﻿USE sofia;
DROP TABLE IF EXISTS sofia.yuj_vpl;
CREATE TABLE yuj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yuj_vpl WRITE;
INSERT INTO yuj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mámá te Jisas Krais yakámp fi mekamp appeyaenápono: Manénkɨr yakámp te Abraham. Tá am feknámp koropea Devit. Tá am fekampao Jisas Krais koropámpon. ");
INSERT INTO yuj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham te Aisakomp naropwar. Tá Aisak te Jekopomp naropwar. Jekop te Juda mwearoamp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Tá Juda te Peres, Seramp naropwar. Am tárápyaramp éntupwar te Tamar. Peres te Hesronomp naropwar. Hesron te Ramomp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram te Aminadapomp naropwar. Aminadap te Nasonomp naropwar. Nason te Salmonomp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon te Boasomp naropwar. Boasomp éntupwar te Rahap. Boas te Obetomp naropwar. Obetomp éntupwar te Rut. Obet te Jesimp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi te King Devitomp naropwar. Devit te Solomonomp naropwar. Maomp éntupwar te wokwaek Yuraiamp yupu yakámp. ");
INSERT INTO yuj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon te Rehoboamomp naropwar. Rehoboam te Abaijamp naropwar. Abaija te Asamp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa te Jehosafatomp naropwar. Jehosafat te Jehoramomp naropwar. Jehoram te Usaiamp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia te Jotamomp naropwar. Jotam te Ahasomp naropwar. Ahas te Hesekaiamp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia te Manasamp naropwar. Manasa te Amonomp naropwar. Amon te Josaiamp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia te Jehoiakin ntia maomp mwearoamp naropwar. Am ke fek táman Babilon mekamp ami koropea Israel fi éréképá tukupea Babilon mek fápákamánki kákapono. ");
INSERT INTO yuj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tukupea am Babilon mek yakápap fekamp Jehoiakin Sealtielomp naropwar. Sealtiel te Serubabelomp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel te Abiutomp naropwar. Abiut te Elaiakimomp naropwar. Elaiakim te Asoromp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor te Sadokomp naropwar Sadok te Akimomp naropwar. Akim te Eliutomp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut te Eleasaromp naropwar. Eleasar te Matanomp naropwar. Matan te Jekopomp naropwar. ");
INSERT INTO yuj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop te Josepomp naropwar. Josep te Mariamp poumarop. Maria te Jisas sámpámpono. Man te ‘Krais’rá sér i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Am te am kear ponankor Abraham feknámpia koropea King Devit yakámp fek te ankár fére-sámpramp kearono. Tá King Devit yakámp feknámpia ponankor koropea Israel fi Babilon mek tukupea fákapá yakáp nap te, ankár fére-sámpramp kearono. Tá Babilon mek fákapá yakáp nap te, ankár koropea Krais yakámp fek te, ankár fére-sámpramp kearono. ");
INSERT INTO yuj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria Jisasén sámpámp kar te ará: Man Josepo sámp naenámpria kar yoroiapon. Aenapan maok, oukoumwan Josepént yak mo nánko, Yiki Kor Spirit yare mek ék nánko, Maria táráp yakánko nkeapon. ");
INSERT INTO yuj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maompor kar yoroinap arop Josep te, yae-párák yakeanámp yupu sámp nae ri námp kwamp, pwar naeria. Aenámpao maok, Maria pwarápae antánoria, man yopor mo, sánánkar porokwe fek pwar naeria nɨnɨk. ");
INSERT INTO yuj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josepo takrá nɨnɨkia kumuruk amprá yém nkenko maok, Kwaromp enselo Josepén sérrá, “Josep, Devitomp ou fekamp táráp e! Amo apápriaka amo sámp nanap yupu Marian pwar kwapono. Amo wawae! Am táráp Mariamp yare mek yak námp te Yiki Kor Spiritao sánk námpono. ");
INSERT INTO yuj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mao poumou-táráp sámp naenámpon. Am táráp sámpeanánko, amo maomp e ‘Jisas’ ri papampo. Am te arak naenámpon: Koumteouráp aropamp kwatae nɨnɨk tirá épériaka am fárákapan warko érékép naenámpon.” Enselo makrá sérimpono. ");
INSERT INTO yuj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Manénkɨr kar Kwaro náráp profetén nɨnɨk sánkánko, profet wawiaka arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Wawenke! Yupu oukoumwan énkirao, táráp yare yakea, poumou-táráp sámp naenámpono. Aenánko maomp e te ‘Imanuelono’rá sér mwanapono.” Am e fi te arakrianono: Kwaro nomont yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josepo am yém nkea pwarará fárámprá Kwar Tokwaeramp enselo man séri námpaok yupu wae fwap sámp. ");
INSERT INTO yuj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Aempao maok, mao te mént yárak mo, akwapea Maria poumou-táráp sámpá yakánko, maomp e ‘Jisas’ ri papámp. ");
INSERT INTO yuj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herot king yakámp ke fek, Maria distrik Judia mekamp taun Betlehem mek Jisasén tankámp. Wae tank nánko, wakmwaek ankwap fi mekamp térmeramp paokop yurukuprá mér i konap arop fárákap yámar aoknámp mwaeknámp taun tokwae Jerusalem mek aokapono. Aokea maok, arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Táráp yink mapek sámpnap Juda firamp king te maok yakáne? Mao koropnámp ke fek yámar aoknámp mwaeknámp térme tokwae wourékam aok námpon. Aenánko yino man lotu mwaria korop námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Heroto am kar wawiaka apápiaka kour me woukoup. Jerusalem mekamp koumteouráp aropao kor apápria kour me woukouriap. ");
INSERT INTO yuj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Heroto pris tokwae fákáre, tá Israel mekamp lo yénkrá farákáp konap arop makiaka ponankor koupoukarea fákeyakrá turunkup, “Krais te mam némpouk korop naenámpono?” ");
INSERT INTO yuj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aeránko maok, am fárákapao man sérrá, “Judia mekamp taun Betlehem mek korop naenámpono. Profet wokwaek kar kumwimp kar makrá sénámpon, ");
INSERT INTO yuj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judamp apár mekamp Betlehem e! Juda mekamp am meknámp arop tokwae koropnap taunrént amo te e tokwaeráp karenono. Nánkárap wakmwaek amo feknámp arop tokwae koropeaka onomp Israel fi taokeyaknámp arop yak naenámpon.’” ");
INSERT INTO yuj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aerapo maok, Herot kánánkámp am koropnap mérnap aropan wumwiria fákeyakrá am fákáreran turunkrá, “Makár am térme tokwae korop námpono?” ");
INSERT INTO yuj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aeria maok, am fárákapan, yumo Betlehem mek tukupenkria tirá kérépria maok, sérrá, “Yumo tukupeaka am táráp fwapnae karia oupourounkia nke kipo. Táte yumo nkea nap kwamp te, yumo koropea onan sénapo, ono kuri akwapeaka man lotu nanampono.” ");
INSERT INTO yuj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aeránko maok, kingomp kar wawiaka man pwarará wae tukup. Tukup napo, am térme tokwae manénkɨr yámar aoknámp mwaeknámp aokánko nkeap támao, mekia akwap nánko, wakmwaek tukup napo, táráp tanknámp nap fununként yámar mek yakámp. ");
INSERT INTO yuj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Am fárákapao térme nkeaka warákára wae. ");
INSERT INTO yuj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aea maok, nap mek yinkea, táráp ntiaka éntupwar Marian nkea maok, kwaráp torokomprá apárok me pékéria, am tárápan lotu. Aeria maok, am fákárerao paus aokor-aokoria maok, man mani tokwae fekamp ankank nénkap te gol, paura nánákáre yankap konap, sanda kwapwe kare, makia nénkapono. ");
INSERT INTO yuj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Takia napo maok, Kwaro am fárákapan yémén sérrá, “Yumo te warko Herotonámpok tukup kwapono.” Makrá sérámpantá maok, am fákárerao ankwap mwae-porok námokuráp némpouk tukupapono. ");
INSERT INTO yuj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Takia tukupapo maok, wakmwaek Kwaromp ensel kumuruk yémén Josepén sérrá, “Herot te am táráp oupourounkia porokwap pap naereane. Amo fárámprá táráp koumte éréképrá Isip mek farákapea akwapae. Amo Isip mek yak napo, nánkár ono warko amwan sénanko, korop nanapono.” ");
INSERT INTO yuj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kwaro aerá séránko maok, Josepo ankár am kumuruk táman fárámprá táráp sérar éréképea Isip mek akwapá yakrá akwapea, Heroto wae sumpwi. ");
INSERT INTO yuj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Am ke fekimp te Tokwae Karao profetomp top kor fek sérimp kar mént pwi námpono. Mao sérrá, “Onomp poumou-táráp Isip mek yak námp wumwi nanko, korop naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heroto am yámar aoknámp mwaekamp mér tokwaeráp aropan, yumo Judamp kingén lotuia pwararea, warko koropea onan sér kipria yépék. Yépékrá yak nánko, námwan yankar séri nap wae méria yonkwae pwarámp. Mao am yámar aoknámp mwaekamp mér i konap aropan térme nkea sériap ke táman nɨnɨk. Aeria, arop ankwap fárákap Betlehem mek tirá kérépria maok sérrá, “Yumo tukupeaka Betlehem mek, tá am fekmwaek némp wonae fik yak námpan oupourounkrá, poumou-tárápu ponankor oukoumwan yinɨnk yopwar monap fupukrá kákenke.” ");
INSERT INTO yuj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Am tak nap te, Kwaro profet Jeremaian sánkámp karao kare korop námpono. Am te arakrá sérimpon: ");
INSERT INTO yuj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Wa napo, Rama mek éménka waeria yonkwae fi. Am te Resel náráp tárápuantá ém nánko, koumteouráp arop fárákap man yonkwae porokwe pap mwanap pourou mono. Waeman maomp tárápu te ankwap yiki yak mono, ponankor kar fupukrá kák napono.” ");
INSERT INTO yuj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wakmwaek Herot wae sumpwi tenánko maok, Kwaromp enselo kumuruk Josepén Isip mek yém sérrá, ");
INSERT INTO yuj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Am arop fákáre táráp porokwap pap mwaria nap te wae surumpwi tenape. Amo fárámprá waráp táráp koumte éréképea warko arákarrá Israel fi mek akwapampo.” ");
INSERT INTO yuj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aenko maok, Josep wae fárámprá táráp koumte éréképrá Israel fi mek tukupapono. ");
INSERT INTO yuj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Josep Isip meknámp koropánko maok, arakrá sér, “Arkelaus te maomp naropwar Heroto apár Judia mek king yakámp éri mek warko mao king yakáne.” Makrá sérapo maok, Josep apápiaka ampok akwap mo. Aenko maok, Kwaro kumuruk Josepén yém sénámpantá maok, warko am feknámp distrik Galili mek akwapeaka, am mekamp taun Nasaret mek yak. ");
INSERT INTO yuj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tá taknámp, profeto sériap kar mént pwi námpono. Mao sérrá, ‘Man te Nasaret mekamp aroprá mwanap’rá sérimpono. ");
INSERT INTO yuj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Warko wakmwaek arop ént mek nérrá kák naenámp Jon koropea distrik Judia mek arop yak mo apár mek yakrá koumteouráp aropan kar farákápria arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Yumo kwatae nɨnɨk te ankár younkwe mwaek sɨrarrá Kwaronámpok koropenke! Kwaro náráp firáp taokeyak naenámp te waeman wonae fik korop námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Am Jon te wokwaek Kwaro profet Aisaian nɨnɨk sánkánko sérimp arop támaono. Mao arakrá sér, “Arop yak mo apár meknámp arop ankárankao wumwia sérrá, ‘Tokwae Karao korop naenámp mwae nánapria fwapokwapenke! Mao korop naenámp mwae kup korokorenámp ékékérrá párakopenke!’” ");
INSERT INTO yuj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mao te waempyam kamel pwae fek yoroi napan yirɨmpea amore mek let fákap te konámpono. Aeria mao te yao pwae mekamp tákár ntia éntu éntan saráp fárimpon. ");
INSERT INTO yuj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","6","Am ke fek táman kápae kare arop Jerusalem mekamp, tá kápae kare Judia mekamp, tá ént Jordan fik mwaekamp Jononámpok koropea náráp kwatae nɨnɨk farákáprá sénapo, Jono am arop fárákapan ént Jordan mek nérrá kákámpon. ");
INSERT INTO yuj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aeria Jono nke nánko, kápae kare Farisi fákáre ntia Sadyusi fákáre ént mek nér mwaria korop napo maok, mao am fárákapan sérrá, “Yumo kwatae kare arop yumo te tákam-ti kwatae niampon! Yumo yiráp kwatae nɨnɨk taki fákeyakápria ént mek néria napo, Kwaro yumwan yopor mo naenámpria nape? ");
INSERT INTO yuj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Táte yumo yae-párák kare paokop nap fek kwatae nɨnɨk younkwe mwaek sɨrarrá Kwaronámpok korop nap érik yénképano. ");
INSERT INTO yuj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tá yumoku kok sérarrá, ‘Yino Abrahamomp ou fekamp tárápuara, yinan Kwar te yopor mo, fwap naenámp’ an mpwe kwapono. Aerá sénapan maok, ono yumwan sénampon: Kwaro yumwan wampwe kwaeri pwarará, fwap mapekamp mámá yumwi kápae karean Abrahamomp tárápu yororá kák naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ankomwar wae yao karámp naenámp nánapi yak námpono. Yao ponankor kwapwe kare ki tank mo i konámp te, kar-tokopea yaomwi mek épér mwanapono. ");
INSERT INTO yuj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ono yumwan ént fek nérrá kák namp te, yumo wae kwatae nɨnɨk younkwe sɨnapan yénkép námpon. Aeno arop wakmwaek korop naenámp te, yumwan Yiki Kor Spirit ntia yaomwi fek nérrá kák naenámpon. Maomp kárákáre te onomp kárákáreran kámákár akwap námpon. Ono te apárok kánanke kare nampara, maomp su samp nanamp pourou mo nampon. ");
INSERT INTO yuj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mao námokuráp sabol yaek sayakrá wit yorokwaerá narek épér nánko, ouwirao tɨri amwar poporokomprá, námokuráp wit kare wit koupoukour konap nap mek kákea pwarará, tɨri te ankár torokwar mo i konámp yaomwi mek yank naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aenánko am ke fek táman Jisas apár Galili pwarará ént Jordan mek akwap. Mao Jononámpok akwapea maomp yaeknámp ént mek anámp naeria. ");
INSERT INTO yuj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aenánko maok, nopok Jono man taokarrá sérrá, “Nopok amo maok onan ént mek anámpá papae. Amo te mokopia ononampok korop napono?” ");
INSERT INTO yuj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tá nopok Jisaso man sérrá, “Fwapono. Amo ono sénampaok napo, Kwaro arop warko érékép naenámp nɨnɨk ponankor pwi yakano.” Aeránko maok, Jono wae Jisaso sénámpaok. ");
INSERT INTO yuj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisas wae ént mek anámpea koupour kar forokor tará aokrá kárák fek fokopeyakrá yámar mek nke nánko, yámar mek fákárámp akwap nánko, Kwaromp Yiki Kor Spirit ant yuri niamp arákarea ékia Jisasomp pourouk tank. ");
INSERT INTO yuj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aenánko yámar meknámp arop kar niampao wumwiria sérrá, “Támáte onomp tárápono. Ono man warákár tokwaeria ono man nke namp te, kwapwe kare námpono.” ");
INSERT INTO yuj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Am ke fek táman Satano Jisasén poupwekápanoria, Yiki Kor Spiritao Jisasén warámpea arop yak mo apár mek sakwapá pwar. ");
INSERT INTO yuj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aenánko Jisas fɨr fár monámp yae te, yiawor fére-sámpramp yámar ntia kumur yakria, mao mwae touwe tokwae. ");
INSERT INTO yuj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aenánko man poupwekáp naenámp arop wae koropea sérrá, “Amo Kwaromp tárápao nap kwamp te, má tankápnámp yumwi má sénapo, pan arákár nánko fárae.” ");
INSERT INTO yuj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aenánko maok, nopok Jisaso man sérrá, “Kwaromp Buk fek te arakrá sénámpon, ‘Fɨr támao mwar te aropan yiki yak sánk mono. Arop Kwaromp Kar sámp námpao maok, yiki yak sámp konámpon.’” ");
INSERT INTO yuj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aerá sénánko, Satano warko Jisasén warámpá akwapea Kwaromp yiki kor taun tokwae Jerusalem mekamp lotu nap tokwae yumuntuk narekamp wi fek páte yakrá ");
INSERT INTO yuj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","man sérrá, “Amo Kwaromp Tárápao nap kwamp te, amo apárok far-kɨrékapae. Kwaromp Buk fek arakrá sénámpon: ‘Mao náráp ensel fárákapan sénánko, amwan yaewourria, mao fwap amwan náráp yaek sampɨká apárok pap napo, amwan yumwirao pu kwae mek párákap mo, fwapono.’” ");
INSERT INTO yuj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nopok Jisaso man sérrá, “Kwaromp Buk fek ankwap kar sénámpon: ‘Amo waráp Kwar Tokwae Karan poupwekápi kwapono.’” ");
INSERT INTO yuj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tá warko Satano Jisasén warámpá pokea narek faonkwe tokwae fek yakria, apár fi tokwae ponankor ntia am mek yakápnámp ankank ponankor yénkria sérrá, ");
INSERT INTO yuj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Amo onan kwaráp torokomprá me kor woukouprá lotu napo te, mámá kápae kare ankank máte amwan sánk nanampon.” ");
INSERT INTO yuj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aerá sénánko, nopok Jisaso man sérrá, “Satan, amo nkwampok akwapae! Kwaromp Buk fek sérrá, ‘Amo ankár waráp Kwar Tokwae Kar ankárankan saráp loturia ankár maomp térean saráp téreampo’rá sénámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aeránko maok, Satan wae Jisasén pwarará akwap nánko, ensel fárákap koropea Jisasén yaewouriapon. ");
INSERT INTO yuj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Am ke fek Jisaso wa nánko, ‘Jonén kalabus mek fákapá pap nap’rá sénapantá, mao distrik Galili mek akwap. ");
INSERT INTO yuj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Akwapea taun Nasaret mekia akwapeaka Kaperneam mek yak. Am Kaperneam te ént aokore fek apár Sebulun ntia Naptali fi yaknámp mwaek yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mao tak námp te waeman Aisaia wokwaek sérinámp kar méntér pwi námpon. Mao sérrá, ");
INSERT INTO yuj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulun fi ntia Naptali fi mwaek ént aokore fek akwapnámp mwaeaok akwapea Jordan mek ankwap arop fárákapan distrik Galili mek koumteouráp arop kɨrɨkɨp mek tankápria wae tokwae nke napono. ");
INSERT INTO yuj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Am koumteouráp arop fárákap sumpwi mwanap kɨrɨkɨp tokwae mek tankáp napo, am fárákapaonapok wae tokwae korop námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Am ke feknámpia Jisas wae kar farákápria mao sérrá, “Yumo kwatae nɨnɨk wae pwarenke! Kwaro maomp firáp taokeyaknámp te wae wonae fik korop námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisaso ént Galili aokore firi akwaprá nke nánko maok, Saimon Pita ntia Andru mwear ént aokore mek umben sɨrarrá yak. Am arop yawor te takrá éntékam ti ko am fek mani sámp konepono. ");
INSERT INTO yuj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisaso am arop yaworan sérrá, “Yumo onomp wakmwaek koropenke! Ono yumwan Kwaronámpok arop éréképá korop nenep yénkép nae.” ");
INSERT INTO yuj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aeránko maok, am arop yawor koupour kar umben fekamp tére pwarará Jisasomp wakmwaek akwapepono. ");
INSERT INTO yuj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Takia akwaprá ankwap ke fek nke nánko, Sebedimp táráp Jems ntia maomp nánae Jon, tá maomp naropwar Sebedi makia bot mek yakáprá náráp umben me aompoprá fwapokwaprá yakáp. Aenapo Jisaso am arop yaworan wumwi nánko, ");
INSERT INTO yuj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","am arop yawor náráp bot ntia naropwar pwarará Jisasomp wakmwaek akwapepono. ");
INSERT INTO yuj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Mao akwapea Galili mekamp kápae kare némpouk mwaek yárakrá koumteouráp aropan lotu nap mek kar yénkrá farákáp. Mao Kwaro náráp firáp taokeyak naenámp Kwapwe Kare Kar farákápria, arop fárákapamp pouroukamp nkwakwe make touwe fwapokwaprá kákámpon. ");
INSERT INTO yuj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mao takrá térenámp kar sérarrá tukupea apár Siria mek mwaekamp ponankor némpouk. Aenapo maok, am mekamp kápae kare arop nkwakwe make touwe sámpnap arop, tá pourou mek touwe tokwae sámp nap arop, tá kwatae-aropao pourou mek noumpoukoup námp, tá arop apárok pɨká párákaprá kour me woukoupa wae konap arop, tá kour ponankor surumpwinámp arop fárákap, am ponankor Jisasomp wonae fik éréképá korop napo, Jisaso am fárákapan fwapokwaprá kákámpono. ");
INSERT INTO yuj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aenánko kápae kare koumteouráp arop Galili mekamp, tá Dekapolis mek mwaekamp, tá Jerusalem mekamp, Judia mek mwaekamp, Jordan ankwapmwaek fik mwaekamp, am fárákap nke mwaria Jisasomp wakmwaek tukupapon. ");
INSERT INTO yuj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisaso am kápae kare koumteouráp arop táman nkea ankwap faonkwe fek poká tank nánko, mao éréképá yárak i konámp arop fárákap maonámpok korop. ");
INSERT INTO yuj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Aenapo, Jisaso am fárákapan arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Am arop fárákap, Kwaromp nɨnɨkan mér mwanámp pwi moianrá nɨnɨk napan te, Kwaro ourour nénk naenámpon. Mao te Kwaro náráp firáp taokeyak naenámp mek yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tá arop fárákap éménkrá yakáp napan te, Kwaro ourour nénk naenámpon. Am ourour te ará: Mao fwap am fárákapamp nɨnɨk kwapwe karerá kák naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Arop fárákap námokuráp e anámprá sánánkar yakáp i konapan te, mao ourour nénk naenámpon. Am ourour te ará: Mao ‘Am fárákapan kápae kare ankank nénk nanamp’rá sérinámp ti mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Arop fárákap Kwaromp nɨnɨkaok akwap nae kar kɨkiankria fɨr fánae kar námp niamp, tá éntan nɨkɨp námp niamp námpan te, Kwar ourour nénk naenámpon. Am ourour te ará: Mao am fárákapamp nɨnɨk mek pwirá kák naerámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tá arop fárákap arop ankwap fárákapan aropomp napan te, Kwaro ourour nénk naenámpon. Am ourour te ará: Mao nopok am fárákapan aropomp naerámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Arop fárákap maomp nɨnɨk yiki kukarrá yakáp napan te, Kwaro ourour nénk naenámpon. Am ourour te ará: Am fárákap fwap man nke mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Arop fárákap arop ankwapao yoporrá yorowar napo, taki kwaponoria yonkwae porokwe pap napan te, Kwaro ourour nénk naenámpon. Am ourour te ará: Mao am fárákapan ‘Yumo te onomp tárápuno’rá sénaenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Arop fárákap yae-párák kare nɨnɨkaok tukup nap fek, aropao touwe kwatae sánk napo te, Kwaro am fárákapan ourour nénk naenámpon. Am ourour te ará: Am fárákap te Kwaro náráp firáp taokeyaknámp mek yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Táte arop fárákapao yumwan nke napo, yumo ononampaok napo, am fek yumwan wouroump kar sérarrá yumwan sámpá yampourourá, nkwakwe make kwatae kar kwekárrá sérar napo te, Kwaro yumwan ourour nénk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yumo fwapono, yonkwae kárámprá warákárrá yakáp kip. Yumo nopok sámp mwanap ankank tokwae te yámar mek tank námpon. Yumwan am tak nap te, wokwaek profet fákáreran mékɨr sámpá yampourouiap táman napon.” ");
INSERT INTO yuj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tá Jisaso ankwap kar arakrá sér, “Yumo onan éntér papnap arop fárákap yumo te oukwerao napenámp niampon. Aeno táte oukwe nape konámp pwar nánko te, nomo mokopianánko am oukwe warko nape naenámpon? Taknámp oukwe te warko nape naenámp pourou mo námpara, arop fárákapao apárok wakár-sɨtenapo, arop am fek pumpur i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yumo te apárokamp wae niampon. Némp narek faonkwe wi fek yak námp te, am fekamp yaomwi wae te mek wouroumpeyak mo i konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tá arop lam pounkouroupea te, tap woukwapá pap mo i konapon. Ankár narek kákánar fek páte napo, am nap mek yakápnap arop fárákapan wae sánk konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Táte taknámp yiráp waerao kor koumteouráp arop nke nap fek wae kwapwe nánko, am fárákapao yumo kwapwe kare nɨnɨk nap nkea am fárákap fwap yámar mek yaknámp yiráp Naropwaromp e narek sampok mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tá Jisaso ankwap kar arakrá sér, “Yumo te ono lo ntia profet fákáreramp kar sámp-sɨnaeria ék nampan mpwe kwapono. Ono te am táman tirá épér mono. Ono korop namp te pwi kare pap nanampria korop nampono. ");
INSERT INTO yuj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ono yumwan kare kar sénampon: Nánkárap mokopia yámar ntia apár pwar námpon kor, lo kar ankwap kánanke moyak mono. Ankár lo te taki yakrá akwapea am kápae kare ankank loao sénámp korop naerámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aeno táte arop lo kar ankwapmwaek kánanke wae sɨr konámpao, arop ankwapan kor, take pourouráp nɨnɨk fek yénk námp te, maomp e te Kwaromp firáp arop yakáp nap mek te kánanke kwarok námpon. Aeno arop lo karwaokria, koumteouráp aropan kor ‘Mántwaokenk’ ria farákáp námp te, maomp e te Kwaromp firáp arop yakáp nap mek tokwae kari yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ono waeman yumwan sénampon: Yiráp Kwaromp karwaok nɨnɨk kwapwe, lo yénk i konap arop ntia Farisi fákáreao i konap nɨnɨkan kámákár akwap mo námp te, yumo Kwaromp firáp mek yakáp mwanap pourou mo karenono.” ");
INSERT INTO yuj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tá Jisaso ankwap kar arakrá sér, “Am lo kar wokwaek yiráp appeyaenáp sámpap te yumo wae wawi napono. Am te arakrá sénámpon: Amo arop sámp-wouroump kwapono. Tá arop ankwapao arop sámp-wouroump námp te, mao te ankár kot naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Aeno ono yumwan sénampon: Arop náráp ankwapnápén yoporianámp te, mao te kot naenámpon. Tá arop ankwap náráp ankwapnápén wouroump kar sénámp arop te, mao te Juda Kaunsil fákáre ou mek kot naenámpon. Tá arop ankwap ankwapao pwarápae tokwae sámp naenámp kar sénámp te, Kwaro man yaomwi mek sɨnaenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ae naenámpara, amo waráp ofa lotu nap tokwae mek Kwarén sánk naeria sakwap napao, amo waráp ankwapnáp amo maninapan nɨnɨk tokwaenámp nɨnɨk nap kwamp te, ");
INSERT INTO yuj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","amo ankár waráp ofa alta wonae fik pátará, manénkɨr akwapea waráp ankwapnápént amo aminap kar fwapokwapampo. Amo fwapokwapia pwarará maok, amo warko akwapea waráp ofa Kwarén sánkampo. ");
INSERT INTO yuj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Táte arop ankwapao amwan kot naerianánko te, yumo oukoumwan mwaeaok akwap nep fek táman amo koupour méntér kar fwapokwapampo. Takria amwan am aropao kot i konámp aropamp yaek pap nánko, kot i konámp aropao amwan plismanomp yaek pap nánko, amwan plismano yae-souwe fákapea kalabus nap mek papantáno. ");
INSERT INTO yuj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ono amwan kare sénampon: Amo ankank ponankor manénkɨr nopok sánk moia te, amo kalabus nap te pwar akwap mono.” ");
INSERT INTO yuj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tá Jisaso ankwap kar sérrá, “‘Ankwapamp yupurént, poumaropént kokopori kwapono’rá sénámp te wae wawi napon. ");
INSERT INTO yuj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Táte ono yumwan sénampon: Arop ankwapao yupu ankwapan yi fek saráp nkea, man kɨkiank námp te, waeman maomp nɨnɨk mek te wae méntér kokopor námpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Takria te, waráp yirao amwan kwatae nɨnɨk mek sámpá akwap nánko te, amo ankár am yi wurukupea sɨrampo. Yae-párák am taknámp pourou ankwapmwaek moyak nánko, amo fwap waráp pourou ponankor yaomwi mek pɨk mo naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Táte amo waráp yae-párák mwaek yae koranánko, kwatae nɨnɨk mek pɨká párákap nap kwamp te, amo ankár am yae kor karámp-tákapea sɨrampo. Am pourou ankwapmwaek ták-sɨrarea napo maok, fwap waráp pourou ponankor yaomwi mek pɨk mo naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tá Jisaso ankwap kar arakrá sér, “Wokwaek te arakrá sér i konapono: ‘Arop ankwap náráp yupu pwar naerámp kwamp te, ankár am yupu pwar konap pepa kumwia man sánkea pwar naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aenámpan maok, ono yumwan sénampon: Aropao náráp yupu arop ankwapént kokopor mo námpan kwaporok pwar nánko, akwapá ankwap nap mek tank námp te, am arop támao nánko, am yupu poumou nap mek tank naenámp lo kwe-pwararea kokopor námpon. Tá taknámp, arop ankwap poumaropao pwate nánko yaknámp yupu sámp námp te, mao kor poumou nap mek tanknámp loan kwe-pwararea kokopor námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jisaso ankwap kar arakrá sér, “Tá ankwap kar appeyaenáp fákárerao sámpap yumo wokwaek wawi nap te ará: ‘Amo ankwap ankankan “Kare kar narekamp ankankráp tak nanamp”rá sénap kwamp te, kwekária pwar kwapono. Amo ankár Kwar Tokwae nke námp fek am sérinapaok taknámp karampo.’ ");
INSERT INTO yuj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aean maok, ono yumwan sénampon: Yumo ‘Narekamp ankankráp’rá séri kwapono. Ankár mo karono. Yumo kar ankwap fou e séria ‘Yámar me’ séria, am fek fou e séri kwapono. Am te Kwaro am fek tank námp támaono. ");
INSERT INTO yuj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yumo ‘Mámá apár’ séria, am fek fou e séri kwapono. Am te Kwaro tankria am fek pu pátea tank námp támaono. Tá yumo ‘Taun Jerusalem’ séria, am fek fou e séri kwapono. Am Jerusalem te King Tokwaeramp taun nono. ");
INSERT INTO yuj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tá amo waráp yépe kor séria am fek fou e séri kwapono. Am te amo me pwae ankwap wupwi pap, tá yákáre pap nanap pourou mono. ");
INSERT INTO yuj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aeno am take pourouráp kar farákáp nap te, Satano nénk námpon. Yumo ankár ‘Yeno’rá sér, tá ‘Mono’rá sénap te, wae támaono.” ");
INSERT INTO yuj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tá Jisaso ankwap kar arakrá sér, “Wokwaek arop fárákapao arakrá sérap yumo wae wawiapon: ‘Arop ankwapao waráp yi porokwapá koraokop nánko te, nopok kor am aropamp yi porokwapá koraokopampo. Tá arop ankwapao waráp yu kor porokwapá kɨrɨkɨp napo te, nopok kor am aropamp yu kor porokwapá kɨrɨkɨpampo.’ ");
INSERT INTO yuj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aerá séri napan maok, oukoumwan te ono yumwan sénampon: Arop yumwan kwatae sokoro napo te, nopoki kwapono. Arop ankwap waráp wapra kor fek porokwap nánko te, amo ankár sámp-arákarrá ankwapmwaek wapra kor sánkampo. ");
INSERT INTO yuj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Táte arop ankwap amwan kotria waráp siot sámp naeria nánko te, amo waráp saketan kor man sánkampo. ");
INSERT INTO yuj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Táte ami mekamp arop ankwapao amwan, náráp kápae sámpea, mwae kup ankárankamp kilomita fek akwapaeria kárákáre nánko te, amo ankár méntér akwapea mwae kup anánk kilomita fek yárakampo. ");
INSERT INTO yuj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Táte arop ankwap amwan ‘Ankank sápae’rá sénánko te, amo ankár man sánkampo. Táte arop ankwap ‘Amwan nánkár nopok sánk nanampan sápae’rá sénánko te, man monoria younkwe sánk kwapono.” ");
INSERT INTO yuj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Tá Jisaso ankwap kar arakrá sér, “Wokwaek arop fárákapao arakrá sérap te yumo wae wawi napon: ‘Amo ankár waráp nouroupén saráp warákárria waráp yopor aropan te kokwarokampo.’ ");
INSERT INTO yuj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aerá sériapan maok, oukoumwan te ono yumwan sénampon: Yumo ankár yiráp yopor aropan kor nouroupria, yumo ankár am arop fárákap yumwan sámpá yampourou nap ‘Man yaewourampo’ ria Kwarén sér kipo. ");
INSERT INTO yuj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Takria maok, yumo te yiráp yámar mek yaknámp Naropwaromp tárápu kare yakáp mwanapon. Mao te kwatae aropan kor yaewour, tá kwapwe kare aropan kor yaewourria yámar yokwap naenámpria narek pap námpon. Tá yae-párák karenap aropan kor yaewour, tá yae-párák monap aropan kor yaewourria warákam sámp-kérép konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Táte yumo arop yumwan nouroup napan saráp nouroup nap te, yumo am fek nopok apae sámp mwanapon? Takis sámp konap arop fárákapao kor waeman tak i konapon. ");
INSERT INTO yuj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Táte yumo yiráp ankwapyaenápén saráp ‘Gude’rá sénap te, yumo apae ankank fek arop ankwap fárákapamp nɨnɨk kwapwe kámákár tukup napon? Kwarén mér monap arop fárákapao kor waeman tak i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yumo ankár yámar mek yaknámp yiráp Naropwar yae-párák kare yak námpnámp taknámp yumo kor yiráp nɨnɨk mek yae-párák kare yakáp kipo.” ");
INSERT INTO yuj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tá Jisaso ankwap kar arakrá sér, “Yumo mér kipo: Yumo aropao ‘Náráp kwapwe kare nɨnɨk nkeanápono’ ria, mao érik nke nap fek saráp arop yaewouri kwapono. Yumo takria te, yiráp yámar mek yaknámp Naropwaromp yaekamp nopok sámp mono. ");
INSERT INTO yuj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Táte amo ankank monámp aropan ankank sánk naeria te, am ‘Námo ankank nénk namp koropá nkeanápono’ ria karmékɨr sérarrá yáraki kwapono. Am te kwekár i konap aropao lotu nap mek mwaek, tá mwae kupuk mwaek takrá paokop i konap niampono. Am fárákap tak nap te arop fárákapao náráp kwapwe kare nɨnɨk nkea náráp e sakap mwanapria napon. Ono yumwan kare kar sénampon: Taknap arop fárákap te waeman nopok kor sámp nap támaono. Kwaro man ankwap mént tapokwap mono. ");
INSERT INTO yuj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Táte amo ankank monap arop fárákapan yaewour nae nap kwamp te, waráp yae-mánkwan mwaekamp yae te yae-párák mwaekamp yaerao sánk námp te mér naeane. ");
INSERT INTO yuj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tak napo maok, waráp aropomprá tére nap sánánkar mek yak naenámpon. Waráp Naropwar te ankank mek yak námp nke konámpara, mao fwap nopok amwan sánk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tá Jisaso ankwap kar arakrá sér, “Yumo Kwarén kar toropwap mwaria te kwekár arop fárákapao i konapnámpi kwapono. Am fárákap te aropao ‘Námwan nkeanápono’ ria lotu nap mek, tá arop koupoukour konap nap mek yakáprá Kwarén kar toropwap mwar kar kɨkiank i konapono. Ono yumwan kare kar sénampono: Am arop fárákap oukoumwan waeman nopok sámp napono. ");
INSERT INTO yuj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aeno amo waráp Naropwar Kwarén kar toropwap naeria te, amo ankár waráp nap aokore mek youmpea ménki kéri pwatea waráp Naropwar mek yaknámp man kar toropwapampo. Waráp Naropwar te ankank mek yak námp nkea mér námpara, amwan fwap nopok sánk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nánkár yumo kar toropwapria te kwaporok kápae kare kar mwar tokwaeri kwekár kwarén lotu i konap arop fárákapao i konap niamp fek séri kwapono. Am fárákap te ‘Yino kápae kare kar sénánko maok, Kwaro yinan fwap am ankank sáp naenámp’rá nɨnɨkria ni konapono. ");
INSERT INTO yuj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yumo te am fárákapao i konap nɨnɨkaok tukup kwapono. Yumo oukoumwan Kwarén sér mo nap fek, yumo monap kápae kare ankank te mao wae méri yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yumo ankár arakrá kar toropwap kip: ‘Yámar mek yak konámp yinomp Naropwar e! Waráp e te ankár yiki kare yakano. ");
INSERT INTO yuj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tá waráp firáp taokeyaknap ke ankár koropano. Waráp térenap arop yámar mek waráp nɨnɨkaok tukup napnámp taknámp, yino kor ponankor apárok mapek ankár waráp nɨnɨkaok tukup mwanámpono. ");
INSERT INTO yuj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amo yinan mámá yae fek fɨr fár mwanámp pwi naenámp sápampo. ");
INSERT INTO yuj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yino yinan aropao kwatae napo, maomp kwataenap nɨnɨk nɨk mo, pwar námpnámp taknámp, amo kor yino amwan kwatae nɨnɨk námp nɨk mo pwarampo. ");
INSERT INTO yuj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amo yinan mokop nap nke naerianámp ankank kwatae mek párakop kwapono. Amo yinan Satanomp kwataenámp ankank mekamp éréképrá fwapnae mwae párakopampo.’ ");
INSERT INTO yuj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yumo wawenk! Yumo arop ankwap fárákapao yumwan napo te, yumo am fárákapamp kwataenap nɨnɨk nɨk mo pwar kip. Yumo tak napo maok, yumo yiráp yámar mek yaknámp Naropwarén kwatae nɨnɨki napan kor, mao am tirá épéria nɨk mo pwar naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aeno táte yumo arop ankwap fárákapao yumwan napo, maomp kwatae nɨnɨk nɨk mo pwar mo napo te, yiráp Naropwaro kor yumo man kwatae nɨnɨk nap tirá épéria nɨk mo pwar mo naerámpono.” ");
INSERT INTO yuj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tá Jisaso ankwap kar arakrá sér, “Yumo Kwarén fwapnae karia sér mwaria fɨr wuri nap kwamp te, kwekár aropao i konap niampia paokopi kwapono. Am fárákap te ‘Nomwan arop fárákapao “Fɨr wuri napon”rá wuri nkea méranápono’ ria éntupia me pwae fárákap moitea paokop i konapono. Ono yumwan kare kar sénampon: Am taknap arop fárákap te aropao waeman oukoumwan am aropamp e sámpea narek sampok napo, nánkár Kwaro maomp e narek sampok mono. ");
INSERT INTO yuj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aeno yumo Kwarén sér mwaria fɨr wuri nap kwamp te, yumo ankár warákárnámp aropamp yimetáp niamp fek paokop kip. ");
INSERT INTO yuj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yumo tak napo maok, arop fárákapao kor yumo fɨr wuri nap am wuri nke mo mwanapon. Yiráp Naropwar mek yak námp mao mwar fwap mér námpara, ankank mek yak námpan nkea nopok sánk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tá Jisaso ankwap kar sérrá, “Yumo mámá apárok mapek yiráp kwapwe kare ankank kénkrá kákrá yakápi kwapono. Mámá apár mek te sárárao fánánko, tá sorok woukouria turupwi konámpono. Tá arop ankwap fárákap nap far párámpea ankank oukun ti konapono. ");
INSERT INTO yuj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aeno yumo yumokuráp ankank kwapwe kénkrá kák mwaria te, yámar mek maok kénkrá kák kipo. Yámar mek te sárár ntia sorokao ankank fépéránko, turupwi mo, tá oukun aropao kor nap far párámpeaka, oukun ti mo, fwapono. ");
INSERT INTO yuj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Am waráp kwapwe kare ankank yaknámp némpouk te, waráp nɨnɨkao kor am némpouk yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Tá Jisaso ankwap kar arakrá sér, “Yi te pourou mekamp lam niampon. Táte waráp yi kwapwe kare námp te, waráp pourou ponankor wakor wae niampon. ");
INSERT INTO yuj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aeno táte waráp yi kwatae námp te waráp pourou ponankor kɨrɨkɨp námpon. Aenámpara, táte waráp pourou mek yaknámp lam kɨrɨkɨp nánko te, am kɨrɨkɨp akwapea tokwae kar naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tá Jisaso ankwap kar arakrá sér, “Arop ankárankampao anánkaopwe arop tokwaeramp tére naenámp mono. Mao am takria te, ankwap arop tokwaeran kokwarokria, ankwapan saráp warákár naerámpon. Tá ankwapamp karwaokria ankwapan younkwe sánk naeria námpon. Yumo te Kwaromp yae ankore mek yakáprá, maniamp yae ankore mek méntér yakáp mwanap pourou mono. ");
INSERT INTO yuj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Aenámpara, ono yumwan sér rae: Yiráp pourouan nɨnɨk tokwaeria ‘Nomo fɨr te apae fár mwareano, maokamp ént fár mwareano?’rá séri kwapono. Tá yiráp pourouk waempyam yirɨr mwanapan nɨnɨk tokwaeria ‘Maokamp waempyam sámpea yirɨr mwareano?’rá séri kwapono. Yiráp yiki yakáp nap te waeman fɨran kámákár akwap, tá yiráp pourouao kor waempyaman kámákár akwap námpon. ");
INSERT INTO yuj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yumo antan nkenke. Mao te yopwar mek fɨr yoro moria, fɨr nap mek tirá koupoukour mo i konapono. Ae konapan maok, yiráp Naropwar yámar mek yak námp mao támao am antan fɨr nénk konámpono. Aeno arop yumo te tokwae karara, Kwaro yumwan waeman mér námpon. ");
INSERT INTO yuj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tá yumo mekamp te wa taknámp nɨnɨk tokwae fek fwap námokuráp yiki yak naenámp ankwap ke kɨrɨmprá pap naenámpon? Am te tak mwanap pourou mono. ");
INSERT INTO yuj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yumo apaeritea waempyam ankankantá nɨnɨk tokwae rap? Yumo yao fu émémi ‘Mokope pourouráp yakáp nap’rá nkenke! Mao te térea waerá waempyam wour mo i konapon. ");
INSERT INTO yuj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Aeno ono yumwan sénampon: Wokwaek Solomono kápae kare mopor kákámpan maok, maomp mopor te am yao fu kwapwe kare niamp take mono. ");
INSERT INTO yuj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yao fu oukoumwan yopwar mek yakeanámp te, oumpouran arop fárákapao am fárákapea yaomwi mek sɨr mwanapono. Am yao fu mwar wuriman, Kwaro mopor kwapwe pap konámpon. Aeno yumo koumteouráp arop yiráp mér te kánanke kwarokono. Yumo fwapia mérenke: Yumo yiráp yirɨr i konap ankank mo námpan kor, Kwaro fwap yumwan taokeyak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yumo te nɨnɨk tokwaeria arakrá séri kwapono, ‘Nomo fɨr apae fár mwareano, ént apae fár mwareano, waempyam yirɨr mwareano?’rá nɨnɨki kwapono. ");
INSERT INTO yuj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Am te Kwarén mér monap arop fárákapao yonkwae sékérrá kápae kare ankankantá takrá oupourounk i konapono. Aeno yiráp Naropwar yámar mek yak námp te yumo ankár am kápae kare ankank fwap takrá ti mwanapria méri yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Aenámpan maok, Kwaro náráp firáp taokeyak konámp ntia maomp yae-párák kare nɨnɨk te manmékɨr oupourounkia nke kipo. Yumo tak napo maok, nánkár mao fwap yumwan am kápae kare ankankan kor nénk nae-námpon. ");
INSERT INTO yuj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aenámpara, yumo oumpouran mank te nɨnɨk tokwae kwapono. Oumpouran mank te nánkár oumpouran táman nɨnɨk mwanapono. Yumo oukoumwan mámá yae fekamp yumonapok koropnámp nɨnɨk tokwae te mámá yae fek saráp támaono.” ");
INSERT INTO yuj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tá Jisaso ankwap kar arakrá sér, “Yumo te arop ankwapao kwatae nɨnɨk námpan yurukupia man ‘Mao te kwataenámp’ ria wouroumprá séri kwapono. Yumo takia napo te, yumwan kor Kwaro yurukupia ‘Kwataenap arop’rá sénaeane. ");
INSERT INTO yuj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yumo mokope pourouráp nɨnɨk fek arop ankwapan yurukupia yoporia napo te, Kwaro kor yumwan take pourouráp fek yurukupia yopor naeane. Yumo aropan mokope pourouráp nɨnɨk feki nap te, ankár take pourouráp nɨnɨk puri fek Kwaro yumwan yurukup naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Amo mokopia waráp ankwapnápomp yi mekamp tɨri kánanke nke napao maok, amokuráp yi mek yaknámp yao kárakére nɨk mo rape? ");
INSERT INTO yuj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Amo mokopia fwap waráp yi mek yao kárakére yak nánko, waráp ankwapnápén sérrá, ‘Ono waráp yi mekamp tɨri sámp-sɨnae’rá sénanapon? ");
INSERT INTO yuj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Amo tak nap te, amo kwekár i konap aropono! Manénkɨr te amo ankár waráp yi mek yaknámp yao kárakére tokwae sámp-sɨrampo. Takitea maok, amo wakmwaek fwap énounkoup karia waráp ankwapnápomp yi mekamp tɨri kánanke sámp-sɨnanapon. ");
INSERT INTO yuj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yumo yiki kwapwenámp ankank te asan sánk kwapono. Tá yumo yiráp anani kor kwapwe kouan sánk kwapono. Takria mao am anani kor pumpuri fápákárápria tákakarrá yumwan yourounkweantáno.” ");
INSERT INTO yuj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tá Jisaso ankwap kar arakrá sér, “Yumo ankank moria Kwarén kar sénapo, mao yumwan am monap ankank fwap sánk nae-námpon. Yumo ankár ankank sámp mwaria, térerá oupourounkria maok, yumo fwap nke mwanapon. Yumo ankár ménki fek poporokwap napo, Kwaro yumwan ménki kɨk-pwar naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Am te apae riteanápe, kápae kare arop wa mokop Kwarén kar toropwap nap te, wae fwap ankank ti konapon. Arop ankank sámp naeria oupourounk námp te, fwap am ankank nke konámpon. Arop ménki fek poporokwap nánko te, Kwaro man ménki kɨk-pwar nae-námpon. ");
INSERT INTO yuj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Táte arop ankwapamp tárápao naropwarén ‘Pan sápae’rá sénánko te, fwap yumwi sánk naenámp nie? Mono. ");
INSERT INTO yuj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Táte tárápao naropwarén sérrá, ‘Éntékam sápae’rá sénánko te, tákam-ti sánk naenámp nie? Am táman kor mono! ");
INSERT INTO yuj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ae konapara, táte yumo kwatae nɨnɨkráp arop fárákap wuriman yiráp tárápan kwapwe kare ankank kwaporok sánk napara, am táman mér kipo: Yiráp Naropwar yámar mek yak námp te fwap man kar toropwapnap aropan kwapwe kare ankank nénk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‘Arop námwan yaewouranápono’ ria nɨnɨk i konámp taknámp, yumo kuri arop ankwapan kor tak kipo. Mámá te Kwaromp lo kar fi kor, tá profet fákárerao sériap kar fi támaono.” ");
INSERT INTO yuj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Tá Jisaso ankwap kar sérrá, “Yumo te ankár kánanke kwarok ménki páraok tukup kipo. Aeno yaomwi mek pɨk mwanap mwaek akwapnámp mwae kup te yinkae tokwaeno. Aenánko kápae kare koumteouráp arop am mwaek tukup napon. ");
INSERT INTO yuj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aeno yiki yakáp mwanap mwaek akwapnámp ménki te kánanke kwarokia mwae koukounkour napon. Aenánko, ankákárank koumteouráp aropao mwar am mwae kup oupourounkia nke konapon.” ");
INSERT INTO yuj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tá Jisaso ankwap kar arakrá sér, “Yumo te kwekár profetén mér kip. Am fárákap te sipsip yɨpi yirɨria yumonapok korop napao maok, mek te yao pwae mekamp as kwatae kare niampono. ");
INSERT INTO yuj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aenapara, yumo fwap maonap nɨnɨkan nkea, mao te profet kare ni mo nierá yurukup mwanapon. Arop te fwap wain ki wiráp paok arák fekamp kánánkap mwanap nie? Ae te arop fwap kwantae ki káre apwar pwae fek tank nánko kánánkap konap nie? Am te mono. ");
INSERT INTO yuj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tá taknámp kwapwe kare yao te kwapwe kare ki tank konámpon. Tá kwatae yao te ki kwatae tank konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kwapwe kare yao te kwatae yao ki tank mo i konámpon. Tá kwatae yao te kwapwe kare yao ki tank mo i konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kápae kare yao kwapwe kare ki tank mo i konámp te, arop fárákapao karrá tokopea yaomwi mek yank i konapon. ");
INSERT INTO yuj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ae konapara, yumo te kwekár profet fákáre mao námokunap nɨnɨk aran yumo fwap mér mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yumo sérrá, ‘Náráp Tokwae Kar, náráp Tokwae Kar!’rá sér i konap koumteouráp arop, Kwaro náráp firáp taokeyaknámp mek te ponankor tukup mwanámpan mpwe nɨnɨk mwanape. Onomp Naropwar yámar mek yaknámp maomp nɨnɨkaok tukupnap arop fárákapao mwar, Kwaro náráp firáp taokeyaknámp mek tukupá yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nánkár am Kwaro aropan yurukupnámp yae fek kápae kare arop onan sérrá, ‘Tokwae Kar, Tokwae Kar, yino waráp e fek profet tére námpon. Tá waráp e fek yino kwatae arop yéréperá kérépámpon. Tá waráp e fek yino kápae kare kárákáre tokwae yororoimpon.’ ");
INSERT INTO yuj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aerá sénapo, ono am ke fek am fárákapan érik arakrá sénanampon: ‘Ono yumwan kánanke mér mo nampon. Yumo te kwatae nɨnɨk i konap aropono. Onomp wonae fik te yakápi kwapono.’” ");
INSERT INTO yuj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tá Jisas warko ankwap kar sérrá, “Arop ono sénamp kar má wawia mántwaok námp te, arop ankwap nɨnɨk kwapwerápao nap tiria oumpwar fi mek yumwi épéria fampá pwate nánko, nap kárákáre yak námp niampon. ");
INSERT INTO yuj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aenánko warákam ékria éntenk tokwae korop, tá kárákáre kor ouwi koropria am nap panánkár nánko, am nap tukur mo, fwap yak konámpon. Am te apae riteanápe, am oumpwar waeman kwar mek yak nánko, yumwi fémpéri tenapo, waeman am fek kárákáre yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aeno arop ono farákápnamp kar mámá wawia mántwaok mo námp te, épépérép arop ankwapao ént woupwi mek oup mek nap oumpwar yoroia tinámp niampon. ");
INSERT INTO yuj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Takianánko te, warákam ékia éntenk korop nánko, kárákáre kor ouwi koropria am nap panánkár nánko te, am nap tukur pɨk naerámpon. Waeman kare kar tukur pɨkia kwatae akwap naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas am kar farákápá pwaránko, kápae kare koumteouráp arop fárákap wawia kokorokoria nɨnɨk tokwae. ");
INSERT INTO yuj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Am te apae riteanápe, lo kar yénkrá farákáp konap arop fárákapao farákáp konap niamp mono, ankár mér tokwaeráp aropamp kar kárákáre niamp fek am fárákapan yénkrá farákáp námpono. ");
INSERT INTO yuj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas wae am kar farákáprá yaknámp am faonkwek pwarará pɨkánko, kápae kare koumteouráp arop maomp wakmwaek tukup. ");
INSERT INTO yuj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aenapo, oukoumwan arop ankárankamp lepra touwe kwataerápao koropea Jisasén nkea kwaráp torokomprá me kor woukoupria sérrá, “Tokwae Kar, amo fwap tak naeria nap kwamp te, onan fwapi papae.” ");
INSERT INTO yuj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aeránko maok, Jisaso maonámpok nárákarrá maomp pourouk yae papria sérrá, “Onomp nɨnɨk te amo oukoumwan fwapi yak nanapono.” Aeránko maok, ankár am ke fek táman maomp pouroukamp lepra touwe wae moyak nánko, am aropamp pourou wae kwapwe kare. ");
INSERT INTO yuj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aenánko Jisas man sérrá, “Amo te mámá ankank waráp pourouk korop námp máte, arop ankwapan séri kwapono. Amo akwapea waráp pourou prisén yénképria Moseso wokwaek sérimpnámp taknámp Kwarén ofa sánkampo. Aenapo maok, arop fárákap waráp touwe wae fwapnámp mér mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas wae Kaperneam mek akwap nánko maok, Rom mekamp arop 100 soldia poukwapnámp koropea Jisasén námwan aropomp naenámp kar fek arakrá turunk, ");
INSERT INTO yuj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tokwae Kar e! Onomp tére konámp arop mao touwe sámpea nap mek amp námpono. Maomp kour te sumpwi yak nánko, am kour touweantá arokwap námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aeránko maok Jisaso man sérrá, “Ono akwapea man fwapi pap nanampono.” ");
INSERT INTO yuj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Tá nopok kepteno Jisasén sérrá, “Tokwae Kar e, ono apae kwapwe kare aropao nanko, onomp nap mek akwap nanapanápe? Amo párák kar fek saráp sénapo, onomp tére arop warko fwapano. Ono kuri ankwap poukeyakáp konap arop fárákapamp yae ankore mek yak nampono. Aenampan maok, ono kuri soldia ankwap fákáre onomp yae ankore mek yakáp napon. Aenapo, ono ankwapan sérrá, ‘Amo koropae’ ranko te, mao korop konámpon. Tá ono onomp tére konámp aropan sérrá, ‘Amo arakrá téreae’rá sénanko te, mao takrá tére konámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas am aropamp kar wawia nɨnɨk tokwaeria maomp wakmwaek tukupnap arop fárákapan sérrá, “Ono yumwan kare kar sénampon: Ono Israel fi mekamp arop ankwap make pourouráp mér nap te nke moi nampono. ");
INSERT INTO yuj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ono yumwan sénampon: Kápae kare ankwap firáp arop yámar aoknámp mwaeknámp, tá yámar porokornámp mwaeknámp korop nap, am fárákap te fwap Abraham, Aisak, Jekop, méntér Kwaro náráp firáp taokeyak námp mek fɨr fár mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aeno koumteouráp arop Kwaro maompor náráp firáp taokeyak naenámp nánapi námpan maok, am fárákap am mek tukup mo napo, Kwaro am fárákapan panek kɨrɨkɨp mek tirá kérép nánko, tukupea yakápria touweantá apánki tɨkirá you kor kɨkɨmpia wae mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aeria Jisas keptenén sérrá, “Amo akwapae! Onomp nɨnɨk te am ankank amo onan mér napnámp taknámp korop naenámpon.” Aeránko maok am ke fek táman keptenomp tére arop warko touwe fwapimpon. ");
INSERT INTO yuj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Takia pwarará, Jisas Pitamp nap mek akwapea nke nánko maok, Pitamp yupuamp éntupwar touwe sámpea nap mek ampi yak. ");
INSERT INTO yuj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aenánko, Jisas maomp yaek toupoukour nánko, am touwe waeman worokor akwap. Aenánko, mao fárámpea Jisasompor fɨr yankapámp. ");
INSERT INTO yuj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Takia pwaránko, kumur mek kápae kare koumteouráp arop pourouk kwatae-arop woukouri yakápnámp arop éréképea, Jisaso-námpok korop. Aenapo, mao sénánko, am kwatae-arop fákáre wae arop pouroukamp worop akwapránk. Tá kápae kare touwenap aropan kor wae fwapokwaprá káká pwar. ");
INSERT INTO yuj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Am tak námp te, wokwaek Kwaro profet Aisaian nɨnɨk sánk nánko, sérimp kar niamp méntér pwi námpon. Mao arakrá sér: “Mao námoku nomp pouroukamp touwe ponankor te námokuráp pourouk kákea ti-akwap tenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas nke nánko, kápae kare koumteouráp arop fárákap koropá man ɨkɨrapo, Jisas námoku éréképá yárak i konámp arop fárákapan sérrá, “Nomo bot mek kounkouria ént aokore tápamprá nkwamwaek fi mwaek tukup mwaro.” ");
INSERT INTO yuj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aeria tukup mwaria napo maok, lo yénkrá farákáp konámp arop ankárankamp koropea Jisasén sérrá, “Tisa, amo apae némpouk akwap nap te, ono fwap amont akwap nanampon.” ");
INSERT INTO yuj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aeránko Jisas nopok man sérrá, “Mwaep te némp mek yak námpono. Tá ant fákáre te wokwae námokuráp taok mek yak námpon. Aeno Aropamp Táráp te mao yépe kor norokor naenámp nap te yak mo kareno.” ");
INSERT INTO yuj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aeránko táte mao éréképá yárak i konámp arop ankárankamp Jisasén sérrá, “Tokwae Kar e, onomp naropwar yépékrá yakea sumpwi nánko maok, pátea korop nanamp te fwap nie?” ");
INSERT INTO yuj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Táte Jisaso nopok man sérrá, “Wampweno, sumpwi arop fákáre námokuráp arop yákáre sámp-farákár mwanapono. Amo te onomp wakmwaek koropae.” ");
INSERT INTO yuj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas wae bot mek korokwap nánko, maomp éréképá yárak i konámp arop fárákapao kor énénki kounkouria ént pirékarrá tukup napo, ");
INSERT INTO yuj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ouwi tokwae koropria ént surukupa waeria bot mek kwampá pɨk naeria wae nánko, Jisas te ampi yak. ");
INSERT INTO yuj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aenánko, am arop fárákap tukupea Jisasén kéménkia sérrá, “Tokwae Kar e! Amo yinan yaewourae! Nomo ponankor ént mek pɨk mwanámp pourouiane!” ");
INSERT INTO yuj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aerapo maok, nopok Jisas am fárákapan sérrá, “Yumo apaerá apáp rape? Yumo te fwapia mér mo napono!” Aerá séria pwarará, fárámprá ouwi ntia ént surukupan yopor nánko, ouwi ntia ént ounk wae moyak. ");
INSERT INTO yuj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Aenánko am mao éréképá yárak i konámp arop fárákap am táman nkea, nɨnɨk tokwaeria sérarrá, “Mámáte mokope pourouráp aropono? Ouwi ntia ént maomp kar wa námp tene!” ");
INSERT INTO yuj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas wae akwapea ént aokore nkwamwaek fi mwaek Gadara fiamp apár mek. Aenánko maok, kwatae-arop noumpoukoupá yaknámp arop anánkaopwe koropea Jisasén mwaeaok kɨkɨp. Am arop yawor te arop kák nap fek mwaek yakria yopora wae nepara, aropao kor apápria am arop yawor yaknep mwaek te paokop mo i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Am arop yawor Jisasén tékén sérrá, “Kwaromp Táráp e! Amo yinan apae nae nape? Kot nanap ke oukoumwan sɨk námp te, amo mapek koropea yinan touwe sáp nae nape?” ");
INSERT INTO yuj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aenepo am fek ankwap kou kápae kare panek tae morok fépérrá yakáp. ");
INSERT INTO yuj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aenapo am kwatae-arop fákáre támao námwan aropomp naenámp kar fek Jisasén tékén sérrá, “Amo yinan yérépe nae nap kwamp te, kou kápae kare ará yakáp nap maomp pourou mek tirá kérépae.” ");
INSERT INTO yuj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aerapo maok, Jisaso am kwatae-arop fárákapan sérrá, “Yumo am mek tukupenke!” Aeránko, am kwatae-arop fákáre am arop anánkaopwean pwarará kouamp pourou mek tukup. Aenapo am kou kápae kare te am kwatae-arop woukouria foporakoránka waeria, ént aokore yaknámp furuk pɨkrɨnkia ént aokore mek ént fépéria am mek surumpwi. ");
INSERT INTO yuj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aenapo am kou wun i konap arop fákáre ek pɨrɨkɨmpea taun mek tukupea am kou surumpwimp kar farákáp. Aeria am kwatae-arop noumpoukoupnámp arop yaworan Jisaso yaewourimp kar táman kor farákáp. ");
INSERT INTO yuj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aenapo, am mekamp kápae kare koumteouráp arop koropea Jisasén kɨkɨp. Am fárákap man nkea apáp tokwaeriaka kar kárákáre fek sérrá, ‘Yinomp apár mek mamek te pwarará ankwapmwaek akwapae’ ria waeapon.” ");
INSERT INTO yuj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas bot ankwap mek korokwaprá ént aokore nkwamwaek fi mwaek arákarrá námoku yak konámp taun Kaperneam mek akwap. ");
INSERT INTO yuj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aenánko arop fárákapao pu kor yae kor yoronkwae tanknámp arop sunkwiar mek papea sankorop. Aenapo, Jisas am fárákapamp méran nkea am pu yae yoronkwae tanknámp aropan sérrá, “Táráp e! Fwapon, amo warákárampo. Ono waráp kwatae nɨnɨk wae tirá épéri pwar nampono.” ");
INSERT INTO yuj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aeránko maok, lo yénkrá farákáp konap arop fárákapao wawia, námokuráp nɨnɨk mek mwar arakrá nɨnɨk, “Mámá arop máte Kwarén wouroump sénámpwae!” ");
INSERT INTO yuj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Aerá nɨnɨkapo maok, Jisas am arop fárákapamp nɨnɨk mek wae méria sérrá, “Yumo apaeritea yiráp nɨnɨk mek kwatae nɨnɨk sámp rape? ");
INSERT INTO yuj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Onomp nɨnɨk te Aropamp Táráp te mámá apár mekamp aropamp kwatae nɨnɨk tirá épér naenámp kárákárerao yak námpan ‘Yumo mérenk’ ria nampon. Ono ‘Waráp kwatae nɨnɨk tirá épér namp’rá sénanko, yumo kar karean sénamprá mér mono. Aeno táte ono ‘Amo fárámpea akwapae’rá sénanko, yumo mao nánko nkeaka ‘Kareno’rá sér mwanapon.” Aerá séria maok, am pu yae yoronkwae tanknámp aropan sérrá, “Amo fárámprá amo am fek yunkupá ampinap ankank sámpea amokuráp nap mek akwapae.” ");
INSERT INTO yuj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aeránko maok, am arop wae fárámprá námokuráp nap mek akwap. ");
INSERT INTO yuj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aenánko maok, koumteouráp arop fárákap am táman nkea apáp tɨrɨnk. Aeria maok, am fárákap Kwaromp e sakapria maomp kárákáre fek arop fárákap takrá tére napan, ‘Aesio’rá sériapon. ");
INSERT INTO yuj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas takia pwarará akwapea nke nánko maok, arop ankwap takis sámp konap nap mek tank. Maomp e te Matyu. Aenánko, Jisas man sérrá, “Ononampaok koropae.” Aerá sénánko, mao wae fárámprá Jisasomp wakmwaek akwap. ");
INSERT INTO yuj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas akwapea Matyump nap mek tankrá fánánko maok, takis sámp konap arop fákáre ntia aropao ‘Kwatae nɨnɨkráp arop’rá sér i konap fákáre méntér tankáprá fépér. Maomp éréképá yárak i konámp arop fárákapao kor énénki tankáp. ");
INSERT INTO yuj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Aenapo, Farisi fákáre táman nkea Jisas éréképá yárak i konámp arop fárákapan sérrá, “Yiráp tisa te apaeritea takis sámp konap arop ntia kwatae nɨnɨkráp aropént tankrá fánámpon?” ");
INSERT INTO yuj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas am kar wawia am fárákapan nopok kar pwarokwaprá sérrá, “Arop fárákap touwe fwapnap apaeritea doktanámpok tukup mwanapon? Touwenap arop fárákapao saráp doktanámpok tukup konapon. ");
INSERT INTO yuj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yumo tukupea Kwaromp Buk fek yaknámp kar nkea mér sámpenke: ‘Ono te ofa sáp napan warákár mono. Arop aropompan ono warákár nampon.’ Ono ék namp te, námo yae-párák kare nɨnɨkrápao namprá nɨnɨknap aropan te érékép mono. Arop, námo kwatae nɨnɨkrápao namprá nɨnɨknap arop fárákapan wumwia érékép naeria ék nampon.” ");
INSERT INTO yuj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Am ke fek táman Jon éréképá yárak i konámp arop fárákap koropea Jisasén sérrá, “Apaeritea yino ntia Farisi fákáre ará Kwarén kar toropwap mwaria fɨr wuri nánko, waráp éréképá yárak i konap arop fákáre fɨr wuri mo napono?” ");
INSERT INTO yuj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aerapo maok, Jisaso nopok am fárákapan kar pwarokwaprá sérrá, “Táte yupu wourékam sámpnámp arop oukoumwan náráp nouroup arop fárákapént yak námp fek te mokopia yonkwae touwe mwanapanáp? Nánkár wakmwaek am yupuráp aropan sámpá tukup tenapo, náráp nouroup aropént yak mo nánko maok, am ke fek táman am fárákapao fɨr wuri mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Arop ankwap waempyam fákáre wourékam sámpea épi fek paprá aomp mo i konámpon. Táte mao tak nánko te, am waempyam me fek paprá aompinámp támao nénérép nánko, ankár porok waempyam épi am pearákár tokwae naerámpon. ");
INSERT INTO yuj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tá arop ankwap wain ént wourékam sámpea meme yɨpi fekamp botol épi mek kér mo i konapon. Táte tak napo te, meme yɨpi fápákáráp nánko, wain apárok kwarákár nánko, am meme yɨpiao kor kwatae akwap naenámpon. Aeno ankár wain ént wourékam te ankár meme yɨpi wourékam fekamp botol mek kéria napo, anánkaopwe énénkér fwap yak konepon.” ");
INSERT INTO yuj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas oukoumwan am kar farákáprá yak nánko, lotu nap taokeyaknámp arop ankwap koropea Jisasomp wonae fik kwaráp torokompria sérrá, “Onomp yupu-táráp wae oukoumwan sumpwi námpono. Aenámpan amo koropea maomp pourouk waráp yae pap napo, mao warko fárámpea yiki yakano.” ");
INSERT INTO yuj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aeránko maok, Jisas fárámprá maomp wakmwaek akwap nánko, mao éréképá yárak i konámp arop fárákapao kor méntér tukup. ");
INSERT INTO yuj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aenapo maok, yupu ankárankamp yaknámp, mao te kápae kare por e-furuk pɨkria ankár taki yak námp te akwapea éntér-sámpramp yopwar. Aenámpao am yupu koropea Jisasomp wonae fik younkwe mwaek yakria maomp waempyam fu fek sámp. ");
INSERT INTO yuj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mao te, námo maomp waempyam fek yae pap nanko te, ono e-furuk pɨk namp wae fwap nae namponria nɨnɨkia yae pap. ");
INSERT INTO yuj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aenámpan maok, Jisas wae sámp-arákarrá man nkea sérrá, “Táráp e, amo oukoumwan te yonkwae kakére fek akwapampo. Amokuráp mérao amwan wae fwapi pap námpon.” Aeránko maok, am ke fek táman am yupu wae fwap. ");
INSERT INTO yuj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Takia pwarará, Jisas wae akwapea lotu taokeyaknámp aropamp nap mekria nke nánko maok, arop poum-ke mek wur fokoprá youenka wae. ");
INSERT INTO yuj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aenapo Jisas am fárákapan sérrá, “Yumo senke! Yupu-táráp te sumpwi mono, párák amp námpono.” Aeránko maok, táte am fárákapao, waeman sumpwi yak námp teria amomoránk. ");
INSERT INTO yuj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aenapo, am fárákapan ek tirá kérépá pwarará, Jisas mwar nap mek youmpea am yupu-táráp yákáre táman yaek sámp nánko, mao wae fárámp. ");
INSERT INTO yuj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Am takianánko, am kar te am apár mekamp kápae kare némpouk mwaek sérarrá paokopiapon. ");
INSERT INTO yuj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas wae takia am némp pwarará akwap. Aenánko maok, yi néneráp arop anánkaopwe maomp wakmwaek akwaprá arakrá wumwi, “Devitomp ou fekamp arop e! Amo yinan aropompae!” ");
INSERT INTO yuj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","29","Aerepo maok, Jisas wae nap mek akwap nánko, am yi néneráp arop yawor maonámpok korop. Aenepo, Jisaso am arop yaworan sérrá, “Ae te yumo fwap ono yumwan fwapi pap nanamp am wae mér nep nie?” Táte am arop yaworao nopok sérrá, “Tokwae Kar e, yeno. Yino wae mér nempon.” Aerepo, Jisas wae am arop yaworamp yi mek yae papria sérrá, “Yumo onan mér nepon. Am tak nep támao yumo warko fwap nepon.” ");
INSERT INTO yuj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aeránko am arop yaworamp yi wae fɨrɨkɨr. Aenánko Jisas am arop yaworan kar kárákáre arakrá sér, “Yumo mér kar kipo. Takria yumo arop ankwapan farákáp nepo, wawia mérantáno.” ");
INSERT INTO yuj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aerá sérimpan maok, am arop yawor ek akwaprá Jisas fwaprá káknámp kar am farákáp nepo, am fekamp kápae kare némpouk mwaekamp arop wawiapono. ");
INSERT INTO yuj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Manénkɨr am arop yawor wae akwap neria nepo, arop ankwap fárákapao kwatae-aropao top kor aompi papnámp arop Jisaso-námpok warámpá korop. ");
INSERT INTO yuj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aenapo, Jisas am kwatae-arop yérépea kérép nánko, am top kor aompi yaknámp arop wae fwap kar sér. Aenánko koumteouráp arop nɨnɨk tokwaeria sérrá, “Wokwaek te mámake pourouráp ankank Israel fi mek korop moimpon.” ");
INSERT INTO yuj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aerapo maok, Farisi fákáre sérrá, “Mao te kwatae-arop taokeyak-námp aropamp kárákáre fek kwatae-arop yéréperá kérép konámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisaso kápae kare taun tá némp kánanke-táráp am mekmwaek yárakrá koumteouráp aropan maomp lotu nap mek kar yénkrá farákápámpono. Mao te Kwaro náráp firáp taokeyak naenámp Kwapwe Kare Kar farákápria kápae kare aropamp pouroukamp nkwakwe make touwe fwapokwaprá kákámpon. ");
INSERT INTO yuj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mao kápae kare koumteouráp aropan nkea yonkwae touwe tokwae. Am te apae riteanápe am arop fárákapamp nɨnɨk te épérépia kwatae kare yakáp napon. Am fárákap te sipsipao taokeyak naenámp arop mo nánko, námoku mwar yakáp nap niampi yakáp napono. ");
INSERT INTO yuj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aenapo maok, Jisas námoku éréképá yárak i konámp arop fárákapan wounáp kar sérrá, “Fɨr te yopwar mek kápae kare nounoumouri námpan maok, am mek tére nae-námp kápae kare tére arop mo námpon. ");
INSERT INTO yuj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aenámpara yumo ankár am yopwar naropwarén kar toropwap napo, mao tére arop sámp-kérép nánko, akwapea maomp fɨr tirá koupoukour nae-námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas náráp éréképá yárak i konámp éntér-sámpramp arop fákáreran koropenkria éréképá tankrá am fárákapao touwenap arop fwapokwaprá kákria arop pouroukamp kwatae-arop yéréperá kérép mwanap kárákáre nénkámpon. ");
INSERT INTO yuj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Am éntér-sámpramp aposel fákáreramp e te ará: Ankwap te Saimon, maomp ankwap e te Pita, maomp nánae te Andru. Ankwap te Jems Sebedimp táráp ntia maomp nánae Jon. ");
INSERT INTO yuj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ankwap te Filip, ankwap te Bartolomyu, tá ankwap te Tomas, ankwap te wokwaek takis sámpámp Matyu, ankwap te Alfiusomp namoráp Jems, ankwap te Tadius. ");
INSERT INTO yuj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ankwap te Saimon Selot, ankwap te Jisasén outɨri naenámp arop Judas Iskariot. ");
INSERT INTO yuj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisaso am éntér-sámpramp arop fárákap tirá kérép naeria am fárákapan kar arakrá sér, “Yumo te ankwap fi aropaonapok tukup kwapono. Tá yumo Samaria mekamp némp-némp tukup kwapono. ");
INSERT INTO yuj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yumo te ankár Israel fi mekamp sipsip wae moyakáp nap niamp námpara, am mek tukup kipo. ");
INSERT INTO yuj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yumo tukupea kar arakrá farákáp kip: ‘Kwaro yámar mekamp náráp firáp taokeyak naenámp te wae wonae fik korop námpon!’ ");
INSERT INTO yuj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yumo tukupea touwenap arop fwapokwaprá kákrá, sumpwinap arop kékéménkrá kákrá, lepra touwe sámpnap arop fwapokwaprá kákria, kwatae-arop arop pourouk woukouri yakápnap yéréperá kérép kipo. Ankank yumo sámp nap te kwaporok sámp napara, yumo kor am ankank kwaporok nénk kipo. ");
INSERT INTO yuj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nánkár yumo tukupria te, yiráp yam kánanke mek golráp mani, silva, tá mani kaparáp, mámá ankank kékéria tukup kwapono. ");
INSERT INTO yuj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nánkár yumo paokop nap te yumo yam, waempyam ankwap, tá su, mear yaopwae ará te ti-samp kwapono. Arop tére námp te fwap am tére námp fek tapek nopok ankank sámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Táte yumo ankwap taun mek, tá némpouk tukupria te, yumo ankár fwapia nkea mér kip. Am némpoukamp arop kwapwe kare yae-párák arop yak nánko te, yumo ankár méntér saráp yakápia nánkár wakmwaek am némp pwarará tukup kip. ");
INSERT INTO yuj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Táte yumo ankwap nap mek tukup nap kwamp te, yumo am nap mekamp koumteouráp aropan ankár arakrá sér kipo: ‘Kwaromp yonkwae porokwe yumont yakano.’ ");
INSERT INTO yuj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aerá sénapo, am nap mekamp koumteouráp arop yumwan warákárria érékép napo te, yumo sénap kar kwapwe fwap am fárákapan yaewour naenámpon. Aeno táte mao yumwan warákárria érékép mo napo te, yumo sénap kar kwapwe warko yumwan mwar yaewour naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Táte arop ankwap yumwan warákárria éréképea yiráp kar wa mo napo te, yumo ankár am némpráp, am nap mek te ankár fori pwararea warko tukup kwapono. ");
INSERT INTO yuj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ono yumwan kare kar sénampon: Nánkárap Kwaro koumteouráp aropan kot naenámp fek, Sodom ntia Gomora mek sánkámp touwe kwatae kámá-pwarará yoporop touwe tokwae am némpao sámp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Yumo wawenk! Ono yumwan yao pwae mekamp as niamp ou mek sipsip niamp tirá kérép nampono. Aenampara, yumo ankár tákamao i konámpnámp yonkwae kour fek tére kipo. Yumo ankár ant yuri i konámp nɨnɨkaokria yumo sánánkar porokwe fek yakáp kipo. ");
INSERT INTO yuj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yumo arop fárákapan fwapia mér kipo. Yumwan náráp kaunsilo nke námp fek éréképá tukupá kot mwarea napon. Tá yumwan lotu nap mek ti fákeyakáprá yumwan fupuk mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yumo ononampaok napara, yumwan Gavman ntia king fákáreaonapok éréképea tukup mwarea napon. Aenapo, yumo am fárákapan kar farákápria ankwap fi aropan kor farákáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yumwan érékép tukupea kot napo te, apápi kwapono. Yumo takria, ‘Yino am fárákapan te apaerá sér mwareano’rá nɨnɨk mwanape. Tá ‘Yino yinan turunk napo te, apae kar nopok sér mwareano’rá nɨnɨk mwanape. Yumwan am ke fek táman yumo kar farákáp mwanap kar Kwaro yiráp nɨnɨk mek pap naenámpono. ");
INSERT INTO yuj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Apae yumoku am kar farákáp mwanapanápe, yiráp Naropwaromp Yiki Kor Spiritao yiráp top korént puiyakria am kar farákáp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Arop fárákap náráp ankwapyaenápén kot nánko, tirá wour mwarea napon. Naropwaro náráp tárápan tak nánko, tá tárápuao kuri náráp éntupwar naropwarén yoporria tirá wour mwarea napono. ");
INSERT INTO yuj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Waeman kápae kare arop yumwan kokwarok mwarea napon. Am te apae riteanápe, yumo waeman onomp firáp yakáp napantá napon. Aeno arop ankár mér kárákáre fek yakrá akwapea pwarnámp yae fek nánko te, Kwaro man fwap warko warámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Táte yumwan ankwap taun mekamp yérépe napo te, yumo ankár pɨrɨkɨmpea ankwap taun mek tukup kipo. Ono yumwan kare kar sénampono: Yumo oukoumwan Israel firamp taun mekamp tére pwar mo napo, Aropamp Táráp waeman ék naeria námpon. ");
INSERT INTO yuj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Skul táráp te náráp tisan kámákár akwap mono. Táte tére konámp aropao kor náráp arop tokwaeran kámákarrá nareki yak mono. ");
INSERT INTO yuj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Skul táráp akwapea maomp tisa yaknámp niampnámp te wae fwap pwi námpono. Táte tére konámp aropao kor akwapea náráp arop tokwae yaknámp niampnámp te wae fwap pwi námpono. Am arop fárákapao nap naropwarén e tokoprá ‘Belsebul’rá sénapara, mámá nap mek énénki yakápnap arop fárákapan kor kwatae e takrá tokoprá kák mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Warko Jisas ankwap kar arakrá sér, “Aropao yumwan kwatae pap mwaria napo te, yumo apápi kwapono. Kápae kare ankank mek oupouroupá yak námp te, nánkárap érik korop naerámpon. Tá kápae kare kar mek yak námp te, nánkár arop ponankor fwap mér mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ono kar yumwan kumuruk farákáp namp te, yumo ankár wae fek farákáp kipo. Tá kar yumo sánánkar woupwi fek wa nap te, yumo ankár koupoukarrá tankáp konap mwaek fokopeyakrá, am kar farákáp kipo. ");
INSERT INTO yuj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yumo te arop pourouan saráp tirá wouria yiráp waempén te kwatae pap mo mwanap arop táman apápi kwapono. Táte mono. Yumo ankár arop pourou ntia waemp yaomwi mek sámp-sɨnaenámp Kwar táman saráp apáp kipo. ");
INSERT INTO yuj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Arop ant kánanke anánkaopwe mani kánanke 2 toea fek sámp konapono. Aeno táte yiráp Naropwar monorianánko te, am ant kánanke te ankwap apárok pɨká párákap mono. ");
INSERT INTO yuj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aeno yumwan te mao waeman yiráp me korokamp me pwae wuriman wae kouroumpea pwi pwate námpon. ");
INSERT INTO yuj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Aenámpara yumo te apápi kwapono. Yumo te waeman Kwaro nke námp fek am ant kápae kare kánanke-táráp kámá-pwar napara, mao amwan fwap taokeyak kor naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisas warko ankwap kar arakrá sér, “Arop koumteouráp aropao nke nap fek onomp e érik farákarrá sénámp te, ono kuri am aropamp e onomp yámar mek yaknámp Naropwaro nke námp fek maomp e érik farákarrá sénanampon. ");
INSERT INTO yuj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aeno aropao koumteouráp aropao nke nap fek ‘Ono te Jisasomp firáp mono’rá sérianámp te, nopok ono kor onomp yámar mek yaknámp Naropwaro nke námp fek am aropan ‘Mao te onomp firáp mono’rá sénae rampon.” ");
INSERT INTO yuj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisas warko ankwap kar arakrá sér, “Yumo te ono apárokamp yorowaran poporokwerá kák naeria ék nampan mpwe nɨnɨki kwapono. Ono apae apárokamp yorowaran poporokwerá kák naeria ék nampanápe, mono. Ono te bainatan sámpea ék nampono. ");
INSERT INTO yuj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ono éknamp fi te arop náráp naropwarén yorowar nánko, tá yupuao kor náráp éntupwarén nánko, tá yupuao kor náráp yupu táparápén yorowar, mak mwanapono. ");
INSERT INTO yuj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Námoku ankárankamp nap mekamp arop kok yorowar mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Arop náráp éntupwar naropwarén saráp nɨnɨk tokwaeria, mao onan nɨnɨk tokwae mo námp te, mao te onomp nouroup yak naenámp pourou mono. Arop náráp poumou-táráp, tá yupu-tárápan saráp nɨnɨk tokwaeria onan nɨnɨk tokwae mo námp te, támao kor onomp nouroup yak naenámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tá arop ono touwe sámp nampaokria, onomp wakmwaek korop mo námp te, mao te onomp nouroup yak naenámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Arop námoku támao yiki yak kare sámp naenámp te, maomp yiki yak te waeman akwapá moyak naenámpon. Aeno arop onan nɨnɨkia námokuráp yiki yak wampwe pwar námp te, mao fwap yiki yak kare sámp naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jisas warko ankwap kar arakrá sér, “Arop yumwan éréképea yaewour nap te, onan kor warámpea yaewour napon. Tá arop onan warámpea yaewour nap te, onan sámp-kérép nánko ono ék namp Kwarén kor warámpea yaewour napon. ");
INSERT INTO yuj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Arop námo profetén yaewour naerá nɨnɨkia profetén warákárria náráp nap mek warámpá akwap námp te, am profet sámp konámpnámp taknámp nopok sámp naenámpon. Tá arop, ono yae-párák kare arop warákárria onomp nap mek warámpá akwap naerá nɨnɨkianámp te, am yae-párák kare aropao sámp námpnámp taknámp nopok kor am ankank kwapwe sámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aropao ono éréképá tanknamp arop ou mekamp e moráp arop ankwapan nkea, mao te Jisasomp wakmwaek akwapnámp aropara, yaewour naerá nɨnɨkia man ént yɨnk-sánkeanámp te, ono yumwan kare kar sénampon: Am taki námp te kwaporok mono, ankár nopok kor sámp naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas námoku éréképá yárak i konámp éntér-sámpramp arop fárákapan am tére mwanap kar farákáp. Takia kar wae pwarará, am némp pwarará am mwaekamp némpouk mwaek akwaprá koumteouráp arop fárákapan Kwaromp kar yénkrá farákáprá yárak. ");
INSERT INTO yuj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jono man fákapea páte napo yakria, Kraiso kápae kare térerá yáraknámp kar wa. Aeria maok, Jon námoku éréképá yárak i konámp arop fárákapan, Jisasén turunkenkria tirá kérép. ");
INSERT INTO yuj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Aenánko maok, am fárákap tukupea Jisasén turunkrá, “Amo te am korop naenámpria yépéknámp arop támao ni, yino nánkár ankwapan yépékrá yakáp mwanámp nie?” ");
INSERT INTO yuj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tá nopok Jisas am fárákapan arakrá sér, “Yumo tukupea kápae kare ankank yumo wawi nap, tá yumo yi fek nke nap, am táman Jonén sér kipo: ");
INSERT INTO yuj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yi néneráp arop fárákap warko fwap nke, tá pu kwataeráp arop fárákap wae paokop, tá pourouk lepra touwe sámpnap arop wae pourou yiki kwapwe, tá woupwi kérnap arop fárákap warko fwap kar wa, tá sumpwinap arop fárákapao kor warko fárámp, tá ankank moráp arop fárákapao kor wae Kwapwe Kare Kar wa napono. ");
INSERT INTO yuj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aeno táte arop ankwap mao onan mérámp pwar mo námp te, Kwaro man ourour sánk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Am Jonomp éréképá yárak i konámp arop fárákap wae tukup tenapo, Jisaso Jon táman koumteouráp arop fárákapan sérrá, “Wokwaek yumo arop yak mo apár mek te apae ankankan nke mwaria tukupapon? Ae te yumo ént woupwi mekamp kaeak ankárank ouwirao nánko, nárákár akwapá koropá námp táman nke mwaria tukupap nie? Am te mono! ");
INSERT INTO yuj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yumo apae ankank nke mwaria tukupapon? Ae te arop ankwap kwapwe kare waempyam moporia yak nánko, táman nke mwaria tukupap nie? Táman kuri mono! Arop fárákap waempyam kwapwe moporia nap te kingomp nap mek yakáp i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aeno yumo te apaen nke mwaria tukupapon? Profet ankárankan nke mwaria tukupap nie? Ye. Tá kare, ono yumwan sénampon: Mámá yaknámp profet máte kápae kare ankwap profetén kámákár akwapea arop tokwae námpon. ");
INSERT INTO yuj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Am arop táman Kwaro maomp Buk fek arakrá sénámpon: ‘Wawenke! Onomp kar farákáp naenámp arop sámp-kérép nanko, amwan manénkɨr meki akwap naenámpon. Mao amo akwap nanap mwae kup nánapia pwar naenámpon!’ ");
INSERT INTO yuj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ono yumwan kare kar sénampon: Arop ént mek nérrá kák-námp Jon te apárokamp ponankor arop fárákapan kámákár akwap námpon. Aenámpan maok, arop Kwaro náráp firáp taokeyaknámp mek arop apárok kar kánanke kwarok yak námpao maok, Jonén kámákár akwap námpon. ");
INSERT INTO yuj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Arop ént mek nérrá kák konámp Jon yakámp ke feknámpia koropea oukoumwan námp te, arop yoporráp kárákáre kor arop fárákapao Kwaro náráp firáp taokeyak námp te yorowarrá apárok anámpá pap mwaria wae napon. ");
INSERT INTO yuj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ponankor profet fákáre ntia Mosesomp loao kor Kwaromp kar farákáprá koropea Jon koropámp ke fek naenámp karan sériapon. ");
INSERT INTO yuj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aeno táte yumo wa mwaria te yumo wawenke! Jon te Elaija am arop korop naenámp támaono. ");
INSERT INTO yuj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aenámpara, woupwiráp arop te ankár mámá kar má wa kuno. ");
INSERT INTO yuj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Oukoumwan mámá ke fekamp koumteouráp aropan te ono waniamprá sénanampono? Am fárákap te tárápu anánk fákáre koropea némpouk tankáprá ankwap fákárerao ankwap fárákapan sér i konap niamp námpon. ");
INSERT INTO yuj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Mao sérrá, ‘Yino yumwan wur fokop námpan maok, yumo tár pounk mo. Tá yino yonkwae touwe mwanap tár sámp námpan maok, yumo te éménk mo i konapon.’ ");
INSERT INTO yuj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tá taknámp Jon koropea fɨr tokwae fár mo, wain ént fár mo námpono. Aenánko arop fárákapao man sérrá, ‘Kwatae-arop maomp pourouk woukoupeyak námp’rá sénapon. ");
INSERT INTO yuj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aeno Aropamp Táráp ékia mao fɨr fárrá, wain ént fár, mak nánko, arop fárákapao man sérrá, ‘Yumo nkenke! Mao te fɨr fár tokwae konámp arop, tá wain ént fár tokwae konámp aropono. Mao te takis sámp konap arop ntia kwatae nɨnɨkráp aropamp nouroupono.’ Aenámpan maok, mao tére námpao Kwaromp mér yénkép námp te kare kar ankankono.” ");
INSERT INTO yuj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ankwap némpouk mwaek Jisas kápae kare kárákáre tokwae yénkép námpan maok, am fárákap te kwatae nɨnɨk younkwek sɨr mono. Aenapantá, am ke fek táman Jisaso am fárákapan yoporimpono. ");
INSERT INTO yuj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Takria arakrá sér, “Yumo taun Korasin mekamp arop fárákap, yumo te koupoutáráp nape! Tá yumo taun Betsaida mekamp arop fárákap, yumo te koupoutáráp nape! Arop ankwap ankwap fi mekamp taun Taia ntia Saidon mek ono yiráp taun mek yénképnamp kárákáre niamp yénképankoria te, am fárákap Taia ntia Saidon fi yonkwae touweria képér i konap waempyam képéria yaomwi éntu mek yakápria kwatae nɨnɨk waeman younkwe mwaek sɨr mwarapono. ");
INSERT INTO yuj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aeno ono yumwan sénampon: Kwaro koumteouráp aropan yurukupia touwe kwatae nénk naenámp yae fek te taun Taia ntia Saidon firao sámp mwanap touwe te, yumo sámp mwanap touwe tokwae niamp take mono. ");
INSERT INTO yuj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tá Kaperneam mekamp arop fákáre, yumwan te arop ankwap fákáreao kakapea yámar mek sampok mwanap nie? Mono. Yumo ankár yaomwi mek pɨk mwarea napono. Táte arop ankwapao taun Sodom mek ono yumwan mapek kárákáre yénkép namp niamp take pourouráp yénképánkoria te, am Sodom oukoumwan fwap makánko yak naempon. ");
INSERT INTO yuj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aeno ono amwan sénampon: Kwaro koumteouráp aropan yurukup naenámp yae fek te amo sámp nanap touwe tokwae te Sodom mek sámpap touwean kámákár akwap námp sámp nanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Am ke fek táman Jisas Kwarén arakrá sér, “Ayao, amo yámar mek ntia apár taokeyak konap Tokwae Karono. Amo mámá ankank mér tokwaeria nɨnɨk kour kwapwenap arop fárákapan te mek wouroumpria, amo tárápunámp yakápnap aropan saráp yénkép nap táman, ono amwan ‘Aesio’rá sénampono. ");
INSERT INTO yuj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ayao, am te kareno. Waráp nɨnɨk te taki yak námpono!” ");
INSERT INTO yuj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jisaso am taun mekamp aropan warko ankwap kar sérrá, “Onomp Naropwaro onomp yaek ponankor ankank káká pwate námpon. Arop ankárankamp Kwaromp Tárápan mér mono. Naropwar Kwar námoku saráp mérámpono. Tá arop ankwap Naropwarén mér mono. Kwaromp Tárápao saráp mérámpono. Aenámpara, Kwaromp Tárápao am fárákapan náráp Naropwar Kwar yénkép nánko, am fárákapao saráp Naropwar Kwarén mér napon. ");
INSERT INTO yuj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yumo arop fárákap tére tokwaea wae, tá ankank kakap napo, kápae nánko te, yumo ponankor ononampok korop napo, ono yumwan anepér nénk nanampon. ");
INSERT INTO yuj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ono yumwan sánknamp am yaopwae kápae yiráp yápare mek porokop tenamp te, yumo fwap samp mwanapon. Tá ono yumwan sampenkria sánknamp ankank te kápae mono. Am te apae riteanápe ono te onokump nɨnɨk te apárok anámpea aropan sánánkar porokwe fek i konampono. Aenampara, yumo fwap anepér sámp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mámá yaopwae ono yiráp yápare mek pap namp te, yumwan kokwae sánk mono. Tá ankank ono yumwan sampenkria nénk namp te kápae mo, kakére fwapono.” ");
INSERT INTO yuj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wakmwaek ankwap Sabat yae fek Jisas witráp yopwar mekmwaek náráp éréképá yárak i konámp arop éréképea akwap. Aenánko am fárákapao yae porokwe nánko, wit kánánkáprá yɨpi kokwarrá fépérrá tukup. ");
INSERT INTO yuj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aenapo, Farisi fákáre am táman nkea Jisasén sérrá, “Amo nkeae! Waráp éréképá yárak i konap arop fárákap nko, Sabat yae fek lo kákánk konap ankank te tak napon.” ");
INSERT INTO yuj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aerá sénapo maok, Jisas nopok am fárákapan sérrá, “Ae te yumo Devitoimp kar Kwaromp Buk fek yak námp te nke mák napon? Ono sénamp te am ke fek Devit ntia maomp arop fárákap yae porokwe nánko, ");
INSERT INTO yuj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kwaromp lotu nap mek yinkea Kwarén ofa sánknap pan fáriapono. Am pan te fouara, arop fár mono. Pris fákárerao saráp fári konapan niapon. ");
INSERT INTO yuj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ae te yumo am kar lo fek yak námpan kor nke mori kwapono? Pris fákáre Sabat yae fek lotu nap tokwae mek lo kwe-pwararea tére napan maok, am fek te kwatae nɨnɨk yak mono. ");
INSERT INTO yuj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ono yumwan sénampon, mapek yak námp te támao lotu nap tokwaeran kwe-pwar námpon. ");
INSERT INTO yuj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kwaro sérrá, ‘Ono te ofa fek warákár mono. Ono te ankwapan aropompan saráp warákár nampon.’ Aeno táte yumo am mek yaknámp kar fwapia mér nap kwamp te, arop kwatae nɨnɨk mo, fwapnap aropan, kwatae nɨnɨk naprá yurukup mo mwanapono. ");
INSERT INTO yuj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Am te apae riteanápe, Aropamp Táráp mao námoku Sabat yaeran kor poukwap konámpono.” ");
INSERT INTO yuj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Takia Jisas am fek pwarará akwapea, ankwap taun mekia am fárákapamp lotu nap mek akwap. ");
INSERT INTO yuj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aenánko maok, am mek yaknámp arop ankárankamp maomp yae te yonkwae yak. Aenánko maok, arop ankwap fárákap Jisasén kot mwanámpria, mokopon nke mwar ritea man turunkrá, “Ae te nomo fwap Sabat yae fek touwenámp arop fwapi pap mwanámp ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aerapo maok, nopok Jisaso am fárákapan sérrá, “Yumo ou mekamp arop ankwap náráp sipsip Sabat yae fek apár me mek pɨká yak nánko te, mao fwap náráp sipsip warko ka-pap konámp te yumo wae mér napon. ");
INSERT INTO yuj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aeno arop te sipsipan kámákár akwap námpon. Aenámpara, nomo fwap Sabat yae fek arop ankwapan yaewour mwanámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aerá séria pwarará am aropan sérrá, “Waráp yae kor ékékérae.” Aeránko maok, am arop wae náráp yae kor ékékér nánko, maomp yae kor wae kwapwe kareria ankwapmwaek yae kor niampi yak. ");
INSERT INTO yuj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aenánko, Farisi fákáre am nkea, lotu nap pwarará tukupea koupoukarrá tankáprá Jisasén sámp-wouroump mwaria kar sérar. ");
INSERT INTO yuj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisaso am Farisi fákáre námwan kwatae pap mwarianap nɨnɨk wae méria am taun pwarará akwap. Aenánko kápae kare koumteouráp arop maomp wakmwaek tukup napo, mao touwenap arop ponankor fwapokwaprá kák. ");
INSERT INTO yuj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aeria maok, am fárákapan sérrá, “Yumo onan, mao tére námponorá arop ankwap fárákapao wa nap fek érik séri kwapono.” ");
INSERT INTO yuj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aenánko maok, am kar te wokwaek Kwaro profet Aisaiamp táp feknámp sérimp kar wae méntér pwi námpono. Aisaia arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mámáte onomp tére aropan ono wae nánapi pwara nampon. Ono man warákár tokwaeria ono te man yonkwae kárámp nampon. Onomp Spirit maomp pourou mek pap nanko mao yae-párák kare nɨnɨk fekamp kar ankwap fi mekamp arop fárákapan farákáp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mao te arop yopor kar sér mo, kar tokwae tékén sér mo. Mao koupoukour konap mwaek érik fokopeyakrá wumwi kar fek kar farákáp mono. ");
INSERT INTO yuj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kaeak nunuri yak námp te, am te ponankor tákár mono. Táte kárákáre monámp lam mekamp wik yurunk kánanke kwarok námp te ponankor torokwari pap mono. Mao fwap térerá yakrá akwapea yae-párák kare nɨnɨk pwi yak námp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Táte kápae kare ankwap fi mekamp arop man méria, man yépékrá yakáp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Am ke fek táman arop fárákapao arop ankárankamp kwatae-arop noumpoukoupá yak námp Jisasnámpok warámpá korop. Mao te yi ntia top kour aompi yak. Aenánko Jisas man fwapi pap nánko, mao wae kar séria yi fwap nke. ");
INSERT INTO yuj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aenánko kápae kare koumteouráp arop nkea kokorokoria sérrá, “Ae te mámá arop te Devitomp fekamp táráp ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aenapan maok, tá Farisi fákáre am wawia sérrá, “Am arop te Belsebul kwatae-arop fákáre taokeyak námp maomp kárákáre fek kwatae-arop yéréperá kérép námpono.” ");
INSERT INTO yuj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aerapan maok, Jisas am fárákapamp nɨnɨk mek wae méria am fárákapan sérrá, “Ankárankamp firáp arop taokeyakáp nap mekamp kuk pɨrékarea yorowar napo te, am fi te mokopia kárákáre yak naenámpon? Waeman kwatae akwap naenámpon. Táte ankárankamp némpoukamp arop, tá ankárankamp nap mekamp arop kuk pɨrékarea yorowar nánko te, am némp ntia am nap mekamp arop te fwapi yakáp mono. ");
INSERT INTO yuj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aeno táte Satan kok námoku yorowar nánko te, am Satanomp fi te waeman pɨpɨrɨkɨri akwap naerámpon. Aenámpara, mao náráp firáp taokeyak konámp te mokopia kárákáre yak naenámpanáp? ");
INSERT INTO yuj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Táte kare, Belsebul onan yaewour nánko, ono kwatae-arop yéréperá kérép nampan nánko te, wa yiráp arop fárákapan yaewouránko kwatae-arop yéréperá kérép konapon? Aenámpara yumokunap fi támao maok warko yumwan yurukup námpon. ");
INSERT INTO yuj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aeno táte yumo nke napo, Kwaromp Yiki Kor Spiritao onan yaewouránko, ono kwatae-arop yéréperá kérép nanko te, yumo táman nkea, Kwaro náráp firáp taokeyak naenámp te yumo nke nap fek wae ék námp, ará mér kipo. ");
INSERT INTO yuj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mokopia aropao ankwap kárákáre kor aropamp nap mek akwapea maomp ankank ti naenámpon? Mao tak naeria te, manénkɨr akwapea am kárákáre kor arop sámpea, paok fek yarokwapea pátea maok, mao fwap nap mek paprará am mek tankápnámp ankank fwap ti naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Táte arop onomp nouroup mo námp te onomp yopor aropono. Arop onont ankára mek koumteouráp aropan koupoukour mo námp te, mao am fárákapan ti-yérépe nánko, pɨrɨkɨmp konapon. ");
INSERT INTO yuj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aeria ono yumwan sénampon, ‘Kwar te koumteouráp arop fárákapao kwatae nɨnɨk ntia man wouroump sénap fwap tirá épér naenámpon. Aeno arop Kwaromp Yiki Kor Spiritan wouroump sénap fekamp kwatae nɨnɨk te tirá épér mono. ");
INSERT INTO yuj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Arop fárákapao Aropamp Tárápan kar kwatae sénap fekamp kwatae nɨnɨk te fwap tirá épér i konámpon. Aeno Kwaromp Yiki Kor Spiritan kar kwatae sénap te, Kwaro am fekamp kwatae nɨnɨk tirá épér mo nánko, oukoumwan taki yak, nánkár kor ankár taki yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tá Jisaso warko ankwap kar arakrá sér, “Kwapwe kare yao te kirao kor kwapwe kare ki tank námpon. Táte kwatae yao te, kirao kor kwatae ki tank námpon. Arop fárákap, kwapwe kare yao ni, kwatae yao nierá mér mwaria te kiran saráp nkea mér i konapon. ");
INSERT INTO yuj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yumo kwatae kare arop tákam-ti kwatae niamp te, yumo mokopia kwapwe kare karan sér mwanapon? Arop nɨnɨk mek kwatae nkwakwe make nɨnɨk yak námp te, am támao maomp táp meknámp am takeniamp kar sérar i konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kwapwe kare arop te maomp nɨnɨk mek kápae kare kwapwe kare nɨnɨk mwar yak námpara, maomp táp meknámp kor kwapwe kare nɨnɨk fekamp karan saráp sérar i konámpon. Arop kwatae te maomp nɨnɨk mek kápae kare nɨnɨk kwatae yak námpara, am kwatae nɨnɨk táman saráp sérar i konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aeno ono yumwan sénampon: Kwaro arop kot naenámp yae tokwae fek te, koumteouráp aropan yumo ponankor kar kwatae-námp nɨk mo, kwaporok sérar i konap, am fek yurukup nae-námpon. ");
INSERT INTO yuj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Amoku waráp sénap kar táman Kwaro yurukupia, amwan ‘Kwapwe kare arop’rá sér, tá ‘Amo kwatae arop’rá sénaenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aenánko am ke fek táman lo yénkrá farákáp konap arop ntia Farisi fákáre Jisasén sérrá, “Tisa, yino amo Kwaromp kárákáre yénkép napo, nke mwaro.” ");
INSERT INTO yuj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tá nopok Jisas am fárákapamp kar pwarokwaprá arakrá sér, “Mámá ke fekamp koumteouráp arop fákáre te Kwarén pwarnap koumteouráp arop kwataerao ‘Kwaromp kárákáre nke mwar’rá sénapono. Táte ono am fárákapan Kwaromp kárákáre fwap yénkép nanampan maok, am fek te profet Jonanimp Kwaromp kárákáreran saráp yénkép nanampono. ");
INSERT INTO yuj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Wokwaek kar Jona te éntékam tokwaeramp yare mek yámar yinɨnk, kumur yinɨnki yakámpon. Aeno Aropamp Tárápao kor kwar mek yámar yinɨnk, kumur yinɨnki yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wokwaek kar Ninive mekamp arop fákáre waeman Jona Kwaromp kar farákáp nánko wawia kwatae nɨnɨk pwar napon. Aeno mapek yaknámp arop ankwap te Jonan kámákár akwap námpan maok, yumo maomp kar younkwek sɨnapon. Aenapara, nánkár Kwaro koumteouráp arop fárákapan yurukup námp fek, Ninive mekamp arop fákáre Kwaro arop ponankor yurukup námp fek foukouri yakáprá yumoinap kwatae nɨnɨk érik farákáp mwanapono. ");
INSERT INTO yuj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wokwaek kar yae-mánkwan mwaek panek yaknámp kwin te apár faek karaok yak námpao maok, Solomono kwapwe kare yonkwae kour kar farákáp nánko, wa naeria koropámpon. Aeno mapek yaknámp arop ankwap te, Solomonén kámákár akwap námpan maok, yumo maomp kar younkwek sɨnapon. Aenapara, nánkár Kwaro koumteouráp aropan yurukup námp fek yae-mánkwan mwaek panek yaknámp Kwin am mek fokopeyakria, mámá ke fekamp koumteouráp aropamp kwatae nɨnɨk érik sérar naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisaso warko ankwap kar arakrá sér, “Aeno táte kwatae-arop arop ankwapan pwarará te, akwapea ént yak monámp apár mekmwaek yárak. Yárakria, am mek anepér sámp naenámp nap oupourounk námpao maok, mao nke mono. ");
INSERT INTO yuj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Aeria maok, mao sérrá, ‘Wampweno. Ono manénkɨr yakea koropnamp nap mek akwap nae’ ria koropea nke nánko, am nap te tɨri farákápea fwapokwapia pwate napo, am nap te kwaporok yak. ");
INSERT INTO yuj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aenánko te, mao warko akwapea ankwap fákánek kwatae-arop maomp kwatae nɨnɨkan kámákár námp éréképá koropea am nap mek tukupea yakáp. Wokwaek am arop te maomp pourouk kwatae-arop yak nánko, kwatae yakámpao maok, oukoumwan te warko ankár porok kwatae kare yak námpon. Tá taknámp oukoumwan mámá ke fekamp koumteouráp arop fárákapao kor, takeniamp arop yakáp mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas koumteouráp aropan am kar farákáprá yak nánko, maomp éntupwar ntia nánaeounáp koropea oumpwik furuk yakápria Jisasént kar sér mwaria. ");
INSERT INTO yuj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aenapo, arop ankwapao Jisasén sérrá, “Amo wawae! Waráp éntupwar ntia waráp nánaeounáp mámá amont kar sér mwaria koropá ek yakáp nape.” ");
INSERT INTO yuj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Táte Jisaso nopok am aropamp kar pwarokwaprá arakrá sér, “Onomp éntupwar te wanono? Onomp nánae te wanono?” ");
INSERT INTO yuj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aeria námoku éréképá yárak i konámp arop fárákapan yae kurépi fokoprá arakrá sér, “Amo nkeae! Onomp éntupwar ntia onomp nánaeou te mámá fárákapono. ");
INSERT INTO yuj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Arop onomp yámar mek yaknámp Naropwaromp nɨnɨkaok akwap námp te, támao maok onomp nánae, onomp antáp, onomp éntupwarono.” ");
INSERT INTO yuj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Am yámaraok táman Jisas am nap pwarará akwapea ekria maok, ént aokore tokwae woupwi fek tank. ");
INSERT INTO yuj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Aenánko, kápae kare koumteouráp arop koropea am fek koupoukour. Aenapo, mao am feknámp bot mek korokwapea tank nánko, koumteouráp arop ponankor ént woupwi mek foukouri yakáp. ");
INSERT INTO yuj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Aenapo Jisas am fárákapan kápae kare wounáp kar farákáp. Aeria sérrá, “Yumo wawenke! Arop ankárankamp akwapea yopwar mek ankankou yɨrɨr námpono. ");
INSERT INTO yuj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mao yɨrɨr nánko maok, ankankou ankwapmwaek mwae kupuk pɨká tankáp nánko, antao koropea fépér. ");
INSERT INTO yuj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tá ankwapmwaek péri kor yárákár námp fek pɨk nánko, kwar tokwae mo námp fek pɨká tankáp. Aeria kwar mek pɨk mo nánko, am ankankou wae koupour kar páre námpao maok, ");
INSERT INTO yuj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","yámar narek aokrá yokwap nánko, kwar kánanke kwarokia am arák yonkwaeria ankankou yákáre námpon. ");
INSERT INTO yuj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tá ankwapmwaek wiráp paok wi forokoraenámp mek pɨká tankáp nánko, am wiráp paok wi támao woukoupria oupoupouri yak. ");
INSERT INTO yuj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aeno ankankou ankwapmwaek kwar émi kwapwe mek pɨká tankáp námp te, waeman fwap párea, warko ki kwapwe tankáp i konámpon. Aeria ankwap 100 ki tankáp, ankwap 60 ki tankáp, ankwap 30 ki tankáp i konámpono. ");
INSERT INTO yuj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Arop woupwirápao námp kwamp te, mámá kar ankár wa kuno.” ");
INSERT INTO yuj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas am kar farákápea pwar nánko, maomp éréképá yárak i konámp arop fárákap koropea Jisasén turunkrá, “Amo apaeritea am fárákapan wounáp kar farákáp napono?” ");
INSERT INTO yuj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tá nopok Jisaso am fárákapan arakrá sér, “Kwaro náráp firáp taokeyak naenámp kar fi mek wouroumpeyak námp, Kwaro yumwan wae yénkép námpono. Aeno mámá arop fárákapan te mono. ");
INSERT INTO yuj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Táte arop Kwaromp kar kárákáre fek nɨki samp nánko te, Kwaro man warko ankwap nɨnɨk kwapwe méntér tapokwaprá kápae kare sánk naenámpon. Aeno táte arop kar wawia nɨki-samp mo námp te, Kwaro am nɨnɨk kánanke kwarok yak námpan maomp yaekamp pwarokwap naerámpon. ");
INSERT INTO yuj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Am taki yak námp táman, ono am fárákapan wounáp kar sénampon: Am fárákapao am ankank énounkoup napao maok, am fárákap te ankank ankwap wuri nke mono. Mao te kar wa mwaria woupwi pap napao maok, mao te wawia mér sámp mono. ");
INSERT INTO yuj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Am koumteouráp arop fárákapao mwanapan, profet Aisaia sérimp kar te wae érik korop námpon. Mao sérrá, ‘Yumo waeman kar wa napao maok, am kar fi te mér mo mwarea napon. Yumo wae énounkoup napao maok, ankank ankwap wuri nke mo mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Am koumteouráp arop fárákapamp nɨnɨk te kárákáre yak námpon. Aeria am fárákapao kar wawantá woupwi kákaria yi wouri yakáp napon. Aenapara, am fárákap te ankank ankwap nkeria, maomp woupwi kar wawia maomp nɨnɨk mek kar fi mérantánoria napara, mao warko arákarea ononampok korop napo, am fárákapan fwapokwaprá kákantáno.’ ");
INSERT INTO yuj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Aeno yiráp yi fwap ankank nke, tá yiráp woupwi fwap kar wawi konapara, Kwaro yumwan ourour sánk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ono yumwan kare kar sénampon, wokwaek kápae kare profet fákáre ntia yae-párák kare arop fárákap oukoumwan yumo nkenap ankank má nke mwar karapao maok, nke moiapon. Tá oukoumwan yumo wanap kar má wa mwar karapao maok, wa moiapon.” ");
INSERT INTO yuj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jisas am fárákapan sérrá, “Yumo am ankankou yopwar mek yɨrɨr i konap fekamp wounáp kar fi wawenk. ");
INSERT INTO yuj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Arop Kwaro náráp firáp taokeyak naenámp karan wa námpao maok, am kar fi fwapia mér mo nap te, mwaeaok pɨká tanknámp ankankou niampon. Satano koupour kar koroprá am kar Kwaro arop nɨnɨk mek ankank ounámp yɨmp námp te, mao ti-akwap konámpono. ");
INSERT INTO yuj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ankankou ankwapmwaek ankore mek péri kor yárákárnámp kwar yumuntuk pɨká tank námp te arop koupour kar kar wawia sámpea warákár. ");
INSERT INTO yuj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aenapao maok, am kar te arák kwar mek pɨk mono. Am te kánanke kwarok ke fek saráp yak nánko maok, mao Kwarén mérámp táman ankwapao námwan kar kwatae sérrá, nkwakwe make sokoro napo, maomp mér námp te koupour kar kwatae akwap konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tá ankankou ankwap wiráp paok wi fi mek pɨká tank námp te, arop wae kar sámp námpao maok, apárokamp ankankantá nɨnɨk tokwaerá kápae kare mani kénk naerianámp nɨnɨkao Kwaromp kar oupouroupá pap nánko, mao te ki tank mo námpon. ");
INSERT INTO yuj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aeno am ankankou kwapwe kare kwar mek pɨká tank námp niamp te, arop kar wawia am kar fi mér námpono. Aenánko mao fwap ki 100, 60, 30 arakrá tankáp konámpono.” ");
INSERT INTO yuj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Warko Jisas ankwap wounáp kar arakrá sér, “Yámar mekamp Kwaro náráp firáp taokeyak konámp te, arop ankwapao wit ou yopwar mek yɨrɨr i konámp niampon. ");
INSERT INTO yuj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aenámpao maok, am koumteouráp arop pampi yakáp napo, kumuruk maomp yopor arop kánánkámp koropea kwatae apwar pwae ki wit fi mek yɨrɨria pwarará akwap te. ");
INSERT INTO yuj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wakmwaek am wit párea wae ki tank naeria nánko, nke napo, am apwar pwae kwataeao kor mént forokor. ");
INSERT INTO yuj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aenánko, am yopwar mek tére konap arop tukupea yopwar naropwarén sérrá, ‘Arop Tokwae, yino nɨk námp te, amo waráp yopwar mek te ankankou kwapwe mwar yoroi napono. Mokopia apwar pwae kwatae am mek yakáp námpono?’ ");
INSERT INTO yuj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Aerapo maok, mao am fárákapan sérrá, ‘Yopor arop ankárankampao am apwar pwae kwatae sɨra námpon.’ Aeránko, am tére aropao sérrá, ‘Ae te amo nɨk nap te, yino tukupea am apwar pwae kwatae moroprá koupoukour mwanámp nie?’ ");
INSERT INTO yuj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aerapo maok, nopok mao am fárákapan sérrá, ‘Mono! Yumo takria apwar pwae kwatae moroprá wit méntér morop mwanape. ");
INSERT INTO yuj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Énénkér taki yakea nepo, nánkár wit moropnap ke fek yumo apwar pwae kwataeran mékɨr moroprá pupuria yaomwi mek yanki pwatea, wakmwaek wit koupoukarea onomp fɨr kák konamp nap mek kák mwanapono.’” ");
INSERT INTO yuj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tá warko Jisas am fárákapan wounáp kar arakrá sér: “Kwaro náráp firáp taokeyak konámp te, arop ankárankao mastet ou sámpea yopwar mek yoroinámp niampon. ");
INSERT INTO yuj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Am mastet ou te ankwap ankankou niamp tokwae mono. Am te kánanke kwarok kareno. Aenámpao maok, nánkár wakmwaek akwapea tokwaeria te ankwap pourouráp yopwar mekamp fɨran kámákár akwap námpon. Akwapea yao niamp nánko, antao kor fwap koropea am yowe mek tankáp i konámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tá warko Jisas ankwap wounáp kar arakrá sér, “Kwaro náráp firáp taokeyak konámp te yis niampon. Yupu ankárankampao am yis sámpea plaua dis mek yokwapea méntér arákareanánko, yámpea tokwae kar i konámp niampono.” ");
INSERT INTO yuj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Am kápae kare kar Jisaso koumteouráp aropan farákáp námp te wounáp kar mwar farákáp námpono. Mao te am fárákapan érik farákarrá kar ankwap sér mono. Ankár wounáp kar mwar farákáp námpono. ");
INSERT INTO yuj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aenámpan am te wokwaek profet ankwapao sérimp kar méntér pwi námpono. Wokwaek mao sérrá, “Ono am fárákapan kar farákáp nanamp te wounáp kar fek sénanampon. Ono am arop fárákapan wokwaek Kwaro mámá apár yoro námp feknámpia mek wouroumpea yakrá koropea oukoumwan námpan sénanampon.” ");
INSERT INTO yuj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Takia pwarará Jisas koumteouráp aropan párakoprá wae nap mek akwap. Aenánko maomp éréképá yárak i konámp arop fárákap koropea man sérrá, “Amo yinan am apwar pwae kwatae yopwar mek forokornámp wounáp kar fi farákápae.” ");
INSERT INTO yuj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tá nopok Jisaso am fárákapan arakrá sér, “Arop kwapwe kare ankankou yoro námp te Aropamp Tárápono. ");
INSERT INTO yuj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yopwar te mámá apárono. Kwapwe kare ankankou te Kwaro náráp firáp taokeyak-námp mekamp koumteouráp aropono. Apwar pwae kwatae te Satanomp koumteouráp aropono. ");
INSERT INTO yuj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Am apwar pwae ou kwatae yɨrɨr námp te Satan nono. Am fɨr yápaenámp ke te mámá apár pwar naenámp yaenono. Yopwar mek tére konap arop te ensel fákáreno. ");
INSERT INTO yuj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Am apwar pwae kwatae koupoukarea yaomwi mek yankap nap te taknámp nánkár mámá apár pwarnámp yae fek tak mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aropamp Táráp mao náráp ensel fákáre tirá kérép nánko, náráp firáp taokeyaknámp mekamp arop fárákapan mérnap kwatae pap konámp ankank, ntia kápae kare kwatae nɨnɨknap arop fárákapan fárarámprá párakop mwanapono. ");
INSERT INTO yuj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Am fárákapan tia yaomwi tokwae mek épéri tenapo, am yaomwi mek yakáprá éménka waeria yu kɨkɨmpia wae mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Am ke fek táman yae-párák kare koumteouráp arop fárákap te náráp Naropwaro maomp firáp taokeyaknámp mek yakáprá yámarnámp wae tákapá yakáp mwanapon. Arop woupwirápao námp kwamp te, ankár mámá kar má wa kuno.” ");
INSERT INTO yuj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tá Jisaso warko arakrá sér, “Kwaro yámar mekamp náráp firáp taokeyak námp te make niampon: Maniráp bokis yopwar mek manénkɨr kwar mek wouroump tenapo, arop ankwapao akwapá kwar yokoropea nkeaka warko oupouri pwar. Aetea mao warákár karia akwapá námokuráp ankank ponankor koupoukarea arop nénkria, am fek mani sámpea warko am mani fek yopwar am sámp námp niampon.” ");
INSERT INTO yuj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tá ankwap wounáp kar arakrá sér: “Kwaro yámar mekamp náráp firáp taokeyak konámp te, arop ankwap solwara mekamp anani kor émi kwapwe kare bisnis téreria am fek mani sámp. ");
INSERT INTO yuj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ae konámpao, mao nke nánko, anani kor ankwap ankárank kwapwe kare kare nánko, mao akwapea námokuráp ankank ponankor nénkria mani tia, am mani fek am anani kor kwapwe námoku naenámp sámp námp niampon.” ");
INSERT INTO yuj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisaso ankwap wounáp kar arakrá sér: “Kwaro yámar mekamp náráp firáp taokeyak konámp te arop ankwap ént aokore mek umben sɨrarea kápae kare nkwakwe make éntékam ti. ");
INSERT INTO yuj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Am umben mek te top pwarámpeyak nánko, forokwapea sakwap paprá tankáprá, baket mek éntékam am kwapwe karenámp kákrá, kwatae éntékam épér i konap niampono. ");
INSERT INTO yuj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nánkár mámá apár pwarnámp yae fek taknámp mwanapono. Ensel fákáre ékia yae-párák kare arop ou mek kwatae nɨnɨkráp arop yakáp napan farámprá párakop mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Am fárákapan tia yaomwi tokwae mek épér tenapo, am fárákap yaomwi tokwae mek yakáprá éménka waeria yu kɨkɨmpia wae mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisaso námoku éréképá yárak i konámp arop fárákapan turunkrá, “Yumo te mámá kar fi ponankor wae mér nap nie?” Aeránko maok, nopok am fárákapao Jisasén sérrá, “Yeno.” ");
INSERT INTO yuj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aerapo Jisaso am fárákapan sérrá, “Wokwaekamp lo mérap arop fárákap te Kwarén méria náráp firáp wourékam taokeyak konámp mek korop napao maok, am fárákap te arak napono: Nap naropwaro náráp nap mekamp maniráp ankank wourékam épirént ankár mek tapokwapea tia érik ti-mank námp niampon.” ");
INSERT INTO yuj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas am wounáp kar farákápea pwarará am némp pwarará akwap. ");
INSERT INTO yuj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mao akwapea námokuráp taun mekria am fekamp koumteouráp arop am fárákapan námokuráp lotu nap mek Jisaso kar farákáp. Aenánko am fárákap wawia kokorokoria sérrá, “Am mámá mér ntia Kwaromp kárákáre yénkép námp máte maokamp sámpea námpon? ");
INSERT INTO yuj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mámá arop te kamdamp tárápono. Maria te maomp éntupwarono. Jems, Josep, Saimon, Judas, am fárákap te maomp nánaeounápono. ");
INSERT INTO yuj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Maomp antáponáp fákáre te nomont yakáp napono. Maomp mér ponankor te maokamp sámp námpono?” ");
INSERT INTO yuj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aeria am fárákap Jisasén kokwarok. Aenapan maok, Jisas am fárákapan sérrá, “Profet te kápae kare némpouk e yak námpono. Aenámpan maok, mao námokuráp némpouk, tá námokuráp nap kare mek te e yak mono.” ");
INSERT INTO yuj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aenámpara, Jisaso am taun mek Kwaromp kárákáre kápae kare yénkép mono. Waeman mér mo napantá námpon. ");
INSERT INTO yuj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Am ke fek Galili taokeyak konámp Gavman Heroto Jisas térenámp kar korop nánko wa. ");
INSERT INTO yuj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Mao náráp tére aropan sérrá, “Am arop te arop ént mek nérrá kák konámp Jono warko apár me meknámp fárámp námpono. Aenámpara, maomp yaek-námp Kwaromp kárákáre tokwae korop námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Am te arakimp: Wokwaek Heroto náráp nánae Filipomp yupu Herodiasén pwarokwap nánko, Jono Herotén sérrá, “Amo sámpnap yupu Herodias am te pwi yak mo námpon.” Aeránko maok, Heroto Jonén sámpea sen fek yarokwapea kalabus nap mek páte napo yakámpon. ");
INSERT INTO yuj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mao Jonén sámp-wouroump naerianámpao maok, koumteouráp arop fárákap te, Jon te profetonoria nɨnɨk nap ara, mao am fárákapan apápria man sumpwi pap mo, párák kalabus mek páte nánko yak. ");
INSERT INTO yuj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aenámpan maok, ankwap yae fek Heroto námwan éntupwaro sámpámp yaeran nɨkia fɨr kékérouria arop éréképeanánko, koupoukarrá fépér. Aenánko, am ke fek am Herodiasomp namom énki am arop ou mek kaerá yárak nánko, Herot nkea warákár tokwae. ");
INSERT INTO yuj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Aeria maok, man kar papria sérrá, “Kare kar yámar mek yak námpráp amo námwan sápaeria sénap ankank te ankár sénap táman sánk nanampono.” ");
INSERT INTO yuj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aeránko maok, maomp éntupwar Herodiaso Jonén yonkwae pwarámpámp kwamp sumpwianoria man nɨnɨk sánkria sérrá, “Amo Herotén sénapo, arop ént mek nér i konámp Jonomp me kor karámp-fárákapea plet mek papea sánk naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aerá sénánko maok, king te, mokop tak naeria nɨnɨk tokwae. Aenámpao maok, kápae kare arop fákáre koupoukarrá tankáprá fánap, mao wa nap fek fou e séri tenámp kwamp maok, ‘Sánkenk’rá sérimpon. ");
INSERT INTO yuj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mao arop ankárank sámp-kérép nánko, kalabus nap mek akwapea Jonomp yápare kor karámp-fárákap. ");
INSERT INTO yuj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Takia am yépe kor plet mek papea sankoropá am yupu-tárápan sánk. Aenánko mao sámpá akwapea éntupwarén sánk. ");
INSERT INTO yuj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aenapo maok, Jono éréképá yárak i konámp arop fárákap koropea maomp yákáre samp-tukupea apár me mek papea pwarará, am fárákap tukupea Jisasén sériapono. ");
INSERT INTO yuj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas Jon sumpwimp am kar wawia am yaknámp némp pwarará bot sámpea arop yak mo apár mek námoku mwar ampok akwap naeria akwap. Aenánko maok, koumteouráp arop mao akwap námp wawia am yakápnap némp pwarará, Jisas akwap tenámp mwaek apáraok tukup. ");
INSERT INTO yuj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wakmwaek Jisas akwapea ankwapmwaek woupwi fek nke nánko, kápae kare koumteouráp arop ou má néntépá yakáp. Aenapo, Jisaso am fárákapan yonkwae touweria maomp pouroukamp touwe fwapokwaprá kák. ");
INSERT INTO yuj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tá wae kumur mek maomp éréképá yárak i konámp arop fárákap maonámpok koropea Jisasén sérrá, “Mámá ke mek te arop yakáp mo napo, wae kumur naeria námpono. Amo mámá koumteouráp arop wae tirá kérép napo, wonae fik mwaekamp némpouk tukupanápono. Aeria námokuráp mani fek fɨr tirá fáranápono.” ");
INSERT INTO yuj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aerapo maok, nopok Jisaso sérrá, “Apaeritea tukup mwanapono? Yumo támao fɨr nénkenke.” ");
INSERT INTO yuj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tá nopok am fárákapao sérrá, “Yino te mapek fɨr tank mono. Pan yankapramp éntik, tá éntékam anánkaopwe arakia támao saráp tank námpono.” ");
INSERT INTO yuj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aerapo maok, Jisas am fárákapan sérrá, “Am fɨr onomp wonae fik mapek ti-koropenke.” ");
INSERT INTO yuj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aeria maok, koumteouráp arop fárákapan sérrá, “Apwar pwae fek tankápenke.” Aeria maok, mao am pan éntik, tá éntékam anánkaopwe takia yaek tia fákeyakrá yámar mek tokore yakrá Kwarén ‘Aesio’rá sér. Aea pwarará, am pan fápákária, mao námoku éréképá yárak i konámp arop fárákapamp yaek nénk nánko, mao am koumteouráp arop táman nénk. ");
INSERT INTO yuj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aenapo, am arop fárákap ponankor fépéria wae yare. Aenapo, fɨr ankwapmwaek tankáp nánko, koupoukarea éntér-sámpramp basket mek kákapo, top-popwarámpimpon. ");
INSERT INTO yuj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Am arop fárákap te 5,000 niamp arakerao fáriapon. Am te koumteou tárápu te kouroump mono. ");
INSERT INTO yuj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisaso námoku éréképá yárak i konámp arop fárákapan sérrá, “Yumo manénkɨr bot mek kounkouria ént aokore ankwapmwaek fi mwaek tukupenke.” Aeria maok, námoku mwar koumteouráp arop fárákap tirá kérép naeria. ");
INSERT INTO yuj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mao koumteouráp arop tirá kérépá pwarará, námoku mwar narek faonkwe wi fek Kwarén kar toropwap naeria. Wae kumur nánko, mao námoku mwar am faonkwe wi fek yak. ");
INSERT INTO yuj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bot waeman akwapea ént aokore tokwae kuk nánko, ouwi bot me kour mwaeknámp koropea bot panánkár. ");
INSERT INTO yuj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aenánko, wae wakor naenámp fápae nánko, Jisas námoku ént yumunturik koropea am fárákapamp wonae fik. ");
INSERT INTO yuj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aenánko, am fárákap mao ént yumunturik koropnámp nkea, kour me woukouria sérrá, “Námwan nkote! Ént arop kwataerao korop ri kane!” Aeria apápria fépénénka wae. ");
INSERT INTO yuj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aenapo, Jisas am fárákapan koupour kar sérrá, “Yumo sánánkar kárákáre fek yakápenke! Máte ono támao korop nampono. Yumo apápi kwapono!” ");
INSERT INTO yuj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aeránko maok, tá Pita maomp kar pwarokwaprá arakrá sér, “Tokwae Kar e! Amo nap kwamp te, amo onan sénapo, ono kor ént yumunturik amonapok korop nae.” ");
INSERT INTO yuj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aeránko maok, Jisaso man sérrá, “Amo koropae!” Aeránko, Pita wae bot pwarará ént yumunturik Jisasnámpok akwap. ");
INSERT INTO yuj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aenámpao maok, ouwi tokwaeran nkea apápria wae, ént mek pɨkria Jisasén sérrá, “Tokwae Kar, amo onan yaewourae!” ");
INSERT INTO yuj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aeránko Jisaso koupour kar yae paprá Pitan yae tokoropea sérrá, “Amo te mér tokwae mono. Amo apaeritea anánkaopwe nɨnɨk sámp napon?” ");
INSERT INTO yuj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aeria Jisas ntia Pita wae bot mek korokwap nepo, ouwi tokwae wae pwar. ");
INSERT INTO yuj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aenánko bot mek tankápnap arop fárákap man loturia sérrá, “Kare kar, amo te Kwaromp Tárápono!” ");
INSERT INTO yuj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mao wae am ént aokore kuk meknámp pirékarrá tukupea nkwamwaek fik apár Genesaret mek. ");
INSERT INTO yuj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aenapo am mekamp koumteouráp arop Jisasén wuri nkea maok, am fek wonae fik mwaekamp kápae kare némpouk kar sámp-kérép napo, am fárákapao kápae kare touwenap arop Jisasnámpok éréképá korop. ");
INSERT INTO yuj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Aeria am fárákapao Jisasén sérrá, “Amo taki yakrá, waráp pourou yénképá yak napo, am arop fárákapao waráp waempyam fu fek toupoukour napo, am fárákapamp touwe wae fwap naenámpon.” Takrá séri pwarará maok, maomp pouroukamp waempyam fek yae papnap arop fárákapamp touwe warko wae fwap námpono. ");
INSERT INTO yuj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Am ke fek Farisi fákáre ntia lo mérnap arop fárákap Jerusalem meknámp Jisasnámpok koropea sérrá, ");
INSERT INTO yuj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Apaeritea amo éréképá yárak i konap arop fárákap nomp appeyaenápo nomwan sápap lo kar ták-sɨnapono. Am fárákap fár mwarianap ke fek te yae yárár i konapaok mo nap tene.” ");
INSERT INTO yuj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nopok Jisaso am fárákapamp kar pwarokwaprá arakrá sér, “Apaeritea yumo Kwaromp lo kwe-pwarará, yiráp tékénouamp loaok saráp tukup napon? ");
INSERT INTO yuj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Am te Kwaro sérrá, ‘Amo ankár waráp éntupwar naropwaromp karwaokampo.’ Tá ‘Arop náráp éntupwar naropwarén kar kwatae séria te, am arop ankár sumpwi naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Aeno yumo te arop fárákapan ‘Arakenk’rá sér i konapon: ‘Yumo mani ankank yiráp éntupwar naropwarén yaewour mwanapan kor, am anánkwapan sérrá, “Ono wae am ankank te Kwarén sánk nanampria nánapi páte nampara, yumwan nénk mono”rá fwap sénanapono.’ Yumo aerá sér i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Am taknap nɨnɨk támao yumo Kwaromp kar apárok sámp-anámprá yiráp tékénou káknap loan saráp narek samp-tukup napon. ");
INSERT INTO yuj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yumo te kwekár i konap aropono! Profet Aisaia te waeman yumwan táman kare sénámpon: ");
INSERT INTO yuj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Am arop fárákap te náráp kar mwar onomp e sakap napono. Aeno maomp nɨnɨk te onan panek yakáp napon. ");
INSERT INTO yuj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Am fárákap aropamp lo karan saráp farákápria sérrá, “Máte Kwaromp karono.” Aenapara, am fárákap te onan kwaporok mwar lotu napono.’” ");
INSERT INTO yuj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aerá séria maok, Jisas koumteouráp aropan koropenkrá wumwiria maok sérrá, “Yumo te fwapi wawia nɨnɨk kourenke. ");
INSERT INTO yuj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ankank táp mek pɨk námp te arop nɨnɨk mek kwatae pap mo i konámpono. Aeno ankank arop nɨnɨk mek yak námpao maomp táp meknámp ek oukur korop námp te, am támao arop nɨnɨk mek kwatae pap námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Am ke fek táman Jisas éréképá yárak i konámp arop fárákap koropea Jisasén sérrá, “Ae te amo Farisi fákáre waráp kar wawia kokwarok nap te wae mér rape?” ");
INSERT INTO yuj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aerapo maok, nopok Jisas arakrá sér, “Onomp yámar mekamp Naropwar te mao wae yopwarrápono. Kápae kare ankank mao námoku yoro moi tari námpan te, am ponankor fi make mokwap naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yumo am Farisi fákáre námoku mwar taki yakápanápon pwarenke! Am fárákap te yi wuri yakáp napao ankwap yi wuri yakápnap arop fárákapan mwae kup yénkép mwaria napon. Aenapan maok, yi wurumpi yaknámp arop ankwap yi wurumpi yaknámp aropan mwae kup yénképria te, énénkér apár me mek pɨk nerea nepon.” ");
INSERT INTO yuj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Táte Pita Jisasomp kar pwarokwaprá arakrá sér, “Amo am arop nɨnɨk mek oumi papnámp kar fi wounáp nap yinan érik farákarrá sénapo, yino wa mwaro.” ");
INSERT INTO yuj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisas nopok sérrá, “Yumo kuri oukoumwan épérép rape? ");
INSERT INTO yuj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ae te kápae kare ankank táp mek pɨkianánko, yare mek tankea tukwi mwae-párák akwapea tukwi nap mek pɨk námp te mér mák rape? ");
INSERT INTO yuj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aeno ankank táp meknámp ek oukur korop námpao maok, am te nɨnɨk meknámp korop námpon. Aenámpara, am támao maok arop nɨnɨk oumi pap konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ankank nɨnɨk meknámp koropánk i konámp te arakono: Nɨnɨk kwataenap, táte arop sámp-wouroump mwanap nɨnɨk, tá poumou nap mekamp yupu kokopor mwanap nɨnɨk, tá pwarápae sánk konámp kokopor nɨnɨk, tá oukun i konap nɨnɨk, tá arop kot nap fek kwekárrá sér i konap nɨnɨk, wouroump sokwak i konap nɨnɨk. ");
INSERT INTO yuj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ará ankank támao maok, arop nɨnɨk mek oumi pap konámpon. Aeno arop manénkɨr yae yárár moi yakrá fɨr fárámp te aropamp nɨnɨk mek oumi pap mono.” ");
INSERT INTO yuj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas am némp pwarará ankwap fi arop yakápnap taun Tair ntia Saidon mekmwaek akwap. ");
INSERT INTO yuj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aenánko Kenan fi mekamp yupu ampok yak námpao maonámpok koropea Jisasén tékén arakrá sér, “Tokwae Kar, Devitomp ou fekamp táráp e! Amo ankár onan aropompae! Kwatae-arop onomp yupu-tárápamp pourouk woukoupea kwatae papáne!” ");
INSERT INTO yuj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aeránko maok, Jisas te am yupuan kar pwarokwaprá sér mono. Mao éréképá yárak i konámp arop fárákapao koropea Jisasén sérrá, “Mámá yupu má nomp wakmwaek wumwirá koropáne. Amo sámp-kérép napo akwapano.” ");
INSERT INTO yuj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aerapo maok, tá nopok Jisaso sérrá, “Kwaro onan ankwap firan yaewouraeria sámp-kérép mo. Israel fi mekamp sipsip moyakáp napantá Kwaro onan sámp-kérép námpono.” ");
INSERT INTO yuj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aeránko maok, am yupu koropea Jisasomp wonae fik kwaráp torokomprá me kor woukoupria sérrá, “Tokwae Kar, amo onan yaewourae!” ");
INSERT INTO yuj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tá nopok Jisaso maomp kar pwarokwaprá wounáprá sér, “Takria nomo tárápuamp fɨr sámpea asan sánkantáno.” ");
INSERT INTO yuj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aeránko maok nopok yupuao sérrá, “Tokwae kar e! Amo te waeman kare kar sénapon. Aeno nap mek yakápnap as te naropwaro fánámp fɨr tɨri párakop pɨkrɨnk nánko, fwap am tirá fári konapono.” ");
INSERT INTO yuj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mao aerá séránko maok, Jisaso am yupuamp kar pwarokwaprá arakrá sér, “Waráp mér te tokwae kar námpara, amo sámp naeria kɨkiank nap take pourouráp amo fwap sámp nanapon.” Aeránko maok, am ke fek táman maomp yupu-táráp wae fwapimpono. ");
INSERT INTO yuj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Oukoumwan Jisas am némp pwarará Galili ént aokore wonae fik akwap. Aea mao pokea narek faonkwek tank. ");
INSERT INTO yuj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aenánko, kápae kare koumteouráp arop fárákap koropea maomp wonae fik koupoukour. Am fárákapao pu kwataenap arop, yi néneráp arop, kour korokorenámp arop, tá top kor aompi yaknámp arop, tá kápae kare ankwap touwenap aropan kor éréképá koropea Jisasomp pu wonae fik kák. Aenapo, mao am arop fwapokwaprá kák. ");
INSERT INTO yuj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aenánko am arop fárákap táman nkea kokorokoria sérrá, “Wakwe! Am top kor aompiyaknámp arop kar sénámpwae! Kour korokorenámp arop warko fwap námpwae! Tá pu kwataeráp arop fwap yárak námpwae! Tá yi néneráp arop fwap nke námpwae!” Aeria maok, am fárákap Israel firamp Kwaromp e sakapiapon. ");
INSERT INTO yuj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Takia pwarará Jisas námoku éréképá yárak i konámp arop fárákapan wumwi nánko, korop napo sérrá, “Ono mámá arop fárákapantá yonkwae touwe nampono. Mao onont wae yinɨnk yae yakápi napao fɨr mo námpono. Ono te yae porokwe make tirá kérép mono. Takria arop ankwap yae porokweraoia mwaeaok poporokweantáno.” ");
INSERT INTO yuj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tá nopok mao éréképá yárak i konámp arop fárákapao sérrá, “Máte arop yak mo apárono. Nomo maokamp kápae kare pan mámá arop ou tokwae má pwi naenámpono?” ");
INSERT INTO yuj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tá nopok Jisaso am fárákapan sérrá, “Yumo pan apaekamp tankáne?” Nopok am fárákapao sérrá, “Yinomp pan te fákánek tank námpono. Tá ankákárank éntékam kánanke tankáp námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aerapo maok, tá Jisaso am koumteouráp aropan sérrá, “Yumo apárok tankápenke.” ");
INSERT INTO yuj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mao am pan fákánek sámp, éntékam ankákárank tia Kwarén ‘Aesio’rá séri pwarará, fápákária mao éréképá yárak i konámp arop fárákapamp yaek nénk. Aenánko, am koumteouráp aropan nénk napo, ");
INSERT INTO yuj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","wae ponankor fépéria pwi. Aenapo maok, tá oukoumwan ankwapmwaek tankáp nánko, Jisasomp arop fákáre am fɨr koupoukarea fákánek basket mek kák napo, top koupour yak. ");
INSERT INTO yuj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Am fárap arop te 4,000 niamp arake. Aenámpan maok, yupu ntia táráp te kouroump mono. ");
INSERT INTO yuj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Takia Jisaso am koumteouráp arop fárákap tirá kérépea pwarará, bot mek korokwaprá apár Magadan mekmwaek akwapámpon. ");
INSERT INTO yuj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi fákáre ntia Sadyusi fákáre koropea Jisasén mokoponrá nke mwaria man sérrá, “Amo ankár yámar mekamp Kwaromp kárákáre yénkép napo, yino nke mwaro.” ");
INSERT INTO yuj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aeapan maok, nopok Jisas am fárákapan sérrá, “Kumur mek yumo nke napo, yámar noumouri nánko, nkea sérrá, ‘Oukoumwan te yámar kwapwe naeane.’ ");
INSERT INTO yuj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tá koumounek yumo arakrá sér i konapono: ‘Yámar mek támáre nánko, oukoumwan te ouwi warákam korop naeane.’ Tá kare! Yumo waeman take pourouráp ankank nkea yae-párák yámar mek yurukup i konapan maok, yumo oukoumwan mámá ke fek koropánknámp ankank fwapia yurukup mo napon. ");
INSERT INTO yuj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yumo te Kwarén pwarnap koumteouráp arop kwataerao ‘Kwaromp kárákáre nke mwar’rá sénapon. Aenapan maok, ono yumwan Kwaromp kárákáre ankwap ankárank yénkép mono. Yumo Jonanimp kárákáre aran saráp nke mwanapono.” Aerá séria Jisas wae am fárákapan pwarará akwap. ");
INSERT INTO yuj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisaso éréképá yárak i konámp arop fárákap wae ént aokore tokwae tápampea tukupea nkwamwaek fik napao maok, am fárákap te pan sámp mo, nɨk mo pwarará tukup. ");
INSERT INTO yuj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aenapo maok, Jisaso am fárákapan sérrá, “Yumo fwapia taokeyakápria yumo Farisi fákáre ntia Sadyusi fákáreramp yisan mér kar kipo. ");
INSERT INTO yuj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aenánko, am arop fákáre námoku támao téréménkrá arakrá sérarrá, “Am te nomo pan sámp mo, yaenémpi korop námpan sénámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas wae am fárákapamp kar wawia sérrá, “Yumo te yiráp mér kánanke kare námpono. Yumo apaeritea yumoku sérarrá, ‘Yino pan mo námp’rá sérarapon? ");
INSERT INTO yuj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ae te yumo oukoumwan mér mo nap nie? Ae te yumo 5,000 aropao pan éntik fépéria napo te, apaekamp basket mek tirá kákapono? ");
INSERT INTO yuj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ae te yumo pan fákánek 4,000 aropao fépéria napo, ankwapmwaek tankáp nánko te, apaekamp basket mekia kákapono? ");
INSERT INTO yuj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ae te mokopono? Yumwan ono ‘Pan sámpenk’rá sér moi namp te, yumo mér mo napon? Ono sérrá: Yumo ankár Farisi fákáre ntia Sadyusi fákáreramp yis te yumo ankár fwapia mér kar kipo.” ");
INSERT INTO yuj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aeránko maok, am fárákapao wae mér, Jisas te ankár ‘Pan mekamp yisan mér kar kip’rá sér mono, ‘Am fárákap ankár Farisi fákáre ntia Sadyusi fákárerao yénkrá farákáp konap karan mér kar kip’rá sénámponrá nɨnɨkiapon. ");
INSERT INTO yuj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas akwapea taun Sisaria Filipai mekmwaekria maok, mao námoku éréképá yárak i konámp arop fárákapan turunkrá, “Koumteouráp arop fárákap te Aropamp Táráp onan te wanonorá sénapon?” ");
INSERT INTO yuj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aerá turunkánko maok, am fárákapao sérrá, “Amwan te ankwap fárákapao ‘Arop ént mek énér i konámp Jon’rá sér. Ankwap fárákapao ‘Mao te Elaija’rá sér. Ankwap fárákapao ‘Mao te Jeremaia’, tá ‘Ankwap profet’rá sénapon.” ");
INSERT INTO yuj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aerapo maok, tá Jisaso am fárákapan sérrá, “Yumoku kare te onan te ‘Wa’rá sénapon?” ");
INSERT INTO yuj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aeránko maok, Saimon Pita maomp kar pwarokwaprá arakrá sér, “Amo te Krais, amo yiki yak konámp Kwaromp Tárápono.” ");
INSERT INTO yuj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aeránko maok, Jisas maomp kar pwarokwaprá arakrá sér, “Jonomp táráp Saimon, Kwaro amwan ourour sánk nánko, amo waeman kare sénapono! Apárokamp arop ankwapao am kar amwan yénkép mono. Onomp Naropwar yámar mek yak námp mao támao amwan yénkép námpono. ");
INSERT INTO yuj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ono amwan sérrá: Amo te Pita. Amo te yumwino. Ono am yumwi yumuntuk onomp sios am fek yoro nanampono. Aenanko sumpwiramp kárákáre te am siosén apárok tirá épér mono. Ono amwan Kwaro náráp firáp taokeyak konámp némpoukamp ménki fekamp ki sánk nanampono. ");
INSERT INTO yuj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Apae ankank amo apárok mapek taokor napo te, Kwaro kor yámar mek taokor naenámpon. Tá apae ankank apárok mapek aokorop pwar napo te, Kwaro kor yámar mek aokorop pwar naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aeria maok, Jisaso námoku éréképá yárak i konámp arop fárákapan kar kárákáre fek ‘Yumo arop ankwapan “Mao te Krais támaono”rá séri kwapono’rá sérimpon. ");
INSERT INTO yuj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Takia pwarará am ke fek táman Jisaso mao éréképá yárak i konámp arop fárákapan sérrá, “Ono ankár Jerusalem mek akwap nanampon. Aenanko, lotu taokeyakáp konap arop ntia pris tokwae fákáre, tá lo yénkrá farákáp konap arop mao onan touwe tokwae sáp napo, sámp nanampon. Takia am fárákapao onan faropea pap napo, péri me mek páte napo, yinɨnki yakea nanko, Kwaro onan warko fárámpá pap naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aeránko Pita man warámpá akwapea mwar fek yoporrá sér, “Tokwae Kar, amo te tak mo karenono. Amo am sénap kar te waráp pourouk koropantáno.” ");
INSERT INTO yuj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aeránko maok, Jisaso sámp-arákarrá Pitan nkea sérrá, “Satan, amo nkwampok akwapae! Amo onomp mwae kup taokor kwapono. Amo te Kwaromp nɨnɨkaok mono, aropamp nɨnɨkaok saráp napon.” ");
INSERT INTO yuj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aeri pwarará Jisas náráp éréképá yárak i konámp arop fárákapan sérrá, “Arop onomp wakmwaek korop naenámp kwamp te, ankár námokuráp nɨnɨk te wampwe pwarará, ono touwe sámp nampaokria maok, onomp wakmwaek korop naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Arop námokuráp yiki yak námp sámp-fákeyak naerianámp te, maomp yiki yak te akwapá moyak naenámpon. Aeno táte arop ankwap onan nɨnɨkria náráp yiki yak wampwe pwar námp te, mao fwap námokuráp yiki yaká yak sámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Táte arop ankwap apárokamp kápae kare ankankan saráp sámprá yak námpao maok, mao yiki yaká yak naenámp mo nánko te, am kápae kare ankank te mokopia man yaewour naenámpon? Arop te apae ankank man sánk nánko, warko náráp yiki yak naenámp am fek yamokwapea sámp naenámpon? ");
INSERT INTO yuj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ono makrá sénamp te, Aropamp Táráp maomp Naropwaromp wae tokwae ntia maomp ensel fákáre méntia ék naenámpon. Am ke fek mao ponankor koumteouráp aropaoinap ankank yurukupia nopok take pourouráp nénk nae-námpon. ");
INSERT INTO yuj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ono yumwan kare kar sénampon: Mámá yakápnap arop ankwap fárákap oukoumwan sumpwi mo, yakápria, manénkɨr Aropamp Táráp king yoroia ék námp ankár nke mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Takia tokwampok yae akwap tenánko, Jisaso Pita, Jems, maomp ankwapnáp Jon, makia éréképea ankwap faonkwe tokwae narek karaok pokea, mao námoku mwar yakáp. ");
INSERT INTO yuj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aeapo maok, am fárákapao nke nap fek Jisasomp pourou mwar pourourápi akwap. Maomp yimetáp te yámarao tákapnámp wae tokwae niamp, tá maomp waempyamráp ankank te wupwi kor kareria, wae tákapa wae. ");
INSERT INTO yuj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aenánko, wokwaek kar yakep arop yawor Moses ntia Elaija am fek koropea méntér yakria Jisasént kar sénepo, am arop yaworan kor wae nke. ");
INSERT INTO yuj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aeria maok, Pita am táman nkea Jisasén sérrá, “Tokwae Kar e! Nomo mapek yakáp mwanámp te kwapwe kareno. Amo ‘Takae’rá sénapo te, ono fwap sákae yinɨnkaopwe mapek woukour nanampono. Ankwap waráp por, ankwap Mosesompor, ankwap Elaijampor.” ");
INSERT INTO yuj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Oukoumwan takrá sérrá yak nánko, am fek táman wae tákap-námp koumwe wupwi ékia am fárákapan oupouroup. Aenánko am meknámp arop kar niampao am yinɨnkaopwean sérrá, “Mámáte onomp Tárápono. Ono man warákár tokwaeria ono man yonkwae kárámp nampono. Yumo ankár maomp kar wa kipo.” ");
INSERT INTO yuj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aeránko, am arop yinɨnkaopwe am kar wawia me kor woukourrá apárok yimetáp kákrá apáp tɨrɨnka waeapon. ");
INSERT INTO yuj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aenapo Jisaso am fárákapamp wonae fik koropea maomp pourouk yae papria sérrá, “Yumo apápi kwapono. Ferámpenke!” ");
INSERT INTO yuj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aeránko ferámprá narek nke napo maok, arop ankwap te yak mono. Jisas mwar yak nánko nke. ");
INSERT INTO yuj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Takia maok, mao wae faonkwek pwarará émpi fek pɨkria Jisaso am fárákapan kar kárákáre sérrá, “Yumo arop ankwapan yumo nkenap ankank mámáte séri kwapono. Ankár yakrá akwapea Aropamp Táráp apár me meknámp Kwaro warko fárámpá pap-námp ke fek naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aeránko maok, mao éréképá yárak i konámp arop fárákap man turunkrá, “Mokopia lo yénkrá farákáp konap arop fárákap sérrá, ‘Elaijamékɨr warko korop nánko, Krais wakmwaek korop naenámp’rá sénapon?” ");
INSERT INTO yuj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tá nopok Jisaso sérrá, “Am te kare, Elaija ankár koropea kápae kare ankank fwapokwap naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ae naenámpan maok, ono yumwan sénampon, Elaija te wae korop námpan maok, arop fárákapao man wuri nke moiaka námoku man nkwakwe make napono. Aropamp Tárápan kor sámpea takia pap mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas takrá sénánko, mao éréképá yárak i konámp arop fárákap wae méria, mao te arop ént mek nér i konámp Jonén sérianrá nɨnɨkiapon. ");
INSERT INTO yuj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wae tukupea koumteouráp arop ou yakáp nap fek napo maok, arop ankárankamp koropea Jisasomp wonae fik kwaráp torokomprá arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Tokwae Kar e! Amo onomp poumou-táráp má aropompae! Mao te mánmánria maomp pourou te kwatae kare yak námpon. Kápae kare por yaomwi mek pɨká párákap, tá kápae kare por ént mek pɨká párákap. ");
INSERT INTO yuj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mak i konámpan waráp éréképá yárak i konap arop fárákapaonapok warámpá akwap nanko, am fárákap te fwapi pap mwanap pourou mo napono.” ");
INSERT INTO yuj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aeránko maok, nopok Jisaso arakrá sér, “Yumo koumteouráp arop yumo Kwarén mér moria, onomp kar younkwe mwaek sɨnap te, ono apaekampor yumont yak nanko, yumo onan wanonorá mér mwanapon? Apaekampor yiráp kápae sámprá yumwan yaewour saráp yak nanampon? Yumo am táráp mampok warámp-sankoropenke.” ");
INSERT INTO yuj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aeria maok, am kwatae-aropan yoporánko, am tárápan pwarará worokor akwap nánko maok, oukoumwan táman am táráp wae kwapwe kare. ");
INSERT INTO yuj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aenko mao éréképá yárak i konámp arop fárákap koropea Jisasén turunkrá, “Yino te mokopia kwatae-arop yéréperá kérép mwanámp pourou mo námpon?” ");
INSERT INTO yuj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Táte Jisas am fárákapan sérrá, “Yiráp mér te kánanke kwarok námpara, yumo te pwi mono. Ono yumwan kare sénampon: Yiráp mér mastet ki kánanke niampao kuri, yumo fwap mámá faonkwe man sérrá, ‘Amo fárámpea ankwapmwaek akwapae’ napo te, mao ampok akwap naenámpon. Yumo tére ankwap yumwan pwi mo naenámp te yak mono. ");
INSERT INTO yuj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Take pourouráp kwatae-arop yérépe mwanap mwae kup te ankwap yak mono, Kwarén sér mwarea nap fek fɨr wuri mwanap mwar yak námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas énénki Galili mek tukupria maok, mao éréképá yárak i konámp arop fárákapan sérrá, “Aropao Aropamp Tárápan ankwap fárákapamp yaek pap mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aenapo am fárákapao faropea péri me mek páte napo, yinɨnk yae yakea warko fárámp nae-námpon.” Aeránko maok, mao éréképá yárak i konámp arop fárákap am kar wawia yonkwae touweria nɨnɨk tokwae. ");
INSERT INTO yuj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wakmwaek am fárákap tukupea Kaperneam mek napo maok, lotu nap tokwae mekamp takis sámp konap arop fárákap koropea Pitan arakrá sér, “Yiráp tisa te lotu nap tokwae mek takis sɨr ko-námp nie?” ");
INSERT INTO yuj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aerapo maok, Pita sérrá, “Yeno. Wae sɨr ko-námpono.” Aeria mao wae nap mek youmpea Jisasén am táman sénaeria námpao maok, Jisaso manénkɨr Pitan wounáprá turunkrá, “Saimon, amo nɨk nap te apaeno? Apárokamp king fákáre takis sámp nap te, ankwap fi aropao nap fekamp sámp konap ni, námokuráp firáp aropao nap fekamp sámp konap nie?” ");
INSERT INTO yuj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aerá turunk nánko maok, nopok Pita sérrá, “Ankwap fi aropao nap fekamp sámp konapono.” Aenánko nopok Jisaso man sérrá, “Takianánko te námokuráp fi arop te takis sɨr mono. Apárokamp kingao tak i konapao maok, nomo Kwarompara, lotu takis sánk mono. ");
INSERT INTO yuj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aeno lotu nap tokwae mekamp takis ti konap arop nomwan yoporantáno. Amo akwapea ént aokore mek wouk-sɨrarea éntékam manénkɨr érékép nap maomp top kor kununkwapea am mekamp mani náparamp sámpae! Amo am mani sámpea am fárákapan sánk napo, nomo énénkér nomp takis pwi naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Am ke fek Jisas éréképá yárak i konámp arop fárákap Jisasnámpok koropea sérrá, “Kwaromp firáp taokeyaknámp mek te wa narek tokwae kari yak námpon?” ");
INSERT INTO yuj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aerapo maok, Jisaso táráp kánanke ankwap koropae ránko koropea am fárákapamp amore mek fokopeyak nánko yénkép. ");
INSERT INTO yuj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aeria mao sérrá, “Ono yumwan kare kar sénampon: Táte yumo épér morok táráp kánanke niamp arákár moria te, Kwaro náráp firáp taokeyaknámp mek te yoump me kareno. ");
INSERT INTO yuj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Arop námoku te wampwe pwarará, épér morok tárápao yak konámp niamp námpao maok, am arop te Kwaro náráp firáp taokeyaknámp mekamp arop ponankor kámákár akwap námpon. ");
INSERT INTO yuj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Táte arop ankwap onan nɨnɨkria mámake pourouráp táráp kánankeran warákárria warámp námp te, mao onan kor warákárria warámp námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jisaso warko arakrá sér, “Aeno táte arop ankwapao táráp kánanke onan mér námpan maoianánko am táráp onan mér námp pwar námp te, wae manénkɨr arop fárákapao am aropamp yápare kor fek yumwi tokwae tokoropea man ént you tokwae mek sɨtenapo, tak moano mpupo. ");
INSERT INTO yuj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Apárokamp arop fárákap arop ankwapan yampourou napo, mao kwatae nɨnɨk nap te am yampourounap arop fárákap te koupoutáráp nape. Tá kare, kwatae nɨnɨk te waeman korop námpan maok, am kwatae nɨnɨk sámpá koropá papnámp aropao maok koupouteane. ");
INSERT INTO yuj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Táte waráp yae kor, tá waráp pu kor támao amwan kwatae nɨnɨk mwaek sakwap naerianánko te, amo ankár am waráp pu kor ni, yae kor nie, am karámp-tákapea sɨrampo. Amo takria maok, yae kor ankárank mwaek ni, pu kor ankárank mwaek nie, am fek fwap yiki yak nanapon. Takria amo pu kor ntia yae kor énénkér mwaek yak napo, amwan torokwar mo i konámp yaomwi mek sɨrantáno. ");
INSERT INTO yuj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Táte waráp yirao amwan kwatae nɨnɨk mwaek sakwap nánko te, wampweno. Amo am yi ankwapmwaek wur-sɨrarea ankárank mwaek yi fek saráp yiki yak sámpá yak nanapono. Takria amo énénkér mwaek yi sámpá yak napo, amwan ponankor yaomwi tokwae mek sɨrantáno. ");
INSERT INTO yuj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yumo fwapia mér kip: Takria yumo mekamp ankwap ankárankampao am kánanke-táráp tárápu te kánanke kwataerao námpwe mwanap. Mono. Ono yumwan arakrá sénampon: Yámar mek te am fárákapan taokeyakáp konap ensel fákáre te onomp Naropwar yámar mek yak námp, maomp yimetáp te wae nke konapon. ");
INSERT INTO yuj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Am te apae riteanápe, Aropamp Táráp te arop fárákap moyakáp napan warko érékép naeria ék námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Tá Jisaso warko arakrá sér, “Yumo te mokoprá nɨnɨk rape? Arop ankárankampao 100 sipsip wunianánko, táte sipsip ankwap ankárank moyak nánko te, mao te akwapea oupourounk mo naenámp nie? Mono. Am 99 sipsip faonkwek yakáp napo pwarará ankárankamp moyak námp táman oupourounk i konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ono yumwan kare kar sénampon: Mao am sipsip akwapea oupourounkia warámpria te, am sipsip ankárankan warákár námp te am 99 fwap yakáp nap táman warákár konámp kámákár akwap námpon. ");
INSERT INTO yuj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aeno taknámp yiráp Naropwar yámar mek yak námp, mao kuri mámá tárápu kánanke-táráp má ankwap moyak te ‘Mono’ ria námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Tá Jisaso warko arakrá sér, “Táte waráp ankwapnápo amwan kwatae nɨnɨki tenánko te, amo akwapea méntér yumoku mwar tankria maomp kwatae nɨnɨk érik yénképampo. Táte mao waráp kar wa námp te, amo am aropan warko warámp napo, yumo énénkér ankárankamp nɨnɨk fek yak nepono. ");
INSERT INTO yuj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tá mao waráp kar wa mo nánko te, amo ankár arop ankárank, anánkaopwe arake éréképá akwapea waráp nɨnɨk sénapo, nopok am aropao sénámp kar anánk, yinɨnkaopwe arakerao wa mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aeno táte mao am fárákapamp kar wa mo nánko te, amo ankár sios fákárean sérampo. Táte mao siosomp karan kor wa mo nánko te, mao te waeman Kwarén mér monámp arop ntia takis sámp konámp arop niamprá nɨnɨkampo. ");
INSERT INTO yuj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ono yumwan kare kar sénampon: Ankank ponankor yumo apárok mapek taokor napo te, am táman Kwaro yámar mek taokor naenámpon. Tá ankank ponankor yumo apárok mapek aokorop pwar napo te, táman Kwaro kor yámar mek am aokorop pwar naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ono warko yumwan sénampon: Táte yumo má apárok yakáp nap fekamp anánkaopwerao ankárankamp ankank sámp neria, ankárankamp nɨnɨk fek kar toropwap nepo te, onomp Naropwar yámar mek yak námp fwap am anánkaopweran am ankank nénk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ye. Táte arop anánkaopwe yinɨnkaopwe arakerao onan nɨnɨkia ankwap fek koupoukour napo te, onoku am fárákapamp ou mek yak nanampon.” ");
INSERT INTO yuj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Am ke fek táman Pita koropea Jisasén turunkrá, “Tokwae Kar, apaekampor onomp ankwapnápo onan nánko, ono maomp kwatae nɨnɨk nɨk mo pwar nanampon? Ae te fákánek por nie?” ");
INSERT INTO yuj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tá nopok Jisaso man arakrá sér, “Ono amwan ‘Fákánek por wae támaono’rá sér mono. Ono sérrá, ‘Fákánek fére-sámpramp fákánek por’rá sénampon. ");
INSERT INTO yuj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Aeno, Kwaromp firáp taokeyak konámp te, king ankwapao náráp tére aropao, ankank nánkár nopok sánk mwanámpria kwaporok tia napo, am tére aropan kwaporok tinap ankank fwapokwap námp niampono. ");
INSERT INTO yuj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mao am téreria am nopok sánk mwanámpria, kwaporok sámpnámp arop warámpá tukup napo, am arop te 10 milion kina kwaporok sámp námp, mao te nopok sánk mono. ");
INSERT INTO yuj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aenámpao maok, am nopok sánk naenámp mo nánko, kingo arop fárákapan sérrá, ‘Am arop ntia maomp yupu, maomp tárápu, maomp kápae kare ankank arop ankwapan sánkea, am fekamp mani mao kwaporok sámpnámp ankank fek nopok sankoropenke.’ ");
INSERT INTO yuj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aeránko maok, táte am maomp tére konámp aropao koropea kingomp wonae fik kwaráp torokomprá man arakrá sér, ‘Amo onan aropompria kánámpár yépékae. Nánkárap waráp ankank kwaporok sámp nampara, ponankor nopok sánk nanampono.’ ");
INSERT INTO yuj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tá maomp arop tokwae am tére konámp aropamp kar wawia man aropompria maok, mao kwaporok sámpnámp ankankan kor ‘Nopok sáp kwapono, wampweno’rá sér. ");
INSERT INTO yuj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Takia pwar nánko, am tére arop ek akwapea nke nánko, mao énénkér tére konep arop ankwap maomp 10 kina ‘Nopok sánk nanamp’ ria kwaporok sámpámp arop korop. Aenánko mao náráp énénkér tére konep arop táman sámpea, oumpour kor fek sámpá fákapá fákeyakrá yopor tokwaeria sérrá, ‘Amo onomp 10 kina koupour nopok sápae!’ ");
INSERT INTO yuj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aeránko maok, am méntér tére konep arop támao man sérrá, ‘Amo onan aropompia kánámpár yépékae! Nánkár fwap nopok sánk nanampon.’ ");
INSERT INTO yuj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aerámpan maok, tá nopok mao monoria man sámp-akwapea kalabus mek pap nánko, yakea fwap am K10 nopok sánk naenámp am fek akwapanoria. ");
INSERT INTO yuj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aenánko maok, tá méntér tére konap arop fárákap mao taknámp táman kokwarokria tukupea arop tokwaeran sér. ");
INSERT INTO yuj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aenapo arop tokwaerao am tére aropan sérrá, ‘Amo te kwatae kare tére aropono. Manénkɨr amo onan “Námwan aropompae” ria ém napo, amo am kwaporok tinap ankank “Nopok sáp kwapono” ri pwara nampon. ");
INSERT INTO yuj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ono amwan aropompi namp te, amo apaerá waráp méntér tére konep aropan aropomp moi napon?’ ");
INSERT INTO yuj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aeria maomp arop tokwae am te yonkwae pwarámpea man kalabus nap taokeyak konap arop fárákapamp yaek pap nánko, mao man touwe kwatae sánk napo, mao kwaporok sámpnámp ankank warko nopok sánk naenámp, am fek akwapea pwar naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Táte yiráp ankwapnápo yumwan napo kor, yumo yiráp nɨnɨk meknámp kar maonap kwatae nɨnɨk nɨk mo, pwar mo napo te, onomp Naropwar yámar mek yak námp mao kuri yumwan ankár taknámp naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisaso am kar farákápea pwarará, mao distrik Galili pwararea, distrik Judia mek ént Jordan tápamprá nkwamwaek fi mwaek akwap. ");
INSERT INTO yuj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aenánko kápae kare arop fákáre maomp wakmwaek tukup napo, am arop fárákapamp touwe am fek fwapokwaprá párakop. ");
INSERT INTO yuj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aenánko Farisi fákáre koropea Jisasén mokopean nke mwar ritea arakrá sér, “Ae te nomo nomp lo fek fwap nkwakwe make ankank fek poumou nap mekamp yupu pwar mwanámp nie?” ");
INSERT INTO yuj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tá nopok Jisaso am fárákapan sérrá, “Ae te yumo lo fek yaknámp kar am te nke mori kwapon? Am te arakrá sénámpon: ‘Wokwaek kar Kwaro kápae kare ankank yoromp fek, mao poumarop ntia yupu yoroi námpon.’ ");
INSERT INTO yuj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aeria Kwaro sérrá, ‘Arop náráp éntupwar naropwar pwararea yupunt koump námp te, am anánkwap waeman ankárankamp pouroui yak nepon.’ ");
INSERT INTO yuj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Aerá sénámpara, am anánkwap te warko anánkaopwe mono. Am anánkwap te waeman ankárankamp pourou támaonono. Aenámpara, ankank Kwaro koumpea pwate námp te, arop te poporori kwapono.” ");
INSERT INTO yuj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aeránko maok, Farisi fákárerao man sérrá, “Ae te Moseso nomwan lo sápria sérrá, ‘Arop fwap pas kumwia am yupuan sánkrá am yupu pwarampo.’ Aerá sérimp te mokopono?” ");
INSERT INTO yuj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Táte Jisaso am fárákapan sérrá, “Kwaro, yupu pwar kwaponoria am lo pap námpan maok, yumoku támao, yupu pwar mwarrá kárákáre napantá, Moseso yumwan, yumoku takenkria pwara námpon. Aeno wokwaek kar te am nɨnɨk yak mono. ");
INSERT INTO yuj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ono yumwan arakrá sér rae: Táte yupu ankwap aropént kokopor mo námpan maok, am poumaropao man pwarará, ankwap yupu sámp námp te, mao te náráp yupuan kwatae nɨnɨkria kokopor námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aeránko maok, Jisaso éréképá yárak i konámp arop fárákapao man sérrá, “Táte arop yupurént yakáp i konap nɨnɨk takanánko te, poumarop yupu sámp te wampweno.” ");
INSERT INTO yuj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aerapo maok, nopok Jisaso am fárákapan arakrá sér, “Kápae kare koumteouráp arop yumo sénap nɨnɨk am te ampaok mwanap pourou mono. Kwaro kárákáre sánknámp ankwap fárákapao saráp tak napon. ");
INSERT INTO yuj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aeno yumo wawenk! Nkwakwe make arop fárákap yupu ti mono. Mapekamp ankwap fárákap éntupwaro fárákap námp feknámpia kwaporok taki yakáp napon. Tá ankwap fárákap kémpiarák fár-pwate napo, yupu sámp mwanap pourou mo nánko, kwaporok yakáp napon. Tá ankwap fárákap Kwaro náráp firáp taokeyak konámp táman nɨnɨkria námoku támao, yupu ti monorá séria kwaporok yakáp napon. Arop mámá kar fwap sámp naenámp kwamp te, sámpea nɨnɨk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jisas am kar farákáp nánko, am ke fek táman arop fárákapao tárápu kánanke-táráp maonámpok éréképá korop. Am fárákapamp nɨnɨk te, Jisaso am tárápuan yae papria ourour nénkanoria. Aenapo maok, tá Jisas éréképá yárak i konámp arop fárákapao am arop fárákapan yopor. ");
INSERT INTO yuj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aenapo Jisaso sérrá, “Yumo yopori kwapono. Am tárápu numwar ononampok koropanápono. Kwaro náráp firáp taokeyak konámp te mámake pourouráp arop fárákap-ampono.” ");
INSERT INTO yuj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aerá séria maok, mao am tárápuamp pourouk yae papea pwarará wakmwaek am apár pwarará akwap. ");
INSERT INTO yuj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aenánko maok, arop ankárankamp koropea, Jisasén sérrá, “Tisa, ono te ankár mokopia kwapwe kare nɨnɨkria ono yiki yaká yak nanamp sámp nanampon?” ");
INSERT INTO yuj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Táte Jisaso am aropan sérrá, “Amo onan apaeritea kwapwe kare nɨnɨkan turunk rap? Kwar ankárankamp mwar kwapwe kareno. Táte amo yiki yak sámp naeria te amo ankár lo ponankor mántwaokampo.” ");
INSERT INTO yuj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Aeránko nopok am aropao sérrá, “Mokope lonono?” Tá Jisaso man sérrá, “Ará lo aráne: Amo arop sámp-wouroump kwapono. Yupuráp arop, poumouráp yupu, amo kokopori kwapono. Amo oukuni kwapono. Aropan kot napo, amo ‘Maoinámp’ ria kwekár kar ankwap séri kwapono. ");
INSERT INTO yuj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Amo ankár waráp éntupwar naropwaromp yae ankore mek yakria, maomp karwaokampo. Amo ankár waráp pourouan aropomp i konapnámp taknámp, waráp nouroupén aropompampo.” ");
INSERT INTO yuj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aeránko maok, tá am arop tár-ménki támao sérrá, “Am lo ponankor te ono wae mántwaok i konampono. Aeno ono apae ankankan mo nampon?” ");
INSERT INTO yuj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aeránko maok, Jisaso man sérrá, “Amo ankár kwapwe kare nae nap kwamp te, amo waráp kápae kare ankank aropan nénkea, am fekamp mani sámpea ankank monap arop fárákapan nénkampo. Amo takria maok, yámar mekamp kwapwe kare ankank sámp nanapono. Aenanapara, amo te onomp wakmwaek koropae.” ");
INSERT INTO yuj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tá nopok am arop tár-ménki am kar wawia, ae te mokop nanamponorá nɨnɨk tokwaeria Jisasén pwarará akwap. Am te apae riteanápe, náráp ankank tokwaeran arop nénk te monoria námpon. ");
INSERT INTO yuj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aenánko maok, Jisaso mao éréképá yárak i konámp arop fárákapan sérrá, “Ono yumwan kare kar sénampon: Kápae kare ankankráp arop te Kwaro náráp firáp taokeyak naenámp mek yink naenámp te kour-sɨr kare námpon. ");
INSERT INTO yuj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ono yumwan warko sé-nampon: Kamel te ankank aomp i konap nil me mek yoump naenámp wuriman kour-sɨr námpono. Aeno ankank tokwaeráp aropao Kwaro náráp firáp taokeyak konámp mek yoump naenámp te kour-sɨr kare námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aeránko, maomp éréképá yárak i konámp arop fákáre am kar wawia kokorokoria sérrá, “Takanánko te, wa mokop am mek yoump naenámp pwi námpon?” ");
INSERT INTO yuj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tá Jisaso am fárákapan younkoupia sérrá, “Arop fárákap te pwi mono. Aeno Kwaro mwar fwap kápae kare ankank pwi námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Aerá sénánko maok, tá Pita maomp kar pwarokwaprá arakrá sér, “Amo nkeae. Yino waeman yinomp ankank ponankor pwararea waráp wakmwaek tukup námpon. Aeno yino apae ankank sámp mwanámpon?” ");
INSERT INTO yuj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aeránko maok, Jisas am fárákapan sérrá, “Ono yumwan kare kar sénampon: Nánkár wakmwaek ankank ponankor wourékam yoro námp fek te, Aropamp Táráp e tokwae sámpea, sia King fek tank nánko, am ke fek táman, yumo arop fárákap onan éntér papá paokop nap, yumo kuri éntér-sámpramp sia fek tankápria éntér-sámpramp Israel fi taokeyakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Apae apae arop ononampaokria, náráp nap, náráp ankwapnáp, náráp antáp, náráp naropwar, náráp éntupwar, tárápu, yopwar, mao ará ankank pwar námp te, Kwaro nopok kápae kare ankank sánk nánko, am fárákap yiki yaká yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aeno kápae kare arop mekia tukup nap te, warko wakmwaek kar yakáp mwarea napon. Táte nopok kápae kare arop oukoumwan wakmwaek kar tukup nap te, ér-pwarará mekia tukup mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tá Jisaso warko ankwap wounáp kar arakrá sér, “Yámar mekamp Kwaromp firáp taokeyak námp te, arop ankwap apár tokwae nánkáráp námp niampon. Aeria koumounek kar wakor ék námp fek, mao wain yopwar mek tére mwanap arop érékép naeria akwap. ");
INSERT INTO yuj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mao am fárákap wae fwap ankárank yae fek térea sámp konap mani sámp mwanapria sénánko, ‘Yeno’ ria sénapo, mao am fárákapan, náráp wain yopwar mek térenkria tirá kérép-ámpon. ");
INSERT INTO yuj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tá warko sárakok ke nánko, mao akwapea nke nánko, arop ankwap fárákap koupoukour konap fek kwaporok yakáp. ");
INSERT INTO yuj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aenapo mao am fárákapan sérrá, ‘Yumo kuri tukupea onomp wain yopwar mek térea napo, yumwan fwap mani yae-párák nénk nanampono.’ ");
INSERT INTO yuj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aerá sénánko, am fárákap wae tére mwaria tukup. Tá éntér-sámpramp ke fek, tá yinɨnk ke fek mao warko akwaprá takrá arop tirá kérép. ");
INSERT INTO yuj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kumur mek yámar éntik ke niamp arake fek akwapea warko arop ankwap fárákap yakáp napo nkea sérrá, ‘Yumo te apaeritea mapek kwaporok yakáp rape?’ ");
INSERT INTO yuj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tá nopok am fárákapao sérrá, ‘Yinan tére sáp naenámp arop mo námpantá yakáp námpono.’ Tá mao sérrá, ‘Yumo kuri onomp wain yopwar mek tukupá térenke.’ ");
INSERT INTO yuj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wae kumur nánko, am wain yopwar naropwar tére taokeyak konámp aropan sérrá, ‘Amo tére konap arop fárákapan wumwiria nopok mani nénkae. Amo wakmwaek kar koropea térenap arop feknámpia nénkrá akwapea manmékɨr koropá tére nap fek pwarampo.’ ");
INSERT INTO yuj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aeránko maok, arop fárákap kumur mek éntik ke nánko koropá tére nap am fárákap ankárank yae fek térea sámp konap mani ti. ");
INSERT INTO yuj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aenapo, manmékɨr kar koropá tére nap te, nomo wae mani tokwae sámp mwanámpan mpwe nɨnɨk. Aenapan maok, am fárákapao kuri ankár take pourouráp ankárank yae fek térea sámp konap mani ti. ");
INSERT INTO yuj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mao am mani tia yopwar naropwarén kar yorowarrá sérrá, ");
INSERT INTO yuj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Mámá arop fárákap wakmwaek kar koropea ankárankamp ke fek saráp tére nap te, amo yino sámpnámp niamp puri fek nénk napono. Aeno yino te manénkɨr kar koumounek-námpia tére tokwae nánko, yinan yámar tákapa wae námpono.’ ");
INSERT INTO yuj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Aerapo maok, nopok yopwar naropwaro am ou mekamp arop ankárankan kar pwarokwaprá arakrá sér, ‘Onomp nouroup e, ono amwan te kwatae moi nampono. Ae te nomo ankárank yae fek térea sámp konap mani sámp nanaprá kar pap moi námp nie? ");
INSERT INTO yuj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Amo waráp mani sámpea akwapae. Ono mani amwan sánk namp te, onoku nɨnɨkia man kor ankár take pourouráp puri fek mámá arop fárákap wakmwaek kar koropá tére napao maok, sánk nampono. ");
INSERT INTO yuj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Am te onokump ankankono. Ae te ono onoku nɨnɨk nampaok takrá nénk naeria namp te fwap takrá nénk nanamp nie? Ono waeman kwapwe kare nɨnɨk fek nénk namp te, amo apaeritea kokwarok rape?’ ");
INSERT INTO yuj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aeno táte taknámp wakmwaek kar yakápnap fárákap te meki tukup napan kár-pwarará mekok tukup mwanapono. Tá nopok arop meki tukup nap te wakmwaek kar yakáp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisaso Jerusalem mek akwapria mao éréképá yárak i konámp éntér-sámpramp arop fárákap mwar éréképea akwap. Aeria mwaeaok Jisaso am fárákapan arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yumo wawenke: Oukoumwan nomo Jerusalem mek tukup námpon. Am mekamp arop fárákap Aropamp Táráp pris tokwae fákáre ntia lo yénkrá farákáp konap arop fárákapamp yaek pap mwanapon. Aenapo, am fárákap kotria man sámp-wouroump mwanap kar pap mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tá man ankwap fi arop fárákapamp yaek sánk napo, am fárákapao man wouroump kar séria man tárapore kákákia yaopwae porokopramp fek pukup mwanapon. Takia napo, mao sumpwia péri me mek yinɨnki yakea, warko fárámp naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Am ke fek táman Sebedimp tárápyaramp éntupwar am náráp tárápyarént akwapea Jisasomp wonae fik kwaráp torokomprá ankwap ankank turunk naeria. ");
INSERT INTO yuj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aenánko Jisaso man sérrá, “Amo apaeran kɨkiank rape?” Mao Jisasén sérrá, “Amo sénapo, amo king yak nap fek, onomp tárápyar máte waráp wonae fik, ankwap waráp yae-párák mwaek tank nánko, ankwap waráp yae-mánkwan mwaekia tank nenepon.” ");
INSERT INTO yuj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Aerá sénánko maok, Jisas maomp kar pwarokwaprá arakrá sér, “Yumo te am ankank yumo mér mo napan turunk napon. Ae te ono touwe sámp namp niamp kap te yumo fwap sámp nenep nie?” Aeránko maok, nopok am arop yaworao sérrá, “Yino fwapono.” ");
INSERT INTO yuj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tá Jisas am arop yaworan sérrá, “Tá kare, yumo ono touwe sámp nanamp kap mekamp fánenepono. Aeno wa mokop onomp yae-párák mwaek tank naenámp, wa mokop onomp yae-mánkwan mwaek tank naenámp, am te onomp ankank mono. Am népe te am arop fárákapampor onomp Naropwaro nánapi páte námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aeránko maok, fére-sámpramp arop fárákap am kar wawia am mwearan yopor. ");
INSERT INTO yuj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aenapo, Jisas am fárákapan wumwiria koropenk ritea sérrá, “Yumo wae mérapono: Ankwap firamp king fákáre te am fárákapan poukwap konapono. Te arop nununkwiao kor koumteouráp arop fárákap náráp karwaokenkria kárákárea wae konapon. ");
INSERT INTO yuj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Aeno take pourouráp nɨnɨk te yumo ou mek yak naeane. Mono. Arop yumo ou mek tokwae kar yak naeria námp kwamp te, ankár yiráp tére arop yak kun. ");
INSERT INTO yuj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tá arop yépe sɨrarea meki akwap naerámp kwamp te, ankár wakmwaek kar yaknámp kwaporok tére konámp arop niampi yak kuno. ");
INSERT INTO yuj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tá taknámp Aropamp Táráp te arop fárákapao námwan yaewouranáponoria ék mono. Mao ék námp te námoku wampwe pwarará arop fárákapan yaewourrá, sumpwia warko yamokwap nanampria ninámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mao wae takia Jeriko pwarará tukup napo, kápae kare koumteouráp arop Jisasomp wakmwaek tukup. ");
INSERT INTO yuj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aenapo, yi néneráp arop yawor mwaeaok wonae fik tank. Am arop yawor Jisas mwae-párák mwaek koropnámp kar wawia tékén arakrá wumwi, “Tokwae Kar, Devitomp ou fekamp Táráp e! Amo yinan aropompae!” ");
INSERT INTO yuj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Aerepo maok, koumteouráp arop fárákap am arop yaworan kar kárákáre fek taokor. Aenapan maok, am arop yawor te wa mono, ankár tékén arakrá sér, “Tokwae Kar, Devitomp ou fekamp Táráp e! Amo yinan aropompae!” ");
INSERT INTO yuj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aerepo maok, Jisaso fokopeyakrá am arop yaworan wumwiria korop nepo sérrá, “Yumo nɨk nep te, ono yumwan apae aeria nepe?” ");
INSERT INTO yuj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Aeránko am arop yaworao man sérrá, “Tokwae Kar e, amo yinomp yi fɨrékarrá papae!” ");
INSERT INTO yuj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aerepo maok, Jisaso yonkwae touweria maok, am arop yaworamp yi mek yae pap nánko, oukoumwan táman am arop yawor te yi wae fwap nke. Aeria maok, am arop yawor Jisasén éntér paprá akwap. ");
INSERT INTO yuj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Am fárákap wae tukupea Jerusalem mek wonae fik, Oliv Faonkwekamp némp Betfage wonae fik yakáp. Aeria maok, Jisas éréképá yárak i konámp arop anánkaopwe tirá kérépria maok, ");
INSERT INTO yuj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","am arop yaworan sérrá, “Yumo am némpouk akwapea koupour kar nke nepo, donki éntupwar koumte paok fek tokoropea pwatenap, yumo am aokorop pwararea ononampok éréképá koropenke. ");
INSERT INTO yuj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aenepo, yumwan arop ankwapao kar sénapo te, yumo ankár arakrá sér kipo, ‘Tokwae Karao am donki fek tére nae-námpono.’ Aerá sénepo, mao am donki anánkaopwe koupour kar tirá kérép naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Am ankank korop námp te wokwaek profeto sérimp kar méntér pwi námpono: ");
INSERT INTO yuj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Yumo Saion mekamp koumteouráp aropan arakrá sérenke: Yumo nkenke, yiráp king yumonapok korop námpono. Mao te porokwe kare fek nɨnɨk i konámpao, mao donki fek narek tankea korop námpono. Mao te donki oukoumwan anképe yumuntuk tank námpono.” ");
INSERT INTO yuj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Am arop yawor wae akwapea Jisaso séri námpaok mántwaok. ");
INSERT INTO yuj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Am arop yawor donki morok koumte Jisasnámpok éréképá koropria maok, am arop yawor náráp waempyam woropea narek donki fek kák nepo, Jisaso am fek tank. ");
INSERT INTO yuj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Aenepo, koumteouráp arop ankwap fárákap náráp waempyam tirá Jisas akwap naenámp mwaeaok yunk napo, tá ankwap fárákap yao yowe tokoprá mwaeaok yunkrá tukup. ");
INSERT INTO yuj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tá kápae kare koumteouráp arop fárákap manmékɨr meki tukup nap, tá Jisasomp wakmwaek tukupnap arop fárákap, makia mao wumwi karan arakrá sér, “Devito yakámp fi mekamp Táráp mámá warákárenke! Kwar Tokwae Karao námokuráp e fek koropnámp aropan warákár tokwae námpono. Narek karaokamp Kwaromp e sakap mwaro.” ");
INSERT INTO yuj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisaso donkimp pourouk tankea Jerusalem mek akwap nánko, am taun tokwae mekamp koumteouráp arop kokorokoria sérrá, “Mámá arop te wanono?” ");
INSERT INTO yuj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tá méntér koropnap koumteouráp arop fárákapao sérrá, “Máte distrik Galili mek Nasaret mekamp profet Jisasono.” ");
INSERT INTO yuj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Takia pwarará, Jisas lotu nap tokwae mek youmpea nke nánko, arop ponankor am mek ankank nonopokrá yakáp. Aenapo, mao am fárákapan yéréperá kérép. Tá ankwap firamp mani tia lotu nap tokwaeramp mani nopok nénknap kákánarráp, ntia sia arop fárákapao am fek tankrá ant nénkrá, maknap ponankor apárok wakárarrá souroumpour. ");
INSERT INTO yuj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aeria am fárákapan sérrá, “Kwaromp buk fek te arakrá sénámpono, ‘Onomp nap te “Kar toropwap i konap napono”rá sér mwanapono.’ Aeno yumo am nap te mákiaka arop fupukrá ankank pouroukoup konap aropao mek wouroumpá yakáp konap apár me niampi pap nape.” ");
INSERT INTO yuj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas takia pwarará am lotu nap tokwae mek yak nánko, arop ankwap fárákap yi kwataeráp, tá pu kwataenámp maonámpok korop napo, fwapokwaprá párakopámpono. ");
INSERT INTO yuj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aenko maok, pris tokwae fákáre ntia lo yénkrá farákáp konap arop fákáre Jisas yénképnámp kárákáre táman nkeria wa napo, tárápu kánanke-táráp lotu nap tokwae mek wumwinkrá arakrá sér, “Devit yakámp fi mekamp Táráp warákár mware!” Aenapo, am fárákap kokwarokia, ");
INSERT INTO yuj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jisasén sérrá, “Ae te amo am tárápu amwan sénap kar wae wa rape?” Tá Jisas am fárákapan sérrá, “Yeno, ono wae wa nampono. Aeno yumo Kwaromp kar Buk fek yak námp te, yumo nkea farákáp moi napon? Am te arakrá sénámpon: ‘Kwar e! tárápu kánanke-táráp, tá táráp yink éntupwaromp mom fek yak námp maomp top kor kununk-pwar napo, waráp e sakapanápono.’” ");
INSERT INTO yuj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aeria mao am fárákapan pwarará taun tokwae Jerusalem younkwek akwapea némp Betani mek am kumuruk am mek ampimpono. ");
INSERT INTO yuj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tá warko koumounek kar Jisas taun tokwae mek arákarrá mwae-páraok akwapria maok, yae porokwe. ");
INSERT INTO yuj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aenánko maok, mao yao fik am akwapnámp mwae fik yak nánko, wonae fik akwapea nke námpao maok, yao ki tank mo, pwae mwar yak. Aenánko mao am yao fikan sérrá, “Amo te warko ki tank mo kareno.” Aerá sénánko maok, koupour kar am yao fik wae yákáre. ");
INSERT INTO yuj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aenánko, mao éréképá yárak i konámp arop fárákap am táman nkea kokorokoria sérrá, “Mokopia am yao fik koupour kar yákáre námpon?” ");
INSERT INTO yuj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tá nopok Jisas am fárákapan arakrá sér, “Ono yumwan kare kar sénampon: Yumo mér kareria anánk nɨnɨk sámp moria te, yumo fwap ono yao fikani nampnámp taknámp mwanapon. Aeria yumo am táman saráp mono. Táte yumo mámá faonkweran sérrá, ‘Amo fárámpea solwara mek férékapae.’ Aerá sénapo te fwap tak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Táte yumo méria kar toropwapria te, yumo am ankank sámp mwaria kar toropwap nap, am ankank fwap yumo sámp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas lotu nap tokwae mek youmpea koumteouráp aropan kar farákáp. Aenánko pris tokwae fákáre ntia Juda fi taokeyakáp konap arop fákáre maonámpok koropea man kokwarokria turunkrá, “Amo te wa kárákáre sánkeanánko, mokope kárákáre fek am tére tére napon?” ");
INSERT INTO yuj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tá nopok Jisas am fárákapan arakrá sér, “Ono kuri ono yumwan ankárankamp ankank turunk nae. Táte yumo am kar onan farákarrá sénapo te, ono kuri yumwan mokope kárákáre fek am tére namprá sénanampon. ");
INSERT INTO yuj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jono ént mek nérrá kákámp te, Kwaromp ankank ni, aropamp ankank nie?” Am fárákap námoku kok sérarrá, “Táte nomo ‘Am te Kwaromp ankankono’rá sénánko te, nomwan ‘Ae te yumo apaerá maomp kar mér morap?’rá sérantáno? ");
INSERT INTO yuj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Táte nomo ‘Aropamp ankankono’rá sér mwanámp te, waeman koumteouráp arop Jon te profetonorá nɨnɨk napantá apápreano?” ");
INSERT INTO yuj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aeria maok, Jisasén sérrá, “Yino te mér mo námpono.” Táte Jisas am fárákapan sérrá, “Ono kuri am kárákáre maokamp sámpeaka am fek tére namp te yumwan sér mono.” ");
INSERT INTO yuj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisaso aerá séria pwarará, am pris tokwae fákáre ntia lotu taokeyakáp konap arop fákáreran turunkrá, “Yumo te mokoprá nɨnɨk rape? Arop ankárankamp táráp anánkaopwerápao naropwaro akwapea nae-tárápan sérrá, ‘Oukoumwan amo te onomp wain yopwar mek akwapá téreae!’ ");
INSERT INTO yuj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Aeránko am tárápao ‘Ono te mono’rá sénámpao maok, warko nɨnɨkia térerá akwap. ");
INSERT INTO yuj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tá warko naropwar akwapea nánae-tárápan manénkɨr nae-tárápan séri námpnámp taknámp sénánko, mao sérrá, ‘Fwap tak nanampono’rá sénámpao maok, akwapá tére mo. ");
INSERT INTO yuj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Am tárápyar te wa mokop naropwaromp nɨnɨkaok námpon?” Tá am fárákapao sérrá, “Nae-tárápao námpon.” Jisas am fárákapan sérrá, “Ono yumwan kare kar sénampon: Takis sámp konap arop ntia kokopor yupu yumwan kár-pwarará Kwaromp firáp taokeyak konámp mek yink napon. ");
INSERT INTO yuj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Am te apae riteanápe, Jon te yumonapok koropea yumwan yae-párák kare paokop mwanap nɨnɨk yénkép námpan maok, yumo man mér moiapono. Aeno takis sámp konap arop fárákap ntia kokopor koumteou fárákap te waeman méri napono. Am tak nap yumo wae nke napao maok, yumo ankwap nɨnɨk sámpea man mér moiapon.” ");
INSERT INTO yuj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tá Jisas am fárákapan warko arakrá sér, “Yumo ankwap wounáp kar wawenke. Arop ankárankamp apár tokwaerápao mao wain yopwar yɨmpea yumwi fek farmaea pwar. Takia yopwar mek wain ént pumpurékamp mwanap yumwi yukuria yoroi pwarará, taokeyak konámp aropampor nap tia pwar. Takia am yopwar arop ankwap fárákapamp yaek sánká pwarará, arakrá sér, ‘Yumo onomp wainráp yopwar taokeyakáprá térerá yakápenke.’ Aerá séria pwarará, mao akwapea panek ankwap némpouk yak. ");
INSERT INTO yuj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Takia wakmwaek wae wain ki koupoukour mwanap ke fek náráp tére arop wain yopwar mek, ampok wain ki ankwapmwaek ti-koropenkria tirá kérép. ");
INSERT INTO yuj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aenánko, am yopwar mek tére konap arop fárákap am tére arop éréképea ankwapan párák porokwap, tá ankwapan yákáre porokwap pap, ankwapan yumwi fek arokopá sumpwi pap. ");
INSERT INTO yuj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aenapo, am yopwar naropwar warko tére arop ankwapmwaek tirá kérép. Am manénkɨr tirá kérépámp kámá-pwarará náre tae morok tirá kérép nánko, am yopwar mek térenap arop am fárákapan kor wae manmékɨri napnámp taknámp. ");
INSERT INTO yuj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tá wakmwaek mao námokuráp táráp sámp-kérépria am naropwar arakrá sér, ‘Am tére arop fárákap te wae fwap onokump tárápamp kar wa mwanapon.’ ");
INSERT INTO yuj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Aenámpan maok, am yopwar mek térenap fárákap am tárápan nkea námoku kok sérarrá, ‘Má yopwar máte am aropamp naropwaro man wakmwaek sánkantá. Nomo koupour man sámp-wouroumpea nomo maomp yopwar ponankor sámp mwanámpon.’ ");
INSERT INTO yuj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aeria maok, man sámpá tukupea yopwar aop fek faropea pap napon. ");
INSERT INTO yuj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aeno yumo te apaerá nɨnɨk rap? Wakmwaek wain yopwar naropwar koropria te, am yopwar mek térenap arop fárákapan te mokop naenámpon?” ");
INSERT INTO yuj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Am Juda taokeyakápnap arop fárákapao Jisasén sérrá, “Mao te koropria am yopwar mek térenap arop kwataeran momwarrá tirá wour naenámpon. Aeria am wain yopwar ki sámp konap ke fek wain ki sánk mwanap arop ankwap firan sánk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas am fárákapan sérrá, “Kareno. Ae te yumo Kwaromp Buk fek kar ará yaknámp te mér mák napon? ‘Mámá yumwi nap ti konap arop fárákapao far-sɨtenap te, fwap nap woupwiramp yumwi kwapwe yak naenámpon. Tokwae Karao am ankank nánapinámp tére yino nke nánko, kwapwe kare kare námpono.’ ");
INSERT INTO yuj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aenámpara, ono yumwan sénampon: Kwaro náráp firáp taokeyak konámp yiráp yaekamp pwarokwapea ankwap fi arop yaonámp ki tanknámp fárákapan sánk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Arop mámá yumwi yumuntuk pɨká párákap nánko te, am aropamp pourou te fápákárápi akwap naerámpon. Táte mámá yumwi arop ankwapamp pourouk pɨká párákapria te, am aropan fwerápea tɨri oui pap naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pris tokwae fákáre ntia Farisi fákáre Jisas wounáp kar sénámp am wawia am fárákap wae mér, am wounáp kar te nomwan sénámponrá nɨnɨk. ");
INSERT INTO yuj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Aeria maok, am fárákap wae Jisasén sámp mwaria napao, koumteouráp aropao Jisasén waeman méria, mao te profetonorá nɨnɨk napantá, am fárákapan apáp. ");
INSERT INTO yuj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisaso am Juda taokeyakáp konap arop fárákapan wounáp kar ankwap arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kwaro náráp firáp taokeyak námp te kingao i konámp niampon. Maomp namoráp yupu sámp naerianánko, toupour tokwae. ");
INSERT INTO yuj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mao tak naeria te manénkɨr am toupour fek apae aropan koropenkrianámpan saráp wumwiria pwatea, wae am toupour naenámp yae fek mao náráp tére arop tirá kérép nánko, tukupá érékép mwaria. Aenapan maok, am fárákapao monoria korop mo. ");
INSERT INTO yuj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Aenapo warko tére arop ankwap fárákap am manénkɨr séri tarinámp arop fárákapan éréképenkria tirá kérépria maok sérrá, ‘Yumo tukupea sérrá, “King wae náráp fɨr nánapi námpono. Yumo wawenk! Wae náráp bulmakau ntia pourouráp nape fɨr mao fwapria nánapia kák námpono. Kápae kare ankank te wae nánapi pwarono. Yumo am yupu warámpnámp toupour fek koropenke.” ’ ");
INSERT INTO yuj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Aeránko maok, am tére arop fákáre tukupea am kingo sérinámp kar takrá sénapo maok, tá am fárákapao maomp kar wa mo, pwarará turukump. Ankwap náráp yopwar mek akwap nánko, ankwap náráp bisnis tére mek akwap. ");
INSERT INTO yuj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tá ankwap fárákapao am kingomp tére arop tia fupuka waeria tirá wouri pwar. ");
INSERT INTO yuj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Aenapo maok, king yonkwae pwarámpea maomp soldia fákáre tirá kérép nánko, tukupea am tére aropan tirá wourinap arop fárákapan ponankor yénképi pwarará, taun méntér yaomwi poupounki pwar. ");
INSERT INTO yuj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Aeria king warko náráp tére arop fárákapan sérrá, ‘Yupu warámp namp fekamp toupour te wae nánapi yak námpan maok, arop fárákap ono koropenkrá sérinamp arop fárákap te korop mwanap pwi mo, kwatae kare nape. ");
INSERT INTO yuj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aenámpara, yumo ankár taun mekamp mwae kɨri poro mekmwaek tukupea arop ponankor yumo nke nap kwamp te man sénapo, onomp fɨr toupour fek koropanápono.’ ");
INSERT INTO yuj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mao aerá sénánko, am tére arop fákáre wae turukumpia paokoprá am taun mekamp kápae kare arop nkea kɨkɨpia maok, am arop fárákap te ankwap arop fwapnae, ankwap te arop kwataenámp takia éréképá koropea am yupu warámpnámp toupour fek koupoukarea nap fákeyak. ");
INSERT INTO yuj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Koumteouráp arop ponankor wae fɨr fár mwaria tankáp napo maok, King námoku nke naeria nap mek yoump. Mao youmpea nke nánko maok, arop ankwap te yupu warámprá fɨr fánap ke fek yirɨmp konap waempyam yirɨmp moitea tank. ");
INSERT INTO yuj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aenánko maok, Kingo man sérrá, ‘Nouroup e, amo apaeritea yupu warámpnap yae fek yirɨmp konap waempyam yirɨmp moitea mamek mank napon?’ Aenánko maok, am arop te waeman kar tákap mo tank. ");
INSERT INTO yuj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aenánko maok, kingo náráp tére arop fárákapan arakrá sér, ‘Yumo mámá aropan pu yae fek yarokwapea ek sɨtenapo, kɨrɨkɨp tokwae mek yakano. Aeria am kɨrɨkɨp tokwae mek apánka waeria you kɨkɨmpia waeano.’” ");
INSERT INTO yuj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisaso am wounáp kar séri pwarará, arakrá sér, “Yeno, Kwar te kápae kare arop fárákapan takrá wumwi námpan maok, am ou mek te ankákárank arop fárákapan saráp náráponoria nánkáráp nánko, mao náráp firáp taokeyaknámp mek korop napono.” ");
INSERT INTO yuj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisi fákáre te, nomo Jisasén poupwekáp nánko, apae mokope kar nopok séran wawia man kot mwanámpria tukupea námoku kok kar sérar. ");
INSERT INTO yuj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Aeria maok, am Farisi fákárerao éréképá paokop i konap arop fákáre ntia Herotomp arop fárákap Jisasonámpok tirá kérép napo, am fárákap tukupea Jisasén sérrá, “Tisa, yino wae mér námpono, amo te kare kar sér i konap aropono. Am kare kar sér i konap fek tapek maok, koumteouráp aropan Kwaro i konámp nɨnɨk yénkrá farákáp konapono. Amo te amwan aropao nɨnɨk mwanapan apáp mo i konapono. Amo te waeman ankárankamp pourouráp nɨnɨk fek ponankor aropan nɨnɨk i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ae konapara, amo ankár yinan sérae: Amo nɨk nap te apaeno? Mosesomp loao nomwan ‘Fwap King Sisarén takis sánk mwanámpono’rá sénámp ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aerapo maok, Jisas am fárákapamp poupwekáp nɨnɨk wae mérámp kwamp sérrá, “Yumo te kwekár i konap aropono. Yumo apaeritea onan poupwekáp rape? ");
INSERT INTO yuj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yumo onan takis mani náparamp yénképenke!” Aeránko am fárákap wae mani sankoropá man yénkép. ");
INSERT INTO yuj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aenapo, mao am fárákapan turunkrá, “Am mani fek yaknámp arop wunéri ntia am e te wampono?” ");
INSERT INTO yuj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aeránko, nopok am fárákapao sérrá, “Sisarompono.” Aerapo, Jisas am fárákapan sérrá, “Takanánko te, Sisaromp ankank te Sisarén sánk kip. Kwaromp ankank te yumo ankár Kwarén sánk kip.” ");
INSERT INTO yuj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Aerá sénánko, am fárákap am kar wawia kokorokoria Jisasén pwarará wae tukup. ");
INSERT INTO yuj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Am yae fek táman Sadyusi ankwap fárákap Jisasnámpok korop. Am fárákap te ‘Surumpwinap arop fárákap te warko fárámp mono’rá sér i konapara, am Sadyusi fákáre Jisasén turunk, ");
INSERT INTO yuj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tisa, Moseso wokwaek sérimp kar amo wae mérapono: ‘Arop ankwap táráp sámp moria sumpwi nánko te, maomp nánaerao maomp yupu kae sámpeanánko, naeramp weri mek yak naenámp tárápu fékér naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aerá sénámp te, wokwaek yino ou mek arop fákánek mwearo yakápiapono. Aeria maok, nae-tárápao yupu sámpea yakria sumpwi nánko, maomp fekamp táráp yak mo. Aenánko, maomp nánaerao am yupu sámp. ");
INSERT INTO yuj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tá am nánaerao kor sumpwi nánko te, maomp nánaerao sámp. Ankár takrá akwapea fákánek mwearo ponankor pwar. ");
INSERT INTO yuj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Takia am ponankor surumpwi pwar napo, yupuao kor wae sumpwi. ");
INSERT INTO yuj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aenámp te amo yinan sérae: Nánkárap surumpwinap arop ferámp nap fek te, waomp yupu yak naenámpon? Amo wae mér napono, am fákánek mwearo te ankárankamp yupu támao tankrá akwap námpono.” ");
INSERT INTO yuj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tá nopok Jisas am fárákapamp kar pwarokwaprá arakrá sér, “Yumo te Kwaromp Buk fekamp kar ntia Kwaromp kárákáreran kor mér moria yumo épépérép kar sérarapon. ");
INSERT INTO yuj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nánkárap sumpwi arop warko ferámp nap fek te koumteou te poumou nap mek tankáp mono. Waeman yámar mekamp ensel fákárerao yakáp nap niamp pourouráp yakáp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aeria Jisas ankwap kar sérrá, “Am sumpwinap arop ferámp mwanap kar te ono yumwan turunk nae nae: Ae te Kwaro yumwan mámá kar arakrá sénámp te nke mori kwapono? ");
INSERT INTO yuj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ono te Abraham, Aisak, Jekop, maomp Kwarono.’ Mámá Kwar te sumpwinap aropamp Kwar mono. Mámá Kwar te yiki yakápnap aropamp Kwarono. Am te apae riteanápe, nomp wokwaekamp appeyaenáp Kwarént yiki yakáp napono.” ");
INSERT INTO yuj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jisas am kar séri pwaránko maok, koumteouráp arop fárákap maomp kar wawia kokorokoriapono. ");
INSERT INTO yuj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Am Jisas sénámp kar támao Sadyusi fákáreamp kar taokarea pap nánko, Farisi fákáre am kar wawia koropea Jisasomp wonae fik koupoukour. ");
INSERT INTO yuj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aenapo am ou mek lo mérámp arop ankárankamp Jisasén mokoponrá nke nae ritea turunk, ");
INSERT INTO yuj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tisa, apae lorao ankwap loran kámákarea tokwae kar námpon?” ");
INSERT INTO yuj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tá Jisas nopok man sérrá, “Am te ará: ‘Tokwae Kar te waráp Kwarono. Amo waráp yonkwae kare ponankor, waráp waemp ponankor, waráp nɨnɨk ponankor, nouroup karampo.’ ");
INSERT INTO yuj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mámá lo te mao támao tokwae karia kámákár akwap námpon. ");
INSERT INTO yuj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Lo anánk te ankár take pourouráp aráno: ‘Amo ankár waráp firáp aropan aropomp nap te, amoku waráp pourouran aropomp i konapnámp taknámpampo.’ ");
INSERT INTO yuj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mámá anánkaopwe lo te ponankor lo kar ntia profet fákáreramp kar am fi fek tukuri yak námp támaono.” ");
INSERT INTO yuj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi fákáre oukoumwan koupoukour yakáp napo, Jisaso am fárákapan turunk, ");
INSERT INTO yuj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yumo Kraisén te mokoprá nɨnɨk rape? Mao te wa yaknámp fi mekampono?” Tá am fárákapao sérrá, “Devitomp fi mekampono.” ");
INSERT INTO yuj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mao am fárákapan sérrá, “Takanánko te, apaeritea Yiki Kor Spiritao Devitén sérimpon? Mao arakrá sér: ");
INSERT INTO yuj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tokwae Karao onomp Tokwae Karan arakrá sér, “Amo onomp yae-párák mwaek tankrá akwapea nánkár ono waráp yopor arop fákáre waráp pu ankore mek kák tenanko, yakáp mwanapono.” ’ ");
INSERT INTO yuj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devito takrá sérimpan maok, ono yiráp kar wa nae: Devit námoku man ‘Tokwae Kar’rá sénámp te mokopia mao Devitomp fi mekamp yak námpon?” ");
INSERT INTO yuj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aerá sénánko maok, am fárákap te ankwap ankárankampao Jisasomp kar pwarokwaprá sér mwarap pourou mono. Aeria maok, ankár am yae feknámpia akwap námp te waeman apápia wakmwaek Jisasén ankwap ankank turunk mo, wae pwar. ");
INSERT INTO yuj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wakmwaek Jisas námoku éréképá yárak i konámp arop fárákap ntia koumteouráp aropan kar arakrá farákáp, ");
INSERT INTO yuj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lo mérap arop fárákap ntia Farisi fákáre yumwan Mosesomp wokwaekamp lo karan farákáp napono. ");
INSERT INTO yuj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Aenapara, am yumwan sánknap kar ponankor yumo ankár wawia mántwaok kipo. Aeno mao i konap nɨnɨk te yumo mántwaoki kwapono. Mao yumwan ‘Am karwaokenk’rá farákáp napao maok, mao kare námoku te mántwaok mo i konapon. ");
INSERT INTO yuj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Am fárákap te kápae kare lo kánanke-táráp kák napo, koumteouráp arop fárákap kére tokwaeani kwapnámp am kápae sámpea nɨnɨk tokwae napan maok, am fárákap námoku te yaewourrá ankwapmwaek kánanke sámp mo i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kápae kare ankank tére mwaria nap te aropao námwan nkeanáponoria kwekárrá paokop i konapono. Ye, am fárákap te Kwaromp kar kukumwinap yae sárak tokwae yirɨri pwatea, waempyam fu fek mopor kwapwe kákea képéria paokop i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tá toupour fek ankár arop tokwae tankáp konap sia fek tankáp mwar kar, tá lotu nap mek arop nke mwanap fek tankáp mwar kar i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Táte námwan arop ou mek ‘Gude’rá séria, e ‘Tisa’rá sérenk kar i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Aeno arop fárákap yumwan ‘Tisa’rá sér mwanape, mono. Ankárankamp támao maok yiráp tisa nánko, yumo ponankor te mwearoi yakáp napon. ");
INSERT INTO yuj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yumo mámá apárok mapek te arop ankwapan ‘Yiráp naropwar’rá séri kwapono. Ankárankamp kare yámar mek yak námpao maok, yiráp Naropwarono. ");
INSERT INTO yuj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yumo arop ankwapan ‘Arop taokeyaknámp arop’rá séri kwapono. Yiráp arop taokeyak konámp arop te Krais ankárankampono. ");
INSERT INTO yuj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yiráp arop tokwae te ankár yiráp tére arop yak kuno. ");
INSERT INTO yuj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Arop, námo tokwae kar namponoria námokuráp e narek sampok nánko te, Kwaro man apárok sámp-anámp naerámpon. Aeno arop námokuráp e apárok sámp-anámp nánko te, Kwaro maomp e narek sampok naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jisaso warko sérrá, “Yumo lo yénkrá farákáp konap arop fárákap ntia Farisi fákáre, yumo te kwekár i konap aropono! Yumo te fwapia mér kipo: Yumwan touwe kwatae korop naeane. Yumo te koumteouráp aropao Kwaromp firáp taokeyak konámp mek yink mwanap ménki te yumo támao nánánkári fákeyakáp napono. Yumoku kor am mek yink mo napara, koumteouráp arop am mek yink mwaria napo, am fárákapan mwae kup kákar napon.” ");
INSERT INTO yuj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Tá Jisas warko sérrá, “Yumo lo yénkrá farákáp konap arop fákáre ntia Farisi fákáre, yumo te kwekár i konap aropono. Yumo te fwapia mér kipo: Yumwan touwe kwatae korop naeane! Yumo te kae koumteouran poupwekápria, maomp nap pouroukoup konapono. Yumo te am yiráp kwatae nɨnɨk oupoupourrá paokoprá arop nke nap fek Kwarén kar toropwap éri konapono. Ae konapara, nopok am fek touwe kwatae sámp mwanapono. ");
INSERT INTO yuj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Yumo lo yénkrá farákáp konap arop fárákap ntia Farisi fákáre, yumo te kwekár i konap aropono. Yumo te fwapia mér kipo: Yumwan touwe kwatae korop naeane. Yumo te solwara mekmwaek, tá kápae kare apárok yiráp wakmwaek paokop mwanap arop oupourounkrá paokoprá érékép konapono. Takia napo, am arop fárákap yiráp arop yakápria waeman yumo niamp yaomwi mek pɨk mwanap arop yakáp napono. Yumo am fárákapan mákia yumonap kwatae nɨnɨk kámákarea kwatae kare kák nape. ");
INSERT INTO yuj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yumo arop ankwap fárákapan mwae kup yénkép mwaria nap te yi wurumpi yakáp napono! Yumo mér kip. Yumwan touwe kwatae korop naeane. Yumo arakrá sér i konapono: ‘Arop lotu nap tokwaeramp e séria fou sénap te kánankeno. Aeno arop am lotu nap tokwae mekamp gol e séria fou e sénapo maok, ankár am séri námpaok tak naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aerá sénapan maok, yumo épépérépia yiráp yi te wuri yak námpono. Apae ankankao tokwae kar námpon? Ae te golao tokwae kar ni, lotu nap tokwae am mek tanknámp gol yiki kukarrá papnámp, am támao tokwae kar nie? ");
INSERT INTO yuj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tá yumo sérrá, ‘Arop alta séria fou e sénámp te kánankeno, aeno táte ofa séria fou e sénap te mao ankár am séri námpaok tak naenámpono.’ ");
INSERT INTO yuj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Aerá sénapan maok, yumo te yi wuri yakáp napono. Apae ankankao tokwae karono? Ae te ofa támao tokwae kar ni, alta ofa yiki kukarrá pap konámp am támao tokwae kar nie? ");
INSERT INTO yuj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Arop alta séria fou e sénámp te, waeman am alta ntia ankank ponankor alta yumuntuk tank námp fek fou e sénámpono. ");
INSERT INTO yuj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Arop lotu nap tokwae séria fou e sénámp te, waeman lotu nap ntia Kwaro námoku lotu nap mek yak námp fek táman fou e sén-ámpon. ");
INSERT INTO yuj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tá arop yámar mek séria fou e sénámp te waeman Kwaromp sia ntia am arop am sia fek tank námp fek táman fou e sénámpon. ");
INSERT INTO yuj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yumo lo yénkrá farákáp konap arop ntia Farisi, yumo te kwekár i konap aropono. Yumo te fwapia mér kipo: Yumwan touwe kwatae korop naeane. Yumo te fɨr mek sɨrarrá fépér i konap nánákáre konámp ankank táman tia fére-sámpramp fi pɨr-pwararea Kwarén ankárank fi sánk konapono. Aeno yumo tokwae kar lo yénk i konap nɨnɨk ponankor mántwaok mo, pwar napono. Am te yae-párák kare nɨnɨkria arop yurukup, tá aropomp i konap nɨnɨk, tá Kwarén mér i konap nɨnɨk te pwar napono. Kwarén fére-sámpramp aopwe pɨrékarea sánk konap lo te pwar kwapono. Aeno mámá tokwae kar lo fekamp ankank máte yumo ankár kare kar mént tére kipo. ");
INSERT INTO yuj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yumo arop mwae kup yénkép mwaria nap te, yumo yi néneráp niamp nape! Yumo te ampwae kánankeran saráp yiráp fɨr mek koropantá yérépe napono. Kamel tokwae te yumo méntér fária nonkorop napon. ");
INSERT INTO yuj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Yumo lo yénkrá farákáp konap arop fárákap tá yumo Farisi, yumo te kwekár i konap aropono! Yumo te fwapia mér kipo: Yumwan touwe kwatae korop naeane. Yumo kap ntia plet younkwe mwaek saráp yárár i konapono. Aeno mek te ankank pouroukoup konap nɨnɨk ntia yumokuráp pourou fekamp nɨnɨkaok paokop napon. ");
INSERT INTO yuj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi yumo te yi nénerápono. Manénkɨr te yumo ankár kap éntér mekmékɨr yárária yiki kwapwe nánko maok, younkwe mwaek kuri yiki kwapwe naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yumo lo mérap arop fárákap tá yumo Farisi, yumo mér kipo: Yumwan touwe kwatae korop naeane. Yumo te kwekár i konap aropono! Yumo te arop papnap apár merao yumuntuk mopor kwapwe yak nánko, mek arop kour ntia kápae kare ankank kwatae top pwarámpeyak námp niampono. ");
INSERT INTO yuj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yumo kuri taknámpi yakáp napono. Arop fárákapao yiráp pourouan nke napo, yae-párák kare arop niampono. Aeno yiráp nɨnɨk mek te kwekár i konap nɨnɨk ntia lo ták-sɨr konap nɨnɨkao yiráp nɨnɨk mek top pwarámpeyak námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jisaso warko ankwap kar arakrá sér, “Yumo lo yénkrá farákáp konap arop fárákap, tá yumo Farisi yumo te kwekár i konap aropono! Yumo mér kipo: Yumwan touwe kwatae korop naeane. Yumo te profet fákáreran kákap fekmwaek nap yumwi fek térerá, tá yae-párák kare arop fárákapamp kwar yu fek mopor kwapwe kák konapono. ");
INSERT INTO yuj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aeria yumo sérrá, ‘Yino wokwaek appenápo yakápap ke fek yakápámpanria te, yino am profet fákáre tirá wour mo mwarámpono.’ ");
INSERT INTO yuj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aerá sénapan maok, yumo am takrá sénap kar támao yénképrá: Yumo te profet fákáreran tirá wouriap arop fárákapamp tárápuno. ");
INSERT INTO yuj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yumo koupour tukupea yiráp appeyaenápoinap kwatae nɨnɨk pwi papenke! ");
INSERT INTO yuj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yumo te fou-tákam kwataeno! Yumo mokopia pɨrɨkɨmpá tukup mwanapanáp? Kwaro yumwan waeman kotianánko, yaomwi mek tukup mwanapono. ");
INSERT INTO yuj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Aenapono yumo wawenke! Nánkár ono onomp profet ankwap fárákap, tá nɨnɨk kourráp, tá lo yénkrá farákáp konap arop yumonapok tirá kérép nanko, yumonapok tukup napo, yumo ankwap fárákap tirá wourrá, tá ankwap fárákapan yaopwae porokopramp fek pukuprá, tá ankwap fárákapan yiráp lotu nap mek fupukrá, mak mwanape. Aeria yumo am fárákapan ankwap taun mekamp yérépea ankwap taun mek kérép mwanape. ");
INSERT INTO yuj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tak napo, yae-párák kare arop fárákap apárok yakápnap arop fárákapao man tirá wour nap te, waeman yumo támaoi napono. Am fárákapao, yae-párák kare arop fárákap Abel feknámpia tukupea Sekaraia Berekaimp táráp am te yumo lotu nap ntia alta amore mek faropea pap nap te, am te yiráp kwatae nɨnɨk fek támaono. ");
INSERT INTO yuj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ono yumwan kare kar sénampon: Am fek nopok touwe kwatae te oukoumwan yumo mámá kear fek yakápnap koumteouráp aropao sámp mwanapon.” Jisaso arakrá sérimpon. ");
INSERT INTO yuj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisaso Jerusaleman yonkwae touweria sérrá, “Jerusalem e! Amo te profet fákáreran tirá wour i konapono! Yumo te Kwaro yumonapok tirá kérépnámp tére aropan yumwi fek yénképrá kák konapono. Kápae kare ke fek ono koumteouráp arop yumwan kakaruk éntupwaro i konámpnámp yowe pwae mek wouri fákeyak nae rampan maok, yumo monorá napon. ");
INSERT INTO yuj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yumo wawenke! Oukoumwan yiráp némp te kwaporok yak naenámpono. ");
INSERT INTO yuj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ono yumwan arakrá sénampon: Yumo te warko onan nke mono, yakrá akwapea nánkárap yumo sérrá, ‘Kwar Tokwae námokuráp e fek koropnámp arop táman warákár tokwae námpono’rá sér mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas lotu nap tokwae pwarará akwap nánko, mao éréképá yárak i konámp arop fárákap koropea Jisasén, ‘Nko lotu nap tokwae mekamp nap-nap nkeae’ ria yénkép. ");
INSERT INTO yuj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aenapan maok, nopok mao am fárákapan arakrá sér, “Yumo am táman nkea nɨnɨk tokwae rape? Aenapao maok, yumwan kare kar sénampon: Nánkár te yumwi ankwap, ankwap yumwi yumuntuk tank mono. Ponankor mént worépámprá épér napo, apárok pɨkrɨnk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas akwapea Oliv faonkwek tank nánko, mao éréképá yárak i konámp arop fárákap námoku saráp Jisasnámpok koropea sérrá, “Amo yinan sérae: Mokope ke fek am ankank fopwar naenámpon? Apae manénkɨr yénkép nánko, yino amo arákarrá ék napo, mámá apár pwar naenámp ke mér mwanámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nopok Jisas am fárákapan arakrá sér, “Takria arop ankárankampao yumwan kwekárantáno mér kip. ");
INSERT INTO yuj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kápae kare arop koroprá onomp e séria sérrá, ‘Ono támao ono Kraiso nae’rá sérantáno. Arop fákáre kápae kare koumteouráp aropan kwekár mwanape. ");
INSERT INTO yuj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yumo panek mwaekamp, wonae fik mwaekamp yorowarnap kar wa mwanapon. Yumo am kar korop nánko waria te yumo mér kip. Yumo táman korokop kwapono. Am ankank te kare korop naenámpan maok, pwarnámp yae kare te oukoumwan sɨkono. ");
INSERT INTO yuj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ankwap fi aropao ankwap fi aropént yorowar. Tá ankwap kingomp firao ankwap kingomp firan yorowar mwanapon. Tá ankwapmwaek kɨrɨkɨrikamp arop fárákap yae porokwe tokwae korop nánko, tá némp yérur tokwae korop naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Am kápae kare ankank korop naenámp te, yupuao táráp sámp naeria manénkɨr touwe tokwae arokwap konámp niamp kápae kare apárok korop naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Am ke fek te yumwan tia touwe nénkria yumwan tirá wour mwanape. Tá kápae kare koumteouráp arop fárákap yumwan kokwarok kare mwanape. Am te apae riteanápe, yumo onomp arop fárákap yakáp napara, yumwan tak mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Am ke fek te kápae kare koumteouráp arop Kwarén mér nap pwarará, mao náráp ankwapyaenápén yopor aropamp yaek papria, námoku kuri náráp ankwapyaenápén yopor mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tá kápae kare kwekár profet koroprá kápae kare koumteouráp aropan kwekár sérar mwanape. ");
INSERT INTO yuj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kápae kare kwatae nɨnɨk tokwae kari akwap nánko, arop yonkwae touwe i konap nɨnɨk te wae pwar mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aeno koumteouráp arop kárákáre yakáprá tukupea pwarnámp yae fek napo te, Kwaro man fwap warko érékép naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tá arop fárákap am Kwaro náráp firáp taokeyaknámp Kwapwe Kare Kar kápae kare apárok mwaek farákáp napo, ponankor koumteouráp arop fwap wawia napo, wakmwaek pwarnámp yae korop naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tá Jisaso ankwap kar arakrá sér. “Tá yumo nke napo, am kwatae kare ankank wokwaek profet Danielo sérimp, am ankank lotu nap tokwae mek koropea fokopeyakea oumi pap naerámpon. (Arop mámá kar te nkea fwapia nɨki samp kuno.) ");
INSERT INTO yuj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tá am ke fek te koumteouráp arop fárákap Judia mek yakáp nap te fwap yakáp mwaria te, pɨrɨkɨmpea faonkwek tukup mwanapono. ");
INSERT INTO yuj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Arop náráp kaerik tank námp te warko nap mek youmpea náráp ankank sámp mono. ");
INSERT INTO yuj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tá arop yopwar mek yak námp te arákárrá akwapea náráp nap mekamp waempyam sámp mono. ");
INSERT INTO yuj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Táte koumteou tárápu yakáp nap, tá táráp yink yaek fákeyakáprá mom wun nap, am fárákap te koupoutáráp nape! Mao te tére tokwae mwanape. ");
INSERT INTO yuj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Komontok korop námp fek, tá lotunap ke fek am ankank koropantánoria, yumo ankár Kwarén kar toropwap kipo. ");
INSERT INTO yuj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Am ke fek te kápae tokwae koropnámp kenono. Wokwaek Kwaro apár wourékam yoroimp ke fek te take pourouráp korop moimpono, tá wakmwaek kor take korop mono. ");
INSERT INTO yuj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Táte Kwaro am ke amor mek ták-pwar mo nánkoria te, koumteouráp arop ponankor moyakáp mwarapon. Aeno Kwaro koumteouráp arop fárákapan námoku nánkáráp tarinámp nɨnɨkria maok, am ke amor mek ták-pwar námpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Am ke fek arop ankwapao yumwan sérrá, ‘Yumo nkenke, Krais te mapek yak námpon.’ Tá ‘Nkwampok yak námpon.’ Aerá sénapo te, yumo, kare karan mpweria méri kwapono. ");
INSERT INTO yuj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Waeman ankwap fárákap yankarrá arakrá sér mwanape, ‘Ono te Kraisono.’ Ankwapao sérrá, ‘Ono profetono.’ Makrá poupwekáp sérar mwanape. Tá kárákáre tokwae momwar pourouráp téreria, am fek Kwaro nánkáráp tenámp koumteouráp aropamp nɨnɨk sámpá yampourou mwanape. ");
INSERT INTO yuj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yumo wawenk! Ono tak mwanap kar táman yumwan ‘Oukoumwan mérenk’ ria séri pwar nampon. ");
INSERT INTO yuj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Aeria am fárákapao yumwan sérrá, ‘Nkenke! Mao arop yak mo apár mek yak námp’rá sénapo te, yumo ampok tukup kwapono. Táte am fárákapao sérrá, ‘Yumo nkenke! Mao te mámá nap mek yak námp’rá sénapo te, am kar wawia méri kwapono. ");
INSERT INTO yuj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mékér wae tokwae yámaraoknámp mwaeknámpia, ponankor wae tákaprá akwapea yámar porokor námp mek i konámp te, nánkár wakmwaek Aropamp Táráp arákarrá ék námp fek kor taknámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Apae ankank mákáre nánko, ampwae yákáre koropea koupoukour konapon. Taknámp niamp Aropamp Táráp yámar meknámp ék námp fek, arop ponankor am fek koupoukour mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jisaso warko ankwap kar sérrá, “Am kápae tokwae koropnámp ke pwar nánko, koupour kar yámar kɨrɨkɨp nánko, yunkao kor wae mo nánko, yámar mekamp térme mukarea apárok ékrɨnk naenámpono. Tá yámar mekamp kárákáre kor ankankao kor wuwia wae naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aenánko, am ke fek táman Aropamp Táráp korop naenámp yarápae yámar mek érik farákár nánko, kápae kare némpoukamp arop am nkea náráp pourouantá éménk mwanapon. Tá am fárákap Aropamp Táráp yámar mek narek karaok koumwe yumuntuknámp kárákáre tokwae ntia wae tokwae fek ék nánko nke mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tá mao náráp ensel fákáre kárákáre fek wur fokopnámp wa nap fek tirá kérép nánko, mao apár yarápae pwar námp fek tukupea, Kwaro nánkáráp tarinámp koumteouráp arop éréképá koropea, ankár mek koupoukour mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisaso warko ankwap kar sérrá, “Yumo te fwap yao fikan nkea mér mwanapono. Am yao yowe ént fékiria pwae pére nánko te, yumo wae méria ‘Oukoumwan te yámar kwapwe naenámp ke’rá sér i konapono. ");
INSERT INTO yuj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Táte taknámp am ankank ponankor koropánk námp nkea, yumo fwap mér mwanapono: Aropamp Táráp korop naenámp yae wae wonae fik koropea ménki fek yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ono yumwan kare kar sénampon: Mámá kear mekamp koumteouráp arop fárákap oukoumwan sumpwi mo napo, am ankank ponankor korop naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yámar mek ntia apár te akwapá pwar naenámpon. Aeno onomp kar te pwar mo kareno.” ");
INSERT INTO yuj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jisaso warko sérrá, “Aeno arop ankárankamp am yae ntia am ke te mér mo kareno. Yámar mekamp ensel fákárerao kor mér mo, Kwaromp Tárápao kor mér mono. Kwar Naropwar námoku saráp méri yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Wokwaek Noa yakámp ke fek nɨnɨkiapnámp taknámp oukoumwan Aropamp Táráp arákarrá ék naenámp fek kor taknámp mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Oukoumwan éntenk tokwae korop monámp ke fek te, fɨr fépérrá ént fépérrá, koumteou tirá takrá tukupea, Noa sip mek papárámp ke fekiapono. ");
INSERT INTO yuj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Am fárákap te náráp pourouk sámp mwarap te nɨk moitea yakáprá takrá tukupapo, éntenk tokwae koropria koumteouráp arop ponankor éntao timpono. Tá taknámp Aropamp Táráp ék naenámp ke fek kor tak mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Arop anánkaopwe yopwar mek tére nep te Kwaro ankwap ankárankamp warámpria, ankwap pwar naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tá yupu anánkaopwe ni yaprá yak nep te, Kwaro ankárankamp warámpria, ankwap te am fek pwar nánko yak naerámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ae naerámpara, yumo ankár fwapia mér kipo: Yumo te mokope ke fek yiráp Tokwae Kar ék naenámpaoean mér mono. ");
INSERT INTO yuj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yumo ará ankankan nɨnɨk kipo: Arop nap naropwaro mokope ke fek arop koropea náráp nap mekamp ankank oukun naenámpaoeanria kumuruk amp mono, ankár yérék nánko, oukun arop te maomp nap mekamp ankank oukun mo, fwapono. ");
INSERT INTO yuj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ae konámpara, yumo kor ankár nánapi yakáp kip. Aropamp Táráp yumo oukoumwan ék mo naenámpan mpweria nɨk mo pwar napo, am ke fek táman ék naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisaso ankwap wounáp kar arakrá sér, “Apae tére arop kwapwe kare nɨnɨkria, maomp tére yae-párák taokeyak konámpon? Am ankank naropwar man ankwap tére aropan taokeyakria, man fɨr nénk naenámp ke fek nénk konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aetenánko, wakmwaek am ankank naropwar arákarrá koropea am tére arop wae námoku séri pwate akwapnámp nɨnɨkaok téreanámp nke nánko, pwi yak nánko te, am tére arop támao fwap warákár tokwae konámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ono yumwan kare kar sénampon: Am aropan te waeman náráp ankank taokeyak naenámp arop tokwae yoroi pap naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aeno am tére arop kwataeria námoku támao nɨnɨkrá, ‘Onomp arop tokwae te koupour korop mono.’ ");
INSERT INTO yuj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Aeria am énénki tére konap aropan fupukrá yárakrá, fɨr fárrá mánmán ént fépér i konap aropént ént fárrá mánmánrá yárak. ");
INSERT INTO yuj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aenánko, maomp arop tokwae am tére arop te korop mo naenámpan mpweria am tére aropao kor oukoumwan apae yae fek, apaekamp ke nánko, korop naenámpaoeanrá mér mo. ");
INSERT INTO yuj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aenánko am arop tokwae te koropea am tére aropan fukia man sámpea kwekár nɨnɨkaok i konap arop fárákapént páte nánko, am mek apánka waeria you kɨkɨmpia wae mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Tá Jisaso wounáp kar ankwap arakrá sér, “Nánkár am ke fek te Kwaro náráp firáp taokeyak naenámp te fére-sámpramp énkénki koumteou niampon. Arop ankárankamp oukoumwan táman yupu sámp naeria koropnámp yae fek, am énkénki koumteou náráp lam tia man mwaeaok yépékia warámpá korop mwaria tukup. ");
INSERT INTO yuj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Aenapo maok, ankwap éntik te yonkwae kour mo, aeno ankwap éntik te fwap yonkwae kourráp. ");
INSERT INTO yuj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aeria yonkwae kour monap koumteou te lam ti-korop napao maok, wel te méntér ti-korop mo. ");
INSERT INTO yuj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Aeno yonkwae kourráp koumteou te wae botol mek wel kéria náráp lamént tia korop. ");
INSERT INTO yuj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aenapo maok, am yupu wourékam sámp naenámp arop te koupour korop mo nánko, am koumteou ponankor ouwipi nánko, pampi yakáp. ");
INSERT INTO yuj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Aenapo akwapea kumur kupuk ‘Yupu sámp naenámp arop wae koropán’rá wumwi kar sérrá, ‘Yumo tukupea man mwaeaok kɨkɨpia warámpá koropenke!’ ");
INSERT INTO yuj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aerapo maok, am énkénki koumteou ponankor fápárámprá náráp lam nánap. ");
INSERT INTO yuj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tá yonkwae kour moráp koumteou náráp lam wel mo nánko, yonkwae kournap koumteouran sérrá, ‘Yumo yinan wel ankwapmwaek sápenke. Yinomp lam torokwar naeria waeane!’ ");
INSERT INTO yuj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aerapo maok, yonkwae kourráp koumteou nopok sérrá, ‘Mono! Mámá wel te yinan kor pwi mo, tá yumwan kor pwi mono. Fwapono, yumo tukupea yumoku mwanap stua mekamp wel mani fek sámpenke.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aerá sérapo maok, am fárákap wae wel sámp mwaria stua mek tukup te. Aenapo maok, am yonkwae kouria nánapi yakápnap koumteou am yupu wourékam sámp naenámp aropént yinkea, nap mek fépérrá tankápria ménki kéri pwate. ");
INSERT INTO yuj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aenapo am ankwap éntik énkénki koumteou wakmwaek arári koropea sérrá, ‘Tokwae Kar e, amo yinan ménki kɨk-pwarae!’ ");
INSERT INTO yuj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aerapo maok, táte am aropao nopok sérrá, ‘Yumo apae koumteou nape? Ono yumwan mér mo rae!’” ");
INSERT INTO yuj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas takrá séri pwarará, arakrá sér, “Yumo fwapia mér kip. Yumo am Aropamp Táráp ék naenámp yae ntia ke te mér mono.” ");
INSERT INTO yuj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisaso warko arakrá sér, “Tá ankwap te, Kwaro náráp firáp taokeyak naenámp te arop ankárankamp tokwae panek ankwap némpouk akwap naeria, náráp tére konap aropan wumwiria, náráp ankank ponankor am fárákapamp yaek nénk námp niampon. ");
INSERT INTO yuj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mao am tére arop ankákárankaomp tére mwanap kárákáre nɨnɨkria take pourouráp puri fek ‘Náráp mani fákeyakáprá, am fek térenk’ ria nénkria, ankwap aropan K5,000 sánk, tá ankwapan K2,000 sánk, tá ankwapan K1,000 sánk. Taki pwarará mao wae akwap. ");
INSERT INTO yuj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mao wae akwap tenánko, am K5,000 sámpnámp arop koupour kar térea kámákarrá warko K5,000 sámp. ");
INSERT INTO yuj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tá am K2,000 sámpnámp arop mao kuri térea warko kámákarrá ankwap K2,000 sámp. ");
INSERT INTO yuj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aeno arop K1,000 sámp námp te sámpá akwapea apár me yokoropea náráp arop tokwaeramp mani te mek wouroumptea yak. ");
INSERT INTO yuj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Aenapo, wae kápae kare ke akwap tenánko, wakmwaek am tére arop fárákapamp arop tokwae wae arákarrá korop. Wae koropea, náráp mani nénk tarinámp am arop fárákapan yurukup naeria. ");
INSERT INTO yuj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Aenánko maok, tá arop K5,000 sámp námp sankoropea sánkria sérrá, ‘Arop Tokwae, amo onan K5,000 sáp napan ono am fek térea, warko ankwap K5,000 sámp namp má nkeae.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Aeránko maok, am arop tokwaerao sérrá, ‘Amo te kwapwe kare tére aropono! Amo tére kwapwe kareria tére taokeyak kwapwe napon. Amo kánanke kwarok ankank fwap taokeyak napara, onomp nɨnɨk te amo fwap kápae kare ankank taokeyak nanapono. Amo koropea onont warákárae.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Arop ankwap K2,000 sámp námp mao kuri koropea sérrá, ‘Arop Tokwae, amo onan K2,000 sáp napono. Amo nkeae. Ono am fek térea warko K2,000 ankwap sámp nampono.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Aeránko maomp arop tokwaerao man sérrá, ‘Amo te tére nap pwar moria, yae-párák kare térea napono. Amo kánanke kwarok ankank yae-párák taokeyak napara, amo fwap tokwae kar ankank poukwap nanaprá nɨnɨk nampon. Amo koropea onont warákárae.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tá K1,000 sámpnámp arop mao kuri koropea sérrá, ‘Arop Tokwae, ono wae mérampono, amo te tére poukwapá yakrá fopwaoka wae, tá amo te arop ankwapao yoroinap yopwar mekamp fɨran kor ti konapono. Tá ankwap aropao kwar mek ankankou yɨrɨri tenap fekamp fɨr ti konapono. ");
INSERT INTO yuj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ae konapantá ono táman apápria waráp K1,000 má kwar mek wouroump tari nampono. Waráp mani má nkeae.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Táte arop tokwaerao maomp kar pwarokwaprá sér, ‘Amo te kwatae kare tére aropono! Amo te kokwae kare aropono! Ono ankwapao yopwar yoroinap fɨr ti konamp, tá ankwapao kwar mek ankankou yɨrɨri tenap mekamp fɨr ti konamp, amo táman mérapono. ");
INSERT INTO yuj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Takria te amo apaeritea onomp mani beng mek pap moi napono? Ono koropea onomp K1,000 sámpria am fek kámákár námp méntér sámp nae mpupo.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Aeria am arop tokwaerao am fek yakápnap arop fárákapan sérrá, ‘Ae te yumo K1,000 am pwarokwapea K10,000 sámpnámp aropan sánkenke. ");
INSERT INTO yuj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Am te apae riteanápe, aropao ponankor ankank ankwap fwapi taokeyak nánko te, warko ankwap ankank man nénk mwanapono. Aeno táte arop ankwap ankank mo námp te, mao fákeyaknámp kánanke kwarok ankank akwapá moyak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Am tére arop kwatae te ek kɨrɨkɨp mek far-sɨtenapo, am mek apánka waeria yu kɨkɨmpia arokwapano.’” ");
INSERT INTO yuj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Tá Jisaso ankwap wounáp kar sérrá, “Nánkár wakmwaek Aropamp Táráp King yakea náráp ponankor ensel fákáre méntér arákarrá éknámp ke fek, mao kingo tank konámp sia king fek tank naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tá ponankor arop fi mao nke námp fek wonae fik koupoukour mwanapon. Aenapo, am arop fi kuk pɨrékarea anánk fi pwar naenámpono. Sipsip taokeyaknámp aropao sipsip pɨrékarrá ankwap mwaek pwar, meme pɨrékarrá ankwap mwaek pwar konámp niamp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mao te sipsip tirá yae-párák mwaek kák, meme tirá yae-mánkwan mwaek kák naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Takria kingo yae-párák mwaek yakápnap arop fárákapan arakrá sér, ‘Yumwan te onomp Naropwar Kwaro warákár námpono. Yumo onomp Naropwaro náráp firáp taokeyak naenámp oukoumwan apár wourékam yoro námp fek yiráp por nánapi páte námp am sámpenke. ");
INSERT INTO yuj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Am te apae riteanápe, wokwaek ono yae-porokwe nanko, yumo onan fɨr sápapono. Tá ono ént nɨkɨp nanko, yumo onan ént sápapono. Ono ankwap némpouknámp korop nanko, onan yiráp nap mek warámp-sɨra napono. ");
INSERT INTO yuj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ono waempyam mo nanko, yumo onan waempyam sápapono. Ono touwe nanko, yumo onan taokeyakápi napono. Ono kalabus mek yak nanko, yumo onan koropá nkeapono.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aeránko, tá yae-párák kare arop fárákap nopok maomp kar pwarokwaprá arakrá sér mwanapon: ‘Tokwae Kar, mae ke fek amo yae-porokwe napo, yino amwan fɨr sánkámpon? Tá mae ke fek amwan ént nɨkɨp nánko, yino ént sánkámpon? ");
INSERT INTO yuj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tá mae ke fek amo ankwap némpouknámp korop napo, yino amwan nap mek warámp-sɨrarimpon. Tá mae ke fek amo waempyam mo napo, yino amwan waempyam sánkámpon? ");
INSERT INTO yuj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mae ke fek yino amo touwe napo koropá amwan nke námpon, tá mae ke fek amo kalabus mek yakapo, koropá amont kar táráparimpon?’ ");
INSERT INTO yuj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nopok kingo man kar pwarokwaprá arakrá sénaenámpon, ‘Ono yumwan kare kar sénampon: Yumo mámá kápae kare ankank onomp mapekamp e tokwae monámp nánae ankwapan takrá tére nap te, onan kor tak napon.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Aeria mao am yae-mánkwan mwaek yakápnap arop fárákapan arakrá sénaenámpon, ‘Yumo te moyakáp mwanap arop fárákapono. Yumo onan pwarará, yumo te onomp Naropwaro Satan ntia maomp ensel fákárerampor nánapi pwatenámp torokwar mo i konámp yaomwi mek pɨkenke. ");
INSERT INTO yuj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Am te apae riteanápe, wokwaek ono yae-porokwe nanko, yumo onan fɨr sáp moi napono. Ono ént nɨkɨp nanko, yumo ént sáp moi napono. ");
INSERT INTO yuj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ono ankwap némpouknámp korop nanko, yumo onan yiráp nap mek warámp moi napono. Ono waempyam mo nanko, onan waempyam sáp moi napono. Ono touwe nanko, tá ono kalabus mek yak nanko, yumo onan koropá nke moi napon.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aerá sénánko, am fárákapao kor nopok man sérrá, ‘Tokwae Kar, mae ke fek yino nke nánko, amo yae-porokwe napo, tá ént nɨkɨp nánko, tá amo ankwap némpouknámp korop napo, tá amo waempyam mo napo, tá amo touwe sámp napo, tá amo kalabus nap mek yak napo, amwan yaewour moi námpono?’ ");
INSERT INTO yuj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tá nopok mao arakrá sénaenámpon: ‘Ono yumwan kare kar sénampon: Yumo mapekamp e moráp arop ankwapan tak moi nap te, yumo onan kor tak moi napon.’ ");
INSERT INTO yuj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aenapara, am fi arop te tukupea touwe kwatae sámpea arokwamánkrá ankár yakápá yakáp mwanapon. Aeno yae-párák kare arop te yiki yak sámpea yakápá yakáp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas am kar ponankor farákápea pwarará, am ke fek táman mao éréképá yárak i konámp arop fárákapan sérrá, ");
INSERT INTO yuj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Yumo wae mérapon, Pasova fɨr fár mwanámp yae te anánk yae mwar tank námpon. Aeno tá wakmwaek Aropamp Táráp yopor aropamp yaek pap napo, am fárákapao yaopwae porokopramp fek pukup mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Am ke fek táman Pris Tokwae fákáre ntia Israel fi taokeyakáp konap arop, pris taokeyak konámp arop tokwae Kaiafasomp nap mek koupoukour. ");
INSERT INTO yuj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Aeria am fárákap Jisasén sámpá farop mwanámpria e-poup kar sérarrá tankáp. ");
INSERT INTO yuj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aeria sérrá, “Mono. Nomo kápae kare arop koupoukarrá Kwarén lotunap yae fek am ankank tak nánko, koumteouráp arop fárákap nomwan yorowarantáno.” ");
INSERT INTO yuj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas Betani mek wokwaek lepra touwe sámpámp arop Saimonomp nap mek yak. ");
INSERT INTO yuj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Aenánko yupu ankárankamp mao botol kwapwe kare yumwi fekamp am mek sanda kwapwe top pwarámpeyak námp sankorop. Am sanda te mani tokwae fekampono. Jisaso fɨr fárrá tank nánko, am yupuao náráp sanda sankoropea maomp me korok kwarákár. ");
INSERT INTO yuj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Aenánko, mao éréképá yárak i konámp arop fákáre nkea kokwarokria sérrá, “Apaeritea mámá sanda kwaporok akwap námpono? ");
INSERT INTO yuj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nomo am sanda arop sánkria am fek nomo mani tokwae sámpea ankank monap arop fárákapan nénk mwar mpupo.” ");
INSERT INTO yuj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas maomp kar wae méria man sérrá, “Yumo apaeritea mámá yupuamp nɨnɨk mek kápae sánk rape? Mao te onan kwapwe kare nɨnɨk fek námpono. ");
INSERT INTO yuj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kápae kare por ankank monap arop fárákap te yumont yakáp mwanapon. Aeno ono te yumont kápae kare por yak mono. ");
INSERT INTO yuj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mámá yupu am sanda onomp pourouk kwarákárámp te onan apár me mek pap mwanapan nánap námpono. ");
INSERT INTO yuj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ono yumwan kare kar sénampon: Ponankor kápae kare apár mekmwaek mámá Kwapwe Kare Kar farákápria am mámá yupuraoinámp karan kor méntér farákáp napo, arop fárákap am táman nɨnɨk mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Am ke fek táman éntér-sámpramp arop ou mekamp arop ankárankamp, maomp e te Judas Iskariot, mao pris tokwae fákáreaonapok akwapea sérrá, ");
INSERT INTO yuj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Yumo onan apae ankank sáp napo, ono yiráp yaek Jisas pap nanampono?” Aeránko maok, am fárákapao man 30 mani silva sánk. ");
INSERT INTO yuj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tak napo maok, am ke fek táman mao, mokope ke fek am fárákapamp yaek Jisas sánk nanampaoeanrá mwae oupourounk. ");
INSERT INTO yuj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yis Moráp Pan Fépér mwarap Yae manénkɨr ankárankamp yae korop námp fek, Jisaso éréképá yárak i konámp arop fárákap koropea Jisasén turunkrá, “Amo nɨnɨk nap te yino maok Pasova fɨr nánapianánko, amo Pasova fánanapono.” ");
INSERT INTO yuj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tá mao sérrá, “Yumo taun mek tukupea ono méramp arop ankárankampan sérrá, ‘Jisaso sérrá, “Ono nanamp ke te wae wonae fik námpono. Ono onomp éréképá yárak i konamp arop fárákapént waráp nap mek Pasova fɨr fánae.” ’” ");
INSERT INTO yuj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Aerá séránko maok, am arop fárákap wae Jisaso sérimpaok takia Pasova fɨr nánapi pwar. ");
INSERT INTO yuj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tá wae kumur mek am éntér-sámpramp arop fárákap éréképea méntér tankáprá fépér. ");
INSERT INTO yuj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Am fárákap fépérrá tankápria Jisaso sérrá, “Ono yumwan kare kar sénampon: Yumo ou mekamp arop ankárankamp onan yopor aropamp yaek pap naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Arop ponankor am kar wawia yonkwae touweria maok, ankákárankrá turunkupria sérrá, “Tokwae Kar e, ae te onoi kano?” Aerá sérar. ");
INSERT INTO yuj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aenapo mao nopok arakrá sér, “Am arop dis mek tanknámp sup mek onont pan anámp námp te mao onanenkria outɨri naenámp arop támaono. ");
INSERT INTO yuj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tá kare Aropamp Táráp te waeman Kwaromp Buk fek sénámpaok touwe sámp naenámpon. Aeno am arop Aropamp Tárápan yopor aropamp yaek pap námpao maok, koupouteane! Éntupwaro man fárákap te wampwe mpupo! Mao tak námp fek waeman touwe kwatae sámp nae-rámpon.” ");
INSERT INTO yuj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aeránko Judas man yopor aropamp yaek sánk naenámp mao arakrá turunk, “Tisa, ae te onoi kano?” Tá Jisas man sérrá, “Wae amoku sénap támaono.” ");
INSERT INTO yuj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mao fépérrá tankáp napo, Jisas pan sámpea Kwarén ‘Aesio’rá séria, mao am pan fárákapea éréképá yárak i konámp arop fárákapan nénk. Aeria mao sérrá, “Máte onomp pourouno. Yumo sámpea fárenke.” ");
INSERT INTO yuj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tá wain éntráp kapan kor Kwarén ‘Aesio’rá séria am fárákapan nénkria sérrá, “Yumo ponankor mámá fárenke. ");
INSERT INTO yuj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Am te onomp yɨri fek kontrak yoro nampono. Ono kápae kare aropamp kwatae nɨnɨk yárári akwapanoria kwarákár na-nampono. ");
INSERT INTO yuj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ono yumwan sénampon: Ono wain ént te warko fár mono, ankár akwapea Kwaro náráp firáp taokeyak konámp korop nánko, am mek yumont wain ént wourékam fánanampono.” ");
INSERT INTO yuj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Takia pwarará tár ankárankamp sámpea wae ek tukupea Oliv Faonkwek tukup. ");
INSERT INTO yuj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas am fárákapan sérrá, “Yiráp onan mérnap te mámá kumuruk kwatae akwap naerámpon. Kwaromp Buk fek sérrá, ‘Ono sipsip taokeyak konámp arop farop nanko, sipsip fákáre pɨrɨkɨmpea tukup mwanapon.’ ");
INSERT INTO yuj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aeno wakmwaek ono warko fárámpea Galili mek yumwan mekia akwap nanampon.” ");
INSERT INTO yuj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tá Pita nopok man arakrá sér, “Táte kápae kare aropamp mér kwatae akwap námpon kor, onomp mér mwar kwatae akwap mo kareno!” ");
INSERT INTO yuj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisas man sérrá, “Ono amwan kare kar sénampon: Mámá kumuruk kakaruk oukoumwan fárámp mo nánko, amo yinɨnk por sérrá, ‘Námo man te mér mono’rá sénaerapon.” ");
INSERT INTO yuj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nopok Pita man sérrá, “Wampweno! Ono fwap amont sumpwi nanampono. Ono amwan ‘Mér mono’rá sér te mo karono!” Ponankor mao éréképá yárak i konámp arop fárákapao kor ankár takrá sér. ");
INSERT INTO yuj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Takia pwarará, Jisas am fárákapént Getsemani yopwar mek tukup. Tukupea mao éréképá yárak i konámp arop fárákapan sérrá, “Yumo mapek yakápenke. Ono nkwapek youmpea kar toropwap nae.” ");
INSERT INTO yuj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aeria maok, mao Pita ntia Sebedimp namoráp yaworan mwar éréképea akwap. Oukoumwan te maomp nɨnɨk kápae nánko, yonkwae touwe tokwaerao man oupouroup. ");
INSERT INTO yuj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aenánko am fárákapan sérrá, “Ono wae sumpwi nanamp wonae fek nánko, ono yonkwae touwe tokwae rae. Yumo mapek yakáprá onont yérékrá yakápenke.” ");
INSERT INTO yuj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aeria yoump tae morokria yimetáp mwaeknámp apárok woukouprá arakrá kar toropwap, “Onomp Ayao! Amo fwap tak naeria te, ono touwe tokwae sámp nanamp kap má sámp-sɨnanapon. Aeno amo onomp nɨnɨkaoki kwapono, wampweno. Amo ankár waráp nɨnɨkaok sarápampo.” ");
INSERT INTO yuj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aeria pwarará akwapea mao éréképá yárak i konámp arop yinɨnkaopwean nke nánko, mao pampi yakáp. Aenapo, mao Pitan sérrá, “Yumo te mokopono? Yumo onont ankárankamp ke fek yépék mwanap pourou mo nie? ");
INSERT INTO yuj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yumo te ankár yérékrá kar toropwapenke! Takria yumo kwatae nɨnɨk fek tukupantáno. Tá kare, yiráp nɨnɨk te, fwap tak nae nɨnɨk napan maok, yiráp pourou te kárákáre mo námpon.” ");
INSERT INTO yuj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aeria maok, mao warko anánkan youmpea arakrá kar toropwap, “Onomp Ayao! Amo fwap mámá touwe sámp nanamp kap onan kárákár pɨk naenámp pourou mo nánko te, amo waráp nɨnɨkaok nanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tá warko youmpea nke nánko, am arop yinɨnkaopwe ouwipi kápae nánko pampi yakáp. ");
INSERT INTO yuj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mao am fárákapan pwarará warko yinɨnkan youmpea am manénkɨr kar toropwapi námp táman warko takrá sér. ");
INSERT INTO yuj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Warko mankea am arop fárákapan sérrá, “Yumo te oukoumwan pampria anepér rape? Yumo nkenke! Aropamp Tárápan kwatae nɨnɨkráp aropamp yaek pap naenámp ke te wokwae koropáne. ");
INSERT INTO yuj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yumo ferámp napo, nomo wae tukup mware. Arop onan yopor aropamp yaek sánk naerianámp wokwae wonae fik koropáne.” ");
INSERT INTO yuj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","48","Jisas oukoumwan kar sérrá yak nánko, Judas am éntér-sámpramp arop ou mekamp wae korop. Pris tokwae fákáre ntia Israel fi taokeyakáp konap aropao tirá kérépnap arop ou tokwae Judasént bainatráp yao ke tia korop. Aeria Judas am fárákapan sérrá, “Yumo nke napo, ono akwaprá man koupwiyakrá aop mukur namp te, am arop te Jisas támaono. Yumo ankár sámp kipo.” ");
INSERT INTO yuj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aerá séri pwarará, koupour kar Jisasnámpok koropria sérrá, “Kumuruk, Tisa.” Aeria mao wae man koupwiyakrá aop mukur. ");
INSERT INTO yuj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aenánko Jisas man sérrá, “Onomp nouroup e, amo am naeria korop nap te koupour takae!” Aeránko maok, arop fárákap wae koroprá paokoprá Jisasomp pourouk yae paprá wae sámp. ");
INSERT INTO yuj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aenapo maok, arop ankárankamp Jisasént yak námpao náráp bainat ak-sámprá pris taokeyaknámp aropamp tére aropan woupwi kor porokwapá aop-sɨr. ");
INSERT INTO yuj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aenánko Jisas man sérrá, “Bainat warko am mek norokorae! Arop ponankor bainat fek yorowaria te, ponankor bainat fek surumpwi mwarea napono. ");
INSERT INTO yuj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Amo te mér mori kwapono? Ono yorowar naeria te ono fwap onomp Naropwarén turunk nanko, mao fwap onan kápae kare ensel fákáre éntér-sámpramp fi ami kámákár akwap námp sáp naenámpono. ");
INSERT INTO yuj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aeno táte ono tak nanko te, Kwaromp Buk fek yaknámp kar te mokopia kare kar naenámpon? Kwaromp Buk fek sérrá, ‘Ankank ankár taknámp korop naenámpri námp támao korop námpon.’” ");
INSERT INTO yuj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Am ke fek táman Jisas am arop fákáreran sérrá, “Yumo onan sámp mwaria korop nap te, oukunrá yorowarinámp aropan sámp mwaria ni konap niamp bainatráp yao ke tia korop napwae! Ono kumur méntép lotu nap tokwae mek tankrá koumteouráp aropan kar farákápamp fek te, yumo onan sámp moiapono. ");
INSERT INTO yuj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aeapan maok, mámá ankank ponankor yumo onan napan maok, profet fákárerao kumwiap kar méntér pwi námpon.” Tá mao éréképá yárak i konámp arop fárákap te waeman Jisasén pwarará pɨrɨkɨmpá tukup. ");
INSERT INTO yuj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lo yénkrá farákáp konap arop fárákap ntia arop taokeyakáp konap arop, pris taokeyaknámp arop Kaiafasomp nap mek koupoukour yakáp. Aenapo arop fárákap Jisasén sámpea am nap mek warámpá tukup. ");
INSERT INTO yuj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aenapo, Pita maomp wakmwaek akwap námpao maok, akwapea panek tae morok yak. Mao am Kaiafasomp nap yári tenap mek youmpea plisman fákárerént tank. Mao te Jisasén apae mokop naprá nke nae ritea yépékrá tank. ");
INSERT INTO yuj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pris tokwae fákáre ntia Kaunsil fákáre arop ‘Jisas te arak námp’ ria yankar sénánko, am fek Jisasén farop mwaria ‘Am tak naenámp arop te maeno?’rá turunkup. ");
INSERT INTO yuj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kápae kare arop koropea yankar sérar. Aenapan maok, am kot wanap arop fárákap te am fek Jisasén farop mwanap ankank te nke mo kare. Aenapo wakmwaek arop anánkaopwe korop. ");
INSERT INTO yuj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Am anánkaopwerao sérrá, “Mámá arop te sérrá, ‘Ono fwap Kwaromp lotu nap tokwae párámpea yinɨnk yae fek saráp warko ti pwar nanamp’rá séri námpono.’” ");
INSERT INTO yuj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tá pris taokeyak konámp aropao fokopeyakrá Jisasén sér, “Amo te mae kar pwarokwaprá sénape? Mámá kar amo taki naprá sénap máte mokopono?” ");
INSERT INTO yuj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aerámpan maok, Jisas te kar sér mo. Aenánko mao warko sérrá, “Ono amwan yiki yak konámp Kwaromp e fek turunk nampono: Amo oukoumwan narekamp fou e sérae! Amo te Krais, Kwaromp Táráp ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nopok Jisas man sérrá, “Amo sénap támaono. Aeno ono yumwan sénampon: ‘Aropamp Táráp kápae kare kárákáreráp Kwaromp yae-párák mwaek yámar mek tankea wakmwaek koumwe yumuntukia ék nánko, nke mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas aerá sénánko, pris taokeyak konámp arop am kar wawia námokuráp waempyam pearákapria sérrá, “Mao te Kwarén wouroumprá sénámpono! Nomo apaerá arop ankwapamp kar wa mwaria wumwi mwanámpanáp? Mao waeman Kwarén wouroump sénánko, oukoumwan táman yumo wae wawi napono. ");
INSERT INTO yuj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Aeno yiráp nɨnɨk te mokop rape?” Tá nopok am fárákapao sérrá, “Mao te waeman kwatae nɨnɨk námpono. Ankár sumpwi naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aeránko oukoumwan arop fárákapao Jisasomp yimetápok atopia man porokwap. Tá ankwap fárákapao man yae kwae fek táraporeria ");
INSERT INTO yuj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sérrá, “Amo Kraisao nap kwamp te, amoku nɨnɨkia profet kar fek sérae, amwan te wa porokwapáne?” ");
INSERT INTO yuj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita am nap topok yár ménki porok youmpea tank. Aenánko am mek tére konámp yupu maomp wonae fik koropea sérrá, “Amo kuri amo Galili mekamp Jisasént yakapono.” ");
INSERT INTO yuj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Táte Pita kápae kare arop wa nap fek sérrá, “Mono! Ono te amo sénap kar am te mér mo nampono.” ");
INSERT INTO yuj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aeria mao yár ménki wonae fik akwap naeria nánko, am mek tére konámp yupu ankwap man nkea wonae fik yakápnap koumteouráp aropan arakrá sér, “Mámá arop máte wokwaek Nasaret mekamp Jisasént yakámp aropono.” ");
INSERT INTO yuj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tá Pita monoria warko arakrá sér, “Kare kar narekampráp, ono am arop te mér mo nampono.” ");
INSERT INTO yuj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aeránko maok, wakmwaek tae morok arop ankwap fárákap am fek yakáp nap koropea Pitan sérrá, “Kare karono, amo te am fi mekamp aropono. Waráp kar te am fi mekamp aropamp kar niamp sénapono.” ");
INSERT INTO yuj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Oukoumwan te Pita ankár kar kárákáre fek arakrá sér, “Kare kar narekampráp, ono am arop te mér mo nampono.” Takrá séri pwar nánko wae kakaruk aráp. ");
INSERT INTO yuj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aenánko Pita warko námwan Jisaso sérimp kar nɨnɨk. Mao sérrá, “Kakaruk oukoumwan aráp mo nánko amo yinɨnk por onan ‘Mér mo namp’rá sénanapono.” Aerimpan nɨnɨkia Pita wae yár younkwek oukur akwapea éma waempon. ");
INSERT INTO yuj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wae takrá yakáp napo akwapea wakor nánko, pris tokwae ponankor, tá Israel fi taokeyakáp i konap arop fárákap takia Jisasén farop mwanap kar sérar. ");
INSERT INTO yuj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Takia pwarará, am fárákapao Jisasomp yae yawor sen fek yarokwapea Gavman Tokwae Pailatonámpok sámpá tukup. ");
INSERT INTO yuj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Oukoumwan te am Jisasén arop outɨrinámp arop Judas te mao nke nánko, Jisasén kotria man sumpwi pap mwanap niamp. Aenapantá mao warko ankwap nɨnɨk sámpea am 30 mani silva am pris tokwae fákáre ntia arop taokeyakáp i konap aropaonapok arákarrá sámpá akwap. ");
INSERT INTO yuj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Aeria sérrá, “Ono kwatae nɨnɨki tenae! Ono kwapwe kare aropan yopor aropamp yaek páte nanko, mao sumpwi naenámp niampáne.” Aeránko maok, am fárákapao sérrá, “Am te yinomp ankank mono. Amoku waráp ankankono.” ");
INSERT INTO yuj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aerapo maok, Judas am mani silva lotu nap tokwae mek sɨrarrá pwarará akwapea námoku paok fek oumpour kor fek tokoropea sumpwi yak. ");
INSERT INTO yuj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pris tokwae fákáre am mani silva am sámpea sérrá, “Mámáte arop sumpwi pap nap fekamp manino. Nomo lotu nap tokwae mekamp manint pap mwareano.” ");
INSERT INTO yuj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aeria maok, námoku kar papea fákeyakáprá, am mani fek apár kwar fekamp sospen yoro i konámp aropamp apár sámp. Aeria am arop fárákapamp nɨnɨk te “Am apár mek panekamp arop koropá yakria sumpwi nánko, am mek pap mwanámpon!” ");
INSERT INTO yuj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aeria maok, am apár e tákaprá ‘Yɨriráp Apár’ ri papapon. Tá am e te oukoumwan taki yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Aenámpan am te wokwaek Kwaro Profet Jeremaiamp top korént purá sérimp kar te oukoumwan take pourouráp wae korop námpon. Mao sérrá, “Arop fárákapao am 30 mani silva sámpea napo, Israel fákárerao am aropan nopok sánk mwanámpria séri tari napan, am mani fek kwar fekamp sospen yoro i konámp aropamp apár sámp mwanapon. Tokwae Karao onan arakrá sérimp niampon.” ");
INSERT INTO yuj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisasén santukupea Gavman Tokwaerao nke námp fek pwate napo, fokopeyak. Aenánko Gavman Tokwaerao man turunkrá, “Amo te Juda firamp king nie?” Tá Jisas sérrá, “Amoku támao takrá sénapono.” ");
INSERT INTO yuj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pris tokwae fákáre ntia arop taokeyakáp konap arop wae man nkwakwe make kar fek kot. Aenapan maok, Jisas te nopok kar ankwap pwarokwaprá sér mo. ");
INSERT INTO yuj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Aenánko Pailato man sérrá, “Arop ponankor amwan kotria má sérarnap kar te wa mák rape?” ");
INSERT INTO yuj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tá Jisas nopok Pailatomp kar pwarokwaprá sér mo. Aenámpantá maok, Gavman Tokwae te nɨnɨk tokwae. ");
INSERT INTO yuj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yopwar méntép am anepérnap yae fek Gavman Tokwaerao kalabus nap mekamp arop ankárankamp sámp-kérép konámpon. Ae konámpara, koumteouráp aropao námoku arop ankárankamp sámp-kérépaeria maomp e sénapo, Pailato am arop táman mwar sámp-kérép konámpono. ");
INSERT INTO yuj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Arop ankárankamp maomp e te Barabas, arop ponankor, kwatae kare aroprá nɨnɨk i konap yak námpono. Jisasén kot nap ke fek Barabasén kalabus nap mek páte napo yak. ");
INSERT INTO yuj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Koumteouráp arop koupoukarrá yakáp napo, oukoumwan Pailato am fárákapan turunkrá, “Yumo nɨnɨk nap te, ono kalabus mekamp wan yumonapok sámp-kérép nanampono? Ono Barabasén sámp-kérép nanamp ni, Jisas ‘Krais’rá sér i konap man sámp-kérép nanamp nie?” ");
INSERT INTO yuj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mao te wae mér, am Juda taokeyakápnap arop fárákap te arop fárákap Jisasén warákárrá man éntér paprá tukup napo, am táman kokwarokria man kot napon. ");
INSERT INTO yuj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailato arop yurukup i konámp sia fek tank nánko, maomp yupuao kar arakrá sámp-kérép, “Amo te am yae-párák kare aropan te nkwak maki kwapono. Ono kumuruk man yém nkea pwatea yonkwae sakáp tokwae nampono.” ");
INSERT INTO yuj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pris tokwae fákáre ntia arop taokeyakáp konap arop fárákap koumteouráp aropamp nɨnɨk mek koupoump napo, am fárákapao ankár Pailatén wumwirá, ‘Barabasén te sámp-kérépae! Jisasén te faropanápono’ ria wae. ");
INSERT INTO yuj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tá Pailato warko turunkrá, “Yumo nɨk nap te, mámá arop yawor te maeran sámp-kérép nanampono?” Am fárákapao sérrá, “Barabasén sámp-kérépae!” ");
INSERT INTO yuj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailato am fárákapan sérrá, “Ae te ‘Jisas Krais’rá sér i konap man te mokop nanampono? Aeránko am fárákap ponankor sérrá, “Yaopwae porokopramp fek pukupenke!” ");
INSERT INTO yuj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tá Pailato sérrá, “Apae riteanono? Apae kwatae ankanki námpono?” Aeránko am fárákap tékén kárákáre fek sérrá, “Yaopwae porokopramp fek pukupenke!” ");
INSERT INTO yuj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Oukoumwan te Pailat nɨnɨk nánko maomp kar te ankore mek yak nánko, arop fárákapao kar yorowar tokwae napantá, mao ént yɨnkɨpea arop fárákapao nke nap fek yae yárária pwarará sérrá, “Máte onomp kwatae nɨnɨk mono. Táte mámá arop sumpwi námp te yumoku napono.” ");
INSERT INTO yuj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tá koumteouráp arop ponankor nopok sérrá, “Am te yinokunámp ankankono. Kotria te, yinoku, tá yinomp tárápuamp pourouk korop naenámpono!” ");
INSERT INTO yuj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aenapantá Pailat Barabasén am fárákapaonapok sámp-kérép. Tá Jisasén maomp soldia fákárerao ain tákáre tokoropramp paok fek Jisasomp younkwe mwaek porokwap. Takia sámpá tukupea yaopwae porokopramp fek pukup mwaria. ");
INSERT INTO yuj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gavman Tokwaeramp soldia fákáre Jisasén porokwapea pwarará Gavman Tokwaeramp nap mek warámpá yinkea soldia ponankor man ɨkɨr yakáp. ");
INSERT INTO yuj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aeria man wouroumpria maok, námokuráp waempyam koupour kar worokwapea sɨrarrá paokoprá, kingo yirɨmp konámp niamp waempyam noumouri sámpea Jisasomp pourouk yirɨmpea pwar. ");
INSERT INTO yuj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tá wiráp paok wi moukoupea kingomp kump niampia maomp me korok yirɨmp. Tá kingo sámpá tank konámp niamp yaopwae sámpea maomp yae-párák mwaekamp yaek sánk. Aeria maomp wonae fik kwaráp torokomprá kar wouroumprá séria arakrá sér, “Yo...! Juda firamp king e!” ");
INSERT INTO yuj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aeria man atopia maomp yaekamp yaopwae pwarokwaprá Jisasén me korok wiráp paok wi yirɨmp tenap yumuntuk purá porokwap. ");
INSERT INTO yuj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Man wouroumprá séria pwarará, am waempyam noumouri worokwapea paprá námokuráp waempyam warko yirɨmpá pwar. Takia pwarará, waeman yaopwae porokopramp fek pukup mwaria sámpá tukup. ");
INSERT INTO yuj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mao tukupria mwaeaok Sairini mekamp arop ankárank maomp e te Saimon, man Jisasén pukup mwanap yaopwae Jisas námoku samp námp, má sampaeria wae napo, mao am kake samp. ");
INSERT INTO yuj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wae tukupea apár e Golgota fek am e fi te ará, “Arop Me Kor Yaknámp Apár.” ");
INSERT INTO yuj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aeria am fárákapao wain ént more konámp marasin méntér ouroukoupramp, touwe anámp tae morokanoria Jisasén sánk. Aenapo, mao kánanke mi námpao maok, fár mo. ");
INSERT INTO yuj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Am fárákapao wae Jisasén yaopwae porokopramp fek nil fek pukupá pwarará, maomp waempyam ankank te wa mokop sámp naenámpaoeanrá nke mwaria, satu pilairá tankáp. ");
INSERT INTO yuj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Am fárákap am fek tankáprá yépékrá tankáp. ");
INSERT INTO yuj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Narek Jisas yépe kor páte yak námp fek kar Jisasén kotinap am arakrá kumwi: Mámáte Jisas Juda firamp Kingono. ");
INSERT INTO yuj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wonae fik Jisasén pukup tenap fek yorowaria ankank pouroukoup nep arop anánkaopwe, ankwap Jisasomp yae-párák mwaek, ankwap yae-mánkwan mwaekia pukupá pwar. ");
INSERT INTO yuj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aetenapo, koumteouráp arop fárákap am mwaek tukupá koroprá te, Jisasén narek pukup tenap táman nke ko me kor párámpárrá kar wouroumprá sér. ");
INSERT INTO yuj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Aeria sérrá, “Amo te ‘Lotu nap tokwae párámpea yinɨnk yae fek saráp ti nanamp’ ri napara, amo amoku yaewourae! Amo Kwaromp Táráp kareao nap kwamp te, yaopwae porokopramp pwarará apárok ékae!” ");
INSERT INTO yuj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pris tokwae fákáre ntia lo yénkrá farákáp konap arop fárákap, tá arop taokeyakáp konap arop fárákapao kor narek Jisasén nkea arakrá wouroumprá sér, ");
INSERT INTO yuj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Mao te arop ankwapan yaewour i konámpao maok, námoku kare te yaewour naenámp pourou mono. ‘Námo Israel firamp King’rá sér i konámpara, yaopwae porokopramp pwarará apárok ék nánko, yino táman nkea mér mwaro. ");
INSERT INTO yuj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mao Kwaromp Tárápria námwan fwap mao yaewour naenámprá mérámpara, Kwaro man warákár námp kwamp te, mao fwap oukoumwan yaewourano.” ");
INSERT INTO yuj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Loan yorowaria ankank pouroukoupnep arop yawor Jisasomp wonae fek pukup tenap arop mao kuri ankár taknámp wouroumprá sér. ");
INSERT INTO yuj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yámar kuk nánko kɨrɨkɨp tokwae ponankor apár oupouroupá yakrá akwapea kumur mwaek yámar yinɨnk ke nánko, ");
INSERT INTO yuj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","tá yámar yinɨnk ke námp fek táman Jisaso Kwarén tékén arakrá wumwi, “Eli, Eli, lama sabaktani?” Am kar fi te arakrá sér, “Onomp Kwar e! Onomp Kwar e! Amo onan apaerá pwararape?” ");
INSERT INTO yuj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Táte, arop ankwap fárákap wonae fik foukouri yakáp nap, am kar wawia sérrá, “Mámá arop te Elaijan wumwi námpono.” ");
INSERT INTO yuj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aeria arop ankárankamp koupour kar akwapea yir niamp ankank sámpea top i konámp wain ént mek anámpea yaopwae fek paprá yarokwapea narek Jisasén fáranoria maomp táp mek sánk. ");
INSERT INTO yuj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aenánko maok, ankwap fárákapao sérrá, “Sɨkono! Nánkár Elaija koropea man yaewour te mokopon nke mwaro!” ");
INSERT INTO yuj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aenapo maok, Jisas warko tékén wumwiria maomp waemp sámp-kéréprá sumpwi. ");
INSERT INTO yuj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Am ke fek táman waempyam tokwaeri lotu nap tokwae fek tokorop tenap nareknámpia pearákarrá pɨkia ankorek fu fek por-pwararea anánk mwaek peari yak. Aenánko némp yérur tokwaeria péri tokoprá pɨkrɨnk. ");
INSERT INTO yuj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aenánko Kwaromp firáp kápae kare koumteouráp arop wokwaek surumpwiapo, apár me mek kákap, am apár me kɨkɨrɨp akwapránk nánko, warko fápárámp. ");
INSERT INTO yuj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Am fárákap apár me pwarará wakmwaek Jisas warko fárámp nánko, am fárákap yiki kor taun Jerusalem mek yink napo, kápae kare arop am fárákapan nkeapono. ");
INSERT INTO yuj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kepten ntia soldia fákáre mént yakáprá Jisasén yépékrá yakápap fárákap am némp yérur nánko, koropnámp ankank táman nkea apáp tɨrɨnka wae. Aeria am fárákapao sérrá, “Námwan kare karono! Mámá arop te Kwaromp Tárápono!” ");
INSERT INTO yuj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kápae kare koumteou wokwaek Jisasomp wakmwaek paokop i konap Galili meknámp man yaewour mwaria korop nap, am koumteou fárákap panek tae morok yakáprá tokor yakáp. ");
INSERT INTO yuj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ankwap am ou mekamp te Makdala mekamp Maria, ankwap te Jems ntia Josepomp éntupwar Maria, ankwap te Sebedimp tárápyaramp éntupwar. ");
INSERT INTO yuj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Takia kumur mek Arimatea mekamp mani tokwaeráp arop maomp e te Josep, mao korop. Mao kuri Jisasén mérnámp arop támaono. ");
INSERT INTO yuj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mao akwapea Pailatén turunkia Jisasomp yákáre sámp naerianánko maok, Pailato soldia fákáreran sénánko, am yákáre sámpea Josepén sánk. ");
INSERT INTO yuj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep am yákáre sámpea yiki kare wupwi kor waempyam fek papea yarokwap. ");
INSERT INTO yuj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yarokwapea sakwapea péri kor me wourékam mao námokuráp por fourrá youmpnámp mek pap. Aea maok, péri kor worare tokwae sámp-farfarrá koropea me fek kéri pwar. Mao taki pwarará, wae akwap. ");
INSERT INTO yuj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aenánko Makdala mekamp Maria ntia ankwap Maria am yupuyarao mwar yakria am péri kor me yak námp fek tankrá tokor tank. ");
INSERT INTO yuj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pampia koumounek am sabat yae fek táman pris tokwae fákáre ntia Farisi fákáre tukupea Pailatonámpok koupoukour. ");
INSERT INTO yuj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Am fárákapao sérrá, “Arop Tokwae, yino am yankar sérar i konámp arop oukoumwan yiki yakámp fek sérimp kar nɨkriano. Mao sérrá, ‘Nánkár wakmwaek yinɨnk yaek yakea warko fárámp nanamp’rá sérimpon. ");
INSERT INTO yuj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Takria maomp éréképá yárak i konámp arop fárákap kánánkámp koropea yákáre sámpá tukup tea koumteouráp aropan kwekárrá sérrá, ‘Mao warko fárámp námpono’rá sérantáno. Aenapo am oukoumwan kwekárrá sénap kar am wokwaekamp kwekárrá sér i konapan kámákár akwapantáno. Aeantáno, amo soldian sénapo, péri ménki fek kárákáre fek kéri pwate napo, yinɨnk yae fek am fek yérékrá yakáp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tá am fárákapan Pailato sérrá, “Takanánko te, yumo tukupea taokeyakáp mwanap arop éréképenke. Aeria yumo tukupea am yákáre papramp péri kor me táp kárákáre fek kéri pwarenke.” ");
INSERT INTO yuj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aeránko maok, am fárákap tukupea péri kor me topok kéria pwarará, am mek yoump tenapo nke mwanapria péri kor me táp fek táraoki pwarará, soldia ankwap fárákap am fek yérék mwanap káká pwar. ");
INSERT INTO yuj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat yae akwapá pwar nánko, yae ankárank Sande fek yámar aok naenámp wonae fik nánko, Makdala mekamp Maria ntia ankwap Maria am Jisasén papnap péri kor me nke neria korop. ");
INSERT INTO yuj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aenepo koupour kar némp yérur tokwae nánko, Tokwae Karamp ensel yámar mek pwarará, ékia péri me táp fek oupouroupá yaknámp yumwi worare tokwae sámp-farfarrá akwapria am yumwi worare yumuntuk tank. ");
INSERT INTO yuj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Maomp yimetáp te mékér wae niamp nánko, maomp waempyam te yámar mekamp koumwe waentar niampono. ");
INSERT INTO yuj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aenánko soldia fákáre am táman nkea apáp tɨrɨnkrá kour me woukouria, ke sorokwamprá wae surumpwi yakáp nap niamp pourouráp. ");
INSERT INTO yuj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aenapo maok, ensel am yupuyaran sérrá, “Yumo te apápi kepono? Ono wae mér, yumo te am Jisas, arop fárákapao yaopwae porokopramp fek pukupap táman oupourounkrá korop nepono. ");
INSERT INTO yuj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mao te mapek yak mono. Mao wokwaek sérimpnámp taknámp wae fárámp teane. Yumo koropea mao ampinámp népe nkenke. ");
INSERT INTO yuj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yumo koupour akwapea maomp éréképá yárak i konámp arop fárákapan sér kipo: ‘Mao te wae péri me meknámp fárámp tenámpono. Mao te yumwan mekia akwapea Galili mek nánko, yumo man ampok nke mwanapon.’” Aerá séria yupuyaran sérrá, “Kwaro onan, am kar séraerá sámp-kérépnámp fi támaono.” ");
INSERT INTO yuj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tá am yupuyar te apáp nepao maok, warákár tokwaeria koupour kar péri kor me pwarará, mao éréképá yárak i konámp arop fárákapan séneria fárakoprá akwap. ");
INSERT INTO yuj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tá Jisaso am yupuyaran mwaeaok kɨkɨpia sérrá, “Koumounek, yupuyar e!” Aeránko, am yupuyar akwapea maomp wonae fikria puk sámpria man lotu. ");
INSERT INTO yuj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aenepo, Jisas am yupuyaran arakrá sér, “Yumo te apápi kepono. Yumo akwapea onomp ankwapyae fákáreran, ‘Mao te “Galili mek tukupea onan ampok nke mwanapono” ’rá sér kipo.” ");
INSERT INTO yuj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Am yupuyar oukoumwan akwap nepo, péri kor me tápok yérékiap soldia fárákap taun mek tukupea pris tokwae fákáreran am ankank korop námp am sérar. ");
INSERT INTO yuj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aenapo, pris tokwae fákáre ntia taokeyakáp konap arop fárákap námoku kar papea fákeyakáprá séraria, am soldia fákáreran mani tokwae nénkea, ");
INSERT INTO yuj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","sérrá, “Yumo ankár ‘Yino pampi tenánko, maomp éréképá yárak i konámp arop fárákapao kumuruk koropea maomp yákáre sámpá tukup tenap’rá sérar kipo. ");
INSERT INTO yuj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Táte Gavman Tokwae yumo am péri kor fwapia taokeyakáp monap kar mámá wa nánko te, yino fwap man ankwap kar sénánko, yumo te fwapono.” ");
INSERT INTO yuj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aeria am soldia fákáre pris tokwaerao sénapaokria ‘Jisasomp firáp aropao maomp yákáre sámpá tukup tenap’rá sérarrá, tukupea napo, oukoumwan kor am kar Judia fi mek taki yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Am mom-sámpramp arop tukupea Galili mek Jisas ‘Tukup kip’rá sérimp faonkwek tukup. ");
INSERT INTO yuj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aeria maok, am fárákapao am fek Jisasén nkea man lotu. Aeapao maok, ankwap fárákap te oukoumwan, mao te kare Jisas támaoiane? rá nɨnɨk. ");
INSERT INTO yuj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tá Jisas am fárákapamp wonae fik koropea sérrá, “Kwaro onan mámá apár mek yaknámp ankank ntia yámar mekamp ankank ponankor taokeyak nanamp kárákáre tokwae sáp námpono. ");
INSERT INTO yuj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aenámpara, yumo te ankár tukupea kápae kare arop fi onomp firáp arop arárrá kák kipo. Aeria yumo am fárákapan onomp Naropwaromp e fek, tá onomp e fek, tá Yiki Kor Spiritamp e fek ént mek nérrá kák kipo. ");
INSERT INTO yuj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tá yumo ankár am fárákapan ono yumwan farákápnamp kar am mántwaokanáponrá farákáp kipo. Yumo fwapia wawenk: Ono fwap ponankor ke fek yumont yakrá akwapea am yae pwar námp fek nanampono.” ");
INSERT INTO yuj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mámá kar mámáte Kwaromp Táráp Jisas Kraisoimp Kwapwe Kare Karono. ");
INSERT INTO yuj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mámá manénkɨr korop námp máte profet Aisaia wokwaek kumwimp niampon. Kwaro arakrá sér: “Wawenke! Ono onomp kar farákáp naenámp arop ankárankamp sámp-kérép nanko, manénkɨr mao akwapeaka waráp por mwae kup yoroano. ");
INSERT INTO yuj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Arop yak mo apár meknámp kar ankwap tékén arakrá sér: ‘Tokwae Karampor mwae kup yoroenke! Mao akwap naenámp mwae kup fwapokwapenke!’” ");
INSERT INTO yuj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kwaro séri námpnámp taknámp Jon ént mek énér i konámp arop mao te arop yak monámp apár mek akwapea maok, mao koumteouráp aropan kar farákápria sérrá, “Yumo te yiráp kwatae nɨnɨk pwararea ént mek nér napo maok, Kwaro yiráp am nɨnɨk kwatae tirá épér naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aeránko maok, apár Judia mekamp koumteouráp arop ponankor, tá Jerusalem mekamp koumteouráp arop ponankor Jononámpok tukupea náráp kwatae nɨnɨk am farákáp napo maok, Jono am fárákapan ént Jordan mek nérrá kák. ");
INSERT INTO yuj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon te kamel pwae fek yoroinap waempyam yirɨmpea maok, fɨr yɨpi fekamp sépér fákap. Aea maok, mao te tákár ntia yao pwae mekamp éntu éntan fárimpon. ");
INSERT INTO yuj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aeria maok, mao kar arakrá farákáp: “Arop ankárank onomp wakmwaek korop námp te maomp kárákáre onomp kárákáreran kwe-pwar námpon. Ono te apárok kánanke kare yak nampara, ono maomp wonae fik kwaráp torokompria maomp su fekamp paok aokorop nanamp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ono te yumwan ént fek nérrá kák nampono. Mao te yumwan Yiki Kor Spirit fek nérrá kák naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Am ke fek táman maok, Jisas apár Galili mekamp Nasaret meknámp korop nánko, Jono man ént Jordan mek anámpámp. ");
INSERT INTO yuj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aeanánko maok, ént meknámp forokor tará aokrá kárák fek fokop nánko, koupour kar narek yámar me kɨkɨr akwap nánko, nke nánko maok, Yiki Kor Spirit ant yuri niampao maonámpok ék. ");
INSERT INTO yuj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aenko maok, yámar meknámp arop kar niamp wumwiria sérrá, “Amo te onokump táráp kare ara, ono amwan warákár tokwae nampon. Amo kwapwe kare nɨnɨk nap te, ono yonkwae kárámp nampono.” ");
INSERT INTO yuj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aenko am ke fek táman, Yiki Kor Spiritao Jisasén kwar saráp mek sámp-kérép. ");
INSERT INTO yuj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aenko maok, mao am kwar saráp mek am mek 40 yámar yakánko maok, tá Satano koropea man poupwekáp. Mao yao pwae mekamp fɨrént yakánko maok, ensel fákáre man yaewouriapon. ");
INSERT INTO yuj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","King Herot Jonén fákapá papánko maok, Jisas distrik Galili mek koropeaka Kwaromp Kwapwe Kare Kar farákáprá yárakimp. ");
INSERT INTO yuj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mao sérrá, “Kwaro sérimp ke te oukoumwan te wae korop námpon. Kwaromp firáp taokeyak naenámp te wae wonae fik korop námpon. Yumo kwatae nɨnɨk pwarará Kwapwe Kare Kar má wawiaka, karenorá mérenke!” ");
INSERT INTO yuj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisaso ént aokore Galili firi pokria nke nánko maok, Saimon ntiaka Andru mwearao ént aokore mek umben sɨrarrá yak. Am arop yawor te éntékam tirá am fek mani sámp konepon. ");
INSERT INTO yuj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aepo maok, Jisas am arop yaworan sérrá, “Yumo te onomp wakmwaek koropenke! Ono yumwan Kwaronámpok arop éréképá korop konap yénkép nanampono.” ");
INSERT INTO yuj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aeránko maok, am arop yaworao kor koupour kar umben fekamp tére pwarará maomp wakmwaek akwap. ");
INSERT INTO yuj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Takia tukup tae morokria nke nánko maok, Sebedimp tárápyar Jems ntiaka Jon mwearao kor bot mek yakrá umben aompoprá fwapokwaprá yak. ");
INSERT INTO yuj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aepo maok, Jisaso wumwi nánko, am arop yaworao kor naropwar Sebedi ntia tére konap arop mént bot mek yakáp napo maok pwarará, am arop yawor Jisasén éntér paprá akwap. ");
INSERT INTO yuj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aea maok, am fárákapao taun Kaperneam mek tukupea maok, Sabat yae fek Juda firamp lotu nap mek youmpea maok, Jisas koumteouráp aropan kar farákáp. ");
INSERT INTO yuj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aenko maok, am fárákapao kor maomp kar wariaka kokorokor. Mao te Kwaromp lo yénkrá farákáp konap arop fárákapamp kar farákáp niamp mono, ankár mér tokwaeráp aropamp kar kárákáre niamp fek am fárákapan yénkrá farákáp námpon. ");
INSERT INTO yuj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Am ke fek táman am fárákapamp lotu nap mek koropnámp arop ankwap, maomp pourouk kwatae-aropao noumpoukoupá yaknámp Jisasén tékén wumwi kar fek sérrá, ");
INSERT INTO yuj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasaret mekamp Jisas, amo yinan te apae naeria nape? Ae te amo yinan kwatae pap naeria korop rape? Ono te wae mér nampon: Amo te Kwaromp yiki kare aropono.” ");
INSERT INTO yuj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Aeránko maok, Jisas am kwatae-aropan yoporia sérrá, “Amo kari kwapono. Am arop pwarará akwapae!” ");
INSERT INTO yuj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aeránko maok, am kwatae-arop am aropamp pourouk noumpoukoupá yakeanámp te pu yae youria fépén tokwaea pwarará worokor pɨk. ");
INSERT INTO yuj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aenánko maok, koumteouráp arop ponankor kour me woukouria maok, am fárákapao námoku támao sérarrá, “Máte apaenono? Máte kar wourékamono! Mámá arop máte kárákáre kourono! Aenámpara, mao am kwatae-aropan kar sénánko, am fárákapao maomp kar wawi konapono!” ");
INSERT INTO yuj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aenánko maok, maoinámp kar Galili mekamp arop fi am ponankor am kar koupour yárak nánko wawia pwi napon. ");
INSERT INTO yuj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Am fákárerao lotu nap meknámp youmpea ek tukup. Tukupea maok, koupour Saimon ntiaka Andrump nap mek yoump. Tá Jems ntiaka Jon méntér akwap. ");
INSERT INTO yuj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aeapo maok, Saimonomp yupuramp éntupwar kákánar fek pourou touwe fokornámp touwe sámpea amp. Aenko maok, koupour Jisasén ‘Touwean’rá sér. ");
INSERT INTO yuj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aeapo maok, Jisaso maonámpok youmpea man yaek sámpea papánko maok, am pourou touwe fokornámp touwe am worokor pɨkánko maok, mao fárámpea am fárákapao fár mwanap fɨr yankapámpon. ");
INSERT INTO yuj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Takia maok, kumuran yámar porokor nánko, ankwap fárákap touwenap arop éréképeaka maonámpok korop. Aeria maok, koumteouráp aropan kwatae-arop noumpoukoupea yaknámp fárákapan kor éréképá korop. ");
INSERT INTO yuj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aeria maok, am taun mekamp koumteouráp arop ponankor koropeaka am nap topok koupoukour. ");
INSERT INTO yuj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Aeapo maok, Jisaso koumteouráp arop kápae kare nkwakwe make touwe sámpá yakáp napan fwapokwap. Aeria maok, am fárákapamp pouroukamp kwatae-arop kápae kare yéréperá kérép. Aemantá maok, am kwatae-aropao kor mao te wanonorá mérapantá maok, mao am fárákapan ‘Kar sérari kwapono’ ria maok, fou e séri pwar. ");
INSERT INTO yuj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Koumounek kar oukoumwan kɨrɨkɨp yak námp mek, Jisas fárámpeaka oukur tará apárok arop yak mo nap fek akwapea námoku mwar am fek yakrá Kwarén kar toropwap. ");
INSERT INTO yuj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Aenánko maok, tá wakmwaek Saimon ntia maomp ankwapyaenáp fárákap tukupea Jisasén nke. ");
INSERT INTO yuj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Am fárákap man nkea maok, sérrá, “Ponankor koumteouráp arop amwan oupourounk nape.” ");
INSERT INTO yuj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aerapo maok, mao am fárákapan sérrá, “Ae te wampweno. Nomo wonae fik mwaekamp némp-némp paokoprá tukup mwaro. Ono am fárákapan kor kar farákáp nanampria am táman ono korop nampono.” ");
INSERT INTO yuj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aea maok, mao am apár Galili mekamp ponankor némpoukmwaek yárakria maok, am arop firamp lotu nap mek am fárákapan kar farákáprá yárak. Aeria maok, kwatae-arop yéréperá kérépámpon. ");
INSERT INTO yuj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aenko maok, lepra arop ankárankamp maonámpok koropea maok, kwaráp torokompria man koupoute kar sérrá, “Jisas, amo tak naeria nap kwamp te, onan fwapi pap napo, onomp pourou fwap yiki kukur naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aeránko maok, Jisaso man aropompria maok, maonámpok nárákarrá maomp pourouk yae papria sérrá, “Onomp nɨnɨk te waráp touwe wae pwar nánko, amo fwapi yakae.” ");
INSERT INTO yuj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aeránko maok, am fek táman am lepra touwe wae pwar nánko, mao wae kwapwe kare yak. ");
INSERT INTO yuj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jisaso man kar kárákáre fek arakrá sér, “Amo te mámá ankank waráp pourouk korop námp máte, arop ankwapan séri kwapono. Amo akwapea prisén waráp pourou yénképria maok, Moseso sérimpnámp waráp lepra touwe fwapnámp ofa sánkampo. Aenapo maok, arop nkea waráp touwe wae pwar námp mér mwanapono.” Aerá séria pwarará, man sámp-kérép. ");
INSERT INTO yuj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aerá séránko, akwapámpao maok, koumteouráp aropan am kar farákápria maok, kápae kare némpoukmwaek farákáp. Aemantá maok, Jisaso kor, taun mek akwap nanko, koumteouráp arop kápae kare námwan koropá ɨkɨrantánoria akwap mo. Mao te ankár am arop yak mo nap fek am fek saráp yak nánko maok, koumteouráp arop némp-némp ponankor maonámpok korop. ");
INSERT INTO yuj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Aea maok, ankwap kumuruk Jisas warko taun Kaperneam mek arákarrá akwapeaka, nap mek yak. Aenánko maok, koumteouráp aropao, mao nap mek yakánrá sénap kar wa. ");
INSERT INTO yuj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aeria maok, kápae kare koumteouráp arop koropea nap mek néntépapo, am nap te wae fákapánko maok, táte ménki fek mwaek kor népe yak mo. Aenánko maok, mao am fárákapan kar farákáp. ");
INSERT INTO yuj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Aenánko maok, arop ankwap maomp kour ponankor surumpwi yaknámp, arop yiaworaopwerao sunkwiar mek papea Jisasnámpok sankorop. ");
INSERT INTO yuj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sankoropea maok, nkeapo am fek te koumteouráp arop néntépa waeapo maok, am Jisasomp wonae fik sayink mwanap pourou mo. Aenámpantá maok, am arop kakapea nap yumuntuk pokea maok, nap oupouroup tenap ankank keakapea am meknámp am arop sunkwiar paok fek tokoropea, yaek fákeyakáprá ér-popwarrá pɨkia Jisasomp wonae fik pap. ");
INSERT INTO yuj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aenapo, Jisaso am fárákapao man mérnap nkea maok, am touwenámp arop táman sérrá, “Táráp e! Ono waráp kwatae nɨnɨk te wae sámp-sɨnampono.” ");
INSERT INTO yuj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aeránko maok, am nap mek tankápnap Kwaromp lo yénkrá farákáp konap arop ankwap fárákap náráp nɨnɨk mek arakrá nɨnɨk, ");
INSERT INTO yuj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Am arop te apaeritea takrá séri námpon? Mao am kar sénámp te Kwarén ér-pwar námp nie? Arop ankwap ankárankampao kwatae nɨnɨk tirá épér naenámp pourou mono. Am te Kwar ankárankao saráp maok tak i konámpono.” ");
INSERT INTO yuj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aerapo maok, Jisas koupour kar am fárákapamp nɨnɨk wae méria maok, arakrá turunk, “Apaeritea yumo takrá nɨnɨk napono? ");
INSERT INTO yuj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ono mokope kar fwap pwi yaknámp sénanampon? Ae te ono sérrá, ‘Ono waráp kwatae nɨnɨk sámp-sɨtenamp’rá sénamp támao fwap pwi yak námp ni? Tá ono sérrá, ‘Amo fárámprá waráp am fek ampinap ankank sámpea akwapae’rá sénamp támao fwap pwi yak námp nie? ");
INSERT INTO yuj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aeno ono nɨk namp te yumo ankár arakrá mérenkria nampon: Aropamp Táráp Kwaro man, mámá apár fek takaeria kárákáre sánkeanánko, am fek mao fwap aropamp kwatae nɨnɨk tirá épér naenámpon.” Aerá séri pwarará maok, am kour surumpwi yaknámp aropan sérrá, ");
INSERT INTO yuj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ono amwan sér rae: Amo fárámpea waráp ampinap ankank sámpea amokuráp nap mek akwapae!” ");
INSERT INTO yuj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aeránko maok, mao fárámprá am koumteouráp aropao nke nap fek koupour náráp amp i konámp ankank sámpea akwap. Aenánko maok, arop ponankor kokorokoria maok, Kwaromp e sakapria arakrá sér, “Wokwaek kar yino te make ankank nke moimpon!” ");
INSERT INTO yuj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Takia pwarará, Jisaso warko ént aokore yaknámp mwaek akwap nánko maok, koumteouráp arop kápae kare maonámpok korop napo maok, mao Kwaromp kar am fárákapan farákáp. ");
INSERT INTO yuj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aea maok, mao akwapea nke nánko, Alfiusomp táráp Livai takis sámp konap nap mek tank. Tank nánko maok, Jisaso man sérrá, “Onomp wakmwaek koropae.” Aeránko maok, mao kor fárámprá maomp wakmwaek akwap. ");
INSERT INTO yuj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wakmwaek Jisaso námoku éréképá yárak i konámp arop fákárerént Livaimp nap mek tankáprá fépér. Aenapo maok, kápae kare takis sámp konap arop, tá aropao ‘Kwatae nɨnɨkráp arop’rá sér i konap am arop fárákap Jisas apaean nke mwaria maomp wakmwaek paokop nap, am ankwap fárákap énénki tankáprá fépér. ");
INSERT INTO yuj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tá lo yénkrá farákáp konap Farisi fákárerao nkeapo maok, Jisaso takis sámp konap arop, tá kwatae nɨnɨkráp arop makia mént tankáprá fépérapo maok, am fárákapao Jisas éréképea yárakinámp fákáreran sérrá, “Mao te apaeritea am takis sámp konap arop ntia kwatae nɨnɨkráp aropént tankrá fánámpon?” ");
INSERT INTO yuj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aerapo maok, Jisas wawia mao am fárákapan sérrá, “Touwe fwapnap arop te doktanámpok tukup mo i konapon. Touwenap aropao saráp doktanámpok tukup konapono. Taknámp ono ék namp te, námo yae-párák kare nɨnɨkrápao namprá nɨnɨknap aropan te mono. Arop námo kwatae nɨnɨkrápao namprá nɨnɨknap aropan wumwia érékép naeria ék nampono.” ");
INSERT INTO yuj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ankwap ke fek Jono éréképá yárak i konámp arop, tá Farisi fákárerao kor Kwarén kar toropwap mwaria fɨr wuri napo maok, ankwap fárákap koropea Jisasén arakrá turunk, “Jono éréképá yárak i konámp arop fákáre ntia Farisi fákárerao kor Kwarén kar toropwap mwaria te fɨr wuri konapono. Aeno amo éréképá yárak i konap arop fákárerao fɨr wuri mo i konap te apaeritea napon?” ");
INSERT INTO yuj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aerapo maok, Jisaso am fárákapan wounáp kar sérrá, “Arop ankárankamp yupu sámp naerianámp oukoumwan yak námp fek te, maomp nouroup fwap fɨr wuri konap nie? Mono! Am arop yupu sámp naerianámp oukoumwan am nouroup aropént yak námp fek te fɨr wuri mo i konapono. ");
INSERT INTO yuj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aeno nánkár wakmwaek am yupu sámp naerianámp aropan sámpá tukup tenapo maok, maomp nouroup arop yonkwae touweria fɨr wuri mwanapono. ");
INSERT INTO yuj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Arop te wourékam waempyam fákáre sámpeaka waempyam épi me fek paprá aomp mo i konámpon. Táte mao tak nánko te, am waempyam wourékam támao épi waempyaman nɨkɨr nánko, warko pearákár tokwae naerámpon. ");
INSERT INTO yuj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Arop te meme yɨpi fekamp botol épi mek te wain wourékam kér mo i konapono. Aeno am mek kérapo te, wainao am meme yɨpi fekamp botol am te fápárákápi papria wain ént kwarákár naeria námpon. Aeria am wain ntia meme yɨpi fekamp botol épi te énénkér kwatae akwap neria nepon. Aeno arop te ankár wain wourékam te meme yɨpi wourékam fekamp botol mek kér i konapono.” ");
INSERT INTO yuj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ankwap Sabat fek Jisas ntiaka mént paokop i konap arop wit yoroi tenap yopwaraok tukup. Tukupea maok, Jisasomp fákáre am wit ankwapmwaek fár mwanámpria kánánkápapo maok, ");
INSERT INTO yuj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","tá Farisi fákárerao Jisasén sérrá, “Wae! Am te Sabat yae fek kákánk i konap te apaerá tére napono?” ");
INSERT INTO yuj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Aerapo maok, Jisas am fárákapan sérrá, “Ae te yumo wokwaek Devitoimp kar buk fek yak námp te nke mori kwapono? Ono sénamp te am ke fek Devit ntia maomp arop fárákap ankank mo nánko yae-porokwe napono. ");
INSERT INTO yuj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar pris taokeyak konámp arop yaknámp ke fek, Devito Kwaromp Nap mek youmpea, pan Kwaro éntér sɨnámp mwaek am fek páte nap fária maok, náráp mént koropnap aropan kor ankwapmwaek nénkámpon. Am pan te fouara, pris fákáreao saráp fépér i konapan nimpon.” ");
INSERT INTO yuj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisaso am fárákapan ankwap kar sérrá, “Kwar te, Sabat yaeran yaewour naenámpria arop yoro mono. Sabat yae te arop anepér mwanap yaewour naenámpria pap námpon. ");
INSERT INTO yuj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aenámpara, Aropamp Táráp te mao námoku Sabat yaeran kor poukwap námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisaso warko lotu nap mek yoump nánko maok, arop ankárank yae yonkwae yak námp am mek yak. ");
INSERT INTO yuj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aenánko maok, am Farisi fárákap támao Jisasén, mao te Mosesomp lo ták-pwararea Sabat yae fek am arop fwapi pap te mokopean nkea man kot mwaria yépékrá yakáp. ");
INSERT INTO yuj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aeapo maok, mao am yae ankwapmwaek yonkwae yaknámp aropan sérrá, “Amo koropae!” Aenánko am arop te koropea kuk fokopeyak. ");
INSERT INTO yuj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aenko maok, mao am fákáreran sér, “Lo te nomo tére mo i konámp sabat yae fek ‘Apaenk’rá sénámpon? Ae te nomo arop ankwapan yaewour mwanámp ni, ankwapan kwatae pap mwanámp nie? Ae te nomo te arop yaewour nánko yiki yak naenámp ni, porokwapá pap mwanámp nie?” Aerá sénánko maok, am fárákapao kor kar sér mo. ");
INSERT INTO yuj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aeapo maok, Jisaso fokopeyakrá énounkouprá yakea am fárákap te aropan yonkwae touwe mono, loan saráp nɨnɨk kárákáre napo, am táman nkea yopor yonkwae pwarámpao maok, yonkwae touwe méntér. Aeria maok, Jisaso am yae yonkwaenámp aropan sérrá, “Waráp yae kor ékékérae.” Aeránko maok, mao yae ékékéránko maok, maomp yae warko fwap. ");
INSERT INTO yuj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aenánko maok, táte Farisi fákáre koupour ferámprá lotu nap pwarará tukupea Herotomp arop fákárerént tapokwapea Jisasén farop mwanámpria kar sérar. ");
INSERT INTO yuj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas námoku éréképá yárak i konámp aropént am taun pwarará ént aokore Galili fik tukupapo maok, koumteouráp aropao kor méntér tukup. ");
INSERT INTO yuj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Am arop fi te distrik Galili mekamp, tá distrik Judia mekamp, tá taun Jerusalem mekamp, distrik Idumea mekamp, ént Jordan nkwamwaek fi mwaekamp, tá taun Tair ntiaka Saidon mek mwaekamp arop fi kápae kare támao Jisaso térenámp kar wawia maok, maonámpok korop. ");
INSERT INTO yuj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Aeapo maok, Jisaso námoku éréképá yárak i konámp aropan sérrá, “Arop kápae kare koropea onan ɨkɨr mwanape. Ae mwarea napara, yumo onompor bot sankoropea wonae fik nánapi fákeyakáp napo, ono am mek korokwap nanampono.” ");
INSERT INTO yuj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Am te wokwaek kápae kare koumteouráp aropan touwe fwapokwaprá kák tenámpantá maok, kápae kare arop fi námwan fwapi papanoria maomp pourouk yae pap mwaria koropea maomp wonae fik koupoukour. ");
INSERT INTO yuj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aenapo maok, am arop pourouk woukouri yakápnámp kwatae-arop fárákap man nkeria te, kwaráp torokomprá tékén wumwi kar fek ‘Amo te Kwaromp Táráp’rá sér i konapono. ");
INSERT INTO yuj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aenapo, mao am fárákapan ‘Námo te wanonorá séri kwapono’ ria tae fek sér. ");
INSERT INTO yuj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisaso am arop ou pwarará námoku mwar faonkwek pokea maok, arop ankwap fárákap maonámpok korop mwanap sénaeria, ponankor wumwi nánko, korop. ");
INSERT INTO yuj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Am arop ou mekamp éntér-sámpramp arop nánkárápea ‘Aposel’rá sérianánko, am fárákap méntér yakáp napo, mao te am fárákapan Kwaromp kar farákápenkria tirá kérép, ");
INSERT INTO yuj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","tá Kwatae-arop tirá kérép mwanap kárákáre nénk nanampria námpon. ");
INSERT INTO yuj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Am éntér-sámpramp aropamp e te ará: Saimonén ankwap e ‘Pita’rá sér. ");
INSERT INTO yuj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tá Sebedimp táráp Jems ntia maomp nánae Jonén man kor ankwap e ‘Boanerges’ ri pap. Am e fi te ‘Oukurérao párákapnámp niamp arop’rá sénapono. ");
INSERT INTO yuj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Tá Andru ntia Filip, tá Bartolomyu, tá Matyu, tá Tomas ntia Jems Alfiusomp táráp, tá Tadius, tá Saimon te Selot pati mekamp, ");
INSERT INTO yuj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","tá Judas Iskariot mao te nánkár Jisasénenkria outɨri naenámp aropono. ");
INSERT INTO yuj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisaso akwapea nap mekánko maok, tá kápae kare koumteouráp arop koropea warko koupoukourapo maok, táte Jisas ntia mao éréképá yáraknámp fárákap mao tankáprá fár mwanap ke te yak mo. ");
INSERT INTO yuj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aenko maok, táte námokuráp kar nánaeounáp Jisas takrá tére námp wawia maok, mao te épépérépri kanrá warámp mwaria korop. ");
INSERT INTO yuj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lo mérnap arop Jerusalem meknámp korop. Koropea maok, arakrá sér, “Belsebul Jisasént yak námpon.” Tá “Mao te kwatae-arop poukwap konámp Belsebulomp kárákáre fek am kwatae-arop fákáre yéréperá kérép námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisaso am fákáreran wonae fik koropenkria maok, mao am fárákapan wounáp kar arakrá sér, “Satan te mokopia Satan yéréperá kérép naenámpon? ");
INSERT INTO yuj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Arop ankárankamp firao kuk pɨrékarea nonopok yorowar nep te, am arop fi fwapi kárákáre yak naenámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tá ankárankamp nap mekamp aropao yorowaria te, am nap mekamp arop te fwapi tankáp mono. ");
INSERT INTO yuj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tá Satan poukeyak námp mekamp ankwap-ankwap fákáre nonopok yorowaria te, am fi pɨpɨrɨkɨr tukup napo te, mao kor kárákáre yak mono, pwar naerámpon. ");
INSERT INTO yuj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Arop ankárankao kárákáre kor aropamp nap mek ankank pouroukoup naeria te, kwaporok yoump mo i konámp nie? Mao te am taenámp aropanénkɨr sámpea yarokwapea pátea maok, am aropamp nap mekamp ankank ponankor ti konámpono. ");
INSERT INTO yuj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ono te yumwan waeman kare sér rae: Kwar te koumteouráp aropamp ponankor kwatae nɨnɨk ntia ponankor wouroump kar sér i konap te fwap tirá épér naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Aeno aropao Yiki Kor Spiritan wouroump sénámp te, Kwar te maomp am wouroump sérinámp kwatae nɨnɨk te sámp-sɨr mono. Oukoumwan, tá nánkár wakmwaek kor am nɨnɨk kwatae te ankár taki yaká yak naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Am fárákapao ‘Kwatae-arop man noumpoukoupeyak námp’rá sénapantá, Jisaso makrá sénámpono.) ");
INSERT INTO yuj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Am ke fek táman, Jisasomp éntupwar ntia nánaeounáp Jisasnámpok korop. Koropea ek yakáprá ‘Mao mankano’rá sér. ");
INSERT INTO yuj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aeapo maok, koumteouráp arop kápae kare man ko-sɨtea tankáprá maok, man arakrá sér, “Amo wawae! Waráp éntupwar ntia waráp nánaeounáp ek yakáprá amwan wumwi nape.” ");
INSERT INTO yuj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aenapo maok, mao am kar pwarokwaprá arakrá sér, “Wa onomp éntupwar ntia onomp nánaenono?” ");
INSERT INTO yuj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aeria maok, koumteouráp arop tankáp nap táman yénkrá sérrá maok, “Nkenke! Onomp éntupwar ntiaka onomp nánaeou tárápu te mámánono. ");
INSERT INTO yuj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Apae koumteouráp aropao Kwaromp nɨnɨkaok yárak námp te, mao támao maok onomp nánae, tá onomp antáp, tá onomp éntupwarono.” ");
INSERT INTO yuj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisaso warko ént aokore Galili fik akwapea koumteouráp aropan Kwaromp kar yénkrá farákáp. Aeria maok, koumteouráp arop kápae kare koropea koupoukour napantá maok, mao ént mek tanknámp bot mek pokea tank. Aenánko, ponankor koumteouráp arop am ént fik táman néntép. ");
INSERT INTO yuj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Aeria maok, mao am fárákapan kápae kare wounáp kar farákápria am fárákapan arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ono kar sénae. Yumo wawenke. Arop ankárankao akwapeaka yopwaraok ankankou yɨrɨr. ");
INSERT INTO yuj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Am te épér nánko maok, ou ankwapmwaek pɨkia mwaeaok tankáp. Aenámp te, antao koropea fépér. ");
INSERT INTO yuj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tá ankwapmwaek yumwi tokwae ankore mek yak nánko, kwar worare fek yumuntuk yak námp mek pɨká tank. Aenámp te, am te wae koupour páre kwapwe námpao maok, ");
INSERT INTO yuj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","arák yumwi fek tɨkɨpeyak nánko, yámar yokwapria, am ankankou páre yonkwae pap nánko, yákáre námpono. ");
INSERT INTO yuj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tá ankankou ankwapmwaek paok wi ou mek pɨká tank nánko maok, am paok wi páre támao am páreran woukoupea pap. Aenánko maok, yao ki tank mo. ");
INSERT INTO yuj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aeno ankankou ankwapmwaek kwar émi kwapwe kare mek pɨk námp te, kwapwe kare párea tokwaeria maok, wae ki tankria maok, ankwap aopwe 30 tank, táte ankwap aopwe 60 tank, tá ankwap aopwe 100 tank.” ");
INSERT INTO yuj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Makrá séri pwarará, Jisaso am fárákapan sérrá, “Arop woupwiráp te má kar má fwapia wa kuno.” ");
INSERT INTO yuj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wakmwaek Jisas námoku nápar yak. Aenko maok, am arop éntér-sámpramp, tá ankwap fárákap Jisasént yakáp napao kor man wounáp kar táman turunk. ");
INSERT INTO yuj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tá mao am fárákapan sérrá, “Kwar te maomp fákáreran taokeyaknámpamp mek-wouroumpeyaknámp kar fi kor yumwan wae yénkép námpono. Aeno am arop kwaporok yakáp nap te, wounáp karan saráp wawi konapono. ");
INSERT INTO yuj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Aenapara, ‘Am te wae énounkoupapan maok, am ankank te ankwap wuri nke mo, tá kar te wa napan maok, am fi te fwapia mér mono. Aenapara, am fárákapao Kwaronámpok tukup napo, Mao am fárákapamp kwatae nɨnɨk tirá épérantáno.’” ");
INSERT INTO yuj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tá Jisaso am fárákapan sérrá, “Yumo mámá wounáp kar te mér mo nap nie? Ae te yumo ponankor ankwap wounáp kar mokopia mér mwanapon? ");
INSERT INTO yuj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Am arop ankankou yoro námp te Kwaromp karan yoro námpon. ");
INSERT INTO yuj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tá kar mwaeaok pɨká párákap námp te, koumteouráp aropao kar wa napan maok, am ke fek táman Satan koroprá am Kwaromp kar am fárákapamp nɨnɨk mek yak námp ti-akwap konámpan sénámpon. ");
INSERT INTO yuj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tá koumteouráp arop ankwap fárákap am te ankankou apár yumwi kor tárankápnámp mek pɨk námp niamp námp te, am fárákapao kar wawia koupour sámpria maok, am táman warákár. ");
INSERT INTO yuj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Aenapao maok, am fárákapao Kwaromp kar te nɨnɨk mek sámpá yak mo. Aenapo, arák mek pɨk monámp taknámp, wakmwaek arop ankwap fárákapao Kwaromp kar sámpá anámprá paprá, am koumteouráp aropan nkwakwe make kar sénapo, am fárákapao koupour Kwaromp kar pwar napon. ");
INSERT INTO yuj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tá koumteouráp arop ankwap fárákap te ankankou paok wi mek kuk pɨká tank námp niamp taknámp, am fárákap te kar wa napao maok, ");
INSERT INTO yuj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tá apárokamp ankankan nɨnɨk kápae kare, mani tokwaeantá nɨnɨkrá paokopria maok, tá nkwakwe make ankankantá kɨkiankrá paokoprá, mak napo maok, am ankankao Kwaromp kar oupouri pap. Taknámp arop te maomp nɨnɨk mek te ki tank mono. ");
INSERT INTO yuj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aeno ankankou ankwapmwaek kwar émi kwapwe mek pɨká tankria páreanámp te, ki tankria ankwap 30 tank, ankwap 60 tank, ankwap 100 tank. Aenámp te, koumteouráp arop ankwap fárákap kar wawia sámpea nɨki paokop napan sénámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisaso ankwap kar am fárákapan sérrá, “Ae te arop lam sámpea korop námp te, baket mek pap konámp nie? Tá kákánar ankore mek pap konámp nie? Mono. Mao te narek kákánar fek pap konámpono. ");
INSERT INTO yuj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ponankor ankank mek wouroumpeyak námp, tá oupouroupá pwate nap te, nánkár wakmwaek érik korop naeria námpon. ");
INSERT INTO yuj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Arop woupwiráp te mámá kar mámá wa kipo.” ");
INSERT INTO yuj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mao am fárákapan warko ankwap kar arakrá sér, “Kar yumo wa nap te fwapiaka nɨnɨk kour kipo. Yumo arop ankwapan mokope puri fek nénk nap te, Kwaro yumwan take pourouráp sánkria kánámpár ankwap yumuntuk kák naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Táte arop Kwaromp kar kárákáre fek nɨki-samp nánko, Kwaro man warko nɨnɨk kwapwe méntér tapokwap naenámpon. Aeno arop am kar sámp-fákeyak mo nánko te, maomp mér kánanke te Kwaro maomp yaekamp pwarokwap naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisaso warko sérrá, “Kwaro náráp firan taokeyak konámp te arop ankárank ankankou kwar mek épéri pwatea, ");
INSERT INTO yuj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","kumur méntép am arop kumuruk amp i ko, wae fek fárámprá, námokuráp térerá yárak. Aenámpao maok, am ankankou te mokopia párea akwapea tokwae kar naenámpaoeanrá mér mono. ");
INSERT INTO yuj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kwar támao arákan wouri sánk nánko, párea téképea, wakmwaek ki tank konámpon. Manénkɨr te páre pokea, pwae fukarea, tá wakmwaek aopwe tokwaeria me ku mek ki tanka wae konámpon. ");
INSERT INTO yuj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tá am ki yápae nánko, fékér mwanap ke korop nánko. am arop akwapea fékér i konámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisaso warko arakrá sér, “Nomo Kwaro náráp firáp taokeyak námp te apae niamprá sér mwanámpon? Nomo mokope pourouráp wounáp kar sér mwanámpon? ");
INSERT INTO yuj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kwaro náráp firáp taokeyak námp te mastet ki kánanke niampon. Am te ankwap yao ki niamp mono. Kánanke kare námpono. Aropao am mastet ki kwar mek yoro i konapon. ");
INSERT INTO yuj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Arop fárákapao yɨmp tenapo, pérea pokea tokwae karria te, yopwar mekamp ankankan kámákár akwapria yowe tokwaeri akwapránk. Aenánko, ant fákáre fwap am yao yowe néntékép mek koropá taok naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisaso koumteouráp aropan kápae kare wounáp kar farákáp námp te, am arop fákáreramp nɨnɨk mwanap puri fek farákáp námpon. ");
INSERT INTO yuj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Am kar koumteouráp aropan farákápámp te érik farákáp mono. Wounáp karan saráp farákáp námpon. Aeria maok, námoku éréképá yárak i konámp arop fárákapao mwar yakáp nap fek saráp am kar fi kor érik farákáp konámpono. ");
INSERT INTO yuj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Takia pwarará am makár táman kumur mek, Jisas mao éréképá yárak i konámp arop fárákapan arakrá sér, “Nomo te ént aokore fik nkwamwaek fimwaek yink mwaro.” ");
INSERT INTO yuj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aerá séria pwarará maok, koumteouráp arop kápae kare am fek yakáp napo pwarará, Jisaso éréképá yárak i konámp arop fárákap Jisas am mek tank námp am bot mek kunkuria man warámpea tukup. Aenapo maok, tá ankwap fárákap bot tiaka wakmwaek tukup. ");
INSERT INTO yuj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Aenapo maok, Jisas bot mek weaok mwaek tankria maok, pilo fek me tankoritea amp. Aenánko maok, ouwi tokwae koropria ént bot mek kupur naeria wae. Aenánko maok, am fákárerao man sérrá, “Tisa, nomo te wae ént mek pɨk mwanámp niamp námp te, amo yonkwae touwe mo rape?” ");
INSERT INTO yuj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aerapo maok, Jisas fárámprá ouwi ntia éntan yopor, “Wae támaono, pwarae!” Aeránko maok, ouwi wae pwaránko, ént wae fwap porokwe fek yak. ");
INSERT INTO yuj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aenánko maok, wokwae námoku éréképá yárak i konámp fákáreran sérrá, “Yumo te apaeritea apáp napon? Apaeritea onan mér mo napon?” ");
INSERT INTO yuj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aeránko korokoprá paokopria maok, námoku támao sérarrá, “Mámá arop máte wa nánko, ouwi ntia éntan sénánko, maomp kar wa námpon?” ");
INSERT INTO yuj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Am fárákapao ént aokore Galili nkwamwaek fimwaek Gerasa firamp apár mek tukup. ");
INSERT INTO yuj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tukupria maok, am bot pwarará tukup napo maok, arop ankárank kwatae-arop maomp pourouk woukoupeyaknámp arop koropea maok, Jisasén kɨkɨp. Am arop te arop kák konap fek mwaek yárakia korop. ");
INSERT INTO yuj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Am arop te man paok fek yarokwapá pap napo kor, fápárákápi sɨr akwap konámpon. Kápae kare por pu ntiaka yaek sen fek fákap ko pap napo maok, mao te kárákáre korara, pu fákapnámp am sen ntiaka yae-souwe fápárákápi sɨr konámpono. Ae konámpara, arop man sérémékér mwanap pourou mo napo, arop kák konap péri me fek mwaek amprá yárak i konámpono. ");
INSERT INTO yuj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wae fek, tá kumuruk kor ankár arop kák konap fek, tá you tokwae mek saráp apánkrá yárakrá yumwi fek námokuráp pourouk pɨpirá yárak i konámpon. ");
INSERT INTO yuj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ae konámpao nke nánko, Jisas oukoumwan panek korop nánko, mao fárakoprá koropea Jisasomp wonae fik kwaráp torokomp. ");
INSERT INTO yuj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jisaso am kwatae-aropan sérrá, “Amo mámá aropamp pourouk woukoupeyak nap worokor pɨkae!” Aeránko maok, am kwatae-aropao apápria tékén fépéna waeria maok, “Jisas, Kárákáre Tokwaeráp Kwaromp Táráp e! Amo te onan apae naeria nape? Ono amwan Kwaromp e fek kare kar sér rae: Amo onan kwatae pap kwapono.” ");
INSERT INTO yuj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aenánko maok, Jisaso man turunkrá, “Ae te waráp e te apaeno?” Makránko maok, mao man sérrá, “Yino te kápae kare ara, onomp e te ‘Ami’ no.” ");
INSERT INTO yuj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aea maok, apáp tɨrɨnkria Jisaso námwan aropomp naenámp kar fek sérrá, “Amo te yinan mámá apár má pwarará tukupenkria yérépe kwapono.” ");
INSERT INTO yuj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Am ke fek kou kápae kare am faonkwe fi mekmwaek táman yakáprá am fek apwar pwae fépérrá yakáp. ");
INSERT INTO yuj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aeapo maok, am kwatae-arop fákáre támao Jisasén kar tae fek sérrá, “Ae te amo yinan tirá kérép napo, tukupea kou fákáreamp pourouk woukouri yakáp mwaro.” ");
INSERT INTO yuj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Aerapo maok, Jisaso am kwatae-arop fákáre táman ‘Takenk’rá sénánko maok, am kwatae-arop fákáre támao kor am arop pwatará tukupea, kouamp pourouk woukour. Aenapo maok, am kou fákárerao kor mánmánria foporakorrá tukupea, yɨnkri furuk mek am mek pɨk napo maok, am kou te 2,000ao am ént aokore mek am mek ponankor pɨkiaka ént fépéria nékér popwarámpia, ponankor surumpwi pwar. ");
INSERT INTO yuj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aeapo maok, kou wun i konap arop te nkea pɨrɨkɨmpá tukupea maok, taun mek, tá taun wonae fikamp aropan am kar farákápapo maok, koumteouráp arop am ankank nke mwaria korop. ");
INSERT INTO yuj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Am fárákapao Jisasnámpok koropea nke napo maok, am kwatae-arop woukoupeyakámp arop te maomp nɨnɨk wae fwapria maok, oukoumwan waempyam kámpea tank. Aenko maok, koumteouráp arop te táman nkeaka apáp tɨrɨnk. ");
INSERT INTO yuj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Am arop fárákapao am arop pourouk kwatae-arop yakámp, oukoumwan fwap tank námp, táte kou fákáreaoi nap nkenap arop fárákap támao am koropnap arop fárákapan am kar farákáp. ");
INSERT INTO yuj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aeapo maok, koumteouráp aropao Jisasén tékén sérrá, “Amo mapek te yak kwapono! Amo ankár ankwap apárok akwapae!” ");
INSERT INTO yuj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aerapo maok, Jisas bot mek koropwap nánko maok, am kwatae-arop maomp pourouk woukoupeyakámp aropao kor kárákáre fek Jisasén sérrá, “Ono te ankár amont akwap nae kar nampono?” ");
INSERT INTO yuj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aeránko maok, Jisaso monoria man sérrá, “Amo te amokuráp némpouk akwapea waráp némpoukamp aropan Tokwae Karao amwan aropompria yaewourinámp kar farákápae.” ");
INSERT INTO yuj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aeránko maok, am aropao akwapea distrik Dekapolis mekamp némpouk mwaek námwan yaewourimp kar farákáp nánko maok, tá am koumteouráp arop ponankor wawia maok, nɨnɨk tokwae. ");
INSERT INTO yuj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas bot meknámp warko ént aokore tápampea nkwamwaek fimwaek akwap nánko maok, táte kápae kare koumteouráp arop koropea Jisasomp wonae fik ént aokore fik am fek néntépapo maok, ");
INSERT INTO yuj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","lotu nap taokeyak konámp arop Jairuso Jisasén nkea maok, koropea maomp wonae fik pumpuri yak námp fek kwaráp torokomp. ");
INSERT INTO yuj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kwaráp torokomprá me kor woukoupria, námwan aropompae karria arakrá sér, “Onomp yupu-táráp sumpwi naeane. Amo koropea maomp pourouk yae pap napo, touwe fwap nánko, yiki yak naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aeránko maok, Jisaso kor mént akwap. Aenko maok, táte kápae kare koumteouráp arop maomp wakmwaek tukupea maok, man kuk sɨr. ");
INSERT INTO yuj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aeapo maok, yupu ankárankao e furuk pɨkia taki yaknámp mwar akwapea éntér-sámpramp yopwar. ");
INSERT INTO yuj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Am yupu te dokta fákáreraonapok akwap saráp yakria, mani ponankor nénk saráp yak námpao maok, maomp touwe te pwar mono, warko ankár porok taki yak. ");
INSERT INTO yuj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Am yupu te Jisas térenámp kar wawia námp kwamp maok, koropea am koumteouráp arop tukupnap ou mekia Jisasomp wakmwaek korop. Mao nɨnɨkrá, “Ono maomp waempyam fek saráp yae sámpria te warko fwap nanampon.” Aeriaka Jisasomp waempyam fek yae sámp. ");
INSERT INTO yuj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aenko maok, e furuk pɨkia taki yaknámp wae koupour kar fárákár nánko maok, námoku wae fwap námp mér. ");
INSERT INTO yuj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aenko maok, Jisaso náráp kárákáre ankwapmwaek worokor pɨk námp méria maok, arákarrá arakrá sér, “Wa onomp waempyam fek yae sámp námpono?” ");
INSERT INTO yuj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aenko maok, námoku éréképá yárak i konámp arop fárákapao man sérrá, “Ae! Amo nkeae! Koumteouráp arop kápae kare mámá amwan kuk-sɨrarrá néntép nap máte, warko apaerá amo, onomp waempyam fek te wa toupoukouranrá turunk rape?” ");
INSERT INTO yuj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Aerá sérapo maok, Jisaso kor, wa onan toupoukareanria am mek oupourounk. ");
INSERT INTO yuj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aenko maok, am yupurao kor maomp pourouk koropnámp ankank te wae méria maok, apáprá kour me woukoupria maok, koropea Jisasomp wonae fik kwaráp torokompria maok, am ankank ponankor man érik farákáp. ");
INSERT INTO yuj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aenko maok, Jisaso man sérrá, “Táráp e! Amoku mér napara, am fek waráp touwe wae fwap námpono. Amo yonkwae kakére fek akwapae. Waráp touwe te wae pwar námpono.” ");
INSERT INTO yuj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisaso makrá sérrá yakánko maok, arop ankwap fárákap lotu nap taokeyak konámp aropamp nap meknámp koropea maok, naropwarén sérrá, “Waráp táráp te waeman sumpwi yak námp te. Apaerá warko tisan tére tokwae sánk nae rape?” ");
INSERT INTO yuj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aerapo maok, Jisaso kor am fárákapao sérap kar am te wampwe pwarará lotu nap taokeyaknámp aropan sérrá, “Amo te apápi kwapono. Ankár mérampo.” ");
INSERT INTO yuj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aerá sériaka pwarará maok, am mént yakápnap fárákapan ‘Mampok korop kwapono’ ria séria pwarará maok, tá Pita, Jems, Jon Jemsomp nánae makia am yinɨnkaopwe támao saráp mént énénki tukup. ");
INSERT INTO yuj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tukupeaka lotu nap taokeyak konámp aropamp nap ménki fekria Jisaso nke nánko maok, arop kápae kare koropá nouroumpria maok, éménkrá kar ounka wae. ");
INSERT INTO yuj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aenapo maok, mao am mek youmpea turunkrá, “Yumo te apaerá éménkrá kara wae rape? Mámá táráp máte sumpwi mono, párák amp námpono.” ");
INSERT INTO yuj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aeránko maok, am fákárerao, waeman sumpwi yak námp teria amomoránk. Tá mao am koumteouráp aropan tirá apárok kérépea pwarará maok, naropwar ntia éntupwarén saráp warámpea, tá námoku éréképá yárak i konámp arop yinɨnkaopwean saráp éréképea am fárákapao saráp táráp ampnámp aokore mek yink. ");
INSERT INTO yuj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","42","(Am tárápamp yopwar te éntér-sámpramp yopwarono.) Am fárákap yinkea maok, Jisaso man yae topwe fek sámpriaka am yupu-tárápan námokuráp kar fek sérrá, “Talita kum!” Am kar te arakrá sénámpon: “Yupu-táráp kánanke, ono amwan sér rae: Amo fárámpae!” Aeránko maok, am yupu-tárápao kor wae fárámpeaka yárak. Aenko maok, man nkea kokorokor. ");
INSERT INTO yuj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aeapo maok, Jisaso kar kárákáre fek sér, “Yumo te arop ankwapan mámá ankank korop námp kar te séri kwapono.” Aeria maok, tá am anánkwapan sérrá, “Yumo am yupu-tárápan fɨr sánkenke!” ");
INSERT INTO yuj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas am némp pwarará námokuráp taun mek akwap. Aenánko maok, mént paokop i konap arop te énénki tukup. ");
INSERT INTO yuj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tukupea maok, Sabat yae fek mao lotu nap mek Kwaromp kar koumteouráp aropan yénkrá farákápánko maok, táte am kápae kare koumteouráp aropao kor am kar wawia kokorokoria maok, arakrá sér, “Nomwan má arop te má ankank ponankor te maokamp sámp námpon? Man sánknap yonkwae kour máte tokwae kar námpon! Máte mokopia mwar pourouráp kárákáre yororo námpon? ");
INSERT INTO yuj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Má arop máte kamda tére konámp nomo wae mérámpon. Máte Mariamp táráp, tá maomp nánaeounáp te Joses, tá Judas, tá Saimon. Tá maomp antáponáp te nomont mapek yakáp napono.” Am fárákapao makrá séria maok, kokwarok napon. ");
INSERT INTO yuj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aerapo maok, Jisaso am fákáreran sérrá, “Profet te maomp e te kápae kare némpouk yak konámpono. Aeno námokuráp némpouk, tá námokuráp fi arop ou mek, tá námokuráp nap mek e yak mono.” ");
INSERT INTO yuj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tá am náráp taun mek te kárákáre yororo naenámp pourou mono. Tá ankákárank touwenap aropan saráp yae papria fwapokwaprá kák námpon. ");
INSERT INTO yuj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tá mao maomp taun mekamp koumteouráp arop man mér mo napantá nɨnɨk tokwae námpon. Aeria maok, am taun pwarará ankwap némpouk mwaek koumteouráp aropan Kwaromp kar farákáprá yárak. ");
INSERT INTO yuj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Takria maok, mao éréképea yáraknámp éntér-sámpramp arop fárákapan térenkria anánánkrá tirá kérép naeria, koropenkrá wumwi. Aea maok, am arop fákárean arop pourou mek woukournámp kwatae-arop yéréperá kérép mwanap kárákáre nénk. ");
INSERT INTO yuj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Aeria maok, am fárákapan sérrá, “Yumo tukupria te, mámá ankank mént sámpea tukup kwapono: Pan, tá yam, tá mani ti-tukup kwapono. Tá waempyam anánkaopwe ti-tukup kwapono. Ankárankan mwar sámpea maok, su mwar yirɨria, mear yaopwaeran saráp tia paokop kip.” ");
INSERT INTO yuj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aeritea maok, mao am fárákapan sérrá, “Yumo tukupeaka ankwap némpouk napo, aropao yumwan warákárria nap mek érékép nánko te, am nap ankárank mek saráp yakáprá tukupea, wae am némp pwarará tukup mwanap ke fek maok, am nap pwarará tukup kipo. ");
INSERT INTO yuj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Táte ankwap némpouk aropao yumwan éréképea pokea nap mek kák moia, yiráp kar wa mo napo te, yumo ankár am némp pwarará tukupria, yiráp pukamp woup am fek poporokompia pwar napo maok, am támao yénképrá, ‘Yumoku nap kwataeno.’” ");
INSERT INTO yuj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aerá séria pwar nánko, am fárákap tukupea maok, arakrá sér, “Yumo kwatae nɨnɨk nap te ankár younkwe mwaek pwar kipo!” ");
INSERT INTO yuj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Aerá séria maok, táte kwatae-arop yéréperá kérépria maok, touwenap aropamp pourouk wel kokorarrá fwapokwaprá kák. ");
INSERT INTO yuj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kápae kare apárok te Jisaso tére nánko, maomp e tokwae kari yak nánko, Heroto am kar wa. Aenánko maok, koumteouráp arop ankwap fárákapao arakrá sér, “Ént mek nér i konámp arop Jon te warko apár me meknámp fárámp námpon. Aenámpara, mao wae kárákáre yoro naenámp kárákáre tokwaerápono.” ");
INSERT INTO yuj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tá ankwap fárákapao sérrá, “Mono! Táte Elaijanono.” Tá ankwap fárákapao sérrá, “Mao te wokwaekamp profet niampono.” ");
INSERT INTO yuj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mak rapo maok, king Heroto am kar wawiaka maok, arakrá sér, “Am te ono wokwaek séranko, yápare kor karámp-fárákapap arop ént mek nér i konámp Jon támao oukoumwan warko fárámp námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Manénkɨr te Heroto maomp nánae Filipomp yupu Herodias sámpánko, Jono Herotén sérrá, “Amo amokuráp nánaeramp yupu sámp nap am te pwi yak mo námpono!” Aeránko maok, Heroto arop fárákap tirá kérép nánko, tukupea Jonén sámpea kalabus nap mek pap. ");
INSERT INTO yuj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Am yupu Herodias támao Jonén sámp-wouroump nae karámpao maok, mao tak naenámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Am te apaeria námpanápe, Heroto wae mér, Jon te kwapwe kareria Kwaro nke námp fek yae-párák kare aropara, Heroto Jonén apáp námpono. Aeria maok, Herot Jonén taokeyakria maok, maomp kar wawia maok, kápae kare nɨnɨk tokwae námpao maok, ‘Maomp kar wa nae kar’rá warákár konámpon. ");
INSERT INTO yuj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wakmwaek Herodiaso Jonén sámp-wouroump nanampria mwae oupourounk. Heroto námwan éntupwaro fárákapnámp yae nɨnɨkrá fɨr nánapria maok, maomp Gavman taokeyakáp konap arop, tá ami taokeyakáp konap arop, tá Galili mekamp arop éréképá tankáp konap arop, makia am fárákapan wumwi. ");
INSERT INTO yuj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aeanánko, mao tankáprá fépérapo maok, táte Herodiasomp yupu-táráp énki mankea kaerá wounk nánko maok, am fárákapao man warákárria maok, kingo am yupu-táráp énkiran arakrá sér, “Amo am kwapwe kare kae nap te am fek apae sámp naeria nap onan sénapo te, fwap sánk nanampono.” ");
INSERT INTO yuj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Aeria maok, Heroto man sérrá, “Ono te narekampráp amwan waeman kare kar sér rae: Amo te apae ankankan sámp naeria sénap te, ono amwan sánk nanampono. Amo onan, waráp apár fi taokeyak nap kuk fár-pwararea ankwapmwaek sápaeria nap kwamp te, onan sénapo sánk nanampon.” ");
INSERT INTO yuj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aeránko maok, am yupu-tárápao ek youmpea éntupwarén turunkrá, “Ono te apae ankank ‘Sápae’rá sénanampono?” Aeránko maok, éntupwaro sérrá, “Ae te amo sérrá, ‘Arop ént mek nér i konámp Jonomp me kor karámp fárákapea sápae’rá sérampo.” ");
INSERT INTO yuj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aeránko maok, am yupu-táráp énki warko tákarákarrá koupour koropea kingén sérrá, “Oukoumwan koupour kar amo arop ént mek nér i konámp Jonomp me kor plet mek papea sápae.” ");
INSERT INTO yuj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Aerá séránko maok, king te, mokop tak naeria yonkwae touwe námpao maok, warko am arop fákárerént fépérrá tankria fou e séri tenámp kwamp, am yupu-tárápamp kar ták-pwar moimpon. ");
INSERT INTO yuj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aeria maok, mao soldia ankwap sámp-kérépria sérrá, “Amo akwapea kalabus nap mek Jonomp yápare kor kar-fárákapea me kor sankoropae.” Mao akwapea Jonomp me kor karámp-fárákapea maok, ");
INSERT INTO yuj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","plet mek papea sankoropá am yupu-táráp énkiran sánkánko maok, tá mao sámprá éntupwarén sánk. ");
INSERT INTO yuj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aeapo maok, Jonomp éréképá yárak i konámp aropao am kar wawia maok, koropea Jonomp yákáre sámpá tukupea péri me mek papapono. ");
INSERT INTO yuj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisaso mént paokop i konap aropan tirá kérépánko, tukupap, wae paokopia arári koropea Jisasnámpok. Aeria maok, am térerá paokopiap kar, tá kar ponankor koumteouráp aropan farákápap man farákáprá sér. ");
INSERT INTO yuj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aeapo maok, kápae kare koumteouráp arop te Jisasnámpok tukupá koropá saráp yakápapo maok, mént paokop i konap fákáreao kor tankrá fɨr fár mwarap ke te yak mo. Aenapo maok, Jisaso am fárákapan sérrá, “Nomo te tukupea arop yak monap ke fek nomoku mwar anepérrá tankáp mwaro.” ");
INSERT INTO yuj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aea maok, bot sámpea arop yak monap apárok tukupea maok, am fárákapao saráp yakáp mwanámpan mpwe. ");
INSERT INTO yuj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tak mwaria napo maok, kápae kare koumteouráp arop Jisasomp fárákapan nkeaka wuri nke. Aeapara maok, kápae kare taun mek mwaekamp arop ponankor Jisas akwap naenámp mek apár mwaek manénkɨr mekia tukup. ");
INSERT INTO yuj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisaso youmpea ént woupwi mekria kápae kare am koumteouráp aropan nke nánko maok, am fárákap te sipsipao taokeyak naenámp mo nánko, námoku yakáp nap niamp napo, yonkwae touwe námpono. Aeria maok, am ke feknámpia mao kápae kare kar yénkrá farákáp. ");
INSERT INTO yuj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Aenánko, wakmwaek yámar pɨk naeria nánko maok, Jisaso éréképá yárak i konámp arop fárákapao koropea Jisasén sérrá, “Mámá apár te arop yakáp mo napo, yámar porokor naereane. Amo mámá koumteouráp arop tirá kérép napo tukupea maok, am apár mwaek paokopria am némpoukamp námoku fár mwanap fɨr tianápono.” ");
INSERT INTO yuj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aerapo maok, Jisaso am fárákapamp kar pwarokwaprá sér, “Yumoku man fɨr nénkenke.” Aeránko maok, am fákárerao sérrá, “Waráp nɨnɨk te yinan ‘200 kina santukupea am fek pan tia am fárákapan nénkenk’ ria nape?” ");
INSERT INTO yuj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aerapo maok, Jisaso sérrá, “Yiráp pan te apaekamp tankánrá tukupá nkenke.” Aeránko maok, nkeaka, “Yino te pan éntik, tá éntékam anánkaopwe mwar tank námpono.” ");
INSERT INTO yuj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aerapo maok, am fárákapan sérrá, “Yumo sénapo, koumteouráp arop apár pwae kwapwe fek mapek ankwap fárákap ankwap fek, ankwap fárákap ankwap fekrá tankápanápono.” ");
INSERT INTO yuj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aeránko maok, am fárákap apárok néntépria maok, ankwap fi tankápap 100 arop, ankwap fi tankápap 50 arop, takrá tankáprá tukupea pwar. ");
INSERT INTO yuj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Aeapo, Jisaso pan éntik sámpea maok, éntékam anánkaopwe sámpea sampeyakrá narek yámar mek tokoreyakrá ‘Aesio’rá séria maok, pan fékéria námoku éréképá yárak i konámp aropan koumteouráp aropan nénkanáponoria maomp yaek nénk. Tá éntékam anánkaopwean kor taknámp tokopea nénk. ");
INSERT INTO yuj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nénkea napo maok, fépéria wae pwi. ");
INSERT INTO yuj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aenánko maok, pan ntia éntékam ankwapmwaek tankánko tia éntér-sámpramp basket mek kák. ");
INSERT INTO yuj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Am pan fépériap te poumou mwar kouroump nap te 5,000. ");
INSERT INTO yuj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisaso námoku éréképá yárak i konámp arop fákárean sérrá, ‘Yumonkɨr ént aokore nkwamwaek fik koupour bot mekia Betsaida mek tukupenk’ ria manénkɨr tirá kérép. Námoku te koumteouráp arop tirá kérép naeria yak. ");
INSERT INTO yuj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Takia maok, am koumteouráp arop tirá kérépea pwatea maok, mao námoku faonkwek pokeaka Kwarén kar toropwap. ");
INSERT INTO yuj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kɨrɨkɨp naerianánko, bot ént aokore mek kuk yakánko maok, Jisas námoku nápar ént woupwi fik yak. ");
INSERT INTO yuj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Aeriaka nke nánko maok, bot me kor mwaekamp ouwi koropria bot panánkár nánko kárákáre fek ént pirékarrá tukup. Pirékarrá tukup napo, wae wakor worae nánko maok, Jisaso ént aokore yumunturi-aok akwapá párákaprá, am fárákapan kámá-pwarará akwap naeria. ");
INSERT INTO yuj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Aenámpan maok, mao éréképá yárak i konámp arop fákáre Jisas ént yumunturiaok korop námp nkea am fárákap te ént aropao námpwe. Aeria maok, am fárákapao apápria apánki tɨkia wae. ");
INSERT INTO yuj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ponankor man nkeaka apápa waeapo maok, Jisaso koupour am fárákapan arakrá sér, “Máte ono nae. Yumo kárákáre fek yakápenke. Apápi kwapono.” ");
INSERT INTO yuj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aeria maok, mao bot mek pokrá am fárákapént bot mek tank nánko maok, ouwi wae pwar. Aenánko maok, am fárákapao kokorokoria nɨnɨk tokwae. ");
INSERT INTO yuj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Am te apae riteanápe, Jisaso arop fákáreran pan nénkámp te, am fi kor fwapi mér mwanap pourou mo, oukoumwan épérépi yakáp napono. ");
INSERT INTO yuj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisas ntia am fákáre ént aokore tápampá tukupea nkwamwaek fimwaek Genesaret apár mek tukupeaka woupwi mek bot tokoropá pwar. ");
INSERT INTO yuj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Am fárákap bot wae pwarará tukup napo maok, táte arop fákárerao wae Jisasén koupour wuri nke. ");
INSERT INTO yuj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Aeria maok, am arop fákárerao am mwaekamp ponankor némpouk mwaek paokoprá am arop fákáreran ‘Jisas koropán’rá sérarapo maok, am arop fákáre wae wawia maok, touwenap arop tirá sunkwiar mek kákrá koupoumpea maok, maonámpok ti-tukup. ");
INSERT INTO yuj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tukupea maonámpokapo maok, tá némp-némp ponankor, taun mekamp arop ponankor Jisaso am mekmwaek yárak. Aenánko maok, touwenap arop ti-koroprá apárok kákria maok, Jisasén tae fek sérrá, “Amo yinan takenkria napo, touwenap aropao waráp waempyam fu fek saráp yae sámpea maok, am fárákapamp touwe warko fwap mwanapono.” Tá ponankor koumteouráp arop takria maomp pourou wae fwap napon. ");
INSERT INTO yuj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisi fákáre te lo yénkrá farákáp konap arop fárákapént tapokwapea Jerusalem meknámp Jisasén nke mwaria korop. ");
INSERT INTO yuj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Aeaka nkeapo maok, Jisaso éréképá yárak i konámp arop fákárerao Farisi fákáreramp loaok yárár konapnámp yae yárár moi yakáprá fépér. ");
INSERT INTO yuj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Am te Farisi ntiaka Juda fi ponankor te náráp wokwaekamp appeyaenápo i konap nɨnɨkaokria ént mek yae yárária saráp fári konapono. Moia nap te, fár mono. ");
INSERT INTO yuj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maket mek tukupea koropnap ke fek kor oukoumwan éntup moria te, fár mo i konapono. Náráp wokwaekamp appeyaenápo i konapaokria ankwap ankank, kap, sospen, tá dis, tá fári konap kákánaran kor yárár i konapono.) ");
INSERT INTO yuj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aeria maok, Farisi fákáre, tá lo yénkrá farákáp konap arop makia am fárákapao Jisasén turunkrá, “Apaeritea amo éréképá yárak i konap arop fákáre te nomp tékénouamp loaok tukup mo napon? Am fárákapamp yae yárár moriaka mént fánapo, Kwaro nke námp fek oum námp tane.” ");
INSERT INTO yuj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aerapo Jisaso am fárákapan sérrá, “Profet Aisaia kumwimp te, yumo kwekár mwanap arop, yumo mwanapan kare kar séri tenámpon. Mao Kwaro sénámp karan arakrá kumwi námpono: ‘Am fi arop te kar mwar onomp e sakap napono. Aeno maomp nɨnɨk te onan te mwar paneki yakáp napono. ");
INSERT INTO yuj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Am fi te aropamp lo kar táman farákáprá paokopria maok, “Máte Kwaromp karon?”rá sénapono. Aenapara maok, onan lotu nap te, kwaporok táman lotu napon.’” ");
INSERT INTO yuj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aerá séria maok, Jisaso am fek warko sérrá, “Yumo te Kwaromp lo wae pwararea aropamp nɨnɨkan saráp sámpea kárákáre napono.” ");
INSERT INTO yuj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aeria maok, am fárákapan sérrá, “Yumo te mér kare aropao námp rape? Yumo te Kwaromp lo kwe-pwarará yiráp tékénouamp loaok saráp tukup napon. ");
INSERT INTO yuj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moseso wokwaek sérrá, ‘Amo te ankár warko éntupwar naropwaromp yae ankore mek yakria, maomp karwaokampo. Aeno arop naropwarén wouroump, tá éntupwarén kor wouroump, maknámp te, mao ankár sumpwi naenámpono.’ ");
INSERT INTO yuj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Aerá sérimpan maok, nopok yumo arop ankwapan arakrá sér i konapono: ‘Amo éntupwar naropwarén sánk nanapan maok, am anánkwapan sérrá, “Mámá mani te Kwarén sánk nanamp”rá séria páte nap kwamp te, ");
INSERT INTO yuj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","éntupwar naropwarén yaewour nanap loan wampweno’rá sér i konapono. ");
INSERT INTO yuj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Takria maok, yumo te yiráp wokwaekamp tékénouamp loaokria, Kwaromp kar anámpá pap napon. Tá yumo ankwap nkwakwe make kápae kare nɨnɨkaok takrá paokop i konapono.” ");
INSERT INTO yuj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisaso koumteouráp aropan warko koropenkrá wumwiria am fárákapan arakrá sér, “Yumo ponankor onomp kar má wawia nɨnɨk kipo. ");
INSERT INTO yuj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ekamp fɨran sámpea fánap te, am támao te am aropan oumi pap mono. Aeno aropamp nɨnɨk meknámp ek korop námp, am támao maok am aropan oumi pap námpon. ");
INSERT INTO yuj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Arop woupwiráp te mámá kar má wa kipo!” ");
INSERT INTO yuj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas aerá séri pwarará am koumteouráp arop pwarará nap mek yoump. Námoku éréképá yárak i konámp arop fákárerao am wounáp kar fi am turunk. ");
INSERT INTO yuj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aeapo maok, mao am fárákapan arakrá sér, “Yumo kuri nɨnɨk yak mo nie? Kápae kare ankank ek yak námpao arop yare mek pɨk námp te, Kwaro nke námp fek am aropan oumi pap mo i konámp te, yumo am te mér mo nie? ");
INSERT INTO yuj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Am te apae riteanápe, am ankank te aropamp nɨnɨk mek pɨk mono. Am te yare mek pɨkianánko tukwi konapono.” (Am ankank Jisaso sénámp te fári konap ankank ponankor te Kwaro nke námp fek yiki kukur kwapwe námpan séri námpon.) ");
INSERT INTO yuj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aeritea maok, mao arakrá sér, “Aropamp nɨnɨk mek yak námpao ek korop námp te, am támao man oumi pap námpon. ");
INSERT INTO yuj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Am nɨnɨk mek yak námpao érik korop konámp ankank te ará: Kwatae mwaek nɨnɨk i konap nɨnɨk, kokopor i konap nɨnɨk, oukun i konap nɨnɨk, arop tirá wour i konap nɨnɨk, yupuráp aropao kokopor i konap nɨnɨk, ");
INSERT INTO yuj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kɨkiank i konap nɨnɨk, nkwakwe make kwatae nɨnɨk, yankar i konap nɨnɨk, yupu faperá kwekár i konap nɨnɨk, kokwarok i konap nɨnɨk, arop wouroumprá sér i konap, ‘Ono nkwak i mak i konamp’rá sér i konap nɨnɨk, fwapia nɨnɨk mo épépérép i konap nɨnɨk. ");
INSERT INTO yuj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mámá nɨnɨk kwatae má ponankor arop nɨnɨk mek yakea ek korop námp te, támao Kwaro nke námp fek am aropan oumi pap námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas apár Galili meknámp akwapea Tair taun ntia Saidon wonae fik maok, arop ankárankampamp nap mek youmpea maok, arop námwan nkeantánoria kánánkámp am mek tank naeria. Aenámpan mao mek tank naenámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ankwap fi kantri Siria mekamp Fonisia fi mekamp yupu ankárank Jisas koropá tank námp wa. Maomp yupu-táráp ankárank maomp pourouk kwatae-arop woukoupá yak nánko maok, koupour koropea Jisasomp wonae fik kwaráp torokompria Jisasén námwan aropomp naenámp kar fek sérrá, “Amo onomp tárápamp pouroukamp kwatae-arop yak námp yérépe napo worokor akwapano.” ");
INSERT INTO yuj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aeránko maok, Jisaso Juda firan nɨnɨkrá wounáp kar arakrá sérrá, “Nomo ankár manénkɨr te tárápuan fɨr nénk mwanámpon. Takria nomo tárápuamp fɨr sámpea asan nénk mwareano.” ");
INSERT INTO yuj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aeránko maok, yupurao man kar pwarokwaprá arakrá sér, “Tokwae Kar e! Tá karean maok, as kákánar ankore mek yakria tárápamp yaekamp fɨr kánanke párakop pɨkrɨnk nánko, tirá fári konámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aeránko maok, Jisaso man sérrá, “Ae te amo takrá sénapara, amo warko arákarrá akwapae. Waráp tárápamp pouroukamp kwatae-arop te wae worokor pɨk tenámpono.” ");
INSERT INTO yuj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aeránko maok, am yupu arákarrá akwapea námokuráp nap mek nke nánko maok, kwatae-arop worokor pɨk tenánko maok, yupu-tárápao népek kwapwe kare amp. ");
INSERT INTO yuj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas taun Tair mekmwaeknámp taun Saidon mekmwaeknámp akwapea maok, am feknámp Dekapolis mekmwaekia maok, warko ént aokore Galili mek akwap. ");
INSERT INTO yuj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jisas ént aokore Galili fik akwapeaka am fekánko maok, tá arop ankárank woupwi kérrá, tá sérékam kárákapeyak nánko, kar fwapia sér mo i konámp. Man warámp-sankoropnap aropao Jisasén námwan aropomp naenámp kar fek sérrá, “Amo am aropamp pourouk yae papae!” ");
INSERT INTO yuj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aerá sérapo maok, Jisaso am arop warámpea koumteouráp arop am fek párakop tará maok, námoku mwar arop warámpea akwap. Táte Jisaso am aropamp woupwi mek yae kurépi fek noropea maok, tá yae kurépi fek atop féki papea sérékam fek pap. ");
INSERT INTO yuj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aetea maok, táte yámar mek tokoreyakrá, yonkwae touweria maok, nékér ak-sɨrarrá námokuráp kar fek arakrá sér, “Efata!” Am takrá sénámp kar fi te ‘Amo kɨkɨr akwapae!’rá sénámpon. ");
INSERT INTO yuj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aenánko maok, am aropamp woupwi koupour kar kɨkɨr akwapea maok, sérékamao kuri kárákap yakámp te wae fwapánko maok, am aropao kor kar yae-párák kare sér. ");
INSERT INTO yuj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aenko maok, Jisaso am fárákapan, mámá aropan koropnámp ankank máte ankwapan séri kwaponoria taokarrá pwara námpan maok, am fárákap te maomp kar wa mono. Ankár kárákáreria am kar farákápapono. ");
INSERT INTO yuj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Aenapo, koumteouráp arop am kar wawia kokorokoria maok, arakrá sér, “Kápae kare ankank mao tére námp te ankár yae-párák námpono. Mao nánko, woupwi kérap arop oukoumwan te kar wa, tá top kor kéri yaknámp arop warko kar fwapnae sérar napono!” ");
INSERT INTO yuj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wakmwaek am ke fek táman kápae kare koumteouráp arop ou tokwae warko koropea koupoukour. Aeapo maok, fár mwarap fɨr wae pwar nánko, Jisaso námoku éréképá yárak i konámp aropan wumwi nánko maok, korop napo am fárákapan arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ono mámá arop fárákap onont yinɨnk yae yakápia napo, fɨr wae mo nánko, aropomp nampono. ");
INSERT INTO yuj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Táte mao yae-porokwe yakápia napo, ono warko námokuráp némpouk tirá kérép te mono. Am te apaeriaka ankwap fárákapao kor panek tukup mwanapara, tukupria mwaeaok poporokweria némpouk tankáp mwanape.” ");
INSERT INTO yuj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aeránko maok, mao éréképá yárak i konámp arop fákárerao nopok man arakrá sér, “Mapek arop mo námp te, pan te maokamp sámpea am koumteouráp aropan nénk nánko, pwi naenámpon?” ");
INSERT INTO yuj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aerapo Jisaso am fárákapan turunkrá, “Ae te yiráp pan te apaekamp tank námpono?” Aeránko maok, am fárákapao sérrá, “Fákánek tank námpono.” ");
INSERT INTO yuj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aerá sérapo maok, mao koumteouráp aropan sérrá, “Yumo apárok tankápenke.” Aeritea maok, mao am pan fákánek sámpea, Kwarén ‘Aesio’rá séria maok, fékériaka námoku éréképá yárak i konámp arop fákáreran nénk nánko, mao am tia koumteouráp aropan nénk. ");
INSERT INTO yuj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aetea maok, éntékam kánanke táráp ankákárank tankáp nánko, am táman kor Jisaso Kwarén ‘Aesio’rá séria maok, námoku éréképá yárak i konámp arop fákáre táman sérrá, “Máman kor taknámp nénkenke.” ");
INSERT INTO yuj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aeránko maok, am fákáreran fɨr nénkapo maok, fépéria wae pwiapo maok, fɨr ankwapmwaek tankáp nánko, Jisasomp arop fákáre am ponankor popokiaka fákánek basket mek kák napo, top koupour yak. ");
INSERT INTO yuj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Am koumteouráp arop te 4,000 niamp arakeno. Takia Jisaso am fárákapan tirá kérépá pwarará maok, ");
INSERT INTO yuj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","mao náráp éréképá yárak i konámp arop fárákapént koupour kar bot mek kounkouria maok, distrik Dalmanuta mek tukup. ");
INSERT INTO yuj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Aenapo maok, Farisi fákáre koropea Jisasént kar yorowarria maok, am fárákapao “Mao ankár Kwaromp térean tére námponoria yénképnámp kárákáre yoro nánko, nke mwaro.” Am fárákap takrá sénap te, man mokopon nke mwar ritea napono. ");
INSERT INTO yuj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tak napo maok, Jisaso am fárákapamp nɨnɨkan kokwaeria tékén nékér ak-sɨrarrá maok, sérrá, “Mámá ke fekamp koumteouráp arop te apaeria kárákáre nke mwarria wumwi napon? Ono te yumwan waeman kare kar sér rae: Ono am fárákapan te kárákáre yénkép mo kareno!” ");
INSERT INTO yuj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aerá séria maok, am fárákapan pwarará náráp arop fákárerént warko bot mek korokwaprá ént aokore nkwamwaek fimwaek tukup. ");
INSERT INTO yuj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisas éréképá yárak i konámp arop fárákap te pan sámp mwarap te nɨk mo pwarará, yaenémpi bot mek tankáp napo, pan ankárankamp mwar bot mek tank. ");
INSERT INTO yuj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aenapo maok, am fárákapan kar kárákáre fek arakrá sér, “Yumo fwapia mér kipo. Yumo te Farisi fákáre ntia Herotomp yis fwapia nɨnɨk kipo.” ");
INSERT INTO yuj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aeránko maok, am fárákap námoku támao “Am takrá sénámp te, apaeritea námpanápe, nomo pan mo námpantá námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aerapo maok, Jisas wae maomp nɨnɨk méria am fárákapan sérrá, “Apaeritea yumoku kok ‘Pan moian’rá sérar rape? Ae te yumo oukoumwan nɨnɨk mo rape? Ae te yiráp kae mek te fákárámp mo nie? ");
INSERT INTO yuj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yumo waeman yi-ráp te, mokopia ankank nke mo napon? Yumo waeman woupwiráp te, mokopia kar wa mo napon? Yumo onoi namp wae nɨk mo pwar nap nie? ");
INSERT INTO yuj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ae te ono arop ou 5,000 aropampor pan éntik fékéria nanko te, yumo te am pan ankwapmwaek tank námp te apaekamp basket mek kák napono?” Aeránko maok, am fárákapao sérrá, “Éntér-sámpramp basket mek kák námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Táte ono 4,000 arop ouampor pan fákánek fékéria nanko te, yumo am pan ankwapmwaek tank námp te, yumo apaekamp basket mek kák napono?” Aeránko maok, am fárákapao sérrá, “Fákánek basket mek kák námpono.” ");
INSERT INTO yuj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aerapo maok, mao am fárákapan sérrá, “Tak napara, ankank tank mo nánko te, ono fwap sánk nanamp te yumo mér mori kwapon?” ");
INSERT INTO yuj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jisas mao tukupea Betsaida mek napo, arop ankwap fákárerao yi wurumpi yaknámp arop warámp-sankoropea Jisasén námwan aropomp naenámp kar fek sérrá, “Amo mámá aropamp pourouk yae papae.” ");
INSERT INTO yuj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aerapo, Jisas am yi wurumpi yaknámp aropamp yaek sámpea némp yarápae fek warámpá akwapeaka, yae kurépi fek atop fékia maomp yi mek papria maok, man turunkrá, “Amo te ankank nke rape mo nie?” ");
INSERT INTO yuj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aeránko maok, am aropao énounkoupia maok sérrá, “Ono arop ankwap fárákap wae nke namp te, yao niamp paokop napono.” ");
INSERT INTO yuj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aeránko maok, Jisas warko maomp yi mek ankwap por yae pap. Aenko maok, am arop yi tae fek fɨrékarea nke nánko maok, táte kápae kare ankank wae érik karaok yakáp. ");
INSERT INTO yuj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Aenko maok, Jisas am aropan námokuráp nap mek sámp-kérépria sérrá, “Amo te warko némpouk mwaek akwapea am kar sérari kwapono.” ");
INSERT INTO yuj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas námoku éréképá yárak i konámp arop éréképea maok, taun Sisaria Filipai wonae fikamp némp-némp kánanke mek tukupea mwaeaokria maok, am fárákapan arakrá turunk, “Am koumteouráp arop te onan te waweanrá sénapono?” ");
INSERT INTO yuj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aeránko maok, am fákárerao man sérrá, “Ankwap fárákapao sérrá, ‘Máte arop ént mek nér i konámp Jon’rá sér i konapon. Tá ankwap fákárerao ‘Elaija’rá sér i konapon. Tá ankwap fákárerao sérrá, ‘Profet ankwapono’rá sér i konapono.” ");
INSERT INTO yuj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aerá sérapo maok, táte Jisaso man turunkrá, “Ae te yumoku kare te onan te wará sér i konapon?” Aeránko maok, Pita maomp kar pwarokwaprá arakrá sér, “Amo te Kraisono.” ");
INSERT INTO yuj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aeránko maok, mao sérrá, “Ae te arop ankwap wa nap fek yumo am kar takrá séri kwapono.” ");
INSERT INTO yuj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aeria maok, am fek arakrá sér, “Aropamp Táráp te ankár touwe tokwae sámp naenámpon. Tak naenámp te, Juda fi taokeyakáp i konap arop, tá pris fákáre, tá lo yénkrá farákáp konap arop am fákáre támao man younkwe sɨrarrá man sámp-wouroump mwanapon. Takia napo, yinɨnki yakea warko fárámp naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mao am kar érik am fárákapan farákápánko maok, tá Pita Jisasén warámpea youmpea ankwap fek yakrá man ‘Taki kwapono’rá yopor. ");
INSERT INTO yuj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Aeránko maok, Jisaso warko arákarrá námoku éréképá yárak i konámp fákáreran énounkoupia maok, tá Pitan arakrá yopor, “Satan, seae! Onan taokor kwapono. Amo te Kwaromp nɨnɨkaok mono, aropamp nɨnɨkaokria sénapono.” ");
INSERT INTO yuj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jisaso koumteouráp arop ntia námoku éréképá yárak i konámp aropan ‘Yumo koropenk’rá wumwia maok, am fárákapan sérrá, “Arop ankárankamp onomp wakmwaek korop naenámp kwamp te, mao námokuráp nɨnɨkan wampwe pwarareaka, mao te ono nampnámp maknámp touwe sámpea, onoinampaok korop kun. ");
INSERT INTO yuj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Arop námokuráp nɨnɨk fek yárak námp te, mao te sumpwi naeria námpon. Aeno arop onan nɨnɨkria, onomp Kwapwe Kare Kar ponankor sámpea farákáp námp te, arop am fek man sámp-wouroump nap te, mao fwap yiki yak sámp naenámpono. ");
INSERT INTO yuj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aeno arop ankárankao apárokamp ankankan nɨnɨk tokwaeria térerá yárakianámp te, sumpwi nánko te, am ankank ponankor támao man mokopiaka yaewour naenámpon? ");
INSERT INTO yuj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ae te am arop te apae arean fek yamokwapea warko yiki yak sámp naenámpon? ");
INSERT INTO yuj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aeno arop ankwap Kwarén younkwe sánkea kwatae nɨnɨk fek paokopnap arop ou mek yakria, ‘Ono Jisasomp’rá séria, onomp kar farákáp naenámp pwarápaeanámp te, tá nánkár wakmwaek kor, Aropamp Táráp maomp yiki kor enselént, tá Naropwaromp wae tokwae mént ék námp fek te, am aropan kor ‘Ono amwan mér moi namp’rá sénaenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisaso sérrá, “Ono yumwan waeman kare kar sér rae: Yumo mámá yakápnap arop ankwap fárákap te, oukoumwan sumpwi mo, yakápria, Kwaromp firáp taokeyak naenámp, maomp kárákárerént korop nánko, nke mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Takia tokwampok yae akwap tenánko, wakmwaek Jisaso Pita, Jems, Jon man éréképea, mao saráp pokea faonkwe wi fek narek karaok poká yakápria maok, Jisasomp pourou te am yinɨnkaopweao tokore yakápapo, ankwap pourou arákár. ");
INSERT INTO yuj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aeria maok, maomp waempyam ankank te wupwi pouri akwap nánko maok, apárokamp arop waempyam take pourouráp wupwi kukarrá pap mo i konapono. ");
INSERT INTO yuj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aenko maok, wokwaek kar yakep arop yawor Elaija ntiaka Moses kwaporok am fek Jisasént fokopeyakepo maok, am fárákapao nkeapo maok, am arop yaworao Jisasént kar sérrá yak. ");
INSERT INTO yuj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tá Pita am táman nkea maok, Jisasén arakrá sér, “Tisa, nomo te mapek yakáp mwanámp te kwapwe kareno. Aenámpara, yino mapek sákae yinɨnkaopwe tiria maok, ankwap waráp por, ankwap Mosesompor, ankwap Elaijampor.” ");
INSERT INTO yuj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Am fárákap apáp tɨrɨnkria maok, Pita am sénaenámp kar mér moria sérimpon. ");
INSERT INTO yuj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Aerá séránko maok, am fárákapamp pourouk koumwe oupouroupánko maok, am koumwe meknámp arop kar arakrá sér, “Támáte onomp tárápono. Ono man warákár nampono. Yumo ankár maomp kar wa kipo.” ");
INSERT INTO yuj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aeránko maok, koupour énounkoup napo maok, arop ankwap yak mo. Jisas ankárank mwar am fárákapént yakánko nke. ");
INSERT INTO yuj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Takia am faonkwek wae pwarará pɨkapo maok, am yinɨnkaopwe-ran toropwapria fou e sérrá, “Yumo nkenap ankank mámá te arop sérari kwapon. Nánkár Aropamp Táráp apár me meknámp warko fárámpeanánko, am kar wakmwaek fwap farákáp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aeránko maok, am fárákapao námoku am kar wawia nɨki-samp paokopria maok, “Mámá kar ‘Apár me meknámp warko fárámp’rá sénámp te apae ankankono?” ");
INSERT INTO yuj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aeria maok, man turunk, “Ae te apaeritea lo mér i konap aropao sérrá, ‘Elaijamékɨr warko korop nánko, Krais wakmwaek korop naenámpon’rá sénapon?” ");
INSERT INTO yuj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aerá sérapo maok, tá Jisaso am fárákapan arakrá sér, “Táte kare, Elaija manénkɨr koropeaka ankank ponankor fwapokwap naenámpon. Aeno ankwap kar Kwaromp Buk fek yaknámp arakrá sénámpon: ‘Aropamp Táráp mao touwe tokwae sámp, tá arop fárákap maomp kar ták-sɨr mwanap’rá sérimp te mokopono? ");
INSERT INTO yuj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aeno ono yumwan sénamp te Elaija wae korop námpon. Aenánko maok, aropao námokuráp nɨnɨkaok tukupriaka man nkwakwe make sokoro napono. Am te wae Kwaromp Buk fek sénámp niamp napon.” ");
INSERT INTO yuj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Am fárákapao ékiaka nkeapo maok, kápae kare koumteouráp arop néntépa waeapo maok, Jisaso éréképá yárak i konámp arop fárákap yakáp napo, lo yénkrá farákáp konap arop fárákap mént kar yorowar. ");
INSERT INTO yuj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Am koumteouráp arop ponankor nkeapo, Jisaso korop nánko maok, kokorokoria maonámpok foporakorrá tukupea, fwaprá kar korop naponoria warákarea warámp. ");
INSERT INTO yuj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Aerapo maok, mao námoku éréképá yárak i konámp arop fákáreran sérrá, “Yumo am fárákapént kar yorowar nap te apaerani napon?” ");
INSERT INTO yuj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aeránko maok, am koumteouráp arop ou mekamp arop ankárankao kar pwarokwaprá sérrá, “Tisa, onomp poumou-táráp ankárankan top kor kéri yaknámp kwatae-arop woukoupeyak námp amonapok warámp-sankorop nampono. ");
INSERT INTO yuj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ankár maomp pourouk woukoupeyakrá kárákáreria maok, man apárok sámp-yankop nánko, maomp táp meknámp aroponk koropánkria yu kákánákia maok, tá pourou tae pári yak konámpono. Aenámpantá, ono amo éréképá yárak i konap arop fárákapan turunkrá, ‘Yumo te onomp tárápamp pouroukamp kwatae-aropan yérépenk’ ria sénanko, am fárákap te yérépe mwanap pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisaso am kar wawia maok, ponankor koumteouráp aropan sérrá, “Yumo te Kwarén mér monap arop fino. Ono apaekampor yumont yak nanko, yumo onan wanonorá wuri nkea mér mwanapon? Yumwan apaekampor yiráp kápae sámprá yumwan yaewour saráp nanampon?” Aerá séri pwarará maok, naropwarén sérrá, “Waráp táráp mampok warámp-sankoropae.” ");
INSERT INTO yuj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aeránko maok, am fárákapao am táráp maonámpok warámp-sankorop napo maok, am kwatae-arop Jisasén nkea maok, am tárápan sámpá fopwaokánko, am táráp te kour me woukoupea maok, apárok sɨkɨrɨpea arokwapria maok, táp meknámp aroponk korop. ");
INSERT INTO yuj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aenko maok, Jisaso naropwarén turunkrá, “Mokope ke fek am yak námpon?” Makrá séránko maok, naropwaro sérrá, “Wokwaek ankár épér morok kánanke fekampao yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kápae kare por am kwatae-aropao am tárápan sumpwi pap nae yonkwaerá, maomp pourouk woukoupeyak nánko, mao yaomwi mek pɨk, tá ént mek pɨk konámpon. Aeno amo fwap tak nae rap kwamp te, yinan aropompria yaewourampo.” ");
INSERT INTO yuj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aeránko maok, Jisaso sérrá, “Amoku támao Kwarén méria te, amo fwap kápae kare ankank tére nanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aeránko maok, naropwaro sérrá, “Ono te wae amo tak nanaprá mér nampao maok, onomp mér fae tákárenono. Amo onan yaewourae.” ");
INSERT INTO yuj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisaso nke nánko, am koumteouráp arop wonae fik foporakorrá korop. Aenapo, mao am tárápamp pourouk woukoupeyaknámp kwatae-arop táman arakrá yopor, “Amo top kor kér, woupwi kériramp kwatae-arop e! Amo am tárápamp pourouk pwarará ankár worokor pɨkae! Warko maomp pourou mek akwap kwapono.” ");
INSERT INTO yuj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aeránko maok, am kwatae-arop apánka waeria maok, am tárápan sámpea fopwaokria maok, wae sumpwi yak námp niampi yak. Aenko maok, arop kápae kare nkea sérrá, “Mao te wae sumpwi yakáne!” ");
INSERT INTO yuj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Aerapo maok, Jisaso man yaek sámpea kakapánko maok, mao fárámpeyak. ");
INSERT INTO yuj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Takia maok, Jisaso nap mek youmpánko maok, námoku éréképá yárak i konámp arop námoku mwar mént yakápia man turunk, “Ae te apaeritea yino am kwatae-arop yérépe mwanámp pourou mo námpon?” ");
INSERT INTO yuj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aerapo maok, mao am fárákapan sérrá, “Kwarén sénap fek saráp, kwatae-arop yérépe mwanapon. Ankwap mwae kup yak mono.” ");
INSERT INTO yuj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jisas ntia mao éréképá yárak i konámp arop fárákap am némp pwarará tukupea distrik Galili mek amore mek, arop námo yak namp mérantánoria kánánkámp am mek yak. Am te apae riteanápe náráp éréképá yárak i konámp aropan saráp kar yénkrá farákáp naeria. Aeria maok, am fárákapan sérrá, “Nánkár Aropamp Tárápan arop fárákapamp yaek pap napo, faropea sumpwi páte napo, yinɨnki yakeaka warko fárámp naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aeránko maok, am fárákapao am kar fi fwapia mér moap kwamp, apápria man turunk mono. ");
INSERT INTO yuj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Takia pwarará, Jisas mao taun Kaperneam mek tukupria, mwaeaok mao éréképá yárak i konámp arop fárákap námo ou mek arop éréképá yak naenámp arop tokwae te wanonorá kánánkámp sérarrá turunkuprá tukup. Takrá tukupea Kaperneam mekria am fárákapao yinkea nap mek napo maok, Jisaso man turunkrá, “Yumo mwaeaok sérarinap kar te apaeran sérari napono?” Aeránko pwarápaeria maok, maomp kar pwarokwaprá sér mo. ");
INSERT INTO yuj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aeapo maok, tankria am éntér-sámpramp aropan koropenkria sérrá, “Arop ankwap yépe kor yoroia meki akwap naeria námp kwamp te, mao ankár wakmwaek kar yakria, ponankor aropan yaewour naenámp tére arop yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aeritea maok, Jisaso épér morok táráp kánanke warámpea kuk papria yae yukup mek yirɨp fákeyakrá am fárákapan sérrá, ");
INSERT INTO yuj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Arop onan nɨnɨkia mámake pourouráp táráp kánankeran warákárria warámp námp te, onan kor warákárria warámp námpon. Tá arop onan warákárria warámp námp te, mao te onan saráp mono. Onan sámp-kérép nánko ék namp, onomp Naropwarén kor warákárria warámp námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tá Jono Jisasén arakrá sér, “Tisa, yino nke nánko, arop ankárankao waráp e sériaka kwatae-arop yéréperá kérép námpao, mao te nomonámpaok yárak mo námpantá, yino man takrá tére kwaponorá taokor námpono.” ");
INSERT INTO yuj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aerá séránko maok, Jisaso man sérrá, “Yumo te man taokor kwapono. Arop ankárankao onomp e sériaka kárákáre yoroia te, mao te koupour onan kwatae kar sér mono. ");
INSERT INTO yuj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tá arop nomwan yopor mo námp te, nomp nouroupono. ");
INSERT INTO yuj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aeno arop ankárankao yumwan nkea, ono te Kraisomp arop fákáre yaewour naerá nɨnɨkia, yumwan kap mek ént yɨnk-sánk námp te, ono yumwan waeman kare kar sénampon: Mao nopok ankank kwapwe sámp naenámp te kwaporok pwar naenámp pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisaso warko arakrá sér, “Táte am arop épér morok táráp make niampao onan mér nánko, maomp nɨnɨk épérépi pap nánko, mao onan younkwek pwar námp te, am arop te manénkɨr yápare kor fek yumwi tokoropea solwara mek sɨtenapo, mao tak moan mpupo. ");
INSERT INTO yuj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Aeno waráp yaerao amwan kwatae nɨnɨk mwaek sámpá akwap nánko te, amo am yae ankwap mwaekamp karámp-tákapea sɨrampo. Aeriaka maok, amo yae-párák yiki yak sámp nanapon. Takria amo yae énénkér sámpá yakria, amo torokwar mo i konámp yaomwi mek pɨk nanape. ");
INSERT INTO yuj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Am némp te sáráp kánanke arop pourou mek fánámp te sumpwi mo, tá pourou wouroukournámp yaomwirao kor torokwar mo i konámpon.) ");
INSERT INTO yuj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aeno waráp pu korao amwan kwatae nɨnɨk mwaek sámpá akwap nánko te, amo am pu kor karámp-tákapea sɨrampo. Aeria maok, am pu ankárank fek saráp yiki yak sámp nanapon. Tá amo pu énénkér sámpá yak napo te, amwan yaomwi mek sɨr mwanape. ");
INSERT INTO yuj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Am némp te sáráp arop pourou mek fánámp te, sumpwi mo i konámpon. Tá pourou wouroukournámp yaomwirao kor torokwar mo i konámpon.) ");
INSERT INTO yuj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tá waráp yirao amwan kwatae nɨnɨk mwaek sámpá akwap nánko te, amo ankár wurukupea sɨrampo. Aeria amo ankárank mwaek yi fek saráp yakria maok, Kwaro náráp firáp taokeyaknámp mek yoump nanapon. Tá amo yi anánkaopwe sámpá yak napo te amwan yaomwi mek sɨr mwanape. ");
INSERT INTO yuj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Am némp te sáráp arop pourou mek fánámp te, sumpwi mo i konámpon. Tá pourou wouroukournámp yaomwirao kor torokwar mo i konámpon. ");
INSERT INTO yuj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Oukwe ofa mek yɨrɨr i konap te ofa yiki kukur naenámpria ni konapon. Tá taknámp, yaomwirao aropamp nɨnɨk mekamp kwatae nɨnɨkan kor wourékɨmpria nɨnɨk yiki kukarrá kák naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Oukwe te yae-párák kare ankankono. Aeno maomp nape konámp akwapá moyak nánko te, yumo fwap mokopia napo, am oukwe warko nape naenámpono? Táte taknámp oukwe nape niamp yiráp nɨnɨk mek yak nánko maok, yumo fwap yiráp ankwapnápént yonkwae porokwe kwapwerá tankápria warákár mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisaso distrik Galili meknámp distrik Judia mek koropea ént Jordan mek nkwamwaek fimwaek tápamprá yoump nánko, táte kápae kare koumteouráp arop koropeaka warko maomp wonae fik koupoukourapo maok, mao námoku i konámp nɨnɨkaok am fárákapan Kwaromp kar farákáp. ");
INSERT INTO yuj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aenko maok, Farisi fákáre koropea man mokopon nke mwar ritea turunkrá, “Nomp lo te yupu pwar mwanámp te ‘Fwapono’rá sénámp ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Aerapo maok, Jisaso am fárákapamp kar pwarokwaprá arakrá sér, “Moses te Juda fi yumwan apae lo sánkámpon?” ");
INSERT INTO yuj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aeránko maok, am fárákapao sérrá, “Moses te ‘Arop yupu pwar námp kwamp te, pas kumwiaka yupuan sánkria, pwar mwanap te fwapono’rá sérimpono.” ");
INSERT INTO yuj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aerapo maok, tá Jisaso am fárákapamp kar pwarokwaprá arakrá sér, “Táte yumo Juda fi yumokunap nɨnɨkaokrá paokop napantá am lo kumwimpono. ");
INSERT INTO yuj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Táte me koum sik te Kwaro ankank ponankor yoroia, tá poumou ntia yupu yoroimpon. Kwaromp Buk fek makrá sénámpon. ");
INSERT INTO yuj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kwaro sérrá, ‘Arop yupu sámpria éntupwar naropwar pwarará maomp yupunt koump námp te, am anánkwap te waeman ankárankamp pourounono. ");
INSERT INTO yuj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Am anánkwap te warko anánkaopwe mono.’ Waeman ankárankamp pourou niamp kare yak nepono. ");
INSERT INTO yuj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aenámpara, Kwaro fekarea fákapá pwatenámp yupu anánkwap te aropao poporori kwapono.” ");
INSERT INTO yuj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wakmwaek Jisaso éréképá yárak i konámp arop fákárerao tukupea nap mek yupu pwar konap kar warko turunk. ");
INSERT INTO yuj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mao am fárákapan sérrá, “Arop ankárankao yupu pwarará ankwap yupu sámp námp te, náráp yupuan kwatae nɨnɨkria, mao ankwap yupurént kokopor námpono. ");
INSERT INTO yuj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tá yupurao poumarop pwarará akwapea ankwap nap mek tank námp te, náráp poumaropan kwatae nɨnɨkria ankwapént kokopor námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Koumteouráp arop fárákap Jisaso ‘Náráp tárápuan yae papria ourour sánkano’ ria maonámpok éréképá korop. Aeapo maok, Jisaso éréképá yárak i konámp arop fárákap nkea am arop fárákapan yopor. ");
INSERT INTO yuj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisaso takapo nkea maok, náráp fárákapan yoporia arakrá sér, “Tárápu te numwar ononampok koropanápono, pwarenke. Kwaro náráp firáp taokeyak námp mek te mámá tárápu kánanke-táráp niampi yakápnap arop fárákapao maok, am mek yakáp mwanapono. ");
INSERT INTO yuj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ono yumwan waeman kare kar sér rae: Táte arop ankwap mámake tárápu kánanke-tárápao Kwaro náráp firáp taokeyak námp mek yink konap niamp tak mo námp te, mao te am mek yoump naenámp pourou mo karenono.” ");
INSERT INTO yuj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aerá séria pwarará tárápu ankákárankrá yae yukup mek fákeyakrá me korok yae paprá ourour nénk. ");
INSERT INTO yuj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisaso takia pwarará fárámprá akwap naerianánko maok, arop ankárankao fárakoprá koropea kwaráp torokompria man arakrá turunk, “Kwapwe kare tisa, ono te mokopiaka yiki yaká yak sámp nanampon?” ");
INSERT INTO yuj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aeránko maok, nopok Jisaso sérrá, “Amo te apaeria onan ‘Kwapwe kare’rá sénapon? Kwar ankárankampao saráp kwapwe kareno. ");
INSERT INTO yuj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lo kar te amo wae mér napon: ‘Yumo arop tirá wouri kwapon. Yumo ankwapamp koumteou poumou tárápunt kokopori kwapon. Yumo oukuni kwapon. Yumo arop ankwap kwekárrá koti kwapon. Yumo arop ankwapamp ankank kɨkiankiaka pouroukoup kwapon. Yumo te ankár yiráp éntupwar naropwaromp yae ankore mekria maomp karwaok saráp kipo.’” ");
INSERT INTO yuj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aeránko maok, am aropao Jisasén sérrá, “Tisa, ono te wokwaek épér mo feknámpia koropea, oukoumwan namp te waeman am loaok saráp yak nampon.” ");
INSERT INTO yuj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Aeránko maok, Jisaso man énounkoupia warákár tokwaeria man sérrá, “Amo ankárankamp ankank te oukoumwan pwi mo napon. Amo akwapea waráp ankank ponankor aropan nénkea maok, am fekamp mani tia amo ankár ankank moráp aropan nénkampo. Amo takria maok, yámar mekamp kwapwe kare ankank sámp nanapono. Amo takia pwarará, ononampaok koropampo.” ");
INSERT INTO yuj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aeránko maok, am arop am kar wawia yépe kákárápea nɨnɨk kápaeria maok, Jisasén pwarará námokuráp némpouk arákarrá akwap. Am te apae riteanápe náráp ankank kápaeran aropan nénk te monoria námpon. ");
INSERT INTO yuj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisaso námoku éréképá yárak i konámp arop fákáreran énounkoupia sérrá, “Arop fárákap kápae kare ankankráp te Kwaro náráp firáp taokeyak námp mek yoump naenámp te kour sɨr kare námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aeránko maok, námoku éréképá yárak i konámp arop fárákap maomp am kar wawia maok, kokorokor. Aeapo maok, Jisaso warko sérrá, “Tárápu! Ankank tokwaeráp arop Kwaro náráp firáp taokeyaknámp mek yoump naenámp te kour-sɨr kare yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel tokwaerao nil me kánanke mek yoump naerianánko, fákap nánko, kounkour i konámpnámp taknámp, ankank kápaeráp aropao kor Kwaro náráp firáp taokeyaknámp mek yoump naenámp te kour-sɨr tak námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aeránko maok, námoku éréképá yárak i konámp arop fárákap támao kokorokoria maok, námoku támao sérarrá, “Ae te takanánko te, wa mokop am mek yoump naenámp pwi námpon?” ");
INSERT INTO yuj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas am fárákapan énounkoup karia maok, sérrá, “Arop námoku te am tak mwanap pourou mono. Kwaro mwar kápae kare ankank fwap tak naenámp pwi námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aeránko maok, Pita Jisasén kar ankárankamp arakrá sérrá, “Amo nkeae! Yino te kápae kare ankank te ponankor pwarará waráp wakmwaek korop námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tá Jisaso sérrá, “Ono waeman yumwan kare kar sér rae: Arop ponankor onan, tá Kwaromp Kwapwe Kare Karan nɨnɨkria, náráp nap, ankwapnáp, antáp, éntupwar, naropwar, náráp tárápu, náráp yopwaran kor kwaporok pwarareanámp te, ");
INSERT INTO yuj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nopok fwap warko 100 por sámp naenámpon. Oukoumwan mámá ke fek yakáp nap fek Kwaro fwap kápae kare ankank ponankor nénk nánko, manénkɨr ti-fákeyakápi napan kámákár akwap naenámpon. Am fárákap fwap kápae kare nap sámp, kápae kare ankwapnáp, antápnáp, éntupwar, tárápu, tá kápae kare yopwaran kor sámp mwanapon. Tá arop ankwap fárákapao nkwakwe make nɨnɨk kwatae nénkea napan kor, nánkár wakmwaek kor mao te yiki yakáp mwanap sámp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kápae kare arop fárákap oukoumwan mekia tukup nap te, nánkár te wakmwaek kar yakáp mwarea napon. Tá kápae kare arop fárákap oukoumwan wakmwaek kar yakáp nap te, am fárákap nánkár mekia tukup mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisas mao Jerusalem mek tukup mwaria mwaeaok tukupria, Jisaso mekia akwap. Aenko mao éréképá yárak i konámp arop fárákapao nɨnɨka waeapo maok, koumteouráp aropao maomp wakmwaek tukupria maok, apáp tɨrɨnk. Tá Jisaso námoku éréképá yárak i konámp arop éntér-sámpramp warko éréképea maok, am fárákapan ‘Námwan mwanap’ ria farákápria arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Yumo wawenk! Oukoumwan te nomo Jerusalem mek tukupeanánko, arop ankárankao Aropamp Táráp warámp-santukupea pris tokwae ntia lo yénkrá farákáp konap aropaonapok mwanapon. Aenapo, am fárákapao man kotia maok, faropea sumpwi pap mwanap kar papea ankwap firamp yaek pwar mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aenapo maok, am arop fárákap man wouroump-séria, tá man atoprá, man faropea sumpwi páte napo maok, yinɨnki yakea warko fárámp naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedimp namoráp yawor Jems ntiaka Jon koropea Jisasén sérrá, “Tisa, yino amwan apae ankank sápaeria sénenko, yinan sáp te mokop nanaprá turunk reno.” ");
INSERT INTO yuj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aerepo maok, mao am arop yaworan sérrá, “Yumwan te apae nanampon?” ");
INSERT INTO yuj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Am arop yaworao man sérrá, “Nánkár wakmwaek amo wae apár ponankoramp King Tokwae yaknap ke fek, amo yinan waráp sia king fek ankwap yae-párák mwaek tank naenámp, tá ankwap yae-mánkwan mwaek tank naenámpia yororoi kákampo.” ");
INSERT INTO yuj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aerá sénepan maok, Jisaso am arop yaworan sérrá, “Yumo te am onan turunknep kar fwapia mér mo nepon.” Aeritea maok, Jisaso am arop yaworan wounáp kar kánanke arakrá turunk, “Ae te ono oukoumwan am mek fánaerianamp kap mek te yumo fwap am mek fánenep nie? Ono oukoumwan sumpwi naeria namp te, yumo fwap taknámp sumpwi nenep nie?” ");
INSERT INTO yuj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aeránko maok, am arop yaworao man sérrá, “Yino te fwap tak nenempon.” Aerepo maok, Jisas am arop yaworan sérrá, “Tá kare, ono oukoumwan fánanamp kap te yumo kor fánenepon. Tá ono oukoumwan sumpwi naeria namp te yumo kor tak nenepon. ");
INSERT INTO yuj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aeno arop onomp yae-párák mwaek tank naenámp, tá yae-mánkwan mwaek tank naenámp te, am te apae ono nánapnamp ankankanápe mono. Am sia te Kwar námoku nánapi pwatenámp arop fárákapampono.” ");
INSERT INTO yuj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aeránko maok, ankwap fárákap fére-sámprampao am turunknep kar wawia maok, Jems ntia Jonén yopor. ");
INSERT INTO yuj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisaso am fárákapan koropenk ritea maok, sérrá, “Yumo te wae mér napono: Ankwap fi arop te arop poukeyakápria, náráp firan fopwaoka wae konapon. Tá arop tokwae kar yakáp nap te koumteouráp arop fárákap ankár ‘Náráp karwaokenk’ ria kárákárea wae konapon. ");
INSERT INTO yuj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Aeno am nɨnɨk te yumo ou mek yak naeane, mono. Yumo ou mek arop tokwae yak naeria námp kwamp te, mao te ankár ponankor aropamp tére arop yak kuno. ");
INSERT INTO yuj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Arop meki akwapnámp arop tokwae yak naerámp kwamp te, mao ankár wakmwaek kar yaknámp ponankor aropamp kwaporok tére konámp arop niampi yak kuno. ");
INSERT INTO yuj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Am te apae riteanápe, Aropamp Tárápao kor arop fárákapao náráp téreria námwan yaewour mwanapria korop mono. Mao korop námp te am fárákapan yaewouria maok, tá námokuráp pourouran faropanáponoria aropan sánkea maok, am fek táman kápae kare koumteouráp arop warko yamokwap nanampria námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas ntia am fárákap tukupea taun Jeriko mekia maok, Jeriko pwarará tukupapo maok, Jisaso éréképá yárak i konámp arop, tá koumteouráp arop ou tokwae énénki am fárákapént tukup. Aeapo maok, Timeusomp táráp Bartimeus, yi aompi yak nánko, mwae fik tankria koumteouráp arop tukup napo, am feknámp ‘Mani ankank sápenk’ ria sér i konámp. ");
INSERT INTO yuj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mao wa nánko, Nasaret mekamp Jisas koropánko maok, man kárákáre fek wumwi, “Jisas, Devitomp ou fekamp Táráp e! Amo onan aropompae!” ");
INSERT INTO yuj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Aeránko maok, arop fárákapao man ‘Kar sér pwarae’ ria yopor. Aenapan maok, mao ankár tékén arakrá sér, “Devitomp ou fekamp Táráp e! Amo ankár onan aropompae!” ");
INSERT INTO yuj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aeránko maok, Jisas fokopeyakrá sérrá, ‘Man wumwi napo koropano’ránko maok, am fárákapao am yi wurumpi yaknámp aropan wumwiria maok, man sérrá, “Jisas amwan wumwiane. Amo warákárrá fárámpae.” ");
INSERT INTO yuj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aerapo maok, mao náráp waempyam sɨrarrá koupour fárámprá Jisasnámpok akwap. Aenánko Jisaso man arakrá turunk, “Amo te ono amwan te apae aeria nape?” ");
INSERT INTO yuj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aeránko maok, am yi wurumpi yaknámp arop támao sérrá, “Tisa, ono te yi nke nae rae.” ");
INSERT INTO yuj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aeránko maok, Jisaso man sérrá, “Fwapono. Amo wae akwapae. Waráp mér nap támao amwan fwapi pap námpon.” Aeránko maok, táte mao wae fwap nkeria maok, Jisasén éntér paprá mwae-páraok akwap. ");
INSERT INTO yuj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","3","Mao wae tukupea Jerusalem mek mwariaka némp Betfage ntiaka Betani mek wonae fik Oliv faonkwekria Jisaso éréképá yárak i konámp arop yaworan sérrá, “Yumomékɨr am nomo nkenámp némpouk am fek akwapenke. Yumo akwapea am némpoukria koupour kar nke nepo, arop donki soup arop oukoumwan am fek tank moianámp tokorop tenapan, aokorop-pwararea sankorop kipo. Aenepo, yumwan arop ankárankao ‘Am apae nenepon?’ ria turunk nánko te, yumo arakrá sér kipo: ‘Tokwae Karao am fek tére naenámpono. Mao téreaka pwarará koupour kar warko sámp-kérép naenámpon.’” Aerá séria pwarará maok, Jisas am arop yaworan sámp-kérép. ");
INSERT INTO yuj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aeria maok, am arop yaworao akwapea nke nepo, am donki soup ankárankamp nap ménki fek wonae fik apárok mwae fik tokorop tenapo maok, am táman aokorop. ");
INSERT INTO yuj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Aenepo maok, arop ankwap fárákap wonae fik yakápia am arop yaworan arakrá turunk, “Yumo te apae neria am donki soup aokorop repe?” ");
INSERT INTO yuj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aerapo maok, am arop yaworao am fárákapan Jisas manénkɨr sérinámp kar sérepo maok, am fárákapao kor “Takenke.” ");
INSERT INTO yuj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Aerapo maok, am arop yaworao donki soup warámpea Jisasonámpok koropea maok, námokuráp waempyam am donki paonkore kor fek yunkupá pwarepo maok, Jisaso am fek tank. ");
INSERT INTO yuj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aenánko maok, arop kápae karerao kor, Jisas tanknámp donki am fek pumpurékamprá akwapanoria mwaeaok náráp waempyam ankank woroprá yunk. Tá ankwap fárákapao yopwar mek mwaekamp yao yowe karámp-tokoprá mwaeaok yunk. ");
INSERT INTO yuj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aenapo, koumteouráp arop ankwap fárákap mekia tukup nap, tá ankwap fárákap wakmwaek éntér káki tukup nap, mao ponankor fáparákrá tékén arakrá sér, “Nomo Kwarén warákár mwaro! Am arop Kwaro námokuráp e fek sámp-kérépeanámp aropara, man ourour sánkano. ");
INSERT INTO yuj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nomp ounáp Devit kápae kare aropan taokeyaknámp taknámp oukoumwan kor mámá arop nomwan taokeyak naenámpon. Ae naenámpara, nomo Kwaromp e narek karaok sampok mwaro.” ");
INSERT INTO yuj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tá Jisaso akwapea Jerusalem mekria maok, lotu nap tokwae mek youmpea ankank ponankor énounkouprá yárak. Takia pwarará maok, yámar porokor naeria námpantá mao náráp éréképá yárak i konámp éntér-sámpramp arop fárákapént Betani mek arári tukup. ");
INSERT INTO yuj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wokwae ankwap kumuruk Betani meknámp Jerusalem mek aok mwaria maok, Jisas mwaeaok yae-porokwe nánko maok, ");
INSERT INTO yuj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","nke nánko, yao fik panek tae morok yakánko pwae kápae kare. Aemantá maok, mao akwapea wonae fik am fek ki tank mákeanrá oupourounk námpan maok, ki ankárank tank mo kare, pwae mwar yak. Am te apaeria námpanápe, oukoumwan tank konámp ke mono. ");
INSERT INTO yuj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aenánko maok, Jisaso am yaoan arakrá sér, “Amo warko ki tank napo, arop fárákap am ki fár mo kareno.” Aerá séránko, mao éréképá yárak i konámp arop fárákap am takrá sénámp kar wae wa. ");
INSERT INTO yuj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas ntia mao éréképá yárak i konámp arop fárákap tukupea Jerusalem mek, tá Jisas lotu nap tokwae mek youmprá maok, am mek bisnis térenap arop fárákapan ek yéréperá kérép. Aeria ankwap firamp mani tia lotu nap tokwaeramp mani nopok nénknap kákánarrápan, tá am arop fárákap am fek tankáprá, ant mani fek nénknap sia méntér wakárarrá souroumpour. ");
INSERT INTO yuj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aeria maok, mao arop ponankoran ‘Yumo nkwakwe make ankank tiaka lotu nap yár meaok paokopi kwapono’rá sér. ");
INSERT INTO yuj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aeritea maok, mao am fárákapan yénkrá farákápria sérrá, “Kwaromp Buk fek kar arakrá sénámpono: ‘Onomp nap máte “Kápae kare arop fi onan kar toropwap i konap nap”rá sér mwanapono.’ Aeno yumo mákiaka arop fupukrá ankank pouroukoup mwanap aropao, mek wouroumpeyakáp konap apár niampi pap nape.” ");
INSERT INTO yuj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pris tokwae fákáre ntia Kwaromp lo yénkrá farákáp konap arop fákáre am kar wawia Jisasén farop mwanap mwae kup oupourounk. Am tak nap te apae riteanápe koumteouráp arop ponankor Jisasomp kar wa napo, kwapwe kare námpantá, táman kokorokoria napon. ");
INSERT INTO yuj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aeapo maok, kumuran Jisas námoku éréképá yárak i konámp arop fákárent Jerusalem pwarará Betani mek tukupapono. ");
INSERT INTO yuj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wakmwaek ankwap yae fek koumounek kar Jisas ntia mao éréképá yárak i konámp arop fárákap tukupria am yao fik nkeapo maok, wae yákáre yak. Tá maomp pwae ntia arák te wae yoronkwae yak. ");
INSERT INTO yuj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aenko maok, Pita am yao fikan Jisaso sérimpan nɨnɨkia sérrá, “Tisa, amo yipɨrman mámá yao fikan ‘Kwatae akwapano’rá séri nap te, oukoumwan wae yákáre yakáne!” ");
INSERT INTO yuj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aeránko maok, Jisaso am fárákapamp kar pwarokwaprá sérrá, “Yumo ankár Kwarén mér kárákáre kipo. ");
INSERT INTO yuj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ono yumwan kare kar sér rae: Arop anánk nɨnɨk yak moria, námo am ankank fwap nke nanamponorá mér kare námp te, am arop te fwap mámá faonkweran sérrá, ‘Amo fárámprá solwara mek far-kɨrékapae’rá sénánko te, mao te fwap am nɨnɨk námp niamp take pourouráp sámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ae naenámpara, yumo ankank sámp mwaria, fwap sámp mwanámpon nɨnɨkria, Kwarén kar toropwap nap te, yumo waeman sénap niamp take pourouráp sámp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yumo Kwarén kar toropwap nae nap kwamp te, arop ankwapao yumwan kwatae nɨnɨkianánko, yumo mao amwan kwatae nɨnɨki námp nɨnɨk nap kwamp te, yumo maomp kwatae nɨnɨk nɨk mo pwar kipo. Am takia pwarapo, yiráp Naropwar Kwar yámar mek yak námp waráp nɨnɨk kwataeran kor nɨk mo pwar naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Aeno yumo am aropao yumwaninámp kwatae nɨnɨk nɨk mo pwar moia napo te, Naropwar Kwar yámar mek yak námp mao te yiráp kwatae nɨnɨkan kor sámp-sɨr mo naerámpon. ");
INSERT INTO yuj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisasomp fákáre warko tukupea Jerusalem mek napo maok, Jisaso akwapea lotu nap tokwae yár mek yárak nánko maok, pris tokwae fákáre, tá lo yénkrá farákáp konap arop, tá Juda fi taokeyakáp i konap arop makia maonámpok korop. ");
INSERT INTO yuj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aeria maok, mao lotu nap tokwae mek bisnis térenap arop yéréperá kérépámpan nɨnɨkrá man turunkrá, “Amwan te wa kárákáre sánkrá, takrá téreaerianánko tére napon? Amo am kárákáre te maokamp sámpea, am fek tére napon?” ");
INSERT INTO yuj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisaso am arop fákáreran sérrá, “Ono kor yumwan ankwap ankank ankárank turunk nae nae. Táte yumo ono turunknamp kar pwarokwaprá sénapo maok, nopok ono kor am kárákáre wa sáp námp yumwan fwap sénanampon. ");
INSERT INTO yuj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wokwaek Jono arop ént mek nérrá kák námp te yumo nɨnɨk nap te, am te Kwaromp ankank ni, aropamp ankank nie? Yumo onan sérenke.” ");
INSERT INTO yuj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Aeránko maok, am fárákapao námoku kok sérarrá maok, arakrá sér, “Táte nomo ‘Kwaromp ankank’rá sénánko te, nomwan ‘Ae te yumo apaerá man mér mo napono?’rá sénaeane. ");
INSERT INTO yuj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Táte nomo ‘Aropamp ankankono’rá sénánko te am kar te pwi mono.” Am takrá sénap te apae riteanápe waeman arop ponankor ‘Jon te profet kare’rá sénapantá, apápria napono. ");
INSERT INTO yuj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ae nap kwamp maok, Jisasomp kar pwarokwaprá sérrá maok, “Mono. Yino te mér mono.” Aerá sérapo maok, Jisas kor am fárákapan sérrá, “Ono kor am kárákáre maokamp sámpeaka am fek tére namp te yumwan sér mono.” ");
INSERT INTO yuj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisaso Juda fi mekamp arop nununkwiramp nɨnɨkan wounáprá arakrá sér, “Arop ankárankao wainampor yopwar yɨmpea, farmaea pwar. Aea maok, yumwi youkoupea wain ki sokwap mwanap tang yoroi pwar. Tá am yopwarantá yérék naenámp aropampor nap tia pwar. Aea maok, am yopwar te am mek térerá mani sámp mwarianap aropamp yaek pwarará, mao námoku te akwapea panek ankwap némpouk yak. ");
INSERT INTO yuj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Akwapá yakea maok, wae wain ki yápaenámp ke fek wain ki, námwan ankwapmwaek sápanáponoria náráp tére arop am wain yopwar taokeyakápnap aropaonapok sámp-kérép nánko, akwap. ");
INSERT INTO yuj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Akwapea maok, am yopwar taokeyakápnap arop fárákapaonapok nánko maok, am fárákapao man sámpá fukia kwaporok yérépe sámp-kérép. ");
INSERT INTO yuj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aeapo maok, tá am yopwar naropwar tére konámp arop ankwap sámp-kérép nánko, akwap nánko, man me korok porokwapea pwarápae sánk. ");
INSERT INTO yuj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aeapo warko ankwap tére arop sámp-kérépánko maok, man kor fukia sumpwi pap. Aeapo, warko kápae kare tére arop tirá kérép námpan maok, am arop fárákapao ankwap fárákap párák fupukria, ankwap fárákap wae fupukrá yákáre kák. ");
INSERT INTO yuj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Takia pwar napo maok, arop ankárank kare mwar yak. Am arop te mao warákár kare konámp námokuráp tárápono. Aenámpan maok, wakmwaek kar am táráp sámp-kérép naeria sérrá, ‘Am fárákap te fwap onomp tárápamp kar wa mwanapono.’ Aeria sámp-kérép nánko, am yopwar taokeyakápnap aropaonapok akwap. ");
INSERT INTO yuj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Aenámpan maok, am yopwar mek térenap arop fárákapao man nkeaka námoku ou mek kar arakrá sérarapon, ‘Mámá arop máte naropwaromp weri mek yakria ankank ponankor wakmwaek ti naeria námpono. Nomo koupour man kor sámp-wouroump mwaro. Nomoku má yopwar má ankár sámp mwanámpono.’ ");
INSERT INTO yuj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aeria maok, man sámpá fukia maomp yákáre te yopwar farmae younkwek sɨtenapono.” ");
INSERT INTO yuj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Am wounáp kar séria pwarará, Jisas koumteouráp aropan turunkrá, “Am yopwar naropwar koropea te apae naenámpon? Mao koropea te, am yopwar mek térenap arop fárákapan tirá wouria pwarará, am yopwar arop ankwap fárákapan sánk nae-námpon. ");
INSERT INTO yuj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ae te yumo Kwaromp kumwi kánanke te nkea farákáp moi napon? Am te arakrá sénámpon: ‘Am yumwi te térenap aropao kwataenoria pap napon. Aeno oukoumwan te, mao nap sámp-fákeyak konámp nap kouprér niampon. ");
INSERT INTO yuj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tokwae Karao námokuianánko, mámá ankank korop námp te, yino nke nánko, am te kwapwe kare námpon.’” ");
INSERT INTO yuj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Aenánko, am arop nununkwi fákáre Jisaso am wounáp kar sénámp te, waeman yinan táman sénámponrá mér. Aeria maok, Jisasén sámp mwaria napao maok, koumteouráp aropan apáp ap kwamp maok, pwarará tukupap. ");
INSERT INTO yuj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","14","Aeria maok, Farisi ankwap fárákap, tá Herotént yakáp konap arop ankwap fárákap tukupea maok, Jisasén, mokoprá séran wawia man kot mwar ritea poupwekáprá sérrá, “Tisa, yino te wae mérono, amo te aropan apáp mo, ankár kare kar saráp sér i konapono. Amo te ankárankamp pourouráp nɨnɨk fek ponankor aropan tére konapon. Aeno amo nɨk nap te mokopono? Mosesomp loao nomwan ‘Fwap Sisarén takis sánk mwanapono’rá sénámp ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aenapan maok, Jisas te am fárákapamp poupwekáp nɨnɨk te wae mérámp kwamp maok, am fárákapan sér, “Ae te yumo te onan apaerá kwekár napon? Mani náparamp sankorop napo, ono nke nae.” ");
INSERT INTO yuj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aeránko, am fárákapao mani náparamp sankoropea sánkapo, mao am fárákapan turunk, “Mámá wunéri tá e máte wampono?” Aeránko maok, am fákárerao sérrá, “Am te Sisarompono.” ");
INSERT INTO yuj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tá nopok Jisaso am fárákapamp kar pwarokwaprá sér “Tá Sisaromp te Sisar námokuráp sánk kip, tá Kwaromp te Kwar námokuráp sánk kip.” Aeránko maok, am fárákapao maomp kar wawia kokorokor. ");
INSERT INTO yuj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Warko Sadyusi ankwap fárákapao, arop sumpwi nap te warko fárámp monorá mér i konap kwamp, koropea Jisasén arakrá turunk, ");
INSERT INTO yuj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tisa, Moseso kar ankwap kumwia nomwan arakrá sér, ‘Arop ankárankao táráp mo námpao sumpwi nánko, tá yupu mwar yak nánko te, nánaerao sámpeanánko, am yupu tárápu tianánko, naerao yaknámp weri mek yak nánko, am fi tomore mo naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Amo am kar fwap mérapo te, yino amwan ankwap kar turunk mwaro: Tá fákánek mwearo yakáp nap kwamp te, nae-tárápao yupu sámpea táráp sámp moitea sumpwi nánko, ");
INSERT INTO yuj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","tá warko nánaerao sámp. Sámpea tanknámp, táráp sámp moia sumpwi nánko, warko am nánaerao kor taknámp tak. ");
INSERT INTO yuj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Takrá akwapea am fákánek mwearo am ponankor am yupu sámpea táráp sámp moiaka, ponankor faokaria napo te, wakmwaek yupurao kor taknámp sumpwi. ");
INSERT INTO yuj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Amo te wae mér, am fákánek aropamp yupu te am ankárankamp támaono. Tá nánkár wakmwaek kor sumpwinap arop fárámpnap ke fek am yupu te wamp yupu yak naenámpon?” ");
INSERT INTO yuj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aerapo maok, Jisaso am fákáreran sérrá, “Yumo te Kwaromp Buk fekamp kar fwapia mér mo napon. Tá Kwaromp kárákáreran kor taknámp fwapia mér moria maok, yumo épérép kar sérarapon. ");
INSERT INTO yuj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nánkár sumpwinap arop apár me meknámp warko ferámpnap ke fek te yupu sámp mono. Kwaromp yámar mekamp ensel fákárerao yakáp napnámp taknámp yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aeno mámá sumpwinap arop warko ferámp mwanap kar te, yumo Mosesomp buk fekamp kar yao kánanke mek yaomwirao yurunk námpao maok, yao fár mo námp te yumo nkerá farákáp moi napon? Am farákápnámp kar te Kwaro Mosesén sérrá, ‘Ono te waráp wokwaekamp appeyaenáp Abraham, Aisak, Jekop, maomp Kwarono.’ ");
INSERT INTO yuj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kwar te sumpwinap aropamp Kwaranápe mono. Am Kwar te yiki yakápnap aropamp Kwarono. Aenámpan maok, yumo te épérép kare kar sénapon!” ");
INSERT INTO yuj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lo yénkrá farákáp konámp arop ankárank koropea wa nánko, am arop fárákapao Jisasént kar yorowarrá yakáp. Aenapo Jisas nopok yae-párák kare kar fek am fákáreran sérámpantá maok, mao Jisasén turunk, “Apae lorao tokwae kari yakria ponankor loan kámákár akwap námpon?” ");
INSERT INTO yuj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aeránko Jisaso am kar pwarokwaprá arakrá sér, “Lo tokwae kari yak námp te aránon: ‘Israel, yumo wawenk. Tokwae Kar te nomp Kwar Tokwae ankárankamp támaono. ");
INSERT INTO yuj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yumo ankár yiráp yonkwae kare ponankor, yiráp waemp ponankor, yiráp nɨnɨk ponankor, tá yiráp kárákáre ponankor fek Kwarén warákár tokwae kipo.’ ");
INSERT INTO yuj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lo anánk te ará: ‘Amo ankár waráp firáp aropan warákár nap te, amokuráp pourouran warákár konapnámp taknámpampo.’ Lo ankwap te am anánkaopwe man kámákár akwap mono.” ");
INSERT INTO yuj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aeránko maok, am lo mérnámp arop Jisasén sérrá, “Tisa, amo sénap kar te kwapwe kareno. Tá amo kare sénapon, Tokwae Kar ankárankampao saráp Kwarono. Ankwap kwar yak mono. ");
INSERT INTO yuj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aeno nomo te ankár nomp yonkwae kare ponankor, nomp nɨnɨk ponankor, tá nomp kárákáre ponankor fek man warákár kare mwanámpon. Tá nomo ankár námoku warákár konámpnámp taknámp arop ankwap fárákapan kor taknámprá warákár mwanámpon. Am lo anánkaopwe támao ampaok nánko te, am nɨnɨk támao ponankor ofa yaomwi mek yankap, tá ponankor nkwakwe make ofaran kámákár akwap námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas am kar wa nánko maok, arop mér kwapwenámp aropamp kar niamp nánko maok, Jisaso man arakrá sér, “Amo te Kwaro náráp firáp taokeyak námp mek te panek yak mo napon.” Aeránko maok, arop ponankor te apápria, Jisasén kar ankwap turunk mono. ");
INSERT INTO yuj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisaso lotu nap tokwae mek yakriaka koumteouráp aropan kar yénkrá farákáp. Aeriaka mao arakrá turunk, “Lo yénkrá farákáp konap arop te mokopia ‘Krais te Devitomp táráp’rá sénapon? ");
INSERT INTO yuj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tá wokwaek kar Yiki Kor Spiritao Devitén nɨnɨk sánk nánko, Devit námoku sérrá: ‘Tokwae Karao onomp Tokwae Karan arakrá sér, “Amo onomp yae-párák mwaek tankrá akwapea napo, waráp yopor arop waráp yae ankore mek kák tenanko, yakáp mwanapon.” ’ ");
INSERT INTO yuj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit námoku am aropan ‘Náráp Tokwae Kar’rá sénámp te, mokopia am arop warko Devitomp fi mekamp yak naenámpon?” (Jisaso am kar séránko maok, kápae kare koumteouráp arop maomp kar wawia warákár.) ");
INSERT INTO yuj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tá Jisaso am fárákapan kar yénkrá farákápria arakrá sér, “Yumo te lo mérnap arop fárákapan fwapiaka mér kip. Am fárákap te waempyam éri képéria paokop mwar kar i konapono. Tá koupoukour nap fek koumteouráp aropao, námwan ‘Gude’rá sérenk kar i konapono. ");
INSERT INTO yuj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Am fárákap te lotu nap mek arop nke nap fek mekok tankáp mwar kar i konapon. Aeria maok, fɨr tokwae fánap fek kor mér arop tank konap sia fek tankáp mwar kar i konapon. ");
INSERT INTO yuj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Am fárákap te kae koumteouran poupwekáprá tukupea, wakmwaek maomp ankank ti konapono. Am nɨnɨk yak námpan maok, kwekárrá kar toropwap éri konapono. Nánkár kot mwanap ke fek am fárákap touwe tokwae kwatae sámp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisaso ankwap ke fek lotu nap tokwae mek koropea mani kák konap bokis tokwae páte nap fek am wonae fik tankrá nke nánko maok, koumteouráp arop am mek mani sɨr. Mani kápae kareráp aropao bokis mek mani kápae kare épér. ");
INSERT INTO yuj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Táte ankank moráp kae yupu ankwap koropea mani kánanke wan toea niamp anánkamp am mek sɨr. ");
INSERT INTO yuj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Aenko Jisaso námoku éréképá yárak i konámp arop fárákapan koropenk ritea maok, am fárákapan sérrá, “Ono waeman yumwan kare kar sér rae: Mámá ankank moráp kae yupu máte mao mani tokwaeráp koumteouráp arop sɨnap mani kámákarea yoporop mani tokwae sɨnámpon. ");
INSERT INTO yuj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mámá ponankor koumteouráp arop te mani kápae kare tank nánko, aopwek kánanke ankwapmwaek saráp bokis mek sɨnapono. Aeno táte am yupu te mani mo námpara, fɨr sámpá fánaenámpao kor tank mono, am kánanke táman mwar ponankor sɨrari námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisaso lotu nap tokwae pwarará akwap nánko maok, mao éréképá yárak i konámp arop ankwap ankárankao sérrá, “Tisa, am yumwi nununkwi kwapwe nkeae. Tá nap kokwapwe nko nkeae.” ");
INSERT INTO yuj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tá Jisas maomp kar pwarokwaprá arakrá sér, “Amo nap nununkwi kwapwe táman nke rape? Nánkár wakmwaek te, arop fárákapao, yumwi ankwap yumuntuk taki tankanoria pwar mono. Arop fárákapao am te ponankor momontokoria apárok sɨr mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisaso Oliv faonkwek tankria nke nánko, lotu nap tokwae nkwampok yak. Tá Pita, Jems, Jon, Andru, am yiaworaopwerao saráp tukupea man turunkrá, ");
INSERT INTO yuj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Amo yinan sérae: Mam ke fek am ankank korop naenámpon? Apaeraomékɨr korop nánko, nkea am ankank korop naenámp te wae wonae fikeanrá mér mwanámpon?” ");
INSERT INTO yuj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aerá turunkapo maok, Jisaso am fárákapan sérrá, “Yumo te fwapia mér kip! Takria arop ankárank yumwan kwekár naeane. ");
INSERT INTO yuj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kápae kare aropao koropeaka onomp eran ‘Ono támao nae.’ Makrá sér mwanape. Aeriaka kápae kare koumteouráp aropan kwekár mwanape. ");
INSERT INTO yuj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nánkár yumo wa napo, ‘Yorowar koropán’rá sér, tá panekamp yorowar kar sérarrá korop. Aenapo kor, táman wawia korokop kwapono. Am ankank te waeman korop naenámpan maok, má apár pwar naenámp yae te oukoumwan sɨkono. ");
INSERT INTO yuj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Arop ankwap firao ankwap-ankwap firént yorowar. Tá ankwap kingomp firao ankwap kingomp firént yorowar mwanap. Ankwap apárok némp yérur korop nánko, táte ankwap apárok yae-porokwe tokwae korop naenámpon. Am ankank koropánk námp te yupurao táráp fárákap naeria manénkɨr touwe sámp konámp niamp take koropánk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Am ke fek te yumoku támao fwapia mér kip. Yumwan ankwap fárákapao náráp lotu nap mekamp kaunsilonámpok santukupá kot mwanape. Aeria maok, yumwan lotu nap mek porokwap mwanap. Yumo onont paokop napara, arop yumwan éréképá tukupea gavman fákáre, tá king fákáre nke nap fek párakop napo te, yumo te onomp kar am fárákapan fwap farákáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nánkár ponankor arop fi ankár Kwapwe Kare Kar farákáp napo, wawia napo, apár pwar naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yumwan sámpá yarokwapea santukupea kot napo, yumo apápria, yino apae kar sér mwareanrá nɨnɨki kwapono. Ponankor kar te Kwaro yumwan nénk nánko, am ke fek táman yumo ankár farákáp mwanapono. Am te apae riteanápe yumoku saráp kar farákáp mono. Yiki Kor Spiritao am kar yumwan sánk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tá arop náráp nánaeran arop outɨri nánko, man foupouri pap. Tá naropwaryaenápo kuri náráp tárápuan taknámp mwanapon. Tá táráp ankwapao kor éntupwar naropwarén yoporia arop outɨri napo, foupouri pap mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tá yumo onont paokop napara, arop ponankor te yumwan kokwarok mwarea napon. Aeno aropao kárákáre yakrá akwapea, pwarnámp yae feknámp te Kwaro man warko warámp naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jisaso warko sérrá, “Yumo nke napo, kwatae kare ankank Kwaromp yiki kor taun mek fokopeyak naeane. (Arop mámá kar nkerá farákáp námp kwamp te, ankár fwapia nɨnɨk kuno.) Am ke fek te koumteouráp arop Judia apár mek yakáp nap te ankár pɨrɨkɨmpea faonkwek pok mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Táte arop naepik yakeanámp te warko nap mek youmpeaka náráp ankank sámp mono. ");
INSERT INTO yuj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tá arop yopwar mek yak námp te, arákarrá akwapea náráp nap mekamp waempyam sámp mono. ");
INSERT INTO yuj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Am ke fek te koumteou arop yareráp, tá yupu-táráp mom wurump nap te koupoutáráp nape! Mao te pɨrɨkɨmpea foporakorrá tukup mwanap kour-sɨr napono. ");
INSERT INTO yuj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yumo te am kwatae ankank te námpare korop konámp ke fek koropantáno, Kwarén kar toropwap kipo. ");
INSERT INTO yuj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Am ke fek te yoporop touwe tokwae kar korop naenámpon. Wokwaek Kwaro kápae kare ankank yoro námp fekia koropea, oukoumwan námp te take pourouráp touwe tokwae korop moimpon. Tá nánkár wakmwaek kor warko take pourouráp touwe tokwae korop mo naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Táte Tokwae Karao am touwe tokwae korop naenámp ke fek fae ták-pwar moianámp te, koumteouráp arop ponankor wour mwanapono. Ae mwanapan maok, mao námoku nánkárápnámp aropan nɨnɨk námp kwamp, am ke fae ták-pwara námpon. ");
INSERT INTO yuj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Am ke fek arop ankárankao yumwan sérrá, ‘Yumo nkenke! Krais máyakáne!’ Tá ankwapao sérrá, ‘Yumo nkenke! Nkoyakáne!’ Aerá sénánko te, yumo te maomp kar wawi kwapono. ");
INSERT INTO yuj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aeno arop ankwap fárákapao koropea yumwan kwekárrá sérrá, ‘Ono te Kraisono.’ Tá ankwap kar sérrá, ‘Ono profetono.’ Aeriaka kárákáre yororoiaka ankwap pourouráp ankankan kor tére mwanape. Ono waeman kare kar sér rae: Koumteouráp arop Kwaro náráponoria nánkáráp námp te, am taknap arop fárákap támao fwap man poupwekáp mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ae mwarea napara, yumo te fwapia mér kip. Ono waeman yumwan kápae kare ankank korop naenámp séri nampono.” ");
INSERT INTO yuj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jisaso warko sérrá, “Nánkár am touwe tokwae am akwap tenánko, yámar kɨrɨkɨp nánko, yunk warko yokor mo. ");
INSERT INTO yuj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tá yámar mekamp térme ponankor mukarrá ékrɨnk naenámpon. Yámar mekamp kárákáre kor ankankao kor wuwia wae naenámpon. ");
INSERT INTO yuj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aenánko, am ke fek táman Aropamp Táráp koumwe mek tankria kárákáre tokwae ntia maomp wae mént ék nánko, arop nke mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Am ke fek táman mao ensel fákáre tirá kérép nánko, ékiaka apár yarápae pwar námp fek tukupea, Kwaro nánkárápnámp arop fárákap koupoukarea, ponankor am fi érékép mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisaso warko sérrá, “Yumo te yao fikan nkea mér sámp mwanapon. Maomp yowe kor ént féki yak námp te, pwae wourékam arokwe nánko, am te kwapwe naenámp kenono. ");
INSERT INTO yuj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Taknámp nánkár wakmwaek kor yumo nke napo, am ankank kwatae koropánk nánko te, yumo am táman mér kip. Aropamp Táráp korop naenámp yae wae wonae fik ménki fek yak námpon. ");
INSERT INTO yuj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ono waeman yumwan kare kar sénampon: Mámá kear mekamp koumteouráp arop oukoumwan sumpwi mo, yiki yakápria, mámá ankank ponankor korop nánko, nke mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tá yámar ntiaka apár máte akwapá pwar naenámpon. Aeno onomp kar máte pwar mono.” ");
INSERT INTO yuj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jisaso warko arakrá sér, “Tá arop ankwap am ankank korop naenámp ke ntia yae te mér mono. Onomp Naropwar námoku saráp am mér námpon. ");
INSERT INTO yuj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yumo te fwapia mér fek yérékrá yakáp kip. Am te apae riteanápe, am te mae ke fek korop naenámpaoean yumo mér mono. ");
INSERT INTO yuj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Am te arak námpon: Arop ankárankao náráp nap pwatea akwap naeria, maomp tére konap arop ankákárankan arakrá kar toropwap: Náráp nap mekamp ankank má fwapia taokeyakáp kipria maok, arop ménki fek taokeyak konámp aropan, ‘Amo yérékrá yakamp’rá séritea akwap konámp niampon. ");
INSERT INTO yuj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mak ri konámpnámp taknámp fwapia yérékrá yakáp kip: Yumo te mér mo mam ke fek am nap nouroup korop naenámp te, kumuran korop ni, táte kumuruk korop ni, tá kom fárámp nánko korop ni, tá koumounek kar korop nie, am te yumo mér mono. ");
INSERT INTO yuj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Takria mao koupour koropria yumo pamp nap nkeantáno. ");
INSERT INTO yuj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mámá kar ono yumwan farákáp namp máte koumteouráp arop ponankoran sénampono: Yumo fwapia yérékria yakáp kip.” ");
INSERT INTO yuj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wakmwaek anánki yakea maok, Pasova Yae Tokwae ntiaka Pan Yis Moráp Fári konap Yae korop naenámp yae tank nánko maok, pris tokwae fákáre, táte lo yénkrá farákáp konap arop fákárerao sérrá, “Nomo te mokopiaka Jisasén poupwekápia kánánkámp sámpeaka foupouri pap mwaro?” ");
INSERT INTO yuj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Am fárákapao sérrá, “Nomo lotu i konap yae tokwae fek te am ankank tak mono. Takria koumteouráp arop nkea kokorokorria nomwan yorowar mwanape. ");
INSERT INTO yuj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Am ke fek te Jisaso Betani mek akwapea, wokwaek lepra touwe sámpá yakámp arop Saimonomp nap mek tank. Mao fánaeria tank nánko maok, yupu ankárank korop. Mao te yumwi fekamp botol kwapwe kare am te nánákáre kwapwe konámp sanda mani tokwae fekamp, am botol nás kor ták-pwararea maok, Jisasomp me korok am sanda kwarákár. ");
INSERT INTO yuj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aenánko maok, arop ankwap fárákap yakáp nap man nkea kokwarokria maok, námoku kok arakrá sérar, “Apaeritea mao am sanda kwaporok kwarákarrá pwar námpon? ");
INSERT INTO yuj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tá nomo arop sánk nánko sámpriaka 300 mani silva sáp napo, tá ankank monap aropan sánk mwanámp tene!” Makrá séria maok, am yupuran yopor. ");
INSERT INTO yuj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aerapo maok, Jisas am fárákapan sérrá, “Yumo am yupu numwar takano pwarenke. Apaerá yumo man nɨnɨk kápae sánk rape? Mao te onan kwapwe kare nɨnɨk námpon. ");
INSERT INTO yuj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nánkár am ankank monap arop fárákap te yumont kápae kare por yakáp napo, yumo am fárákapan yaewour saráp yakáp mwaria te tak mwanapon. Aeno ono te yumont kápae kare por yak mono. ");
INSERT INTO yuj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ankank mámá yupuaoi námp te fwap tak naenámp pwi nánko námpon. Ono oukoumwan sumpwi mo nanko, mao onomp pourouk sanda kwarákárámp te onomp pourou apár me mek pap mwanap nánap námpon. ");
INSERT INTO yuj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ono yumwan waeman kare sénampon: Ponankor apár mekmwaek tukuprá Kwapwe Kare Kar farákápria mámá yupuaoinámp ankank máman kor méntér sérar napo, arop fárákap man nɨnɨk mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Am ke fek mént paokop i konap arop éntér-sámpramp ou mekamp Judas Iskariot mao pris tokwae fákáreaonapok Jisasén am fárákapamp yaek pap naenámp kar akwapá sérar. ");
INSERT INTO yuj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aenko am fárákapao am wawia maok, warákáránkria maok, am fárákapao man sérrá, “Amwan mani ankwapmwaek sánk mwanámpon.” Aerapo maok, Judaso am aropamp yaek sánk naenámp mwae kup oupourounkimpon. ");
INSERT INTO yuj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yis Moráp Pan Fépér i konap Yae ankárank korop nánko, Kwaro Israel firan yaewouránko fwapi yakápiap ke nɨnɨkrá fári konap sipsip morok faopornap ke. Aenánko maok, námoku éréképá yárak i konámp arop fákárerao Jisasén turunkrá, “Amo nɨnɨk nap te, yino te maok tukupea am Pasova fɨr nánap mwanámpon?” ");
INSERT INTO yuj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aerapo maok, Jisaso námoku éréképá yárak i konámp arop anánkaopweran tirá kérépria arakrá sér, “Yumo akwapea Jerusalem mek nepo, arop ankárank sospen mek ént yɨnkɨpea koropea mwaeaok yumwan kɨkɨp nánko te, yumo man éntér papea akwap kipo. ");
INSERT INTO yuj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aenepo maok, akwapea nap mek yoump nánko, yumo nap naropwarén turunkrá arakrá sér kip: ‘Tisa sérrá, “Onoku éréképá yárak i konamp fákárerént Pasova fánanamp nap aokore te maen?”rá séri námpo.’ ");
INSERT INTO yuj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aerá sénepo maok, yumwan nap aokore tokwae narekamp yénkép nánko maok, am mek te tankáp i konap ankank wae nánapi tank námpon. Yumo am mek fɨr nánap kipo.” ");
INSERT INTO yuj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aeránko maok, am arop yaworao akwapea am taun mek Jisaso sérimpaok nkea maok, am mek fɨr nánap. ");
INSERT INTO yuj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kumuran Jisas námoku éréképá yárak i konámp arop éréképea mént korop. ");
INSERT INTO yuj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aeaka am fárákap fépérrá tankáprá maok, Jisaso sérrá, “Ono te yumwan waeman kare kar sénampon: Yumo ou mekamp arop ankárankamp onan yopor aropamp yaek pap naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aeránko maok, am námoku éréképá yárak i konámp arop fárákap támao yonkwae touweria maok, man ankákárankrá turunkup, ‘Ae te amo onan sérri kwapon’rá sér. ");
INSERT INTO yuj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aerapo maok, Jisaso am fárákapan sérrá, “Am arop te yumo éntér-sámpramp ou mekamp ankárankamp pan sámpea onont dis mekamp sup mek anámpea fánámp támaono. ");
INSERT INTO yuj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kare, Aropamp Táráp te Kwaromp Buk fek sénámp niamp ankár takrá sumpwi naenámpon. Aeno am arop Aropamp Tárápan yopor aropamp yaek papnámp aropao maok koupouteane! Man éntupwaro fárákap te wampwe mpupo!” ");
INSERT INTO yuj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Am fárákapao fɨr fépérrá tankápapo maok, Jisaso pan ankárank sámpea Kwarén ‘Aesio’rá séria maok, fékéria am fárákapan nénkria sérrá, “Máte onomp pourouno. Má sámpea fárenke.” ");
INSERT INTO yuj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Aeaka warko wain éntráp kap sámpria Kwarén ‘Aesio’rá séria maok, am fárákapan nénkria maok, ");
INSERT INTO yuj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","am fárákapan sérrá, “Máte onomp yɨri yumont kontrak wourékam yoro nampon. Ono kápae kare koumteouráp aropan yaewourria kwarákár nanampon. ");
INSERT INTO yuj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ono yumwan waeman kare kar sér rae: Ono te warko wain fár morá akwapea, Kwaro náráp firáp taokeyaknámp mek wourékam wain ént fánanampon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Takia pwarará, am fárákapao tár kar ankárank sámpea pwarará maok, taun pwarará Oliv faonkwek pok. ");
INSERT INTO yuj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisaso am fárákapan sérrá, “Yumo ponankor te onan mérnap pwararea pɨrɨkɨmp mwarea napono. Kwaromp Buk fek am táman sérrá, ‘Ono sipsip taokeyak konámp arop porokwap pap nanko, maomp sipsip pɨrɨkɨmp mwanapon.’ ");
INSERT INTO yuj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Aeno ono te warko fárámpea yiki yakria, ononkɨr yumwan mekia Galili mek akwap nanampon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita sérrá, “Arop ankwap fárákap amwan pwarará pɨrɨkɨmp napo kor, wampweno. Ono mwar amwan pwar nanamp mono.” ");
INSERT INTO yuj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tá Jisaso man sérrá, “Ono amwan kare sér rae: Oukoumwan kumuruk kakaruk oukoumwan anánk por aráp mo nánko, amo yinɨnk por ‘Ono te man mér mono’rá sénanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Aerámpan maok, Pita ankár kar kárákáre fek sérrá, “Wampweno! Ono ankár amont sumpwi naeria te, ono amwan ‘Mér mo namp’rá sér mo kareno!” Tá mént paokop i konap arop ponankor takrá sérar. ");
INSERT INTO yuj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aea maok, am fárákapao tukupea oliv pékri Getsemani mekria maok, Jisaso námoku éréképea yárakinámp arop fárákapan sérrá, “Yumo mapek yakápenke. Ono akwapea Kwarén kar toropwap nae.” ");
INSERT INTO yuj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aeritea maok, Pita, Jems, Jon man éréképea am yinɨnkaopwe támao mént tukup. Aeapo maok, Jisaso náráp pourouk korop naenámp touwe tokwae wakmwaek sámp naenámpan yonkwae sakápria yonkwae touwea wae. ");
INSERT INTO yuj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aeria maok, mao am fárákapan sérrá, “Ono yonkwae touwea waeria, wae sumpwi nanamp pourouiane. Yumo mapek yakáprá yérékenke.” ");
INSERT INTO yuj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aeria mao yoump tae morokria mao éntér mwaeknámp apárok pɨká párákapea Kwarén kar toropwapria sérrá, “Amo onan korop naenámp ankank kwatae kwe-pwar nanap mwae kup yak nánko te, fwap kwe-pwar nanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aeritea maok, mao sérrá, “Ayao! Amo te ponankor ankank fwap tére nanapono. Aeno ono nɨk namp te, ono sámp nanamp touwe sámp-sɨraeria nampan maok, wampweno. Amo ankár amokuráp nɨnɨkaokampo.” ");
INSERT INTO yuj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Takia maok, warko akwapea am yinɨnkaopwean nke nánko, pampi yakáp. Aenapo, mao Pitan arakrá turunk, “Saimon, amo te amp rape? Amo ankárankamp ke fek saráp yérékrá yak nanap pourou mo nie? ");
INSERT INTO yuj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yumo ankár yérékria Kwarén kar toropwaprá yakápenke. Yumo am ankank korop nánko, pɨrɨkɨmp mwanape. Nɨnɨk te wae am tére naeria warákár námpan maok, pourourao kárákáre mono.” ");
INSERT INTO yuj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Warko akwapea manénkɨri námpnámp taknámp Kwarén kar toropwap. ");
INSERT INTO yuj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aea maok, warko arákarrá koropea námoku éréképá yárak i konámp arop fárákapan nke nánko maok, pampi yakáp. Am te apae riteanápe, am fárákapamp yi te ouwipi kápae. Aeapara, mao am fárákapan kékéménk námp fek te, am kar pwarokwaprá sér mwanap te mér mo napara, sér moiapon. ");
INSERT INTO yuj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jisas warko yinɨnkan akwapeaka koropea am fárákapan sérrá, “Yumo te oukoumwan pampria anepér rape? Wae támaono. Fápárámpea nkenke! Oukoumwan te Aropamp Tárápan kwatae nɨnɨkráp aropamp yaek sánk mwanap ke wae koropáne. ");
INSERT INTO yuj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yumo fárámp napo tukup mwaro. Nkenke! Onan outɨrinámp arop wae koropáne.” ");
INSERT INTO yuj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas kar sérrá yak nánko maok, táte am éréképá yárak i konámp arop éntér-sámpramp arop ou mekamp ankwap ankárankamp Judaso korop. Aenánko, pris tokwae fákáre, tá lo yénkrá farákáp konap arop, tá Juda taokeyakápnap arop fárákapao tirá kérépnap arop kápae kare, bainatráp yaopwae tia Judasén éntér kákrá korop. ");
INSERT INTO yuj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Manénkɨr am outɨrinámp arop am arop fárákapan arakrá sér: “Nánkár ono akwapea nouroupria aop mukur namp te, am arop te Jisas támaonon. Yumo man sámpea maok, fwapia taokeyakea sámpá tukup kip.” ");
INSERT INTO yuj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aeritea maok, Judas koupour kar akwapea Jisasonámpokria te, ‘Tisa’rá séria man koupwiyakrá aop mukur. ");
INSERT INTO yuj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aenánko maok, am fárákap wae Jisasomp pourouk yae paprá sámp. ");
INSERT INTO yuj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aeapo maok, arop ankwap ankárank bainat sámprá pris taokeyak konámp aropamp tére aropan woupwi kor karámpá aop-sɨr. ");
INSERT INTO yuj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jisaso am fárákapan sérrá, “Yumo onan sámp mwaria korop nap te, oukunria yorowar i konámp aropan sámp mwaria ni konap niamp bainat, yaopwae makia tia korop rape? ");
INSERT INTO yuj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wokwaek ono yumwan lotu nap mek kar farákáp saráp yak konamp fek onan sámp mwarap tane apaeapon? Yumo mámá nap te wokwaek Kwaromp Buk fek kumwiap karao kare koropanoria napon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aerá séránko maok, Jisasént paokop i konap arop fákáre man pwarará pɨrɨkɨmpea tukup. ");
INSERT INTO yuj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Arop tár-ménki ankárank Jisasomp wakmwaek koropámp, mao te waempyam wupwi kor mwar woukwapeanámpao, am fárákapao man sámpria maok, waempyam fek saráp sámp napo maok, ");
INSERT INTO yuj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mao waempyam wor-sɨrarrá pourou mwar farákapá akwap. ");
INSERT INTO yuj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Am fárákapao Jisasén sámpea pris taokeyak konámp aropamp nap mek santukup. Tá pris tokwae ponankor, Juda taokeyakáp konap arop, lo yénkrá farákáp konap arop makia koupoukour yakáp. ");
INSERT INTO yuj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita te Jisasomp wakmwaek akwap námpao maok, mao panek tae morok yak. Mao pris taokeyak konámp aropamp naepik yár éntér mek lotu nap tokwae taokeyakáprá yérék i konap plisman fákárerént yaomwi fek pourou yirɨnkrá yak. ");
INSERT INTO yuj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pris tokwae fákáre ntia kaunsil fákáre ponankor, arop ankwap fárákapan ‘Koropea Jisasoinámp kar farákápenk’ ria wumwi. Aenapan maok, am fárákap te maoinámp kwatae nɨnɨk nkea am fek sumpwi pap mwaria oupourounkapao maok, mao am fek sumpwi naenámp kwatae nɨnɨk nke mono. ");
INSERT INTO yuj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aeapo maok, táte kápae kare arop man kwekárrá sérapan maok, am fárákapamp kar te ankárankamp pourouráp mo. ");
INSERT INTO yuj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aeapo ankwap fárákap yakápia ‘Jisaso araki námpono’rá kwekária sér, ");
INSERT INTO yuj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yino wa nánko, mao sérrá, ‘Ono lotu nap tokwae aropao ti nap te, ono párámpeaka yinɨnk kumur fek ono ankwap pourouráp nap ti nanampan maok, arop yae kor fek ti mono’rá sérimpon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tá am kar sérar napao kor ankár épépérépi akwapria ankárankamp pourouráp moimpon. ");
INSERT INTO yuj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aeapo maok, pris taokeyak konámp arop kaunsil fákáreamp yik fokopeyakrá Jisasén arakrá turunk, “Amo te kar pwarokwaprá sénanap kar mo nie? Amwan mámá kar sérarap te mokopono?” ");
INSERT INTO yuj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aeránko maok, Jisaso kor man kar tákaprá sér mo. Aenko maok, pris taokeyak konámp arop man warko turunkrá, “Amo te arop ponankor lotu i konap Kwaromp Táráp Krais támao ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisaso sérrá, “Am te ono támaono. Nánkár Aropamp Táráp ponankor kárákáre tokwaeráp Kwaromp yae-párák mwaek tankea yámar mekamp koumwe yumuntuk ék nánko nke mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aeránko maok, pris taokeyak konámp arop am kar wawia korokopria yopor yonkwae pwarámpria, námokuráp pouroukamp waempyam pearákapria maok, sérrá, “Nomo wae táman wa námp te, warko apaerá arop ankwap wumwi mwanámpon? ");
INSERT INTO yuj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yumo wae wa napo, mao Kwarén wouroump sénámpon. Yumo nomo man te mokop mwanámprá nɨnɨk rape?” Aeránko maok, am arop fárákapao ponankor sérrá, “Mao te kwatae nɨnɨki tenámpara, ankár sumpwiano.” ");
INSERT INTO yuj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aerapo maok, arop ankwap fárákapao man atatopria maok, táte waempyam sámprá yimetápok woukoupea fákeyakáprá man porokwapria sérrá, “Amo oukoumwan profet kar fek sérae: Oukoumwan amwan te wa porokwapriane?” Aeria maok, lotu nap taokeyakáprá yérék i konap plisman fákáre yae faeran sámprá tárapore. ");
INSERT INTO yuj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita te ek yár éntér mek yakánko maok, tá pris taokeyak konámp aropamp tére konámp yupu ankárank koropea ");
INSERT INTO yuj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","nke nánko maok, Pita yaomwi fek tank. Aenánko maok, yupurao man tokor kari yakrá arakrá sér, “Amo kor wae Nasaret mekamp Jisasént yak konapon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aerámpan maok, Pita monoria arakrá sér, “Mono! Ono te amo sénap kar am te mér mo kare nampon!” Makri pwarará oukur tará ek youmprá nap ménki fek nánko maok, kakaruk ankárank aráp. ");
INSERT INTO yuj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aenko am tére konámp yupurao kor warko man nkea maok, wonae fik am fek yakápap arop fárákapan sérrá, “Mámá arop máte wae am fi támaonono.” ");
INSERT INTO yuj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tá Pita warko sérrá, “Mono!” Aeránko maok, wakmwaek arop ankwap fárákap wonae fik am fek yakáp napao sérrá, “Wɨ! Amo te waeman am fi támaono. Waráp kar te Galili mekamp aropamp kar niamp napono.” ");
INSERT INTO yuj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tá Pita kar arakrá sér, “Ono te yumwan waeman narekampráp kare kar sér rae: Ono am yumo sénap arop te mér mo nampon. Táte ono kwekár sénanko te, Kwaro onan kwatae pap naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Takrá séri pwar nánko maok, koupour kar kakaruk anánk por aráp. Aenánko maok, Pita warko Jisaso sérimp kar nɨk: “Nánkár kakaruk oukoumwan anánk por fárámp mo námp fek, amo yinɨnk por ‘Ono te man mér mono’rá sénanapono.” Aeria maok, Pita aropompria éma waempon. ");
INSERT INTO yuj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Koumounek kar pris tokwae fákáre ntia Juda taokeyak konap arop fákáre, tá lo yénkrá farákáp konap arop fákáre, tá ponankor kaunsil fákáre makia maok, koupoukarrá am mwanap kar pap. Takia pwarará, wakmwaek Jisasén sámpea yaek sen fek yarokwapea santukupea, Rom mekamp arop érékép-tank konámp gavman Pailatonámpok santukup. ");
INSERT INTO yuj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Aeapo maok, Pailato man turunkrá, “Amo Juda firamp king nie?” Aerá séránko maok, Jisaso maomp kar pwarokwaprá maok, “Wae amoku sénap támaono.” ");
INSERT INTO yuj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Aeránko maok, pris tokwae fákárerao Jisas tak moimp karan kwekárrá nkwakwe make kar farákáp. ");
INSERT INTO yuj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aeapo maok, Pailato man warko turunkria maok, “Amo wa napo, amwan kápae kare kar sénap máte, nopok kor ankwap kar sér mo nie?” ");
INSERT INTO yuj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aeránko maok, Jisaso kor ankwap kar pwarokwaprá sér mo nánko maok, Pailat nɨnɨk tokwae. ");
INSERT INTO yuj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yopwar méntép Pasova fári konap yae fek Pailato fákapá yaknámp arop ankárank aokorop pwar konámp. Am te koumteouráp aropao arop ankárank fákapá yak námp maomp e sénapo, Pailato am arop aokorop-pwar konámpon. ");
INSERT INTO yuj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Am ke fek te arop ankwap gavmanén yorowaria arop sumpwi yénképia napo, gavman am fárákap fápákamánkia kák tenapo, yakáp napon. Am ou mek arop ankárankamp maomp e te Barabas. ");
INSERT INTO yuj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aeria maok, am koumteouráp aropao kor Pailatén ‘Wokwaek i konámpnámp taknámp, arop kalabus mekamp ankárank sámp-kérépae’rá sér. ");
INSERT INTO yuj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aerapo maok, Pailato nopok am fárákapan arakrá turunk, “Yumo te ono yumo Judamp king, man sámp-kérépenkria nape?” Am takrá turunk námp te apae riteanápe, Pailato wae mér, ");
INSERT INTO yuj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","pris tokwae fákárerao Jisasén párák kokwarokria warámpá korop tenapantá. ");
INSERT INTO yuj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aenámpan maok, pris tokwae fákáre koumteouráp aropan, takrá sérenkria fopwaoka wae napo maok, am fárákapao Pailatén ‘Amo Jisasén te sámp-kérép kwapono. Barabasén sámp-kérépae’ ria wae. ");
INSERT INTO yuj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aerapo maok, Pailato warko turunkrá, “Yiráp nɨnɨk te mámá arop yumo ‘Judamp king’ ri konap man te mokopaeria nape?” ");
INSERT INTO yuj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aeránko maok, táte am fárákapao warko sérrá, “Yaopwae porokopramp fek pukupenke!” ");
INSERT INTO yuj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aerapo maok, Pailato am fárákapan sérrá, “Apae riteanono? Mao te apae kwatae nɨnɨki námpon?” Aerá turunkámpan maok, am fárákap ankár kárákárea waeria sérrá, “Yaopwae porokopramp fek pukupenke!” ");
INSERT INTO yuj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aerapo, Pailato am koumteouráp aropao warákáranáponoria Barabasén am arop fákáreaonapok sámp-kérép. Aeria mao sénánko, soldia Jisasén wip ain fekamp nil tokoropeyak námp fek am fek porokwapá pwarará maok, yaopwae porokopramp fek pukupenkria soldiamp yaek sánk. ");
INSERT INTO yuj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aenko am soldia fákárerao Jisasén warámp santukupea Rom mekamp kiap tokwaeramp nap népikria maok, soldia ponankor ‘Koropenk’ ria wumwi. ");
INSERT INTO yuj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Am fárákapao maomp waempyam worokwapea papria maok, kingo yirɨmp konámp niamp waempyam noumouri fek Jisasomp pourouk yirɨmp. Tá wiráp paok wi moukoupea kingo yirɨmp konámp kumpan wounáprá maomp me korok yirɨmpá pwar. ");
INSERT INTO yuj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Am soldia fákárerao wouroumpria sérrá, “Yo...! Juda firamp king e!” ");
INSERT INTO yuj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aeria maok, am fákárerao man yaopwae fek me korok fuk. Tá am fárákapao man atopria táman e tokwae sánk námpria wouroumprá maomp wonae fik kwaráp torokomp. ");
INSERT INTO yuj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Am fákárerao man wouroumpea pwarará, maomp pouroukamp waempyam noumouri worokwapea paprá, tá námokuráp waempyam am yirɨmpea maok, man yaopwae porokopramp fek pukup mwaria taun younkwek santukup. ");
INSERT INTO yuj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Aleksander ntiaka Rufusomp naropwar Saimon Sairini meknámp koropeaka, taun mek akwap naerianánko maok, táte am fákárerao man, Jisasomp yaopwae porokopramp sámpaeria kárákáre. ");
INSERT INTO yuj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Am fárákapao Jisasén santukupea faonkwek Golgota mek. Am faonkwe e fi te ‘Arop Me Kor Yaknámp Apár’rá sér i konapon. ");
INSERT INTO yuj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Arop ankwapao Jisasén wain ntiaka touwe námpare yak naenámp marasin mént ouroukoupea sánk mwaria napo maok, Jisaso fár mo. ");
INSERT INTO yuj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Am soldia fákárerao Jisasén yaopwae porokopramp fek pukupia pwatea maok, yakáprá satu pilairiaka, wa mokop kárákáreaka am waempyam ankank tianrá nke mwaria. ");
INSERT INTO yuj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Man yaopwae porokopramp fek koumounek sárakok ke námp fek pukupapono. ");
INSERT INTO yuj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aetea maok, narek me kor yarápae fek arop am fek kotia pukupnap kar kumwiria maok, arakrá sér: Juda Firamp Kingono. ");
INSERT INTO yuj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aetea arop yorowaria ankank pouroukoupnep arop anánkaopwe wonae fik am fek ankwapan yae-párák mwaek, ankwapan yae-mánkwan mwaekia pukupapono. ");
INSERT INTO yuj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Aeapara Kwaromp Buk fekamp kar ankárankamp yak námp máte oukoumwan te kare karono. Am kar te arakrá sénámpon: ‘Aropao man kwatae nɨnɨkinámp aropént koumpá pwar napon.’ ");
INSERT INTO yuj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aetea maok, koumteouráp arop fákárerao mwaeaok tukup koroprá man wouroump-sérria maok, “Amo, lotu nap tokwae soumpouriaka yinɨnk yae fek warko ti nanamp ri konap aropao nap. ");
INSERT INTO yuj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Oukoumwan te amoku támao yaewouria yaopwae porokopramp pwarará ékae!” ");
INSERT INTO yuj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tá pris tokwae fákáre, lo yénkrá farákáp konap arop fákárerao kor man wouroump. Námoku támao sérarrá arakrá sér, “Mao te wokwaek fikamp aropan yaewouri námpao maok, námoku te yaewour naenámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mao te Krais, Israel firamp kingao námp kwamp te, yaopwae porokopramp am pwarará ék nánko, nomo man nkeaka man te Krais karenorá mér mwaro.” Tá arop yawor Jisasént yaopwae porokopramp fek pukup napao kor man wouroumpepono. ");
INSERT INTO yuj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yámar kukkwaraokánko, kumur niamp kɨrɨkɨp tokwae kar apár ponankor oupouroupeyakrá akwapea 3 kilok. ");
INSERT INTO yuj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Aenko am ke fek táman Jisas tékén arakrá wumwi, “Eloi, Eloi, lama sabaktani?” Makrá sérimp te arak: “Onomp Kwar e, onomp Kwar e, amo onan apaerá pwararape?” ");
INSERT INTO yuj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aeránko arop ankwap fárákap wonae fik am fek yakáp nap wawia maok, sérrá, “Wawenke! Mao te Elaijan wumwi námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aerapo maok, arop ankwap ankárankamp fárakoprá akwapea yao yir niamp fek top i konámp wain ént mek anámpeaka Jisaso fáranoria yaopwae fek norokarea sánk. Aeria maok, am aropao sérrá, “Nomo yépékrá yakáp mwaro. Elaija te koropea aokoropea sámpék ni mokopon nke mwaro.” ");
INSERT INTO yuj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aeapo maok, Jisaso tékén fépéna waeria maok, wae worokor. ");
INSERT INTO yuj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Aenánko maok, Jisas worokorámp ke fek te, waempyam tokwae lotu nap tokwae mekamp aokore kuk mek ménki fek nánkáráp tariap te nareknámpiaka pearákarrá ékia fu fek por-pwar nánko maok, am waempyam anánk mwaek peari yak. ");
INSERT INTO yuj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tá soldia fi éréképá yak konámp kepteno Jisas yakámp fek wonae fik fokopeyakea Jisas worokor námp nkea arakrá sér, “Kare karono. Mámá arop máte Kwaromp Tárápono!” ");
INSERT INTO yuj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Koumteou ankwap fárákapao kor panek tae morok yakáprá maok, yérépékrá yakáp. Ankwap ankárank maomp e te Magdala mekamp Maria, ankwap te Maria, nánae Jems ntiaka Josesomp éntupwar, tá ankwap te Salome. ");
INSERT INTO yuj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Am koumteou te Jisas wokwaek Galili mek yakámp ke fek maomp wakmwaek tukuprá man yaewouriapono. Tá Jisas Jerusalem mek koropánko, koumteou kápae kare mént tapokwapea koropap fek, mao kuri am fek yakápiapon. ");
INSERT INTO yuj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Kumuran taun Arimatea mekamp Josep korop. Mao te Kaunsil ankwap koumteouráp arop nke nap fek e kwapweráp arop, tá mao kor Kwaro náráp firáp taokeyak naenámp keantá yépékrá yak konámp. Oumpouran te anepér i konap yae ara, oukoumwan te ankank nánapnap yaenon. Aeria maok, Josep te Pailatén nkea apáp mono, youmpea maok, man sérrá, “Ono te Jisasomp yákáre sámpá akwapá pap nae rae.” ");
INSERT INTO yuj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Aeránko maok, Pailato nɨnɨk tokwaeria maok, man sérrá, “Mao te wae sumpwi námp nie?” Aeria maok, keptenén koropae ritea man turunkrá, “Jisas te wae sumpwi námp nie?” ");
INSERT INTO yuj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mao wae keptenomp kar wawia, Josepén sérrá, “Amo akwapea am yákáre sámpae.” ");
INSERT INTO yuj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aeránko maok, Josepo akwapeaka waempyam wupwi mani fek sámpea maok, tá akwapea narekamp Jisasomp yákáre sámpá ékia am waempyam wupwi fek papea yarokwap. Aea sakwapea péri me wokwaek yoroiap me mek papria maok, Josepo péri kárakére tokwae fáparákarrá youmpea péri me táp fek woukoupá pwar. ");
INSERT INTO yuj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aenko Makdala mekamp Maria ntia Josesomp éntupwar Maria am anánkaopwerao Jisasén pap nap wae nkea méri pwarará akwap. ");
INSERT INTO yuj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Anepér i konap Sabat yae pwar nánko maok, Makdala mekamp Maria ntiaka Jemsomp éntupwar Maria, tá Salome, makia am fárákapao welráp nánákáre konámp ankank mani fek tia Jisasomp yákáre koupour mákáreantá forokwapá pap mwanámpria nánapia pátea pamp. ");
INSERT INTO yuj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pampia maok, koumounek kar Sande fek am ankank tiaka péri kor me fek tukup. ");
INSERT INTO yuj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tukupria maok, námoku am fárákap támao sérarrá tukuprá, “Wa mokop nomwan yaewouria am péri kor me táp fekamp péri kárakére tokwae kɨkɨpia far-farrá akwap naenámpon?” ");
INSERT INTO yuj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aeritea am fárákapao nkeapo maok, am péri kor me táp fekamp te yak mo. Am me táp fekamp ér-sayoumpea aop mwaek pwate. Am péri kor worare te yoporop tokwae kar. ");
INSERT INTO yuj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aenko am fárákapao péri kor me mek yinkea nkeapo maok, arop tár-ménki waempyam wupwi éri yirɨmpea, yae-párák mwaek tankánko maok, am fárákapao nkerá paokoprá kokorokor. ");
INSERT INTO yuj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aeapo maok, mao am fárákapan sérrá, “Yumo te kokorokori kwapon! Ono wae mérampon, yumo te Nasaret mekamp Jisasén yaopwae porokopramp fek pukup nap táman oupourounkrá korop napon. Mao te wae fárámp tenámpon. Mao te mapek yak mono. Man papap yowae má nkenke. ");
INSERT INTO yuj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yumo tukupeaka maomp arop fákáreran séraria maok, Pitan kor sér kip, ‘Jisas te wae manénkɨr Galili mek mekia akwap naenámpon. Aenánko, yumo te mao wokwaek yumwan sérimpnámp taknámp ampok man nke mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aeránko maok, am koumteouao kor péri kor me meknámp ek ouroumpá mankrá apápria kour me woukour riaka pɨrɨkɨmpea tukupria maok, arop ankárankan kar sér mo. ");
INSERT INTO yuj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas yae ankárank Sande fek koumounek kar fárámpámpon. Aea maok, manénkɨr te, mao akwapea Makdala mekamp Marian kɨkɨpimpon. Am yupu te wokwaek kar kwatae-arop fákánekao maomp pourouk woukouri yakápánko, Jisaso yéréperá kérépámp yupunono. ");
INSERT INTO yuj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria akwapea am Jisasént wokwaek paokopiap arop fákáreran sénaeria nke nánko maok, am arop fárákapao kor Jisasén yonkwae touweria maok, éménkrá yakáp. ");
INSERT INTO yuj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yakápapo maok, am fárákapan sérrá, “Ono nke nanko, Jisas te yiki yak námpono!” Aerá séránko maok, am fárákap wa napao maok, kare karonorá nɨnɨk mo. ");
INSERT INTO yuj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nánkár wakmwaek Jisasént paokopiap arop anánkaopwerao taun pwarará akwapepo maok, Jisas arop ankwap niampia akwapea am arop yaworan mwaeaok kɨkɨp. ");
INSERT INTO yuj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Aenko maok, am arop yaworao kor akwapea Jisasént paokop i konap arop ankwap fárákapan am kar fárákapepo maok, am fárákapao kor am arop yaworamp kar wawia karenorá mér mo. ");
INSERT INTO yuj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wakmwaek Jisasént paokop i konap mom-sámprampao tankáprá fépérapo maok, Jisaso maonapok akwap. Am fárákap te koumteouráp aropao ‘Jisas te warko fárámp nánko nke námpono’rá sénapan maok, mao te karenorá nɨnɨkia mér mo. Aenapantá maok, Jisaso am fárákapan yoporimpon. ");
INSERT INTO yuj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aeria maok, mao am fárákapan arakrá sér, “Yumo tukupea apár-apár ponankor Kwaromp Kwapwe Kare Kar ponankor aropan farákáp kipo. ");
INSERT INTO yuj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aenapo, arop Kwarén mériaka, ént mek anámp námp te, Kwaro man warko warámp naerámpon. Aeno arop man mér mo námp te, kotia yaomwi mek pɨk naerámpon. ");
INSERT INTO yuj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kwar te arop man mér nánko te, maomp kárákáre am aropamp yaek puiyakrá náráp kárákáre yororo naenámpon. Tá maomp e fek kwatae-arop yéréperá kérép, tá ankwap-ankwap wourékam kar farákáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Am fárákapao fou-tákam fwap yae fek sámp mwarea napon. Tá arop sumpwi pap konap fou fánapao kor, sumpwi mo, fwapono. Tá am fárákap touwenap aropan kor pourouk yae pap napo, am touwe fwap naeria námpon.” ");
INSERT INTO yuj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jisas Tokwae Karao Kwaromp kar am fárákapan farákápea pwar nánko, Kwaro yámar mek man sámpea pok. Aenánko mao Kwaromp yae-párák mwaek tank námpono. ");
INSERT INTO yuj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aenko mént paokopiap aropao tukupea, ponankor apár mek Kwaromp kar farákáp. Aenapo, Tokwae Kar am fárákapént téreria, mao farákápnap kar kare karonorá yénképnámp kárákáre yororoimpono. ");
INSERT INTO yuj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Tiofilus, arop taokeyak konap arop tokwae e! Kwaro nkwakwe make ankank yino yakáp námp mekmékɨr térempan, arop ankwap fárákapao am ankankan wokwaekia koropea oukoumwan nkeaka, arop kápae kareran Kwaromp Kar érik farákápriaka yinan kor am ankankan farákáp napon. Aerapo, kápae kare aropao am fek nɨnɨk tokwaeaka, ono kumwi naerá nɨnɨkia, am ankank ponankor kumwi napao maok, oukoumwan pwi kari yak mono. Aenámpantá, ono wokwaek, am ankank kápae kare fi kare mokoponrá mér naeria fwapnae karia turunkwapia, oukoumwan ono fwapokwapia kumwi namp te wokwaek kar koropámp niamp pourourápono. Aempan ono má kar waráp por kumwi nampono. ");
INSERT INTO yuj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Amo mámá kar nkea amwan wokwaek farákápap kar, am te kare karonorá mér nanapon. ");
INSERT INTO yuj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Heroto apár Judiamp king yakámp fek, pris yakámp arop e te Sekaraia. Mao te ounáp Abaija fekamp pris fi yak námpono. Maomp yupu te pris taokeyaknámp arop Aron yakámp fi mekamp. Maomp e te Elisabet. ");
INSERT INTO yuj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Am anánkwap te Kwaro nkemp fek te yae-párák kare yak. Aeria maok, Kwar Tokwaeramp ponankor loaok, tá Kwaromp ponankor karwaok yárak nepara, mao nke námp fek kwatae nɨnɨk nep yak mono. ");
INSERT INTO yuj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aenámpao maok, Elisabet te mapo yakámpara, am anánkwap te táráp sámp mo, yakeaka wae tékénou. ");
INSERT INTO yuj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pris tére konap arop fákáre koropea maok, Sekaraia kor Kwaro nke námp fek pris tére. ");
INSERT INTO yuj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Am fárákap wa mokop Kwaromp Nap Aokore Yiki Kor mek tére naenámpaoean nke mwaria satu pilai. Takria maok, Sekaraian ‘Oukoumwan te amo tére nanap kenono’rá sérapo maok, Sekaraia wae lotu nap tokwae Aokore Yiki Kor mek youmpea, am aokore mek Kwar Tokwaerampor paura nánákáre yankap naeria. ");
INSERT INTO yuj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Paura nánákáre yankap naenámp ke fek kápae kare arop koropea apárok néntépá yakápria Kwarén kar toropwaprá yakápapo maok, Sekaraia paura nánákáre alta fek yankap naeria youmpea nke nánko maok, ");
INSERT INTO yuj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","alta yak námp fek Kwar Tokwaeramp ensel yae-párák mwaek am fek fokopeyakánko, ");
INSERT INTO yuj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","nkea korokopea apápimp. ");
INSERT INTO yuj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aenánko maok, enselo Sekaraian sérrá, “Sekaraia, amo apápi kwapono. Kwar te amo táráp sápaeria toropwapnap kar te wae wawi námpono. Waráp yupu Elisabet te poumou-táráp sámpeanánko maok, amo maomp e tákapria te ‘Jon’ ri papampo. ");
INSERT INTO yuj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nánkár am táráp tankeanánko, amoku kor yonkwae kárámpriaka warákár napo maok, fikamp arop kápae kare am korop námp táman nkeaka warákár mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mao oukoumwan éntupwaromp yare mek yak námp fek Yiki Kor Spiritao maomp pourouk woukoupá yak naenámpon. Am feknámpia ankár takrá akwapea, mao Kwaro nke námp fek Kwaromp arop tokwae kwapwe yak naenámpara, wain ént ntia mánmán ént ankwap fár mo. ");
INSERT INTO yuj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mao Kwaromp kar farákáp nánko, Israel fi mekamp arop kápae kare wawiaka warko náráp Kwar Tokwaeraonámpok arári korop mwanapono. ");
INSERT INTO yuj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mao te Elaijamp nɨnɨk ntia kárákáre niamp sámpeaka Tokwae Kar wakmwaek korop naenámp fek mekia akwap naenámpon. ‘Naropwaryaenáp ntia tárápu nonopok ankárankamp nɨnɨk fek yakáp kip’rá sénaenámpon. Tá mao kar ták-sɨr konap aropamp nɨnɨk fwapokwap nánko, yae-párák kare aropamp nɨnɨk kwapwe sámp mwanapon. Takria mao arop fárákapan nánaprá párakop nánko, am fárákap Tokwae Karao korop naenámp nánaprá yakáp mwanapon.” Am enselo arakrá sérimpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraia enselén turunkrá, “Ono wae mér pourou, onomp yupurao kor waeman énénkér mér pourou nemp tane, ono te mokopia am kar karenorá mér nanampon?” ");
INSERT INTO yuj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aeránko maok, enselo sérrá, “Ono Kwarént yak konamp Gebrielono. Kwar námoku onan amwan, má kar kwapwe farákápaeria sámp-kérép nánko, ono ékiaka sénampono. ");
INSERT INTO yuj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aeno amo onomp kar wawia ‘Kareno’rá sér mo napo te, waráp top kor kéri yak nánko, amo te kar sér mono, akwapeaka ono má sénamp ankank koropnámp ke fek warko waráp top kor fwap naenámpon. Ono sénamp kar máte kare kar tak naenámpan sénampono.” ");
INSERT INTO yuj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Koumteouráp arop Sekaraian yépékrá yakáprá nɨnɨkrá, “Máte apae ankank korop nánko, mao Nap Aokore Yiki Kor mek youmpea am mek youpoukwap yakreane?” ");
INSERT INTO yuj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Makrá yakáp napo, Sekaraia am meknámp mank nánko, nkeapo maok, kar sér mo, yae fek saráp yénkánko, nkea méria maok, “Mao te Nap Aokore Yiki Kor mek mwar pourouráp ankank nkea karane! Top kor kéri yak námpono!” ");
INSERT INTO yuj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wakmwaek Sekaraia pris tére térea pwarará námokuráp némpouk akwap. ");
INSERT INTO yuj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aenko maok, maomp yupu Elisabet te wae táráp yororia maok, éntik yunk te érik yárak mo, nap mek saráp yakrá nɨnɨkia arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ono wokwaek te mapo yak nanko, onan sérar napo, pwarápae tokwaeampan maok, Kwar Tokwaerao onan aropompria yaewourianánko, ono táráp yak namp te koumteouráp aropao nke nap fek te, ono pwarápae yak mono.” ");
INSERT INTO yuj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet táráp yak námp tokwampok yunk akwap tenánko, Kwaro ensel Gebrielén, apár Galili mekamp taun Nasaret mek akwapaeria sámp-kérép. ");
INSERT INTO yuj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mao yupu énki ankárankan kar farákáp naeria akwap. Am yupu e te Maria. Mao Josepomp nap mek tank naenámpria kar yoroi tariap. Am Josep te King Devit yakámp fi mekampono. ");
INSERT INTO yuj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gebrielo maonámpok akwapea sérrá, “Ae! Maria! Tokwae Karao amwan nkea warákárriaka, amont yak námpono.” ");
INSERT INTO yuj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria am kar wará yárakrá nɨnɨk tokwae. Aeriaka, “Onan te apaerá sériane? Am te mokop naenámp karaniane?” ");
INSERT INTO yuj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aeránko maok, enselo sérrá, “Maria, amo te apápi kwapono. Kwaromp nɨnɨk te amwan warákár námpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Amo wawae! Amo wakmwaek te poumou-táráp yakeaka tank nanapono. Amo maomp e tákapria te ‘Jisas’ ri papampo. ");
INSERT INTO yuj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mao te arop éréképea tank naenámpon. Aeriaka man nɨnɨkria sérarrá: ‘Mao te yámar mekamp Kwar Kárákáre Koramp Tárápono’rá sér mwanapon. Aenapo maok, Kwar Tokwaerao man maomp ounáp Deviténimpnámp taknámp Israelomp king yoroi pap naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mao te king yakriaka, Jekop yakámp fi éréképea yaká yakria maok, Am king yak námp te pwar mo, Ankár yaká yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria enselén sérrá, “Am te mokopia nanampono? Ono oukoumwan poumou nap mek tank mo namp tene.” ");
INSERT INTO yuj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aeránko maok, enselo maomp kar pwarokwaprá sérrá, “Yiki Kor Spiritao amonapok koropeanánko, yámar mekamp Kwaromp kárákáre tokwaerao waráp pourouk woukoupá yak naenámpon. Aenánko maok, wakmwaek amo am táráp tank napo, Man am fákárerao nɨnɨkria sérrá, ‘Kwar Kárákáre Koramp Tárápono’rá sér mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ono amwan ankwap kar sénamp te wawae: Waráp ankwapwaráp Elisabeto kor wae mér pourou námpao maok, mao kor poumou-táráp yare mek yak námpono. Wokwaek kar aropao man sérarrá, ‘Mao te táráp sámp mo, mapo yak námpono’ riapan maok, oukoumwan te wae táráp yare mek yak nánko, tokwampok yunki yak námpono. ");
INSERT INTO yuj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwaro nkwakwe make ankank yoro naenámp te, man kour-sɨnaenámp kánanke yak mono. ");
INSERT INTO yuj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Enselo am séria pwaránko maok, Maria enselén sérrá, “Ono te Tokwae Karamp tére konamp yupu ara, mao amo onan sénapnámp taknámp tak naeria te fwap tak naenámpon.” Aerá séránko maok, enselo wae man pwarará akwapámpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Aenko maok, am ke fek táman Maria koupour taun Nasaret meknámp fárámprá apár Judia mek akwapea faonkwekamp némpouk ");
INSERT INTO yuj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sekaraiamp nap mek youmpea Elisabetén ‘Gude’ nánko maok, ");
INSERT INTO yuj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet te am kar wa nánko maok, táráp Elisabetomp yare mek kukur. Aenko maok, Yiki Kor Spiritao Elisabetomp nɨnɨk mek tokwae yakánko maok, ");
INSERT INTO yuj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabeto Marian tae fek sérrá, “Kwaro ankwap koumteouan yaewour nánko warákár konap te, oukoumwan amwan sánknámp warákár tokwae támao kámákár akwap námpono. Waráp yare mek yaknámp tárápao kor ourour tokwaerápono. ");
INSERT INTO yuj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ono te apae kwapwe nanko, onomp Kwar Tokwaeramp éntupwar koropea onan nkeriane? ");
INSERT INTO yuj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ono waráp kar wa nanko, onomp yare mek yaknámp táráp warákárria kukur námpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kwaro amwan sérinámp kar wawia kare korop naenámpria mér napara, warákárampo.” Elisabet Marian arakrá sérimpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","48","Aeránko maok, Maria sérrá, “Ono te párák Kwaromp tére konamp yupu kwataerao maok, mao námoku onan nɨnɨkia aropomp námpantá, ono te Tokwae Karan aesiorá fáparáka waeaka, onan warámpnámp Kwarén yonkwae kárámpria warákár nampon. Takia nanko maok, arop ponankor oukoumwania akwapea nánkárap kor Kwaro onan warákár tokwae sápnámp táman sérar mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yiki kor kwapweráp Kwar Kárákáre Tokwaerao onan yaewour tokwae kwapwe námpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mao éréképeanámp arop te ankár maomp karwaok tukupea napo, maomp tárápuao kor takrá tukupeaka, appeyaenápo kor ankár takrá tukup napo, Kwaromp aropomp am fárákapént yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Arop, yino wae mér námpria námokuráp nɨnɨk fek paokopiap aropan te Kwaro náráp kárákáre tokwae fek am fárákapan yéréperá kérép konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mao kárákáre kor king fárákapan apárok néri kákrá, párák yakápnap aropan kingén námp niamp yae-páráki kák námpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aea fákeyakrá yae-porokwenap aropan kwapwe kare ankank nénkria, ankank tokwaeráp arop fárákapan kwaporok tirá kérépámpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Mao nomp ouyaenápén sérimpnámp koropea náráp tére konap arop Israelén yaewouriaka, mao Abrahamén nɨkiaka aropompi námp te, koropea maomp appeyaenáp fárákapan kor ankár taki yak námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria arakrá séri pwarará Elisabetént yinɨnk yunk niamp arake fek yakeaka, wakmwaek warko náráp taun mek arákarrá akwapámp. ");
INSERT INTO yuj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet táráp tank naenámp ke korop nánko maok, mao wae poumou-tárápi tank. ");
INSERT INTO yuj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aenánko maok, Elisabetomp némpoukamp, maomp firáp arop, Tokwae Karao man aropompnámp kar wawia am fárákapao mént énénki warákáránk. ");
INSERT INTO yuj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Takia maok, yukupuk yae fek táman maok, am arop fárákapao am tárápan yɨpi fárákap mwaria, maomp naropwar e ‘Sekaraia’ ri pap mwaria koropapon. ");
INSERT INTO yuj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Aeapo maok, am tárápamp éntupwaro sérrá, “Mono. Yumo man te ‘Jon’ ri papenke.” ");
INSERT INTO yuj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aeránko man sérrá, “Mo. Waráp firáp arop te am eráp arop yak mono.” ");
INSERT INTO yuj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aea maok, takrá tukupea e mér mwaria naropwarén turunkria yae fek saráp yénkép. ");
INSERT INTO yuj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aeapo maok, maomp top kor oukoumwan kéri yak nánko, yae fek saráp yénképrá, ‘Yao kárakére sápenk’ ria maok, am fek kumwiria arakrá sér, “Maomp e te Jon nono.” Aeránko maok, am fárákapao nɨnɨk tokwae. ");
INSERT INTO yuj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aeapo maok, oukoumwan kar táman Sekaraia warko kar séria maok, Kwaromp e sakapámpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aenko maok, maomp népekamp arop nkerá kokorokor. Aeria maok, am kar te apár Judia mek you mekmwaekamp némp-némp akwapámpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ae naenko, arop ponankor am kar waria nɨnɨk tokwaeaka arakrá sér, “Wakmwaek am táráp te mokope arop yak naenámpono?” Am fárákap te wae mér, Tokwae Karamp kárákáre te mént yak námpono. ");
INSERT INTO yuj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aerapo maok, Yiki Kor Spiritao ékia maomp naropwar Sekaraiamp pourouk woukoupeyakánko maok, Sekaraia profet kar fek sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nomo Israelomp Kwar Tokwaeramp e sámpea sakap mwaro. Am te apaeria námpanápe mao náráp fi koumteouráp arop nomwan koropea yaewour riaka nomwan warko éréképea fwapia kák námpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kwaromp tére arop Devit yakámp fi mek kárákáre kor arop ankárankamp nomwan warko éréképanoria pap námpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kwaromp e tokwaeráp profet fákárerao maomp kar wariaka am táman sérrá: ");
INSERT INTO yuj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Mao te nomwan younkwe sɨrarrá yopornap arop fákáreramp yaekamp warko érékép naenámpono.’ ");
INSERT INTO yuj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Am takámp te, Kwar te nomp ouyaenápén aropompiaka yaewourimpon. Mao wokwaek kar ‘Yiráp por tak nanamp’rá sérimp kontrak kárákáre te oukoumwan nɨki-samp yak námpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mao nomp ounáp Abrahamén kare kar sérimp te, oukoumwan kor wokwaek sérimpnámp taknámp kare kar nomwan yaewour naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Mao te nomwan yopor aropamp yae kwae mekamp érékép námpara, nomo te apáp mono, ankár man loturá yakáp mwanámpono. ");
INSERT INTO yuj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nomo yiki yakápnámp ke fek ponankor mao nke námp fek, yiki kare nɨnɨk fek yae-párák kare térerá paokop mwanámpon.” Sekaraia Kwarén warákarea pwarará náráp tárápan sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Onomp táráp e! Wakmwaek te arop ponankor amwan ‘Narek Kari Yaknámp Kwaromp profet’rá sér mwanapon. Amo mekia akwapria Tokwae Karamp mwae nánap nanapon. ");
INSERT INTO yuj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Amo maomp koumteouráp arop fárákapan ‘Kwaro yiráp kwatae nɨnɨk tirá épéria, warko érékép naenámp’rá farákáp nanapon. ");
INSERT INTO yuj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kwaro nomwan yonkwae touweriaka porokwe kare fek i konámpon: Mao te yámar mekamp wakor wae nomonámpok sámp-kérép nánko, ");
INSERT INTO yuj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nomo kɨrɨkɨp mek yakápria sumpwi mwaria waenámp arop fárákap nomwan wae sáp námpon. Mao nomwan mwae yénkép nánko, nomo yae-párák yonkwae porokwe nɨnɨkaok tukup mwanámpon.” Sekaraia te am karan arakrá farákápámpon. ");
INSERT INTO yuj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wakmwaek am táráp téképria maok, maomp waemp wae kárákáreria nɨnɨk kour sámpea mao te apár mwar mek yakea, wakmwaek Israel fi nke mwanap fek érik korop naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Maria mao táráp tank naenámp ke fek maok, Rom mekamp King Sisar Ogastus lo papea sérrá, “Ono koumteouráp arop ponankor e ti nanampono.” ");
INSERT INTO yuj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mámá te manénkɨr kar oukoumwan e ti mo fek tiapono. Am ke fek te Kwirinius apár tokwae Siria mek kiap tokwae yoroi yakámp. ");
INSERT INTO yuj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aemantá maok, koumteouráp arop ponankor námokuráp némpouk e tianoria tukup. ");
INSERT INTO yuj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep te Devit yakámp fi mekampao námp kwamp maok, mao Galili mekamp mao yaknámp am taun Nasaret pwarará, Devitomp némpouk apár Judia mekamp taun Betlehem mek akwapámp. ");
INSERT INTO yuj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mao te náráp yupu Maria arop yarerápan, nomp e tianoria warámpea akwap. ");
INSERT INTO yuj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Am anánkwap am fek yakepo maok, Maria táráp tank naerianámp ke fek maok, Betlehem mek koropea nke nepo, arop néntép konap nap kápae te wae aropao pwi yak. Aemantá maok, Josep ntia Maria nap oupourounkrá akwapeaka bulmakaump nap mek am mek yak. Aenepo maok, Maria táráp tank naenámp ke fek maok, nae-táráp poumou-táráp tankea, waempyam fek yarokwapea bulmakau maonk pwae fári konap bokis mek am mek papámpon. ");
INSERT INTO yuj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Am taun Betlehem yarápae fek aop mwaek sipsip wun i konap aropao náráp sipsipantá kumuruk yérékrá yakápap. ");
INSERT INTO yuj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aenapo maok, Tokwae Karamp ensel maonapok koropánko maok, am fek táman Tokwae Karamp wae tokwae tákapá yak naenko maok, am aropao apáp tɨrɨnk. ");
INSERT INTO yuj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aeapo maok, am enselo am fárákapan sérrá, “Yumo te apápi kwapono. Wawenke! Ono yumwan kar kwapwe kare farákáprá korop nampono. Am tak namp te, arop ponankor warákár mwanapono. ");
INSERT INTO yuj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mámá yae fek táman Devitomp taun mek yupu ankárank táráp sámp námpono. Mao te yumwan warko érékép naenámp aropono. Mao te Krais Tokwae Karono. ");
INSERT INTO yuj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yumo te aran nkeaka mér kipo: Táráp waempyam mek papea yarokwapea bulmakaump maonk pwae fári konap bokis mek páte nánko amp námp aráne!” ");
INSERT INTO yuj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Enselo makrá séránko maok, koupour kar yámar mekamp ensel fopwakwap fopwakwap koropeaka, am enselént yakápria maok, Kwaromp e sakapria sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yámar mek tokwae narek karaok yaknámp Kwaromp e narek sampok mwaro! Kwaro warákárnámp apárokamp arop ankwap fárákapan man yonkwae porokwe sánk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Am ensel fákárerao am fárákapan pwarará warko yámar mek pokapo maok, sipsip wun i konap arop fárákapao arakrá sér, “Oukoumwan nomo Betlehem mek tukupea, Kwaro nomwan wae yénképnámp ankankan nke mwaro.” ");
INSERT INTO yuj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aeria maok, koupour tukupea nkeapo, Maria ntiaka Josep yakepo maok, táráp te bulmakau apwar pwae fépér i konap bokis mek amp. ");
INSERT INTO yuj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aenánko, am fárákapao am táráp nkeaka maok, enselo am tárápao naenámp tére sérinámp karan am mwaek yakápnap aropan farákápapono. ");
INSERT INTO yuj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aeapo maok, arop ponankor am sipsip wun i konap aropamp kar waria maok, kokorokoriap. ");
INSERT INTO yuj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aeno Maria námoku te am kar ankár ponankor nɨnɨk mek tia nɨki-samp yakámpon. ");
INSERT INTO yuj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Táte sipsip wunnap arop fárákap te am kápae kare ankank enselo séránko wawia nkeap táman, Kwarén warákárriaka náráp sipsip yakápnap mwaek arári tukupria Kwaromp e sakaprá tukupapon. ");
INSERT INTO yuj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Manénkɨr éntupwar oukoumwan arop yoro mo nánko, enselo Jisasomp e ták-papámpon. Aempan maok, wakmwaek éntupwaro am táráp tankeaka yukupuki yakeanánko maok, am tárápamp yɨpi fárákapea maok, man ‘Jisas’ ri papapon. ");
INSERT INTO yuj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Me koum sik Kwaro Mosesén kar sánkámp te ará, “Éntupwaryaenáp poumou-táráp nae-táráp sámp napo te, éntupwar naropwaro am táráp Kwarén sánk kipo.” Kwaromp Kar ankwap arakrá sér, “Yumo táráp tankea nap kwamp te, ant anánkaopwe Kwarén sánk mwanapono. Am mo nánko te, ant morok wourékam kánanke anánkaopwe sánk mwanapono.” Am loao sénámpnámp taknámp, éntupwar ntia táráp wae éntupia, am anánkwapao am lo karwaokrá Jerusalem mek akwapea táráp Kwarén sánkria, ant ofa sánkep. ");
INSERT INTO yuj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalem mek yaknámp arop mér, maomp e te Simeon. Am arop te yae-párák kareria Kwarén lotu i konámp. Aeria Israel firan warko érékép naenámp arop korop naeanrá yépékrá yak. Aenánko man te Yiki Kor Spiritao oupouroupá yakámpono. ");
INSERT INTO yuj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Am Yiki Kor Spiritao am aropan wokwaek kar sérrá, “Amo te oukoumwan sumpwi mo, yiki yakria Kraisén nke nanapono.” ");
INSERT INTO yuj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Táte Jisasomp éntupwar naropwar man sámpá koropea loao sénámpnámp taknámp Kwarén sánk neria Lotu Nap Tokwae mek koropepo maok, am Simeonén Kwaromp Yiki Kor Spiritao séránko, mao kor lotu nap tokwae mek youmpámp. ");
INSERT INTO yuj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Aeria maok, Simeono Jisas kakapea yaek sampeyakrá Kwaromp e sakapria sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","“Tokwae Kar e! Amo onan wokwaek sériapan am arop amo apárokamp arop érékép naenámpria sámp-kérép napo, ono wae nke nampono. Amo am arop te kápae kare arop fi nke nap fek wae nánapi pwar napono. Am arop te wae tokwae kwapwe ara, mao te apárokamp arop ankwap fi ponankoran yokoránko, am arop fi ponankor Kwaromp nɨnɨk mér mwanapon. Táte waráp wae waráp Israel firént yak nánko, arop ankwap firao nke nap fek kwapwe kare naenámpon. Makiaka ono waráp tére konamp arop fwap oukoumwan yonkwae porokwe fek sumpwi nanampono.” ");
INSERT INTO yuj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jisasomp éntupwar naropwar Simeon sénámp kar táman nɨnɨk tokwae nepo maok, ");
INSERT INTO yuj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Simeono am anánkwapan Kwar ourour sánkanoria Kwarén sériaka, Jisasomp éntupwar Marian arakrá sér, “Ae! Amo wawae. Kwaro mámá táráp nánapia sámp-kérép námp te, arop Israel ankwap fárákap maomp kar ták-sɨnap kwatae tukup napo, ankwap fárákap maomp kar wawia warákár nap te, am fárákapan kor éréképeanánko, yae-párák yakáp mwanapria ninámpon. Mao te érik fokopeyakrá yénkép nánko maok, kápae kare aropamp nɨnɨk mek yaknámp kwatae nɨnɨk érik farákár naenámpon. Amwan kor oumpnámp párákap nánko, yonkwae touwea wae nanapono.” ");
INSERT INTO yuj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Simeono am kar séria pwaránko maok, profet yupu ankwap yak námp, maomp e te Ana. Mao te Asa yakámp fi mekamp, Fanuelomp namom. Wokwaek te poumou nap mek tankea yakámp yopwar te fákánek yopwar. ");
INSERT INTO yuj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Wakmwaek poumarop sumpwi tenánko maok, kae yakrá koropea oukoumwan mao yaknámp yopwar ponankor te 84 yopwar. Aenámpara, wae mér kare. Mao te ankwap nɨnɨkaok mono, ankár, Kwarén yae-párák kar toropwap nanampria fɨr wuriria kápae kare por lotu nap tokwae mek akwap ko, kar toropwap i konámpono. Aeria maok, Kwaromp tére námp te ankár kumur yámar méntép tére saráp yak konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mao kor am ke fek Jisasomp wonae fik korop riaka, Kwarén ‘Aesio’rá sérimpono. Mao te Kwaro Jerusalem mekamp arop fárákapan warko érékép naenámpria yépékrá yakápnap arop fárákapan am tárápao korop námpan farákápámpono. ");
INSERT INTO yuj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aenánko maok, am anánkwapao Kwaro sérimp karwaok lotu nap tokwae mek takrá térea pwarará, warko distrik Galili mekamp taun Nasaret mek akwap. ");
INSERT INTO yuj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aeanepo maok, am táráp wae téképria kárákáre sámpria maok, yonkwae kour kwapwe nánko, Kwaro man nɨki yakrá yaewourrá yakámpon. ");
INSERT INTO yuj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jisasomp éntupwar naropwar te yopwar méntép Kwarén loturia Pasova Yae Tokwae nke neria Jerusalem mek akwap konep. ");
INSERT INTO yuj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas wae éntér-sámpramp yopwar yak nánko maok, am anánkwap wokwaek i konepnámp taknámp, akwapriaka Jisasén warámpea Jerusalem mek akwapepono. ");
INSERT INTO yuj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tá wakmwaek Pasova Yae wae ponankor pwaránko maok, wae anánkwap náráp nouroup fárákapént némpouk arákarrá akwap nepo maok, Jisas te oukoumwan Jerusalem mek yak. Tá éntupwar naropwar te Jisas Jerusalem mek yak námp mér mo. ");
INSERT INTO yuj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Anánkwapamp nɨnɨk te, Jisas wae náráp nouroup ankwap fárákapént akwap námpan mpwe. Aeria maok, am anánkwap te wae ankárankamp yámar akwapea, kumuránko náráp nouroup arop ou mek Jisas yak mákeanria oupourounk. ");
INSERT INTO yuj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Am anánkwapao oupourounkepo maok, Jisasén nke mono. Aeria maok, am anánkwap warko Jerusalem mek man oupourounkrá akwap. ");
INSERT INTO yuj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jisasén oupourounkep te yinɨnki yakea maok, wakmwaek nkepo, Jisas lotu nap tokwae mek yak. Mao te tisa fákáre ou mek kuk mek tankrá, am fárákapamp kar wará turunkuprá tank. ");
INSERT INTO yuj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aenánko maok, arop ponankor Jisaso nɨnɨk kour fek am arop fárákapamp kar pwarokwaprá sénámp kar wariaka kokorokor. ");
INSERT INTO yuj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Am anánkwap wae akwapea Jisasén nkeaka korokop. Tá éntupwaro man sérrá, “Táráp e! Amo apaeritea yinan tak rape? Waráp éntupwar naropwar yino amwan yonkwae sakáp tokwaeria amwan oupourounk nempono.” ");
INSERT INTO yuj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nopok mao éntupwar naropwarén sérrá, “Yumo apaerá onan oupourounk repe? Ono te ankár onomp Naropwaromp nap mek yak nanamp te, yumo mér mák nepono?” ");
INSERT INTO yuj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Aerá sénámpan maok, am anánkwap te mao sénámp kar fi am te mér mono. ");
INSERT INTO yuj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Táte wae mao náráp éntupwar naropwarént warko arákarrá, Nasaret mek tukupea kápae kare por mao te éntupwar naropwaromp karwaokrá yak námpon. Aenánko, éntupwar te Jisas sérarnámp kápae kare kar te nɨnɨk mek sámpea nɨki-sampeyak. ");
INSERT INTO yuj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Táte Jisaso wae tékép nánko maok, maomp yonkwae kour te kwapwe kare kare. Aenánko maok, Kwar Tokwaerao nkea warákár tokwae, tá aropao kor nkea, man warákár tokwae. ");
INSERT INTO yuj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taiberius 15 yopwar fek Sisar yak nánko, Pontius Pailat Judia distrik mek Gavman Tokwae yak. Am ke fek te Herot distrik Galili poukeyakánko, maomp naenáp Filip distrik Ituria, Trakonitis poukeyak, tá Lisanias distrik Abilene poukeyakámpono. ");
INSERT INTO yuj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Táte Anas ntia Kaiafas pris taokeyakep arop yak. Aeapo maok, am ke fek Jon Sekaraiamp táráp arop yak mo apár mek akwapá yak nánko, Kwaro náráp kar man sánk. ");
INSERT INTO yuj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aenánko maok, Jon ént Jordan mekamp apár mek am mwaek yárakrá koumteouráp aropan ‘Yumo te yiráp kwatae nɨnɨk pwarará ént mek nér napo, Kwaro yiráp kwatae nɨnɨk tirá épérano’ ria kar farákáp. ");
INSERT INTO yuj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Profet Aisaia kumwinámp buk fek am kar yak námp te ará: “Arop yak mo apár meknámp arop ankárankao wumwirá, ‘Kwar Tokwae korop naenámp mwae nánapria fwapokwapenke. ");
INSERT INTO yuj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Apár wi yakápnámp tokoprá, faonkwe furuk popomprá, kápae kare mwae kup korokorenámp ékékérrá yumwia waenámp tirá épéria fwapi pwarenke. ");
INSERT INTO yuj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aeria maok, Kwaro nomwan érékép naeria tére námp ponankor arop fwap nke mwanapon.’” ");
INSERT INTO yuj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aeránko maok, kápae kare koumteouráp arop, Jono ént mek nérrá kákanoria korop napo maok, mao sérrá, “Yumo fou-tákam niamp aropono! Yumo yiráp kwatae nɨnɨk taki fákeyakápria ént mek néria napo, Kwaro yumwan yopor mo naenámpria nape? ");
INSERT INTO yuj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yumo yae-párák kare paokop nap fek kwatae nɨnɨk younkwe mwaek sɨrarrá Kwaronámpok korop nap érik yénképano. Tá yumoku kok sérarrá, ‘Yino Abrahamomp ou fekamp tárápu ara, yinan Kwar te yopor mo, fwap naenámpan mpwe’ kwapono. Aerá sénapan ono yumwan sérrá: Kwar yumwan wampwe kwaeri pwarará, fwap mámá yumwi kápae karean Abrahamomp tárápu arárria kák naenámpono. ");
INSERT INTO yuj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ankomwar wae yao karámp naenámp nánapi yak námpono. Yao ponankor kwapwe kare ki tank mo i konámp te, kar-tokopea yaomwi mek épér mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Aerá séránko maok, arop ponankor man turunkrá, “Ae te yino mokop mwanámpono?” ");
INSERT INTO yuj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aerapo maok, nopok Jono am fárákapan sérrá, “Arop siot anánkaopwe námp kwamp te, arop ankwapao mo nánko te ankwap man sánkano. Táte arop ankwapao fɨr mo nánko, yumo fɨr tank nánko te man sánk kipo.” ");
INSERT INTO yuj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis sámp konap arop ankwap fárákapao kuri ént mek nér mwaria koropea maok, Jonén sérrá, “Tisa, yino te mokop mwanámpono?” ");
INSERT INTO yuj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tá Jono am fárákapan nopok sérrá, “Yumo takis mani sámp mwaria te, ankár gavmano sérinámp kare fek saráp sámp kipo. Yumo yiráp nɨnɨk fek am kámákarrá sámp kwapono.” ");
INSERT INTO yuj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldia ankwap fákárerao kor man turunkrá, “Yino te apae mokop mwanámpon?” Jono nopok am fárákapan sérrá, “Yumo aropan fupukrá maomp yaekamp mani pouroukoupria, aropan kwekárrá koti kwapon. Yumoku yiráp tére fekamp mani sámp nap te, wae támaonoria warákár kipo.” ");
INSERT INTO yuj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aeránko maok, koumteouráp aropao maomp yonkwae kour kwapwe nkea maok, nɨnɨk tokwaeria sérrá, “Jon máte Krais támaoi kane?” ");
INSERT INTO yuj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aerapo maok, Jono wawia nopok kar pwarokwaprá sérrá, “Ono yumwan ént kar fek ént mek nérrá kák nampono. Nánkár wakmwaek arop ankwap korop námpao maok, maomp kárákáre te onomp kárákáreran kámákár akwap námpono. Ono te apárok kánanke kare nampara, maomp pukamp su fekamp paok aokorop nanamp pwi mo nampono. Mao te yumwan Yiki Kor Spirit ntiaka yaomwi fek nérrá kák naenámpono. ");
INSERT INTO yuj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mao námokuráp sabol yaek sayakrá, wit yorokwaerá narek épérrá tɨri poporokomprá, wit kare wit koupoukour konap nap mek kákea pwarará, tɨri te ankár torokwar mo i konámp yaomwi mek yank naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon kápae kare karan kor koumteouráp arop méranáponoria farákápria maok, Kwaromp Kwapwe Kare Kar farákápámpon. ");
INSERT INTO yuj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aeria maok, táte Jono arop poukeyak konámp arop tokwae Herotén yoporimp te maomp nánaeramp yupu Herodias námoku sámpea yakria maok, ankwap kápae kare kwatae nɨnɨk nánko, man yopori námpono. ");
INSERT INTO yuj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Táte Herot kwatae nɨnɨk ankwap yumuntuk pap námp te, Jonén kalabus mek pap námp aránon. ");
INSERT INTO yuj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Heroto Jonén oukoumwan fákapá pap monámp fek, koumteouráp arop Jon ént mek nérrá kákámp fek Jisaso kor koropea ént mek anámp. Ént mek anámpea pwatea, Kwarén kar toropwaprá yak nánko maok, yámar me fákárámp akwap. ");
INSERT INTO yuj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aenánko maok, am meknámp Yiki Kor Spirit ék. Aropao am nke napo maok, ant yuriamp pourou niampao Jisasomp pourouk éká tank. Aenánko maok, yámar meknámp arop kar niamp wumwiria sérrá, “Amo te onokump tárápono. Amo kwapwe kare nap te, ono amwan warákár tokwaeria yonkwae kárámp nampono.” ");
INSERT INTO yuj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisaso wae 30 yopwaria tére naerianánko maok, koumteouráp aropamp nɨnɨk te, mao te Josepomp tárápan mpweapon: Josep am te Helimp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli te Matatomp táráp. Matat te Livaimp táráp. Livai te Melkimp táráp. Melki te Janaimp táráp. Janai te Josepomp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep te Matatiasomp táráp. Matatias te Amosomp táráp. Amos te Nahumomp táráp. Nahum te Eslimp táráp. Esli te Nagaimp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai te Matomp táráp. Mat te Matatiasomp táráp. Matatias te Semenomp táráp. Semen te Josekomp táráp. Josek te Jodamp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda te Joananomp táráp. Joanan te Resamp táráp. Resa te Serubabelomp táráp. Serubabel te Sialtielomp táráp. Sialtiel te Nerimp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri te Melkimp táráp. Melki te Adimp táráp. Adi te Kosamomp táráp. Kosam te Elmadamomp táráp. Elmadam te Éromp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ér te Josuamp táráp. Josua te Elieseromp táráp. Elieser te Jorimomp táráp. Jorim te Matatomp táráp. Matat te Livaimp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai te Simeonomp táráp. Simeon te Judamp táráp. Juda te Josepomp táráp. Josep te Jonamomp táráp. Jonam te Eliakimomp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim te Meleamp táráp. Melea te Menamp táráp. Mena te Matatamp táráp. Matata te Natanomp táráp. Natan te Devitomp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit te Jesimp táráp. Jesi te Obetomp táráp. Obet te Boasomp táráp. Boas te Salmonomp táráp. Salmon te Nasonomp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason te Aminadapomp táráp. Aminadap te Atminomp táráp. Atmin te Arnimp táráp. Arni te Hesronomp táráp. Hesron te Peresomp táráp. Peres te Judamp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda te Jekopomp táráp. Jekop te Aisakomp táráp. Aisak te Abrahamomp táráp. Abraham te Teramp táráp. Tera te Nahoromp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor te Serukomp táráp. Seruk te Reump táráp. Reu te Pelekomp táráp. Pelek te Eberomp táráp. Eber te Selamp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela te Kainanomp táráp. Kainan te Arpaksatomp táráp. Arpaksat te Siemomp táráp. Siem te Noamp táráp. Noa te Lamekomp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek te Metuselamp táráp. Metusela te Inokomp táráp. Inok te Jaretomp táráp. Jaret te Mahalalelomp táráp. Mahalalel te Kainanomp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan te Enosomp táráp. Enos te Setomp táráp. Set te Adamomp táráp. Adam te Kwaromp táráp. ");
INSERT INTO yuj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Yiki Kor Spirit Jisasén oupouroupá yakánko maok, Jisas ént Jordan pwarará arákarrá akwap. Aenko Yiki Kor Spiritao man warámpea kwar saráp mek sakwapá pwar. Aetenánko maok, mao am kwar saráp mek yiawor fére-sámpramp kumur yakriaka, fɨr fár mo, akwapea am ke fek nánko, mao yae-porokwe tokwae. ");
INSERT INTO yuj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aenánko maok, Satano man poupwekáprá sérrá, “Amo Kwaromp Tárápao nap kwamp te, amo yumwi man sénapo, pan arákareanánko, fárae.” ");
INSERT INTO yuj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nopok Jisas maomp kar pwarokwaprá sérrá, “Kwaromp Buk fek te arakrá sénámpon: ‘Fɨr támao mwar te aropan yiki yak sánk mono.’” ");
INSERT INTO yuj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tá Satano warko Jisasén faonkwe tokwae fek warámpá pokea, mámá apár mekamp taun tokwae ponankor yénképria maok, ");
INSERT INTO yuj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Satano Jisasén sérrá, “Mámá kápae kare kárákáre ntiaka ponankor ankank máte onompono. Ono arop ankwapan sánk naeria te, fwap sánk nanampon. Oukoumwan te amwan sánk nae. ");
INSERT INTO yuj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tá amo onomp puk mapek Kwaráp torokomprá me woukoupria onan lotu napo te, mámá ankank ponankor warápono.” ");
INSERT INTO yuj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas nopok maomp kar pwarokwaprá sérrá, “Kwaromp Buk fek te arakrá sénámpon: ‘Amo te waráp Kwar Tokwae Kar ankárankampan saráp lotuampo. Tá amo maomp térean saráp téreampo.’” ");
INSERT INTO yuj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tá warko Satano Jisasén warámpá akwapea Jerusalem mekamp lotu nap tokwae yumuntuk narekamp wi fek páteyakrá, man sérrá, “Amo Kwaromp Tárápao nap kwamp te, mapeknámp apárok nkwampok far-kɨrékapae. ");
INSERT INTO yuj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kwaromp Buk fek arakrá sénámpon: ‘Mao náráp ensel fákáreran sénánko, amwan yaewourria fwap taokeyak mwanapono.’ ");
INSERT INTO yuj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tá ‘Amwan mao náráp yaek sampɨká apárok pap napo, amwan yumwirao waráp pu kwae mek párákap mo, fwapono.’” ");
INSERT INTO yuj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nopok Jisas kar pwarokwaprá sérrá, “Kwaromp Buk fekamp kar te arakrá sénámpono: ‘Amo waráp Kwar Tokwaeran poupwekápi kwapono.’” ");
INSERT INTO yuj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan am poupwekáp námp takia Jisasén pwarará, nánkárap ankwap fek nke nanampria yépékrá yak. ");
INSERT INTO yuj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisaso Yiki Kor Spiritamp kárákáre fek Galili mek arákarrá akwap. Aenánko mao tére námp te am mekamp némpoukamp arop wae wa napono. ");
INSERT INTO yuj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mao te kápae kare por lotu nap mek koumteouráp aropan kar farákáp nánko, am arop ponankor maomp e sakap. ");
INSERT INTO yuj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas wokwaek épér mo fek yakea téképámp taun Nasaret mek akwapea, Juda firamp anepér i konap yae Sabat méntép tak i konámpara, am yae fek lotu nap mek Kwaromp Kar buk fekamp nkerá farákáp naeria youmpea fokopeyak. ");
INSERT INTO yuj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aenánko maok, lotu taokeyak konámp aropao man profet Aisaiamp buk sánk nánko, sámpea buk aok-pwararea, am mek kumwi oupourounkia nke nánko maok, kar arakrá sénámp yak: ");
INSERT INTO yuj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kwaromp Spirit onan oupouroupá yak námp te, mao onan, Kwapwe Kare Kar ankank monap aropan farákáp nanaponoria nánap námpon. Mao onan sámp-kérép nánko, ék namp te, kar arakrá farákápaeria námpon: ‘Yumo fákapá yakápnap arop aokor pwarará tukupenke! Yumo yi wouroumpeyakápnap arop warko yi fɨrékarrá nkenke.’ Mao onan sámp-kérép nánko, ono ék namp te, tirá néri fákeyakáp nap mekamp aropan fwapi pwarará, ");
INSERT INTO yuj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kwar Tokwae náráp arop érékép naenámp ke kwapweran érik farákáprá séraeria ninámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisaso buk koumoumpea warko lotu taokeyak konámp aropamp yaek sánká pwatea, mekok am fek tank nánko, am lotu nap mek tankápnap koumteouráp arop te Jisasén saráp tokor tankáp. ");
INSERT INTO yuj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aenapo maok, mao wae am fárákapan Kwaromp kar arakrá farákáprá, “Oukoumwan te Kwaromp kar kumwi tari nap wae kare kar korop nánko, yumo wae am kar wa napono.” ");
INSERT INTO yuj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Am lotu nap mekamp arop maomp kar wawia kwapwe kare warákárria nɨnɨk tokwaeria sérrá, “Nomo te wae mér, mámá arop te Josepomp táráp te, mokopia take pourouráp kar kárákáre kwapwe farákáp námpon?” ");
INSERT INTO yuj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Aerá sérapo maok, nopok Jisas kar pwarokwaprá sérrá, “Kare karono, yumo wae onan kar arakrá sér mwanapono: ‘Dokta, amo ankár waráp pourouanmékɨr fwapokwapae! Amo Kaperneam mek térenap kar te yino wae wawi námpono. Amo ankár waráp némpouk mapek kuri taknámp téreampo.’ ");
INSERT INTO yuj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Aerá sér mwanapan maok, ono yumwan kare kar sér rae: Arop fárákap námokuráp némpoukamp profetomp kar te wa mo i konapono. ");
INSERT INTO yuj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yumo wae mér napono, profet Elaija yakámp ke fek kápae kare kae koumteou Israel yaknámp fi mek yakápapo maok, Kwaro yámar me kéri fákeyak nánko, warákam ék mo námp te yinɨnk yopwaria tokwampok yunki yak nánko, apár ponankor mek mwae touwe tokwae koropámpon. ");
INSERT INTO yuj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Takámp fek te Kwaro Elaijan te Israel fi mekamp kae yupu ankárankan yaewouraeria sámp-kérép mono. Mao te taun tokwae Saidon yak námp fek némp Sarefat mekamp kae yupuanámpok saráp sámp-kérépámpon. ");
INSERT INTO yuj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tá taknámp profet Elisa yak námp fek kápae kare Israel fi mekamp lepraráp arop yakáp napao maok, am ou mek Israel fi mekamp arop ankárankampamp touwe fwap mono. Siria fi mekamp arop Naman ankárankao mwar maomp touwe fwapi námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aerá séri pwar nánko maok, lotu nap mek tankápnap arop ponankor am kar wawiaka yonkwae pwarámp tokwaeria, ");
INSERT INTO yuj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jisasén panánkár santukupea taun younkwe mwaek. Am fárákapamp taun te faonkwek yak námpara, Jisasén warámpá tukupea am taun yarápae feknámp Jisasén furuk far-sɨr mwaria napan maok, ");
INSERT INTO yuj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","tá Jisas am arop ou mek amore mek akwapá párákaprá akwap te. ");
INSERT INTO yuj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas apár Galili mekamp taun Kaperneam mek akwapea yae Sabat fek koumteouráp aropan kar yénkrá farákáp. ");
INSERT INTO yuj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aenko maok, am fárákap maomp kar wanap te, mér tokwaeráp aropamp kar kárákáre niamp nánko, wawia kokorokori napon. ");
INSERT INTO yuj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Arop ankárankamp kwatae-arop oupouroupá yaknámp am lotu nap mek yak námpao, Jisasén tékén wumwia waerá sér, ");
INSERT INTO yuj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Wɨ! Nasaret mekamp Jisas e! Amo yinan apae naeria nape? Ae te amo yinan tirá wour naeria koropri kwapono. Ono amwan wae mérampono: Amo te Kwaronámpoknámp koropnap yae-párák yiki kare aropono.” ");
INSERT INTO yuj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Aerámpan maok, Jisaso am kwatae-aropan yoporrá, “Amo te kar pwarará am arop pwar-akwapae!” Aeránko am kwatae-arop am aropan arop ou mek apárok sɨrarrá, wae worokor akwapriaka, am aropan kwatae pap mo, fwap. ");
INSERT INTO yuj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tá ponankor arop kokorokoria námoku kok téréménkrá sérarrá, “Maomp kar máte mokopia kárákáre námpono? Mao kwatae-aropan kar sénánko, woropá tukup nap te, am aropamp kar te kárákáre tokwaeráp aropamp kar niamp námpono.” ");
INSERT INTO yuj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aenánko maok, Jisas am térenámp kar te am mwaekamp némpouk ponankor akwap nánko, kápae kare arop wawi napono. ");
INSERT INTO yuj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas fárámprá am lotu nap pwarará Saimonomp nap mek akwap. Saimonomp yupuamp éntupwar te pourou touwe fokornámp touwe sámpea amp nánko, man koropea yaewouraeria am arop fárákapao Jisasén sér. ");
INSERT INTO yuj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aerapo maok, Jisaso akwapea am yupuamp wonae fik fokopeyakrá pourou mek touwe fokornámp touwe táman yoporánko, am touwe wae worokor akwap. Aenánko, am yupu wae touwe fwapria fárámprá am arop fárákapao fár mwanap fɨr yankapámpono. ");
INSERT INTO yuj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sabat yae yámar worae nánko, arop fárákapao náráp nouroup arop kápae kare touwe arokwamánk nap Jisasnámpok éréképá korop. Mao am fárákapan ankákárankrá pourouk yae paprá touwe fwapokwaprá párakopámpono. ");
INSERT INTO yuj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Táte kwatae-arop fákáreao kor kápae kare koumteouráp aropan pwarará worop-akwapránkrá Jisasén arakrá wumwirá sér i konapono, “Amo te Kwaromp Tárápono.” Am kwatae-arop fákáre te Jisas te Krais támaonoria mérapara, Jisas te am fárákapan te kar séri kwaponorá taokari námpon. ");
INSERT INTO yuj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jisas koumounek kar fárámprá am yak námp pwarará, arop yak mo apár mek akwapea Kwarén kar toropwap. Aenánko maok, koumteouráp aropao man oupourounkia maonámpok tukupea, yinan pwarrá akwap kwaponorá taokor mwaria. ");
INSERT INTO yuj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Aenapo maok, Jisas am fárákapan sérrá, “Ono te ankár ankwap taun mek kuri akwaprá Kwaro maomp firáp taokeyak naenámp Kwapwe Kare Kar farákáp nanampono. Kwaro onan tak tére nanapria sámp-kérép nánko, ono ék nampono.” ");
INSERT INTO yuj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aeria maok, Galili mekamp lotu nap mekmwaek kar farákáprá yáraki námpono. ");
INSERT INTO yuj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ankwap ke fek Jisas ént aokore Genesaret fik fokopeyak nánko, kápae kare koumteouráp arop maomp kar wa mwaria koropá koupoukarea fákappéri yakáp. ");
INSERT INTO yuj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aeapo, Jisas nke nánko, bot kánanke anánkaopwe ént aokore fik tank. Éntékam ti konap arop fárákapao bot am fek pátea éntékam sámp konap umben yérérrá yakáp napo, ");
INSERT INTO yuj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas Saimonomp bot mek korokwapea, man sérrá, “Amo bot ént mek kuk tae morok panánkár sakwapae.” Pita tak nánko maok, Jisas bot mek am mek tankrá koumteouráp aropan kar farákáp. ");
INSERT INTO yuj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mao kar farákápea pwarará, Saimonén sérrá, “Bot sámpea ént pirékarrá sakwapea ént pe kukria umben am mek sɨrarea éntékam tiae.” ");
INSERT INTO yuj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aeránko maok, nopok Saimono sérrá, “Arop Tokwae, yino wae kumuruk éntékam sámp mwanámpan mpwerá sɨr saráp yakáp nánko, moi námpan maok, oukoumwan te amo sénapara, sɨr nki mwaro.” ");
INSERT INTO yuj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aeria sɨrarea maok, kápae kare éntékam tiap te, éntékam ti konap yam fárákár naenámp niamp kare. ");
INSERT INTO yuj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Aenko maok, mao énénki tére konap arop bot ankwap mek yakáp napo, am fárákapan ‘Koropea yinan yaewourenk’ ria wumwi. Aeapo, am fárákap koropea éntékam am tirá bot anánkaopwe mek kák napo, bot anánkaopwe te kápaeria ént mek pɨk naenámp niamp pourouráp. ");
INSERT INTO yuj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aenánko, Saimon Pita am táman nkea Jisasomp puk wonae fik kwaráp torokomprá me kor woukoupria sérrá, “Tokwae Kar e! Ono te kwatae nɨnɨkráp aropao nampono. Onan pwarará akwapae!” ");
INSERT INTO yuj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pita am takrá sénámp te am kápae kare éntékam tinap táman korokop nánko, méntér yakápnap aropao kuri kokorokor nap kwamp napono. ");
INSERT INTO yuj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedimp tárápyarao kor, Jems ntia Jon Pitant énénki tére konap, am arop yaworao kuri nkea korokop. Tá Jisas Saimonén sérrá, “Amo apápi kwapono. Amo éntékam érékép konap mér napara, nánkár wakmwaek amo fwap ononampok koumteouráp arop érékép-korop nanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aeránko maok, bot am pirékarrá tukupea fik papá pwarará maok, tá mao térenap ankank wae párakoprá Jisasomp wakmwaek tukup. ");
INSERT INTO yuj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ankwap ke fek Jisaso ankwap taun mek yak nánko, am taun mek te lepra touwe kwataeráp arop yak. Mao Jisasén nkea maomp wonae fik apárok me kor woukoupria Jisaso námwan aropomp naenámp kar sérrá, “Amo onan fwapi pap nae nap kwamp te, tak napo, onomp pourou Kwaro nke námp fek yiki kukur nae.” ");
INSERT INTO yuj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aeránko maok, Jisas maonámpok nárákarrá maomp pourouk yae papria sérrá, “Onomp nɨnɨk te, amo yiki kukuraeria nampon.” Aeránko, ankár am ke fek táman maomp touwe wae pwar. ");
INSERT INTO yuj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tá Jisaso man kar kárákáre fek sérrá, “Amo arop ankwapan séri kwapono, mono. Amo akwapea prisén waráp pourou yénképria, Moses sérimpnámp taknámp Kwarén ofa sánkampo. Aenapo, arop fárákap wae nkea, waráp touwe te wokwae pwar námprá mér mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aerámpan maok, Jisas am térenámp kar te kápae kare némpouk akwapránk nánko, wawia pwi. Aeria maok, kápae kare arop Jisasomp kar wariaka, tá Jisaso náráp touwe fwapokwapanoria korop. ");
INSERT INTO yuj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jisas am tére naerianámp fek te Kwaromp kárákáre sámp naeria, arop yakáp mo nap ke mek akwap ko Kwarén kar toropwap i konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ankwap kumuruk Jisaso kar yénkrá farákáprá yak. Aenko maok, Farisi ankwap fárákap, tá lo méria farákáp konap tisa fákáre makia distrik Galili ntiaka Judia mekamp taun ponankor, am mekamp taun tokwae Jerusalem meknámp koropea, Jisasomp kar wará tankáp. Jisas touwenap arop fwapokwaprá párakopanoria Kwaromp kárákáre maomp pourouk oupouroupeyak námpono. ");
INSERT INTO yuj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aenánko maok, arop ankárankamp maomp kour ponankor surumpwia tank nánko, arop ankwap fárákapao sunkwiar mek papea sámpea koropea nap mek sayinkea Jisasomp wonae fik pap mwaria. ");
INSERT INTO yuj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Aenapan maok, kápae kare koumteouráp arop nap mek am mek yinkea fákeyakáp napo, maomwaeknámp sayink mwaria mwae oupourounk napo, mo. Aeria maok, narek pokea nap oupouroup tenap ankank keakapea am meknámp am arop sunkwiar fek paok tokoropea, yaek fákeyakáprá ér-popwarrá pɨkia Jisasomp wonae fik am néntépá yakápnap koumteouráp arop ou mek pap. ");
INSERT INTO yuj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aeapo maok, Jisas am fárákapamp méran nkeaka am touwenámp aropan sérrá, “Onomp nouroup e! Ono waráp kwatae nɨnɨk te wae sámp-sɨnampono.” ");
INSERT INTO yuj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aeránko maok, lo yénkrá farákáp konap arop fákáre ntia Farisi fákáreao am kar wawia námoku támao nɨnɨkrá, “Máte apae aropao námp kwamp, Kwarén takrá kar wouroumprá sériane? Arop ankárankaomp kwatae nɨnɨk tirá épér naenámp te yak mono. Am te Kwaromp tére mwarono.” ");
INSERT INTO yuj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tá Jisas am fárákapamp nɨnɨk mek wae mérria, nopok kar pwarokwaprá sérrá, “Yumo apaeritea yiráp nɨnɨk mek poup takrá sérar rape? ");
INSERT INTO yuj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ae te ono am aropan sérrá, ‘Waráp kwatae nɨnɨk te wae pwarámpono’rá sénanko te, yumo wae ‘Kare karono’rá mér mwanap ni, ono ‘Fárámprá akwapae’rá sénanko, mao wae fárámprá akwap nánko, yumo nkea ono sénamp kar ‘Kareno’rá mér mwanap nie? ");
INSERT INTO yuj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aeno onomp nɨnɨk te, yumo arakrá mérenkria nae: Aropamp Tárápan Kwaro, mámá apár mek takaeria kárákáre sánkeanánko, aropamp kwatae nɨnɨkan fwap tirá épér naenámpon.” Aerá séria maok, am kour ponankor surumpwi yaknámp aropan sérrá, “Ono amwan waeman sénampono: Amo fárámprá waráp amp i konap ankank sámpea amokuráp nap mek akwapae.” ");
INSERT INTO yuj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aeránko maok, ankár oukoumwan táman koumteouráp aropao nke nap fek, mao námoku am fek ampinámp ankank sámprá námokuráp nap mek akwapria Kwaromp e sakapria warákár. ");
INSERT INTO yuj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aenánko, arop ponankor am nkea kokorokoria kor me woukourria Kwaromp e sakapria sérrá, “Nomo oukoumwan te mwar pourouráp ankank nkeriano!” ");
INSERT INTO yuj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Warko wakmwaek Jisas am nap pwarará akwapria nke nánko, arop ankwap takis sámp konap nap mek tank. Maomp e te Livai. Aenko Jisas man sérrá, “Amo onomp wakmwaek koropae!” ");
INSERT INTO yuj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tá Livai maomp ankank ponankor am fek pwarará fárámprá ankár Jisasomp wakmwaek akwap. ");
INSERT INTO yuj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tá Livai Jisasompor fɨr tokwae nánap nánko, kápae kare takis sámp konap arop, tá ankwap kápae kare aropao kor méntér fépérrá tankápapo maok, ");
INSERT INTO yuj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisi fákáre, tá námokuráp lo yénkrá farákáp konap arop fákáre, makia Jisaso éréképá yárak i konámp arop fákáreran sérarrá, “Yumo apaerá takis sámp konap arop ntia ankwap kwatae nɨnɨkráp aropént pápárárri tankáp napon?” ");
INSERT INTO yuj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tá nopok Jisas maomp kar pwarokwaprá wounáprá arakrá sér, “Arop fárákap touwe mo, fwapnap te doktanámpok tukup mo i konapono. Touwenap aropao saráp doktanámpok tukup konapono. ");
INSERT INTO yuj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tá taknámp ono ék namp te, arop, námo yae-párák kare nɨnɨkrápao namprá nɨnɨknap aropan te mono. Arop, námo kwatae nɨnɨkrápao namponorá nɨnɨknap arop táman yaewour nanko, maomp kwatae nɨnɨk pwaranoria ék nampon.” ");
INSERT INTO yuj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ankwap ke fek, arop ankwap fárákapao Jisasén sérrá, “Jon éréképea yárak i konámp arop fárákap te kápae kare por Kwarén kar toropwap mwaria fɨr wuri yakáp i konapono. Tá Farisi fákárerao éréképá paokop i konap arop fákáreao kor tak i konapon. Aeno amo éréképá yárak i konap arop fákáre máte fɨrráp ént fépér i konapon.” ");
INSERT INTO yuj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tá nopok Jisas am fárákapan námokuráp pourouan wounáprá sérrá, “Ae te yiráp nouroup arop ankwap ankárank yupu sámp naerianámp arop oukoumwan yumont yak námp fek te, arop ankwapao fwap yumwan fɨr fár mwanap taokor naenámp nie? Mono. ");
INSERT INTO yuj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tá nánkár wakmwaek aropao am yupu sámp naerianámp arop warámprá tukup tenapo, náráp nouroup aropént yak mo nánko, am ke fek maok mao fwap fɨr wuri konapono.” ");
INSERT INTO yuj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisaso námokuráp kar Juda firamp nɨnɨként tapokwap mo námpan am fárákapan wounáprá sérimp: “Arop ankwap waempyam épi me aomp naeria te, wourékam waempyam fárákapea épi waempyam fek pap mo i konámpono. Tá arop ankwapao tak nánko te wourékam waempyam popor soumpour námpon. Tá wourékam waempyam te épi waempyamént ankár pourouráp kárákáre mono. ");
INSERT INTO yuj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tá arop ankwap épi meme yɨpi mek wain ént wourékam kér mo i konámpono. Tá arop ankwap tak námp te, wain ént wourékamao épi meme yɨpi fár-pwaránko, wain ént apárok kwarokor pɨk nánko, meme yɨpirao kuri kwatae akwap naenámpono. ");
INSERT INTO yuj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aeno arop ankár meme yɨpi wourékam mek wain ént wourékam kér naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tá arop épi wain ént fárianámp te warko wourékam wain ént fánaerá nɨkɨp mono. ‘Ént wain épi te kwapwe kare ara, wae támaono’rá sér i konámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jisas ankwap Sabat yae fek mao éréképá yárak i konámp arop éréképea witráp yopwar meaok tukupria maok, am arop fárákapao mwae touwe nánko, wit kánánkáprá yae fek kokwarrá fépérrá tukup. ");
INSERT INTO yuj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aenapo maok, tá Farisi fákáreao sérrá, “Sabat yae fek lo kákánk i konap ankank te, yumo apaerá tak rape?” ");
INSERT INTO yuj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisas maomp kar pwarokwaprá sérrá, “Wokwaek Devit ntia maomp arop fárákapaoi nap kar buk fek yak námp te yumo nke mori kwapono? ");
INSERT INTO yuj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Am ke fek Devit ntia maomp arop fárákap mwae touweria, Devit Kwaromp nap mek youmpea Kwarén sánknap pan aropao fár mono, pris fákáreao saráp fári konap pan wuriman mao fária, náráp arop fárákapan nénkánko fáriapono.” ");
INSERT INTO yuj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Aerá séria maok, warko Jisas am fárákapan sérrá, “Aropamp Táráp te Sabat yae poukwap námpara, mao námoku ‘Apae kip’rá fwap sénaenámpono.” ");
INSERT INTO yuj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jisas ankwap Sabat fek lotu nap mek akwapea koumteouráp aropan kar yénkrá farákáp. Aenko maok, arop ankwap yae-párák mwaek yae yonkwae yak námp am arop ou mek yak. ");
INSERT INTO yuj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aenánko maok, lo yénkrá farákáp konap arop fákáre ntia Farisi fákáre Jisas Sabat fek arop yae fwapi pap te mokopon nke mwar ritea sánánkar yépékrá tankápria, man kot mwanap mwae oupourounk. ");
INSERT INTO yuj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tá Jisas am fárákapamp nɨnɨk mek wae méritea am yae yonkwae yaknámp aropan sérrá, “Amo fárámprá kuk mapek fokopeyakae!” Aeránko maok, am arop fárámpea koropea fokopeyak. ");
INSERT INTO yuj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tá Jisas am fárákapan sérrá, “Ono yumwan turunk rae: Lo te Sabat fek nomwan ‘Apaenk’rá sénámpon? Ae te Sabat fek arop ankwapan yaewour mwanámp ni, ankwapan kwatae pap mwanámp nie? Ae te nomo aropan yaewourianánko yiki yak naenámp ni, porokwapá pap mwanámp nie?” ");
INSERT INTO yuj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aeria am mek tankápnap aropan énounkouprá akwapria am yae kwataeráp aropan sérrá, “Waráp yae kor ékékérae.” Aerá séránko maok, am arop wae takánko, maomp yae kor wae warko kwapwe kare. ");
INSERT INTO yuj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tá am fárákap am nkea, yonkwae pwarámp tokwaeria námoku kok sérarrá, “Jisasén te apae mokop mwanámpon?” ");
INSERT INTO yuj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Am ke fek Jisas Kwarén kar toropwap naeria faonkwek akwap. Am kumuruk ponankor mao Kwarén kar toropwaprá yakámp te akwapea wakor. ");
INSERT INTO yuj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Koumounek yámar aok nánko éréképá yárak i konámp aropan ‘Koropenk’ ria wumwi. Aenánko, am fárákap wae korop napo maok, náráp tére mwanap arop éntér-sámpramp farákápea pwarará, mao am fárákapan ‘Aposel’ e tokoprá kák. ");
INSERT INTO yuj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Arop ankwapamp e te Saimon (Jisas man ankwap e tákaprá ‘Pita’rá sér) ntia maomp nánaenáp Andru. Ankwap te Jems, tá maomp nánaenáp Jon. Ankwap te Filip, ankwap te Bartolomyu, ");
INSERT INTO yuj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ankwap te Matyu, ankwap te Tomas, ankwap te Alfiusomp táráp Jems, tá Saimon, Selot Pati mekamp arop, ");
INSERT INTO yuj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","tá Jemsomp táráp Judas, tá Judas Iskariot, wakmwaek Jisasén outɨri naenámp arop. ");
INSERT INTO yuj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas faonkwek pwarará, maomp éréképá yárak i konámp aropént pɨkia apár émpi fek náráp éréképá yárak i konámp kápae kare aropént yakápapo, kápae kare arop distrik Judia mek, ntia taun Jerusalem mekamp koumteouráp arop, tá solwara fikamp taun Tair ntia Saidon mekamp arop fárákapao kuri yakáp. ");
INSERT INTO yuj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Am arop fárákap te Jisasomp kar waria, tá Jisas náráp touwe fwapokwapanoria koropap. Tá kápae kare arop kwatae-aropao maomp pourou sokoro napo, Jisas am kwatae-arop yérépeanoria korop. Aenapo, Jisaso am koropnap aropan ponankor fwapokwapimpono. ");
INSERT INTO yuj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jisasomp pourou meknámp kárákáre akwapria arop ponankoramp touwe fwapokwaprá kák námpara, kápae kare koumteouráp arop párák Jisasomp pourouk pap mwaria maonámpok tukup napon. ");
INSERT INTO yuj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisaso náráp éréképea yáraknámp aropan énounkoupia sérrá, “Yumo ankank monap arop fárákap, Kwaro yumwan ourour sánk naenámpon. Am ourour te ará: Kwaro náráp firáp taokeyak námp te yirápono. ");
INSERT INTO yuj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yumo yae-porokwenap arop, Kwaro yumwan ourour sánk naenámpon. Am ourour te ará: Nánkár wakmwaek yumo fwap fária yare mwarea napon. Yumo arop oukoumwan éménkrá yakáp nap te, Kwaro yumwan ourour sánk naenámpon. Am ourour te ará: Nánkár wakmwaek yumo fwap amomoránk mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Yumo Aropamp Tárápamp weaok tukup napo, yumwan arop nkea kokwarokrá yumwan younkwe sánkria yumwan wouroumprá, ‘Yumo te kwatae mwaek paokopnap arop’rá sérar napo, Kwaro yumwan ourour sánk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Am arop fárákap yumwan tak napo te, yumo fwapono warákárriaka yonkwae kárámp kip. Am te apaeria námpanáp, yumo nopok sámp mwanap ankank tokwae te yámar mek tank námpon. Wokwaek maomp appeyaenápo kor profet fákáreran takiap táman napono. ");
INSERT INTO yuj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aeno yumo ankank kápaeráp arop, yumo te mér kip: Oukoumwan te yumo yonkwae kárámpnap kwapwe kare ankank wae sámp napon. ");
INSERT INTO yuj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tá yumo arop oukoumwan fɨr tokwae fépérrá yare nap te, yumo te mér kip: Wakmwaek te yumo mwae touwe mwanapon. Tá yumo arop oukoumwan amomoránk nap te, yumo te mér kip: Wakmwaek te yumo éménkrá émti pɨk mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tá kápae kare arop yiráp e sámpá sakap napo te, yumo am wa nap kwamp te mér kip: Wokwaek maomp appeyaenápo kuri kwekár sérar i konap profetomp eran kor takrá sámpá sakapiapon.” ");
INSERT INTO yuj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Tá Jisaso ankwap kar yénkrá sérrá, “Yumo onomp kar wanap arop yumwan sér rae: Yumo te ankár yumwan yopornap aropan nouroup kip. Arop yumwan yopor napo te, yumo man yaewour kip. ");
INSERT INTO yuj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tá arop yumwan sámpá yampourou napo te, nopok yumo man kwapwe kare kar sériaka, yaewour kip. Yumwan touwe sánk napo te, yumo ‘Am fárákapan yaewourampo’rá Kwarén sér kip. ");
INSERT INTO yuj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tá arop ankwapao amwan wapra kor fek porokwap nánko te, warko ankwap mwaek wapra kor sámp-arákarrá, maonámp mwaek sánkampo. Tá aropao waráp saket worokwap naerianánko te, waráp siot méntér worokwapantánoria taokor kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tá arop ankwapao, námwan ankank sápae nánko te, ankár man sánkamp. Arop waráp ankank pwarokwap nánko te, ‘Am ankank arákarrá sápae’ ria kárákáre fek séri kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Arop námwan yaewouranáponoria nɨnɨk i konapnámp taknámp, yumo kuri arop ankwapan tak kip. ");
INSERT INTO yuj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Táte yumo arop yumwan warákár konap aropan warákár nap te, waeman nopok sámp nap wae támaono. Kwaromp firáp monap aropao kuri námwan warákár konap aropan nopok warákár konapono. ");
INSERT INTO yuj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yumwan yaewour i konap aropan saráp yaewourap te, am fek waeman nopok sámp nap wae támaono. Kwaromp firáp monap aropao kuri tak i konapono. ");
INSERT INTO yuj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tá yumo arop nopok kuri sáp naenámp nɨnɨkria ankank sánk nap te, waeman nopok sámp nap wae támaono. Tá Kwaromp firáp monap aropao kuri takrá ankank nonopok i konapono. ");
INSERT INTO yuj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ae konapara, yumo ankwap nɨnɨk sámpenke. Yumwan yopornap aropan nouroupria, man yaewour kip. Yumo ankár ankank monap aropan ankank nénkria, nopok kuri sáp naenámponoria nɨnɨki kwapono. Yumo am tak nap te, nánkár wakmwaek ankank tokwae sámpria, narekamp Kwar Tokwaeramp tárápu yakáp mwanapon. Mao te námwan ‘Aesio’rá sér monap aropan aropompria, kwatae nɨnɨkráp aropan kuri aropomp i konámpon. ");
INSERT INTO yuj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yiráp Naropwaro ponankor aropan yonkwae touwe konámpnámp taknámp, yumo kuri am fárákapan yonkwae touwe kip.” ");
INSERT INTO yuj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Tá Jisaso ankwap kar arakrá sér, “Yumo te arop ankwapao kwatae nɨnɨk námpan yurukupia ‘Mao te kwatae námp’ ria wouroumprá séri kwapono. Nopok Kwaro yumwan kuri yurukupia ‘Kwatae nap’rá sénaeane. Tá yumo arop kwatae nɨnɨk námpan yumo man, yaomwi mek pɨk nanaponoria far-pwar kwapono. Yumo tak napo te, Kwaro yumwan kor yaomwi mek far-pwar naeane. Yumo yumwan kwatae nap arop ankwap fárákapamp kwatae nɨnɨk wampwenoria pwar napo maok, nopok Kwaro yiráp kwatae nɨnɨk tirá épér naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tá yumo ankwap aropan ankár ankank nénk napo, nopok yumwan kor Kwaro ankank nénk naenámpon. Mao nopok kámákarrá kápae kare nénkria top-pwarámpea panánkarrá warko top kare fek tankrá top koupouriaka kwarákár námp yumwan nénk naenámpon. Yumo arop mokope puri fek nénk nap te, Kwaro nopok yumwan take pourouráp nénk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aerá séria pwarará maok, Jisaso arop fárákapan wounáp kar ankwapan kor farákáp: “Ae te yi néneráp arop te arop ankwap yi nénenámpan fwap mwae kup yénképrá akwap naenámp nie? Mono. Takria te am yawor énénkér me mek pɨk nenepe. ");
INSERT INTO yuj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tá oukoumwan skulnámp arop te maomp tisan kámákár akwap mo i konámpono. Nánkárap skulia pwatea maok, táte wae maomp tisa niamp take popwar yak konámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Táte Jisas wounáp kar ankwap arakrá sér: “Amo apaeritea waráp ankwapwarápomp yi mek tɨri kánanke tank námp táman énounkoupria amokuráp yi mek tanknámp yao kárakére tokwae nke mo rape? ");
INSERT INTO yuj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Amo mokopia waráp ankwapnápén sérrá, ‘Onomp nouroup o! Ono waráp yi mek tɨri kánanke tank námp sámp-sɨnae’rá sénapan maok, amokuráp yi mek yao kárakére tokwae tank námp te nke mo rape? Amo tak nap te, yiráp kar te yiráp nɨnɨként ankár pourouráp mono! Manmékɨr te amokuráp yi mekamp yao kárakére tokwae tank námp am sámpea sɨtea maok, amo fwap énounkoup karia waráp nouroupomp yi mekamp tɨri kánanke sámp-sɨnanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jisas warko wounáp kar ankwap arakrá sér, “Kwapwe kare yao te kwatae yao ki tank mo i konámpono. Tá taknámp kwatae yao te kwapwe kare yao ki tank mo i konámpon. ");
INSERT INTO yuj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Arop am yao ki tank námp táman wuri nkea maok, aráte am yao fekamponorá nɨnɨk i konapon. Arop kwantaeki kánánkapea fár mwaria te, wiráp paok aopwe fekamp tukupá kánánkapea fár mo i konapon. Tá wain ki te yao pwae mekamp wiráp yao yowe fek tank mo i konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Táte taknámp kwapwe kare arop te maomp nɨnɨk mek kápae kare kwapwe kare nɨnɨk mwari yak námpara, maomp táp meknámp kor kwapwe kare nɨnɨk fekamp karan saráp sér i konámpon. Aeno kwataenámp arop te maomp nɨnɨk mek kápae kare kwatae nɨnɨk mwari yak námpara, am fekamp kar kwataeran saráp sérar i konámpon. Apae nɨnɨk maomp nɨnɨk mek top koupouri yak námp te, am táman top korao érik sér i konámpono.” ");
INSERT INTO yuj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jisas sérrá, “Yumo apaerá onan ‘Tokwae Kar! Tokwae Kar!’rá sénapao, yumo onomp karwaok mo rape? ");
INSERT INTO yuj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Táte arop ankárankamp ononampok koropea onomp kar wawia mántwaok námp te, maonámp táman yumo nkea nɨnɨkenkria yénkép nanampon. ");
INSERT INTO yuj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Am aropamp nɨnɨk te nɨnɨk kwapweráp arop ankwapao nap ti naerianámp niampon. Manénkɨr te apár me yokoroprá pɨkia mek karaok oumpwar sɨrarea oumpwar fi mek yumwi épéria fampea kárákáre pwate nánko, nap am fek yak. Aenánko, wakmwaek warákam námp fek ént ntenk tokwae koropria nap tuk-sɨnaerianánko, nap fwap tukur mo, kárákáre yak konámpon. Am te apaeritea námpanápe, am aropao nap kwapwe kare ti tenámpara námpon. ");
INSERT INTO yuj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aeno arop onomp kar wawia mántwaok mo námp te, arop ankwap nɨnɨk kwapwe mo námpao, nap ti naerianámp niampon. Mao oumpwar fi mek te yumwi fémpér mo yakrá, kwar mwar fémpéri tenánko, wakmwaek warákam nánko éntenk tokwae koropria am nap tuk-sɨnánko, nap panánkár nánko, kwatae akwap konámp niampono.” ");
INSERT INTO yuj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas koumteouráp aropan am kar farákápea pwarará maok, akwapea Kaperneam mek. ");
INSERT INTO yuj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aenko maok, Rom fi mekamp kepten 100 soldia éréképá yak námp, mao náráp tére arop ankárankamp man táman warákár konámpao maok, mao touwe tokwae sámpea waeman sumpwi naenámp niamp pourou. ");
INSERT INTO yuj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aenánko maok, kepten Jisas yakámp kar wawia, mao Juda fi taokeyakáp konap arop Jisasnámpok tirá kérépria sérrá, “Yumo tukupea Jisasén sénapo, koropea náráp tére arop fwapi papano.” ");
INSERT INTO yuj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aeránko maok, wae tukupea Jisasnámpokria maok, man aropomp naenámp kar fek sérrá, “Am arop te kwapwe kare aropono. Amo fwap man yaewour nanap pwi námpono. ");
INSERT INTO yuj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mao te Juda fi nomwan warákárriaka yaewour i konámpono. Mao námoku yinomp lotu nap ti námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tá wae Jisas am fárákapént akwap. Akwapea wonae fik keptenomp nap-topokánko maok, am kepteno náráp arop ankwap fárákap tirá kérépánko koropea Jisasén sérrá, “Tokwae Kar e! Mokop korop nanapanáp, wampweno. Aeria apae ono kwapwe kare aropao nanko, onomp nap mek korop nanapanápe. ");
INSERT INTO yuj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Táte ono kuri kwapwe kare aropao amwan kuri koropá nke nanampanápe. Amo kar fek saráp sénapo, onomp tére arop wae touwe fwap naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Am te apae riteanápe, ono kuri onan tére sáp konámp aropamp yae ankore mek yak konampono. Táte ono kuri onomp soldia onomp yae ankore mek yakáp napara, tá ono ankwapan ‘Amo akwapae’rá sénanko te, mao akwap námpon. Tá ono ankwapan ‘Amo koropae’rá sénanko te, mao korop námpon. Tá onomp tére aropan sérrá, ‘Amo ará téreae’rá nanko te, mao takrá tére konámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aerá sénánko Jisas am kar wawia mao am aropan nɨnɨk tokwaea sámp-arákarrá kápae kare koumteouráp arop maomp wakmwaek korop napan sérrá, “Ono yumwan sénampon: Ono Israel fi mek te mámake Kwarén mér kárákárenámp arop nke moi nampono.” ");
INSERT INTO yuj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Táte am arop fárákap kepteno tirá kérépánko, koropap arop wae nap mek ti-arári tukupea nkeapo maok, keptenomp tére arop maomp touwe wae fwap. ");
INSERT INTO yuj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Takia pwarará, warko wakmwaek Jisas taun Nain mek akwap. Aenánko mao éréképá yárak i konámp arop fárákap, táte kápae kare koumteouráp arop makia Jisasént tukup. ");
INSERT INTO yuj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jisas akwapea taun ménki tokwae fek nánko maok, arop tár-ménki sumpwi námp sunkwiar mek papea sámpá korop. Aenapo am sumpwinámp aropamp éntupwar te táráp ankwap sámp mono, am ankárankamp támao mwar, táte maomp poumaropao kuri wae sumpwi te. Tá am taun mekamp koumteouráp aropao kuri am yupunt korop. ");
INSERT INTO yuj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aenapo maok, Tokwae Karao am yupu nkea man aropomp tokwaeria am yupuan sérrá, “Amo émi kwapono.” ");
INSERT INTO yuj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aerá séria maok, Jisas námoku wonae fik akwapea arop ampnámp sunkwiar fek yae pap nánko, am arop sámpnap arop am fek foukouri yakáp. Aenapo Jisaso sérrá, “Arop tár-ménki, ono amwan sénampono: Amo fárámpae.” ");
INSERT INTO yuj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aenánko maok, am arop sumpwi yak námp te wae fárámpea tankrá kar sénánko maok, Jisas am arop wae náráp éntupwarént pwar. ");
INSERT INTO yuj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aenánko maok, koumteouráp arop ponankor apáp tɨrɨnkria Kwaromp e sakapria sérrá, “Profet tokwae kar ankárank wae nomp amore mek korop námpono.” Aeria maok, warko am fárákapao sérrá, “Kwaro náráp koumteouráp arop yaewour nanampria wae korop námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aeria maok, arop fárákap Judia mekamp némpouk mwaek, tá kápae kare némpouk mwaek paokoprá Jisas am térenámp kar farákáp napon. ");
INSERT INTO yuj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Aenapo maok, Jono éréképá yárak i konámp aropao am kar wawia Jonén sér. Aenapo, Jon éréképá yárak i konámp arop anánkaopwe wumwiria ");
INSERT INTO yuj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jisasnámpok tirá kérépria maok sérrá, “Arakrá turunk kipo: ‘Amo te am korop naenámpria yépéknámp arop támao ni, yino nánkár ankwap yépék mwanámp nie?’” ");
INSERT INTO yuj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aeránko am arop yawor wae akwapea Jisasnámpokria man sérrá, “Yinan arop ént mek nér i konámp Jono tirá kérép nánko, amonapok korop nempono. Mao te arakrá séri námpon: ‘Amo te yino korop naenámpria yépéknámp arop támao ni, yino nánkár ankwap yépék mwanámp nie?’” ");
INSERT INTO yuj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Am ke fek te Jisas kápae kare koumteouráp aropamp nkwakwe make touwe fwaprá kák, tá kápae kare kwatae-arop pouroukamp yéréperá kérép, tá kápae kare yi néneráp aropamp yi fwaprá kákámpono. ");
INSERT INTO yuj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ae námp fek Jisas am arop yaworan nopok kar pwarokwaprá arakrá sér, “Yumo akwapea Jonén kápae kare ankank yumo nkeria wawi nep táman farákáp kipo. Yi néneráp arop fárákap warko fwap nke, tá pu kor kwataeráp arop warko ferámpea paokop. Lepranap aropamp pourou yɨpi warko yiki kwapwe napono. Táte woupwi kéri yaknámp arop warko fwap woupwi wa napon. Tá sumpwinap arop warko ferámp napono. Ankank moráp arop fárákap Kwaromp Kwapwe Kare Kar wa napono. ");
INSERT INTO yuj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Arop onan mér námpao, maomp mér kwatae akwap mo námp te, mao fwap warákárrá yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tá am arop yawor Jonén kar sámpá akwap nep wae akwap tenepo maok, Jisas koumteouráp aropan Jon yáraknámp kar farákápria sérrá, “Yumo wokwaek kwar saráp mek tukupap te, apae ankank nke mwaria tukupapon? Ae te yumo ouwirao nárákapá nár-pwatenámp kaeak nke mwaria tukupap nie? Mono. ");
INSERT INTO yuj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yumo apae ankank tukupá nkeapon? Ae te arop ankárankamp waempyam kwapwe kare yirɨmpea yak námpan nke mwaria tukupap nie? Táte mono. Kápae kare arop waempyam kwapwe yirɨria pourou yɨpi fek saráp ankank tinap arop kingomp nap mek tankáp i konapon. ");
INSERT INTO yuj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aeno yumo te mokope ankankan tukupá nkeapon? Yumo te profet ankárankan tukupá nkeap nie? Táte yeno. Ono yumwan sénampon: Mao te profetao maok, ponankor ankwap profetén kámákár akwapnámp arop tokwaeno. ");
INSERT INTO yuj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Am arop táman Kwaro náráp Buk fek ono tére namp máman méntér wounáprá sérrá, ‘Yumo wawenke! Ono arop sámp-kérép nanko, onomp kar sámpea manmékɨr amwan mekia akwaprá mao waráp mwae kup yororá akwap naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ono yumwan sénampon: Jon te apárokamp ponankor aropan kámákár akwap námpan maok, arop Kwaromp fi mek kánanke kare yak námp te Jonén kámákár akwap námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tá koumteouráp arop ntia takis sámp konap aropao kuri am kar wawia sérrá, “Kareno! Kwaromp nɨnɨk te yae-párákono.” Am takrá sénap arop fárákap te Jonomp yaek ént mek nériapao sénapon. ");
INSERT INTO yuj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Táte Farisi fákáre ntia lo mérnap arop fákáre te Kwaro kwapwe kare mwae kup yénkép námpan younkwe sɨnap te, Jonomp yaek ént mek nér moi napara napon. ");
INSERT INTO yuj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tá Jisaso sérrá, “Mámá ke fekamp koumteouráp arop te mokope pourouráp aropono? ");
INSERT INTO yuj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Am fárákap te némpouk tankáprá sokwaknap tárápu niampon. Tárápu kánanke-tárápao némpouk amore mek tankáprá sokwaknap tárápuan arakrá wumwi, ‘Yino sére porokwap nánko, yumo apaerá tár sámp mo rape? Tá yino yonkwae touwe mwanap tár sámp nánko yumo apaerá ém mo rape?’ ");
INSERT INTO yuj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ae konapnámp taknámp arop ént mek nér i konámp Jon mao koropea pan ntiaka wain ént fár mo nánko, yumo am táman warákár moria sérrá, ‘Kwatae-arop maomp pourouk woukoupeyak námp’rá sériapon. ");
INSERT INTO yuj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aenap támao, oukoumwan kor Aropamp Táráp koropea, pan ntiaka wain ént fánánko, yumo am táman kor warákár moria sérrá, ‘Nkenk! Mao te fɨrráp wain ént kápae fári konámp aropono. Mao te takis sámp konap arop ntia kwatae nɨnɨkráp arop fárákapamp nouroupono.’ Aerá sér i konapon. ");
INSERT INTO yuj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aeno arop Kwaromp yonkwae kour sámp nap te, maomp paokop te nomwan yénképrá am yonkwae kour te kare karono.” Jisas arakrá farákápámpon. ");
INSERT INTO yuj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ankwap fek, arop Farisi ankwapao Jisasén ‘Námont koropea fɨr fárae’ ria wumwi nánko, Jisas akwapea am Farisimp nap mek fár mwaria tank. ");
INSERT INTO yuj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Aenánko maok, kokopor i konámp yupu ankárankamp am taun mek yak námpao ‘Jisas Farisimp nap mek koropá fáran’rá sérap kar wa. Aeria maok, am yupu yumwi kwapwe fek yoroinap botol sanda sámpea korop. ");
INSERT INTO yuj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mao koropea Jisasomp younkwek puyar mwaek wonae fik fokopeyakrá, émrá yak. Aenánko, Jisasomp puk émti pɨk. Aenánko, námoku náráp me pwae sámpea am fek torokorria aop mukur i konap niampria Jisasomp puk takria am sanda kwarákarámpono. ");
INSERT INTO yuj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Takánko maok, am Farisi Jisasén koropaerá wumwi rimp támao am táman nkea, arakrá nɨnɨk, “Táte mámá arop profet kareao námp kwamp te, mámá yupu maomp puk sanda kwarákar námp nkea, mao i konámp ankank wae méria, am yupu te kwatae nɨnɨkráp yupunoria mér naeria námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Farisi takrá nɨnɨk nánko maok, Jisas maomp nɨnɨkan pwarokwaprá sérrá, “Saimon, ono amwan ankwap kar sénae.” Aeránko nopok Saimono sérrá, “Tisa, amo sénaenap kar sérae.” ");
INSERT INTO yuj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Táte Jisaso wounáprá arakrá sér, “Arop yawor akwapea, arop ankwapan turunk nepo, ankwapan K100 sánk, ankwapan K10 sánk, ");
INSERT INTO yuj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Maki tenánko, wakmwaek am arop yawor nopok sánk nenep pourou mo nánko te, am mani sánknámp aropao wampwenori pwar. Aenánko te am arop yawor te wa mani sánknámp aropan warákár tokwae námpono?” ");
INSERT INTO yuj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Táte Saimono nopok kar pwarokwaprá sérrá, “Ono nɨk namp te, mani tokwae sámp námpao, nopok sánk monámp aropao námpono.” Táte Jisas sérrá, “Waráp kar te yae-párák támaono.” ");
INSERT INTO yuj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aeria maok, am yupu yaknámp mwaek sámp-arákarrá, Saimonén yénképrá sérrá, “Amo mámá yupu mapek nkeae. Ono waráp nap mek korop namp te, amo waráp tére konap aropan sénapo, onomp pu yárár moi námpono. Aeno mámá yupu mao náráp émti ti fek onomp pu kor yárária, náráp me pwae fek féki torokor námpono. ");
INSERT INTO yuj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Arop nap mek korop napo, aop mukur i konap te amo onan tak moi napono. Aeno mámá yupu te ono oukoumwan nap mek korop namp feknámpia koropea oukoumwan onomp puk aop mukur i konapnámp tak námpono. ");
INSERT INTO yuj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Amo te onomp me korok wel kwarákár mo napo maok, mámá yupu te onomp puk sanda kwarokor námpono. ");
INSERT INTO yuj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aenámpantá, ono amwan sér rae: Mao te kápae kare kwatae nɨnɨkianánko, ono maomp kwatae nɨnɨk tirá épéri nampara, mao onan warákár tokwae námpon. Aeno arop kwatae nɨnɨk ankwap yinɨnkianánko, Kwaro maomp kwatae nɨnɨk tirá épérianámp te, maomp warákár te kánankeno.” ");
INSERT INTO yuj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aerá séria pwarará, Jisaso am yupuan sérrá, “Ono waráp kwatae nɨnɨk wae tirá épéri pwar nampono.” ");
INSERT INTO yuj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aerá séránko maok, táte am énénki tankáprá fépérnap aropao námoku kok arakrá sérar, “Mámá arop máte wa námp kwamp, nkwakwe make téreria kwatae nɨnɨkan kor tirá épér námpono?” ");
INSERT INTO yuj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Táte Jisaso am yupuran sérrá, “Waráp onan mérnap támao amwan fwapi pap námpono. Amo am mér napara, akwapea yonkwae porokwe fek yakampo.” ");
INSERT INTO yuj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tá wakmwaek ankwap fek Jisas némp-némp yárakrá, Kwaromp firáp yakáp mwanap Kwapwe Kare Kar koumteouráp aropan farákáprá yárak nánko, mao éréképá yárak i konámp éntér-sámpramp arop énénki paokop. ");
INSERT INTO yuj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tá koumteou ankwap fárákap wokwaek kwatae-arop pouroukamp yéréperá kérépria maomp touwe fwaprá kákámp, am fárákapao kuri Jisasént énénki tukup. Ankwap te, taun Makdala mekamp Maria wokwaek Jisaso fákánek kwatae-arop maomp pouroukamp tirá épérimp, ");
INSERT INTO yuj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tá King Herotomp nap taokeyak konámp arop Kusamp yupu Joana, tá Susana, tá kápae kare ankwap koumteou kor méntér tukup. Tá am koumteou fárákap te Jisas ntia mao éréképea yárak i konámp arop fárákapan námokuráp ankank fek yaewour mwaria mént paokopiapon. ");
INSERT INTO yuj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ankwap ke fek ponankor taun mekmwaekamp kápae kare arop koropea Jisasomp wonae fik koupoukour napo, mao am fárákapan wounáp kar arakrá farákáp: ");
INSERT INTO yuj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Arop ankwap akwapea yopwar mek ankankou yoro. Mao ankankou yɨrɨrrá yak nánko maok, ankankou ankwapmwaek te mwae kupuk pɨká tankáp nánko, aropao pumpurékamprá tukup napo, antao koropá fánámpono. ");
INSERT INTO yuj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tá ankankou ankwap yumwi kor námp fek pɨká tankáprá térér námpao maok, ént féki mo nánko, am ankankou ponankor yárákáre námpon. ");
INSERT INTO yuj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tá ankankou ankwap wiráp paok wi ou mek pɨkia tankápria térér námpao maok, wiráp paok méntérria am támao oupoupourámpon. ");
INSERT INTO yuj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Táte ankankou ankwapmwaek kwar kwapwe mek pɨká tankáp námp te fwap péreaka pokea yánk kápae kare tankria, 100-100rá tankáp i konámpon.” Jisas aerá séri pwarará maok, am fárákapan sérrá, “Arop woupwiráp te ankár am kar wa kuno.” ");
INSERT INTO yuj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Takrá séria pwar nánko, mao éréképá yárak i konámp arop fárákapao wounáp fi kor mér mwaria Jisasén turunk. ");
INSERT INTO yuj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aenapo, nopok Jisaso sérrá, “Am Kwaromp firáp yakáp mwanap kar mek wouroumpeyak námp te Kwaro námoku yumwan wae yénkép námpono. Aeno arop ankwap fárákapao maok wounáp karan saráp wa napono. Aenapara, mao te yiran nke napao maok, am ankank te wuri nke mo mwanapon. Tá arop fárákap kar wa napao maok, fi kor mér mo mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jisaso warko arakrá sér: “Am wounáp kar fi kor te ará: Am ankankou te Kwaromp karono. ");
INSERT INTO yuj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","‘Ankankou ankwapmwaek mwae kupuk pɨká tankáp námp’rá sénámp te, arop kar wa napan maok, wakmwaek Satan te, am arop fárákap Kwarén mér napo, mao am arop fárákap éréképantánoria koropea arop nɨnɨk mekamp kar pouroukouprá épér i konámpon. ");
INSERT INTO yuj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","‘Ankankou ankwapmwaek yumwi kor fek pɨká tankáp námp’rá sénámp te, táte arop kar wawia sámpea warákár napao maok, arák kwar mek pɨk mono. Kánanke kwarok ke fek saráp Kwarén méria, nkwakwe make ankank korop nánko, ti-arári tukup napon. ");
INSERT INTO yuj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Táte ‘Ankankou ankwapmwaek wiráp paok ou mek pɨká tankáp námp’rá sénámp te, arop kar wawia tukup napao maok, nɨnɨk tokwaerá apárokamp maniráp ankank sámprá apárokamp ankankan warákárnap nɨnɨkao tokwae karia oupoupouránko, yao ki tank námp niamp pourou mo mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aeno ‘Am ankankou kwar kwapwe mek pɨkia tankáp námp’rá sénámp te, arop kar wawia, nɨki-samp napon. Am fárákapamp nɨnɨk yae-párák kareria kwapwe kare nánko, kárákáre yakáp napo, maomp nɨnɨk mek te yopwar mekamp fɨrao kare yak námp niampi yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisaso warko ankwap wounáp kar arakrá sér, “Arop lam pounkouroupea nap te tap woukwapá pap, tá kákánar ankore mek pap mo i konapono. Ankár narek kákánar fek páte napo, am nap mek youmpnap arop fárákapao am wae nke mwanapono. ");
INSERT INTO yuj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Am wae yokor nánko te, kápae kare ankank mek wouri yakáp námp te nánkár wakmwaek érik korop naenámpon. Tá kápae kare ankank aropao mek oupoupouria kák tenap te, nánkár wakmwaek am ankank érik farákár nánko, arop fárákapao wae nkea mér mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yumo Kwaromp kar wa nap te fwapia mér karrá wa kip. Arop Kwaromp kar kárákáre fek nɨki-samp nánko te, Kwaro man ankwap nɨnɨk kwapwe méntér tapokwap naenámpon. Aeno tá arop kar wawia nɨki-samp nampan mpwe námpao mo námp te, Kwaro am nɨnɨk kánankeran maomp yaekamp pwarokwap naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisaso takrá kar farákápámp ke fek maomp éntupwar ntia nánaeounáp man nke mwaria korop napao maok, kápae kare koumteouráp arop Jisasomp wonae fik koupoukarea yakáp napo, mao Jisasomp wonae fik tukup mwanap pourou mo. ");
INSERT INTO yuj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aenapo maok, arop ankwap fárákapao Jisasén sérrá, “Waráp éntupwar ntia nánaeounáp amwan nke mwaria koropea ek yakáp nape.” ");
INSERT INTO yuj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Táte Jisas am fárákapamp kar pwarokwaprá sérrá, “Koumteouráp arop fárákap Kwaromp kar wawia ampaok nap támao maok, onomp éntupwar ntia onomp nánaeounápono.” ");
INSERT INTO yuj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ankwap ke fek, Jisaso náráp éréképá yárak i konámp arop fárákapént bot mek kounkouria sérrá, “Nomo ént aokore tokwae tápampea nkwamwae fik tukup mwaro.” Aeria maok, wae ént pirékarrá tukup napo, ");
INSERT INTO yuj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","bot wae ént kuk akwap nánko, Jisas te ampi yak. Aenánko maok, am ént aokore mek ouwi tokwae koropria ént surukup tokwaeria, bot mek ént koupour nánko, am arop fárákap ént mek pɨk mwanap niamp pourouráp. ");
INSERT INTO yuj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aenánko maok, am fárákapao tukupea Jisasén kéménkia sérrá, “Arop Tokwae, Arop Tokwae! Nomo oukoumwan ént mek pɨk mwanámp niampáne!” Aeapo Jisaso fárámpea fokopeyakrá am ouwiran taokoránko, ouwi ntia ént tokwae anakop námp wae pwarareaka, ént ounk wae pwar. ");
INSERT INTO yuj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aenánko maok, Jisas námoku éréképá yárak i konámp arop fárákapan turunkrá, “Yiráp onan mér nap te maok yak námpono?” Aeránko, am fárákap te apápria nɨnɨk tokwaeria maok, námoku támao sérarrá, “Mámá arop máte waweane? Mao ouwi ntia éntan sénánko, ankár mao sénámpaok námp ta!” ");
INSERT INTO yuj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Am fárákap apár Galili pwarará warko bot mek ént pirékarrá tukupea nkwamwae fik apár Gerasa mek korop. ");
INSERT INTO yuj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Jisas bot pwarará apárok kɨrékaprá pok nánko, am némpoukamp arop ankwap ankárank maonámpok korop. Kápae kare por kwatae-arop fákárerao maomp pourouk woukouri yakáprá man fákapá fákeyakáp napo, arop kápae kare por man poukeyakáprá sen fek yarokwap ko paprá yae-souwe fákapá paprá. Mak napo kuri, am te ankár fápákárápi ko sɨrarrá akwap konámp. Ankár wokwaek karia koropea oukoumwan námp te, waempyam kámp mono. Pourou mwar yakrá, nap mek amp mono. Ankár am kwatae-arop támao man sámpea arop yak mo apár mek yérépe napo, arop kák konap apár me kwar yu fi mwaek yárak i konámpon. Mao Jisasén nkeria fépéna waeria, Jisasomp puk wonae fik kwaráp torokompria tékén wumwia waeria sérrá, “Jisas, narekamp Kwar Tokwae Karamp Táráp e! Amo onan apae nanape? Ono amwan kárákáre fek sér rae: Amo onan touwe kwatae sáp kwapono.” Am te apaeria námpanápe, Jisaso am kwatae-aropan ‘Érik mankae!’rá yopor. ");
INSERT INTO yuj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisaso man turunkrá, “Waráp e te apaeno?” Tá mao sérrá, “Onomp e te ‘Ami’ no.” Am e sénámp fi te kápae kare kwatae-arop fárákap maomp pourou mek woukouri yakáp napara, takrá sénámpon. ");
INSERT INTO yuj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aeria maok, am kwatae-arop fákárerao náráp pourouantá yonkwae touwe tokwaeria Jisasén tékén sérrá, “Amo yinan nánkárap touwe sámp mwanámp me tokwae éri mek yéréperá kérép kwapon.” ");
INSERT INTO yuj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aerá sérapo, kou kápae kare wonae fik faonkwe yɨpɨri fek fépérrá yakáp. Aenapo maok, am kwatae-arop fárákapao Jisasén aropomp naenámp kar fek tékén sérrá, “Yinan te kouramp pourou mek tirá kérépae!” Aerapo maok, Jisas wae, ampaok tukupenkria pwar. ");
INSERT INTO yuj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aenko maok, am kwatae-arop fárákap am arop pwarará tukupea kouamp pourou mek woukourapo, am kou kápae kare te épépérépia pɨrɨkɨmpria fákáre tokwae mek ént aokore mek pɨkrɨnkria ént fépérrá nékér popwarámpria surumpwi yakáp. ");
INSERT INTO yuj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tá kou wun i konap arop fárákap am táman nkea pɨrɨkɨmpá tukupea, taun mekamp koumteouráp aropan am karan farákáprá sériaka, am mwaek kɨrɨkɨri kouráp sipsipráp wunnap arop fárákapan am kar farákáprá sérar. ");
INSERT INTO yuj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Koumteouráp arop am kar wawia tukupea ankank nke mwaria Jisasnámpok tukup. Mao tukupea nke napo maok, am kwatae-arop noumpoukoupá yaknámp aropan nke napo, kwatae-arop fákáre wae man pwar-tukup tenapo, mao nɨnɨk fwapnae sámpea waempyam yirɨmpea Jisasomp pu páte yak námp fek wonae fik tank. Aenánko, am koumteouráp arop am táman nkea apáp tɨrɨnk. ");
INSERT INTO yuj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jisaso am kwatae-arop yaknámpráp aropan fwapi pap námp nkenap arop fákáre am koropnap arop fárákapan farákáprá sér. ");
INSERT INTO yuj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Apár Gerasa mekmwaekamp arop ponankor Jisasomp kárákáre tokwae nkea apáp tɨrɨnkria, Jisasén sérrá, “Amo wae yinan pwarará akwapae!” Aerapo maok, Jisas wae éréképá yárak i konámp arop fárákapént bot mek korokwapea wae arári tukup mwaria. ");
INSERT INTO yuj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Aenapan maok, am arop kwatae-arop fárákap wae woropá tukup tenap mao Jisasén kárákáre fek sérrá, “Ono te ankár amont akwap nae kar nampono.” Aeránko maok, tá nopok Jisas man sérrá, ‘Mono. Amoku waráp némpouk arákarrá akwapea Kwaro amwan yaewourinámp kar waráp némpoukamp aropan farákápae’rá séria sámp-kérépámpon. Aenko maok, am arop akwapea am némpoukamp ponankor koumteouráp aropan Jisas námwani námp farákáprá sérimpon. ");
INSERT INTO yuj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mamwaek fikamp kápae kare koumteouráp arop Jisasén yépékrá yakáp napo, Jisas wae mao éréképá yáraknámp aropént bot mekia arári korop napo, am koumteouráp arop mao korop napan warákáránkrá yakáp. ");
INSERT INTO yuj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aenapo maok, tá arop ankwap maomp e te Jairus, mao te lotu nap taokeyak konámp arop, mao koropea Jisasomp wonae fik pu pumpuri yak námp fek kwaráp torokompria woukoupria, námwan aropompae karria arakrá sér, “Amo onomp nap mek koropae.” ");
INSERT INTO yuj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Am taknámp fi te ará: Mao te táráp ankwap sámp mono, am yupu-táráp ankárankamp támao mwar, maomp yopwar te éntér-sámpramp yopwar niamp arakenámpao, mao wae sumpwi naeria wae nánko námpono. Táte Jisas wae ampok akwap naeria akwap nánko, arop ou kápae kare man ɨkarea tukup. ");
INSERT INTO yuj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tá am ou mek yupu ankárankamp yak námp, mao te e furuk pɨk námp ankár taki yakrá akwapea éntér-sámpramp yopwar. Ae námp kwamp maok, námwan fwapi pap mwanapan mpwerá kápae kare mani sɨnámpan maok, dokta fárákap man fwapi pap mwanap pourou mono. ");
INSERT INTO yuj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Am taknámp yupu koropea Jisasomp wonae fik younkwe mwaeknámp Jisasomp waempyam fu fek yae pap nánko, maomp e furuk pɨknámp am wae koupour kar pwar. ");
INSERT INTO yuj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tak nánko, Jisas turunkrá, ‘Onomp pourouk yae pap námp te wawean?’ránko, arop ponankor sérarrá, “Ono te mono.” Táte Pita sérrá, “Arop Tokwae, arop ou tokwae kar amwan ɨkarea kɨmpá yakáprá waráp pourouk touroupoukour napono.” ");
INSERT INTO yuj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Táte Jisas sérrá, “Arop ankwap onomp pourouk yae pap námpono. Ono wae mér, onomp kárákáre ankwapmwaek maonámpok akwap námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aeránko am yupu wae méria, ami námp te mek wouroump naenámp pourou mo námpantá maok, mao kour me woukoupria koropea Jisasomp wonae fik apárok kwaráp torokomprá koumteouráp aropao nke nap fek Jisasomp pourouk yae papnámp fi kare séria, tá ‘Onomp touwe te oukoumwan waeman koupour pwar námpon’rá sénámpon. ");
INSERT INTO yuj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aeránko, Jisas am yupuan sérrá, “Táráp e! Amo onan mér nap támao amwan fwapi pap námpono. Amo akwapea yonkwae kakére fek yakampo.” ");
INSERT INTO yuj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas oukoumwan am kar sérrá yak nánko, arop ankwap Jairusomp nap meknámp koropea man sérrá, “Waráp táráp te wae sumpwi tankáne. Tisan youpoukwap tére tokwae sánk kwapono, wampweno.” ");
INSERT INTO yuj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aerámpan maok, Jisas am kar wawia Jairusén sérrá, “Amo apápi kwapono. Amo ankár Kwarén mérampo. Waráp táráp te warko fwap naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tá Jisas wae akwapea Jairusomp nap mekia maok, koumteouráp arop fárákapan ‘Táráp sumpwi tanknámp nap aokore mek yink kwapono’ ria taokor. Aea maok, Jisas námoku mwar Pita, Jon, Jems, am tárápamp éntupwar naropwar, makia man mwar éréképea am nap aokore mek yink mwarea. ");
INSERT INTO yuj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Aenapo maok, kápae kare arop am tárápantá yonkwae touwerá éménkrá yakáp napo, Jisaso am fárákapan sérrá, “Yumo éménki kwapono. Mao te sumpwi mono, párák amp námpono.” ");
INSERT INTO yuj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Aeránko, arop fárákapao am kar wawia amomoránk. Am tak nap te, wae sumpwi tenámponoria. ");
INSERT INTO yuj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Aenapo maok, Jisas wae youmpea am yupu-tárápamp yaek sámpea kéménkrá arakrá sér, “Táráp e! Amo fárámpae!” ");
INSERT INTO yuj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aeránko, am tárápamp waemp arákarrá koropá noumpoukoup nánko, am táráp koupour kar fárámp. Aenánko, Jisaso éntupwar naropwarén sérrá, “Man fɨr sánkenke.” ");
INSERT INTO yuj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tá am tárápamp éntupwar naropwar te am nkea kour me woukoup tokwae nepo maok, Jisas am anánkwapan kar kárákáre fek sérrá, “Mámáninamp ankank mámáte arop ankwapan séri kepono.” ");
INSERT INTO yuj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ankwap ke fek Jisas náráp éréképá yárak i konámp éntér-sámpramp arop fárákapan wumwia koupoukarea fákeyakrá man tére mwanap arop yororoia kák. Aeria maok, kwatae-arop yéréperá kérépria touwenap arop fwapokwaprá kák mwanap kárákáre nénk. ");
INSERT INTO yuj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aeria Jisas am fárákapan, ‘Kwaro náráp firáp taokeyaknámp kar tukupá farákápria, touwenap arop fwapokwaprá kákrá, ");
INSERT INTO yuj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Makenk’ ria tirá kérép naeria sérrá, “Yumo paokopria ankank mént ti-paokop i konap te taki kwapono. Am ankank te ará: Mear yaopwae, yam, fɨr, mani, siot ankwap. Aráte ti-tukup kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yumo tukupea ankwap taun mek napo, arop ankwapao yumwan nkea warákárria náráp nap mek érékép nánko te, yumo ankár maomp nap mek saráp yakáprá tukupea am taun pwarará tukupnap ke fek kipo. ");
INSERT INTO yuj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aeno táte yumo ankwap taun mek tukup napo, arop ankwapao yumwan warákárria náráp nap mek érékép mo napo te, yumo ankár am taun pwarará yiráp su fekamp woup poporokompia pwar napo maok, am támao yénképrá, yumoku nap támaono.” ");
INSERT INTO yuj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jisaso aerá farákápá pwaránko maok, am fárákap wae tukupea kápae kare némpouk mwaek Kwaromp kar farákáprá am némpouk mwaekamp touwenap arop fárákap fwapokwaprá kákapon. ");
INSERT INTO yuj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Apár Galili taokeyak konámp King Heroto Jisas kápae kare ankank térenámp kar wawia nɨnɨk tokwae. Am te apae riteanápe, ankwap fárákapao sérrá, “Arop ént mek nérrá kák konámp Jono apár me meknámp warko fárámpea námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tá ankwap fárákapao sérrá, “Profet Elaija warko korop námpon.” Tá ankwap fárákapao sérrá, “Wokwaek kar profet ankwapao sumpwianámp támao warko fárámpea námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Aerapo maok, King Herot támao sérrá, “Jon te ono wokwaek sénanko, yápare kor fár-sɨrari napono. Aeno ono oukoumwan wa nanko, nkwakwe make tére námprá sénap arop te wanono?” Aeria maok, mao Jisasén nke naeria námpon. ");
INSERT INTO yuj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisas tirá kérép nánko térerá tukupnap arop fárákap am wae Jisasnámpok arári koropea am térenap kar man farákáprá sér. Aenapo maok, Jisaso ankwap arop fárákap am fek pwarará éréképá yárak i konámp arop mwar éréképea taun Betsaida mwaek kɨrɨkɨri ampok tukupea anepéranáponoria éréképá akwap. ");
INSERT INTO yuj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aenánko maok, tá koumteouráp arop fárákap mao tukup nap te wae méria, maomp weaok mwaek tukup. Aenapo maok, Jisaso am fárákapan nkea koropenkria warákárria maok, mao am fárákapan Kwaro maomp firáp taokeyak konámp kar farákápria, touwenap arop fárákap fwapokwaprá kák. ");
INSERT INTO yuj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Takrá akwapea kumur mwaek nánko maok, éréképea yárak i konámp arop éntér-sámpramp támao koropea Jisasén sérrá, “Mámá arop fárákap má tirá kérép napo, tukupea arop yakápnap némpouk mwaek fɨr oupourounkrá fépéria pampanápono. Nomo mapek yakáp námp te arop yakáp monap apárono.” ");
INSERT INTO yuj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aerapo maok, Jisas am fárákapamp kar pwarokwaprá sérrá, “Yumoku támao am fárákapan fɨr nénkenke.” Tá am fárákapao sérrá, “Yino te fɨr kápae kare tank mono. Pan éntik ntia éntékam anánkaopwe, ará mwar tankáp námpon. Ae te waráp nɨnɨk te yino tukupea mani fek fɨr ti-koropeanánko má kápae kare arop ponankor fár mwanap nie?” ");
INSERT INTO yuj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Mámá arop ou te 5,000 niamp arakeno.) Jisas am fárákapan sérrá, “Mámá aropan sénapo, ntik fére-sámpramprá koupoukarrá tankápanápono.” ");
INSERT INTO yuj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aeránko maok, mao éréképá yárak i konámp arop fárákapao am arop ouan takrá koupoukarrá pwar napo, tankáp. ");
INSERT INTO yuj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Aenapo Jisaso pan éntik ntia éntékam anánkaopwe sámpea yámar mek tokoreyakrá Kwarén ‘Aesio’rá sér. Aea pwarará, am pan fékér, éntékam tokop, makia mao éréképá yárak i konámp arop fárákapamp yaek nénk nánko, mao am koumteouráp aropan nénk. ");
INSERT INTO yuj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Aenapo, am koumteouráp arop ponankor fɨran fépéria wae pwi. Aenapo maok, ankwapmwaek oukoumwan tankáp nánko, mao éréképá yárak i konámp arop fárákapao warko popokrá tia éntér-sámpramp basket mek kéria top popwarámpi kák. ");
INSERT INTO yuj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ankwap ke fek Jisas námoku mwar Kwarén kar toropwap nánko, mao éréképá yárak i konámp arop fárákapao maonámpok korop. Aenapo, Jisaso am fárákapan turunkrá, “Koumteouráp arop fárákap onan te ‘Wanono’rá sénapono?” ");
INSERT INTO yuj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aeránko mao éréképá yárak i konámp arop fárákapao nopok man sérrá, “Ankwap fárákapao sérrá, ‘Amo te arop ént mek nér i konámp Jon nono.’ Tá ankwap fárákap sérrá, ‘Amo te wokwaek yakámp profet Elaijanono.’ Tá ankwap fárákapao sérrá, ‘Amo wokwaek yakea sumpwiap profeto fárámpea korop napon.’” ");
INSERT INTO yuj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Táte warko am fárákapan turunkrá, “Yumo kareao te onan te ‘Wano’rá sénapon?” Pita maomp kar pwarokwaprá sérrá, “Amo te Kwaro sámp-kérépnámp Kraisono.” ");
INSERT INTO yuj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita takrá séránko maok, Jisas am fárákapan ‘Am kar ankwap aropan takrá séri kwapono’rá kar kárákáre fek taokarrá pwar. ");
INSERT INTO yuj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tá mao sérrá, “Aropamp Táráp te ankár kápae kare touwe tokwae sámp nánko, arop taokeyakáp konap arop ntia pris tokwae fákáre, tá lo yénkrá farákáp konap arop fárákap, makia man younkwe sɨnapo, arop fárákapao man faropea pap napo, sumpwia yinɨnk yae yakeaka warko fárámp naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aerá séria pwarará, mao éréképá yárak i konámp arop fárákapan ponankor sérrá, “Táte arop ankwap onont korop naeria námp kwamp te, náráp pourou te ankár wampwe pwarará, ono nampnámp mao kuri ankár kumur méntép ‘Touwe tokwae sámprá, fwap sumpwi nanamp’rá nɨnɨk námpao maok, fwap onan éntér pap naenámpono. ");
INSERT INTO yuj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aeno táte arop ankwap námokuráp nɨnɨkaok saráp yakria Kwaromp nɨnɨk wampweri pwar námp te, mao te yiki yaká yak sámp mono. Aeno arop ankwap ononampaok námpan am fek man sámp-wouroump nap te, mao te yae-párák yiki yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tá arop ankwap apárokamp ankankan saráp tére kárákárerá yárakianánko, maomp waemp yaomwi mek pɨk nánko, am kápae kare ankankao te mokopia maomp waempén yaewour naenámpon? ");
INSERT INTO yuj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Táte arop ankwapao onomp e ntia onomp karan arop wa nap fek sénaenámp pwarápaeanámp te, nánkár wakmwaek Aropamp Táráp king yakea námokuráp wae tokwaerént Naropwaromp yiki kor ensel fárákapamp wae tárapokwampia éknámp ke fek nopok am aropamp eran kor érik sér mo nae-námpono. ");
INSERT INTO yuj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ono yumwan kare kar sénampono: Arop ankwap fárákap máyakáp nap oukoumwan sumpwi mo, yiki yakápria, Kwaromp firáp taokeyak konámp nke mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas am kar farákáprá séri pwatea, yukupuk yae niamp arake akwap tenánko, wakmwaek Jisaso Pita warámp, Jon warámp, Jems warámp, makia Kwarén kar toropwap naeria faonkwek pok. ");
INSERT INTO yuj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mao kar toropwaprá yak nánko maok, ankár am ke fek táman, maomp yimetáp te mwar pourouráp akwap nánko, maomp waempyamao kuri mékér wae niampria wae tákapa wae. ");
INSERT INTO yuj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aenánko arop yawor wokwaek yakep Moses ntia Elaija kwaporok koupour kar méntér fokopeyakrá kar sér. ");
INSERT INTO yuj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Am arop yawor te Kwaromp wae tokwaerént foukouri yakrá Kwaro Jisas Jerusalem mek sumpwi naenámpria nánapi pwatari námp, am kar táman Jisasént sérarrá yakáp. ");
INSERT INTO yuj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita mao ouwipi nánko, pamp mwaria napan maok, Jisasomp wae ntiaka am arop anánkaopwe foukouri yak nep táman nkeria maok, warko ouwipi mámaránk. ");
INSERT INTO yuj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Am arop yawor Jisasén wae pwarará akwap neria nepo, Pita Jisasén sérrá, “Arop Tokwae, nomo mapek yakáp mwanámp te kwapwe kareno. Yino fwap sákae yinɨnkaopwe, ankwap waráp por, ankwap Mosesompor, ankwap Elaijampor, makia ti mwanámpon.” Pita am takrá sénámp te, am fi mér moria, kwaporok sénámpon. ");
INSERT INTO yuj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita takrá sérrá yak nánko, koumwe tokwae ékia oupouroup nánko, am arop yinɨnkaopwe apáp tɨrɨnk. ");
INSERT INTO yuj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aenapo maok, am koumwe meknámp arop karao arakrá sér, “Támáte onomp Tárápono. Ono wae mao tére naenámpria nánapi pwate nampono. Yumo ankár maomp kar wa kipo.” ");
INSERT INTO yuj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Am kar takrá séri pwaránko, nke napo maok, Jisas námoku mwar yak. Takia am faonkwek pwarará, warko pɨkianap ke fek te, arop yinɨnkaopwe am nkenap ankank arop ankwapan sér mono. Mek wouroump taeriapono. ");
INSERT INTO yuj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pampia ankwap kumuruk am faonkwek pwarará pɨk napo, ankwap arop ou kápae kare koropá Jisasén mwaeaok kɨkɨp. ");
INSERT INTO yuj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aenapo, am mekamp arop ankárankampao námwan aropomp naenámp kar fek wumwiria sérrá, “Arop Tokwae, ono amwan kare kar sénampono, amo koropea onomp táráp nkeae. Ono te má táráp ankárank támao mwarono. ");
INSERT INTO yuj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Aenampan, kwatae-aropao ankár kar koropá noumpoukoup nánko, táráp apánka wae nánko, man sámpá fopwaoka waeria maomp pourou mek sámpá yampourouria koupour worokor pɨk mo, kápae kare por taki yak nánko, am tárápamp táp meknámp atop wupwi korop konámpon. ");
INSERT INTO yuj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ae konámpantá ono amo éréképá yárak i konap arop fárákapan, onomp tárápamp pouroukamp kwatae-arop wor-pwarenk kar nanko, mao tak mwanap pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Aeránko maok, nopok Jisaso maomp kar pwarokwaprá sérrá, “Yumo mámá ke fekamp koumteouráp arop yumo te mér mo karria, kwatae nɨnɨk fek yakáp napon! Aenapantá ono yumwan sér rae: Ono apaekampor yiráp kápae sámprá yumwan yaewour saráp yak nanampon?” Aerá séri pwarará maok, naropwarén sérrá, “Waráp táráp mampok warámp-sankoropae.” ");
INSERT INTO yuj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aeránko, am táráp oukoumwan mwaeaok mank nánko, am kwatae-arop támao am táráp apárok sámpea sɨnánko, pu yae yurá arokwapa wae. Aenánko maok, Jisaso am kwatae-arop táman yoporia pwarará, am táráp fwapi papea sámprá naropwarén sánk. ");
INSERT INTO yuj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aenko maok, kápae kare koumteouráp arop am Kwaromp kárákáre tokwae nkea kokorokoránka waeapon. Aeria maok, am koumteouráp arop fárákap te Jisas tére námp táman nɨnɨk tokwae napo, Jisaso námoku éréképá yárak i konámp arop fárákapan sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Yumo ankár fwapia woupwi pátea mámá kar wawenke! Nánkár wakmwaek tae morok, arop fárákapao Aropamp Tárápan kárákáre sámpá yakápnap aropamp yaek sánk mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aeránko maok, mao éréképá yáraknámp arop fárákap te mao sénámp kar fi te mér mo. Am sénámp kar fi te mek wouroumpeyak námpara, mér mwanap pourou moriaka, am kar fi turunk mwanapan kor wampweri pwararapon. ");
INSERT INTO yuj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Táte Jisaso éréképá yárak i konámp arop fárákap námoku támao, ‘Nomo ou mek mamek te wa mokop arop tokwae kar yoroia nareki yak kun’rá téréménkiapon. ");
INSERT INTO yuj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aeapo maok, Jisaso am fárákapamp nɨnɨk mek yaknámp nɨnɨkan wae méria maok, mao táráp kánanke warámpea náráp wonae fik páte yakrá, ");
INSERT INTO yuj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","am fárákapan sérrá, “Arop onan nɨnɨkria mámake tárápan warákárria warámp námp te, onan kuri warákárria warámp námpon. Tá arop onan warákárria warámp námp te, onan sámp-kérép nánko ék namp Kwarén kor warákárria warámp námpon. Arop ankwapao mao námoku te wampweri pwarará yumwan ponankor yaewour námp te, am arop támao maok Kwaro nke námp fek nareki yak námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jisas takrá séri pwaránko, Jono man sérrá, “Arop Tokwae, yino nke nánko, arop ankwap waráp e fek arop pouroukamp kwatae-arop fákáreran yéréperá kérép námpao maok, mao te nomont waráp wakmwaek yárak mo námpantá, yino man taokoranámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aeránko maok, nopok Jisaso man sérrá, “Yumo man taokor kwapono. Arop yumwan yopor mo námp te yumonap mwaek yaknámp arop támaono.” ");
INSERT INTO yuj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kwaro Jisasén warámpea yámar mek pok naenámp yae wae fae nánko, Jisas wae nɨnɨk sámpea Jerusalem mek akwap naeria nɨnɨk kárákárea wae námpono. ");
INSERT INTO yuj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aeria maok, apár Galili pwarará arop ankwap manmékɨr ankank nánap mwanapria tirá kérép nánko, am fárákap tukupea Samaria mekamp némp ankwap mek. ");
INSERT INTO yuj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Aenapan maok, am némpoukamp arop fárákapao Jisas mao Jerusalem mek tukup mwaria napantá, am fárákap te, náráp nap mek korop te monoria wae. ");
INSERT INTO yuj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tak napo maok, Jisas éréképá yárak i konámp arop yawor Jems ntia Jon am wawia Jisasén sérrá, “Tokwae Kar e! Yino Kwarén sénánko, yámar mekamp yaomwi tokwae sámp-kérép nánko ékia mámá arop ponankor wurukumpi pwar naenámp te mokopono?” ");
INSERT INTO yuj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Aerepo maok, tá Jisaso sámp-arákarrá am arop yaworan yopor. ");
INSERT INTO yuj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aeria maok, Jisas maomp am fákáre éréképá tukupea ankwap némpouk pampiapon. ");
INSERT INTO yuj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jisas náráp arop fárákap éréképea tukupá mwaeaok napo maok, arop ankwapao man sérrá, “Amo apae némpouk akwap nap te, ono fwap amont akwap nanampon.” ");
INSERT INTO yuj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aeránko maok, táte Jisaso man sérrá, “Mwaep te me mek pamp i konapono. Tá ant te taok mek pamp i konapono. Aeno Aropamp Táráp te mao akwapea yépe kour norokarea amp naenámp nap te yak mono.” ");
INSERT INTO yuj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aeria maok, arop ankwapan sérrá, “Amo te ononampaok koropae.” Aeránko, tá am aropao sérrá, “Ae te onomp naropwarén yépékia sumpwi nánko pátea korop nae.” ");
INSERT INTO yuj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tá Jisaso man sérrá, “Wampweno. Arop sumpwi te námoku surumpwi mwanap aropao yokoropea papanápono. Aeno amo te akwapea Kwaro maomp firáp taokeyak konámp farákápae.” ");
INSERT INTO yuj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Arop ankwapao Jisasén sérrá, “Tokwae Kar e! Ono te amonapok korop naenampan, ono akwapea onomp nouroup arop fárákap yae koukoupwiyakea pwatea korop nanamp te mokopono?” ");
INSERT INTO yuj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tá Jisaso nopok man sérrá, “Arop Kwaromp tére naerianámpao, pwatarinámp ankank fek warko nɨnɨk námp te, mao te Kwaromp tére naenámp pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wakmwaek Tokwae Karao 72 arop ankwap fárákap téreanáponoria, wakmwaek námoku yárakrá akwap nanamprianámp némpouk mwaek anánánkrá manénkɨr tukupenkria tirá kérép. ");
INSERT INTO yuj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aeria mao arop Kwaronámpok korop mwanapan nɨnɨkria am fárákapan wounáprá sérrá, “Yopwar mekamp fɨr kápae kare wae noumouri yak námpan maok, am fɨr tére mwanap arop te kápae kare mo napon. Aenapara, yumo ankár yopwar Naropwarén sénapo, mao fwap am fɨr tére mwanap arop tirá kérép nánko, tukupea náráp fɨr tirá koupoukour mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yumo tukupenke! Yao pwae mekamp as niamp arop ou mek yumwan sipsip moroknámp tirá kérép nampon. ");
INSERT INTO yuj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mani yam, ankank kér i konap yam, su, yumo mámá ankank tia tukup kwapon. Yumo mwaeaok arop kɨkɨpria te, man ‘Gude’rá séria am fek yakáprá kar séri kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yumo ankwap nap mek tukup nap kwamp te, manénkɨr yumo ankár arakrá sér kip: ‘Ono nɨnɨk namp te, Kwaro mámá nap mekamp koumteouráp arop yumwan yonkwae porokwe sánkanoria nampon.’ ");
INSERT INTO yuj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aerá sénapo, am nap mek yonkwae porokwenámp arop yak mo nánko te, yumo am fárákapan sénap yonkwae porokwe kar am te yumokuráp nɨnɨk mek arákarrá korop naenámpon. Aeno táte yonkwae porokwenámp arop yak nánko te, am yumo sénap yonkwae porokwe kar maomp nɨnɨk mek akwapá yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tak nánko te, yumo ankár am nap mek saráp yakáp kip. Aeria maok, yumwan fɨrráp ént nénk napo te, ankár táman fépér kip. Am te apae riteanápe, térenap aropara, nopok kuri fwap sámp mwanapon. Yumo te kápae kare nap mek paokopi kwapon. ");
INSERT INTO yuj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yumo tukupea ankwap taun mek napo, yumwan nkea, fwaprá korop naponoria, nap mek éréképá tukupea, yumwan fɨr nénk napo te, táman fépér kip. ");
INSERT INTO yuj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Takria maok, yumo ankár am taun mekamp touwenap arop fwapokwaprá kákria maok, yumo ankár kar arakrá farákáp kip: ‘Kwaro náráp firáp taokeyak konámp yumonapok korop naenámp ke te wae wonae fik námpon.’ ");
INSERT INTO yuj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Aeno yumo ankwap taun mek napo, yumwan, fwaprá korop naponorá sér moria, náráp nap mek éréképá tukup mo napo te, yumo am taun mekamp mwaeaok am fek yakáprá sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yiráp mámá taun mekamp woup kwar yinomp su fek kárákapá yak námp te yumokunapok arákarrá poporokompi pwar námpon. Aeno yumo fwapia nɨnɨk kipo: Kwaro náráp firáp taokeyak konámp korop naenámp ke te wae wonae fik námpono’rá sér kip.” ");
INSERT INTO yuj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jisas am fárákapan arakrá toropwapia pwarará, warko ankwap kar sérrá, “Ono yumwan sénampono: Pwar naenámp yae fek te Sodom mekamp aropao kwatae kareapo, Sodom mek kwatae kare ankank tokwae korop naenámpan maok, am Kwarén younkwe sɨnap aropamp taun mek korop naenámp touwe te yoporop tokwae kar korop naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jisas am fek warko sérrá, “Yumo Korasin mekamp arop, koupoutáráp nape! Yumo Betsaida mekamp arop, koupoutáráp nape! Arop ankwap taun Taia ntiaka Saidon mek akwapea ono yumo ou mek yoro namp niamp Kwaromp kárákáre yoro nánko nkeria te, am taun Tair ntiaka Saidon mekamp arop wae kwatae nɨnɨk pwarará, yonkwae touweria yirɨr i konap waempyam yirɨria, yaomwi ntu mek tankápria Kwaronámpok tukup mwarapono. ");
INSERT INTO yuj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nánkárap Kwaro koumteouráp aropan énounkoupia Tair ntia Saidon mek sánkámp touwe kwatae te tokwae karan maok, yumwan sánk naenámp touwe kwatae te yoporop tokwae karono. ");
INSERT INTO yuj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tá yumo Kaperneam mekamp arop yumoku támao ‘Yino te kwapwe kare ritea yámar mek pok mwanámp’ ritea nape? Mono. Yumo te waeman yaomwiráp me tokwae mek pɨk mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aerá séria pwarará maok, warko mao am éréképá yárak i konámp arop fárákapan sérrá, “Arop yiráp kar wa námp te, mao onomp karan kuri wa námpon. Tá arop yumwan younkwe sɨnámp te, mao onan kuri younkwe sɨnámpon. Tá arop onan younkwe sɨnámp te, onan sámp-kérép nánko ék namp Kwarén kor man younkwe sɨnámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wakmwaek 72 arop fárákap arári koropea warákáránkria Jisasén sérrá, “Yinomp Arop Tokwae, yino waráp e fek sénánko, am kwatae-arop fárákap yino sénámpaoki napono.” ");
INSERT INTO yuj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tá Jisas am fárákapan sérrá, “Ono nke nanko, yumo tak nap fek Satan yámar meknámp mékér wae niampao éká párákap námpon. ");
INSERT INTO yuj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yumo wawenke! Ono yumwan wae kárákáre nénk nampara, yumo fwap fou-tákam ntia kao pumpuri anámpria, yumo yiráp yopor arop Satanomp yorowar kárákáre fwap kwe-pwar mwanapono. Yumwan touwe sánk naenámp ankank ankwap yak mono. ");
INSERT INTO yuj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Aeno kwatae-arop yiráp karwaok tukup nap táman saráp warákár tokwae kwapono. Yumo warákár tokwae mwanap te, Kwaro yámar mek yiráp e kukumwia páte námpan warákár mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jisaso am arop fárákapao farákápnap kar am wawia, Yiki Kor Spirit man warákár sánk nánko, warákárria náráp Naropwarén sérrá, “Onomp Naropwar e! Amo yámar ntia apár ponankor taokeyak napono! Amo am ankank mér tokwaerápia nɨnɨk kour kwapwenap aropan yénkép mono. Párák némpoukamp aropan saráp yénkép nap táman ono amwan ‘Aesio’rá sér rae. Yeno, Ayao, amo amokuráp nɨnɨkaokria tak napono.” ");
INSERT INTO yuj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aerá séria pwarará, warko am arop fárákapan sérrá, “Onomp Naropwar onomp yaek kápae kare ankank ponankor pap námpono. Arop ankárankamp Kwaromp Tárápan mér kari yak mono. Naropwaro saráp námokuráp Tárápan mér kari yak námpon. Tá arop ankwap Naropwarén mér kari yak mono. Táráp námoku ntia Tárápao náráp Naropwar yénképnámp arop fárákap támao saráp Naropwarén mér kari yakáp napon.” ");
INSERT INTO yuj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jisas takrá séri pwaránko maok, mao éréképá yárak i konámp éntér-sámpramp arop fárákapao mwar Jisasént yakáp napo, am fárákapaonapok sámp-arákarrá am fárákapan nkeria maok, arakrá sér, “Yumo nkenap ankank mámá arop ankwap fárákapao nke nap te, fwaprá kar nke napara, warákár mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ono yumwan sénampono: Wokwaek kar kápae kare profet ntia kápae kare king oukoumwan yumo nkenap ankank má nke mwanámpria yépékapao maok, nke moiapon. Tá am fárákapao oukoumwan yumo wanap kar má wa mwanámpria yépékapao maok, oukoumwan wa moiapon.” ");
INSERT INTO yuj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ankwap ke fek lo kar méri yaknámp arop ankwap Jisasomp wonae fik koropea, Jisas te mokoprá séran wa nae ritea Jisasén turunkrá, “Tisa, apae mokopia yiki yak kwapwe sámpea yaká yak nanampon?” ");
INSERT INTO yuj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tá Jisaso man sérrá, “Lo fek te apae kar yak námpon? Amo te mokoprá farákáp napon?” ");
INSERT INTO yuj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tá mao maomp kar pwarokwaprá sérrá, “Waráp Kwar Tokwae Karan te amo ankár waráp yonkwae kare ponankor, waráp waemp ponankor, waráp pourou ponankor, waráp nɨnɨk ponankor warákárampo. Tá amo ankár waráp firáp aropan warákár nap te amoku waráp pourouran warákár konapnámp taknámpampo.” ");
INSERT INTO yuj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tá Jisaso man sérrá, “Yeno. Am támaono! Amo yae-párák kare sénapono. Amo takria maok, amo yiki yak sámpea yaká yak nanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Táte am lo mérnámp aropao nɨnɨkrá, námo wae méri yak nampan turunkria, pwarápae sáp námpwaeria maok, warko Jisasén turunkrá, “Onomp firáp arop te wan sénapon?” Tá nopok Jisaso wounáp kar man arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","“Arop ankárankampao Jerusalem meknámp Jeriko mek pɨk naeria nánko, oukun arop fárákapao mwaeaok yéréréki yakápia man sámpá tankáprá fukia sɨrarrá, kwapwe kare ankank pourouk yakáp námp woropea tukup. Aetenapo, am arop mwaeaok taki tankrá, wae sumpwi naenámp pourouráp. ");
INSERT INTO yuj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tá am ke fek pris tére konámp arop ankárankamp am mwae páraok pɨkia akwaprá am aropan nke námpao maok, kámá-pwarará mwae firi warákarrá akwap. ");
INSERT INTO yuj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tá taknámp, Livai ankwapao kuri koropeaka am arop tank námp fek námpao, am aropan nkea kámá-pwarará mwae firi warákarrá akwap. ");
INSERT INTO yuj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aenepan maok, apár Samaria mekamp arop ankárankamp am mwae-páraok koropea am arop tank námp fekria, mao am aropan nkea maok, man aropomp kare. ");
INSERT INTO yuj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mao am aropamp wonae fik akwapea am fukinap toupou mek wel ntia wain kwarákarea, am ankáráp foupouia pwar. Aea maok, am arop kakapea námokuráp donkimp pourouk papea sámpá akwapea arop néntép konap nap mek paprá taoke-samp amp. ");
INSERT INTO yuj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ampia koumounek mao am nap naropwarén mani silva anánkaopwe sánkria maok, man sérrá, ‘Amo mámá arop má fwapi taokeyakampo. Tá waráp mani ankwapmwaek maomp pourou fek pwaránko te, nánkár ono arákarrá korop namp fek am nopok amwan sánk nanampon.’” ");
INSERT INTO yuj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisaso am wounáp kar farákápria maok, am lo mérnámp aropan turunkrá sér, “Amo má kar wawia mokoprá nɨnɨk rap? Mámá yinɨnkaopwe arop te wa mokop arop oukun aropao fuki sɨrarinap aropan maomp firápan i konapnámp taknámp námpon?” ");
INSERT INTO yuj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tá am lo mérnámp aropao man sérrá, “Am arop man aropompia man yaewourámp te támaono.” Jisaso man sérrá, “Amo akwapea amo kuri am táman taknámpampo.” ");
INSERT INTO yuj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tá Jisas ntia mao éréképá yárak i konámp arop fárákap énénki takrá tukupea mwaeaok napo maok, tá Jisas ankwap némp kánanke mek akwap nánko, yupu ankwap, maomp e te Marta, mao Jisasén warámpea náráp nap mek akwap. ");
INSERT INTO yuj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martamp nánae te Maria. Jisas Tokwae Karao narek tank nánko, Maria koropea maomp wonae fik pu páte tank námp fek tankrá mao sénámp kar wará tank. ");
INSERT INTO yuj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta te námoku fɨr yankaprá, kápae kare ankank nánaprá, mao te námwan yaewour mo námprá nɨnɨka wae. Aeria maok, Marta akwapea Jisasén sérrá, “Tokwae Kar e! Onomp nánae te onan pwate nánko, onoku nápar fɨr nánaprá tére nampono. Amo am te nɨnɨk mo rape? Amo man sénapo, mao koropea onan yaewourano.” ");
INSERT INTO yuj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Táte Jisas nopok man kar pwarokwaprá sérrá, “Marta kwae! Amo te kápae kare ankankan nɨnɨk tokwae napon. ");
INSERT INTO yuj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Amo te ankár ankárankamp ankankan saráp nɨnɨkae. Mámá ankank Maria sámp naerianámp te kwapwe kare ankankara, nomo te maomp yaekamp pwarokwapá pap mono.” ");
INSERT INTO yuj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ankwap kumuruk Jisaso akwapea ankwap fek yakrá Kwarén kar toropwap. Mao kar toropwapia pwaránko, wakmwaek mao éréképá yárak i konámp arop ankwapao man sérrá, “Tokwae Kar e, amo yinan Kwarén kar toropwap i konap nɨnɨk yénkrá farákápae. Arop ént mek nér i konámp Jono mao éréképea yárak i konámp arop fárákapan yénkrá fárákapámpnámp yinan kor takae.” ");
INSERT INTO yuj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tá mao am fárákapan sérrá, “Nánkár yumo Kwarén kar toropwap mwaria te yumo arakrá sér kipo: ‘Ayao! Yino nɨnɨk námp te, arop ponankor waráp e te yiki karenorá nɨnɨkanápono. Tá waráp firáp taokeyak nanap ke ankár koropano. ");
INSERT INTO yuj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fɨr kumur méntép fár mwanámp puri fek ti-sápampo. ");
INSERT INTO yuj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Amo yinomp kwatae nɨnɨk nɨk mo, pwarampo. Am te apae riteanápe, Arop fárákap yinan napo, yino maomp kwatae nɨnɨk nɨk mo pwar konámpono. Amo yinan mokop nap nke naerianámp ankank mek kwatae mwaek párakop kwapono.’” ");
INSERT INTO yuj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tá mao am fárákapan sérrá, “Táte yumo ou mekamp arop ankárankao maomp nouroup arop ankwap yak nánko, kumur kupuk mao akwapea am nouroupén sérrá, ‘Nouroup o! Amo onan pan yinɨnkaopwe sápae! ");
INSERT INTO yuj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Onomp nouroup ankwap kumuruk korop nánko, man sánk nanamp fɨr tank mono.’ ");
INSERT INTO yuj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tá am nap mekamp arop maomp kar far-pwarará sérrá, ‘Wae ménki kéri yak nánko, tárápu tia amp rae. Ono fárámpea amwan ankank sánk nanamp pourou moiane. Onan kéménki kwapono.’ Ae te mokop nae-námpono? ");
INSERT INTO yuj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ono yumwan sénampono: Am nap naropwaro náráp nouroupén nɨnɨkria am fek man ankank sánk mono. Mao wumwinámp kar wa te ankár kokwae kareria maok, mao fárámpea mao monámp ankank am ponankor nénk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ono yumwan sérrá: Yumo ankank moria Kwarén sénapo te, am monap ankank fwap yumwan nénk naenámpon. Yumo ankár am monap ankank oupourounkria maok, yumo fwap nke mwanapon. Yumo ankár ménki fek poporokwap napo, Kwaro yumwan ménki kɨk-pwar naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Am te apae riteanápe, arop, námo am ankank sámp naeria Kwarén sénámp te, ankár am táman sámp konámpon. Arop, ankank sámp nae nɨkia oupourounk námp te waeman táman nke konámpon. Arop, námwan ménki kɨk-pwaraeria poporokwap nánko te, Kwaro man ménki kɨk-pwar naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Táte yumo ou mekamp arop ankwapamp tárápao náráp naropwarén ‘Námwan éntékam sápae’rá sénánko te, am naropwar te fwap am sénámp pwarará, tákam-ti sánk naenámp nie? Mono. ");
INSERT INTO yuj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Táte tárápao naropwarén sérrá, ‘Námwan kae sápae’rá sénánko te, am pwarará kao kwatae sánk naenámp nie? Am támao kuri mono. ");
INSERT INTO yuj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yumo apárokamp kwatae nɨnɨkráp arop wuriman, yiráp tárápan kwapwe kare ankank kwaporok sánk konapono. Taknámp, yumo fwapia mér kar mwanapon: Yámar mek yaknámp yiráp Naropwar te námwan sápaeria kar toropwapnámp aropan Yiki Kor Spirit man sánk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Arop ankwap kwatae-aropao maomp top kor me kéri fákeyak nánko, Jisaso am kwatae-aropan yéréperá kérép nánko maok, am top kor me kéri yaknámp arop wae fwap kar sér. Aenánko maok, koumteouráp arop am táman nkea korokop. ");
INSERT INTO yuj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aenapan maok, arop ankwap fárákapao sérrá, “Mao te kwatae-arop poukeyak konámp Satanomp kárákáre fek kwatae-arop yéréperá kérép námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tá arop ankwap fárákapao, mao te mokoponrá nke mwar ritea am fárákapao man sérrá, “Amo kárákáre ankwap yoro napo, yino nkeaka Kwaromp kárákáre amont yak námpan mér mwanámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aenapo maok, Jisaso am fárákapamp nɨnɨk wae méria, mao am fárákapan sérrá, “Táte arop maomp fi taokeyak námp kuk pɨrékarea yorowar nánko te, am fi te kwatae akwap naenámpon. Táte ankárank fi mwearoao kuk pɨrékarea yorowar nap te, am mwearo fwapi kénki yakáp mono. ");
INSERT INTO yuj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tá taknámp Satanomp fi kuk pɨrékarea yorowarria te, mokopia ankank poukwap mwanap kárákáre sámp mwanapon? Aeno yumo mokopia ‘Satanomp kárákáre fek kwatae-arop yéréperá kérép námpono’rá sénapon. ");
INSERT INTO yuj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tá kare Satan onan yaewour nánko, ono kwatae-arop yéréperá kérép nanko te, wa yiráp arop fákáreran yaewouria kwatae-arop fákáre yéréperá kérép naenámpon? Aenámpara, yumoku yiráp arop fákárerao yiráp kar yurukup napo te, pwi yak mo naeria námpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aeno táte Kwaro onan kárákáre sáp nánko, ono kwatae-arop yéréperá kérép nanko, Kwaro náráp firáp taokeyak konámp te wae yiráp wonae fik korop námp mér mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Táte kárákáre kor arop ankwap oump ankank tia náráp nap-topok arop koropantá yérék nánko te, maomp nap mekamp ankank fwap tankáp naenámpono. ");
INSERT INTO yuj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Aeno táte arop ankwap kárákáre kor karerao koropea am aropan yorowaria kwe-pwararea maomp yaekamp am fek yorowar naenámp nɨnɨk kárákáre sámp konámp oumpráp ankank pouroukoupea ti-akwapea arop ankwap fárákapan nénk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Arop onomp nouroup mo námp te, mao te onomp yopor aropono. Arop onan yaewourria koumteouráp aropan ankára mek tirá koupoukour mo námp te, am fárákapan ti-yérépe nánko pɨrɨkɨmp konapon.” ");
INSERT INTO yuj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jisaso ankwap kar sérrá, “Táte kwatae-arop arop pourouk woukoupeyak námpao worékár akwapea, mao kwar saráp mek yárakrá, am mek anepér naenámp apár oupourounk nánko, yak mo nánko te, warko mao sérrá, ‘Ono am wokwaek yakamp nap mek arákarrá akwap nae!’ ");
INSERT INTO yuj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aeria maok, akwapeaka am nap nke nánko, am nap tɨri farákápea, ankank fwapokwapia pwate. ");
INSERT INTO yuj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aenánko maok, mao warko akwapea, fákánek kwatae-arop fárákap maomp kwatae nɨnɨk kámákár námp éréképá koropea am nap mek yakáp. Aenapo, wokwaek am arop maomp pourou kwatae-arop yakánko, kwatae yakámpao maok, oukoumwan te warko ankár porok kwatae kare arop yak námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kápae kare koumteouráp arop yakápapo, Jisas má kar farákápámpon. Aenko yupu ankwap am ou mek yakámpao Jisasén arakrá sér, “Am yupu wokwaek amwan fárákapea amwan mom wurumpámp, mao maok warákár naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tá Jisaso sérrá, “Mo, arop fárákap Kwaromp kar wawia mántwaok nap te, am fárákapao saráp fwap warákár mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kápae kare koumteouráp arop fárákap koropea koupoukour yakápapo, Jisaso am fárákapan sérrá, “Mámá ke fekamp arop fárákap te kwatae nɨnɨkráp arop fárákapono. Am arop fárákapao sérrá, ‘Krais támaonorá yénképnámp kárákáre yoro napo, nke mwaro.’ Aerapan maok, ono am fárákapan am yénkép mono. Profet Jona yénképámp ankankan saráp yénkép nanampono. ");
INSERT INTO yuj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona éntékamamp yare mek yinɨnki yakea érik korop nánko, Ninive mekamp arop fárákapan Kwaro man sámp-kérép námpan yénkép námpon. Táte taknámp, Aropamp Tárápao kor apár me mek yinɨnki yakeaka fárámp nanko, mámá ke fekamp arop fárákapan Kwaro onan sámp-kérép námp yénkép nae námpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wakmwaek Kwaro arop fárákapan yurukupnámp ke fek, Siba fi mekamp kwino mámá ke fekamp arop fárákapént fokopeyakria, mámá ke fekamp arop fárákapamp kwatae nɨnɨk érik farákáp naenámpon. Am te apaeria námpanápe, am kwin te maomp apár panek faek karaok yak námpao koropea King Solomono farákápámp nɨnɨk kour wawi námpono. Aeno mapek yaknámp arop ankárankampamp nɨnɨk kour te Solomonomp nɨnɨk kour kámákár akwap námpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Taknámp wakmwaek Kwaro arop fárákapan yurukup naenámp ke fek Ninive mekamp arop fárákap foukouri yakápria oukoumwan má ke fek yakápnap arop fárákapamp kwatae nɨnɨk érik farákáp mwanapon. Am te apaeritea námpanápe, am Ninive mekamp arop fárákap Jona Kwaromp kar farákáp nánko, wawia kwatae nɨnɨk pwarará, Kwaronámpok tukupapono. Aeapara, oukoumwan mapek yaknámp arop ankárankampao farákápnámp kar te Jona farákápámp karan kámákár akwap námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tá Jisaso warko ankwap kar arakrá sér, “Arop lam pounkouroupea nap te mek pap mo, tap woukwapá pap mo i konámpon. Narek kákánar fek páte napo, arop am nap mek koropria kor, am lam wae táman nke mwanapria. ");
INSERT INTO yuj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Waráp yi te waráp pouroukamp lamono. Waráp yi kwapwe kare nánko te, waráp pourou mek kuri wae kwapwe námpon. Aeno waráp yi kwatae nánko te, waráp pourou mek ponankor kɨrɨkɨp námpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aenámpara, amo fwapia mérampo: Takria waráp pourou mek kɨrɨkɨp koropantáno. Waerao saráp yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Waráp pourou mek ponankor wae kwapwe yak nánko, ankwapmwaek kɨrɨkɨri kɨrɨkɨp mo nánko te, waráp pourou mek ankár wae pouri yakria, lam waerao amwan tákapnámp niamp naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisaso am kar farákáprá séri pwaránko, Farisi ankwapao, námont koropea fáraeria wumwi. Aenánko Jisas wae maomp nap mek akwapea fánaeria tank. ");
INSERT INTO yuj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tá Farisi tankrá nke nánko maok, Jisas te Juda firao i konap nɨnɨkaok yae yárár moi tetankrá fɨr fánánko maok, am Farisi te, Jisas máte apaereaneria nɨnɨka wae. ");
INSERT INTO yuj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aenámpan maok, Jisas man sérrá, “Yumo Farisi yumo te kap ntia plet younkwe mwaek saráp yárár napon. Aeno mek te kɨkiank nɨnɨk tá nkwakwe make kwatae nɨnɨkao top pwarámpá yak námpono. ");
INSERT INTO yuj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yumo te épépérép aropono! Kwar te ankank pu-pwaek saráp yororia mek kuri yoro moi námp nie? ");
INSERT INTO yuj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aeno ankank yiráp nɨnɨk mek yak námpan, ankank monap arop fárákapan yaewouranorá nénk kipo. Tak napo maok, yumo térenap ankank te fwap yiki kukur yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Aeno yumo Farisi, yumo te fwapia mér kip! Yumo te fɨr mek sɨrarrá fépér i konap nánákáre konámp ankank tia fére-sámpramp fi papea, Kwarén ankárankamp fi sánk konapan maok, yumo ankwapan yae-párák kare nɨnɨk i konap ntia Kwarén warákár konap nɨnɨk te pwar napon. Aeno yumo te anánkaopwe nɨnɨk méntér téreria ankwap lo pwar mo napo maok, am te yae-párák naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yumo Farisi, yumo te fwapia mér kip! Yumo te lotu nap mek, arop námwan nke nap fek tankáp mwar kar, tá yumwan koumteouráp aropao koupoukourap mek, ‘Gude’rá séranáponorá kɨkiank i konapono. ");
INSERT INTO yuj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yumo fwapia mér kip! Yumo te arop yákáre apár me mek papea oupouri pwatea napo, arop fárákap mér moria, am yumuntukaok paokop i konapono.” ");
INSERT INTO yuj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Táte lo méri yakápnámp arop ankwapao man sérrá, “Tisa, amo takrá sénap te, amo yinan kor kar kárákáre fek wouroumprá sénapon!” ");
INSERT INTO yuj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tá Jisas sérrá, “Yumo lo méri yakáp nap arop fárákap, yumo kor fwapia mér kip! Yumo kápae kare lo kánanke-táráp kák napo, koumteouráp arop ampaokrá paokopria, am lo kápae táman mokopi mokop mwarria kounkour napon. Aenapao maok, yumoku te am fárákapan kánanke yae paprá yaewour mo kar napono. ");
INSERT INTO yuj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yumo fwapia mér kip! Wokwaek yiráp appeyaenápo profet fárákapan yénképrá kák tenapo, yumo am apár me kwar yu fek sank moporrá párakop napon. ");
INSERT INTO yuj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yumo am taknap nɨnɨk te arop fárákapan yénképrá: Profet fákáreran yénképrá kákap te, fwaprá kari naponorá nɨnɨk napon. Am te apae riteanápe, mao profet fákáreran yénképrá kák tenapo, yumo maomp kwar yu fek sank moporrá paokop napon. ");
INSERT INTO yuj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Aenapantá yonkwae kour kwapweráp Kwaro wokwaek arakrá sér: ‘Ono profet ntia aposel fákáre tirá kérép nanko, arop fárákapao ankwap fárákapan sámpá yampourourá, ankwapmwaek yénképrá kák mwanap’ rimpon. ");
INSERT INTO yuj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Wokwaek Kwaro apár yoro námp fek, Abel feknámpia, profet fákáreran yénképrá kákrá koropea, Sekaraia Kwarén ofa sánk konap alta ntia lotu nap tokwae yak nánko, amore mek sumpwi námpon. Aeno mámá ke fekamp aropan te Kwaro nopok touwe kwatae sánk naenámpon. Ye, ono yumwan sénampono: Takiap fekamp touwe te, oukoumwan mámá ke fekamp arop fárákapao am fek touwe kwatae sámp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yumo lo méri yakápnap arop fárákap, yumo fwapia mér kipo! Yumoku támao Kwarén mér kokwaeria, arop ankwap fárákap am mér sámp mwaria napo, yumo mwae kéri fákeyakáp napon.” ");
INSERT INTO yuj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisas takrá séria, am nap pwarará, ek akwap nánko, lo yénkrá farákáp konap arop fákáre ntia Farisi fárákap yonkwae popwarámpria téréménka waerá, Jisas te apaerá séran wa mwarria kápae kare nkwakwe make kar man turunkup. ");
INSERT INTO yuj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Am fárákap te, man kot mwanámp karan séri kanrá am mao sénámp kar wará yépékrá yakápiapon. ");
INSERT INTO yuj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kápae kare fopwakwap arop koupoukareaka, fákappéri yakápria, ankwap fárákapamp pu topwe fek pumpur mwanap niamp pourouráp. Am ke fek táman maok, Jisas námoku éréképá yárakimp aropan sérrá, “Yumo Farisi fákáreramp yis fwapnae karia mér kipo. Ono te aran sénampono: Arop nke nap fek te kwapwe kare paokop napao maok, maomp nɨnɨk mek te kwatae nɨnɨk yak námpono. ");
INSERT INTO yuj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kápae kare ankank mek wouroumpeyak námp te, nánkár wakmwaek érik yak naerámpon. Tá kápae kare kánánkámp sérarap karao kor arop ponankor am kar mér mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ae mwarea napara, kápae kare kar yumo kumuruk sérar nap te, kápae kare arop yámaraok wa mwanapon. Tá ankwap karan kor yumo nap mek ankwap aropan kánánkámp sánánkar séri napan kor, am kar nánkár némp kupuk fokopeyakáprá érik sérar mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jisaso warko ankwap kar sérrá, “Ononamp fákáre, ono yumwan arakrá sér rae: Arop pourouran saráp sámp-wouroumpria, waempén kwatae pap mwanap pourou monámp arop táman apápi kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aeno ono yumwan, wan apáp kiprá érik sénae nae: Yumo ankár Kwarén apáp kipo. Kwar te arop porokwap pap námp kwamp te, am arop yaomwi mek sɨnaenámp kárákáre fákeyak námpon. Aenámpara, ono yumwan waeman kar sénampon: Yumo ankár Kwarén apáp kipo. ");
INSERT INTO yuj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Yumo te waeman mér napono: Arop ant kánanke éntik sámp nap te 2 toea fek sámp konap wuriman, Kwar te am ant kánanke te nɨk mo mono. Waeman méri yak námpon. Aenámpara, yiráp me korkamp me pwaeran kor ponankor kouroumpea mér kare námpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aeno arop yumo te Kwaro nke námp fek am ant kánankeran kámákár tukup napara, apápi kwapon.” ");
INSERT INTO yuj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jisaso warko ankwap kar sérrá, “Ono yumwan sénampon: Arop koumteouráp aropan sérrá, ‘Námo te onan maomp firáp yak nampono’rá sénánko te, Aropamp Tárápao kor Kwaromp ensel fákáreran ‘Mámá arop te náráp firáp aropono’rá sénaenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aeno arop koumteouráp aropan ‘Námo te onan maomp firáp mekamp arop mono’rá sérianámp te, Kwaromp Tárápao kor Kwaromp ensel fákáre wa nap fek ‘Mao te onomp mono’rá sénaenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Arop ankwapao Aropamp Tárápan wouroump nánko te, tá fwap Kwaro maomp am kwatae nɨnɨk sámp-sɨnaenámpon. Aeno Yiki Kor Spiritan wouroump nánko te, Kwar te am maomp am kwatae nɨnɨk te sámp-sɨr mono. ");
INSERT INTO yuj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nánkár yumwan éréképea tukupeaka lotu nap mek, tá Gavman, tá arop taokeyakáp konap nke nap fek yumwan kot naenánko, yumo apápriaka, yino te apae mokope kar pwarokwaprá sér mwareanoria apápi kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nánkár taknap ke fek táman, yumwan Yiki Kor Spiritao, ará kar arakrá sérenkria yénkép nánko, fwap sér mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kápae kare arop néntépria maok, ankwap ankárankao Jisasén sérrá, “Tisa, onomp naropwar sumpwi nánko, onomp ankank onomp naerao sarápnámp, amo akwapea sénapo, onan ankwapmwaek pɨrékarea sápano.” ");
INSERT INTO yuj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aeránko maok, Jisaso am aropan sérrá, “Wɨ! Onan te wa yiráp ankank yurukup nanamp arop yoroi páte nánko, ono yiráp ankank pɨrékarea nénk nanampanápe?” ");
INSERT INTO yuj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aeria maok, Jisas koumteouráp aropan arakrá sér, “Yumo fwapnae karia mér kipo: Yumo takria nkwakwe make ankank sámp mwaria kɨkiank mwanape. Arop kápae kare ankank tinámpao maok, mao te am ankank fek yiki yak sámp naenámp pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aeritea maok, Jisas am fárákapan wounáprá sérrá, “Maniráp arop ankwapamp yopwarkamp fɨr kápae kare tankáp nánko maok, ");
INSERT INTO yuj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","am maniráp aropao nɨnɨkrá, ‘Ae te kák nanamp nap pwi mo námp te, mokop nae? ");
INSERT INTO yuj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Arak nanampon: Mámá nap warko pápárámpia fákeyakrá, tokwae nununkwi tiria maok, onomp witráp kápae kare ankank kwapwe kare mámá am nap mek kák nanampon. ");
INSERT INTO yuj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ono te onoku támao arakrá sér: Ono oukoumwan te kápae kare ankank kwapwe kare nampara, fwap kápae kare yopwar fek yak nanampon. Oukoumwan te ono anepéri yakrá, fɨr kwapwe fárrá yakrá warákár nanampono.’ ");
INSERT INTO yuj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Aenámpan maok, Kwaro man arakrá sér, ‘Amo te épérép kare aropono. Amo oukoumwan kumuruk saráp sumpwi nanape. Amo am ankank koupoukareaka kák tenap te, wa sámp naenámpono?’” ");
INSERT INTO yuj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jisaso mámá wounáp kar séria pwarará maok, arakrá sér, “Mámake pourouráp ankank te kápae kare ankank koupoukournámp aropamp pourouk korop naenámpon. Aenámpan maok, Kwaro nke námp fek te ankank moráp arop yak námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aeria maok, Jisaso námoku éréképea yáraknámp aropan sérrá, “Yumo te yiráp pourouantá apápriaka, arakrá sér mwanape: ‘Nomo te apae fɨr sámpea fár mwareano?’ ria nɨnɨka wae, tá ‘Maokamp waempyam sámpea yirɨr mwareano?’ ria nɨnɨk tokwae kwapon. ");
INSERT INTO yuj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yiráp yiki yakáp nap te waeman fɨran kámákár akwap, tá yiráp pourouao kor waempyaman kámákár akwap námpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yumo te antan nɨnɨk kipo. Ant te yopwar yoroitea fɨr tirá koupoukour mo i konámp. Tá fɨr tirá kák konap ap nap sámpá yak mo i konámpan maok, Kwar támao man fɨr nénk konámpono. Aeno arop yumo te tokwae kar ankankara, Kwaro yumwan waeman mér námpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tá yumo ou mekamp arop ankwapao námoku fwapi yak naenámpan nɨnɨk tokwaeria te, am nɨnɨk tokwae námp fek tapek mao yiki yak naenámp ke warko ér-sakwaprá pap naenámp nie? Tak naenámp pourou mo kareno. ");
INSERT INTO yuj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aeno yumoku mwar am ankank kánanke tak mwanap pourou mo námp te, apaerá ankwap ankankantá nɨnɨk kápae napon? ");
INSERT INTO yuj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yumo te yao fuan mokoprá yakreanrá fwapia nke kipo. Mao te waempyam yoro mo i konámpono. Aeno ono yumwan sénae namp te, wokwaek kar king Solomono kor kápae kare kwapwe kare ankank moporimp te, am yao fu émi niamp kwapwe kare takeniamp mono. ");
INSERT INTO yuj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kare karono, yopwaraok apwar oukoumwan yak námp te, tá oumpouran moropea yaomwi mek yank i konapono. Take pourouráp apwar pwae kánanke kwatae wuriman, Kwaro fupu kwapwe kák tenámpono. Taknámp táman fwapia mér kip: Kwar te arop yumwan te fwap waempyam ankank nénk naenámpon. Ae naenámpan maok, yiráp Kwarén mér nap te kánanke kwarok námpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mao yumwan taokeyak námpara, yumo te, apae fɨr, apae ént fár mwareanorá nɨnɨka wae kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mámá apárokamp arop fi ponankor Kwarén mér monap aropao saráp maok, am ankankantá nɨnɨk tokwae konapon. Aeno yiráp Naropwar yumo arake ankank fwap ti mwanapria méri yak námpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Aenámpara, yumo te ankár kwapwe kare Kwaro nɨnɨk námpaok saráp nɨnɨka waerá paokop napo, yumwan kor am ankank nénkano mpupo. ");
INSERT INTO yuj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Onomp sipsip ankwap yinɨnk e! Yumo apápi kwapono. Yiráp Naropwar Kwaro yumwan náráp firáp taokeyakáp mwanap sánk nanampria warákár námpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yumo te yiráp ankank ponankor arop, mani fek sámpenkria sánkria maok, am mani sámpea maok, mani monap aropan yaewouria am mani sánk kip. Yumo tak napo maok, yiráp yámar mekamp paus mek top koupour naenámpon. Tá yámar mekamp yiráp waempén yaewour i konámp kwapwe kare ankankan saráp koupoukour kip. Am yámar mekamp ankank pwar mo i konámp, tá oukun i konámp arop te wonae fik korop mono. Tá oumpwe te am ankank fépér mo i konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yumo má kar man nɨnɨk kipo: Am yiráp kwapwe kare ankank tankápnámp némpouk te, am némpouk táman yiráp nɨnɨkao kuri yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jisaso ankwap kar arakrá sér, “Yumo te ankár waempyam fae tákáre fek képéria, yumuntuk sépér fápákamprá, yaomwi poupounkia nánapi yakáp kipo. ");
INSERT INTO yuj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yumo te yiráp arop tokwae yupu warámp riaka, fɨr fáriaka pwarará koroprá ménki kɨk-pwarenk ránko, koupour kɨkɨp mwanámpria yépék i konapnámp taknámp kipo. ");
INSERT INTO yuj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Am arop tokwaerao koropea náráp tére konap aropan nke nánko, pamp mo, yiki tankáp nap kwamp te, warákár konapono. Ono yumwan waeman kare kar sér rae: Nánkár arop tokwae námoku koropea tére arop arákarea tére konap aropan, yumo tankápenk ritea, námoku fɨr yankapea nénk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mao kumur kupuk korop kuni, wakor naenámp ke fek korop kuni, mao koropria nke nánko, am náráp tére konap aropao kor pampi yakáp mo nap kwamp, am tére arop fwap warákár mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yumo te arak i konap aran fwapiaka nɨnɨkrá mér kip: Nap naropwaro oukun arop koropea náráp nap mekamp ankank oukun-tiantánoria námp kwamp te, am arop numwar koropea nap kɨk-pwarará yinkanáponoria pwar mo i konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yumo kor ankár nánapi yakáp kip. Aropamp Táráp yumo, oukoumwan korop mo naenámpan mpwe napo, am ke fek táman korop naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aerá séránko maok, Pita Jisasén turunkrá, “Tokwae Kar e! Amo am wounáp kar sénap tane, yinan saráp sér rape, arop ponankoran sér rape?” ");
INSERT INTO yuj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aeránko maok, Jisaso Pitamp kar pwarokwaprá maok arakrá sér, “Tére taokeyak konámp arop te mokopia nɨnɨk kwapwe sámpea yae-párák náráp tére tére kour naenámpon? Arop tokwaerao take pourouráp tére poukwapnámp arop yoroi páte nánko, náráp tére arop poukeyakria, am fárákapan fɨr nénk naenámp ke fek nénk konámpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Take pourouráp tére arop te fwap warákár kare naenámpon: Nánkár maomp arop tokwae arákarrá koropria mao náráp térerá yak námp nke naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ono yumwan waeman kare kar sér rae: Am arop tokwae náráp tére aropan náráp ankank ponankor poukwap naenámpria pap naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aeno am tére aropao nɨnɨkrá, náráp arop tokwae te koupour korop naenámp pourou monoria maok, tére konap arop ankwapan porokwap, am térenap yupuran kor porokwapria maok, fɨr fárrá, mánmán ént fária épépéréprá yárakria, ");
INSERT INTO yuj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","maomp arop tokwae korop naenámp méria nánap mo nánko, am ke fek táman maomp arop tokwae korop naerámpon. Aeria am arop tokwae te am tére aropan fukia kwatae paprá maok, man kar ták-sɨr konap aropént páte nánko yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tére konap aropao náráp arop tokwaeramp nɨnɨk te wae mér námpao maok, mao ankank nánapia náráp arop tokwaeramp nɨnɨkaok mo námp te, maomp arop tokwaerao man tékén porokwap naerámpono. ");
INSERT INTO yuj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Aeno térenámp aropao náráp arop tokwaeramp nɨnɨk mér moria maomp nɨnɨkaok mo námp te, maomp arop tokwaerao kor man paok ke fek sánánkar tae morok fek porokwap naenámpono. Kwaro arop ankárankan ourour tokwae sánk nánko te, nopok kuri am fek fwapi tére kuno. Táte koumteouráp arop fárákapao arop ankárankampan ‘Námwan taokeyak naenámp tére sánktea, am tére fek fwapia yinan taokeyakae’ ria sérara wae konapon.” ");
INSERT INTO yuj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisaso warko ankwap kar arakrá sér, “Ono ékamp te yaomwi apárok ko-sɨnanko, yaomwi koupour yurunkano karria ék nampon. ");
INSERT INTO yuj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Onan mwar pourouráp touwe tokwaerao oupouroup nánko, sumpwi nanampara, oukoumwan am sámp mo namp kwamp nɨnɨk tokwae nampon. ");
INSERT INTO yuj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ae te yumo nɨnɨk nap te, ono ék namp te, yorowari kwaponoriaka taokor naeria má apár mek ék namp nie? Tak te mono. Ono yumwan sénae: Ono ék namp te koumteouráp aropan kuk pɨr-pwar naeria ék nampon. ");
INSERT INTO yuj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Oukoumwan, tá nánkár wakmwaek kor éntupwar naropwar maomp tárápu nonopok yorowaria, ankwap yinɨnkaopwe yakriaka, ankwap anánkaopweran kar sér, tá ankwap anánkaopwe yakriaka nopok am yinɨnkaopweran kor kar yorowar mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tá ankwap te, naropwaro náráp tárápan yorowar nánko, nopok poumou-táráp náráp naropwarén yorowar naerámpon. Tá éntupwaro náráp yupu-tárápan yorowar nánko, nopok yupu-tárápao kor náráp éntupwarén yorowar naerámpon. Tá éntupwaro tárápamp yupuan yorowar nánko, nopok am tárápamp yupuao kor náráp táparápén yorowar naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisaso koumteouráp arop ouan arakrá sér, “Yumo te warákam ék naenámp yámar wae wuri nkea, ‘Warákam ék naeane.’ Makrá sénapo, tá wae kare warákam ék konámpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tá ankwap te, ouwi korop nánko nkea méria, ‘Máte wae noump ouwirao korop námpono’rá sénapo, am te wae kare noump tank konámpon. ");
INSERT INTO yuj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yumo kwekár i konap arop wuriman, yumo apárok mapek korop konámp ankank, tá yámar mek korop konámp ankank yae-párák yurukup i konap te, apaeritea oukoumwan mámá ke fek korop naenámp ankank nke napao, yumo warko fwapia mér moitea épéréprá paokop napon?” ");
INSERT INTO yuj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jisaso warko arakrá sér, “Ae te apaeritea yumo fwapia nɨnɨkia kwapwe kare nɨnɨk fek apae-apae ankank yae-páráknámp yurukup mo napon? ");
INSERT INTO yuj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Amwan arop ankwapao kot naeria warámpea akwap nánko te, amo oukoumwan mwaeaok akwap nep fek tapek kar fwapokwap kipo. Takria amwan kot wa i konámp aropamp wonae fikeanánko, mao amwan plismanomp yaek pap nánko, plismano amwan kalabus nap mek papantáno. ");
INSERT INTO yuj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ono amwan waeman kar sénampon: Amo te koupour akwap mono, ankár kalabus mek yakrá akwapea, amwan sérinap mani ponankor sánkea maok, pwar nanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jisaso am kar farákápea pwar nánko maok, am ke fek táman arop ankwap fárákapao yakápia Jisasén sérrá, “Galili mekamp aropan Pailatomp soldia fákárerao lotu nap tokwae mek faoporapo, am fárákapamp yɨri Kwarén ofa sánknap nape fɨramp yɨri yumuntuk kwarákari námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aerapo maok, Jisaso am fárákapamp kar pwarokwaprá sérrá, “Yumo nɨnɨk nap te, am Galili mekamp arop fárákapamp kwatae nɨnɨkao saráp tokwaeria Galili mekamp ankwap fárákapamp kwatae nɨnɨkan kámákár akwap námpan mpwe nɨnɨk rape? ");
INSERT INTO yuj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ono yumwan waeman kare kar ‘Mono’rá sénampon. Aeno yumo kwatae nɨnɨk pwar moria te, take pourouráp ankank yumwan ponankor taknámp mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wokwaek kar Siloam mekamp pouri nap tukur pɨkria, 18 arop paokimp te, yumo nɨnɨk nap te, am fárákapaoinap kwatae nɨnɨk te Jerusalem mek yakápnap arop fárákapamp kwatae nɨnɨkan kámákár akwap námpan mpwe nɨnɨk rape? ");
INSERT INTO yuj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ono yumwan waeman kare kar ‘Mono’rá sénampon. Aeno yumo kor kwatae nɨnɨk pwar moria te, take pourouráp ankank yumwan ponankor korop naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jisaso wounáp kar sérrá, “Arop ankwapao yao fik wain yopwaraok yɨmptea yakrá tank naenámpan mpwerá korop ko nke námpan maok, am te ki tank mono. ");
INSERT INTO yuj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aenámpantá maok, am yopwar mekamp tére aropan sérrá, ‘Amo wawae! Ono yinɨnk yopwar fek ki tank naenámpan mpwerá korop ko, nke nanko, tank mo námpono. Aenámpara, amo ankár am yao karápae! Wain yak naenámp fek fápárákápáne!’ ");
INSERT INTO yuj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Aeránko maok, am térenámp aropao kor am yopwar naropwarén sérrá, ‘Wampweno. Nánkár ono má yopwar fek saráp fi akárápria kwar kwapwe karenámp fi mek kák nanko, ki tank mákean nke nae. ");
INSERT INTO yuj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nánkárap ankwap yopwar fek warko tank moian nkea, mo nánko maok, “Karámpae”rá sérampo.’” ");
INSERT INTO yuj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat yae fek lotu nap mek Jisaso koumteouráp aropan kar farákáp. ");
INSERT INTO yuj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aenánko maok, yupu ankárankan kwatae-aropao man touwe sánkánko maok, maomp paonkore kor te ankár woukoupea yárak námp te akwapea 18 yopwar fek yak. ");
INSERT INTO yuj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aenánko, Jisaso man nkea, koropae ritea, man sérrá, “Waráp touwe te amwan oukoumwan sámp-fákeyak mono. Wae pwar námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aeria pwarará maok, maomp pourouk yae papánko maok, am yupurao náráp paonkore kor kwapwe kare naenko maok, Kwarén fáparák tokwaeriaka warákarimpon. ");
INSERT INTO yuj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aenámpan maok, am lotu nap taokeyak konámp aropao Jisaso Sabat yae fek yupuramp pouroukamp touwe fwapi papámpantá, nkeaka yopor yonkwae pwarámpria maok, koumteouráp aropan sérrá, “Loao sérrá, ‘Yumo tokwampok yae fek saráp tére kip.’ Aenámpara, yumwan aropao yiráp touwe fwapi papanáponoria te, tokwampok yae fek saráp korop kipo. Aeno Sabat yae fek te korop kwapono.” ");
INSERT INTO yuj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aeránko maok, nopok Jisaso maomp kar pwarokwaprá sérrá, “Yumo te kwekár i konap aropono! Yiráp kar te yiráp nɨnɨként ankár pourouráp mono! Sabat yae fek te yumo ponankor yiráp bulmakauramp nap mek tukupea yiráp bulmakauráp donki aokor-aokoria man ént fáranáponoria éréképá tukup konapon. ");
INSERT INTO yuj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aeno má yupu máte Abrahamomp tárápan maok, Satano maomp pourouk 18 yopwar fek yarokwapá fákeyak námpono. Táte ono am man woukoupeyaknámp ankank fwap Sabat yae fek wor-pwar nanamp te mokopono?” ");
INSERT INTO yuj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Makrá sénánko maok, am Jisasén yorowar kar sérap arop fákáre am te pwarápae tokwae sámpapo maok, táte nopok koumteouráp arop ponankor mao térenámp ankank te kwapwe kare námpantá warákár tokwaeapon. ");
INSERT INTO yuj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisaso warko sérrá, “Kwaro náráp firan taokeyak konámp te mokope ankankono? Ae te ono apae ankankan, arake niamprá wounáp nanampon? ");
INSERT INTO yuj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Am te ará: Arop ankárankao fɨran nape sánk konámp mastet fu kánanke kwarok yopwaraok sɨtenánko maok, forokareaka yao karnámp téképea tokwae kar nánko, ant am yowe fek taok i konámpono. Tá taknámp, Kwaromp firao kor kápae kare forokor naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisaso warko ankwap kar arakrá sér, “Ono Kwaro náráp firáp taokeyak námp te mokope wounáp kar sénanampon? ");
INSERT INTO yuj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Am te yis niampon. Yupu ankwap plaua tokwae mek yis kánanke kwarok yok-sɨrarea mént arákareanánko, am plaua ponankor yámpea tokwae kar i konámp niamp takeno.” ");
INSERT INTO yuj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisaso taun mekmwaek, némpouk mwaek yárakrá koumteouráp aropan kar yénkrá farákáprá yárakia Jerusalem mek akwapnámp mwae-párák akwap. ");
INSERT INTO yuj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aenánko maok, arop ankárankao Jisasén turunkrá, “Tokwae Kar e, Kwar te ankákárank aropan saráp érékép naenámp nie?” Aeránko maok, Jisaso am fárákapan sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yumo te ankár ménki kánanke mek yink mwaria, kárákáre kar kip. Ono yumwan sénamp te: Arop kápae kare am ménki kánanke mek yink mwaria napan maok, am fárákap te pwi mo napon. ");
INSERT INTO yuj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nánkár wakmwaek nap naropwaro nap ménki kéri tenánko, yumo te koropea ek yakáprá, ménki fek poporokwapria sérrá, ‘Arop Tokwae, amo yinan ménki kɨk-pwarae’rá sénapo, nopok mao yiráp kar pwarokwaprá yumwan sérrá, ‘Ono yumwan mér mo namp te, yumo te maokampono?’ ");
INSERT INTO yuj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Aeránko maok, yumo nopok man arakrá sér, ‘Yino waeman amont fépér, tá amo wae yinomp némpouk yakria, yinan kar farákáp, mak i konap tene.’ ");
INSERT INTO yuj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Makrá sénapo, mao kor nopok yumwan sérrá, ‘Ono te yumwan fwapia mér mo nampono. Yumo mam némpoukamp aropao nape? Yumo te kwatae nɨnɨk i konap arop fárákapono! Yumo ponankor onan pwarará tukupenke!’ ");
INSERT INTO yuj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yumo te nánkár Abraham, Aisak, Jekop, profet ponankor Kwaromp firáp taokeyak námp mek yakáp napo nke mwanapan maok, yumoku támaoia, yumwan ek pwate napo, am mek yakáprá apánki tɨkirá you kɨkɨmpia wae mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aenapo, tá ankwap fi mekamp arop, yámar pɨknámp mekamp arop, fwe yawor mekamp arop má ponankor Kwaromp firáp taokeyaknámp mek koupoukarea tankápria fɨr fépér mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yumo wawenk! Arop ankwap fárákap oukoumwan wakmwaek kar kánanke kwatae yakáp nap te, manénkɨr am mek yink mwarea napon. Tá arop ankwap fárákap oukoumwan manénkɨr yink mwarianap arop tokwae yakáp nap te, nopok wakmwaek kar kánanke kwatae yakáp mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Am takámp ke fek táman Farisi mekamp arop ankwap fárákap koropeaka Jisasén sérrá, “Amo te mapek yak kwapono. Ankwap fek akwapae. Heroto amwan sámp-wouroump nanampri námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Aeránko maok, Jisaso sérrá, “Yumo tukupea am yao pwae mekamp as kwatae táman arakrá sér kipo: ‘Ono oukoumwan, tá oumpouran arapek kwatae-arop yéréperá kérépria, touwenap arop fwapokwaprá kákea maok, yinɨnk yae arapek onomp tére wae pwar nanampon.’ ");
INSERT INTO yuj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aeno oukoumwan, tá oumpouran, tá ankwap makáran arapek maok, ono ankár akwap nanampon. Am te apae riteanápe: Profet te ankwap némpouk yak nánko, man sámp-wouroump mono. Man te ankár Jerusalem mek maok sámp-wouroump mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aeria maok, sérrá, “Jerusalem, Jerusalem e! Amo te profet fákáreran tirá wouriaka, Kwaro amonapok tirá kérépnámp aropan kor mént yumwi fek yénképrá kák konapono. Kápae kare por ono te waráp tárápuan kakaruk éntupwaro náráp morokan i konámpnámp yowe pwae ankore mek wouri fákeyak nae rampan maok, yumoku monorá napon. ");
INSERT INTO yuj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yumo wawenke! Kwar te yumwan pwate nánko, yiráp némp máte kwaporok yak naeria námpon. Ono yumwan waeman kar sénampon: Yumo warko onan nke mo yakrá tukupea yumo sérrá, ‘Am arop te Kwaro nɨnɨk námp fek korop námpara, Kwaro man ‘Yae-párák kareano’rá sér mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ankwap Sabat yae fek Jisaso akwapea Farisi mekamp arop tokwaeramp nap mek fárrá tankánko maok, ankwap fákárerao man, mokopon nke mwarria yépékrá tankáp. ");
INSERT INTO yuj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aenapo maok, pu yae yárámpámp arop ankwap Jisasomp wonae fik tank. ");
INSERT INTO yuj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aenánko Jisaso am aropan nkea maok, lo mérnap arop fákáre ntia Farisi fákáreran arakrá turunk, “Nomo te Sabat yae fek te touwenap arop te fwap fwapokwaprá kák mwanámp ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aerá turunkánko maok, am fárákapao kor kar tákaprá sér moapantá maok, námoku man warámpea maomp touwe wor-sɨrarea sámp-kérépánko, akwap. ");
INSERT INTO yuj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aenánko maok, mao arakrá sér, “Ae te yumo ankwapao yiráp táráp, tá bulmakau Sabat yae fek ént me mek pɨk nánko te, yumo kor man koupour warámp mo i konap nie?” ");
INSERT INTO yuj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aerá séránko maok, am fárákap te nopok maomp kar pwarokwaprá sér mwarap pourou mono. ");
INSERT INTO yuj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisaso nke nánko, arop fɨr fár mwaria korop nap te ankár am fɨr kérounámp aropao yak námp fek saráp tankáp napantá maok, wounáp kar arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Arop ankárankao yupu warámpnámp fɨr kérouria amwan wumwi nánko, akwap nap kwamp te, am yupu warámpnámp aropao tank námp fek te akwapá tank kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Takria amwan ‘Má sia pwar napo, náráp nouroup mapek tankano’rá sénánko, amo pwarápae tokwae sámpea younkwe mwaek akwapá tank nanape. ");
INSERT INTO yuj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aeantara, amwan arop ankwapao fár mwaria wumwi nánko, akwap nap kwamp te kánánkar akwapea, faek karaok tank napo, nánkár námoku sérrá, ‘Wonae fik mapek koropea napo, tankar’rá sénaenámpon. Amwan takrá sénánko maok, amont fánap arop ponankor nke nap fek amo e tokwae sámp nanapon. ");
INSERT INTO yuj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Arop, námo tokwaerao nampria námokuráp e narek sampok námp te, Kwaro man apárok sámp-anámp naeria námpon. Aeno arop, námo te kánanke kwatae namponoria apárok sámp-anámp námp te, Kwaro maomp e narek sampok nae-námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisaso am fɨr kérounámp aropan sérrá, “Amo fɨr koropá fárenkria wumwi nap kwamp te, waráp nouroupén saráp wumwi, tá yumoku mwearoan saráp wumwi, tá yumoku-pwaeráp aropan saráp wumwi, tá amokuráp ankárankamp némpoukamp mani kápaenap arop, aran saráp wumwi kwapono. Takria nánkár wakmwaek amwan kuri ‘Koropá fárae’rá wumwi, tá waráp fɨr am nopok sánkantáno. ");
INSERT INTO yuj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mono. Táte amo fɨr kékérou nap kwamp te, ankank moráp arop, tá pourou kwataenámp arop, tá pu kwataenámp arop, tá yi kwataenámp arop, aran wumwiampo. ");
INSERT INTO yuj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Am take pourouráp arop fárákap te amwan fɨr nopok sánk mwanap pourou mo napara, amo fwap warákár nanapono. Am te apaeritea námpanápe, nánkár yae-párák kare arop sumpwinap ferámpnap ke fek, amwan Kwaro nopok sánk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Am fépérrá tankáp nap mekamp arop ankwap am kar wawia maok, Jisasén sérrá, “Arop Kwaro náráp firáp taokeyak námp mek tankrá fánámp te, mao te fwap warákár naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aeránko maok, Jisaso wounáprá man sérrá, “Arop ankárankao, náráp toupour fek korop kipria arop kápae kare sérari pwate. ");
INSERT INTO yuj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tá wae am tupur naenámp yae korop nánko maok, náráp tére aropan, akwapea éréképá koropaeria sámp-kérépánko maok, mao akwapea sérrá, ‘Fɨr wae ponankor nánapia páteane. Yumo koropenke!’ ");
INSERT INTO yuj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Aerá séránko maok, am ponankor arop fárákap sérrá, ‘Yino te tukup mono.’ Ankwap ankárankao sérrá, ‘Ono te oukoumwan yopwar yoro nanamp apár ankwapao námpan sámp nampara, akwapá énounkoup nae rae. Aenanampara, ono te korop nanamp pourou mono.’ ");
INSERT INTO yuj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Aeránko, arop ankwapao kor sérrá, ‘Onomp téreampor bulmakau fére-sámpramp sámpea nampan, am fárákap tére te mokop naprá akwapá nke naenampara, ono korop nanamp pourou mono.’ ");
INSERT INTO yuj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Aeránko ankwapao kor taknámp sérrá, ‘Ono te oukoumwan kar yupu sámpea nampara, ono korop nanamp pourou mono.’ ");
INSERT INTO yuj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Aerapo maok, am tére konámp aropao kor warko arákarrá akwapea naropwarén sérrá, ‘ “Korop mono”rá sénap’rá sénánko maok, tá am naropwaro kor youpoukwapia am aropan sérrá, ‘Amo warko koupour akwapea am taun mekamp mwae kup tokwae páraok, tá mwae kánanke-tárápaok yárakrá ankank moráp arop fárákap, tá pourou kwataenap arop fárákap, tá yi kwataenap arop fárákap, tá pu kwataenap arop fárákap, aran amo onomp nap mek éréképá koropae.’ ");
INSERT INTO yuj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Aeránko maok, warko akwapea am arop éréképá koropea pwatea maok, naropwarén sérrá, ‘Ono te wae amo sénapaok kákea nanko, sia ankwapmwaek pwi mono, kwaporok tank námpono.’ ");
INSERT INTO yuj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aeránko maok, naropwaro kor warko sérrá, ‘Ae te warko arákarrá akwapea mwae kupuk mwaek, tá yopwar mek mwaekamp yár firi yárakria koumteouráp arop nke nap kwamp te, am fárákapan ankár kar kárákáre fek sénapo, onomp fɨr koropá fáranápono. Onomp nɨnɨk te onomp nap ankár aropao pwianoria nampon.’ ");
INSERT INTO yuj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aeritea maok, am arop fárákapan sérrá, ‘Ono manénkɨr wumwirinamp arop fárákap te onomp fɨr máte kánanke sámpá fár mwanap pourou mo karane.’” ");
INSERT INTO yuj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kápae kare koumteouráp arop Jisasént tukup napo, Jisaso arákarrá am fárákapan sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Arop ononampok korop námpao maok, náráp éntupwar naropwar, námokuráp yupu, námokuráp táráp, náráp ankwapnáp, náráp antáp, tá námokuráp pourou kare, aran saráp nɨnɨk tokwaeria, onan nɨnɨk námp kánanke kwarok námp te, kumtiráp kar onomp firáp arop yak naenámp pourou mo kareno. ");
INSERT INTO yuj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Arop ono touwe sámp nampaok moria, onomp wakmwaek korop mo námp te, mao te onomp firáp yak naenámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Arop nap tokwaeri ti naeria te, am arop te nap ti naenámp ankank ponankor yurukuprá nɨnɨkia pwatea maok, am nap fwap ti-pwar konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aeno fwapia nɨnɨk moi yakrá, oumpwar yɨmptea am nap tia pwar mo nánko te, kápae kare arop am nap nkeaka man wouroump mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Aeria maok, sérrá, ‘Mao te nap ti námpao maok, ponankor tia fákáp naenámp pourou mo námp’rá sér mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Táte king ankwap akwapea ankwap Kingént yorowar naeria te, sánánkar tankrá fwapia nɨnɨkia pwatea ni konámpono. Ae te mao wae 10 tausen soldia nánko, ankwap king 20 tausen soldiant korop kan. Aeria te méria pwatea maok, mao, fwap ankwap king yérépea tirá kérép nanampaoeani, mo nierá nɨnɨk i konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mao nɨnɨk nánko, pwi mo nánko te, arop oukoumwan yorowar korop mo, panek yak námp fek, arop ankwap fárákap tirá kérép nánko, tukupea wampwenoria taokor konapon. ");
INSERT INTO yuj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ae konapnámp maknámp, yiráp ou mekamp arop ankwapao námokuráp ankankan kor ponankor kwaporok younkwe mwaek pwar mo námp te, am arop te ankár kumtiráp kar onomp firáp yak mo kareno.” ");
INSERT INTO yuj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jisaso warko ankwap kar sérrá, “Oukwe te kwapwe kareao maok, akwapea námpareria, nape konámp pwar nánko te, nomo apae mokopianánko warko nape naenámpono? ");
INSERT INTO yuj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Am take pourouráp oukwe te waeman kwatae námpara, warko aropan yaewour mono. Aenámpara, kwatae sɨr konámpon. Arop yumo te woupwirápara, má kar má fwapia wa kip.” ");
INSERT INTO yuj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis sámp konap arop fárákap, ntia Juda firao ‘Kwatae nɨnɨkráp’rá sér i konap arop fárákapao Jisasonámpok koropea Jisas farákápnámp karan wará tankáp. ");
INSERT INTO yuj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Aenapo maok, Farisi mekamp arop fárákap ntiaka lo yénkrá farákáp konap arop fárákapao kánánkámp sérarrá, ‘Nko arop nko kwatae nɨnɨkráp arop fárákapan nouroupriaka mént fárrá yárak námpwae!’ ria sérar. ");
INSERT INTO yuj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aenapo maok, Jisaso am fárákapan wounáp kar sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Yumo ankwap ankárankao sipsip 100 wun nánko, ankwap ankárank moyak nánko te, am naropwaro 99 sipsip fépérrá yakáp napo, pwarará akwapea, am ankwap ankárank moyak námp oupourounk i konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Oupourounkrá akwapea kakapea yápare mek porokopea korop riaka warákárrá korop naerámpon. ");
INSERT INTO yuj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Koropea némpoukria maok, námokuráp némpoukamp arop ntiaka mao nouroupnámp aropan koropá koupoukourenkria wumwi. Aenánko maok, koropea koupoukourapo maok, am fárákapan sérrá, ‘Onomp sipsip ankárank moyak nánko, oupourounkiaka warko warámpea korop namp má, yumo kuri onont warákárenke!’” ");
INSERT INTO yuj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tá Jisaso arakrá sér, “Ono yumwan waeman kar sénampon: Yámar mekamp arop te yae-párák yakápnap 99 aropan warákár napan maok, arop ankwap kwatae nɨnɨk pwararea Kwaronámpok korop nánko te, yámar mek te yoporop warákár tokwae korop naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jisaso warko wounáp kar arakrá sér, “Yupu ankárankao mani meráp fére-sámpramp sámpá yak nánko, fére náparamp fɨrɨkɨr pɨk tenánko te, apae naenámpon? Mao te lam pounkouroupea samp yakrá, pwar pɨkantánoria sánánkar nap mekamp tɨri farákáprá oupourounkrá akwapea sámp naerámpon. ");
INSERT INTO yuj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mao am mani wae sámpea te, námokuráp némpoukamp arop ntia mao nouroupnámp aropan wumwi nánko, koropea koupoukour. Aenapo maok, mao am fárákapan sérrá, ‘Onomp mani moyak námpan maok, warko oupourounkia sámp nampono! Yumo onont warákárenke!’ ");
INSERT INTO yuj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ono yumwan waeman kar sénampon: Arop ankwap kwatae nɨnɨki námpao Kwaronámpok arákarrá korop nánko te, ensel fákáre ou mek take pourouráp warákár tokwae korop konámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisaso wounáp kar ankwap sérrá, “Arop ankárankamp poumou-táráp anánkaopwerápao maok, ");
INSERT INTO yuj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","nánae-tárápao naropwarén arakrá sér, ‘Amo yinan nánkár wakmwaek ankank pɨrékarea ti-sáp nanampri nap te onomp wae oukoumwan sápae.’ Aerá séránko maok, naropwaro kor náráp tárápyarampor am ankank pɨrékarea nánae-tárápamp wae sánk. ");
INSERT INTO yuj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Yaeamp mono, am nánae-tárápao kor náráp ankank koupoukarea sámp-samprá akwapea, tokwae panek ankwap némpouk yak. Yakria maok, maomp mani te kwaporok nkwakwe make sokororá yárak námp fek épéria pwar. ");
INSERT INTO yuj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Takia maok, maomp mani ponankor pwatenámp ke fek te, am apárok yae-porokwe tokwae korop naenko, maomp yae kwae mek te ankank kánanke ankwap ankárank tank mo kare. ");
INSERT INTO yuj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aempantá maok, akwapea arop ankwapan ‘Ono tére nae’rá sénánko maok, am aropao man, náráp kou taokeyakrá wunaeria sámp-kérép. Aenánko maok, taokeyakánko, yae-porokwea wae naenko maok, kouan fɨr nénkria, ");
INSERT INTO yuj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","kouao fánámp fekamp yɨpi kwatae táman make tirá fánaeria. Aenámpan maok, arop ankwap ankárankampao man fɨr ankwap sánk mono. ");
INSERT INTO yuj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Aeapo maok, tá námoku kwatae yárakinámp táman warko nɨnɨk tokwaerá tankea maok, ‘Onomp naropwaromp térenap arop mao saráp kápae kare fɨr kwapwe fánapo, ono mapek yakriaka, yae-porokwe tokwae nampon. ");
INSERT INTO yuj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wampwe kwae! Ono fárámprá warko onomp naropwaronámpok arákarrá akwap nae. Ono akwapea te man arakrá sénanampon: “Ayao! Ono te Kwarén, tá amwan kor kwatae nɨnɨki nampon. ");
INSERT INTO yuj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Oukoumwan te ono apae kwapwe kare nampan, amo onan ‘Waráp táráp’rá sénanapanápe. Wampwe kwae! ‘Waráp tére arop’rá sérae!” ’ ");
INSERT INTO yuj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aerá sénanamponorá nɨnɨkia pwarará maok, mao wae fárámprá náráp naropwaronámpok arákarrá akwap. Oukoumwan panek korop nánko naropwaro nkeaka, náráp tárápria yonkwae touweriaka fárakoprá akwapea tárápan sámp-kánánkaprá koupwiyakea kákámánkar. ");
INSERT INTO yuj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aenánko maok, namorápo man sérrá, ‘Ayao! Ono te Kwarén, tá amwan kor kwatae nɨnɨki nampono. Ono apae yae-páráki nampan, amo onan ‘Náráp tárápono’rá sénanapanápe!’ ");
INSERT INTO yuj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aeránko maok, naropwaro kor náráp tére aropan wumwiria sérrá, ‘Yumo onomp waempyam tokwaeri kwapwe ará koupour sámpá koropea yirɨmpá pwarenke. Tá ring ará sámpea yae topwe fek yirɨmpenke! Tá su sámprá puk yirɨmpenke! ");
INSERT INTO yuj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tá bulmakau soup tokwae ará yankopea yankap napo, nomo fépérrá warákár mwaro. ");
INSERT INTO yuj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Am te apae riteanápe, mámá táráp te waeman sumpwi tenámpan mpwe yonkwae nampan maok, oukoumwan yiki yak námpon. Waeman moyak te rámpwe nampan maok, nomo warko warámp námpon.’ Aeria maok, am fɨr tokwae kékérourá fépéria warákáránk. ");
INSERT INTO yuj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Aenapo maok, am ke fek táman, nae-táráp yopwar mek yakeanampao koropea nap top fekria maok, wa nánko, tár sámprá, musik porokwaprá, kepárapo, wa. ");
INSERT INTO yuj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aeria maok, tére konámp aropan koropae ritea, man turunkrá, ‘Máte apae rape?’ ");
INSERT INTO yuj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Makrá turunkánko maok, am tére konámp aropao kor sérrá, ‘Máte waráp nánae warko arákarrá koropeanánko, naropwaro bulmakau soup sámpea fɨr kérou námpon. Am te apae riteanápe, mao kwapwe kare yakea korop nánko, warákár námpon.’ ");
INSERT INTO yuj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aeránko wawia maok, am nae-tárápao kor kokwarokia, am mek yoump mo naenko maok, naropwaro kor mankrá, ‘Amo te apaeritea nap, mankae’rá séránko maok, ");
INSERT INTO yuj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","namorápo kor naropwaromp kar pwarokwaprá sérrá, ‘Kápae kare yopwar ono waráp kar ták-pwar mo, ankár tére konap arop niamp térerá yárak namp fek, amo onan meme soup ankárank takeniamp sáp napo onomp nouroupént kor fépériaka warákár tak mwanámpan amo mo kari napon. ");
INSERT INTO yuj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aeno waráp táráp am te kokopor koumteou fek ankank ponankor épéri pwateaka, warko arákarrá korop námp táman, amo warákárria bulmakau soup kwapwe am sámp napon.’ ");
INSERT INTO yuj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aeránko maok, tá nopok naropwaro kor nae-tárápamp kar pwarokwaprá sérrá, ‘Nomo te waeman énénkér némpouk yak nempara, kápae kare ankank máte ankár ponankor warápono. ");
INSERT INTO yuj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aeno waráp nánae máte waeman sumpwi yak námpao maok, oukoumwan warko yiki yak námpono. Mao te waeman moyak námpan maok, nomo warko nkea warámp námpon. Aenámpara, nomo kékérourá fépérrá warákár mwaro.’” ");
INSERT INTO yuj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisaso námoku éréképea yárak i konámp aropan sérrá, “Maniráp aropamp ankank taokeyak konámp arop yak nánko maok, arop ankwap fárákap koropea am maniráp aropan sérrá, ‘Waráp ankank poukeyak konámp arop te fwapia tére mo, waráp ankank te kwaporok épér námpono.’ ");
INSERT INTO yuj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aerapo maok, am maniráp aropao kor náráp ankank taokeyak konámp aropan koropae ritea sérrá, ‘Ono amonap karan arop fárákapao sénapan wa namp te mokopono? Amo akwapea onomp ankank amo taokeyak nap ponankor kukumwiampo. Amo warko onomp ankank taokeyak mono.’ ");
INSERT INTO yuj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Aeránko maok, am ankank taokeyak konámp aropao wawia, námokuráp nɨnɨk mek nɨnɨkrá, ‘Awɨ! Onan poukeyak konámp arop onan wae pwar naeria sénámp te mokop nanampono? Ono te kwar fɨpɨmp nanamp te kárákáre mo nampono. Tá ono arop ankwapan maniráp ankank mámánk nanamp te pwarápae nampon. ");
INSERT INTO yuj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aeno oukoumwan te ono wae mér nampon: Onan poukeyaknámp naropwar onan “Tére pwarará akwapae”rá sénámpara, oukoumwan te, aropao onan warámpea náráp nap mek tukup mwanap mwae kup mér nampon.’ ");
INSERT INTO yuj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Aeritea maok, náráp térenámp naropwaromp ankank kwaporok tinap aropan koropenk ritea manénkɨr koropámpan turunkrá, ‘Am arop te amwan apaekamp ankank sánkámpon?’rá turunk. ");
INSERT INTO yuj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Aenko mao sérrá, ‘Mao te 100 dram wel sánkámpono’rá sénánko maok, man sérrá, ‘Amo koupour am arop sánknámp tiket sámpea nopok sánk nanap némpi 50 dram kumwia papae.’ ");
INSERT INTO yuj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tá wakmwaek ankwap korop nánko, man turunkrá, ‘Amo kor apaekamp kwaporok sámp napono?’ Aenánko, mao kar pwarokwaprá sérrá, ‘Ono kor 100 wit bek sámp nampono.’ ‘Ae te koupour tiket sámpea nopok sánk nanap némpi 80 bek mwar kumwiae.’ ");
INSERT INTO yuj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tá wakmwaek man poukeyaknámp naropwaro mao térenámp wawia, mao náráp ankank taokeyak konámp arop kwekár i konámpan man sérrá, ‘Amo nɨnɨk kour kwapwe tenape!’ Am te apaeritea námpanápe, wakmwaek námwan yaewour naenámp ankankan nɨnɨkia námpono. Arop fárákap apárokamp nɨnɨkaok tére nap te nkwakwe make tére mwanap mwae kup mér kareria arop fárákap wae fekamp nɨnɨkaok paokop napan kámákár tukup napon. ");
INSERT INTO yuj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ono yumwan sérrá: Apárokamp mani kwatae fek mapekamp aropan nouroupria nénk napo, yiráp nouroup yakáp mwanapon. Nánkár wakmwaek am mani pwar nánko, yakápi yakáp mwanap nap mek éréképá tukup mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Arop ankwap kánanke kwarok ankank yae-párák kare taokeyak konámp te, tá ankank tokwae karan kor fwap taokeyak naenámpon. Tá arop kánanke kwarok térean poupwekáp fek tére námp te, tá tokwae kar térean kor poupwekáp fek tére naeria námpon. ");
INSERT INTO yuj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yumo apárokamp mani kwataeran kor fwapia taokeyak mo napo te, wa yumwan yámar mekamp yak konámp ankank sánk nánko taokeyak mwanapon? ");
INSERT INTO yuj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yumo ankwapamp ankankan fwapnae karia taokeyak mo napo te, Kwaro yumokuráp por nánapnámp ankankan kor yumwan wa sánk naenámpon? ");
INSERT INTO yuj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tére konámp arop ankárankamp te taokeyak konámp arop anánkaopweramp tére naenámp pourou mono. Mao takria te, ankwapan kokwaeria, ankwapan saráp warákár naenámpono. Tá ankwapamp karwaokria, ankwapan younkwe sɨnaeria námpon. Yumo te Kwaromp yae ankore mek yakáprá, maniamp yae ankore mek méntér yakáp mwanap pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi fákáre te maniran kɨkiankrá paokop nap kwamp maok, Jisaso farákápámp kar má wawia man wouroump napon. ");
INSERT INTO yuj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aenapan maok, Jisaso am fárákapan sérrá, “Yumo te, arop fárákapao yumwan ‘Yae-párák kare arop’rá séranáponoria napon. Aeno Kwaro yiráp nɨnɨk mek mek yaknámp ankank te wae mér námpon. Aropao tokwae karonoria nɨnɨknámp ankank te, Kwaro nke námp fek te kánanke kwataeno. ");
INSERT INTO yuj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Lo kar ntiaka profet fákáreramp kar te wokwaekamp karao koropea Jon yakámp ke fek námpon. Aenámpan maok, warko Jon yak námp fekampao koropea Kwaro náráp firáp taokeyak naenámp Kwapwe Kare Kar némp-némp ponankor akwap námpon. Aenánko, ponankor arop fárákap am náráp firáp taokeyak námp mek yink mwaria kárákárea wae napon. ");
INSERT INTO yuj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yámar ntiaka apár te moyak naenámpono. Aeno Kwaromp loamp kar te ankwap kánanke moyak mono.” ");
INSERT INTO yuj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jisaso sérrá, “Arop wa mokop yupu sámpeaka warko pwarará, ankwap yupu sámp námp te, mao te náráp yupuan kwatae nɨnɨkria kokopor námpon. Tá taknámp arop ankwapao poumaropao pwate nánko yaknámp am yupu sámp námp te, támao kuri poumou nap mek tanknámp loan kwe-pwararea kokopor námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisaso ankwap kar sérrá, “Wokwaek maniráp arop ankárank yakria maok, mao te kápae kare por ankár kwapwe kare waempyam yirɨmpria maok, tá waempyam noumouri kwapwe fek am yumuntuk pourouk woukwap konámpon. Tá mao te kumur méntép fɨr kwapwe fári konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Aenánko maomp ménki fek ankank moráp Lasarus am fek amp. Maomp nɨnɨk te maniráp aropao fɨr fánánko, kánanke-táráp kákánar ankore mek pɨkrɨnk námp tirá fánaeria. Aenánko maok, man te ankárápa waerá yɨri sárár nánko maok, as fákárerao korop ko maomp ankáráp mek mukur saráp yakáp. ");
INSERT INTO yuj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nánkár wakmwaek am ankank moráp arop am sumpwi nánko maok, ensel fákárerao sámpá tukupea Abrahamo fɨr tokwae kérou námp fek tank námp fek mént páte. Aenánko maok, tá maniráp aropao kor wakmwaek sumpwinko man apár me mek pap. ");
INSERT INTO yuj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mao te waempomp némpouk yakria touwe tokwae sámprá yak. Aeria maok, narek nke nánko maok, Abraham tokwae panek kar yak nánko maok, Lasarus kor méntér yak. ");
INSERT INTO yuj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Aenánko maok, maniráp aropao arakrá wumwi, ‘Ayao Abraham e! Amo onan aropompria Lasarusén sénapo, mao yae kurépi fek ént mek anámpea sankoropea onomp sérékam fek pap nánko, námpare tae morokano. Ono mámá yaomwi mek yak nanko, onan te touwe kwatae kareane!’ ");
INSERT INTO yuj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Aeránko maok, Abrahamo sérrá, ‘Táráp e! Amo wokwaek apárok yakap ankank aran nɨnɨkampo. Amo oukoumwan yiki yakap fek te, kápae kare ankank kwapwe kare tiapo, Lasarus máte kwatae yakámpon. Aempan oukoumwan te mámá némpouk te kwapwe kare yak nánko, nopok amo touwe kwatae sámp napon. ");
INSERT INTO yuj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tá ankwap te, yumo tampok yak, yino mampok yak nánko, kuk mek te Kwar námoku yɨnkri furu tokwae páte námpara, arop mapek yakáp nap te mokopia tampok tukup mwanapanápe. Tá arop tampok yakáp nap mokopia mampok korop mwanapanápe.’ ");
INSERT INTO yuj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Aeránko maok, maniráp aropao kor sérrá, ‘Ayao, ae te takanánko te, ono amwan sénanko, amo Lasarusén sámp-kérép napo, onomp naropwaromp nap mek akwapano. ");
INSERT INTO yuj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Onomp nánaeou te éntikono. Mao akwapea kárákáre kor kar farákáp nánko, am fárákap náráp nɨnɨk fwapokwapanápono. Takria mao kor mámá touwe tokwae kwatae sámp mwanap némpouk koropantáno.’ ");
INSERT INTO yuj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aerámpan maok, tá warko Abrahamo sérrá, ‘Moses ntiaka profet fákáreramp kar wae tank námpon. Aenámpara, am fárákap am kar táman woupwi pátea wa mwanapono.’ ");
INSERT INTO yuj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Aeránko maok, warko maniráp aropao kor sérrá, ‘Ayao Abraham, am támao pwi mono. Ankár sumpwianámp aropao warko apár me meknámp fárámpea akwapea sénánko te, fwap wawia kwatae nɨnɨk pwar mwanapono.’ ");
INSERT INTO yuj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aeránko maok, Abrahamo kor warko man sérrá, ‘Ae te Moses ntiaka profet fákáreramp kar wa mo napo te, sumpwianámp arop ankárank warko arákarrá aokea sénámpan kor, maomp kar wawia mér mwanap pourou mono.’” ");
INSERT INTO yuj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisaso námoku éréképá yáraknámp arop fárákapan sérrá, “Arop am fek kwatae nɨnɨk sámp mwanap nkwakwe make ankank koropánk naerianámpon. Aenámpan maok, am aropan kwatae nɨnɨk sánknámp arop támao maok, koupouteane! Mao te touwe tokwae sámp naenámpono. ");
INSERT INTO yuj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Táte arop ankwapao mámakeniamp táráp maoianánko, am táráp kwatae nɨnɨk fek akwap nánko te, wae manénkɨr arop fárákapao am aropamp yápare kor fek yumwi tokwae tokoropea man ént you tokwae mek sɨtenapo, tak moan mpupo. ");
INSERT INTO yuj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yumo kor yumoku támao fwapnae karia mér kip! Waráp ankwapwaráp kwatae nɨnɨk nánko te, amo ‘Am te kwataeno. Pwarae’rá sénapo, ‘Kare tak nampono’ ria pwar nánko te, amo kor maomp kwatae nɨnɨk warko nɨki kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Táte mao ankárankamp yámaraok mwar amwan fákánek por kwatae nɨnɨk námpao fákánek por amonapok koropea sérrá, ‘Ono yonkwae touwe nampono’rá sénánko te, amo am aropan sérrá, ‘Ono amoinap kwatae nɨnɨk wae nɨk mo, pwar namp’rá sérampo.” ");
INSERT INTO yuj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisaso, kar farákápenkria tirá kérépnámp arop fárákapao Jisasén kar toropwaprá sérrá, “Amo yinomp Kwarén mér námp yaewour napo, tokwae karano.” ");
INSERT INTO yuj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jisaso sérrá, “Yiráp mér te sapok fu kánanke kwarok niampao maok, yumo fwap mámá yaoan sérrá, ‘Amo arák make mokwapea akwapea ént mek warko yakae’rá sénapo te, fwap yiráp karwaok tak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jisaso warko ankwap kar sérrá, “Táte yumo ou mekamp arop ankwapao náráp tére konámp aropan ‘Amo akwapá yopwar mek téreae’rá sér, tá ‘Sipsip taokeyakae’rá sénánko, mao akwapá térea arákarrá korop nánko te, tá maomp arop tokwae te man sérrá, ‘Amo koupour koropea tankrá fárae’rá sénaenámp nie? ");
INSERT INTO yuj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mono. Man sérrá, ‘Amo onomp fɨr yankapea manénkɨr waempyam kámpea onomp fɨr yorokwaerá kákea sankorop sápae. Ono manénkɨr fária, ént fária nanko maok, amo wakmwaek fɨrráp ént fárae’rá sénaeria námpon. ");
INSERT INTO yuj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ae te am arop tokwae náráp tére arop náráp kar wawia mántwaok nánko te, man ‘Aesio’rá sénaenámp nie? ");
INSERT INTO yuj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tá taknámp, yumo kuri Kwaro yumwan sérinámp tére ponankor térea pwar nap kwamp te, yumo ankár arakrá sér kip: ‘Yino te kwatae tére aropono. Ankank yino tére námp te yinomp tére támaono.’” ");
INSERT INTO yuj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisaso Jerusalem mek akwapnámp mwae-páraok akwapea, apár Galili kár-pwarará akwapea apár Samaria kuk mek. ");
INSERT INTO yuj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Mao akwapea ankwap némp wonae fik nánko maok, lepra touweráp arop fére-sámprampao koropeaka, mwaeaok am fek kɨkɨp. Kɨkɨpia paneknámp nkea foukouri yakáprá Jisasén tékén wumwia sérrá, ‘Jisas, Arop Tokwae, amo yinan aropompae.’ ");
INSERT INTO yuj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aerá sérapo maok, am fárákapan nkea sérrá, “Yumo tukupea pris fákáreran yiráp pourou yénkenke!” Aeránko am fárákap mwaeaok tukupea nke napo, náráp pourou wae yiki kukur kwapwe. ");
INSERT INTO yuj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aenko maok, am ou mekamp arop ankwap ankárankamp námokuráp pourouk nke nánko, wae kwapwe nánko maok, mao arákarrá akwapria tékén Kwaromp e narek sampokrá e sakap. ");
INSERT INTO yuj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mao akwapea Jisasonámpokria maok, kwaráp torokomprá, apárok Jisaso pu páte námp fek me kor woukouprá, man ‘Aesio’rá sér. Am arop te Juda mono. Mwar ankwap fi arop Samaria mekampaoimpono. ");
INSERT INTO yuj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisaso man nkeaka sérrá, “Ono nɨnɨk namp te fére-sámpramp ponankor yiki kukur napan mpwe nampan maok, fére ankárankao warko arákarrá korop nánko, sárakok te maok yakáp nape? ");
INSERT INTO yuj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ae te arop ankwap arákarrá koropea Kwarén ‘Aesio’rá séria maomp e sakap naenámp yak mo nie? Mámá ankwap fi mekamp arop ankárank mao saráp nie?” ");
INSERT INTO yuj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aeria maok, Jisaso am aropan sérrá, “Wae amo onan mér napara, waráp pouroukamp touwe fwap námpono. Amo fárámprá akwapae.” ");
INSERT INTO yuj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi fákárerao Jisasén “Makár Kwaro náráp arop fi taokeyak naenámp yae korop naenámponria turunkapo maok, Jisaso kor am fárákapamp kar pwarokwaprá sérrá, “Kwaro náráp arop fi taokeyak naenámp yae korop nánko te, arop yi fek te nke mwanap pourou mono. ");
INSERT INTO yuj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Am te arop fárákapao yi fek nkea ‘Máyaknámp nkenk!’rá sér, tá ‘Arampok yakán’rá sér mwanap pourou mono. Yumo wawenk: Kwaro náráp firáp taokeyak námp te yumo ou mek yak námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aeritea maok, Jisas námoku éréképá yáraknámp arop fárákapan kor sérrá, “Nánkár wakmwaek kor yumo Aropamp Tárápan kápae kare yae fek nke moria kor, ankárank kumur fek nke mwar kar napao maok, yumo te nke mo karenono. ");
INSERT INTO yuj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nánkár yumwan aropao sérrá, ‘Arampok yak námp nkenke!’, tá ‘Mapek máyak námp nkenke!’ Aerá sénapan maok, mao sénapaok tukup kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yumo te wae mérono: Mékér wae tákap námp fek te, yámar mek ponankor wae tákap konámpono. Ae konámp te, Aropamp Táráp ék naenámp ke fek kor taknámp nánko, arop fi ponankor nke mwanapono. ");
INSERT INTO yuj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Aeno mao te ankár manénkɨr touwe tokwae sámp nanko maok, mámá ke fekamp arop fákáre man younkwe sánk mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Wokwaek Noa yakámp fekiapnámp taknámp, Aropamp Táráp ék naenámp fek kor taknámp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa yakámp fek kor ankár fɨr fépérrá, ént fépérrá koumteou tirirá, makrá yakáprá tukupea Noa sip mek youmpámp ke fekiapon. Aenko ént tokwae nákareaka arop ponankor oupoupourimpon. ");
INSERT INTO yuj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tá Loto yakámp ke fek kor take, fɨr fépérrá, ént fépérrá, mani fek ankank tirá, nénkrá, yopwar yororá, nap térerá yakápiapono. ");
INSERT INTO yuj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Aeapo Loto kor taun Sodom pwarará akwap nánko maok, am yámaraok táman yaomwi ntia yumwi salfa kéntia waenámpao, yámar meknámp warákamnámp ékria arop ponankor wourékɨmpimpon. ");
INSERT INTO yuj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nánkár Aropamp Táráp wakmwaek érik korop naenámp ke fek kor, take nɨnɨk fek yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Am yae fek táman arop ankwap kaerik yak námp te, warko nap mek youmpea náráp ankank ti mono. Tá arop ankwap yopwaraok akwapá yakeanámpao, warko arákarrá koropea náráp nap mekamp ankank ti mono. ");
INSERT INTO yuj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yumo Lotomp yupuranimpan nɨnɨkenke. ");
INSERT INTO yuj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aeno táte arop ankwap námokuráp pourouan saráp nɨki-samp námp te, maomp pourou te kwatae akwap naerámpon. Aeno arop námokuráp pourou wampwe pwar námpao maok, mao yae-párák yiki yak kwapwe sámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ono yumwan sénampon: Arop anánkaopwe kumuruk nap mek amp nepo, am ke fek Aropamp Táráp korop nánko te, am mekamp ankwap ankárankamp mwar warámpria, ankwap ankárank pwar naerámpon. ");
INSERT INTO yuj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tá yupu anánkaopwerao kor ni yaprá yak nep te, Aropamp Tárápao ankárank mwar warámpriaka, ankwap pwar naerámpon. ");
INSERT INTO yuj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Poumarop yaworao kor yopwaraok tére nepo, Aropamp Tárápao ankwap warámpriaka, ankwap pwar naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jisaso makrá farákápánko maok, mao námoku éréképá yárakimp aropao má kar wawia turunkrá, “Tokwae Kar e! Amo má sérarnap ankank te maok korop naenámpon?” Aerá turunkapo maok, Jisaso am fárákapan sérrá, “Apae ankank mákáre nánko, ampae yákáre koropea koupoukour konapon. Taknámp ono ék namp fek, kápae kare arop fi nke mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisaso námoku éréképá yárak i konámp arop fárákapan ‘Kokwae kwapono. Kwarén ankár kar toropwap saráp yak kip’ riaka farákáprá sérimp wounáp kar te, ");
INSERT INTO yuj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","arakrá sérimpon: “Ankwap taun mek kot wawi konámp arop ankárank yak. Am arop te Kwarén apáp mo, tá aropan kor nɨnɨk tokwae mo i konámpao maok, ");
INSERT INTO yuj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","kae yupu ankárankao am taun mek am mek yak námpao korop ko, am kot wawi konámp aropan sérrá, ‘Onan aropao kar yorowar nape. Amo onan yaewourrá kotae.’ ");
INSERT INTO yuj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Manénkɨr te am kot i konámp arop te, am yupuran yaewour monoria nɨnɨkimpao maok, warko wakmwaek nɨnɨkia, ‘Ono Kwarén apáp moria aropan kor nɨnɨk tokwae mo nampon. ");
INSERT INTO yuj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Aeno kae yupu máte ankár korop ko onan sér saráp yak nánko, mákia ono kokwae nanae. Wampwe. Man yaewour nae.’” ");
INSERT INTO yuj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jisaso sérrá, “Yumo te mámá kwatae kot wawi konámp aropamp kar wae wa napono. ");
INSERT INTO yuj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ae te Kwar te mokop námpon? Mao náráponoria nánkárápnámp arop fákáre, yinan yaewouraeria kar tae fek kumur yámar méntép kar toropwap saráp yakáp napo te, Kwar te wa kéréprá yaewour mo naenámp nie? ");
INSERT INTO yuj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ono yumwan waeman kare kar sér rae: Mao te koupour kar wará yaewour i konámp Kwarono. Aeno nánkár Aropamp Táráp ék námp ke fek, mao koumteouráp arop apárok yakáp nap te, Kwarén mérrá yakápi nap ni mo nierá nke naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Arop ankwap fárákapao nɨnɨkrá, yino mwar yae-párák kare nánko, arop ankwap fárákap te yino niamp mono, apárok kánanke kwatae naponorá nɨnɨk. Am taknap arop fákáre táman Jisaso wounáp kar arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Farisi mekamp arop ntia takis sámp konámp arop, makiaka am anánkaopwerao Lotu nap tokwae mek Kwarén kar toropwap neria akwapea yakria maok, ");
INSERT INTO yuj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","am Farisi mekamp arop fokopeyakrá námokuráp nɨnɨk mek poup Kwarén sérrá, ‘Ono ankwap arop fárákap niamp mo nampara, amwan aesio rae. Arop ankwap fárákap te poupwekápria nkwakwe make ankank puri fek nénk mo i konap. Tá nkwakwe make kwatae nɨnɨk i konapono. Tá poumou nap mekamp yupu kokopor i konapono. Tá ono te mámá takis sámp konámp arop niamp take mono. ");
INSERT INTO yuj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ono te Sarere méntép anánk kumur fek fɨr sámp moria, kápae kare ankank sámp namp te fére-sámpramp fi pɨrékarea maok, ono amwan ankwap fi sánk konampono.’ ");
INSERT INTO yuj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Aeno takis sámp konámp arop te panek fokopeyakria yámar mek nke te mo, me pakáráprá námokuráp éntér kor fek porokwaprá sérrá, ‘Kwar e! Ono te kwatae nɨnɨkráp aropono. Amo onan aropompae.’” Takrá séri pwarará maok, Jisaso am fárákapan sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ono yumwan kare kar sér rae: Nopok takis sámp konámp arop námokuráp nap mek arákarrá akwap námp, mao saráp Kwaro nke námp fek te yae-párák kare aropono. Aeno am arop ankwap te mono. Am te apae riteanápe, arop, námo tokwae kar namponoria warákarrá námokuráp e narek sampok nánko te, Kwaro man apárok sámp-anámp naerámpon. Aeno arop námoku apárok sámp-anámp nánko te, Kwaro maomp e narek sampok naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Koumteouráp aropao náráp tárápuan, Jisaso yae paprá ourour nénkanoria éréképá korop. Aeapan maok, mao éréképá yárakimp arop fárákapao nkeaka am koumteouráp aropan yopor. ");
INSERT INTO yuj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Aenapo maok, Jisaso am tárápu kánanke-tárápan, wonae fik koropenkria érékép fákeyakrá am fárákapan sérrá, “Yumo épér morok tárápu ononampok korop mwaria napo taokor kwapono. Numwar koropanápono. Kwaromp firáp taokeyak námp te, mámake pourouráp épér morok tárápu niamp arop fárákapampono. ");
INSERT INTO yuj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ono yumwan waeman kare kar sér rae: Épér morok tárápao ankank sánk napo, koupour sámprá warákár konámpnámp taknámp, Kwaromp firáp taokeyak námp koupour sámp moianámp te, am mek yink mwanap pourou mo karenono.” ");
INSERT INTO yuj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juda mekamp arop ankárank arop taokeyak konámpao Jisasén turunkrá, “Tisa kwapwe kare e! Ono te mokopia fwap yiki yak sámpea yiki yaká yak nanampono?” ");
INSERT INTO yuj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tá Jisaso man sérrá, “Amo onan apaerá ‘Kwapwe kare’rá sér rape? Kwar ankárankao saráp kwapwe kareno.” ");
INSERT INTO yuj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aerá séri pwatea maok, man sérrá, “Amo te lo waeman mér napon: Yupuráp arop, poumouráp yupu, yumo te kokopori kwapon. Amo arop sámp-wouroump kwapon. Amo oukuni kwapon. Amo arop ankwapan kwekári kwapon. Amo te ankár waráp éntupwar naropwaromp yae ankore mek yakria, maomp karwaokampo.” ");
INSERT INTO yuj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aeránko maok, arop taokeyak konámp aropao kor sérrá, “Am lo te ono wae épér feknámpia ankár ponankor mántwaokrá koropea oukoumwan nampon.” ");
INSERT INTO yuj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Makrá séránko maok, Jisaso am kar wawia man sérrá, “Amo ankwap ankárank aran mo napono. Waráp ankank kápae karenámp támá arop mani fek ti napo, am mani sámpeaka ankank monap aropan nénkampo! Amo takria maok, yámar mekamp kwapwe kare ankank sámp nanapon. Takia maok, amo onomp wakmwaek koropae.” ");
INSERT INTO yuj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Makránko maok, am aropao kor am kar wará yárakrá, náráp ankankantá nɨnɨk tokwae. ");
INSERT INTO yuj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisaso am arop náráp ankankantá nɨnɨk tokwae nánko nkea maok sérrá, “Arop fárákap kápae kare ankankráp te Kwaro náráp firáp taokeyaknámp mek yink mwanap te kour-sɨr kare námpon. ");
INSERT INTO yuj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel te aomp i konap nil me mek yoump naerianámp wuriman kour-sɨr námpono. Aeno ankank tokwaeráp aropao Kwaro náráp firáp taokeyak námp mek yoump naenámp te kour-sɨr kare námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aeránko maok, am arop fárákap am kar wawia sérrá, “Takanánko te, wa mokop am mek yoump naenámp pwi námpon?” ");
INSERT INTO yuj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aerá sérapo maok, Jisas warko sérrá, “Aropao tére mwanap pourou monámp ankank te Kwaro fwap tére naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Aeránko maok, Pita arakrá sér, “Ae te yino yinomp némp ntia yinomp ankank wae pwarará waráp wakmwaek korop námp te mokopono?” ");
INSERT INTO yuj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Aerá sénánko maok, Jisaso am fárákapan arakrá sér, “Ono waeman yumwan kare kar sér rae: Arop ponankor Kwaro náráp firáp taokeyak naenámpan nɨnɨkia náráp nap, náráp yupu, náráp ankwapnáp, náráp éntupwar naropwar, náráp tárápu, makia ará wampwe pwar námp te, ");
INSERT INTO yuj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Kwaro am fárákap manénkɨr ti-fákeyakápnap ankankan oukoumwan má apár mek yakáp nap fek kámá-pwarará, kápae kare nénk naenámpono. Tá nánkár wakmwaek korop naenámp ke fek kuri yaká yakáp mwanap yiki yak kwapwe sámp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisaso námoku éréképea yárak i konámp arop éntér-sámpramp mwar éréképea kánánkámp am fárákapan saráp arakrá sér, “Yumo wawenk. Oukoumwan te nomo Jerusalem mek tukup mwanámpono. Wokwaek kar profet fákárerao Aropamp Tárápamp pourouk korop naenámp ankankan kumwiap kar te oukoumwan te wae kare korop naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Man te arop ankwap firamp yaek sánk napo, man wouroumprá amomoránkriaka atatop mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Aeria maok, man tárapore kákákia sumpwi pap mwanapon. Ae mwanapan maok, yinɨnki yakea warko fárámp naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aerámpan maok, námoku éréképá yáraknámp arop fárákap te am kar fi te mek wouroumpeyak námpara, fwapia mér mo, épérépiapon. ");
INSERT INTO yuj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisaso akwapea, Jeriko mek wonae fikánko maok, yi wurumpi yaknámp arop ankárankao mwae fik tankrá koumteouráp aropan ‘Mani sápenk’ ria fépénrá tank. ");
INSERT INTO yuj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aenámpao mao wa nánko, koumteouráp arop kápae kare man kámákáprá tukup napo maok, mao arakrá turunkrá, “Máte apaen nape?” ");
INSERT INTO yuj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aeránko maok, man sérrá, “Máte Nasaret mekamp Jisaso korop námpan nape.” ");
INSERT INTO yuj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mak rapo maok, mao wará yárakrá, náráp yi am fwapi papanoriakámp kwamp, Jisasén tae fek wumwirá, “Jisas! Devitomp ou fekamp Táráp e! Amo onan aropompae!” ");
INSERT INTO yuj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mao makrá wumwirá sénánko maok, manénkɨr mekia tukupap aropao man yoporrá sérrá, “Amo te kar pwarae!” Aerapan maok, am arop te ankár tékén arakrá wumwia wae, “Devitomp ou fekamp Táráp, amo onan aropompae!” ");
INSERT INTO yuj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aeránko Jisaso mankea fokopeyakrá am arop fárákapan sérrá, ‘Yumo wonae fik mampok warámp samankenk’rá séránko, mao kor mankea wonae fikánko maok, Jisaso man turunkrá, ");
INSERT INTO yuj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Amo te ono amwan apaeria nape?” Aerá turunkánko maok, am aropao kor sérrá, “Tokwae Kar e! Ono te yi nke nae rae.” ");
INSERT INTO yuj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aeránko Jisaso man sérrá, “Waráp yi te wae fwapano. Waráp onan mér nap fek tapek amo warko fwap napon.” ");
INSERT INTO yuj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aeránko maomp yi wae fwapánko, fwap nkemp kwamp maok, Jisasomp wakmwaek akwapria maok, warákárrá, ‘Aesio! Onomp Kwar!’ ria Kwaromp e sakaprá akwap. Tá ponankor koumteouráp aropao kor am táman nkea Kwarén warákárrá maomp e sakapiapon. ");
INSERT INTO yuj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","Jisaso akwapea Jeriko mekia akwap naeria. Aenánko maok, arop ankwap Jeriko mek yak námp, maomp e te Sakius. Mao te takis sámp konap aropan taokeyak konámp maniráp aropono. Mao Jisaso korop námp wawia, Jisas te mokope aroponoria nkea mér naeria. Aenámpan maok, mao te arop pu fae ara, arop kápae kareao nánánkárapo maok, Jisasén nke naenámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ae námp kwamp maok, am fek pwarará, Jisas maomwaeknámp akwap naerámponoria, fárakop akwapea maok, yao mek poká tank. ");
INSERT INTO yuj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yao mek poká tankánko maok, Jisas akwapea am fekria mao narek am yao mek nkea maok, Sakiusén arakrá sér, “Sakius, amo koupour ékae. Ono oukoumwan te waráp nap mek akwap nanampon.” ");
INSERT INTO yuj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aerámpantá maok, mao koupour ékrá warákár karia Jisasén warámpea náráp nap mek akwap. ");
INSERT INTO yuj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aenánko maok, arop ponankor man nkeaka kánánkámp sérarrá, “Wɨ! Mao te kwatae nɨnɨkráp arop ankwapamp nap mek akwap námpwae!” ");
INSERT INTO yuj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tá Sakiuso fokopeyakrá Jisasén sérrá, “Tokwae Kar e! Oukoumwan te onomp ankank ponankor kuk pɨr-pwararea te, ankank monap aropan ankwapmwaek nénk nanampon. Ankwap te, ono kwekáriaka takis fekamp mani ono ankwapmwaek oukuni namp fek yiawor por nénk nanampono.” ");
INSERT INTO yuj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aeránko maok, Jisaso sérrá, “Oukoumwan Kwaro má nap mekamp arop ponankor érékép námpon. Aeno mámá arop te Abrahamo Kwarén mérimp niamp námpara, Abrahamomp ounáp támaono. ");
INSERT INTO yuj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aropamp Táráp te arop fárákap moyakáp napan oupourounkrá warko érékép naeria námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Makránko maok, am fárákapao Jisasomp am kar wawia nɨnɨkrá wae Jerusalem mek akwap naenámp fápae námpara, mao te akwapá Jerusalem mekria oukoumwan king yak naenámpan sérámpwe nɨnɨk napan maok, ");
INSERT INTO yuj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jisaso am fárákapan wounáp kar ankwap arakrá sér, “Arop tokwae ankwap te panekamp apár fi mek akwapeanánko, man king yoroi páte napo, námokuráp némpouk arákarrá koropea námokuráp fi arop poukeyak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mao wae akwap naerianámp ke fek, náráp tére konap arop fére-sámprampan koropenk ritea maok, mani sámpea 20 kina-20 kinará nénkria maok, am fárákapan sérrá, ‘Má mani fek mapek bisnis térerá yakáp napo, ono warko koropria nke nanampon.’ ");
INSERT INTO yuj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mak ritea akwap tenánko maok, námokuráp némpoukamp aropao mao king yak naenámp te warákár mo nap kwamp, am fekamp arop fárákap wakmwaek tirá kérép napo Sisaronámpok tukupea ‘Am arop te yinomp king yak te mono’rá sér. ");
INSERT INTO yuj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Aenapan maok, wae king yoroia páte napo, mao wae king yakria warko koropea némpouk. Aeria maok, arop fárákapan sérrá, ‘Onomp térenap aropan sénapo, koropea napo, mani profit apaekamp sámp naprá wawia mér nae.’ ");
INSERT INTO yuj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Aeránko maok, ankwapaomékɨr mekia koropea am mani nénknámp naropwarén sérrá, ‘Amo onan sápnap 20 kina te ono am fek téreaka kámákarrá 200 kina sámp nampono.’ ");
INSERT INTO yuj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Makránko maok, am kingo kor man sérrá, ‘Amo te kwapwe kare téreriaka kánanke kwarok ankankan kor yae-párák taokeyakrá tére kwapwe napara, ono amwan fére-sámpramp taun taokeyakaeria e tokwae sánk nanampono.’ ");
INSERT INTO yuj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Aeránko, ankwap ankárank wakmwaek koropea taknámp sérrá, ‘Amo onan sápnap mani 20 kina te ono am fek téreaka kámákarrá 100 kina sámp nampono.’ ");
INSERT INTO yuj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aeránko maok, kingo man sérrá, ‘Amo te éntik taun taokeyakae.’ ");
INSERT INTO yuj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Tá ankwap wakmwaek koropea sérrá, ‘Amo te kárákárea waerá yárakria, arop ankwapao pátenámp ankankan kor sámp, tá ankwapao yɨmp tenámp ankankan kor mokwap konapantá, amwan nkea apáp namp kwamp, waráp 20 kina mani má waempyam fákáre mek paprá yarokwapea má sampeyak nampon.’ ");
INSERT INTO yuj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aeránko maok, kingo am tére konámp aropan sérrá, ‘Amo tak nap te kokwae kare aropono! Amo onan nke napo, ono te kárákáre kor arop, arop ankwapao pátenap ankank ono sámp, ankwapao yoroi tenap fɨr ono mokwap namp nke konap mér napono. ");
INSERT INTO yuj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Amo te onomp mani beng mek páte napo, bengao ankwap mént tapokwapea páte nánko, koropea sámp nae mpupo.’ ");
INSERT INTO yuj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aeria maok, arop ankwap fárákap wonae fik am fek foukouri yakáp napan sérrá, ‘Yumo maomp yaekamp 20 kina pwarokwapeaka 200 kina sámpá yaknámp arop táman sánkenke.’ ");
INSERT INTO yuj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Aerá séránko maok, am arop fárákapao kor man sérrá, ‘Arop Tokwae, mao te wae 200 kina samp yak námpono.’ ");
INSERT INTO yuj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Aerapo maok, kingo sérrá, ‘Arop ponankor ankank sámpá yak kourapo te, tá ono warko ankwap mént nénk nanampon. Aeno arop ankwapao ankank fwapia sámpá yak mo, kánanke kwarok mwar sámpá yak nánko te, ono fwap maomp yaekamp warko pwarokwap nanampon. ");
INSERT INTO yuj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aeno arop onan ‘King yakria yinan taokeyak mono’ ria paokopnap arop fárákap te yumo am arop éréképá koropea onoku nke namp fek mapek faoporia kákenke.’” ");
INSERT INTO yuj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisaso am kar séria pwarará maok, Jerusalem mek akwapnámp mwae párák mekia pok. ");
INSERT INTO yuj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfage ntia Betani te Oliv Faonkwek am mek yaknep némpouk pok naeria wonae fik am fek námoku éréképá yárakimp arop yaworanmékɨr tirá kérépria ");
INSERT INTO yuj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","sérrá, “Yumokɨr pokea némpouk nke nepo, donki soup ankárank oukoumwan arop am fek tank moinap nap-topok tokorop tenap yak nánko te, táman aokorop-pwarareaka warámpea koropenke. ");
INSERT INTO yuj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tá arop yumwan nkea ‘Yumo te apae neria donki aokorop-pwar rep?’rá turunk napo te, yumo nopok pwarokwaprá sérrá, ‘Yinomp Arop Tokwaerao mént tére naenámpono’rá sér kip.” ");
INSERT INTO yuj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aerá séria pwarará maok, am arop yaworan tirá kérépánko, am arop yawor kor akwapea Jisaso sérimpaok am donki wae nke. ");
INSERT INTO yuj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Am arop yaworao am donki soupamp pouroukamp paok aokorop-pwarepo maok, am donkiramp naropwar nkeaka, am arop yaworan turunkrá, “Yumo te apae neria am donki soup aokorop-pwar repe?” ");
INSERT INTO yuj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aerapo, arop yaworao sérrá, “Yinomp Tokwae Karao am fek tére naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aea maok, am arop yaworao donki am warámpea koropea Jisas yak námp fekia maok, náráp waempyamráp donkiramp paonkore kor fek kákea pwarepo maok, Jisas kor donkiramp pourouk am waempyam yumuntuk tank. ");
INSERT INTO yuj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","37","Aeria maok, am Oliv Faonkwek am mwaek pɨkánko, koumteouráp aropao nkeaka, Jisas ampaok akwapanoria náráp waempyam mwaeaok yunkrá tukup. Aenapo maok, Jisaso am yumuntukaok akwap naenánko maok, maomp wakmwaek tukupnap arop kápae karerao kor Kwaromp kárákáre manénkɨr yénk nánko, nke konap mént nɨnɨkia maok, Kwarén warákára waeria maok, Kwaromp e narek sampok. ");
INSERT INTO yuj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Aeria maok, tékén wumwi kar fek sérarrá, “Kwar Tokwae námoku sámp-kérépnámp King táman ourour tokwae sánkano! Yonkwae porokwe kwapwe yámar mek yak námpono. Nomo Kwaromp eran saráp sámpea narek karaok samp yakáp mwaro!” ");
INSERT INTO yuj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aerapo, Farisi ankwap fárákap am koumteouráp arop ou mek yakápria Jisasén sérrá, “Tisa! Amo te waráp arop fákáre te yoporae! Am fárákap take pourouráp kar sér te mono.” ");
INSERT INTO yuj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tá Jisaso am fárákapamp kar pwarokwaprá arakrá sér, “Ono yumwan sénampono: Ae te mámá arop fárákap kar tákap mo napo te, yumwirao námoku Kwaromp e sakaprá warákár mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas akwapea taun Jerusalem mek wonae fikria Jerusalem nkeaka, Jerusalemantá émria ");
INSERT INTO yuj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","sérrá, “Jerusalem e! Onomp nɨnɨk te, mámá yae fek ankank amwan yae-párák yaewour nanko yonkwae porokwe fek yak nanap méraeria nampon. Aeno am ankank te mek wouroumpeyak nánko, amo oukoumwan nke mo napon. ");
INSERT INTO yuj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Amo wawae: Wakmwaek ankwap ke korop naenámp te, amwan yorowar naenámp arop koropea amwan saokor-yakáprá, yár firi ponankor ɨkɨr-yakáp mwanape. ");
INSERT INTO yuj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Waráp tárápu am mek yakáp napan kor méntér kwatae pap mwarea napon. Amo te Kwaro koropeaka amwan yaewour naenámp ke te wuri nke moi napara, yumwi ankwap ankárankao kor ankwap yumuntuk tank mo, waeman ponankor souroumpouri sɨr mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisaso Jerusalem mek pokeaka lotu nap tokwae mek youmpea nke nánko, arop ofa sánk mwanapria sipsipráp antráp ti-koroprá lotu nap tokwae mek nénkrá mani ti. Aenapo, yéréperá kérépria, ");
INSERT INTO yuj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","am fárákapan sérrá maok, “Kwaro náráp Buk fek sérrá, ‘Onomp nap te Kwarén kar toropwap mwanap nap yak námpon’rá sénámpon. Aenámpan maok, yumo mákia arop fupukrá ankank pouroukoup konap aropao mek wouroumpá yakáp konap me niampi pap nape!” ");
INSERT INTO yuj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jisaso am lotu nap tokwae mek koumteouráp aropan kumur-kumur Kwaromp kar farákáp saráp yak námpantá, pris tokwae fákáre, tá lo yénkrá farákáp konap arop, tá arop taokeyakáp konap arop fárákap, makia Jisasén apae fek sámp-wouroump mwarrá mwae kup oupourounk. ");
INSERT INTO yuj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aeapan maok, koumteouráp arop ponankor kárákáre fek Jisasomp kar wa napantá maok, am arop taokeyakáp konap arop fárákapao man mwanap mwae kup nke mo nap kwamp, wampwe kwaeria pwarariapon. ");
INSERT INTO yuj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ankwap kumuruk Jisaso lotu nap tokwae mek koumteouráp aropan Kwaromp Kwapwe Kare Kar yénkrá farákáp. Aenánko maok, pris tokwae, tá lo yénkrá farákáp konap arop fárákap ntia arop taokeyakáp konap arop makia Jisasnámpok korop. ");
INSERT INTO yuj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Koropea maok, Jisasén turunkrá, “Amo e tokwae maokamp sámpea am tére tére napon? Amwan te wa am tére tére nanap kárákáre sánk tenánko, tére napon? Yinan sérae.” ");
INSERT INTO yuj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aerapo maok, Jisaso nopok am fárákapamp kar pwarokwaprá sérrá, “Ono kuri yumwan ankárankamp ankank turunk nae nae. Yumo onan sér kipo. ");
INSERT INTO yuj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jono arop ént mek néri námp te, yumo nɨnɨk nap te, am te Kwaromp ankank ni, aropamp ankank nie?” ");
INSERT INTO yuj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Aeránko maok, am arop fákárerao kor námoku téréménkrá sérarrá, “Nomo ‘Kwaromp ankankono’rá sénánko te, námwan ‘Ae te yumo apaerá Jono sérinámp kar mér mo napono?’rá sérantáno. ");
INSERT INTO yuj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tá nomo ‘Aropamp ankankono’rá sénánko te, am arop fárákapao Jon te profetonorá mér kárákáre napara, nomwan yumwi fek yérénkép mwanape.” ");
INSERT INTO yuj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aerá séria pwarará maok, warko Jisasén sérrá, “Yino te Jon arop ént mek néri námp te mér moreano. Am te maokamp sámpea niane.” ");
INSERT INTO yuj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aerapo maok, Jisaso am fárákapan sérrá, “Ono kor am kárákáre maokamp sámpeaka am fek tére namp te ono yumwan sér mono.” ");
INSERT INTO yuj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisaso koumteouráp aropan wounáp kar arakrá sér, “Arop ankárankao wain yopwar yɨmpea pwarará maok, am mek térerá mani sámp mwarianap aropamp yaek pwarará, mao námoku te akwapea ankwap némpouk tokwaeri ke fek yak. ");
INSERT INTO yuj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Aea maok, am wain ki yápae nánko kánánkáp konap ke fek maok, am yopwar mek térenap arop náráp por wain ki ankwapmwaek sánkanáponoria, náráp tére konap arop sámp-kérép. Aenámpan maok, am mek térenap arop fárákapao man fukia yérépea kwaporok sámp-kérép. ");
INSERT INTO yuj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tá yopwar naropwar warko tére arop ankwap maonapok sámp-kérép. Aenámpan maok, man kor pwarápae sánkria fukia yérépe napo, yaenémpi arákarrá akwap. ");
INSERT INTO yuj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tá warko tére arop yinɨnkan sámp-kérépánko, man kor taknámp fukia ek yérépe. ");
INSERT INTO yuj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aeapantá maok, warko am yopwar naropwaro kor, ae te mokop naeria maok, ‘Onomp poumou-táráp ankárank ono warákár tokwae namp man sámp-kérép nanko te, fwap maomp kar wa te mokop mwanape?’ ");
INSERT INTO yuj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aeriaka man sámp-kérépánko maok, akwapánko, am yopwaraok téreap aropao kor am tárápan nkea námoku kok sérarrá, ‘Nko arop korop námp nkote waeman naropwaromp weri mek yakria, nánkár wakmwaek náráp ankank waeman ponankor sámp naerianámpon. Nomo koupour man sámpea faropea papria maok, nomoku má yopwar má sámp mwanámpono.’ ");
INSERT INTO yuj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aeria maok, am aropan sámpea kakaprá yár younkwek sɨrarrá maok, faropea pap. Aenapo yumo nɨk nap te, am yopwar naropwar te am arop fárákapan te mokop naenámpon? ");
INSERT INTO yuj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mao te koropea am yopwar taokeyakáprá térenap aropan te tirá wouria pwarará, am wain yopwar te ankwap fi aropan sánk naenámpon.” Aerá séránko, am arop ponankor am kar wawia maok, “Wɨ! Mao tak te mono.” ");
INSERT INTO yuj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aerapo maok, Jisaso yopwar naropwaromp tárápan far-pwarapan nɨnɨkia warko am fárákapan tokore yakrá sérrá maok, “Kwaromp Buk fek yaknámp kar arakrá sér, ‘Mámá yumwi te térenap aropao kwataenoria sɨtenapan maok, oukoumwan te am fek nap kárákáre yak naenámp yumwi kwapwe yak námpon.’ ");
INSERT INTO yuj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Arop ponankor am yumwi yumuntuk sɨkɨrɨp nap te, kour ták-ták-faokoria tank naenámpon. Tá am yumwiao arop pourouk pɨká párákapea anámpria te, kour ponankor sokwapá pap naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisas arakrá séránko maok, lo yénkrá farákáp konap arop fákáre, tá pris tokwae fákárerao kor Jisaso wounáp kar sérámp am wae wawia méria maok, námoku nɨnɨkrá, máte waeman yinan sénámp karenoria fápárámprá man wae sámp mwaria. Aenapan maok, warko maomp kar wanap aropan apápia pwararapono. ");
INSERT INTO yuj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Am arop fárákapao Jisas te mokop kunria yépékrá paokopap kwamp, arop ankwap fárákapan, tukupea páráknámp paokoprá Jisas térenámp yurukupenkria tirá kérép. Aenapo am fárákap kwekárrá, Jisasomp kar wa mwar kar nap niamprá paokop. Am fárákap Jisas te mokope kar séran wawia man kotia gavman tokwaeramp yaek pap napo, man kot naenámpria poupwekáp kar sérar napon. ");
INSERT INTO yuj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Am fárákapao Jisasén turunkrá, “Amo tisa yakrá téreriaka arop kar farákáp nap te yae-párák kare nánko, yino wae wawia mér námpon. Amo te waeman ankárankamp pourouráp nɨnɨk fek ponankor aropan nɨnɨk i konapono. Amo te Kwaromp nɨnɨk námpaok koumteouráp aropan kare kar kar yénkrá farákáp konapono. ");
INSERT INTO yuj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Amo tak napantá, yino amwan turunkriano: Amo te mokoprá nɨnɨk rap? Mosesomp loao nomwan ‘Fwap King Sisarén takis sánk mwanámpono’rá sénámp ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aerapo, Jisas am fárákapamp poupwekáp nɨnɨk te wae mér námp kwamp maok, am fárákapan sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ae te yumo onan mani náparamp sankoropea onan yénképenk. Am mani fek yaknámp arop wunéri ntia e te wampono?” Aeránko maok, am fárákapao sérrá, “Am te Sisarompono.” ");
INSERT INTO yuj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aerapo maok, Jisaso sérrá, “Sisarompao nánko te, yumo te Sisarén sánk. Tá Kwaromp ankank te, yumo ankár Kwarén sánk kip.” ");
INSERT INTO yuj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jisaso am kar pwarokwaprá sérámp kar wawia nɨnɨk tokwaeria maok, apae maomp kar te kwataenámpan arop nke nap fek man war-santukupea kot mwanámpanápe wampwe kwaeria kar tákap mo, pwar. ");
INSERT INTO yuj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi fákáreramp nɨnɨk te, arop wae sumpwianámp te warko fárámp naenámp pourou mono. Aerá nɨnɨknap Sadyusi ankwap fárákap Jisasnámpok korop. ");
INSERT INTO yuj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Aea maok, am fárákapao Jisasén sérrá, “Tisa, wokwaek kar Moses kumwiaka nomwan sérrá, ‘Arop ankwapao yupu sámpeaka táráp sámp moiteaka sumpwi nánko te, warko nánaerao am yupu sámpeanánko, tárápu tianánko te, am sumpwinámp naeramp weri mek yakáp mwanapon.’ ");
INSERT INTO yuj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ae te fákánek mwearoao naeraomékɨr yupu sámpea táráp sámp moi yakrá, sumpwi. ");
INSERT INTO yuj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tá warko maomp nánaerao sámpeaka sumpwi. ");
INSERT INTO yuj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Táte yinɨnkao kor warko am yupu sámp. Am fákánek mwearo te takrá tukupea ponankor tárápu yak mo nánko, surumpwi tenapo, ");
INSERT INTO yuj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","am yupurao kor wakmwaek sumpwi. ");
INSERT INTO yuj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Am fákánek mwearoao am yupu mao sámpá, mao sámpá-rá tukupea nap te, nánkár wakmwaek sumpwianap arop ferámpeanap ke fek te, mao wamp yupu kare yak naenámpon?” ");
INSERT INTO yuj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aerapo Jisaso am fárákapan sérrá, “Oukoumwan apárok yiki yakápnap ke fek te, poumarop fwap yupu sámpá, yupurao kor fwap poumou nap mek tank naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Aeno nánkár wakmwaek Kwaro fwap ferámpea kák naenámp pwinámp arop fárákap te yámar mek yiki yakáp nap fek te, yupu sámp mono. ");
INSERT INTO yuj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Am fákáre te Kwaro apár me mekamp ferámpea kák nánko, Kwaromp tárápu yakáp napara, warko sumpwi mono. Ensel fákárerao yakáp napnámp taknámp yakáp mwanapono. ");
INSERT INTO yuj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moseso kor, sumpwinap arop te warko ferámp mwanaprá nomwan farákápámpon. Wokwaek kar yao yiki kánanke mek yaomwi yurunk tank námp fek, Kwaro Mosesén sérrá, ‘Kwar Tokwae te Abraham, Aisak, Jekopomp Kwarono.’ ");
INSERT INTO yuj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tá taknámp, Kwar te apae sumpwinap aropamp Kwaranápe, yiki yakápnap arop fárákapamp Kwarono. Pourou te sumpwi napao maok, Kwaro nke námp fek te ponankor yiki yakáp napono.” ");
INSERT INTO yuj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Makrá séránko maok, lo kar yénkrá farákáp konap arop ankwap fárákapao wawiaka sérrá, “Tisa! Amo sénap kar te kwapwe kare námpono.” ");
INSERT INTO yuj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aeriaka pwarará maok, warko turunk mwarea kapao pwarápae nap kwamp apápria pwararapono. ");
INSERT INTO yuj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aeapo maok, Jisaso Farisi fákáreran sérrá, “Ae te mokopiaka ‘Krais te Devito yakámp fi mekamp aropono’rá sénapono? ");
INSERT INTO yuj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Devit námoku wokwaek kar Buk Song fek kumwiriaka sérrá, ‘Tokwae Karao onomp Tokwae Karan sérrá, “Amo te onomp yae-párák mwaek tankea napo, ");
INSERT INTO yuj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nánkár wakmwaek amwan yorowar i konap aropan waráp yae ankore mek párakop tenanko, yakáp mwanapon.” ’ ");
INSERT INTO yuj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit námoku Kraisén ‘Onomp Tokwae Kar’rá sénámpao maok, mao te mokopia warko Devitomp ounáp yak námpono?” ");
INSERT INTO yuj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Arop ponankor oukoumwan am fek yakrá Jisas sérámp kar wará yakápapo maok, tá warko Jisaso námoku éréképá yárakimp arop fárákapan sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Yumo te kar yénkrá farákáp konap arop fárákapan fwapnae karia mér kip: Am fárákap te youén táman, arop námwan nkeanáponoria waempyam éri kare fek képéri pwateaka paokopria, arop koupoukour nap mek tukup napo, námwan kápae kare aropao warákárria me pakáráprá ‘Gude’rá séranápon kar i konapono. Tá ankwap te, arop námwan nkeanáponoria tukupea lotu nap mek mekok tankápria, ankwap te, fɨr kékérou nap fek arop tokwaeramp wonae fikamp sia fek tukupea tankáp konapon. ");
INSERT INTO yuj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tá am fárákap kae koumteouan poupwekáprá maomp nap mekamp ankank ponankor ti konapono. Tá ankwap te, náráp am nɨnɨk oupoupourrá, arop námwan nkeanáponoria yoporop kar éri fek Kwarén kar toropwaprá paokop i konapon. Ae konapan maok, nánkár kotnap ke fek te am fárákap te yoporop touwe tokwae sámp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisaso lotu nap tokwae mek yakrá énounkouprá yakria nke nánko maok, mani tokwaeráp arop fárákapao náráp ofa mani lotu nap tokwae mekamp bokis mek épér. ");
INSERT INTO yuj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aenapo maok, Jisaso nke nánko, kae yupu ankwap mani mo námpao maok, mani kánanke anánkamp támao mwaran sankoropea bokis mek sɨr. ");
INSERT INTO yuj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aenánko maok, Jisaso sérrá, “Ono yumwan kare sénampon: Mámá mani monámp kae yupu mani tokwae kar sɨrarea arop ankwap fárákapao sɨnapan kwe-pwarámpon. ");
INSERT INTO yuj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Am kápae kare arop fárákap te mani kápae kare ankwapmwaek tank nánko, ankwapmwaek mwar Kwarén sánk napono. Aeno mámá kae yupu te fɨr sámpá fánaenámp te ankwap tank mo karenámpao maok, ankár ponankor sɨnámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Arop ankwap fárákap lotu nap tokwae táman sérarrá: “Arop fárákapao kwapwe kare yumwi, tá nkwakwe make ankank koumteouráp aropao Kwarén kwaporok nénk nap tia am nap moporia pwate napon.” Aerapo maok, nopok Jisaso sérrá, ");
INSERT INTO yuj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mámá ankank yumo oukoumwan nke nap te nánkárap ankwap ke fek te am nap mekamp yumwi ankwap yumwi yumuntuk te tank mono. Am te ponankor aropao momontokoria apárok sɨr mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Aeránko maok, am arop fárákapao Jisasén turunkrá, “Tisa, mokope ke fek am ankank korop naenámpon? Apae ankank manénkɨr korop nánko, yino táman méria, am ankank korop naenámp ke te wae wonae fekáneria nɨnɨk mwanámpon?” ");
INSERT INTO yuj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisaso sérrá, “Yumo fwapia mér kip. Takria yumwan kápae kare aropao poupwekáp mwanape. Am te apae riteanápe ‘Námo te am arop támaono’rá séria, ‘Pwarnámp ke oukoumwan wae wonae fik korop námpono’rá sénapo te, yumo táman wawia maomp weaok mwaek tukup kwapon. ");
INSERT INTO yuj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tá nánkár wakmwaek yumo yorowarnap purunk, tá yorowar tokwaenap kar waria te, yumo apáp tɨrɨnkria kour me woukouri kwapono. Am ankank te wae manmékɨr korop námpao maok, pwar naenámp yae te oukoumwan tamak korop mono.” ");
INSERT INTO yuj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tá mao warko sérrá, “Arop ankwap firao ankwap fi aropan yorowar, tá ankwap kingomp fákárerao ankwap kingomp fákáreran yorowar mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Táte némp yérur tokwae korop. Tá kápae kare apárok yae-porokwe tokwae korop, touwe tokwae korop naerámpon. Aeria yumo nke napo, yámar mek nkwakwe make mwar pourouráp ankank koropánkria yumwan apáp tokwae sánk naeane. ");
INSERT INTO yuj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Aeno manénkɨr te am ankank oukoumwan korop mo nánko, yumo Kwaromp firáp yakáp napara, yumwan ti-fápákampria ti-yampourou mwanape. Yumwan lotu nap mek kotia kalabus nap mek kák mwanape. Tá king ntia gavmanomp yi mek éréképá tukupea kot mwanape. ");
INSERT INTO yuj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yumwan am tak nap te yumo fwap Kwaromp Kar farákáp mwanap mwae kup támaono. ");
INSERT INTO yuj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aenámpara, yumo, am fárákapan nopok kar sér mwanámp nánap mwarrá nɨnɨki kwapono. ");
INSERT INTO yuj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Waeman fwap onoku yiráp táp mek kar papria yumwan yonkwae kour nénk nanampon. Aenanko kápae kare arop yumwan yoporap te, ono yumwan sánknamp karan ták-pwar mo, sámp-anámp mo mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yiráp éntupwar naropwar, naeounáp, ankárank fi arop, nouroup fárákap, mao kuri yumwan yopor aropamp yaek pap mwarea napon. Aenapo, ankwap fárákap yumo ou mekamp tirá wour mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Am tak nap te, yumo Kwaromp firáp yakáp napara, arop ponankor yumwan kokwarokria napon. ");
INSERT INTO yuj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Táte yiráp me korokamp me pwae ankwap ankárankamp kwaporok moyak mono. ");
INSERT INTO yuj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Aenámpara, yumo kárákáre fek fokopeyakápria, yumokuráp yiki yakápá yakáp mwanap sámp mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tá Jisas ankwap kar sérrá, “Aeno táte nánkár yumo nke napo, ami fákáre koropea Jerusalem sámp-saokor napo te, yumo táman mér kip: Taun souroumpour mwanap ke te wae wonae fik námpon. ");
INSERT INTO yuj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Am ke fek te arop fárákap apár Judia mek yakáp nap te ankár pɨrɨkɨmpea you mek pok mwarea napon. Tá arop fárákap Jerusalem mek yakáp nap ankár am taun pwararea ankwapok pɨrɨkɨmpá tukup mwarea napon. Tá arop ankwap fárákap némp kánanke-táráp fekmwaek yakáp nap Jerusalem mek te tukup mo kareno. ");
INSERT INTO yuj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Am ke te Kwaro sokoronap arop fárákapan nopok touwe kwatae sánknámp kenon. Aenámpara, am kar ponankor te Kwaromp buk fek yak námp kare kar korop naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Koumteou tárápu yakáp nap, tá wae yaek fákeyakáprá mom wunnap koumteou am ke fek te koupoutáráp nape! Am apár mek te touwe tokwae korop nánko, Kwaromp yonkwae pwarámp te waeman am mekamp koumteouráp aropan sámp naerámpon. ");
INSERT INTO yuj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ankwap fárákap bainat fek faoporrá épérrá, ankwap fárákap fápákamánkia ankwap-fi ankwap-fi mekmwaek ti-tukup mwarea napon. Takria ankwap fi arop fárákapao Jerusalem poukeyakáprá tukupea Kwaro ‘Wae támaono’rá sénámp fek pwar mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tá Jisas warko ankwap kar sérrá, “Pwarnámp yae korop naeria nánko, yámar, yunk, térmeamp pourouk nkwakwe make ankank koropánk nánko, solwara tokwae souroukoupriaka purunk tokwae nánko, apárokamp arop fi ponankor nkea yonkwae touwe foforia apáp tɨrɨnka wae mwanapono. ");
INSERT INTO yuj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Am ankank apárok korop naerianánko, kápae kare koumteouráp arop nɨnɨkria apáp tɨrɨnkria yi mánmán mwanape. Am te apae riteanápe, yámar mekamp térmeráp ankank sámpá wuwi naerámpon. ");
INSERT INTO yuj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Am ankank koropea pwaránko, Aropamp Táráp koumwe meknámp kárákáre tokwae ntia wae tokwae méntér ék nánko, nke mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Am ankank fi yokorrá korop nánko, am ke fek táman yumo ankár fokopeyakrá narek tokoreyakáp mwanapon: Kwaro yumwan warko éréképea yámar mek pok naenámp ke te wae wonae fik korop námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tá warko am fárákapan wounáp kar arakrá sér, “Yumo yao fikráp ankwap yao aran nkenke. ");
INSERT INTO yuj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Táte yumo nke napo, pwae páre nánko te, ‘Oukoumwan te yámar kwapwe naenámpono’rá sér i konapon. ");
INSERT INTO yuj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Táte taknámp, yumo nke napo, yámar mek am ankank koropánk nánko te, yumo wae mér mwanapono: Kwaromp firáp taokeyaknámp ke te wae wonae fik korop námpon. ");
INSERT INTO yuj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ono yumwan kare kar sénampon: Mámá kear mekamp koumteouráp arop fárákap oukoumwan sumpwi mo, yakáp napo, am kápae kare ankank korop naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yámar me ntia apár te akwapea pwar naenámpon. Aeno onomp kar te akwapá moyak mono.” ");
INSERT INTO yuj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Aeno yumo fwapia mér kip. Yumo takria fɨr kápae ntia mánmán ént fépérrá mánmánrá paokop mwanape. Yumo takria pouroukamp ankankan saráp nɨnɨk tokwae mwanape. Take nɨnɨk támao yumwan oupoupouri fákeyak nánko te, am Arop Tokwae koropnámp yae te koupour kar koropria, ");
INSERT INTO yuj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","aopwerao kouan porokwap konámp niamp naenámpon. Am yae te kápae kare apárok yakápnap arop fi ponankoran korop naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ae naenámpara, yumo te ankár fwapia mér kare fek yakáp kip. Yumo ankár Kwarén kar toropwap saráp yakáp napo, yumwan kárákáre sánk naenámpon. Aeria maok, yumwan nkwakwe make touwe kwatae korop námpon kor, yumo fwap kwe-pwararea Aropamp Táráp yumwan yurukup naenámp fek yumo pwarápae mo, fwap fokopeyakáp mwanapon.” Jisas aerá séri pwara námpon. ");
INSERT INTO yuj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Am yinɨnk kumuri yak námp fek te, Jisas koumteouráp aropan lotu nap tokwae mek kar yénkrá farákáp ko, kumuruk Oliv Faonkwekamp némpouk akwapá amp i konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aenánko kápae kare koumteouráp arop te koumounek kar maomp kar wa mwaria lotu nap tokwae mek korop konapono. ");
INSERT INTO yuj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yis Moráp Pan Fárrá Lotu i konap Pasova Yae wae wonae fik nánko, ");
INSERT INTO yuj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pris tokwae fákáre ntia lo kar yénkrá farákáp konap arop fárákap mao Jisasén farop mwaria napao maok, koumteouráp arop fárákapao nkeantánia apáprá kánánkámp mokopia farop mwanámpria mwae kup oupourounk. ");
INSERT INTO yuj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satano akwapea Judas, ankwap e Iskariot, maomp nɨnɨk mek noumpoukoup. Am Judas te Jisas éréképá yárak i konámp éntér-sámpramp arop fárákap ou mekamp. ");
INSERT INTO yuj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mao akwapea, pris tokwae fákáre ntia lotu nap tokwae taokeyakáp konap soldia fákáre méntér tankrá, Jisasén am arop fárákapamp yaek sánk naenámpan sérarrá am naenámp mwae kup oupourounk. ");
INSERT INTO yuj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aenánko maok, am arop fárákapao warákáránkia maok, ‘Fwap amwan mani sánk mwanámp’rá sér. ");
INSERT INTO yuj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aenapo maok, Judas am fárákapamp kar wawia ‘Fwapono’rá séria maok, mao, arop nke mo nap ke fek am fárákapamp yaek Jisas sámp-sánk nanampria mwae yororia yépék. ");
INSERT INTO yuj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yis Moráp Pan Fári konap Yae wae korop. Am yae fek te sipsip morok, am Pasova fár mwanámpria yénkép i konapon. ");
INSERT INTO yuj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aenámpantá Jisaso Pita ntia Jonén tirá kéréprá, “Yumo akwapea Pasova fɨr nánapia nepo, nomo fár mwanámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aeránko maok, am arop yaworao Jisasén turunkrá, “Amo nɨk nap te, yino maok nánap nenempon?” ");
INSERT INTO yuj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mao am arop yaworan sérrá, “Yumo wawenke! Yumo Jerusalem mek akwap nepo, arop ankwap sospen mek ént yɨnkɨpea férek papea samprá akwap námp yumwan mwaeaok kɨkɨp naenámpon. Aenánko, yumo mao akwapnámp nap mek am mek maomp wakmwaek akwap kip. ");
INSERT INTO yuj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Aeria yumo ankár am nap naropwarén sérrá, ‘Amwan yinomp Tisa sérrá, “Námo náráp éréképá yárak i konamp arop fárákapént Pasova fɨr fánanamp nap aokore te maok yak námpon?” ’ ");
INSERT INTO yuj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aerá turunk nepo, mao yumwan narekamp aokore tokwae kákánarráp tankáp i konap fae ankank tankáp námpráp yénkép nánko, yumo am mek Pasova fɨr nánap kip.” ");
INSERT INTO yuj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Am arop yawor akwapea, waeman Jisaso séri námpaok taknámpia maok, wae Pasova fɨr nánapi pwar. ");
INSERT INTO yuj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Am fár mwanap ke korop nánko, Jisas náráp éréképea yárak i konámp aposelént fár mwaria tankáp. ");
INSERT INTO yuj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aeria mao am fárákapan sérrá, “Ono nánkár wakmwaek te touwe tokwae sámp nanampara, manmékɨr yumont mámá Yae Tokwae fek Pasova fɨr fánaeria warákár tokwae nampono. ");
INSERT INTO yuj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ono yumwan sér rae: Ono te warko Pasova fɨr fár mono akwapea Kwaro náráp firáp taokeyak naenámp ke fek am Pasova fánámp fi kare érik koropnámp ke fek fánanampon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Aeria maok, mao wainráp kap sámpea Kwarén kar fáparákia am fárákapan sérrá, “Yumo má sámpea ou fápárákaprá fárenke. ");
INSERT INTO yuj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ono yumwan sénampon: Ono te oukoumwania nánkárap kor wain ént fár mono, akwapea Kwaro náráp firáp taokeyak naenámp ke korop námp fek fánanampon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aeria maok, warko mao pan sámpea fákeyakrá Kwarén kar fáparákia pwarará, fopwaria am fárákapan nénkria maok, sérrá, “Mámá te onomp pourounono. Ono yumwan yaewour naenámpria nénk nampon. Kápae kare por yumo takria onan nɨnɨk kip.” ");
INSERT INTO yuj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pasova fɨr ponankor fépéria pwarapo, tá taknámp ankwap wainráp kapan kor takrá sér, “Mámá wain te onokump yɨri fek kontrak wourékam papea pwar namp wounápono. Aeriaka am yɨri te yiráp por kwarákárria yumwan yamokwap námpon. ");
INSERT INTO yuj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Aeno yumo nkenke: Am arop onan yopor aropamp yaek pap naerianámp te onont mámá kákánar fek fárrá tank námpon. ");
INSERT INTO yuj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aenámpan maok, Aropamp Táráp te fwap Kwaro nánapi tenámpaok akwap naenámpon. Aeno man yopor aropamp yaek sánknámp aropao maok, mao te koupouteane!” ");
INSERT INTO yuj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mao aerá sénánko maok, am arop fárákap námoku kok turunkuprá, ‘Ae te wa mokop tak kun?’rá sérar. ");
INSERT INTO yuj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Táte warko Jisaso éréképea yárak i konámp arop fárákap námoku ou mek táman kar yorowarrá, ‘Wa mokop nomp tokwae kar yak naenámpon?’rá sérar. ");
INSERT INTO yuj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aerapo maok, Jisaso am fárákapan sérrá, “Mámá apárokamp king tokwae te kárákáre tokwae napara, arop poukeyak nánko, arop fárákapao, mao te arop yaewour kwapwe konámprá nɨnɨk mwanapria napon. ");
INSERT INTO yuj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Aeno yumo te takrá nɨnɨki kwapono. Yumo ou mek arop tokwae kar yak naerianámp te, ankár nánae karao wakmwaek yak konámp niamp kuno. Tá yumwan taokeyaknámp arop te ankár yaewour naenámp tére arop niampi yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ae te wa tokwae karono? Arop tankrá fɨr fánámp ni, nopok tére arop fɨr nánapi sankoropá sánknámp arop nie? Am arop tankrá fɨr fánámp támao maok, tokwae karono. Aeno ono yumo ou mek yak namp te, tére arop arákarea yumwan yaewour nampon. ");
INSERT INTO yuj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ono wokwaek nkwakwe make touwe sámp nampon kor, yumo onan pwarará pɨrɨkɨmpá tukup mono. Waeman onont yakápi napon. ");
INSERT INTO yuj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Onomp Naropwaro maomp firáp poukwapá yak nanamp kárákáre sáp námpan, tá taknámp ono am kárákáre yumwan nénk nampon. ");
INSERT INTO yuj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ono am Kwaromp firáp taokeyak namp mek te yumo fwap onomp kákánar fek fɨr fépérrá ént fépér mwanapon. Yumo fwap kingomp sia fek tankápria éntér-sámpramp Israel fi mekamp koumteouráp arop fárákapan yurukup mwanap arop fárákap yakáp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisaso am kar séria pwarará, Pitan sérrá, “Saimon, Saimon, wawae! Kwaro takanorianánko, Satano, wa mokop Kwarént koumpeyak nánko, wa mokop Kwarén pwaran nke nae ritea yumwan yampourou naeria waeane. ");
INSERT INTO yuj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Aenámpan maok, ono wae amwan yaewourria Kwarén sénanko, amo onan mérap te onan ankár pwarará akwap mono. Warko wakmwaek arákarrá ononampok koropria waráp ankwapyaenápén kárákáre sánk nanapon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aeránko, nopok Pita man sérrá, “Tokwae Kar, ono te waeman amwan fákapria te, onan méntér fákap mwanapria nánap nampon. Tá ono waeman amont sumpwi nanampria nánap nampon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Aeránko nopok Jisaso Pitan sérrá, “Pita, ono amwan sénampon: Mámá kumuruk oukoumwan mámá kakaruk fárámp mo námp fek, amo yinɨnk por onan te ‘Mér mo nampono’rá sénae rapon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tá warko Jisaso am fárákapan sérrá, “Wokwaek ono yumwan tirá kérépanko tukupap fek te paus mani, brasbel, su, aráte ti-tukup moiapon. Am ke fek te yumo ankank ankwap moiap ni, fwap nie?” Aeránko maok, nopok am fárákapao sérrá, “Mono.” ");
INSERT INTO yuj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aerapo maok, Jisaso am fárákapan sérrá, “Oukoumwan te arop maomp paus mani tank nánko te, sámp, brasbelan kor tak. Táte arop bainat mo námp kwamp te, náráp waempyam aropan sánkria am fekamp mani sámpea bainat ankárank sámp kun. ");
INSERT INTO yuj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Am te apae riteanápe, Kwaromp Buk fek profet kar arakrá sér, ‘Kwatae nɨnɨkráp arop ou mek tapokwapá kouroump napon.’ Ono yumwan sénampon: Kwaromp Buk fekamp onan sénámp profet kar waeman ankár korop naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aeránko nopok am fárákapao sérrá, “Tokwae Kar, amo nkeae! Yino wae bainat anánkaopwe tank námpon.” Jisaso am fárákapan sérrá, “Aenánko te wae támaono.” ");
INSERT INTO yuj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Takia pwarará, Jisas Jerusalem taun pwarará Oliv Faonkwek wokwaek i konámpnámp taknámp náráp éréképá yárak i konámp arop fárákap éréképea akwap. ");
INSERT INTO yuj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Akwapea am fekria am fárákapan sérrá, “Yumwan Satano poupwekápantáno. Kwarén sénapo, ankár yumwan yaewour naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aeria maok, mao am fárákapan am fek párakoprá panek tae morok 30 mita fek akwapea kwaráp torokomprá Kwarén arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ayao, amo fwap tak naeria te amo onan touwe sáp mwanap má sámp-sɨnanapon. Aenanapan maok, onomp nɨnɨkaoki kwapono. Mono. Amo ankár amokuráp nɨnɨkaokampo.” ");
INSERT INTO yuj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aerá sénánko maok, yámar mekamp ensel ankárankamp maonámpok koropea man kárákáre sánk. ");
INSERT INTO yuj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisaso am touwe sámp naenámp táman yonkwae sakáp tokwaeria kárákáre fek Kwarén kar toropwap. Aenánko maok, maomp pouroukamp fápáre te yɨri niampria apárok fɨrɨkɨp pɨkrɨnk. ");
INSERT INTO yuj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mao Kwarén séria pwarará fokopeyakea maok, akwapea éréképá yárak i konámp arop fárákapan nke nánko, am fárákap te ankank kwatae Jisasomp pourouk korop naenámp táman yonkwae touwe tokwaeria kour porokwe nánko, pampi yakáp. ");
INSERT INTO yuj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Aenapo, Jisaso am fárákapan sérrá, “Apaerá pamp rape? Yumo fárámpea Kwarén sérenke. Takria Satanomp nɨnɨk koropea yumwan sámp nánko, kwatae nɨnɨk fek tukup mwanape.” ");
INSERT INTO yuj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisaso oukoumwan am kar takrá sérrá yak nánko, kápae kare arop ou wae korop. Aenapo am arop Judas, mao te am éntér-sámpramp éréképá yárak i konámp ou mekampao maok, mao mekia am fárákapan mwae yénképrá korop. Mao koropea Jisasomp wonae fikria man koupwiyakrá aop mukur naeria. ");
INSERT INTO yuj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aenánko maok, Jisaso man sérrá, “Judas, amo Aropamp Táráp kwekárrá koupwiyakrá aop mukuria yopor aropamp yaek sánk nae rape?” ");
INSERT INTO yuj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Am éréképá yárak i konámp arop fárákap Jisasént yakápi napao, Jisasén sérrá, “Amo nɨnɨk nap te, yino má arop fárákapan bainat fek faoporrá épér mwanámp nie?” ");
INSERT INTO yuj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Takria maok, arop ankárankamp am ou mekampao bainat ér-sámprá pris taokeyak konámp aropamp tére konámp aropan karámp-sɨrrampweria yae-párák mwaekamp woupwi kor mwar aop-sɨnánko pɨká párákap. ");
INSERT INTO yuj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aenánko, Jisaso nkea sérrá, “Amo nopok i konap nɨnɨk te ankár pwarae!” Aeria maok, Jisaso warko am aropamp woupwi kor sámprá kɨrɨmpá pwar nánko, warko wae kwapwe kare yak. ");
INSERT INTO yuj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aenánko, Jisaso pris tokwae fákáre ntia lotu nap tokwae taokeyakáp konap soldia fákáre ntia Juda fi taokeyakáp konap arop fárákap man sámp mwaria korop nap táman sérrá, “Yumo bainatráp yaopwae tia yorowarinámp aropan sámp mwaria korop konap niamp korop rape? ");
INSERT INTO yuj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kápae kare kumur ono yumont lotu nap tokwae mek yak namp fek te, yumo onan sámp moiapono. Aeno oukoumwan mámá ke fek yiráp kerao korop námpon. Oukoumwan mámá fae tákáre ke fek kɨrɨkɨpamp kárákárerao kwe-pwar námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aerá séri pwaránko, Jisasén wae sámpea tukup. Man warámp-santukupea pris taokeyak konámp aropamp nap mek napo, Pita te am fárákapamp wakmwaek kwarok-te kwarok-te akwapea panek tae morok yak. ");
INSERT INTO yuj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Arop ankwap fárákapao pris taokeyak konámp aropamp nap yaknámp yár mek yaomwi yankia pwatea am fek tankáp napo, Pita akwapea méntér yaomwi fek tank. ");
INSERT INTO yuj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aenánko, pris taokeyak konámp aropamp tére konámp yupu Pitan énounkoupia am arop fárákapan sérrá, “Mámá aropao kor Jisasént yak námpono.” ");
INSERT INTO yuj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aeránko maok, nopok Pita sérrá, “Mono! Ono am arop te mér mo nampono.” ");
INSERT INTO yuj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aeritea tank tae morok nánko maok, tá warko arop ankwap ankárankampao man nkea sérrá, “Amo kuri amo maomp firáp arop támaono.” Aerámpan maok, Pita nopok sérrá, “Ono maomp firáp arop te mono.” ");
INSERT INTO yuj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tá wakmwaek ankárankamp ke akwap tenánko, arop ankwap am tankápnap arop fárákapan tékén sérrá, “Kare karono. Mámá aropao kor méntér yak námpon. Mao te Galili mekamp aropono.” ");
INSERT INTO yuj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aeránko maok, Pita nopok man sérrá, “Ono amo sénap kar am te mér mo nampon.” Aeránko maok, am ke fek táman kakaruk fárámp. ");
INSERT INTO yuj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Aenánko maok, Jisaso kotrá yak námp feknámp mankrá sámp-arákarrá Pitan tokoreyak nánko, Pita warko wokwaek Jisas sérimp kar am nɨnɨk. Wokwaek mao sérrá, ‘Mámá kumuruk oukoumwan kakaruk fárámp mo nánko, amo yinɨnk por sérrá, “Ono Jisas te mér mo nampono”rá sénanap’ rimp kar warko nɨnɨk. ");
INSERT INTO yuj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aeria mao yár ménki porok oukur akwapea yár younkwek yakrá yonkwae touwe tokwaeria éma wae. ");
INSERT INTO yuj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aenko maok, Jisasén sámpá tukupap, soldia fákáre man wouroump séria man yae fek fukiapon. ");
INSERT INTO yuj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Am fárákap te Jisasomp yimetápok waempyam woukoupea pwarará, porokwaprá man arakrá turunk, “Amoku méria profet kar fek sérae: Amwan te wa porokwapán?” ");
INSERT INTO yuj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ankár takrá tukuprá kápae kare ankwap wouroump kar sérariapon. ");
INSERT INTO yuj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tá warko wakmwaek yámar aok nánko, Juda fi taokeyakáp konap arop ntia pris tokwae fákáre ntia lo yénkrá farákáp konap arop fákáre koupoukour napo, arop ankwap fárákapao Jisasén warámpea am Kaunsil fákáreaonapok tukup napon. Aenapo maok, am Kaunsil fákáre Jisasén turunkrá, ");
INSERT INTO yuj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Amo yinan sérae: Amo te Krais ni mo nie?” Aerapo maok, nopok Jisaso am fárákapan sérrá, “Ono yumwan sénanko te, yumo mér mo mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tá ono yumwan ankwap kar turunk nanko te, yumo onomp kar pwarokwaprá sér mono. ");
INSERT INTO yuj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Táte oukoumwania nánkárap wakmwaek Aropamp Táráp Kárákáre Tokwaeráp Kwaromp yae-párák mwaek tank naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aeránko maok, am fárákap ponankor Jisasén sérrá, “Ae te tak napara, amoku támao amo Kwaromp Táráp nie?” Tá nopok mao am fárákapan sérrá, “Yumoku támao takrá sénapon.” ");
INSERT INTO yuj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aeránko maok, am fárákapao sérrá, “Nomo apaerá ankwapamp kar wa mwaria yépék mwanámpanáp? Waeman námokuráp táp meknámp mámá kar sénánko, nomo wa námpono.” ");
INSERT INTO yuj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aeria maok, ponankor ferámprá Pailatonámpok Jisas warámpá tukup. ");
INSERT INTO yuj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Warámpá tukupea man kotria sérrá, “Yino nke nánko, mámá arop te Juda fi yino i konámp nɨnɨk sámpá yampourou námpono. Tá mao sérrá, ‘Ono támao ono Krais, ono Kingono’rá sér i konámpono. Tá yino Sisarén takis sánk mwarianánko te, mao taokor konámpono.” ");
INSERT INTO yuj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aerapo maok, Pailato Jisasén turunkrá, “Amo te Juda fákáreramp king nie?” Aeránko, mao nopok Pailatomp kar pwarokwaprá sérrá, “Amoku támao amo takrá sér rape.” ");
INSERT INTO yuj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aeránko maok, Pailato pris tokwae ntia koumteouráp aropan sérrá, “Ono te mámá aropan am fek kot mwanap ankank te nke mo nampono.” ");
INSERT INTO yuj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aeránko, tá nopok am fárákapao kar kárákáre fek sérrá, “Mao mámá Judia apár mekmwaekamp arop fárákapan kar yénkrá farákáp nánko, arop ponankor Gavmanomp kar ták-sɨr mwanap nɨnɨk yak námpono. Mao am tak námp te apár Galili meknámpia koropea mapek námpon.” ");
INSERT INTO yuj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailato am kar wawia am fárákapan turunkrá, “Mámá arop te Galili mekamp nie?” ");
INSERT INTO yuj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aeránko maok, sérrá, ‘Jisas te Heroto poukwapnámp apár mekampono’rá sérapo maok, Pailato Jisasén Herotonámpok sámp-kérép. Am ke fek te Heroto kor Jerusalem mek yak. ");
INSERT INTO yuj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aenánko maok, Heroto Jisasén nkea mao warákár tokwae. Wae manmékɨr Jisas térenámp kar wawia mao man nkeaka, Kwaromp kárákáre yénkép nánko, man nke nae karrá yakámpon. ");
INSERT INTO yuj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aeria maok, Heroto man kápae kare ankank turunkupánko maok, Jisas te nopok maomp kar ankwap pwarokwaprá sér mo. ");
INSERT INTO yuj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pris tokwae fákáre ntia lo mérnap tisa fákáre koropea wonae fik yakáprá Jisasén tékén sérarrá, kotiapono. ");
INSERT INTO yuj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tá Herot ntia maomp soldia fákáre, mao te kingonorá Jisasén wouroumprá amomoránkiapono. Aea maok, Heroto séránko kingo yirɨmp konámp niamp waempyam kwapwe kare sámpea maomp pourouk yirɨmpea Pailatonámpok arákarrá sámp-kérépapono. ");
INSERT INTO yuj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Wokwaek te Herot ntia Pailat te nonopok yoporipao maok, oukoumwan am ke fek te nonopok nouroup nepono. ");
INSERT INTO yuj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tá Pailato warko pris tokwae fákáre ntia Kaunsil fákáre, tá arop ponankor wumwi nánko, koropeaka koupoukour. ");
INSERT INTO yuj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Aenapo, mao am fárákapan sérrá, “Yumo ononampok mámá arop warámpá koropea sérrá, ‘Mao aropamp nɨnɨk sámpá yampourou námp’rá sénapan maok, yumoku kareao wa nap fek turunki nampono. Yumo wawenk: Ono mámá aropan am fek kotnap ankank te nke mo kar nampon. ");
INSERT INTO yuj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroto kor nke moria warko nomonámpok arákarrá sámp-kérép námpon. Nomo mámá aropan sumpwi pap mwanámp fi te yak mo kare námpono. ");
INSERT INTO yuj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Aenámpara, ono soldia fákáreran sénanko, ain tákáre tokoropramp paok fek táraporea sámp-kérépanápono.” ");
INSERT INTO yuj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Juda fi te arak i konapono: Kápae kare por mao lotu i konap Pasova Yae korop námp fek te Pailato fákapá yaknámp arop aokorop-pwarará, amwar sámp-kérép nánko, akwap konámpono.) ");
INSERT INTO yuj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Táte koumteouráp arop fárákap ponankor tékén sérrá, “Am arop te sumpwi papria, Barabasén yinonámpok sámp-kérépae.” ");
INSERT INTO yuj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Am Barabas te taun mek Gavmanén yorowaria arop ankwapan sámp-wouroumpeanánko, am fek man sámpea fákapá pap napon.) ");
INSERT INTO yuj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Warko Pailato ‘Jisasén aokorop-pwarará sámp-kérép nae’rá sénánko maok, ");
INSERT INTO yuj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","tá am fárákap tékén wumwi kar fek sérrá, “Yaopwae porokopramp fek pukupenke! Yaopwae porokopramp fek pukupenke!” ");
INSERT INTO yuj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Táte warko Pailato am fárákapan yinɨnkan sérrá, “Am te apae riteanono? Am arop te apae ankanki námpono? Ono te mao am fek fwap sumpwi naenámp ankank te kánanke nke mo nampono. Aenampara, ono sénanko, ain tákáre tokoropramp paok fek fukia sámp-kérépanápono.” ");
INSERT INTO yuj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aenánko maok, am fárákapao ‘Jisasén yaopwae porokopramp fek pukupenk’ ria tékén wumwi kar fek séra waeria, Pailatomp kar te ankár apárok sámp-anámp. ");
INSERT INTO yuj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aenapantá maok, Pailato wampweria am fárákapao sénapaokria ‘Takenk’rá sérimpono. ");
INSERT INTO yuj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Koumteouráp arop fárákap am fákapá yaknámp arop, warko warámp mwarria wumwi nap te Pailato am Gavmanén yorowaria arop ankwap porokwapea sumpwi papámpan man sámp-kérép. Táte am koumteouráp arop fárákapamp karwaokria Jisasén soldia fákáreramp yaek sánkámpono. ");
INSERT INTO yuj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aenko, am Rom mekamp soldia fákáre wae Pailatomp nap pwarará Jisasén warámpá tukup. Takria mwaeaok nke napo, arop Sairini mekamp Saimon Jerusalem mek akwap naeria korop. Aenánko, man sámpea fákeyakáprá sérrá, ‘Jisasén am fek pukup mwanap yaopwae mao námoku samp námp mámá amo man yaewourrá sampae’ ria fopwaok. Aenapo, mao am yaopwae kakapea Jisasén éntér papea akwap. ");
INSERT INTO yuj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tak napo, kápae kare koumteouráp arop maomp wakmwaek tukup napo, koumteou ankwap fárákap Jisasén yonkwae touwea waeria éménkrá tukup. ");
INSERT INTO yuj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Aenapo maok, Jisaso sámp-arákarrá am koumteouran sérrá, “Jerusalem mekamp koumteou, yumo te onantá éménki kwapono. Yumokuráp pourou ntia yiráp tárápuantá éménk kipo. ");
INSERT INTO yuj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Am te apae riteanápe, nánkár wakmwaek ankwap ke fek kápae kwatae korop naenámpono. Am ke fek koumteou mapo yakáp nap, tá táráp samp monap, tá táráp mom wurump monap, am fárákap fwap warákár mwanapon. ");
INSERT INTO yuj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Am ke fek táman touwe tokwae kwatae kare korop nánko, koupour sumpwi mwarria am arop fárákapao péri wi tokwaeran sérrá, ‘Yumo yinan oupouroupá yakápenke!’ Tá faonkwe kánanke-tárápan sérrá, ‘Yumo koropea yinan nánánkárenke!’ ");
INSERT INTO yuj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Oukoumwan yao yiki yak námp niamp yae-párák kare aropan touwe kwatae sánk napanánko te, nánkár wakmwaek am fárákap támao yao yákáre niamp arop kwataerara, touwe kwatae tokwae yármare kar sámp mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Táte arop anánkaopwe kwatae nɨnɨk nepo, am yaworan kor Jisasént yaopwae porokopramp fek pukupia sumpwi pap mwaria éréképá tukup. ");
INSERT INTO yuj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wae tukupea apár faonkwe ‘Arop Me Kor Yaknámp Apár’rá séri konap fek tukupea, Jisasén yaopwae porokopramp fek paprá nil pukupá pwar. Aeria, tá am kwatae nɨnɨkinep arop yaworan kor takia Jisasomp wonae fik ankwapan yae-párák mwaek, ankwapan yae-mánkwan mwaekia pukupá pwar. ");
INSERT INTO yuj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tak napo maok, Jisaso náráp naropwarén sérrá, “Ayao! Amo am fárákapamp kwatae nɨnɨk tirá épérampo. Mao am taknap kwatae nɨnɨk te mér moria napono.” Táte soldia fákáre Jisaso yirɨmp konámp waempyam ankank ti mwaria satu pilaiapono. ");
INSERT INTO yuj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aenapo, koumteouráp arop am fek yakáprá tokoreyakáp napo, Kaunsil fákáre Jisasén wouroumprá sérrá, “Mao te arop ankwap fárákapan yaewour i konámpono. Táte kare, Kraisao námp kwamp te, fwap mao námoku támao yaewourano.” ");
INSERT INTO yuj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldia fákárerao kor man wouroump kar séria top i konámp wain ént táp mek sánk mwaria, wonae fik korop. ");
INSERT INTO yuj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tá am fárákapao sérrá, “Táte kare amo Juda fákáreamp Kingao nap kwamp te, fwapono, amoku waráp pourou yaewourae.” ");
INSERT INTO yuj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Táte Jisas me kor páte yaknámp yarápae fek yaopwae kárakére fek kumwiria sérrá, “Mámá te Juda firamp Kingono.” ");
INSERT INTO yuj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Táte am kwatae nɨnɨkinep arop yawor pukup tenap ankwap ankárankao Jisasén wouroumprá sérrá, “Amo te Krais nie? Amo takanánko te, amoku kare yaewourria, yinan mént yaewourae.” ");
INSERT INTO yuj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Aeránko maok, táte ankwapao am kar wawia am aropan yoporrá sérrá, “Nomo touwe tokwae mao sámpnámp niamp take pourouráp sámp nempan maok, am te nomo kwatae nɨnɨki nemp fek sámp nempono. Aeno mámá arop te kwatae nɨnɨk moi námpan, kwaporok touwe kwatae sánk napono. Amo te man wouroumpria te, Kwarén apáp mák napono?” ");
INSERT INTO yuj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Takria maok, mao Jisasén sérrá, “Jisas e, amo nánkár wakmwaek King yakria, waráp firáp arop taokeyaknap ke fek onan kor nɨnɨkampo.” ");
INSERT INTO yuj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aeránko maok, Jisaso man sérrá, “Ono amwan kare kar sénampono: Amo te waeman oukoumwan táman onont kwapwe kare némp yámar mek yak nanapono.” ");
INSERT INTO yuj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Oukoumwan yámar kuk nánko, yámar néntéképria kɨrɨkɨp tokwaerao apár oupouroupea yakrá akwapea kumur mek yámar yinɨnk ke fek. ");
INSERT INTO yuj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Aenánko, lotu nap tokwae mek Aokore Yiki Kwapwe Kare ménki fek nánkáráp tenapo yak konámp waempyam tokwae am te kuk paerákarea anánk mwaek peari yak. ");
INSERT INTO yuj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aenánko, Jisaso tékén Kwarén sérrá, “Ayao, amo onomp waemp taokeyakaeria waráp yaek sánk rae.” Aerá séria maok, mao wae sumpwi. ");
INSERT INTO yuj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aenánko maok, soldia fákáreramp kepten am táman nkea Kwaromp e narek sampokrá sérrá, “Kare karono! Mámá arop máte yae-párák kare aropono!” ");
INSERT INTO yuj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Táte kápae kare koumteouráp arop koropea tokoreyakáp napo, am ankank korop nánko nkea, apae mao yae-párák kare arop sumpwi papeanoria námokuráp éntér kor fek yae porokwapea nɨnɨk tokwaerá náráp nap mekmwaek turukump. ");
INSERT INTO yuj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tá Jisasomp nouroup ankwap fárákap ntia koumteou ankwap fárákap apár Galili meknámp fárámpea Jisasomp wakmwaek koropap, mao kor panek tae morok yakáprá, am kápae kare ankank Jisas sumpwi námp fek koropánk námp am nke napono. ");
INSERT INTO yuj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Juda apár mekamp taun Arimatea mekamp arop, maomp e te Josep, mao te kwapwe kare yae-párák kareria, Kwaro náráp firáp éréképea taokeyak naenámp ke korop naenámpria yépékrá yak konámpon. Mao te Kaunsil fákáre mekamp Kaunsil ankwapao maok, manénkɨr Jisasén farop mwaria Kaunsil kar sérarap fek te, mao am arop fárákapamp nɨnɨk napént takenkrá nɨnɨk moimpon. ");
INSERT INTO yuj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Am arop te Pailatonámpok akwapea, man ‘Jisasomp yákáre sámp nae’ ria sénánko Pailato ‘Takae’rá sér. ");
INSERT INTO yuj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aenánko maok, mao Jisasomp yákáre yaopwae porokopramp fekamp worokwapá sékia waempyam wupwi fek woukoupea sakwapea arop pap mwanámpria péri kor me wourékam wokwaek yoroia pwatariap mek am mek pap. ");
INSERT INTO yuj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Am yae Fraide te Sabat yae fekamp ankank nánap i konap yae nánko, am Sabat ke wae wonae fik korop námpono. ");
INSERT INTO yuj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Am apár Galili meknámp fárámpea Jisasént koropnap koumteou, mao kor Josepomp wakmwaek tukupea am péri kor me nkeria, mao Jisasomp yákáre mokopia papán nke mwaria tukupapono. ");
INSERT INTO yuj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nkea pwarará, wae námokuráp nap mek arária tukupea, Jisasomp yákáre forokwap mwanámpria nánákáre kwapwe konámp marasinráp, wel nánapia papá pwarará, loao sénámpnámp taknámp, Sabat yae fek anepériapono. ");
INSERT INTO yuj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande fek koumounek kar am koumteou nánákáre i konámp wel ankank nánapi pátariap am tia péri kor me mek tukup. ");
INSERT INTO yuj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tukupea nke napo maok, péri worare tokwae arárákarrá koropea me fek nánkáráp tariap te am fek yak mono. ");
INSERT INTO yuj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Aenánko, am koumteou te me mek yinkea nke napo maok, Jisas Tokwae Karamp yákáre te am mek tank mo. ");
INSERT INTO yuj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aenánko, am koumteou, máte mokopia Jisasomp yákáre tank mo námponoria nɨnɨk tokwae. Takria nke napo maok, arop anánkaopwe Jisasén papap fek wonae fik fokopeyak nepo, maomp pouroukamp waempyam te wae tákapa wae. ");
INSERT INTO yuj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aenánko, am koumteou te apáp tɨrɨnkia me kor woukourrá apárok tokoreyakáp. Aenapo maok, am ensel yaworao am fárákapan sérrá, “Yumo apaeritea sumpwi pátenap meknámp fárámpea yiki yaknámp aropan oupourounk rape? Mao te mamek tank mono. Wae fárámp teane! ");
INSERT INTO yuj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yumo ankár wokwaek Galili mek yakámp fek yumwan sérimp kar táman warko nɨnɨk kipo. ");
INSERT INTO yuj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mao yumwan arakrá sérimpon: ‘Arop fárákapao Aropamp Tárápan kwatae nɨnɨkráp aropamp yaek sánkea napo, man yaopwae porokopramp fek pukupia sumpwi pap napo, apár me mek yinɨnki yakeaka, warko fárámp naenámp’rá séri námpono.” ");
INSERT INTO yuj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aerá sénepo maok, tá am koumteou fárákap wae Jisaso wokwaek sérimp kar am nɨnɨkria, ");
INSERT INTO yuj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","wae am péri kor me pwarará arári tukupea Jisaso éréképea yárak i konámp mom-sámpramp arop fárákap ntia arop ankwap fárákapan am kápae kare ankank nke nap táman farákáprá sériapono. ");
INSERT INTO yuj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Am koumteou fárákap te Makdala mekamp Maria, tá Joana, tá Jemsomp éntupwar Maria mao yakáp napo, tá koumteou ankwap fárákapao kor méntér yakápria aposel fákáreran am kar farákápapono. ");
INSERT INTO yuj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aeapan maok, am aposel fákáreramp nɨnɨk te, am koumteou te náráp yi fek nke mono, kwaporok amorikamp karan sénapan mpweria am fárákapamp kar wawia karenoria nɨnɨk moiapono. ");
INSERT INTO yuj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aenapo, Pita fárámprá fárakop akwapea péri kor me mek woukoupeyakrá nke nánko, Jisasén woukoupá papap waempyam mwar tank nánko nkea pwarará, warko námokuráp nap mek arákarrá akwapria, am te mokopi námponorá nɨnɨk tokwaerá akwap. ");
INSERT INTO yuj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Am makár táman Jisaso éréképá yárak i konámp ou mekamp arop anánkaopwe némp kánanke Emeus mek akwap neria akwap. Jerusalem pwarará Emeus mek tukup konap te 11 kilomitanono. ");
INSERT INTO yuj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Am arop yawor akwaprá námoku támao am Jerusalem mek koropnámp ankank táman sérarrá, ");
INSERT INTO yuj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","námoku támao turunkrá akwap nepo maok, Jisas námoku kareao am arop yaworan kɨkɨpia énénki tapokwapea tukup. ");
INSERT INTO yuj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Aenapo maok, am arop yawor te Jisasén te nke nepao maok, man wuri nke mono. ");
INSERT INTO yuj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aenepo maok, Jisaso am arop yaworan turunkrá, “Yumo te apae karan sérarrá akwap repe?” Aerá sénánko, am arop yawor te fokopeyakrá yonkwae touweria maok, ");
INSERT INTO yuj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kliopas maomp kar pwarokwaprá sérrá, “Kápae kare némpouk mwaekamp arop oukoumwan Jerusalem mek yakápria am ankank ponankor mérapono. Ae te amo ankárankampao am ke fek Jerusalem mek koropnámp ankank mér mori kwapono?” ");
INSERT INTO yuj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aerá séránko maok, Jisas am arop yaworan turunkrá, “Am te apae ankankono?” Aenánko nopok am arop yaworao man sérrá, “Mámá Nasaret mekamp Jisaséninap ankank mátane. Mao te profetao, Kwaro nke námp fek, tá arop fárákapao nke nap fek tére kárákáreria, kar kárákáre farákáp konámpono. ");
INSERT INTO yuj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nomp pris tokwae fákáre ntia Juda taokeyakáp konap arop fákárerao Gavmanomp yaek pap napo, Gavmano ‘Man yaopwae porokopramp fek pukupenk’rá sénapo, taki napono. ");
INSERT INTO yuj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aenapan maok, wokwaek te yino arakrá méri námpono: Am arop te Israel firan warko yamokwap naeria námpon. Tá ankwap kar te ará: Am ankank koropnámp yae te wae yinɨnk yae akwap tenámpono. ");
INSERT INTO yuj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Oukoumwan yinomp ou mekamp koumteou yinan korokopá pap napono. Am te ará: Mao koumounek kar tukupea péri kor me mek nke napo, ");
INSERT INTO yuj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jisasomp yákáre tank mo nánko, arári koropea sérrá, ‘Yino ensel nke nánko, mao sérrá, “Jisas yiki yak námpono.” ’ ");
INSERT INTO yuj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aenapo, arop ankwap fárákap yino ou mekamp tukupea péri kor me mek nke napo, am koumteou séri nap ankár take pourouráp nke napono. Aenapan maok, mao karean te nke moi napono.” ");
INSERT INTO yuj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Táte Jisas am arop yaworan sérrá, “Yiráp nɨnɨk te épérépria profet fákáreramp kar koupour kar mér mo nepono. ");
INSERT INTO yuj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Am te arakrá sériapono: ‘Krais te ankár manénkɨr touwe sámpea, wakmwaek pokea Kwarént wae tokwae kwapwe fek tank naenámp’ riapon.” ");
INSERT INTO yuj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aerá séria maok, Moseso kumwinámp kar feknámpia akwapea, profet fákárerao kumwiap kar am arop yaworao wanep fek farákápria maok, Kwaromp Buk fek Jisas námoku karean sénámp kar fi am ponankor farákápámpono. ");
INSERT INTO yuj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Takrá tukupea, am arop yaworao akwap nerianep némp wonae fikria, Jisas te wae némp kámá-pwarará kánámpár akwap naeria námp niamp. ");
INSERT INTO yuj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aenámpantá maok, am arop yaworao Jisasén sérrá, “Wae yámar porokor nánko, kɨrɨkɨp naereane! Amo yinont mapek yakae.” Aerepo maok, Jisaso wae am arop yaworént nap mek akwap. ");
INSERT INTO yuj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tá wakmwaek tankáprá fáneria nepo, Jisas méntér tankria pan sámpea Kwarén ‘Aesio’rá séria pwarará, fékéria arop yaworan nénk. ");
INSERT INTO yuj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aenánko am arop yawor wae Jisasén wuri nkeria, mér nepo, Jisas kwaporok am fek moyak nánko, am arop yawor te warko man nke mo. ");
INSERT INTO yuj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aeria maok, námoku támao sérrá, “Wɨ! Nomo mwaeaok korop námp fek nomwan kar farákápria, Kwaromp Buk fek yaknámp nɨnɨk fi kor farákáprá sénánko, am ke fek táman nomp nɨnɨk mek párákap nánko, nomo korokopria nomp nɨnɨk érik farákára námpono.” ");
INSERT INTO yuj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Am arop yawor takrá séri pwarará, am kumur mek táman fárámprá Jerusalem mek arákarrá akwapea Jisas éréképea yárak i konámp mom-sámpramp arop ntia maomp nouroup ankwap fárákap koupoukour tankáp napo, am mek akwap. ");
INSERT INTO yuj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aenepo maok, am fárákapao sérrá, “Wae kare kar Jisas Tokwae Kar te warko fárámpeanánko, Saimono man wae nke námpono!” ");
INSERT INTO yuj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aerapo maok, tá am arop yaworao kar mao mwaeaok nkenep kar am farákáp. Aeria maok, am arop yaworao sérrá, “Mao te pan fékéria yinan ti-sáp nánko, yino wae wuri nke nempon.” ");
INSERT INTO yuj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Oukoumwan táman am kar sérarrá tankáp napo, Jisas námoku kwaporok kuk fokopeyak. ");
INSERT INTO yuj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aenánko maok, am arop fárákap nkerá paokoprá, waemp ritea kokorokoria apáp tɨrɨnk. ");
INSERT INTO yuj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aenapo maok, Jisaso am fárákapan yoporrá, “Yumo apaeritea kokorokoria nɨnɨk tokwae rape? ");
INSERT INTO yuj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yumo onomp pu yae má nkenke. Ono kare támao nampono. Yumo onomp pourouk sámpá nkenke. Waemp te ononampnámp maknámp émiráp kour yak mono.” ");
INSERT INTO yuj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aerá séri pwarará, am fárákapan náráp pu kor yae kor yénkánko, ");
INSERT INTO yuj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","am fárákap nkea warákáránk napao maok, oukoumwan fwapia mér moria nɨnɨk tokwae. Aenapo, Jisaso am fárákapan sérrá, “Ae te fɨr tank mákáne?” ");
INSERT INTO yuj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aeránko éntékam tákáre yankapramp sánk napo, ");
INSERT INTO yuj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","mao sámpea am fárákapao nke nap fek fár. ");
INSERT INTO yuj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aeria am fárákapan sérrá, “Ono wokwaek oukoumwan yumont yakamp fek ono yumwan wae sériamp támaono: ‘Kápae kare ankank wokwaek onan korop naenámpan Moseso kumwimp lo, tá profet fákárerao kumwiap kar, tá Buk Song fek kumwiap kar am te waeman ankár take pourouráp korop naenámp’rá sériampon.” ");
INSERT INTO yuj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aerá sériaka, am fárákapao Kwaromp Buk fek yaknámp kar nɨnɨk sámpanáponoria ");
INSERT INTO yuj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","arakrá sér, “Kwaromp Buk fek arakrá sénámpon: ‘Krais te ankár touwe sámpea yinɨnk kumur fek warko ankár apár me meknámp fárámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","48","Aeanánko, maomp e fek arop fárákapao kápae kare arop firan kar farákáp napo, arop fárákap kwatae nɨnɨk pwarará, Kwaronámpok korop napo, mao am fárákapamp kwatae nɨnɨk tirá épér naenámpon. Onomp tére, onomp yárak ponankor yumo yumokuráp yi fek nkea, yumokuráp woupwi fek wawi napara, yumo ankár Jerusalem meknámpia, ankwap némpouk mwaek am kar ponankor farákáprá paokop kipo. ");
INSERT INTO yuj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yumo wawenke: Yumwan onomp Naropwaro ‘Yiki Kor Spirit sámp-kérép nanamp’rá sérimp te, ono wae oukoumwan yumonapok sámp-kérép nanampono. Aeno yumo ankár Jerusalem mek yakáprá yépék napo, am yámar mekamp kárákáre yiráp pourouk ékia woukoup naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisaso am fárákapan takrá séri pwarará, éréképá akwapea, némp kánanke Betani mekria maok, am fárákapao yakápnap mwaek yae nareki fákeyakrá am fárákapan ourour nénk. ");
INSERT INTO yuj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Am ourour nénkrá yak nánko, Kwaro Jisasén wae warámpea yámar mek pok nánko, Jisas wae am fárákapan pwar. ");
INSERT INTO yuj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aenánko, am fárákap kwaráp torokomprá man lotu. Takia pwarará, wae warákáránkia Jerusalem mek arári tukupapono. ");
INSERT INTO yuj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tá kápae kare por lotu nap tokwae mek yakáprá, Kwaromp e sakapiapono. ");
INSERT INTO yuj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Me koum sik kar, Kwaro ponankor ankank oukoumwan yoro momp fek, Kar yakámpono. Karao Kwarént yak, tá Kar námoku kare támao Kwarono. ");
INSERT INTO yuj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Me koum sik Kar te Kwarént yakámpono. ");
INSERT INTO yuj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Am Kar fek táman ankank ponankor forokorimpon. Ankank ankwap ankwap mwae kup fek forokor mono. Ponankor ankank te am Kar támao nánko forokorimpon. ");
INSERT INTO yuj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yiki yak am Kar mek yak námpon. Am yiki yak te koumteouráp aropamp nɨnɨk mek wae sankoropnámp yiki yakono. ");
INSERT INTO yuj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Am wae te kɨrɨkɨp mek wae puri akwap konámpara, kɨrɨkɨp te am waeran oupouroupea torokwari pap mono. ");
INSERT INTO yuj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kwaro arop ankárank sámp-kérépámp, am aropamp e te Jon. Mao te karan farákáprá koropámpon. ");
INSERT INTO yuj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mao te am waeramp kar táman farákáp nánko, koumteouráp arop ponankor maomp kar wawia méranáponoria farákápámpon. ");
INSERT INTO yuj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon námoku te am wae támao mono. Mao te párák am waeramp karan farákáprá koropámpon. ");
INSERT INTO yuj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Am wae te wae karerao maok, arop ponankoran wae sánk naeria oukoumwan te apárok ék námpon. ");
INSERT INTO yuj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Oukoumwan te am Kar apárok yak námpon. Kwaro am fek apár yoroimpan maok, apárokamp koumteouráp arop fárákap te man mér mo napon. ");
INSERT INTO yuj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Námokuráp apár fi mek ék námpan maok, mao námokuráp arop fi te man wuri nke mo napon. ");
INSERT INTO yuj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aeno ankwap koumteouráp arop fárákap man warámp nap te, am fárákap man wae méria napon. Am taknap fákáreran te Kwaro kárákáre nénk nánko, am fárákap te fwap Kwaromp tárápu yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Am arop Kwaromp tárápu yakáp nap te, naropwar ntia éntupwaromp yɨri fekamp mo, tá aropamp pourou fek mwaekamp mo, tá aropamp nɨnɨk fekamp mono. Kwaro námoku yoroianánko, maomp tárápu yakáp napon. ");
INSERT INTO yuj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Aeria maok, Karao arop arákarea maok, yino ou mek yak námpon. Aenánko, yino maomp wae ntia kárákáre tokwae te wae nke námpon. Am wae tokwae am Táráp ankárankampamp Kwaro sámp-kérép nánko ék námp, maompono. Aeria maok, aropomp ntia kare kar nɨnɨk te maomp nɨnɨk mek saráp top-pwarámpeyak námpon. ");
INSERT INTO yuj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jono koumteouráp aropan wumwiria arakrá sér, “Mámá arop te ono yumwan wokwaek sériamp arop támaono. Ono yumwan sérrá: Arop onomp wakmwaek korop námp te, onomp Tokwae Karono. Am te apae riteanápe, ono oukoumwan korop mo nanko, mao te wokwaek kar yakámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Aropomp te am aropan top-pwarámpeyak nánko, am aropomp fek tapek nomwan ponankor kwapwe karerá kák konámpono. ");
INSERT INTO yuj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tá kare, Kwaro nompor lo Mosesomp yaek sánkámpon. Aeno Jisas Kraisomp yaekamp te nomo aropomp ntia kare kar nɨnɨkan sámp námpon. ");
INSERT INTO yuj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Arop ankwap Kwarén te nke mo kareno. Am Kwaromp Táráp ankárank mao námoku saráp Naropwaromp wonae fik kar yakeakámpao am ankárank támao nomwan Kwar yénkép námpon. ");
INSERT INTO yuj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda poukeyak konap fákárerao pris fákáre ntiaka Livai fákáre Jerusalem meknámp tirá kérép napo, koropea Jonén turunk, “Amo kare te wa nape?” ");
INSERT INTO yuj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aerapo maok, Jon te mek wouroump mono, érik arakrá sér, “Ono te Krais támao mono.” ");
INSERT INTO yuj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aeránko maok man turunkrá, “Ae te amo Elaija nie?” Tá mao sérrá, “Mono.” “Ae te amo yino yépékrá yakápnámp profet nie?” Tá nopok mao sérrá, “Mono.” ");
INSERT INTO yuj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aeránko maok, am fárákapao man warko turunkrá, “Amo te wa kareao nape? Yino te yinan sámp-kérépnap arop fárákapan amo nopok sénap kar tukupea sér mwanámpono. Amoku kare te apaerá sér rape?” ");
INSERT INTO yuj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Aerapo maok, Jono sérrá, “Ono te am arop profet Aisaia sérrá, ‘Arop kar ankárankamp arop yak mo apár meknámp wumwiria sérrá, “Tokwae Karao korop naenámp mwae kup fwapokwapenk”rá sénaenámp’ rimp arop támaono.” ");
INSERT INTO yuj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Am arop fárákap Farisi fákáreao tirá kérépapo koropap támao Jonén warko turunkrá, ");
INSERT INTO yuj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Amo te Krais mo, amo te Ilaija mo, amo te am profet mo nap kwamp te, apaerá mámá koumteouráp aropan ént mek nérrá kák napon?” ");
INSERT INTO yuj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Jono nopok am fárákapamp kar pwarokwaprá arakrá sér, “Ono te arop fárákapan ént fek nérrá kák konampon. Aeno yumo ou mek yaknámp arop ankwap ankárank yumo te man mér mo napon. Am arop te onomp wakmwaek korop námpon. Ono te apárok kánanke kare nampara, maomp pukamp su fekamp paok aokorop nanamp pwi mo nampono.” ");
INSERT INTO yuj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jono am kar sérimp te, ént Jordan mek nkwamwaek fimwaekamp némp Betani mek yakrá am kar sérria koumteouráp aropan ént mek nérrá kákámpono. ");
INSERT INTO yuj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ankwap kumuruk, Jono nke nánko, Jisas maonámpok koropánko maok, “Nkenke! Nkote Kwaromp Sipsip Morokono. Mao te apárokamp koumteouráp arop ponankoramp kwatae nɨnɨk tirá épér naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Am arop te ono wokwaek sérrá, ‘Arop onomp wakmwaek korop námp te, onomp Tokwae Karono’rá sériamp támaono. Am te apae riteanápe, mao te ono oukoumwan korop mo nanko, mao te manénkɨr me koum sik yakámpon. ");
INSERT INTO yuj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Onoku karerao kor, mao te wanonorá mér moiampan maok, párák koropea Israel fi mekamp koumteouráp aropan am arop mér mwanapria ént mek nérrá kák nampon.” ");
INSERT INTO yuj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Aeritea maok, Jon Jisasén nke námpan sérrá, “Ono wae Yiki Kor Spiritao yámar meknámp ant yuri niampao ékiaka maomp pourouk narek tank nánko nke nampon. ");
INSERT INTO yuj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ono kareao kor manénkɨr te man mér moi nampan maok, Kwaro onan manénkɨr sámp-kérép nánko, koropea am koumteouráp aropan ént mek nérrá kák nampono. Wokwaek mao onan arakrá sér, ‘Amo nke napo, Yiki Kor Spirit ékiaka arop ankárankampamp pourouk tank námp te, am arop támao koumteouráp arop fákáreran Yiki Kor Spirit fek nérrá kák naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aenánko onoku wae nke nampan arakrá farákáp nampon: Mao te Kwaromp Tárápono.” ");
INSERT INTO yuj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jono wakmwaek ankwap yae fek am ént mek nér i konap fek mao éréképá yárak i konámp arop anánkaopwerént yak. ");
INSERT INTO yuj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Aeria mao nke nánko maok, Jisaso am fek koropá párákaprá akwap. Aenánko maok, Jono sérrá, “Nkenke! Nkote Kwaromp Sipsip Morokono!” ");
INSERT INTO yuj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aeránko maok, am anánkaopwerao am kar wawia maok, Jisasomp wakmwaek akwapepon. ");
INSERT INTO yuj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas arákarrá nke nánko maok, am arop yawor maomp wakmwaek akwapepo maok, Jisaso am arop yaworan arakrá turunk, “Yumo te apae ankankan oupourounk repe?” Tá am arop yaworao man sérrá, “Rabai, amo mae nap mek yak napono?” (Am ‘Rabai’ e fi te ‘Tis’ nono.) ");
INSERT INTO yuj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jisaso am arop yaworan sérrá, “Yumo koropá nkenke.” Am ke te oukoumwan yiawor ke námpantá nimpon. Aeránko maok, am arop yawor akwapea mao yaknámp nap nkeaka maok, mént yakrá akwapea kumuran. ");
INSERT INTO yuj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Am arop yawor Jonomp kar wawia, Jisasomp wakmwaek akwapep ankwap te Saimon Pitamp nánae Andru. ");
INSERT INTO yuj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mao akwapea náráp naenáp Saimonén oupourounkia sérrá, “Yino te wae Mesaian nke námpono.” (Am ‘Mesaia’rá sénap ankwap e te ‘Krais’ ono.) ");
INSERT INTO yuj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andru man warámpea akwapea Jisasnámpok nánko maok, Jisaso man nkeaka sérrá, “Amo te Saimon, Jonomp tárápono. Nánkár wakmwaek waráp e te ‘Sifas’ ri pap mwanapono.” (Am takrá sénap te Grik kar fek te ‘Pit’ nono. Am ‘Pita’rá sénap fi te ‘Yumwi’rá sénapon.) ");
INSERT INTO yuj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wakmwaek ankwap kumuruk Jisas Galili mek akwap naeriaka Filiponámpok akwapea nkeaka sérrá maok, “Amo onomp wakmwaek koropae!” ");
INSERT INTO yuj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip te Betsaida mekampono. Am taun te Andru ntia Pitamp taun nono. ");
INSERT INTO yuj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo akwapea Natanielén oupourounkia maok, man sérrá, “Am arop te wokwaek kar Moseso kumwimp lo, tá profetao kor am kar man kumwimp te, am arop te yino wae nke námpono. Mao te Josepomp táráp, Nasaret mekamp Jisasono.” Aeránko maok, Natanielo man sérrá, “Ae te kwapwe kare ankank fwap Nasaret meknámp korop námp nie?” ");
INSERT INTO yuj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aeránko maok, Filipo man sérrá, “Amo koropea nkeae.” ");
INSERT INTO yuj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanielo Jisasnámpok korop nánko maok, Jisas man nkeaka arakrá sér, “Yumo nkenke! Mámá arop mámáte Israel mekamp arop karenono. Mao te kwekár kar, tá kwekár nɨnɨk kánanke yak mo kareno.” ");
INSERT INTO yuj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tá Natanielo Jisasén arakrá turunk, “Amo mokopiaka onan mér napon?” Makránko Jisaso maomp kar pwarokwaprá arakrá sér, “Manénkɨr Filip amwan oukoumwan wumwi mo nánko, amo yao fik pékri fek tankapo, ono am ke fek táman amwan nke nampon.” ");
INSERT INTO yuj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aeránko maok, Natanielo maomp kar pwarokwaprá arakrá sér, “Tisa, amo te Kwaromp Táráp, Israelomp Kingono!” ");
INSERT INTO yuj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aeránko Jisaso sérrá, “Ono amwan sénamp te amwan ono yao fik pékri fek nke namp fi kor fek táman amo mér napon? Am te kánankenono. Amo nánkár wakmwaek máman kámákár akwapnámp ankank tokwae nke nanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mak ritea maok, warko man sérrá, “Ono waeman kare kar yumwan sér rae: Nánkár wakmwaek te yumo nke napo, yámar me kɨkɨr akwap nánko maok, Kwaromp ensel fákárerao Arop Tárápamp pourou mwaek éká poká napo, nke mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jisaso Filip ntia Natanielén éréképámp yae anánki yak nánko, arop ankárank distrik Galili mekamp taun Kana mek yupu sámp naerianánko maok, toupour. Tá Jisasomp éntupwar am yupu sámp naerianámp toupour fek am mek yakánko maok, ");
INSERT INTO yuj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","am fárákapao Jisasén kor wumwiria maok, mao éréképá yárak i konámp arop fárákapan kor ‘Koropenk’rá sér. ");
INSERT INTO yuj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Am toupour fek fánap wain ént pwaránko maok, Jisasomp éntupwaro man sérrá, “Mámá arop fárákap te wain ént mo nape.” ");
INSERT INTO yuj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisaso man sérrá, “Ayae, amo apaeritea onan turunk rape? Ono nanamp yae te oukoumwan sɨkono.” ");
INSERT INTO yuj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aeránko maok, éntupwaro tére konap aropan sérrá, “Mao yumwan apae kar sénánko te, yumo ankár mao sénámpaok kipo.” ");
INSERT INTO yuj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Am nap mek te Juda firao námoku i konap nɨnɨkaok yae yárár i konap éntráp kwar fekamp sospen éri tokwae tokwampok tankáp. Am sospen ankákárank mek te 100 lita ént fwap tank naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisaso am tére konap aropan sérrá, “Sospen mek ént kokorarenke.” Aeránko maok, am fárákapao am mek kokorarea top-pwarámprá kák. ");
INSERT INTO yuj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tá mao am fárákapan sérrá, ‘Fɨr poukwapnámp aropaonámpok santukupenk’ránko, santukupap. ");
INSERT INTO yuj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Fɨr poukwapnámp aropao am ént fári nki nánko maok, wae wain kare nánko maok, mao te am maokamp sámp naprá mér mo. (Aeno am térenap aropao saráp ént yɨnkɨp nap te wae mér.) Aeapo maok, táte fɨr poukwapnámp aropao am yupu sámpámp aropan wumwiria maok, ");
INSERT INTO yuj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","man arakrá sér, “Arop ponankor wain kwapwe kareanénkɨr nénk napo, fépéria napo maok, wakmwaek am fárákap kápae kare fépéria pwarnap ke fek maok, táte warko wain kwatae taenámp wakmwaek nénk konapon! Ae konapan maok, amo kwapwe kare wain te pátea oukoumwan táman sankorop napon.” ");
INSERT INTO yuj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Am kárákáre te Jisaso manénkɨr arop fárákapao nke nap fek Kwaromp kárákáre te aránorá yénképnámp ankankono. Am yoroimp te Galili apár mekamp taun Kana mek yoroimpon. Aeria maok, am fek táman mént paokopap arop fákáre man mériapon. ");
INSERT INTO yuj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Takia pwarará maok, Jisaso náráp éntupwar warámp, tá náráp nánaeounáp tárápu érékép, tá náráp éréképea yárak i konámp arop fákáre érékép, makia pɨkia taun Kaperneam mek ankwap yinɨnk yae yakápiap. ");
INSERT INTO yuj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda firamp Pasova yae wae fae nánko maok, Jisaso Jerusalem mek pokea maok, ");
INSERT INTO yuj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lotu nap tokwae yár mek nke nánko maok, arop bulmakau, sipsip, ant, arapek bisnis térerá yakáp. Tá mao nke nánko, arop ankwap fárákap ankwap firamp mani tia lotu nap tokwaeramp mani nonopokrá yakáp. ");
INSERT INTO yuj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jisaso paok sámpea mwepia am fek arop fárákapént maomp sipsip, bulmakau méntér yéréperá kérép nánko, am lotu nap pwarará pɨrɨkɨmprá tukup. Tá arop nonopoknap mani wakárarria kákánar méntér wakár-sɨr. ");
INSERT INTO yuj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aeria maok, arop ant nénk napan kor sérrá, “Yumo yiráp ant tia tukupenke! Yumo te onomp naropwaromp nap te mákiaka stua niamp arákarrá pap nape!” ");
INSERT INTO yuj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mao éréképá yárak i konámp arop fákárerao Jisaso taknámp nkea kar ankwap Buk fek yaknámp am nɨnɨk. Am kar te arakrá sénámpon: “Ono waráp napan warákár tokwae nampara, am nap fwapi yakanoria tére kárákáre nampon.” ");
INSERT INTO yuj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Juda taokeyakáp konap fárákap am Jisasonámp nɨnɨk nkea maok, man arakrá turunk, “Ae te amwan takaeria sánknámp kárákáre yinan yénkép naeria te, apae kárákáre yoro nanapon?” ");
INSERT INTO yuj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aerapo maok, Jisaso am fárákapamp kar pwarokwaprá arakrá sér, “Yumo mámá lotu nap tokwae párámpea napo, ono warko yinɨnk yae fek saráp ti nanampono.” ");
INSERT INTO yuj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aeránko maok, am fárákapao sérrá, “Apae! Am lotu nap tokwae te 46 yopwar fek ti nap te, amo fwap yinɨnk yae fek saráp ti nanap nie?” ");
INSERT INTO yuj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aeno am lotu nap tokwae Jisaso sénámp te námokuráp pourouan sérimpon. ");
INSERT INTO yuj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Am tak rimp te nánkár wakmwaek Kwaro man apár me mekamp yinɨnki yakeanánko, fárámpá papámp fek maok, mao éréképá yárak i konámp arop fárákapao am sérimp kar nɨnɨkiapon. Tá Kwaromp Buk fek yaknámp kar ntia Jisaso sérimp karan kor mér napon. Aea maok, Jisas sérimp kar, tá Kwaro sérimp kumwian kor mériapon. ");
INSERT INTO yuj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisaso Jerusalem mek Pasova yae fek yakánko maok, kápae kare koumteouráp arop koropea mao nkwakwe make kárákáre yoro nánko nke. Aeria maok, am fárákap wae mao te Kraisonorá mér. ");
INSERT INTO yuj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Aeapao maok, Jisas te am fárákapan, wae kare naponorá nɨnɨk mono. ");
INSERT INTO yuj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Am te apae riteanápe, mao te ponankor aropamp nɨnɨk mek te wae méri yak námpon. Mao te apae nɨnɨk fae tákáre nánko, arop ankwapao man nɨnɨk sánk mwanapanápe, mono. Mao námoku waeman aropamp nɨnɨk mér kare yak námpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Arop ankárank maomp e te Nikodemus mao te Farisi fákáre mekampao, Juda fi taokeyak konámp arop. ");
INSERT INTO yuj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Am aropao Jisasnámpok kumuruk koropea maok, man sérrá, “Rabai, yino te wae mérono: Kwaro amwan te tisa niamp sámp-kérép námpono. Táte Kwaro arop ankwap méntér yak mo nánko te, am arop mokopia mámá amo yoro i konap kárákáre má yoro naenámpanáp mono.” ");
INSERT INTO yuj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Aeránko maok, Jisaso maomp kar pwarokwaprá sérrá, “Ono amwan kare kar sénampon: Arop warko wourékam yoro mo námp te, Kwaro náráp firáp taokeyak námp mek te nke naenámp pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Aeránko maok, Nikodemuso man sérrá, “Ae te arop wae méri yak námp te mokopiaka warko wourékam yoro naenámpon? Ae te fwap warko éntupwaromp yare mek youmpeanánko, éntupwaro warko fárákap naenámp nie? Tak naenámp pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aeránko maok, Jisaso maomp kar pwarokwaprá sérrá, “Ono wae amwan kare kar sér rae: Arop ént fek, tá Yiki Kor Spirit fek wourékam yoro mo námp te, Kwaro náráp firáp taokeyak námp mek te yoump naenámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ankank pourourao sámp námp oupourounki pap námp te pourouampono. Táte ankank Yiki Kor Spiritao yoroi námp te, am te Spiritampono. ");
INSERT INTO yuj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ono amwan sénamp kar táman korokop kwapono. Yumo ankár warko wourékam yoro kipo. ");
INSERT INTO yuj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ouwi te námoku akwap naerianámpaok akwap konámpon. Amo te párák mɨnkan wa napan maok, am te maoknámp koropea, maok akwaprianrá mér mono. Tá Yiki Kor Spiritao arop wourékam yoro i konámp te takeno.” ");
INSERT INTO yuj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Aeránko maok, Nikodemuso maomp kar pwarokwaprá arakrá sér, “Am ankank amo sénap te mokopia korop naenámpon?” ");
INSERT INTO yuj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Aeránko maok, Jisaso maomp kar pwarokwaprá arakrá sér, “Amo Israel firamp tisa te, mokopia am ankank épérép rape? ");
INSERT INTO yuj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ono waeman amwan kare kar sér rae: Yino sénámp te yino wae mérnámp ankankan sénámpon. Tá yino nkenámp ankank te yino wae farákáp námpon. Aeno yumo yino farákápnámp kar te younkwek sɨr konapon. ");
INSERT INTO yuj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ono manénkɨr yumwan apárokamp ankank sénanko, yumo mér mo napon. Táte taknámp ono yumwan yámar mekamp ankankan sénanko te, yumo mokopia mér mwanapon? ");
INSERT INTO yuj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Arop ankwap yámar mek pok moi námpon. Aropamp Táráp yámar me pwararea apárok ékámp te, mao ankárankampao mwar pok naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Wokwaek kar Moseso apár mwar mek bras fek tákam wunéri yoroia narek yaopwae fek arápámp niamp, Aropamp Tárápan kor arop fárákapao narek aráp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Aenapo maok, arop ponankor man nkea mér nap te, yae-párák kare yakápria, yiki yak kwapwe sámpea yaká yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwar te Táráp ankárankamp kare mwar yak námpon. Aenámpan maok, Kwaro ponankor koumteouráp aropan yonkwae touwe tokwae námp kwamp maok, am Táráp ankárankamp am arop fákáreran sánk námpon. Mao taki námp te, ponankor koumteouráp arop man méria, am fárákap yaomwi mek pɨk mono, ankár yiki yak kwapwe sámpea yakápi yakáp mwanapria ninámpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kwaro Táráp mámá apár mek sámp-kérép námp te, mámá apár mekamp aropao i konap apárokamp koumteouráp aropamp nɨnɨk yurukup naenámpria te mono. Mao sámp-kérép nánko ék námp te, am fárákapan warko érékép naenámpria ninámpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Arop am Kwaromp Tárápan mér námp te, mao kot mo, fwapono. Aeno arop man mér moianámp te, waeman kot naenámp arop yak námpon. Am te apae riteanápe, mao am Kwaromp Táráp ankárankamp táman mér moianámpara námpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Am kot mwanap fi te aránono: Wae kwapwe te waeman apárok ék námpan maok, arop fárákap te kɨrɨkɨpan warákárria am waeran warákár mo i konapon. Am te apae riteanápe, am fárákap te kwatae nɨnɨk i konap aropara napon. ");
INSERT INTO yuj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Arop ponankor kwatae nɨnɨk i konap te, am fárákap te waeran yopor napon. Maomp nɨnɨk érik farákár te monoria napara, wae fek korop mo i konapon. ");
INSERT INTO yuj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aeno arop kare kar nɨnɨk fek tére konámp arop te, mao fwap wae fek korop nánko, arop fárákap maomp tére nkea mériaka sérrá, ‘Maomp tére te Kwaromp kárákáre fek tére námpono’rá sér i konapon.” ");
INSERT INTO yuj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Takia pwarará wakmwaek Jisas ntia mao éréképá yárak i konámp arop fárákap Jerusalem pwarará, apár Judia mekmwaek tukup. Tukupea maok, am mek am fákárerént yakria maok, am mekamp koumteouráp aropan ént mek énérrá kákámp. ");
INSERT INTO yuj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jono kor koumteouráp aropan ént Ainon mek Salem wonae fik yak nánko maok, am fek te kápae kare ént yak nánko maok, koumteouráp arop koropapo, am fákáreran ént mek nérrá kákámpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Heroto Jonén oukoumwan kalabusia pap mo námp fekimpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aenko maok, Jono éréképá yárak i konámp arop fárákap, tá Juda mekamp arop ankárank makia Juda firao Kwaro nke námp fek yiki kukur mwaria yaeráp ankank yárár i konap nɨnɨkan nonopok kar yorowar. ");
INSERT INTO yuj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aeria maok, Jonént paokop i konap arop Jononámpok tukupea man sérrá, “Tisa, wokwaek kar arop amont Jordan mek nkwamwaek fimwaek fokopeyakánko, amo maomp kar kwapwe farákápap, am arop te oukoumwan koumteouráp arop fárákap ént mek nérrá kák nánko, ponankor maonámpok tukup nape.” ");
INSERT INTO yuj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Aerapo maok, Jono am fákáreran kar pwarokwaprá arakrá sér, “Yámar mekamp Kwaro arop ankwapan tére sánk mo nánko te, am arop te sámp mono. ");
INSERT INTO yuj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yumwan te wae ono wokwaek am kar séranko, wawiapon. Ono te Krais mono. Ono te am aropao akwap naenámp fek, mao onan, mekia akwapaeria sámp-kérépnámp aropono. ");
INSERT INTO yuj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ono te am aropao yupu sámpanoria yaewour i konámp arop niamp takeno. Táte arop ankwapao yupu sámp námp te, am yupu te ankár mao sámp námpon. Tá maomp nouroup te párák fokopeyakrá maomp karan wonae fik woupwi pátea wawia warákár konámpon. Táte taknámp onomp nɨnɨk mek te warákár tokwae nampon. ");
INSERT INTO yuj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Maomp e te ankár tokwae kari akwap nánko, onomp e te ankár kánanke kwaroki akwap naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Arop nareknámp ék námp te ponankor ankankan nareki yak námpon. Aeno arop mámá apár meknámp korop námp te, am arop te apárokampon. Aenámpara, mao te apárokamp nɨnɨkan téreria, mámá apár mekamp ankankan saráp sérar i konámpon. Aeno arop yámar meknámp ék námp te, ponankor ankankan poukwapea nareki yak námpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mao te ankank wae nke, tá wawianámpan farákáp konámpon. Ae konámpan maok, arop ankwap ankárankamp am kar farákápnámp sámpea, am kar nɨki-samp yárak mo námpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Arop am kar wawia nɨki-samp yárak námp te, am támao yénképrá: Kwar te kare kar sér i konámpria am karan mér kare námpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Am te apae riteanápe, am arop Kwaro sámp-kérép nánko koropeanámp, mao Kwaromp karan farákáp námpon. Kwar te man Yiki Kor Spirit aop-aopwekrá nénk mo i konámpono. ");
INSERT INTO yuj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Naropwaro náráp Tárápan warákár námp te ankank ponankor náráp Tárápamp yaek sánk nánko, taokeyak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Arop Kwaromp Tárápan mériaka ‘Kareno’rá sénámp te, mao te yae-párák yiki yaká yak naenámpon. Aeno arop Kwaromp Tárápamp kar wawia mántwaok yárak moi námp te, mao te yiki yak naenámp sámp mono, Kwaromp yonkwae pwarámp te maomp pourouk yak námpon. ");
INSERT INTO yuj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Am ke fek maok, Farisi fákárerao wa napo, Jisaso kápae kare arop éréképea ént mek nérrá kák nánko, am arop fárákap Jisaso éréképá yárak naenámp arop yakáp napo, am fárákap te Jono éréképá yáraknámp arop fárákapan kámákár akwap námpon. ");
INSERT INTO yuj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aerá sénapan maok, Jisas námoku te ént mek nérrá kák mo i konámpono. Námoku éréképá yárak i konámp arop fákárerao arop ént mek nérrá kák napon. ");
INSERT INTO yuj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Am Farisi fákáre támao am kar wae méria maok, Jisas am kar wawia méria maok, Judia apárok pwarará námoku éréképá yárak i konámp aropan éréképea Galili apár mek akwap. ");
INSERT INTO yuj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tá am mwae kup mao akwap naerianámp te Samaria mekmwaek akwapeyak námpon. ");
INSERT INTO yuj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aea maok, mao wae akwapeaka apár Samaria mek taun Sikar mek am apár te wokwaek kar Jekopo náráp táráp Josepén sánkámp fek wonae fik am fek. ");
INSERT INTO yuj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jisas koropea Jekopo wokwaek éntampor ént me tokwaeri yokoropámp fek, am fek nánko maok, yámar kuk nánko kokwae nánko, am ént me-tápok am fek tank. ");
INSERT INTO yuj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Aenánko maok, Samaria mekamp yupu ankárank ént yɨnkɨp naeria koropánko maok, Jisaso man sérrá, “Onan ént yɨnk-sáp napo, fánae.” ");
INSERT INTO yuj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Mént paokop i konap arop fákáre te fɨr ti mwaria taun mek tukup tenapon.) ");
INSERT INTO yuj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Am Samaria mekamp yupu támao Jisasén sérrá, “Amo mwar Juda fi, tá ono mwar Samaria mekamp yupu te, amo mokopia onan ‘Ént sáp napo fánae’rá sénapon?” (Am yupu takrá sénámp te Samaria fi te ankwap fi ara, Juda fi mént tárápar mo i konapan sénámpon.) ");
INSERT INTO yuj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aeránko maok, Jisaso nopok am yupuan arakrá sér, “Táte amo Kwaro kwaporok nénk konámp ankank mérria, tá amwan ‘Ént sápae fánae’rá sénámp aropan mérria man sénapo te, mao fwap amwan yiki yak sánk konámp ént sánk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aeránko maok, yupurao man sérrá, “Arop Tokwae, amo te baket mo, tá ént me te tokwaeri. Aenámp te, amo am yiki yak sánk konámp ént te maokamp yɨnkɨp nanapon? ");
INSERT INTO yuj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yinomp appe Jekopo am ént me te yinan sáp námpon. Am ént me te námoku, náráp tárápu, tá bulmakau, sipsip, makia fáriapono. Ae te amo Jekopén kwe-pwar nap nie?” ");
INSERT INTO yuj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Aeránko maok, Jisaso maomp kar pwarokwaprá sérrá, “Arop ponankor mámá ént má fánapo te, maomp oumpour kor te warko káke naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Aeno arop ankárankao ono sánk nae namp ént fánámp te, ankwap ke fek warko oumpour kor káke mono. Am ént ono sánk nae namp te ankár ént me meknámp oukur námpnámp taknámp, nɨnɨk mek kor taknámpi yakria maok, yiki yak naenámp sánk nánko, kwapwe kare yaká yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aeránko maok, yupurao sérrá, “Arop Tokwae, amo onan am ént sápae. Aenapo nánkár wakmwaek te ono ént nɨkɨp mo nánko, ono mámá ént yɨnkɨp mo, tá ono warko mapek ént yɨnkɨprá korop mo nanampono.” ");
INSERT INTO yuj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aeránko maok, Jisaso man sérrá, “Amo akwapea waráp poumaropan séria maok, warko arákarrá mapek koropae.” Aeránko maok, yupurao maomp kar pwarokwaprá sérrá, “Ono te poumarop mono.” ");
INSERT INTO yuj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jisaso man sérrá, “Amo ‘Ono te poumarop mono’rá sénap te, amo te kare kar sénapon. Wokwaek amo mént yakap poumarop te éntikan maok, ");
INSERT INTO yuj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tá oukoumwan amo mént yaknap arop te waráp poumarop mono. Aenámpara, waráp kar am te kare karono.” ");
INSERT INTO yuj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aeránko maok, yupurao man sérrá, “Arop Tokwae, oukoumwan ono wae mér nampono, amo te profet ankwapono. ");
INSERT INTO yuj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yinomp appeyaenáp mámá faonkwe mapek koupoukarea, lotu i konapan maok, yumo Juda firao Kwarén lotu i konap némp te ankár Jerusalem mek sarápono.” ");
INSERT INTO yuj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aeránko maok, Jisaso man sérrá, “Yupu, amo te onomp kar man wawia mérae. Nánkár wakmwaek koropnámp ke fek Naropwar Kwarén yumo mámá faonkwek mapek lotu mo, tá Jerusalem mek kuri man lotu mono. ");
INSERT INTO yuj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria yumo te mér monap ankankan lotu napon. Aeno Juda yino te ankank wae mér námpan lotu i konámpon. Am te apae riteanápe, Kwaro arop fi ponankor warko érékép naenámp tére te Juda fi yinanmékɨr tére námpono. ");
INSERT INTO yuj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aeno am korop naenámp yae te oukoumwan te wae korop námpon. Tá arop ponankor lotu kare mwaria nap kwamp te, Kwar Naropwarén Yiki Kor Spiritamp kárákáre fek, tá kare kar nɨnɨk fek lotu mwanapon. Naropwar te take pourouráp lotunap arop fárákapan warákár tokwae námpon. ");
INSERT INTO yuj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kwar te Spiritara, arop man loturia te, ankár Yiki Kor Spiritamp kárákáre fek, tá ankár kare kar nɨnɨk fek lotu mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aeránko maok, yupurao man sérrá, “Ono wae mér nampon, Mesaia ék naenámpon. ‘Mao te Kwaro Nánapinámp Arop Kraisono’rá sér i konapon. Nánkár mao ékria te nomwan kápae kare ankank sénaenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aeránko maok, Jisaso man sérrá, “Am te Ono Taki Yak konamp má támao, amont kar sénampono.” ");
INSERT INTO yuj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aerá séránko maok, mént paokop i konap arop fákáre warko arári koropea, man nkeapo maok, yupu ankáranként kar sérrá yak. Aenánko maok, am fárákapao nkea pwarápaeria nɨnɨk tokwae. Aenapao maok, ankwap ankárankampao Jisasén ‘Amo apae sámp nae rap?’, tá ‘Apaeritea amo am yupurént kar sénap?’rá turunk mono. ");
INSERT INTO yuj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tá am yupurao náráp baket am fek pátará maok, warko taun mek arákarrá akwap. Mao akwapea koumteouráp aropan sérrá, ");
INSERT INTO yuj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Yumo arop ankárankamp koropá nkenke. Mao te ono wokwaek kar yárakinamp ankank érik farákáp námpon. Am te Kwaro sámp-kérép nanamprinámp Krais támaoi kane.” ");
INSERT INTO yuj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aeránko maok, am fárákapao taun pwarará Jisasnámpok korop. ");
INSERT INTO yuj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Am ke fek táman, mént paokop i konap arop fákárerao Jisasén sérrá, “Tisa, amo wae fárae.” ");
INSERT INTO yuj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Aerapo maok, mao am fárákapan sérrá, “Ono fɨr wae tank námpono. Am fɨr te yumo mér mono.” ");
INSERT INTO yuj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aeránko maok, mént paokop i konap arop fákárerao námoku sérarrá, “Ae te arop ankwapao man fɨr sankoropá sánk kare nape?” ");
INSERT INTO yuj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Aerapo maok, Jisaso am fárákapan sérrá, “Onomp fɨr te aránono: Ono ankár Kwaromp nɨnɨkaok tére nanampon. Mao onan sámp-kérép nánko ék namp te, ono ankár maomp tére ponankor térea pwar nanampon.” ");
INSERT INTO yuj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jisaso námoku éréképá yárak i konámp aropan sérrá, “Yumo kor tak tére mwanaponoria arakrá sér, ‘Fɨr kare naenámp yunk te yiawor yunk fek kare nánko mokwap konámpono.’ Aeno ono yumwan sénamp te: Yopwar mek fwapia énounkoupia fɨr wae kare námp nke kipo. ");
INSERT INTO yuj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Arop yopwar mekamp fɨr toupour námp te nopok am fek sámpria maok, fɨr kare námp ti námp niamp koumteouráp arop kápae kare tia yiki yakáp námp mek éréképá koropea párakop naenámpon. Aenánko yoro i konámp arop ntia toupour i konámp arop, am arop yawor te énénkér warákár konepon. ");
INSERT INTO yuj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Aenepara, mámá kar te kare karono: ‘Arop ankwap ankárankao yopwar yɨmp tenánko, arop ankwapao am fɨr ti konámpon.’ ");
INSERT INTO yuj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ono te yumo wokwaek am mek tére moinap yopwar mekamp fɨran tukupá tienkria tirá kérépampon. Arop ankwap fárákapao am yopwar yoroia napo, yumo maomp tére kárákáre fek yaknámp firan yumo párák tukupá ti napon.” ");
INSERT INTO yuj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Am taun mekamp Samaria arop kápae kare am yupuramp kar wawia Jisasén mériapon. Am te apae riteanápe am yupurao sérrá, ‘Kápae kare ankank ono wokwaeki namp te, mao érik farákáp námp’rá sénánko napono. ");
INSERT INTO yuj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tá Samaria fákárerao Jisasnámpok koropea man sérrá, “Amo te yinont mapek yakae.” ");
INSERT INTO yuj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Aerá sénapantá maok, am fek anánki yakánko maok, kápae kare arop Jisasomp kar námokuráp woupwi fek wawia maok, mériapon. ");
INSERT INTO yuj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aeria maok, am fárákapao am yupuran sérrá, “Yino te amo sénap karan saráp wawia am aropan mér mono. Yinoku kareao kor mao námoku sénámp kar wawia, am arop te apárokamp arop ponankor warko érékép naenámp arop támaonorá mér námpon.” ");
INSERT INTO yuj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Am fek anánki yakea maok, Jisas am feknámp distrik Galili mek akwap. ");
INSERT INTO yuj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Jisas námoku kar farákápria maok, sérrá, “Profet te námokuráp némpouk te e yak mono.”) ");
INSERT INTO yuj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ae konapan maok, warko Galili mek akwapánko maok, manénkɨr yae tokwae fek Jerusalem mek nkwakwe make kárákáre yororo nánko nkeap kwamp maok, mao koropánko man nkea warákariapon. ");
INSERT INTO yuj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jisaso warko akwapea Galili mekamp taun Kana mek. Am taun mek te manénkɨr éntan wain ént arákarea papámpon. Am ke fek táman Kingomp ofisa am taun mek korop nánko, maomp poumou-táráp Kaperneam mek touwe sámpá yak. ");
INSERT INTO yuj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Am aropao wa nánko, Jisas Judia meknámp Galili mek koropeanrá sér. Aenapo maok, mao akwapea Jisasén sérrá, “Onomp táráp touwe sámpea sumpwi naeria waeane! Koropea fwapi papae.” ");
INSERT INTO yuj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tá Jisaso man sérrá, “Ono nkwakwe make kárákáre yoro nanko, nke moria te, yumo onan mér mo mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Aenánko maok, Kingomp ofisa man sérrá, “Arop Tokwae, amo koupour koropae! Takria onomp táráp sumpwiantáno!” ");
INSERT INTO yuj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tá Jisaso man sérrá, “Amo akwapae. Waráp táráp wae fwap yiki yak námpon.” Aeránko maok, am aropao Jisasomp kar wawia kare námponorá nɨnɨkia akwap. ");
INSERT INTO yuj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mao oukoumwan Kaperneam mek akwap mono, oukoumwan mwaeaok nánko maok, maomp tére konap aropao koropea mwaeaok kɨkɨpia man sérrá, “Waráp táráp te wae fwap tank námpono.” ");
INSERT INTO yuj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aerapo maok, mao am fárákapan turunkrá, “Mae ke fek fwapi námpon?” Aeránko am fárákapao man sérrá, “Yipɨrman yámar ankárank ke nánko, pourou touwe fopokor námp te wae worokor pɨk námpon.” ");
INSERT INTO yuj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aerapo maok, naropwaro kor yipɨrman take ke fek táman Jisaso ‘Waráp táráp yiki yak námpono’rá sérimp nɨnɨkia mér. Aenánko maok, maomp firáp aropao kor ponankor mériapon. ");
INSERT INTO yuj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisaso Judia meknámp koropea Galili mekia maok, mámá kárákáre yoro námp te anánkan yoro námpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Taki pwatea maok, Juda lotu i konap Yae Tokwae korop námp fek, Jisaso Jerusalem mek akwap. ");
INSERT INTO yuj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem mek sipsip mank konap ménki tokwae yak námp fek ént aokore am fek yak. Am ént aokoreamp e te Hibru kar fek te ‘Betesda’rá sér i konapon. Am ént aokore fik, tankáp mwanap naepik éntik yoroia pwate nap yak námpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Am kaerik am fek te kápae kare touwenap arop am fek tankáp konap te yi néneráp arop, tá pu kwataenámp arop, tá kour surumpwi yakápnap arop fárákap am fek tankáprá ént meknámp purumpur aokanoria yépékrá tankáp i konapono. ");
INSERT INTO yuj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ankwap ke fek Tokwae Karamp enselo ént aokore mek am mek pɨkia anakop nánko, am ént purumpur aokea pwaránko maok, tá arop am mek manénkɨr mekia pɨk nánko te maomp touwerao kor warko fwap i konámpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Arop ankárankamp ént aokore fik am fek tank námp te maomp touwe te 38 yopwar yakámp. ");
INSERT INTO yuj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisaso am arop ampánko, man nkea maok, maomp touwe te wokwaek karkampao yak námpria wae mérámp kwamp, Jisaso man sérrá, “Ae te amo te waráp pourou te fwapanoria nape?” ");
INSERT INTO yuj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aeránko maok, am touwenámp arop támao Jisasomp kar pwarokwaprá sérrá maok, “Arop Tokwae, ént purumpurnámp ke fek te, onan sámpeaka ént aokore mek pap naenámp arop te mono. Onoku pɨk nae nanko maok, arop ankwapao onan kámá-pwarará námomékɨr mekia pɨk konámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aeránko maok, Jisaso man sérrá, “Amo fárámprá waráp am fek amp i konap ankank sámprá akwapae.” ");
INSERT INTO yuj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aeránko maok, am aropamp pourou koupour kar wae kwapwe kare. Aenánko maok, táte am arop náráp am fek amp i konámp ankank sámpea akwapámp. Am yae te Sabat yae fekara, ");
INSERT INTO yuj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Juda taokeyakáp konap arop fákáre am fwapinámp arop táman sérrá, “Oukoumwan te Sabat yae fekara, amo te waráp amp i konap ankank sámpea akwap kwapono. Am te founo.” ");
INSERT INTO yuj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aerapo maok, mao am fárákapan sérrá, “Onan fwapi papnámp aropao onan, ‘Waráp am fek amp i konap ankank sámpea akwapae’rá séri námpon.” ");
INSERT INTO yuj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Am fárákapao man turunkrá, “Amwan te apae aropao sérrá, ‘Waráp am fek amp i konap ankank sámpea akwapae’ ri námpon?” ");
INSERT INTO yuj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Aerapo maok, kápae kare koumteouráp arop am fek néntápapo, Jisas wae akwap tenámpara, am touwe fwapinámp aropao kor mao te wanonorá fwapia mér mono. ");
INSERT INTO yuj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wakmwaek Jisaso lotu nap tokwae mek man nkea maok, man sérrá, “Amo wawae! Oukoumwan te amo wae fwap napon. Warko amo kwatae nɨnɨki kwapono. Takria waráp pourou warko touwe tokwae kar koropantáno.” ");
INSERT INTO yuj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aeránko maok, am aropao akwapea Juda taokeyakáp konap arop fákárean sérrá, “Onan touwe fwapi papnámp arop te Jisas támaono.” ");
INSERT INTO yuj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Aerámpantá maok, am fákárerao am feknámpia Jisasén yoporrá pokopiapon. Am te apae riteanápe, Sabat yae fek takrá tére námpantá niapon. ");
INSERT INTO yuj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Aeapo maok, Jisaso nopok am fárákapan sérrá, “Onomp Naropwar te kápae kare por kumur méntép térerá koropea oukoumwan námpon. Tá ono kor tére konampon.” ");
INSERT INTO yuj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aerámpantá maok, am fákárerao wawia yonkwae pwarámpea Jisasén sámp-wouroump mwaria wae. Aeria mao arakrá sér, “Mao te Sabat yae anepér i konap lo mwar oupoukour akwap mono. Mao sérrá, ‘Kwar te náráp Naropwar kare’rá sénámpon. Am kar mao takrá sénámp te námoku támao Kwar niamp yak námpon!” ");
INSERT INTO yuj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisaso am fárákapan nopok sérrá, “Ono waeman yumwan kare kar sénampon: Táráp námoku mwar te námokuráp nɨnɨk fek saráp ankwap ankank tére naenámp pourou mono. Mao tére námp ankank te Naropwaro nánko nkea pwatea maok, kápae kare ankank Naropwaro tére námp te, Tárápao kor mántwaok tére námpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Am te apae riteanápe, Naropwaro náráp Tárápan warákárria man ponankor ankank yénkép námpon. Tá yumo korokop tokwae mwanap ankwap tére tokwae kar, mámá oukoumwan tére námpan kámákár akwap námp yénkép naerámpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Naropwaro sumpwinap arop kéménkia paprá yiki yak nénk konámpono. Tá taknámp Tárápao kor námoku warákárnámp nɨnɨk fek aropan yiki yak nénk naerámpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Naropwar te arop ankwapan yurukuprá kot mo i konámpono. Kot mwanap tére te wae ponankor Tárápan sánk tenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Aenámpara, arop ponankor Naropwaromp eran sakap konapnámp taknámp, Tárápamp eran kor sakap mwanapono. Arop Tárápamp e sakap mo i konámp te, Tárápan sámp-kérép nánko éknámp Naropwaromp eran kor sakap mono. ");
INSERT INTO yuj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ono wae yumwan kare kar sér rae: Arop onomp kar wawia onan sámp-kérép nánko éknamp Naropwar man mér námp te, mao te fwap yiki yaká yak naenámpon. Am arop man kot mo, tá sumpwi konap pwararea oukoumwan te wae yiki yak námpono. ");
INSERT INTO yuj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ono yumwan kare kar sér rae: Am korop naenámp yae te oukoumwan te wae korop námpon. Aenámpara am arop fákáre oukoumwan sumpwi nap niamp yakáp nap, Kwaromp Tárápamp kar wa mwanapon. Tá am wanap arop fárákap te yiki yakáp sámp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Naropwar te námoku yiki yak fi korara, Tárápan kárákáre sánk nánko, mao kuri yiki yak fi korrápono. ");
INSERT INTO yuj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mao te Aropamp Tárápara, Naropwaro man koumteouráp aropamp nɨnɨk yurukuprá kot naenámp kárákáre sánk námpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yumo te am ono má sénamp kar táman nɨnɨk tokwae kwapono. Am ke korop naerianámp te, apár me mek yakápnap ponankor koumteouráp arop te Tárápamp kar wawia, ");
INSERT INTO yuj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","apár me pwarará érik ouroumpá korop mwarea napon. Takia maok, arop fárákap kwapwe kare nɨnɨki nap te warko ferámpea yiki yakáp mwanapon. Aeno kwatae nɨnɨkinap arop fárákap te warko ferámpea tukupá kotia napo, kotao sérrá, ‘Ponankor yaomwi mek pɨkenk’rá sénaenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jisaso warko sérrá, “Ono te onokump nɨnɨk fek ankwap ankank tére nanamp pourou mono. Ono te Naropwaro sénámp karwaok sarápria koumteouráp aropamp nɨnɨk yurukup nampono. Tá ono kot namp yae-párák námp te, apae riteanápe, ono te onokump nɨnɨkaok mono. Onan sámp-kérép nánko ék namp Naropwaromp nɨnɨkaok saráp nampara námpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Táte onoku mwar saráp téreria, onokump nɨnɨk fek kar farákáp nanko te, onomp kar te arop fárákapao karenoria fwapia mér mono. ");
INSERT INTO yuj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Aeno arop ankwapao fokopeyakria onomp kar farákáp nánko te, ono wae am onomp kar farákáp námp te karenorá mér nampon. ");
INSERT INTO yuj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yumo Jononámpok arop tirá kérép napo, tukupea wa napo, mao onomp nɨnɨk ntia tére nanampan ‘Am te kare karono’rá sérimpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ono te arop ankwapao onomp kar, tá onomp tére ‘Karenorá sérenk’rá nɨnɨk mono. Aeno onomp nɨnɨk te, Kwaro yumwan warko éréképanoria maok, ono má kar farákáp nampon. ");
INSERT INTO yuj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon te lam wae niampi yakria arop yumwan ponankor wae sánkámpon. Tá fae tákáre ke fek yumo am wae táman warákár napao maok, warko pwarari napon. ");
INSERT INTO yuj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Aeno ankank Jonén kámákár akwap námp te mao oukoumwan ono tére nanamp máman farákáprá sérimpono. Am te am tére ponankor onomp Naropwaro onan, térea pwaraeria sáp námp támaono. Ono am tére nanko, aropan onomp Naropwaro onan sámp-kérép nánko ono ék namp yénkép námpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tá onomp Naropwaro onan sámp-kérép nánko ono ék namp te, mao námoku kor onan yumwan yénkép námpon. Aenámpan maok, yumo te maomp kar te kánanke wa mo kar, tá yumo maomp yimetáp nke mo kare napon. ");
INSERT INTO yuj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yumo te am arop Naropwaro sámp-kérép nánko ék námp maomp kar wawia, mér mo napara, maomp karao kor yiráp nɨnɨk mek tank mo námpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yiráp nɨnɨk te yumo Kwaromp Buk fekamp kar nkerá farákápria am kar ponankor yurukup napo, am támao yumwan yiki yaká yakáp mwanap sánk naenámprá nɨnɨk napao maok, am Kwaromp Buk fek kor onan yénkép konámpan, ");
INSERT INTO yuj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","yumo te ononampok koropea yiki yak sámp te monoria napon. ");
INSERT INTO yuj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ono te aropao onan e tokwae sápanáponoria mámá kar sér mono. ");
INSERT INTO yuj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Aeno ono te yumwan wae mér nampon, yumo te Kwarén te ankár warákár mo kare napon. ");
INSERT INTO yuj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Onomp Naropwaro onan apárok ékaeria sámp-kérép nánko ék nampan maok, yumo onomp kar sámp mo napon. Aeno arop ankárankao námokuráp nɨnɨk fek koropea sénámp karan maok, yumo koupour kar maomp kar sámp konapon. ");
INSERT INTO yuj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yumo te yumokuráp arop firao e tokwae sánk napo, sámp mwar kar i konapono. Ae konapan maok, yumo tére kwapwe napo, Kwaro warákárria e tokwae sánk naenámpan maok, yumo kokwae napon. Yumo tak nap te mokopia onan mér mwanapon? ");
INSERT INTO yuj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yiráp nɨnɨk te ono onomp Naropwaro nke námp fek yumwan kot naenámpan mpwe nɨnɨk mwanape. Mono. Yumwan mao kot naenámp arop te Moses támaono. Am arop te yumwan yaewour naenámprá nɨnɨknap aropono. ");
INSERT INTO yuj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Táte yumo Mosesomp kar mér nap kwamp te, yumo onomp karan kor wawia mér mwanapon. Am te apae riteanápe, mao kumwinámp kar te yumwan onan érik yénkép námpon. ");
INSERT INTO yuj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aeno táte yumo mao kumwinámp kar karenorá mér moia te, mokopia onomp karan kor karenorá mér mwanapon?” ");
INSERT INTO yuj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Am kar wae pwaránko maok, Jisaso ént aokore Galili mek nkwamwaek fimwaek yoump. (Am ént aokore ankwap e te Taiberias.) ");
INSERT INTO yuj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Aenánko maok, mao touwenap arop fwapokwaprá kák námpantá maok, kápae kare koumteouráp arop maonámpok tukup. ");
INSERT INTO yuj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas faonkwek pokea námoku éréképá yárak i konámp aropént tank. ");
INSERT INTO yuj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Am ke te Juda firamp Pasova fári konap yae tokwae wae fae námpono. ");
INSERT INTO yuj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisaso nke nánko maok, kápae kare koumteouráp arop maonámpok koropapo maok, Filipén turunkrá, “Nomo te maokamp pan sámpeanánko am koumteouráp arop fár mwanapon?” ");
INSERT INTO yuj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mao am takrá sénámp te Filipén mokopon nke nae ritea námpon. Aeno mao námoku te am tére nanamprianámp te wae mér námpon. ");
INSERT INTO yuj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aenánko maok, Filipo maomp kar pwarokwaprá arakrá sér, “Táte nomo 200 mani silva fek pan sámpeanánko te, koumteouráp arop fárákap ponankor kánanke-táráp karrá fár mwanapan kor take pwi mo naeria námpon.” ");
INSERT INTO yuj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aenánko méntér paokop i konap arop, Saimon Pitamp nánae Andru man sérrá, ");
INSERT INTO yuj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Máyaknámp táráp ankárankampao mwar bali fekamp pan éntik, tá éntékam anánkaopwe tank námpon. Aenámpan maok, koumteouráp arop te ou tokwae námpara, má pan ntia éntékam te mokopia pwi naenámpanép?” ");
INSERT INTO yuj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Aeránko maok, Jisaso sérrá, “Koumteouráp aropan sénapo tankápanápono.” (Kápae kare apwar pwae kwapwe yak námpono.) Tá am arop tankáp napo, kouroump nap te 5000 niamp arake. ");
INSERT INTO yuj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Am fárákapao tankápapo maok, Jisaso pan sámpea maok, Kwarén ‘Aesio’rá séria maok, táte am koumteouráp arop fárákapan nénkea maok, tá éntékam anánkaopweran kor tak. Mao am fárákapan nénk nánko maok, am fárákapao fépéria napo pwi. ");
INSERT INTO yuj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Fépéria pwi napo maok, Jisaso námoku éréképá yárak i konámp aropan sérrá, “Yumo fɨr ankwapmwaek tankápnámp popokenke. Takria fɨr ankwapmwaek kwaporok pwarantáno.” ");
INSERT INTO yuj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Aeránko maok, arop fépéria pwar napo, am bali fekamp pan éntik fekamp ankwapmwaek oukoumwan tankáp námp koupoukarea éntér-sámpramp basket mek kákapono. ");
INSERT INTO yuj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Koumteouráp arop fákárerao Jisas am ankank yoroimpan nkeaka sérrá, “Kare korono. Máte profet Kwaro ‘Apárok sámp-kérép nanamp’rá sérimp támaono!” ");
INSERT INTO yuj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aerapo maok, Jisaso am kar wawia mér, am fárákap te koropea námwan sérémékéri fákeyakrá ‘Náráp king yakae’rá sér mwaria napon. Aeria maok, mao am némp pwarará faonkwek arákarrá pokámpon. ");
INSERT INTO yuj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kumuran Jisasént paokop i konap arop fákárerao ént aokore mek tukupea maok, ");
INSERT INTO yuj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","am fákárerao bot ankárank sámpea bot meknámp ént aokore tépériaka Kaperneam mek tukup mwaria mwaeaok tukup. Aeapo maok, wae kumuri yak nánko maok, Jisas te am fárákapaonapok oukoumwan akwap mo. ");
INSERT INTO yuj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Am fárákapao bot mek tankápapo maok, kárákáre kor ouwi koropria, am ouwi támao ént panánkarrá sankorop. ");
INSERT INTO yuj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aenánko, am fárákapao ént arákaprá tukupea, éntik, tá tokwampok kilomita fekria maok, am fárákapao nke napo, Jisas wae ént yumunturik koropeaka bot yak námp fek wonae fik. Aenánko, am fákáre te apáp tɨrɨnk napo maok, ");
INSERT INTO yuj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jisaso am fárákapan sérrá, “Máte ono korop rae. Yumo te apápi kwapono.” ");
INSERT INTO yuj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aeránko maok, am fárákapao warákáránkia, Jisasén bot mek warámp-sɨnapo maok, koupour kar am bot wae am tukup mwaria nap mek akwapámpon. ");
INSERT INTO yuj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wakmwaek ankwap kumuruk maok, am koumteouráp arop ént aokore mek nkwamwaek fimwaek yakáp. Am fárákap te wae mér, yipɨrman te bot ankwap tank moimpon. Ankárankamp bot mwar tank nánko, Jisas te am mek korokwap mono. Mao éréképá yárak i konámp arop fákáre mwar am mek kounkouria tukupapon. ");
INSERT INTO yuj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aenapo maok, Taiberias mekamp bot ankwap fárákap Tokwae Karao pan Kwarén ‘Aesio’rá séria nénkánko fáriap némpouk am fek korop. ");
INSERT INTO yuj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tá koumteouráp arop fárákapao kor nkeapo maok, Jisas ntia mao éréképá yárak i konámp arop fárákap yakáp mo. Aenapantá maok, am fárákapao bot ankwap mek kounkouria tukupea Kaperneam mek Jisasén oupourounkiap. ");
INSERT INTO yuj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Am koumteouráp arop fárákap wae tukupea Jisasnámpok ént aokore ankwapmwaek fikria maok, man arakrá turunk, “Tisa, amo mapek te makár korop napon?” ");
INSERT INTO yuj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mak rapo maok, Jisaso am fákáreramp kar pwarokwaprá sérrá, “Ono yumwan kare kar sénampon: Yumo te ono yumwan yénkép nanko nkenap kárákárerao yénkép naenámp fi mér mwaria onan oupourounkrá korop mono. Yumo te am pan ono yumwan fékérrá nénk nanko, fépéria yare tokwae nap am fi fek táman yumo onan oupourounk napon. ");
INSERT INTO yuj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yumo te kwatae akwap konámp fɨr táman sámp mwaria tére kwapono. Yumo te ankár yaká yak konámp fɨran sámp mwaria tére kipo. Take pourouráp fɨr te Aropamp Tárápao yumwan nénk naenámpon. Naropwar Kwaro tak naenámpria wae kárákáre man sánk tenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aeránko maok, am fárákapao man sérrá, “Ae te yino mokopiaka Kwaro warákárnámp tére tére mwanámpon?” ");
INSERT INTO yuj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aerá sérapo maok, Jisaso am fárákapamp kar pwarokwaprá sérrá, “Yumo Kwaro warákárnámp tére mwanap te aránono: Yumo ankár am arop Kwaro sámp-kérépánko ék námpan mér kipo.” ");
INSERT INTO yuj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aeránko maok, am fárákapao am kar wawia man arakrá turunk, “Ae te amo apae nkwakwe make kárákáre yoro napo, yino táman nkea waráp kar te karenoriaka mér mwanámpon? ");
INSERT INTO yuj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wokwaek kar yinomp ounáp fákáre kwar saráp mek mana fáriapon. Am te Kwaromp Buk fekamp karao sérrá, ‘Am pan te yámar mekampan am fárákapan nénkánko fáriapon’rá sénámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aerapo maok, Jisaso am fárákapan sérrá, “Ono te waeman yumwan kare kar sér rae: Am pan Moseso yumwan nénkámp te yámar mekamp mono. Onomp Naropwar te yámar mekamp pan kareran yumwan nénk konámpono. ");
INSERT INTO yuj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Am pan Kwaro nénk námp te, yámar mek pwarará ékia apárokamp koumteouráp aropan yiki yak mwanap nénk konámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aeránko maok, am fárákapao man sérrá, “Arop Tokwae, amo te ankár am pan ti-sáp saráp yakampo!” ");
INSERT INTO yuj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aerapo maok, Jisaso am fárákapan sérrá, “Onoku karerao yiki yak nénk konámp pan nono. Arop ononampok korop námp te yae-porokwe mono. Tá arop onan mér námp te mao te éntantá oumpour kour káke mono. ");
INSERT INTO yuj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ono yumwan wae séri nampono, yumo onan wae nke napao maok, yumo onan mér mo napon. ");
INSERT INTO yuj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ponankor koumteouráp aropan onomp Naropwaro onomp yaek sáp námp te, am fárákap te ononampok korop mwanapon. Tá arop ononampok korop námp te, ono te man yérépe nanamp pourou mo kareno. Ono yámar me pwarará ék namp te onokump nɨnɨkaok yárak naeria mono. ");
INSERT INTO yuj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ono te onan sámp-kérépnámp Naropwaromp nɨnɨkaok naeria ék nampon. ");
INSERT INTO yuj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mao onan manénkɨr sámp-kérép nánko éknamp nɨnɨk te aránono: Mao onan sápnámp koumteouráp arop fárákap te ankwap ankárankamp pwar mono, nánkár wakmwaek pwarnámp yae fek te ono ankár ponankor kékéménkrá kák nanampon. ");
INSERT INTO yuj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Onomp Naropwaromp nɨnɨk te aránono: Arop ponankor Tárápan nkea méria maok, yiki yakáp mwanap sámpea yae-párák kare yaká yakáp mwanapon. Tá nánkár pwarnámp yae fek ono am fárákapan kékéménkrá kák nanampon.” ");
INSERT INTO yuj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tá Juda fi Jisaso ‘Ono támao am yámar me pwarará éknamp pan nono’rá sénámp kar wawia námoku kok téréménkrá kara wae. ");
INSERT INTO yuj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Aeria maok, am fárákapao sérrá, “Mámá arop máte Jisas Josepomp tárápono. Nomo maomp éntupwar naropwar te wae mér námpono. Am te mokopia oukoumwan mao sérrá, ‘Ono te yámar me pwarará ék namp’rá sénámpon?” ");
INSERT INTO yuj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Makrá sénapo maok, Jisaso am fákáreramp kar pwarokwaprá arakrá sér, “Yumo te yumoku ou mek yumoku támao téréménka wae kwapono. ");
INSERT INTO yuj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Arop ankárankao námokuráp nɨnɨk fek te ononampok korop naenámp pourou mo kareno. Onomp Naropwaro onan manénkɨr sámp-kérépánko ékamp te, támao am aropamp nɨnɨk mek farop-sɨrarea ononampok warámpá korop naenámpon. Aenánko maok, ono man am yae pwar námp fek apár me mekamp fárámpá pap nanampon. ");
INSERT INTO yuj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Profet fákárerao kumwiap kar Kwaromp Buk fek yak námpao sérrá, ‘Kwaro ponankor koumteouráp arop kar yénkrá farákáp naenámpon.’ Kwaro am tak nánko, koumteouráp arop ponankor onomp Naropwaromp kar wawia man mér sámpea, ononampok korop konapono. ");
INSERT INTO yuj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Arop ankwap ankárank te onomp Naropwarén te nke moi námpon. Am arop Kwarént yakea éknámp aropao saráp Naropwarén nke námpon. ");
INSERT INTO yuj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ono waeman yumwan kare kar sér rae: Arop onan mér námp te yiki yak naenámp kwapwe sámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Onoku támao yiki yak nénk konámp pan nono. ");
INSERT INTO yuj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wokwaek kar kwar saráp mek yiráp wokwaekamp appeyaenápén pourouan yaewourimp pan mana fépériapao maok, am fárákap te wae surumpwiapon. ");
INSERT INTO yuj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aeno am pan yámar me pwararea ék námp te, koumteouráp arop fépéria nap te surumpwi mono. ");
INSERT INTO yuj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ono te am yiki yak konámp panao yámar me pwararea ék nampon. Táte arop ankárankao am pan fárianámp te, mao te yiki yaká yak naenámpon. Am pan ono man sánk nanamp te, am te onokump pourounono. Ono apárokamp koumteouráp aropan nénk nanko te, am fárákap te yiki yakáp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aeránko maok, Juda fákáre am kar wawia námoku kok kákkarria maok, arakrá sér, “Mámá arop te mokopiaka námokuráp émi nomwan ti-sáp nánko, nomo fár mwanámpon?” ");
INSERT INTO yuj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Aerapo maok, Jisaso am fárákapan sérrá, “Ono te yumwan waeman kare kar sér rae: Yumo Aropamp Tárápamp émi fár mo, tá yumo maomp yɨri fár moia te, yumo te yiki yakáp te sámp mono. ");
INSERT INTO yuj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Arop onomp émi fánámp, tá onomp yɨri fánámp, mao te yae-párák kare yiki yaká yak nánko, ono man am yae pwar nánko kéménki pap nanampon. ");
INSERT INTO yuj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Am te apae riteanápe, onomp émi, tá onomp yɨri te fépér mwanap ankank kare támaono. ");
INSERT INTO yuj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Arop onomp émi fánámp, tá onomp yɨri fánámp te, mao onont yak nánko, ono mént yak nanampon. ");
INSERT INTO yuj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Onomp Naropwaro yiki yak námpao onan sámp-kérépánko, ono ékamp te, ono onomp Naropwaromp kárákáre fek yiki yak nampono. Aenampara, arop onan fánámp te, mao te onomp kárákáre fek yiki yak sámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Am pan támao yámar me pwararea ékámpon. Am pan te yiráp ounápo fária wakmwaek faokariap pan niamp te mono. Arop mámá pan fánámp te ankár yiki yaká yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisaso Kaperneam mekamp lotu nap mek yakria koumteouráp aropan kar yénkrá farákápria am fárákapan mámá kar sérimpon. ");
INSERT INTO yuj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Námoku éréképá yárak i konámp arop kápae karerao am kar wawia maok, am ou mekamp kápae kare arop fárákap arakrá sér, “Am kar mér mwanámp pourou mo námp te, wa mokop fwap wa naenámpon?” ");
INSERT INTO yuj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Am fárákapao man te sér moapo maok, Jisas námoku wae mérámp kwamp maok, námoku éréképá yárak i konámp aropao námoku kok sérarapo maok, Jisas am fárákapan sérrá, “Má kar te yumo wa napo, yiráp mér kwatae pap námp nie? ");
INSERT INTO yuj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ae te yumo am kar sámp moiaka nánkár nke napo, Aropamp Táráp wokwaek yakámp némpouk narek pok nánko te, yumo te mokop mwanapon? ");
INSERT INTO yuj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yiki Kor Spirit námoku maok aropan yiki yak sánk konámpon. Arop námoku arop ankwapan yiki yak sánk naenámp pourou mo kareno. Má kar ono yumwan sánk namp, mao te Kwaromp yiki yak sánk konámp Spiritamp ankankono. ");
INSERT INTO yuj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Aeno yumo ankwap fákáre te oukoumwan onan mér mo napon.” (Wokwaek kar arop man mér mo mwanap te, Jisas manénkɨr méri tenámpon. Tá am arop námwan yopor aropamp yaek sánk naenámp aropan kor wae méri tenámpon.) ");
INSERT INTO yuj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aeapantá maok, mao sérrá, “Am táman ono manénkɨr yumwan sériamp te, onomp Naropwaro aropan kárákáre sánk mo nánko te, ononampok korop naenámp pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jisaso am kar farákápea pwaránko maok, Jisasént paokop i konap kápae kare arop fárákap méntér paokop mo, Jisasén pwarará warko arári tukup. ");
INSERT INTO yuj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aeapo maok, Jisaso námoku éréképea yárak i konámp arop éntér-sámprampan turunkrá, “Ae te yumo kor wae onan pwatea tukup mwaria nape?” ");
INSERT INTO yuj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Aeránko maok, Saimon Pita maomp kar pwarokwaprá arakrá sér, “Tokwae Kar e! Yino te wanámpok tukup mwanámpon? Waráp kar te yiki yak kwapwe sánk konámpon. ");
INSERT INTO yuj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yino wae wawia méria maok, amo te Kwaro námoku nánapia sámp-kérép nánko ék nap yiki kor kare arop támao naprá mér kare námpon.” ");
INSERT INTO yuj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Aerapo maok, Jisaso am fárákapamp kar pwarokwaprá sérrá, “Ono wae éntér-sámpramp yumwan onomponoria nánkáráp nampon. Aenampan maok, yumo ou mekamp arop ankárankamp maomp nɨnɨk mek te kwatae-aropono.” ");
INSERT INTO yuj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Má sénámp kar máte Saimon Iskariotomp táráp Judas am arop te Jisasént paokop i konap éntér-sámprampao maok, ankwap ankárankao nánkár wakmwaek Jisasén man farop mwanap aropamp yaek sánk naenámpan sénámpon.) ");
INSERT INTO yuj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Am kar pwaránko maok, Jisas Galili mekmwaek akwap. Juda firao man farop mwariakapantá maok, Judia mekmwaek akwap moimpon. ");
INSERT INTO yuj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Juda firao sákae kánanke mek yakápiap nɨnɨkrá lotu i konap yae wae fae nánko, ");
INSERT INTO yuj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jisasomp nánaeounápo man sérrá, “Amo te mámá apár pwarará Judia mek akwapea napo maok, amo éréképá yárak i konap arop fárákap waráp mwar pourouráp térenap nke mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Arop ankárank, arop námwan méranoria te kánánkámp tére mo i konámpon. Aeno amo am tére nap kwamp te, ankár koumteouráp aropao nke nap fek érik fokopeyakrá téreampo.” ");
INSERT INTO yuj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Maomp nánaeounápo kor man fwapia mér moria man makrá sér. ");
INSERT INTO yuj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aerapo maok, Jisaso am fárákapan sérrá, “Ono érik tére nanamp yae te oukoumwan sɨkono. Mámá ponankor yae te yirápono. ");
INSERT INTO yuj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kwaromp kar wa monap fákáre te yumwan tirá wour mono. Onan maok am nkwakwe make nɨnɨk kwatae ti-yakáp napo, am táman érik sérar nanko, am fek onan yopor napono. ");
INSERT INTO yuj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yumoku maok am lotu i konap Yae Tokwae tukupea nkenke! Ono te onomp yae oukoumwan sɨk námpara, akwap mono.” ");
INSERT INTO yuj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mao am fárákapan makrá séritea maok, Galili mek yépékrá yak. ");
INSERT INTO yuj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tá Jisasomp nánaeounáp fákáre am Yae Tokwae nke mwaria tukupapo maok, Jisaso kor wakmwaek akwapámpao maok, mao te érik akwap mono, akwapea meaok yárakimp. ");
INSERT INTO yuj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aenko Juda firan taokeyakáp konap arop fákáre man am Yae Tokwae fek am fek oupourounkrá paokopria maok, sérrá, “Am arop te maok yakáne?” ");
INSERT INTO yuj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Aerapo maok, koumteouráp arop fákárerao kánánkámp téréménkrá sérarrá maok, “Am arop te yae-párák kare aropono.” Aerapo ankwap fárákapao sérrá, “Mono. Mao te kápae kare aropan kwekárrá sér i konámpono.” ");
INSERT INTO yuj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Aeria maok, Juda taokeyakáp konap arop fákáreran apáp napara, arop ankwap ankárank érik sér mono. ");
INSERT INTO yuj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Am lotu i konap ke fek amore mek Jisas akwapea lotu nap tokwae mek koumteouráp aropan kar yénkrá farákápámp. ");
INSERT INTO yuj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aenánko maok, Juda firan taokeyakáp konap arop fákáre am kar wawia nɨnɨk tokwaeria maok, arakrá sér, “Mámá arop máte skul moi námp te, maokamp mámá mér sámp námpon?” ");
INSERT INTO yuj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aerapo maok, Jisaso am fárákapamp kar pwarokwaprá sérrá, “Mámá kar ono yumwan sánk namp te onokump mono, onan sámp-kérép nánko éknamp Kwaromp karono. ");
INSERT INTO yuj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Aeno arop ankárankamp Kwaromp karwaok akwap naeria te, mao te ono farákápnamp kar fi máte fwapia méria maok, am kar te Kwaro sénámpaoeane, tá ono onokump nɨnɨk fek farákáp nampaoeanierá mér naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Arop námokuráp nɨnɨk fek kar farákáp námp te, ankwapao náráp e narek sampokanoria ni konámpon. Aeno arop mao sámp-kérépnámp aropamp e narek sampok námp te, mao te kwekár mono. Yae-párák kare aropono. ");
INSERT INTO yuj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Wokwaek kar Moseso yumwan lo kar sánkámpan maok, yumo te ankwap ankárank am lo karaok tukup moiapon. Ae nap tane yumo te apaerá onan sámp-wouroump mwaria nape?” ");
INSERT INTO yuj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aeránko maok, am fárákapao man kar pwarokwaprá sérrá, “Amwan te kwatae-arop woukoupeyakri kane! Amwan te wa sámp-wouroump naeriane?” ");
INSERT INTO yuj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aerapo maok, Jisaso kar pwarokwaprá sérrá, “Ono manénkɨr Kwaromp kárákáre yénképnámp tére nanko, yumo ponankor nkea nɨnɨk tokwaeapon. ");
INSERT INTO yuj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moseso yumwan manénkɨr ‘Yɨpi fékérenk’ ria sérimp te (Am nɨnɨk te kareran maok, Mosesoimpanápe, yiráp ouyaenápoimpan maok) yumo Sabat fek kor fwap poumou-táráp yɨpi fárákap konapon. ");
INSERT INTO yuj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yumo te Mosesomp lo táman nɨnɨkia mántwaok tukupria maok, tárápamp yɨpi Sabat yae fek fárákap konapan maok, tá ono Sabat yae fek arop ankwap pourou fwapi pap nanko te, yumo apaerá onan kokwarok napon? ");
INSERT INTO yuj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yumo te ankank ponankor yi fek saráp yurukupi kwapon. Ankár yae-párák kare nɨnɨk fek yurukup kip.” ");
INSERT INTO yuj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem mekamp koumteouráp arop ankwap fárákapao sérrá, “Má arop máte Juda taokeyakáp konap arop man sámp-wouroump mwaria nap támao nie? ");
INSERT INTO yuj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ae te nkenke! Mao te kar érik farákáp nánko, man te kar sér mo i konapon. Ae te arop fárákapao kor, máte Krais támaonorá nɨnɨk nap nie? ");
INSERT INTO yuj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Krais koropeanámp ke fek nomo te mao maoknámp koropeanrá mér mono. Aeno nomo te mámá aropamp némp te wae mér námpon.” ");
INSERT INTO yuj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisaso lotu nap tokwae mek yakria koumteouráp aropan kar yénkrá farákápria maok, tékén arakrá sér, “Yiráp nɨnɨk te yumo onan wae méria, tá onomp némp kareran kor, wae mér námpria nape? Aeno ono te onokump nɨnɨk fek korop mono. Onomp Naropwaro onan sámp-kérép nánko maok, ono ék namp, maomp nɨnɨk te kare karan maok, yumo man te mér mo napon. ");
INSERT INTO yuj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ono man te wae mér nampon. Am te apae riteanápe, ono manénkɨr mént yakampan, mao onan sámp-kérép nánko ék nampon.” ");
INSERT INTO yuj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aerámpantá maok, arop ankwap fárákap am kar wawia man fákapea pap mwariakapan maok, mao sumpwi naenámp yae te oukoumwan sɨk námpantá maok, man sámp mo, pwarariapon. ");
INSERT INTO yuj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aeno kápae kare koumteouráp arop man mér napao am mér monap aropan sérrá, “Ae te Kraiso mámá arop térenámp man kwe-pwar naenámp nɨnɨk rapie?” ");
INSERT INTO yuj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisi ankwap fárákapao wawapo maok, arop fákárerao ‘Jisas te nkwak mak námp’rá kar sérarapo maok, táte am fákáre ntia pris tokwae fákáre, Jisasén fákapenkria lotu nap tokwae taokeyakáp konap plisman fákáre tirá kérép. ");
INSERT INTO yuj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Aeapo maok, Jisaso sérrá, “Ono te yumont tokwae yak mono. Ono warko arákarrá onan sámp-kérépnámp Naropwaronámpok pok nanampon. ");
INSERT INTO yuj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aenanampan maok, ono akwapea yaknamp némp te, yumo am fek tukup mwanap pourou mo napara, yumo onan oupourounk napao maok, nke mono.” ");
INSERT INTO yuj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aeránko maok, Juda fi taokeyakáp konap aropao námoku kok sérarrá, “Mao te maok akwap nánko, nomo man nke mo mwanámpon? Ae te nomp ankwap fákáre Grik fi mek yakáp nap fek akwapeaka kar farákáp naeri kan? ");
INSERT INTO yuj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mao sérrá, ‘Yumo onan nke mwaria oupourounk napao maok, onan nke mono.’ Tá ankwap kar sérrá, ‘Yumo te ono akwapea yaknamp némpouk te tukup mono.’ Makrá séri námp te apae kar fino?” ");
INSERT INTO yuj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Am sákae kánanke mek yakápiap nɨnɨkrá lotunap yae akwapea, ankwap Sarere fek nap te, am yae te tokwae karono. Am yae wae pwar naeria nánko maok, Jisaso fokopeyakrá tékén sérrá, “Arop ankárank éntantá oumpour kor káke námp kwamp te, ononampok koropeaka fánaenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Am te Kwaromp Buk fekamp karao arakrá sénámp, ‘Arop onan mér námp te yiki yak naenámp sánk konámp ént kup tokwae maomp nɨnɨk mek pe yakria kwarákarea akwap naenámpon.’” ");
INSERT INTO yuj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Am sénámp te, ‘Arop námwan mér napan Yiki Kor Spirit sámp mwanapon’rá sérimp. Am ke fek te Jisas oukoumwan yámar mek pok mo námpara, Yiki Kor Spirit oukoumwan ék moimpon. ");
INSERT INTO yuj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Arop ankwap fárákapao Jisas sénámp kar wawia sérrá, “Kare karono, am arop am te Kwaro sámp-kérép naenámpria yépékrá yakápnámp profet támaono.” ");
INSERT INTO yuj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ankwap fárákapao sérrá, “Mao te Krais támaono.” Aerapo, ankwap fárákapao sérrá, “Mono. Am Krais te Galili meknámp korop mono. ");
INSERT INTO yuj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kwaromp Buk fekamp karao sérrá, ‘Krais te Devit yakámp fi meknámp taun Betlehem mek korop naenámpon. Am taun te Devit yakámp némpono.’” ");
INSERT INTO yuj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Am fákárerao Jisasén nɨnɨkria séraria maok, anánk fi pɨr-pwar. ");
INSERT INTO yuj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ankwap fákárerao fákapá pap mwaria napan maok, arop ankwap ankárankampao man sámp mono. ");
INSERT INTO yuj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Am lotu nap taokeyakáp konap soldia fákáre warko arári tukupapo, pris tokwae fákáre ntia Farisi fákárerao man turunkrá, “Yumo te apae riteaka man warámpea korop moi napon?” ");
INSERT INTO yuj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aerapo maok, lotu nap tokwae taokeyakáp konap soldia fákárerao maomp kar pwarokwaprá sérrá, “Wokwaek kar te arop ankwap te am aropamp kar niamp tak moiapon” ");
INSERT INTO yuj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Aerapo maok, Farisi fákárerao am fákáreramp kar pwarokwaprá sérrá, “Mao te yumwan kor poupwekáp reanie? ");
INSERT INTO yuj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ae te yumo nke napo, yino arop taokeyak konámp arop, tá Farisi fákáre, yino te ankwap Jisasén mér námp nie? Mo karono! ");
INSERT INTO yuj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aeno arop fákáre man mérap te am koumteouráp arop te lo épérépria napara, Kwaro man ‘Faokorenk’rá sénaenámpon!” ");
INSERT INTO yuj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus te Farisi fákáre mekampao wokwaek Jisasén akwapea nkea mérimp aropao maok, am fárákapan sérrá, ");
INSERT INTO yuj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nomp lo te ‘Arop kwaporok fákapá papenk’rá sénámpanápe, mono. Nomo te nánkár maomp kar fwapia wawiaka mériaka fákeyakrá maok, man fákap konámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Aeránko maok, maomp kar pwarokwaprá sérrá, “Ae te amo kor Galili mekamp aropaoi kwapon? Amo Kwaromp Buk fek yaknámp kar fwapia nkeaka mérae! ‘Profet ankwap ankárank te Galili meknámp korop mono’rá sénámpon!” ");
INSERT INTO yuj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Arop ponankor wae námokuráp nap mekmwaek tukupapo maok, Jisas mwar Oliv faonkwek pok. ");
INSERT INTO yuj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tá mao koumounek kar warko ékia lotu nap tokwae mek yakánko maok, koumteouráp arop koropea koupoukourapo, Kwaromp kar yénkrá farákáprá tank. ");
INSERT INTO yuj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aenánko poumou nap mekamp yupu ankwap kokoporánko nke nap, lo yénkrá farákáp konap arop ntia Farisi fákárerao am yupu warámp-sankoropea kuk pátea maok, ");
INSERT INTO yuj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","6","Jisasén mokopon nke mwarria poupwekáprá sérrá, “Tisa, má yupu te poumou nap mekampao kokopor nánko, arop ankwap man nke námpon. Moseso kumwimp lo karao sérrá, ‘Taknámp yupuan te yumwi fek arokopá pap kip’rá sénámpon. Aeno amo te mokoprá nɨnɨk rap?” Aerapo maok, Jisaso me woukoupá tankrá kwar mek yae kurépi fek kukumwirá tank. ");
INSERT INTO yuj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Aenánko maok, am fárákap foukouri yakáprá turunkupa wae napantá maok, mao warko fárámpea fokopeyakrá am fárákapan sérrá maok, “Ae te yumo ou mekamp kwatae nɨnɨk mo i konámp aropao manénkɨr am yupuan yumwi ankárank fek yankopano.” ");
INSERT INTO yuj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aerá séria maok, mao warko me woukoup-tankrá kwar mek yae kurépi fek kukumwirá tank. ");
INSERT INTO yuj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aenánko, am yupuan kot mwarianap arop fárákap te am kar wawia maok, wae pwarará ankákárankrá tukup. Méro fárákapaomékɨr tukupapo maok, tá ménki tárápu fárákap wakmwaek tukup. Aenapo, am yupu mwar Jisas tank námp fek fokopeyak. ");
INSERT INTO yuj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Aeria maok, Jisas fokopeyakrá am yupuan turunkrá, “Má arop fárákap te maok tukup nape? Ae te arop ankwapao amwan kot naenámp yak mo nie?” ");
INSERT INTO yuj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tá am yupurao sérrá, “Arop Tokwae, arop ankwap ankárank yak mono.” Jisas kor man sérrá, “Ono kor amwan kot mono. Akwapae. Wakmwaek te warko kwatae nɨnɨki kwapono.” ");
INSERT INTO yuj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisaso lotu nap tokwae mek yakápnap fárákapan sérrá, “Ono te apárokamp arop fákáreramp waenon. Arop onan éntér pap námp te, mao te kɨrɨkɨp mek yárak mono, yiki yak sánk naenámp wae kwapwe fek yárak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Aeránko maok, Farisi fákárerao am kar wawia man sérrá, “Amo te amokuráp karan farákáp napon. Aenapara, má arop fárákap waráp kar te karenoria mér mono.” ");
INSERT INTO yuj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aerapo maok, Jisaso am fákáreramp kar pwarokwaprá sérrá, “Tá kare, ono onokump karan farákáp nampan maok, onomp kar te karenono. Am te apae riteanápe, ono te ono am feknámp fárámpea korop namp némp wae mér, tá ono akwap nanamp némp wae mér nampon. Aeno yumo te onomp némp kare te mér mo nap, tá ono akwap naenamp némp am táman kor yumo te mér mono. ");
INSERT INTO yuj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yumo te apárokamp nɨnɨk fek aropan yurukuprá sérar i konapon. Aeno ono te arop ankwapan yurukup mo i konampon. ");
INSERT INTO yuj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aeno arop ankwapan yurukup naeria te, ono yae-párák kare nɨnɨk fek yurukup i konampon. Am tak namp te onoku mwar mono, onomp Naropwaro onan sámp-kérép nánko ék namp, mao onont tére konámpon. ");
INSERT INTO yuj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aeno yiráp lo te kar araki yak námpon: Arop anánkaopwerao ankár pourouráp kar sénepo maok, am arop yaworamp kar te ‘Kareno’ ria sér i konapon. ");
INSERT INTO yuj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ono onoku te wanonorá farákáprá sénamp, tá onomp Naropwar onan sámp-kérép nánko ék namp, mao kuri onan te wanonorá farákápnámp kar te ankárankamp pourouráp karono.” ");
INSERT INTO yuj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aeránko maok, Farisi fákárerao man turunkrá, “Waráp naropwar te maok yak námpon?” Jisaso am kar pwarokwaprá sérrá, “Yumo onan mér moia te, yumo onomp Naropwarén kor mér mono. Yumo onan méria maok, onomp Naropwarén kor mér mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Lotu nap tokwae mek, mámá kar te Jisaso Kwarén sánk konap mani kák konap aokore wonae fik tankrá koumteouráp aropan kar yénkrá farákápámpon. Aempan maok, arop ankwap man sámp moap te, maomp yae te oukoumwan sɨk námpantá niapon. ");
INSERT INTO yuj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mao warko am fárákapan ankwap kar sérrá, “Ono wae akwap nae rae. Yumo yiráp kwatae nɨnɨk te taki yak nánko, yumo sumpwi mwarea napono. Yumo te ono akwap naenamp némpouk te tukup mwanap pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aerámpantá maok, Juda taokeyakáp konap arop fákárerao sérrá, “Apae riteaka mao sérrá, ‘Yumo te ono akwap naenamp némpouk te tukup mo kare nono’rá sénámpon? Ae te námoku támao náráp pourou sámpea sumpwi naeria ni kane?” ");
INSERT INTO yuj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Aeapo maok, mao am fárákapan sérrá, “Yumo te apárokamp arop fino. Aeno ono te yámar mekampono. Yumo te má apár mekampono, ono te má apár mekamp mono. ");
INSERT INTO yuj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ae namp kwamp, ono yumwan wae sénampon: Yumo sumpwi napo kor, yiráp kwatae nɨnɨk taki yak naenámpon. Táte yumo Ono Taki Yak konamp onan mér moia te, yiráp kwatae nɨnɨk taki yak nánko yumo sumpwi mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Aeránko maok, am fákárerao man turunkrá, “Ae te amo te wanono?” Aerapo maok, Jisaso am fárákapan sérrá, “Ono te wanonorá wokwaek kar yumwan sériamp támaono. ");
INSERT INTO yuj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ono yumo i konap nɨnɨkan kot i konámp aropnámp yurukupia yumwan kot nanamp te, kápae karenono. Aeno mao manénkɨr onan sámp-kérépánko ékamp te, maomp nɨnɨk te ankár kare kar sér i konámpon. Tá ono kor maomp kar ponankor wawi namp, táman saráp apárokamp aropan farákáp konampon.” ");
INSERT INTO yuj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Am fárákap te, náráp yámar mekamp Naropwarén sénámponrá mér moiapon. ");
INSERT INTO yuj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Aenapantá maok, Jisaso am fárákapan arakrá sér, “Nánkár wakmwaek Aropamp Tárápan yaopwae porokopramp fek narek sampoká aráp napo maok, Ono Taki Yak konamp mér mwanapon. Tá ono onokump nɨnɨk fek ankwap ankárank tére mono, onomp Naropwaro onan yénképrá sérimp karan saráp farákáp konamp yumo mér mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Onomp Naropwaro onan sámp-kérépánko ono ék namp, mao te onont yak námpon. Mao te onan nápar yakaeria pwar mo námp, am te apae riteanápe, ono kápae kar por mao warákárnámp nɨnɨkaok tére nanko námpon.” ");
INSERT INTO yuj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kápae kare koumteouráp arop Jisas takrá sénámp kar waria man mériapono. ");
INSERT INTO yuj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Aeria maok, Jisaso námwan mérap Juda fákáreran sérrá, “Yumo ono sénamp kar má sámpea fákapea paokopria te, yumo te onomp arop fi kare yakáp mwanapono. ");
INSERT INTO yuj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tá yumo am kare kar kar mér napo te, am kare kar karao yumwan fwapokwapeanánko, yumo fwap amwar kar yakáp mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tá nopok am fárákapao sérrá, “Yino te Abrahamomp fekamp arop fino. Yino ankwap ankárankamp ke fek arop ankwapamp kwaporok tére konámp arop yakáp moimpon. Aenámp te amo apaeritea yinan ‘Amwar kar yakáp kip’rá sér rape?” ");
INSERT INTO yuj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Aerapo maok, Jisaso am fárákapamp kar pwarokwaprá sérrá, “Ono yumwan kare kar sér rae: Arop ponankor kwatae nɨnɨk fek yakáp nap te, táte am kwatae nɨnɨkamp tére konap aropono. ");
INSERT INTO yuj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kwaporok tére konap arop fárákap te nap mek yaká yak mo i konámpon. Am arop námokuráp tárápao maok, mént ankár am nap mek yaká yak konámpono. ");
INSERT INTO yuj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ae konámpara, Tárápao yumwan fwapokwapia amwar kar pwatenánko te, yumo amwar kar yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yumo Abrahamomp fekamp arop fi yakáp nap te, ono wae mér nampon. Aenampan maok, onomp kar yiráp nɨnɨk mek yak mo námpon. Aenámpara, yumo onan sámp-wouroump mwaria napon. ");
INSERT INTO yuj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ono farákáp namp ankank te, onomp Naropwaro yénkép námpan farákáp nampon. Aeno yumo te yiráp naropwaro séri námpaok napono.” ");
INSERT INTO yuj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Am fárákapao maomp kar pwarokwaprá sérrá, “Yinomp naropwar te Abrahamono.” Aerapo maok, Jisaso nopok am fárákapan sérrá, “Táte kare yumo Abrahamomp toutounápao nap kwamp te, Abrahamo i konámp nɨnɨk niamp taknámp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kápae kare por ono farákápnamp kare kar kar te, ono manénkɨr Kwaro námpan sámpea ni konampan, yumo oukoumwan onan sámp-wouroump mwaria napon. Abraham te take pourouráp nɨnɨk moimpon. ");
INSERT INTO yuj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yumo te yiráp naropwaromp nɨnɨkan saráp sámp napon.” Am fárákapao man sérrá, “Yinomp éntupwar te mwaeaok yárakia yinan sámp mono. Yinomp naropwar ankárank te Kwarono.” ");
INSERT INTO yuj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aerapo maok, Jisaso am fárákapan sérrá, “Táte kare, Kwaro yiráp naropwaranánko te, yumo onan warákár mwanapono. Am te apae riteanápe, ono te Kwarént yakea nampao ék nampon. Ono te onokump nɨnɨk fek ék mono. Kwaro onan sámp-kérép nánko, ono ék nampon. ");
INSERT INTO yuj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ae te apaeriteaka yumo te ono sénamp kar wa mo kare napara napono? Am fi te ará: Yumo onomp karan wa mwanap pourou mono. ");
INSERT INTO yuj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yiráp naropwar te Satanara, yiráp naropwaromp nɨnɨkaok paokop mwaria kárákáre napon. Wokwaek kar te mao arop tirá wour i konámp aropono. Mao te kare kar nɨnɨkaok mo i konámpono. Man te kare kar nɨnɨk yak mono, yankar sérar i konámp nɨnɨkao saráp yak námpon. Am yankar sérar te mao námokurápara, mao támao yankar sérar i konámpono. Am te apae riteanápe, mao te yankar sérar i konámp arop, tá mao támao yankar sérar i konap nɨnɨkamp naropwarono. ");
INSERT INTO yuj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Aenánko yumo te maompara, ono te kare kar karan farákáp konampan maok, yumo onomp kar wawia mér mo napon? ");
INSERT INTO yuj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yumo nke napo, ono kwatae nɨnɨki tenanko te, yumo ankár onomp kwatae nɨnɨk am érik sérenke. Aeno táte ono kare kar kar farákáp nanko, yumo apaerá karenoria mér mo napon? ");
INSERT INTO yuj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kwaromp tárápu te ankár Kwaromp karan saráp wawi konapon. Aeno yumo te Kwaromp tárápu mo napara, yumo Kwaromp kar wa te monoria napon.” ");
INSERT INTO yuj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aeránko maok, Juda fákárerao maomp kar pwarokwaprá man arakrá sér, “Yino amwan ‘Samaria mekamp arop ankárank kwatae-arop woukoupeyak námp’rá sérinámp te waeman kare karono.” ");
INSERT INTO yuj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aerapo maok, Jisaso nopok kar pwarokwaprá sérrá, “Onomp pourouk te kwatae-arop noumpoukoupeyak mono. Ono te onomp Naropwaromp eran sakap nampan maok, yumo onomp e apárok sámp-anámp napon. ");
INSERT INTO yuj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ono te onokump eran sakap mon, nánkár kot wawi konámp Aropao onan yurukupia onomp e sakap naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ono waeman yumwan kare kar sér rae: Arop ankwap onomp karwaok námp te, mao te sumpwi mo kareno!” ");
INSERT INTO yuj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Aeránko maok, Juda fákárerao man sérrá, “Yino oukoumwan te amwan wae mér námpon, waráp pourouk te kwatae-arop woukoupeyak námpon! Abraham te wae sumpwi, tá profet fákáreao kor wae sumpwi tenapan maok, amo sérrá, ‘Arop ankárankamp onomp karwaok yárak námp te, mao te sumpwi mono’rá sénap te, mokopianono? ");
INSERT INTO yuj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ae te amo nomp ounáp Abrahamén kwe-pwar namp rape? Mao wae sumpwi, tá profet fákáreao kor wae faokor tenapon. Waráp nɨnɨk te amo te wanono?” ");
INSERT INTO yuj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisaso nopok sérrá, “Ono onokump eran sakap nanko te, onomp e te kánanke kwataeno. Aeno yumo yiráp Kwarrá sér i konap, mao námoku onomp e sakap námpon. ");
INSERT INTO yuj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Aenámpan maok, yumo te man mér mo napon. Ono maok man mér nampon. Aeno ono sérrá, ‘Ono man mér mo nampono’rá sénanko te, ono kor yumo napnámp kwekár i konamp aropono. Aeno ono wae man méria nampan, ono maomp karwaok akwap nampon. ");
INSERT INTO yuj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yiráp ounáp Abraham mao te ono ék nanamp ke nke naeria warákár karimpon. Takia wae nkeaka yonkwae kárámpámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Aeránko maok, Juda fákárerao man sérrá, “Amo te oukoumwan 50 yopwar yak moi napao, amo yakrá ‘Námo wae Abraham nke namp’rá sér rapie?” ");
INSERT INTO yuj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aerá sénapo maok, Jisaso am fárákapan sérrá, “Ono waeman yumwan kare kar sér rae: Abraham te oukoumwan yak mo fek onomékɨr Ono Taki Yakampon.” ");
INSERT INTO yuj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aeránko maok, am fákárerao yumwi sámprá paokoprá Jisasén yankop mwariakapo maok, Jisaso sánánkar e-poup lotu nap tokwae meknámp akwap. ");
INSERT INTO yuj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas akwapria nke nánko, arop ankárank éntupwaro sámpámp ke feknámpia yi aompi yak námp yak. ");
INSERT INTO yuj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aenko maok, Jisaso éréképá yárak i konámp arop fákárerao man turunkrá, “Tisa, wa mokop kwatae nɨnɨkianánko, éntupwaro am yi aompi yaknámp táráp sámp námpon? Am arop námoku kwatae nɨnɨki námp ni, tá éntupwar naropwaro kwatae nɨnɨk nep nie?” ");
INSERT INTO yuj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mak rapo maok, Jisaso am fárákapamp kar pwarokwaprá arakrá sér, “Am aropao námoku kwatae nɨnɨk námp fek mo, maomp éntupwar naropwaro kor kwatae nɨnɨki nep fekamp mono. Am ankank maomp pourouk koropámp te Kwaro mámá aropamp pourou fwapokwapianánko, maomp kárákáre érik korop nánko, koumteouráp arop fárákap nke mwanapria námpon. ");
INSERT INTO yuj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Oukoumwan te wakor wae yak námp fek ara, onan sámp-kérépánko ékamp Kwaromp tére mwanámpon. Kumur nánko te, arop tére mo mwarea napono. ");
INSERT INTO yuj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ono oukoumwan má apár mek yak namp ke fek te, ono mámá apár mekamp aropamp wae yak nampono.” ");
INSERT INTO yuj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mao makrá sériaka pwarará maok, táte kwar mek atopia arákaria maok, am kwar yokwapea am aropamp yi mek pap. ");
INSERT INTO yuj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Aeria maok, mao man sérrá, “Amo akwapeaka ént aokore Siloam mek waráp yimetáp yárárae.” (Am ént aokore ‘Siloam’rá sénap te, am te arakono: ‘Sámp-kérépánko akwap’rá sér i konapono.) Aenánko maok, am yi aompi yaknámp arop akwapea yimetáp yárária, yi wae fwap nkeria arákarrá koropámpon. ");
INSERT INTO yuj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aenko maomp némpoukamp arop, tá man wokwaek ‘Mani sápenk’ ria sérrá tank nánko nkeap aropao kor, am fárákapao sérrá, “Ae te nko arop te tankrá aropan ‘Mani sápenk’ ri konámp arop támaoi kane.” ");
INSERT INTO yuj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aerapo maok, ankwap fárákapao sérrá, “Mono. Arop ankwapao mao niamp námpon.” Aerapo maok, am aropao námoku sérrá, “Máte ono támaono.” ");
INSERT INTO yuj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aeránko maok, am fárákapao man sérrá, “Ae te mokopia waráp yi fwap námpon?” ");
INSERT INTO yuj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aerapo mao am fárákapan sérrá, “‘Jisas’ ri konap aropao kwar ént mek ouroukoupea onomp yi mek forokwapea maok, onan sérrá, ‘Amo akwapea ént Siloam aokore mek yi yárárae.’ Aeránko maok, ono akwapea am mek yi yárária nanko, wae fwap nánko, ono nke nampon.” ");
INSERT INTO yuj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aeránko maok, am fárákapao man turunkrá, “Ae te am arop te maok yak námpon?” Aerapo maok, mao sérrá, “Ono mér mono.” ");
INSERT INTO yuj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Arop fárákapao am yi aompi yakámp arop warámpea Farisi fákáreaonapok tukup. ");
INSERT INTO yuj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Am te Sabat yae fek Jisaso am kwar ouroukoupea maomp yi fɨrékarea pap tenánko niapon. ");
INSERT INTO yuj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farisi fákáreaonapok warámpea tukupapo maok, am fárákapao man warko turunkrá, “Waráp yi te warko mokopia fwapi námpon?” Aerapo maok, mao am fárákapan sérrá, “Mao kwar ouroukoupea onomp yi mek forokwapeanánko, ono yi ént mek yárária maok, fwap nke nampon.” ");
INSERT INTO yuj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Aeránko maok, Farisi ankwap fákárerao sérrá, “Yino te wae mér, am arop te Sabat loaok mo námpara, Kwaro man sámp-kérép moimpon.” Aerapo maok, Farisi ankwap fárákapao sérrá, “Ae te kwatae nɨnɨkráp arop te mokopiaka nkwakwe make kárákáre takrá yoro naenámpon?” Aerá séria maok, anánk fi pɨrékarapono. ");
INSERT INTO yuj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Aeria maok, Farisi fákárerao warko am yi aompi yakámp aropan turunkrá, “Waráp yi fwapi papnámp arop te amo mokope aroponorá nɨnɨk rap?” Aerapo maok, am aropao sérrá, “Mao te profet ankwapono.” ");
INSERT INTO yuj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tá kare, wokwaek am arop te yi aompi yakámpan maok, oukoumwan te wae yi fwap fɨrɨkɨr námpon. Aenámpan maok, Juda taokeyakáp konap arop, am kar te karenorá mér te monoria nap kwamp maok, am yi fwap nkenámp aropamp éntupwar naropwarén koropenkria wumwi. ");
INSERT INTO yuj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Maomp éntupwar naropwar korop nepo, man arakrá turunk, “Má arop te yiráp táráp nie? Yumo sérrá, ‘Éntupwaro sámpámp fek yi aompi yakámpono’rá sénap nie? Takanánko te mokopiaka warko fwap nke námpon?” ");
INSERT INTO yuj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aerapo maok, éntupwar naropwaro sérrá, “Yino te wae mér nempono, am te yinomp tárápono. Wokwaek éntupwaro sámpámp feknámpia yi aompi yaká yak námp te, yino wae mér nempon. ");
INSERT INTO yuj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Aeno oukoumwan te maomp yi mokopia fwapianrá mér mono. Tá wa maomp yi fɨrékarea pap námp am táman kor yino mér mono. Wae tékép námpara, námoku fwap sénaeria námpono. Man turunkenke.” ");
INSERT INTO yuj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Am te wokwaek kar, Juda taokeyakáp konap arop fákárerao sérrá, “Arop ankárankao ‘Jisas te Kraisono’rá sénánko te man te, lotu nap mek korop kwaponoria yérépe mwanámpon.” Aerá sér i konapantá, éntupwar naropwar am táman apápria maok, ‘Wae tékép námpara, yumoku man turunkenk’rá sénepon. ");
INSERT INTO yuj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aerepo maok, warko am yi aompi yakámp arop táman am fárákapao man koropaerá wumwia sérrá, “Waráp yi fwap nánko te, Kwaro nke námp fek man saráp kare kar warákárrá ‘Aesio’rá sérampo. Yino wae mérono, am arop te kwatae nɨnɨkráp aropono.” ");
INSERT INTO yuj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Aerapo maok, mao kar pwarokwaprá arakrá sér, “Mao te kwatae nɨnɨkráp arop ni fwap nie? Ono kor mér mono. Aeno ono mérnamp ankank te, wokwaek onomp yi aompi yakámpan, oukoumwan onomp yi wae fwap kwapwe kare nánko nke nampon.” ");
INSERT INTO yuj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aeránko maok, am fárákapao man sérrá, “Mao te amwan apae námpon? Waráp yi te mokopia fɨrékarea pap námpon?” ");
INSERT INTO yuj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aerapo maok, mao am fárákapamp kar pwarokwaprá sérrá, “Ono waeman yumwan sénampan maok, yumo am kar wa te monoria napon. Apaeritea yumo kápae kare por turunk rap? Ae te yumo kor maomp wokwaek paokop mwaria nape?” ");
INSERT INTO yuj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Aeránko maok, am Farisi fákáre man wouroumpriaka sérrá, “Amoku maok am arop kwataeramp wakmwaek yáraknap aropono. Yino te Mosesomp wakmwaek paokop i konámpono. ");
INSERT INTO yuj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yino te Kwaro Mosesén sérinámp karan saráp mérámpono. Aeno yino te am arop te maoknámp koropreanrá mér mono.” ");
INSERT INTO yuj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Aerapo maok, am aropao am fárákapamp kar pwarokwaprá sérrá, “Am onomp yi fwapi papnámp aropan yumo sérrá, ‘Yino mér mo námp te maoknámp koropean’rá sénapo, ono korokop tokwae nampono. ");
INSERT INTO yuj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nomo te wae mér, Kwar te kwatae nɨnɨkráp aropamp kar te wa mo i konámpono. Aeno arop ankárank Kwarén loturiaka Kwaromp nɨnɨkaok akwapnámp aropan maok, Kwaro maomp karan wawi konámpon. ");
INSERT INTO yuj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wokwaek karia koropea oukoumwan námp te, arop ankárank éntupwaro sámpámp fek yi aompiyakámp arop maomp yi fwapi papámp kar te yak mono. ");
INSERT INTO yuj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Aeno Kwaro am arop sámp-kérép moi yakánko te, mao te am takeniamp tére mono.” ");
INSERT INTO yuj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Aeránko maok, am fárákapao maomp kar pwarokwaprá sérrá, “Waráp éntupwaro amwan sámpnámp ke feknámpia koropea amo oukoumwan nap te kwatae nɨnɨkráp aropono. Amo yinan yénkrá farákáp nae rape?” Am fárákapao makrá séria maok, man lotu nap mekamp yérépea ek sámp-kérép. ");
INSERT INTO yuj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisaso am aropan arop fárákapao yérépea sámp-kérépnap kar wawia maok, mao akwapea oupourounkia nke. Jisaso man nkea maok, man arakrá sér, “Amo te Aropamp Tárápan mér nap ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Aeránko maok, am aropao maomp kar pwarokwaprá sérrá, “Arop Tokwae, am Aropamp Táráp te wanono? Amo onan sénapo te, ono fwap man mér nanampon.” ");
INSERT INTO yuj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Aeránko maok Jisaso man sérrá, “Amo am arop te wae nke napono. Am arop te oukoumwan má amwan kar sénámpono.” ");
INSERT INTO yuj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Aeránko maok, am aropao man sérrá, “Tokwae Kar e! Ono wae mér nampon.” Makrá séria maok, Jisasén kwaráp torokomprá man lotuimpon. ");
INSERT INTO yuj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aenko maok, Jisaso sérrá, “Ono ék namp te apárokamp arop fárákapaonap nɨnɨkan yurukup naeria ék nampon. Aenampara, arop fárákap yi aompi yakáp nap te fwap nke mwanapono. Tá arop fárákap náráp yi te fwap nke námprá nɨnɨk nap te, yi aompi yakáp mwarea napono.” ");
INSERT INTO yuj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Aeránko maok, Farisi ankwap fákáre wonae fik am fek yakápia maok, am kar wawia man sérrá, “Ae te yinan kor yinomp yi te aompi yaknámprá sénae rape?” ");
INSERT INTO yuj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Aerapo maok, Jisaso am fárákapan sérrá, “Yumo yumokuráp yi aompi yaknámp mér nap te, arop yumwan mokopia kot mwanapanáp, fwapono. Aeno yumo sérrá, ‘Yinomp yi te fwap yae-párák yakáp námpono’rá sénap te, yumo te oukoumwan kwatae nɨnɨk fek yakáp napon.” ");
INSERT INTO yuj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisaso warko ankwap kar sérrá, “Ono waeman yumwan kare kar sér rae: Arop sipsipamp yár ménki porok yoump moria, yár ankwap feknámp oupukarrá pɨknámp arop te, am te oukun arop, tá ankwapamp ankank sámp naerianámp aropono. ");
INSERT INTO yuj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Aeno arop ménki porok yoump námp te, táte sipsip taokeyak konámp arop námoku támaono. ");
INSERT INTO yuj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Aenko maok, ménki kɨkɨp konámp aropao, am arop mankanoria ménki kɨk-pwaránko maok, am arop mankria námokuráp sipsipamp e ankákárankrá nánáránko, maomp kar wawia ouroumpea mank napo éréképea ek akwap konámpon. ");
INSERT INTO yuj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mao náráp sipsip ponankor éréképea ek akwapea maok, mekia akwap nánko, maomp sipsip ponankor maomp kar wuri wawia maomp wakmwaek éntér kákeaka tukup konapon. ");
INSERT INTO yuj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Am sipsip fákáre te arop ankwapamp wakmwaek te tukup mo, pɨrɨkɨmpá tukup i konapon. Am te apaerianápe, mao wa nap te, ankwap aropamp kar námpantá napono.” ");
INSERT INTO yuj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisaso am fárákapan mámá wounáp kar farákáp námpan maok, am fárákapao kar fi fwapia mér moiapon. ");
INSERT INTO yuj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aeria maok, Jisaso warko sérrá, “Ono yumwan waeman kare kar sér rae: Ono támao ono sipsip akwap korop naenámp ménkinono. ");
INSERT INTO yuj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Sipsip taokeyak konap arop ponankor manénkɨr yakápap te, am arop fárákap te oukunrá, ankank ti konap aropono. Ae konapara, sipsip te am fárákapamp kar wa moiapon. ");
INSERT INTO yuj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ono támao ono ménkino. Arop ankárank ononampok koropeaka am yár mek yoump námp te, Kwaro man warko warámp naenámpon. Aeanánko mao te mek youmpea warko ek akwapria fɨr oupourounkrá fánaenámpono. ");
INSERT INTO yuj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Oukun arop te ankwap ankankan nɨkia korop mono. Sipsip oukunria, yénképrá kákria sámpá yampourou naeria korop konámpon. Aeno ono te am fárákap fwap yiki yak sámpea napo, yiki yak am fárákapan top koupouri yak naenámpria korop nampono. ");
INSERT INTO yuj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ono támao ono sipsip kwapwe kare taokeyak konamp aropono. Sipsip kwapwe kare taokeyak konámp arop te mao námoku am sipsip fárákap yaewour naeria náráp pourou sámp konámpono. ");
INSERT INTO yuj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Aeno maniantá saráp térerá yárak i konámp arop te sipsip taokeyak konámp arop kare mo, tá sipsipamp naropwar mo ara, nke nánko, yao pwae mekamp as korop nánko te, am sipsip párakoprá farákapá akwap konámpono. Aenánko, yao pwae mekamp asao ankwapmwaek yourounkwe nánko, ankwapmwaek pɨrɨkɨmp konapono. ");
INSERT INTO yuj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Am taknámp arop te sipsipantá nɨnɨk mono, maniantá saráp tére námpono. ");
INSERT INTO yuj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ono támao sipsip kwapwe kare taokeyak konamp aropono. Onomp Naropwaro onan wae mér, ono kor onomp Naropwarén wae mérnamp taknámp, onomp sipsipao kor onan wae mér, ono kor onomp sipsip wae mér nampono. Aenampara, onomp sipsipan yaewourria, fwap sumpwi nanampon. ");
INSERT INTO yuj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Onomp sipsip ankwap fákáreao kor yakáp napon. Am fákáre te má yár mekamp mo ara, ankwap fek yakáp napon. Ono am fákárean kor éréképá koropea nanko, am fárákapao kor onomp kar wa mwanapon. Aeria maok, ankárankamp fi sipsip mwar yakáp napo maok, ankárankamp sipsip taokeyak konámp arop yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ono am sipsipantá onomp pourou sámpea, sumpwia warko fárámp nanampara, onomp Naropwar onan warákár kare námpono. ");
INSERT INTO yuj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Arop ankárankao onan kwaporok sámp-wouroump mono, onokump nɨnɨk fek onoku fwap sumpwi nanampon. Ono fwap onomp pourou sámpea sumpwi nanampon. Tá ono fwap warko yiki yak sámpea fárámp nanamp pwi nampono. Onomp Naropwaro onan ‘Tak nanapono’rá séri námpono.” ");
INSERT INTO yuj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aeránko, Juda fákárerao am kar wawia maok, warko anánk fi pɨr-pwar. ");
INSERT INTO yuj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Takia maok, kápae kare aropao sérrá, “Mao te kwatae-arop noumpoukoupea épépérép námpono. Yumo apaerá man woupwi pátea maomp kar wa rape?” ");
INSERT INTO yuj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aerapo maok, táte nopok ankwap fárákapao sérrá, “Má kar máte arop kwatae-arop noumpoukoupá yaknámp aropamp kar mono. Ae te kwatae-arop woukoupá yak námp te, fwap arop yi aompi yak nánko, fɨrékarea pap naenámp nie?” ");
INSERT INTO yuj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalem mek, komontnámp ke fek lotu nap tokwae ménki kɨk-pwarariap yae nɨnɨkria warákárrá lotu i konap yae koropámp. ");
INSERT INTO yuj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Am ke fek maok, Jisaso lotu nap tokwae mek Solomonomp naepik mwaek yárakrá akwap. ");
INSERT INTO yuj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Aenánko maok, Juda fákárerao mankea man kuk-sɨrarrá, am fárákapao man sérrá, “Amo Kraisao nap kwamp te, mae ke fek amo te wa karenorá érik sénanapon? Yinomp nɨnɨk épérép námp tane!” ");
INSERT INTO yuj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aerapo, Jisaso am fárákapamp kar pwarokwaprá sérrá, “Ono waeman yumwan séri nampan yumo mér mo napon. Onomp Naropwaromp kárákáre fekamp ponankor tére tére namp te, am tére támao, ono te wa karenorá yumwan yénkép námpon. ");
INSERT INTO yuj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Aeno yumo te onomp sipsip fi mo napara, yumo onan mér mo napon. ");
INSERT INTO yuj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Onomp sipsip fákáre te ono wae mér nanko, am fárákap onomp kar wuri wawia, onomp wakmwaek korop konapon. ");
INSERT INTO yuj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aenapo maok, ono am fárákapan yiki yaká yakáp mwanap nénk nanko, mao te moyakáp mo kareno. Tá arop ankwap te onomp yaekamp pouroukoup mono. ");
INSERT INTO yuj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Onomp Naropwaro am fárákapan onan sáp námp te, námoku ankárankamp támao tokwae karia ankank ponankoran kor poukeyak námpara, arop ankwap te maomp yaekamp pouroukoup mono. ");
INSERT INTO yuj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Onomp Naropwar te, yino ankárankamp támaono.” ");
INSERT INTO yuj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Aeránko maok, Juda fákáre am kar wawia yumwi sámprá warko man yankop mwariakapo maok, ");
INSERT INTO yuj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisaso am fárákapan sérrá, “Ono yumwan manénkɨr onomp Naropwaromp kápae kare tére kwapwe wae yénkép namp te, yumo apae téreran nɨnɨk nap kwamp onan yumwian yankop mwaria nape?” ");
INSERT INTO yuj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aeránko maok, Juda fákárerao man kar pwarokwaprá sérrá, “Yino te tére kwapweran nɨnɨkria amwan yumwi fek yankop mono. Amo arop kareao maok, Kwarén wouroump sérria ‘Ono te Kwar’rá sénap fekeano.” ");
INSERT INTO yuj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Makrá sérapo maok, Jisaso am kar pwarokwaprá am fárákapan sérrá, “Yumokuráp lo karan kumwia nap te Kwaromp kar araki yak námpon: ‘Ono sérrá, “Yumo te kwar fákárenono.” ’ ");
INSERT INTO yuj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kwaro am arop fárákapan kar farákápria, ‘Am fárákap te “Kwar”rá sérimpon.’ Nomo te wae mér, Kwaromp Buk fekamp kar te ankár taki yak konámpono. ");
INSERT INTO yuj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aeno onomp Naropwaro onan nánapia sámp-kérép nánko, ono má apár mek ék nampara, ono sérrá, ‘Ono te Kwaromp Tárápono’rá sénanko, yumo onan apaerá ‘Kwarén wouroump nap’rá sénapon? ");
INSERT INTO yuj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Aeno táte ono onomp Naropwaromp tére mo nanko, yumo onomp kar karenorá mér mo mwanapono. ");
INSERT INTO yuj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Aeno ono te maomp tére nampon. Táte yumo onan, amo te karenorá mo nap kwamp te, yumo ono tére namp máman mér kipo. Aeria maok, onomp Naropwaro onont yak nánko, ono onomp Naropwarént yak namp fwapi nɨnɨkia mér mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Am fárákapao warko man fákap mwariakapo maok, mao am ankwap mwaeknámp warákarrá akwapámpon. ");
INSERT INTO yuj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisaso warko arákarrá akwapea ént Jordan tápampá akwap. Akwapea manénkɨr Jono arop ént mek énérrá kákámp fek yak. ");
INSERT INTO yuj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Aenko maok, kápae kare koumteouráp arop maonámpok koropea maok, sérarrá, “Kareno. Jon te nkwakwe make ankank kárákáre yoro moimpan maok, mámá aropao naenámp karan mao farákápámp kar te ponankor kare karono.” ");
INSERT INTO yuj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aeria maok, am fek táman kápae kare arop man méria, karenoriapono. ");
INSERT INTO yuj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Arop ankárank touwe sámpámp, mao te Betani mekamp Lasarus. Am Betani te Maria ntia Marta aenenkamp némpono. ");
INSERT INTO yuj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Am yupu Maria te Tokwae Karamp puk wel kwarákárria maok, mao námokuráp me pwae fek pukamp wel féki torokorimpon. Am touwe sámpnámp arop Lasarus te am aenenkamp ménkinono. ");
INSERT INTO yuj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Aenko maok, antáp yaworao Jisasnámpok kar sámp-kérépria arakrá sér, “Tokwae Kar e, amo man nouroupria warákár konap arop te touweane.” ");
INSERT INTO yuj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisaso am wawia maok, sérrá, “Am touwe te arop sumpwi naenámp touwe mono. Am te koumteouráp arop Kwaromp kárákáre nkea man warákárrá man e tokwae sánk mwanapono. Tá am fek táman Kwaromp Tárápao kor e tokwae sámp naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas te Marta, maomp nánae Maria, tá ménkináp Lasarus am anánkwapoan te warákár konámpon. ");
INSERT INTO yuj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Am Lasarus touwenámp kar koropánko maok, wawitea am yaknámp némpouk anánki yak. ");
INSERT INTO yuj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Aea maok, wakmwaek námoku éréképá yárak i konámp arop fákáreran sérrá, “Nomo warko Judia mek tukup mwaro.” ");
INSERT INTO yuj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Aeránko maok, am éréképá yárak i konámp arop fákárerao man sérrá, “Tisa, oukoumwan kar amwan Juda fákárerao yumwi fek arokopea sumpwi pap mwaria wae nap te, amo warko am fek akwap nae rapie?” ");
INSERT INTO yuj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisaso maomp kar pwarokwaprá wounáp kar sérrá, “Ae te ankárankamp yae fek yámar éntér-sámpramp ke akwap mo i konámp nie? Aeno arop yámar wae kare fek yárak námp te, sɨkɨrɨp mo i konámpono. Am te apae riteanápe mao te waeman apárok yokorámp wae nke námpono. ");
INSERT INTO yuj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Aeno arop kumuruk yárak námp te, mao nke naenámp wae yokor mo námpara, sɨkɨrɨp konámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Makrá séria maok, wakmwaek am fárákapan sérrá, “Nomp nouroup Lasarus amp námpono. Aenámpan maok, ono akwapea kéménkia fárámpá pap nanampono.” ");
INSERT INTO yuj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aeránko maok, am éréképea yárakámp arop fákáre támao am kar wawia maok, sérrá, “Tokwae Kar e! Mao amp nánko, maomp touwe warko fwap naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisaso sérámp kar te Lasarus sumpwimpan séránko maok, am fárákap te Lasarus párák amp námpan sénámpwe nɨnɨkiapono. ");
INSERT INTO yuj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Aeapo maok, warko Jisaso érik sérrá, “Lasarus te wae sumpwi námpono. ");
INSERT INTO yuj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Aenámpan maok, ono am ke fek méntér yak moi namp táman yumwan nɨnɨkria warákár nampono. Aenampara, yumo am fek táman Kwarén mér mwanapono. Oukoumwan nomo maonámpok tukup mwaro.” ");
INSERT INTO yuj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jisas takrá séria pwar nánko, Tomas maomp ankwap e Tam Feae, mao Jisasén paokop i konap ankwap fákáreran sérrá, “Tak mwaro. Nomo ponankor tukupea mént sumpwi mwaro!” ");
INSERT INTO yuj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisas ntia mao éréképá yárak i konámp arop fárákap tukupea némp Betani wonae fikria maok, mao wa nánko, Lasarus te wae péri me mek yiawori yak námpono. ");
INSERT INTO yuj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani te Jerusalem mek wonae fik kar 3 kilomita fek yak námpon. ");
INSERT INTO yuj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Aenámpara, Juda mekamp kápae kare koumteouráp arop Marta ntiaka Maria aenenkamp ménkináp sumpwi námpantá, am aenenkan yonkwae porokwe sánk mwaria koropea méntér yakáp. ");
INSERT INTO yuj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aenapo maok, Maria nap mek tankánko maok, ");
INSERT INTO yuj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta ‘Jisas koropán’rá sénap kar wawia akwapea mwaeaok kɨkɨpia maok, Jisasén sérrá, “Tokwae Kar e, amo mapek yakaporia te, onomp ménki te sumpwi mono.” ");
INSERT INTO yuj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Aerá séria maok arakrá sér, “Ono wae mér nampon, amo Kwarén ‘Ankank sápae’ ria sénapo te, amwan fwap sánk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Aeránko maok, Jisaso man sérrá, “Waráp ménki te fwap warko fárámprá yiki yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tá Marta man sérrá, “Ono wae mér nampon, nánkár pwarnámp yae fek, sumpwinap arop ponankor warko ferámp nap fek fárámp naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Aeránko Jisaso man sérrá, “Warko fárámp konap te onoku támao, tá yiki yak te onoku támaono. Arop onan mér námp sumpwi námpao kor, mao oukoumwan yiki yak naerámpon. ");
INSERT INTO yuj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tá arop ponankor yiki yakápria onan mér nap fárákap te sumpwi napao kor, fwap yiki yakáp mwanapon. Amo te mámá wae mér rape mo nie?” ");
INSERT INTO yuj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aeránko maok, tá Marta Jisasén sérrá, “Tokwae Kar, yeno! Ono wae mér nampon, amo te Kwaromp Tárápono. Amo te am arop Kwaro apárok sámp-kérép nánko, náráp koumteouráp arop warko érékép nanap rimp támaono.” ");
INSERT INTO yuj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta aerá séria pwarará, youmpea nánae Marianámpok akwapea warámpá youmpea aop mwaek yakria maok, sánánkar sérrá, “Tisa koropea yakria amwan koropaenáne.” ");
INSERT INTO yuj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mak ránko maok, Maria am kar wawia koupour fárámprá Jisasén akwapá nke. ");
INSERT INTO yuj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Jisas te oukoumwan némpouk akwap mo, máte akwapea Marta man kɨkɨpimp fek yak.) ");
INSERT INTO yuj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Juda fákárerao Marian koukarrá yonkwae touwerá nap mek am mek yakáp napao nkeapo, Maria am feknámp fárámprá ek oukur akwapánko maok, am fárákapao nɨnɨkrá, máte akwapea péri me fek ém naeria akwapri kanria éntér kákia énénki tukup. ");
INSERT INTO yuj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria akwapea Jisaso yak námp fekria maok, man nkea maomp puk wonae fik kwaráp torokompria man sérrá, “Tokwae Kar e! Amo mapek yakaporia te, onomp ménki sumpwi mono.” ");
INSERT INTO yuj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maria ém nánko maok, tá mént koropap Juda fákárerao kor éménk. Aenapo maok, Jisas man nkeria maok, mao kuri yonkwae touwea waeria maok, ém naenámp niamp. ");
INSERT INTO yuj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Aeria maok turunkrá, “Yumo man te maok pap napon?” Aeránko maok, am fárákapao kor man sérrá, “Tokwae Kar, amo koropea nkeae!” ");
INSERT INTO yuj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Aerapo maok, Jisaso kor ém. ");
INSERT INTO yuj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Aenánko, Juda fákárerao nkea sérrá, “Yumo nkenke! Mao te am aropan nouroup kar i konámp kwamp námpon.” ");
INSERT INTO yuj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aenánko maok, arop ankwap fárákapao sérrá, “Má arop te arop yi aompi yak námpan kor fɨrékarea pap konámp te, mámá aropan kor apaeritea yaewour mo nánko, sumpwi námpon?” ");
INSERT INTO yuj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisaso warko yonkwae touwea waeria maok, akwapea am papnap péri me táp fek. Am papnap me te manénkɨr péri me yokoropeaka maok, péri ankwap kárakére sámpea top kor fek nánkáráp tenapono. ");
INSERT INTO yuj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ae tenapo maok, Jisaso sérrá, “Yumo am péri kárakére támá far-farrá tukupenke!” Aeránko maok, am sumpwinámp aropamp antápnáp Marta man sérrá, “Tokwae Kar e! Mao am mek tank námp te wae yiawori yak námpara, wae mákáre kwatae korop naeria námpono.” ");
INSERT INTO yuj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Aeránko maok, Jisaso man sérrá, “Ono wae manénkɨr amwan sériampon, ‘Amo méria te, Kwaromp kárákáre fwap nke nanapon!’” ");
INSERT INTO yuj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aeránko maok, am fárákapao péri kárakére keakapapo maok, Jisaso narek tokoreyakrá sérrá, “Ayao, amo ono sénamp kar wawi napantá amwan ‘Aesio’rá sér rae. ");
INSERT INTO yuj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ono te wae mér nampon, amo ono sénamp kar ankár wa saráp yak konapon. Aeno ono nɨnɨk namp te, mámá yakápnap koumteouráp arop amo onan sámp-kérép napo ék namp mér mwanapria, mámá kar sér rae.” ");
INSERT INTO yuj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Makrá séria pwarará maok, tékén kar wumwia sérrá, “Lasarus, amo ek oukur-koropae!” ");
INSERT INTO yuj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Makránko maok, am sumpwinámp arop fárámpeaka érik mankánko maok, maomp pu, yae, tá yimetápok waempyam fek woukoup tenap yak nánko, Jisaso am fárákapan sérrá, “Yumo am waempyam aokor-aokoria pwarapo akwapano.” ");
INSERT INTO yuj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kápae kare Juda fákáre koropea Mariant koukarrá yonkwae touwenap arop fárákap Jisaso am ankank taknámp nkeaka man mériapono. ");
INSERT INTO yuj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aenapan maok, ankwap fárákap te tukupea Farisi fákáreaonapokria am Jisasoinámp ankank táman farákáp. ");
INSERT INTO yuj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aenapo maok, pris tokwae fákáre ntia Farisi fákáre Kaunsil fákáreran koropenkria wumwi. Wae koropea koupoukour napo maok, am fárákapan sérrá, “Am arop te kápae kare nkwakwe make ankank yoro námp te, mokop mwanámpon? ");
INSERT INTO yuj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Táte nomo man kwaporok takanoria pwate nánko te, arop ponankor man mér mwarea napon. Tá Rom mekamp arop fákáre koropea nomp lotu nap tokwae souroumpouriaka nomp arop fárákapan kor méntérantáno.” ");
INSERT INTO yuj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Aerapo maok, arop ankárank Kaiafas mao te pris taokeyak konámp arop am yopwar fek yakria maok, mao am fárákapan sérrá, “Yiráp nɨnɨk te épépérép kare nape. ");
INSERT INTO yuj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yumo te ankárankamp ankank yumwan fwap yaewour naenámp te mér mo napon. Arop ankárankao ponankor koumteouráp aropantá sɨrarrá sumpwi naenámp te kwapwe kareno. Takria nomp arop fi ponankor surumpwiantáno.” ");
INSERT INTO yuj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiafas te námokuráp nɨnɨk mekamp karan sér mono. Mao te am yopwar fek pris éréképá yak konámp aropara, Jisas Juda fian yaewourrá sumpwi naenámpan profet kar fek sénámpon. ");
INSERT INTO yuj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mao sumpwi námp te Juda firan saráp yaewour mono, am sumpwi námp te Kwaromp tárápu ponankor apár-apár yakáp nap koupoukareaka ankárankamp fi yakáp mwanapria námpon. ");
INSERT INTO yuj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aeria maok, am yae feknámpia man sámp-wouroump mwanap mwae oupourounkrá kar sérarrá tukup. ");
INSERT INTO yuj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Aeapo maok, Jisaso warko Juda fákáre ou mek érik akwap mono. Am fek pwarará námoku éréképá yárak i konámp arop fákáre éréképea arop yak mo apár wonae fikamp taun ankárank Efraim mek énénki tukupea am fek yakápiapon. ");
INSERT INTO yuj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juda firamp Pasova Fári konap Yae wae fae nánko maok, kápae kare némpouk mwaekamp arop Jerusalem mek Kwaro nke námp fek námokuráp nɨnɨk fwapokwap mwaria tukup. ");
INSERT INTO yuj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Aeria maok, Jisas te maok yakánrá oupourounk. Am fárákap lotu nap tokwae mek yinkea yakáprá námoku kok sérarrá maok, “Yumo te mokoprá nɨnɨk rap? Mao te koropea Pasova Yae Tokwae te nkea ni moi kane?” ");
INSERT INTO yuj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aerapo maok, pris tokwae fákáre ntiaka Farisi fákárerao koumteouráp aropan sérrá, ‘Arop ankárankao Jisas te maok yakánrá mér námp kwamp te, yinan sénapo, man fákap mwanámp’rá séri napono. ");
INSERT INTO yuj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasova Fári konap Yae oukoumwan tokwampok yae tankánko maok, am ke fek Jisaso apár me mekamp kéménkia papámp arop Lasarusomp némp Betani mek akwap. ");
INSERT INTO yuj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Aenko maok, am némpouk am fek Jisasén ‘Aesio’rá sér mwaria, maompor fɨr nánap. Marta fɨr yorokwae nánko maok, Lasarus Jisasént fár mwanap aropént tank. ");
INSERT INTO yuj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Aeapo maok, Maria sanda mani tokwae fekamp, hap kilo botol sankoropea maok, Jisasomp puk forokwapea pwarará maok, námokuráp me pwae fek féki torokorrá yakánko maok, am nap mek sanda nánákáre kwapwe top-pwarámpá yak. ");
INSERT INTO yuj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Aenko mént paokopiap arop ankárank Judas Iskariot am arop te nánkár wakmwaek Jisasén arop outɨri naenamp mao sérrá, ");
INSERT INTO yuj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Am sanda te nomo aropan sánkria am fekamp 300 yae fek térea sámp konámp niamp 300 mani silva sámpeaka, ankank monap aropan nénk mwar mpup!” ");
INSERT INTO yuj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mao te ankank monámp aropan nɨnɨkrá sér mono, mao maniráp yam taokeyakria mani oukun i konámp aropao námpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aeránko maok Jisaso sérrá, “Am yupu te numwar takano. Mao am taki námp te, nɨki-samp yakrá akwapea, ono sumpwi nanko, onan apár me mek papnap yae fek naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ankank moráp arop fárákap te yumont yakápi yakáp mwanapon. Aeno ono te yumont yaká yak nanamp mono.” ");
INSERT INTO yuj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kápae kare Juda fákárerao wa napo, Jisas Betani mek yakánko maok, am arop fárákap te maonámpok korop. Am fárákap te Jisasén saráp koropea nke mono. Manénkɨr Jisaso Lasarusén apár me mekamp kéménkia papámpan mér napara, Lasarusén kor nke mwaria korop napon. ");
INSERT INTO yuj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Aeriaka, kápae kare Juda fákáre pris tokwae fákáreran pwarará tukuprá Lasarusén nkeaka Jisasén mérapantá maok, pris tokwae fákárerao sérrá, ‘Lasarusén kor mént sámp-wouroump mwar’ ria kar papapono. ");
INSERT INTO yuj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jisaso Lasarusént fária pwaránko, ankwap yae fek kápae kare koumteouráp arop Pasova Yae nke mwaria Jerusalem mek koropea koupoukour yakáp. Aeria am fárákapao wawapo maok, ‘Jisas Jerusalem mek korop naean’rá sér. ");
INSERT INTO yuj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Am wawia maok, oupuk pwae niamp yao pwae fékéria tukupea, mwaeaok Jisasén kɨkɨpia tékén arakrá sér, “Nomo Kwarén warákár mwaro! Kwaro Tokwae Karamp e fek koropnámp arop má e tokwae sánkano! Mao te Israel firamp King yak naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisaso donki soup ankárank sámpea am fek tank. Aenánko, am te Kwaromp Buk fek yaknámp kar niampon. Am te arakrá sénámpono: ");
INSERT INTO yuj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Taun Saion mekamp koumteouráp arop, yumo te apápi kwapono! Yiráp king oukoumwan má korop námp nkenke. Mao te donki soup fek tankrá korop námpono.” ");
INSERT INTO yuj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Manénkɨr am ke fek te mao éréképá yárak i konámp arop fárákap te am kar fi te mér moiapono. Aeno nánkár wakmwaek Jisas warko arákarrá pokria wae tokwae sámp námp fek maok, am Kwaromp Buk fek yaknámp kar nɨnɨkria, arop fárákapao Jisaséniapan kor nɨnɨkia, ‘Am te Jisas táman sénámpon’rá mériapon. ");
INSERT INTO yuj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Wokwaek kápae kare koumteouráp arop Jisasént yakápria nkeapo, Jisaso Lasarusén apár me mekamp fárámpea papámpon. Oukoumwan am koumteouráp arop te am Jisasoimp táman arop ankwap fárákapan kar farákáp napon. ");
INSERT INTO yuj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aenapo, kápae kare koumteouráp arop Jisaso manénkɨr am ankank yoroimp kar táman wawia maok, am fárákap maonámpok tukupea mwaeaok kɨkɨp. ");
INSERT INTO yuj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tá Farisi fákárerao kor námoku támao am nkea námoku kok sérarrá, “Nkenke! Nomo mwaria nánap námp te tak mwanámp pourou moiane! Ponankor koumteouráp arop te man éntér kákia tukup napon.” ");
INSERT INTO yuj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Koumteouráp arop fákárerao tukupea Jerusalem mek Pasova yae fek Kwarén lotu mwariakapo maok, táte Grik ankwap fákárerao kor mént tukup. ");
INSERT INTO yuj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Am Grik fákáre te Galili mekamp taun Betsaida mekamp arop Filiponámpok koropea maok, man arakrá sér, “Arop Tokwae, yino te Jisasén nke mwarianeano.” ");
INSERT INTO yuj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Aerapo maok, Filipo kor akwapea Andrun séria warámpea énénkér akwapea Jisasén sérepo maok, ");
INSERT INTO yuj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","tá Jisaso am arop yaworamp kar mao sumpwi naempan wounáp kar sérrá, “Oukoumwan má ke fek te Aropamp Táráp e tokwae sámp naenámp ke te wae korop námpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ono waeman yumwan kare kar sér rae: Wit ki apárok pɨká tankrá yɨpi takére mo námp te, am ankárank támao saráp yak konámpon. Aeno apárok pɨká tankea yɨpi takérea téri pokea maok, ki kápae kare tank konámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Am wounáp kar séria pwarará maok, kar kare sérrá, “Aeno arop námokuráp pourouan yiki yak naenámpan nɨnɨkrá yárak námp te, maomp yiki yak moyak naerámpon. Aeno arop námokuráp pourouan wampwe pwarará, onan nɨnɨk námp te, mao fwap ankár yiki yaká yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aeno arop ankárank onomp tére naenámp kwamp te, ankár ononampaok kuno. Takria maok, mae némpouk ono yak namp te onomp tére aropao kor onont am fek yak naenámpon. Aeria maok, arop onomp tére nánko te, onomp Naropwar te man e tokwae sánk naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisas warko ankwap kar arakrá sér, “Oukoumwan te ono yonkwae touweria nɨnɨk tokwae nampono. Aenampara apaerá sénanampon? Ae te ono onomp Naropwarén sérrá, ‘Oukoumwan má ankank korop námp má sámp-sɨrae’rá sénanamp nie? Ono takrá sér mono. Am ankank te ankár onomp pourouk korop naenámpria ék namp támaono. ");
INSERT INTO yuj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ayao, waráp e tokwae kwapwe yénkép napo, arop fárákapao nke mwanapono.” Jisaso makrá séránko maok, táte yámar meknámp kar ankárank arakrá sér, “Ono te wae onomp e tokwae kwapwe kare yénkép nampara, warko oukoumwan kor tak nanampono.” ");
INSERT INTO yuj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aeránko am koumteouráp arop fárákap wonae fik am fek yakáp napao, am kar wawia arakrá sérrá, “Wɨ! Oukurér párákapáne!” Tá ankwap fákárerao sérrá, “Mono, enselo mént kar sénámpono.” ");
INSERT INTO yuj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Aerapo maok, Jisaso sérrá, “Am kar yumo wa nap te onan yaewour mono. Yumwan yaewour naenámpan námpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Oukoumwan Kwaro má apár mekamp koumteouráp arop younkoupria, táte má apár mekamp arop poukeyak konámp arop kwatae yérépea kérép naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Oukoumwan te ono má apár mek yak nampan maok, nánkár te onan ka-sampokea napo, am ke fek táman ponankor koumteouráp arop ononampok érékép-korop nanampon.” ");
INSERT INTO yuj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Jisaso am takrá sérimp te námoku sumpwi naenámp mwaekamp nɨnɨk fek sérimpon.) ");
INSERT INTO yuj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Aeránko maok, am koumteouráp arop fákárerao maomp kar pwarokwaprá man sérrá, “Yino wa nánko Kwaromp loao sérrá, ‘Krais te ankár yaká yak naenámpono’rá sénámpon. Amo mokopia ‘Aropamp Táráp narek sampok mwanap’rá sér rape? Am ‘Aropamp Táráp’ te wanono?” ");
INSERT INTO yuj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aerapo maok, Jisaso am fárákapan wounáp kar sérrá, “Wae te fae tákáre ke fek yumont yak námpon. Oukoumwan wae yumont yak námp fek yiráp paokop te ankár wae fek paokop kip. Yumwan kɨrɨkɨp koropea oupouroup naeane. Arop kɨrɨkɨp mek yárakria te, mao te maok akwap raerá mér mo i konámpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Wae te oukoumwan yumont yak námpara, yumo ankár wae táman méria maok, yumo waeramp arop fákáre yakáp mwanapon.” Jisaso makrá séritea maok, am fárákapan pwarará youmpea mek yak. ");
INSERT INTO yuj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Am fárákap Jisaso nkwakwe make kárákáre yoro nánko nke napao maok, man te mér mo napon. ");
INSERT INTO yuj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Aenapo maok, profet Aisaiamp kar méntér pwi námpon. Aisaiao sérrá, “Tokwae Kar e! Wa mokop yinomp kar wawia mér námpon? Wa mokop Tokwae Karao náráp kárákáre yénképnámp tére oukoumwan má térenámp niamp nke námpon?” ");
INSERT INTO yuj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Am fárákap Jisasén mér mwanap pourou mono. Am tak mwarap fi táman Aisaia ankwap kar kumwi námpon: ");
INSERT INTO yuj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kwaro am fárákapamp yi nke mwanap pourou moi papria nɨnɨkan kor épérépi pap. Takria am fárákap ankank nkeria, kar fi méria, ononampok arákarrá korop napo, ono am fárákapan fwapokwapi papantáno.” ");
INSERT INTO yuj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia am takrá sénámp te, apae riteanápe, Jisasomp kárákáre tokwaeran nkea pwatea am Jisas táman sérimpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Karenono, kápae kare Juda taokeyakáp konap aropao kor man mérapo maok, Farisi fákárerao námwan, lotu nap mek korop kwaponoria taokorantá apáp nap kwamp, maomp mérap érik sér moiapon. ");
INSERT INTO yuj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Am fárákap te Kwaro námwan warákár naenámpria te mono, arop fárákapao námwan warákáranápon kar i konapon. ");
INSERT INTO yuj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisaso tékén sérrá, “Arop onan mér námp te onan saráp mér mono, onomp Naropwaro onan sámp-kérép nánko ék nampan kor mént mér námpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Arop onan nke námp te, onomp Naropwaro onan sámp-kérépánko ék namp man kor nke námpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ono má apár mek ék namp te ará: Arop fárákap onan mér nap te kɨrɨkɨp mek yakáp mono. ");
INSERT INTO yuj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Aeno arop ankárankao onomp kar wawiaka onomp karwaok yárak mo námp te, man te ono arop yurukuprá kot i konámp aropnámp taknámp mono. Ono ék namp te má apár mek yakrá koumteouráp aropan yurukuprá kot naeriaka ék mono. Ono ék namp te am arop fákáreran warko érékép naeria ék nampon. ");
INSERT INTO yuj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aeno arop onan younkwek sɨrarrá onomp kar sámp mo námp te, man yurukuprá kot naenámp arop te yak námpon. Ono farákápnamp kar támao nánkár pwarnámp yae fek mao am fárákapan yurukuprá kot naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ono te onokump nɨnɨk fek má kar farákáp mono. Onomp Naropwaro onan sámp-kérépánko ono ékamp, mao námoku kápae kare kar onan farákápaerianámp sápria, am farákáp nanamp nɨnɨkan kor sáp námpon. ");
INSERT INTO yuj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ono te wae mér nampon, onomp Naropwaromp kar te yiki yaká yakáp mwanap nénk konámpon. Aenámpara, kápae kare kar ono farákáp namp te onomp Naropwaro ‘Arakae’rá sénámpaok i konampono.” ");
INSERT INTO yuj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova Yae kumur korop naerianánko, am ke fek táman Jisas wae mér, má apár pwarará Naropwaronámpok pok naenámp ke korop. Aenánko maok, náráp koumteouráp arop fákáreran má apár mek yakáp napan yonkwae touwemp te ankár yonkwae touwe tokwaerá akwapea, sumpwimp ke fekimpon. ");
INSERT INTO yuj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kumuran Jisas ntia mao éréképá yárak i konámp arop fárákap fépérrá tankáp. Aenapan maok, Saimon Iskariotomp táráp Judasén te wae Satano Jisasén arop outɨri naenámp nɨnɨk wokwaek sánk tenámpono. ");
INSERT INTO yuj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas te wae mér, Naropwaro ankank ponankor maomp yaek sánkámp, tá námwan sámp-kérépánko ékiakámpan warko arákarrá Kwaronámpok pok naenámpan kor wae mér. ");
INSERT INTO yuj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ae námp kwamp maok, Jisaso am fɨr taki tank nánko, fárámpea waempyam éri wor paprá tawel sámprá kámpea pwarará maok, ");
INSERT INTO yuj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ént dis mek kwarákár. Takia maok, wae am feknámp námoku éréképá yárak i konámp arop fárákapamp pu yárária pwarará maok, táte am kámpnámp tawel fek am fárákapan féki torokor. ");
INSERT INTO yuj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Takria Saimon Pitamp wonae fik koropánko maok, Pita man sérrá, “Tokwae Kar e! Amo te onomp pu yárár nae rape?” ");
INSERT INTO yuj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Aeránko maok, Jisaso maomp kar pwarokwaprá sérrá, “Ono térenamp ankank te oukoumwan te amo mér mono, tá nánkár wakmwaek maok, amo mér nanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aeránko maok, Pita man sérrá, “Amo onomp pu te yárár mo karono!” Aerá séránko maok, Jisaso maomp kar pwarokwaprá sérrá, “Ono amwan éntup moia nanko te, amo warko onont yak nanap pourou mono.” ");
INSERT INTO yuj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aeránko maok, Saimon Pita man sérrá, “Tokwae Kar e, ae te takanánko te, onomp pu mwar yárári kwapon. Ankár yae kor, me kor méntér yárárae!” ");
INSERT INTO yuj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Mak ránko maok, Jisaso man wounáprá sérrá, “Arop wae éntupianámp te warko koupour kar éntup mo i konámpon. Puan saráp yárár napo kor, waeman ponankor yiki kukurámpon. Yumo te waeman yiki kor yakáp napan maok, ono yumwan ‘Ponankor’rá sér mono.” ");
INSERT INTO yuj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Jisas te am arop námwan yopor aropamp yaek pap naenámp te wae mér. Ae námp kwamp maok, mao sérrá, “Yumo ponankor yiki kukur mono.”) ");
INSERT INTO yuj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisaso am fárákapamp pu yárária pwatea warko náráp waempyam sámpea yirɨmptea warko tank. Aeria maok, am fárákapan turunkrá, “Ono yumwan má térenamp fi te yumo wae mér nap nie? ");
INSERT INTO yuj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yumo onan ‘Tisa’, tá ‘Tokwae Kar’rá sénap te, tá kare yae-párák kare sénapon. ");
INSERT INTO yuj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ono Tokwae Kar, tá Tisa wuriman, tére arop arákarea yiráp pu yárár nampara, yumo kor yiráp ankwapnáp ankwap fárákapamp puan kor takrá yárár kipo. ");
INSERT INTO yuj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ono mámá nɨnɨk yumwan yénkép namp te, yumo kor ono yumwan yénkép nampnámp maknámp tére kip. ");
INSERT INTO yuj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ono yumwan kare kar sénámpon: Tére konámp arop te maomp arop tokwae kámákár akwap mono. Tá sámp-kérép nánko korop námp te, am sámp-kérépnámp aropan kámákarrá nareki yak mono. ");
INSERT INTO yuj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Oukoumwan te yumo ono amnamp nɨnɨk fi kor wae mér napara, yumo ampaokria te, yumo fwap warákár mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ono te yumwan ponankor sér mono. Ono onomponoria nánkárápnamp arop fárákapan yumwan te wae mér nampan maok, Kwaromp Buk fek kar arakrá yak námp waeman kare korop naenámp mér nampon. Am kar te arakrá sér, ‘Arop onont pan fánámpao onan younkwe sɨnaeria námpon.’ ");
INSERT INTO yuj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Am ankank te oukoumwan korop mo nánko, ono yumwan manénkɨr sér rae: Nánkár wakmwaek am ankank koropeanánko, yumo fwap Ono Taki Yak namp mér mwanapono. ");
INSERT INTO yuj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ono waeman yumwan kare kar sér rae: Ono tére arop sámp-kérép nanko, man warámpea yaewour námp te, tá onan táman warámpea yaewour námpon. Tá arop onan warámp námp te, mao onan sámp-kérépánko ékamp Kwarén kor warámp námpono.” ");
INSERT INTO yuj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas takrá séria pwarará, yonkwae touwea waeria maok, érik farákarrá arakrá sér, “Ono yumwan waeman kare kar sér rae: Yumo ou mekamp ankwap ankárank onan yopor aropamp yaek pap naerámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Makrá séránko maok, mao éréképá yárak i konámp arop fárákap námoku kor am kar épérép nap kwamp maok, nonopok énounkouprá, máte wan sérianria mér mono. ");
INSERT INTO yuj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mént paokop i konap arop ankárankamp Jisaso man warákár kar i konámp arop te Jisasomp éntér mwaek wonae fik kar tank. ");
INSERT INTO yuj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Aenánko maok, Saimon Pita, man wan sérianrá turunkaeria me fi wink. ");
INSERT INTO yuj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aeránko maok, mao wonae fik kar éntér kor fek youmprá woukoupria maok, Jisasén sérrá, “Tokwae Kar, amo te wan sér rap?” ");
INSERT INTO yuj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Aeránko maok, Jisaso sérrá, “Nánkár nomo énénki fánámp arop ankárankampan ono pan sámpea sup mek anámpea sánk nampao maok, am arop táman sénampon.” Mak ritea maok, pan sámpea sup mek anámpea Saimon Iskariotomp táráp Judasén sánk. ");
INSERT INTO yuj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judaso am pan sámpea pwar nánko maok, Satano maomp nɨnɨk mek yoump. Aenko maok, Jisaso man arakrá sér, “Ankank amo tak naenap te koupour takae.” ");
INSERT INTO yuj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Aeránko maok, arop ponankor énénki tankáp nap Jisaso Judasén sénámp kar fi te ankwap ankárankampao mér mono. ");
INSERT INTO yuj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ankwap fárákapao nɨnɨkrá, Judas te mani kériramp yam poukwap konámpara, Jisas man te ‘Am mani fek lotu mwanap yae fekamp ankank akwapá tiae’rá sérámpwe nɨnɨk. Tá ankwap fárákapao ‘Ankank monap aropan nénkae’rá sérámpwe nɨkiapon. ");
INSERT INTO yuj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Aeapo maok, Judas am pan fákáre sámpea pwarará koupour kar apárok oukur akwapánko maok, wae kɨrɨkɨpeyak. ");
INSERT INTO yuj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas wae apárok akwap tenánko maok, Jisaso sérrá, “Oukoumwan te Aropamp Táráp wae e tokwae sámp námpon. Tá Kwaro Aropamp Tárápaonámp fek e tokwae sámp námpon. ");
INSERT INTO yuj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kwaro mao tére námp fek e tokwae sámpria te Aropamp Tárápan kor Kwaro námoku e tokwae sánk nánko, am ankank te koupour kar naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Onomp tárápu kwae! Kánanke kwarok ke fek saráp ono yumont yak nanampon. Aeno nánkár te yumo onan oupourounk mwanapon. Ono manénkɨr Juda taokeyakáp konap fákáreran makrá sériampan oukoumwan yumwan kor take pourouráp kar táman sér rae: Yumo te ono akwap nanamp némpouk te tukup mo kareno. ");
INSERT INTO yuj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ono te yumwan oukoumwan lo wourékam nénk nampon. Am te arak: Yumo ankákárank nonopok nounouroupria warákár kipo. Ono yumwan nouroupia warákár kari namp te, yumo kor taknámp ankár nonopok nounouroupria warákár kar tak kipo. ");
INSERT INTO yuj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yumo yiráp ankwapyaenáp fárákapént nonopok nounourouprá warákár kare napo maok, arop ponankoran yumo onomp firáp yakáp nap yénkép napo, mér mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita man sérrá, “Tokwae Kar, amo te maok akwap nanapon?” Aeránko maok, Jisaso maomp kar pwarokwaprá arakrá sér, “Ono akwap naerianamp némpouk te amo oukoumwan onan éntér papá akwap nanap pourou mono. Aeno nánkár wakmwaek maok amo onan éntér papá korop nanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Aeránko maok, Pita man turunkrá, “Tokwae Kar, apaeritea ono oukoumwan waráp wakmwaek akwap mo nanampon? Ono fwap amwan yaewourrá onomp pourou sámp nanamp tene!” ");
INSERT INTO yuj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aeránko maok, Jisaso man sérrá, “Waráp nɨnɨk te, amo fwap onan yaewourrá waráp pourou sámp nanap nie? Ono amwan waeman kare kar sér rae: Kakaruk oukoumwan aráp mo nánko, amo onan te ‘Mér mo namp’rá yinɨnk por sénae rapono.” ");
INSERT INTO yuj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas warko am fárákapan sérrá, “Yumo te kokorokoriaka yonkwae touwe tokwae kwapon. Yumo Kwarén méria ankár onan kor mént mér kip. ");
INSERT INTO yuj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Onomp Naropwaromp nap aok-aokore te kápae kare ara, ono pokea yiráp por nap aokore nánaprá párakop nanampon. Aeno am nap aokore yak mo nánko te, ono yumwan takrá sér mono. ");
INSERT INTO yuj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ono pokeaka yiráp por népe nánapia pwar namp kwamp te, warko ékia yumwan éréképá pokeaka ono yak namp fek énénki yakáp mwanámpon. ");
INSERT INTO yuj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yumo te ono pok naenamp némpouk poknámp mwae te yumo wae mér napon.” ");
INSERT INTO yuj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aeránko maok, Tomaso man sérrá, “Tokwae Kar e, amo te maok akwap nae rape? Yino am te mér mo námpon. Tá mwaeran kor mokopia mér mwanámpon?” ");
INSERT INTO yuj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisaso man sérrá, “Onoku támao mwae kupono. Tá ono kare kar sér i konap fi korono. Ono te yiki yak fi korono. Arop Kwaronámpok korop naenámp te ankwap mwae te yak mono, ono mwarono. ");
INSERT INTO yuj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yumo onan wae méri yakáp nap kwamp te, oukoumwan yumo fwap onomp Naropwarén kor mér mwanapon. Yumo man te wae nke napara, oukoumwania man mérrá tukup napon.” ");
INSERT INTO yuj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo Jisasén arakrá sér, “Tokwae Kar e, amo yinan Naropwar yénképea napo maok, am támao wae yinomp nɨnɨk fwap farákár naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nopok Jisaso man sérrá, “Filip, ono yumont waeman kápae kare ke fek yak nampan maok, amo te onan oukoumwan mér mo nap nie? Arop onan nke námp te, onomp Naropwarén kuri wae nke námpon. Amo mokopiaka ‘Waráp Naropwar yinan yénképae’rá sér rape? ");
INSERT INTO yuj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ae te amo onomp Naropwarént koumpeyak nanko, onomp Naropwaro onan koumpeyak námp te amo mér mo rape? Ono yumwan sénamp kar te onokump nɨnɨk fek sér mono, onomp Naropwaro onont yakria maok, náráp tére am tére konámpon. ");
INSERT INTO yuj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yumo te má kar man ankár mér kipo: Ono onomp Naropwarén koumpeyak nanko, tá onomp Naropwaro kor onan koumpeyak námpon. Táte yumo takrá mér mwanap pourou mo nánko te, yumo ankár ono kápae kare tére namp táman nɨnɨkria maok, yumo onan mér kip. ");
INSERT INTO yuj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ono waeman yumwan kare kar sér rae: Arop onan mér námp te, mao kor ono nkwakwe make tére konamp te, fwap takrá tére naenámpon. Mao te tére tokwaeria onomp tére kámákár akwap naenámpon. Am te apae ritea námpanápe ono te onomp Naropwaronámpok pokea yak nanampon. ");
INSERT INTO yuj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kápae kare ankank yumo onan mér nap fek turunk nap te, ono fwap yumwan nénk nanampon. Aenanko maok, Tárápao tak námp fek Naropwaro e tokwae sámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ponankor apae ankank yumo onomp e fek turunk nap te, ono fwap ampaok nanampon.” ");
INSERT INTO yuj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jisas warko arakrá sér, “Yumo onan nouroup kareria te, yumo ankár ono sénamp kar ponankor ampaok mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aenapo, ono onomp Naropwarén turunk nanko, yumont Fearámpá Yakria Kárákáre Sánk naenámp Ankwap sámp-kérép naenámpon. Aenánko maok, mao te ankár yumont yaká yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Am Fearámpá Yak naenámp te kare kar sér i konámp Spiritono. Apárokamp koumteouráp arop te man sámp mwanap pourou mono. Am te apae riteanápe man nke mo, man mér mono. Aeno yumo maok man mér napara, yumont yakria, yiráp nɨnɨk mek yaká yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ono te yumwan kwaporok taki yakápenkria párakop tenanko, yumo kweri tárápu niampia yakáp mono. ");
INSERT INTO yuj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ono te fwap warko yumonapok korop nanampon. Kánanke kwarok ke fek, apárokamp koumteouráp arop te onan warko nke mono. Aeno yumo maok onan nke mwanapon. Ono yiki yak nampara, yumo kor taknámp yiki yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Am yae fek táman maok, ono onomp Naropwarént koumpeyak nanko, yumo kor onont koumpeyakáp napo, ono yumont koumpeyak namp mér mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Arop onomp kar sámpea ampaok kar námp te, am arop onan nouroup kare námp yénkép námpon. Tá arop onan nouroup kare námp te, onomp Naropwaro nouroup kare nánko, tá ono kor man nouroup kareria onoku kare man érik yénkép nanampon.” ");
INSERT INTO yuj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisaso makrá séránko maok, Judas Iskariot te mono, Judas ankwapao, Jisasén sérrá, “Tokwae Kar e, apaeritea amo yinan saráp amoku kare yénképria mámá apárokamp koumteouráp aropan yénkép mo nanapon?” ");
INSERT INTO yuj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aeránko maok, Jisaso nopok man arakrá sér, “Arop onan nourouprá warákár kare námp te, mao te ono sénamp karwaok kar yárak naenámpono. Aenánko onomp Naropwaro kor am aropan nouroupria warákárria maok, yino énénkér koropeaka mént yaká yak nenempon. ");
INSERT INTO yuj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Arop onan nouroup kar mo námp te, mao te fwapia onomp karwaok mo i konámpon. Mámá yumwan yénkrá farákápnamp kar máte onokump kar mono. Onomp Naropwaro onan sámp-kérépánko ono ékamp maomp karono. ");
INSERT INTO yuj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ono oukoumwan yumont yaknamp ke fek, ono yumwan am kar farákáp nampon. ");
INSERT INTO yuj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aeno ‘Yumont Fearámpá Yakria yumwan Kárákáre Sánk naenámp’rá sénamp te Yiki Kor Spiritono. Onomp e fek onomp Naropwaro man sámp-kérép nánko, ék naenámpon. Mao te yumwan kápae kare ankank yénk naenámpon. Tá mao yumwan nɨnɨk sánk nánko, ono yumwan wokwaek farákápnamp kar ponankor warko nɨk mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ono yumwan pwar naeramp kwamp, yonkwae porokwe nénk tenanko, am yiráp nɨnɨk mek yak naenámpon. Tá ono yumwan yonkwae porokwe nénk naeramp te, apárokamp aropao nénk konap niamp mono. Aenampara, yumo te kokorokoriaka apáp tɨrɨnkia yonkwae sékéria wae kwapon. ");
INSERT INTO yuj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yumo te ono yumwan farákápnamp kar mámá wae wa napon: Ono yumwan pwarará akwap nae rae. Tá ono warko yumonapok arákarrá korop nanampon. Yumo onan warákár nap kwamp te, ono onomp Naropwaronámpok akwap nampan kor warákár mwanapon. Am te apaeritea námpanápe, onomp Naropwar te narek kar onan kámákár yak námpon. ");
INSERT INTO yuj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mámá kar yumwan farákáp namp te, am ankank oukoumwan korop mo nánko, ono manénkɨr farákáp nampon. Aenampara, nánkár am ankank korop nánko, nkea maok, yumo mér mwanapono. ");
INSERT INTO yuj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ono te yumwan kápae kare kar sénanamp pourou mono. Am te apae riteanápe, apárokamp arop poukeyak konámp arop wae koropáne. Mao te onan kwe-pwar naenámp kárákáre te yak mono. ");
INSERT INTO yuj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Aeno ono nɨnɨk namp te apárokamp arop fárákap te fwapia mér kipo: Ono onomp Naropwarén te warákár tokwaeria maok, kápae kare ankank tére namp te mao onan séri nampaok nampono. Yumo fápárámpenke! Wae tukup mwaro.” ");
INSERT INTO yuj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisaso wounáp kar arakrá sér, “Ono te yao wain aopwe karenono. Onomp Naropwar te yao wain yopwar naropwarono. ");
INSERT INTO yuj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Onomp yowe kor ponankor tank mo nánko te, onomp Naropwaro karrá tokopea épér i konámpon. Tá yowe kor ponankor ki tank konámpan maok, onomp Naropwaro ki kápae kare tank naenámpria yowe fae tákáre fek fékérrá, yowe kor fwapokwap i konámpono. ");
INSERT INTO yuj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ono sénamp karao yumwan wae fwapokwapianánko yiki kukur yakáp napon. ");
INSERT INTO yuj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yumo te ankár onont koumpeyakáp napo, ono yumont koumpeyak nanampon. Yao wain yowe fek pukupá yak mo námp te ki tank naenámp pourou mo i konámpon. Tá taknámp yumo kor onont koumpeyakáp moia te, yumo kor yao niamp ki tank mono. ");
INSERT INTO yuj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Onoku támao ono wain aopwe kor nanko, yumo te wain yowe kor niampon. Arop ankwap onont koumpeyak nánko, ono kor mént koumpeyak nanko te, mao te kápae kare ki tank naenámpon. Aeno yumo onan pwararea te, yumoku mwar tére mwanap te pwi mono. ");
INSERT INTO yuj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Arop ankwap onont koumpeyak mo nánko, man far-pwar mwanap te, yao yowerao yákáre nánko, koupoukarea yaomwi mek épéria yank i konap niamp taknámp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Aeno yumo onont koumpeyakáp napo te, onomp kar yiráp nɨnɨk mek yak nánko, yumo fwap apae ankank turunk napo, am ankank fwap korop naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aeno yumo kápae kare yao ki niamp énki nap te, arop nke nap fek yumo te onomp fákáre yakáp nap yénkép nánko, am fek táman onomp Naropwaromp e sakap napo, e tokwae sámp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Onomp Naropwaro onan nouroup tokwae konámp te, ono kor takeniamp nɨnɨk fek yumwan nouroup tokwae nampono. Yumo kor ankár am ono nouroup i konamp nɨnɨk mek saráp yakáp kipo. ");
INSERT INTO yuj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Táte yumo onomp lo karwaok kar paokop nap te, yumo waeman ono yumwan nouroup i konamp nɨnɨk mek am mek yakáp nap te, ono kor onomp Naropwaromp karwaok karria ono maomp nouroup i konámp nɨnɨk mek yak konamp niamp napono. ");
INSERT INTO yuj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Onomp nɨnɨk te, onomp warákár konamp yumont yakria, am warákár yiráp nɨnɨk mek top-pwarámpeyak naenámpria, ono yumwan mámá kar sénampon. ");
INSERT INTO yuj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Onomp lo te araki yak námpon: Ono yumwan nouroup kare nampnámp taknámp yumo ankákárank ankár nonopok nounouroup kipo. ");
INSERT INTO yuj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Táte arop náráp nouroup fárákapan nouroup kareriaka man yaewourrá náráp pourou sámp námp te, am nɨnɨkao koumteouráp aropao ankwapan nouroup i konap nɨnɨkan kámákár akwap námpon. ");
INSERT INTO yuj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Táte ono yumwan sénampnámp maknámp nap te, yumo onomp nouroup yakáp napon. ");
INSERT INTO yuj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tére konap arop te, tére taokeyak konámp aropamp nɨnɨk te mér mono. Ae konapara, ono yumwan warko ‘Tére konap arop’rá sér mono. Onomp naropwaromp kar ponankor wawi namp, am te ono wae yumwan séri namp támao yumwan onomp nourouprá yénkép námpon. ");
INSERT INTO yuj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yumo te onan náráponoria nánkáráp mono. Ono maok yumwan onomponoria nánkárápea nanko maok, onomp firáp yakáp napon. Aenampara, ono yumwan tére nénk tenanko, tukupea ki énkiriaka, yiráp ki énkinámp am yae-párák yaká yak nae-námpono. Aeria maok, yumo onomp Naropwarén apae ankank sámp mwaria ono warákárnamp nɨnɨként turunk nap te, mao yumwan fwap sánk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ono yumwan lo arakrá sánk nampon. Yumoku kok ankákárank ankár nonopok nounouroup kar kipo.” ");
INSERT INTO yuj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jisas warko sérrá, “Aeno apárokamp arop fárákap yumwan ampwae-sámp nap te, yumo te wae mérono, manénkɨr onan tak napara napon. ");
INSERT INTO yuj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Aeno yumo apárokamp aropamp yakáp nap niamp wuri popwar yakáp napo te, am apárokamp arop fákáre te, tá wae yinoku finoria warákár mwanapon. Aeno yumo te mámá apár mekamp arop mono. Ono yumwan wae onomponoria nánkáráp namp te, yumo mámá apár mekamp nɨnɨként tapokwap mo mwanapria ninampon. Aenampara, apárokamp koumteouráp arop yumwan ampwae-sámp napon. ");
INSERT INTO yuj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ono yumwan farákápnamp kar má yumo fwapiaka nɨki-samp kip: Tére konap arop te náráp arop tokwaeran kámákár akwap mono. Arop fárákap onan nkwakwe make touwe sáp nap te, yumwan kor tak mwarea napon. Táte arop fárákap onomp karwaokia nap te, yumwan kor yiráp karwaok mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Aeno am fárákap te onomp Naropwar onan sámp-kérépánko ékamp man mér moitea napara, am fárákap ponankor kwataenámp nɨnɨkan tak napon. Am te apaeritea napanápe, am fárákap te yumo onomp firáp yakáp nap wae méria napon. ");
INSERT INTO yuj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Táte ono ékia kar farákáp mo nankoria te, am fárákap náráp kwatae nɨnɨk yak námprá mér mono. Aeno oukoumwan te am fárákapamp kwatae nɨnɨk mek wouroump mwanap mwae te yak mono. ");
INSERT INTO yuj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Aeno arop onan ampwae-sámp námp te, onomp Naropwarén kor ampwae-sámp námpon. ");
INSERT INTO yuj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Táte ono am fárákap ou mek yakria tére namp, arop ankwapao wokwaek takrá tére moimpanánko te, am fárákap yino te kwatae nɨnɨk námprá mér mono. Aeno am fárákap onomp tére wae nke napara, onan ampwae-sámpria, onomp Naropwarén mént ampwae-sámp napon. ");
INSERT INTO yuj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Am fárákapao am taknap nɨnɨk te am fárákapamp lo kumwi napao sénámp niamp napon. Am támao arakrá sér, ‘Arop fárákap onan kwaporok fwapnae mek ampwae-sámp napon.’ ");
INSERT INTO yuj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Aeno yumwan yaewourria kárákáre sánk naenámp Spirit te onomp Naropwarént yak námpan, nánkár ono yumonapok sámp-kérép nanampon. Am Spirit te kare kar sér i konámpao Naropwarént yakeanámpan ék naenámpon. Mao ékia te, ono i konamp nɨnɨk érik farákarrá yénkép naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aenánko, yumo kor wokwaek onont yakriaka, ono tére fi yokor námp feknámpia onont yakáprá koropea oukoumwan napara, yumo kor ono te wanonorá farákáp mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas wae am fek ankwap kar arakrá sér, “Yumo onan mér nap pwar te monoria namp kwamp, ono yumwan mámá kar sénampon. ");
INSERT INTO yuj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Arop fárákapao, yinont lotui kwaponoria táraokwamprá yérépe mwarea napon. Nánkár wakmwaek, ankwap ke fek te arop fárákapao yumwan tirá wouria am fárákapamp nɨnɨk te yino Kwaromp tére kwapwe námpan mpwe mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Am fárákap te onomp Naropwarén mér mo, tá onan kor mér mo napara, am nɨnɨk tak mwarea napon. ");
INSERT INTO yuj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aeno oukoumwan te ono yumwan sérinamp am ankank te korop naerámpon. Am te nánkár wakmwaek arop fárákapao yumwan tak napo maok, ono yumwan sérarinamp kar mámá warko nɨnɨk mwanapon.” Jisaso warko ankwap kar sérrá, “Wokwaek kar onoku yumont yak nampara maok, ono yumwan má ankank korop naenámp kar sér moiampon. ");
INSERT INTO yuj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Aeno oukoumwan te mao onan sámp-kérépánko ékamp Naropwaronámpok pok nae nae. Yumo te ankwap ankárankamp onan ‘Amo te maok akwap nae nap’rá turunk moi napon. ");
INSERT INTO yuj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ono oukoumwan yumwan mámá kar sénanko te, yumo yonkwae touwe tokwae napon. ");
INSERT INTO yuj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Aenapan maok, ono yumwan waeman kare kar sénampon: Yae-párák ono yumwan pwarará pok namp te, yumwan yaewour námpon. Aeno ono pok mo nanko te, yumwan kárákáre sánk naenámp Spirit te yumonapok ék naenámp pourou mono. Aeno táte ono pokea maok, ono sámp-kérép nanko yumonapok ék naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mao ékiaka yénkép nánko te apárokamp arop fárákap kwatae nɨnɨk fi kor mérrá, tá yae-párák kare nɨnɨk fi kor mér, tá Kwaro arop kot naenámp fi kor mér mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kwatae nɨnɨk fi kor yénkép námp te, arop fárákap onan mér mo nap aranon. ");
INSERT INTO yuj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yae-párák kare nɨnɨkrá sénámp fi te ará: Ono onomp Naropwaronámpok pok nanko, yumo te warko onan nke mono. ");
INSERT INTO yuj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kwaro arop kot naenámp fi yénkép námp te, mámá apár mek taokeyaknámp aropan te Kwaro waeman kot námpon. ");
INSERT INTO yuj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ono te kápae kare kar oukoumwan yumwan farákáp nanamp yak námpan maok, oukoumwan yumo sámp mwanap pourou moiane. ");
INSERT INTO yuj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nánkár kare kar sér i konámp Spiritao ékia maok, yiráp nɨnɨk ékékér nánko, yumo kare kar kar mér mwanapon. Am tak námp te, mao námokuráp nɨnɨk feknámp sér mono. Mao Naropwaromp kar wawianámpan, am táman yumwan farákáp naenámpon. Mao te yumwan wakmwaek korop naenámp ankank farákáp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mao te onomp karan sámpea yumwan farákáp nánko, am taknámp nɨnɨk támao arop wanap fek onomp e tokwae ntia onomp kárákáre yénkép naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Onomp Naropwaromp kápae kare ankank te onompono. Aenámpara, ono sérrá, ‘Mao te onomp karan sámpea yumwan farákáp naenámpon.’” ");
INSERT INTO yuj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jisas warko ankwap kar sérrá, “Kánanke kwarok ke fek saráp yumo onan warko nke mono, tá warko wakmwaek kánanke kwarok ke fek yumo onan nke mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aeránko maok, mao éréképá yárak i konámp arop ankwap fákárerao námoku kok sérarrá, “Mámá kar te apae kar firan nomwan sériane? Mao sérrá, ‘Kánanke kwarok ke fek saráp yumo onan nke mono. Warko wakmwaek kánanke kwarok ke fek onan nke mwanapon’rá sénámpon. Tá ankwap sérrá, ‘Ono onomp Naropwaronámpok pok nanamp’rá sénámp te apae kar finono?” ");
INSERT INTO yuj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Aeria maok, am fárákapao sérrá, “Am ‘Kánanke kwarok ke’rá sénámp te apae ankankono? Nomo am kar fi mér mo námp tane!” ");
INSERT INTO yuj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Am fárákapao man turunk mwaria nap te, Jisas wae méria maok, am fárákapan sérrá, “Ae te ono farákápnamp kar fi man yumo téréménk rape?” Aerá séria maok, “Ono te arakrá sénampon: Kánanke kwarok ke fek saráp yumo onan nke mono. Tá wakmwaek kánanke kwarok ke fek yumo warko onan nke mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ono waeman yumwan kare kar sérrá: Yumo te yonkwae touwe tokwaeria, éménka wae mwanapon. Aenapan maok, apárokamp koumteouráp arop te warákár mwanapon. Yumo te yonkwae touwe napan maok, warko am pwarará warákár kar mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yupu táráp sámp naerianámp ke fek te, touwe tokwae sámpria yonkwae touwe konámpon. Aenámpao maok, mao wae táráp sámpea te, am touwe sámp námp te wae nɨk mo pwarará, táráp wae koropá yak námp táman warákár konámpon. ");
INSERT INTO yuj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ae konámpnámp taknámp oukoumwan yumo yonkwae touwe sámp napon. Nánkár wakmwaek ono yumwan warko nke nanko te, yiráp nɨnɨk te warákár naenámpon. Yiráp am warákár te arop ankwapao sámp-sɨr mono. ");
INSERT INTO yuj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Am ke fek te yumo onan ankwap ankank turunk mono. Ono yumwan waeman kare kar sénampon: Yumo onomp Naropwarén onomp e fek ‘Ankank sápae’ ria kar toropwap napo te, mao yumwan fwap nénk naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yumo wokwaekia koropea oukoumwan nap te, onomp e fek onan ankank sámp mwaria kar toropwap moiapon. Oukoumwan te yumo ankár onan kar toropwapria te, yumo fwap sámpea warákár napo, am warákár te yiráp nɨnɨk mek top-pwarámp kari yak naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jisas warko sérrá, “Ono manénkɨr te yumwan te wounáp kar fek mámá kar sérariampon. Nánkár wakmwaek te ono yumwan warko wounáp kar fek sér mono. Yumwan te onomp Naropwaro i konámp nɨnɨk érik sénanampon. ");
INSERT INTO yuj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nánkár am ke fek ono te onomp Naropwarén sénanko, yumwan yaewour naenámp te yak mono. Am te apae riteanápe, yumo ankank sámp mwaria te, fwap yumoku kor onomp Naropwarén onomp e fek turunk mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Onomp Naropwaro námoku yumwan warákár námp te, apae riteanápe yumo onan nouroupria warákárria, wae ono Kwarént yakea ékamp méri yakáp napo námpon. ");
INSERT INTO yuj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Wokwaek te, ono onomp Naropwarént yakea, ono man pwarará apárok mapek ékampon. Aeampan oukoumwan te ono mámá apár má pwarará, onomp Naropwaronámpok arákarrá pok nae rae.” ");
INSERT INTO yuj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Aeránko maok, mao éréképea yárak i konámp arop fákárerao sérrá, “Tá kare, oukoumwan te amo wounáp kar sér mono, wae érik sénapon. ");
INSERT INTO yuj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Oukoumwan te yino amwan wae mér námpon, amo te nánkár aropao amwan turunkia napo, nopok sénaeria yépék mono. Amo ankank ponankor méri yak napon. Aenapara, yino kor amo Kwarént yakea ék nap wae mérámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Aerapo maok, Jisaso am fárákapamp kar pwarokwaprá sérrá, “Oukoumwan te yumo wae mér nap nie? ");
INSERT INTO yuj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yumo wawenk! Oukoumwan te ankank korop naenámp ke wonae fik kar námpon. Ye! Oukoumwan te wae korop námpara, yumwan ti yérépe napo, yumo ponankor ankákárankrá yiráp némpoukmwaek turukumpria onan pwate napo, onoku nápar yak nae rampon. Aenanampan maok, onoku nápar yak mono. Onomp Naropwaro onont yak námpon. ");
INSERT INTO yuj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ono yumwan má kar farákáp namp te, yumo onont koumpá yakápria yonkwae porokwe fek yakáp mwanapria nampon. Má apárok te yumwan nkwakwe make touwe korop naenámp yak námpan maok, yiráp nɨnɨk te fwapia kárákáre fek yakáp kip. Wawenk! Ono te mámá apár mekamp kárákáre te waeman kwe-pwar tenampon!” ");
INSERT INTO yuj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisaso mao éréképá yárak i konámp arop fárákapan kar farákápea pwarará maok, narek yámar mek tokoreyakrá arakrá sér, “Ayao, oukoumwan te wae yae faeane. Amo waráp Tárápan e tokwae érik yénkép napo, waráp Tárápao kuri amwan e érik yénkép naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Am te apae riteanápe, amo man tak naenámp kárákáre sánk napon. Amo man koumteouráp arop ponankor taokeyakria amo man nénknap arop fárákapan yiki yak nénkeanánko, yiki yaká yakáp mwanapria nánapi napono. ");
INSERT INTO yuj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tá am yiki yaká yakáp mwanap kwapwe te aráno: Am yiki yak sámpnap arop fárákap te amo ankárankampao saráp Kwar kare yak nap mér napon. Aeria maok, amo Jisas Krais sámp-kérép napo, ék námp mér napono. ");
INSERT INTO yuj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ono te amo onan, takrá téreaeria sápnap tére te wae térea pwar nampon. Am tak namp támao apárokamp aropan waráp e tokwae ntia kárákáre yénkép námpon. ");
INSERT INTO yuj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ayao, wokwaek kar má apár oukoumwan yak mo fek, ono amont yakamp fek te e tokwae sámp-fákeyakampono. Onomp nɨnɨk te, oukoumwan kor waráp wonae fik yak namp fek, onan am e tokwae sápaeria nae. ");
INSERT INTO yuj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Amo mámá apár mekamp arop onan sáp nap te, am fárákapan amo wanonorá te wae érik yénképá pwara nampon. Am arop fárákap warápan onan sáp nap te, waráp kar wae wawiaka fwap mántwaok yae-párák paokop napon. ");
INSERT INTO yuj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Oukoumwan te am fárákap kápae kare ankank amo onan ti-sáp nap te amonapoknámp korop námprá wae mér napon. ");
INSERT INTO yuj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kápae kare kar amo onan sáp nap te, ono wae am fárákapan farákáp nanko, sámpea karenoria mér napon. Wokwaek ono amont yakea nanko amo onan sámp-kérépapo ono ékampan kor, wae mér napon. ");
INSERT INTO yuj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ono am fárákapan yaewouriaka kar toropwap nampon. Ono te ponankor apárokamp arop fárákapan yaewourrá kar toropwap mono. Ono te amo onan sápnap arop fákáreran yaewourrá kar toropwap nampono. Am te apaeria námpanápe am fákáre te warápon. ");
INSERT INTO yuj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Onomp arop fárákap ponankor te waráp fárákapono. Tá waráp arop fárákap ponankor te onomp fárákapono. Tá arop fárákap am onomp fákáre táman nkeria onomp e sakap napon. ");
INSERT INTO yuj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ono te warko má apár mek yak nanamp pourou mono. Oukoumwan te ono wae amonapok aok nanampono. Aeno mámá fárákap te apárok yakáp mwanapon. Onomp yiki kare Ayao! Am fárákapan amokuráp kárákáre fek taokeyakampo. Aenapo maok, nomo ankárankamp yak nempnámp, am fárákapao kor ankárankamp kare yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ono am fárákapént yakria, man taokeyakamp te amo onan sápnap waráp kárákáre feki nampon. Ono fwapia am fárákapan yae-párák taokeyak nanko maok, am fárákap te ankwap ankárank moyak moimpon. Moyak naenámp arop ankárank mao saráp moyak tenámpon. Am tak namp te, waráp Buk fek yaknámp kar te kare korop námpon. ");
INSERT INTO yuj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Oukoumwan te ono amonapok aok naeria namp kwamp, oukoumwan ono apárok yak namp fek má kar séria nanko, onomp warákár am fárákapamp nɨnɨk mek top-pwarámpá yak naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Waráp kar onan sáp nap te, ono wae am fárákapan farákáp nampon. Ono má apár mekamp mo nampnámp, am fárákapao kor má apár mekamp mo napara, má apár mekamp arop fárákapao am fárákapan ampwae sámp napon. ");
INSERT INTO yuj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ono amwan kar toropwap namp te ‘Mámá apár pwarará éréképae’rá sér mono. Ono amwan kar toropwap namp te, amo am fárákapan taokeyak napo, arop kwatae am fárákapan sámpá yampourou mo naenámpan nampon. ");
INSERT INTO yuj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Am fárákap te onoku mámá apár mekamp mo nampnámp taknámp, mao kuri má apár mekamp mono. ");
INSERT INTO yuj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Waráp kar te ponankor kare karara, onomp nɨnɨk te amo am fárákapan yaewour napo, am kare kar kar am fárákapamp nɨnɨk mek tére nánko, waráp fákáre yiki kukur kare yakáp mwanapono. ");
INSERT INTO yuj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Amo wokwaek onan sámp-kérépapo, ono ékia, apárokamp koumteouráp arop ou mek yakampon. Táte taknámp ono kor amo onan sápnap arop fárákap tirá kérép nanko, tukupea apárokamp koumteouráp arop ou mek yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tá am fárákapan yaewour naenámp te onomp pourou ponankor waráp tére nanampria amwan sánk nampara, kare kar am fárákap te waráp tére mwanapria, ankár waráp arop fárákap kare yakáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Aeno ono kar toropwap namp máte am fárákapan saráp yaewour mono, arop am fárákapamp kar wawia onan mér mwanapan kor mént kar toropwap nampono. ");
INSERT INTO yuj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Onomp nɨnɨk te, am ponankor arop fárákap ankárankamp nɨnɨk fek onomp Ayao amo onont yak napo, ono amont yak namp niampi yakáp mwanapono. Tá taknámp am fárákap nomont ankárankamp kare yakáp napo maok, apárokamp arop fárákap amo onan sámp-kérép napo ék namp mér mwanapono. ");
INSERT INTO yuj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Amo onan kárákáre tokwae ntia wae kwapwe sáp nap te, ono kor am fárákapan nénk tenanko, nomo ankárankamp nɨnɨk fek yak nempnámp taknámp am fárákapao kor tak mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ono te am fárákapént yak nanko, tá amo onont yak napo, am nɨnɨk támao am fárákap ankárankamp nɨnɨk fek yakápanáponria nampon. Aenapo maok, am apárokamp arop fárákap amo onan sámp-kérépapo, ékamp mér napo maok, táte amo am onomp fárákapan warákár nap te amo onan warákár nap niamp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ayao, onomp nɨnɨk te amo onan sápap koumteouráp arop te am ono yak namp fek, mao kuri am fek onont yakáp mwanapria nampon. Tá am fárákap mámá apár oukoumwan yak mo fek, amo onan warákár tokwaeria, wae kwapwe ntiaka kárákáre tokwae sápap am nkeanáponoria nampon. ");
INSERT INTO yuj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yae-párák kare Ayao! Apárokamp arop fárákap te amwan mér mono. Aeno ono mwar amwan mér nampon. Tá mámá onomp fákáre te amo onan sámp-kérépapo ono ékamp te wae mér napon. ");
INSERT INTO yuj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ono amo te wanonorá am fárákapan wae yénkép nampon. Aenampara ono kánámpár warko yénkép nanko maok, amo onan warákár konapnámp taknámp am fárákapao arop ankwapan kor warákár mwanap nɨnɨk sámp mwanapon. Aenapo maok, ono kor fwap am fárákapént yak nae nampon.” ");
INSERT INTO yuj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisaso am kar toropwapia pwarará maok, mao ntia éréképá yárak i konámp arop fákáre ént kánanke Kidron tépéri pokea, ankwapmwae fik tankáp i konap yao pékri fek tankáp. ");
INSERT INTO yuj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Am Jisasén yopor aropamp yaek sánk naerianámp arop Judas mao kuri am yopwar wae mér. Am te apae riteanápe kápae kare por Jisas náráp arop fárákap érékép ko, tukupá am mek koupoukour konapara. ");
INSERT INTO yuj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ae konapara, Judaso Rom mekamp soldia érékép, tá pris tokwae fákáre ntiaka Farisi fákárerao tirá kérépnap plisman fákáre éréképea maok, am fek korop. Am fárákap te lam yaek ti, sarom poupounkia maok, yorowar i konap ankank tia korop. ");
INSERT INTO yuj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas te kápae kare ankank man korop naenámp te wae mérámp kwamp maok, youmprá wonae fikria am fárákapan turunkrá, “Yumo te wan oupourounk rape?” ");
INSERT INTO yuj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Aeránko maok, am fárákapao kar pwarokwaprá sérrá, “Yino te Nasaret mekamp Jisasén oupourounkrá koropreano.” Makrá sérapo maok, tá Jisaso am fárákapan sérrá, “Am te Ono Taki Yak konamp má támaono.” Judas am fárákapamp yaek Jisas sánk naerianámp te am fárákapént fokopeyak. ");
INSERT INTO yuj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Am fárákapao wa napo, Jisaso ‘Am te Ono Taki Yak konamp má támaono’rá sénánko maok, am fárákapao younkwe mwaeknámp érérékri tukupria maok, apárok pɨká pér. ");
INSERT INTO yuj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tá Jisas warko am fákáreran turunkrá, “Yumo te wan oupourounk rape?” Tá am fárákapao sérrá, “Yino te Nasaret mekamp Jisasén oupourounkreano.” ");
INSERT INTO yuj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisaso nopok arakrá sér, “Ono yumwan wae séri nampon: Am te Ono Taki Yak konamp má támaono. Yumo onan oupourounk nap kwamp te, mámá arop fákáre máte tukupanápon pwar kipo.” ");
INSERT INTO yuj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Am takrá sénámp nɨnɨk te mao manénkɨr sérinámp kar aran nɨnɨkria ninámpon, ‘Amo onan sápnap arop fákáre te ankwap ankárankamp moyak mono’rá sérimp kar mént pwi námpon. ");
INSERT INTO yuj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita bainat sankorop námp am yɨpi mekamp akaprá pris taokeyak konámp aropamp tére arop yae-párák mwaekamp woupwi kor porokwapea aop-sɨr. Am aropamp e te Malkusono. ");
INSERT INTO yuj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Aenko maok, Jisaso Pitan sérrá, “Bainat warko yɨpi mek kérépae. Amo nɨk nap te onan Ayao sápnámp kap mátane, am mek fár moaeria nape?” ");
INSERT INTO yuj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Aerá séránko maok, soldia fákáre, tá man taokeyak konámp arop, tá Judamp plisman fákáre, makia maok, Jisasén sámpeaka paok fek yarokwap. ");
INSERT INTO yuj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Aea maok, Anas Kaiafasomp wunápnáponámpok warámpá tukup. Am yopwar fek te Kaiafaso pris taokeyak konámp arop yak. ");
INSERT INTO yuj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafas te mao manénkɨr Juda fákáreran sérrá, ‘Ae te arop ankárankao mao saráp sumpwiaka koumteouráp arop fárákapan yaewourano’rá sérimp arop támaono. ");
INSERT INTO yuj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita ntia Jisas éréképá yárak i konámp arop ankwap Jisasén sámpá tukup napo wakmwaek akwap. Pris taokeyak konámp arop am arop ankwapan te man wae mér námpara, mao te Jisas youmpnámp yár mek am mek yoump. ");
INSERT INTO yuj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Aenámpan maok, Pita te yár younkwek wonae fik ménki fek fokopeyak. Aenánko am mént paokop i konap arop ankárank pris taokeyak konámp arop man mér námp támao youmpea, ménki taokeyak konámp yupuran séria, Pitan yár mek warámpá mank. ");
INSERT INTO yuj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aenánko maok, tá am ménki fek taokeyakámp yupurao Pitan turunkrá, “Amo te mént paokop i konap arop ankwap támao nie?” Aeránko maok, Pita sérrá, “Ono te méntér paokop i konap arop mono.” ");
INSERT INTO yuj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Aenánko maok, nkenko tére konap arop, tá plisman fákáre makia námpare nánko, yaomwi yankia pwatea am fek yae yérénkrá yakáp. Aenapo, Pita kor youmpea am fárákapént yae yérénkrá yak. ");
INSERT INTO yuj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pris taokeyak konámp arop Jisasén mént paokop i konap aropan mér nae yonkwaerá turunkria maok, maomp kar am arop fárákapan sérarimp kar mént turunkup. ");
INSERT INTO yuj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Aenánko maok, Jisaso maomp kar pwarokwaprá arakrá sér, “Ono koumteouráp arop fárákapan te érik karaok kar yénkrá farákápampono. Kápae kare por koumteouráp aropan lotu nap mek, tá lotu nap tokwae yár mek kápae kare Juda fákáre koupoukour konap fek ono am fárákapan yénkrá farákáp namp te, kar ankwap mek wouroumprá sér moi nampon. ");
INSERT INTO yuj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aenamp te amo apaeria onan turunk rap? Amo ankár am kar wawi konap arop fárákapan turunkupae! Am fárákap te ono farákápnamp kar wae méri yakáp napon.” ");
INSERT INTO yuj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas takrá séránko maok, am fek fokopeyakeanámp plisman ankwapao Jisasén yae faeran táraporeria maok sérrá, “Amo te apaerá pris taokeyak konámp arop tokwaeran takrá kar pwarokwaprá sér rape?” ");
INSERT INTO yuj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisaso man nopok sérrá, “Ae te ono kwatae kar sénanko te, amo am ono kwatae kar sénamp érik sérae. Aeno táte ono kwapwe kare kar sénamp te, amo apaerá onan porokwap rap?” ");
INSERT INTO yuj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Takia maok, Anas Jisasén yarokwap nap taki yak nánko, make pris taokeyaknámp arop Kaiafasnámpok sámp-kérép. ");
INSERT INTO yuj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita yae yérénkrá yakánko maok, am fárákapao man sérrá, “Amo kor mént yárak i konap arop támao nie?” Tá mao sérrá, “Mono. Ono te mono!” ");
INSERT INTO yuj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Aenámpan maok, pris taokeyak konámp aropamp tére arop te Pita woupwi kor porokwap aop-sɨrarinámp aropamp ankárankamp fi aropara, man sérrá, “Ae te ono amwan mént yakepo yopwaraok nkeamp támao nie?” ");
INSERT INTO yuj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Aeránko Pita warko sérrá, “Mono.” Aeránko maok, am ke fek táman kakaruk fárámp. ");
INSERT INTO yuj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Koumounek kar Jisasén Kaiafasomp nap mekamp gavman taokeyaknámp aropaonámpok warámpá tukup. Aea maok, am fárákap te Kwaro nke námp fek Pasova fári konap yae fek oum sámpantánoria ankwap fi aropamp nap mek yink mo, ek yakáp. ");
INSERT INTO yuj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Am fárákap ek yépékrá yakáp napo, Pailato mankea am fárákapan turunkrá, “Yumo mámá aropan apae tenánko kot mwaria nape?” ");
INSERT INTO yuj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aeránko maok, am fárákapao sérrá, “Má arop te sokoro mo, yae-párák kare nánko te, amonapok warámpá korop mono.” ");
INSERT INTO yuj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Aerapo maok, Pailato am fárákapan sérrá, “Ae te yumoku warámpá tukupea yumokuráp lo fek man kotenk.” Aerá séránko maok, Juda fákárerao nopok man sérrá, “Rom yiráp loao arop ankwapan sámp-wouroump kwaponorá námpon. Aeria námp kwamp, yino man amonapok warámpá korop námpono.” ");
INSERT INTO yuj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Am tak nap te Jisaso wokwaek apae mwae fek námo sumpwi naenámp nɨnɨkan sérimp, am ankank te wae kare korop naeria námpon.) ");
INSERT INTO yuj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tá Pailato warko arákarrá nap mek youmpea maok, Jisasén mankaeria maok, man turunkrá, “Amo te Juda firamp King nie?” ");
INSERT INTO yuj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Aeránko maok, Jisaso maomp kar pwarokwaprá sérrá, “Ae te amoku támao nɨnɨkia am kar sér rape, arop ankwapao amwan onan takrá séri nap nie?” ");
INSERT INTO yuj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aeránko maok, nopok Pailato sérrá, “Ae te ono te Juda fi mekamp nie? Amoku yaknap fi mekamp arop ntia pris tokwae fákáre amwan ononampok warámpá korop napon. Amo te apae mokopi napon?” ");
INSERT INTO yuj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aeránko maok, Jisaso sérrá, “Onomp firáp taokeyak nanamp te mámá apár mekamp mono. Táte onomp firáp taokeyak konamp mámá apár mekampaonánko te, onomp arop fákáre fwap yorowar napo, arop ankárankamp onan Juda fárákapamp yaek pap mono. Aeno onomp firáp taokeyak nanamp te mámá apár mekamp mono.” ");
INSERT INTO yuj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Aeránko maok, Pailato man sérrá, “Tak napan nánko te, amo te King nie?” Jisaso nopok man sérrá, “Amo ‘King’rá sénap te amoku támao sénapon. Ono má apár mek ék nanko, onomp éntupwar onan fárákap námp te onomp ankárankamp tére te, arop fárákapan kare kar kar farákáp nanko, wa mwanapria ninampon. Tá arop ponankor am kar kare wawia ampaok paokop nap te, am fárákap onomp kar wawi konapono.” ");
INSERT INTO yuj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mak ránko maok, Pailato man turunkrá, “Kare kar kar te apae ankankono?” Makrá séri pwarará warko apárok youmpea maok, Juda fákáreran sérrá, “Ono te ‘Mao sumpwiano’rá sénanamp fi te mér mo rae. ");
INSERT INTO yuj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Aeno ono i konamp nɨnɨk te wae mér napono. Yopwar méntép lotu i konap Pasova Yae Tokwae fek arop ankárank kalabus mekamp yumoku am arop e sénapo, man yumonapok sámp-kérép konampono. Ae konampara, yiráp nɨnɨk te mámá Juda fákáreramp king man yumonapok sámp-kérép nanamp nie?” ");
INSERT INTO yuj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tá am fárákapao warko tékén sérrá, “Mao te mono! Amo ankár Barabasén aokor-pwarae!” (Barabas te arop tirá wourrá yárakrá am fárákapamp yaekamp ankank pouroukoup konámp aropono.) ");
INSERT INTO yuj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pailato séránko maok, soldia fákárerao Jisasén sámpea ain tákáre tokoropramp paok fek paonkore kor fek fuk. ");
INSERT INTO yuj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aea pwarará maok, am soldia fákáre wiráp paok sámpea moukoupea, kingo yirɨmp konámp kumpan erékáprá Jisasomp me korok yirɨmp. Aeria maok, waempyam noumouri sámpea kingo yirɨmp konámpan erékáprá maomp pourouk aowarámprá yirɨmpá pwar. ");
INSERT INTO yuj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Aea maok, maomp wonae fik ankákáranki tukuprá man sérrá, “Yo...! Juda firamp King e!” Aeri ko man yae faeran tárapore. ");
INSERT INTO yuj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat warko apárok youmpea maok, Juda firan sérrá, “Yumo nkenke! Ono man yumonapok warámp sa-mank namp te, ono maoinámp ankank nke mo namp aran mérenkria nae.” ");
INSERT INTO yuj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jisas ek mank námp te, maomp me korok yirɨmp, nap wiráp paok te oukoumwan taki yak, tá waempyam noumouri yirɨmp napao kor taki yak. Aenánko maok, Pailato am arop fákáreran sérrá, “Má arop man nkenke!” ");
INSERT INTO yuj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aeránko maok, pris tokwae fákáre, tá lotu nap tokwae mekamp plisman fákáre mao man nkea tékén sérrá, “Yaopwae porokopramp fek pukupenke! Yaopwae porokopramp fek pukupenke!” Aerapo maok, Pailato am fárákapan sérrá, “Ae te yumoku man santukupea yaopwae porokopramp fek pukupenke! Ono te maoinámp ankank nke mo nampono.” ");
INSERT INTO yuj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aeránko maok, Juda fákárerao maomp kar pwarokwaprá sérrá, “Yinomp lo ankwap yak námp te am loao sérrá: Mao ‘Námo Kwaromp Tárápono’rá sénámp te, mao te ankár sumpwi naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailato am kar wawia apápa wae. ");
INSERT INTO yuj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Aeria mao warko nap mek youmpria maok, Jisasén turunkrá, “Amo te mae némpoukampono?” Aeránko maok, Jisas te maomp kar pwarokwaprá sér mo. ");
INSERT INTO yuj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Aenko maok, Pailato man sérrá, “Amo onan kar pwarokwaprá sénanap te apaeritea napon? Ono te arop tokwae ara, amwan fwap pwar nanamp, tá amwan fwap ‘Yaopwae porokopramp fek pukupenk’rá sénanampon. Ae te amo am te mér mori kwapon?” ");
INSERT INTO yuj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tá Jisas maomp kar pwarokwaprá sér, “Kwaro amwan kárákáre sánk mo nánko te, amo onan apárok sámp-anámp nanap pourou mono. Aenámpara, arop onan waráp yaek sánknámp aropamp kwatae nɨnɨk te waráp kwatae nɨnɨkan kámákarea tokwae kari yak námpon.” ");
INSERT INTO yuj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailato am kar wawia maok, man pwar nae yonkwaerá mwae kup oupourounk. Aenámpan maok, Juda fákáre man kar tae fek sérrá, “Amo am aropan sámp-kérépea te, amo te Sisaromp nouroup mono! Aropao sérrá, ‘Onoku kingono’rá sérámp te mao te Sisarén ampwae-sámpnámp aropono.” ");
INSERT INTO yuj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailato am kar wawia maok, Jisasén ek warámpá youmpea kaerikamp kot i konap sia fek tank. (Am kaerik e te ‘Yumwi fekamp Kaerik.’ Judamp Hibru kar fek sér i konap te ‘Gabata’.) ");
INSERT INTO yuj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Am Yae Tokwae te Pasova fár mwanap fɨr nánap i konap yae fek maok, yámar kukánko Pailato Juda fákáreran sérrá, “Yiráp king má nkenke.” ");
INSERT INTO yuj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aeránko maok, kápae kare ou aropao tae fek sérrá, “Sámpá tukupenke! Sámpá tukupenke! Yaopwae porokopramp fek pukupenke!” Pailato am fárákapan sérrá, “Yumo te onan yiráp king ‘Man yaopwae porokopramp fek pukupenk’rá séraeria nape?” Aeránko maok, pris tokwae fákárerao sérrá, “Yino te king ankwap te yak mono! Yinomp king te Sisar ankárank támao mwarono!” ");
INSERT INTO yuj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aerapo maok, Pailato Jisasén am fárákapamp yaek sánk nánko, pukup mwarea napon. Aea maok, am fárákap Jisasén warámpeaka tukup napo maok, ");
INSERT INTO yuj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisas námoku námwan pukup mwanap yaopwae kakapeanánko, am taun pwarará tukupea apár ankwap, ‘Arop Me Kor Yaknámp Apár’rá sér i konap, tá Hibru kar fek te ‘Golgota’rá sér i konap fek. ");
INSERT INTO yuj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Am fek táman arop yaworan fápae yawor pukupria maok, Jisasén kuk pukupapon. ");
INSERT INTO yuj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailato sénánko, am fárákap kar ankárank kumwia yaopwae porokopramp fek Jisasomp me kor yarápae fek tɨrɨri pwar. Am kar te arakrá kumwi napono: “Mámáte Nasaret mekamp Jisas, Juda firamp Kingono.” ");
INSERT INTO yuj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Am kar te Hibru kar, tá Rom kar, tá Grik kar makia am fek kumwiapono. Am Jisasén pukupap apár te taun wonae fik yak námpara, kápae kare Juda koropea am kar nkerá farákáp konapono. ");
INSERT INTO yuj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Aenapo maok, Juda firamp pris tokwae fákárerao Pailatén sérrá, “Amo te ‘Juda Firamp King’rá kumwi kwapono. Amo ankár ‘Mámá arop te “Námo Juda Firamp King”rá sénámp’rá kumwi mpupo.” ");
INSERT INTO yuj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Aerapo maok, Pailato sérrá, “Wampweno! Kar ono kumwi tenamp am támao yakano!” ");
INSERT INTO yuj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldia fákáre Jisasén yaopwae porokopramp fek pukup tea maok, mao yirɨr i konámp ankank ponankor tia maok, yiawor fi kákea maok, táte am soldia fákáre ankákárankrá tiapono. Aeno ankárank mwaek saráp wouriramp waempyaman kor sámpea, ");
INSERT INTO yuj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","soldia fákáre námoku sérarrá, “Mámá te pápaeri kwapono! Nomo satu pilairiaka wa mokop kárákáreria sámpén nke mwanámpon.” Am takiap te, Kwaromp Buk fek wokwaek kumwiap kar kare korop námpon. Am kar te arakrá sér, “Arop fárákapao ono yirɨr i konamp ankank tia nénk napo mao ti mwanapon. Tá onomp waempyam sámp naenámp arop nke mwaria satu pilai mwanapon.” Am soldia tak nap te, am kar wae mént pwi námpon. ");
INSERT INTO yuj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tá Jisasomp éntupwar ntia maomp nánaenáp Maria Klopasomp yupuia maok, Makdala mekamp Maria, am koumteou támao Jisasén yaopwae porokopramp fek pukup tenapo, wonae fik am fek foukouri yakáp. ");
INSERT INTO yuj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Aeapo maok, Jisaso náráp éntupwar ntiaka mao nouroup kare i konámp arop wonae fik foukouri yakepo, éntupwarén sérrá, “Ayae, támáte waráp tárápono.” ");
INSERT INTO yuj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tá mao am námoku warákár konámp aropan sérrá, “Támáte waráp éntupwarono.” Aeránko maok, am ke fek táman am aropao Jisasomp éntupwarén warámpá akwapea námokuráp nap mek taokeyak. ");
INSERT INTO yuj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas te maomp tére ponankor wae oukoumwan pwar námp mér. Tá mao sérrá, “Onan éntao oumpour kor kákeane.” Am takrá sénámp te, Kwaromp Buk fekamp kar ankwap méntér pwi námpono. ");
INSERT INTO yuj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Farákére mek top i konámp wain tankánko maok, yao yir niamp am mek anámp napo, am top i konámp wain am mek pwarámpeyakánko maok, yaopwae hisop fek norokarea Jisasomp táp mek sánk. ");
INSERT INTO yuj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas am top i konámp wain fária pwarará maok, mao sérrá, “Wae táman pwar nae rae.” Makrá séria pwarará maok, me fɨkɨprá waemp worokwaprá sámp-kéréprá wae sumpwi. ");
INSERT INTO yuj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Am yae te Pasova fár mwanap nánap mwanap yaenono. Am Sabat Yae te tokwae karara, Juda firamp nɨnɨk te arop yákáre yaopwae porokopramp fek Sabat yae fek yakantáno. Aeria maok, Pailatén sérrá, ‘Pu kor tokoprá párakopea napo, koupour surumpwi napo am yákáre tirá épér mwar’rá sér. ");
INSERT INTO yuj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aerapo maok, soldia fákárerao tukupea Jisasént pukup tariap arop yaworamp pu kor tokoprá kák. ");
INSERT INTO yuj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Aenapao maok, Jisasén te tukupá nke napo maok, wae sumpwi yak. Aenámpantá maok, pu kor ták-pap moiapono. ");
INSERT INTO yuj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Aeno soldia ankárankao oump fek amor fárákap mek faropánko maok, koupour kar yɨri ntiaka ént kwarákár ék. ");
INSERT INTO yuj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Arop am kar farákáp námp te, am te wae nke tari námpan farákáp námpon. Aenámpara, mao farákápnámp kar te kare karono. Mao námoku kor am kar te karenorá mér námpon. Aenámpara, yumo kor fwapia mér kipo.) ");
INSERT INTO yuj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Am takiap ankank te Kwaromp Buk fekamp kar kare kar korop námpon. Am kar te arakrá sénámpon, “Maomp kour ankwap ták-pap mo mwarea napon.” ");
INSERT INTO yuj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tá Kwaromp Buk fekamp kar ankwap sérrá, “Arop fárákap am faropnap aropan tokore yakáp mwaria napon.” ");
INSERT INTO yuj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Takia pwate napo maok, Arimatea mekamp Josepo Pailatén sérrá, “Ono Jisasomp yákáre sámp nae.” Am Josep te Jisasomp firápao maok, Juda firan apápia maok, kánánkámp mérrá yárakimpon. Aempao maok, Pailato takaeránko, Josep akwapea Jisasomp yákáre sámpámpon. ");
INSERT INTO yuj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, manénkɨr Jisasén kumuruk koropá nkemp, mao kuri méntér korop. Mao te yao yɨri anánk aopwe ankára mek tapokwapeakámpan sankorop. ");
INSERT INTO yuj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Maomp kápae te 30 kilogram. Am arop yaworao Jisasomp yákáre sámpea maok, Juda firao arop papria nánákáre kwapwenámp ankankan forokwap konapnámp takrá forokwapea maok, waempyam mek papea yarokwap. ");
INSERT INTO yuj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Am Jisasén yaopwae porokopramp fek pukupap fek te yopwar ankárank am fek yak. Aenánko, am yopwar mek te péri me wourékam yoroia napao, oukoumwan arop yákáre pap moinap yak. ");
INSERT INTO yuj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Juda firao Pasova fári konap kumur wae wonae fik námpantá, am arop yawor koupour kar Jisasomp yákáre sámpá akwapea wonae fik yaknámp am péri kor mek pap. ");
INSERT INTO yuj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande fek oukoumwan kɨrɨkɨp yakánko, koumounek kar Makdala mekamp Maria koropeaka, péri me nke nánko maok, péri kárakére ménki fek yak mo. ");
INSERT INTO yuj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aenánko maok, mao fárakoprá akwapea Saimon Pita, tá ankwap Jisaso man nouroup kar i konámp, am arop yaworan sérrá, “Tokwae Karamp yákáre te arop fárákapao péri me mekamp te wae sámp te nap te, nomo mér mono. Maok sámpá tukupá páte nape?” ");
INSERT INTO yuj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Aeránko maok, Pita ntiaka am Jisaso warákár konámp arop taun pwarará énénkér péri me fek akwap. ");
INSERT INTO yuj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Am arop yawor énénkér fárakoprá akwapepao maok, ankwap Jisaso warákár konámp aropaomékɨr akwapá péri me fek. ");
INSERT INTO yuj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Aea maok, mek pɨk mono, péri me fek saráp tankria papeyakrá nke nánko maok, waempyam mwar tank. ");
INSERT INTO yuj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita maomp wakmwaek korop námpao maok, péri me mek youmpea nke nánko maok, waempyam ankwap mwar tankáp. ");
INSERT INTO yuj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tá nke nánko, Jisasomp me korok woukoupap waempyam ankwapao kor me kor papámp yarápae fek aropao moukoupea papnap niampi tank. ");
INSERT INTO yuj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Aenko maok, manénkɨr akwapeakámp am Jisaso warákár konámp aropao kor mek yoump. Tá mao kor am ankank nkea wae mér. ");
INSERT INTO yuj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Am ke fek te am fárákap te Kwaromp Buk fekamp kar Jisas apár me meknámp fárámp naenámpan sénámp kar te oukoumwan fwapi mér mono.) ");
INSERT INTO yuj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Aea maok, am Jisasént yárakep arop yawor warko némpouk arákarrá akwap. ");
INSERT INTO yuj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria ek péri me táp fek fokopeyakrá maok, émrá yakria tank-kékiráprá péri me mek nke. ");
INSERT INTO yuj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Aeriaka nke nánko maok, ensel anánkaopwe waempyam wupwiráp am Jisasomp yákáre pátariap fek am fek tankria maok, ankwapao me kor tankámp fek tank, tá ankwapao puyar sɨrarámp fek tank. ");
INSERT INTO yuj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aeria maok, am ensel yaworao Marian sérrá, “Yupu! Amo te apaeritea ém rape?” Aerepo maok, mao am arop yaworan sérrá, “Onomp Tokwae Karamp yákáre sámp tenap te, ono mér mono. Maok samp-tukupá páte nape?” ");
INSERT INTO yuj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Makrá séria pwarará maok, arákarrá nkenko maok, Jisas fokopeyak. Aempan maok, Maria te máte Jisas támaonorá mér mono. ");
INSERT INTO yuj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Aeránko maok, Jisaso man sérrá, “Yupu! Amo te apaentá émrá yárak rape? Amo te wan oupourounk nae rape?” Aeránko maok, Mariamp nɨnɨk te, am arop te yopwar taokeyak konámp arop ritea man sérrá, “Arop Tokwae, amo te man sámpá akwapea pap nap kwamp te, onan am pap nap sénapo, ono akwapea warko sámpá korop nae.” ");
INSERT INTO yuj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Aeránko maok, Jisaso man sérrá, “Maria.” Aeránko maok, Maria sámp-arákarrá man Hibru kar fek sérrá, “Rabonai!” (Am kar te ‘Tisa’rá sénámpon.) ");
INSERT INTO yuj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Aeránko maok, Jisaso man sérrá, “Ono te oukoumwan narek onomp Naropwaronámpok pok mo nampara, amo onan sérémékéri kwapono. Aeno amo ankár akwapea onomp nánaeounáp fárákapan arakrá sérampo, ‘Ono te narek pokria, onomp Naropwar, tá yumo kor yiráp Naropwar maonámpok pok rae. Tá onomp Kwar, tá yumo kor yiráp Kwar, maonámpok pok rae.’” ");
INSERT INTO yuj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Aeránko maok, Makdala mekamp Maria akwapea mént paokop i konap arop fákárean sérrá, “Ono te Tokwae Karan nketea korop rae.” Aeria maok, Jisaso sérimp kar am fárákapan farákáp. ");
INSERT INTO yuj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jisasént paokopiap arop fárákapao Juda taokeyakáp konap fákáreran apápriaka mao yakápnap nap ménki kárákáre fek kéritea yakáp. Am Sande fek táman wae yámar porokor nánko, kumur mek Jisas koropeaka kuk mek fokopeyak. Aeria maok, mao sérrá, “Yiráp nɨnɨk te sánánkar porokwe fek yakano.” ");
INSERT INTO yuj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aerá séria pwarará maok, náráp yaekamp nil toupou, tá amor fárákap mekamp oump toupou yénkép. Am arop fárákap Tokwae Karan nkea am fárákapamp nɨnɨk mek te warákáránka wae. ");
INSERT INTO yuj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Aenapo maok, Jisaso warko sérrá, “Yiráp nɨnɨk te sánánkar porokwe fek yakano. Onan te onomp Naropwaro sámp-kérépánko koropampnámp taknámp, ono kor yumwan tirá kérép nanko, tukup mwanapono.” ");
INSERT INTO yuj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Makrá séria pwarará maok, mao táp meknámp náráp ouwipár am fárákapan fori pwarará maok, mao am fárákapan sérrá, “Yumo Yiki Kor Spirit yiráp nɨnɨk mek akwapano sámpenke.” ");
INSERT INTO yuj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Aeria maok, sérrá, “Yumo arop ankwapamp kwatae nɨnɨk sámp-sɨnapo te, Kwaro kor am fárákapamp kwatae nɨnɨk sámp-sɨnánko, moyak naenámpon. Aeno yumo arop ankwapamp kwatae nɨnɨk sámp-sɨr mo nap te, Kwaro kor am aropamp kwatae nɨnɨk sámp-sɨr mono.” ");
INSERT INTO yuj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisaso am fárákapaonapok koropámp ke fek te, arop éntér-sámpramp ou mekamp ankwap ankárank te am ke fek yak mo. Am arop te Tomas, ankwap e te ‘Tam Feae’rá sénapono. ");
INSERT INTO yuj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Wakmwaek am fárákap man sérrá, “Yino wae Tokwae Karan nke námpon.” Aeránko maok, Tomaso am fárákapan sérrá, “Táte ono maomp yaekamp nil toupou nke mo, tá onomp yae kurépi am nil toupou mek norokor mo, táte ono maomp amor fárákap mekamp oump toupou mek yae pap mo namp fek te, ono te kare sénapria mér mo kareno.” ");
INSERT INTO yuj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Warko ankwap Sande fek, am arop fárákap am nap mek am mek yakáp napo, Tomas kor méntér yak. Aeria maok, am fárákap ménki ponankor kárákáre fek kákari pwatea yakáp. Aenapo, Jisas mankea kuk mek fokopeyakria sérrá, “Yirɨp nɨnɨk te sánánkar porokwe fek yakano.” ");
INSERT INTO yuj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Aeritea yakrá maok Tomasén sérrá, “Amo waráp yae kurépi onomp yae kwae mek mamek fokopria onomp yae nkeae. Tá amo koropea onomp amor fárákap mek yae papae. Amo te anánk nɨnɨk pwarará, ankár mérae!” ");
INSERT INTO yuj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aeránko maok, Tomaso maomp kar pwarokwaprá arakrá sér, “Amo onomp Tokwae Kar, amo onomp Kwarono!” ");
INSERT INTO yuj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Aeránko maok, Jisaso man sérrá, “Amo te onan nkeaka mér rape? Arop fárákap onan oukoumwan nke mo yakáprá mér nap, am arop fárákapan te Kwaro ourour nénk naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisaso Kwaromp kárákáre yénképnámp kápae kare ankank námoku éréképá yárakimp aropao nkeap fek yoroimp te, ono te am ankank te má buk fek mapek ponankor kumwi mono. ");
INSERT INTO yuj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Aeno ono mámá kar kumwi namp te, yumo Jisasén méria, mao te Krais, mao te Kwaromp Táráponorá mér mwanapria kumwi nampon. Yumo man mérria te, maomp e fek táman yiki yak sámp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jisaso warko wakmwaek ént aokore Galili, ankwap e Taiberias wonae fik, námoku éréképá yárak i konámp arop fárákapan akwapá kɨkɨp. Mao am arop fárákapaonapok akwapámp te ará: ");
INSERT INTO yuj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (Ankwap e te Tam Feae), apár Galili mek Kana mekamp Nataniel, tá Sebedimp tárápyar, tá Jisasént paokopiap arop ankwap anánkaopwe énénki am fek yakápapo maok, ");
INSERT INTO yuj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita am fárákapan sérrá, “Ono te akwapea éntékamantá umben sɨnae.” Tá am fárákapao man sérrá, “Yino kor amont énénki tukup mwaro.” Aenapao maok, am kumuruk te éntékam ankárankamp sámp mono. ");
INSERT INTO yuj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Aenapo maok, koumounek yámar aok naeria nánko, Jisas ént woupwi mek fokopeyak. Aenánko maok, am arop fárákap mao te Jisasonorá mér mo. ");
INSERT INTO yuj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Aenapo maok, Jisaso am fárákapan arakrá turunk, “Tárápu o! Yumo te éntékam wae sámp máki nape?” Aeránko am fárákapao sérrá, “Mono.” ");
INSERT INTO yuj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aerapo maok, mao am fárákapan sérrá, “Yumo umben sámpea bot tank námp fek yae-párák mwaek sɨrenke. Yumo fwap ankwapmwaek ti mwanapono.” Aeránko am fárákap umben am mao sénámpaok sɨrapo maok, éntékam pɨk te mákia kápae karenko maok, mokopia narek forokwaprá saok mwarria kounkour. ");
INSERT INTO yuj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mént paokopiap arop Jisaso man warákár konámpao Pitan sérrá, “Am te Tokwae Kar támaoiane!” Saimon Pita waempyam wor-pátea térerá yárakimpao wa nánko ‘Mao te Tokwae Karono’rá sénámpantá maok, warko waempyam kámpea ént mek fékér-pɨkia maok, érrá akwap. ");
INSERT INTO yuj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Aenánko, am ankwap fákáre bot meknámp ént woupwi mek panek tae morok 90 mita fek yakápria, éntékamráp umben am éréképrá koropea kárákáre fek pap. ");
INSERT INTO yuj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Am fárákap wae koropea kárákáre fek yakápria maok, nke napo yaomwi yak. Tá am yaomwi mek éntékam tank nánko, panao kor tank. ");
INSERT INTO yuj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Aenánko maok, Jisaso am fárákapan sérrá, “Éntékam ankwap am sankoropenke.” ");
INSERT INTO yuj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aeránko maok, Saimon Pita bot mekamp am umben éréképea koropea kárák fekánko maok, éntékam kápae kare nununkwi te kouroump napo te, 153 nono. Aenámpao maok, am umben te fárákár moimpon. ");
INSERT INTO yuj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Aenko maok, Jisaso am fárákapan sérrá, “Yumo koropea fárenke.” Aeránko maok, am fárákap te apápia ‘Amo te wanap?’rá turunk mo. Am te am fárákap wae mér, mao te Tokwae Kar támaono. ");
INSERT INTO yuj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tá Jisas yaomwi fek wonae fik youmpea, pan sámprá am fárákapan nénkea pwarará, tá warko éntékaman kor sámpea am fárákapan nénk. ");
INSERT INTO yuj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mámáte Jisaso apár me meknámp fárámpea yárakria mao éréképá yárak i konámp arop fárákapan yinɨnkan koropá nkemp karono. ");
INSERT INTO yuj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mao wae fépéria pwarará maok, tá Jisaso Saimon Pitan sérrá, “Jonomp táráp Saimon e! Amo te onan nouroup kare nap te, arop ankwapao onan nouroup námpan kwe pwar nap nie?” Aeránko maok, Pita man sérrá, “Yeno, Tokwae Kar, ono amwan nouroup namp wae mér napon.” Mak ránko maok, Jisaso man sérrá, “Ae te amo onomp sipsip morok fɨr wunampo!” ");
INSERT INTO yuj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tá warko anánkan man sérrá, “Jonomp táráp Saimon, amo te onan nouroup kare rape mo nie?” Aeránko maok, Pita man sérrá, “Yeno, Tokwae Kar! Amo te wae mérapon, ono amwan nouroup nampon.” Aeránko maok, Jisaso man sérrá, “Ae te amo onomp sipsip anképe fákáre taokeyakampo.” ");
INSERT INTO yuj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tá Jisas warko yinɨnkan turunkrá, “Jonomp táráp Saimon, amo te onan nouroup rape?” Aeránko maok, Pita námwan yinɨnk por sérámpantá pwarápaerá nɨnɨk tokwaeria Jisasén sérrá, “Tokwae Kar, amo te kápae kare ankank te wae ponankor mér napara, ono amwan nouroup nampan kor wae mér napon.” Aeránko maok, Jisaso man sérrá, “Ae te amo onomp sipsip anképe fákáre wunampo. ");
INSERT INTO yuj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ono waeman amwan kare kar sér rae: Amo oukoumwan tár-ménki fek te amoku amokuráp sépér fákapea amoku akwap nae rap mwaek yáraki napono. Aeno nánkár wakmwaek amo wae mér pourou nap fek te waráp yae kor narek kakap napo, arop ankwapao amwan sépér fek fákapea sámpeaka amo akwap mo naenap mwaek santukup mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jisaso má kar makrá sérimp te nánkár Pita mokoprá sumpwiria Kwarén e tokwae sánk naenámpan nɨnɨkrá sénámpon.) Tá Jisas warko Pitan sérrá, “Amo te onomp wakmwaek koropampo.” ");
INSERT INTO yuj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita sámp-arákarrá Jisaso nouroup kar i konámp aropan nke nánko maok, maomp wakmwaek korop. Am arop te wokwaek Jisasént tankáprá fárap ke fek maomp wonae fik éntér kor fek me kor woukouprá, ‘Tokwae Kar, amwan te wa yopor aropamp yaek pap naenámpono?’rá turunkimp arop. ");
INSERT INTO yuj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita man nkea maok, Jisasén sérrá, “Tokwae Kar e, mámá arop te mokop naenámpon?” ");
INSERT INTO yuj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Aeránko maok, Jisaso man sérrá, “Waráp ankankanápe? Ono man takanoria nanko te, mao fwap yakrá akwapea, ono arákarrá ék namp fek naenámpon. Aeno amo te onomp wakmwaek koropae!” ");
INSERT INTO yuj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aeránko maok, am kar yárakánko maok, táte am mént yárakimp arop te sumpwi mo, yak naenámpan mpwe yonkwaeapon. Aeno Jisas man te ‘Sumpwi mo, yak naenámp’ karan sér mono. Mao sénámp te, ‘Ono takanoria nanko, mao yakrá akwapea, ono arákarrá ék namp fekanoria nanko te, am te waráp ankank ni?’rá sénámpon. ");
INSERT INTO yuj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Am arop támao oukoumwan mao am ankank táman farákápria mámá kar kumwi námpon. Tá nomo wae mér, am kar mao farákáp námp te kare karono. ");
INSERT INTO yuj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisaso térenámp te kápae kare ankwap ankankao kor yak námpon. Aeno táte arop fárákap am ankank ankákárank ponankor kumwia naporia te, nomo am kápae kare buk kák mwanámp apár yak mo naempon. ");
INSERT INTO yuj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","lTiofilus, ono am buk wokwaek kar kumwiamp te Jisaso wokwaek nkwakwe make tére fi yokarea koumteouráp aropan farákáprá koropea, ");
INSERT INTO yuj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","oukoumwan mámá yae fek nánko, Kwaro yámar mek warámpá poknámp karan sámpea maok, warko kumwi nampon. Mao te manénkɨr fárámpea yiki yakria maok, aposel fárákapaonapok koropámpon. 40 yae fek am fárákapao man nke napo, mao am fárákapan Kwaro náráp fi taokeyak konámpan farákáp. Tá nkwakwe make ankank yénk nánko, am fárákap mao te wae kare kar yiki yak námp mér kare napono. Aenapo am aposel fárákap te mao námoku nánkáráp tari námpan mao am fárákapan Yiki Kor Spiritamp kárákáre fek nkwakwe make tére mwanap kar sérianánko, wakmwaek Kwaro man warámpea narek pok námpono. ");
INSERT INTO yuj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mao oukoumwan am fárákapént yakámp fek te, mao sérrá, “Yumo te Jerusalem pwar kwapono, am mek yakáprá, onomp Naropwaro yumwan sánk nanamprianánko, ono yumwan wokwaek sériamp ankank táman yépék kip. ");
INSERT INTO yuj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon te kápae kare koumteouráp aropan ént fek nérrá kákámpono. Aeno oukoumwan yaeamp mo nánko, Naropwar Kwaro Yiki Kor Spirit fek yumwan nérrá kák naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Am ke fek am fárákap Jisasént koupoukour yakápria, Jisasén turunkrá, “Tokwae Kar, amo Israel fi warko fwapokwapia napo, mao warko apár-apár arop fi ponankor taokeyakáp mwanap ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Aerapo maok, Jisaso am fárákapan kar pwarokwaprá sérrá, ‘Kwar te yumwan, am ke ntia am yae papnámp mérenkria mono. Mao námoku am ankank poukwap námpon. ");
INSERT INTO yuj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aeno nánkár Yiki Kor Spiritao ékia yiráp pourouk noumpoukoupea yak nánko, yumo am fek kárákáre sámp mwanapon. Aeria maok, yumo onoinamp karan tukupea Jerusalem mek farákáp, tá Judia mekmwaek ponankor, tá distrik Samaria mekia maok, apár-apár ponankor tukupria maok, nkwakwe make tére nanko yumo nkeap, tá nkwakwe make kar farákáp nanko yumo wawiap, am táman farákáp kip’rá sérimpon. ");
INSERT INTO yuj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Am kar farákápeaka pwaránko, am fárákapao foukouri yakáprá tokoreyakáp napo maok, mao yámar mek poká pokea koumwe wupwi mek papár nánko maok, warko man nke mo. ");
INSERT INTO yuj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mao pok tenánko, am fárákap yámar mek tokoreyakáp napo, koupour kar waempyam wupwiráp arop anánkaopwe am fárákapént foukouri yak. ");
INSERT INTO yuj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aeria maok, am arop yaworao sérrá, “Galili mekamp arop fákáre, yumo te apaeritea foukouri yakáprá yámar mek tokoreyakáp rape? Am Jisas te oukoumwan waeman yumwan pwarará, Kwaro yámar mek warámpea pok námpon. Mao te oukoumwan yumo nke napo, pok námpnámp taknámp arákarrá ék naenámpono.” ");
INSERT INTO yuj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aea maok, am fárákapao am Oliv Faonkwe am pwarará pɨkia warko Jerusalem mek arári tukup. Am Oliv faonkwe te Jerusalem wonae fik yak nánko ankárankamp kilomita fek tukup konapono. ");
INSERT INTO yuj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Am fárákapao wae taun tokwae mek tukupea maok, am néntép konap narekamp aokore mek am mek pok. Am fárákapamp e te ará: Pita, Jon, Jems, Andru, Filip ntiaka Tomas, Bartolomyu ntiaka Matyu, tá ankwap Jems Alfiusomp táráp, tá Saimon Selot, tá Judas ankwap Jemsomp táráp. ");
INSERT INTO yuj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Am arop fárákap ponankor ankára mek koupoukarrá tankápria maok, Kwarén kar toropwap. Tá koumteou, Maria Jisasomp éntupwar, tá Jisasomp nánaeounápo kor taknámp énénki kar toropwapiapon. ");
INSERT INTO yuj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Am ke fek Jisasén mérnap arop fárákap koupoukour yakáp nap te 120 arakeno. ");
INSERT INTO yuj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Aeapo maok, Pita am arop fárákap ou mek fokopeyakrá kar arakrá farákáp, “Onomp ankwapyae fákáre, Kwaromp Buk fekamp kar ankárank wokwaek kar Yiki Kor Spiritao Devitén nɨnɨk sánkánko sérimp te, Judaso Jisasén sámp mwanap mwae yénképánko sámpap kar te oukoumwan te wae kare korop námpon. ");
INSERT INTO yuj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Wokwaek te Judas te yinomp firáp yakria, yinont ankárankamp tére arop yakápámpon.” ");
INSERT INTO yuj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Am arop Judas te kwatae nɨnɨkimp fekamp mani sámpea am fek apár kánanke sámp. Aea maok, wakmwaek mao am apár mek pɨká párákapea yare pukur akwapea, yare ponankor am apár mek wakor pɨkámpon. ");
INSERT INTO yuj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wakmwaek arop ponankor Jerusalem mek yakápap am táman méria maok, námokuráp kar fek sérrá, “Am apár te Akeldamanono.” Am takrá sérap te, am apár te ‘Yɨriráp Apárono’. ");
INSERT INTO yuj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita warko sérrá, “Mámá kar te Devito Buk Song fek kumwimp te ará: ‘Mao yak námp mek te amwar éri yak naenámpon. Amo am mek arop ankwap yakanoria pwar kwapono.’ Buk Song ankwap fek sérrá, ‘Arop ankwapao maomp tére sámp naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Aeno oukoumwan te nomo nomp Jisas Tokwae Kar nomont akwap koropnámp ke fek nomont paokop i konap arop ou mekamp ankárank warámp mwanámpon. ");
INSERT INTO yuj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Wokwaek Jono koumteouráp aropan ént mek nérrá kákámp tére, tá am feknámp Jisas térerá koropeanánko, oukoumwan Kwaro yámar mek warámpá pok námp, am ankank ponankor nkenámp aropan maok, warámpeanánko, mao nomont téreria, Jisas fárámpá poknámp kar farákáp naenámpon.” ");
INSERT INTO yuj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita takrá sénánko maok, arop anánkaopweran éréképap te, Josep Barsabas maomp ankwap e Jastus, tá arop ankwap te Matias. ");
INSERT INTO yuj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Am arop yawor éréképea tankáprá maok, am fárákapao arakrá kar toropwap, “Tokwae Kar e! Amo te kápae kare aropamp nɨnɨk te wae mér napon. Amo te yinan yénképampo: Amo te wa mokop ");
INSERT INTO yuj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judaso aposel téremp tére sámp naenámp nánap rape? Judaso am tére pwarará námoku akwap naerianámp némpouk akwap tenámpon.” ");
INSERT INTO yuj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Aea maok, am arop yaworamp e kumwiramp yumwi sɨrarea maok, Kwar te wa mokop am tére sámp naenámp arop nánapánrá nke napo maok, Matiasomp e kumwiap yumwiraomékɨr korop. Aenánko maok, nkea man mom-sámpramp aposelént tére naenámpria pwararapono. ");
INSERT INTO yuj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos yae fek, Jisasén mérnap arop fárákap ankárankamp nap mek koupoukour yakáp. ");
INSERT INTO yuj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aenapo maok, yámar meknámp ouwi tokwae ounk niamprá ékia am tankápnap nap mek top fákap yak. ");
INSERT INTO yuj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aenko am fárákapao nkeapo maok, yaomwi yurunk niampao ékria maok, am fárákapamp pourouk ankákárankrá fápárákár akwap. ");
INSERT INTO yuj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aeria maok, Yiki Kor Spiritao am Jisasén mérnap aropamp pourouk woukourria maok, táte moumountukri kar sérar. ");
INSERT INTO yuj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Am ke fek Kwarén lotu i konap Juda fi kápae kare apár mekamp koropeaka Jerusalem mek yakáp. ");
INSERT INTO yuj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Am ouwi tokwae ounk niamp korop nánko maok, kápae kare koumteouráp arop wawia koropá koupoukour. Aeria maok, am Jisasén mérnap arop fárákapamp kar waria kokorokor. Am te apae riteanápe am fárákap ankákárank wa napo, náráp kar kare fek sérar. ");
INSERT INTO yuj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Aenapo maok, am fákáre kokorokoria sérrá, “Mámá arop fárákap má kar sérarap te am te Galili mekamp arop fino! ");
INSERT INTO yuj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mokopiaka nomp naropwaromp kar kare fek sérar napo, nomo ankákárank ponankor wa námpon? ");
INSERT INTO yuj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Makia mapek koropá yakápnámp arop nomo apár Patia fi mekamp, Midia fi mekamp, Elam fi mekamp, distrik Mesopotemia mekamp, distrik Judia mekamp, provins Kapadosia mekamp, provins Pontus ntia Esia mekamp, ");
INSERT INTO yuj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","distrik Frigia ntia Pamfilia mekamp, tá Isip fi mekamp, distrik Libia ankwapmwaek kɨrɨkɨri Sairini taun wonae fikamp arop, tá nomo Rom fi mekamp arop mapek koropea yakáp námp. ");
INSERT INTO yuj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tá nomo Judaoia maok, tá nomo arop ankwap fi Juda lotu i konap nɨnɨkaok lotu i konámp arop, nomo apár amor ke Krit, tá distrik Arebia, nomo ponankor am fárákapao Kwaromp kárákáre kor tére konap kar nomp kar fek sérarap wa námpon.” ");
INSERT INTO yuj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Aeria maok, ponankor kokorokoria nɨnɨka waeria maok, námoku kok támao arakrá sérarria téréménkrá maok, “Máte apae fi korono?” ");
INSERT INTO yuj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aeapo maok, ankwap fárákapao aposel fákáreran wouroumprá sérarrá, “Táte wain ént wourékam fária mánmánrá paokop napono.” ");
INSERT INTO yuj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tá Pita mom-sámpramp aposel fákárerént yakria maok, kar kárákáre fek séria maok, am koumteouráp aropan arakrá sér, “Juda yumo, tá Jerusalem meknámp koropnap arop fákáre yumo te ono sénamp kar má fwapia woupwi pátea wawia maok, yumo am ankank fi nke nap má mérenke. ");
INSERT INTO yuj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yumo te, mámá arop fákáre máte mánmán napon yonkwae rape? Mono. Oukoumwan koumounek fépér mo nap fek sárakok ke mwar ara, arop mánmán mwanap pourou mono. ");
INSERT INTO yuj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mámá ankank oukoumwan korop námp te wokwaek profet Joelo sérimp niampon. Mao arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Kwaro sérrá, “Pwarnámp yae fek te, ono onomp Spirit fek koumteouráp aropamp pourouk oupoupourrá kák nanampono. Tá yiráp poumou-tárápu tá yiráp yupu-tárápuao kor profet kar fek onomp kar farákáp mwanapon. Tá ono yiráp tár-ménkiran nkwakwe make yém nke nap niamp yénkép nanko nke, tá mér aropao kor yémén nke mwanapon. ");
INSERT INTO yuj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tá am ke fek táman, onomp tére konap arop ntia tére konap koumteouamp pourouk onomp Spirit oupoupour nánko, am fárákap onomp kar profet kar fek farákáp mwanapon. ");
INSERT INTO yuj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tá yámar mek te momwar pourouráp ankank yororia, tá apárok kárákáre yororo nanamp te yɨri, yaomwi tokwae, yaomwi souri má apár má oupouroup yak naenámp te, am yae korop naenámp ke fek námpon. ");
INSERT INTO yuj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Am ke fek ono yámar sámpea arákár nanko kɨrɨkɨp korop, yunk sámpea arákár nanko yunk noumouriria yɨri niamp naenámpon. Nánkár wakmwaek te, Kwaro náráp Yae Tokwae fek náráp kárákáre ntia wae tokwae má apár ponankor yénkép naenámpon. ");
INSERT INTO yuj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Am ke fek ponankor koumteouráp arop Tokwae Karan ‘Námwan yaewourae’ ria wumwi napo, mao am fárákapan warko éréképeanánko, yae-párák yakáp mwanapon.” ’ Joelo profet kar fek makrá farákápámpon.” ");
INSERT INTO yuj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita warko ankwap kar sérrá, “Israel fi mekamp arop yumo te woupwi pátea onomp kar wawenke. Ono yumwan Nasaret mekamp Jisasoi námpan sénae rae: Yumo te nkwakwe make tére kárákáre Kwaro maomp yaek yumo ou mek yororo nánko nkea méri napon. Mao takimp te yumwan, námoku sámp-kérép nanko éknámp aroprá mérenkria ninámpon. ");
INSERT INTO yuj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kwaro wokwaek kar tak mwanaponorá nɨnɨki tari námpan maok, am aropan yiráp yaek pwar námpon. Aenánko yumo támao kwatae nɨnɨkráp aropamp yaek sánk napo, yaopwae porokopramp fek man pukupia, sumpwi pap napon. ");
INSERT INTO yuj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Aenapan maok, Kwaro warko man fárámpea papria, mao warko, am sumpwi sámpnámp touwe kwatae mek taki yakanori pwar moi námpon. Am te apae riteanápe, sumpwi te man sámp-fákeyak naenámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Devito kor man takrá sérimp, ‘Ono nke nanko Tokwae Karao kumur méntép onomp wonae fik kar yak námpon. Mao wonae fik yakriaka onan kárákáre sáp námpara, onan ankwap ankank te apápia kour me woukoupá pap mono. ");
INSERT INTO yuj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Aenámpan onomp nɨnɨk te kwapwe kare nánko, ono mámá kar warákárria sénampon. Ono te sumpwi nanamp aropao maok, Kwaro onan kwapwe kare ankank sáp naenámpan yépékrá yak nampon. ");
INSERT INTO yuj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Am te apae riteanápe, amo onan, waempomp némpouk yakaeria pwar mono. Tá amoku nánapinap arop te, numwar apár me mek mákáreanoria pwar mono. ");
INSERT INTO yuj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Amo onan yiki yak nanamp mwae wokwae yénkép napono. Tá amo te onont yak napo maok, am fek táman warákár tokwae nanampon!’ Mámá kar te Devito wokwaek makrá farákápámpon.” ");
INSERT INTO yuj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita warko ankwap kar sér, “Kémpiyae tárápu, ono yumwan érik sénampon: Nomp ounáp Devit mao te wae sumpwi nánko maok, apár me mek papapono. Am man papap apár me te, nomo ou mek yakrá koropea, oukoumwan kor yak námpon. ");
INSERT INTO yuj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Aeno Devit te profetara, mao te wae mér, Kwaro kare kar narek séria arakrá sér, ‘Nánkár wakmwaek te, ono waráp ounápén nánapitenanko, mao te amo King yak napnámp taknámp yak naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wokwaek kar te, Devito Kwaro tére naenámp ankank wae nkeanámpan, Kraiso warko fárámp naenámpan sérimpon. Mao sérrá, ‘Kwar te man, waempomp némpouk yakaeria pwar mo, tá maomp pourouao kor mákáre mono’rá sérimpon.’ ");
INSERT INTO yuj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Am takrá sérimp Jisas táman Kwaro fárámpea pap nánko, yino wae nke námpan sénámpon. ");
INSERT INTO yuj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Oukoumwan te wae narek pokeaka, Kwaromp yae-párák mwaek tankrá e tokwae sámp námpon. Mao te wae wokwaek sérimp niamp maomp Naropwaromp yaekamp Yiki Kor Spirit sámp námpon. Aenámpara oukoumwan te maomp kárákáre kwarokor nánko, yumo am wae nkea maomp kar wa napon. ");
INSERT INTO yuj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit te Jisas narek pok námp niamp tak mono. Aenámpao maok, mao arakrá sér, ‘Tokwae Karao onomp Tokwae Karan arakrá sérimpon, “Amo onomp yae-párák mwaek tankrá akwapea napo, ");
INSERT INTO yuj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Nánkár ono waráp yopor arop tirá waráp yae ankore mek kák tenanko, yakáp mwanapon.” ’ ");
INSERT INTO yuj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Aerimpara, yumo Israel fi ponankor te arakrá mérenke: Am Jisas, yumo yaopwae porokopramp fek pukup nap te, Kwaro man sérrá, ‘Tokwae Kar yoroi páte nánko, mao te Krais yak námpon.’” ");
INSERT INTO yuj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aeránko maok, koumteouráp arop fárákap Pitamp kar wa napo maok, am kar te am fárákapamp nɨnɨk mek párákap. Aenánko maok, am fárákapao Pita ntiaka ankwap aposel fákáreran arakrá turunk, “Ankwapyae fárákap e! Yino oukoumwan te apae mwanámpon?” ");
INSERT INTO yuj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Aerapo maok, Pita am fárákapan sérrá, “Yumo ponankor ankákárank ankár kwatae nɨnɨk pwararea, Jisas Kraisomp e fek ént mek nér napo, Kwaro yiráp kwatae nɨnɨk tirá épérano. Yumo tak napo, Kwaro yumwan Yiki Kor Spirit nénkano. ");
INSERT INTO yuj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Am te wokwaek kar Kwaro sérrá, ‘Yumwan, tá yiráp tárápuan, tá ponankor koumteouráp arop panek yakáp nap man Yiki Kor Spirit sánk nanamp’rá sérimpon. Nomp Tokwae Kar Kwaro mao wumwirinámp ponankor koumteouráp aropan ‘Yiki Kor Spirit nénk nanamp’ ria sérimpon.” ");
INSERT INTO yuj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tá Pita ankwap kar kápae kare am fárákapan tae fek farákápria maok, arakrá sér, “Yumo te fwapia mér kipo: Yumo takria am kwataenap arop fárákapént touwe sámp mwanape.” ");
INSERT INTO yuj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aeránko maok, am Pitamp kar wanap arop fárákap méria maok, ént mek nér. Am yae fek táman 3,000 koumteouráp arop manénkɨr Jisasén mérnap aropént koropá tapokwap napon. ");
INSERT INTO yuj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Am fárákap te kárákárerá aposel fákáreramp kar wawia maok, ankwapyaenápén yaewour, tá ankára mek koupoukarea fɨr fépérrá maok, énénki Kwarén kar toropwapiapon. ");
INSERT INTO yuj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aeapo maok, Kwaro aposel fákáreamp yae kor fek kápae kare kárákáre yororo nánko, koumteouráp arop fárákap ponankor nkea kokorokoria apáp tɨrɨnk. ");
INSERT INTO yuj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jisasén mérnap arop fárákap kápae kare por koupoukour saráp yakáp. Tá am fárákap te náráp ponankor ankank te Kwarén mérnap arop fárákapamp ponankoronorá nɨnɨk. ");
INSERT INTO yuj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Aeria maok, ankwap fárákapan náráp apárráp ankank nénkria, am fek mani sámpria te, ponankor arop fɨr ankank mo napén nénkapono. ");
INSERT INTO yuj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ponankor ankárankamp nɨnɨk fek kápae kare por lotu nap tokwae mek tukup ko koupoukour. Am fárákap nonopok nap-nap koupoukarrá énénki fépér. ");
INSERT INTO yuj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Am takrá fépérap fek te, am fárákapamp nɨnɨk yae-párák kareria warákáránkrá énénki fépériapono. Aeria am fárákap Kwaromp e sakap saráp yakáp napo, arop ankwap am fárákapan nkea te, yae-párák kare naprá nɨnɨk. Aenapo, Kwar Tokwaerao kumur méntép koumteouráp arop warko éréképrá, man manénkɨr mérnap aropént tapokwapá pwar. ");
INSERT INTO yuj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ankwap ke fek Pita ntiaka Jon yámar yinɨnk ke nánko, Kwarén kar toropwap i konap ke fek lotu nap tokwae mek pok. ");
INSERT INTO yuj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Am arop yaworao wae nke nepo maok, arop ankárank pu kwataenámp am fek tank. Éntupwaro sámpánko taki yakámp. Kumur méntép santukupea am lotu nap tokwae ménki fek páte napo tankrá, Kwarén loturá poknap koumteouráp arop fárákapan ‘Mani sápenk’ ria wumwirá tank konámp. Am ménki e te ‘Kwapwe Kare’rá sér i konapono. ");
INSERT INTO yuj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pita ntia Jon lotu nap tokwae mek yoump neria nepo maok, am pu kwataenámp arop támao am arop yaworan nkea, ‘Yumo onan ankank sápenk’rá sér. ");
INSERT INTO yuj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aenánko maok, Pita ntiaka Jono am aropan tokoreyakria maok, Pita man sérrá, “Amo yinan tokor yakae!” ");
INSERT INTO yuj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Aeránko maok, táte am aropao Pita ntiaka Jono yakep mwaek éntér arákarrá maok, námo te am arop yaworamp yaekamp ankank sámp nanampan mpwe nɨnɨk. ");
INSERT INTO yuj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Aenámpan maok, Pita sérrá, “Ono te mani mono. Ono amwan sánk nae namp ankank te Nasaret mekamp Jisas Kraisomp kárákáre fek ono amwan sér rae: Amo fárámpea akwapae!” ");
INSERT INTO yuj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Aeria maok, Pita maomp yae-párák mwaek yae tokoropea sámp-fokopá fákeyak nánko, koupour kar maomp pu ntia kwaráp kor wae kárákáre. ");
INSERT INTO yuj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Aenánko maok, mao wae fékér-pokrá fokopeyakea maok, wae yárak. Aeria maok, am arop yaworamp wakmwaek lotu nap tokwae mek youmpea maok, fékér-pok fékér-pokrá yárakrá, Kwaromp e sakap. ");
INSERT INTO yuj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ponankor koumteouráp arop man nke napo, mao te yárakriaka Kwaromp e sámpea sakap nánko maok, ");
INSERT INTO yuj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","am fárákap wae mér, am arop te kápae kare por lotu nap tokwae ‘Ménki Kwapwe Kare’ ri konap fek tankrá, mani ankankantá wumwirá tank konámp támaono. Aeria maok, am fárákap man nke napo, mao wae kwapwe kare nánko maok, am fárákap kokorokoria nɨnɨk tokwae. ");
INSERT INTO yuj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mao Pita ntiaka Jonén sámpá yakánko maok, koumteouráp arop kápae kare kokorokoria maonámpok foporakorrá koropea ‘Solomonomp Kaerik’rá sér i konap am fek nouroump. ");
INSERT INTO yuj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Aenapo, Pita am táman nkea, koumteouráp aropan arakrá sér, “Israel fi mekamp arop yumo te apaeritea mámá ankankan nkea korokop rape? Apaeritea yumo yinan énounkoup tokwae rape? Yiráp nɨnɨk te yinokump kárákáre tokwae fek, tá Kwaro nke námp fek yino kwapwe kare yaknemp nɨnɨk fek mámá arop fwapia yárakrá mpwe yonkwae rape? Am te mo karono. ");
INSERT INTO yuj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Aisak, Jekop, tá nomp wokwaekamp appeyaenápomp Kwar, am Kwar te náráp tére arop Jisasén námokuráp wae tokwae sánkámpon. Am arop te yumo yopor aropamp yaek papapono. Tá yumo Pailato nke námp fek man younkwe sánkapon. ");
INSERT INTO yuj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yumo te am yae-párák yiki kare aropan younkwe sɨrarrá maok, nopok Pailatén ‘Arop sámp-wouroumpámp arop táman pwarae’ ria kárákáre fek sériapon. ");
INSERT INTO yuj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Aenapan maok, yumo sámp-wouroumpnap arop am te nomwan yiki yakáp mwanámp kare nénk konámp arop ankárank támani napon. Aenapan maok, Kwaro man apár me mekamp fárámpea pap námpon. Yino kareao am nke nempan érik farákáp nempon. ");
INSERT INTO yuj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Aeria maok, yino te wae Jisasén mér nempon. Aenempara, Jisasomp kárákárerao mámá aropan kárákáre sánk nánko, yumo man nkea wae mér napon. Jisas námoku yinan mér sápeanánko, am mér fek táman yumo ponankor nke nap fek am aropamp pu wae fwap námpon. ");
INSERT INTO yuj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kémpiyae tárápu, ono te wae mér nampon, yumo te fwapia mér mo, tá yumwan taokeyakáp konap fárákapao kor mér moria am takiapon. ");
INSERT INTO yuj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Aeapan maok, wokwaek kar Kwaro ponankor profet fákáreramp top kor feknámp kar farákápámp te, Krais te touwe sámp naenámpan nimpon. Aempan, oukoumwan yumo am takinap nɨnɨk te wae am karént pwi námpon. ");
INSERT INTO yuj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Aenámpara, yumo te yiráp kwatae nɨnɨk te pwarará Kwaronámpok korop napo, Kwaro yumwan aminap nɨnɨk torokoria yiki kukarrá papano. ");
INSERT INTO yuj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Yumo tak napo te, táte Tokwae Karao yumwan wourékam kárákáre sánkria maok, mao yiráp por nánapinámp arop Krais yumonapok sámp-kérép nánko ék naenámpon. ");
INSERT INTO yuj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Oukoumwan te yámar mek yakrá, Kwaro nánkár warko kápae kare ankank te fwapokwapiaka wourékam ke yépékrá yak naenámpon. Am te wokwaek kar man saráp tére konap profet fákáreramp top kor fek sérimp niamp naenámpon. ");
INSERT INTO yuj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Am profet fákáre ou mekamp arop ankwap Moseso arakrá sér, ‘Yiráp Kwar Tokwae Karao yiráp ankwapnáp ankárank warámpea profet páte nánko, ono yak namp niamp maknámp yak naenámpon. Yumo te ankár maomp kar wawia, mao yumwan sénámp ponankor karwaok kipo. ");
INSERT INTO yuj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tá arop ponankor am profetomp kar wa mo napo te, Kwaro am fárákapan “Faokorenk”rá sénaenámpon. Aetenánko, am fárákap Israel fi mek yak mono.’ ");
INSERT INTO yuj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Profet fákáre, tá Samuel ntia wakmwaek yakápinap profet fárákap, Kwaro kar sánkánko, am farákápap te am te waeman oukoumwan mámá ke fek kare kar korop námpon. ");
INSERT INTO yuj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yumo te profet fákáreramp tárápu yakáp napon. Yumo te Kwaro yiráp por kontrak yoroinámp fekamp ankank sámp mwanap arop yakáp napon. Kwaro yiráp wokwaekamp ounáp Abrahamén sérrá, ‘Waráp appeyaenáp tárápu fek mámá apár mekamp arop fi ponankor kwapwe kare tankáp sámp mwanapon’ rimpon. ");
INSERT INTO yuj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Aempara, Kwaro náráp tére konámp aropan kéménki papea, yumwan, ourour nénkanoria manénkɨr yumonapok sámp-kérép námpon. Maomp nɨnɨk te, yumwan ponankor ankákárankrá kwatae nɨnɨk mekamp tiarárrá kák nánko, am kwatae nɨnɨk pwarará koropenkria námpon.” ");
INSERT INTO yuj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ntiaka Jon oukoumwan koumteouráp aropan kar farákáprá yakepo maok, táte pris fákáre, lotu nap tokwae taokeyakáp konap plisman fákáreramp kepten, tá Sadyusi fákáre, makia maok, korop. ");
INSERT INTO yuj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Am fárákap te wae mér, am arop yawor te koumteouráp aropan Jisas apár me meknámp fárámp námp, tá arop ponankor sumpwi napao kor warko ferámp mwanap kar farákáp nepria, am táman yopor tokwaeria, am arop yaworan tia kot mwaria napon. ");
INSERT INTO yuj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aenapan maok, wae kumur naeria námpantá, am arop yaworan oumpouran kot mwanámpria kalabus nap mek kák te. ");
INSERT INTO yuj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Aeno kápae kare koumteouráp arop oukoumwan am kar wawiaka Jisasén mér nap te, manénkɨrkampént tapokwapea 5,000 arakeno. ");
INSERT INTO yuj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wae wakor nánko, Juda taokeyakáp konap pris fákáre ntia némpouk yakáp konap yonkwae kourráp arop fákáre, tá lo mérnap arop fákáre, makia Jerusalem mek koupoukour. ");
INSERT INTO yuj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pris taokeyak konámp arop Anas, tá Kaiafas, Jon, Aleksander, táte Anasomp firáp ankwap fárákap makia am fárákapént koupoukour. ");
INSERT INTO yuj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Takia maok, am aposel yaworan, am fárákapao nke nap fek fokopeyakenk ritea maok, arakrá turunk, “Yumo te mokope kárákáre sámpea, apae e séria am ankank takrá tére nepon?” ");
INSERT INTO yuj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aerapo maok, Yiki Kor Spirit Pitamp pourou mek top-pwarámpá yak námp fek am fárákapan sérrá, “Yumo Israel mekamp arop tokwae, tá yumo arop taokeyakáp konap arop, ");
INSERT INTO yuj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","yumo te yino pu kwataenámp aropan yaewourinemp aran yinan turunk mwaria nape? Ae te yumo am arop te, mokopia fwapinámponorá mér mwaria nape? ");
INSERT INTO yuj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ae te tak nap kwamp te, yumo ponankor, tá Israel fi ponankorao kor, Nasaret mekamp Jisas Kraisomp eramp kárákáre fek am pu kwataeráp arop warko fwapia oukoumwan yumo nke nap fek fokopeyaknámp aran mér kipo. Yumo wokwaek man yaopwae porokopramp fek arápapan maok, tá Kwaro man warko apár me mekamp fárámpá papámpon. ");
INSERT INTO yuj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Am Jisas táman Kwaromp Buk fek arakrá sénámpon: ‘Nap ti konap arop, yumo, kwatae yumwinoria sɨtenapan maok, Kwaro man sámpea, nap am fek fokopeyak naenámp yumwi kwapwe yoroia páte námpon.’ ");
INSERT INTO yuj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nomwan yaewour naenámp te arop ankwap yak mono. Apár-apár ponankor te nomwan warko érékép naenámp arop ankwapamp e te Kwaro nomwan yénkép námp yak mono.” ");
INSERT INTO yuj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Aeránko maok, am fárákap nkeapo, Pita ntiaka Jon te apáp mono, kar kárákáre fek sér. Am fárákap te wae mér, am arop yawor te skul moinep arop yaworonoria nɨnɨk tokwae. Aenapan maok, am fárákap wae mér, am arop yawor te wokwaek Jisasént yakepara nepon. ");
INSERT INTO yuj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tá am fárákapao nkeapo, am arop te maomp pourou te wae fwapia maok, am arop yaworént fokopeyak yak. Aenánko maok, am fárákap te nopok am arop yaworamp kar pwarokwaprá sér mwanap yak mono. ");
INSERT INTO yuj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aeria maok, am arop fárákapao am arop yaworan sérrá, “Yumo Kaunsil nap aokore pwarará ek akwapenk!” Aerá sérapo, am arop yawor akwap tepo maok, am arop fárákap kar arakrá téréménk, ");
INSERT INTO yuj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nomo am arop yaworan te mokop mwanámpon? Am arop yawor te wae Kwaromp kárákáre ankárank yoro nepo, Jerusalem mekamp koumteouráp arop te wae mér napara, nomo te am kar mek wouroump mwanámp pourou mono. ");
INSERT INTO yuj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Aeno takria am kar te kápae kare koumteouráp aropao wa nap fek akwapantara, nomo ankár kar kárákáre fek am arop yaworan taokor mwanámpon. Aenánko maok, am arop yawor Jisasomp e fek ankwap fárákap wanap fek warko kar farákáp mo kare nenepon. ");
INSERT INTO yuj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Aeria maok, am fárákapao arop yaworan wumwiria maok, ‘Yumo te Jisasomp e fek koumteouráp aropan kar yénkrá farákáp kepono’ ria kar kárákáre fek taokor. ");
INSERT INTO yuj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Aerapan maok, nopok Pita ntiaka Jon am fárákapamp kar pwarokwaprá arakrá sér, “Yumo nɨk nap te, apae nɨnɨkao Kwaro nke námp fek yae-párák námpon? Yino te ankár Kwaromp karwaok akwap nenemp ni, yiráp karwaok akwap nenemp nie? Yumoku támao youroukoup kipo. ");
INSERT INTO yuj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yino te am kar farákáp mo nenemp pourou mono. Yino te ankár kápae kare ankank yino wokwaek nkemp, tá wawimp te ponankor farákáp nenempon.” ");
INSERT INTO yuj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Aerepo maok, am Kaunsil fákárerao am arop yaworan kot mwanap kar fi yak mo námpantá maok, am arop yaworan ankwap kar kárákáre fek séria maok, pwar napo, akwap. Am te apae riteanápe, arop ponankor Kwaro térenámp táman nɨnɨkria maomp e sakap napantá, takria, námwan yorowarantánorá apápria pwar napon. ");
INSERT INTO yuj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Am arop arop yaworao Kwaromp kárákáre fek fwapi papep te, maomp yopwar te wae 40 yopwar kámákár akwap námpon. ");
INSERT INTO yuj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kaunsil fákárerao Pita ntia Jonén pwatapo, am arop yawor maomp firáp yakápnap nap mek arákarrá akwapea maok, am fárákapan pris tokwae ntiaka lo mérnap arop fákárerao sérariap kar farákáp. ");
INSERT INTO yuj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Am fárákap am kar wawia maok, ponankor ankárankamp nɨnɨk fek tankápria maok, Kwarén énénki arakrá kar toropwap: “Tokwae Kar e! Amo wokwaek yámar, tá apár, tá solwara, ntia ponankor ankank am mek yakáp napan yoroiapono. ");
INSERT INTO yuj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wokwaek kar waráp Yiki Kor Spiritao yinomp appenáp waráp tére konámp arop Devitomp nɨnɨk mek sánkánko, mao arakrá sérimpono: ‘Apae riteaka ankwap fi arop yopor yonkwae pwarámpa wae napon? Apaeritea am koumteouráp arop te Kwarén yopor mwanámpria kwaporok nɨnɨk mwar pap napon? ");
INSERT INTO yuj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Apár ponankor mekamp king fákáre yorowar mwaria nánap napon. Gavmanomp poukeyakápnap arop fákáre énénki koupoukarea maok, Tokwae Karan apárok anámpá paprá, tá am Kraisén kor anámpá pap mwaria napon.’ ");
INSERT INTO yuj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Oukoumwan te am kar te waeman kare karono. Herot, Pontius Pailat ntiaka ankwap fi, tá Israel fi, makia maok, amo wokwaek nánapiap waráp tére arop kwapwe kare Jisasén anámpá pap mwaria, am taun mek tapokwaprá koupoukoura napono. ");
INSERT INTO yuj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Am fárákapao am ankank tak nap te, waráp kárákáre ntia amo takenkrá nɨnɨk napaok támani napono. ");
INSERT INTO yuj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tokwae Kar e! Amo ankár yinan apáp sáprá sérarnap kar mámá nɨnɨkria, waráp tére arop yinan yaewourampo. Aenapo maok, yino fwap apáp moria kárákáre fek waráp kar farákáp mwanámpon. ");
INSERT INTO yuj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Aeria maok, amoku waráp tére arop Jisasomp kárákáre fek amo touwenap aropamp pourouk yae papria, fwapokwapria maok, nkwakwe make kárákáre yoroampo.” ");
INSERT INTO yuj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Am fárákapao kar toropwapia pwar napo maok, táte am néntépap nap am te némp yérur koropánko maok, táte am fek am fárákapamp pourou mek Yiki Kor Spirit top-pwarámpánko maok, táte am fárákapao kor apáp mono, kárákáre fek Kwaromp kar farákápapon. ");
INSERT INTO yuj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jisasén mérnap arop ponankor ankárankamp nɨnɨk fek saráp yakáp. Arop ankwap ankárank náráp ankank nkea ‘Onokump kareno’rá sér mono. Ankank ponankor te ankár arop ponankor-ampono. ");
INSERT INTO yuj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposel fákárerao Jisas Tokwae warko fárámpámp kar farákápap te, am fárákapamp kar te kárákáre kor kare. Tá Kwaro am mérnap koumteouráp aropan warákár tokwaeria ourour kwapwe nénkámpon. ");
INSERT INTO yuj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Aenko maok, am ou mekamp arop te ankwap ankárankamp fɨrráp ankank monámp arop yak mono. Arop ponankor maomp apár yak, tá maomp nap yak nánko te, arop ankwapan nénkria, am fek mani tiria maok, ");
INSERT INTO yuj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tá am mani te aposel fákáreran sankoropá sánk napo maok, am fákárerao ankank monap koumteouráp aropan nénkapono. ");
INSERT INTO yuj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tá arop ankárankamp yak námp, maomp e te Josepén maok, aposel fárákapao ankwap e tákapap te ‘Barnabas’ ri pap nap te, am e fi te, ‘Aropamp nɨnɨk mek kárákáre sánk konámpon.’ Barnabas te Livaimp fi fekamp apár amor ke Saiprus mekamp aropono. ");
INSERT INTO yuj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Am aropao apár arop ankwapan pwararea maok, am fek mani sámpea maok, sankoropea aposel fárákapan sánkámp. ");
INSERT INTO yuj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Arop ankwap maomp e te Ananaias, tá maomp yupu te Safaira. Am Ananaiaso náráp apár ankwapmwaek arop ankwapan pwar. ");
INSERT INTO yuj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Aeria am fekamp mani sámpea, ankwapmwaek námoku nanampria pap. Aenánko maomp yupuao kor am wae mér. Aea maok Ananaiaso am mani ponankoronoria, ankwapmwaek saráp sankoropá aposel fákáreran sánk. ");
INSERT INTO yuj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Aenánko maok, Pita arakrá sér, “Ananaias, amo apaeritea Satan waráp nɨnɨk mek top-pwarámpanoria pwatea, Yiki Kor Spiritan kwekár séria waráp apár fekamp mani ankwapmwaek mek wouroump napon? ");
INSERT INTO yuj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Wokwaek oukoumwan am arop am apár sámp moap fek te, amokuráp apárono. Tá wakmwaek am apár sámpeanánko te, mani te amoku sámpea poukwap nanap tene. Aeno amo apaeritea am nɨnɨk kwatae sámp napon? Amo te aropan poupwekáp mono. Kwarén poupwekápi napono.” ");
INSERT INTO yuj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aeránko maok, Ananaias am kar waria maok, apárok pɨká párákapria wae sumpwi yak. Aenko maok, arop ankwap fárákapao am kar wawia maok, apáp tɨrɨnka wae. ");
INSERT INTO yuj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Aenko maok, ménki-tárápu fárákap koropea, maomp yákáre waempyam fek woukoupea santukupea pap. ");
INSERT INTO yuj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Aetapo, yinɨnk ke akwap tenánko maok, maomp yupu am te mér moitea maok, am mek korop. ");
INSERT INTO yuj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita man nkea sérrá, “Yumo apár fek sámpnep mani te wae támao nie?” Aeránko maok, yupurao sérrá, “Kare, wae támaonono.” ");
INSERT INTO yuj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Aeránko maok, Pita man sérrá, “Yumo apaeritea Tokwae Karamp Spiritan mokopean nke neria poupwekápi nepon? Amo wawae. Waráp poumaropamp yákáre santukup-papnap arop fárákap te mankea ménki fek máyakáp napon. Am fárákap amwan kor sámpá tukupá pap mwanapon.” ");
INSERT INTO yuj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aerá séránko maok, táte am fek táman am yupuao kor Pitamp wonae fik pɨká párákapria wae sumpwi yak. Aenko maok, am ménki-tárápu mankea nke napo, am yupu wae sumpwi yak. Aenánko maok, am fárákap man sámpea santukupea poumaropan papnap wonae fik pap. ");
INSERT INTO yuj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Aenapo maok, sios ponankor, tá arop ankwap fárákapao kor, am anánkwapao taknep kar wawia maok, apáp tɨrɨnka waeapon. ");
INSERT INTO yuj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Koumteouráp arop ou mek aposel fákárerao Kwaromp kárákáre fek nkwakwe make kárákáre yororo. Aenapo, Kwarén mérnap arop ponankor ankárankamp nɨnɨk fek lotu nap tokwae mekamp Solomonomp naepik koupoukour konapono. ");
INSERT INTO yuj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ponankor arop ankwap fárákap te am fárákapamp e sakapria, apápria maok, am fárákapént koropea koupoukour mo. ");
INSERT INTO yuj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aenapo maok, kápae kare koumteouráp arop fákáre Tokwae Karan méria koroprá, am fárákapént tapokwap. ");
INSERT INTO yuj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aeapo maok, koumteouráp arop fárákapao kor touwenap arop ti-koroprá, mwaeaok nkwakwe make kwanpae ankank yunkrá párakoprá maok, am fek tirá kák. Am tak nap te, Pita yámar fek yárak nánko, maomp wunérirao, am fárákapamp pourouk oupoupour nánko, am fákáreamp touwe fwapanáponoria niapon. ");
INSERT INTO yuj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem wonae fik mwaekamp, ponankor taun mekampao kor koropea koupoukour. Am fárákap te touwenap arop fárákap ntia kwatae-aropao woukouria kwatae káknámp arop fárákap ti-korop napo maok, am koumteouráp arop te warko fwapiapono. ");
INSERT INTO yuj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aenko maok, pris taokeyak konámp arop, tá maomp ponankor mént yakáp konap, tá Sadyusi fákáre, makia maok, am fárákapao aposel fákárerao am tére napan nkea kokwarokria yonkwae pwarámp. ");
INSERT INTO yuj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Aeria maok, am fárákap aposel fákáreran tia, kalabus nap mek kwataenap arop fákáre yakáp nap mek kák. ");
INSERT INTO yuj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Aenapan maok, kumuruk Kwar Tokwae Karamp ensel ankárankao kalabus nap ménki kɨk-pwararea maok, am fárákapan ek éréképá mankea sérrá, ");
INSERT INTO yuj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Yumo tukupea lotu nap tokwae mek koumteouráp aropan wourékam yɨki yakamp ponankor nɨnɨk farákápenke.” ");
INSERT INTO yuj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aposel fákárerao am kar wawia maok, koumounek kar lotu nap tokwae mek tukupea maok, koumteouráp aropan kar farákáp. Pris taokeyak konámp arop, táte maomp arop fákáre, Kaunsil fákáre ponankor wumwi napo koropea koupoukour. Aeria maok, kalabus nap mek kar sámp-kérépria sérrá, “Am aposel fákáre éréképá koropenke.” ");
INSERT INTO yuj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mak rapo maok, plisman fákárerao am kalabus nap mek tukupea nkeapo maok, aposel fákáre yak mo. Aenapo maok, warko arákarrá tukupea am fárákapan kar sérrá, ");
INSERT INTO yuj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Yino tukupea nke nánko maok, am kalabus nap te ménki kéri yak nánko, am fek taokeyakáp konap soldia fákárerao ménki méntép foukouri yakáp napo maok, yino ménki kɨk-pwarará yinkea am nap mek nke nánko te, aposel fákáre te ankárankampao kor am mek yak mono.” ");
INSERT INTO yuj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Aerapo maok, lotu nap tokwae mekamp kepten, tá pris tokwae fákáre makia maok, am kar waria nɨnɨkria maok, “Ae te am arop fárákap te mokopia moyakáp napon?” ");
INSERT INTO yuj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Aerapo maok, arop ankárank koropeaka am fárákapan sérrá, “Yumo te wawenke. Yumo am arop fákáre kalabus nap mek kák nap te, am fárákap te lotu nap tokwae mek yakáprá koumteouráp aropan kar farákáp napon.” ");
INSERT INTO yuj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Aerá sénánko maok, kepten ntia plisman fákáre tukupea am aposel fárákap tiria maok, éréképá korop. Aenapao maok, man te fupuk mono. Takria, koumteouráp aropao nomwan yumwi fek yérénképantánorá apápria párák sánánkar érékép napono. ");
INSERT INTO yuj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Plisman fákárerao aposel fákáre éréképá koropea Kaunsil fákáre nke nap fek párakop napo maok, foukouri yakáp napo, pris taokeyak konámp aropao am fárákapan sérrá, ");
INSERT INTO yuj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Yino waeman yumwan sérrá, ‘Koumteouráp aropan maomp e fek kar farákáp kwapono’rá séri námp te, yumo wa moi yakáprá, oukoumwan am kar farákáprá yakáp napo, Jerusalem mek mwaekamp koumteouráp arop waeman am kar wawia pwi napono. Tá yumo yinan ‘Am aropan sámp-wouroump napono’rá sérar napon!” ");
INSERT INTO yuj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Aerapan maok, Pita ntiaka aposel fákárerao am kar pwarokwaprá arakrá sér, “Yino te ankár Kwaromp karwaok saráp mwanámpono. Yino te aropamp karwaok tukup mono. ");
INSERT INTO yuj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yumo Jisasén yaopwae porokopramp fek pukupia sumpwi papapan maok, nomp appeyaenápomp Kwaro man fárámpea papámpon. ");
INSERT INTO yuj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kwaro man warámpea narek pokeaka, yae-párák mwaek páte nánko tank námpon. Aeria mao nomwan mwae kup yénkrá, nomwan warko éréképnámp arop yak námpon. Am taknámp ke fek táman maok, mao fwap Israel fi nomwan yaewour nánko, nomo kwatae nɨnɨk pwarará maonámpok tukup nánko, mao nomp kwatae nɨnɨk tirá épér naenámpon. ");
INSERT INTO yuj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yino te Kwaro am ankank tére nánko nkenámp karan farákáp konámpon. Tá Yiki Kor Spiritao kor am ankank táman farákáp námpon. Aenánko, am karwaok tukupnap koumteouráp arop fárákapan Kwaro am Yiki Kor Spirit nénk námpon.” ");
INSERT INTO yuj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Am Kaunsil fákáre Pitamp kar waria maok, yonkwae pwarámpria am aposel fákáreran tirá wour mwari wae. ");
INSERT INTO yuj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Aenapan maok, am ou mekamp Kaunsil ankwap yak námp mao te Farisi fi mekamp, maomp e te Gamaliel. Mao te lo méria farákáp konámp tisa yak nánko, ponankor koumteouráp arop maomp e sakap konap. Mao sérrá, “Aposel fákáreran ek éréképá yinkea napo, kánanke kwarok ke fek yakápanápono.” ");
INSERT INTO yuj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Aeránko maok, aposel fákáre wae ek yink tenapo, Gamaliel Kaunsil ankwap fákáreran sérrá, “Israel fi mekamp arop fákáre, yumo te mámá arop fárákapan apae mwaria te, yumoku támao fwapia nɨnɨk kouritea kip. ");
INSERT INTO yuj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yumo te wae mér napon, wokwaek tae morok te Tiudas sérrá, ‘Ono te arop tokwae, ono te kárákáreno.’ Waeman 400 naenámp niamp arop maomp wakmwaek tukupapon. Aeapan maok, Gavmano soldia tirá kérép nánko, am aropan yaonk-pap napo, man mérap arop fárákap pɨrɨkɨmpea tukup napo, maomp tére te kwaporok pwara námpono. ");
INSERT INTO yuj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tá wakmwaek, Gavmano koumteouráp aropamp e ti naenámp ke fek, Galili mekamp Judaso arop ankwap fárákapan yopor kaea Gavmanén yorowaria yérépe mwaria éréképá akwap. Aempan maok, man kor yaonk-pap napo, maomp wakmwaek tukupnap arop fárákap pɨrɨkɨmpea tukupapono. ");
INSERT INTO yuj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Aenapantá, ono oukoumwan yumwan sénampon: Yumo te am arop fárákapan te kánanke nkwak maki kwapono, pwar kipo. Am aposel fákáre aropamp nɨnɨk fek saráp tére napo te, am tére kwatae akwap naerámpon. ");
INSERT INTO yuj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Aeno Kwaro námoku nénknámp téreanánko te, yumo am fárákapan taokor mwanap pourou mono. Yumo takria, Kwarén yorowar mwanape.” ");
INSERT INTO yuj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Aeránko maok, am Kaunsil fákáre Gamalielo sérámpaokria maok, aposel fákáreran wumwiria, koropapo maok, am soldia fákáreran sérrá, “Aposel fákárean paok ke fek fupukenke.” Aerapo, am fárákapan fupukia pwarará maok, sérrá, ‘Yumo te warko Jisasomp e fek kar farákáp kwapono’rá séria, tirá kérép. ");
INSERT INTO yuj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aeapo maok, aposel fákárerao am kaunsilén pwarará tukupria maok, Kwaro waeman námwan Jisasén mérnap fek pwarápae sámp mwanap fwap pwi naponorá nɨnɨk námponoria warákáránk. ");
INSERT INTO yuj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ae nap kwamp maok, kumur méntép lotu nap tokwae mek, táte aropamp nap mek kor tukuprá ‘Jisas te Krais támaono’rá am Kwapwe Kare Kar yénkrá farákápria maok, am tére te ankár pwar moiapon. ");
INSERT INTO yuj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Am ke fek táman maok, Jisasén mérnap arop te ou tokwae. Aeria maok, Grik kar fek farákáp konap arop fárákap Judamp kar fek farákáp konap arop fárákapan kokwarok napon. Am te apae riteanápe, am fárákapao fɨr monap aropan yaewour napao maok, náráp kae koumteouén te yaewour mo napria napon. ");
INSERT INTO yuj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aenapo maok, aposel éntér-sámprampao Jisasén mérnap arop fárákapan koropenkria wumwiria maok, sérrá, “Yino Kwaromp kar farákáp mo pwarará, fɨr mwar nénk námp te, kwatae yak námpon. ");
INSERT INTO yuj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Aenámpara, kémpiyae fárákap, yumo ou mekamp arop fákánek, arop ponankor man warákár konap, tá Yiki Kor Spirit top-pwarámpá yakáp námp, tá yonkwae kour kwapweráp aran oupourounkia napo, nomo am fárákapan yoroi kák nánko, am tére tére mwanapon. ");
INSERT INTO yuj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aeno yinoku te kápae kare por kar toropwaprá, koumteouráp aropan Kwaromp kar fek yaewour mwanámpon.” ");
INSERT INTO yuj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Makrá sérarrá maok, koumteouráp arop ponankor am aposel fákáreramp kar wawia, warákárria maok, fákánek aropan éréképea korop. Maomp e te ará: Stiven te maomp mér te kárákáre kor kareria maok, táte Yiki Kor Spiritao maomp pourouk aowarámpá yak námpon. Tá ankwap te Filip, ankwap te Prokorus, ankwap te Nikanor, ankwap te Timon, ankwap te Parmenas, ankwap te Nikolas. Nikolas te Antiok mekamp aropao maok, Juda lotunap nɨnɨk sámpea ampaok i konámp arop. ");
INSERT INTO yuj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Am fákánek aropan éréképá koropea aposel fákáreamp wonae fik párakop napo, am fárákapao maomp me korok yae paprá Kwarén kar toropwapia maok, am tére mwanap arop yoroi kák. ");
INSERT INTO yuj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Aeapo maok, Kwaromp kar kápae kare apár mek akwapánko maok, kápae kare koumteouráp arop Jerusalem mek Jisasén méria, maomp firáp yakápiapon. Táte kápae kare pris fákáreao kor Jisasén méria Kwaromp karwaokiapon. ");
INSERT INTO yuj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kwaro ourour kwapwe ntia kárákáre tokwae Stivenén sánkánko maok, am fek táman koumteouráp arop nkeap fek nkwakwe make kárákáre yoro. ");
INSERT INTO yuj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aenko maok, arop ankwap fákárerao Stivenént kar yorowar. Am arop fárákap te Judamp ‘Amwar Yakápnap Arop Fákáreamp lotu nap’rá sér i konap mekamp arop fárákap, taun tokwae Sairini mekamp, tá taun tokwae Aleksandria mekamp, tá provins Silisia ntia provins Esia mekampaoiapon. ");
INSERT INTO yuj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Yiki Kor Spiritao Stivenén yonkwae kour sánk námpara, am arop fárákap te maomp kar te kwe-pwar mwanap pourou mono. ");
INSERT INTO yuj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aenámpantá maok, am fárákap arop ankwap fárákapan kar porokwerá arakrá sér, “Yumo yankar-séria ‘Yino wa nánko, Stiven te Moses ntiaka Kwarén wouroump-séri námpono’rá sérenke.” ");
INSERT INTO yuj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Amnap nɨnɨk fek koumteouráp arop, tá Juda taokeyakáp konap arop, tá lo yénkrá farákáp konap arop, Stivenén sámp-wouroumpenkria fopwaok. Aenapo am fárákapao tukupea Stivenén sámpea maok, Kaunsil fákáreraonapok sámpá tukup. ");
INSERT INTO yuj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Am fárákapao man kwekár sér mwanap arop fákáre éréképá tukupeakapo maok, am arop fárákapao arakrá sér, “Am arop te kápae kare por Kwaromp nap ntia maomp loan kwatae kar sér i konámpon.” ");
INSERT INTO yuj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mak ritea maok, arakrá sér, “Yino wanánko, mao sérrá, ‘Am Nasaret mekamp Jisas te lotu nap tokwae souroumpouria, Moseso nomwan sápámp nɨnɨk pwarará, ankwap yiki nɨnɨk kák naenámp’rá sér i konámpon.” ");
INSERT INTO yuj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Aerapo maok, am Kaunsil tankápnap fákáre ponankor Stivenén tokoreyakápria nke napo maok, maomp yimetáp te enselomp yimetáp wae niampi yak. ");
INSERT INTO yuj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Aenánko maok, pris taokeyak konámp arop Stivenén arakrá turunk, “Mámá kar amwan sénap te kare kar ni mo nie?” ");
INSERT INTO yuj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Aeránko maok, Stiveno sérrá, “Kémpiyae tárápu, tá onomp tékénou fákáre, yumo wawenke! Wokwaek kar nomp ounáp Abraham oukoumwan taun Haran mek akwap mo, apár Mesopotemia mek yakámp fek maok, am ke fek táman yámar mekamp wae tokwaeráp Kwar Abrahamonámpok koropámpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Aeria maok, Kwaro man arakrá sér, ‘Amo waráp firáp arop, tá waráp apár fi máte wampwe pwarará, akwap napo, amwan am mek yak nanap apár yénkép nanampon.’ ");
INSERT INTO yuj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Aeránko maok, Abrahamo am apár Kaldia pwarará akwapea Haran mek yak. Aenko am ke fek maomp naropwar sumpwi nánko, warko Kwaro man sámp-kérépánko maok, koropeaka nomo oukoumwan yakápnámp apár mek mamek yakámpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Aeno Kwar te Abrahamén apár ankwap námoku naenámp kare te sánk mo, tá ankwap kánanke kareanánko pwar moimpon. Aempan maok, Kwaro, wakmwaek mámá apár sánkea nanko, maomp apár yak, tá maomp tárápu firamp apár yak naenámp rimpon. Abraham te am ke fek oukoumwan táráp sámp mo nánko maok, ");
INSERT INTO yuj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kwaro man takrá sér, ‘Nánkár wakmwaek waráp ounáp tárápu te ankwap fi apár mek tukupá yakáp mwanapon. Aeria am fárákap te ankwap fi aropamp kwaporok tére arop yakáp napo, am fárákapao man sámpá yampourourá tukupea 400 yopwar fek mwanapon. ");
INSERT INTO yuj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Aenapan maok, nánkár wakmwaek te ono am takinap ankwap fi arop fárákapan nopok touwe nénk nanampon. Aea napo maok, nánkár wakmwaek am fárákap am fi pwarará koropea, mámá apár mek onan lotu mwanap’rá sérimpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kwaro Abrahamén kontrak yoroinámp yénképria, mao ankár yɨpi fárákap naenámp rimpono. Tá wakmwaek Abrahamo Aisakomp naropwar yakria, yukupuk yae fek Aisakomp yɨpi fárákapámpon. Aeakánko maok, Aisak te náráp táráp Jekopomp yɨpi fárákap. Tá nomp appenáp Jekop maomp tárápu éntér-sámprampan yɨpi fékérimpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Am appeyaenáp támao náráp nánae Josepén kokwarokria kwaporok tére konámp arop niampia sámprá, ankwap fi aropamp yaek sámp-kérépapono. Aenapo, am fárákapao man Isip mek warámpá tukupapan maok, Kwaro méntér yakámpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Mao man yaewourria, maomp nɨnɨk kápae tirá épéri pwar. Tá Josep Isip mekamp kingént kar sénánko maok, Kwaro man kingo warákár naenámp yonkwae kour sánk. Aenánko maok, kingo man Isip mekamp ankank poukwap naenámp Gavman Tokwae yoroi pap. Aetenánko maok, mao kingomp nap mekamp ankankan kor poukeyakámpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nánkár wakmwaek maok, Isip mek fɨr mo nánko, yae-porokwe tokwae ponankor apár mek koropria, Kenan mek kor tak nánko, koumteouráp arop ponankor nɨnɨk kápae tokwae sámpapon. Tá nomp appeyaenápo kor fɨr fár mwanap moimpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Aeria maok, Jekopo wanánko, ‘Fɨr te Isip mek tank námp’rá sénapo maok, táte mao nomp appeyaenáp manénkɨr tirá kérép. ");
INSERT INTO yuj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aeapan maok, warko anánkan tukupap te Josepo náráp naeounápén sérrá, ‘Ono te Josepono.’ Aeránko maok, táte kingo kor Josepomp fi am mérimpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Aeria maok, táte Josep náráp naropwar Jekopén kar kérépria wumwi nánko maok, Jekopo náráp koumteouráp arop fi éréképea koropámp te 75ono. ");
INSERT INTO yuj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Aea maok, Jekop Isip mek akwapá yakea maok, wakmwaek sumpwi tenánko, nomp appeyaenáp fákáreao kor wae surumpwi pwar. ");
INSERT INTO yuj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Aenapo, am fárákapamp kour te apár Kenan mek tiarárrá ti-tukupea taun Sekem mek, wokwaek Abrahamo Hamoromp tárápuran mani silva sánkria sámpámp apár mekamp péri me mek kákapono. ");
INSERT INTO yuj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Kwaro wokwaek kar Abrahamén sérimp yopwar 400 wae akwapá pwar naeria nánko maok, am fek táman Isip mekamp Israel fi wae námoku kápae kare forokora wae. ");
INSERT INTO yuj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Aenapo maok, am ke fek táman king ankwap Isip mek yakria maok, Josepomp tére te mér moitea yakrá maok, ");
INSERT INTO yuj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","am king támao nomp firáp arop firan poupwekápria sámpá yampourou. Takria maok, am fárákapan, ‘Yiráp tárápu ek épéri tenapo surumpwianápono’ ria fopwaoka wae napon. ");
INSERT INTO yuj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Am ke fek táman Mosesomp éntupwaro man fárákapea-nánko, am táráp te kwapwe kare kare nánko maok, Kwaro man warákár. Aenánko, éntupwar naropwaro kánánkámp sámpá yak nepo, wae yinɨnk yunk akwap te. ");
INSERT INTO yuj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Aenánko maok, wakmwaek am táráp ek sakwapea páte nepo maok, tá kingomp yupu-tárápao akwapea nkea sámpea, mao námokuráp tárápnámp wurumpámpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Takianánko maok, Moses éririaka, Isip mek skuliaka am mekamp mér kwapwe sámpea maok, kárákáre kor arop yakria, kar kárákáre fek farákáprá, nkwakwe make ankank kárákáre térempono. ");
INSERT INTO yuj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mao am mek yakrá akwapea 40 yopwaria maok, warko náráp ankwapyaenáp Israel firan nke naeria akwap. ");
INSERT INTO yuj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Akwapea nke nánko maok, Isip mekamp arop ankárankao Israel mekamp aropan yorowarrá yárakánko maok, Moseso man yaewourria Isip mekamp aropan porokwapea sumpwi pap. ");
INSERT INTO yuj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Aeria maok, Mosesomp nɨnɨk te maomp ankwapyaenáp fárákap, Kwaro náráp yaerént purá am fárákapan yaewour naenámprá nɨnɨk mwanapan mpwe námpon. Aenámpan maok, am fárákap mér mono. ");
INSERT INTO yuj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Takia maok, táte ankwap yae fek Moseso nke nánko maok, Israel mekamp arop yawor nonopok yorowar. Aenepo maok, mao akwapea sérémékéria taokarrá pap naeria maok, am arop yaworan sérrá, ‘Ae! Yumo te mwearono. Apaeritea yumoku támao nonopok touwe sámp neria nepe?’ ");
INSERT INTO yuj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mak ránko maok, am manénkɨr nɨkia yorowarámp arop támao Mosesén panánkár sakwapria sérrá, ‘Amo te akwapae. Amwan te wa yinan taokeyakrá tárakwamp nanap arop pap námpon? ");
INSERT INTO yuj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Amo te yipɨrman Isip mekamp aropani napnámp, onan kor porokwap pap nae rape?’ ");
INSERT INTO yuj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Aeránko maok, Moses am kar wawia mao wae farákap. Mao farákápá akwapea Midian firamp apár mek yak. Aeria maok, wakmwaek am mekamp yupu sámpea maok, poumou-táráp anánkaopwe ti. ");
INSERT INTO yuj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Moses am mek 40 yopwar yakeanánko maok, Sainai faonkwe wonae fik arop yak mo apár mek ensel ankwap maonámpok korop. Am ensel te Moseso nke nánko, yao kánanke yowe mek yaomwi yurunk nánko am mek yak. ");
INSERT INTO yuj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moseso am táman nkea nɨnɨk tokwae. Aeria maok, mao fwapi nke nae yonkwaerá wonae fik akwap nánko maok, Tokwae Karao man sérrá, ");
INSERT INTO yuj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ono waráp appewarápomp Kwaro nae, tá Abraham, Aisak, Jekop, maomp Kwaro nae’rá sér. Aeránko maok, Moses wará yárakrá kour me woukoupria maok, am mek énounkoup naerianámp te, apápa wae. ");
INSERT INTO yuj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Aenánko maok, Kwar Tokwaerao man sérrá, ‘Amo ankár waráp pukamp su te wor-papae. Am te apae riteanápe, támá apár amo am mek fokopeyak nap te, onokumpria maok, am te fou kareno. ");
INSERT INTO yuj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ono te Isip mek onomp firáp koumteouráp aropan nap kwatae nɨnɨk te wae nke nampono. Ono am fárákapamp ém kar te wae wawia nampan, am Isip fárákapamp yaekamp warko érékép naeria ék nampon. Ae namp kwamp, ono amwan Isip mek warko sámp-kérép nae rae.’ ");
INSERT INTO yuj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Manénkɨr te Israel fi Mosesomp kar ták-pwarará arakrá sér, ‘Amwan te wa yinan taokeyakria yinan kot nanap arop pap námpono?’rá sériapono. Aeapan maok, Kwaro am arop Moses táman arop taokeyak konámp arop, tá am fárákapan érékép naenámp arop yoroia sámp-kérép námpon. Yao kánanke mek yaomwi yurunk námp meknámp enselomp yae kor fek Kwaro man tak naenámp kárákáre sánk námpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Aeránko maok, Moseso Isip mek akwapea, Kwaromp nkwakwe make kárákáre yoroia, am feknámp Israel fi éréképá akwapea Noumouri Solwara mek, tá kwar saráp mek 40 yopwar fek kor nkwakwe make kárákáre yororo. ");
INSERT INTO yuj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Am Moses támao Israel firan sérrá, ‘Nánkár Kwaro yiráp ankwapnáp ankárank nánapi pwate nánko, onoku yak namp niamp yak naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wakmwaek Israel fi tukupea kwar saráp mek koupoukour yakáp napo, am Moses támao am fárákapént yakámp. Tá mao narek Sainai faonkwe wi fek pokeanánko maok, enselo man kar sánkánko, mao am Kwaromp yiki yak konámp kar nomwan farákápámpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Aenámpan maok, nomp appeyaenáp te maomp kar wa moria kar ták-sɨrirá paokopria, warko Isip mekamp ankankan kɨkiankria, am mek arári tukup mwaria waeapon. ");
INSERT INTO yuj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Am fárákap te Mosesomp nánae Aronén sérrá, ‘Am yinan Isip meknámp éréképea koropnámp Moses te, mao te apae mokoprian nomo mér mo námpono. Amo ankár yinomp kwar yoroia napo, mao mekia akwapria, yinan éréképá akwap naenámpon.’ ");
INSERT INTO yuj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Am ke fek táman gol fek bulmakau soup ankárank niamp kwekár kwar yoroi papea, man ofa sánk. Aeria am námokuráp yae fek yoroiap kwekár kwar táman warákáránkrá koupoukarrá fɨr kékérourá fépér. ");
INSERT INTO yuj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Aenapo maok, Kwaro am fárákapan, yumoku naponoria younkwe sɨtenánko maok, kwaporok námoku támao takrá kwekár kwarén loturá paokopria maok, yámar, yunk, térmeráp ankankan lotuiapono. Am tak nap te, profet fákáreramp buk fek yak námp niampon. Am kar te arakrá sér, ‘Israel fi yumo te kwar saráp mek 40 yopwar fek yakápria bulmakauráp sipsip fupukrá tia ofa nap te, ae te yumo am ofa taki nap te onani nap nie? Mo karono. ");
INSERT INTO yuj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Am yumo sampnap sel nap te kwekár kwar Molekompono. Tá yumo yiráp kwekár kwar Refanomp térme wunérian kor samp napon. Yumo te am kwekár kwaromp wunéri yororoia man lotu napono. Aenapara, ono yumwan mapekamp fárarámprá párakop nanko, nkwampok Babilon firamp apár yak námp mwaek tukupá yakáp mwarea napon.’ ");
INSERT INTO yuj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Wokwaek kar nomp appeyaenáp fákáre te kwar saráp mek yakápap sel fekamp Kwaromp lotu nap sámpá yakápiapon. Am lotu nap yak námp te am fárákapan, Kwar te yiráp ou mek yak konámponorá yénkép námpon. Am sel nap ti nap fek te Kwaro Mosesén sérimpaokria, Moseso nkenámp wunéri mántwaok tiapono. ");
INSERT INTO yuj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","46","Wakmwaek maok, Josua nomp appeyaenápomp tárápu éréképá koropea Kwaro ankwap fi aropan yorowaria kwe-pwaranámp apár sámpea am apár mek am sankoropap sel fekamp lotu nap sámp-fokopapono. Am sel fekamp lotu nap te ankár taki yakrá koropea Kwaro warákár konámp arop King Devit yaknámp ke fekimpon. Tá Devito nomp ounáp Jekopomp Kwaromp nap ti nae yonkwaeria Kwarén kar toropwapimpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Aempan maok, wakmwaek Solomono mámá nap timpon. ");
INSERT INTO yuj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Aeno narek yaknámp Kwar Tokwae te aropao tinap nap mek te yak mo i konámpono. Profeto makrá sérimpon, ");
INSERT INTO yuj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Kwar Tokwaerao arakrá sér: “Yámar te onomp sianono, tá apár te ono am yumuntuk pu pátea tank konampono. Ae konámpara, yumo onompor te mokope pourouráp nap ti mwanapon? Tá ono te anepér nanamp némp te maok yak naenámpon? ");
INSERT INTO yuj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Onoku támao am ankank yoroi nampono.” ’” Tá Stiveno Kaunsil fákárean warko arakrá sér, ");
INSERT INTO yuj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Yumo te kwekápnap aropono. Yumo te ankwap fi aropamp nɨnɨk niamp nape. Yiráp woupwi te kéri yak nánko, Kwaro sénámp kar wa mo napon. Yumo te wokwaek yiráp appeyaenápoiapnámp Yiki Kor Spiritamp kar ták-sɨri napon. ");
INSERT INTO yuj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wokwaek te apae profet yakánko, yiráp appeyaenápo man sámpá yampourou moiapon? Am fárákap te ‘Yae-párák kare nɨnɨk naenámp arop korop naenámp’rá sérámp aropan te tirá wouriapon. Aeapan maok, oukoumwan te am arop wae koropeanámpan yumo man yopor aropamp yaek pap napo, man sámp-wouroumpapon. ");
INSERT INTO yuj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yumo te enselomp yaekamp Kwaromp lo sámp napao maok, yumo ampaok tukup moi napono.” ");
INSERT INTO yuj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stiveno makrá sénánko maok, Kaunsil fákáre am kar wawia, youpoukwap tokwaeria, you kɨkɨmpia wae. ");
INSERT INTO yuj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aenapan maok, Stivenén Yiki Kor Spiritao woukoupeyak nánko maok, yámar mek tokoreyakria nke nánko maok, Kwaromp wae kwapwe tákap nánko, am mek Jisas Kwaromp yae-párák mwaek fokopeyak námp nke. ");
INSERT INTO yuj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Aeria maok, Stiveno arakrá sér, “Yumo wawenk! Ono yámar mek nke nanko, yámar kɨkɨr akwap nánko, Aropamp Táráp Kwaromp yae-párák mwaek fokopeyak nánko nke nampon.” ");
INSERT INTO yuj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Aeránko maok, am fárákap am kar wawia maok, tékén kar kárákáre fek sérarrá, Stivenomp kar wawantánoria woupwi mek yae kákar. Aeria maok am fárákap ponankor ferámprá foporakorrá tukupea Stivenén sámp. ");
INSERT INTO yuj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Man sámpea santukupea ek taun younkwek sɨrarrá paokoprá man yaonk-pap mwaria yumwian arokop. Am manénkɨr man wouroump-sériap arop fárákap náráp waempyam éri worépámpá tukupea, arop tár-ménki ankwapamp wonae fik kák. Am aropamp e te Sol. ");
INSERT INTO yuj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","