﻿USE sofia;
DROP TABLE IF EXISTS sofia.yss_yawu_vpl;
CREATE TABLE yss_yawu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yss_yawu_vpl WRITE;
INSERT INTO yss_yawu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisas Krais eteri yeiwarege etemri sig gwo. Ere Abraham eteri tame supa. Devit ere Abraham eteri tame supa. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ere Aisak eteri a. Aisak ere Jekop eteri a. Jekop ere Juda eteri lakemaseken etemri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ere Peresken Seraken etepri a. Nawo teri sig Tamar. Peres ere Hesron eteri a. Hesron ere Ram eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ere Aminadap eteri a. Aminadap ere Nason eteri a. Nason ere Salmon eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ere Boas eteri a. Nawo teri sig Rahap. Boas ere Obet eteri a. Nawo teri sig Rut. Obet ere Jesi eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ere Keryen Devit eteri a. Devit ere Solomon eteri a. Nawo te kiyi Uria eteri ta. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ere Rehoboam eteri a. Rehoboam ere Abiya eteri a. Abiya ere Asa eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ere Jehosafat eteri a. Jehosafat ere Jehoram eteri a. Jehoram ere Usia eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ere Jotam eteri a. Jotam ere Ahas eteri a. Ahas ere Hesekia eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia ere Manase eteri a. Manase ere Emon eteri a. Emon ere Josaia eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia ere Jehoiakin eteri lakemaseken etemri a. Ete yabel Babilon tatame eme Israel tatame emne panen yim, eme Babilonke yin temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yin Babilonke temenem, Jehoiakin ere Sealtiel eteri a. Sealtiel ere Serubabel eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel ere Abiut eteri a. Abiut ere Eliakim eteri a. Eliakim ere Asor eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor ere Sadok eteri a. Sadok ere Akim eteri a. Akim ere Eliut eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut ere Eleasar eteri a. Eleasar ere Matan eteri a. Matan ere Jekop eteri a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop ere Josep eteri a. Josep ere Maria etetri tame. Maria te Jisas erne warwiyim. Eme erne etep wobe. Krais. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham eteri tame supa eme ep yekwo let ep yekwo let tewo bor epe pes epe pes kei (14-pela), Devit ere ek temenem. Devit eri tame supa eme ep yekwo let ep yekwo let tewo epe pes epe pes (14-pela) keyem, eme Babilon komke yin temenem. Emri tame supa ep yekwo let ep yekwo let tewo bor epe pes epe pes kei (14-pela), Krais ere ek yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Krais eterne nawo te warwiyimkap, eri sike gwo. Eri nawo te Maria, eme tene Josep eterne womenem. Josep ere Maria tene mak panemenemke, eme lam, Maria te yenken tem. Yen ere God Eteri Wou eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tene womenem tame, Josep, ere tame yenbo. Ere metem, te yenken tem, ere akeite tatame emne beke wo. Ere papke abom. An tene beke kip pane, an tene mesginte. Sene ere etep abom. An tatame etemri bitimik etep tete, te sebera yate wurken. Etep abom, ere etepkap beke te, ere mo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep ere som abobetem, ere nugsi tuknalam. Nugsi tuknalam, God eteri komri tame wuri ere erne yan terekwunen etep wom. Josep, ne Devit eteri tame supa. Ne Maria tene panete. Ne mane akte. Ne ek met. Ete yen, teri sek tetan yen, ere God Eteri Wouke newom yen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Te taureyen warwite nenbe. Ere tatame emri wule yaper peten sepitte, ere tatame emne sene pette, eke ne eri sig Jisas tete. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Etek tem wos profet tame, ere Keryen God eri tuma wusoubetem tame, ere etek tem wos kiyi bepou me wom. Eri wom tumakap, ete tuma ere yuri seken tem. Tuma wusoubetem tame ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Munguta wuri te tame beke nar, te yen panete, te taureyen warwite. Eme erne tete nenbe sig gwo. Emanuel. Ete sig eri somo etep wobe. God ere neremken tetan. Ere etep won bas rasem. Eri bas rasemkap, Maria te Jisas erne warwiyim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep ere nugsik tuknalamke, ere sene wayen sin God eri komri tame ere erne wom tuma ere etepke tobom. Ere ta tene panem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Panem, ere etetken beke tukna. Berai. Te ete yen ek warwiyimke, yuri epe kir tuknam. Te taureyen warwiyim, eme erne sig tem. Tem sig Jisas. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria te Jisas erne Betlehem komke warwiyim. Betlehem kom e Judia distrikke tetan. Herot eter ere apeilake temenem yabelke Maria te Jisas erne warwiyim. Warwiyim, yuri porereken tame eme yabel wayebe emiri tame, eme Jerusalem etek yam. Yamke, eme etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yen geibele wuri warwiyim, yuri ere Juda tatame etemri keryen tete. Ere mak tetan? Nema yuke laye. Yu eri puspas nema iyalek laye. Nema yawo, nema eterne sukye woran gulke pate yawo. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Apeilake Herot ere ete tuma etep metem, ere wouken aken kenake abom. Jerusalemri tatame nogwape etemken kir wouken aken eme kenake abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herot ere God eri akeri apeilake emne, Moses eri wule wusoubetem tame emne akei wopeten ere emne etep wometem. God eter wom tame, Krais, ere ma komke tete? ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Eme erne etep wom. Ere Betlehem komke tete. E Judia distrikri kom. God eri kiyi temenem tuma wusoubetem tame erne etep wom, tuma wusoubetem tame ere eteri tuma etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Betlehem kom e Judia distrikri kom, ete kom nebule beke te. Berai. E kom sig eisau tem. Akeite kom eisau eme Betlehem kom erne beke teitkwun. Betlehem komri tame wuri ere keryen tete, ere kom panen si tame tete. Ere areri Israel tatame emne kom panen site. God ere erne wom, ere etepke bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Eme Herot erne etep womke, ere yabel waye emiri porereken tame emne wopeten emne tuma elen etep wolam. Makapke kem ete yu lam? ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Eme erne awosein womke, ere emne won Betlehemke yim. Ere emne etep wom. Kem erne noub sopen yin late. Ete yen kem late, kem ane tuma wopeteyate. An kir yin erne gulke pate. Etep wom, ere emne tuma me yikwokwom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Eme Apeilake Herot eri tuma meten yim. Emri kiyi lam yu, eme yabel wayebe emik lam, sene eme lam, yu ere taresin yin yen eter temenem ake mekinke yin tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Eme yu lam, eme metekwasen pap yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Eme akek yin wurin lam, yen ere nawo Mariaken epe etek temenem. Lan eme gulke pan sukye woran, eme emri ayer peten ayerke yewomenem wos liken newom. Eme erne kelken bos yenbo yabe ei subukap wos, bosken kwar erne etep newom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Newon sene eme nugsi tuknalam, God ere emne etep wom. Kem Herot ere tetan emi kem mane ete keluke sene yite. Etep womke, eme akeite keluke sene yin etemri komke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Eme yimke, God eri komri tame ere yan Josep erne nugsik terekwunen etep wom. Herot ere yen pen sate wobe. Eke ne yenken nawoken epne panen kantri Isipke amen yite. Ne etek yin temente. Yuri an nene sene wotek, kem sene yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Etep womke, Josep ere wayen ere yentaken epne panen neirke berasen kantri Isipke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yim, Josep ere Isipke temenem, Herot ere samke, eme sene yam. Etepkap, Keryen God eri tuma wusoubetem tame eteri tuma ere seken tem. God ere erne wom, ere God eri wom tuma etep bas rasem. Ari taureyen ere kantri Isipke temente, an erne sene won yate. Etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot ere metem, iyale yekwok yam porereken tame eme erne sene beke yin la. Ere meten, ere etep abom. Eme sene ane beke kip yan la. Eme arene me yikwokwom. Etepke abon, ere pap wayen, ere tame kau emne won yim, Betlehem komken akeite mekinke tetan komken Rama komken emne etek won yim. Yim, eme nabe pes tem taureyenken geibele yenken emne pen saiwom. Porereken tame eme Herot erne kiyi etep wom. Kiyi nema yu lan yam, nabe pes nema keluke yam. Etep wom. Eke eme nabe pes wom yen emne pen saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kiyi God eri tuma wusoubetem tame, Jeremaia, ere ete wos kir wom. Eri wom tuma sekenwai tem. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Eme tumaken tayeken Rama komke metbe. Eme nogwape kera taye metbe. Resel te teri yen emne kerabe. Teri yen eme akei saiwom, tatame eme tene kobo lan wotaken nenlawoibe, te pap yaper som tetan. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Yuri Herot ere samke, Josep ere kantri Isipke temenem, ere nugsi sene tuknalam, God eri komri tame ere erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ne wayen neri yentaken panen kantri Israelke sene yite. Yen pen sabetem tame ere sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ere etep wom, Josep ere yenta epne panen kantri Israelke sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ere metem, Herot eri yen Arkelaus ere a eri yaku petem, ere Judia distrikri apeilake tem. Etep metem, ere Judiak tete mo wom, ere me akem. Me akem, God ere erne terekwunemke, ere Galili distrikke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yim, ere Nasaret komke yin tem. Etep tem, tuma wusoubetem tame emri kiyi wom tuma ere seken tem. Ere etep wom. Tatame eme erne Nasaret komri tame wote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Eme Nasaret komke yin tem, baptais ok wirubetem tame, Jon, ere yam, ere Judia distrikke yam, tameken berai emik yan temenem. Temenem, tatame eme yabetem, ere emne tuma wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ere etep wom. God eri kom panen site yabel mekin mekinye. Kem wule yaper magel taite, yenbo woswou pap yewote. Kem etep tete, God ere kemne kom panen site. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","God eri tuma wusoubetem tame, Aisaia, ere Jon eteri tuma emne kiyi wusowum. Ere etep wom. Tame wuri ere tameken berai emik noubke wote. Ere etep wote. Kem Aneyen eri yate nenbe kelu eyarte. Eri yate kelu kem noub akwun eyarte. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon ere kelken berai tame, ere kerap yaper warbetem, ere kamel por wuske kapem tame oub warmenem, ere moutip mopke sibetem. Sibetem, ere boulri wos yaper abetem, musken wuyewuye yenken ere eteke abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abetem, Jerusalem komri tatame, Judia distrikri tatame, Jordan peik mekinke temenem tatame eme Jon erne yin lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yin lam, eme emri nenbetem wule yaper erne wusowumke, ere emne Jordan peikke baptais ok wiruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon ere lam, Juda tatame nogwape emri apeilake, Farisi tameken Sadyusi tameken eme kir baptais ok wirute yam. Yam, ere emne etep wom. Kem wale yaperkap, kem porere yaper tetan tame. Beke kem ane late yawo? Yuri God ere kemne pap wayete. Ere tatame emne paku pete, ere kemne kir pete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kem ane mane yan late. Kiyi kem wule yenbo nente. Kem etep nente, akeite tatame eme lan etep wote. Eme wule yaper mesginye, eke eme yenbo wos nenbe. Etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kem etep wobe. Abraham ere neremri warege. Ere tame yenbo. Eke nerem kir, nema tame yenbo. Kemri etep wobe tuma e tuma seken berai. Kem Abraham eteri nan, kem tame yenbo berai. Eter tebetemkap, kem beke te. Kemri selpap yaper kem mesginte, kem tame yenbo tete. God ere abotek, ere gwo pape peten ere tame ek seikte, sene eme Abraham eteri yen tete. Kem bepou mane etep wote. Nema Abraham eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yuri yate tame ere wor letke sebe tamekap. Ere me teite, ere somok teite. Me nogwape eme supa yenbo beke ya, ere ete me emne teyin kerke liste. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kem akeite selpap yaper mesginte, selpap yenbo pette, an kemne baptais ok wirute. Ari kin yekwok yate nenbe tame ere kemne God Eteri Wou kemne newote. Kemri nenbe wule yaper ere kerke liste. Ete tame ere tame eisau, ere tame yenbowai. Aren, an tame nebule. An tame yenbo berai, nesa wolbaye wurisubuk beke kip si. An nebule yen, an selke site. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kopi saug tame eme peten sepitbekap, ete tame ere tatame yaper emne kerke pete warte nenbe. Ete ker ere som ei betete nenbe. Tame eme kopi om peten akek rasbekap, ere tatame yenbo emne eri akek panen yite nenbe. Jon ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jon ere etek temenem, Jisas ere Galili mesginin Jordan peikke yim. Ere Jon eterne late yim, Jon ere erne baptais ok wirute yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yim, Jon ere erne wotaken etep wom. Beke aren nene baptais ok wirute. Neren ane baptais ok wirute, e yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Etep womke, Jisas ere erne awosein etep wom. Berai. Neren ane baptais ok wirute. Ne etep tete, ne God eri wom tuma tobote. Etep womke, Jon ere kir tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ere erne baptais ok wiruwumke, Jisas ere ok mesginin wayebetemke, gwan beram. Beram, eme lam, God Eri Wou ere nel borborke ap bourkap yan yeirin, Jisas eteri telak yeirin sim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yeirin sim, tuma wuri nelke etep wom. Gwo ari yen yenbo adebas. An erne oksubu ten metekwasbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Gabo etemri apeilake Satan ere Jisas erne seilate womke, God Eri Wou ere Jisas erne tameken berai emik panen yite wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yim, Jisas ere a beke a. Neirken yabelken nogwape (40-pela) ere bepou me temenem, ere kwoi sabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kwoi sabetem, Satan ere yan erne etep wom. Ne God Eteri Yen seken, ne wotek, gwo pape eme geilke tetek, ne peten ate. Ne etep tetek, an late, ne God Eteri Yen. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ere awosein etep wom. God eri siglou etep wobe. Tame eme aomsubu abote, eme noub beke te. Tame eme God eri tuma mette, eme noub temente. Etep womke, ere Satan eri wom tuma beke tobo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sene Satan ere erne panen kom sag Jerusalemke yim. Yim, ere erne God eteri ake eisau magelke panen yawom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Panen yawom, ere erne etep wom. Ne God Eteri Yen temente, ne kerpen warte. God eri siglou etep wobe. God ere eri komri tame emne won yate, eme nene kobo late. Neri tewo papek beke kip pe, eme nene letke pette, ne noub waren tetete. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ere erne awosein etep wom. God eri siglou etep wobe. God ere nereri Keryen, eke ne erne mane seilate. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satan ere erne sene panen kow eisauke yawon ere erne nogwape nowselri kom ake peteram, ete komke tetan wosbas nogwape kir akei peteram. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Peteram, ere erne etep wom. Ne gulke pan ane sukye woratek, ete wos nogwape an nene akei newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Etep wom, ere erne awosein etep wom. Satan, ne seki. God eri siglou etep wobe. Kem Keryen God eterwoune sukye worabet, eterwoune yaku kerebet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Etep womke, Satan ere erne seilawoyin ere erne mesginin yim, God eri kom tame eme yan Jisas erne kobo lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisas ere metem, eme Jon erne ake yaperke panen yim. Ere etep meten ere Galili distrikke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yim, ere eri maime Nasaret kom beke yin te. Ere Kaperneam kom etek yin temenem. Kaperneam kom e peik kupa barke tetan, Sebulunken Naptaliaken etemri selke tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Etek yin temenem, kiyiri tuma wusoubetem tame, Aisaia, eter wom tuma ere sekenwai tem. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulun selken Naptali selken epe kerokke yibe keluke tetan. Epe Jordan peik keraruke tetan. Ete sel e Juda tame, Juda berai tatame etemri sel wule. E Galili distrikke tetan. Juda tatame nogwapeken ekya tame nogwapeken eme etek tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ete tatame kerneirikapke sitenkap, eme wule yaper tobobe. Yuri eme tu eisau late. Ete tu eisau ere kerneirik sin sabe tatame etemne tobukte, eme kom geinik tete. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Etek yin temenem, ere tuma tasen wusowum. Ere emne etep wom. Kem keremri porere yaper mesginte. God ere kemne kom panen site yabel mekin mekinye. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas ere Galili peik kupa barke sewurbetem, ere lakemase per epne wopetem, Saimonken Andruken. Saimon eri akeite sig wuri e Pita. Ere lam, epe omyen petbetem tame, epe peikke wuli rasen omyen petbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Petbetem, ere epne etep wom. Kep arenken yite. Kiyi kep omyen petebetem. Kep omyen petbetemkap, an kepne noub peterate, kep tame etepke pette. Pette tame eme areri wakse tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Etepke womke, agetage epe epri wuli mesginin eterken yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ere sene yibetem, ere lam, lakemase per Jemsken Jonken epne lam. Epe Sebedi eteri yen. Ere lam, etepri ar eter Sebediken perek simenem, wuli let mate nabetem. Nabetem, ere epne yate wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yate wom, agetage epe epri ar erne perek mesginin eterken yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ere yin Galili komke sewurbetem. Sewurbetem, ere God eteri akek tuma wusoubetem, ere God eri tuma yenbo emne wusoubetem, ere numa pemenem tatame emne eyarbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Etep tebetem, kantri Siriari tatame eme etep metemke, eme akeite akeite numa pe tatame emne panen yam. Gabo gulelemenem tatameken sasoubbetem tatameken, let tewo saiwobe tatameken, ere emne sene eyarbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Eyarbetem, tatame nogwape eme erne semoubetem. Galiliri tatame, Dekapolisri tatame, Jerusalemri tatame, Judiari tatame, Jordan peik keraruke temenem tatame eme erne semoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas ere tatame nogwape emne lam, ere kowke yawon sim. Simenemke, eri anepoi eme erne yin lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yim, Jisas ere emne tuma tasen wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ere emne etep wom. Tatame eme God erne etep wote. An nene noub beke met. An neri tuma mette abobe. Etep wote tatame eme metekwaste. God ere ete tatame emne kom panen site. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tatame eme emri yaper nenbekap lan pap yaper tete, e yenbo. Ete tatame eme metekwaste. God ere emri pap ragerte nenbe. Eme pap sene yenbo mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tatame eme emri sig maime eisau beke wo, eme metekwaste. Eme God eri wom wos nogwape pette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tatame eme God eri wule yenbo tobote abobe, eme metekwaste. Eme a an se kir ten, se kwoi sene beke sa tatamekap. Emri wolabe wos God ere emne newote nenbe, eme sene beke kip wola. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tatame eme akeite tatame emne kobo labe, eme metekwaste. God ere emne kir kobo late nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tatame eme selpap yenbowai tetan, ete tatame eme metekwaste. Yuri eme God erne late nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tatame eme ei wotakebe, eme metekwaste. God ere emne etep wote. Kem ari yen. Etep wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","God ere wobe tumakap, tatame eme etep tobote, sene tame kau eme emne yaper nente, eme mus eisau mette, ete tatame yenbo eme metekwaste nenbe. God eteri kom e etemri. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kem ane semoube, eke tatame kau eme kemne tuma yaper wote, kemne yaper nente, kemne tuma kenake yikwokwote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Etep tete, kem metekwaste nenbe. Kemri tokwo eisau God eteri komke kemne etek kouten. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Weyeke kerebe kiti, kupa beke kip te. Kerem kem nowselri tatame etemne kerebe weyekekap. Kem tatame emne kobo late, eme wule yaper mesginte. Weyeke ere tuma beke kip kute, e weyeke yaper. Weyeke yaper sepitin tewok teserbekap, kem yaku yenbo beke kip kere, God ere kemne magel taite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kerem, kem nowselri tatame etemne tu kerebekap. Kowke siten kom, tatame eme kaike kuyese late. Ete kom beke kip beras. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tame eme lam yarbe, eme tukna tiy kulke beke tuk. Berai. Eme tiyke tukbe, ere kukmenbe, komke tetan tatame nogwape eme kuyese labe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Eme lam yaren kom geinik tukbekap, kem wos yenbo kom geinik nente. Tatame eme kerem nenbe porere yenbo late, keremri Hevenke tetan Apei erne eme tuma yenbo wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kem mane etep abote. An yam, an Moses erne newom wuleken kiyiri tuma wusoubetem tame emri wom tumaken an keroukte yam. Berai. An yam, an ete wuleken ete tumaken an noub won seken tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","An kemne sekenke wobe. Nelken selken omote yabel tete, God ere Moses erne newom wule ere som temente nenbe. Akei wos kiyi tete, ete wule eri bas ras akei som kir temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tame wuri ere wule wuri naswoite, ere akeite tame emne etepkap tete wote, ere tame erne God eteri komke eme erne sig eisau beke wo. Tame ere ete wule noub meten tobote, ere tatame emne ete wule wusoute, ete tame erne God eteri komke eme eri sig eisau wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","An kemne wobe. Kem wule wusoube tameken Farisi tameken etem tebekap tobote, kem Heven beke kip yi. Kem etemri tebekap teitkwunen wule yenbo tobote, kem Hevenke yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yeiwarege emne kiyi wobetem tuma kem metem. Eme etepke wobetem. Kem alwo mane pete. Kem alwo pete, kem ete tuma yuri namdete nenbe. Etep wobebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Aren, an kemne akeite tuma wuri wobe. Tame ere lake o mase emne pap wayete, God ere erne tuma namdete nenbe. Tame ere eri lake o mase emne tuma yaper wote, apeilake etemri kaunsil eme erne tuma namdete. Tame ere akeite tame erne ragi eyin etep wote. Ne worisubu tame. Etep wobe tame ere ker tetan komke yite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ne God erne wos newote aboye, sene ne abote, neri lake o mase ere nene pap wayewo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Etep tetan, ne God eterne newote wom wos ne yin eterne kwar pebe tiy mekinke rasrute. Rasruwun, ne yin neri lake o maseken ne eterken tuma namden gerute. Tuma namden geruwun, ne sene yan God erne wos ek newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tame ere nene tuma namdete yibetete, kep kelu yibetete, kep kip agetage geru. Ete tame ere nene tuma met tame erne kiyi wote wurken, ere nene nau se tame emne kiyi wote wurken, eme nene ake yaperke kiyi won wurte wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","An kemne sekenke wobe. Ne ake yaperke yite, ne etek temente. Eme wote lup o nabe omote, ne ake yaper mesginin komke sene yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kiyi temenem tatame eme wobetem tuma kem metten. Eme etep wobetem. Tame eme ete taken sir mane yite. Ta eme ete tameken sir mane yite. Etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aren, an kemne akeite tuma wuri wote. Tame ere ta tene malbe, ete tame ere wule yaper seken nenye. Ta te tame malbe, te wule yaper seken nenye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Neri le sebera ya wos lan nente abobe, ne ete le puken sepitte. Ne le wurisubu temente, e wos eisau berai. Wos eisau e neren ker tetan komke yite wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Neri let ere sebera ya wos nente abobe, ne ete let temen sepitte. Let wurisubu temente, e wos eisau berai. Wos eisau e neren ker tetan komke yite wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kiyi temenem tatame eme etep wobetem. Tame ere eri ta tene mesginte wote, ere tene siglou wuri bas rasen newon, ere tene ek mesginte. Etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aren, an kemne akeite tuma wuri etep wobe. Ta te sir bisi beke yi, tame ere tene bepou me mesginte, e yaper. Ere tene mesginte, sene ete ta te akeite tame yite, te tame yibe wule yaper nenye. Etep tebe, ete ta teri kiyi yim tame eter me eiksem. Ere tene bepou mesginim. Teri yurik yite nenbe tame eter kir ere ta panebe wule yaper nenye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yeiwarege eme tatame emne etep wobetem. Kem tame kupa takte, kem tuma mane yikwokwote. Kem Apei God eterne kupa takbe, kem etepwou tete. Eme etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aren, an kemne akeite tuma wuri wote. Kem akeite tatameken tuma namde raste, kem tame kupa mane takte. Kem akeite wosri sig tame kupa mane takte. Nel e God eteri siten emi, eke kem nel mane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kem sel mane wote. Gwote sel e God eteri wolbaye nebule. Ere tewo etek teitbe. Kem Jerusalem kom sig mane wote. Jerusalem e kom panen siten tame God eteri kom sag. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Keremri wule kem tare mane kupa takte. Kemri tare kem maime mane kupa takte. Kem mapeke ten kem kemri tare take maime won kerkereken geipaken tete. God eterwou ere etep kuyese nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kem etepwou wote. Ye. An nente. O kem etepwou wote. Berai. An beke kip nen. Etep wote, e yau. Kem sene mane namden tame kupa mane takte. Kem tame kupa takbe, Satan eter ere kemne wobeke, kem tame kupa takbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kem metem. Kiyi temenem tatame eme etep wobetem. Tame ere akeite tame erne pete, ete tame ere erne awosein pete. Tame ere akeite tame erne pen nep yeirte, ere erne awosein pen nep kir yeirte. Etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aren, an kemne akeite tuma etep wobe. Tame ere kemne yaper nente, kem ete tame erne yaper mane awosein nente. Tame ere kemne pouye buroute, kem sene ep yekwo pouye taite, ere kemne ep yekwok sene buroute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tame ere kemne tuma namdete, ere kemri tame oub wuri pette wote, kem erne tame oub wurisubu mane newote. Kem erne peske newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O tame ere kemne wos mekin kerak sen yite, noubke kemne egiyete, kem erne kobo lan, gene kerak sen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tame ere kemne won erne wos bepou me newote wote, kem erne eger mane tete. Kem erne bepou me newote. Tame ere kemri wos pette wote, ere kemne yurik awosein newote wote, kem eger mane tete. Kem erne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kem metem, kiyi temenem tatame eme etep wobetem. Kem kemri tameya emne pap yewote, kem peiktame emne yaper nente. Etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aren, an kemne akeite tuma wuri etep wote. Peiktame emne kem pap kir yewote. Tame eme kemne yaper nente, kem God erne womette, ere emne kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Etep tete, kem Hevenke tetan Apei eteri yen tete. God ere akei tatame emne yenbo nenbetbe. Ere wobe, yabel ere ek pasbe. Pasbe, tame yaperken tame yenboken emri now awos eisau ten yabe. Ere wobe, mou tibe. Tibe, yenbo nenbe tameken yaper nenbe tameken etemri nowri awos eisau ten yabe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kemne yenbo nenbe tame etemwoune kem pap yewote, God ere kemne mapeke yenbo nen. Kel petbe tame yaper etem kir eme etep tebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kem kemri tamenowu etemnewou pir won tuma namdete, kem tame nogwape etem tebekap tete. God erne beke abo tame etem kir eme etep tebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Keremri Hevenke tetan Apei ere yenbowai. Kem etepke tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yenbotanbo wule kem tatame emri bitimik mane nente, eme mane late, eme kemri sig eisau mane wote. Kem tatame emri bitimik etep tete, kemri Hevenke tetan Apei ere kemne tokwo wuri beke kip newo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kem wosken berai tame emne wos newote wote, kem akeite tame emne mane wusoute, eme kemri newoye wos late wurken, eme kemri sig eisau wote wurken. Kem etepkap beke nen, e yenbo. Maime sig eisau wobe tame eme God eri akek wurbe o keluke tetebe, eme akeite tatame emne wusowun God erne wos ek newobe. Etepkap akeite tatame eme lan emri sig eisau wobe. Kem etepkap mane nente. An kemne sekenke wobe. Etepkap tebe tame, gwopte eme emri tokwo akei eyi petye. Yuri God ere emne tokwo sene beke kip newo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kem wosken berai tame emne kobo late, akeite tame eme kemri wule mane late, eme kemri kobo late tuma mette wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kem me berasen wosken berai tame emne kobo late. Epkap kemri Hevenke tetan Apei ere berasen nenbe wos kuyese labe, ere kemne tokwo awosein newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kem God erken tuma namdete, kem tuma okkap sirbe tame etem tebekap kem mane nente. Eme God erken namdebe, eme God eri akek wurin tetebe, o keluke teten ek namdebe. Namdebe, yi yabe tatame eme emne labe, eme emri sig eisau wobe. An kemne sekenke wobe. Etep tebe tame, eme tokwo akei petye, yuri eme sene beke kip pet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kem God erken tuma namdete, kem ake purik wurin eru kit kerete. Kit keren, kem kemri lek beke la Apei erken namdete. Kemri Apei God ere kemri berasen nenbe wos kuyese labe, ere kemne tokwo newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kem God erken tuma namdete, kem god seken berai erne abobe tame etem namdebekap mane namdete. Eme abobe, eme tuma eisau som namdete emri abobe seken berai god ere kuyese mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kem emri tebekap mane nente. Kemri yuri eiksete wos, kemri Apei God ere kiyi laten. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kem God erken tuma namdete, kem etep wote. Neremri Hevenke tetan Apei, nema abobe, neri sig yenbowai tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nema abobe, ne akei kom panen site. Neri kom tame eme neren wobe tuma etepwou tobobe. Epkap nema abobe, nema nowselri tatame nema kir etepwou tobote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ne nemne gwotepteri awos newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tatame eme nemne yaper nenbe, nema emne gerubekap neren kir nemri yaper nenbekap ne gerute. Ne sene mane abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ne nemne mane som seilate. Satan ere nemne keresukte wurken. Kem Apei God erken tuma namdete, kem etepke wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kem akeite tatame eme kemne nenbe wule yaper gerube, keremri Hevenke tetan Apei eter kir ere kemri nenbe wule yaper gerube. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kem akeite tatame eme kemri nenbe wule yaper beke geru, kemri Hevenke tetan Apei eter kir, ere keremri nenbe wule yaper beke kip geru. Ere som abon yaper kemne awosein nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kem God eterken tuma namden a mesginbe, kem bitimi mane yaper late. Akeite tatame eme mane mette, kem a mesginye. Tuma yikwokwobe tame eme etepke bitimi yaper tebe. Tatame eme etemri bitimi labe, eme abobe, eme awos mesginye. Etepkap, eme emri sig eisau wobe. Metye. Etepkap tebe tame eme emri tokwo akei petye. God ere emne sene beke kip newo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kem awos takerte yabel kem kemri tare take woran kem ok wiyin bitimi yenbo late. E yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Etep tete, tame eme kemne lan beke etep kip abo. Kem a mesginye. Nemri lek beke la Apei eterwou ere metten. Nemri Apei God ere nemri berasen nenbe wos labe, ere kemne tokwo newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kem maime abo. Nowselri wos yenbo kem mane peten raste. Didiwarkebai eme nowselri wos regbe, sesegwan nowselri wos nogwape kerebe, wosbas sir petbe tame eme ake regen sir petbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kem God eri wule noub sete. Kem etep tete, e God eteri komke peten rasbe wos yenbokap. Ete wos e nowselri woskap berai. Didiwarkebai eme ete wos beke kip reg, sesegwan beke kip kere, sir petbe tame eme ake beke kip regen wurin sir beke pet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Neri wos yenbo rasten emi, neri pap etewouke temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Le e wusomri tukap. Kemri labe wos kem papke abobe. Kem yenbo woswou late, kem yenbo woswou abote. Kem noub tuke sewurbekap, kem etep tete, kemri porere wusom yenbo tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kemri le e yaper woswou late, kem yaper wos abote. Kem neirke bepou me sewurbekap, kemri porere wusom etepkap yaper tete. Porere yaper e yenbo berai. E ker neirke sewurbekap. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tame ere yaku lakerebe tame pes etepri yaku kuyese beke kip kere. Wuri erne ere pap wayete nenbe, wuri erne ere metekwaste. Wuri eri yaku ere noub kerete nenbe. Wuri eri yaku ere yaperke kerete nenbe. Etepkap, God eri yakuken kel yakuken kem peske kuyese beke kip kere. Berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Eke an kemne wobe. Kem tetankap mane ep abo ep abote. Kem awosken kerap wole wosken mane ep abo ep abote. Awos e eisau wos berai. Kem tetankap e wos eisau. Kerap wole wos e wos eisau berai. Kemri wusom e eisau wos. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kem ap emne abote. Eme sag beke kere, kwoi beke peren kwoyeakek beke ras. Berai. Kemri Hevenke tetan Apei ere ap emne noub lakerebe, emne awos newon abe. Ap eme eisau wos berai. Kem tatame, kem eisau wos. Eke, God ere kemne kir noub lakerete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tame ere ep abo ep abote, ere yabel wurinabu sene temente? Berai. Ere yabel wuri sene beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Beke kem kerap wole wos ep abo ep abobe? Walku emri kerap kem abote. Eme yaku beke kere eme kerap wole wos beke abo. God ere emne noub lakerebe, eke eme kerap yenbo wolebe. God ere kemne kir noub eyarte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Keryen tame Solomon ere kiyi temenem wosbasken tame. Ere kerap wolebetem, eri kerap e yenbo. An kemne wobe. Menamane emri walku emri kerap e yenbosubuwai, eme Solomon eteri kerap me teitkwunbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Walku kerap nema labe, gwopte eme tetan, kipi o kwokwos eme sok tebe. Eme som beke te. Etepkap, edepure wos God ere emne kerap yenbo wolerube. Kem tatame, kem wos eisau. God ere emne kerap wolerubekap, ere kemne kerap wole wos kir newote. Kem etep abobe. God ere nemne beke kip newo. Kem etepkap mane abote. Kem God erne womette, ere kemne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Etepkap kem mane ep abo ep abote, etep mane wote. Nema be woske ate? Nema be okke ate? Nema be kerapke wolete? Kem etep mane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","God erne beke abo tatame eme etepkap abobe. Kemri Hevenke tetan Apei ere kemne laten. Kem be wos eikseten, ere metten. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Eke kem God erne kiyi abotek, eri wom tuma kem kiyi nentek, ere kemne wos ek newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kipi tete wos kem mane ep abo ep abote. Kipiri wos e kipik tete nenbe wos. Wurare wurare yabelri wos yaper, e yabel wuriri wos. Kem mane som sene ep abo ep abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kem akeite tame etemri porere emri tebekap mane si lan etep wote. Eme tame yaper. Kem emne si late, God ere kemne awosein si lan wote. Kem tame yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kem tame emri porere, emri tebekap si lan wotekap, God ere kemne etepke awosein si lan wote nenbe. Eke, kem akeite tame emne mane si late. Kem emne nenbe wulekap, God ere kemne ete wuleke awosein tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Beke kem akeite tatame emri yaper nenbe wule nebule si labe, kemri nenbe wule yaper eisau kem maime beke la? ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kerem nenbe wule yaper e eisauwai. Kem akeite tatame emne etep mapeke wobe. Neri wule yaper nebule an nene peterate, God ere eyarte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kem tuma yikwokwobe tame. Kem kerem nenbe wule yaper kiyi mesginte, sene kem akeite tatame etem nenbe wule yaper kuyese lan peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","God eri tuma mette mo wobe tatame emne kem God eri tuma emne mane wusoute. Kem emne wusoutek, eme kemne tame tabe walekap yan tate. Tatame eme God eri tuma etep wobe. E tuma yaper. Etep wobe tatame emne kem God eri tuma mane wusoute. Eme meten magel taibe. Wos yenbo tame eme por emne mane raspitete, por tewo mane elik teitte. Etepkap, God eri tuma mette mo wobe tatame emne kem God eri tuma mane emne wusoute. Eme kemri wobe tuma magel tayen eme kemne yaper nente nenbe. E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kem God erne som wometbetete, kemri wometbekap God ere nente. Kem som sopbetete, kemri sopbe wos kem late. Kem eru som pemetbetete, God ere kemne eru latte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tame ere tewok tewok womette, eri wometbekap God ere nente. Tame ere wos tewok tewok sopte, eri sopbe wos ere late. Tame ere eru tewok tewok pemette, God ere erne eru latte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ane kem, yen eme kemne a wometbe, kem emne selgerke newobe o? Berai. Kem emne aomke newobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O, eme kemne omyen wometbe, kap, kem emne sopo maske newobe o? Berai. Kem emne omyenke newobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kem tame yaper, kem keremri yen emne wos yenbo newobe. Nemri Hevenke tetan Apei ere tame yaper berai. Ere yenbowai. Eke, tatame eme erne womette, ere emne wos yenbowou newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Moses ere bas rasem wuleken God eri tuma wusoubetem tame etemri tumaken epri somo gwo. Kem abobe, tatame eme kemne yenbo nenbekap, kem akeite tatame emne etepwou nente, e ete tuma etepri somo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kem kelu nebulek yite. Ker tetan komke yibe kelu e eisau, barapai. Tatame nogwape eme ete keluke yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Hevenke yibe kelu e kelu nebulewai. Tatame eme ete keluke yite, eme yaku eisau keren eme ek yite. Ete keluke yibe tatame eme nogwape berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kem noub la. Kau tame eme tuma yikwokwobe tame. Eme tuma yikwokwon etep wobe. Nema God eri tuma seken wusoube. Etep wobe. Tatame eme ete tame emne labe, eme etep abobe. Eme tame yenbo. Etep abobe, emri porere yaper eme beke la. Eme seyi wus wolen sopo wuskap tebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kem emri tebekap noub late, kem emne abote, eme tame yaper. Eme wos yaper nenbe. Keibi supa eme lagken kupunuburke beke ya. Mane supa eme kwayek beke ya. Berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Me yenbo eme me supa yenbo yabe. Me yaper eme me supa yaper yabe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Me yenbo e me supa yaper beke kip ya. Me yaper e me supa yenbo beke kip ya. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Me eme supa yenbo beke ya, tame eme ete me teyin kerke lisbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Etepkap, tuma yikwokwobe tame emri tebekap kem noub late, etep kem abote, eme tuma me yikwokwobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ane Aneyen taye tayebe tatame, akei eme God eter panen siten komke beke kip yi. Berai. Tatame eme ari Hevenke tetan Apei eri wom tuma noub meten tobobe tatame, etemwou eme God eter panen siten komke yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tuma namdete yabel tatame nogwape eme ane etep wote. Aneyen. Aneyen. Neri murek nema neri tuma wusoubetem. Neri murek nema gabo pen keroukbetem, neri sigke nema rigrabe nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Etep wotek, an emne wote. Kem areri yen berai. Kem wule yaper nenbe tame, kem ane seki. An emne etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tatame eme ari tuma meten tobote, eme porere yenbo tetan tamekap. Eme ake pape luke kerebe tamekap. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pape luke kerem ake, mou marye yam, ok wayem, ete ake erne rulawoyim, ake beke kip tere. Ake ere som temenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tatame eme areri tuma bepou me metbe, eme beke tobo, eme eikse akse tamekap. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Eme emri ake senke kerebe tamekap, mou marye yam, ok wayem, ete ake ere teren warem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas ere ete tuma won omomke, tatame nogwape eme eri tuma metem, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Moses eri wule tuma wusoubetem tame eme wusoubetemkap ere etep beke wusou. Berai. Ere apeilake etem wusoubetemkap ere emne etepke wusoubetem, eke eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas ere kow mesginin sene warem, tatame nogwape eme erne semowun yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Semowun yim, numa pe tame ere yan Jisas eteri tewo tobok gulke pan guromun etep wom. Aneyen, ne wote, ne ane yenbo nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Etep womke, Jisas ere erne let keren etep wom. An wote. Ne yenbo sene tete. Etep womke, agetage erne pemenem numa sok tem, ere yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tem, Jisas ere erne etep wom. Metye. An nene yenbo nenye, ne eike tamene mane wusoute. Agetage ne God eteri akek yin neri wus God eri akek yaku kerebe tame erne peterate. Moses eri kiyi wom tuma ne etep tobote, ne God erne kwar pete. Etep tetek, tame eme late, eme abote, nene pemenem numa sok tem, ne yenbo tem. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas ere Kaperneam komke yin wurim, akeite nowselri ei nai tame emri apeilake ere yan Jisas erne etep wometbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aneyen, ari yaku kerebe tame ere yaper metbe, ere akek tuknaten. Eri letken tewoken sam, ere mus eisau metbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Etep womke, Jisas ere erne etep wom. An yan erne eyarte, ere sene yenbo mette. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ei nai tame emri apeilake ere eri sig maime teitkwunen erne etep wom. Ne mane yate. An tame yenbo berai. Ne areri ake mane yin wurte. An sebera yate. Ne tumak wotek, ari yaku kerebe tame ere yenbo mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","An akeite apeilake eteri kulke tetan. Ari ei nai tame eme ari kulke tetan. An ei nai tame emne yite wobe, eme ek yibe. An tame emne yate wobe, eme ek yabe. An ari yaku kerebe tame emne yaku kerete wobe, eme ek kerebe. Etepkap an metten, ne apeilake, ne wote, ari yaku kere tame ere yenbo sene tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas ere etep metem, ere wouken akem, erne semowumenem tame ere emne etep wom. An kemne sekenke wobe. Juda tame eme gwo tame eteri kenawaike abobekap beke te. Ere emne teitkwunbe. Ere metten. An yaper metbe tame emne kuyese eyarte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","An kemne wobe. Juda tatame eme God eri panen siten komke yite. Etemwou beke yi. Nowselri tatame nogwape eme kir yite. Yabel wayebe yekwori tatame, you yekwori tatame eme kir yite. Eme wurte, eme Juda tatame emri yeiwarege Abraham, Aisak, Jekop etemken etek sin a ate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Juda tatame nogwape eme beke wur. God ere emne won yite, emne ker tetan komke won yite. Etep tete, eme mus eisau mette, eme kenake kerate nenbe. Eme mus eisau mette, eme ker wobetete nenbe. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sene ere ei nai tame emri apeilake erne etep wom. Ne akek yi. Neri kenawaike abobe wos ne late nenbe. Etep womke, agetage ete tame eri yaku kere tame ere yenbo metem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas ere Pita eri akek wurin lam, Pita eri owi te wus kerem, te tiyke tuknamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tuknamenem, ere etetri letke kerem, teri wus yenbo tem, te wayen Jisas erne iyawu keren erne awos newon am. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Perpe temke, tatame eme gabo gulelemenem tatame nogwape emne panen yam, eme Jisas eter temenem emik panen yam. Panen yam, Jisas eteri tumak etek gulelemenem gabo emne ere pekeroukum, ere kapoyi metbetem tatame emne yenbo nenem, eme yenbo meten eyar tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Etep tem, God eri kiyi wom tuma, e tuma wusoubetem tame, Aisaia, ere kiyi wusowum tuma ete yabel e tuma ere seken tem. Aisaia ere kiyi etep wom. Eter ere neremri metbe kapoyi peten sepitim. Ere neremri akeite akeite metbe kapoyi yenbo nenem. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas ere lam, tatame nogwape eme eterne serkap pem, eke ere eri anepoi tame emne etep wom. Nema ete peik kupa keraruke wute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Etep womke, Moses erne newom wule wusoube tame wuri ere etep wom. Tuma wusoube tame, ne mak yi mak yite, an nerenken kir yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisas ere erne etep wom. Boulke sewurbe por wale eme sel purik tuknabe. Ap eme neske tuknabe. Aren, an Tatame Etemne Lan Yeirim tame, an tukna emiken berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tame wuri, ere Jisas eteri anepoi tame, ere Jisas erne etep wom. Aneyen, neren kir wotek, an apei erne kiyi meike raste, yuri an nerenken yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ere awosein etep wom. Ne ar erne mane mei peren raste. Ne arenken yate. Ane beke abo tatame eme sabe tamekap. Ete tame etem eme saye tame emne mei peren raste. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas ere perek waremke, eri anepoi tame eme eter warem perek warem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Waren yim, mou marye eisau yam, ok sare eisau yabetem, pere gergerte nenem, Jisas ere tuknamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tuknamenem, anepoi tame eme yin erne teren wayen sin etep wom. Aneyen, ne nemne kobo la. Nema sate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ere awosein etep wom. Beke kem akbe? Kem ane kenawaike beke abo, eke kem akbe. Etep womke, ere wayen teten maryeken ok sareken epne wotakem, maryeken ok sareken epe beyim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Etep temke, eme pap etewouke ten etep wom. Ere mapkap tame? Maryeken ok sareken epe eteri tuma meten beiwo. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas ere perek sene yibetem, ere ep yekwo peik kupa Galili keraruke wum, Gadara yekwok yim. Yim, tame pes epe tame sele emi mesginin erne yan lam. Epne gabo gulelemenem, epe tame tabe wale yaperkap, tatame eme epne akbetem. Epri emi tatame eme etek beke yi. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yin lam, epe noubke ten etep wom. Ne God Eteri Yen. Ne kap nesne mapeke kip nen? Ne kap nesne yaper nente o? Gwopte ete tuma namdete yabel berai. Gwopte ne nesetne yaper mane nente. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Por nogwape eme etek mekinke an sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gabo eme erne etep wom. Ne nemne lelete, ne nemne won nema ete por etemne gulelete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ere emne etep wom. Kem epe yi. Etep womke, eme ete tame epne mesginin yin por etemne yin gulelem. Gulelem, ete por eme agetage amekirin yin emi yaperke warkutem, peikke kerpen okke an saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Por emne lakerebetem tame eme etep lam, eme me amen komke yim, emri lam wos eme yin wusowum. Gabo gulelemenem tame pes epne temkap eme etep wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wusowum, kom sag tame eme Jisas erne sopen yin lan erne etep wom. Ne neremri sel mesginin yite. Eme akemke, eke eme etep erne wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Eme erne womke, Jisas ere perek waren peik keraruke sene wum, ere eteri maime komke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yim, letken tewoken bulworam tame erne tatame eme erne tame sebe tiyke yewon sen yam. Jisas ere erne eyarte eke eme sen yam, eme eter temenem akek sen yam. Sen yam, Jisas ere lam, eme eteri mure kenawaike abom, eke ere let tewo sam tame erne etep wom. Ari yen, ne pap yenbo mette. An neri nenem wule yaper peten sepitbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Moses eri wule tuma wusoubetem tame eme etep metem, eme etemri porerek etep abom. Ete tame ere God eterneke tuma yaper woye. God eterwou ere wule yaper peten sepitbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Etep abomke, Jisas ere emri porere lam, ere emne wometem. Beke kem keremri porerek yaper wos etep abobe? ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","An ete tame erne wote. An neri sebera ya wos peten sepitte. Etep wote, e yaku eisau. O an erne etep wote. Ne wayen teten yite. An etep wote, e etepwou, e yaku eisau. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","An Tatame Etemne Lan Yeirim Tame, an gwote nowselke tetan. An mureken, an tatame etemri sebera ya wos kuyese peten sepitte. Areri mure an kemne peterate. Kem late. Etep womke, ere ku let tewo sam tame erne etep wom. Ne wayen teten neri tukna rowe peten sen neri akek sene yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Etep womke, ete tame ere wayen teten eri akek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yim, tatame eme etep lamke, eme aken God eri sig eisau wom. Eme etep wom. God ere ete tame Jisas erne mure newom, ere wule yaper kuyese peten sepitbe. Eke eme God eri sig eisau wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas ere ete emi mesginin yibetem, ere lam, tame wuri ere takis kel petbetem akek simenem. Eri sig Matyu. Ere erne lan etep wom. Ne arenken yite. Etep womke, ere wayen teten eterken yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yim, sene Jisas ere Matyu eteri akek a abetem, kel nogwape petbetem tame, akeite wule yaper nenbetem tame eme yan eterken sim, eri anepoi tame etemken sin a abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Sin abetem, Farisi tame eme etep lam, eme eteri anepoi emne etep wometem. Beke keremri tuma wusoube tame ere kel petbe tame etemken akeite wule yaper nenbe tame etemken a sin abe? Eme etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas ere emri wom tuma metem, ere awosein etep wom. Tame eme bepou me tetan, emne kapoyi beke kei, eme dokta erne beke yin la. Berai. Kapoyi metbe tame etemwou eme dokta erne yin labe. Kau tatame eme maime etep abobe. An tame yenbo. Etepkap tatame an emne kobo late beke ya. Kau tatame eme maime etep abobe. An tame yaper. Etepkap tatame an emne kobo late yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","God eri bas rasem siglou etep wobe. Tatame eme ane kwar mane pete. An aboye, tatame eme akeite tatame emne kobo late. Etep wobe. Ete tuma somo kem beke met. An yam, an tame yenbo emne eyarte beke ya. An sebera yabe wule yaper nenbe tame etemne eyarte yam. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Baptais ok wirubetem tame Jon eri anepoi tame eme Jisas erne yan lan etep wom. Nema Farisi tame etemken nogwape yabel nema wule yenbo sebe, nema a takerbe. Beke yabel nogwape neri anepoi tame eme wule yenbo beke se, eme a som abe? ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas ere awosein etep wom. Tame ere ta panete, ere eri tamenowu emne wo yate, eme ta panen kisbe a ate. Eme oksubu tebe, eme a beke taker. Yuri ta panete tame ere sene yite, eri tamenowu eme pap yaper tete, eme a beke a, eme a takerte. Gwopte an ari anepoi tame etemken tetan, eme oksubu tebe, eme a abe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tame eme woyarten mate seba tetan, eme mate meg ager beke peten, etek beke kape. Etep tete, pekaten mate ere eisauwai sene pekate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tame eme yurik nenem wain ok kiyiri ok tibe girbu sebak beke yewo. Etep tete, yurik nenem wain ok ere wayen pelaube, girbu seba ere ek pekan ok ere selke sirpitbe. Etep tebe, girbu ere yaper tebe. Yurik nenem wain ok eme girbu agerke yewote, wain okken girbuken epe yenbo temente. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas ere emne tuma som wobetem, Juda etemri apeilake wuri ere yan eri bitimik gulke pan etep wom. Areri yen te saye. Ne yan tene let kerete, te sene terbo terbon yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Etep womke, Jisas ere erne semowun yim, eri anepoi tame eme eterken yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ere yibetem, ta wuri te yan eteri kin yekwok yan eri tame oub megke kerelam. Ete ta te worta subetem, nabe ep yekwo let ep yekwo let tewo bor pes keyem (12-pela), te worta subetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Eri tame oub kerelam, teri porere te etep abom. An eri tame oub let kerelatek, an yenbo mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Etep abomke, Jisas ere petkwo lan tene etep wom. Yen, neri pap yenbo mette. Ne ane kenawaike abobe, eke an nene eyarte. Etepkap ne yenbo mette. Eter wobetem tuma tepken teri subetem worta omom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ere etep tem, ere keryen eteri akek yin wurin lam, tame eme amo puw optebetem, tatame nogwape eme keratirbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yan lam, ere etep wom. Kem seki. Yen te beke sa. Te me tuknaten. Etep womke, eme erne kenake keyatirem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Keyatiremke, ere tatame emne wom, eme kom genik woram, ere ake purik wurin etetri letke kerem, te wayen sim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wayen sim, eri nenem wule tatame eme etep lam, eme komke komke wusowun sewurem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas ere ete ake mesginin yibetem, le si tame pes epe erne lelekeren yin etep wom. Ne Devit eteri nan. Ne nesetne kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Etep womke, ere akek yin wurim, le si tame epe erne yan lam. Ere epne etep wometem. Kep mapeke aboye? An kerepri le kuyese eyarte o? Epe awosein etep wom. Ye. Ne kuyese nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ere epri le letke keren etep wom. Kerepri porere an laye, kep ane kenawaike abobe, eke an kepne noub nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Etep womke, epri le sene yenbo tem. Etep tem, Jisas ere epne koubkoub etep wom. An kepne nenyekap kep eike tame emne mane wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Etep wom, epe sene woran yim, Jisas eri nenemkap epe komri komri tatame emne wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Epe sene yibetem, tatame eme tuma eikse tame erne Jisas eterke panen yam. Gabo ere ete tame erne gulelemenem, ere tuma rebe temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Panen yam, Jisas ere erne gabo erne lelem, tame ere tuma sene namdem. Tuma namdem, tatame eme wouken aken etep wom. Yenbowaike. Kiyi nema etepkap wos gwo kantri Israelke kiyi beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Farisi tame etem, eme etep beke wo. Eme wobe. Gabo etemri keryen, Satan eter, ere Jisas erne mure newobe, ere gabo emne lelebe. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas ere yin kom komke sewurbetem. Sewurbetem, ere God eteri akek wurin tuma wusoubetem, God ere kom panen site tuma emne wusoubetem. Ere akeite akeite kapoyi met tatame emne eyarbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Eyarbetem, ere tatame nogwape emne lam, ere emne kobo lam. Eme por walekap, eme a newon an lakerebe tame berai. Emne lakerebe tame berai, eme mureken berai, emri porere yaper temenem. Etepkap ere emne kobo lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Etep temke, ere eri anepoi tame emne etep wom. Nogwape nowri awos okwoye. Ete awos pette tame eme nogwape berai. Etepkap, tatame nogwape eme God eri tuma mette abobe. Emne tuma wusou tame eme nogwape berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kem now maime erne womette, ere yaku kere tame won yin tatame emne tuma wusoute. Eke tatame nogwape eme eri tuma kenawaike abon now maime eteri komke yite. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas ere eteri anepoi tame emne won yan wurisubuk sim. Eri anepoi tame eme tame ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) tame. Ere emne etep wom. An kemne mure newote, kem gabo emne kuyese lelete, kapoyi met tatame emne kuyese eyarte. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Eri aposel tame, eri wom tame eme ep yekwo let ep yekwo let tewo bor pes keyem (12-pela). Emri sig gwo. Taresi tame ere Saimon. Eri sig wuri Pita. Tame wuri ere Andru, Saimon eteri mase. Tame pes epe Jemsken eri mase Jonken, epe Sebedi eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Akeite tame eme Filip, Bartolomyu, Tomas, Matyu. Kiyi Matyu ere takis kel petbetem tame. Wuri ere Tadius. Wuri ere Jems, Alpius eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Wuri ere Saimon Selot. Kiyi ere komke komke sewurbetem, tatame emne etep wobetem. Akeite kantri eme nemne panen siten, e yaper. Nerem, nema maime neremri kantri panen site. Kiyi ere etep wobetem. Wurinabu ere Judas Iskariot. Yuri Judas ere Jisas erne peiktame etemri letke rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas ere ete tame emne won yite nenem, ere emne tuma noub won etep wom. Tame eme Juda tame berai kem etemri kom mane yite. Samaria etemri kom mane yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kem Juda tatame etemri kom nogwape etek yite. Juda tatame eme mou yibe porkap. Keryen ere emne sopbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yitek, kem emne tuma etep wusoute. God eri kom panen site yabel e mekin mekinye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Etep wotek, kem kapoyi metbe tatame emne eyarte, sa tatame emne wou sene newote. Kem numa pe tatame emne eyarte, gabo emne lelepitte. An kemne mure bepou newobe. Kem kelke beke tuk. Eke kem kapoyi metbe tatame emne eyarte, kem bepou me nente. Kem tokwo mane womette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kem kel mane sen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kem yite, kemri warten tame oubwou sen yite. Akeite aiyer, tame oub, tewo bus, kwokwul mane sete. Kem tatame emne kobo latek, eme kemne kobo awosein late, eme kemne ete wos newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Komke yin wurte, kem tame yenbo late. Tame yenbo ere kemne pap yewote, kem eteri akewouke yin tete. Kem akeite akeite akek mane yin tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kem akek wurtek, kem emne pir won etep wote. Kem noub me temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Etep wotek, eme kemne pap yewote, eme noub temente. Eme kemne pap beke yewo, eme kemne magel taite nenbe, eme yenbo beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kau kom o tame eme kemne pap beke yewo, o eme kemri tuma beke met, kem ete kom o ake mesginin yite. Yitek, kem tewo subu nubutkwunte. Komri tatame eme maime lan abote. O nema emne yaperke nenye, yuri God ere nemne yaper awosein nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","An kemne sekenke wobe. Ete tatame eme kemne pap beke yewo, e yaperwai. Yuri tatame emne tuma namdete yabelke, God ere emne awosein kenake pete. Sodomken Gomoraken ete komri tatame ere emne kera kobo lan, ere emne etepkap beke pe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kem met. Aren an kemne komke komke won yibe. Wale eme sipsip emne tabekap, tatame yaper eme kemne yaper nente nenbe. Eme kemne yikwokwote wurken. Bour eme porerekenkap, kerem kir, kem porereken tete. Kem mawonkap elen me sin sewurte, kem tatame yaper etemken mane ei naite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kem noub la. Kau tame eme kemne panen tuma namdebe akek panen yite. Eme kemne paku yaper pete, God eteri ake eme kemne etek pete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kem arenken anepoi tame yibe, eke apeilake, kom panen si tame eme kemne tuma namdete. Etep tetek, kem God eri tuma yenbo emne wusoute. Juda berai tatame emne kem kir wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Eme kemne tuma namdete, kem mane ep abo ep abote. Nema be tumake awosein wote? Ete yabel God eter ere kemne tuma peterate, kem ete tuma awosein wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kerem wusoute tuma e keremri tuma berai. Apei God Eteri Wou ere kemne gulelete, kem tuma ek kuyese wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ete yabel wule yaper nogwape eme genik tete nenbe. Tame eme emri lakemase emne tuma namden pen sate bebe. Ane eme emri yen etepwou tete. Yen eme anenawo emne peiktamek tete nenbe, emne akeite tame emne won yite, eme emne pen sate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kem ane kenawaike abobe, eke tatame nogwape eme kemne yaper nente nenbe. Eke yaper tete yabel omote, ane som abobe tatame eme yenbo som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kom wuriri tatame eme kemne yaper nente, kem amen akeite komke yin tete. An kemne sekenke wobe. Kem nogwape Israel komke yin yaku kerete, ete yaku ere beke kip omo. An tatame nogwape Etemne Lan Yeirim Tame, an yin sene yatek, ete yaku ere ek omote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Skul sibe yen, eme etemri tuma wusoube tame emne beke teitkwun. Yaku kerebe tame eme emri yaku lakerebe tame emne beke teitkwun. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Skul sibe yen eme tuma wusoube tame etemkap temente, e yenbo. Yaku kerebe tame eme etemri apeilake etemkap temente, e yenbo. An keremri Apeilake. Kau tame eme emne tuma yikwokwon etep wobe. Jisas ere Belsebul. Ere Satan, ere gabo etemri apeilake. Eme etep wobe. Kem ane abobe, eke eme kemne tuma yaper kir wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tatame eme kemne yaper nente, kem mane akte. Kemri berasen nenbe wule, yuri tatame nogwape eme late nenbe. Kemri berasen wobe tuma yuri tatame nogwape eme mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gwopte an kemne tuma elen me wobe. Tatame nogwape eme areri tuma beke kip met. An keremnewou wusoube. Ari woye tuma kem metten, kem komke komke yin tatame nogwape emne areri woye tuma wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tatame eme kemne pen sate wote, kem emne mane akte. Tame etemri wusomwou eme kuyese pen sabe. Wou eme kir beke pen sa. God eterne kem erne akte. Eterwou ere wusomken wouken yaper nente, ker tetan komke seitte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kem laten, tatame eme ap nebule pes kel wurisubuke tukbe. Ete ap nebule epe beke kip sa. Apei God eter ere kir wote, ap nebule wuri ek sate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ere kemne kir noub lakerebe. Ere keremri nogwape tare take wurare wurare akei sarem. Ere kemne akei lan metten. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Etepkap kem be wos mane akte. Apei God ere kemne noub nenbe. God ere ap nebule emne abon yenbo nenbekap, kem tatame, ere kemne abon noubwai nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tatame eme akeite tatame emne etep wote. An Jisas eteri. Etep wote, yuri an ari Hevenke tetan Apei erne etep wote. Ete tatame eme areri wakse. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tatame eme tatame emne etep wote. An Jisas eteri wakse berai. Etep wotek, yuri an ari Hevenke tetan Apei erne etep wote. Ete tatame eme ari wakse berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","An yam, kem mane etep abote. Nowsel tatame eme yenbo site. Berai. Eme yenbo beke kip si. Eme pekan peske ten ei naite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","An yam, kau tatame eme ane kenawaike abote, kau eme ane mowai wote. Etepkap, yen eme anenawo etemken ei naite. Ane eme yei etemken ei naite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ake wurik tetan tatame eme etemwou etemwou peiktamekap ei naite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tame eme emri anenawowou kenake metekwasbe, eme ane som beke metekwas, ete tame eme ari wakse beke kip te. O eme emri yen etemnewou kenake metekwaste, eme ane som beke metekwas, ete tame eme ari wakse beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ari metbe muskap, tame eme mette mo wote, eme ari tuma beke kip tobo, ete ame eme areri wakse seken berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tame eme maime wusomwou abote, yuri eme yaper tete nenbe. Tame eme ane kenawaike abote, eme emri wusom beke abo, yuri ete tame eme yenbo som temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Tame eme kemne pap yewobe, eme arene kir pap yewobe. Ane won yam tame God eterne kir pap yewobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tame eme God eri tuma wusoube tame emne lan etep abote. O ere God eri tuma wusoube tame. An erne ari akek panen yite. Etep tete, yuri ete tame eme tuma wusoube tame etemri pette nenbe tokwokap ere kir pette. O tame eme tame yenbowai lan etep abote. O ere tame yenbowai. An erne ari akek panen yite. Etep tetek, yuri ete tame eme tame yenbowai etemri pette nenbe tokwokap ere kir pette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kem gwotepke abote, mane eiksete. Tame eme areri wakse ere sigken berai tame erne lan etep wote. O ere Jisas erne kenawaike abobe tame. An erne ok newon ate. Etep tetek, God ere eri yaku nebule ere beke eikse. Yuri ere erne tokwo newote nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas ere eri ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) anepoi tame emne tuma wusowun ere ete kom mesginin komke komke yin tatame emne tuma wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Baptais ok wirubetem tame, Jon, ere ake yaperke temenem, ere Krais eri kerebetem yaku metem. Etep metem, ere eri anepoi tame emne won yim, Jisas erne yin lan eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jon ere kiyi etep wom. Tame wuri, Krais, ere yate nenbe. Ne nemne wusoute. Ne Jon eri kiyi wom tame, o ne akeite tame? ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ere awosein etep wom. Kem sene yin keremri laye woskap kem Jon erne wusoute, keremri metyekap erne kir wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Le si tame an emne eyarbe, eme sene kuyese labe. Tewo yaper te tame an emne eyarbe, eme sene kuyese yibe. Kapoyi metbe tame an emne eyarbe, eme sene yenbo tebe. Wan si tame an emne eyarbe, eme tuma kuyese metbe. Sa tatame an emne wobe, eme wou sene peten wayen yabe. Wos eikse tatame emne an God eteri tuma yenbo wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tatame eme ari nenbekap lan etep abote. Gwo tame God ere erne won yam. Etep abote tatame emri porere yenbo. Emri porere pes berai, etepkap eme metekwaste. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon eri anepoi tame eme sene yibetem, Jisas ere tatame emne Jon erne etep wom. Kiyi kem Jon erne tameken berai emik late yim, kem be wos late yim? Kap kem etep abobetem? Jon ere polik sen yibe me takekap. Ere mureken berai. An kemne wobe. Ere etepkap berai. Ere mureken tame. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kap kem etep abobetem? Yenbotanbo tame oub wolebe tame nema late. An kemne wobe. Jon ere tame oub yenbo beke war. Yenbotanbo tame oub wolebe tame eme tameken berai emik beke yin sewur. Eme ake yenbok temenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kap kem etep abobetem? Nema God eri tuma wusoube tame late. Ye. Jon ere God eri tuma wusoube tame. Ere akei tuma wusou tame emne epiye tetan. Ere tame eisau. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","God eri bas rasem tuma ere Jon eterne etep wobe. Gwo tame ere ari tuma wusoube tame. An erne won yite. Ere taresin yin ari tuma wusoute, ere neri yate kelu eyarte. God ere Krais eterne etep wom, eme etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","An kemne tuma sekenke wobe. Baptais ok wirubetem tame Jon ere nogwape nowselri tame emne epiye tetan. Jon eteri kin yekwok ane kenawaike abote tatame eme mette, an etemri nenbetem wule yaperke sate. Jon ere etep beke met. Etepkap, God eri kom panen si komri tatame, ane kenawaike abobe tatame, etemri sig nebuleken tame emri sig e Jon eri sig epiye tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon ere tatame emne tuma tasen wusowun yam, gwopte kir ei nai tame yaper eme God erne kenawaike abobe tatame emne yaper nenbe. Ete tame yaper eme abobe, tatame nogwape eme God erne kenawaike mane kip abo. Eme abobe, God ere tatame emne mane kom panen site. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","God ere kom panen site nenbe tuma, kiyi tuma wusoubetem tame nogwape eme etep wusoubetem. Moses ere etep wusoubetem. Jon eter kir ere etep wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kem etemri tuma mette, e yenbo. Kiyiri tame, Elaija, eri wusoubetem tumakap Jon ere kir wusoubetem. Kiyiri tame eme etep bas rasem. Elaija ere yurik sene yate nenbe. Etep bas rasem, an kemne wobe. Elaija ere kiyi yam. E Jon eter. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kem wanken, kem noub met. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jisas ere emne sene etep wom. Gwopte tetan tatame eme mapkap tatame? An kemne wusoute. Eme ake maklek sou teten sewurbe yenkap. Eme akeite yen emne won yan etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nema sekwo lomen me pebe, kem sekwo kir beke lom. Nema wokerabe, kem nemne kir beke panen kera. Nemri tebekap, kem etep kir beke nen. Etep wobe, be wos yen eme nenbe, akeite yen eme etep wobetem. E yaper. Etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon ere yam, yabel nogwape ere awos mesginin a beke a, ere wain ok beke a. Tatame eme aren woye yenkap, eme Jon eter nenbetem wule lan etep wobetem. Ete tame ere etep tebe, gabo erne guleleten. Eme etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","An Tatame Etemne Lan Yeirim Tame, an yan a abe, ok abe, aren woye yenkap, tatame eme ane etep wobe. Ek la. Ere a nogwape abe tame, ere wain ok nogwape abe tame. Ere takis kel petbe tameken akeite wule yaper nenbe tameken etemken gerebe. Eme etep wobe. Be wos an nenbe, eme etep wobe. E yaper. Etep wobe. Metye. Yuri kem aren kerete nenbe yaku late, kem noub abote, e God eteri porere eisau. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kiyi Jisas ere nogwape komke wurin yaku eisau kerebetem. Kerebetem, tatame eme etep lam, eme emri yaper nenbetem wule beke mesgin. Eke ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","O Korasin komri tatame, yuri kem mus eisau mette nenbe. O Betsaida komri tatame yuri kem mus eisau mette nenbe. An keremri komke temenem, an kemne God eri mure peteram. Peteram, kem etep lam, kem God erne kenawaike beke abo. Tair komri kiyiri tatame, Saidon komri kiyiri tatame eme God eri nenem wule eme beke la. An God eri mure ete kom pesri tatame emne peterate wom, eme emri wule yaper pauk mesginte wom. Emri kiyi nenbetem wule yaper eme abon sebera yan eme til waren pauk site wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kem ek met. Yuri God ere tatame emne tuma namdete yabel Tair komri tatame, Saidon komri tatame eme mus eisau beke kip met. Kem Korasin, Betsaida komri tatame kem mus eisau mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kem Kaperneam komri tatame kem kemri maime sig eisau Hevenke wote wom. Kem beke wo. Yuri kem ker tetan komke yite nenbe. An kemne yaku eisau kerem, kemne God eri mure peteram. An Sodom komke etep tete wom, Sodom komri tatame eme emri sebera yabe wule mesginte wom, God ere emne yaper beke pauk nen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kem ek met. Yuri tete yabel, God ere tatame emne tuma namdete yabel Sodom komri tatame emne God ere emne kobo late, eme mus eisau beke kip met. Kerem, kem mus eisau mette nenbe. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ete yabel Jisas ere God erne etep wom. Apei, ne nelken selken etepri Keryen. Neri nenbekap, neri tuma somokap ne porereken tatame emne berasen, emne beke petera. Nebule yenkap tatame etemne, porereken berai tatame etemnewou ne neri tuma somo emne noub wom. E yenbo. Etepkap an metekwasbe, an nene pir wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ye. Apei, e neri porerek ne nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","God erne etep wom, ere sene wom. Apei ere wos nogwape ari letke rasem. An Eteri Yen, tatame eme ane etep beke met. Apei eterwou ere ane metten. Tatame eme erne beke met. Arenwou an erne metten. Aren kenem tatame etemne an emne wusowum. Etemwou, eme erne metten. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yaku eisau kerebe tatameken pap yaper tebe tatameken kem arenke yatek, an kemne ege won site, kem pap yenbo mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kem ari kerebe yakukap kem kerete, an kemne peterate, nema etep kerete. An tumaken takken berai tame. An elen me site wule tobobe tame. An kemne yaper beke nen. Kem yaku aren kerebekap kerete, kem pap yenbo mette, kem noub site. ");
INSERT INTO yss_yawu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yaku an kemne newote, e eisau berai. Kem kuyese kerete. Ete yaku yenbo. Kem ari yaku kerete, kemri porere yenbo temente. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yuri ege si yabelke Jisas ere eri anepoi tameken eme wit now borke yibetem, eri anepoi tame eme se kwoi samke, eme wit supa kwosen keluke an yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Keluke an yibetem, Farisi tame eme etep lan, eme etep wom. Neri anepoi tame eme ege si yabelke wit supa kwosen abe, eme neremri wule yaper nenbe. E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ere emne awosein etep wom. Kiyi Devit eter nenem wule eme bas rasem. Kem kap ete siglou beke la, kiyi Devitken eteri wakseken eme kwoi sam, eme kap be ake am? ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Eme kwoi samke, eme God eteri kobor eisauke wurin God eterne newon rasem geil eme peten am. Nemri wule eme tousin eme am. Neremri wule gwo. God eri akeri tame etemwou eme God erne newobe geil abe. Tame nogwape beke kip a. Devit eter, eteri wakseken eme am, eme tuma beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ege si yabel God eri akeri tame eme God eteri akek wurin eri yaku kerebe. Moses eri wom tuma kem metem. Ere etep wom. Ege si yabel kem yaku mane kerete. Etep wom. God eri akeri tame eme ete wule yaper nenbe, eme yaku kerebe. Etep tebe, God ere emne tuma beke namde. Berai. Eme eri yaku ege si yabelke kerete, e yenbo. Tuma berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","An kemne wobe. Akeite tuma ere eisauwai. Ere Moses eri kiyi wom tuma erne tousite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kiyi temenem tame wuri, Hosea, ere tuma bas rasem. Kap eri tuma kem beke met o? Ere etep bas rasem. God ere wom. Ane kwar pebe wule an beke abo. Kem akeite tatame emne kobo late, e kwar pebe wule me tousiten. Etep wom. Etepkap kem ete tuma noub metmente wom, kem yenbo nenbe tatame emne tuma yaper beke pauk wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aren, an Tatame Etemne Lan Yeirim Tame. Aren, an ege si yabelri apeilake tame. Aren, an tatame emne wote, be wos ege si yabelke nente wote, eme kuyese nente. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas ere tuma namden omon, ere ete emi mesginin yim, ere God eteri akek yin wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wurim, let yaper tame ere etek temenem. Akeite tame eme kir etek temenem, eme Jisas erne tuma namdete abom, eme erne etep wometem. Tatame eme kapoyi met tame emne ege si yabelke eyarte, eme nemri wule yaper nenbe o? ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ere emne awosein etep wom. Keremri tame wuri eri sipsip ere ege si yabelke ok meike warte, ere maime ere mapeke tete? Kap ere sipsip erne sene pette o? Ye. Ere erne sene pette. Etep tete, e tuma berai. E neremri wule. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sipsip eme eisau wos berai. Tatame etem eme eisau wos. Kem ane etep wobe. Ege si yabel an kapoyi met tame eyarte, e yaper. Etep wobe. Neremri wule e etep beke wo. Wule ere etep wobe. Ege si yabel tame eme wule yenbo nente, e tuma berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Etep womke, ere let yaper tame erne etep wom. Ne let tai. Ere let tayemke, eri let yenbo tem, ep yekwo yakap yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Etep tem, Farisi tame eme etep lam, eme wayen yin wurik sin, etemwou etemwou eme tuma namdem. Eme Jisas erne pen sate tuma namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Eme erne pen sate wom, Jisas ere etep metemke, ere ete kom mesginin yim. Yim, tatame nogwape eme erne semowum. Semowum, tame kau eme kapoyi metbetem, ere emne eyarem, eme yenbo tebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Etep tem, ere emne wotakem. Ari nenyekap kem mane wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ere ete tuma bepou me beke wo. Eri wom tuma kiyiri tuma wusou tame, Aisaia, eri bas rasem tuma e seken tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ere etep bas rasem. God ere etep wom. Ete tame ere ari yaku kerebe tame. An erne yaku newom. An erne metekwasbe. Areri Wou ere erne gulelete, aren yuri wule yaper nenbe tatame etemne awosein yaper nente nenbe tuma ere nogwape nowselri tatame emne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ere ei beke nai. Ere koubkoub tuma beke wo. Ere kelu komke namdebe tuma genik beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yam ere busin warte, ere etep late, ere yam sene nenewayen tumou pen noub tetete. Ker ere sate kerake temente, ere etep late, ere beke mesgin. Ere sene liskeren, ker ere sene eyin wayete. Etep tete, tatame eme som abote. Etep tete, wule yenbo ere wule yaper erne teitkwunte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tatame nogwape eme erne late, eme etep wote. Ere nemne kobo labe. Etep wote. God ere wom tuma Aisaia ere etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tatame eme tame wuri Jisas eterke panen yan etep wom. Gabo ere gwote tame erne guleleten, ere le siten, tuma eikse tetan. Etep wom, Jisas ere erne eyarem, ere tuma sene namdem, ere le kuyese sene lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Eyaren, etek temenem tatame eme etep lam, eme wouken aken etep wom. Ere kap Devit eteri nan o? Ere kap God eter erne yaku newom tame o? ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Etep wom, Farisi tame eme tatame emri wobetem tuma metem, eme etep wom. Keremri wobe tuma e seken berai. Gabo emri apeilake Belsebul, ere erne mure newobe, ere gabo emne lelepitbe. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas ere emri porere lan emne etep wom. Apeilake wuri eri wakse eme peske pekan etemwou etemwou naitek, eme noub beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satanken arkwu gaboken eme etepkap tete. Eme pekate, etemwou etemwou ei naite, eme noub som beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kem ane etep wobe. Gabo etemri apeilake Belsebul eter ere mure newobe, eke an gabo emne pekeroukbe. Ete tuma e seken berai. Keremri kau tame eme kir gabo pekeroukbe. Eike emne ete mure newobe? Belsebul o? Kerem kir, kem Belsebul beke wo. Eke, kemri tame eme gabo pekeroukbe, nema etep labe, nema metten, kerem me yikwokwobe. An gabo pekeroukbe, an Belsebul eteri murek beke pekerouk. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","God Eri Wou ere ane mure newobe, an ete gabo emne pekeroukbe. Kem etep latek, kem abote. Gwopte God ere tatame emne panen siten. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ere emne sekur sakur tuma etep wom. Tame ere mureken tame eteri akek wurte wote, eri wosbas pette wote, kiyi ere ete tame erne kepke peiken raste. Peiken rastek, ere kuyese wosbas ek pette. Etepkap, an Satan erne teitkwunen, Satan ere kiyi petem tatame an emne sene petbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tame eme ari wakse beke te, eme areri peiktame. Tatame eme arenken yaku beke kere, eme ari yaku yaper kerebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Eke, an kemne etep wobe. Tame eme wule yaper nente, o eme tuma yaper God erne wotek, God ere emri nenem wule yaper kuyese peten sepitin, tuma beke kip namde. Tame eme God Eteri Wou eterne tuma yaper wote, God ere ete wule yaper beke kip peten sepit. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","An Tatame Etemne Lan Yeirim Tame. Tame eme ane tuma yaper wote, God ere ete tame emri nenbe wule yaper ere peten sepitte. Tame eme God Eri Wou eterne tuma yaper wote, God ere ete tame emri nenbe wule yaper ere beke peten sepit. Gwopte ere beke kip peten sepit, yuri kir ere beke kip peten sepit. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Me supa yenbo, me ere kir yenbo. O me supa yaper, me ere kir yaper. Nema tatame, nema me supa labe, nema abobe, be me yenbo o be me yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kau me eme yenbo, kau me eme yaper. Tatame etem kir. Kau eme yenbo, kau eme yaper. Kem Farisi tame, kem arkwu walekap. Kem porere yaper tetan, eke kem tuma yaper wobe. Kem tuma yenbo beke wo. Tame emri porere tetankap, emri wobe tuma eme etepkapwou wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tame yenbo eme porere yenbo tetan, eme wule yenbo tobobe, eme tuma yenbo wobe. Tame yaper eme porere yaper tetan, eme wule yaperwou tobobe, tuma yaperwou wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Metye. An kemne wobe. Yuri ete yabel God ere tatame emne tuma namdete, tatame emri kiyi bepou me wobetem tuma ere emne yurik womette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yuri ere keremri tuma sin lan etep wote. Ne tame yenbo. O ere etep wote. Ne tame yaper. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jisas ere etep womke, Moses eri wule wusoubetem tameken Farisi tameken eme erne etep wom. Nema abobe, ne rigrabe nente. Nema late, nema mette, ne God eri murek ete wos nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ere emne tuma awosein etep wom. Gwopte tetan tatame eme tatame yaperwai. God eri wule eme beke met. Kem ane rigrabe nente woye. Keremri woyekap an beke kip nen. God eri kiyi temenem tuma wusoubetem tame, Jona, eter nenbetemkap, etepwou an nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kiyi Jona ere neir mur yabel mur omyen eisau eteri kibuk temenem, ere sene woramkap, an Tatame Etemne Lan Yeirim Tame, an neir mur yabel mur sele meike ten an sene wayen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kiyi Ninive komri tatame eme God erne beke abo, eme Jona eri tuma metem, eme emri nenbetem wule yaper agetage mesginim. Gwopte tetan tame wuri ere Jona erne teitkwunten. Kem ari tuma metem, kem wule yaper beke mesgin. Eke, yuri God ere tatame emne tuma namdete yabel, Ninive komri tatame eme wayen teten kemne ker wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kiyi temenem keryen ta, yale yekwori ta, te genek yam, porereken tame, kom panen sibe Keryen Solomon eteri akek yan eri tuma yenbo mette yam. Gwopte an keremken tetan, an Solomon erne teitkwunten. Kem ari tuma metten, kem wule yaper beke mesgin. Eke yuri God ere tatame emne tuma namdete nenbe yabelke ete keryen ta te wayen teten kemne ker wote nenbe. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisas ere emne sene sekur sakur tuma wurinabu wom. Gwopte tetan tatame eme gabo guleleten tamekap. Gabo ere tame erne mesginin yim, ere boulke yin site emi soplawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yin lawoyim, ere etep abom. An ari kiyi gulelemenem tame eterke sene yite. Yin lam, tame eri porere e yenbo tem. Yenbo tem, akeite gabo erne wuri beke gulele. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Eke ere sene yin akeite gabo, ep yekwo let ep yekwo let por pes kei (7-pela) gabo, emne panen yam. Gabo emri yaper nen wule e gabo wuri eri yaper nen wule teitkwunmenem. Panen yam gabo eme tame erne gulelem. Gulelemenem tame, kiyi gabo wurisubu erne gulelemenem, tame ere yaper temenem. Sene gabo nogwape erne gulelemenem, tame ere yaperwai sene tem. Tame ere yaperwai temenemkap, gwopte tetan tatame yaper eme etepke temente. Eme bepou me temente, eme ane kenawaike beke abo, eme yaperwai sene tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas ere tatame emne tuma som wobetemke, Jisas eri nawoken maseken eme yan kom genik tetpete wurmenem. Eme eterken tuma namdete wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tame wuri ere Jisas erne etep wom. Neri nawoken maseken eme yawo, tetpete woraten. Eme nerenken tuma namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ere emne awosein etep wom. An kemne peterate. Eike ari nawo, eike ari mase. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Etep womke, ere anepoi tame emne letke peteram. Ek la. Gwo tame eme areri nawo, areri mase. ");
INSERT INTO yss_yawu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tatame eme areri komke tetan Apei eteri tuma meten tobote, etem eme areri nawo, areri geisimasekap. Ere ete wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ete yabel Jisas ere ake mesginin wurin peik barke yin sin, tatame emne tuma wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tuma wusoubetem, tatame nogwapewai eme yamke, ere perek waren simenem, tatame nogwape eme peik barke tetyewomenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tetyewomenem, ere emne tuma nogwape wusowum, ere sekur sakur tumak etep wom. Tame wuri ere wit supa nowke yin seitin sewurem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Seitin sewurem, wit supa kau eme keluke yeirim, ap eme yan am. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kau eme pape luke yeirim. Sel berai, papewouke temenem. Etep temke, agetage wit supa eme pam rekwan yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Rekwan yam, nen nebule temenem. Yabel pasem, eke wit supa eme sok ten saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wit supa kau eme keikei waboi boulke yeirin rekwan yam, keikei waboi eme emne punen boreren eme sok tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kau eme sel yenbok yeirin rekwan eisau ten, supa nogwape yam. Kau eme supa nogwapewai (100) yam. Kau eme supa nogwape kera (60-pela) yam, kau eme supa nogwape (30-pela) yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ere sekur sakur tuma won, ere emne sene etep wom. Tame eme wanken, eme wan wurik mette. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas eri anepoi tame eme yan erne etep wom. Beke ne tatame nogwape emne sekur sakur tumawouke wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ere emne awosein etep wom. God ere kom panen site tuma, kiyi berasmenem tuma an keremne noub wusoute, keremwou metbe. An akeite tame emne wusoube, eme noub beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Porere yenbo tetan tame eme ari tuma metbe, eme tuma somo kir metbe. Ete tatame an emne tuma nogwape som wusoubetete. Porere yaper tetan tatame eme ari tuma metbe, eme tuma somo beke met. Ete tatame emri metyekap eme me eiksebe, an emne tuma sene beke kip wusou. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Etepkap, an emne sekur sakur tumawouke wobe. Eme wos labe, wos somo eme beke la. Tuma eme wanke metbe, emri wanke metbe tuma somo eme beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Emri nenbekap, kiyiri tuma wusoubetem tame, Aisaia, ere etep bas rasem. Kem tuma wanwouke mette, kem tuma somo beke kip met. Kem wos lewouke late, somo kem beke kip la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ete tatame emri porere yenbo berai. Emri wanke e tuma mette mo wom, eme wan getkap tem. Eme emri le birkeremenem. Eme etepkap beke pauk nen, eme noub late wom, eme noub pauk mette wom, eme porereken tete wom. Eme ane kenawaike abon, an emne yenbo nente wom. God ere etep womke, Aisaia ere eke bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kerem, ari anepoi, kem metekwaste. Keremri le kem ari nenbe wos somo noub labe. Keremri wan ari namdebe tuma noub metbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","An kemne sekenke wobe. Ari tebekap kem labe, kiyi tuma wusoubetem tame nogwape, tatame yenbo nogwape eme etep late abom, eme beke la. Ari woye tuma kem metbe, eme mette abom, eme beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kem ek met. Wit supa nowke seitin sewurem tuma somo an kemne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","God ere tatame emne kom panen site tuma tatame kau eme ete tuma metbe, eme keluke yeirbe wit supakap. Eme tuma bepou me metbe, sene Satan ere yabe, agetage ere ete tuma peten sepitbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kau tatame eme tuma metbe, eme pape luke yeirbe wit supakap, eme tuma meten agetage peten pap yewon metekwasbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ete tatame eme tuma noub beke se. Eme kerake tebe, sene akeite tame eme eri tuma ragerkwunte aboye, eme God eri tuma metbe tatame emne tuma yaper wobe, o emne yaper nenbe. Etep tebe, tatame eme God eri tuma mesginbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kau tatame eme tuma metbe, eme keikei waboi boulke yeirbe wit supakap, eme tuma metbe, eme nowselri wosken kelken etepwou abobe, ete woske emne ragerbe. Etep tebe, eme God eri yaku beke kere, eme wos yenbo beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tatame kau eme tuma metbe, eme sel yenbok yeirbe wit supakap, eme tuma meten abobe, eme eri yaku keren yenbo nenbe. Wit supa eme 100 yabekap, tatame kau eme God eri yaku yenbo kenake kerebe. Wit supa nogwape kere (60-pela) yabekap, tatame kau eme God eri yaku nogwape yenbo kerebe. Wit supa eme nogwape (30-pela) yabekap tatame kau eme God eri yaku yenbo kera kerebe. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas ere akeite sekur sakur tuma wuri emne etep wom. God eri tatame emne kom panen site wule ere gwopkap. Tame ere wit supa nowke seitin sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yuri tatame eme tuknamenemke, ete tame eri peiktame eme yan top yaper eri supa wit supa etemri borke seitin ek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yuri wit supa eme pam rekwan eisau tem, supa yate nenbetemke, eme lam, top yaper eme kir temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yaku kere tame eme yin now maime erne etep wom. Aneyen, kiyi ne wit supa yenbo nowke seitim, sene nema laye, top yaper eme kir rekwan yaten. Etepkap top yaper nema beke seit? Ete top yaper ere mak yamke, ere gwotek wayeten? ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ere emne awosein etep wom. Peiktame etem yan seitim. Eme erne etep wom. Ne mapeke abobe? Nema yin ete top yaper sete o? ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ere emne wotaken etep wom. Kem top yaper mane sete. Kem yin top yaper sete nenbe, kem wit yenboken kir topken sete wurken. E yaper. Kem epe mesginte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Epe peske rekwan peske etep temente. Yuri supa yatek, ete yabelke an yaku kere tame emne etep wote. Kem top yaper kiyi akei sen butyewon kerke liste. Sene kem wit supa kayen ari kwayeakek raste. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Jisas ere emne akeite sekur sakur tuma wuri etep wom. God ere tatame emne kom panen sibe wule ere gwopkap. E mastet mekap. Mastet e me sig. Eri supa akeite me supakap eisau berai. Ete me supa nebulewai. Tame ere ete me supa peten eri nowke rasem. Rasen, rekwan yam, yuri ere eisau tem. Akeite me eme nebule e me ere eisauwai. Eisau tem, ap eme yan ete me ku ake etek kerebetem. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas ere emne akeite sekur sakur tuma wuri sene etep wom. God ere tatame emne kom panen site wule e gwopkap. E yiskap. Ta te bret nenbe, te witmil kerake petbe. Sene te yis peten witmilken legoum agomun, ete witmil ere pelen wayen eisau tebe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas ere tatame nogwape emne epkap epkap sekur sakur tumak wobetem. Ere sekur sakur tumawouke emne wobetem. Ere tuma somo beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ere etep bepou beke nen. Eri nenemkap e kiyiri tuma wusoubetem tame eter bas rasemkap. Ere etepke bas rasem. An emne wote, an emne sekur sakur tumake wote. Kiyisape God ere nowsel seikin yam, gwopte kir tuma nogwape ere berasten. Ete tuma an geinik wusoute. Ere etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas ere tatame emne mesginin akek wurim, eri anepoi tame eme yan erne etep wom. Top yaper sekur sakur tuma eri somo ne nemne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisas ere awosein etep wom. Wit supa yenbo seitim tame e aren. An Tatame Etemne Lan Yeirim Tame. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Now e nogwape kom. Wit supa e God eri tatame seken. Top yaper e Satan eteri tatame yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Areri peiktame, top yaper supa seitim tame, ere Satan. Awos pette yabel e yurik tete nenbe wos, e gwote nowsel omote yabel. Awos kwutabe tame eme God eteri komri tame. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Eme top yaper sen buten kerke liste nenbekap, yurik tete nenbe yabel eme tatame yaper emne etepke tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","An Tatame Etemne Lan Yeirim Tame, an God eri komri tame emne won yite, eme God eri panen siten kom komke yin tatame yaper emne peten wurisubuke rute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wurisubuk ruwun, sene eme emne ker eisauke seitte. Tatame eme akeite tatame emne yaper tete wobe, ete tatame etemne kir eme emne ker eisauke seitte. Eme mus eisau mette nenbe, eme kenake kerate nenbe. Eme mus eisau meten, eme ker wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ete yabel God eteri tatame eme God eterken temente, eme yenbo tete. Eme God eterkap tete. Aren woye tuma kem noub meten abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","God ere tatame emne panen site wule e kel mate sel kik berastenkap. Tame ere ok mei perbetem, ere kel mate etek lam. Lam, ere metekwasem, ere sel sene yenkeren ere ek yim. Yim, eri wos nogwape ere akeite tame emne kelken natokwo keram. Ete kel ere peten yin eri lam kel mateken selken tukem. Jisas ere etep wom. Sekur sakur tuma somo gwo. God ere nemne kom panen site, e yenbowai. Eke nema wos nogwape magel taite, nema God eternewou kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","God ere tatame emne panen sibe wule e gabo yase yenbowaikap. Kel yaku kerebe tame wuri ere gabo yase tukbe yaku kerebe tame. Ere gabo yase yenbo tukte abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ere gabo yase wuri yenbowai lam, ere yin eri wos nogwape ere akeite tame emne kelke natokwo keram, ete kelke ere sene ete gabo yase yenbosubuwai tukem. Jisas ere etep wom. Sekur sakur tuma somo gwo. God ere nemne kom panen site, e yenbowai. Eke nema wos nogwape magel taite, nema God eternewou kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisas ere sene etep wom. Keryen God ere tatame emne panen site wule ere gwopkap. Tatame eme wuli peik kupak sogwunbetem, epkap epkap omyen wurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wuli pelawom, eme litin wayen barke rasem, eme tapun, eme omyen yenbo rewo nebuk yewom. Omyen yaper eme sepitim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Yuri nowsel yaper tete yabel, eme etepke tete nenbe. God eri komri tame eme yate, tame yaper emne won yikwutete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Sene eme emne ker eisauke seitte. Etep tete, eme mus meten keratiren, ker wote nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas ere emne etep wolam. An kemne woye tuma kem metten o? Eme erne awosein etep wom. Nema metten. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ere etep wom. Moses eri wule tuma wusoube tame, sene eme God eri wule sebe, eme ake eisau maimekap. Ere wos rasbe akek wurin wos agerken sebaken peten sen ek yabe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas ere sekur sakur tuma won mesginin ere ete kom mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yim, ere eri maime kom Nasaretke yim, God eri akek wurin emne tuma wusowum. Tatame eme metem, eme wouken aken etep wom. Selpap porere lei eike erne newom? Ere rigrabe nenbe mure ere mak petem? ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nema kir tame. Ere ake kerebe tame eteri yen. Ere Maria etetri yen. Jems, Josep, Saimon, Judas eme eteri mase. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Eri geisi eme neremken tetan. Selpap porere ere mak petem? ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Etep womke, eme erne magel tayem. Jisas ere emne etep wom. God eri tuma wusou tame emne komri komri tatame eme emne etep wobe. Eme tame yenbo. Etep wobe. Etemri maime komri tame eme emne magel taibe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eke Jisas ere rigrabe nogwape etek beke nen. Ere peswouke nenem. Eme erne kenawaike beke abo, eke ere beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ete yabel Galili provinsri apeilake tame, Herot, ere Jisas eri nenbetemkap metem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Metem, ere eri yaku kere tame emne etep wom. Ete tame ere tame emne baptais ok wirubetem tame Jon. Kiyi an erne wak regem, ere selek sene wayen mure peten ere rigrabe ek nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Jon eri sam tuma gwopkap. Kiyi Herot eter ere Jon erne keresukun kepke peiken ake yaperke won wurim. Bepou berai. Eri mase, Filip, eteri ta, Herodias etet te erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kiyi Jon ere Herot erne etep wobetem. Ne neri mase eri ta panem, e yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Etep wobetem, Herot ere pap wayem, ere Jon erne pen sate wom. Tatame nogwape eme wobetem. Jon ere God eri tuma wusoube tame, ere tame yenbo. Etep wobetem. Herot ere emri tuma metem, ere erne pen sate me akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yabel wuri kau tame eme yan Herot eterken wurisubuk siyewom, eme Herot erne nawo te warwiyim yabel abom, eke eme awos eisau nenem. Nenem, Herodias teri yen te emri borke teten yage taibetem, Herot ere metekwasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Metekwasem, ere tene etep wom. Nema nene metekwasbe. Etepkap, ne ane be wos nene newote wote, an nene newote. An beke yikwokwo. An nene newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Etep womke, yen te teri nawo tene yin tuma wometlan etep wom. Ere ane wos newote woye. An erne be woske womette? Te sene woran Herot erne nawo teri wom tuma erne etep wom. Tatame emne baptais ok wirubetem tame, Jon, ne erne wak regte, eri tare rewok yewo sen yan, ane ek peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Etep womke, Herot ere pap yaper metem. Ere Jon erne wak regte mo wom, ere abolawoyim. Ere etep abom. Tatame nogwape eme arenken awos abe, eme aren tene woye tuma metye. An tene beke yikwokwote. Etep abon, ere etep wom. Teri woye wos kem etep nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Etep wom, ere yaku kere tame won ake yaperke yin eme Jon erne wak regem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Regem, eme eri tare sen yan rewok rasem mungu ta yen tene newom. Newom, yen te peten sen yin nawo tene peteram. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Etep temke, Jon eri wakse eme yan eri kupa peten sele mei peren meike rasem. Sele meike peren rasen, eme sene yin Jisas erne wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas ere ete tuma metemke, ere ete kom mesginin pere peten akeite emik yim. Ere kena wiwi, ere tameken berai emik yim. Yim, tatame eme etep metem, eme emri ake mesginin erne lan yim. Eme tewok yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yim, yuri Jisas ere yin gayin lam, ere tatame nogwape emne etek lam. Lam, ere emne kobo kenake lam, ere etemri kapoyi kei tatame emne eyarem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Perpe eri anepoi tame eme yan erne etep wom. Yabel warbe. Gwo emi e tameken berai, tatame eme awos mak pette? Ne emne won yite, eme komke yin awos tukte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisas ere awosein etep wom. Eme beke nenteke yite. Kerem, kem emne awos newon ate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Eme erne etep wom. Nema awos nogwape berai. Geil ep yekwo let, omyen sok peswou tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ere etep wom. Ne ane gwok sen yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sen yan, ere tatame emne etep wom. Kem selke si. Simke, ere geil ep yekwo let, omyen sok pes peten ere le nelke nerulan God erne pir won ere geilken omyenken pekayewom. Pekayewom, ere eri anepoi tame emne newom, eme peten tatame emne newopit pete yan eme am. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Akei an se kir temke, tep tem, eme peten kworasare ep yekwo let ep yekwo let tewo bor pes kei (12-pela) etek yewon pelawon yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Sitirin awos am tamewou eme sarem, eme nogwapewai (500). Yenta emne eme beke sar. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas ere anepoi tame emne etep wom. Kem perek waren peik keraruke kiyi taresin yite. Yimke, ere tatame emne etemri komke sene won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yimke, ere kena wiwi kowke yawom, ere Apei erken tuma namdete yawom. Yabel warbetem, ere etek kena wiwi temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Temenem, teketemke, pere nebule wuri anepoi tame eme etek siyewomenem, eme peik mei borke temenemke, marye ek yam, ok sare pere tarek tegilmibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sene ei berate nenbetemke, Jisas ere ok luke yin ere anepoi tame etemken tete yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yibetemke, eme etep lam, eme kenake aken taye pitin etep wom. E peikri sikilewas. Eke eme aken taye pitem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisas ere emne etep wom. Kem mane akte. Gwo aren. Kem mane akte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita ere erne awosein etep wom. Aneyen, kap neren seken, ne ane wotek, an ok luke nene yan late. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisas ere etep wom. Ne epe ya. Pita ere pere mesginin ere ok luke yin Jisas erne lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yim, sene ere marye lan akem. Akem, ere okke waren abetem, ere agetage Jisas erne tem. Aneyen, ne ane kobo la. Ne ane nenewayete. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Agetage Jisas ere erne let tayemke, erne keresukun erne etep wom. Ne ane kenawaike beke abo. Beke ne pap pes ten me akbe? ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Etep womke, epe perek yin waremke, marye ere beyem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Beyem, perek temenem tame eme eri mure etep lam, eme erne sukye woran etep wom. Sekenwai. Ne Keryen God Eteri Yen. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Eme peik kupa pukeyin keraruke woi wun, eme Genesaret komke yin gayim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Gayim, ete komri tatame eme erne lam, eme etep wom. E Jisas. Etep womke, eme kom mekinri tatame emne tuma wopitim, eme emri rekebuk tatame emne panen yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Panen yam, rekebuk tatame eme erne etep wometem. Nema neri warten tame oub megke kerelate. Nema kerelate, nema yenbo tete. Etep wom, ete tatame eme eri warmenem tame oub megke kerelam, eme akei yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kau tame eme Farisi tameken, Moses eri wule wusoubetem tameken eme Jerusalem kom mesginin yam, eme Jisas erne late yam. Eme erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Yeiwarege eme etep wobe. Nema awos ate, nema let ok kiyi keyate. Nema etep nente, God ere neremri nenbe wule yaper peten sepitte, nema tatame yenbo tete. Etep wobe. Beke neri anepoi tame eme etep beke nen? Eme awos abe, eme let ok beke keya, eme let kerkarken abe. Eme nemri wule yaper nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas ere awosein emne etep wom. Beke kem yeiwarege etemri wulewou seten, God eri wule kem mesginim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kiyi God ere etep wom. Kem aken o nawoken etepne noub nente. Tame eme ane o nawo epne tuma yaper wote, ete tame kem emne pen sate. God ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kerem, kem akeite wule tobobe. Kem etep wobe. Tame eme aken nawoken epne wos newote woye. Newote woye, sene eme ete wos God erne newote, eme aken nawoken epne beke newo. Etep tete, e yenbo. Kem etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","An kemne wobekap e kena. Tame eme etep tebe, eme aken nawoken epne yaper nenbe. Eme God erne wos newobe, aken nawoken epne wos beke newo, etepkap e yaper. Kem etep tebe, kem God eri wule mesginbe, kem kemri porerek nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kem me yikwokwobe tame. Kiyiri tuma wusoubetem tame, Aisaia, ere yeiwarege etemne abon bas rasem. Ere keremne kir bas rasem. Ere tuma seken wom. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Gwo tatame eme yikwokwon etep wobe. God ere yenbo. Etep wobe tame, eme God erne pap beke yewo, erne beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Eme tame etem nenbe wulewou wusoute abobe, eme yikwokwon etep wobe. Gwo wule e God eteri wule. Etep wobe, etepkap eme God erne bepou sukye worabe. Aisaia ere etep wom, eke Jisas ere etep emne wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas ere tatame emne wopeten emne etep wom. Kem wan tai. Kem ari tuma ek met. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tame abe awos e tame emri porere yaper beke te. Berai. Be wos tame emri porerek abon etep tebe o wobe, ete woske tame emri porere yaper tebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Etep womke, eri anepoi tame eme yan etep wom. Farisi tame eme neri woye tuma eme mo woye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ere awosein etep wom. Ari Apei ere Hevenke tetan, ere now maime. Be wos ere beke nanekwo, nowke bepou me rekwam, top yaper ere somoken nenken akei me yese peten sepitte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kem Farisi emne mane abote. Emri tuma mane mette. Eme le si tamekap. Le si tame ere akeite le si tame erne kelu peterate, epe peske belebalen yin emi yaperke warte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita ere Jisas erne awosein etep wom. Nema beke noub met. Neri woye tuma somokap ne nemne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ere emne etep wom. Kerem kir, kem porereken berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Metye. Tame ere a abe, ete a ere sek warbe. Sene ere sek tetan yuri ere seken eibe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ete tame emri namdebe tuma eme etemri porerek kiyi abon ek namdebe. Emri namdebe tuma tatame eme yaper tebe. Ete tuma e yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tame emri porere yaper tetan, eme yaper wos nenbe, eme yaper wos abobe. Eme alwo pebe. Eme ta panen mesginbe, akeite ta sir yibe. Eme sir petbe. Eme tuma yikwokwobe. Eme akeite tame emne tuma yaper wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ete wos tatame eme tobote, eme tatame yaper. Farisi tame eme tatame emne wobe, kem let ok kiyi beke keyan, awos ek a, kem tatame yaper. Emri etepkap wobe tuma e yaper. Eme me eiksebe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas ere eri anepoi tameken eme ete kom mesginin Tairken Saidonken yekwok yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yim, Kenan nowselri ta wuri, te Juda ta berai, te etek temenem, te yan etep wom. Aneyen, Devit eteri nan, ne ane kobo la. Gabo ere ari yen tene guleleten, ere tene yaperwai tebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jisas ere awosein beke wo, eri anepoi eme yan erne etep wom. Ete ta te neremri kin yekwok wokeren yabe. Ne tene won, te sene yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ere tene etep wom. Juda tatame eme sipsipkap, eme mou yim. God ere ane won yam, an etemnewou kobo late yam. An akeite nowselri tatame emne kobo beke la. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ta te etep metemke, te yan gulke pan sene etep wom. Aneyen, ne ane kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Etep womke, ere abom. Ete ta te Juda ta berai. An Juda tatame etemne kiyi kobo lan nente. Etep abom, ere tene awosein etep wom, ere tene sekur sakur tumak etep wom. Nema yen etemri awos beke peten wale emne beke newon a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Te awosein etep wom. Neri woye tuma e seken. Aren, an etep wobe. Yen emri abe awos nebule selke yeirbe, wale eme eteke nugen abe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ere tene etep wom. Ne ane kenawaike abobe, eke neri aboye wos an etep nente. Etep womke, agetage ete ta teri yen te sene yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas ere kom mesginin yim, ere Galili peik kupa mekinke yim. Yim, ere kowke yawon sim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sibetem, tatame nogwape eme let kere tewo kere tatame emne Jisas eterke panen yam. Tewo yaper tatame, le si tatame, let tewo guri tatame, tuma eikse tatame, akeite akeite let nai tewo naibetem tatame emne eme panen etek yam. Yam, eme Jisas eteri tewo tobok yan emne etek rasem, ere emne eyarbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Etep temke, tatame nogwape eme eteke lam. Tuma eikse tatame eme tuma sene namdebetem. Let tewo guri tatame eme yenbo tebetem. Tewo yaper eme kuyese sene sewurbetem. Le yaper eme kuyese sene labetem. Eme eteke lam, eme wouken aken etep wom. Juda tatame emri Keryen God eter ere emne noub nenbe. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas ere eri anepoi tame emne won yan emne etep wom. An gwo tatame emne kobo laye. Yabel mur eme arenken tem, emri sen yam awos eme akei an omom. An emne won komke sene yite, an emne awos beke newon an eme ek yite, eme kelu kwoi san keluke le menaborborkap pen kermusken yate wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eme erne etep wom. Gwote emi e tatame berai. Awos nema mak peten, tatame nogwape emne ek newon ate? ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ere emne wometlam. Kem geil sok mapseinke tetan? Eme awosein etep wom. Nema geil sok ep yekwo let ep yekwo let bor pes kei (7-pela) etepke tetan. Nema omyen sok kau tetan. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jisas ere tatame emne won eme selke sitirim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sitirimke, ere geil sok ep yekwo let ep yekwo let bor pes kei (7-pela) peten omyen peten God erne pir wom. Pir won, ere eri anepoi tame emne newon eme tatame emne newopit peteyam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Newopit peteyam, eme akei an se kir tem. Sene anepoi tame eme awos tep peten sare ep yekwo let ep yekwo let bor pes kei (7-pela) etek yewon pelawom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Am tame eme nogwapewai (400). Eme yenta kir beke sar. Eme tamewou sarem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sene Jisas ere tatame emne won yim, ere pere peten Magadan yekwok sene yin tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi tameken Sadyusi tameken eme Jisas erne yan lan etep abom. Kap ere God eteri komke yam, o ere kap nowselri tame. Etep abom, eme erne seilan etep wom. Ne rigrabe nenen nema late. Etep tete, nema etep wote. Ne God eteri komke yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ere emne awosein etep wom. Perpe yabel yenbo waren wolebe, kem etep wobe. Kipi yabel paste nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Keni yabel wayebe, kem mou neirbe makwos labe, kem etep wobe. Gwopte mou marye yate nenbe. Etep wobe, kem nelke tebe wos, kem noub labe. Gwopte tetan wos, God eri won yam tame ere nenbekap kem noub beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gwopte tetan tatame eme tatame yaper, eme God eri wule beke met. Kem ane rigrabe nente woye. Keremri woye wos an beke kip nen. Kiyi temenem tame, Jona, eri nenbetemkapwou an nentek, kem etepwou late. Kiyi Jona ere neir mur yabel mur ere omyen eisau eteri kibuk temenem. Etep won ere emne mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Anepoi tame eme peik kupa keraruke wute nenbetem, eme geil beke peten sen yi. Eme bepou me yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yim, Jisas ere etemne etep wom. Kem noub met. Farisiken Sadyusiken etemri bret pelbe wos, yis, kem mane pette. Ete wos yaper. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eme etemwou etemwou etep wom. Nema geil beke sen ya, ere eke wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Etep womke, Jisas ere meten emne etep wom. Beke kem geilwouke abobe? Kem ane kenawaike beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kap kem beke met? Kiyi an geil ep yekwo let peten tame nogwape (500) emne newon am. Kem kap som abobe o? A tep sare mapsein kem sene peten yewom? ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Akeite yabel an geil ep yekwo let ep yekwo let bor pes kei (7-pela) peten tame nogwape (400) emne newon am. A tep sare mapsein kem yewom? ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kiyi an kemne woye. Kem Farisi tameken Sadyusi tameken etemri bret pelbe wos, yis, kem mane pette. Ari woye tuma, an geil beke abon wo. Berai. Emri yis kem mane pette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Etep womke, emri porere eme etep abom. Ere nemne yis beke wo. Farisiken Sadyusiken etemri tuma nema mane mette. Ere nemne eteke woye. Eme etep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas ere Sisaria Filipai komke yibetemke, ere eri anepoi tame emne etep wometem. An Tatame Etemne Lan Yeirim Tame. Tatame eme ane mapeke wobe, an eike? ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Eme awosein etep wom. Kau eme nene etep wobe. Ne tatame emne baptais ok wirubetem tame, Jon. Kau eme nene etep wobe. Ne kiyi temenem tuma wusoubetem tame, Elaija. Kau eme nene etep wobe. Ne kiyi temenem tuma wusoubetem tame, Jeremaia. Kau eme nene etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jisas ere emne wometem. Kerem, kem ane mapeke wobe, an eike? ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita ere awosein etep wom. Ne Krais, God eter nene won yam tame. Ne God Eteri Yen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisas ere erne awosein etep wom. Saimon, Jon eteri yen, ne metekwaste. Tame etem eme nene etepkap tuma beke wusou. Berai. Neri woye tuma ari Hevenke tetan Apei eter ere nene etepkap tuma wusouye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pita, neri tetan sig somo e pape. Neri woye tuma e seken. Tatame eme neri woye tuma kenawaike mette, eme arenken temente. Arenken temente, eme sate, eme yaper beke kip te, eme yenbo som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","God eteri komke yibe kelu e eru tetan. Ete ake eru latbe wos an nene newote. Ne tame emne etep wote. Ne beke kip wur. Etep wote, ere beke wur. Ne tame emne etep wote. Ne epe wur. Etep wote, ere ek wurte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Etep wom, ere anepoi tame emne wom. Kem akeite tatame emne mane wosoute, an Krais, God ere ane won yam tame. Ere emne etep wotakem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ete yabel Jisas ere eri anepoi tame emne ere sate wule emne wusowum. Ere etep wom. An Jerusalemke yite. Yite, Juda apeilake, God eri akek yaku kerebe tame emri apeilake, Moses eri wule tuma wusoube tame eme ane yaper nente, an mus eisau mette. Eme ane pen sate. Sate, yabel pes tete, wuri, God ere ane wotek, an wou sene peten sene wayen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Etep womke, Pita ere metem, ere erne ep kera panen yin erne elen tumak wom. Ere erne wotaken etep wom. Aneyen, God ere nene pap yewoten. Eme nene mane pen sate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Etep wom, Jisas ere petkwo lan Pita erne etep wom. Satan, ne seki. Ne ane kelu tukbe. Ne God eteri porere beke tobo. E tame yaper etemri porere. Ne ane mesginin yite. Jisas ere erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jisas ere eri anepoi tame emne sene etep wom. Tatame eme ari tame supa tete, eme gwopke tete. Eme etemri maime wusom beke kip abo. Ari mette muskap eme mo beke kip wo, eme etep kir mette. Tame eme etep tete, eme areri anepoi tame yaku yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tame eme etem maime wusom abote, ete tatame eme yaper tete nenbe. Tatame eme ane abote, eme etem maime wusom beke abo, ete tatame eme noub som temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tatame eme nowselri wos nogwape pette, sene eme yaper tete, e yenbo o? Berai. E yaper. Tatame eme God eri komke yite abobe, eme kelke tuken yi. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","An Tatame Etemne Lan Yeirim Tame, ari sene yate yabel mekin mekinye. An yate, an Apei God eteri mureken yate, God eteri kom tame emne panen yate. Yate, an tatame emri kerebe yaku emne tokwo newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Metye. Kem gwotek tetan tame, kau kem beke kip sa, kem late, an kom panen site mureken yate nenbe. An Tatame Etemne Lan Yeirim Tame. An yate, kem late nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yabel ep yekwo let ep yekwo let ges wuri kei (6-pela) yimke, Jisas ere Pita, Jems, eteri mase Jon emne panen kow eisauke yawom. Etemwou eme etek yawon temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Etek temenem, eme lam, Jisas eri wus kaspen eri bitimi ere oknalkapke lam. Eri warmenem tame oub geipawaike lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Geipawaike lam, sene eme lam, kiyi temenem tame pes Mosesken Elaijaken epe God eri komke yan yeirin temenem, epe Jisas erken tuma namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Etep lam, Pita ere Jisas erne etep wom. Aneyen, nema gwotek tetan, e yenbowai. Ne wote, nema yabel ake mur kerete. Wuri nereri, wuri Moses eteri, wuri Elaija eteri, nema gwotek kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wobetemke, nel gwan ere geipawai ere yeirin emne subpitim, eme tuma wuri etek metem. Etek wobetem tuma ere etep wom. E areri Yen yenbo adebas. An erne metekwasbe. Eri tuma kem noub mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Etep wom, eri anepoi tame eme eri tuma metemke, eme kenake aken waren tuknam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Waren tuknam, Jisas ere emne mekinke yan emne letke keren etep wom. Kem mane akte. Kem epe wayen tet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tetem, eme lam, Jisas eterwou etek som temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eme kow mesginin yeirbetem, Jisas ere emne noub wom. Kemri laye woskap kem mane kip wusoute. An tatame etemne kobo late yeirim tame. An sate, sene wayen yite yabelke kemri laye wos kem ek wusoute. Gwopte kem mane wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Etep womke, anepoi tame eme erne etep wometem. Moses eri wule tuma wusoube tame eme etep wom. God eri tuma wusoubetem tame, Elaija eter, ere taresin yatek, Krais ere yurik yate nenbe. Beke eme etepkap wom? ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ere tuma sein etep wom. Eme sekenke wom. Elaija ere kiyi taresin yam. Yam, ere Krais eter yate kelu regem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Regem, tatame eme beke met, ete tame erne God ere erne won yam. Eme erne etemri porerek yaper abom, erne yaperwai nenem. An Tatame Etemne Lan Yeirim Tame. Elaija erne yaper nenemkap, eme ane yaper kir nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Etep womke, eme meten etep abom. Ere tatame emne baptais ok wirubetem tame eterne wobe. Jon ere Elaija eterkap. Eme etep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Eme kowke yeirin, eme yin tatame nogwape emne yin lam. Lam, tame wuri ere Jisas erne yan gulke pan etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aneyen, ne ari yen erne kobo late. Erne gabo guleleten, etepkap yabel nogwape ere kerke san warbetem, o ere okke san warbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","An erne kiyi neri anepoi tame etemne panen yawo, eme erne kuyese beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisas ere etep wom. Oi, kem ane kenawaike beke abo. Kemri porere yenbo berai. Yabel nogwape an keremken temenem, kem kenawaike beke abo. Kem ete yen erne panen arenke yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Panen yamke, ere gabo erne pekeroukumke, gabo ere ete yen erne mesginin yim, agetage yen ere yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yuri anepoi tame eme lam, tatame nogwape eme sene yimke, eme Jisas erne wometem. Beke nema gabo erne pekerouklawoyim? ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ere emne sene etep wom. Kem etep beke abo. God ere mureken, ere kuyese nente. Etep beke abo, eke kem gabo pekerouklawoyim. An kemne sekenke wobe. Kem God erne kerake abotek, kem ete kow erne etep wote. Ne ete emi mesginin akeite emik yi. Kem kerake abon etep wotek, kow ere ek yite. Kem kerake abote, kem God erne womette, kem kuyese nente. Kow erne won yitekap, kem etepkap rigrabe nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Kem gabo pekeroukte, kem gwopke tete. Kem awos lek lan beke a, God erne womette. Etepwou tetek, kem gabo kuyese pekeroukte. Jisas ere etep wom.) ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Eme Galilike yan sewurbetem, Jisas ere eri anepoi tame emne etep wom. An Tatame Etemne Lan Yeirim Tame. Yuri eme ane keresukte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Eme ane pen sate. Neir pes tete, mur wote, an sene wayen yite. Anepoi tame eme etep metem, eme pap yaper tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yuri eme Kaperneam komke yim. God eri ake eisauke kel petbetem tame eme yan Pita erne wometen etep wom. Keremri Aneyen ere God eri ake eisau kel rasbe o? ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita ere etep wom. Ye. Ere kir rasbe. Etep womke, Jisas ere erne kiyi wom, erne etep wometem. Saimon, ne mapeke aboye? Gwo nowsel apeilake eme eikene womettek, takis kel ek raste? Eme etemri yenta, anenawo etemne womette, o eme akeite tame etemne womette? ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ere awosein etep wom. Eme akeite tame etemne womette. Jisas ere erne etep wom. Seken. Yenta, anenawo etem eme takis beke ras. An God Eteri Yen, eke an takis beke kip ras, God ere ane tuma beke kip namde. ");
INSERT INTO yss_yawu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","An beke kip ras, tame etem eme ane tuma namdete. Eke an kir rasbe. Ne peik kupak yin pus sogwunte. Kiyi wurte omyen ne eri elemoi gworan kel etek late. Ete kel ne peten sen yin emne newote. E nesetri takis kel. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ete yabel anepoi tame eme Jisas erne yin lan etep wom. God ere tatame emne kom panen site, eike nemri apeilake eisau tete? ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Etep wom, Jisas ere yen wuri erne wopeten yan emri borborke tetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Tetem ere etep wom. Kem abote. Kemri porere yaper kem mesginte. Yen eme yenbo woswou abobekap, kem etepke abote. Kem etep tete, kem God eteri komke yin eterken temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tame eme emri sig teitkwunte, eme yen nebulekap abote, ete tame eme God eri panen si komke yite, God ere ete tame eri sig eisau wote. Tatame eme yen nebule emri sig etep abobe. Yen emri sig e kulke tetan. Etep abobekap, kem kemri sig maime etepke abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tame eme ane abobe, eme gwopkap yen erne pap yewobe, etepkap ere ane kir pap yewobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tame wuri ere ane yenkap kenawaike abobe, sene tame wuri ere erne yikwokwon seilate, ane kenawaike abobe tame ere ane magel tayen wule yaper nente, e yaperwai. Tuma yikwokwobe tame ere wule yaper som nente wurken, eke eme erne pape eisau wakke tenen peik meike seitin ere etek sate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gwote nowselri wos ere tatame emne wule yaper seilabe. Ete wos yaper tete nenbe. Eike tatame eme akeite tatame emne wule yaper seilabe, God ere emne yaperwai awosein nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Neri let o neri tewo ne wule yaper nente, God erne sene beke abo, etepkap ne neri let o tewo tem peten sepitte. Ne let o tewo wurisubu temente, God eri komke yin etek temente, e yenbo. Ne let o tewo pespes temente, ne ker tetan komke yin temente, e yaperwai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Neri le sebera ya wos lan God erne sene beke abo, etepkap ne ete le puk peten sepitte. Ne le wurisubu temente, God eteri komke yin temente, e yenbo. Ne le pespes temente, ker tetan komke yin temente, e yaperwai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kem yen emne yaper mane nente, emne mane sewayin etep wote. Eme yen nebule. God eri komri tame eme yen emne lakerebe. God eri kom tame eme God eterken tetan, eke God eter kir ere yen emne lakerebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Bepou pauk berai. An Tatame Etemne Lan Yeirim. An yam, an wule yaper tetan tatame etemne sopen pette yam, emri wule yaper peten sepitte yam.) ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Tame wuri ere sipsip nogwape (100-pela) temente, sipsip wuri mou yite, maime ere mapeke tete? Ere sopte o ere me mesginte? Sipsip nogwape (99) eme awos kowke som abeteteke, ere emne etek mesginin ere sipsip wuri sopen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yin lan ere sene pette, ere metekwaste nenbe. Sipsip nogwape (99) eme noub tetan, ere emne beke noub metekwas. Eter sopen sene petem sipsip eterne ere kenawaike metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tame ere sipsip erne lakerebekap, kemri Hevenke tetan Apei ere tatame emne etepke lakerebe. Tatame eme sipsipkap mou yite, yuri eme kom yaperke yite. Etepkap God ere mowai wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","God erne kenawaike abobe mase ere nene yaper nente, ne yin erne etep wote. Ne ane yaper nenye. Etep wote, eterwoune ne yin wote. Ne akeite tatame emne mane wusoute. Ne eterwoune yin wote, ere neri tuma mette, e yenbo. Ne erne yenbo nente, kep pespes kir noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ere neri tuma beke met, ne yin tame pes o mur panen kem erne sene yin late. Kem etep yin eterken sene namdete. Kiyi temenem tame eme God eri tuma etep bas rasem. Kem tame pes o mur kem tuma kirkir wotek, kemri woye tuma e seken. Emri bas rasem tumakap kem etep tobote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Etep tete, ere kemri tuma beke met, ere nene yaper nenemkap, ne kenawaike abobe tatame nogwape emne etep wusoute. Wusoute, ere keremri tuma beke met, kem erne God eteri tuma beke met tamekap won yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","An kemne wobe. Tame emri nenbe wule yaper, kem kuyese beke mesgin, Hevenke tetan Apei eter kir ere beke kip mesgin. Kem tame emri wule yaper mesgintek, Hevenke tetan Apei eter kir ere mesginte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","An kemne tuma wuri sene wote. Kemri tame pes epe be wos pette wote, o nente wote, epe selpap wurisubuk tete, epe God erne wolatek, ari Apei ere Hevenke tetan, ere ete wos nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tame pes o mur eme wurik sin eme ane abote, etem tetan emik an kir etek temente. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sene Pita ere Jisas erne yan etep wolam. Aneyen, ari mase ere ane yaper wos tewok tewok nente, an eri yaper nenbe wos tewo mapsein mesginte? Kap ep yekwo let ep yekwo let bor pes kei (7-pela) o? ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas ere erne awosein etep wom. Ep yekwo let ep yekwo let bor pes kei (7-pela) an nene etep beke wo. Berai. Tatame eme nene tewo tewok yaper nente, ne emne tewo tewok emri yaper nen wule gerute. Etep tete, e yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Pita ere erne etep wolamke, eke Jisas ere sekur sakur tuma etep wom. God ere tatame emne kom panen sin emri yaper nen wos peten sepitte wule ere gwopkap. Kiyi keryen tame wuri temenem. Ere etep wom. Ari yaku kere tame nogwape emne an ari kel newom, eme ane awosein beke newo. An wobe, eme ane kel awosein newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ere kel sene pette yaku somo tasemke, eme yaku kerebe tame wuri erne panen yam, ere kel eisau kiyi petem tame. Kel nogwape eisau ere kiyi petem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ete tame ere kelken berai, ere kel awosein mapeke newote? Eke keryen tame ere etep wom. Tame eme ete tame erne, eri yen taken wosbasken akei tuktek, ete kel ere peten ane newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Etep womke, ete tame ere keryen tame eteri tewo tobok gulke pan etep wom. Ne ane kobo late. Yuri an nene kel awosein newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Keryen tame ere erne kobo lan erne etep wom. Ne kel awosein mane newote. Etep wom, ere erne won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ete tame ere sene yibetem, ere eri yaku kere tame sip erne lam. Kiyi ete tame ere eri kel petem, ere awosein beke newo. Kiyi ere eri kel nogwape kera petem. Erne lan ere erne borwagke keren etep wom. Neri petem kel ne ane awosein newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Etep womke, ete tame ere gulke pan erne etep wom. Ne ane kobo lan ane kera koute. An nene awosein newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ete tame ere koute mo wom, ere erne panen yin ake yaperke won wurin temenem. Ere etep wom. Ne ari kel awosein newotek, ne ake yaper mesginin sene worate. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Etep tem, eri yaku kere tame sip eme eri yaper nenemkap lam, eme pap yaper tem, eme yin keryen tame erne etep wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Keryen tame ere etep metem, ere yaku kere tame erne wopeten yan erne etep wom. Ne yaku kere tame yaper. Kiyi ne ane wolam, an nene kobo lam, ne petem kel eisau an sene beke pet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","An nene kobo lamkap, beke ne ete tame erne kobo beke la? Etepkap ne tame yaperwai. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Keryen tame ere erne pap wayen, ere erne ake yaperke won wurin, ere erne etep wom. Ne kel awosein newotek, ne ake yaper mesginin ek worate. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jisas ere sene wom. Ari woye sekur sakur tuma somo kem abote. Tatame eme kemne yaper nente, kem mane abote, ari Hevenke tetan Apei ere kemri yaper nen wule kir beke kip abo. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas ere tuma omon ere Galili mesginin Judia distrikke yim. Eme Jordan peik keraruke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yim, tatame nogwape eme emne semowun yim, Jisas ere emri rekebuk tame emne eyarem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisi tame eme erne yan erne tuma wuri wometem. Eme etepke abom. Nema erne womette, ere kap nemne tuma yaper awosein wote. Eme erne etepke wometem. Moses eri wule mapeke wobe? Tame ere ta tene sene mesginte, e yenbo o? ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisas ere awosein etep wom. God eri tuma, eme kiyi bas rasem tuma, kap kem beke la o? Eme etepke bas rasem. Kiyisape God ere wos nogwape seikim, ere taken tameken kir seikim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Eme sene bas rasem. Tame ere eri aken nawoken epne mesginin yin ere taken tete, epe etep kena temente. Epe wusom wurisubuk tete. Etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tame ere ta panete, epri wusom pes berai. Epe wusom wurisubu. Tame ere ta tene panebe, God ere wom, e yenbo. Eke tame ere ta tene mane mesginte. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisi eme erne etep wom. Neri woye tuma e seken berai. Kiyi Moses ere siglouke bas rasen etep wom. Tame ere ta mesginte abobe, ere siglou bas rasen ta tene newon, ere tene ek mesginte. Ere etep bas rasem. Beke ere etep bas rasem? ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas ere emne etep wom. Kiyi Moses ere lam, kem Juda tatame kem wan kenake gwolebetem, eke ere kemne wom. Kem siglou newon, kem ta tene mesginte. Kiyisape God ere taken tameken seikim, eme etepkap wule beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","An kemne wobe. Tame wuri eri ta te sir beke yi, tame ere tene bepou me mesginte, ere sene akeite ta panete, ete tame ere sir yibe wulekap tebe. Ere yaperke tebe. Eri ta te sir yite, etepkap ere tene mesginte, e tumaken berai. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Eri anepoi tame eme erne etep wom. Tame ere ta panete, yuri ere tene mesginte. E neremri wule. Neren ne etepke wobe. Tame ere ta bepou mane mesginte. Etepkap nema abobe, tame ere ta beke kip pane, ere bepou me temente, e yenbo. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisas ere emne etep wom. Tame ere ta beke pane wule, ete wule tame nogwape eme beke tobo. God ere kau tame emne mure newobe, eke eme ete wule kuyese tobobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kau tame eme ta beke pane. Kau eme tametobo, eme ta panete beke abo. Kau eme yomo pet tame eme ta beke pane. Kau eme God eri yakuwou abobe, eme ta beke pane. Ta beke pane tame, kem ete tuma mette. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sene kau tatame eme nebule yen panen Jisas erne late yam. Eme abom, ere yen emne tarek let keren God erne womette, ere yen emne noub nente. Eme eke panen yam. Yam, Jisas eri anepoi tame eme tatame emne lam, eme emne wotakem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisas ere etep metem, ere etep wom. Kem emne mane wotakete. Nebule yen eme arenke yate. Eike God erne kenawaike abote, nebule yen etemri porerekap eme tete, eme God eri panen siten komke yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Etep womke, ere emne let tarek keren Apei God erne wometem, ere emne noub nente. Etep ten ere ete emi mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sene tame wuri ere yan Jisas erne etep wom. Tuma wusoube tame, be wule yenbo an nentek, an noub som temente? ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisas ere awosein etep wom. Beke ne ane wule yenbo wometbe? Gwo nowselri tatame eme eike yenbo wuri beke te? God eterwou ere yenbo. Ne noub som temente abobe, ne God eri kiyi bas rasem tuma meten tobobet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Etep wom, ete tame ere wometem. Be tuma? Jisas ere awosein etep wom. Ne alwo mane pen sate. Akeite tame emri ta ne sir mane yite. Ne sir mane pette. Ne akeite tame emne tuma mane yikwokwote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ne anenawo epri tuma wan wurik mette. Ne neren maime yenbo nenbekap, ne akeite tatame emne etepwou nente. Kiyi God ere etep wom, eke eme bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Etep womke, ete tame ere etep wom. Neri woye wule an akei toboten. Be woske an sene nente? ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas ere erne etep wom. Wos wuri ne sene nente. Ne etep tetek, ne God eri wom wos nente, ere metekwaste. Ne yin neri wosbas nogwape akeite tame eme tukte. Tukte, kel ne peten wosken berai tatame emne newote. Newotek, ne sene yan arenken sewurte. Yuri ne God eri komke yite, wos nogwape yenbo ne pette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Etep womke, tame taureyen ere etep metem, ere pap yaper ten ek yim. Bepou berai. Eri wosbas nogwape eike tatamene newo ere mo wom. Eke ere bepou me yim, Jisas eri womkap ere beke tobo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ere yim, Jisas ere eri anepoi tame emne etep wom. An kemne wobe. Wosken tatame eme emri nogwape wosbaswou abobetete, eme God eri panen siten komke yite abote, eme yaku eisau keren ek yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","An kemne sene wobe. Kamel por e akekap. Kamel ere mate kapebe lag taukke wurte wote, eme wurlawoite. Etepkap, nogwape wosbasken tame eme God eri komke yite wote, eme yaku eisau kerete, eme ek yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Eri anepoi tame eme ete tuma metem, eme wouken aken etep wom. Tame eme wosbasken, eme akeite tatame emne kuyese kobo late. Eke, nema abobe, eme God eri komke yite, eme yaku eisau beke kere. Neren, ne etep wobe. Eme yaku eisau kerete. Eke nema abobe, tatame nogwape eme God eteri kom kuyese beke yi. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisas ere emne noub lan etep wom. Tame etem eme akeite tame emne kuyese beke won yi, eme God eri komke beke yi. God eterwou ere tatame emne won yitek, eme eri komke yite. Wos nogwape God ere kuyese nente. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita ere Jisas erne etep wom. Metye. Nerem, nema wos nogwape mesginin nerenken anepoi yim. Nema etep tem, nema sene be wos pette? ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisas ere emne etep wom. An kemne wobe. An tatame etemne lan yam tame. Yuri wos ager nogwape tete, an yate, an apeilake tete. An ari wolbaye eisauke sin tatame emri tuma mette, emne sin late. Kem ep yekwo let ep yekwo tewo bor pes kei (12-pela) tame, kerem kir, kem wolbayek site, kem Israel tatame emri tame beig ep yekwo let ep yekwo let tewo bor pes kei (12-pela) emri tuma meten emne sin late. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ane abobe tatame eme akei, lakemase, naregeisi, anenawo, yen, wosbas mesginin ari yaku keretek, God ere emne noub awosein nente, eme noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Gwopte tame kau eme sig eisau tetan. Yuri ete tame eme sigken berai tame sene tete. Eme bepou me tete. Bepou me tetan sigken berai tame, yuri eme sene sig eisau pette nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas ere etep wom. Keryen God eri kom panen site wule ere gwopkap. Tame ere now eisau temenem. Eipipiwai ere yin now yaku kerete tame sopte yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yin lam, ere emne etep wom. Kem yabel wuri yaku kerete, an kel ep yekwo let ep yekwo let kemne wurare wurare newote. Etep womke, eme kir tem, ere emne now yaku won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Keru yabelke ere komke yin lam, kau tame eme bepou me temenem, eme yakuken berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Lan, ere emne etep wom. Kem ari now yaku kerete, an kemne tokwo yenbo newote. Etep womke, eme eri wom yaku yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yabel me pebetem, ere komke sene yim. Yuri ere sene yin yaku kere tame kau sene petem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Perpe ere sene yin lam, kau tame eme bepou me tetemenem. Ere emne etep wom. Kem bepou me teteten. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Eme awosein etep wom. Nemne eike tame yaku wuri beke newo. Ere etep wom. Kem ari now yaku kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Perpe tebetemke, now maime ere yaku lakere tame erne ere etep wom. Ne yaku kere tame emne wo peten tokwo newote. Tipti yawo tame emne ne tokwo kiyi newote. Kiyi yawo tame emne ne tokwo yurik newote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tiptiwuk yam tame eme yam, kel epe yekwo let epe yekwo let eme wurare wurare petem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yaku kiyi taresin kerem tame eme yan etep lan, eme etep abom. Nema kap kel nogwapeke pette. Etep abom, kel ep yekwo let ep yekwo let eme kir petem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Petemke, eme now maime erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ete tame eme yurik yawo, eme yaku nogwape beke kere. Eme yaku kerake kereye. Nerem, nema keruke yawo, yabel eisau nemri wuske pasrasbe, nema yaku eisau kenake kereye. Ne nemne etemne newoye tokwokap newoye. E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Now maime ere etemri tame wuri erne awosein etep wom. Metye. An nene yaper beke nen. An nene kiyi woye. Ne ane yaku kerete, kel ep yekwo let ep yekwo let an nene newote woye. Ari woyekap, an etepke toboye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nene newoye tokwo ne peten sen yi. Nene newoye tokwokap an aboye, an yuri yawo tame emne etepke kir newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","E areri wos. Kel nogwape e areri kel. An newote wote, kem mane wote. An yenboke nenye, eke an emne bepou me newoye, beke ne pap yaper teye. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jisas ere sene etep wom. Tatame eme God eri komke yite, eme etepkap pette. Ane kiyi kenawaike abobe tatame, ane yuri kenawaike abobe tatame eme tokwo wurisubu pette. Eme kena kena beke kip pet. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas ere Jerusalem komke yibetem, ere tatame nogwape emne mesginin ere ep yekwo let ep yekwo let tewo bor pes kei tame (12-pela) emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Kem ek met. Gwopte nema Jerusalemke yaute. An tatame etemne lan yam tame, eme ane keresukun eme ane panen yite. God eri akek yaku kerebe tame emri apeilake etem, Moses eri wule wusoube tame etem eme ane etemke panen yite. Eme ane pen sate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sene eme Juda berai tame etem, eme ane peten ane tuma yaper won paku pete, ane mek kwuran kwanen an sate. Neir mur tetek, an sene wayen yite. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebeti eri yen pes epri nawo te yen epne Jisas eterke panen yan, te gulke pan Jisas erne wote abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisas ere tene wometem. Ne be woske aboye? Te awosein etep wom. Yuri ne apeilake tete, ne wolbaye eisauke site, an aboye, areri yen pes epe nerenken kom panen site. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Etep womke, Jisas ere tene awosein etep wom. Neri wometye tuma ne noub beke abo Etep wom, ere epne wometem. Eme ane yaper nente, an mus mette, kap kep kir kuyese mus mette, o kap ane mesginte. Mus mette, e ok yaper abekap. Epe awosein etep wom. Berai. Nesa nene beke kip mesgin. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ere etep wom. Ye. Eme ane yaper nentekap, eme kepne kir yaper nente. Aren, an beke kip wo, eike ari ya gwaimeken ya mameken site. E ari yaku berai. Ari Apei eterwou ere wote, eike etek site. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jisas eri akeite anepoi tame ep yekwo let ep yekwo let eme ete tuma metemke, eme ete yen pes epne tuma wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tuma won, Jisas ere emne won yan emne etep wom. Nowselri apeilake eme emri kulke tetan tatame emne yaku eisau newobe. Eme yaku beke kere, apeilake eme emne paku pete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Emri tebekap, kem mane tobote. Kem apeilake tete aboye, kem yaku kere tamekap tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kem apeilake tete abote, kem tatame nogwape emne yaku kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","An Tatame Etemne Late Yeirim Tame, an etepwou tebe. An yam, an beke wo, tatame eme ane yaku kerete. Berai. An yam, an etemne yaku kerete yam. An tatame emne kobo late yam. Eme ane pen sate, an emne tuken emri wule yaper peten sepitte. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Eme Jeriko kom mesginin yibetem, tatame nogwape eme Jisas erne semowun yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yibetemke, le si tame pes epe kelu ganke simenem, epe metem, Jisas ere ete keluke yabetem. Etep metem, epe noubke ten etepke wom. Jisas, ne Devit eteri nan, ne nesetne kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tatame eme epne wotaken etep wom. Kep elen te. Etep womke, epe sene noubke etep wom. Jisas, ne Devit eteri nan, ne nesetne kobo late. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas ere epri tuma meten, ere epne wometem. Kep aboye, an kepne be woske nente? ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Epe awosein etep wom. Aneyen, nesa abobe, nesetri le ne eyarte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas ere epne kobo lam, eke ere epri le letke kerem. Keren, epe le sene kuyese lam, epe erne semowun eme etep yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Eme Jerusalemke yibetem, eme Oliv kowke tetan komke yam. Kom sig Betfage. E Jerusalem mekinke tetan. Yabetem, Jisas ere yen pes epne won taresin yite wom. Ere epne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kep ete komke yin wurtek, kep late, donki por pes, yenken nawoken, epe etek kepke tenten. Kep yin kep ogwon, donki pes ane panen yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kep yin kep ogwobetetek, eike tame eme kepne womette, kep emne awosein etep wote. Aneyen eter nesetne woye, eke nesa donki epne panen yite woye. Kep etepke wote, eme agetage kir tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jisas ere etep bepou beke wo. Kiyi temenem tuma wusoubetem tame eri bas rasem tuma, eke ere tobom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ere etepke bas rasem. Ne Jerusalem komri tatame emne yin etep wote. Kemri Aneyen ere yabe. Ere apeilake etemri kerap beke wole. Ere donki yen eri magel luke siye elenke yabe. Kiyiri tuma wusoubetem tame ere etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Won yim tame pes epe taresin yin Jisas eri womkap epe etepke tobom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Donki yenken nawoken epne panen yabetem tame, epri warmenem tame oub lagwubai lugun donki pes epri magelke rasen Jisas ere etek yawon sin ek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yibetem, tatame nogwapewai eme Jisas eri yibetem keluke tetemenem, eme emri warmenem tame oub lugun keluke petan yibetem. Kau tame eme tewoteya take kwosin keluke petan yibetem. Eme abom. Jisas ere apeilake. Eke eme etepke nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Eterken temenemem tatame, eterken tipti wumenem tatame eme noubke etepke wobetem. Eteke, Keryen Devit eteri nan ere nemne yan labe, nema eteri sig eisau wobe. God ere erne won yam. God ere erne yenbo nente. God ere nemne kobo labe, ere erne won yawo, erne yenbo nenye. Eme etepke noubke tebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas ere Jerusalem kom sagke wurimke, komri tatame eme erne lam, eme wouken aken etep wom. E eike yabe? ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eterken yabetem tatame eme awosein etep wom. Ere tuma wusoube tame. Eri sig Jisas. Eri kom Nasaret, Galili distrikke teten kom. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas ere God eri ake eisauke wurin lam, tatame eme kel pet yaku etek kerebetem. Ere lan, ere emne won emri wos keroukem. Kau tame eme kel natokwo kere yaku kerebetem, ere emri kel rasbetem tiy peten lagalapitin warem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Lagalapitin waren, ere emne etep wom. Kiyi temenem tame eme God eri tuma etepke bas rasem. Areri ake e arenken tuma namdebe ake. Eme etep bas rasem. Kem etep beke tobo. Eteri akek kem kel pet yaku kerebe. Etep tebe, eteri ake e sir pet tame etemri berasen sibe akekap. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas ere God eri akek temenem, le si tame, gulwar yaper temenem tame eme erne yan lam, ere emne noub eyarem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Etep tem, God eri akek yaku kerebetem tame emri apeilakeken Moses eri wule wusoubetem tameken eme eri nenem wos yenbo lam, eme erne eike tetem. Yen nogwape eme wurin eterne noubke tebetem, eri sig eisau wobetem, eme etep wom. Eteke, ne Devit eteri nan, nema neri sig eisau wobe. Etep wobetem. Apeilake eme yen emri tebetem tuma metem, eme Jisas erne pap wayem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Eme erne etep wom. Yen emri tebekap ne metye? Etepkap yaper. Ere awosein etep wom. Ye, an metye. Emri tuma e yenbo. Kiyi temenem tame eme God eri tuma bas rasemkap, kem e tuma metem o? Eme epke bas rasem. Yakeleyenken aneyenken eme ari sig eisau wote. God eri tuma eme etepke bas rasem, Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Etep womke, Jisas ere emne mesginin yim, ere Betani komke yin ten, etek tuknam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kwokwos keru Jisas ere Jerusalem komke sene yibetem, ere kwoi sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ere yipige me kelu ganke lam, ere gelame kwutan ate yim. Yin lam, ete me ere gelame berai. Nawobe sebuke temenem. Ere etep lan, ere etep wom. Gwo me ere supa sene beke kip ya. Etep womke, Jisas eteri tuma tepken me ere san sok tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sok tem, eri anepoi tame eme etep lam, eme wouken aken etep wom. Neri tuma tepken ete me ere saye. Beke nenye, eke me ere saye? ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisas ere emne awosein etep wom. Kem ek met. Kem God eterwoune kenawaike abote, kem porere pes mane tete, ari tebekap kem kir tobote. Kem me erne wote, ere ek sate. Etepwou berai. Gwo kow erne kem etep wote. Kow, ne etek tetan okke warte. Etep wote, kow ere kemri wobekap ere kuyese etepke tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kem kenawaike abon, kem God erne be wos womette, ere kemne kuyese newote. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas ere God eteri ake eisauke wurin tatame emne tuma wusowum. Wusoubetem, God eteri ake yaku kerebe tame etemri apeilakeken Juda tatame etemri apeilakeken eme yan erne etepke wometem. Nene eike tamek gwote yaku kerete wom, eke ne ete yaku kerebe? Eike tamek nene won yam? ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisas ere emne awosein etep wom. An kemne wos wuri womette. Kem ane awosein wotek, kemri ane wometye tumakap yurik an kemne awosein ek wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon ere yam, ere tatame nogwape emne baptais ok wirubetem. Eike Jon erne ete yaku kerete won yam? Kap nowselri tame etem erne won yam, o God eter erne won yam, eke ere tatame emne baptais ok wirubetem? Etep womke, eme etemwou etemwou namden, eme etep wom. Nema mapeke awosein wote? Nema kip mane etep wote, God eter erne won yam tame. Etep wote nenbe, ere nemne awosein kip etep womette nenbe. God eter Jon erne won yam tame, beke kem eri tuma beke met? ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nema kip mane etepkap wote. Tame etem eme Jon erne won yam. Nema etep wotek, tatame nogwape eme etepke mette, eme nemne pap wayete nenbe. Eme abobe, Jon ere God eri tuma wusoubetem tame. Eke eme nemne kip pap wayete wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eme etemwou etemwou namden eme Jisas erne awosein etep wom. Nema beke met, eike Jon erne won yam. Ere emne etep wom. Aren kir, an kemne beke kip wo, eike ane won yam. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas ere emne sekur sakur tuma wuri emne etep wom. Tame wuri ere yen peske temenem. Eri mase tobo yen erne etep wom. Gwopte ne now yaku yin kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ete yen ere etep wom. An mo woye. Yurik ere sene abon, ere yin now yaku ek kerem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sene a ere mase erne yin etep wom. Ne ari now yaku yin kerete. Yen ere ar erne awosein etep wom. An kerete nenbe. Etep wom, ere now yaku beke yin kere, ere akek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kem mapeke abobe? Eike yen eter ere ar eri wom tuma meten yin yaku kerem? Eme erne awosein etep wom. Lake eter. Jisas ere emne etep wom. God eri kom panen si tatame eme etepkapke tete nenbe. Tatame yaperken, takis kel petebetem tameken sir yibetem tatameken etem eme God eri kom kiyi taresin yite nenbe. Kap kem yite nenbe, o kem beke kip yi? ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Baptais ok wirubetem tame, Jon, ere yan kemne God eterke yibe kelu peteram. Eri tuma kem kenawaike beke met. Tatame yaper, takis kel petbetem tameken sir yibe taken eme eri tuma kenawaike metem. Kem etep lam, kem selpap ager beke pet, erne kenawaike beke abo. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas ere emne etep wom. An sekur sakur tuma sene wuri wote. Kem ek met. Kiyi tame wuri ere nowsel nogwape temenem, ere gerep now nenbetem. Ere gerep supa nanekwom, ere bow peiken, sene ere okmoi wuri perem. Perem, ere now lakerete meker ake wuri kerem, tame eme etek sin now noub lakerebetem. Etep ten, ere yaku kere tame emne ete now lakerete etep wom. An akeite komke yite nenbe. Kem ari now yaku keren, noub lakeretek, yuri an kemne gerep supa kau newote. Etep womke, ere gene komke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Yuri gerep supa eme okwon yamke, now maime ere eri yaku kerebetem tame emne won yim, now yaku kerebetem tame emne nowke late yim. Now maime eri gerep supa eme kwutate yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yim, eme nowke yam, now lakerebetem tame eme yaku kere tame wuri erne paku pem, tame wuri erne me bwotkwum, tame wuri erne pape pakuk pem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Etep temke, now maime ere akeite tame nogwape emne sene won yim, now lakerebetem tame eme emne etepwou sene pebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Yuri now maime ere eri yen seken erne won yim. Ar ere etep abom. Ari yen seken eteri tuma eme mette. Etep abom, eke ere erne won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yim, now lakerebetem tame eme erne lam, eme etemwou etemwou etep namdem. Gwote yen ere now maime eteri yen seken. Nema erne pen satek, nema gwo nowsel pette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Etep womke, eme erne keresukun now kopok erne panen wurin erne etek pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jisas ere sekur sakur tuma emne won, ere emne wolam. Now maime ere sene yate, ere now lakere tame emne beke nente? ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Eme awosein etep wom. Ere tame yaper emne pen saiwote, ere akeite tame emne yaku newote nenbe. Newote, nowri awos petbe yabel tete, ete tame eme maime erne nowri gerep supa newote. Etepkap ete tame ere emne ete yaku newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas ere etep wom. Ari woye tuma e kiyi temenem tame etem bas rasem tumakap. Ete tuma kem lam o kem beke la? Eme etepke bas rasem. Tame eme ake kerebetem, eme kiyi sepitim kwat eteke sene peten ake kerem. Ete kwat e kobor nawo kwat yenbowai. Keryen God ere emne peteram, eke eme ete kwat sene peten yewom. Nema etep lan, nema wom. Keryen God ere yenbowai nenem. Kiyi eme etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jisas ere Juda tatame emne sene etep wom. An kemne wobe. God eri panen siten komke God ere kemne won keroukte, kemri etek tetan ake ere akeite tame emne newote. Eteri yaku kerebe tame ere emne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Tame eme ari woye kwat eterke tebete pitin waren tewo wusken baute. Ete kwat ere warte, ere tame emne botkwu yewon eme saiwote. Jisas ere emne etep wom.) ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","God eri ake yaku kerebetem tame emri apeilakeken Farisi tameken eme Jisas eri wom sekur sakur tuma metem, eme etep abom. Ere neremneke etepkap wobe. Eme etepke abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Etep abon, eke eme erne keresukun, erne tuma namdete wom. Tatame nogwape eme abom. Jisas ere God eteri tuma wusoube tame. Eke Farisi tame eme emne aken Jisas erne beke keresuk. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas ere emne sekur sakur tuma sene etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","God ere tatame emne panen sibe wule ere gwopkap. Kiyi apeilake eisau wuri ere temenem. Eri yen ere ta panete, ere emne awos eisau nenen ate wom, ere tatame nogwape emne awos yan ate wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wom, awos ate yabel temke, ere eri yaku kerebetem tame emne etep wom. Kem kom komke yin ari kiyi won tatame emne awos yan ate tuma emne wote. Eme yin wom, tatame eme mo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ar ere akeite yaku kerebe tame emne komke komke won yim, eme etep wom. Kem yate. Awos eme kiyi nenye. Eme por peye kwibe. A ere kemne kouten. Kem epe ya. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Etep womke, tatame eme ete tuma metem, eme yin a ate mo wom. Eme etemri yakuwou abom. Tame wuri ere nowke yite abom, wuri ere eri stua yaku yite abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kau eme apeilake eri yaku kerebe tame emne keresukun emne paku pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Apeilake ere etep metem, ere pap wayen ere eri ei nai tame emne won yin ete tame emne pik pen eme saiwom, eme emri ake kerke lisim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kerke lisim, sene apeilake ere eri yaku kerebe tame emne etep wom. Ta neisem awos nema kiyi eyarye. Taresin yate wom tame emri nenbekap e yaper, eke eme ete awos beke kip a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kem yin kelu bougke tetete. Kem tatame kau late, kem emne etep wote. Kem yan ta neisbe awos ate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Etep womke, eme yin keluke teten lam, tatame nogwape yenboken yaperken emne won yam, eme ta pane tame eteri akek yan wurin akeken pelawom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Apeilake ere tatame emne late wurim. Ere lam, tame wuri ere kerap yenbo beke wolen si. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lam, ere erne etep wom. Ei, ne a ate yawo tame? Ne beke nenye, eke ne kerap yenbo beke wole? Etep wom, ete tame ere erne tuma awosein beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Etep temke, apeilake ere yaku kerebe tame emne wom, eme ete tame erne keresukun eri letken tewoken bogun eme erne kom geinik seitpite wurim. Seitpite wurim, apeilake ere ep wom. Ere kerneirik temente. Ere mus eisau mette, ere taye piten ker wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Gwote tuma eri somo ere gwo. God ere tatame nogwape emne won yabe. Won yabe, nogwape eme beke ya. God eter kenem tatame etemwou eme wurare wurare yate. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisi tame eme epke abom. Nema Jisas erne tuma wolate, ere kap nemne tuma yaperke awosein wote nenbe o? Ere nemne tuma yaper awosein wote, nema erne keresukun ake yaperke won wurte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Etep abomke, eme etemri tame kau Herot eri wakse kau emne Jisas eterke won yim. Yim, eme Jisas erne etep wolam. Tuma wusoube tame, ne tuma beke yikwokwo. God eri tuma ne tatame emne wusoube, ne noubwai wusoube. Kau tuma ne beke beras. Ne tatame emne beke ak. Akei tatame emne ne wule wurisubu nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ne nemne wusoute. Keryen Sisar ere akeite kantriri tame, ere Rom tame. Ere nemne kom panen siten. Sisar ere nemne takis kel raste wobe. Kiyi Moses ere nemne wom, nema God erne wos newote. Nema mapeke tete? Nema Sisar eterne newote o nema God eterwoune newote? Ne mapeke abobe? ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Etep womke, ere emri selpap lam, eme epke abom. Ere kap nemne tuma yaper sein wote o? Etep lam, ere emne etep wom. Kem tuma yikwokwobe tame. Beke kem ane seilabe? ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis rasbe kel wuri kem ane peterate. Eme erne kel wuri peteram, ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ere kel peten lan etep wom. Gwo kel ere tame eri wouken basem sigken tetan. Kap, e eikeri wouken eikeri sigken? ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Eme awosein etep wom. E Romri Keryen Sisar eteri wouken eteri sigken. Ere emne etep wom. Kem yenboke woye. Sisar eri wos kem Sisar erne newote. God eri wos kem God eterne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Eme eri tuma metem, eme wouken aken erne tuma sene beke wola, eme wayen teten sene me yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadyusi tame eme etep wobetem. Sa tatame eme yuri sene beke kip wayen yi. Etep wobetem, etemri tame kau eme Jisas erne yan erne etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tuma wusoube tame, kiyi Moses ere etep bas rasem. Tame ere ta panete, sene ere yenken berai, ere satek, eri mase ere wane tene sene panen, ek yen sete. Yen sete, ete yen, e lake eteri yen. Moses ere etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kiyi gwo komke temenem tame eri yen eme ep yekwo let ep yekwo let bor pes kei (7-pela) temenem. Mase tobo yen ere ta panem, epe yen beke se. Berai. Ere bepou me sam. Samke, mase ere eri wane tene panem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Panem, epe yen beke se. Berai. Ere sam. Mase eme etepwou etepwou tebetem. Eme wane tene panebetem, yen beke wuri se, eme akei bepou me saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yuri ete ta teken sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kem wobe. Yuri sa tatame eme sene wayen yite. Ete yabel kiyi akei lakemase eme tene panem, kap ete ta te eikeri ta seken tete? Sadyusi eme erne etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas ere awosein etep wom. Kem porere yenbo berai. God eteri bas rasem tuma, eteri mure kem noub beke la, epkap kem porere yenbo berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yuri sa tatame eme sene wayen yite, tame eme sene ta beke kip pane, ta eme sene tame beke kip nar. Eme God eri kom tamekap tete, eme ta sene beke kip pane. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sa tame eme sene wayen yite tuma an sene wote. God ere keremne won bas rasem tuma kem kap lam, o kem beke la? God ere Moses erne etep womke, ere eke bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","An Abraham eteri Keryen God, an Aisak eteri Keryen God, an Jekop eteri Keryen God. Kiyi God ere etep wom, Moses ere etep bas rasem. Ete tame eme kiyi sam, sene etemri wou eme God eterken tetan, God ere etep wom. Eke nema metten. God ere kelpe tatame etemri God. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Etep womke, tatame eme metem, eme wouken akem. Eri tuma e yenbowai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sadyusi tame eme Jisas eri wom tuma awosein beke wo, Farisi tame eme etep metem, eme yan etemken wurisubuk sim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sin, emri tame wuri ere Moses eri bas rasem wule tuma wusoubetem tame, eme erne etep wom. Ne yin Jisas erne tuma wuri wolate. Ere kap tuma yaper awosein wote o? Etep womke, ere yin Jisas erne etep wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tuma wusoube tame, Moses eri bas rasem wule eme nogwapewai. Eke be wule ere eisauwai? Ne ane wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas ere sene etep wom. Wule eisau ere gwo. God ere keremri keryen. Kem eterne kenawaike abote. Keremri wusom, porere, selpap, akei kem erne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ete wule eisauwai. Akeite wule eme nebule. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wule wurinabu ere etepwou. Ere gwopkap. Kerem maime abobekap, kem akeite tatame emne etepke kir abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kiyi Moses ere tuma nogwape bas rasem. Kiyi temenem tuma wusoubetem tame eme kir eme tuma nogwape bas rasem. Ari woye tuma pes e kiyi bas rasem tuma eteri somo. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi tame eme som wurisubuk simenem, Jisas ere emne wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","God eri yaku newom tame, Juda tatame emne kobo late tame, Krais eter, kem erne mapeke abobe? Ere eikeri nan tete? Eme awosein etep wom. Ere Devit eteri nan tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisas ere wom. Kiyi Krais ere nowselke mak yamenem, God Eri Wou ere Devit erne gulelem, Devit ere Krais eterne Aneyen won etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Keryen God ere areri Aneyen erne etep wom. Ne Aneyen, ne ari ya piseit yekwok site. Yuri an wote, ne neri peiktame emne teitkwunte. Ne emne panen site nenbe. Etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit eter ere Krais erne Aneyen wom. Kem etepke wobe. Krais ere kiyi beke te. Ere Devit eteri nan tete. An wobe, e seken berai. Devit ere Krais erne Aneyen wom, mapeke ere Devit eteri nanyen tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Etep womke, eri wometem tuma eme tuma awosein kuyese beke wo. Ete yabel eme erne sene womette me akem, yuri eme erne tuma wuri sene beke womet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisas ere eri anepoi tameken akeite tatame nogwapeken emne tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ere etep wom. Farisi tameken Moses eri wule tuma wusoube tameken eme Moses eri wom tuma somo metten, eme wosoube. Eke etemri tuma kem mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Emri wobe tumakap kem etep tobote. Emri tobobe wulekap kem mane tobote. Emri wule kem mane pette. Emri wobe tumakap e yenbo. Emri tebekap eteke yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eme tatame emne etep wobe. Nemri tebekap kem etepwou tete. Etep wobe, tatame eme etemri tebekap tete, eke eme yaku eisau kerebe. Farisi eme etep labe, eme emne pap beke yewon, emne kobo beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Emri tebekap eme etep abobe. Tatame eme nemri tebekap late. Etep abobe, eke eme geinik nenbe. God eri bas rasem tuma eme ayerke yewon mokwok peiken sewurbe, tatame eme lan etep abobe. Eme tame yenbo. Farisi eme sene etep abobe. Tatame eme nemne late. Etepke abobe, eke eme kerap yenbowai wolebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Eme God eri akek wurbe, eme abobe, eme apeilake etemri wolbayek site. Eme awos eisau ate, eme abobe, eme apeilake etemri wolbayek site. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Eme kom geinik tetebe, eme abobe, tatame eme emne pir won, emne tame yenbo wote. Eme etepke abobe. Tatame eme emne etep wote, eme tuma wusoube tame. Eme etep abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kem ari anepoi tame, kem etepkap mane nente. Kem akei lakemasekap, eke kemri tame wuri eterne tuma wusoube tame mane wote. Tame wurisubu ere keremne tuma wusoube tame seken. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Gwo nowselri tame emne mane apei seken mane wote. Kem Apei wuriwou tetan. Ere Hevenke tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kemri tame wuri erne kem aneyen mane wote. Kemri Aneyen wurisubu tetan. Ere Krais. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kemri tame eme sig eisau pette abote, eme akeite tatame emri yaku kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tame eme etemri sig maime eisau wote, God ere ete tame emri sig nebule wote. Tame eme etemri sig maime teitkwunte, ete tame emne God ere emri sig eisau wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kem Moses eri wule wusoube tameken Farisi tameken kem tuma yenboke wobe, kemri nenbe wule e yaper. Tatame nogwape eme God eter panen siten komke yite abobe. Eme wurte nenbe, kem emri kelu tukbe. Kerem, kem etek beke kip yi. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Moses eri wule wusoube tameken Farisi tameken, yuri kem yaper tete nenbe. Kem tuma yikwokwobe tame. Kem wane ta etemne tuma yikwokwon etemri wos kem sirke petbe. Sene kem keremri wule yaper beraste abobe, kem God eri akek wurin, eterken tuma eisau namdebe. Kem etep tebe, kem abobe. Tatame eme nemne tame yenbo wote. Kem etepkap tebe, God ere kemne yaperwai nente nenbe.) ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Moses eri wule wusoube tameken Farisi tameken, yuri kem yaper tete nenbe. Kemri tumaken kemri wuleken epe kenakena. Kem kemri wule sete tame emne sopbe. Kem gene genek yin sopbe. Kem lan petbe, ete tame eme kemri wule sebe, emri yaper nenbekap e kemri yaper nenbekap tewo pes teitkwunbe. Keremken etemken kem ker tetan komke yite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Moses eri wule wusoube tameken Farisi tameken, kem le si tamekap, tatame emne kelu kuyese mapeke peterate. Yuri kem yaper tete nenbe. Kem etep wobe. Tame eme God eri ake tame kupa takbe, eme bepou me takbe. Eme woye wos nema beke nen, e tuma berai. Kem tame kupa takbe, kem God eri akek tetan golke nenem ou eri sigke takbe, kem wobe. E seken. Etek woye wos nema nente. Nema beke nen, eme nemne tuma wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kem etep wobe, an kemne wobe. Kem worisubu tamekap. Kem le si tamekap. God eri akeken eri akek rasten golken pespes epe wos eisau woswou. Wuri ere akeite erne beke teitkwun. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kem etep wobe. Nema tame kupa takbe, nema God eterne kwar pebe tiy eri sig nema takbe. Etep takbe, nema bepou me takbe. God eterne newon kwar pebe tiyke rasten wos, nema eterne tame kupa takte, e sekenwai tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kem etep wobe, kem porereken berai. Kem le si tamekap. God erne kwar pebe tiyken kwar pebe wosken epe kir. Wuri ere wuri erne beke teitkwun. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tame eme God erne kwar pebe tiy eri sig tame kupa takbe, eme ete tiyke rasten wos eri sig kir takbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Keryen God ere eteri ake eisauke tetan. Tame eme eteri ake eisau eri sig tame kupa takbe, ere God eteri sig kir takbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","God ere Hevenke tetan wolbaye eisau etek siten, eke tame eme Heven eri sig tame kupa takbe, eke ete tame eme God eri wolbayeri sigken God eri sig etep kir takbe. Kem God eri sig tame kupa takbe, e yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Moses eri wule wusoube tameken Farisi tameken, yuri kem yaper tete nenbe. Kemri tumaken kemri wuleken epe kenakena. God eri wom tuma kem akei beke tobo. Kemri petbe wos kem obo ep yekwo let ep yekwo let pekabe, obo wuri kem God erne newobe. Wos nebulewai kem God erne kir newobe. Etep tebe, wule eisau kem beke nen. Kem tatame emne kobo beke la, emne pap beke yewo, emne yenbo beke nen. Kemri petbe wos kem akei pekate, God erne wuri newote, e yenbo. Ete wule kem mane mesginte. Ari woye wos eisau kem kir nente. Kem tatame emne pap yewote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kem le si tame, kem akeite tame erne kelu kuyese mapeke peterate. Wule nebule kem tobobe. Wule eisau kem beke tobo. Kem ok abe, kem keskes nebule etek labe, kem peten sepitbe. Kwayebwagu eisau kem beke la, kem etep okken kir abe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Moses eri wule wusoube tameken Farisi tameken, yuri kem yaper tete nenbe. Kem ware ok keyabe, kem ware eliwou keyabe. Warek yewoten wos e sirke petbe wulekap, kemri porerek tobobe wule e etepkap. Kem wule nebule nenbe, tatame eme lan etep wobe. Eme tame yenbo. Etep wobe, kemri porere yaper tetan, kem wule eisau kuyese beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi tame, kem le si tamekap. Kem ware mei keyate, ware eli ere kir yenbo tete. Kem porere yenbo pette, kem wule yenboken wule eisauken kem kuyese tobote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Moses eri wule wusoube tameken Farisi tameken, yuri kem yaper tete nenbe. Kemri tumaken kemri wuleken epe kenakena. Kem tame sele meikap. Sele mei eli kem wolebe, tatame eme le yenbo labe. Sele mei puri sam tame etemri kupa etek tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kem etepke tetan, tatame eme kemri nenbekap labe, eme etep wobe. Eme tame yenbo. Eme beke la, kemri porere e yaper. Kem tuma yikwokwobe tame, kem wule yaper nenbe. Eme etep beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Moses eri wule wusoube tameken Farisi tameken, yuri kem yaper tete nenbe. Kemri tumaken kemri wuleken epe kenakena. Kiyi temenem tuma wusoubetem tame emne rasem sele mei kem ake eisau etek kerebe. Emri kerebetem yaku kem som abobe, kem etep abon nenbe. Kiyi temenem tame yenbo emne rasem sele mei kem emne abon, emri sele mei kem wolebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kem etep wobe. Nemri yeiwarege etem temenem yabel ete yabel nema tuma wusoubetem tame emne beke pauk pe. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","God eri kiyi temenem tuma wusoubetem tame emne tatame eme emne pen sabetem. Ete tatame eme keremri yeiwarege. Kem etep wobe. Yeiwarege eme tuma wusoubetem tame emne pen sam. Etep wobe. Kerem, kem keremri yeiwarege etemkap. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Emri nenbetem wule yaper kem etep som tobobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kem sopo yaperkap. Yuri God ere kemne keresukun ker tetan komke seitte nenbe. Kem mapeke ame? Ere kemne keresukte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","An kemne wobe. Aren wotek, ari tuma wusoube tameken porereken tameken God eteri kiyi tuma wusoubetem tameken etem eme kemne yan late. Etemri kau kem emne pen sate. Kau kem emne me kwuran etek kwane sate. Kau kem emne God eri akek panen yin emne etek kep selemal pewakerte nenbe. Kau kem emne kom komke lelete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kem etep tete nenbe, eke God ere kemne awosein yaper nente. Kiyi Kein ere eri mase, Abel, erne pen sam. Sene keremri yeiwarege eme God eri tuma wusoubetem, tame emne pen sam. Yuri eme Berekia eri yen, Sekaraia, erne pen sam. Ere God eteri ake ep yekwo God erne kwar pebe tiy ep yekwo eme erne borborke pen sam. Etek sam tame eme tame yenbo, eke God ere kemne awosein pete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","An kemne sekenke wobe. Gwopte tetan tame emne God ere emne yaper awosein nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas ere etep womke, ere Jerusalem kom lan etep wom. O Jerusalem komri tatame, kem God eri kiyi temenem tuma wusoubetem tame emne pen sam. God eri won yam tame emne kem pen sate won, eke kem emne pape seitim. Tewo nogwape an kemne pap yewote wobe. Kwokwo nawo te teri yen wopeten tipe kulke wurbekap, an kemne noub nente wom. Nente nenem, kem mo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Metye. Yuri tatame eme Jerusalem komri ake akei berayewote nenbe, tatame eme etek sene beke kip te. Ete kom e kom sub tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kem ane sene beke kip la. Yuri kem etep wote. God erne won yam tame God ere erne yenbowai nente. Kem etep wotek, kem ane sene late. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas ere God eri ake eisauke worabetem, eri anepoi eme erne yan lan erne ake peteran etep wom. Gwo ake, God eri ake e ake yenbowai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jisas ere awosein etep wom. Ye, ete ake yenbo. An kemne wobe. Gwote ake eme kerem, eme pape peten tirin yaubetem. Yuri ete pape eme akeite pape luke beke kip te. Eme akei beran petewarte nenbe. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas ere Oliv kowke yawon etek simenemke, eri anepoi tame etemwou eme yan erne etep wometem. Ne woye, tame eme God eri ake eisau berate. Be yabelke eme etep nente? Be woske kiyi tetek nema abote, neri yate nenbe yabelken nowsel yaper tete yabelken mekin mekinye? Eme etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ere emne awosein etep wom. Kem eisa eisa. Tame kau eme kemne mane tuma yikwokwote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yuri tame nogwape eme yate, eme areri sigke yan wote. Eme kemne yikwokwon etep wote. An Krais, an God eter won yam tame. Tatame nogwape eme emri yikwokwobe tuma kenawaike mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kiyi kem late, tatame nogwape eme ei naite nenbe. Mekin tetan tatame, genek tetan tatame eme ei naite. Kem mette, eme ei naibe, kem mane ep abo ep abote. Nowsel ere yaper tete yabel ere yurik tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kom wuriri tatame eme akeite komri tatame etemken ei naite. Apeilake wuri eri wakse eme akeite apeilake eri wakseken eme ei etep naite. Kom nogwape eme nakwoi meig sin, akei saiwote. Nogwape nogwape komke nina yate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ari woye wos e ta te yen warwite tasen metbe muskap. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Sene tatame eme kemne keresukte, eme kemne akeite tame etemke newote, eme kemne paku pen, kemne pen sate nenbe. Eme mette, kem ane kenawaike abobe, eke eme kemne pap wayete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ete yabel ane kenawaike abobe tatame nogwape eme ane mesginin magel taite nenbe. Tatame eme etemri wakse kau emne mowai won tuma namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ete yabel nogwape tame eme yan yikwokwo tuma etep wote. An God eteri tuma wusoube tame. Etep wote, tatame nogwape eme etemri yikwokwobe tuma kenawaike mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ete yabel tatame eme wule yaper nogwape nente. Etep tete, eme pap yewobe wule mesginte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yaper tete yabel ane som abobe tatame eme noub som temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","God eri tuma yenbo, ete yabelke eme ete tuma kom komke wusowun sewurte. Nogwape nowselri tatame eme kiyi metmentek, yuri nowsel ere yaper tete yabel ek tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","God eri kiyi temenem tuma wusoubetem tame, eri sig Daniel, ere tuma etepke bas rasem. Tame wuri ere wos yaperwai God eri akek raste. Raste, ete ake ere yaper tete nenbe. Ere etep bas rasem. Kem gwote siglou labe, tuma somo kem noub abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kem eteri etek bas rasem wos latek, kem Judia tatame, kem amen kowke yin tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tame ere ake maklek ege simente, ere ete wos late, ere agetage amen yite. Ere eri akek tetan wosbas ere mane wurin pette. Ere epitage kuyese beke kip pet, eke ere mane wurin pette, ere yaper tete wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Eike tame ere nowke temente, ere ete wos late, ere agetage amen yite. Ere eri akek mane wurin eri wosbas ere mane pette. Eri wosbas ere epitage kuyese beke kip pet, eke ere mane wurin pette, ere yaper tete wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ete yabel an yenken ta o yen muk newon abe ta emne kobo late nenbe. Eme kuyese agetage beke kip ame. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mou tite yabelke ete yaper wos ere tete wote, kem mapeke amete? Juda, kem ep wobe. Ege si yabel nema akeite kom beke yi. Kem etep wobe. Ege si yabelke yaper wos tete, kem mapeke amete? Kem God erne etep womette. Ete wos ere mou tite yabelke mane tete, ege si yabelke yaper wos ere mane tete. Kem erne etep womette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ete yabel yaper wos nogwape tete nenbe. Kiyi epkap yaper wos beke te. Kiyisape God ere nowsel seikin yan gwopte kir, epkap yaper wos kiyi etep beke te. Yaper wos omote, sene epkap beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ete yabel God ere borke regte beke wo, akeite tatame eme pauk saiwote wom. God ere eter kenem tatame emne abobe, eke yuri ere ete yabel borke regte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ete yabel tatame eme kemne etep wote. Ek la. Krais ere gwo. Eme etep wotek, emri tuma kem mane kenawaike mette. Emri wote tuma e me yikwokwobe tuma. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tame nogwape eme yan kemne tuma yikwokwon etep wote. An Krais. An God eteri tuma wusoube tame. Eme etep wote. Eme yate, eme rigrabe nente. E tuma yikwokwobe tame eme rigrabe nente, eme etep abote. An rigrabe nente, God erne kenawaike abobe tatame eme ari tuma kenawaike mette. Etep abote, God erne kenawaike abobe tatame eme emri wote tuma beke kip met. God erne kenawaike beke abo tatame eme emri tuma wan wurik mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yuri tete wos an kemne kiyi wusouye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tatame eme kemne me yikwokwobe tuma eme etep wote. Krais ere tameken berai emik tetan. Eme etep wote, kem mana yin late. Kau eme etep wote. Krais ere ete ake purik berasten. Etep wote, kem emri tuma mane mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","An Tatame Etemne Lan Yeirim Tame. Yuri an sene yate, keremken akei nowselri tatameken kem ane late. Kem pelale labekap kem etep ane late. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jisas ere emne sekur sakur tuma sene etep wom. A kupa tetan emi kware eme agetage etek yabe. Jisas ere ep wom. Etepkap, Krais ere agetage yan tatame yaper emne tuma namdete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ete yabel eri yaper tete wos ere omotek, agetagewai yabelken lupken epe kerneirikap tete, sow eme nelke yeirkwutete nenbe. Nina ere nelke yate, nelri wos eme bereibereyin yesen kenakena yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Etep tetek, kem nelke late, akei gwote nowselri tatame eme aken me kerate. Sene an Tatame Etemne Lan Yeirim Tame, an sene ek yate. An nel geike yate. An mureken tamekap, keryenkap yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sene God eri komri tame ere pu tetek, an God eri kom tame emne kom komke won yin weiwar, yawarke emne won yite, God eri kiyi wom tatame emne eme panen yan wurisubuke site. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kem kwar kepken mok walkuken abote. Gub pan yan buyebe, kem etep wobe. Nabe tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ari kiyi woye tuma e etepkap. Ari woye tumakap etep tete, kem abote. Ari yate nenbe yabel mekin mekinye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","An kemne sekenke wobe. Gwote tetan tatame kau eme mak saiwomente, ari woye wos eme kir late nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","An kemne wobe. Nelken selken omote nenbe. Ari tumawou ere som temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ari yate nenbe yabel eike tame beke wuri met. God eri kom tame eme beke met. Aren, an God Eteri Yen, an etepwou beke met. Ari Apei God eterwou ere metten. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kiyi Noa eri temenem yabel tatame emri nenbetemkap, ari sene yate nenbe yabel tatame eme etepke sene tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kiyi ok eisau mak yamenem, ete yabel tatame eme God erne som beke abo. Eme selri woswou abobetem, eme a abetem, eme ta panebetem, etepwou tebetem. Eme God erne beke abo. Eme etep tebetem, sene Noa ere pere eisau wuri nenem, ere etek wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Etek temenem tatame eme yuri ok eisau geite tuma eme beke met. Yurik ok eisau geiyen yan, tatame emne akei okke an saiwom. An Tatame Etemne Lan Yeirim Tame, ari sene yate yabel tatame eme selri woswou abote, eme a ate, ta panete, etepwou abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ete yabel tame pes epe etep now yaku kerebetete, an yatek, wuri an erne wopette, wuri an erne etek mesginte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ta pes epe etep awos nenbetete, an yatek, wuri an tene wopette, wuri an tene etek mesginte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Etepkap, kem eisa eisa. Kap be yabel Aneyen ere yate? Kem beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kem abote. Ake maime ere mette, sir petbe tame ere yate. Etep mette, ere beke kip tukna. Sir pet tame ere yate, ake maime ere erne keresukte, ete tame ere eri wos sirke beke kip pet. Epkap ari sene yate yabel kem beke met. Eke kem noub kowun lakerebet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Etepkap kem ane kenawaike som abobet. An Tatame Etemne Lan Yeirim Tame. Kem etep mane abote. Gwopte ere beke kip ya. An kemne wobe, ete yabel an yate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Porereken yaku yenbo kerebe tame eme gwopkapke tete. Tame eri apeilake ere erne etep wote. Ne ari yaku kerebe tame emne lakerete. Ne emne awosken tokwoken emne newote. Etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yaku lakerebe tame ere etep tete, apeilake ere yin sene yan lan etep wote. Ne ari wom yaku yenbo kereye. Etep wote, yaku lakerebe tame ere metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Apeilake ere yaku lakerebe tame eri yaku yenbo late, ere erne etep wote. Ari sene yate yabel ne etep abon yaku yenbo kerem, eke an nene yaku yenbo newote, ari wosbas nogwape ne lakerete. Etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yaku yaper kerebe tame eme gwopke tebe. Ete tame ere etep abote. Ari apeilake ere yin sene epi beke kip ya. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Etep abote, ere eri kir yaku kerebe tame sip emne paku pebetete. Sene ere yin ok yaper abe tame etemken sin okken awosken etep abetete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ete tame ere eri apeilake ere yate yabel beke abo, apeilake ere ek yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ere sene yate, ere erne yaper nente nenbe. Ere erne won yin tuma yikwokwobe tame etemken tete nenbe. Eme etek tete, eme mus metbetete, eme kenake keran, eme awowo ker wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas ere etep wom. God ere kom panen site yabel ere gwopkap. Munguta ep yekwo let ep yekwo let eme emri lam peten sen ek yim. Tame wuri ere ta panete yate nenbetem, eme erne lan panen yate yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ta ep yekwo let eme porereken temenem, akeite ta ep yekwo let eme porereken berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Porereken berai ta eme lamwou sen yim. Eme ok kir beke sen yi. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Porereken ta eme lamken okken sen ek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ta panete tame ere agetage beke ya, ete ta eme koulawoyim, eme le meten tuknam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Neir borke tame wuri ere etepke tem. Ta panete tame ere yabe. Kem erne yin lan erne panen yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Etep metemke, ete ta eme wayen sin emri lam yarem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Porere berai ta eme porereken ta emne etep wom. Kemri ok tep kem nemne kera newote. Nemri lam okken berai, lam saye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Eme awosein etep wom. Berai. Gwo ok e nogwape berai. Kem stuak yin kena tukte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Eme ok tukte yimenemke, ta panete tame ere yam. Ta ep yekwo let eme erne koumenem, eme erne panen akek wurim, ta neisbe a ate wurim. Wurin, eme eru kit kerem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Yuri ok tukte yim ta eme sene yan etep wom. Aneyen, ne nemne eru latte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ere emne awosein wometem. Kem eike? An kemne beke la. An tuma beke yikwokwo. An seken wobe. An kemne beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Etep womke, Jisas ere eri anepoi tame emne lan etep wom. Ari sene yate yabel kem beke kip met, eke kem eisa eisa. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","God ere kom panen site yabel ere gwopkap. Apeilake wuri ere eri kom mesginin genek yim. Yite nenbetem, ere eri yaku kerebe tame emne won yan emne yaku newom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Newon, ere emri yaku kerebekap kiyi abon emne yaku ek newom. Tame wuri erne ere 500 kina newon etep wom. Gwo kel ne yaku yenbo kerete. Tame wuri erne ere 200 kina newon etepwou wom. Tame wuri erne ere 100 kina newon etepwou wom. Etep ten ere ek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yimke, 500 kina petem tame ere yin kel pet yaku kerem, ere sene kel warkeken peten rasem. Rasem, eri semenem kel e 1000 kina. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","200 kina petem tame eter kir ere kel pet yaku keren sene ere kel warkeken sene rasen ere 200 kina petem. Petem, eri semenem kel e 400 kina. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","100 kina petem tame ere kel pet yaku beke kere. Ere selke mei peren kel etek berasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nabe nogwape temke, yuri apeilake ere sene yamke, ere yaku kerebetem tame emri yaku late wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","500 kina petem tame ere yan etep wom. Apeilake, kiyi ne ane 500 kina newom. An kel pet yaku kerem, an kel warkeken 500 kina peten bogum. Etep womke, ere apeilake erne eri semenem 1000 kina etep newom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Apeilake ere erne etep wom. Ne yaku yenbo kerem. Ne yaku kerebe tame yenbo. Nene newom kel ne yaku noub kerem, yuri an nene wos nogwape lakerete tame won tete. Ne ari akek tete, nema etep metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Sene 200 kina petem tame ere yan etep wom. Apeilake, kiyi ne ane 200 kina newom, an kel pet yaku kerem, an kel warkeken 200 kina sene peten bogum. Gwo 400 kina e nereri. Ne pet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Apeilake ere etep wom. Ne yaku yenbo kerem. Ne yaku kerebe tame yenbo. Kel nebule ne yaku noub kerem, etepkap yuri an nene wos nogwape newon lakerete. Ne ari akek temente, nema etep metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","100 kina petem tame ere yan etep wom. Apeilake, ne agegera tame, eke an nene akbe. Akeite tame ere now awos nanekwobe, ne papke abok yin peten abe. Akeite tame ere me supa petbe, ne papke abon peten abe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","An nene akem, neri newom kel an selke mei peren rasem. Neri newom 100 kina gwo. Ne sene pet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Apeilake ere awosein etep wom. Ne yaku kerebe tame yaper. Ne yaku bulwora tame. Ari nenbekap ne lam. Ne kiyi woye. An ete tameri nowri awos peten abe. An ete tame eri petbe me supa peten abe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ari kel ne kel rasbe akek raste wom, kel ere sene nogwape tete wom. Etep tete wom, an sene yan ari kel warkeken sene pette wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Erne newom kel kem sene peten 1000 kina seten tame erne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wosken tame, porereken tame emne an ete kupak sene newote, eme nogwape sete. Tame eme be wos, porere wuri beke te, emri temente wos nebule o porere nebule an sene pette. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ete yaku kerebe tame yaper erne kem lelen ere ep yekwo wur kerneirik yin te. Ere mus mette, ere keran ker wote. Apeilake ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisas ere emne wom. An Tatame Etemne Lan Yeirim Tame. Yuri an keryenkap sene yate. An yatek, God eter, eri kom tame etem, eme ari sig eisau wote. An yatek, an God eri kom tame emne panen yate, an keryen eteri wolbayek site, tatame emne tuma namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sitek, akei nowselri tatame eme yan wurisubu emik site, an emne seigte, emne pekan obo peske tete. Sipsip lakerebe tame eme sipsip emne kena yite wobe, meme emne kena yite wobekap, an tatame emne etepwou nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","An sipsip emne areri pi seit yekwok won tetete, meme emne areri let gwaime yekwok won tetete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Etep tete, pi seitike tetemente tatame emne an etep wote. An Keryen. Kem tatame yenbo. Ari Apei ere kemne yenbo nenem, eke kem arenken yate. God ere kemne kiyi newote wom wos yenbo kem yan pette. Kiyisape God ere nowsel seikim, ere ete wos ere yen etemne newote wom, ete wos ere eteri komke tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kem ane yenbo nenem, eke Apei ere etep tem. Kiyi an kwoi sabetem, kem ane awos newon abetem. An kelpok sopbetem, kem ane kelpok newon abetem. An ek ya tamekap temenem, kem ane kemri akek panen yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","An tame oubken berai, kem ane tame oub newobetem. An kapoyi keibetem, kem ane noub eyarbetem. An ake yaperke temenem, kem ane yan labetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","An emne etep wotek, tatame yenbo eme awosein etep wote. Aneyen, nema nene mapkapke lan ne kwoi sabeten nema nene awos newon am? Nema nene mapkapke lan kelpok sopbetem, nene newon am? ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nema nene makapke lan ne ek ya tamekap temenem, nene neremri akek panen yim? Nema nene makapke lan ne tame oubken berai, nene tame oub newom? ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nema nene makapke lan ne kapoyi keibetem, nene eyarem? Nema nene makapke lan ne ake yaperke temenem, nema nene yan lam? Nema nene etepkap beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Eme etep wote, an Keryen, an emne awosein etep wote. An kemne wobe. Ari woyekap ari geisimase emne kem etepke nenbetem. Ane kenawaike abobe sigken berai tatame kem emne etep eyarbetem. Kem emne noub eyarbetem, kem ane kir noub eyarbetem. An emne etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Sene an ari let gwaime yekwok tetemente tatame emne etep wote. Kem ane mesginin yite. God ere kemne magel taibe. Kem ker tetan komke yite. E keremri kom. Ete ker ere beke kip sa. Kiyisape God ere ete kom seikin etep wom. Satan eter, eri wakseken etem, eme etek temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bepou berai. Kiyi an kwoi sabetem, kem ane awos beke newon a. An kelpok sopbetem, kem ane kelpok beke newon a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","An ek ya tamekap temenem, kem ane kemri akek beke panen yi. An tame oub berai, kem ane tame oub beke newo. An yaper metbetem, kem ane beke eyar. An ake yaperke temenem, kem ane beke yan la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Eme awosein etep wote. Aneyen, makapke nema nene lam, ne kwoi sam, kelpok sopem? Nema nene beke la. Makapke nema lam, ne ek ya tamekap temenem? Nema beke la. Makapke nema lam, ne tame oub berai? Makapke nema lam, ne yaper metem? Makapke nema lam, ne ake yaperke temenem? Nema nene beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","An Keryen, an emne awosein etep wote. Kem ari yen nebule, ari geisimase emne kobo beke la, kem arene kir kobo beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Etep wotek, ete tatame eme kom yaperke yin temente. Etek temente, eme mus som mette. Tatame yenbo eme kom yenbok som noub temente. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas ere ete tuma akei won omomke, ere eri anepoi tame emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Kem ek met. Yabel peswou tete, awos ate yabel ek tete nenbe. Ete awos nema etep wobe. Pasova. An Tatame Etemne Lan Yeirim Tame, ete yabel eme ane keresukun me kwuran kwane keren an sate. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","God eri ake eisauke yaku kerebetem tame etemri apeilakeken Juda etemri apeilakeken eme wurik sin tuma namdem. God eri akek yaku kerebetem tame emri apeilake eri sig Kaiafas. Eme eteri akek sin namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Emri namdem tuma ere gwo. Eme Jisas erne elen berasen yin erne keresukun erne pen sate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Eme etep wom. Pasova awos ate nenbe yabel nema erne mane etek keresukte. Tatame nogwape eme awos ate yate nenbe. Nema erne ete yabel keresukte, eme etep late, eme mo won eiken naite wurken. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas ere Betani komke temenem, ere kiyi numa pemenem tame, Saimon, eteri akek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Etek temenem, ta wuri te papek nenem gin sen yam. Gin e kwar yenbo, tokwo eisauke tukem kwar yewomenem. Yan, Jisas ere awos tiyke sin abetem, te yan kwar eteri tarek sirem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Sirem, eri anepoi tame eme etep lam, eme pap kera wayen etep wom. Beke ete kwar te bepou me sirpitiye? ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ete kwar e tokwo eisauke tukem. Ete kwar te kelken natokwo kerete woye, kel te wosbasken berai tatame emne newote woye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas ere emri tuma metem, ere emne etep wom. Kem beke ete ta tene etepkap kuken wobe? Te ane wos yenboke nenye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wosbasken berai tame eme keremken som temente, kem emne tewo tewok kuyese yenbo nenbetete. Aren an keremken som beke kip te, eke te ane yenbo nenye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tame sabe wule, kem tame kupa kwar pebe. An mak saten, gwote ta te ete kwar ari wuske sirye. Te eteke peteraye, an sate kerake tetan. Kem ane sele meike raste nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","God eri tuma yenbo eme nowsel nogwapek yin wusoute, gwote ta teri nenyekap eme kir wusoute. Eke eme tene abote. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ete yabel anepoi tame emri wuri, eri sig Judas Iskariot, ere yin God eri akek yaku kerebetem tame etemken tuma namde rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ere emne etep wom. Kem Jisas erne keresukte wom. An kemne Jisas erne keresukte kelu peterate, kem ane be woske newote? Etep wometem, eme erne kel silva nogwape (30-pela) newom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Newon, ere yin Jisas erne keresukte kelu sopte yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Taresibe yabel, tatame eme yisken berai geil abe, ete yabel Jisas eri anepoi tame eme yan erne etep wom. Pasova awos nema mak yin ate? ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ere emne etep wom. Kem yin kom sagke wurin tame wuri erne yin late. Kem erne etep wote. Tuma wusoube tame ere etep woye. Ari yabel mekin mekinye. An ari anepoi tame etemken nema Pasova awos ate, nema neri akek ate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Anepoi tame eme eri womkap nenem, eme etek yin Pasova awos nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Perpe Jisas ere yan anepoi tame etemken sin abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sin abetem, Jisas ere emne etep wom. Kemri tame wuri ere ane yena tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Etep wom, anepoi tame eme pap yaper ten ep abo ep abom. Eme wurare wurare erne etep wometem. Aneyen, kap aren? ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ere awosein etep wom. Eike arenken nesa ware mei let peske warte, ete tame eter ere ane yena tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","God eri bas rasem siglou e arene etep wom. Tatame Etemne Lan Yeirim Tame eterne eme pen sate nenbe. Etep wom. Tame wuri ere ane yena tete nenbe. Kobo labe, ere mus eisau mette. Nawo te erne beke pauk warwi, ere ete mus eisau beke pauk met. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas eter ere Jisas erne yena tete nenbe tame, ere erne etep wom. Tuma wusoube tame, kap ne arene wobe? Jisas ere awosein etep wom. Ye. Neri woye tuma e seken. Ere erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eme abetemke, Jisas ere geil peten God erne pir won pekayewon ere anepoi tame emne newopit pete yan etep wom. Gwo areri om. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sene ere wain ok ware wuri peten God erne pir won emne newon etep wom. Kem akei, kem gwo wain ok ate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gwo ok e areri nep. Eme ane pen sate, ari nep yeirte, e tatame emne peteran God eri namde rasem tuma e seken tete. God ere tatame nogwape emri wule yaper peten sepitte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","An kemne wobe. Wain ok an sene beke kip a. Yuri nema Apei eri panen siten komke temente, an wain ok yenbo keremken sene etek ate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Etep womke, eme sekwo wuri lomen eme worakwuten eme Oliv kowke yin yaukwutem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas ere emne etep wom. Kiyi tuma wosoubetem tame ere God eri siglouke bas rasen etep wom. God ere sipsip lakerebe tame erne pete, sipsip eme kenakena amekirin yikwute yakwutete. Etep bas rasem, gwopte neir kem etepke tete nenbe. Kem akei, kem ane magel tayen amekirin yikwutete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","An sate, an sene wayete, an Galili yekwok kiyi taresin yite. Yuri kem ane etek yan late. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita ere etep metem, ere erne etep wom. Aren, an nene magel beke kip tayen ame. Tame nogwape eme etep tete, aren an etep beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisas ere erne etep wom. Pita, an nene sekenke wobe. Gwopte neir kwokwo mak womente, tewo mur ne ari sig berasen etep wote. An erne beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita ere awosein etep wom. An neri sig beke kip beras. An nerenken sate, e yenbo. Etep womke, akei eme etepwou kir wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas ere anepoi tameken eme Getsemanike yim. Yimenem, ere emne etep wom. Kem gwotek simen. An ep yekwok yin God erken tuma namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Etep womke, ere Sebedi eri yen pesken Pitaken emne panen eme etep yim, ere pap yaperwai meten emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ari pap yaperwai teye. Selpap ari an nenlawoiwo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Etep womke, ere ep kera yin selke keipe keipe waren tuknan Apei erne etep wom. Apei, an nene wometbe. Ne ane mapeke tete, e neri wos. An abobe, ane nente wos yaper e ane mane tete, an mus eisau beke kip met, e yenbo. Ari porerekap ne mane tobote. Ne neri porerek etepke nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ere wayen emne sene yin lam, anepoi tame eme me tuknamenem. Tuknamenem, ere emne teren Pita erne etep wom. Beke kem tuknaten? An kerake yin teye, kem ane beke sin lakere. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kem lakeren God erne etep womette, Satan ere kemne mane seilate, kem yaper mane nente. An metten, kem tuknate mo woye. Kemri selpap kem God erken tuma namdete abobe, kemri wusom lumken teye, eke kem tuknaye. Selpap ere etep nente abobe, wusom ere lumken tebe. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ere eri kiyi temenem emi ere sene etek yin Apei erken tuma sene namdem. Ere etep wom. Ari Apei, ane nente wos yaper ane kuyese beke kip mesgin, e yenbo. E nereri wos. Neri porerek ne etep nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Etep womke, ere sene yan lam, anepoi tame eme sene tuknamenem. Eme le meten eme tuknamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ere emne sene mesginin yin Apei erken sene tuma namdem. Tewo mur eter kiyi wom tumakap ere etepwou Apei erne sene wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sene won, ere tame mur emne sene yin etep wometem. Kem som tuknaten? Metye. An Tatame Etemne Lan Yeirim Tame, ane keresukun panen yite nenbe tame yaper eme mekin mekinye. Kem wayen ek la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nema emne yin late. Ane yena ten peterate tame ere mekin mekin yan teye. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas ere som wobetemke, eri anepoi tame etemri wuri, Judas eter, ere yam. Tame nogwape eme eterken yam. Eme wor paku kir setirmenem. God eteri akek yaku kere tame etemri apeilakeken Juda emri apeilakeken eme ete tame emne won yam, eme Jisas erne keresukte yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kiyi Judas ere ete tame emne etep wom. Kem late, an tame wuri erne bwoite. Ete tame erne kem keresukte. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Eme yan, Judas ere agetage yin Jisas erne pir won bwoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Bwoyim, Jisas ere erne etep wom. Tamenowu, neri nente yawo wos ne agetage nente. Etep womke, agetage eme yan erne keresukum. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Anepoi tame wuri ere Jisas erken temenem, ere eri gapaku lik peten God eri akek yaku kerebetem tame etemri apeilake eri yaku kerebetem tame erne wan gapakuk baukwunem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jisas ere lan etep wom. Ne gapaku buske sene yewote. Wor gapakuk naibe tame yuri emne wor gapakuk tan sabe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","An Apei erne kuyese womettek, ari tuma tepken ere eri komri ei nai tame nogwapewai (60 tausen) emne won yate, eme ane ei worate. An Apei erne etep beke womet. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Eme ane keresukun panen yin pen satekap kiyiri tame eme etep kiyi bas rasem. An Apei erne ane ei wora tame womette wom, emri kiyi bas rasem tuma e seken beke pauk te. Eke eme ane ei beke wora. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jisas erne keresukum tame nogwape emne ere etep wom. Kem arene pette yawo, kem wor gapaku kir sen ek yawo. Beke kem etepkap yawo? An peiktame ei taresibe tame berai. Yabel nogwape an God eteri akek wurin sin kemne tuma wusoubetem, kem ane etek kiyi pauk keresukte wom? ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kemri nenbekap kem bepou beke nen. Kiyiri tame emri bas rasemkap kem etepwou tobobe. Etep womke, eri anepoi tame eme erne mesginin amen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisas erne keresukum tame etem eme erne panen yim. God eri akek yaku kerebe tame etemri apeilake, Kaiafas, eteri akek panen yim. Moses eri wule tuma wusoube tame etem, Juda etemri apeilake etem kir eme etek wurisubuk sim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Erne panen yibetem, Pita ere emne kaike semowun Kaiafas eri akek yim. Yim, ere maklek sin nau se tame etemken etek simenem. Eme Jisas erne mapke tete nenbekap eme etepke late koumenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","God eri akek yaku kerebetem tame etemri apeilakeken apeilake etemri kaunsil tameken eme yikwokwote tuma wuri sopbetem. Eike tame ere Jisas erne tuma yikwokwote, eme Jisas erne ek pen sate. Etepkap tuma eme me sopem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tame nogwape eme yan erne tuma yikwokwom, eme tuma wurisubu beke wo. Eme akeite akeite tuma wobetem. Eke apeilake eme erne pen sate tuma somo beke wuri met. Sene tame pes epe yan etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ete tame ere kiyi etep wom. An God eteri ake eisau berayewon sene yabel murke an sene kuyese kerete. Kiyi ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","God eri ake eisauke yaku kerebetem tame emri apeilake ere wayen teten Jisas erne etep wom. Ne tuma sein beke wo? Epri woye tuma e seken o berai? ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jisas ere tuma beke wuri wo. Ere tuma rebe tem. Apeilake ere erne sene nobke etep wom. Ne nemne wote. Ne tuma yikwokwote, Hevenke teten God ere mette. Ne kap God eter won yam tame o? Kap ne God Eteri Yen o berai? Ne epe wusou. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisas ere awosein etep wom. Ye. Ete ne woye. An kemne wobe, an Tatame Etemne Lan Yeirim Tame. An gwote nowsel mesginte, kem ane beke kip la. An Hevenke yaute, an keryen ten mureken God eri let mame yekwok sitek, kem ane late. Yuri kem ane late nenbe, an nel gwanke yate. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Eme etep metemke, apeilake ere pap wayen eri tame oub ere letke keren pekan etep wom. Ere God erne tuma yaperke wobe. Eri woye tuma kem metye. Ete tuma yaperwai. Nema akeite tame emne eri yaper nenbekap sene beke kip womet, e yau. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kem mapke abobe? Nema erne beke nente? Eme erne awosein etep wom. Erne pen sa. E tuma berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Etep womke, kau eme eri bitimi sabelokwok sobobetem, kau eme erne let pakuk pebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kau eme erne wan burowon etep wom. Ne wobe, ne Krais, God ere nene won yam. Ne nemne wote, eike nene pebe? Eme erne tuma kwoyen etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ere maklek simenem, yaku kerebetem ta te yan lan erne etep wom. Ne Galili tame, Jisas, eterken sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Etep womke, tatame nogwape eme erne lek temenem, ere yikwokwon etep wom. Aren berai. Neri wobe tame an beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Etep won, Pita ere wayen yin ere makle ser eru mekinke temke, akeite ta wurinabu te erne lam, te etek simenem tame emne etep wom. Ete tame ere Nasaret komri tame Jisas eterken sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita ere etep metem, ere tame kupa taken etep wom. Neri woye tame an erne beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Etep won, kerake tem, etek tetemenem tame eme erne wom. E seken. Ne Jisas eteri anepoi tame etemri wuri. Jisas ere Galiliri tame. Neri namdebe tuma e Galili tatame etemri namdebe tumakap. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Etep womke, Pita ere tame kupa taken etep noubke wom. An kemne sekenwai wobe. An kemne tuma yikwokwote, God ere ane pete. Kemri wobe tame an erne beke met. Etep wobetem tuma tepken, kwokwo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Womke, Jisas ere Pita erne kiyi wom tuma ere sene abom. Jisas ere kiyi etep wom. Kwokwo mak womentek, tewo mur ne areri sig beraste. Etep sene abomke, ere sebera yan geinik woran kenake keram. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ei berabetem, God eri akek yaku kerebetem tame etemri apeilake etem, Juda etemri apeilake etem eme wurisubuk sim, eme Jisas erne pen sate tuma namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Namdem, eme erne kepke peiken erne apeilake Pailat eteri akek panen yim. Pailat ere akeite nowselri apeilake tame, ere sene Juda tatame etemri apeilake temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisas erne eteri peiktame emne peteram tame, Judas, ere metem, eme Jisas erne tuma namden pen sate wom. Etep metemke, ere pap yaper ten abolawoyim. Abolawoyim, eme erne newom kel silva ere peten God eri akek yaku kerebetem tame etemri apeilake, Juda tatame emri apeilake etemne sene yin etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Jisas ere wule yaper beke nen. An tame yenbo erne yena tem, aren an wule yaper nenye. Apeilake eme awosein etep wom. E neremri wos berai. E nereri wos. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Etep wom, Judas ere kel God eri akek sepit wurim. Sepit wurim, ere yin kep peten wakke tenen kerpen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","God eri ake eisauke yaku kerebetem tame etemri apeilake eme God eri akek sepit wurim kel akei peten etep wom. Gwote kel e tame pen sateke newom kel. Gwo kel nema God eri akek tetan kel nema etek kir yewote, e yaper. Nema etep tete, nema Moses eri wule yaper nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Eme etepke namdem, ete kel eme peten ou rasbetem tame etemri sel tukem. Tukem, eme etep wom. Ek ya tame eme gwo Jerusalem komke sate, nema emne ete selke raste. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","E sel e gwopte som teten. Eme sel sig etep wobe. Nep yeirim sel. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kiyi temenem tuma wusoubetem tame, Jeremaia, eter bas rasem tuma e seken tem. Ete sel eme bepou me beke tuk. Jeremaia eter bas rasemkap eke eme tukem. Ere etep bas rasem. Juda tame eme etep wom. Nema erne tukte. Nema kel silva nogwape (30-pela) peten erne tukte. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ete kel eme peten ou rasem tame etemri sel tukem. Aneyen ere ane etep nente wom. Jeremaia ere etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Eme Jisas erne apeilake eteri bitimik won tetem, apeilake ere Jisas erne etep wometem. Ne Juda etemri kom panen si keryen o? Ere awosein etep wom. Ye, ete ne woye. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sene God eri akek yaku kerebetem tame etemri apeilake, Juda etemri apeilake etem eme Jisas eterne tuma pekam. Pekam, ere emri tuma yaper metem, ere tuma rebe tem, ere awosein beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pailat ere etep lam, ere erne etep wom. Kap emri nene namdeye tuma ne beke met o? Beke neri nenem woskap ne emne awosein beke wo? ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jisas ere Pailat eri wom tuma awosein beke wo. Ere wanwouke metem. Etep tem, Pailat ere wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nabe nogwape Juda tatame eme Pasova awos abetem yabel, apeilake ere kobo labe wule nenbetem, ere komri tatame emne etep wometbetem. Ake yaperke teten tame wuri erne an komke won yite. Kap an eikene won yite? Kem ane wote. Etep wometbetemke, eme erne tame sig wobetem, ere ete tame erne komke sene won yibetem. Etep tebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ete yabel tame yaperwai ere ake yaperke temenem. Eri sig Barabas. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tatame nogwape eme wurisubuk simenem, Pailat ere emne etep wometem. An eikene won komke yite? An Barabas erne won yite, o an Jisas, eme erne Krais wobe, an eterne won yite? Kem ane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat ere etep bepou beke wo. Ere lam, Jisas ere yaper wos beke wuri nen, eme erne bepou me pap wayen erne tuma namdem. Eke ere Jisas erne won komke yite abom. Ere etep abom. Kap eme sene abolawoite, erne sene won komke yite o? Eke ere emne etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat ere tuma sin metbetem wolbayek simenemke, eri ta te erne tuma wotakepitin etep wom. Ne ete tame yenbo erne be wos mane nente. Ere yaper wos wuri beke nen. An erne nugsik laye. Laye, an pap yaperwai teye. Ta te erne etep wopitim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","God eri akek yaku kerebetem tame etemri apeilake, Juda etemri apeilake etem eme tatame nogwape emne tuma won sewurem. Eme etep wom. Kem Pailat erne etep wote. Ne Barabas erne won komke yite, Jisas eterne pen sate. Kem erne etep wote. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Sene apeilake Pailat ere emne sene wometem. An eikene won komke yite? Eme awosein etep wom. Barabas eterne. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat ere emne wometem. Jisas erne eme Krais wobe, eterne an beke nente? Eme awosein etep wom. Ne erne me kwuran erne etek kwanete. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat ere etep wom. An eri nenem wule yaper an beke wuri la. Kem ane wusoute, ere be wos yaperke wuri nenem? Etep womke, eme noubke awosein etep wom. Erne me kwuran kwanen sate. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat ere etep abom. Ari tuma eme beke met. Emri woye tuma an beke kip nen, eme eiken naite nenbe. Etep abomke, ere eri let nogwape tatame etemri bitimik ok keyan etep wom. An erne pen sate mo woye. Kem erne pen sate, e keremri woske. E areri wos berai. Kem ane ker mane wote. Eke ere etemri bitimik let ok keyam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Etek temenem tatame nogwape eme etep wom. Neri woye tuma nema metye. Eme nemne ker wote, e neremri wos. Nema beke ak. Tatame eme nemne tuma namdete, nerem, nemri yennanken nema awosein etep wote. Nerem erne pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Etep womke, Pailat ere Barabas erne komke won yim. Yim, ere ei nai tame emne etep wom. Kem Jisas erne kep sekenak wurbetete. Wurbeten, sene eme erne panen yim, eme erne mek kwuran kwanete panen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Apeilake Pailat eri ei nai tame eme Jisas erne apeilake eri akek panen wurim, ei nai tame nogwape eme yan tekukwu rasen erne lek tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Eme erne tuma yikwokwon eri tame oub lugpetem, sene eme apeilake etem warbe kerap, tame oub wolepai peten erne warruwun eme erne workwoyeken resbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sene eme kwokwo seg peten keryen emri tare selikap basen eri tarek gwurereruwum. Eme erne sene yikwokwon keryen etem sebe kwokwulkap erne wuri newom, eme erne gulke pan erne tuma workwoyeken resen etep wom. Sikile ere eteke. Ne Juda tatame etemri keryen. Nema nene eisau wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eme etep won, eme erne sabelokwo kuspayen eme erne newom kwokwul eme sene peten erne maime tarek apekem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Apekem, eme erne tuma yaper wo mesginin eme wolepai tame oub sene lugpeten eteri maime tame oub sekenke erne sene warruwum. Warruwun eme erne panen yin erne me kwuran kwanen pen sate panen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Eme Jisas erne panen yibetem, eme erne kwanete nenem me eme maime eterne newon, ere semenem. Eme lam, tame wuri, eri sig Saimon, ere Sairini komri tame. Lan, eme erne egiyen let tobo kere sen yin, etep wom. Ne Jisas erne kobo lan erne kwanete me sen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ere sen yim, eme kow nebulek yin yawom. Ete kow eri sig Golgota. Ete sig eri somo Tame Tare Bai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yawon, eme wain okken kwule yabe okken etep erne newon am. Newom, ere alawoyim, ere beke a. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Beke a, ei nai tame eme erne mek kwanem, eme eri tame oub wosan, satu sou tetebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Satu sou tetem, eme eterne kwanem emik sin erne ei simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ei simenem, eme me wulale wuri peten tuma etek bas rasen eri tareken yekwok kwanem. Emri erne namdem tuma eme etep bas rasem. Gwo Jisas. Ere Juda Tatame Etemri Keryen. Etep basem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sene eme sir petbetem tame pes epne etek kir me kwuran kwanem. Kwanem, wuri erne eme Jisas eri let mame yekwok teteruwum, wuri erne Jisas eteri let gwaime yekwok teteruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jisas erne etek kwanemenem, tame eme ete keluke yi yabetem, eme erne tuma workwoyeken resbetem, tare bolabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Eme etep wobetem. Ne kiyi etep wom. An God eri ake eisau berayewon sene yabel murke kerete. Etep wom. Eme erne etep wobetem. Ne God Eteri Yen, ne maime kobo late. Ne God Eteri Yen, ne me mesginin sene yeirte. Eme erne tuma kwoyen etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","God eri akek yaku kerebetem tame etemri apeilake etem, Moses eri wule wusoubetem tame etem, Juda etemri apeilake etem kir eme tuma kwoye kwayen etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kiyi ere tatame emne kobo labetem, gwopte ere maime kuyese kobo beke la. Ere wom. An Juda etemri keryen. Ere me mesginin yeirtek, nema lan etep wote. E seken, ere keryen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kiyi ere wom. An God Eteri Yen, God ere ane kobo late. Etep wobetem, gwopte nema late. Kap God ere erne kobo late o? Eme etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sir petbe tame pes, epne me kwuran kwanem tame pes etep kir epe erne etepwou tuma kwoyabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yabel komluke simenem, nowsel neirkap tekete keren yin, perpe tebetem yabel ere sene pasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yabel warbetem, Jisas ere etemri tumak noubke etep tem. Eli, eli lema sabaktani. Ete tuma somo ere gwo. Ari God, ari God, ne ane mapeke mesginye? ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Etep womke, kau tame eme etek mekinke temenem, eme eri womkap kuyese mapeke met, eme etep wom. Metye. Ere kiyi temenem tuma wusoubetem tame, Elaija, eterne kap tebe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Etemri tame wuri ere amen yan ere yam sou peten sen yan kwole yabe wain okke sogwunen mek peiken Jisas erne newon ate sen tetem. Sen tetem, Jisas ere beke a. Ere mo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mo wom, kau tame eme etep wom. Wai. Nema late. Kap God eteri kiyi temenem tuma wusoubetem tame, Elaija, ere kap erne kobo late nenbe o? Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas ere tewo wurinabu taye noubke pitin eri wou maime won yin ere ek sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Samke, God eri akek esmenem mate ere etiye yekwok pekan yeirin kerare kerare tem. Nina eisau yam, pape eisau eme borke pekam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Etep tem, sele mei nogwape eme tagwoyewom, God eri kiyi sam tatame nogwape eme wou sene peten eme sele mei mesginin wayem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yuri Jisas ere sele mesginin sene wayen yim yabel, ete tame eme Jerusalem komke yim, tatame nogwape eme emne etek lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ei nai tameken emri apeilakeken eme Jisas erne ei simenem, eme ninaken akeite wosken lam. Lam, eme kenake aken etep wom. Sekenwai. Ete tame ere God Eteri Yen. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kau ta eme kai kerak teten lakerebetem. Kiyi Jisas ere Galili mesginin yam, ete ta eme erne semowun yabetem, erne kobo labetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ete ta etemri wuri te Makdala komri Maria. Wuri te akeite Maria, Jemsken Josepken etepri nawo. Wuri te Sebedi eri yen pes etepri nawo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Perpe tem, Arimatea komri tame, kelken tame, ere yam. Eri sig Josep. Ere Jisas eteri tuma kenawaike abobetem tame. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yam, ere Pailat erne yin Jisas eri kupa pette erne wometem. Wometem, Pailat ere kir tem, eme Jisas eri kupa Josep erne newom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Newom, Josep ere peten tame oub geipa agerke leyen rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Leyen sen yim, yeki agerke nenem pape purik eme Jisas eri kupa etek rasem. E Josep eteri pape puri. Rasen, eme pape eisau gelkwun yan, pape puri eru rageren eme komke sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Makdala komri Maria te akeite Mariaken epe ete pape puri mekinke sin lakerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas ere samke, kwokwos God eri akek yaku kerebetem tame etemri apeilakeken Farisi tameken eme Pailat erne yin lan etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Apeilake, nema tuma wuri aboye. Kiyi ete tuma yikwokwobetem tame Jisas ere temenem, ere etep wom. An sate, yabel mur tetek, an sene wayen yite. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ne kir wote, ei nai tame eme yin yabel mur eteri sele mei ei simente. Jisas eri anepoi tame eme kip yan eri kupa sirke pette wurken. Eme tatame emne etep yikwokwote wurken. Jisas ere selek sene wayen yim. Eme ete tuma yikwokwote nenbe, e kiyi yikwokwom tuma teitkwunte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Etep womke, Pailat ere etep wom. Kem ei nai tame emne panen yite, eme sele mei noub ei simente. ");
INSERT INTO yss_yawu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eme emne panen yim. Eme yop leketen Jisas eteri sele mei luke etek rasruwun, eme ei nai tame emne won ei simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Juda tatame etemri ege si yabel kiyi temke, ei berabetem, Makdala komri Maria, akeite Maria etetken epe sele mei late yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yibetemke, nina yam, God eri komri tame wuri ere nelke yan yeirim. Yan yeirim, ere pape puri eru ragermenem pape gelkwun yin ere pape luke simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ete tame eri wusom tukap tobkumenem. Eri tame oub e geipawai. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Etek sele ei simenem ei nai tame eme erne lam, eme aken let tewoken puyer puyeren selke waren tuknatirin sa tamekap tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ete ta epe yam, God eri komri tame ere epne etep wom. Kep mane akte. An aboye. Kep etem mek kwuran kwanem tame Jisas eterne kep late yawo. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ere gwo beke te. Ere sene wayen yiwo. Kiyi ere etep wom. An sate, an sene wayen yite. Eri wom tumakap ere etep teye. Ere wayen yiwo. Kep epe yan la. Eri kupa rasem emi kep yan la. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kep agetage sene yin eri anepoi tame emne etep wote. Ere selek sene wayen yiwo. Ere Galili yekwok emne taresin yin koute. Kem erne etek yin late. Kep etepke yin wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Etep womke, ta pes epe akem, epe sele mesginin amen yim. Epe akem, epe sene metekwasken tem. Etep temke, epe anepoi tame emne wusoute yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yibetem, Jisas ere epne keluke lan, epne pir wom. Epe etep metem, epe gulke pan eri tewo tobok erne sukye woram. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ere epne etep wom. Kep mane akte. Kep yin ari mase emne etep wote. Kem Galilike yite, kem ane etek late. Ere epne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ta pes epe yibetemke, sele ei simenem ei nai tame eme komke sene yim. Yin, eme God eri akek yaku kerebetem tame etemri apeilake emne emri lam wos wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wusowum, God eri akek yaku kerebetem tame etemri apeilakeken Judari apeilakeken eme ete tuma namdem. Namden, eme ei nai tame emne kel nogwape newon etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kem tatame emne tuma yikwokwon etep wo. Neir nema tuknamenye, Jisas eri anepoi tame eme yan eri kupa sirke petye. Kem tatame emne etepke yikwokwote. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kemri apeilake ere etep mette, ere kemne pap wayete, nema eterken namdete, ere kemne beke kip pe. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ei nai tame eme kel peten apeilake emri wom tuma eme tatame emne etepke yikwokwon wosouwum. Juda tatame eme ete tuma kenawaike metem. Gwopte kir eme som kenawaike abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisaseri anepoi tame eme ep yekwo let ep yekwo let tewo ges wuri keyem (11-pela) tame eme Galilike yim, eme Jisas eter wom kowke yin yawom. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yin yawom, eme Jisas erne etek lam, eme erne sukye woram. Kau eme pap pes ten etep abom. Kap gwo tame ere Jisas o ere mapkap tame? ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas ere mekin mekin yan emne etep wom. God ere ane mure newom, an gwote selken nelken kom panen site. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Eke kem yin nogwape kantri tatame emne ari tuma wusoute. Eme ari wakse tete, kem emne baptais ok wirute, kem Apei eteri sig, ari sig, God Eri Wouri sigken won emne baptais ok wirute. ");
INSERT INTO yss_yawu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","An kemne wusowum tuma kem tatame emne wote, eme ari tuma meten tobote. Tuma wuri kem mane wan gette. An kemne beke mesgin. An keremken som temente. Gwote selken nelken yaper tete yabel an keremken som temente. Matyu ere bas rasem tuma ab eteke. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jisas Krais ere God Eteri Yen. Eteri tuma yenbo gwotek bas rasten. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God eteri tuma yenbo gwopkapke tem. Aisaia ere womkap etep yam. Aisaia ere God eteri kiyi temenem tuma wusoubetem tame, ere tuma kiyi siglouke bas rasen, etep wom. Kem wan raste. Gwo tame ere ari tuma wusoube tame, an erne won yate, ere taresin yin ari tuma wote, ere neri yate kelu noub eyarte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tame wuri ere tameken berai emik temente, ere noubke etep wote. Keryen ere yate. Kem eteri yate kelu noub eyarte. Etepke wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aisaia ere etep bas rasem, etepkap Jon ere etek yam. Yam, ere tameken berai emik yan temenem, ere tatame emne baptais ok wirubetem, ere tuma wusoubetem. Ere etep wusoubetem. Kem keremri wule yaper mesgintek, an kemne baptais ok wirubetete. Baptais ok wirubetete, God ere keremri wule yaper peten sepitite, ere kemne beke tuma namde. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Etep wom, Judia nowselri tatame, Jerusalem komri tatame eme akei Jon eterne yin lam. Eme emri nenbetem wule yaper wusowumke, Jon ere emne Jordan peikke baptais ok wirubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ere kelworken tame berai, ere kerap yaper, kamel por wuske nenem tame oub warbetem, ere somo kep borke sibetem. Sibetem, ere boulri wos yaper abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Etep tem, ere tuma etep wusoubetem. An taresin yam, tame wuri ere tiptiwun yate. Eter ere tame eisau, tame yenbowai. An tame eisau berai. An tame yenbo berai, nesa situk wurik beke si. An yen nebule, an selke site. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","An kemne okke wirube. Yuri yate tame ere kemne God Eri Wou kemne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sene Jisas ere Nasaret kom mesginin yim. Nasaret kom e Galili distrikke tetan. Mesginin yim, ere Jordan peikke yim, Jon ere erne etek baptais ok wiruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jordan peikke ok wiruwumke, Jisas ere peik mesginin barke wayen teten ere nerulam, ei gwan beram, God Eteri Wou ere nelke ap bourkap yan yeirin, Jisas eteri gwarek yeirin sim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yeirin sim, tuma wuri nelke etep wom. Ne Ari Yen yenbowai. An nene metekwasbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","God Eteri Wou ere Jisas erne won yim, ere tameken berai emik yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yim, eikina abona tame tabe por toub eme etek temenem. Neirken yabelken nogwape (40-pela) ere etek temenemke, gabo etemri keryen, Satan, ere erne seilabetem. Seilabetem, God eteri komri tame eme yan erne eyarem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yuri Jon ere ake yaperke temenemke, Jisas ere Galilike yin God eteri tuma yenbo etek wusowun etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Awo tobo teye. God ere Keryen, ere kom panen site nenbe. Kem porere yaper mesginte, sene kem porere yenbo pette. Kem God eteri tuma yenbo meten kenawaike abote. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas ere Galili peik kupa barke sewurbetem, ere lakemase Saimonken Andruken epne lam. Lam, epe omyen petbetem tame, epe wuli peikke rasen omyen petbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Petbetem, Jisas ere epne etep wom. Kep wayen arenken yite. Kiyi kep omyen petbetem. Omyen petbekap, sene an kepne peterate, kep tatame emne etepke pette. Pette, eme ari wakse tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Etep womke, agetage epe etepri wuli mesginin eterken yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ere epkera sene yibetem, ere lakemase Jemsken Jonken epne lam. Epe Sebedi eteri yen. Lam, epe perek sin wuli let mate nabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Let mate nabetem, Jisas ere epne yate wom. Womke, epe ar erne eteri yaku kerebetem tameken eme perek temenem, epe emne mesginin Jisas eterken yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas ere anepoi tameken eme yim, eme Kaperneam komke yan tem, ege si yabel Jisas ere God eteri akek wurin tatame emne tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wusowum, eme eteri tuma metem, eme wouken akem. Ere emne Moses eteri wule wusoubetem tame etemri wusoubetemkap beke wusou. Keryen emri wusoubetemkap ere emne etepke wusoubetem, eke eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ere emne wusoubetem, tame wuri, erne gabo gulelemenem tame, ere God eteri akek yan woram. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yan woran, ere noubke etep wom. Jisas, ne Nasaret komri tame. Ne kap nesetne be wos nente? Kap ne nesetne botkwute yawo, o berai? An nene laten. Ne God eteri tame yenbo. Ere nene won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Etep womke, Jisas ere erne wom. Ne elen me te. Ne tame erne mesginin yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Etep wom, gabo ere tame erne selke teren, ete tame ere let tewoken negnegem. Negnegem, gabo ere taye piten tame erne mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mesginin yim, tatame nogwape eme etep lam, eme wouken akem, eme etemwou etemwou etep wolam. E mapkap tame? Ere mureken keryenkap wobe. Gabo eme eri tuma metbe, eme tame emne mesginin amebe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Agetage Galiliri tatame akei eme Jisas eri nenemkap eme akei metem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas ere eri anepoi tameken eme God eteri ake mesginin yin Saimonken Andruken epri akek yin wurim. Jonken Jemsken epe kir yin wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yin wurim, Saimon eteri owi te kapoyi keyem, te tiyke tuknamenem. Tuknamenem, eme Jisas erne etep wom. Gwo ta te kapoyi keiwo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Etep womke, ere yin tene let keren nenewayen siruwum. Siruwum, te yenbo tem, te wayen emne iyawu keren emne awos newon am. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yabel waremke, tatame eme let yaper tewo yaper te tatame, gabo gulelemenem tatameken emne panen Jisas erne yin lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Yin lam, nogwape komri tatame eme ake eruke yan tetyewom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tetyewomenem, Jisas ere eikina abona let yaper tewo yaper te tatame emne eyarbetem. Gabo eme tatame nogwape emne gulelemenem, ere emne akei won yibetem. Gabo eme Jisas erne lam, ere emne wotakem, eme eri sig mane wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Neir tepke Jisas ere wayen yim, ere tatameken berai emik yim, ere Apei God eterken tuma namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Namdebetem, Saimon, eterken temenem tame kau eme erne sopen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yin lam, eme erne etep wom. Tatame nogwape eme nene sopbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ere emne etep wom. Nema yi. Nema akeite akeite mekinke tetan komke yite. An emne tuma kir wusoute. An ete yaku kerete yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Etep wom, ere Galili yewok yin sewurbetem, ere God eteri akek wurin tuma wusoubetem, gabo emne won amekirbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Numa pe tame ere yan gulke pan Jisas erne etep wom. Ne abote, ne ane noub nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Etep womke, Jisas ere erne kobo kenake lam, ere erne let kerelan etep wom. An aboye. Ne yenbo te. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Etep womke, eter wobetem tuma tepken erne pemenem numa eme sok ten, ere yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yenbo tem, Jisas ere erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Metye, an nene noub wote. Agetage ne God eteri akek yin neri wus God eri akek yaku kerebe tame erne peterate. Moses ere kiyi womkap ne etep nente, ne God erne kwar pete. Etep nente, tatame eme late, eme mette, nene pemenem numa sok teye, ne yenbo tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jisas eri wom tuma ete tame ere metem, ere beke tobo. Ere yin tatame nogwape emne wusowun sewurem. Wusowum, tatame eme Jisas erne late wom. Etepke Jisas ere kom wuri mapeke yi. Tameken berai emik ere etek yin temenem. Ere etek temenem, komri komri tatame nogwape eme eterne etek yin lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yuri Jisas ere Kaperneam komke sene yim, tatame eme lam, ere eteri anenawoken temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Etep lam, tatame nogwape eme ete akek wurmenem, ake pelawom. Pelawom, tatame eme yan ake eruke tetlawoyim. Tetlawoyim, Jisas ere ake purik temenem, ere tuma yenbo ake purik wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wusoubetem, tatame eme yan letken tewoken bulworan tame wuri erne sen yam. Tame epe pes epe pes eme erne sen yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sen yam, tatame nogwape ake pelawom, eme ete tame erne mapeke sen wur? Sen wurlawoyin eme erne ake magelke sen yawom, ake ropo tagwon tame erne tiyken newokwunem. Eme Jisas eteri baye tobok nenewaren rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nenewaren rasen, Jisas ere emri porere lam, eme eteri mure kenawaike abobetem, eke ere letken tewoken bulworam tame erne etep wom. Areri yen, neri nenem wule yaper an peten sepitye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Etep womke, Moses eteri wule tuma wusoubetem tame eme etep metem, eme etemri papke etep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ete tame ere beke etep woye? Ere God erne tuma yaperke woye. More tame etem wule yaper beke peten sepit. God eterwou ere peten sepitibe. Eme etep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisas ere etemri porere lam, ere emne wometem. Beke kem etepkap porere teye? ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","An ete tame erne wote. An neri nenem wule yaper peten sepitye. Etep wote, e yaku eisau. An erne etep wote. Ne wayen teten neri tukna wos peten sen yi. An etep wote, etepwou e yaku eisau. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","An Tatame Etemne Late Yeirim Tame, an gwote nowselke tetan. An mureken, an tatame etemri wule yaper kuyese peten sepitite. Areri mure an kemne peterate. Kem la. Etep womke, ere letken tewoken bulworam tame erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","An nene wobe. Ne wayen teten neri tukna rowe peten sen akek sene yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Etep wom, tatame eme lek temenem, ete tame ere wayen teten eteri tukna rowe peten sen akek yim. Sen yim, eme lam, eme wouken aken God eterne tuma yenbo etep wom. Etepkap wos e gwotepte nenye, nema kiyi beke la. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas ere kom mesginin Galili peik kupa barke sene yim. Sene yim, tatame nogwape eme yan wurisubuk sim, ere emne tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wusowum, ere sene yibetem, ere Livai erne lam. Livai ere Alfias eteri yen, ere takis kel rasbetem akek simenem, tatame etemri takis kel petbetem. Lan, ere erne etep wom. Ne arenken yite. Etep wom, Livai ere wayen eterken yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yim, takis kel petbetem tame nogwape, akeite wule yaper nenbetem tameken eme eteri tuma metem, eme erne semowum. Semowum, yuri Jisas ere Livai eteri akek sin awos abetem, kau eme yan eterken eri anepoi tameken eme etemken sin awos abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sin abetem, Moses eteri wule tuma wusoubetem tameken Farisi tameken eme lam, Jisas ere takis kel petbetem tameken akeite wule yaper nenbetem tameken etemken sin awos abetem. Etep lam, eme Jisas eri anepoi tame emne etep wometem. Beke Jisas ere takis kel petbe tameken akeite wule yaper nenbe tame etemken awos sin abe? ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Etep wom, ere emri wom tuma metem, ere emne awosein etep wom. Tatame eme kapoyi beke kei, eme yaper beke met, eme dokta erne beke kip yi. Kapoyi keibe tatame etemwou eme dokta erne late yibe. Kau tatame eme etep abobe. Nema tatame yenbo. Etepkap tatame an emne kobo beke kip la. Kau tatame eme etep abobe. Nema tatame yaper. Etepkap tatame an emne kobo late yam. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Baptais ok wirubetem tame Jon eteri anepoi tameken Farisi tameken eme aom takeren God erne abobetem. Etep tebetem, tame kau eme yan Jisas erne etep wometem. Beke Jon eteri anepoi tameken Farisi tameken eme wule yenbo tobobe, eme aom takerbe. Neri anepoi tame eme wule yenbo beke tobo, eme aom beke taker? ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ere emne awosein etep wom. Tame ere ta panete, ere eri tamenowu emne ta neisbe awos ate wote, eme kap aom takeren, bepou me temente o? Berai. Ta panete tame ere tetan emi eme awos nogwape abe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yuri ta panete tame ere yite, eme awos beke kip a, eme aom takerte. Gwopte an areri anepoi tame etemken tetan, eme awos abe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tame eme pekaten tame oub seba tetan, eme tame oub ager keraken eme beke peten etek kape. Ere tame oub ager keraken peten etek kapete, pekaten tame oub ere eisauwai sene pekate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ere tuma sene etep wom. Yurik nenem wain ok eme girbu seba yewon pelaube, girbu seba ere pekan ok selke sirpitite. Etep tete, girbu ere yaper tete. Etepkap yurik nenem wain ok eme girbu agerke yewobe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yuri ege si yabel tem, Jisas ere anepoi tameken eme wit now borke yibetem, eri anepoi tame eme yin wit supa kwosbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kwosbetem, Farisi tame eme etep lam, eme Jisas erne etep wom. Ek la. Neri anepoi tame eme ege si yabelke etep nenbe, eme neremri wule tousibe. E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisas ere emne awosein etep wom. Devit ere kiyi temenem keryen. Ere kiyi nenem wos eme bas rasem, kem kap e tuma beke la. Devit eteri wakseken eme kwoi sabetem, eme kap be aomke am? ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kwoi sabetemke, eme God eteri ake eisauke yin wurim. Ete yabel Abiatar ere temenem, ere God eteri akek yaku kerebetem tame etemri apeilake. Eme wurin, Devit ere God eterne newon rasem geil peten am. Am, ere eterken temenem tame emne newon am. Neremri wule, God erne newobe geil God erne ake yaku kere tame etemwou eme abe. Akeite tame eme beke kip peten a. Devit eteri wakseken eme abetem, God eri akek yaku kerebetem tame eme tuma beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisas ere emne sene etep wom. God ere tame kiyi seikim, ere ege si yabel yurik nenem. God ere ete ege si yabel nenem, tatame eme ete yabel ege sibe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","An Tatame Etemne Lan Yeirim Tame. Aren, an ege si yabelri Keryen. Aren, an tatame emne wote, be wos ege si yabelke nente wote, eme kuyese nente. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisas ere God eteri akek sene wurin lam, let gwori tame ere etek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Temenem, kau tame eme Jisas erne tuma namdete keluke sopem. Etepkap eme erne lek ten etep abobetem. Gwopte ege si yabel. Ere kap let gwori tame erne let sene segilin eyarte o? Ere etep tete, nema erne kuyese tuma namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Eme etepke abom, Jisas ere let gwori tame erne etep wom. Ne gwok yan etemri borke yan tetete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Etep wom, ere tatame emne etep wometem. Wule ere mapeke wobe? Ege si yabel nema beke nente? Ege si yabel nema wule yenbo nente, o nema wule yaper nente? Ege si yabel tame sate nenbetete, nema erne kobo lan eyarte, o nema erne pik pen sate? Ere emne etep wometem, eme awosein beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Awosein beke wo, ere emne lan sewuren pap wayem. Eme eteke lan eme elpenalpem, eke Jisas ere emne kobo late abom. Kobo late abom, ere let gwori tame erne etep wom. Ne let tai. Let tayemke, eri let yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yenbo tem, Farisi tame eme God eteri ake mesginin yin Herot eri anepoi tame etemken namdem. Eme etep wom. Nema Jisas erne pen sate. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas ere eteri anepoi tameken eme kena yite abom, eme Galili peik kupak yin temenem. Yin temenem, Galili distrikri tatame nogwape eme erne semowum. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Juda yekwori tatame, Jerusalem komri tatame, Idumea yekwori tatame, Jordan peik yekwok temenem tatame, Tairken Saidonken kom sag pes mekinke temenem tatame eme akei yam. Jisas ere nenbetem wos eme metem, eme erne late yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Erne late yam, ere anepoi tame emne etep wom. Kem ane pere wuri sen yan mekinke gaite. Tatame eme ane mane yan mekin mekin tetkwunte. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kiyi ere tatame nogwape emne eyarbetem, eme eterne kerelate awoawo ginbetem. Eme etepke abom. Nema erne kerelate, nema sene eyar tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Etepke abom, gabo gulelemenem tatame eme erne lamke, eme gulwarke pan erne muresen etep wom. Ne God Eteri Yen. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ere emne noubke etep wom. An God Eteri Yen, kem tatame emne etep mane wusoute. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sene Jisas ere kowke yawen kau tame emne won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yam, ere ep yekwo let ep yekwo let tewo bor pes kei (12-pela) tame emne etep wom. Kem arenken tete. An kemne Aposel yaku newon, kem kom komke yin ari tuma wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","An kemne mure newote, kem gabo emne ari murek kuyese pekeroukte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Etek wom tame ep yekwo let ep yekwo let tewo bor pes kei (12-pela) tame emri sig gwo. Wuri ere Saimon. Jisas ere erne akeite sig Pita wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Pes epe Jemsken eri mase Jonken. Epe Sebedi eteri yen. Jisas ere akeite sig epne tem. Sig et Boanerges. Sig somo gwo. Waketekap pebe tame. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Akeite emri sig gwo. Andru, Filip, Bartolomyu, Matyu, Tomas, Jems. Jems ere Alfius eteri yen. Pes epe Tadiusken Saimon Selotken. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Wuri ere Judas Iskariot. Yuri ere Jisas erne yena tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sene Jisas ere maime komke sene yim. Sene yim, tatame nogwape eme wurisubuk sin ere emne tuma wusowum. Wusowum, Jisas eter, eri anepoi tameken eme yaku eisau kerem, eme a beke a. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","A beke a, Jisas eri nawoken eri maseken eme etep metem, eme etep wom. Jisas ere me belebe. Etep wom, eme yan, eme erne panen yite yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moses eri wule wusoubetem tame eme Jerusalem komke mesginin yeirin, eme etep wom. Satan ere gabo etemri apeilake. Eri sig wuri e Belsebul. Eter ere Jisas erne gulelemenem. Ere Jisas erne mure newom, eke ere gabo emne pekeroukbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Etep wom, Jisas ere tatame emne won yam, ere sekur sakur tuma emne etep wom. Ere emne wometem. Satan ere mapeke eter maime lelete? ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Keryen wuri eri wakse eme pekan etemwou etemwou naite, eme som beke kip te, eme yikwute yakwutete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ane wuri eri yen eme etemwou etemwou naite, eme som beke kip te. Eme yikwute yakwutete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanken omogaboken eme etepkapke tete. Satan ere eteri wakseken naitek, eme beke kip te. Eme yikwute yakwutete, eme noub beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jisas ere sekur sakur tuma sene etep wom. Tame ere mureken tame eteri akek wurte wote, ere eteri wos pette wote, kiyi ere yin ete murken tame erne kepke peten bogun raste. Bogun raste, ere kuyese wurin wos ek pette. Etepkap, an Satan erne kepke peiken rasbe. Rasbe, Satan ere kiyi petem tatame an emne sene petbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","An kemne sekenke wobe. Tatame eme wule yaper nente, God ere emri nenbe wule yaper peten sepitite, ere tuma beke kip wo. O eme God erne tuma yaper wotek, God ere ete wule yaper peten sepitite, ere tuma beke kip wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tatame eme God Eteri Wou eterne tuma yaper wote, God ere emri nenbe wule yaper beke kip peten sepit, ere emne tuma namdete. Gwopte, yuri etepwou ere beke kip peten sepit. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kiyi eme etep wom. Gabo ere Jisas erne guleleten, ere gabo emne pekeroukbe. Etep womke, Jisas ere emne ete tuma wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jisas eri nawoken maseken eme yan kom genik tetpete wurmenem. Wurmenem, eme erne tuma wopete wurin etep wom. Nema nerenken tuma namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Etep womke, tatame nogwape eme eterken mekinke simenem, eme erne etep wom. Metye. Neri nawoken maseken eme yawo, kom genik kouten. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ere awosein etep wom. An kemne peterate, eike ari nawo, eike ari mase. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Eterken mekinke simenem tatame ere emne lan etep wom. Ek la. Gwo tatame eme ari nawokap, ari masekap. ");
INSERT INTO yss_yawu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tatame eme God eri tuma meten tobote, ete tatame etem eme ari nawokap geisimasekap. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yuri Jisas ere Galili peik kupa tapek yin temenem, ere tatame emne tuma sene wusoubetem. Wusoubetem, tatame nogwapewai eme yan tetyewon ouyeimenem, ere perek waren simenem. Tatame nogwape eme peik kupa tapek tetyewomenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tetyewomenem, ere sekur sakur tuma nogwape emne wusoubetem, ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Metye. Tame wuri ere wit supa nowke yin panbele sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Panbelen sewurem, wit supa kau eme keluke yeirim, ap eme yan akei am. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wit supa kau eme pape luke yeirim, sel nebule etek temenem, wit supa eme agetage rekwan wayem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Rekwan wayem, emri nen nebule temenem, yabel pasem, eme sok ten saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wit supa kau eme keikei waboi somok yeirin rekwam. Keikei waboi eme punen borer bareren, wit eme supa beke ya. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Supa kau eme sel yenbok yeirin rekwan eisau ten, supa nogwape yam. Supa kau eme nogwape kera (30-pela) yam. Kau eme supa nogwape (60-pela) yam. Kau eme supa nogwapewai (100-pela) yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Etep won, ere sene etep wom. Tatame eme wanken eme wan wurik mette. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tatame nogwape eme sene yim, Jisas eteri ep yekwo let ep yekwo let tewo bor pes keyem tame (12-pela) etem, akeite tameken eme som temenem, eme erne sekur sakur tuma somo wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ere emne awosein etep wom. God ere kom panen sibe tuma, kiyi basem tuma an wusoube, keremwou kem noub mette. Akeite tatame emne an sekur sakur tumawouke wobe, eme noub beke kip met. Kiyi basem tuma etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Eme wos late, eme wos somo beke kip la. Tuma eme wanwouke mette, eme tuma somo beke kip met. Eme noub mette wom, eme God erne kenawaike abote wom. Eme kenawaike abote wom, God ere emri wule yaper pauk peten sepitite wom. Etepke basem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas ere emne etep wolam. Ari woye sekur sakur tuma kem metye o kem beke met? Kem beke kip met, yuri an sene wote sekur sakur tuma kem etepwou beke kip met. Wit supa nowke panbelen sewurem sekur sakur tuma somo an kemne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","God eteri tuma wusoube tame ere wit supa nowke panbelen sewurem tamekap. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tatame eme tuma bepou me metbe, eme keluke yeirim wit supakap. Eme metbe, sene Satan ere yabe, ere ete tuma peten sepitibe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tuma metbe tatame eme pape luke yeirim wit supakap. Eme tuma meten agetage peten pap yewon metekwasbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Eme tuma noub beke tobo, sene akeite tame eme God eri tuma teitkwunte, eme God eri tuma metbe tatame emne tuma yaper wobe, o emne yaper nenbe. Etep tebe, eme God eri tuma mesginbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kau tatame eme tuma metbe, eme keikei waboi somok yeirim wit supakap. Eme God eteri tuma metbe, ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","eme nowselri wosken kelken etepwou abobe, ete wos emne keplakap maukpitbe. Etep tebe, eme God eri yaku beke wuri kere, eme wos yenbo beke wuri nen. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kau tatame eme tuma metbe, eme sel yenbok yeirim wit supakap, eme tuma meten abobe, eme God eri yaku kerebe, eme wule yenbowou nenbe. Kau supa eme 30-pela yamkap, tatame eme God eteri yaku kera kerebe. Kau supa eme 60-pela yamkap, tatame eme God eri yaku nogwape kera kerebe. Kau supa eme 100-pela yamkap, tatame eme God eri yaku nogwapewai kerebe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas ere emne wolam. Tatame eme lam yaren sen wurbe, eme mak tukbe? Eme tukna tiy kulke tukbe o? Eme ouke gumkerebe? Berai. Eme etepkap beke nen. Eme tiyke tukbe, tatame eme kuyese labe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Gwopte berasten wos yuri tatame nogwape eme noub late nenbe. Gwopte wos nogwape subten, yuri eme ete wos late. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kem wanken, kem wan wurik mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Be tuma kem mette, kem noub meten abote. Be tuma o be wos kem tatame emne tebekap, God ere kemne sene etepkap tete nenbe. Ere kemne kenake nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Porere yenbo tetan tatame eme ari tuma metbe, eme tuma somo kir metbe. Etepkap tatame an emne tuma nogwape som wusoute. Porere yaper tetan tatame eme ari tuma metbe, tuma somo eme beke met. Etepkap tatame eme metbekap eme sene beke abo. Beke abo, an emne tuma sene beke kip wusou. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","God eter panen siten kom ere gwopkap. Tame ere wit supa nowke panbelebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Panbelebe, neir teketebe, tame ere tuknabe, yabel ere sewurbe. Etep tebekap, wit supa eme rekwan yabe. Tame ere beke la, wit supa eme boube. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Wit supa selke bowen yabe, take senin, sikile ten supa ek yabe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wit supa okwobe yabel now maime ere kwotan akek sen yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas ere emne wolam. God eter panen siten kom e mapeke? An kemne sekur sakur tuma wuri wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","E mastet mekap. Mastet e me sig. Eri supa e nogwape me supa eisaukap berai. Ete me supa nebulewai. Tame ere ete me supa peten eteri nowke rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Rasem, eme rekwan wayem, yuri eme eisau tem. Me nogwape eme nebule, e me ere eisauwai. E me eri ku eisau, ap eme yan ete me kuk sibetem. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas ere tatame emne etepkap sekur sakur tuma nogwapeke wusoubetem. Eme eter wosoubtem tuma noub abobetem, ere emne sene wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ere emne sekur sakur tumawou wusoubetem. Yuri eteri anepoi tameken etemwou temenem, ere emne sekur sakur tuma somo ek wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yabel warbetem, Jisas ere eri anepoi tame emne etep wom. Nema peik kupa keraruke pukeyin wute. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Etep womke, eme tatame nogwape emne mesginin yim. Jisas eter simenem perek anepoi tame eme etek waren sin erne panen yim. Yim, pere kau eme etek kir yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yim, marye eisau yam. Ok sare eisau yam, ok pere barke teikwunbetem. Pere ok pelaute nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pelaute nenbetem, Jisas ere pere kin yekwok tare bagwu takwun tuknamenem. Tuknamenem, anepoi tame eme erne teren wayen sin erne etep wom. Nema sate nenbe. Ne nemne kobo beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Etep womke, Jisas ere wayen teten ere maryeken ok sareken epne wotakem. Kep elen me te. Etep womke, epe elen tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ere eri anepoi tame emne etep wom. Kem mapeke akbe? Kem ane kenawaike beke abo. Ari mure kem beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Etep wom, eme kenake akem, eme etemwou etemwou namden etep wom. Gwo mapkap tame? Maryeken ok sareken epe eteri tuma meten beiwo. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Eme sene yibetem, eme peik kupa keraruke wun Gerasa yekwok yim. Gerasa yekwo e Juda yekwo berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Etek yim, eme pere gayin yan tame wuri ere tame sele emike sewurbetem, ere Jisas erne late yam. Ete tame erne gabo gulelemenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ete tame ere sele emike temenem. Eri mure eisauwai, tatame eme erne noubke keresukun kepke peiklawoyim. Eme waia kepke peiklawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tewo nogwape eme erne let tewo waia kepke erne peikem, ere let kep roborasem, ere pape peten tewo peikmenem waia etek regrasem. Eri mure eisau, eme erne mapeke keresuk. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yabel nogwape ere tame sele mei keluke yibetem, kowke yibetem, ere taye kenake pitbetem, ere pape peten eri wus kwibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jisas ere kaike temenem, ete tame ere erne lan, ere amen yan gulke pam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Gulke pan, ere Jisas erne noubke etep wom. Jisas, ne Apei God Eteri Yen. Ne ane be wos nente? Ne God erne abon ane kobo late. Ne ane mane pete. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kiyi Jisas ere gabo erne etep wom. Ne ete tame erne mesginte. Ere etep womke, tame ere etepkap tuma erne wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Etep wom, Jisas ere erne wolam. Neri sig map? Ere awosein etep wom. Ari sig Ei Nai Tame Nogwape. Nema gabo nogwape, eke ari sig Ei Nai Tame Nogwape wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Etep wom, ere Jisas erne tewok tewok wobetem. Sen. Adebas. Ne nemne genek mane won yite. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Por nogwape eme mekinke temenem, eme kowke a an sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","An sewurbetem, gabo eme Jisas erne etep wom. Ne nemne won yin nema por etemne yin gulelete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Etep womke, ere emne etep wom. Kem epe yi. Etep wom, eme tame erne mesginin yin por etemne yin gulelem. Gulelemke, ete por eme agetage amekirin yin emi yaperke warkuten peik kupak lele kerpen eme okke an saiwom. Por eme nogwape, 200. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Saiwom, por lakerebetem tame eme etep lam, eme amekirin yin kom sagri tatameken boul komri tatameken emne emri lam wos wusoubetem. Wusoubetem, tatame eme metem, eme ete wos late yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yim, Jisas eterken, kiyi gabo gulelemenem tame eterken eme etepne late yim. Ete tame kiyi eri sig eme etepke wobetem. Ei Nai Tame Nogwape. Yin lam, tame ere tame oub waren etek simenem. Ere porere yenbo sene tem. Eme erne lan, eme akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Akem, ete wos emri lek lam tatame eme akeite tatame emne etep wusowum. Gabo ere tame erne gulelem tumaken, por etemri tumaken eme emne wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wusowun eme metem, eme Jisas erne etep wom. Ne nemri sel mesginin yite. Eme me akemke, eke eme erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Etep won, ere perek waren yite wom, kiyi gabo gulelemenem tame ere erne etep wolam. Sen. Nesa etep yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jisas ere erne wotaken etep wom. Ne nereri komke sene yite. Ne neri wakse emne yin late. Aneyen ere nene kobo laye, nene yenbo nenye tuma ne emne etep wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Etep wom, tame ere yin Juda berai tatame etemri yekwok Dekapolis yekwori kom nogwaperi tatame emne won sewurbetem. Ere etep wom. Jisas ere ane yenbo nenem. Tatame eme etep metem, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas ere perek sene waren peik kupa keraruke sene eme yim, tatame nogwape eme eterke yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yam, ete komke tetan God eri ake nebule lakerebe tame wuri, eteri sig Jairus, ere kir yam. Yam, ere Jisas erne lam, ere etep abom. Ete tame ere tame yenbo. Etep abom, ere eteri tewo tobok waren erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Areri yen te sate nenbe. Ne yan tene let kerete, te beke kip sa. Te yenbo sene tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Etep womke, Jisas ere eterken yim. Yibetem, tatame nogwape eme eterken mekin mekin kirkir yibetem, ere borborke tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Etep tem, ta wuri te worta sibetem, nabe ep yekwo let ep yekwo let tewo bor pes kei (12-pela) te nep sibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Etep tem, te dokta emne yibetem, eme mus eisau newobetem. Te kel nogwape emne newobetem. Newobetem, te etep abobetem. Dokta eme ane eyarte, ari gwotek sibe nep omote. Etep abobetem, nep ere beke omo, etepke som temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Etep tem, te Jisas eri nenbetemkap metem, te tatame nogwape etemken yan eteri kin gumak yan tetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tetem, te etep abom. An eteri tame oub megke let keretek, ari sibe worta ek omote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Te let kerem, teri sibetem worta omom, te metem, te yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Etep tem, Jisas ere etep metem. Eri mure tene etep nenem, ere etep metem. Metem, ere petkwo lam, tatame nogwape emne etep wolam. Eike ari tame oub megke let kereye? ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Anepoi tame eme erne awosein etep wom. Ne epe la. Tatame nogwape eme nerenken borborke yibe. Beke ne etep wolabe, eike ane let kereye? ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ere lan sewuren etep abom. Eike ane kerelaye? An sopte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ta te etep abom. Ari sibetem worta omoye, an yenbo teye. Eri mure ane eyarye. Te etep abom, te aken let tewoken poipoyin eri tewo tobok waren te erne etep wom. Aren, an nene let kerelaye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ere tene etep wom. Ari yen, ne ane kenawaike etep aboye, eke ne yenbo teye. Neri metbetem mus omoye. Ne yin eyar temen. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas ere etetken tuma som namdebetem, tame kau eme Jairus eteri ake mesginin yan Jairus erne etep wom. Neri yen te saye. Ne tuma wusoube tame erne mane panen yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisas ere ete tuma metem, ere Jairus erne etep wom. Ne mane akte. Ne ane kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Etep womke, ere erne semowun yibetem tatame emne etep wom. Kem gwotek temen. Pita, Jems, eteri mase Jonken etemwou eme arenken yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Etep wom, eme ete komri God eteri ake nebule lakerebetem tame eteri akek yan ere lam, tatame nogwape eme keratirbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Etep lam, ere akek wurin etep wom. Kem beke etepkap keratirbe? Ete yen te beke sa. Te bepou me tuknaten. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Etep wom, eri wom tuma eme sak kenake keyetirem. Sak keyetirbetem, ere tatame nogwape emne wotakem, eter, ete yen teri aken nawoken etep, eterken temenem tame etem eme yen kupa rasmenem emik yin wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yin wurim, ere ete yen tene letke keren Hibru tumak etep wom. Talita kum. Ete tuma somo ere gwopkap. An nene wobe. Yen, ne epe waye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Etep womke, agetage yen te wayen teten sewurem. Yen teri nabe ep yekwo let ep yekwo let tewo bor pes kei (12-pela) temenem. Tatame eme etep lan, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisas ere emne wotakem. Ari nenyekap kem emne mane wusoute. Ere emne sene etep wom. Kem ete yen tene awos newon a. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas ere ete emi mesginin ere eteri maime kom Nasaretke sene yim, eteri anepoi tame eme eterken yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yim, ege si yabel tem, ere God eteri akek wurin emne tuma wusoubetem. Tuma wusoubetem, tatame nogwape eme eri tuma metem, eme wouken aken etep wom. Ere tuma nogwape yenboke wobe. Porere erne eike newom? Eike erne etepkap tuma wusowum? Erne ete rigrabe porere eike newom? ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nema kir tame. Ere ake kerebe tame. Ere Maria etetri yen. Ere Jems, Josi, Judas, Saimon etemri lake. Eteri geisi eme neremken tetan. Etep womke, eme erne magel tayem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ere emne etep wom. God eteri tuma wusoubetem tame emne e komri tatame eme etep wobe. Eme tame yenbo. Etep wobe. Etemri maime komri tatame etem eme emne magel taibe. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Etepkap, ere rigrabe nogwape eteri maime kom beke kip sene nen. Ere let tewo yaperken tame peswou epne let kerem, epe yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tatame eme erne kenawaike beke abo, ere etep metem, ere wouken akem. Sene ere kom komke sewuren tuma wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisas ere eri anepoi tame epe yekwo let epe yekwo let tewo bor pes keyem tame (12-pela) emne won yam. Yan, ere emne pesre pesre kom komke yite won emne etep wom. An kemne mure newote, kem gabo kuyese pekeroukte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ere emne sene etep wom. Kem kom komke yite, wos nogwape mane sete. Kwokwulwouke kem sete. Awos, ayer, kel kem mane sete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kem warte tame oub, wurisubuwouke warte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ere emne sene etep wom. Kem komke yin yaku etek kerete, kem ake wurisubuk yin tete. Ake wurisubuk sin ate, kem etek tuknate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Komri tatame eme kemne pap beke yewo, o kemri tuma beke met, kem emri kom mesginin yite. Yite, kem yop rasen, kem tewo subu etek nubutkwunte. Eme eteke lan, eme etep wote. Nema epne yaperke nenye, eke yuri God ere nemne yaper awosein nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Etep womke, anepoi tame eme kom komke yin tuma wusoubetem. Eme etep wobetem. Kem porere yaper mesginte, kem porere yenbo pette. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Etep wobetem, tame emne gulelemenem gabo emne anepoi tame eme gabo emne pekeroukbetem. Tatame let kere tewo kerebetem, anepoi tame eme kwar peten emne wuske kerebetem. Etep tebetem, tatame eme yenbo metbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tatame nogwape eme Jisas eri nenbetem wos namdebetem, apeilake tame Herot ere etep metem. Kau tame eme etep wobetem. Baptais ok wirubetem tame, Jon, ere sam, ere sele meike sene wayen yim. Sene wayem, eke ere mureken ere rigrabe nenbe. Etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kau tatame eme etep wobetem. Ere Elaija, God eteri kiyi temenem tuma wusoubetem tame. Kau eme etep wobetem. Ere God eteri tuma wusoubetem tame etemri wuri. Ere kiyi temenem tuma wusoubetem tamekap. Eme etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot ere Jisas eri nenbetem wos metem, ere abon etep wom. Ere baptais ok wirubetem tame Jon. Kiyi an erne wak regen ere ek sam. Ere sele meike sene wayen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jon ere sam tuma gwopkap. Kiyi Herot eter ere Jon erne keresukun kepke peiken ake yaperke won wurim. Bepou berai. Herot ere eri mase Filip eri ta Herodias tene burkitpeten panem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Etep tem, Jon ere Herot erne etep wobetem. Neri mase eteri ta ne tene burkitpeten panem, e yaper. Ne etepkap tem, ne wuleke tousim. Herot ere etep metem, ere pap wayen ere tame won yin Jon erne keresukun ake yaperke won wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Wurim, Herot eteri ta Herodias te Jon erne pap kenake wayen, etep abom. An tame wuri erne won ere Jon erne berasen yin pen sate. Te etepkap tete nenlawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tame eme erne pete wurken, eke Herot ere Jon erne ake yaperke berasem. Herot ere etepke abom. Jon ere tame yenbo. Eri porere e yenbowai. Etep abom. Herot ere Jon eri tuma metbetem, ere pap yaper ten, porere pes tem. Etep temenem, ere Jon eteri tuma noub sene metbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yabel wuri tatame nogwape eme yan Herot eterken temenem, eme Herot erne nawo te warwiyim yabel abom, eke eme awos nenem. Yam tame eme gwopkap. Eme gavman tameken ei nai apeilake tameken Galili distrikri apeilake tameken. Ete yabel Herodias te etep abom. Gwote yabel an Jon erne pen sate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Etep abom, Herodias etetri yen te munguta, te woran teten tesbetem. Tesbetem, Herot ere akeite tameken sin abetem, eme teri tesbetemkap lam, eme metekwasbetem. Metekwasbetem, Herot ere tene etep wom. Nema nene metekwasye. Etepkap, ne be woske pette abobe, ne ane wotek, an nene ek newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ere gabo puromon etep wom. An nene sekenke wobe. An nene newote nenbe. Ne ari teitkerem siten sag pette wote, an nene eisauke kerkwun newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Munguta yen te wurin nawo tene etep wolam. An erne be woske wote ere ane newote. Nawo te awosein etep wom. Ne baptais ok wirubetem tame Jon eteri tareke wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Etep womke, agetage te woran Apeilake Herot erne etep wom. Ne ane baptais ok wirubetem tame Jon eterne wak regen tare rewok yewon sen yan ane peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Etep womke, Herot ere pap yaper tem. Ere Jon erne wak regte mo wom, ere sene maime abolawoyim. Tatame nogwape eme arenken awos abe, eke eme ari tene woye tuma metye. An tene mane yikwokwote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Etep womke, agetage Herot ere eri ei nai tame wuri erne etep wom. Ne Jon erne wak regen eri tare sen yate. Etep womke, Jon ere ake yaperke temenem, Herot eri ei nai tame ere yin Jon erne etek wak regem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Regen, ere eri tare rewok yewon sen yan, munguta yen tene newom. Newon, te peten sen yin nawo tene peteram. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jon eteri anepoi tame eme etep metem, eme yan eri kupa peten meike rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisas ere won yim tame eme sene yan Jisas erken wurisubuk sim. Simenem, emri kerebetem yakuken wobetem tumaken eme erne wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wusoubetem, tatame nogwape eme ete emi yi yabetem, Jisas eter, eteri anepoi tameken eme yaku eisau kerebetem, eme awos beke a. Jisas ere eri anepoi tame emne wom. Kem arenken yite. Nema tameken berai emik yin ege site. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Etep womke, eme pere peten tameken berai emik yin temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tatame nogwape eme lan etep wom. Jisas ere yibe. Etep won, eme akei kom mesginin keluke amekirin yim. Eme kiyi taresin keluke yim, yuri Jisas ere perek yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yan gayin ere tatame nogwape emne etek lam, ere etep abom. O, eme sipsipkap. Emne awos newon an emne noub lakerete tame berai. Eteke ere emne kobo lam, ere tuma nogwapeke emne wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kweikwei wobetem, eri anepoi tame eme erne yan etep wom. Yabel warbe. Gwo emi e tameken berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ne tatame emne mekinke tetan komke emne won yin awos tukte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ere emne awosein etep wom. Kerem, kem emne a newon ate. Eme erne wolam. Nema emne awos tukte, nema 200 kina rasen ek tukte. Tame eme nabe wuri yaku kerebe, eme etepkap kel ek petbe. Nerem, nema etepkapke mak pette? ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ere emne etep wolam. Kem geil mapseinke tetan? Kem ape yin la. Eme yin lan etep wom. Geil nema ep yekwo let seten, omyen sok peske seten. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jisas ere eri anepoi tame emne wom. Kem nogwape tatame emne wote. Kem kenakena si. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kau kem nogwape 100 100 sin yite. Kau kem nogwape 50 50 sin yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Simke, ere geil sok ep yekwo let, omyen sok pesken peten ere nelke neru lan, God erne pir won mesginim, ere geil sok pekayewon anepoi tame emne newom. Newom, eme peten tatame emne newopit peteyam. Sene ere omyen sok pes peten pekayewom, anepoi tame emne newom, eme peten tatame emne newopit peteyam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Etep tem, eme an se kir tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Se kir tem, geil tepken omyen tepken temenem, anepoi tame eme a tep peten sarek yewon sewurem, kworasare ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) etep pulawon yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A am tame eme nogwapewai, 500. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Agetage Jisas ere eri anepoi tame emne etep wom. Kem pere waren peik kupa keraruke kiyi taresin yi. Kem Betsaida komke yi. Eme yim, ere tatame nogwape emne emri komke sene yite wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yite wom, ere emne pir won ere kowke yawen God eterken tuma namdete yawom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Neir teketem, anepoi tame eme perek yibetem, eme peik kupa mei borke temenem, Jisas ere kena wiwi peik barke temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ere emne lam, emri pere e tewolagwu beke yi. Marye poli pere barke apekebetem. Apekebetem, eme pere ei kerelawoyim. Etep tebetem, ei berate nenbetem, ere ok luke emne late yim. Yin, ere emne sekite nenem, ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","anepoi tame eme lam, ere ok luke yibetem, eme taye piten etep wom. Oi, e kap sikiliwaske ok luke yabe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Eme erne lan kenake akem. Akbetem, agetage Jisas ere emne etep wom. Kem muresen te. Gwo aren. Kem mane akte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Etep won, ere perek yin waren sim, marye beyim. Marye beyim, eme wouken aken ep abo ep abobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kiyi Jisas ere tatame nogwape emne awos newon am, anepoi tame eme lam, eme beke abo, eme kera me eiksem. Eke eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Eme peik kupa keraru barke puk yin wun Genesaret komke yin gayin pere etek tenruwem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tenruwem, eme barke yaukwutem, tatame eme yan Jisas erne lan etep wom. Ek la. Jisas ere yawo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Etep won, eme kom komke yin let nai tewo nai tatame emne tiyke yewon sen yam, Jisas eter temenem emik etek yan rasen, ere emne eyarbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Eyarbetem, ere sewurbetem, ere kom nebuleken kom eisauken etek sewurbetem, tatame eme let nai tewo nai tatame emne peten sen yam, makle geinik rasbetem. Rasbetem, eme erne etep noub wobetem. Nema neri warten tame oub megke let kerelate. Nema kerelatek, nema yenbo tete. Etep won, eme kerelabetem, eme akei yenbo tebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Farisi tameken Juda tameken eme gwopke nenbetem. Eme let ok keyan awos ek abetem. Etep tebetem, eme etepke abobetem. An let ok keyabe, an tame yenbo temente. Etep abobetem, e yeiwarege etemri wule eme tobobetem. Eme a rasbe akek yin aom tuken sen yabetem, eme a ate nenbetem, eme let ok kiyi keyan eyaren ek abetem. Eme gerpu wolpiye, mwa ti ware, lousi, outi ware akei ok keyabetem. Yeiwarege wule eme som tobobetem. Farisi tameken Moses eteri wule wusoubetem tameken eme Jerusalemke yan, Jisas eterken wurik sim. Wurik simke, eme lam, eri anepoi tame eme awos abetem, eme let ok beke keya. Etep lan, eme etep wom. Eme let ok beke keya, eme nemri wuleke yaper nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farisi tame, Moses eteri wule wusoubetem tameken eme erne wometem. Neri anepoi tame eme yeiwarege wule beke tobo. Eme a abe, eme let ok beke keya. Beke etepkap nenbe? ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ere emne etep wom. Kem bebe tumaken yikwokwobe tame, kem ete. Kiyi God eri tuma wusoubetem tame, Aisaia, ere yeiwarege etemne bas rasem. Ere keremne kir lan, eke ere bas rasem. Ere sekenke bas rasen etep wom. Gwo tatame eme etep wobe. God ere yenbo. Etep wobe tatame eme God erne beke abo, erne pap beke yewo. Eme bepou me wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Eme tame etem nenbe wulewou wusoute abobe, eme etep wobe. Gwo wule e God eteri wule. Etep wobe tame, eme God erne bepou me sukye worabe. Aisaia ere etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jisas ere sene etep wom. Kem God eteri wule mesginim, kem yeiwarege etemri wulewou abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kem keremri wule toboten. Toboten, kem etep abobe. Nema God eteri wuleke toboten. Nema noubwaike tobobe. An kemne sekenwaike wobe. Kem God eteri wule beke tobo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses ere kiyi etep wom. Kem aken nawoken epne noub nente. Ere sene etep wom. Tame ere aken nawoken epne tuma yaper wuri wote, ete tame erne kem pen sate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Kerem, kem akeite tuma wuri etep wobe. Tame ere aken nawoken epne wos newote woye, sene ete wos ere God erne newote woye. Woye, yuri aken nawoken epe yan yen erne epne newote wos wolate, ere epne beke newo. An kemne wobe. Kem etepke tebe, kem aken nawoken epne yaper nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kem God eteri wule tousibe. Kem yeiwarege etemri wulewou toboten, ete wule kem akeite tatame emne wusoube. Kem nogwape wule yaper kir nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas ere tatame nogwape emne sene won yam, ere emne etep wom. Kem wan ras. Kem ari tuma ek met. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Tame abe awos e tame selpap yaper beke te. Berai. Tame eme selpapke abobe, eme etep nenbe o wobe, ete wos e emri selpap yaper tebe. Kem wanken, kem noub mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sene ere tatame emne mesginin akek wurim, anepoi tame eme ete sekur sakur tuma somo erne wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ere emne etep wom. Kem kir kem porereken berai. Kem beke met. Tatame eme awos abe, eme yaper beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Awos e tatame emri selpapke beke wur. Berai. Tatame eme awos abe, ete awos ere sek waren tebe. Sene ete sek tetan awos e seken eipitbe. Jisas eri wom tuma somo ere gwopkap. Nogwape aom tatame eme ate, e yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisas ere etep wom. Tatame eme be wule yaper nente o wote, ete wulek tatame eme yaper tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tatame emri selpap yaper tetan, eme wule yaper nenbe. Eme wule yaper abobe. Eme sir petbe. Eme ei naibe. Eme emri ta mesginin eme e taken sewurbe. Eme e tameri wos pette abobe. Eme epkap epkap wos yaper nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Eme tuma yikwokwobe. Eme wule beke tobo. Eme e tame wobe wos eme eger tebe. Eme tatame emne tuma yaper wobe. Eme etem maimewou abobe. Eme eike tetebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ete yaper wos tatame eme emri selpapke abobe, ete woske tatame eme yaper tebe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas ere wayen teten ere ete kom mesginin Tair yekwok yim. Yim, ere akek wurin akeite tame emne wotaken etep wom. An yawo, komri tatame emne etep mane kem wusoute. Wotaken, ere beraslawoyim. Tatame eme metem, ere yan temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Etep metem, ta wuri te eteri tuma mette yam. Ete ta te yedeyen wuri komke mesginim. Gabo ere ete yen tene gulelemenem. Ete ta te yan Jisas eri tewo tobok gulke pam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Te akeite komri ta. Kom sig Fonisia. Gulke pan, te erne etep wom. Senou. Ne ari yen tene guleleten gabo ne won pekeroukte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Etep won, ere abom. Ete ta te Juda ta berai. An Juda tatame etemne kiyi kobo lan nente. Ere etep abom, ere sekur sakur tumak etep wom. Nema yen emne kiyi newon ate. Nema yen etemri awos mane peten wale emne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Te awosein etep wom. Aneyen, yen eme awos abe, awos nebule selke yeirbe, eke wale eme yan nugen abe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ere tene awosein etep wom. Ne noub awosein woye, an neri yen tene yenbo nenye. Ne tene yin late. Gabo ere yen tene mesginye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Etep womke, te komke sene yin lam, yen te tiyke noub me tuknamenem. Gabo ere kiyi yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas ere Tair yekwo mesginin ere Saidon yekwok yin Dekapolis borborke yin Galili peik kupak yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yim, tatame eme tame wuri panen yam. Tame ere wan simenem, ere tuma beke namde, ere tuma kir eiksemenem. Eme erne panen yan, eme Jisas erne etep wom. Ne erne eyarte. Ne erne let kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jisas ere ete tame erne panen yin tatame nogwape emne mesginin yin etepwou temenem. Temenem, Jisas ere ete tame eri wan tauk let bor etek rasem, sene ere sabelokwo newon ere let bor tame eteri tawulke rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Rasem, ere nelke nerulam. Ere erne kobo lam, eke ere me pusukun, ere ete tame erne Hibru tumak etep wom. Efata. Tuma somo e neri wan piyekete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Etep wom, eri wan piyekem, tawul yenbo tem, ere tuma yenbo namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tuma yenbo namdem, Jisas ere ete tame erken epe tatame etem temenem emik sene yim, Jisas ere emne etep wom. Kem tatame emne mane wusoute. An nenye wos eisau kem mane wusoute. Ere emne wotakem, eme beke beras, eme me wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tatame eme ete tuma metem, eme wouken aken etep wobetem. Ere wos nogwape yenboke nenbe. Tame ere wan sim, Jisas ere erne eyarye, tame ere wan noub metbe. Tame ere tuma beke namde, Jisas ere erne eyarye, sene ere tuma noub namdebe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yuri tatame nogwape eme sene wurisubuk sim. Emri sen yam awos eme eyi an omom, Jisas ere eri anepoi tame emne won yan, ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","An tatame emne kobo laye. Yabel mur eme arenken tetan, emri sen yam awos eme eyi an omom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kau eme gene komke yam. An emne sene komke won yite, an emne awos beke newon an ek yite, eme kap let tewo oksubu ten keluke kermusken yate wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Etep womke, eteri anepoi tame eme erne wolan awosein etep wom. Nema geil sok mak peten emne newon ate? Gwo e tameken berai emi. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ere emne awosein wolam. Kem geil sok mapseinke tetan? Eme etep wom. Nema geil sok ep yekwo let ep yekwo let bor pes kei (7-pela) tetan. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jisas ere tatame emne etep wom. Kem selke site. Sene ere geil sok ep yekwo let ep yekwo let bor pes kei (7-pela) peten God erne pir won, geil sok ere pekayewon anepoi tame emne newom. Newom, eme peten tatame nogwape emne wosan ek newopit peteyam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Eme omyen nebule pes temenem, ere peten God erne pir won anepoi tame emne newon etep wom. Kem tatame emne wosan newopit peteyate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wosan newopit peteyan, tatame eme an se kir tem. An se kir tem, anepoi tame eme a tep peten sare ep yekwo let ep yekwo let tewo bor pes kei (12-pela) etek yewon pulawon yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A am tatame eme nogwape, 400. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jisas ere tatame emne won yim, ere eteri anepoi tameken eme yin pere peten Dalmanuta distrikke yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Eme Dalmanuta distrikke yam, Farisi tame eme yan Jisas erken tuma eikap nakwosem. Eme erne etep wolam. Ne God eteri yaku kerebe tame, ne nemne rigrabe peterate. Peterate, nema nene etepke wote, God eter nene won yam. Etep wom, eme erne seilam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisas ere etep metem, ere pap yaper tem, ere bulken ten etep wom. Gwopte tetan tatame beke eme ane rigrabe nente wobe? An kemne sekenke wobe. Gwopte tetan tatame eme rigrabe beke kip la. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Etep womke, Jisas ere Farisi tame emne mesginin yim, ere eteri anepoi tameken eme perek waren peik kupa keraruke sene wum. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Anepoi tame eme wan getem, eme geil beke peten sen ya. Geil wurisubu perek yewomenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Etep tem, Jisas ere emne etep wom. Kem noub met. Kem Farisi tameken Herotken emri bret pelbe wos, yis, kem mane pette. E wos yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Anepoi tame eme etep metem, eme etemwou etemwou eme etep namdem. Nema geil beke sen ya, ere etep woye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas ere etemri tuma metem, ere etep wom. Kem beke etep wobe? Nema geil berai. Ari mure kem beke abo, kem wan getye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kem le tetan, kem beke la. Kem wan tetan, kem beke met. Kiyi nema awosken berai, an nenem wos kem wan getem o? ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kiyi an geil sok tame nogwape, 500, emne newon am. Tep kem sare mapsein peten yewon pelawom? Eme awosein etep wom. Nema sare ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) sarek yewon pelawom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ere sene wolam. Kiyi an geil sok ep yekwo let ep yekwo let bor pes keyem (7-pela) peten pekayewon tame nogwape, 400, emne newon am, tep kem sare mapsein peten yewon pelawom? Eme awosein etep wom. Nema sare ep yekwo let ep yekwo let bor pes (7-pela) kei yewon pelawom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ere emne etep wom. Kem etep lam, sene kem ari mure beke abo. Kem me eikseye. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Eme yin Betsaida komke yin gayim, komri tatame eme le si tame erne panen yan Jisas erne etep wom. Ne gwo le si tame erne let kerete, ere yenbo tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ere le si tame erne let tobo keren panen yin kom mesginin ep kera yim. Ere ete tame eri le sabelokwo kwuspayen eri let ete tame eterne keren erne etep wolam. Ne wos labe o? ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Le si tame ere etep wom. Ye. Tatame eme yi yabe, an emne kuyese kera labe. An emne makapke labe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisas ere let eri lek sene rasen eri le yenbo tem, ere wos nogwape kuyese lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Lam, Jisas ere tame erne akeke won yin erne etep wom. Ne komke mane yin tatame emne mane wusoute. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas eter, eteri anepoi tameken eme Betsaida kom mesginin Sisaria Filipai yekwok temenem komke yim. Yim, Jisas ere eri anepoi tame emne wometem. Tame eme ane mapke wobe, an eike? ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eme erne awosein etep wom. Kau eme nene etep wobe. Ne Jon, kiyi tame emne baptais ok wirubetem tame. Kau eme nene etep wobe. Ne Elaija, God eteri kiyi temenem tuma wusoubetem tame. Kau eme nene etep wobe. God eteri tuma wusoubetem tame, ne etemri tame wuri. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jisas ere emne sene wometem. Kerem, kem ane mapeke wobe, an eike? Pita ere awosein etep wom. Ne Krais, God eter nene won yam tame. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jisas ere emne etep wom. E seken. Kem tatame nogwape emne mane etep wusoute, an Krais, God ere ane won yam tame. Kem emne etep mane wusoute. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas ere emne etep wom. An Tatame Etemne Lan Yeirim Tame, an mus kenake mette. Juda apeilakeken God eteri akek yaku kerebetem tame etemri apeilakeken Moses eri wule tuma wusoube tameken eme ane tuma namden pen sate. Pen sate, yabel mur tete, God ere ane wote, an wou sene peten sene wayen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ere emne tuma genik etep wom. Won, Pita ere erne ep kera panen yin erne etep wom. Jisas, ne etepkap mane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Etep wom, Jisas ere anepoi tame emne petkwo lan erne etep wom. Satan, ne ane seki. Neri porere e God eteri porere berai. E nowselri tatame etemri porere. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Etep wom, Jisas ere eri anepoi tameken tatame nogwapeken emne etep wom. Kem gwok ya. Yan, ere emne etep wom. Eike arenken anepoi tame yite wote, eme gwopke tete. Eme maime teitkwunte. Aren mette nenbe muskap, eme kir mette, eme beke kip ak. Tame eme etep tete, eme arenken anepoi tame yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tame eme etemne maime abote, yuri eme yaper tete. Tame eme ane kenawaike abote, eme maime wusom beke kip abo, yuri eme som noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kem mapeke abobe? Tame eme nowselri wosbas nogwape peten sene eme kerke yite, ete wos emne yenbo tete nenbe o? Beraiwai. Eme yaper tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tame eme yenbo sene tete aboye, eme kel mapke tuken sene yenbo tete? ");
INSERT INTO yss_yawu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Gwopte tatame nogwape eme God erne beke abo, eme wos yaper nenbe. Etepkap tebe, eike tatame eme ane aken sebera yabe, eme etep wobe. Ere neremri keryen berai. Etep won, eme ari tuma kir sebera yabe. Etep tebe, an Tatame Etemne Lan Yeirim Tame, an yuri sene yatek, an God eteri mureken eteri komri tame yenbo etemken yate. Ete yabelke an ete tatame emne awosein sebera yate nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisas ere emne sene etep wom. An kemne sekenke wobe. Gwopte kem gwok tetan, kau kem mak samentek, kem late, God ere eteri mureken yate nenbe, ere kom nogwape panen site. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yabel ep yekwo let ep yekwo let ges wuri kei (6-pela) temke, Jisas ere Pita, Jems, Jon emne panen kow eisauke yin yawom. Eme etemwou yawen etek temenem. Temenem, eme etep lam, Jisas eri wus kaspem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kaspem, eri warmenem tame oub kir kaspen geipawai tem. Nowselri tame eme etepkap geipa wos mapeke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Etep tem, Jisas eri anepoi tame mur eme lam, kiyi temenem tame pes, Elaijaken Mosesken epe eterken etek temenem, epe Jisas eterken tuma namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Eme lan me akem, Pita ere etep abom. An be tumake wote? Ere abolawoyin, ere bepou me etep wom. Tuma wusoube tame, nema gwotek tetan, e yenbowai. Nema ake nebule murke keren, nema gwotek temente. Neri wuri, Moses eri wuri, Elaija eri wuri nema etepke kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Etep womke, ei gwan yan emne akei subpitim, eme tuma wuri metem. Etek wom tuma ere etepke wom. E Ari Yen yenbo, adebas. Kem eri tuma noub met. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Etep wom, anepoi tame eme petkwo lam, Jisas eterwou ere temenem. Mosesken Elaijaken epe beke te, epe sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eme kow mesginin yeirbetem, Jisas ere emne wotaken etep wom. Kemri laye wos kem gwoteptek mane kiyi wusoute. An Tatame Etemne Lan Yeirim Tame. An satek, an sene wayen yite yabelke kemri laye wos kem epe wusou. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Etep wom, emri lam wos eme eikene beke wusou, eme etemwou etemwou namden etep wom. Jisas ere etep woye. An sele meike sene wayen yite. Ere mapeke ten, ere sele meike sene wayen yite? Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Eme Jisas erne etepke wometem. Moses eteri wule tuma wusoube tame eme etep wobe. God eri tuma wusoube tame Elaija ere kiyi taresin yate, Krais ere yuri tipti wun yate. Eme beke etepkap wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ere emne awosein wom. Kem sekenke wobe. Elaija ere kiyi taresin yam. Ere Krais eri yate kelu regem. Kiyi eme tuma etepke bas rasem. Tatame Etemne Lan Yeirte Tame ere mus nogwape mette nenbe. Eme erne tuma yaper wote nenbe. Beke eme etepkap bas ras? ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","An kemne wobe. Elaija ere kiyi yam. God eteri tuma bas rasemkap tatame eme etemri porerek eme Elaija erne yaper nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Eme kowke yeirin yam, Jisas eteri anepoi tame etem temenem emik yam. Yan lam, tatame nogwape eme yan anepoi tame emne teten ouyeimenem. Moses eteri wule tuma wusoubetem tame kau eme etemken ei nakwosebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tatame eme Jisas erne lam, eme wouken akem, agetage eme yin erne pir wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pir wom, ere anepoi tame emne etep wolam. Kem beke etemken ei nakwosebe? ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tatame nogwape emri tame wuri ere erne awosein etep wom. Tuma wusoube tame, an areri yen erne panen yawo. Gabo ere ete yen erne guleleten. Ere tuma rebe tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gabo ere erne guleleten, yen erne tubanepitin sabe. Ere sabelokwo bulbalken worabe, pogu takikekerabe, ere letken tewoken kiki tabe. An neri anepoi tame emne wolaye, eme gabo pekerouklawoiwo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisas ere emne etep wom. Oi, kem ane kenawaike beke abo. Yabel nogwape an keremken tetan, kem ane kenawaike beke abo. Kem yen erne gwotek arenke panen ya. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Etep womke, eme gabo gulelemenem yen erne panen yam, gabo ere Jisas erne lam, ere yen erne tubanepitin, waren, ere sabelokwo bulbalken worabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisas ere ar erne etep wolam. Yen ere yabel mapsein ere etepkap temenem? Ere awosein etep wom. Kiyi ere yekleyen temenemke, ere etepkap tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yabel nogwape gabo ere erne kerke tubanepitbetem, o peikke tubanepite warbetem. Warbetem, ere kerke eiyin sate o okke an sate, eke ere erne etep tebetem. Ne nemne pap yewon kobo late. Kap ne gabo erne kuyese pekeroukte o? ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ere erne etep wom. Ne beke etepkap wobe? Tame ere God erne kenawaike abotek, God ere kuyese nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Etep wom, agetage yen eri ar ere etep wom. An abobe. Aren kenawaike abobekap e nebule. Ne ane latek, an kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Etep wom, Jisas ere lam, tatame nogwape eme amen yabetem. Amen yabetem, ere gabo erne etep wom. Ne tuma eikse gabo. Ne wan siten gabo. Ne epe seki. Ne ete yen erne sene mane gulelete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Etep womke, gabo ere taye piten yen erne selke taren mesginin amen yim. Amen yin, yen ere let tewo oksubu tem, ere sa yenkap temenem. Sa yenkap temenem, tatame eme etep lam, eme etep wom. Ere saye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Etep womke, Jisas ere yen eri let keren erne nenewayen teteruwun, ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ere eri anepoi tameken eme akek yin wurim. Wurim, etemwou temenem, anepoi tame eme erne etep wolam. Mapeke nema gabo pekerouklawoyim? ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ere emne etep wom. Kem God erken tuma kiyi namdetek, kem gabo kuyese pekeroukte. Akeite kelu wuri berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Eme ete kom mesginin Galili distrikke yim. Yim, Jisas ere etep abom. Nema Galilike temente, tatame eme etep mane mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ere eri anepoi tame emne tuma wusoubetem, eke ere abom. Tatame eme mane mette, an gwok tetan. Tuma wusoubetem, ere emne etep wom. An Tatame Emne Lan Yeirim Tame, eme ane keresukun panen yin peiktame etemri letke rasen ane pen sate. Pen satek, yabel mur tetek, an ek sene wayen yite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Anepoi tame eme ete tuma somo beke met, eme Jisas erne wolate me akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Eme Kaperneam komke yam, eme etek wurin tem, Jisas ere emne etep wometem. Kem keluke yabeteye, kem be tumake eikap nakwosebeteye? ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Etep wom, eme tuma awosein beke wo. Eme keluke yabetem, eme etemwou etemwou etep eikap nakwosebetem. Nemri wuri eike ere apeilake? ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Eme erne tuma sein beke wo, Jisas ere sin eri ep yekwo let ep yekwo let tewo bor pes kei tame (12-pela) emne ere won yan emne etep wom. Tame ere apeilake tete abote, ere gwopke tete. Ere eter maime teitkwunen tatame nogwape etemri yaku kerete, ere apeilake tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Etep womke, ere yen nebule wuri panen yan borke teteruwun, ere erne narkeresukun emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Tame ere ane kenawaike abobe, ere gwopkap yen erne pap yewobe, ere ane kir pap yewobe. Ane pap yewobe, ere arenewou pap beke yewo. Berai. Ere arene won yam Apei eterne kir pap yewobe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ere Jisas erne etep wom. Tuma wusoube tame, nema lam, tame wuri ere neri sig wom, ere neri murek gabo pekeroukum. Ete tame ere neremri tamenowu berai, eke nema erne wotakem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisas ere etep wom. Kem mane wotakete. Tame eme areri sigke won rigrabe nente, eme ane tuma yaper agetage beke kip wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tame eme neremken ei beke nai, ete tame eme neremri tamenowu. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","An kemne sekenke wobe. Tame eme kemne lan etep abote. Eme Jisas eteri anepoi tame, nema emne kobo late. Eme etep abotek, eme kemne kelpok newon ate, God ere ete tame emne yenbo awosein nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tame wuri ere ane yenkap kenawaike abobe, sene tame wuri ere erne tuma yikwokwote, ane kenawaike abobe tame ere ane magel taite, wule yaper nente, e yaperwai. Tuma yikwokwobe tame ere wule yaper som nente wurken, eke, eme erne pape eisau wakke tenen peik meike seitin, ere etek sate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Neri let e wule yaper nente, ne neri let tem peten sepitte. Ne let wurisubu temente, etepkap ne God eri komke yin etek temente, e yenbo. Ne let pespes temente, eme nene ker tetan komke peten seitte, e yaperwai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Ete kom e ker eibe emi. Ker ere beke kip sa. Tatame eme mus eisau etek mette nenbe.) ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Neri tewo ne wule yaper nente, ne neri tewo maime tem peten sepitte. Ne tewo wurisubu temente, etepkap ne God eri komke yin temente, e yenbowai. Ne tewo peske temente, eme nene ker tetan komke peten seitte, e yaperwai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Ete kom e ker eibe emi. Ker ere beke kip sa. Tatame eme mus eisau etek mette nenbe.) ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Neri le ne wos yaper late, ne le puken seitte. Ne le wurisubu temente, ne God eteri panen siten komke yin temente, e yenbowai. Ne le peske temente, eme nene ker tetan komke peten seitte, e yaperwai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","(Ete kom e ker eibe emi. Ker ere beke kip sa. Tatame eme mus eisauwai etek som mette nenbe.) ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tatame eme akeite tatame emne tuma yikwokwon, eme God erne sene beke kenawaike abo, God ere tuma yikwokwobe tatame emne yaper nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tuma kwutebe weyeke e yenbowai. Tame eme ete weyeke kiti kerebe, kiti ere kupa beke kip te. Yuri weyeke ere tuma beke kwute, e weyeke sega e yaper. Kem weyeke tarekap temente, e yenbo. Kem etep nente, kem ei beke kip nai, kem eyar temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas ere Kaperneam kom mesginin Judia yekwok yim, ere Jordan peik keraruke wum. Wun, tatame nogwape eme yan wurisubuk sim, ere yaku sene kerebetem, emne tuma wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisi tame eme yan erne seilam. Eme abom. Nema erne tuma wuri wolate, ere kap tuma yaper awosein wote. Eme erne etep wolam. Moses eri wule mapeke wobe? Tame ere ta tene mesginte, e yenbo? ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ere emne awosein etep wolam. Kiyi Moses ere kemne be tumake wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eme awosein etep wom. Tame ere ta mesginte wote, ere siglou wuri basen ta tene newon ere tene ek won yite. Moses ere kiyi etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisas ere awosein etep wom. Kiyi Moses ere lam, kem Juda tatame kem wan gwoletem, eke ere ete wule siglouke basem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kiyisape God ere akei wosbas seikim, ere etep beke wo. God eri siglou etep wobe. God ere taken tameken seikim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Etepkap, tame ere eri anenawo epne mesginin yin ere taken etep temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Tame ere ta panete, epe wusom wurisubu temente. God eri siglou etep wobe. Epe sene kenakena berai. Epe wusom wurisubu. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Etepkap wos God ere wom, tatame epe wusom wurisubuk tete, tame eme mane pekan peske tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jisas ere ete tuma won omon, sene eme akek wurim. Wurin, ta mesginbe tuma anepoi tame etemken erne sene wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ere emne etep wom. Tame ere eteri ta mesginte, ere akeite ta panete, ere kiyi panem ta tene yaper nenbe. Ere sir yibe wule nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ta te etetri tame erne mesginin akeite tame yite, te sir yibe wule nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kau tatame eme yen nebule emne panen yam. Eme abom, Jisas ere yen emne let keren God erne womette, ere yen emne noub eyarte. Eme emne eke panen yam. Yam, anepoi tame eme etep lan, eme tatame emne wotakem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wotaken, Jisas ere etemri tuma metem, ere eike teten emne etep wom. Kem yen emne mane wotakete. Yen eme yate. Tame eme God erne yenkap kenawaike abote, eme God eteri panen siten komke yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","An kemne tuma sekenke wobe. Kemri porere yaper kem mesginte, yen eme yenbo woswou abobekap, kem etep abote. Kem etep tete, kem God eri komke yin eterken temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Etep womke, ere yen emne wurare wurare peten eteri ku luke siruwun let keren etep wobetem. God ere kemne noub eyarte. Etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas ere keluke sene yite nenbetem, tame wuri ere yan gulke pan erne etep wometem. Tuma wusoube tame, ne tame yenbo. Be wule yenbo an nente, an noub som temente? ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas ere erne awosein wolam. Beke ne ane tame yenbo wobe? Gwote nowselri tatame eme eike tame yenbo beke wuri te. God eterwou ere yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ne God eteri wule kiyi metem. Eri wule etep wobe. Tame eme alwo mane pete. Eme sir mane pette. Eme ta sir mane yite. Eme tuma mane yikwokwote. Eme anenawo etemri tuma noub meten tobote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Etep womke, ete tame ere awosein etep wom. Tuma wusou tame, an yen nebule ten yan, gwopte an aneyen tem, an God eri wule noub toboten. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas ere erne lan kobo lam, ere erne etep wom. Wos wuri ne sene nente. Ne yin neri nogwape wos tatame eme tukte. Tukte, kel ne pette, ne eikse akse tatame emne newote. Newotek, ne yan arenken sewurte. Yuri ne God eteri komke yin temente, yenbo wos ne etek pette. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ete tame ere Jisas eri tuma metem, ere bitimi yaper tem. Bepou berai. Ere kelworken tame. Eke ere pap yaper ten yim. Jisas ere erne womkap ere beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ere yim, Jisas ere anepoi tame emne lan etep wom. Kelworken tame eme emri wos kenake abobe, eme God eri panen siten kom mapeke yite, God ere etepkap tame etemne wobe. Kem yaku eisau keren, kem ari komke yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Etep wom, eri anepoi tame eme eri tuma meten wouken akem. Jisas ere sene wom. Areri yen, kelworken tatame eme God eri komke yite, eme yaku eisau kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel por ere por eisau. Kamel ere mate kapebe lag taukke wurte wote, ere kuyese wurte. Ere kelworken tame etem God eteri komke yite kerebe yakukap beke kere. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Anepoi tame eme etep metem, eme wouken aken etep wom. Kelworken tame eme God eri komke kuyese beke yi. Eke eike tatame eme God eteri komke yite? ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ere emne noub lan etep wom. Tatame etem eme tatame emne kuyese beke kip wo, eme God eri komke beke kip yi. God eterwou ere tatame emne won eme eteri komke yite. Wos nogwape God ere kuyese nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita ere etep wom. Metye. Nerem, nema wos nogwape mesginin nerenken anepoi sewurbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisas ere etep wom. An kemne seken wobe. Ane abobe tame eme emri ake, lakemase, naregeisi, anenawo, yenta, wos nogwape mesginin ari yaku keretek, ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gwopte ete tame emne God ere awosein eyar nente. Eme wos nogwape pette. Eme ake, lakemase, naregeisi, anenawo, yenta pette. Pette, akeite komri tame eme emne yaper nente. Emne yaper nente, yuri eme God eteri kom etek noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Gwopte tatame kau eme sig eisau tetan. Yuri eme sigken berai tatame tete. Eme bepou me tete. Kau bepou me tetan sigken berai tatame yuri eme sig eisau pette nenbe. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisas ere Jerusalemke yibetem, anepoi tame eme erne semowun yite wom, eme me akem. Akeite tatame eme kir akem. Bepou berai. Eme etep abom. Eme Jisas erne pete nenbe, eke eme akem. Akem, Jisas ere anepoi tame emne panen tatame emne mesginin yim. Yim, yuri tatame eme erne yaper nente, eke ere etemken tuma etep namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ere etep wom. Metye. Gwopte nema Jerusalemke yaute. An Tatame Emne Lan Yeirim Tame, eme ane keresukun panen yite. God eteri akek yaku kerebe tame etemri apeilake etem, Moses eteri wule tuma wusoube tame etemken eme ane panen yite. Eme ane pen sate, akeite tame eme Juda tame berai, etem ane pette. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ete tame etem ane tuma namdete, ane sabelokwo soboyewote, eme ane pete. Eme ane pen sate. Sate, yabel pes tetek, kwokwos an sene wayen yite nenbe. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jemsken Jonken epe Sebedi eteri yen, epe Jisas eterne yan etep wom. Tuma wusoube tame, ne nesne wos wuri nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ere epne etep wolam. Be wos an kepne nente? ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Epe erne etep wom. Yuri ne keryen tete, ne wolbaye eisauke tatame emne etek panen site, nesa aboye, neset emne kir panen site. Neset nerenken site. Wuri neri pi seit yekwok site, wuri ya gwaimek site. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ere epne etep wom. Kepri wolaye tuma kep noub beke abo. Eme ane yaper nente, an mus mette, kap kep ari mette muskap etep kir kuyese mette o kep ane mesginte? Kep mus mette, e ok yaper abekap, o ok wirubekap. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Epe awosein etep wom. Nesa kir mette. Ere epne etep wom. Ye. Yuri ari abe ok yaperkap kep kir ate. Yuri ari mette muskap kep kir mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aren, an beke kip wo, eike ari ya gwaimek site, o pi seit yekwok site. E ari yaku berai. God eterwou ere wote, eike etek sin ete yaku kerete. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Anepoi tame ep yekwo let ep yekwo let eme ete tuma metemke, eme Jemsken Jonken epne tuma yaper wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisas ere emne akei won yan emne etep wom. Nowselri apeilake eme etemri kulke tetan tatame emne yaku eisau newobe. Eme yaku beke kip kere, keryen eme emne paku pebe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Emri nenbekap, kem etepkap mane nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kem apeilake tete abote, kem yaku kerebe tamekap tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","An Tatame Etemne Lan Yeirim Tame an etepwou nenbe. An yam, an etep beke wo. Tatame eme ane yaku kerete. Berai. An yam, an etemri yaku kerete yam. An tatame emne kobo late yam. Eme ane pen sate, an emne tuken emri nenbe wule yaper peten sepitte. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas eter, eri anepoi tameken tatame nogwapeken eme Jeriko komke yim. Yin, eme sene mesginte nenem, le si tame ere kelwor wometbetem tame, ere kelu ganke simenem. Ete tame eri sig Bartimeus. Ere Timeus eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ete tame ere metem, Nasaret komri tame, Jisas, ere yam. Etep meten, ere erne muresen ten etep wom. Jisas, ne Devit eteri nan, ne ane kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tatame nogwape eme erne wotaken etep wom. Ne elen te. Etep womke, ere sene muresen ten etep wom. Devit eteri nan, ne ane kobo la. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisas ere yibetem, ere etep metem, ere teten eri anepoi tame emne etep wom. Kem ete tame erne won ya. Eme yin le si tame erne etep wom. Ne mane akte. Ne epe wayen tet. Jisas ere nene etep wobe, ne yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Le si tame ere mate maukun simenem. Ere ete tuma metem, agetage ere mate lugrasen teten Jisas erne late yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yim, Jisas ere erne wometem. Ne aboye, an nene beke nente? Ere awosein etep wom. Tuma wusoube tame, an abobe, ne ari le noub sene eyarte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisas ere erne etep wom. Ne sene yi. Ne ane kenawaike aboye. An neri le noub eyarte nenbe. Ne ane kenawaike aboye, eke neri le kuyese sene late. Etep wom, agetage eri le yenbo tem, ere kuyese lam. Lam, ere Jisas erne semowun yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas eter, eteri anepoi tameken eme Jerusalem mekinke yibetem, eme Oliv kowke tetan kom petem. Kom pes petem, Betfageken Betaniken. Petem, ere eri anepoi tame pes epne won yim, epne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kep ete kom mekinke yin wurte, kep late, donki por yen etek kepke tenten. Ete donki por yen tame eme eri magel etek kiyi beke si. Kep yin kep ogwon donki por panen yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kep ogwobetete, kap tatame emri wuri ere kepne wolate. Kep beke donki por yen kep ogwobe? Etep wolate, kep erne awosein etep wote. Aneyen ere yakuken, yuri nema donki sene panen yate nenbe. Kep etepke wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Epe ete komke yin wurim, epe donki por lam. Ere kelu ganke temenem, ake eruke tenmenem. Epe lam, epe donki por yen kep ogwobetemke, ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","kau tame mekinke tetemenem, eme epne etep wolam. Beke kep donki por yen kep ogwobe? ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jisas ere kiyi wom tumakap epe emne awosein etep womke, eme epne kir tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kir ten, epe donki por yen ogwo peten panen yin Jisas erne newom. Newom, emri warmenem tame oub eme donki por yen eri magel luke petan Jisas ere yawen etek sin ek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yibetem, tatame nogwape eme emri warmenem tame oub lug peten keluke petan yibetem. Kau eme me ku kayen sen yin keluke petan yibetem. Eme etep abom. Jisas ere neremri Keryen. Eke eme etep nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Eterken taresimenem tatameken tiptiwumenem tatameken eme nobke etepke tebetem. Hosana, nema Keryen God erne metekwasbe. God eter won yam tame ere yabe. God ere erne yenbo nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Neremri warege Devit eteri nan ere nemne kom panen site nenbe. God ere eteri kom panen site yaku eyarte nenbe. Hosana. Nema God eteri sig eisau wobe. Eme etepke wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas ere Jerusalemke yin wurin, ere God eri ake eisauke wurin lan sewurem. Yabel warbetem, ere eteri abom yaku beke kere. Ere eteri anepoi tame (12-pela) etemken eme Betani komke sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kwokwos eme Betani kom mesginin Jerusalemke sene yibetem, ere kwoi sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kwoi sam, ere lam, yipige kaike tetmenem, take nogwape temenem. Etep lan, gelame kwutan ate yim. Yin lam, takewouke temenem. Gelame mak yamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mak yamenem, ere yipige erne etep wom. Tatame eme gelame sene beke kip a. Etep wom, anepoi tame eme eter wom tuma metem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Eme Jerusalemke yam, Jisas ere God eteri ake eisauke wurin lam, tatame eme kel petbe yaku etek kerebetem. Etep lam, ere emne ake tuma won eme bokem. Kau tame eme kel natokwo kerebetem, ere etemri kel rasbetem tiy peten legalepitim. Ap tukbetem tame emri ap rasbetem tiy ere kir peten legalepitin warem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Legalepitin warem, tatame eme wosbas sen ake purik yi yabetem, ere emne etep wotakem, eme kenakena yikwutem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wotaken, sene ere tatame emne etep wosoubetem. Kiyi temenem tame eme God eri tuma etep bas rasem. Areri ake eisau komri komri tatame nogwape eme etek yan arenken tuma namdete. Etep bas rasem, kem etep beke nen. Etep tebe, kem God eteri ake e sir petbe tame etem berasen sibe akekap tebe. Etep wom, ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","tatame nogwape eme Jisas eteri tuma meten wouken akem. God eteri akeri apeilakeken Moses eteri wule wusoubetem tameken eme etep lam, eme akem, eme erne pen sate kelu sopem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Neir teketebetem, Jisas eteri anepoi tameken eme Jerusalem mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tuknan ei beram, keru eme keluke sene yibetem, eme yipige erne sene lam. Lam, ere san sok ten tetemenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jisas ere yere wom tuma Pita ere etep sene abom, ere erne etep wom. Tuma wusoube tame, ne ek la. Yere ne yipige me erne wom, ere me sam. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisas ere awosein wom. Kem God erne kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","An kemne seken wobe. Tame ere etep abotek, ere kow erne etep wote. Kow, neren kena yesen peikke warte. Etep wote, tame ere porere pes mane tete, ere God eterwoune som abotek, kow ere kerem wobe tumakap ere etep tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","An kemne wobe. Kem God eterken tuma namdete, erne wolate, kem erne kenawaike etep abote. Areri wolaye wos an pette nenbe. Etep abote, kem wolabe wos pette. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kem som tetan God erken tuma namdete, tame ere nerene pap wayete, kem etep abote, kem yin eterken tuma namden gerute. Kem etep tetek, kemri Hevenke tetan Apei ere keremri nenbe wule yaper sene beke kip abo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Tame eme kemne yaper nente, kem beke geru, keremri Hevenke tetan Apei ere kemri yaper nenbe wos som abote. Ere etep wom.) ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Eme Jerusalemke sene yam, Jisas ere God eteri ake eisauke wurin sewurbetem, God eteri akek yaku kerebetem tame etemri apeilake, Moses eri wule tuma wusoubetem tameken, Juda etemri apeilake eme erne late yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Late yam, eme erne etep wolam. Nereri yaku eike nene wom, ne ete yaku kerebe? Eike nene won yam? ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ere emne awosein etep wom. An kemne tuma wuri kiyi wolate. Kem ane kiyi wusoutek, an etepwou, an kemne ek wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kem metem, Jon ere yam, ere tatame emne baptais ok wirubetem. Eike erne ete yaku kerete won yam? God ere erne won yam, o tatame etem erne won yam? Kem ane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eme etep metem, eme etemwou etemwou namden etep wom. Nema mapeke wote? Nema kuyese mane etep wote, God ere Jon erne won yam. Nema etep wote, Jisas ere nemne etep wote. Beke kem Jon eri tuma beke met? ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nema kuyese mane etep wote, tatame etem Jon erne won yam. Nema etep wote, tatame nogwape eme nemne tuma namdete. Tatame eme etep wobe. Jon ere God eteri tuma wusoubetem tame yenbo. Nema tatame emne akbe, eke nema etep beke kip wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Etemwou etemwou namdem, eme Jisas erne etep wom. Eike erne won yam, nema beke met. Ere emne awosein wom. Kem ane beke wo, an kir. Eike ane won yam, an gwote yaku kerebe, an kemne beke kip wo. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas ere Juda apeilake emne sekur sakur tuma etep wom. Tame wuri ere wain now nenem, ere waren supa nanekwom, ere bou peikem. Sene ere wain supa ok wulte okmoi wuri perem. Wulbe ok e wain ok. Perem, sene tame eme sin now noub lakerete ake wuri keren, tiy mekerke petam. Petan, ere kel yaku kerebe tame emne ete now lakerete wom. Ere etep wom. An gene komke yite. Kem ari now yaku keren noub lakerete, yuri an kemne wain supa ek newote. Etep womke, now maime ere gene komke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Yim, yuri wain supa okwon yamke, maime ere eri yaku kerebe tame wuri erne won yim, now lakerebe tame emne late yim. Ere now maime erne wain supa kwotete yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yim, now lakerebe tame eme yaku kerebetem tame erne keresukun, eme erne paku pen won yim. Ere sene yim, ere letsubu yim, ere wain supa beke se. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yim, maime eri yaku kerebe tame wuri erne sene won yim, eme erne lan tare bulan tuma yaper wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wobetem, now maime ere yaku kerebe tame wurinabu sene won yim, ete tame erne eme me pen sam. Pen sam, now maime ere yaku kerebe tame nogwape emne wurare wurare won yim, kau emne eme paku pebetem, kau emne eme me pen sabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Etep tem, now maime eteri yen seken, wurisubuwai eterken temenem. Ere erne metekwasbetem, ere etep wom. Ari yen seken eri tuma eme mette. Etep wom, ere yen erne won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Won yim, now lakerebe tame eme yen erne lam, eme etemwou etemwou etep namdem. Yuri gwote yen ere ar eri now pette. Nema erne pen sate, ere yuri pette wos nerem pette. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Etep womke, eme erne pen sam, eri kupa eme now kopok sepit wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisas ere sekur sakur tuma wusowumke, ere emne wolam. Now maime ere now lakerebe tame emne beke nente? An kemne wobe, ere yan ete tame emne pen sate, ere akeite tame emne ete now newote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aren woye tuma e kiyi temenem tame etem basem tumakap. Ete tuma eme etepke basem. Tame eme ake kerem, eme kiyi sepitim kwat sene peten ake etek kerem. Ete kwat erne eme nawo kwat etek yewom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Keryen God ere ete nawo kwat yenbo emne peteram, nema etep lam, nema abom. Ere yenbosubuwai nenem. Eme etep basem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Juda tame etemri apeilake eme eri wom sekur sakur tuma metem, eme etep abom. Ere neremneke wobe. Nema now lakerebe tamekap. Eme etep abomke, eme erne keresukte wom. Eme tatame nogwape etemne akem, eke eme erne beke keresuk. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yuri Jisas eri peiktame eme abom. Nema erne tuma wuri yikwokwon wolate. Ere nemne tuma yaper awosein wote, nema erne keresukun ake yaperke won wurte. Etep abom, eme Farisi tameken apeilake Herot eteri yaku kere tameken emne won yim, eme Jisas erne tuma wuri wolate yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yim, eme erne etep wom. Tuma wusoube tame, ne tuma sekenwou wobe tame. God eri tuma ne tatame emne wusoube, ne noub wusoube. Kau tuma ne beke beras. Ne tatame emne beke ak. Eke tatame emne ne wule wurisubuwou peterabe. Ne nemne wusoute. Keryen Sisar ere akeite kantriri tame, ere Rom tame. Ere nemne kom panen siten, ere nemne takis raste wobe. Nema be wos nente? Nema Sisar eterne takis kel newote, o nema eterne beke kip newo? Ne nemne noub wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ere emri selpap yaper lam, eke ere emne etep wom. Beke kem ane seilabe? Kem kel wuri sen yan ane peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eme kel wuri sen yan peteran, ere lan emne etep wolam. Gwo kel e tame wouken tame sigken basten. Kap e eikeri wouken, eikeri sigken? Eme sein etep wom. E Romri Keryen Sisar eteri wouken, eteri sigken. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ere emne etep wom. Kem yenboke woye. Sisar eri wos kem Sisar eterne newote. God eteri wos kem God eterne newote. Eme eteri tuma metem, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusi tame eme etep wobetem. Sa tame yuri eme sene beke kip wayen yi. Etemri kau eme Jisas erne late yam, eme erne etep wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tuma wusoube tame, kiyi Moses ere nemne etep basem. Tame ere ta panete, epe yen beke se, ere bepou me sate, eri mase ere eri wane tene panen yen sete. Yen sete, ete yen eme etep wote. E lake eteri yen. Moses ere etep kiyi basem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kiyi lakemase eme ep yekwo let ep yekwo let pes eme temenem. Mase tobo yen ere ta panem. Yuri epe yenken berai, ere bepou me sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Samke, mase ere wane tene panem, epe yenken berai, ere bepou me sam. Bor tame ere etepwou tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sene mase eme etepwou etepwou tebetem, eme wane tene panebetem, eme yenken berai, eme bepou me saiwom. Yuri ta etet te kir sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kem etep wobe. Sa tame eme wou sene wayen yite. Etepkap lakemase ep yekwo let ep yekwo let bor pes keyem (7-pela) eme ete ta tene panem. Yuri ete ta te eikeri ta seken tete? Eme erne etep wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas ere emne awosein etep wom. Kem porere yenbo berai. God eteri siglou, eteri mure kem beke la, eke kem porere yenbo berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yuri sam tame eme sene wayen yite, eme sene beke kip ta pane, ta eme tame beke kip nar. Eme God eteri komri tamekap tete, ta eme tame beke kip nar, tame eme ta beke kip pane. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Sam tame eme sene wayen yite, Moses ere etep kiyi basem. Kap kem beke la, o kem wan getem. Moses ere ker eibetem me nebule mekinke tetemenem, God ere erne etep wom. An neri yeiwarege Abraham, Aisak, Jekop etemri Keryen God. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ete yeiwarege eme kiyi sam, sene etemri wou God eterken tetan, God ere etep wom. Eke nema metten, tatame eme san sene etemri wou God eterken temente, God ere ete tatame etemri Keryen temente. Eke God ere kelpe tatame etemri Keryen God. Ere sam tatame etemri Keryen God berai. Keremri woye tuma e seken berai. Kem yaperwaike woye. Ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jisas ere Sadyusi tame etemken tuma namdem, Moses eteri wule wusoubetem tame wuri ere yan wan rasem. Wan rasem, ere metem, Jisas ere tuma yenbo awosein wobetem. Eke ere erne etep wolam. Be wule e eisauwai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisas ere awosein etep wom. Wule eisauwai ere gwopkap. Israel tatame, kem met. God ere wurisubu eterwou ere Keryen. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kem Keryen God erne metekwaste. Keremri selpap, porere, wusom, mure kem eterwoune newote. Ete wule e eisauwai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wule pes wuri ere gwopkap. Ne maime wusom noub nenbekap, ne tatame emne etepkap noub nente. Ete wule pes epe eisau, akeite wule eme nebule. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","God eteri wule wusoubetem tame ere erne etep wom. Tuma wusoube tame, ne tuma seken woye. God ere wurisubuwai tetan. Akeite keryen beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nema God erne kenawaike metekwaste, nemri selpap, porere, wusom, mure nema erne newote, e yenbowai. Nerem maime yenbo nenbekap, nema tatame emne etepkap nente, e yenbowai. Ete wule pes eisauwai e sipsip peten botkwun lisin God erne newobe wule teitkwunbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Etep wom, Jisas ere abom. Ete tame ere porereken. Etep abom, ere erne wom. Ne noub aboye, ne God eteri wakse tete kerake teye. Etep wom, tatame eme erne tuma sene wolate me akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas ere God eteri ake eisauke temenem, ere emne tuma wuri etep wusowum. Moses eteri wule wusoubetem tame eme etep wobe. God eri won yam tame Krais ere Keryen Devit eteri nan tete. Beke eme etepkap wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kiyi Krais ere nowselke mak yamenem, God Eri Wou ere Keryen Devit erne gulelem, Devit ere etep wom. Keryen God ere areri Aneyen erne etep wom. Ne Aneyen, ne ari let pi seit yekwok site. Site, ne nereri peiktame emne teitkwunen, emne kom panen site nenbe. Ere etep basem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit eter ere Krais erne Aneyen wom. Kerem, kem etep wobe. Krais ere kiyi beke te. Ere Devit eteri nanyen tete. An etep wobe. E seken berai. Devit ere Krais erne Aneyen wom, mapeke Krais ere Devit eteri nanyen tete. Tatame nogwape eme ete tuma etep metem, eme metekwasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas ere tatame emne sene etep wusowum. Moses eteri wule wusoube tame etemri nenbe wule yaper kem noub late. Eme abobe, tatame eme emne late, eke eme tame oub lagwu waren ek sewurbe. Eme abobe, tatame eme emne pir wote, emne tame yenbo wote, eke eme kom geinik sewurbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Eme God eteri akek wurbe, eme abobe, eme apeilake etemri wolbayek site. Eme a eisau abe yabel, eme abobe, eme apeilake etemri sibe emi yenbok sin a ek ate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eme wane ta emne tuma yikwokwon etemri ake sirke petbe. Sene eme etemri nenbe wule yaper beraste abobe, eme God eteri ake eisauke yin wurbe, God eterken tuma eisau namdebe. Etep tebe, eme abobe. Tatame eme etep labe, eme nemne tame yenbo wote. Eme etep tebe, an wobe, God ere ete tame emne yuri yaperwai nente nenbe. Ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas ere kel yewobetem ou ganke simenem, ere lam, tatame eme kel sen yan ouke yewobetem. Kelworken tatame nogwape eme kel nogwape yewobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ere lam, wane ta wuri te kelken berai, te kel nebule peske sen yan yewom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ere lam, ere anepoi tame emne won yan emne etep wom. An tuma sekenke wobe. Kelken tatame eme kel nogwape yewoye. Kelken berai wane ta te kel nebule peske yewoye, teri yewoye kel pes e nogwape tame emri kel epwei teye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kelworken tatame eme kel kerake yewoye, nogwape som akek tetan. Wane ta te kel nogwape berai, teri a tukbe kel te akei eyi yewon omoye. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas ere God eteri ake eisau mesginin yim, eri anepoi tame wuri ere erne etep wom. Tuma wusoube tame, gwote ake, God eteri ake e ake yenbowai. Ake eme papek kerem, pape yenbowai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisas ere awosein etep wom. Kem gwote ake eisau laye. Kiyi eme gwote ake kerem, eme pape peten yopen yawom. Yuri ete pape eme akeite pape luke beke kip te. Eme akei beran petewarte nenbe. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas ere Oliv kowke yawen sin God eteri ake eisau lam. Etek simenem, Pita, Jems, Jon, Andru etemwou eme eterken yawen temenem. Temenem, eme erne wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ne woye, tame eme God eri ake eisau berate. Be yabelke eme etep tete? Be wos nema kiyi lan abote, eme God eri ake ek berate? Ne nemne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ere emne etep wom. Kem eisa eisa. Tame wuri ere kemne mane yikwokwote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nogwape tame eme yuri yan areri sigke wote. Eme tuma yikwokwon etep wote. An Krais, God ere ane won yam tame. Nogwape tatame eme emri yikwokwobe tuma worwor mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yuri kem late, tatame eme ei naite. Mekinke tetan tatame, genek tetan tatame eme ei naite. Kem etep mette, kem mane ep abo ep abote. E nowsel yaper tete yabel berai. Nowsel yaper tete yabel ere yurik tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yuri kom wuriri tatame eme akeite komri tatame etemken ei naite. Keryen wuri eri wakseken eme akeite keryen eri wakseken eme etep ei naite. Nina kom komke yate nenbe. Tatame eme nakwoi meig site nenbe. Ete wos e ta te yen warwite tasen metbe muskap. Yuri yaper wos nogwape etepke tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kem eisa eisa. Kau tame eme kemne pap wayen tuma namdete nenbe. Eme kemne God eteri ake etek paku pete nenbe. Kem met. Kem areri anepoi tame, eke eme kemne apeilake etemri kaunsil etemri bitimik won tetete nenbe. Etep tetek, kem areri tuma yenbo emne etek wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","God eri tuma akei komri komri tatame eme akei kiyi mettek, yuri nowsel yaper tete yabel ek tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yuri eme kemne tuma namdete panen yite, kem mane akte. Kem mane etep abote. O, nema be tumake awosein wote? Ete yabel God ere kemne tuma peterate, kem ete tuma awosein wote. Kerem wote tuma e keremri tuma berai. God Eteri Wou ere kemne gulelete, kem tuma awosein kuyese wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tame eme emri lakemase emken akeite tameken emne won yite, eme lakemase emne tuma namden pen sate nenbe. Ane eme yen emne etepwou nente. Yen eme anenawo emne magel taite, emne akeite tamene won yite, eme emne pen sate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kem ane kenawaike abote, eke tatame nogwape eme kemne pap wayete nenbe. Etek yaper tete yabel omote, ane som abobe tatame etemwou eme noub som temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jisas ere etep wom. Yuri kem late, tame wuri ere wos yaperwai God eteri akek raste nenbe. Kem etep late, kem Judia distrikke tetan tatame kem kowke amen yin tete. Kem gwote siglou labe tatame, tuma somo kem noub abote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tame ere ake makle ege simente wote, ere ete wos yaper late, ere agetage amen yite. Ere ake mane wurin be wos be wos mane pette. Ere epitage kuyese beke kip pet, eke ere mane wurin pette, ere yaper tete wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tame ere nowke temente wote, ere ete wos yaper late, ere agetage amen yite. Ere eri akek mane wurin eri tame oub mane pette. Eri tame oub ere epitage beke kip pet, eke ere mane wurin pette, ere yaper tete wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ete yabel an yenken ta, yen muk newobe ta emne abote. Eme kuyese agetage beke kip ame. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ete wos ere mou tete yabelke tete wote, kem mapeke ame? Kem God erne tuma wolate, ete wos yaper ere mou tibe yabelke mane tete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ete yabel wos yaper nogwapewai tete nenbe. Kiyi etepkap wos yaper beke te. Kiyisape God ere nowsel seikin yam, gwopte kir, etepkap wos yaper beke temen. Ete wos yaper omote, sene etepkap beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ete yabel God ere borke beke regte wom, akei tatame eme pauk saiwote wom. Eke God ere eter kenem tatame etemne abom, yuri ere ete yabel borke regte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ete yabel tatame eme kemne etep wote. Ek la. Gwo Krais. Etep wote, emri tuma kem mane worwor mette. Emri wote tuma e me yikwokwobe tuma. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nogwape tame eme yan kemne tuma yikwokwon etep wote. An Krais, an God eteri tuma wusoube tame. Eme yate, eme rigrabe nente, eme etep abote. An rigrabe nente, God eri kenawaike abobe tatame eme ari yikwokwobe tuma worwor mette. Etep abote, God erne kenawaike abobe tatame eme emri tuma worwor mette. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kem eisa eisa. Yuri tete wos an kemne kiyi wusouye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ete yabel eri yaper tete wos omotek, agetagewai yabel ere neirkap teketete, lup te beke kip pas. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sow eme nelke tetan, eme yesen yeirkwutete. Nina ere nelke yate, nelri wos eme birbetan kenakena yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Etep tementek, sene eme late, agetage Tatame Etemne Lan Yeirim Tame, an yate. An nel geike yate. An mureken tamekap yate, an keryenkap yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yatek, an God eri kom tame emne won yite, eme you yale ekte ekte eme etek yite, eme God eri kiyi kenem tatame emne akei panen yan wurisubuk site. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Metye. Kem kwar kepken mok walkuken abote. Kwar kepken mok walkuken yeirbe, kem etep wobe. Nabe tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ari kiyi wom tuma e etepkap, kem etep abote. Ari yate yabel mekin mekinye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","An kemne sekenke wobe. Gwopte tetan tatame eme mak samente, ari kiyi woye wos eme kir late nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nelken selken akei omote nenbe. Areri tumawou e som temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Aren sene yate yabel tatame eme beke met. God eteri komri tame eme etepwou beke met. Aren, an God Eteri Yen, aren etepwou an beke met. God eterwou ere metten. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kem beke met, be yabelke an sene yate, eke kem eisa eisa. Kem noub lakerete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ete yabel ere gwopkap. Keryen ere kom mesginin gene komke yim. Yite womke, ere yaku kerebetem tame emne yaku petera sewuren emne etep wom. Kem wos lakerebetete. Etep wom, ere ake eru lakerebetem tame erne etep wom. Ne ake eru noub lakerete. Etep won, ere mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jisas ere etep wom. An ete keryen eterkap. Be yabelke ake maime ere sene yate, kem beke met. Yabel wartek ere yate, o neir borke ere yate, o kwokwo wobetetek ere yate, o ei berabetetek ere yate o? Etepkap kem eyar noub lakerete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ere kemne agetage yan late, kem mane tuknamente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","An kemne wobe tumakap, an tatame nogwape emne wobe. An etep wobe. Aren yate yabel kem noub lakerete. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kiyi Juda tatame eme kantri Isipke temenem, God ere emne kobo lam. Nabek nabek eme ete yabel abobetem, tewo pes eme awos eisau abetem. Awos eisau abetem yabel wuri eme etep wobetem. Pasova Yabel. Yabel wuri eme yisken berai geil abetem, eme ete yabel sig etep wobetem. Yisken berai geil abe yabel. Yabel pes mak temente, yuri ere ege si yabel yate nenbe, ete yabel God eteri akek yaku kerebe tame etemri apeilakeken Moses eteri wule wusoubetem tameken eme etep wom. Nema Jisas erne elen berasen yin keresukun erne pen sate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Awos eisau ate yabel nema erne mane keresukte. Tatame nogwape eme awos eisau ate yam. Nema erne keresukte, eme mane late, eme mane mo won eiken naite. Eme tuma etepke namderasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas ere Betani komke temenem, ere kiyi numa pemenem tame Saimon eteri akek yin temenem. Etek temenem, ere a abetem, ta wuri te yam, te papek nenem gin sen yam. Gin e kwar yenbo, kel eisauke tukbe kwar yewomenem. Te yan, gin bureren kwar Jisas eteri tarek sirem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sirem, kau tame eme etep lan, eme pap wayen etemwou etemwou etep wom. Beke ete kwar te bepou me sirpitiye? ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ete kwar e tokwo eisauke tukem. Ete kwar te kel natokwo kerete woye, te kel nogwape peten wosken berai tatame emne newote woye. Eme ta tene etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisas ere metem, ere etep wom. Kem beke tene etepkap tuma wobe? Kem tene tuma mane wote. Te ane yenboke nenye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wos berai tatame eme keremken som temente, kem emne tewok tewok kuyese noub nente. Aren, an keremken som beke kip te, eke te ane yenbo nenye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tame sabe wule kem tame kupa kwar pebe. An mak saten, gwote ta te ete kwar ari wuske sirye, yuri an sate, eme ane sele meike raste. Te etepkapke peteraye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","An kemne sekenke wobe. Eme ari tuma yenbo kom nogwapek yin wusoute, gwote ta teri nenyekap eme kir wusoute. Kem etep abote. Ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Anepoi ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) etemri wuri, Judas Iskariot, ere God eteri akek yaku kerebetem tame etemri apeilake emne late yim. Yim, eme Jisas erne keresukte wom, ere emne etep wom. An kemne Jisas erne peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Etep wom, eme etep metem, eme metekwasen erne etep wom. Ne etep tete, nema nene kel newote. Etep won, ere yin Jisas erne keresukte kelu sopte yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Awos eisau abe yabel, taresibe yabel, tatame eme yisken berai geil abetem. Ete yabel sipsip yen wuri eme botkwubetem, eme kisin etep abobetem. Kiyi God ere nemri yeiwarege emne beke pe, ere emne noub eyarbetem. Etep abobetem, eme a eisau abetem. Ete yabel Jisas eteri anepoi tame eme yan erne etep wolam. Pasova awos nema mak ate? ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ere anepoi pes epne etep wom. Kep kom sagke yite. Yin kep tame wuri late, ere gin okken wuri semente. Kep erne late, kep erne semowun kir yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ere akek wurtek, kep ete ake maime erne etep wote. Tuma wusoube tame ere etep woye. Awos ate emi ma? An Pasova awos ari anepoi etemken ate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Etep wote, ake maime ere ake puri eisau, iye yekwok tetan ake puri kepne peterate. Tame eme ete ake puri kiyi eyarem, awos abe tiyken wolbayeken etek tukten. Kep nemri awos etek nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Etep wom, epe kom sagke yin ere womkap etep lam, epe Pasova awos etek nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yabel warbetem, Jisas eter, eri anepoi tameken eme ek yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yan, eme awos abetem, ere etep wom. An kemne tuma sekenke wobe. Keremri tame wuri, neremken abe tame, ere ane yena tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Etep wom, eme pap yaper tem, eme wurare wurare wolam. Kap ne arene wobe o? ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ere emne wom. Kem tame ep yekwo let ep yekwo let tewo bor pes keyem tame (12-pela). Keremri tame wuri, ere arenken nesa ware mei let peske warte, ete tame eter ere ane yena tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","God eteri siglou ere arene etep wom. Tatame Etemne Lan Yeirim Tame erne nema pen sate nenbe. Etep wom. Ane yena tete tame yuri ere mus nogwape mette nenbe. Nawo te erne beke pauk warwi, ere mus eisau beke pauk met. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eme abetem, Jisas ere geil wuri peten ere God erne pir won pekayewon anepoi tame emne newopit peteyan etep wom. Kem peten a. Gwo areri om. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","An, ere sene ok ware wuri peten God erne pir won emne wain ok newon am. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ere emne etep wom. Gwo areri nep. Eme ane pen sate, ari nep yeirte. Yeirte, e tatame nogwape emne peterate, God ere namderasem tuma e seken tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","An kemne sekenke wobe. An gwote selke temente, wain ok an sene beke kip a. Yuri an God eteri panen siten komke temente, an etepkap ok yenbo etek ate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Etep womke, eme God erne sekwo wuri lomen eme ek woran Oliv kowke yin yawom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas ere emne etep wom. Kiyiri tame eme God eri siglou basen etep wom. God ere sipsip lakerebe tame erne pete, sipsip eme amekirin yikwute yakwutete nenbe. Etep basem. Kem etepke tete nenbe. Kem ane magel tayen amen yite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","An sate, an sene wayen yite, an kemne Galili distrikke kiyi taresin yin koute. Yuri kem tipti wun yate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita ere erne etep wom. Aren, an nene magel beke kip tayen amen yi. Tame nogwape eme etep tete, aren an etep beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisas ere erne etep wom. An nene sekenke wobe. Gwopte neir kwokwo ere tewo pes mak womentek, tewo mure ne areri sig berasen etep wote. An Jisas erne beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita ere erne koubkoub etep wom. An nerenken sate, e yenbo. An beke kip ak, neri sig an beke kip neis. Etep womke, akei anepoi tame eme kir wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Eme Getsemani nowke yim, Jisas ere anepoi tame emne etep wom. Kem gwotek simente. An God erken tuma namdete yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Etep won ere Pita, Jems, Jon emne panen yim. Yim, ere pap yaperwai metem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Meten, ere emne etep wom. An pap yaperwai teye. Porere ari an nenlawoiwo. Kem gwotek temente. Kem mane tuknate. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Etep won, ere epkera yin selke keipe keipe waren tuknan God erne etep wom. Ane yaper nente wos mane tete. Mus mette an mo woye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Apei, ne wos akei kuyese nenbe. An wobe, ane yaper nente wos e ane beke kip ya, an mus eisau beke kip met. Ere sene wom. E nereri wos. Aren wobekap ne mane tobote. Neren wobekap ne etepwou tobote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ere yin lam, anepoi eme tuknamenem, ere emne teren Pita erne etep wom. Saimon, beke ne tuknaten? Kem ane kera beke lakere. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kem mane tuknate. Kem God erken tuma namdete. Kem erne wolate, Satan ere kemne mane seilate, kem yaper mane tete. An metye, kem tuknate mo woye. Kemri selpap kem God erken tuma namdete abobe, kemri wus nenlawoiwo, eke kem tuknaye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Etep won, ere sene yin God erken tuma sene namdem. Kiyi wom tumakap ere sene etepke wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Namden, ere sene yin lam, anepoi eme sene tuknamenem. Eme le metem, eke eme tuknamenem. Tuknamenem, ere emne terem, eme tuma beke namde. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tuma beke namde, tewo mur ere yin sene yan emne etep wom. Beke kem som tuknaten? Yau. An Tatame Etemne Lan Yeirim Tame. Tame yaper, ane keresukun panen yite tame eme mekinke yan teye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kem wayen teten nema yi. Ek la. Ane yena ten peterate tame ere mekinke yan teye. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas ere som wobetem, eri anepoi tame etemri wuri, Judas, ere yam. Tatame nogwape eme eterken yam, eme wur paku kir setirmenem. God eteri akek yaku kerebetem tame etemri apeilake, Moses eteri wule wusoubetem tame, Juda etemri apeilake tame eme ete tame emne won yan Jisas erne keresukte yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kiyi Judas ere ete tame emne etep wom. An tame wuri erne bwoite, ete tame kem erne keresukun erne panen yite. Kem erne noub keresuk. Ere kip amete wurken. Judas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas ere yin Jisas erne etep wom. Tuma wusoube tame. Etep won, ere erne bwoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bwoyim, tame eme etep lan, eme erne keresukum. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tame wuri ere etek temenem, ere eri gapaku lik peten God eteri akek yaku kerebetem tame etemri apeilake eri yaku kerebetem tame wuri eri wan gapakuk baukwunem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Gapakuk baukwunem, Jisas ere erne keresukte yam tame emne etep wom. Kem arene pette yawo, kem peiktame ei taresibe tame erne petbekapke yawo. Kem nogwape yawo, kem wur pakuken kir sen yawo. An peiktame ei taresibe tame berai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yabel nogwape an God eri ake eisauke temenem, an kemne tuma wusoubetem, kem ane etek beke keresuk. Kemri tebekap kem bepou beke nen. Kiyiri tame emri bas rasemkap kem etepke toboye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Etep womke, anepoi tame akei eme erne mesginin amen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tame taureyen wuri ere tame oub geipa warmenem, ere Jisas erne semowum. Ete tame eme erne etep lam, eme erne keresuklawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Keresuklawoyim, eme eteri warmenem tame oubwou lugpetem, ere bepou me amen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Eme Jisas erne God eteri akek yaku kerebetem tame etemri apeilake eteri akek panen yim. Yim, God eteri akeri apeilake, Juda etemri keryen, Moses eteri wule wusoubetem tame eme ete akek wurisubuk sim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Erne panen yim, Pita ere emne tiptiwun semowun yin apeilake eteri akek yam. Yam, ere maklek yin sin, ere nau semenem tame etemken etek simenem. Simenem, ere wus negel yam, ere etemken ker wus leibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","God eteri akeri apeilakeken Juda etemri kaunsil tameken akei eme Jisas erne pen sate tuma sopem. Eme erne pete tuma soplawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tame nogwape eme yan erne tuma yikwokwom, eme tuma wurisubu beke wo. Eme tuma kenakena wobetem, eke apeilake eme erne pen sate tuma somo wuri beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sene kau tame eme teten eme yikwokwon etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Kiyi Jisas ere etep wom. God eri ake eisau, tamek kerem ake, an berayewote. Sene yabel murke an ete ake sene kerete. Tame eme kerebe akekap an beke kip kere. Ere kiyi etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Etep womke, eme tuma tarekenwu kenakena wobetem. Eme tuma wurisubu beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","God eteri akeri apeilake ere wayen teten Jisas erne wom. Beke nenye, eke ne emri woye tuma ne awosein beke wo? ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jisas ere tuma rebe tem. Apeilake ere erne sene wolam. Ne Tatame Emne Sene Pette Yam Tame, Krais, o berai? Ne God eter won yam tame o? Ne God Seken Eteri Yen o berai? Ne nemne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisas ere etep wom. E aren. An Tatame Etemne Lan Yeirim Tame. Yuri kem late, an keryen tete, an mureken God eteri pi seit yekwok site. Sene an nel gwanke sene yate, kem ane late. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Etep womke, apeilake ere meten ere pap wayen eri tame oub ere letke keren pekan etep wom. Ere God erne tuma yaperke woye. Nema akeite tame emne eteri nenbe wule yaper sene eike tame beke kip wola. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Eri woye tuma yaper kem metye. Kem mapeke aboye? Nema erne mapeke tete? Eme akei etep wom. Jisas ere tuma yaperwai woye, nema erne pen sate. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tame kau eme erne sabelokwo soboyewon, eme erne bitimi noub suben erne ek pem. Pem, eme erne tuma kwoyen etep wom. Ne nemne wusoute. Eike nene peye? Etep wom, yaku kerebetem tame eme erne let pakuk wan burowom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ere ake maklek temenem, God eteri akeri apeilake eri yaku kerebetem ta te yam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yan te lam, Pita ere kerke wus leibetem, etek temenem. Te erne noub lan etep wom. Neren kir, kiyi ne Nasaret komri Jisas eterken sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ere etep wom. An berai. Neri wobe tuma an beke met. Etep won ere ake makle mesginin yim. Mesginin epkera yim, kwokwo ere wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wom, yaku kerebetem ta te Pita erne sene lan, te mekinke temenem tame emne etep wom. Kem laye, gwote tame ere Jisas eteri anepoi tame etemri tame tep. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita ere sene etep wom. Berai. An etemri tame tep berai. Etep wom. Kerake tem, mekinke temenem tame eme Pita erne etep wom. Sekenke. Ne etemri tame tep. Ne Galili yekwori tame. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita ere etep wom. Nemri Apei God ere ane labe, an beraiwai. An kemne sekenwaike wobe. An kemne yikwokwote, God ere ane pete. Kemri wobe tame an erne beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Etep womke, kwokwo ere tewo wurinabu sene wom. Ere etep metem, ere sene abom. Jisas ere ane kiyi woye. Kwokwo ere tewo pes mak womentek, tewo mur ne ari sig berasen etep wote. An Jisas erne beke la. Ere etepke sene abon, ere sebera yan kenake keram. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ei berabetem, God eteri akeri apeilake, Juda tatame etemri apeilake, Moses eteri wule wusoubetem tame, apeilake etemri kaunsil tame etemke eme agetage wurisubuk wurin tuma namdem. Namden, eme Jisas erne let peske peiken, Apeilake Pailat eterke eme panen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Panen yim, Pailat ere Jisas erne etep wometem. Ne Juda tatame etemri keryen o? Jisas ere awosein etep wom. Ye, neri woye tuma e seken. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Etep womke, God eteri akeri apeilake eme erne tuma nogwape namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Namden, Pailat ere erne sene etep wom. Ne emne awosein beke wo. Metye. Eme nene tuma nogwape namdeye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ere sene awosein beke wo, etepkap Pailat ere ep abo ep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nabek nabek Pasova a abetem yabel Pailat ere ake yaperke temenem tame wuri won yibetem. Tatame nogwape eme wobetem tame erne Pailat ere erne won yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ete yabel tame nogwape eme ake yaperke temenem. Etemri tame wuri ere Barabas. Ere tame nogwape etemken eme gavman tame etemken kom sagke ei nayin eme tame kau pen sam. Pen sam, eme erne ake yaperke won wurin temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tatame nogwape eme yan Pailat erne etep wom. Ake yaperke temenem tame, kiyi ne emne won yibetem. Ne etepke sene nente. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat ere awosein etep wom. Kem mapeke abobe? An kemri Judari keryen erne won yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Etep wom, ere etep bepou beke wo. Ere Jisas erne won akek yite abom. Ere abom, Jisas ere wule yaper beke wuri nen, eme erne bepou pap wayen erne tuma namdem. Ere etep abom. Kap eme Jisas erne sene abon, erne won akek yite. Eke ere emne etep wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","God eteri ake yaku kerebetem tame eme tatame nogwape emne etep wom. Kem Pailat erne etep wote. Ne Barabas eterne won yite. Etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat ere tatame emne wometem. Kem Jisas erne etep wobe, ere Juda etemri keryen. An erne mapeke tete? ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eme awosein noubke etep wom. Erne me kwuran kwanete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ere emne wometem. Eri nenem yaper wos an beke wuri la. Ere be wos yaperke nenem? Eme sene noubke etep wom. Erne me kwuran etek kwanete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ere etemri tuma sene abon, ere etep abom. An etep tete, eme metekwaste. Etepkap ere Barabas erne won komke yim. Yin, ere ei nai tame emne etep wom. Kem Jisas erne kep sekenak wurbetete. Wurbeten eme erne panen yim, erne me kwuran kwanete panen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ei nai tame eme Jisas erne Romri apeilake eteri akek panen wurim. Panen wurim, ei nai tame nogwape emne ten yan eme etek wurisubuk wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wurim, ei nai tame eme keryen eteri wolepai tame oub wuri Jisas erne warruwun, sene eme erne kwokwo seg peten keryen etemri tare selikap basen eteri tarek gwurereruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Gwurereruwum, eme erne pir wom. Sikile ere eteke. Ne Juda tatame etemri keryen. Nema nene eisau wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Won, eme paku peten eteri tarek apeken, eme erne sabelokwo soboyewom. Eme gulke pan eme erne tuma workwoyeken resem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tuma kwoyen mesginin eme wolepai tame oub sene lugpeten eter maime warmenem tame oub eme erne sene warruwum. Warruwum, eme erne me kwuran kwanete panen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Eme Jisas erne panen yibetem, ere kwanete me sen yibetem. Eme tame wuri erne lam, ere kom sagke yibetem. Eri sig Saimon, ere Sairini komri tame, ere Aleksaderken Rufusken etepri apei. Eme erne lam, ei nai tame eme erne egiyen ere Jisas eri kwanete me sen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Eme kow nebulek yin yawom, kow sig Golgota. Ete kow sig eri somo e Tame Tare Bai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Eme Jisas erne wain okken kwole yabe okken erne newom. Newom, ere beke a. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Beke a, eme erne etek me kwuran peiken kwanem. Kwanen omom, eme eri tame oub wosate sou tetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Keru yabelke eme erne mek peiken kwanem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kwanen eme me wulale wuri peten tuma etek basen eri tare runak peik kerem. Eme erne namdem tuma eme etep basem. Ere Juda tatame etemri Keryen. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Etep tem, eme sir petbetem tame pes epne kir me kwuran peiken kwanem. Wuri Jisas eteri pi seit yekwok tetruwem, wuri eteri let gwaime yekwok tetruwem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(God eri kiyi siglouke basem tuma ete yabel seken tem. Eme etep basen, erne etep wom. Ere tame yaper etemri wuri. Etepke basem.) ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jisas erne peiken kwanemenem emi tatame eme ete keluke yi yabetem, eme erne tuma kwoyen, tare bolan, erne etep wobetem. Kiyi ne etep wom. An God eteri ake eisau berayewon sene yabel murke an sene kerete. Ne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Eme erne sene etep wom. Ne God Eteri Yen, ne neren maime kobo late. Ne God Eteri Yen, ne me mesginin sene yan yeirte. Eme erne etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","God eteri akeri apeilake etem, Moses eteri wule wusoubetem tame eme kir erne tuma kwoyen etep kir wobetem. Kiyi ere tatame emne kobo labetem, gwopte ere maime kobo kuyese beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ere wom, ere God ere erne won yam tame, ere Juda tatame etemri Keryen. Ere me mesginin yeirtek, nema etep late, nema etep wote. E seken. Ere Krais, Juda tatame etemri Keryen. Etep wom. Tame pes epe eterken me kwuran peiken kwanem tame pes etep epe erne etepwou kir wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yabel kom luke simenem, nowsel neirkap teketekeren yin, perpe tebetem yabel ere sene pasem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yabel warbetem, Jisas ere etemri tumak noubke etep wom. Eloi, Eloi, lama sabaktani. Etep wom tuma somo eri gwopkap. Ari Apei God. Ari Apei God, ne beke ane mesginye. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Etep womke, kau tatame eme etek mekinke temenem, eme eri wom tuma noub beke met, eme etep wom. Metye. Ere kiyi temenem tuma wusoubetem tame, Elaija erne tebe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Etemri tame wuri ere amen yan yam sou peten sen yan kwole yabe wain okke sogwunen mek peiken erne newon ate sen tetem. Sen tetem, tame ere etep wom. Wai. Nema late. Kap Elaija ere yan erne kobo lan ere yeirte o? Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jisas ere taye muresen piten ere ek sam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ere samke, God eri akek esmenem mate ere iye yekwok pekan yeirin kerare kerare tem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ei nai tame etemri apeilake wuri ere Jisas eteri bitimi yekwok tetmenem, ere lam, Jisas ere muresen ten ere ek sam. Ere etep lan, ere wom. Sekenwai. Ete tame ere God Eteri Yen. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kau ta eme kai kerak teten lakerebetem, etemri wuri te Makdala komri ta. Teri sig Maria. Wuri teri sig Salome. Wuri teri sig Maria. Te Jemsken Josepken etepri nawo. Jems ere kumoi yen. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kiyi Jisas ere Galilike temenem, ete ta eme eterken sewurbetem, erne kobo labetem. Ta nogwape eme eterken Jerusalemke yan eme etek kir temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Opre Arimatea komri tame Josep ere yam. Ere Juda etemri kaunsil tame wuri, ere tame yenbo. God ere kom panen site yabel ere etep koumenem. Ere yan, ere abom. Kipi e ege si yabel, nema yaku beke kip kere. Gwopte nema wos eyarte. Etep abomke, ere beke ak, ere Pailat erne yin lan Jisas eri kupa pette wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wolam, Pailat ere wouken aken etep abom. Kap Jisas ere saye o? Etep abomke, ere ei nai apeilake tame erne won yan erne etep wolam. Jisas ere saye, o ere beke sa? ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ei nai apeilake ere erne etep wom. Ere saye. Ere etep meten, ere Josep erne etep wom. Ne yin Jisas eteri kupa ne peten sen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Etep womke, Josep ere yin tame oub geipa tuken sen yin eri kupa neneyeirin tame oubke leyem. Leyen, ere sen yin pape purik rasen pape eisau gelkwun yan sele me ragerkerem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ragerkerem, Makdala komri Maria, Josep eri nawo Mariaken epe etek temenem, epe Jisas eri kupa rasem emi epe lam. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Juda tatame etemri ege si yabel temke, Makdala komri Maria te gwo, Jems eri nawo Maria te gwo, Salome te gwo eme yin bosmame kwar petem. Kwar eme Jisas eri kupa etek kerete abom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Etep abom, Sande keru ei berabetem, ta eme sele late yim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yibetem, eme etemwou etemwou tuma namden etep wom. Eike pape puri eru ragerten pape erne gelkwute? ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Etep namden eme yin lam, pape eisau ere gelkwun kena tuknamenem. Ete pape ere eisauwai. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Etep lan eme pape purik wurin lam, tame taureyen ere pi seit yekwo etek simenem. Ere tame oub geipa waren simenem. Erne lam, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ere emne etep wom. Kem mane akte. Kem Nasaret komri Jisas erne sopbe. Eme me kwuran peiken erne etek kwanem, ere sam. Sam, ere sene wayen yiwo. Ere gwo beke te. Eri kupa rasem emi kem ape yan la. Ere beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kem epe yin, Pitaken Jisas eteri akeite anepoi tameken emne etep wote. Jisas ere Galili yekwok kemne taresin koute yiwo. Kem Galilike yin erne etek late. Ere kemne etep kiyi wom tumakap, kem yin eteri anepoi emne etep wote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eme pape puri mesginin amen yim. Eme wouken akem, let tewo oksubu teyewom, eme eikene beke wuri wusou. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","(Sande ei berabetem, Jisas ere sene wayen yim, ere Makdala komri Maria etetne kiyi yin lam. Kiyi gabo ep yekwo let ep yekwo let bor pes keyem (7-pela) eme etetne gulelemenem, Jisas ere ete gabo emne pekeroukum. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jisas erken kiyi sewurbetem anepoi tame eme pap yaper tem, eme keratirbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria te yin emne etep wusowum. Jisas ere tetan. An erne laye. Eme etep metem, eme teri tuma kenawaike beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yuri eteri anepoi tame pes epe kom mesginin keluke sewurbetem, epe Jisas erne lam, ere kiyi temenemkap. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Epe erne lan, epe yin akeite anepoi tame emne etep wusowum. Epe etep wom. Nesa Jisas erne laye. Eme etep metem, eme epne etep wom. Kep me yikwokwobe. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yuri anepoi tame eme ep yekwo let ep yekwo let tewo ges wuri keyem (11-pela) eme sin a abetemke, Jisas ere emne etek yan lan, ere pap wayen emne woyewom. Kiyi ta murken tame pesken eme ane lam, eme kemne yan wom. Jisas ere sene wayen yiwo. Nema erne laye. Etep wom, anepoi tame eme emri tuma worwor beke met, eke Jisas ere emne woyewom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ere emne etep wom. Kem nowsel nogwapek yin God eri tuma yenbo tatame nogwape emne wusowun sewurte. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Eike ane kenawaike abote, kem emne baptais ok wirute, God ere emne sene pette, eme eyar temente. Eike ane kenawaike beke abo, yuri God ere emne tuma namden, emne pete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ane kenawaike abote tatame eme rigrabe nente. Eme areri sigke won, eme ari murek gabo emne pekeroukte. Eme akeite akeite tumak namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Eme sopo letke pette, sopo emne beke kip tan sa. Eme tame sabe ok yaper ate, eme beke kip sa. Eme let kere tewo kere tame emne let kerete, eme yenbo sene tete. Ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aneyen Jisas ere emne wo mesginin God ere erne womke, ere God eteri komke yin God eteri pi seit yekwok sim. ");
INSERT INTO yss_yawu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yin sim, eteri anepoi tame eme akei komke komke tuma wusowun sewurbetem. Aneyen Jisas ere etemken yaku etep kerebetem. Tatame eme anepoi emri nenem rigrabe lam, eme etep wom. Emri wobe tuma e seken. Etep wom.) Mak ere bas rasem tuma ab eteke. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O apeilake tame Tiofilus, kiyi tame kau eme Jisas eter kerebetemkap eme basem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tame eme Jisas eter nenbetem wos lam, eteri wusoubetem tuma eme metem, eme nemne etep wusowum. Emri lan wusowumkap, kau tame eme etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Bas rasem, an kir an ete tuma basen nene newopitte abobe. Emri basem tumakap an etep noub lam, an etepke noub baste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ete tuma eme nene kiyi wusowum, ne metem. Ete tuma an basen nene newopitte, ne lan etep mette, neri kiyi metem tuma e seken. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kiyi Herot ere Juda tatame etemri apeilake temenem, God eteri akek yaku kerebetem tame wuri ere temenem. Eri sig Sekaraia. Ere Abiya eteri wakse. Eri ta te Aron eteri yen supa. Ta teri sig Elisabet. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","God ere lam, epe tatame yenbo. Keryen God eteri tuma, eteri wule epe meten nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Epe yen berai. Elisabet te yen game abetem ta, epe keryen tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yabel wuri Sekaraia ere akeite tameken eme God eteri yaku God eteri ake eisauke kerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kerebetem, eri yaku kere tamesip eme erne etep wom. Gwopte ne God erne bos yenbo yabe wos liste. Etep wom, ere ake puri yenbok yin wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wurim, ere bosken wos lisbetem, tatame nogwape eme kom genik wurisubuk tetemenem, eme God erken tuma namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Namdebetem, ere lam, God eri komri tame ere bos yenbo yabe wos lisbetem emi pi seit yekwok tetemenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Etep lam, Sekaraia ere wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wouken akem, God eri kom tame ere erne etep wom. Sekaraia, ne mane akte. God ere neri namdebetem tuma metem, neri ta Elisabet te taureyen warwite, ne eri sig Jon tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Erne warwite, neri pap yenbo mette, ne metekwaste. Tatame nogwape eme etep yan late, eme kir metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yuri ete yen ere God eteri yaku yenbo kerete. Keryen God ere etep late, ere erne tame yenbo wote. Ete yen ere ok yaper mane ate. Erne nawo te warwite, God Eri Wou ere eterken somsom temente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ere Israel tatame emne God eri tuma wusoute, tatame nogwape eme meten Keryen God eterne kenawaike sene abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","God ere erne wote, ere God eteri kiyi temenem tuma wusoubetem tame Elaija eterkap tete. Ere mureken tete. Eike yenken aken eme pekan kenakena tete, ere emne tuma yenbo wote, eme sene noub site. God erne beke abo tatame eme wan gwolebe, ere emne tuma yenbo wusowun, eme porere yenbo pette. Ere tatame nogwape emne etep wote. Kem kemri wule yaper mesginte. Aneyen ere yate nenbe. God eri kom tame ere Sekaraia erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraia ere God eri kom tame erne awosein etep wom. Neri woye tuma e seken o? An mapeke met. An ari taken nesa keryen teye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","God eri kom tame ere awosein etep wom. An Gebriel, an God eteri bitimik tetebe tame. Ere ane won yawo, eke an nene tuma seken woye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ari woye tuma ne kenawaike beke met, eke ne tuma eikse tame tete nenbe, ne tuma beke kip namde. Tuma eikse ten yin aren nene woye tuma ere seken tete, neri ta te yen warwitek, ne kip tuma sene namdete nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sekaraia ere God eteri ake purik wurmenem, tatame nogwape eme erne sene worate koumenem. Koulawoyim, eme etep wom. Sekaraia ere beke wora. Ere kap beke nenyeke, ere God eteri ake purik som tetan? ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Etep womke, ere sene yan woram, ere tuma eikse tem, ere emne tuma letwouke peterabetem. Peterabetem, eme etep wom. Ere wurmenye, ere kap be woske laye, ere tuma eikse teye? ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Etep wom, Sekaraia ere God eteri akek kerebetem yaku omom, ere akek sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yuri eri ta Elisabet te yenken tem. Yenken tem, lup ep yekwo let te etetri akek berasen simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Te etep wom. Keryen God ere ane yenbo nenemke, an yenken teye. Tatame eme ane sene beke kip wo. An yen game abe ta. An sebera sene beke kip ya. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet te yenken tem, lup ep yekwo let ep yekwo let ges wuri (6-pela) yim, God ere eteri kom tame Gebriel erne sene won ere Galili distrikke tetan kom Nasaretke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yim, ere munguta wuri tene tuma wusoute yim. Ete ta tene eme tame womenem. Tame eri sig Josep. Ere kiyi temenem Keryen Devit eteri supa. Munguta teri sig Maria. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yim, ere tene pir wom, ere etep wom. Keryen God ere nerenken tetan. Ere nene noub nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Te etep metem, te abolawoyin etep abom. E mapkap tuma? ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","God eteri kom tame ere tene etep wom. Maria, ne mane akte. God ere nene noub nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yuri ne yenken tete nenbe. Ne taureyenke warwite nenbe. Ne erne sig Jisas tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yuri ere keryen tete, tatame eme eterne etep wote. Ere Hevenke tetan God Eteri Yen. Etep wote. Kiyi Devit ere keryen temenemkap, yuri Jisas ere eteri yaku pette, ere keryen tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ere warege Jekop eteri tame supa emne somsom panen site. Ere keryen som temente. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria te erne awosein etep wom. An yenken mapeke te? An tame mak narten. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ere tene awosein etep wom. Akei wos God eteri kulke tetan. God Eteri Wou ere nerenke yate. God eteri mure ere nene newote. Etepkap ne yenken tete. Yuri ne warwite yen eme erne etep wote. Ete yen ere yenbosubuwai. Ete yen ere God Eteri Yen. Eme etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Metye. Neri wopu te Elisabet, kiyi eme tene etep wobetem. Te yen beke se. Te yen game abe ta. Eme etep wobetem, gwopte te keryen tebe, te yenken. Te lup ep yekwo let ep yekwo let ges wuri (6-pela) yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wos nogwape God ere kuyese nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria te etep wom. An God eteri yaku kere ta. Neri woyekap ere ane etep nente, an kir teye, e yenbo. Etep womke, God eteri kom tame ere tene mesginin sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ete yabel Maria te wos peten agetage te kowke yim, te Juda distrikke tetan kom nebule etek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yim, te Sekaraia eteri akek wurin Elisabet tene pir wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pir wom, Elisabet teri sek temenem yen ere titowum. Titowum, God Eteri Wou ere Elisabet tene gulelemenem, ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","te Maria tene noubke etep wom. God ere nene noub kobo lam. Ere akeite ta emne etepkap beke nen. Neri sek tetan yen eter kir, God ere erne kir kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ari keryen eri nawo te ane late yawo, an pap yenbo metye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Neri woye pir an metye, agetage ari sek tetan yen ere metekwasye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","God ere nene wom tuma ne etep kenawaike abobe, eke ne metekwaste. Elisabet te tene etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria te etep wom. Ari selpapke an Keryen God eri sig eisau wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ari selpapken porereken an Keryen God erne metekwasbe. Ane sene petem God ere ane eyarem. An erne sig eisau wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","An eteri yaku kerebe ta nebule. Ere ane abobetem, eke an metekwasbe. Mure sapeken God, ere ane wule eisau nenye, eke gwopte tetan tatame, yurik tete nenbe tatame eme wote. God ere ane yenbo nenbe. Eri sig e yenbowai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Eteri kulke tetan tatame emne ere kobo labe. Kiyiri tatameken gwotepteri tatameken yurik tete tatameken emne eter som kobo labetete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Eteri letke God ere sapeken wos nenbe. Ere sig maime eisau wobe tame emne won sekiyin, eme yikwute yakwutem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ere kom panen siten keryen tame emne teitkwunbetem. Maime sig teitkwunbe tame emne ere emri sig eisau wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Se kwoi sam tatame ere emne a yenbo newon abetem. Eme an se kir tem. Kel worken tatame emne ere wos beke newo, ere emne won, eme bepou me yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ere eteri yaku kere tame, Israel, erne kobo lam. Ere neremri warege etemken namderasem tuma abopitim. Ere warege Abrahamken eteri nanken emne noub som eyarbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Etep ten, Maria te Elisabet teken lup mur etek ten te komke sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet te yen warwite yabel tem, te taureyenke warwiyim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Warwiyim, teri kom tame, teri tame supa eme metem, Keryen God ere tene noub nenem, eke te yen warwiyim. Etep metem, eme metekwasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yabel ep yekwo let ep yekwo let bor mur (8-pela) tem, tame kau eme yam. Eme yen erne somo kwunen erne sig tete yam. Eme ar eteri sig Sekaraia tete wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Etep wom, nawo te mo won etep wom. Berai. Nema eri sig Jonke tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Etep wom, eme tene wotaken etep wom. Ete sig e neri tame beig etemri sig berai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Etep wom, eme ar erne letke peteran erne etep wolam. Yen erne sig mapeke tete? ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Etep wom, ar ere siglou womke, eme siglou peten sen yan erne newom, ere yen eri sig etek basem. Ere etepke basem. Eri sig Jon. Etepke bas rasem, eke eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wouken akem, agetage Sekaraia ere tuma sene namdem, ere God erne tuma yenbo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wom, kom tatame eme lam, ere tuma sene namdem, eke eme wouken akem. Judia distrikke tetan kowke temenem tatame nogwape eme ete tuma kir metem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Metem, nogwape tatame eme etep wobetem. God eri mure ere ete yen eterken tetan. Ete yen ere aneyen tete, ere kap be yakuke kerete nenbe? Eme etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","God Eri Wou ere Jon eteri ar, Sekaraia, eterne gulelen ere yurik tete wos wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ere etep wom. Nema Israel tatame, nema Keryen God erne tuma yenbo wote. Ere eri tatame emne kobo lan emne sene petem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ere eri yaku kere tame Devit eri tame supa wuri kenem. Ete tame ere mureken tame, ere nemne sene pette, nema yenbo tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kiyi God ere eteri tuma wusoubetem tame yenbo emne tuma wusowum, sene eme tatame emne ete tuma wusowum. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","God ere etep wom. An kemne peiktameken kemne pap yaper tebe tameken etemri letke an kemne sene pette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ere sene etep wom. An yeiwarege emne kobo lam, kiyi namde rasem tuma yenbo an beke wan get. An som abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Ere emri warege Abraham erken tuma namde rasen etep wom. An keremri peiktame emne teitkwunte. Teitkwunte, kem temente, kem ari yaku kerete, kem mane akte. An late, kem yenbo temente. Ere Israel tatame nemne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sekaraia ere etep womke, ere eri yen erne etep wom. Areri yen, yuri ne keryen erne taresin yin eri kelu noub eyarte. Tatame eme nene etep wote. Ere Hevenke tetan God eteri tuma wusoube tame. Eme nene etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wote, ne tatame emne etep wote. Kerem, kem wule yaper mesginte. Mesginte, God ere kemri nenbetem wule yaper magel taite, ere kemne sene pette. Ne emne etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Neremri God ere kobo labe tame, eke ere gwopkap nenbe. Tatame eme kerneirikapke siten, eme sate akbe. God Eri Yen ere Hevenke tetan, ere erne won yate, ere yabelkap paste, eke neir ere eikap berate nenbe. Etep tete, ere nemne kelu yenbo peterate, nema noub site nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Etep womke, yuri Jon ere aneyen tem, ere mureken tem. Ere tatameken berai emik yin ten temenem. Ten yin, yuri ere Israel tatame emne God eteri tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yuri Romri Keryen Sisar Ogastus ere wule wuri wom. Ere etep wom. Nogwape komri tatame emri sig nema pette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kiyi eme tatame emri sig beke pet, sene ere etep wom. Ete nabe Kwirinius ere kantri Siriari apeilake temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tatame nogwape eme emri maime komke yim, eme emri sig newote yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yim, Josep ere Devit eteri tame supa. Kiyi Devit eteri nawo te erne Betlehemke warwiyim, eke Josep ere Galili distrikri kom Nasaret mesginin Judia distrikri kom Betlehemke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ere eteri ta Maria etetken epe etep yim, epe epri sig newote yim. Maria tene Josep eterne womenem, te bepou me ayi ayabetem, te yen lekan yenke temenem, eke epe etep yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yin Betlehemke temenem, Maria te yen etek warwiyim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Te mase tobo yen, taureyenke warwiyim. Warwiyim, te erne matek leyen bulmakau etemri a abetem yubuk yewon rasem. Tatame eme tuknabe ake eisau erne tame nogwape wurin pelawom, eke epe nenlawoyim, epe bulmakau etemri akek yin temenem, te yen etek warwiyim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sipsip lakerebetem tame eme Betlehem kom sag ep yekwo wurik temenem, neirke eme emri sipsip etek lakerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Lakerebetem, Keryen God ere eteri kom tame wuri erne won etemne yim. Won yim, eme tukap tobukem eme lam, eme kenake akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Akem, God eri kom tame ere emne etep wom. Kem mane akte. Metye. An kemne tuma yenbo wusoute yawo. Ari wote tuma tatame nogwape eme pap yenbo ten metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gwopte neir ta wuri te Devit eteri komke yen warwiwo. Yuri ete yen ere kemne sene pette. Eri sig Aneyen Krais. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kem yin etepke late. Nawo te erne matek leiwo rasten. Ere bulmakau a abe yubuk tuknaten. Kem etep late, kem ari wobe tuma sene abon etep wote. Eri woye tuma e seken. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Etep womke, agetage God eri kom tame nogwapewai eme wuri eterken yan temenem, eme God erne tuma yenbo wom, eme eri sig eisau wobetem. Eme etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","God ere Hevenke tetan, ere yenbowai. Nowselke tetan tatame emne God ere emne kobo labe, tatame eme noub site. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","God eteri kom tame eme sipsip lakerebetem tame emne mesginin eme God eteri kom Hevenke sene yim. Yimke, sipsip lakerebetem tame eme etep wom. Nema ape yi. Aneyen ere nemne woye wos nema Betlehem komke yin late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Etep won, eme agetage yin lam, Mariaken Josepken epe etek temenem. Yen ere bulmakau etemri a abe yubuk tuknamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tuknamenem, eme etep lan woran God eteri kom tame eter yan wom tuma eme tatame emne etepke wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wusoubetem, tatame nogwape eme sipsip lakerebetem tame emri tuma meten, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Wouken akem, Maria te etemri tuma som abobetem, te beke wan get. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sene sipsip lakerebetem tame eme etemri komke sene yim. Yibetem, God eteri kom tame emri wom tuma, emri lamkap eme abom, eme God eri sig eisau wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sande wuri tem, eme yen erne somo kwunen erne sig tem. Eme eri sig Jisas tem. Kiyi nawo te yenken mak temenemke, God eteri kom tame ere ete sig kiyi teruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kiyi Moses ere yen geibele eyarbe wule wuri bas rasem. Eke Mariaken Josepken epe etepke tem. Tem, epe yen sen Jerusalemke yim, God ere Moses erne newom wule tobote yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","God eri wule etep wom. Kemri mase tobo yen, taureyen kem peten Keryen God eterne newon etep wote. Gwote yen e nereri. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","God eri akeite wule etep wom. Kem ap bour pes o murke pen kerke lisin ane newote. Etep womke, Mariaken Josepken epe God erne ap pes newote sen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tame wuri ere Jerusalemke temenem, eri sig Simeon. Ere tame yenbo, ere God erken tuma namdebetem, sekwo lombetem tame. Israel tatame etemne sene pette tame eterne ere koumenem. God Eri Wou ere eterken temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Eterken temenem, kiyi God Eri Wou ere erne etep wom. Ne kiyi beke kip sa. Ne Keryen God eri wom tame Krais erne lan, ne ek sate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Etep wom, God Eri Wou ere erne womke, ere God eri ake eisauke wurim. Wurim, kiyi wom wulekap, aken nawoken epe Jisas erne etep nente sen yamke, ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon ere yen erne letke peten sen, ere God erne pir won etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Keryen, an neri yaku kerebe tame. Neri kiyi wom wos an laye, ari pap yenbo metye, eke an sate nenbe, e yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nemne sene pette tame an erne areri lek laye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Neren, ne erne won ere tatame nogwape emne noub nente. Ere yawo, an etep laye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ere tukap. Ere akeite kantriri tatame emne kelu yenbo peterate yawo. Nereri Israel tatame nogwape emri sig ere eisau wote nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jisas eri aken nawoken epe Simeon eri wom tuma etep metem, epe wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Wouken akem, Simeon ere emne tuma yenbo wom, ere yen eri nawo Maria tene etep wom. Ne ek met. God ere gwote yen erne wom. Wom, kau Israel tame eme erne magel taite, eme sene yaper tete nenbe. Kau eme erne pap yewote, eme sene noub tete nenbe. God ere erne won yam, tatame eme erne tuma yaper wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Akeite tatame eme etep late, eme tuma yaper wote tame etemri porerek abote. Yuri ne pap yaper mette nenbe. Etepkap metbe mus e pik pebe muskap. Simeon ere Maria tene etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tuma wusoubetem ta wuri, teri sig Ana, te Fanuel eteri yen, te Aser eteri tame supa temenem. Te keryenwai tem. Kiyi te tame yimenem, nabe ep yekwo let ep yekwo let bor pes keyem (7-pela), tame ere ek sam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Sam, nabe nogwape (84) yim, te wane ta simenem. Te God eri ake eisau beke mesgin. Neirken yabelken te God erne sukye worabetem, te God erken tuma namdebetem. Tewo wuri te erne sukye worabetem, te aom takerbetem, te a beke a. Te etepwouke nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ete yabel aken nawoken epe Jisas erne sen yim yabel, ete ta te yan kir temenem, te yen erne lam. Lam, te God erne pir won te tatame emne ete yen erne te emne wusowum. God erne koumenem tatame nogwape te emne wusowum. Ete tatame eme tame wuri koumenem, Jerusalemri tatame emne sene pette tame erne eme koumenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Keryen God eter wom wule eme etep nenem, Josepken Mariaken epe etepri maime kom Nasaretke sene yim. Nasaret e Galili distrikke tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yin tem, yen ere aneyen tem, ere nogwape mureken porereken temenem. Etep temenem, God ere erne kobo lan erne noub nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nabe wurare wurare Jisas eri aken nawoken epe Jerusalemke yibetem, epe Pasova a ate yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yibetem, Jisas eri nabe ep yekwo let ep yekwo let ep yekwo tewo bor pes keyem (12-pela) temke, emri kiyi nenbetemkap, eme etep sene nenem, eme Pasova ate Jerusalemke yawom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Yawom, sene Pasova yabel omom, anenawo epe komke sene yibetem, muyen eisau kera temenem yen Jisas ere Jerusalemke som temenem. Temenem, aken nawoken epe erne beke la, ere Jerusalemke som temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Erne beke la, epe etepke abom. Ere kap Nasaret komri tatame etemken yibe. Etep abom, eke epe yabel wurik yin kom petem. Petem, epe tatame nogwape etemri borke erne sopen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Soplawoyim, epe Jerusalemke sene erne sopte yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yim, yabel pes epe erne soplawoyim. Yabel mur temke, epe erne lam, ere God eteri ake eisau purik wurin simenem. Simenem, ere tuma wusoubetem tame etemri borke sin etemri tuma metbetem. Metbetem, ere emne awosein wometbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wometbetem, tame kau eme eri porere, eri awosein wometbetem tuma metem, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aken nawoken epe Jisas erne etek sopen yin lam. Lam, epe wouken akem. Jisas ere tame nogwape etemri borke simenem. Nawo te erne etep wom. Yen, ne beke nesetne etepkap teye? Nesa nene soplawoyim, nesa ar erken selpap yaperke metbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Etep wom, ere epne awosein etep wom. Kep beke ane sopbe? An areri Apei eteri akek siten. Kep etep beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Etep womke, ere epne wom tuma somo epe beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ere etepken Nasaret komke sene yin temenem, ere kwokwos kwokwos anenawo epri tuma tobobetem. Tobobetem, eri wobetem tuma nawo te peten etetri selpapke tebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tebetem, Jisas ere aneyen tem, ere porere yenbo petem. Petem, tatame eme erne metekwasbetem, God ere erne kir metekwasbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisar Taiberius ere Rom tatame etemri keryen temenem. Nabe nogwape (15 yia) ere apeilake som temenem. Temenem, Pontius Pailat ere Judia distrikri tatame emri apeilake temenem, Herot ere Galili distrikri tatame etemri apeilake temenem. Eri mase ere Filip, ere Ituria distrik Trakonitis distrik etemri apeilake temenem, Lisanias ere Abilene yekwori tatame etemri apeilake temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasken Kaiafasken epe God eteri ake eisauke yaku kerebetem tame etemri apeilake temenem. Ete yabel Jon, Sekaraia eteri yen, ere tameken berai emik temenem, God ere erne tuma wopete yeirim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wopete yeirim, Jon ere Jordan peik yekwori kom komke yin tatame emne tuma wusoubetem. Ere etep wobetem. Kem keremri wule yaper mesginte, an kemne baptais ok wirute. Baptais ok wirute, God ere kemri nenbetem wule yaper peten sepitte, ere kemne tuma beke kip namde. Ere etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kiyi temenem tuma wusoubetem tame, Aisaia, ere ete tuma kiyi siglouke bas rasem. Ere etepke bas rasem. Tame wuri ere tameken berai emik temente, ere tuma noubke etepke tebetem. Kem Keryen eri kelu noub eyarte. Kem eri yate nenbe kelu noub akwun eyarte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wauna wauna kem sel peren yente. Kelu kwokwore, kem noub borborke kayen eyarte. Me nenken kelu kem me nen kayen petewarte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Etep nente, nemne sene pette tame erne God ere erne won yate. Nema etep late. Aisaia ere etep kiyi bas rasem, Jon ere yurik yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tatame nogwape eme Jon erne yan lam, ere emne ok wiruteke yam. Yam, ere emne etep wom. Kem wale yaperkap, kem porere yaper tatame. Beke kem ane late yawo? Yuri God ere tatame emne pakuk pete, ere kemne kir pete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kem yenbo nente. Kem etep nente, nema mette, kem wule yaper mesginye. Kem mane etep wote. Abraham ere neremri warege. Ere tame yenbo, eke nerem kir nema tame yenbo. Kemri etep wobe tuma e tuma seken berai. Kem Abraham eteri nan, kem tame yenbo berai. Eter nenbetemkap, kem etepwou beke nen. Kemri porere yaper kem mesginte, kem tame yenbo tete. God ere abote, ere gwo pape peten tame seikite, sene eme Abraham eteri yen tete. God ere etep kuyese nente. Kem mane etep wote, nema Abraham eteri yen. Etep bepou mane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yuri yate tame ere wor letke sete tamekap. Ere me teite, ere somosomok teite. Nogwape me eme supa yenbo beke ya, ere ete me emne teyin kerke liste nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ere etep womke, tatame nogwape eme erne etep wometem. Nema be woske nente? ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ere awosein emne etep wom. Tame ere tame oub pes temente, wuri ere tame oubken berai tame erne newote. Awos tetan tame ere etepwou nente. Ere awos berai tame emne awos newote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis kel petbe tame eme yan baptais ok wirute wom, eme erne etep wom. Tuma wusoube tame, nema be woske nente? ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ere emne awosein etep wom. Kem takis kel pette, kem kemri apeilake eter wobekapwou pette. Kem kel tep kera sirke mane pette. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ei nai tame eme erne yan etep wometem. Nerem, nema mapeke tete? Ere emne awosein etep wom. Kem tuma mane yikwokwon tatame etemri kel sirke pette. Kem wos yaper beke nen tatame emne mane tuma bepou me namdete. Kem keremri yaku kerebe kelwouke peten metekwaste. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tame eme Jon eteri tuma metem, eme eterne abon etep wom. Kap Jon ere Krais, God eter won yam tame o? ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Etep womke, Jon ere emne etep wom. An kemne okke wirute. Yuri tame wuri ere yate, ere tame eisau, ere tame yenbo. An tame nebule. An tame yenbo berai, nesa wolbaye wurisubuk beke kip si. An tame nebule, an selke site. Ete tame ere kemne God Eteri Wou kemne newote. Kemri nenbe wule yaper ere kerke liste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kopi wus tame eme peten sepitbekap, ete tame ere tatame yaper emne kerke seitte. Ete ker ere som eibe. Tame eme kopi om peten akek rasbekap, ere tatame yenbo emne eteri komke panen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Etep wom, Jon ere God eteri tuma yenbo emne wobetem, tuma nogwape ere emne kir wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yuri Jon ere apeilake Herot erne tuma etepke wom. Ne neri mase eteri ta, Herodias tene burkit peten panem. E yaperwai. Ne akeite wule yaper nogwape kir nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Etep womke, Herot ere wule yaper wurinabu sene nenem, ere Jon erne ake yaperke won wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jon ere tatame nogwape emne kiyi baptais ok wiruwum, yuri ere Jisas erne baptais ok wiruwum. Baptais ok wiruwum, Jisas ere God erken tuma namdebetem, eme lam, gwan beram, ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","God Eteri Wou ere nelke ap bourkap yeirim, Jisas eterke yeirin sim. Yeirin sim, tuma wuri nelke etep wom. Ne Ari Yen yenbowai. An nene me metekwasbe. Etepke wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kiyi Jisas ere yaku tasem, eteri nabe e nogwape kera (30 yia). Tatame eme erne etep abom. Ere Josep eteri yen. Josep ere Hilai eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilai ere Matat eteri yen. Matat ere Livai eteri yen. Livai ere Melki eteri yen. Melki ere Janai eteri yen. Janai ere Josep eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep ere Matatias eteri yen. Matatias ere Amos eteri yen. Amos ere Nahum eteri yen. Nahum ere Esli eteri yen. Esli ere Nagai eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ere Mat eteri yen. Mat ere Matatias eteri yen. Matatias ere Semen eteri yen. Semen ere Josek eteri yen. Josek ere Joda eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ere Joana eteri yen. Joana ere Resa eteri yen. Resa ere Serubabel eteri yen. Serubabel ere Sealtiel eteri yen. Sealtiel ere Neri eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ere Melki eteri yen. Melki ere Adi eteri yen. Adi ere Kosam eteri yen. Kosam ere Elmadam eteri yen. Elmadam ere Er eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ere Josua eteri yen. Josua ere Eleasar eteri yen. Eleasar ere Jorim eteri yen. Jorim ere Matat eteri yen. Matat ere Livai eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai ere Simeon eteri yen. Simeon ere Juda eteri yen. Juda ere Josep eteri yen. Josep ere Jonam eteri yen. Jonam ere Eliakim eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ere Melea eteri yen. Melea ere Matata eteri yen. Matata ere Natan eteri yen. Natan ere Devit eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit ere Jesi eteri yen. Jesi ere Obet eteri yen. Obet ere Boas eteri yen. Boas ere Salmon eteri yen. Salmon ere Nason eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ere Aminadap eteri yen. Aminadap ere Atmin eteri yen. Atmin ere Arni eteri yen. Arni ere Hesron eteri yen. Hesron ere Peres eteri yen. Peres ere Juda eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ere Jekop eteri yen. Jekop ere Aisak eteri yen. Aisak ere Abraham eteri yen. Abraham ere Tera eteri yen. Tera ere Nahor eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ere Seruk eteri yen. Seruk ere Reu eteri yen. Reu ere Pelek eteri yen. Pelek ere Eber eteri yen. Eber ere Sela eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ere Kainan eteri yen. Kainan ere Arpaksat eteri yen. Arpaksat ere Siem eteri yen. Siem ere Noa eteri yen. Noa ere Lamek eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ere Metusela eteri yen. Metusela ere Enok eteri yen. Enok ere Jaret eteri yen. Jaret ere Mahalalel eteri yen. Mahalalel ere Kenan eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ere Enos eteri yen. Enos ere Set eteri yen. Set ere Adam eteri yen. Adam ere God eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisas ere Jordan peik mesginin yim, God Eri Wou ere eterken temenem, ere Jisas erne panen ere tame berai emik yin temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yin neirken yabelken nogwape (40-pela) ere etek temenem. Temenem, Jisas ere a beke a, ere bepou me temenem. Temenem, yuri ete yabel akei omom, ere kwoi sabetem, gabo etemri apeilake, Satan, ere yan erne etek seilam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seilam, Satan ere erne etep wom. Ne God Eteri Yen seken, ne wotek, gwote pape eme geilke ten, ne ek peten ate. Ne etep nentek, an lan etep wote. Ne God Eteri Yen seken. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas ere erne awosein etep wom. God eri siglou ere etepke wobe. Tatame eme aomwou abote, eme noub beke kip te. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sene Satan ere Jisas erne panen kowke yawom, agetage gwote nowselri kom nogwape ere erne peteram. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Peteran, ere Jisas erne etep wom. An nene ete kom nogwape newote, ne kom panen site. Wos nogwape yenbotanbo ete komke tetan, an nene akei newote. God ere ete wos ane newom. An tame wuri erne newote wote, an kuyese newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ne gulke pan ane sukye worate, wos nogwape an nene newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas ere awosein erne etep wom. God eri siglou etep wobe. Kem Keryen God eterwoune sukye worate, eterwoune yaku kerebetete. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sene Satan ere Jisas erne Jerusalem komke panen yim, ere erne God eteri ake eisau magelke panen yawon tetem. Tetem, ere erne etep wom. Ne God Eteri Yen, ne kerpekwunte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","God eri siglou e etep wobe. God ere eri komri tame emne won yate, eme nene kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tuma wuri sene etep wobe. Neri tewo papek beke kip pe, ne noub waren tetete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Etep womke, Jisas ere erne awosein etep wom. God eri siglou etep wobe. God ere nereri Keryen. Eke ne erne mane seilate. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan ere erne seilawoyim, ere erne mesginin yim, ere akeite yabelke erne sene seilate kowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","God Eri Wou ere Jisas eterken temenem, ere Galili distrikke sene yim. Yim, Jisas ere nenem wos komri komri tatame eme metem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jisas ere God eteri akek wurin tatame emne tuma yenbo wusoubetem, eme eri sig eisau wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sene Jisas ere Nasaret komke yim. Kiyi ere apuleyen temenem, ere Nasaret komke temenem. Yim, ere kiyi nenbetemkap, ege si yabelke ere God eteri akek wurim, ere God eteri siglou lan wote wayen tetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tetem, Aisaia eri bas rasem siglou eme erne newom, ere tuma wuri sopen lan etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Keryen Eri Wou arenken tetan. Ere ane wom, an wosken berai tatame emne tuma yenbo wusoute. Ere ane tuma wosoute won yan ake yaperke tetan tame eme ake yaper mesginin sene won yite. Le si tatame eme noub sene late. Ere ane won yam, an selpap yaper metbe tatame emne tuma yenbo wusoute, eme pap yenbo mette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ere ane won yam, an emne tuma wusoute, God ere tatame emne sene pette nenbe yabel, ete tuma an emne etep wusoute nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Etep lan wom, Jisas ere siglou gupakeren lakerebetem tame erne sene newom. Newom, ere ek sene sim, tatame nogwape eme God eteri akek simenem, eme eterwoune lakerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ere emne etep wom. Gwopte kemri metye tuma, God eri bas rasem tuma, ere gwopte seken teye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Etep womke, ere emne tuma yenbowai wom, eke eme ep abo ep abom. Eme etep wom. Ete tame ere Josep eteri yen. Mapeke ere etepkap tuma wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eme etep womke, Jisas ere emne etep wom. Kem tatame etem wobe tumakap kem ane etep wote. Ne akeite tatame emne noub nenbe tame, ne nereri maime kom noub nente. Sene kem ane etep wote. Neren Kaperneamke nenem rigrabekap nema metemkap, ne neri maime komke kir nente. Kem ane etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","An kemne tuma sekenwaike wobe. Tuma wusoube tame etemri komri tatame eme erne pap beke kip yewo, eme erne magel taibe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Metye. An kemne tuma sekenke wobe. Kiyi Elaija ere temenem, wane ta nogwape eme Israelke temenem. Temenem, mou beke ti, nabe mur lup ep yekwo let ep yekwo let ges wuri keyem (6-pela), tatame nogwape kom komke eme se kwoi sabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Se kwoi sabetem, God ere Elaija erne wom, ere Israelri wane ta etemne beke won yi. Berai. Ere erne won Sarefat komri wane ta etetwoune yin lam. Sarefat kom e Saidon yekwok tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sene God eri tuma wusoubetem tame, Elisa, ere temenem, numa pe tame nogwape eme Israelke temenem. Temenem, God ere emne noub beke nen. Berai. Siria yekwori tame, Naman, eterwoune God ere erne noub nenem. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tatame eme God eteri akek temenem, eme Jisas eri wom tuma etep metem, eme erne pap kenake wayem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pap wayem, eme wayen teten Jisas erne keresukun erne kom mesginin litin wurim. Wurim, kom siten kowke eme erne panen yawom, eme erne etek sogwunen warte wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Sogwunen warte wobetem, ere etemri borke emne mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas ere Kaperneam komke yim. Kaperneam kom e Galili distrikke tetan. Yim, ege si yabel ere God eteri akek wurin emne tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wusowum, eme eri tuma metem, eme wouken akem. Apeilake emri wusoubetemkap ere emne etepkapke wusoubetem, eke eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Wouken akem, God eri akek temenem tame erne gabo gulelemenem. Gulelemenem, ere tuma noubke etep tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Jisas, ne Nasaret komri tame. Ne kap nemne be woske nente? Ne nemne pete yawo o? Nema nene laten, ne God Eteri Yen yenbo. Ere nene won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Etep womke, Jisas ere erne tuma etep wom. Ne elen te. Ne ete tame erne mesginin yite. Etep wom, gabo ere ete tame erne selke taren, ere etemri bitimik selke warem. Waren gabo ere erne mesginin yim. Yim, gabo ere erne yaper beke nen, ere bepou me yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bepou me yim, tatame nogwape eme etep lam, eme wouken akem, eme etemwou etemwou etep wom. Eri woye tuma e mapkap tuma? Ere mureken tame etem wobekap, gabo eme eri tuma metbe, eme tame mesginin yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Etep wom, Jisas eri nenem rigrabe, ete tuma e kom komke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas ere God eteri ake mesginin yin Saimon eteri akek yin wurim. Wurim, Saimon eri owi te kapoyi eisau metbetem. Metbetem, eme Jisas erne won tene kobo late wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wom, ere yin tukna tiy mekinke teten teri kapoyi yenbo mette wom. Wom, teri kapoyi yenbo ten agetage te wayen emne iyawu keren, emne awos newon am. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yabel warbetem, tatame eme eikina abona let nai tewo nai tatame emne Jisas eterke panen yam. Panen yam, Jisas ere eri let tatame nogwape emne wurare wurare keren yin, eme yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yenbo metem, gabo yaper eme tatame nogwape emne mesginin yim, eme noubke etepke tebetem. Ne God Eteri Yen. Eme metem, ere Krais, God eter wom tame. Etepkap Jisas ere emne wotaken etep wom. Kem etep mane wote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ei berabetemke, Jisas ere ete kom mesginin tatame berai emik yim. Tatame nogwape eme erne sopen yim. Yin lam, eme erne wotakete wom. Eme etep abom. Ere nemne mane mesginin yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wotakete wom, ere emne etep wom. An God eri kom panen site tuma yenbo akeite komke won sewurte. God ere ane eteke won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Etep womke, ere Judia distrikke temenem, ere God eteri ake nogwape wur sewurbetem, ere emne God eri tuma yenbo wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yuri Jisas ere Genesaret peik kupa barke temenem, tatame nogwape eme yan erne tukukem. Eme God eteri tuma mette yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yam, Jisas ere lam, pere pes peik barke lit sen yawon rasmenem. Rasmenem, omyen petbetem tame eme pere mesginin emri wuli ok keyate yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yim, Jisas ere perek waren sim, ere pere maime, Saimon, erne etep wom. Ne pere reman meike wurte. Etep tem, Jisas ere perek sin ere tatame emne tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tuma wusoubetemke, ere Saimon erne etep wom. Ne pere peik meike piyan yite. Ne, nerenken yaku kerebe tame, kem wuli okke sene rasen omyen pette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon ere erne awosein etep wom. Aneyen, gwopte neir nema yaku eisau kereye, nema omyen beke wuri pet. Neren woyeke, an wuli sene raste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Etep wom, eme yin wuli rasen omyen nogwape wurim. Wurim, wuli omyenken wuyarte kerake tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wuyarte kerake tem, eme emri yaku kerebetem tamesip emne ten yam. Yam, eme pere wurik temenem, eme yan omyen peten pere peske yewon pelawom. Pere peske gergerte nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pere gergerte nenem, Saimon Pita ere etep lan, ere yin Jisas eteri tewo tobok gulke pan etep wom. Aneyen, an wule yaper nenbe tame. Ne ane mesginin yi. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimon Pita eterken temenem tame eme emri petem omyen lam, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon eteri anepoi tame Jemsken Jonken etep kir epe wouken akem. Epe Sebedi eteri yen pes. Wouken akem, Jisas ere Saimon erne etep wom. Ne mane akte. Kiyi ne omyen petbetem. Ne omyen petbekap yuri ne tatame emne etepke pette. Ne tatame emne areri tuma yenbo wusoutek, eme areri wakse tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Etep womke, eme pere lit sen yawon peik barke rasen eme emri wosbas akei mesginin erne semowun yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yuri Jisas ere akeite komke yin temenem, numa pe tame ere ete komke temenem. Temenem, ere Jisas erne lam, ere gulwarke pan guromun ere etep wom. Aneyen, ne abote, ne ane eyarte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisas ere erne let kerelan etep wom. An aboye, ne yenbo tete. Etep womke, eter wobetem tuma tepken erne temenem numa sok tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sok tem, ere erne etep wom. An nene yenbo nenye. Ne eike tamene etep mane wusoute. Agetage ne God eri akek yin God eri akek yaku kerebe tame erne neri wusom erne peterate. Peterate, Moses eri kiyi wom tuma ne etep nente. Ne God erne kwar pete. Etep tete, tatame eme late, eme mette, neri numa sok tem, ne yenbo tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Etep wom, tatame eme Jisas eri nenbetemkap wusowum, akeite komri tatame nogwape eme ete tuma metem. Metem, eme Jisas eteri tuma mette yabetem, emri eikina abona let nai tewo nai tatame emne kir panen yabetem. Jisas ere emne eyarbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Etep tebetem, tewo nogwape ere emne mesginin tatameken berai emik yin God erken tuma ek namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ete yabel Jisas ere tatame emne tuma wusoubetem, Farisi tame, Moses eri wule tuma wusoubetem tame eme yan simenem. Eme Galili distrikri kom nogwape eme yam, Judia distrikri kom nogwape eme yan eme Jerusalem kom mesginin yam. Yam, Keryen God ere Jisas erne mure newom, ere eikina abona letken nai tewo nai tatame emne eyarem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Eyarem, tame kau eme letken tewoken bulworam tame erne tame sebe tiyke yewon sen yam, erne akek sen wurin Jisas eter temenem emik mekinke wurin raste wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Etep tem, emi natekelbesem, eme sen wurlawoyim, eme erne ake magelke sen yawon eme ropo regen tame erne tiyken tatame nogwape emne newokwunen Jisas eteri tewo tobok rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Rasem, Jisas ere lam, eme eteri mure kenawaike abom, eke ere letken tewoken bulworam tame erne etep wom. Ari tamenowu, an neri nenbetem wule yaper an peten sepitye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Etep wom, Moses eri wule tuma wusoubetem tame, Farisi tame eme etemwou etemwou etep namdebetem. E eike tame? Ere etep woye, ere God erne tuma yaper woye. Tame etem eme wule yaper kuyese beke kip peten sepit. Berai. God eterwou ere etep nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Etep womke, Jisas ere emri porere lam, ere emne etep wometem. Kem beke etepkap porere teye? ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","An ete tame erne etep wote. An neri nenbe wule yaper peten sepitte, etep wote, e yaku eisau. O an erne etep wote. Ne noub teten sene yite. An etep wote, etepwou yaku eisau. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","An Tatame Etemne Lan Yeirim Tame, an gwote nowselke tetan. An mureken, an tatame etem nenbe wule yaper an kuyese peten sepitte. Areri mure an kemne peterate. Kem late. Etep womke, ere letken tewoken bulworam tame erne etep wom. An nene wobe. Ne wayen teten neri tukna rowe maime peten sen akek yite. Ere etep wom, ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","agetage ete tame ere tatame etemri bitimik wayen teten eri tukna rowe peten eteri maime akek sen yim. Yibetem, ere God eri sig eisau kir wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wobetem, tatame eme wouken akem, eme God erne tuma yenbo etep wom. Gwopte nema akeite wos, kiyi beke la wos nema laye. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yuri Jisas ere ete akek woran yin lam, takis kel petbetem tame ere takis kel rasbetem akek simenem. Tame eri sig Livai. Simenem, Jisas ere erne etep wom. Ne arenken yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Etep wom, ere etek temenem wos nogwape mesginin Jisas eterken yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Eterken yim, Livai ere awos nogwape Jisas erne eteri akek nenem. Nenem, kel petbetem tame nogwape, akeite tame nogwape eme wurisubuk sin etepken awos abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Abetem, Farisi tameken Moses eteri wule wusoubetem tameken eme etep lam, eme Jisas eri anepoi tame emne etepke wometem. Beke kem kel petbe tameken akeite wule yaper nenbe tatame etemken kem sin awos etep kir abe? E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ere emri wom tuma metem, ere emne tuma awosein etep wom. Tatame eme bepou me tetan, eme kapoyi beke kei, eme dokta emne beke kip yin la. Kapoyi keibe tatame etemwou eme dokta erne yin labe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kau tatame eme etep abobe. An tame yenbo. Etepkap abobe tatame an emne yenbo sene tete wote beke ya. Tatame kau eme etep abobe. An tame yaper. Etepkap abobe tatame an emne etep wote. Kem keremri nenbe wule yaper mesginin God erne kenawaike abote. An etepke nente yam. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ere etep womke, tatame kau eme Jisas erne etep wom. Yabel nogwape baptais ok wirubetem tame Jon eteri anepoi tame eme wule yenbo sebe, eme awos takerbe. Takerbe, eme God erken tuma namdebe. Farisi etemri anepoi tame eme etepkap kir nenbe. Neri anepoi tame eme etep beke nen. Yabel nogwape eme a abe, eme a beke taker. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ere emne awosein etep wom. Tame ere ta panete, ere eri tamenowu emne ta neiste kisbe a ate emne won yate. Ta panete tame ere temente, kap eme ete a mesginte o? Berai. Eme awos abe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yuri ta panete tame ere sene yite, eteri tamenowu eme a takerte. Gwopte an areri anepoi tame etemken tetan, eke eme a abe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Etep womke, ere emne sekur sakur tuma wuri etep wom. Tame eme pekaten tame oub seba tetan, eme mate meg beke peten, etek beke kape. Etep tete, pekaten mate ere eisauwai sene pekate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yurik nenem wain ok tame eme kiyiri ok tibe girbu sebak beke yewo. Etep tem, yurik nenem wain ok ere wayen pelaube, girbu seba ere pekan wain ok ere selke sirpitbe. Etep tebe, girbu ere yaper tebe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yurik nenem wain ok eme girbu agerke yewobe, girbu ere beke kip peka. ");
INSERT INTO yss_yawu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tame eme kiyiri wain okwou abe, eme yurik nenem wain ok abe, eme beke metekwas. Eme etep wobe. Kiyiri ok e yenbo. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yuri akeite ege si yabelke Jisas ere eteri anepoi tameken eme wit now borke yibetem. Yibetem, anepoi tame eme wit supa kwosin letke sen, eme ek am. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Am, Farisi tame eme lan etep wom. Neri anepoi tame eme ege si yabelke wit supa kwosin abe, eme neremri wuleke tousibe. E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisas ere emne awosein etep wom. Devit ere kiyi temenem keryen. Eri nenemkap eme bas rasem. Kap kem ete siglou beke la? Kiyi Devitken eteri wakseken eme kwoi sabetem, kap be aomke am? ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kwoi sabetem, Devit ere God eteri ake eisauke wurin God eterne newon rasem geil ere peten am. Am, ere eteri wakse emne kir newon am. Neremri wule eme kir tousim. Nemri wule gwopkap. God erne newobe geil God eri akek yaku kerebe tame etemwou eme abe. Devit eter, eteri wakseken eme am, eme emne tuma beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","An Tatame Etemne Lan Yeirim Tame. Aren, an ege si yabelri Keryen Tame. Aren, an tatame emne wote, be wos ege si yabelke nente wote, eme kuyese nente. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Akeite ege si yabel Jisas ere God eteri akek yin wurin tatame emne tuma wosoubetem. Wosoubetem, let yaper te tame ere simenem, eri ya mame e yaper temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Simenem, Moses eri wule wusoubetem tame etem, Farisi tameken etem eme Jisas erne tuma namdete kelu sopte wom. Etepkap, eme erne lek ten etep abom. Ere kap tame erne ege si yabelke eyarte, o berai? Ere eyarte, nema erne tuma namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Etep abom, Jisas ere emri porere lan ere let yaper te tame erne etep wom. Ne wayen teten gwok ya. Etep wom, ere wayen etek tetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tetem, Jisas ere tatame emne etep wom. An kemne wometbe. Nemri wule mapeke wobe? Ege si yabel nema beke nente? Ege si yabelke nema wos yenbo nente, o nema wos yaper nente? Ege si yabel tame wuri ere sate kerake tetan, nema erne kobo lan eyarte, o nema erne yaper nenen ere sate? ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Etep womke, ere emne lan sewuren let yaper te tame erne etep wom. Ne neri let tai. Let tayemke, eri let yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yenbo tem, Farisi tame, Moses eri wule tuma wusoubetem tame eme etep lam, eme pap wayen etemwou etemwou etep wom. Nema Jisas erne pen sate. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jisas ere kowke yawon God eterken tuma namden yin eiken beram. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ei beram, ere eri anepoi tame emne wopetem, ere emne ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) tame emne wom. Wom tame emri sig gwo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wuri ere Saimon. Jisas ere erne akeite sig Pita wom. Wuri ere Andru, Saimon eteri mase. Akeite tame eme Jems, Jon, Filip, Bartolomyu, ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas. Wuri ere Alfius eteri yen Jems. Wuri ere Saimon, eri sig wuri Selot. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Wuri ere Judas, Jems eteri yen. Wuri ere Judas Iskariot. Yuri ere Jisas erne yena tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas eteri anepoi tameken eme kow mesginin warem, wurselke tetem. Tetem, tatame nogwape eme yam. Judia distrikri tatame, Jerusalem komri tatame, peik barke tetan kom pes Tairken Saidonken ete komri tatame eme etep yan temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yam, eme Jisas eri tuma mette yam. Ere let nai tewo nai tatame emne yenbo nente yam. Gabo yaper gulelemenem tame etem kir eme yam, Jisas ere gabo emne pekeroukbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pekeroukbetem, eme abom, Jisas ere mureken temenem, eke tatame nogwape eme erne let kerete yam. Eme yenbo tete eke abom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas ere eri anepoi tame emne lan etep wom. Kem eikse akse tatame, kem metekwaste. God ere kemne kom panen sibe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gwopte kwoi sabe tatame kem metekwaste. Kem a an se kir tete nenbe. Gwopte kerabe tatame kem metekwaste. Yuri kem sou sak keyete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","An Tatame Etemne Lan Yeirim Tame, kem ane kenawaike abobe. Etepkap, tatame eme kemne beke metekwas, eme kemne magel taite, eme kemne tuma yaper wote, eme kemne etep wote. Kem tatame yaper. Etep tete, kem metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kemri tokwo eisau e God eteri komke tetan, eke kem metekwaste. Gwopte tetan tatame etemri yeiwarege eme God eri tuma wusoubetem tame emne kir yaper nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Wosbasken tame, kem selpap yaper tete nenbe. Gwopte kem wosbasken, kem metekwasbe. Yuri kem beke kip metekwas. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Gwopte a an, se kir tebe tatame, yuri kem selpap yaper tete, kem kwoi kenake sate nenbe. Gwopte sou sak keyebe tatame, yuri kem selpap yaper tete, kem keratirte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tatame nogwape eme kemri sig eisau wobe, yuri kem selpap yaper tete. Etemri yeiwarege kiyi eme yikwokwo tuma wusoubetem tame emri sig eisau kir wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ari tuma metbe tatame, an kemne wobe. Kem kemri peiktame emne pap yewote. Tatame eme kemne beke metekwas, kem emne noub nente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tatame eme kemne tuma yaper wobe, kem emne tuma yenbo sein wote. Tatame eme kemne yaper nenbe, kem emne God erken tuma namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tame eme kemne pouyek buroute, kem sene ep yekwo pouye sene taite, eme sene etek buroute. Tame eme kemri tame oub pette wote, kem emne tame oub wurisubu mane newote. Kem emne peske newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tame eme kemri wos bepou me pette wote, kem emne eger mane tete. Kem emne bepou me newote. Newote, yuri kem emne mane etep wote. Ne nemne awosein newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Be wos kem abobe, akeite tatame eme kemne yenbo nenbekap, kem emne etepwou nenbetete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kemne pap yewobe tatame etemwoune kem pap awosein yewobe, kem tatame yenbo beke kip te. Wule yaper nenbe tatame eme etep kir nenbe. Emne pap yewobe tatame eme emne awosein pap yewobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tame eme yaper nenbe tame emne yenbo nenbe, yaper nenbe tame eme emne yenbo awosein nenbe. Eme akeite tame emne yenbo beke nen. Kerem, kem akei tatame emne yenbo nente. Kemne yenbo nenbe tame etemnewou kem yenbo nente, God ere kemne noub beke kip nen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yaper nenbe tame eme akeite yaper nenbe tame emne wos newobe. Newobe wos eme yuri awosein petbe. Kerem, kem wos newote, kem awosein pette mane abote. Wos awosein newote tame etemnewou kem newote, God ere kemne noub beke kip nen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kem kemri peiktame emne pap yewote, emne wule yenbo nente. Kem tame emne wos newote, kem awosein pet mane abote. Kem etep nente, yuri kem awosein tokwo eisau pette nenbe. Kem Hevenke tetan God eteri yen seken tete nenbe. God eterne pir beke wo tatame, yaper nenbe tatame God ere emne kobo metbe. Kem etep emne kir nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","God ere kemne kobo labekap, kem akeite tatame emne etep kir kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kem akeite tame emri porere, emri nenbekap mane etep wote. Eme tame yaper. Kem etep nente, God ere kemne awosein si lan etep wote. Kem tame yaper. Kem tatame emne tuma mane namdete. Kem etep nente, God ere keremne tuma awosein namdete. Tame eme kemne yaper nente, kem emne tuma mane wote. Kem etemken me gerute. Kem etep nente, keremri yaper nenbekap, God ere wan gette, ere sene beke kip abo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kem akeite tame emne wos newote, God ere kemne awosein newote, wos nogwape neri let pelaute nenbe. Kem tatame emne wos newobekap, God ere kemne awosein etepke newote nenbe. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sene ere emne sekur sakur tuma emne etepke wusowum. Le si tame eme akeite le si tame emne kelu kuyese beke kip petera. Eme emne kelu peterate, eme me belen yin emi yaperke warte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Porere petbe yen eme etemri tuma wusoube tame emne beke teitkwun. Eme porere noub pette, eme etemri tuma wusoube tame etemkap tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kem geisimase etem nenbe yaper wos nebule mane abote. Beke kem etemri yaper nenbe wule nebule si labe, kemri nenbe wule yaper eisau kem beke la? ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kerem nenbe wule yaper e eisauwai. Kem geisimase emne etep mapeke wobe. Kem nenbe wule yaper nebule an nene peterate, God ere eyarte. Etep wobe. An kemne wobe, kem tuma yikwokwobe tame. Kem kerem nenbe wule yaper kiyi mesginte, sene kem geisimase etem nenbe wule yaper kuyese lan peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Me yaper eme supa yenbo beke kip ya. Me yenbo eme supa yaper beke kip ya. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tame eme me supa labe, eme abobe, e me yenbo o me yaper. Tame eme mane supa kwoste, eme kwaye supa beke kip kwos. Eme keibe supa kwutete, eme lagken kupunubur supa beke kip kwute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tame yenbo eme porere yenbo tetan, eme wos yenbo nenbe, eme tuma yenbo wobe. Tame yaper eme porere yaper tetan, eme wule yaper nenbe, eme tuma yaper wobe. Tame emri porere tetankap, eme wobe tuma eme etepkap wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Beke kem ane keryen, keryen wobe, sene kem ari tuma kelu beke tobo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Arenken yabe tatame, areri tuma kelu tobobe tatame eme mapkap? ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ete tatame eme ake kerebe tamekap. Eme kwat mei eisau kiyi peren waren yuri eme seg yewobe wulekap eme kiyi pape sogwunen sel ek yenbe. Yenbe, yuri ok ere wayen gwomun ake erne rube, ake ere beke tere. Tame eme ake yenbo kerebe, ete ake ere beke kip tere. ");
INSERT INTO yss_yawu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ari tuma meten beke tobo tatame eme akeite ake kerebe tamekap. Eme kwat mei eisau beke per. Yuri ok ere wayen gwomun, agetage ake ere teren ake ere yaperwai tebe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas ere ete tatame emne tuma wusowun omon, ere Kaperneam komke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yim, Romri ei nai apeilake ere etek temenem. Temenem, ere eri yaku kerebe tame wuri erne metekwasmenem. Ete yaku kerebe tame ere kapoyi meten sate kerake tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sate kerake tem, ei nai tame emri apeilake ere etep metem, Jisas ere yam. Etep metem, ere Juda etemri apeilake emne won yim, eme Jisas erne womette yim, ere ete yaku kerebe tame erne yenbo nente wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jisas erne yin lam, eme erne noub etep wom. Ei nai tame etemri apeilake ere tame yenbo. Ne erne kobo late, ne eteri yaku kerebe tame erne eyarte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ere Juda tame berai, ere nemne pap yewobe. God eteri ake wuri ere nemne kerem. Etepkap ne eri yaku kerebe tame erne eyarte. Ere kip sate wurken. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jisas ere etemken yin ere ake mekinke yan tebetem, ei nai tame emri apeilake ere eteri tamenowu emne won yan eme Jisas erne etep wom. Ei nai apeilake ere etep woye. Me teye. An nene yaku newote wurken. An tame yenbo berai, ne ari akek mane yan worate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","An tame yenbo berai, eke an nene beke kip yan la. Ne tumawouke wote, ari yaku kerebe tame ere yenbo ek mette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","An apeilake, an akeite apeilake eteri kulke tetan. Ari ei nai tame eme ari kulke tetan. An ei naite tame wuri erne yite wobe, ere ek yibe. An akeite erne yate wobe, ere ek yabe. An ari yaku kerebe tame erne yaku kerete wobe, ere ek kerebe. Etepkap an metten, ne keryen, ne tumak wote, areri yaku kerebe tame ere yenbo tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas ere ete tuma metem, ere wouken aken peikkeren erne semoumenem tatame nogwape emne etep wom. An kemne wobe. Ete tame ere kenawaike abobekap, Juda tame eme etepkap kenawai beke abo. Ere emne teitkwunten. Ere metten, an let nai tewo nai tame emne kuyese eyarte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Etep womke, ei nai tameri apeilake eri won yam tame eme apeilake eri akek sene yim. Yin lam, yaku kerebetem tame ere yenbo metem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yuri Jisas ere Nain komke yim, eri anepoi tame, nogwape tatameken eme eterken yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yim, ere kom ser eru mekinke temenem, komri tatame eme sam tame wuri erne sen yam. Sam tame eteri nawo te wane ta. Teri yen wurisubuwai eter sam. Ere sam, nogwape tatame, wane taken eme tame kupa sen yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sen yibetem, Jisas ere wane tene lam, ere tene kobo kenake lan tene etep wom. Ne mane kerate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Etep womke, ere yin ere tame kupa rasmenem tiy let kerem. Kerem, tiy sen yibetem tame eme sene beke yi, eme etek sen tetemenem. Tetemenem, Jisas ere etep wom. Tame taureyen, an nene wobe. Ne wayen site. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Etep wom, sam tame ere sene wayen sin ere tuma sene namdem. Tuma sene namdem, Jisas ere yen erne nawo tene newom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Newom, nogwape tatame eme aken God eri sig eisau etep wom. Tuma wusou tame ere yan neremken tetan. Eme sene etep wom. God ere eri tatame emne sene pette yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Etep wom, Jisas ere nenemkap Judia distrik komri tatame, mekinke temenem komri tatame eme akei metem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Baptais ok wirubetem tame, Jon, eri anepoi eme Jon erne Jisas eri nenbetem wule akei wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jon ere eri anepoi tame pes epne won yam. Yam, ere epne etep wom. Kiyi an wom. Tame wuri, Krais, ere yate nenbe. Kep yin Jisas erne tuma wuri etepke womette. Ne Jon eter kiyi wom tame, o nema akeite tame erne koute? ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Etep wom, eke ere epne Jisas eterne yin late wom. Yin lam, epe Jisas erne etep wom. Baptais ok wirube tame, Jon eter, ere nesne woye, eke nesa yawo. Nesa nene tuma wuri womette. Ne kap Jon eter kiyi wom tame, o nema akeite tame erne koute? Etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Epe yamenem yabel, Jisas ere eikina abona let nai tewo nai tatame emne eyarbetem. Gabo yaper emne ere pekeroukbetem. Le simenem tatame nogwape ere emne noub eyarem, eme kuyese sene labetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Etep nenbetem, ere Jon eteri anepoi tame epne awosein etep wom. Kep sene yin Jon erne kepri laye wos, kepri metbekap erne etep wusoute. Le si tatame emne an eyarbe, eme le sene kuyese labe. Tewo yaper tetan tatame an emne eyarbe, eme sene kuyese yibe. Numa pe tame an emne eyarbe, eme sene noub tetan. Wan si tatame an emne eyarbe, eme wan sene kuyese metbe. Sam tatame an emne wobe, eme wou sene petbe. Eikse akse tatame emne an God eteri tuma yenbo emne wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tame eme ari nenbekap lan etep abote, gwo tame God eter ere erne won yam. Etep abote tame emri selpap e yenbo. Eme selpap pes berai, etepkap eme metekwaste. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon eri anepoi epe sene yimke, Jisas ere tatame emne Jon eterne etep wom. Kiyi kem tameken berai emik yim, Jon erne late yim, kem be woske late yim? Kap kem etep abobetem, Jon ere polik sen yibe me takekap, ere mureken berai. An kemne wobe. Ere etepkap berai. Ere mureken tame. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kap kem etep abobetem, yenbotanbo tame oub warbe tame erne nema late. An kemne wobe. Jon ere tame oub yenbo beke war. Yenbotanbo tame oub warbe tame, wosken tame eme tameken berai emik beke kip yin sewur. Eme ake yenbok temenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kap kem etepke abobetem, nema God eteri tuma wusoube tame erne late. Ye. An kemne wobe. Jon ere God eteri tuma wusoube tame. Ere kiyiri tuma wusoube tame emne akei teitkwunbe. Ere tame eisau. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","God ere bas rasem tuma Jon eterne wobe. Metye. Areri tuma wusoube tame ere nene taresin yite. Ere neri yate kelu eyarte. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jisas ere sene wom. An kemne wobe. Jon ere nowselri tatame nogwape emne epiye tetan. Jon eri kin yekwok ane kenawaike abote tatame eme mette, an etemri nenbetem wule yaperke sate. Jon ere etep beke met. Etepkap, God eri kom panen simenem komri tatame etemri sig nebuleken tame, emri sig e Jon eri sig epiye tete nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tatame nogwape kel petbe tameken eme eri tuma metem, eme etep wom. God eri wule yenbo. Etep wom. Kiyi ete tatame eme emri wule yaper aken mesginin Jon ere emne baptais ok wiruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farisi tame, Moses eri wule porereken tame etem eme God eri tuma magel tayem, emne baptais ok wirute mo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisas ere etep wom. Gwopte tetan tatame eme mapkap tatame? An kemne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Eme ake maklek sou teten sewurbe yenkap. Eme akeite yen emne tuma won etep wobetem. Nema sekwo lombe, me pebe, kem sekwo kir beke lom. Nema wokerabe, kem nemne kir beke panen kera. Nerem tebekap kem etep beke nen. Yen etem eme etep wobetem. Be wos yen eme nenbetem, akeite yen eme yaper wobetem, eme beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Baptais ok wirubetem tame, Jon, ere yan yabel nogwape ere awos beke a, wain ok kir beke a. Kem ari woye tame, kem erne lam, kem etep wom. Ete tame ere etep nenbe, erne gabo guleleten. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","An Tatame Etemne Lan Yeirim Tame, an yam, an a abe an wain ok kir abe, kem ane etep wobe. Ek la. Ere a kenake abe tame. Ere wain ok kenake abe tame. Ere kel petbe tameken akeite wule yaper nenbe tame etemken gerebe. Kem etep wobe. Be wos an nenbe, kem etep wobe. E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","God eri porere petem tatame eme metten, God eri porere e seken. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi tame ere Jisas erne wom, ere eterken a ate wom. Wom, Jisas ere eteri akek yin sin a abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Abetem, ta wuri te wule yaper tobobetem ta, te ete komke temenem. Temenem, te metem, Jisas ere Farisi tame eteri akek a abetem. Etep metem, te papek nenem gin peten sen ek yim. Gin e kwar yenbo yewomenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Te yin Jisas eri magel ganke teten eteri tewo tobo mekinke keram. Kerabetem, le ok Jisas eteri tewo luke yeirbetem, te Jisas eri tewo etetri tare takek saketem, te eri tewo etetri ragike bwoyin eri tewo kwar pebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jisas erne a ate wom Farisi tame ere etep lam, ere eter maime etep wom. Jisas ere God eri tuma wusoube tame seken berai. Ere seken temente, erne let kereye ta teri nenbe wule yaper, ere etep noub mette. An labe, ere etep tene beke met. Ere maime etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas ere erne etep wom. Saimon, an tuma wuri nene wote. Saimon ere etep wom. Tuma wusoube tame, ne ane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ere etep wom. Kel newobe tame ere tame pes epne kel newom. Tame wuri erne ere 100 kina newom, tame wuri erne ere 10 kina newom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yuri epe kel berai, epe awosein beke newo. Kel newom tame ere etep wom. Etep temenem. Ane sene mane newote. Etep wom, eike kenawaike metekwasem? Eike kerake metekwasem? ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon ere awosein etep wom. Ete tame ere kel nogwape petem, ete kel ere maime erne sene beke newo, eter ere metekwaswai tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Etep wom, ere ta tene petkwo lan Saimon erne etep wom. Gwo ta ne tene laye. An neri akek yan woraye, ne ane tewo ok keyate ok beke newo. Ete ta te ari tewo etetri le okke keyaye, etetri tare takek okse saketeye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne ane beke metekwas, ne ane beke bwoi. An yan woraye, ete ta te ane tewo etetri ragike bwoiwo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ari tare ne kwar beke pe. Etet te ari tewo kwar peye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","An nene wobe. Te ane metekwasye, ane pap yewoye, an teri wule yaper peten sepitye. Eike tatame eme wule yaper nen kerake nente, ete tatame eme ane pap kerake yewote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Etep wom, Jisas ere ta tene etep wom. Neri wule yaper an peten sepitye. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tame eme eterken sin a abetem, eme etemwou etemwou namdem. Ete tame ere eike? Ere wule yaper peten sepitbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Etep wom, Jisas ere ta tene etep wom. Ne ane aboye, etepke an neri wule yaper peten sepitye, God ere nene sene petye. Ne selpap yenbo meten yite. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yuri Jisas ere kom komke yin sewurbetem, ere tatame emne God eri kom panen site tuma wusowum. Eri ep yekwo let ep yekwo let tewo bor pes (12-pela) keyem tame eme eterken sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ta kau kiyi gabo emne gulelemenem, Jisas ere gabo pekeroukum, ta kau kiyi eme let nai tewo naimenem, ere emne eyarem. Ete ta etem kir eme eterken sewurbetem. Ta wuri te erken sewurbetem, teri sig Maria. Te Makdala komri ta. Kiyi gabo ep yekwo let ep yekwo let bor pes keyem (7-pela) eme tene gulelemenem, Jisas ere ete gabo emne pekeroukem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Akeite ta te eterken sewurbetem, teri sig Joana. Te Herot eteri ake lakerebetem tame, Kusa, eteri ta. Akeite ta teri sig Susana. Ta nogwape eme Jisas eterken sewurbetem, ete ta eme Jisas erne, eri anepoi tame etemne kobo lan emne kelken awosken newobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kom komri tatame nogwape eme yan Jisas erne late yabetem. Yabetem, eme Jisas eter temenem emik yabetem, Jisas ere emne sekur sakur tuma wuri etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Tame ere wit supa peten nowke yin panbelen sewurem. Panbelen sewurem, wit supa kau keluke yeirim, tame eme yan tewok teitem, eke ap eme yan ete supa am. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Supa kau pape luke yeirin pam wayem. Pam wayem, sel okken berai, eke supa eme sok ten akei saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit supa kau eme keikei waboi somok yeirin pam wayem, keikei waboiken witken etep eme kir wayem, wit emne keikei waboike bureren yaper tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wit supa kau eme sel yenbok yeirin rekwan eisau tem, eme supa nogwape yam. Wurare wurare eme supa nogwape (100) yam. Etep wom, Jisas ere sene wom. Metye. Tatame eme wanken eme wan wurik mette. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas eri anepoi eme erne sekur sakur tuma somo wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jisas ere awosein etep wom. God eri kom panen site tuma kiyi berasmenem an kemne wusoube. Keremwou kem noub metbe. Akeite tatame emne an sekur sakur tumawou wobe, eme noub beke met. Eme emri lek labe wos eri somo eme beke la. Eme tuma metbe, tuma somo eme beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ari kiyi woye sekur sakur tuma somo ere gwo. God eteri tuma e wit supakap. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tatame kau eme God eri tuma metbe, eme keluke yeirbe wit supakap. Eme tuma metbe, sene Satan ere yan ete tuma peten sepitbe. Ere etepke abobe. Eme kenawaike mane abote, God ere emne kip pette wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tatame kau eme tuma metbe, eme pape luke yeirbe witkap, eme God eri tuma agetage meten pap yewon metekwasbe. Kerake ten, sene akeite wos emne seilabe, eme God erne sene mesginbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tatame kau eme tuma metbe, eme keikei waboi somok yeirbe wit supakap. Eme God eteri tuma metbe, sene eme nowselri wosken kelken etewouke abobe, eke ete woske emne ragerbe. Etep tebe, eme God eri yaku noub beke kere. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tatame kau eme tuma metbe, eme sel yenbok yeirbe wit supakap. Eme tuma metbe, eme noub sebe, eme God eri yaku kerebe, eme noub yenboke nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tame eme lam yarbe, eme ouke beke gumkere, o eme tiy kulke beke tuk. Berai. Eme tiy mekerke tukbe, eme le kuyese labe, tame eme akek wurbe, eme kuyese labe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gwopte berasten wos, yuri ete wos tatame nogwape eme late nenbe. Wos nogwape gwopte berasten, yuri eme mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kem tuma noub mette. Porere yenbo tetan tatame eme tuma metbe, eke tuma somo eme kir metbe. Ete tatame an emne tuma sene wusoute, eme sene mette. Porere yaper tetan tatame eme tuma metbe, eke tuma somo eme beke kip met. Emri metyekap eme sene wan getbe. Ete tatame an emne tuma sene beke kip wusou. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisas ere tuma wusoubetemke, eri nawoken maseken eme erne late yam. Yam, tatame nogwape eme wurisubuk wurmenem, eke eme kom genik tetpete wurmenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Etep tem, tame wuri ere Jisas erne etep wom. Neri nawoken maseken eme ep yekwo kom genek kouten. Eme nene late yawo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisas ere erne awosein etep wom. Eike tatame eme God eri tuma meten tobobe, ete tatame etem eme areri nawokap areri geisimasekap. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yuri Jisas ere eteri anepoiken eme perek warem, ere emne etep wom. Nema peik kupa keraruke wute. Etep won, eme ek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yibetem, Jisas ere perek tuknamenem, marye eisau yam, ok sare pere barke ten bolan wayen pelaute nenbetem, eme sate kerake tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Etep tem, anepoi tame eme Jisas erne yan teren wayen sin etep wom. Aneyen, nema sate nenbe. Etep womke, Jisas ere wayen teten maryeken ok sareken epne wotaken, maryeken ok sareken epe beyim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Beyimke, ere emne etep wom. Mapeke teye, kem ane kenawaike beke abo? Etep wom, eme wouken aken etemwou etemwou namden etep wom. Ete tame ere eike? Ere maryeken ok sareken wotakeye, epe eri tuma meten agetage beiwo. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Eme sene yibetem, eme Galili peik kupa keraruke yin Gerasa yekwok yin gayim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yin gayin ere barke yawon tetem, kom sagri tame wuri ere erne yan etek lam. Gabo eme ete tame erne gulelemenem. Gulelemenem, ere mate beke ger, ere akek beke te. Ere tame sele mei temenem emik temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ere Jisas erne lam, ere taye pitin eteri tewo tobok waren tuknan erne noubke etep wom. Jisas, ne Keryen God Eteri Yen. Kap ne ane mapeke tete nenbe? An nene wobe. Ne ane mane pete. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kiyi Jisas ere gabo erne etep wom. Ne tame erne mesginte. Etep wom, eke tame ere etep wom. Kiyi tewo nogwape gabo ere tame erne keresukbetem, tatame eme erne peten erne let tewo waia kepke peikrasen erne akek won yibetem. Akek yin tebetem, ere kep roborasen, gabo eme tame erne gulelemenen tame berai emik yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisas ere ete tame erne etep wometem. Neri sig map? Ere awosein etep wom. Ari sig Ei Nai Tame Nogwape. Eme gabo nogwapewai, etepkap eri sig ete Ei Nai Tame Nogwape. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Gabo eme Jisas erne worwor etep wom. Ne nemne mane won ker tetan komke yite. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Por nogwape eme mekinke temenem, eme kowke an sewurbetem. An sewurbetem, gabo eme Jisas erne etep wom. Ne nemne ete por etemne won yite. Jisas ere awosein etep wom. Kem epe yi. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Etep womke, gabo eme ete tame erne mesginin yin, eme por etemne yin gulelem. Gulelem, por eme agetage amekirin yin emi yaperke warkuten peik kupak kerpen okke an saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Saiwom, por lakerebetem tame eme etep lam, eme amekirin yin kom sagri tatame, boul komri tatame emne emri lam wos wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wusowum, tatame eme metem, eme ete wos late yim. Yin lam, kiyi gabo gulelemenem tame ere tame oub waren Jisas eri tewo tobok simenem. Simenem, eri porere yenbo temenem. Temenem, tatame eme etep lan, eme akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Akem, Jisas ere gabo gulelemenem tame erne noub nenem kiyi yan lam tatame eme yuri late yam tatame emne emri lam woskap etep wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wusowum, Gerasa yekwori tatame eme etep metem, eme kenake aken Jisas erne etep wom. Ne nemne mesginin yite. Etep wom, ere perek waren sin ere sene yite wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Sene yite wom, kiyi gabo erne gulelemenem tame ere erne etep wom. Sen. Nesa etep yite. Jisas ere erne wotaken erne sene won erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ne neri komke sene yite. God ere nene nenemkap, ne kom tatame emne etep wusoute. Etep wom, tame ere eteri komke sene yin Jisas ere erne nenemkap ere tatame emne etep wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas ere peik kupa keraruke sene wum, tatame nogwape eme erne etek koumenem. Koumenem, eme erne lam, eme metekwasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Metekwasem, God eteri akek yaku kerebetem tame, eri sig Jairus, ere yan Jisas eteri tewo tobok waren erne etep wom. Ne ari akek yate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ari yedeyen te sate nenbe. Ne tene eyarte. Etep wom. Eri yen te wurisubuwai. Teri nabe ep yekwo let ep yekwo let tewo bor pes keyem (12-pela). Eme etep keluke yibetem, tatame nogwape eme Jisas eterken mekin mekin kirkir yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Yibetem, etemri wuri te worta sibetem, nabe ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) te worta sibetem. Worta sibetem, te dokta emne late yim, eme tene beke eyar. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Beke eyar, eke te yan Jisas eri tame oub megke kerelam. Letke kerelam, teri sibetem worta omom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Omom, Jisas ere etep wom. Eike ane let kerelaye? Tatame nogwape eme etep wom. An berai. Pita ere etep wom. Aneyen, ne laye. Tatame nogwape eme nerenken mekin mekin kirkir yibe, kau eme nene tigerye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jisas ere etep wom. Ari mure kau yiwo. Ta o tame ane let kerelaye, eke ari mure kau yiwo, an etep metye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Etep womke, ete ta te abom. Ere ane laye. Etep abom, te aken poipoi yin Jisas eteri tewo tobok warem. Warem, te tatame nogwape etemri bitimik teri let kereye tuma somo erne wusowum. Te etep wom. An worta sibetem. Gwopte an nene let kerelaye, eke agetage ane sibe worta omoye, eke an yenbo teye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisas ere tene etep wom. Ari yen, ne ane kenawaike aboye, an nene eyarte. Etep aboye, eke ne yenbo metye. Ne wayen teten noub me yin site. Ere tene etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ere som wobetem, tame wuri ere Jairus eri ake mesginin yam, Jairus erne etep wom. Ne tuma wusoube tame erne mane panen yate. Neri yen te saye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisas ere etep metem, ere Jairus erne etep wom. Ne mane akte. Ne ane kenawaike abotek, neri yen te sene yenbo tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Etep won eme sene yin Jairus eri akek yam. Yam, tatame nogwape eme eteri akek kir wurte wom, Jisas ere emne wotakem. Wotaken ere Pita, Jon, Jems, anenawo etemwou eme eterken wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wurim, tatame nogwape eme etek siyewon, yen tene keratirbetem. Keratirbetem, Jisas ere emne etep wom. Kem mane kerate. Te beke sa. Te bepou me tuknaten. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Etep womke, eme eri wom tuma sou sakken keyetirbetem. Eme etepke abom. Te me saye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Eme sou sak keyetirbetemke, Jisas ere yen etetri letke keren tene etep wom. Yen, ne wayen site. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Etep wom, yen teri wou sene yam, te agetage wayen sene sim. Sim, Jisas ere anenawo epne etep wom. Kep tene a newon ate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Etep womke, anenawo epe wouken akem. Wouken akem, eke Jisas ere epne etep wom. Ari nenyekap kep tatame emne mane wusoute. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas ere eri ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) anepoi tame emne won yam, ere emne etep wom. An kemne mure newote, kem gabo nogwape kuyese pekeroukte, let nai tewo nai tatame emne kuyese eyarte. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Newom, ere emne God eri kom panen si tuma wusoute, let nai tewo nai tame emne yenbo nente won yite wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yite wom, ere emne etep wom. Kem wos mane sen yite. Kem kwokwul mane sogwunen yite. Ayer mane peleikte. Awos, kel mane kir peten sen yite. Tame oub pes mane sen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ma komke kem yite, eme kemne emri akek panen yite, kem eteri akewouke yin temente. Kem akeite akeite akek mane yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma komke kem yite, eme kemne yaper nente, kem ete kom mesginin yite. Yite, kem tewo subu etek nubutkwunte. Ete komri tatame eme etep lan, eme etep abote. O nema emne yaperke nenye, eke yuri God ere nemne yaper awosein nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Etep womke, eri anepoi tame eme kom komke yin God eri tuma yenbo wusowun, sewurbetem, let nai tewo nai tatame emne yenbo nenen sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Apeilake Herot ere Jisas eri nenbetemkap metem, ere ep abon ep abom. Tame kau eme etep wobetem. Baptais ok wirubetem tame, Jon, ere selek sene wayem, ere mure peten, ere eke rigrabe nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kau eme etep wobetem. Elaija ere selek sene wayem, ere ete rigrabe nenbe. Kau eme etep wobetem. Kiyi temenem tuma wusoubetem tame etemri wuri ere sene wayem, ere eke rigrabe nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Etep wobetem, Herot ere etep wom. An metbe, tame wuri ere rigrabe nenbe. Kap ere eike? Ere Jon berai. Jon erne an kiyi wak regem. Etep wom, ere Jisas erne late abom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisas ere won yim tame eme sene yan emri nenbetem nogwape woskap eme Jisas erne wusowum. Wusowum, ere emne panen etemwou Betsaida komke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yim, tatame eme etep metem, eme erne semowun yim. Yim, Jisas ere etep lam, ere emne metekwasen, ere emne God eri kom panen siten tuma yenbo wusoubetem, ere let nai tewo nai tatame emne eyarbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Eyarbetem, perpe yabel warbetem, Jisas eri ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) anepoi tame eme yan erne etep wom. Nemri tetan emi gwo e tameken berai. Ne tatame emne won eme kom komke yin awos peten an etek tuknate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jisas ere emne etep wom. Kerem, kem emne awos newon ate. Etep womke, eme erne awosein etep wom. Nema a berai. Nema geil ep yekwo let omyen sok peswouke tetan. Ne mapeke abobe? Nema yin tatame nogwape emne a tukte o? Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tame nogwapewai (500) eme temenem, Jisas ere anepoi tame emne etep wom. Kem emne wote, eme nogwape nogwape kenakena (50 50ke) site. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eri anepoi tame eme tatame nogwape emne etepke won sim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Simke, Jisas ere geilken omyen sokken peten sen ere le nelke niru lan God erne pir wom. Pir wom, ere geilken omyen sokken pekayewon eri anepoi tame emne newom. Newom, eme peten tatame nogwape emne newopit peteyam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Newopit peteyam, eme an se kir tem, a tep anepoi tame eme peten kwora sare ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) etek yewon pelawon yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yuri Jisas ere kena wiwi God erken tuma namdebetem, eri anepoi tame eme eterken temenem, ere emne etep wom. Tatame nogwape eme ane mapeke wobe, an eike? ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eme erne awosein etep wom. Kau eme etepke wobe. Ne tatame emne baptais ok wirubetem tame Jon. Kau eme nene etep wobe. Ne kiyi temenem tuma wusoubetem tame Elaija. Kau eme nene etepke wobe. Ne God eri kiyi temenem tuma wusoubetem tame etemri wuri, ne selek sene wayem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ere emne etep wom. Kerem, kem ane mapeke wote, an eike? Pita ere awosein etep wom. Ne Krais, God eter nene won yam tame. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ere etep womke, Jisas ere emne wotaken emne etep wom. Pita eri woye tuma kem tatame emne mane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ere emne sene etep wom. An Tatame Etemne Lan Yeirim Tame, an mus eisau nogwape mette nenbe. Juda etemri apeilake tameken God eri akek yaku kerebetem tameken emri apeilake Moses eri wule tuma wusoubetem tameken eme ane magel taite, eme ane pen sate nenbe. Yabel pes tete, mur wote, God ere ane wote, an wou sene peten sene wayen yite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Etep wom, ere anepoi tame akei emne etep wom. Eike tame eme arenken anepoi yite, eme gwopke tete. Eme maime teitkwunte. Ari mette muskap eme kwokwos kwokwos kir etep sete. Eme etep tete, eme arenken yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tame eme emri maime wusomwou abote, eme yaper tete nenbe. Tame eme arenwoune kenawaike abote, eme maime wusom beke abo, yuri eme yenbo som temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tame eme nogwape nowselri woswou pette abobe, yuri eme yaper temente, etepkap e yenbo o? Berai. E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tatame eike eme ane sebera yate, ari tuma kir sebera yate, yuri Tatame Etemne Lan Yeirim Tame, ere sene yate, ere ete tatame emne awosein sebera yate, emne kobo beke kip la. Ere yate, ere Apei eteri mureken God eri kom tame etemri mureken yate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","An kemne sekenke wobe. Gwotepte gwotek tetan tatame kau eme beke sa, eme late, God ere kom panen site yabel tete nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sande wuri temke, Jisas ere Pita, Jon, Jems emne panen kowke God erken tuma namdete yawom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yawom, ere tuma namdebetem, eri bitimi kaspem, epkapke lam. Lam, eri warmenem tame oub ere kaspen geipasubuwai tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jisas ere etek temenem, agetage kiyi temenem tame pes, Mosesken Elaijaken, epe yan Jisas erken tuma namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Namdebetem, God eteri mureken yan, epe Jisas eterken God eri kiyi wom tuma namdebetem. Kiyi God ere etep wom. Jisas ere Jerusalem komke sate nenbe. Eme sene etepke namdebetem. Kerake tete, Jisas ere Jerusalemke sate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Etepke namdebetem, Pitaken anepoi tame pesken eme tuknamenem, eme sene wayen sin lam, Jisas eri wus kaspen epkap lam, tame pes epe eterken yan tetemenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yan temenem, epe sene mesginin yite wom, Pita ere Jisas erne etep wom. Aneyen, nerem gwotek tetan, e yenbowai. Nema ake mur kerete. Wuri nereri, wuri Moses eteri, wuri Elaija eteri. Ere etep bepou me wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Etep wobetem, nel gwan ere emne yan subbetem, eme me akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Eme akemke, tuma wuri ete nel gwan borke etep wom. Ete tame ere areri Yen yenbo adebas. An erne won yam. Kem eri tuma mette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Etep wobetemke, eme lam, Jisas ere kena wiwi eterwou tetmenem. Tetmenem, eri anepoi tame eme tuma rebe tem, emri lam wos eme akeite tame emne beke wusou. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kwokwos eme kow mesginin yeirim, tatame nogwape eme yan Jisas erne keluke yan lam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yan lam, tatame nogwape etemri tame wuri ere worworke etep wom. Tuma wusoube tame, an nene worworke wobe. Ne ari taureyen late, ere ari yen wurisubuwai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Gabo yaper erne guleleten, ere taye pitbe, erne tubanepitin san tuknabe. Ere elemoi sabelekwo bulbalken worabe. Gabo ere eri wusom yaper nenbe, ere erne beke mesgin. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","An neri anepoi emne wometye, eme pekerouklawoiwo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisas ere emne awosein etep wom. Oi, gwopte tetan tatame nogwape kem kenawaike beke abo. Kem porere yenbo berai. Yabel nogwape an keremken tetan. Mapeke kem ane kenawaike abote? An kera moke wobe. Sene ere ar erne etep wom. Neri yen ne erne panen yate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Panen yabetem, gabo ere yen erne tubanepitim. Tubanepitim, Jisas ere gabo erne womke, ere yen erne mesginin yim. Yim, Jisas ere yen erne yenbo nenen, ere ar eteri letke sene newom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Etep womke, tatame nogwape eme God eri mure etep lam, eme wouken akem. Eme Jisas eri nenbetem wule som wouken akbetem, Jisas ere eri anepoi tame emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ari wote tuma kem mane wan gette. An Tatame Etemne Lan Yeirim Tame, tame eme ane keresukte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Etep wom, tuma eri somo eme beke met, eme erne tuma somo womette me akem. Eme tuma somo mette wurken, eke God ere emri porere wotakem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisas eri anepoi tame eme tuma walekap nayin etep wom. Neremri wuri eike ere apeilake eisau? Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas ere emri porere lam, eke ere yen nebule wuri peten eteri ganke teteruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Teteruwun, ere emne etep wom. Tatame eme ane kenawaike abote, eme gwotek tetan yenkap erne pap yewobe, eme arene kir pap yewobe. Ane pap yewobe tatame eme ane won yam tame, God, eterne kir pap yewobe. Keremri sig nebuleken tatame etem eme apeilake eisau tete. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon ere Jisas erne etep wom. Aneyen, nema lam, tame wuri ere neri sig wom, ere nereri murek gabo pekeroukem. Ere neremri tamesip berai, eke nema erne wotakem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisas ere erne awosein etep wom. Kem erne mane wotakete. Tame eme keremne yaper beke nen, ete tame eme keremri tamenowu. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisas ere Hevenke yite yabel mekin mekin tem, ere porere wurisubu tem, ere Jerusalemke yite wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Etep wom, ere tame kau emne won eme taresin yim, eme Samaria distrikri komke yin wurim, eme eri tukna akeken awosken eyarte wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wurim, Samaria tatame eme Juda tatame etemri peiktame temenem. Eme metem, ere Juda tame etemri kom Jerusalemke yibetem, eme erne pap beke yewo, eme erne wotakem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wotakem, anepoi tame pes, Jemsken Jonken, epe etep lan, epe Jisas erne etep wom. Aneyen, ne mapeke abobe? Nesa ker won Hevenke yeirin tatame emne kerke eite o? ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Etep womke, Jisas ere epne petkwo lan epne kuken won, wotakem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wotaken sene eme akeite komke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Eme keluke yibetem, tame wuri ere Jisas erne etep wom. Ne mak yi mak yite, an nerenken kir yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisas ere erne etep wom. Boulke sewurbe mou wale eme sel purik tuknabe. Ap eme neiske tuknabe. Aren, an Tatame Etemne Lan Yeirim Tame, an tukna akeken berai, ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Etep won ere akeite tame wuri erne etep wom. Ne arenken yite. Ete tame ere awosein etep wom. Wai. Ne kir wote, an ari apei erne kiyi sele meike rasen an nerenke ek yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisas ere erne awosein etep wom. Ne mane yin erne sele meike raste. Arene kenawaike beke abo tatame eme sabe tamekap. Ete tame etem eme saye tame erne sele meike raste. Ne yin God eri kom panen site tuma wusoute. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sene akeite tame wuri ere erne etep wom. Aneyen, an nerenken yite. Ne kir tete, an sene yin kom tame emne pir won emne nar peten tak keren mesginin, nerenken ek yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisas ere erne etep wom. Tame eme pere berei kerete, eme kelu kiyi beke lan yi, eme God eter panen site kom yaku kuyese beke kip kere. Ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yuri Aneyen ere akeite tame nogwape (72-pela) emne won yim. Ere emne pesre pesre eter yite nenem kom komke taresin won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ere emne won yite nenbetem, ere emne etep wom. Nowke tetan awos nogwape okwoye. Awos pette yaku kerebe tame eme nogwape berai. Kem now maime erne womette, ere yaku kere tame sene kenete, eme yin eri tuma wusoute, tatame nogwape eme eri tuma kenawaike mette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kem epe yi. Aren an kemne woye, eke kem yibe. Kem yite, kemri late tatame eme mou sir yibe walekap. Kerem kem sipsip yenkap. An kemne etemri komke won yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kem kel yewobe ayer o awos yewobe ayer mane peleikte, kem tewo bus mane wute. Kem tatame emne keluke late, kem emne pir won kem etek mane som tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kem ake wurik yin wurtek, kiyi kem emne etepke wote. Kem noub me temente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ake maime ere porere yenbo temente tame erne God ere noub nente. Ake maime ere porere yaper temente tame erne God ere noub beke kip nen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Eme kemne ake newote, kem etemwouken temente. Etem kemne newote a kem ate. Emri kemne newobe a ete a kerem yaku kerebe tokwokap. Kem ake ake mane yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kem komke yin wurin eme kemne etemri akek panen yite, eme kemne newote a kem peten ate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kem ete komri le si tame, wan si tame, let nai tewo nai tatame emne eyarte, tatame emne etep wote. God eri kom panen site yabel mekin mekinye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kem komke yin wurte, eme kemne pap beke yewo, kemne ake beke panen yi, kem kom genik teten etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Kemri komri sel neremri tewo papke tetan, nema nubutkwunbe gwo. Kem etep labe, kem etep abote. Kem nemne yaper nenye, yuri God ere kemne yaper awosein nente nenbe. Kem etep noub abote. God ere kom panen site yabel mekin mekinye. Kem emne etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","An kemne wobe. Ete komri tatame eme kemne pap beke yewo, e yaperwai. Yuri tatame emne tuma namdete yabelke, God ere ete tatame emne awosein kenake pete nenbe. Sodom komri tatame God ere emne etepkap beke kip pe, ere emne kerake pete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","O Korasin komri tatame, yuri kem mus eisau mette nenbe. Betsaida komri tatame, kerem kir, yuri kem mus eisau mette nenbe. An keremri komke temenem, God eri mure an kemne peteram. Kem etep lam, kem God erne kenawaike beke abo. Tair komri kiyiri tatame, Saidon komri kiyiri tatame eme God eri nenem wos eme beke la. An God eri mure ete komri tatame emne peterate wom, eme emri nenbetem wule yaper pauk mesginte wom. Emri kiyi nenem wule yaper eme sebera yate wom, eme mate seba peiken kersubuk site wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yuri God ere tatame emne tuma namdete yabel, Tair komri tatameken Saidon komri tatameken eme mus eisau beke kip met. Kem Korasin, Betsaida komri tatame, kem mus eisau mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kem Kaperneam komri tatame, eme kemne Hevenke panen yaute? Kem beke kip yi. Beraiwai. Kem ker tetan komke yite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Etep wom, Jisas ere eri anepoi tame emne etep wom. Eike tatame eme kemri tuma mette, eme ari tuma kir mette. Eike tatame eme kemne magel taite, eme ane kir magel taite. Ane magel taite tatame eme ane won yam tame eterne kir magel taite. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yuri Jisas eri won yim tame nogwape (72-pela) eme sene yam, eme metekwasen etep wom. Aneyen, nema neri sig wobetem, tame emne gulelemenem gabo eme nemri tuma metbetem, eme sene woran amekirbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisas ere etep wom. Kiyi an lam, Satan ere nelke yam, ere agetage pelalekapke an yeirim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Metye. An kemne mure newom, kem sopoken walgerken tewok teitte, eme kemne beke kip ta. An kemne mure newom, kem keremri peiktame Satan eteri mure teitkwunte. Ere be wos yaper kemne beke kip wuri nen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kem gabo emne pekeroukte, kem mane metekwaste. God ere kemri sig eteri komri siglouke kiyi bas rasem, etepwou kem metekwasen tete. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ete yabel God Eri Wou ere Jisas eterken temenem, Jisas ere metekwasen etep wom. Apei, ne nelken nowselken eteri Keryen God. Neri nenbekap, neri tuma somokap ne porereken tame emne berasem, emne beke petera. Yen nebulekap tatame etemne, porereken berai tatame etemnewou ne neri tuma somo emne noub wusoube. Etep tebe, ne neri porerek etep nenem. E yenbo. Etepkap, an metekwasbe, an nene pir wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Apei, wos nogwape ne ari letke rasem. An Nereri Yen, tatame eme ane etep beke met. Apei, nerenwou ne ane metten. Arenwou an nene metten. Ari won yan nereri tuma wusoube tatame etemwou eme nene metten. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Etep womke, ere eri anepoi tame etemwoune etep wom. Kemri labe wos kem metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","An kemne wobe. Ari tebekap kem labe. Kiyi God eri tuma wusoubetem tame etem, kom nogwape panen sibetem apeilakeken eme etep late abom, eme beke la. Ari woye tuma kem metbe, eme ete tuma mette abom, eme beke met. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Moses eri wule wusoubetem tame ere yan Jisas erne seilan erne etep wolam. Tuma wusoube tame, an mapeke tetek, an noub som temente? ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisas ere erne awosein etep wom. God eri bas rasem tuma mapeke wobe? Ne map lam? ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ere awosein etep wom. God eri tuma etep wobe. Ne Keryen God erne pap kenawaike yewote. Neri wusom, mure, selpap, porere ne God eterwoune newote. God eri tuma ere sene etep wobe. Ne neri maime wusom eyarbekap, ne akeite tatame emne etepke pap yewote. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas ere erne etep wom. Ye. Ne tuma seken sein woye. Ne etep nente, ne som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Etep womke, Moses erne newom wule wusoubetem tame ere etep abom. Tatame eme ane tuma yenbo wote, eke an Jisas erne tuma wuri sene womette. Etep abom, eke ere etep wom. God eri tuma etep wobe. Tatame eme akeite tatame emne yenbo nente. Etep wobe. Akeite tatame eme eike? ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas ere erne awosein etep wom. An nene sike wuri wusoute. Ne ek met. Tame wuri ere Jerusalem kom mesginin ere Jeriko komke warem. Warbetem, tame yaper eme erne keluke lam, eme erne pen eri wosbas akei sirke peten eme amen yim. Yim, ere keluke tuknamenem, ere sate kerake tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sate kerake temenem, God eri akeri tame ere keluke yabetem, ere ete tame erne lam, ere erne amekwunen kelu ganke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yibetem, sene akeite tame wuri ere Livai tame supa, ere God eteri ake lakerebetem tame, ere keluke yabetem, ere ete keluwouke tuknamenem tame erne lan erne amekwunen kelu ganke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amekwunen yibetem, akeite komri tame, Samaria tame, ere ete keluke yabetem, ere erne etep lam, ere erne kobo lam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kobo lam, ere erne mekinke yin erne lan kwarken wain okken etem erne pen borpuk etek siren banis kepke peikem. Peiken, ere erne nenewayen donki magelke siruwun erne peten yim. Yim, epe etem yi yabetem tatame etem tuknabetem akek yin wurin etek rasen erne eyarem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Noub eyaren tuknan, ei beram, ere ake maime erne kel pes newon erne etep wom. Ne gwote tame erne lakerete. Yuri an sene yate, an nene kel sene newote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas ere womke, ere Moses eri wule wusoubetem tame erne etep wolam. Sir petbe tame eme tame wuri erne paku pem, eri wos eme akei petem. Tame mur eme erne keluke lam. Ne mapeke abobe? Tame mur etemri wuri eike erne kobo kenake lam? ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ere awosein etep wom. Samaria komri tame ere erne kobo lam, ete tame ere erne noub nenem. Jisas ere erne etep wom. Ne yin akeite tatame emne etepwouke nente. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas, eteri anepoi tameken eme sene yibetem, eme kom wurik yin wurim. Wurim, ta wuri, teri sig Marta, te Jisas erne panen etetri akek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yim, Marta teri mase Maria te yan Aneyen eteri tewo tobok sin eri tuma metbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Metbetem, Marta etetwou te iawu nogwape kerebetem, te mase tene ragi eyim. Etep tem, te yin Jisas erne etep wom. Te etep wom. Aneyen, ari mase te ane mesginye, arenwou an iawu kerebe. Te ane kobo beke la. Ne tene wote, te ane yaku kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aneyen ere tene awosein etep wom. Marta, Marta, ne wos nogwape abobe, ne selpap yaper teye. Wos wuri ne kiyi abo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maria te ete wos yenbo abobe. Te ane abobe, eke te ari tuma metbe. Eike tatame eme beke kip wotake. Jisas ere tene etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yabel wuri Jisas ere akeite emik yin God eterken tuma namdem. Namdebetemke, eri anepoi tame wuri ere erne etep wom. Aneyen, kiyi Jon ere eri anepoi tame emne tuma wusoubetem, ere God eterken tuma namdete wule emne kir wusoubetem. Ne nemne etepkap wule wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ere anepoi tame emne awosein etep wom. Kem God eterken tuma namdete, kem etepke wote. Apei, nema abobe, neri sig yenbowai som temente. Nema abobe, ne nemne akei kom panen site. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ne nemne gwotepteri awos newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tatame eme nemne yaper nenbe, nema emne awosein emri nenbe wos yaper gerute. Etepkap ne nemri yaper nenbe wos ne peten sepitte. Wule yaper nemne mane seilate. Kem Apei eterken tuma namdete, kem etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jisas ere emne tuma wuri sene etep wom. Tame wuri ere neir borke tamenowu eteri akek yin erne etep wom. Tamenowu, ne ane naku mur newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ari tamenowu ere kelu geneke yawo. An erne newon ate a berai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Etep womke, ake purik temenem tame ere awosein etep wom. Ne beke ane yaku newoye. An ake eru kiyi kit kereye. An yenken tuknabe. An beke kip wayen nene awos beke kip newo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","An kemne wobe, ake maime ere woran tamenowu ere eikseten wos ere erne newote. Ere tamenowu erne kobo late beke kip abo, ek newote. Berai. Ere tamenowu eteri wometbe tuma som mette mo wobe, eke ere erne wos newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","An kemne wobe. Kem som wometbetete, kemri wometbekap God ere nente. Kem wos som sopbetete, kemri sopbe wos kem late. Kem eru som pemetbetete, God ere eru latte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tame ere tewok tewok wemette, ere wemetbekap, ere late. Tame ere tewok tewok sopte, ere wos late. Tame ere tewok tewok eru pemette, God ere erne eru latte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kemri nenbekap e gwopkap. Ane, kem kemri yen eme kemne omyen womette, kap kem emne sopo yaperke newote o? Berai. Kem emne omyenke newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O yen eme kemne kwokwo yen wuri newote wote, kem emne walgerke newote o? Berai. Kem emne kwokwo yenke newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kem tame yaper, kem kemri yen emne wos yenbo newobe. Kemri Hevenke tetan Apei ere yaper berai. Ere yenbo. Eke eike God erne womette, ere Eri Wou emne newote. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Gabo ere tame wuri erne gulelemenem, tame ere tuma eikse temenem. Etepke temenem, Jisas ere yan gabo erne pekeroukun yim, tuma eikse temenem tame ere tuma sene namdem. Sene namdem, tatame nogwape eme etep lam, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wouken akem, kau eme etep wom. Satan ere gabo etemri apeilake. Eri akeite sig Belsebul. Eter ere Jisas erne mure newobe, eke ere gabo emne pekeroukbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Etep womke, tame kau eme erne seilate abom, eme etep wom. Ne akeite rigrabe nente, God ere nemne eri mure peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Etep womke, Jisas ere emri porere lan ere emne etep wom. Apeilake eri wakse eme pekan etemwou etemwou ei naite, eme som beke kip te. Ake wuriri tatame eme etemwou etemwou ei naite, eme kenakena yin tete, eme yenbo beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satanken omugaboken eme etep tete. Eme pekan etemwou etemwou naite, mapeke eme noub som temen? Etepkap eme etep beke nen. Kem ane etep wobe. Gabo emri apeilake Belsebul, ere ane mure newobe, eke an gabo emne pekeroukbe. E tuma seken berai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Keremri anepoi tame kau eme kir gabo pekeroukbe. Eike emne ete mure newobe? Belsebul o? Kem Belsebul beke wo. Eke kemri tame eme gabo pekeroukbe, nema etep labe, nema metten, keremri wobe tuma e yaper. An gabo pekeroukbe, an Satan eteri murek beke pekerouk. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","God ere ane eteri mure newobe, eke an ete gabo emne pekeroukbe. Kem etep latek, kem abote. Gwopte God ere tatame emne panen siten. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mureken tame ere nau meta pi sen ere eri ake noub lakerebe, eri wos noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yuri mure eisauken tame ere yan ete tame erken ei nayin erne teitkwunte. Teitkwunte, ere ete tame eri pi nau meta pette, ete tame eri wosbas ere peten akeite tatame emne wosan newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tatame eme ari wakse beke te, eme ari peiktame. Tatame eme arenken yaku beke kere, eme ari yaku yaperke kerebe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jisas ere emne sekur sakur tuma emne sene etep wom. Gabo ere tame wuri erne mesginin boulke yim. Yim, ere site emi yenbo soplawoyin ere etep wom. Kiyi gulelemenem tame an eterke sene yin gulelete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sene yin lam, ete tame ere porere yenbo temenem, ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","akeite gabo beke wuri gulele. Eke ere sene yin akeite gabo ep yekwo let ep yekwo let bor pes keyem (7-pela) emne sene panen yam. Ete gabo emri yaper nen wule kiyi temenem gabo eri yaper nenbetemkap teitkwunem. Panen yam, eme tame erne gulelemenem. Kiyi gabo wurisubu ere tame erne gulelemenem, tame ere yaper temenem. Sene gabo nogwape erne gulelemenem, tame ere yaperwai temenem. Tatame eme bepou me temente, eme ane kenawaike beke abo, eme yaperwai sene tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas ere etepkap tuma womke, tatame nogwape etemri ta wuri te noubke erne etep wom. Nene warwi yen muk newobetem nawo etet te metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jisas ere etep wom. Berai. Tatame eme God eri tuma mette, eri tuma kuyese tobote, etem eme metekwaste. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tatame nogwape eme yan Jisas erne ouyeyim, ere emne sene etep wom. Gwopte tetan tatame eme yapersubuwai. Eme ari rigrabe late wobe. Etemri woye wos an beke kip nen. God ere eteri kiyi temenem tuma wusoubetem tame, Jona, eter kiyi nenbetemkap etepwou an nente, eme etep late. Kiyi Jona ere neir mur yabel mur omyen eisau eteri kibuk temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona eri kerem yakukap an etep kerete. An Tatame Etemne Lan Yeirim Tame, kiyisape Ninive komri tatame eme Jona eri yaku lamkap, gwopte tetan tatame eme ari yaku late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kiyi temenem ep yekwo barri apeilake ta te genek yam, porereken tame, kom panen simenem tame Solomon eteri akek yan eri tuma yenbo mette yam. Gwopte an keremken tetan, an Solomon erne teitkwunten. Kem ari tuma bepou me metbe, kem wule yaper beke mesgin. Etepkap, yuri God ere tatame emne tuma namdete yabel, ete apeilake ta te wayen teten kemne ker wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kiyi Ninive komri tatame eme Jona eri tuma kenawaike metem, eme emri yaper nenbetem wule mesginim. Gwopte an keremken tetan, an Jona erne teitkwunten. Kem ari tuma bepou me metbe, kem wule yaper beke mesgin. Etepkap, yuri God ere tatame emne tuma namdete yabel Ninive komri tatame eme wayen teten kemne ker wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tame eme tu yarbe, eme uwoi yekwo kulke beke tuk, o eme ouke beke gumkere. Berai. Eme tiyke tuken kukmenbe, ake puri kuyese labe. Eike tatame eme yan worate, eme kuyese late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kemri le e kemri wusomri tukap. Kemri labe wos kem porerek abobe. Kemri le yenbo temente, kem yenbo woswou late, kem yenbo woswou abote. Kem kuyese tuke sewurbekap, kemri selpap wusom etepkap yenboke temente. Kemri le yaper temente, kem yaper woswou late, yaper woswou abote. Kem neirke bepou me sewurbekap, kemri selpap wusom etepkap yaper temente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Etepkap kem noub abote. Kemri selpap ere tukap keremente. Kemri porere mane kerneirikap tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kemri selpap tukap keremente, kera kera beke tekete, kemri wusom ere tukap keremente. Tu ere kemri wusom noub kuyese labekap, kem etepke tete. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas ere tuma won mesginim, Farisi tame wuri ere Jisas erne ten yan awos eterken ate wom. Ate wom, ere yin akek wurin sin a abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sin a abetem, Farisi tame ere etep lam, ere a am, ere let ok kiyi beke keya. Ere bepou me am. Etep lam, ere wouken aken ep abo ep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ep abo ep abom, Jisas ere erne etep wom. Kem Farisi tame, kem ok abe ware eliwouke ok keyabe, kemri wusom yenbo labe, kemri selpap yaperwai tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kem me belebe. God ere tame emne seikim, ere wusken omken seikim, ere selpap kir seikim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kem awosken okken peten wosken berai tatame emne newotek, kemri wusomken selpapken yenbo tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kem Farisi tame, yuri kem yaper tete nenbe. Kemri petbe wos kem obo ep yekwo let ep yekwo let keyem (10-pela) pekabe, obo wuri kem peten God erne newobe. Wule nebulewai kem etepwou kir nenbe. Kem God erne rasen newobe. Etep tebe, wule eisau kem beke tobo. Kem tatame emne yenbo beke nen. Kem God erne selpapke beke yewo. Kemri petbe wos kem som rasbetete, God erne wuri newote, e yenbo. Ete wule kem mane mesginte. Ari woye wule eisau kem kir nente. Kem God erne, tatame emne selpapke yewote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kem Farisi tame, yuri kem yaper tete nenbe. Kem God eteri akek wurbe, kem abobe, kem apeilake tame etemri wolbayek sin tatame eme kemne late. Kem makle yenbok sewurbe, kem abobe, tatame eme kemne pir wote, kemne tame yenbo wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kem eisa eisa. Yuri kem yaper tete nenbe. Kem tame sele meikap. Tame kupa kik tetan, tatame eme beke la, eme sele elik sewurbe. Etepkap, kemri porere kupa tebe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Moses eri wule tuma wusoubetem tame etemri wuri ere erne etep wom. Tuma wusoube tame, ne etep wobe, ne tuma yaper nemne kir wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisas ere etep wom. Ye. Kem Moses eri wule tuma wusoube tame, kerem kir yuri kem yaper tete nenbe. Kem tatame emne etep wobe. Nemri nenbekap, kem etepwou nente. Etep wobe, tatame eme kemri nenbekap nenbe, eme yaku eisau kerebe. Kem etep labe, kem emne kobo beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yuri kem noub beke kip te. Kemri yeiwarege eme God eri tuma wusoubetem tame emne pen sabetem. Pen sabetem, gwopte kem emri sele mei som wolebe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sele mei som wolebe, tatame eme labe, eme yeiwarege emri yaper nenbe wule kir etep wobe. Emri nenbetemkap e yenbo. Etep wobe. Eme emne pen sabetem, gwopte kem emri sele mei som wolebe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Etepkap, God eri bas rasem tuma etep wobe. An tuma wusoube tameken tuma won sewurbe tameken emne won yite. Won yitek, kau tame eme emne pen sate nenbe, kau eme emne wule yaper tobote nenbe. God ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kiyisape God ere nelken selken seikim, tatame eme God eri tuma wusoubetem tame emne pen saiwom. Gwopte tetan tatame eme etep som nenbe, yuri eme mus eisau mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kiyisape Kein ere eri mase Abel erne pen sam. Sene kemri yeiwarege eme God eri tuma wusoubetem tame nogwape emne pen sabetem. Pen sabetem, yuri eme Sekaraia erne pen sam. Ere God eri ake eisauke wurin temenem, eme erne etek pen sam. Eke, gwopte tetan tatame emne God ere emne yaper awosein nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Moses eri wule tuma wusoubetem tame, yuri kem yaper tete nenbe. Areri tuma seken kem berasbe. Kem tuma seken beke pet. Akeite tatame eme mette wobe, kem emne wotakebe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Etep womke, Jisas ere ete ake mesginin woram, Farisi tame, Moses eri wule tuma wusoubetem tame eme pap wayen eme erne akeite akeite tuma seilabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Erne ei tuma seilabetem, eme etep abom. Ere tuma yaper wote, nema erne tuma namdete. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jisas ere tuma tasen wusoute nenbetem, tatame nogwape nogwape eme yan wurisubuk tetyewon natekelbesem, eme awoawo tewok tetem. Tetem, Jisas ere eri anepoi emne kiyi etep wom. Kem eisa eisa. Farisi emri geil pelbe yiskap wos kem eisa eisa. An kemne emri yikwokwobe tuma kemne wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Emri berasen nenbe wule, yuri tatame nogwape eme late nenbe. Emri berasen wobe tuma, yuri tatame nogwape eme mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gwopte tuma nogwape kem neirke wobe, tatame nogwape eme beke met. Ete tuma yuri tatame nogwape eme mette nenbe. Tuma nogwape kem ake purik wurin tatame emri wanke elen me wusoube, yuri ete tuma tatame eme kom genik mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ari tamenowu, an kemne wobe. Tame eme kemne pen sate wote, kem emne mane akte. Kem satek, eme kemne akeite wule yaper kuyese beke kip nen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","An kemne wobe. Kem God eterwoune akte. Eter ere kemri wusom pen sate, sene ere kemne ker tetan komke won yite wote, kem yite nenbe. An kemne sekenke wobe. Kem eterne akte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kem lam. Tame eme ap nebule tukbe, eme kel nebule pes (tu toea) rasbe, eme misyekwo ep yekwo let petbe. Ap eme nebule wos, God ere akei ap emne abobe, ere wuri beke wan get. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","God ere kemne kir abobe, ere kemne akei lan metten. Ere kemri tare take nogwape wurare wurare akei sarem. God ere misyekwo nebule emne abon noub nenbekap, kem tatame, ere kemne abon noubwai lakerete. Ere kemne beke wan get. Etepkap, kem be wos be wos mane akte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","An kemne wobe. Tame ere akeite tatame emne etep wote. An Jisas eteri wakse. Etep wote, an Tatame Etemne Lan Yeirim Tame, an God eri komri tame emne ete tame eterne etep wote. Ere areri wakse. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tame ere akeite tatame emne etep wote. An Jisas eteri wakse berai. Etep wote, an Tatame Etemne Lan Yeirim Tame, an God eri komri tame emne ete tame erne etep wote. Ere areri wakse berai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","An Tatame Etemne Lan Yeirim Tame, tatame eme ane tuma yaper wote, God ere emri nenbe wule yaper peten sepitte nenbe, emne tuma beke namde. Tame ere God Eteri Wou eterne tuma yaper wote, God ere eri nenbe wule yaper beke kip peten sepit. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Yuri eme kemne tuma namdebe akek panen yin apeilake eteri bitimik tuma namdete, kem mane aken etep abote. Nema mapeke awosein wote? Nema be tumake emne wusoute? ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ete yabel God Eri Wou ere kemne be tuma wusoute wote, kem ete tumawou awosein wosoute. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jisas ere etep wom, tatame nogwape etemri wuri ere erne etep wom. Tuma wusoube tame, apei ere sam, ari lake ere apei eteri wos akei petem. Ne erne wote, ere ete wos wosan ane kau newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisas ere erne etep wom. An tuma metbe tame berai. Mapeke an erne wote, ere ete wos wosan, nene kau newote? ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Etep womke, ere emne sene etep wom. Kem noub la. Kem wos mane malte. Tame eme wos malte, yuri eme somsom beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ere emne sekur sakur tuma sene etep wom. Wosbasken tame eri now awos nogwape temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Temenem, ere eteri selpapke etep abom. An mapeke tete? Awos nogwape ten yaten, an kwayeke eisau berai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","An aboye. An ari kwayeke nebule akei regyewon kwayeke eisauwai kerete. Keretek, an ari awosken wosbasken ete ake eisauke raste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Raste, an maime etep wote. An tame yenbo. Ari wos nogwapewai. Nabe nogwape an now yaku sene beke kip kere. An ege sin, a an, tewo lomte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Etep wom, God ere erne etep wom. Ne me belebe tame. Gwopte neir ne kip sa. Wos nogwape ne petyewom, eike pette? ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Eke Jisas ere etep wom. Tame eme wosbas nogwape pette kouten, eme ari woye tamekap. Eme nowselri woswou pette abobe. Eme nowselri wos pette, God eri wos eme beke kip pet. God ere labe, eme eikse akse tame. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sene Jisas ere anepoi tame emne etep wom. Etepkap, an kemne wobe. Kem wosken kerap wole wosken mane ep abo ep abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Aom e eisau wos berai. Neri nenbekap eter eisau wos. Kerap wole wos etepwou eisau berai. Neri wusom e eisau wos. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kem ap emne abote. Eme kwoi beke peren, kwayekek beke ras. Berai. God eter ere emne a peterabe. Ap eme nebule wos. Kem tatame, kem eisau wos. Eke God ere kemne kir noub lakerebe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tame ere etep abobe. Gwopte an beke kip sa. An som temente nenbe. Etep abote tame ere som temente, o? Berai. Ere som beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kem etepkap nebule wos kuyese beke nen, mapeke kem akeite akeite eisau wos ep abo ep abo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kem walku emri kerap abote. Kem lam, eme kerap wole wos beke abo. God ere emne noub lakerebe, emri kerap yenbo labe. An kemne wobe. Kiyi apeilake Solomon ere temenem, ere wosbasken tame. Ere kerap yenbo wolebetem. Me walku kep walku emri kerap yenbowai, eme Solomon eri kerap teitkwunbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Walku etemri kerap nema labe, gwopte eme tetan, kipi o kwokwos eme sok tebe. Eme som beke te. Ete nebule wos, God eter ere emne kerap yenbo wolebe. Kem tatame, kem eisau wos. God ere walku emne kerap wolerubekap, ere kemne kerap wole wos kir newote. Kem etep abobe, ere nemne wos beke newo. Kem etepkap mane abote. Kem erne womette, ere kemne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Etepkap, kem mane ep abo ep abote. Nema be woske ate? Kem etep mane abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","God erne kenawaike beke abo tatame eme etepkap abobe, eme ep abo ep abobe. Kerem, kemri Apei ere kemne laten. Be wos kem eikseten, ere laten. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kem mane ep abo ep abote. Kem God erne abote. Ere kemne kerap wole wosken awosken newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kem areri sipsip yenkap. Kem mane akte. God ere kemne kom panen site metekwasbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kem keremri akei wos peten sen yin akeite tame eme akei tuken kem kel peten wosbasken berai tatame emne newote. Kem etep tete, kemri tokwo yenbotanbo God eteri komke tetan. God eri komke tetan wos yaper beke te, didi eme wos beke reg, sir petbe tame eme etek beke te. Akei wos noub som teten. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Neri yenbotanbo wos tetan emi neri selpap kir etewouke temente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kem yaku kerebe tamekap wos eyarte. Kem tame oub waren tu yaren koute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yaku kerebe tame emri aneyen ere ta neisbe awos ate yim, eri yaku kerebe tame eme erne sene yate koumenbekap, kem etepke koute. Ere yan ake eru kowkowte, eme eru agetage latte. Kem etepkap noub koute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aneyen ere sene yan late, yaku kerebe tame eme erne kowun eme wos eyarem, ete yaku kerebe tame eme metekwaste nenbe. An kemne tuma sekenke wobe. Aneyen eter ere emne yaku kerete, ere emne a newon ate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aneyen ere neir borke yate, o ere kwokwo wobetetek ere yate, yaku kerebe tame eme erne som koumentek, ete tame eme metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Metye. Sir petbe tame ere akek wurin sir pette. Ake maime ere etep kiyi mette, ere beke kip tukna. Sir petbe tame ere yate, ake maime ere erne keresukte, sir petbe tame ere ake beke kip regen wurin wos beke kip pet. Etepkap, ari sene yate yabel kem beke met. Eke, kem noub kowun lakerebetete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Etepkap kem ane som kenawaike abobetete, kem ane som kowun simente. An Tatame Etemne Lan Yeirim Tame, tame eme etep abobe, gwopte ere beke kip ya, ete yabelke an yate nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita ere etep wom. Aneyen, ne ete sekur sakur tuma neremwoune wobe, o tatame nogwape emne kir wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aneyen ere awosein etep wom. Porereken yaku lakerebe tame yenbo ere gwopke tebe. Ete tame eri apeilake ere erne etep wote. Ne ari yaku kerebe tame emne lakerete. Ne emne awosken tokwoken emne newote. Etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yaku lakerebe tame ere etep nente, apeilake ere sene yan lan etep wote. Ne ari wom yaku yenbo kerem. Etep wote, tame ere metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sene apeilake ere yaku lakerebe tame erne etep wote. Ari sene yate yabel ne etep noub abon yaku yenbo som kerebete, eke an nene yaku yenbo sene newote. Ari wos nogwape ne lakerete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yaku lakerebe tame yaper ere gwopke tebe. Ere etep abote. Apeilake ere agetage sene beke kip ya. Etep abote, ere eri yaku kere tamesip taken tameken emne paku pebetete. Sene ere aken ok yaperken an, ere eikse aksen bele balebetete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Apeilake ere yate yabel yaku lakere tame ere etep beke abo, ete yabel apeilake ere sene yate nenbe. Apeilake ere yate, ere yaku lakerebe tame erne yaperwai nente. Ere erne won yin ere wan gwolebe tame etemken temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yaku kerebe tame ere apeilake eteri tuma meten yin eter wom tuma ere beke nen, apeilake tame ere ete tame erne pakuk kenake noubke pete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yaku kerebe tame ere apeilake eteri tuma kerake metbe, ere yin yaku yaper kerete, apeilake ere erne kerake pete. Tatame eme Apei eri newobe wos nogwape kera pette, eme awosein etep newote. Tatame eme Apei eri newobe wos nogwapewai pette, eme awosein etep newote. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisas ere sene etep wom. An yam, an nowsel kerke lisin sewurte yam. An abobe, ete ker ere eiyin eisau tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","An sate, an mus eisau mette nenbe. Etepkap, ari selpap yapersubu teye. An kiyi san omote, ari selpap yenbo sene meten, an metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kem mapeke abobe? An yam, nowselri tatame eme noub site nenbe o? Berai. An kemne wobe. Eme noub beke kip si, eme pekan eme kenakena yin site. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yuri, tatame ep yekwo let eme ake wurisubuke tete, eme porere pes tete, eme pekan peske tete. Mur eme pes etepri peiktame tete, pes epe mur etemri peiktame tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yen ere a eterken ei naite, ar ere yen eterken naite. Yedeyen te nawo teken ei naite, nawo te yen etetken naite. Nan te yei etetken ei naite, yei te nan etetken ei naite. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sene Jisas ere akeite tuma emne etep wom. Kem labe, mou neirbe, kem etep wobe. Mou tite nenbe. Kem etep wobe. Etep labe, mou ek tibe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kem etep labe, keni yabel neir tepke selebe, kem etep wobe. Gwopte yabel yenbo paste nenbe. Etep wobe, ere etepke pasbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kem tuma yikwokwobe tame, kem nowselri wos o nelri wos labe, kem abon kem etep wobe. Gwopte mou tite, o gwopte yabel paste. Kem etepke kuyese abobe. Gwopte tebe wos, kem kir etep kuyese beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mapeke kem wule yenbo beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tame ere kemne tuma namdete, kem eterken keluke yibetete, kem eterken tuma kiyi namden gerute. Ere kemne tuma metbe tame eterke panen yite wurken. Ere kemne nau se tame etemne newon, nau se tame eme kemne ake yaperke won wurte wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","An kemne wobe. Kem ake yaper kiyi epiyi beke kip mesgin. Emri wote lupkap omotek, kem komke sene ek yite nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ete yabel kau tame eme yan Jisas erne etep wom. Galili tame eme God erne sipsipken apken kwan pen newobetem, Pailat ere eri ei nai tame emne won eme Galili tame emne pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisas ere emne awosein etep wom. Kem mapeke abobe? Ete Galili tame emri nenbetem wule yaper e eisauke nenem, etepkapke Pailat ere emne pen sam? Akeite Galili tame emri nenbetem wule yaper nebuleke nenem, eke Pailat ere emne beke pen sa. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Beraiwai. Emri wule yaper kir etepwou kir tetan. An kemne wobe. Kem kemri wule yaper beke kip mesgin, kem porere yenbo beke kip pet, kem akei etepke sate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tame nogwape (18-pela), kiyi Siloam komri ake ere teren ete tame emne akei botkwun sam. Kem mapeke abobe? Emri nenem wule yaper e eisauke nenemke, eme ek sam, akeite Jerusalemke tetan tatame eme nenem wule yaper e nebuleke nenemke eme beke sa o? ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Beraiwai. Emri nenem wule yaper etepwou kirkir. Wule yaper kem beke kip mesgin, porere yenbo kem beke kip pet, kem kir akei akei etep saiwote nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jisas ere emne sekur sakur tuma etep wom. Yipige me e tame wuri eri nowke tetemenem. Tetemenem, yuri ere yin lam, gelame supa beke ya. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Beke ya, now lakerebe tame erne ere etep wom. Nabe mur an yipyokwo supa kwutete yan lawoyim. Eke ete yipege ne teite. Me ere supa beke ya, eke ne ete me erne teipitte. Ere bepou mane tetmente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Etep womke, now lakerebe tame ere awosein etep wom. Aneyen, me tetan. Nema gwote nabek lakerete. An sel peren mog yewolate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kap akeite nabe ere kap supa yate nenbe o? Supa yate, e yenbo. Supa beke ya, nema ek teite. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Akeite ege si yabel Jisas ere God eteri akek wurin tatame emne tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tuma wusoubetem, gabo tene gulelemenem ta wuri te etek temenem. Gabo tene gulelemenem, te rekebukun sim, nabe nogwape (18-pela) te etep temenem. Temenem, te magelken kwokworen, te kuyese mapeke tet. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas ere tene lam, ere tene etep wom. Ta, an nene eyarye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Etep womke, ere ta tene letke kerelam, agetage teri magel segilin yenbo tem. Yenbo tem, te God eteri sig eisau wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Etep womke, God eri ake lakere tame ere lam, Jisas ere tene ege si yabelke noub eyarem. Eke ere Jisas erne selpap wayen tatame emne etep wom. Yabel ep yekwo let ep yekwo let ges wuri keyem (6-pela) nema yaku kerebe. Kem let nai tewo nai tatame kem abote, ete tatame ere kemne yenbo nente, kem yaku kere yabelke yate. Ege si yabelke kem mane yate. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jisas ere erne awosein etep wom. Kem tuma me yikwokwobe tame. Ege si yabel kerem kem yaku kerebe. Bulmakau emri akek kem etek yin kep ogwon bulmakauken donkiken emne panen yin eme ok abe. Kem etep nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ete ta te Abraham eteri tame supa. Satan ere tene yaper nenem, te kin magelken kwokworem. Nabe nogwape (18-pela) te etepke temenem. Etepkap Satan ere tene kepke peikbekap tene keresukten. Ege si yabel an tene yenbo nente, e yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Etep womke, Jisas eri peiktame eme etep metem, eme sebera yam. Sebera yam, tatame nogwape eme Jisas eri nenem wule yenbo lam, eme metekwasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas ere sene etep wom. God eri panen site kom nema mapeke la? An kemne sekur sakur tuma wuri wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","God ere panen site kom ere mastet supakap. Mastet e me sig. Mastet supa ere akeite me supa yabekap eisau berai. E nebulewai. Tame ere mastet supa lei peten eri nowke rasen eme pam rekwan wayen tetete. Yuri ete me ere eisau tete, ap eme yan ete me kuk eme etek sin ake kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisas ere emne sene etep wometem. God eri kom panen si wule ere be woskap? ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","E yiskap. Ta te bret nente, te witmil nogwape peten sene te yis kera peten witmilken lugoum agoumen, ete witmil ere pelen wayen eisau tebe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sene Jisas ere Jerusalemke yibetem, ere kom komke yin tatame emne tuma wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wusoubetem, tame wuri ere erne etep wometem. Aneyen, kap God ere tame wurare wurare emne sene pette, o ere tatame nogwape emne sene pette? Jisas ere erne awosein etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Kem yaku eisau keren eru nebulek wurte. An kemne wobe. Tatame nogwape eme wurte nenlawoite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yuri ake maime ere ake eru kit keretek, kem yan ep yekwo genik teten eru kowkowen etep wote. Aneyen, ne nemne ake eru latte. Etep wote, ere kemne tuma awosein etepke wote nenbe. Kem mak yawo? An kemne beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kem erne awosein etep wote. Kiyi nema nerenken awos abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ere kemne sene wote. Kem mari tame? An kemne beke la. Kem wule yaper nenbe tame. Kem akei ane seki. Ake maime ere etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kem Abraham, Aisak, Jekop, kiyi tuma wusoubetem tameken emne God eri panen siten komke ek late. Keremne God eri panen siten komke beke kip wun yi. Kem etep late, kem selpap yaperwai mette, kem keran ker wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nowselri tatame nogwape eme iyou yekwo, iyale yekwo, woiwar yawarken yekwok yate, eme God eter panen siten komke sin a ate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Gwopte tatame kau eme sigken berai. Yuri ete tatame eme sig eisau pette. Gwopte tatame kau eme sig eisauken. Yuri ete tatame eme sig eisau beke te. Eme bepou me temente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jisas ere etep womke, ete yabel kau Farisi tame eme yan erne etep wom. Ne gwo kom mesginin akeite komke yite. Herot ere nene pen sate wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ere awosein etep wom. Herot ere mou sir yibe walekap. Kem yin erne etep wote. Gwopte aren Jisas an gabo pekeroukbe, an tatame emne eyarbe. Kipi an ete yaku som kerebetete. Kwokwos ari yaku omote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Gwopte, kipi, kwokwos, an ete keluke yibetete, an Jerusalemke yite. Eme God eri tuma wusoube tame erne Jerusalem komke etek pen sate nenbe. Eme erne akeite komke beke kip pen sa. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalem komri tatame, kem God eri kiyi temenem tuma wusoubetem tame emne etek pen sabetem. God eri wom tame kem emne pen sabetem, kem emne pape etek seitbetem. Yabel nogwape an kemne papke yewote wom. Kwokwo nawo te yen etetri tipe kulke petewuren gembekap, an kemne etepke noub nente wom. Etep tete wom, kem mo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kem ek met. Yuri ei nai tame eme kemri ake berayewote, tatame eme etek sene beke te. An kemne wobe. Kem ane sene beke kip la, yin ete yabel tetek, kem etep wote. Ete tame God ere erne won yam. God ere erne yenbo nente. Kem etep wotek, kem ane sene late. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Akeite ege si yabel Jisas ere Farisi apeilake eri akek a ate wurim. Wurim, tatame eme erne noub lakerebetem. Kap ere ege si yabelke tame eyarte, o? Eke eme erne lakerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Lakerebetem, tame wuri eri wusom pelmenem, ere yan temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Temenem, Jisas ere erne lan ere Farisi tameken Moses eri wule tuma wusoubetem tameken emne etep wometem. Moses eri wule mapeke wobe? Ege si yabel nema tatame emne yenbo nente o nema emne beke nente? ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Etep womke, eme tuma eikse tem. Tuma eikse tem, Jisas ere ete tame erne letke keren erne eyaren erne won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yim, ere emne etep wom. Kemri tame wuri eri yen o bulmakau ere ege si yabelke okmoike warte, maime ere ege si yabelke kuyese sene nenewayete, o ere sene beke kip nenewaye? Ye. Tame ere erne ege si yabelke kuyese sene nenewayete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Etep womke, eme ete tuma awosein beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas ere lam, tame kau eme a ate yam, eme wolbaye yenbok site wom. Etep lam, ere emne bepou sekur sakur tumak etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Tame ere ta neisbe a ate ere nene won yate, ne wolbaye yenbok mane site. Kap maime ere sig eisau tetan tame erne kir won yate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ne kiyi yin wolbaye yenbok simente, a ate woye tame ere yan nene etep wote. Ete wolbaye yenbo ne sigken tame erne newon site. Etep wote, ne sebera yan ne selke site. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tame ere nene a ate won yate, ne yan selke site. A maime ere yan nene etep wote. Ne selke mane site. Ne gwok yan wolbaye yenbok site. Etep wote, ne sig eisau ek pette. Tatame nogwape, nerenken a abe tatame, eme etep late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tame ere eteri sig maime eisau wote, God ere ete tame eri sig nebule wote. Tame ere eteri sig maime teitkwunte, God ere ete tame eri sig eisau wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisas erne a ate wom tame erne ere etep wom. Ne awos kiste, ne neri tamenowu, lakemase, anenawo, yei, meim, wopu, wosbasken kom tame emne mane won yan a ate. Ne emne won yate, yuri eme nene a awosein kisin nene wote, e yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ne a eisau nente, wosken berai tatame, let nai tewo nai tatame, le si tatame etemwoune ne won yate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Won yatek, yuri eme nene aom awosein beke kip newo. Etepkap ne metekwaste. Yuri tatame yenbo eme sele meike sene wayen yite yabel, God ere nene awosein newote. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Eterken abetem tame etemri wuri ere ete tuma metem, ere Jisas erne etep wom. Tatame eme God eri panen site komke sin awos ate, eme metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisas ere sekur sakur tumak awosein etep wom. Apeilake tame wuri ere awos eisau nenem, ere tatame nogwape emne a ate wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wom, awos ate yabel temke, ere eri yaku kerebe tame emne won yin kiyi wom tatame emne etep wom. Kem epe yate. Awos eme kiyi eyarye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Etep wom, eme wurare wurare beke ya. Tame wuri ere etep wom. An sel tukem, an ete sel yin late. Kobo labe, an beke kip ya. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Akeite tame wuri ere etep wom. An yaku kerebe bulmakau ep yekwo let ep yekwo let tukem. An bulmakau terulan yaku kerete. Kobo labe, an beke kip ya. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Etep womke, akeite tame wuri ere etep wom. Gwopte an ta paneye. Kobo labe, an beke kip ya. Gwopte an ta paneye. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yaku kerebe tame ere sene yin apeilake erne emri wom tuma wusowum. Wusowum, apeilake ere etep metem, ere pap wayen yaku kerebe tame erne etep wom. Ne kom sagke agetage yite. Kelu eisauken kelu nebuleken ne etek yin late. Wosken berai tatame, let nai tewo nai tatame, le si tatame, tewo yaper te tatame emne ne ari akek panen yate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Etep womke, ere yin emne lam, yuri ere sene yan etep wom. An neri woye tuma nenye. Nogwape eme yan siye, wolbaye kau bepou som tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Apeilake ere yaku kerebe tame erne etep wom. Ne sene yite. Ne komluke yibe, nowke yibe keluken boulke yibe kelu nebuleken yin lan tatame emne let tobo keren panen yate, eme ari akek yate. Eme yate, ari ake pelaute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","An kiyi wom tame eme ari a beke kip pet. Jisas ere sekur sakur tuma etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yuri Jisas ere yibetem, tatame nogwape eme eterken yibetem, ere petkwo lan emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Tame ere arenken yite wobe, ere eteri anenawo, yenta, geisimase, eteri maime wusom peiktamekap beke kip abo, ere ari anepoi tame beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aren mette muskap tame ere kir meten arenken yite. Tame ere etep mo wote, ere mus mette mo wote, ere ari anepoi tame kuyese beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tame ere ake eisau kerete abote, kiyi ere sin ake kerete kel noub sarte. Eri kel ere kuyese keren omote, o kuyese beke kip keren omo. Ere etep kiyi abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ere kel kiyi beke abo, ere kwat tuken, mesginte. Ere kelken berai, ere kuyese beke kip kere. Tatame nogwape eme etep late, eme ete tame erne sak keyete. Eme erne etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Tame ere ake kwat tukem, ere beke kere. Etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Apeilake ere eteri ei nai tame nogwape (10 tausen) emne panen yin akeite apeilake eri ei nai tame nogwapewai (20 tausen) ei nai tameken yin naite, ere kiyi sin noub abote. Ere akeite apeilake eterken kuyese naite, o kuyese beke kip nai? ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ere abolawoite, kuyese beke kip nai wote, peiktame eme kaike som temente, ere emne tuma wopitin etep wote. Nema sene sin tuma namden eyaren gerute. Nema ei beke kip nai. Etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jisas ere sene etep wom. Eme kiyi sin abobekap, kem etep kiyi sin abote. Tame ere eri wos nogwape magel beke kip tai, ere ari anepoi tame beke kip yi. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Weyeke ere wos yenbo. Weyeke sene ere tuma beke kute, e weyeke sega. ");
INSERT INTO yss_yawu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Weyeke sega e wos toboger beke yewo. Nema bulmakau etemri seken beke kip ras, nowri awos beke kip noub waye. Berai. Nema bepou me kelpe emik sepitbe. Kem eike wanken, kem tuma somo mette. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yabel wuri kel petbetem tameken wule yaper nenbetem tameken eme yan Jisas eri tuma mette wurisubu emik siyewom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Siyewom, Farisi tameken Moses eri wule wusoubetem tameken eme Jisas erne kerebe tuma elen etep wom. Ete tame ere wule yaper nenbe tame etemken sin tuma namdebe, etemken a kir abe. E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jisas ere emne sekur sakur tuma etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Tame ere sipsip nogwape (100) temenem. Temenem, sipsip wuri ere sipsip nogwape emne mesginin mou sir yim, sipsip maime ere beke nenem? Sipsip nogwape (99) eme a kowke som abetemke, maime ere emne mesginin ere sipsip wuri sopen yim. Sopen yin sipsip erne ere sene lam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ere lan metekwasem, ere sipsip erne peten telak sen yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yam, ere komke yin ere eri tamenowu, eri kom tame emne won yan wurisubuk sin emne etep wom. Kem arenken metekwaste. Ari sipsip wuri mou yim, an sopen sene petye. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jisas ere sene etep wom. An kemne sipsip sekur sakur tuma somo wote. Tatame nogwape eme selpap yenbo tetan, God eri kom tame eme emne metekwaste. Tame yaper ere eri wule yaper mesginin selpap yenbo pette, God eri komri tame eme erne late, eme metekwaswaite nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jisas ere tuma sene wuri etep wom. Ta wuri te kel ep yekwo let ep yekwo let semenem, wuri yeirin berke yim, te beke nenem? Te tu yaren ake noub akwun sopen yin sene petem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sene petem, te teri nowuken kom tameken emne won wurisubuk sim, te emne etep wom. Kem arenken metekwaste. Ari kel wuri yeirin berke yiwo, an sene sopen lan petye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jisas ere sene etep wom. An kemne wobe. Wule yaper nenbe tame ere eri nenbe wule yaper mesginin selpap yenbo tete wote, God eri komri tame eme metekwaste. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas ere sene etep wom. Tame wuri eri taureyen peske temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mase ere ar erne etep wom. Apei, ne ane kiyi wom wos an pette. Etep womke, ar ere yen pes epne wos wosan newopit peteyam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Etep nenemke, mase eri wos akeite tame eme tuken ere maime kel petem. Kel petem, kerake tem, mase ere eri wos lokopakwon ar erne mesginin ere gene komke yin temenem. Etek temenem, ere wule yaper nenen eri kel bepou me petewarem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ere kel petewarem, yuri eter temenem kom nakwoi meig sim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nakwoi meig simke, ere ete komri tame wuri erne yaku wometem, tame ere erne won yin eteri por lakeren a newon abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Newon abetem, por eme me supa abetem, ere kir atekap tebetem. Atekap tebetem, erne eike tame erne a beke wuri newon a. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Etep temke, ere sene abopitin ere etep wom. Apei eri yaku kerebe tame eme a nogwape tetan. Tep eme me mesginbe. Arenwou an gwote selke tetan, an se kwoi sabe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","An sene yite. An apei erne lan etep wote. Apei, an God eterken nerenken kepne yaperke nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Gwopte an tame yenbo berai, ne ane neri yen mane wote. Ne ane neri yaku kerebe tame wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Etep womke, ere wayen teten ar erne late yim. Ere genek yabetem, ar ere erne kaike lam. Lam, ar ere erne kobo kenake lam, ere amen yin yen erne narpeten erne bwoibayem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bwoibayem, yen ere ar erne etep wom. Apei, an God eterken nerenken kepne yaper nenem. Eke an tame yenbo berai, ne ane neri yen mane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Etep womke, ar ere eri yaku kerebetem tame emne etep wom. Kem ari tame oub yenbowai peten agetage sen yan ari yen erne newote. Let bor pisiki wuri erne let borke wurute. Erne tewo bus wurute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Etep ten, kem wus me burbur kelkelbe bulmakau yen wuri peten sen yan pen san kwiyen kisin nema ate. Nema awos eisau an kir teste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","An abobe. Ari yen ere kiyi sam, gwopte ere sene yawo. Ere kiyi yim, gwopte nema erne sene laye. Etep wom, eme erne metekwasen kir tesbetem. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mase tobo yen ere nowke temenem, ere sene yabetem, ere ake mekinke tetbetem, ere sekwo taye metem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Meten yan, ere yaku kerebetem tame emne wopeten yan ere emne etepke wometem. Eme e beke nenbe? ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Eme erne awosein etep wom. Neri mase ere sene yawo, ere noub tetan. Eteke, ar ere bulmakau yen wus me burbur kelkelbe erne wuri peye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Etep metem, lake ere pap wayen ere ake purik beke wur. Beke wur, ar ere yan woran erne etep wom. Ne wora. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ere ar erne awosein etep wom. Metye. Yabel nogwape an nerenken yaku kerebe tamekap neri yaku kerebetem. Yabel wuri an neri wule beke yaper nen. An etep nenbetem, ne ane meme yen beke wuri pen newon a, ari tamenowu etemken beke a. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Neri kel nogwape neri yen ere peten yin eter sir yibetem ta etemne akei newopit peteyan omom. Omom, ere sene yawo, ne erne letewo oksubu teye, ne erne bulmakau yen wus me burbur kelkelbe erne peye. Etepkap e yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ar ere erne tuma awosein etep wom. Yen, ne arenken gwotek som tetan. Nesa etep tetan, ari wos nogwape nereriwou. ");
INSERT INTO yss_yawu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Neri mase an erne etep wom. Kap ere me sam. Gwopte ere sene yawo. Kiyi ere yim, gwopte nema erne sene laye. Etepkap, nema erne letewo oksubu tete. Jisas ere sekur sakur tuma etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas ere eri anepoi tame emne sekur sakur tuma wuri etep wom. Kel worken tame wuri ere eri yaku lakerebetem tame erne wom. Tame kau eme kel worken tame erne yan lan erne etep wom. Neri yaku lakerebe tame ere neri kel bepou me sepitbe. Ere yaku yenbo beke kere. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Etep womke, ere yaku lakerebe tame erne won yan erne etep wom. Tatame eme nene woye, ne tumaken teye. Ne ane wusoute. Ari kel ne beke nenem? Sene ne yaku lakerebe tame beke te. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yaku lakerebetem tame ere eteri selpapke etep abom. Aneyen ere ane kip tumaken tete, an mapeke tete nenbe? Sene an be yakuke kerete? An mureken berai, an now yaku kuyese mapeke keren kel pette? An akeite tatame emne a nasegerete, etepkap an sebera yate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","An aboye. Aneyen ere ane tumaken tete nenbe. Eke ari aboyekap an nente, tatame eme metekwasen eme ane pette, an etemri akek yin tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Etep abom, tatame nogwape aneyen erne tokwo awosein beke newo tatame emne yaku lakerebetem tame ere emne won yam. Yam, ere etemken wurare wurare tuma namderasem. Ere kiyi yam tame erne etep wometem. Ne ari aneyen erne tokwo mapseinke awosein newote? ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ere etep wom. An kwar yewoten gin nogwape (100) erne newote. Yaku lakerebetem tame ere erne etep wom. Gwo siglou e neren awosein newote siglou. Ete siglou ne awosein newote tokwo nebule (50-pela) etek baste. Ne aneyen erne awosein nogwape mane newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Etep wom, ere akeite tame wuri erne etep wometem. Ne aneyen erne tokwo mapseinke awosein newote? Ere etep wom. An erne wit supa nogwape (100) mateken awosein newote. Yaku lakere tame ere erne etep wom. Ne tokwo awosein newote siglou tokwo nebule (80-pela) etek baste. Ne aneyen erne awosein nogwape mane newote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yuri aneyen ere akeite tatame emne yaku lakerebetem tame eterne etep wom. Yaku lakerebetem tame ere etepkap nenem, ere porereken tame. Jisas ere sene etep wom. Nowselri wos abobe tame eme etemri tamesip emken yaku kerebe, eme porereken wule emne nenbe. God eri yaku abobe tatame eme etep beke te. Etepkap, aneyen ere etep wom. Yaku lakerebetem tame ere porereken tame. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jisas ere sene etep wom. An kemne wobe, kemri kel kem peten tatame emne be wos be wos yenbo tuken newopit peteyate, eme kemri tamenowu tete. Etep tete, yuri kemri kel omote, eme kemne God eri komke pap yewon kem etek som noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tame ere yaku nebule noub kerete, sene ere yaku eisau kir noub kerete. Tame ere yaku nebule noub beke kere, sene ere yaku eisau kir noub beke kip kere. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kem gwote nowselri wos noub beke lakere, mapeke God ere eteri komke tetan wos seken kemne newon lakere? Ere kemne beke kip newo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kem akeite tame emri wos noub beke lakere, eike kemne wos newote? ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yaku kerebe tame ere yaku lakerebe tame pes epri yaku kuyese beke kip kere. Wuri erne ere pap wayete, wuri erne ere metekwaste. Aneyen wuri eri yaku ere noub kerete, aneyen wuri eri yaku ere yaperke kerete. Etepkap kem God eri yakuken kel pet yakuken kem peske kuyese mapeke kerete. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi tame eme Jisas eri tuma metem, eme erne sou sakke keyem. Eme kel metekwasbetem tame, eke eme etep tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Etep tem, Jisas ere emne etep wom. Wos yenbo kem tatame etemri bitimik nenbe. Etep tebe, God eterwou ere kemri berasten porere yaper labe. Be wos tame eme kemne etep wobe. E yenbo. Ete wos, God ere labe, ere etep wobe. E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kiyi kem Moses eri wuleken tuma wusoubetem tame emri wule kem abobetem. Sene Jon ere yan etep wom. God ere kom panen site yabel mekin mekinye. Etep womke, tatame nogwape eme ete komke yite me egiyebe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Etep tebe, kem mane etep abote. Moses eri basem wule ere omoten. Berai. Eri wule eisauken wule nebuleken som tetan. Yuri nelken selken eme yaper tete nenbe, Moses eri basem wule ere yaper beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tame ere ta tene mesginin akeite ta panete, ere sir yibe wulekap nenbe. Ta wuri te tameken temenem, tame ere tene mesginim, akeite tame ere tene panete, ere sir yibe wulekap nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisas ere sekur sakur tuma sene etep wom. Kiyi kel worken tame wuri ere temenem, ere tame oub yenbosubuwai warbetem. Kwokwos kwokwos ere a yenbo peten abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tame wuri ere kelken berai, eri sig Lasarus. Ere wus numa pemenem tame. Ere yin kel worken tame eteri ake eruke sibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sibetem, Lasarus ere etepke abobetem. Kel worken tame eteri a nebule tiy kulke yeirtek, an peten ate. Etep abom, ere etek sibetem, wale eme yan eri kuparmus tawulke pokwobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yuri Lasarus ere sam, God eri kom tame eme yan erne peten sen yin ere neremri warege Abraham eterken kom yenbok temenem. Temenem, yuri kel worken tame erken sam, eme erne sele meike rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sele meike rasem, ere kom yaper, ker tetan komke yin temenem, ere mus eisau metbetem. Metbetem, ere genek nereyim, Abraham ere etek temenem, Lasarus ere eterken etek kir temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Etep lam, kel worken tame ere erne etep wom. Apei Abraham, ne ane kobo late. An ker musken yabe. Ne Lasarus erne won yan ere let bor okke sogwunen ere yan ari tawulke raste, ari tawul negelken tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham ere etep wom. Yen, ne sene abote. Kiyi ne selke temenem, ne wos nogwape yenbo petbetem, Lasarus ere yaper temenem. Gwopte Lasarus ere pap yenbo metbe, neren ne mus eisau yaper metbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","An nene sene wobe. Pwale eisau neremri borke tetan. Gwote barke tetan tame eme keraru barke kuyese mapeke wu, kem ep yekwo barke tetan, kem gwope yekwo kuyese mapeke yeir. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kel worken tame ere etep wom. Apei, an nene wobe. Ne Lasarus erne won areri apei eteri akek yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Areri mase ep yekwo let eme etek tetan. Lasarus ere yin emne tuma wusoute, eme gwote komke mane kip yate, eme kip mus eisau mette wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham ere etep wom. Mosesken kiyi tuma wusoubetem tameken eme ete tuma kiyi basem. Neri mase eme ete tuma wan wurik mette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kel worken tame ere awosein etep wom. Apei Abraham, eme kuyese mapeke met? Sam tame ere sele meike sene wayen emne yin wotek, eme ek meten emri nenbe wule yaper mesginin selpap yenbo pette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham ere etep wom. Eme Mosesken tuma wusoubetem tameken etemri tuma beke met, eme sele meike sene wayete tame eteri tuma kir beke kip met. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas ere eri anepoi tame emne etep wom. Tatame emne seilate wos tete nenbe, tatame eme wule yaper sene nente nenbe. Eike tatame eme tatame emne seilate, ete tatame eme yaperwai tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tame ere yenkap ane abobe, akeite tame ere erne seilate, sene ane kenawaike abobe tame ere wule yaper nente. Etep tete, seilate tame ere wule yaper sene mane nente, eke eme erne pape eisau wakke tenen erne peik meike sogwunte. God ere erne pete, ere mus eisau mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kem maime eisa eisa. Kemri lake o mase ere wule yaper nente, kem erne wotakete. Wotakete, ere wule yaper mesginte wote, kem eri wule yaper peten magelke raste. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yabel wuri tame ere nene tewo nogwape (7-pela) nene wule yaper nente, ere tewo nogwape (7-pela) sene yan lan etep wobetete. An nene wule yaper nenye, an sene beke kip nen. Etep wote, kem erne tuma mane namdete, kem eri wule yaper peten magelke raste. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisas eri won yim tame eme erne etep wom. Nema nene kenawaike beke abo, ne nemne kobo late, nema nene kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aneyen ere etep wom. Mastet supa e nebulewai, sene ere moyen eisau tebe. Etepkap, kem God erne kerawaike abotek, kem gwote me erne kuyese etep wote. Ne somoken yesen sen yin ne peikke yin tetete. Kem kerawai abon etep wote, ere kemri tuma meten etek yin tetete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Apeilake tame wuri ere eri yaku kerebe tame won yin now yaku kerete, o ere sipsip lakerete. Etep nente, yaku omote, yaku kerebe tame ere akek sene yate, apeilake ere erne mapeke wote? Kap ere etep wote. Ne ege sin gwote awos ate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Berai. Ere etep beke kip wo. Ere erne etep wote. Ne areri iyawu kiyi kerete. Sene ne mate peiken ari a sen yate. An kiyi atek, yuri ne yin neri a ek ate. Etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yaku kerebe tame ere apeilake eteri tuma tobote, apeilake ere erne pir beke wo. Berai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kerem kir. God ere kemne wom yaku kem keren omote, kem etep wote. Nema yaku kerebe tame yaper. God ere nemne newom yaku nema etepwou kerebe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas ere Jerusalemke yibe keluke yibetem, ere Samaria distrik, Galili distrik borke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yibetem, ere kom wurik wurbetem, numa pe tame ep yekwo let ep yekwo let eme yan erne keluke lam. Lam, eme genek teten ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","noubke etep wom. Jisas, Aneyen, ne nemne kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Etep womke, ere emne lan emne etep wom. Kem yite. Kem kemri wus God eri akek yaku kerebe tame emne peterate. Eme sene yibetem, emri wus sene yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tem, etemri wuri ere eri wus etep lan eri wus yenbo tem, ere sene yam. Yabetem, ere God eri sig eisau noubke wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wobetem, ere yan Jisas eri tewo tobok gulke pan erne pir wobetem. Ete tame ere Juda tame berai. Ere Samariari tame. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisas ere erne lam, ere etep wom. Tame ep yekwo let ep yekwo let emri wus yenbo teye. Ep yekwo let ep yekwo let bor epe pes epe pes keyem (9-pela) tame eme mak yiwo? ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Eme sene beke ya, God erne pir beke wo. Samaria tame eterwou ere sene yan God erne pir woye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jisas ere erne etep wom. Ne wayen yite. Ne ane kenawaike aboye, eke ne yenbo teye. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi tame eme Jisas erne etep wometem. Mapeke God ere kom panen si? Ere emne awosein etep wom. God ere kom panen site, tatame eme lek beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Eme etep beke kip wo. Ek la, ere gwok tetan. O eme etep beke kip wo. Ere ep yekwok tetan. Metye. God eri kom panen site wule kemri selpapke tetan. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sene Jisas ere eri anepoi tame emne etep wom. Yuri kem selpap yaper tete, kem ane late abote. Kem ane yabel wurik late abote. Abote, kem ane beke kip la. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tatame eme kemne etep wote. Ek la. Ere etek tetan. O eme etep wote. Ak la. Ere gwok tetan. Etep wote, emri wote tuma kem mane meten sopen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pelalekap an nowsel nogwape tukap kerebekap, an Tatame Etemne Lan Yeirim Tame an yate, an etepkapke yate nenbe. Tatame nogwape eme ane etep late nenbe. E yurik tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Gwopte tetan tatame eme ane kiyi magel taite, an mus nogwape kiyi mette. Ete mus kiyi tetek, an yurik yate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kiyi Noa eter temenem yabel tatame emri nenbetemkap, an sene yate yabel tatame eme etepke nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa eter temenem yabel tatame eme nowselri woswou abobetem, eme a abobetem, ta panebetem. Etepwou abobetem. Eme God erne beke abo. Etep tebetem, sene Noa ere sip sikile wuri keren etek temenem, eme etep som tebetem. Tebetem, ok sapeken geyin tatame nogwape eme akei eme okke an saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Sene yuri Lot ere temenem, eme etepwouke nenbetem. Eme a abetem, tokwo natokwo kerebetem, eme now yaku kerebetem, eme ake kerebetem, eme ete woswou abobtem, eme God erne beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Etep temke, Lot ere Sodom kom mesginin yibetem, kerken pape nelke moukap tim, tatame eme ete kerke eyin saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","An Tatame Etemne Lan Yeirim Tame, an yan kom geinike tete yabel tatame eme etepkap som nente nenbe, eme God erne beke abo, eme nowselri yakuwou abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","An yate nenbe yabel tame ere ake maklek simente, ere agetage amen yite. Ere ake purik mane wurin eri be wos be wos mane pette, ere yaper tete wurken. Tame ere nowke temente, ere agetage amen yite. Ere akek sene mane yin be wos be wos pette, ere yaper tete wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kem Lot eri ta tene abote. Eme amen yibetem, te teri wos pette sene petkwo lam, God ere tene pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tatame eme etem maimewou abote, eme yaper tete nenbe. Tatame eme etem maime beke abo, eme noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","An kemne wobe. An yate, ete neir tame pes epe wurisubu tiyke tuknamente, wuri erne an panen yite, wuri erne an etek mesginte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ta pes epe nak etep tabetete, an yatek, wuri tene an panen yite, wuri tene an etek mesginte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tame pes epe etep nowke temente, an yatek, wuri erne an panen yite, wuri erne an etek mesginte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jisas eri anepoi tame eme erne etep wometem. Aneyen, neren woyekap ma barke tete? Ere emne sekur sakur awosein wom. Omyen kupa tetan emi kware eme etek agetage yan wurisubu emik sibe. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas ere abom, eri anepoi tame eme God erken kwokwos kwokwos tuma namdete, eme mane bulken tete. Eke ere emne sekur sakur tumak etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tuma metbetem tame ere komke temenem, ere God erne beke ak, ere tatame nogwape emne beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wane ta te ete kom sagke kir temenem. Temenem, kwokwos kwokwos te tuma metbetem tame erne yin lam, etep metbetem. Tame kau eme ane tuma namdebe. Ne ane kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Etep wom, tuma metbe tame ere tene kobo late mo won wotakebetem. Wotakebetem, yuri ere eteri selpapke etep wom. An God erne beke ak. Tatame etepwou emne beke ak. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ete wane ta te ane som wometbe, wometbe, etepkap an mo woye. Eke an tene tuma kobo late. An tene beke kip kobo la, te som worwor yabetete, an mowai woye. E yaper. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jisas ere sene etep wom. Etek tuma metbe tame yaper eri nenem wule kem noub abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eter nenemkap God eteri wom tatame eme eterken kwokwos kwokwos neirken yabelken som tuma namdebetete, kap God ere emne agetage kobo late o? ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","An kemne wobe. Ere agetage emne kobo late nenbe. An Tatame Emne Lan Yeirim Tame, yuri an kap mapeke yan late? Kap tatame eme ane kenawaike abon God erken tuma namdebetete, o eme ane kenawaike beke kip abo, God erken tuma beke kip namde? Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tame kau eme etem maime kena yenbo abobetem, eme akeite tatame emne mo wobetem, ete tame emne Jisas ere sekur sakur tuma etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Tame pes epe God eri ake eisauke wurin God erken tuma namdebetem. Wuri ere Farisi tame, wuri ere kel petbetem tame. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Wurim, Farisi tame ere yin teten eteri selpapke God erken tuma namden etep wom. God, sen. An tame nogwape etemkap berai. Eme sir petbe, eme tuma yikwokwobe, eme sir yibe. An etepkap tame berai. An gwo kel petbe tame yaper eterkap berai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sande wuri yabel pes an nene abobe, an awos takerbe. Wos nogwape an petbe, an pekayewon ep yekwo let ep yekwo let rasen, nene wuri newobe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kel petbetem tame ere genek teten le selwouke lan ere eri morgu apeken etep wom. God, an wule yaper nenbe tame. Ne ane kobo late. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jisas ere anepoi tame emne etep wom. An kemne wobe. God ere ete kel petbetem tame eri nenbetem wule yaper peten sepitim. Sepitim, tame ere eri akek sene yim, God ere erne tame yenbo wom. Farisi tame eri wule yaper eterken som tetan. Tame ere eri sig maime eisau wote, God ere eri sig teitkwunte nenbe. Tame ere eri sig maime teitkwunte, God ere eri sig eisau wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tatame eme emri yen geibele Jisas erne sen yam. Eme abom, Jisas ere yen emne let keren God erne womette, eme noub temente. Eke eme yen sen yam. Yam, Jisas eteri anepoi tame eme etep lan, eme anenawo emne wotakem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wotakem, Jisas ere yen emne wopeten mekinke yan tetyewom. Ere etep wom. Kem emne mane wotakete. Eike tatame etem eme yen etemkap God erne kenawaike abote, eme God eteri panen siten komke yite. Yen emne mesginin eme yate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","An kemne sekenke wobe. Kem selpap yaper mesginte, yen eme wos yenbowou abobekap, kem etepke abote. Kem etep tete, kem God eter panen siten komke wurte. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juda etemri apeilake wuri ere yan Jisas erne etep wometem. Tuma wusoube tame, ne tame yenbo. Be wule an nentek, an noub som temente? ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisas ere erne awosein etep wom. Beke ne ane yenbo woye? Gwote nowselri tatame eme eike yenbo beke wuri te. God eterwou ere yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ne wule metbe. Wule ere etep wobe. Ne eike tameri ta tene sir mane yite. Ne alwo mane pete. Ne sir mane pette. Ne tuma mane yikwokwote. Ne anenawo etepri tuma noub meten tobote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Etep womke, tame ere erne etep wom. Kiyi an apulele yen ten yan gwopte an aneyen tem, an ete wule noub toboten. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas ere etep metem, ere erne awosein etep wom. Wos wuri ne beke nen. Neri be wos be wos nogwape akeite tame eme tukte. Tukte, etek pette kel ne wosken berai tatame etemne newote. Etep tete, ne yan arenken temente. Etep tetek, yuri ne God eri komke yin tete, ne wos yenbo etek pette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Etep wom, ete tame ere etepkap tuma metem, ere pap yaperwai tem. Bepou berai. Eri wosbas nogwape ere eike tatamene newote mo wom. Eke Jisas ere womkap ere beke tobo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas ere etep lam, tame ere pap yaper tem, ere erne etep wom. Kel worken tame eme emri wos nogwape abobe, eme God eri panen siten komke yite abobe, God ere emne etep wobe. Kem yaku eisau keren, kem ek God eri panen siten komke yite. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel ere por eisau. Ere mate kapebe lag taukke wurte wote, ere me tekekebe. Etepkap, kel worken tame ere God eri panen siten komke yite abobe, ere yaku eisauwai keren, ere ek yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Etep wom, etek temenem tatame eme etep wom. Tame eme kel worken eme akeite tatame emne kuyese kobo labe. Eke nema abobe, eme God eri komke yite, eme yaku eisau beke kere. Neren, ne wobe. Eme yaku eisau kerete. Eke nema abobe, eike tame ere kuyese beke kip yi. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisas ere awosein etep wom. Be wos tame eme kuyese beke nen, God eter ere kuyese nente. Tame etem eme akeite tame emne God eri komke beke won yi. God eterwou ere tatame emne eteri komke won yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita ere etep wom. Metye. Nerem, nema nemri kom mesginin nerenken anepoi tame yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisas ere etep wom. Ye. An kemne sekenke wobe. Tatame eme God eri yaku kerete, eme emri kom, yenta, lakemase, anenawo mesginin God eri yaku kerebe, ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ete tatame gwopte God ere emne awosein yenbo nente nenbe, yuri eme noub som temente. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas ere eri ep yekwo let ep yekwo let ep yekwo tewo bor pes keyem (12-pela) anepoi tame emne panen yin etep wom. Kem mette. Nema Jerusalemke yite. God eri kiyi temenem tuma wusoubetem tame eme tuma nogwape kiyi bas rasem. An Tatame Etemne Lan Yeirim Tame, eme aren tetekap bas rasem. Etek bas rasem tuma gwotepte sekenwai teye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Eme ane keresukte, sene akeite tame eme Juda tame etemri berai, eme ane peten ane tuma workwoyeken reste, ane tuma yaper wote, ane sablekwo auyarte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sene eme ane paku pete, ane pen sate nenbe. Sate nenbe, yabel pes tetek, mur an sene wayen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Etep wom, eri anepoi tame eme tuma somo beke met. Tuma somo ere me berasem, Jisas ere wom tuma eme beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas ere Jeriko kom mekin mekinmenem, le simenem tame wuri ere kelu ganke simenem, ere tatame emne kelken wosken nasegerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nasegerebetem, ere metem, tatame nogwape eme tuma obulen yabetem, ere kau emne etep wometlam. Kem beke nenbe? ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Eme erne awosein etep wom. Nasaret komri Jisas eter yabe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Etep womke, ere noubke etep tem. Jisas, ne Devit eteri nan. Ne ane kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Etep womke, kiyi taresim tame eme erne wotaken etep wom. Ne elen me te. Etep womke, ere noubke sene etepke tem. Ne Devit eteri nan. Ne ane kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Etep womke, Jisas ere yan teten emne etep wom. Kem erne arenke panen yate. Etep wom, ere Jisas erne mekinke yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Jisas ere erne etep wometem. Ne abobe, an nene beke nente? Ere awosein etep wom. Aneyen, an aboye, an le sene noub late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jisas ere erne etep wom. Neri le yenbo teye. Ne ane kenawaike etep abobe, an nene noub eyarte. Etep abobe, eke nereri le yenbo teye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Etep womke, eri wom tuma agetage ete tame eri le kuyese lam. Lam, ere Jisas erne semowun yibetem, ere God eri sig eisau wobetem. Wobetem, tatame eme etep lam, eme God eri sig eisau kir wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas ere Jeriko komke yin wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tame wuri eri sig Sakius ere Jeriko komke temenem. Ere takis kel petbetem tame etemri apeilake tame. Ere kel worken tame. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Komke wurim, Sakius ere Jisas erne late wom. Tatame nogwape eme etek temenem, Sakius ere tobotare tame, ere Jisas erne kuyese beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Eke ere kiyi taresin amen yin ere yipige nak yawon sim. Sim, ere etepke abom. Jisas ere gwote keluke yate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Etepke abom, Jisas ere yan nerulan erne etep wom. Sakius, ne agetage yeirte. Gwopte an neri akek yin tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Etep wom, ere agetage yeirin Jisas erne panen eteri akek yim. Yim, ere me metekwasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tatame nogwape eme etep lam, eme Jisas erne pap wayen etep wom. Ere wule yaper nenbe tame etemri akek yibe, e yaper. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakius eter ere teten Aneyen erne etep wom. Aneyen, ne ek met. Gwopte an ari wos wosan obo pes raste. Obo wuri an wosken berai tatame emne newote. Kiyi an eikene yikwokwon emri wos sirke petbetem, an emne wos epe pes epe pes awosein newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Etep wom, Jisas ere erne etep wom. Gwopte gwote akek tetan tatame eme emri wule yaper mesginin sene selpap yenbo petye. Gwote tame eter kir, ere warege Abraham eteri nan, an erne kir sene petye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","An Tatame Etemne Lan Yeirim Tame, an yam, an yaper nenbe tatame emne sopen sene pette yam, an emri wule yaper peten sepitte yam. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisas ere Jerusalem mekinke yan temenem, etek temenem tatame eme etep abom. God eri kom panen site yabel mekin mekinye. Jisas ere emri abomkap lam, eke ere tatame emne sekur sakur tuma etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Apeilake wuri ere panen site keryen tete abom, eke ere gene kom sagke yin sene yate wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yite wom, ere eri yaku kerebetem tame ep yekwo let ep yekwo let emne won yam. Yam, ere kel me pes me pes (20 kina, 20 kina) emne wurare wurare newon emne etep wom. Ete kel kem tokwo pette yaku kerebetete. An sene yate, an kel sene ek pette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Apeilake eteri kom tame eme erne mo wom, eke ere yibetem, eme tame kau emne won yin erne kin yekwok gene komri apeilake tame erne etep wom. Ete tame erne nema mo woye. Ere neremne kom panen site tame mane tete. Nema mo woye. Eme erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ere kom panen site tame tem, yuri ere sene yam, kiyi kel yaku kerebetem tame emne ere won yam, ere kel warkeken pette, ere emne etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tame wuri ere kiyi taresin yan ere etep wom. Apeilake, an neri kel me pes (20 kina) petem, tokwo petbe yaku kerebetem. An sene warkeken nogwape (200 kina) peten rasem. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ere erne awosein etep wom. Ne yaku kerebe tame yenbo. Ne yaku yenbo kerebetem. Ne wos nebule noub lakerebetem, etepkap an nene yaku yenbo sene newote. Sene ne kom sag ep yekwo let ep yekwo let lakerete. Ere erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yuri tiptewum yam tame ere etep wom. Apeilake, an neri kel me pes (20 kina) petem, tokwo pet yaku kerebetem, sene an warkeken (100 kina) an sene peten rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Etep womke, ere erne etep wom. Yenbo. Ne kom sag ep yekwo let lakerete. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Akeite yaku kerebetem tame ere yan etep wom. Apeilake, neri kel me pes (20 kina) an som seten. Ete kel an mate megke peiken berasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Neri wule an lam. Ne agegerake tetan. Akeite tame etemri wos ne papke abo petbe. Etepkap an nene me akbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Apeilake ere erne etep wom. Ne yaku kerebe tame yaper. Neri namdebe tuma yaper an nene eteke tuma namdete nenbe. Ne lam, an agegera tetan, akeite tame etemri wos an papke abok petbe. Awos akeite tamek nanekwobe, an papke abok yin petbe. Ne etep lam, beke ne ari kel bepou me rasem? ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ari kel ne pauk kel rasbe akek raste wom, kel nogwape tete wom. Etep tete wom, an sene yan kel warkeken sene pette wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Etep womke, ere mekin tetmenem tatame emne etep wom. Kem eteri kel me pes peten kel nogwape (200 kina) tetan tame erne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eme erne etep wom. Apeilake, ere kel nogwape seten. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ere etep wom. An kemne wobe. Kel worken tame o porereken tame an erne worwor sene newote. Tame ere be wos o be porere beke wuri te, eri temente nebule wos o porere nebule an sene pette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ari peiktame, an kom panen site mo wom tame emne kem panen yan emne areri bitimik pen sate. Jisas ere ete sekur sakur tuma etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas ere ete tuma won ere Jerusalem komke taresin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Taresin yim, ere Oliv kowke tetan komke yam. Kom pes Betfageken Betaniken. Yam, ere eri anepoi tame pes epne won taresin yim, ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ere epne etep wom. Kep ete komke yin wurte, kep late, donki yen wuri etek tenten. Ete donki, tame eme eteri magel lu kiyi beke si. Kep yin kep ogwen donki panen sene yate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kep ogwobetetek, tame eme kepne etep wolate, kep beke donki yen kep ogwobe? Etep womette, kep awosein etep wote. Aneyen ere nesetne won yawo, nesa donki eterne panen yite. Etepke wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Epe yim, Jisas ere epne wom tuma ere sekenwai tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tem, epe donki yen kep ogwobetem, donki yen maime ere epne etepke wometem. Beke kep donki yen kep ogwobe? ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Epe awosein etep wom. Aneyen ere nesetne won yawo, nesa eke ogwobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Etep womke, epe donki yen Jisas erne panen yam. Yam, emri warmenem tame oub eme peten donki yen eri magel luke rasem, Jisas ere etek yawon sim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sin ere yibetem, tatame eme emri warmenem tame oub lugun keluke petan, Jisas ere ete luke yim. Eme abom. Jisas ere keryen, eke eme etep nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yim, ere Jerusalem mekinke yan tem, ere Oliv kowke warbe kelu bougke ere etek yibetem. Yibetem, eri anepoi tatame nogwape eme erne metekwasem. Erne metekwasem, Jisas ere kiyi nenbetem wule eme abom, eke eme God erne tuma yenbo noubke etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","God ere Eri Won Yam Kom Panen Site Keryen erne yenbo nente. God ere tatame emne yenbo nente. Nema God eri sig eisauwai wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eme etep wobetem, Farisi tame kau eme tatame nogwape etemken temenem, eme Jisas erne etep wom. Tuma wusoube tame, ne neri anepoi tatame emne wotakete. Eme elen te. Eme mane nobke tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisas ere awosein etep wom. An kemne wobe. Tatame eme elen tete, pape etem eme nobke tate. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas ere Jerusalem kom mekinke yabetem, ere kom lam, ere me keram. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Keram, ere etep wom. Noub site wule kem late, e yenbo. Gwopte ete wule ere kemne me berasten, kem kuyese mapeke la. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yuri akeite yabel tete, peiktame eme yan ei warte. Eme lu tayen ek yawon waren komri tatame emne lelete. Kem kuyese beke kip wora. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Eme yan ei naite, kemri komke teten tatameken yenken emne eme akei pen sate nenbe. Eme kemri ake akei berayewote nenbe. Ake kerebetem pape eme akei berayewon petewarte nenbe. God ere kemne sene pette yam, kem etep beke abo, etepkap kemri peiktame eme yan etepke kemne tete nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas ere God eri ake eisauke yin wurin lam, tame eme kel yaku etek kerebetem. Lam, ere emne won wos kerouken ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","emne etep wom. Kiyi temenem tame eme God eri tuma etep bas rasem. Ari ake e arenken tuma namdebe ake. Eme etep bas rasem, kem etep beke nen. Eteri akek kem kel petbe yaku keren tatame emri kel petbe. God eteri ake e sir petbe tame etemri berasen sibe akekap. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Etep wom, yabel nogwape ere tatame emne God eteri ake eisauke tuma wusoubetem. God eteri akek yaku kerebetem tame etemri apeilake, Moses eri wule wusoubetem tame, Juda tatame emri apeilake eme Jisas erne pen sate abom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Abom, tatame nogwape eme eri tuma mette abom, eke apeilake tame eme Jisas erne pen sate kelu wuri beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Akeite yabel Jisas ere God eteri ake eisauke wurin tatame emne God eri tuma yenbo wusoubetem, God eri akek yaku kerebetem tame etemri apeilake, Moses eri wule wusoubetem tame, Juda tatame etemri apeilakeken eme erne late yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yam, eme erne etep wom. Ne nemne wusoute. Nereri yaku eike nene newom, eke ne ete yaku kerebe? Eike nene mure newom? ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ere emne awosein etep wom. An kemne tuma wuri womette, kem ane wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon ere yam, ere tatame emne baptais ok wirubetem. Eike erne ete yaku newom? Kap God eter erne newom, o tame etem erne newom? Kem ane wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Etep womke, eme etemwou etemwou namden etep wom. Nema mapeke wote? Nema mane etep wote. God eter erne won yam. Nema etep wote, ere nemne awosein etep wote. Mapeke temke, kem Jon eri tuma beke abo? ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nema mane etep wote. Tame etem erne won yam. Nema etep wote, gwotek tetan tatame nogwape eme pape paku peten nemne pete nenbe. Tatame eme etep wobe. Jon ere God eteri tuma wusoubetem tame. Etepkap, eme pape peten nemne seitte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Etemwou etemwou namdebetemke, eme Jisas erne tuma awosein etep wom. Nema beke met, eike Jon erne won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ere emne awosein etep wom. Kem ane beke wusou, an kir an kemne beke kip wusou. Eike ane won yam, an kemne etep beke kip wusou. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisas ere sekur sakur tuma tatame emne etep wom. Tame ere gerep now nenem. Nenem, ere yaku kerebetem tame etemne ete now lakerete etep wom. An akeite komke yite. Kem ari gerep now yaku keren noub lakeretek, yuri an kemne gerep supa kau newote. Etep womke, ere gene komke yin etek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Etek temenem, gerep supa okwon yamenem, now maime ere eri yaku kerebetem tame wuri won now lakerebetem tame emne yin lam. Ere now maime eri gerep supa kwotate yim. Yim, now lakerebetem tame eme erne pen erne won bepou sene yim. Ere gerep supa beke wuri sen yi. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bepou me yim, sene maime ere akeite yaku kerebetem tame wuri won yim, eme eterken ei nayin erne pen erne won ere bepou me sene yim. Ere gerep supa beke wuri sen yi. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yuri tewo mur ere eri yaku kerebetem tame wurinabu won yim, eme erne pen lelem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Lelem, now maime ere etep wom. An mapeke tete? An ari metekwasbe yen seken, an erne won yite. Kap eme eri tuma mette o? ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ar ere yen erne won yim, now lakerebetem tame eme erne lam, eme etemwou etemwou etep namdem. Now maime eri yen seken ere yabe. Yuri yen ere ar eri wos pette nenbe. Nema erne pen satek, nema gwote sel pette. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Etep womke, eme erne keresukun now kopo ep yekwo barke panen wurin eme erne etek pen sam. Jisas ere sekur sakur tuma wom, ere tatame emne etep wometem. Now maime ere now lakerebetem tame emne beke nente? ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Now maime ere yin now lakerebe tame emne pen sate, ere akeite tame emne ete yaku newote nenbe. Tatame eme eri tuma metem, eme etep wom. Ere etep tete wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ere emne lan etep wom. Kiyi temenem tame eme God eri tuma gwopkapke bas rasem. Tame eme ake kerebe, eme kiyi sepitim kwat sene peten ake etek kerem. Ete kwat erne eme nawo kwat etek yewom. Ete kwat yenbosubuwai. God eri siglou eme etepke bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tatame eme ari woye kwat eterke emne tebete pitin waren, tewo wusken baute. Ete kwat ere warte, ere tatame emne botkwuyewon eme saiwote. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Etep wom, Moses eri wule tuma wusoubetem tame etem, God eteri akek yaku kerebetem tame etemri apeilake etemken eme Jisas eri wom sekur sakur tuma metem, eme etep abom. Jisas ere neremne woye. Etep abomke, eme erne agetage keresukte wom. Wom, eme tatame nogwape emne lam, eme me akem, eke eme erne beke keresuk. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eme Jisas erne mesginin eme erne elen labetem. Labetem, eme etep abom. Nema Jisas erne tuma wuri wometlate, ere tuma yaper awosein wote, nema erne keresukun Romri apeilake eterke panen yin erne tuma namdete. Etep abom, eke eme tuma yikwokwobe tame emne tuken emne won Jisas erne tuma wolate yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yim, eme Jisas erne etep wometem. Tuma wusoube tame, nema metem, neri wobe tuma e tuma yenbo, tuma seken. Keryen etemri wobe tuma ne beke ak. God eri tuma yenbo, eri tuma seken ne wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ne mapeke abobe? Keryen Sisar ere akeite nowselri tame, ere Rom tame. Ere nemne kom panen siten. Sisar ere nemne takis kel raste wobe. Nema mapeke nente? Nema Sisar eterne kel newote, o nema God eterwoune kel newote? Ne nemne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Emri yikwokwom tuma Jisas ere kiyi abom, ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kem ane kel wuri peterate. Eme erne peteramke, ere emne etep wometem. Gwote kel e tame wouken sigken tetan. E eikeri wouken eikeri sigken? ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eme awosein etep wom. E Romri Keryen Sisar eteri wouken eteri sigken tetan. Jisas ere etep wom. Romri keryen eteri wos kem eterne newote. God eteri wos kem God eterne newote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Etep womke, ere tuma yenbo tatame etemri bitimik awosein wom, eke eme ep abo ep abon tuma rebe tem, eme erne beke keresuk. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi tame eme etep wobetem. Sabe tatame eme sene beke kip wayen yi. Etepkap, etemri tame kau eme yan Jisas erne etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tuma wusoube tame, warege Moses ere tuma basen nemne etep wom. Mase tobo yen ere ta panete, yuri ere sate, ere yenken berai, mase ere sene eri wane tene panen yen sete. Sete, ete yen e lake eteri yen. Moses ere etepke basem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kiyi lakemase ep yekwo let ep yekwo let bor pes keyem (7-pela) temenem, mase tobo yen ere ta panem, epe bepou temenem, epe yen berai, ere bepou me sam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Samke, mase ere wane tene panem, epe yenken berai, ere bepou me sam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sam, bor tame ere etepwou tebetem. Mase eme etepwou etepwou tebetem. Eme ete wane etetwoune panebetem, eme yenken berai, eme bepou me saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yuri ete ta teken sam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kem etep wobe. Yuri sabe tame eme sene wayen yite nenbe. Kiyi akei lakemase ep yekwo let ep yekwo let bor pes keyem (7-pela) eme ete ta tene panebetem. Yuri sabe tame eme sene wayete, ete ta te eikeri ta seken tete? Eme Jisas erne etepke seilan wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisas ere emne awosein etep wom. Gwopte tetan tame eme ta panebe, ta eme tame narbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","God ere emne yenbo wote tatame yuri eme sene wayen God eri kom yenbok yin tete, tame eme ta beke kip pane, ta eme tame beke kip nar. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Eme God eteri komri tamekap temente, eme beke kip sa, eme som temente. God ere emne wote, eme sene wayen yite, eke God ere emne eteri yen wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kiyi Moses ere kerke eibetem me nebule mekinke yin tetemenem, God ere erne etep wom. An warege Abraham, Aisak, Jekop etemri Keryen God. Etep wom. Epkap Moses ere nemne peteram, sabe tatame eme sene wayete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God ere akei sam tatame emne wou sene newobe, eke ere sam tatame etemri God berai. Ere kelpe tatame etemri God. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Etep womke, Moses eri wule wusoubetem tame eme tuma awosein etep wom. Tuma wusoube tame, ne tuma awosein yenbo woye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Etep wom, eme erne sene womette me akem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisas ere emne etep wolam. Moses eri wule wusoube tame eme etep wobe. Krais ere Devit eteri nan tete. Beke eme etep wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Devit eter ere siglou basen etep wom. Keryen God eter ere ari Aneyen erne etep wom. Ne Aneyen, ne ari let pi seit yekwok site. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Yuri an wote, ne neri peiktame emne teitkwunen ne emne kom panen site nenbe. God ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit eter ere Krais erne Aneyen wom. Kerem kem etepke wobe. Krais ere kiyi beke te. Ere Devit eteri nanyen tete. An wobe. E seken berai. Devit ere Krais erne Aneyen wom, mapeke Krais ere Devit eteri nanyen tete. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tatame eme etek som temenem, Jisas eri tuma metbetem. Jisas ere eri anepoi tame emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Wule wusoube tame emri nenbekap kem etep mane nente. Eme abobe, tatame eme emne late, eke eme tame oub lagwu waren sewurbe. Sewurbe, eme kom genik sewurbe, eme abobe, tatame eme emne pir won emne tame yenbo wote. Eme God eteri akek wurbe, eme abobe, eme apeilake etemri wolbayek site. Eme awos eisau yite, eme abobe, eme apeilake etemri wolbayek sin ate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eme wane ta emne yikwokwon emri wos sirke petbe. Sirke petbe, sene eme God eri akek wurbe, God eterken tuma nogwape namdebe. Etep tebe, eme etep abobe. Tatame eme nemne yenbo wote. Etepkap eme tebe, yuri God ere emne yaperwai awosein nente nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas ere God eri ake eisauke temenem, ere lam, kel worken tame eme kel sen yan kel yewobe ouke yewobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yewobetem, ere lam, kelken berai wane ta te kel nebule pes te kel yewobe ouke yeworuwom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Etep lam, ere etep wom. An kemne sekenke wobe. Kel worken tame eme kel nogwape yewoye. Kelken berai wane ta te kel nebule peswouke yewoye. Teri yewoye kel ete tame nogwape emri kel teitkwunye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kel nogwape tetan tame eme kel kerake God erne newoye, kel nogwape eme som seten. Ete ta te kel nogwape berai, teri kel te akei newoye. Teri awos tukbe kel te akei newon omoye. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jisas eri anepoi tame kau eme God eteri ake eisauke tuma namden etep wom. Gwote ake nemri le yenboke labe. Eme pape yenbok kerem. Tatame eme God eterne newom wos nema kir labe, e yenbo wos. Etep womke, Jisas ere etep wom. Gwote ake eme kerem, eme pape peten tirin yawom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Gwote wos gwopte kem labe, e yenbo. Yuri ete pape eme kau pape luke sene beke te. Eme berayewon akei petewarte. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ere etep womke, eme erne etep wometem. Tuma wusoube tame, ne woye, eme God eteri ake eisau berayewote. Be yabelke eme etep nente? Be wos nema kiyi lan abote, ete wos ek tete? ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisas ere etep wom. Kem eisa eisa. Eme kemne tuma mane yikwokwote. Tame nogwape eme yate, eme ari sig wote. Eme yikwokwon etep wote. Aren, an Krais, God eter wom yam tame. Etep wotek, kau eme sene etep wote. Yabel mekin mekinye. Etep wote. Etemri tuma kem mane meten emne semoute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yuri kem mette, kom wuriri tatame eme akeite komri tameken ei eisau naite. Sene kem mette, kom wuriri tatame eme ei etemwou etemwou naite. Kem etep mette, kem mane akte. E nowsel yaper tete yabel berai. Nowsel yaper tete yabel ere yuri tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ere emne sene etep wom. Kom wuriri tame eme akeite komri tameken ei naite, apeilake wuri eteri wakseken naite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nina eisau yate, akeite akeite komri tatame eme kwoi sate. Tatame nogwape eme kapoyi eisau keite nenbe. Nel kem late, akeite wos yaper eisau kem etek late nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ari woye wos e yurik tete. Kiyi eme kemne keresukun kemne yaper nente. Eme kemne etemri tuma namdebe akek panen yin tuma namdete, kemne ake yaperke won wurte. Kem areri yaku kerebe, eke eme kemne kom panen sibe apeilake erne panen yin kemne tuma namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tuma namdete, kem areri tuma yenbo etemne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gwopte kem yuri sene wote tuma mane abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Awosein wote tuma yenbo an kemne wusoute, kemne porere yenbo newote. An kemne wote tuma kemri peiktame eme beke kip ragerkwun. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Anenawo, lakemase, meim wopu, tamenowu eme kemne peiktame emne wusoute. Peiktame eme keremri tame kau etemne pen sate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kem ane kenawaike abote, eke tatame nogwape eme kemne eike tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kem mane ep abo ep abote. God ere kemne lakerete, eke kem yaper beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kem yaku noub kerete, kem mane mesginte. Kem etep tetek, kem noub som temente. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yuri kem late, ei nai tame nogwape eme yan Jerusalem kom ei warte nenbe. Kem etep late, kem abote, eme kom ake akei berayewote yabel mekin mekinye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ete yabel kem Judiak tetan tatame, kem kowke sene amen yin tete. Jerusalemke tetan tatame eme kom mesginin yite. Tatame eme nowke temente, eme kom mane sene yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ete yabel God ere tatame emne pete nenbe. God eteri kiyiri siglouke bas rasem tuma ere seken tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","God ere gwote nowselke tetan tatame emne pap wayete nenbe, eme nogwape mus eisau mette nenbe. Tal. Ete yabel an yenken ta, yen muk newon abe ta emne kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kobo labe, akeite nowselri tame eme tatame kau emne pik pen sate nenbe. Kau emne eme keresukun panen yin akeite nowselke yin tete nenbe. Yin tete, akeite nowselri tatame eme Jerusalem kom panen site nenbe. Site, yuri God ere etep wote. E yau. Eme kom sene beke kip panen si. Etep wote, eme kom sene mesginin yite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ete yabel epkap epkap wos tete nenbe yabel, lup, sow emne epkapke late nenbe. Late nenbe, tatame eme kenake akte nenbe. Eme kerkera ok sare eisau ken meten lan ek akte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Etepkap wos gwote nowselke yate, tatame nogwape eme etep abote, eme kenake aken kuken yaken beke kip te. Nina nelke yate nenbe, nelri wos, yabel, lup, sow eme berayewon kenakena yite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Etepkap tete, eme late, an Tatame Etemne Lan Yeirim Tame, an nelgeike sene yate nenbe. An mureken tamekap yate, keryenkap yate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yuri ari woye wos tete, kem mette. God ere kemne pette yabel mekin mekinye. Eke kem teten bitimi nelke nerute. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jisas ere emne sekur sakur tumak etep wom. Kem kwarkepken mok walkuken abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kwarkep eme walku yeirbe, kem etep wobe. Nabe tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","An kemne kiyi woye tuma e etepkap. An woye tumakap etep tete, kem etep sene abote. God ere kom panen site nenbe. Kem etep abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","An kemne sekenke wobe. Gwopte tetan tatame eme beke kip sa, ari woye wos eme akei ek late nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nelken selken epe omote nenbe, ari tumawou ere som temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kem noub me late. Kem ok yaper nogwape mane an sisi pete. Kem nowselri wos mane abote. Kem Apei eteri woswou nenbetete, ari yate yabel an ari porerek yate nenbe. Tame ere pi sen yin por eteri porerek pebekap, an etep yate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ari yate yabel nogwape nowselri tatame eme akei late nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kwokwos kwokwos kem noub late, God eterken tuma namdete, ere kemne mure newote. Newote, ari woye wos tete, kem kuyese sate. An Tatame Etemne Lan Yeirte Tame, yuri an yate, kem areri bitimik noub tette. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yabel nogwape Jisas ere tatame emne God eteri ake eisauke yin tuma wusoubetem. Wo mesginin yabel warbetem, ere emne mesginin Oliv kowke yawon etek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Temenem, ei berakwunbetem, ere sene yeirbetem, tatame nogwape eme God eteri ake eisauke wurisubuk simenem, eme eri tuma mette koumenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","A eisau abe yabel tete nenbetem. A eisau abe yabel eri sig Pasova. Ete yabel Juda tame eme yisken berai bret abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ete yabel God eri ake yaku kerebetem tame etemri apeilake, Moses eri wule wusoubetem tame eme tatame emne akem, eme Jisas erne pen sate nenlawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nenlawoyim, Jisas eri anepoi tame ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) etemri wuri ere Judas. Eri akeite sig Iskariot. Gabo etemri apeilake, Satan, ere erne gulelem, ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ere yin God eri ake yaku kerebetem tame etemri apeilake, God eri ake eisau lakerebetem tame etemken namdem. Ere Jisas erne etemke newote kelu namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Namdem, eme metekwasem, eme erne kel newote wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Womke, Judas ere kir tem, ere yin Jisas erne keresukte kelu sopte yim. Sopte yim, ere abom. Tatame nogwape eme mane late. Etep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Juda tatame etem Pasova a ate yabelke eme yisken berai bret abetem. Abetem, eme sipsip yen pebetem, Pasova a abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Etep tebetem, eme etep abobetem. Kiyi God ere nemri yeiwarege emne beke pe, ere emne kobo lam. Etep abobetem, eke eme a abetem. Ete yabel Jisas ere Pitaken Jonken epne won yin etep wom. Kep Pasova a yin nente, nema yin ate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Epe erne etep wom. Nesa mak nente? ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ere epne etep wom. Metye. Kep kom sagke yin wurte, kep tame wuri late, ere ok tin ginken semente. Semente, kep eterne semoute. Eter wurte akek kep kir etek wurte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wurtek, kep ake maime erne etep wote. Tuma wusoube tame ere nene wometye. A ate emi ma? An ari anepoi tameken Pasova a ate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Etep wotek, ere kepne ake puri eisau iye yekwok tetan ake puri kepne peterate, tiyken wolbayeken etek temente. Peterate, kep Pasova a etek nente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Etep womke, epe yin Jisas ere womkap epe etep lam, epe Pasova a etek nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A ate yabel tem, Jisas ere a ate yin simenem. Eri anepoi tame eme eterken kir yin simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Simenem, ere emne etep wom. An Pasova a keremken ate aboye. Nema kiyi atek, yuri an mus eisau ek mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","An kemne wobe. An Pasova a sene beke kip a. Yuri God ere kom panen sitek, gwote awos eri wule somo genik tete, an sene ek ate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Etep womke, Jisas ere ok ware wuri peten God erne pir won emne etep wom. Kem akei kem gwo ok peten ate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","An kemne wobe. Wain ok, an nowselke temente, an sene beke a. Yuri an Apei eri panen siten kom etek temente, an sene etek ate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Etep womke, ere bret peten God erne pir won pekayewon emne newopit peteyan etep wom. Gwo areri om. (An kemne newobe, e keremne kobo late. Kem etep sene tetek, kem ane sene abote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","An omom, sene ere ok ware wuri peten etep wom. Gwo wain ok e areri nep. Eme ane pen sate, ari nep yeirte. Yeirte, ere tatame emne peterate, God ere keremken namderasem tuma ere seken tem, ere keremri wule yaper peten sepitte, kem eteri tatame tete.) ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Metye. Ane yena tete tame ere arenken sin a etep abe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","An Tatame Etemne Lan Yeirim Tame, an God eteri womkap sate nenbe. Ane yena tete tame ere mus eisau mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Etep womke, eme etemwou etemwou etep wom. Eike etepkap tete? Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Anepoi tame eme tuma walekap nayin etep wom. Eike neremri apeilake tame tete? ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Etep womke, Jisas ere emne etep wom. Akeite komri apeilake tame eme tatame emne kom panen sibe, tatame emne eme etep wobe. Nema etemri kulke tetan. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kem etemkap berai. Keremri tame wuri ere etep wom. Gwopte an apeilake tete. Etep wotek, an erne etep wote. Ne yenkap tete, yuri ne apeilake tete. Ne akeite tatame etemri yaku keretek, ne apeilake ek tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Eike ere apeilake tame? Kap pere meike siten tame eter, o pere ei kerebe tame eter? Nowselri tatame eme etep wobe. Pere meike siten tame eter ere apeilake tame. Eter ere tame eisau. Aren, an kemne wobe. Akeite tatame emne a yaku kerebe tame eter ere apeilake. An keremken tetan, an yaku kerebe tame. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Tatame eme ane seilan ane yaper wos nenbetem, kem arenken som temenem, kem ane beke mesginin yi. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ari Apei ere ane wom, eke an kom panen site. Etepkap an kemne wobe, kerem kem tatame emne kom panen site. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","An kom panen site yabelke kem arenken sin aken okken ate. Kem apeilake etemri wolbayek sin Israel tatame etemri tame beig ep yekwo let ep yekwo let ep yekwo tewo bor pes keyem (12-pela) etemri tuma meten, emne si late. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas ere etep wom. Saimon, ne mette. Satan ere God erne wometem, ere kemne seilate. Tame eme wit supa peten rermon supa kena rasbe, wus sepitbekap, Satan ere kemne etepkap seilate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Saimon, an God eterken tuma namdeye, ere nene kobo late, ne ane kenawaike som abote. An erne etep wometye. Satan ere nene seilate, ne wule yaper nentek, sene ne pap yenbo mette, ne neri lakemase emne tuma yenbo wusoute, ne ane kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita ere erne awosein etep wom. Aneyen, an nerenken ake yaperke kir yite, an nerenken kir sate. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisas ere awosein etep wom. Pita, an nene wobe. Gwopte neir kwokwo mak womente, tewo mur ne ari sig berasen etep wote nenbe. An Jisas erne beke la. Etep wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas ere emne etep wom. Kiyi an kemne won yim, kem mesupawak ayer beke waker, peleik ayer beke peleik, tewo oub beke wu. Ete yabel kem wos wuri sopem o? Eme awosein etep wom. Berai. Nema wos beke sop. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ere emne etep wom. Gwopte tame ere kel yewobe mesupawak tetan, o akeite ayer tetan, ere peten sete. Tame ere aki berai, ere eri tame oub peten ete tameken natokwo keren ere kel peten aki wuri yin tukte. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","An kemne wobe. God eri basem tuma etep wobe. Tatame eme etep wote. Ere tame yaper etemri wuri. Etep wobe. God eri tuma ere arene wobe, ete tuma ere sekenwai tete nenbe. Kiyi ane basem tuma sekenwai tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Etep womke, anepoi tame eme erne etep wom. Aneyen, ek la. Aki pes gwo. Ere emne etep wom. Yauke. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas ere kom mesginin yim, ere kwokwos kwokwos nenbetemkap ere etep sene nenem, ere Oliv kowke yawom. Yawom, eri anepoi tame eme eterken kir yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Yin eme ete emi petem, ere emne etep wom. Kem God erken tuma namden erne etep womette. Satan ere kemne seilate wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Etep wom, ere emne mesginin epkera yim, ere gulwar tewok pan God erken tuma namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ere etep wom. Apei, an abobe, ane yaper tete wos ete wos ane mane tete, an mus eisau mane mette. E nereri wos. Ari abobekap ne mane nente. Neri abobekap ne etepwou nente. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Etep womke, God eri komri tame wuri ere God eteri kom mesginin yan erne mure newom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ere pap yaperwai metbetem, ere God erne som wometbetem, kermus nepkap yan selke yeirbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ere sene wayen yin lam, eri anepoi tame eme pap yaper metem, eme tuknamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tuknamenem, ere emne teren etep wometem. Kem beke tuknaten? Kem wayen sin God erken tuma namdete, erne wometbetete. Satan ere kemne seilate wurken. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas ere som wobetemke, nogwape tame eme etek yam. Yam, Jisas eri ep yekwo let ep yekwo let tewo bor pes keyem (12-pela) anepoi tame etemri wuri, Judas, ere taresin yan Jisas erne bwoite yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Bwoite yam, Jisas ere erne etep wom. Judas, an Tatame Etemne Lan Yeirim Tame, ne ane peiktame etemne peterate, eke ne an bwoite yawo. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Anepoi tame eme eterken temenem, eme lam, eme erne keresukte nenbetem, eme erne etep wometem. Aneyen, ne mapeke abobe? Nema emne pete o? ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Etep womke, emri tame wuri ere God eteri ake yaku kerebetem tame etemri apeilake eri yaku kerebetem tame wuri eri pi seit yekwoken wan gapakuk baukwunen yeirsiyam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Etep lam, Jisas ere etep wom. Yau. Ne mesgin. Etep won ere ete tame eri wan baukwunem emi let kerem, eri wan noub sene tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Erne keresukte yam tame eme God eteri ake yaku kerebetem tame etemri apeilakeken God eri ake eisauri ei nai tame emne lakerebetem tame etemri apeilake etemne Jisas ere etep wom. Kem ane keresukte yawo, kem peiktame ei taresibe tamekap erne keresukte yawo. Kem ei nai wos setirten. An etepkap tame berai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yabel nogwape an keremken God eteri ake eisauke temenem, kem ane etek beke keresuk. Gwopte yabel e keremri yabel, eike kem wule yaper nente. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ere etep womke, eme erne keresukun erne God eteri akeri apeilake eri akek panen wurim. Wurim, Pita ere yuri tipti wun semowun yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yim, eme ker wuri ake makle borborke lisin simenem, Pita ere kir wus negel yam, eke ere etek yin etemken ker simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Simenem, yaku kerebe ta wuri te erne lam, te erne sene noub lan etep wom. Ete tame ere Jisas eterken sewurbetem tame. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Etep womke, Pita ere etep wom. An berai. An erne beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Etep wom, yuri sene tame wuri ere erne yan lan etep wom. Neren kir, ne etemri tame tep wuri. Pita ere etep wom. An berai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kerake tem, tame wuri ere me gwungwunen etep wom. Ete tame ere Galili tame. Ere Jisas eteri anepoi tame etemri wuri. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita ere wom. Berai. Neri wobe tame an erne beke la. Etep wobetemke, agetage kwokwo ek wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Wom, Jisas ere Pita erne petkwo lamke, Pita ere Jisas eri kiyi wom tuma sene abopitim. Kiyi ere erne etep wom. Gwopte neir kwokwo mak womentek, tewo mur ne ari sig neisen etep wote. An Jisas erne beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Etep abom, ere sebera yan ere kom genik wurin kenake keram. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jisas erne lakerebetem tame eme erne workwoyeken resen erne paku pebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pebetem, eme eri le matek subun eme erne etep wometem. Ne nemne wusoute. Eike nene pebe? ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Etep tebetem, eme erne yapersaper tuma kir wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ei beram, Juda tatame etemri kaunsil tame etemri apeilakeken God eri akeri apeilakeken Moses eri wule wusoubetem tameken eme wurisubuk sim. Sim, akeite tame eme Jisas erne etek panen yam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kaunsil tame eme erne etep wom. Ne nemne wusoute. Ne Krais, ne tatame emne sene pette yam tame o berai? Ere awosein etep wom. An kemne wusoute, kem ane kenawaike beke kip abo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","An kemne tuma wuri womette, kem ane tuma awosein beke kip wo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","An Tatame Etemne Lan Yeirim Tame. An gwote nowsel mesginte, sene an muremame Keryen God eteri let pi seitken yekwok site nenbe. Etepkap, nesa Apei erken nesa kom etep panen site. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Etep womke, eme etep wometem. Ne God Eteri Yen o? Ere awosein etep wom. Kem sekenke wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ere etep womke, eme eteri wom tuma eme etep wom. Nema metye, ere maime kena woye, nema sene akeite tame etemri tuma beke kip met. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kaunsil tame akei eme Jisas erne Pailat eterke panen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yim, eme erne tuma namden etep wom. Nema lam, gwote tame ere nemri tatame nogwape emne porere yaper newom. Ere Romri apeilake erne takis kel newote emne wotakem. Sene ere etep wobetem. An Juda etemri apeilake. An Krais, God eter ane wom tame. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Etep womke, Pailat ere Jisas erne etep wometem. Ne Juda etemri kom panen siten apeilake o berai? Ere awosein etep wom. Ye, neren ne etep woye. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailat ere God eteri ake yaku kerebetem tame etemri apeilakeken tatame nogwapeken emne etep wom. Gwote tame ere wule yaper beke wuri nen. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Etep womke, eme tuma me gwungwunen etep wom. Ere tatame emne tuma won tasmol wayem. Eri tuma eme etep metem, eme gavman etemken ei naite nenem. Ere Galili distrikke yin etek yaku tasen yin Judia distrikke yin sene gwotek yan wusoubetem. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat ere etep metem, ere emne etep wometem. Ete tame ere Galili tame o? ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Eme kir ten etep wom. Ye. Pailat ere etep meten abom, Jisas ere apeilake Herot eter lakerebe yekwori tame, eke ere Herot eterke won yim, Herot ere erne tuma namdete. Ete yabel Herot eter ere Jerusalemke temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Temenem, Herot ere Jisas erne lam, ere metekwasem. Kiyi ere Jisas eri nenbetemkap metem, ere erne late wom, Jisas ere rigrabe nenen late wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Etep tem, Herot ere erne tuma nogwape wometem, Jisas ere erne awosein beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Awosein beke wo, God eteri akek yaku kerebetem tame emri apeilake etem, Moses eri wule wusoubetem tame etem eme teten erne tuma kenake namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tuma namdem, Herotken eteri ei nai tameken eme erne workwoyeken resen erne tuma yaper wom. Eme tame oub yenbosubuwai peten Jisas erne warruwun erne won yim, ere Pailat erne sene yin lam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kiyi Herot ere Pailat eterken peiktame temenem, ete yabel epe nowu kerem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","God eteri ake yaku kerebetem tame etemri apeilakeken Juda etemri apeilakeken tatameken etemne Pailat ere won yan wurisubuk tetyewom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ere emne etep wom. Kem ete tame erne panen ane late yawo. Kem etep woye. Ere tatame emne porere yaper newon, emne ei naite wom. An erne keremri bitimik tuma wometlawoiwo. Kem erne namdeye tuma yaper an beke wuri met. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot eter kir ere eri tuma yaper beke wuri met, ere erne won nemne sene late yawo. Kem met. Ete tame ere be wos yaper beke wuri nen, eke nema erne mane pen sate. E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Etepkap an erne pakuwou pen mesginin yite. Etep wom. ( ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nabe nogwape Pasova a abetem yabelke Pailat ere ake yaperke temenem tame wuri won ere komke sene yibetem. E etemri wule, eme etep nenbetem.) ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pailat ere Jisas erne won yite wom, tatame nogwape eme noubke ten etep wom. Jisas erne pen sate. Barabas eterne won sene komke yite. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Kiyi Barabas ere nogwape tameken eme kom panen si tame etemken kom sagke ei nayim, ere tame wuri pen sam. Pen sam, eke eme erne ake yaperke won wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat ere emne etep sene wom. An Jisas erne sene won yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Eme awosein wom. Berai. Erne mek kwuran kwanete. Erne mek kwuran kwanete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Etep womke, Pailat ere tewo mur won emne sene etep wometem. Gwote tame ere wule yaper beke wuri nen. An eri nenem wule yaper beke wuri la, nema erne mane pen sate. Etepkap an erne pakuwouke pen sene won yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Etep wom, eme noubke som tebetem. Erne mek kwuran kwanete. Emri taye Pailat eri tuma ragerkwunbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ragerkwunbetem, ere Jisas erne mek kwuran kwanete tuma kir tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kir tem, ere tatame emri wom tame, Barabas, erne won sene komke yim. Ete tame ere kiyi kom panen si tame etemken ei nayim, ere tame wuri pen sam, eke eme erne ake yaperke won wurim. Pailat ere erne won sene yim, ere Jisas erne peten tatame emne newon etep wom. Kem keremri porerek erne nente. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Eme Jisas erne panen yibetem, eme lam, Sairini tame wuri, eri sig Saimon, ere yan kom sagke wurte yabetem. Wurte yabetem, eme erne keresukun me eme eteri gware luke rasem, Jisas erne semowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Semowum, tatame nogwape eme erne semowum, ta kau eme erne kera keraken semoumenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Semoumenem, Jisas ere emne petkwo lan emne etep wom. Jerusalemri ta, kem ane mane kerate. Kem kerem maime sogwoke kerate, keremri yen etemne kerate. Yuri tame eme emne yaper nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Metye. Yuri akeite yabel tete, tatame eme etep wote. Yen game a ta, yenken berai ta, yen muk beke newon a ta eme metekwaste. Etep wote. Akeite tatame emri yen eme mus mette, eke eme etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ete yabel tatame eme mus eisau mette, eke eme sate abon kow eisau erne etep wote. Ne boken yeirin nemne ragerkerete. Eme kow nebule emne etepwou wote. Kem boken yeirin nemne ragerkerete. Etep wote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","An pap wayebe tame berai, an tame yenbo. Eme ane yaper nenbe. Yuri tame yaper eme kemne yaperwai nente nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Eme akeite tame pes etepne kir panen yim. Epe sir petbetem tame. Eme epne Jisas eterken pen sate wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Won yim, eme kow nebulek yan yawom. Kow sig Tame Tare Bai. Kowke yawon eme erne mek kwuran kwanem. Kwanem, eme sir petbetem tame pes etepne etek kir kwanem. Wuri Jisas eteri let pi seit yekwok tetruwum, wuri let gwaime yekwok tetruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kwanem, Jisas ere etep wom. Apei, ne emri nenbetem wule yaper peten sepitte. Eme emri nenbe wule yaper beke abo. Etep wom, Romri ei nai tame eme etemwou etemwou satu sou tetem, eme eri tame oub wosam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tatame eme teten erne lakerebetem, Juda etemri apeilake eme Jisas erne tuma yaper etep workwoyeken resen etep wom. Kiyi ere akeite tatame etemne kobo labetem. Ere wom, ere God eter won yam tame. Eter seken wote, ere eter maime kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Etep wom, ei nai tame etem kir eme erne tuma yaper wobetem. Eme yan mekinke teten erne kwole yabe ok newom, eme erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ne Juda etemri kom panen sibe apeilake, ne neren maime kobo late. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Basem tuma wuri eme eteri tare iye yekwok peikkerem. Eme etep basem. Gwote tame ere Juda tatame etemri kom panen siten apeilake. Eme etep basem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sir petbetem tame wuri ere Jisas erne tuma yaper etep wom. Ne wom, ne Krais, God eter wom tame. Etepkap ne neren maime kobo late, nesetne kir kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Etep womke, sir petbetem tame wuri ere erne wotaken etep wom. Eme nemne murke pen sate woye. Beke ne God erne beke ak? ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kiyi nesa wule yaper nenbetem, sene nesa mus metbe, e yenbo. Gwote tame ere wule yaper beke wuri nen, eke ere mus bepou metbe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ere Jisas erne etep wom. Jisas, yuri ne kom panen site, ne ane kir abote. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisas ere erne etep wom. An nene sekenke wobe. Gwotepte ne arenken kom yenbok tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yabel komluke simenem, nowsel neirkap teketekeren yam, perpe tebetem, yabel ere sene pasem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yabel sene pasem, mate eisau, God eteri ake eisauke eismenem mate, ere etiya yekwok pekan yeirin kerare kerare tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tem, Jisas ere noubke ten etep wom. Apei, ari wou an neri letke rasye. Etep won ere ek sam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sam, ei nai tame etemri apeilake ere ete wos lam, ere God eri sig eisau wom. Ere etep wom. Ete tame ere tame yenbo sekenwai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Etep wom, tatame nogwape eme etek erne late yan wurisubuk tetmenem, eme lam, ere sam. Etep lam, eme pap yaper ten eme sene yikwutem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yikwutem, Jisas eri nowuken Galilike erne semowun yam taken eme yan gene kerak teten eme ete wos kir lam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tame wuri eri sig Josep, ere Arimatea komri tame. Ere tame yenbowai, ere abom, God ere kom panen site, ere etep koumenem. Ere kaunsil tame etemri wuri, kiyi kaunsil eme Jisas erne pen sate wom, ere kir beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kir beke te, ere Pailat erne yin lan Jisas eri kupa pette erne wolam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wolam, Pailat ere kir tem, eke ere yin Jisas eri kupa neneyeirin peten sen yin mate geipak leyen sele meike rasem. Ete sele mei eme pape purik nenem, kiyi eme tame kupa wuri etek beke ras. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Erne rasem yabel e Pasova a nenbetem yabel. Ege si yabel tete nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilike yam ta, kiyi Jisas eterken yam ta eme Joseph eterken yin sele mei lam. Jisas eri kupa rasem emi eme lam. ");
INSERT INTO yss_yawu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lam, eme emri akek sene yin kwarken bos yenbo yabe wosken eme Jisas eteri kupa kerete eyarem. Eyarem, ege si yabel eme God eteri wule abom, eme etep bepou me sim, eme yaku beke kere. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kwokwos ei berabetemke, ta eme emri kiyi eyarem kwar peten sen selek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yin lam, sele mei ragerem pape ere sele mei ganke temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Etep lam, eme yin wurin eme Aneyen eri kupa lawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lawoyim, eme ep abo ep abom, eme eiksekapke tem. Eiksekap tem, agetage eme lam, tame pes, epri tame oub geipasubuwai labetem, epe mekinke yan tetemenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tetemenem, ta eme etep lan aken selke warem. Selke warem, tame pes epe emne etep wom. Beke kem wouken tame erne sa tame etemri emik sopbe? ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ere gwotek beke te. Ere sene wayen yiwo. Kem ek met. Kiyi ere Galilike temenem, ere kemne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","An Tatame Etemne Lan Yeirim Tame, eme ane tame yaper etepke newote, eme ane mek kwuran kwanen, an ek sate. Sate, yabel mur tetek, an sene wayen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Etep womke, eme Jisas eri kiyi wom tuma sene abopitem, ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","eme sele mei mesginin sene yan ep yekwo let ep yekwo let tewo ges wuri keyem (11-pela) tame emne akeite tameken emne emri lam wos emne wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wusowum ta eme Makdala komri Maria te gwo, Joana te gwo, Jems eteri nawo Maria te gwo. Etem, kau taken etem etep temenem, eme Aposel tame emne ete tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wusowum, Aposel tame eme etep abom. Ta eme tuma bepou me yikwokwobe. Etep abom, eme emri tuma kenawaike beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Etep tem, Pita ere wayen teten sele meike amen yim. Yim, ere gwuromun nerewurin lam, Jisas eteri matewou sele meike temenem. Etepwou temenem, ere akek sene yibetem, eri lam wosken eri metem tumaken ere ep abo ep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ete yabelke tame pes epe etemri tame tep Jerusalem gene kerak tetan kom nebulek yibetem. Kom sig e Emeus. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yibetem, Jisas eterne pem tuma epe eteke namden yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Namden yibetem, Jisas ere yan epne semowun etepken kir yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Eme ete tuma namden yibetem, epe Jisas erne lam, epe erne beke noub la. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Epe noub beke la, ere epne etep wom. Kep yibe, kep be tumake namdebe? Etep womke, epe pap yaper meten makemake ten tetem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Makemake ten tetem, tame wuri, eri sig Kliopas, ere awosein etep wom. Ete kom tame nogwape eme yan Jerusalemke tetan, yekik tem wos eme kir lam. Nerenwou yekik tem wos ne beke la o ne beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jisas ere etep wometem. Be woske tem? Epe sene etep wom. Nasaret komri Jisas eterne eme pemkap, nesa eteke namdebe. Ere yaku eisau kerebetem, nemne tuma yenbo wosoubetem. God eter, tatame etem eme erne tame yenbo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","God eri akeri apeilake, nemri apeilake eme erne apeilake Pailat eterne panen yin tuma namdem, eme erne pen sate namderasem. Namderasem, eme erne mek kwuran kwanem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ete tame, kiyi nema etep abom. Kap tame ere Israel tatame emri apeilake ten emri peiktame emne teitkwunte. Etep abom. Eme erne yekik pem, gwopte yabel mur woye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Gwopte nema nemri ta kau emri woye tuma metye, nema wouken akye. Ei berabeteyek, eme selek yiwo, ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","eme Jisas eri kupa lawoiwo. Lawoiwo, eme sene yan nemne etep woye. Nema God eri kom tame pes laye. Epe nemne etep woye. Jisas ere wou sene petye. Ete ta epe etep woye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Etep woye, nemri tame tep eme selek yiwo, eme ete ta epri woye wos laye. Eterne eme beke la. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jisas ere epne etep wom. Kep porere berai. Kiyiri tuma wusoubetem tame emri tuma kep beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kap kep beke met, Krais, God eter won yam tame, ere mus kiyi mette, yuri ere kom yenbok sene yin tete. Etepkap ete tuma ere sekenwai tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Etep wom, Jisas ere Moses eri bas rasem tuma etek tasen, God eteri kiyiri tuma wusoubetem tame etem bas rasem tumaken ere epne noub maime wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Eme yin emri kom mekin mekinmenem, Jisas ere keranabu kere yite wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sene yite wom, epe erne wotaken etep wom. Ne nesetken gwotek tete. Yabel warbe, neir teketen yabe. Ere wurin etepken tem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ten eme a ate wom, Jisas ere etepken sin ere bret peten God erne pir won pekayewon epne newom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Newom, epe erne kuyese noub lam. Lam, ere agetage etek pekan yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pekan yim, epe etepwou etepwou kena namden etep wom. Nema keluke yawo, ere nesetne God eri basem tuma somo nesne wusouye, nesetri pap yenbo metye. Epe etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Epe agetage Jerusalemke sene yim. Yin lam, ep yekwo let ep yekwo let tewo ges wuri keyem (11-pela) anepoi tame, akeite tameken eme wurisubuk simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Simenem, eme etep wom. Sekenwai. Aneyen ere selek sene wayewo. Saimon ere erne laye. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Etep womke, epe emne ete tuma wusowum. Epe Jisas erne keluke lan akek panen yim, ere bret peten pekayewomke, epe erne etek noub lam, epe emne etep wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Epe emne ete tuma wusobetemke, eme lam, Jisas ere etemri borborke me pamnen ere emne pir wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pir wom, eme wouken akem, eme etep abom. Kap nema gaboke labe. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ere emne etep wom. Beke kem ep abo ep abobe? Beke kem pap pes teye? ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kem ek la. Ari letken tewoken kem la. Gwo aren. Kem ane let kerelate. Ek la. An wusomken. Gabo etem eme wusomken berai. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Etep womke, ere eri letken tewoken emne peteram. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Peteram, eme bepou me metekwasem, eme erne kenawaike beke noub abo, eme ep abo ep abobetem. Kap Jisas eter o? Etep ten ere emne eke wolam. Kem awos tetan o? ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Eme erne emri lisem omyen tep newom, ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ere peten etemri bitimik am. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ere emne etep wom. Kiyi an keremken temenem, an kemne ete tuma wusoubetem. An etep wom. Tuma nogwape eme kiyi basem, ete tuma ere sekenwai tete. Moses eteri siglouri tuma, Devit eteri siglouri tuma e yuri sekenwai tete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Etep womke, eme meten God eri basem tuma noub metem. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Noub metem, ere emne etep wom. Siglouri tuma etep wobe. Krais, God eter yaku newom tame ere mus eisau mette, yabel mur tete, ere sene wayete. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Sene wayete, tatame eme Krais eteri murek tuma wusoute. Eme Jerusalemke kiyi wusoutek, yuri eme kom nogwapeke yin etep kir wosoute. Kem kemri wule yaper mesgintek, God ere kemne ek gerute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kem lam woskap kem etepke yin wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Apei ere kiyi kemne newote namderasem wos an kemne newote. Kem gwote kom sagke koute, ete mure ere Heven mesginin keremne yate. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ere etep womke, ere emne Betani kom mekinke panen yim, ere eri let nenewayen tuma yenbo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tuma yenbo emne wobetem, God ere erne peten ere God eteri kom Hevenke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yim, eme eri sig eisau wom, eme letewo oksubuwai ten eme Jerusalemke sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yim, kwokwos kwokwos eme God eri ake eisauke yin wurin God erne pir won erne tuma yenbo wobetem. Luk ere bas rasem tuma ere ab eteke. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kiyisapewai nelken nowselken mak temenem, God eteri tuma ere temenem. Ete tuma ere God eterken temenem. Jisas Krais eter ere tuma. Eter ere God. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kiyisapewai Krais ere God eterken temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Eter womke, akeite wos ek tem. Be wos bepou beke te. God eter wom, Krais eterwou ere akeite wos ek seikim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ere sene womke, tatame eme noub som temente wule ek tem. Sene womke, tatame eme porere yenbo pette wule ek tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ete porere yenbo newobe tame ere tukap kerebe tame. Wule yaper nenbe tatame eme kerneirik tetan. Eme tukap kerebe tame erne worpulawoibe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God ere tame wuri erne won yam, eri sig Jon. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Won yam, ere tuma wusoute yam. Tukap kerebe tame eterne ere tatame emne eteri tuma wusoute yam. Ete tuma mette tatame eme Jisas erne kenawaike abote, eme porere yenbo ek pette, eke ere emne wusoute yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon eter ere tukap kerebe tame berai. Ere tukap kerebe tame eteri tuma wusoute yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jisas eter ere tukap seken. Ere tatame emne porere yenbo newobe tame. Eter ere nowselke yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kiyi God ere wom, Krais ere nowselken tatameken seikim. Yuri ere yan tatame etemken temenem, eme erne mak metmenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ere kantri Israelke yam, Juda tatame eme erne pap beke yewo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kau eme erne pap yewom. Ete tatame eme erne kenawaike abobetem, God ere emne etep wom. Kem ari yen. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ete tatame eme God eteri yen bepou beke te. Nawo te yen warwibekap eme God eteri yen beke te. Sir bisi yibe wulek eme God eteri yen beke te. Anenawo epri porerek eme God eteri yen beke te. Berai. God eteri porere selpapke eme eteri yen seken tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","God eteri tumakap tame, Jisas, ere nowselke yam, ere neremken temenem. Temenem, eri wusom neremri wusomkap tem. God eteri mure Jisas eterken temenem, kobo labe wule seken eterken temenem. Nema eteri mure eisau lam, nema metem, ere Apei God Eteri Yen wurisubu. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ere Jisas erne abon ere tatame nogwape emne wusowun etep wom. Nawoi te ane kiyi warwiyim. Tame wuri eri nawo te erne yurik warwiyim. Kiyisapewai ete tame ere Hevenke temenem, etepkap an erne ari Aneyen wobe. Jon ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jisas ere kobo eisau labe tame, eke ere nemne kwokwos kwokwos yenbowai nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","God eteri wule ep yekwo let ep yekwo let ere Moses erne newom, Moses ere ete wule tatame emne newom. God eteri kobo labe wule, eteri tuma seken Jisas Krais eter ere nemne newom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Eike tame wuri ere God erne beke la. God Eteri Yen ere God eterken tetan, eke eter ere Apei eri tebekap nemne noub wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda tame eme God eri akek yaku kerebetem tameken Livai tameken emne won yim, eme Jerusalem mesginin Jon erne wolate yim. Eme yin Jon erne etep wolam. Jon, God eter nene won yam o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Etep womke, Jon ere tuma rebe beke te, ere genik awosein etep wom. God eter wom tame Krais eter ere tatame emne sene pette. An eterkap berai. Ari yaku kena. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eme erne sene wometem. Ne eike? Ne Elaija, God eteri kiyi temenem tuma wusoubetem tame o? Ere awosein etep wom. Berai. An Elaija berai. Eme erne sene wometem. Nema God eteri tuma wusou tame erne kouten. Ne eter o? Ere sene etep wom. Berai. An akeite tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eme erne sene wometem. Ne eike? Nemne won yam tame emne nema yin mapeke awosein wote? Etepkap ne neri tebekap nemne noub wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ere emne awosein etep wom. God eteri tuma wusoubetem tame, Aisaia, eter womkap, an etep nenbe. An tameken berai emik nubke etep wote. Kem Aneyen eri yate nenbe kelu noub eyarte. Jon ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ete tame, Farisi tame eme emne won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Eme erne sene wometem. Ne woye, ne God eter wom tame berai, ne Elaija berai, ne God eteri tuma wusoube tame berai. Etep woye, etepkap beke ne tatame emne baptais ok wirube? ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ere emne sene etep wom. An tatame emne okke wirube. Ari kerebe yaku e eisau berai. Tame wuri keremken tetan, kem erne beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ere eri yaku taste. Ere tame eisau, ere tame yenbo, nesa situk wurik beke kip si. An yen nebulekap, an selke site. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Eme Betani komke temenem, eme etepke namdem. Betani kom e Jordan peik keraruke tetan. Jon ere tatame emne etek baptais ok wirubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kwokwos Jisas ere keluke yabetem, Jon ere erne lan etep wom. Kem ek la. Ete tame ere God eterne kwar pete nenbe sipsip yen. Tatame eme God erne kwar pelawoibetem, Jisas ere nowselri tatame emne kobo lan wule yaper peten sepitte. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ete tame kiyi an kemne etep wom. Ari nawoi te ane kiyi warwiyim, tame wuri eri nawo te erne yurik warwiyim. Kiyisapewai ere Hevenke temenem, eteke an erne ari Aneyen wobe. An etep kiyi wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aren an erne kiyi beke met. Tatame eme ete tame erne noub mette, eke an yan Juda tatame emne baptais ok wirubetem. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon ere sene etep wom. An etep lam, God Eri Wou ere Heven mesginim, ere ap bourkap ten yan yeirin Jisas eterke yan sim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","An erne mak noub lamenem. Mak noub lamenem, God ere ane wom, tatame emne baptais ok wirute wom. Wom, God ere ane etep wom. Ari Wou ere Heven mesginin tame wuri eterke yeirin site. Ete tame ere Ari Wou tatame emne newote. Ere ane etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","An etep lam, eke an kemne wobe. Ete tame ere God Eteri Yen seken. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kwokwos Jon ere eteri anepoi tame pesken eme etek sene temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Temenem, Jisas ere yabetem, Jon ere erne lan etep wom. Kem ek la. God eterne kwar pete nenbe sipsip yen ere e. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jon eteri anepoi tame pes epe etep metem, eke epe Jisas erne semowun yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Semowun yim, Jisas ere epne petkwo lam, epe erne semoumenem, eke ere epne etep wometem. Kep beke yabe? Epe erne awosein etep wom. Rabai, ne ma akek tetan? Rabai sig tuma somo e Tuma Wusoube Tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ere epne etep wom. Kep yan late. Etep womke, epe yin eri temenem ake lam. Epe perpe yabelke yin lan eterken etek sin teketem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tame pes epe Jon eteri wom tuma meten Jisas eterne semowun yim, wuri eteri sig Andru. Ere Saimon Pita eteri mase. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Agetage Andru ere yin lake Saimon erne yin lan etep wom. Nesa akeite tameken nesa God eter wom tame Krais erne laye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Etep womke, Andru ere Saimon erne panen Jisas erne yin lam. Jisas ere Saimon erne lan etep wom. Ne Saimon, Jon eteri yen. Yuri nema neri sig Sifas wote. Etep wom. Juda tame etemri tumak eme Sifas wobe. Grik tuma Pita wobe. Sig somo e Pape. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kwokwos Jisas ere Galili distrikke yite wom, ere Filip erne lan etep wom. Ne arenken yite. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip ere Betsaida komri tame, ere Andruken Pitaken etepri kom tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Sene Filip ere Nataniel erne sopen yin lan erne etep wom. Kiyi Moses ere Juda wule siglouke bas rasem. God eter wom tame ere eterne bas rasem. Kiyi temenem tuma wusoube tame etem kir eme siglou bas rasem. God eter wom tame eme eterne bas rasem. Ete tame nema erne laye. Ere Nasaret komri tame, ere Jisas, Josep eteri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel ere erne etep wom. Nasaret e kom yaper. God eter wom tame, Krais ere ete komke beke kip te. Filip ere erne awosein etep wom. Neren epe yan la. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisas ere lam, Nataniel ere yabetem, ere erne etep wom. Ek la. Israelri tame yenbo ere yabe. Ere tuma wuri beke yikwokwo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Etep womke, Nataniel ere erne etep wometem. Ne ane mapeke metten? Ere erne awosein etep wom. Kiyi Filip ere nene mak woye, ne yipyokwo somok simenye, an nene laye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Etep womke, Nataniel ere erne awosein etep wom. Tuma wusoube tame, ne God Eteri Yen. Ne Israel kom panen site nenbe apeilake. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisas ere erne awosein etep wom. An nene epke woye. Ne yipyokwo somok simenye, an nene etek laye. Etep woye, eke ne ane agetage kenawaike aboye. An nene etep woye, ete wos nebule. Yuri ne ari mure eisau ek late. ");
INSERT INTO yss_yawu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","An kemne sekenke wobe. Yuri kem late, nel erukap lat raste, kem late nenbe, an Tatame Etemne Lan Yeirin Tame, God eteri kom tame eme ane lan yau yeirbetete nenbe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yabel pes tem, mur womke, tame wuri ere ta panem. Galili distrikke temenem kom Kana etek panem. Jisas eteri nawo te ta panen simenem akek yin temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Eme Jisas erne kir wopetem, ere eri anepoi tameken, eme ta neiste nenem awos ate yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yam, tatame nogwape eme sin abetem, wain ok omom. Ok omomke, Jisas eri nawo te yan erne etep wom. Emri wain ok omoye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ere tene wotaken etep wom. Nawoi, beke ne ane etep wobe? Yurik an eisau wos nente, gwopte berai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Etep womke, te a nenbetem tame emne etep wom. Jisas ere kemne beke nente wote, kem etep nente. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Juda emri wule eme let ok keyabe, eme etepke abobe, God ere nemne metekwasen nemri wule yaper peten sepitbe. Etep abobetem, eke ete akek tukmenem ou eisau ep yekwo let ep yekwo let ges wuri kei (6-pela) eme etek tukmenem. Tatame eme ok tin let ok keyabetem, eke eme etek tukmenem. Ete ou eisau eme ok nogwape, 100 lita, tin sen yan siren pelaubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Etek tukmenem, Jisas ere awos nenbetem tame emne etep wom. Kem ete ou ep yekwo let ep yekwo let ges wuri kei (6-pela) etek tukten ou, kem ok tin sen yan etek siren pelaute. Etep womke, eme yin ok tin sen yan siren pelawom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Etep tem, ere emne sene etep wom. Ware wuri kem peten ete ok tin sen awos lakerebe tame erne newon taklate. Etep wom, eme ware wuri peten ok tin sen yin newom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Newom, awos lakerebetem tame ere ete ok taklam, ete ok ere wain ok seken tem. Emri ok tim emi ere beke la. Ok tim tame etem eme lam. Taklam, ere ta panem tame erne wopetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Wopetem, ere erne etep wom. Neri yurik newoye wain ok e yenbowai. Tatame nogwape eme etepkap beke nen. Eme pap mame berai, etepkap eme kel eisauke tukbe wain ok kiyi newopit peteyabe. Tatame eme ete wain ok nogwape an sisi pebe, yuri eme kel nebulek tukbe wain ok emne sene ek newon abe. Ne etepkap beke nen. Neren ne kel eisauke tukem wain ok yuri sen yan nemne newoye. Ne etepkap nenye, e yenbo. Ne pap mame tame. Ere erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ete yabel Jisas ere rigrabe tasen nenem. Ere Galili distrikke tetan kom Kanak temenemke, ere ete wos nenem. Etep nenem, ere eri mure tatame emne peteram. Eri anepoi tame eme eri mure lam, eme erne kenawaike abobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Etep tem, ere Kaperneam komke warem. Waremke, eteri nawoken maseken eteri anepoi tameken eme kir etep warem. Yabel kau eme ete kom sagke temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda etemri Pasova awos eisau ate yabel mekin mekinemke, eke Jisas ere Jerusalemke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yim, ere God eteri ake eisauke wurin lam, tame nogwape eme kel pet yaku etek kerebetem. Eme kwar pebe bulmakauken sipsipken apken eme etep sen yan rasen tatame eme tukbetem. Kau eme tiyke sin akeite nowselri tame etemken kel natokwo kerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Etep lam, Jisas ere nuglei peten emne nuglei sekenak pe wurbeten won yim. Sipsipken bulmakauken emne kir won yim. Natokwo kerebetem tame eme kel rasbetem tiy ere peten legalepitin kel eme selke akei panbelapitim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ere ap kel petbetem tame emne kobkob etep wom. Kem seki. Gwote ake e ari Apei eteri ake. Gwote akek kem kel mane natokwo kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Etep womke, eri anepoi tame eme God eri bas rasem tuma wuri sene abom. Bas rasem tuma etep wobe. Apei, nereri ake an metekwaswaibe, eke an yaku eisau keren yin mus meten sate. Etep wobe. Eme etepke abom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Juda tame eme Jisas eteri temkap lan erne etep wolam. Nene eike woye, eke ne emne won bokye? Ne nemne rigrabeken mureken peterate, nema nene tuma beke kip namde. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ere emne awosein etep wom. Kem God eteri ake eisau berayewote, yabel murke, an sene kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Juda eme etep wom. Gwote ake eme kerem, nabe nogwape (46) eme gwote yaku kerebetem. Yabel mur ne kuyese sene beke kip kere. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisas ere God eteri ake eisau wom, ere eter maimeke abon eke wom. Yuri ere sate, yabel mur tete, ere sene wayete, ere etepke abom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yuri God ere Jisas erne wou sene newom, Jisas eri anepoi tame eme eri wom tuma sene abom. Sene abom, eme God eteri siglouke basem tuma worworke abom, eme Jisas eter wom tuma kir kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Juda etemri Pasova awos eisau abetem yabel Jisas ere Jerusalemke temenem. Etek temenem, ere rigrabe nogwape nenbetem. Nenbetem, nogwape tatame eme etep lam, eme erne kenawaike abobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Abobetem, ere emri selpap kuyese labetem, ere abom, ete tatame eme erne bepou me abobetem. Yuri eme erne sene mesginte. Eike tatame wuri erne beke wusou. Berai. Eter ere etemri porere selpap lam, eke ere emri tuma som beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tame wuri eri sig Nikodemus, ere Farisi tame. Ere Juda etemri apeilake tame wuri. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ete tame ere Jisas erne neirke yin lan etep wom. Tuma wusoube tame, nema metem, God ere nene won yam, ne nemne tuma wusoube. Ne rigrabe nenbe, etepkap nema metem, God ere nerenken tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisas ere erne awosein etep wom. An nene sekenke wobe. Tatame eme porere selpap ager beke kip pet, eme God eri komke beke kip yi. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus ere erne awosein etep wom. Tame ere keryen tebe, mapeke ere sene porere ager pette? Ere keryen tebe, nawo te erne sene mapeke warwiyin, ere porere selpap ager pette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas ere erne awosein etep wom. An nene sekenke wobe. Tatame eme okke ager beke te, eme God Eteri Wou beke kip pet, eme God eteri komke beke kip yi. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ta te yen warwite, ere nowselri tame tete. God Eteri Wou ere tatame etemken gulelete, eme porere yenbo pette, eme God eteri yen tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","An nene woye, ne porere selpap ager pette. Ne etep mette, ne mane wouken akte. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Poli ere eteri porere akeite akeite emik yibe. Ne poli ken metbe, ne beke la, ere mak yibe o mak yabe. Etepkap, God Eteri Wou ere akeite akeite tame emne gulelebe, eme porere selpap ager sene petbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus ere Jisas erne etep wom. Ete tuma somo ere mapkap? ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisas ere erne awosein etep wom. Ne Israel etemri tuma wusoube tame wuri. Mapeke ne tuma somo beke met? ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","An nene sekenke wobe. Nemri metbe wos, nemri labe wos nema etep wusoube. Wusoube, kem som beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nemri nowselke labe wos an kemne etep wusoube, kem kenawaike beke abo. Eke Hevenke tetan wos an kemne wusoute, kem kenawaike mapeke abo? ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Eike tatame eme God eteri komke mak yiten. An Tatame Etemne Lan Yeirim Tame, arenwou an God eteri komke temenem, an ete kom mesginin yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kiyi Moses ere tameken berai emik temenem, ere ainke nenem sopo mek peiken nenewayen paruwum. Nenewayen paruwum, rekebuk tatame eme eteke labetem, eme beke sa, eme sene yenbo tebetem. Etep tebetem, an Tatame Etemne Lan Yeirim Tame, eme ane etep tete, eme ane mek nenewayen yeworute. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Etep tete, tatame eme ane kenawaike abote, eme yaper beke kip te, eme noub som temente. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God ere gwote nowselke tetan tatame emne pap noub yewom, ere Eteri Yen wurisubuwai erne won yam, ere gwote nowselri tatame emne kobo lan sam. Sam, tatame eme erne kenawaike abote, eme yaper beke kip te, eme som noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God ere Eteri Yen erne won yam, ere tatame etemne tuma namde beke ya. Ere emne sene pette, eme som noub tete eke yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tatame eme erne kenawaike abote, God ere emne tuma beke kip namde. Tatame eme God Eteri Yen wurisubu eri sig kenawaike beke abo, God ere emne tuma eisau kiyi namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tukap kerebe tame ere gwote nowselke yam. Yam, tatame nogwape eme yaper nenbe, eme kerneirik tetan. Eme tukap kerebe tame erne mo wobe, eke God ere emne tuma namdem. Yuri ere emne awosein yaper nente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wule yaper nenbe tatame eme etepke abobe. Wule yaper nema kom genik mane nente, tatame eme nemne late wurken. Eke eme tukap kerebe tame erne mo won erne amekwunbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wule yenbo seken nenbe tatame eme tukap tobukbe tame erne kenawaike abobe. Eke tatame eme emne labe, emri nenbekap e God eter womkap. Eme etep labe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yuri Jisas ere eri anepoi tameken eme Judia distrikke yim, yabel kau ere etemken etek temenem, ere tatame emne baptais ok wirubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon ere kir ere tatame emne Ainon komke baptais ok wirubetem. Ainon kom e Salim kom mekinke tetan, ok nogwape etek tetan. Eke ere emne etek baptais ok wirubetem. Tatame eme etek yabetem, ere emne baptais ok wirubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Apeilake tame, Herot, ere Jon erne ake yaperke mak won wurmenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Juda tame wuri ere Jon eteri anepoi tame emken ei nakwosem. Eme ok wirube wule ei nakwosem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nakwosem, sene eme Jon erne yin lan etep wometem. Tuma wusoube tame, kiyi ne nemne Jisas eterne wusoubetem. Ere kiyi neremken Jordan peik keraruke temenem. Eter kir ere tatame emne baptais ok wirube. Tatame nogwape eme eterke yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon ere awosein etep wom. Hevenke tetan God ere Keryen. Ere wote, tatame eme eterke yite. Ere etep wote, eme yite. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","An kemne kiyi wom tuma kem metem. An etep wom. An God eter wom tame berai. God ere ane won an kiyi taresin yam, an eteri tuma kiyi wusoute yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Metye. Tame ere ta panebe, ta te eteri akek yin tebe, te erken tuma etep namdebe. Ta panebe tame eri nowu ere erken sene beke namde, ere teten lakerebe. Ere ta panebe tame erne labe, eri tuma metbe, ere metekwaswaibe. Nowu ere metekwasbekap, an etepke metekwasbe. Tatame nogwape eme Jisas erne yin lan eterken tebe, an metekwasbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jisas eri sig eisau tete, ari sig nebule tete, an etep abobe. Jon ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","God eteri komke yam tame ere apeilake eisau. Akeite apeilake eme nebule. Nema nowselri tatame, nema nowselri wos abon wusoube. God eteri kom mesginin yam tame, ere tame eisauwai. Ere nowselri tame emne teitkwunten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","God eri komke lan metem wos ere wusoube, tatame eme eri tuma kenawaike beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Eike tame eme Jisas eri tuma worwor metbe, eme etep wobe. God ere tetan. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","God eter won yam tame ere God eteri tuma wusoube. Eterne God ere Eteri Wou, eri mure eisau erne newom, ere God eteri murek noub wusoube. God ere papmame tame, ere newobe wos ere nogwape newobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Apei ere Eri Yen erne som abobe. Ere erne wom, ere akei nowselri tatame nemne panen site wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tatame eme Eteri Yen erne kenawaike abote, eme som noub temente nenbe. Tatame eme eri tuma kenawaike beke kip abo, eme som noub beke kip te. God ere emne pap kenake wayebe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisi tame eme metem, tatame nogwape eme Jon eteri tuma worwor meten ere emne baptais ok wirubetem. Sene eme metem, tatame nogwapewai eme Jisas eri tuma worwor meten ere emne baptais ok wirubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jisas eter ere tatame emne baptais ok beke wiru. Eteri anepoi tame etem eme emne baptais ok wirubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jisas ere metem, Farisi eme ete tuma metem, eke ere Judia distrik mesginin Galili distrikke sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yim, ere yibetem kelu e Samaria distrik borborke yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ere yim, ere Samaria distrikri kom wurik yim. Ete kom sig Sikar. Kiyi temenem tame, Jekop, ere eri yen Josep erne newom sel ete kom mekinke tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kiyi Jekop ere perem ok tibetem okmoi ere ete emik tetan. Yabel komluke simenem, Jisas ere kelu geneke yam, eke ere wus lumken temke, ere yan ete okmoi barke ege etek sim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Eri anepoi tame eme kom sagke awos tukte yimenem, eke Jisas ere ege simenem. Samaria ta wuri te ok tite yam, Jisas ere tene etep wom. Ne ane ok kera tin newon an kelpok ate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Te erne awosein etep wom. Ne Juda tame. An Samariari ta. Mapeke ne ane kelpok wometbe? Te etep wom. Juda emri wule gwokap. Juda tatame eme Samariari tatame emken a wurik beke a. Eke te erne etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisas ere tene awosein etep wom. An nene ok wometye, ne ane beke met. God ere tatame emne yenbo nenbe wule, ne beke met. Ne ane metmente, ne arene wouken ok womette. Womettek, an nene wouken ok newon ate, ne noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Te erne etep wom. Aneyen, ne ok ti ware berai. Gwo okmoi ok uwoiwaike tetan. Tatame som noub temente ok ne mak tite? ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nemri warege, Jekop, ere gwo okmoi peren nemne mesginim. Eter, eri yen etem, eri bulmakauken etem eme gwote okmoi abetem. Kap ne warege Jekop erne me teitkwunten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ere tene awosein etep wom. Tatame eme gwo kelpok ate, yuri eme sene wak sok tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Metye. Tatame eme aren newobe ok ate, yuri eme wak sok sene beke kip te. Sene eme pap yenbo som metbetete. An emne newote ok e som me sekbe okkap. Eme ate, eme pap yenbo meten eme noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Etep womke, te erne etep wom. Aneyen, ne ane ete ok newote. Yuri an ok sene beke kip sop, an gwo okmoi ok sene beke kip yan ti. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ere tene etep wom. Ne yin neri tame erne won erne panen ya. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Te awosein etep wom. An tame berai. Ere tene etep wom. Neri wobe tuma e seken. Ne tame berai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Neri kiyi atukum tame eme ep yekwo let. Nerenken tetan tame ere nereri tame seken berai. Ne etep woye. An tame berai. E sekenwai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Etep womke, te sebera yan erne etep wom. Aneyen, an aboye, ne God eteri tuma wusoube tame. An nene tuma wuri womette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nema Samaria tatame, nemri yeiwarege eme gwok tetan kowke yawon God erne etek sukye worabetem. Kem Juda kem wobe. Tatame eme Jerusalem komke yin God erne etek sukye worate. Beke kem etep wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ere tene sene etep wom. Ne ari tuma kenawaike metbe. Yuri kem gwote kow sene beke kip yawon, Apei erne sukye wora. Kem Jerusalem beke kip yin sukye wora. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kem Samaria distrikri tatame, kem kemri sukye worabe tame erne noub beke met. Kem bepou me sukye worabe. Nema Juda nema nemri sukye worabe God erne noub metten, nema erne sukye worabe. Aren an Juda tame. God ere ane wom, an nowselri tatame emne sene pette, eme yenbo tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Apei ere abobe, tatame eme porereken wule seken erne sukye worate. Ere etepkap tatame emne sopbe. Epkap tatame eme God erne noub sukye worate yabel mekin mekinye. Gwopte eme etep nente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God ere wusomken berai, wou eterwou ere tetan. Eke erne sukye worate tatame nema erne sekenwai wouken erne sukye ek worate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Te erne etep wom. God eter wom tame nema erne Krais wobe, ere yate nenbe, an etep metten. Ere yate, ere nemne wos nogwape peterate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ere tene etep wom. Eike nerenken tuma namdebe tame, aren, an Krais. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Eri wobetem tuma tepken, eri anepoi tame eme sene yam. Yan lam, ere ete ta teken tuma namdebetem, eme ep abo ep abom. Emri wuri tene beke etep womet. Ne be woske wometbe? O emri wuri erne beke etep womet. Beke ne teken tuma namdebe? Eme etep beke womet. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Etep ten te teri ok tibetem gin etek mesginin te kom sagke sene yin komri tatame emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Kem epe yan la. Tame wuri ere ari kiyi nenbetem woskap ane akei wusouye. Ere kap eike? Kap God eter won yate wom tame o berai? ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Etep womke, kom tatame eme etep metem, eme kom sag mesginin erne late yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Te tatame emne wote yimenem, Jisas eri anepoi tame eme erne etep wom. Tuma wusoube tame, ne awos a. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ere emne etep wom. Ari tetan awos kem beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Etep womke, anepoi tame eme etemwou etemwou namdelan etep wom. Kap erne tame wuri ere a sen yan newoye o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ere emne etep wom. Ari Apei ere ane won yaku kerete wom. Ari a gwopkap. Ane won yam tame eter abobekap an etepke kerete, ere ane newom yaku an keren omote. E aren abe akap. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kau tame eme etep wobe. Lup epe pes epe pes omote, nema kwoi ek perte. Aren an kemne etep wobe. Kem yin now lan sewurte. Kwoi eme okwon site, kem yin kwoi perte. Etep wom. Eteri wom tuma somo gwopkap. Kem mane etep wote. Nema God eteri yaku yuri kerete. Etep mane wote. Kem epe yin la. Nogwape tatame eme Jisas erne kenawaike abote nenbe, kem yin kenawaike abobe wule emne wusoute, eme kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","God erne kenawaike abobe wule wusoube tatame God ere emne yenbo awosein nenbe. Eke kenawaike abobe tatame eme yenbo som temente. Kwoi perbe tatameken kwoi berbe tatameken eme metekwasbekap, tatame emne kiyi wusowum tatameken emne yuri wusowum tatameken eme kir etepke metekwasbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kau tame eme etep wobe. Tame wuri ere kwoi berbe, akeite tame wuri ere kwoi perbe. Ete tuma e seken. An kemne wobe. Tame wuri ere ari tuma kiyi yin wusoube. Sene akeite tame ere tuma kupa sene wusoube, tatame eme meten kenawaike abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","An kemne won yibe, kem akeite tame eri berem kwoi kem yin perte. Akeite tame eme yaku eisau keren eme kwoi berem. Sene kem ek yin emri berem kwoi kem perbe. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria kom sagri tatame nogwape eme ete ta teri tuma metem. Te emne etep wom. Jisas ere ari kiyi nenbetemkap ane maime wusowun omoye. Etep womke, tatame eme erne kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Etep tem, Samaria tatame eme yan ere etemken temente, eme erne etep noub wobetem. Wobetemke, yabel pes ere ete komke temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Temenem, sene tatame nogwape eme eri tuma noub metbetem, eme erne kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kenawaike abom, eme ete ta tene etep wom. Nema neren wom tumawou beke kenawaike meten ete tame erne kenawaike abo. Berai. Ere wom tuma nema neremri wanke metem. Etepkap, nema wobe, ete tame ere nowselri tatame etemne sene petbe, eme yenbo tebe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yabel pes tem, Jisas ere Samaria distrik mesginin Galili distrikke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Eter ere kiyi etep wom. Tuma wusou tame emri maime komri tatame eme emne yenbo beke wo, eme emne magel taibetem. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galili distrikke yim, Galiliri tatame eme erne pap yewom. Kiyi ete tatame eme Pasova awos Jerusalemke ate yim. Yim, Jisas ere awos abetem yabelke nenemkap, eme akei lam, eme metekwasem. Eteke, ere emri komke yam, eme erne pap yewom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ere Galili distrikke tetan kom Kanak yim. Kiyi ere etek temenem, ere womke, kelpok ere sene wain ok seken tem. Etek yim, ete komri apeilake eri yaku kere tame eri yen ere kapoyi eisau meten temenem. Yen ere Kaperneam komke temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Temenem, ete yaku kere tame ere metem, Jisas ere Judia distrik mesginin Galili distrikke yam, ere erne yin lan erne noubwai wometbetem. Areri yen ere sate nenbe. Ne Kaperneamke yin erne eyarte. Etep wometbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ere awosein etep wom. An akeite akeite rigrabe beke kip nen, etepkap kem ane kenawaike beke kip abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Apeilake ere erne etep wom. Aneyen, ne arenken yite. Ari yen sate wurken. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisas ere erne etep wom. Ne epe yi. Nereri yen ere beke kip sa. Etep wom, ete tame ere Jisas eri tuma kenawaike abon ek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yimke, kwokwos ere yibetemke, eri yaku kerebetem tame eme erne keluke yan lan etep wom. Neri yen ere yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ere emne etep wometem. Ere makapke yenbo tem? Eme erne awosein etep wom. Yere ere yaper metmenem, yabel pikeren sepiteyabetem, ere yenbo ek tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Etep womke, ar ere abopitim, ere yere yabetemke, Jisas ere etep wom. Yen ere beke kip sa. Etep abopitim, eke ere eteri yentaken eme Jisas erne kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas ere Judia distrik mesginin Galili distrikke yan temenemke, ere ete yen erne eyarem, e eteri tewo pes nenem rigrabe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yuri Juda etemri ege si yabel eisau tete nenbetemke, Jisas ere Jerusalemke yin yawom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem kom ser eisau pemenem. Ete ser eri eru eme etep wobe. Sipsip Eru. Ete eru okmoi wuri etek mekin temenem. Okmoi sig eme Hibru tumak etep wobe. Betesda. Okmoi bar ege sibe ake ep yekwo let etek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ete ake nogwape let nai tewo nai tame eme etek simenem. Kau eme le si tame, kau eme tewo yaper tame. Kau tewo bor kupakap temenem tame, eme ete akek tuknan ok lakerebetem. Lakerebetem, sene ok ere lom teseite, eme eke koumenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yabel kau God eri komri tame wuri ere okmoike yeirin ok lom saberbetem, kiyi taresin warbetem tame ere kapoyi yenbo tebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tame wuri ere etek tuknan koumenem, erne nenbetem kapoyi nabe nogwape (38) erne metbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nabe nogwape ere etek tuknan koumenem. Jisas ere etep lam, ere erne wometem. Ne sene yenbo tete abobe o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kapoyi kei tame ere erne awosein etep wom. Aneyen, ok lom teseite, ane eike tamek ane peten okke panen warte? Aren an warte abobe, akeite tame eme kiyi agetage warbe, an warte nenlawoibe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisas ere erne etep wom. Ne epe wayen teten neri tukna wos peten sen yi. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Agetage ete tame ere yenbo ten ere eri tukna wos peten sen akek yim. Etep tem yabel e Juda etemri ege si yabel, eke ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Juda eme etep lam, eme pap wayen eme yenbo tem tame erne wotaken etep wom. Gwopte ege si yabel. Ne tukna wos mane peten sen yite. Ne etepkap nenbe, ne nemri wule tousibe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ere emne awosein etep wom. Arene eyarye tame eter ere ane woye, eke an tukna wos sen yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Eme erne etep wometem. Eike nene woyeke, ne neri tukna wos peten sen yibe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yenbo tem tame ere awosein beke wo. Ere Jisas erne beke noub la. Sene ere erne soplawoyim. Tatame nogwape eme etek temenem, eke Jisas ere yim kelu, ete tame ere erne beke la, ere erne soplawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yuri Jisas ere God eteri ake eisauke wurin yenbo tem tame erne etek lan erne etep wom. Gwopte ne yenbo noub teye. Ne kiyi nenbetem wule yaper sene mane nente. Ne wule yaper sene nente, wule yaper eisau nene sene tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Etep wom, yenbo tem tame ere yin Juda emne etep wusowum. Ane yenbo nenye tame ere Jisas. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jisas ere ete tame erne ege si yabelke eyarem, eke Juda eme tasen erne yaper nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisas ere Juda emne etep wom. Ari Apei ere yaku kwokwos kwokwos kerebe. Etepkap aren kir an etep kir kerebe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Etep wom, Juda eme erne pen sate abom. Eme etep wom. Ere wos pes yaper nenye. Wuri ere ege si yabel wule tousiye. Wuri ere etep woye. God ere areri Apei. Ere etep woye, e yaper. Eteke, Juda eme erne pap wayem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisas ere emne etep wom. An God Eteri Yen. An ari porerek beke nen. Apei eter nenbekap an labe, an etepwou nenbe. Be wos be wos ari Apei ere nenbe, an etep kir nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ari apei ere ane kobo labe, eke be wos be wos ere nenbe, ere ane peterabe. Kiyi ere ane peteram, an rigrabe nenem. Yuri ere ane sene peterate, an rigrabe nente, kem wouken akte nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ari Apei ere sabe tatame emne wou sene newobekap, an God Eteri Yen, areri porerek an tatame emne wote, eme yenbo som temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Apei ere tatame emne beke kip sin lan tuma namde. An Eteri Yen, ete yaku ere arene newon etep wom. Neren, ne tatame emne sin lan, tuma namdete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Etepkap akeite tatame eme Apei erne sukye worabekap, eme ane etep kir sukye worate. Apei ere ane won yam, etepkap, tatame eme ane sukye beke wora, eme ane won yam Apei erne kir sukye beke wora. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","An kemne sekenke wobe. Tatame eme ari tuma meten ane won yam tame erne kenawaike abote, eme som yenbo temente nenbe. Ete tatame an emne tuma beke kip namde. Eme sate, eme wou sene pette, eme yenbo som temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","An kemne sekenke wobe. An God Eteri Yen. Sam tatame eme areri tuma mette, eme yenbo som temente. Eme mette yabel e mekin mekinye. Gwopte teye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Apei eri mure eisauwai. Ere wou kuyese sene newobe. Ere eri mure ane newom. Newom, an kir an wou kuyese sene newobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","An Tatame Etemne Lan Yeirim Tame, eke Apei ere ane etep wom. Ne tatame emne sin lan tuma namdete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kem wouken mane akte. Sele meike tetan tatame eme ari tuma yurik mette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mette, eme sele meike sene wayete. Wayete, yenbo nenbetem tatame eme God eteri komke yin etek yenbo som temente nenbe. Yaper nenbetem tatame emne an tuma namden yaper awosein nente. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jisas ere etep wom. Be wos wuri an ari porerek beke nen. An tatame emne sin lan tuma namdete, an ari porerek beke nen. God ere ane wobekap, an emne etep nente. Ere ane wom, an eteri porerewouke nenbe. Etepkap, an tatame emne sin lan tuma namdete, ari namdete nenbe tuma e seken. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Aren nenbe yaku arenwou wusoute, eme meten eme abolawoite. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Akeite tame wuri ere arenke tatame emne wusoube. Ere arenken emne wusoube tuma e tuma seken. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kem tame kau emne won yim, eme Jon erne yin wometem. Wometem, aren nenbe wos ere emne wusowum. Ere tuma seken emne wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Aren nenbe wos, ete tame ere etep wusoute, an etep som beke abo. Berai. An kemne sene pette, kem yenbo tete, an eteke abobe. Eke ari nenbe wos Jon ere kemne wusoute, kem ane kenawaike abote, e yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ere kukmenem kerkap. Kem eteri kukmenem kerke kerake sin metekwasem, sene kem erne mesginim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jon ere yan kemne ari yate tuma etep wusowum. Apei God ere erne won yam, ere apeilake eisau. Ere kemne etep wusowum. Sene God ere ane newom yaku an kerebe. Kerebe, an tatame emne peterabe, God ere ane won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Apei eter ere ane won yam. Eter ere etep wom. Ere Areri Yen. Eter wobetem tuma kem beke met. Eteri bitimi kem beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ere ane won yam, an eteri tuma wusoube. Kem eri tuma kenawaike beke met, etepkap God eteri tuma keremri porerek beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kem God eteri siglou noub lan etep abobe. Nema God eteri siglou late, nema yenbo som temente. Kem etep abobe. Metye. Ete siglou ere kemne areneke wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kem ane kenawaike abote, kem yenbo som temente. Kem ane kenawaike abote mo wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Tatame eme ari sig eisau wote, an etep beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","An kemri porere laten. Kem God eterne beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","God ere areri Apei, ere ane won yam. Yam, kem ari tuma kenawaike beke met. Akeite tame eteri porerek abon yate, kem eteri tuma kenawaike metbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kem keremri sig awoawo maime eisau wobe, kem etepwou abobe, e yaper. God ere kemri sig eisau wote, kem etep beke abo. Eke kem ari tuma mapeke kenawaike mette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kerem nenbe wule yaper an ari Apei erne beke kip wusou. Kem abobe, Moses ere kemne kobo late nenbe. Berai. An kemne wobe, Moses eter ere kemne tuma namdete. Eter kemne newom wule ep yekwo let ep yekwo let kem tousibetem, eke ere kemne tuma namdete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kem Moses eri tuma kenawaike pauk mette wom, kem ari tuma etepwou kenawaike mette wom. Moses ere arene abon siglou basem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moses eter basem tuma kem kenawaike beke abo, eke ari tuma kem kenawaike beke kip abo. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Yuri Juda etemri Pasova awos eisau ate yabel mekin mekinmenem, tatame nogwape eme Jerusalemke yibetem. Jisas ere eteri anepoi tameken eme Galili peik kupa keraruke wum. Ete peik kupa eri sig wuri, eme etep wobe, Taiberias Peik Kupa. Keraruke wumke, tatame nogwape eme emne semoubetem. Kiyi eme lam, Jisas ere let yaper tewo yaper temenem tatame emne eyarem, eke eme erne semowum. Semowum, Jisas eteri anepoi tameken eme kowke yawon simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Simenem, Jisas ere lam, tatame nogwape eme erne semowun yabetem. Etep lamke, Filip erne ere yikwokwon etep wometem. Nema awos mak tuken nema ete tatame nogwape emne newon ate? ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Be awos tatame emne newon ate, Jisas ere etep kiyi abom. Ere Filip eteri porereke seilan erne yikwokwon wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip ere erne awosein etep wom. Nema 200 kinawou temente wote, nema ete tatame nogwape emne awos mapeke tuk. Eme se kir beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jisas eteri anepoi tame wuri, Saimon Pita eteri mase, Andru ere Jisas erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Yen wuri ere gwotek tetan, ere geil ep yekwo letken omyen sok pesken etep seten. Etepkap, tatame nogwape eme se kir beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisas ere etep wom. Kem tatame emne won yan eme etek site. Etep wom, top nogwape ete emik temenem, eme etek sitirim. Sitirim tame eme nogwapewai (500). Eme tame etemwoune sarem. Yenta emne beke sar. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Eme simke, Jisas ere geil ep yekwo let peten God erne pir won etek simenem tatame emne newopit peteyam. Ere omyen kir etepwou nenem. Newopit peteyam, akei tatame eme an se kir tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Se kir tem, ere anepoi tame emne won yin etep wom. Geil tepken omyen tepken kem sene pette. A tep yaper tete wurken. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Emri am geil tep eme peten kwora sare ep yekwo let ep yekwo let tewo bor pes kei (12-pela) etek yewon pelawom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tatame eme Jisas ere nenem rigrabe lam, eme etep wom. Sekenwai. Kiyi God ere eri tuma wusou tame gwo nowselke won yate wom. Ete tame e Jisas eter. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Etep womke, Jisas ere lam, eme erne egiyen erne apeilake tete wom. Ere etep lamke, ere emne mesginin ere kow eisau etek kena wiwi yin yawom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yabel warbetem, eri anepoi tame eme peik kupa barke warem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Waren neir teketebem, Jisas ere mak yamenem. Mak yamenem, eme pere waren Kaperneam komke woi wubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wubetemke, marye eisau yam, sene oksare eisau ere me yau yeirin yabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Me yau yeirin yabetem, eme piyan yin genek temenem, kilomita nogwape kera (5 o 6 kilomita) eme etepke yin temenem. Temenem, eme lam, Jisas ere ok luke ep yekwo yabetem, pere mekinke yabetem eme etep lam, eme kenake akem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ere emne etep wom. Kem mane akte. Gwo aren. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Etep womke, eme pap yenbo meten erne yewom. Yewom, agetage pere ere etem yite yibetem emik yin gayim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kwokwos peik kupa keraruke temenem tatame eme etek som temenem, eme lan etep wom. Pere wurisubuke yere gwok temenem. Yere Jisas ere anepoi tame etemken beke yi. Anepoi tame etemwou eme perek waren yim. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sene tatame kau eme perek waren Taiberias kom mesginin yam. Aneyen ere God erne pir won tatame eme a am emik eme etek yan gayim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gayim, tatame nogwape eme lam, Jisas ere eteri anepoi tameken eme etek beke temen. Lawoyim, eme etek gaimenem perek waren Kaperneam kom keraruke woi wukwuten Jisas erne sopte yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ete tatame eme peik kupa keraruke erne yin lam, eme erne wometem. Tuma wusou tame, ne mapeke yawo? ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ere emne awosein etep wom. An kemne sekenke wobe. An rigrabe nenbe, kem bepou me lam, kem ane beke abo. Yere kem geil an se kir tem, eke kem ane abon sopbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nowri awos e kupa tebe awos. Kem a yakuwou mane kerete. Akeite awos kem peten ate, kem noub som temente. An Tatame Etemne Lan Yeirim Tame, Apei ere ane wom, an kemne ete awos newote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Eme erne awosein etep wom. Nema beke nentek, nema God eri yaku kerete? ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ere emne awosein etep wom. God ere abobe, ere eri won yam tame arene kem kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Eme erne etep wom. Neren nemne rigrabe nente, nema nene kenawaike etep abote, ne God Eteri Yen. Ne be rigrabe nente? ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nemri yeiwarege eme tameken berai emik temenem, eme awosken berai, Moses ere emne awos newon am. Ete a eri sig mana. God eteri siglou etep wobe. Ere emne eteri komke yeirim awos emne newon am. Kap ne awos nemne kuyese newote o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ere emne etep wom. An kemne sekenke wobe. Moses ere newom awos e God eteri komke yam awos berai. Awos seken ari Apei eterwou ere kemne newobe. Ete awos e Heven mesginin yam tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Aren an Heven mesginin yam. Nowselri tatame eme ane kenawaike abote, an emne porere yenbo newote, eme noub som temente. E awos abe wulekap. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Eme erne etep wom. Aneyen, ne ete awos nemne kwokwos kwokwos newon ate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ere emne etep wom. Aren, an aomkap. Tatame eme arene kenawaike abote, eme mure pette. Eme porere yenbo pette. Eme noub som temente. Eme pap yenbo som mette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","An kemne woye. Kem ane laye, kem ane kenawaike beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Apei ere ane newom tatame eme arenke yate nenbe. Tatame eme arene yan late nenbe, an emne sene beke kip won yi. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","An God eteri kom mesginin yam. Arene wom tame, God, eteri porere an etep nente yeirim. An ari porerek beke kip nen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ane wom tame ere ane etep wom. An nene newom tatame emne ne mane wuri mesginte. Nowsel yaper tete yabelke ne emne akei wou sene newote, eme yenbo som temente. Ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ari Apei ere etep wom. Tatame eme Ari Yen erne kenawaike abote, eme yenbo som temente. Etep wom, nowsel yaper tete yabelke, an ete tatame emne wou sene newote, eme yenbo som temente. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kiyi Jisas ere etep wom. Aren, an awos, God eteri komke yam awos. Etep womke, Juda tame eme etep meten eme tuma eikap nakwosebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Eme etep wom. Ete tame ere mane etep wote. An God eteri kom mesginin yam. Etep wote, ere tuma me yikwokwobe. Ere Jisas, Josep eteri yen. Eri anenawoken nema epne etep laten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ere emne awosein etep wom. Kem ane tuma eikap mane nakwosete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Apei eter ane won yam. Apei eter tatame emne wotek, eme ane kenawaike ek abote. Ere emne beke kip wo, eme ane kenawaike beke kip abo. Yuri nowsel yaper tete yabelke, ete tatame an emne wou sene newote, eme noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","God eteri kiyi temenem tuma wusoubetem tame eme siglou etepke basem. God ere tatame emne porere newote. Etepke basem. Tatame eme God eteri tuma mette, eme eteri porere peten eme ane kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tatame eme Apei erne beke la. Eter tetan komke yam tame, arenwou an erne laten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","An kemne sekenke wobe. Tatame eme ane kenawaike abote, an emne wou sene newote, eme noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aren an aomkap. Tatame eme ane kenawaike abote, eme noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kiyi kemri yeiwarege eme tatameken berai emik temenem, eme mana awos yenbowai abetem, eme keryen ten me sabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","An God eteri komke yabe awoskap, tatame eme ete awos ate, eme ane kenawaike abote, yuri eme yaper beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","An God eteri kom mesginin yam. Aren an aomkap. Tatame eme ete awos ate, eme ane kenawaike abote, eme noub som temente. An emne newote awos e areri om. An sate, eke tatame nogwape eme noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Juda eme ete tuma metem, eme etemwou etemwou tuma walekap nayim. Eme etep wom. Gwo tame ere eri om mapeke nemne newon ate? Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ere emne etep wom. An Tatame Etemne Lan Yeirim Tame. An kemne sekenke wobe. Kem ari wusom beke kip a, ari nep beke kip a, kem som noub beke kip te. An kemri wule yaperke sate. Kem etep kenawaike abote, kem noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tatame eme ari omken nepken abetete, eme som noub me temente. Yuri nowsel yaper tete yabelke, an emne wou sene newote, eme noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kem nowri awos abe, kem mure nebuleke petbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tatame eme ari omken nepken abe, etepkap eme arenken tetan, an etemken tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Som temente God ere ane won yam. Eteri murek aren kir an noub som temente. Etepkap, tatame eme ane kenawaike abote, eme noub som temente. Eme ari murek som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yeiwarege etem abetem awos eme abetem, eme sabetem. God eteri kom mesginin yam awos, e aren. Tatame eme ate, eme ane kenawaike abote, eme som noub temente. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas ere Kaperneam komri God eteri akek temenem, ere emne ete tuma wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jisas ere tuma womke, eteri wakse nogwape eme meten etep wom. Eri woye tuma e kik tetan tuma. Nema mapeke noub met. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Eteri wakse eme etemwou etemwou erne tuma eikap nakwosebetemke, Jisas ere emri selpap lan emne etep wom. Beke kem ari tuma mo wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","An Tatame Etemne Lan Yeirim Tame, an kiyi temenem komke sene yite. Kem etep late, kem kenawaike beke kip abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","God Eteri Wou ere selpapken porereken yenbo newobe, eke kem erne pette, kem noub som temente. More tame eme selpapken porereken yenbo beke kip newo. An kemne wobe tuma e God Eteri Wou eteri tuma. Kem ari tuma kenawaike mette, kem noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kem kau ari tuma kenawaike beke met. Etep wom, tatame eme eri tuma kenawaike beke kip met, ere etep kiyi metmenem. Erne yaper nente nenbe tame eterne kir ere kiyi lan metmenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ere sene etep wom. An kemne kiyi woye. Ari Apei ere tatame emne mure beke kip newo, eme ane kenawaike beke kip abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ere etep womke, eteri wakse nogwape eme erne mesginin yim. Sene eme eterken beke sewur. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Etep temke, ere eteri anepoi tame ep yekwo let ep yekwo let ep yekwo tewo bor pes kei (12-pela) emne etep wometem. Kem ane kir mesginin yite o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita ere erne awosein etep wom. Aneyen, nema eikek yite? Neren wobe tuma, tatame eme nene kenawaike mette, eme noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nema neri tuma kenawaike metbe. Nema metten, ne God Eteri Yen yenbo. Nema etep metten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisas ere emne awosein etep wom. An kemne ep yekwo let ep yekwo let tewo bor pes kei (12-pela) kemne etep kenem. Kenem, kemri wuri ere tame yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Etep wom, ere Judas, Saimon Iskariot eteri yen eterne abon eke wom. Judas ere anepoi tame ep yekwo let ep yekwo let tewo bor pes kei (12-pela) etemri wuri. Yuri Judas ere Jisas erne yena ten eri peiktame eme erne pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yuri Jisas ere Galili distrikke yaku keren sewurbetem. Juda tame kau eme erne pen sate koumenem, eteke Jisas ere Judia distrikke sewurte mo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Juda etemri ege si yabel wuri mekin mekinmenem. Ete yabel eme sipsip wuske kerebe yabel ake keren yam, eme etek sin a abetem. Ete sipsip wuske kerebe yabel ake ege si yabel mekin mekinem, ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jisas eri mase eme Jisas erne etep wom. Ne gwo kom mesginin Judia distrikke yi. Tatame nogwape eme etek tetan. Neren nenbe rigrabe ne etek sene nenen eme late. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","5","Eteri mase eme erne kenawaike beke abo, eke eme erne sene yaku wotaken etep wom. Akeite tame eme sig eisau pette abote, eme yaku beke berasen kere. Eme kom geinik kerebe. Ne rigrabe nente, ne kom geinik nentek, tatame nogwape eme late. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisas ere emne etep wom. Gwopte an Jerusalemke beke kip yi. God ere ane wote, an ek yite. Gwopte kem yin sou late, an tuma berai. Keremri wos. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","God eteri tuma beke met tatame eme kemne mo beke kip wo. Arene eme mo wobe. Emri nenbe wule yaper an kom geinik wusoube, eke eme ane mo wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kem Jerusalem komri ege si sou yin late. Kem epe yi. Gwopte an ete sou beke kip yi. God ere wote, an ek yite. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Etep won, ere Galilike temenem. Ere beke yi. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jisas eteri mase eme ege si yabel sou late yimke, ere tipti won yim. Yim, ere kelu ganke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yim, Juda tame eme erne sou tetebetem emik me sopbetem. Eme erne wometla kalen etep wom. Ete tame ere mak tetan? Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tatame nogwape eme erne etemwou etemwou elen me namdebetem. Kau eme etep wobetem. Ere tame yenbo. Kau eme etep wobetem. Ere tatame emne tuma yikwokwobe tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Eme Juda apeilake etemne akem, eke eme erne elen me namdebetem, eme geinik beke namde. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sipsip wuske kerem yabel ake sou som temenem, Jisas ere God eteri ake eisauke yawon wurin tatame emne tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wusowum, Juda eme eteri tuma metem, eme wouken aken etep wom. Jisas ere skul eisau beke yin si. Ere porere eisau mak petem? ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ere emne awosein etep wom. An kemne wusoube tuma e areri tuma berai. E God eteri tuma. Ere ane won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","God eteri porerek nente abobe tatame eme metbe, an wobe tuma e ari tuma berai. E God eteri tuma. Eme etep metten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tame ere eteri porerek tetan tuma wusoute, ere abobe, akeite tatame eme eri sig eisau wote. An etepkap tame berai. God ere ane won yam. Etepkap, tatame eme God eteri sig eisau wote, an eteke abobe. Etepkap an kemne wobe tuma e tuma seken. An kemne beke yikwokwo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses ere God eteri wule basen kemne newom. Kem ete wule beke noub meten tobo. Kem wobe. An ete wule tousibe, eke kem ane pen sate abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tatame eme erne awosein etep wom. Nene gabok guleleyeke, ne etepkap tuma wobe. Nene eike pen sate? ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ere emne awosein etep wom. Kiyi ege si yabelke an tame wuri erne eyarem. Kem etep lam, kem ane etep wom. Ne yaku ege si yabelke kerebe. Etep wom, kem ane pap wayem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Metye. Kemri yeiwarege eme somo kwunbe wule kemne newom. Yuri warege Moses ere ete wule kir wom. Nawo te taureyen warwibe, yabel ep yekwo let ep yekwo let bor mur kei (8-pela), kem yen somo kwunbe. Ep yekwo let ep yekwo let bor mur kei (8-pela) yabel e ege si yabel, kem somo kwunbe. Etep tebe, kerem kir, kem yaku ege si yabelke kir kerebe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moses eri somo kwunbe wule kem mane tousite, eke ege si yabelke kem taureyen emne somo kwunbe, kem wobe. Nema etep nenbe, e yenbo. Etep wobe. Kiyi an let nai tewo nai tame wuri eri wusom ege si yabelke eyarem. Etep tem, beke kem ane tuma namdebe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ari nenbe wule somo kem beke met, eke kem ane tuma namdebe. Kem ane noub mette, kem ane tuma etepkap beke kip namde. Ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalemri tatame kau eme Jisas erne lan eme etemwou etemwou namdem. Eme tame wuri pen sate wom. Kap, Jisas eterne o eikene? ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ek la. Jisas ere kom geinik tetan tatame emne tuma wusoube. Apeilake eme erne beke wotake. Kap eme kenawaike etep metbe, Jisas ere God eter wom tame? ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nema mapeke met? Nema eri kom sig metten. Ere Nasaret komri tame. God eter wom tame ere yate wule, tatame eme eri yate wom kom eme beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisas ere God eteri ake eisauke temenem, ere tatame emne tuma wusoubetem. Ere noubke etep wometem. Kem ane noub metten? Ari maime kom seken kem noub metten? Metye. An areri porerek beke ya. Arene won yam tame ere seken. Kem erne beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Aren an erne metten. An eterken temenem, eke, ere arene won kemne yan lam. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Eme eteri tuma metem, eme pap wayen erne ake yaperke won wurte abom. God ere kir beke wo, eke eme erne beke keresuk. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Etep tem, tatame nogwape eme erne kenawaike abobetem, eke eme etep wom. Jisas ere rigrabe kenake nenbe. Akeite tame ere erne mapeke teitkwun. Eter ere kuyese som nenbe. Nema etep wobe. Jisas eter ere God eter wom tame. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tatame nogwape emri elen me namdebetem tuma Farisi tame eme etep metem. Tatame eme Jisas erne kenawaike abom. Eme etep metem. Metem, Farisi tameken God eteri akek yaku kere tame etemri apeilakeken eme nau se tame emne etep wom. Kem yin Jisas erne keresukun ake yaperke won wurte. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisas ere tatame emne etep wom. Kerake an keremken temente. Sene an arene won yam tame erne sene yin late. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yite nenbe, kem ane soplawoite. Ari yite emi kem kuyese beke kip yi. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juda tame eme etep metem, eme etemwou etemwou namden etep wom. Ere ma komke yite, nema erne beke kip la? Kap ere neremri tamesip etem tetan emi kantri Grikke yite o? Ere Grik tame emne yin eteri tuma emne wusoute o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ere nemne etep woye. Kem ane soplawoite. Ari yite emi kem kuyese beke kip la. Etep woye, eri etepkap woye tuma nema noub beke met. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Eme sipsip wuske kerebe yabel ake sou omon, eme bokte nenbetem, ete yabel eme sou eisau tetebetem. Ete yabelke Jisas ere teten tatame emne tuma noubke etep wusowum. Kem eike wak sok tete, kem arene yan late. Kem ari tuma kenawaike mette, an kemne som temente kelpok newon ate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","God eteri siglou etep wobe. Tatame eme ane kenawaike abobe, God Eteri Wou ere etemri porerek tetan. Etek tetan, eme wule yenbo som tobobe. Emri tobobe wule yenbo e ok sekbekap. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Eri tuma somo gwo. Tatame eme erne kenawaike abote, God Eteri Wou ere etemken temente. Erne kenawaike abobetem tatame ete yabel eme God Eteri Wou mak petmenem. Yuri ere san wou sene peten sene wayen God eri komke yawom, ere God Eteri Wou emne ek newom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tatame nogwape eme Jisas eteri tuma metem, kau eme etep wom. Jisas ere God eteri tuma wusou tame wuri. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kau eme etep wom. Ere Krais berai. Jisas ere Galili tame. Krais ere Galili distrikke beke kip ya, eke Jisas ere Krais berai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","God eri siglou etep wobe. Krais ere Devit eteri nanyen. Devit eteri kiyi temenem kom e Betlehem, eke Krais ere ete Betlehem komke yate. God eteri siglou etep wobe. Epkap, kau tame eme etep wom. Jisas ere Betlehem komri tame berai. Ere Nasaret komri tame. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Etep tem, tatame eme borke pekam. Kau eme erne kenawaike abobetem, kau eme erne kenawaike beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kau eme erne ake yaperke won wurte abom. Etep tete abom, eme erne beke keresuk. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kiyi Farisi tame, God eteri akek yaku kere tame etemri apeilake eme nau se tame emne won Jisas erne keresukte yim. Eme bepou me sene yamke, apeilake eme emne etep wom. Kem mapeke teye, eke kem Jisas erne beke panen ya? ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nau se tame eme awosein etep wom. Jisas eteri tuma wusoubekap, kiyi temenem tame eme etepkap beke wusou. Eteke, nema erne beke keresuk. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisi tame eme nau se tame emne etep wom. Kerem kir kem Jisas eteri yikwokwobe tuma kenawaike metbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nema Farisi tame, nema apeilake, nema eteri tuma kenawaike beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jisas erne abobe tatame eme Moses eri wule noub beke met, eke God ere emne yaper nente nenbe. Farisi eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Etep wom, kiyi Jisas erne yin lam tame, Nikodemus, eter kir ere Farisi tame etemri wuri, ere etek temenem. Ere kau Farisi tame emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Neremri wule nema tame emne bepou beke pe. Nema tame eri tuma noub kiyi mette. Mette, ere wule yaper nente, nema erne ek pete. E neremri wule. ");
INSERT INTO yss_yawu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Eme erne awosein etep wom. Kap ne Galili tame wuri? Ne God eteri siglou noub lan abote. God eteri tuma wusou tame eme Galili distrikri tame berai. Farisi tame eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Eme etep wom, tatame eme etemri akek yikwutem. Jisas eter ere Oliv kowke yawom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yawom, ei berabetem, ere God eteri ake eisauke sene yeirim. Yeirim, tatame nogwape eme eterne late yam, ere sin emne tuma wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tuma wusoubetemke, Moses eri tuma wusoubetem tameken Farisi tameken eme ta wuri tene panen yam, tatame nogwape etemri borke yan tetem. Ete ta te sir yim, eme tene etep lam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tetem, eme Jisas erne etep wom. Tuma wusoube tame, gwote ta te sir yimke, eme tene lam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses eri basem wule ere nemne etep wobe. Sir yibe ta tene nema pape peten seitin tene pen sate. Moses ere etep wom. Neren, ne mapeke abobe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Eme ete tuma eterne me seilam. Eme eterne tuma namdete keluke sopbetem. Etep wom, Jisas ere awosein beke wo, ere guromun sin let bor subuk basbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Eme erne kenawaike wobetemke, ere wayen teten emne etep wom. Kemri eike tame eter ere wule yaper beke wuri nen, eter taresin pape peten tene kiyi seitte. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Etep wo mesginin Jisas ere sene guromun subuk sene basem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bas rasbetem, eme ete wom tuma metem, eme emri nenbetem wule yaper maime sebera yam, eke eme wurare wurare yikwute yakwutem. Apeilake eme kiyi taresin yimke, sene akeite tatame eme emne semowun yim. Eme yikwutemke, Jisas ere gwo, ete ta te gwo epewou etek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Etepwou temenemke, Jisas ere wayen teten tene etep wom. Eme mak yiwo? Eme nene pape beke seit. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Te awosein etep wom. Ye. Eike tame eme ane tuma beke wuri namde. Ere tene etep wom. An kir, an nene tuma beke kip namde. Ne epe yi. Ne wule yaper sene mane kip nente. Ere tene etep won te ek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yuri Jisas ere tatame emne sene etep wom. Arenwou an tatame etemne tukap kerebe tame. Tatame eme ari tuma meten tobote, eme kerneirik beke kip sewur. Eme selpap yenbo peten noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Etep womke, eke Farisi tame eme erne etep wom. Ne neren kena wobe, eke neri wobe tuma tatame eme kip beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ere emne awosein etep wom. An kemne areri maime tuma eteke wobe, ari wobe tuma e seken. Ari yam emiken yite emiken an maime metten. Eke an tuma seken wobe. Ari yam emi, ari sene yite nenbe emi kem beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kem nowselri wos sebe tatame, kem tatame emri selpap kuyese beke kip la. Kuyese beke kip la, kem emri nenbekap bepou me sin labe. An tatame emne beke sin la. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","An tatame emne sin late wote, an kena wiwi beke kip nen. Ane won yam tame ere arenken tetan, nesa tatame emne kir sin late. Eke nesetri wule e wule yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Keremri basem wule etep wobe. Tame pes epe wos wuri kir lan epe tuma kir wobe, epri wobe tuma e tuma seken. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","An aren kena wobe, arene won yam Apei eter kir ere ane kemne wobe. Ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Emken erne awosein etep wometem. Neri ar ere mak tetan? Ere emne awosein etep wom. Kem ane beke met, kem ari Apei erne kir beke met. Kem ane metmente, kem Apei erne kir metmente. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ere tatame nogwape emne God eteri ake eisauke tuma etek wusoubetem, kel rasbetem emi, etek wusoubetem. Wusoubetem, eme erne beke keresuk. God ere beke wo, eke eme erne beke keresukun ake yaperke beke won wur. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas ere sene Farisi tame emne sene etep wom. An yite, kem ane sopte nenbe. Kem ane soplawoite, kem me sate nenbe. Kemri nenbe wule yaper beke mesgin, kem ek sate nenbe. Eke an yite kom kem etek beke kip yi. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Juda tame eme abolawoyin etep wom. Beke ere etep wobe. Eter yite kom nema beke kip yin la. Kap ere eter maime pen sate nenbe o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ere emne awosein etep wom. Kem nowselri tatame. An God eteri kom Hevenke temenem, an nowselke yam. Kem nowselri tatame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","An kemne kiyi woye. Keremri nenbe wule yaper beke mesgin, kem ek sate. An kemne kiyi etep wobetem. An God Eteri Yen. Kem etep kenawaike beke abo, kem nenbe wule yaper beke mesgin kem ek sate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Eme erne awosein etep wom. Ne eike? Ere emne awosein etep wom. An etem kemne kiyi wobetem tame an gwote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kemri nenbe wule yaper an kemne tuma kenake namdete. Ane won yam tame eteri tuma e seken. Eri tuma an metem, an nowselri tatame emne eteri tuma wusoube. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ere God eterneke emne wusowum, eme ete tuma somo beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Beke met, eke ere emne etep wom. An Tatame Etemne Lan Yeirim Tame. Yuri kem ane mek kwuran kwanen nenewayen yeworute nenbe. Etep tetek, kem mette, an God Eteri Yen. An ari porerek beke nen. Apei ere ane tuma wusowumkap, an etepwou wusoube. Yuri kem etep mette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ane won yam tame eter abobekap, kwokwos kwokwos an etepwou nenbe. Eke ere arenken tetan. An kena beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ere etep womke, tatame nogwape eme erne kenawaike abobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sene Jisas erne kenawaike abobetem Juda tatame emne ere etep wom. Kem ari tuma kenawaike som meten tobote, kem ari wakse seken tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Etep tete, kem ane noub metmente. An nowselri wule yaper kemne ogworaste, kemne be wos sene beke kip keresuk. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Etep womke, eme abolawoyin, eme erne awosein etep wom. Nemne be wos be wos beke keresuk. Nema Abraham eteri yennan. Kiyi akeite tame eme nemne beke keresuk, nema emri yaku bepou beke kere. Beke ne etep woye, nema nene kenawaike abote, sene be wos nemne sene beke keresuk? ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ere emne awosein etep wom. An kemne sekenke wobe. Eike tatame eme wule yaper nenbe, ete wule yaper eter ere emne maime keresukten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Keresukten tatame eme apeilake tame eteri akek som beke kip te. Apeilake tame ere emne wotaken sene won yite. Ete apeilake tame eteri yen etemwou eme etek som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","An God Eteri Yen. An wule yaper ogworaste, wule yaper ere kemne sene beke kip keresuk. Kem wule yaper sene beke kip nen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","An metten, kem Abraham eteri nan. Kem ari tuma beke met, eteke kem ane pen sate abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kiyi an areri Apei eterken temenem. Be wos an etek lam, an etep wusoube. Kerem, keremri ane eteri wobekap, kem etepwou nenbe, kem etepke tetan. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Eme Jisas erne awosein etep wom. Nemri warege ere Abraham. Jisas ere etep wom. Kem wobe, kem Abraham eteri nan. Aren an wobe, Abraham eter tebetemkap, kem etep beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","God ere ane wobetem tuma seken, an kemne wusoube. Wusoube, kem ane pen sate abobe. Abraham ere etepkap beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kemri ar ere tebekap, kem etepwou tebe. Eme erne etep wom. Nema kelu yen berai. Nemri apei wurisubu, ere God. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ere emne etep wom. God ere keremri apei temente wote, kem ane pap yewote. Kem ane pap beke yewo. An ari porerek beke ya. Kiyi an God eterken temenem, ere ane wom, eke an erne mesginin yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Beke kem ari tuma beke met? Kem mo wobe, eke kem beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Keremri ar ere Satan. Kem eteri yen. Eter wobekap, kem kir won nenbe. Kiyi ere tame pen sabetem, gwopte ere etepwou tebe. Tuma seken ere magel taibe, eke ere tuma seken mapeke wo? Yikwokwo tumawou eri porerek tetan, eke ere yikwokwo tumawou wobe. Ere tuma yikwokwobe tame. Yikwokwo tuma wusoube apeilake ere Satan. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","An kemne tuma seken wusoube, eke kem ete tuma kenawaike beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","An be wule yaper nenem? Eike ere ane wusoute? An wule yaper beke nen. An kemne tuma seken wusoube. Beke kem ari tuma kenawaike beke met? ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","God eri yen eme God eteri tuma kenawaike metbe. Kem God eteri yen berai, eke kem eteri tuma kenawaike beke met. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda tame eme Jisas erne awosein etep wom. Nema sekenke wobe. Ne Samariari tame. Samaria komri tame eme God erne beke abo. Ne etemkap. Gabo wuri ere nerene guleleten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ere awosein etep wom. Gabo ere ane beke gulele. An ari Apei eri sig eisau wobe. Kem ari sig yaper wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","An ari sig eisau maime beke wo. Tame wuri ere ari sig eisau wote abobe. Ere tatame emne sin labe tame eter. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sekenwai, an kemne wobe. Kem ari tuma meten tobote, kem noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juda eme erne etep wom. Ne etep woye, nema metten, gabo nene guleleten. Abraham ere kiyi sam. God eteri tuma wusoubetem tame eme akei eyi saiwom. Ne etep wobe. Tame eme neri tuma meten tobote, eme noub som temente. Beke ne etep wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nemri kiyi sam warege Abraham ere apeilake eisau temenem. Ne erne mapeke teitkwunem? God eteri tuma wusoubetem tame eme kiyi sam. Ne emne mapeke teitkwunem? Ne mapeke abobe, ne mapkap tame? ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ere awosein etep wom. An ari sig eisau maime wote, an bepou me wote. Ari Apei eter ere ari sig eisau wobe. Ari Apei kem erne etep wobe. Ere neremri God. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Metye. Kerem, kem God erne beke la. Aren, an erne laten. An etep beke wo. An erne beke la. An etep wote, an keremkap tuma yikwokwo tame tete. An erne metten, eter wobekap, an etep kir tobobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Keremri warege Abraham ere Hevenke tetan. An nowselke yeirte wom, ere etep metem, ere ane metekwasem. Ere etep lan ere metekwaswayim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Juda tame eme erne etep wom. Ne nabe nogwape (50-pela) beke te. Ne keryen berai. Ne Abraham erne mapeke lam? ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ere emne etep wom. An kemne sekenke wobe. Kiyi Abraham ere mak temenem, ere letbai tewobaike temenem, aren an temenem. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Juda eme etep metem, eme erne pape peten seitte nenem. Etep temke. Ere berasen God eteri ake eisau mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas ere yibetem, ere le simenem tame erne lam. Nawo te erne warwiyim, te etepke lam, ere le simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Eri anepoi tame eme erne etep wometem. Tuma wusoube tame, eike wule yaper nenem? Ete le simenem tame eter ere yaper nenen ere le sim, o eri anenawo etep yaper nenemke, ere le ek sim? ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ere awosein etep wom. Ete tame eri nenem wule yaper o anenawo epri nenem wule yaper berai. God eter ere etepke seikim. Etep tem, ere eri mure eisau peterate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ane won yam tame eteri yaku nema som kerete. Yabel pasten, nema yaku etek kerete. Yuri neir teketete nenbe, nema yaku mapeke kere? Eke nema eteri yaku gwopte som kerebe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","An nowselri tatame etemken tetan, an etemri tukap. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ere etep womke, ere sabelokwo selke kwuspayen ere sabelokwo selken peten le si tame eri le bandem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Bandem, ere erne etep wom. Ne yin Siloam okmoike yin ok etek wite. Siloam sig eme tuma somo etep wobe. Won yim. Etep wom. Ete tame ere yin ok wiyin akek sene yam, eri le yenbo ten ere kuyese labetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ete tame, kiyi ere tatame emne kel o awos wometbetem. Eri kom tatameken erne kiyi labetem tatameken eme etep wometem. Kap ete tame ere nemne kiyi keluke sin kel nasegerebetem tame eter, o? Etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kau eme etep wom. Ye. Eterke. Kau eme etep wom. Ere berai, e akeite tame, eteri tame yopkap labe. Etek le yenbo tem tame ere etep wom. Akeite tame beraike. Gwo aren. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eme erne etep wometem. Mapeke teyek, neri le yenbo sene teye? ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ere emne awosein etep wom. Tame wuri, eri sig Jisas, ere sabelokwo selke kwuspayen peten areri le banden ere ane etep woye. Ne Siloam okmoike yin ok etek wite. Etep woye, an yin wiwo, an le kuyese sene laye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eme erne etep wometem. Ete tame ere mak tetan? Ere awosein etep wom. Kapken. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Eme le sene yenbo tem tame erne Farisi tame etemke panen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisas ere sabelokwo selke kwuspayen peten tame eri le eyarem yabel e Juda etemri ege si yabel. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farisi tame etem kir le sene yenbo tem tame erne wometen etep wom. Neri le ere mapeke yenbo sene teye? Ere emne awosein etep wom. Ere sabelokwo selke kwuspayen peten ari le banden an ok yin wiwo, eke ari le sene kuyese laye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kau Farisi tame eme etep wom. Erne eyarye tame ere ege si yabel wule tousiye, etepkap ere God eter won yam tame berai. Kau eme etep wom. Wule yaper nenbe tame ere Jisas eri nenbekap mapeke nen? Etep wom. Farisi tame eme peske pekam, kau eme Jisas erne kenawaike abom, kau eme erne kenawaike beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Eme pes pekamke, eme le sene yenbo tem tame erne sene etep wom. Ete tame ere neri le eyarye, ne erne mapeke abobe? Ere awosein etep wom. Ete tame ere God eteri tuma wusou tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Le sene yenbo tem tame, ere kiyi etep wom. Kiyi an le simenem, sene an kuyese labe. Etep womke, Farisi tame eme eri tuma som beke met, eke eme le sene yenbo tem tame eri aken nawoken epne wopeten yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Yam, eme epne etep wometem. Gwote tame ere kerepri yen seken o? Nawo te erne warwiyim, ere le simenem o? Mapeke teyek, eri le yenbo sene teye? ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aken nawoken epe awosein etep wom. Gwo nesetri yen seken. An erne warwiyim, ere le simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mapeke teyek, eri le yenbo teye, nesa beke la. Eike eri le yenbo nenye, nesa beke la. Nesetri yen ere aneyen tem, kem eterne wometla. Eter ere kemne noub wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Epe Juda etemri apeilake emne akem, eke epe etep wom. Jisas eter kerebetem yaku Juda apeilake eme kenawaike beke abo, etepkap kiyi eme etep wom. Tatame eme etep wote. Jisas ere Tatame Etemne Sene Pette Tame. Etep wote tatame eme God eteri ake sene beke kip wur. Nema erne wotakete. Juda apeilake eme etep womke, eke anenawo epe me akem, ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","epe etep wom. Ere aneyen tem, kem eterne wometlate. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farisi tame eme le sene yenbo tem tame erne tewo pes sene wopeten yam. Yam, eme erne etep wom. Ne nemne tuma mane yikwokwote. Ne tuma seken wote. Neri le eyarye tame ere wule yaper nenbe tame. Ere God eteri tuma wusou tame berai. Nema etep metten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Le sene yenbo tem tame ere awosein etep wom. Ere tame yenbo o ere tame yaper, an beke met. Yeki an le som simenem, gwotepte ari le yenbo teye. An etepwou metten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Eme erne etep wometem. Ere nene beke nenye? Ere neri le mapeke eyarye? ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ere emne awosein etep wom. An kemne kiyi wusouye. Kem mette mo woye. Beke kem kupa yapa som wometbe? Kap kem eteri wakse tete abobe o? Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Eme erne tuma yaper etep wom. Neren, ne eteri tuma metbe tame. Nerem, nema warege Moses eteri tuma metbe tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","God ere Moses erne tuma wusoubetem, erne yaku kerete wom. Ete tame Jisas, eike erne won yam? Ere mak yam, nema beke la? ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tame ere wouken aken emne awosein etep wom. Nawoi apeio. Ete tame ere rigrabe nenye, ere ari le eyarye, kem erne beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Metye. God ere wule yaper nenbe tame emri tuma beke kip met. Tame ere God erne sukye worabe, eri wule tobobe, God ere etepkap tame etemri tumawou metbe. Nema etep metten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Gwopkap kiyi beke temen. Nawo te yen erne warwiyim, ere le simenem, sene akeite tame ere eteri le sene beke noub eyar. Kiyi etepkap wule beke temen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","God ere ete tame erne beke pauk won ya, ari le gwote pauk som siten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Etep womke, eme erne awosein etep wom. Ne kelu yen. Beke ne nemne tuma wusoube? Ne epe seki. Etep womke, eme erne keren tebana tabanan yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas ere metem, eme le sene yenbo tem tame erne tebana tabanan yim. Etep metem, ere le sene yenbo tem tame erne sopen lan etep wom. Ne Tatame Etemne Lan Yeirim Tame erne kenawaike abobe o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ere erne awosein etep wom. Aneyen, ere eike? Ne ane wusoute, an erne kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisas ere etep wom. Ne erne kiyi laye. Ere nerenken tuma namdebe. An gwote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ere etep wom. Aneyen, an nene kenawaike abobe. Etep wom, ere gulke pan erne sukye woram. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisas ere etep wom. An akei nowselri tatame emri porere sin late yam. Tatame kau eme etep wobe. Nema God eteri tuma noub beke met. Ete tatame an emne wote, eme noub mette. Tatame eme etep wobe. Nema God eteri tuma noub kiyi metem. Nema porere eisau tetan. Etep wobe tatame an emne tuma mapeke wusoute? Eme noub beke kip met. An etemri porere sin late yam. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisi tame kau eme mekin temenem, eme eteri tuma meten erne etep wom. Ne neremne wobe, nema God eteri tuma noub beke met. Nema wobe, nema God eteri tuma noub metten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ere emne etep wom. Kerem God eteri tuma noub mette wom, kem wule yaper beke pauk nen. Kem etep wobe. Nema God eteri tuma noub metten. Kem etep wobe, kem me yikwokwobe, kem wule yaper som nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas ere etep wom. An kemne sekenke wobe. Sipsip eme bow peikem emik tetan. Tame eme eru beke wur, eme bowke yawon warbe, ete tame eme sir petbe tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Eruke wurbe tame eter ere sipsip lakerebe tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ete eru lakerebe tame ere eru latte. Latte, sipsip lakerebe tame ere ek wurte. Eter ere eri sipsip etemri sig wurare wurare emne wobe. Eteri maime tuma ape sipsip eme metbe, ere emne panen kom genik worakwutebe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Emne panen worakwutebe, ere taresite. Sipsip eme eteri maime tuma ape metbe, eke eme erne semowun yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sipsip eme akeite tame erne beke semowun yi. Eme akeite tame eteri tuma ape metbe, eme erne lan me amekirbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas ere emne ete sekur sakur tuma wusowum, eme tuma somo noub beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Eme ete tuma somo beke met, eke Jisas ere sene etep wom. An kemne sekenke wobe. Ane kenawaike abobe tatame eme sipsipkap. Aren an etemri wur worabe erukap. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ane kiyi taresin yabetem tame eme etep wobetem. Nema sipsip lakere tame. God ere nemne won yam. Ete tame eme tuma yikwokwobetem tame. Sipsip eme tuma yikwokwobetem tame etemri tuma beke meten tobo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aren an eru. Tatame eme ete eruke wur worate, eme noub temente. Sipsip eme wur woran top yenbo abekap, an emne etepke noub lakerebetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tuma yikwokwobe tame ere yate, ere sipsip sirke peten emne yaper nenen pen sate. An etepkap beke kip nen. An sipsip emne som noub lakerete yam. Eme noubwai som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","An sipsip lakerebe tame yenbo. Sipsip lakerebe tame yenbo ere sipsip emne kobo lan sate. An etepke tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Akeite tame eme sipsip lakeren kel petbe. Ete tame eme sipsip maime berai. Mousir wale eme sipsip emne tate yabe, ete tame eme lan aken sipsip emne mesginin amekirbe. Etep tete, mousir wale eme sipsip emne lelen eme amekirte. Kau eme emne tate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ete tame eme kelwou abobe, eme sipsip emne beke abo, eteke eme amekirbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","An etepkap beke nen. An sipsip lakerebe tame yenbo. Apei ere ane metten, an erne metten. Etepkap, an areri sipsip, areri tatame etemne metten, eme ane metten. An emne kobo lan sate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Akeite sipsip eme nowsel nogwapeke tetan. Etem kir eme areri. Gwopte eme areri tuma beke met. Yuri eme mette. An yin emne panen yate, eme arenken temente. Arenwou an emne noub lakerete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","An Apei erne etep wom. An sipsip emne kobo lan sate. Sate, an wou sene peten wayen yite. Etep wom, Apei ere ane metekwasbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tame eme ane pen sate, eme etemri porerek ane beke pen sa. An kir wote, eme ane ek pen sate. An mure eisau tetan. An sate wote, an sate. An wou sene peten wayen yite wote, an wou sene peten wayen yite. Apei ere ane etep tete wom. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Juda eme etep metem, eme tuma namdem, pekan kenakena tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tame nogwape eme etep wom. Gabo erne guleleten. Ere me belebe. Eri tuma nema beke kip sene met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Akeite tame eme etep wom. Berai. Gabo erne beke gulele. Gabo guleleten tame ere Jisas eter wobe tumakap mapeke wo. Gabo guleleten tame ere le si tame mapeke eyarte? Eme pekan kenakena tem, eke eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Juda tatame eme ege si yabel sou eisau Jerusalem komke tem. Kiyisape eme God eteri ake eisau sene keren wolem. Nabe wurarek eme ete yaku abon sou eisau tetbetete. Woru tebetem, eme ete sou tetbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisas ere God eteri ake eisauke wurim, ere Solomon eteri makle etek sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Etek sewurbetem, Juda tame eme erne yan erne etep wom. Ne nemne sekur sakur tuma som mane wote. Ne nemne tuma seken wote. God eter nene wom tame o? Ne nemne wote. Eme erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ere emne awosein etep wom. An kemne kiyi etep wom. An Krais. Etep wom, kem etep kenawaike beke met. Areri Apei ere ane wom yaku an gwote kerebe. Aren kerebe yaku e tatame emne peterabe, an Krais, God eter wom tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kerem, kem areri sipsip berai, etepkap kem ane kenawaike beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Areri sipsip eme ari tuma metbe. An emri sig wurare wurare metten, eme ari tuma meten tobobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","An emne wote, eme noub som temente. Yuri eme yaper beke kip te. An emne noub lakerebe, akeite tame eme emne beke kip peskarpet. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ete tatame eme ari sipsip. Ari Apei ere emne abon ane newom. Eri mure eisauwai. Akeite tame eme etepkap mure berai. Eke, Apei ere sipsip emne noub lakerebe, akeite tame eme emne mapeke peskarpet? ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nesa Apeiken nesa wurisubu. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Juda tame eme etep metem, eme pape sene peten Jisas erne seitin botkwun sate wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ere emne etep wom. God eteri rigrabe yenbo an kemne peterabetem. An be yaku yaper kerem, eke kem ane pape paku seitte nenbe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Eme erne awosein etep wom. Neri kerebetem yaku yenbo berai, eke nema nene pape paku seitte nenbe. Ne God eterne tuma yaperke wobetem. Ne nowselri tame, ne etep wobe. An God. Etep wobe, eke nema nene pap wayen pape paku seitin botkwun sate wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ere emne awosein etep wom. God eri siglou etepke basem. Kem wurare wurare, kem God eterkap. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","God ere eteri tuma yeiwarege emne newom. Ere emne etep wom. Kem arenkap. God eri tuma beke yikwokwo. Kiyisape eri tuma e tuma seken. Gwopte kir, eri tuma e tuma seken. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aren, God ere ane yaku newon won yam. An yam, an wobe. An God Eteri Yen. God eter womkap, an etep wobe. Kem ane etep woye. Ne God erne tuma yaper wobe. Beke kem etep wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","God ere ane wom yaku eke an kerebe. An eteri yaku beke pauk kere, kem ari tuma kenawaike beke kip met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kem ari tuma kenawaike beke met. An kemne wobe. An Apei eri rigrabe yaku kerebe, kem ete yaku noub late. Late, kem abote, Apei God ere arenken tetan, an Apei eterken tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Etep womke, eme erne sene keresukte abom, eke ere emne mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas ere Jordan peik keraruke sene wum, Jon ere tatame emne kiyi baptais ok wirubetem emik ere etek yin temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Temenemke, tatame nogwape eme erne late yim, eme etemwou etemwou etep wom. Kiyi Jon ere rigrabe beke nen. Jisas eter, ere rigrabe nenbetem. Jon ere Jisas eter nente wule nemne wusowum. Eri tuma e seken tem. Ere nemne tuma beke yikwokwo. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Etek temenem tatame nogwape eme Jisas erne kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tame wuri, eri sig Lasarus, ere kapoyi eisau meten tuknamenem. Eteri geisi pes epe Martaken Mariaken eme Betani komke temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Kiyi ete ta Maria te kwar peten Aneyen Jisas eteri tewo eli wuske sirem. Sirem, te etetri maime tare bila etek eteri tewo eli wus bandem. Ete ta teri nare, Lasarus, ere kapoyi eisau nenen tuknamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kapoyi eisau meten tuknamenem, geisi epe Jisas erne tuma etepke wopitim. Aneyen, neri tamenowu yenbo ere kapoyi eisau metye tuknaten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ere ete tuma metem, ere etep wom. Eri tetan kapoyi ere beke kip sa. Ere kapoyi meten tuknaten, eke tatame eme God eteri mure late. Late, eme God eri sig eisau wote, eme God Eteri Yen eri sig eisau kir wote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas ere Marta etetri mase Maria epri nare Lasarus emne pap yewom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pap yewom, Lasarus eri kapoyi eisau keyen tuknamenem, ere etep metem, ere agetage beke yi, ere yabel pes eter temenem emik som temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Etep tem, ere eteri anepoi tame emne etep wom. Nema Judia distrikke sene yite, Lasarus eter tetan komke yite. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Anepoi tame eme aken erne etep wom. Tuma wusoube tame, yeki Juda tame eme nene pape paku seitin botkwun sate wom. Ne beke ete emik sene yite wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ere awosein etep wom. Yabel pasbe, tame eme noub lan sewurbe. Emri tewo beke tebete. Aren keremken temente, kem yaper beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tame eme neirke bepou me sewurbe, emri tewo tebetebe, eme tuken berai, eke emri tewo tebetebe. Neir mak teketeten, nema yaku som kere. Eke nema Judia distrikke yin God eteri yaku kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ere etep womke, ere emne sene etep wom. Neremri tamenowu, Lasarus, ere bepou me tuknaten. An yin erne terete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Anepoi tame eme erne etep wom. Aneyen, ere bepou me tuknaten, ere yenbo meten wayen site. Beke ne erne yin terete? ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas ere metem, Lasarus ere sam, eke ere sekur sakur tuma etep wom. Lasarus ere me tuknaten. Anepoi tame eme sekur sakur tuma somo beke met. Eme abom. Lasarus ere bepou me kap tuknamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Etepkap, sene ere emne genik etep wom. Lasarus ere sam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ere sam, an eterken beke te, an metekwasbe. Sene an rigrabe nente, kem ane kenawaike ek abote, eke an metekwasbe. Nema erne yin late. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Etep womke, Tomas, eri akeite sig Peske Warwiyim Yen, ere akeite anepoi tame emne etep wom. Nema yite. Juda eme erne pen sate, nema eterken sate. Etep won eme ek yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Eme Betani komke yim, Jisas ere metem, Lasarus ere yabel epe pes epe pes sele meike temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani kom e Jerusalem kom mekinke tetan. Kelu gene kera, kilomita murwou. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jerusalem komri Juda tatame nogwape eme Martaken Mariaken epne kiyi yin lam, som etek temenem. Epne yin lam, etepri nare ere sam, eke eme epne kobo lan mokwo simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta te metem, Jisas ere yabetem. Etep metem, te erne kelu ep yekwo yim. Maria te beke yi, te akek som simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Yin lam, Marta te Jisas erne etep wom. Aneyen, ne gwotek temente wom, areri nare ere beke pauk sa. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","An nene kenawaike abobe. Be wos ne Apei God erne womette, ere etep nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ere tene etep wom. Nare ere sam, ere wou sene peten wayen site. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Te erne etep wom. Ye. Yuri nowsel yaper tete yabelke ere wou sene peten wayen yite. Ete yabel akei tatame eme wou sene pette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ere tene etep wom. Aren, an sabe tatame emne sele meike sene won wayekwutate. Aren, an emne wote, eme som noub temente. Ane kenawaike abobe tatame eme sate, emne an wou sene newote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tatame eme ane kenawaike abobe, eme som noub temente. Eme sene beke kip sa. Marta, ne areri tuma kenawaike metbe o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Te erne awosein etep wom. Ye. Aneyen, an neri tuma kenawaike metbe. Ne Krais, God eter wom tame. Ne God Eteri Yen. Kiyi God eri nowselke yate wom tame, e neren. Te etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta te etep womke, te Jisas erne mesginin sene yin mase tene elen tumak etep wom. Tuma wusoube tame ere yawo. Ere nerene wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria te etep metem, te agetage wayen teten erne yin lam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas ere Betani komke mak yin wurmenem, Marta etet erne yin lam emi ere etek som temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Juda tatame eme Maria etetken akek mokwo simenem, eme lam, Maria te agetage wayen teten kom genik yin wurim. Etep lan eme etep abom. Te kap sele ganke sene kerate yibe. Eke eme tene semowun yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria te Jisas eter temenem emik yin erne lam, te eteri tewo tobok gulke pan tare guromun keran erne etep wom. Aneyen, ne gwotek temente wom, ari nare ere beke pauk sa. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas ere lam, te kerabetem, tene panen yam Juda tatame eme kir kerabetem. Etep lam, ere pap yaper tem, ere emne kobo lam, ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","eke ere emne etep wometem. Kem erne mak rasem? Eme erne etep wom. Aneyen, ne yan la. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisas ere keram. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Keram, Juda tame eme etep wom. Ek la. Jisas ere Lasarus erne kenake abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kau eme etep wom. Kiyi ere le si tame eri le kuyese eyarem. Epkap, ere pauk Lasarus erne kobo late wom, Lasarus ere pauk beke sa. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas ere pap yaper sene tem, ere sele meike yam. Ete sele e kow puri. Eme sele mei eisau papek ragerem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisas ere etep wom. Kem pape sene gelkwun yin ganke raste. Etep wom, sam tame eteri geisi Marta, te etep wom. Aneyen, ere sam, yabel epe pes epe pes tem, eke eri kupa yabe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisas ere tene awosein etep wom. An nene kiyi woye. Ne ane kenawaike abote, ne God eteri mure eisau late nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Eme pape gelkwun yim, Jisas ere nelke nereyawon etep wom. Apei, ne ari tuma metbe, eke an nene pir wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","An metten, ne ari tuma kwokwos kwokwos metbe. An gwok tetyewoten tatame emne abobe, eke an etep wobe. Etepkap eme kenawaike mette, ne ane won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ere etepkap tuma won mesginin ere noubke etep wom. Lasarus. Ne epe yan wora. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Etep womke, sam tame ere ek yan woram. Woram, eri wusomken letewoken matek leimenem. Eteri bitimi kir matek leimenem. Jisas ere emne etep wom. Erne leiten mate kem ogwoyewon mesginin ere yi. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Juda tatame nogwape eme Maria teken temenem, eme lam, Jisas ere Lasarus erne wou sene newom. Etep lam, eke eme Jisas erne kenawaike abobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kau tame eme yin Farisi tame emne Jisas eter nenemkap wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wusowum, God eteri ake yaku kere tame emri apeilakeken Farisi tameken eme kaunsil tame emne wopeten wurisubuk sin tuma namdebetem. Eme etep wom. Ete tame Jisas ere rigrabe nogwape nenbe. Nema beke nente? ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nema erne beke kip wotake, tatame nogwape eme erne kenawaike abote nenbe, ere apeilake tete. Rom tame eme nemne panen siten, eme pap wayen ei nai tame gwotek won yan eme nemne pen sate, eme God eteri ake yenbo berayewote nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tame wuri Kaiafas, ete nabe ere God eteri akek yaku kere tame etemri apeilake temenem. Ere Kaunsil tame emne etep wom. Kem porere berai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Metye. Tame wuri ere sate, Juda tatame nogwape eme yenbo tete. Ere sate, nema yenbo temente. Etep wom. Ere abom, Jisas ere sate, Rom tame eme Juda tatame emne beke kip pe. Etep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiafas ere etep wom, ere eteri porerek beke wo. Ete nabe ere God eteri yaku kere tame etemri apeilake tame temenem, ere God eteri porerek wom. Eri wom tuma eri somo gwo. Jisas ere Juda tatame etemne kobo lan sate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ere Juda tatame etemwoune kobo beke lan sa. Ere eri yikwute yakwutem tatame etemne kir kobo lan sate. Etepkap, God eteri tatame, Juda tatameken Juda berai tatameken eme God eteri tame supawou tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ete yabel Juda apeilake eme Jisas eterne pen sate tuma namde rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Etep tem, Jisas ere Juda etemri kom komke sene beke yin sewur. Ere Betani mesginin Efraim komke yim. Efraim kom e boulke temenem. Etek yim, ere eteri anepoi tameken eme etek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juda etemri Pasova awos abetem yabel tete nenemke, tatame nogwape gene generi eme Jerusalemke yam. Pasova yabel pes temenem, eme yakwutebetem. Yabetem, kiyi eme God erne kwar pebetem, God ere etemri wule yaper peten sepitte. Ete Pasova wule eme etep tobobetem. Sene eme Pasova awos ek abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Eme Jerusalemke yam, eme Jisas erne sopbetem. Eme God eteri ake eisauke tetyewon etemwou etemwou namdebetem. Kem mapeke abobe? Kap Jisas ere Pasova wule kir yate, o ere beke kip ya? Eme etep namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kiyi God eteri akek yaku kerebetem tame etemri apeilake tameken Farisi tameken eme kiyi me pen tatame emne etep wom. Eike tatame eme Jisas erne metmente o lamente, eme nemne yan wusoute. Nema erne ake yaperke won wurte. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasova awos ate yabel mekin mekinem. Yabel ep yekwo let ep yekwo let ges wuri kei (6-pela) som temenemke, Jisas ere Betani komke yim. Betani e Lasarus eteri kom. Kiyi ere sam, Jisas ere erne wou sene newom, ere sene wayen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Etek yim, eme erne awos nenem, Marta te awos tiyewom. Tiyewom, teri nare Lasarus ere Jisas eterken akeite tameken tiyke sin awos etek abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Abetem, Maria te kwar ginken peten Jisas eteri tewo eli wuske siryewom. Ete kwar eme kel eisauke tukem. Siryewom, eke te etetri maime tare bila etek Jisas eri tewo eli wus etek bandem. Bandem, akek temenem tatame akei eme ete kwar bos yenbo metem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Metem, Jisas eri anepoi tame wuri, eri sig Judas Iskariot, ere Jisas erne yuri yena tem tame, ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Beke te etep nenbe? Ete kwar e kel eisauke tukbe wos. Ete kwar tame eme tukte wote, 300 kina eme peten wosken berai tatame emne newote woye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ere etep wom tuma ere wosken berai tatame etemne beke abon etep wo. Berai. Ere sir petbe tame. Ere kel yewobetem ayer lakerebe tame, eke ere ete kel sirke pette abom, eke ere etep yikwokwom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jisas ere erne etep wom. Ne tene tuma mane wote. Te tame kupa kerebe wule ane peteraye. Etep wom. Juda etemri tame kupa kerebe wule eme tame kupa kwar pen ek pape purik rasbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Jisas ere sene etep wom. Wosken berai tatame eme keremken som temente. Kem emne kuyese tewok tewok yenbo nenbetete. Aren, an keremken som beke kip te, eke te ane yenbo nenye. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Juda tatame nogwape eme metem, Jisas ere Betani komke temenem, eme erne yin lam. Eme Jisas eterwoune beke yin la. Jisas eter wou sene newom tame, Lasarus, eme erne kir late yikwutem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lasarus ere wou sene petem, Juda tatame nogwape eme etep lam, etepkap eme Jisas eterne kenawaike abom. Abom, eme God eteri ake yaku kerebetem tame etemri apeilake emne mesginin Jisas erne semowum. Etep tem, God eri akek yaku kerebetem tame emri apeilake eme Lasarus erne kir pen sate wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kwokwos tatame nogwape eme metem, Jisas ere Jerusalemke yate wom. Ete tatame eme kiyi Pasova awos ate etek yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Etep metem, eme tewo teya take kayen sen yin Jisas erne keluke late yim. Yim, eme etep som som tebetem. God ere yenbowai. Eteri sigke yam tame, nema erne pir wobe, eri sig eisau wobe. Ere Israel etemri Keryen. God ere erne noubwai nente. Eme etep tebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas ere donki por yen wuri lan peten eteri magel luke yawon sin yabetem. God eri kiyi temenem tuma siglouke etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jerusalem komri tatame, kem mane akte. Ek la. Keremri Keryen ere yabe. Ere donki yen eteri magel luke siye yabe. Etek basem tuma ete yabel ere seken tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Eri anepoi tame eme ete tuma somo mak metmenem. Yuri Jisas ere sam, ere wou sene peten God eteri komke yawomke, eme God eteri siglou tuma sene abopitin etep wom. Ye. God eteri siglou etep tete wom. Tatame eme erne etep tete wom. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jisas ere Lasarus erne sele meike wopeten wou sene newom, etek lam tatame eme sene kau tatame nogwape emne etep wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Eme metem, Jisas ere rigrabe nenem, eke nogwape eme erne keluke lan yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Etep tem, Farisi tame eme etemwou etemwou etep wom. Kem laye. Nema erne nenlawoyim. Ek la. Sene tatame nogwapewai eme erne semoube. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kantri Grikri tame kau eme Jerusalemke temenem. Eme Pasova awos ate yam, em God erne sukye worate yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","E Grik tame eme Jisas eteri anepoi tame Filip erne etep wometem. Metye. Nema Jisas erken tuma namdete abobe. Filip ere Betsaida komri tame. Betsaida e Galili distrikke tetan kom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Etep wom, Filip ere Andru erne yin wusowum, sene Andruken Filipken epe Jisas erne wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Wusowumke, ere epne awosein etep wom. An Tatame Etemne Lan Yeirim Tame. Mekin mekinye God ere ari sig eisau wote nenbe. Eme ane pen sate, an sig eisau ek pette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","An kepne sekenke wobe. Tatame eme kwoi nawo wuri bepou me berbe, om beke yi. Ete kwoi nawo bepou me temente. Eme kwoi nawo wuri peten beren kupoite, eter om sene nogwape yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tatame eme kwoi nawokap. Tatame eme maime wuswou abote, yuri eme yaper tete. Tatame eme maime beke abo, eme nowselri wos beke abo, yuri ete tame eme noub som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tatame eme ari yaku kerete aboye, eme ari tuma mette. Ari yaku kerete tatame eme aren yite emi etek yin temente. Tatame eme ari yaku kerete, ari Apei ere emne tatame yenbo wote. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisas ere sene etep wom. An pap yaper teye. An mapeke wo? Kapken, an etep wote. Apei, ne ane kobo late. Eme ane mane kip pen sate. Berai. An etep beke kip wo. An eteke yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Apei, neri sig eisau tete, e yenbo. Etep womke, tuma ape wuri Hevenke yan etep wom. Kiyi ari sig eisau temenem, sene etep som temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Etep wom, etek tetyewomenem tatame eme ete tuma ape kir metem, kau eme etep wom. E mou toboke pebe. Kau eme etep wom. God eteri kom tame ere Jisas erken tuma namdeye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisas ere awosein etep wom. E Hevenke yawo tuma arene beke wo. Ere kemne wobe. Eke kem porere yenbo pette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mekin mekinye, God ere tatame emne sin late. Mekin mekinye, ere nowselri apeilake, Satan, erne teitkwunte. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tame eme ane keresukun mek kwanen nenewayen yeworute. Yuri aren, an tatame nogwape emne pette nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Eme erne pen sate wule, Jisas ere etep abon eke wom. Eme ane mek kwanen nenewayen yeworute. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tame nogwape eme erne awosein etep wom. Nema metten, Moses eri wule etep wobe. God eter wom tame, Krais, ere som temente. Ere beke sa. Etep wobe, beke ne etep wobe, eme Tatame Etemne Lan Yeirim Tame erne mek kwanen ere sate? Tatame Etemne Lan Yeirim Tame ere eike? ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisas ere emne etep wom. An keremken tetan, an tukap kerebe. An tatame emne porere yenbo newote yam. An keremken kerake temente. Gwote tu an kerebe, kem porere yenbo petbe. Yuri an yite, e neir teketebekap. Neir teketete, kem porere yenbo mapeke pet? Neirke sewurbe tame kelu yenbo eme me belebe. Kerake tete, an kemne mesginen yite. Etep tetek, kem ari tuma mapeke met? ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","An gwok tetan, kem ane kenawaike abote. Kem ane kenawaike abote, kem porere yenbo pette, etepkap kem areri wakse tete. Jisas ere emne wo mesgin, ere yin berasem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kiyi ere rigrabe nogwape nenbetem, tatame nogwape eme etep lam, eme erne kenawaike beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kiyisape God eteri tuma wusoubetem tame wuri, Aisaia, ere etep basem. Aneyen, neri tuma nema tatame emne wusoube, eme kenawaike beke abo. Eme neri mure eisau labe, eme nene beke abo. Etep basemkap, Juda tatame nogwape eme etep tebetem, eme kenawaike beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Aisaia ere sene etep basem. God ere wom, emri le yaper tem, emri porere yaper tem. Etep temenem, eme noub beke kip la. Emri porere eme noub beke kip abo. Etepkap, eme God eteri tuma kenawaike beke kip met. Kenawaike beke met, God ere emne noub beke kip nen. Etep basemkap, Juda tatame nogwape eme God erne noub beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kiyi Aisaia ere siglou basbetem, ere metmenem, yuri Jisas ere keryen eisau tete. Ere etep metmenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tatame nogwape eme Jisas eterne kenawaike beke abo, nogwape eme erne selpapwouke kenawaike abom, eme genik beke wusou. Kau Juda apeilake eme kir, eme erne selpapke kenawaike abom. Farisi tame eme kiyi etep wom. Eike tatame eme Jisas erne kenawaike abote, nema emne God eteri akek beke kip won wurin God erne sukye wora. Etep womke, tatame nogwape eme aken Jisas erne selpapwouke kenawaike abobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Eme selpapke abon etep wom. Farisi eme nemri sig yaper mane wote. Etep wom, God ere emri sig yenbo wote, eme beke abo. Tame etem, eme emri sig yenbo wote, eme eteke abobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas ere noubke etep wom. Tame ere ane kenawaike abobe, ere arenewou beke kenawaike abo. Ere arene won yam Apei eterne kir kenawaike abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tame ere ane laten, ere arene won yam Apei eterne kir laten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","An tukap tobukbe. An nowselri tatame emne selpap porere yenbo newote yam. Eike ane kenawaike abobe, eme selpap porere yenbo pette. Eme kerneirike beke te. Eme yabel geinik temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tame eme areri tuma wanwouke meten beke tobo, an emne tuma beke namde. An nowselri tatame emne tuma namdete beke ya. Berai. An tatame etemri nenbetem yaper wos peten sepitte yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Eike ane magel tayen areri tuma naswoite, eme yaper tete nenbe. Yuri nowsel yaper tete yabel, an emne awosein yaper ek nente nenbe. Eme ari tuma beke met, etepkap an emne yaper nente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Areri selpapke an kemne beke wo. Berai. Ane won yam Apei eter wom tuma an kemne wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","An metten, God ere etep wom. Tatame eme ari tuma noub meten tobote, eme som noub temente. Etep wom. An eterke metem tuma an kemne etep wobe. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova a ate yabel kwokwoske tete wom, Jisas ere etep abom. Ari peiktame eme ane pen sate yabel mekin mekinye. Eme ane pen sate, an nowsel mesginin Apei erne sene yin lan eterken temente. Etep abomke, ere eterne kenawaike abobetem tatame emne kobo lan negwonegwon ere me sam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisas eter, anepoi tameken eme perpe a sin abetem. Kiyi Satan ere Judas Iskariot, Saimon eteri yen, erne porere yaper newon etep wom. Judas, ne Jisas eteri peiktame emne kobo lan eme Jisas erne pen sate. Kiyi etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","A sin abetem, Jisas ere etep abom. God ere wom, an keryen eisau tem. Ere ane won yam, an eterne sene yin lan eterken temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Etep abomke, ere a an omon wayen tetem. Wayen tetem, ere eri tame oub lugrasen taul lagwubai peten moutip sim. Yaku kere tame etem tebekap ere etep tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sene ere ok yubu eisauke siren eri anepoi tame emri tewo tasen ok keyabetem. Ok keyabetem, ere eteri moutip simenem taulke megke etemri tewo etek sakitbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Emri tewo wurare wurare ok keyan yibetem, ere yan Saimon Pita eteri tewo ok keyate wom. Pita ere abolawoyin erne etep wom. Aneyen, ne keryen, ne ari tewo ok mane keyate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ere erne awosein etep wom. Ari nenbekap ne noub beke abo. Yuri ne abote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita ere erne wotaken etep wom. Ne areri tewo mane keyate. Jisas ere erne awosein etep wom. An neri tewo beke kip keya, ne ari wakse beke kip te. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita ere Jisas eri wakse tete abom, eke ere etep wom. Aneyen, etepkap ne ari tewowou mane ok keyate. Ne ane akei wirute. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisas ere erne etep wom. Tame ere ok kiyi wiwo, eri wus yenbo teye, ere ok sene beke wi. Eteri tewowou kerkera teye, ere tewowou ok keyate. Kem nogwape kem yenbo tetan. Keremri wuri ere yenbo beke te. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas ere etep abom. Ari anepoi tame wuri ere ane yaper nente. Etepkap ere etep wom. Kemri wuri ere yenbo beke te. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas ere emri tewo akei ok keyan ere eri tame oub sene warem. Waren ere wolbayek sene yin sin emne etep wom. Aren kemne nenyekap kem aboye o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kem ane tuma wusoube tame wobe, kem ane Aneyen wobe. Kem etepkap wobe, e yenbo. An etepkap. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Aren an keremri tuma wusoube tame. Aren, an keremri Aneyen. An yaku kere tamekap ten keremri tewo ok keyaye. Etepkap, kerem kir, kem yin keremwou keremwou tewo ok etepke keyate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","An kemne wule yenbo peteraye. Yaku eisau kerebe wulekap, yaku nebule kerebe wulekap an kemne akei eyi peteraye. Aren keremne nenyekap, kem etep tewok tewok yin nenbetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","An kemne sekenke wobe. Kem noub met. Yaku kere tame eme apeilake tame eteri kulke temenbe. Emne won yibe tame eme emne won yibe tame eteri kulke tetan. An kemne won yibe, kem ari kulke tetan. An keremri apeilake tame, an yaku nebule kir kerebe. An yaku nebule bul beke woran, mo wo. An kemne wobe, kerem kir kem yaku eisau kerebetete. Kem tatame emne kobo labetete. Aren nenbekap, kem etep kir nenbetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kem ete tuma noub metye. Sene kem etep nenbetete, kem metekwasbet. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Keremri wuri ere ari tuma beke met. An erne beke kene. God eteri siglou etep wobe. Arenken awos am tame wuri ere ane yaper nenem. Etep wobe tuma ere seken tete nenbe. Ete tame ere etep tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","E yurik tete nenbe wos, eke an kemne gwopte wusoube. Ete tame ere etep nente, kem kenawaike abote. An Krais, God eter won yam tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","An kemne sekenke wobe. Tame eme ari won yim tame emne pap yewobe, eme ane kir pap yewobe. Ane pap yewobe tame eme ane won yam Apei eterne kir eme pap yewobe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas ere etep won ere pap yaper meten sene ere emne etep wom. An sekenke wobe. Kemri wuri ere ane yena tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Etep wom, anepoi tame eme etemwou etemwou lek nereyi nareyan etep wometem. Eike etep tete nenbe? Jisas ere eikene wobe? Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jisas ere anepoi tame wuri erne kenake metekwasbetem, ete tame ere eteri ganke simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pita ere erne lek neisen etep wom. Ne erne etep womette. Ere eikene wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ere Jisas eterken mekinke yin etep wometem. Aneyen, eike nene peiktame etemri letke raste nenbe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisas ere awosein etep wom. An geil peten mwak sogwunen ete tame erne newon ate. Etep won ere geil mwak sogwunen, Saimon eteri yen, Judas Iskariot, erne newom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas ere ete geil petem, agetage Satan ere erne gulelem. Jisas ere erne etep wom. Neren nente wos, ne agetage yin nente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Etep wom, a abetem tame eme Jisas eter Judas erne wom tuma somo eme beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kau eme etep abom. Judas ere neremri kel yewobe ayer lakerebe tame. Kap, Jisas ere erne won ere awos tukte, o kap ere erne won ere wosken berai tatame emne kel newote wobe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas ere geil peten agetage ere wurim. Etep tem, e neir teketemenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ere yimke, Jisas ere etep wom. An Tatame Etemne Lan Yeirim Tame. Gwopte ari mure eisau genik teye. Gwopte God eteri mure eisau arenke geni teye. Eri sig eisau tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","God ere sig eisau arenke tete nenbe, eterke an sig eisau pette. Kerake tete, ere etep nente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ari yen, an kerake keremken temente. An yite, kem ane soplawoite. An Juda emne kiyi womkap, an kemne kir wobe. Aren yite emi kem etek kuyese beke yi. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","An kemne wule ager newobe. Kem awoawo pap yewon noub nenbetete. Aren kemne pap yewon noub nenbekap, kem etep keremwou keremwou awoawo pap yewon noub nenbetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kem keremwou keremwou pap yewon noub nenbetete, akeite tatame eme etep lan wote. Eme Jisas eteri wakse. Eme etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jisas ere etep womke, Saimon Pita ere erne etep wometem. Aneyen, ne mak yite nenbe? Ere awosein etep wom. Aren yite nenbe emi gwopte ne etek kuyese beke kip yi. Yuri ne etek yite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita ere erne etep wometem. Beke an gwoteptek kuyese beke kip yi? An nereken sate, e yenboke. An beke kip ak. ");
INSERT INTO yss_yawu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisas ere awosein etep wom. Gwopte neir ne aken etep wote. An Jisas erne beke met. Etep wote. Gwopte kwokwo mak womentek, tewo mur ne ari sig berasen etep wote nenbe. An Jisas erne beke met. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas ere eri anepoi tame emne etep wom. An yite, kem pap yaper mane tete. Kem God erne kenawaike abobetete. Kem ane kir kenawaike abobetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ari Apei eri kom nogwape ake etek tetan. An kemne beke tuma yikwokwo. An etek yite, an kemne ake eyarte yite nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","An kemne ake kiyi yin ake eyaren an sene yan kemne panen ek yite. Aren temente kom kem kir arenken etek temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aren yite kom kem kelu etep laten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas ere erne etep wolam. Aneyen, neren yite nenbe kom nema beke la. Etepkap nema kelu kir beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisas ere erne etep wom. Aren, an kelu. Aren, an God eteri tuma seken wobe. Arenke tatame eme Apei eterke yin som noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kem ane noub abote, kem ari Apei erne kir noub abote. Gwopte kem erne abobe, kem erne metten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip ere erne awosein etep wom. Aneyen, ne nemne Apei erne peterate. Nema erne late, nema pap yenbo mette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas ere erne awosein etep wom. Filip, yabel nogwape an keremken temenem, ne ane beke abo. Tame eme ane kenawaike abobe, eme Apei erne kir kenawaike abobe. Beke ne etep wobe, an Apei erne kemne peterate? ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","An Apei eterken tetan. Apei ere arenken tetan. Ne etep metten o? An kemne wobe tuma e ari selpapri tuma berai. God ere ari selpapke tetan, eke an eteri tuma wusoube, an eteri yaku kerebe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","An Apei eterken tetan, Apei ere arenken tetan. Kem etep kenawaike abote. Kem etep kenawaike beke abo, kem aren kerebe yaku eisau latek, eteke kem kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","An kemne sekenke wobe. Kem ek met. Tatame eme ane kenawaike abobe, aren kerebe yaku eisau eme kir etep kerete. An Apei eterke sene yite, etepkap eme yaku eisau kerete nenbe. Ari kerebe yaku e eisau berai. Eme kerete nenbe yaku e sikilewai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Be wos kem Apei God eterne womette, kem arene kir kenawaike abon ek womette. Womette, an etep nente nenbe. Etepkap areri murek Apei ere sig eisau pette nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kem be wos areri sigke womette, an nente nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jisas ere etep wom. Kem ane pap noub yewote, kem ari tuma noub meten tobobetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","An Apei erne wolate, ere kemne Kobo Labe Tame erne won yate. Ete tame ere keremken som temente, ere kemne kobo labetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ete tame ere God Eteri Wou. Ere God erne noub laten, eke ere kemne God eteri tuma seken wote. God erne kenawaike beke abo tatame eme God Eteri Wou erne beke la, erne beke met. Eke eme erne pap beke yewo. Kem God erne kenawaike abobe tatame, kem God Eteri Wou erne metten. Gwopte ere keremken tetan. Yuri ere keremri selpapke temente, eke kem erne metten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","An kemne beke mesgin, kem kuwo yenkap beke te. An yite, an kemne sene yan late. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kerake tete, nowselri tatame eme ane sene beke la. Kerem, kem ane sene late. An som noub temente, etepkap kerem kir kem som noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","An wou sene pette yabel ete yabel kem kenawaike etep abote. Ere Apei eterken tetan, nema eterken tetan, ere neremken tetan. Ete yabel kem etep kenawaike abobetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ari wom tuma peten noub metbe tatame eme ane pap yewobe. Ane pap yewobe tatame emne ari Apei ere emne pap yewote. Aren kir an emne pap yewon ari tuma an emne wote. Eme ane noub mette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Akeite Judas, Judas Iskariot eter berai, ere Jisas erne etep wometem. Aneyen, mapeke neremwou nema nene noub mette, akeite nowselri tatame eme nene noub beke kip met? ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas ere erne awosein etep wom. Eike tatame eme ane pap yewote, eme ari tuma meten tobote. Etep tete, ari Apei ere emne pap yewote, nesa Apeiken nesa yan etemken temente. Ane kenawaike beke kip abo tatame eme etep beke kip la. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Eike tatame eme ane pap beke yewo, eme ari tuma beke meten noub tobo. Etepkap eme ane noub beke met. Metye. An kemne wobe tuma e areri tuma berai. E Apei eteri tuma. Ere ane won yam, an eteri tuma wusoute wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Gwopte an keremken teten, an kemne tuma wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","An yitek, God ere Eri Wou erne won yate. Aren kemne wusoubekap, ere kemne etepke wusoubetete. Ari wule ere kemne noub peterabetete. Akeite wos ere kemne wusoubetete. An kemne kiyi wusoubetem tuma ere kemne porerek newote, kem sene abote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","An yite, selpap yenbo metbe wule an kemne newote. Nowselri tatame newobekap an beke kip newo. An kemne areri selpap yenbo metbe wule seken kemne newote. Eke kem mane ep abo ep abon akte. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","An yite, an kemne sene yan late. An etep kiyi wusowum, kem metem. Beke kem ep abo ep abobe? Apei ere ari Keryen, an erne late yite nenbe. Kem ane pap yewote, kem metekwaste, kem ari Apei eterke sene yite. Apei ere epiye tetan, an eteri kulke tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","An yite, an kemne etep kiyi wusou. Yuri an yite, kem etep abote. Ere nemne kiyi womkap, ere etep nenye. Nema eri tuma kenawaike metbe. Kem etep abote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","An keremken tuma som beke kip namde. Nowselri tatame etemri apeilake Satan ere kelu yabe. Areri peiktame eme ane keresukte yabe. Keresukte, kem mane akte. Eme ane beke kip teitkwun. ");
INSERT INTO yss_yawu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","An Apei erne abobe, etepkap an eri tuma meten tobobe. Etep tebe, nowselri tatame eme late, an Apei erne abobe. Yau, nema yite. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas ere eri anepoi tame emne etep wom. Me wuri tetan. Ari Apei ere me maime. Aren an me nawobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ane abobe tatame eme ari ku letewokap. Supa beke ya ku, letewo, Apei ere yan kayen petewarte. Eme God eteri tuma beke meten tobo, eke ere emne kayen petewarbe. Supa yabe ku, letewo Apei ere take yaperwou bwanen eyarbe. Eyarbe, eke sene eme supa nogwape yabe. God eri tuma meten tobobe tatame emne ere etep nenbe. Nenbe, sene eme eteri yaku noub kerebe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Me take yaper bwanen eyarbekap, an kemne wobetem tuma e kemri selpap noub eyarbetem. Eke, kem noub tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kem arenken temente, an keremken temente. Nawobe berai me ku, letewo eme supa beke kip ya. Kem etepkap mane tete. Kem arenken temente, kem wos yenbo nogwape ek nente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","An me nawobekap. Kem me ku, letewokap. Tatame eme arenken temente, an etemken temente, eme supa nogwape yabetete. Eme yenbo wos nogwape nenbetete. Kem ane mesginin, kem kena wiwi temente, kem yenbo wos mapeke kip nen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tatame eme ane mesginte, eme kayen petewarbe me ku, letewokap. Kayen petewarbe, eme sok tebe. Sene eme emne wurare wurare nugen kerke liste. Eme etepkap. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kem ane beke kip mesgin, kem areri tuma noub tobote, be wos be wos kem abobe, kem ane wolate. Wolate, an kemne ek newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Metye. Awos supa nogwape yate, now lakerebe tame ere sig eisau tete. Kem nogwape wos yenbo nente, Apei eri sig eisau tete. Tatame eme etep lan wote. Kem God eteri wakse. Eme etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Apei ere ane pap yewobekap, an kemne etepke kir pap yewobe. An kemne pap yewobe, kem ane mane mesginte. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","An Apei eter wobetem tuma wan wurik metbetem, eke ere ane som pap yewoten. Kem ari wobe tuma wan wurik meten tobobetete, etepkap an kemne pap som yewote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","An kemne etep wusouye, etepkap kem metekwaste. Aren metekwasbekap, kem etepke metekwaste. Kem kenake metekwaste, an etep abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","An kemne wobe. Aren an kemne abon pap yewokap, kem keremwou keremwou etepke abon pap awoawo yewote. Kem etep tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Eike tatame eme emri tamenowu abon kobo lan sate, eme pap yewobe wule eisau sebe. Akeite pap yewobe wule etepkap eisau berai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ari wote tuma kem wan wurik mette, kem areri tamenowu seken tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sene an kemne yaku kere tame beke kip wo. Yaku kerebe tame eme yaku lakerebe tame etemri porere beke met. An kemne tamenowu seken wobe. Tamenowu eme emri nowu emri porere noub metten. Apei ere wom tuma an kemne akei wusowum, etepkap an kemne tamenowu seken wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Metye. Kem ane beke kene. Aren an kemne kenem, eke kem yin wule yenbo nenbetete. Kerem nente wule yenbo e yaper beke kip te. An kemne etep wom. Kem etep tete, Apei ere kemri tuma mette. Be wos be wos kem erne wolate, kem ane kir kenawaike abon wolate. Etep tetek, ere kemne ek newote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","An kemne wobe. Kem keremwou keremwou pap som yewobetete. Kem etepke tete. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jisas ere eri wakse emne etep wom. Nowselri tatame eme kemne pap wayen pik pete. Eme ane kiyi pik pete. Eme kemne mo wote, kem abote. Eme ane kiyi mo wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kem nowselri tatame etemri selpapke temente wom, eme pauk kemne abon noub eyarte wom. An kemne kenem, kem ari wakse tem. Sene kem nowselri tatamekap berai. Etepkap, eme kemne eke mo won pap wayebe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","An kemne kiyi wom tuma, kem sene abote. Kiyi an etep wom. Yaku kerebe tame ere yaku lakerebe tame eri kulke tetan. An kemne kiyi etep wom. Kem ari yaku kerebe, etepkap nowselri tame eme ane mo won yaper nenemkap, eme kemne kir mo won yaper nente nenbe. Kau eme ari tuma meten tobobetemkap eme kemri tuma kir meten tobote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ane won yam tame erne nowselri tatame eme erne beke met. Kem ari wakse, etepkap eme kemne etepkap etepkap wule yaper nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Aren an beke pauk yan tuma wusou, wule yaper beke pauk te. Eme ane lan metem, etepkap eme mapeke etep wo? Nema erne beke la, nema erne beke met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tame eme ane mo wobe, eme areri Apei erne kir mo wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","An nenbetem rigrabe akeite tame eme beke nen. An etep beke pauk nen, eme emri wule yaper beke pauk abo. An rigrabe nenbetem, tatame eme etep lam, eme ane kenawaike beke abo, eme arenken areri Apeiken nesetne mo wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Emri basten wule etep wobe. Bepou eme ane mo wobe. Etep basmenem tuma ere seken teye. Gwopte eme etep tebe, eme ane bepou mo wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Metye. God Eteri Wou ere Apei God eterken tetan. An yin erne won yate. Ere kemne Kobo Lan Porere Newobe Tame, ere kemne kobo late. Ere kemne tuma seken wusoute, ere kemne arene noub wusoute, kem ane noub mette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kerem kir, kem tatame emne ane wusoute. An ari yaku tasen kerem, kem arenken temenem. Etepkap kem arene emne wusoute. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas ere eri anepoi tame emne sene etep wom. Yaper wos kemne tete, kem kenawaike som abote. Kem ari wule mane mesginte, eke an kemne wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yuri eme kemne wotaken etep wote. Kem God eteri akek mane sene wurte. Etep wote. Sene eme kemne pen san etep wote. Nema emne pen sabe, nema God eteri yaku yenbo kerebe. Eme etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ete tatame eme Apei erne beke met, eme ane beke met, eke eme kemne yaper nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","An kemne wusoube tuma e yurik tete nenbe. Yuri tetek, kem sene etep abote. Aneyen ere nemne etep kiyi wom. Etep abote. An keremken temenem, eke an kemne ete tuma kiyi beke wusou. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Arene won yam tame eterne an sene yin late nenbe. Kemri wuri beke ane etep womet. Ne mak yibe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","An kemne etep woye. An Apei erne yin late. Etep woye, kem metye, kem pap yaperwai teye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","An kemne sekenke wobe. An kemne abobe, eke an yite nenbe. An beke kip yi, God Eteri Wou ere kemne beke kip ya. Aren yitek, an erne ek won yate. Ere keremne Kobo Labe Tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ere yate, ere nowselri tatame emne tuma seken noub etep peterate. Emri nenbe wule yaper ere emne maime peterate, sene ere wule yenbo emne kir peterate. God ere tatame emne tuma namdete wule ere emne kir peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yaper tebe wule ere gwopkap. Nowselri tatame eme ane kenawaike beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yenbo nenbe wule ere gwopkap. An tatame etemri yaper woske sate. Sene an wou peten wayen Apei God erne yin late. An yin an eterken temente, kem ane beke kip la. Tatame eme etep kenawaike abote, eme selpap yenbo pette. E wule yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tuma namdete nenbe wule ere gwopkap. Nowselke panen siten tame, Satan eterne God ere kiyi tuma namden, erne pen sate wom. God erne kenawaike beke abo tatame emne God ere etepkapwou tete nenbe. E tuma namdete nenbe wule. God Eteri Wou ere kemne etep peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Tuma nogwape an kemne wusoute abobe. Gwopte kem ete tuma kuyese beke kip met, etepkap an kemne beke kip wusou. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yuri God Eteri Wou ere yate, ere kemne wos seken peterate. Ere akei wos seken peterate. Ere eteri porerek beke kip wo. God ere erne wusoube tuma ere kemne etepwou wusoubetete. Yuri tete wos ere kemne kir wusoubetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ari tuma ere kemne wusoubetete. Wusoubetete, etepkap ere ane sig eisau newobetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Apei eri tetan nogwape wos e areri wos. Etepkap, an kemne woye. God Eri Wou ere areri wos peten kemne peterate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jisas ere emne sene wom. Kerake tete, kem ane sene beke kip la. Sene epkera tetek, kem ane sene ek late. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kau anepoi tame eme etemwou etemwou namden etep wom. Beke Jisas ere etep wobe. Epkera tete nema erne sene beke la. Sene epkera tetek, nema erne ek sene late. Beke ere epkap wobe, an Apei erne yin late? ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Beke ere etep wobe, epkerake tete? Nema eri wobe tuma somo beke met. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Eme Jisas erne tuma somo womette abom. Jisas ere emri porere lan emne etep wom. An woye. Epkera tetek, kem ane sene beke la. Sene epkera tete, kem ane sene ek late. Ete tuma somo kem beke met, eke kem keremwou keremwou wometbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","An kemne sekenke wobe. An yite, kem keran mokwo site nenbe. Kem mokwo site, nowselri tatame eme metekwaste nenbe. Kem pap yaperwai mette, sene kem metekwaste nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ta te yen warwite, te mus eisau meten pap yaper tebe. Te yen warwiyin, sene te pap yenbo mette. Te teri yen metekwaste, te metem mus te sene beke kip abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kerem kir, gwopte kem pap yaper metbe. Yuri an kemne sene late, kem pap yenbo meten kem metekwaste nenbe. Tame wuri ere kemri metekwasbe wule beke kip wotake. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ete yabel tete, kem arene wos sene beke kip womet. Sene kem Apei erne womette. Be wos be wos kem erne womette, kem ane kir kenawaike abon erne womette. Womette, ere kemne ek newote nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kiyi kem areri sigke wos wuri beke womet. Sene kem areri sigke wometbetete, eke kem pette nenbe. Etepkap kem metekwaswaite. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jisas ere eri anepoi tame emne etep wom. An kemne sekur sakur tuma woye. Yuri an kemne sekur sakur tuma beke kip wusou. An Apei erne kemne genik wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","God Eteri Wou ere yate, kerem kem Apei erne womette, kem ane kir kenawaike abon ek womette. An kemne etep beke wo, aren an Apei erne wometen ere kemne kobo late. Berai. Kerem, kem erne kena womette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Apei God eter ere kemne abon pap yewobe. God ere ane won yam. Kem etep kenawaike metbe, kem ane abon pap yewobe, eke Apei ere kemne abon pap yewobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ye. Apei eteri kom an mesginin nowselke yam. Sene an nowsel mesginin Apei eteri komke sene yite nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Eteri anepoi tame eme erne etep wom. Ye. Gwopte ne nemne tuma somo genik wusoube. Ne sekur sakur tuma beke wo. E yenbo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ne akei wos metten. Gwopte nema etep metye. Nema neri tuma kenawaike metbe, nema nene tuma sene beke kip womet. Ne God eteri kom mesginin yam, nema etep noub meten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisas ere emne etep wom. Gwopte kem kenawaike abobe o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Metye. Gwopte neir kem akei kem amen yikwute yakwutete nenbe. Kem keremri akek yite. Kem ane mesginte, an kena wiwi temente. An kena wiwi beke kip te. Apei ere arenken som temente nenbe. Ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","An abobe, kem arenke pap yenbo temente. Eke an kemne etep woye. Kem nowselke temente, be wos be wos yaper kemne tete. An nowselri wule teitkwunem. Kem mane ep abo ep abote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas ere won mesginin ere sate yabel mekin mekinmenem, ere nelke nereyawon etep wom. Apei, ne wom yabel mekin mekinye. An Neri Yen. Ne ane mure newote. Newote, an neri yaku kuyese kerete, neri sig eisau ek tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ne wom, an keryen eisau tem. Nowselri tatame nogwape eme ari kulke tetan. Etepkap an wote, ne ane newom tatame eme som noub temente. Eme ari wakse, an emne etep nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nerenwou ne Keryen God seken. An Jisas Krais, ne ane won yam. Tatame eme nesetne kenawaike abote, eme som noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","An gwo nowselke temenem, neri womkap akei an nenen omom. Eke neri sig eisau tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Apei, kiyi ne nowsel mak seikmenem, an nerenken temenem. Nesa adebas emi yenbok temenem, nesa noubwai temenem. An nene wometbe, nesa kiyi temenemkap, nesa etep sene temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kau nowselri tatame eme nereri yen. Ete tatame ne emne arene newom. Newom, an nereri tuma emne wusowum, eme neri wule noub seten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sene eme metem, nogwape wosken neri wuleken mureken ne akei arenke newom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Neren ane wom tuma an emne etep kenake wusowun eme ete tuma kenawaike abom. Kiyi ne ane won yam, an neri kom mesginin yam, eme etep kenawaike metbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ete tatame an emne abon nerenken namdebe. An kenawaike beke abo tatame emne an beke abon nerenken beke namde. Ne ane newom tatame etemnewou an abon nerenken tuma namdebe. Eme nereri yen, eke an emne abon nerenken tuma namdebe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ari wakse eme nereri. Neri yen eme areri. Etemke an sig eisau petbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","An nowsel sene mesginin nene late yabe. Ne ane newom tatame etem eme nowselke som temente. Ne Apei yenbowai. Nereri mureken sigke ne emne noub lakerete. Ete sig ne ane newom. Neset tetan selpapken porereken wurisubu, eme etep kir temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ne ane newom sig, e mureken sigke an emne noub lakerebetem. Eme nene beke mesgin. Neri siglou kiyi womkap, tame wurisubu eterwou ere nene mesginin yaper tem. Neri tuma seken tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","An nerene late yabe, an kenake metekwasbe. An nowselke som tetan, an emne etepke wusoube. Eke kenake metekwasbekap eme etepke kir metekwaste. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Neri tuma an emne newom, eme kenawaike meten nowselri wule mesginim. An nowselri tame berai. Etem kir, eme nowselri tame berai. Etepkap, nowselri tatame eme emne mo won pap wayebe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","An nene etep beke kip womet, ne emne peten eme nowsel mesginte. Berai. An wometbe, ne emne noub lakeren ei simente, eke, tame yaper, Satan, ere emne yaper beke kip nen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","An nowselri tame berai. Eke etem kir eme nowselri wule mesginim, eme nowselri tatame berai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Neri tuma e sekenwai. Neri tuma sekenke ne emne eyarte, eme neri yen yenbowai tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ne ane won nowselke yam, an neri tuma wusoubetemkap, an emne won yibe, eme neri tuma wusoubetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","An emne kenake abobe, eke an akeite wos beke kip abo. Etepkap eme neri wakse seken tete. Eme akeite wos beke kip abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","An areri anepoi tame etemwoune kobo late beke womet. Tatame eme etemri wusoute nenbe tuma meten, eme ane yuri kenawaike abote, ete tatame an nene wometbe, eke ne emne kir kobo late. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Eme porere selpap wurisubuwou tete, an emne etep wometbe. Apei, neset tetankap, eme etepke tete, an etep abobe. Eme nesetken wurik tete, an etep abobe. Etep tete, nowselri tatame eme etep late, eme kenawaike etep abote, ne ane won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ne ane newom sig yenboken mureken an emne newom. Etepkap eme wurisubuk tete. Nesa wurisubu tetankap, eme etepwou wurisubuk tete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","An etemken tetan, ne arenken tetan. Nesa tetankap, eme porere wurisubuk etepke noub tete. Etepkap tete, nowselri tatame eme etep abote. God ere Jisas erne won yam. Ere Jisas erne pap kenake yewobetemkap, ere emne kir pap yewobe. Nowselri tatame eme etep lan mette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Apei, ne ane newom tatame eme aren temente emi eme etek temente, an etep abobe. Kiyi ne selken nelken mak seikmenem, ne ane kenake abon ane noubwai nenem, eke an keryen eisau tem. Eme etepke late, eke an abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Apei, ne Wule Yenbo Nenbe Tame. Nowselri tatame eme nene beke la. Aren, an nene laten. Ne ane newom wakse, eme kenawaike metem, ne ane won yam. Eme etep metten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nereneke an emne wusoubetem. An emne som wusoute. Etep tete, ne ane abon pap yewobe wule etemken temente. An kir an etemken temente. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas ere God erken tuma namden omon, ere eteri anepoi tameken eme yin Kidron peik keraruke wum. Wum, ete emi oliv now wuri etek temenem, eme etek wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kiyi Jisas ere eteri anepoi tameken tewok tewok ete nowke yin wurisubuk sibetem. Etepkap Jisas erne yikwokwom tame, Judas, eter kir ere ete now temenem emi ere lamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas ere kiyi yimke, ere God eteri akeri apeilake etemri yaku kere tameken Farisi tameken ei nai tameken emne panen ete nowke yam. Yam, ei nai tame eme tuken yam, eme ei nai wos kir setirmenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas ere erne yuri tete wos ere abobetem, ere emne yin lan etep wometem. Kem eikene sopbe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eme awosein etep wom. Nema Nasaret komri tame, Jisas eterne sopen yawo. Etep wom, erne peiktame etemri letke rasem tame, Judas, ere ei nai tame etemken etek tetemenem. Jisas ere emne etep wom. An gwo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Eme etepkap metem, eme kinkin yin selke warkutan tuknatirim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tuknatirim, Jisas ere emne tewo wurinabu sene wometem. Kem eikene sopbe? Eme awosein etep wom. Nema Nasaret komri tame, Jisas, nema eterne sopbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ere awosein etep wom. An kemne woye. An gwote tetan. Kem arene sopen yamente, kem ari anepoi tame emne mesginin yite. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Etep womke, Jisas ere God eterken namdebetem tuma ere seken tem. Kiyi ere erne etep wom. Ne ane newom tame emne an noub lakerebetem. Eme nene beke kip mesgin. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sene Saimon Pita ere eri semenem gapaku peten yaku kere tame erne gapakuk eri wan mame yekwo kayekwunem. Ete tame eri sig Malkus. Ere God eteri akek yaku kerebetem tame etemri apeilake eri yaku kerebetem tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Etep tem, Jisas ere Pita erne etep wom. Ne gapaku sene buske yewo. Ne emne mane wotakete. Apei ere womkap eme ane keresukun pen sate. Etep tete. Jisas ere erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sene ei nai tame etem, etemri apeilake etem, Juda etemri nau se tame etem, eme Jisas erne keresukun kep peten peikem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Peikkerem, eme erne Anas eterke panen yim. Anas ere Kaiafas eteri owi. Ete nabe Kaiafas ere God eteri akek yaku kere tame etemri apeilake temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ete tame, Kaiafas, ere Juda tatame emne kiyi etep wom. Tame wuri ere sate, Juda tatame nogwape eme yenbo tete. Ere sate, nema noub temente nenbe. Ere ete tuma kiyi wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Eme Jisas erne keresukun panen yim, eri anepoi tame pes, Saimon Pitaken akeite tameken epe Jisas erne semowun yim. Ete akeite tame erne God eteri akeri apeilake tame ere erne kiyi lam, eke ere Jisas eterken epe kuyese ake makle pemenem eruke wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita ere beke wur. Ere makleri ser eru gwop yekwok koumenem. Koumenem, ake maime erne metmenem anepoi tame ere sene yam, eru lakerebetem ta tene womke, ere Pita erne panen wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Wurmemke, eru lakerebe ta te Pita erne etep wom. Kap, ne Jisas eteri anepoi tame wuri? Ere awosein etep wom. An eteri anepoi tame berai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ete neir negel yabetem, eke kau yaku kere tameken nau se tameken eme ker lisin kerke tetyewon wus leibetem. Pita eter kir, ere kir etemken kerke tetyewomenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Etep temenem, God eteri akek yaku kere tame etemri apeilake ere Jisas erne etep wometem. Neri anepoi tame eme eike? Be tuma be tuma ne emne wusoube? ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisas ere erne tuma awosein etep wom. Akei tuma an kom genik wusoubetem. An beke berasen wusou. Juda tatame etem God erne sukye worabetem ake, God eteri ake eisauken ake nebuleken an yin tuma etek wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Beke ne ane wometbe? Ari tuma metbe tame, ne etemne womette. Ari wobe tuma eme metten. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas ere etep womke, nau se tame ere mekinke tetemenem, ere Jisas erne pouyek burowon erne etep wom. Ne beke apeilake erne etepkap woye? E yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisas ere erne awosein etep wom. Be tuma an yaper wobe, ne ane wusoute. An tuma sekenke wobe, ne ane beke peye? ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Etep tem, Jisas eri let kepke som peikkeremenem, Anas ere erne apeilake Kaiafas, eterke won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita ere ker wus som leibetem, eme erne sene etep wometem. Kap, ne Jisas eteri anepoi tame etemri wuri. Pita ere yikwokwon awosein etep wom. An berai. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tame wuri, ere God eteri akek yaku kere tame etemri apeilake eri yaku kere tame, ere Pita eter wan kayem tame eteri akeri tame, ere Pita erne etep wom. Seken, an nene laye. Ne Jisas eterken Oliv nowke temenye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita ere sene yikwokwon etep wom. An berai. Etep womke, kwokwo ere wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ei berabetemke, Juda tame eme Kaiafas eri ake mesginin Jisas erne Rom komri apeilake eteri ake eisauke panen yim. Juda etemri wule eme Pasova awos ate, eme Juda berai tatame emri akek beke kip wur. Eke erne panen yim tame eme Rom tameri akek beke wur. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Etep temke, Pailat ere woran emne etep wometem. Be tumake kem gwote tame, Jisas, erne panen yawo? ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Eme erne tuma awosein etep wom. Ere wule yaper beke pauk wuri nen nema erne beke panen ya. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat ere emne etep wom. Kerem, keremri Juda wulek erne tuma namdete. Juda tame eme erne etep wom. Kem Rom tame, kem wobe, nema Juda tame nema tame wuri beke kip pen sa. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Rom tame emri pen sabe wule eme mek kwuran mesginin tame yaper emne etek kwanen nenewayen yeworuwon, ek sabe. Juda emri tame pen sabe wule etepkap berai. Jisas eter satekap, kiyi ere etep wom. Eme ane mek kwuran kwanen nenewayen yeworute. Eri kiyi womkap e seken tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat ere ake eisauke sene yin wurin ere Jisas erne wopeten etep wometem. Ne Juda etemri kom panen si keryen o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisas ere erne awosein etep wometem. Ete tuma neren ne kena etep abon ane wometbe, o akeite tamek kiyi nene wusouyeke, ne ane wometbe? ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat ere erne sene awosein wometem. Ne Juda etemri keryen o ne etemri keryen berai? An beke met. Aren an Juda tame berai. Neri kantriri tameken apeilakeken eme nene arenke panen yawo, eme etep wobe. Ne be woske yaper nenem? ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisas ere awosein etep wom. An nowselri keryen berai. Aren panen siten kom e akeite emik tetan. Gwote nowselke beke te. Aren panen siten kom gwote nowselke temen pauk, ari wakse eme Juda tame etemken ei pauk naite woye. Nai pauk, Juda eme ane beke pauk keresuk. Metye. Aren panen siten kom e gwote nowselke beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Etep womke, Pailat ere erne etep wometem. Neren, ne keryen o? Jisas ere sene etep wom. Neren, ne wobe, an keryen. An yaku wuri kereteke, ari nawo te ane warwiyim. An tatame emne tuma seken wusoubetem. Tuma seken metbe tatame, eme ari tuma noub metbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat ere erne etep wometem. Tuma seken e be tuma? Pailat ere ete tuma wo mesginin Juda tame eme tetemenem emi ere etek sene yin emne etep wom. Jisas ere wule yaper wuri beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kem Pasova yabel wule wuri tetan. Nabe nabek Pasova awos ate yabel tebe, ake yaperke tetan tame wuri erne an mesginin ere komke sene yibe. Kem mapeke abobe? An Juda etemri keryen, Jisas, eterne komke sene won yite o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Eme nubke awosein etep wobetem. Berai! Eterne beraike! Ne Barabas eterke won komke yite. Etep wom. Barabas ere ei naibetem, sir petbetem tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Sene Pailat ere wom, eme Jisas erne papeger nebuleken kepke erne wurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wurbetem, ei nai tame eme kwokwo seg peten apeilake emri tare kerapkap nenen Jisas eteri tarek gworereruwem. Gworereruwem, sene eme apeilake etemri kerap tame oub wolepai peten Jisas erne warruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Warruwum, sene eme wurare wurare yan Jisas erne bepou me pir wobetem. Sikile ere eteke. Ne Juda etemri kom panen siten apeilake. Etep won eme erne pouyek burowom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat ere sene woran Juda tame emne etep wom. Metye. An erne wometlawoiwo. Ere wule yaper beke wuri nen. Etepkap an erne panen woraye, kemne wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Etep womke, Jisas ere yan woram, ere kwokwo segke basem seli tarek som gworeremenem, wolepai tame oub waren ere eke yan woram. Woram, Pailat ere etep wom. Ek la. Tame ere gwo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Etep womke, God eri ake yaku kere tame etemri apeilakeken nau se tameken eme Jisas erne lan eme nubke etep wobetem. Erne mek kwuran kwanete. Erne mek kwuran kwanete. Pailat ere emne etep wom. Kerem, kem erne mek kwuran kwanete. Aren, an laye, ere wule yaper beke wuri nen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Juda tame eme awosein etep wom. Kiyi ere etep wobetem. An God Eteri Yen. Neremri wule gwopkap. Eike tame ere etep wote, nema erne pen sate. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat ere etep metem, ere kenake akem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Akem, ere ake eisauke sene wurin Jisas erne etep wometem. Ne map yekwok yam? Ere erne awosein beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Awosein beke wo, eke Pailat ere erne etep wom. Ne arene tuma sein beke wo. Metye. An Romri apeilake. An kir wote, eme nene mek kwuran kwanen sate. An wotakete, eme nene mesginin ne komke sene yite. Ne etep metten o? ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisas ere awosein etep wom. Metye. Hevenke tetan God ere beke wo, eke an neri kulke beke kip te. Etepkap neren ne ane wule yaper eisau beke nen. Tame ere ane nereri letke rasye, eter ere ane wule yaper eisau nenye. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat ere etep metem, sene ere Jisas erne komke won yite nenlawoyim. Juda tame eme Pailat erne muresen etep wom. Ne erne won yite, ne Keryen Sisar eteri peiktame tete. Jisas ere wobe, ere keryen eisau. Etep womke, ere Keryen Sisar eteri peiktame tem. Ne erne kobo late, ne Sisar eteri peiktame kir tete. Sisar ere Romken Judia distrikken kom panen simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Etep tem, Pailat ere Jisas erne panen woram, ere tuma namde tame etemri wolbayek sim. Ete sibe emi, eme Hibru tumak wobe, Gabata. Tuma somo etep wobe, Pape Tiy. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pasova awos eyarem yabel temke, Pailat ere Juda tame emne etep wom. Ek la. Keremri keryen ere gwo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sene Juda eme muresen etep wobetem. Erne pen sa. Erne pen sa. Erne mek kwuran kwanekeren ere sa. Pailat ere emne etep wometem. Keremri keryen erne an mek kwuran kwanekeren sate o? God eri akek yaku kere tame etemri apeilake eme sene etep wom. Sisar eterwou ere neremri keryen. Nema akeite apeilake keryen berai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Etep womke, Pailat ere Jisas erne peiktame etemri letke rasen eme erne mek kwuran kwanekeren sate panen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ei nai tame eme Jisas erne panen yin, eme erne maime etek kwanekeren sate me, eme Jisas erne maime newon ere sen yim. Sen yim, eme emi wurik yam. Hibru tumak ete emi eme etep wobe. Golgota. Ete tuma somo e Tame Tare Bai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ete emik eme Jisas erne mek kwuran kwanekeren nenewayen yeworuwem. Eme tame pes epne kir mek kwanen nenewayen yeworuwem. Wuri erne yamame yekwok, wuri erne eme let gwaime yekwok yeworuwem. Jisas erne eme borborke yeworuwem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat ere me wulale wuri peten tuma etek basem, eme peten sen yin kwuramenem me itiye yekwok kwaneruwum. Eri bas rasem tuma etep wom. Nasaret Komri Jisas. Juda Etemri Keryen. Ere etepke basem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ete tuma ere tuma murke basem. Hibru tuma, Rom tuma, Grik tuma etepke basem. Ete emi e Jerusalem kom sag mekinke temenem. Etepkap nogwape Juda tatame eme etek yi yabetem, eme ete tuma lan yi yabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","God eri akek yaku kere tame etemri apeilake eme Pailat erne wotaken etep wom. Ne mane etepke baste, Juda etemri Keryen. Ne etepke baste. Eter ere wom, ere Juda etemri Keryen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat ere awosein etep wom. Aren basyekap e me tetan. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sene ei nai tame eme Jisas erne mek kwuran nenewayen yeworuwem yaku omon eme Jisas eter warmenem tame oub wosan epe pes epe pes rasem, eme obo wurare wurare eme petem. Jisas eteri siot ete siot wuri lagwu, beke kape. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Eme etep lam, ei nai tame eme etemwou etemwou namden etep wom. Gwote siot nema beke kip peka. Nema satu sou tetete, nema late, eike tame eter pette. Etep temke, God eteri kiyi basem tuma ere seken tem. God eteri tuma etep wobe. Areri tame oub akei eme wosan wurare wurare petem. Eme satu sou tetemke, tame wuri ere ari siot petem. Ei nai tame eme etepke tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisas erne mek kwuran kwanemenem, kau ta epe pes epe pes eme erne mekinke tetemenem. Eteri nawo, eteri nakmoi, Klopas eteri ta Maria, Makdala komri ta Maria, eme etek tetyewomenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Etek tetyewomenem, Jisas ere eteri nawoken eteri metekwasbetem anepoi tame wuriken epne lam. Lam, ere nawo tene etep wom. Nawoi, gwok teteten tame ere neri yen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sene ere eteri anepoi tame erne etep wom. Gwok teteten ta te neri nawo. Etep wom. Ete yabelke, anepoi tame ere Maria tene eteri akek panen yin newon abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas erne mek kwuran kwanekeremenem, ere metem, God ere erne newom yaku omom. Ere etep wom. An wak sok teye. Etep wom tuma e God eteri siglouke kiyi bas rasem tuma. E kiyi bas rasem tuma seken tem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kwole yabe wain ok ware wuriken etek tukmenem. Eme yam sou peten ete wain okke sogwunen mek leyen eterne newon ate sen tayem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Sen tayem, ere ete kwole ya wain ok a mesginin ere etep wom. Akei yaku omoye. Etep wom, ere tare bangukwunen, ere eri wou won yin ere ek sam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kau Juda tame eme Pailat erne yin lan etep wom. Kipi e Pasova awos ate yabel. Neremri ege site yabel eisau. Ete yabel tame kupa eme kwuraten mek etek som kwanekeremente wurken. Etepkap, ne kir wote, ei nai tame wuri won yite, eme tame mur emne tewo kwosyewon eme agetage san tame kupa neneyeirin raste. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Etep womke, ei nai tame eme yin Jisas eterken ep yekwo ep yekwo kwanekeremenem tame pes epri tewo kwosim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kwosyewon, eme yan Jisas erne lam, ere kiyi sam. Eke eme eri tewo beke kwos. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Beke kwos, ei nai tame wuri ere Jisas erne pi bulke peramke, agetage nepken nep gil okken pi taukke yeirbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Tame wuri ere etep eteri lek lan, nemne wusowum. Ere tuma seken wusowum, eke kem kenawaike abote.) ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","God eri siglouke kiyi wom tuma e seken tem. Ete tuma etep wobe. Eme eteri letewo kip beke wuri kwos. Eke ei nai tame eme Jisas eri tewo beke kwos. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","God eteri siglou tuma sene etep wobe. Eterne pik pem tame eme erne leklek tete. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yuri Arimatea komri tame, Josep, ere Pailat erne yin lam, ere Jisas eri kupa pette wometem. Josep ere Jisas erne berasen kenawaike abobetem. Ere Juda emne akem, eke ere kom geinik beke wusou. Pailat ere kir temke, Josep ere yin Jisas eteri kupa peten sen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Sen yim, Nikodemus, ere kiyi Jisas erne neirke yin lam tame, ere kir, eterken yin Jisas eri kupa petem. Pag yenbo yabe me wusken ere gwor geren me neirken etep erke narken ere ek sen yim. Eri lum e 30 kilogram, ere sen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Sen yin epe Juda etemri tame kupa kerebe wulek epe etepke ten epe Jisas eri kupa peten kwar wiyin mesginin erne mate peten etek leyem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas erne mek kwuran kwanem emi now wuri etek mekin temenem. Pape puri tame kupa rasbe emi ager etek temenem, kiyi eme tame kupa etek beke wuri ras. ");
INSERT INTO yss_yawu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pasova awos ate yabel mekinke tem, e pape puri ere mekin temenemke, eke epe Jisas eri kupa etek rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande ei mak beramenemke, Makdala komri ta Maria, te Jisas eteri sele late yim. Yin lam, reba pemenem pape ere gelkwun yin genek tuknamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Etep lam, te amen Saimon Pitaken akeite anepoi tame, Jisas erne metekwasbetem tameken, epne yin lan etep wom. Aneyen eri kupa eme sele meike petye. Nema beke la, eri kupa eme kap mak sen yin rasye. Epe etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pitaken akeite anepoi tameken epe etepri temenem emi mesginin Jisas eterne rasem sele late yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Late yim, epe kir amen yibetem, akeite anepoi tame ere Pita erne mesginin taresin selek kiyi yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yin, ere guromun pape purik nerewurin lam, matewou etek rasmenem. Etep lam, ere pape puri beke wur. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Beke wur, Saimon Pita ere erne semowun yan ere yin wurin lam, matewou etek rasmenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jisas eri tarek peikmenem mate leyen gwolben ep yekwok rasmenem. Ete mate ere akeite mateken beke te. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Etep lam, kiyi taresin yam anepoi tame ere tiptiwun yin wurin lam, Jisas ere etek beke te. Ere etep lan kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","God eteri siglou etep wobe, Jisas ere san wou sene pette tuma, epe sene beke abo. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Etep tem, anepoi tame pes epe akek sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria te Jisas eteri kupa rasem pape puri ganke teten kerabetem. Kerabetemke, te guromun pape purik nerewurim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nerewurin, te lam, God eri komri tame pes epe mate geipa warmenem, epe Jisas eteri kupa rasem emik simenem. Epe tewo segwo tare sukke sepit peteyamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Epe Maria tene etep wometem. Ne beke kerabe? Te epne awosein etep wom. Eme ari Aneyen eri kupa petye. Rasten emi an beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Te wo mesginin te petkwo lam, tame wuri ere tetemenem. Ete tame ere Jisas. Maria te beke noub la, e Jisas eter. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisas ere tene etep wom. Ne beke kerabe? Ne eikene sopbe? Maria te etep abom, ere ete now lakerebe tame. Etep abom, eke te erne etep wometem. Ne kap Jisas eri kupa sen yin mak kap rasten? Neren rasye emi ne ane wusoutek, an yin eri kupa sene pette. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ere tene etep wom. Maria. Etep womke, te erne lan Hibru tumak etep wom. Rabonai. Ete tuma somo etepkap. Tuma wusoube tame. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ere tene etep wom. Ne ane mane kerelate. An Apei sene mak yin laten, eke ne ane mane kerelate. Ne yin ari wakse emne etep wote. Ari Apei ere keremri Apei. Ari Keryen ere keremri Keryen. An eterne sene yin late. Ne yin emne etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sene Makdala komri Maria, te yin Jisas eteri anepoi tame emne etep wom. An Aneyen erne laye. Etep wom, sene Jisas ere tene wom tuma, te emne etep wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ete Sande perpe Jisas eteri anepoi tame eme etep wom. Juda tame eme nemne kir pen sate wurken. Etep womke, eme aken ake eru akei kiten yan eme siyewomenem. Siyewomenemke, Jisas ere etemri tewo borke me pamnen etep wom. Apo. Kem pap yenbo met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Etep wo mesgin, ere eri letken pi bulke peram taukken emne peteram. Peteram, anepoi tame eme Aneyen erne noub lam, eme metekwaswayim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Etep tem, ere emne sene etep wom. Kem noub me tete. Apei ere ane yaku kerete won yamkap, an kemne yaku kerete won yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Etep wo mesgin, ere emne yimu optepitin emne etep wom. Kem God Eteri Wou yenbo pet. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kem tatame emri wule yaper peten sepitte wote, God ere etemri wule yaper peten sepitte. Kem tatame emri wule yaper peten sepitte beke kip wo, etepkap emri wule yaper som temente. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisas eteri anepoi tame ep yekwo let ep yekwo let tewo bor pes kei (12-pela) etemri wuri ere Tomas. Eri akeite sig e Peske Warwiyim Yen. Ete tame ere akeite anepoi tame emken beke temen, Jisas ere ek yam, eke ere erne beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Beke la, ere sene yam, anepoi tame eme erne etep wom. Nema Aneyen erne laye. Tomas ere etep wom. Jisas ere sele meike wayem tuma an kenawaike beke abo. An erne ari lek late, an kenawai ek abote. An eteri nikel pem taukken pi bulke peram taukken lan ari let bor etek petewurlatek, an kenawaike ek abote, ere wou sene petem. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sene yabel ep yekwo let ep yekwo let bor pes kei (7-pela) tem, anepoi tame eme ete akek simenem, Tomas ere kir etemken simenem. Ake eru kitmenem, Jisas ere etemri borborke sene me pamnen emne etep wom. Apo. Kem pap yenbo met. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sene ere Tomas erne etep wom. Ne yan neri let bor ari let pap nil taukke raspitiwur. Neri let ane pi bulke peram taukke petewurlate. Ne mane ep abo ep abote. Ne kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas ere erne awosein etep wom. Ne ari Aneyen. Ne ari God. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisas ere erne sene wom. Ne ane laye, eke ne kenawaike abobe, an sele mesginin sene wayen yam. Tatame eme ane beke la, eme ane etep kenawaike abote, God ere emne noub eyarte, eme metekwaswaite. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas ere nogwape rigrabe nenbetem, anepoi tame eme labetem. Ete nogwape rigrabe gwo siglouke beke bas ras. ");
INSERT INTO yss_yawu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","An basbe tuma, kem labetete, kem kenawaike etep abote. Jisas eter ere God eter won yam tame, eter ere God Eteri Yen. Kem etep kenawaike abobetete, kem eteri sigke kem noub som temente nenbe. Eke an gwo siglou basbe. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Sene anepoi tame eme Galili peik kupak temenemke, Jisas ere etemri bitimik me pamnen yam. Peik kupa eri sig wuri Taiberias peik kupa. Jisas ere gwopke nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Etek temenem tame etemri sig gwo. Saimon Pita, Tomas, eri sig wuri Peske Warwi Yen. Nataniel, ere Galili distrik Kana komri tame, Sebedi eteri yen pes, akeite anepoi tame pes. Eme etek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Etek temenem, Saimon ere emne etep wom. An wuli raste yibe. Eme erne etep wom. Nema kir nerenken yite. Etep won eme perek waren yin wuli rasem. Ete neir eme wuli raslawoyim, omyen beke wur, eme bepou me ten yin eiken beram. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ei beram, Jisas ere peik barke tetemenem. Anepoi tame eme eri tame yop noub beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Noub beke la, Jisas ere emne ten etep wom. Tamenowu, kem omyen kau petye o? Eme erne awosein etep wom. Beraiwai. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ere emne etep wom. Metye. Kem wuli pere gan let mame yekwok sogwunte, kem omyen pette. Etep wom, eme wuli sogwunen omyen nogwapewai wurim. Wurim, eke eme wuli nenewayelawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jisas erne metekwasbetem tame ere Pita erne etep wom. Ete tame ere Aneyen eter. Saimon Pita ere yaku kerebetem, eke ere eri tame oub lugrasmenem. Ere metem, Jisas ere peik barke tetemenem, agetage ere tame oub peten gersen peikke kerpekwunem. Kerpekwunen, ere agetage payen woran yin Jisas erne lam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Perek temenem anepoi tame eme bar mekinke temenem, gene e 100 mita etepke temenem. Eme peyan Pita erne semowun omyenken wuliken litin yan barke woram. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Barke wurin eme lam, omyen kerke lismenem, geil etep kir rasmenem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Etep lam, Jisas ere emne etep wom. Kemri petye omyen kem kau sen ya. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Etep wom, Saimon ere perek waren wuli ogwon barke lit sen yawom. Omyen nogwapewai, 153, eisauwou wuli takke tem. Omyen nogwapewai, wuli beke wuyar. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisas ere emne etep wom. Kem yan awos a. Etep womke, anepoi tame eme Jisas erne beke womet. Ne eike? Eme akei lam, ere Aneyen. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas ere yan emne geilken omyenken newopit peteyam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Etepkap Jisas ere sele mei mesginin yimenem, anepoi tame eme erne tewo mur lam. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Eme awos an omon, Jisas ere Saimon Pita erne etep wom. Jon eteri yen, Saimon, anepoi tame eme ane pap yewobe. Kap ne ane pap kenake yewobe o? Pita ere tuma sein etep wom. Aneyen, an nene pap yewobe. Ne etep metten. Jisas ere erne etep wom. Sipsip lakerebe tame eme sipsip yen awos newon abekap ne ari wakse emne ari tuma som wusobetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Etep wom, Jisas ere erne sene etep wometem. Jon eteri yen, Saimon, ne ane pap kenake yewobe o? Pita ere awosein etep wom. Ye. Aneyen, an nene pap yewobe, ne etep metten. Jisas ere erne etep wom. Sipsip lakerebe tame eme sipsip lakerebekap ne ari wakse emne etepke lakerebetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Etep wom, Jisas ere erne tewo mur sene wometem. Jon eteri yen, Saimon, ne ane pap yewobe o? Tewo mur Jisas ere erne etep wometem. Ne ane pap yewobe o? Eteke, Pita ere pap yaper ten erne etep wom. Aneyen, nogwape wos ne akei metten. An nene pap yewobe, ne etep metten. Jisas ere erne etep wom. Ne ari wakse lakerebetete. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","An nene sekenke wobe. Kiyi ne tame taureyen temenem, neren ne neri moutip peten borke sin, nereri porerek sewurbetem. Yuri ne keryen tete, ne neri let taitek, akeite tame etem eme nene moutip peten borke site, neren mo wom emik eme nene etek keisen yite. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisas ere etepkap wom, ere Pita eter yurik san, tatame eme God eter sig eisau wote nenbekap eke etep wom. Sene ere Pita erne etep wom. An nene wotekap, ne etep tete. Ne ane semowun ya. Jisas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jisas ere etep womke, Pita ere petkwo lam, Jisas eri metekwasbetem anepoi tame ere epne semoumenem. Kiyi eme sin awos abetemke, ete anepoi tame ere Jisas eterken mekinke simenem, ere etep wometem. Aneyen, nene eike peiktame etemri letke raste? Etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petkwo lam, Pita ere Jisas erne etep wometem. Aneyen, ete tame ere mapeke sa? ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisas ere awosein etep wom. E nereri wos berai. E areri wos. Kap an wote, ere som temente, an ek sene yate, e neri wos berai. Ne ane semowun yate. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yuri Jisas erne kenawaike abobetem tatame eme ete tuma wuri won yi won yin eme etep wom. Ete anepoi tame ere beke kip sa. Jisas eter, ere etep beke wo. Ere etep wom. Kap an wote, ere som temente, an ek sene yate, e nereri wos berai. Etepwou ere wom. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ete anepoi tame e aren. An gwo tuma wom, an gwo tuma siglouke basem. Ari tuma e seken. Nema etep metten. ");
INSERT INTO yss_yawu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas ere akeite akeite yaku nogwape kir kerebetem. Wurare wurare akei kerebetem yaku siglouke pauk baste wom, ete siglou emne nema mapeke pauk ras. Berai. An etep abobe. Jon ere bas rasem tuma ab eteke. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiofilus, an nene siglou bas rasbe. Areri kiyi bas rasem siglou, Jisas ere nenbetem woskap, eri tuma, an etep bas rasen nene newopitim. Jisas ere eri yaku keren yin omom, ere God eteri komke sene yawom. An nene etep kir bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ere mak yaumenem, eri aposel tame emne ere tuma wusoubetem. Eme kerete yaku ere etep wusoubetem. God Eteri Wou ere Jisas eterken temenem, ere aposel tame emne tuma wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jisas ere sam, sene ere wou sene petem yabel nogwape (40-pela) ere nowselke temenem. Nowselke temenem, ere eteri aposel tame emne tewok tewok yin lam. God eter nogwape kom panen site tuma ere emne etep wusoubetem. Eme erne lam, eme etep wobetem. Jisas ere kelpe tameke som tetan. Etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ere etemken temenem, ere emne etep wom. Kem Jerusalem agetage mane kip mesginte. Kem etek koute. Ari Apei ere kemne mure newote wom. An kemne etep kiyi wusowumkap, ere etep nente. Kem etek som koute. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kiyi Jon ere tatame emne baptais ok wirubetem. Kerake tetek, God ere Eteri Wou kemne newote, kem mure eisau pette. Jisas ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yuri God eteri aposel tame eme Jisas eterken yan simenem, eme erne etep wolam. Aneyen, God ere Eri Wou nemne newote yabel, nema Juda nema independenske pet o? ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jisas ere emne awosein etep wom. Areri Apei ere wobe, wos nogwape ek tebe. Yuri tete wos ere metten. Yuri tete wos kem beke met. E Apei eteri wos. E keremri wos berai. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","God Eteri Wou ere keremken yan temente, kem mure pette. Pette, ari tuma kem tatame etemne wusoute. Kiyi kem Jerusalem komri tatame emne wusoute, sene Judiari tatame emne wusoute, sene Samariari tatame emne wusoute, sene kem akei nowselri kom komke yin wusoute. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jisas ere womkap, aposel tame eme etep lam, Jisas ere Hevenke yawom. Yaubetem, gwan erne yan soppitim, aposel tame eme etep lam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eme lek temenemke, agetage tame pes epe yan etemri ganke yan tetem. Epe geipa tame oub warmenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Yan tetem, epe God eteri aposel tame emne etep wom. Kem Galili distrikri tame, kem beke tetyewon nelke labe? Jisas ere God eteri komke yaubekap, yuri ere etepkapke sene yeirte nenbe. Epe etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aposel tame eme lam, Jisas ere Hevenke yim, sene eme Oliv kow mesginin yeirin eme Jerusalem komke sene yim. Jerusalem kom e Oliv kow mekinke tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalemke yim, eme tiy peske petemenem akek yawon etek temenem. Etek temenem tame emri sig gwo. Pita, Jon, Jems, Andru, Filip, Tomas, Bartolomyu, Matyu, Alfius eteri yen Jems, Saimon Selot, Jems eteri yen Judas. Eme etek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Temenem, eme kir won eme kwokwos kwokwos wurik yan sin God erken tuma namdebetem. Kau ta, Jisas eteri nawo Maria, Jisas eteri maseken eme kir etek yin temenem, God eterken tuma namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Yabel kau yimke, Jisas erne kenawaike abobetem tatame eme wurisubu emik yan siyewomenem. Tatame nogwape (120) eme siyewomenem. Yan simke, Pita ere teten emne tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ere etep wom. Ari geisimase, God eteri tuma, e tuma seken. Kiyi God Eteri Wou ere Devit erne yurik tete wos wusowum, Devit ere ek bas rasem. Ere Judas eterne bas rasem. Jisas erne pete yam tame emne Judas ere emne kelu peteram. Etepkap, Devit eri kiyi bas rasem tuma ere seken tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kiyi Judas ere Jisas eteri anepoi tame temenem. Jisas ere erne wom, ere neremken yaku kerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Sene Judas ere Jisas erne pem tame emne kobo lam, ere kel peten ere sel wuri tukem. Tukem, sene ere etek waren selke apeken se pekan seken woran ere ek sam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Samke, Jerusalemri tatame eme kir metem, Judas eri sam tuma eme kir metemke, eme ete sel sig Akeldama wobe. Sel eri sig somo Nepken Sel. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sene Pita ere etep wom. Ete tuma ere Buk Songke tetan. Buk Song etepke wobe. Tame wuri mane etek temente. Eri ake noub bepou me temente. E siglou kir etep wobe. Akeite tame ere eri yaku pette. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ete siglou etep wobe, etepkap nema akeite tame erne wote, ere Judas eri yaku pette. Jisas eterken nema sewurbetem tame wuri erne nema pette. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Kiyi Jon ere tatame emne baptais ok wirubetem. Etep lam tame ere neremken som sewurbeten, yan Jisas ere Hevenke yawom. Etepkap tame nema erne wote, ere neremken yaku kerete. Jisas ere sene wayen yim tuma ete tame, ere ete tuma kir wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Etep womke, eme tame pes kiyi wom. Tame wuri eri sig ere Josep Barsabas Jastus. Tame wuri eri sig Matias. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Sene eme akei eme God erken tuma namden etep wom. Apei God, ne akei tame emri porere labe. Judas ere neri yaku mesginim, ere ker tetan komke yim. Nema gwo tame pes epne woye. Neren wom tame ne nemne peterate. Peterate, ne erne wote, ere neri yaku kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Etep wom, sene eme satu sou tetem, Matias ere aposel tame tete yaku petem. Petem, ere ep yekwo let ep yekwo let tewo ges wuri kei (11-pela) aposel tame emken yaku kerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nabe nabek Juda tatame eme nowri awos petbetem, eme God erne pir wobetem. Etep tebetem yabel eme Pentikos yabel wobetem. Ete yabel tem, Jisas erne abobetem tatame eme yan wurisubuk simenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Simenem, agetage eme metem, marye eisau kenkap nelke yam. Etem simenem akek ken nogwape eisauwai eme metem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Metem, sene eme lam, ker tawulkap wos temenem. Temenem, sitirmenem tatame emne ker tawulkap wos etemri tarek wurare wurare etek ten yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ten yam, God Eri Wou ere tatame emne yan etemne gulelemke, eme akeite akeite kom tumak namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ete yabel Juda tatame nogwape eme kiyi akeite akeite nowsel mesginin yam, eme Jerusalem etek temenem. Ete tatame eme God eteri tuma meten tobobetem tatame, eme Pentikos awos eisau ate yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yam, eme nelke yam ken eisau metem, eme yan lam, eme metem, God Eteri Wou gulelemenem tame eme akeite akeite kom tumak namdebetem. Etep metem, eme emri kom tuma kir etep meten eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wouken aken eme ep abo ep abon etep wom. Nemri tumak namdebe tame eme Galili distrikri tame. Eme neremri kom tame berai. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Eme mapeke neremri akeite akeite kom tuma sekenke namdebe? Neremri kom tame etem namdebekap, eme etepke namdebe, nema etep metye. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nema akeite akeite provinsken kantriken etek yam. Nema kantri Partiak yam, kantri Midiak yam, kantri Elamke yam. Kau nema Mesopotemia distrikke yam, Judia distrikke yam, Kapadosia provinske yam. Kau nema Pontus provinske yam, Esia provinske yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Kau nema Frigia distrikke yam, Pamfilia distrikke yam, kantri Isipke yam. Kau nema Sairini kom mekinke tetan yekwok yam, Libia distrikke yam. Kau nema Rom komke yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nema Rom komke yam tame, kau nema Juda tame seken, kau nema Juda tame berai, nema Juda tame etemri tebekap nema nenbe. Nema kau, nema ailan Krit tame, kau Arebia distrikri tame. God eter kerebe yaku eisau e eme wusoube, nema etep neremri tumak metbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Etep wom, eme wouken aken abolawoyim. Eme etemwou etemwou etep wometbetem. Beke eme etepkap tuma namdebe? ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Etep wom, kau eme workwoyeken resen etep wom. Neremri tumak namdebe tame eme ok yaper an sisi peye, eke eme etepkap tebe. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sene Pita ere aposel tame ep yekwo let ep yekwo let tewo ges wuri kei (11-pela) tameken eme teten Pita ere tatame emne tuma noubke etep wom. Juda tatame, Jerusalemke yam tatame, kem wan raste. Emri nenbekap an kemne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Akeite akeite tumak namdebe tame eme sisi beke pe. Berai. Keni nema ok yaper beke a. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Emri nenbekap kem abo. God eteri kiyi temenem tuma wusoubetem tame, Joel, ere etepke wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","God ere etep wom. Nowsel yaper tete yabel mekin mekinte, an Ari Wou tatame emne newote nenbe. Kemri yedeyen, taureyen eme yuri tete wos wusoute. Kemri taureyen tame eme nugsi tuknalabe woskap late. Kemri keryen eme nugsik tuknalate. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ye, Ari Wou an areri yaku kerebe tatame emne newote. Newote, eme yuri tete wos wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","An rigrabe nelke nente nenbe. Kem lan wouken akte. Kem nep, ker, ker bou nogwape late nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yabel ere beke kip pas. Lup te wolepai tete nenbe. Etep tetek, Keryen ere ek yate nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tatame eme God eter etemne kobo late womette, ere emne kobo late, eme noub tete nenbe. Kiyi temenem tame, Joel, ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita ere sene etep wom. Juda tame, kem ari tuma noub mette. An kemne Nasaret komri Jisas eterne kemne wusoute. God ere Jisas eterne won yam, ere wos yenbo nogwape nenbetem, ere rigrabe nenbetem, ere yaku eisau kerebetem. God ere erne mure eisau newon ere ete wos nenbetem. Kem etep lam, kem abom, God ere erne won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kiyi God ere eteri porerek Jisas erne keremri letke rasem. Rasem, wule yaper nenbetem tame eme erne mek kwuran kwanen ek sam, kem lewouke lam, kem emne beke wotake. Etepkap, kem erne pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sam, God ere Jisas eteri sam mus lam, eri sam mus ere akei peten petewarem, ere erne wou sene newom, ere yenbo tem. Tame sabe wule Jisas erne keresuklawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kiyi Devit ere Jisas eterne abon etep wom. An lam, God ere arenken mekin tetan. Ere arenken tetan, ere ane mure newobe, an beke kip ak. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Etepkap an metekwasye, an erne tuma yenbo wobe. An metten, an sate, an noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ne ari wou beke kip mesginte, an gabo komke beke kip yi. Ne ane beke kip mesgin, neri yen yenbowai ere beke kip kupoi. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Noub som temente wule ne ane peteram. Ne arenken temente, an metekwaste. Jisas eri wom tuma Devit ere etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita ere emne sene wom. Ari geisimase, neremri warege Devit eterne an kemne wusoute. Ere ete tuma bas rasem, ere eter maime beke bas ras. Devit ere sam, eme erne meike rasem. Eri sele mei som tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Devit ere God eri tuma wusoubetem tame, God ere erken tuma namderasem. God ere Devit erne etep wom. Yuri neri nan ere neren tetankap etep tete nenbe, ere kom panen site nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","God ere yuri tete wos Devit ere etep metem. Ere metem, Krais ere sate, God ere erne wou sene newote. Devit ere etep kiyi metem, ere etep wom. God ere Krais erne som beke kip mesgin, ere gabo komke som beke kip te, ere beke kip kupoi. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nema lam, God ere Jisas erne wou sene newom. Nema etep lam, nema kemne etep wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God ere erne wou sene newon ere wayen ere God eteri yamame yekwori wolbaye yenbok siten. God ere kiyi womkap, ere etep nenem, ere Eteri Wou Jisas erne newom. Newom, ere Wou erne nemne won yan newoye. Gwotepte kem etep metbe, etep labe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit eter ere God eteri komke beke yau. Devit ere Krais eterne abon ere eke bas rasem. Keryen God ere areri Aneyen erne etep wom. Ne Aneyen, ne yan ari yamame yekwok site. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Yuri an wote, ne nereri peiktame emne teitkwunte. Ne emne panen site nenbe. Devit ere etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pita ere sene etep wom. Kem Juda tame, kem noub mette. Jisas erne kem me kwuran kwanem. Ete Jisas ere Krais, God ere erne yaku newom. Pita ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tatame eme Pita eteri tuma metem, eme sebera yan pap yaper tem. Eme Pita eterken aposel tameken emne etep wometem. Lakemase, nema beke nente, God ere nemne kobo late? ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita ere awosein etep wom. Kem wurare wurare kemri kiyi nenbetem wule yaper akei mesginin sene mane nente. Sene nema Jisas eteri sigke won kemne wurare wurare baptais ok wirute. Kem etep tete, God ere kemri nenbetem wule yaper peten sepitte, ere Eteri Wou kemne bepou me newote. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kiyisape God ere wom, ere Eri Wou kemne newote wom. Ere keremne, keremri yen emne etep wom, ere akeite tatame mak te mak te emne etep kir wom. Ere kenem tatame etemne ere Eri Wou emne newote. Pita ere etep newote wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita ere tuma emne sene wusowun, ere emne tuma nogwape wusowum. Ere etep wom. God ere wule yaper nenbe tatame emne paku pete. God ere kemne kip etemken pete wurken, eke kem God erne kenawaike abote. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Etep womke, tatame nogwape eme eri tuma kenawaike metem, emne baptais ok wiruwum. Ete yabel, tame nogwape (3 tausen) eme Jisas erne kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kristen eme aposel tame emri tuma kwokwos kwokwos metbetem, eme metekwasbetem, eme wurisubuk temenem. Eme Jisas erne abon eme wurisubuk sin awos abetem, eme God erken tuma kenake namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aposel tame eme rigrabe kenake nenbetem, tatame nogwape eme lan wouken akbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jisas erne kenawaike abom tatame eme kwokwos kwokwos wurisubuk sibetem etemri wos lakemase emne newobetem. Wos nogwape temenem tatame eme wosken berai tatame emne wos newobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Newobetem, eme etemri selken wosbasken etep tukbetem, eme kel peten wosken berai tatame emne newobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Etep tebetem, eme selpap wurik tem, eme God eteri ake eisauke kwokwos kwokwos yin God erne sekwo lomen erken tuma namdebetem. Eme akek yin wurisubuk sin awos abetem, eme metekwasbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Metekwasbetem, eme etep wobetem. God ere yenbo. Etep wobetem, komri tatame eme etep labetem, eme etep wobetem. Jisas erne kenawaike abobe tatame eme tame yenbo. Etep wobetem. Kwokwos kwokwos God ere tatame emri wule yaper peten sepitbetem, Jisas erne abobetem tatame eme nogwape tebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Perpe Juda tatame eme God erken tuma namdebetem, Pitaken Jonken epe God eteri ake eisauke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yim, tame wuri erne kiyi nawo te erne warwiyim, ere tewo yaper temenem. Temenem, kwokwos kwokwos tatame eme ete tewo yaper tame erne sen yan God eteri ake eisau eru tumak sirubetem. Eru teri sig e gwo, Le Yenbo Labe Eru. Sirubetem, ete tame ere sin God eri akek wurbetem tatame emne kel nasegerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pitaken Jonken epe wurte nenbetem, ere epne kel wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wometbetem, epe eterwoune som lek temenem, Pita ere etep wom. Ne nesetne la. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ere epne lan etep abom. Epe ane woskap newote wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita ere erne etep wom. An kel berai, an nene akeite woske newote. Nasaret komri Jisas eteri murek an nene wobe. Ne epe wayen teten sewurte. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Etep wom, Pita ere erne yamamek keren nenewayen tetruwum, agetage ete tame ere tewoken wangwoleken yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ere wayen teten ere me yim. Etep tem, ere etepke God eteri ake eisauke wurin God erne pir wobetem. Wursuwurin ere me kerpen metekwasen sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tatame nogwape eme erne etep lam, ere sewuren God erne tuma yenbo wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Etep lam, eme etep wom. Ete tame ere kiyi kel nasegerebetem. Le Yenbo Labe Eruke ere etek sin tatame emne kel wometbetem. Sene ere yenbo teye. Etep won, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kiyi tewo yaper temenem tame ere Pitaken Jonken epne let kerebetem, tatame nogwape eme yan etem temenem emik yan siyewom. Emri temenem emi eri sig e Solomon Eteri Makle. Yan lam, eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita ere tatame emne lan ere emne etep wom. Israelri tatame, kem beke wouken akye lakerebe? Kem mapeke abobe? Nesetri porerek nesa ete tame erne yenbo nenye, ere sewurbe? Berai. Kap kem abobe, nesa tame yenbo, nesa erne yenbo nenye, ere sewurbe? Berai. Neset, nesa kuyese beke nen. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Neremri warege Abraham, Aisak, Jekop etemri God, neremri yeiwarege etemri God ere eri yaku kere tame, Jisas, eri sig eisau wom. Kerem, kem Jisas erne etemri peiktame emne newom. Pailat eter, ere Jisas erne pen sate wotakem, ere erne won yite abom. Kerem, kem Pailat eteri bitimik temenem, kem etep wom. Jisas ere tame yaper. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jisas ere wule yaper wuri beke nen, ere tame yenbowaike. Kem erne magel tayen kem Pailat erne etep wom. Ne Jisas erne mane won yite. Alwo pe tame wuri ere ake yaperke tetan, ne erne komke won yite. Kem etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nema Jisas erne kenawaike abote, nema noub som temente. Ete Jisas erne kem pen sam. Sam, God ere erne eyaren erne wou sene newom, ere sene wayen yim. Wayen yim, nesa etep wusoube. Nema erne sene lam, nesa kemne etep wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Gwo tame erne kem laten. Kiyi ere tewo yaper temenem tame. Nesa Jisas erne kenawaike abon eri sig woye, eke tame ere sene yenbo teye. Jisas ere nesetne porere yenbo newon nesa erne kenawaike abon, nesa ete tame erne woye, eke ere sene yenbo teye. Kem etep laye. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Geisimase, an metten, kerem, kemri komri keryen o apeilakeken kem eikse, kem Jisas erne pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kiyisape God eteri tuma wusoubetem tame eme tatame emne tuma won etep wobetem. Krais ere mus nogwape eisau mette nenbe. Eme etep wobetem. Ete wos God ere nenem. God ere Jisas erne lam, Jisas ere mus eisau metem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Etepkap, keremri wule yaper kem pap yaper met. Kem keremri kiyiri porere magel taite, kem God erne womette, ere kemne porere yenbo newote. Etep tete, ere kemri nenbetem wule yaper peten sepitte. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ere keremken temente, kem ege site. Eter wom tame, Jisas erne ere kemne sene won yate. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jisas ere God eteri komke tetan, ere God erne kouten. God ere akei wos sene noub nentek, Jisas ere sene ek yate nenbe. Kiyisape God eteri tuma wusoubetem tame eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Neremri warege, Moses, ere tatame emne etep wom. Keryen God ere ane kemne won yamkap, ere kemne tuma wusou tame wuri won yite. Ete tame ere keremri tame wuri. Eri wote tuma kem noub met. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tatame eme etemri tuma beke kip met, eme God eteri tatame etemken beke kip temen, eme yaper tete nenbe. Moses ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kiyi temenem tuma wusoubetem tame nogwape, Samuel eter, yuri temenem tuma wusoubetem tame etem, eme etepwou wom. Gwopte tetan wos eme kiyi wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ete tuma wusoubetem tame eme kemri yeiwarege. Kiyi God ere neremri warege emne tuma namden emne yenbo nente wom. God ere neremne kir nemne yenbo nente nenbe. Kiyi God ere neremri warege Abraham erne etep wom. Nereri yennan etemke an nowselri tatame akei emne yenbo nente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Etepkap, God ere eri yen erne won yan ere Juda tame kemne kiyi yam, ere kemne yenbo nente yam. Kem kemri nenbe wule yaper mesginte, ere kemne yenbo nente. Pita ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitaken Jonken epe tatame emne som wusoubetemke, kau tame eme epne late yam. God eteri akek yaku kere tame etemri apeilake etem, God eteri ake eisau lakerebetem tame etemri apeilake eter, Sadyusi tame etem eme epne late yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yan lam, eme epne pap wayem. Epe tatame emne etep wusoubetem. Jisas ere wou sene peten selek sene wayen yim, etep tem, sabe tatame eme yuri selek sene wayen yite nenbe. Epe etep wusoubetem, eme epne eke pap wayem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pap wayem, eme epne peten ake yaperke won wurim. Teketem, eme epne neir wuri keresukun tuknam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tatame nogwape eme epri tuma metem, eme Jisas erne kenawaike abom. Jisas erne kenawaike abom tatame emne eme sarem, eme ok yen ok tame nogwapewai (5 tausen). ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kwokwos Juda etemri apeilake, Moses eri wule wusoubetem tameken eme Jerusalem komke yin poyim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","God eteri akek yaku kere tame etemri apeilake, Anas ere gwo, Kaiafas ere gwo, Jon ere gwo, Aleksander ere gwo, apeilake etemri somo nuk nogwape eme kir yan etemken poimenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Poimenem, eme aposel tame pes epne etemri bitimik won teten eme epne ek wometem. Kep tewo yaper temenem tame erne mapeke eyarem? Eikeri mure, eikeri sigke kep ete wos nenem? ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","God Eri Wou ere Pita eterken temenem, Pita ere emne awosein etep wom. Kem Israelri apeilake, an kemne wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nesa tewo yaper temenem tame erne eyarem. Kem eteke wometbe. Ete tame ere mapeke yenbo tem? ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kem akei, kem mette. Akei Israel tatame, etem eme kir akei mette. Nasaret komri Jisas Krais eteri mure, eteri sigke ete tame eri tewo yenbo tem. Ete tame ere keremri bitimik tetan. Jisas eterne kem erne mek kwuran kwanen sam, sene God ere erne wou sene newom, sene ere selek sene wayen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","God eri siglou Jisas eterne eke wobe. Kem ake yaku kere tame, kem ake kerebe, kem kiyi sepitim kwat sene peten ake etek kerem. Ete kwat ere nawo kwat, ere kwat yenbowai. Etep wobe. Jisas eter ere ake nawo kwatkap. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Eterwou ere nemne kobo lan nemne sene pette nenbe. God ere Jisas eterwoune nemne won yam. Ere akeite tame beke won ya. Jisas eterwou ere nemne sene peten neremri wule yaper peten sepitte. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kaunsil tame eme Pitaken Jonken epne lam, epe skul kiyi beke wuri si, epe mureken ten epe tuma noub wusoubetem. Etep lam, eme wouken akem. Sene eme abon etep wom. Epe Jisas eteri anepoi tame, etepkap eke epe tuma yenbo noub wusoube. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Eme lam, tewo yaper temenem tame ere sene yenbo tem, ere Pitaken Jonken etepken temenem. Etep lam, eme tuma rebe tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Sene Juda etemri apeilake etemri kaunsil tame eme epne etep wom. Kep ep yekwok wurte. Wurim, eme etemwou etemwou tuma wuri namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Eme etep wom. Nema epne mapeke nente? Epe tewo yaper temenem tame erne yenbo nenem. Jerusalemri tatame nogwape eme etep lam. Nema etep mane neiste. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Akeite tatame eme ete tuma mane kip mette, etepkap nema epne wotakete, epe Jisas eri sig sene mane wote. Epe wote, nema epne tuma namdete. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Etep womke, eme epne sene wopeten woran epne worwor etep wom. Kep Jisas eri tuma sene mane wusoute, Jisas eri sig kep sene mane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Epe emne awosein etep wom. Kem abote. God ere wom wos nesa mesginin keremri tuma mette, God ere mapeke wote? Ere yenboke wote o? ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Jisas ere nenbetemkap nesa lam, eri wobetemkap nesa metem. Etep nenbe, nesa akei wusoute. Nesa tuma rebe beke kip te. Epe etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kaunsil tame eme epne tuma worwor sene won eme epne sene won yim. Komri tatame eme epri nenem rigrabe lam, eme metekwasen God erne pir wom. Etepkap, kaunsil tame eme me akem, eme epne ake yaperke won wurte abolawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ete tewo yaper sene yenbo tem tame eri nabe nogwape (40-pela). ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pitaken Jonken epe ake yaper mesginin epe epri tamesip emne late yim. Yim, God eri akek yaku kerebetem tame etemri apeilake eri tuma, Juda etemri kaunsil tame etemri tuma epe yin tamesip emne wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Eme epri tuma metem, eme God erken tuma namden etep wom. Keryen, ne nelken selken gare okken akei seikim. Nelke tetan wos, selke tetan wos, okke tetan wos, ne akei seikim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kiyi Nereri Wou ere neremri warege Devit erne tuma wuri wusowum. Devit ere nereri yaku kere tame, ere wom tuma ere etep wom. Akeite komri tame, eme Juda tame berai, beke eme pap wayem? Beke tatame eme nene yaper nente wom? ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Komri komri apeilake eme naite kowum. Kaunsil eme wurisubuk poyin, eme God eterken Krais eterken epne teitkwunte wom. Devit ere etep kiyi bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ete tuma seken tem. Herot eter, Pontius Pailat eter, Romri tame etem, Israelri tatame etem, eme gwo komke poyim, Nereri Yen yenbo, nereri wom tame eterne eme erne teitkwunte wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Apei God, ne mureken ne porereken kiyi ne yuri tete wos womkap, eme etep nenem. Eme Jisas erne pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Apei God, ne ek met. Eme nemne yaper woske nente woye. Eme nemne ei nenbe. Nema nene wometbe, ne nemne kobo late, nema beke ak, nema neri tuma noub wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ne let kere tewo kere tatame emne eyarte. Ne nemne wote, neri yaku kere tame yenbo, Jisas, eteri sig yenbo nema wote, nema rigrabe nogwape nente. Eme God erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Eme God erken namden mesginim, emri simenem ake ere peya payem. God Eteri Wou ere etemne gulelem. Gulelem, eme beke ak, eme mureken tem, eme God eteri tuma noub wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jisas erne kenawaike abobetem tatame eme porere wurik tem, eme wurare wurare etep wom. Ari wos e areri woswou berai. E tatame nogwape etemri wos. Eme etepwou nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposel tame eme nogwape mureken temenem, eme tuma wusoubetem. Jisas ere wou sene peten selek sene wayen yim tuma eme etep wusoubetem. Jisas erne kenawaike abobetem tatame emne God ere yenbo nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Etepkap, etemri tame wuri wos beke abo. Eike sel temenem o ake temenem, akeite tame eme tuken eme kel petbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Emri petbetem kel eme aposel tame etemne newobetem, eme peten wosbasken berai tatame etemne newopit peteyabetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Livai tame ere Saiprus ailanke yam, ere etemken temenem, eri sig Josep. Aposel tame eme erne akeite sig tem. Tem sig Barnabas. Ete sig eri somo Kuye Kwaye Tuma Wobe Tame. ");
INSERT INTO yss_yawu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ete tame eri sel akeite tame eme tukem, kel ere peten aposel tame emne newom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tame wuri eri sig Ananaias, ere taken, ta teri sig Safaira. Tame ere epne sel tuken epe kel petem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Petem, ta te kir wom, kel kau ere sem, kau ere aposel tame emne newon etep wom. Petye kel ab ete. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pita ere Ananaias erne etep wom. Ananaias, beke Satan ere nene guleleye, eke ne tuma yikwokwoye? An petye kel te ab eteke. Ne etepkap teye, ne God Eteri Wou erne tuma yikwokwobe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ne ete sel beke newon tukte sel e nereri. Ne sel tukem, ete kel e nereri. Etepkap, beke ne porere yaper peten ete wule yaper nenye? Ne tamewoune beke tuma yikwokwo. Ne God eterne kir tuma yikwokwoye. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias ere ete tuma metem, ere agetage waren tuknan me sam. Etep temke, eme kenake akem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Etep ten kau muyen si tame eme eri kupa peten matek leyen sen yin meike rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kerake nenem, Safaira te yan woram, te beke met, tame ere sam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Yan woramke, Pita ere tene etep wometem. Gwo kel kep nemne newoye, kep kiyi selke petem kel, ab ete o? Te wom. Ye, ab ete kem petye. Te etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ere tene sene etep wometem. Beke kep kir won God Eri Wou erne seilaye? Metye. Muyen si tame eme neri tame erne sen yin meike rasye, eme sene yabe. Eme ake eruke teteten. Eme nene kir sen yin meike raste nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Etep womke, agetage te Pita eteri tewo borke waren san tuknam. Muyen si tame eme woran lam, ta te san tuknamenem, eme tene pet sen yin tame eterne rasem meike tene etek kir rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jisas erne abobetem tatameken akeite tatameken eme etep metem, eme kenake akem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposel tame eme rigrabe tatame emne nenem. Jisas erne abobetem tatame eme God eteri ake eisauke yin maklek kwokwos wuri kwokwos wuri poyim. Emri poibetem emi eri sig e Solomon Eteri Makle. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Poibetem, akeite tatame nogwape eme etep abobetem. Jisas erne abobe tatame eme yenbo. Etep abobetem, eke eme Jisas erne kenawaike abobetem tame etemken beke poi. Eme me akem, eke eme etemken beke poi. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tatame nogwape eme beke ak, eme Jisas erne kenawaike abom, eme nogwapewai tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tatame nogwape eme aposel tame emri nenbetem rigrabe eme eyi metmenem. Metmenem, eme let kere tewo kere tatame sen yin keluke yin tukna rewo petan etek rasrubetem. Eme etepke abom. Pita ere gwo keluke yate, eri wou kelu ep yekwok yate nenbe. Pita eri wou let kere tewo kere tatame emne tousin yite, eme yenbo tete. Eme etepke abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tatame nogwape eme Jerusalem kom mekinke temenem, eme Jerusalemke yam. Eme let kere tewo kere tatame, omugabo gulelemenem tatame emne kir panen yam. Panen yam, aposel tame eme emne eyarem, eme akei yenbo tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","God eteri ake yaku kere tame etemri apeilake eter, etemri somo nuk etem, Sadyusi tameken eme aposel tame emri yaku lam, eme emne pap wayen eme emne yaper nente tuma namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Namdem, eme aposel tame emne keresukun ake yaperke won wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ake yaperke won wurin temenem, neirke God eteri komri tame ere yan ake yaper eri eru latrasen ere aposel tame emne sene won worakwutem. Ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Kem yin God eteri ake eisauke yin teten tatame emne tuma wusoute. Eme Jisas eterken noub temente. Kem emne etep wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Etep womke, ei beramke, aposel tame eme yin God eteri ake eisauke wurin tatame emne tuma tasen wusowum. God eri ake eisau eri apeilake eter, etemri somo nuk etem eme Juda etemri kaunsil etemken wurisubuk sin tuma namdebetem. Namdebetem, eme ake yaperke tuma wopitin etep wom. Kem aposel tame emne panen ya. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nau se tame eme ake yaperke yin emne soplawoyim. Aposel tame eme etek beke temen. Etep lam, nau se tame eme kaunsil tame emne sene yan etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Nema ake yaperke yin laye, ake yaper eru noub kitmenem, lakerebetem tame eme eruke tetyewomenye. Nema eru laten wurin nema lawoiwo, tame beke te. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","God eteri akeri apeilake etem, God eri ake lakere tame etemri apeilake etem eme etep meten eme ep abo ep abom. Eme etep wom. Mapeke etepkap teye? ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Etep sin wobetemke, tame wuri ere yan woran etep wom. Kem ake yaperke won yim tame eme sene God eteri ake eisauke woran teten tatame emne tuma wusoube. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Etep womke, God eteri ake lakere tame etemri apeilake ere nau se tameken eme God eteri ake eisauke yin ete tame emne peten sene panen yam. Panen yam, lakerebetem tame eme komri tatame emne akem, eke eme aposel tame emne beke pe. Eme etep wom. Komri tatame eme nemne kap pap mane wayen, nemne pape paku peten kip seitin pete wurken. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Eme aposel tame emne panen woran kaunsil tame etemri bitimik tetem. Tetem, God eteri akeri apeilake tame ere emne etep wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Kiyi nema kemne kenake etep wom. Kem tatame emne tuma mane wusoute. Jisas eri sig kep mane wusoute. Kem nerem womkap beke nen. Jerusalemri tatame nogwape eme kemri tuma mette wurken. Kem emne etep wobe. Kaunsil tame eme Jisas erne pen sam. Etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita ere aposel tameken eme awosein etep wom. Nema God eteri tuma noub meten tobote. Tatame emri tuma nema etep beke kip meten tobo. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kem Jisas erne me kwuran kwanen sam. Neremri yeiwarege etemri God ere Jisas erne yenbo nenen ere selek sene wayen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Selek sene wayen yim, ere neremri Keryen, ere neremne Kobo Labe Tame, ere God eteri yamame yekwok siten. Etek siten, Israelri tatame eme erne womette, ere neremri wule yapersaper peten sepitte, ere emne porere yenbo newote. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nema tatame emne etep wusoube, God Eteri Wou eter kir emne wusoube. Tatame eme God eri tuma noub meten nente, God ere Eri Wou emne newote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaunsil tame eme Pita eri tuma metem, eme pap kenake wayen, eme aposel tame emne pen sate wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kaunsil tame wuri, eri sig Gamaliel, ere Farisi tame, ere etemken temenem. Ere Moses eri wule wusoubetem tame. Tatame nogwape eme erne metekwasbetem. Ere wayen teten etep wom. Aposel tame emne kem won kom genik wurte. Eme nemri namdete nenbe tuma kip mette wurken. Etep womke, eme emne panen woram. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gamaliel ere kaunsil tame emne etep wom. Kem Israelri tame, kem ari tuma ek met. Kem tame emne be wos nente, kem kiyi abolate. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kiyiri tame wuri, Teudas, ere yan etep wom. An Israelri apeilake. Etep womke, tame nogwapewai (400) eme eterwouke tem. Yuri ei nai tame eme Teudas erne pen sam, eri somo nok eme akei yikwute yakwutem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Sene gavman eme akei tatame emri sig peten siglou eisauke bas rasem. Ete yabel tem, tame wuri, Galiliri Judas, ere etep wom. An Israelri apeilake tame. Etep wom, tatame nogwape eme eteri wakse tem, yuri ei nai tame eme Judas erne pen sam, eri somo nok eme akei yikwute yakwutem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","An kemne wobe. Kem ete aposel tame emne mesginin yi. Aposel tame eme etemri porerek ete yaku kerebe, ete yaku ere agetage yaper tete nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Aposel tame eme God eteri murek kerebe, yaku ere som temente. Kem God erken mane naite. Ere etep wom, Kaunsil tame eme eri tuma metem, eme kir etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kaunsil tame eme aposel tame emne sene panen woran eme paku peten pen etep wom. Jisas eri sig kem tatame emne mane sene wusoute. Etep won eme emne sene won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yim, aposel tame eme etep wom. Nema Jisas eri yaku kerebe, nema mus metbe, nema me metekwasbe. God ere nemne labe, nema mureken, eke nema mus metbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kwokwos kwokwos eme God eteri ake eisauke wurin, eme tatame etemri ake kir wurbetem, eme Jisas eri tuma yenbo tatame emne wusoubetem. Eme etep wom. Jisas ere Krais, God eter won yam tame. Etep wobetem, eme ete yaku beke mesgin. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Yuri Jisas erne kenawaike abobetem tatame eme nogwapewai temke, kau eme Grik tuma namdebetem, kau eme Hibru tuma namdebetem. Etep ten eme ei nayim. Grik tuma namdebetem tame eme etep wom. Kem Hibru tuma namdebe tatame, eme awos newobe, keremri wane ta eme awos nogwape petbe. Neremri wana ta eme nogwape beke pet. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aposel tame nogwape (12-pela) eme Jisas erne abobetem tatame etemken sin tuma namdem. Eme etep wom. Nema tame nogwape (12-pela), nema awos newobe, e yaper. Nema etep nente, mapeke nema God eri tuma tatame emne wusoute? ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Geisimase, kem tame nogwape (7-pela) emne yaku newote. Etem eme awos lakere tame tete, eme awos newopit peteyate. Gwopkap tame emne kem ete yaku newote. God Eteri Wou ere etemken tetan. Eme porereken tame. Akeite tame eme emne yenbo wobe. Etepkap tame emne kem yaku newote. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Etep nente, nema aposel tame nema kwokwos kwokwos God erken tuma namdete, tatame emne God eteri tuma wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jisas erne abobetem tatame eme kir wom, eme Stiven erne yaku newom. Stiven ere God erne kenawaike abobetem, God Eteri Wou ere eterken temenem. Eme akeite tame emne kir yaku newom. Emri sig gwo. Filip, Prokorus, Nikanor, Timon, Parmenas, Nikolas. Nikolas ere Antiok komri tame. Kiyi ere Juda tame berai, sene ere Juda etemri nenbetemkap ere nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Emne yaku newom, tame eme emne aposel tame etemke panen yim, aposel tame eme God erken tuma namden eme tame nogwape (7-pela) emri let tarek kerem. Let tarek kerem, eme emne yaku newom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tatame nogwape eme God eteri tuma metem. Jerusalemri tatame nogwape eme Jisas erne kenawaike abobetem. God eteri akek yaku kerebetem tame nogwape etem kir eme Jisas erne kenawaike abobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God ere Stiven eterken temenem, eri mure eisau, ere rigrabeken akeite wosken yenbo nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kau tame eme Stiven erne teitkwunte wom, eme erken tuma wale kap naibetem. Eme Friman Sosaiti tame, eme God eteri ake nebule etek erne sukye worabetem. Ete tame eme kom peske yam tame. Eme Aleksandria komke yam, Sairini komke yam. Juda tame kau eme Silisia provinske yam, Esia provinske yam, etem kir eme Stiven erken tuma walekap naibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","God Eri Wou ere Stiven eterken temenem, ere porere yenbo temenem, ere tuma yenbo emne awosein wobetem, eme Stiven eri tuma teitkwunlawoyim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Teitkwunlawoyim, eme akeite tatame emne kel newon eme tuma yikwokwon etep wom. Stiven ere tuma yaper Moses erken God erken epne wom. Eme ete tuma me yikwokwom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Etep tem, tatame nogwape, apeilake tame, Moses eri wule wusoubetem tame eme ete tuma metem, eme Stiven erne pap kenake wayem. Pap kenake wayem, eme yan Stiven erne keresukun Juda etemri kaunsil tame etemri akek panen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kaunsil etemri akek yin wurim, yikwokwo tuma eme sene etep yikwokwon etep wom. Gwote tame Stiven ere God eri ake eisau tewok tewok wobetem, Moses eri wule ere tewok tewok tuma yaper wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nema etep metem, Stiven ere etep wom. Nasaret komri Jisas ere God eri ake eisau berayewote nenbe, Moses eri wule ogwon akeite wule tete. Stiven ere etep wom, eme ete tuma me yikwokwom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tatame nogwape eme kaunsil tame etemken simenem, eme Stiven erne lek temenem, eri bitimi labetem, ere God eteri kom tame bitimikap. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","God eteri akeri apeilake ere Stiven erne etep wometem. Emri woye tuma ere seken o? ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stiven ere erne awosein etep wom. Ari a, lakemase, kem wan tai. Kiyi nemri warege Abraham ere Mesopotemia selke temenem, ere Haran komke mak yimenem, God ere yenbowaike, ere Abraham erne late yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Late yim, ere erne etep wom. Ne neri maime kom, neri kom tame emne mesginin yite, an nene nowsel wuri peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Etep womke, Abraham ere Kaldia tatame emri nowsel mesginin yin Haran komke yin tem. Etek temenem, Abraham eteri a ere sam, God ere Abraham erne etep wom. Ne Israel selke yin tete. Ere yam, gwopte nema gwotek siten. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yam, God ere Abraham erne ete sel beke newo. Kerawai etepwou beke newo. Ere bepou me yin temenem. Ere ete tuma namden omom, Abraham eteri gwote yennan eme gwo sel yurik pette nenbe. Ete yabel, God ere Abraham erken tuma namderasem yabel, Abraham ere yenken berai. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God ere Abraham erne etep wom. Neri yuri yennan eme akeite selke tete nenbe. Eme akeite tameri yaku kerete nenbe, eme kel beke kip pet, eme yakusubu kerete nenbe. Akeite selri tame eme neri yuri yennan emne paku pebetete nenbe, nabe nogwape (400) eme ete selke temente nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tame eme neri yuri yennan emne paku pete, an emne awosein pete nenbe. Yennan ete sel mesginte, eme yan gwote selke ten arene sukye worate. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Etep womke, God ere Abraham erne wule newon ere etep wom. Kem kemri taureyen emne somo kwunte. Etep tete, kem late, ari wom tuma ere tuma seken. Etep wom. Yuri Abraham ere keryen temenem, eteri ta te yen warwiyim. Yen eri sig Aisak. Yen eri yabel ep yekwo let ep yekwo let bor mur keyem (8-pela), Abraham ere yen erne somo kwunem. Yuri Aisak ere eri yen Jekop erne kir somo kwunem. Yuri Jekop ere eri yen nogwape (12-pela) emne etepwou nenem. Ete yen eme Juda tatame etemri apeilake tame yuri tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ete tame eme etemri mase Josep erne pap wayem, eme erne akeite kantriri tame emne newon lake eme kel petem. Kel petem, Josep erne kantri Isip tame erne panen yin etemri kantri Isipke temenem, ere akeite tatame etemne yakusubu kerebetem. Kerebetem, God ere Josep eterken temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Eme erne yaper nenbetem, God ere Josep erne kobo labetem, ere noub temenem. Josep ere kantri Isip etemri keryen, Fero, eteri bitimik tetem, God ere Josep erne porere yenbo newom, Fero ere lam, Josep ere tame yenbo, eke ere Josep erne etep wom. Ne ari ake eisau lakerete, ne kantri Isip kir lakerete. Fero ere erne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Yuri kantri Isipken kantri Kenanke temenem tatame etemri awos yabel kerke eyin saiwom. Akei tatame eme kwoi an saiwobetem. Nemri yeiwarege eme awosken berai. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Etep tem, Jekop ere tuma metem, awos nogwape Isipke temenem. Etep metem, ere nemri yeiwarege tewo wurik emne won kantri Isipke yin awos tuken sen yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Yuri eme sene yim, Josep ere eri sig emne wusowum, Keryen Fero ere Josep eteri lakemase emne lam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Sene Josep ere eri a, Jekop, erne tuma wopitin etep wom. Kem akei, kem Isipke ya. Jekop eri yenta, yaku kere tameken eme nogwape (75-pela) temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Etep womke, Jekop ere Isipke waren yim. Yim, yuri ere etek sam, nemri yeiwarege eme kir etek saiwom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yuri eme Jekop eteri ya tareken nemri yeiwarege etemri ya tareken peten Sekim komke sen yin etek rasem. Ete rasem sel, kiyi Abraham ere Hamor eteri yen etemne sel kelke tukem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","God ere Abraham eterken namderasem tuma ere nente wule mekin tem, nemri yeiwarege eme kantri Isipke temenem, eme nogwapewai tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nogwape tem, akeite tame ere kantri Isipke panen simenem, ere Josep erne kiyi mak lamenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kiyi mak lamenem, ere yeiwarege emne tuma yikwokwon emne paku pebetem. Ere emne etep wom. Kemri geibele yen kem kelpe emik rasruwun sate. Etep beke nen tatame an emne pete. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Etep womenem, Moses eri nawo te Moses erne warwiyin simenem. God ere lam, ere yen yenbowai. Warwiyim, anenawo epe erne lup mur noub lakerem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Lakerem, eme erne kelpe emik rasrumenem, Keryen Fero eteri yedeyen etet te Moses erne peten muk newom, ere etetri yen sekenkap tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Etep tem, Moses ere Isip tatame emri selpap, porerekap peten ere yaku yenbowai kerebetem. Ere tuma noub wusoubetem tame tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Eri nabe nogwape (40-pela) temke, ere etep wom. An areri kom tame emne yin late. Eme akeite tameri yaku kerebe, eme kel beke pet. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ere yin lam, Isip tame wuri ere Israel tame erne pebetem. Etep lam, ere erne kobo lan ei woran Isip tame erne awosein pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pen sam, Moses ere etep abom. Ari kom tame eme kir metten, God ere ane won emne kobo late. Etep abom, kom tame eme etep beke met, eme akeite porere tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kwokwos Moses ere lam, Israelri tame pes epe ei naibetem. Etep lamke, ere epne woran sareken etep wom. Kep lakemase, kep mane ei naite. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Paku ker kutem tame ere Moses erne keren tubane pitin erne etep wometem. Eike womke, ne neremri apeilake ten nemne noub lakerete? ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Yere ne Isipri tame wuri pen samkap ne ane etep sene pen sate wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Etep womke, Moses ere aken amen yim. Yim, ere kantri Isip mesginin Midian sel etek yin tem. Etek yin temenem, ere ta panen epe yen taureyen peske temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nabe nogwape (40-pela) Moses ere Midian selke temenem, ere tame berai emik yin tem, Sainai kow mekinke yin tem. Yin tem, ere lam, me nebule ker ere etek eibetem. Eibetem, Moses ere God eteri komri tame wuri erne etek lam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Lam, ere wouken akem, ere ker mekinke yin teten ere God eri tuma metem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","God ere etep wom. An God. An neri yeiwarege etemri Keryen God. Abraham, Aisak, Jekop etemri Keryen God. Etep womke, Moses ere aken let tewo me puyeir puyeirem, ere ker late me akem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","God ere etep wom. Ne tewo bus lugraste. Ari gwo tetan emi ere yenbowai. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","An lam, ari Isipke tetan tatame eme mus nogwape eisau metbe. Etemri kera taye an metbe. An yawo, an emne kobo late yawo. Eme sene yenbo tete nenbe. Moses, ne epe ya. An nene kantri Isipke won yite. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Israelri tatame eme Moses erne kiyi mo wom. Eme etep wom. Eike Moses erne won nemri apeilake tem? Etep wom. Sene Moses eterne God ere erne apeilake won tem. God eteri komri tame ere kerke temenem, ere Moses erne kobo lam. God ere erne womke, ere Israelri tatame emne kobo lam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses ere nogwape rigrabe nenbetem, ere Israel tatame emne panen yin kantri Isip mesginin yim, eme peik kupa eisauke yam. Peik kupa sig Wolepai Ok. Yam, eme ete peik kupa sel sokke wei wum. Wei wum, sene eme tameken berai emik sewurbetem, nabe nogwape (40-pela) eme etek sewurbetem. Etek sewurbetem, Moses ere rigrabe nogwape nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nenbetem, ere Israelri tatame emne etep wom. Yuri God ere arenkap tame wuri kemne won yate. Ere keremri Juda tame, ere yate, ere kemne tuma wusou tame tete. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Israelri tatame eme tameken berai emik temenem, Moses ere etemken temenem. God eri kom tame ere Sainai kowke yan yeiwarege emne tuma wusoute yeirim, ere Moses eterne tuma wusowum. Wusowum, sene Moses ere ete tuma Israelri tatame emne wusowum. Emne wusowum tuma ere som tetan, e God eteri tuma. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Neremri yeiwarege eme Moses eteri tuma beke met. Eri wom tuma eme selke sepitim. Eme kantri Isip kenake abon, eme etek sene yite abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yite abom, Moses ere Sainai kowke yawon temenem, Israelri tatame eme Moses eri mase, Aron, erne etep wom. Moses ere nene kantri Isipke panen yam, nema beke la, ere kap mak yim? Eke ne nemne memake wuri regte. Nema Isipke sene yite, memake ere taresin, nemne kelu peterate. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Etep womke, eme bulmakau yenkap wos wuri regem, eme bulmakau yenkap wos erne kwar pen sukye woram. Emri letke regem bulmakau yenkap wos eme metekwasen eme etep tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Etep temke, God ere emne mesginin yim. Eme wule yaper nenem, eme sowken lupken yabelken emne sukye worabetem. Tuma wusoubetem tame eme siglouke etep bas rasem. God ere wom. Israelri tatame, kem nabe nogwape (40-pela) tame berai emik temenem, kem ane kwar beke pe. Berai. Kem memake etemne kwar pebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kem memake etemri sipsip wuske kerem ake sen sewurbetem. Ete memake eri sig Molek. Kem sowkap sukye tare sen sewurbetem. Sukye tare eri sig Refan. Kem sukye tare nenem, kem sukye worabetem. Kem etep nenbetete, an kemne mesginte. An kemne gene komke won yite, kem kantri Babilon mesginin kin yekwok an kemne etek won yin, kem etek temente. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Neremri yeiwarege eme tameken berai emik temenem, God eri sipsip wuske kerem ake etek temenem. Eme etepkap ake kerem, God ere Moses erne tumak womkap, eme etepke kerem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yuri Josua ere emne panen akeite emik yin emri sel petem. God ere sel maime emne won eme yim, Israel tatame eme ete sel petem. Yin petem, eme God eteri sipsip wuske kerem ake peten sen yim, etek ten yamenem, yuri Devit ere sene tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devit ere tem, God ere erne metekwasem, Devit ere God erne etep wom. O Jekop eteri God, an nene ake wuri keren ne etek temente. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","God ere erne wotakem, yuri Solomon, Devit eteri yen, ere God eteri ake eisau wuri kerem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Keryen God ere tamek kerebe akek beke te. Tuma wusoubetem tame ere etep bas rasen etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","God ere etep wom. Nel e areri wolbaye yenbokap. Sel e areri tewo teit emi. Mapkap ake kem ane kerete? Ari ege si emi ma? ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Eike akei wos seikim? Aren an seikem. God ere etep wom, tuma wusoubetem tame ere etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stiven ere emne sene etep wom. Kem wan gwoleteye. Kemri selpap e God erne beke abo tatame etemri selpapkap. Kem God eri tuma beke met. Kem wan si tamekap. Kemri yeiwarege eme God Eri Wou magel taibekap kem etepwou tebe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kiyi yeiwarege eme tuma wusoubetem tame emne yaper nenbetem. Kiyi tuma wusou tame kau eme tuma won ek wobetem. Yuri tame yenbowai ere yate nenbe. Etep wobetem. Ete tuma wusoubetem tame, yeiwarege eme emne pen sam. Emri wom tame kem erne eteri peiktame etemke newom, e kerem erne pen samkap. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","God ere eri kom tame won eme God eri wule kemne wusowum. Wusowum, eri wule kem beke se. Stiven ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kaunsil tame eme Stiven eri tuma metem, eme pap wayen pogu takike kerem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pogu takike keremke, God Eri Wou ere Stiven eterken temenem, ere nerulam, ere God eteri wus yabel pasbekap lam. Ere lam, Jisas ere God eteri ya pi seit yekwok temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stiven ere etep wom. Ek la. Gwan beraye, an labe, Tatame Etemne Yeirim Tame ere God eteri ya pi seit yekwok tetan. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kaunsil tame eme etep metem, eme tuma noubke awosein won wan goromon eme agetage amekirin yan Stiven erne me keresukum. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Keresukum, eme erne panen kom sag mesginin epkera wurin yim. Yim, Stiven erne tuma pekam tame eme emri tame oub lugun Sol eterne newon semenem, eme pape peten seitin Stiven erne pebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Erne papek seitin pebetem, Stiven ere Jisas erne etep wom. Aneyen Jisas, ne ari wou pette. ");
INSERT INTO yss_yawu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Sene ere gulke pan noubke etep wom. Jisas, eme ane yaper nenbe. Ne emne awosein mane yaper nente. Etep wo mesginin ere ek sam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Eme Stiven erne pen sam, Sol ere etep wom. E kem yenboke nenye. Etep wom. Ete yabel tatame eme Jisas erne kenawaike abobetem tatame emne tasen yaper nenbetem, eme mus nogwape metbetem. Eke, eme Jerusalem kom mesginim, eme Judia distrikken Samaria distrikken etek yikwute yakwutem. Aposel tame etemwou eme Jerusalemke temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kau Juda tame, God eteri wule tobobetem tame eme yan keratiren Stiven eri kupa peten meike rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol ere Jisas erne abobetem tatame etemri akek wurare wurare yin wurbetem, taken tameken emne keresukun me lit sen yin ake yaperke won wurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yikwute yakwutem tatame nogwape eme God eteri tuma yenbo tatame emne wusowun sewurbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip ere Samaria distrikri kom wurik yim, ere tatame emne etep wom. Krais, God eter yaku newom tame erne kem kouten. Jisas eter ere Krais, God ere erne won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Etep wom, tatame nogwape eme eri tuma noub metem, Filip eri kerem yaku eisau eme lam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Gabok gulelem tatame nogwape Filip ere gabo emne won pekeroukbetem. Pekeroukbetem, gabo eme taye noubke piten tatame emne mesginbetem. Let kere tewo kere tatame nogwape, tewo yaper te tatame nogwape emne Filip ere yenbo eyarbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Etep tebetem, komri tatame eme etep lan eme metekwasbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ete kom tame wuri, eri sig Saimon, ere nuba labetem tame. Akei Samaria tatame eme eri nenbetemkap labetem, eme wouken akbetem. Saimon ere etep wobetem. Aren an apeilake. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tatame nogwape muyen si yen etem, keryen tatame etem, eme eri tuma meten eterne abobetem, eme eterne etep wobetem. God eri mure eisauwai Saimon eterke tetan. Eme etep wobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nabe nogwape Saimon ere etek temenem, nuba labetem, komri tatame eme eteri tuma noub metbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Sene Filip ere yan tatame emne Jisas Krais eri sig emne wusowum. God ere akei kom panen site tuma ere emne etep wusowum. Wusowum, tatame nogwape eme ete tuma som metem, eke Filip ere emne baptais ok wiruwum. Ere taken tameken emne baptais ok wiruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon, nuba labetem tame, eter kir ere Jisas erne kenawaike abobetem, eke eme erne baptais ok wiruwum. Wiruwum, ere Filip eterken yin sewurbetem, Filip ere rigrabe nenbetem, ere etep labetem, ere wouken akbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aposel tame eme Jerusalemke temenem, eme etep metem, Samaria tatame eme God eri tuma kenawaike abobetem. Etep metemke, eme Pitaken Jonken epne wom, epe Samariak yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Yimke, epe God erken tuma namden erne wometem, ere Samaria tatame emne God Eteri Wou newoteke wometem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kiyi emne baptais ok wiruwum, eme Aneyen Jisas eteri sig won baptais ok wiruwum. Wiruwum, God Eteri Wou ere emne beke yan te. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pitaken Jonken epe tatame emne wurare wurare let tarek kerem, eme God Eri Wou ek petem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon ere lam, aposel epe emne let tarek keren sewurbetem, eme God Eri Wou petbetem. Etep lam, ere aposel tame epne ete mure kelke tukte abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Etep abom, ere yan kel pet sen yin epne etep wom. Kep ari kel pette. Kep God eri mure ane newote, an tatame emne let tarek kerete, eme God Eri Wou pette. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita ere erne awosein etep wom. God eri bepou me newobe wos ne kuyese beke kip tuk. An abobe, neren, neri kelken ne ker eibe komke yite. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","God ere labe, nereri selpap e wule yaperke nenbe. Etepkap nesetri kerebe yaku ne kir kuyese beke kip kere. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ne God erne womette, ere nene kobo late, ere nereri nenbe wule yaper peten sepitte. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","An labe, ne nesetri yaku malbe, wule yaper nerenke som me tetan. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Etep womke, Saimon ere awosein etep wom. Kep God erne womette, ere ane kobo late. An ker tetan komke mane kip yite. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pitaken Jonken epri lam wos, God eri nenem wos epe tatame emne etep wusowum. God eteri tuma yenbo epe emne wusowum. Wusowum, epe Jerusalemke sene yim. Yibetem, epe God eri tuma nogwape Samariari komke yin wusowun yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yuri God eteri komri tame wuri ere yan Filip erne etep wom. Ne wos gelwon ne yale yekwok yite, Jerusalem mesginin Gasa komke yibe kelu ne etek yite. Ete kelu e tame beke te emik yibe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip ere wos gelwon ere me yim. Yibetem, ere kantri Itiopiari tame erne lam. Ete tame ere Jerusalem komke yin ere sene ete keluke sene yabetem. Ere Jerusalemke yin God erne sukye woran sene yabetem. Ete tame ere Itiopia kom panen si keryen ta teri kelken teri yenbo wosken lakerebetem tame. Keryen ta teri sig Kandasi. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yabetem, ere hoske litin yibe tiyke sin yibetem. Ere tuma wusoubetem tame, Aisaia, eter bas rasem siglou ere lan yibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Lan yibetem, God Eteri Wou ere Filip erne etep wom. Ne yin hoske litin yibe tiyke yin mekin tete. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip ere mekin yan wan rasen metem, tiyke simenen tame ere Aisaia eter bas rasem siglou lan wobetem. Filip ere erne etep wometem. Siglouke tetan tuma somo ne noub metten o? ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ere awosein etep wom. An mapeke mette? Eike ane tuma somo wusoute? Neren epe wayen nesa etep site. Ne ane tuma somo wusoute. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Eter labetem siglou eri tuma ere gwopkap. Eme sipsip peten sen yin botkwubekap, eme erne peten sen yim. Eme sipsip yen erne wus take kerbe, sipsip ere beke kera, eme erne yaper nenem, ere tuma beke wo. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Eme erne yaper nenem. Eme erne tuma pekam, eme tuma somo noub beke peka. Ere wule yaper beke wuri nen, eme erne bepou me pem. Eri yen supa berai, eke emri nenbekap eike wusoute? Eme erne pen sam, ere selke sene beke te. God eteri siglou tuma etep wobe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ete tame ere Filip erne etep wometem. Tuma wusoubetem tame, Aisaia, ere eikene wom? Eter maime o akeite tamene? ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filip ere God eteri siglou tuma erne tuma somo wusowum, sene ere Jisas eri tuma yenbo erne wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Epe keluke yibetem, epe peik nebule wuri yin lam, Itiopia tame ere etep wom. Ek la. Ok tetan. Ne ane baptais ok beke wiru. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip ere etep wom. Ne Jisas erne kenawaike abote, an nene ek baptais ok wirute. Itiopia tame ere awosein etep wom. An erne kenawaike abobe. Jisas Krais ere God Eteri Yen seken. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Etep womke, ere hos erne won tetem, Filip ere Itiopia tameken epe okke waren Filip ere erne baptais ok etek wiruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ok mesginin wayemke, God Eri Wou ere Filip erne panen akeite emik yim. Yim, Itiopia tame ere Filip erne sene beke la, ere keluke sene yin metekwasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip ere agetage Asdot komke yam, ere ete kom mesginin yin ere kom nogwapek yin tatame emne God eri tuma yenbo wusowum. Wusowum, sene ere Sisaria komke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Filip ere etep nenem, Sol ere Jisas eterne abobtem tatame emne yaper nenen emne pen sate wobetem. Ere God eteri ake eisauke yaku kerebe tame etemri apeilake erne yin etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ne siglou bas rasen ane newote. Ete siglou an Damaskus komke sen yin God eteri akeri tame emne peterate. Etep womke, ere siglou etep bas rasem. Jisas erne kenawaike abobe tatame, Sol ere emne keresukun panen Jerusalemke yate, e yenbo. Etep bas rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol ere yibetem, ere Damaskus mekin mekinmenem, agetage pelalakap an erne tukap tobuk peten ere kom genik tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tem, ere selke waren tuknan tuma wuri metem. Ete tuma ere erne etepke wom. Sol, Sol, ne beke ane som yaper nenbe? ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Etep womke, Sol ere wometem. Aneyen, ne eike? Ere awosein etep wom. Gwo aren. An Jisas, ne ane yaperke nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Neren epe wayen teten kom sagke wur. Yuri tame wuri ere nene be wos nente wote, ne etep nente. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sol erken sewurbetem tame eme etek temenem, eme tuma rebe tem. Wobetem tumawou eme metbetem. Eme tame beke la. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol ere wayen teten ere le bilelem, ere kuyese beke la. Kuyese beke la, eme erne let tobo keren panen Damaskuske yin tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yin temenem, yabel mur ere le beke nereyi nereya, aom kera beke a. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jisas erne kenawaike abobetem tame wuri ere Damaskuske temenem, eri sig Ananaias. Ere nugsi tuknalam, ere Aneyen Jisas erne lam. Jisas ere erne etep wom. Ananaias. Ere awosein etep wom. Aneyen, an gwo. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Aneyen ere erne etep wom. Ne wayen yi. Kelu wuri eme etep wobe, Tepererese Kelu, ne etek yite, ne Judas eteri akek yin wurte. Tarsus komri tame wuri ere etek tetan. Eri sig Sol. Ere God eterken etek tuma namdebe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ere kir, ere nugsi tuknalam, ere lam, tame wuri, eri sig Ananaias, ere yan woran let eteri tarek keremke, ere le nereyi nereyam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias ere awosein etep wom. Aneyen, tame nogwape eme ane wusoube, ete tame, Sol, ere nene abobe tatame, Jerusalemke ten yaten tatame emne yaperke nenbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","God eri ake eisauri apeilake ere Sol erne yaku newon ere Damaskuske yan nene abobe tatame emne keresukte. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Aneyen ere etep wom. Ne epe yi. An Sol erne kenem, ere ari yaku kerete. Ari tuma ere akeite tatame, kom panen si apeilake, Israelri tatame emne wusoute. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ere areri tuma wusoute, ere mus nogwape mette. An erne etep peterate nenbe. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananaias ere yin akek wurin Sol eterne let tarek keren ere etep wom. Apule yen, Aneyen Jisas ne erne keluke lam, ere ane woye, eke an nene late yawo. Ne le sene kuyese late, God Eri Wou ere nerenken temente. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaias eteri tuma tepken Sol eri lek temenem omyen garkap wos yeirsiyam, eri le boteyam. Boteyam, ere teten Ananaias ere erne baptais ok wiruwum. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wiruwum, Sol ere ma naku an mure sene petem. Jisas erne kenawaike abobetem tatame eme Damaskuske temenem, Sol ere etemken yabel pes tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ere God eteri akek yin Jisas eteri tuma tatame emne wusowum. Ere etep wom. Jisas ere God Eteri Yen seken. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tatame nogwape eme eri tuma metem, eme wouken akem. Eme etep wom. Ete tame ere Jerusalemke temenem, Jisas eteri sig wobetem tatame ere emne yaper nenbetem. Ere gwok yam, ere Jisas eri tatame emne kip keresukun panen yiteke yam. Ere emne God eteri ake eisauri apeilake etemne panen yiteke yam. Ete tame eter. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol ere mureken tem, ere etep wusowum. Sekenwai. Jisas ere Krais, ere God eter wom tame. Etep wom, Damaskuske temenem Juda tatame, eme eri tuma metem, eme abolawoyin, tuma rebe tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yabel nogwape tem, Juda tame eme poyin Sol erne pen sate tuma namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Namdem, Sol ere metem, eme erne pen sate wom. Erne pen sate won neirken yabelken eme kelu ei sibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ei sibetem, neirke Sol eri somo nuk eme erne panen papek pemenem serke yim. Yim, eme eip eisau peten Sol ere eipke waren simenemke, eme erne kepke nenewaren ser ep yekwo ganke tetruwun ere Damaskus kom kuyese mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol ere Jerusalemke yin tem, Jisas erne kenawaike abobetem tatame etemken poite yin lawoyim. Eme erne akem, eme etep abom. Sol ere Jisas erne beke abo. Etep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Etep tem, Barnabas ere Sol erne kobo lam, ere Sol erne panen aposel tame etemne late yim. Ere emne etep wom. Sol ere Aneyen Jisas erne keluke lam, Jisas ere eterken tuma namdem. Sene Sol ere Jisas eri sig Damaskusri tatame emne wusoubetem. Wusoubetem, ere beke ak. Barnabas ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Etep womke, Sol ere etemken temenem, ere Jerusalem komke sewuren tatame emne Jisas eri tuma wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wusoubetem, kau Juda tame eme Grik tuma meten namdebetem tame, Sol ere etemken Grik tumak namdebetem, eme tuma wale kap naibetem. Wale kap naibetem, eme Sol erne pen sate wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pen sate womke, lakemase eme etep metem, eme Sol erne Sisaria komke panen yin eme erne Tarsus komke won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Judiari tatame, Galiliri tatame, Samariari tatame Jisas erne kenawaike abobetem, eme noubwai me temenem. Emri peiktame eme etemken beke nai, eme pap yenbo metbetem. Eme God eteri tuma noubwai semenem. God Eteri Wou ere emne kobo lam, eme mureken temenem, tatame nogwape eme Jisas erne kenawaike abobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ere kom nogwapeke sewurbetem. Sewurbetem, God eteri tatame Lida komke temenem, ere emne late yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yin lam, tame wuri, eri sig Ainias ere etek temenem. Eri kin gwai borkupakap teyewom, ere tiyke tuknamenem. Ere nabe ep yekwo let ep yekwo let bor mur (8-pela) temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Etep lam, Pita ere erne etep wom. Ainias, Jisas Krais ere nene yenbo nente. Ne teten neri tukna rewo peten gwolte. Agetage Ainias ere wayen tetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wayen tetem, Lida komri tatame, Saron komri tatame eme etep lam, eme Aneyen Jisas erne kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jisas erne abobetem ta wuri te Jopa komke temenem, teri sig Tabita. Grik tuma eme etemri sig wobe. Dorkas. Kwokwos kwokwos te yenbo wos nenbetem, te wosken berai tatame emne kobo labetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pita ere Jopak temenem, ete ta te kapoyi keyen te sam. Sam, eme teri kupa peten ok keyan meker ake tiyke sen yawon rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida komken Jopa komke mekinke tetan. Jisas erne abobetem tame eme metem, Pita ere Lida komke temenem. Etep metem, eme tame pes won erne late yim. Epe erne etep wom. Ne agetage nesetken yite. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Etep womke, Pita ere etepken yim. Yin kom petem, epe erne meker ake tiyke panen yawom. Yawom, wane ta nogwape eme yan Pita erne teten kerabetem. Kerabetem, nogwape mate, tame oub, Dorkas te temenemke nenbetem wos eme peten erne peteram. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peteram, Pita ere emne won yim, ere gulke pan God eterken tuma namdem. Namdem, ere petkwon lan ete ta teri kupa lan etep wom. Tabita, ne epe wayen si. Te le sene bilelen nereyi nereyan Pita erne lan te wayen sim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Wayen sim, Pita ere etetri ya wagnek keren nenewayen tetruwem. Jisas erne abobetem tatameken wane taken, ere emne sene won worakwutem. Worakwutem, Pita ere ta tene sene emne newom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Etep tem, ete tuma Jopa komri tatame nogwape eme metem, eme Aneyen Jisas erne kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Yabel nogwape Pita ere Jopak temenem. Ere bulmakau wus yaku kerebetem tame wuri eterken temenem. Eri sig Saimon. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tame wuri ere Sisaria komke temenem, eri sig Kornilius. Ere ei nai tame nogwape (100) etemri apeilake. Ei nai tame eme kantri Itali etemri ei nai tame. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","E tame ere God eri wule semenem tame. Eri yentaken akei eme God eterne sukye worabetem. Kornilius ere tame yenbowai, ere kel nogwape petbetem, wosbasken berai Juda tatame emne newopit peteyabetem. Ere God erken tuma kwokwos kwokwos namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yabel wuri yabel warbetem, ere nugsikap tuknalam. Ere lam, God eteri kom tame wuri ere yan woran erne lan etep wom. Kornilius. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Etep wom, Kornilius ere lan aken etep wom. Aneyen, ne beke yawo? God eri kom tame ere erne awosein etep wom. Neri tuma God ere metem. Ne wosken berai tatame emne kobo labe, God ere etep lan nene abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gwopte ne tame pes epne Jopa komke won yite. Epe yin tame wuri, eri sig Saimon, erne won ere ya. Eri akeite sig e Pita. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ete tame ere yiwol Saimon eteri akek tetan. Ake ere gare okkap peik barke tetan. Ere bulmakau wus yaku kerebe tame. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","God eri kom tame ere etep won ere sene yimke, Kornilius ere yaku kerebe tame pes, ei nai tame wuri emne won yim. Ei nai tame ere God erne kenawaike abobetem tame, kwokwos yabel ere Kornilius eterken sewurbetem, erne yaku kobo labetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Won yam, eri nugsik tuknalamkap Kornilius ere etep emne wusowun emne won Jopak yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kwokwos eme yan kom sag Jopa mekinke yan temenem, yabel me pemke, Juda etemri tiykap peta ake magelke Pita ere yawon God erken tuma etek namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Namdebetem, ere kwoi san ate abom. Eme awos nenbetem, Pita ere nugsikap tukna lam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ere etepke lam. Nel eikap beram, God eteri komri tame eme yabel oub megke ep yekwo ep yekwoken selke neneyeirim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Neneyeirim, ete yabel oub mei nogwape eikena abona portoub, sopo, om ap eme etek yewomenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Yewomenem, tuma wuri etep wom. Pita, ne wayen teten kau pen ate. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita ere etep wom. Aneyen, an mo woye. An beke kip pen a. Etepkap aom an beke a. Nemri Juda wule etepke wobe. Ete wos e yaper, tame mane ate. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ere awosein etep wom. Be wos God ere wobe e yenbo, ete wos ne yaper mane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ete wos Pita ere tewo mur lamke, yabel oub eme sene neneyau petem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ere etep lamke, Pita ere ep abo ep abom. Ere etep wom. E aren laye nugsi somo ere mapkap? Ere etep abomke, Kornilius eri wom tame eme yan Saimon eri ake wometen yan ake eru tumak tetyewom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Eme etepke wometem, Saimon Pita ere gwotek tetan o? ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita ere nugsi abobetem, God Eteri Wou ere erne etep wom. Metye. Tame mur eme nene sopbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ne epe wayen waren etemken yite. Ne mane ep abo ep abote. Aren, an emne won yawo. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Etep womke, Pita ere waren ete tame emne etep wom. Kemri sopbe tame aren. Kem beke yawo? ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Eme awosein etep wom. Ei nai apeilake Kornilius ere nemne won yawo. Ere tame yenbo, ere God erne sukye worabe tame. Juda tame nogwape eme erne tame yenbo wobe. Yeki God eri kom tame ere yan erne etep wom. Ne Saimon Pita erne won ere ya. Yate, ne eteri tuma mette. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita ere emne wopetem, eme eteri akek tuknam. Kwokwos ere wos gelwon ere etemken yim. Jopari tame kau, Jisas erne abobetem tame eme Pita eterken etep yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Eme yin kwokwos eme Sisaria kom yin petem. Kornilius ere eri tamenowu o tamesip emne won yan eme wurisubu emik poyin Pita erne koumenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita ere akek wurte wom, Kornilius ere yan eteri tewo tobok gulke pam. Ere abom, Pita ere tame yenbo, eke ere etepkap tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Gulke pam, Pita ere erne nenewayen tetruwun etep wom. Ne etepkap mane nente. Nesa kir tame. An God eterkap berai. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita ere eterken tuma namden epe akek wurin lam, tatame nogwape eme wurisubu emik poimenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Lam, Pita ere emne etep wom. An Juda tame, kem Juda berai tatame. Nema Juda tatame, nema Juda berai tatame etemken beke sin an tuma beke namde. Yeki an nugsi tuknalam, God ere ane peteram, gwopte an kemne tame yaper sene beke kip wo. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Etepkap kem ane yate wom, an kemri tuma beke metkwun, an yawo. Beke kem ane won yawo? ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornilius ere etep wom. Yeki yabel epe pes epe pes tem, an ari akek temenem, an God erken tuma namdebetem. Gwotepkap yabel perpek an erken namdebetem, an lam, tame wuri ere ari bitimik tetem. Eri warmenem tame oub ere me lak bakbetem. Ere ane etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kornilius, God ere neri tuma metem. Ne wosken berai tatame emne kobo labe, God ere etep lan nene abobe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ne tame wuri won Jopa komke yin Saimon Pita erne won ere yate. Ere yiwol Saimon eteri akek tetan. Ere bulmakau wus yaku kerebe tame. Eri ake gare okkap peik barke tetan. Ete tame ere ane etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Etepkapke, an nene tame mur won eme agetage nene late yim. Ne yawo, e yenbo. Nema akei yan gwotek kouten. Aneyen ere nene newom tuma ne nemne etep wusoute, nema eteke mette kouten. Kornilius ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita ere etep wom. Gwopte an metem, God ere Juda tatame etemwoune noub beke nen. Ere tatame nogwape emne wule wurisubu nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Eike mari komri tame, ere God eterne sukye worate, eteri wule noub nente, God ere erne pap yewote. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","God ere nemne Juda tatame nemne tuma yenbo wom. Kem etep metem. Ere nemne Jisas Krais eterne wom. Jisas Krais ere tatame nogwape etemri Aneyen. Tatame eme erne kenawaike abote, eme kuyese noub temente. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kem metem, kiyi Jon ere tatame emne baptais ok wiruwum, sene God eri tuma yenbo eme Galili distrikke tasen Judiari kom nogwape etek yin wusoubetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kem metem, God ere Eri Wou, eri mure Nasaret komri tame, Jisas, erne newom. Newom, ere kom komke yin yenbotanbo wos nenbetem, tatame emne eyarbetem. God ere eterken temenem, Satan eri yaper nenbetem tatame emne ere sene eyarbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nema aposel tame, nema Jisas eri nenem wos, Judia distrikken Jerusalem komke etek nenem wos nema etep lam, eke nema etep wusoube. Eme erne mek kwuran kwanen ek pen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pen sam, yabel mur temke, God ere erne wou sene newon ere selek sene wayen yim, tatame nogwape eme erne lam, ere kelpe tamekap temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Juda tatame nogwape eme erne beke la. God ere kau tame nemne kiyi wom, neremwou nema erne lam. Ere selek sene wayen yim, ete yabel nema erken sin awos abetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ere nemne etep wom. Kem tatame nogwape emne tuma noub wote. Kem emne etep wo. God ere Jisas erne wom, ere kelpe tatameken sam tatameken emne akei late nenbe. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kiyi temenem tuma wusoubetem tame nogwape eme etep wobetem. Tatame eme Jisas erne abote, God ere emri wule yaper peten sepitte. Eme etep wobetem. Pita ere emne etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita ere tuma som wosoubetemke, God Eri Wou ere Pita eri tuma metmenem tatame etemke yeirim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jisas erne kenawaike abobetem Juda tame, Pita eterken yam tame, eme lam, God Eteri Wou ere akeite tatame emne kir newom. Etep lan eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Eme metem, akeite tame eme akeite akeite tumak namden God erne tuma yenbo wobetem. Pita ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","God Eteri Wou nerem petemkap, eme etepke petye. Etepkap, nema emne baptais ok wirute, eike emne wotakete? Beraiwai. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pita ere emne sene etep wom. Kem Jisas Krais eteri sigke baptais ok wirute. Wiruwum, eme erne etep wom. Ne neir pes yabel pes neremken gwotek temente. Eme etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposel tameken Judiak temenem geisimaseken eme tuma etep metem, akeite tatame eme God eri tuma petem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Etep metem, Pita ere Jerusalemke sene yamke, kau tame eme akeite tame emne somo kwunte wom tame, eme Pita erne tuma wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Eme etep wom. Pita, ne somo beke kwun tame etemri akek yin etemken awos am. Etepkap yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Etep womke, Pita ere emne eri nenemkap emne akei wusouyewon etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","An Jopa komke temenem, an God erken tuma namdebetemke, an nugsik tuknalakap lam. An lam, yabel oub eisau eme nelke neneyeirim, ep yekwo ep yekwo megke eme keren neneyeirim, aren temenem emik yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","An noub lam, eikena abona portoub, sopo, ap eme ete yabel oubke yewomenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Lan an tuma etepke metem. Pita, ne wayen teten kau pen ate. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","An etep wom. Aneyen, an mo woye. An beke kip pen a. Ete wos an beke a. Nemri Juda wule e etep wobe. E wos e yaper. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tuma ere ane sene wom. Be wos God ere wobe e yenbo, ne yaper mane wote. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","E wos tewo mur an lan ete yabel oub eme sene neneyau petem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Neneyau petem, tame mur eme yan aren temenem akek yam. Sisaria komri tame ere emne won ane late yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yam, God Eteri Wou ere ane etep wom. Ne etemken yite. Ne mane ep abo ep abote. Etep womke, ep yekwo let ep yekwo ges wuri kei (6-pela) lakemase eme arenken Sisaria komke yin Kornilius eteri ake yin wurim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yin wurim, Kornilius ere emne etep wom. Ne tame wuri won Jopa komke yin Saimon Pita erne won ere yate. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yate, ere nene tuma wusoute. God ere nene sene peten ne yenbo tete, neri akeri tatame etemken etep peten yenbo tete. Ere nene etep wote. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Etep womke, an emne tuma tasen wusoubetemke, God Eteri Wou ere etemke yeirim. Kiyi God Eteri Wou nemne yeirimkap, ere emne kir etep yeirim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Etep tem, Aneyen ere kiyi wom tuma an sene abom. Ere etep wom. Jon ere tatame emne okke wirubetem. Keremne God ere Eteri Wou kemne newote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kiyi nema Jisas Krais erne kenawaike abom, God ere nemne Eteri Wou nemne bepou me newomkap, God ere akeite tatame etepkap kir newom. Etepkap, an God erne mapeke kip wotake? Pita ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Eme Pita eri tuma etep metem, eme emri wobetem tuma mesginim. Eme God eri tuma yenbo won etep wom. God ere akeite tatame emne kir kobo labe. Eme etemri wule yaper mesginin, God ere emne wote, eme noub som temente nenbe. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kiyi eme Stiven erne pen sam, sene eme Jisas erne kenawaike abom tatame emne yaper nenbetem. Yaper nenbetem, Jisas erne kenawaike abobetem tatame eme amekirin yikwute yakwutem. Kau eme Fonisia distrikke yim, kau eme Saiprus ailanke yim, kau eme Antiok komke yim. Yim, God eri tuma eme Juda tatame etemwoune wusoubetem. Eme akeite tatame emne beke wusou. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Jisas erne abobetem tatame, kau eme Saiprus ailanri tame, Sairini komri tame, eme Antiok komke yin akeite tatame emne God eteri tuma wusowum. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Wusowum, Jisas eri mure etemke temenem, tatame nogwape eme Jisas erne abon pap yewom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalemke temenem tatame, Jisas erne kenawaike abobetem tatame eme etep metem, eme Barnabas erne won Antiokke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Yin lam, God ere tatame emne yenbo nenem, ere metekwasen emne etep wom. God eri tuma kem mane eiksete, kem eri tuma noub se. Kem eterken mekin temen. Ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ere tame yenbo. God Eri Wou ere eterken temenem, ere Jisas erne kenake abobetem. Eteke Antiokri tatame nogwape eme Jisas erne kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Sene Barnabas ere Tarsus komke yin Sol erne sopen late yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Lam, ere erne panen Antiok komke yam. Nabe wuri epe etek temenem. Epe Jisas eterne kenawaike abobetem tatame etemken temenem. Epe tatame nogwape emne God eri tuma wusoubetem. Jisas erne abobetem tatame eme Kristen sig Antiok komke petem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ete yabel God eri tuma wusoubetem tame eme Jerusalem mesginin Antiokke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yim, etemri wuri eri sig Agabus. God Eri Wou ere eterken temenem, ere etep wom. Yuri akei nowselri tatame eme nakwoi meig site nenbe. Etep wom. Yuri Kornilius ere Rom komri apeilake temenem, eme nakwoi meig sibetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Antiokri Kristen tatame eme etep metem, eme Judia Kristen tatame emne kobo lan etep wom. Nema emne kel newote, emne kobo late. Kelken tame eme nogwape newote, kel nebule tetan tame eme kerake newote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Etep tem, kel eme Barnabasken Solken etepne newon epe Jerusalemri Kristen etemri apeilake etemne sen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ete yabel apeilake Herot ere kau Kristen tatame emne yaper nente abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ere eri ei nai tame emne wom, eme Jon eteri lake Jems erne gapakuk borwag regen sam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Etep tem, apeilake Herot ere lam, Juda tatame eme eri nenemkap metekwasem. Etep lam, ere yaper sene nenem, ere Pita erne keikeresukun kepke peiken rasem. Juda tatame eme yisken berai bret abetem yabelke etep tem, eme Pita erne kepke peiken rasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Peik rasem, eme erne ake yaperke panen wurim, ei nai tame epe pes epe pes eme Pita erne lakerebetem. Lakerebetem, Herot ere abom. Yuri nema yisken berai bret abe yabel omotek, an Pita erne Juda tatame etemri bitimik panen yin tuma ek namdete. Ere etep abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita ere ake yaperke temenem, Kristen tatame eme God erken tuma namdebetem, ere Pita erne kobo late. Eme etep namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herot ere Pita erne tuma namdete nenbetem yabel, ete neir Pita ere ei nai tame pes etepri borke tuknamenem. Eme erne ainke nenem kep peske peikmenem, ei nai tame nogwape eme ake yaper eru lakerebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Lakerebetem, agetage God eteri komri tame ere yam, ake puri eikap beram. Yan ere Pita erne baye tobo letke keren erne teren etep wom. Ne agetage wayen tetete. Etep womke, Pita ere wayen tetem, agetage eri letke peikmenem ainke nenem kep ere robokwunem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","God eteri komri tame ere erne etep wom. Ne neri moutip sin tewo bos wute. Etep temke, God eri komri tame ere sene etep wom. Ne neri tame oub waren ane semoute. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita ere erne semowun epe ake yaper mesginin yim. Yim, Pita ere etep abom. Kap God eteri komri tame ere ane panen yibe, o an kap nugsike tuknalabe? ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ere etep yibetem, erne lakerebetem tame emne epe me sekiyin yibetem. Sene yin kau tame eme lakerebetem, epe emne sekiyin yim. Akek yibe kelu eme ainke nenem eru temenem emi yam, eru ere me latmenem, epe ek woran yim. Keluke yibetem, agetage God eri kom tame ere Pita erne mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pita ere abopitim, ere etep wom. An laye, Keryen God ere eri komri tame won yan ane petye. Herotken Juda tatameken eme ane tuma namdete wom, eme ane beke namde. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Etep abom, ere Jon Mak eteri nawo Maria etetri akek yim. Tatame nogwape eme ete akek poimenem, eme God erken tuma namdebetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Namdebetem, Pita ere ake eru yin pemetem, yaku kere ta teri sig Roda, te yan eru latte nenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Latte nenbetem, te Pita eri tuma ape meten te metekwasen te eru beke kiyi lat. Te sene peyapus rasen amen wurin etep wom. Pita eter ake eruke teteten. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Eme tene etep wom. Ne me belebe. Te awosein emne etep wom. Berai. Sekenwai. Ere yawo. Eme etep wom. Kap, eteri wouke yawo. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pita ere ake eru som pemetbetem, eme ake eru laten erne lan eme wouken akem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita ere emne letke wotaken eme tuma elen ten, ere emne tuma wusowum. Keryen God ere erne ake yaperke sene petem tuma etep kir wusowum. Ere emne etep wom. Kem Jemsken lakemase nogwapeken emne ete tuma wusoute. Etep won ere emne mesginin akeite emik yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ei beramke, ei nai tame eme me sopen etep wometem. Pita ere mak yiwo? ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herot ere etep wom. Kem Pita erne sopte. Etep wom, eme erne soplawoyim, Herot ere ake yaper lakerebetem tame emne pap wayen ere ei nai tame emne won ake yaper lakerebetem tame emne pen sam. Pen sam, Herot ere Judia distrik mesginin ere Sisaria komke waren etek temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herot ere Tairken Saidonken komri tatame emne pap kenake wayem. Ete tatame eme etep abom. Nema ei nente, nema apeilake Herot eri tatame emri awos mapeke tuk? Etep abomke, eme poyin eme Herot erken gerute wom. Eme Blastus erken tuma kiyi namderasen wurisubuk tem. Blastus ere apeilake Herot eteri ake eisau lakerebetem tame. Porere wurisubuk rasen Blastus ere Tairken Saidonken komri tatame emne kobo lan tuma kir namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herot ere wom yabel temke, ere keryen etemri kerap wolen wolbaye yenbo etek sin tatame emne tuma namdem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Namden, tatame nogwape eme eteri tuma meten etep wom. Ere tame berai, ere God. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Etep womke, Herot ere tatame emne beke wotake, ere God eri sig eisau beke wo, eke agetage God eri kom tame ere yan Herot erne pen sopoyow eme erne tan sam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kristen tatame eme God eri tuma kom komke wusoubetem. Tatame nogwape eme meten, eme Jisas erne kenawaike abom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabasken Solken epe kel Jerusalemke sen yin newo mesginin epe Jon Mak erne Antiok komke panen yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokri Kristen tatame kau eme tuma wusoubetem tame. Emri sig gwo. Wuri ere Barnabas, wuri ere Simeon, eri sig wuri Niger. Wuri ere Lusius, ere Sairini komri tame. Wuri ere Manain, apeilake Herot eri anenawo epe Manain erne newon am. Wuri ere Sol. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ete tame eme wurik poyin a naku takeren God erken tuma namdebetem, God Eri Wou ere emne etep wom. Kem Barnabasken Solken epne wote, epe ari wom yaku kerete. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Eme sene a naku takeren God erken namden sene eme epne let keren epne won yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","God Eri Wou ere Barnabasken Solken epne wom, epe Selusia komke yim. Yin epe sip peten epe Saiprus ailanke yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Yin epe Salamis komke gayin God eri tuma epe etek wusoubetem. Epe God eteri akek wurin emne wusoubetem. Jon Mak ere kir etepken temenem, epne yaku kobo labetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Sene eme Salamis kom mesginin eme gene genek yin ep yekwo peik barke waren Pafos komke yin tem. Yin tem, eme Juda tame wuri lam, eri sig Barjisas. Ere nuba labetem tame. Ere etepke tuma yikwokwobetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Barjisas ere apeilake Sergius Paulus eteri nowu. Sergius Paulus ere apeilake, ere porereken tame, ere God eri tuma mette wom. Ere Barnabasken Solken epne won yam. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Won yam, Barjisas, eteri Grik tumak wobe sig e Elimas, ere epne wotakem. Ere apeilake Sergius Paulus erne etep wom. Ne God erne mane abote. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","God Eri Wou ere Sol eterken temenem. Sol eteri akeite sig e Pol. Temenem, ere nuba labetem tame, Elimas, eterne le kuken lan etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ne Satan eteri yen. Ne nogwape wos yenbo etemri peiktame. Ne wos yaper nenbe, ne tuma yikwokwobe tame. Ne God eri kelu tukbe tame. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","God ere nene yaper nente nenbe. Yabel nogwape ne yabel beke la, ne le site nenbe. Etep womke, Elimas ere agetage le sim, ere etep wom. Le ari kerneirikap teye. Etep won ere belebalen sewurbetem, ere tame sopbetem, erne let tobo keren erne kelu peterate tame erne ere sopbetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Apeilake Sergius Paulus ere ete wos lan ere God erne kenawaike abom. Ere God eri tuma metem, eri pap etewouke tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol ere anepoi tameken eme sip peten Pafos kom mesginin Perga komke yim. Perga e Pamfilia provinske tetan. Ete komke temenem, Jon Mak ere Barnabasken Polken epne mesginin ere Jerusalemke sene yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Yim, epe Perga kom mesginin epe yin akeite Antiok komke yin tem. Ete Antiok kom ere Pisidia distrikke tetan. Juda etemri ege si yabel tem, epe God eteri akek wurin sim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Sim, God eri akeri tame eme Moses eri wuleri siglou lan wom. Kiyiri tuma wusoubetem tame emri siglou eme kir lan womke, eme epne tuma wopitin etep wom. Mase, kep pap yenbo met tuma abobe, kep nemne wusoute. Etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol ere teten ya nenewayen sen ere etep wom. Kem Israelri tame, kem akeite tame, God erne sukye worabe tame, kem ari tuma met. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","God ere Israelri tatame etemri God, ere neremri yeiwarege emne kenem. Yeiwarege eme Isip selke ya tamekap yin temenem, eme nogwape tem. God eri mure eisau tetan, ere emne panen eme Isip sel mesginin yim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Mesginin yim, nabe nogwapewai (40-pela) eme emi yaperke sewurbetem. Sewurbetem, eme yaper wos nenbetem, God ere emne lek me labetem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Sene Kenan nowselke temenem tatame, God ere emne akei pen saiwom. Ep yekwo let ep yekwo let bor pes kei (7-pela) kantri God ere e tatame emne pen saiwom, sam tame etemri sel God ere neremri yeiwarege emne newom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Newom, nabe nogwape (450) eme etek temenem. Sene God ere nowselken tatameken lakerebetem tame won eme Israelri tatame emne panen sin yan tuma wusoubetem tame, Samuel, ere yuri tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samuel ere temenem, Israelri tatame eme nowsel panen site keryen wuri God erne wometem. Wometem, God ere Kis eteri yen Sol, eterne wom. Sol ere Benjamin eteri tame supa. Wom, Sol ere keryen tem, nabe nogwape (40-pela) ere keryen temenem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sene God ere Sol erne won yim, Devit ere keryen tem. God ere tatame emne Devit eterne etep wom. Jesi eri yen, Devit, an eterne metekwasbe. Ari wote tuma ere etep nente. God ere etep wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Devit eteri tame supa, Jisas eter, ere Israel tatame emne sene petbe tame. Kiyi God ere ete tuma namderasem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kiyi Jisas ere mak yamenem, Jon ere Israel tatame emne etep wom. Kem kemri nenbe wule yaper pap yaper mette, an kemne baptais ok wirute. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon ere eri yaku omote wom, ere etep wom. Kem mapeke abobe, an eike? An kerem kouten tame berai. Ete tame ere yurik yate nenbe. An tame yenbo berai, nesa wolbaye wurik beke kip si. An sou tet yenkap, an selke site. Jon ere etep wom, ere eri sig teitkwunen Jisas eteri sig eisau wom. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ari geisimase, Abraham eteri somo nokken akeite tameken, kem God erne kenawaike abobe tatame, an kemne wobe. E tuma, God ere nemne sene pette tuma, ete tuma ere nemne wopitim. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jisas ere nemne sene petbe tame, Jerusalemri tameken apeilakeken eme noub beke met. Kwokwos yabel ege si yabelke eme tuma wusoubetem tame eteri siglou labetem, eme tuma somo noub beke abo. Kiyi tuma wusoubetem tame eme etep wom. Kem Krais erne tuma pekate nenbe. Etep wom, eme etep tem, ete tuma ere sekenwai tem. ");
INSERT INTO yss_yawu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Eme eri nenem wule yaper beke wuri la, eme apeilake Pailat erne won Jisas erne bepou me pen sam. ");
INSERT I