﻿USE sofia;
DROP TABLE IF EXISTS sofia.yreNT_vpl;
CREATE TABLE yreNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yreNT_vpl WRITE;
INSERT INTO yreNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Zozi Crizi a David kluda min -a, ɛn e ya \"nyian Abraam kluda min -a. Zozi tranun 'tɔ nɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraam Izak -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ɛn Zuda 'lee Tama bɛ, o Faras 'lee Zara -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ɛn Aram Aminada -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ɛn Salmɔn 'lee 'e nan Rab bɛ, o Boazɩ -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ɛn Jese David nɛn e drɛ mingɔnnɛn -a bɛ, -a -ya. Ɛn David Salomɔn -ya 'o 'vale Uri -le -cale -a. ");
INSERT INTO yreNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ɛn Salomɔn Robɔam -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ɛn Asa Zozafa -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ɛn Ozia Zoatan -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ɛn Ezekia Manase -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ɛn Zozia Zekonia 'lee 'e \"bʋɩnun yaa. E o yaa tʋ nɛn o -ko Izraɛl 'nɔn 'a Babilɔn bɛ -a man. ");
INSERT INTO yreNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Zɩ o -kʋ Babilɔn \"bɛ -sru \"bɛ, ɛn Zekonia Salatiɛl -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ɛn Zorobabɛl Abiudi -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ɛn Azo Sadoci -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɛn Eliu Eleaza -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ɛn Zago Zozɛfʋ nɛn e cɩ Mari -sran -a bɛ, -a -ya. ");
INSERT INTO yreNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Klu pɛɛnɔn zɩɛ -a \"nɛn \"nɛn 'gʋ: -E e \"sia Abraam da -trilii, -e 'e bɔ David man bɛ, e ya klu -fuda sinjɛn. -E e \"sia David da -trilii, -e 'e bɔ tʋ nɛn o -ko Izraɛl 'nɔn 'a Babilɔn bɛ -a man bɛ, e ya klu -fuda sinjɛn. -E e \"sia tʋ nɛn o -ko Izraɛl 'nɔn 'a Babilɔn -trilii, -e 'e bɔ min 'sizan 'wɩ 'ji Crizi man bɛ, e ya klu -fuda sinjɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Zɩ Zozi 'yanan wɩ cɩ 'gʋ: Mari a Zozɛfʋ 'tɔ da 'nan -e 'e 'pa. Wa'a tian 'o cin -tɔlɛ lɩ 'lee -kɔnnɛn -a dɩ, ɛn Mari 'e 'pɔn 'si Bali lei man. ");
INSERT INTO yreNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zozɛfʋ nɛn, e \"ta -daa Mari 'palɛ bɛ, e ya min tɩglɩ 'a. E 'ka \"vale 'nan 'e Mari 'ci bɔala dɩ -le \"wɛan, yaa nrɔn 'e 'ji 'nan e \"cɛan \"man 'e yɔɔdɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","E -fʋ 'e 'ci \"nrɔnnan 'wɩ zɩɛ -a da, ɛn Bali -le 'pasianɔn nɛn laji bɛ -a -tʋ -ta \"va \"nyrinvla. E -yrɛ 'nan: «David kluda min Zozɛfʋ, te Mari 'padɩ \"klan 'e 'i 'tɛ dɩ! 'Nɛn nɛn -a -pɔn cɩ \"man \"bɛ, e \"sia Bali lei va. ");
INSERT INTO yreNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mari \"ta -daa 'nɛn 'klɔnmɔn -yalɛ. 'Nɛn zɩɛ 'i 'tɔ 'pa Zozi. -Yɛɛ \"ta -daa 'yee minnun 'silɛ 'wɩ 'wlidɩ \"ji.» ");
INSERT INTO yreNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","'Wɩ pɛɛnɔn zɩɛ, e drɛ 'wɩ nɛn Bali 'lewei vɩzan -a 'vɩ 'e 'cɛn bɛ -a 'lɛ sɔɔdɩ -a. Kɔɔ yaa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«\"I 'yiɔ! Nɔnbɛ \"nɛn, ya'a tian 'kɔnnɛn -tɔlɛ dɩɛ, 'e 'pɔn \"sia, -e 'e 'nɛn 'klɔnmɔn -ya, waa 'tɔ \"paa Emanuɛl.» Emanuɛl -ci nɛn 'nan, Bali a -kaa 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zɩ Zozɛfʋ fuʋ bɛ, 'wɩ nɛn Bali -le 'pasiazan -a 'vɩ bɛ yaa drɛ, e -kʋ Mari -a 'yee \"kɔnnɛn, ɛn yaa 'pa. ");
INSERT INTO yreNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","'Pian wa'a 'o cin -tɔlɛ lɩ 'lee 'kɔnnɛn -a \"fo 'lɔɔ ɛn Mari Zozi 'ya dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","O Zozi 'ya Bɛtelɛm 'fla Zude 'lɛglɔn 'ji, te Erodi 'bɛ cɩ Zuif 'nɔn -le mingɔnnɛn -a. Zɩ waa -ya bɛ, ɛn 'wɩ 'tɔnɔn nɛn o mlɛn crɛnnun -kɔnnɛn \"paala bɛ, o 'si yidɛ wluan \"nan 'zia, ɛn o -ta Zeruzalɛm. Zɩ o 'bɔla Zeruzalɛm bɛ, ");
INSERT INTO yreNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ɛn waa laabʋ minnun lɔ 'nan: «Zuif 'nɔn 'le mingɔnnɛn nɛn, o \"sia -a -yanan 'gʋɛ, e ya nyin zia? Kʋ -yee mlɛn crɛn 'yɩ yidɛ wluan \"nan zia, ɛn kʋ -ta -a bɔlɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Zɩ mingɔnnɛn Erodi 'wɩ zɩɛ -a 'man bɛ, -a ci srɛ. Ɛn Zeruzalɛm 'nɔn pɛɛnɔn \"le 'ci srɛ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tɔɔn e Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn laabʋ, ɛn yaa laabʋ -wlɔ 'nan: «Nyin zia nɛn, o min 'sizan 'wɩ 'ji Crizi -yaa?» ");
INSERT INTO yreNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","O -yrɛ 'nan: «Waa -yaa Bɛtelɛm, Zude 'lɛglɔn 'ji. Kɔɔ 'wɩ nɛn Bali 'lewei vɩzan -a crɛn -tɛ 'e 'cɛn bɛ -nyrɛn 'gʋ: ");
INSERT INTO yreNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Bɛtelɛm 'nɔn, 'ka fla a Zude 'lɛglɔn 'ji 'fla \"wɛnnɛn 'a, 'pian e ya 'fla nɛn -a 'tɔ -taa vɩlɛ bɛ -a. Kɔɔ 'ka 'va nɛn o -taa Minsan -yalɛ, -yɛɛ si -kɔɔnman 'mɛn minnun Izraɛl 'nɔn lɛ.› » ");
INSERT INTO yreNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","\"Bɛ -sru ɛn Erodi 'wɩ 'tɔnɔn zɩɛ o laabʋ 'e yɔɔdɩ, ɛn yaa laabʋ -wlɔ 'nan: «Tʋ \"kɔ \"man 'sɛzɛ nɛn, ka mlɛn crɛn zɩɛ -a 'yɩ?» Ɛn waa 'vɩ -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","-A -nan nɛn e 'o 'pa 'sia Bɛtelɛm, yaa 'vɩ -wlɛ 'nan: «-Te ka 'bɔla 'nan nun bɛ, 'ka 'nɛn zɩɛ -a -wɛɛ tɩglɩ! Ɛn -te kaa 'yɩ bɛ, 'ka 'ta \"mɛn \"vɩ, -e \"an -kʋʋ -a bɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Zɩ e cɛɛn 'wɩ zɩɛ -a vɩdɩ man -wlɛ \"bɛ, ɛn o -kʋdɩ \"sia. \"Wɛɛ -kɔn -kʋnan -sia bɛ, ɛn o mlɛn crɛn -tʋwli \"nɛn, waa 'yɩ yidɛ wluan \"nan 'zia bɛ -a 'yɩ \"nyian. E -trɔa o 'lɛ, ɛn e -kʋ -tɔlɛ 'kɔn nɛn 'nɛn 'bɔ cɩ -ji bɛ -a ta lou. ");
INSERT INTO yreNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Zɩ o mlɛn crɛn zɩɛ -a 'yɩ bɛ, ɛn o 'ci nran 'sia 'kpa tɩglɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","O wla 'kɔn zɩɛ -a -ji, ɛn o 'nɛn 'lee 'e \"bʋ Mari 'yɩ. O \"po sɔɔn, ɛn o 'nɛn zɩɛ -a 'bɔ. O 'wee -trɔ flu, ɛn o fɛnun -nɔn -yrɛ. -Siganun 'lee -laziglɔnun 'lee fɛnun nɛn waa laabo mire bɛ, -a 'bɔ nɛn waa -nɔn -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","\"Bɛ -sru \"bɛ, ɛn Bali 'wɩ tin 'ba 'wɩ 'tɔnɔn zɩɛ -wlɛ \"nyrinvla. Yaa 'vɩ -wlɛ 'nan: «Te 'ka li \"nyian 'ka da Erodi -va dɩ.» Zɩ o fuʋ bɛ, o -si pee 'sia, ɛn o -kʋ 'wee 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Zɩ 'wɩ 'tɔnɔn \"o -kʋʋ bɛ, ɛn Bali -le 'pasiazan -ta Zozɛfʋ -va nyrinvla. E -yrɛ 'nan: «Erodi a \"va 'nan 'e 'nɛn 'gʋɛ -a -tɛa. -Yee \"wɛan 'i 'wluan, 'i 'nɛn 'lee 'e \"bʋ 'sia -e 'ka 'kʋ tada min tiidii \"trɛda Ezipti 'lɛglɔn 'ji. 'Ka 'fʋ -nan nun -trilii, -te mɛin laabʋ 'vaa -e 'ka 'ta.» ");
INSERT INTO yreNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ɛn Zozɛfʋ wluan, e 'nɛn 'lee e \"bʋ 'sia, ɛn o Ezipti 'lɛglɔn 'ji si 'sia 'pei -man. ");
INSERT INTO yreNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Zɩ o 'bɔla 'nan nun bɛ, o -fʋ -nan nun -trilii, ɛn Erodi -ka. 'Wɩ nɛn Minsan -a 'vɩ 'e 'cɛn 'e 'lewei vɩzan lɛ bɛ, zɩ e 'lɛ sɔɔ zɩɛ. Kɔɔ yaa 'vɩ 'nan: «Ezipti 'lɛglɔn 'ji nɛn 'an 'pɩ cɩ, ɛn maan laabʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Zɩ Erodi -a 'yɩ 'nan, 'wɩ 'tɔnɔn 'e see paa bɛ, 'bli 'fɔ \"ji -wlidɩ. Ɛn e minnun 'pa 'sia 'nan 'o 'kʋ Bɛtelɛm 'lee 'e \"srɔn 'flanun pɛɛnɔn da, -e nannannun pɛɛnɔn nɛn o lɛ 'bɔ \"fli 'lee o nɛn o lɛ 'ka tian bɔlɛ \"fli \"dɩɛ, 'o o -tɛɛ. Tʋ nɛn 'wɩ 'tɔnɔn 'a 'vɩ Erodi lɛ bɛ -a da nɛn 'e 'ci nrɔn ɛn e lɛ \"fli 'wɩ 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'Wɩ nɛn Bali 'lewei vɩzan Zeremi -a 'vɩ 'e 'cɛn bɛ, zɩ e 'lɛ sɔɔ zɩɛ. Kɔɔ yaa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«O -paandɩ 'lee wu maan Rama 'fla. Rashɛl 'bɛ 'yee 'nɛnnun -wua. 'Yee 'nɛnnun kaa, e 'ka \"vale 'wee \"sii dɩ, kɔɔ o 'ka \"nyian -nan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Zɩ Erodi -ka bɛ, ɛn Bali -le 'pasiazan 'wɩ tin 'ba \"nyian Zozɛfʋ lɛ nyrinvla Ezipti 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","E 'nan -yrɛ 'nan: «'I 'wluan! 'I 'nɛn 'lee 'e \"bʋ 'sia -e 'ka li waa 'ka da Izraɛl 'lɛglɔn 'ji! Kɔɔ minnun nɛn waa -wɛɛman 'nan 'o 'nɛn 'gʋɛ -a -tɛa \"bɛ, o pɛɛnɔn kaa.» ");
INSERT INTO yreNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Zozɛfʋ wluan, e 'nɛn 'lee 'e \"bʋ 'sia, ɛn o Izraɛl 'lɛglɔn 'ji si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","'Pian zɩ yaa 'man 'nan Akelausi 'bɛ 'tɔ mingɔnnɛn -a Zude 'lɛglɔn da 'e \"tɩ Erodi \"pa 'ji bɛ, tɔɔn Zude 'lɛglɔn 'bɔ 'ji -nyrandɩ \"klan -a -tɛ \"nyian. -A -nan nɛn Bali 'wɩ tin 'ba -yrɛ \"nyrinvla, ɛn e Galile 'lɛglɔn 'ji si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Zɩ o 'bɔla 'nan nun bɛ, ɛn o -kʋ -nyɛnlɛa 'fla nɛn waa laabo Nazarɛtɩ bɛ -a da. 'Wɩ nɛn Bali 'lewei vɩnɔn -a 'vɩ 'e 'cɛn bɛ, zɩ e 'lɛ sɔɔ zɩɛ. Kɔɔ waa 'vɩ 'nan: «Waa laabo Nazarɛtɩ min.» ");
INSERT INTO yreNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tʋ zɩɛ -a man nɛn min -batize drɛzan Zan 'bɔla Zude \"bui \"da ɛn yaa vɩdɩ 'sia minnun lɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«'Ka 'si 'wɩ 'wlidɩ \"drɛdɩ man -e 'ka 'fli -nɔn Bali lɛ! Bali -le mingɔnnɛn -blɩdɩ 'bɔ -kogo.» ");
INSERT INTO yreNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zan -le 'wɩ nɛn Bali 'lewei vɩzan Ezai -a 'vɩ 'li. Yaa 'vɩ 'nan: «Min -tʋ wei 'bɛ \"we \"bui \"da. Min zɩɛ yaa ve 'nan: ‹'Ka Minsan -le -si ta drɛ! 'Ka -yee -sinun ta -sɛn 'e cin va!› » ");
INSERT INTO yreNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","-Wi nɛn waa laabo Shamo bɛ, -a \"cɛsɔ nɛn Zan da, ɛn -wi 'kɔlɛ nɛn 'e 'tɔdɩ \"da -a -tiɛn. Srɔ 'lee -srɔ 'nyrɔn nɛn yaa -ble fɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Min \"kaga \"kʋ \"va. O -mienun \"sia Zeruzalɛm, ɛn o -mienun \"sia Zude 'lɛglɔn 'ji, ɛn o -mienun \"sia 'yi nɛn waa laabo Zudan bɛ -a \"srɔn 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","O pɛɛnɔn 'ta ɛn o 'wee 'wɩ 'wlidɩnun 'vɩ Bali lɛ 'wein minnun pɛɛnɔn yiɛ man, te Zan o -batize dra Zudan -va. ");
INSERT INTO yreNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","'Pian zɩ Zan -a 'yɩ 'nan Farizɛn 'nɔn 'lee Saduze 'nɔn a -tanan 'e 'va \"kaga -e 'e o -batize drɛ bɛ, ɛn yaa 'vɩ -wlɛ 'nan: «Min -wlidɩnun! -Tɩɛ 'vɩ 'cɛɛ 'nan 'ka 'si Bali -le nyran -blɩdɩ nɛn e \"ta -daa \"bɛ -a wlu? ");
INSERT INTO yreNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","'Ka -kɔɔn 'ka drɛ wɩ -a 'nan, ka 'si 'wɩ 'wlidɩ \"drɛdɩ man. ");
INSERT INTO yreNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","'Pian te 'ka vɩ 'e \"tun 'nan, ka 'si 'wɩ 'ji Abraam a 'ka \"tra -a -le \"wɛan dɩ! Maan ve 'cɛɛ 'nan, -kɔlɛnun nɛn 'lagʋɛ, Bali -kɔlaman o drɛdɩ -a Abraam kludanɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","'Ka \"trɔɛn \"tɔ -kɔnnɛn 'gʋɛ -yrɛ: 'Bɛ nɛn 'gʋɛ yibanun 'cɛndɩ -le \"wɛan bɛ, -saanɛn lɛ a 'e \"trandɩ 'va. Yiba \"nɛn e baa, te -a 'blʋ 'ka \"yi \"dɩɛ, waa \"cɛan, -e 'o tuʋ 'tɛ 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","\"An 'ka -batize drɛ 'yi 'a, -a -kɔɔndɩ -a 'nan, ka 'si 'wɩ 'wlidɩ \"drɛdɩ man. 'Pian min -tʋ \"ta -daa 'e 'fɔla \"da, ɛn -a 'plɛblɛ \"mlian 'an da. An 'ka -yee -manwua \"tun \"da baa \"fluzan -a dɩ. Min zɩɛ -yɛɛ 'ka -batize dra Bali lei 'lee 'tɛ 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","-Yee -klu \"a 'e 'lɔ -e 'e fɛ 'lee 'e -flu 'cɛn 'e cin man. Yaa 'wlɛ -sɛan 'trɛbɔ -ji. 'Pian yaa -flu 'tɛ 'ble 'tɛ nɛn ya'a 'driman 'mlɔnmlɔn dɩɛ -a va.» ");
INSERT INTO yreNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","\"Bɛ -sru Zozi 'si Galile 'lɛglɔn 'ji, ɛn e -ta Zan va 'yi nɛn waa laabo Zudan bɛ -a man. E -ta 'nan -e 'yee -batize drɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Zan \"e -yrɛ 'nan: «-Cɛjɛ! 'I 'bɔ nɛn yiɛ 'an -batize dra bɛ, yiɛ ve 'pian 'mɛn 'nan, 'mɛin -batize drɛ?» ");
INSERT INTO yreNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ɛn Zozi \"e -yrɛ 'nan: «'I 'wɩ \"man -e 'i drɛ, kɔɔ e ya 'wɩ \"yi \"a -e 'wɩ nɛn e cɩ Bali ci 'sɔa bɛ 'kʋ drɛ.» Ɛn Zan 'ka 'wɩ 'pee vɩlɛ \"nyian dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Zɩ Zan Zozi -batize drɛ bɛ, Zozi \"ɛ 'si 'yia, tɔɔn labli 'lɛ 'sʋ, ɛn e Bali lei 'yɩ -sɔɔnlanan 'e da \"le -plablo -le 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɛn wei -tʋ wɩɩ laji. E 'nan: «Min 'labɛ, e ya 'an 'pɩ nɛn maan ye \"yi ɛn -yee 'wɩ 'an 'ci \"nranman bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","\"Bɛ -sru, ɛn Bali lei -kʋ Zozi 'a \"bui \"da, -e Satan 'e man -tan -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Zɩ e fɛ 'sɔn yi -fuba sinjɛn bodrun funnin bɛ, ɛn dra -a -tɛdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","-A -nan nɛn Satan nɛn min man -tanzan -a bɛ e pli \"man, ɛn e -yrɛ 'nan: «-Te i ya Bali -pɩ -a bɛ, 'i 'wɩ 'tʋ vɩ -e -kɔlɛnun 'labɛ 'o lila -blɩfɛ -a!» ");
INSERT INTO yreNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ɛn Zozi \"e -yrɛ 'nan: «E ya 'e 'crɛn -tɛdɩ 'nan: ‹-Blɩfɛ 'saza 'man \"cɛɛ min \"belia dɩ. 'Pian weinun pɛɛnɔn nɛn e \"sia Bali 'le bɛ, -a da 'ta wʋdɩ man nɛn min \"belia.› » ");
INSERT INTO yreNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","\"Bɛ -sru Satan -kʋ Zozi 'a Zeruzalɛm, ɛn e -kʋ -a -tɔlɛ Bali -pan 'kɔn 'win -ji lou. ");
INSERT INTO yreNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","-A -nan nɛn e 'nan Zozi lɛ 'nan: «-Te i ya Bali -pɩ -a bɛ, 'i 'sʋ -e 'i -sɔɔnla, kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan: ‹Bali -a ve 'yee 'pasianɔn nɛn laji bɛ -wlɛ 'nan, 'wei 'kun 'o 'lɔ lou, \"tɔgɔ 'i 'cɛin 'e 'lɛ wʋ -kɔlɛ -mie ji -le \"wɛan.› » ");
INSERT INTO yreNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Zozi \"e -yrɛ 'nan: «-Cɛjɛ, ma'an dra dɩ. Kɔɔ e ya \"nyian 'e 'crɛn -tɛdɩ 'nan: ‹Te blamin 'e Bali nɛn Minsan -a bɛ -a man -tan dɩ!› » ");
INSERT INTO yreNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","\"Bɛ -sru, ɛn Satan -kʋ Zozi 'a \"nyian pɔn loulou \"tʋ -win -ji. -A -nan nɛn e mingɔnnɛn trɛnun pɛɛnɔn nɛn 'trɛda bɛ -a kɔɔn -yrɛ 'o 'vale 'wee fɛnyian -a. ");
INSERT INTO yreNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ɛn \"e -yrɛ 'nan: «-Te i \"po sɔɔnla 'an 'wlu -e 'yian bɔ bɛ, mingɔnnɛn trɛnun pɛɛnɔn 'labɛ, maan -nɔan 'yiɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tɔɔn Zozi \"e -yrɛ 'nan: «Satan, 'i -pli 'i -sru! E ya 'e 'crɛn -tɛdɩ 'nan: ‹Bali nɛn Minsan -a bɛ, -a 'bɔ nɛn min 'e bɔ, ɛn -a -tʋwli \"cɛ \"nɛn min 'e 'su!› » ");
INSERT INTO yreNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","-A -nan nɛn Satan 'si -a \"srɔn, tɔɔn Bali -le 'pasianɔn nɛn laji bɛ, o pli \"man, ɛn waa 'su. ");
INSERT INTO yreNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zɩ Zozi 'a 'man 'nan o Zan -fɔ -pʋ 'kuin bɛ, ɛn e 'li 'e da Galile. ");
INSERT INTO yreNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ya'a 'fʋlɛ Nazarɛtɩ dɩ, 'pian e -kʋ -nyɛnlɛa Kapanamo. 'Fla zɩɛ e ya Galile 'yi -dan \"srɔn. E ya Zabulɔn 'lee Nefʋtali 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","'Wɩ nɛn Bali 'lewei vɩzan Ezai -a 'vɩ 'e 'cɛn bɛ, zɩ e 'lɛ sɔɔ zɩɛ. Kɔɔ yaa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Zabulɔn 'lee Nefʋtali 'lɛglɔn 'ji 'nɔn! Ka ya 'trɛ nɛn e ya Galile 'yi -dan \"srɔn \"bɛ -a da 'nɔn 'a. Ɛn ka ya 'lɛglɔn nɛn e ya Zudan 'yi -sru \"bɛ -a -ji 'nɔn 'a. Galile nɛn minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ o -nyɛanla 'nan bɛ -a -nan 'nɔn nɛn kaa! 'Ka \"trɔɛn \"tɔ 'wɩ 'gʋɛ -yrɛ! ");
INSERT INTO yreNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Minnun nɛn 'o -nyrandɩ klun tiidii 'va bɛ, o 'tɛ 'san -dan 'yɩ. Ɛn minnun nɛn o cɩ -ka -lɔ bɛ, 'tɛ 'san -sɛn o da.» ");
INSERT INTO yreNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tʋ zɩɛ -a man nɛn Zozi Bali -le 'wɩ vɩdɩ 'sia. Yaa 'vɩ 'nan: «'Ka 'si 'wɩ 'wlidɩ \"drɛdɩ man -e 'ka 'fli -nɔn Bali lɛ! Bali -le mingɔnnɛn -blɩdɩ 'bɔ 'kogo.» ");
INSERT INTO yreNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yi -tʋ da nɛn Zozi a ciɩnan Galile 'yi 'plo da, ɛn e min \"fli 'yɩ, te o ya 'wee pɔ -tɛ \"se 'wɛɛnnan 'yi 'va. Pɔ -tɛnɔn nɛn waa. Simɔn nɛn waa laabo Piɛri bɛ 'lee 'e \"bʋɩ Andre nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ɛn e 'nan -wlɛ 'nan: «'Ka -sɔɔnla 'an -sru! An -taa 'ka drɛlɛ minnun nɛn o min laabo 'an -sru \"bɛ waa.» ");
INSERT INTO yreNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","'Nun tɔɔn o 'wee \"senun 'tʋɩ, ɛn o sɔɔnla Zozi -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","\"Yɛɛ -kʋ \"nyian 'e 'lɛ bɛ, te e min \"fli \"pee ye. Zebede -pɩ Zaji 'lee 'e \"bʋɩ Zan nɛn, o ya 'o 'fɔdɩ -klʋ -ji 'o 'vale 'o \"tɩ Zebede -a, te o 'wee \"senun -peeman. Zozi o laabʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","'Nun tɔɔn min \"fli zɩɛ o 'si 'wee -klʋ -ji, o 'si 'o \"tɩ -sru, ɛn o sɔɔnla Zozi -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zozi ciɩ Galile 'lɛglɔn pɛɛnɔn 'ji. E 'wɩ paa minnun ji Zuif 'nɔn 'le cin yɩ 'kɔnnun -ji. E Bali 'le 'wɩ 'nɔnnɔn 'vɩ -yee mingɔnnɛn -blɩdɩ da. Minnun pɛɛnɔn nɛn -cɛ cɩ o man 'lee minnun pɛɛnɔn nɛn o man \"yaaman bɛ e 'o beli. ");
INSERT INTO yreNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","-A -nan nɛn waa 'tɔ 'wɩdɩ 'man Siri 'lɛglɔn pɛɛnɔn 'ji, ɛn minnun -ta o pɛɛnɔn nɛn o cɩ see -blɩnan -cɛ 'tɔ 'tʋdʋ pɛɛnɔn 'lɔ bɛ waa -yrɛ. Min -mienun man 'bɛ \"yaaman, ɛn -yʋ -wlidɩ 'bɛ cɩ min -mienun -sru, ɛn -tʋwli \"cɛ 'bɛ cɩ min -mienun man, ɛn min -mienun a 'o -srandɩ \"tra, o pɛɛnɔn zɩɛ o -ta waa -yrɛ, ɛn e o beli. ");
INSERT INTO yreNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","-A -nan nɛn min \"kaga 'kpa -sɔɔnla -a -sru. O -mienun \"sia Galile 'lɛglɔn 'bɔ 'ji, ɛn o -mienun \"sia 'lɛglɔn 'tʋ nɛn waa laabo 'Fla 'fu bɛ -a -ji, ɛn o -mienun \"sia Zeruzalɛm, ɛn o -mienun \"sia Zude, ɛn o -mienun \"sia 'yi nɛn waa laabo Zudan bɛ -a -sru 'flanun da. ");
INSERT INTO yreNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Zɩ Zozi min \"kaga zɩɛ o 'yɩ bɛ, -a -nan nɛn e pɔn tri, e -nyran, ɛn -a -srunɔn pli \"man. ");
INSERT INTO yreNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ɛn e 'wɩ \"paadɩ 'sia o ji. Yaa 'vɩ -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Minnun nɛn waa -tɔa 'o 'fli 'lɔ 'nan, -te Bali 'ka 'palɛ 'o 'va dɩɛ, wa'a 'kɔlaman fɛ -tʋ drɛdɩ -a dɩɛ, Bali -le -fɛa a o man, kɔɔ -wɛɛ cɩ Bali -le mingɔnnɛn trɛdanɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Minnun nɛn o cɩ -trunnan 'o 'man wɩnun lɔ bɛ, Bali -le -fɛa a o man, kɔɔ Bali o \"siiman. ");
INSERT INTO yreNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Minnun nɛn o cɩ min -trɔɔ -a bɛ, Bali -le -fɛa a o man, kɔɔ 'trɛ nɛn Bali -a 'vɩ bɛ -wɛɛ cɩ -a da 'nɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Minnun nɛn Bali -le 'wɩ tɩglɩ drɛdɩ dra o -tɛa \"bɛ, Bali -le -fɛa a o man, kɔɔ Bali o ci -taa \"tra 'wɩ zɩɛ -a drɛdɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Minnun nɛn min nyrinda -sɛan \"o da bɛ, Bali -le -fɛa a o man, kɔɔ Bali o nyrinda \"sia. ");
INSERT INTO yreNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Minnun nɛn o 'wɩ dra 'o 'ci 'fɩdaa 'a bɛ, Bali -le -fɛa a o man, kɔɔ o -taa Bali yɩlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Minnun nɛn waa -wɛɛman 'nan minnun yei 'e 'fʋ -trɔɔ bɛ, Bali -le -fɛa a o man, kɔɔ Bali -taa \"o laabʋlɛ 'yee 'nɛnnun. ");
INSERT INTO yreNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Minnun nɛn o cɩ 'tɛ 'panan o da Bali ci 'sɔ wɩ drɛdɩ -le \"wɛan bɛ, Bali -le -fɛa a o man, kɔɔ -wɛɛ cɩ Bali -le mingɔnnɛn trɛdanɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","-Te o 'ka \"srɔnman 'mɛn \"wɛan oo, -te o 'tɛ \"paa 'ka da 'mɛn \"wɛan oo, -te o 'wɩ 'wlidɩ 'tɔ 'tʋdʋ pɛɛnɔn ve 'ka man 'wlu 'a 'mɛn \"wɛan oo, Bali -le -fɛa a 'ka man! ");
INSERT INTO yreNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","'Ka 'ci 'e \"nran 'e 'ciɩla \"da, kɔɔ 'ka 'kopa -kɔan -dan laji. Bali 'lewei vɩnɔn nɛn 'ka 'lɔ 'e 'flin bɛ, 'wɩ 'tʋwli zɩɛ minnun -wee drɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Ka ya 'trɛda \"le -wɛ -le 'wɩ 'zʋ. -Te -wɛ 'nɔnnɔn 'si \"man \"bɛ, -mɛ \"a nɛn waa dra 'nɔnnɔn? E 'ka fɛ -tʋ drɛvɛ -a \"nyian \"fo \"dɩ. Waa wɛɛnman, -e minnun 'o \"taanla \"da.» ");
INSERT INTO yreNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Ka ya 'trɛda \"le 'tɛ 'san -le 'wɩ 'zʋ. 'Fla nɛn pɔn da lou \"bɛ, e 'ka 'e yɔɔdɩ dɩ, -a -tʋwli \"nɛn \"nyian 'cee vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ɛn wa'a -kannɛn -fɔa \"nɛn -e 'o yɔɔ -pɔ wlu dɩ. 'Pian waa -tɔala fɛnan 'wein da, -e 'e min pɛɛnɔn nɛn 'kuin bɛ o va drɛ 'wein. ");
INSERT INTO yreNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","'Wɩ 'tʋwli zɩɛ -a 'bɔ nɛn 'cee vɛ -a, minnun pɛɛnɔn 'o 'ka 'san yɩ! Ɛn 'wɩ \"yi \"nɛn kaa dra bɛ 'o yɩ, -e 'o 'ka \"tɩ \"nɛn laji bɛ -a 'tɔ drɛ -dan.» ");
INSERT INTO yreNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Te -a -cin 'e 'kɔn 'ka 'ji 'nan, an -ta Moizi -le -pei klu -sɛnlɛa ji dɩ! Te -a -cin 'e 'kɔn 'ka 'ji \"nyian 'nan, an -ta Bali 'lewei vɩnɔn wei klu -sɛnlɛa ji dɩ! Ma'an 'talɛ 'wɩnun zɩɛ -a klu -sɛnlɛa ji dɩ, an -ta 'nan -e 'an o 'lɛ sɔɔ 'pian. ");
INSERT INTO yreNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -te labli 'lee 'trɛ 'ka tian 'nyanlɛ dɩɛ, te -pei -le 'wɩ \"wɛnnɛn 'tʋwli \"cɛ 'ka 'sia \"da \"dɩ -trilii, -e 'wɩ pɛɛnɔn nɛn -pei -a 'vɩ bɛ 'e 'lɛ sɔɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","-Yee \"wɛan min nɛn e Bali -le -pei \"wɛnnɛn 'tʋwli srɛ bɛ, ɛn e 'wɩ paa minnun ji 'nan, 'o drɛ \"le 'yee 'wɩ 'zʋ bɛ, Bali -le mingɔnnɛn trɛda bɛ, min zɩɛ -yɛɛ -kɔan min \"wɛnnɛn 'a. 'Pian min nɛn e 'ta 'wʋla Bali -le -pei da, ɛn yaa \"paaman minnun ji 'nan 'o 'ta wʋla \"da \"bɛ, Bali -le mingɔnnɛn trɛda bɛ, min zɩɛ -yɛɛ -kɔan min -dan a. ");
INSERT INTO yreNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","-Yee \"wɛan maan ve 'cɛɛ 'nan, -te 'ka drɛ wɩ \"yinun 'ka 'mlinlɛ 'fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn 'le vɛ da dɩɛ, ka'a -ko Bali -le mingɔnnɛn 'trɛda \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Kaa 'man 'nan, waa 'vɩ -kaa tranun lɛ 'nan: ‹Te blamin 'e drɛ min -tɛzan -a dɩ! Min nɛn e min -tɛ bɛ, o -ko -a tin 'banɔn 'cɛin -da.› ");
INSERT INTO yreNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","'Pian 'an 'bɔ, \"an \"ve 'cɛɛ 'nan, min nɛn 'bli 'fɔ \"ji 'e \"bʋɩ man bɛ, o -ko -a tin 'banɔn 'cɛin -da. Ɛn min nɛn yaa 'vɩ 'e \"bʋɩ lɛ -blʋzan bɛ, o -ko -a tin 'banɔn -dandan cɛin -da. Ɛn min nɛn yaa 'vɩ 'e \"bʋɩ lɛ klinzan bɛ, e ya \"le 'o -fɔ 'tɛ nɛn -a va yra yɩdɩ 'leda \"ka \"dɩɛ, -a va. ");
INSERT INTO yreNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","-Te i -kʋ Bali -panvɛ -a Bali -pannan, ɛn -a -cin -trɔa 'i 'ji 'nan, 'wɩ a 'ka 'vale 'i \"bʋɩ -tʋ -a 'ka yei \"bɛ, ");
INSERT INTO yreNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'i Bali -panvɛ zɩɛ -a 'tʋɩla Bali -pannan bɛ, -e 'i 'kʋ 'i \"bʋɩ zɩɛ -a va. 'I 'ka yei \"sɛn 'e cin va 'vaa -e 'i 'ta 'yie 'sraga bʋ Bali lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","-Te min -tʋ 'i 'sanman drɛ, ɛn ka \"ta -ko -a tin 'balɛ bɛ, 'i 'fɔ 'e 'flin 'i 'ka yei \"sɛn 'e cin va, \"tɔgɔ 'yei 'nɔn tin 'bazan lɛ, -e tin 'bazan 'e 'i 'fɔ -pʋ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Maan ve 'yiɛ 'wɩ tɩglɩ 'a 'nan, \"yiɛ vɩnan i bɔla -pʋ 'kɔn zɩɛ -a -ji bɛ, te i cɛɛn -yee \"lala pɛɛnɔn bɔladɩ man.» ");
INSERT INTO yreNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Kaa 'man 'nan, Bali \"e 'nan: ‹Te blamin 'e min nan -wɛɛ \"dɩ, ɛn te 'e min -sran -wɛɛ \"dɩ!› ");
INSERT INTO yreNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","'Pian 'an 'bɔ, \"an \"ve 'cɛɛ 'nan, min nɛn e min nan -nanjɛɛn, ɛn -a 'bli bʋ \"man \"bɛ, te yaa wɛɛ 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","-Yee \"wɛan maan ve 'cɛɛ 'nan, -te 'i 'pɛ \"yi \"da yiɛ 'bɛ -maan i 'wɩ 'wlidɩ \"dra bɛ, 'i 'si \"ji -e 'i tuʋ -kɔɔbli! Kɔɔ -te 'i 'man 'mɛn -tʋwli \"cɛ srɛ bɛ, -a \"yi \"mlian 'i 'bɔ po -fɔdɩ 'tɛ nɛn -a va yra yɩdɩ 'leda \"ka \"dɩɛ, -a va da. ");
INSERT INTO yreNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ɛn -te 'i 'pɛ \"yi 'bɛ -maan i 'wɩ 'wlidɩ \"dra bɛ, 'i 'cɛn -e 'i tuʋ -kɔɔbli! Kɔɔ -te 'i 'man 'mɛn -tʋwli \"cɛ srɛ bɛ, -a \"yi \"mlian 'i 'bɔ po -fɔdɩ 'tɛ nɛn -a va yra yɩdɩ 'leda \"ka \"dɩɛ, -a va da.» ");
INSERT INTO yreNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Bali -a 'vɩ \"nyian 'nan: ‹-Te min \"ta 'e nan bɔala bɛ, 'fluba nɛn yaa -kɔɔnman 'nan yaa 'bɔla bɛ, 'e 'nɔn -yrɛ 'vaa -e 'e bɔla.› ");
INSERT INTO yreNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","'Pian 'an 'bɔ, \"an \"ve 'cɛɛ 'nan, min nɛn e nan 'bɔla, te -kɔnnɛn -wɛɛdɩ man \"cɛɛ dɩɛ, te min zɩɛ -yɛɛ vɩnan 'e -kɔnnɛn -wɛɛ -kɔnnɛn pee 'padɩ -a. Ɛn min nɛn e lɩ zɩɛ -a 'pa bɛ, te Bali 'lɛ zia bɛ e min nan wɛɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Kaa 'man 'nan, waa 'vɩ -kaa tranun lɛ 'nan: ‹Te blamin 'e 'wlu man -pɛ wluan Bali 'tɔ da dɩ! 'Pian 'wɩ oo 'wɩ nɛn 'e 'pɛ wluan 'ji Minsan Bali 'tɔ bɛ, yaa 'lɛ sɔɔman -kpɔ.› ");
INSERT INTO yreNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","'Pian 'an 'bɔ, \"an \"ve 'cɛɛ 'nan, te 'ka fɛ -tʋ -ji -pɛ wluan \"fo \"dɩ! Ɛn te 'ka labli drɛ 'cee 'wɩ nan yɩzan -a \"fo \"dɩ, kɔɔ e ya Bali -le mingɔnnɛn pɛin -a. ");
INSERT INTO yreNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Te 'ka 'trɛ drɛ 'cee 'wɩ nan yɩzan -a \"fo \"dɩ, kɔɔ e ya Bali cɛin -trɔanan \"a. Te 'ka Zeruzalɛm 'trɛ drɛ 'cee 'wɩ nan yɩzan -a \"fo \"dɩ, kɔɔ e ya Bali nɛn mingɔnnɛn -dan a bɛ -a 'fla -a. ");
INSERT INTO yreNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ɛn te 'ka vɩnan 'wɩ 'e 'bɔ 'ka man 'wɩ 'tʋ -ji, -e 'ka 'wulo 'e 'kʋ -ji dɩ, kɔɔ ka'a 'kɔlaman 'ka 'wulo \"jɛ pou -tʋwli \"cɛ liladɩ -a 'fuvu dɩ, ɛn ka'a 'kɔlaman -a liladɩ -a tiidii \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","-Te e ya -inyan -a bɛ, 'ka vɩ -inyan! -Te e ya -cɛjɛ -a bɛ, 'ka vɩ -cɛjɛ! 'Wɩ pɛɛnɔn nɛn cɛɛ ve -a -sru \"bɛ, 'e \"sia Satan nɛn e 'wɩ 'wlidɩ \"paa 'nyranman -a bɛ -a va.» ");
INSERT INTO yreNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Kaa 'man 'nan waa 'vɩ 'nan: ‹-Te min 'i yiɛ -wi bɛ, 'i -yee vɛ -wi! Ɛn -te min 'i 'shɛ 'sʋ bɛ, 'i -yee vɛ 'sʋ!› ");
INSERT INTO yreNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","'Pian 'an 'bɔ, \"an \"ve 'cɛɛ 'nan, te 'ka 'wɩ 'lɛji -tɔ 'wɩ 'wlidɩ \"drɛzan lɛ dɩ. -Te min 'pa 'fɔ 'i 'pɛ \"yi \"da 'klanbo \"da bɛ, 'i 'pɛ bʋ davɛ -kɔɔn \"nyian -yrɛ! ");
INSERT INTO yreNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","-Te min a \"va 'nan 'e 'ko 'yia tin 'bazan cɛin -da, 'yie -tralɛ 'sidɩ -le \"wɛan bɛ, 'i 'ta sɔ nɛn -a 'wɩ cɩ 'i man bɛ, 'i 'nɔn -yrɛ \"nyian! ");
INSERT INTO yreNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","-Te min -tʋ -trɔ -tɔ 'i 'win -ji -sa -a, 'nan 'i 'kʋ -a kilo -tʋ da bɛ, 'i 'pa \"da \"nyian -tʋ! ");
INSERT INTO yreNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","-Te min fɛ laabʋ 'i 'lɔ bɛ, 'i 'nɔn -yrɛ. Ɛn te 'i koda -tɔ min nɛn e -ta fɛ 'fɛlɛ 'i 'lɔ bɛ -yrɛ \"dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Kaa 'man 'nan waa 'vɩ 'nan: ‹Blamin 'e bɔɛzan -tʋ yɩ \"yi, 'pian 'e 'nan 'e 'nanmanzan man!› ");
INSERT INTO yreNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","'Pian 'an 'bɔ, \"an \"ve 'cɛɛ 'nan, 'ka 'ka 'nanmannɔn yɩ \"yi, ɛn \"nyian bɛ 'ka Bali trʋ 'ba minnun nɛn o 'tɛ \"paa 'ka da bɛ, -wee 'wɩ man! ");
INSERT INTO yreNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","'Wɩnun zɩɛ -a 'bɔ nɛn 'ka drɛ, -e 'ka 'kɔn 'ka \"tɩ nɛn laji bɛ -yee 'nɛnnun tɩglɩ 'a. Kɔɔ e yidɛ wuanla 'wɩ 'wlidɩ \"drɛnɔn 'lee 'wɩ \"yi \"drɛnɔn da, ɛn e laa -fɛan min -wlidɩnun 'lee min tɩglɩnun da. ");
INSERT INTO yreNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","-Te minnun nɛn o 'ka ye \"yi \"bɛ, o 'saza nɛn ka o ye \"yi \"bɛ, te -a -cin 'e 'kɔn 'ka 'ji 'nan Bali -a man \"yi \"dra 'cɛɛ dɩ! 'Sukɔlɛ 'sinɔn nɛn 'wɩ 'wlidɩ \"drɛnɔn 'a bɛ, 'wɩ 'bɔ zɩɛ -nyrɛn \"o \"dra. ");
INSERT INTO yreNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ɛn -te 'ka \"bʋɩnun 'saza nɛn ka 'o 'tɔ bo bɛ, ka'a 'wɩ -dan drɛlɛ \"fo \"dɩ. Kɔɔ minnun nɛn wa'a Bali tɔa dɩɛ, 'wɩ 'tʋwli zɩɛ -a 'bɔ nɛn \"o \"dra. ");
INSERT INTO yreNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","'Ka 'kɔn tɩglɩ \"le zɩ 'ka \"tɩ Bali nɛn laji bɛ e cɩ tɩglɩ bɛ -yee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Fɛ oo fɛ nɛn ka \"ta -a dra Bali lɛ bɛ, te 'ka -wɛɛ 'nan 'ka dra minnun yiɛ lɛ 'nan -e 'o 'ka 'tɔ \"yi \"vɩ dɩ! Kɔɔ -te 'wɩ zɩɛ -a -cin a 'ka 'ji bɛ 'ka \"tɩ \"nɛn laji bɛ ya'a man \"yi 'dra 'cɛɛ \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","-Yee \"wɛan fɛ oo fɛ nɛn yia -nɔan seezan lɛ bɛ, te 'i 'nan wɩ fuila \"man \"dɩ! 'Wɩ zɩɛ -a 'bɔ nɛn minnun nɛn o 'wɩ dra min yiɛ lɛ bɛ, waa dra cin yɩ 'kuin, ɛn waa dra \"nyian -guada. Waa -nan wɩ ve 'nan -e minnun 'e 'o 'tɔ \"yi \"vɩ -le \"wɛan. Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, o 'o -kopa 'yɩ 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","'Pian 'yie vɛ bɛ, -te \"yiɛ \"lala -nɔn seezan lɛ bɛ, te min pee 'e 'nan yɩ dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","'I drɛ zɩɛ 'dʋ -e -a 'wɩ 'e 'fʋ 'e yɔɔdɩ, -e 'i \"tɩ \"nɛn e fɛ yɔɔdɩ -tɔa \"bɛ, 'yei -ko 'pa.» ");
INSERT INTO yreNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ɛn -te ka ya Bali trʋ 'banan bɛ, te 'ka drɛ \"le minnun nɛn o 'wɩ dra min yiɛ lɛ bɛ, -wee 'wɩ 'zʋ dɩ! O Bali trʋ 'badɩ ye \"yi 'o 'tɔdɩ lou cin yɩ 'kuin 'lee -guada, 'nan -e minnun 'e 'o yɩ -le \"wɛan. Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, o 'wee -kopa 'yɩ 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","'Pian 'yie vɛ bɛ, -te i ya \"va 'nan i Bali trʋ \"baa bɛ, 'i wla 'yie 'kɔn \"bʋ \"ji, 'i 'lɛ wʋ, -e 'i \"tɩ \"nɛn e cɩ fɛ yɔɔdɩ 'bɔ zɩɛ -a -nan bɛ, 'i trʋ 'ba. -Te i ya -a drɛnan zɩɛ, 'i \"tɩ \"nɛn e 'wɩ yɔɔdɩ ye bɛ, yei -ko \"paa. ");
INSERT INTO yreNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","-Te ka ya Bali trʋ 'banan bɛ, te 'ka 'wɩ \"kaga \"vɩ \"le minnun nɛn wa'a Bali tɔa dɩɛ, -wee 'wɩ 'zʋ dɩ. E ya 'o 'ji \"le 'nan 'wee tin \"kaga 'padɩ man nɛn Bali 'e \"trɔɛn -tɔa 'wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Te 'ka drɛ \"le -wee 'wɩ 'zʋ dɩ! Kɔɔ 'ka \"tɩ \"nɛn laji bɛ, \"cɛɛ vɩnan 'ka fɛnun laabʋ -yrɔ \"bɛ, te e 'ka 'man wɩnun 'bɔ -tɔa 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Zɩ kɔ 'ka Bali trʋ 'ba bɛ -nyrɛn 'gʋ, 'ka vɩ 'nan: 'Kʋ \"tɩ Bali nɛn laji bɛ, 'i drɛ -e minnun 'o 'i 'tɔ drɛ -dan. ");
INSERT INTO yreNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","'Yie mingɔnnɛn -blɩdɩ 'e 'ta. Ɛn 'i drɛ -e minnun 'o 'i 'ci 'sɔ wɩ drɛ 'trɛda, \"le zɩ e dra laji bɛ, -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","'I 'kʋe cɛɛgʋ -blɩfɛ nɛn kʋ cɩ \"va \"bɛ, -a -nɔn 'kʋɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","'Wɩnun nɛn kʋa dra 'yiɛ -wlidɩ \"bɛ 'i 'cɛ 'kʋɛ, \"le zɩ minnun 'wɩ dra 'kʋɛ -wlidɩ kʋa \"cɛa -wlɛ \"bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Te 'i 'kʋ 'tʋɩ -e Satan 'e 'kʋ 'man yɩ dɩ. 'Pian 'i 'kʋ 'si -yrɔ. Mingɔnnɛn -blɩdɩ, 'lee 'plɛblɛ, 'lee 'tɔ -dan a 'li 'e 'cɛn 'yie vɛ -a, -trilii. Amɛn! ");
INSERT INTO yreNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","'Wɩ 'wlidɩ \"nɛn minnun -a dra 'cɛɛ bɛ, -te kaa \"cɛa -wlɛ \"bɛ, 'ka \"tɩ \"nɛn laji bɛ, 'wɩnun nɛn kaa drɛ -yrɛ \"wlidɩ \"bɛ, e \"cɛa \"nyian 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","'Pian -te minnun 'wɩ drɛ 'cɛɛ, ɛn ka'a 'cɛlɛ -wlɛ \"dɩɛ, 'ka \"tɩ \"nɛn laji bɛ, 'wɩnun nɛn kaa drɛ -yrɛ \"wlidɩ \"bɛ, ya'a \"nyian \"e cɛa 'cɛɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«-Te ka ya fɛ 'sɔnnan bɛ, te 'ka 'fli ta drɛ -trɔdrɔ \"le minnun nɛn o 'wɩ dra min yiɛ lɛ bɛ, -wee 'wɩ 'zʋ dɩ. 'O 'fli ta dra -trɔdrɔ, -e 'o -kɔɔn \"minnun lɛ 'nan, 'o ya fɛ 'sɔnnan. Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, o 'wee -kopa 'yɩ 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","-Te i ya fɛ 'sɔnnan bɛ, 'i yra \"foe, ɛn 'i -laziglɔ -sɛn 'i da, ");
INSERT INTO yreNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","-e minnun 'o vɩlɛ o -kɔnnɛn \"yɩ 'nan i ya fɛ 'sɔnnan dɩ. 'I \"tɩ \"nɛn e cɩ fɛ yɔɔdɩ 'bɔ zɩɛ -a -nan bɛ, -yɛɛ -nan ye 'i 'lɔ, -e 'yei -ko 'pa.» ");
INSERT INTO yreNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Te 'ka fɛnun tre 'ka yɩfɛ -a 'trɛ 'gʋɛ -a da dɩ! Fadrʋnɛn 'lee mɔnnɛnnun o srɛman, ɛn crinnɔn 'kɔn \"fɔan, -e 'o \"koola. ");
INSERT INTO yreNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","'Pian 'ka fɛnun tre 'ka yɩfɛ -a laji. Fadrʋnɛn 'lee mɔnnɛnnun 'ka 'nan nun -e 'o fɛ srɛ dɩ, ɛn crinnɔn 'ka 'nan nun -e 'o crin wʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Fɛ nɛn yaa -maan 'lɔɔ 'an 'wɩ zɩɛ -a 'vɩ bɛ, -yɛɛ cɩ 'nan, fɛnan nɛn min yɩfɛ cɩ 'e pladɩ bɛ, -a -nan nɛn min -le ci \"nrɔndɩ pɛɛnɔn -kɔan. ");
INSERT INTO yreNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Min yiɛ 'bɛ -maan min fɛnan ye. -Te 'i yiɛ a \"ji 'kpa bɛ, 'tɛ 'san -sɛan 'i da, yia -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","'Pian -te 'i yiɛ 'ka fɛnan ye dɩɛ, 'tɛ 'san -sɛan 'i da, yi'a tɔa dɩ. I ya tʋ pɛɛnɔn man klun va. -Te fɛ -tʋ -si -tɔ 'tɛ 'san -lɔ ɛn i -fʋ klun va bɛ, te i ya klun tiidii -dan 'va! ");
INSERT INTO yreNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Min -tʋwli 'ka 'kɔlaman -e 'e drɛ min \"fli 'suzan 'a dɩ. Kɔɔ -te yaa 'vɩ 'nan 'e dra bɛ, e \"naan -a -tʋ man -e 'e -tʋ yɩ \"yi. Ɛn -te 'bɛ \"cɛɛ dɩɛ, e kɔamlan -a -tʋ man, -e 'e -tʋ drɛ 'e 'pɛla koda. -A -tʋwli \"nɛn \"nyian 'cee vɛ -a, ka'a 'kɔlaman -e 'ka Bali 'lee \"lala yɩ \"yi 'e cin -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«-Yee \"wɛan nɛn maan ve 'cɛɛ 'nan, te 'ka 'fʋ 'ka 'ci \"nrɔnnan 'cee 'trɛda da dɩ! -Yɛɛ cɩ \"le: ‹-Mɛ \"nɛn kʋa -ble? -Mɛ \"nɛn kʋa -mlian? Kʋa dra 'kɔ, -e 'kʋ 'man sɔnun yɩ?› 'Pian -a -cin 'e 'kɔn 'ka 'ji 'nan, 'belidɩ nɛn 'ka 'lɔ bɛ -a \"yi \"mlian -blɩfɛ da, ɛn 'ka 'kɔlɛ nɛn 'ka da bɛ, -a 'kpa \"mlian sɔnun da. ");
INSERT INTO yreNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","'Ka 'ci \"nrɔn \"lomannun da! Wa'a 'saa 'fɔa dɩ, ɛn wa'a 'saa 'tɛa dɩ, ɛn wa'a 'saa 'sɛan 'trɛbɔnun -ji dɩ. 'Pian 'ka \"tɩ \"nɛn laji bɛ e -blɩfɛ -nɔan -wlɛ. -A -cin 'e 'kɔn 'ka 'ji 'nan Bali 'lɛ bɛ 'ka \"yi \"mlian o da! ");
INSERT INTO yreNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","'Cee ci \"nrɔndɩ 'cee 'trɛda da bɛ, ya'a 'kɔlaman -e 'e yi -tʋwli \"cɛ 'pa 'cee 'belidɩ da \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Sɔnun nɛn 'kɔ ka 'wʋ 'ka man bɛ te 'ka 'ci \"nrɔn -a 'wɩ 'a dɩ! Lunun nɛn 'o -fui -tɛa \"lua bɛ, 'ka 'ci \"nrɔn o da! Wa'a 'nyranman paa dɩ, ɛn wa'a 'nanwlɛ 'taan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","'Pian maan ve 'cɛɛ 'nan, Salomɔn nɛn e ya mingɔnnɛn -dan tʋ a 'li bɛ, -yee sɔ -tʋ fɛnyian 'ka 'mlinlɛ lu -fuinun zɩɛ -a -tʋwli \"le fɛnyian da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lu -fui \"nɛn 'bɛ cɩ lua, \"trɛ wɛɛ \"cɛan -e 'wɛɛ 'fɔ 'tɛ 'va bɛ, -te Bali 'bɛ 'man drɛvɛ wɛɛ fɛnyian zɩɛ bɛ, 'lɔɔ kaa \"nun? 'Cee yi -tɛradɩ Bali da a \"wɛnnɔn. ");
INSERT INTO yreNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","-Yee \"wɛan te 'ka 'fʋ 'ka 'ci \"nrɔnnan -a laabʋdɩ -a 'nan: ‹-Mɛ \"nɛn kʋa -ble? -Mɛ \"nɛn kʋa -mlian? Kʋa dra 'kɔ, -e 'kʋ 'man sɔnun yɩ?› ");
INSERT INTO yreNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ci \"nrɔndɩ nun zɩɛ e ya minnun nɛn wa'a Bali tɔa dɩɛ, -wee vɛ -a. 'Ka \"tɩ \"nɛn laji bɛ yaa -tɔa 'nan fɛnun zɩɛ -a 'wɩ a 'ka man. ");
INSERT INTO yreNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","'Ka -wɛɛ 'e tɛdɛ 'nan, Bali 'e mingɔnnɛn -blɩ 'ka da, ɛn 'ka -wɛɛ \"nyian 'nan, 'ka Bali ci 'sɔ wɩ dra. \"Bɛ -sru -e Bali 'e fɛ pɛɛnɔn zɩɛ -a drɛ 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","\"Trɛ \"tʋ 'lee 'e 'ci wɩ, ɛn yi -tʋ 'lee 'yee \"koe \"nyan. -Yee \"wɛan te 'ka 'ci \"nrɔn \"trɛ \"wɩ da dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Te 'ka min 'tɔ 'tɛ dɩ, \"tɔgɔ tʋ nɛn Bali 'trɛdanɔn 'le 'wɩ tin \"baa bɛ, 'e tin -tɛ 'ka da! ");
INSERT INTO yreNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kɔɔ Bali 'cee tin \"baa \"le zɩ ka minnun -le vɛ 'pa bɛ -yee 'wɩ 'zʋ. Zɩ i 'wɩ dra 'i bɔɛzan -tʋ -va bɛ, -a da nɛn Bali \"yie \"dra. ");
INSERT INTO yreNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","-Mɛ \"le \"wɛan nɛn i yiba -flunɛn ye 'i bɔɛzan -tʋ yiɛ -goei, te 'i 'bɔ 'le vɛ nɛn yiba -dan 'bɔ cɩ 'bɛ 'ji bɛ, yi'a 'bɛ 'ye dɩ? ");
INSERT INTO yreNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","'I 'bɔ nɛn yiba -dan cɩ 'i 'yiɛ -goei \"bɛ, -mɛ \"le \"wɛan nɛn \"yiɛ \"ve 'i bɔɛzan lɛ 'nan: ‹'I 'tɔ -e 'an yiba -flu 'si 'i 'yiɛ -goei!› ");
INSERT INTO yreNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","-Blʋzan, 'i yiba -dan 'si 'i 'yiɛ -goei 'vaa, -e 'i fɛnan yɩ 'wein. \"Bɛ -sru i -kɔlaman yiba -flu 'sidɩ -a 'i bɔɛzan -tʋ yiɛ -goei. ");
INSERT INTO yreNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Te 'ka Bali -le fɛnun -nɔn -plɛnnun lɛ dɩ, \"tɔgɔ 'o li 'o da -e 'o 'ka 'wi \"cɛɛn 'e cin man! Ɛn te 'ka 'cee -siga -fɔla 'srunun lɛ dɩ, \"tɔgɔ 'o 'tran \"da!» ");
INSERT INTO yreNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«'Ka fɛ trʋ 'ba, waa -nɔan 'cɛɛ! 'Ka fɛ -wɛɛ, kaa ye! 'Ka 'kɔn 'tɛ, waa 'lɛ \"so 'cɛɛ! ");
INSERT INTO yreNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kɔɔ min nɛn e fɛ trʋ \"baa bɛ, waa -nɔan -yrɛ. Min nɛn e fɛ -wɛɛman bɛ, yaa ye. Ɛn min nɛn e 'kɔn -tɛa \"bɛ, waa 'lɛ \"so -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Min -tʋ 'ka 'ka yei, -te 'yee 'nɛn -blɩfɛ trʋ 'ba -yrɔ, -e 'e 'kɔlɛ -nɔn -yrɛ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ɛn min -tʋ 'ka 'ka yei, -te -yee 'nɛn pɔ trʋ 'ba -yrɔ, -e 'e -mlɛn -nɔn -yrɛ \"nyian dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ka ya -wlidɩ, 'pian ka fɛ \"yi -tɔa -e 'ka -nɔn 'cee 'nɛnnun lɛ. 'Ka \"tɩ \"nɛn laji bɛ, -a ci \"yi \"mlian 'ka da, -yee \"wɛan 'ka -tɔ 'nan, e fɛ \"yi -nɔan minnun nɛn waa laabo -yrɔ \"bɛ -wlɛ! ");
INSERT INTO yreNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","'Wɩ pɛɛnɔn nɛn ka ya \"va 'nan minnun 'o drɛ 'cɛɛ bɛ, -a 'wɩ 'bɔ -tʋwli zɩɛ -nyrɛn 'ka -wee \"drɛ! 'Wɩ zɩɛ -a 'bɔ nɛn Moizi -le -pei -a 'vɩ 'nan blamin 'e drɛ. Ɛn -a -tʋwli \"nɛn \"nyian Bali 'lewei vɩnɔn -a 'vɩ 'nan blamin 'e drɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«'Kɔn -yrɛ \"fɩɩnɛn bɛ -a -ji nɛn 'ka -wla -e 'ka 'belidɩ yɩ! Kɔɔ 'kɔn -yrɛ nɛn min -wlamlan 'ji, te -a 'le 'srannan \"nɛn -kadɩ -a bɛ e ya -dan, ɛn -a -si a -gbagbla. -Si zɩɛ -a da ta wʋdɩ nɛn min \"kaga -a ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","'Pian 'kɔn -yrɛ nɛn min -wlamlan 'ji -e 'e 'belidɩ yɩ bɛ e ya \"fɩɩnɔn, ɛn -a -si a \"wɛnnɔn. -Yee \"wɛan min \"soglo 'nɛn 'bɛ 'ta wʋla \"da.» ");
INSERT INTO yreNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«'Ka yiɛ 'tɔ 'ka 'fli -va, minnun nɛn waa ve 'nan Bali 'lewei vɩnɔn nɛn waa, 'pian te o 'ka 'a dɩɛ -wee \"wɛan. 'O 'fli dra 'ka yei \"le 'blanun -le 'wɩ 'zʋ, \"tɔgɔ te plɔ winun nɛn waa. ");
INSERT INTO yreNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","O drɛ wɩnun man nɛn ka o -kɔnnɛn \"ye. Kɔɔ kaa -tɔa 'nan wa'a -lomin naan -tɛin \"man dɩ, ɛn wa'a -wɛn bɛwlɛ 'naan \"trɔɛn 'fɔn lei man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yiba \"nɛn e ya 'kpa bɛ -a 'blʋ a \"yi, ɛn yiba \"nɛn e ya -wlidɩ \"bɛ -a 'blʋ a -wlidɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yiba \"nɛn e ya 'kpa bɛ -a 'blʋ 'ka 'wlidɩ \"dɩ, ɛn yiba \"nɛn e ya -wlidɩ \"bɛ -a 'blʋ 'ka \"yi \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yiba \"nɛn e baa te -a 'blʋ 'ka \"yi \"dɩɛ, waa \"cɛan -e 'o 'fɔ 'tɛa. ");
INSERT INTO yreNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","-Yee \"wɛan minnun zɩɛ, o drɛ wɩnun man nɛn 'ka -taa \"o -tɔlɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«'An laabʋdɩ Minsan, Minsan bɛ, -a 'saza 'ka 'ko min -a Bali -le mingɔnnɛn trɛda dɩ. 'Pian min nɛn yaan \"tɩ \"nɛn laji bɛ -a ci 'sɔ wɩ dra bɛ, -yɛɛ ko -nan nun. ");
INSERT INTO yreNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yi nɛn an 'trɛdanɔn 'le tin \"baa bɛ, min \"kaga -taa -a vɩlɛ 'mɛn 'nan: ‹Minsan, Minsan! Kʋ Bali 'lewei 'vɩ 'i 'tɔ da, ɛn kʋ -yʋ -wlidɩ \"pin minnun -sru 'i 'tɔ da, ɛn kʋ 'lɛbo \"fɔ wɩnun drɛ 'i 'tɔ da.› ");
INSERT INTO yreNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","'Pian maan ve -wlɛ 'nan: ‹Ma'an 'ka 'tɔa \"fo \"dɩ, 'ka 'si 'an \"srɔn \"kɔɔbli, ka ya 'wɩ 'wlidɩ \"drɛnɔn 'a.› ");
INSERT INTO yreNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","-Yee \"wɛan nɛn, 'wɩnun nɛn maan ve 'cɛɛ 'gʋɛ, -te min nɛn yaa 'man, ɛn yaa ta 'ta 'wʋ bɛ, te -a san a \"le 'nan 'wɩ 'tɔzan nɛn e 'yee 'kɔn -klu cɛɛn 'e trʋdɩ, ɛn yaa -pʋ -fɔ 'plɛblɛ bɛ, -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fulɔ fɛɛn, ɛn laa 'fɛn, ɛn 'yi yrʋ, -a pɛɛnɔn -sɛn 'kɔn zɩɛ -a man, ɛn ya'a 'wilɛ dɩ, e ya 'e 'tɔdɩ -kli -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","'Pian min nɛn e 'wɩnun nɛn maan ve 'gʋɛ -a 'man, ɛn ya'a 'ta wʋlɛ \"da \"dɩɛ, -a san a \"le 'nan -blʋzan nɛn e 'yee 'kɔn 'tɔ nyrɛn va bɛ, -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Fulɔ fɛɛn, ɛn laa 'fɛn, ɛn 'yi yrʋ, -a pɛɛnɔn -sɛn 'kɔn zɩɛ -a man, ɛn e wiila 'nan \"fo.» ");
INSERT INTO yreNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Zɩ Zozi cɛɛn 'wɩnun zɩɛ -a vɩdɩ man bɛ, -yee 'wɩ \"paadɩ minnun pɛɛnɔn zɩɛ o 'kan, ");
INSERT INTO yreNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kɔɔ -yee 'wɩ \"paadɩ 'ka \"le 'fluba 'ci vɩnɔn 'le vɛ zʋ dɩ. 'Pian yaa \"paaman \"le min nɛn Bali -kɔladɩ -nɔn -yrɛ \"bɛ, -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Zɩ Zozi 'si pɔn da bɛ, ɛn min \"kaga sɔɔnla -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","-A -nan nɛn -kogobe 'tɛzan -tʋ pli \"man, e \"po sɔɔn \"wlu, ɛn e -yrɛ 'nan: «Minsan, maan -tɔa 'nan, -te i wɩɩ \"man \"bɛ, i -kɔlaman i -kogobe \"sia 'an man, -e 'an drɛ 'saun Bali 'lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Zozi 'e 'pɛ 'sʋ \"ji, e klɛ \"man, ɛn e -yrɛ 'nan: «An \"we \"man, 'I drɛ 'saun Bali 'lɛ!» 'Nun tɔɔn -kogobe 'bɔ 'si \"man, ɛn e drɛ 'saun Bali 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","-A -nan nɛn Zozi \"e -yrɛ 'nan: «Te 'i -nan sɛɛ wʋ min -tʋ lɛ 'mlɔnmlɔn dɩ! 'Pian 'i 'kʋ Bali -panzan -tʋ -va, -e 'yei 'nanjɛn! \"Bɛ -sru -e 'i 'sraga bʋ Bali lɛ, \"le zɩ Moizi -a crɛn -tɛ Bali -le 'fluba 'ji bɛ -yee 'wɩ 'zʋ. Tɔɔn -e minnun pɛɛnɔn 'o -kɔnnɛn \"yɩ 'nan i beli.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Zozi Kapanamo si 'sia. Zɩ e 'bɔla 'fla zɩɛ -a da bɛ, ɛn 'sounjanun tazan -tʋ pli \"man. Yaa trʋ 'ba ");
INSERT INTO yreNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","-a vɩdɩ -a 'nan: «Minsan, 'yian 'suzan 'beli! -Cɛ -fɔ \"man, ɛn e -sran \"tra. E ya 'e nyinnandɩ \"kɔnnɛn, ɛn e ya 'e yra yɩnan -wlidɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Zozi \"e -yrɛ 'nan: «An \"ta \"lo, -e 'an -cɛ 'si \"man.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ɛn 'sounjanun tazan \"e -yrɛ 'nan: «Minsan, an 'ka min nɛn i -wlamlan -yee 'kuin bɛ -a dɩ, kɔɔ Zuif min \"cɛɛ man dɩ. 'Pian 'i 'wɩ 'tʋ vɩ, -e 'an 'suzan 'e 'beli. ");
INSERT INTO yreNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'An 'bɔ 'gʋɛ, 'an 'tanɔn 'bɛ 'an \"paala, ɛn 'mɛn 'sounjanun bɛ mɛɛn 'o \"paala. -Te maan 'vɩ -a -tʋ lɛ 'nan: ‹'I 'kʋ›, -e 'e 'kʋ. Ɛn -te maan 'vɩ -a pee lɛ 'nan: ‹'I 'ta›, -e 'e 'ta. Ɛn -te maan 'vɩ 'mɛn nɔan lɛ 'nan: ‹'I 'wɩ 'gʋɛ -a drɛ bɛ›, yaa dra.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Zɩ Zozi 'wɩnun zɩɛ -a 'man bɛ, 'wɩ -a 'kan, ɛn minnun nɛn -a -sru \"bɛ, e -wlɛ 'nan: «An 'wɩ tɩglɩ ve 'cɛɛ! Ma'an tian min -tʋ yɩlɛ Izraɛl 'nɔn 'va, te e yi -tɛala 'an da tɩglɩ zɩɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Maan 'lɛ \"cɛan 'cɛɛ 'nan, min \"kaga \"sia yidɛ wluan \"nan 'lee yidɛ 'fɔ -nan \"va, o -taa -e 'o \"fɛdi -blɩ Bali fla 'o 'vale Abraam 'lee Izak 'lee Zago nun -a. ");
INSERT INTO yreNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","'Pian minnun nɛn Bali o 'si \"va 'e tɛdɛ 'yee mingɔnnɛn trɛdavɛ -a bɛ, Izraɛl 'nɔn nɛn. Bali -taa -wee 'tu wʋlɛ klun va bei. Fɛnan nɛn -wuɔdɩ 'lee 'shɛ da -blɩdɩ cɩ bɛ -a -nan.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tɔɔn Zozi \"e 'sounjanun tazan zɩɛ -yrɛ 'nan: «'I 'kʋ 'yie \"kɔnnɛn. 'Wɩ nɛn, i yi -tɛra \"da \"bɛ 'e 'lɛ sɔɔ 'yiɛ!» Tʋ 'bɔ 'lein zɩɛ -a wlu nɛn 'sounjanun tazan 'suzan bɛ, e beli. ");
INSERT INTO yreNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","\"Bɛ -sru ɛn Zozi 'kʋ Piɛri -le \"kɔnnɛn. Yaa nan \"bʋ 'yɩ 'e nyinnandɩ 'kɔlɛ 'tɔndɔn 'lɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","E klɛ -a -pɛla man, ɛn -a 'kɔlɛ 'ji 'e 'trɔ -fɔ. 'Nun tɔɔn lɩ zɩɛ e wluan lou, ɛn e fɛ -nɔn -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Zɩ funninmlan 'pla bɛ, ɛn minnun -ta minnun nɛn -yʋ -wlidɩnun cɩ o -sru \"bɛ o \"kaga \"a Zozi lɛ. Yaa 'vɩ -yʋ -wlidɩnun lɛ 'nan, 'o 'si minnun -sru, ɛn e -cɛ -tɛnɔn pɛɛnɔn beli. ");
INSERT INTO yreNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","'Wɩ nɛn Bali 'lewei vɩzan Ezai -a 'vɩ 'e 'cɛn bɛ, zɩ e 'lɛ sɔɔ zɩɛ. Kɔɔ yaa 'vɩ 'nan: «E 'kʋe yra yɩdɩ 'si 'kʋ man, ɛn e 'kʋ 'man -cɛ pɛɛnɔn 'si 'kʋ man.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Zɩ Zozi min \"kaga 'yɩ 'e \"srɔn \"bɛ, ɛn yaa 'vɩ 'e -srunɔn lɛ 'nan: «-Kaa kʋ 'yi -sru.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","-A -nan nɛn 'fluba 'ci vɩzan -tʋ pli \"man, ɛn yaa 'vɩ Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan, fɛnan pɛɛnɔn nɛn i -ko bɛ, kʋɛ 'ko 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ɛn Zozi \"e -yrɛ 'nan: «-Canjannɛnnun nyinnan a, ɛn \"lomannun \"kɔɛ \"a, 'pian Blamin -pɩ \"le \"fɛ -tʋ -nan \"ka -e 'e 'wulo 'pla 'nan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ɛn -a -sruzan 'pee -a 'vɩ -yrɛ 'nan: «Minsan, 'i 'si -nɔn 'mɛn -e 'an 'kʋ 'an \"tɩ \"wʋ 'vaa, -e 'an 'ta.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Zozi \"e 'vɩ -yrɛ 'pian 'nan: «'I -sɔɔnla 'an -sru! Minnun nɛn Bali \"le 'va o cɩ 'o 'kadɩ bɛ, 'i o 'tʋɩ 'o 'wee min wʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Zozi 'fɔ -klʋ -ji 'o 'vale 'e -srunɔn 'a, ɛn o -kʋdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tɔɔn fulɔ 'plɛblɛ 'tʋ \"fɛɛndɩ 'sia 'yi zɩɛ -a yiɛ da, ɛn 'yi 'sɛndɩ 'sia -klʋ -ji. Tʋ zɩɛ -a wlu bɛ, te Zozi \"e \"yi -tɛa. ");
INSERT INTO yreNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","-A -nan nɛn -a -srunɔn pli \"man, waa fuʋ, ɛn o -yrɛ 'nan: «Minsan, 'i 'pa 'kʋ 'va, 'kʋ 'nan \"ta -nyaan!» ");
INSERT INTO yreNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ɛn Zozi \"e -wlɛ 'nan: «-Mɛ \"klan 'bɛ 'ka -tɛa? 'Cee yi -tɛradɩ Bali da a \"wɛnnɔn!» -A -nan nɛn e wluan, ɛn e paan fulɔ 'lee 'yi da 'plɛblɛ. Tɔɔn fɛnan -tɔ flɩɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","'Wɩ zɩɛ e minnun pɛɛnɔn 'kan, ɛn waa laabʋ 'nan: «-Mɛ \"sʋ -man min 'bɛ cɩ zɩɛ, ɛn 'bɛ 'wɩ tin \"baa fulɔ 'lee 'yi lɛ -e 'o drɛla \"da.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Zɩ Zozi 'bɔla 'yi -sru Gadara 'lɛglɔn 'ji bɛ, ɛn min \"fli \"nɛn -yʋ -wlidɩnun cɩ o -sru \"bɛ, o -ta -a 'lɛ. Min -yrɛ nɛn waa bo -kɔlɛ -ji bɛ -a -mie ji nɛn o nyian. O nyran wo -wlidɩ \"le \"wɛan, min -tʋ 'ka 'ciala fɛ zɩɛ -a -nan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tɔɔn o -paandɩ 'sia 'nan: «Bali -pɩ! -Mɛ \"nɛn 'yie 'nan 'e dra 'kʋɛ? I -ta 'tɛ 'palɛ 'kʋ da 'va? Tʋ nɛn Bali -a kɔɔn bɛ ya'a tian bɔlɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tʋ zɩɛ -a wlu bɛ te 'sru 'pa 'tʋ a 'e 'blɩnan. 'Srunun 'bɔ 'ka o man -kɔɔbli dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ɛn -yʋ -wlidɩnun toba -fɔ Zozi lɛ. Waa 'vɩ -yrɛ 'nan: «-Te i 'kʋ 'pin bɛ, 'i 'kʋ 'pa 'sia 'sru 'pa 'labɛ -a va.» ");
INSERT INTO yreNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Zozi \"e -wlɛ 'nan: «'Ka 'kʋ!» Tɔɔn o 'si min \"fli zɩɛ o -sru, ɛn o -fɔ 'srunun -sru. 'Sru 'pa 'tʋ zɩɛ, o flan 'sia pɔn 'sɛan man zia, o -sɛn 'yia. Ɛn o pɛɛnɔn kaa \"fo. ");
INSERT INTO yreNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Minnun nɛn o 'srunun 'bɔ 'ta -pian \"bɛ, \"o \"sɛn 'wʋ 'ji flan -a. O 'bɔla 'ji 'fla, ɛn 'wɩ nɛn e drɛ o yiɛ man bɛ, 'lee 'wɩ nɛn e drɛ minnun nɛn -yʋ -wlidɩnun \"cɩ o -sru \"bɛ -wlɛ \"bɛ, waa -nan 'sinan 'pa. ");
INSERT INTO yreNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ɛn 'flanɔn pɛɛnɔn 'kʋ Zozi 'lɛ. Zɩ waa 'yɩ bɛ, ɛn o toba -fɔ -yrɛ 'nan, 'e 'si 'wee 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","-A -nan nɛn Zozi 'fɔ -klʋ -ji \"nyian, e 'yi cɛɛn, ɛn e 'bɔla Kapanamo. 'Fla zɩɛ -a da nɛn e -nyɛanla. ");
INSERT INTO yreNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tɔɔn minnun -ta min -tʋ nɛn e -sran \"tra \"bɛ -a -yrɛ \"se \"ji. Zɩ Zozi -wee yi -tɛradɩ 'e da 'yɩ bɛ, ɛn e 'nan min -srandɩ \"tra zɩɛ -yrɛ 'nan: «'An bee, nyɛn 'e 'si 'i 'ji! 'Wɩnun nɛn yia drɛ 'wlidɩ \"bɛ, maan fui!» ");
INSERT INTO yreNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","'Wɩ zɩɛ -a da nɛn 'fluba 'ci vɩnɔn -mienun -a 'vɩ 'o 'ji 'nan: «Min 'labɛ, e Bali srɔn!» ");
INSERT INTO yreNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Zɩ Zozi -wee ci \"nrɔndɩ 'yɩ bɛ, ɛn yaa laabʋ -wlɔ 'nan: «-Mɛ \"le \"wɛan nɛn ci \"nrɔndɩ -wlidɩ zɩɛ, e ya 'ka 'ji? ");
INSERT INTO yreNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","-Te maan 'vɩ -yrɛ 'nan: ‹'Wɩnun nɛn yia drɛ 'wlidɩ \"bɛ, maan fui›, 'bɛ a -tʋ. Ɛn -te maan 'vɩ -yrɛ 'nan: ‹'I 'wluan, 'i 'tɔ lou, 'i 'ta wʋ›, 'bɛ a -tʋ. 'Wɩ \"fli zɩɛ -a \"cɛn \"vɩdɩ 'bɛ cɩ 'plɛblɛ? ");
INSERT INTO yreNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","'Pian an \"ta -a -ci -kɔɔnman 'cɛɛ 'nan, Bali -kɔladɩ -nɔn Blamin -pɩ lɛ, -e 'e min -le 'wɩ -wlidɩnun fui 'trɛda.» -A -nan nɛn yaa 'vɩ min -srandɩ \"tra zɩɛ -yrɛ 'nan: «'I 'wluan! 'I 'yie nyinnan \"davɛ 'sia! 'I 'kʋ 'yie \"kɔnnɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","'Nun tɔɔn e wluan lou, ɛn e 'yee \"kɔnnɛn \"si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Zɩ min \"kaga 'wɩ zɩɛ -a -nan 'yɩ bɛ, \"klan -sɛn o ji, ɛn o Bali 'tɔ bɔdɩ 'sia, kɔɔ e -kɔladɩ zɩɛ -a -nɔn blamin lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Zozi 'si fɛ zɩɛ -a -nan. \"Yɛɛ -kʋ 'e 'lɛ bɛ, ɛn e min -tʋ nɛn waa laabo Matie bɛ -a 'yɩ. 'Sukɔlɛ 'sizan nɛn, ɛn e ya 'yee 'nyranman 'bɔ zɩɛ -a 'panan. Ɛn Zozi \"e -yrɛ 'nan: «'I -sɔɔnla 'an -sru!» Matie wluan, ɛn e sɔɔnla -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","\"Bɛ -sru Zozi 'lee 'e -srunɔn a 'o -nyrandɩ -blɩfɛ -sru 'kuin. Ɛn 'sukɔlɛ 'sinɔn \"kaga 'lee 'wɩ 'wlidɩ \"drɛnɔn 'ta, o -nyran fɛ -sru o va. ");
INSERT INTO yreNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Zɩ Farizɛn 'nɔn -a -nan 'yɩ bɛ, ɛn waa laabʋ Zozi -srunɔn lɔ 'nan: «-Mɛ \"le \"wɛan nɛn 'ka 'san fɛ -ble 'o 'vale 'sukɔlɛ 'sinɔn 'lee 'wɩ 'wlidɩ \"drɛnɔn 'a?» ");
INSERT INTO yreNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Zozi 'wɩ zɩɛ -a 'man, ɛn e 'nan Farizɛn 'nɔn lɛ 'nan: «Minnun nɛn -cɛ 'ka o man dɩɛ, wa'a -dɔdrɔ -sru -wɛɛman dɩ. 'Pian minnun nɛn -cɛ cɩ o man bɛ, -wɛɛ -dɔdrɔ -sru -wɛɛman. ");
INSERT INTO yreNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","'Ka 'ci \"nrɔn 'wɩ nɛn Bali -a 'vɩ bɛ -a da. E 'nan: ‹Min nyrinda 'e 'sɛn 'ka da!› 'Bɛ cɩ 'wɩ \"yi \"a, 'pian 'sraga bʋdɩ bɛ 'bɛ a 'e \"tun. 'Ka -wɛɛ 'nan 'ka 'wɩ zɩɛ -a -ci maan 'kpa! 'Wɩ 'bɔ zɩɛ -yee \"wɛan nɛn an -ta. An -ta 'nan -e 'an 'wɩ 'wlidɩ \"drɛnɔn laabʋ, -e 'o 'si 'wɩ 'ji. Ma'an 'talɛ minnun nɛn o cɩ tɩglɩ bɛ -wee \"wɛan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","\"Bɛ -sru Zan -srunɔn 'ta Zozi 'va, ɛn waa laabʋ -yrɔ 'nan: «-Mɛ \"wɛan nɛn 'kʋ 'vale Farizɛn 'nɔn 'a, kʋ fɛ \"sɔan, te 'i -srunɔn 'ka \"o \"fɛ sɔan dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ɛn Zozi \"e -wlɛ 'nan: «-Te minnun a lɩ 'pa \"fɛdi drɛnan bɛ, tʋ nɛn lɩ -trɛ 'pazan a o yei \"bɛ, o man 'ka 'kɔan 'yuo dɩ. 'Pian tʋ nɛn e 'ka \"nyian o yei \"dɩɛ, -a -nan nɛn o -kɔlaman o fɛ \"sɔan. ");
INSERT INTO yreNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ɛn \"nyian bɛ, -a -cin 'e 'tɔ 'ka 'ji 'nan, wa'a sɔ -trɛ 'fʋɩ 'sia -e 'o 'pa sɔ ceje 'fʋɩ bʋnan dɩ. -Te 'bɛ \"cɛɛ dɩɛ, sɔ -trɛ zɩɛ e sɔ ceje 'fʋɩ bʋnan \"paa \"va te e srɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wa'a 'wɛn -trɛ sɛan -wi 'kɔlɛ tre cejenun -ji dɩ. -Te 'bɛ \"cɛɛ dɩɛ -wi 'kɔlɛ tre cejenun fɛaman, -e -wɛn 'e 'sran, te 'o srɛ. 'Pian o -wɛn -trɛ -sɛan -wi 'kɔlɛ tre 'trɛnun -ji, -e -wɛn 'lee -wi 'kɔlɛ 'trenun 'o vɩlɛ 'e srɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Zozi a 'wɩnun zɩɛ -a vɩnan -wlɛ, tɔɔn ɛn min tazan -tʋ -ta. E \"po sɔɔn \"wlu, ɛn e -yrɛ 'nan: «'An 'lu \"sia -kanan 'nun -naagʋ. 'Pian 'i yra 'si, 'i 'ta 'i 'pɛ 'pla \"da, -e 'e 'fuʋ!» ");
INSERT INTO yreNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Zozi wluan, ɛn e sɔɔnla -a -sru 'o 'vale 'e -srunɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tɔɔn lɩmɔn -tʋ nɛn nyɛn -sɛanla \"man -a -nan lɛ -fuda \"fli 'bɔ, te ya'a 'nyan dɩɛ, e pli Zozi man 'e koda zia, ɛn e klɛ -yee sɔ 'lɛbo \"man. ");
INSERT INTO yreNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kɔɔ yaa 'vɩ 'e 'ji 'nan: «-Te an -kɔla an klɛ 'e \"tun -yee sɔ man bɛ an \"belia.» ");
INSERT INTO yreNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Zozi 'e 'man lila, yaa 'yɩ, ɛn e -yrɛ 'nan: «'An 'lu, nyɛn 'e 'si 'i 'ji! 'Yie yi -tɛradɩ 'an da 'i beli.» 'Nun tɔɔn lɩmɔn zɩɛ e beli. ");
INSERT INTO yreNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Zɩ Zozi 'bɔla min tazan zɩɛ -yee \"kɔnnɛn \"bɛ, e 'bei 'fɛnnɔn 'lee min \"kaga 'yɩ. O -ta -wuɔlɛ -cɛda. ");
INSERT INTO yreNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ɛn e -wlɛ 'nan: «'Ka bɔla! Nɔnbɛ 'labɛ ya'a 'kalɛ dɩ, 'pian e ya yi -tɛnan.» Ɛn waa sɛɛ wʋdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Zɩ o cɛɛn minnun bɔɔladɩ man bɛ, ɛn Zozi wlala, e nɔnbɛ zɩɛ -a 'kun 'e 'pɛ man, ɛn nɔnbɛ 'bɔ wluan lou. ");
INSERT INTO yreNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","'Wɩ zɩɛ e fuila \"man 'lɛglɔn pɛɛnɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Zɩ Zozi 'si fɛ zɩɛ -a -nan bɛ, ɛn yiɛ 'winɔn \"fli sɔɔnla -a -sru -paandɩ -a. O -paanman 'nan: «David kluda min Zozi, 'kʋ nyrinda 'e 'sɛn 'i da!» ");
INSERT INTO yreNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Zɩ e 'bɔla \"kɔnnɛn \"bɛ, ɛn yiɛ 'winɔn 'bɔ pli \"man. Zozi 'a laabʋ -wlɔ 'nan: «Ka yi -tɛala \"da 'nan, an -kɔlaman 'padɩ -a 'ka 'va?» Ɛn waa wun -fɔ -yrɛ 'nan: «-Inyan, Minsan!» ");
INSERT INTO yreNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","-A -nan nɛn 'e 'pɛ klɛ o yiɛ man, ɛn e 'nan -wlɛ 'nan: «'Wɩ nɛn ka yi -tɛra \"da \"bɛ, 'e 'lɛ sɔɔ 'cɛɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ɛn o yiɛ 'lɛ 'sʋ. Zozi 'wɩ 'pla -wlɛ, yaa 'vɩ -wlɛ 'nan: «Te 'ka -nan sɛɛ wʋ min lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","'Pian o -kʋ, ɛn waa 'sinan 'pa 'lɛglɔn pɛɛnɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Zɩ min \"fli zɩɛ o -kʋ bɛ, ɛn minnun -ta min -tʋ nɛn -yʋ -wlidɩ -a drɛ bobo -a bɛ -a Zozi lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Zozi -yʋ -wlidɩ zɩɛ -a -pin -a -sru, ɛn e 'wɩdɩ 'sia. 'Wɩ zɩɛ e minnun 'lɛbo \"fɔ, ɛn waa vɩdɩ 'sia 'nan: «Kʋ'a tian 'wɩ 'gʋɛ -a tɛdɛ -nan yɩlɛ Izraɛl 'lɛglɔn 'ji 'mlɔnmlɔn dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","'Pian Farizɛn 'nɔn \"o 'vɩ 'nan: «-Yʋnun tazan -le 'plɛblɛ 'a nɛn e -yʋnun -pian \"minnun -sru.» ");
INSERT INTO yreNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Zozi ciɩ 'fla -dandannun 'lee 'fla \"wɛnnɛnnun pɛɛnɔn da. E 'wɩ paa minnun ji -wee cin yɩ 'kɔnnun -ji. E 'wɩ 'nɔnnɔn 'vɩ -wlɛ 'nan, Bali -le mingɔnnɛn -blɩdɩ 'bɔ -kogo. Minnun pɛɛnɔn nɛn -cɛ cɩ o man 'lee minnun pɛɛnɔn nɛn o man \"yaaman bɛ, e 'o 'beli. ");
INSERT INTO yreNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Zɩ e minnun 'yɩ \"kaga \"bɛ, ɛn o nyrinda -sɛn \"da. Kɔɔ e o 'yɩ bɛ, o \"koe 'ka 'o da dɩ, ɛn o ya 'fogo 'fogo \"le 'blanun nɛn o -sru \"pinzan \"ka -e 'e o 'lɛ bʋ tɩglɩ dɩɛ -wee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","-A -nan nɛn yaa 'vɩ 'e -srunɔn lɛ 'nan: «'Saa 'bɛ tran \"kaga \"bɛ, 'pian -a -tɛnɔn a \"wɛnnɔn. ");
INSERT INTO yreNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","-Yee \"wɛan 'ka Minsan nɛn fei zɩɛ e cɩ -yee vɛ -a bɛ -a trʋ 'ba 'nan, 'e -a -tɛnɔn 'pa 'sia -e 'o -yee 'saa bɛ -a -tɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zozi 'e -srunɔn 'fuda \"fli \"bɛ o cin 'yɩ, ɛn e -kɔladɩ -nɔn -wlɛ 'nan, 'o -yʋ -wlidɩnun -pin minnun -sru, ɛn \"nyian 'o minnun pɛɛnɔn nɛn -cɛ cɩ o man 'lee minnun pɛɛnɔn nɛn o man \"yaaman bɛ o 'beli. ");
INSERT INTO yreNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Min -fuda \"fli \"nɛn Zozi o 'si \"va 'yee 'pasianɔn 'a bɛ, o 'tɔ nɛn 'gʋ: Simɔn nɛn waa laabo \"nyian Piɛri bɛ, 'lee 'e \"bʋɩ Andre, 'lee Zebede -pɩ Zaji 'lee 'e \"bʋɩ Zan, ");
INSERT INTO yreNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","'lee Filipʋ, 'lee Batelemi, 'lee Toma, 'lee Matie nɛn e ya 'e tɛdɛ 'sukɔlɛ 'sizan 'a bɛ, 'lee Alife -pɩ Zaji, 'lee Tade, ");
INSERT INTO yreNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","'lee Simɔn -tʋ nɛn waa laabo \"nyian Zelo bɛ, 'lee Zudazi Karioti. Min nɛn e \"ta -daa Zozi 'nɔnlɛ 'e 'nanmannɔn lɛ bɛ, -nyrɛn. Minnun zɩɛ o 'bɔ nɛn Zozi o 'si \"va 'yee 'pasianɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Min -fuda \"fli zɩɛ, o nɛn Zozi o 'pa 'sia. 'Wɩ nɛn yaa 'pla -wlɛ 'vaa, ɛn e o 'pa 'sia bɛ -nyrɛn 'gʋ. E -wlɛ 'nan: «Te 'ka 'kʋ minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ o va dɩ! Ɛn te 'ka 'kʋ Samari 'nɔn 'le 'flanun da dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","'Ka 'kʋ 'pian Izraɛl 'nɔn 'va. -Wɛɛ cɩ 'blanun nɛn o 'san bɛ waa! ");
INSERT INTO yreNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","'Ka 'kʋ Bali -le 'wɩ vɩ -wlɛ! 'Ka vɩ -wlɛ 'nan: ‹Bali -le mingɔnnɛn -blɩdɩ 'bɔ 'kogo.› ");
INSERT INTO yreNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Minnun nɛn 'cɛ cɩ o man bɛ, 'ka o 'beli! Minnun nɛn o -ka bɛ, 'ka o 'fuʋ! 'Ka 'kogobe 'si minnun man -e 'o drɛ 'saun Bali 'lɛ! 'Ka 'yʋ -wlidɩnun -pin minnun -sru! 'Ka 'wɩ pɛɛnɔn zɩɛ -a drɛ minnun lɛ 'e \"tun! Te 'ka fɛ -tʋ 'si \"man \"dɩ, kɔɔ an 'plɛblɛ zɩɛ -a -nɔn 'cɛɛ 'e \"tun. ");
INSERT INTO yreNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Te 'ka -siga 'lee \"lala 'sia 'ka -tiɛn \"ji dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Te 'ka 'pada 'sia dɩ! Ɛn te 'ka 'tralɛ 'sia \"fli \"dɩ! Te 'ka 'manwua pee 'sia dɩ! Ɛn te 'ka \"tonyrin pee 'sia dɩ! Kɔɔ -a -nɔan da nɛn -e 'nyranman 'pazan 'e 'yee -pan yɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","-Te 'fla -dan da nɛn ka 'bɔla oo, -te 'fla \"wɛnnɛn da nɛn ka 'bɔla oo, min nɛn e ya 'fla zɩɛ -a da, e \"we \"man -e 'e 'ka 'pɛ 'kun bɛ, -a 'bɔ nɛn 'ka -wɛɛ. 'Ka 'fʋ -a san va -trilii -e 'cee -kʋ yi 'e bɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","-Te ka wla 'kɔn 'tʋ -ji bɛ, 'ka 'kɔn zɩɛ -a -ji 'nɔn 'tɔ bʋ! ");
INSERT INTO yreNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","-Te 'kɔn zɩɛ -a -ji 'nɔn 'ka 'pɛ 'kun bɛ, 'cee -fɛa 'e 'fʋdɩ -trɔɔ -nɔn -wlɛ. 'Pian -te wa'a 'ka 'pɛ 'kunlɛ dɩɛ, 'cee -fɛa \"nɛn 'e 'fʋ 'e \"tun. ");
INSERT INTO yreNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Minnun nɛn wa'a 'ka 'pɛ 'kunlɛ dɩ, ɛn wa'a o \"trɔɛn \"tɔlɛ 'ka 'wei lɛ dɩɛ, 'ka 'pɛ 'e 'si -wee 'wɩ 'ji -e 'ka 'si 'o fla, -te 'bɛ \"cɛɛ dɩɛ, 'ka 'si 'wee \"kɔnnɛn -e 'ka 'kʋ! ");
INSERT INTO yreNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, yi nɛn Bali minnun -le tin \"baa bɛ, 'fla zɩɛ -a da 'nɔn 'o yra ye 'plɛblɛ. E \"mlian Sodɔm 'nɔn 'lee Gomɔr 'nɔn 'le yra yɩdɩ da.» ");
INSERT INTO yreNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«'Ka \"trɔɛn \"tɔ 'wɩ 'gʋɛ -yrɛ! An \"ta 'ka \"paa -sia 'trɛdanɔn 'va, 'pian ka ya o yei \"le 'nan 'blanun nɛn plɔ winun yei \"bɛ -wee 'wɩ 'zʋ. -Yee \"wɛan 'wɩ 'tɔdɩ -a nɛn 'ka 'ta wʋ o yei, ɛn 'ka 'kɔn o va -trɔɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","'Pian 'ka yiɛ 'tɔ 'ka 'fli -va minnun -le \"wɛan! Kɔɔ o -taa 'ka -nɔnlɛ tin 'banɔn lɛ, -e 'o 'ka 'sɔn -ngble -a Zuif 'nɔn 'le cin yɩ 'kɔnnun -ji. ");
INSERT INTO yreNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","'Mɛn \"wɛan o -ko 'ka 'a -kɔnmandannun 'lɛ, ɛn o -ko 'ka 'a mingɔnnɛnnun 'lɛ. Fɛ zɩɛ -a -nan nɛn ka 'mɛn 'wɩ 'nɔnnɔn vɩ. Ka dra 'mɛn 'wɩ 'nan yɩnɔn 'a o 'lɛ, ɛn ka dra \"nyian 'mɛn 'wɩ 'nan yɩnɔn 'a minnun o 'ka Zuif 'nɔn 'a dɩɛ o 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","'Pian -te o 'ka 'nɔn -wlɛ \"bɛ, 'wɩ nɛn kɔ 'ka vɩ bɛ, te -a nyɛn 'e 'kɔn 'ka 'ji dɩ. Kɔɔ -te -a tʋ 'bɔ bɛ, 'wɩ zɩɛ -a -cin -tɔa 'ka 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","-Yɛɛ cɩ 'nan 'ka \"tɩ Bali lei 'bɛ 'wɩ \"paa 'ka 'le, -e 'ka vɩ. Cɛɛ \"cɛɛ tin 'baa dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tʋ -tʋ -taa \"bɔlɛ bɛ, \"bʋɩ -mie 'e 'bɔ 'fli \"bʋɩ -nɔan \"minnun lɛ 'nan 'o -tɛ. Ɛn \"nyian 'nɛn \"tɩ -mie 'yee 'nɛn -nɔan \"minnun lɛ 'nan 'o -tɛ. 'Nɛnnun -mienun wuanla 'o \"tɩ 'lee 'o \"bʋ \"man 'nan minnun 'e o -tɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","'Mɛn \"wɛan bɛ, minnun pɛɛnɔn -taa 'nanlɛ 'ka man. 'Pian min nɛn e -tɔ 'plɛblɛ 'trilii, ɛn e 'bɔla -a 'le 'sran \"nan \"bɛ, e \"sia 'wɩ 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","-Te minnun a 'tɛ 'panan 'ka da 'fla 'tʋ da bɛ, 'ka 'si 'bɛ 'nan, -e 'ka 'kʋ 'fla 'pee da. Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, ka'a 'cɛan ciɩdɩ man Izraɛl 'fla pɛɛnɔn da Bali -le 'wɩ vɩdɩ -a 'vaa -e 'an 'bɔ Blamin -pɩ -tadɩ 'e 'bɔ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Maan ve \"nyian 'cɛɛ 'nan, 'wɩ -tranlazan 'ka 'mlian 'wɩ \"paazan da dɩ. Ɛn min 'suzan 'ka 'mlian 'e plazan \"da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","-Yee \"wɛan te 'wɩ 'e 'ka 'kan dɩ. 'Wɩ nɛn waa drɛ 'wɩ \"paazan lɛ bɛ, waa dra \"nyian -a -tranlazan \"lɛ. Ɛn 'wɩ nɛn waa drɛ min plazan \"lɛ bɛ waa dra \"nyian -a 'suzan lɛ. Ɛn \"nyian bɛ \"kɔnnɛnzan ceje 'bɔ bɛ minnun -a laabʋ -yʋnun tazan Bɛlzebul, -yee \"wɛan 'wɩ nɛn o -taa -a vɩlɛ -yee \"kɔnnɛn 'nɔn man bɛ, e \"mlianla \"da!» ");
INSERT INTO yreNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Pian minnun nɛn o 'wɩnun zɩɛ -a dra 'cɛɛ bɛ, te 'ka \"klan -wlɔ \"dɩ! Kɔɔ 'wɩ nɛn e ya tian 'e yɔɔdɩ minnun man bɛ, -a ta -taa \"bɔlɛa. Ɛn 'wɩ pɛɛnɔn nɛn minnun 'ka tian -a tɔa dɩɛ, -a -ci -taa 'silɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","-Yee \"wɛan 'wɩ nɛn maan ve 'cɛɛ klun tiidii 'va bɛ, 'ka vɩ yidɛa, ɛn 'wɩ nɛn maan ve 'cɛɛ 'sure -ji bɛ, 'ka trɔan -tɔ -guada. ");
INSERT INTO yreNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ɛn te 'ka \"klan minnun lɔ dɩ! O -kɔlaman min po -tɛdɩ -a, te wa'a 'kɔlaman -a lei -tɛdɩ -a dɩ. 'Pian 'ka \"klan Bali lɔ! Kɔɔ e -kɔlaman min po -tɛdɩ -a, ɛn e -kɔlaman min lei -tɛdɩ -a. Yaa dra 'tɛ nɛn ya'a 'driman 'mlɔnmlɔn dɩɛ -a va. ");
INSERT INTO yreNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","-A -cin 'e 'kɔn 'ka 'ji 'nan, \"loman \"wɛnwɛnnɛnnun nɛn min 'ka o taan \"lala \"kaga 'va dɩɛ, 'ka \"tɩ Bali yiɛ a o da. -A -tʋ 'ka 'sia \"va -e 'e 'tria te Bali 'bɔ \"cɛɛ 'vɩ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ɛn 'cee vɛ bɛ, 'ka 'wulo \"jɛ pɛɛnɔn nɛn 'ka 'win -ji bɛ, Bali -a pou \"nɛn -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","-Yee \"wɛan te \"klan -tʋ 'e 'kɔn 'ka 'ji 'mlɔnmlɔn dɩ, Bali 'ka \"siala e -cia \"lomannun \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Min nɛn yaa 'lɛ \"cɛan minnun 'lɛ 'nan, 'e ya 'an -sruzan 'a bɛ, maan 'lɛ \"cɛan \"nyian 'an \"tɩ \"nɛn laji bɛ -a 'lɛ 'nan, min 'gʋɛ 'an -sruzan nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","'Pian min nɛn e 'ka \"vale 'e ve minnun yiɛ man 'nan, 'e ya 'an -sruzan 'a dɩɛ, an 'bɔ \"nyian \"an \"ve 'an \"tɩ \"nɛn laji bɛ -a 'lɛ 'nan, 'an -sruzan \"cɛɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Te 'e 'kɔn 'ka 'ji 'nan, an -ta 'trɛda 'nan -e 'ka 'man 'e 'fɔla -trɔɔ dɩ! Ma'an 'talɛ 'nan -e 'ka 'man 'e 'fɔla -trɔɔ dɩ, 'pian an -ta 'wɩ 'fɔlɛa 'ka man. ");
INSERT INTO yreNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kɔɔ an -ta 'wɩ 'fɔlɛa 'nɛn -klɔnmɔn 'lee 'e \"tɩ yei, ɛn an -ta 'wɩ 'fɔlɛa nɔnbɛ 'lee 'e \"bʋ yei, ɛn \"nyian bɛ an -ta 'wɩ 'fɔlɛa 'nɛn \"bʋ 'lee 'e 'pɩ nan yei. ");
INSERT INTO yreNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ɛn min 'bɔ 'mangulinun 'bɛ -taa \"drɛlɛ -a 'nanmannɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Min nɛn e \"tɩ ye \"yi, -te \"bɛ \"cɛɛ dɩ, 'e \"bʋ ye \"yi e \"mlian 'an da bɛ, ya'a nyɛnlɛ 'an -sruzan 'a dɩ. Ɛn min nɛn e 'pɩ ye \"yi, -te \"bɛ \"cɛɛ dɩ, e 'lu ye \"yi e \"mlian 'an da bɛ, ya'a nyɛnlɛ 'an -sruzan 'a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Min nɛn e ya \"vale 'e -sɔɔnmlan 'an -sru \"bɛ, 'e 'wɩ yra yɩdɩ man, ɛn 'e 'wɩ -kadɩ man yiba \"plan da! -Te ya'a drɛlɛ zɩ dɩɛ, ya'a nyɛnlɛ 'an -sruzan 'a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Min nɛn e ya 'e 'ladɩ 'yee 'trɛda da bɛ, ya'a ye dɩ. 'Pian min nɛn 'e 'pɛ 'si 'yee 'trɛda da \"fo, ɛn 'e 'fli -nɔn 'mɛn bɛ, yaa ye.» ");
INSERT INTO yreNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Min nɛn e 'ka 'pɛ 'kun bɛ, te yaan 'pɛ 'kun. Ɛn min nɛn yaan 'pɛ 'kun bɛ, te e min nɛn yaan 'pa 'sia bɛ -a -pɛ 'kun. ");
INSERT INTO yreNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Min nɛn e Bali 'lewei vɩzan -pɛ 'kun 'nan e ya Bali 'lewei vɩzan -a -le \"wɛan bɛ, Bali -a san -ko \"paa \"le Bali 'lewei vɩzan -le 'wɩ 'zʋ. Ɛn min nɛn e min tɩglɩ 'pɛ 'kun 'nan e ya min tɩglɩ 'a -le \"wɛan bɛ, Bali -a san -ko \"paa \"le min tɩglɩ 'le 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'An -sruzan nɛn minnun 'ka -a siala fɛ -tʋ -a dɩɛ, min nɛn e 'yi 'kulenɛn 'tʋ -nɔn -yrɛ 'nan e ya 'an -sruzan 'a -le \"wɛan bɛ, maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, Bali -a -ko \"paa 'wɩ nɛn yaa drɛ bɛ -a man.» ");
INSERT INTO yreNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Zɩ Zozi cɛɛn 'wɩnun pɛɛnɔn zɩɛ -a vɩdɩ man 'e -srunɔn 'fuda \"fli \"lɛ bɛ, ɛn e 'si fɛ zɩɛ -a -nan. E -kʋ 'wɩ \"paadɩ -a minnun ji 'lee Bali -le 'wɩ vɩdɩ -a minnun lɛ fɛ zɩɛ -a \"srɔn 'flanun da. ");
INSERT INTO yreNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tʋ zɩɛ -a wlu bɛ, te Zan a -pʋ 'kuin. 'Wɩnun nɛn Crizi -a dra bɛ yaa 'man, ɛn 'e -srunɔn 'pa 'sia \"va, ");
INSERT INTO yreNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","'nan o laabʋ -yrɔ 'nan: «Yiɛ cɩ min nɛn kʋa 'man 'nan e -taa \"bɛ -a, -baa kʋa pee man -pɛan tian?» ");
INSERT INTO yreNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ɛn Zozi \"e -wlɛ 'nan: «'Ka 'kʋ! 'Wɩnun nɛn kaa 'man bɛ, 'lee 'wɩnun nɛn kaa -nan 'yɩ bɛ, 'ka 'sinan 'pa Zan lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","'Wɩnun zɩɛ -nyrɛn 'gʋ: An yiɛ 'winɔn yiɛ 'lɛ 'sʋ. Minnun nɛn o -sran \"tra \"bɛ an o wluan lou. An -kogobe 'si -kogobe 'tɛnɔn man. An \"trɔɛn \"winɔn \"trɔɛn 'lɛ 'sʋ. Minnun nɛn o -ka bɛ an o fuʋ. Ɛn an Bali -le 'wɩ 'nɔnnɔn 'vɩ 'yalɛ -tɛnɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Min nɛn e yi -tɛra an da ɛn -a -pɛ -sru 'ka tɔalɛ 'mlɔnmlɔn dɩɛ, Bali -le -fɛa a -a san man.» ");
INSERT INTO yreNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Zɩ Zan -le 'pasianɔn zɩɛ o lidɩ 'sia 'o da bɛ, ɛn Zozi Zan -le 'wɩ vɩdɩ 'sia minnun nɛn -nan bɛ -wlɛ. Yaa laabʋ -wlɔ 'nan: «-Mɛ \"le \"wɛan nɛn ka -kʋ Zan -nanjɛnlɛ \"bui \"da? -Cɛan nɛn fulɔ cɩ -a nyɔɔnnan bɛ, -a yɩnan \"cɛɛ ka -kʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ɛn -mɛ \"le \"wɛan nɛn ka -kʋ \"mɛn? Min nɛn e sɔ fɛnyian 'wʋ 'e da bɛ, -a yɩnan \"cɛɛ ka -kʋ dɩ. Kɔɔ kaa -tɔa 'nan sɔ fɛnyian fɛnyian bɛ, mingɔnnɛn -le 'kuin nɛn waa ye. ");
INSERT INTO yreNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","'Ka 'ci nrɔn 'nan Bali 'lewei vɩzan nɛn, -yee \"wɛan nɛn ka -kʋ. 'Wɩ 'kpa nɛn! 'Pian maan ve 'cɛɛ 'nan, Zan -dan \"mlian Bali 'lewei vɩzan da. ");
INSERT INTO yreNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kɔɔ e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan: ‹'An 'bɔ Bali, an 'mɛn min -tʋ -tɔala 'i 'lɛ, -yɛɛ 'i 'lɛ si dra.› Min nɛn Bali -a 'vɩ bɛ Zan nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'trɛda blamin -tʋ -dan 'ka 'mlian min -batize drɛzan Zan da dɩ. 'Pian minnun nɛn o ya Bali -le mingɔnnɛn trɛdavɛ -a bɛ, o va min \"wɛnnɛn -dan \"mlian Zan da. ");
INSERT INTO yreNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tʋ nɛn min -batize drɛzan Zan Bali -le 'wɩ vɩdɩ 'sia, 'trilii -e 'e bɔ cɛɛgʋ yi -a bɛ, minnun a 'o 'tɔdɩ lou 'nan te Bali -le mingɔnnɛn -blɩdɩ 'e 'kʋ 'e 'lɛ dɩ. Ɛn minnun 'bɔ nɛn -wee 'wɩ a 'tɔndɔn zɩɛ, o ya \"va 'nan 'e drɛ 'wee vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bali -le mingɔnnɛn -blɩdɩ pou siadɩ bɛ, Bali 'lewei vɩnɔn pɛɛnɔn -a 'vɩ 'e 'cɛn, ɛn 'wɩ zɩɛ e ya 'e 'crɛn -tɛdɩ \"nyian Moizi -le -pei 'fluba 'ji. Ɛn Zan \"e 'wɩ 'tʋwli zɩɛ -a 'vɩ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","'Wɩnun zɩɛ -te ka yi -tɛala \"da 'nan 'wɩ 'kpa nɛn bɛ, maan ve 'cɛɛ 'nan, Eli nɛn Bali 'lewei vɩnɔn -a 'vɩ 'nan e -taa 'vaa -e Bali -le mingɔnnɛn -blɩdɩ 'e pou sia bɛ -a 'bɔ nɛn Zan -a. ");
INSERT INTO yreNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Min nɛn 'wɩ man \"trɔɛn \"cɩ -a -wulo -man bɛ 'e man. ");
INSERT INTO yreNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","-Naagʋnɔn bɛ an o -kɔɔnman -tɩnun man? O ya \"le nannannun nɛn o ya srɔan -tɛnan -guada bɛ, -wee 'wɩ 'zʋ. -A -mienun -a ve 'o bɔɛnun lɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Kʋ -pʋ -tɛ 'cɛɛ, 'pian ka'a 'tanlɛ dɩ. \"Drenun nɛn o min -wulo -man -taa \"bɛ kʋa -fɔ 'cɛɛ, 'pian ka'a 'wuɔlɛ dɩ›. ");
INSERT INTO yreNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Fɛ nɛn maan 'vɩ zɩɛ -yɛɛ cɩ 'nan, zɩ Zan -ta bɛ, e fɛ 'sɔn, ɛn ya'a -wɛn mlinlɛ dɩ, 'pian minnun -a 'vɩ \"man 'nan: ‹-Yʋ -wlidɩ 'bɛ cɩ -a -sru.› ");
INSERT INTO yreNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","'Bɛ nɛn 'gʋɛ 'an 'bɔ Blamin -pɩ -ta, \"an \"fɛ -ble, ɛn \"an \"wɛn -mlian, ɛn minnun -a 'vɩ 'an man 'nan: ‹Fɛ -blɩ -lagu nɛn 'maan, ɛn -wɛn -tɛzan nɛn 'maan.› Ɛn \"nyian minnun -a 'vɩ 'an man 'nan: ‹'Sukɔlɛ 'sinɔn 'lee 'wɩ 'wlidɩ \"drɛnɔn bee nɛn 'maan.› 'Pian 'an drɛ wɩnun 'bɛ Bali -le 'wɩ 'tɔdɩ -ci -kɔɔnman.» ");
INSERT INTO yreNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","\"Bɛ -sru ɛn Zozi 'wɩ 'tɔ 'flanun nɛn e 'lɛbo \"fɔ wɩ \"kaga drɛ \"da \"bɛ o man, kɔɔ wa'a 'wɩlɛ \"man -e 'o 'si 'o drɛ wɩ -wlidɩnun man dɩ. Yaa 'vɩ -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Koraze 'nɔn, 'wɩ -taa \"bɔlɛ 'ka man! Bɛzaida 'nɔn, 'wɩ -taa \"bɔlɛ 'ka man! 'Lɛbo \"fɔ wɩnun nɛn o drɛ 'ka fla 'gʋɛ, \"te o drɛ Tir 'lee Sidɔn 'flanun da bɛ, \"te o 'tɛ 'yie 'wi 'o da -a -nan 'mɔn, ɛn \"te 'o -cɛ bʋ sɔ cɛɛn 'o man -a -nan 'mɔn. -A -ci -kɔɔndɩ nɛn 'nan o 'si 'o drɛ wɩ -wlidɩnun man. ");
INSERT INTO yreNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","-Yee \"wɛan maan ve 'cɛɛ 'nan, yi nɛn Bali minnun -le tin \"baa bɛ, 'cee yra yɩdɩ 'plɛblɛ \"mlian Tir 'nɔn 'lee Sidɔn 'nɔn 'le vɛ da. ");
INSERT INTO yreNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ɛn kaa nɛn ka cɩ Kapanamo 'nɔn 'a bɛ, e ya 'ka 'ji 'nan ka -ko Bali va laji? -Cɛjɛ, 'pian Bali 'ka -sɔɔnmlan -kanɔn 'va. Kɔɔ 'lɛbo \"fɔ wɩnun nɛn o drɛ 'ka 'va 'gʋɛ, \"te o drɛ Sodɔm 'nɔn fla bɛ, \"te 'fla zɩɛ e ya -nan tian cɛɛgʋ yi -a. ");
INSERT INTO yreNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","-Yee \"wɛan maan ve 'cɛɛ 'nan, yi nɛn Bali minnun -le tin \"baa bɛ, 'cee yra yɩdɩ 'plɛblɛ \"mlian Sodɔm 'nɔn 'le vɛ da.» ");
INSERT INTO yreNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tʋ zɩɛ -a man nɛn, Zozi Bali trʋ 'ba. Yaa 'vɩ 'nan: «'An \"tɩ, yiɛ cɩ labli 'san -a, ɛn yiɛ cɩ 'trɛ 'san -a. Mɛin 'tɔ \"yi \"ve 'nan, 'wɩnun nɛn yia yɔɔ minnun nɛn 'o 'fli \"siala 'wɩ 'tɔnɔn -a bɛ o man bɛ, yia ta 'bɔla minnun nɛn 'o 'fli drɛ nannannun -a bɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","'Wɩ 'kpa nɛn, kɔɔ 'wɩ nɛn e cɩ 'i 'ci 'sɔ 'a bɛ, -a 'bɔ nɛn yia drɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Fɛ pɛɛnɔn 'pɛba a 'e wʋdɩ 'an 'lɔ, 'an \"tɩ yiɛ drɛ zɩ. 'An \"tɩ 'saza 'bɛ 'an 'bɔ nɛn an cɩ -a -pɩ -a bɛ 'an -tɔa. Ɛn 'an 'bɔ nɛn an cɩ -a -pɩ -a bɛ 'an 'saza 'bɛ 'an \"tɩ -tɔa. Ɛn \"nyian 'an 'bɔ nɛn an cɩ -a -pɩ -a bɛ, min nɛn an ya \"va 'nan 'an ta bɔala -yrɛ \"bɛ, -a san 'bɛ 'an \"tɩ -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","'Ka pɛɛnɔn, 'ka 'ta 'an 'va! 'Ka \"koe \"a 'e 'nyandɩ, kɔɔ -trɔ nɛn 'ka 'win -ji bɛ -a cibɛn a, -yee \"wɛan 'ka 'ta 'an 'va -e 'an 'ka 'trɔa. ");
INSERT INTO yreNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","'Ka 'wɩ \"man -e 'an drɛ 'ka 'tazan -a! 'Ka -sɔɔnla 'an -sru -e 'ka 'wɩ -tranla 'an 'va! Ma'an 'tɛ 'paa 'ka da dɩ, ɛn \"nyian bɛ, an 'ka 'tʋdʋ pɛɛnɔn \"siala min -a. 'An 'va zia bɛ, 'ka 'ci yra \"tra. ");
INSERT INTO yreNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kɔɔ -si nɛn maan -kɔɔnmlan 'cɛɛ -e 'ka 'sia bɛ, e ya 'ka 'sia -si -a. Ɛn -trɔ nɛn maan -nɔan 'cɛɛ -e 'ka 'sia bɛ, e ya 'fogo 'fogo.» ");
INSERT INTO yreNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","\"Bɛ -sru 'flinla \"yi -tʋ da bɛ, ɛn Zozi 'lee 'e -srunɔn fei -tʋ 'cɛndɩ 'sia 'ji. Tʋ zɩɛ -a wlu bɛ, te dra -a -srunɔn -tɛa. Fɛ 'wlɛ nɛn fei zɩɛ -a da bɛ, waa cɛɛn, ɛn waa -blɩdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Zɩ Farizɛn 'nɔn -a -nan 'yɩ bɛ, ɛn waa 'vɩ Zozi lɛ 'nan: «\"I 'yiɔ 'i -srunɔn 'a! 'Wɩ nɛn wa'a dra -cee 'flinla \"yi da dɩɛ, -a 'bɔ nɛn o cɩ -a drɛnan bɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ɛn Zozi -a laabʋ -wlɔ 'nan: «'Wɩ nɛn -kaa tra David -a drɛ 'o 'vale 'yee minnun -a bɛ, ka'a tian -a ta vɩlɛ dʋʋ? Te dra o -tɛa \"bɛ, ");
INSERT INTO yreNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","e wla Bali -le 'kuin, ɛn 'kpɔun nɛn waa 'pla Bali -le vɛ -a bɛ, yaa 'sia, yaa blɩ, ɛn e 'yee minnun \"le \"nɔn, 'pian te -a 'kpɔun 'bɔ zɩɛ Bali -pannɔn 'saza 'bɛ -ble. ");
INSERT INTO yreNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ɛn \"nyian bɛ, kaa ta 'vɩ Bali -le 'fluba 'ji 'nan, 'flinla \"yi da bɛ, Bali -pannɔn 'ko 'nyranman 'palɛ Bali -pan 'kuin. 'Flinla \"yi 'srɔɛn nɛn waa srɛ zɩɛ, 'pian o ya Bali -pan 'kuin -le \"wɛan bɛ, min -tʋ 'ka 'wɩ 'tɔa o man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Maan ve 'cɛɛ 'nan, fɛ nɛn 'bɛ -dan \"mlian Bali -pan 'kɔn da bɛ, 'bɛ a 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","E ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan: ‹Min nyrinda 'e 'sɛn 'ka da! 'Bɛ cɩ 'wɩ \"yi \"a, 'pian 'sraga bʋdɩ bɛ, 'bɛ a 'e \"tun.› \"Te ka 'wɩ zɩɛ -a -ci 'man bɛ, 'mɛn minnun nɛn wa'a 'wɩ 'wlidɩ \"tʋ drɛlɛ 'labɛ dɩɛ, \"te ka'a 'wɩ 'tɔa o man \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Fɛ nɛn maan 'vɩ zɩɛ -yɛɛ cɩ 'nan, 'an 'bɔ Blamin -pɩ mɛɛn cɩ 'flinla \"yi san -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Zozi 'si fɛ zɩɛ -a -nan, ɛn e -kʋ -wee cin yɩ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","'Kɔn zɩɛ -a -ji bɛ, min -tʋ nɛn -a -pɛla 'ka 'e man bɛ, e ya -nan. -A -nan nɛn minnun 'wɩ 'gʋɛ -a laabʋ Zozi 'lɔ 'nan -e 'o -kɔla 'wɩ 'tɔdɩ -a \"man \"le \"wɛan. O -yrɛ 'nan: «-Cee -pei -tɔ wɩ -a -si -nɔn 'nan min 'e 'cɛ 'si min man 'flinla \"yi da?» ");
INSERT INTO yreNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «Min -tʋ 'ka 'ka yei, -te -yee 'bla a -tʋwli \"cɛ, ɛn e -tɛ -klu -ji 'flinla \"yi da bɛ, -e 'e vɩlɛ 'e 'si dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Blamin 'wɩ a e -cia 'bla da. -Yee \"wɛan -a -si a min lɔ -e 'e 'wɩ \"yi \"drɛ min lɛ 'flinla \"yi da.» ");
INSERT INTO yreNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ɛn Zozi -a 'vɩ min nɛn -a -pɛla 'ka 'e man bɛ -yrɛ 'nan: «'I 'pɛ 'sʋ \"ji!» Min zɩɛ 'e 'pɛ 'sʋ \"ji, ɛn -a -pɛ zɩɛ e drɛ \"plɔnblɔn \"le -a -pɛ -tʋ -le 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Zɩ e 'wɩ zɩɛ -a drɛ bɛ, ɛn Farizɛn 'nɔn 'bɔla bei. O -kʋ 'o cin yɩlɛ. Waa 'pla \"da 'nan, 'o Zozi 'man -wɛɛ -e 'o -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","'Wɩ nɛn -a -cin cɩ Farizɛn 'nɔn 'ji 'nan 'o dra bɛ, Zozi -a -kɔnnɛn 'yɩ, ɛn e 'si fɛ zɩɛ -a -nan, e -kʋ. Min \"kaga \"kʋla -a -sru, ɛn minnun nɛn 'o 'man \"yaaman bɛ, e -cɛ 'si o pɛɛnɔn man, ");
INSERT INTO yreNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","'pian e 'wɩ 'pla -wlɛ 'klagla 'nan, te 'wee 'tɔ fuila \"man \"dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","'Wɩ nɛn Bali 'lewei vɩzan Ezai -a 'vɩ 'e 'cɛn bɛ, zɩ e 'lɛ sɔɔ zɩɛ. Kɔɔ yaa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Bali \"e 'nan: ‹'An 'suzan nɛn maan 'si \"va \"bɛ, -nyrɛn \"bɛ. Maan ye \"yi ɛn -yee 'wɩ 'an 'ci \"nranman. An 'mɛn lei 'saun -nɔan -yrɛ. Zɩ an min \"siala min tɩglɩ 'a 'an 'lɛ bɛ, -yɛɛ ve 'lɛglɔn pɛɛnɔn 'ji 'nɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ya'a ve -sa -a dɩ, ɛn ya'a -paanman -a vɩdɩ -a dɩ. Ɛn \"nyian bɛ, ya'a ve -guada -trilii dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Maan ve 'cɛɛ 'nan, -cɛan nɛn e ya 'e 'widɩ bɛ, 'an 'suzan zɩɛ, ya'a sʋʋmlan \"nɛn \"dɩ. Ɛn 'tɛ nɛn e cɛɛn \"dridɩ man bɛ, ya'a 'driman dɩ. Yaa dra -blɛblɛ zɩɛ -trilii, -e zɩ an min \"siala min tɩglɩ 'a 'an 'lɛ bɛ, minnun pɛɛnɔn 'o -ci man. ");
INSERT INTO yreNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","'Trɛdanɔn pɛɛnɔn yiɛ 'fo -yrɛ 'nan, -yɛɛ min \"sia 'wɩ 'ji.› » ");
INSERT INTO yreNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","\"Bɛ -sru ɛn minnun -ta min -tʋ nɛn -yʋ -wlidɩ \"a -a -sru \"bɛ, -a Zozi lɛ. Min zɩɛ -yʋ -wlidɩ 'bɔ -a yiɛ 'wi, ɛn yaa drɛ bobo -a. Zozi -a beli, ɛn e wɩɩ, ɛn e fɛnan yɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","'Wɩ nɛn Zozi -a drɛ bɛ, e minnun pɛɛnɔn 'plo 'fɔ, ɛn waa 'vɩ 'o cin yei 'nan: «Min 'labɛ e -kɔan David kluda min -a 'kpagba.» ");
INSERT INTO yreNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Zɩ Farizɛn 'nɔn 'wɩ nɛn minnun -a 'vɩ bɛ -a 'man bɛ, ɛn waa 'vɩ -wlɛ 'nan: «-Yʋnun tazan Bɛlzebul -le 'plɛblɛ 'a nɛn min 'labɛ e -yʋ -wlidɩnun -pian \"minnun -sru.» ");
INSERT INTO yreNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","'Wɩ nɛn Farizɛn 'nɔn 'ji bɛ, Zozi -a -tɔ, ɛn e 'nan -wlɛ 'nan: «-Te 'lɛglɔn 'tʋ -ji minnun cɛɛn 'e cin man, ɛn o ya -kuli -tanan 'o cin man bɛ, 'lɛglɔn zɩɛ e -wia. -Te 'fla -tʋ da 'nɔn 'bɛ cɩ 'wɩ 'tʋwli zɩɛ -a drɛnan oo, 'fla zɩɛ ya'a 'mɔan dɩ, -e 'e -wi. Ɛn -te 'kɔn 'tʋwli 'lɛ \"nɛn 'nɔn 'bɛ cɩ 'wɩ 'tʋwli zɩɛ -a drɛnan oo, \"kɔnnɛn zɩɛ e -wia. ");
INSERT INTO yreNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","-A -tʋwli \"nɛn \"nyian Satan 'lee -yee -yʋnun -le vɛ -a. \"Te -wɛɛ cɛɛn 'e cin man, ɛn o ya -kuli -tannan 'o cin yei \"bɛ, \"te -yee mingɔnnɛn trɛ -wi -a -nan 'mɔn. ");
INSERT INTO yreNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kaa 'vɩ 'an man 'nan, Bɛlzebul 'bɛ 'plɛblɛ -nɔan 'mɛn ɛn an -yʋ -wlidɩ -pian \"minnun -sru, 'lɔɔ 'cee 'nɛnnun -le vɛ bɛ cɛɛ ve -nɔn? 'Wɩ nɛn kaa ve 'an man, -te ka'a ve 'cee 'nɛnnun man dɩɛ, yaa -kɔɔnman 'nan -tin a 'e 'tɛdɩ 'ka da. ");
INSERT INTO yreNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","'Pian 'mɛn vɛ bɛ, Bali lei 'bɛ 'plɛblɛ -nɔan 'mɛn, ɛn an -yʋnun -pian \"minnun -sru. 'Wɩ zɩɛ -yɛɛ -kɔɔnman 'nan Bali -le mingɔnnɛn -blɩdɩ 'bɔla 'ka 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ɛn \"nyian bɛ, maan ve 'cɛɛ 'nan, Satan nɛn e ya min 'plɛblɛ 'a bɛ, waa \"kuan waa -yrɩman 'vaa, ɛn min -kɔlaman 'e -wlamlan -yee 'kuin -e 'e -yee fɛnun \"koola. ");
INSERT INTO yreNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Min nɛn e 'ka 'an 'va dɩɛ, te -a pei a 'e 'padɩ 'an man. Ɛn min nɛn ya'a 'paa 'an 'va -e 'kʋ fɛ tre 'e cin man dɩɛ, yaa fuimlan \"man. ");
INSERT INTO yreNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","E ya \"le 'an 'wɩ 'pla 'cɛɛ 'nan, 'wɩ 'wlidɩ pɛɛnɔn nɛn min -a dra bɛ, Bali -kɔlaman -a 'cɛdɩ -a min lɛ. Ɛn \"nyian -te min Bali srɔn bɛ, Bali -kɔlaman -a 'cɛdɩ -a min lɛ. 'Pian 'wɩ nɛn Bali lei 'saun -a dra bɛ, min nɛn e \"we \"man -wlidɩ \"bɛ, Bali 'ka -a cɛa -a san lɛ 'li \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Min nɛn e 'wɩ 'wlidɩ 'vɩ 'an 'bɔ Blamin -pɩ man bɛ, waa \"cɛa -yrɛ. 'Pian min nɛn e 'wɩ 'wlidɩ 'vɩ Bali lei 'saun man bɛ, -te -a yiɛ a \"man 'trɛda 'gʋ oo, -te e -ka oo, wa'a cɛa -yrɛ \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","O yiba 'kpa -tɔa 'e 'blʋ man. -Te yiba \"a \"yi \"bɛ, -a 'blʋ -kɔan \"yi, ɛn -te yiba \"a -wlidɩ \"bɛ, -a 'blʋ -kɔan -wlidɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Min -wlidɩnun! 'Wɩ \"yi 'ka 'kɔlaman -e 'e 'bɔla 'ka 'le dɩ, kɔɔ 'ka 'ci wɩ a -wlidɩ. -Yɛɛ cɩ 'nan 'wɩ nɛn 'e fadɩ min -ji bɛ -yɛɛ bɔala min 'le. ");
INSERT INTO yreNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Min nɛn -a ci wɩ a \"yi \"bɛ, -a 'le nɛn 'wɩ \"yi bɔala, ɛn min nɛn -a ci wɩ a -wlidɩ \"bɛ, -a 'le nɛn 'wɩ 'wlidɩ bɔala. ");
INSERT INTO yreNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Maan ve 'cɛɛ 'nan, yi nɛn Bali minnun -le tin \"baa bɛ, 'wɩ pɛɛnɔn nɛn min a 'bɔla 'e 'le bɛ, yi zɩɛ -a da nɛn min -a -ci ve. ");
INSERT INTO yreNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kɔɔ 'wɩ pɛɛnɔn nɛn min -a 'vɩ bɛ, -yɛɛ -tin -tɛa \"min da, ɛn -yɛɛ min -le tin dra 'nɔnnɔn.» ");
INSERT INTO yreNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","\"Bɛ -sru ɛn 'fluba 'ci vɩnɔn -mienun 'lee Farizɛn 'nɔn -mienun 'wɩ laabʋ Zozi 'lɔ. O -yrɛ 'nan: «Bali -le 'wɩ \"paazan, 'i 'wɩ 'tʋ drɛ -e 'e -ci -kɔɔn 'kʋɛ 'nan i \"sia Bali va!» ");
INSERT INTO yreNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ɛn Zozi \"e 'nan -wlɛ 'nan: «-Naagʋnɔn, ka ya min -wlidɩnun -a, ka cɛɛn Bali man, ɛn ka ya \"va 'nan, 'an 'wɩ 'tʋ drɛ -e 'e -kɔɔn 'nan 'an \"sia Bali va. 'Pian maan ve 'cɛɛ 'nan, Bali 'ka \"nyian 'wɩ 'nɔan -kɔɔn \"vɛ pee dra 'ka 'va 'gʋ dɩ, -te ya'a 'silɛa 'wɩ nɛn e 'bɔ Bali 'lewei vɩzan Zonazi man bɛ -a dɩɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","'Wɩ nɛn e 'bɔ Zonazi man bɛ -nyrɛn 'gʋ. E yi drɛ pɔ -dan tʋ pɔn -ji yaaga. 'Wɩ 'tʋwli zɩɛ e bɔa 'an 'bɔ Blamin -pɩ man, an yi dra 'trɛ 'ji yaaga. ");
INSERT INTO yreNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yi nɛn Bali minnun -le tin \"baa bɛ, Ninivi 'nɔn 'bɛ 'wɩ -tɔa -naagʋnɔn man. Kɔɔ zɩ Zonazi Bali -le 'wɩ 'vɩ Ninivi 'nɔn lɛ bɛ, o 'si 'wɩ 'wlidɩ \"drɛdɩ man, ɛn o -sɔɔnla Bali -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ɛn \"nyian bɛ, lɩmɔn -tʋ nɛn 'li e ya mingɔnnɛn -a 'trɛda \"tre 'zia bɛ, yi nɛn Bali minnun -le tin \"baa bɛ, -yɛɛ 'wɩ -tɔa -naagʋnɔn man. Kɔɔ e 'si 'trɛda fɛnan -kɔɔbli 'nan, 'nan -e 'e Salomɔn -le 'wɩ 'tɔdɩ yɩ. Maan ve 'cɛɛ 'nan, min nɛn -a -dan \"mlian Salomɔn da bɛ, e ya 'gʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«-Te -yʋ -wlidɩ 'si min -tʋ -sru \"bɛ, e -cia \"wʋdɩ -a fɛnan -kadɩnun -nan. E -cia \"fɛnan -wɛɛdɩ -a 'nan -e 'e -nyran nan, 'pian -te ya'a yɩlɛ dɩɛ, ");
INSERT INTO yreNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","-e 'e vɩ 'nan: ‹An lia 'an da 'mɛn 'kɔn nɛn an cɩ \"nɛn \"ji bɛ, -a -ji.› -Te e -ta, te -a -nan a e \"koodɩ, te fɛnun a 'e wʋʋladɩ \"da, ɛn -a -ci a 'e \"tun \"bɛ, ");
INSERT INTO yreNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tɔɔn e -ko 'e -sru, -e 'e -yʋ -wlidɩ 'sɔravli \"nɛn o -wlidɩ \"mlian \"da \"bɛ o 'pa 'e 'va, -e 'o 'ta -nyran 'kɔn zɩɛ -a -ji. \"Yɛɛ 'le 'sran bɛ, min zɩɛ -yee -kɔndɩ -wlidɩ \"mlian -a tɛdɛ vɛ da \"fo. 'Wɩ -tʋwli zɩɛ -yɛɛ dra -naagʋnɔn lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Zozi 'fʋ tin 'banan minnun zɩɛ -wlɛ, ɛn -a \"bʋ 'lee -a \"bʋɩnun -ta. O -fʋ 'o 'tɔdɩ bei, ɛn o 'nan 'o ya \"vale 'o 'wɩ tin \"baa -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ɛn minnun nɛn o cɩ Zozi wei mannan bɛ, o va min -tʋ -kʋ -a vɩlɛ -yrɛ 'nan: «'I \"bʋ 'lee 'i \"bʋɩnun a bei, o ya \"vale 'o tin \"baa 'yiɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","'Pian Zozi \"e min zɩɛ -yrɛ 'nan: «-Tɩnun 'bɛ cɩ 'an \"bʋ \"a, ɛn -tɩnun 'bɛ cɩ 'an \"bʋɩnun -a?» ");
INSERT INTO yreNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Zɩ e 'wɩ zɩɛ -a 'vɩ bɛ, -a -nan nɛn 'e 'pɛ 'sʋ \"ji 'e -srunɔn da, ɛn e 'nan: «\"Ka 'yiɔ, 'an \"bʋ 'lee 'an \"bʋɩnun nɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Fɛ nɛn an 'wɩ zɩɛ -a 'vɩ bɛ, -yɛɛ cɩ 'nan min nɛn yaan \"tɩ \"nɛn laji bɛ -a ci 'sɔ wɩ dra bɛ, -yɛɛ cɩ 'an \"bʋ \"a, ɛn -yɛɛ cɩ 'an \"blu -a, ɛn -yɛɛ cɩ 'an \"bʋɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yi -tʋwli zɩɛ -a da bɛ, Zozi 'si 'kuin, ɛn e -kʋ -nyɛnlɛa Galile 'yi 'plo man. ");
INSERT INTO yreNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Minnun a trenan \"man \"kaga, -yee \"wɛan e -kʋ -fɔlɛ -klʋ -ji, ɛn e -nyran. Minnun pɛɛnɔn \"o -fʋʋ 'yi 'plo da, ");
INSERT INTO yreNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ɛn e 'wɩ \"paadɩ 'sia o ji -kɔnnɛnnun -fɔdɩ -a -wlɛ. E 'nan -wlɛ 'nan: «Min -tʋ 'bɛ 'kʋ 'saa 'fɔlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","\"Yɛɛ -kɔn -a wɛɛnnan bɛ, ɛn -a 'wlɛ plɔɛn 'sran si man. \"Lomannun -ta, ɛn waa blɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","-A 'wlɛ -mie -sran \"nyian puo da, fɛnan nɛn 'trɛ 'ka \"kaga \"dɩɛ, -a -nan. E bɔdɩ 'sia tada, kɔɔ 'trɛ 'ka \"da \"kaga \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","'Pian zɩ yidɛ \"ɛ bɔla \"ji \"bɛ, 'saa zɩɛ e 'tɛ blɩ, ɛn e -ka, -a \"sɛin 'ka 'kʋlɛ -kɔɔbli dɩ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ɛn -a 'wlɛ -mie -sran \"nyian fɛnan nɛn -tɛin -taa \"bɔlɛ bɛ -a -nan. -Tɛin zɩɛ e 'tu, yaa -maan 'saa 'ka bɔlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ɛn -a 'wlɛ -mie -sran 'trɛ \"yi \"da, e 'bɔ, e -sɛn \"da. 'Saa bɛ -tʋ 'wlɛ a \"man -yaa tʋ, ɛn -a bɛ -tʋ 'wlɛ a \"man -fuba 'shɛɛdʋ, ɛn -a bɛ -tʋ 'wlɛ a \"man -fuba yaaga. ");
INSERT INTO yreNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Min nɛn 'wɩ man \"trɔɛn \"cɩ -a -wulo -man bɛ, -a san 'e man!» ");
INSERT INTO yreNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Zozi -srunɔn pli Zozi man, ɛn waa laabʋ -yrɔ 'nan: «-Mɛ \"le \"wɛan nɛn i 'wɩ tin 'ba minnun 'labɛ -wlɛ -kɔnnɛn \"ji?» ");
INSERT INTO yreNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ɛn Zozi \"e -wlɛ 'nan: «Kaa 'gʋɛ, 'ka lɛ nɛn Bali 'yee 'wɩ yɔɔdɩ nɛn 'e min \"paala 'a bɛ -a -ci 'si. 'Pian minnun nɛn o 'ka 'an -sru \"dɩɛ, \"o 'wɩ pɛɛnɔn maan -kɔnnɛn \"ji. ");
INSERT INTO yreNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","'Wɩ 'kpa nɛn, kɔɔ min nɛn e ya -yrɔ \"bɛ, -a lɛ nɛn waa -nɔan, -e 'e -tɔ 'e 'ciɩla \"da. 'Pian min nɛn -yee \"ka \"dɩɛ, -a \"tiɛnnɛn nɛn yaa -tɔa \"bɛ, waa \"sia -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'Wɩ zɩɛ -yee \"wɛan nɛn an 'wɩ tin \"baa minnun 'labɛ -wlɛ -kɔnnɛn \"ji, kɔɔ o yiɛ a \"ji fɛnan yɩ vɛ -a, 'pian wa'a fɛnan ye dɩ. Ɛn 'wɩ man \"trɔɛn \"a o -wulo -man, 'pian wa'a 'wɩ maan dɩ, ɛn waa 'wɩ 'ci maan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","'Wɩ nɛn Bali 'lewei vɩzan Ezai -a 'vɩ bɛ, -yɛɛ 'bɔ o man. Yaa 'vɩ nan: ‹'Ka \"trɔɛn -tɔa 'wɩ lɛ 'kpa tɩglɩ, 'pian ka'a -ci maan dɩ. Ka fɛnan -nanjɛan 'kpa tɩglɩ, 'pian ka'a -kɔnnɛn 'ye dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","-Yɛɛ cɩ 'nan minnun 'labɛ 'o 'bli da -tɔ 'plɛblɛ, 'o 'fli \"trɔɛn drɛ \"yuyu, ɛn 'o yiɛ 'lɛ 'wʋ 'o 'bɔ 'a. Waa drɛ zɩɛ 'nan, -e 'o vɩlɛ 'o fɛnan yɩ dɩ, ɛn -e 'o vɩlɛ 'o 'wɩ man dɩ, ɛn -e 'o vɩlɛ 'o 'wɩ 'ci man dɩ. 'Wɩ pɛɛnɔn zɩɛ waa drɛ 'nan, \"tɔgɔ 'o -sɔɔnla 'an -sru -e 'an o 'si 'wɩ 'ji.› ");
INSERT INTO yreNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","'Pian kaa nɛn ka cɩ 'an -srunɔn 'a 'gʋɛ, Bali -le -fɛa a 'ka man, kɔɔ 'ka yiɛ fɛnan ye, ɛn 'ka \"trɔɛn 'wɩ 'ci maan. ");
INSERT INTO yreNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, Bali 'lewei vɩnɔn \"kaga, 'lee minnun nɛn o 'ta 'wʋla Bali wei da bɛ o \"kaga -a man wɛɛ 'nan, fɛ nɛn kaa ye bɛ \"o \"ye, 'pian wa'a -kɔlalɛ -a yɩdɩ -a dɩ. Ɛn \"nyian waa man wɛɛ 'nan, 'wɩ nɛn kaa maan 'gʋɛ \"o maan, 'pian wa'a -kɔlalɛ -a mandɩ -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Kaa nɛn ka cɩ 'an -srunɔn 'a bɛ, -kɔnnɛn \"nɛn maan -fɔ 'saa 'fɔzan man bɛ, an \"ta -a -ci ve 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Min -mienun -le vɛ bɛ, 'wɩ nɛn e 'bɔ 'saa 'wlɛ nɛn e -sran -si man bɛ -a man bɛ, -yɛɛ bɔa \"nyian -wee \"man. 'O \"trɔɛn \"tɔ Bali -le mingɔnnɛn -blɩdɩ min da 'wɩ lɛ, 'pian o \"trɔɛn \"yuyu 'tan. Tɔɔn ɛn Bali 'nanmanzan 'ta 'wɩnun nɛn -a -cin -fɔla o ji bɛ, -a \"koolɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Min -mienun -le vɛ bɛ, 'wɩ nɛn e 'bɔ 'saa 'wlɛ nɛn e -sran puo da bɛ, -a man bɛ, -yɛɛ bɔa \"nyian -wee \"man. O Bali -le 'wɩ maan, 'nun tɔɔn o \"we \"man ci \"nrandɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","'Pian o 'ka 'o 'tɔdɩ \"da 'plɛblɛ dɩ, -Te 'wɩ 'tɔndɔn bɔdɩ \"sia o man, ɛn minnun 'tɛ 'padɩ 'sia o da 'nan o wɩɩ Bali -le 'wɩ man -le \"wɛan bɛ, tɔɔn -e 'o 'pɛ 'si Bali -le 'wɩ -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Min -mienun -le vɛ bɛ, 'wɩ nɛn e 'bɔ 'saa 'wlɛ nɛn e -sran fɛnan nɛn -tɛin -taa \"bɔlɛ bɛ, -a -nan bɛ, -yɛɛ bɔa -wee \"man. O Bali -le 'wɩ maan, 'pian -wee ci \"nrɔndɩ 'trɛda fɛnun da, 'lee -wee \"lala yɩdɩ \"yi \"bʋʋ \"bɛ, e -si -tɔa Bali wei lɔ -e 'e 'nyranman 'pa o man. ");
INSERT INTO yreNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","'Pian min -mienun -le vɛ bɛ, 'wɩ nɛn e 'bɔ 'saa 'wlɛ nɛn e -sran 'trɛ \"yi \"da bɛ, -a man bɛ, -yɛɛ bɔa \"o man. O Bali -le 'wɩ maan, o \"we \"man, tɔɔn 'nyranman nɛn Bali wei -a 'padɩ \"siala o man bɛ -a \"nɛn bɔala -dan. Te o drɛ \"le 'nan 'saa nɛn -a bɛ -tʋwli 'wlɛ a \"man -yaa tʋ, ɛn -a -tʋwli 'wlɛ a \"man -fuba 'shɛɛdʋ, ɛn -a -tʋwli 'wlɛ a \"man -fuba yaaga bɛ, -yee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Zozi -kɔnnɛn \"pee -fɔ \"nyian -wlɛ. E 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -nyrɛn 'gʋ. E ya \"le min -tʋ 'bɛ 'yee fei 'pa, ɛn e 'saa 'fɔ \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","'Pian, zɩ -pei 'tan, ɛn minnun a yi -tɛnan bɛ, min zɩɛ -a 'nanmanzan 'ta, e lu -wlidɩ 'wlɛ wɛɛn fei zɩɛ -a da, ɛn e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","'Saa zɩɛ e 'bɔ, e -sɛn \"da, ɛn lu -wlidɩ \"e 'bɔ 'wʋ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Minnun nɛn 'o yiɛ -tɔa \"fei 'bɔ 'va te waa man dra bɛ, o -ta -a vɩlɛ fei san lɛ 'nan: ‹'Kʋ 'san, 'saa 'saza nɛn yia -fɔ 'yie fei. E drɛ 'kɔ, ɛn lu -wlidɩ 'bɔ 'ji?› ");
INSERT INTO yreNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ɛn e 'nan -wlɛ 'nan: ‹'An 'nanmanzan 'bɛ drɛ.› Ɛn -yee minnun 'bɔ -a 'vɩ -yrɛ 'nan: ‹Kʋ \"ta -ko -a \"sʋʋlɛa?› ");
INSERT INTO yreNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ɛn e 'nan -wlɛ 'nan: ‹-Cɛjɛ, te 'ka drɛ dɩ! \"Tɔgɔ \"cɛɛ vɩ 'nan ka lu -wlidɩ 'sʋla bɛ, 'ka 'saa 'pa 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","'Ka o 'tʋɩ 'o trʋ 'e cin va -trilii, -e 'saa 'tɛ tʋ 'e bɔ. 'Saa 'tɛ tʋ -man bɛ, maan ve 'saa 'tɛnɔn lɛ 'nan, 'o lu 'wlɛ -wlidɩ \"sʋʋla 'e 'flin, 'wɛɛ -yrɩ, -e 'wɛɛ 'tɛ 'blɩ. Ɛn 'saa bɛ, 'wɛɛ 'tɛ, -e 'wɛɛ 'sɛn 'mɛn 'trɛbɔ -ji.› » ");
INSERT INTO yreNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Zozi -kɔnnɛn \"pee -fɔ \"nyian -wlɛ. E 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -nyrɛn 'gʋ. E ya \"le min -tʋ 'bɛ fei fɛ 'wlɛ \"wɛnnɛn 'tʋ 'si, ɛn yaa -fɔ 'yee fei. ");
INSERT INTO yreNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Fei fɛ 'wlɛ zɩɛ -a \"wɛnnɛn \"mlian fei fɛ 'wlɛ pɛɛnɔn nɛn min -a -fɔa \"fei bɛ -a da. 'Pian -te waa -fɔ ɛn e 'bɔ bɛ, -a -dan \"mlian fei 'wlɛ pɛɛnɔn da. E dra \"le yiba 'zʋ, te \"lomannun a o \"kɔɛ \"tɔnan -a plan -ji.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ɛn e -kɔnnɛn \"pee -fɔ \"nyian -wlɛ. E 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -nyrɛn 'gʋ. E ya \"le lɩmɔn -tʋ 'bɛ -fari puu \"sonun yaaga 'si, e 'mannyan \"wɛnnɔn 'wʋ \"va, ɛn yaa baa. 'Mannyan zɩɛ e -fari -pʋ 'bɔ siiman 'e pɛɛnɔn.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","-Kɔnnɛn \"ji nɛn Zozi wɩ pɛɛnɔn zɩɛ -a 'vɩ minnun \"kaga \"nɛn 'o cin 'yɩ bɛ -wlɛ. Ya'a 'wɩ 'tʋ vɩlɛ -wlɛ te e 'ka -kɔnnɛn \"ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Zozi -a drɛ zɩɛ 'nan, -e 'wɩ nɛn Bali 'lewei vɩzan -a 'vɩ bɛ, 'e 'lɛ sɔɔ. Bali 'lewei vɩzan -a 'vɩ 'nan: «-Kɔnnɛn \"ji nɛn an 'wɩ tin \"baa minnun lɛ. 'Wɩnun nɛn o -fʋ 'e yɔɔdɩ 'trɛda pou sianan \"trilii -e 'e 'bɔ cɛɛgʋ yi -a bɛ, maan ve minnun lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","\"Bɛ -sru, Zozi minnun \"kaga zɩɛ o 'tʋɩ, ɛn e -kʋ \"kɔnnɛn 'o 'vale 'e -srunɔn 'a. -A -srunɔn pli \"man, ɛn o 'nan -yrɛ 'nan: «-Kɔnnɛn \"nɛn yia -fɔ lu 'wlɛ -wlidɩ \"da bɛ, 'i -ci vɩ 'kʋɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Min nɛn, e 'saa 'fɔ bɛ, 'an 'bɔ Blamin -pɩ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Fei 'bɔ bɛ, 'trɛda nɛn. 'Saa 'wlɛ bɛ, minnun nɛn o 'ta wʋla Bali -sru \"bɛ o nɛn. Lu 'wlɛ 'wlidɩ \"bɛ, minnun nɛn o 'ta wʋla Satan -sru \"bɛ o nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Min zɩɛ -a 'nanmanzan nɛn e lu 'wlɛ 'wlidɩ wɛɛn bɛ, Satan nɛn. 'Saa 'tɛ tʋ bɛ, yi nɛn Bali 'trɛdanɔn -le tin \"baa bɛ -nyrɛn. Ɛn 'saa -tɛnɔn bɛ, Bali -le 'pasianɔn nɛn laji bɛ o nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","O lu 'wlɛ 'wlidɩ 'tɛ blɩ, 'wɩ 'tʋwli zɩɛ -yɛɛ dra yi nɛn Bali 'trɛdanɔn -le tin \"baa bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","'Wɩ nɛn e -taa \"drɛlɛ bɛ -nyrɛn 'gʋ: 'An 'bɔ Blamin -pɩ 'an 'mɛn 'pasianɔn nɛn laji bɛ o \"paa -sia. 'Wɩ 'wlidɩ \"drɛnɔn, 'lee minnun nɛn waa dra -e min 'e 'wɩ 'wlidɩ \"drɛ bɛ, 'mɛn 'pasianɔn o bo \"va minnun nɛn Bali mingɔnnɛn -ble o da bɛ o yei. ");
INSERT INTO yreNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","O minnun zɩɛ o -sɛan 'tɛ -dan 'va. Fɛnan nɛn -wuɔdɩ 'lee 'shɛ da -blɩdɩ cɩ bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tɔɔn -e minnun nɛn o 'ta 'wʋla Bali -sru \"bɛ, o ta 'e 'sʋ 'o \"tɩ \"le mingɔnnɛn trɛda, te o -san a \"le yidɛ 'san -le 'wɩ 'zʋ. Min nɛn 'wɩ man \"trɔɛn \"cɩ -a -wulo -man bɛ -a san 'e man!» ");
INSERT INTO yreNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Zozi \"e 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ -nyrɛn 'gʋ. E ya \"le 'nan -gan -tʋ nɛn 'e yɔɔdɩ fei -tʋ da. Min -tʋ -kʋ, e -gan zɩɛ -a 'yɩ, ɛn \"e yɔɔ \"nyian. -A ci \"nranman \"bʋʋ -le \"wɛan, e 'yee fɛnun pɛɛnɔn 'tan, ɛn e -kʋ fei zɩɛ -a 'lɔlɛ -a man \"lala -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ɛn e -kɔnnɛn \"pee -fɔ \"nyian -wlɛ. E 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -nyrɛn 'gʋ. E ya \"le 'flɛ 'tanzan -tʋ 'bɛ cɩ fɛ -tʋ nɛn -a 'flɛ a \"le -siga -zʋ bɛ -a -mie -wɛɛnan 'nan -e 'e 'lɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Fɛ zɩɛ yaa -tʋ 'yɩ te -a 'flɛ a 'kpa tɩglɩ. E -kʋ, e 'yee fɛnun pɛɛnɔn 'tan, ɛn e -ta -a 'lɔlɛ -a man \"lala -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Zozi -kɔnnɛn \"pee -fɔ \"nyian -wlɛ. E 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -nyrɛn 'gʋ. E ya \"le min -tʋ 'bɛ 'kʋ 'yee \"se 'wɛɛnlɛ 'yi 'va. \"Se zɩɛ pɔ 'tɔ 'tʋdʋ pɛɛnɔn 'sɛn -ji. ");
INSERT INTO yreNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Zɩ e 'fa bɛ, minnun -a klan 'yi 'plo da, o -nyran, ɛn waa fa bʋdɩ 'sia. Pɔ 'kpa nun nɛn \"va \"bɛ, -wɛɛ -sɛn -pɔ -ji, ɛn -a -wlidɩnun bɛ, -wɛɛ wɛɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'Wɩ 'tʋwli zɩɛ -yɛɛ dra yi nɛn Bali 'trɛdanɔn 'le tin \"baa bɛ, -a da. Bali -le 'pasianɔn nɛn laji bɛ, o -taa \"min -wlidɩnun bʋlɛ \"va minnun nɛn o 'ta 'wʋla Bali -sru \"bɛ o yei. ");
INSERT INTO yreNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","O minnun zɩɛ o -sɛan 'tɛ -dan 'va. Fɛnan nɛn -wuɔdɩ 'lee 'shɛ da -blɩdɩ cɩ bɛ -a -nan.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ɛn Zozi -a laabʋ 'e -srunɔn 'lɔ 'nan: «Ka 'wɩ pɛɛnɔn zɩɛ -a -ci 'man?» O -yrɛ 'nan: «-Inyan!» ");
INSERT INTO yreNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ɛn e -wlɛ 'nan: «Kaa 'vɩ 'kpa. Maan ve 'cɛɛ 'nan, min nɛn e Bali -le 'fluba -tɔa ɛn e -sɔɔnla 'an -sru \"bɛ, te e drɛ \"le \"kɔnnɛn san ceje -le 'wɩ 'zʋ. E 'wɩ cejenun 'lee 'wɩ 'trɛnun \"paaman 'yee \"kɔnnɛn 'nɔn 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Zɩ Zozi cɛɛn -kɔnnɛn \"nun zɩɛ -a -fɔdɩ man bɛ, ɛn e 'si 'nan, ");
INSERT INTO yreNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","e -kʋ 'e fla. Zɩ e 'bɔla -nan nun bɛ, e 'wɩ \"paadɩ 'sia -wee cin yɩ 'kuin. Min pɛɛnɔn 'plo 'fɔ ɛn o 'nan: «-Tɩɛ 'wɩ 'tɔdɩ paa \"ji? Ɛn yaa dra 'kɔ 'lɔɔ ɛn e 'lɛbo \"fɔ wɩnun dra? ");
INSERT INTO yreNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Min nɛn e cɩ -a bɛ, kʋa -tɔa. Yiba \"nyaanzan nɛn 'gʋɛ -a -pɩ nɛn. Ɛn Mari 'bɛ cɩ -a \"bʋ \"a. Ɛn -a \"bʋɩnun nɛn Zaji 'lee Zozɛfʋ 'lee Simɔn 'lee Zud -a. ");
INSERT INTO yreNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ɛn \"nyian bɛ, -a \"blunun pɛɛnɔn a -kaa fla 'gʋ. -Yee 'wɩ 'tɔdɩ 'lee 'lɛbo \"fɔ wɩnun drɛdɩ 'labɛ nyin zia nɛn yɛɛ 'si?» ");
INSERT INTO yreNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","'Wɩ zɩɛ ya'a o ci 'sɔlɛ dɩ. -Yee \"wɛan nɛn wa'a 'wɩlɛ \"man -e 'o yi -tɛra \"da \"dɩ. -A -nan nɛn Zozi \"e 'nan -wlɛ 'nan: «-Te Bali 'lewei vɩzan a 'e fla, ɛn -te 'bɛ \"cɛɛ dɩ 'nan e ya 'yee \"kɔnnɛn \"bɛ, minnun yiɛ 'ka \"naan \"man \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Minnun 'ka yi -tɛlɛa Zozi da dɩ -le \"wɛan, ya'a 'lɛbo \"fɔ wɩ \"kaga \"drɛlɛ fɛ zɩɛ -a -nan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tʋ zɩɛ -a man nɛn, mingɔnnɛn Erodi nɛn e Galile 'lɛglɔn \"paala bɛ, e Zozi 'le 'wɩ 'man. ");
INSERT INTO yreNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yaa 'vɩ 'e 'wlunɔn lɛ 'nan: «Min 'labɛ min -batize drɛzan Zan nɛn! E wluan -kanɔn 'va, -yee \"wɛan 'plɛblɛ a -yrɔ ɛn e 'lɛbo \"fɔ wɩnun dra.» ");
INSERT INTO yreNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","'Wɩ nɛn e drɛ 'lɔɔ ɛn Zan 'bɔ 'ka bɛ, -nyrɛn 'gʋ: Erodi 'bɛ 'vɩ 'nan o Zan 'kun, o -yrɩ, -e 'o -fɔ -pʋ 'kuin. Erodi 'e \"bʋɩ Filipʋ nan nɛn waa laabo Erodia bɛ -a 'si 'e 'lɔ, ɛn yaa 'pa. ");
INSERT INTO yreNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","'Wɩ zɩɛ e 'nan Zan man, tʋ pɛɛnɔn man bɛ te yaa ve Erodi lɛ 'nan: «-A -si 'ka 'i 'lɔ -e 'i \"bʋɩ nan 'pa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","-Yee \"wɛan Erodi a \"va 'nan 'e Zan -tɛa. 'Pian \"klan a \"ji minnun \"le \"wɛan, kɔɔ min pɛɛnɔn Zan \"siala Bali 'lewei vɩzan -a. ");
INSERT INTO yreNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Erodi -ya yi \"fɛdi drɛdɩ 'bɔ. Yi zɩɛ -a da bɛ Erodia 'lu \"dre 'tan minnun nɛn Erodi o laabʋ \"fɛdi da bɛ o 'lɛ. -Yee \"dre 'tandɩ Erodi ci 'sɔ \"fo. ");
INSERT INTO yreNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","-Yee \"wɛan e -tɔ 'e 'wei da nɔnbɛ zɩɛ -yrɛ. Yaa 'vɩ -yrɛ 'nan: «Fɛ oo fɛ nɛn i ya \"va \"bɛ, 'i vɩ 'mɛn, maan -nɔan 'yiɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","-A \"bʋ 'wɩ wʋʋ \"ji, ɛn e 'nan Erodi lɛ 'nan: «Min -batize drɛzan Zan -wulo -va nɛn an cɩ. 'I -nɔn 'mɛn -naagʋ \"plɛdi da!» ");
INSERT INTO yreNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","'Wɩ zɩɛ e trun -fɔ mingɔnnɛn Erodi man. 'Pian e -tɔ 'e wei da 'va, ɛn \"nyian bɛ minnun nɛn \"fɛdi da bɛ -wee \"wɛan, ya'a 'kɔlaman -e 'e vɩ -cɛjɛ dɩ. -A -nan nɛn e wɩɩ \"man, ");
INSERT INTO yreNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ɛn e min 'pa 'sia 'nan 'e 'kʋ Zan -wulo 'cɛn -pʋ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Yaa cɛɛn, ɛn e -ta -a \"plɛdi da. Waa -nɔn nɔnbɛ zɩɛ -yrɛ, ɛn e -kʋ -a 'e \"bʋ \"lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","\"Bɛ -sru, Zan -srunɔn 'ta Zan -kadɩ 'silɛa, ɛn o -kʋ -a wʋlɛ. 'Wɩ nɛn e 'bɔ \"man \"bɛ, ɛn o -kʋ -a 'sinan 'palɛ Zozi lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Zɩ Zozi 'wɩ zɩɛ -a 'man bɛ, e -fɔ -klʋ -ji, ɛn e 'si fɛ zɩɛ -a -nan. E ya 'vale 'e -kɔan fɛnan nɛn e cɩ flɩɩ bɛ -a -nan. 'Pian min \"kaga -a -kɔnnɛn 'yɩ, o 'si 'fla, ɛn o -kʋla -a -sru 'o 'cɛin ji. ");
INSERT INTO yreNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Zɩ e sɔɔnla -klʋ -ji bɛ, e minnun 'yɩ \"kaga, ɛn o nyrinda -sɛn \"da. -A -nan nɛn -cɛnɔn nɛn minnun zɩɛ o yei \"bɛ e o beli. ");
INSERT INTO yreNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Zɩ funninmlan \"ta \"paala bɛ, ɛn -a -srunɔn pli \"man, o -yrɛ 'nan: «-Pei \"ta taan, min 'ka 'nyɛanla 'gʋ dɩ. -Yee \"wɛan 'i vɩ minnun lɛ 'nan, 'o 'kʋ 'fla -e 'o 'wee -blɩfɛnun 'lɔ, o -blɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «O -kɔlaman o -fo 'gʋ, 'ka 'blɩfɛ -nɔn -wlɛ 'ka 'bɔa!» ");
INSERT INTO yreNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ɛn o 'nan -yrɛ 'nan: «'Kpɔun 'soolu 'lee pɔ 'fiili \"cɛ \"nɛn 'kʋ 'lɔ 'gʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ɛn Zozi \"e 'nan: «'Ka 'ta -a 'mɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","\"Bɛ -sru ɛn yaa 'vɩ minnun \"kaga zɩɛ -wlɛ 'nan, 'o -nyran lu da. E 'kpɔun 'soolu 'lee pɔ \"fli zɩɛ -a 'si, 'e yra -tɔ laji, e Bali muo \"fɔ. \"Bɛ -sru e 'kpɔunnun 'bɔ \"nɛn jɛɛn, ɛn yaa -nɔn 'e -srunɔn lɛ 'nan 'o -pli \"minnun 'bɔ man. ");
INSERT INTO yreNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","O pɛɛnɔn -a blɩ, o 'kan. -A plɔɛn nɛn e -fʋ bɛ, waa tre 'e cin man, e saannɛn -fuda \"fli 'fa. ");
INSERT INTO yreNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Minnun nɛn waa blɩ bɛ, o \"nɛn bɔa -kpi 'soolu, te wa'a nannannun 'lee lɩmɔnnun \"nrɔnlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","\"Bɛ -sru, ɛn e -tɔ 'e -srunɔn man 'nan, 'o 'fɔ -klʋ -ji 'o 'trɔa 'e 'lɛ 'yi -sru. E -fɔla \"da 'nan -e 'e -si -nɔn minnun 'bɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Zɩ minnun -nyan -nan bɛ, e pɔn -tʋ tri ɛn e -kʋ Bali trʋ 'balɛ 'e 'saza. Funninmlan 'pla te e ya fɛ zɩɛ -nan 'e 'tʋwli. ");
INSERT INTO yreNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tʋ zɩɛ -a man bɛ, te -klʋ -sru 'bɔ 'kɔɔbli. 'Pian te -klʋ 'bɔ a 'e yra yɩnan 'yi nɛn e 'blʋ -fɔa \"bɛ -yrɔ, kɔɔ fulɔ \"fɛɛnman o da zia. ");
INSERT INTO yreNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Zɩ tʋ 'cɛn mannɛn 'wɩdɩ 'sia bɛ, ɛn Zozi 'kʋla o -sru 'ta wʋdɩ -a 'yi yiɛ da. ");
INSERT INTO yreNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Zɩ -a -srunɔn -a 'yɩ, te e ya 'ta wʋnan 'yi yiɛ da bɛ, o ci nrɔn 'nan: «Min lei nɛn!» \"Klan o -tɛa \"le \"wɛan o -paandɩ 'sia 'plɛblɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ɛn Zozi \"e -wlɛ 'nan: «'Ka 'fʋ flɩɩ. Maan nɛn, te 'ka \"klan dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ɛn Piɛri \"e 'nan -yrɛ 'nan: «Minsan, -te bii nɛn bɛ, 'yian laabʋ -e 'an 'lʋ 'i 'va 'ta wʋdɩ -a 'yi yiɛ da.» ");
INSERT INTO yreNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ɛn e -yrɛ 'nan: «'I 'ta!» Piɛri 'si -klʋ -ji, ɛn e 'ta wʋladɩ 'sia 'yi 'yiɛ da te e -ko Zozi 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","'Pian zɩ yaa 'yɩ 'nan fulɔ \"fɛɛnman 'plɛblɛ bɛ, \"klan -sɛn \"ji, ɛn e -wladɩ 'sia 'yi 'wlu. -A -nan nɛn e -paandɩ 'sia. E 'nan: «Minsan, 'yian 'sʋ 'yi 'lɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","'Nun tɔɔn Zozi 'e 'pɛ 'sʋ \"ji, yaa 'kun, ɛn e 'nan -yrɛ 'nan: «'Yie yi -tɛradɩ 'an da a \"wɛnnɔn. -Mɛ \"le \"wɛan nɛn 'i 'ci -fɔɔdɩ 'sia?» ");
INSERT INTO yreNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","-A -nan nɛn o -fɔ -klʋ -ji, ɛn fulɔ \"fɛɛndɩ 'le 'tɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tɔɔn ɛn -a -srunɔn 'o \"po sɔɔn \"wlu, waa 'vɩ -yrɛ 'nan: «-A -sa 'ka \"fo \"dɩ, Bali -pɩ nɛn yia.» ");
INSERT INTO yreNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","O 'yi zɩɛ -a cɛɛn 'ji, ɛn o 'bɔla Jenezarɛt 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Minnun nɛn o -nyɛanla fɛ zɩɛ -a -nan bɛ, zɩ o Zozi 'yɩ bɛ, waa -kɔnnɛn 'yɩ. -A -nan nɛn o minnun 'pa 'sia 'o \"srɔn 'flanun da, ɛn minnun -ta -cɛ -tɛnɔn pɛɛnɔn 'a -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɛn o toba -fɔ Zozi lɛ 'nan 'e 'si -nɔn 'wlɛ -e 'o klɛ -yee sɔ 'lɛbo \"tun \"man. Minnun pɛɛnɔn nɛn o -kɔla klɛdɩ -a -yee sɔ 'lɛbo \"man bɛ, -cɛ 'si o man \"fo. ");
INSERT INTO yreNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","\"Bɛ -sru, ɛn Farizɛn 'nɔn -mienun 'lee 'fluba 'ci vɩnɔn -mienun 'si Zeruzalɛm, o -ta Zozi 'va, ɛn waa laabʋ -yrɔ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«-Mɛ \"le \"wɛan nɛn 'i -srunɔn 'ka 'ta 'wʋla -kaa tranun kluda wɩnun da dɩ? \"Wɛɛ fɛnun -blɩ bɛ, wa'a 'o 'pɛ -man foeman \"le zɩ -kaa tranun -a 'vɩ bɛ -yee 'wɩ 'zʋ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Ka 'bɔ \"nun, -mɛ \"le \"wɛan nɛn -kaa tranun kluda wɩ 'tɔ 'ji bɛ, ka'a 'ta 'wʋla Bali -le -pei -tɔ wɩnun da dɩ? ");
INSERT INTO yreNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bali \"e 'nan: ‹'I \"tɩ 'lee 'i \"bʋ \"bɛ, 'i yiɛ 'e 'nan o man.› Ɛn yaa 'vɩ \"nyian 'nan: ‹Min nɛn e wɩɩ -wlidɩ 'e \"tɩ \"lɛ, -te 'bɛ \"cɛɛ dɩ e wɩɩ -wlidɩ 'e \"bʋ \"lɛ bɛ, -a san zɩɛ 'o -tɛ.› ");
INSERT INTO yreNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","'Pian 'ka 'bɔ \"ka \"paaman minnun ji 'nan, min nɛn yaa 'vɩ 'e \"tɩ -te 'bɛ \"cɛɛ dɩ 'e \"bʋ \"lɛ 'nan: ‹\"Lala nɛn 'an 'ci nrɔn 'nan 'an \"paa -a 'ka 'va bɛ, an \"ta -a -nɔan Bali lɛ.› ");
INSERT INTO yreNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","-A san zɩɛ -te -a yiɛ 'ka 'nanlɛ 'e \"tɩ 'lee 'e \"bʋ \"man dɩɛ, ya'a fɛ -tʋ dra dɩ. 'Wɩ zɩɛ yaa -kɔɔnman 'nan, ka Bali wei klu -sran 'ji 'ka tranun kluda wɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wei \"flivli 'nɔn! 'Wɩ nɛn Bali 'lewei vɩzan Ezai -a 'vɩ 'ka man bɛ, 'wɩ 'kpa nɛn. Yaa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Bali \"e 'nan: Minnun 'labɛ, waan 'tɔ \"yi \"ve 'o 'le lou, 'pian o jinun bɛ, o ya 'o 'sidɩ 'an man -kɔɔbli. ");
INSERT INTO yreNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","-Wee 'an 'sudɩ bɛ -a \"nɛn \"ka \"dɩ. Kɔɔ -peinun nɛn blamin a -tɔ bɛ, -a 'bɔ nɛn waa \"paaman minnun ji 'nan -yɛɛ cɩ Bali -le -si -a.› » ");
INSERT INTO yreNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","\"Bɛ -sru ɛn Zozi minnun laabʋ 'e \"srɔn \"kogo, ɛn e 'nan -wlɛ 'nan: «'Ka \"trɔɛn \"tɔ -e 'ka 'wɩ 'gʋɛ -a -ci man 'kpa! ");
INSERT INTO yreNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Fɛ nɛn e \"sia bei -e 'e -wla \"min ji bɛ, ya'a min \"tri 'tɔa Bali 'lɛ dɩ. 'Pian fɛ nɛn e \"sia min ji -e 'e bɔla bei \"bɛ, -yɛɛ min \"tri -tɔa Bali 'lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tɔɔn ɛn -a -srunɔn pli \"man, ɛn o 'nan -yrɛ 'nan: «'Wɩ nɛn yia 'vɩ 'gʋɛ, e wla Farizɛn 'nɔn man. Yia -tɔa zɩ?» ");
INSERT INTO yreNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «Fɛ pɛɛnɔn nɛn 'an \"tɩ \"nɛn laji bɛ, -yɛɛ \"cɛɛ 'wlɛ 'fɔ 'trɛ 'ji dɩɛ, o -taa -a \"sʋʋlɛa. ");
INSERT INTO yreNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","'Ka o 'tʋɩ zɩɛ! Yiɛ 'winɔn nɛn waa, ɛn o ya \"vale 'o -si -kɔɔnman minnun nɛn o yiɛ a 'e 'widɩ bɛ -wlɛ. -Te yiɛ 'wizan -tʋ a -si -kɔɔnnan yiɛ 'wizan -tʋ lɛ bɛ, o \"flinɔn -tɛa \"klu -ji.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ɛn Piɛri -a 'vɩ Zozi lɛ 'nan: «-Kɔnnɛn \"nɛn yia -fɔ 'nan min \"tri -tɔa Bali 'lɛ bɛ, 'i -ci vɩ 'kʋɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ɛn Zozi \"e 'nan -yrɛ 'nan: «'Ka 'bɔ \"nyian, \"ka \"ya wo tian minnun nɛn wa'a 'wɩ 'ci maan dɩɛ waa? ");
INSERT INTO yreNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","-Mɛ drɛ ka'a 'wɩ 'ci maan dɩ? Fɛ pɛɛnɔn nɛn e -wlamlan min 'le bɛ, e -ko min -pɔn -ji, ɛn -a 'bɔ 'a nɛn o -fɔa \"lua. ");
INSERT INTO yreNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","'Pian fɛ pɛɛnɔn nɛn e bɔala min 'le bɛ, e \"sia min souba ji, -yɛɛ min \"tri -tɔa Bali 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kɔɔ min souba ji nɛn ci \"nrɔndɩ -wlidɩ pɛɛnɔn \"sia: min -tɛdɩ a -tʋ, min nan -wɛɛdɩ a -tʋ, min -sran -wɛɛdɩ a -tʋ, nyinnandɩ lɩ 'lee -kɔnnɛn -a te wa'a 'o cin 'palɛ dɩɛ e ya -tʋ, crin wʋdɩ a -tʋ, 'wlu 'sɛndɩ minnun man a -tʋ, 'wɩdɩ min man -wlidɩ \"a -tʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","'Wɩnun zɩɛ -a drɛdɩ 'bɛ min \"tri -tɔa Bali 'lɛ. 'Pian -te min fɛ -blɩ 'e 'pɛ -man \"tri \"a bɛ, ya'a min \"tri 'tɔa Bali 'lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Zozi 'si fɛ zɩɛ -a -nan, ɛn e -kʋ Tir 'lee Sidɔn 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","'Lɛglɔn zɩɛ -a -ji 'nɔn bɛ Zuif 'nɔn \"cɛɛ waa dɩ. -A -nan lɩmɔn -tʋ 'bɛ 'ta Zozi 'lɛ, ɛn e paan -yrɛ. E 'nan -yrɛ 'nan: «Minsan, David kluda min, 'an nyrinda 'e 'sɛn 'i da. -Yʋ -wlidɩ \"a see 'panan 'an 'lu man.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","'Pian Zozi 'ka 'wɩ 'tʋ 'silɛ \"da \"man \"dɩ. Ɛn -a -srunɔn pli \"man, o toba -fɔ Zozi lɛ 'nan: «'I fɛ -tʋ drɛ -e lɩ 'gʋɛ 'e li 'e da, kɔɔ -a -nan 'mɔn te e -paanman -kaa -sru.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Izraɛl 'nɔn 'saza 'va nɛn Bali 'an 'pa 'sia. -Wɛɛ cɩ \"le 'blanun nɛn -si 'san -wlɔ \"bɛ -wee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","'Pian lɩ zɩɛ e -ta 'e \"po sɔɔnla Zozi 'wlu ɛn e -yrɛ 'nan: «Minsan 'i yra 'si, 'i 'pa 'an 'va!» ");
INSERT INTO yreNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Zozi \"e -yrɛ 'nan: «E 'ka 'wɩ \"yi \"a -e min 'e 'yee 'nɛnnun -blɩfɛ 'si 'e -nɔn -plɛnnun lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ɛn lɩ zɩɛ e 'nan: «'Wɩ 'kpa nɛn, Minsan! 'Pian -plɛnnun bɛ, o \"tɩ 'nɛan plɔɛn nɛn e -sɛanla bɛ, -nyrɛn waa -ble.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tɔɔn Zozi \"e -yrɛ 'nan: «'Yie yi -tɛradɩ Bali da a -dan. 'Wɩ nɛn i cɩ \"va \"bɛ 'e 'lɛ sɔɔ 'yiɛ!» Tʋ 'bɔ 'lein zɩɛ -a wlu nɛn -a 'lu beli. ");
INSERT INTO yreNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","\"Bɛ -sru Zozi 'si fɛ zɩɛ -a -nan, ɛn e -kʋ Galile 'yi man. E pɔn -tʋ tri, ɛn e -nyran \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ɛn minnun -tadɩ 'sia \"va \"kaga. O -ta 'o 'lɔ le minnun nɛn o \"tun \"bo bɛ waa, 'lee yiɛ 'winɔn, 'lee minnun nɛn o man mɛn -mie -ka o man bɛ waa, 'lee bobonun, 'lee -cɛ -tɛnɔn \"kaga \"pee \"nyian. O -ta waa ɛn o o -sran -a 'lɛ, ɛn e o pɛɛnɔn beli. ");
INSERT INTO yreNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bobonun wɩɩ, minnun nɛn o man mɛn -mie -ka o man bɛ e drɛ \"plɔnblɔn 'e \"pa 'ji, minnun nɛn o \"tun \"bo bɛ o 'ta 'wʋ, yiɛ 'winɔn fɛnan 'yɩ, zɩ minnun 'wɩ zɩɛ -a -nan 'yɩ bɛ, o 'plo 'fɔ, ɛn o Izraɛl 'nɔn 'le Bali 'tɔ bɔdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Zozi 'e -srunɔn laabʋ, ɛn e 'nan -wlɛ 'nan: «Min \"kaga 'labɛ, o nyrinda -sɛan 'an da, kɔɔ o yi yaaga nɛn 'an \"srɔn 'gʋ, ɛn o -blɩfɛ \"ka \"nyian dɩ. An 'ka \"va 'nan 'an o lia 'o da 'o 'ci le dra -a dɩ, \"tɔgɔ o \"koe 'e 'si 'o da -sia.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","-A -srunɔn \"e -yrɛ 'nan: «Fɛnan nɛn -kaa cɩ 'gʋɛ, min 'ka 'nyɛanla 'nan dɩ. Nyin zia nɛn kʋ -blɩfɛ \"kaga \"ye -e 'kʋ -nɔn min \"kaga zɩɛ -wlɛ o 'kanvɛ -a?» ");
INSERT INTO yreNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ɛn Zozi -a laabʋ -wlɔ 'nan: «-Blɩfɛ \"cɛ \"nɛn 'ka 'lɔ?» Ɛn o -yrɛ 'nan: «'Kpɔun 'sɔravli 'lee pɔnɛn \"wɛnwɛnnɛn -mie nɛn 'kʋ 'lɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tɔɔn Zozi \"e 'nan minnun lɛ 'nan 'o -nyran \"tra. ");
INSERT INTO yreNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","E 'kpɔun 'sɔravli 'lee pɔnɛnnun zɩɛ -a 'si, e Bali muo \"fɔ, ɛn yaa \"nɛn jɛɛn. \"Bɛ -sru yaa -nɔn 'e -srunɔn lɛ, ɛn waa pli minnun man. ");
INSERT INTO yreNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","O pɛɛnɔn -a blɩ, o 'kan. -A plɔɛn nɛn e -fʋ bɛ, waa tre 'e cin man, e saannɛn 'sɔravli 'fa. ");
INSERT INTO yreNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Minnun nɛn waa blɩ bɛ, o \"nɛn bɔa -kpi sinjɛn, te wa'a nannannun 'lee lɩmɔnnun \"nrɔnlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Zɩ Zozi 'si -nɔn minnun lɛ o -kʋ bɛ, ɛn e -fɔ -klʋ -ji, e Magadan 'lɛglɔn 'ji si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farizɛn 'nɔn 'lee Saduze 'nɔn pli Zozi man, ɛn o 'tan \"man 'wɩ 'tʋ laabʋdɩ -a -yrɔ. Waa 'vɩ -yrɛ 'nan, 'e 'lɛbo \"fɔ wɩ -tʋ drɛ laji -e 'o -tɔ 'nan Bali -le 'plɛblɛ a -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ɛn Zozi \"e 'nan -wlɛ 'nan: «-Te funninmlan 'pla te laji a 'tɛndɛn bɛ, kaa ve 'nan, \"trɛ \"bɛ fɛnan -kɔan 'e siadɩ \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ɛn bodrun -te fɛnan a -suglɔɔ bɛ, kaa ve 'nan, cɛɛgʋ laa -fɛan. 'Wɩ nɛn e \"ta dra laji bɛ, kaa -tɔa. 'Pian 'wɩ nɛn 'bɛ cɩ drɛnan 'ka 'bɔ yiɛ man 'gʋɛ, ka'a 'bɛ 'ci maan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","-Naagʋnɔn, ka ya min -wlidɩnun -a, ka cɛɛn Bali man, ɛn ka ya \"va 'nan, 'an 'wɩ 'tʋ drɛ -e 'e -kɔɔn 'nan Bali -le 'plɛblɛ a 'an 'lɔ. 'Pian maan ve 'cɛɛ 'nan, Bali 'ka \"nyian 'wɩ 'nɔan -kɔɔn \"vɛ pee dra 'ka 'va 'gʋ dɩ, -te ya'a 'silɛa 'wɩ nɛn e 'bɔ Bali 'lewei vɩzan Zonazi man bɛ -a dɩɛ.» Ɛn e o 'tʋɩ, e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Te -a -srunɔn \"ta -ko 'yi -sru 'zianun bɛ, o ci 'san 'kpɔun siadɩ man. ");
INSERT INTO yreNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Zɩ o 'bɔla 'nan nun bɛ, ɛn Zozi \"e -wlɛ 'nan: «'Ka yiɛ 'tɔ 'ka 'fli -va 'kpa Farizɛn 'nɔn 'lee Saduze 'nɔn 'le 'mannyan 'le \"wɛan.» ");
INSERT INTO yreNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","-A -srunɔn 'o 'ci nrɔn, ɛn waa 'vɩ 'o cin yei 'nan: «-Ka'a talɛ 'kpɔun -a dɩ, -yee \"wɛan nɛn e 'wɩ zɩɛ -a 'vɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Zozi -a -kɔnnɛn 'yɩ, ɛn e 'nan -wlɛ 'nan: «'Cee yi -tɛradɩ Bali da a \"wɛnnɔn. -Mɛ \"le \"wɛan nɛn 'ka 'ci nrɔn 'nan, ka'a 'talɛ 'kpɔun -a dɩ, -yee \"wɛan nɛn an 'wɩ zɩɛ -a 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","'Wɩ klɔ 'ka 'ka 'ji dʋʋ? -A -cin 'e 'tɔ 'ka 'ji 'nan, an 'kpɔun 'soolu pli min -kpi 'soolu man, waa blɩ o 'kan. -A plɔɛn nɛn e -fʋ bɛ e saannɛn 'fa wɛa? ");
INSERT INTO yreNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ɛn -a cin 'e 'tɔ 'ka 'ji \"nyian 'nan, an 'kpɔun 'sɔravli pli min -kpi sinjɛn man, waa blɩ o 'kan. -A plɔɛn nɛn e -fʋ bɛ e saannɛn 'fa wɛa? ");
INSERT INTO yreNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'Cee 'wɩ 'ci mandɩ a 'plɛblɛ. Ma'an 'kpɔun -le 'wɩ vɩlɛ 'cɛɛ dɩ. 'Pian maan 'vɩ 'cɛɛ 'nan, 'ka yiɛ 'tɔ 'ka 'fli -va Farizɛn 'nɔn 'lee Saduze 'nɔn 'le 'mannyan 'le \"wɛan.» ");
INSERT INTO yreNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ɛn -a -srunɔn -a -ci 'man \"mɛn 'nan, 'mannyan nɛn waa -sɛan 'kpɔun -va bɛ, -yee \"wɛan \"cɛɛ e 'nan 'o yiɛ 'tɔ 'o 'fli -va dɩ. 'Pian Farizɛn 'nɔn 'lee Saduze 'nɔn -le 'wɩ \"paadɩ nɛn yaa ve. ");
INSERT INTO yreNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Zɩ Zozi 'bɔla Sezare Filipʋ 'lɛglɔn 'ji bɛ, ɛn yaa laabʋ 'e -srunɔn 'lɔ 'nan: «'An 'bɔ Blamin -pɩ bɛ minnun \"o 'nan, -tɩ nɛn 'maan?» ");
INSERT INTO yreNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɛn o 'nan -yrɛ 'nan: «Min -mienun \"o 'vɩ 'nan, min -batize drɛzan Zan nɛn e -ka bɛ, -nyrɛn 'yia. Ɛn min plɔɛn \"o 'vɩ 'nan, Bali 'lewei vɩzan Eli nɛn 'li bɛ, -nyrɛn 'yia. Ɛn o -mienun \"o 'vɩ 'nan Bali 'lewei vɩzan Zeremi nɛn 'li bɛ, -nyrɛn 'yia. Ɛn -te 'bɛ \"cɛɛ dɩɛ, Bali 'lewei vɩnɔn nɛn 'li bɛ -a -tʋ 'bɛ fuʋ, -nyrɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ɛn yaa laabʋ 'e -srunɔn 'lɔ 'nan: «Kaa \"nun, \"ka 'vɩ 'nan, -tɩ nɛn 'maan?» ");
INSERT INTO yreNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simɔn Piɛri \"e -yrɛ 'nan: «I ya Crizi nɛn Bali -a 'pa 'sia -e 'e minnun 'si 'wɩ 'ji bɛ -a. Bali nɛn -a yiɛ cɩ \"man \"bɛ -a -pɩ nɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ɛn Zozi \"e 'nan: «Zonas -pɩ Simɔn, 'yie 'wɩ a \"yi. Kɔɔ blamin \"cɛɛ 'wɩ zɩɛ -a -cin -tɔ 'i 'ji dɩ, 'pian 'an \"tɩ \"nɛn laji bɛ -yɛɛ -cin -tɔ 'i 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Maan ve 'yiɛ 'nan, 'i 'tɔ nɛn Piɛri, -a -ci puo. Ɛn puo zɩɛ -a da nɛn an -taa 'mɛn -leglizi -tɔlɛa. Fɛ -tʋ 'ka 'trɛ 'gʋɛ -a da -e 'e -leglizi zɩɛ -a -wi dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Bali -le mingɔnnɛn trɛ bɛ, maan -lagle 'wlɛ -nɔan 'yiɛ. Fɛ oo fɛ nɛn yia ve \"man \"cɛjɛ 'trɛ 'gʋɛ -a da bɛ, te o -cɛjɛ 'vɩ \"man laji. Ɛn fɛ oo fɛ nɛn yia \"kuan 'i 'pɛ \"fli \"a 'trɛ 'gʋɛ -a da bɛ, te waa 'kun o -pɛ \"fli \"a laji.» ");
INSERT INTO yreNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","-A -nan nɛn Zozi 'e -srunɔn \"trɔɛn nyuɔn 'klagla. Yaa 'vɩ -wlɛ 'nan, te 'o -nan sɛɛ wʋ min lɛ 'nan, min nɛn Bali -a 'si \"va -e 'e minnun 'si 'wɩ 'ji bɛ -nyrɛn 'yaa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","-E 'e 'sia tʋ zɩɛ -a man bɛ, -a -nan nɛn 'wɩ nɛn e \"ta -daa \"bɔlɛ Zozi man bɛ yaa vɩdɩ 'sia 'e -srunɔn lɛ. E 'nan -wlɛ 'nan: «An -ko Zeruzalɛm. Min cejenun, 'lee Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn 'tɛ \"kaga \"paa 'an da. Waan -tɛa, -a yi yaagazan da -e 'an 'wluan -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","-A -nan nɛn Piɛri -a laabʋ 'o \"fli yei, ɛn e 'wɩ pladɩ 'sia -yrɛ 'klagla. Yaa 'vɩ -yrɛ 'nan: «Minsan, 'wɩ zɩɛ te 'an man 'i da \"fo \"dɩ, te Bali 'e -si -nɔn dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Zozi 'e yra -tɔ Piɛri da, ɛn e -yrɛ 'nan: «Satan! 'I 'si 'an -sru! Te 'i 'si -tɔ 'an 'lɔ dɩ! 'Wɩ nɛn 'i 'ci \"nrɔnman \"da \"bɛ, -a da \"cɛɛ Bali e ci \"nrɔnman dɩ. Blamin -le ci \"nrɔndɩ nɛn 'i 'wulo -ji.» ");
INSERT INTO yreNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","\"Bɛ -sru ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «Min nɛn e ya \"vale 'e dra 'an -sruzan 'a bɛ, 'e 'wɩ yra yɩdɩ man, ɛn 'e 'wɩ 'kadɩ man yiba \"plan da, -e 'e -sɔɔnla 'an -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kɔɔ min nɛn e cɩ 'e 'ladɩ 'yee 'trɛda da bɛ, ya'a ye dɩ. 'Pian min nɛn 'e 'pɛ 'si 'yee 'trɛda da \"fo ɛn yaa -nɔn 'mɛn bɛ, -a san 'bɛ 'belidɩ nɛn ya'a 'nyaan dɩɛ -a ye. ");
INSERT INTO yreNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ɛn -te min 'trɛda fɛ pɛɛnɔn 'yɩ, te 'belidɩ 'ka -yrɔ \"dɩɛ, -a -ci nɛn 'nɔn? Fɛ -tʋ 'ka 'trɛ 'gʋɛ -a da -e min 'e 'yee 'belidɩ ta pan wʋ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","'Wɩ pɛɛnɔn zɩɛ maan -cin -tɔ 'ka 'ji, kɔɔ tʋ nɛn an -ta pee wo bɛ, 'an 'bɔ Blamin -pɩ, an -taa 'an \"tɩ \"le 'tɛ 'san da 'kʋ 'vale 'mɛn 'pasianɔn nɛn laji bɛ waa. Tʋ zɩɛ -a man nɛn min -tʋ 'e drɛ wɩ man -kopa ye. ");
INSERT INTO yreNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'ka pɛɛnɔn nɛn 'an 'lɛ 'gʋɛ, ka'a 'cɛan -kaadɩ man 'vaa -e 'ka yɩ 'nan, 'an 'bɔ Blamin -pɩ mingɔnnɛn -blɩdɩ 'sia dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yi 'shɛɛdʋ, \"bɛ -sru ɛn Zozi 'kʋ pɔn loulou \"tʋ da 'o 'vale Piɛri 'lee Zaji 'lee 'e \"bʋɩ Zan -a. ");
INSERT INTO yreNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Zozi 'kɔlɛ lila o yiɛ man. -A yra 'bidɩ 'sia \"le yidɛ 'le 'wɩ 'zʋ, ɛn -yee sɔ drɛ 'fuvu 'yrɩyrɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ɛn o Moizi 'lee Eli 'yɩ -a \"srɔn, te o -sɛɛ \"wo 'o 'vale Zozi 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","-A -nan nɛn Piɛri -a 'vɩ Zozi lɛ 'nan: «Minsan, e drɛ 'wɩ \"yi \"a ɛn -kaa ta 'gʋ. -Te 'i wɩɩ \"man \"bɛ, an segle pannɛn yaaga -tɔa. -A -tʋ -kɔan 'yie vɛ, -a -tʋ -kɔan Moizi -le vɛ, ɛn -a -tʋ -kɔan Eli -le vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","E -fʋ 'wɩ zɩɛ -a tin 'banan, ɛn \"lolu -koei \"nɛn e ya 'fuvu 'yrɩyrɩ bɛ, e -trɔa o da. -A -nan nɛn wei -tʋ wɩɩ \"lolu -koei zɩɛ -a va. Yaa 'vɩ 'nan: «Min 'labɛ, e ya 'an 'pɩ nɛn maan ye \"yi \"bɛ -a. E ya 'an 'bli 'pa \"da \"nɛn -a. 'Ka \"trɔɛn \"tɔ -a wei lɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Zɩ -a -srunɔn wei zɩɛ -a 'man bɛ, \"klan -sɛn o ji, o tɛɛla 'o 'kɔlɛnɛn, ɛn 'o yra blula. ");
INSERT INTO yreNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","'Pian Zozi pli o man, e klɛ o man, ɛn e -wlɛ 'nan: «Te 'ka \"klan dɩ! 'Ka 'wluan lou!» ");
INSERT INTO yreNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","-A -nan nɛn 'o 'wulo wluan lou, ɛn o Zozi 'yɩ 'e 'saza. ");
INSERT INTO yreNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Zɩ o ya 'sinan pɔn da -e 'o -sɔɔn \"ji \"bɛ, ɛn e 'wɩ 'pla 'e -srunɔn lɛ. Yaa 'vɩ -wlɛ 'nan: «'Wɩ nɛn ka \"sia -a -nan yɩnan 'gʋɛ, te 'ka -nan sɛɛ wʋ min lɛ dɩ, -trilii -e 'an 'bɔ Blamin -pɩ 'an 'wluan -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","-A -nan nɛn -a -srunɔn 'wɩ laabʋ -yrɔ. Waa laabʋ 'nan: «-Mɛ \"le \"wɛan nɛn 'fluba 'ci vɩnɔn \"o 'nan, Eli 'bɛ -taa 'e 'flin 'vaa -e min 'sizan 'wɩ 'ji 'e 'ta?» ");
INSERT INTO yreNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ɛn Zozi \"e 'nan -wlɛ 'nan: «-Wee tin a 'nɔnnɔn. Eli 'bɛ -taa 'e 'flin, -e 'e fɛnun pɛɛnɔn -tɔɔla 'e \"pa 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","'Pian maan ve 'cɛɛ 'nan, Eli -ta 'va, ɛn wa'a 'silɛa min -a dɩ. 'Wɩ nɛn o cɩ \"va \"bɛ, waa drɛ -yrɛ. 'Wɩ 'tʋwli zɩɛ -yɛɛ bɔa 'an 'bɔ Blamin -pɩ man, 'an yra ye -wlɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","-A -nan nɛn -a -srunɔn -a -ci 'man 'nan, min -batize drɛzan Zan -le 'wɩ nɛn yaa 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Minnun nɛn o cɩ Zozi 'pɛnnan bɛ, Zozi 'lee 'e -srunɔn yaaga 'bɔ o man, ɛn min -tʋ -ta 'e \"po \"sran Zozi 'wlu, ɛn e 'nan -yrɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Minsan, 'an 'pɩ nyrinda 'e 'sɛn 'i da! -Tʋwli \"cɛ a \"man, ɛn e ya 'e yra yɩnan -yrɔ \"wlidɩ. Tʋ -mie man bɛ, yaa -tɛa 'tɛ 'va, ɛn tʋ -mie man bɛ yaa -tɛa 'yi 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","An -ta -a 'i -srunɔn lɛ, wa'a -kɔlalɛ -a 'belidɩ -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Zozi \"e 'nan -wlɛ 'nan: «-Naagʋnɔn, 'cee yi -tɛradɩ Bali da \"ka \"dɩ, ɛn ka 'wɩ 'wlidɩ \"dra. 'An \"koe -nyaan 'ka man 'e \"tun. Tʋ wɛa nɛn maan dra \"nyian 'ka 'va? 'Ka 'ta 'nɛn 'bɔ 'a 'gʋ!» ");
INSERT INTO yreNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ɛn Zozi 'a 'vɩ 'yʋ -wlidɩ zɩɛ -yrɛ 'nan: «'I 'si 'nɛn 'gʋɛ -a -sru.» E 'si -a -sru ɛn 'nɛn zɩɛ e beli 'nun. ");
INSERT INTO yreNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","\"Bɛ -sru, zɩ Zozi 'lee 'e -srunɔn 'fʋ 'o 'saza bɛ, ɛn waa laabʋ -yrɔ 'nan: «-Mɛ \"le \"wɛan nɛn kʋ'a -kɔlalɛ -yʋ -wlidɩ zɩɛ -a -pindɩ -a dɩ?» ");
INSERT INTO yreNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Cee yi -tɛradɩ Bali da a \"wɛnnɔn, -yee \"wɛan ka'a -kɔlalɛ -a drɛdɩ -a dɩ. Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -te 'cee yi -tɛradɩ Bali da a \"wɛnnɔn \"le fei fɛ 'wlɛ \"wɛnnɛn -tʋ -le 'wɩ 'zʋ bɛ, kaa ve pɔn 'labɛ -yrɛ 'nan: ‹'I 'sʋra fɛ 'gʋɛ -a -nan 'i 'trɔa -miɛn›, yaa dra. 'Wɩ 'tʋ 'ka 'kɔan, te ka'a 'kɔlaman -a drɛdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","'Pian -yʋ -wlidɩ zɩɛ, min fɛ \"sɔan, e Bali trʋ \"baa 'vaa ɛn e -kɔlaman -a -pindɩ -a min -sru.» ");
INSERT INTO yreNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yi -tʋ da te Zozi 'lee 'e -srunɔn a ciɩnan Galile 'lɛglɔn 'ji, ɛn Zozi -a 'vɩ -wlɛ 'nan: «'An 'bɔ Blamin -pɩ bɛ, o \"ta -daa 'an -nɔnlɛ minnun lɛ, ");
INSERT INTO yreNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","-e 'waan 'tɛ. -A yi yaagazan da -e 'an 'wluan -kanɔn 'va.» 'Wɩ zɩɛ yaa -srunɔn 'ta drɛ 'trɔdrɔ 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lɛ -tʋdʋ pɛɛnɔn man bɛ Zuif 'nɔn nɛn -klɔnmɔnnun -a bɛ, o \"lala -nɔan Bali -pan 'kɔn 'le vɛ -a. -Yee \"wɛan yi -tʋ da, zɩ Zozi 'lee 'e -srunɔn 'bɔla Kapanamo bɛ, minnun nɛn o \"lala zɩɛ -a \"sia bɛ, o pli Piɛri man, ɛn waa laabʋ -yrɔ 'nan: «\"Lala nɛn minnun -a -nɔan Bali -pan 'kɔn 'le vɛ -a bɛ, 'ka 'san \"e -nɔan?» ");
INSERT INTO yreNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piɛri \"e 'nan: «-Inyan, yaa -nɔan.» \"Bɛ -sru ɛn e wla 'kuin. -A -nan nɛn Zozi 'fɔ 'e 'flin, e 'wɩ 'gʋɛ -a laabʋ -yrɔ. Yaa laabʋ -yrɔ 'nan: «Simɔn, 'i 'ci \"nrɔn 'wɩ 'gʋɛ -a da. Mingɔnnɛnnun nɛn 'trɛ 'gʋɛ -a da bɛ, -tɩnun lɔ nɛn o 'sukɔlɛ \"sia? 'O 'bɔ 'le \"kɔnnɛn 'nɔn 'lɔ nɛn waa \"sia, -baa min peenun lɔ nɛn waa \"sia?» ");
INSERT INTO yreNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ɛn e 'nan Zozi lɛ 'nan: «Min peenun lɔ nɛn waa \"sia.» Zozi \"e 'nan -yrɛ 'nan: «'Wɩ 'kpa nɛn, wa'a sia 'o 'bɔ 'le \"kɔnnɛn 'nɔn 'lɔ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","'Pian -te kʋa drɛ ɛn 'wɩ 'nan o man bɛ, e 'ka \"yi \"dɩ. -Yee \"wɛan 'i 'kʋ 'yi man, 'i -kopa -fɔla 'yia. Pɔ tɛdɛ nɛn e -kopa zɩɛ -a \"siala bɛ 'i -tɛ. 'I yiɛ 'tɔ -a 'le! 'Lein 'wlɛ nɛn -nan bɛ, 'i 'si -e 'i -nɔn -wlɛ 'mɛn vɛ 'lee 'yie vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tʋ zɩɛ -a man nɛn, Zozi -srunɔn pli \"man, ɛn waa laabʋ -yrɔ 'nan: «-Tɩɛ cɩ min -dan a Bali -le mingɔnnɛn trɛda?» ");
INSERT INTO yreNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zozi 'nɛn \"wɛnnɛn 'tɔ laabʋ, yaa -tɔ o yei. ");
INSERT INTO yreNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ɛn e 'nan -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -te ka'a lilɛa -e 'ka 'fli drɛ \"le nannannun -le 'wɩ 'zʋ dɩɛ, ka'a 'ko Bali -le mingɔnnɛn trɛda dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","'Pian min nɛn 'e 'fli drɛ \"wɛnnɔn bɛ, Bali -le mingɔnnɛn trɛda, e ya min -dan a. ");
INSERT INTO yreNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ɛn min oo min nɛn e min nɛn \"le 'nɛn \"wɛnnɛn 'zʋ -gʋ -a 'kun tɩglɩ 'mɛn \"wɛan bɛ, te 'an 'bɔ nɛn yaan 'kun tɩglɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Minnun nɛn o yi -tɛala 'an da \"le nannannun -le 'wɩ 'zʋ bɛ, min oo min nɛn yaa drɛ ɛn -a -tʋwli \"cɛ 'si 'an -sru \"bɛ, -a \"yi mlin -e 'o 'kɔlɛbu -dan -fɔ -a 'klan -e 'o -fɔ jemie -va. ");
INSERT INTO yreNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","'Wɩ -taa \"bɔlɛ 'trɛdanɔn 'gʋɛ o man, kɔɔ -wɛɛ dra -e 'mɛn minnun 'o 'si 'an -sru. 'Wɩnun nɛn waa -maan 'lɔɔ -e min 'e 'si 'an -sru \"bɛ, o ya 'trɛda \"kaga. 'Pian min nɛn yaa drɛ ɛn 'mɛn min -tʋ 'si 'an -sru \"bɛ, 'wɩ -taa \"bɔlɛ -a san man. ");
INSERT INTO yreNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","-Yee \"wɛan maan ve 'cɛɛ 'nan, -te 'i 'pɛ, -te 'bɛ \"cɛɛ dɩ 'i 'cɛin 'bɛ -maan i 'wɩ 'wlidɩ \"dra bɛ, 'i 'cɛn -e 'i tuʋ -kɔɔbli. Kɔɔ -te i -kʋ Bali va 'i 'pɛ ponɛn 'a, -te 'bɛ \"cɛɛ dɩ 'i cɛin ponɛn 'a 'i man bɛ, -a \"yi mlin 'i 'pɛ \"fli 'lee 'i 'cɛin \"fli 'o 'fʋ 'i man -e 'wei 'tuʋ 'tɛ 'va bɛ, -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ɛn -te 'i yiɛ 'bɛ -maan 'i 'wɩ 'wlidɩ \"dra bɛ, 'i 'si \"ji, -e 'i tuʋ -kɔɔbli. Kɔɔ -te i -kʋ Bali va yiɛ 'tʋwli \"a bɛ, 'bɛ \"yi mlin 'i yiɛ \"fli 'o 'fʋ \"ji, -e 'wei 'tuʋ 'tɛ 'va bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","'Ka drɛ \"yi! Minnun nɛn o yi -tɛala 'an da \"le nannannun -le 'wɩ 'zʋ bɛ, te 'ka o drɛ 'ka 'pɛla koda dɩ! Kɔɔ maan ve 'cɛɛ 'nan, Bali -le 'pasianɔn nɛn o yiɛ -tɔa \"minnun zɩɛ o va bɛ o ya bodrun funnin 'o 'tɔdɩ 'an \"tɩ \"nɛn laji bɛ -a 'lɛ. 'Wɩ nɛn e bɔa \"minnun zɩɛ o man bɛ -e 'o -nan 'sinan 'pa -yrɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","«'An 'bɔ Blamin -pɩ an -ta 'nan -e 'an minnun nɛn o 'san bɛ o 'si 'wɩ 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","'Ka 'ci \"nrɔn 'wɩ 'gʋɛ -a da! Min -tʋ -le 'bla a -yaa tʋ, ɛn -a -tʋ 'san \"va. Yaa dra 'kɔ? Maan ve 'cɛɛ 'nan, 'bla -fuba 'sɔrasiɛn 'wlɛ 'sɔrasiɛn bɛ e 'o \"tʋe zɩɛ, -e 'e 'kʋ 'bla -tʋ nɛn e 'san bɛ -a -wɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","-Te yaa 'yɩ bɛ, -a ci \"nranman. Ci \"nran zɩɛ e -ciala 'bla -fuba 'sɔrasiɛn 'wlɛ 'sɔrasiɛn nɛn wa'a 'sanlɛ dɩɛ, -wee ci \"nran nɛn waa -nɔan min lɛ bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","'Ka \"tɩ \"nɛn laji bɛ, 'wɩ 'tʋwli zɩɛ -a 'bɔ nɛn yaa dra. -A ci 'sɔ \"cɛɛ 'nan, minnun nɛn o yi -tɛala 'an da \"le nannannun -le 'wɩ 'zʋ bɛ, o -tʋwli \"cɛ 'e 'san \"va \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","-Te 'i bɔɛzan -tʋ nɛn e ya 'an -sruzan 'a \"le 'yie 'wɩ 'zʋ 'nan e 'wɩ 'wlidɩ drɛ 'yiɛ bɛ, 'i 'kʋ \"va -e 'ka 'nan wɩ vɩ 'ka \"fli yei. -Te yei wei 'man bɛ, te yiɛ drɛ ɛn 'ka yei \"sɛn 'e cin va. ");
INSERT INTO yreNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","'Pian -te e 'ka \"va 'nan 'yei wei maan \"dɩɛ, 'i min -tʋ 'pa 'i 'va, -te 'bɛ \"cɛɛ dɩ 'i min \"fli 'pa 'i 'va, -e 'ka 'kʋ 'wɩ zɩɛ -a -pɛ 'pa 'e cin man o yiɛ man. ");
INSERT INTO yreNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","-Te e 'ka \"vale 'e 'o 'wei maan \"dɩɛ, 'i 'wɩ zɩɛ -a 'pla -leglizinɔn lɛ. Ɛn -te e 'ka \"vale 'e -leglizinɔn wei maan \"dɩɛ, 'i \"bʋɩ zɩɛ -a 'sia 'siɛn \"le min nɛn e 'ka Bali -le 'nɛnnun va dɩɛ, -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, fɛ oo fɛ nɛn kaa ve \"man \"cɛjɛ 'trɛ 'gʋɛ -a da bɛ, te o -cɛjɛ 'vɩ \"man laji. Ɛn fɛ oo fɛ nɛn kaa \"kuan 'ka 'pɛ \"fli \"a 'trɛ 'gʋɛ -a da bɛ, te waa 'kun o -pɛ \"fli \"a laji. ");
INSERT INTO yreNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ɛn maan ve \"nyian 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -te ka ya min \"fli ɛn 'ka 'ci drɛ -tʋwli, ka 'wɩ 'tʋ laabʋ 'an \"tɩ \"nɛn laji bɛ -yrɔ \"bɛ, yaa -nɔan 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kɔɔ -te min \"fli, min yaa 'o cin yɩ 'nan -e 'waan 'tɔ drɛ -dan bɛ, an ya o yei.» ");
INSERT INTO yreNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ɛn Piɛri -a laabʋ -yrɔ 'nan: «Minsan, min nɛn e ya 'i -sruzan 'a \"le 'mɛn 'wɩ 'zʋ bɛ, -te e 'wɩ 'wlidɩ drɛ 'mɛn bɛ, maan \"cɛa -yrɛ 'e 'pa -a wɛa? 'An 'cɛ -yrɛ -trilii 'e 'pa -a 'sɔravli?» ");
INSERT INTO yreNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Zozi \"e -yrɛ 'nan: «Yi'a dra 'e 'pa 'sɔravli \"cɛ \"dɩ, 'pian 'i drɛ -trilii -fuba 'sɔravli 'pa 'sɔravli. ");
INSERT INTO yreNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Fɛ -le \"wɛan nɛn an 'wɩ zɩɛ -a 'vɩ bɛ, -nyrɛn 'gʋ: Bali -le mingɔnnɛn -blɩdɩ min da bɛ, e ya \"le 'nan mingɔnnɛn -tʋ 'bɛ 'vɩ 'e 'wlunɔn lɛ 'nan, 'yee fiɛnnun nɛn o da bɛ, 'o 'ta -e 'e \"nrɔn! ");
INSERT INTO yreNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Zɩ yaa \"nrɔndɩ 'sia bɛ, ɛn o -ta min -tʋ -a -yrɛ. 'Bɛ 'ta fiɛn bɔa -mlinyɔn (1.000.000) \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Min zɩɛ fɛ -tʋ 'ka -yrɔ -e 'e -yee \"lala 'bɔ bɔla dɩ. -A -nan nɛn mingɔnnɛn zɩɛ e 'nan, 'o min 'bɔ 'tan, 'o -a nan 'lee 'yee 'nɛnnɛnnun -tan. Ɛn \"nyian bɛ, o -a yɩfɛ pɛɛnɔn 'tan -e 'o 'yee \"lala -mie bɔla. ");
INSERT INTO yreNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Min zɩɛ e \"po -sɔɔn mingɔnnɛn bɛ -a 'wlu, ɛn e -yrɛ 'nan: ‹'An 'san, 'i yra 'si! 'I tʋ -kɔɔn 'mɛn \"nyian! An 'yie \"lala -wɛɛ \"man -blɛblɛ -e 'an pɛɛnɔn bɔla 'yiɛ.› ");
INSERT INTO yreNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","-A nyrinda -sɛn mingɔnnɛn zɩɛ -a da, ɛn e fiɛn pɛɛnɔn 'bɔ 'cɛ -yrɛ, ɛn e 'si \"man. ");
INSERT INTO yreNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","\"Yɛɛ -kʋ bɛ, min -tʋ nɛn o 'nyranman -tʋwli \"paa 'e cin va bɛ yaa 'yɩ. -Yee \"lala \"wɛnnɛn a 'bɛ 'lɔ fiɛn -ji. Yaa -blɔ man sɔ 'kun, ɛn e 'nan -yrɛ 'nan: ‹'Mɛn \"lala nɛn 'i 'lɔ bɛ, 'i -nɔn 'mɛn!› ");
INSERT INTO yreNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Min zɩɛ e \"po -sɔɔn \"wlu, ɛn e toba -fɔdɩ 'sia, -yrɛ. E 'nan: ‹'I yra 'si! 'I tʋ -kɔɔn 'mɛn! An 'yie \"lala -wɛɛ \"man -blɛblɛ -e 'an pɛɛnɔn bɔla 'yiɛ.› ");
INSERT INTO yreNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","'Pian ya'a 'wɩlɛ \"man \"fo \"dɩ. E -kʋ -a -fɔlɛ -pʋ 'kuin. Min zɩɛ, e 'cɛn -yee \"lala -nɔndɩ man 'vaa ɛn 'e bɔla. ");
INSERT INTO yreNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","-A bɔɛnun -mienun nɛn o 'nyranman \"paa waa 'e cin va bɛ, waa -nan 'yɩ. 'Wɩ zɩɛ e o 'kan ɛn o -kʋ -a 'sinan 'palɛ mingɔnnɛn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","-A -nan nɛn mingɔnnɛn 'e 'suzan zɩɛ -a laabʋ \"nyian, ɛn e 'nan -yrɛ 'nan: ‹'An 'suzan, i ya 'tɛɛ -wlidɩ! I toba -fɔ 'mɛn -yee \"wɛan fiɛn nɛn 'i da bɛ, maan pɛɛnɔn 'cɛ 'yiɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","'I bɔɛzan nyrinda \"sia paan \"le 'mɛin nyrinda 'si bɛ -yee 'wɩ -zʋ!› ");
INSERT INTO yreNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","'Bli 'fɔ mingɔnnɛn zɩɛ -a ji -wlidɩ, ɛn yaa -nɔn minnun lɛ 'nan 'o 'kʋ 'tɛ 'pa \"da -pʋ 'kuin. E cɛɛn -yee \"lala -nɔndɩ man 'vaa ɛn 'e bɔla. ");
INSERT INTO yreNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","-A -tʋwli \"nɛn \"nyian 'cee vɛ -a. -Te ka'a cin man wɩ 'cɛlɛ 'ka 'ci 'fɩdaa 'a dɩɛ, 'an \"tɩ \"nɛn laji bɛ 'wɩ 'tʋwli zɩɛ -nyrɛn yaa dra 'cɛɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Zɩ Zozi cɛɛn 'wɩnun zɩɛ -a \"paadɩ man 'e -srunɔn 'ji bɛ, e 'si Galile, ɛn e -kʋ Zude 'lɛglɔn 'fʋɩ nɛn Zudan 'yi -sru 'zia bɛ -a -ji. ");
INSERT INTO yreNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Min \"kaga \"kʋla -a -sru, ɛn minnun nɛn -cɛ cɩ o man bɛ e o beli. ");
INSERT INTO yreNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","-A -nan nɛn Farizɛn 'nɔn pli \"man. O 'wɩ laabʋ -yrɔ -a wei 'kundɩ -le \"wɛan. Waa laabʋ -yrɔ 'nan: «-Cee -pei -tɔ wɩ -a -si -nɔn 'nan min -kɔlaman 'e nan bɔala 'wɩ pɛɛnɔn 'ji 'e \"tun?» ");
INSERT INTO yreNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Wɩ nɛn e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, ka'a ta vɩlɛ dʋʋ? E ya 'e 'crɛn -tɛdɩ 'nan, 'trɛda pou sianan \"bɛ, Bali -klɔnmɔn drɛ 'o 'vale lɩmɔn -a. ");
INSERT INTO yreNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ɛn Bali -a 'vɩ \"nyian 'nan: ‹-Klɔnmɔn \"sia 'e \"tɩ 'lee 'e \"bʋ \"srɔn, -e 'e lɛa 'e nan man, te o drɛ min -tʋwli \"a.› ");
INSERT INTO yreNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","O 'ka \"nyian \"le min \"fli \"le 'wɩ 'zʋ dɩ, 'pian te o drɛ min -tʋwli \"a. Min \"fli zɩɛ Bali o 'pa 'e cin man. Te min 'e o 'cɛn 'e cin man \"fo \"dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɛn Farizɛn 'nɔn -a laabʋ -yrɔ \"nyian 'nan: «-Mɛ \"le \"wɛan nɛn Moizi -a crɛn -tɛ \"mɛn 'nan, min -kɔlaman 'e nan bɔala, 'pian yaa 'fluba dra -e 'e -nɔn -yrɛ 'vaa -e 'e bɔla?» ");
INSERT INTO yreNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Zozi \"e 'nan -wlɛ 'nan: «'Ka \"trɔɛn \"a \"yuyu, -yee \"wɛan nɛn Moizi -si -nɔn 'cɛɛ 'nan 'ka lɩ bɔla. 'Pian 'trɛda pou sianan \"bɛ, 'wɩ zɩɛ e 'ka -nan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","'An 'bɔ maan ve 'cɛɛ 'nan, min oo min nɛn 'e nan 'bɔla, te -kɔnnɛn -wɛɛdɩ man \"cɛɛ dɩ, ɛn e lɩ pee 'pa bɛ, te e 'wɩ 'wlidɩ drɛ 'e nan 'tʋɩdɩ -a ɛn e lɩ pee wɛɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ɛn -a -srunɔn 'a 'vɩ -yrɛ 'nan: «-Te 'wɩ zɩɛ -yɛɛ cɩ -klɔnmɔn 'lee lɩmɔn yei \"bɛ, \"te e ya 'wɩ \"yi \"a -e min 'e vɩlɛ 'e lɩ 'pa dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Zozi \"e 'nan -wlɛ 'nan: «'Wɩ nɛn an \"sia -a vɩnan 'gʋɛ, min pɛɛnɔn 'ka -a -ci maan dɩ, 'pian minnun nɛn Bali -a -ci 'si -wlɛ \"bɛ, -wɛɛ -ci maan. ");
INSERT INTO yreNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Min -mienun a bɛ, o \"bʋ \"o -ya te o 'ka -klɔnmɔn -a dɩ. Ɛn min -mienun a bɛ, min 'bɛ o \"saa -e 'o 'si -klɔnmɔn -va. Ɛn min -mienun a bɛ, o 'ka \"vale 'o lɩ \"paa dɩ -e 'o Bali -le 'nyranman 'pa 'kpa. Min nɛn e 'wɩ 'ci maan \"bɛ 'e man.» ");
INSERT INTO yreNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Minnun a -tanan nannannun -a Zozi lɛ, -e 'e 'pɛ 'pla o da, -e 'e Bali trʋ 'ba -wlɛ 'nan Bali 'e -fɛa vɩ o man. -A -nan nɛn -a -srunɔn 'si -tɔ -wlɔ 'nan 'o 'li 'o da. ");
INSERT INTO yreNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Ka nannannun 'tʋɩ 'o 'ta 'an 'va, te 'ka 'si -tɔ -wlɔ \"dɩ! Kɔɔ minnun nɛn \"le -wee 'wɩ 'zʋ bɛ, Bali -le mingɔnnɛn trɛ a -wee vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","'E 'pɛ 'pla o da. \"Bɛ -sru ɛn e -kʋ fɛ pee -nan. ");
INSERT INTO yreNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yi -tʋ da bɛ, -gobonɛn 'tʋ pli Zozi man, ɛn e 'wɩ 'gʋɛ -a laabʋ -yrɔ. Yaa laabʋ -yrɔ 'nan: «Bali -le 'wɩ \"paazan! 'Wɩ \"yi \"kɔ \"nɛn maan dra, -e an 'belidɩ nɛn ya'a 'nyaan dɩɛ -a yɩ?» ");
INSERT INTO yreNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Zozi \"e -yrɛ 'nan: «-Mɛ \"le \"wɛan nɛn yia laabo 'an 'lɔ 'nan, 'wɩ \"cɛn 'bɛ cɩ \"yi -e 'i drɛ? Bali -tʋwli 'bɛ cɩ \"yi. -Te i ya \"vale 'i 'belidɩ nɛn ya'a 'nyaan dɩɛ, -a ye bɛ, 'i 'ta wʋla -yee -pei -tɔ wɩnun da.» ");
INSERT INTO yreNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ɛn -gobo zɩɛ yaa laabʋ Zozi 'lɔ 'nan: «-Yee -pei -tɔ wɩnun 'bɔ \"cɛn?» Ɛn Zozi \"e 'nan -yrɛ 'nan: «Te 'i drɛ min -tɛzan -a dɩ! Te 'i min nan -wɛɛ \"dɩ! Te 'i crin wʋ dɩ! Te 'i 'wlu -sɛn min man dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","'I yiɛ 'e 'nan 'i \"tɩ 'lee 'i \"bʋ \"man! Ɛn 'i bɔɛzan -tʋ yɩ \"yi \"le 'yie 'wɩ 'zʋ!» ");
INSERT INTO yreNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","-Gobonɛn bɛ, e 'nan Zozi lɛ 'nan: «'Wɩ pɛɛnɔn zɩɛ -a da nɛn an 'ta wʋla. -Mɛ \"wɩ 'bɛ klɩ 'an man \"nyian?» ");
INSERT INTO yreNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ɛn Zozi \"e 'nan -yrɛ 'nan: «-Te i ya \"vale 'yie 'wɩ 'e 'kɔn tɩglɩ Bali 'lɛ bɛ, 'i 'kʋ, fɛnun nɛn 'i 'lɔ bɛ, 'i -tan, -e 'i man \"lala -pli 'yalɛ -tɛnɔn man. E ya \"le i ya 'i yɩfɛ planan \"laji. \"Bɛ -sru -e 'i -sɔɔnla 'an -sru.» ");
INSERT INTO yreNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Zɩ -gobonɛn 'wɩnun zɩɛ -a 'man bɛ, -a 'ta drɛ -trɔdrɔ, ɛn e -kʋdɩ 'sia. -A yɩfɛnun a \"kaga \"le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ɛn Zozi 'a 'vɩ 'e -srunɔn lɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, fɛzan -le drɛdɩ Bali -le mingɔnnɛn trɛdavɛ -a bɛ, e ya 'plɛblɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ɛn maan ve \"nyian 'cɛɛ 'nan, -wi -dan nɛn waa laabo shamo bɛ, ya'a -kɔlaman -wladɩ -a 'mɛnzrɛn -yrɛ ji dɩ. -A -tʋwli \"nɛn \"nyian fɛnɔn 'le vɛ -a. Drɛdɩ Bali -le mingɔnnɛn trɛdavɛ -a bɛ, e ya -wlɔ 'plɛblɛ 'wlidɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Zɩ -a -srunɔn 'wɩnun zɩɛ -a 'man bɛ, e wla o man -wlidɩ, ɛn waa laabʋ -yrɔ 'nan: «-Te 'bɛ a zɩɛ, -tɩɛ -kɔlaman -e 'e 'si 'wɩ 'ji \"mɛn?» ");
INSERT INTO yreNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Zozi o -nanjɛɛn, ɛn e 'nan -wlɛ 'nan: «Min 'ka 'kɔlaman 'e 'fli 'sidɩ -a 'wɩ 'ji dɩ, 'pian Bali -kɔlaman 'wɩ pɛɛnɔn drɛdɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","-A -nan nɛn Piɛri \"e -yrɛ 'nan: «Kʋ 'si fɛ pɛɛnɔn -sru, ɛn kʋ sɔɔnla 'i -sru. -Mɛ \"nɛn \"kʋ \"ye -ji?» ");
INSERT INTO yreNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ɛn Zozi e 'nan -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, tʋ nɛn fɛnun pɛɛnɔn dra 'e 'trɛ, te 'an 'bɔ Blamin -pɩ an ya 'an -nyrandɩ 'mɛn tin 'ba pɛin -dan da bɛ, kaa nɛn ka 'ta 'wʋla 'an -sru \"bɛ, ka -kɔan 'ka -nyrandɩ \"nyian mingɔnnɛn pɛin -fuda \"fli \"da, ɛn cɛɛ Izraɛl 'lɛglɔn 'fuda \"fli \"le tin \"baa. ");
INSERT INTO yreNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ɛn min oo min nɛn 'mɛn \"wɛan e 'si 'e 'fla, -te 'bɛ \"cɛɛ dɩ e 'si 'e \"bʋɩnun -sru, -te 'bɛ \"cɛɛ dɩ e 'si 'e \"blunun -sru, -te 'bɛ \"cɛɛ dɩ e 'si 'e \"tɩ 'lee 'e \"bʋ -sru, -te 'bɛ \"cɛɛ dɩ e 'si 'e nan 'lee 'yee 'nɛnnun -sru, -te 'bɛ \"cɛɛ dɩ e 'si 'yee -yɔ -sru \"bɛ, -a san zɩɛ yaa pɛɛnɔn zɩɛ -a ye 'e 'pa -a -yaa tʋ. Ɛn 'belidɩ nɛn ya'a 'nyaan dɩɛ, e dra -yee vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Minnun nɛn o -trɔa 'si 'lɛ bɛ, o \"kaga -taa \"fɔlɛa \"da, ɛn minnun nɛn o -fɔla \"da \"bɛ, o \"kaga -taa \"drɛlɛ -si 'lɛnɔn 'a.» ");
INSERT INTO yreNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Zɩ Zozi 'wɩ zɩɛ -a 'vɩ bɛ, ɛn e -kɔnnɛn \"tʋ -fɔ -wlɛ. Yaa 'vɩ -wlɛ 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -nyrɛn 'gʋ, e ya \"le fei san -tʋ 'bɛ 'bɔla bodrun puunɔn ɛn e minnun -wɛɛdɩ 'sia 'nan -e 'o 'kʋ 'nyranman 'pa 'yee rɛzɛn fei. ");
INSERT INTO yreNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","E min -mienun 'yɩ, ɛn o wei drɛ waa -tʋ 'nan yi -tʋ nyranman -pan nɛn 'e -nɔan -wlɛ. Ɛn o -kʋ 'yee fei zɩɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","E 'bɔla \"nyian te bodrun yidɛ wluan loulou 'kpa. Ɛn e min -mienun 'yɩ 'o -nyrandɩ -guada, te 'nyranman 'ka -wlɔ -e 'o 'pa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ɛn \"e 'nan -wlɛ 'nan: ‹'Ka 'kʋ 'nyranman 'pa 'mɛn fei! Maan man -ko \"paa 'cɛɛ.› ");
INSERT INTO yreNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","-A -nan nɛn minnun zɩɛ o -kʋ -yee rɛzɛn fei. Fei san zɩɛ e 'bɔla \"nyian te yidɛ 'bɔ min -win -ji 'sɛzɛ, ɛn e 'bɔla \"nyian te funninmlan yidɛ tɛɛnla. Minnun nɛn e 'bɔ o man bɛ, 'wɩ 'tʋwli zɩɛ -nyrɛn yaa 'vɩ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Zɩ yidɛ 'pla plɔ da bɛ, ɛn e 'bɔla \"nyian, e 'bɔ min -mienun man -guada, ɛn yaa laabʋ -wlɔ 'nan: ‹-Mɛ \"le \"wɛan nɛn ka -fʋ 'ka -nyrandɩ bodrun 'trilii funninmlan, ɛn ka'a 'nyranman 'tʋ 'palɛ dɩ?› ");
INSERT INTO yreNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","O 'nan -yrɛ 'nan: ‹Min -tʋ 'ka 'kʋ 'silɛ 'nan 'kʋ 'yee 'nyranman 'pa dɩ.› Ɛn fei san \"e 'nan -wlɛ 'nan: ‹'Ka 'kʋ 'nyranman 'pa 'mɛn rɛzɛn fei!› ");
INSERT INTO yreNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Zɩ funninmlan 'pla bɛ, ɛn fei san zɩɛ e min nɛn e yiɛ -tɔa 'yee 'nyranman 'panɔn 'va bɛ -a laabʋ. E 'nan -yrɛ 'nan: ‹'I 'nyranman 'panɔn pɛɛnɔn laabʋ -e 'i o -ko 'pa. 'I 'sia minnun nɛn o -fɔla \"da \"bɛ o da -e 'i 'le 'sran minnun nɛn o -trɔa -si 'lɛ bɛ o da.› ");
INSERT INTO yreNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","-A -nan nɛn minnun nɛn o -kʋ 'nyranman 'palɛ te yidɛ 'pla plɔ da bɛ o -ta, ɛn e yi -tʋ nyranman man \"lala -nɔn o pɛɛnɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yaa drɛ zɩɛ -trilii ɛn e 'bɔ minnun nɛn o -trɔa -si 'lɛ bɛ o da. -A -cin a o ji 'nan 'o -kopa -taa 'ciɩlɛa \"da, 'pian yi -tʋ nyranman man \"lala nɛn waa 'yɩ 'o pɛɛnɔn. ");
INSERT INTO yreNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","-A -nan nɛn o 'wɩ 'blɩdɩ 'sia fei san va. ");
INSERT INTO yreNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Waa 'vɩ -yrɛ 'nan: ‹Minnun nɛn o -ta 'e -fɔla \"da 'gʋɛ, wa'a 'mɔnlɛ 'nyranman 'panan \"fo \"dɩ. 'Kʋ 'bɔ nɛn kʋ 'nyranman 'pa yi -tʋ \"fo, ɛn kʋ -fʋ yidɛa \"trilii bɛ, i 'kʋ 'pan 'bɔ waa 'e cin man. -Mɛ \"le \"wɛan yaa drɛ zɩ?› ");
INSERT INTO yreNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ɛn fei san 'wɩ 'si \"va o va min -tʋ lɛ. Yaa 'vɩ -yrɛ 'nan: ‹'An bee! Ma'an 'wɩ 'wlidɩ \"drɛlɛ 'yiɛ dɩ. Yi -tʋ nyranman \"lala da nɛn 'kʋ wei -tria, -njɛɛ dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","-Yɛɛ cɩ 'yie vɛ -a, 'i 'si -e 'i 'kʋ. Min nɛn e -fɔla \"da \"bɛ, -te maan -ko \"paa \"le 'yie 'wɩ 'zʋ oo, e \"siala 'an 'bɔ 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","'Wɩ nɛn e 'sɔ 'an 'ji bɛ, -a 'bɔ nɛn maan dra 'an yɩfɛ -a. -Te an \"yi drɛ min lɛ bɛ, -mɛ drɛ -a 'wɩ \"naan 'i man?› » ");
INSERT INTO yreNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ɛn Zozi 'a 'le 'sran -wlɛ 'nan: «Minnun nɛn o -fɔla \"da \"bɛ, zɩ o -taa \"drɛlɛ -si 'lɛnɔn 'a zɩɛ, ɛn minnun nɛn o -trɔa -si 'lɛ bɛ, zɩ o -taa \"fɔlɛa \"da zɩɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Zozi 'lee 'e -srunɔn a -kʋnan Zeruzalɛm. -A -nan nɛn Zozi 'e -srunɔn 'fuda \"fli laabʋ 'o 'saza, ɛn e 'nan -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«-Kaa \"ta -ko Zeruzalɛm 'gʋɛ, minnun 'an 'bɔ Blamin -pɩ -nɔan Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn lɛ. O tin -tɛa 'an da -e 'an 'ka -a 'wɩ 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Waan -nɔan \"minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ -wlɛ. Minnun zɩɛ waan sɛɛ wo, waan -sɔan -ngble -a, ɛn waan -pɛinman yiba \"plan da -e 'an 'ka. 'Pian -a yi yaagazan da bɛ, -e 'an 'wluan -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","\"Bɛ -sru ɛn Zebede nan pli Zozi man 'o 'vale -yee 'nɛnnun -a. E \"po sɔɔn Zozi 'wlu 'nan -e 'e 'wɩ 'tʋ -si laabʋ -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ɛn Zozi 'a laabʋ -yrɔ 'nan: «-Mɛ 'va nɛn i cɩ?» Lɩ zɩɛ e 'nan Zozi lɛ 'nan: «'Mɛn 'nɛnnun \"fli 'gʋɛ, tʋ nɛn i dra mingɔnnɛn -a bɛ, 'i 'wɩ \"man -e 'o -nyran 'i \"srɔn. -A -tʋ 'e -nyran 'i 'pɛ \"yi \"da, -e -a -tʋ 'e -nyran 'i 'pɛ bʋ da.» ");
INSERT INTO yreNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Wɩ nɛn ka cɩ -a laabʋnan bɛ, ka'a 'ci tɔa dɩ. 'Wɩ yɩdɩ nɛn e \"ta -daa \"bɔlɛ 'an man bɛ, 'ka 'wulo \"sɔa \"wlu?» Ɛn -yee 'nɛnnun 'bɔ -a 'vɩ -yrɛ 'nan: «-Inyan, 'kʋ 'wulo \"sɔa \"wlu.» ");
INSERT INTO yreNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Zozi \"e 'nan -wlɛ 'nan: «'Wɩ 'kpa nɛn, 'wɩ nɛn e \"ta -daa \"bɔlɛ 'an man 'gʋɛ e bɔa \"nyian \"cee \"man. 'Pian -nyrandɩ 'an 'pɛ \"yi 'lee 'an 'pɛ bʋ da bɛ, 'an 'bɔ \"cɛɛ -si -nɔan \"min lɛ dɩ. Minnun nɛn 'an \"tɩ -a pla o 'tɔ man bɛ -wee vɛ 'bɛ cɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Zozi -srunɔn 'fu nɛn o -fʋ bɛ, zɩ o 'wɩ zɩɛ -a 'man bɛ, ɛn 'bli 'fɔ o ji Zan 'lee 'e \"bʋɩ Zaji man. ");
INSERT INTO yreNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","-A -nan nɛn Zozi o pɛɛnɔn laabʋ, ɛn e 'nan -wlɛ 'nan: «Kaa -tɔa 'nan, 'trɛda mingɔnnɛnnun min \"paala -sa wɩ -a. Ɛn minnun nɛn o cɩ min -dandannun -a bɛ, o -va -ble minnun da. ");
INSERT INTO yreNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","'Pian te 'wɩ zɩɛ -nyrɛn 'e 'kɔn 'ka yei \"dɩ. Min oo min nɛn e ya \"vale 'e dra min -dan a 'ka yei \"bɛ, 'e 'fli 'pla 'ka pɛɛnɔn 'wlu o 'sudɩ -a! ");
INSERT INTO yreNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ɛn min oo min nɛn e ya \"vale 'e dra 'ka 'tazan -a bɛ, 'e 'fli drɛ 'ka pɛɛnɔn 'le nɔan -a! ");
INSERT INTO yreNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","'Wɩ 'tʋwli zɩɛ -a 'bɔ nɛn an 'bɔ Blamin -pɩ maan drɛ. Ma'an 'talɛ 'nan -e minnun 'waan 'su dɩ, 'pian an -ta 'nan -e 'an minnun 'su. Ɛn an -ta 'nan -e 'an 'ka -e min \"kaga 'o 'sʋ Satan -le 'plɛblɛ 'lɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Zɩ Zozi 'lee 'e -srunɔn 'si Zeriko bɛ, min \"kaga 'kpa sɔɔnla o -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yiɛ 'winɔn \"fli \"a 'o -nyrandɩ -si man, waa 'man 'nan Zozi a ciɩnan, ɛn o -paandɩ 'sia. O paan 'nan: «Minsan, David kluda min, 'kʋ nyrinda 'e 'sɛn 'i da!» ");
INSERT INTO yreNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɛn minnun paan o da 'nan 'o 'lɛbo 'pla da. 'Pian yiɛ 'winɔn zɩɛ o paan \"nyian 'plɛblɛ 'kpa. O paan 'nan: «Minsan, David kluda min, 'kʋ nyrinda 'e 'sɛn 'i da!» ");
INSERT INTO yreNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Zozi 'tɔ, e o laabʋ, ɛn e 'nan -wlɛ 'nan: «Ka ya \"vale 'an drɛ 'cɛɛ 'kɔ?» ");
INSERT INTO yreNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","O 'nan -yrɛ 'nan: «Minsan, kʋ ya \"vale 'i 'kʋ yiɛ 'lɛ 'sʋ!» ");
INSERT INTO yreNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","O nyrinda -sɛn Zozi da, -a -nan nɛn 'e 'pɛ klɛ o yiɛ man, 'nun tɔɔn o yiɛ 'lɛ 'sʋ, ɛn o sɔɔnla -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Zozi 'lee 'e -srunɔn a -plinan Zeruzalɛm. O 'bɔ 'fla nɛn waa laabo Befaze bɛ -a \"srɔn. 'Fla zɩɛ e ya Olivie pɔn man. Ɛn Zozi 'e -srunɔn \"fli 'pa 'sia 'o 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Yaa 'vɩ -wlɛ 'nan: «'Ka 'kʋ 'fla nɛn 'ka 'lɛ bɛ -a da! -Te 'ka 'bɔla 'nan nun bɛ, ka -aflumun \"bʋ \"tʋ 'lee -yee 'nɛn ye 'o 'baa -tɔdɩ. 'Ka o baa 'sʋ -e 'ka 'ta waa 'mɛn! ");
INSERT INTO yreNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","-Te min -tʋ 'wɩ laabʋ 'ka 'lɔ bɛ, 'ka vɩ -a san lɛ 'nan: ‹Minsan \"e 'nan -aflumun 'wɩ a 'e man.› 'Nun tɔɔn 'e 'pɛ sia \"da -e 'ka 'ta -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","'Wɩ pɛɛnɔn zɩɛ, e drɛ 'wɩ nɛn Bali 'lewei vɩzan -a 'vɩ 'e 'cɛn bɛ -a 'lɛ sɔɔdɩ -a. Kɔɔ yaa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«'Ka vɩ Zeruzalɛm 'nɔn lɛ 'nan: \"Ka 'yiɔ, 'cee mingɔnnɛn a -tanan 'ka 'va! E -taala 'e man -trɔɔ. E ya 'e -nyrandɩ -aflumun da. -Aflumun nɛn e -trɔ \"siala bɛ, -a 'nɛn da nɛn e ya 'e -nyrandɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Zozi -srunɔn \"fli zɩɛ o 'kʋ, ɛn 'wɩ nɛn yaa 'vɩ -wlɛ \"bɛ waa drɛla \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","O -ta -aflumun \"bʋ 'lee -yee 'nɛn 'a, o 'wee sɔnun -sɛn \"da, ɛn Zozi -nyran \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Minnun \"kaga 'wee sɔnun paala -a 'lɛ. Ɛn min -mienun yiba \"pɛnɛnnun cɛɛn, ɛn waa 'pla -a 'lɛ. Zɩ \"o min -dan \"siala zɩɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Min \"kaga yra -a 'lɛ, ɛn min \"kaga -fɔla \"da -a koda, te o pɛɛnɔn plaman 'e cin va. Waa ve 'nan: «-Fɛavɛa o! -Fɛavɛa o! David kluda min -le -fɛavɛa o! Bali -le -fɛa 'e 'kɔn min nɛn Minsan -a 'pa 'sia bɛ -a man. Bali 'tɔ 'e drɛ -dan laji lou!» ");
INSERT INTO yreNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Zɩ e 'bɔla Zeruzalɛm bɛ, -wee pladɩ Zeruzalɛm 'si \"fo, ɛn 'flanɔn pɛɛnɔn 'man nyɔɔn -a laabʋdɩ -a 'nan: «-Tɩ nɛn min 'bɔ 'labɛ -a?» ");
INSERT INTO yreNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Minnun \"kaga \"nɛn waa si -fɔ bɛ, o 'nan: «Zozi nɛn! Bali 'lewei vɩzan nɛn, e \"sia Nazarɛtɩ Galile 'lɛglɔn 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","\"Bɛ -sru ɛn Zozi 'kʋ Bali -pan 'kuin. Minnun nɛn o ya Bali -pan fɛnun -tannan 'lee minnun nɛn o ya -a 'lɔnan Bali -pan 'kuin bɛ, e o -pin. E \"lala ta -fɔɔnɔn 'le 'tablonun 'lee -plablo -tannɔn 'le pɛinnun fuila \"man. ");
INSERT INTO yreNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ɛn e 'nan -wlɛ 'nan: «E ya e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan, Bali \"e 'nan: ‹'Mɛn 'kɔn -kɔan 'an trʋ 'ba 'kɔn 'a.› 'Pian kaa drɛ 'cee crin wʋnan -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","\"Bɛ -sru ɛn yiɛ 'winɔn 'lee minnun nɛn o \"tun \"bo bɛ, o pli Zozi man Bali -pan 'kuin, ɛn e o beli. ");
INSERT INTO yreNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn 'wɩ -dandan nɛn Zozi cɩ -a drɛnan bɛ -a -nan 'yɩ. Ɛn o nannannun 'yɩ \"nyian te o plaman Bali -pan 'kuin -a vɩdɩ -a 'nan: «Bali David kluda min 'tɔ drɛ -dan!» -A 'wɩ 'nan o man, ");
INSERT INTO yreNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ɛn o 'wɩ 'pla Zozi lɛ. Waa 'vɩ -yrɛ 'nan: «'Wɩ nɛn o cɩ -a vɩnan 'labɛ, yi'a maan dʋʋ?» Ɛn Zozi \"e 'nan -wlɛ 'nan: «Maan maan. -Mɛ \"le \"wɛan nɛn ka 'wɩ zɩɛ -a laabʋ 'an 'lɔ? 'Wɩ nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ ka'a tian -a ta vɩlɛ dʋʋ? Kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan: ‹Yia drɛ ɛn nannannun 'lee 'nyɔnmlin 'nɛnnun 'i 'tɔ \"yi 'vɩ.› » ");
INSERT INTO yreNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","-A -nan nɛn e o 'tʋɩ, ɛn e 'si Zeruzalɛm. E -kʋ 'fla nɛn waa laabo Betani bɛ -a da, e 'nyin 'nan nun. ");
INSERT INTO yreNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tʋ cɛɛn bodrun ɛn Zozi Zeruzalɛm si 'sia \"nyian. \"Yɛɛ -kɔn -kʋnan 'sia bɛ, -a -nan nɛn dra -a -tɛdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","E fijie yiba 'yɩ 'si man, ɛn e pli \"man 'nan -e 'e 'blʋ -mie 'cɛn 'e -blɩ. 'Pian -a 'la 'saza nɛn yaa 'yɩ \"da, ɛn e 'nan fijie yiba zɩɛ -yrɛ 'nan: «Te 'i 'blʋ -tʋwli 'e ba 'i man 'li \"fo \"dɩ!» 'Nun tɔɔn fijie yiba 'bɔ 'ka. ");
INSERT INTO yreNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Zɩ -a -srunɔn 'wɩ zɩɛ -a -nan 'yɩ bɛ, o 'lɛbo \"fɔ, ɛn o 'nan -yrɛ 'nan: «E drɛ 'kɔ, ɛn fijie yiba \"ka 'nun zɩɛ?» ");
INSERT INTO yreNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Zozi \"e 'nan -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -te ka yi -tɛala Bali da bɛ, ɛn \"nyian -te ka'a 'ci -fɔɔman dɩɛ, 'wɩ nɛn maan drɛ fijie yiba 'labɛ -yrɛ \"bɛ, 'ka 'pɛ \"sɔa -a drɛdɩ -a. Ɛn \"nyian -te kaa 'vɩ pɔn 'labɛ -yrɛ 'nan: ‹'I 'sʋra 'gʋ, 'i 'kʋ -trɔa jemie -va bɛ›, yaa dra. ");
INSERT INTO yreNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","-Te ka yi -tɛala Bali da, ɛn ka fɛ -tʋ laabʋ -yrɔ -a trʋ 'badɩ -a bɛ, kaa ye.» ");
INSERT INTO yreNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","\"Bɛ -sru ɛn Zozi 'kʋ Bali -pan 'kuin, e 'wɩ \"paadɩ 'sia minnun -ji. -A -nan nɛn Bali -pannɔn 'tanɔn 'lee min cejenun -ta, ɛn waa laabʋ -yrɔ 'nan: «-Kɔladɩ \"cɛn \"a nɛn i 'wɩnun zɩɛ -a drɛ? Ɛn -tɩɛ -si -nɔn 'yiɛ?» ");
INSERT INTO yreNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Zozi \"e 'nan -wlɛ 'nan: «An 'bɔ \"nyian an \"ta 'wɩ 'tʋwli \"cɛ laabo 'ka 'lɔ. -Te kaa -sru 'vɩ 'mɛn bɛ, -kɔladɩ nɛn an 'wɩnun zɩɛ -a drɛ 'a bɛ, maan -ci \"sia 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","-Tɩɛ Zan 'pa 'sia 'nan 'e 'ta min -batize drɛ? Minnun 'bɛ 'pa 'sia, -baa Bali 'bɛ 'pa 'sia? 'Ka vɩ 'mɛn!» -A -nan nɛn waa vɩdɩ 'sia 'o cin yei 'nan: «-Te -kaa 'vɩ 'nan: ‹Bali 'bɛ 'pa 'sia bɛ›, e -taa -a laabʋlɛ -kaa 'lɔ 'nan: ‹-Mɛ \"le \"wɛan nɛn ka'a yi -tɛala 'wɩ nɛn Zan -a 'vɩ bɛ -a da dɩ?› ");
INSERT INTO yreNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ɛn -te -kaa 'vɩ 'nan: ‹Minnun 'bɛ 'pa 'sia bɛ›, minnun pɛɛnɔn -taa 'wunlɛa -kaa man, kɔɔ o pɛɛnɔn Zan \"siala Bali 'lewei vɩzan -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","-A -nan nɛn waa 'vɩ Zozi lɛ 'nan: «Kʋ'a san -tɔa dɩ.» Ɛn Zozi \"e 'vɩ \"nyian -wlɛ 'nan: «An 'bɔ \"nyian min nɛn e -si -nɔn 'mɛn ɛn an 'wɩnun zɩɛ -a drɛ bɛ, ma'an -ci sia 'cɛɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«'Ka 'ci \"nrɔn 'wɩ 'gʋɛ -a da! Min -tʋ a, ɛn 'yee 'nɛn 'klɔnmɔnnun a 'fiili. Yi -tʋ da bɛ yaa 'vɩ -a ceje 'nɛnzan lɛ 'nan: ‹'Mɛn 'nɛn 'i 'kʋ 'nyranman 'pa cɛɛgʋ 'mɛn rɛzɛn fei.› ");
INSERT INTO yreNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","-Yee 'nɛn zɩɛ e 'nan -yrɛ 'nan: ‹Ma'an 'ko dɩ›. 'Pian \"bɛ -sru -a ci lila, ɛn e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","'Wɩ 'tʋwli zɩɛ yaa 'vɩ \"nyian 'yee 'nɛn 'fɔla \"dazan lɛ. 'Nɛn zɩɛ e wɩɩ \"man. Yaa 'vɩ 'e \"tɩ \"lɛ 'nan: ‹'An \"tɩ, maan 'man›, 'pian \"bɛ -sru ya'a 'kʋlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","'Nɛnnun \"fli zɩɛ o yei \"bɛ, -tɩɛ 'e \"tɩ \"ci 'sɔ wɩ drɛ?» Minnun tanɔn nɛn o cɩ 'wɩ zɩɛ -a mannan bɛ, o -yrɛ 'nan: «'Nɛn ceje 'nɛnzan nɛn.» Ɛn Zozi \"e 'nan -wlɛ \"nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'sukɔlɛ 'sinɔn 'lee -kɔnnɛn -wɛɛnɔn -tɔala 'ka 'lɛ -wladɩ -a Bali -le mingɔnnɛn trɛda. ");
INSERT INTO yreNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Zan -ta -si tɩglɩ -kɔɔnlɛ 'cɛɛ, ɛn ka'a yi -tɛlɛa 'wɩ nɛn yaa 'vɩ bɛ -a da dɩ. 'Pian 'sukɔlɛ 'sinɔn 'lee -kɔnnɛn -wɛɛnɔn yi -tɛra \"da. 'Wɩ zɩɛ kaa -nan 'yɩ, 'pian ka'a 'wɩlɛ \"man -e 'ka yi -tɛra 'wɩ nɛn Zan -a 'vɩ bɛ -a da, -e 'ka 'si 'wɩ 'wlidɩ \"drɛdɩ man dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«'Ka \"trɔɛn \"tɔ -kɔnnɛn \"pee lɛ: Min -tʋ 'bɛ 'yee rɛzɛn fei 'pa, e -klɔn 'bʋ \"man, e rɛzɛn 'blʋnan drɛ, ɛn e fɛ -tʋ drɛ, min -tɔa \"da -e 'e fei 'bɔ 'ta -pin. \"Bɛ -sru e fei zɩɛ -a -pɛba 'wʋ minnun lɔ 'nan 'o 'nyranman 'pa \"da, te o 'yee vɛ -nɔan. Yaa drɛ zɩɛ, ɛn e -kʋ 'lɛglɔn 'kɔɔbli 'tʋ da. ");
INSERT INTO yreNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Zɩ rɛzɛn nan tʋ 'bɔ bɛ, ɛn min zɩɛ 'e 'sunɔn 'pa 'sia minnun nɛn o 'nyranman \"paa 'yee rɛzɛn fei bɛ o va, 'nan 'nyranman nɛn waa 'pa bɛ 'o 'yee vɛ -nɔn. ");
INSERT INTO yreNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Fei 'panɔn zɩɛ waa 'sunɔn 'bɔ kuun. Waa -tʋ -sɔn, waa -tʋ -tɛ, ɛn waa yaagazan -tɛ -kɔlɛnun -a. ");
INSERT INTO yreNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Fei san zɩɛ e 'sunɔn 'pa 'sia \"nyian. O \"kaga \"mlian minnun nɛn o -kʋ 'e tɛdɛ bɛ o da. 'Wɩ 'tʋwli zɩɛ -a 'bɔ nɛn fei 'panɔn -a drɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","\"Bɛ -sru ɛn 'e 'pɩ 'pa 'sia o va. 'E 'ci nrɔn 'nan, o yiɛ -taa 'nanlɛ 'e 'pɩ man. ");
INSERT INTO yreNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","'Pian zɩ fei 'panɔn -yee 'nɛn zɩɛ -a 'yɩ bɛ, ɛn waa 'vɩ 'o cin yei 'nan: ‹Min 'labɛ -yɛɛ 'e \"tɩ -zia -ble. -Kaa -tɛ, -e -zia zɩɛ 'e drɛ -cee vɛ -a.› ");
INSERT INTO yreNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","-A -nan nɛn waa 'kun, o ciɩ 'a -klɔn -sru, ɛn waa -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Maan laabo 'ka 'lɔ 'nan, -te fei san zɩɛ e -ta bɛ, yaa dra 'yee fei 'panɔn lɛ 'kɔ?» ");
INSERT INTO yreNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɛn minnun tanɔn nɛn o cɩ 'wɩ zɩɛ -a mannan bɛ, o 'nan -yrɛ 'nan: «Min -wlidɩnun zɩɛ, e o -tɛɛman \"le 'nan plɔannɔn 'le 'wɩ 'zʋ. \"Bɛ -sru -e 'e 'yee fei -pɛba wʋ min peenun lɔ. Yaa -pɛba wo minnun nɛn -te o 'nyranman 'pa, o -yee vɛ -nɔan 'e tʋ man bɛ -wlɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ɛn Zozi -a 'le 'sran -wlɛ 'nan: «'Wɩ nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, ka'a ta vɩlɛ dʋʋ? Kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan: ‹-Kɔlɛ nɛn 'kɔn 'tɔnɔn -a tuʋ 'o 'pɛla koda bɛ, -yɛɛ drɛ 'kɔn 'pʋ -fɔ -kɔlɛ -a. Minsan 'bɛ drɛ, ɛn -kɔlɛ zɩɛ 'e drɛ 'kɔn 'pʋ -fɔ -kɔlɛ -a. 'Wɩ nɛn Minsan -a drɛ bɛ, e min 'plo -fɔa.› ");
INSERT INTO yreNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Maan 'nan 'an ve 'cɛɛ 'nan, mingɔnnɛn -blɩdɩ Bali va bɛ Bali -taa -a 'silɛ 'ka 'lɔ. Yaa -nɔan 'lɛglɔn 'pee -ji 'nɔn nɛn, o 'ta 'wʋla -a wei da bɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kɔɔ e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji \"nyian 'nan: ‹Min nɛn e -tria -kɔlɛ zɩɛ -a da bɛ, e -wia. Ɛn -te -kɔlɛ zɩɛ e -tria min da bɛ, yaa pɔlɛ \"bo.› » ");
INSERT INTO yreNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Zɩ Bali -pannɔn 'tanɔn 'lee Farizɛn 'nɔn -kɔnnɛnnun zɩɛ -a 'man bɛ, waa -tɔ 'nan 'wee 'wɩ nɛn Zozi -a ve. ");
INSERT INTO yreNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɛn o ya \"vale 'nan 'o \"kuan. 'Pian minnun -le \"wɛan \"klan a o ji, kɔɔ minnun zɩɛ o Zozi \"siala Bali 'lewei vɩzan -a. ");
INSERT INTO yreNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","\"Bɛ -sru ɛn Zozi -kɔnnɛn pee -fɔ \"nyian -wlɛ. Yaa 'vɩ -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -nyrɛn 'gʋ. E ya \"le mingɔnnɛn -tʋ 'bɛ \"ta 'e 'pɩ -le lɩ 'pa \"fɛdi dra. ");
INSERT INTO yreNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Minnun nɛn e \"fɛdi zɩɛ -a 'wɩ 'vɩ -wlɛ \"bɛ, e 'e 'sunɔn 'pa 'sia 'nan 'o 'kʋ o laabʋ. 'Pian wa'a 'wɩlɛ \"man -e 'o -ta \"fɛdi da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ɛn e 'e 'sunɔn 'pee 'pa 'sia \"nyian. E 'nan -wlɛ 'nan, 'o vɩ minnun zɩɛ -wlɛ 'nan: ‹An cɛɛn -a drɛdɩ man. An trinun tɛɛ, ɛn an 'blanun tɛɛ. -A pɛɛnɔn 'man, -yee \"wɛan 'ka 'ta \"fɛdi da!› ");
INSERT INTO yreNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","'Pian o 'wɩ zɩɛ -a -fɔla 'o \"trɔɛn -sru. O -mie -kʋ 'wee fei, ɛn o -mie -kʋ 'wee 'flɛ 'tanlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ɛn o -mienun -a 'sunɔn 'bɔ kuun, o o -sɔn, ɛn o o tɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","'Bli 'fɔ mingɔnnɛn zɩɛ a ji -wlidɩ. E 'yee 'sounjanun 'pa 'sia 'nan 'o min -tɛnɔn zɩɛ o -tɛɛ, ɛn 'o -wee 'fla 'tɛ 'blɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","\"Bɛ -sru ɛn e 'nan 'e 'sunɔn lɛ 'nan: ‹An cɛɛn lɩ 'pa \"fɛdi fɛnun drɛdɩ man. 'Pian minnun nɛn maan 'vɩ -wlɛ \"bɛ, o 'ka \"fɛdi zɩɛ -a da 'nɔn 'a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","-Yee \"wɛan 'ka 'kʋ -si -plannun da. Minnun pɛɛnɔn nɛn ka bɔa \"o man bɛ, 'ka vɩ -wlɛ 'nan 'o 'ta lɩ 'pa \"fɛdi da.› ");
INSERT INTO yreNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mingɔnnɛn 'sunɔn zɩɛ waa drɛla \"da. Minnun pɛɛnɔn nɛn o 'bɔ o man bɛ, o -ta waa. Min -wlidɩ oo, min \"yi oo, o pɛɛnɔn 'ta, ɛn o 'kɔn zɩɛ -a -ci 'fa. ");
INSERT INTO yreNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mingɔnnɛn wlala o va 'nan -e 'e minnun nɛn o -ta \"fɛdi da bɛ o yɩ. E min -tʋ 'yɩ o yei te lɩ 'pa \"fɛdi da sɔ 'ka \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ɛn e 'nan -yrɛ 'nan: ‹'An bee, lɩ 'pa \"fɛdi da sɔ 'ka 'i da dɩ. E drɛ 'kɔ, ɛn i ya 'gʋ?› Min zɩɛ ya'a -kɔlalɛ 'wɩ 'tʋ 'sidɩ -a \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","-A -nan nɛn mingɔnnɛn -a 'vɩ 'e 'sunɔn lɛ 'nan: ‹'Ka min 'labɛ -a 'kun, 'ka cɛin 'lee -a -pɛ -yrɩ, -e 'ka tuʋ klun va bei, fɛnan nɛn -wuɔdɩ 'lee 'shɛ da -blɩdɩ cɩ bɛ -a -nan.› » ");
INSERT INTO yreNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ɛn Zozi -a 'le 'sran -wlɛ 'nan: «Minnun nɛn Bali o laabʋ bɛ, o ya \"kaga. 'Pian minnun nɛn Bali o \"sia \"va 'yee vɛ -a bɛ, o ya \"wɛnnɔn.» ");
INSERT INTO yreNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","\"Bɛ -sru ɛn Farizɛn 'nɔn 'kʋ 'o cin yɩlɛ. Waa 'pla \"da 'nan 'o Zozi 'kun 'e wei man. ");
INSERT INTO yreNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","-A -nan nɛn o 'wee minnun 'lee Erodi -le minnun 'pa 'sia 'nan 'o 'wɩ laabʋ Zozi 'lɔ. Waa laabʋ -yrɔ 'nan: «Bali -le 'wɩ \"paazan, kʋa -tɔa 'nan i ya 'wɩ tɩglɩ vɩzan -a, ɛn i Bali -sru 'ta wʋdɩ \"paaman minnun ji 'e tɩglɩ da. Yi'a 'klanman min lɔ 'wɩ tɩglɩ 'ci 'sidɩ -a -yrɛ dɩ. Ɛn yi'a min bo \"va \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","-Yee \"wɛan kʋa laabo 'i 'lɔ 'nan: ‹-A -si a -kaa 'lɔ -e -kaa 'sukɔlɛ -pan wʋ Rɔm 'nɔn 'le mingɔnnɛn Seza lɛ, -baa te -ka'a drɛ dɩ? 'Wɩ nɛn \"yie 'ji bɛ, 'i vɩ 'kʋɛ!› » ");
INSERT INTO yreNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","'Pian 'wɩ nɛn -a -cin cɩ o ji bɛ Zozi -a -kɔnnɛn 'yɩ. Ɛn e 'nan -wlɛ 'nan: «Wei \"flivli 'nɔn! Ka ya 'an 'man -wɛɛnan -wlidɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","\"Lala nɛn ka 'sukɔlɛ -pan wo -a bɛ, 'ka 'lein 'wlɛ -tʋ 'si \"va -e 'ka -kɔɔn 'mɛn!» -A -nan nɛn o 'lein 'wlɛ -tʋ kɔɔn -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ɛn Zozi -a laabʋ -wlɔ 'nan: «-Tɩ -wulo -fodo nɛn 'gʋ? Ɛn -tɩ 'tɔ 'crɛn nɛn 'gʋ?» ");
INSERT INTO yreNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","O 'nan -yrɛ 'nan: «Rɔm 'nɔn 'le mingɔnnɛn Seza nɛn.» Ɛn Zozi \"e 'nan -wlɛ 'nan: «Fɛ nɛn Seza -le vɛ -a bɛ, 'cɛɛ 'nɔn Seza lɛ! Ɛn fɛ nɛn Bali -le vɛ -a bɛ, 'cɛɛ 'nɔn Bali lɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","'Wɩ zɩɛ -a mandɩ o 'plo 'fɔ, -a -nan nɛn o 'si Zozi \"srɔn, ɛn o -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yi 'bɔ 'lein zɩɛ -a da bɛ, Saduze 'nɔn -mie pli Zozi man. Saduze 'nɔn \"o \"ve 'nan -te min -ka bɛ, ya'a 'wuanla -kanɔn 'va dɩ. Zɩ o pli \"man \"bɛ, ɛn waa laabʋ -yrɔ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Bali -le 'wɩ \"paazan, Moizi \"e 'nan: ‹-Te min lɩ 'pa, ɛn -a san zɩɛ e -ka, te wa'a tian 'nɛn 'yalɛ 'o 'vale 'e nan 'bɔ 'a dɩɛ, -yee -cale zɩɛ -a \"bʋɩ 'e 'pa, -e 'e \"bʋɩ klu bɔla!› ");
INSERT INTO yreNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bali -le 'wɩ \"paazan, min -tʋ a 'li 'kʋ 'va bɛ 'yee 'nɛn 'klɔnmɔn a 'sɔravli. -A tɛdɛ lɩ 'pa. Wa'a tian 'nɛn 'yalɛ 'e nan zɩɛ -a dɩ, ɛn e -ka. -A klu 'ka 'fʋlɛ dɩ, -yee \"wɛan -a -suannɛn 'e \"bʋɩ -cale zɩɛ -a 'pa. ");
INSERT INTO yreNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","'Wɩ 'tʋwli zɩɛ -yɛɛ 'bɔ \"nyian -yee \"man, ɛn -yɛɛ 'bɔ -a yaagazan man. E drɛ zɩɛ -trilii, ɛn o 'sɔravli cɛɛn -kaadɩ man. ");
INSERT INTO yreNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","\"Bɛ -sru ɛn lɩ 'bɔ -ka. ");
INSERT INTO yreNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tʋ nɛn minnun wuanla -kanɔn 'va bɛ, lɩ zɩɛ e -kɔan -tɩ nan -a? Kɔɔ o 'sɔravli 'bɔ -a 'pa lɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Ka'a tian 'wɩ 'tʋ -ci manlɛ \"fo \"dɩ. 'Wɩ nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, ka'a -ci maan dɩ, ɛn Bali -le 'plɛblɛ bɛ, ka'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kɔɔ tʋ nɛn minnun wuanla -kanɔn 'va bɛ, -klɔnmɔnnun 'ka lɩ paa dɩ, ɛn lɩmɔnnun 'ka -kɔnnɛn paa dɩ. O -kɔan \"le Bali -le 'pasianɔn nɛn laji bɛ -wee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","-Te -a -cin a 'ka 'ji 'nan, minnun nɛn o kaa bɛ wa'a 'wuanla -kanɔn 'va dɩɛ, te ka ya 'ka 'fli see \"paanan. 'Wɩ 'nɛn Bali -a 'vɩ 'yee 'fluba 'ji bɛ, ka'a tian -a ta vɩlɛ dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kɔɔ yaa 'vɩ 'nan: ‹An ya Abraam -le Bali -a, ɛn an ya Izak -le Bali -a, ɛn an ya Zago 'le Bali -a.› Tʋ nɛn Bali 'wɩ zɩɛ -a ve bɛ, te -kaa tranun zɩɛ o kaa -a -nan 'mɔn. 'Pian Bali \"le 'va bɛ, o yiɛ a \"man tian, kɔɔ Bali a minnun nɛn o yiɛ cɩ \"man \"bɛ -wee Bali -a, e 'ka minnun nɛn o kaa bɛ -wee Bali -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Minnun nɛn o cɩ 'wɩ zɩɛ -a mannan bɛ, Zozi 'le 'wɩ \"paadɩ o 'plo 'fɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farizɛn 'nɔn -a 'man 'nan Zozi Saduze 'nɔn klɩ 'wɩ 'a. -A -nan nɛn o -ta 'o cin yɩlɛ Zozi man. ");
INSERT INTO yreNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ɛn o va min -tʋ nɛn e Bali -le -pei -tɔ wɩnun -tɔa 'kpa tɩglɩ bɛ, e 'wɩ laabʋ Zozi 'lɔ 'nan -e 'e wei man. ");
INSERT INTO yreNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Yaa laabʋ -yrɔ 'nan: «Bali -le 'wɩ \"paazan, Bali -le -pei -tɔ wɩ pɛɛnɔn bɛ, -a \"cɛn 'bɛ cɩ \"va -dan?» ");
INSERT INTO yreNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ɛn Zozi \"e 'nan -yrɛ 'nan: « ‹'I Minsan 'bɔ nɛn 'yie Bali -a bɛ, -a yɩ \"yi 'i 'bli pɛɛnɔn 'a! 'I yɩ \"yi 'yie 'wɩ drɛdɩ pɛɛnɔn 'a! Ɛn 'i yɩ \"yi 'i 'ci \"nrɔndɩ pɛɛnɔn 'a.› ");
INSERT INTO yreNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","'Wɩ zɩɛ -yɛɛ cɩ Bali -le -pei -tɔ wɩ tɛdɛ -a, ɛn -yɛɛ cɩ \"va -a -dan a. ");
INSERT INTO yreNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ɛn -a \"flizan nɛn o cin 'sia 'a bɛ, -nyrɛn 'gʋ: ‹'I bɔɛzan -tʋ yɩ \"yi \"le 'yie 'wɩ 'zʋ!› ");
INSERT INTO yreNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","'Wɩ \"fli zɩɛ, -wɛɛ cɩ 'wɩ pɛɛnɔn nɛn Bali -le -pei -tɔ wɩnun -a 'vɩ bɛ -a -wulo -a, ɛn -wɛɛ cɩ 'wɩ pɛɛnɔn nɛn Bali 'lewei vɩnɔn -a 'vɩ bɛ -a -wulo -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","\"Bɛ -sru ɛn Zozi -a laabʋ Farizɛn 'nɔn pɛɛnɔn nɛn 'o cin 'yɩ bɛ -wlɔ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Crizi nɛn Bali -a 'si \"va -e 'e min 'si 'wɩ 'ji bɛ, -tɩ -pɩ nɛn? \"Cee 'ji min nɛn e cɩ -a bɛ, 'ka vɩ 'mɛn!» Ɛn o 'nan -yrɛ 'nan: «David -pɩ nɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ɛn Zozi -a laabʋ -wlɔ 'nan: «-Te Crizi a David -pɩ -a bɛ, -mɛ \"le \"wɛan nɛn zɩ Bali lei 'saun 'ta 'tɔ David man bɛ, yaa laabʋ 'e 'san? Kɔɔ David -a 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Minsan Bali -a 'vɩ 'an 'san lɛ 'nan: 'I -nyran 'an 'pɛ \"yi \"da -trilii, -e 'an 'cɛn 'i 'nanmannɔn 'klɩdɩ man.› ");
INSERT INTO yreNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","-Te David 'bɔ Crizi laabo 'e 'san bɛ, e drɛ 'kɔ ɛn 'bɛ -kɔan David kluda min -a?» ");
INSERT INTO yreNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Min -tʋ 'ka -kɔlalɛ 'wɩ 'tʋ 'sidɩ -a \"da -yrɛ \"dɩ. \"Bɛ -sru min -tʋ 'ka \"nyian 'wɩ laabʋlɛ Zozi 'lɔ 'nan -e 'e wei 'kun dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","\"Bɛ -sru ɛn Zozi 'wɩ tin 'badɩ 'sia 'e -srunɔn 'lee minnun pɛɛnɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Yaa 'vɩ -wlɛ 'nan: «'Fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn 'bɛ Moizi -le -pei -tɔ wɩnun \"paaman 'ka 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","-Yee \"wɛan 'wɩ pɛɛnɔn nɛn waa ve 'cɛɛ bɛ, 'ka 'ta wʋla \"da! 'Pian te 'ka 'ta wʋla o drɛ wɩnun da dɩ! Kɔɔ 'wɩnun nɛn waa \"paaman 'ka 'ji bɛ, -a da \"cɛɛ 'o 'bɔ \"o 'ta wʋla dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","'Wɩnun nɛn o ya 'plɛblɛ bɛ, -a 'bɔ nɛn waa -tɛa 'e cin da -e 'o vɩ minnun lɛ 'nan 'o 'ta wʋla \"da. 'Pian o 'ka \"vale o \"paa o va -a drɛnan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","-Wee 'wɩ pɛɛnɔn drɛdɩ bɛ, e ya min yiɛ 'lɛ. 'Fluba nɛn waa crɛn -tɛa, -e 'o 'pa o nyrɛnbɔn da bɛ, 'lee -nyrɛn waa crɛn -tɛa -e 'o 'pa 'o 'pɛ -da bɛ, 'lee sɔ 'lɛbo \"nɛn 'e -plimlan bɛ, -wee vɛ \"mlianla \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","-Te e ya \"fɛdi da -a oo, ɛn -te e ya cin yɩ 'kuin -a oo, -nyran \"nan 'kpagba nɛn waa 'sidɩ ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Waa ye \"yi \"le 'nan min 'e 'o 'tɔ bʋ -guada, ɛn waa ye \"yi \"le 'nan min 'e 'o laabʋ 'fluba \"paazan. ");
INSERT INTO yreNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","'Pian 'cee ve bɛ, te 'ka -wɛɛ 'nan min -tʋ 'e 'ka laabʋ 'fluba \"paazan dɩ! Kɔɔ 'ka pɛɛnɔn ka drɛ \"bʋɩnun -a, ɛn Bali -tʋwli 'bɛ cɩ 'wɩ \"paazan -a 'ka 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ɛn \"nyian bɛ, 'trɛ 'gʋɛ -a da bɛ, te 'ka min -tʋ bɔ -a laabʋdɩ -a 'nan 'ka \"tɩ \"dɩ, kɔɔ 'ka \"tɩ \"a laji lou, Bali nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Te 'ka -wɛɛ 'nan min -tʋ 'e 'ka laabʋ 'e 'tazan dɩ! Kɔɔ Crizi -tʋwli 'bɛ cɩ 'ka 'tazan -a. ");
INSERT INTO yreNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","'Ka 'va min -dan 'e drɛ 'ka pɛɛnɔn 'suzan 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Min nɛn 'e 'fli drɛ -dan bɛ, Bali -a dra \"wɛnnɔn. Ɛn min nɛn 'e 'fli drɛ \"wɛnnɔn bɛ, Bali -a dra -dan.» ");
INSERT INTO yreNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«'Fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn, ka 'wɩ dra min yiɛ 'lɛ! 'Wɩ -taa \"bɔlɛ 'ka man! Kɔɔ ka -si -tɔ minnun lɔ 'nan te 'o 'kʋ Bali va dɩ. 'Ka 'bɔ, ka 'ka \"vale 'ka -wla \"wo Bali -le mingɔnnɛn trɛda dɩ, ɛn minnun nɛn o ya \"vale \"o -wlamlan 'nan bɛ, ka -si 'lɛ 'wʋ -wlɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","'Fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn, ka 'wɩ dra min yiɛ 'lɛ! 'Wɩ -taa \"bɔlɛ 'ka man! Kɔɔ ka -calenun -le fɛnun \"sia 'o 'lɔ -dawli -a. \"Bɛ -sru -e 'ka Bali trʋ 'ba -plɔun 'nan -e minnun 'o 'ka \"sia min tɩglɩ 'a. 'Wɩnun zɩɛ -yee \"wɛan Bali -wee tin \"paa 'plɛblɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","'Fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn, ka 'wɩ dra min yiɛ 'lɛ! 'Wɩ -taa \"bɔlɛ 'ka man! Kɔɔ ka -ko min -wɛɛlɛ 'trɛda fɛ -kɔɔbli 'nan, 'nan -e 'o 'ta wʋla 'cee -pei -tɔ wɩnun da. Ɛn -te ka min 'yɩ bɛ, 'cee 'wɩ \"paadɩ a limlan min -wlidɩ \"a \"fo. -Yee -kɔndɩ -wlidɩ -ciala 'cee vɛ da 'e 'pa -a \"fli. ");
INSERT INTO yreNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","'Ka yiɛ a 'e 'widɩ, ɛn ka ya \"vale 'ka -si -kɔɔnman minnun lɛ. -Yee \"wɛan 'wɩ -taa \"bɔlɛ 'ka man! Kaa paa minnun ji 'nan, -te min 'e 'pɛ wluan Bali -pan 'kɔn da bɛ, ya'a fɛ -tʋ dra min lɛ dɩ. 'Pian -te min 'e 'pɛ wluan -siga nɛn Bali -pan 'kuin bɛ -a da bɛ, -yɛɛ cɩ 'wɩ -dan a. -A san -a 'ta ta wo -kpɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","-Blʋnɔn nɛn kaa, ɛn 'ka yiɛ a 'e 'widɩ! -Siga bɛ e ya fɛ -tʋ -a, 'pian Bali -pan 'kuin nɛn e dra 'saun Bali 'lɛ. Ka'a tɔa zɩɛ dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ɛn ka paa minnun ji \"nyian 'nan, -te min 'e 'pɛ wluan Bali -pan \"davɛ da bɛ, ya'a fɛ 'tʋ dra min lɛ dɩ. 'Pian -te min 'e 'pɛ wluan 'sraga bʋvɛ nɛn Bali -pan \"davɛ da bɛ, -a da bɛ, e ya 'wɩ -dan a. -A san -a 'ta ta wo -kpɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yiɛ 'winɔn! 'Sraga bʋvɛ bɛ e ya fɛ -tʋ -a, 'pian Bali -pan \"davɛ da nɛn e dra 'saun Bali 'lɛ. Ka'a tɔa zɩɛ dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Min nɛn 'e 'pɛ wluan Bali -pan \"davɛ da bɛ, te 'e 'pɛ wluan Bali -pan \"davɛ 'lee 'sraga bʋvɛ pɛɛnɔn nɛn \"da \"bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Min nɛn 'e 'pɛ wluan Bali -pan 'kɔn da bɛ, te 'e 'pɛ wluan Bali nɛn e -nyɛanla 'ji bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ɛn min nɛn 'e 'pɛ wluan labli man bɛ, te 'e 'pɛ wluan Bali -le mingɔnnɛn pɛin man, ɛn \"nyian te 'e 'pɛ wluan Bali da kɔɔ -yɛɛ cɩ 'e -nyrandɩ pɛin zɩɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","'Fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn, ka 'wɩ dra min yiɛ 'lɛ! 'Wɩ -taa \"bɔlɛ 'ka man! Ka fɛ pɛɛnɔn 'fuzan -nɔan Bali lɛ. Ɛn \"nyian fɛ 'finvinnun pɛɛnɔn bɛ, kaa -fuzan -nɔan Bali lɛ, -nyrɛn \"le sinwlɛnun nɛn waa laabo manti 'lee anɛti 'lee -cimɛn bɛ -wee 'wɩ 'zʋ. 'Pian -pei -tɔ wɩnun nɛn o cɩ -dan \"le 'cɛɛ drɛ bɛ cɛɛ \"tʋe. 'Wɩ tɩglɩ drɛdɩ a -tʋ, ɛn min nyrinda 'sidɩ a -tʋ, ɛn yi -tɛradɩ Bali da a -tʋ, 'wɩnun zɩɛ -nyrɛn kaa dra 'e tɛdɛ paan 'vaa -e 'ka pee drɛ \"bɛ -sru! ");
INSERT INTO yreNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","'Ka yiɛ a 'e 'widɩ, ɛn ka ya \"vale 'ka -si -kɔɔnman minnun lɛ. -Te 'nyrɔndrʋ \"wɛnnɛn 'fɔ 'ka 'blɩfɛ va bɛ, kaa \"sia \"va. 'Pian -wi -dandan nɛn waa laabo shamo bɛ, cɛɛ \"mɛan te ka'a -kɔnnɛn 'ye dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","'Fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn, ka 'wɩ dra min yiɛ 'lɛ! 'Wɩ -taa \"bɔlɛ 'ka man! Kɔɔ ka 'kulenɛn 'lee -pɔ man \"foeman fɛnyian, 'pian fɛnun nɛn kaa -ble -ji bɛ, crinnan fɛnun 'lee fɛnun nɛn kaa \"sia minnun lɔ 'ka 'bɔ 'ci 'sɔ wɩnun da bɛ -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farizɛn 'nɔn, 'ka yiɛ a 'e 'widɩ! 'Ka -wɛɛ 'nan 'ka 'ci 'e drɛ tɩglɩ 'vaa -e 'ka 'kulenɛn 'lee -pɔ man \"foe. ");
INSERT INTO yreNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","'Fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn, ka 'wɩ dra min yiɛ 'lɛ! 'Wɩ -taa \"bɔlɛ 'ka man! Kɔɔ ka ya \"le min -yrɛnun nɛn o trɔɛ 'wʋ \"man \"bɛ -wee 'wɩ 'zʋ. O man bei \"a fɛnyian, 'pian te o ci a 'e fadɩ min 'wlɛ 'lee fɛ fʋlɩdɩ pɛɛnɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","'Ka 'bɔ \"nyian, minnun 'ka ye min tɩglɩnun -a, 'pian te ka 'ka 'bɛ 'a dɩ. Ka 'wɩ dra min yiɛ 'lɛ, ɛn 'ka 'ci a 'e fadɩ 'wɩ 'wlidɩ 'tɔ 'tʋdʋ pɛɛnɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","'Fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn, ka 'wɩ dra min yiɛ 'lɛ! 'Wɩ -taa \"bɔlɛ 'ka man! Kɔɔ Bali 'lewei vɩnɔn nɛn -kaa tranun o tɛɛ bɛ, ka 'kɔn drɛ o -yrɛ da. Ɛn \"nyian ka min tɩglɩnun -yrɛ da drɛ fɛnyian fɛnyian. ");
INSERT INTO yreNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","\"Cɛɛ vɩ 'nan kaa 'kɔn 'wɩnun zɩɛ -a drɛnan bɛ, te kaa ve 'nan: ‹\"Te tʋ nɛn 'kʋ tranun yiɛ a \"man, kʋ ya -nan bɛ, \"te kʋ'a 'palɛ o va -e 'kʋ Bali 'lewei vɩnɔn -tɛɛ \"dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ɛn 'wɩnun zɩɛ -a vɩdɩ -a -kɔɔnman 'nan kaa 'vɩ 'ka 'fli -a 'nan 'ka tranun 'bɛ Bali 'lewei vɩnɔn tɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","'Wɩnun nɛn 'ka tranun -a drɛ 'li bɛ, -te ka ya \"va, \"ka \"drɛ 'e 'ciɩla -wee vɛ da! ");
INSERT INTO yreNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ka ya min -wlidɩnun -a! Bali -le tin -tɛa 'ka da -kpɔ. Te -a -cin 'e 'kɔn 'ka 'ji 'nan, 'tɛ nɛn ya'a 'driman dɩɛ e 'ka \"bluman dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","-Yee \"wɛan 'ka \"trɔɛn \"tɔ 'wɩ 'gʋɛ -yrɛ 'kpa! 'An \"ta -daa Bali 'lewei vɩnɔn 'lee 'wɩ 'tɔnɔn 'lee 'fluba 'ci vɩnɔn 'palɛ -sia 'cɛɛ. Ka o -mie -tɛa \"va, ɛn ka o -mie -tɛa \"o -pɛindɩ -a yiba \"plan da, ɛn ka o -mie -sɔan -ngble -a 'cee cin yɩ 'kɔnnun -ji. Ka 'tɛ \"paa o -mienun da 'flanun da, te wa'a 'o 'wulo da ye 'ka 'lɔ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","'Wɩnun zɩɛ -a drɛdɩ 'bɛ -maan -e minnun nɛn wa'a 'wɩ 'wlidɩ \"drɛlɛ dɩ, ɛn 'ka tranun o tɛɛ bɛ, o -ka wɩ 'e 'pa 'ka da zia. Abɛl nɛn min tɩglɩ 'a bɛ, -a da nɛn 'ka tranun -a 'sia -trilii, ɛn e 'bɔ Barashi -pɩ Zakari nɛn kaa -tɛ Bali -pan 'kɔn 'lee Bali -pan \"davɛ yei \"bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'wɩ pɛɛnɔn zɩɛ -yee \"wɛan bɛ, Bali -le tin -tɛa 'ka -naagʋnɔn da.» ");
INSERT INTO yreNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Zeruzalɛm 'nɔn, 'cee 'wɩ \"naan 'an man -wlidɩ! Ka Bali 'lewei vɩnɔn tɛɛ, ɛn minnun nɛn Bali o 'pa 'sia 'cɛɛ bɛ, ka o tɛɛ -kɔlɛnun -a. Maan man -wɛɛ 'e 'pa -a \"kaga 'nan 'an 'ka treman 'e cin man \"le zɩ mɛin \"bʋ 'yee 'nɛnnun treman 'e -pɛba wlu bɛ -yee 'wɩ 'zʋ. 'Pian ka'a 'wɩlɛ \"man \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","-Yee \"wɛan an \"ta 'an 'pɛ \"sia 'ka -sru, -e 'cee Bali -pan 'kɔn 'e 'fʋ 'e \"tun. ");
INSERT INTO yreNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Maan ve 'cɛɛ 'nan, ka'a \"nyian 'an yɩ pee wo dɩ, -trilii -e 'ka vɩ 'nan: ‹Bali -le -fɛa 'e 'kɔn min nɛn e -taa Minsan 'tɔ da bɛ -a man.› » ");
INSERT INTO yreNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","\"Bɛ -sru Zozi 'bɔla Bali -pan 'kuin, ɛn e -kʋdɩ 'sia. -A -nan nɛn -a -srunɔn pli \"man, ɛn o 'nan -yrɛ 'nan: «\"I 'yiɔ, Bali -pan 'kɔn a -miɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ɛn Zozi \"e 'nan -wlɛ 'nan: «-A pɛɛnɔn 'labɛ 'ka -nanjɛn! Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'kɔn 'labɛ e -wia. -A -kɔlɛ pɛɛnɔn fuimlan \"man, -a -tʋ 'ka 'fo 'e bɔɛzan -tʋ da dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Zɩ Zozi 'bɔla Olivie pɔn da bɛ, e -nyran, ɛn -a -srunɔn -a laabʋ -yrɔ 'nan: «'Wɩ nɛn i \"sia -a vɩnan 'gʋɛ, tʋ \"cɛn \"man nɛn e dra? Ɛn \"nyian -mɛ \"wɩ 'bɛ dra 'vaa -e 'kʋ -tɔ 'nan 'i 'ta tʋ 'bɔ? Ɛn -mɛ \"wɩ 'bɛ dra 'vaa -e 'kʋ -tɔ 'nan 'trɛ 'nyan tʋ 'bɔ?» ");
INSERT INTO yreNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Ka yiɛ 'tɔ 'ka 'fli -va! Te min -tʋ 'e 'ka see \"paa -e 'ka 'si -si tɩglɩ da dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Fɛ nɛn maan ve zɩɛ -yɛɛ cɩ 'nan, min \"kaga -taa \"talɛ 'an 'tɔ da. Waa ve 'o 'fli man 'nan, min nɛn Bali -a 'si \"va \"bɛ -nyrɛn 'waa, -e min \"kaga 'o -sɔɔnla o -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ka -kuli -tan wɩnun maan, ɛn ka 'fla -kɔɔbli -kɔɔbli da -kuli wɩnun maan. Te 'o 'ka 'cɛn nyɛn -a dɩ! Kɔɔ 'wɩnun zɩɛ -wɛɛ dra 'e 'flin, 'pian 'trɛda -nyan tʋ \"cɛɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","'Lɛglɔn 'tʋ -ji 'nɔn -taa 'wunlɛa 'lɛglɔn 'tʋ -ji 'nɔn man, ɛn mingɔnnɛn trɛ -tʋ -taa 'wunlɛa mingɔnnɛn trɛ -tʋ man. Dra minnun -tɛɛman fɛ \"kaga \"nan, ɛn 'trɛ 'nyɔɔnman fɛ \"kaga \"nan. ");
INSERT INTO yreNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","-A pɛɛnɔn zɩɛ e ya \"le 'nan 'nɛn 'yadɩ -le ci -yaa pou sianan \"wɛnnɛn 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tʋ zɩɛ -a man nɛn minnun 'ka \"kuundɩ \"siala, te o 'tɛ \"paa 'ka da, ɛn te o 'ka -tɛɛman. 'Lɛglɔn pɛɛnɔn 'ji 'nɔn \"naan 'ka man, ka drɛ 'an -srunɔn 'a -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ɛn \"nyian min \"kaga \"sia 'an -sru. 'O cin man wlɛ -fɔa, te o \"naan 'o cin man. ");
INSERT INTO yreNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Minnun nɛn o 'wlu wɩ \"sia -e 'o vɩ, te waa ve 'nan o ya Bali 'lewei vɩnɔn 'a bɛ, o bɔala 'trɛda \"kaga. Ɛn o min \"kaga see \"paaman. ");
INSERT INTO yreNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","'Wɩ 'wlidɩ \"drɛdɩ faa \"da 'trɛda -le \"wɛan, min \"kaga \"le min yɩdɩ \"yi 'e 'le -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","'Pian min nɛn e -tɔ 'plɛblɛ -trilii, ɛn e 'bɔ -a 'le 'srannan \"bɛ, e \"sia 'wɩ 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bali -le mingɔnnɛn -blɩdɩ min da bɛ, 'wɩ 'nɔnnɔn nɛn. Ɛn 'wɩ zɩɛ minnun -a fuimlan \"man 'trɛda 'nɔn pɛɛnɔn 'va, -e 'lɛglɔn 'tʋdʋ pɛɛnɔn 'o man. \"Bɛ -sru 'vaa -e 'trɛda -nyan tʋ 'e bɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Bali 'lewei vɩzan Daniɛl -a 'vɩ 'nan, 'wɩ 'wlidɩ \"nɔnnɔan -taa \"drɛlɛ Bali -le 'kuin. Min nɛn e 'fluba 'gʋɛ -a ta ve bɛ 'e 'ci man 'kpa! Tʋ nɛn 'wɩ zɩɛ kaa -nan 'yɩ Bali -pan 'kuin bɛ, ");
INSERT INTO yreNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","minnun nɛn o cɩ Zude 'lɛglɔn 'ji bɛ, 'o flan 'bli, 'o 'kʋ pɔnnun yei! ");
INSERT INTO yreNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ɛn -te min a bei \"bɛ, te 'e -wla 'yee 'kuin -e 'e 'kʋ fɛ -tʋ 'sia dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ɛn -te min a fei bɛ, te 'e li 'e da 'fla -e 'e 'kʋ 'yee -tralɛ 'si 'yee 'kuin dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lɩmɔnnun nɛn o -pɔn cɩ 'o man tʋ zɩɛ -a man bɛ, 'lee lɩmɔnnun nɛn 'nɛn 'nyɔn -mlian -wlɔ tʋ zɩɛ -a man bɛ, -wee yra yɩdɩ \"mlianla \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","-Yee \"wɛan 'ka Bali trʋ 'ba 'nan, te 'wɩ zɩɛ 'e 'tria laa 'fɛn tʋ -man dɩ, ɛn te 'e 'tria 'cee 'flinla \"yi da dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kɔɔ 'wɩ yɩdɩ -kɔan -dan 'kpa tʋ zɩɛ -a man. Zɩ Bali 'trɛ drɛ 'li -e 'e bɔ cɛɛgʋ yi -a bɛ, -a sʋman 'wɩ yɩdɩ 'ka tian drɛlɛ dɩ. Ɛn 'wɩ yɩdɩ zɩɛ -a pee 'ka 'dra \"nyian 'li 'trɛda \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yinun nɛn 'wɩnun zɩɛ o dra \"da \"bɛ, Bali -a -mie cɛɛn \"da. -Te ya'a 'wɩ zɩɛ -a drɛlɛ dɩɛ, \"te min -tʋ -wulo 'ka -taa bɔlɛa \"va \"dɩ. 'Pian minnun nɛn e o 'si \"va 'yee vɛ -a bɛ, -wee \"wɛan e yinun -mie cɛɛn \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","-Te min -tʋ -a 'vɩ 'cɛɛ 'nan, min 'sizan 'wɩ 'ji Crizi a 'gʋ, -te 'bɛ \"cɛɛ dɩ, Crizi a -miɛn bɛ, te 'ka yi -tɛra \"da \"fo \"dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kɔɔ minnun nɛn o 'wlu -sɛan 'nan 'wɛɛ cɩ Crizi -a bɛ, o -taa \"kɔnlɛ 'trɛda. Ɛn minnun nɛn o 'wlu wɩnun ve, te waa ve 'nan Bali 'lewei vɩnɔn nɛn waa bɛ, o -taa \"kɔnlɛ \"nyian. O -taa 'lɛbo \"fɔ wɩ -dandan 'lee -cɛ -srɔn \"wɩ -dandan drɛlɛ. Waa dra 'nan -te 'o 'pɛ 'sɔ 'a bɛ -e 'o minnun nɛn Bali o 'si \"va 'yee vɛ -a bɛ, o 'si -si tɩglɩ da. ");
INSERT INTO yreNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","'Wɩnun zɩɛ maan -cin -trɔa 'ka 'ji 'nan, te 'ka yiɛ a 'ka 'fli -va. ");
INSERT INTO yreNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","-Yee \"wɛan -te min -a 'vɩ 'cɛɛ 'nan, Crizi a \"bui \"da bɛ, te 'ka 'kʋ -nan dɩ. Ɛn -te waa 'vɩ 'cɛɛ 'nan, e ya 'kɔn 'tʋ -ji bɛ, te 'ka yi -tɛra \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kɔɔ tʋ nɛn 'an 'bɔ Blamin -pɩ 'an -taa \"man \"bɛ, e dra \"le laa -paan 'zʋ. Laa -paan, 'e 'wlei -wlei -fɔa, e \"sia yidɛ wluan \"nan 'zia, -e 'e 'kʋ yidɛ 'fɔ -nan \"va 'zia. 'Trɛda 'nɔn pɛɛnɔn -a -nan ye. ");
INSERT INTO yreNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","-Kaa -tɔa 'wein 'nan fɛnan nɛn -wi -kadɩ cɩ 'e pladɩ bɛ, -a ta lou \"nɛn -wi pɛa \"blɩ \"lomannun 'o 'ble.» ");
INSERT INTO yreNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«-Te 'wɩ yɩdɩ -dan zɩɛ, e cɛɛn -nyandɩ man bɛ, 'nun tɔɔn yidɛ yra klun -tɔala, mlɛn 'bidɩ 'e 'le -tɔa, mlɛn crɛnnun \"sia laji, o -tɛɛmlan \"tra, ɛn laji fɛnun pɛɛnɔn nɛn 'plɛblɛ a -wlɔ \"bɛ, o \"sia 'o 'klu -ji. ");
INSERT INTO yreNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tɔɔn minnun pɛɛnɔn -a -kɔnnɛn ye laji 'nan 'an 'bɔ Blamin -pɩ -tadɩ 'bɔ \"mɛn. \"Bɛ -sru 'trɛda 'nɔn pɛɛnɔn 'an 'bɔ Blamin -pɩ ye -tanan \"lolu -koei \"da laji, -e 'o 'wuɔdɩ 'sia. 'Plɛblɛ -dan -kɔan 'an 'lɔ, ɛn 'tɔ -dan -kɔan 'an 'lɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bali -le 'bei -dan \"we, -e 'an 'bɔ Blamin -pɩ, 'an 'mɛn 'pasianɔn nɛn laji bɛ o 'pa 'sia 'trɛda fɛ pɛɛnɔn 'nan. Minnun pɛɛnɔn nɛn an o 'si \"va 'mɛn vɛ -a bɛ, 'mɛn 'pasianɔn o cin ye. Fɛ -tʋ -nan 'ka 'fʋ 'trɛda, te wa'a min 'silɛ 'bɛ 'nan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«'Wɩ nɛn e dra fijie yiba \"lɛ bɛ, 'e drɛ 'cee 'wɩ -kɔɔn \"manvɛ -a! -Te -a 'la nrindɩ 'sia \"da \"bɛ, kaa -tɔa 'nan 'munmun tʋ a -tanan bɔdɩ -a -kogo. ");
INSERT INTO yreNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","-A -tʋwli \"nɛn \"nyian, 'an 'bɔ Blamin -pɩ -tadɩ -le vɛ -a. -Te ka 'wɩnun nɛn maan 'vɩ 'cɛɛ bɛ, -a 'yɩ drɛnan bɛ, 'ka -tɔ 'nan 'an 'tadɩ a bɔnan 'kogo! ");
INSERT INTO yreNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'ka -naagʋnɔn 'gʋɛ, ka'a 'cɛan -kaadɩ man 'vaa, -e 'wɩnun zɩɛ 'o drɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Labli 'lee 'trɛ 'nyan tʋ a, 'pian 'an wei -fo -nan 'li 'trilii. ");
INSERT INTO yreNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Tʋ nɛn an -taa \"man \"bɛ, blamin -tʋ 'ka -a tɔa \"fo \"dɩ. Ɛn Bali -le 'pasianɔn nɛn laji bɛ, wa'a tɔa \"fo \"dɩ, ɛn 'an 'bɔ Blamin -pɩ ma'an tɔa \"fo \"dɩ, 'pian 'an \"tɩ 'bɛ -tɔa 'e 'tʋwli. ");
INSERT INTO yreNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tʋ nɛn 'an 'bɔ Blamin -pɩ -taa \"bɛ, 'wɩnun dra \"le zɩ e drɛ Noe tʋ va bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kɔɔ Noe tʋ va 'li te laa -dan 'ka tian 'fɛnlɛ 'trɛda dɩɛ, minnun fɛ blɩ, o -wɛn mlin, o lɩ 'pa, o -kɔnnɛn 'pa. Waa drɛ zɩɛ -trilii ɛn Noe wla -klu -dan -ji, te waa dra tian. ");
INSERT INTO yreNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","'Wɩ 'tʋ -cin 'ka o ji dɩ. O -fʋ -a drɛdɩ man zɩɛ -trilii ɛn laa -dan o -nan -nyan \"fo. 'Wɩ 'tʋwli zɩɛ -yɛɛ dra 'an 'bɔ Blamin -pɩ -ta tʋ -man. ");
INSERT INTO yreNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tʋ zɩɛ -a man bɛ, min \"fli -kɔan \"fei, 'mɛn 'pasianɔn nɛn laji bɛ waa -tʋ \"siala -e 'o -tʋ 'tʋɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ɛn \"nyian bɛ, lɩmɔn \"fli -kɔan 'saa 'sɔnnan, 'mɛn 'pasianɔn nɛn laji bɛ waa -tʋ \"siala -e 'o -tʋ 'tʋɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","-Yee \"wɛan 'ka 'man 'e 'kɔn 'e wʋʋdɩ tʋ pɛɛnɔn man! Kɔɔ yi nɛn 'ka 'san -taa \"da \"bɛ, ka'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'Ka 'ci \"nrɔn 'wɩ 'gʋɛ -a da! Tʋ nɛn crinzan -taa \"min crin wʋlɛ -pei -man bɛ, \"te 'kɔn san -a -tɔa \"bɛ, \"te -a yiɛ 'fo \"man \"trilii, ɛn ya'a 'we \"man -e crinzan 'e -yee fɛnun \"koola dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","'Kɔn san 'ka crinzan -ta tʋ tɔa dɩ. -A -tʋwli \"nɛn \"nyian 'cee vɛ -a, Blamin -pɩ -le -tadɩ bɔa 'ka man kligli, -yee \"wɛan 'ka 'man 'e 'kɔn 'e wʋʋdɩ tʋ pɛɛnɔn man!» ");
INSERT INTO yreNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Min 'suzan \"cɛn 'bɛ 'ta wʋla 'e 'san wei da 'wɩ 'tɔdɩ -a? Min 'suzan nɛn -a tazan 'yee 'kɔn 'pɛba 'wʋ -yrɔ, ɛn yaa 'vɩ -yrɛ 'nan, 'e -blɩfɛ -nɔn min 'sunɔn -mienun lɛ 'e tʋ -man bɛ, -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Min 'suzan zɩɛ -te -a tazan 'bɔ \"man 'wɩ zɩɛ -a drɛnan bɛ -yee vɛ a \"yi. ");
INSERT INTO yreNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -a tazan -a -tɔa 'e yɩfɛ pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","'Pian -te min 'suzan -wlidɩ \"nɛn bɛ, zɩ 'e 'ci \"nrɔnman 'gʋ. Yaa ve 'nan: ‹'An 'tazan a 'mɔnnan.› ");
INSERT INTO yreNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tɔɔn -e 'e 'tɛ 'padɩ 'sia minnun nɛn 'e yiɛ -tɔa \"o va bɛ o da, te e ya 'e 'fɔdɩ -wɛn -tɛnɔn -sru, o fɛnun -ble waa, te o -wɛn -mlian \"waa. ");
INSERT INTO yreNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tɔɔn yi nɛn -a -cin 'ka \"ji 'nan 'e 'tazan -taa \"dɩɛ, -e 'bɛ bɔla kligli, ");
INSERT INTO yreNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","-e -a tazan 'e \"nɛn \"jɛɛnla 'ji -wlidɩ. E 'wɩ \"nɛn -kɔɔnman -yrɛ \"le zɩ o 'wɩ \"nɛn -kɔɔnman minnun nɛn o 'wɩ dra min yiɛ lɛ bɛ -wlɛ \"bɛ, -yee 'wɩ 'zʋ fɛnan nɛn -wuɔdɩ 'lee 'shɛ da -blɩdɩ cɩ bɛ -a -nan.» ");
INSERT INTO yreNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ɛn Zozi -kɔnnɛn pee -fɔ \"nyian -wlɛ. E 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -nyrɛn 'gʋ. E ya \"le nɔnbɛ \"fu 'bɛ 'wee -kannɛnnun 'sia, ɛn o -kʋ lɩmɔn -tʋ nɛn e \"ta -kɔnnɛn \"paa bɛ -yee 'kuin. Min nɛn e \"ta lɩ \"paa bɛ waa -pɛndɩ 'sia, kɔɔ -wɛɛ -ko o 'palɛ -sia 'o 'lɔ le 'wee -kannɛnnun -a. ");
INSERT INTO yreNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nɔnbɛnun zɩɛ -a 'soolu a \"va \"bɛ -blʋnɔn nɛn waa, ɛn -a 'soolu a \"va \"bɛ 'wɩ 'tɔnɔn nɛn waa. ");
INSERT INTO yreNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","-A 'soolu nɛn -blʋnɔn 'a bɛ, o 'wee -kannɛnnun 'sia, 'pian wa'a 'kunlɛ -a 'yi man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ɛn -a 'soolu nɛn 'wɩ 'tɔnɔn 'a bɛ o 'wee -kannɛnnun 'sia, ɛn o 'kun -a 'yi -mie man. ");
INSERT INTO yreNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Min nɛn e \"ta lɩ \"paa bɛ, zɩ e ya 'mɔnnan bɛ, ɛn yi -fɔla nɔnbɛnun zɩɛ o da. ");
INSERT INTO yreNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Zɩ bada -tɔ bɛ, ɛn minnun pladɩ 'sia. O pla 'nan: ‹Min nɛn e \"ta lɩ \"paa bɛ, e ya -tanan. 'Ka 'kʋ -a 'si 'sia.› ");
INSERT INTO yreNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","-A -nan nɛn nɔnbɛnun zɩɛ o wluan lou, ɛn o 'wee -kannɛnnun drɛ 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nɔnbɛnun 'soolu nɛn -blʋnɔn 'a bɛ, waa 'vɩ 'o \"luenun lɛ 'nan: ‹'Ka \"kʋe 'cee -kannɛn 'yi 'nɔn, kɔɔ 'kʋe -kannɛnnun \"ta \"driman!› ");
INSERT INTO yreNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Pian nɔnbɛnun nɛn 'wɩ 'tɔnɔn 'a bɛ, o 'nan -wlɛ 'nan: ‹-Cɛjɛ, kʋ'a 'we \"man \"dɩ. Ya'a 'bɔa 'kʋe vɛ 'lee 'cee vɛ -a dɩ. 'Ka 'kʋ 'cee vɛ 'lɔ -kannɛn 'yi -tanzan -va!› ");
INSERT INTO yreNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ɛn nɔnbɛnun zɩɛ o -kʋ -a 'lɔlɛ. Tʋ zɩɛ -a wlu nɛn min nɛn e \"ta lɩ \"paa bɛ e 'bɔla. Ɛn nɔnbɛnun 'soolu nɛn o man cɩ 'e wʋʋdɩ bɛ, o -kʋ lɩ 'pa \"fɛdi da. -A -nan nɛn minnun 'kɔn 'lɛ 'wʋ o da. ");
INSERT INTO yreNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","\"Bɛ -sru ɛn nɔnbɛnun nɛn -blʋnɔn 'a bɛ, o -ta. O 'kɔn -tɛ, te o -paanman 'nan: ‹'Kʋ 'san, 'kʋ 'san, 'i yra 'si, 'i 'kɔn 'lɛ 'sʋ 'kʋɛ!› ");
INSERT INTO yreNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","'Pian lɩ 'pazan zɩɛ ya'a 'wɩlɛ \"man \"dɩ. E 'nan -wlɛ 'nan: ‹Ma'an 'ka 'tɔa dɩ.› » ");
INSERT INTO yreNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ɛn Zozi -a 'le 'sran -wlɛ 'nan: «'Wɩ zɩɛ -a bɔdɩ 'ka man -le \"wɛan bɛ, 'ka 'man 'e 'kɔn 'e wʋʋdɩ tʋ pɛɛnɔn man, kɔɔ tʋ nɛn an -taa \"man \"bɛ, ka'a tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -nyrɛn 'gʋ. E ya \"le min -tʋ 'bɛ \"ta -ko 'ta wʋnan. Min zɩɛ 'e 'sunɔn laabʋ, ɛn 'e yɩfɛ pɛɛnɔn -pɛba 'wʋ -wlɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","E -siga 'wlɛ 'soolu 'nɔn -a -tʋ lɛ, ɛn yaa -nɔn -a -tʋ lɛ \"nyian 'wlɛ \"fli, ɛn yaa -nɔn -a yaagazan lɛ 'wlɛ 'tʋ. Zɩ min -tʋ -kɔlaman 'e 'pɛ man liladɩ -a bɛ, -a da nɛn yaa -nɔn -wlɛ. Ɛn e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","'Nun tɔɔn min nɛn e -siga 'wlɛ 'soolu 'yɩ bɛ, 'e 'pɛ man lila -siga zɩɛ -a, ɛn -a man 'pa \"nyian -siga 'wlɛ 'soolu. ");
INSERT INTO yreNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Min nɛn e -siga 'wlɛ \"fli 'yɩ bɛ, 'wɩ 'tʋwli zɩɛ -a 'bɔ nɛn \"e drɛ. -Yee vɛ man 'pa -siga 'wlɛ \"fli. ");
INSERT INTO yreNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Min nɛn e -siga 'wlɛ -tʋwli 'yɩ bɛ, e -klu cɛɛn, ɛn yaa yɔɔ \"ji. ");
INSERT INTO yreNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","-A -nan 'mɔn 'trilii, ɛn o tazan zɩɛ e -ta. -A -nan nɛn 'e 'sunɔn zɩɛ o laabʋ 'nan -e 'o 'nyranman nɛn waa 'pa bɛ -a -sru \"vɩ 'yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Min nɛn e -siga 'wlɛ 'soolu 'yɩ bɛ, e -ta 'e 'lɔ le -siga 'wlɛ 'soolu -a \"nyian. Ɛn e 'nan 'e 'san lɛ 'nan: ‹'An 'san, -siga 'wlɛ 'soolu nɛn yia -nɔn 'mɛn bɛ, maan drɛ ɛn -a man 'pa \"nyian -siga 'wlɛ 'soolu. -Nyrɛn 'gʋ.› ");
INSERT INTO yreNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","-A -nan nɛn -a tazan \"e 'nan -yrɛ 'nan: ‹I muo, yia drɛ 'kpa. I ya 'an 'suzan 'kpa -a. Fɛ \"wɛnnɛn nɛn maan -pɛba 'wʋ 'i 'lɔ 'gʋɛ, i 'wɩ \"yi drɛ 'a. -Yee \"wɛan an fɛ -dan -pɛba wo 'i 'lɔ. 'I 'ta -e 'kʋ 'ci 'e \"nran 'e cin va.› ");
INSERT INTO yreNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Min nɛn e -siga 'wlɛ \"fli 'yɩ bɛ, e -ta ɛn e 'nan 'e 'san lɛ 'nan: ‹'An 'san, -siga 'wlɛ \"fli \"nɛn yia -nɔn 'mɛn bɛ, maan drɛ ɛn -a man 'pa \"nyian -siga 'wlɛ \"fli. -Nyrɛn 'gʋ.› ");
INSERT INTO yreNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","-A -nan nɛn -a tazan \"e 'nan -yrɛ 'nan: ‹I muo, yia drɛ 'kpa. I ya 'an 'suzan 'kpa -a. Fɛ \"wɛnnɛn nɛn maan -pɛba 'wʋ 'i 'lɔ 'gʋɛ, i 'wɩ \"yi drɛ 'a. -Yee \"wɛan an fɛ -dan -pɛba wo 'i 'lɔ. 'I 'ta -e 'kʋ 'ci 'e \"nran 'e cin va.› ");
INSERT INTO yreNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","\"Bɛ -sru min nɛn e -siga 'wlɛ -tʋ 'yɩ bɛ, e -ta ɛn e 'nan 'e 'san lɛ 'nan: ‹'An 'san, maan -tɔa 'nan, i ya min nɛn -yee 'wɩ a 'tɔndɔn bɛ -a. -Te min 'yie 'nyranman 'pa bɛ, -a ta -trɔn pɛɛnɔn nɛn yaa ye bɛ, yia \"sia -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","\"Klan -fʋ 'an 'ji 'nan te 'yie -siga 'e 'san 'an 'lɔ dɩ, -yee \"wɛan an -kʋ -a yɔɔlɛ 'trɛ 'ji. -Nyrɛn 'gʋ, 'i 'si.› ");
INSERT INTO yreNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ɛn -a tazan zɩɛ e 'nan -yrɛ 'nan: ‹I ya 'an 'suzan -wlidɩ \"a, ɛn kɔanzan nɛn yia. -Te -a -cin a 'i 'ji 'nan, min 'mɛn 'nyranman \"paa, maan ta -trɔn pɛɛnɔn \"sia -a san lɔ bɛ, ");
INSERT INTO yreNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","-mɛ \"le \"wɛan nɛn yi'a -kʋlɛ 'mɛn -siga 'palɛa fɛnan nɛn -a man \"paa bɛ -a -nan dɩ? Yia dra paan zɩɛ, -te an -ta bɛ, -e 'an 'kʋ 'mɛn -siga 'si 'o 'vale 'e 'man 'pa 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'Ka -siga 'labɛ -a 'si -yrɔ, -e 'ka -nɔn min nɛn -siga -fu a -yrɔ \"bɛ -yrɛ! ");
INSERT INTO yreNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kɔɔ min nɛn fɛ a -yrɔ \"kaga \"bɛ -a lɛ nɛn waa -nɔan, -e -yee vɛ 'e 'pa \"da. 'Pian min nɛn fɛ 'ka -yrɔ \"kaga \"dɩɛ, -a \"tiɛnnɛn nɛn -yrɔ \"bɛ, waa \"sia. ");
INSERT INTO yreNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","'An 'suzan 'gʋɛ, -a -pɛ 'ka 'fɔala 'e man dɩ, 'ka 'ta -a tuʋ klun va bei, fɛnan nɛn -wuɔdɩ 'lee 'shɛ da -blɩdɩ cɩ bɛ -a -nan.› » ");
INSERT INTO yreNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Tʋ nɛn 'an 'bɔ Blamin -pɩ an -taa 'kʋ 'vale 'mɛn 'pasianɔn nɛn laji bɛ waa bɛ, an -taa 'mɛn 'tɛ 'san da, -e 'an -nyran 'mɛn mingɔnnɛn pɛin -da. ");
INSERT INTO yreNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","'Lɛglɔn pɛɛnɔn 'jinɔn 'o cin ye 'an 'lɛ, -e 'an o 'cɛn 'e cin man \"fli. Maan dra \"le zɩ 'bla -sru \"pinzan 'yee 'blanun 'lee 'yee bonun \"cɛan 'e cin man bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","E 'blanun -sɛan 'e 'pɛ \"yi \"da, -e 'e bonun -sɛn 'e 'pɛ bʋ da. ");
INSERT INTO yreNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tɔɔn 'an 'bɔ mingɔnnɛn maan ve 'an 'pɛ \"yi \"danɔn lɛ 'nan: ‹Kaa 'gʋɛ, 'an \"tɩ -fɛa 'vɩ 'ka man! 'Ka 'ta! Mingɔnnɛn trɛ nɛn 'an \"tɩ -a man drɛ 'trɛda pou sianan \"bɛ, e drɛ 'cee vɛ -a. 'Ka 'si! ");
INSERT INTO yreNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Fɛ -le \"wɛan nɛn maan -nɔn 'cɛɛ bɛ, te dra 'an -tɛa \"bɛ, ka fɛ -nɔn 'mɛn. Ɛn te 'yi dra 'an -tɛa \"bɛ, ka 'yi 'nɔn 'mɛn, ɛn te an 'lʋ 'ka 'va 'pɛn -a bɛ, kaan 'kun 'ka 'pɛ \"fli \"a. ");
INSERT INTO yreNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ɛn te sɔ 'ka 'an da dɩɛ, ka sɔ 'wʋ 'an man, ɛn te 'an 'man \"yaaman bɛ, 'ka yiɛ 'tɔ 'an 'va. Ɛn te an ya -pʋ 'kuin bɛ, ka 'lʋ 'an 'nanjɛnlɛ.› ");
INSERT INTO yreNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tɔɔn -e min tɩglɩnun zɩɛ 'o laabʋ 'an 'lɔ 'nan: ‹Minsan, tʋ \"cɛn \"man nɛn kʋi 'yɩ te dra 'i -tɛa ɛn kʋ fɛ -nɔn 'yiɛ? Ɛn tʋ \"cɛn \"man nɛn kʋi 'yɩ te 'yi dra 'i -tɛa ɛn kʋ 'yi 'nɔn 'yiɛ? ");
INSERT INTO yreNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tʋ \"cɛn \"man nɛn i 'lʋ 'kʋ 'va 'pɛn -a, ɛn kʋi 'kun 'kʋ 'pɛ \"fli \"a? Tʋ \"cɛn \"man nɛn i ya 'i plʋdɩ, ɛn kʋ sɔ 'wʋ 'i da? ");
INSERT INTO yreNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tʋ \"cɛn \"man nɛn kʋi 'yɩ te 'i 'man \"yaaman, ɛn 'kʋ yiɛ 'tɔ 'i 'va? Tʋ \"cɛn \"man nɛn kʋi 'yɩ te i ya -pʋ 'kuin ɛn kʋ 'lʋ 'i 'nanjɛnlɛ?› ");
INSERT INTO yreNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tɔɔn 'an 'bɔ mingɔnnɛn, maan ve -wlɛ 'nan: ‹Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, tʋ nɛn ka ya 'wɩnun zɩɛ -a drɛnan 'an \"bʋɩnun 'gʋɛ o va min \"wɛnnɛn 'tʋ lɛ bɛ, te 'an lɛ nɛn ka cɩ -a drɛnan.› ");
INSERT INTO yreNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","\"Bɛ -sru maan ve minnun nɛn 'an 'pɛ bʋ da bɛ -wlɛ 'nan: ‹'Ka -pli 'ka -sru \"kɔɔbli! Bali wei a 'e pladɩ 'ka man. 'Ka 'kʋ 'tɛ nɛn ya'a 'driman dɩɛ, -a va. Bali -a man drɛ Satan 'lee 'yee 'pasianɔn 'le vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Fɛ -le \"wɛan nɛn an 'wɩ zɩɛ -a 'vɩ bɛ, te dra 'an -tɛa \"bɛ, ka'a fɛ -nɔnlɛ 'mɛn dɩ. Ɛn te 'yi dra 'an -tɛa \"bɛ, ka'a 'yi 'nɔnlɛ 'mɛn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ɛn te an 'lʋ 'ka 'va 'pɛn -a bɛ, ka'an 'kunlɛ 'ka 'pɛ \"fli \"a dɩ. Ɛn te sɔ 'ka 'an da dɩɛ, ka'a sɔ wʋlɛ 'an man dɩ. Ɛn te 'an 'man \"yaaman bɛ, ka'a yiɛ -tɔlɛ 'an 'va dɩ. Ɛn te an ya -pʋ 'kuin bɛ, ka'a 'lʋlɛ 'an 'nanjɛnlɛ dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tɔɔn -e \"o laabʋ 'an 'lɔ \"nyian 'nan: ‹Minsan, tʋ \"cɛn \"man nɛn kʋi 'yɩ te dra 'i -tɛa? Ɛn tʋ \"cɛn \"man nɛn kʋi 'yɩ te 'yi dra 'i -tɛa? Ɛn tʋ \"cɛn \"man nɛn i 'lʋ 'kʋ 'va 'pɛn -a? Ɛn tʋ \"cɛn \"man nɛn i ya 'i plʋdɩ? Ɛn tʋ \"cɛn \"man nɛn kʋi 'yɩ te 'i 'man \"yaaman? Ɛn tʋ \"cɛn \"man nɛn kʋi 'yɩ te i ya -pʋ 'kuin? Ɛn tʋ \"cɛn \"man nɛn kʋ'a 'palɛ 'i 'va dɩ?› ");
INSERT INTO yreNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tɔɔn -e 'an vɩ -wlɛ 'nan: ‹Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, tʋ nɛn ka 'ka 'wɩnun zɩɛ -a drɛnan 'an \"bʋɩnun 'gʋɛ o va min \"wɛnnɛn 'tʋ lɛ dɩɛ, te 'an 'bɔ lɛ nɛn ka 'ka -a drɛnan dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Minnun zɩɛ, wɛɛ -ko yra yɩdɩ nɛn -a 'leda \"ka \"dɩɛ -a va. 'Pian minnun nɛn o cɩ min tɩglɩnun -a bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ, e ya -wee vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Zɩ Zozi cɛɛn 'wɩ pɛɛnɔn zɩɛ -a vɩdɩ man bɛ, ɛn yaa 'vɩ 'e -srunɔn lɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Kaa -tɔa 'nan, e -fʋ yi -tʋ -a \"fli -e -kaa tranun -le 'sidɩ nɔanba -ji \"fɛdi drɛdɩ 'e bɔ. Yi zɩɛ -a da nɛn 'an 'bɔ Blamin -pɩ waan -nɔan \"minnun lɛ, -e 'waan 'tɛ 'an -pɛindɩ -a yiba \"plan da.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tʋ zɩɛ -a wlu bɛ te Bali -pannɔn 'tanɔn 'lee min cejenun a 'o cin yɩnan Bali -pannɔn 'tazan nɛn waa laabo Kaifa bɛ -yee -klɔn -ji. ");
INSERT INTO yreNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","-A -nan nɛn waa 'pla \"da 'nan 'o Zozi 'kun ci 'cɛn 'a -e 'o -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","'Pian waa 'vɩ 'o cin yei 'nan: «Te -kaa drɛ \"fɛdi yi da dɩ! \"Tɔgɔ minnun 'o -nan yɩ -e 'o 'wluan -kaa man.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Zozi a 'fla nɛn waa laabo Betani bɛ -a da. E ya Simɔn nɛn -kogobe a \"nɛn \"man \"bɛ -yee 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","O ya fɛnun -blɩnan, -a -nan nɛn lɩmɔn -tʋ pli Zozi man 'e 'lɔ le -laziglɔ nɛn -a 'flɛ a 'plɛblɛ 'kpa bɛ -a -pɔnɛn 'tʋ -a. Ɛn yaa -sɛndɩ 'sia Zozi 'win -ji. ");
INSERT INTO yreNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Zɩ -a -srunɔn 'wɩ zɩɛ -a -nan 'yɩ bɛ, -a 'wɩ 'nan o man, ɛn o 'nan: «-Mɛ \"le \"wɛan nɛn e -laziglɔ 'kpa bɛ -a srɛ 'e \"tun? ");
INSERT INTO yreNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","-Laziglɔ 'labɛ yaa -taan paan 'flɛ 'plɛblɛ 'a, -e 'e man \"lala -pli 'yalɛ -tɛnɔn man.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Zozi 'wɩ zɩɛ -a 'man, ɛn e 'nan -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn ka 'wɩ -tɔa lɩ 'gʋɛ -a man? E 'wɩ \"yi drɛ 'mɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","'Yalɛ -tɛnɔn a 'ka 'va tʋ pɛɛnɔn man, 'pian \"an 'ka 'wo 'ka 'va tʋ pɛɛnɔn man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","-Laziglɔ nɛn yaa -sɛn 'an da 'gʋɛ, 'an 'man nɛn yaa drɛ 'nan -e 'waan wʋ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, fɛnan pɛɛnɔn nɛn minnun Bali -le 'wɩ 'nɔnnɔn ve 'trɛda bɛ, 'wɩ nɛn lɩ 'gʋɛ yaa drɛ bɛ, waa -nan 'sinan \"paa, ɛn -yɛɛ -maan 'lɔɔ -e lɩ 'bɔ 'cin 'e 'fɔla minnun ji.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","\"Bɛ -sru ɛn Zozi -srunɔn 'fuda \"fli 'va min -tʋ nɛn waa laabo Zudazi Karioti bɛ, e -kʋ Bali -pannɔn 'tanɔn 'va, ");
INSERT INTO yreNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ɛn e 'nan -wlɛ 'nan: «-Te an Zozi 'nɔn 'cɛɛ bɛ, -mɛ \"nɛn kaa -nɔan 'mɛn?» -A -nan nɛn o 'lein 'wlɛ -fuba yaaga 'nɔn -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yi zɩɛ -a da nɛn Zudazi -a man -wɛɛdɩ 'sia 'nan, tʋ \"yi 'e 'pla -e 'e Zozi 'nɔn Zuif 'nɔn 'tanɔn 'bɔ lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","'Kpɔun nɛn 'mannyan 'ka \"va \"dɩɛ, Zuif 'nɔn -a \"fɛdi -ble 'flɛ 'tʋ. Zɩ 'flɛ zɩɛ e 'bɔ bɛ, -a yi tɛdɛ da nɛn Zozi -srunɔn -ta -a laabʋlɛ -yrɔ 'nan: «Nyin zia nɛn i ya \"vale 'kʋ 'kʋ -kaa tranun 'sidɩ nɔanba -ji \"fɛdi bɛ -cee vɛ man drɛ?» ");
INSERT INTO yreNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ɛn Zozi min -tʋ 'tɔ 'vɩ -wlɛ 'nan 'o 'kʋ \"va. Yaa 'vɩ -wlɛ 'nan: «'Ka 'kʋ Zeruzalɛm, -e 'ka vɩ -yrɛ 'nan: ‹Bali -le 'wɩ \"paazan \"e 'nan, 'kʋ vɩ 'yiɛ 'nan, 'yee tʋ 'bɔ 'kogo. 'Yie 'kuin nɛn 'e -kaa tranun 'sidɩ nɔanba -ji \"fɛdi -ble 'o 'vale 'e -srunɔn 'a.› » ");
INSERT INTO yreNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","'Wɩ nɛn Zozi -a 'vɩ -wlɛ \"bɛ -a -srunɔn -a drɛla \"da, ɛn o \"fɛdi zɩɛ -a man drɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Zɩ funninmlan 'pla bɛ, ɛn Zozi 'lee 'e -srunɔn 'fuda \"fli \"nyran fɛnun -sru. ");
INSERT INTO yreNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","O ya fɛnun -blɩnan ɛn Zozi \"e 'nan -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min -tʋ a 'ka yei 'gʋ, -yɛɛ 'an -nɔan \"minnun lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","'Wɩ zɩɛ e o ta drɛ 'trɔdrɔ \"fo, ɛn waa laabʋdɩ 'sia -yrɔ \"tʋdʋ 'nan: «Minsan, 'an 'bɔ nɛn?» ");
INSERT INTO yreNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Min nɛn 'kʋ 'vale -a 'kʋ 'pɛ wla 'pɔ -tʋwli \"ji 'gʋɛ, -a san 'bɛ 'an -nɔan \"minnun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'Wɩ 'kpa nɛn, 'an 'bɔ Blamin -pɩ an -kaa, zɩ waa crɛn -tɛ Bali -le 'fluba 'ji zɩɛ. 'Pian min nɛn yaan 'bɔ Blamin -pɩ -nɔan \"minnun lɛ bɛ, 'wɩ -taa \"bɔlɛ -a san man. E ya paan -a san -le 'wɩ \"yi \"a -e 'o vɩlɛ o -ya dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","-A -nan nɛn Zudazi nɛn e \"ta -daa -a -nɔnlɛ Zuif 'nɔn 'tanɔn lɛ bɛ, yaa 'si \"va. Yaa laabo -yrɔ 'nan: «Bali -le 'wɩ \"paazan, 'an 'bɔ nɛn?» Ɛn Zozi \"e 'nan -yrɛ 'nan: «'Yiɛ 'bɛ 'vɩ 'i 'bɔ 'a.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","O -fʋ fɛnun zɩɛ -a -blɩnan, ɛn Zozi 'kpɔun 'si, e Bali muo \"fɔ, yaa \"nɛn jɛɛn, ɛn yaa -nɔn 'e -srunɔn lɛ. E 'nan -wlɛ 'nan: «'Ka 'si, 'ka -blɩ! -Nyrɛn 'gʋɛ, 'an 'kɔlɛ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","\"Bɛ -sru e 'kulenɛn nɛn rɛzɛn -wɛn cɩ -ji bɛ -a 'si, e Bali muo \"fɔ, ɛn yaa -nɔn 'e -srunɔn lɛ. E 'nan -wlɛ 'nan: «'Ka mlin 'ka pɛɛnɔn! ");
INSERT INTO yreNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","-Nyrɛn 'gʋɛ, 'an nyɛn nɛn. -A 'bɔ nɛn Bali \"ta -a \"sia -e 'e blamin 'lee 'e 'bɔ yei \"sɛn 'e cin va. E \"ta -sɛanla 'nan -e Bali 'e min \"kaga \"le 'wɩ 'wlidɩ 'fui. ");
INSERT INTO yreNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Maan ve 'cɛɛ 'nan, ma'an \"nyian rɛzɛn -wɛn 'mlian dɩ, -trilii -e yi nɛn -kaa pee -mlian 'e cin va 'an \"tɩ \"le mingɔnnɛn trɛda bɛ 'e bɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Zɩ o cɛɛn fɛnun -blɩdɩ man bɛ, o Bali 'tɔ bɔ \"dre \"fɔ. \"Bɛ -sru ɛn o -kʋ Olivie pɔn da. ");
INSERT INTO yreNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tɔɔn Zozi \"e 'nan -wlɛ 'nan: «Cɛɛgʋ -pei 'gʋɛ -a man bɛ, 'ka pɛɛnɔn 'ci -taa \"srɛlɛ, -e 'ka 'si 'an -sru. Kɔɔ e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan: ‹Bali \"e 'nan, e 'bla -sru \"pinzan -tɛa -e 'blanun 'o fuila \"man.› ");
INSERT INTO yreNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","'Pian \"bɛ -sru, -te an wluan 'kanɔn 'va bɛ, an -tɔala 'ka 'lɛ Galile 'lɛglɔn 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ɛn Piɛri \"e 'nan -yrɛ 'nan: «-Te 'yie \"wɛan min pɛɛnɔn 'ci srɛman -e 'o 'si 'i -sru \"bɛ, 'an 'tʋwli 'gʋɛ, ma'an 'sia 'i -sru 'li \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","-A -nan nɛn Zozi \"e 'nan -yrɛ 'nan: «Maan ve 'yiɛ 'wɩ tɩglɩ 'a 'nan, -pei 'bɔ 'gʋɛ -a man bɛ, yia ve 'e 'pa -a yaaga 'nan, yi'an 'tɔa dɩ, 'vaa -e mannɛn tɛdɛ 'e 'wɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ɛn Piɛri -a 'vɩ -yrɛ 'nan: «-Te e ya 'nan kʋɛ -kaa 'kʋ 'vale 'yia oo, ma'an dra zɩɛ \"fo \"dɩ.» Ɛn -a -srunɔn pɛɛnɔn \"o 'wɩ 'tʋwli zɩɛ -a 'vɩ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","\"Bɛ -sru Zozi 'lee 'e -srunɔn 'kʋ fei nɛn waa laabo Zezemani bɛ -a da. Ɛn e 'nan -wlɛ 'nan: «'Ka 'nyran 'gʋ! An \"ta 'sia 'ka \"srɔn -e 'an Bali trʋ 'ba.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","E Piɛri 'lee Zebede -pɩ \"fli \"fɔ 'e -sru, ɛn o -kʋ waa. -A -nan nɛn Zozi 'ta drɛdɩ 'sia 'trɔdrɔ te \"klan -a -tɛa. ");
INSERT INTO yreNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ɛn e 'nan -wlɛ 'nan: «'An 'ta nɛn e drɛ 'trɔdrɔ 'gʋɛ, e \"mlianla 'an da. 'Ka 'fʋ 'gʋ, -e -kaa yi 'sɔn 'e cin va!» ");
INSERT INTO yreNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","E pli 'e 'lɛ \"wɛnnɔn, e blula \"tra, ɛn e Bali trʋ 'badɩ 'sia. Yaa 'vɩ 'nan: «'An \"tɩ, 'i yra 'si! -Te i \"we \"man \"bɛ, 'kulenɛn nɛn 'wɩ yɩdɩ cɩ -ji e -taa 'labɛ, 'i drɛ -e 'e \"paala 'an man! 'Pian te 'e drɛ 'an 'ci 'sɔ wɩ -a dɩ, 'i 'bɔ 'ci 'sɔ wɩ nɛn 'e drɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","\"Bɛ -sru ɛn e 'li 'e da 'e -srunɔn yaaga zɩɛ o va. E 'bɔ o man te o ya yi -tɛnan, e Piɛri fuʋ, ɛn yaa 'vɩ -yrɛ 'nan: «Ka'a -kɔlalɛ 'padɩ -a 'an 'va -e 'ka yi 'sɔn tʋ \"wɛnnɛn 'gʋɛ -a wlu dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","'Ka yi 'sɔn -e 'ka Bali trʋ 'ba, \"tɔgɔ 'wɩ 'wlidɩ 'e 'ka 'man yɩ! Blamin a \"va 'nan 'e 'wɩ \"yi \"dra, 'pian -a 'plɛblɛ 'ka -yrɔ \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Zozi 'li -bei \"flizan 'wʋ 'e da, ɛn e Bali trʋ 'ba \"nyian. Yaa 'vɩ 'nan: «'An \"tɩ, 'i yra 'si! -Te i 'ka \"vale 'i \"we \"man -e 'kulenɛn nɛn 'wɩ yɩdɩ cɩ -ji e -taa 'labɛ, e \"paala 'an man dɩɛ, 'i 'ci 'sɔ wɩ nɛn 'e drɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","E 'li 'e da, ɛn e 'bɔ o man \"nyian yi -tɛnan, kɔɔ o \"koe \"nyan. ");
INSERT INTO yreNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Zozi o 'tʋɩ \"nyian, ɛn e -kʋ Bali trʋ 'balɛ. -A cɛin yaagazan nɛn te e 'wɩ 'tʋwli zɩɛ -a ve Bali lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","-A -nan nɛn e 'li 'e da 'e -srunɔn 'va, ɛn yaa laabʋ -wlɔ 'nan: «Ka yi -tɛa tian, te ka \"flianla 'ka man -a -trɔɔ? Maan ve 'cɛɛ 'nan, -a tʋ 'bɔ \"mɛn. Tʋ nɛn, minnun 'an 'bɔ Blamin -pɩ -nɔan 'wɩ 'wlidɩ \"drɛnɔn lɛ bɛ, e 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","'Ka 'wluan lou, -e -kaa kʋ! Min nɛn e \"ta 'an -nɔan \"minnun lɛ bɛ, e ya -plinan 'kogo.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Zozi 'fʋ 'wɩ zɩɛ -a vɩnan, tɔɔn ɛn Zudazi nɛn -a -srunɔn 'fuda \"fli 'bɔ 'va min -tʋ -a bɛ, e 'bɔla. -Wɛɛ cɩ 'o 'vale min \"kaga \"a, ɛn sɛnnun 'lee yibanun a -wlɔ. Bali -pannɔn 'tanɔn 'lee min cejenun 'bɛ o 'pa 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zudazi -a 'vɩ 'e 'cɛn minnun zɩɛ -wlɛ 'nan: «Min nɛn an -atu -tɛ \"man \"bɛ, te Zozi nɛn. -A 'bɔ nɛn 'ka 'kun!» ");
INSERT INTO yreNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","-Yee \"wɛan zɩ o 'bɔla bɛ, tɔɔn ɛn e pli Zozi man. E 'nan: «'An 'san, mɛin 'tɔ bo.» -A -nan nɛn e -atu -tɛ \"man. ");
INSERT INTO yreNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ɛn Zozi \"e 'nan -yrɛ 'nan: «'An bee, 'wɩ nɛn i -ta \"man \"bɛ, 'i drɛ!» Tɔɔn minnun nɛn e -ta waa bɛ, o Zozi 'kun. ");
INSERT INTO yreNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","-A -nan nɛn Zozi -sruzan -tʋ 'yee sɛn 'sʋ 'ji, ɛn e Bali -pannɔn 'tazan 'suzan 'tʋ \"trɔɛn cɛɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","'Pian Zozi \"e 'nan -yrɛ 'nan: «'I 'yie sɛn wʋ 'e 'kɔlɛ 'ji! Maan ve 'yie 'nan, minnun pɛɛnɔn nɛn o sɛn \"siala min man bɛ, sɛn \"nɛn \"nɛn o -kaala. ");
INSERT INTO yreNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","'I 'tɔ 'nan, \"te an ya \"va 'nan min 'e 'pa 'an va bɛ, maan ve 'an \"tɩ \"lɛ 'nan, 'e 'yee 'pasianɔn nɛn laji bɛ, o 'pa 'sia 'mɛn. O 'kɔn -kuli 'pa 'tʋdʋ -fuda 'fiili, -e 'waan 'ta kuli -tan. ");
INSERT INTO yreNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","'Pian -te 'wɩ zɩɛ e drɛ bɛ, 'wɩ nɛn e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, ya'a 'kɔlaman -e 'e 'lɛ sɔɔ dɩ. Kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan, zɩ 'e drɛ zɩɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ɛn Zozi 'a 'vɩ min \"kaga zɩɛ -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn ka -ta 'an 'kunlɛ 'ka 'lɔ le sɛnnun 'lee yibanun -a \"le ka -ta crinzan -sru? Tʋ pɛɛnɔn man an ya Bali -pan 'kuin, te an Bali -le 'wɩ \"paaman 'ka 'ji, ɛn ka'an 'kunlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","'Pian 'wɩ pɛɛnɔn zɩɛ, e drɛ -e 'wɩnun nɛn Bali 'lewei vɩnɔn -a crɛn -tɛ 'e 'cɛn bɛ 'e 'lɛ sɔɔ.» -A -nan nɛn Zozi -srunɔn pɛɛnɔn 'wi \"man -a -sru, ɛn o flan bli. ");
INSERT INTO yreNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Minnun nɛn o Zozi 'kun bɛ, o -kʋ Zozi 'a Bali -pannɔn 'tazan nɛn waa laabo Kaifa bɛ, -yee \"kɔnnɛn. 'Fluba 'ci vɩnɔn 'lee min cejenun 'o cin 'yɩ fɛ zɩɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piɛri -fʋ -kɔɔbli, te e -kʋla Zozi -sru. E -kʋ zɩɛ -trilii, ɛn e 'bɔla Bali -pannɔn 'tazan -le \"kɔnnɛn. E wla -yee -klɔn -ji, ɛn e -nyran -a 'sunɔn yei, 'wɩ nɛn e bɔa Zozi man bɛ -a -nan yɩdɩ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bali -pannɔn 'tanɔn 'lee tin 'banɔn pɛɛnɔn a \"va 'nan o 'wlu wɩ -tʋ \"paa Zozi da, -e 'o -kɔla -a -tɛdɩ -a -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Min \"kaga 'wlu 'sɛn Zozi man, 'pian 'wɩ pɛɛnɔn zɩɛ ya'a tin -tɛlɛ Zozi da \"fo \"dɩ. \"Bɛ -sru min \"fli \"ta ɛn \"o 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Min 'labɛ e 'nan: ‹'An -kɔlaman Bali -pan 'kɔn 'widɩ -a, -e 'an pee -tɔ yi yaaga 'wlu.› » ");
INSERT INTO yreNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","-A -nan nɛn Bali -pannɔn 'tazan wluan lou, ɛn yaa 'vɩ Zozi lɛ 'nan: «'Wɩ nɛn minnun -a ve 'i man bɛ, yi'a sia \"va \"dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Zozi 'ka -a 'silɛ \"da -yrɛ \"dɩ. Ɛn Bali -pannɔn 'tazan -a 'vɩ -yrɛ 'nan: «'I 'pɛ wluan Bali nɛn -a yiɛ cɩ \"man \"bɛ -a 'lɛ! Maan laabo 'i 'lɔ 'nan, min 'sizan 'wɩ 'ji nɛn yia? Bali -pɩ nɛn yia? 'Wɩ zɩɛ 'i -ci 'si 'kʋɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ɛn Zozi \"e 'nan -yrɛ 'nan: «-Nyrɛn, yia 'vɩ 'i 'bɔ 'a bɛ. Maan ve 'cɛɛ 'nan, -e 'e 'sia cɛɛgʋ yi 'gʋɛ -a da bɛ, kaan 'bɔ Blamin -pɩ ye 'an -nyrandɩ 'plɛblɛ pɛɛnɔn 'san Bali -pɛ \"yi \"da. Ɛn \"bɛ -sru kaan ye \"nyian laji, te an ya -tanan \"lolu -koei \"da.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","-A vɩdɩ zɩɛ e Bali -pannɔn 'tazan ta kli, ɛn 'e 'ta sɔnun 'fʋɩ bʋdɩ 'sia. -A -nan nɛn e 'nan: «E Bali srɔn! -Kaa 'ka \"nyian -yee 'wɩ 'nan yɩzan pee -va \"fo \"dɩ. \"Srɔn nɛn e \"sia -a wʋnan bɛ, kaa 'man 'ka 'bɔ 'a. ");
INSERT INTO yreNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","\"Ka \"ve -ji 'nɔn?» Ɛn minnun -a 'si \"va -yrɛ 'nan: «E 'sɔ -ka vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","'Wɩ zɩɛ -a da nɛn, o 'le 'yi 'sɛndɩ 'sia -a yra, ɛn o -fɔlɛ wʋʋdɩ \"va 'sia. Min -mienun 'pa -fɔa -a yra, te waa laabo -yrɔ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«'Yie 'nan min 'sizan 'wi 'ji nɛn 'yia. -Yee \"wɛan -te i ya Bali 'lewei vɩzan a bɛ, min nɛn e fɛ tuʋ 'yiɛ bɛ, 'i -kɔɔn 'kʋɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tʋ zɩɛ -a wlu bɛ, te Piɛri a tian 'e -nyrandɩ -klɔn -ji. -A -nan nɛn nɔan lɩmɔn -tʋ pli \"man, ɛn e 'nan -yrɛ 'nan: «Bii 'gʋɛ Galile min Zozi -sruzan 'tʋ nɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","'Pian Piɛri yɔɔ \"da min pɛɛnɔn yiɛ man. E 'nan: «'Wɩ nɛn i cɩ \"vale 'i ve bɛ, ma'an tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɛn Piɛri -klɔn -yrɛ \"nɛn -si 'sia, -a -nan nɛn nɔan lɩmɔn pee -a 'yɩ, ɛn yaa 'vɩ minnun nɛn fɛ zɩɛ -a -nan bɛ -wlɛ 'nan: «Min 'lagʋɛ, e ya Nazarɛtɩ min Zozi -sruzan 'tʋ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piɛri yɔɔ \"da \"nyian, yaa -ci -pɛ wluan, ɛn e 'nan: «Min 'labɛ, ma'an tɔa \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","\"Bɛ -sru \"nyian, minnun nɛn fɛ zɩɛ -a -nan bɛ, o pli Piɛri man ɛn o 'nan -yrɛ 'nan: «'Wɩ 'kpa nɛn. 'I 'bɔ 'gʋɛ, -a -sruzan -tʋ nɛn 'yia. 'Yie 'wɩdɩ -a kɔɔn \"man zɩɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","-A -nan nɛn Piɛri \"e 'nan: «-Te 'wlu nɛn maan -sɛan \"bɛ, Bali 'e 'wɩ \"nɛn -kɔɔn 'mɛn. Maan 'vɩ 'cɛɛ 'nan, ma'an min 'labɛ -a tɔa \"fo \"dɩ.» 'Nun tɔɔn ɛn mannɛn wɩɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Wɩ nɛn Zozi -a 'vɩ Piɛri lɛ bɛ, ɛn -a -cin -trɔa Piɛri ji. Kɔɔ Zozi -a 'vɩ -yrɛ 'nan: «'Vaa -e mannɛn tɛdɛ 'e 'wɩ bɛ, te yia 'vɩ 'e 'pa -a yaaga 'nan yi'an 'tɔa dɩ.» -A -nan nɛn Piɛri 'bɔla bei, ɛn e -wuɔdɩ 'sia 'wɩ 'nanmandɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Zɩ tʋ cɛɛn bodrun bɛ, ɛn Bali -pannɔn 'tanɔn 'lee min cejenun pɛɛnɔn 'wei 'pa 'e cin man 'nan 'o Zozi 'tɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","O Zozi yrɩ, \"bɛ -sru ɛn o -kʋ -a -nɔnlɛ Rɔm min -kɔnmandan Pilati lɛ. Mingɔnnɛnnun tazan nɛn Rɔm bɛ, -yɛɛ Pilati -tɔ 'nan 'e 'lɛglɔn 'bɔ 'pla. ");
INSERT INTO yreNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zudazi 'bɔ nɛn, e Zozi -nɔn minnun lɛ bɛ, zɩ yaa 'yɩ 'nan minnun tanɔn tin -tɛ Zozi da 'nan 'e -ka -a 'wɩ 'ji bɛ, -a -nan nɛn 'wɩ 'nandɩ \"man 'sia, ɛn e -kʋ 'lein 'wlɛ 'fuba yaaga bɛ -a -nɔnlɛ Bali -pannɔn 'tanɔn 'lee min cejenun lɛ 'e \"pa 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","E 'nan -wlɛ 'nan: «An 'wɩ 'wlidɩ drɛ min nɛn ya'a 'wɩ 'tʋ drɛlɛ -wlidɩ \"dɩɛ, -a -nɔndɩ -a 'cɛɛ.» -A -nan nɛn minnun zɩɛ o 'nan Zudazi lɛ 'nan: «\"Kʋe 'man wɩ 'ka 'ji dɩ. 'I 'bɔ 'lɔ wɩ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tɔɔn Zudazi 'lein 'wlɛnun zɩɛ -a -sran Bali -pan 'kuin, ɛn e -kʋ 'e 'blɔ wʋlɛ baa -ji. ");
INSERT INTO yreNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bali -pannɔn 'tanɔn 'lein 'wlɛnun zɩɛ -a koola, ɛn o 'nan: «-A -si 'ka -kaa 'lɔ -e -kaa \"lala 'gʋɛ -a -sɛn Bali -pan 'kuin \"lala -va dɩ, kɔɔ \"lala nɛn yaa -maan blamin nyɛn -sran bɛ -nyrɛn.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","'Wɩ nɛn 'kɔ 'o drɛ \"lala zɩɛ -a bɛ, o wei drɛ \"da -tʋwli. -A -nan nɛn o -kʋ fei 'lɔlɛ -pɔ -tɔzan -tʋ -lɔ. Fei zɩɛ waa 'lɔ 'nan -e 'e drɛ -pɛnnɔn 'le min wʋnan -a. ");
INSERT INTO yreNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","'Bɛ nɛn -kaa cɩ cɛɛgʋ yi -a 'gʋɛ, minnun fei zɩɛ -a laabo nyɛn fei, kɔɔ \"lala zɩɛ -yɛɛ -maan blamin nyɛn -sran. ");
INSERT INTO yreNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","'Wɩ nɛn Bali 'lewei vɩzan Zeremi -a 'vɩ 'e 'cɛn bɛ, zɩ e 'lɛ sɔɔ zɩɛ. Kɔɔ yaa 'vɩ 'nan: «'Lein 'wlɛ 'fuba yaaga nɛn waa 'si min nɛn Izraɛl 'nɔn 'a 'flɛ 'tan bɛ -a manvɛ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ɛn \"lala -tʋwli zɩɛ -a 'bɔ nɛn waa -nɔn -pɔ -tɔzan -le fei man. Zɩ Minsan -a 'vɩ 'mɛn zɩɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Zɩ minnun 'bɔla Zozi 'a -kɔnmandan 'lɛ bɛ, ɛn -kɔnmandan 'wɩ laabʋ -yrɔ. Yaa laabʋ -yrɔ 'nan: «Zuif 'nɔn 'le mingɔnnɛn nɛn 'yia?» Zozi \"e 'nan -yrɛ 'nan: «-Nyrɛn, yia 'vɩ 'i 'bɔ 'a bɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","'Wɩnun nɛn Bali -pannɔn 'tanɔn 'lee min cejenun -a 'vɩ Zozi man bɛ, Zozi 'ka 'wɩ 'tʋ 'silɛ \"da \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","-A -nan nɛn Pilati \"e 'nan -yrɛ 'nan: «'Wɩ pɛɛnɔn nɛn waa \"paa 'i da bɛ, yi'a maan dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","'Pian Zozi 'ka 'wɩ 'tʋ 'silɛ \"da -yrɛ \"fo \"dɩ. 'Wɩ zɩɛ e -kɔnmandan 'kan 'e 'ciɩla \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lɛ -tʋdʋ pɛɛnɔn man bɛ, -te Zuif 'nɔn tranun -le 'sidɩ nɔanba -ji \"fɛdi drɛdɩ 'bɔ bɛ, -kɔnmandan \"sia -pʋ 'kɔnzan 'tʋ man. -Pʋ 'kɔnzan nɛn minnun cɩ \"va 'nan 'o 'si man bɛ, -a man nɛn e \"sia. ");
INSERT INTO yreNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lɛ 'bɔ zɩɛ -a -ji bɛ, te min -tʋ nɛn e 'wɩ 'wlidɩ -dan drɛ -a 'wɩ a 'e fuiladɩ \"man \"bɛ e ya -pʋ 'kuin. Min zɩɛ waa laabo Barabazi. ");
INSERT INTO yreNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","-Yee \"wɛan zɩ minnun a 'o cin yɩdɩ bɛ, ɛn Pilati -a laabʋ -wlɔ 'nan: «Barabazi 'lee Zozi nɛn waa laabo min 'sizan 'wɩ 'ji bɛ, -tɩ man nɛn 'an 'si o \"fli yei?» ");
INSERT INTO yreNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilati -a -tɔa 'nan minnun tanɔn \"naan Zozi man 'e \"tun, -yee \"wɛan nɛn o -ta Zozi 'a 'yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilati a 'e -nyrandɩ 'yee tin 'ba pɛin -da tin -sru, ɛn -a nan min 'pa 'sia -yrɛ. E 'nan: «Min 'labɛ ya'a 'wɩ 'tʋ drɛlɛ -wlidɩ \"dɩ. Te 'i 'pɛ wʋ -yee 'wɩ 'ji dɩ. Kɔɔ paan 'pei -man nyrin nɛn maan -tɛ bɛ, 'an \"koe 'nyan -yee \"wɛan 'kpa tɩglɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tʋ zɩɛ -a wlu bɛ, Bali -pannɔn 'tanɔn 'lee min cejenun -a 'vɩ minnun lɛ 'nan, 'o vɩ 'nan Barabazi man nɛn Pilati 'e 'si -e 'e Zozi 'tɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","-Yee \"wɛan nɛn zɩ -kɔnmandan -a laabʋ -wlɔ \"nyian 'nan: «Min \"fli 'gʋɛ o yei \"bɛ, -tɩ man nɛn 'an 'si?» Ɛn o pɛɛnɔn -a 'vɩ 'nan: «Barabazi man nɛn 'i 'si.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilati -a laabʋ -wlɔ 'nan: «Zozi nɛn waa laabo min 'sizan 'wɩ 'ji bɛ, 'an drɛ -yrɛ 'kɔ?» Ɛn o pɛɛnɔn -a 'vɩ -yrɛ 'nan: «'I -pɛin yiba \"plan da.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","-A -nan nɛn Pilati -a laabʋ -wlɔ 'nan: «'Wɩ 'wlidɩ \"cɛn \"nɛn yaa drɛ -yee \"wɛan 'an -pɛin yiba \"plan da?» Ɛn o pɛɛnɔn paan \"nyian 'kpa 'plɛblɛ. Waa 'vɩ 'nan: «'I -pɛin yiba \"plan da!» ");
INSERT INTO yreNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilati -a 'yɩ 'nan, 'e 'ka o 'klɩnan 'wɩ 'a dɩ, te minnun plaman \"bʋʋ. -A -nan nɛn e 'yi 'si, 'e 'pɛ -man foe minnun pɛɛnɔn yiɛ man, ɛn e 'nan -wlɛ 'nan: «Mɛɛn \"cɛɛ vɩ 'nan o min 'lagʋɛ -a -tɛ dɩ. -Te e -ka bɛ, 'ka 'bɔ 'lɔ 'wɩ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɛn minnun wɩɩ \"man o pɛɛnɔn. Waa 'vɩ 'nan: «-A -ka wɩ 'e 'pa 'kʋ da, ɛn 'e 'pa 'kʋe 'nɛnnun da.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","-A -nan nɛn Pilati 'si Barabazi man, ɛn yaa 'vɩ 'yee 'sounjanun lɛ 'nan, 'o Zozi 'sɔn -ngble -a, -e 'o 'kʋ -a -pɛin yiba \"plan da. ");
INSERT INTO yreNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","-Kɔnmandan -le 'sounjanun -kʋ Zozi 'a -kɔnmandan -le -klɔn -ji. Ɛn o 'sounjanun pɛɛnɔn cin 'yɩ \"man. ");
INSERT INTO yreNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","O -yee sɔnun 'sʋ 'e da, ɛn o mingɔnnɛn -tralɛ -gblɔ 'tɛndɛn 'tʋ 'wʋ \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","O lei 'tan, ɛn waa 'wʋ -a -wulo -man \"le mingɔnnɛn kle 'zʋ. Ɛn o -cɛan -kɔ -tʋ -nɔn -a -pɛ \"yi \"lɛ, \"le -yee mingɔnnɛn \"tonyrin -zʋ. -A -nan nɛn 'o \"po -sɔɔnladɩ 'sia \"wlu, te waa sɛɛ wo. Waa ve -yrɛ 'nan: «Zuif 'nɔn 'le mingɔnnɛn, 'tɩɩ 'tɔ bo!» ");
INSERT INTO yreNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","O 'le 'yi -sɛan \"da, ɛn \"nyian o -cɛan -kɔ \"sia -yrɔ, -e 'o 'lɛ wʋla -a -win -ji. ");
INSERT INTO yreNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Zɩ o cɛɛn -a sɛɛ wʋdɩ man bɛ, ɛn o mingɔnnɛn -tralɛ zɩɛ -a 'sʋ \"da. O -yee sɔnun 'wʋ 'e da, ɛn o -kʋ -a 'nan -e 'o -pɛin yiba \"plan da. ");
INSERT INTO yreNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","'Sounjanun -kʋdɩ 'sia Zozi 'a, ɛn 'o cin 'yɩ Sirene min -tʋ nɛn waa laabo Simɔn bɛ -a. 'Sounjanun 'tɔ Simɔn zɩɛ -a -sru \"sa -a, 'nan 'e Zozi 'le yiba \"plan 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","O 'bɔla fɛnan nɛn waa laabo Gɔlgota bɛ -a -nan. Gɔlgota -ci nɛn 'nan, min -wulo klo. ");
INSERT INTO yreNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","-Wɛn nɛn waa baa fɛ -tʋ nyrannyrandɩ -a bɛ, waa -nɔn -yrɛ 'nan 'e mlin. 'Pian zɩ yaa -nanjɛɛn 'e 'le bɛ, ya'a 'wɩlɛ \"man -e 'e mlin dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Waa -pɛin yiba \"plan da, \"bɛ -sru ɛn o -yee sɔnun pli 'o cin yei. Waa drɛ 'lein 'wlɛ 'tuʋladɩ da. 'Wɩ nɛn Bali 'lewei vɩzan -a 'vɩ 'e 'cɛn bɛ, zɩ e 'lɛ sɔɔ zɩɛ. Kɔɔ yaa 'vɩ 'nan: «O 'mɛn sɔnun pli 'o cin yei, ɛn o 'mɛn sɔ -gblɔ 'sia 'lein 'wlɛ 'tuʋladɩ da.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","\"Bɛ -sru ɛn 'sounjanun -nyran, te o Zozi 'nanjɛan. ");
INSERT INTO yreNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","'Wɩ nɛn -yee \"wɛan o Zozi -pɛin yiba \"plan da bɛ, waa crɛn -tɛ ɛn waa 'pa -a -wulo da lou. Waa crɛn -tɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","O 'wɩ 'wlidɩ \"drɛnɔn \"fli pɛin \"nyian yiba \"plan da. Waa -tʋ pɛin yiba \"plan da Zozi 'pɛ \"yi \"da, ɛn waa -tʋ pɛin yiba \"plan da -a -pɛ bʋ da. ");
INSERT INTO yreNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Minnun nɛn o -ciala fɛ zɩɛ -a -nan bɛ, o Zozi \"srɔnman, te 'o 'wulo nyɔɔnman. ");
INSERT INTO yreNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Waa ve 'nan: «Yiɛ \"cɛɛ 'vɩ 'nan 'i Bali -pan 'kɔn -wia -e 'i pee -tɔ yi yaaga 'wlu 'gʋ dʋʋ? -Te i ya Bali -pɩ -a bɛ, 'i 'fli 'si 'wɩ 'ji, -e 'i 'si yiba \"plan 'labɛ -a da!» ");
INSERT INTO yreNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn 'lee min cejenun \"o sɛɛ 'wʋ \"nyian. \"O 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«E min peenun 'si 'wɩ 'ji, 'pian ya'a 'kɔlaman 'e 'fli 'sidɩ -a 'wɩ 'ji dɩ. -Te e ya Izraɛl 'nɔn 'le mingɔnnɛn -a bɛ, 'e 'si yiba \"plan da 'e -sɔɔnla -e 'kʋ yi -tɛra \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","E yi -tɛra Bali da 'nan Bali \"paa 'e 'va, ɛn yaa 'vɩ 'nan 'e ya Bali -pɩ -a. -Yee \"wɛan -te Bali -a ye \"yi \"bɛ, Bali 'e 'si 'wɩ \"mɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","'Wɩ 'wlidɩ \"drɛnɔn nɛn minnun o pɛin yiba \"plan da Zozi \"srɔn \"bɛ, \"o Zozi srɔn \"nyian 'wɩ 'tʋwli zɩɛ -a vɩdɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Zɩ yidɛ 'bɔ min -win -ji 'sɛzɛ bɛ, ɛn klun -trɔa 'lɛglɔn pɛɛnɔn 'ji. E -fʋ zɩɛ -trilii ɛn funninmlan yidɛ tɛɛnla. ");
INSERT INTO yreNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Zɩ funninmlan yidɛ tɛɛnla bɛ, ɛn Zozi paan 'kpa 'plɛblɛ. Yaa 'vɩ 'e fla wei -ji 'nan: «Eli, Eli lama sabatani?» 'Wɩ zɩɛ -a -ci nɛn 'nan: «'Mɛn Bali, 'mɛn Bali, -mɛ \"le \"wɛan nɛn 'i 'pɛ 'si 'an -sru?» ");
INSERT INTO yreNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Min -mienun nɛn fɛ zɩɛ -a -nan bɛ, waa 'man, ɛn o 'nan: «E ya Eli laabʋnan.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Nun tɔɔn 'sounja min -tʋ flan bli, e -kʋ sɔ 'silɛ, yaa 'wʋ -wɛn 'wlɛ 'cɛn 'va, yaa 'wʋ 'cɛan -kɔ \"nɛn, ɛn yaa 'pa Zozi 'lɛbo \"nɛn 'nan -e 'e 'yi flɔn \"ji. ");
INSERT INTO yreNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","'Pian 'sounja -mienun \"o 'vɩ 'nan: «'I 'tɔ -e -kaa -nan yɩ, -te Eli -taa -a 'silɛ 'wɩ 'ji -o.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Zozi paan \"nyian 'kpa 'plɛblɛ, ɛn 'e yiɛ 'lɛ 'wʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","'Nun tɔɔn sɔ -dan nɛn 'e 'tindɩ Bali -pan 'kuin bɛ, e 'fʋɩ 'bʋ 'ji \"fli. E 'fʋɩ bʋdɩ 'sia lou, ɛn yaa -sɛn \"tra. 'Trɛ nyɔɔn, ɛn puo -kɔlɛnun 'fʋɩ bʋʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Min -yrɛnun 'lɛ sʋʋ, ɛn Bali -le minnun \"kaga wluan 'kanɔn 'va, ");
INSERT INTO yreNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","te o bɔala 'yrɛ -ji. 'Pian zɩ Zozi wluan 'kanɔn 'va bɛ, -a -nan nɛn o -kʋ 'o 'fli -kɔɔnlɛ. 'O 'fli kɔɔn min \"kaga \"lɛ Zeruzalɛm nɛn Bali -le 'fla 'saun -a bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","'Sounjanun tazan 'lee 'yee minnun nɛn 'o yiɛ 'tɔ Zozi 'va bɛ, zɩ 'trɛ nyɔɔn waa -nan 'yɩ bɛ, ɛn 'wɩ pɛɛnɔn nɛn e drɛ waa -nan 'yɩ bɛ, -a \"klan o -tɛdɩ 'sia. -A -nan nɛn waa 'vɩ 'nan: «'Wɩ 'kpa nɛn, min 'labɛ Bali -pɩ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Fɛ 'bɔ zɩɛ -a -nan bɛ, lɩmɔn \"kaga \"a 'o 'tɔdɩ -kɔɔbli, te o yiɛ a -nan nun. Lɩmɔnnun nɛn o sɔɔnla Zozi -sru Galile, te o 'nyranman \"paa Zozi lɛ bɛ o 'bɔ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lɩmɔnnun zɩɛ, Madala lɩ Mari a o va, ɛn Zaji 'lee Zozɛfʋ \"bʋ Mari a o va, ɛn Zebede -pɩnun \"bʋ \"a o va. ");
INSERT INTO yreNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Zɩ funninmlan 'pla bɛ, ɛn fɛzan -tʋ nɛn e 'sia Arimate bɛ e -ta. Waa laabo Zozɛfʋ. Zozi -sruzan 'tʋ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","E -kʋ toba -fɔlɛ Pilati lɛ 'nan 'e Zozi pa -nɔn 'yrɛ. Ɛn Pilati -a 'vɩ 'yee minnun lɛ 'nan 'o -nɔn -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Zozɛfʋ Zozi 'kadɩ zɩɛ -a 'si, e sɔ -trɛdrɛ 'pa \"man, ");
INSERT INTO yreNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ɛn e -kʋ -a wʋlɛ. Yaa 'wʋ min -yrɛ -trɛ nɛn waa cɛɛn puo -kɔlɛ ji bɛ -a -ji. Waa cɛɛn paan -a 'bɔ 'fli -le vɛ -a. \"Bɛ -sru e -kɔlɛ -dan blu, yaa -tɔ -yrɛ zɩɛ -a \"nɛn, ɛn e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tʋ zɩɛ -a wlu bɛ, te Madala lɩ Mari 'lee Mari -tʋ a -nan. O -fʋ 'o -nyrandɩ -yrɛ 'bɔ 'lɛ \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Zɩ tʋ cɛɛn bɛ, Bali -pannɔn 'tanɔn 'lee Farizɛn 'nɔn 'kʋ Pilati -va. Zuif 'nɔn 'le 'flinla \"yi da nɛn o -kʋ. -Yɛɛ cɩ Saba yi -a. ");
INSERT INTO yreNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","O 'nan -yrɛ 'nan: «'Kʋ 'san, 'wɩ 'tʋ -cin -trɔa 'kʋ 'ji, -yee \"wɛan nɛn kʋ -ta. 'Wluzan 'labɛ, te -a yiɛ a tian \"man \"bɛ, e 'nan, -te e -ka bɛ, e yi dra yaaga -e 'e 'wluan 'kanɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","-Yee \"wɛan kʋi trʋ \"baa 'nan 'i vɩ 'yie minnun lɛ -e 'o yiɛ 'tɔ -a -yrɛ -va -trilii yi yaaga. 'I drɛ zɩɛ \"tɔgɔ Zozi -srunɔn 'o 'kʋ Zozi pa 'si -yrɛ -ji, -e 'o 'wlu 'sɛn minnun lɛ 'nan e wluan -kanɔn 'va. 'Wlu zɩɛ 'bɛ 'cibɛn -taa 'mlinlɛ -a tɛdɛ da.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","-A -nan nɛn Pilati \"e 'nan -wlɛ 'nan: «'Sounja 'pa 'tʋ 'labɛ, maan -nɔan 'cɛɛ. 'Ka 'kʋ waa, -e 'o yiɛ 'tɔ -yrɛ 'bɔ 'va \"le zɩ ka cɩ \"va \"bɛ -yee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","O -kʋ, o -yrɛ 'bɔ \"kɔnnɛn 'pla, ɛn o 'sounjanun -tɔ -a 'lɛ \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","'Mɔnnɛn yi nɛn 'bɛ cɩ Zuif 'nɔn 'le 'flinla \"yi -sru \"yi -a. 'Mɔnnɛn yi zɩɛ, -a bodrun puunɔn nɛn Madala lɩ Mari 'lee Mari -tʋzan bɛ, o -kʋ -yrɛ da. ");
INSERT INTO yreNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","'Nun tɔɔn 'trɛ nyɔɔn 'kpa 'plɛblɛ. Minsan -le 'pasiazan -tʋ 'bɛ 'si laji, e -kɔlɛ nɛn waa -tɔ -yrɛ \"nɛn \"bɛ -a 'sinan, ɛn e -nyran \"da. ");
INSERT INTO yreNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","E \"bia \"le zɩ laa 'e 'wlei -wlei -fɔa e \"bia bɛ -yee 'wɩ 'zʋ. Ɛn -yee sɔ a 'fuvu, -a -kɔɔn \"manvɛ \"ka \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nyɛn 'sounjanun cɛɛn, ɛn o nyɔɔndɩ 'sia. -A -nan nɛn o tɛɛla \"tra. O drɛ \"le minnun nɛn o kaa bɛ -wee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ɛn Bali -le 'pasiazan tin 'badɩ 'sia lɩmɔnnun lɛ. Yaa 'vɩ -wlɛ 'nan: «Te \"klan 'e 'ka 'tɛ dɩ! Maan -tɔa 'nan, ka ya Zozi nɛn waa -tɛ yiba \"plan da bɛ -a -wɛɛnan. ");
INSERT INTO yreNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","E 'ka 'gʋ dɩ. E wluan -kanɔn 'va \"le zɩ yaa 'vɩ 'e 'cɛn bɛ -yee 'wɩ 'zʋ. 'Ka 'ta, -e 'ka yiɛ 'tɔ fɛnan nɛn waa 'pla bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","\"Bɛ -sru 'ka 'kʋ \"nyiandʋ -a vɩ -a -srunɔn lɛ. 'Ka vɩ -wlɛ 'nan: E wluan 'kanɔn 'va, e -trɔa 'ka 'lɛ Galile, ka bɔa \"man \"nan nun. 'Wɩ nɛn an -ta -a vɩlɛ 'cɛɛ bɛ, -nyrɛn zɩɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lɩmɔnnun zɩɛ o 'si \"nyiandʋ -yrɛ da. Nyɛn o cɛɛn, 'pian ci \"nrandɩ -dan a -wlɔ, ɛn o -kʋ flan 'blidɩ -a. 'Wɩ zɩɛ o \"ta -ko -a 'sinan 'panan Zozi -srunɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","'Nun tɔɔn Zozi 'bɔla o 'lɛ, ɛn e 'nan -wlɛ 'nan: «An 'ka 'tɔ bo.» Lɩmɔnnun pli Zozi man, o \"po sɔɔn \"wlu, ɛn waa cɛin 'kun -a bɔdɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","-A -nan nɛn Zozi \"e 'nan -wlɛ 'nan: «Te \"klan 'e 'ka 'tɛ dɩ! 'Ka 'kʋ -a vɩ 'an -srunɔn nɛn o drɛ \"le 'an \"bʋɩnun -zʋ bɛ -wlɛ. 'Ka vɩ -wlɛ 'nan 'o 'kʋ Galile. O bɔa 'an man -nan nun.» ");
INSERT INTO yreNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Te lɩmɔnnun a -kʋnan -sia bɛ, -a -nan nɛn 'sounja -mienun 'bɔla Zeruzalɛm 'fla. 'Wɩ pɛɛnɔn nɛn e drɛ bɛ, waa 'sinan 'pa Bali -pannɔn 'tanɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bali -pannɔn 'tanɔn zɩɛ 'o cin 'yɩ 'o 'vale min cejenun -a, ɛn o 'wɩ 'pla \"da. -A -nan nɛn o \"lala \"kaga \"nɔn 'sounjanun lɛ, ");
INSERT INTO yreNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ɛn o 'nan -wlɛ 'nan: «'Ka vɩ 'nan, Zozi -srunɔn 'ta Zozi pa crin wʋlɛ -pei -man, te ka ya yi -tɛnan. ");
INSERT INTO yreNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","'Wɩ zɩɛ -te -kɔnmandan -a 'man bɛ, kʋ toba -fɔa -yrɛ, -e 'kʋ 'wɩ 'si 'ka man.» ");
INSERT INTO yreNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","'Sounjanun \"lala zɩɛ -a 'si, ɛn 'wɩ nɛn Bali -pannɔn 'tanɔn -a 'vɩ -wlɛ \"bɛ, waa drɛla \"da. 'Wɩ nɛn waa 'vɩ zɩɛ Zuif 'nɔn -a ve tian cɛɛgʋ yi -a. ");
INSERT INTO yreNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Zozi -srunɔn 'fuda -tʋ -kʋ Galile, pɔn nɛn Zozi -a kɔɔn -wlɛ \"bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Zɩ o Zozi 'yɩ bɛ, o \"po sɔɔn \"wlu -a bɔdɩ -a. 'Pian te o va min -mienun 'o 'ci -fɔɔman. ");
INSERT INTO yreNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Zozi pli 'e -srunɔn man, ɛn e 'wɩ tin 'ba -wlɛ. Yaa 'vɩ -wlɛ 'nan: «Bali 'plɛblɛ 'nɔn 'mɛn fɛ pɛɛnɔn da laji, ɛn yaa -nɔn 'mɛn fɛ pɛɛnɔn da 'trɛda. ");
INSERT INTO yreNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","'Ka 'kʋ, 'ka 'lɛglɔn pɛɛnɔn 'ji 'nɔn drɛ 'an -srunɔn 'a! 'Ka o -batize drɛ -kaa \"tɩ Bali 'lee 'e 'pɩ 'lee 'yee lei 'saun 'tɔ da. ");
INSERT INTO yreNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ɛn 'wɩ pɛɛnɔn nɛn maan paa 'ka 'ji bɛ, 'ka \"paa o ji, -e 'o 'ta wʋla \"da \"le \"wɛan. Ɛn -a -cin 'e 'kɔn 'ka 'ji 'nan, an -fo 'ka 'va yi pɛɛnɔn man 'li 'trilii, -e 'trɛ 'nyan tʋ 'e bɔ.»");
INSERT INTO yreNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Bali -pɩ Zozi Crizi -le 'wɩ 'nɔnnɔn pou sianan \"nɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","E pou 'sia \"le 'wɩ nɛn 'e 'crɛn -tɛdɩ Bali 'lewei vɩzan Ezai -le 'fluba 'ji bɛ, -yee 'wɩ 'zʋ. Kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan: «Bali \"e 'nan: ‹An 'mɛn min -tʋ -tɔala 'i 'lɛ, -yɛɛ 'i 'lɛ si -tɛa.› ");
INSERT INTO yreNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Min zɩɛ -a wei \"we \"bui \"da. Yaa ve 'nan: ‹'Ka Minsan -le -si ta drɛ! 'Ka -yee -sinun ta -sɛn 'e cin va!› » ");
INSERT INTO yreNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Min zɩɛ Zan nɛn. E 'bɔla 'ji \"bui \"da, ɛn e Bali -le 'wɩ vɩdɩ 'sia minnun lɛ. Yaa 'vɩ -wlɛ 'nan: «'Ka 'si 'wɩ 'wlidɩ \"drɛdɩ man, -e 'ka 'fli -nɔn Bali lɛ! 'Ka 'ta 'ka -batize drɛ, -e Bali 'e 'cee 'wɩ 'wlidɩ 'fui.» ");
INSERT INTO yreNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Minnun nɛn o -nyɛanla Zude 'lɛglɔn 'ji 'lee Zeruzalɛm bɛ, o \"kaga \"ta Zan wei manlɛ. O 'wee 'wɩ 'wlidɩnun 'vɩ 'wein Bali lɛ minnun pɛɛnɔn yiɛ man, te Zan o -batize dra 'yi nɛn waa laabo Zudan bɛ, -a va. ");
INSERT INTO yreNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","-Wi nɛn waa laabo Shamo bɛ, -a \"cɛsɔ nɛn Zan da, ɛn -wi 'kɔlɛ nɛn 'e 'tɔdɩ \"da -a -tiɛn. Srɔ 'lee -srɔ 'nyrɔn nɛn yaa -ble fɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","E 'nan minnun lɛ 'nan: «Min -tʋ \"ta -daa 'e 'fɔla \"da, ɛn -a 'plɛblɛ \"mlian 'an da. 'An 'ka -yee -manwua \"tun \"da baa \"fluzan -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","An 'ka -batize dra 'yi 'a, 'pian -yɛɛ 'ka -batize dra Bali lei 'saun 'a.» ");
INSERT INTO yreNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tʋ zɩɛ -a wlu bɛ, ɛn Zozi 'si Galile 'fla nɛn waa laabo Nazarɛtɩ bɛ -a da, ɛn e -ta Zan -va. -A -nan nɛn Zan -a -batize drɛ Zudan 'yi 'va. ");
INSERT INTO yreNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Zozi \"ɛ 'si 'yia bɛ, te e labli ye 'e 'lɛ 'sʋdɩ, ɛn e Bali lei 'yɩ e sɔɔn \"da \"le -plablo -le 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","-A -nan nɛn wei -tʋ wɩɩ laji. E 'nan: «I ya 'an 'pɩ nɛn maan ye \"yi ɛn -yee 'wɩ 'an 'ci \"nranman bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","\"Bɛ -sru, ɛn Bali lei -kʋ Zozi 'a \"bui \"da. ");
INSERT INTO yreNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","E yi drɛ 'nan nun -fuba sinjɛn, te Satan -a man -taan. E ya -winun va lu -ji, te Bali -le 'pasianɔn -a \"sua. ");
INSERT INTO yreNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Zɩ minnun Zan -fɔ -pʋ 'kuin bɛ, ɛn Zozi 'li 'e da Galile 'lɛglɔn 'ji. -A -nan nɛn e Bali -le 'wɩ 'nɔnnɔn vɩdɩ 'sia minnun lɛ. Yaa 'vɩ -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Tʋ nɛn Bali -a kɔɔn bɛ, e 'bɔ. Bali -le mingɔnnɛn -blɩdɩ 'bɔ 'kogo. 'Ka 'si 'wɩ 'wlidɩ \"drɛdɩ man, -e 'ka 'fli -nɔn Bali lɛ! 'Ka yi -tɛra Bali -le 'wɩ 'nɔnnɔn da!» ");
INSERT INTO yreNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Zozi a ciɩnan 'yi -dan nɛn Galile bɛ -a man, ɛn e Simɔn 'lee 'e -suannɛn Andre 'yɩ, te o ya pɔ -tɛnan \"se \"a. ");
INSERT INTO yreNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Ka -sɔɔnla 'an -sru! An -taa 'ka drɛlɛ minnun nɛn o min laabo 'an -sru \"bɛ waa.» ");
INSERT INTO yreNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","'Nun tɔɔn o 'wee \"senun -sran, ɛn o sɔɔnla Zozi -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","E -kʋdɩ 'sia \"nyian 'e 'lɛ, ɛn e Zebede -pɩnun 'yɩ, te o ya 'wee \"senun -peenan -klʋ -ji. Zaji 'lee 'e \"bʋɩ Zan nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Zozi o laabʋ, -a -nan nɛn o 'si 'o \"tɩ Zebede 'lee 'wee 'nyranman 'panɔn -sru, ɛn o sɔɔnla Zozi -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Zozi 'lee 'e -srunɔn 'kʋ 'fla nɛn, waa laabo Kapanamo bɛ, -a da. 'Flinla \"yi da bɛ, e wla -wee cin yɩ 'kuin, ɛn e Bali -le 'wɩ \"paadɩ 'sia minnun ji. ");
INSERT INTO yreNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","-Yee 'wɩ \"paadɩ minnun 'plo 'fɔ, kɔɔ yaa \"paaman o ji \"le Bali -a -kɔladɩ -nɔn -yrɛ. Ya'a \"paalɛ o ji \"le 'nan 'fluba 'ci vɩnɔn 'le vɛ -zʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Min -tʋ a cin yɩ 'kɔn 'bɔ 'ji bɛ, -yʋ -wlidɩ \"a -a -sru. Min zɩɛ e -paandɩ 'sia, yaa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Nazarɛtɩ min Zozi, -mɛ \"wɛan nɛn i -tɔa 'kʋe 'wɩ 'ji? I -ta 'kʋ klu 'sʋlɛ. Mɛin -tɔa. Bali -le min tɩglɩ nɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Zozi 'wɩ 'pla -yrɛ 'nan: «'I 'ta -tɔ! 'I 'si min 'gʋɛ -a -sru!» ");
INSERT INTO yreNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","-Yʋ -wlidɩ \"min zɩɛ -a nyɔɔndɩ 'sia 'plɛblɛ, te e -paanman, ɛn e 'si -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","'Wɩ zɩɛ e ciɩla min pɛɛnɔn da. Waa laabʋdɩ 'sia 'o cin lɔ 'nan: «-Mɛ \"sʋ -man wɩ 'bɛ cɩ zɩɛ? Min 'gʋɛ -yee 'wɩ \"paadɩ a 'e 'trɛ, ɛn Bali -a -kɔladɩ -nɔn -yrɛ. E -yʋnun -le 'plɛblɛ yi -kaa. 'Wɩ nɛn yaa ve -wlɛ \"bɛ, waa drala \"da.» ");
INSERT INTO yreNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","-A -nan nɛn minnun Zozi 'sɩ -fɔdɩ 'sia 'kpa tɩglɩ Galile 'lɛglɔn pɛɛnɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Zɩ Zozi 'bɔla cin yɩ 'kuin bɛ, ɛn e -kʋ Simɔn 'lee Andre -le \"kɔnnɛn 'o 'vale Zaji 'lee Zan -a. ");
INSERT INTO yreNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","\"Wɛɛ 'bɔla \"kɔnnɛn \"bɛ, te Simɔn nan \"bʋ \"a 'e nyinnandɩ 'kɔlɛ -wɔandɩ 'plɛblɛ 'lɔ, ɛn waa 'vɩ Zozi lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Zozi pli \"man, yaa 'kun 'e 'pɛ -man, ɛn yaa wluan. 'Nun tɔɔn -a 'kɔlɛ 'ji 'e 'trɔ -fɔ. -A -nan nɛn e fɛ -nɔn -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Zɩ funninmlan 'pla yidɛ 'fɔ plɔ va bɛ, ɛn minnun -tadɩ 'sia -cɛ -tɛnɔn pɛɛnɔn 'lee minnun pɛɛnɔn nɛn -yʋ -wlidɩ \"a o -sru \"bɛ waa Zozi lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","'Flanɔn \"kaga \"ta -sɛnlɛ 'kɔn zɩɛ -a 'lɛ \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Zozi min \"kaga beli -cɛ 'tɔ 'tʋdʋ pɛɛnɔn 'sidɩ -a o man. Ɛn e -yʋ -wlidɩ 'si min \"kaga -sru \"nyian. Zozi 'ka -yʋ -wlidɩnun 'tʋɩlɛ -e 'o 'wɩ dɩ, kɔɔ min nɛn Zozi cɩ -a bɛ waa -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bodrun te klun a tian bɛ, Zozi wluan, ɛn e 'bɔla bei. E -kʋ Bali trʋ 'balɛ 'fla -sru fɛnan nɛn -a -nan cɩ flɩɩ bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔn 'lee Zozi -srunɔn -mienun bɛ, o -kʋ Zozi -wɛɛlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Zɩ waa 'yɩ bɛ, ɛn o -yrɛ 'nan: «Minnun pɛɛnɔn a 'i -wɛɛnan.» ");
INSERT INTO yreNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ɛn Zozi 'a 'vɩ -wlɛ 'nan: «-Kaa kʋ fɛ pee -nan! -Kaa kʋ 'fla 'gʋɛ -a \"srɔn 'flanun da, -e 'an Bali -le 'wɩ vɩ -nan nun. Kɔɔ 'wɩ zɩɛ -a man nɛn an -ta 'trɛ da.» ");
INSERT INTO yreNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ɛn e ciɩdɩ 'sia Galile 'lɛglɔn pɛɛnɔn 'ji. E Bali -le 'wɩ 'vɩ cin yɩ 'kɔnnun -ji, te e -yʋ -wlidɩ -pian \"minnun -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yi -tʋ da bɛ, -kogobe 'tɛzan -tʋ -ta Zozi 'lɛ. E \"po sɔɔn \"wlu, ɛn yaa trʋ 'badɩ 'sia. Yaa 'vɩ -yrɛ 'nan: «Maan -tɔa 'nan -te i wɩɩ \"man \"bɛ, i -kɔlaman i -kogobe \"sia 'an man, -e 'an drɛ 'saun Bali 'lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","-A nyrinda -sɛn Zozi da. 'E 'pɛ 'sʋ \"ji, e klɛ \"man, ɛn yaa 'vɩ -yrɛ 'nan: «An \"we \"man! 'I drɛ 'saun Bali 'lɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","'Nun tɔɔn -kogobe 'si \"man, ɛn e drɛ 'saun Bali 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Zozi 'wɩ 'pla -yrɛ -a \"trɔɛn nyuɔndɩ -a. Yaa 'vɩ -yrɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Te 'i 'wɩ nɛn e drɛ 'gʋɛ -a -nan sɛɛ wʋ min -tʋ lɛ \"fo \"dɩ! 'Pian 'i 'kʋ Bali -panzan -tʋ -va -e 'yei 'nanjɛn! \"Bɛ -sru 'sraga nɛn Moizi -a kɔɔn bɛ 'i drɛ, -e minnun 'o -kɔnnɛn \"yɩ 'nan, i beli!» ");
INSERT INTO yreNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","'Pian min zɩɛ 'wɩ nɛn Zozi -a drɛ -yrɛ \"bɛ, yaa 'sinan 'padɩ 'sia min 'tʋdʋ pɛɛnɔn lɛ. -Yee \"wɛan Zozi 'ka -kɔlalɛ \"nyian -e 'e 'fli -kɔɔn 'fla dɩ. Ɛn e -fʋ 'fla -sru fɛnan nɛn min \"ka \"dɩɛ -a -nan. 'Pian te minnun \"sia fɛ pɛɛnɔn 'nan, o -ko \"va \"nun. ");
INSERT INTO yreNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yi 'fli yaa \"bɛ -sru, ɛn Zozi 'li 'e da Kapanamo. Minnun -a 'man 'nan Zozi a \"kɔnnɛn, ");
INSERT INTO yreNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ɛn o \"kaga \"kʋ \"va. Min a \"kaga \"bʋʋ \"le \"wɛan, 'tɔnan 'ka 'fʋlɛ \"nyian 'kɔn 'lɛ \"nɛn \"dɩ. Zozi Bali -le 'wɩ vɩdɩ 'sia -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","-A -nan nɛn, minnun -tadɩ 'sia min -srandɩ -tʋ -a Zozi lɛ. E ya min sinjɛn lɔ \"se \"ji. ");
INSERT INTO yreNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","'Pian wa'a -kɔlalɛ -plidɩ -a Zozi man dɩ, min a \"kaga \"le \"wɛan. -A -nan nɛn o 'kɔn tri, waa 'fɔn 'e 'win -ji fɛnan nɛn Zozi cɩ 'e 'tɔdɩ bɛ -a -nan. O -cɛzan zɩɛ -a sɔɔnla. ");
INSERT INTO yreNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Zɩ Zozi -wee yi -tɛradɩ 'e da 'yɩ bɛ, ɛn yaa 'vɩ -cɛzan zɩɛ -yrɛ 'nan: «'An 'pɩ, 'wɩ 'wlidɩnun nɛn yia drɛ bɛ maan fui.» ");
INSERT INTO yreNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bali -le 'fluba 'ci vɩnɔn -mie a min \"kaga zɩɛ o yei 'o -nyrandɩ. Waa nrɔn 'o 'ji 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«-Mɛ \"wɛan nɛn, min 'labɛ, e 'wɩ zɩɛ -a ve? E Bali srɔn. -Te ya'a 'silɛa Bali -tʋwli \"a dɩɛ, -tɩɛ -kɔlaman min -le 'wɩ 'wlidɩnun fuidɩ -a?» ");
INSERT INTO yreNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Zozi -wee ci \"nrɔndɩ 'yɩ, ɛn yaa 'vɩ -wlɛ 'nan: «-Mɛ \"wɛan nɛn ci \"nrɔndɩ zɩɛ, e ya 'ka 'ji? ");
INSERT INTO yreNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","-Te maan 'vɩ min -srandɩ \"tra 'gʋɛ -yrɛ 'nan: ‹'Wɩ 'wlidɩnun nɛn yia drɛ bɛ maan fui›, 'bɛ a -tʋ. Ɛn -te maan 'vɩ -yrɛ 'nan: ‹'I wluan, 'i 'yie nyinnan \"davɛ 'sia, 'i 'ta wʋ›, 'bɛ a -tʋ. 'Wɩ \"fli zɩɛ, -a \"cɛn \"vɩdɩ 'bɛ cɩ 'plɛblɛ? ");
INSERT INTO yreNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","'Pian an \"ta -a -ci -kɔɔnman 'cɛɛ 'nan -kɔladɩ a 'an 'bɔ Blamin -pɩ -lɔ -e 'an min -le 'wɩ 'wlidɩnun fui 'trɛda.» -A -nan nɛn yaa 'vɩ -cɛzan zɩɛ -yrɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«'I 'wluan! 'I 'yie nyinnan \"davɛ 'sia! 'I 'kʋ 'yie \"kɔnnɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","'Nun tɔɔn min zɩɛ e wluan, e 'yee nyinnan \"davɛ 'sia, ɛn e 'ta wʋdɩ 'sia min pɛɛnɔn yiɛ man, e 'bɔla bei. 'Wɩ zɩɛ e ciɩla 'o pɛɛnɔn da. O Bali 'tɔ \"yi 'vɩ, ɛn waa 'vɩ 'nan: «'Wɩ 'gʋɛ kʋ'a tian 'li -a -nan yɩlɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Zozi 'kʋ \"nyian Galile 'yi man. Min \"kaga \"kʋla -a -sru, ɛn e Bali -le 'wɩ 'nɔnnɔn paa o ji. ");
INSERT INTO yreNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","\"Yɛɛ -kʋ 'e 'lɛ bɛ, te e Alife -pɩ Levi ye 'e -nyrandɩ fɛnan nɛn o 'sukɔlɛ \"sia bɛ -a -nan. E ya 'yee 'nyranman 'panan. Ɛn Zozi -a 'vɩ -yrɛ 'nan: «'I -sɔɔnla 'an -sru!» Levi wluan, ɛn e sɔɔnla -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","\"Bɛ -sru ɛn Zozi 'lee 'e -srunɔn 'kʋ Levi -le \"kɔnnɛn fɛnun -blɩlɛ. 'Sukɔlɛ 'sinɔn 'lee 'wɩ 'wlidɩ \"drɛnɔn -mienun yra fɛ zɩɛ -a -sru. Kɔɔ min \"kaga 'bɛ 'kʋla -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","'Fluba 'ci vɩnɔn nɛn o ya Farizɛn 'nɔn 'a bɛ, zɩ waa 'yɩ 'nan Zozi a fɛ -blɩnan 'o 'vale 'sukɔlɛ 'sinɔn 'lee 'wɩ 'wlidɩ \"drɛnɔn -mienun -a bɛ, ɛn waa 'vɩ -a -srunɔn lɛ 'nan: «-Mɛ \"le \"wɛan nɛn e fɛ blɩ 'o 'vale 'sukɔlɛ 'sinɔn 'lee min -wlidɩ -mienun -a?» ");
INSERT INTO yreNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Zozi 'wɩ zɩɛ -a 'man, ɛn e 'nan -wlɛ 'nan: «Minnun nɛn -cɛ 'ka o man dɩɛ, wa'a -dɔdrɔ -sru -wɛɛman dɩ. 'Pian minnun nɛn -cɛ cɩ o man bɛ, -wɛɛ cɩ -dɔdrɔ -va. Ɛn \"nyian bɛ minnun nɛn o cɩ tɩglɩ bɛ, -wee \"wɛan \"cɛɛ an -ta dɩ, 'pian an -ta 'wɩ 'wlidɩ \"drɛnɔn 'va. An -ta o laabʋlɛ -e 'an Bali -le -si -kɔɔn -wlɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Zan -srunɔn 'lee Farizɛn 'nɔn a fɛ 'sɔnnan. Ɛn minnun -ta 'wɩ laabʋlɛ Zozi 'lɔ 'nan: «-Mɛ \"le \"wɛan nɛn, Zan -srunɔn 'lee Farizɛn -srunɔn fɛ \"sɔan, te \"yie -srunɔn 'ka fɛ sɔan dɩ?» ");
INSERT INTO yreNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «-Te minnun -a lɩ 'pa \"fɛdi drɛnan bɛ, tʋ nɛn lɩ -trɛ 'pazan a o yei \"bɛ, minnun fɛ \"sɔan? -Cɛjɛ, tʋ nɛn lɩ -trɛ 'pazan a o va bɛ wa'a 'kɔlaman fɛ 'sɔndɩ -a dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","'Pian yi nɛn lɩ -trɛ 'pazan -taa 'silɛ o yei \"bɛ, -a nyan nɛn o -taa \"fɛ 'sɔnlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ɛn \"nyian bɛ, min 'ka sɔ -trɛ 'fʋɩ 'sia, -e 'e 'pa sɔ ceje 'fʋɩ bʋnan dɩ. -Te 'bɛ \"cɛɛ \"dɩɛ, sɔ -trɛ -a ceje 'fʋɩ bʋnan \"paa \"va. ");
INSERT INTO yreNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ɛn \"nyian bɛ min 'ka 'wɛn -trɛ sɛan -wi 'kɔlɛ 'tre cejenun -ji dɩ. -Te 'bɛ \"cɛɛ \"dɩɛ, -wɛn -trɛ -wi 'kɔlɛ 'tre cejenun fɛaman, te -wɛn 'lee 'trenun 'bɔ srɛ. 'Pian e ya \"le min 'e 'wɛn -trɛ -sɛn -wi 'kɔlɛ 'tre -trɛnun -ji!» ");
INSERT INTO yreNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","'Flinla \"yi da nɛn, Zozi 'lee 'e -srunɔn 'ciɩdɩ 'sia fei -tʋ da. Fɛ 'wlɛ nɛn fei zɩɛ -a da bɛ, e ya 'lee 'saa 'le 'wɩ 'zʋ. -A -srunɔn 'ko -a \"cɛɛndɩ -a, te waa -ble. ");
INSERT INTO yreNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","-A -nan nɛn Farizɛn 'nɔn -a 'vɩ Zozi lɛ 'nan: «\"I 'yiɔ 'wɩ nɛn 'i -srunɔn -a dra bɛ -a. -Cee 'flinla \"yi da bɛ, wa'a 'wɩ 'labɛ -a dra dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Wɩ nɛn -kaa tra David -a drɛ 'li, te dra -a -tɛa 'o 'vale 'yee minnun -a bɛ, ka'a tian -a ta vɩlɛ dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","E wla Bali -le 'kuin, ɛn Bali -le 'kpɔun nɛn Bali -pannɔn 'saza 'bɛ -ble bɛ, yaa 'sia, yaa blɩ, ɛn e 'yee minnun \"le \"nɔn. Tʋ zɩɛ -a va bɛ, te Abiata 'bɛ cɩ Bali -pannɔn 'tazan -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ɛn Zozi -a 'pla \"da 'nan: «Bali 'flinla \"yi drɛ minnun -le vɛ -a! Ya'a minnun drɛlɛ 'flinla \"yi -le vɛ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","-Yee \"wɛan nɛn 'an 'bɔ Blamin -pɩ, mɛɛn cɩ 'flinla \"yi san -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Zozi 'kʋ pee 'wʋ \"nyian cin yɩ 'kuin. Min -tʋ a 'kɔn zɩɛ -a -ji, -a -pɛla 'tʋ a 'e 'kadɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Farizɛn 'nɔn nɛn 'kɔn zɩɛ -a -ji bɛ, o Zozi 'nanjɛndɩ 'sia -gɔɛɛn 'nan, -te e min zɩɛ -a \"belia 'flinla \"yi da -o. Waa drɛ zɩɛ 'nan -e 'o -kɔla 'wɩ 'tɔdɩ -a \"man. ");
INSERT INTO yreNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Zozi -a 'vɩ -pɛ -kazan lɛ 'nan: «'I 'wluan! 'I 'tɔ min yei 'gʋ!» ");
INSERT INTO yreNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ɛn Zozi -a laabʋ -wlɔ 'nan: «-Mɛ \"wɩ nɛn -cee -pei -a vɩ? -Si a 'e 'nɔndɩ min lɛ 'nan 'e 'wɩ \"yi \"drɛ 'flinla \"yi da, -baa 'wɩ 'wlidɩ \"nɛn e drɛ? Ɛn \"nyian bɛ, e min \"belia, -baa e min \"tʋe -e 'e 'ka?» Min -tʋ 'ka 'wɩ 'silɛ \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Zozi o pɛɛnɔn -nanjɛɛn 'tʋdʋ nyran da. -Wee \"trɔɛn \"yuyu nɛn waa \"taan Bali va bɛ, -yee \"wɛan -a ta drɛ 'trɔdrɔ. -A -nan nɛn yaa 'vɩ -cɛzan zɩɛ -yrɛ 'nan: «'I 'pɛ 'sʋ \"ji!» E 'e 'pɛ 'sʋ \"ji, ɛn -a -pɛ drɛ \"plɔnblɔn 'e \"pa 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farizɛn 'nɔn 'bɔla bei. O -kʋ Erodi -le minnun 'va -a 'palɛa \"da 'nan 'o Zozi 'man -wɛɛ -e 'o -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Zozi 'lee 'e -srunɔn 'kʋ Galile 'yi man. Min \"kaga 'kʋla o -sru. O -mie 'si Galile 'lɛglɔn 'ji, ɛn o -mie 'si Zude 'lɛglɔn 'ji, ");
INSERT INTO yreNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ɛn o -mie 'si Zeruzalɛm, ɛn o -mie 'si Idume 'lɛglɔn 'ji, ɛn o -mie 'si 'lɛglɔn nɛn Zudan 'yi -sru \"bɛ -a -ji, ɛn o -mie 'si 'lɛglɔnnun nɛn Tir 'lee Sidɔn \"srɔn \"bɛ o ji. Min \"kaga zɩɛ o -ta Zozi 'va, kɔɔ 'wɩnun nɛn yaa dra bɛ waa 'man. ");
INSERT INTO yreNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","-Yee \"wɛan Zozi -a 'vɩ 'e -srunɔn lɛ 'nan, 'o 'klʋ -tʋ man wʋʋ, \"tɔgɔ minnun 'o trun 'e man \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Fɛ -le \"wɛan nɛn e 'wɩ zɩɛ -a 'vɩ bɛ -yɛɛ cɩ 'nan, e min \"kaga 'beli, ɛn -cɛnɔn pɛɛnɔn 'o cin -mɛandɩ 'sia 'nan -e 'o klɛ \"man. ");
INSERT INTO yreNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Minnun nɛn -yʋ -wlidɩ \"cɩ o -sru \"bɛ, -te o Zozi 'yɩ bɛ, o -tɛɛmlan \"wlu, te o -paanman 'nan: «Bali -pɩ nɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'Pian Zozi 'wɩ \"paala -wlɛ 'klagla. Yaa ve -wlɛ 'nan: «Te 'ka min nɛn 'an cɩ bɛ -a ta bɔla minnun lɛ dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","\"Bɛ -sru ɛn Zozi pɔn -tʋ tri. Minnun nɛn Zozi cɩ \"va \"bɛ, e o laabʋ 'e 'va. Ɛn o -kʋ -a \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Zɩ e min -fuda \"fli 'si \"va zɩɛ, ɛn e o 'tɔ 'pa 'yee 'pasianɔn. Yaa drɛ zɩɛ 'nan, -e 'o 'kɔn -a \"srɔn. Ɛn yaa drɛ 'nan -e 'o 'kʋ Bali -le 'wɩ vɩ, ");
INSERT INTO yreNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","te -kɔladɩ a -wlɔ -e 'o -yʋ -wlidɩnun -pin minnun -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Minnun nɛn e o 'si \"va \"bɛ, o 'tɔ nɛn 'gʋ: Simɔn nɛn yaa 'tɔ 'pa Piɛri bɛ, ");
INSERT INTO yreNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","'lee Zebede -pɩnun Zaji 'lee 'e \"bʋɩ Zan nɛn Zozi o 'tɔ 'pa Boanɛzi bɛ, -a -ci nɛn 'nan laa -paan \"sʋ -man minnun, ");
INSERT INTO yreNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","'lee Andre, 'lee Filipʋ, 'lee Batelemi, 'lee Matie, 'lee Toma, 'lee Alife -pɩ Zaji, 'lee Tade, 'lee Simɔn -tʋ nɛn waa laabo \"nyian Zelo bɛ, ");
INSERT INTO yreNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","'lee Zudazi Karioti. Min nɛn e \"ta -daa Zozi 'nɔnlɛ 'e 'nanmannɔn lɛ bɛ -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","\"Bɛ -sru ɛn Zozi 'kʋ \"kɔnnɛn. Minnun 'o cin 'yɩ \"nyian \"man \"kaga \"le \"wɛan, Zozi 'lee 'e -srunɔn 'ka 'o 'wulo -da yɩlɛ -e 'o fɛ -blɩ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Zɩ Zozi 'mangulinun 'wɩ zɩɛ -a 'man bɛ, o -si 'sia 'nan 'o 'ko -a 'kunlɛ. Kɔɔ -a -cin a o ji 'nan, -a -wulo srɛ 'e da. ");
INSERT INTO yreNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ɛn \"nyian bɛ, 'fluba 'ci vɩnɔn nɛn o 'si Zeruzalɛm bɛ, o 'nan, -yʋ -wlidɩnun tazan nɛn waa laabo Bɛlzebul bɛ, e ya Zozi -sru. Ɛn -yee 'plɛblɛ 'a nɛn e -yʋnun -pian \"minnun -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","-A -nan nɛn Zozi o laabʋ, ɛn e 'wɩ tin 'badɩ 'sia -kɔnnɛn \"ji. E 'nan: «Satan 'ka 'kɔlaman -e 'e 'bɔ 'fli -pin dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","-Te 'lɛglɔn 'tʋ -ji minnun cɛɛn 'e cin man, ɛn o ya -kuli -tannan 'o cin man bɛ, 'lɛglɔn zɩɛ, e -wia. ");
INSERT INTO yreNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɛn -te 'kɔn 'tʋwli 'lɛ \"nɛn 'nɔn 'bɛ cɩ 'wɩ 'tʋwli zɩɛ -a drɛnan oo, \"kɔnnɛn zɩɛ e -wia. ");
INSERT INTO yreNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","-A -tʋwli \"nɛn \"nyian Satan 'lee -yee -yʋnun -le vɛ -a. \"Te -wɛɛ cɛɛn 'e cin man, ɛn o ya -kuli -tannan 'o cin yei \"bɛ, \"te -yee mingɔnnɛn trɛ -wi -a -nan 'mɔn. ");
INSERT INTO yreNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","'Ka -tɔ 'nan, Satan nɛn e ya min 'plɛblɛ 'a bɛ, min 'ka 'kɔlaman -e 'e -wla -yee 'kuin -e 'e -yee fɛnun crin wʋ, -te ya'a Satan 'bɔ -yrɩlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'wɩ 'wlidɩ pɛɛnɔn nɛn min -a dra bɛ, Bali -kɔlaman -a 'cɛdɩ -a min lɛ. Ɛn \"nyian wei -wlidɩ pɛɛnɔn min -a -fɔa Bali lɛ bɛ, Bali -kɔlaman -a 'cɛdɩ -a min lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","'Pian 'wɩ nɛn Bali lei 'saun -a dra bɛ, min nɛn e \"we \"man -wlidɩ \"bɛ, Bali 'ka -a cɛa -a san lɛ 'li \"fo \"dɩ. 'Wɩ 'kpa, 'wɩ 'wlidɩ zɩɛ e -fo -yrɔ 'li \"fo \"le vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Minnun nɛn o 'nan, -yʋ -wlidɩ \"a Zozi -sru \"bɛ, o 'tɔ 'ji nɛn e 'wɩ zɩɛ -a 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Zozi \"bʋ 'lee -a \"bʋɩnun -ta. O -fʋ 'o 'tɔdɩ bei, ɛn o min -tʋ 'pa 'sia 'nan 'e 'kʋ Zozi laabʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Minnun \"kaga \"a 'o -nyrandɩ Zozi \"srɔn. Waa si -fɔ. O 'nan -yrɛ 'nan: «'I \"bʋ 'lee 'i \"bʋɩnun a bei. O 'nan, 'i 'lʋ!» ");
INSERT INTO yreNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Zozi \"e 'nan -wlɛ 'nan: «-Tɩnun 'bɛ cɩ 'an \"bʋ \"a? Ɛn -tɩnun 'bɛ cɩ 'an \"bʋɩnun -a?» ");
INSERT INTO yreNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Zɩ e 'wɩ zɩɛ -a 'vɩ bɛ, e minnun nɛn waa si -fɔ bɛ, o -nanjɛɛn, ɛn e 'nan: «\"Ka 'yiɔ! 'An \"bʋ 'lee 'an \"bʋɩnun nɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Fɛ nɛn maan 'vɩ zɩɛ -yɛɛ cɩ 'nan, min nɛn e Bali ci 'sɔ wɩ dra bɛ, -yɛɛ cɩ 'an \"bʋɩ -a, ɛn -yɛɛ cɩ 'an \"blu \"a, ɛn -yɛɛ cɩ 'an \"bʋ \"a.» ");
INSERT INTO yreNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yi -tʋ da bɛ, Zozi 'wɩ \"paadɩ 'sia minnun ji \"nyian Galile 'yi man. Minnun a trenan \"man \"kaga, -yee \"wɛan e -fɔ -klʋ -ji 'yi yiɛ da, ɛn e -nyran. Minnun -fʋ 'o 'sɛndɩ 'yi 'plo da. ");
INSERT INTO yreNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","-Kɔnnɛn \"ji nɛn e 'wɩ \"kaga paa o ji. Yaa 'vɩ -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«\"Ka 'yiɔ 'wɩ 'tʋ nɛn 'gʋ! 'Ka \"trɔɛn \"tɔ -yrɛ! Min -tʋ 'bɛ 'kʋ 'saa 'fɔlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Zɩ e ya -a wɛɛnnan bɛ, -a 'wlɛ plɔɛn 'sran -si man. \"Lomannun -ta, waa blɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","-A 'wlɛ -mie -sran puo da, fɛnan nɛn 'trɛ 'ka \"kaga \"dɩɛ -a -nan. E bɔdɩ 'sia tada, kɔɔ 'trɛ 'ka \"da \"kaga \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Zɩ yidɛ 'bidɩ 'sia bɛ, ɛn e kaala 'nan, -a \"sɛin 'ka 'kʋlɛ -kɔɔbli dɩ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","-A 'wlɛ plɔɛn 'sran fɛnan nɛn -tɛin -taa \"bɔlɛ bɛ -a -nan. -Tɛin zɩɛ e 'tu, e blala 'saa man, wa'a -kɔlalɛ -sɛndɩ -a \"da \"dɩ, ɛn o kaa. ");
INSERT INTO yreNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","-A 'wlɛ plɔɛn 'sran 'trɛ \"yi \"da. 'O 'bɔ, 'o trʋ, ɛn 'o 'sɛn \"da. -A bɛ -tʋ 'wlɛ a \"man -fuba yaaga. -A bɛ -tʋ 'wlɛ a \"man -fuba 'shɛɛdʋ. -A bɛ -tʋ 'wlɛ a \"man -yaa tʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Min nɛn 'wɩ man \"trɔɛn \"cɩ -a -wulo -man bɛ, -a san 'e man!» ");
INSERT INTO yreNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","\"Bɛ -sru, zɩ Zozi 'fʋ 'e 'saza 'o 'vale 'e -srunɔn 'fuda \"fli 'lee min -mienun -a bɛ, ɛn waa laabʋ Zozi 'lɔ 'nan: «-Kɔnnɛn \"nɛn, yia -fɔ 'gʋɛ, -a -ci nɛn 'nɔn?» ");
INSERT INTO yreNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","-A -nan nɛn Zozi -a 'vɩ -wlɛ 'nan: «Kaa 'gʋɛ, 'ka lɛ nɛn Bali 'yee 'wɩ yɔɔdɩ nɛn 'e min \"paala 'a bɛ -a -ci 'si. 'Pian minnun nɛn o 'ka 'an -sru \"dɩɛ, \"o 'wɩ pɛɛnɔn maan -kɔnnɛn \"ji. ");
INSERT INTO yreNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","E drɛ zɩɛ 'nan -e 'o fɛnan -nanjɛn, te wa'a -kɔnnɛn 'ye dɩ, ɛn -e 'o 'wɩ man, te wa'a -ci maan dɩ, \"tɔgɔ 'o 'fli -nɔn Bali lɛ -e 'bɛ -wee 'wɩ 'wlidɩnun fui.» ");
INSERT INTO yreNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Zozi -a laabʋ -wlɔ 'nan: «-Te ka'a -kɔnnɛn 'gʋɛ -a -ci manlɛ dɩɛ, kaa dra 'kɔ -e 'ka peenun -ci man?» ");
INSERT INTO yreNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","-A -nan nɛn yaa 'vɩ -wlɛ 'nan: «'Saa 'fɔzan -kʋ 'yee 'saa 'fɔlɛ, e ya \"le 'nan, min -tʋ 'bɛ 'kʋ Bali -le 'wɩ vɩlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","'Saa 'wlɛ nɛn e -sran -si man bɛ, minnun nɛn o Bali -le 'wɩ maan, 'nun tɔɔn -e Satan 'e 'ta -a 'si o ji bɛ, -wee 'wɩ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ɛn 'saa 'wlɛ nɛn 'e 'sran puo da bɛ, minnun nɛn o Bali -le 'wɩ maan, 'nun tɔɔn o \"we \"man ci \"nrandɩ -a bɛ, -wee 'wɩ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wa'a tʋe -e -a \"sɛin 'e 'kʋ -kɔɔbli dɩ. Wa'a 'o \"trɔɛn 'tɔala 'ji dɩ. -Te 'wɩ yɩdɩ 'lee 'tɛ 'padɩ o da a bɔnan o man Bali -le 'wɩ 'le \"wɛan bɛ, tɔɔn -e 'o 'pɛ 'si Bali -le 'wɩ -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ɛn 'saa 'wlɛ nɛn e -sran fɛnan nɛn -tɛin -taa \"bɔlɛ bɛ -a -nan bɛ, minnun nɛn o Bali -le 'wɩ maan, o \"we \"man \"bɛ, -wee 'wɩ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","'Pian minnun zɩɛ, o -taa 'o 'ci \"nrɔndɩ 'silɛa 'trɛda fɛnun \"kaga \"da. Fɛ yɩdɩ o see \"paaman. O ya \"vale fɛ pɛɛnɔn 'e drɛ 'wee vɛ -a. 'Wɩ zɩɛ e -si -tɔa Bali wei lɔ, -e 'e vɩlɛ 'e 'nyranman 'pa o man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ɛn 'saa 'wlɛ nɛn o -sran 'trɛ \"yi \"da bɛ, minnun nɛn o Bali -le 'wɩ maan, o \"we \"man -e 'o 'ta wʋla \"da \"bɛ, -wee 'wɩ nɛn. Tɔɔn 'nyranman nɛn Bali wei -a 'padɩ \"siala o man bɛ, -a \"nɛn bɔala -dan. Te o drɛ \"le 'nan 'saa nɛn -a bɛ -tʋwli 'wlɛ a \"man -fuba yaaga, ɛn -a -tʋwli 'wlɛ a \"man -fuba 'shɛɛdʋ, ɛn -a -tʋwli 'wlɛ a \"man -yaa tʋ bɛ, -yee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","\"Bɛ -sru ɛn Zozi \"e 'nan -wlɛ 'nan: «Min 'ka -kannɛn 'fɔa \"nɛn -e 'e yɔɔ -pɔ wlu dɩ. -Te 'bɛ \"cɛɛ \"dɩɛ, -e 'e yɔɔ nyinnan \"davɛ wlu dɩ. 'Pian waa -tɔala fɛnan 'wein da, te minnun pɛɛnɔn -a ye. ");
INSERT INTO yreNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Maan ve 'cɛɛ 'nan, fɛ -tʋ 'ka 'fo 'e yɔɔdɩ -trilii, -e 'e vɩlɛ 'e bɔla 'ji dɩ. Ɛn 'wɩ yɔɔdɩ -tʋ \"ka -e 'o vɩlɛ 'o man fɛnan 'wein da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Min nɛn 'wɩ man \"trɔɛn \"cɩ -a -wulo -man bɛ, -a san 'e man! ");
INSERT INTO yreNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","'Ka drɛ \"yi 'wɩ nɛn ka cɩ -a mannan 'gʋɛ -a va! Zɩ ka Bali wei 'man bɛ, -a da nɛn Bali 'wɩ 'tɔdɩ \"paa \"da 'cɛɛ, -e 'e 'kʋ 'e 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kɔɔ min nɛn e cɩ -yrɔ \"bɛ, -a lɛ nɛn waa \"paa \"da. 'Pian min nɛn e \"ka -yrɔ \"dɩɛ, -a \"tiɛnnɛn nɛn -yrɔ \"bɛ, o -taa -a 'silɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ɛn Zozi -a 'vɩ \"nyian 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ -nyrɛn 'gʋ. E ya \"le min -tʋ 'saa -fɔ 'yee fei. ");
INSERT INTO yreNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","\"Bɛ -sru e yi -tɛa \"pei -man -e 'e 'fuʋ bodrun. Yaa dra zɩɛ yi -tʋdʋ pɛɛnɔn man. 'Pian fɛ nɛn e dra 'lɔɔ -e 'saa nyriɛn 'e bɔ -e 'e trʋ bɛ, ya'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","'Trɛ -a bɔa 'e 'fli -a. Yaa nyriɛn bɔa 'e 'flin, \"bɛ -sru -e 'e 'sɛn \"da, -e 'e 'yi mlin. ");
INSERT INTO yreNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","-Te -a 'wlɛ tran bɛ, te -a -tɛdɩ 'bɔ. -A -nan nɛn min zɩɛ e -ko -a -tɛlɛ srɛn 'a.» ");
INSERT INTO yreNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ɛn Zozi -a 'vɩ \"nyian 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -mɛ \"man \"nɛn -kaa -kɔɔnman? -Kɔnnɛn \"cɛn \"fɔdɩ -a nɛn maan -ci ve 'cɛɛ? ");
INSERT INTO yreNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maan -kɔɔnman fei fɛ 'wlɛ 'tʋ man. -A 'wlɛ \"wɛnnɛn \"mlian 'trɛda fɛ 'wlɛ pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","'Pian -te waa -fɔ bɛ, e bɔa -e 'e trʋ. -A -dan -cia fei sinwlɛ pɛɛnɔn da. 'E plan -tɔa, -e \"lomannun 'o \"kɔɛ \"tɔ -a 'la 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","-Kɔnnɛnnun zɩɛ -a \"kaga \"fɔdɩ -a bɛ, Zozi Bali -le 'wɩ paa minnun ji \"le zɩ o -kɔlaman -a -ci mandɩ -a bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","-Kɔnnɛn 'saza 'ji nɛn e tin 'ba minnun lɛ. 'Pian -te 'o 'vale 'e -srunɔn 'a o -fʋ 'o 'saza bɛ, -e 'e pɛɛnɔn 'ci vɩ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yi -tʋwli 'bɔ zɩɛ -a funninmlan nɛn, Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «-Kaa kʋ 'yi -sru!» ");
INSERT INTO yreNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","O -si -nɔn minnun lɛ. -A -nan nɛn o -kʋdɩ 'sia. -Klʋ nɛn Zozi cɩ -ji paan bɛ, -a -ji nɛn e -fʋ ɛn o -kʋdɩ 'sia. -Klʋ -mienun yra o -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ɛn fulɔ 'plɛblɛ 'tʋ \"fɛɛndɩ 'sia. 'Yi 'sɛndɩ 'sia -klʋ -ji. 'Siɛn vɛ bɛ 'yi \"ta -klʋ faa. ");
INSERT INTO yreNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tʋ zɩɛ -a wlu bɛ, te Zozi a yi -tɛnan -klʋ pei 'ji. -A -wulo a 'e pladɩ -sunmun da. -A -srunɔn 'a fuʋ, ɛn o -yrɛ 'nan: «Bali -le 'wɩ \"paazan, 'kʋ 'nan cɛɛn 'nyandɩ man. \"Yie 'man wɩ 'ka 'ji dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","-A -nan nɛn Zozi wluan, e paan fulɔ da, ɛn yaa 'vɩ 'yi lɛ 'nan: «'I 'ta -tɔ! 'I 'ta \"tra!» 'Nun tɔɔn fulɔ \"fɛɛndɩ 'le 'tɔ, ɛn fɛnan -tɔ flɩɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Zozi -a laabʋ -wlɔ 'nan: «-Mɛ \"klan nɛn kaa wo zɩɛ? Ka'a tian yi tɛala 'an da dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","-A -nan nɛn \"klan -sɛn o pɛɛnɔn 'ji, ɛn waa laabʋdɩ 'sia 'o cin lɔ 'nan: «-Mɛ \"sʋ -man min bɛ cɩ zɩɛ? Fulɔ 'lee 'yi -a wei maan \"yi.» ");
INSERT INTO yreNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Zozi 'lee 'e -srunɔn 'bɔla Galile 'yi -sru Geraze 'nɔn 'le 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Zɩ Zozi sɔɔnla -klʋ -ji bɛ, min -tʋ 'si min wʋnan zia, ɛn e -ta -a 'lɛ. -Yʋ -wlidɩ \"a min zɩɛ -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Min wʋnan nɛn e -nyɛanla. Min -tʋ 'ka 'kɔlaman -a -yrɩdɩ -a dɩ. -Te -bulalɛ baa nɛn oo, wa'a 'kɔlaman dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Waa cɛinnun 'lee -a -pɛnun yrɩ -bulalɛ baa 'e 'pa -a \"kaga, te yaa \"cɛɛnman 'e man. Min -tʋ 'plɛblɛ 'ka 'cia \"da 'lɔɔ -e -a -pɛ 'e 'sɔ -a pladɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bodrun funnin, e -cia \"min wʋnan 'lee pɔnnun da -paandɩ -a 'plɛblɛ, te 'e 'man 'kɔlɛ bʋʋman -kɔlɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Zɩ e Zozi 'yɩ 'kɔɔbli bɛ, e -ta flan -a, ɛn 'e \"po sɔɔnla \"wlu. ");
INSERT INTO yreNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","-A -nan nɛn e paan 'plɛblɛ, ɛn yaa 'vɩ Zozi lɛ 'nan: «Zozi, 'yie -mɛ \"wɩ nɛn 'an man? Bali nɛn min ta lou \"bɛ, -a -pɩ nɛn yia. Bali 'tɔ 'ji bɛ, te 'i 'tɛ 'pa 'an da dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Zozi -a 'vɩ -yrɛ 'nan, 'e 'si min zɩɛ -a -sru, -yee \"wɛan nɛn e 'wɩ zɩɛ -a 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ɛn Zozi -a laabʋ -yrɔ 'nan: «'I 'tɔ nɛn 'nɔn?» E 'nan Zozi lɛ 'nan: «'An 'tɔ nɛn -kuli 'pa 'tʋ, kɔɔ kʋ ya min 'gʋɛ -a -sru \"kaga.» ");
INSERT INTO yreNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɛn e toba -fɔdɩ 'sia Zozi lɛ 'nan, te 'e 'o 'pin 'lɛglɔn zɩɛ -a -ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tʋ zɩɛ -a wlu bɛ, te 'sru 'pa 'tʋ a 'e 'blɩnan o \"srɔn \"pɔn -tʋ da. ");
INSERT INTO yreNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ɛn -yʋnun -a 'vɩ Zozi lɛ 'nan: «'I yra 'si! 'I 'kʋ 'pa 'sia 'srunun 'labɛ o va -e 'kʋ 'fɔ o -sru!» ");
INSERT INTO yreNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Zozi 'si -nɔn -wlɛ. -A -nan nɛn -yʋ -wlidɩnun 'si min zɩɛ -a -sru, ɛn o -kʋ -fɔlɛ 'srunun -sru. O flan 'sia pɔn 'sɛan man zia, te o -sɛan 'yia, ɛn o pɛɛnɔn kaa. O ya 'sru -kpi \"fli. ");
INSERT INTO yreNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Zɩ 'sru -sru \"pinnɔn 'wɩ zɩɛ -a -nan 'yɩ bɛ, o -tɛ -ji flan -a, ɛn o -kʋ 'fla 'lee fei -paannun da. 'Wɩ nɛn e drɛ bɛ, waa -nan 'sinan 'pa. Minnun -kʋ 'wɩ zɩɛ -a -nan yɩlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Zɩ o 'bɔ Zozi man bɛ, ɛn o min nɛn blɔgɔ -yʋ \"kaga \"cɩ -a -sru \"bɛ, -a 'yɩ. E ya 'e -nyrandɩ 'e 'ta le sɔ -a, te -a ta 'si. 'Wɩ zɩɛ e o cɛɛn nyɛn -a. ");
INSERT INTO yreNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Minnun nɛn o cɩ -nan ɛn Zozi min zɩɛ -a beli bɛ, 'wɩ nɛn e drɛ bɛ waa -nan 'sinan 'pa -wlɛ. Ɛn 'wɩ nɛn e 'bɔ 'srunun man bɛ, waa -nan 'sinan 'pa \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","-A -nan nɛn o toba -fɔdɩ 'sia Zozi lɛ 'nan, 'e 'si 'wee 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Zɩ Zozi \"ta -fɔa \"klʋ -ji bɛ, ɛn min nɛn yaa beli bɛ, e 'nan Zozi lɛ 'nan: «'I yra si, 'kʋɛ 'ko 'yia!» ");
INSERT INTO yreNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Zozi 'ka 'wɩlɛ \"man \"dɩ. 'Pian \"e 'nan -yrɛ 'nan: «'I 'kʋ 'yie \"kɔnnɛn 'i 'mangulinun va! 'Wɩ pɛɛnɔn nɛn Minsan -a drɛ 'yiɛ bɛ, 'i 'sinan 'pa -wlɛ! Ɛn 'i nyrinda nɛn e -sɛn Minsan da bɛ, 'i 'sinan 'pa -wlɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Min zɩɛ e -kʋ, ɛn 'wɩ pɛɛnɔn nɛn Zozi -a drɛ -yrɛ \"bɛ, yaa -nan 'sinan 'padɩ 'sia 'lɛglɔn nɛn, waa laabʋ 'Fla 'fu bɛ -a -ji. Minnun pɛɛnɔn nɛn o 'wɩ zɩɛ -a 'man bɛ, o 'lɛbo \"fɔ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Zozi 'fɔ -klʋ -ji, ɛn e 'li 'e da Galile 'e \"pa 'ji. Minnun 'o cin 'yɩ \"man \"kaga, te e ya tian 'yi 'plo da. ");
INSERT INTO yreNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","-A -nan nɛn cin yɩ 'kɔn 'tazan -tʋ nɛn waa laabo Zairus bɛ, e -ta. Zɩ e Zozi 'yɩ bɛ, e -tria \"wlu, ");
INSERT INTO yreNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ɛn e 'nan -yrɛ 'nan: «'I yra 'si! 'I 'pa 'an 'va \"nyiandʋ! 'An 'lu cɛɛn 'e yiɛ 'lɛ wʋdɩ man. 'I yra 'si, 'i 'ta 'i 'pɛ 'pla \"da, -e 'e 'beli!» ");
INSERT INTO yreNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ɛn Zozi sɔɔnla -a -sru, te min -a -mɛan \"man -pɛ pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Min \"kaga zɩɛ o yei \"bɛ, lɩ -tʋ a -nan, -cɛ a \"man. -Cɛ zɩɛ e nyɛn -sɛanla \"man, -a -nan lɛ -fuda \"fli 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","'E yra 'yɩ -kʋdɩ -dɔdrɔ \"kaga 'va 'le \"wɛan, ɛn e 'yee \"lala pɛɛnɔn srɛ. 'Pian -yee -cɛ fa 'ka drɛlɛ \"yi \"dɩ, te e -ko 'padɩ -a \"da. ");
INSERT INTO yreNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","E Zozi 'le 'wɩ 'man, -yee \"wɛan e wla min \"kaga zɩɛ o yei. E pli Zozi man 'e koda zia, ɛn e klɛ -yee sɔ man. ");
INSERT INTO yreNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yaa nrɔn 'e 'ji 'nan, -te 'e 'pɛ klɛ 'e \"tun -yee sɔ man bɛ, 'e \"belia. ");
INSERT INTO yreNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","'Nun tɔɔn nyɛn -srandɩ \"man 'le 'tɔ, ɛn yaa -kɔnnɛn 'yɩ 'nan 'e beli. ");
INSERT INTO yreNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Zozi -a -tɔ 'nan, 'plɛblɛ 'tʋ 'bɔla 'e 'ji. -A -nan nɛn 'e 'man lila minnun da, ɛn yaa laabʋ 'nan: «-Tɩɛ klɛ 'an 'man sɔ man?» ");
INSERT INTO yreNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","-A -srunɔn -a 'vɩ -yrɛ 'nan: «\"Wuo! Minnun 'i -mɛan \"man -pɛ pɛɛnɔn da bɛ, -e 'i laabʋ 'nan, -tɩɛ klɛ 'i man?» ");
INSERT INTO yreNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Zozi 'e yiɛ 'tɔdɩ 'sia 'e man 'nan -e 'e min nɛn e klɛ 'e man bɛ -a yɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","-A -nan nɛn lɩ zɩɛ, e -ta nyɔɔndɩ -a. Nyɛn a cɛɛn, kɔɔ 'wɩ nɛn e drɛ -yrɛ \"bɛ yaa -tɔa 'e 'bɔ 'a. E \"po sɔɔn Zozi 'wlu, ɛn e 'wɩ pɛɛnɔn 'vɩ -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Zozi \"e 'nan -yrɛ 'nan: «An 'lu, i yi -tɛra 'an da, -yee \"wɛan nɛn i beli. 'I 'kʋ -trɔɔ! 'Yie -cɛ 'si 'i man.» ");
INSERT INTO yreNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Zozi 'fʋ 'wɩ zɩɛ -a tin 'banan, ɛn Zairus -le \"kɔnnɛn 'pa 'sianɔn 'ta -a vɩlɛ Zairus lɛ 'nan: «'I 'lu 'ka 'va. Te 'i Bali -le 'wɩ \"paazan \"koe \"nyan \"nyian dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Zozi 'wɩ zɩɛ -a 'man. E 'nan Zairus lɛ 'nan: «Te 'i \"klan dɩ! 'I yi -tɛra 'an da!» ");
INSERT INTO yreNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","-Te ya'a 'silɛa Piɛri 'lee Zaji 'lee 'e \"bʋɩ Zan -a dɩɛ, Zozi 'ka 'wɩlɛ \"man -e min pee 'e -sɔɔnla 'o -sru \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Zɩ o 'bɔla Zairus -le \"kɔnnɛn \"bɛ, Zozi min \"kaga 'yɩ 'baba 'fɔ o man, te o -wua. ");
INSERT INTO yreNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","E wla 'kuin, ɛn e 'nan -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn 'baba 'fɔ 'ka man, te ka -wua? 'Nɛn 'labɛ ya'a 'kalɛ dɩ, 'pian e ya yi -tɛnan.» ");
INSERT INTO yreNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","-A -nan nɛn minnun Zozi sɛɛ wʋdɩ 'sia. Ɛn e minnun pɛɛnɔn 'bɔla bei. E 'nɛn \"tɩ 'lee -a \"bʋ 'lee 'e -srunɔn yaaga 'sia, ɛn o wla 'kɔn \"bʋ \"nɛn 'nɛn 'bɔ cɩ -ji bɛ -a -ji. ");
INSERT INTO yreNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yaa 'kun 'e 'pɛ -man, ɛn yaa 'vɩ 'e wei -ji 'nan: «Talita kumu!» -A -ci nɛn 'nan, lɩmɔn 'nɛn, maan 'nan 'yiɛ 'nan, 'i 'wluan lou. ");
INSERT INTO yreNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","'Nun tɔɔn lɩmɔn 'nɛn zɩɛ e wluan, ɛn e 'ta wʋdɩ 'sia. -A lɛ a -fuda \"fli. Zɩ o 'wɩ zɩɛ -a -nan 'yɩ bɛ, o 'lɛbo \"fɔ. ");
INSERT INTO yreNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","'Pian Zozi 'wɩ pla -wlɛ o \"trɔɛn nyuɔndɩ -a. Yaa 'vɩ -wlɛ 'nan, te 'o -nan sɛɛ wʋ min -tʋ lɛ dɩ! Ɛn e 'nan: «'Ka fɛ -nɔn -yrɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","\"Bɛ -sru Zozi 'kʋ 'e fla Nazarɛtɩ 'o 'vale 'e -srunɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","'Flinla \"yi da bɛ, ɛn e 'wɩ \"paadɩ 'sia minnun ji cin yɩ 'kuin. Min \"kaga \"nɛn o -yee 'wɩ \"paadɩ 'man bɛ, o 'lɛbo \"fɔ. Ɛn waa laabʋdɩ 'sia 'o cin lɔ 'nan: «Nyin zia nɛn 'wɩ 'labɛ \"yɛɛ tranla? -Tɩɛ 'wɩ 'tɔdɩ zɩɛ -a -nɔn -yrɛ? Yaa dra 'kɔ, ɛn e 'lɛbo \"fɔ wɩnun 'labɛ -a dra? ");
INSERT INTO yreNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yiba \"nyaanzan \"tun \"nɛn, ɛn Mari -pɩ nɛn. Zaji 'lee Zoze 'lee Zud 'lee Simɔn nun flinzan nɛn. Ɛn \"nyian bɛ, -a -suannɛn lɩmɔnnun -nyɛanla -kaa va 'gʋ.» -Yee \"wɛan wa'a wei 'silɛa 'wɩ 'a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","-A -nan nɛn Zozi -a 'vɩ -wlɛ 'nan: «Fɛ pɛɛnɔn 'nan bɛ, Bali 'lewei vɩzan 'tɔ a 'e wluandɩ. 'Pian -te e ya 'e 'flanɔn 'lee 'e drɩnun 'lee 'e 'mangulinun yei \"bɛ, wa'a siala min -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","-Te ya'a 'silɛa -pɛ 'pladɩ -a -cɛ -tɛnɔn -mie da -e 'o 'beli dɩɛ, Zozi 'ka -kɔlalɛ 'lɛbo \"fɔ wɩ pee drɛdɩ -a 'fla zɩɛ -a da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yi nɛn wa'a -tɛlɛa Zozi da dɩɛ, -a 'wɩ -a 'kan 'e 'ciɩla \"da. \"Bɛ -sru ɛn e -kʋ 'fla peenun da, ɛn e 'wɩ paa minnun ji. ");
INSERT INTO yreNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Zozi 'e -srunɔn 'fuda \"fli laabʋ, ɛn e o 'pa 'sia \"flivli. E -kɔladɩ -nɔn -wlɛ 'nan -e 'o -yʋ -wlidɩnun -pin minnun -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yaa 'vɩ -wlɛ 'nan: «-Te ya'a 'silɛa \"tonyrin -a dɩɛ, te 'ka 'ta wʋ \"man \"fɛ pee 'sia dɩ! Te 'ka 'blɩfɛ 'lee 'pada 'lee \"lala 'sia dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","'Ka 'manwua \"wʋ! Te 'ka 'tralɛ 'sia \"fli \"dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ɛn yaa 'vɩ \"nyian -wlɛ 'nan: «-Te 'ka 'bɔla 'fla 'tʋ da bɛ, 'ka 'fʋ 'kɔn nɛn, o 'ka laabʋ 'ji bɛ -a -ji, -trilii -e 'ka 'kʋdɩ 'e bɔ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Pian -te ka 'bɔla 'fla, ɛn 'fla zɩɛ -a da 'nɔn 'ka 'ka 'silɛa min -a dɩɛ, ɛn wa'a \"trɔɛn \"tɔlɛ 'ka wei lɛ dɩɛ, 'ka 'kʋ 'ka 'lɛ! \"Cɛɛ -kʋ bɛ, 'ka 'cɛin -man fuɔn -koei \"trɔa o da 'wɩ pladɩ -a -wlɛ. -A -ci -kɔɔndɩ nɛn 'nan 'ka 'pɛ 'si -wee 'wɩ 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","-A -nan nɛn o -kʋ, ɛn o Bali -le 'wɩ vɩdɩ 'sia minnun lɛ. Waa 'vɩ -wlɛ 'nan, 'o 'si 'o drɛ wɩ -wlidɩ \"man -e 'o 'fli -nɔn Bali lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","O -yʋ -wlidɩ \"kaga \"pin minnun -sru. O 'nyrɔn ciɩ -cɛ -tɛnɔn \"kaga \"man, te o \"belia. ");
INSERT INTO yreNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mingɔnnɛn Erodi Zozi 'le 'wɩ 'man, kɔɔ -a 'tɔ 'wɩdɩ fuila \"man, te minnun -a ve 'nan: «Min -batize drɛzan Zan 'bɛ wluan -kanɔn 'va. -Yee \"wɛan nɛn -kɔladɩ a -yrɔ ɛn e 'lɛbo \"fɔ wɩnun dra.» ");
INSERT INTO yreNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ɛn min plɔɛnnun \"o 'vɩ 'nan: «Eli nɛn.» Ɛn min -mienun \"o 'vɩ 'nan: «Bali 'lewei vɩzan -tʋ nɛn \"le Bali 'lewei vɩnɔn 'li bɛ -wee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Zɩ Erodi 'wɩnun zɩɛ -a 'man bɛ, ɛn e 'nan: «Zan nɛn maan -wulo cɛɛn bɛ, -a 'bɔ nɛn. -Yɛɛ wluan -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kɔɔ Erodi 'bɛ Zan -tɛ. 'Wɩ nɛn e drɛ 'lɔɔ yaa -tɛ bɛ, -nyrɛn 'gʋ. Erodi 'yee minnun 'pa 'sia, ɛn 'o -kʋ Zan 'kunlɛ, waa yrɩ, ɛn waa -fɔ -pʋ 'kuin. Yaa drɛ zɩɛ Erodia -le \"wɛan, kɔɔ lɩ zɩɛ e ya Erodi \"bʋɩ Filipʋ nan -a, ɛn Erodi -a 'si \"wlu. ");
INSERT INTO yreNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","'Wɩ zɩɛ Zan -a 'lɛ cɛɛn Erodi lɛ. Yaa 'vɩ -yrɛ 'nan: «-Si 'ka 'i 'lɔ -e 'i \"bʋɩ nan 'si 'e 'wlu dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","-A 'wɩ 'nan Erodia man -wlidɩ. Ɛn e Zan -sa 'pla 'nan 'e -tɛa. 'Pian -si nɛn kɔ 'e 'ciɩla \"da \"bɛ, ya'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kɔɔ -a -sran Erodi 'bɔ \"e \"klan wo Zan -lɔ. -Yaa -tɔa 'nan, Zan a Bali -le min tɩglɩ 'a, -yee \"wɛan 'e yiɛ -tɔa \"va, \"tɔgɔ 'o -tɛ. Erodi Zan wei mandɩ ye \"yi, 'pian 'wɩ nɛn Erodi \"e \"yɩ -e \"e \"vɩ Zan lɛ bɛ, ya'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Zɩ Erodi -ya lɛ 'lɛ sɔɔ yi 'bɔ bɛ, ɛn Erodia -si nɛn kɔ 'e 'ciɩla \"da -e 'e Zan -tɛ bɛ -a 'yɩ. Yi zɩɛ -a da bɛ, Erodi min -dandannun 'lee 'yee 'sounjanun tanɔn 'lee Galile min cejenun laabʋ 'nan, 'o 'ta \"fɛdi drɛ 'e 'va. ");
INSERT INTO yreNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ɛn Erodia 'lu 'kʋ \"dre 'tanlɛ o 'lɛ. Erodi 'lee 'yee minnun pɛɛnɔn 'ci 'sɔ 'e 'ciɩla \"da. -A -nan nɛn Erodi -a 'vɩ -yrɛ 'nan: «Fɛ nɛn i cɩ \"va bɛ, 'i laabʋ 'an 'lɔ, maan -nɔan 'yiɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ɛn Erodi -tɔ 'e wei da -a vɩdɩ -a 'nan: «-Te 'mɛn mingɔnnɛn trɛ va nɛn i cɩ bɛ, maan 'fʋɩ 'tʋ -nɔan 'yiɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ɛn nɔnbɛ zɩɛ e 'bɔla, e -kʋ -a laabʋlɛ 'e \"bʋ 'lɔ 'nan: «-Mɛ \"fɛ nɛn 'an laabʋ -yrɔ?» -A \"bʋ \"e -yrɛ 'nan: «Min -batize drɛzan Zan -wulo nɛn, 'i laabʋ -yrɔ!» ");
INSERT INTO yreNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","-A -nan nɛn e 'li 'e da \"nyiandʋ mingɔnnɛn Erodi -va, ɛn yaa 'vɩ -yrɛ 'nan: «Min -batize drɛzan Zan -wulo va nɛn an cɩ. 'I -nɔn 'mɛn -naagʋ \"plɛdi da!» ");
INSERT INTO yreNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Zɩ Erodi 'wɩ zɩɛ -a 'man bɛ, -a ta drɛ 'trɔdrɔ. 'Pian e -tɔ 'e wei da minnun nɛn o -ta \"fɛdi da bɛ o yiɛ man, -yee \"wɛan ya'a -kɔlalɛ -a vɩdɩ -a -cɛjɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","-A -nan nɛn e 'sounja -tʋ 'pa 'sia 'nan, 'e 'kʋ Zan -wulo 'cɛn. 'Sounja zɩɛ e -kʋ -pʋ 'kuin, ɛn e Zan -wulo cɛɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","E -ta -a \"plɛdi da, ɛn yaa -nɔn nɔnbɛ 'bɔ lɛ. Ɛn nɔnbɛ zɩɛ yaa -nɔn 'e \"bʋ \"lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zɩ Zan -srunɔn 'wɩ zɩɛ -a 'man bɛ, ɛn o -kʋ -a -kadɩ 'silɛa. O -kʋ -a wʋlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Minnun nɛn Zozi o 'pa 'sia paan bɛ, o -ta. 'Wɩ pɛɛnɔn nɛn waa drɛ bɛ, 'lee 'wɩ nɛn waa paa minnun ji bɛ, waa 'sinan 'pa Zozi lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «-Kaa 'si fɛ 'gʋɛ -a -nan! -Kaa kʋ fɛnan nɛn e cɩ flɩɩ bɛ -a -nan, -e -kaa 'flinla \"wɛnnɔn!» Fɛ nɛn e 'wɩ zɩɛ -a 'vɩ bɛ, -yɛɛ cɩ 'nan, minnun nɛn o -ko 'lee minnun nɛn o -taa \"bɛ, o ya \"kaga \"bʋʋ -le \"wɛan, wa'a 'o 'wulo -da ye -e 'o fɛ -blɩ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","-A -nan nɛn Zozi 'lee 'e -srunɔn -fɔ -klʋ -ji 'o 'saza, ɛn o -kʋdɩ 'sia fɛnan nɛn e cɩ flɩɩ bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Minnun o -kʋnan 'yɩ. Ɛn 'wɩ zɩɛ min \"kaga -a 'man. -Yee \"wɛan o 'si 'fla pɛɛnɔn da, ɛn o -trɔa o 'lɛ flan -a fɛ zɩɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Zɩ Zozi sɔɔnla -klʋ -ji bɛ, e min \"kaga zɩɛ 'o 'yɩ o 'sɛndɩ. O nyrinda -sɛn \"da, kɔɔ e o 'yɩ \"le 'nan 'blanun nɛn o -sru \"pinzan \"ka \"dɩɛ, -wee 'wɩ 'zʋ. -A -nan nɛn e 'wɩ \"kaga \"paadɩ 'sia o ji. ");
INSERT INTO yreNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Zɩ funninmlan \"ta \"paala bɛ, ɛn Zozi -srunɔn pli \"man. O 'nan -yrɛ 'nan: «-Pei \"ta taan, ɛn min 'ka 'nyɛanla 'gʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","-Yee \"wɛan 'i vɩ minnun lɛ 'nan, 'o 'kʋ fei -paannun 'lee 'flanun nɛn -kaa \"srɔn 'gʋɛ -a da -e 'o 'wee -blɩfɛnun 'lɔ, 'o -blɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «'Ka 'blɩfɛ -nɔn -wlɛ 'ka 'bɔ 'a!» -A -nan nɛn waa laabʋ Zozi 'lɔ 'nan: «Kʋa dra kɔ -e 'kʋ 'blɩfɛ -nɔn -wlɛ? I ya \"vale 'nan 'kʋ 'kʋ minnun \"kaga 'labɛ o -blɩfɛ 'lɔ yi yaa \"fli \"da 'nyranman \"lala -a?» ");
INSERT INTO yreNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ɛn Zozi -a laabʋ -wlɔ 'nan: «'Kpɔun wɛa nɛn 'ka 'lɔ? 'Ka 'kʋ -a -nanjɛn!» Waa laabʋ 'o cin lɔ, ɛn o -yrɛ 'nan: «'Kpɔun 'soolu 'lee pɔ \"fli \"nɛn 'kʋ 'lɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","\"Bɛ -sru ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan, 'o min pɛɛnɔn 'nyran \"tra 'e 'kule -a, 'e 'kule -a. ");
INSERT INTO yreNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɛn minnun -nyran 'e 'kule -a, 'e 'kule -a. -A 'kule -mie bɔa min -yaa tʋ, ɛn -a 'kule -mie bɔa min -fuba 'soolu. ");
INSERT INTO yreNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","-A -nan nɛn Zozi 'kpɔun 'soolu 'lee pɔ \"fli zɩɛ -a 'si, 'e yra -tɔ laji, ɛn e Bali muo \"fɔ. E 'kpɔunnun ta cɛɛn, ɛn yaa -nɔn 'e -srunɔn lɛ 'nan, 'o -pli \"minnun man. E pɔ \"fli pli \"nyian minnun pɛɛnɔn man. ");
INSERT INTO yreNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Min pɛɛnɔn fɛ blɩ, o 'kan. ");
INSERT INTO yreNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","'Kpɔun ponɛnnun 'lee pɔnun nɛn o -fʋ bɛ, -a -srunɔn -a -sɛn saannɛn -fuda \"fli \"ji, yaa 'fa. ");
INSERT INTO yreNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Minnun nɛn o 'kpɔun blɩ bɛ, -klɔnmɔn a 'o va -kpi 'soolu. ");
INSERT INTO yreNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","\"Bɛ -sru ɛn Zozi 'tɔ 'e -srunɔn man 'nan, 'o 'fɔ -klʋ -ji -e 'o 'trɔa 'e 'lɛ Bɛzaida fla 'yi -sru. E -fɔla \"da 'nan -e 'e 'si -nɔn minnun lɛ, te o -ko -wee \"kɔnnɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Zɩ o pɛɛnɔn cɛɛn 'kʋdɩ man bɛ, ɛn e -kʋ Bali trʋ 'balɛ pɔn -tʋ da. ");
INSERT INTO yreNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","-Pei 'tan, ɛn -klʋ \"e 'bɔ 'wʋ 'yi yei, te Zozi a tian 'e 'tʋwli \"tra. ");
INSERT INTO yreNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Zozi -a 'yɩ 'nan, 'e -srunɔn a 'o yra yɩnan -klʋ -fɔdɩ -a, kɔɔ fulɔ \"fɛɛnman e -taa \"o da zia. -Pei -man, mannɛn tɛdɛ -a bɛ, ɛn e -kʋla o -sru 'ta wʋdɩ -a 'yi yiɛ da. E \"ta -cia \"o da. ");
INSERT INTO yreNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","-A -nan nɛn waa 'yɩ, te e ya 'ta wʋnan 'yi yiɛ da. -Wee 'ji \"le 'nan min lei nɛn, ɛn o -paandɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Waa 'yɩ 'o pɛɛnɔn, ɛn nyɛn -sɛn o ji. 'Pian Zozi -a 'vɩ -wlɛ 'nan: «'Ka -pɔan 'kun! Te 'ka \"klan dɩ! 'An 'bɔ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","-A -nan nɛn e -fɔ o va -klʋ -ji. 'Nun tɔɔn fulɔ 'ta 'tɔ. 'Wɩ zɩɛ e o 'plo 'fɔ 'e 'ciɩla \"da. ");
INSERT INTO yreNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","'Lɛbo \"fɔ wɩ nɛn Zozi -a drɛ 'kpɔun -a bɛ, wa'a -ci manlɛ dɩ. -Wee -ci mandɩ a -kɔɔbli -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Zɩ o 'yi cɛɛn bɛ, o 'bɔla Jenezarɛt. ");
INSERT INTO yreNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","O sɔɔnla -klʋ -ji, 'nun tɔɔn minnun Zozi -kɔnnɛn 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","O ciɩ fɛ pɛɛnɔn 'nan -a vɩdɩ -a minnun lɛ. -A -nan nɛn minnun -tadɩ 'sia -cɛ -tɛnɔn 'a \"se \"ji, fɛnan nɛn waa 'man 'nan e ya bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Fɛnan pɛɛnɔn nɛn e 'bɔ bɛ, -te e ya 'fla \"wɛnnɛn da -a oo, -te e ya 'fla -dan da -a oo, -te fei -paan \"da \"nɛn oo, minnun -taa \"cɛ -tɛnɔn -a -guada. O toba -fɔa Zozi lɛ 'nan, 'e 'yee sɔ 'lɛbo 'fɛndaa 'tʋɩ -e -cɛ -tɛnɔn 'o klɛ \"man. -Cɛ -tɛnɔn pɛɛnɔn nɛn o klɛ \"man \"bɛ, o beli. ");
INSERT INTO yreNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Yi -tʋ da bɛ, Farizɛn 'nɔn 'lee 'fluba 'ci vɩnɔn -mienun 'si Zeruzalɛm, ɛn o -ta Zozi 'va. ");
INSERT INTO yreNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Waa 'yɩ 'nan -a -srunɔn plɔɛn fɛ blɩ, te wa'a 'o 'pɛ -man \"foelɛ \"le zɩ o tranun -a 'vɩ 'nan 'o drɛ bɛ -yee 'wɩ 'zʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Zuif 'nɔn nɛn Farizɛn 'nɔn 'a bɛ, 'lee Zuif 'nɔn pɛɛnɔn bɛ, -te wa'a 'o 'pɛ -man \"foelɛ \"le zɩ o tranun -a 'vɩ 'nan 'o drɛ bɛ -yee 'wɩ 'zʋ dɩɛ, wa'a fɛ ble dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ɛn -te o 'si 'flɛji bɛ, -te wa'a 'o -srulɛ \"le zɩ o tranun -a 'vɩ 'nan 'o drɛ bɛ -yee 'wɩ 'zʋ dɩɛ, wa'a fɛ ble dɩ. O kluda wɩ \"kaga plɔɛn a \"nyian. E ya 'yi 'mlin 'kulenɛnnun -ci \"foedɩ da, ɛn e ya -pɔnun 'lee -daganun -ci \"foedɩ da, ɛn e ya nyinnan \"davɛnun -srudɩ da. ");
INSERT INTO yreNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","-Yee \"wɛan Farizɛn 'nɔn 'lee 'fluba 'ci vɩnɔn 'a laabʋ Zozi 'lɔ 'nan: «-Mɛ \"le \"wɛan nɛn, 'i -srunɔn 'ka 'wɩ nɛn -kaa tranun -a 'vɩ 'nan -kaa drɛ bɛ -a dra dɩ? 'Pian wa'a 'o 'pɛ -man dra 'saun Bali 'lɛ 'vaa -e 'o fɛ -blɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","-A -nan nɛn Zozi \"e 'nan -wlɛ 'nan: «Wei \"flivli 'nɔn! 'Wɩ nɛn Bali 'lewei vɩzan Ezai -a crɛn -tɛ 'ka man bɛ, 'wɩ 'kpa nɛn, kɔɔ yaa 'vɩ 'nan: ‹Bali \"e 'nan: Minnun 'labɛ, waan 'tɔ \"yi \"ve 'o 'le lou, 'pian o jinun bɛ, o ya 'o 'sidɩ 'an man -kɔɔbli. ");
INSERT INTO yreNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","-Wee 'an 'sudɩ bɛ -a \"nɛn \"ka \"dɩ. Kɔɔ -peinun nɛn blamin a -tɔ bɛ, -a 'bɔ nɛn waa \"paaman minnun ji 'nan -yɛɛ cɩ Bali -le -si -a.› » ");
INSERT INTO yreNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «'Ka \"trɔɛn 'si Bali -le -pei -va, ɛn ka -sɔɔnla 'ka tranun kluda wɩ -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","'Ka 'ci a 'e 'cɛndɩ. Ka Bali -le -pei tuʋ 'ka 'pɛla koda, ɛn ka lɛa 'ka tranun kluda wɩ man. ");
INSERT INTO yreNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","'Wɩ nɛn yaa -kɔɔnman bɛ -nyrɛn 'gʋ. E ya 'e 'crɛn -tɛdɩ 'nan: ‹'I yiɛ 'nan 'i \"tɩ 'lee 'i \"bʋ \"man!› Ɛn \"nyian 'nan: ‹Min nɛn, 'e wei 'pla 'e \"tɩ \"man, -te 'bɛ \"cɛɛ dɩɛ, 'e \"bʋ \"man bɛ, 'o san -tɛ!› -Pei zɩɛ Bali 'bɛ -nɔn Moizi lɛ, ");
INSERT INTO yreNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","'pian kaa \"paaman minnun ji 'nan, -si a 'e 'nɔndɩ min lɛ -e 'e vɩ 'e \"tɩ 'lee 'e \"bʋ \"lɛ 'nan: ‹Ma'an 'kɔlaman -e 'an 'pa 'ka 'va dɩ. \"Lala nɛn kɔ \"an -nɔn 'cɛɛ bɛ, maan drɛ Kɔrban -a. -A -ci nɛn 'nan, maan -nɔn Bali lɛ.› ");
INSERT INTO yreNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","'Cee 'wɩ \"paadɩ zɩɛ e -si -tɔa -yrɔ -e 'e 'pa 'e \"tɩ 'lee 'e \"bʋ 'va. ");
INSERT INTO yreNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Zɩ ka Bali wei klu -sɛanla 'ji 'ka tranun kluda wɩ -a zɩɛ. Ɛn 'wɩ zɩɛ -a -tʋwli \"nɛn kaa dra 'wɩ \"kaga \"ji.» ");
INSERT INTO yreNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","\"Bɛ -sru ɛn Zozi min \"kaga laabʋ \"nyian, ɛn e 'nan -wlɛ 'nan: «'Ka \"trɔɛn \"tɔ 'an wei lɛ -e 'ka 'wɩ 'gʋɛ -a -ci man 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Fɛ nɛn e \"sia bei, -e 'e -wla \"min ji bɛ, ya'a min \"tri 'tɔa Bali 'lɛ dɩ. 'Pian fɛ nɛn e \"sia min ji -e 'e bɔla bei \"bɛ, -yɛɛ min \"tri -tɔa Bali 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Min nɛn 'wɩ man \"trɔɛn \"cɩ -a -wulo -man bɛ, -a san 'e man!» ");
INSERT INTO yreNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Zozi 'si min \"kaga yei, ɛn e wla 'kuin. -A -nan nɛn -a -srunɔn 'a laabʋ -yrɔ 'nan, 'e -kɔnnɛn \"nɛn yaa -fɔ bɛ -a -ci vɩ 'wlɛ! ");
INSERT INTO yreNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ɛn e 'nan -wlɛ 'nan: «'Ka 'bɔ \"nyian, ka'a 'kɔlaman -e 'ka 'wɩ zɩɛ -a -ci man dʋʋ? Fɛ nɛn e -wlamlan min ji bɛ, ya'a min \"tri 'tɔa Bali 'lɛ dɩ. Ka'a tɔa zɩ dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kɔɔ ya'a 'wlamlan min souba ji dɩ, 'pian e -ko min -pɔan 'ji. \"Bɛ -sru -e min 'e 'kʋ -fɔ -a lua.» 'Wɩ zɩɛ -a vɩdɩ -a nɛn Zozi -a kɔɔn 'nan, -blɩfɛ -tʋ 'ka min \"tri -tɔa Bali 'lɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ɛn Zozi -a 'le 'sran 'nan: «Fɛ nɛn, e \"sia min ji bɛ, -yɛɛ min \"tri -tɔa Bali 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kɔɔ blamin souba 'ji nɛn ci \"nrɔndɩ -wlidɩ pɛɛnɔn \"sia. -Kɔnnɛn -wɛɛdɩ \"kaga 'lee lɩ -wɛɛdɩ \"kaga \"a -tʋ, ɛn crin wʋdɩ a -tʋ, ɛn min -tɛdɩ a -tʋ, ");
INSERT INTO yreNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ɛn min nan -wɛɛdɩ 'lee min -sran -wɛɛdɩ a -tʋ, ɛn \"lala yɩdɩ \"yi \"bʋʋ \"a -tʋ, ɛn nyannɛn drɛdɩ a -tʋ, ɛn -dawli drɛdɩ a -tʋ, ɛn fɛ -blɩdɩ 'lee -wɛn mlindɩ -e 'e 'ciɩla \"da \"bɛ e ya -tʋ, ɛn man bʋdɩ a -tʋ, ɛn 'wɩdɩ min man -wlidɩ \"a -tʋ, ɛn fli drɛdɩ -dandan a -tʋ, ɛn -blʋ 'tandɩ a -tʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","'Wɩ 'wlidɩ pɛɛnɔn zɩɛ, o \"sia min ji, ɛn -wɛɛ min \"tri -tɔa Bali 'lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Zozi 'si fɛ zɩɛ -a -nan, ɛn e -kʋ Tir 'fla \"srɔn Fenizi 'lɛglɔn 'ji. E wla 'kɔn 'tʋ -ji. E 'ka \"vale 'nan, minnun 'o -tɔ 'nan e ya -nan dɩ. 'Pian ya'a -kɔlalɛ drɛdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Lɩmɔn -tʋ a 'fla zɩɛ -a da. -Yʋ -wlidɩ \"a -a 'lu -sru. 'Nun tɔɔn e Zozi 'le 'wɩ 'man, ɛn e -ta \"va, ɛn 'e \"po sɔɔnla \"wlu. ");
INSERT INTO yreNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","-A -nan nɛn e toba -fɔ -yrɛ 'nan, 'e 'yʋ -wlidɩ \"pin 'e 'lu -sru. Lɩ 'bɔ zɩɛ Zuif lɩ \"cɛɛ dɩ, e \"sia Siri Fenizi 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «'I nannannun 'tʋɩ 'o fɛ -blɩ 'o 'kan 'lɔ! E 'ka 'wɩ \"yi, -e min 'e nannannun -lɔ 'kpɔun 'si 'e -nɔn -plɛnnun lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɛn yaa 'vɩ Zozi lɛ 'nan: «'Wɩ tɩglɩ nɛn, yia 'vɩ, 'an 'san. 'Pian nannannun 'nɛan plɔɛn nɛn e -sɛanla bɛ, -plɛnnun nɛn 'tablo wlu bɛ, waa -ble.» ");
INSERT INTO yreNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «Yia 'vɩ fɛnyian. 'I 'kʋ, -yʋ -wlidɩ 'si 'yie 'nɛn -sru!» ");
INSERT INTO yreNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","-A -nan nɛn lɩ zɩɛ e 'li 'e da 'yee \"kɔnnɛn. E 'bɔ 'yee 'nɛn man 'e nyinnandɩ -saa da, te -yʋ -wlidɩ 'si -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","\"Bɛ -sru ɛn Zozi 'si 'lɛglɔn nɛn Tir 'fla \"srɔn \"bɛ -a -ji. E ciɩla Sidɔn, ɛn e -kʋ 'lɛglɔn nɛn waa laabo 'Fla 'fu bɛ -a da Galile 'yi man. ");
INSERT INTO yreNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","-A -nan nɛn minnun -ta bobo -tʋ -a Zozi lɛ, ɛn o toba -fɔ -yrɛ 'nan, 'e 'pɛ 'pla \"da, -e 'e 'beli. ");
INSERT INTO yreNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Zozi -cɛzan zɩɛ -a 'si minnun \"srɔn \"kogo, ɛn e -kʋ -a -kɔɔbli fɔɔ. E 'pɛ 'wlɛ 'wʋ -a \"trɔɛn 'ji, ɛn e 'le 'yi 'si, yaa klɛ -a nrɛn man. ");
INSERT INTO yreNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","-A -nan nɛn 'e yiɛ -tɔ laji, e flin -vɛɛ, ɛn yaa 'vɩ -yrɛ 'e wei -ji 'nan: «Efata!» -A -ci nɛn 'nan, 'i 'lɛ 'sʋ! ");
INSERT INTO yreNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","'Nun tɔɔn -a \"trɔɛn 'lɛ 'sʋ, ɛn -a nrɛn flu. -A -nan nɛn e 'wɩdɩ 'sia tɩglɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Zozi 'wɩ 'pla minnun lɛ 'nan, te 'o -nan wɩ vɩ minnun lɛ dɩ! E 'wɩ \"paala -wlɛ te yaa \"paala, 'pian 'bɛ 'nan nɛn minnun -a fuimlan \"man \"bʋʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Min pɛɛnɔn 'lɛbo \"fɔ 'e 'ciɩla \"da, te waa ve 'nan: «'Wɩ pɛɛnɔn nɛn yaa dra bɛ, e ya \"yi. Yaa drɛ ɛn \"trɔɛn \"winɔn \"trɔɛn 'lɛ 'sʋ, ɛn yaa drɛ ɛn bobonun nrɛn baa flu.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tʋ zɩɛ -a man nɛn, min \"kaga 'o cin 'yɩ \"nyian Zozi man. Ɛn zɩ o -blɩfɛ \"ka -e 'o -blɩ dɩɛ, -a -nan nɛn yaa 'vɩ 'e -srunɔn lɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Minnun 'labɛ, o nyrinda -sɛan 'an da. Kɔɔ yi yaaga nɛn 'gʋ, te o ya 'an \"srɔn, ɛn -blɩfɛ -tʋ 'ka -wlɔ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","-Te an o 'li 'o da 'o 'ci le dra -a bɛ, o man -taa tɔalɛ -sia. Ɛn \"nyian bɛ, o -mienun 'sinan a -kɔɔbli.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","-A -srunɔn -a 'vɩ -yrɛ 'nan: «Nyin zia nɛn min -blɩfɛ ye -e 'e -nɔn -wlɛ fɛnan nɛn min 'ka 'nyɛanla 'gʋ dɩɛ -a -nan?» ");
INSERT INTO yreNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ɛn Zozi -a laabʋ -wlɔ 'nan: «'Kpɔun a 'ka 'lɔ wɛa?» O 'nan -yrɛ 'nan: «E ya 'sɔravli.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tɔɔn e 'nan minnun \"kaga zɩɛ -wlɛ 'nan, 'o -nyran \"tra. E 'kpɔun 'sɔravli zɩɛ -a 'si, e Bali muo \"fɔ, ɛn yaa \"nɛn jɛɛn. Yaa -nɔn 'e -srunɔn lɛ 'nan, 'o -pli \"o man. Ɛn waa pli o man. ");
INSERT INTO yreNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pɔ \"wɛnwɛnnɛn -mie a \"nyian -wlɔ \"tiɛnnɔn. Zozi Bali muo \"fɔ, ɛn yaa 'vɩ 'e -srunɔn lɛ 'nan: «'Ka -pli \"nyian o man!» ");
INSERT INTO yreNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Minnun pɛɛnɔn -a blɩ, o 'kan. Ɛn -a ponɛnnun nɛn o -fʋ bɛ, waa tre 'e cin man, e saannɛn 'fa 'sɔravli. ");
INSERT INTO yreNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Minnun nɛn waa blɩ bɛ o \"nɛn bɔa -kpi sinjɛn. \"Bɛ -sru ɛn Zozi -si -nɔn -wlɛ 'nan 'o 'li 'o da 'o fla. ");
INSERT INTO yreNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ɛn Zozi 'lee 'e -srunɔn -fɔ -klʋ -ji. O -kʋ 'trɛ nɛn, waa laabo Damanuta bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farizɛn 'nɔn 'ta, ɛn o -sa -fɔdɩ 'sia Zozi 'va. -A man -tandɩ -le \"wɛan, waa laabʋ -yrɔ 'nan, -te -yee -kɔladɩ \"sia Bali va bɛ, 'e 'lɛbo \"fɔ wɩ -tʋ drɛ laji. ");
INSERT INTO yreNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Zozi flin -vɛɛ, ɛn e 'nan -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn 'ka -naagʋnɔn, 'lɛbo \"fɔ wɩ nɛn kaa -wɛɛman? Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, wa'a 'lɛbo \"fɔ wɩ -tʋ -kɔɔnman 'ka -naagʋnɔn lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","-A -nan nɛn e 'si o va, e -fɔ -klʋ -ji, ɛn e -kʋ 'yi -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Zozi -srunɔn 'ci 'san 'kpɔun siadɩ man. 'Kpɔun -tʋwli \"nɛn -wlɔ \"klʋ -ji. ");
INSERT INTO yreNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ɛn Zozi 'wɩ pladɩ 'sia -wlɛ. Yaa 'vɩ 'nan: «'Ka yiɛ 'tɔ 'ka 'fli -va! Erodi 'lee Farizɛn 'nɔn 'le 'mannyan 'le \"wɛan nɛn maan ve zɩɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","-A -nan nɛn -a -srunɔn -a vɩdɩ 'sia 'o cin yei 'nan, 'kpɔun nɛn e 'ka -kaa 'lɔ dɩɛ, -yee \"wɛan nɛn e 'wɩ zɩɛ -a 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Zozi 'wɩ zɩɛ -a -kɔnnɛn 'yɩ, ɛn yaa 'vɩ -wlɛ 'nan: «-Mɛ \"wɛan nɛn kaa ve 'nan, 'kpɔun -le \"wɛan nɛn an 'wɩ zɩɛ -a 'vɩ? Ka'a tian 'wɩ 'ci manlɛ dʋʋ? Ɛn ka'a 'wɩ 'paala 'ka 'ka 'ji dʋʋ? -Mɛ \"le \"wɛan 'cee 'wɩ mandɩ 'lɛ 'wʋ? ");
INSERT INTO yreNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","'Ka yiɛ nɛn \"ji \"bɛ, fɛnan yɩvɛ \"cɛɛ dʋʋ? 'Ka \"trɔɛn \"nɛn 'ka 'wulo -man bɛ, 'wɩ manvɛ \"cɛɛ dʋʋ? 'Wɩ 'cin 'ka 'fɔala 'ka 'ji dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tʋ nɛn an 'kpɔun 'soolu -pliman min -kpi 'soolu man -e 'o 'kan bɛ, 'kpɔun ponɛn nɛn, e -fʋ bɛ, e saannɛn 'fa wɛa?» O -yrɛ 'nan: «-Fuda \"fli.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ɛn Zozi 'a laabʋ \"nyian 'nan: «Tʋ nɛn an 'kpɔun 'sɔravli -pliman min -kpi sinjɛn man -e 'o 'kan bɛ, 'kpɔun ponɛn nɛn, e -fʋ bɛ, e saannɛn 'fa wɛa?» O -yrɛ 'nan: «'Sɔravli.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Zozi \"e -wlɛ 'nan: «-Te 'bɛ a zɩɛ, -mɛ \"le \"wɛan ka'a tian 'wɩ 'ci manlɛ dɩ?» ");
INSERT INTO yreNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Zozi 'lee 'e -srunɔn 'bɔla Bɛzaida, ɛn minnun -ta yiɛ 'wizan -tʋ -a -yrɛ. O toba -fɔ Zozi lɛ 'nan 'e klɛ \"man. ");
INSERT INTO yreNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","-A -nan nɛn Zozi yiɛ 'wizan zɩɛ, -a 'kun 'e 'pɛ -man, ɛn e -kʋ -a 'fla lunɛn. E 'le 'yi 'pa -a yiɛ da, ɛn e 'e 'pɛ 'pla min zɩɛ -a da. \"Bɛ -sru ɛn yaa laabʋ -yrɔ 'nan: «'I fɛ -tʋ ye?» ");
INSERT INTO yreNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","E fɛnan -nanjɛn, ɛn e 'nan: «An minnun ye. E dra \"le 'nan yibanun 'bɛ cɩ 'ta wʋnan.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ɛn Zozi 'e 'pɛ 'pla \"nyian -a yiɛ da. -A -nan nɛn min zɩɛ e fɛnan 'yɩ 'wein, e beli. ");
INSERT INTO yreNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Zozi -a 'li 'e da 'e fla 'wɩ pladɩ -a -yrɛ. Yaa 'vɩ -yrɛ 'nan: «'I 'kʋ 'i 'mangulinun va, 'pian te 'i 'ciɩla Bɛzaida 'fla yei \"dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zozi 'lee 'e -srunɔn a -kʋnan 'flanun nɛn Sezare Filipʋ \"srɔn \"bɛ -a da. O ya -sia, ɛn e 'wɩ 'gʋɛ -a laabʋ 'e -srunɔn 'lɔ. Yaa laabʋ 'nan: «Minnun \"o 'nan, -tɩ nɛn 'maan?» ");
INSERT INTO yreNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɛn o 'nan -yrɛ 'nan: «Min -mienun \"o 'vɩ 'nan, min -batize drɛzan Zan nɛn 'yia. Ɛn min plɔɛnnun \"o 'vɩ 'nan, Bali 'lewei vɩzan Eli nɛn 'li bɛ -nyrɛn 'yia. Ɛn min -mienun \"o 'vɩ 'nan, Bali 'lewei vɩnɔn nɛn 'li bɛ, -a -tʋ nɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ɛn Zozi -a laabʋ -wlɔ 'nan: «Kaa \"nun, \"ka 'vɩ 'nan, -tɩ nɛn 'maan?» Piɛri \"e -yrɛ 'nan: «I ya Crizi nɛn Bali -a 'pa 'sia -e 'e minnun 'si 'wɩ 'ji bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ɛn Zozi 'o \"trɔɛn nyuɔn 'wɩ pladɩ -a -wlɛ 'nan, te 'o 'yee 'wɩ vɩ min lɛ \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","\"Bɛ -sru ɛn Zozi 'wɩ \"paadɩ 'sia 'e -srunɔn 'ji. Yaa vɩdɩ 'sia -wlɛ 'nan: «Yra yɩdɩ \"kaga \"ta -daa \"bɔlɛ 'an 'bɔ Blamin -pɩ man. Min cejenun 'lee Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn -taa 'an drɛlɛ 'o 'pɛla koda. Waan -tɛa. 'Pian -a yi yaagazan da bɛ, -e 'an 'wluan -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","E 'wɩ zɩɛ -a 'vɩ -wlɛ 'wein. -A -nan nɛn Piɛri Zozi laabʋ 'o \"fli yei, ɛn e 'wɩ 'pla Zozi lɛ. E -yrɛ 'nan: «Te 'i 'wɩ zɩɛ -a vɩ \"fo \"dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Zozi 'e 'man lila, 'e -srunɔn 'nanjɛɛn, ɛn e 'wɩ 'pla Piɛri lɛ 'klagla. Yaa 'vɩ -yrɛ 'nan: «Satan, 'i 'si 'an \"srɔn \"kogo! 'Wɩ nɛn 'i 'ci \"nrɔnman \"da \"bɛ, -a 'bɔ \"cɛɛ Bali -a nrɔn 'e 'ji dɩ. 'Pian 'yie ci \"nrɔndɩ a blamin -le vɛ da.» ");
INSERT INTO yreNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","-A -nan nɛn Zozi minnun pɛɛnɔn 'lee 'e -srunɔn laabʋ 'e \"srɔn. Ɛn e 'nan -wlɛ 'nan: «-Te min nɛn e ya \"vale 'e 'ta wʋla 'an -sru \"bɛ, 'e 'bli 'si 'e 'fli da, ɛn 'e 'wɩ yra yɩdɩ man, ɛn 'e 'wɩ 'kadɩ man yiba \"plan da 'vaa, -e 'e -sɔɔnla 'an -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Min oo min nɛn e ya 'e 'ladɩ 'yee 'trɛda da bɛ, -yee 'trɛda -taa 'silɛ -yrɔ. 'Pian min nɛn 'e 'pɛ 'si -yee 'trɛda da \"fo, ɛn yaa -nɔn 'mɛn 'an yɩdɩ \"yi 'lee Bali -le 'wɩ 'nɔnnɔn yɩdɩ \"yi \"le \"wɛan bɛ, Bali -le 'belidɩ dra -a san -le vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","-Te min 'trɛda fɛ pɛɛnɔn 'yɩ, ɛn 'belidɩ 'si -yrɔ \"bɛ, -a -trɔn nɛn -mɛ \"a? E 'ka \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kɔɔ ya'a 'kɔlaman -e 'e 'belidɩ zɩɛ -a ta pan wʋ 'e 'lɔ fɛ -tʋ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","-Naagʋnɔn 'o 'fli cɛɛn Bali man, ɛn o ya 'wɩ 'wlidɩ \"kaga \"drɛnan. Min nɛn, yra -a -tɛ o 'lɛ -a vɩdɩ -a 'nan 'e ya 'an -sruzan 'a bɛ, -te 'bɛ \"cɛɛ dɩ, 'mɛn 'wɩ vɩdɩ -wlɛ yra -a -tɛ bɛ, Blamin -pɩ -yee vɛ yra -tɛa \"nyian tʋ nɛn e -taa \"man \"bɛ -a man. E -taa 'e \"tɩ \"le 'tɛ 'san 'lee 'e \"tɩ \"le 'pasianɔn 'le 'tɛ 'san da.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ɛn Zozi -a 'le 'sran -a vɩdɩ -a 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'ka pɛɛnɔn nɛn 'an 'lɛ 'gʋɛ, ka'a 'cɛan -kaadɩ man 'vaa -e 'ka yɩ 'nan Bali mingɔnnɛn -blɩdɩ 'sia 'yee 'plɛblɛ 'a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yi 'shɛɛdʋ \"bɛ -sru Zozi Piɛri 'lee Zaji 'lee Zan 'saza 'sia, ɛn e -kʋ waa pɔn loulou \"tʋ da. -A -nan nɛn -a 'kɔlɛ lila o yiɛ man. ");
INSERT INTO yreNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","-A man sɔnun drɛ 'fuvu 'yrɩyrɩ. Min -tʋ 'ka 'trɛda 'gʋ -e 'e -a sʋman fɛ 'fuvu drɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ɛn o Eli 'lee Moizi 'yɩ Zozi \"srɔn te o ya -sɛɛ \"wʋnan waa. ");
INSERT INTO yreNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","-A -nan nɛn Piɛri -a 'vɩ Zozi lɛ 'nan: «'Kʋ 'san, e ya 'wɩ \"yi \"a -e -kaa -fʋ fɛ 'gʋɛ -a -nan. Kʋ segle pannɛn yaaga -tɔa. -A -tʋ a 'yie vɛ -a, -a -tʋ a Moizi -le vɛ -a, ɛn -a -tʋ a Eli -le vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piɛri 'wɩ zɩɛ -a vɩ 'e lei -sru, kɔɔ nyɛn o cɛɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ɛn \"lolu -koei \"trɔa o da. -A -nan nɛn wei -tʋ wɩɩ \"lolu -koei zɩɛ -a va. Yaa 'vɩ 'nan: «'An 'pɩ nɛn, e 'sɔ 'mɛn tɩglɩ bɛ, -nyrɛn \"bɛ. 'Ka \"trɔɛn \"tɔ -a wei lɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","'Nun tɔɔn \"wɛɛ vɩnan 'o yiɛ 'tɔ 'o \"srɔn \"bɛ, te o Zozi 'tʋwli \"ye 'e 'tɔdɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Zɩ o pɔn -sɔɔndɩ \"ji 'sia bɛ, ɛn Zozi 'wɩ pladɩ 'sia -wlɛ. Yaa 'vɩ 'nan: «-Te Blamin -pɩ 'ka tian 'wunlɛa -kanɔn 'va dɩɛ, 'wɩ nɛn kaa -nan 'yɩ 'gʋɛ, te 'ka -nan sɛɛ wʋ min -tʋ lɛ \"fo \"dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","O 'wɩ zɩɛ -a 'man \"yi. 'Pian waa laabʋdɩ 'sia 'o cin yei 'nan: «Wluandɩ -kanɔn 'va bɛ, -a -ci nɛn 'nɔn?» ");
INSERT INTO yreNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ɛn -a -srunɔn -a laabʋ -yrɔ 'nan: «-Mɛ \"le \"wɛan nɛn Bali -le 'fluba 'ci vɩnɔn -a 'vɩ 'nan, Eli 'bɛ -taa 'e 'flin 'vaa -e min nɛn Bali 'si \"va \"bɛ 'e 'ta?» ");
INSERT INTO yreNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Zozi -a 'vɩ -wlɛ 'nan: «-Wee tin a 'nɔnnɔn, Eli 'bɛ -taa 'e 'flin, -e 'e 'wɩ pɛɛnɔn drɛ 'e \"pa 'ji. 'Pian e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji \"nyian 'nan, Blamin -pɩ 'e yra ye \"kaga, ɛn minnun -a dra 'o 'pɛla koda. -Mɛ \"le \"wɛan nɛn e ya 'e 'crɛn -tɛdɩ zɩɛ? ");
INSERT INTO yreNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Maan vɩ 'cɛɛ 'nan, Eli -ta 'va, ɛn minnun 'ka 'a 'silɛa min -a dɩ. 'Wɩ nɛn o cɩ \"va \"bɛ, waa drɛ -yrɛ. 'Wɩ nɛn e 'bɔ \"man zɩɛ, e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'e 'cɛn 'nan 'e dra.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Zɩ Zozi 'lee 'e -srunɔn yaaga zɩɛ, o \"ta bɔa -a -srunɔn plɔɛn nɛn o -fʋ pɔn wlu bɛ o man bɛ, ɛn o min \"kaga 'yɩ, te waa -srunɔn 'bɔ 'si -fɔ. Bali -le 'fluba 'ci vɩnɔn a o yei, te o -sa -fɔa 'o 'vale -a -srunɔn 'bɔ 'a. ");
INSERT INTO yreNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Zɩ minnun zɩɛ o Zozi 'yɩ bɛ, o drɛ kligli, ɛn o -kʋ \"va \"flan -a 'nan -e 'o 'tɔ bʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","-A -nan nɛn Zozi -a laabʋ 'e -srunɔn 'lɔ 'nan: «-Mɛ \"sa nɛn, ka cɩ -a -fɔnan 'ka 'vale waa?» ");
INSERT INTO yreNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ɛn min -tʋ -a 'vɩ Zozi lɛ minnun yei 'nan: «Bali -le 'wɩ \"paazan, an -ta 'mɛn 'nɛn 'a 'yiɛ. -Yʋ -wlidɩ \"a -a -sru, ya'a 'kɔlaman 'wɩdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","-Te e -ta \"da \"bɛ, yaa -tiala \"tra, te -a 'le -pɔɛ bɔa, te e 'shɛ ta -ble, -e 'e 'tɔ -jɛi. Maan 'vɩ 'i -srunɔn lɛ 'nan, 'o 'yʋ -wlidɩ zɩɛ -a -pin -a -sru. 'Pian 'o 'pɛ 'ka 'sɔlɛ -a drɛdɩ -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «-Naagʋnɔn, 'cee yi -tɛradɩ Bali da \"ka \"dɩ. Tʋ wɛa nɛn 'an drɛ \"nyian 'ka 'va, 'vaa -e 'ka yi -tɛra 'an da? 'An drɛ \"nyian 'cɛɛ 'kɔ? 'Ka 'ta 'nɛn 'bɔ 'a 'mɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","-A -nan nɛn o -kʋ -a -yrɛ. Zɩ -yʋ -wlidɩ Zozi 'yɩ bɛ, 'nun tɔɔn e 'nɛn zɩɛ -a nyɔɔn 'plɛblɛ, ɛn e -tria. E kɔɔladɩ 'sia, te -a 'le -pɔɛ bɔa. ");
INSERT INTO yreNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Zozi -a laabʋ -a \"tɩ 'lɔ 'nan: «Tʋ \"cɛn \"man nɛn, e drɛdɩ 'sia -yrɛ?» -A \"tɩ \"e -yrɛ 'nan: «E drɛdɩ 'sia -yrɛ -a \"wɛnnɛn da. ");
INSERT INTO yreNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","-Yʋ -wlidɩ -a -tria 'e 'pa -a \"kaga. Tʋ -mie 'bɔ bɛ, yaa -fɔ 'tɛa, ɛn tʋ -mie 'bɔ bɛ, yaa -tɛ 'yia. Yaa dra zɩɛ 'nan -e 'e 'ka -le \"wɛan. 'I yra 'si, -te i -kɔlaman 'wɩ 'tʋ drɛdɩ -a bɛ, 'kʋ nyrinda 'e 'sɛn 'i da, -e 'i 'pa 'kʋ 'va!» ");
INSERT INTO yreNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Zozi \"e -yrɛ 'nan: «-Mɛ \"le \"wɛan nɛn yia 'vɩ 'nan, -te an -kɔlaman? Min nɛn, e yi -tɛala Bali da bɛ, -a -pɛ \"sɔa 'wɩ pɛɛnɔn drɛdɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","'Nun tɔɔn ɛn 'nɛn \"tɩ -a 'vɩ 'plɛblɛ 'nan: «An yi -tɛala Bali da, 'pian 'i 'pa 'an 'va -e 'mɛn yi -tɛradɩ Bali da 'e 'pa \"da.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Zɩ Zozi -a 'yɩ 'nan, minnun a -tanan \"kaga \"bɛ, ɛn yaa 'vɩ -yʋ -wlidɩ \"lɛ yra 'tɔndɔn 'a 'nan: «-Yʋ -wlidɩ \"nɛn e 'nɛn 'gʋɛ -a dra bobo -a bɛ, 'i 'si -a -sru! Te 'i 'ta \"nyian -a -sru \"fo \"dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","-Yʋ -wlidɩ 'bɔ -paandɩ 'sia, ɛn e 'nɛn 'bɔ nyɔɔn 'plɛblɛ, -a -nan nɛn e 'si -a -sru. 'Nɛn 'bɔ yra flɩɩ \"le min -kadɩ -le 'wɩ 'zʋ. Ɛn min \"kaga -a vɩdɩ 'sia 'nan: «E -ka.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","'Pian Zozi -a 'kun 'e 'pɛ -man, yaa wluan, ɛn e -tɔ lou. ");
INSERT INTO yreNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","\"Bɛ -sru ɛn Zozi 'kʋ \"kɔnnɛn. -A -nan nɛn -a -srunɔn -a laabʋ -yrɔ 'o 'saza yei 'nan: «-Mɛ \"le \"wɛan nɛn, kʋ'a -kɔlalɛ -yʋ -wlidɩ zɩɛ -a -pindɩ -a dɩ?» ");
INSERT INTO yreNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «-Yʋ -wlidɩnun nɛn \"le 'nan -yʋ -wlidɩ 'labɛ -yee 'wɩ 'zʋ bɛ, -te ya'a 'silɛa Bali trʋ 'badɩ -a dɩɛ, min 'ka 'kɔlaman o -pindɩ min -sru \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Zozi 'lee 'e -srunɔn 'si fɛ zɩɛ -a -nan, ɛn o -kʋdɩ 'sia 'nan -e 'o Galile 'cɛn. 'Pian Zozi 'ka \"vale minnun 'o -kɔnnɛn \"yɩ 'nan 'e 'bɔ nɛn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kɔɔ e ya 'wɩ \"paanan 'e -srunɔn 'ji. -A -nan nɛn 'wɩ nɛn e -taa \"bɔlɛ \"man \"bɛ, yaa -ci 'vɩ -wlɛ. E 'nan: «Minnun \"ta -daa Blamin -pɩ -nɔnlɛ minnun lɛ -e 'o -tɛ. -A yi yaagazan da nɛn e wuanla -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","'Pian -a -srunɔn 'ka 'wɩ zɩɛ -a -ci manlɛ dɩ, ɛn -a -ci laabʋdɩ o -tɛa \"klan -a. ");
INSERT INTO yreNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Zozi 'lee 'e -srunɔn 'bɔla Kapanamo. Zɩ o ya \"kɔnnɛn \"bɛ, ɛn Zozi -a laabʋ -wlɔ 'nan: «-Mɛ \"sa nɛn, kaa -fɔa paan 'sia?» ");
INSERT INTO yreNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","'Pian 'o 'ta -sɛn. Kɔɔ -te o ya -sia bɛ, o -sa -fɔ 'o cin yei 'nan, -tɩɛ cɩ o yei Zozi -sruzan -dan a? ");
INSERT INTO yreNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","-A -nan nɛn Zozi 'nyran, ɛn 'e -srunɔn 'fuda \"fli laabʋ. E 'nan -wlɛ 'nan: «Min nɛn, e cɩ \"vale 'e dra 'an -sruzan -dan a bɛ, 'e 'fli 'pla min pɛɛnɔn 'wlu 'nan -e 'e o 'su!» ");
INSERT INTO yreNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","-A -nan nɛn Zozi 'nɛn \"wɛnnɛn 'tʋ 'si, ɛn yaa -tɔ o 'lɛ. Yaa 'si, yaa -fɔ 'e man, ɛn e 'nan -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Min oo min nɛn e min nɛn \"le 'nɛn \"wɛnnɛn 'zʋ 'gʋ -a 'kun tɩglɩ 'mɛn \"wɛan bɛ, te 'an 'bɔ nɛn, yaan 'kun tɩglɩ. Ɛn min nɛn yaan 'kun tɩglɩ bɛ, 'an 'tʋwli \"cɛɛ yaa 'kun tɩglɩ dɩ, 'pian min nɛn, yaan 'pa 'sia 'trɛda bɛ, te -a san nɛn yaa 'kun tɩglɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zan -a 'vɩ Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan, kʋ min -tʋ 'yɩ, te e -yʋ -wlidɩ -pian \"minnun -sru 'i 'tɔ da. Ɛn kʋa 'vɩ -yrɛ 'nan, te 'e drɛ dɩ, kɔɔ ya'a 'ta 'wʋla 'i -sru \"le 'kʋe 'wɩ 'zʋ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ɛn Zozi \"e 'nan: «Te 'ka 'wɩ zɩɛ -a drɛ dɩ! Kɔɔ min -tʋ \"ka -e 'e 'lɛbo \"fɔ wɩ drɛ 'an 'tɔ da, \"bɛ -sru -e 'e 'wɩ 'an man -wlidɩ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ɛn min nɛn, -a pei 'ka 'e 'padɩ -kaa man dɩɛ, te e ya -kaa -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min oo min nɛn e 'yi 'kulenɛn 'tʋ -nɔn 'cɛɛ, 'nan 'ka ya Crizi -le vɛ -a -le \"wɛan bɛ, e -taa 'yee -kopa yɩlɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Minnun nɛn o yi -tɛala 'an da \"le nannannun -le 'wɩ 'zʋ bɛ, min oo min nɛn yaa drɛ ɛn -a -tʋwli \"cɛ 'si 'an -sru \"bɛ, -a \"yi mlin -e 'o 'kɔlɛbu -dan -fɔ -a 'klan -e 'o -fɔ jemie -va. ");
INSERT INTO yreNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","-Te 'i 'pɛ 'bɛ -maan i 'wɩ 'wlidɩ \"dra bɛ, 'i 'cɛn 'i man! Kɔɔ -te i wla 'i 'pɛ -tʋwli \"a 'belidɩ nɛn ya'a 'nyaan dɩɛ -a va bɛ, 'bɛ \"yi mlin -kʋdɩ 'tɛ 'va te 'i 'pɛ a \"fli \"bɛ -a da. 'Tɛ zɩɛ ya'a 'driman 'li \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","'Wɩ 'kpa, fɛ zɩɛ -a -nan 'tɛ 'ka 'driman 'li \"fo \"dɩ, ɛn min -le yra yɩdɩ 'leda \"ka \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","-Te 'i 'cɛin 'bɛ -maan i 'wɩ 'wlidɩ \"dra bɛ, 'i 'cɛn 'i man! Kɔɔ -te i wla 'i 'cɛin -tʋwli \"a 'belidɩ nɛn ya'a 'nyaan dɩɛ -a va bɛ, 'bɛ \"yi mlin -kʋdɩ 'tɛ 'va te 'i 'cɛin a \"fli \"bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","'Wɩ 'kpa, fɛ zɩɛ -a -nan 'tɛ 'ka 'driman 'li \"fo \"dɩ, ɛn min -le yra yɩdɩ 'leda \"ka \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ɛn -te 'i yiɛ 'bɛ -maan i 'wɩ 'wlidɩ \"dra bɛ, 'i 'si \"ji! Kɔɔ -te i -wla 'i yiɛ -tʋwli \"a Bali -le mingɔnnɛn trɛ da bɛ, 'bɛ \"yi mlin -kʋdɩ 'tɛ 'va te 'i yiɛ a \"fli \"bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","'Wɩ 'kpa, fɛ zɩɛ -a -nan 'tɛ 'ka 'driman 'li \"fo \"dɩ, ɛn min -le yra yɩdɩ 'leda \"ka \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Fɛ nɛn maan 'vɩ zɩɛ -yɛɛ cɩ 'nan, Bali -pan wɩ -tʋdʋ pɛɛnɔn bɛ, o -wɛ -fɔa \"man. -A -tʋwli \"nɛn \"nyian 'cee vɛ -a, 'tɛ -taa 'ka 'tʋdʋ pɛɛnɔn 'nanjɛnlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","'Wɩ 'kpa, -wɛ a fɛ \"yi \"a. 'Pian -te -wɛ 'nɔnnɔn 'si \"man \"bɛ, -mɛ \"a nɛn waa dra \"nyian 'nɔnnɔn? E \"ka \"fo \"dɩ. \"Le zɩ -wɛ fɛ dra 'nɔnnɔn bɛ, 'ka 'bɔ \"nyian 'ka 'nɔnnɔn 'e 'kɔn 'ka cin man, -e 'ka yei 'e 'fʋ -trɔɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","\"Bɛ -sru Zozi 'si Galile, ɛn e -kʋ Zude 'lɛglɔn 'fʋɩ nɛn Zudan 'yi -sru \"bɛ -a -ji. Ɛn minnun o cin 'yɩ \"man \"nyian \"kaga, -a -nan nɛn e 'wɩ \"paadɩ 'sia o ji \"le zɩ yaa dra 'e 'cɛn bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farizɛn 'nɔn -mie pli \"man. O 'wɩ laabʋ -yrɔ -a wei 'kundɩ -le \"wɛan. Waa laabʋ -yrɔ 'nan: «-Cee -pei -tɔ wɩ -a -si -nɔn 'nan min 'e nan bɔla?» ");
INSERT INTO yreNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ɛn Zozi -a laabʋ -wlɔ 'nan: «-Mɛ \"wɩ nɛn Moizi -a crɛn -tɛ -pei 'fluba 'ji 'nan 'ka drɛ?» ");
INSERT INTO yreNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Waa 'vɩ Zozi lɛ 'nan: «Moizi -a -si -nɔn 'kʋɛ 'nan, -te min \"ta 'e nan bɔala bɛ, 'e lɩ bɔla 'fluba drɛ -e 'e 'nɔn -yrɛ 'vaa -e 'e bɔla.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Zozi \"e -wlɛ 'nan: «'Ka \"trɔɛn \"a \"yuyu, -yee \"wɛan nɛn Moizi -pei zɩɛ -a -tɔ 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","'Pian zɩ Bali fɛ pɛɛnɔn drɛ bɛ, ɛn e -klɔnmɔn drɛ 'o 'vale lɩmɔn -a. ");
INSERT INTO yreNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","-Yee \"wɛan -klɔnmɔn \"sia 'e \"tɩ 'lee 'e \"bʋ \"srɔn, -e 'e lɛa 'e nan man. ");
INSERT INTO yreNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","-A -nan nɛn o \"flinɔn dra min -tʋwli \"a. Wa'a 'kɔan \"nyian min \"fli \"a dɩ, 'pian o drɛ min -tʋwli \"a. ");
INSERT INTO yreNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","-Yee \"wɛan -si 'ka 'e 'nɔndɩ blamin lɛ 'nan fɛ nɛn Bali -a 'pa 'e cin man bɛ, 'e 'cɛn 'e cin man dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Zɩ o 'bɔla \"kɔnnɛn \"bɛ, ɛn -a -srunɔn \"nyian \"o 'wɩ laabʋ -yrɔ 'wɩ zɩɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ɛn yaa 'vɩ -wlɛ 'nan: «Min oo min nɛn 'e nan 'bɔla, ɛn e lɩ pee 'pa bɛ, te e 'wɩ 'wlidɩ drɛ 'e nan 'tʋɩdɩ -a ɛn e lɩ pee wɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","-A -tʋwli \"nɛn \"nyian, -te lɩmɔn 'si 'e 'sran wlu, ɛn e -kɔnnɛn pee 'pa bɛ, te e 'wɩ 'wlidɩ drɛ 'e 'sran 'tʋɩdɩ -a ɛn e -kɔnnɛn pee wɛɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Minnun -ta nannannun -a Zozi lɛ 'nan -e 'e klɛ o man. 'Pian Zozi -srunɔn 'si -tɔ -wlɔ. ");
INSERT INTO yreNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Zɩ Zozi 'wɩ zɩɛ -a -nan 'yɩ bɛ, e 'nan \"man, ɛn yaa 'vɩ 'e -srunɔn lɛ 'nan: «'Ka nannannun 'tʋɩ 'o 'ta 'an 'va! Te 'ka 'si -tɔ -wlɔ \"dɩ! Kɔɔ minnun nɛn \"le -wee 'wɩ 'zʋ bɛ, Bali -le mingɔnnɛn trɛ a -wee vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, minnun nɛn wa'a 'wɩlɛ \"man \"le zɩ nannannun -le 'wɩ 'zʋ -e Bali 'e mingɔnnɛn -blɩ o da dɩɛ, wa'a 'wlamlan -yee mingɔnnɛn trɛda dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","-A -nan nɛn e o 'si, ɛn e -fɔ 'e man. 'E 'pɛ 'pla o da -tʋdʋ, te e -fɛa ve o man. ");
INSERT INTO yreNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Zɩ Zozi 'si 'sia bɛ, tɔɔn min -tʋ -ta -a 'lɛ flan -a, ɛn 'e \"po sɔɔn \"wlu. Yaa 'vɩ Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan tɩglɩ, maan dra 'kɔ, -e 'belidɩ nɛn ya'a 'nyaan dɩɛ, \"an \"yɩ?» ");
INSERT INTO yreNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ɛn Zozi \"e 'nan -yrɛ 'nan: «-Mɛ \"le \"wɛan nɛn, yian laabo min tɩglɩ? -Te ya'a 'silɛa Bali -tʋwli \"a dɩɛ, min -tʋ 'ka tɩglɩ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","I Bali -le -pei -tɔ wɩnun -tɔa. Te 'i drɛ min -tɛzan -a dɩ! Te 'i min nan -wɛɛ \"dɩ! Te 'i crin wʋ dɩ! Te 'i 'wlu 'sɛn min man dɩ! Te 'i min ta -blɩ dɩ! 'I yiɛ 'e 'nan 'i \"tɩ 'lee 'i \"bʋ \"man!» ");
INSERT INTO yreNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","E Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan, -pei pɛɛnɔn zɩɛ, an 'ta wʋladɩ 'sia \"da 'an \"wɛnnɛn da.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Zozi -a -nanjɛɛn tɛin, yaa 'yɩ \"yi, ɛn e -yrɛ 'nan: «'Yie 'wɩ 'fʋ -tʋwli -yɛɛ klɩ 'i man. 'I 'kʋ, fɛnun nɛn 'i 'lɔ bɛ, 'i 'tan, -e 'i man \"lala -pli 'yalɛ -tɛnɔn man! -Te yia drɛ zɩɛ, 'i yɩfɛ -taa \"kɔlɛ laji. \"Bɛ -sru ɛn 'i -sɔɔnla 'an -sru!» ");
INSERT INTO yreNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","'Pian zɩ e 'wɩ zɩɛ -a 'man bɛ, e -si 'sia, te -a ta a -trɔdrɔ, kɔɔ -a yɩfɛ a \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","-A -nan nɛn Zozi 'e -srunɔn 'nanjɛɛn 'e \"srɔn, ɛn yaa 'vɩ -wlɛ 'nan: «Minnun nɛn, 'trɛda fɛnun cɩ -wlɔ \"bɛ, e ya 'plɛblɛ -e 'o drɛ Bali -le mingɔnnɛn trɛdavɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","'Wɩ zɩɛ yaa -srunɔn 'ci baa 'ji, ɛn Zozi -a 'vɩ -wlɛ \"nyian 'nan: «'Mɛn 'nɛnnun, e ya 'plɛblɛ -e min 'e drɛ Bali -le mingɔnnɛn trɛdavɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Min nɛn e ya fɛzan -a bɛ, -e 'e drɛ Bali -le mingɔnnɛn trɛdavɛ -a bɛ, e ya \"man 'plɛblɛ 'wlidɩ. Kɔɔ 'vaa -e 'wɩ zɩɛ 'e drɛ bɛ, te -wi -dan nɛn waa laabo shamo bɛ, e ciɩ 'mɛnzrɛn -yrɛ ji.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","-A -nan nɛn -a -srunɔn 'ci baa 'ji \"mɛn 'e ciɩla \"da, ɛn waa vɩdɩ 'sia 'o cin lɛ 'nan: «-Te 'bɛ a zɩɛ, -tɩɛ -kɔlaman 'sidɩ -a 'wɩ 'ji \"mɛn?» ");
INSERT INTO yreNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zozi o -nanjɛɛn tɛin, ɛn e 'nan -wlɛ 'nan: «Min 'ka 'kɔlaman -e 'e 'fli 'si 'wɩ 'ji dɩ, 'pian Bali 'bɛ -kɔlaman -a drɛdɩ -a. Kɔɔ Bali -kɔlaman 'wɩ pɛɛnɔn drɛdɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ɛn Piɛri -a 'vɩ -yrɛ 'nan: «Kʋʋ \"nun? Kʋ 'si fɛ pɛɛnɔn -sru, ɛn kʋ sɔɔnla 'i -sru.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Zozi -a 'vɩ -yrɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min oo min nɛn e 'si 'yee 'kɔn, 'lee 'e \"bʋɩnun, 'lee 'e \"blunun, 'lee 'e \"bʋ, 'lee 'e \"tɩ, 'lee 'yee 'nɛnnun, 'lee 'yee feinun -sru 'mɛn \"wɛan 'lee Bali -le 'wɩ 'nɔnnɔn 'le \"wɛan bɛ, ");
INSERT INTO yreNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","min zɩɛ, e fɛ pɛɛnɔn zɩɛ -a ye 'e 'pa -a -yaa tʋ 'trɛda. Yaa ye 'kɔnnun -a, ɛn yaa ye \"bʋɩnun -a, ɛn yaa ye \"blunun -a, ɛn yaa ye \"bʋnun -a, ɛn yaa ye 'nɛnnun -a, ɛn yaa ye feinun -a. Minnun -tɛ \"paa \"da, 'pian yaa ye. \"Bɛ -sru tʋ -fɔla \"da ji bɛ, 'belidɩ nɛn, ya'a 'nyaan dɩɛ, e dra -yee vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Minnun nɛn o -trɔa 'si 'lɛ bɛ, o \"kaga -taa \"fɔlɛa \"da, ɛn minnun nɛn o -fɔla \"da \"bɛ, o \"kaga -taa \"drɛlɛ -si 'lɛnɔn 'a.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zozi 'lee 'e -srunɔn a -kʋnan Zeruzalɛm, ɛn Zozi nɛn 'si 'lɛ. -Kʋdɩ Zeruzalɛm \"klan -a -srunɔn 'fuda \"fli 'bɔ 'tɛdɩ 'sia, ɛn minnun nɛn o -sru \"bɛ, nyɛn a \"nyian -wee 'ji. Zozi 'e -srunɔn 'fuda \"fli laabʋ 'o 'saza, ɛn 'wɩ nɛn e \"ta -daa \"bɔlɛ \"man \"bɛ yaa vɩdɩ 'sia -wlɛ. E 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«-Kaa \"ta -ko Zeruzalɛm. -Te -kaa 'bɔla 'nan nun bɛ, minnun Blamin -pɩ -nɔan Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn lɛ. O tin -tɛa \"da 'nan 'e 'ka. Waa -nɔan \"minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Minnun zɩɛ, waa sɛɛ wo, 'o 'le 'yi -sɛan -a yra, waa -sɔan -ngble -a, ɛn waa -tɛa. 'Pian -a yi yaagazan da bɛ, -e 'e 'wluan -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebede -pɩ Zaji 'lee 'e \"bʋɩ Zan pli Zozi man. O -yrɛ 'nan: «Bali -le 'wɩ \"paazan, kʋ ya \"vale 'wɩ nɛn kʋ \"ta -a laabo 'i 'lɔ 'gʋɛ, 'i drɛ 'kʋɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ɛn Zozi -a laabʋ -wlɔ 'nan: «-Mɛ 'va nɛn, ka cɩ?» ");
INSERT INTO yreNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","O 'nan -yrɛ 'nan: «-Te i mingɔnnɛn -blɩdɩ 'sia bɛ, 'i 'wɩ \"man -e 'kʋ -nyran 'i \"srɔn! Min -tʋ -kɔan 'i 'pɛ \"yi \"da, -e min -tʋ 'e 'kɔn 'i 'pɛ bʋ da.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Zozi \"e -wlɛ 'nan: «'Wɩ nɛn ka cɩ -a laabʋnan bɛ, ka'a 'ci tɔa dɩ. 'Wɩ yɩdɩ nɛn e \"ta -daa \"bɔlɛ 'an man bɛ, 'ka 'wulo \"sɔa \"wlu? Ɛn 'tɛ nɛn o \"ta -daa -a 'palɛ 'an da bɛ, 'ka 'wulo \"sɔa \"wlu?» ");
INSERT INTO yreNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","O -yrɛ 'nan: «-Inyan, 'kʋ 'wulo \"sɔa \"wlu.» Ɛn Zozi \"e -wlɛ 'nan: «'Wɩ tɩglɩ nɛn, 'wɩ yɩdɩ nɛn e \"ta -daa \"bɔlɛ 'an man bɛ, e bɔa \"nyian \"cee \"man. Ɛn 'tɛ nɛn minnun \"ta -daa -a 'palɛ 'an da bɛ, waa \"paa \"nyian \"cee \"da. ");
INSERT INTO yreNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","'Pian -nyrandɩ 'an 'pɛ \"yi 'lee 'an 'pɛ bʋ da bɛ, 'an 'bɔ \"cɛɛ -si -nɔan \"min lɛ dɩ. Minnun nɛn Bali -a pla o 'tɔ man bɛ -wee vɛ 'bɛ cɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Zozi -srunɔn 'fu nɛn o -fʋ bɛ, zɩ o 'wɩ zɩɛ -a 'man bɛ, ɛn 'bli 'fɔ o ji Zaji 'lee Zan man. ");
INSERT INTO yreNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","-A -nan nɛn Zozi o pɛɛnɔn laabʋ, ɛn e 'nan -wlɛ 'nan: «Kaa -tɔa 'nan, min tanɔn 'le min pladɩ 'bɛ cɩ -sa wɩ -a. Ɛn minnun nɛn o cɩ min -dandannun -a bɛ, -wɛɛ -va -ble minnun da. ");
INSERT INTO yreNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","'Pian te 'wɩ zɩɛ -nyrɛn 'e 'kɔn 'ka yei \"dɩ. Min oo min nɛn e ya \"vale 'e dra min -dan a 'ka yei \"bɛ, 'e 'fli 'pla min pɛɛnɔn 'wlu o 'sudɩ -a! ");
INSERT INTO yreNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ɛn min oo min nɛn e ya \"vale 'e dra 'ka 'tazan -a bɛ, 'e 'fli drɛ 'ka pɛɛnɔn 'le nɔan -a! ");
INSERT INTO yreNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","'Wɩ 'tʋwli zɩɛ -a 'bɔ nɛn Blamin -pɩ -a drɛ. Ya'a 'talɛ 'nan -e minnun 'o 'su dɩ, 'pian e -ta 'nan -e 'e minnun 'su. Ɛn e -ta 'nan -e 'e 'ka -e min \"kaga 'o 'sʋ Satan -le 'plɛblɛ 'lɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Zozi 'lee 'e -srunɔn ciɩla Zeriko, te o \"ta -ko Zeruzalɛm. \"Wɛɛ 'si Zeriko bɛ, minnun \"kaga sɔɔnla o -sru. Time -pɩ Batime yra 'e -nyrandɩ -si man, te e fɛnun trʋ \"baa -a yiɛ a 'e 'widɩ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Zɩ yaa 'man 'nan, Zozi nɛn 'e \"sia Nazarɛtɩ bɛ, e ya ciɩnan bɛ, ɛn e -paandɩ 'sia 'nan: «Minsan, David kluda min, 'yian nyrinda 'si!» ");
INSERT INTO yreNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɛn minnun paan \"da 'nan 'e 'lɛbo 'pla da. 'Pian e paan \"nyian 'kpa 'plɛblɛ 'nan: «Minsan, David kluda min, 'yian nyrinda 'si!» ");
INSERT INTO yreNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","-A -nan nɛn Zozi 'tɔ, ɛn e 'nan: «'Ka vɩ -yrɛ 'nan, 'e 'ta 'gʋ!» Waa 'vɩ Batime lɛ 'nan: «'I -pɔan 'kun! E 'nan, 'i 'lʋ!» ");
INSERT INTO yreNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tɔɔn e 'yee sɔ 'si 'e da, e wluan lou -blu, ɛn e -kʋ Zozi 'va. ");
INSERT INTO yreNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Zozi \"e -yrɛ 'nan: «-Mɛ \"nɛn i ya \"vale 'nan 'an drɛ 'yiɛ?» Ɛn yiɛ 'wizan -a 'vɩ -yrɛ 'nan: «'An 'san, an ya \"vale 'yian yiɛ 'lɛ 'sʋ!» ");
INSERT INTO yreNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ɛn Zozi \"e -yrɛ 'nan: «'I 'kʋ! 'Yie yi -tɛradɩ 'an da 'i beli.» 'Nun tɔɔn Batime yiɛ 'lɛ 'sʋ, ɛn e -sɔɔnla Zozi -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Zozi 'lee 'e -srunɔn a -plinan Zeruzalɛm. O 'bɔ 'flanun nɛn o o laabo Befaze 'lee Betani bɛ -a \"srɔn. 'Flanun zɩɛ o ya Olivie pɔn man. Ɛn Zozi 'e -srunɔn \"fli 'pa 'sia 'o 'lɛ. Yaa 'vɩ -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«'Ka 'kʋ 'fla nɛn, 'ka 'lɛ bɛ -a da! -Te ka 'bɔla 'nan nun bɛ, ka -aflumun planɛn ye 'e 'baa -tɔdɩ. Min 'ka tian 'fɔlɛ \"da \"dɩ. 'Ka baa 'sʋ -e 'ka 'ta -a 'mɛn 'gʋ! ");
INSERT INTO yreNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","-Te min -tʋ -a laabʋ 'ka 'lɔ 'nan, -mɛ \"nɛn kaa dra -yrɛ \"bɛ, 'ka vɩ -yrɛ 'nan: ‹Minsan \"e 'nan, -aflumun 'wɩ a 'e man. 'Pian e -taa \"a -naagʋ.› » ");
INSERT INTO yreNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","O -kʋ, ɛn o 'bɔ -aflumun planɛn man 'e 'baa -tɔdɩ 'kɔn 'tʋ -kpɛin \"man bei -si man. Ɛn waa baa 'sʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","-A -nan nɛn minnun nɛn o cɩ -nan bɛ, o -mienun -a laabʋ -wlɔ 'nan: «-Mɛ \"nɛn kaa dra? -Mɛ \"le \"wɛan nɛn kaa baa 'sʋ?» ");
INSERT INTO yreNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","'Wɩ nɛn Zozi -a 'vɩ -wlɛ \"bɛ, -a 'bɔ nɛn waa 'vɩ -wlɛ. Ɛn minnun o 'tʋɩ, waa drɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","O -kʋ -aflumun planɛn zɩɛ -a Zozi lɛ. O 'wee sɔnun paala -a koda, ɛn e -nyran \"da. ");
INSERT INTO yreNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Minnun \"kaga 'wee sɔnun paala -a 'lɛ. Ɛn min -mienun yiba \"pɛnɛnnun cɛɛn, ɛn waa 'pla -a 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Minnun nɛn Zozi 'lɛ bɛ, 'lee minnun nɛn o -sru \"bɛ, o pladɩ 'sia -a vɩdɩ -a 'nan: «-Fɛavɛa o! -Fɛavɛa o, Bali -le -fɛa 'e 'kɔn min nɛn Minsan -a 'pa 'sia bɛ -a man! ");
INSERT INTO yreNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bali -le -fɛa 'e 'kɔn mingɔnnɛn -blɩdɩ nɛn, e \"ta -daa \"bɛ -a man! 'Kʋ tra David -le mingɔnnɛn -blɩdɩ nɛn. Bali 'tɔ 'e drɛ -dan laji lou!» ");
INSERT INTO yreNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zɩ Zozi wlala Zeruzalɛm zɩɛ. Ɛn e -kʋ Bali -pan 'kuin 'nan -e 'e fɛ pɛɛnɔn -nanjɛn. Zɩ -pei \"ta taan \"bɛ, ɛn e 'bɔla, e -kʋ Betani 'o 'vale 'e -srunɔn 'fuda \"fli \"a. ");
INSERT INTO yreNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tʋ cɛɛn ɛn Zozi 'si Betani 'o 'vale 'e -srunɔn 'a. \"Wɛɛ -ta -sia bɛ, ɛn dra Zozi 'tɛdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","-A -nan nɛn e fijie yiba \"tʋ 'yɩ -kɔɔbli te -a 'la a \"da. Ɛn Zozi 'kʋ -a -nanjɛnlɛ 'nan -te -a 'blʋ a \"maan? Zɩ e 'bɔ yiba zɩɛ -a wlu bɛ, -a 'la 'saza nɛn yaa 'yɩ \"da. Kɔɔ fijie ba tʋ \"cɛɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ɛn Zozi -a 'vɩ yiba zɩɛ -yrɛ 'nan: «Te min -tʋ 'e 'i 'blʋ -blɩ 'li \"fo \"dɩ!» -A -srunɔn 'wɩ zɩɛ -a 'man. ");
INSERT INTO yreNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","\"Bɛ -sru o 'bɔla Zeruzalɛm, ɛn Zozi wla Bali -pan 'kuin. Minnun nɛn o cɩ Bali -pan fɛnun -tannan, 'lee minnun nɛn o cɩ -a 'lɔnan bɛ, e o -pindɩ 'sia. E \"lala ta -fɔɔnɔn 'le 'tablonun, 'lee -plablo -tannɔn 'le pɛinnun fuila \"man. ");
INSERT INTO yreNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ɛn ya'a min -tʋ 'tʋɩlɛ -e 'e 'ciɩ fɛ -tʋ -a Bali -pan 'kuin dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Zozi 'wɩ 'pla -wlɛ. E 'nan: «E ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan, Bali \"e 'nan: ‹'Mɛn 'kɔn -kɔan 'trɛdanɔn pɛɛnɔn 'le Bali trʋ 'ba 'kɔn 'a.› 'Pian kaa drɛ crin wʋnan -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Zɩ Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn 'wɩ zɩɛ -a 'man bɛ, ɛn o Zozi 'man -wɛɛdɩ 'sia 'nan -e 'o -tɛ. Kɔɔ nyɛn o 'cɛndɩ 'sia, -yee 'wɩ \"paadɩ nɛn e ya 'sɔnan minnun pɛɛnɔn lɛ bɛ, -yee \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Zɩ funnin 'pla bɛ, ɛn Zozi 'lee 'e -srunɔn 'si Zeruzalɛm. ");
INSERT INTO yreNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tʋ cɛɛn ɛn Zozi 'lee 'e -srunɔn lidɩ 'sia 'o da \"nyian Zeruzalɛm. O fijie yiba zɩɛ -a 'yɩ, te e -ka e 'bɔ 'e \"sɛin \"man. ");
INSERT INTO yreNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tɔɔn 'wɩ nɛn Zozi -a 'vɩ fijie yiba zɩɛ -a man bɛ, -a -cin -tɔ Piɛri ji. Ɛn yaa 'vɩ Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan, \"i 'yiɔ! Fijie yiba \"nɛn 'i wei 'pla \"man \"bɛ, e -ka.» ");
INSERT INTO yreNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «'Ka yi -tɛra Bali da! ");
INSERT INTO yreNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -te min -tʋ -a 'vɩ pɔn 'labɛ -yrɛ 'nan: ‹'I 'sʋra 'gʋ, 'i 'kʋ -tɛ jemie -va,› ɛn min zɩɛ ya'a 'e 'ci -fɔɔlɛ dɩ, 'pian e yi -tɛra \"da 'nan Bali -a 'lɛ sɔɔman 'yrɛ bɛ, e dra. ");
INSERT INTO yreNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","-Yee \"wɛan maan ve 'cɛɛ 'nan, fɛ pɛɛnɔn nɛn kaa laabo Bali 'lɔ te ka ya Bali trʋ 'banan bɛ, 'ka yi -tɛra \"da 'nan kaa 'yɩ 'va, tɔɔn kaa ye! ");
INSERT INTO yreNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ɛn -te ka \"ta Bali trʋ \"baa, te min -tʋ man wɩ a 'ka 'ji bɛ, 'ka 'cɛ -yrɛ! 'Ka drɛ zɩɛ -e 'ka \"tɩ \"nɛn laji lou \"bɛ, 'wɩnun nɛn kaa drɛ -yrɛ \"wlidɩ \"bɛ, 'e 'cɛ 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","'Pian -te ka'a min man wɩ cɛa dɩɛ, 'ka \"tɩ \"nɛn laji lou \"bɛ, 'wɩnun nɛn kaa drɛ -yrɛ \"wlidɩ \"bɛ, ya'a \"nyian \"e cɛa 'cɛɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","\"Bɛ -sru Zozi 'lee 'e -srunɔn 'bɔla \"nyian Zeruzalɛm. Ɛn Zozi 'ciɩdɩ 'sia Bali -pan 'kuin. -A -nan nɛn Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn 'lee min cejenun pli \"man. ");
INSERT INTO yreNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Waa laabʋ -yrɔ 'nan: «-Kɔladɩ \"cɛn \"a nɛn i 'wɩnun zɩɛ -a drɛ? Ɛn -tɩɛ -si -nɔn 'yiɛ?» ");
INSERT INTO yreNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «An 'bɔ \"nyian an \"ta 'wɩ 'tʋwli \"cɛ laabo 'ka 'lɔ. -Te kaa -sru 'vɩ 'mɛn bɛ, -kɔladɩ nɛn an 'wɩnun zɩɛ -a drɛ 'a bɛ, maan -ci \"sia 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","-Tɩɛ Zan 'pa 'sia 'nan 'e 'ta min -batize drɛ? Minnun 'bɛ 'pa 'sia, -baa Bali 'bɛ 'pa 'sia? 'Ka vɩ 'mɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","-A -nan nɛn waa vɩdɩ 'sia 'o cin yei 'nan: «-Te -kaa 'vɩ 'nan: ‹Bali 'bɛ 'pa 'sia bɛ›, e -taa -a laabʋlɛ -kaa 'lɔ 'nan: ‹-Mɛ \"le \"wɛan nɛn ka'a yi -tɛala 'wɩ nɛn Zan -a 'vɩ bɛ -a da dɩ?› ");
INSERT INTO yreNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ɛn -te -kaa 'vɩ 'nan: ‹Minnun 'bɛ 'pa 'sia bɛ›, minnun pɛɛnɔn -taa 'wunlɛa -kaa man.» Zuif 'nɔn 'tanɔn zɩɛ, \"klan a o ji, kɔɔ minnun pɛɛnɔn Zan \"siala Bali 'lewei vɩzan -a. ");
INSERT INTO yreNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","-Yee \"wɛan nɛn waa 'vɩ Zozi lɛ 'nan: «Kʋ'a san tɔa dɩ.» Ɛn Zozi -a 'vɩ -wlɛ 'nan: «An 'bɔ \"nyian min nɛn e -si -nɔn 'mɛn ɛn an 'wɩnun zɩɛ -a drɛ bɛ, ma'an 've 'cɛɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Zozi 'wɩ tin 'badɩ 'sia -wlɛ -kɔnnɛn \"ji. Yaa 'vɩ -wlɛ 'nan: «Min -tʋ 'bɛ 'yee rɛzɛn fei 'pa, e -klɔn 'bʋ \"man, e rɛzɛn 'blʋnan drɛ, ɛn e fɛ -tʋ drɛ, min -tɔa \"da -e 'e fei 'bɔ ta 'pin. \"Bɛ -sru e fei zɩɛ -a -pɛba 'wʋ minnun lɔ 'nan 'o 'nyranman 'pa \"da, te o 'yee vɛ -nɔan. Yaa drɛ zɩɛ, ɛn e -kʋ 'lɛglɔn 'pee -ji. ");
INSERT INTO yreNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Zɩ rɛzɛn nan tʋ 'bɔ bɛ, ɛn min zɩɛ 'e 'suzan 'tʋ 'pa 'sia minnun nɛn o 'nyranman \"paa -yee rɛzɛn fei bɛ o va, 'nan 'nyranman nɛn waa 'pa bɛ 'o 'yee vɛ -nɔn. ");
INSERT INTO yreNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","'Pian waa 'suzan zɩɛ -a 'kun, waa -sɔn, ɛn waa 'li 'e da 'e 'lɔ 'a 'e \"tun. ");
INSERT INTO yreNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","\"Bɛ -sru ɛn e 'suzan 'pee 'pa 'sia \"nyian o va. Wɛɛ 'kun, wɛɛ 'sɔn 'e 'wulo -man, wɛɛ srɔn. ");
INSERT INTO yreNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yaa yaagazan 'pa 'sia, ɛn wɛɛ 'tɛ. \"Bɛ -sru min \"kaga \"le vɛ drɛ \"nyian zɩ, waa -mienun -sɔn, ɛn waa -mienun tɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Min -tʋwli \"nɛn, e -fʋ fei san zɩɛ -yrɔ \"bɛ, -yɛɛ cɩ -a 'bɔ 'pɩ -tʋwli \"nɛn, e 'sɔ -yrɛ tɩglɩ bɛ -a. Yaa 'pa 'sia fei 'panɔn zɩɛ o va 'e -fɔla \"da. Yaa 'vɩ 'e 'ji 'nan, o -taa 'yra -tɛlɛ 'e 'pɩ man. ");
INSERT INTO yreNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","'Pian fei 'panɔn -a 'vɩ 'o cin lɛ 'nan: ‹Min 'labɛ -yɛɛ 'e \"tɩ -zia -ble. -Kaa -tɛ, -e -zia zɩɛ 'e drɛ -cee vɛ -a.› ");
INSERT INTO yreNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","-A -nan nɛn waa 'kun, waa -tɛ, ɛn waa -kadɩ tuʋ fei lunɛn -klɔn -sru. ");
INSERT INTO yreNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","'Wɩ zɩɛ -a -ji bɛ, -mɛ \"wɩ nɛn fei san -taa -a drɛlɛ? Maan ve 'cɛɛ 'nan, e -taa -e 'e 'yee fei 'panɔn zɩɛ o -tɛɛ, -e 'e 'yee rɛzɛn fei 'bɔ 'nɔn min peenun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","'Wɩ nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, ka'a ta vɩlɛ dʋʋ? Kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan: ‹-Kɔlɛ nɛn 'kɔn 'tɔnɔn -a tuʋ 'o 'pɛla koda bɛ, -yɛɛ drɛ 'kɔn 'pʋ -fɔ -kɔlɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Minsan 'bɛ drɛ ɛn -kɔlɛ zɩɛ 'e drɛ 'kɔn 'pʋ -fɔ -kɔlɛ -a. 'Wɩ nɛn Minsan -a drɛ bɛ, e min 'plo -fɔa.› » ");
INSERT INTO yreNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zɩ Zuif 'nɔn 'tanɔn -kɔnnɛn zɩɛ -a 'man bɛ, waa -tɔ 'nan 'wee 'wɩ nɛn Zozi -a ve. -Yee \"wɛan o ya \"vale 'o \"kuan, 'pian minnun lɔ \"klandɩ -le \"wɛan waa 'tʋɩ, ɛn o -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","\"Bɛ -sru ɛn Zuif 'nɔn 'tanɔn zɩɛ o Farizɛn 'nɔn -mienun 'lee Erodi -le minnun -mienun 'pa 'sia Zozi 'va -a man -wɛɛdɩ 'nan -e 'o wei 'kun 'le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","O -kʋ, ɛn o 'nan -yrɛ 'nan: «Bali -le 'wɩ \"paazan, kʋa -tɔa 'nan, i ya 'wɩ tɩglɩ vɩzan -a. Yi'a 'klanman min lɔ 'wɩ tɩglɩ ci 'sidɩ -a -yrɛ dɩ. Ɛn yi'a min bo \"va \"dɩ. 'Pian i Bali -sru 'ta wʋdɩ \"paaman minnun ji 'e tɩglɩ da. -Yee \"wɛan kʋa laabo 'i 'lɔ 'nan, -a -si a -kaa 'lɔ -e -kaa 'sukɔlɛ -pan wʋ Rɔm 'nɔn 'le mingɔnnɛn Seza lɛ, -baa te -ka'a drɛ dɩ? 'I vɩ 'kʋɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","'Pian 'wɩ nɛn -a -cin cɩ o ji bɛ, Zozi -a -kɔnnɛn 'yɩ, ɛn yaa 'vɩ -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn, ka ya \"vale kaan wei \"kuan? 'Ka 'ta 'lein 'wlɛ 'tʋ -a 'mɛn -e 'an yɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Waa -tʋ -nɔn -yrɛ. -A -nan nɛn Zozi -a laabʋ -wlɔ 'nan: «-Tɩ -wulo -fodo nɛn 'gʋ? Ɛn -tɩ 'tɔ 'crɛn nɛn 'gʋ?» O -yrɛ 'nan: «Rɔm 'nɔn 'le mingɔnnɛn Seza -le vɛ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «Fɛ nɛn Seza -le vɛ -a bɛ, 'cɛɛ 'nɔn Seza lɛ! Ɛn fɛ nɛn Bali -le vɛ -a bɛ, 'cɛɛ 'nɔn Bali lɛ!» 'Wɩ zɩɛ -a mandɩ o 'plo 'fɔ. ");
INSERT INTO yreNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","\"Bɛ -sru ɛn Saduze 'nɔn -mie pli Zozi man. Saduze 'nɔn \"o \"ve 'nan, -te min -ka bɛ, ya'a 'wuanla -kanɔn 'va dɩ. Zɩ o pli \"man \"bɛ, ɛn waa laabʋ -yrɔ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Bali -le 'wɩ \"paazan, 'wɩ nɛn Moizi -a crɛn -tɛ 'kʋɛ bɛ, -nyrɛn 'gʋ: ‹-Te min lɩ 'pa, ɛn -a san zɩɛ e -ka, te wa'a tian 'nɛn 'yalɛ 'o 'vale 'e nan 'bɔ 'a dɩɛ, -yee -cale zɩɛ -a \"bʋɩ 'e 'pa, -e 'e \"bʋɩ klu bɔla!› ");
INSERT INTO yreNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Min -tʋ -le 'nɛn -klɔnmɔn a 'sɔravli. -A tɛdɛ lɩ 'pa, ɛn e -ka, te wa'a 'nɛn 'yalɛ 'e nan 'bɔ 'a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","-A \"flizan \"e -cale -tʋwli zɩɛ -a 'pa, ɛn e -ka, te wa'a 'nɛn 'yalɛ dɩ. -A yaagazan 'le vɛ drɛ \"nyian zɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","O 'sɔravli \"lɩ zɩɛ -a 'pa, ɛn o pɛɛnɔn kaa, te wa'a 'nɛn 'yalɛ dɩ. \"Bɛ -sru ɛn lɩ 'bɔ \"e \"ka 'wʋ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tʋ nɛn minnun wuanla -kanɔn 'va bɛ, lɩ zɩɛ e -kɔan -tɩ nan -a? 'I vɩ 'kʋɛ! Kɔɔ o 'sɔravli 'bɔ -a 'pa lɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Ka'a tian 'wɩ 'tʋ -ci manlɛ \"fo \"dɩ. 'Wɩ nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, ka'a -ci maan dɩ, ɛn Bali -le 'plɛblɛ bɛ, ka'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kɔɔ tʋ nɛn minnun wuanla -kanɔn 'va bɛ, -klɔnmɔnnun 'ka lɩ paa dɩ, ɛn lɩmɔnnun 'ka -kɔnnɛn paa dɩ. O -kɔan \"le Bali -le 'pasianɔn nɛn laji bɛ -wee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","-Te -a -cin a 'ka 'ji 'nan, minnun nɛn o kaa bɛ wa'a 'wuanla -kanɔn 'va dɩɛ, te ka ya 'ka 'fli see \"paanan. 'Wɩ 'nɛn 'e 'crɛn -tɛdɩ Moizi -le 'fluba 'ji bɛ, ka'a tian -a ta vɩlɛ dʋʋ? Kɔɔ tʋ nɛn Bali a yiba \"kpizrɛnnɛn 'va ɛn e 'wɩ tin 'ba Moizi lɛ bɛ, yaa 'vɩ -yrɛ 'nan: ‹An ya Abraam -le Bali -a, ɛn an ya Izak -le Bali -a, ɛn an ya Zago 'le Bali -a.› ");
INSERT INTO yreNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tʋ nɛn Bali 'wɩ zɩɛ -a ve bɛ, te -kaa tranun zɩɛ o kaa -a -nan 'mɔn. 'Pian Bali \"le 'va bɛ, o yiɛ a \"man tian, kɔɔ Bali a minnun nɛn o yiɛ cɩ \"man \"bɛ -wee Bali -a, e 'ka minnun nɛn o kaa bɛ -wee Bali -a dɩ. -Yee \"wɛan ka'a 'wɩ 'tʋ -ci manlɛ \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","'Fluba 'ci vɩzan -tʋ -sa zɩɛ -a 'man. Zɩ yaa 'yɩ 'nan Zozi -a -ci 'vɩ Saduze 'nɔn lɛ fɛnyian bɛ, e pli Zozi man, ɛn yaa laabʋ -yrɔ 'nan: «Bali -le -pei -tɔ wɩ pɛɛnɔn bɛ, -a \"cɛn 'bɛ cɩ \"va -dan?» ");
INSERT INTO yreNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ɛn Zozi \"e 'nan -yrɛ 'nan: «Bali -le -peinun pɛɛnɔn 'va bɛ, -pei -dan nɛn 'gʋ: ‹Izraɛl 'nɔn, 'ka \"trɔɛn \"tɔ! -Kaa 'san Bali 'bɛ cɩ Minsan -a 'e 'tʋwli. ");
INSERT INTO yreNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ɛn 'i Minsan 'bɔ nɛn 'yie Bali -a bɛ, -a yɩ \"yi 'i 'bli pɛɛnɔn 'a! 'I yɩ \"yi 'yie 'wɩ drɛdɩ pɛɛnɔn 'a! 'I yɩ \"yi 'yie ci \"nrɔndɩ pɛɛnɔn 'a! 'I yɩ \"yi 'yie 'plɛblɛ pɛɛnɔn 'a!› ");
INSERT INTO yreNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ɛn -a \"flizan nɛn 'gʋ: ‹'I bɔɛzan -tʋ yɩ \"yi \"le 'yie 'wɩ 'zʋ!› Bali -le -pei -tɔ wɩ pee -dan 'ka 'mlian -pei \"fli zɩɛ o da dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ɛn 'fluba 'ci vɩzan -a 'vɩ -yrɛ 'nan: «Bali -le 'wɩ \"paazan, yia 'vɩ fɛnyian. 'Yie tin a 'nɔnnɔn -a vɩdɩ -a 'nan, Minsan 'bɛ cɩ Bali a 'e 'tʋwli, -a pee \"ka \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","-Yee \"wɛan min 'e Bali yɩ \"yi 'e 'bli pɛɛnɔn 'a, 'lee 'yee ci \"nrɔndɩ pɛɛnɔn 'a, 'lee 'yee 'plɛblɛ pɛɛnɔn 'a! Ɛn 'e bɔɛzan -tʋ yɩ \"yi \"le 'e 'bɔ 'le 'wɩ 'zʋ! 'Wɩ zɩɛ -a drɛdɩ -dan \"mlian 'sraga nɛn waa 'tɛ 'ble Bali lɛ bɛ, -a da. Ɛn -a -dan \"mlian 'sraga pɛɛnɔn bʋdɩ Bali lɛ da.» ");
INSERT INTO yreNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zɩ Zozi -a 'yɩ 'nan, min zɩɛ yaa -sru 'vɩ 'wɩ 'tɔdɩ -a bɛ, ɛn e 'nan -yrɛ 'nan: «E -fʋ \"wɛnnɔn -e Bali -le mingɔnnɛn -blɩdɩ 'e pou 'sia 'i 'va.» \"Bɛ -sru 'wɩ laabʋdɩ -yrɔ \"cin 'ka \"nyian -tɔlɛ min -tʋ ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Zozi a 'wɩ \"paanan minnun ji Bali -pan 'kuin. Ɛn yaa 'vɩ -wlɛ 'nan: «E drɛ 'kɔ ɛn 'fluba 'ci vɩnɔn \"o 'nan, min 'sizan 'wɩ 'ji Crizi a David kluda min -a? ");
INSERT INTO yreNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kɔɔ David 'bɔ -a 'vɩ, tʋ nɛn Bali lei 'saun 'ta 'tɔ \"man \"bɛ, -a 'nan: ‹Minsan Bali -a 'vɩ 'an 'san lɛ 'nan: 'I 'nyran 'an 'pɛ \"yi \"da -trilii, -e 'an 'cɛn 'i 'nanmannɔn 'klɩdɩ man.› ");
INSERT INTO yreNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","-Te David 'bɔ Crizi laabo 'e 'san bɛ, e drɛ 'kɔ ɛn 'bɛ -kɔan David kluda min -a?» Min \"kaga \"trɔɛn \"a 'e 'tɔdɩ -yrɛ ci \"nrandɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ɛn yaa 'vɩ \"nyian 'yee 'wɩ \"paadɩ 'bɔ 'va 'nan: «'Ka yiɛ 'tɔ 'ka 'fli -va! -Te 'ka 'wɩ drɛ \"le 'fluba 'ci vɩnɔn 'le 'wɩ 'zʋ! O -tɔɔdɩ ye \"yi -tralɛ -gblɔnun nɛn fɛnyian bɛ -a -ji. Ɛn waa ye \"yi \"le 'nan min 'e o 'tɔ bʋ -guada. ");
INSERT INTO yreNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","-Te e ya cin yɩ 'kuin -a oo, ɛn -te e ya \"fɛdi da -a oo, -nyran \"nan 'kpagba nɛn waa 'sidɩ ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","O fɛnun \"sia -calenun lɔ -dawli -a. \"Bɛ -sru -e 'o Bali trʋ 'ba -plɔun 'nan -e minnun 'o o \"sia min tɩglɩ 'a. 'Wɩnun zɩɛ -a drɛdɩ -le \"wɛan Bali -wee tin \"paa 'plɛblɛ 'kpa.» ");
INSERT INTO yreNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","\"Bɛ -sru ɛn Zozi 'kʋ -nyɛnlɛa -gbogbo nɛn minnun \"lala -sɛan \"ji Bali -le vɛ -a bɛ -a \"srɔn. Minnun nɛn o cɩ \"lala -sɛnnan -ji bɛ, e o -nanjɛndɩ 'sia. Fɛnɔn \"kaga \"ta, ɛn o \"lala -sɛn -ji \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","\"Bɛ -sru ɛn -cale seezan -tʋ -ta, e -bablu 'wlɛ 'tʋdʋ -fɔ -ji \"fli. ");
INSERT INTO yreNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","-A -nan nɛn Zozi 'e -srunɔn laabʋ 'e \"srɔn, ɛn yaa 'vɩ -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -cale seezan 'labɛ, e fɛ -nɔn Bali lɛ e mlin minnun pɛɛnɔn nɛn waa -nɔn 'gʋɛ o da. ");
INSERT INTO yreNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kɔɔ o pɛɛnɔn nɛn waa -nɔn 'gʋɛ, \"lala a -wlɔ \"kaga. 'Pian lɩ 'labɛ, \"lala pɛɛnɔn nɛn -yrɔ -yee fɛ -blɩ \"man \"vɛ -a bɛ, -a 'bɔ nɛn yaa -nɔn Bali lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Zozi a bɔlanan Bali -pan 'kuin, ɛn -a -sruzan 'tʋ -a 'vɩ -yrɛ 'nan: «Bali -le 'wɩ \"paazan, \"i 'yiɔ, Bali -pan 'kɔn bɛ, waa -tɔ -kɔlɛ fɛnyian -a. Ɛn waa -tɔ -dandan 'e pɛɛnɔn.» ");
INSERT INTO yreNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «'Kɔn -dandannun nɛn kaa -sɩ -fɔa 'labɛ, yi nɛn o -wiiman bɛ, e ya -tanan bɔdɩ -a. -A -tɔ -kɔlɛ pɛɛnɔn fuimlan \"man, -a -tʋ 'ka -fo 'e bɔɛzan da dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","\"Bɛ -sru ɛn Zozi 'kʋ -nyɛnlɛa Olivie pɔn da te -a yra a Bali -pan 'kɔn da zia. -A -nan nɛn Piɛri, 'lee Zaji, 'lee Zan, 'lee Andre 'wɩ laabʋ -yrɔ 'o 'saza yei. O 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«'Wɩ nɛn i \"sia -a vɩnan 'gʋɛ, tʋ \"cɛn \"man nɛn e dra? Ɛn -mɛ \"man nɛn, waa -kɔnnɛn \"ye 'nan 'wɩnun zɩɛ o \"ta dra? 'I vɩ 'kʋɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Zozi -a vɩdɩ 'sia -wlɛ 'nan: «'Ka yiɛ 'tɔ 'ka 'fli -va! Te min -tʋ 'e 'ka see \"paa -e 'ka 'si -si tɩglɩ da dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Min \"kaga -taa \"talɛ 'an 'tɔ da. Waa ve 'nan, 'wɛɛ cɩ Crizi -a. Ɛn o -taa minnun \"kaga see \"paalɛ -e 'o 'si -si tɩglɩ da. ");
INSERT INTO yreNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ka -kuli -tan wɩnun maan, ɛn ka 'fla -kɔɔbli -kɔɔbli da -kuli wɩnun maan. 'Wɩnun zɩɛ te 'o 'ka 'cɛn nyɛn -a dɩ! Kɔɔ 'wɩnun zɩɛ -wɛɛ dra 'e 'flin, 'pian 'trɛda -nyan tʋ \"cɛɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","'Lɛglɔn 'tʋ -ji 'nɔn -taa 'wunlɛa 'lɛglɔn 'tʋ -ji 'nɔn man, ɛn mingɔnnɛn trɛ -tʋ -taa 'wunlɛa mingɔnnɛn trɛ -tʋ man. 'Trɛ -taa 'nyɔɔnlɛ fɛ \"kaga \"nan, ɛn dra -dandan -taa \"minnun -tɛɛlɛ. 'Wɩ yɩdɩ pou sianan \"nɛn. 'Pian -a pɛɛnɔn zɩɛ e ya \"le 'nan 'nɛn 'yadɩ -le ci -yaa pou sianan 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","'Ka yiɛ 'tɔ 'ka 'fli -va! Minnun 'ka \"kuan -e 'o -kʋ 'ka 'a tin 'banɔn 'cɛin -da. Zuif 'nɔn -taa 'ka 'sɔnlɛ sɔnba \"a 'wee cin yɩ 'kɔnnun -ji. Ɛn \"nyian bɛ, minnun -taa \"kʋlɛ 'ka 'a -kɔnmandannun 'lee mingɔnnɛnnun cɛin -da 'mɛn \"wɛan. -A -nan nɛn ka dra 'mɛn 'wɩ 'nan yɩnɔn 'a o 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kɔɔ Bali -le 'wɩ 'nɔnnɔn fuimlan \"man 'lɛglɔn 'tʋdʋ pɛɛnɔn 'ji, 'vaa -e 'trɛda -nyan tʋ 'e bɔ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","-Te minnun 'ka 'kun, ɛn o -kʋ 'ka 'a tin 'banɔn 'cɛin -da bɛ, 'wɩ nɛn kɔ 'ka vɩ bɛ, te -a nyɛn 'e 'kɔn 'ka 'ji dɩ! 'Pian 'wɩ nɛn Bali -a -cin -tɔa 'ka 'ji, te -a tʋ 'bɔ bɛ, -a 'bɔ nɛn 'ka vɩ! Ya'a 'taa 'silɛ 'ka 'bɔ 'va dɩ, 'pian Bali lei 'saun 'bɛ \"paa 'ka 'le. ");
INSERT INTO yreNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","\"Bʋɩ -mie -taa 'e 'bɔ 'fli \"bʋɩ -nɔnlɛ minnun lɛ 'nan 'o -tɛ. Ɛn 'nɛn \"tɩ -mie -taa 'yee 'nɛn 'nɔnlɛ minnun lɛ 'nan 'o -tɛ. Ɛn 'nɛnnun -mie -taa 'wunlɛa 'o \"tɩnun 'lee 'o \"bʋnun man 'nan minnun 'e o -tɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ka drɛ 'mɛn vɛ -a -le \"wɛan bɛ, min pɛɛnɔn -taa 'nanlɛ 'ka man, wa'a 'taa 'ka yɩlɛ \"yi \"dɩ. 'Pian min nɛn e -tɔ 'plɛblɛ, ɛn e 'bɔ -a 'le 'srannan \"bɛ, e \"sia 'wɩ 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Tʋ -tʋ -taa \"bɔlɛ bɛ, 'wɩ 'wlidɩ \"nɔnnɔan -taa \"kɔnlɛ fɛnan nɛn e 'ka \"le 'e 'kɔn dɩɛ -a -nan. Min nɛn e 'fluba 'gʋɛ -a ta ve bɛ, 'e 'ci man 'kpa! Tʋ nɛn 'wɩ zɩɛ kaa 'yɩ drɛnan Bali -pan 'kuin bɛ, minnun nɛn o cɩ Zude 'lɛglɔn 'ji bɛ, 'o flan 'bli, 'o 'kʋ pɔnnun yei! ");
INSERT INTO yreNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ɛn -te min a bei \"bɛ, te 'e -wla 'yee 'kuin -e 'e 'kʋ fɛ -tʋ 'sia dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ɛn -te min a fei bɛ, te 'e li 'e da 'fla -e 'e 'kʋ 'yee -tralɛ 'si 'yee 'kuin dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lɩmɔnnun nɛn o -pɔn cɩ 'o man tʋ zɩɛ -a man bɛ, 'lee lɩmɔnnun nɛn 'nɛn 'nyɔn -mlian -wlɔ tʋ zɩɛ -a man bɛ, -wee yra yɩdɩ \"mlianla \"da. ");
INSERT INTO yreNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","'Ka Bali trʋ 'ba 'nan, te 'wɩ zɩɛ 'e 'tria laa 'fɛn tʋ -man dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kɔɔ 'wɩ yɩdɩ -kɔan -dan 'kpa tʋ zɩɛ -a man. Zɩ Bali 'trɛ drɛ 'li -e 'e bɔ cɛɛgʋ yi -a bɛ, -a sʋman 'wɩ yɩdɩ 'ka tian drɛlɛ dɩ. Ɛn 'wɩ yɩdɩ zɩɛ -a pee 'ka 'dra \"nyian 'li 'trɛda \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yinun nɛn 'wɩnun zɩɛ o dra \"da \"bɛ, Minsan Bali -a -mie cɛɛn \"da. -Te ya'a 'wɩ zɩɛ -a drɛlɛ dɩɛ, \"te min -tʋ -wulo 'ka -taa bɔlɛa \"va \"dɩ. 'Pian minnun nɛn e o 'si \"va 'yee vɛ -a bɛ, -wee \"wɛan e yinun -mie cɛɛn \"da. ");
INSERT INTO yreNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","-Te min -tʋ -a 'vɩ 'cɛɛ 'nan, min 'sizan 'wɩ 'ji Crizi a 'gʋ, -te 'bɛ \"cɛɛ dɩ, e ya -miɛn bɛ, te 'ka yi -tɛra \"da \"fo \"dɩ! ");
INSERT INTO yreNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kɔɔ minnun nɛn o 'wlu -sɛan 'nan 'wɛɛ cɩ Crizi -a bɛ, o -taa \"kɔnlɛ 'trɛda. Ɛn minnun nɛn o 'wlu wɩnun ve, te waa ve 'nan Bali 'lewei vɩnɔn nɛn waa bɛ, o -taa \"kɔnlɛ \"nyian. O -taa 'lɛbo \"fɔ wɩ -dandan 'lee -cɛ -srɔn \"wɩ -dandan drɛlɛ. Waa dra 'nan, -te 'o 'pɛ 'sɔ 'a bɛ -e 'o minnun nɛn Bali o 'si \"va 'yee vɛ -a bɛ, o 'si -si tɩglɩ da. ");
INSERT INTO yreNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","'Cee vɛ bɛ, 'ka yiɛ 'tɔ 'ka 'fli -va 'kpa! An 'wɩ pɛɛnɔn 'vɩ 'cɛɛ 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«-Te 'wɩ yɩdɩ -dan zɩɛ, e cɛɛn -nyandɩ man bɛ, 'nun tɔɔn yidɛ yra klun -tɔala, mlɛn 'bidɩ 'e 'le -tɔa, ");
INSERT INTO yreNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mlɛn crɛnnun \"sia laji, o -tɛɛmlan \"tra, ɛn laji fɛnun pɛɛnɔn nɛn 'plɛblɛ a -wlɔ \"bɛ, o \"sia 'o 'klu -ji. ");
INSERT INTO yreNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tɔɔn te minnun pɛɛnɔn 'an 'bɔ Blamin -pɩ ye -tanan \"lolu -koei \"da. 'Plɛblɛ -dan -kɔan 'an 'lɔ, ɛn 'tɔ -dan -kɔan 'an 'lɔ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bali -le 'pasianɔn nɛn laji bɛ, an o \"paa -sia 'trɛda fɛ pɛɛnɔn 'nan -e 'o minnun nɛn an o 'si \"va 'mɛn vɛ -a bɛ, o o cin yɩ. Fɛ -tʋ -nan 'ka 'fo 'trɛda, te wa'a min 'silɛ 'bɛ 'nan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","'Wɩ nɛn e dra fijie yiba \"lɛ bɛ, 'e drɛ 'cee 'wɩ -kɔɔn \"manvɛ -a! -Te -a 'la nrindɩ 'sia \"da \"bɛ, kaa -tɔa 'nan 'munmun tʋ a -tanan bɔdɩ -a -kogo. ");
INSERT INTO yreNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","-A -tʋwli \"nɛn \"nyian, 'an 'bɔ Blamin -pɩ -tadɩ -le vɛ -a. -Te ka 'wɩnun nɛn maan 'vɩ 'cɛɛ bɛ, -a 'yɩ drɛnan bɛ, 'ka -tɔ 'nan 'an 'tadɩ a bɔnan -kogo! ");
INSERT INTO yreNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'ka -naagʋnɔn 'gʋɛ, ka'a 'cɛan -kaadɩ man 'vaa -e 'wɩnun zɩɛ 'o drɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Labli 'lee 'trɛ 'nyan tʋ a, 'pian 'an wei -fo -nan 'li 'trilii. ");
INSERT INTO yreNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tʋ nɛn an -taa \"man \"bɛ, blamin -tʋ 'ka -a tɔa \"fo \"dɩ. Ɛn Bali -le 'pasianɔn nɛn laji bɛ, wa'a tɔa \"fo \"dɩ, ɛn 'an 'bɔ Blamin -pɩ ma'an tɔa \"fo \"dɩ, 'pian 'an \"tɩ 'bɛ -tɔa 'e 'tʋwli. ");
INSERT INTO yreNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","-Yee \"wɛan 'ka yiɛ -tɔ 'ka 'fli -va! Te 'ka yi -tɛ dɩ! Kɔɔ tʋ nɛn, 'wɩ zɩɛ e dra \"man \"bɛ, ka'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","-A -kɔɔn \"man wɩ nɛn 'gʋ. Min -tʋ 'bɛ \"ta -ko 'ta -kɔɔbli wʋnan. E 'yee 'kɔn 'pɛba 'wʋ 'e 'sunɔn 'lɔ. Min -tʋ 'lee 'yee 'nyranman -a 'bɔ nɛn yaa -nɔn o -tʋdʋ pɛɛnɔn lɛ. Ɛn yaa 'vɩ min nɛn 'e yiɛ -tɔa -klɔn -yrɛ \"nɛn \"bɛ, -yrɛ 'nan, te 'e yi -tɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","-A -tʋwli \"nɛn \"nyian 'cee vɛ -a. -Yee \"wɛan te 'ka yi -tɛ dɩ! Kɔɔ tʋ nɛn, 'kɔn san lia 'e da \"man \"bɛ, ka'a tɔa dɩ. -Te funninmlan nɛn oo, -te bada nɛn oo, -te mannɛn tɛdɛ -a nɛn oo, -te bodrun nɛn oo, ka'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","-Yee \"wɛan te 'ka yi -tɛ dɩ! \"Tɔgɔ e 'bɔ 'ka man kligli te ka ya yi -tɛnan. ");
INSERT INTO yreNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","'Wɩ nɛn an cɩ -a vɩnan 'cɛɛ 'gʋɛ, e ya min pɛɛnɔn 'le vɛ -a. Te 'ka yi -tɛ dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zuif 'nɔn tranun -le 'si nɛn waa 'wʋ nɔanba -ji bɛ, -a \"fɛdi yi -fʋ \"fli -e 'e bɔ. \"Fɛdi zɩɛ -a da nɛn minnun 'kpɔun nɛn 'mannyan 'ka \"va \"dɩɛ -a -ble. Tʋ zɩɛ -a man bɛ, te Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn a Zozi 'man -fɔɔnan 'nan, -e 'o 'kun ci 'cɛn 'a -e 'o -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","'Pian waa 'vɩ 'o cin yei 'nan: «Te -kaa drɛ \"fɛdi yi da dɩ! \"Tɔgɔ minnun 'o -nan yɩ -e 'o 'wluan -kaa man.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Zozi a Betani. E ya Simɔn nɛn -kogobe a \"nɛn \"man \"bɛ -yee 'kuin 'e -nyrandɩ fɛnun -sru. -A -nan nɛn lɩmɔn -tʋ pli Zozi man 'e 'lɔ le -pɔnɛn 'tʋ -a. -Laziglɔ nɛn waa laabo nard bɛ, e ya -ji. E 'ka 'e baadɩ fɛ -tʋ -a dɩ, ɛn -a 'flɛ a 'plɛblɛ 'kpa. Yaa 'lɛ 'sʋ, ɛn yaa -sɛn Zozi 'win -ji. ");
INSERT INTO yreNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","'Wɩ zɩɛ e 'nan min -mienun man, ɛn waa 'vɩ 'o cin yei 'nan: «-Mɛ \"le \"wɛan nɛn e -laziglɔ 'kpa bɛ -a srɛ 'e \"tun? ");
INSERT INTO yreNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","-Laziglɔ 'labɛ yaa -taan paan. -A 'flɛ bɔa yi -yaa yaaga 'nyranman \"lala -a, -e 'o -pli 'yalɛ -tɛnɔn man.» Ɛn o 'wɩ blɩ lɩmɔn zɩɛ -a va. ");
INSERT INTO yreNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","'Pian Zozi -a 'vɩ -wlɛ 'nan: «'Ka lɩ 'labɛ -a 'tʋɩ flɩɩ! -Mɛ \"le \"wɛan nɛn, ka 'wɩ -tɔa \"man? E 'wɩ \"yi drɛ 'mɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","'Yalɛ -tɛnɔn a 'ka 'va tʋ pɛɛnɔn man. Ɛn tʋ nɛn e 'sɔ 'cɛɛ bɛ, ka -kɔlaman 'wɩ \"yi \"drɛdɩ -a -wlɛ. 'Pian 'mɛn vɛ bɛ, an 'ka 'ka 'va 'gʋ tʋ pɛɛnɔn man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","'Wɩ nɛn e -kɔlaman -a bɛ, -a 'bɔ nɛn yaa drɛ. -Laziglɔ nɛn yaa -sɛn 'an da 'gʋɛ, 'an 'man nɛn yaa drɛ 'nan -e 'waan wʋ -a. ");
INSERT INTO yreNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, fɛnan pɛɛnɔn nɛn minnun Bali -le 'wɩ 'nɔnnɔn ve 'trɛda bɛ, 'wɩ nɛn lɩ 'gʋɛ yaa drɛ bɛ, waa -nan 'sinan \"paa, ɛn -yɛɛ -maan 'lɔɔ -e lɩ 'bɔ 'cin 'e 'fɔla minnun ji.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","\"Bɛ -sru ɛn Zozi -srunɔn 'fuda \"fli 'va min -tʋ nɛn waa laabo Zudazi Karioti bɛ, e -kʋ Bali -pannɔn 'tanɔn 'va, 'nan -e 'e Zozi 'nɔn -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Zɩ e 'wɩ zɩɛ -a 'vɩ -wlɛ \"bɛ, e o ci nran. -A -nan nɛn o -tɔ \"da 'nan, 'o -taa \"lala -nɔnlɛ -yrɛ. Yi zɩɛ -a da nɛn Zudazi -a man -wɛɛdɩ 'sia 'nan, tʋ \"yi 'e 'pla -e 'e Zozi 'nɔn Zuif 'nɔn 'tanɔn 'bɔ lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","\"Fɛdi nɛn Zuif 'nɔn 'kpɔun nɛn 'mannyan 'ka \"va \"dɩɛ, -a -ble \"da \"bɛ e 'bɔ. -A yi tɛdɛ da nɛn o 'blanun -tɛɛman -e 'o tranun 'si nɔanba -ji \"fɛdi -blɩ. Ɛn Zozi -srunɔn -a laabʋ -yrɔ 'nan: «Nyin zia nɛn i ya \"vale 'nan 'kʋ 'kʋ \"fɛdi fɛnun -tɔɛn 'yiɛ?» ");
INSERT INTO yreNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ɛn Zozi 'e -srunɔn \"fli 'pa 'sia. Yaa 'vɩ -wlɛ 'nan: «'Ka 'kʋ Zeruzalɛm! Ka bɔa min -tʋ man. 'Yi 'tɔbɔ -kɔan -yrɔ. 'Ka -sɔɔnla -a -sru! ");
INSERT INTO yreNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","'Kɔn nɛn, e wla 'ji bɛ, 'ka vɩ -a san lɛ 'nan: ‹Bali -le 'wɩ \"paazan \"e 'nan, 'kʋ laabʋ 'i 'lɔ 'nan, 'kɔn \"bʋ \"nɛn 'kʋ 'vale 'an -srunɔn 'a, kʋ -kaa tranun 'sidɩ nɔanba -ji \"fɛdi -ble -ji bɛ, e ya nyin zia?› ");
INSERT INTO yreNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","E -taa 'kɔn \"bʋ -dan tʋ -kɔɔnlɛ 'cɛɛ 'kɔn 'ta lou, te -a -ci a 'e drɛdɩ 'va. Fɛ zɩɛ -a -nan nɛn 'ka -cee fɛnun -tɔɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","-A -nan nɛn -a -srunɔn zɩɛ, o -kʋ 'fla. Waa 'yɩ \"le zɩ Zozi -a 'vɩ -wlɛ \"bɛ, -yee 'wɩ 'zʋ. Ɛn o 'si nɔanba -ji \"fɛdi fɛnun man drɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Zɩ funninmlan 'pla bɛ, ɛn Zozi 'ta 'o 'vale 'e -srunɔn 'fuda \"fli \"a. ");
INSERT INTO yreNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tʋ nɛn o yra fɛnun -sru \"bɛ, ɛn Zozi -a 'vɩ -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -kaa nɛn -kaa cɩ fɛnun -blɩnan 'gʋɛ, 'ka 'va min -tʋ 'bɛ -taa 'an 'nɔnlɛ minnun lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","-A -srunɔn 'ta drɛ 'trɔdrɔ, ɛn waa laabʋdɩ 'sia -yrɔ \"tʋdʋ 'nan: «'An 'bɔ nɛn?» ");
INSERT INTO yreNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «'Ka min -fuda \"fli \"nɛn, -kaa cɩ fɛnun -blɩnan 'e cin va 'gʋɛ, 'ka 'va min -tʋ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","'Wɩ tɩglɩ nɛn, Blamin -pɩ \"ta -daa \"kalɛ \"le zɩ waa crɛn -tɛ Bali -le 'fluba 'ji bɛ -yee 'wɩ 'zʋ. 'Pian min nɛn, e Blamin -pɩ -nɔan \"minnun lɛ bɛ, 'wɩ -taa \"bɔlɛ -a san man. E ya paan -a san -le 'wɩ \"yi \"a -e 'o vɩlɛ 'o -ya dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","O -fʋ fɛnun -blɩnan, ɛn Zozi 'kpɔun 'si. E Bali muo \"fɔ, yaa \"nɛn jɛɛn, ɛn yaa -nɔn -wlɛ. E 'nan -wlɛ 'nan: «'Ka 'si! -Nyrɛn 'gʋɛ, 'an 'kɔlɛ nɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","\"Bɛ -sru e 'kulenɛn nɛn rɛzɛn -wɛn cɩ -ji bɛ -a 'si. E Bali muo \"fɔ, yaa -nɔn -wlɛ, ɛn waa mlin 'o pɛɛnɔn. ");
INSERT INTO yreNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yaa 'vɩ -wlɛ 'nan: «-Nyrɛn 'gʋɛ, 'an nyɛn nɛn. -Yɛɛ \"ta -sɛanla -e 'e drɛ min \"kaga -pli \"vɛ -a \"nyian Bali man 'e 'pee. ");
INSERT INTO yreNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, ma'an \"nyian rɛzɛn -wɛn pee mlian dɩ -trilii, -e yi nɛn maan -mlian 'e 'pee Bali -le mingɔnnɛn trɛda bɛ 'e bɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Zɩ o cɛɛn fɛnun -blɩdɩ man bɛ, o Bali 'tɔ bɔ \"dre \"fɔ. Ɛn o -kʋ Olivie pɔn da. ");
INSERT INTO yreNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","-A -nan nɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «'Ka pɛɛnɔn 'ci -taa \"srɛlɛ -e 'ka 'si 'an -sru. Kɔɔ e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan: ‹Bali \"e 'nan, e 'bla -sru \"pinzan -tɛa -e 'blanun 'o fuila \"man.› ");
INSERT INTO yreNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","'Pian \"bɛ -sru, -te an wluan 'kanɔn 'va bɛ, an -tɔala 'ka 'lɛ Galile 'lɛglɔn 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ɛn Piɛri -a 'vɩ -yrɛ 'nan: «-Te 'yie \"wɛan min pɛɛnɔn 'ci srɛman -e 'o 'si 'i -sru \"bɛ, ma'an 'sia 'i -sru \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","-A -nan nɛn Zozi -a 'vɩ -yrɛ 'nan: «Maan ve 'yiɛ 'wɩ tɩglɩ 'a 'nan, -pei 'bɔ 'gʋɛ -a man bɛ, yia ve 'e 'pa -a yaaga 'nan, yi'an 'tɔa dɩ, 'vaa -e mannɛn \"flizan 'e 'wɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ɛn Piɛri -a 'vɩ \"nyian 'nan: «-Te e ya 'nan kʋɛ -kaa 'kʋ 'vale 'yia oo, ma'an dra zɩ \"fo \"dɩ.» Ɛn -a -srunɔn pɛɛnɔn \"o 'wɩ 'tʋwli zɩɛ -a 'vɩ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","\"Bɛ -sru Zozi 'lee 'e -srunɔn 'bɔla fei nɛn waa laabo Zezemani bɛ -a da. Yaa 'vɩ 'e -srunɔn lɛ 'nan: «'Ka 'nyran 'gʋ! An \"ta -ko Bali trʋ 'balɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","E Piɛri, 'lee Zaji, 'lee Zan -fɔ 'e -sru, ɛn o -kʋ waa. -A -nan nɛn nyɛn Zozi 'cɛndɩ 'sia ɛn \"klan -dan 'kpa -a -tɛdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ɛn yaa 'vɩ -wlɛ 'nan: «'An 'ta nɛn e drɛ 'trɔdrɔ 'gʋɛ, e \"mlianla 'an da. 'Ka 'fʋ 'gʋ! Te 'ka yi -tɛ dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","E pli 'e 'lɛ \"wɛnnɔn, e blula \"tra, ɛn e Bali trʋ 'badɩ 'sia 'nan, -te e -kɔlaman drɛdɩ -a bɛ, tʋ -wlidɩ 'gʋɛ 'e 'si 'e man -kɔɔbli. ");
INSERT INTO yreNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yaa 'vɩ 'nan: «'An \"tɩ -baba! I -kɔlaman 'wɩ pɛɛnɔn drɛdɩ -a. 'Kulenɛn nɛn 'wɩ yɩdɩ cɩ -ji 'gʋɛ, 'i drɛ -e 'e \"paala 'an man! 'Pian te 'e drɛ 'an 'ci 'sɔ wɩ -a dɩ, 'i 'bɔ 'ci 'sɔ wɩ nɛn 'e drɛ!» ");
INSERT INTO yreNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ɛn e 'li 'e da, e 'bɔ 'e -srunɔn yaaga 'bɔ man, te o ya yi -tɛnan. -A -nan nɛn Zozi -a 'vɩ Piɛri lɛ 'nan: «Simɔn, i yi -tɛ 'va? Yi'a -kɔlalɛ -e 'i tʋ \"wɛnnɛn 'gʋɛ -a drɛ, te 'i yiɛ a \"man \"dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Te 'ka yi -tɛ dɩ! 'Ka Bali trʋ 'ba, \"tɔgɔ 'wɩ 'wlidɩ 'e 'ka 'man yɩ! Blamin a \"va 'nan 'e 'wɩ \"yi \"dra, 'pian -a 'plɛblɛ 'ka -yrɔ \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","\"Bɛ -sru ɛn e -kʋ \"nyian Bali trʋ 'balɛ, te e 'wɩ 'tʋwli zɩɛ -a ve. ");
INSERT INTO yreNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ɛn e 'li 'e da 'e -srunɔn 'va. E 'bɔ o man \"nyian yi -tɛnan. Kɔɔ o yiɛ 'cibɛn -tɔ. Ɛn wa'a 'wɩ 'tʋ yɩlɛ -e 'o vɩ -yrɛ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Zozi 'cɛin yaagazan da bɛ, ɛn yaa 'vɩ -wlɛ 'nan: «Ka yi -tɛa tian, te ka \"flianla 'ka man -a -trɔɔ? E -nyan, -a tʋ 'bɔ \"mɛn. Minnun \"ta -daa Blamin -pɩ -nɔnlɛ 'wɩ 'wlidɩ \"drɛnɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","'Ka 'wluan lou, -e -kaa kʋ! Min nɛn e \"ta 'an -nɔan \"minnun lɛ bɛ, e ya -plinan 'kogo.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Zozi 'fʋ 'wɩ zɩɛ -a vɩnan, tɔɔn ɛn Zudazi nɛn -a -srunɔn 'fuda \"fli 'bɔ 'va min -tʋ -a bɛ, e 'bɔla. -Wɛɛ cɩ 'o 'vale min \"kaga \"a, ɛn sɛnnun 'lee yibanun a -wlɔ. Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn 'lee min cejenun 'bɛ o 'pa 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zudazi nɛn e wlɛ -fɔ bɛ, yaa 'vɩ 'e 'cɛn minnun zɩɛ -wlɛ 'nan: «Min nɛn an -atu -tɛ \"man \"bɛ, te Zozi nɛn. -A 'bɔ nɛn 'ka 'kun -e 'ka 'kʋ -a! 'Pian 'ka 'kun \"man 'kpa!» ");
INSERT INTO yreNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","-Yee \"wɛan zɩ e 'bɔla bɛ, tɔɔn ɛn e pli Zozi man. E 'nan -yrɛ 'nan: «'An 'san.» Ɛn e -atu -tɛ \"man. ");
INSERT INTO yreNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","-A -nan nɛn minnun nɛn o cɩ waa bɛ, o Zozi 'kun. ");
INSERT INTO yreNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tɔɔn minnun nɛn -nan bɛ, -a -tʋ 'yee sɛn 'sʋ 'ji, ɛn e Bali -pannɔn 'tazan 'suzan 'tʋ \"trɔɛn cɛɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Zozi -a 'vɩ -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn ka -ta 'an 'kunlɛ 'ka 'lɔ le sɛnnun 'lee yibanun -a \"le ka -ta crinzan -sru? ");
INSERT INTO yreNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tʋ pɛɛnɔn man an ya 'ka yei Bali -pan 'kuin, te an 'wɩ \"paaman minnun ji, ɛn ka'an 'kunlɛ dɩ. 'Pian 'wɩ pɛɛnɔn zɩɛ, e drɛ -e 'wɩnun nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ 'e 'lɛ sɔɔ.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","-A -nan nɛn -a -srunɔn pɛɛnɔn 'wi \"man -a -sru, ɛn o flan bli. ");
INSERT INTO yreNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","-Gobonɛn 'tʋ sɔɔnla Zozi -sru 'e 'ta le sɔ -tʋwli \"cɛ \"a. Minnun -a 'kun, ");
INSERT INTO yreNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","'pian e 'si 'yee sɔ man, ɛn e flan bli 'e plʋdɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Minnun -kʋ Zozi 'a Bali -pannɔn 'tazan -dan 'va. Bali -pannɔn 'tanɔn, 'lee min cejenun, 'lee 'fluba 'ci vɩnɔn 'o cin 'yɩ fɛ zɩɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piɛri -fʋ -kɔɔbli, ɛn e -kʋla Zozi -sru -trilii, ɛn e wla Bali -pannɔn 'tazan -dan le -klɔn -ji. E -nyran -a 'sunɔn yei, te e 'tɛ \"klanman. ");
INSERT INTO yreNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bali -pannɔn 'tanɔn 'lee tin 'banɔn pɛɛnɔn 'wɩ 'tʋ -wɛɛdɩ 'sia 'nan -e 'o 'pa Zozi da -e 'o -kɔla -a -tɛdɩ -a -le \"wɛan. 'Pian wa'a 'wɩ 'tʋ yɩlɛ \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Min \"kaga 'wlu 'sɛn Zozi man, 'pian o wei 'ka drɛlɛ -tʋwli \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Min -mienun wluan ɛn o 'wlu 'gʋɛ -a -sɛn \"man. Waa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Kʋa 'yɩ -a vɩnan 'nan: ‹Bali -pan 'kɔn nɛn blamin -pɛ -a -tɔ bɛ, maan -wia, -e 'an pee -tɔ yi yaaga 'wlu. 'Kɔn nɛn blamin \"cɛɛ -tɔ 'e 'pɛ -a dɩɛ, -a 'bɔ nɛn maan -tɔa.› » ");
INSERT INTO yreNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","'Wɩ 'bɔ zɩɛ 'bɛ da oo, minnun wei 'ka \"nyian drɛlɛ -tʋwli \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ɛn Bali -pannɔn 'tazan -dan wluan, e -tɔ minnun yei, ɛn yaa laabʋ Zozi 'lɔ 'nan: «'Wɩ nɛn minnun -a ve 'i man bɛ, yi'a sia \"va \"dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","'Pian Zozi 'ta -fʋ flɩɩ, ya'a 'wɩ 'tʋ 'silɛ \"da \"dɩ. Ɛn Bali -pannɔn 'tazan -dan -a laabʋ -yrɔ \"nyian 'nan: «Min 'sizan 'wɩ 'ji Crizi nɛn 'yia? Bali -pɩ nɛn 'yia?» ");
INSERT INTO yreNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Zozi \"e 'nan -yrɛ 'nan: «-Inyan, -a 'bɔ nɛn 'maan. Ɛn 'ka pɛɛnɔn, ka -taa Blamin -pɩ yɩlɛ 'e -nyrandɩ 'plɛblɛ pɛɛnɔn 'san Bali -pɛ \"yi \"da. Ɛn ka -taa -a yɩlɛ 'sinan laji \"lolu -koei \"da.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","-A -nan nɛn Bali -pannɔn 'tazan -dan 'e 'ta sɔ 'fʋɩ 'bʋ, ɛn yaa 'vɩ 'nan: «-Kaa 'ka \"nyian -yee 'wɩ 'nan yɩzan pee -va \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bali srɔn nɛn yaa 'wʋ bɛ, kaa 'man. \"Ka \"ve -ji 'nɔn?» Ɛn minnun -a 'si \"va -yrɛ 'nan: «E 'sɔ -ka vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɛn min -mienun 'le 'yi 'sɛndɩ 'sia Zozi da. O sɔ 'pa -a yra, ɛn o 'pa 'fɔ -a yra, te waa laabo -yrɔ 'nan: «Bali 'lewei vɩzan, -tɩɛ fɛ tuʋ 'yiɛ? 'I -kɔɔn 'kʋɛ!» Ɛn Bali -pannɔn 'sunɔn -a 'kun, te o -ko -a -sɔndɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tʋ zɩɛ -a wlu bɛ, te Piɛri a tian -klɔn -ji. Ɛn Bali -pannɔn 'tazan -le nɔan lɩmɔn -tʋ -ta. ");
INSERT INTO yreNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","E Piɛri 'yɩ 'tɛ \"klannan. Yaa -nanjɛɛn tɛin, ɛn yaa 'vɩ -yrɛ 'nan: «'I 'bɔ \"nyian Nazarɛtɩ min Zozi -sruzan 'tʋ nɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","'Pian Piɛri yɔɔ \"da. E 'nan: «'Wɩ nɛn i cɩ \"vale 'i ve bɛ, ma'an tɔa dɩ, ɛn ma'an ci man dɩ.» Tɔɔn e 'wluan, e -kʋ bei -sia, ɛn mannɛn -tʋ wɩɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","\"Bɛ -sru nɔan lɩmɔn zɩɛ, e Piɛri 'yɩ \"nyian, ɛn yaa vɩdɩ 'sia minnun nɛn o cɩ -nan bɛ -wlɛ 'nan: «Min 'lagʋɛ e ya 'o 'va.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piɛri yɔɔ \"da \"nyian. Fɔɔnɔn minnun nɛn fɛ zɩɛ -a -nan bɛ, waa 'vɩ \"nyian -yrɛ 'nan: «'Wɩ 'kpa nɛn. 'I 'bɔ 'gʋɛ, -a -sruzan 'tʋ nɛn 'yia, kɔɔ Galile min nɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tɔɔn Piɛri -a vɩdɩ 'sia: «-Te 'wlu nɛn maan -sɛan \"bɛ, Bali 'e 'wɩ \"nɛn -kɔɔn 'mɛn. Maan 'vɩ 'cɛɛ 'nan, ma'an min 'labɛ -a tɔa \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","'Nun tɔɔn mannɛn \"flizan wɩɩ. 'Wɩ nɛn Zozi -a 'vɩ Piɛri lɛ bɛ, -a -cin -trɔa Piɛri ji. Kɔɔ Zozi -a 'vɩ -yrɛ 'nan: «'Vaa -e mannɛn \"flizan 'e 'wɩ bɛ, te yia 'vɩ 'e 'pa -a yaaga 'nan yi'an 'tɔa dɩ.» Tɔɔn e -wuɔdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Zɩ tʋ cɛɛn bodrun bɛ, ɛn Bali -pannɔn 'tanɔn 'lee min cejenun 'lee 'fluba 'ci vɩnɔn nɛn o ya Zuif 'nɔn 'le tin 'banɔn 'a bɛ, o wei 'pa 'e cin man 'nan 'o Zozi yrɩ, -e 'o 'kʋ -a -nɔn Rɔm min -kɔnmandan Pilati lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilati -a laabʋ Zozi 'lɔ 'nan: «Zuif 'nɔn 'le mingɔnnɛn nɛn 'yia?» Zozi \"e 'nan -yrɛ 'nan: «-Nyrɛn, yia 'vɩ 'i 'bɔ 'a bɛ.» ");
INSERT INTO yreNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɛn Bali -pannɔn 'tanɔn 'wɩ \"kaga 'pa Zozi da. ");
INSERT INTO yreNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","-A -nan nɛn Pilati -a 'vɩ -yrɛ \"nyian 'nan: «Yi'a 'wɩ 'tʋ ve dʋʋ? 'Wɩnun nɛn, waa \"paa 'i da bɛ, yi'a maan dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","'Pian Zozi 'ka 'wɩ 'tʋ 'silɛ \"da \"dɩ. 'Wɩ zɩɛ e Pilati 'kan. ");
INSERT INTO yreNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lɛ -tʋdʋ pɛɛnɔn man bɛ, -te Zuif 'nɔn tranun -le 'sidɩ nɔanba -ji \"fɛdi drɛdɩ 'bɔ bɛ, -kɔnmandan \"sia -pʋ 'kɔnzan 'tʋ man. -Pʋ 'kɔnzan nɛn minnun cɩ \"va 'nan 'o 'si \"man \"bɛ, -a man nɛn e \"sia. ");
INSERT INTO yreNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lɛ 'bɔ zɩɛ -a -ji bɛ, min -tʋ nɛn waa laabo Barabazi bɛ, te e ya -pʋ 'kuin 'o 'vale 'wɩ 'wlidɩ \"drɛnɔn nɛn, o 'wɩ 'fɔla minnun 'lee min tanɔn yei, ɛn o min -tɛ 'wɩ zɩɛ -a -ji bɛ waa. ");
INSERT INTO yreNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Minnun \"kaga \"kʋ Pilati -va, ɛn 'wɩ nɛn yaa dra -wlɛ -wee \"fɛdi da -tidi bɛ, waa laabʋ -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilati -a laabʋ -wlɔ 'nan: «Ka ya \"vale 'nan, 'an 'si Zuif 'nɔn 'le mingɔnnɛn man?» ");
INSERT INTO yreNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kɔɔ Pilati -a -kɔnnɛn 'yɩ 'nan, Bali -pannɔn 'tanɔn \"naan Zozi man 'e \"tun, -yee \"wɛan nɛn o -ta Zozi 'a 'yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bali -pannɔn 'tanɔn -tɔa minnun man, -e 'o vɩ Pilati lɛ 'nan, Barabazi man nɛn 'e 'si. ");
INSERT INTO yreNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ɛn Pilati -a laabʋ minnun \"kaga zɩɛ -wlɔ 'nan: «-Mɛ 'va nɛn ka cɩ 'nan, 'an drɛ min nɛn kaa laabo Zuif 'nɔn 'le mingɔnnɛn bɛ -yrɛ?» ");
INSERT INTO yreNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","-A -nan nɛn o paan 'nan: «'I -pɛin yiba \"plan da!» ");
INSERT INTO yreNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilati -a laabʋ -wlɔ 'nan: «'Wɩ 'wlidɩ \"cɛn \"nɛn yaa drɛ?» 'Pian o paan \"nyian 'kpa 'plɛblɛ. Waa 'vɩ 'nan: «'I -pɛin yiba \"plan da!» ");
INSERT INTO yreNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Minnun ci \"nrandɩ 'sɔ Pilati lɛ, -yee \"wɛan e 'si Barabazi man. Ɛn e Zozi 'nɔn 'yee 'sounjanun lɛ 'nan 'o -sɔn -ngble -a, -e 'o 'kʋ -a -pɛin yiba \"plan da. ");
INSERT INTO yreNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","'Sounjanun -kʋ Zozi 'a -kɔnmandan -le -klɔn -ji. Ɛn o 'sounjanun pɛɛnɔn cin 'yɩ \"man. ");
INSERT INTO yreNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","O mingɔnnɛn -tralɛ -gblɔ 'tɛndɛn 'tʋ 'wʋ Zozi da. O lei 'tan, ɛn waa 'wʋ -a -wulo -man \"le mingɔnnɛn kle 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","-A -nan nɛn waa 'tɔ bʋdɩ 'sia, te waa ve 'nan: «Kʋi 'tɔ bo, Zuif 'nɔn 'le mingɔnnɛn!» ");
INSERT INTO yreNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Waa -sɔndɩ 'sia 'e 'wulo -man -cɛan -kɔ -a, te o 'le 'yi -sɛan \"da. Ɛn 'o \"po -sɔɔnmlan \"wlu, te o \"kuannan -a 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Zɩ o cɛɛn -a sɛɛ wʋdɩ man bɛ, ɛn o mingɔnnɛn -tralɛ zɩɛ -a 'sʋ \"da. O -yee sɔnun 'wʋ 'e da, ɛn o -kʋ -a 'nan -e 'o -pɛin yiba \"plan da. ");
INSERT INTO yreNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","'Sounjanun -kʋdɩ 'sia Zozi 'a, ɛn 'o cin 'yɩ Sirene min -tʋ -a. Waa laabo Simɔn, e \"sia fei. Alɛzandre 'lee Rufus \"tɩ \"nɛn. 'Sounjanun 'tɔ Simɔn zɩɛ -a -sru \"sa -a 'nan -e 'e Zozi 'le yiba \"plan 'sia. ");
INSERT INTO yreNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","O -kʋ Zozi 'a fɛnan nɛn waa laabʋ Gɔlgota bɛ -a -nan. Gɔlgota -ci nɛn 'nan, min -wulo klo. ");
INSERT INTO yreNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","-Wɛn nɛn waa baa 'yile nɛn waa laabo mire bɛ -a bɛ, o ya \"vale 'nan 'o -nɔan -yrɛ. 'Pian Zozi 'ka -a mlinlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ɛn waa pɛin yiba \"plan da, \"bɛ -sru ɛn o -yee sɔnun pli 'o cin yei. Waa drɛ 'lein 'wlɛ 'tuʋladɩ da. ");
INSERT INTO yreNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Waa pɛin yiba \"plan da bodrun te yidɛ wluan fɔɔ. ");
INSERT INTO yreNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","'Wɩ nɛn waa -tɛ \"man \"bɛ, waa crɛn -tɛ yiba 'fʋɩ da, ɛn waa pɛin Zozi 'ta lou. Waa crɛn -tɛ \"da 'nan: ");
INSERT INTO yreNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","O 'wɩ 'wlidɩ \"drɛnɔn \"fli pɛin yiba \"plan da. Waa -tʋ pɛin yiba \"plan da Zozi 'pɛ \"yi \"da, ɛn waa -tʋ pɛin yiba \"plan da -a -pɛ bʋ da. ");
INSERT INTO yreNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","'Wɩ nɛn e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, zɩ e 'lɛ sɔɔ zɩɛ. Kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan: «Minnun -taa -a 'silɛa 'wɩ 'wlidɩ \"drɛzan -a.» ");
INSERT INTO yreNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Minnun nɛn o -ciala fɛ zɩɛ -a -nan bɛ, o Zozi \"srɔnman, te 'o 'wulo nyɔɔnman. Waa ve -yrɛ 'nan: «Ee! Yiɛ \"cɛɛ 'vɩ 'nan 'i Bali -pan 'kɔn -wia -e 'i pee -tɔ yi yaaga 'wlu 'gʋ dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","'I 'fli 'si 'wɩ 'ji, -e 'i 'si yiba \"plan 'labɛ -a da!» ");
INSERT INTO yreNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn \"o sɛɛ 'wʋ \"nyian. \"O 'vɩ 'o cin lɛ 'nan: «E min peenun 'si 'wɩ 'ji, 'pian ya'a 'kɔlaman 'e 'fli 'sidɩ -a 'wɩ 'ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","-Te e ya min 'sizan 'wɩ 'ji Crizi nɛn, e cɩ Izraɛl 'nɔn 'le mingɔnnɛn -a bɛ, 'e 'si yiba \"plan da! -Te 'kʋ 'wɩ zɩɛ -a -nan 'yɩ bɛ, kʋ yi -tɛala \"da.» Ɛn min \"fli \"nɛn minnun o pɛin yiba \"plan da Zozi \"srɔn \"bɛ, \"o Zozi srɔn \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yidɛ 'bɔ min -win -ji 'sɛzɛ, ɛn klun -trɔa 'trɛ pɛɛnɔn da. E -fʋ zɩɛ -trilii, ɛn funninmlan yidɛ tɛɛnla. ");
INSERT INTO yreNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Zɩ e 'bɔ zɩɛ, ɛn Zozi paan 'kpa 'plɛblɛ. Yaa 'vɩ 'e fla wei -ji 'nan: «Eloi, Eloi, lama sabatani?» 'Wɩ zɩɛ -a -ci nɛn 'nan: «'Mɛn Bali, 'mɛn Bali, -mɛ \"le \"wɛan nɛn 'i 'pɛ 'si 'an -sru?» ");
INSERT INTO yreNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Min -mienun nɛn fɛ zɩɛ -a -nan bɛ, waa 'man, ɛn o 'nan: «'Ka \"trɔɛn 'pla! E ya Eli laabʋnan.» ");
INSERT INTO yreNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'Sounja min -tʋ flan bli, e -kʋ sɔ 'silɛ, yaa 'wʋ 'wɛn 'wlɛ 'cɛn 'va, yaa 'wʋ -cɛan -kɔ \"nɛn, ɛn yaa 'pa Zozi 'lɛbo \"nɛn 'nan -e 'e 'yi flɔn \"ji. Ɛn min zɩɛ e 'nan: «'Ka 'tɔ -e -kaa -nan yɩ, -te Eli -taa -a 'silɛ yiba \"plan da -o.» ");
INSERT INTO yreNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","'Pian Zozi paan 'plɛblɛ, ɛn 'e yiɛ 'lɛ 'wʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","-A -nan nɛn sɔ -dan nɛn 'e 'tindɩ Bali -pan 'kuin bɛ, e 'fʋɩ 'bʋ 'ji \"fli. E 'fʋɩ bʋdɩ 'sia lou, ɛn yaa -sɛn \"tra. ");
INSERT INTO yreNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Zɩ 'sounjanun tazan nɛn 'e 'tɔdɩ Zozi 'lɛ bɛ, yaa -kanan 'yɩ bɛ, e 'nan: «'Wɩ 'kpa nɛn, min 'labɛ Bali -pɩ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Fɛ 'bɔ zɩɛ -a -nan bɛ, lɩmɔn -mienun a 'o 'tɔdɩ -kɔɔbli, te o yiɛ a -nan nun. Madala lɩ Mari, 'lee Salome, 'lee Mari nɛn, e cɩ Zaji -gobonɛn 'lee Zoze \"bʋ \"a bɛ, o ya 'o yei. ");
INSERT INTO yreNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tʋ nɛn Zozi a Galile bɛ, lɩmɔnnun zɩɛ o sɔɔnla -a -sru, te o 'nyranman \"paa -yrɛ. Lɩmɔn -mienun nɛn 'o 'vale Zozi nun -a, o -kʋ Zeruzalɛm bɛ, \"o ya \"nyian -nan. ");
INSERT INTO yreNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yi zɩɛ, yaa yi nɛn, ɛn Zuif 'nɔn 'le 'flinla \"yi \"ta 'e pou \"siala. -Yee \"wɛan zɩ funninmlan 'pla bɛ, ");
INSERT INTO yreNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimate min Zozɛfʋ -kʋ Pilati -va. E -pɔan 'kun 'plɛblɛ, ɛn e toba -fɔ Pilati lɛ 'nan 'e Zozi pa -nɔn 'yrɛ. Zozɛfʋ zɩɛ, e ya Zuif 'nɔn 'le 'wɩ tin 'banɔn 'va min -dan tʋ -a. Ɛn e ya -a man -pɛnnan 'nan Bali 'e mingɔnnɛn -blɩdɩ 'sia 'yee minnun da. ");
INSERT INTO yreNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilati 'plo 'fɔ -a mandɩ -a 'nan Zozi 'ka 'va. Ɛn e min 'pa 'sia 'sounjanun tazan laabʋnan. Zɩ e -ta bɛ, ɛn yaa laabʋ -yrɔ 'nan: «Zozi 'ka -a -nan 'mɔn?» ");
INSERT INTO yreNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Zɩ Pilati 'sounjanun tazan wei 'man bɛ, ɛn e Zozi pa -nɔn Zozɛfʋ lɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zozɛfʋ sɔ fɛnyian 'lɔ, e Zozi 'kadɩ 'si yiba \"plan da, ɛn yaa 'pa \"man. -A -nan nɛn e -kʋ -a wʋlɛ -yrɛ nɛn waa 'bʋ puo -kɔlɛ ji bɛ, -a ji. \"Bɛ -sru e -kɔlɛ -dan blu, ɛn yaa -tɔ -yrɛ zɩɛ -a \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Madala lɩ Mari 'lee Zoze \"bʋ Mari bɛ, fɛnan nɛn o Zozi 'wʋ bɛ, waa -nan 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Zɩ Zuif 'nɔn 'le 'flinla \"yi ciɩ bɛ, Madala lɩ Mari, 'lee Salome, 'lee Zaji \"bʋ Mari -kʋ tɔɔ nɛn -a -koei \"a 'nɔnnɔn bɛ -a 'lɔlɛ. Kɔɔ o ya \"vale 'nan 'o 'ko -a wʋlɛ Zozi man. ");
INSERT INTO yreNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ɛn 'mɔnnɛn yi nɛn 'flinla \"yi -sru \"yi \"a bɛ, -a bodrun puunɔn, te yidɛ \"ta wuanla bɛ, lɩmɔnnun zɩɛ o -kʋ -yrɛ da. ");
INSERT INTO yreNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Waa vɩ 'o cin lɛ 'nan: «-Tɩɛ 'ta -tɔa -kɔlɛ -dan nɛn -yrɛ \"nɛn \"bɛ -a man -cɛɛ?» ");
INSERT INTO yreNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","'Pian \"wɛɛ 'o yiɛ 'tɔ bɛ, waa 'yɩ 'nan, -kɔlɛ -dan 'bɔ nɛn -yrɛ \"nɛn \"bɛ, e ya 'e \"bludɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","-A -nan nɛn o wla 'yrɛ 'bɔ 'ji, ɛn o -gobonɛn 'tʋ 'yɩ. -Tralɛ -gblɔ 'fuvu a \"da, ɛn e ya 'e -nyrandɩ 'o 'pɛ 'yi \"da. Nyɛn o cɛɛn. ");
INSERT INTO yreNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","'Pian min zɩɛ e 'nan -wlɛ 'nan: «Te nyɛn 'e 'ka 'cɛn dɩ! Ka ya Nazarɛtɩ min Zozi nɛn waa pɛin yiba \"plan da bɛ, -a -wɛɛnan. E 'ka fɛ 'gʋɛ -a -nan dɩ, e wluan -kanɔn 'va. \"Ka 'yiɔ, fɛnan nɛn waa 'pla \"nɛn \"bɛ, -a -nan nɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","'Ka 'kʋ -a vɩ -a -srunɔn 'lee Piɛri lɛ 'nan, e -trɔa o 'lɛ Galile. Ka bɔa \"man \"nan nun, \"le zɩ yaa 'vɩ 'cɛɛ 'e 'cɛn bɛ -yee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","O 'bɔla 'yrɛ -ji \"nyiandʋ flan -a, gligli o 'kun. Ɛn wa'a -kɔlalɛ -a -nan wɩ vɩdɩ -a min -tʋ lɛ dɩ, nyɛn 'plɛblɛ o cɛɛn 'le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Zozi wluan -kanɔn 'va 'mɔnnɛn yi nɛn 'flinla \"yi -sru \"yi \"a bɛ, -a bodrun puunɔn. 'E 'fli kɔɔn 'e tɛdɛ Madala lɩ Mari lɛ. Lɩ zɩɛ -a -sru \"nɛn e -yʋ -wlidɩ 'sɔravli \"pin. ");
INSERT INTO yreNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Minnun nɛn o cɩ \"nɛn Zozi -sru \"bɛ, trun -fɔ o pɛɛnɔn man, te o ya -a -wuɔnan, ɛn lɩ zɩɛ e -kʋ -a vɩlɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","'Pian zɩ yaa 'vɩ 'nan, Zozi a 'e 'belidɩ bɛ, wa'a yi -tɛlɛa \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","\"Bɛ -sru Zozi 'e 'fli kɔɔn 'e -srunɔn \"fli \"lɛ, te o ya -kʋnan 'fla \"wɛnnɛn 'tʋ da. 'Pian 'e 'fli kɔɔn 'e 'kɔlɛ pee -a. ");
INSERT INTO yreNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","O 'li 'o da, ɛn waa -nan wɩ 'vɩ -a -srunɔn -mienun lɛ, 'pian wa'a yi -tɛlɛa \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","\"Bɛ -sru Zozi 'e 'fli kɔɔn 'e -srunɔn 'fuda -tʋ lɛ, te o ya fɛ -blɩnan. E 'o \"trɔɛn nyuɔn, kɔɔ -wee yi -tɛradɩ 'wɩ da \"ka \"dɩ, ɛn o \"trɔɛn a \"yuyu. -Yɛɛ cɩ 'nan, minnun nɛn waa 'yɩ 'nan e 'beli ɛn waa 'vɩ -wlɛ bɛ, wa'a yi -tɛlɛa o da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","\"Bɛ -sru e 'nan -wlɛ 'nan: «'Ka 'kʋ 'trɛda fɛ pɛɛnɔn 'nan -e 'ka Bali -le 'wɩ 'nɔnnɔn vɩ minnun pɛɛnɔn lɛ! ");
INSERT INTO yreNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Min oo min nɛn e yi -tɛra \"da ɛn waa -batize drɛ bɛ, e -taa 'silɛ 'wɩ 'ji. 'Pian min oo min nɛn, ya'a yi -tɛlɛa \"da \"dɩɛ, ya'a 'belidɩ nɛn ya'a 'nyaan dɩɛ -a ye dɩ. ");
INSERT INTO yreNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Minnun nɛn o yi -tɛra \"da \"bɛ, o 'lɛbo \"fɔ wɩnun 'gʋɛ -a dra. O -yʋ -wlidɩnun -pian \"minnun -sru 'an 'tɔ da, ɛn o wei 'trɛ -fɔa. ");
INSERT INTO yreNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","-Te o -mlɛn 'kun 'o 'lɔ oo, -te o min -tɛ 'yile mlin oo, ya'a fɛ -tʋ dra -wlɛ \"dɩ. 'O 'pɛ \"paala -cɛ -tɛnɔn da, -e 'o 'beli.» ");
INSERT INTO yreNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Zɩ Minsan Zozi cɛɛn 'wɩnun zɩɛ -a vɩdɩ man bɛ, ɛn e wluan, e -kʋ laji, ɛn e -nyran Bali -pɛ \"yi \"da. ");
INSERT INTO yreNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","-A -srunɔn 'kʋ Bali -le 'wɩ 'nɔnnɔn vɩlɛ fɛ pɛɛnɔn 'nan. Minsan Zozi 'pa o -va. Ɛn 'wɩ nɛn waa 'vɩ bɛ, Bali 'bɔ -a -ci kɔɔn 'nan 'wɩ tɩglɩ nɛn, kɔɔ e ciɩla o va, ɛn o 'lɛbo \"fɔ wɩnun drɛ.");
INSERT INTO yreNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","'Tɩɩ Teofil, 'wɩnun nɛn o drɛ 'kʋ 'va 'gʋɛ, minnun \"kaga -a man wɛɛ ɛn waa crɛn -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Minnun nɛn 'wɩnun zɩɛ o drɛ o yiɛ man -a pou sianan \"bɛ, -wɛɛ 'sinan 'pa 'kʋɛ. Ɛn 'o 'bɔ nɛn Bali o 'pla 'nan 'o 'yee 'wɩ 'nɔnnɔn fuila \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","-Yee \"wɛan, zɩ an cɛɛn 'wɩ pɛɛnɔn zɩɛ -a pou -wɛɛdɩ man 'e klɔji bɛ, 'an 'bɔ, \"an 'yɩ \"nyian 'kpa, ɛn 'an \"yie crɛn -tɛ 'e \"nɛn 'e \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Maan drɛ zɩɛ 'nan -e 'wɩ pɛɛnɔn nɛn minnun -a paa 'i ji bɛ, 'i -tɔ 'nan 'wɩ tɩglɩ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tʋ nɛn mingɔnnɛn Erodi Zude 'lɛglɔn \"paala bɛ, -a -nan nɛn 'wɩ 'gʋɛ 'e drɛ. Tʋ zɩɛ -a va bɛ, te min -tʋ a, waa laabo Zakari. E ya Bali -panzan -tʋ -a Abia nun va. Ɛn waa nan laabo Elizabɛtɩ. Bali -panzan -tʋ nɛn 'li, waa laabo Arɔn bɛ, -a kluda lɩ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Min \"fli zɩɛ o ya min tɩglɩ 'a Bali 'lɛ. Ɛn -wee 'wɩ drɛdɩ 'lee -wee 'ta wʋdɩ Minsan -le -pei da bɛ, -a -pɛ -tʋwli 'ka \"va \"wlidɩ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","'Pian -wee 'nɛn \"ka \"dɩ, kɔɔ Elizabɛtɩ a lɩmɔn nɛn ya'a nɛn 'yaa dɩɛ -a, ɛn o \"flinɔn drɛ \"nyian ceje. ");
INSERT INTO yreNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yi -tʋ da bɛ, ɛn Zakari -kʋ 'yee Bali -pan 'nyranman 'palɛ Bali -pan 'kuin. Kɔɔ Bali -pannɔn nɛn e cɩ o va zia bɛ o da nɛn e 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","'Wɩ nɛn Bali -pannɔn -a dra -tidi bɛ, -a 'bɔ nɛn waa drɛ. Ɛn cɛɛgʋɛ, Zakari da nɛn e -tria. E wla Bali -pan 'kuin, ɛn e -kʋ fɛ -tʋ nɛn -a -koei \"a 'nɔnnɔn bɛ, -a 'tɛ 'blɩlɛ Bali lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tʋ zɩɛ -a wlu bɛ, te minnun \"kaga \"a 'o 'sɛndɩ 'kɔn 'lɛ \"nɛn bei Bali trʋ 'banan. ");
INSERT INTO yreNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","-A -nan nɛn Bali -le 'pasiazan nɛn laji bɛ, -a -tʋ 'e 'fli kɔɔn -yrɛ. E ya 'e 'tɔdɩ lou, fɛnan nɛn o fɛ zɩɛ -a 'tɛ 'ble bɛ -a -pɛ \"yi \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zɩ Zakari -a 'yɩ bɛ, nyɛn -a cɛɛn, ɛn \"klan -a -tɛdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ɛn Bali -le 'pasiazan 'e 'nan -yrɛ 'nan: «Zakari, te \"klan 'e 'i 'tɛ dɩ! 'Wɩ nɛn yia laa 'bʋ Bali lɔ bɛ, e wɩɩ \"man. 'I nan Elizabɛtɩ \"ta -daa 'yie 'nɛn 'klɔnmɔn -yalɛ. 'I 'tɔ 'pa Zan. ");
INSERT INTO yreNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","E -kɔan 'yie ci \"nran wɩ -dan tʋ -a, ɛn -a -yadɩ min \"kaga 'ci \"nranman. ");
INSERT INTO yreNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","E -kɔan min -dan tʋ -a Minsan 'lɛ. Ya'a 'wɛn mlian dɩ, ɛn -wɛn nɛn e min -tɛa \"bɛ, ya'a mlian dɩ. -A -srandɩ man 'e \"bʋ 'pɔn -ji bɛ, -e Bali lei 'saun 'e 'ta \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","-Yɛɛ dra -e Izraɛl 'nɔn 'o -sɔɔnla \"nyian Minsan nɛn -wee Bali -a bɛ -a -sru 'e 'pee. ");
INSERT INTO yreNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Min nɛn Bali -a -trɔa Minsan 'lɛ bɛ, -nyrɛn. E dra Bali 'lewei vɩzan -a \"le zɩ Eli cɩ 'li Bali 'lewei vɩzan -a bɛ, -yee 'wɩ 'zʋ. 'Plɛblɛ 'lee Bali lei 'saun nɛn Eli -lɔ 'li bɛ, -yɛɛ -kɔan -yrɔ. E 'nɛn 'lee 'e \"tɩ -sɛan 'e cin va. Minnun nɛn wa'a 'yra tɛa Bali man dɩɛ, yaa dra -e 'o -sɔɔnla -si tɩglɩ da. Ɛn \"nyian bɛ, yaa dra -e min \"kaga 'o 'man wʋʋ Minsan -pɛndɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zɩ Zakari 'wɩ zɩɛ -a 'man bɛ, ɛn e 'nan Bali -le 'pasiazan zɩɛ -yrɛ 'nan: «Maan dra 'kɔ -e 'an -tɔ 'nan 'wɩ 'kpa nɛn yia ve? Kɔɔ an drɛ ceje ɛn 'an nan drɛ \"nyian ceje.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ɛn Bali -le 'pasiazan \"e 'nan -yrɛ 'nan: «'An 'tɔ nɛn Gabriɛl, mɛɛn cɩ Bali 'lɛ. Bali 'an 'pa 'sia, 'nan -e 'an 'wɩ tin 'ba 'yiɛ, -e 'an 'wɩ \"yi zɩɛ -a vɩ 'yiɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","'Wɩ nɛn maan 'vɩ 'yiɛ 'gʋɛ e dra te -a tʋ 'bɔ. Ɛn yi'a yi -tɛlɛa 'an wei da dɩ. -Yee \"wɛan i dra bobo -a. Yi'a 'we 'lɔɔ -e -a drɛ yi 'e bɔ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tʋ zɩɛ -a wlu bɛ te minnun \"kaga \"a Zakari -pɛnnan tian. Ɛn 'wɩ o 'kan 'nan e ya 'mɔnnan Bali -pan 'kuin \"bʋʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zɩ e 'bɔla bɛ, ya'a -kɔlalɛ 'wɩ tin 'badɩ -a -wlɛ \"dɩ. Tɔɔn 'o 'ci nrɔn 'nan Bali 'e 'fli kɔɔn Zakari lɛ Bali -pan 'kuin. -A -nan nɛn e 'wɩ tin 'badɩ 'sia 'e 'pɛ -a, te ya'a 'we dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zɩ -yee 'nyranman 'pa yi -nyan bɛ, ɛn e -kʋ 'yee \"kɔnnɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","\"Bɛ -sru -a -nan 'ka 'mɔnlɛ dɩ, ɛn -a nan Elizabɛtɩ 'e 'pɔn 'si. E -fʋ 'e yɔɔdɩ \"kɔnnɛn mlɛn 'soolu, te yaa ve 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Minsan 'pa 'an 'va. Ɛn 'wɩ nɛn e 'yra \"sia 'an yiɛ man minnun yei \"bɛ yaa drɛ 'mɛn.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Zɩ Elizabɛtɩ -pɔn mlɛn 'shɛɛdʋ 'bɔ bɛ, ɛn Bali 'yee 'pasiazan Gabriɛl 'pa 'sia Galile 'fla 'tʋ nɛn waa laabo Nazarɛtɩ bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yaa 'pa 'sia nɔnbɛ 'nɛn 'tʋ -va. Nɔnbɛ zɩɛ, -a 'tɔ nɛn Mari, ɛn ya'a tian 'kɔnnɛn -tɔlɛ \"fo \"dɩ. 'Pian e ya Zozɛfʋ 'tɔ da 'nan -e 'e 'pa. Zozɛfʋ zɩɛ, David kluda min nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bali -le 'pasiazan wlala \"va, ɛn e 'nan -yrɛ 'nan: «Mɛin 'tɔ bo. Bali \"yi drɛ 'yiɛ, ɛn Minsan yiɛ a 'i 'va.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","'Wɩ zɩɛ e Mari cɛɛn nyɛn -a, ɛn yaa laabʋ 'e 'fli -lɔ 'nan, 'tɔ bʋdɩ \"cɛn 'bɛ cɩ zɩɛ? ");
INSERT INTO yreNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ɛn Bali -le 'pasiazan \"e 'nan -yrɛ 'nan: «Mari, te \"klan 'e 'i 'tɛ dɩ! Bali \"yi drɛ 'yiɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","I \"ta -daa 'i 'pɔn 'silɛ, -e 'i 'nɛn 'klɔnmɔn -ya. 'Nɛn zɩɛ 'i 'tɔ 'pa Zozi! ");
INSERT INTO yreNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","E -kɔan \"min -dan tʋ -a, ɛn waa laabo Bali nɛn min ta lou \"bɛ -a -pɩ. Minsan Bali -a -nyɛanla mingɔnnɛn pɛin nɛn -a tra David -nyran \"da \"bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","E mingɔnnɛn -ble Zago kludanɔn da 'li 'trilii, ɛn -yee mingɔnnɛn -blɩdɩ 'le 'ka 'tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ɛn Mari \"e 'nan Bali -le 'pasiazan zɩɛ -yrɛ 'nan: «'Wɩ zɩɛ 'bɛ dra 'kɔ -e 'bɛ drɛ? Kɔɔ ma'an 'kɔnnɛn tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ɛn Bali -le 'pasiazan \"e 'nan -yrɛ 'nan: «Bali lei 'saun 'bɛ dra. Bali nɛn min ta lou \"bɛ, -yee 'plɛblɛ -taa 'i 'va \"le fulɔ -le 'wɩ 'zʋ. -Yee \"wɛan 'nɛn nɛn i \"ta -daa -a -yalɛ bɛ, waa laabo Bali -pɩ. E ya Bali -le vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ɛn \"nyian bɛ, 'i drɩ lɩmɔn Elizabɛtɩ \"e 'pɔn 'si 'e ceje da. E \"ta -daa 'nɛn 'klɔnmɔn -yalɛ. Lɩmɔn nɛn minnun -a ve \"nɛn 'nan, ya'a 'nɛn 'yaa dɩɛ, -a -pɔn mlɛn 'shɛɛdʋ nɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kɔɔ 'wɩ 'tʋ 'ka 'kɔlaman Bali 'klɩdɩ -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ɛn Mari \"e 'nan: «An ya Bali 'suzan 'a, 'wɩ nɛn e cɩ \"va \"bɛ -nyrɛn 'e drɛ 'mɛn.» -A -nan nɛn Bali -le 'pasiazan 'si -a \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","\"Bɛ -sru ɛn Mari -kʋ \"nyiandʋ Zude 'lɛglɔn 'ji 'fla 'tʋ nɛn e ya pɔn da bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","E wla Zakari -le 'kuin, ɛn e Elizabɛtɩ 'tɔ 'bʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Zɩ Elizabɛtɩ Mari -le 'tɔ bʋdɩ 'man bɛ, ɛn 'nɛn nyɔɔn -a -pɔn -ji. -A -nan nɛn Bali lei 'saun 'ta Elizabɛtɩ da. ");
INSERT INTO yreNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ɛn e paan wei 'plɛblɛ 'a 'nan: «Bali -fɛa 'vɩ 'i man lɩmɔn nun va. Ɛn 'nɛn nɛn 'i 'pɔn -ji bɛ, Bali -fɛa 'vɩ \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","-Tɩ nɛn 'maan ɛn 'mɛn Minsan \"bʋ -taa 'an 'va? 'Wɩ zɩɛ yaan 'ci \"nranman -dan. ");
INSERT INTO yreNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Zɩ an 'yie 'tɔ bʋdɩ 'man bɛ, 'nɛn \"le 'ci nran \"nyian, ɛn e nyɔɔn 'an 'pɔn -ji. ");
INSERT INTO yreNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bali -le -fɛa a 'i man, kɔɔ 'wɩ nɛn Bali -le 'pasiazan -a 'vɩ 'yiɛ bɛ, i yi -tɛra \"da 'nan e 'lɛ sɔɔman.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ɛn Mari \"e 'nan: «An Minsan 'tɔ bɔa 'tandan. ");
INSERT INTO yreNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Bali nɛn yaan 'si 'wɩ 'ji bɛ, -yee \"wɛan ci \"nran -dan a 'an 'lɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kɔɔ 'an 'bɔ nɛn an cɩ -a 'suzan \"tun \"a bɛ, 'an 'cin -trɔa \"ji. -E 'e 'sia cɛɛgʋ man bɛ, blamin pɛɛnɔn -a ve 'an man 'nan Bali -le -fɛa a 'an man. ");
INSERT INTO yreNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kɔɔ 'plɛblɛ pɛɛnɔn 'san Bali 'wɩ -dandan drɛ 'mɛn. E ya Bali nɛn \"tri 'ka \"man \"dɩɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ɛn e ya \"yi 'li 'trilii minnun nɛn waa ye \"yi, ɛn waa bɔa \"bɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","E -pɛ 'plɛblɛ 'ci kɔɔn 'wɩ -dandan drɛdɩ -a. Minnun nɛn fli drɛdɩ -dan bli a o ji bɛ, e o fuila \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","E mingɔnnɛnnun 'sia 'wee mingɔnnɛn pɛin -da. Ɛn minnun nɛn min 'ka o siala fɛ -tʋ -a dɩɛ, e o wluan lou. ");
INSERT INTO yreNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Minnun nɛn dra o -tɛa \"bɛ, e man yɩfɛ \"kaga \"nɔn -wlɛ. Ɛn e fɛnɔn 'li 'o da 'o 'lɔ 'a 'e \"tun. ");
INSERT INTO yreNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","E -ta 'palɛ Izraɛl nɛn yaa 'si \"va 'nan 'e 'yee 'nyranman 'pa bɛ -a va. \"Yi \"nɛn e 'nan 'e dra -yrɛ \"bɛ, -a -cin -trɔa \"ji. ");
INSERT INTO yreNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","'Wɩ zɩɛ yaa 'vɩ 'e 'cɛn -kaa tranun lɛ. E 'nan 'e \"yi dra 'kʋ tra Abraam 'lee 'e kludanɔn lɛ 'li 'trilii.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari -fʋ Elizabɛtɩ -va mlɛn yaaga, \"bɛ -sru ɛn e 'li 'e da 'e fla. ");
INSERT INTO yreNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Zɩ Elizabɛtɩ pɔn plala bɛ, ɛn e 'nɛn 'klɔnmɔn -ya. ");
INSERT INTO yreNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","-A \"srɔnnɔn 'lee -a drɩnun -a 'man 'nan Minsan \"yi drɛ Elizabɛtɩ lɛ, ɛn o ci nran 'o 'vale waa. ");
INSERT INTO yreNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ɛn -a yi 'sɔrazan da bɛ, o -ta 'nɛn zɩɛ -a -fɔlɛ -klɔnmɔn -va. O ya \"vale 'o laabʋ 'e \"tɩ 'tɔ 'a Zakari. ");
INSERT INTO yreNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","'Pian -a \"bʋ 'ka 'wɩlɛ \"man \"dɩ. E 'nan: «'O laabʋ Zan.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɛn minnun zɩɛ o 'nan -yrɛ 'nan: «Wa'a 'i drɩ 'tʋ laabo 'tɔ zɩɛ -a dɩ. -Mɛ \"le \"wɛan nɛn yie 'nan 'o laabʋ Zan?» ");
INSERT INTO yreNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","-A -nan nɛn o 'wɩ laabʋdɩ 'sia -a \"tɩ 'lɔ 'o 'pɛ -a. Waa laabʋ 'nan: «'Nɛn 'bɔ 'tɔ nɛn 'nɔn?» ");
INSERT INTO yreNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ɛn Zakari yiba 'fʋɩnɛn 'tʋ -nan laabʋ 'nan -e 'e 'crɛn -tɛ. Yaa crɛn -tɛ \"da 'nan: «-A 'tɔ nɛn Zan.» Ɛn 'wɩ o pɛɛnɔn 'kan. ");
INSERT INTO yreNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","'Nun tɔɔn -a nrɛn flu ɛn e 'wɩdɩ 'sia te e Bali 'tɔ bɔa. ");
INSERT INTO yreNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Minnun pɛɛnɔn nɛn o -nyɛanla fɛ zɩɛ -a -nan -kogo bɛ, nyɛn o cɛɛn. 'Wɩ zɩɛ -a -nan sɛɛ nɛn waa wo Zude pɔnnun pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Min -tʋdʋ pɛɛnɔn nɛn o 'wɩ zɩɛ -a maan \"bɛ, 'o 'ci \"nrɔndɩ \"siala 'nan: «-Mɛ \"a nɛn 'nɛn zɩɛ e -taa \"drɛlɛ?» Kɔɔ waa -tɔa 'wein 'nan Bali -pɛ -trɔɔ a 'e 'padɩ 'nɛn 'bɔ da. ");
INSERT INTO yreNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakari nɛn 'nɛn zɩɛ -a \"tɩ \"a bɛ, Bali lei 'saun 'ta \"da, ɛn e Bali 'lewei vɩdɩ 'sia. E 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Minnun pɛɛnɔn 'o Minsan 'tɔ bɔ! -Yɛɛ cɩ Izraɛl 'nɔn 'le Bali -a. E -ta 'palɛ 'yee minnun va, ɛn e o 'si nɔanba -ji. ");
INSERT INTO yreNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bali -ta min 'plɛblɛ nɛn e -kɔlaman e min \"sia 'wɩ 'ji bɛ -a -cɛɛ. -Yee 'nyranman 'pazan David kluda min nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","'Wɩ zɩɛ yaa 'pa 'e 'lewei vɩnɔn 'saun 'le 'e 'cɛn, ɛn waa 'vɩ -a -nan lɛ 'ka lɛ va dɩ. Yaa 'pa o 'le 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","E -kaa \"sia -kaa 'nanmannɔn 'le nɔanba -ji, ɛn minnun pɛɛnɔn nɛn o \"naan -kaa man bɛ, e -kaa \"sia -wee 'plɛblɛ 'wlu. ");
INSERT INTO yreNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","'Bɛ nɛn 'gʋɛ, e \"yi drɛ -kaa tranun lɛ, ɛn cibɔ \"da \"wɩ 'saun nɛn yaa 'vɩ bɛ -a -cin -trɔa \"ji. ");
INSERT INTO yreNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","'Wɩ zɩɛ e -tɔ 'e wei da -a -kaa tra Abraam lɛ. Yaa 'vɩ -yrɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","E -kaa \"sia -kaa 'nanmannɔn 'le 'plɛblɛ 'wlu, 'nan -e -kaa -kɔla 'yee 'nyranman 'padɩ -a, te nyɛn 'ka -kaa 'ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ɛn \"nyian te -kaa ya -yee vɛ -a, ɛn -kaa 'ta wʋla 'e wei da tʋ -tʋdʋ pɛɛnɔn man -trilii, -e -kaa ka yi 'e bɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","'Mɛn 'nɛn, minnun -taa 'i laabʋlɛ Bali nɛn min ta lou \"bɛ -a 'lewei vɩzan. Kɔɔ yiɛ -tɔala Minsan 'lɛ -e 'i -yee -si man drɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yiɛ ve -yee minnun lɛ 'nan, o 'sizan 'wɩ 'ji a -tanan, ɛn -yɛɛ -wee 'wɩ 'wlidɩ \"fuiman. ");
INSERT INTO yreNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kɔɔ -cee Bali ci a \"yi, ɛn e min ye \"yi. -Yee \"wɛan e 'tɛ 'san 'si lou, ɛn e bii -kaa da \"le yidɛ 'bɛ cɩ wluannan. ");
INSERT INTO yreNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yaa drɛ zɩɛ 'nan -e -yee 'tɛ 'san 'bɔ 'e minnun nɛn o cɩ klun \"va, te o \"klanman -ka -lɔ bɛ, o man drɛ 'wein. Ɛn \"nyian 'nan -e 'e 'wɩ 'tɔdɩ nɛn e blamin -fo -trɔɔ bɛ, -a \"paa -kaa 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zɩ Zan drɛ ceje bɛ, ɛn -yee 'wɩ 'tɔdɩ 'pa \"da. \"Bɛ -sru ɛn e -kʋ \"bui \"da, e -fʋ -nan nun -trilii, ɛn yi nɛn e bɔala 'ji Izraɛl 'nɔn 'lɛ bɛ, e 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","'Wɩ nɛn e drɛ Zozi 'ya tʋ man bɛ, -nyrɛn 'gʋ. Mingɔnnɛnnun tazan nɛn Rɔm bɛ, waa laabo Ogust. E 'nan, minnun pɛɛnɔn nɛn 'e mingɔnnɛn -ble o da bɛ, o o \"nrɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Min \"nrɔndɩ tɛdɛ nɛn. E drɛ te Cirini 'bɛ cɩ Siri 'lɛglɔn da -kɔnmandan -a. ");
INSERT INTO yreNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɛn min -tʋdʋ pɛɛnɔn 'kʋ 'o 'tɔ 'crɛn -tɛlɛ 'o 'ya 'trɛ -da. ");
INSERT INTO yreNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","-Yee \"wɛan Zozɛfʋ 'si Galile 'lɛglɔn 'ji, 'fla nɛn waa laabo Nazarɛtɩ bɛ -a da. Ɛn e -kʋ Zude 'lɛglɔn 'ji, 'fla nɛn waa laabo Bɛtelɛm bɛ -a da. 'Fla zɩɛ -a da nɛn, o Zuif 'nɔn 'le mingɔnnɛn David -ya. Zozɛfʋ a David kluda min -a, -yee \"wɛan nɛn e -kʋ -nan nun. ");
INSERT INTO yreNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","E -kʋ 'e 'tɔ 'crɛn -tɛlɛ 'o 'vale Mari nɛn e \"ta -daa \"drɛlɛ -a nan -a bɛ -a, te Mari 'pɔn a 'e man. ");
INSERT INTO yreNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Zɩ o 'bɔla Bɛtelɛm bɛ, ɛn -yee 'nɛn 'ya tʋ 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","-A -nan nɛn Mari 'nɛn tɛdɛ -ya -klɔnmɔn -a. E sɔ 'pa 'nɛn zɩɛ -a man, ɛn yaa 'nyinnan -winun -le fɛ -blɩvɛ -ji. Kɔɔ wa'a nyinnan \"nan \"yɩlɛ -pɛn 'nɔn nyinnan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bɛtelɛm 'fla 'bɔ zɩɛ -a \"srɔn \"bɛ, 'bla -sru \"pinnɔn a -nan. 'O yiɛ -tɔa 'wee 'blanun da -pei -man. ");
INSERT INTO yreNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","-A -nan nɛn Minsan -le 'pasiazan -tʋ 'bɔla o va, ɛn Minsan -le 'tɛ 'san o si -fɔ. Nyɛn -dan sɛn o ji, ");
INSERT INTO yreNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","'pian Bali -le 'pasiazan \"e -wlɛ 'nan: «Te \"klan 'e 'ka 'tɛ dɩ! An -ta 'wɩ nɛn e minnun pɛɛnɔn 'ci \"nranman tɩglɩ bɛ -a vɩlɛ 'cɛɛ! ");
INSERT INTO yreNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","'Wɩ zɩɛ -nyrɛn 'nan, min nɛn e \"ta -daa 'ka 'silɛ 'wɩ 'ji bɛ, waa -ya cɛɛgʋ David fla. Crizi nɛn Minsan -a bɛ -nyrɛn! ");
INSERT INTO yreNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","'Ka 'kʋ -a -nanjɛn! -A -kɔnnɛn \"yɩ vɛ nɛn 'gʋ: Ka bɔa 'nɛn 'tʋ man, te sɔ a 'e -bladɩ \"man, te e ya 'e nyinnandɩ -winun -le fɛ -blɩ vɛ -ji. 'Nɛn zɩɛ -nyrɛn.» ");
INSERT INTO yreNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","'Nun tɔɔn Bali -le 'pasianɔn \"kaga 'si laji, ɛn o -ta trelɛ 'pasiazan tɛdɛ bɛ -a \"srɔn, ɛn o Bali 'tɔ bɔdɩ 'sia. Waa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«'Tɔ -dan a Bali -le vɛ -a laji lou. Ɛn e -fʋdɩ -trɔɔ -nɔn 'trɛdanɔn pɛɛnɔn nɛn e o ye \"yi \"bɛ -wee vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Zɩ Bali -le 'pasianɔn 'li o da laji bɛ, ɛn 'bla -sru \"pinnɔn a vɩdɩ 'sia 'o cin lɛ 'nan: «-Kaa kʋ Bɛtelɛm, 'wɩ nɛn Minsan -a 'vɩ -cɛɛ bɛ -a 'yɩ.» -A -nan nɛn o -si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Zɩ o -kʋ, o 'bɔla 'nan nun bɛ, o 'bɔ Mari 'lee Zozɛfʋ man. Ɛn o 'nɛn zɩɛ -a 'yɩ 'e nyinnandɩ -winun -le fɛ -blɩvɛ -ji. ");
INSERT INTO yreNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Zɩ waa 'yɩ bɛ, tɔɔn 'wɩ nɛn Bali -le 'pasiazan -a 'vɩ -wlɛ 'nɛn zɩɛ -a man bɛ, waa vɩdɩ 'sia minnun pɛɛnɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Minnun nɛn o 'wɩ zɩɛ -a 'man bɛ, 'wɩ o 'plo 'fɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","'Pian Mari \"e 'wɩnun pɛɛnɔn zɩɛ -a klɔ \"paala 'e 'ji, te 'e 'ci \"nrɔnman \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","\"Bɛ -sru ɛn 'bla -sru \"pinnɔn 'li 'o da, te o Bali 'tɔ bɔa 'wɩnun nɛn waa 'man 'lee waa -nan 'yɩ bɛ -yee \"wɛan. Kɔɔ 'wɩ nɛn Bali -le 'pasiazan -a 'vɩ -wlɛ \"bɛ -a da nɛn e drɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Zɩ 'nɛn zɩɛ -a yi 'sɔrazan 'bɔ bɛ, ɛn waa -fɔ -klɔnmɔn -va. -A -nan nɛn o Zozi 'tɔ 'pa \"man. 'Tɔ zɩɛ Bali -le 'pasiazan 'bɛ 'vɩ, te -a \"bʋ 'ka tian 'e 'pɔn 'silɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tʋ nɛn o Mari -sruman -e 'e drɛ 'saun Bali lɛ \"le zɩ Moizi -le -pei -a 'vɩ bɛ -yee 'wɩ 'zʋ bɛ e 'bɔ. -A -nan nɛn o -kʋ Zozi 'a Zeruzalɛm, 'nan -e 'o -kɔɔn Minsan lɛ, ");
INSERT INTO yreNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"le zɩ Minsan -le -pei -a 'vɩ bɛ -yee 'wɩ 'zʋ. Kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan: «Fɛ pɛɛnɔn 'nɛn flin nɛn, waa -yaa te e ya 'e 'kɔnnɛn -a bɛ, 'o 'pla Minsan lɛ kɔnglɔn -yee vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","O -kʋ -nan nun, 'nan -e 'o Bali -pan \"le zɩ e ya 'e 'crɛn -tɛdɩ Minsan -le -pei -a bɛ -yee 'wɩ 'zʋ. 'Yalɛ -tɛnɔn -a -nɔan -plablo \"fli, -te 'bɛ \"cɛɛ dɩ, -plablo 'nɛn \"fli. -A 'bɔ nɛn Zozi 'mangulinun \"o \"nɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Min -tʋ a Zeruzalɛm. -A 'tɔ nɛn Simeɔn. Min zɩɛ e ya min tɩglɩ 'a, ɛn e 'ta 'wʋla Bali wei da. E ya min nɛn e \"ta -daa Izraɛl 'nɔn 'silɛ 'wɩ 'ji bɛ -a -pɛnnan. Bali lei 'saun a -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ɛn Bali lei 'saun 'bɔ -a 'vɩ -yrɛ 'nan, min 'sizan 'wɩ 'ji nɛn Minsan Bali -taa \"talɛ -a bɛ, yaa ye 'e yiɛ 'a 'vaa ɛn e -kaa. ");
INSERT INTO yreNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bali lei 'saun -a -cin -tɔ Simeɔn -ji 'nan 'e 'kʋ Bali -pan 'kuin, ɛn e -kʋ. Nun tɔɔn Zozi \"tɩ 'lee -a \"bʋ wla 'o 'lɔ le 'nɛn 'linɛn 'bɔ 'a. 'Wɩ nɛn Bali -le -pei -a 'vɩ bɛ -a 'bɔ nɛn o \"ta -a dra -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeɔn Zozi 'si 'e 'pɛ -ji. E Bali 'tɔ 'bɔ, ɛn e 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«'An 'san, 'i 'si \"mɛn 'i 'suzan man, -e 'e 'ka -trɔɔ, kɔɔ 'wɩ nɛn yia 'vɩ bɛ, e drɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","-Yɛɛ cɩ 'nan, an min nɛn e min \"sia 'wɩ 'ji bɛ -a 'yɩ 'an yiɛ 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Min nɛn yia 'si \"va 'trɛdanɔn pɛɛnɔn 'le vɛ -a bɛ -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","-Yɛɛ cɩ 'tɛ 'san nɛn, e 'lɛglɔn pɛɛnɔn 'ji dra 'wein bɛ -a, ɛn -yɛɛ 'yie minnun Izraɛl 'nɔn 'tɔ dra -dan.» ");
INSERT INTO yreNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","'Wɩ nɛn Simeɔn cɩ -a vɩnan Zozi man bɛ, e Zozi \"bʋ 'lee -a \"tɩ 'plo 'fɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeɔn -fɛa 'vɩ 'o man, ɛn e 'nan Zozi \"bʋ Mari lɛ 'nan: «'Nɛn 'gʋɛ Bali -a 'si \"va 'nan, Izraɛl 'nɔn 'va bɛ min \"kaga -tiala -yee \"wɛan, ɛn min \"kaga wuanla -yee \"wɛan. Ɛn Bali -a 'si \"va 'nan -e 'e 'kɔn 'wɩ 'nɔan -kɔɔn \"vɛ nɛn e 'wɩ \"paala minnun lɛ bɛ -a. 'Pian minnun 'o 'ci \"paa \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","'Wɩ zɩɛ -a drɛdɩ bɛ, e o ci wɩ yɔɔdɩ ta bɔala 'wein. Ɛn bii nɛn i cɩ -a \"bʋ \"a bɛ, 'wɩ -taa 'nanlɛ 'i man \"le srɛn 'bɛ 'i 'fɔn.» ");
INSERT INTO yreNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ɛn \"nyian bɛ Bali 'lewei vɩzan lɩmɔn -tʋ -nyɛanla Zeruzalɛm 'bɔ 'nan nun. Waa laabo Anne, Panuɛl -le 'nɛn nɛn Aser -le 'lɛglɔn 'ji. E ya ceje 'kpa. E -kɔnnɛn 'pa 'e nɔnbɛ \"da, ɛn o lɛ drɛ 'e 'sran -a 'sɔravli 'vaa ɛn -a -sran 'bɔ 'ka. ");
INSERT INTO yreNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","E -fʋ -cale -a -trilii, ɛn -a lɛ 'bɔ -fuba 'sɔra 'wlɛ sinjɛn. E ya Bali -pan 'kuin, te e Bali \"sua bodrun funnin fɛ 'sɔndɩ 'lee Bali trʋ 'badɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tʋ nɛn Simeɔn a 'wɩ zɩɛ -a vɩnan 'nɛn man bɛ, te e ya -nan. -A -nan nɛn lɩ zɩɛ, e Bali 'tɔ bɔdɩ 'sia. E Zozi 'le 'wɩ vɩdɩ \"sia minnun pɛɛnɔn nɛn o cɩ Zeruzalɛm -le 'sidɩ nɔanba -ji -pɛnnan bɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Zɩ Zozi \"tɩ 'lee -a \"bʋ cɛɛn -a drɛdɩ man \"le Minsan -le -pei -a 'vɩ bɛ -yee 'wɩ 'zʋ bɛ, ɛn o 'li 'o da 'o fla Nazarɛtɩ Galile 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Zozi drɛdɩ 'sia ceje, ɛn e -tɔdɩ 'sia 'plɛblɛ. E 'wɩ 'tɔdɩ 'sia 'kpa tɩglɩ, ɛn Bali -le -fɛa a 'e vɩdɩ \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lɛ -tʋdʋ pɛɛnɔn man bɛ, Zozi 'mangulinun -ko Zeruzalɛm Zuif 'nɔn 'le 'si nɔanba -ji \"fɛdi da. ");
INSERT INTO yreNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Zɩ Zozi lɛ 'bɔ 'fuda \"fli \"bɛ, -wɛɛ -kʋ waa \"fɛdi zɩɛ -a da \"le zɩ waa dra 'e 'cɛn bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Zɩ \"fɛdi drɛdɩ -nyan bɛ, Zozi \"tɩ 'lee -a \"bʋ 'o fla si 'sia. Zozi -fɔla \"da Zeruzalɛm nun, 'pian wa'a -kɔnnɛn \"yɩlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","E ya o ji 'nan, Zozi a minnun nɛn o -taala waa bɛ o va. Zɩ o yi drɛ 'sia -tʋ bɛ, ɛn waa -wɛɛdɩ 'sia o drɩnun 'lee o beenun va. ");
INSERT INTO yreNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wa'a yɩlɛ dɩ -le \"wɛan, o 'li 'o da \"nyian Zeruzalɛm -a -wɛɛdɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","-A -wɛɛdɩ yi yaagazan da nɛn o -kʋ bɔlɛ \"man Bali -pan 'kuin. E ya 'e -nyrandɩ Bali -le 'fluba 'ci vɩnɔn -dandan yei, te -a \"trɔɛn yra 'o wei lɛ, te e 'wɩ -mienun laabo -wlɔ, ɛn te o -yee -mie laabo 'e 'lɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Minnun pɛɛnɔn nɛn o \"trɔɛn \"cɩ -a wei lɛ bɛ, -yee 'wɩnun laabʋdɩ 'lee -yee 'wɩnun -ci vɩdɩ o 'plo 'fɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Zɩ -a \"tɩ 'lee -a \"bʋ \"ta bɔlɛ \"man 'kɔn zɩɛ -a -ji bɛ 'wɩ o 'kan. -A -nan nɛn -a \"bʋ \"e -yrɛ 'nan: «'Mɛn 'nɛn, -mɛ \"wɛan nɛn yia dra 'kʋɛ zɩ? 'Kʋ 'vale 'i \"tɩ \"a, kʋi -wɛɛdɩ 'sia, 'kʋ 'ci -tɔ lou.» ");
INSERT INTO yreNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ɛn Zozi \"e -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn, kaan -wɛɛman? Fɛnan nɛn 'an \"tɩ \"man wɩ cɩ bɛ -a -nan nɛn an -kɔan. Ka'a tɔa zɩ dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'Wɩ nɛn, yaa 'vɩ -wlɛ \"bɛ, wa'a -ci manlɛ \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","\"Bɛ -sru ɛn Zozi 'lee 'e \"tɩ 'lee 'e \"bʋ 'li 'o da Nazarɛtɩ. Yaa 'sia 'e \"tɩnun 'wei -da. Mari 'wɩnun zɩɛ -a 'pla 'e 'ji. ");
INSERT INTO yreNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Zozi trʋ ɛn 'yee 'wɩ 'tɔdɩ 'pa \"da. 'Wɩ zɩɛ e minnun ci nran, ɛn e Bali ci nran. ");
INSERT INTO yreNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tʋ nɛn 'wɩ 'gʋɛ e drɛ \"man \"bɛ, te Tibɛr 'bɛ cɩ mingɔnnɛnnun tazan -a Rɔm. -A lɛ -fuda 'sooluzan nɛn, te e ya mingɔnnɛn -a 'lɛglɔn pɛɛnɔn da. Ɛn tʋ zɩɛ -a va bɛ te Rɔm min Ponzʋ Pilati 'bɛ cɩ -kɔnmandan -a Zude 'lɛglɔn da. Ɛn te Erodi 'bɛ cɩ Galile 'lɛglɔn 'tazan -a, ɛn -a \"bʋɩ Filipʋ 'bɛ cɩ Iture 'lɛglɔn 'lee Trakoni 'lɛglɔn 'tazan -a. Ɛn te Lisania 'bɛ cɩ Abilenɛn 'lɛglɔn 'tazan -a. ");
INSERT INTO yreNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ɛn te Ane 'lee Kaifa 'bɛ cɩ Bali -pannɔn 'tanɔn 'a. Tʋ zɩɛ -a man nɛn Bali 'wɩ tin 'ba Zakari -pɩ Zan lɛ \"bui \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","-A -nan nɛn Zan ciɩdɩ 'sia 'yi nɛn waa laabo Zudan bɛ -a \"srɔn 'lɛglɔn pɛɛnɔn 'ji, te e 'wɩ tin \"baa minnun lɛ. Yaa 'vɩ -wlɛ 'nan: «'Ka 'si 'wɩ 'wlidɩ \"drɛdɩ man -e 'ka 'fli -nɔn Bali lɛ! 'Ka 'ta 'ka -batize drɛ -e Bali 'e 'cee 'wɩ 'wlidɩ 'fui!» ");
INSERT INTO yreNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","'Wɩ nɛn e cɩ 'e 'crɛn -tɛdɩ Bali 'lewei vɩzan Ezai -le 'fluba 'ji bɛ, zɩ 'e 'lɛ sɔɔ zɩɛ. Kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan: «Min -tʋ wei 'bɛ \"we \"bui \"da. Min zɩɛ yaa ve 'nan: 'Ka Minsan -le -si ta drɛ! 'Ka -yee -sinun ta -sɛn 'e cin va! ");
INSERT INTO yreNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","'Ka pɔn -klo pɛɛnɔn 'ji -sɛn 'e cin va! 'Ka pɔnnun 'lee pɔn 'nɛn 'ta \"nyaan -e 'o 'ta \"tra! Ɛn 'ka 'si plinnan pɛɛnɔn 'sʋ \"ji tɩglɩ! Ɛn \"nyian bɛ 'ka 'si srɛdɩ pɛɛnɔn 'ta drɛ \"yi! ");
INSERT INTO yreNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","'Ka drɛ zɩɛ -e minnun pɛɛnɔn 'o -kɔla min 'sizan 'wɩ 'ji nɛn Bali -ta -a bɛ -a yɩdɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Minnun -ta Zan -va \"kaga, 'nan -e 'e 'o -batize drɛ. -A -nan nɛn yaa 'vɩ -wlɛ 'nan: «Min -wlidɩnun! -Tɩɛ 'vɩ 'cɛɛ 'nan, 'ka 'si Bali -le nyran -blɩdɩ nɛn e \"ta -daa \"bɛ, -a wlu? ");
INSERT INTO yreNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","'Ka -kɔɔn 'ka drɛ wɩ -a 'nan, ka 'si 'wɩ 'wlidɩ \"drɛdɩ man. 'Pian te 'ka vɩ 'e \"tun 'nan, ka 'si 'wɩ 'ji Abraam a 'ka tra -a -le \"wɛan dɩ. Maan ve 'cɛɛ 'nan, Bali -kɔlaman e -kɔlɛnun 'labɛ o dra Abraam kludanɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","'Ka drɛ \"yi! Tʋ nɛn o yibanun \"cɛan bɛ, e 'bɔ 'va. Yiba \"nɛn e baa te -a 'blʋ 'ka \"yi \"dɩɛ, waa \"cɛan -e 'o tuʋ 'tɛ 'va.» ");
INSERT INTO yreNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","-A -nan nɛn minnun nɛn o -ta \"va \"bɛ, waa laabʋ -yrɔ 'nan: «Kʋa dra \"mɛn 'kɔ?» ");
INSERT INTO yreNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ɛn Zan \"e 'nan -wlɛ 'nan: «Min nɛn -tralɛ -a -yrɔ \"fli \"bɛ, 'e -tʋ -nɔn min nɛn -yee \"ka \"dɩɛ -yrɛ. Ɛn min nɛn -blɩfɛ -a -yrɔ \"bɛ, 'e bɔɛzan \"le \"nɔn.» ");
INSERT INTO yreNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","-Va \"lala 'sinɔn \"o \"ta wʋ \"nyian 'o -batize drɛlɛ, ɛn waa laabʋ Zan -lɔ 'nan: «Bali -le 'wɩ \"paazan, \"kʋ \"drɛ 'kɔ?» ");
INSERT INTO yreNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ɛn Zan \"e 'nan -wlɛ 'nan: «Te 'ka -va \"lala 'si 'e 'ciɩla -nyrɛn waa 'vɩ 'cɛɛ bɛ -a da dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ɛn 'sounjanun \"o laabʋ \"nyian -yrɔ 'nan: «Kʋʋ \"nun, \"kʋ \"dra 'kɔ?» E 'nan 'wlɛ 'nan: «Te 'ka \"lala 'si minnun lɔ -sa -a dɩ! Ɛn te 'ka 'si 'wlu wɩ man dɩ! 'Pian 'ka 'pan 'bɛ cɩ 'cee vɛ -a!» ");
INSERT INTO yreNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Minnun nɛn fɛ zɩɛ -a 'nan bɛ, 'wɩ nɛn Bali \"e 'nan, e -taa \"drɛlɛ bɛ -a -cin a o ji. -Yee \"wɛan 'o 'ci nrɔn 'nan, Zan -kɔan Crizi nɛn e min \"sia 'wɩ 'ji bɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tɔɔn ɛn Zan \"e 'nan o pɛɛnɔn lɛ 'nan: «\"An 'ka -batize dra 'yi 'a. 'Pian min nɛn -a 'plɛblɛ \"mlian 'an da bɛ, e \"ta -daa. An 'ka -yee -manwua \"tun \"da baa \"fluzan -a dɩ. -Yɛɛ 'ka -batize dra Bali lei 'saun 'lee 'tɛ 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","-Yee -klu \"a 'e 'lɔ, -e 'e fɛ 'lee 'e -flu 'cɛn 'e cin man. Yaa 'wlɛ -sɛan 'yee 'trɛbɔ -ji, 'pian -a -flu \"bɛ yɛɛ -sɛan 'tɛ nɛn ya'a 'driman 'mlɔnmlɔn dɩɛ -a va, -e 'e 'tɛ 'blɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","'Wɩ zɩɛ 'lee 'wɩ \"kaga \"pee nɛn Zan -a 'vɩ minnun lɛ Bali -le 'wɩ 'nɔnnɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ɛn \"nyian bɛ, Zan 'wɩ 'pla Galile 'lɛglɔn 'tazan Erodi lɛ. Kɔɔ Erodi 'e \"bʋɩ nan Erodia 'pa, ɛn e 'wɩ 'wlidɩ \"pee drɛ \"nyian \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","\"Bɛ -sru ɛn e 'wɩ 'wlidɩ drɛ \"nyian Zan -fɔdɩ -a -pʋ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Minnun pɛɛnɔn -ta 'o -batize drɛlɛ Zan -va. Ɛn Zozi \"e \"ta 'wʋ \"nyian \"e -batize drɛlɛ. \"Bɛ -sru zɩ Zozi Bali trʋ 'badɩ 'sia bɛ, ɛn labli 'lɛ 'sʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","-A -nan nɛn Bali lei 'saun sɔɔn \"da -goezee \"le -plablo -le 'wɩ 'zʋ. Ɛn wei -tʋ wɩɩ laji. Yaa 'vɩ 'nan: «I ya 'an 'pɩ nɛn maan ye \"yi ɛn -yee 'wɩ 'an 'ci \"nranman bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Zozi lɛ a -fuba yaaga, ɛn e Bali -le 'wɩ 'nɔnnɔn vɩdɩ 'sia. Waa \"siala 'nan Zozɛfʋ nɛn Eli -pɩ -a bɛ, -yee 'nɛn nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mata -pɩ nɛn Eli -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatia -pɩ nɛn Zozɛfʋ -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maati 'pɩ nɛn Nagayi 'a ");
INSERT INTO yreNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoana 'pɩ nɛn Yoda -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Mɛci -pɩ nɛn Neri 'a ");
INSERT INTO yreNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yesua 'pɩ nɛn Ɛri -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeɔn -pɩ nɛn Levi -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea -pɩ nɛn Eliakim -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jese -pɩ nɛn David -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminada -pɩ nɛn Naashɔn -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zago 'pɩ nɛn Zuda -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seru 'pɩ nɛn Nawo -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Jena 'pɩ nɛn Salmɔn -a ");
INSERT INTO yreNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matuzale 'pɩ nɛn Lame 'a ");
INSERT INTO yreNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Eno 'pɩ nɛn Jena 'a ");
INSERT INTO yreNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bali lei 'saun a Zozi 'lɔ, ɛn e 'si Zudan 'yi \"srɔn. Bali lei 'saun 'kʋ -a \"bui \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","-A -nan nɛn 'wɩ 'wlidɩ \"drɛzan nɛn waa laabo Satan bɛ, e Zozi 'man -tandɩ 'sia \"bui zɩɛ -a da. Zɩ e yi -fuba sinjɛn drɛ, te ya'a fɛ ble dɩɛ, ɛn dra -a -tɛdɩ 'sia 'plɛblɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","-A -nan nɛn Satan \"e 'nan -yrɛ 'nan: «-Te Bali -pɩ nɛn yia bɛ, 'i vɩ -kɔlɛ 'labɛ -yrɛ 'nan 'e lila \"da -blɩfɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ɛn Zozi \"e 'nan -yrɛ 'nan: «E ya 'e 'crɛn -tɛdɩ 'nan: ‹-Blɩfɛ 'saza man \"cɛɛ min \"belia dɩ.› » ");
INSERT INTO yreNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","\"Bɛ -sru ɛn Satan -kʋ -a \"nyian loulou, ɛn e mingɔnnɛn trɛ pɛɛnɔn nɛn 'trɛda bɛ -a kɔɔn -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","-A -nan nɛn e 'nan Zozi lɛ 'nan: «'An 'plɛblɛ -nɔan 'yiɛ -e 'i drɛ mingɔnnɛn trɛ 'lee 'e da fɛnun fɛnyian pɛɛnɔn 'labɛ -a tazan -a. -A pɛɛnɔn 'labɛ waa -nɔn 'mɛn, ɛn \"an -nɔan \"min nɛn an ya \"va \"bɛ -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","-Te 'i \"po sɔɔnla 'an 'wlu ɛn yian 'bɔ bɛ, -a pɛɛnɔn zɩɛ te e drɛ 'yie vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ɛn Zozi \"e 'nan -yrɛ 'nan: «E ya 'e 'crɛn -tɛdɩ 'nan: ‹Bali nɛn Minsan -a bɛ, -a 'bɔ nɛn min 'e bɔ. Ɛn -a -tʋwli \"cɛ \"nɛn min 'e 'su.› » ");
INSERT INTO yreNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","\"Bɛ -sru ɛn Satan -kʋ Zozi 'a Zeruzalɛm. Ɛn e -kʋ -a -tɔlɛ Bali -pan 'kɔn 'win -ji lou. -A -nan nɛn e 'nan -yrɛ 'nan: «-Te i ya Bali -pɩ -a bɛ, 'i 'si 'i 'fli man -e 'i 'kʋ \"tra. ");
INSERT INTO yreNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan: ‹Bali -a ve 'yee 'pasianɔn lɛ 'nan 'wei 'kun, ");
INSERT INTO yreNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","'o 'lɔ lou, \"tɔgɔ 'i 'cɛin 'e 'lɛ wʋ -kɔlɛ ji -le \"wɛan.› » ");
INSERT INTO yreNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ɛn Zozi \"e 'nan -yrɛ 'nan: «-Cɛjɛ ma'an dra dɩ. Kɔɔ e ya 'e 'crɛn -tɛdɩ \"nyian 'nan: ‹Te blamin 'e Bali nɛn Minsan -a bɛ -a man -tan dɩ!› » ");
INSERT INTO yreNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Zɩ Satan \"koe \"nyan Zozi 'man -tandɩ man bɛ, ɛn e 'si -a \"srɔn, -a man -tandɩ pee man -pɛndɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","\"Bɛ -sru ɛn Zozi 'li 'e da Galile 'lɛglɔn 'ji. Bali lei 'saun 'le 'plɛblɛ a -yrɔ. Ɛn -a 'tɔ 'wɩdɩ 'sia fɛ pɛɛnɔn 'nan. ");
INSERT INTO yreNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","E -cia Zuif 'nɔn 'le cin yɩ 'kɔnnun -ji te e Bali -le 'wɩ \"paaman minnun ji. -A 'tɔ \"yi \"a min pɛɛnɔn 'le. ");
INSERT INTO yreNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Zozi 'bɔla Nazarɛtɩ, 'fla nɛn waa 'lɛ 'bʋ \"da \"bɛ -a da. Zuif 'nɔn 'le 'flinla \"yi bɛ, waa laabo Saba. -A -tʋ da nɛn e wlala -wee cin yɩ 'kuin \"le zɩ yaa dra 'e 'cɛn bɛ -yee 'wɩ 'zʋ. E wluan lou 'nan -e 'e Bali -le 'fluba ta vɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ɛn o Bali 'lewei vɩzan Ezai -le 'fluba 'nɔn -yrɛ. Yaa 'lɛ 'sʋ, ɛn fɛnan nɛn 'wɩ 'gʋɛ e cɩ 'e 'crɛn -tɛdɩ bɛ, yaa 'yɩ. E ya 'e 'crɛn -tɛdɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Minsan lei 'saun a 'an 'lɔ, kɔɔ yaan 'si \"va, 'nan -e 'an Bali -le 'wɩ 'nɔnnɔn vɩ 'yalɛ -tɛnɔn lɛ, 'nan -e 'an minnun nɛn o cɩ 'o yra yɩnan bɛ, o 'si 'wɩ 'ji. 'Nan -e 'an minnun nɛn o yiɛ a 'e 'widɩ bɛ, -a 'lɛ 'sʋ, 'nan -e 'an minnun nɛn o cɩ 'tɛ 'panan o da bɛ o 'si 'wɩ 'lɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","'Nan -e lɛ nɛn Minsan 'yee \"yi -kɔɔnman -ji bɛ, 'an vɩ 'cɛɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Zɩ e cɛɛn 'fluba zɩɛ -a ta vɩdɩ man bɛ, yaa 'lɛ 'wʋ, ɛn yaa -nɔn cin yɩ 'kuin 'pasiazan lɛ. -A -nan nɛn e -nyran. Minnun pɛɛnɔn nɛn cin yɩ 'kuin bɛ, 'o yiɛ 'sɛn \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","-A -nan nɛn e 'nan -wlɛ 'nan: «'Wɩ nɛn kaa 'man Bali -le 'fluba 'gʋɛ -a -ji bɛ, 'e 'lɛ sɔɔdɩ 'sia cɛɛgʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɛn minnun pɛɛnɔn 'tɔ -a -sru. 'Wɩ 'nɔnnɔn nɛn e bɔala -a 'le bɛ e o 'plo 'fɔ, te waa ve 'nan: «Zozɛfʋ -pɩ \"cɛɛ dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Maan -tɔa 'nan -kɔnnɛn 'gʋɛ ka -taa -a -fɔlɛ 'mɛn. -Kɔnnɛn zɩɛ -nyrɛn 'nan: ‹Min 'belizan, 'i 'fli 'beli 'i 'bɔ 'a!› Ɛn ka -taa \"nyian -a vɩlɛ 'mɛn 'nan, 'wɩ pɛɛnɔn nɛn yia drɛ Kapanamo kʋa 'man bɛ, 'i drɛ 'i fla 'gʋ! ");
INSERT INTO yreNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, minnun 'ka Bali 'lewei vɩzan 'tʋ siala -dan 'e 'bɔ fla dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ɛn e ya \"le 'an 'wɩ 'gʋɛ -a -cin -tɔ 'ka 'ji. Tʋ nɛn Bali 'lewei vɩzan Eli a 'li bɛ, laa cɛɛn lɛ yaaga mlɛn 'shɛɛdʋ, ɛn dra -dan -ta 'fla pɛɛnɔn da. Tʋ zɩɛ -a man bɛ te -cale \"kaga \"a Izraɛl, ");
INSERT INTO yreNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","'pian Bali 'ka Eli 'palɛ -sia o -tʋ -va dɩ. -Pɛn lɩ -tʋ nɛn e ya -cale -a Sidɔn 'lɛglɔn 'ji 'fla nɛn waa laabo Sareta bɛ -a da bɛ, -a va nɛn Bali Eli 'pa 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ɛn \"nyian tʋ nɛn Bali 'lewei vɩzan Elize a 'li bɛ, te -kogobe 'tɛnɔn \"kaga \"a \"nyian Izraɛl. -Kogobe 'ka 'silɛ min -tʋwli \"man dɩ, 'pian Siri min Naaman man nɛn -kogobe 'si.» ");
INSERT INTO yreNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Zɩ minnun 'wɩ zɩɛ -a 'man bɛ, 'bli 'fɔ o pɛɛnɔn 'ji cin yɩ 'kɔn 'bɔ 'ji. ");
INSERT INTO yreNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","O -sɛn lou, ɛn o Zozi 'bɔla bei \"sa -a. -A -nan nɛn o -kʋ -a 'fla lu \"nɛn, 'nan -e 'o 'ta 'tɔ \"man pɔn -yro -ji. Kɔɔ -wee 'fla 'bɔ a pɔn da. ");
INSERT INTO yreNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","'Pian Zozi 'bɔla o yei 'e \"tun, ɛn e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Zozi 'bɔla Kapanamo. E ya Galile 'lɛglɔn 'fla 'tʋ -a. Ɛn -wee 'flinla \"yi da bɛ e Bali -le 'wɩ \"paadɩ 'sia -wee cin yɩ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","-Yee 'wɩ \"paadɩ minnun 'plo 'fɔ, kɔɔ yaa ve \"le Bali -a -kɔladɩ -nɔn -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Min -tʋ a cin yɩ 'kɔn 'bɔ 'ji bɛ, -yʋ -wlidɩ \"a -a -sru. E -paandɩ 'sia 'plɛblɛ. Yaa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Nazarɛtɩ min Zozi, -mɛ \"wɛan nɛn i -tɔa 'kʋe 'wɩ 'ji? I -ta 'kʋ klu 'sʋlɛ. Mɛin -tɔa. Bali -le min tɩglɩ nɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ɛn Zozi -a -tɛra -a 'nɛan, e -yʋ -wlidɩ \"lɛ 'nan: «'I 'ta -tɔ! 'I 'si min 'labɛ -a -sru!» -A -nan nɛn -yʋ -wlidɩ \"min zɩɛ -a -tria minnun yei, ya'a fɛ -tʋ drɛlɛ -yrɛ \"dɩ, ɛn e 'si -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","'Wɩ zɩɛ e min pɛɛnɔn 'kan, ɛn waa 'vɩ 'o cin lɛ 'nan: «-Mɛ \"sʋ -man wɩ 'bɛ cɩ zɩɛ? Yaa ve -yʋ -wlidɩnun lɛ 'yee 'plɛblɛ 'lee 'yee -kɔladɩ -a, 'nan 'o 'si minnun -sru -e 'o drɛla \"da.» ");
INSERT INTO yreNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","'Wɩ nɛn Zozi 'a drɛ zɩɛ, -yee \"wɛan -a 'tɔ \"yi \"vɩdɩ 'pa \"nyian \"da Galile 'lɛglɔn pɛɛnɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Zɩ Zozi 'bɔla cin yɩ 'kuin bɛ, ɛn e -kʋ min -tʋ nɛn waa laabo Simɔn bɛ -yee \"kɔnnɛn. Tʋ zɩɛ -a man bɛ, te Simɔn nan \"bʋ \"a 'e yra yɩnan 'kɔlɛ -wɔandɩ 'plɛblɛ 'lɔ. -A -nan nɛn minnun Zozi trʋ 'ba 'nan 'e -nanjɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Zozi 'kunnan lɩ zɩɛ -a da, ɛn e 'nan 'kɔlɛ -wɔan \"cɛ lɛ 'nan: «'I 'si lɩ 'gʋɛ -a man.» Tɔɔn ɛn -a 'kɔlɛ 'e 'trɔ -fɔ. -A -nan nɛn e wluan, ɛn e fɛ -nɔn -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Zɩ funninmlan 'pla bɛ, ɛn minnun -tʋdʋ pɛɛnɔn nɛn -cɛ 'tɔ 'tʋdʋ pɛɛnɔn cɩ o man bɛ, o -ta waa Zozi lɛ. 'E 'pɛ 'pla o -tʋdʋ pɛɛnɔn da, ɛn e o beli. ");
INSERT INTO yreNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","E -yʋ -wlidɩnun -pin min \"kaga -sru \"nyian. O \"sia o -sru -paandɩ -a. O -paanman 'nan: «Bali -pɩ nɛn 'yia.» 'Pian Zozi 'ka o 'tʋɩlɛ -e 'o 'wɩ dɩ, kɔɔ waa -tɔa 'nan Zozi a min 'sizan 'wɩ 'ji -a. ");
INSERT INTO yreNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Zɩ tʋ cɛɛn bɛ, ɛn Zozi 'si 'fla. E -kʋ fɛnan nɛn -a -nan cɩ flɩɩ bɛ -a -nan. 'Pian minnun -kʋ -a -wɛɛdɩ -a, ɛn o -kʋ bɔlɛ \"man. O ya \"vale o dra 'nan -e 'e vɩlɛ 'e 'si 'o \"srɔn \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","-A -nan nɛn e 'nan -wlɛ 'nan: «Bali 'bɛ cɩ mingɔnnɛn -a fɛ pɛɛnɔn da. E ya \"le 'an 'kʋ -yee mingɔnnɛn -blɩdɩ 'wɩ vɩ min peenun lɛ \"nyian, kɔɔ 'wɩ zɩɛ -a man nɛn Bali 'an 'pa 'sia.» ");
INSERT INTO yreNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ɛn Zozi 'kʋ Bali -le 'wɩ vɩlɛ 'lɛglɔn pɛɛnɔn 'ji -wee cin yɩ 'kɔnnun -ji. ");
INSERT INTO yreNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yi -tʋ da, te Zozi a 'e 'tɔdɩ 'yi nɛn waa laabo \"nyian Jenezarɛt bɛ -a 'plo da, ɛn minnun tredɩ 'sia \"man \"kaga, 'nan -e 'o Bali -le 'wɩ man. ");
INSERT INTO yreNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","-A -nan nɛn e -klʋ \"fli 'yɩ 'e 'tɔdɩ 'yi 'bɔ zɩɛ -a 'plo man, te pɔ -tɛnɔn sɔɔnla 'ji, 'nan -e 'o 'wee pɔ -tɛ \"se -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Zozi 'fɔ -klʋ zɩɛ -a -tʋ -ji, te Simɔn -le vɛ nɛn. Ɛn e 'nan Simɔn 'bɔ lɛ 'nan: «'Kʋ 'si 'yi 'plo man -kogo.» Tɔɔn ɛn e -nyran. E -fʋ -klʋ -ji, ɛn e 'wɩ \"paadɩ 'sia minnun ji. ");
INSERT INTO yreNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Zɩ e cɛɛn -a 'wɩdɩ man bɛ, ɛn e 'nan Simɔn lɛ 'nan: «'I -pli \"klʋ -a fɛnan nɛn 'yi -klu cɩ bɛ -a -nan, -e 'ka 'cee \"se 'wɛɛn -e 'ka pɔ -tɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ɛn Simɔn \"e 'nan -yrɛ 'nan: «'Kʋ 'san, kʋ 'nyranman 'pa paan 'pei -man \"fo, ɛn fɛ -tʋ 'ka 'fɔlɛ 'kʋe \"se \"ji dɩ. 'Pian 'i wei da nɛn, an \"ta \"se 'gʋɛ -a wɛɛnman.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Zɩ waa drɛ bɛ, ɛn pɔ -sɛn -wee \"se \"ji \"kaga 'kpa. -Yee \"wɛan -wee \"se \"ta 'fʋɩ bʋʋman. ");
INSERT INTO yreNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","-A -nan nɛn o pɔ -tɛnɔn nɛn -klʋ -tʋ -ji bɛ o laabʋ 'nan, 'o 'ta 'pa 'o 'va. Zɩ o -ta bɛ, ɛn o 'wee -klʋ \"fli 'bɔ 'fa pɔnɛn 'a. -Klʋ \"fli zɩɛ o ya \"vale 'o 'ko 'siɛn 'yi 'wlu. ");
INSERT INTO yreNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Zɩ Simɔn Piɛri 'wɩ zɩɛ -a -nan 'yɩ bɛ, 'e \"po sɔɔnla Zozi 'wlu, ɛn e 'nan -yrɛ 'nan: «Minsan, 'i 'si 'an \"srɔn \"kogo, kɔɔ an ya min nɛn e 'wɩ 'wlidɩ \"dra bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pɔ \"kaga \"nɛn waa -tɛ bɛ, -yee \"wɛan \"klan -dan sɛn Simɔn 'lee o pɛɛnɔn nɛn o cɩ waa bɛ o ji, ɛn e 'wɩ zɩɛ -a 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","'Wɩ 'tʋwli zɩɛ -yɛɛ drɛ \"nyian Zebede -pɩnun Zaji 'lee Zan nɛn Simɔn \"srɔn \"bɛ -wlɛ. Ɛn Zozi \"e 'nan Simɔn lɛ 'nan: «Te nyɛn 'e 'i 'cɛn dɩ! -Pɔ -tɛzan nɛn 'yia, 'pian -e 'e 'sia cɛɛgʋ man bɛ, i drɛ min nɛn e -taa \"minnun laabʋlɛ 'an -sru \"bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","\"Bɛ -sru ɛn o -ta 'wee -klʋ -a 'yi 'plo man. O 'si fɛ pɛɛnɔn zɩɛ -a -sru, ɛn o sɔɔnla Zozi -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yi -tʋ da bɛ, ɛn Zozi 'lee min -tʋ 'o cin 'yɩ 'fla 'tʋ da. Min zɩɛ -kogobe a 'kɔlɛ pɛɛnɔn da 'si \"fo. Zɩ e Zozi 'yɩ bɛ, 'nun tɔɔn 'e \"po sɔɔn \"wlu, ɛn 'e yra blula. -A -nan nɛn e toba -fɔdɩ 'sia -yrɛ. E 'nan: «Minsan, maan -tɔa 'nan, -te i wɩɩ \"man \"bɛ, i -kɔlaman i -kogobe \"sia 'an man, -e 'an drɛ 'saun Bali 'lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ɛn Zozi 'e 'pɛ 'sʋ \"ji, e klɛ \"man, ɛn yaa 'vɩ -yrɛ 'nan: «An \"we \"man. 'I drɛ 'saun Bali 'lɛ!» 'Nun tɔɔn ɛn -kogobe 'si \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","\"Bɛ -sru Zozi \"e -yrɛ 'nan: «Te 'i vɩ min lɛ 'nan, mɛin beli dɩ! 'Pian 'i 'kʋ Bali -panzan -tʋ -va, -e 'yei 'nanjɛn! \"Bɛ -sru -e 'i 'sraga bʋ Bali lɛ, \"le zɩ Moizi -a crɛn -tɛ Bali -le 'fluba 'ji bɛ -yee 'wɩ 'zʋ. Tɔɔn -e minnun pɛɛnɔn 'o -kɔnnɛn \"yɩ 'nan, i beli.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Zozi 'tɔ \"yi \"a min -tʋdʋ pɛɛnɔn 'le fɛ pɛɛnɔn 'nan, te minnun -taa \"va 'nan -e 'o wei man -e 'e 'wee -cɛ 'si 'o man. ");
INSERT INTO yreNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","'Pian Zozi 'si o va, ɛn e -kʋ fɛnan nɛn -a -nan cɩ flɩɩ bɛ -a -nan, 'nan -e 'e Bali trʋ 'ba. ");
INSERT INTO yreNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yi -tʋ da, te Zozi a Bali -le 'wɩ \"paanan minnun ji bɛ, Farizɛn 'nɔn 'lee 'fluba 'ci vɩnɔn a -nan. O 'si Galile 'lee Zude 'fla pɛɛnɔn da, ɛn o -mie 'si \"nyian Zeruzalɛm. Bali -le 'plɛblɛ a Zozi 'lɔ, te e minnun \"belia -a. ");
INSERT INTO yreNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","-A -nan nɛn minnun -tadɩ 'sia, te min -srandɩ -tʋ a -wlɔ \"se \"ji. O ya \"vale 'o min zɩɛ -a -wlamlan 'kuin 'nan -e 'o 'pla Zozi 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","'Pian wa'a -kɔlalɛ -a -wladɩ -a dɩ, kɔɔ min -a -nan \"kaga. Tɔɔn ɛn o 'kɔn tri. O 'kɔn bɔ 'fɔn 'e 'win -ji lou, ɛn o -cɛzan zɩɛ -a sɔɔnla \"se \"ji minnun pɛɛnɔn yei Zozi 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Zɩ Zozi -wee yi -tɛradɩ 'e da 'yɩ bɛ, ɛn e 'nan -cɛzan zɩɛ -yrɛ 'nan: «An 'yie 'wɩ 'wlidɩnun fui.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","-A -nan nɛn 'fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn 'o 'ci \"nrɔndɩ 'sia, ɛn o 'nan: «-Tɩɛ Bali 'tɔ srɛman zɩɛ? Min -tʋ 'ka 'kɔlaman -e 'e blamin -le 'wɩ 'wlidɩ \"fui dɩ, -te ya'a 'silɛa Bali -tʋwli \"a dɩɛ!» ");
INSERT INTO yreNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","'Pian Zozi -wee ci \"nrɔndɩ 'yɩ, ɛn yaa laabʋ -wlɔ 'nan: «-Mɛ \"wɛan nɛn 'ka 'ci \"nrɔnman zɩɛ? ");
INSERT INTO yreNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","-Te maan 'vɩ -yrɛ 'nan: ‹'Wɩnun nɛn yia drɛ -wlidɩ \"bɛ, maan fui›, 'bɛ a -tʋ. Ɛn -te maan 'vɩ -yrɛ 'nan: ‹'I 'wluan, 'i 'tɔ lou, 'i 'ta wʋ›, 'bɛ a -tʋ. 'Wɩ \"fli zɩɛ -a \"cɛn \"vɩdɩ 'bɛ cɩ 'plɛblɛ? ");
INSERT INTO yreNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","'Pian an \"ta -a -ci -kɔɔnman 'cɛɛ 'nan, Bali -kɔladɩ -nɔn Blamin -pɩ lɛ, -e 'e min -le 'wɩ 'wlidɩnun fui 'trɛda.» -A -nan nɛn yaa 'vɩ min -srandɩ \"tra zɩɛ -yrɛ 'nan: «'I 'wluan! 'I 'yie nyinnan \"davɛ 'sia! 'I 'kʋ 'yie \"kɔnnɛn!» ");
INSERT INTO yreNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","'Nun tɔɔn min zɩɛ e wluan o yiɛ man, ɛn e 'yee nyinnan \"davɛ 'sia, ɛn e -kʋdɩ 'sia 'yee \"kɔnnɛn, te e Bali 'tɔ bɔa. ");
INSERT INTO yreNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","'Wɩ zɩɛ e min pɛɛnɔn 'plo 'fɔ, ɛn o Bali 'tɔ bɔdɩ 'sia. O klan Bali lɔ, ɛn waa vɩdɩ 'sia 'nan: «Cɛɛgʋ nɛn, kʋ -cɛ \"srɔn wɩnun zɩɛ -a -nan 'yɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","\"Bɛ -sru, ɛn Zozi 'si fɛ zɩɛ -a -nan. \"Yɛɛ -kʋ 'e 'lɛ bɛ, ɛn e 'sukɔlɛ 'sizan 'tʋ 'yɩ, te e ya 'yee 'nyranman 'panan. Waa laabo Levi. Zozi \"e 'nan -yrɛ 'nan: «'I -sɔɔnla 'an -sru!» ");
INSERT INTO yreNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi fɛ pɛɛnɔn 'tʋɩ, e wluan, ɛn e sɔɔnla -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","\"Bɛ -sru ɛn Levi \"fɛdi -dan da fɛnun tɔɛn Zozi lɛ 'yee \"kɔnnɛn. 'Sukɔlɛ 'sinɔn \"kaga 'lee min -mienun 'bɛ cɩ 'o -nyrandɩ 'o 'vale Zozi nun -a fɛ -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farizɛn 'nɔn 'lee 'wee minnun nɛn o 'fluba 'ci ve bɛ o ci 'ka 'e 'sɔdɩ dɩ. -A -nan nɛn waa laabʋ Zozi -srunɔn lɛ 'nan: «-Mɛ \"wɛan nɛn ka fɛnun -ble, 'e cin va 'sukɔlɛ 'sinɔn 'lee 'wɩ 'wlidɩ \"drɛnɔn 'a? Ɛn -mɛ \"wɛan nɛn ka 'yi -mlian 'e cin va waa?» ");
INSERT INTO yreNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Minnun nɛn -cɛ 'ka o man dɩɛ, wa'a -dɔdrɔ -sru -wɛɛman dɩ. 'Pian minnun nɛn -cɛ cɩ o man bɛ, -wɛɛ cɩ -dɔdrɔ -va.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ɛn e 'nan \"nyian -wlɛ 'nan: «Min tɩglɩnun -le \"wɛan \"cɛɛ an -ta dɩ. 'Pian an -ta 'nan -e 'wɩ 'wlidɩ \"drɛnɔn 'o 'si 'wɩ 'wlidɩ \"drɛdɩ man, -e 'o -sɔɔnla Bali -sru.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Minnun -a 'vɩ Zozi lɛ 'nan: «Zan -srunɔn 'lee Farizɛn 'nɔn -srunɔn fɛ \"sɔan yi -mie da, te o Bali trʋ \"baa. 'Pian \"yie -srunɔn fɛ -ble, te o 'yi -mlian.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Zozi \"e -wlɛ 'nan: «-Te minnun -a lɩ 'pa \"fɛdi drɛnan bɛ, tʋ nɛn lɩ -trɛ 'pazan a o yei \"bɛ, wa'a fɛ sɔan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","'Pian tʋ -tʋ -taa \"bɔlɛ bɛ, o lɩ -trɛ 'pazan \"sia o yei. Tʋ zɩɛ -a man nɛn o fɛ \"sɔan.» ");
INSERT INTO yreNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ɛn Zozi -kɔnnɛn \"tʋ -fɔdɩ 'sia -wlɛ. Yaa 'vɩ 'nan: «Min -tʋ 'ka sɔ -trɛ 'fʋɩ 'bo, -e 'e 'pa sɔ ceje 'fɔnnan dɩ. -Te 'bɛ \"cɛɛ dɩɛ, sɔ -trɛ 'bɔ 'fʋɩ 'bʋ 'e \"tun, ɛn o yiɛ 'ka 'kɔan 'e cin va dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ɛn \"nyian bɛ, e 'ka \"le 'o -wɛn -trɛ -sɛn -wi 'kɔlɛ 'tre cejenun -ji dɩ. -Te 'bɛ \"cɛɛ dɩɛ, -wɛn -trɛ -wi 'kɔlɛ 'tre cejenun fɛaman -e -wɛn 'e 'sran, te -wi 'kɔlɛ 'trenun wii. ");
INSERT INTO yreNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","'Pian o -wɛn -trɛ -sɛan -wi 'kɔlɛ 'tre -trɛnun -ji! ");
INSERT INTO yreNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ɛn \"nyian bɛ, min nɛn -wɛn 'cɛn 'mlindɩ -trɔa -a bɛ, ya'a 'wɛn -trɛ ye \"yi \"dɩ. Kɔɔ yaa ve 'nan: ‹-Wɛn 'cɛn 'mlindɩ 'bɛ cɩ \"yi.› » ");
INSERT INTO yreNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","'Flinla \"yi da nɛn, Zozi 'lee 'e -srunɔn fei -tʋ 'cɛndɩ 'sia 'ji. Fɛ 'wlɛ nɛn fei zɩɛ -a da bɛ, -a -srunɔn 'ko -a 'cɛndɩ -a. Waa plʋmlan \"man 'o 'lɔ, te waa -ble. ");
INSERT INTO yreNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","-A -nan nɛn Farizɛn 'nɔn -mienun -a 'vɩ -wlɛ 'nan: «-Mɛ \"nɛn kaa dra bɛ? -Si 'ka -kaa 'lɔ 'nan -kaa 'wɩ zɩɛ -a drɛ -cee 'flinla \"yi da dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Wɩ nɛn -kaa tra David -a drɛ 'li, te dra -a -tɛa 'o 'vale 'yee minnun -a bɛ, ka'a tian -a ta vɩlɛ dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","E wla Bali -pan 'kuin, ɛn 'kpɔun nɛn waa 'pla Bali -le vɛ -a bɛ, yaa 'sia, yaa blɩ, ɛn e 'yee minnun \"le \"nɔn. 'Wɩ zɩɛ yaa drɛ, 'pian te e ya 'e vɩdɩ 'nan Bali -pannɔn 'saza 'bɛ -ble.» ");
INSERT INTO yreNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ɛn Zozi -a 'le 'sran -wlɛ 'nan: «'An 'bɔ Blamin -pɩ mɛɛn cɩ 'flinla \"yi san -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","'Flinla \"yi pee 'bɔ \"nyian, ɛn Zozi wla cin yɩ 'kuin. E Bali -le 'wɩ \"paadɩ 'sia minnun ji. Min -tʋ a 'kɔn zɩɛ -a -ji, -a -pɛ \"yi \"pɛla a 'e 'kadɩ 'e man. ");
INSERT INTO yreNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ɛn 'fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn Zozi -nanjɛndɩ 'sia -gɔɛɛn. O ya -a -nanjɛnnan 'nan -te e -cɛ \"sia min man 'flinla \"yi da -o. O ya -a man -wɛɛnan 'nan -e 'o 'wɩ 'tʋ yɩ, -e 'o -kɔla 'wɩ 'tɔdɩ -a \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","'Pian Zozi -wee ci \"nrɔndɩ 'yɩ, ɛn e 'nan min nɛn -a -pɛla cɩ 'e 'kadɩ 'e man bɛ -yrɛ 'nan: «'I 'wluan lou -e 'i 'tɔ min yei 'gʋ!» E wluan, ɛn e -tɔ lou minnun yei. ");
INSERT INTO yreNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","-A -nan nɛn Zozi -a laabʋ -wlɔ 'nan: «-Mɛ \"wɩ nɛn -cee -pei -a 'vɩ? -Si a 'e 'nɔndɩ min lɛ 'nan 'e 'wɩ \"yi \"drɛ 'flinla \"yi da, -baa te 'e drɛ dɩ? Ɛn \"nyian min -kɔlaman e min \"belia, -baa yaa \"tʋe -e 'e 'ka?» ");
INSERT INTO yreNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Zozi o pɛɛnɔn 'nanjɛndɩ 'sia 'tʋdʋ, ɛn e 'nan min nɛn -a -pɛla 'ka 'e man bɛ -yrɛ 'nan: «'I 'pɛ 'sʋ \"ji.» Min zɩɛ yaa drɛ, 'nun tɔɔn ɛn -a -pɛ drɛ \"plɔnblɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","'Wɩ zɩɛ e 'bli 'fɔ Zozi 'nanmannɔn 'ji, ɛn o 'wɩ nɛn o \"ta -daa -a drɛlɛ -yrɛ \"bɛ, -a -sa -fɔdɩ 'sia 'o cin yei. ");
INSERT INTO yreNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yi -tʋ da ɛn Zozi 'kʋ Bali trʋ 'balɛ pɔn -tʋ da. E -fʋ Bali trʋ 'banan -trilii, ɛn tʋ cɛɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Zɩ tʋ cɛɛn bɛ, ɛn 'e -srunɔn laabʋ. E min 'si o va -fuda \"fli, e o 'tɔ 'pa 'yee 'pasianɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","O 'tɔ nɛn 'gʋ: Simɔn nɛn yaa 'tɔ 'pa Piɛri bɛ, 'lee 'e \"bʋɩ Andre, 'lee Zaji, 'lee Zan, 'lee Filipʋ, 'lee Batelemi, ");
INSERT INTO yreNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","'lee Matie, 'lee Toma, 'lee Alife -pɩ Zaji, 'lee Simɔn -tʋ nɛn waa laabo \"nyian Zelo bɛ, ");
INSERT INTO yreNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","'lee Zaji -pɩ Zude, 'lee Zudazi Karioti. Min nɛn e \"ta -daa Zozi 'nɔnlɛ 'e 'nanmannɔn lɛ bɛ -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Zozi pɔn sɔɔn \"ji o 'vale 'yee 'pasianɔn 'bɔ 'a, ɛn e -tɔ fɛnan pablanɛn 'tʋ -nan. Min \"kaga \"a 'o 'sɛndɩ fɛ zɩɛ -a -nan 'o 'vale -a -srunɔn \"kaga \"a \"nyian. Minnun zɩɛ o 'si 'lɛglɔn 'tʋdʋ pɛɛnɔn 'ji, ɛn o -ta. O -mie 'si Zude 'lɛglɔn 'ji, ɛn o -mie 'si Zeruzalɛm 'fla, ɛn o -mie 'si jemie \"srɔn Sidɔn 'lee Tir 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","O -ta 'nan -e 'o Zozi wei man, ɛn 'nan -e 'e -cɛ 'si 'o man. Minnun nɛn -yʋ -wlidɩ \"cɩ o -sru \"bɛ, o beli. ");
INSERT INTO yreNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɛn minnun pɛɛnɔn -a -wɛɛman 'nan 'o kla Zozi man, kɔɔ 'plɛblɛ 'tʋ bɔala \"ji, te e -cɛ \"sia o pɛɛnɔn man. ");
INSERT INTO yreNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Zozi 'e yiɛ 'tɔ 'e -srunɔn 'va, ɛn e 'nan: «Kaa nɛn ka ya 'yalɛ -tɛnɔn 'a bɛ, Bali -le -fɛa a 'ka man, kɔɔ ka ya Bali -le mingɔnnɛn trɛdanɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kaa nɛn dra cɩ 'ka -tɛnan bɛ, Bali -le -fɛa a 'ka man, kɔɔ ka -taa 'kanlɛ. Kaa nɛn 'ka cɩ -wuɔnan bɛ, Bali -le -fɛa a 'ka man, kɔɔ 'ka 'ci -taa \"nranlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","-Te minnun \"naan 'ka man Blamin -pɩ -le \"wɛan oo, ɛn -te minnun 'ka 'si o 'va Blamin -pɩ -le \"wɛan oo, ɛn -te minnun 'ka \"srɔnman Blamin -pɩ -le \"wɛan oo, ɛn -te minnun 'ka 'tɔ srɛman Blamin -pɩ -le \"wɛan oo, Bali -le -fɛa a 'ka man. ");
INSERT INTO yreNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","'Wɩ zɩɛ 'e 'ka 'ci \"nran, ɛn 'ka 'sʋ lou ci \"nran -a, kɔɔ 'ka -kopa a -dan laji. -A -cin 'e 'kɔn 'ka 'ji 'nan, 'wɩ -tʋwli zɩɛ o tranun -a drɛ Bali 'lewei vɩnɔn lɛ 'li. ");
INSERT INTO yreNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ɛn \"nyian bɛ, kaa nɛn ka cɩ fɛnɔn 'a bɛ, 'wɩ -taa \"bɔlɛ 'ka man, kɔɔ ka ya 'cee vɛ drɛnan 'va. ");
INSERT INTO yreNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ɛn kaa nɛn ka cɩ 'ka kandɩ bɛ, 'wɩ -taa \"bɔlɛ 'ka man, kɔɔ dra \"ta -daa 'ka 'tɛlɛ. Ɛn kaa nɛn ka cɩ 'shɛ 'blɩnan bɛ, 'wɩ -taa \"bɔlɛ 'ka man, kɔɔ ka \"ta -daa \"wuɔlɛ \"le -cɛ 'bɔ 'ka da. ");
INSERT INTO yreNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","-Te minnun -cee 'wɩ \"yi \"ve bɛ, 'wɩ -taa \"bɔlɛ 'ka man. -A -cin 'e 'kɔn 'ka 'ji 'nan, 'wɩ 'tʋwli zɩɛ o tranun -a drɛ minnun nɛn o Bali 'lewei 'vɩ 'li 'wlu 'a 'bɛ -wlɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Kaa nɛn 'ka \"trɔɛn \"cɩ 'mɛn bɛ, maan ve 'cɛɛ 'nan: 'Ka 'ka 'nanmannɔn yɩ \"yi! 'Ka \"yi \"drɛ -wlɛ! ");
INSERT INTO yreNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","'Ka 'fɛa vɩ minnun nɛn o -yʋ -saanman 'ka man bɛ o man! Minnun nɛn o 'tɛ \"paa 'ka da bɛ, 'ka Bali trʋ 'ba -wlɛ! ");
INSERT INTO yreNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","-Te min 'pa 'fɔ 'i 'klanbo \"tʋ da bɛ, 'i -tʋ -tɔ \"nyian -yrɛ. Ɛn -te min 'yie -sɛn \"dasɔ 'si 'i 'lɔ bɛ, te 'i 'si -tɔ -yrɔ 'yie -tralɛ 'sinan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Min oo min nɛn e fɛ -tʋ laabʋ 'i 'lɔ bɛ, -te e ya 'i 'lɔ, 'i -nɔn -yrɛ. -Te min 'yie fɛ 'si 'i 'lɔ, te yiɛ \"cɛɛ -nɔn -yrɛ \"dɩɛ, te 'i vɩ -yrɛ 'nan 'e 'lɛji bɔla 'yiɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","'Wɩ nɛn ka cɩ \"vale minnun 'o drɛ 'cɛɛ bɛ, -a 'wɩ 'lein zɩɛ -nyrɛn 'ka -wee \"drɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","-Te minnun nɛn o 'ka ye \"yi \"bɛ, o 'saza nɛn ka o ye \"yi \"bɛ, te -a -cin 'e 'kɔn 'ka 'ji 'nan Bali -a man \"yi \"dra 'cɛɛ dɩ! 'Wɩ 'wlidɩ \"drɛnɔn \"nyian, min nɛn e o ye \"yi \"bɛ, -nyrɛn waa ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Minnun nɛn o \"yi \"dra 'cɛɛ, -te o lɛ nɛn ka \"yi \"dra bɛ, te -a -cin 'e 'kɔn 'ka 'ji 'nan Bali -a man \"yi \"dra 'cɛɛ dɩ! 'Wɩ 'wlidɩ \"drɛnɔn \"o \"dra \"nyian zɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","-Te ka fɛ \"fɛa minnun nɛn kaa -tɔa 'nan waa 'lɛji bɔala bɛ -wlɛ \"bɛ, te -a -cin 'e 'kɔn 'ka 'ji 'nan Bali -a man \"yi \"dra 'cɛɛ dɩ! 'Wɩ 'wlidɩ \"drɛnɔn fɛ \"fɛa 'wɩ 'wlidɩ \"drɛnɔn lɛ, 'nan -e 'o 'lɛji bɔla. ");
INSERT INTO yreNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Te 'cee vɛ 'e 'kɔn zɩ dɩ! 'Pian minnun nɛn o \"naan 'ka man bɛ, 'ka o yɩ \"yi! 'Ka \"yi \"drɛ -wlɛ! Ɛn \"nyian bɛ 'ka fɛ 'fɛ min lɛ 'e \"tun. Te 'ka 'ci \"nrɔn 'nan, e -kɔlaman -a 'lɛji bɔladɩ -a dɩ. -Te ka ya 'wɩnun zɩɛ -a drɛnan bɛ, 'ka -kopa -kɔan -dan. Ɛn ka -kɔan Bali nɛn lou \"bɛ -yee 'nɛnnun -a. -A -cin 'e 'kɔn 'ka 'ji 'nan, Bali \"yi \"dra minnun nɛn wa'a min 'tɔ \"yi 've dɩɛ -wlɛ, ɛn e \"yi \"dra nyannɛnnɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","-Yee \"wɛan 'ka 'ci 'e 'kɔn \"yi \"le zɩ 'ka \"tɩ Bali ci cɩ \"yi \"bɛ -yee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Te 'ka min 'tɔ 'tɛ dɩ, \"tɔgɔ tʋ nɛn Bali 'trɛdanɔn 'le tin \"baa bɛ, 'e tin -tɛ 'ka da! Te 'ka 'wɩ bɔ min man dɩ, \"tɔgɔ tʋ nɛn Bali 'trɛdanɔn 'le tin \"baa bɛ, 'e 'wɩ bɔ 'ka man! 'Ka 'wɩ 'cɛ min lɛ, -e Bali 'e \"cee 'wɩ 'cɛ! ");
INSERT INTO yreNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","'Ka fɛ -nɔn min lɛ, -e Bali 'e \"cee \"nɔn! Bali -a faa 'coun -e 'e -sɛn 'ka 'man sɔ -ji. Zɩ i 'wɩ dra 'i bɔɛzan -tʋ -va bɛ, -a da nɛn Bali \"yie \"dra.» ");
INSERT INTO yreNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ɛn Zozi 'wɩ 'tʋ 'vɩ -wlɛ -kɔnnɛn \"ji. E 'nan: «Yiɛ 'wizan 'ka -si kɔɔnman 'e bɔɛzan yiɛ 'wizan lɛ dɩ, -te 'bɛ \"cɛɛ dɩ, o \"flinɔn -tɛa \"klu -ji. ");
INSERT INTO yreNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ɛn min nɛn e cɩ 'wɩ -tranlanan \"bɛ, ya'a 'mlian 'wɩ \"paazan da dɩ, 'pian min nɛn e 'wɩ 'tɔ tɩglɩ bɛ, e dra \"le min nɛn e 'wɩ paa \"ji \"bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","-Mɛ \"le \"wɛan nɛn i yiba -flunɛn ye 'i bɔɛzan -tʋ yiɛ -goei, te 'i 'bɔ 'le vɛ nɛn yiba -dan 'bɔ cɩ 'bɛ 'ci bɛ, yi'a 'bɛ 'ye dɩ? ");
INSERT INTO yreNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","'I 'bɔ nɛn yiba -dan a 'i 'yiɛ -goei te yi'a 'ye dɩɛ, -mɛ \"le \"wɛan nɛn yiɛ ve 'i bɔɛzan lɛ 'nan: ‹'An \"bʋɩ, 'i 'tɔ -e 'an yiba -flu 'si 'i 'yiɛ -goei!› -Blʋzan, 'i yiba 'si 'i 'yiɛ -goei 'e 'flin 'vaa, -e 'i fɛnan yɩ 'wein. \"Bɛ -sru i -kɔlaman yiba -flu 'sidɩ -a 'i bɔɛzan -tʋ yiɛ -goei.» ");
INSERT INTO yreNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Yiba 'kpa 'ka 'baa yiba \"bɛwlɛ 'wlidɩ \"a dɩ! Ɛn yiba -wlidɩ 'ka 'baa yiba \"bɛwlɛ \"yi \"a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","O yiba -tɔa 'e 'blʋ man, kɔɔ kaa -tɔa 'nan wa'a -lomin 'naan -tɛin \"man dɩ, ɛn wa'a -wɛn bɛwlɛ 'naan \"trɔɛn 'fɔn lei man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Min nɛn -a ci wɩ a \"yi \"bɛ, -a 'le nɛn 'wɩ \"yi bɔala. Ɛn min nɛn -a ci wɩ a -wlidɩ \"bɛ, -a 'le nɛn 'wɩ 'wlidɩ bɔala. -Yɛɛ cɩ 'nan, 'wɩ nɛn 'e fadɩ min ji bɛ, -yɛɛ bɔala min 'le.» ");
INSERT INTO yreNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«-Mɛ \"le \"wɛan nɛn kaan laabo Minsan, Minsan, 'pian 'wɩ nɛn maan ve 'cɛɛ bɛ, te ka'a dra dɩ? ");
INSERT INTO yreNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Min nɛn e drɛ 'an -sruzan 'a, te yaan wei maan, ɛn e 'ta wʋla \"da \"bɛ, an \"ta -a -kɔɔnman 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","E ya \"le min nɛn e \"ta 'yee 'kɔn -tɔa, yaa -klu cɛɛn 'e trʋdɩ, ɛn yaa -pʋ -fɔ 'plɛblɛ bɛ, -yee 'wɩ 'zʋ. -Te 'yi 'fa, 'yi nɛn e \"yro \"bɛ, ya'a 'kɔlaman 'kɔn zɩɛ -a -widɩ -a dɩ, kɔɔ e ya 'e 'tɔdɩ -kli. ");
INSERT INTO yreNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","'Pian min nɛn yaan wei 'man, ɛn ya'a 'ta wʋlɛa \"da \"dɩɛ, -a san a \"le min nɛn e 'kɔn 'trɔa nyrɛn va, ɛn ya'a -pʋ -fɔlɛ 'trɛ 'ji dɩɛ, -yee 'wɩ 'zʋ. Zɩ 'yi 'fa bɛ, e wɛɛn \"man, ɛn 'kɔn zɩɛ e -wi 'nun. E wiila 'nan \"fo.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Zɩ Zozi cɛɛn 'wɩ tin 'badɩ man minnun lɛ bɛ, ɛn e -kʋ Kapanamo. ");
INSERT INTO yreNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","'Sounjanun tazan -le nɔan -tʋ man \"yaaman 'fla zɩɛ -a da. -A -kadɩ -fɔla tʋ, ɛn -a tazan 'bɔ -a ye \"yi 'kpa tɩglɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Zɩ e Zozi 'le 'wɩ 'man bɛ, ɛn e Zuif min ceje -mienun 'pa 'sia \"va, 'nan 'e 'ta 'yee nɔan 'beli. ");
INSERT INTO yreNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Minnun zɩɛ o -kʋ, ɛn o 'bɔ Zozi man. O kɔala \"man -a trʋ 'badɩ -a. Waa 'vɩ -yrɛ 'nan: «'Sounjanun tazan 'labɛ, e ya \"le 'i 'wɩ zɩɛ -a drɛ -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","E -cee 'lɛglɔn ye \"yi, ɛn -yɛɛ 'kʋe cin yɩ 'kɔn 'tɔ.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ɛn Zozi 'kʋdɩ 'sia 'o 'vale waa. \"Yɛɛ -pli 'sounjanun tazan zɩɛ -yee vɛ -nan \"srɔn \"bɛ, ɛn min zɩɛ e beenun 'pa 'sia 'nan 'o vɩ -yrɛ 'nan: «Minsan, te 'i 'fli \"koe \"nyan dɩ! An 'ka min nɛn i -wlamlan -yee 'kuin bɛ -a dɩ, kɔɔ Zuif min \"cɛɛ 'maan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","'Wɩ zɩɛ -yee \"wɛan nɛn ma'an 'fli yɩlɛ tɩglɩ -e 'an 'lʋ 'i 'va 'an 'bɔ 'a dɩ. 'Pian an ya \"vale 'i 'wɩ 'tʋ vɩ -e 'mɛn nɔan 'e 'beli. ");
INSERT INTO yreNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kɔɔ 'an 'bɔ 'gʋɛ, 'an 'tanɔn 'bɛ 'an \"paala, ɛn 'mɛn 'sounjanun bɛ mɛɛn o \"paala. -Te maan 'vɩ -a -tʋ lɛ 'nan: ‹'I 'kʋ›, -e 'e 'kʋ. -Te maan 'vɩ -a pee lɛ 'nan: ‹'I 'ta›, -e 'e 'ta. -Te maan 'vɩ 'mɛn nɔan lɛ 'nan: ‹'I 'wɩ 'gʋɛ -a drɛ bɛ›, yaa dra.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","'Sounjanun tazan -le 'wɩ nɛn yaa 'pa 'e beenun 'le bɛ, zɩ Zozi -a 'man bɛ, yaa 'kan. -A -nan nɛn 'e man lila minnun \"kaga nɛn o -kʋla -a -sru \"bɛ o da, ɛn e 'nan: «Maan ve 'cɛɛ 'nan, Izraɛl 'nɔn 'va bɛ, ma'an min -tʋ yɩlɛ te e yi -tɛala Bali da tɩglɩ zɩɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Minnun nɛn 'sounjanun tazan o 'pa 'sia bɛ, \"wɛɛ li 'o da \"kɔnnɛn \"bɛ, te -cɛ 'si nɔan zɩɛ -a man \"fo. ");
INSERT INTO yreNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","\"Bɛ -sru ɛn Zozi 'kʋ 'fla 'tʋ nɛn waa laabo Naɛn bɛ -a da. -Wɛɛ kʋ 'o 'vale 'e -srunɔn 'lee minnun \"kaga \"a. ");
INSERT INTO yreNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Zozi \"ɛ vɩnan 'e -pli 'fla zɩɛ -a man -klɔn -kpɛin \"srɔn \"bɛ, te o \"ta -ko min -kadɩ -tʋ -a -yrɛ da. -Cale lɩmɔn -tʋ -le 'nɛn -tʋwli \"nɛn yaa -ya bɛ, -nyrɛn. 'Flanɔn \"kaga 'lee -cale 'bɔ 'bɛ cɩ -kʋnan. ");
INSERT INTO yreNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Zɩ Minsan lɩ zɩɛ -a 'yɩ bɛ, -a nyrinda -sɛn \"da, ɛn e 'nan -yrɛ 'nan: «Te 'i 'wuɔ dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","-A -nan nɛn Zozi pli 'e 'lɛ, e klɛ -planɛn man. Ɛn minnun nɛn -planɛn 'bɔ cɩ o -win -ji bɛ, o -tɔ. Ɛn Zozi \"e 'nan: «-Gobonɛn, 'an 'bɔ \"e 'yiɛ 'nan, 'i 'wluan lou!» ");
INSERT INTO yreNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Min -kadɩ zɩɛ e wluan lou, ɛn e 'wɩdɩ 'sia. Ɛn Zozi \"e 'nan -a \"bʋ \"lɛ 'nan: «'Yie 'nɛn nɛn 'gʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nyɛn minnun pɛɛnɔn cɛɛn, ɛn o Bali 'tɔ bɔdɩ 'sia 'nan: «Bali 'lewei vɩzan -dan 'bɔla -kaa 'va, ɛn \"nyian, Bali -ta 'palɛ 'yee minnun va.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","'Wɩ nɛn Zozi -a drɛ zɩɛ, e fuila \"man Zude 'lɛglɔn 'lee 'e \"srɔn 'lɛglɔn pɛɛnɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ɛn Zan -srunɔn 'kʋ 'wɩ zɩɛ -a 'sinan 'palɛ Zan lɛ. 'E -srunɔn \"fli laabʋ, ");
INSERT INTO yreNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ɛn e o 'pa 'sia Minsan -va. E 'nan -wlɛ 'nan: «'Ka laabʋ -yrɔ 'nan, -yɛɛ cɩ min nɛn kʋa 'man 'nan e -taa \"bɛ -a, -baa 'kʋ min pee man -pɛn tian?» ");
INSERT INTO yreNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Zɩ o 'bɔ Zozi man bɛ, ɛn o 'nan -yrɛ 'nan: «Min -batize drɛzan 'kʋ 'pa 'sia 'i 'va, 'nan -e 'kʋ laabʋ 'i 'lɔ 'nan, min nɛn kʋa 'man 'nan e -taa \"bɛ, -nyrɛn 'yia, -baa 'kʋ min pee -pɛn?» ");
INSERT INTO yreNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tʋ 'bɔ zɩɛ -a wlu bɛ, te Zozi man \"yaa 'nɔn \"kaga beli, ɛn e -cɛ -tɛnɔn \"kaga beli, ɛn e -yʋ -wlidɩ \"pin min \"kaga -sru, ɛn e yiɛ 'winɔn \"kaga yiɛ 'lɛ 'sʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Zozi \"e 'nan Zan -le 'pasianɔn zɩɛ -wlɛ 'nan: «'Wɩ nɛn -kaa -nan 'yɩ 'lee 'wɩ nɛn -kaa 'man bɛ, ka 'kʋ -a 'sinan 'pa Zan lɛ. 'Ka vɩ -yrɛ 'nan: Yiɛ 'winɔn yiɛ 'lɛ 'sʋ, \"tun \"bʋnɔn 'ta 'wʋ, -kogobe 'si -kogobe 'tɛnɔn man, \"trɔɛn \"winɔn \"trɔɛn 'lɛ 'sʋ, ɛn minnun nɛn o kaa bɛ o fuʋ, ɛn 'yalɛ -tɛnɔn Bali -le 'wɩ 'nɔnnɔn 'man. ");
INSERT INTO yreNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ɛn \"nyian bɛ, min nɛn e yi -tɛra an da ɛn -a -pɛ -sru 'ka tɔalɛ 'mlɔnmlɔn dɩɛ, Bali -le -fɛa a -a san man.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Zɩ Zan -le 'pasianɔn 'kʋ bɛ, ɛn Zozi Zan 'bɔ 'le 'wɩ vɩdɩ 'sia minnun lɛ. Yaa 'vɩ -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn ka -kʋ Zan -nanjɛnlɛ \"bui \"da? -Cɛan nɛn fulɔ cɩ -a nyɔɔnnan bɛ, -a -nanjɛnnan \"cɛɛ ka -kʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ɛn -mɛ \"le \"wɛan nɛn ka -kʋ \"mɛn? Min nɛn e sɔ fɛnyian 'wʋ 'e da bɛ, -a -nanjɛnnan \"cɛɛ ka -kʋ dɩ. Kɔɔ kaa -tɔa 'nan minnun nɛn o sɔ fɛnyian wo 'o da, te 'o 'ci 'sɔ wɩnun dra \"lala -a bɛ, o -nyɛanla mingɔnnɛn -le 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","'Ka 'ci nrɔn 'nan Bali 'lewei vɩzan nɛn -yee \"wɛan nɛn ka -kʋ. 'Wɩ 'kpa nɛn! 'Pian maan ve 'cɛɛ 'nan, Zan -dan \"mlian Bali 'lewei vɩzan da. ");
INSERT INTO yreNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kɔɔ e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan: ‹Bali \"e 'nan: An 'mɛn min -tʋ -tɔala 'i 'lɛ, -yɛɛ 'i 'lɛ si dra.› Min nɛn Bali -a 'vɩ bɛ Zan nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Maan ve 'cɛɛ 'nan, 'trɛda blamin -tʋ -dan 'ka 'mlian Zan da dɩ. 'Pian minnun nɛn o ya Bali -le mingɔnnɛn trɛdavɛ -a bɛ, o va min \"wɛnnɛn -dan \"mlian Zan da. ");
INSERT INTO yreNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Minnun pɛɛnɔn Zan wei 'man \"yi. Ɛn 'sukɔlɛ 'sinɔn \"nyian \"o wei 'man \"yi. O pɛɛnɔn zɩɛ, waa -tɔ 'o 'fli -a 'nan, Bali -le tin a 'nɔnnɔn, ɛn Zan o -batize drɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","'Pian Farizɛn 'nɔn 'lee 'fluba 'ci vɩnɔn 'ka 'wɩlɛ 'wɩ nɛn Bali -a \"vale 'e dra -wlɛ \"bɛ -a man dɩ. -Yee \"wɛan wa'a 'wɩlɛ \"man -e Zan 'e o -batize drɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ɛn Zozi \"e 'nan \"nyian 'nan: «-Tɩ man nɛn an -naagʋnɔn -kɔɔnman, ɛn -tɩ nɛn waa 'sia? ");
INSERT INTO yreNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","O ya \"le 'nan nannannun nɛn o ya srɔan -tɛnan -guada bɛ, -wee 'wɩ 'zʋ. -A -mienun -a ve 'o bɔɛnun lɛ 'nan: ‹Kʋ -pʋ -tɛ 'cɛɛ, 'pian ka'a 'tanlɛ dɩ. \"Drenun nɛn o min -wulo -man -taa \"bɛ kʋa -fɔ 'cɛɛ, 'pian ka'a 'wuɔlɛ dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Fɛ nɛn maan 'vɩ zɩɛ -yɛɛ cɩ 'nan zɩ min -batize drɛzan Zan -ta bɛ, e fɛ 'sɔn, ɛn ya'a -wɛn mlinlɛ dɩ, ɛn kaa 'vɩ \"man 'nan: ‹-Yʋ -wlidɩ \"a -a -sru.› ");
INSERT INTO yreNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","'Bɛ nɛn 'gʋɛ 'an 'bɔ Blamin -pɩ -ta, \"an \"fɛ -ble, \"an \"wɛn -mlian, ɛn ka 'vɩ 'an man 'nan: ‹Fɛ -blɩ -lagu nɛn 'maan, ɛn -wɛn -tɛzan nɛn 'maan, ɛn 'sukɔlɛ 'sinɔn 'lee 'wɩ 'wlidɩ \"drɛnɔn bee nɛn 'maan.› ");
INSERT INTO yreNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","'Pian minnun nɛn o drɛ Bali -le 'nɛnnun -a bɛ, -wɛɛ Bali -le 'wɩ 'tɔdɩ -ci -kɔɔnman.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farizɛn min -tʋ nɛn waa laabo Simɔn bɛ, e Zozi trʋ 'ba 'nan 'e 'kʋ fɛnun -blɩ 'e 'va. Zozi wla Farizɛn min zɩɛ -yee 'kuin ɛn e -nyran fɛnun -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lɩmɔn -tʋ nɛn e -kɔnnɛn -wɛɛman 'fla zɩɛ -a da bɛ, yaa 'man 'nan Zozi a fɛnun -blɩnan Farizɛn min zɩɛ -yee 'kuin. -A -nan nɛn e -ta -kɔlɛ -tʋ nɛn waa -ci 'bʋ \"le -pɔ -zʋ bɛ -a. E ya 'e fadɩ 'nyrɔn nɛn -a -koei \"a 'nɔnnɔn, ɛn waa wo min man bɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","E -tɔ Zozi 'cɛin \"srɔn, ɛn e -wuɔdɩ 'sia te -a yiɛ yi -sɛan Zozi 'cɛin -da. E -sɛan \"da te yaa bʋʋman 'e 'wulo \"jɛ \"a, te yaa cɛin 'bɔ lɛaman 'e man. \"Bɛ -sru ɛn e 'nyrɔn 'bɔ 'sɛn -a cɛin -da. ");
INSERT INTO yreNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Zɩ Farizɛn min Simɔn 'bɔ 'wɩ zɩɛ -a -nan 'yɩ bɛ, ɛn 'e 'ci \"nrɔndɩ 'sia 'nan: «\"Te min 'labɛ Bali 'lewei vɩzan nɛn bɛ, \"te lɩ nɛn e klɛ \"man 'labɛ yaa -tɔa 'nan 'wɩ 'wlidɩ \"drɛzan nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ɛn Zozi \"e 'nan -yrɛ 'nan: «Simɔn, an ya \"vale 'an 'wɩ 'tʋ ve 'yiɛ.» Ɛn Simɔn \"e 'nan: «Bali -le 'wɩ \"paazan, 'an \"trɔɛn \"a 'yiɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","-A -nan nɛn Zozi \"e 'nan -yrɛ 'nan: «Min -tʋ 'bɛ \"lala 'fɛ min \"fli \"lɛ. Min -tʋ \"e 'si -kpi yaa tʋ, ɛn min -tʋ \"e 'si -kpi fu. ");
INSERT INTO yreNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Zɩ fɛ -tʋ 'ka -wlɔ -e 'o -yee \"lala bɔla dɩɛ, ɛn e \"lala zɩɛ -a 'cɛ o \"flinɔn lɛ. Min \"fli zɩɛ o yei \"bɛ, -tɩɛ min nɛn e \"lala 'fɛ -wlɛ \"bɛ -a ye \"yi \"bʋʋ? 'I vɩ 'mɛn.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ɛn Simɔn \"e 'nan -yrɛ 'nan: «\"Mɛɛn 'ji \"le 'nan, min nɛn e \"lala \"kaga 'cɛ -yrɛ \"bɛ -a san nɛn.» Ɛn Zozi 'a 'vɩ Simɔn lɛ 'nan: «Yia -tɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","-A -nan nɛn Zozi 'e 'man lila lɩ zɩɛ -a da. E 'nan Simɔn lɛ 'nan: «Lɩ 'gʋɛ yia ye? An wla 'yie 'kuin, yi'an cɛin -man \"foe yi -nɔnlɛ dɩ. 'Pian \"yaan cɛin -man foe 'e yiɛ 'yi 'a, ɛn yaa man bʋʋ 'e 'wulo \"jɛ \"a. ");
INSERT INTO yreNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yi'a -atu -tɛlɛ 'an man dɩ. 'Pian -yee vɛ bɛ, zɩ an wla paan 'i 'va 'gʋɛ, ya'a tian 'flinlɛ 'an 'cɛin lɛadɩ -a 'e man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yi'a 'nyrɔn 'sɛnlɛ 'an 'win -ji dɩ. 'Pian \"e 'nyrɔn nɛn -a -koei \"a 'nɔnnɔn bɛ -a -sɛn 'an 'cɛin -da. ");
INSERT INTO yreNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","-Yee \"wɛan maan ve 'yiɛ 'nan, Bali -yee 'wɩ 'wlidɩ fui. Ɛn lɩ 'bɔ -a -ci kɔɔn 'an yɩdɩ \"yi -dan zɩɛ -a. Min nɛn Bali -yee 'wɩ 'wlidɩ \"wɛnnɛn fui bɛ, min zɩɛ ya'a yɩdɩ \"yi -dan ci kɔɔnman Bali lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ɛn Zozi \"e 'nan lɩ zɩɛ -yrɛ 'nan: «Bali 'yie 'wɩ 'wlidɩ fui.» ");
INSERT INTO yreNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Minnun nɛn o cɩra waa fɛnun -sru \"bɛ, 'o 'ci \"nrɔndɩ 'sia 'nan: «Min 'labɛ, -tɩ nɛn? Ɛn 'bɛ -kɔlaman blamin -le 'wɩ 'wlidɩ \"fuidɩ -a?» ");
INSERT INTO yreNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ɛn Zozi 'a 'vɩ \"nyian lɩ zɩɛ -yrɛ 'nan: «'Yie yi -tɛradɩ Bali da 'i 'si 'wɩ 'ji. 'I 'fʋ -trɔɔ.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","\"Bɛ -sru ɛn Zozi 'kʋ 'fla -dandan 'lee 'fla \"wɛnwɛnnɛnnun da, te e -ko Bali -le 'wɩ 'nɔnnɔn vɩdɩ -a -yee mingɔnnɛn -blɩdɩ da. -Wɛɛ cɩ 'o 'vale 'e -srunɔn 'fuda \"fli \"a. ");
INSERT INTO yreNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ɛn lɩmɔn -mienun nɛn e -yʋ -wlidɩ \"pin o -sru, ɛn e -cɛ 'si o man bɛ o -kʋla Zozi -sru \"nyian. Mari nɛn waa laabo Madala bɛ e ya o va. Zozi -yʋ -wlidɩ 'sɔravli \"pin lɩ zɩɛ -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ɛn lɩmɔn -tʋ nɛn waa laabo Zanɛn bɛ e ya \"nyian o va. Lɩ zɩɛ -a -sran 'tɔ nɛn Suza, -yɛɛ yiɛ -tɔa Erodi -le 'kɔn 'va. Ɛn lɩmɔn -tʋ waa laabo Sizanɛn bɛ e ya o va \"nyian, 'lee lɩmɔn -mienun nɛn o 'pa Zozi 'lee 'e -srunɔn 'va 'wee fɛnun -a bɛ -wɛɛ cɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yi -tʋ da bɛ minnun \"kaga \"ta Zozi 'va. O 'si 'fla 'tʋdʋ pɛɛnɔn da, ɛn o -ta. Ɛn Zozi 'wɩ \"paadɩ 'sia o ji -kɔnnɛn \"ji. Yaa 'vɩ -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Min -tʋ 'bɛ 'kʋ 'yee 'saa 'fɔlɛ. \"Yɛɛ 'saa 'wɛɛn bɛ, -a 'wlɛ plɔɛn 'sran -si man. Minnun taanla \"da, ɛn \"lomannun -ta, waa blɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","-A 'wlɛ -mie -sran puo da. \"Yɛɛ 'bɔ bɛ, ɛn e -ka, 'yi 'ka \"man \"dɩ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","-A 'wlɛ -mie -sran fɛnan nɛn -tɛin -taa \"bɔlɛ -a -nan. -Tɛin zɩɛ e 'tu, e blala 'saa man, ɛn yaa -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","-A 'wlɛ plɔɛn 'sran 'trɛ \"yi \"da. E 'bɔ, ɛn e -sɛn \"da. -A bɛ -tʋ 'wlɛ a \"man -yaa tʋ.» Ɛn Zozi -a 'le 'sran -wlɛ 'nan: «Min nɛn 'wɩ man \"trɔɛn \"cɩ -a -wulo -man bɛ, -a san 'e man!» ");
INSERT INTO yreNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ɛn Zozi -srunɔn -a laabʋ Zozi 'lɔ 'nan: «-Kɔnnɛn \"nɛn yia -fɔ zɩɛ, -a -ci nɛn 'nɔn?» ");
INSERT INTO yreNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Kaa 'gʋɛ, 'ka lɛ nɛn Bali 'yee 'wɩ yɔɔdɩ nɛn 'e min \"paala 'a bɛ -a -ci 'si. 'Pian minnun nɛn o 'ka 'an -srunɔn 'a dɩɛ, \"o 'wɩ pɛɛnɔn maan -kɔnnɛn \"ji. Bali -a drɛ zɩɛ 'nan -e 'o fɛ -nanjɛn, te wa'a -kɔnnɛn 'ye dɩ, ɛn -e 'o 'wɩ man, te wa'a -ci maan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ɛn Zozi \"e -wlɛ 'nan: «-Kɔnnɛn \"nɛn maan -fɔ bɛ, -a -ci nɛn 'gʋ: 'Saa 'wlɛ bɛ -yɛɛ cɩ \"le Bali -le 'wɩ 'nɔnnɔn 'le 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Min -mienun -le vɛ bɛ, 'wɩ nɛn e 'bɔ 'saa 'wlɛ nɛn e -sran -si man bɛ -a man bɛ, -yɛɛ bɔa \"nyian -wee \"man. O Bali -le 'wɩ 'nɔnnɔn maan, 'nun tɔɔn -e Satan 'e 'ta -a 'si o ji. Kɔɔ e 'ka \"vale 'o 'ta wʋla \"da -e 'o 'si 'wɩ 'ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Min -mienun -le vɛ bɛ, 'wɩ nɛn e 'bɔ 'saa 'wlɛ nɛn e -sran puo da bɛ -a man bɛ, -yɛɛ bɔa \"nyian -wee \"man. O Bali -le 'wɩ 'nɔnnɔn maan, 'nun tɔɔn o \"we \"man ci \"nrandɩ -a. 'Pian wa'a tʋe -e -a \"sɛin 'e 'kʋ -kɔɔbli dɩ. O yi -tɛala \"da tʋ \"wɛnnɛn 'a, 'pian -te 'wɩ 'tɔndɔn bɔdɩ 'sia o man bɛ, tɔɔn -e 'o 'si Bali -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Min -mienun -le vɛ bɛ, 'wɩ nɛn e 'bɔ 'saa 'wlɛ nɛn e -sran fɛnan nɛn tɛin -taa \"bɔlɛ bɛ -a -nan bɛ -yɛɛ bɔa \"nyian -wee \"man. O Bali -le 'wɩ 'nɔnnɔn maan, o \"we \"man. Minnun zɩɛ 'o 'ci \"nrɔndɩ \"siala 'trɛda fɛnun \"kaga \"da. Fɛ yɩdɩ o see \"paaman. O ya \"vale fɛ pɛɛnɔn 'e drɛ -wee vɛ -a. 'Wɩ zɩɛ -yɛɛ -si -tɔa Bali wei lɔ, -e 'e vɩlɛ 'e 'nyranman 'pa o man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Min -mienun -le vɛ bɛ, 'wɩ nɛn e 'bɔ 'saa 'wlɛ nɛn e -sran 'trɛ \"yi \"da bɛ -a man bɛ, -yɛɛ bɔa \"nyian -wee \"man. O Bali -le 'wɩ 'nɔnnɔn maan 'o 'ci 'fɩdaa 'a. Waa paala 'o 'ji te o 'ta wʋla \"da -e -a \"nɛn 'e bɔla.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","\"Bɛ -sru ɛn Zozi \"e 'nan -wlɛ \"nyian 'nan: «Min 'ka -kannɛn 'fɔa \"nɛn 'vaa -e 'e yɔɔ fɛ -tʋ -a dɩ, -te 'bɛ \"cɛɛ dɩɛ, -e 'e yɔɔ nyinnan \"davɛ wlu dɩ. 'Pian yaa -tɔala fɛnan 'wein da, 'nan -e minnun nɛn o -wlamlan 'yee 'kuin bɛ, 'o -san yɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Maan -cin -tɔa 'ka 'ji 'nan, fɛ -tʋ 'ka 'fo 'e yɔɔdɩ -trilii, -e 'e vɩlɛ 'e bɔla 'ji dɩ. Ɛn 'wɩ yɔɔdɩ -tʋ \"ka -e 'o vɩlɛ 'o man fɛnan 'wein da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","'Wɩ nɛn maan ve 'cɛɛ bɛ, 'ka \"trɔɛn \"tɔ -yrɛ 'kpa tɩglɩ! Kɔɔ min nɛn yaa 'pla 'e 'ji bɛ, -a san lɛ nɛn maan \"paa \"da \"nyian. 'Pian min nɛn ya'a 'palɛa 'e 'ji dɩɛ, -a \"tiɛnnɛn nɛn -yrɔ \"bɛ, waa \"sia -yrɔ.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ɛn Zozi \"bʋ 'lee Zozi \"bʋɩnun -ta. 'Pian minnun \"kaga \"le \"wɛan wa'a -kɔlalɛ -plidɩ -a Zozi \"srɔn \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tɔɔn ɛn minnun -a 'vɩ Zozi lɛ 'nan: «'I \"bʋ 'lee 'i \"bʋɩnun a bei, o ya \"vale 'wei 'man ye.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Minnun nɛn, o Bali wei maan, te o 'ta wʋla \"da \"bɛ, -wɛɛ cɩ 'an \"bʋ \"a, ɛn -wɛɛ cɩ 'an \"bʋɩnun -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yi -tʋ da bɛ, Zozi 'fɔ -klʋ -tʋ -ji 'o 'vale 'e -srunɔn 'a, ɛn e 'nan -wlɛ 'nan: «-Kaa kʋ 'yi -sru.» Ɛn o -si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","\"Wɛɛ -kɔn -kʋnan 'yi yiɛ da bɛ, ɛn yi -fɔla Zozi da. Tɔɔn fulɔ 'plɛblɛ 'tʋ \"fɛɛndɩ 'sia 'yi zɩɛ -a yiɛ da, ɛn 'yi 'sɛndɩ 'sia 'klʋ -ji. 'Wɩ nɛn e 'bɔ o man bɛ, e ya 'plɛblɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","-A -nan nɛn -a -srunɔn -pli \"man, ɛn waa fuʋdɩ 'sia. Waa 'vɩ -yrɛ 'nan: «'Kʋ 'san! 'Kʋ 'san! 'I 'fuʋ! 'Kʋ 'nan cɛɛn 'nyandɩ man.» Ɛn Zozi wluan, e paan fulɔ 'lee 'yi da 'plɛblɛ. 'Nun tɔɔn fulɔ \"fɛɛndɩ -ta \"tra, ɛn 'yi 'ta \"tra. Ɛn fɛnan -tɔ flɩɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","\"Bɛ -sru ɛn Zozi 'a laabʋ 'e -srunɔn 'lɔ 'nan: «Ka'a yi tɛala 'an da dʋʋ?» 'Wɩ nɛn Zozi \"sia -a drɛnan bɛ, e o cɛɛn nyɛn -a, ɛn e o 'lɛbo \"fɔ. Waa laabʋdɩ 'sia 'o cin lɔ 'nan: «-Mɛ \"sʋ -man min 'bɛ cɩ zɩɛ? Yaa 'vɩ fulɔ 'lee 'yi lɛ 'nan, 'o 'ta -tɔ, ɛn waa wei 'man \"yi.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Zozi 'lee 'e -srunɔn Galile 'yi cɛɛn 'ji, ɛn o 'bɔla Geraze 'nɔn 'le 'lɛglɔn 'ji. Geraze 'lɛglɔn 'lee Galile 'lɛglɔn a 'o cin yra 'sɛzɛ, 'pian 'yi 'bɛ o \"cɛan 'e cin man. ");
INSERT INTO yreNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Zɩ Zozi 'si -klʋ -ji, e sɔɔnla \"tra \"bɛ, ɛn 'fla zɩɛ -a da min -tʋ -ta -a 'lɛ. Min zɩɛ -yʋ -wlidɩ \"kaga \"a -a -sru. -A -nan 'mɔn 'kpa te ya'a sɔ wo 'e man dɩ, ɛn ya'a 'nyian 'kuin dɩ, 'pian e nyian min -yrɛ da. ");
INSERT INTO yreNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Zɩ e Zozi 'yɩ bɛ, ɛn e paan. E \"po sɔɔn Zozi 'wlu, ɛn yaa 'vɩ -yrɛ wei 'plɛblɛ 'ji 'nan: «Zozi, 'yie -mɛ \"wɩ nɛn 'an man? Bali nɛn min ta lou \"bɛ -a -pɩ nɛn yia, maan -tɔa zɩ. 'I yra 'si, te 'i 'tɛ 'pa 'an da dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Zozi a -a vɩnan -yʋ -wlidɩ \"lɛ 'nan, 'e 'si -a -sru. -Yee \"wɛan nɛn e 'wɩ zɩɛ -a 'vɩ. Min zɩɛ -yʋ -wlidɩnun a -a -sru -a -nan 'mɔn. Minnun -a -pɛ -yrɩman -bulalɛ baa -a, -e 'o -bulalɛ -fɔ -a cɛin -man. 'Pian e baa zɩɛ -a \"cɛɛnman 'e man, -e -yʋ -wlidɩnun 'o 'kʋ -a \"bui \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Zozi -a laabʋ -yrɔ 'nan: «'I 'tɔ nɛn 'nɔn?» Ɛn e 'nan Zozi lɛ 'nan: «'An 'tɔ nɛn -kuli 'pa 'tʋ.» -Yʋ -wlidɩ \"kaga \"nɛn -a -sru, -yee \"wɛan nɛn e 'wɩ zɩɛ -a 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","-A -nan nɛn -yʋnun 'bɔ toba -fɔdɩ 'sia Zozi lɛ 'nan: «'I yra 'si, te 'i 'tɔ 'kʋ man 'nan 'kʋ 'kʋ -klu nɛn -a 'leda \"ka \"dɩɛ, -a ji dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tʋ zɩɛ -a wlu bɛ, te 'sru 'pa 'tʋ a 'e 'blɩnan o \"srɔn \"pɔn -tʋ da. Ɛn -yʋ -wlidɩnun -a 'vɩ Zozi lɛ 'nan: «'I yra 'si, 'i 'kʋ 'pa 'sia 'srunun nɛn 'labɛ o va -e 'kʋ 'fɔ o -sru.» -A -nan nɛn Zozi 'si -nɔn -wlɛ, ɛn o -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","-Yʋ -wlidɩnun 'si min zɩɛ -a -sru, ɛn o -fɔ 'srunun -sru. 'Srunun 'bɔ flan 'sia pɔn 'sɛan man zia, ɛn o pɛɛnɔn 'sɛn 'yi 'va, te 'yi o -tɛɛman. ");
INSERT INTO yreNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Zɩ 'sru -sru \"pinnɔn 'wɩ zɩɛ -a -nan 'yɩ bɛ, o -tɛ -ji flan -a. O -kʋ -a -nan 'sinan 'palɛ 'fla 'lee fei -paannun da. ");
INSERT INTO yreNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","-A -nan nɛn minnun -kʋ 'wɩ nɛn e drɛ bɛ -a -nan yɩlɛ. O 'bɔ Zozi man, ɛn o min nɛn -yʋnun 'si -a -sru \"bɛ, -a 'yɩ. Sɔ a \"da 'e wʋdɩ, ɛn e ya 'e -nyrandɩ Zozi 'cɛin -man, te -a ta 'si. Zɩ o 'wɩ zɩɛ -a -nan 'yɩ bɛ, \"klan -sɛn o ji. ");
INSERT INTO yreNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Minnun nɛn 'wɩ zɩɛ e drɛ o yiɛ man bɛ, zɩ e drɛ 'lɔɔ ɛn -yʋ -wlidɩ 'si min zɩɛ -a -sru \"bɛ, waa -nan 'sinan 'pa -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","-A -nan nɛn Geraze 'nɔn \"kaga toba -fɔdɩ 'sia Zozi lɛ 'nan, 'e 'si 'wee 'lɛglɔn 'ji. Kɔɔ 'wɩ nɛn Zozi -a drɛ bɛ \"klan -dan -sɛn o ji. Ɛn Zozi 'fɔ -klʋ -ji, 'nan -e 'e 'li 'e da. ");
INSERT INTO yreNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Min nɛn Zozi -a beli bɛ e 'nan Zozi lɛ 'nan: «'I yra 'si, 'kʋɛ 'ko 'yia!» 'Pian Zozi \"e -yrɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«-Cɛjɛ! 'I 'kʋ 'yie \"kɔnnɛn, -e 'wɩ pɛɛnɔn nɛn Bali -a drɛ 'yiɛ bɛ, 'i -nan 'sinan 'pa!» E -kʋ, ɛn 'wɩ pɛɛnɔn nɛn Zozi -a drɛ -yrɛ \"bɛ, yaa 'sinan 'pa 'fla yei fɛ pɛɛnɔn 'nan. ");
INSERT INTO yreNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Zɩ Zozi 'li 'e da Galile 'lɛglɔn 'ji bɛ, e 'bɔla, te min \"kaga \"a -a -pɛnnan. O -ta -a 'silɛ -sia. ");
INSERT INTO yreNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","-A -nan nɛn Zuif 'nɔn 'le cin yɩ 'kɔn 'tazan -tʋ nɛn, waa laabo Zairus bɛ, e -ta Zozi 'va, e \"po sɔɔn \"wlu. E Zozi trʋ 'badɩ 'sia 'nan 'o 'kʋ -a 'yee 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kɔɔ -yee 'nɛn 'tʋwli \"a -kanan. 'Nɛn zɩɛ lɩmɔn nɛn, ɛn -a lɛ a -fuda 'fiili. Ɛn Zozi sɔɔnla -a -sru, te minnun -a -mɛan \"man -pɛ pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Minnun zɩɛ o yei \"bɛ, lɩ -tʋ a -nan, -cɛ a \"man. -Cɛ zɩɛ e nyɛn -sɛanla \"man, -a -nan lɛ -fuda \"fli 'bɔ. E -dɔdrɔ drɛ \"kaga \"bʋʋ \"le \"wɛan, -yee \"lala pɛɛnɔn 'nyan -yrɔ. 'Pian -dɔdrɔ -tʋ 'ka -kɔlalɛ -yee -cɛ zɩɛ -a 'yile yɩdɩ -a \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Lɩ zɩɛ e pli Zozi man 'e koda zia, ɛn e klɛ -yee sɔ 'lɛbo \"man. 'Nun tɔɔn, nyɛn -srandɩ \"man 'le 'tɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ɛn Zozi 'a laabʋ 'nan: «-Tɩɛ klɛ 'an man?» Zɩ min -tʋ 'ka 'wɩlɛ dɩɛ, ɛn Piɛri \"e 'nan Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan, min \"kaga 'i 'si -fɔ, ɛn minnun 'i -mɛan \"man -pɛ pɛɛnɔn da.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","'Pian Zozi \"e 'nan: «'Wɩ 'kpa, min -tʋ klɛ 'an man. Maan -tɔa 'nan 'plɛblɛ 'tʋ 'bɔla 'an 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Zɩ lɩ zɩɛ, yaa -tɔ 'nan, Zozi -a -kɔnnɛn 'yɩ bɛ, e nyɔɔndɩ 'sia, ɛn e -ta. E \"po sɔɔn Zozi 'wlu. 'Wɩ nɛn e drɛ 'lɔɔ, ɛn 'e klɛ Zozi man bɛ, yaa 'vɩ minnun pɛɛnɔn yiɛ man. Ɛn e 'yee -cɛ -nyandɩ wɩ 'vɩ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","-A -nan nɛn Zozi \"e -yrɛ 'nan: «An 'lu, i yi -tɛra 'an da, -yee \"wɛan nɛn i beli. 'I 'fʋ -trɔɔ!» ");
INSERT INTO yreNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Zozi 'fʋ 'wɩ zɩɛ -a vɩnan, ɛn cin yɩ 'kɔn 'tazan Zairus -le \"kɔnnɛn 'pasiazan -tʋ -ta, ɛn e 'nan Zairus lɛ 'nan: «'I 'lu 'ka 'va. Te 'i Bali -le 'wɩ \"paazan \"koe \"nyan \"nyian dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Zɩ Zozi 'wɩ zɩɛ -a 'man bɛ, ɛn e 'nan Zairus lɛ 'nan: «Te 'i \"klan dɩ. 'I yi -tɛra 'an da, -e 'e 'beli.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Zɩ o 'bɔla \"kɔnnɛn \"bɛ, Zozi 'ka 'wɩlɛ \"man -e min -tʋ 'e -wla -a -sru 'kuin dɩ. 'Pian yaa -si -nɔn Piɛri 'lee Zan 'lee Zaji 'lee 'nɛn \"tɩ 'lee 'nɛn \"bʋ \"lɛ 'nan 'o -wla. ");
INSERT INTO yreNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Minnun nɛn 'kuin bɛ, o pɛɛnɔn a -wuɔnan, te o -pɛ a 'o 'win -ji. Ɛn Zozi \"e 'nan -wlɛ 'nan: «Te 'ka 'wuɔ dɩ! 'Nɛn 'gʋɛ ya'a 'kalɛ dɩ, 'pian e ya yi -tɛnan.» ");
INSERT INTO yreNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Minnun -a sɛɛ wʋdɩ 'sia, kɔɔ waa -tɔa 'nan e -ka. ");
INSERT INTO yreNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","'Pian Zozi 'nɛn 'bɔ 'kun 'e 'pɛ -man, ɛn yaa 'vɩ wei 'plɛblɛ 'ji 'nan: «'Nɛn, 'i 'wluan lou!» ");
INSERT INTO yreNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","'Nun tɔɔn 'nɛn zɩɛ e fuʋ, ɛn e wluan lou. Zozi \"e 'nan, 'o fɛ -nɔn -yrɛ 'e -blɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","'Wɩ nɛn Zozi -a drɛ bɛ, e 'nɛn \"tɩ 'lee -a \"bʋ 'kan. Ɛn Zozi \"e 'nan -wlɛ 'nan: «Te 'o 'wɩ zɩɛ -a -nan sɛɛ wʋ min -tʋ lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Zozi 'e -srunɔn 'fuda \"fli \"bɛ o cin 'yɩ. E -kɔladɩ 'lee 'plɛblɛ -nɔn -wlɛ 'nan -e 'o -yʋ -wlidɩnun -pin minnun -sru, -e 'o -cɛ 'si minnun man. ");
INSERT INTO yreNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","E o 'pa 'sia 'nan 'o 'kʋ -a vɩ minnun lɛ 'nan Bali -le mingɔnnɛn -blɩdɩ 'bɔ, te o -cɛ \"sia minnun man. ");
INSERT INTO yreNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Zozi \"e 'nan -wlɛ 'nan: «Te 'ka fɛ -tʋ 'sia dɩ! -Yɛɛ cɩ \"le \"tonyrin -le 'wɩ 'zʋ, ɛn \"le 'pada 'le 'wɩ 'zʋ, ɛn \"le -blɩfɛ -le 'wɩ 'zʋ, ɛn \"le \"lala -le 'wɩ 'zʋ. -A pɛɛnɔn zɩɛ, te 'ka -tʋ 'sia \"fo \"dɩ! Ɛn te 'ka 'tralɛ 'sia \"fli \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","'Kɔn nɛn 'ka wla 'ji 'nan o 'ka 'sia tɩglɩ bɛ, -a -ji nɛn 'ka 'fʋ, -e 'ka 'kʋdɩ 'e 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","-Te ka 'bɔla 'fla 'tʋ da, ɛn -a -nannɔn 'ka 'ka 'silɛa dɩɛ, ɛn wa'a \"trɔɛn \"tɔlɛ 'cɛɛ dɩɛ, 'ka 'si 'fla zɩɛ -a da. 'Pian \"cɛɛ 'si 'fla 'bɔ da bɛ, 'ka 'cɛin -man fuɔn -koei \"trɔa o da, -a -ci -kɔɔndɩ nɛn 'nan 'ka 'pɛ 'si -wee 'wɩ 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Zozi -srunɔn 'fuda \"fli zɩɛ, o -kʋ. O ciɩ 'flanun da, te o Bali -le 'wɩ 'nɔnnɔn ve minnun lɛ, te o -cɛ \"sia minnun man fɛ pɛɛnɔn 'nan. ");
INSERT INTO yreNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erodi nɛn e Galile 'lɛglɔn \"paala bɛ, 'wɩ pɛɛnɔn nɛn Zozi cɩ -a drɛnan bɛ yaa 'man. Ɛn zɩ kɔ 'e ci \"nrɔn bɛ, ya'a tɔa dɩ. Kɔɔ min -mienun -a ve 'nan: «Min -batize drɛzan Zan nɛn e -ka bɛ, -yɛɛ fuʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ɛn min plɔɛnnun -a ve 'nan: «Bali 'lewei vɩzan Eli nɛn 'li bɛ, -yɛɛ 'ta 'e 'fli -kɔɔnlɛ.» Ɛn min -mienun \"o 'vɩ 'nan: «Bali 'lewei vɩnɔn nɛn 'li bɛ, -a -tʋ 'bɛ fuʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","'Pian Erodi \"e 'vɩ 'nan: «'An 'bɔ 'gʋɛ, 'mɛn minnun 'bɛ Zan -wulo cɛɛn. Ɛn min nɛn an -yee 'wɩ maan 'gʋɛ, -tɩ 'bɛ \"mɛn 'bɛ 'a?» -Yee \"wɛan Erodi -a man -wɛɛdɩ 'sia 'nan 'e Zozi ye. ");
INSERT INTO yreNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Zozi 'le 'pasianɔn 'fuda \"fli \"bɛ o 'li 'o da. Ɛn 'wɩ pɛɛnɔn nɛn, waa drɛ bɛ, waa 'sinan 'pa Zozi lɛ. \"Bɛ -sru ɛn Zozi 'kʋ o 'saza 'a 'fla 'tʋ nɛn waa laabo Bɛzaida bɛ -a \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Min \"kaga \"o -kʋnan 'yɩ, ɛn o -kʋla Zozi -sru. Zozi 'ka o lilɛ 'o da dɩ. E Bali -le mingɔnnɛn -blɩdɩ 'wɩ 'vɩ -wlɛ, ɛn minnun nɛn -cɛ cɩ o man bɛ, e -cɛ 'si o man. ");
INSERT INTO yreNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zɩ funninmlan \"ta \"paala bɛ, ɛn Zozi -srunɔn pli Zozi man. O 'nan -yrɛ 'nan: «'I vɩ minnun lɛ 'nan, 'o 'kʋ fei -paannun 'lee 'flanun nɛn -kogo 'gʋɛ -a da, -e 'o -blɩfɛ 'lee nyinnan \"nan \"yɩ. Kɔɔ fɛnan nɛn -kaa cɩ 'gʋɛ, min 'ka 'nyɛanla 'nan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ɛn Zozi \"e -wlɛ 'nan: «'Ka 'bɔ, 'ka 'blɩfɛ -nɔn -wlɛ!» Ɛn o 'nan -yrɛ 'nan: «'Kpɔun 'soolu 'lee pɔ \"fli \"nɛn 'kʋ 'lɔ \"cɛ. I ya \"vale 'nan, 'kʋ 'kʋ minnun \"kaga 'labɛ o -blɩfɛ 'lɔ?» ");
INSERT INTO yreNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Minnun nɛn -nan bɛ, -klɔnmɔn a 'o va -kpi 'soolu. Ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «'Ka o -nyran 'e cin da -fuba 'souzou.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Waa drɛla \"da, ɛn o pɛɛnɔn 'nyran. ");
INSERT INTO yreNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Zozi 'kpɔun 'soolu 'lee pɔ \"fli zɩɛ -a 'si, 'e yra -tɔ laji lou, ɛn e Bali muo \"fɔ. E 'kpɔunnun \"nɛn jɛɛn, ɛn yaa -nɔn 'e -srunɔn lɛ 'nan 'o -pli \"minnun zɩɛ o man. ");
INSERT INTO yreNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","O pɛɛnɔn -a blɩ, o 'kan. Ɛn -a -mie nɛn e -fʋ bɛ waa -tɛ 'e cin da, e saannɛn 'fa -fuda \"fli. ");
INSERT INTO yreNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yi -tʋ da Zozi a Bali trʋ 'banan 'e 'saza, te -a -srunɔn a -a \"srɔn. Ɛn yaa laabʋ -wlɔ 'nan: «Minnun \"o 'nan, -tɩ nɛn 'maan?» ");
INSERT INTO yreNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","O -yrɛ 'nan: «Min plɔɛn \"o 'vɩ 'nan, min -batize drɛzan Zan nɛn 'yia. Min -mienun \"o 'vɩ 'nan, Bali 'lewei vɩzan Eli nɛn 'li bɛ, -nyrɛn 'yia. Ɛn o -mienun \"o 'vɩ 'nan, Bali 'lewei vɩnɔn nɛn 'li bɛ, -a -tʋ 'bɛ fuʋ, -nyrɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ɛn Zozi -a laabʋ -wlɔ \"nyian 'nan: «Kaa \"nun, \"ka 'vɩ 'nan, -tɩ nɛn 'maan?» Ɛn Piɛri \"e -yrɛ 'nan: «I ya Crizi nɛn, Bali -a 'pa 'sia -e 'e minnun 'si 'wɩ 'ji bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ɛn Zozi 'wɩ 'pla -wlɛ 'klagla 'nan, te 'o 'wɩ zɩɛ -a vɩ min -tʋ lɛ 'mlɔnmlɔn dɩ! ");
INSERT INTO yreNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Zozi 'a 'pla \"da \"nyian -wlɛ 'nan: «E ya 'e vɩdɩ 'nan, Blamin -pɩ 'e yra ye \"kaga. Ɛn \"nyian bɛ, min cejenun 'lee Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn -a dra 'o 'pɛla koda, ɛn o Blamin -pɩ -tɛa. -A yi yaagazan da -e 'e 'wluan -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","\"Bɛ -sru ɛn Zozi \"e 'nan o pɛɛnɔn lɛ 'nan: «Min nɛn e ya \"vale 'e dra 'an -sruzan 'a bɛ, 'e 'wɩ tʋ pɛɛnɔn man yra yɩdɩ man, ɛn 'e 'wɩ -kadɩ man yiba \"plan da -e 'e -sɔɔnla 'an -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kɔɔ min nɛn e cɩ 'e 'ladɩ 'yee 'trɛda da bɛ, -yee 'trɛda -taa 'silɛ -yrɔ. 'Pian min nɛn 'e 'pɛ 'si 'yee 'trɛda da \"fo, ɛn yaa -nɔn 'mɛn bɛ, -a san 'bɛ 'belidɩ nɛn ya'a 'nyaan dɩɛ -a ye. ");
INSERT INTO yreNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","-Te min 'trɛda fɛ pɛɛnɔn 'yɩ, ɛn 'belidɩ 'si -yrɔ \"bɛ, -a -ci nɛn 'nɔn? -A -ci \"ka \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Min nɛn, 'yra -a -tɛa -a vɩdɩ -a 'nan 'e ya 'an -sruzan 'a bɛ, ɛn -te 'bɛ \"cɛɛ dɩ, 'mɛn 'wɩ vɩdɩ min pee lɛ yra -a -tɛa \"bɛ, Blamin -pɩ -yee vɛ yra -tɛa \"nyian tʋ nɛn e -taa \"man \"bɛ -a man. E -taa 'e 'bɔ 'le 'tɛ 'san 'lee 'e \"tɩ \"le 'tɛ 'san 'lee 'e \"tɩ \"le 'pasianɔn 'le 'tɛ 'san da. ");
INSERT INTO yreNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min -mienun a fɛ 'gʋɛ -a -nan bɛ, wa'a 'kaa 'vaa -e 'o -tɔ 'nan Bali mingɔnnɛn -blɩdɩ 'sia dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Zozi 'wɩ zɩɛ -a 'vɩ, -a -nan yi 'sɔra \"bɛ -sru, ɛn e Piɛri 'lee Zan 'lee Zaji 'sia, ɛn o -kʋ Bali trʋ 'balɛ pɔn -tʋ da. ");
INSERT INTO yreNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","E ya Bali trʋ 'banan, ɛn -a yra liladɩ 'sia, ɛn -yee sɔ drɛ 'fuvu 'yrɩyrɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","-A -nan nɛn 'o 'vale min \"fli \"a o -sɛɛ \"wʋdɩ 'sia. Min \"fli zɩɛ Moizi 'lee Eli nɛn waa. ");
INSERT INTO yreNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bali -le 'tɛ 'san o si -fɔ, ɛn 'wɩ nɛn e \"ta -daa \"drɛlɛ Zozi lɛ Zeruzalɛm bɛ, waa -nan wɩ vɩdɩ 'sia -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tʋ zɩɛ -a wlu bɛ, te yi -fɔla Piɛri 'lee min \"fli \"nɛn o -kʋ waa bɛ, o da \"fo. 'Pian o fuʋ ɛn o Zozi 'yɩ Bali -le 'tɛ 'san wlu. Ɛn o min \"fli 'yɩ \"nyian 'o 'tɔdɩ -a \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Minnun zɩɛ \"wɛɛ 'si Zozi \"srɔn \"bɛ, ɛn Piɛri \"e 'nan Zozi lɛ 'nan: «'An 'san, e drɛ 'wɩ \"yi \"a ɛn -kaa ta 'gʋ. Kʋ segle pannɛn yaaga -tɔa. -A -tʋ a 'yie vɛ -a, -a -tʋ a Moizi -le vɛ -a, ɛn -a -tʋ a Eli -le vɛ -a.» 'Wɩ nɛn Piɛri -a 'vɩ bɛ, yaa 'vɩ 'e lei -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Zɩ Piɛri a 'wɩ zɩɛ -a vɩnan bɛ, ɛn \"lolu -koei \"trɔa o da. \"Lolu -koei \"a -trɔanan Zozi -srunɔn da \"fo. -A -nan nɛn nyɛn o cɛɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","'Nun tɔɔn wei -tʋ wɩɩ \"lolu -koei 'bɔ 'va. E 'nan: «'An 'pɩ nɛn, maan 'si \"va \"bɛ, -nyrɛn \"bɛ. 'Ka \"trɔɛn \"tɔ -a wei lɛ!» ");
INSERT INTO yreNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Zɩ wei zɩɛ e wɩɩ bɛ, ɛn Zozi 'fʋ 'e 'tʋwli. 'Wɩ nɛn Zozi -srunɔn 'a -nan 'yɩ bɛ, wa'a -nan sɛɛ wʋlɛ min -tʋ lɛ \"fo 'vaa ɛn Zozi 'kʋ laji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Zɩ tʋ cɛɛn bɛ, ɛn o pɔn sɔɔn \"ji. Min \"kaga \"ta Zozi 'silɛ -sia. ");
INSERT INTO yreNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Minnun 'bɔ zɩɛ o yei \"bɛ, min -tʋ -paandɩ 'sia. Yaa 'vɩ 'nan: «Bali -le 'wɩ \"paazan, mɛin trʋ \"baa, 'i 'mɛn 'nɛn 'gʋɛ -a -nanjɛn! -Yɛɛ cɩ 'mɛn 'nɛn 'tʋwli \"a. ");
INSERT INTO yreNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","-Yʋ -wlidɩ \"tʋ -taa \"da, 'nun tɔɔn -e 'e -paandɩ 'sia. -Yʋ -wlidɩ 'bɔ -a \"cɛan \"da, te yaa 'le -pɔɛ bɔa. \"Yɛɛ vɩnan 'e 'si \"da \"bɛ, te e 'tɛ 'pa \"da \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mɛin -srunɔn trʋ 'ba 'nan, 'o 'yʋ -wlidɩ zɩɛ -a -pin -a -sru. 'Pian wa'a -kɔlalɛ -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ɛn Zozi \"e 'nan: «-Naagʋnɔn, 'cee yi -tɛradɩ Bali da \"ka \"dɩ. 'Ka 'wɩ 'wlidɩ \"dra. Tʋ wɛa nɛn \"nyian maan dra 'ka 'va? 'An \"koe -nyaan 'ka man 'e \"tun. 'I 'ta 'yie 'nɛn 'a 'gʋ!» ");
INSERT INTO yreNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Zɩ 'nɛn 'bɔ \"ɛ -pli Zozi man bɛ, ɛn -yʋ -wlidɩ -a -tria \"tra. Yaa cɛɛn \"da. 'Pian Zozi 'e yra 'tɔn 'tɔ -yʋ -wlidɩ \"da, ɛn e 'nan -yrɛ 'nan: «'I 'si 'nɛn 'gʋɛ -a -sru.» Zɩ Zozi -a beli bɛ, ɛn e 'nan -a \"tɩ \"lɛ 'nan: «'Yie 'nɛn nɛn 'gʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bali -le -dan 'lee -yee 'plɛblɛ min pɛɛnɔn 'kan. 'Wɩ nɛn Zozi -a drɛ bɛ, min pɛɛnɔn 'plo 'fʋ 'e 'fɔdɩ. -A -nan nɛn Zozi 'a 'vɩ 'e -srunɔn lɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«'Ka \"trɔɛn \"tɔ 'wɩ 'gʋɛ -yrɛ 'kpa tɩglɩ! Minnun \"ta -daa Blamin -pɩ -nɔnlɛ minnun lɛ -e 'o -tɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","-A -srunɔn 'ka 'wɩ zɩɛ -a -ci manlɛ dɩ. -A -ci a 'e yɔɔdɩ -wlɔ, 'dʋ -e 'o vɩlɛ 'o -ci man dɩ. 'Pian -a -ci laabʋdɩ \"klan o -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","\"Bɛ -sru -sa -tʋ -tria Zozi -srunɔn yei. -Sa zɩɛ -nyrɛn 'nan, -tɩɛ cɩ o yei Zozi -sruzan -dan a? ");
INSERT INTO yreNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Zozi 'a -kɔnnɛn 'yɩ -wlɔ. -A -nan nɛn e 'nɛn \"wɛnnɛn 'tʋ 'si, yaa -tɔ 'e \"srɔn, ");
INSERT INTO yreNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ɛn e 'nan -wlɛ 'nan: «Min nɛn e 'nɛn \"wɛnnɛn 'gʋ -a 'kun tɩglɩ 'mɛn \"wɛan bɛ, te 'an 'bɔ nɛn yaan 'kun tɩglɩ. Ɛn min nɛn yaan 'kun tɩglɩ bɛ, te min nɛn yaan 'pa 'sia 'trɛda bɛ, -a 'bɔ nɛn yaa 'kun tɩglɩ. Maan ve 'cɛɛ 'nan, 'an -sruzan nɛn 'e 'fli drɛ 'nɛn \"wɛnnɛn 'a bɛ, -a san 'bɛ cɩ -dan.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ɛn Zan \"e 'nan Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan, kʋ min -tʋ 'yɩ, te e -yʋ -wlidɩ -pian \"minnun -sru 'i 'tɔ da. Ɛn kʋa 'vɩ -yrɛ 'nan, te 'e drɛ dɩ, kɔɔ ya'a 'ta 'wʋla 'i -sru \"le 'kʋe 'wɩ 'zʋ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ɛn Zozi \"e 'nan -yrɛ 'nan: «Te 'ka 'wɩ zɩɛ -a drɛ dɩ! Kɔɔ min nɛn, -a pei 'ka 'e 'padɩ 'ka man dɩɛ, te e ya 'ka 'va.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tʋ nɛn Bali Zozi \"sia 'trɛ 'gʋɛ -a da -e 'e 'kʋ -a laji bɛ, e 'bɔ 'kogo. -A -nan nɛn Zozi 'nyinnan 'e 'fli da, ɛn e Zeruzalɛm si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","E minnun 'pa 'sia 'e 'lɛ. Minnun zɩɛ o -kʋ, ɛn o 'bɔla Samari 'nɔn fla. O nyinnan \"nan -wɛɛdɩ 'sia Zozi lɛ 'fla zɩɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","'Pian Samari 'nɔn 'ka 'wɩlɛ \"man \"fo \"dɩ, kɔɔ Zeruzalɛm nɛn e \"ta -ko. ");
INSERT INTO yreNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Zɩ Zozi -srunɔn Zaji 'lee Zan 'wɩ zɩɛ -a 'man bɛ, ɛn waa 'vɩ Zozi lɛ 'nan: «Minsan, i ya \"vale 'kʋ 'tɛ 'si laji -e 'e o -nan -nyan?» ");
INSERT INTO yreNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Zozi 'e man lila o da, ɛn e 'wɩ 'pla -wlɛ 'klagla. Yaa 'vɩ -wlɛ 'nan: «Min nɛn ka drɛ -yee 'nɛnnun -a bɛ -a -cin 'san 'ka 'ji 'va? ");
INSERT INTO yreNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kɔɔ 'an 'bɔ Blamin -pɩ ma'an 'talɛ 'trɛda 'nan -e 'an minnun -tɛɛ \"dɩ. 'Pian an -ta 'nan -e 'an minnun 'si 'wɩ 'ji.» -A -nan nɛn o 'fla pee da si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Zɩ o ya -kʋnan -sia bɛ, ɛn min -tʋ \"e 'nan Zozi lɛ 'nan: «Fɛnan pɛɛnɔn nɛn i -ko bɛ, kʋɛ 'ko 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ɛn Zozi \"e 'nan -yrɛ 'nan: «-Canjannɛnnun nyinnan a, ɛn \"lomannun \"kɔɛ \"a, 'pian Blamin -pɩ \"le \"fɛ -tʋ -nan \"ka -e 'e 'wulo 'pla 'nan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ɛn Zozi 'a 'vɩ min -tʋ lɛ 'nan: «'I -sɔɔnla 'an -sru!» Min zɩɛ e 'nan Zozi lɛ 'nan: «Minsan, 'i 'si -nɔn 'mɛn, -e 'an 'kʋ 'an \"tɩ \"wʋ 'vaadrɔ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Zozi \"e 'nan -yrɛ 'nan: «Minnun nɛn Bali \"le 'va o cɩ 'o 'kadɩ bɛ, 'i o 'tʋɩ 'o 'wee min wʋ. 'Pian 'i 'bɔ 'i 'kʋ -a vɩ minnun lɛ 'nan Bali -le mingɔnnɛn -blɩdɩ 'bɔ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ɛn min pee -a 'vɩ 'nan: «Minsan, an -taa -sɔɔnlɛa 'i -sru, 'pian an ya \"vale 'i 'si -nɔn 'mɛn -e 'an 'kʋ -si trʋ 'ba 'an 'mangulinun lɔ.» ");
INSERT INTO yreNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ɛn Zozi \"e 'nan -yrɛ 'nan: «-Te min -si -tʋ 'sia, te -a \"trɔɛn \"a 'e koda bɛ, -a san zɩɛ ya'a dra Bali -le mingɔnnɛn trɛdavɛ -a \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","\"Bɛ -sru ɛn Minsan min -fuba 'sɔravli 'wlɛ \"fli 'si \"va, ɛn e o 'pa 'sia \"flivli 'e 'lɛ. Yaa 'vɩ -wlɛ 'nan 'o 'kʋ 'fla 'lee fɛnan pɛɛnɔn nɛn 'e \"ta -ko bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Saa 'bɛ tran \"kaga \"bɛ, 'pian -a -tɛnɔn a \"wɛnnɔn. -Yee \"wɛan 'ka Minsan nɛn fei zɩɛ e cɩ -yee vɛ -a bɛ -a trʋ 'ba, 'nan 'e -a -tɛnɔn 'pa 'sia -e 'o -yee 'saa bɛ -a -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","'Ka -si 'sia! 'Pian 'ka drɛ \"yi, kɔɔ an \"ta 'ka \"paa 'sia \"le 'bla 'nɛnnun nɛn o \"ta -ko plɔ winun yei \"bɛ -wee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Te 'ka \"lala 'lee 'pada 'lee -manwua 'sia dɩ, ɛn te 'ka 'mɔn -sia min minnun 'tɔ bʋdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","-Te ka wla 'kɔn 'tʋ -ji bɛ, 'ka -a -ji 'nɔn 'tɔ bʋ 'nan, Bali 'e 'fʋdɩ -trɔɔ -nɔn -wlɛ! ");
INSERT INTO yreNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ɛn -te min -tʋ a 'kɔn zɩɛ -a -ji, te e ya -fʋdɩ -trɔɔ -wɛɛnan bɛ, 'cee -fɛa -fʋdɩ -trɔɔ -nɔan -yrɛ. 'Pian -te 'bɛ \"ka \"dɩɛ, 'cee -fɛa \"nɛn \"fo 'e \"tun. ");
INSERT INTO yreNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","'Kɔn nɛn -a 'lɛ \"nɛn 'nɔn 'ka 'pɛ 'kun bɛ, -a -nan nɛn 'ka 'fʋ. Ɛn fɛ oo fɛ nɛn waa -nɔn 'cɛɛ -ji -blɩvɛ -a 'lee mlinvɛ -a bɛ, 'ka -blɩ ɛn 'ka mlin. Kɔɔ min nɛn e ya 'nyranman -tʋ 'panan bɛ, -a -nɔan da nɛn -e -a -pan 'e 'kɔn. 'Pian te 'ka 'ciɩ 'kɔn 'lɛ \"nɛn -tɔɔladɩ -a \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","'Fla nɛn ka 'bɔla \"da, ɛn o 'ka 'kun tɩglɩ bɛ, fɛ nɛn o -taa 'cɛɛ bɛ, 'ka -blɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","'Ka -cɛ 'si minnun man 'fla zɩɛ -a da, ɛn 'ka vɩ -wlɛ 'nan, Bali -le mingɔnnɛn -blɩdɩ 'sia 'ka 'va. ");
INSERT INTO yreNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","'Pian -te ka wla 'fla 'tʋ da, ɛn 'fla zɩɛ -a danɔn 'ka 'o yiɛ 'tɔlɛ 'ka yra dɩɛ, 'ka 'kʋ -wee -guada, -e 'ka vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹'Ka -tɔ 'nan, Bali -le mingɔnnɛn -blɩdɩ 'bɔ 'kogo. 'Pian ka'a 'wɩlɛ \"man \"dɩ. -Yee \"wɛan 'ka fla fuɔn nɛn e -fʋ 'kʋ 'cɛin -man bɛ, kʋa -tɔala 'ka da. -A -kɔɔndɩ nɛn 'nan 'kʋ 'pɛ 'si 'cee 'wɩ 'ji.› ");
INSERT INTO yreNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, yi nɛn Bali 'trɛdanɔn 'le tin \"baa bɛ, 'fla zɩɛ -a da 'nɔn 'le yra yɩdɩ 'plɛblɛ \"mlian Sodɔm 'nɔn 'le vɛ da.» ");
INSERT INTO yreNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ɛn Zozi -a -tɔ \"nɛn -a vɩdɩ -a 'nan: «Koraze 'nɔn, 'wɩ -taa \"bɔlɛ 'ka man! Bɛzaida 'nɔn, 'wɩ -taa \"bɔlɛ 'ka man! Kɔɔ, \"te 'lɛbo \"fɔ wɩnun nɛn o drɛ 'ka yiɛ man 'gʋɛ, 'nan o drɛ 'fla nɛn waa laabo Tir 'lee Sidɔn bɛ -a da bɛ, \"te -a da 'nɔn 'si 'o drɛ wɩ -wlidɩ \"man -a -nan 'mɔn. Ɛn \"te o 'tɛ 'yie 'wi 'o da -a -nan 'mɔn, ɛn \"te o -cɛ bʋ sɔ cɛɛn 'o man -a -nan 'mɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","-Yee \"wɛan nɛn maan ve 'cɛɛ 'nan, yi nɛn Bali minnun -le tin \"baa bɛ, 'cee yra yɩdɩ 'plɛblɛ \"mlian Tir 'lee Sidɔn 'nɔn 'le vɛ da. ");
INSERT INTO yreNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ɛn kaa nɛn ka cɩ Kapanamo 'nɔn 'a bɛ, e ya 'ka 'ji 'nan ka -ko Bali va laji? -Cɛjɛ, 'pian Bali 'ka -sɔɔnmlan -kanɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Min nɛn e 'ka wei 'man \"yi \"bɛ, te 'an 'bɔ nɛn yaan wei 'man \"yi. Ɛn min nɛn ya'a 'e yiɛ 'tɔlɛ 'ka yra dɩɛ, te 'an yra nɛn -a san 'ka 'e yiɛ 'tɔlɛ dɩ. Ɛn \"nyian bɛ, min nɛn ya'a 'e yiɛ 'tɔlɛ 'an yra dɩɛ, te -a san 'ka 'e yiɛ 'tɔlɛ min nɛn yaan 'pa 'sia 'trɛda bɛ -a yra dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Min -fuba 'sɔravli 'wlɛ \"fli \"nɛn Zozi o 'pa 'sia bɛ o 'li 'o da ci \"nrandɩ -a. Ɛn waa 'vɩ Zozi lɛ 'nan: «'Kʋ 'san, 'kʋɛ cɩ -yʋ -wlidɩnun da. 'Wɩ nɛn kʋa 'vɩ -wlɛ 'i 'tɔ da 'nan 'o drɛ bɛ, waa dra.» ");
INSERT INTO yreNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Maan -tɔa zɩ. An Satan yɩ 'sinan laji, te e \"ta -sɔɔnman \"le laa -paan 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","'An 'bɔ mɛɛn -kɔladɩ -nɔn 'cɛɛ, 'nan -e 'ka 'ta wʋla -sanjre 'lee -mlɛn 'lee Bali 'nanmanzan 'le 'plɛblɛ pɛɛnɔn da. 'Wɩ 'tʋ 'ka 'dra 'cɛɛ \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ɛn te 'ka 'ci 'e \"nran 'nan, cɛɛ cɩ -yʋ -wlidɩnun da dɩ! 'Pian 'ka 'ci 'e \"nran 'nan, 'ka 'tɔ a 'e 'crɛn -tɛdɩ Bali va!» ");
INSERT INTO yreNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tʋ zɩɛ -a wlu bɛ, Bali lei 'saun ci \"nrandɩ -nɔn Zozi lɛ. -A -nan nɛn Zozi \"e 'nan: «'An \"tɩ, yiɛ cɩ labli 'san -a, ɛn yiɛ cɩ 'trɛ 'san -a. Mɛin 'tɔ \"yi \"ve 'nan 'wɩnun nɛn yia yɔɔ minnun nɛn 'o 'fli \"siala 'wɩ 'tɔnɔn -a bɛ o man bɛ, yia ta 'bɔla minnun nɛn 'o 'fli drɛ nannannun -a bɛ -wlɛ. 'Wɩ 'kpa nɛn, kɔɔ 'wɩ nɛn e cɩ 'i 'ci 'sɔ 'a bɛ, -a 'bɔ nɛn yia drɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Fɛ pɛɛnɔn 'pɛba a 'e wʋdɩ 'an 'lɔ, 'an \"tɩ yiɛ drɛ zɩ. 'An \"tɩ 'saza 'bɛ 'an 'bɔ nɛn an cɩ -a -pɩ -a bɛ 'an -tɔa. Ɛn 'an 'bɔ nɛn an cɩ -a -pɩ -a bɛ, 'an 'saza 'bɛ 'an \"tɩ -tɔa. Ɛn \"nyian 'an 'bɔ nɛn an cɩ -a -pɩ -a bɛ, min nɛn an ya \"va 'nan 'an ta bɔala -yrɛ \"bɛ, -a san 'bɛ 'an \"tɩ -tɔa.» ");
INSERT INTO yreNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Zozi 'e 'man lila 'e -srunɔn 'saza da, ɛn yaa 'vɩ -wlɛ 'nan: «Bali -le -fɛa a kaa nɛn ka 'wɩ zɩɛ -a -nan ye bɛ 'ka man. ");
INSERT INTO yreNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Maan ve 'cɛɛ 'nan, Bali 'lewei vɩnɔn \"kaga 'lee mingɔnnɛnnun -a man wɛɛ 'nan, 'wɩ nɛn kaa -nan ye bɛ, \"o \"ye, 'pian wa'a yɩlɛ dɩ. Ɛn 'nan 'wɩ nɛn kaa maan \"bɛ, \"o maan, 'pian wa'a manlɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","'Fluba 'ci vɩzan -tʋ wluan 'nan -e 'e Zozi wei 'kun. Ɛn yaa laabʋ Zozi 'lɔ 'nan: «Bali -le 'wɩ \"paazan, maan dra 'kɔ -e 'an 'belidɩ nɛn ya'a 'nyaan dɩɛ -a yɩ?» ");
INSERT INTO yreNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Zozi \"e -yrɛ 'nan: «Bali -le -pei 'fluba 'ji bɛ, e ya 'e 'crɛn -tɛdɩ 'kɔ? -Mɛ \"wɩ nɛn yia 'man 'ji?» ");
INSERT INTO yreNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ɛn e 'nan: «'I Minsan Bali yɩ \"yi 'i 'bli pɛɛnɔn 'a! 'I yɩ \"yi 'yie 'wɩ drɛdɩ pɛɛnɔn 'a! 'I yɩ \"yi 'yie 'plɛblɛ pɛɛnɔn 'a! 'I yɩ \"yi 'i 'ci \"nrɔndɩ pɛɛnɔn 'a! Ɛn \"nyian 'i bɔɛzan -tʋ yɩ \"yi \"le 'yie 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Zozi \"e -yrɛ 'nan: «Yia 'vɩ 'kpa. 'I drɛ zɩ -e 'i 'belidɩ nɛn ya'a 'nyaan dɩɛ -a yɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","'Fluba 'ci vɩzan zɩɛ e ya 'yee tin 'nɔnnɔn -wɛɛnan, -yee \"wɛan yaa laabʋ \"nyian Zozi 'lɔ 'nan: «-Tɩɛ cɩ 'an bɔɛzan -tʋ -a?» ");
INSERT INTO yreNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ɛn Zozi 'wɩ zɩɛ -a -sru 'vɩ -kɔnnɛn \"fɔdɩ -a. E 'nan -yrɛ 'nan: «Min -tʋ 'si Zeruzalɛm, e \"ta -ko Zeriko. Zɩ e 'bɔ -si yei \"bɛ, ɛn crinnɔn 'bɔ \"man, o 'wʋ \"da, ɛn o -yee fɛnun pɛɛnɔn koo -yrɔ. Waa -sɔn -trilii -a -kadɩ -fɔla tʋ, ɛn o 'si -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","\"Bɛ -sru ɛn Bali -panzan -tʋ -si -tʋwli zɩɛ -a 'sia. Min nɛn crinnɔn -a -sɔn bɛ, yaa 'yɩ, ɛn e paala \"man -kɔɔbli, e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","\"Bɛ -sru ɛn min -tʋ nɛn e 'nyranman \"paa Bali -pan 'kuin bɛ e -si -tʋwli zɩɛ -a 'sia \"nyian. Min zɩɛ Levi min nɛn. 'Wɩ -tʋwli \"nɛn Bali -panzan -a drɛ bɛ, -nyrɛn yaa drɛ. Min nɛn crinnɔn -a -sɔn bɛ, yaa 'yɩ, ɛn e paala \"man \"kɔɔbli, e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ɛn \"nyian bɛ Samari min -tʋ \"ta -ko 'ta wʋnan. E -si -tʋwli zɩɛ -a 'sia. E 'bɔ min zɩɛ -a man. Zɩ yaa 'yɩ bɛ, ɛn -a nyrinda -sɛn \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","E pli \"man, ɛn yaa mlɔnnun yra bʋʋ 'nyrɔn 'lee -wɛn -a, ɛn yaa ta yrɩ. Zɩ e cɛɛn \"man \"bɛ, ɛn yaa 'si 'yee -sʋ da, tɔɔn ɛn e -kʋ -a -pɛnnɔn nyin -ji 'kuin, ɛn 'e yiɛ 'tɔ \"va. ");
INSERT INTO yreNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","-A ta tʋ cɛɛn, e 'lein 'wlɛ 'si \"fli, yaa -nɔn -pɛnnɔn nyin -ji 'kɔn san lɛ, ɛn e 'nan -yrɛ 'nan: ‹'I yra 'si, 'i yiɛ 'tɔ min 'gʋɛ -a va 'mɛn! \"Lala nɛn i \"ta -a srɛman -a -wulo -wlu bɛ, -te an -ta bɛ -e 'an bɔla 'yiɛ.› » ");
INSERT INTO yreNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ɛn Zozi -a laabʋ 'fluba 'ci vɩzan zɩɛ -yrɔ 'nan: «\"Yie 'ji, min yaaga zɩɛ o yei \"bɛ, -tɩɛ drɛ min nɛn crinnɔn -a -sɔn bɛ, -a bɔɛzan -tʋ -a? 'I vɩ 'mɛn!» ");
INSERT INTO yreNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ɛn 'fluba 'ci vɩzan \"e 'nan: «Min nɛn yaa nyrinda 'si bɛ, -a san nɛn.» Ɛn Zozi -a 'le 'sran -yrɛ 'nan: «'I 'kʋ! 'I 'bɔ \"i \"drɛ \"nyian zɩɛ!» ");
INSERT INTO yreNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Zozi 'lee 'e -srunɔn a -kʋnan -sia, ɛn o 'bɔla 'fla 'tʋ da. Lɩmɔn -tʋ a 'fla zɩɛ -a da, waa laabo Mat. E \"yi drɛ Zozi lɛ 'e 'bɔ 'le \"kɔnnɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","-A \"blu -tʋ a, wɛɛ laabo Mari. Mari zɩɛ e -nyran Minsan cɛin -man, ɛn yaa wei mandɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tʋ zɩɛ -a wlu, te Mat \"le yra 'kla \"tra \"dɩ, fɛnun -tɔɛndɩ 'lee 'wɩ \"kaga \"drɛdɩ -le \"wɛan. Tɔɔn e -ta, ɛn e 'nan Zozi lɛ 'nan: «Minsan, 'an \"blu 'an \"tʋe 'an 'tʋwli fɛnun drɛnan. 'Wɩ zɩɛ yi'a siala 'wɩ 'a dʋʋ? 'I vɩ -yrɛ 'nan 'e 'pa 'an 'va!» ");
INSERT INTO yreNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ɛn Minsan \"e 'nan -yrɛ 'nan: «Mat, 'i 'ci \"nrɔnman 'wɩ \"kaga \"da, ɛn 'i yra 'kla \"tra \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","'Pian maan ve 'yiɛ 'nan, 'wɩ nɛn e cɩ tɩglɩ bɛ e ya -tʋwli \"cɛ. -A 'bɔ nɛn 'i \"blu Mari -a -si 'sia 'gʋ, ɛn min 'ka -a sia -yrɔ \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yi -tʋ da bɛ, Zozi Bali trʋ 'badɩ 'sia fɛ -tʋ -nan. Zɩ e cɛɛn \"man \"bɛ, ɛn -a -sruzan 'tʋ \"e -yrɛ 'nan: «Minsan, 'i Bali trʋ 'badɩ \"paa 'kʋ 'ji \"le zɩ Zan -a paa 'e -srunɔn 'ji bɛ, -yee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «\"Cɛɛ vɩ 'nan ka Bali trʋ 'ba bɛ, 'ka vɩ 'nan: 'Kʋ \"tɩ Bali, 'i drɛ -e minnun 'o 'i 'tɔ drɛ -dan! 'Yie mingɔnnɛn -blɩdɩ 'e 'ta! ");
INSERT INTO yreNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yi -tʋdʋ pɛɛnɔn da bɛ, 'i 'kʋ 'blɩfɛ nɛn kʋ cɩ \"va \"bɛ -a -nɔn 'kʋɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","'Wɩnun nɛn kʋa dra 'yiɛ -wlidɩ \"bɛ, 'i 'cɛ 'kʋɛ! Kɔɔ min 'wɩ dra 'kʋɛ -wlidɩ \"bɛ, kʋa \"cɛa -yrɛ. Te 'i 'kʋ 'tʋɩ -e Satan 'e 'kʋ 'man yɩ dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","\"Bɛ -sru ɛn Zozi -kɔnnɛn \"tʋ -fɔ -wlɛ. E 'nan: «Min -tʋ a 'ka yei, ɛn -a bee -tʋ -a. Bada -tɔ, ɛn e -kʋ 'e bee zɩɛ -a -va. Yaa 'vɩ -yrɛ 'nan: ‹'An bee, 'i yra 'si, 'i \"mɛn 'kpɔun yaaga 'fɛ! ");
INSERT INTO yreNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Min -tʋ \"sia 'ta wʋnan, e 'bɔla 'an 'va. Ɛn fɛ -tʋ 'ka 'an 'lɔ -e 'an -nɔn -yrɛ \"dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tɔɔn -a bee zɩɛ, -e 'e vɩ -yrɛ 'nan: ‹'Yian 'tʋɩ flɩɩ! 'An 'kɔn 'fɔ -ji 'va. 'Kʋ 'vale 'mɛn 'nɛnnun -a kʋ ya yi -tɛnan. Ma'an 'wuanla -e 'an 'kpɔun -nɔn 'yiɛ dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","-Te min zɩɛ e 'ka \"vale 'e wuanla 'e bee -le \"wɛan dɩɛ, maan ve 'cɛɛ 'nan, e wuanla 'nan 'e bee a 'e man drɛnan -wluwlu -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","-Yee \"wɛan maan ve 'cɛɛ 'nan: 'Ka fɛ trʋ 'ba, waa -nɔan 'cɛɛ! 'Ka fɛ -wɛɛ, kaa ye! 'Ka 'kɔn 'tɛ, waa 'lɛ \"so 'cɛɛ! ");
INSERT INTO yreNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kɔɔ min nɛn e fɛ trʋ \"baa bɛ, waa -nɔan -yrɛ. Ɛn min nɛn e fɛ -wɛɛman bɛ, yaa ye. Ɛn min nɛn e 'kɔn -tɛa \"bɛ, waa 'lɛ \"so -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Min \"tɩ \"tʋ 'ka 'ka yei, -te 'yee 'nɛn pɔ trʋ 'ba -yrɔ \"bɛ -e 'e -mlɛn -nɔn -yrɛ -a \"pa 'ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ɛn \"nyian bɛ, min \"tɩ \"tʋ 'ka 'ka yei, -te 'yee 'nɛn mannyrɛn trʋ 'ba -yrɔ \"bɛ -e 'e -sanjre -nɔn -yrɛ -a \"pa 'ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ka ya min -wlidɩ \"a, 'pian ka fɛ \"yi -tɔa -e 'ka -nɔn 'cee 'nɛnnun lɛ. 'Ka \"tɩ \"nɛn laji bɛ, -a ci \"yi \"mlian 'ka da, -yee \"wɛan 'ka -tɔ 'nan, e lei 'saun -nɔan minnun nɛn waa laabo -yrɔ \"bɛ -wlɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yi -tʋ da bɛ, ɛn Zozi bobo -tʋ beli. -Yʋ nɛn e min zɩɛ -a drɛ bobo -a bɛ, Zozi -a -pin -a -sru. Zɩ -yʋ zɩɛ e 'si bobo -sru \"bɛ, ɛn min 'bɔ 'wɩdɩ 'sia. Tɔɔn minnun pɛɛnɔn nɛn -nan bɛ, 'wɩ o 'plo 'fɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","'Pian min -mienun \"o 'vɩ 'nan: «-Yʋnun tazan nɛn waa laabo Bɛlzebul bɛ, -yɛɛ 'plɛblɛ 'nɔn Zozi lɛ, ɛn e -yʋ -wlidɩnun -pian \"minnun -sru.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ɛn \"nyian bɛ min -mienun -a laabʋ Zozi 'lɔ 'nan, 'e 'lɛbo \"fɔ wɩ -tʋ drɛ, -e 'o 'tɔ 'nan e \"sia laji. ");
INSERT INTO yreNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Zɩ 'wɩ nɛn -a -cin cɩ o ji bɛ, Zozi 'a -kɔnnɛn 'yɩ bɛ, ɛn e 'nan -wlɛ 'nan: «-Te 'lɛglɔn 'tʋ -ji minnun cɛɛn 'e cin man, ɛn o ya -kuli -tannan 'o cin man bɛ, 'lɛglɔn zɩɛ e -wia. 'Kɔnnun -wiiman 'o cin da. ");
INSERT INTO yreNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","-A -tʋwli \"nɛn \"nyian Satan 'lee -yee -yʋnun -le vɛ -a. \"Te -wɛɛ cɛɛn 'e cin man, ɛn o ya -kuli -tannan 'o cin yei \"bɛ, \"te -yee mingɔnnɛn trɛ -wi -a -nan 'mɔn. -Yee \"wɛan -te 'ka ve 'an man 'nan Bɛlzebul 'bɛ 'plɛblɛ -nɔan 'mɛn, ɛn 'an -yʋ -wlidɩnun -pian \"minnun -sru \"bɛ, 'cee tin 'ka 'nɔnnɔn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ɛn -te 'wɩ nɛn ka 'vɩ zɩɛ e ya 'wɩ 'kpa 'a bɛ, 'lɔɔ 'cee minnun bɛ, -tɩ -le 'plɛblɛ 'a nɛn \"o \"yʋ -wlidɩnun -pian? 'Ka 'bɔ 'le minnun 'bɛ -kɔɔnman 'nan 'cee tin 'ka 'nɔnnɔn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","'Ka -tɔ 'nan, Bali -le 'plɛblɛ 'a nɛn an -yʋ -wlidɩnun -pian \"minnun -sru. Ɛn 'wɩ zɩɛ -a drɛdɩ 'bɛ -kɔɔnman 'nan, Bali -le mingɔnnɛn -blɩdɩ 'bɔ 'ka 'va. ");
INSERT INTO yreNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Min 'plɛblɛ nɛn -kuli -tan fɛnun cɩ -yrɔ, ɛn -a yiɛ a 'yee 'kɔn 'va bɛ, -a yɩfɛnun pɛɛnɔn 'man yra flɩɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","'Pian min nɛn -a 'plɛblɛ -cia \"da \"bɛ, -te e -ta, ɛn yaa klɩ bɛ, e -yee -kuli -tan fɛnun nɛn e yi -tɛra \"da \"bɛ -a \"kooman -yrɔ -e 'e -a yɩfɛnun -pli. ");
INSERT INTO yreNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","-A -cin 'e 'kɔn 'ka 'ji 'nan, min nɛn e 'ka 'an 'va dɩɛ, te -a pei a 'e 'padɩ 'an man. Ɛn min nɛn ya'a 'paa 'an 'va -e 'kʋ fɛ tre 'e cin man dɩɛ, yaa fuimlan \"man.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«-Te -yʋ -wlidɩ 'si min -sru \"bɛ, e -cia \"wʋdɩ -a fɛnan -kadɩnun -nan. E -cia \"fɛnan -wɛɛdɩ -a 'nan -e 'e -nyran -nan. 'Pian -te ya'a yɩlɛ dɩɛ, -e 'e vɩ 'nan: ‹An lia 'an da 'mɛn 'kɔn nɛn an cɩ \"nɛn \"ji bɛ, -a -ji.› ");
INSERT INTO yreNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","-Te e -ta, te -a -nan a 'e \"koodɩ, te -a -nan fɛ pɛɛnɔn yra \"cɛjɛ, ");
INSERT INTO yreNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","tɔɔn -e 'e 'kʋ 'e -sru, -e 'e -yʋ -wlidɩ 'sɔravli \"nɛn o -wlidɩ \"mlian \"da \"bɛ o 'pa 'e 'va, -e 'o 'ta -nyran 'kɔn zɩɛ -a -ji. \"Yɛɛ 'le 'sran bɛ, min zɩɛ -yee -kɔndɩ -wlidɩ \"mlian -a tɛdɛ vɛ da.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Zɩ Zozi cɛɛn 'wɩnun zɩɛ -a vɩdɩ man bɛ, tɔɔn ɛn lɩmɔn -tʋ wei wɩɩ minnun yei. Yaa 'vɩ 'nan: «Bali -fɛa 'vɩ lɩmɔn nɛn yei 'ya ɛn e 'nyɔn 'nɔn 'yiɛ bɛ -a man.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","'Pian Zozi \"e 'nan -yrɛ 'nan: «Min nɛn e Bali wei maan te e 'ta wʋla \"da \"bɛ, -a san man nɛn Bali -le -fɛa cɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Zɩ minnun a trenan \"kaga \"bɛ, tɔɔn Zozi \"e 'nan: «-Naagʋnɔn, ka ya min -wlidɩnun -a. Ka ya \"va 'nan, 'an 'wɩ 'tʋ drɛ -e 'e -kɔɔn 'nan 'an \"sia Bali va. 'Pian maan ve 'cɛɛ 'nan, Bali 'ka \"nyian 'wɩ 'nɔan -kɔɔn \"vɛ pee dra 'ka 'va 'gʋ dɩ, -te ya'a 'silɛa 'wɩ nɛn Bali 'lewei vɩzan Zonazi -a drɛ bɛ -a dɩɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kɔɔ Blamin -pɩ -taa \"drɛlɛ 'wɩ 'nɔan -kɔɔn \"vɛ -a -naagʋnɔn lɛ, \"le zɩ Zonazi -a drɛ 'li Ninivi 'nɔn lɛ bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ɛn lɩmɔn -tʋ nɛn 'li e ya mingɔnnɛn -a 'trɛda \"tre 'zia bɛ, yi nɛn Bali minnun -le tin \"baa bɛ, -yɛɛ 'wɩ -tɔa -naagʋnɔn man. Kɔɔ e 'si 'trɛda fɛnan -kɔɔbli 'nan, 'nan -e 'e Salomɔn -le 'wɩ 'tɔdɩ yɩ. Maan ve 'cɛɛ 'nan, min nɛn -a -dan \"mlian Salomɔn da bɛ, e ya 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ɛn \"nyian bɛ, yi nɛn Bali minnun -le tin \"baa bɛ, Ninivi 'nɔn 'wɩ -tɔa -naagʋnɔn man. Kɔɔ zɩ Zonazi Bali -le 'wɩ 'vɩ -wlɛ \"bɛ, o 'si 'wɩ 'wlidɩ \"drɛdɩ man, ɛn o -sɔɔnla Bali -sru. Maan ve 'cɛɛ 'nan, min nɛn -a -dan \"mlian Zonazi da bɛ, e ya 'gʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ɛn Zozi -a 'le 'sran 'nan: «Min 'ka -kannɛn 'fɔa \"nɛn -e 'e yɔɔ dɩ, -te 'bɛ \"cɛɛ dɩ, -e 'e wʋ -pɔ wlu dɩ. 'Pian yaa -tɔala fɛnan 'wein da, -e minnun \"ɛ -wla 'kuin bɛ, te waa -san ye. ");
INSERT INTO yreNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Min yiɛ 'bɛ -maan min fɛnan ye. -Te 'i yiɛ a \"ji 'kpa bɛ, 'tɛ 'san -sɛan 'i da, yia -tɔa. 'Pian -te 'i yiɛ 'ka fɛnan ye dɩɛ, 'tɛ 'san -sɛan 'i da, yi'a tɔa dɩ. I ya tʋ pɛɛnɔn man klun va. ");
INSERT INTO yreNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","-Yee \"wɛan 'ka drɛ \"yi, te fɛ -tʋ 'e 'si -tɔ 'tɛ 'san -lɔ, -e 'ka 'fʋ klun va dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kɔɔ -te 'tɛ 'san a 'e -sɛndɩ 'i fɛ pɛɛnɔn 'nan, ɛn 'i fɛ -tʋ -nan 'ka 'fʋlɛ klun va dɩɛ, 'i man -kɔan 'wein \"fo \"le zɩ -kannɛn 'i 'man dra 'wein bɛ, -yee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Zozi 'fʋ 'wɩ tin 'banan, ɛn Farizɛn min -tʋ -ta -a trʋ 'balɛ. Yaa 'vɩ -yrɛ 'nan, 'e 'kʋ fɛnun -blɩ 'yee \"kɔnnɛn. Zozi wɩɩ \"man. Zɩ e -kʋ, e wla -yee 'kuin bɛ, 'nun tɔɔn ɛn e -nyran fɛnun -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","'Wɩ zɩɛ e Farizɛn min 'plo 'fɔ. Kɔɔ Zozi 'ka 'e 'pɛ -man \"foelɛ \"le zɩ 'o tranun -a 'vɩ bɛ -yee 'wɩ 'zʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","-A -nan nɛn Zozi \"e 'nan -yrɛ 'nan: «'Ka Farizɛn 'nɔn bɛ, ka 'kulenɛn 'lee -pɔ man bei \"foeman fɛnyian. 'Pian 'ka 'pɔn -ji a 'e fadɩ crin -pɔan 'lee nyannɛn -pɔan \"a. ");
INSERT INTO yreNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ka ya -blʋ -a! Bali nɛn e fɛ man bei drɛ bɛ, -yɛɛ fɛ -ji drɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","-Yee \"wɛan fɛ nɛn e cɩ 'cee 'kulenɛn 'lee 'cee -pɔ -ji bɛ, -nyrɛn 'ka -nɔn 'yalɛ -tɛnɔn lɛ, -e 'ka 'kɔn 'saun Bali 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Farizɛn 'nɔn, 'wɩ -taa \"bɔlɛ 'ka man! Kɔɔ sinwlɛnun nɛn waa laabo manti 'lee ru bɛ, 'lee 'cee sinwlɛ pɛɛnɔn bɛ, kaa -fuzan -nɔan Bali lɛ. 'Pian ka'a Bali ye \"yi \"dɩ, ɛn ka'a va wɩ dra \"yi \"dɩ. Te 'wɩ zɩɛ -yɛɛ cɩ \"le blamin 'e drɛ 'vaa -e 'e fɛ -fuzan -nɔn Bali lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farizɛn 'nɔn, 'wɩ -taa \"bɔlɛ 'ka man! Kɔɔ -te ka ya cin yɩ 'kuin bɛ, ka -nyran \"nan 'kpagba 'sidɩ ye \"yi. Ɛn -te ka ya -guada bɛ, ka ya \"vale min yiɛ 'e 'nan 'ka man -e 'e 'ka 'tɔ bʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","'Wɩ -taa \"bɔlɛ 'ka man! Kɔɔ ka ya \"le min -yrɛ nɛn -a ta a 'e 'sandɩ bɛ -yee 'wɩ 'zʋ. -Te min 'tran \"da bɛ, -e fɛ nɛn \"ji \"bɛ 'e min \"tri \"tɔ Bali 'lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Zɩ Zozi 'wɩ zɩɛ -a 'vɩ bɛ, -a -nan nɛn 'fluba 'ci vɩzan -tʋ -a 'si \"da. Yaa 'vɩ Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan, -te yia vɩ zɩɛ, te i ya \"nyian \"kʋe \"srɔn wʋnan.» ");
INSERT INTO yreNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ɛn Zozi \"e 'nan -yrɛ 'nan: «'Fluba 'ci vɩnɔn, 'wɩ -taa \"bɔlɛ \"nyian \"cee \"man! Kɔɔ 'wɩ 'plɛblɛ nɛn kaa ve minnun lɛ 'nan 'o drɛ, te ka'a 'paa o va -a drɛnan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","'Wɩ -taa \"bɔlɛ 'ka man! Kɔɔ Bali 'lewei vɩnɔn nɛn 'ka tranun o tɛɛ bɛ, ka 'kɔn drɛ o -yrɛ da. ");
INSERT INTO yreNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","'Wɩ nɛn 'ka tranun -a drɛ bɛ, e ya 'ka 'ji 'wɩ \"yi \"a, -yee \"wɛan nɛn ka 'kɔn drɛ Bali 'lewei vɩnɔn zɩɛ o -yrɛ da. ");
INSERT INTO yreNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bali nɛn 'wɩ 'tɔdɩ pɛɛnɔn a -yrɔ \"bɛ, e 'wɩ zɩɛ -a 'vɩ 'e 'cɛn. Yaa 'vɩ 'nan: ‹An -taa 'an 'lewei vɩnɔn 'lee 'mɛn 'pasianɔn 'a -wlɛ, 'pian o o -mie -tɛa, ɛn o 'tɛ \"paa o -mie da.› ");
INSERT INTO yreNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","-Yee \"wɛan Bali 'lewei vɩnɔn nɛn minnun o tɛɛ 'trɛda pou sianan \"bɛ, -naagʋnɔn da nɛn Bali -a nyran -sɛan. ");
INSERT INTO yreNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","E 'sia Abɛl da -trilii, ɛn e 'bɔ Zakari nɛn waa -tɛ Bali -pan 'kɔn 'lee Bali -pan \"davɛ yei \"bɛ -a da. Maan ve 'cɛɛ 'nan, -naagʋnɔn da nɛn Bali -a nyran -sɛan. ");
INSERT INTO yreNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","'Fluba 'ci vɩnɔn, 'wɩ -taa \"bɔlɛ 'ka man! Kɔɔ -si nɛn minnun -a \"siala -e 'o 'kʋ Bali va bɛ kaa 'lɛ 'wʋ. 'Ka 'bɔ 'ka -si 'bɔ zɩɛ -a da dɩ, ɛn \"nyian bɛ minnun nɛn o ya \"vale 'nan 'o 'si zɩɛ -a \"siala bɛ, ka -si -tɔ -wlɔ!» ");
INSERT INTO yreNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Zɩ Zozi cɛɛn 'wɩ zɩɛ -a vɩdɩ man bɛ, ɛn e 'bɔla Farizɛn min zɩɛ -yee 'kuin. 'Wɩ pɛɛnɔn nɛn Zozi 'a 'vɩ bɛ, e 'bli 'fɔ 'fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn 'ji \"fo. -Yee \"wɛan -e 'e 'sia tʋ zɩɛ -a man bɛ, o 'wɩ laabʋ 'siɛn -yrɔ \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Waa dra zɩɛ 'nan -e 'o wei 'kun -e 'o 'kɔla 'wɩ 'tɔdɩ -a man. ");
INSERT INTO yreNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ɛn minnun tredɩ 'sia \"nyian Zozi man \"kaga 'kpa 'nan -e 'o wei man. O ya \"kaga \"bʋʋ \"le \"wɛan o \"taanmlan 'o cin cɛinla da. 'Pian Zozi 'wɩ tin 'badɩ 'sia 'e tɛdɛ 'e -srunɔn lɛ. Yaa 'vɩ -wlɛ 'nan: «'Ka yiɛ 'tɔ 'ka 'fli -va Farizɛn 'nɔn 'le 'mannyan 'le \"wɛan. O wei a \"flivli, -yɛɛ cɩ \"le 'mannyan 'le 'wɩ 'zʋ. Te 'wɩ zɩɛ 'e 'ka 'sa -e 'ka 'wɩ drɛ \"le -wee 'wɩ 'zʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Maan -cin -tɔa 'ka 'ji 'nan, fɛ -tʋ 'ka 'fo 'e yɔɔdɩ -trilii, -e 'e vɩlɛ 'e bɔla 'ji dɩ. Ɛn 'wɩ yɔɔdɩ -tʋ \"ka -e 'o vɩlɛ o man fɛnan 'wein da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","-Yee \"wɛan 'wɩ pɛɛnɔn nɛn kaa ve klun va bɛ, o -taa -a manlɛ yidɛa. Ɛn 'wɩ nɛn kaa ve 'sure -ji min lɛ 'kɔn \"bʋ \"ji bɛ, o -taa -a trɔan -tɔlɛ min yei.» ");
INSERT INTO yreNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«'An beenun, maan ve 'cɛɛ 'nan, te 'ka \"klan minnun nɛn o min po -tɛa, te wa'a 'kɔlaman \"nyian fɛ pee drɛdɩ -a dɩɛ, -wlɔ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Min nɛn 'kɔ 'ka \"klan -yrɔ \"bɛ, maan -kɔɔnman 'cɛɛ. 'Ka \"klan Bali lɔ, kɔɔ e -kɔlaman e min -tɛa, ɛn e -kɔlaman e -ko min -a yra yɩdɩ nɛn ya'a 'nyaan dɩɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","-A -cin 'e 'kɔn 'ka 'ji 'nan, \"loman \"wɛnwɛnnɛnnun 'bɔ nɛn min 'ka o taan \"lala \"kaga 'va dɩɛ, Bali yiɛ a o -tʋdʋ pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ɛn 'cee vɛ bɛ, Bali 'ka 'wulo \"jɛ \"pou -tʋdʋ pɛɛnɔn \"nɛn -tɔa. -Yee \"wɛan te nyɛn 'e 'kɔn 'ka 'ji dɩ! Bali 'ka \"siala e -cia \"loman \"kaga \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Maan ve 'cɛɛ 'nan, min nɛn yaa 'lɛ \"cɛan minnun pɛɛnɔn 'lɛ 'nan, 'e ya 'an -sruzan 'a bɛ, 'an 'bɔ Blamin -pɩ maan 'lɛ \"cɛan \"nyian Bali -le 'pasianɔn 'lɛ 'nan, min 'gʋɛ 'an -sruzan nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","'Pian min nɛn e 'ka \"vale 'e ve minnun yiɛ man 'nan, e ya 'an -sruzan 'a dɩɛ, 'an 'bɔ \"nyian \"an \"ve Bali -le 'pasianɔn yiɛ man 'nan, 'an -sruzan \"cɛɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ɛn min nɛn e wɩɩ 'wlidɩ Blamin -pɩ man bɛ, Bali -a man wɩ \"cɛa. 'Pian min nɛn e wɩɩ 'wlidɩ Bali lei 'saun man bɛ, Bali 'ka -a cɛa -yrɛ \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","-Te o -kʋ 'kaa tin 'banɔn 'cɛin -da bɛ, 'wɩ nɛn 'kɔ 'ka vɩ bɛ, te -a nyɛn 'e 'kɔn 'ka 'ji dɩ. -Te Zuif 'nɔn 'le cin yɩ 'kuin nɛn oo, ɛn -te min tanɔn 'cɛin -da nɛn oo, ɛn -te mingɔnnɛnnun cɛin -da nɛn oo, 'wɩ nɛn 'kɔ ka vɩ bɛ, te -a nyɛn 'e 'kɔn 'ka 'ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kɔɔ 'wɩ nɛn 'kɔ 'ka vɩ bɛ, Bali lei -a \"paaman 'ka 'ji tʋ zɩɛ -a wlu.» ");
INSERT INTO yreNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Min -tʋ nɛn minnun yei \"bɛ, e 'nan Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan, 'i vɩ 'an \"bʋɩ lɛ 'nan, 'kʋ \"tɩ -zia fɛnun bɛ, 'kʋ -pli!» ");
INSERT INTO yreNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ɛn Zozi \"e 'nan min zɩɛ -yrɛ 'nan: «-Tɩɛ 'vɩ 'yiɛ 'nan maan nɛn 'an drɛ 'ka yei fɛ -plidɩ da tin 'bazan 'a?» ");
INSERT INTO yreNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ɛn Zozi -a 'vɩ minnun nɛn -nan bɛ -wlɛ 'nan: «'Ka yiɛ 'tɔ 'ka 'fli -va! Te 'ka -wɛɛ 'nan fɛ pɛɛnɔn 'e 'kɔn 'ka 'lɔ dɩ! Kɔɔ -te min a fɛzan -a 'kɔ oo, -yee 'belidɩ 'ka 'sia 'e lɔ fɛ man dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","-A -nan nɛn Zozi -kɔnnɛn 'gʋɛ -a -fɔdɩ 'sia -wlɛ. E 'nan: «Fɛzan -tʋ -a, ɛn -yee fei -a. -Yee fei zɩɛ -a ta fɛ 'bɔla \"kaga 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","-A -nan nɛn yaa \"nrɔndɩ 'sia 'e 'ji 'nan: ‹Maan dra 'kɔ? Kɔɔ fɛ pee -nan \"ka \"nyian -e 'an 'mɛn fɛnun -sɛn -nan dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tɔɔn 'wɩ 'tʋ -cin -tɔ \"ji. -Nyrɛn 'nan: ‹'An 'mɛn fɛnun tre 'kɔnnun -wia, -e 'an pee -tɔ 'kpa -dan. \"Bɛ -sru -e 'an 'mɛn fei fɛ 'wlɛ 'lee 'an yɩfɛ pɛɛnɔn -sɛn -ji, ");
INSERT INTO yreNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","-e 'an vɩ 'an 'fli lɛ 'nan: 'An bee, i yɩfɛ a \"kaga lɛ \"kaga 'wlu vɛ -a. 'I 'flinla 'e \"tun, ɛn 'i fɛ -blɩ 'e \"tun, ɛn 'i 'wɛn mlin 'e \"tun, -e 'i 'ci 'e \"nran 'e \"tun!› ");
INSERT INTO yreNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","'Pian Bali -a vɩ -yrɛ 'nan: ‹-Blʋzan! Cɛɛgʋ 'pei 'gʋɛ -a man bɛ, 'yie vɛ -nyaan 'trɛ da. Fɛnun pɛɛnɔn nɛn yia tre bɛ, -tɩ -lɔ nɛn e -fo?› » ");
INSERT INTO yreNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ɛn Zozi -a 'le 'sran 'nan: «'Wɩ 'tʋwli zɩɛ -yɛɛ bɔa min nɛn 'e yɩfɛ -wɛɛman 'e 'bɔ 'le vɛ -a bɛ -a man. Kɔɔ -a san 'ka fɛzan -a Bali 'lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","\"Bɛ -sru ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «-Yee \"wɛan maan ve 'cɛɛ 'nan: Te 'ka 'fʋ 'ka 'ci \"nrɔnnan 'cee 'trɛda da dɩ! -Yɛɛ cɩ \"le: ‹-Mɛ \"nɛn kʋa -ble? Ɛn kʋa dra 'kɔ, -e 'kʋ 'man sɔnun yɩ?› ");
INSERT INTO yreNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kɔɔ 'belidɩ nɛn 'ka 'lɔ bɛ -a \"yi \"mlian -blɩfɛ da. Ɛn 'ka 'kɔlɛ nɛn 'ka da bɛ -a 'kpa \"mlian sɔnun da. ");
INSERT INTO yreNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","'Ka 'ci \"nrɔn \"lomannun da -tʋ! Wa'a 'saa 'fɔa dɩ, ɛn wa'a 'saa 'tɛa dɩ, ɛn -wee fɛ 'ka 'e tredɩ fɛ -tʋ -nan dɩ, ɛn -wee fɛ trenan \"ka \"dɩ, 'pian te Bali -blɩfɛ -nɔan -wlɛ. -A -cin 'e 'kɔn 'ka 'ji 'nan Bali 'lɛ bɛ, 'ka \"yi \"mlian \"lomannun da! ");
INSERT INTO yreNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","'Cee ci \"nrɔndɩ 'cee 'trɛda da bɛ, ya'a 'kɔlaman -e 'e yi -tʋwli \"cɛ 'pa 'cee 'belidɩ da \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","-Te ka'a 'kɔlaman 'wɩ zɩɛ 'bɛ drɛdɩ -a dɩɛ, -mɛ \"le \"wɛan nɛn 'ka 'ci \"nrɔnman 'wɩ peenun da? ");
INSERT INTO yreNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","'Ka 'ci \"nrɔn lu -fuinun da \"nyian -tʋ! 'Ka -wee drɛdɩ yɩ! Wa'a 'nyranman 'paa dɩ, ɛn wa'a sɔ taan dɩ. 'Pian maan ve 'cɛɛ 'nan, Salomɔn nɛn e ya mingɔnnɛn -dan tʋ -a 'li bɛ, -yee sɔ -tʋ fɛnyian 'ka 'mlinlɛ lu -fuinun zɩɛ -a -tʋwli \"le fɛnyian da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Lu -fui \"nɛn 'bɛ cɩ lua, \"trɛ wɛɛ \"cɛan -e 'wɛɛ -fɔ 'tɛ 'va bɛ, -te Bali 'bɛ 'man drɛ vɛ wɛɛ fɛnyian zɩɛ bɛ, 'lɔɔ kaa \"nun? 'Cee yi -tɛradɩ Bali da a \"wɛnnɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","-Yee \"wɛan fɛ nɛn 'kɔ 'ka -blɩ 'lee fɛ nɛn 'kɔ 'ka mlin bɛ, te 'ka 'fʋ 'ka 'ci \"nrɔnnan \"da \"dɩ! ");
INSERT INTO yreNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kɔɔ minnun nɛn wa'a Bali tɔa dɩɛ, -wɛɛ ci \"nrɔnman 'wɩnun zɩɛ -a da. 'Pian 'ka \"tɩ Bali -a -tɔa 'nan, fɛnun zɩɛ -a 'wɩ a 'ka man. ");
INSERT INTO yreNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","'Cee vɛ bɛ, 'ka -wɛɛ 'e tɛdɛ 'nan Bali 'e mingɔnnɛn -blɩ 'ka da. \"Bɛ -sru -e -a 'bɔ 'e 'wɩ pɛɛnɔn zɩɛ -a drɛ 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Te nyɛn 'e 'kɔn 'ka 'ji dɩ! Ka ya \"le 'bla 'pa \"wɛnnɛn 'zʋ. Kɔɔ 'ka \"tɩ Bali 'ka 'si \"va 'nan 'yee mingɔnnɛn trɛ a 'cee vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","'Ka 'ka yɩfɛnun -tan, -e 'ka man \"lala -nɔn 'yalɛ -tɛnɔn lɛ. Fɛ nɛn ya'a srɛman dɩɛ, -a 'bɔ nɛn 'ka -wɛɛ! -Yɛɛ cɩ min yɩfɛ nɛn laji bɛ -a. Crinnɔn 'ka 'pliman fɛ zɩɛ -a -nan dɩ, ɛn fɛ srɛ bɛbɛ 'ka 'nan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kɔɔ fɛnan nɛn min yɩfɛ cɩ bɛ, -a -nan nɛn -yee ci \"nrɔndɩ pɛɛnɔn 'kɔan.» ");
INSERT INTO yreNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«'Ka 'man 'e 'kɔn 'e wʋʋdɩ, ɛn 'cee -kannɛn 'e 'fʋ 'fɔdɩ \"nɛn! ");
INSERT INTO yreNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","'Ka 'kɔn \"le minnun nɛn o cɩ 'o 'tazan -pɛnnan bɛ -wee 'wɩ 'zʋ. Minnun zɩɛ, -te o tazan 'si lɩ 'pa \"fɛdi da 'nan e -ta, ɛn e 'kɔn 'tɛ bɛ, -wɛɛ 'lɛ \"so -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bali -le -fɛa a minnun nɛn Minsan bɔa o man, te o yiɛ a \"man \"bɛ o man. Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'e 'man wʋʋman, -e 'e o -nyran fɛnun -sru, -e 'e -wee fɛ 'pa. ");
INSERT INTO yreNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","E -ta bada oo, ɛn -te 'bɛ \"cɛɛ dɩ, e -ta tʋ \"nɛn \"tʋ -a oo, -te e 'bɔ o man te o yiɛ a \"man \"bɛ, Bali -le -fɛa a o man. ");
INSERT INTO yreNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Maan ve 'cɛɛ 'nan, tʋ nɛn crinzan -taa \"min crin wʋlɛ bɛ, \"te 'kɔn san -a -tɔa \"bɛ, \"te -a man -kɔan 'e wʋʋdɩ tʋ pɛɛnɔn man, ɛn ya'a tʋe -e 'e 'yee 'kɔn 'fɔn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","-Yee \"wɛan 'ka 'bɔ \"nyian 'ka 'man wʋʋ! Kɔɔ Blamin -pɩ -taa tʋ nɛn -a -cin 'ka 'kɔan 'ka 'ji dɩɛ -a man.» ");
INSERT INTO yreNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","-A -nan nɛn Piɛri -a laabʋ Zozi 'lɔ 'nan: «Minsan, -kɔnnɛn \"nɛn yia -fɔ zɩɛ, 'kʋ 'saza 'le vɛ nɛn, -baa min pɛɛnɔn 'le vɛ nɛn?» ");
INSERT INTO yreNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ɛn Minsan \"e 'nan -yrɛ 'nan: «Min 'suzan \"cɛn 'bɛ 'ta wʋla 'e 'san wei da 'wɩ 'tɔdɩ -a? Min 'suzan nɛn -a tazan 'yee 'kɔn 'pɛba 'wʋ -yrɔ, ɛn yaa 'vɩ -yrɛ 'nan, 'e -blɩfɛ -nɔn min 'sunɔn -mienun lɛ 'e 'tʋ -man bɛ -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Min 'suzan zɩɛ -te -a tazan 'bɔ \"man 'wɩ zɩɛ -a drɛnan bɛ, -yee vɛ a \"yi. ");
INSERT INTO yreNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -a tazan -a -tɔa 'e yɩfɛ pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","'Pian -te min 'suzan zɩɛ 'e ci nrɔn 'nan: ‹'An 'tazan -a 'mɔnnan.› Tɔɔn -e 'e 'tɛ 'padɩ 'sia minnun nɛn 'e yiɛ -tɔa \"o va bɛ o da, te e ya \"fɛdi -blɩnan 'saza, ɛn e ya -wɛn mlinnan 'saza. ");
INSERT INTO yreNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tɔɔn yi nɛn -a -cin 'ka \"ji 'nan 'e 'tazan -taa \"dɩɛ, -e 'bɛ bɔla kligli, -e -a tazan 'e \"nɛn \"jɛɛnla 'ji -wlidɩ. E 'wɩ \"nɛn -kɔɔnman -yrɛ \"le zɩ Bali 'wɩ \"nɛn -kɔɔnman minnun nɛn wa'a yi -tɛlɛa 'e da dɩɛ -wlɛ \"bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Min 'suzan nɛn 'e 'tazan 'ci 'sɔ wɩnun -tɔa, 'pian e 'ka \"vale 'e 'ta wʋla \"da \"dɩɛ, waa -sɔan \"kaga 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ɛn \"nyian bɛ, min nɛn e 'wɩ 'tʋ drɛ 'wlidɩ 'e 'tazan lɛ, te ya'a ci 'sɔ wɩnun tɔa dɩɛ, waa -sɔan, 'pian waa -sɔan \"wɛnnɔn. -A -cin 'e 'kɔn 'ka 'ji 'nan, min nɛn Bali fɛ \"kaga \"nɔn -yrɛ \"bɛ, yaa laabo -yrɔ \"nyian \"kaga. Ɛn min nɛn Bali fɛ \"kaga \"pɛba 'wʋ -yrɔ \"bɛ, -a san lɔ nɛn e 'wɩ \"kaga laabo.» ");
INSERT INTO yreNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«'An -ta 'tɛ 'fɔlɛ \"nɛn 'trɛ da. An ya \"vale 'e 'kɔn 'e 'bidɩ 'va. ");
INSERT INTO yreNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","'Pian e ya \"le 'mɛn yra yɩ tʋ 'e bɔ 'vaa, -e 'e 'bidɩ 'sia. 'Bɛ nɛn 'gʋɛ, an ya -a -pɛnnan 'an 'ci le nyɛn -a, 'nan 'wɩ zɩɛ 'e drɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Te 'e 'kɔn 'ka 'ji 'nan 'an -ta 'trɛda, 'nan -e minnun man 'e 'fɔla -trɔɔ dɩ! 'Pian an -ta 'wɩ 'fɔlɛa minnun man. ");
INSERT INTO yreNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Maan ve 'cɛɛ 'nan, -te min a 'soolu 'kɔn 'tʋwli 'lɛ \"nɛn \"bɛ, o \"cɛan 'e cin man 'mɛn \"wɛan. Min yaaga -taa \"kɔnlɛ -pɛ -tʋ -a, -e min \"fli 'o 'kɔn -pɛ -tʋ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ɛn 'nɛn \"tɩ 'lee 'e 'pɩ yei 'ka 'taa -a -blɩlɛ dɩ. Ɛn 'nɛn \"bʋ 'lee 'e lu yei 'ka 'taa -a -blɩlɛ dɩ. Ɛn -sran \"bʋ 'lee 'e 'pɩ nan yei 'ka 'taa -a -blɩlɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Zozi -a 'vɩ \"nyian minnun nɛn -nan bɛ -wlɛ 'nan: «-Te laa wla \"ji yidɛ 'fɔ -nan \"va 'zia bɛ, 'nun tɔɔn kaa ve 'nan, laa \"ta -fɛan, -e 'e drɛ zɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ɛn -te fulɔ nɛn e \"sia 'trɛda \"tre 'zia bɛ, ka 'yɩ \"fɛɛnnan bɛ -a 'yɩ bɛ, 'nun tɔɔn ka ve 'nan, 'tɛdɛ \"ta -daa, -e 'e drɛ zɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ka 'wɩ dra min yiɛ 'lɛ! Fɛ nɛn e \"ta dra 'trɛ da bɛ, 'lee fɛ nɛn e \"ta dra laji bɛ, 'cɛɛ -tɔa. 'Pian 'wɩ nɛn 'an cɩ 'bɛ drɛnan tʋ 'gʋɛ -a bɛ, ka 'ka \"vale 'cɛɛ -tɔa \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ɛn 'wɩ nɛn 'bɛ cɩ tɩglɩ \"le 'cɛɛ drɛ bɛ, ka 'ka \"vale 'cɛɛ tɔa dɩ. -Mɛ \"le \"wɛan nɛn kaa dra zɩ? ");
INSERT INTO yreNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","'Ka 'ci \"nrɔn 'wɩ 'gʋɛ -a da -tʋ! -Te min -tʋ 'i 'sanman drɛ, ɛn ka \"ta -ko -a tin 'balɛ bɛ, 'i 'fɔ 'e 'flin 'i 'ka yei \"sɛn 'e cin va, \"tɔgɔ 'yei 'nɔn tin 'bazan lɛ, -e tin 'bazan 'e 'i 'fɔ -pʋ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Maan ve 'yiɛ 'nan, \"yiɛ vɩnan i bɔla -pʋ 'kɔn zɩɛ -a -ji bɛ, te i cɛɛn \"lala pɛɛnɔn bɔladɩ man.» ");
INSERT INTO yreNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tʋ zɩɛ -a man bɛ, -kɔnmandan Pilati Galile 'nɔn -mienun tɛɛ Zeruzalɛm. E o tɛɛ te o ya Bali -pannan Bali -pan 'kuin. -A -nan nɛn min -mienun -ta 'wɩ zɩɛ -a 'sinan 'palɛ Zozi lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ɛn Zozi \"e 'nan -wlɛ 'nan: «E ya 'ka 'ji 'nan, Galile 'nɔn zɩɛ o 'wɩ 'wlidɩ drɛ e ciɩla Galile 'nɔn -mie -le vɛ da, -le \"wɛan 'wɩ zɩɛ e 'bɔ o man? ");
INSERT INTO yreNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","-Cɛjɛ, e 'ka zɩ \"fo \"dɩ! 'Pian -te ka'a 'silɛ 'wɩ 'wlidɩ \"drɛdɩ man -e 'ka -sɔɔnla Bali -sru \"dɩɛ, ka -kaaman \"le -wee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ɛn \"nyian bɛ, min -fuda 'sɔra nɛn 'kɔn loulou o tɛɛ Siloe bɛ, e ya 'ka 'ji 'nan, o 'wɩ 'wlidɩ drɛ e ciɩla Zeruzalɛm 'nɔn pɛɛnɔn da? ");
INSERT INTO yreNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","-Cɛjɛ, e 'ka zɩ \"fo \"dɩ! 'Pian -te ka'a 'silɛ 'wɩ 'wlidɩ \"drɛdɩ man -e 'ka -sɔɔnla Bali -sru \"dɩɛ, ka -kaaman \"le -wee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ɛn Zozi -kɔnnɛn 'gʋɛ -a -fɔdɩ 'sia. E 'nan: «Min -tʋ -le fijie yiba \"a 'e 'tɔdɩ 'yee rɛzɛn fei. Min zɩɛ e -ta -a 'blʋ -wɛɛlɛ \"man, 'pian ya'a yɩlɛ \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","-A -nan nɛn yaa 'vɩ min nɛn 'e yiɛ -tɔa rɛzɛn fei 'bɔ va bɛ -yrɛ 'nan: ‹Lɛ yaaga nɛn 'gʋ, te 'an -taa fijie yiba 'gʋɛ, -a 'blʋ -wɛɛlɛ \"man, te ma'an ye dɩ. -Yee \"wɛan 'i yiba 'cɛn! Kɔɔ e ya -nan 'e \"tun.› ");
INSERT INTO yreNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ɛn min nɛn 'e yiɛ -tɔa \"fei 'bɔ va bɛ, e 'nan min zɩɛ -yrɛ 'nan: ‹Minsan, 'i 'tʋɩ \"nyian lɛ -tʋ! Maan \"srɔn \"kluman, -e 'an 'bli -sɛn \"man 'dʋ -e 'e ba. ");
INSERT INTO yreNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lɛ pee -te ya'a balɛ dɩɛ, -e 'i 'cɛn.› » ");
INSERT INTO yreNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Zuif 'nɔn 'le 'flinla \"yi bɛ, waa laabo Saba. -A -tʋ da nɛn, te Zozi a Bali -le 'wɩ \"paanan minnun ji -wee cin yɩ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lɩmɔn -tʋ a 'kɔn zɩɛ -a -ji. -A lɛ -fuda 'sɔra 'bɔ, te 'e yra ye -yʋ -wlidɩ \"tʋ -lɔ. -A 'klɔn 'tɔ 'siɛn, ɛn ya'a \"nyian 'kɔlaman wluandɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Zɩ Zozi lɩ zɩɛ -a 'yɩ bɛ, yaa laabʋ, ɛn e 'nan -yrɛ 'nan: «'Yie -cɛ 'e 'si 'i man!» ");
INSERT INTO yreNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","-A -nan nɛn 'e 'pɛ 'pla lɩ zɩɛ -a da. 'Nun tɔɔn ɛn e 'sʋ \"ji, ɛn e Bali 'tɔ bɔdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","'Wɩ nɛn Zozi 'a drɛ bɛ, e 'bli 'fɔ cin yɩ 'kɔn 'tazan ji, kɔɔ Zozi min beli Saba yi da. Ɛn e 'nan minnun lɛ 'nan: «Yi a 'shɛɛdʋ, -a da nɛn blamin 'nyranman \"paa. Yinun zɩɛ -a -tʋ da nɛn, 'ka 'ta, -e 'o 'ka 'beli. 'Pian te 'ka 'ta Saba yi da \"fo \"dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ɛn Minsan \"e 'nan -yrɛ 'nan: «Ka ya min -wlidɩ \"a, ka 'wɩ dra min yiɛ 'lɛ. Saba yi da bɛ, ka \"we \"man, -e min 'e 'yee trʋvɛ baa \"flu 'e 'blɩfɛ -sru, -e 'e 'kʋ 'yi 'nɔn -yrɛ. -Te e ya tri a oo, ɛn te 'bɛ \"cɛɛ dɩ, -te e ya -aflumun a oo, kaa dra zɩ, -njɛɛ dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","'Pian ka 'ka \"vale 'an baa 'si Abraam kluda lɩ 'gʋɛ -a man Saba yi da dɩ. Kɔɔ Satan -a yrɩ -a -nan lɛ -fuda 'sɔra nɛn 'gʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Zɩ Zozi 'wɩ zɩɛ -a 'vɩ bɛ, ɛn 'yra -a 'nanmannɔn 'tɛdɩ 'sia. 'Pian te min pɛɛnɔn 'ci \"nranman 'wɩ \"yi 'tɔ 'tʋdʋ pɛɛnɔn nɛn Zozi a dra bɛ -yee \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","\"Bɛ -sru Zozi -kɔnnɛn \"fɔdɩ 'sia minnun lɛ. E 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -mɛ \"man nɛn 'an -kɔlaman maan -kɔɔnman? ");
INSERT INTO yreNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","E ya \"le min -tʋ 'bɛ fei fɛ 'wlɛ \"wɛnnɛn 'tʋ 'si, ɛn yaa -fɔ 'yee fei. E bɔa -e 'e drɛ yiba \"a, te \"lomannun a o \"kɔɛ \"tɔnan -a plan -ji.» ");
INSERT INTO yreNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ɛn e -kɔnnɛn pee -fɔ \"nyian -wlɛ. E 'nan: «Bali -le mingɔnnɛn -blɩdɩ min da bɛ, -mɛ \"man nɛn 'an -kɔlaman maan -kɔɔnman? ");
INSERT INTO yreNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","E ya \"le lɩmɔn -tʋ 'bɛ -fari puu \"sonun yaaga 'si, e 'mannyan \"wɛnnɔn 'wʋ 'va, ɛn yaa baa. 'Mannyan zɩɛ e -fari -pʋ 'bɔ siiman 'e pɛɛnɔn.» ");
INSERT INTO yreNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","\"Bɛ -sru Zozi Zeruzalɛm si 'sia \"nyian. E -kʋ Bali -le 'wɩ \"paadɩ -a minnun ji 'flanun nɛn -si -a bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ɛn min -tʋ -a laabʋ -yrɔ 'nan: «'An 'san. 'Wɩ 'kpa, min \"nɛn \"wɛnnɛn nɛn Bali -a \"sia 'wɩ 'ji?» Ɛn Zozi -a vɩdɩ 'sia minnun lɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«'Ka man -wɛɛ 'nan 'ka -wlamlan 'kɔn -yrɛ \"fɩɩnɛn 'ji -e 'ka 'belidɩ yɩ! Maan ve 'cɛɛ 'nan, min \"kaga -taa -a man -wɛɛlɛ 'nan 'o -wlamlan 'kɔn zɩɛ -a -ji, 'pian wa'a 'bɔala 'nan nun dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tʋ -tʋ -taa \"bɔlɛ bɛ, -te 'kɔn san \"ta 'yee 'kɔn -fɔa \"ji, te ka -fʋ bei. Ka 'kɔn 'tɛdɩ \"siala, te ka \"ta -a ve -yrɛ 'nan: ‹'Kʋ 'san, 'i 'kɔn 'lɛ 'sʋ 'kʋɛ!› Yaa ve 'cɛɛ 'nan: ‹Ma'an 'ka 'tɔa dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tɔɔn -e 'ka vɩ -yrɛ 'nan: ‹-Kaa fɛ -blɩ 'e cin va, ɛn -kaa 'yi mlin 'e cin va. Ɛn i Bali -le 'wɩ paa 'kʋ fla.› ");
INSERT INTO yreNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","\"Bɛ -sru yaa ve 'cɛɛ 'nan: ‹Ma'an 'ka 'tɔa \"fo \"dɩ. Ka ya 'wɩ 'wlidɩ \"drɛnɔn 'a, 'ka 'si 'an \"srɔn \"kogo!› ");
INSERT INTO yreNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tʋ zɩɛ -a man bɛ, te ka Abraam 'lee Izak 'lee Zago 'lee Bali 'lewei vɩnɔn pɛɛnɔn ye Bali -le mingɔnnɛn trɛda. 'Pian ka -fo bei, -e 'ka -wuɔdɩ 'sia te 'ka 'shɛ da -ble. ");
INSERT INTO yreNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Minnun \"sia yidɛ wluan \"nan 'zia, ɛn o \"sia yidɛ 'fɔ -nan \"va 'zia, ɛn o \"sia 'trɛda lou 'zia, ɛn o \"sia 'trɛda \"tre 'zia, -e 'o \"fɛdi -dan -blɩ Bali -le mingɔnnɛn trɛda. ");
INSERT INTO yreNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Minnun nɛn o -fɔla \"da \"bɛ, o \"kaga -taa \"drɛlɛ -si 'lɛnɔn 'a. Ɛn minnun nɛn o -trɔa -si 'lɛ bɛ, o \"kaga -taa \"drɛlɛ min -fɔla \"danɔn 'a.» ");
INSERT INTO yreNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tʋ zɩɛ -a man bɛ, Farizɛn 'nɔn -mie -ta -a vɩlɛ Zozi lɛ 'nan: «'I 'kʋ, 'i 'si 'gʋ! Erodi a 'i -wɛɛnan 'nan -e 'yei 'tɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ɛn Zozi 'a 'vɩ -wlɛ 'nan: «'Ka 'kʋ -a vɩ -dawlizan 'labɛ -yrɛ 'nan, an -yʋ -wlidɩ -pian \"minnun -sru, ɛn an minnun \"belia cɛɛgʋ 'lee \"trɛ \"a. -A yi yaagazan da -e 'an 'cɛn \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","'Wɩ 'kpa, maan dra cɛɛgʋ, ɛn maan dra \"trɛ, ɛn maan dra \"bɛ -sru. Ɛn an bɔala Zeruzalɛm, kɔɔ -nan nun nɛn Bali 'lewei vɩzan -kaa. ");
INSERT INTO yreNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Zeruzalɛm 'nɔn, ka Bali 'lewei vɩnɔn -tɛɛman. Ɛn minnun nɛn Bali -taa \"waa 'cɛɛ bɛ, ka o -tɛɛman -kɔlɛbu -a. Maan man wɛɛ 'e 'pa -a \"kaga 'nan 'an 'ka treman 'e cin man, \"le zɩ mɛin \"bʋ 'yee 'nɛnnun treman 'e 'pɛba 'wlu bɛ -yee 'wɩ 'zʋ. 'Pian ka'a 'wɩlɛ \"man \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","-Yee \"wɛan Bali \"ta 'e 'pɛ \"sia 'cee Bali -pan 'kɔn -sru. Ɛn 'an 'bɔ 'gʋɛ, ka'a \"nyian 'an 'ye dɩ. 'Pian ka -kɔlaman 'an yɩdɩ -a 'e 'pee yi nɛn kaa vɩdɩ \"siala 'nan: ‹Bali -le -fɛa 'e 'kɔn min nɛn Minsan -a 'pa 'sia bɛ -a man!› » ");
INSERT INTO yreNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Zuif 'nɔn 'le 'flinla \"yi nɛn waa laabo Saba bɛ -a -tʋ da nɛn, Zozi wlala Farizɛn 'nɔn 'tazan -tʋ -le 'kuin 'nan -e 'e fɛ -blɩ. Minnun nɛn 'kɔn zɩɛ -a -ji bɛ, te o yiɛ a Zozi 'va. ");
INSERT INTO yreNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ɛn min -tʋ -ta -tɔlɛ Zozi 'lɛ. Min zɩɛ -a 'kɔlɛ pɛɛnɔn a 'e -tɔɔladɩ -cɛ -tʋ -lɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tɔɔn ɛn Zozi -a laabʋ 'fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn 'lɔ 'nan: «-Mɛ \"wɩ nɛn -cee -pei -a 'vɩ? -Si a 'e 'nɔndɩ min lɛ 'nan 'e 'cɛ 'si min man 'flinla \"yi da?» ");
INSERT INTO yreNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'Pian o 'ka \"vale 'o 'wɩ \"sia \"da \"fo \"dɩ. Tɔɔn Zozi klɛ -cɛzan zɩɛ -a man, ɛn yaa beli. E -si -nɔn -yrɛ, ɛn e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","-A -nan nɛn Zozi -a vɩdɩ 'sia 'fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn lɛ 'nan: «Min -tʋ 'ka 'ka yei, -te -yee 'nɛn 'fɔ 'yi 'klu -ji 'flinla \"yi da bɛ, -e 'e vɩlɛ 'e 'si dɩ. Ɛn -te -yee tri -fɔ 'yi 'klu -ji 'flinla \"yi da bɛ, -e 'e vɩlɛ 'e 'si dɩ. -Njɛɛ dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wa'a -kɔlalɛ -e 'o 'wɩ zɩɛ -a -zi -fɔ -yrɛ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Zozi -a 'yɩ 'nan minnun nɛn o -taa \"bɛ, o -nyrannan tɩglɩ tɩglɩ \"sia, te o -nyɛanla. -A -nan nɛn e -kɔnnɛn 'gʋɛ -a -fɔdɩ 'sia -wlɛ. E 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«-Te min 'i laabʋ 'nan 'i 'lʋ \"fɛdi -blɩ 'e 'va bɛ, te 'i 'nyrannan tɩglɩ 'si dɩ! Kɔɔ -a -mie da bɛ, te min nɛn 'bɛ a min -dan a e -cia 'i da bɛ, wɛɛ laabʋ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Min nɛn e 'ka laabʋ bɛ, yaa ve 'yiɛ 'nan: ‹'I pɛin 'labɛ -a -nɔn min 'gʋɛ -yrɛ!› Tɔɔn te i \"ta wuanla 'yra -a, -e 'i 'kʋ -nyran pɛin -fɔla \"dazan da. ");
INSERT INTO yreNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","-Yee \"wɛan -te min 'i laabʋ 'nan, 'i 'lʋ \"fɛdi -blɩ 'e 'va bɛ, 'i -nyran pɛin -fɔla \"dazan da! Min nɛn yei laabʋ bɛ, -te yei 'yɩ bɛ, -e 'e 'ta -a vɩ 'yiɛ 'nan: ‹An bee, 'i 'ta -nyrannan tɩglɩ 'gʋɛ -a 'si!› -Te e drɛ zɩɛ, min pɛɛnɔn nɛn ka \"ta -nyɛanla waa bɛ, 'yra \"sia 'i yiɛ man o yei.» ");
INSERT INTO yreNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ɛn Zozi -a 'le 'sran 'nan: «Min nɛn 'e 'fli drɛ -dan bɛ, Bali -a dra \"wɛnnɔn. Ɛn min nɛn 'e 'fli drɛ \"wɛnnɔn bɛ, Bali -a dra -dan.» ");
INSERT INTO yreNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","\"Bɛ -sru ɛn Zozi 'wɩ tin 'badɩ 'sia min nɛn e Zozi 'bɔ laabʋ 'nan 'e 'lʋ \"fɛdi -blɩ 'e 'va bɛ, -yrɛ. Yaa 'vɩ -yrɛ 'nan: «-Te 'i \"ta minnun laabo \"fɛdi fɛ man bɛ, te 'i beenun laabʋ dɩ! Ɛn te 'i \"bʋɩnun laabʋ dɩ! Ɛn te 'i 'mangulinun laabʋ dɩ! Ɛn te 'i bɔɛnun fɛnɔn laabʋ dɩ! \"Tɔgɔ -wee vɛ da, -e 'wei laabʋ te 'e drɛ fɛ 'lɛji bɔladɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","'Pian -te 'i \"ta minnun laabo \"fɛdi fɛ man bɛ, 'i 'yalɛ -tɛnɔn laabʋ! Ɛn minnun nɛn -cɛ cɩ o man bɛ 'i o laabʋ! Ɛn minnun nɛn o \"tun \"bo bɛ 'i o laabʋ! Ɛn minnun nɛn o yiɛ 'wi bɛ 'i o laabʋ! ");
INSERT INTO yreNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","-Te i 'wɩ zɩɛ -a drɛ bɛ, Bali -fɛa ve 'i man, kɔɔ wa'a 'lɛji bɔala 'yiɛ dɩ. 'Pian Bali -a 'lɛji bɔala 'yiɛ, tʋ nɛn min tɩglɩ nun wuanla -kanɔn 'va bɛ, -a man.» ");
INSERT INTO yreNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","-A -nan nɛn min -tʋ nɛn fɛ zɩɛ -a -nan bɛ yaa 'vɩ Zozi lɛ 'nan: «Min nɛn e fɛ -ble Bali -le mingɔnnɛn trɛda bɛ, Bali -le -fɛa a -a san man.» ");
INSERT INTO yreNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ɛn Zozi -kɔnnɛn \"tʋ -fɔdɩ 'sia -yrɛ. E 'nan: «Min -tʋ 'bɛ \"ta \"fɛdi -dan dra, ɛn yaa 'wɩ 'vɩ min \"kaga \"lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Zɩ \"fɛdi yi 'bɔ bɛ, ɛn 'e 'suzan 'tʋ 'pa 'sia 'nan 'e 'kʋ o laabʋ. 'E vɩ -wlɛ 'nan: ‹'Ka 'ta! O cɛɛn fɛnun drɛdɩ man.› ");
INSERT INTO yreNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","'Pian o -tʋdʋ pɛɛnɔn 'wɩ 'tʋ 'yɩ, ɛn waa 'vɩ -yrɛ. Min tɛdɛ -a 'vɩ -yrɛ 'nan: ‹An \"sia fei -tʋ 'lɔnan. An \"ta -ko -a -nanjɛnlɛ. -Yee \"wɛan 'i yra 'si, ma'an 'kɔlaman 'lʋdɩ -a dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ɛn -a -tʋ \"e 'vɩ -yrɛ 'nan: ‹An tri 'lɔ -fu. An \"ta -ko o -nanjɛnlɛ, -te o 'nyranman \"paa 'kpa -o. -Yee \"wɛan 'i yra 'si, ma'an 'kɔlaman 'lʋdɩ -a dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ɛn -a pee \"e 'vɩ 'nan: ‹An \"sia lɩ 'panan. -Yee \"wɛan ma'an 'kɔlaman 'lʋdɩ -a dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Min 'suzan zɩɛ e 'li 'e da 'e 'tazan -va. 'Wɩ nɛn o pɛɛnɔn -a 'vɩ bɛ yaa 'sinan 'pa -yrɛ. -A -nan nɛn 'bli 'fɔ -a tazan 'bɔ 'ji, ɛn e 'nan 'e 'suzan lɛ 'nan: ‹'I 'kʋ tada 'fla yei, -e 'i vɩ 'yalɛ -tɛnɔn lɛ, ɛn 'i vɩ minnun nɛn -cɛ cɩ o man bɛ -wlɛ, ɛn 'i vɩ minnun nɛn o yiɛ 'wi bɛ -wlɛ, ɛn 'i vɩ minnun nɛn o \"tun \"bo bɛ -wlɛ, -e 'ka 'ta waa!› ");
INSERT INTO yreNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ɛn min 'suzan zɩɛ e -kʋ \"nyian. Fɔɔnɔn, ɛn e -ta -a vɩlɛ 'e 'tazan lɛ 'nan: ‹'An 'san, 'wɩ nɛn yia 'vɩ bɛ, maan drɛ, 'pian -nyrannan -mie a tian 'nan.› ");
INSERT INTO yreNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","-A -nan nɛn -a tazan -a 'vɩ \"nyian -yrɛ 'nan: ‹'I 'kʋ -siblʋ 'nɛnnun da, ɛn 'i 'kʋ fei -paannun da, -e 'i vɩ minnun lɛ 'nan 'o 'ta. 'I 'tɔ o man, -e 'o 'wɩ \"man, 'dʋ -e 'mɛn 'kuin 'e fa!› » ");
INSERT INTO yreNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ɛn Zozi -a 'le 'sran 'nan: «Maan ve 'cɛɛ 'nan, minnun nɛn Bali o laabʋ, ɛn wa'a 'wɩlɛ \"man \"dɩɛ, o -tʋ 'ka 'taa \"fɛdi -blɩlɛ 'an 'va dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","\"Bɛ -sru ɛn Zozi Zeruzalɛm si 'sia \"nyian. Min yra -a -sru \"kaga 'kpa. -A -nan nɛn Zozi 'e 'man lila, ɛn e 'nan -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Min nɛn e ya \"vale 'e -sɔɔnmlan 'an -sru \"bɛ, 'yaan 'sia e 'mlin 'e \"tɩ 'lee 'e \"bʋ \"da. Ɛn 'yaan 'sia e 'mlin 'e nan 'lee 'yee 'nɛnnun da. Ɛn 'yaan 'sia e 'mlin 'e \"bʋɩnun 'lee e \"blunun \"da. Ɛn 'yaan 'sia e 'mlin 'e 'bɔ 'le 'belidɩ da. -Te ya'a drɛlɛ zɩ dɩɛ, ya'a 'kɔlaman -e 'e drɛ 'an -sruzan 'a \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ɛn \"nyian bɛ, min nɛn e ya \"vale 'e -sɔɔnmlan 'an -sru \"bɛ, 'e 'wɩ yra yɩdɩ man, ɛn 'e 'wɩ -kadɩ man yiba \"plan da! -Te ya'a drɛlɛ zɩ dɩɛ, ya'a 'kɔlaman -e 'e drɛ 'an -sruzan 'a \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","-A -kɔɔn \"man wɩ -tʋ nɛn 'gʋ. Min -tʋ a 'ka yei, ɛn e ya \"vale 'e 'yee 'kɔn -dan -tɔa. Min zɩɛ zɩ 'kɔ 'e drɛ bɛ, yaa \"nrɔnman 'e 'ji 'vaa, ɛn yaa -si \"siala. E 'yee \"lala -nanjɛan, -te e bɔa -yee 'kɔn 'tɔvɛ -a -o. ");
INSERT INTO yreNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","\"Tɔgɔ -te e 'yee 'kɔn 'pʋ -fɔ 'trɛ 'ji bɛ, -e 'e vɩlɛ 'e 'cɛn \"man \"dɩ. Tɔɔn minnun nɛn o 'wɩ zɩɛ -a -nan ye bɛ, waa sɛɛ wʋdɩ \"siala -a vɩdɩ -a 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹Min 'labɛ e 'kɔn 'tɔdɩ 'sia, 'pian ya'a -kɔlalɛ 'cɛndɩ -a \"man \"dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ɛn -a -kɔɔn \"man wɩ -tʋ nɛn \"nyian 'gʋ. Mingɔnnɛn -tʋ \"ta -ko -kuli man mingɔnnɛn -tʋ -va. Mingɔnnɛn zɩɛ zɩ 'kɔ 'e drɛ bɛ, yaa \"nrɔnman 'e 'ji 'vaa, ɛn e -kuli -si \"siala. 'E 'ci \"nrɔnman 'nan, 'yee minnun -kpi fu (10.000) 'gʋɛ, o -pɛ \"sɔa min -kpi yɔ -tʋ (20.000) -a? ");
INSERT INTO yreNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","-Te yaa -tɔ 'nan 'e 'pɛ 'ka 'taa 'sɔlɛ -kuli -a dɩɛ, e minnun \"paa 'sia mingɔnnɛn -tʋ zɩɛ -a va, te 'bɛ a tian 'kɔɔbli. E toba -fɔa -yrɛ 'nan, te 'o 'kuli -tan \"nyian dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ɛn Zozi -a 'le 'sran 'nan: «'Wɩ 'tʋwli zɩɛ -nyrɛn 'e drɛ 'cee vɛ -a! -Te min 'ka 'e 'bli 'silɛ 'yee fɛ pɛɛnɔn da dɩɛ, ya'a 'kɔlaman -e 'e drɛ 'an -sruzan 'a \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","'Wɩ 'kpa, -wɛ a fɛ \"yi \"a. 'Pian -te -wɛ 'nɔnnɔn 'si \"man \"bɛ, -a drɛ vɛ \"ka \"nyian 'nɔnnɔn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","E 'ka \"nyian \"yi fɛ -tʋ drɛ vɛ -a 'trɛda dɩ. Ɛn e 'ka -anglɛ -a dɩ. 'Pian waa wɛɛnman 'e \"tun. Min nɛn 'wɩ man \"trɔɛn cɩ -a -wulo -man bɛ, -a san 'e man!» ");
INSERT INTO yreNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yi -tʋ da 'sukɔlɛ 'sinɔn \"kaga pli Zozi man 'nan -e 'o wei man. Ɛn minnun nɛn o 'tɔ 'wlidɩ \"a \"nyian minnun 'le bɛ, o \"kaga \"ta \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'Wɩ zɩɛ ya'a Farizɛn 'nɔn 'lee 'fluba 'ci vɩnɔn 'ci 'sɔlɛ \"fo \"dɩ. -A -nan nɛn waa vɩdɩ 'sia 'nan: «Min 'labɛ, e ta -kli \"wɩ dra. E 'wɩ 'wlidɩ \"drɛnɔn \"kuan 'e 'pɛ \"fli \"a, ɛn o fɛ -ble waa 'e cin va.» ");
INSERT INTO yreNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","-A -nan nɛn Zozi -kɔnnɛn \"fɔdɩ 'sia -wlɛ. E 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Min -tʋ -le 'bla a -yaa tʋ, ɛn -a -tʋwli \"cɛ 'san \"va. Min zɩɛ yaa dra 'kɔ? Maan ve 'cɛɛ 'nan e 'bla -fuba 'sɔrasiɛn 'wlɛ 'sɔrasiɛn \"tʋe \"bui \"da, -e 'e 'kʋ -a -tʋwli \"nɛn e 'san bɛ -a -wɛɛ. -Njɛɛ dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","-Te yaa yɩ bɛ, -a ci \"nranman 'kpa tɩglɩ. Yaa \"sia -e 'e -fɔ 'e 'plabei da. ");
INSERT INTO yreNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","-Te e 'bɔla \"kɔnnɛn \"bɛ, 'e beenun 'lee 'e \"srɔnnɔn laabo 'e va. Yaa ve -wlɛ 'nan: ‹'Ka 'ta -e -kaa ci 'e \"nran 'e cin va! An 'mɛn 'bla nɛn e 'san bɛ -a 'yɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","'Wɩ 'tʋwli zɩɛ -yɛɛ dra Bali lɛ. -Te min -tʋwli \"cɛ 'si 'wɩ 'wlidɩ \"drɛdɩ man, ɛn 'e 'fli -nɔn Bali lɛ bɛ, Bali ci \"nranman. Ci \"nran nɛn min -tʋwli zɩɛ, yaa -nɔan Bali lɛ bɛ, e \"mlian min -fuba 'sɔrasiɛn 'wlɛ 'sɔrasiɛn nɛn o ya tɩglɩ 'va bɛ -wee ci \"nran nɛn waa -nɔan Bali lɛ bɛ -a da.» ");
INSERT INTO yreNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ɛn Zozi -a 'vɩ \"nyian -wlɛ 'nan: «-Te lɩmɔn -tʋ -le 'lein 'wlɛ a -fu, ɛn -a -tʋwli \"cɛ 'san \"va \"bɛ, e -kannɛn -fɔa \"nɛn, -e 'e 'yee 'kuin \"koodɩ 'sia. Yaa -wɛɛman -trilii, -e 'e yɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","-Te yaa 'yɩ bɛ, 'e \"luenun 'lee 'e \"srɔnnɔn laabo 'e 'va. Yaa ve -wlɛ 'nan: ‹'Ka 'ta -e -kaa ci 'e \"nran 'e cin va! An 'mɛn 'lein 'wlɛ nɛn e 'san bɛ -a 'yɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","'Wɩ 'tʋwli zɩɛ -yɛɛ dra Bali 'le 'pasianɔn nɛn laji bɛ -wlɛ. -Te min -tʋwli \"cɛ 'si 'wɩ 'wlidɩ \"drɛdɩ man, ɛn 'e 'fli -nɔn Bali lɛ bɛ, Bali -le 'pasianɔn 'ci \"nranman.» ");
INSERT INTO yreNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zozi -kɔnnɛn \"tʋ -fɔ \"nyian -wlɛ. E 'nan: «Min -tʋ a, ɛn -yee 'nɛnnun a \"fli. ");
INSERT INTO yreNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yi -tʋ da bɛ, ɛn -a \"tiɛnnɛnzan -a 'vɩ 'e \"tɩ \"lɛ 'nan: ‹'An \"tɩ, 'an 'blɩnan nɛn e -taa \"kɔnlɛ 'mɛn vɛ -a bɛ, 'i -nɔn 'mɛn!› -A -nan nɛn o \"tɩ 'e yɩfɛ cɛɛn 'e cin man -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Yi \"fli, yaa, \"bɛ -sru ɛn -a \"tiɛnnɛnzan 'bɔ 'yee vɛ pɛɛnɔn 'tan. Yaa man \"lala 'si, ɛn e -kʋ -a -blɩlɛ 'fla 'kɔɔbli 'tʋ da, te 'e 'ci 'sɔ wɩnun dra. ");
INSERT INTO yreNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","\"Yɛɛ 'cɛn -a -blɩdɩ man bɛ, te dra -dan 'lɛ \"so 'fla zɩɛ -a da. -A -nan nɛn 'e yra yɩdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ɛn e -kʋ toba -fɔlɛ 'fla zɩɛ -a da min -tʋ lɛ, 'nan -e 'e 'nyranman \"va. Min zɩɛ 'bɛ 'pa 'sia 'nan 'e 'kʋ 'e yiɛ 'tɔ 'yee 'srunun va lua. ");
INSERT INTO yreNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Dra -a -tɛa, e ya \"vale 'e 'srunun -blɩfɛ -ble, 'pian min -tʋ 'ka -a -nɔan -yrɛ \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ɛn 'e 'wulo 'ji \"nrɔndɩ \"sia. Yaa 'vɩ 'e 'ji 'nan: ‹'An \"tɩ \"le 'nyranman 'panɔn 'bɛ fɛ -ble -miɛn, te e o \"kle. 'Pian mɛɛn -kaa \"dra lɔ 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","'Wɩ nɛn an -taa -a drɛlɛ bɛ -nyrɛn 'gʋ. An lia 'an da 'an \"tɩ 'va -e 'an vɩ -yrɛ 'nan: «'An \"tɩ, 'i yra 'si! 'An 'wɩ 'wlidɩ drɛ Bali wlu, ɛn 'an 'wɩ 'wlidɩ drɛ 'yiɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","E 'ka \"le 'waan laabʋ \"nyian 'yie 'nɛn \"fo \"dɩ. 'I yra 'si, 'yian drɛ 'yie 'nyranman 'pazan 'tʋ -a!» › ");
INSERT INTO yreNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","-A -nan nɛn e 'li 'e da 'e \"tɩ 'va. E -fʋ \"kɔnnɛn \"man -kɔɔbli, ɛn -a \"tɩ -a 'yɩ. -Yee 'nɛn nyrinda -sɛn \"da, ɛn e -kʋ -a 'lɛ flan -a. Yaa 'kun, ɛn e -atu -tɛ \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","-A -pɩ \"e -yrɛ 'nan: ‹'An \"tɩ, an 'wɩ 'wlidɩ drɛ Bali wlu, ɛn an 'wɩ 'wlidɩ drɛ 'yiɛ. E 'ka \"le 'waan laabʋ \"nyian 'yie 'nɛn \"fo \"dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","'Pian -a \"tɩ -a 'vɩ 'yee nɔannun lɛ 'nan: ‹'Ka 'ta \"nyiandʋ sɔ -trɛ fɛnyian -a, -e 'ka wʋ 'mɛn 'nɛn 'gʋɛ -a da! 'Ka sɔɔnwlɛ wʋ -a -pɛ 'wlɛ man, -e 'ka 'manwua \"wʋ -a cɛin -man! ");
INSERT INTO yreNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","'Ka 'ta tri -blonɛn bɔadɩ bɛ -a, -e 'kaa -tɛ -yrɛ! E ya \"le -kaa \"fɛdi -blɩ, -e -kaa ci 'e \"nran 'e cin va. ");
INSERT INTO yreNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kɔɔ 'an 'pɩ nɛn kaa ye 'gʋɛ, e -ka, ɛn e fuʋ. E 'san, ɛn maan 'yɩ.› Tɔɔn ɛn o \"fɛdi drɛdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tʋ zɩɛ -a wlu bɛ, te -yee 'nɛn cejenɛnzan a tian fei. Zɩ e 'si fei, e ya -tanan bɛ, \"yɛɛ -pli \"kɔnnɛn \"man bɛ, ɛn e \"dre 'man. ");
INSERT INTO yreNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","-A -nan nɛn e nɔan -tʋ laabʋ, ɛn e \"kɔnnɛn \"wɩ laabʋ -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","'Bɛ 'vɩ -yrɛ 'nan: ‹'I -suannɛn 'bɛ 'ta. 'I \"tɩ tri -blonɛn bɔadɩ bɛ -a -tɛ -yrɛ, 'nan 'wɩ 'tʋ 'ka drɛlɛ -yrɛ \"dɩ -le \"wɛan.› ");
INSERT INTO yreNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","'Wɩ zɩɛ e 'bli 'fɔ \"ji, ɛn e 'ka \"vale 'e -wlamlan \"kɔnnɛn \"dɩ. Tɔɔn ɛn -a \"tɩ 'bɔla. E toba -fɔdɩ 'sia -yrɛ 'nan 'e -wla \"kɔnnɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","'Pian e 'nan 'e \"tɩ \"lɛ 'nan: ‹'An lɛ \"kaga 'kpa nɛn 'gʋ, te 'an 'nyranman \"paa 'yiɛ, ɛn ma'an tian 'li -a vɩlɛ 'yie 'wɩ 'tʋ man -cɛjɛ dɩ. 'Pian yi'a tian bo 'nɛn 'tʋwli \"nɔnlɛ 'mɛn, -e 'kʋ \"fɛdi -blɩ \"va 'kʋ 'vale 'an beenun -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","\"I 'yiɔ, 'wɩ nɛn yia drɛ bɛ -a! 'I 'pɩ nɛn e 'yie \"lala pɛɛnɔn blɩ lɩmɔnnun man bɛ, zɩ e -ta bɛ, ɛn i tri -blonɛn bɔadɩ bɛ -a -tɛ -yrɛ.› ");
INSERT INTO yreNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ɛn -a \"tɩ \"e -yrɛ 'nan: ‹'Mɛn 'nɛn, tʋ pɛɛnɔn man bɛ, i ya 'an 'va 'gʋ, ɛn 'an yɩfɛ pɛɛnɔn bɛ e ya 'yie vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","E ya \"le -kaa \"fɛdi -blɩ, -e -kaa ci 'e \"nran 'e cin va. -Ka'a 'kɔlaman -e -kaa 'wɩ 'pee drɛ \"fo \"dɩ, kɔɔ 'i -suannɛn 'gʋɛ e -ka, ɛn e fuʋ, e 'san, ɛn maan 'yɩ.› » ");
INSERT INTO yreNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","\"Bɛ -sru Zozi -kɔnnɛn \"tʋ -fɔdɩ 'sia 'e -srunɔn lɛ. E 'nan: «Fɛzan -tʋ a, ɛn min -tʋ 'bɛ 'e yiɛ -tɔa -a yɩfɛ pɛɛnɔn 'va. Ɛn minnun -a -nan sɛɛ 'wʋ fɛzan zɩɛ -yrɛ 'nan, min nɛn 'e yiɛ -tɔa -a yɩfɛ va bɛ, yaa \"sia \"va te 'e man wɩ dra -a. ");
INSERT INTO yreNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","-A -nan nɛn fɛzan -a laabʋ, ɛn e 'wɩ 'gʋɛ -a laabʋ -yrɔ. E 'nan: ‹-Mɛ \"wɩ nɛn maan 'man 'i man 'gʋ? Yi'a 'kɔlaman -e 'i 'fʋ 'an yɩfɛ da \"nyian \"fo \"dɩ. -Yee \"wɛan 'nyranman pɛɛnɔn nɛn yia 'pa bɛ, 'i -sru \"vɩ 'mɛn!› ");
INSERT INTO yreNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ɛn min nɛn 'e yiɛ -tɔa -a yɩfɛ va bɛ, 'e 'ci \"nrɔndɩ 'sia. Yaa 'vɩ 'e 'ji 'nan: ‹'An 'san \"ta 'mɛn 'nyranman \"sia 'an 'lɔ. -Mɛ \"nɛn an -taa -a drɛlɛ \"mɛn? 'An \"koe \"ka -e 'an fei 'pa dɩ, ɛn 'tra 'tɛdɩ 'yra 'an -tɛa. ");
INSERT INTO yreNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","'Pian 'wɩ nɛn 'kɔ 'an drɛ -e minnun 'o 'an yɩ \"yi \"bɛ, maan -tɔa. 'Wɩ zɩɛ -a 'bɔ nɛn maan dra, 'bɛ 'le vɛ bɛ, -te 'an 'san 'si 'an man bɛ, -e minnun 'waan 'kun 'o 'pɛ \"fli \"a 'wee \"kɔnnɛn.› ");
INSERT INTO yreNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","-A -nan nɛn minnun nɛn -a san -le fiɛn cɩ o da bɛ, e o laabʋdɩ 'sia 'tʋdʋ. Yaa laabʋ -a tɛdɛ -lɔ 'nan: ‹'An 'san -le fiɛn a 'i da wɛa?› ");
INSERT INTO yreNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","\"Bɛ -yrɛ 'nan: ‹E ya 'nyrɔn \"tugu -yaa tʋ!› Ɛn e -yrɛ 'nan: ‹'I 'yie 'fluba 'si, 'i -nyran \"nyiandʋ, -e 'i crɛn -tɛ -fuba 'soolu!› ");
INSERT INTO yreNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","\"Bɛ -sru yaa laabʋ \"nyian -a -tʋ -lɔ 'nan: ‹Bii \"nun? E ya \"yie 'lɔ wɛa?› \"Bɛ -yrɛ 'nan: ‹E ya 'saa 'wlɛ 'plablu -yaa tʋ.› Ɛn e -yrɛ 'nan: ‹'I 'yie 'fluba 'si, -e 'i crɛn -tɛ -fuba 'sɔra!› » ");
INSERT INTO yreNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ɛn Zozi -a 'le 'sran 'e -srunɔn lɛ 'nan: «Min 'suzan 'wlidɩ zɩɛ, e 'wɩ 'tɔ wɩ drɛ. Maan ve 'cɛɛ 'nan, minnun nɛn wa'a Bali tɔa dɩɛ, o 'wɩ -tɔa 'o cin yei e \"mlian minnun nɛn o cɩ Bali -le vɛ -a bɛ o da. ");
INSERT INTO yreNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","-Yee \"wɛan 'wɩ zɩɛ -a da nɛn 'ka 'ci \"nrɔn -e 'ka 'wɩ drɛ! 'Ka bee -wɛɛ \"lala nɛn e ya 'wɩ 'wlidɩ 'tɔ 'tʋdʋ pɛɛnɔn pou -a bɛ -a! -Te ka 'wɩ zɩɛ -a drɛ bɛ, tʋ nɛn \"lala 'wɩ 'ka 'kɔan \"nyian dɩɛ, o 'ka \"kuan 'o 'pɛ \"fli \"a Bali fla. ");
INSERT INTO yreNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","-Te min drɛ wɩ a tɩglɩ 'wɩ 'sɛzɛnɛn pɛɛnɔn 'ji bɛ, min drɛ wɩ -kɔan tɩglɩ 'wɩ -dandan ji. Ɛn -te min -dawli ye \"yi 'wɩ 'sɛzɛnɛn pɛɛnɔn 'ji bɛ, min -dawli ye \"yi 'wɩ -dandan ji. ");
INSERT INTO yreNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","-Yee \"wɛan -te minnun 'ka yi -tɛlɛa 'ka da \"lala nɛn e ya 'wɩ 'wlidɩ 'tɔ 'tʋdʋ pɛɛnɔn pou -a bɛ -a va dɩɛ, Bali 'ka fɛ nɛn e cɩ tɩglɩ bɛ -a nɔan 'cɛɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ɛn -te minnun 'ka yi -tɛlɛa 'ka da fɛ nɛn e 'ka 'cee vɛ -a dɩɛ -a va dɩɛ, fɛ nɛn Bali -a 'pla 'cee vɛ -a bɛ, ya'a nɔan 'cɛɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Maan ve 'cɛɛ 'nan, nɔan -tʋ 'ka 'kɔlaman -e 'e min \"fli 'su 'e cin -a dɩ. E lɛaman -a -tʋ man, te ya'a -tʋ ye \"yi \"dɩ. Fɛ -le \"wɛan nɛn an 'wɩ zɩɛ -a 'vɩ bɛ, min nɛn e \"lala ye \"yi \"bɛ, ya'a 'kɔlaman -e 'e Bali yɩ \"yi \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farizɛn 'nɔn nɛn -nan bɛ, zɩ o 'wɩnun zɩɛ -a 'man bɛ, ɛn o Zozi 'shɛ blɩ. Kɔɔ o \"lala ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","-A -nan nɛn Zozi \"e 'nan -wlɛ 'nan: «'Ka 'fli dra min yiɛ lɛ min tɩglɩnun -a. 'Pian Bali 'cee ci \"nrɔndɩ ye. Ɛn fɛ nɛn minnun -a \"siala 'nan, ka ya 'wɩ -dan drɛnan bɛ, Bali \"le 'va bɛ, e ya 'wɩ 'wlidɩ \"a \"fo. ");
INSERT INTO yreNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","-Pei -tɔ wɩnun nɛn Bali -a -nɔn Moizi lɛ bɛ, 'lee 'wɩnun nɛn Bali 'lewei vɩnɔn 'a 'vɩ bɛ, -a da nɛn minnun 'ta 'wʋla -trilii ɛn Zan -ta. 'Pian zɩ e -ta bɛ, ɛn Bali -le 'wɩ 'nɔnnɔn nɛn 'nan -yee mingɔnnɛn -blɩdɩ 'bɔ 'kogo bɛ, waa vɩdɩ 'sia minnun lɛ. -A -nan nɛn minnun \"kaga -a \"vale 'nan Bali 'e mingɔnnɛn -blɩ 'o da. ");
INSERT INTO yreNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","'Pian -te labli 'lee 'trɛ 'ka tian 'nyanlɛ dɩɛ, te -pei -le 'wɩ \"wɛnnɛn 'tʋwli 'ka tian 'silɛ \"da \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","-Yee \"wɛan min nɛn e 'si 'e nan man ɛn e lɩ pee 'pa bɛ, te e lɩ wɛɛ 'e nan ceje man. Ɛn \"nyian bɛ, min nɛn e lɩ nɛn -a -sran -a 'bɔla bɛ -a 'pa bɛ, te min nan wɛɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","\"Bɛ -sru Zozi -kɔnnɛn \"tʋ -fɔ \"nyian. E 'nan: «Fɛzan -tʋ a. Min zɩɛ mingɔnnɛnnun da sɔ nɛn -a 'flɛ cɩ bɛ, -nyrɛn yaa wo. Ɛn tʋ -tʋdʋ pɛɛnɔn man te -a ci a 'e 'sɔdɩ, te e \"fɛdi -ble. ");
INSERT INTO yreNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ɛn 'yalɛ -tɛzan -tʋ a \"nyian. Wɛɛ laabo Laza. Min zɩɛ mlɔn \"a -a 'kɔlɛ pɛɛnɔn da. Ɛn e ya 'e nyinnandɩ fɛzan zɩɛ -yee -klɔn -yrɛ \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","E ya \"vale 'e fɛzan 'nɛan pɔnnɛn nɛn e -sɛanla bɛ -a -ble. 'Pian min -tʋ 'ka -a -nɔnlɛ -yrɛ \"dɩ. E ya 'e nyinnandɩ fɛ zɩɛ -a -nan, te -plɛnnun -a mlɔnnun 'ji flanman. ");
INSERT INTO yreNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yi -tʋ 'bɔ ɛn 'yalɛ -tɛzan zɩɛ e -ka. -A -nan nɛn Bali -le 'pasianɔn -a 'si, o -kʋ -a Abraam \"srɔn. \"Bɛ -sru ɛn fɛzan \"e \"ka 'wʋ \"nyian, ɛn wɛɛ 'wʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Zɩ e 'bɔla -yremo fla bɛ, ɛn 'e yra yɩdɩ 'sia. -A -nan nɛn 'e yiɛ 'tɔ lou, ɛn e Abraam 'yɩ 'kɔɔbli, te Laza yra -a \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ɛn e -paandɩ 'sia. E 'nan: ‹'Kʋ tra Abraam, 'an nyrinda 'e 'sɛn 'i da! 'I yra 'si, 'i Laza 'pa 'sia 'e 'ta 'e 'pɛ 'wlɛ wʋ 'yia, -e 'e 'tɔ 'an 'le! Kɔɔ 'an ya 'an yra yɩnan 'tɛ 'gʋɛ -a va.› ");
INSERT INTO yreNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ɛn Abraam \"e -yrɛ 'nan: ‹'Mɛn 'nɛn, -a -cin 'e 'tɔ 'i 'ji 'nan, tʋ nɛn i ya 'trɛda bɛ i \"yi 'yɩ, te Laza \"e yra ye. -Yee \"wɛan 'bɛ nɛn 'gʋɛ, -a \"sii tʋ 'bɔ ɛn 'yie yra yɩ tʋ 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɛn \"nyian bɛ -klu -dan -kaa cɛɛn 'e cin man. -Te min a \"vale 'nan 'e \"sia 'kʋ 'va 'gʋ -e 'e 'lʋ 'ka 'va nun bɛ, ya'a 'kɔlaman -a drɛdɩ -a dɩ. Ɛn -te min a \"vale 'nan 'e \"sia 'ka 'va nun -e 'e 'ta 'kʋ 'va 'gʋɛ, ya'a 'kɔlaman -a drɛdɩ -a dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tɔɔn fɛzan -a 'vɩ -yrɛ 'nan: ‹'Kʋ tra Abraam, 'pian mɛin trʋ \"baa, 'i Laza 'pa 'sia 'an \"tɩ \"le \"kɔnnɛn! ");
INSERT INTO yreNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","'An \"bʋɩnun a 'soolu, -e 'e 'wɩ tin 'ba -wlɛ, \"tɔgɔ 'o 'ta fɛnan nɛn 'an yra ye 'gʋɛ -a -nan.› ");
INSERT INTO yreNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ɛn Abraam \"e -yrɛ 'nan: ‹Bali -le -pei -tɔ wɩnun nɛn yaa -nɔn Moizi lɛ bɛ, e ya o va nun. Ɛn 'wɩnun nɛn Bali 'lewei vɩnɔn 'a 'vɩ bɛ, e ya o va nun. 'O \"trɔɛn \"tɔ -yrɛ -e 'o 'ta wʋla \"da!› ");
INSERT INTO yreNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ɛn fɛzan -a 'vɩ -yrɛ 'nan: ‹'Kʋ tra Abraam, 'bɛ 'ka 'bɔa waa \"fo \"dɩ. 'Pian -te min 'si -kanɔn 'va, ɛn e -kʋ 'wɩ tin 'balɛ -wlɛ \"bɛ, waa wei maan. O \"sia 'wɩ 'wlidɩ \"drɛdɩ man, -e 'o -sɔɔnla Bali -sru.› ");
INSERT INTO yreNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","-A -nan nɛn Abraam -a 'vɩ -yrɛ 'nan: ‹-Te wa'a 'o \"trɔɛn 'tɔa Bali -le -pei -tɔ wɩnun nɛn yaa -nɔn Moizi lɛ bɛ -yrɛ \"dɩɛ, ɛn -te wa'a 'o \"trɔɛn 'tɔa 'wɩnun nɛn Bali 'lewei vɩnɔn 'a 'vɩ bɛ -yrɛ \"dɩɛ, te wa'a 'kɔlaman \"nyian -e 'o \"trɔɛn \"tɔ min nɛn e 'si -kanɔn 'va bɛ -a wei lɛ dɩ.› » ");
INSERT INTO yreNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","\"Bɛ -sru ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «'Wɩnun nɛn o -kɔlaman o min \"sia Bali -sru \"bɛ, o ya 'trɛda \"kaga. 'Pian min nɛn yaa drɛ ɛn 'wɩ zɩɛ 'e bɔ min -tʋ man bɛ, 'wɩ -taa \"bɔlɛ -a san man. ");
INSERT INTO yreNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","E ya \"le 'o -kɔlɛbu -fɔ min zɩɛ -a 'klan, -e 'o tuʋ jemie -va. 'Bɛ \"yi mlin, \"tɔgɔ 'e drɛ -e 'mɛn 'nɛn 'tʋ 'e 'si 'an -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","'Ka drɛ \"yi 'ka 'fli -va! -Te 'i \"bʋɩ -tʋ 'wɩ 'wlidɩ drɛ bɛ, 'i 'wɩ tɩglɩ tin 'ba -yrɛ. -Te yaa -tɔ 'e 'fli -lɔ bɛ, -e 'i man wɩ 'cɛ! ");
INSERT INTO yreNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ɛn -te e 'wɩ 'wlidɩ drɛ 'yiɛ 'e 'pa -a 'sɔravli yidɛ 'wlɛ 'tʋwli 'wlu, te e lia 'e da 'i 'va 'e 'pa -a 'sɔravli, te yaa ve 'yiɛ 'e 'bɔ 'a bɛ, 'i man wɩ 'cɛ!» ");
INSERT INTO yreNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","-A -nan nɛn Zozi 'le 'pasianɔn -a 'vɩ Minsan 'bɔ lɛ 'nan: «'I 'kʋe yi -tɛradɩ 'i da 'pa \"da!» ");
INSERT INTO yreNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ɛn Minsan \"e 'nan: «-Te 'cee yi -tɛradɩ Bali da a \"wɛnnɔn \"le fei fɛ 'wlɛ 'tʋ -le 'wɩ 'zʋ bɛ, kaa ve yiba -dan 'gʋɛ -yrɛ 'nan: ‹'I 'sʋra, 'i 'kʋ -tɔ jemie -va›, yaa dra.» ");
INSERT INTO yreNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«'Ka 'ci \"nrɔn 'wɩ 'gʋɛ -a da! 'Cee nɔan a, ɛn e 'nyranman \"paa 'cee fei, -te 'bɛ \"cɛɛ dɩ, 'e yiɛ -tɔa 'cee -winun va. Min -tʋ 'ka 'ka yei, -te nɔan zɩɛ e 'si lua, e -ta bɛ, -e 'e vɩ -yrɛ 'nan: ‹'I 'ta \"nyiandʋ -nyran fɛ -sru \"dɩ?› ");
INSERT INTO yreNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'Pian yaa ve -yrɛ 'nan: ‹'I fɛnun -tɔɛn \"nyiandʋ, 'i 'man wʋʋ, -e 'i 'ta 'mɛn fɛ 'pa! -Te an fɛ blɩ, an 'kan, ɛn an 'yi mlin bɛ, -e 'i 'yie vɛ -blɩ.› ");
INSERT INTO yreNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ɛn \"nyian bɛ, min -tʋ 'ka 'yee nɔan muo 'fɔa 'nyranman nɛn yaa 'pa bɛ -a man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Zɩ ka cɩ Bali lɔ zɩɛ. -Yee \"wɛan -te ka cɛɛn Bali -le 'nyranman nɛn e 'nan 'ka 'pa bɛ -a man bɛ, 'ka vɩ 'nan: ‹Nɔan \"tun \"nɛn 'kʋa. 'Wɩ nɛn e cɩ \"le 'kʋ drɛ bɛ, -a 'bɔ nɛn kʋa drɛ.› » ");
INSERT INTO yreNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Te Zozi a -kʋnan Zeruzalɛm zia bɛ, e ciɩladɩ 'sia Samari 'lɛglɔn 'lee Galile 'lɛglɔn yei. ");
INSERT INTO yreNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Zɩ Zozi \"ta bɔala 'fla 'tʋ da bɛ, ɛn -kogobe -tɛnɔn 'fu -ta -a 'lɛ. O -fʋ \"man \"kɔɔbli, ");
INSERT INTO yreNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ɛn o -paandɩ 'sia -yrɛ. Waa 'vɩ 'nan: «'Kʋ 'san Zozi! 'I yra 'si! 'I 'kʋ nyrinda 'si!» ");
INSERT INTO yreNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Zɩ Zozi o 'yɩ bɛ, ɛn e 'nan -wlɛ 'nan: «'Ka 'kʋ 'ka 'fli -kɔɔn Bali -pannɔn lɛ.» \"Wɛɛ -kɔn -kʋnan -sia bɛ, ɛn -kogobe 'si o pɛɛnɔn man. ");
INSERT INTO yreNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Zɩ o va min -tʋ -a 'yɩ 'nan, -kogobe 'si 'e man bɛ, ɛn e 'li 'e da Zozi 'va. E Bali 'tɔ bɔdɩ 'sia wei 'plɛblɛ 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Zɩ e 'bɔ Zozi man bɛ, ɛn e \"po sɔɔn \"wlu, 'e yra blula, ɛn yaa muo \"fɔdɩ 'sia. Min zɩɛ e \"sia Samari, Zuif min \"cɛɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ɛn Zozi -a laabʋ minnun lɔ 'nan: «-Kogobe 'si min -fu bɛ, o pɛɛnɔn man. Ɛn min 'sɔrasiɛn a nyin zia? ");
INSERT INTO yreNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","-Mɛ \"le \"wɛan nɛn min nɛn e 'ka Zuif min -a dɩɛ, -yɛɛ 'si o yei, ɛn e -ta Bali 'tɔ \"yi \"vɩlɛ?» ");
INSERT INTO yreNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","-A -nan nɛn Zozi -a 'vɩ min zɩɛ -yrɛ 'nan: «'I 'wluan, 'i 'kʋ! I yi -tɛra 'an da, -yee \"wɛan 'i beli.» ");
INSERT INTO yreNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farizɛn 'nɔn -a laabʋ Zozi 'lɔ 'nan: «Tʋ \"cɛn \"man nɛn Bali mingɔnnɛn -blɩdɩ \"siala?» Ɛn e -wlɛ 'nan: «Bali -le mingɔnnɛn -blɩdɩ 'ka 'taa \"le fɛ nɛn waa ye bɛ -yee 'wɩ 'zʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ɛn wa'a 'kɔlaman -e 'o vɩ 'nan, -yɛɛ 'bɔla -miɛn dɩ, ɛn -yɛɛ 'bɔla 'gʋ dɩ. Maan ve 'cɛɛ 'nan Bali mingɔnnɛn -blɩdɩ 'sia 'ka yei 'va.» ");
INSERT INTO yreNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","\"Bɛ -sru ɛn Zozi -a 'vɩ 'e -srunɔn lɛ 'nan: «Tʋ -tʋ -taa \"bɔlɛ bɛ, te ka ya \"va 'nan 'ka Blamin -pɩ ye. -Te e ya yi -tʋwli \"cɛ \"a oo, ka ya \"vale 'ka ye -kpɔ, 'pian ka'a 'kɔlaman -a yɩdɩ -a \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tʋ zɩɛ -a man nɛn minnun -a ve 'cɛɛ 'nan, e ya -miɛn, ɛn e ya 'gʋ. 'Pian te 'ka 'kʋ -nan dɩ, ɛn te 'ka sɔɔnla o -sru \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kɔɔ tʋ nɛn Blamin -pɩ -taa \"man \"bɛ, e -taa \"le laa -paan \"le 'wɩ 'zʋ. E 'wlei -wlei -fɔa, -e -a -san 'e labli 'cɛn 'ji \"fo. ");
INSERT INTO yreNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","'Pian e ya \"le Blamin -pɩ 'e yra yɩ, ɛn -naagʋnɔn 'o 'nan \"man 'vaa, -e 'wɩ zɩɛ 'e drɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tʋ nɛn Blamin -pɩ -taa \"man \"bɛ, 'wɩnun nɛn minnun -a drɛ 'li Noe tʋ va bɛ, waa dra \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kɔɔ Noe tʋ va bɛ, minnun fɛ blɩ, o -wɛn mlin, o lɩ 'pa, ɛn o -kɔnnɛn 'pa. Waa drɛ zɩɛ -trilii, ɛn tʋ nɛn Noe -wlamlan -klʋ -dan ji bɛ e 'bɔ. Tʋ zɩɛ -a man nɛn laa -dan fɛndɩ 'sia, ɛn o pɛɛnɔn 'nan -nyan. ");
INSERT INTO yreNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ɛn \"nyian bɛ, 'wɩnun nɛn minnun -a drɛ 'li Lɔt tʋ va bɛ, waa dra \"nyian. Minnun fɛ blɩ, o -wɛn mlin, o fɛnun lɔɔ, o fɛnun taan, o feinun paa, o 'kɔnnun tɔɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","'Pian yi nɛn Lɔt 'si Sodɔm bɛ, -a -nan nɛn Bali 'tɛ 'lee 'tɛ nyin nɛn -a -koei \"min -tɛa \"bɛ, -a -fɛn laa 'a 'fla zɩɛ -a da. Ɛn o pɛɛnɔn 'nan -nyan. ");
INSERT INTO yreNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","'Wɩ 'tʋwli zɩɛ -a 'bɔ nɛn minnun -kɔan -a drɛnan, ɛn Blamin -pɩ -taa. ");
INSERT INTO yreNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tʋ zɩɛ -a man bɛ, min nɛn e cɩ 'yee 'kɔn 'lɛ \"nɛn \"bɛ, te 'e -wla 'kuin fɛ -tʋ 'sinan dɩ! Ɛn min nɛn fei bɛ, te 'e li 'e da 'fla dɩ! ");
INSERT INTO yreNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","'Wɩ nɛn 'li e 'bɔ Lɔt nan man, te 'e yiɛ 'tɔ 'e koda bɛ, 'e 'wɩ 'cin -trɔa 'ka 'ji! ");
INSERT INTO yreNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Min nɛn e cɩ 'e 'ladɩ 'yee 'trɛda da bɛ, ya'a ye dɩ. 'Pian min nɛn 'e 'pɛ 'si 'yee 'trɛda da \"fo, ɛn yaa -nɔn 'mɛn bɛ, -a san 'bɛ 'belidɩ nɛn ya'a 'nyaan dɩɛ -a ye.» ");
INSERT INTO yreNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ɛn Zozi -a 'le 'sran 'nan: «Maan ve 'cɛɛ 'nan, -pei zɩɛ -a man bɛ, min \"fli -kɔan 'o nyinnandɩ -saa -tʋwli \"da, waa -tʋ \"siala, -e -a -tʋ \"e -fʋʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ɛn lɩmɔn \"fli -kɔan \"fɛ -sɔnnan, waa -tʋ \"siala, -e -a -tʋ \"e -fʋʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ɛn min \"fli -kɔan fei -tʋwli \"da, waa -tʋ \"siala, -e -a -tʋ \"e -fʋʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","-A -nan nɛn Zozi -srunɔn -a laabʋ -yrɔ 'nan: «'Kʋ 'san! 'Wɩ zɩɛ nyin zia nɛn e dra?» Ɛn e 'nan -wlɛ 'nan: «Fɛnan nɛn -wi -kadɩ cɩ 'e pladɩ bɛ, -a ta lou \"nɛn -wi pɛa \"blɩ \"lomannun 'o 'ble!» ");
INSERT INTO yreNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","\"Bɛ -sru ɛn Zozi -kɔnnɛn \"tʋ -fɔdɩ 'sia -wlɛ. E ya \"vale 'e -kɔɔnman -wlɛ 'nan 'o Bali trʋ 'ba tʋ pɛɛnɔn man, te o \"koe 'e 'nyan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","E 'nan -wlɛ 'nan: «'Fla 'tʋ da bɛ, tin 'bazan 'tʋ a -nan. Min zɩɛ ya'a 'klan man Bali lɔ dɩ, ɛn -a yiɛ 'ka 'naan min man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ɛn -cale -tʋ a \"nyian 'fla -tʋwli 'bɔ zɩɛ -a da. Tʋ pɛɛnɔn man bɛ, e -taa 'yee 'wɩ 'a tin 'bazan zɩɛ -yrɛ. Yaa ve -yrɛ 'nan, 'e 'tɔ 'e -sru -e 'yee tin 'e 'tɛ 'e 'nanmanzan da. ");
INSERT INTO yreNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","-A -nan 'mɔn 'wɩ zɩɛ -a drɛnan, te ya'a -yee tin 'baa \"fo \"dɩ. 'Pian zɩ yi -tʋ 'bɔ bɛ, ɛn 'e 'ci \"nrɔndɩ 'sia. Yaa 'vɩ 'e 'ji 'nan: ‹Ma'an 'klan man Bali lɔ dɩ. Ɛn 'an yiɛ 'ka 'naan min man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","'Pian -cale 'gʋɛ, e see \"paa 'an man \"bʋʋ, -yee \"wɛan an -yee tin dra 'nɔnnɔn. Maan dra zɩɛ -e 'e vɩlɛ 'e 'wɩ 'wlidɩ \"drɛ 'mɛn dɩ.› » ");
INSERT INTO yreNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ɛn Minsan -a 'le 'sran -wlɛ 'nan: «'Wɩ nɛn tin 'bazan 'wlidɩ zɩɛ e 'sia -a vɩnan bɛ, kaa 'man 'kpa? ");
INSERT INTO yreNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","E ya 'ka 'ji 'nan, minnun nɛn Bali o 'si \"va 'yee vɛ -a te o -paanman -yrɛ \"tʋ pɛɛnɔn man bɛ, 'e \"trɔɛn \"sia o va? -Cɛjɛ, ya'a dra \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Maan ve 'cɛɛ 'nan, Bali 'ka 'mɔan dɩ, te e -tɔ o -sru -e 'e tin 'nɔnnɔn 'nɔn -wlɛ. 'Bɛ a zɩ, 'pian tʋ nɛn Blamin -pɩ -taa \"nyian 'trɛda bɛ, e bɔa minnun nɛn o yi -tɛra Bali da bɛ o man?» ");
INSERT INTO yreNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Zozi -kɔnnɛn \"tʋ -fɔdɩ 'sia minnun nɛn 'o 'fli \"siala min tɩglɩnun -a, te wa'a 'o bɔɛnun siala min tɩglɩnun -a dɩɛ, o man. E 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Min \"fli 'bɛ 'kʋ Bali trʋ 'balɛ Bali -pan 'kuin. Min -tʋ a Farizɛn min -a, ɛn -a -tʋ a 'sukɔlɛ 'sizan 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farizɛn min a 'e 'tɔdɩ lou, ɛn e Bali trʋ 'badɩ 'sia 'e 'ji. E 'nan: ‹Bali, mɛin muo -fɔa 'nan an 'ka \"le min peenun -le 'wɩ 'zʋ dɩ. Kɔɔ o crin wo, ɛn o ya 'wɩ 'wlidɩ \"drɛnɔn 'a, ɛn o ya min nan -wɛɛnɔn 'a. Ɛn \"nyian bɛ mɛin muo -fɔa 'nan an 'ka \"le 'sukɔlɛ 'sizan 'labɛ -yee 'wɩ 'zʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kɔɔ an fɛ \"sɔan yi \"fli 'flɛ 'tʋ -ji, ɛn fɛ pɛɛnɔn nɛn maan ye bɛ, maan -fuzan -nɔan 'yiɛ.› ");
INSERT INTO yreNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tʋ zɩɛ -a wlu bɛ te 'sukɔlɛ 'sizan a 'e 'tɔdɩ -kɔɔbli, ɛn e ya Bali trʋ 'banan. 'E 'wulo -fɔ 'e 'wlu, ɛn 'e 'pɛ 'pa 'e 'kɔlɛ \"nɛn. Ɛn yaa vɩdɩ 'sia 'nan: ‹Bali 'i yra 'si! 'Wɩ 'wlidɩ \"drɛzan nɛn maan, 'yian nyrinda 'si!› » ");
INSERT INTO yreNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ɛn Zozi -a 'le 'sran 'nan: «Maan ve 'cɛɛ 'nan, 'sukɔlɛ 'sizan zɩɛ, 'o 'vale Bali -a o yei \"sɛn 'e cin va, ɛn e -kʋ 'yee \"kɔnnɛn. 'Pian Farizɛn min 'lee Bali yei 'ka 'sɛnlɛ 'e cin va dɩ. Kɔɔ min nɛn 'e 'fli \"siala -dan bɛ, Bali -a dra \"wɛnnɔn. Ɛn min nɛn 'e 'fli drɛ \"wɛnnɔn bɛ, Bali -a dra -dan.» ");
INSERT INTO yreNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yi -tʋ bɛ, ɛn minnun -tadɩ 'sia nannannun -a Zozi lɛ, 'nan -e 'e klɛ o man. 'Pian zɩ -a -srunɔn 'wɩ zɩɛ -a -nan 'yɩ bɛ, ɛn o -si -tɔ -wlɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","-A -nan nɛn Zozi nannannun laabʋ 'e 'va, ɛn e 'nan 'e -srunɔn lɛ 'nan: «'Ka nannannun 'tʋɩ 'o 'ta 'an 'va! Te 'ka 'si -tɔ -wlɔ \"dɩ! Kɔɔ minnun nɛn \"le nannannun -le 'wɩ 'zʋ bɛ, Bali -le mingɔnnɛn trɛda si a 'e 'lɛ 'sʋdɩ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, minnun nɛn wa'a yi tɛala Bali da \"le zɩ nannannun yi -tɛala 'o \"tɩ \"da bɛ -yee 'wɩ 'zʋ dɩɛ, Bali 'ka mingɔnnɛn ble o da \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","\"Bɛ -sru ɛn min tazan -tʋ -ta 'wɩ laabʋlɛ Zozi 'lɔ. E 'nan: «Bali -le 'wɩ \"paazan, i ya min tɩglɩ 'a. Maan dra 'kɔ, -e 'an 'belidɩ nɛn ya'a 'nyaan dɩɛ, -a yɩ?» ");
INSERT INTO yreNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ɛn Zozi \"e 'nan -yrɛ 'nan: «-Mɛ \"le \"wɛan nɛn, yia ve 'nan an ya min tɩglɩ 'a? Min -tʋ 'ka tɩglɩ dɩ, -te ya'a 'silɛa Bali -tʋwli \"a dɩɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Bali -le -pei -tɔ wɩnun 'gʋɛ, yia -tɔa. -Nyrɛn 'nan: ‹Te 'i min nan -wɛɛ \"dɩ! Te 'i drɛ min -tɛzan -a dɩ! Te 'i crin wʋ dɩ! Te 'i 'wlu 'sɛn min man dɩ! 'I yiɛ 'e 'nan 'i \"tɩ 'lee 'i \"bʋ \"man!› » ");
INSERT INTO yreNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ɛn e 'nan Zozi lɛ 'nan: «'Wɩ pɛɛnɔn zɩɛ, maan drɛdɩ 'sia 'an \"wɛnnɛn da, ɛn an drɛ ceje.» ");
INSERT INTO yreNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Zɩ Zozi 'wɩ zɩɛ -a 'man bɛ, ɛn e 'nan -yrɛ 'nan: «'Pian 'yie 'wɩ 'fʋ -tʋ. -Nyrɛn 'nan, 'i 'yie fɛnun pɛɛnɔn 'tan, -e 'i man \"lala -pli 'yalɛ -tɛnɔn man. -Te yaa drɛ zɩɛ, laji fɛnun nɛn, wa'a srɛman dɩɛ, o dra 'yie vɛ -a. \"Bɛ -sru -e 'i -sɔɔnla 'an -sru!» ");
INSERT INTO yreNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Zɩ e 'wɩ zɩɛ -a 'man bɛ, ɛn -a -pɛ -sru -tɔa, kɔɔ -a yɩfɛ a \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Zɩ Zozi -a 'yɩ 'nan -a ta drɛ 'trɔdrɔ bɛ, ɛn e 'nan: «Minnun nɛn, o yɩfɛ a \"kaga 'trɛda bɛ, -wee -sɔɔnladɩ Bali -sru \"a 'tɔndɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Maan ve 'cɛɛ 'nan, -wi -dan nɛn waa laabo shamo bɛ, ya'a 'kɔlaman -wladɩ -a 'mɛnzrɛn -yrɛ ji dɩ. -A -tʋwli \"nɛn \"nyian fɛnɔn 'le vɛ -a, -wee -sɔɔnladɩ Bali -sru \"a 'plɛblɛ 'wlidɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Zɩ minnun 'wɩ zɩɛ -a 'man bɛ, ɛn o 'nan: «-Te 'bɛ a zɩɛ, -tɩɛ -kɔlaman 'sidɩ -a 'wɩ 'ji \"mɛn?» ");
INSERT INTO yreNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Wɩ nɛn min 'ka 'kɔlaman -a drɛdɩ -a dɩɛ, Bali -kɔlaman -a drɛdɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","-A -nan nɛn Piɛri -a 'vɩ -yrɛ 'nan: «Minsan, 'kʋ 'bɔ 'gʋɛ, kʋ 'si 'kʋe fɛnun pɛɛnɔn -sru, ɛn kʋ sɔɔnla 'i -sru!» ");
INSERT INTO yreNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min oo min nɛn e 'si 'yee \"kɔnnɛn, -tɛ 'bɛ \"cɛɛ dɩ, e 'si 'e \"bʋɩnun 'lee 'e \"blunun -sru, -tɛ 'bɛ \"cɛɛ dɩ, e 'si 'e \"bʋ 'lee 'e \"tɩ -sru, -tɛ 'bɛ \"cɛɛ dɩ, e 'si 'yee 'nɛnnun -sru, 'nan -e Bali 'e mingɔnnɛn -blɩ 'e da -le \"wɛan bɛ, ");
INSERT INTO yreNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","-a san zɩɛ e fɛ pee ye \"kaga 'trɛda. Ɛn \"bɛ -sru tʋ nɛn Bali fɛ pɛɛnɔn limlan bɛ e 'belidɩ nɛn ya'a 'nyaan dɩɛ -a ye.» ");
INSERT INTO yreNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","\"Bɛ -sru ɛn Zozi 'e -srunɔn 'fuda \"fli 'saza laabʋ. Ɛn e 'nan -wlɛ 'nan: «-Kaa \"ta -ko Zeruzalɛm, -e 'wɩ pɛɛnɔn nɛn Bali 'lewei vɩnɔn -a 'vɩ Blamin -pɩ man bɛ, 'e 'lɛ sɔɔ. -Nyrɛn 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Minnun -a -nɔan minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ -wlɛ, -e 'o -tɛ. Minnun zɩɛ, waa sɛɛ wo, o 'le 'yi -sɛan -a yra, ");
INSERT INTO yreNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","waa -sɔan -ngble -a, -e 'o 'kʋ -a -tɛ. 'Pian -a yi yaagazan da bɛ, -e 'e 'wluan -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","-A -srunɔn 'ka 'wɩ zɩɛ -a -ci manlɛ dɩ. -A -ci -fʋ 'e yɔɔdɩ o man. 'Wɩ nɛn Zozi \"e 'nan 'e ve bɛ, wa'a -tɔlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Zozi a -plinan Zeriko 'fla \"srɔn, te yiɛ 'wizan -tʋ yra 'e -nyrandɩ -si man, te e fɛnun trʋ \"baa. ");
INSERT INTO yreNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Zɩ yiɛ 'wizan zɩɛ, e minnun -cin 'man 'ciɩnan bɛ, ɛn yaa laabʋ 'nan: «-Mɛ 'bɛ drɛ?» ");
INSERT INTO yreNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","O -yrɛ 'nan: «Nazarɛtɩ min Zozi 'bɛ cɩ ciɩnan!» ");
INSERT INTO yreNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","-A -nan nɛn e -paandɩ 'sia. E 'nan: «David kluda min Zozi, 'i yra 'si, 'yian nyrinda 'si!» ");
INSERT INTO yreNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɛn minnun nɛn o cɩra 'si 'lɛ bɛ o paan \"da 'nan 'e 'lɛbo 'pla \"da. 'Pian e paan \"nyian 'kpa 'plɛblɛ 'nan: «David kluda min, 'yian nyrinda 'si!» ");
INSERT INTO yreNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ɛn Zozi 'tɔ, e 'nan minnun lɛ 'nan 'o 'ta yiɛ 'wizan zɩɛ -a 'e 'va 'gʋ. Zɩ e pli \"man \"bɛ, ɛn Zozi -a laabʋ -yrɔ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«-Mɛ \"nɛn i ya \"vale 'an drɛ 'yiɛ?» Ɛn e 'nan Zozi lɛ 'nan: «Minsan, an ya \"vale 'yian yiɛ 'lɛ 'sʋ!» ");
INSERT INTO yreNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «'I yiɛ 'e 'lɛ 'sʋ! 'Yie yi -tɛradɩ 'an da 'i beli!» ");
INSERT INTO yreNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","'Nun tɔɔn -a yiɛ 'lɛ 'sʋ, ɛn e sɔɔnla Zozi -sru, te e Bali 'tɔ bɔa. Zɩ min pɛɛnɔn 'wɩ zɩɛ -a -nan 'yɩ bɛ, ɛn o Bali 'tɔ drɛ -dan. ");
INSERT INTO yreNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","\"Bɛ -sru ɛn Zozi 'bɔla Zeriko 'fla. E 'fla zɩɛ -a 'cɛndɩ 'sia 'ji. ");
INSERT INTO yreNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Fɛzan -tʋ a 'fla 'bɔ da, waa laabo Zashe. 'Sukɔlɛ 'sinɔn 'tazan nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Min zɩɛ e ya \"vale 'e Zozi ye. 'Pian e ya tounɔn, ɛn min \"kaga \"le \"wɛan ya'a 'kɔlaman -a yɩdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","-A -nan nɛn e -trɔa o 'lɛ flan -a, ɛn e yiba \"tʋ nɛn waa laabo Sikomor bɛ -a tri. Yaa drɛ zɩɛ 'nan -te Zozi a ciɩnan \"wlu \"bɛ -e 'e yɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zɩ Zozi 'bɔ fɛ zɩɛ -a -nan bɛ, ɛn 'e yiɛ 'tɔ lou. Yaa 'vɩ Zashe lɛ 'nan: «Zashe, 'i -sɔɔnla tada! Kɔɔ e ya \"le cɛɛgʋ 'an -nyran 'yie \"kɔnnɛn.» ");
INSERT INTO yreNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ɛn Zashe sɔɔnla \"nyiandʋ. E -kʋ Zozi 'a 'yee \"kɔnnɛn, ɛn e \"yi drɛ -yrɛ ci \"nrandɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Minnun nɛn waa -nan 'yɩ bɛ, o Zozi 'man wɩ vɩdɩ 'sia. Waa 'vɩ 'nan: «E wla 'wɩ 'wlidɩ \"drɛzan zɩɛ -yee 'kuin.» ");
INSERT INTO yreNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zashe pli Minsan man, ɛn e -yrɛ 'nan: «Minsan, an \"ta 'an yɩfɛ \"cɛan 'e cin man \"fli, -e 'an -tʋ -nɔn 'yalɛ -tɛnɔn lɛ. Ɛn \"nyian bɛ, \"lala nɛn maan 'si minnun lɔ 'e 'ciɩladɩ \"da \"bɛ, an min -tʋ -le vɛ 'lɛji bɔala 'e 'pa -a sinjɛn.» ");
INSERT INTO yreNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tɔɔn ɛn Zozi -a 'vɩ -yrɛ 'nan: «Cɛɛgʋ, Bali 'kɔn 'gʋɛ -a 'lɛ \"nɛnnɔn 'si 'wɩ 'ji. Kɔɔ yia kɔɔn 'nan Abraam kluda min nɛn 'yia. ");
INSERT INTO yreNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Blamin -pɩ -ta 'trɛda 'nan -e 'e min nɛn e 'si Bali man -kɔɔbli bɛ, -a 'si 'wɩ 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Zozi a -plinan Zeruzalɛm \"srɔn \"kogo, -yee \"wɛan 'wɩ nɛn Zozi 'sia -a vɩnan bɛ, zɩ minnun -a 'man bɛ, ɛn 'o ci \"nrɔndɩ 'sia 'nan, Bali -le mingɔnnɛn -blɩdɩ 'bɔ 'kogo. Zozi -a -kɔnnɛn 'yɩ, ɛn e -kɔnnɛn \"fɔdɩ 'sia -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","E 'nan: «Mingɔnnɛn kluda min -tʋ 'bɛ \"ta -ko 'lɛglɔn -kɔɔbli 'tʋ da. E \"ta -ko 'nan -e 'wee 'tɔ mingɔnnɛn -a. \"Bɛ -sru -e 'e 'ta mingɔnnɛn -blɩ 'e 'ya trɛ da. ");
INSERT INTO yreNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","\"Yɛɛ -kʋ bɛ, 'e 'sunɔn laabʋ -fu, ɛn e -siga 'wlɛ nɛn -a 'flɛ -kɔan tɩglɩ bɛ, -a pli o man -tʋdʋ. E 'nan -wlɛ 'nan: ‹'Ka fɛ -wɛɛ \"a -trilii, -e 'an 'tadɩ 'e bɔ.› ");
INSERT INTO yreNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Min zɩɛ -yee 'lɛglɔn 'jinɔn 'ka -a ye \"yi \"dɩ, -yee \"wɛan o minnun 'pa 'sia -a -sru 'nan 'o 'ka \"vale 'e 'tɔ 'o da mingɔnnɛn -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","'Pian e drɛ mingɔnnɛn -a, ɛn e 'li 'e da. Zɩ e 'bɔla bɛ, ɛn 'e 'sunɔn nɛn e -siga pli o man bɛ o laabʋ. Yaa drɛ zɩɛ 'nan, -e 'o 'nyranman nɛn waa 'pa bɛ -a -sru \"vɩ 'yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","-A tɛdɛ -ta, ɛn e -yrɛ 'nan: ‹'An 'san, -siga nɛn yia -nɔn 'mɛn bɛ, an -siga 'yɩ \"man \"fu.› ");
INSERT INTO yreNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ɛn -a tazan -a 'vɩ -yrɛ 'nan: ‹'I muo, yia drɛ \"yi. I ya 'an 'suzan 'kpa -a. Fɛ \"wɛnnɛn nɛn maan -pɛba 'wʋ 'i 'lɔ 'gʋɛ, i 'wɩ \"yi drɛ 'a. -Yee \"wɛan an 'fla 'fu -nɔan 'yiɛ -e 'mɛin 'tɔ o tazan -a.› ");
INSERT INTO yreNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","\"Bɛ -sru ɛn -a \"flizan 'ta. E -yrɛ 'nan: ‹'An 'san, 'yie -siga nɛn yia -nɔn 'mɛn bɛ, an -siga 'yɩ \"man 'soolu.› ");
INSERT INTO yreNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ɛn -a tazan -a 'vɩ -yrɛ 'nan: ‹'I muo, yia drɛ \"yi \"nyian. -Yee \"wɛan an 'fla 'soolu -nɔan 'yiɛ -e 'mɛin 'tɔ o tazan -a.› ");
INSERT INTO yreNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","\"Bɛ -sru ɛn -a pee -ta. \"Bɛ 'vɩ -yrɛ 'nan: ‹'An 'san, 'yie -siga nɛn yia -nɔn 'mɛn bɛ, maan 'pa sɔ -ji ɛn maan 'pla 'yiɛ. -Nyrɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","\"Klan -fʋ 'an 'ji 'i 'va zia, kɔɔ 'yie 'wɩ a 'tɔndɔn. Fɛ nɛn 'yie vɛ \"cɛɛ dɩɛ, yia \"sia. Ɛn -te min 'yie 'nyranman 'pa bɛ, -a ta -trɔn pɛɛnɔn nɛn yaa ye bɛ yia \"sia -yrɔ.› ");
INSERT INTO yreNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ɛn -a tazan -a 'vɩ -yrɛ 'nan: ‹I ya 'an 'suzan 'wlidɩ \"a. 'I wei 'i -tɛa. Yia -tɔa 'nan, 'mɛn 'wɩ a 'tɔndɔn, ɛn yie 'nan: «Fɛ nɛn e 'ka 'mɛn vɛ -a dɩɛ, maan \"sia. Ɛn -te min 'mɛn 'nyranman 'pa bɛ, -a ta -trɔn pɛɛnɔn nɛn yaa ye bɛ, maan \"sia -yrɔ.» ");
INSERT INTO yreNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","-Te i 'wɩ zɩɛ -a -tɔa \"bɛ, -mɛ \"le \"wɛan nɛn yia 'mɛn -siga 'palɛa fɛnan nɛn -a man \"paa \"bɛ -a -nan dɩ? Yia dra paan zɩɛ -e \"mɛn vɩnan 'an 'ta bɛ, te -a man 'pa.› ");
INSERT INTO yreNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tɔɔn ɛn mingɔnnɛn zɩɛ yaa 'vɩ minnun nɛn o cɩ -nan bɛ, -wlɛ 'nan: ‹'Ka -siga bɛ -a 'si -yrɔ, -e 'ka -nɔn min nɛn -siga -fu a -yrɔ \"bɛ -yrɛ!› ");
INSERT INTO yreNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ɛn minnun 'bɔ -a 'vɩ -yrɛ 'nan: ‹'Kʋ 'san, -siga a -yrɔ -fu 'va.› ");
INSERT INTO yreNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","-A -nan nɛn mingɔnnɛn -a 'vɩ 'nan: ‹Min nɛn e ya -yrɔ \"bɛ, -a lɛ nɛn waa -nɔan. 'Pian min nɛn -yee \"ka \"dɩɛ, -nyrɛn -yrɔ \"bɛ waa \"sia.› ");
INSERT INTO yreNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ɛn yaa 'vɩ \"nyian 'nan: ‹'An 'nanmannɔn nɛn wa'a yɩlɛ \"yi 'nan 'an 'tɔ 'o da dɩɛ, 'ka 'ta waa 'an 'lɛ 'gʋ, -e 'ka o -blɔ \"cɛɛn!› » ");
INSERT INTO yreNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Zɩ Zozi cɛɛn 'wɩ zɩɛ -a vɩdɩ man bɛ, ɛn e Zeruzalɛm si 'sia \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Zɩ Zozi 'bɔ Befaze 'lee Betani \"srɔn \"bɛ, ɛn 'e -srunɔn \"fli 'pa 'sia 'o 'lɛ. 'Fla \"fli zɩɛ o ya Olivie pɔn 'sɛan man. ");
INSERT INTO yreNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","E 'nan -wlɛ 'nan: «'Ka 'kʋ 'fla nɛn 'ka 'lɛ bɛ -a da. -Te ka 'bɔla 'nan nun, ka -aflumun planɛn ye 'e 'baa -tɔdɩ. Min -tʋ 'ka tian 'fɔlɛ \"da \"dɩ. 'Ka baa 'sʋ, -e 'ka 'ta -a 'mɛn 'gʋ! ");
INSERT INTO yreNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","-Te min -a laabʋ 'ka 'lɔ 'nan: ‹-Mɛ \"le \"wɛan nɛn ka cɩ -a baa 'sʋnan bɛ›, 'ka vɩ -yrɛ 'nan: ‹Minsan \"e 'nan, -aflumun 'wɩ a 'e man.› » ");
INSERT INTO yreNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Minnun nɛn e o 'pa 'sia bɛ, o -kʋ. O 'bɔ \"man \"le zɩ yaa 'vɩ bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Zɩ o ya -aflumun baa \"flunan bɛ, ɛn minnun nɛn -wee vɛ cɩ -a bɛ, waa laabʋ -wlɔ 'nan: «-Mɛ \"le \"wɛan ka ya -a \"flunan?» ");
INSERT INTO yreNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɛn o 'nan -wlɛ 'nan: «Minsan \"e 'nan, -aflumun 'wɩ a 'e man.» ");
INSERT INTO yreNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","-A -nan nɛn o -kʋ -aflumun zɩɛ -a Zozi lɛ. O 'wee sɔnun paala -a koda, ɛn o Zozi -nyran \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ɛn e -kʋdɩ 'sia. Minnun 'wee sɔnun \"paaladɩ 'sia \"wlu, te e -kʋla \"da. ");
INSERT INTO yreNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Zɩ e Olivie pɔn sɔɔn \"ji ɛn e 'bɔ Zeruzalɛm \"srɔn \"kogo bɛ, -a -nan nɛn -a -srunɔn pɛɛnɔn Bali 'tɔ bɔdɩ 'sia 'ci \"nrandɩ -a. 'Lɛbo \"fɔ wɩnun nɛn waa -nan 'yɩ bɛ, ");
INSERT INTO yreNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","-yee \"wɛan waa vɩdɩ 'sia 'nan: «Bali -le -fɛa 'e 'kɔn mingɔnnɛn nɛn Minsan -a 'pa 'sia bɛ -a man! Bali -a drɛ ɛn kʋ -fʋdɩ -trɔɔ 'yɩ. -A 'tɔ 'e drɛ -dan laji lou!» ");
INSERT INTO yreNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farizɛn 'nɔn -mienun a o yei. Zɩ o 'wɩ zɩɛ -a 'man bɛ, ɛn waa 'vɩ Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan, 'i -paan 'i -srunɔn da!» ");
INSERT INTO yreNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","'Pian Zozi \"e 'nan -wlɛ 'nan: «Maan ve 'cɛɛ 'nan, -te 'o 'lɛbo 'pla \"da \"bɛ, -kɔlɛnun 'bɛ -taa 'wɩlɛ o \"pa 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Zɩ Zozi Zeruzalɛm 'fla 'yɩ 'e 'lɛ bɛ, ɛn e -wuɔdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","E 'nan: «Zeruzalɛm 'nɔn, -fʋdɩ -trɔɔ a paan 'cee vɛ -a, -mɛ \"le \"wɛan nɛn ka'a 'wɩlɛ \"man \"dɩ? 'Pian 'bɛ nɛn 'gʋɛ, ka'a \"nyian -kɔlaman -a yɩdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tʋ -tʋ -taa \"bɔlɛ bɛ, 'ka 'nanmannɔn 'ka 'si -fɔa \"klɔn -a, -e 'o 'kuli -tɔ 'ka man -pɛ pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","O 'ka 'fla -wia, ɛn o minnun pɛɛnɔn -tɛɛman. Fɛ -tʋwli 'ka 'fo 'fla 'bɔ da dɩ. 'Wɩ pɛɛnɔn zɩɛ e bɔa 'ka man, kɔɔ tʋ nɛn Bali -ta 'palɛ 'ka 'va bɛ, ka'a 'wɩlɛ \"man \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","\"Bɛ -sru ɛn Zozi 'kʋ Bali -pan 'kuin. Minnun nɛn o Bali -pan fɛnun -taan \"bɛ, e o -pindɩ 'sia 'kɔn zɩɛ -a -ji, 'nan 'o bɔla bei. ");
INSERT INTO yreNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yaa 'vɩ -wlɛ 'nan: «E ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan, Bali \"e 'nan: ‹'Mɛn 'kɔn -kɔan 'an trʋ 'ba 'kɔn 'a.› 'Pian kaa drɛ crin wʋnan -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","\"Bɛ -sru te Zozi 'ko Bali -le 'wɩ \"paalɛ yi -tʋdʋ pɛɛnɔn man Bali -pan 'kuin. Ɛn Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn 'lee minnun tanɔn Zozi 'man -wɛɛdɩ 'sia, 'nan -e 'o -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","'Pian 'wɩ nɛn 'kɔ 'o drɛ -e 'o -kɔla -a man yɩdɩ -a bɛ, wa'a tɔa dɩ. Kɔɔ Zozi 'le 'wɩ \"paadɩ 'sɔ min pɛɛnɔn lɛ, ɛn \"nyian bɛ o Zozi 'bɔ ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yi -tʋ da Zozi a Bali -le 'wɩ \"paanan minnun ji Bali -pan 'kuin. Ɛn e Bali -le 'wɩ 'nɔnnɔn vɩdɩ 'sia -wlɛ. -A -nan nɛn Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn 'lee min cejenun -ta \"va, ");
INSERT INTO yreNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ɛn waa laabʋ -yrɔ 'nan: «-Kɔladɩ \"cɛn \"a nɛn i 'wɩnun zɩɛ -a dra? Ɛn -tɩɛ -si -nɔn 'yiɛ? 'I vɩ 'kʋɛ!» ");
INSERT INTO yreNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'An 'bɔ \"nyian an \"ta 'wɩ 'tʋwli \"cɛ laabo 'ka 'lɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","-Tɩɛ Zan 'pa 'sia 'nan 'e 'ta min -batize drɛ? Minnun 'bɛ 'pa 'sia, -baa Bali 'bɛ 'pa 'sia? 'Ka vɩ 'mɛn!» ");
INSERT INTO yreNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","-A -nan nɛn waa vɩdɩ 'sia 'o cin yei 'nan: «-Te -kaa 'vɩ 'nan, Bali 'bɛ 'pa 'sia bɛ, yaa laabo -kaa 'lɔ 'nan: ‹-Mɛ \"le \"wɛan nɛn ka'a yi -tɛlɛa -a wei -da dɩ?› ");
INSERT INTO yreNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ɛn -te -kaa 'vɩ 'nan, minnun 'bɛ 'pa 'sia bɛ, min pɛɛnɔn 'kɔlɛ wɛɛndɩ \"siala -kaa 'va -e 'o -kaa -tɛɛ. Kɔɔ -a -cin a o pɛɛnɔn 'ji 'nan Zan a Bali 'lewei vɩzan -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","-A -nan nɛn waa 'vɩ Zozi lɛ 'nan: «Min nɛn e Zan 'pa 'sia bɛ, kʋ'a tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'An 'bɔ \"nyian min nɛn e -si -nɔn 'mɛn, ɛn an 'wɩnun zɩɛ -a dra bɛ, ma'an -ci sia 'cɛɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ɛn Zozi -kɔnnɛn 'gʋɛ -a -fɔdɩ 'sia minnun lɛ. E 'nan: «Min -tʋ 'bɛ 'yee rɛzɛn fei 'pa, ɛn yaa -nɔn minnun lɛ 'nan 'o 'nyranman 'pa \"da, te o 'yee vɛ -nɔan. Yaa drɛ zɩɛ, ɛn e -kʋ 'lɛglɔn 'kɔɔbli 'tʋ da, e \"mɔan -nan nun. ");
INSERT INTO yreNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Zɩ rɛzɛn nan tʋ 'bɔ bɛ, ɛn min zɩɛ 'e 'suzan -tʋ 'pa 'sia, 'nan 'e 'kʋ 'yee vɛ 'si. Fei 'panɔn -a 'suzan zɩɛ -a 'kun, waa -sɔn, ɛn o 'si \"man. Wa'a fɛ -tʋ -nɔnlɛ -yrɛ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","\"Bɛ -sru ɛn 'e 'suzan 'pee 'pa 'sia \"nyian. Waa -sɔn, waa srɔn, ɛn waa 'li 'e da 'e 'lɔ 'a 'e \"tun. ");
INSERT INTO yreNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","\"Bɛ -sru ɛn yaa yaagazan 'pa 'sia \"nyian. Wɛɛ 'sɔn -trilii, nyɛn 'bɔ 'bɛ da, ɛn wɛɛ 'pin. ");
INSERT INTO yreNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","-A -nan nɛn fei san 'bɔ \"e 'nan: ‹Maan dra 'kɔ? -A -cin -tɔ 'an 'ji. 'An 'pɩ nɛn e 'sɔ 'mɛn tɩglɩ bɛ, -a 'bɔ nɛn maan \"paa -sia o va. Maan ye \"le o yiɛ -taa 'nanlɛ 'bɛ man.› ");
INSERT INTO yreNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","'Pian zɩ fei 'panɔn 'nɛn zɩɛ -a 'yɩ 'tanan bɛ, ɛn waa 'vɩ 'o cin yei 'nan: ‹'Nɛn 'labɛ, -yɛɛ -taa \"drɛlɛ 'e \"tɩ -ziazan -a. -Yee \"wɛan -kaa -tɛ, -e fei 'e 'fʋ -kaa 'lɔ.› ");
INSERT INTO yreNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Waa 'kun, ɛn o -kʋ -a rɛzɛn fei -sru \"sa -a, ɛn waa -tɛ. 'Wɩ zɩɛ -a -ji bɛ, -mɛ \"wɩ nɛn fei san -taa -a drɛlɛ minnun nɛn o -yee fei dra bɛ -wlɛ? ");
INSERT INTO yreNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Maan ve 'cɛɛ 'nan, e -taa -e 'e 'yee fei 'panɔn zɩɛ o -tɛɛ, -e 'e 'yee rɛzɛn fei 'bɔ 'nɔn min peenun lɛ.» Minnun nɛn -nan bɛ, o 'nan: «'Wɩ nɛn i \"sia -a vɩnan 'labɛ, ya'a dra dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Zozi o -nanjɛndɩ 'sia, ɛn yaa 'vɩ -wlɛ 'nan: «'Wɩ nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, -a -ci nɛn 'nɔn? Kɔɔ e ya 'e 'crɛn -tɛdɩ 'nan: ‹-Kɔlɛ nɛn, 'kɔn 'tɔnɔn -a tuʋ 'o 'pɛla koda bɛ, -yɛɛ drɛ 'kɔn 'pʋ -fɔ -kɔlɛ -a.› ");
INSERT INTO yreNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Min nɛn e -tria -kɔlɛ zɩɛ -a da bɛ, e -wia. Ɛn -te -kɔlɛ zɩɛ e -tria min da bɛ, yaa pɔlɛ \"bo.» ");
INSERT INTO yreNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Zɩ 'fluba 'ci vɩnɔn 'lee Bali -pannɔn 'tanɔn 'wɩ zɩɛ -a 'man bɛ, ɛn waa -tɔ 'nan, 'wee \"wɛan nɛn Zozi -kɔnnɛn zɩɛ -a -fɔ. -A -nan nɛn o ya \"vale 'o Zozi \"kuan -nan nun, 'pian o klan minnun lɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tʋ zɩɛ -a man nɛn 'fluba 'ci vɩnɔn 'lee Bali -pannɔn 'tanɔn Zozi 'man -fɔɔdɩ 'sia. -Yee \"wɛan o minnun 'pa 'sia \"va, 'nan 'o 'fli drɛ min tɩglɩnun -a, -e 'o Zozi wei 'kun. O ya \"vale 'o 'wɩ 'tʋ ye -e 'o -kɔla Zozi 'nɔndɩ -a -kɔnmandan lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Minnun zɩɛ o 'wɩ laabʋ Zozi 'lɔ. O 'nan: «Bali -le 'wɩ \"paazan, kʋa -tɔa 'nan, i 'wɩ \"paaman 'wɩ tɩglɩ 'a. Ɛn kʋa -tɔa \"nyian 'nan, yi'a min bo \"va \"dɩ. Ɛn \"nyian bɛ, 'wɩ nɛn Bali \"e 'nan blamin 'e drɛ bɛ, -a tɩglɩ 'bɔ nɛn yia \"paaman minnun ji. ");
INSERT INTO yreNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","-Yee \"wɛan kʋ \"ta 'wɩ 'gʋɛ -a laabo 'i 'lɔ. -Nyrɛn 'nan: -Si a 'e 'nɔndɩ -cɛɛ, -e -kaa 'sukɔlɛ -pan wʋ Rɔm 'nɔn 'le mingɔnnɛn Seza lɛ, -baa te -ka'a drɛ \"fo \"dɩ?» ");
INSERT INTO yreNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","'Pian Zozi -wee -dawli -kɔnnɛn 'yɩ. Ɛn e 'nan -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«'Ka 'ta 'lein 'wlɛ 'tʋ -a 'mɛn -e 'an yɩ! -Tɩ -wulo -fodo nɛn 'gʋ? Ɛn -tɩ 'tɔ 'crɛn nɛn 'gʋ?» O 'nan -yrɛ 'nan: «Rɔm 'nɔn 'le mingɔnnɛn Seza nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Fɛ nɛn Seza -le vɛ -a bɛ, 'cɛɛ 'nɔn Seza lɛ! Ɛn fɛ nɛn Bali -le vɛ -a bɛ, 'cɛɛ 'nɔn Bali lɛ!» ");
INSERT INTO yreNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wa'a -kɔlalɛ Zozi wei 'kundɩ -a minnun yiɛ man \"fo \"dɩ. Ɛn 'wɩ 'bɔ nɛn Zozi -a 'vɩ bɛ e o 'kan, -yee \"wɛan wa'a \"nyian 'wɩ 'tʋ vɩlɛ \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","\"Bɛ -sru ɛn Saduze 'nɔn -mie pli Zozi man. Saduze 'nɔn \"o \"ve 'nan, -te min -ka bɛ, ya'a 'wuanla -kanɔn 'va dɩ. Zɩ o pli \"man \"bɛ, ɛn waa laabʋ -yrɔ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Bali -le 'wɩ \"paazan, 'wɩ nɛn Moizi -a crɛn -tɛ 'kʋɛ bɛ, -nyrɛn 'gʋ: ‹-Te min lɩ 'pa, ɛn -a san zɩɛ e -ka, te wa'a tian 'nɛn 'yalɛ 'o 'vale 'e nan 'bɔ 'a dɩɛ, -yee -cale zɩɛ -a \"bʋɩ 'e 'pa, -e 'e \"bʋɩ klu bɔla!› ");
INSERT INTO yreNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Min -tʋ -le 'nɛn -klɔnmɔn a 'sɔravli. -A tɛdɛ lɩ 'pa, ɛn e -ka, te wa'a 'nɛn 'yalɛ 'e nan 'bɔ 'a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","-A \"flizan \"e -cale -tʋwli zɩɛ -a 'pa, ɛn e drɛ \"nyian zɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ɛn -a yaagazan \"e -cale -tʋwli zɩɛ -a 'pa, ɛn e drɛ \"nyian zɩ. 'Wɩ 'tʋwli zɩɛ e 'bɔ o 'sɔravlinɔn man. Wa'a 'nɛn 'yalɛ dɩ, ɛn o pɛɛnɔn kaa. ");
INSERT INTO yreNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","\"Bɛ -sru ɛn lɩ 'bɔ \"e \"ka 'wʋ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tʋ nɛn minnun wuanla -kanɔn 'va bɛ, lɩ zɩɛ e -kɔan -tɩ nan -a? 'I vɩ 'kʋɛ! Kɔɔ o 'sɔravli 'bɔ -a 'pa lɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Minnun nɛn 'trɛ 'gʋɛ -a da bɛ, -wɛɛ lɩ 'lee -kɔnnɛn \"paa. ");
INSERT INTO yreNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","'Pian minnun nɛn Bali o 'yɩ tɩglɩ 'trɛ pee davɛ -a, ɛn e o wluan -kanɔn 'va bɛ, wa'a lɩ 'lee -kɔnnɛn 'paa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ɛn wa'a 'kɔlaman \"nyian -kadɩ -a dɩ. O -kɔan \"le Bali -le 'pasianɔn nɛn laji bɛ -wee 'wɩ 'zʋ. Bali o wluan -kanɔn 'va, ɛn o drɛ -yee 'nɛnnun -a. ");
INSERT INTO yreNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","'Ka Saduze 'nɔn, -a -cin a 'ka 'ji 'nan, min 'ka 'wuanla -kanɔn 'va dɩ. Ka ya 'ka 'fli see \"paanan, kɔɔ 'wɩ nɛn Moizi -a 'vɩ 'li bɛ, yaa -ci -kɔɔnman 'nan, minnun nɛn o kaa bɛ, o wuanla -kanɔn 'va. 'Wɩ nɛn Moizi -a -nan 'yɩ te 'tɛ nrɛn a yiba \"kpizrɛnnɛn 'va bɛ, -nyrɛn 'gʋ. Yaa crɛn -tɛ 'nan: ‹Minsan \"e 'nan, 'e ya Abraam -le Bali -a, ɛn 'e ya Izak -le Bali -a, ɛn 'e ya Zago 'le Bali -a.› ");
INSERT INTO yreNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tʋ nɛn Bali 'wɩ zɩɛ -a ve bɛ, te -kaa tranun zɩɛ o kaa -a -nan 'mɔn. 'Pian Bali \"le 'va bɛ, o yiɛ a \"man tian, kɔɔ Bali a minnun nɛn o yiɛ cɩ \"man \"bɛ -wee Bali -a, e 'ka minnun nɛn o kaa bɛ -wee Bali -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","-A -nan nɛn 'fluba 'ci vɩnɔn -mienun -a 'vɩ -yrɛ 'nan: «Bali -le 'wɩ \"paazan, yia -ci 'vɩ tɩglɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ɛn wa'a \"nyian 'wɩ 'pee laabʋlɛ Zozi 'lɔ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","\"Bɛ -sru ɛn Zozi -a laabʋ minnun lɔ 'nan: «E drɛ 'kɔ ɛn minnun \"o 'nan, min 'sizan 'wɩ 'ji Crizi a David kluda min -a? ");
INSERT INTO yreNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kɔɔ David 'bɔ -a 'vɩ \"dre 'fluba 'ji 'nan: ‹Minsan Bali -a 'vɩ 'an 'san lɛ 'nan: 'I 'nyran 'an 'pɛ \"yi \"da -trilii, ");
INSERT INTO yreNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","-e 'an 'cɛn 'i 'nanmannɔn 'klɩdɩ man.› ");
INSERT INTO yreNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","-Te David 'bɔ Crizi laabo 'e 'san bɛ, e drɛ 'kɔ ɛn 'bɛ -kɔan David kluda min -a?» ");
INSERT INTO yreNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Zɩ minnun pɛɛnɔn a Zozi wei mannan bɛ, ɛn e 'wɩ pladɩ 'sia 'e -srunɔn lɛ. E 'nan -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Te 'ka 'wɩ drɛ \"le 'fluba 'ci vɩnɔn 'le 'wɩ 'zʋ dɩ! O -tɔɔdɩ ye \"yi -tralɛ -gblɔnun nɛn fɛnyian bɛ -a -ji. Ɛn waa ye \"yi \"le 'nan min 'e o 'tɔ bʋ -guada. -Te e ya \"fɛdi da -a oo, ɛn -te e ya cin yɩ 'kuin -a oo, -nyran \"nan 'kpagba nɛn waa 'sidɩ ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","O fɛnun \"sia -calenun lɔ -dawli -a. \"Bɛ -sru -e 'o Bali trʋ 'ba -plɔun 'nan -e minnun 'o o \"sia min tɩglɩ 'a. 'Wɩnun zɩɛ -a drɛdɩ -le \"wɛan Bali -wee tin \"paa 'plɛblɛ 'kpa.» ");
INSERT INTO yreNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Zɩ Zozi cɛɛn 'wɩ zɩɛ -a vɩdɩ man bɛ, \"yɛɛ yiɛ 'tɔ 'e \"srɔn Bali -pan 'kɔn 'bɔ 'ji bɛ, te e fɛnɔn ye. O ya \"lala nɛn kɔ 'o -nɔn Bali lɛ bɛ -a -sɛnnan -gbogbo -tʋ -ji. ");
INSERT INTO yreNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ɛn Zozi -cale seezan -tʋ 'yɩ, te e ya -bablu 'wlɛ 'tʋdʋ \"fli \"fɔnan -ji. ");
INSERT INTO yreNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","-A -nan nɛn e 'nan 'e -srunɔn lɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -cale seezan 'labɛ, e fɛ -nɔn Bali lɛ e mlin minnun pɛɛnɔn nɛn waa -nɔn 'gʋɛ o da. ");
INSERT INTO yreNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kɔɔ o pɛɛnɔn nɛn waa -nɔn 'gʋɛ, \"lala a -wlɔ \"kaga. 'Pian lɩ 'labɛ, \"lala pɛɛnɔn nɛn -yrɔ -yee fɛ -blɩ \"man \"vɛ -a bɛ, -a 'bɔ nɛn yaa -nɔn Bali lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tʋ zɩɛ -a wlu bɛ, te min -mienun a -a vɩnan 'nan: «\"Ii, Bali -pan 'kɔn bɛ, waa -tɔ -kɔlɛ fɛnyian -a! 'Ka 'yiɛ 'tɔ fɛnun fɛnyian nɛn minnun -a -nɔn Bali lɛ bɛ -a 'bɔ 'a nɛn waa 'man drɛ.» Ɛn Zozi \"e 'nan 'wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Tʋ -tʋ -taa \"bɔlɛ bɛ, fɛnun nɛn ka o ye 'labɛ, minnun -a -wiiman 'e pɛɛnɔn. -A -kɔlɛ pɛɛnɔn fuimlan \"man, -a -tʋ 'ka 'fo 'e bɔɛzan da dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Minnun -a laabʋ Zozi 'lɔ 'nan: «Bali -le 'wɩ \"paazan, tʋ \"cɛn \"man nɛn, 'wɩnun zɩɛ o dra? Ɛn -mɛ \"man nɛn, waa -kɔnnɛn \"ye 'nan 'wɩnun zɩɛ o \"ta dra?» ");
INSERT INTO yreNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Ka yiɛ 'tɔ 'ka 'fli -va! Te min -tʋ 'e 'ka see \"paa -e 'ka 'si -si tɩglɩ da dɩ! Fɛ nɛn maan ve zɩɛ -yɛɛ cɩ 'nan, min \"kaga -taa \"talɛ 'an 'tɔ da. Waa ve 'nan, 'wɛɛ cɩ Crizi -a. Ɛn waa ve \"nyian 'nan, 'trɛda -nyan tʋ 'bɔ! Te 'ka -sɔɔnla minnun zɩɛ o -sru \"dɩ! ");
INSERT INTO yreNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ka -kuli -tan wɩnun maan, ɛn 'lɛglɔn 'tʋ -ji 'nɔn wuanla 'o cin man, kaa -nan wɩ maan. Te 'o 'ka 'cɛn nyɛn -a dɩ! Kɔɔ 'wɩnun zɩɛ -wɛɛ dra 'e flin, 'pian 'trɛda -nyan tʋ \"cɛɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ɛn Zozi \"e 'nan \"nyian -wlɛ 'nan: «'Lɛglɔn 'tʋ -ji 'nɔn wuanla 'lɛglɔn 'tʋ -ji 'nɔn man, ɛn mingɔnnɛn trɛ -tʋ wuanla mingɔnnɛn trɛ -tʋ man. ");
INSERT INTO yreNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ɛn \"nyian bɛ, 'trɛ 'nyɔɔnman fɛ \"kaga \"nan. Dra -dandan -taa, ɛn -cɛ -wlidɩ -kɔan fɛ \"kaga \"nan. Ɛn \"nyian bɛ, nyɛn 'cɛn wɩ -dandan 'lee 'wɩ 'nɔan -kɔɔn \"vɛ -dandan dra laji. ");
INSERT INTO yreNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Maan ve 'cɛɛ 'nan, 'vaa -e 'wɩnun zɩɛ 'o drɛ bɛ, minnun 'ka \"kuan, o 'tɛ \"paa 'ka da. Ka drɛ 'mɛn vɛ -a -le \"wɛan bɛ, minnun -ko 'cee tin 'palɛ 'wee cin yɩ 'kuin, ɛn o 'ka -fɔa \"pʋ 'kuin. Ɛn \"nyian bɛ, o -ko 'ka 'a mingɔnnɛnnun 'lee -kɔnmandannun 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tʋ zɩɛ -a man bɛ, ka dra 'mɛn 'wɩnan yɩnɔn 'a o 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","'Wɩ nɛn kɔ 'ka vɩ -e 'cee tin 'e drɛ 'nɔnnɔn bɛ, te -a nyɛn 'e 'kɔn 'ka 'ji dɩ! ");
INSERT INTO yreNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kɔɔ 'an 'bɔ 'bɛ 'wɩ 'tɔdɩ -nɔan 'cɛɛ, ɛn \"nyian bɛ 'wɩ nɛn kɔ 'ka vɩ bɛ, maan -cin -tɔa 'ka 'ji. -Yee \"wɛan 'ka 'nanmannɔn 'ka 'kɔlaman -e 'o -zi -fɔ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","'Ka \"tɩ 'lee 'ka \"bʋ 'bɛ -taa 'silɛ 'ka -sru. -Te 'bɛ \"cɛɛ dɩ, 'ka \"bʋɩnun 'lee 'ka \"blunun 'bɛ -taa 'silɛ 'ka -sru. -Te 'bɛ \"cɛɛ dɩ, 'ka drɩnun 'lee 'ka beenun 'bɛ -taa 'silɛ 'ka -sru. O pɛɛnɔn \"sia 'ka -sru -e 'o 'ka -nɔn minnun lɛ. 'Wɩ zɩɛ -a -ji bɛ, 'ka \"kaga 'wulo -ko -ji. ");
INSERT INTO yreNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ka drɛ 'mɛn vɛ -a -le \"wɛan bɛ, min pɛɛnɔn -taa 'nanlɛ 'ka man, wa'a 'taa 'ka yɩlɛ \"yi \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Maan ve 'cɛɛ 'nan, 'ka 'wulo \"jɛ \"pou -tʋwli 'ka 'saan \"va \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","'Pian 'ka -pɔan 'e 'sɔ -e 'ka 'belidɩ nɛn ya'a 'nyaan dɩɛ -a yɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ɛn Zozi \"e 'nan -wlɛ \"nyian 'nan: «Tʋ nɛn ka Zeruzalɛm 'yɩ te -a 'nanmannɔn 'le 'sounjanun -a si -fɔ bɛ, 'ka -tɔ 'nan, -a -nan srɛ tʋ 'bɔ 'kogo. ");
INSERT INTO yreNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tʋ zɩɛ -a man bɛ, minnun nɛn Zude 'lɛglɔn 'ji bɛ, 'o flan 'bli, 'o 'kʋ pɔnnun yei! Ɛn minnun nɛn Zeruzalɛm bɛ 'o 'si 'nan! Ɛn minnun nɛn fei -paan \"da \"bɛ, te 'o li 'o da Zeruzalɛm dɩ! ");
INSERT INTO yreNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tʋ nɛn Bali minnun -le tin \"baa bɛ, -a pou siadɩ nɛn. Ɛn 'wɩnun nɛn 'o 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, -a 'lɛ sɔɔ tʋ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lɩmɔnnun nɛn o -pɔn -kɔan 'o man tʋ zɩɛ -a man bɛ, 'lee lɩmɔnnun nɛn 'nɛn 'nyɔn -mlian -wlɔ tʋ zɩɛ -a man bɛ, -wee yra yɩdɩ \"mlianla \"da. Kɔɔ minnun pɛɛnɔn -taa 'o yra yɩlɛ -wlidɩ 'lɛglɔn zɩɛ -a -ji. Bali -le nyran -blɩ tʋ nɛn o va. ");
INSERT INTO yreNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","O min -mienun -tɛɛman srɛn 'a. O -ko o -mienun drɛlɛ nɔannun -a 'lɛglɔn peenun -ji. Minnun nɛn wa'a Bali tɔa dɩɛ, o Zeruzalɛm srɛman \"fo. 'Pian -wee tʋ 'bɔ 'leda a.» ");
INSERT INTO yreNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ɛn Zozi \"e 'nan -wlɛ \"nyian 'nan: «Fɛ -nɔan -kɔɔn \"vɛ -kɔan yidɛ yra, ɛn e -kɔan mlɛn yra, ɛn e -kɔan mlɛn crɛnnun yra. 'Wɩ zɩɛ e \"klan -dan -sɛan 'lɛglɔn pɛɛnɔn 'ji minnun ji. Ɛn \"nyian bɛ, jemie 'blʋ 'fɔdɩ 'lee -a -klundɩ 'plɛblɛ o \"cɛan nyɛn -a. ");
INSERT INTO yreNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Minnun -kaa \"klan -dan 'lɔ, te o ya 'wɩ nɛn e \"ta -daa \"drɛlɛ 'trɛda bɛ -a man -pɛnnan. Kɔɔ laji fɛnun 'plɛblɛ pɛɛnɔn 'nyɔɔnman. ");
INSERT INTO yreNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tʋ zɩɛ -a man nɛn, minnun pɛɛnɔn Blamin -pɩ ye 'sinan laji \"lolu -koei \"da. -Kɔladɩ 'plɛblɛ 'lee 'tɔ -dan -kɔan -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","-Te 'wɩnun zɩɛ -a drɛdɩ \"ta 'e pou \"siala bɛ, 'ka -pɔan 'kun, -e 'ka 'wulo wluan lou, kɔɔ te 'ka 'sidɩ 'wɩ 'ji a -plinan 'kogo.» ");
INSERT INTO yreNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","\"Bɛ -sru ɛn Zozi -a vɩdɩ 'sia -kɔnnɛn \"ji 'nan: «Yiba \"tʋ nɛn waa laabo fijie bɛ, 'ka drɛ 'cee 'wɩ -kɔɔn \"manvɛ -a 'lee yiba -mienun \"nyian! ");
INSERT INTO yreNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","-Te -a 'la nrindɩ 'sia \"da \"bɛ, kaa -tɔa 'nan 'munmun tʋ a -tanan bɔdɩ -a -kogo. ");
INSERT INTO yreNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","-A -tʋwli \"nɛn \"nyian Bali -le mingɔnnɛn trɛ -tadɩ -le vɛ -a. -Te ka 'wɩnun zɩɛ -a 'yɩ drɛnan bɛ, 'ka -tɔ 'nan Bali -le mingɔnnɛn trɛ -tadɩ 'bɔ 'kogo. ");
INSERT INTO yreNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'ka -naagʋnɔn 'gʋɛ, ka'a 'cɛan -kaadɩ man 'vaa -e 'wɩnun zɩɛ 'o drɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Labli 'lee 'trɛ 'nyan tʋ a, 'pian 'an wei -fo -nan 'li 'trilii. ");
INSERT INTO yreNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","'Ka yiɛ 'tɔ 'ka 'fli -va! Te 'ka 'fli -nɔn -wɛn lɛ 'e 'ciɩla \"da \"dɩ! Ɛn te 'ka 'fli -nɔn 'trɛda ci \"nrɔndɩ lɛ 'e 'ciɩla \"da \"dɩ! \"Tɔgɔ tin 'ba yi 'e bɔ 'ka man kligli. ");
INSERT INTO yreNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kɔɔ yi nɛn Bali 'trɛdanɔn pɛɛnɔn 'le 'wɩ tin \"baa bɛ, e dra kligli. E dra \"le zɩ \"se -sɛanla pɔnun da kligli bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","-Yee \"wɛan te 'ka 'ci 'e 'san 'ka 'fli man dɩ! 'Ka Bali trʋ 'ba tʋ pɛɛnɔn man, -e 'ka \"koe 'e 'kɔn 'ka da! 'Ka drɛ zɩ, -e 'wɩ pɛɛnɔn nɛn e -taa \"bɔlɛ 'ka man bɛ 'ka 'sʋ -yrɔ, -e 'ka 'kɔla -plidɩ -a Blamin -pɩ man.» ");
INSERT INTO yreNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yi -tʋdʋ pɛɛnɔn man bɛ, Zozi 'ko Bali -le 'wɩ \"paalɛ minnun ji Bali -pan 'kuin, 'pian -pei -man bɛ, -e 'e 'kʋ Olivie pɔn da. ");
INSERT INTO yreNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tʋ \"le 'cɛndɩ man bodrun puunɔn bɛ, te minnun pɛɛnɔn a -kʋnan Zozi 'va Bali -pan 'kuin 'nan -e 'o wei man. ");
INSERT INTO yreNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Zuif 'nɔn tranun -le 'si nɛn waa 'wʋ nɔanba -ji bɛ, -a \"fɛdi \"ta bɔa. \"Fɛdi zɩɛ -a da nɛn minnun 'kpɔun nɛn 'mannyan 'ka \"va \"dɩɛ -a -ble. ");
INSERT INTO yreNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tʋ zɩɛ -a man bɛ, te Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn a Zozi 'man -fɔɔnan, 'nan -e 'o -tɛ 'e yɔɔdɩ. Kɔɔ \"klan a o ji minnun -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satan -fɔ Zudazi nɛn waa laabo \"nyian Karioti bɛ -a -sru. Zozi -srunɔn 'fuda \"fli 'bɔ 'va min -tʋ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Zudazi zɩɛ e -kʋ Bali -pannɔn 'tanɔn 'lee minnun tanɔn nɛn o yiɛ -tɔa Bali -pan 'kɔn 'va bɛ o va. Ɛn 'wɩ nɛn kɔ 'e drɛ 'lɔɔ -e 'e Zozi 'nɔn -wlɛ \"bɛ, yaa 'vɩ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Wɩ zɩɛ e o ci nran. -A -nan nɛn waa 'vɩ -yrɛ 'nan, o \"lala -nɔan -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","E wɩɩ \"man, ɛn zɩ kɔ 'o drɛ 'lɔɔ -e 'o Zozi 'kun te minnun 'ka 'nan dɩɛ, yaa man -wɛɛdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","\"Fɛdi nɛn Zuif 'nɔn 'kpɔun nɛn 'mannyan 'ka \"va \"dɩɛ -a -ble \"da \"bɛ e 'bɔ. Waa drɛdɩ 'sia, ɛn yi nɛn o 'blanun -tɛɛman -e 'o tranun 'si nɔanba -ji \"fɛdi -blɩ bɛ e 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","-A -nan nɛn Zozi Piɛri 'lee Zan 'pa 'sia. E 'nan -wlɛ 'nan: «'Ka 'kʋ 'fla -cee \"fɛdi fɛnun man drɛ, 'dʋ -e -kaa -blɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ɛn waa laabʋ Zozi 'lɔ 'nan: «Nyin zia nɛn i ya \"vale 'kʋ 'kʋ -a drɛ?» ");
INSERT INTO yreNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «-Te ka 'bɔla 'fla bɛ, ka min -tʋ ye, te 'yi 'tɔbɔ a -yrɔ. 'Ka 'kʋla -a -sru! 'Kɔn nɛn e -ko -ji bɛ, 'ka 'kʋ waa! ");
INSERT INTO yreNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","'Ka vɩ 'kɔn zɩɛ -a san lɛ 'nan: ‹Bali -le 'wɩ \"paazan \"e 'nan, 'kʋ vɩ 'yiɛ 'nan, 'kɔn \"bʋ \"nɛn 'kʋ 'vale 'an -srunɔn 'a, kʋ \"fɛdi fɛnun -ble -ji bɛ, e ya nyin zia?› ");
INSERT INTO yreNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Min zɩɛ e 'kɔn \"bʋ -dan tʋ -kɔɔnman 'cɛɛ 'kɔn 'ta lou te -a -ji a 'e drɛdɩ \"fo. Fɛ zɩɛ -a -nan nɛn 'ka -cee \"fɛdi fɛnun man drɛ!» ");
INSERT INTO yreNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Zozi -srunɔn zɩɛ o -kʋ, ɛn waa 'yɩ \"le zɩ Zozi -a 'vɩ bɛ -yee 'wɩ 'zʋ. -A -nan nɛn o 'wee \"fɛdi fɛnun man drɛdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Zɩ \"fɛdi fɛnun -blɩ tʋ 'bɔ bɛ, ɛn Zozi 'lee 'yee 'pasianɔn 'nyran fɛnun -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ɛn e 'nan -wlɛ 'nan: «-Kaa tranun 'sidɩ nɔanba -ji \"fɛdi 'gʋɛ, maan wɛɛ 'kpa tɩglɩ 'nan -kaa -blɩ 'e cin va 'vaa -e 'mɛn yra yɩ tʋ 'e bɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kɔɔ maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, ma'an \"nyian -a pee ble dɩ, -trilii, ɛn tʋ nɛn Bali \"fɛdi 'bɔ 'ci \"sia 'cɛɛ -yee mingɔnnɛn trɛ da bɛ e bɔa.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","-A -nan nɛn Zozi 'kulenɛn 'tʋ 'si, e Bali muo \"fɔ, ɛn e 'nan -wlɛ 'nan: «'Ka 'si -e 'ka mlin 'sɛzɛnɔn! ");
INSERT INTO yreNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Maan ve 'cɛɛ 'nan, ma'an \"nyian rɛzɛn -wɛn pee mlian dɩ, -trilii -e Bali -le mingɔnnɛn trɛ 'e 'ta.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","\"Bɛ -sru ɛn Zozi 'kpɔun 'si, e Bali muo \"fɔ, yaa \"nɛn jɛɛn, ɛn yaa -nɔn -wlɛ. E 'nan -wlɛ 'nan: «-Nyrɛn 'gʋɛ, 'an 'kɔlɛ nɛn. -Yɛɛ -taa \"drɛlɛ 'sraga bʋvɛ -a Bali lɛ 'ka 'lɛji. 'Wɩ nɛn an cɩ -a drɛnan 'gʋɛ, 'ka drɛ, te 'an 'cin -tɔala 'ka 'ji!» ");
INSERT INTO yreNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","O cɛɛn fɛnun -blɩdɩ man, ɛn e 'kulenɛn 'nyranman 'si. E 'nan -wlɛ 'nan: «'Kulenɛn 'gʋɛ 'an nyɛn nɛn -ji. -Yɛɛ \"ta -sɛanla -e 'e drɛ 'ka -pli \"vɛ -a \"nyian Bali man 'e 'pee.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ɛn Zozi -a 'le 'sran 'nan: «Min nɛn e \"ta -daa 'an -nɔnlɛ 'an 'nanmannɔn lɛ bɛ, 'kʋ 'pɛ a -a san -a -pɔ -tʋwli \"ji. ");
INSERT INTO yreNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","'Wɩ tɩglɩ, Blamin -pɩ \"ta -daa \"kalɛ \"le zɩ Bali -a 'vɩ bɛ -yee 'wɩ 'zʋ. 'Pian min nɛn, e Blamin -pɩ -nɔn 'e 'nanmannɔn lɛ bɛ, 'wɩ -taa \"bɔlɛ \"man.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","-A -nan nɛn Zozi -srunɔn -a laabʋdɩ 'sia 'o cin lɔ 'nan: «-Tɩɛ cɩ 'wɩ zɩɛ -a drɛzan -a?» ");
INSERT INTO yreNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","\"Bɛ -sru ɛn -sa -fɔla Zozi -srunɔn yei. -Sa zɩɛ -nyrɛn 'nan, -tɩɛ cɩ 'o yei Zozi -sruzan -dan a? ");
INSERT INTO yreNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Kaa -tɔa 'nan, 'trɛda mingɔnnɛnnun min \"paala -sa wɩ -a. Ɛn minnun nɛn o cɩ min -dandannun -a bɛ, waa ve minnun lɛ 'nan 'o 'o laabʋ \"yi \"drɛnɔn. ");
INSERT INTO yreNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","'Pian 'cee vɛ bɛ, te 'e 'kɔn zɩ dɩ! Min nɛn e cɩ min -dan a 'ka yei \"bɛ, 'e 'fli drɛ \"le 'nɛn \"wɛnnɛn 'zʋ. Ɛn min nɛn e cɩ min tazan -a 'ka yei \"bɛ, 'e 'fli drɛ \"le min 'suzan 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","'Ka 'ci \"nrɔn 'wɩ 'gʋɛ -a da! Min nɛn e ya 'e -nyrandɩ fɛnun -sru \"bɛ, 'lee min nɛn e ya fɛnun zɩɛ -a \"paanan bɛ, -tɩɛ cɩ o yei min -dan a? Maan ve 'cɛɛ 'nan, min nɛn 'e -nyrandɩ fɛ -sru \"bɛ -a san nɛn. 'Pian mɛɛn cɩ 'ka yei \"le min 'suzan 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kaa 'gʋɛ, cɛɛ -fʋ 'an -sru \"trilii 'mɛn yra yɩdɩ pɛɛnɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","-Yee \"wɛan mingɔnnɛn trɛ nɛn 'an \"tɩ -a -nɔn 'mɛn bɛ, maan -nɔan \"nyian \"cee \"lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","-Kaa -taa \"fɛdi -blɩlɛ 'e cin va 'mɛn mingɔnnɛn trɛ da. Tʋ zɩɛ -a man bɛ, ka -kɔan 'ka -nyrandɩ mingɔnnɛn pɛinnun da, -e 'ka Izraɛl 'lɛglɔn 'fuda \"fli \"le tin 'ba.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","-A -nan nɛn Zozi -a vɩdɩ 'sia Simɔn Piɛri lɛ 'nan: «Simɔn! Satan 'ka laabʋ 'nan, -e 'e 'ka \"fee \"le 'saa 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","'Pian an Bali trʋ 'ba 'yiɛ 'nan, -e 'yie yi -tɛradɩ 'an da 'e vɩlɛ 'e 'le 'tɔ dɩ. Ɛn \"bɛ -sru, -te i 'li 'i da \"nyian 'an -sru \"bɛ, 'i \"bʋɩnun man -tɔ 'plɛblɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ɛn Piɛri -a 'vɩ Zozi lɛ 'nan: «Minsan, 'an 'man a 'e wʋʋdɩ. -Te e ya -pʋ 'kuin -a oo, ɛn -te e ya -kadɩ -a oo, 'an 'man a 'e wʋʋdɩ -e 'kʋ 'kʋ 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «Piɛri, maan ve 'yiɛ 'nan, cɛɛgʋ, yia ve 'e 'pa -a yaaga 'nan, yi'an tɔa dɩ, 'vaa -e mannɛn tɛdɛ 'e 'wɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","\"Bɛ -sru ɛn Zozi -a laabʋ o pɛɛnɔn 'lɔ 'nan: «Tʋ nɛn an 'ka 'pa 'sia, te \"lala 'ka 'ka 'lɔ dɩɛ, ɛn te 'pada 'ka 'ka 'lɔ dɩɛ, ɛn te -manwua 'ka 'ka 'cɛin -man dɩɛ, fɛ -tʋ klɩ 'ka man?» Ɛn o 'nan -yrɛ 'nan: «-Cɛjɛ. Fɛ -tʋ 'ka 'klɩlɛ 'kʋ man dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Pian 'bɛ nɛn 'gʋɛ, min nɛn \"lala a -yrɔ \"bɛ, 'e 'sia! Ɛn min nɛn 'pada a -yrɔ \"bɛ, 'e 'sia! Ɛn min nɛn sɛn 'ka -yrɔ \"dɩɛ, 'e 'yee -tralɛ 'tan, -e 'e 'yee sɛn 'lɔ! ");
INSERT INTO yreNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Fɛ -le \"wɛan nɛn an 'wɩ zɩɛ -a 'vɩ bɛ, 'wɩ nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, e \"ta 'lɛ sɔɔman 'an da. 'Wɩ zɩɛ e ya 'e 'crɛn -tɛdɩ 'nan: ‹Minnun -taa -a 'silɛa 'wɩ 'wlidɩ \"drɛzan -a.› 'Wɩ pɛɛnɔn nɛn 'e 'crɛn -tɛdɩ 'an man bɛ, -a 'lɛ sɔɔdɩ 'bɔ 'kogo.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɛn -a -srunɔn -a 'vɩ -yrɛ 'nan: «Minsan, sɛn \"fli \"nɛn 'gʋ!» 'Pian e 'nan -wlɛ 'nan: «E 'bɔ \"yi!» ");
INSERT INTO yreNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","\"Bɛ -sru ɛn Zozi 'kʋ Olivie pɔn da \"le zɩ yaa dra 'e 'cɛn bɛ -yee 'wɩ 'zʋ. Ɛn -a -srunɔn sɔɔnla -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Zɩ o 'bɔla fɛ zɩɛ -a -nan bɛ, ɛn e 'nan -wlɛ 'nan: «'Ka Bali trʋ 'ba -e 'wɩ 'wlidɩ 'e vɩlɛ 'e 'ka 'man yɩ dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ɛn e 'si o \"srɔn \"kogo, e -kʋ 'e 'lɛ fɔɔ. 'E \"po sɔɔnla ɛn e Bali trʋ 'badɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Yaa 'vɩ 'nan: «'An \"tɩ, -te i \"we \"man \"bɛ, 'kulenɛn nɛn 'wɩ yɩdɩ cɩ -ji 'gʋɛ, 'i 'si 'an man -kɔɔbli! 'Pian te 'an 'ci 'sɔ wɩ nɛn 'e drɛ dɩ, 'i 'bɔ 'ci 'sɔ wɩ nɛn 'e drɛ!» ");
INSERT INTO yreNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tɔɔn ɛn Bali -le 'pasiazan -tʋ 'si laji, e -ta -a man -tɔlɛ 'plɛblɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","\"Klan -a -tɛdɩ 'sia 'wlidɩ, ɛn e Bali trʋ 'badɩ 'sia 'kpa tɩglɩ. -A man 'tɛdɛ drɛ nyɛn -a te e -sɛanla \"tra. ");
INSERT INTO yreNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Zɩ e cɛɛn Bali trʋ 'badɩ man bɛ, ɛn e -ta 'e -srunɔn 'va. E 'bɔ o man, te o ya yi -tɛnan. O ta drɛ 'trɔdrɔ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ɛn Zozi \"e 'nan -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn ka ya yi -tɛnan? 'Ka 'wluan lou, 'ka Bali trʋ 'ba, -e 'wɩ 'wlidɩ 'e vɩlɛ 'e 'ka 'man yɩ dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Zozi 'fʋ 'wɩ zɩɛ -a vɩnan, ɛn minnun -tadɩ 'sia \"kaga. Zudazi nɛn -a -srunɔn 'fuda \"fli 'bɔ 'va min -tʋ -a bɛ, e yra o 'lɛ. E pli Zozi man 'nan -e 'e -atu -tɛ \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ɛn Zozi \"e 'nan -yrɛ 'nan: «Zudazi, -atu -tɛdɩ -a nɛn i Blamin -pɩ -nɔan \"minnun lɛ -e 'o -tɛ?» ");
INSERT INTO yreNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Zozi -srunɔn nɛn Zozi \"srɔn \"bɛ, waa -kɔnnɛn 'yɩ 'nan 'wɩ 'tʋ \"ta dra, ɛn waa laabʋ Zozi 'lɔ 'nan: «'Kʋ 'san, sɛn -a nɛn 'kʋ 'kuli -tan o man?» ");
INSERT INTO yreNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ɛn o va min -tʋ 'yee vɛ tuʋ Bali -pannɔn 'tazan 'suzan 'tʋ lɛ. Yaa -pɛ \"yi \"da \"trɔɛn cɛɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","'Pian Zozi \"e 'nan -wlɛ 'nan: «'Ka 'tɔ! 'Ka 'tɔ!» -A -nan nɛn e klɛ min zɩɛ -a \"trɔɛn \"man, ɛn e drɛ \"plɔnblɔn 'e \"pa 'ji. ");
INSERT INTO yreNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ɛn Zozi \"e 'nan Bali -pannɔn 'tanɔn, 'lee minnun tanɔn nɛn 'o yiɛ -tɔa Bali -pan 'kɔn 'va bɛ, 'lee min cejenun lɛ 'nan: «-Mɛ \"le \"wɛan nɛn ka -ta 'an 'kunlɛ 'ka 'lɔ le sɛnnun 'lee yibanun -a \"le ka -ta crinzan -sru? ");
INSERT INTO yreNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tʋ pɛɛnɔn man an ya 'ka yei Bali -pan 'kuin, ɛn ka'an 'kunlɛ dɩ. 'Pian 'bɛ nɛn 'gʋɛ 'cee tʋ 'bɔ \"mɛn. Ɛn Satan nɛn e -cia \"klun va bɛ, -yee tʋ 'bɔ \"nyian.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","O Zozi 'kun, ɛn o -kʋ -a Bali -pannɔn 'tazan -le -klɔn -ji. Piɛri sɔɔnla o -sru \"kɔɔbli. ");
INSERT INTO yreNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","O 'tɛ 'sɔn -klɔn 'bɔ yei 'sɛzɛ, ɛn o -nyran -a \"srɔn. Ɛn Piɛri -nyran o yei. ");
INSERT INTO yreNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","-A -nan nɛn nɔan lɩmɔn -tʋ -a 'yɩ 'e -nyrandɩ 'tɛ man. Yaa -nanjɛɛn tɛin, ɛn e 'nan: «Min 'gʋɛ, e ya \"nɛn -a -sru.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","'Pian Piɛri yɔɔ \"da. E 'nan: «Lɩmɔn, ma'an min 'labɛ -a tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Fɔɔnɔn min pee Piɛri 'yɩ \"nyian, ɛn \"bɛ -yrɛ 'nan: «'I 'bɔ 'gʋɛ -a -sruzan -tʋ nɛn yia.» Ɛn Piɛri \"e -yrɛ 'nan: «An 'ka o va dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Zɩ o 'mɔn \"nyian -trilii bɛ, ɛn min -tʋ kɔala \"man -a vɩdɩ -a 'nan: «'Wɩ tɩglɩ nɛn min 'gʋɛ e ya \"nɛn -a -sru. Kɔɔ Galile min nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ɛn Piɛri \"e 'nan -yrɛ 'nan: «'Wɩ nɛn yie 'nan 'i ve bɛ, ma'an tɔa dɩ.» E -fʋ 'wɩ zɩɛ -a vɩnan ɛn mannɛn wɩɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","-A -nan nɛn Minsan 'e 'man lila, ɛn e Piɛri -nanjɛɛn. 'Wɩ nɛn Minsan -a 'vɩ bɛ, -a -cin -tɔ Piɛri ji. Kɔɔ Minsan -a 'vɩ -yrɛ 'nan: «Cɛɛgʋ, yia ve 'e 'pa -a yaaga 'nan, yi'an tɔa dɩ, 'vaa -e mannɛn tɛdɛ 'e 'wɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","-A -nan nɛn Piɛri 'bɔla bei, ɛn e -wuɔdɩ 'sia 'wɩ 'nanmandɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Minnun nɛn o yiɛ cɩ Zozi 'va bɛ, waa sɛɛ wo te waa -sɔan. ");
INSERT INTO yreNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","O sɔ -fɔa -a yra -e 'o 'wɩ laabʋ -yrɔ 'nan: «I ya Bali 'lewei vɩzan -a, min nɛn e fɛ tuʋ 'yiɛ bɛ, 'i san -kɔɔn!» ");
INSERT INTO yreNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Te o 'wɩ \"kaga \"ve -yrɛ \"nyian \"srɔn pɛ -ji. ");
INSERT INTO yreNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Zɩ tʋ cɛɛn bɛ, ɛn min cejenun 'lee Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn 'o cin 'yɩ. 'O cin 'yɩ 'nan -e 'o Zozi 'le tin 'ba. O 'nan 'o 'ta Zozi 'a 'wlɛ. -A -nan nɛn minnun -ta Zozi 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ɛn tin 'banɔn 'bɔ -a laabʋ -yrɔ 'nan: «Min 'sizan 'wɩ 'ji Crizi nɛn 'yia? 'I vɩ 'kʋɛ!» Ɛn Zozi \"e 'nan -wlɛ 'nan: «-Te maan 'vɩ 'cɛɛ oo, ka'a yi tɛala \"da \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ɛn -te an 'wɩ laabʋ 'ka 'lɔ oo, ka'a ve 'mɛn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Maan ve 'cɛɛ 'nan, -e 'e 'sia cɛɛgʋ yi 'gʋɛ -a da bɛ, 'an 'bɔ Blamin -pɩ -kɔan 'an -nyrandɩ 'plɛblɛ pɛɛnɔn 'san Bali -pɛ \"yi \"da.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɛn o pɛɛnɔn -a 'vɩ -yrɛ 'nan: «Yioo, Bali -pɩ nɛn 'yia?» Ɛn Zozi \"e 'nan -wlɛ 'nan: «-A 'bɔ nɛn kaa 'vɩ bɛ, an ya -a.» ");
INSERT INTO yreNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tɔɔn ɛn o 'nan: «E 'ka \"le -e -kaa 'wɩ laabʋ \"nyian min pee -lɔ \"fo \"dɩ. -Kaa 'wɩ 'bɔ 'man -a 'le 'va.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Minnun pɛɛnɔn wluan lou 'e cin va, ɛn o -kʋ Zozi 'a Rɔm min -kɔnmandan Pilati 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","O 'wɩ 'padɩ \"da 'sia -a vɩdɩ -a 'nan: «Min 'lagʋɛ, 'e 'wɩ 'fɔla minnun yei -cee 'lɛglɔn 'ji. -Yɛɛ 'vɩ 'nan, te minnun 'o 'sukɔlɛ -pan wʋ Rɔm 'nɔn 'le mingɔnnɛn Seza lɛ dɩ. Ɛn yaa 'vɩ 'e 'fli man 'nan, 'yɛɛ cɩ 'kʋe mingɔnnɛn -a, ɛn Bali 'e 'pa 'sia 'nan -e 'e 'kʋ 'si 'wɩ 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","-A -nan nɛn Pilati 'wɩ laabʋ Zozi 'lɔ 'nan: «Zuif 'nɔn 'le mingɔnnɛn nɛn 'yia?» Ɛn Zozi \"e 'nan -yrɛ 'nan: «-A 'bɔ nɛn yia 'vɩ bɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ɛn Pilati \"e 'nan Bali -pannɔn 'tanɔn 'lee minnun lɛ 'nan: «Ma'an 'wɩ 'wlidɩ 'ye min 'gʋɛ -yee 'wɩ 'va -e 'o 'kun \"man \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","'Pian o kɔala \"man te waa ve 'nan: «E 'wɩ 'fɔla minnun yei 'wɩ \"paadɩ -a Zude 'lɛglɔn pɛɛnɔn 'ji. Yaa pou 'sia Galile ɛn e 'bɔla Zeruzalɛm 'gʋ.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Zɩ Pilati 'wɩ zɩɛ -a 'man bɛ, ɛn yaa laabʋ 'nan: «Galile min nɛn?» ");
INSERT INTO yreNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Minnun -a wun -fɔ -yrɛ. Zɩ yaa 'man 'nan, Zozi \"sia 'lɛglɔn nɛn Erodi -a \"paala bɛ -a -ji bɛ, ɛn e 'nan 'o 'kʋ -a Erodi lɛ. Kɔɔ tʋ zɩɛ -a man bɛ te Erodi 'bɔ a Zeruzalɛm. ");
INSERT INTO yreNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Zɩ Erodi Zozi 'yɩ bɛ, ɛn -a ci nran 'kpa tɩglɩ. Kɔɔ -a -nan 'mɔn te e ya \"vale 'e Zozi 'bɔ ye, 'wɩnun nɛn yaa maan \"man \"bɛ -yee \"wɛan. Ɛn -a -cin a Erodi 'bɔ 'ji 'nan 'e 'lɛbo \"fɔ wɩ -tʋ drɛ 'e yiɛ man. ");
INSERT INTO yreNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","E 'wɩ laabʋ Zozi 'lɔ \"kaga, 'pian Zozi 'ka 'wɩ 'silɛ \"da -yrɛ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bali -pannɔn 'tanɔn 'lee 'fluba 'ci vɩnɔn a 'o 'tɔdɩ Zozi \"srɔn, te \"o 'wɩ \"paa \"da 'lɛbo 'plɛ 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","-A -nan nɛn Erodi 'lee 'yee 'sounjanun Zozi drɛdɩ 'sia 'o 'pɛla koda. Waa sɛɛ 'wʋ, o mingɔnnɛn sɔ fɛnyian 'wʋ \"da -a sɛɛ wʋdɩ -a \"nyian. \"Bɛ -sru ɛn Erodi -a 'li 'e da Pilati lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Yi 'bɔ 'lein zɩɛ -a da nɛn, Pilati 'lee Erodi drɛ bee -a, te o yei 'ka \"nɛn -a ble dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","\"Bɛ -sru ɛn Pilati Bali -pannɔn 'tanɔn 'lee minnun tanɔn cin 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ɛn e 'nan -wlɛ 'nan: «Ka -ta min 'gʋɛ -a 'mɛn, ɛn ka 'nan e ya 'wɩ 'fɔlanan minnun yei. -Yee \"wɛan an 'wɩ laabʋ -yrɔ 'ka yiɛ man. 'Pian 'wɩ pɛɛnɔn nɛn kaa 'pa \"da \"bɛ, ma'an yɩlɛ -a drɛzan -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ɛn \"nyian bɛ Erodi 'ka \"nyian \"e \"yɩlɛ -a drɛzan -a dɩ, kɔɔ yaa 'li 'e da -cɛɛ. Min 'gʋɛ, ya'a 'wɩ 'tʋ drɛlɛ -e 'e 'ka -a 'wɩ 'ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","-Yee \"wɛan maan ve 'mɛn minnun lɛ 'nan 'o -sɔn, -e 'o 'si \"man.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lɛ -tʋdʋ pɛɛnɔn man bɛ, -te Zuif 'nɔn tranun -le 'sidɩ nɔanba -ji \"fɛdi drɛdɩ 'bɔ bɛ, Pilati \"sia -pʋ 'kɔnzan 'tʋ man. ");
INSERT INTO yreNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Zɩ minnun 'wɩ nɛn Pilati -a 'vɩ bɛ -a 'man bɛ, ɛn o pɛɛnɔn -paandɩ 'sia. O 'nan: «'I min 'labɛ -a -tɛ, -e 'i 'si Barabazi man 'kʋɛ!» ");
INSERT INTO yreNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabazi zɩɛ waa -fɔ -pʋ 'kuin, kɔɔ e 'wɩ 'fɔla minnun 'lee min tanɔn yei 'fla, ɛn e min -tɛ 'wɩ zɩɛ -a -ji. ");
INSERT INTO yreNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilati 'wɩ tin 'ba \"nyian -wlɛ, kɔɔ e ya \"vale 'e \"sia Zozi man. ");
INSERT INTO yreNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","'Pian te minnun -paanman 'nan: «'I -pɛin yiba \"plan da! 'I -pɛin yiba \"plan da!» ");
INSERT INTO yreNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilati 'wɩ laabʋ -wlɔ -a 'pa yaagazan da 'nan: «'Wɩ 'wlidɩ \"cɛn \"nɛn yaa drɛ? Kɔɔ ma'an 'wɩ 'tʋ yɩlɛ \"man -e 'e 'ka 'bɛ 'ji dɩ. -Yee \"wɛan maan ve 'mɛn minnun lɛ 'nan 'o -sɔn, -e 'o 'si \"man.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'Pian minnun kɔala \"man, te o -paanman 'plɛblɛ -a vɩdɩ -a 'nan: «'I -pɛin yiba \"plan da!» -Wee -paandɩ -le \"wɛan, ");
INSERT INTO yreNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilati wɩɩ 'wɩ nɛn waa 'vɩ bɛ -a man. ");
INSERT INTO yreNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","-A -nan nɛn e 'si Barabazi man. Min zɩɛ waa -fɔ -pʋ 'kuin 'nan e 'wɩ 'fɔla minnun 'lee min tanɔn yei, ɛn e min -tɛ. Ɛn e Zozi 'nɔn 'yee 'sounjanun lɛ 'nan 'o 'kʋ -a -tɛ \"le zɩ minnun cɩ \"va \"bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","'Sounjanun -kʋdɩ 'sia Zozi 'a, ɛn 'o cin 'yɩ Sirene min -tʋ -a. Waa laabo Simɔn, ɛn e \"sia fei. Waa 'kun, ɛn o Zozi 'le yiba \"plan -nɔn -yrɛ 'nan 'e 'sia -e 'e -sɔɔnla Zozi -sru. ");
INSERT INTO yreNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Min \"kaga 'kpa 'lee lɩmɔn \"kaga 'kpa yra -a -sru. Lɩmɔnnun 'o 'pɛ -sɛn 'o 'win -ji, te o -wua -yee \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ɛn Zozi 'e 'man lila o da. E 'nan -wlɛ 'nan: «Zeruzalɛm lɩmɔnnun, te 'ka 'wuɔ 'mɛn \"wɛan dɩ! 'Pian 'ka 'cee 'nɛnnun 'lee 'ka 'bɔ 'fli -wuɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Maan ve 'cɛɛ 'nan tʋ -wlidɩ -taa \"bɔlɛ, te ka ya -a vɩnan 'nan: ‹Bali -le -fɛa a lɩmɔnnun nɛn wa'a 'nɛn 'yaa dɩɛ o man. Ɛn Bali -le -fɛa a \"nyian lɩmɔnnun nɛn wa'a 'nɛn 'yalɛ dɩɛ o man.› ");
INSERT INTO yreNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tʋ zɩɛ -a man bɛ, kaa ve pɔnnun lɛ 'nan: ‹'Ka 'kʋ 'ta 'san!› Ɛn kaa ve pɔnnɛnnun lɛ 'nan: ‹'Ka 'tɛ 'kʋ da!› ");
INSERT INTO yreNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Maan ve 'cɛɛ 'nan, -te 'wɩ 'gʋɛ minnun a -a drɛnan yiba \"bedrɛn \"lɛ bɛ, yiba \"kadɩ -le vɛ -taa 'ciɩlɛa \"da.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","'Sounjanun -kʋ 'wɩ 'wlidɩ \"drɛnɔn \"fli \"a, 'nan -e 'o o -tɛɛ 'o 'vale Zozi 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Zɩ o 'bɔla fɛnan nɛn waa laabo min -wulo klo bɛ -a -nan bɛ, ɛn 'sounjanun Zozi 'lee 'wɩ 'wlidɩ \"drɛnɔn \"fli 'bɔ pɛin yiba \"plan da. 'Sounjanun o pɛin 'tʋdʋ, -a -tʋ a Zozi 'pɛ \"yi \"da, ɛn -a -tʋ a -a -pɛ bʋ da. ");
INSERT INTO yreNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","-A -nan nɛn Zozi \"e 'nan: «'An \"tɩ, 'wɩ 'wlidɩ \"nɛn o cɩ -a drɛnan 'mɛn bɛ, 'i o man wɩ 'cɛ. Kɔɔ 'wɩ nɛn o cɩ -a drɛnan bɛ, wa'a tɔa dɩ.» 'Sounjanun Zozi 'man sɔ pli 'lein 'wlɛ 'tuʋladɩ da. ");
INSERT INTO yreNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Minnun a -nan te waa -nan ye. Minnun tanɔn 'le vɛ bɛ, \"o Zozi sɛɛ 'wʋ -a vɩdɩ -a 'nan: «E min peenun 'si 'wɩ 'ji. -Te -yɛɛ cɩ min 'sizan 'wɩ 'ji nɛn Bali -a 'pa 'sia bɛ -a bɛ, 'e 'fli 'si 'wɩ 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","'Sounjanun \"o sɛɛ 'wʋ \"nyian, ɛn o -wɛn 'wlɛ 'cɛn 'nɔn -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Waa 'vɩ -yrɛ 'nan: «-Te i ya Zuif 'nɔn 'le mingɔnnɛn -a bɛ, 'i 'fli 'si 'wɩ 'ji!» ");
INSERT INTO yreNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Waa crɛn -tɛ yiba 'fʋɩ da, ɛn waa pɛin Zozi 'ta lou. Waa crɛn -tɛ \"da 'nan: ");
INSERT INTO yreNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","'Wɩ 'wlidɩ \"drɛzan nɛn yiba \"plan -tʋ da bɛ, e Zozi \"srɔndɩ 'sia. E 'nan: «Yie 'nan 'i ya min 'sizan 'wɩ 'ji -a, 'i 'fli 'si 'wɩ 'ji, -e 'i 'kʋ 'si 'wɩ 'ji \"nyian!» ");
INSERT INTO yreNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ɛn -a bɔɛzan 'wɩ 'pla -yrɛ 'nan: «Yi'a 'klanman Bali lɔ dʋʋ? I ya 'i yra yɩnan \"le -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","'Pian 'kʋe yra yɩdɩ bɛ, -a -nɔan da nɛn. Kɔɔ 'wɩ nɛn kʋa drɛ bɛ, -a \"nɛn \"nɛn kʋ cɩ -a yɩnan. Min 'labɛ, ya'a 'wɩ 'wlidɩ \"tʋ drɛlɛ \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ɛn 'wɩ 'wlidɩ \"drɛzan zɩɛ yaa 'vɩ Zozi lɛ 'nan: «Zozi, tʋ nɛn i mingɔnnɛn -blɩdɩ \"siala bɛ, 'an 'cin 'e 'tɔ 'i 'ji!» ");
INSERT INTO yreNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «Maan ve 'yiɛ 'wɩ tɩglɩ 'a 'nan, cɛɛgʋɛ, 'kʋ 'vale 'yia kʋɛ -kɔan Bali -le fɛnan nɛn min 'ka 'e yra ye dɩɛ -a -nan.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yidɛ 'bɔ min -win -ji 'sɛzɛ, ɛn klun -trɔa 'trɛ pɛɛnɔn da. E -fʋ zɩɛ -trilii, ɛn funninmlan yidɛ tɛɛnla. ");
INSERT INTO yreNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Klun -fʋ yidɛ yra, ɛn sɔ -dan nɛn 'e 'tindɩ Bali -pan 'kuin bɛ, e 'fʋɩ 'bʋ 'ji \"fli. E 'fʋɩ bʋdɩ 'sia lou, ɛn yaa -sɛn \"tra. ");
INSERT INTO yreNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Zozi paan wei 'plɛblɛ 'ji. Yaa 'vɩ 'nan: «'An \"tɩ, 'an lei -nɔan 'yiɛ 'e \"pa 'ji.» E 'wɩ zɩɛ -a 'vɩ, ɛn 'e yiɛ 'lɛ 'wʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Zɩ 'sounjanun tazan 'wɩnun zɩɛ -a -nan 'yɩ bɛ, ɛn e 'tɔ -dan nɔndɩ 'sia Bali lɛ. E 'nan: «'Wɩ 'kpa nɛn, min 'labɛ min tɩglɩ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Minnun pɛɛnɔn nɛn o -ta 'wɩ zɩɛ -a -nan yɩlɛ bɛ, 'wɩnun nɛn e drɛ o yiɛ man bɛ, waa 'yɩ. -Yee \"wɛan o 'li 'o da, te 'o 'pɛ a 'e 'fɔdɩ 'o man. ");
INSERT INTO yreNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Minnun pɛɛnɔn nɛn o Zozi -tɔa \"bɛ, 'lee lɩmɔnnun nɛn o 'si waa Galile ɛn o -ta -a 'palɛ bɛ, o ya 'o 'tɔdɩ -kɔɔbli, te 'wɩ nɛn e cɩ drɛnan bɛ waa ye. ");
INSERT INTO yreNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Min -tʋ a bɛ, waa laabo Zozɛfʋ. E ya min tɩglɩ 'a, ɛn e ya Zuif 'nɔn 'le tin 'bazan -dan tʋ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","'Pian 'wɩ nɛn tin 'banɔn -mie -a 'vɩ 'lee waa drɛ Zozi lɛ bɛ, e 'ka -a -sru \"dɩ. Zozɛfʋ 'bɔ zɩɛ, e \"sia Zude 'lɛglɔn 'ji, 'fla nɛn waa laabo Arimate bɛ -a da, ɛn e ya -a man -pɛnnan 'nan Bali 'e mingɔnnɛn -blɩdɩ 'sia 'yee minnun da. ");
INSERT INTO yreNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Zozɛfʋ zɩɛ -yɛɛ kʋ toba -fɔlɛ Pilati lɛ 'nan, 'e Zozi pa -nɔn 'yrɛ -e 'e wʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Zozɛfʋ Zozi 'kadɩ 'si yiba \"plan da. E sɔ fɛnyian 'pa \"man, ɛn e -kʋ -a wʋlɛ -yrɛ nɛn, waa cɛɛn puo -kɔlɛ ji bɛ -a -ji. -Yrɛ zɩɛ, wa'a tian min wʋlɛ \"ji \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yi zɩɛ, yaa yi nɛn, ɛn Zuif 'nɔn 'le 'flinla \"yi \"ta 'e pou \"siala. ");
INSERT INTO yreNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Lɩmɔnnun nɛn o 'si 'o 'vale Zozi 'a Galile bɛ, o -kʋ Zozɛfʋ 'palɛ. O yiɛ 'tɔ fɛnan nɛn o \"ta Zozi wo bɛ -a -nan. Zɩ waa 'pla bɛ waa 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","-A -nan nɛn o 'li 'o da 'wee \"kɔnnɛn, o -kʋ 'nyrɔn 'lee tɔɔ nɛn -a -koei \"a 'nɔnnɔn bɛ -a drɛlɛ. Kɔɔ \"trɛ \"bɛ 'flinla \"yi nɛn, ɛn o \"flianla \"le zɩ -wee -pei -a 'vɩ bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","'Mɔnnɛn yi 'bɛ cɩ Zuif 'nɔn 'le 'flinla \"yi -sru \"yi -a. 'Mɔnnɛn yi zɩɛ -a bodrun puunɔn nɛn lɩmɔnnun zɩɛ o -kʋ Zozi 'yrɛ da 'o 'lɔ le 'nyrɔn 'lee tɔɔ nɛn waa drɛ bɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","-Kɔlɛbu -dan nɛn 'e 'tɔdɩ -yrɛ \"nɛn \"bɛ, waa 'yɩ 'e 'sidɩ \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","-A -nan nɛn o wlala -yrɛ 'bɔ 'ji. 'Pian wa'a Minsan Zozi pa yɩlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","'Wɩ zɩɛ e 'baba 'fɔ o man. Ɛn min \"fli 'bɔla 'ji o va 'o 'ta le sɔ 'fuvu 'yrɩyrɩ 'a. ");
INSERT INTO yreNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","-A -nan nɛn nyɛn o cɛɛn ɛn 'o 'wulo -fɔ 'o 'wlu. 'Pian min \"fli zɩɛ o 'nan -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn min nɛn -a yiɛ cɩ \"man \"bɛ, kaa -wɛɛman minnun nɛn o kaa bɛ o va? ");
INSERT INTO yreNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Zozi 'ka fɛ 'gʋɛ -a -nan dɩ, e wluan 'kanɔn 'va. 'Wɩ nɛn yaa 'vɩ te e ya tian Galile bɛ, -a -cin 'e -sɔɔnla 'ka 'ji. ");
INSERT INTO yreNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kɔɔ yaa 'vɩ 'nan: ‹Minnun Blamin -pɩ -nɔan 'wɩ 'wlidɩ \"drɛnɔn lɛ -e 'o -tɛ. Waa -pɛinman yiba \"plan da, -a yi yaagazan da bɛ -e 'e 'wluan -kanɔn 'va.› » ");
INSERT INTO yreNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tɔɔn ɛn 'wɩ nɛn Zozi -a tin 'pa -wlɛ \"bɛ, -a -cin sɔɔnla o ji. ");
INSERT INTO yreNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","-A -nan nɛn o 'bɔla -yrɛ zɩɛ -a ji. Ɛn o -kʋ 'wɩ zɩɛ -a vɩlɛ Zozi -srunɔn 'fuda -tʋ 'lee min -mienun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Lɩmɔnnun nɛn o -kʋ -yrɛ da bɛ, o 'tɔ nɛn 'gʋ: Madala lɩ Mari a, ɛn Zanɛn a, ɛn Zaji \"bʋ Mari a, 'lee lɩmɔn -mienun. -Wɛɛ 'wɩ nɛn e drɛ bɛ, -a 'sinan 'pa Zozi 'le 'pasianɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","'Wɩ zɩɛ Zozi -srunɔn 'a 'sia -sɛɛ \"wʋ wɩ -a, ɛn wa'a yi -tɛlɛa \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","'Pian Piɛri wluan, ɛn e -kʋ flan -a Zozi -yrɛ da. Zɩ e 'bɔla 'nan nun bɛ, ɛn e 'kunnan, \"yɛɛ yiɛ 'tɔ bɛ, te e sɔ nɛn waa 'pa Zozi man bɛ, -a ye 'e -srandɩ \"tra. -A -nan nɛn e 'li 'e da 'yee vɛnan, te -a 'plo a 'e 'fɔdɩ 'wɩ nɛn yaa -nan 'yɩ bɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yi 'bɔ 'lein zɩɛ -a da nɛn Zozi -srunɔn \"fli -kʋdɩ 'sia 'fla nɛn waa laabo Emauzi bɛ -a da. 'Fla zɩɛ e ya Zeruzalɛm man kilo -fu da. ");
INSERT INTO yreNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","O ya -sɛɛ \"wʋnan 'wɩ pɛɛnɔn nɛn e drɛ bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","\"Wɛɛ -kɔn 'wɩ tin 'banan 'wɩnun zɩɛ -a da bɛ, ɛn Zozi 'bɔ o man, ɛn o -kʋdɩ 'sia waa. ");
INSERT INTO yreNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Waa 'yɩ, 'pian wa'a -kɔnnɛn \"yɩlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ɛn Zozi -a laabʋ -wlɔ 'nan: «-Mɛ \"wɩ nɛn kaa ve, te ka -ko 'ta wʋdɩ -a 'gʋ?» O ta drɛ 'trɔdrɔ, ɛn o -tɔ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Min \"fli zɩɛ -a -tʋ a \"va \"bɛ waa laabo Kleopa. E 'nan Zozi lɛ 'nan: «'I 'tʋwli yiɛ cɩ Zeruzalɛm, te 'wɩ nɛn e drɛ 'nan bɛ, yi'a tian \"i \"manlɛ \"fo \"dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ɛn Zozi -a laabʋ -wlɔ 'nan: «-Mɛ \"wɩ 'bɛ drɛ Zeruzalɛm?» -A -nan nɛn o 'nan -yrɛ 'nan: «Nazarɛtɩ min Zozi 'le 'wɩ nɛn. Bali 'lewei vɩzan -dan nɛn. 'Wɩnun nɛn yaa 'vɩ, 'lee 'wɩnun nɛn yaa drɛ bɛ, -wɛɛ -ci -kɔɔnman 'nan Bali 'bɛ 'pa 'sia, ɛn minnun -a -tɔ 'nan 'wɩ 'kpa nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","'Pian -cee Bali -pannɔn 'tanɔn 'lee -kaa tanɔn -a -nɔn minnun lɛ 'nan 'o -tɛ. Ɛn waa -tɛ yiba \"plan da. ");
INSERT INTO yreNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","-A -cin a \"nɛn 'kʋ 'ji 'nan, -yɛɛ \"ta -daa Izraɛl 'nɔn 'silɛ 'wɩ 'ji. 'Pian 'wɩ zɩɛ e 'bɔ \"man -a -nan yi yaaga nɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ɛn \"nyian bɛ cɛɛgʋ bodrun 'gʋɛ, lɩmɔnnun nɛn kʋ cɩ waa bɛ, o -kʋ -yrɛ da. Ɛn o -ta 'lɛbo \"fɔ wɩ -dan vɩlɛ 'kʋɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","O 'nan, wa'a Zozi pa yɩlɛ -yrɛ -ji dɩ, ɛn Bali -le 'pasianɔn 'bɔla 'ji o va. Bali -le 'pasianɔn zɩɛ o 'nan Zozi yiɛ a \"man. ");
INSERT INTO yreNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Min -mienun nɛn kʋ cɩ waa bɛ, \"o -kʋʋ \"nyian -yrɛ da. Waa 'yɩ \"le zɩ lɩmɔnnun -a 'vɩ bɛ -yee 'wɩ 'zʋ. Ɛn o 'bɔ \"nyian wa'a Zozi yɩlɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Cee 'wɩ ci mandɩ a 'plɛblɛ. -Mɛ \"le \"wɛan nɛn 'wɩnun nɛn Bali 'lewei vɩnɔn -a 'vɩ bɛ, e ya 'ka 'lɔ 'plɛblɛ -e 'ka yi -tɛra \"da? ");
INSERT INTO yreNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kɔɔ Bali 'lewei vɩnɔn -a crɛn -tɛ 'wein 'nan, 'wɩnun zɩɛ -wɛɛ bɔa min 'sizan 'wɩ 'ji Crizi man, 'vaa -e 'e mingɔnnɛn -blɩdɩ 'sia.» ");
INSERT INTO yreNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","-A -nan nɛn Zozi 'wɩ pɛɛnɔn nɛn 'e 'crɛn -tɛdɩ 'e 'bɔ man bɛ, -a -ci 'vɩ -wlɛ. Yaa 'sia 'wɩnun nɛn 'o 'crɛn -tɛdɩ Moizi -le 'fluba 'ji bɛ -a da, ɛn yaa 'le 'sran 'wɩ pɛɛnɔn nɛn Bali 'lewei vɩnɔn -a 'vɩ bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Zɩ o 'bɔla 'fla nɛn o \"ta -ko \"da \"bɛ -a \"srɔn \"kogo bɛ, ɛn Zozi -a drɛ \"le 'e \"ta -ko -kɔɔbli. ");
INSERT INTO yreNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","'Pian min \"fli zɩɛ o kɔala \"man -a trʋ 'badɩ -a 'nan: «'I 'fʋ 'kʋ va 'gʋ, kɔɔ funninmlan 'pla, ɛn -pei cɛɛn tandɩ man.» Zozi wlala o va, ɛn e -fʋ o va. ");
INSERT INTO yreNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Zɩ o -nyran 'nan -e 'o fɛ -blɩ bɛ, ɛn Zozi 'kpɔun 'si, e Bali muo \"fɔ, yaa \"nɛn jɛɛn, ɛn yaa -nɔn -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","-A -nan nɛn o yiɛ da 'si, ɛn o Zozi -kɔnnɛn 'yɩ. 'Nun tɔɔn ɛn e 'san o 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ɛn waa vɩdɩ 'sia 'o cin lɛ 'nan: «Fɛ -le \"wɛan nɛn -a wei 'kʋ 'sianan paan -sia, te e ya Bali wei nɛn 'e 'crɛn -tɛdɩ bɛ, -a -ci vɩnan 'kʋɛ bɛ, kʋa -ci 'man \"mɛn.» ");
INSERT INTO yreNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","-A -nan nɛn min \"fli zɩɛ, o 'li 'o da \"nyian Zeruzalɛm. O 'bɔ Zozi -srunɔn 'fuda -tʋ 'lee min -mienun man 'o cin yɩdɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ɛn minnun nɛn 'o cin yɩdɩ bɛ, waa vɩdɩ 'sia min \"fli zɩɛ -wlɛ 'nan: «Minsan wluan 'kanɔn 'va, 'wɩ 'kpa nɛn. 'E 'fli kɔɔn Simɔn lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ɛn min \"fli zɩɛ, 'wɩ nɛn e drɛ \"nyian -wee \"lɛ -sia bɛ waa 'vɩ. Ɛn zɩ waa -kɔnnɛn 'yɩ 'kpɔun \"nɛn 'jɛnnan bɛ, waa 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","O -fʋ 'wɩ zɩɛ -a vɩnan, ɛn Zozi 'bɔla 'ji o yei, ɛn e o 'tɔ 'bʋ. Yaa 'vɩ -wlɛ 'nan: «Bali 'e 'fʋdɩ -trɔɔ -nɔn 'cɛɛ!» ");
INSERT INTO yreNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","-A -nan nɛn \"klan -sɛn o ji, ɛn nyɛn o cɛɛn. 'O 'ci nrɔn 'nan min lei nɛn. ");
INSERT INTO yreNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ɛn Zozi \"e 'nan -wlɛ 'nan: «-Mɛ \"le \"wɛan nɛn \"klan 'ka -tɛa? Ɛn -mɛ \"le \"wɛan nɛn 'wɩ zɩɛ -a -cin -tɔa 'ka 'ci? ");
INSERT INTO yreNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","'Kaan -pɛlanun 'lee 'an 'cɛinnun -nanjɛn! 'An 'bɔ nɛn. 'Ka klɛ 'an man -e 'ka -tɔ 'nan maan nɛn. 'An nɛn a 'an man, ɛn 'an 'wlɛ a \"ji. Kaa -tɔa 'nan, min lei -le vɛ 'ka zɩ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","E ya 'wɩ zɩɛ -a vɩnan ɛn 'e 'pɛnun 'bɔla 'ji -wlɛ, ɛn 'e 'cɛinnun 'bɔla 'ji -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","'Wɩ o 'kan \"fo, ɛn o ci \"nranman 'kpa, 'pian wa'a tian yi tɛala \"da 'nan 'wɩ 'kpa nɛn dɩ. -Yee \"wɛan Zozi -a laabʋ -wlɔ 'nan: «-Blɩfɛ -tʋ a 'ka 'lɔ 'gʋ?» ");
INSERT INTO yreNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɛn o pɔnnɛn srɛndɩ ponɛn 'tʋ -nɔn -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yaa 'si, ɛn yaa blɩ o yiɛ man. ");
INSERT INTO yreNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","\"Bɛ -sru ɛn e 'nan -wlɛ 'nan: «'Wɩ nɛn maan 'vɩ 'e 'cɛn bɛ -a -cin 'e 'tɔ 'ka 'ji! Kɔɔ maan 'vɩ 'cɛɛ 'nan, 'wɩ pɛɛnɔn nɛn 'e 'crɛn -tɛdɩ 'mɛn 'wɩ 'a Moizi -le -pei 'fluba 'ji bɛ, 'lee Bali 'lewei vɩnɔn 'le 'fluba 'ji bɛ, 'lee \"dre 'fluba 'ji bɛ, 'o bɔa 'an man.» ");
INSERT INTO yreNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Zozi 'padɩ 'sia o va, 'nan -e Bali wei nɛn 'e 'crɛn -tɛdɩ bɛ 'o -ci man. ");
INSERT INTO yreNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yaa 'vɩ -wlɛ 'nan: «E ya 'e 'crɛn -tɛdɩ 'nan, min 'sizan 'wɩ 'ji Crizi 'e yra ye, -e 'e 'ka. 'Pian -a yi yaagazan da bɛ, -e 'e 'wluan -kanɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ɛn e ya 'e 'crɛn -tɛdɩ \"nyian 'nan, minnun Bali -le 'wɩ ve -a 'tɔ da minnun lɛ 'lɛglɔn pɛɛnɔn 'ji. Waa ve minnun lɛ 'nan, 'o 'si 'wɩ 'wlidɩ \"drɛdɩ man, -e 'o 'fli -nɔn Bali lɛ, -e Bali 'e -wee 'wɩ 'wlidɩ 'fui. Waa vɩdɩ \"siala Zeruzalɛm, -e 'e bɔ 'lɛglɔn 'tʋdʋ pɛɛnɔn 'ji 'nɔn man. ");
INSERT INTO yreNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","'Ka 'kɔn 'wɩnun zɩɛ -a -nan yɩnɔn 'a! ");
INSERT INTO yreNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Fɛ nɛn 'an \"tɩ -a 'vɩ 'nan 'e -nɔan 'cɛɛ bɛ, 'an 'bɔ, mɛɛn \"paa -sia 'cɛɛ. 'Pian 'ka 'fʋ Zeruzalɛm 'fla 'bɔ da -trilii, -e Bali -le 'plɛblɛ zɩɛ 'e 'ta 'ka da!» ");
INSERT INTO yreNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","\"Bɛ -sru ɛn Zozi 'kʋ 'e -srunɔn 'a 'fla nɛn waa laabo Betani bɛ -a \"srɔn. 'E 'pɛ wluan lou, ɛn e -fɛa vɩdɩ 'sia o man. ");
INSERT INTO yreNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","E -fʋ -fɛa vɩnan, ɛn e 'si o \"srɔn, te e -ko laji. ");
INSERT INTO yreNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","-A -nan nɛn -a -srunɔn 'o \"po sɔɔn, ɛn waa 'bɔ. \"Bɛ -sru ɛn o 'li 'o da Zeruzalɛm te o ci \"nranman 'kpa tɩglɩ. ");
INSERT INTO yreNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tʋ -tʋdʋ pɛɛnɔn nɛn e \"cɛan bɛ te o ya Bali -pan 'kuin. O Bali 'tɔ bɔ \"drenun -fɔa, te waa trʋ \"baa.");
INSERT INTO yreNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fɛ pɛɛnɔn drɛdɩ pou sianan \"bɛ, te min nɛn waa laabo wei bɛ e ya. Wei 'bɔ a Bali va, ɛn e ya Bali -a. ");
INSERT INTO yreNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","-A pou sianan \"bɛ te e ya Bali va. ");
INSERT INTO yreNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Bali ciɩla \"va ɛn e fɛ pɛɛnɔn drɛ. Fɛ -tʋ 'ka 'e drɛdɩ, te -yɛɛ \"cɛɛ drɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","-A va nɛn 'belidɩ 'si. 'Belidɩ zɩɛ, 'tɛ 'san nɛn e 'trɛdanɔn 'man dra 'wein bɛ -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","'Tɛ zɩɛ -a -san -sɛn klun va, ɛn klun 'ka -tɔlɛ -a 'lɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bali min -tʋ 'pa 'sia, -a 'tɔ nɛn Zan. ");
INSERT INTO yreNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","E -ta 'nan -e 'e 'tɛ 'san -le 'wɩ vɩ minnun lɛ, 'dʋ -e minnun 'o man, -e 'o yi -tɛra \"da. ");
INSERT INTO yreNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Zan 'bɔ \"cɛɛ 'tɛ 'san zɩɛ -a -nɔan \"dɩ, 'pian e -ta 'nan -e 'e 'tɛ 'san -le 'wɩ vɩ minnun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Min nɛn waa laabo wei bɛ, -yɛɛ cɩ 'tɛ 'san tɩglɩ 'a, ɛn -yɛɛ 'ta 'trɛdanɔn pɛɛnɔn 'man drɛlɛ 'wein. ");
INSERT INTO yreNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bali ciɩla \"va ɛn e fɛ pɛɛnɔn drɛ. 'Pian zɩ e -ta 'trɛda bɛ, minnun 'ka -a 'silɛa min -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","E -ta 'yee 'trɛda, ɛn -yee minnun 'ka -a 'kunlɛ 'o 'pɛ \"fli \"a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","'Pian min -mienun -a 'kun 'o 'pɛ \"fli \"a, ɛn o yi -tɛra \"da. Minnun zɩɛ yaa -si -nɔn -wlɛ -e 'o drɛ Bali -le 'nɛnnun -a. ");
INSERT INTO yreNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wa'a drɛlɛ Bali -le 'nɛnnun -a \"le zɩ min 'nɛn -yaa 'e 'pɔn -ji bɛ -yee 'wɩ 'zʋ dɩ. Ɛn min \"cɛɛ o drɛ Bali -le 'nɛnnun -a dɩ. 'Pian Bali 'bɔ 'bɛ o drɛ 'yee 'nɛnnun -a. ");
INSERT INTO yreNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Wei zɩɛ, e drɛ blamin -a, ɛn e -ta -nyɛnlɛa 'kʋ 'va. Kʋ -yee -dan ci 'yɩ, -dan zɩɛ e ya -kaa \"tɩ Bali -le 'nɛn 'tʋwli \"le vɛ -a. E ya 'e fadɩ \"yi \"a, ɛn zɩ Bali cɩ bɛ, yaa kɔɔn 'kʋɛ 'e tɩglɩ da. ");
INSERT INTO yreNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yi -tʋ da nɛn Zan -yee 'wɩ vɩdɩ 'sia minnun lɛ. 'E wei wluan 'plɛblɛ, ɛn yaa 'vɩ 'nan: «Min nɛn an -yee 'wɩ 'vɩ 'e 'cɛn bɛ -nyrɛn \"bɛ. Maan 'vɩ 'nan, e -fɔla \"da 'an -sru e -taa. -A -dan \"mlian 'an da, kɔɔ e ya 'li 'e 'cɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","\"Yi \"nɛn -yrɔ \"bɛ e -cee \"nɔn. Yi -tʋdʋ pɛɛnɔn man te e \"yi zɩɛ -a -sɛan \"da -cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bali ciɩla Moizi -va, ɛn e -pei -tɔ -cɛɛ. 'Pian Zozi 'bɛ 'ta Bali -le \"yi \"a, ɛn zɩ Bali cɩ bɛ -yɛɛ kɔɔn -cɛɛ 'e tɩglɩ da. ");
INSERT INTO yreNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Min -tʋ 'ka tian Bali yɩlɛ dɩ. 'Pian Bali -le 'nɛn -tʋwli \"nɛn e ya Bali -a, ɛn e ya 'e 'cɛn -kaa \"tɩ Bali \"srɔn \"bɛ, zɩ Bali 'bɔ cɩ bɛ -yɛɛ kɔɔn -cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yi -tʋ da, Zuif 'nɔn 'tanɔn nɛn Zeruzalɛm bɛ, o Bali -pannɔn 'lee Levi kludanɔn -mienun 'pa 'sia Zan -va. Levi kludanɔn 'bɔ bɛ, -wɛɛ nyranman \"paa Bali -pan 'kuin. O o 'pa 'sia 'nan 'o laabʋ Zan -lɔ 'nan: «-Tɩ nɛn 'yia?» 'Wɩ nɛn Zan -a 'vɩ minnun zɩɛ -wlɛ \"bɛ -nyrɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ya'a 'wɩ 'tʋ yɔɔlɛ o man dɩ, yaa 'vɩ -wlɛ -gbaa 'nan: «An 'ka Crizi nɛn Bali -a 'si \"va -e 'e minnun 'si 'wɩ 'ji bɛ -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tɔɔn ɛn waa laabʋ -yrɔ 'nan: «'Lɔɔ -tɩ nɛn 'yia \"mɛn, Bali 'lewei vɩzan -dan nɛn waa laabo Eli bɛ, -nyrɛn 'yia?» Ɛn Zan \"e 'nan: «Eli \"cɛɛ 'maan dɩ.» Ɛn waa laabʋ -yrɔ \"nyian 'nan: «Bali 'lewei vɩzan nɛn o -yee 'wɩ 'vɩ bɛ, -nyrɛn 'yia?» Ɛn e 'nan: «-Cɛjɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɛn waa laabʋ -yrɔ 'nan: «'Lɔɔ, -tɩ nɛn 'yia -kpɔ? 'I vɩ 'kʋɛ, 'dʋ -e 'kʋ -kɔla 'kʋ 'wɩ 'tʋ yɩ, -e 'kʋ vɩ minnun nɛn o 'kʋ 'pa 'sia bɛ -wlɛ. -Mɛ \"wɩ nɛn i -kɔlaman -e 'i vɩ 'i 'fli man?» ");
INSERT INTO yreNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tɔɔn ɛn Zan \"e 'nan -wlɛ 'nan: «Mɛɛn cɩ min nɛn Bali 'lewei vɩzan Ezai -a 'vɩ 'li bɛ -a. Yaa 'vɩ 'nan: ‹Min -tʋ wei 'bɛ \"we \"bui \"da, -a san -a ve 'nan: 'Ka Minsan -le -si ta drɛ!› » ");
INSERT INTO yreNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Minnun nɛn o o 'pa 'sia Zan -va bɛ Farizɛn 'nɔn a o va. ");
INSERT INTO yreNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ɛn waa laabʋ -yrɔ nan: «Crizi \"cɛɛ 'yia dɩ, ɛn Eli \"cɛɛ yia dɩ, ɛn Bali 'lewei vɩzan nɛn o -yee 'wɩ 'vɩ bɛ -njɛɛ 'yia dɩ. -Mɛ \"le \"wɛan nɛn i min -batize dra \"mɛn?» ");
INSERT INTO yreNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Zan \"e 'nan -wlɛ 'nan: «'An 'bɔ, \"an \"min -batize dra 'yi 'a, 'pian 'ka yei \"bɛ, min -tʋ a -nan, ka'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","E -fɔla \"da. An 'ka -yee -manwua \"tun \"da baa \"fluzan -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","'Wɩ pɛɛnɔn zɩɛ e drɛ 'fla nɛn waa laabo Betani bɛ -a da. 'Fla zɩɛ e ya 'yi nɛn waa laabo Zudan bɛ -a -sru, fɛ zɩɛ -a -nan nɛn Zan minnun -batize drɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","-A ta tʋ cɛɛn, zɩ Zan -a 'yɩ 'nan Zozi a -tanan 'e 'va zia bɛ, ɛn e 'nan: «\"Ka 'yiɔ, Bali -le 'bla 'a. -A 'bɔ nɛn Bali -a -nɔn 'nan -e 'e 'trɛdanɔn 'le 'wɩ 'wlidɩ pɛɛnɔn \"nɛn wɩ yɩ, -e -wee 'wɩ 'wlidɩ 'e 'fui. ");
INSERT INTO yreNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Min nɛn, an -yee 'wɩ 'vɩ 'e 'cɛn bɛ, -nyrɛn \"bɛ. Maan 'vɩ 'nan e -fɔla \"da e -taa, -a -dan \"mlian 'an da, kɔɔ e ya -nan 'li 'e 'cɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tʋ nɛn an 'wɩ zɩɛ -a ve bɛ te ma'an min 'bɔ 'tɔa dɩ, 'pian an minnun -batize drɛdɩ 'sia 'nan -e Izraɛl 'nɔn 'o min zɩɛ -a -tɔ.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","'Wɩ nɛn Zan -a -nan 'yɩ, ɛn yaa 'vɩ minnun lɛ bɛ, -nyrɛn 'gʋ: «An Bali lei 'saun 'yɩ 'sinan laji, e sɔɔn \"da \"le -plablo -zʋ, ɛn e -fʋ \"va. ");
INSERT INTO yreNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tʋ nɛn an 'wɩ zɩɛ -a ve bɛ te ma'an min 'bɔ 'tɔa dɩ, 'pian Bali nɛn e 'nan 'an 'ta min -batize drɛ 'yi 'a bɛ, -yɛɛ 'vɩ 'mɛn 'nan: ‹Min nɛn 'i Bali lei ye -e 'e -sɔɔn \"da -e 'e 'fʋ \"va \"bɛ, -yɛɛ Bali lei 'saun -nɔan \"min lɛ.› ");
INSERT INTO yreNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Maan -nan 'yɩ, ɛn maan 'vɩ 'wein 'nan, min 'labɛ Bali -pɩ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","-A ta tʋ cɛɛn, te Zan 'lee 'e -srunɔn \"fli 'bɛ cɩ fɛ zɩɛ -a -nan, ");
INSERT INTO yreNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ɛn zɩ e Zozi 'yɩ te e ya ciɩnan bɛ, ɛn e 'nan: «\"Ka 'yiɔ Bali -le 'bla bɛ, -nyrɛn \"bɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","-A -srunɔn \"fli \"bɛ, o 'wɩ zɩɛ -a 'man, tɔɔn ɛn o sɔɔnla Zozi -sru. ");
INSERT INTO yreNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Zozi 'e 'man lila, zɩ yaa 'yɩ 'nan Zan -srunɔn bɛ o sɔɔnla 'e -sru \"bɛ, ɛn yaa laabʋ -wlɔ 'nan: «-Mɛ \"nɛn kaa -wɛɛman?» O 'nan -yrɛ 'nan: «Rabi, 'yie \"kɔnnɛn \"a nyin zia?» Rabi -ci nɛn 'nan Bali -le 'wɩ \"paazan. ");
INSERT INTO yreNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ɛn Zozi \"e -wlɛ 'nan: «'Ka 'ta -e 'ka -nan yɩ!» O sɔɔnla -a -sru, ɛn waa -nyrannan 'yɩ. Yi zɩɛ -a da bɛ, o -fʋ -a \"srɔn. 'Wɩ pɛɛnɔn zɩɛ e drɛ te yidɛ \"ta -pliman \"tra. ");
INSERT INTO yreNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Min \"fli \"nɛn o Zan wei 'man ɛn o sɔɔnla Zozi -sru \"bɛ, Simɔn Piɛri \"bʋɩ Andre nɛn -a -tʋ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andre zɩɛ, min tɛdɛ nɛn e -kʋ \"va \"bɛ, -a 'bɔ \"bʋɩ Simɔn nɛn. Ɛn e -yrɛ 'nan: «Kʋ min nɛn e cɩ Crizi -a bɛ -a 'yɩ.» Crizi -ci nɛn 'nan min nɛn Bali -a 'si \"va. ");
INSERT INTO yreNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ɛn e -kʋ Simɔn -a Zozi lɛ. Zozi -a -nanjɛɛn tɛin ɛn e 'nan -yrɛ 'nan: «Zan -pɩ Simɔn nɛn 'yia, o -taa 'i laabʋlɛ Keva.» Keva 'bɔ nɛn waa ve \"nyian Piɛri. ");
INSERT INTO yreNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","'Bɛ 'ta tʋ cɛɛn, ɛn Zozi a \"vale 'e 'ko Galile 'lɛglɔn 'ji, -a -nan nɛn e 'bɔ Filipʋ man ɛn e 'nan -yrɛ 'nan: «'I -sɔɔnla 'an -sru.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipʋ zɩɛ, Bɛzaida nɛn Andre 'lee Piɛri fla -a bɛ, -a -nan min nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipʋ 'bɔ min -tʋ nɛn waa laabo Natanaɛl bɛ -a man, ɛn e 'nan -yrɛ 'nan: «Min nɛn -yee 'wɩ cɩ 'e 'crɛn -tɛdɩ Moizi -le -pei 'fluba 'lee Bali 'lewei vɩnɔn 'le 'fluba 'ji bɛ, kʋa 'yɩ. Nazarɛtɩ min Zozi nɛn Zozɛfʋ -pɩ -a bɛ, -nyrɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ɛn Natanaɛl -a laabʋ -yrɔ 'nan: «Fɛ 'kpa -kɔlaman -e 'e bɔla 'fla nɛn waa laabo Nazarɛtɩ bɛ -a da?» -A -nan nɛn Filipʋ \"e -yrɛ 'nan: «'I 'ta -e 'i yɩ 'i 'bɔ 'a.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Zɩ Zozi Natanaɛl 'yɩ 'tanan 'e 'va bɛ, ɛn yaa 'vɩ 'nan: «Cɛɛ Izraɛl min tɩglɩ nɛn 'e 'wɩ tɩglɩ ve bɛ, -nyrɛn \"bɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ɛn Natanaɛl -a laabʋ -yrɔ 'nan: «Nyin zia nɛn yian -tɔa?» Zozi \"e -yrɛ 'nan: «Te i ya 'i -nyrandɩ Fijie yiba 'wlu -e Filipʋ 'e 'i laabʋ bɛ, te mɛin 'yɩ 'va.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","-A -nan nɛn Natanaɛl \"e 'nan -yrɛ 'nan: «Bali -le 'wɩ \"paazan, Bali -pɩ nɛn 'yia, yiɛ cɩ Izraɛl 'nɔn 'le mingɔnnɛn -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Zozi -a laabʋ -yrɔ 'nan: «Maan 'vɩ 'yiɛ 'nan mɛin 'yɩ Fijie yiba 'wlu 'le \"wɛan nɛn i yi -tɛra 'an da? I -taa 'wɩ -dandan -nan yɩlɛ e -ciala 'wɩ 'labɛ 'bɛ da.» ");
INSERT INTO yreNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ɛn Zozi -a 'vɩ \"nyian 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, ka -taa labli yɩlɛ 'e 'lɛ 'sʋdɩ -e 'ka Bali -le 'pasianɔn yɩ, te o -ko laji, ɛn te o \"sia laji -e 'o -sɔɔn 'an Blamin -pɩ da.» ");
INSERT INTO yreNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yi yaaga \"bɛ -sru, ɛn lɩ 'pa \"fɛdi drɛdɩ 'bɔ 'fla nɛn waa laabo Kanan bɛ -a da, Galile 'lɛglɔn 'ji. Zozi \"bʋ \"a \"fɛdi zɩɛ -a da, ");
INSERT INTO yreNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ɛn o Zozi 'lee 'e -srunɔn laabʋ \"nyian \"fɛdi 'bɔ da. ");
INSERT INTO yreNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Zɩ -wɛn -nyan bɛ, ɛn Zozi \"bʋ \"e 'nan Zozi lɛ 'nan: «-Wɛn -nyan -wlɔ.» ");
INSERT INTO yreNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Zozi \"e 'nan -yrɛ 'nan: «Manmi, -mɛ \"le \"wɛan nɛn i -tɔa 'wɩ zɩɛ 'bɛ 'ji, 'mɛn tʋ 'ka tian bɔlɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","-A -nan nɛn Zozi \"bʋ \"e 'nan minnun nɛn o cɩ fɛnun -plinan bɛ -wlɛ 'nan: «'Wɩ pɛɛnɔn nɛn yaa 've 'cɛɛ bɛ, 'ka drɛla \"da.» ");
INSERT INTO yreNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","'Yi 'tɔbɔ nɛn 'e drɛdɩ -kɔlɛ -a bɛ, -a 'shɛɛdʋ a fɛ 'bɔ zɩɛ -a -nan. 'Yi 'tɔbɔ zɩɛ -a -ji nɛn Zuif 'nɔn 'o 'cɛin 'lee 'o 'pɛ -man \"foe yi \"sia -e 'o 'fli drɛ 'saun Bali 'lɛ. -A -tʋ -kɔlaman e 'yi \"siala \"tugu -yaa tʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ɛn Zozi \"e 'nan minnun nɛn o cɩ fɛnun -plinan bɛ -wlɛ 'nan: «'Ka 'pɔnun 'labɛ o fa 'yi 'a!» O -pɔnun zɩɛ -a 'fa, e -sran \"man. ");
INSERT INTO yreNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","-A -nan nɛn Zozi \"e 'nan -wlɛ 'nan: «'Ka 'yi 'gʋɛ -a 'kolu \"tiɛnnɔn -e 'ka 'kʋ -a min nɛn 'e yiɛ -tɔa \"fɛdi 'gʋɛ -a da bɛ -yrɛ!» Ɛn waa kolu o -kʋ -a -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Min nɛn 'e yiɛ -tɔa \"fɛdi 'bɔ da bɛ, e 'yi zɩɛ -a -nanjɛɛn 'e 'le te e lila 'wɛn -a. Fɛnan nɛn -wɛn zɩɛ e 'si bɛ ya'a tɔa dɩ. 'Pian fɛ -plinɔn nɛn o 'yi 'bɔ 'tɔ bɛ, \"o -tɔa. E lɩ 'pazan laabʋ ɛn e 'nan -yrɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Minnun pɛɛnɔn 'gʋɛ, -wɛn nɛn e cɩ 'kpa bɛ, -a 'bɔ nɛn waa -nɔan \"min lɛ 'e 'flin. \"Bɛ -sru te -wɛn ciɩ min yiɛ da bɛ, -e -wɛn nɛn e 'ka 'kpa dɩɛ, 'wɛɛ 'nɔn min lɛ. 'Yie vɛ bɛ, -wɛn nɛn e cɩ 'kpa bɛ, yia ta -tɔ -trilii tʋ 'gʋɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","'Lɛbo \"fɔ wɩ tɛdɛ nɛn Zozi -a drɛ bɛ, -nyrɛn zɩɛ. Yaa drɛ Kanan, Galile 'lɛglɔn 'ji. E 'yee -dan ci kɔɔn ɛn -a -srunɔn yi -tɛra Zozi 'bɔ da. ");
INSERT INTO yreNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","\"Bɛ -sru, ɛn e sɔɔn \"ji 'fla nɛn waa laabo Kapanamo bɛ -a da, 'o 'vale 'e \"bʋ 'lee 'e \"bʋɩnun 'lee 'e -srunɔn 'a. O -fʋ 'fla zɩɛ -a da tʋ \"wɛnnɛn 'a. ");
INSERT INTO yreNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Zuif 'nɔn 'le 'si nɔanba -ji \"fɛdi drɛdɩ 'bɔ 'kogo, ɛn Zozi 'kʋ Zeruzalɛm. ");
INSERT INTO yreNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Zɩ e 'bɔla 'nan nun bɛ, ɛn e wla Bali -pan 'kuin. E minnun 'yɩ te o ya trinun 'lee 'blanun 'lee -plablonun -tannan. Ɛn e minnun 'yɩ \"nyian te o ya \"lala ta -fɔɔnan. ");
INSERT INTO yreNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Zɩ e 'wɩ zɩɛ -a -nan 'yɩ bɛ, e baa drɛ sɔnba \"a, ɛn e 'blanun 'lee trinun 'lee minnun pɛɛnɔn 'pin Bali -pan 'kuin. E \"lala ta -fɔɔnɔn 'le \"lala fuila \"man e -wee 'tablonun -sran ji. ");
INSERT INTO yreNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ɛn e 'nan -plablo -tannɔn lɛ 'nan: «'Ka fɛnun 'gʋɛ -a bɔla fɛ 'gʋɛ -a -nan. Te 'ka 'an \"tɩ \"le 'kɔn drɛ 'flɛ 'tan 'kɔn 'a dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ɛn -a -cin -tɔra -a -srunɔn 'ji 'nan 'e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan: «'Yie 'kɔn yɩdɩ \"yi \"a 'an 'ji -dan e -ciala \"da.» ");
INSERT INTO yreNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Zɩ Zozi 'wɩ zɩɛ -a drɛ bɛ, ɛn Zuif 'nɔn 'tanɔn -a laabʋ -yrɔ 'nan: «'Lɛbo \"fɔ 'wɩ \"kɔ \"nɛn yia dra -e 'e -kɔɔn 'nan Bali 'bɛ 'si -nɔn 'yiɛ 'nan 'i 'wɩ zɩɛ -a drɛ?» ");
INSERT INTO yreNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ɛn Zozi -a -sru \"fɔ -wlɛ 'nan: «Bali -pan 'kɔn 'gʋɛ, 'ka -wi! E ya yi yaaga -e 'an wluan lou 'e \"pa 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ɛn o 'nan -yrɛ 'nan: «Bali -pan 'kɔn 'labɛ, lɛ -fuba sinjɛn 'wlɛ 'shɛɛdʋ wlu nɛn minnun -a -tɔ, ɛn yie 'nan, yi yaaga 'wlu -e 'i pee -tɔ?» ");
INSERT INTO yreNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","'Pian -te Zozi a 'wɩ zɩɛ -a vɩnan bɛ, -a 'bɔ po nɛn Bali -le 'kɔn 'a bɛ -nyrɛn yaa ve. ");
INSERT INTO yreNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Zɩ 'e wluan -kanɔn 'va bɛ, -a -ci -tɔ -a -srunɔn 'ji 'nan e 'wɩ zɩɛ -a 'vɩ 'e 'cɛn. Ɛn o yi -tɛra Bali wei nɛn 'e 'crɛn -tɛdɩ bɛ -a da, 'lee 'wɩ nɛn Zozi -a 'vɩ -wlɛ \"bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tʋ nɛn te Zozi a Zeruzalɛm Zuif 'nɔn 'le 'si nɔanba -ji \"fɛdi da bɛ, zɩ minnun 'lɛbo \"fɔ wɩnun nɛn yaa drɛ bɛ -a -nan 'yɩ -yrɔ \"bɛ, ɛn min \"kaga \"yi -tɛra Zozi 'bɔ da. ");
INSERT INTO yreNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","'Pian Zozi 'ka yi -tɛlɛa o da dɩ, kɔɔ e o pɛɛnɔn -tɔa \"fo. ");
INSERT INTO yreNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ɛn Zozi 'ka -a wɛɛman 'nan, min 'e min -tʋ man wɩ vɩ 'yrɛ dɩ. 'Wɩ nɛn min ji bɛ, Zozi -a -tɔa 'e 'bɔ 'a. ");
INSERT INTO yreNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Zuif 'nɔn 'tazan -tʋ nɛn waa laabo Nikodɛm bɛ, e ya Farizɛn 'nɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","E -ta Zozi 'va 'pei -man, ɛn e 'nan -yrɛ 'nan: «'An 'san, kʋa -tɔa 'nan i ya min nɛn Bali -a 'pa 'sia -e 'e 'wɩ \"paa minnun ji bɛ -a. Kɔɔ 'lɛbo \"fɔ wɩnun nɛn yia dra 'gʋɛ min nɛn Bali a 'e 'padɩ \"va \"bɛ, -a san 'bɛ -kɔlaman -a drɛdɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ɛn Zozi \"e 'nan -yrɛ 'nan: «Maan ve 'yiɛ 'wɩ tɩglɩ 'a 'nan, min 'ka 'kɔlaman -e 'e Bali -le mingɔnnɛn trɛ yɩ, te wa'a -yalɛ 'e 'trɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","-A -nan nɛn yaa laabʋ Zozi 'lɔ 'nan: «Min nɛn e drɛ ceje 'gʋɛ, waa dra 'kɔ -e 'o -ya? E -wlaman \"nyian 'e \"bʋ 'pɔn -ji -e 'o -ya 'e 'pee?» ");
INSERT INTO yreNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ɛn Zozi \"e -yrɛ 'nan: «Maan ve 'yiɛ \"nyian 'wɩ tɩglɩ 'a 'nan, min 'ka 'kɔlaman -e 'e 'kʋ Bali -le mingɔnnɛn trɛ da, te wa'a -yalɛ 'yi 'lee Bali lei -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Fɛ nɛn min -a -ya bɛ, e ya min -a. 'Pian fɛ nɛn Bali lei -a -ya bɛ, e ya -yee vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","-Te 'an 'bɔ maan 'vɩ 'yiɛ 'nan e ya \"le 'wei 'ya \"nyian 'e 'trɛ bɛ, te -a 'wɩ 'e 'i 'kan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Waa -kɔɔnman fulɔ man. Fɛnan nɛn fulɔ cɩ \"vale 'e 'ko bɛ, -a -nan nɛn e \"fɛɛnman e -ko. Waa -cin maan, 'pian -a -nan nɛn e \"sia bɛ wa'a tɔa dɩ, ɛn -a -nan nɛn e -ko bɛ wa'a tɔa dɩ. -A -tʋwli \"nɛn \"nyian min nɛn Bali lei -a -ya 'e 'trɛ bɛ -yee vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodɛm -a laabʋ -yrɔ 'nan: «'Wɩ zɩɛ e dra 'kɔ -e 'bɛ drɛ?» ");
INSERT INTO yreNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ɛn Zozi \"e 'nan -yrɛ 'nan: «'I 'bɔ nɛn i 'wɩ \"paaman Izraɛl 'nɔn 'ji bɛ, yi'a 'wɩnun zɩɛ -a tɔa dʋʋ? ");
INSERT INTO yreNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Maan ve 'yiɛ 'wɩ tɩglɩ 'a 'nan, 'wɩ nɛn kʋa -tɔa \"bɛ -nyrɛn kʋa ve, ɛn 'wɩ nɛn kʋa -nan 'yɩ bɛ, -nyrɛn kʋa ve, ɛn 'kʋe 'wɩ zɩɛ ya'a 'ko 'ka 'wulo -ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","An 'trɛ 'gʋɛ -a da wɩ 'vɩ 'cɛɛ, ka'a yi -tɛlɛa 'bɛ da dɩ, 'lɔɔ -te an laji lou \"wɩ 'vɩ 'cɛɛ bɛ, e dra 'kɔ -e 'ka yi -tɛra 'bɛ da? ");
INSERT INTO yreNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Min -tʋ 'ka tian 'kʋlɛ laji dɩ, -te ya'a 'silɛa Blamin -pɩ nɛn e 'si laji bɛ -a dɩɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","\"Le zɩ Moizi a \"bui \"da 'li ɛn e -bulalɛ drɛ -mlɛn -a ɛn yaa 'pa yiba \"man ɛn yaa wluan lou \"bɛ, -a -tʋwli \"nɛn \"nyian waan 'bɔ blamin -pɩ wuanla lou. ");
INSERT INTO yreNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","'Dʋ -e min nɛn e yi -tɛra Blamin -pɩ 'bɔ da bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ 'e drɛ -a san -le vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","-Yɛɛ cɩ 'nan Bali 'trɛdanɔn pɛɛnɔn 'yɩ \"yi \"bʋʋ \"le \"wɛan, 'e 'pɩ -tʋwli \"nɔn -wee 'wɩ 'ji, 'nan -e min nɛn e yi -tɛra -a -pɩ zɩɛ -a da bɛ, -a san -nan 'e vɩlɛ 'e 'nyan dɩ, 'pian -e 'belidɩ nɛn ya'a 'nyaan dɩɛ, 'e drɛ -a san -le vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bali 'ka 'e 'pɩ 'palɛ -sia 'trɛda 'nan -e 'e tin -tɛ min da dɩ, yaa 'pa 'sia 'nan -e 'e min 'si 'wɩ 'ji. ");
INSERT INTO yreNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Min nɛn e yi -tɛala -a -pɩ zɩɛ -a da bɛ, wa'a -yee tin 'baa dɩ, 'pian min nɛn ya'a yi 'tɛala \"da \"dɩɛ -a san -le 'wɩ a 'e tin 'badɩ 'va, kɔɔ ya'a yi -tɛlɛa Bali -pɩ -tʋwli \"da dɩ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","'Wɩ nɛn -yee \"wɛan, Bali 'trɛdanɔn 'le tin \"baa bɛ, -nyrɛn 'gʋ, 'tɛ 'san -ta 'trɛda, ɛn minnun 'ka -a yɩlɛ \"yi \"dɩ, o klun 'yɩ \"yi e mlin 'tɛ 'san da, o drɛnan wɩ a -wlidɩ \"le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","-Yɛɛ cɩ 'nan min nɛn e 'wɩ 'wlidɩ \"dra bɛ, ya'a 'tɛ 'san ye \"yi \"dɩ. Ɛn -a san 'ka 'taa 'tɛ 'san da dɩ, \"tɔgɔ -yee 'wɩ 'wlidɩ \"ta 'e bɔla. ");
INSERT INTO yreNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","'Pian min nɛn e 'ta 'wʋla 'wɩ tɩglɩ da bɛ, e -taa 'tɛ 'san da, 'dʋ -e 'tɛ 'san 'e drɛ wɩ -ci -kɔɔn 'nan e 'ta 'wʋla Bali wei da.» ");
INSERT INTO yreNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","\"Bɛ -sru ɛn Zozi 'lee 'e -srunɔn 'kʋ Zude 'lɛglɔn 'ji. O -fʋ fɛ zɩɛ -a -nan tʋ \"wɛnnɛn 'a, ɛn e minnun -batize drɛdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tʋ 'bɔ 'lein zɩɛ -a wlu bɛ, te Zan \"e minnun -batize dra \"nyian 'fla nɛn waa laabo Enɔn bɛ -a da, kɔɔ 'yi banun a -nan \"kaga. 'Fla zɩɛ, e ya 'fla nɛn waa laabo Salim bɛ -a \"srɔn. Minnun -ko -nan nun te Zan o -batize dra, ");
INSERT INTO yreNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tʋ zɩɛ -a man bɛ, te wa'a tian -a -fɔlɛ -pʋ 'kuin dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yi -tʋ da, ɛn -sa -tʋ -fɔla Zan -srunɔn 'lee Zuif min -tʋ yei. -Sa zɩɛ e ya min drɛdɩ 'saun Bali 'lɛ da. ");
INSERT INTO yreNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","O -kʋ Zan -va, ɛn waa laabʋ -yrɔ 'nan: «Bali -le 'wɩ \"paazan, min nɛn \"nɛn ka cɩ 'ka 'vale -a Zudan 'yi -sru, te i -yee 'wɩ ve minnun lɛ bɛ, e ya minnun -batize drɛnan ɛn minnun pɛɛnɔn a -kʋnan \"va 'zia.» ");
INSERT INTO yreNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","-A -nan Zan \"e 'nan -wlɛ 'nan: «Min 'ka 'kɔlaman -e 'e fɛ -tʋ yɩ te Bali \"cɛɛ -nɔn -yrɛ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Maan 'vɩ 'ka yiɛ man 'nan, min nɛn e min \"sia 'wɩ 'ji bɛ, -a 'bɔ \"cɛɛ 'maan dɩ, 'pian an ya min nɛn Bali -a -trɔa -a 'lɛ bɛ -a. 'Ka 'bɔ ka ya 'mɛn 'wɩ 'nan yɩnɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lɩmɔn nɛn e -kɔnnɛn 'pa bɛ, e ya -tɩ -le vɛ -a? Min nɛn yaa 'pa bɛ, -yee vɛ nɛn. Lɩ 'pazan 'bɔ bee -le vɛ \"cɛɛ dɩ, -a bee bɛ, \"bɛ \"ya wo min nɛn e -tɔa -a \"srɔn, te -a \"trɔɛn \"a 'e 'tɔdɩ -a wei lɛ bɛ -a. Ɛn -a wei mandɩ -a ci \"nranman. Zɩ 'an 'ci cɩ zɩɛ. 'Bɛ nɛn 'gʋɛ, 'an 'ci \"nranman e -ciala \"da \"mɛn \"fo. ");
INSERT INTO yreNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","E ya \"le -a 'bɔ 'tɔ nɛn 'e drɛ -dan -e 'an 'tɔ \"e \"ta wʋ \"tra. ");
INSERT INTO yreNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Min nɛn e \"sia laji lou \"bɛ, e ya fɛ pɛɛnɔn da, 'pian min nɛn e 'si 'trɛda bɛ, e ya 'trɛda min -a, ɛn 'trɛda wɩ nɛn yaa ve. Min nɛn e \"sia laji bɛ, e ya fɛ pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ɛn 'wɩ nɛn yaa -nan 'yɩ, 'lee 'wɩ nɛn yaa 'man bɛ -nyrɛn yaa ve, 'pian min -tʋ 'ka yi -tɛlɛa 'wɩ zɩɛ -a da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Min nɛn e yi -tɛra 'wɩ nɛn yaa 'vɩ bɛ -a da bɛ, te 'bɛ 'san \"e 'nan 'wɩ 'kpa, Bali 'wɩ tɩglɩ ve. ");
INSERT INTO yreNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","-Yɛɛ cɩ 'nan min nɛn Bali -a 'pa 'sia bɛ, Bali 'bɔ wei nɛn yaa ve, kɔɔ Bali 'ka 'yee lei 'saun 'nɔndɩ \"nɛn 'palɛa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","-Kaa \"tɩ Bali 'e 'pɩ ye \"yi, ɛn e fɛ pɛɛnɔn 'pɛba 'wʋ -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Min nɛn e yi -tɛra -a -pɩ zɩɛ -a da bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ, e ya -a san -le vɛ -a. 'Pian min nɛn ya'a -pɩ 'silɛa min -a dɩɛ, -a san 'ka 'belidɩ ye dɩ, te 'bli a 'e 'fɔdɩ Bali -ji -a san man.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Zozi -a -tɔ 'nan, Farizɛn 'nɔn -a 'man 'nan minnun nɛn 'e -sru te 'e o -batize dra bɛ, o ya \"kaga, ɛn o \"mlian Zan -srunɔn da. ");
INSERT INTO yreNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Zozi 'bɔ \"cɛɛ min -batize dra 'e 'bɔ 'a dɩ, 'pian -a -srunɔn nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Zɩ Zozi 'wɩ zɩɛ -a -kɔnnɛn 'yɩ bɛ, -a -nan nɛn e 'si Zude 'lɛglɔn 'ji, ɛn e Galile si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","-Si zɩɛ e -ciala Samari 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Zozi 'bɔla Samari 'fla 'tʋ da. 'Fla zɩɛ waa laabo Sisha e ya fei nɛn Zago -a -nɔn 'li 'e 'pɩ Zozɛfʋ lɛ bɛ -a \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Fɛ zɩɛ -a -nan nɛn Zago 'le 'yi -klu cɩ. Zɩ Zozi \"koe \"nyian 'ta wʋdɩ -a bɛ, ɛn e -nyran 'yi -klu zɩɛ -a \"srɔn te yidɛ 'bɔ min -win -ji 'sɛzɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","-A -nan nɛn Samari lɩmɔn -tʋ -ta 'yi 'tɔlɛ, ɛn Zozi \"e 'nan -yrɛ 'nan: «'I 'yi 'nɔn 'mɛn -e 'an mlin.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tʋ zɩɛ -a wlu, te -a -srunɔn 'kʋ -blɩfɛnun 'lɔlɛ 'fla. ");
INSERT INTO yreNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ɛn Samari lɩ zɩɛ e 'nan Zozi lɛ 'nan: «-Mɛ \"le \"wɛan nɛn 'i 'bɔ nɛn Zuif min -a bɛ, i 'yi laabo 'an 'lɔ -e 'i mlin, te Samari lɩ nɛn 'maan?» Zuif 'nɔn 'lee Samari 'nɔn bɛ te o yei 'ka -a ble \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ɛn Zozi \"e 'nan -yrɛ 'nan: «\"Te fɛ nɛn Bali -a -nɔn minnun lɛ bɛ, 'nan yia -tɔa \"bɛ, ɛn min nɛn yaa ve 'yiɛ 'nan 'i 'yi 'nɔn 'mɛn 'gʋɛ, yia -tɔa \"bɛ, \"te 'i 'bɔ 'bɛ 'yi laabʋ -yrɔ, -e 'i mlin, -e 'e 'yi nɛn e 'belidɩ -nɔan \"min lɛ bɛ -a -nɔn 'yiɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ɛn lɩ zɩɛ e 'nan Zozi lɛ 'nan: «Minsan, fɛ -tʋ 'ka 'i 'lɔ -e 'i 'yi 'tɔ 'a dɩ, ɛn -klu 'gʋɛ e ya 'e trʋdɩ. Nyin zia nɛn i 'yi nɛn e 'belidɩ -nɔan \"bɛ, -a \"sia? ");
INSERT INTO yreNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","'Kʋ tra Zago nɛn e 'yi -klu 'gʋɛ -a -nɔn 'kʋɛ bɛ, -a 'bɔ \"e ci yi mlin 'o 'vale 'e 'pɩnun 'lee 'yee trinun -a. 'I -dan \"mlian 'bɛ da?» ");
INSERT INTO yreNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ɛn Zozi \"e -yrɛ 'nan: «Min nɛn e 'yi 'gʋɛ -a mlin bɛ, 'yi dra pee -a -tɛa. ");
INSERT INTO yreNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","'Pian min nɛn e 'yi nɛn maan -nɔan \"bɛ -a mlin bɛ, 'yi dra pee 'ka \"nyian 'li -a tɛa dɩ, ɛn 'yi nɛn maan -nɔan -yrɛ \"bɛ, e dra \"ji 'yi ku -a, ɛn e 'belidɩ nɛn ya'a 'nyaan dɩɛ -a -nɔan -yrɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","-A -nan nɛn lɩ bɛ e 'nan Zozi lɛ 'nan: «Minsan, 'yi zɩɛ 'i \"mɛn \"nɔn -e 'yi dra pee 'e vɩlɛ 'yaan 'tɛ dɩ, -e 'an vɩnan 'an 'ta \"nyian 'yi 'tɔ 'gʋ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ɛn Zozi \"e -yrɛ 'nan: «'I 'kʋ 'i -sran laabʋ -e 'ka 'ta -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Lɩ zɩɛ e 'nan -yrɛ 'nan: «'An -sran \"ka \"dɩ.» Ɛn Zozi \"e -yrɛ 'nan: «I 'wɩ tɩglɩ 'vɩ -a vɩdɩ -a 'nan, 'i -sran \"ka \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","-Yɛɛ cɩ 'nan i -kɔnnɛn 'pa tian 'soolu, ɛn min nɛn i cɩ \"wlu \"bɛ, 'i -sran \"cɛɛ dɩ, i 'wɩ tɩglɩ 'vɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tɔɔn lɩ bɛ e 'nan Zozi lɛ 'nan: «Minsan, maan ye \"le 'nan Bali 'lewei vɩzan nɛn 'yia. ");
INSERT INTO yreNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","'Kʋ tranun nɛn Samari 'nɔn 'a bɛ, pɔn 'gʋɛ -a da nɛn o Bali 'bɔ, ɛn 'ka Zuif 'nɔn \"ka 'vɩ 'nan Zeruzalɛm nɛn 'o 'kʋ Bali 'bɔ -kpɔ.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ɛn Zozi \"e 'nan -yrɛ 'nan: «'I \"trɔɛn \"tɔ 'an wei 'gʋɛ -yrɛ 'kpa. Tʋ -tʋ -taa \"bɔlɛ bɛ, te ka'a Bali bɔa pɔn 'gʋɛ -a da dɩ, ɛn ka'a 'ko Bali bɔlɛ Zeruzalɛm dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'Ka Samari 'nɔn bɛ, ka Bali bɔa, 'pian ka'a Bali 'bɔ 'tɔa dɩ, 'kʋ Zuif 'nɔn bɛ, \"kʋ Bali bɔa ɛn \"kʋ Bali 'bɔ -tɔa. -Yɛɛ cɩ 'nan min nɛn e 'trɛdanɔn \"sia 'wɩ 'ji bɛ, Zuif 'nɔn 'va nɛn e \"sia. ");
INSERT INTO yreNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","'Pian tʋ -tʋ -taa \"bɔlɛ bɛ, ɛn -a tʋ 'bɔ 'bɔ 'va. Tʋ zɩɛ -a man nɛn Bali bɔ 'nɔn tɩglɩ -kaa \"tɩ Bali bɔa Bali lei 'saun 'le 'plɛblɛ 'a, ɛn waa bɔa 'e -si tɩglɩ da. Bali bɔ 'nɔn zɩɛ o va nɛn -kaa \"tɩ Bali cɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Bali a lei -a. -Yee \"wɛan minnun nɛn waa bɔa \"bɛ, 'o bɔ -yee lei 'saun 'le 'plɛblɛ 'a, ɛn 'o bɔ 'e -si tɩglɩ da.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ɛn lɩ zɩɛ e 'nan Zozi lɛ 'nan: «Maan -tɔa 'nan min nɛn e cɩ Crizi -a bɛ e -taa, -a 'bɔ nɛn Bali -a 'si \"va. Tʋ nɛn e -ta bɛ, e 'wɩ pɛɛnɔn 'ci ve 'kʋɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ɛn Zozi \"e 'nan -yrɛ 'nan: «'An 'bɔ nɛn an 'wɩ tin \"baa 'yiɛ 'gʋɛ, mɛɛn cɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","E -fʋ 'wɩ zɩɛ -a vɩnan, nun tɔɔn ɛn -a -srunɔn 'bɔla. 'Wɩ o 'kan 'nan 'o 'vale lɩmɔn -a o ya 'wɩ tin 'banan. 'Pian o va min -tʋ 'ka -a laabʋlɛ -yrɔ 'nan, -mɛ \"wɩ nɛn e cɩ -a laabʋnan lɩ 'labɛ -yrɔ \"dɩ? Ɛn wa'a laabʋlɛ \"nyian 'nan, -mɛ \"wɩ nɛn e cɩ -a tin 'banan -yrɛ \"dɩ? ");
INSERT INTO yreNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","-A -nan nɛn lɩ zɩɛ e 'yee 'yi 'tɔvɛ 'tʋɩ, ɛn e -kʋ 'fla -a vɩlɛ minnun lɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«'Ka 'ta min -tʋ yɩ. Min zɩɛ yaan drɛ wɩ pɛɛnɔn 'vɩ 'mɛn. -Te Crizi nɛn -o?» ");
INSERT INTO yreNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɛn minnun pɛɛnɔn 'si 'fla, o -ta fɛnan nɛn e cɩ bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tʋ zɩɛ -a wlu bɛ, te Zozi -srunɔn Zozi man dra -wluwlu 'nan 'e fɛ -blɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","'Pian Zozi \"e 'nan -wlɛ 'nan: «-Blɩfɛ nɛn 'an 'le 'gʋɛ, ka'a tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ɛn Zozi -srunɔn -a laabʋ 'o cin lɔ 'nan: «Min -tʋ -ta -blɩfɛ -a -yrɛ \"baalɛ?» ");
INSERT INTO yreNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Zozi \"e -wlɛ 'nan: «'Mɛn -blɩfɛ nɛn 'nan min nɛn yaan 'pa 'sia bɛ, 'an 'ci 'sɔ wɩnun drɛ, ɛn 'nyranman nɛn yaa -nɔn 'mɛn bɛ 'an 'pa. ");
INSERT INTO yreNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","'Ka bɔ, \"ka 'vɩ 'nan, e -fʋ mlɛn sinjɛn 'vaa -e 'o 'saa 'tɛdɩ 'sia. 'Pian 'an 'bɔ, maan ve 'cɛɛ 'nan, 'ka 'wulo wluan lou 'saa tran 'tɛvɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Min nɛn e cɩ 'saa 'tɛnan bɛ, -a san -kopa a 'va, ɛn fɛ 'wlɛ 'bɔ nɛn yaa -tɛ bɛ, yaa tre 'belidɩ nɛn ya'a 'nyaan dɩɛ -yee vɛ -a. E drɛ zɩɛ 'nan -e min nɛn e 'saa 'fɔ bɛ, 'lee min nɛn yaa -tɛ bɛ, o 'ci 'e \"nran 'e cin va. ");
INSERT INTO yreNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","O -kɔnnɛn \"tʋ -fɔa 'nan: ‹Min -tʋ 'bɛ fɛ 'wlɛ -fɔa 'trɛ 'ji -e min pee nɛn 'e -tɛ.› E ya 'wɩ 'kpa -a. ");
INSERT INTO yreNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","An 'bɔ, an 'ka 'pa 'sia 'nan, 'ka 'kʋ 'saa 'tɛ fei nɛn ka'a 'nyranman 'palɛ \"da \"dɩɛ -a da. Min peenun -a da nyranman 'pa 'va, ɛn cɛɛ \"ta -a \"nɛn \"ble.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","'Wɩ nɛn lɩ zɩɛ yaa 'vɩ bɛ, -yee \"wɛan Samari 'nɔn \"kaga \"yi -tɛra Zozi da. Kɔɔ yaa 'vɩ 'nan, Zozi 'e drɛ wɩ pɛɛnɔn 'vɩ 'yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Zɩ Samari 'nɔn 'ta Zozi 'va bɛ, ɛn waa trʋ 'ba 'nan 'e 'fʋ 'o 'va. -A -nan nɛn Zozi yi 'fiili drɛ o va. ");
INSERT INTO yreNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","'Wɩ nɛn yaa ve bɛ, -yee \"wɛan minnun nɛn o yi -tɛra \"da \"bɛ, o 'bɔ \"nyian \"kaga 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ɛn waa 'vɩ 'siɛn lɩ zɩɛ -yrɛ 'nan: «Wa'a vɩlɛ 'nan 'wɩ nɛn yia 'vɩ bɛ, -a 'saza 'le \"wɛan nɛn kʋ yi -tɛra \"da \"dɩ. 'Pian 'wɩ nɛn kʋa 'man \"da 'kʋ 'bɔ 'a bɛ, -yee \"wɛan nɛn kʋ yi -tɛra \"da, ɛn kʋa -tɔ \"mɛn 'nan -yɛɛ cɩ 'trɛdanɔn pɛɛnɔn 'sizan 'wɩ 'ji -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Zɩ Zozi yi \"fli drɛ o va bɛ, ɛn e Galile -si 'sia \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Te Zozi -a 'vɩ 'e 'bɔ 'a 'nan, wa'a Bali 'lewei vɩzan -tʋ siala -dan 'e 'bɔ fla dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","'Pian zɩ e 'bɔla Galile bɛ, Galile 'nɔn -a 'sia 'kpa tɩglɩ. Kɔɔ 'wɩ nɛn yaa drɛ \"fɛdi da Zeruzalɛm bɛ, waa -nan 'yɩ, o -kʋ -nan nun -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","E 'bɔla \"nyian Kanan Galile 'lɛglɔn 'bɔ 'ji, 'fla nɛn e 'yi lila 'wɛn -a bɛ -a da. Tʋ zɩɛ -a man bɛ, mingɔnnɛn wluzan -tʋ nɛn e -nyɛanla Kapanamo bɛ, te -a -pɩ 'man \"yaaman 'kpa tɩglɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mingɔnnɛn wluzan zɩɛ, yaa 'man 'nan Zozi 'si Zude, ɛn e 'bɔla Galile. -A -nan nɛn e -kʋ Zozi 'va, ɛn e toba -fɔ -yrɛ 'nan, 'e -sɔɔn \"ji Kapanamo -e 'e 'yee 'nɛn nɛn -a man \"yaaman -nan nun bɛ -a 'beli. 'Nɛn zɩɛ -a -kadɩ -fɔla tʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ɛn Zozi \"e 'nan -yrɛ 'nan: «-Te ka'a tian 'lɛbo \"fɔ wɩnun 'lee -cɛ -srɔn \"wɩnun -nan yɩlɛ dɩɛ, ka'a yi 'tɛala 'wɩ da 'mlɔnmlɔn dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mingɔnnɛn wluzan \"e -yrɛ 'nan: «Minsan, 'i yra 'si, 'i -ta -trɛlɛ 'vaa -e 'mɛn 'nɛn 'e yiɛ 'lɛ wʋ.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «'I 'kʋ, 'i -pɩ \"belia.» E yi -tɛra 'wɩ nɛn Zozi -a 'vɩ bɛ -a da ɛn e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","\"Yɛɛ -kɔn -kʋnan -sia bɛ, ɛn -a 'sunɔn 'ta -a 'lɛ, ɛn o -yrɛ 'nan: «-Cɛ 'si 'yie 'nɛn man.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","-A -nan nɛn yaa laabʋ -wlɔ 'nan: «Tʋ \"cɛn \"man nɛn -cɛ 'si \"man?» Ɛn o -yrɛ 'nan: «'Sɩ te yidɛ 'sia 'mɔɛnnɛn man \"tiɛnnɔn, tɔɔn ɛn -cɛ 'si \"man.» ");
INSERT INTO yreNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ɛn -a -cin -tɔ mingɔnnɛn wluzan ji 'nan, tʋ 'lein zɩɛ -a wlu nɛn Zozi -a 'vɩ 'yrɛ 'nan: «'I 'pɩ \"belia.» -A -nan nɛn -a 'bɔ 'lee 'yee \"kɔnnɛn 'nɔn pɛɛnɔn yi -tɛra Zozi da. ");
INSERT INTO yreNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Zɩ Zozi 'si Zude ɛn e -kʋ Galile bɛ, -a -nan nɛn e 'lɛbo \"fɔ wɩ zɩɛ -a drɛ. -Yee 'lɛbo \"fɔ wɩ \"flizan nɛn yaa dra fɛ 'lein zɩɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","\"Bɛ -sru, Zuif 'nɔn 'le \"fɛdi -tʋ drɛdɩ 'bɔ Zeruzalɛm, ɛn Zozi 'kʋ -nan nun. ");
INSERT INTO yreNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Zeruzalɛm 'bɔ man -klɔn bɛ, -a -wlala \"nan \"tʋ a, waa laabo 'blanun -wlala \"nan. -Wlala \"nan zɩɛ -a \"srɔn \"bɛ, 'yi 'tʋ a -nan, waa laabo Ebre wei -ji «Betɛsda». -Duban 'soolu a 'e 'tɔdɩ 'yi zɩɛ -a \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","-Dubannun zɩɛ -a wlu bɛ, -cɛ -tɛnɔn \"kaga yra 'o nyinnandɩ -nan. Yiɛ 'winɔn 'lee minnun nɛn o \"tun \"bo bɛ 'lee minnun nɛn 'o -srandɩ \"tra \"bɛ, o nɛn. O ya -a man -pɛnnan 'nan 'yi 'e 'nyɔɔn \"ji. ");
INSERT INTO yreNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","-Yɛɛ cɩ 'nan Bali -le 'pasianɔn nɛn laji bɛ, -a -tʋ -sɔɔn \"man 'yi zɩɛ -a va, -e 'e nyɔɔn. Min nɛn e sɔɔn \"va 'e tɛdɛ te Bali -le 'pasiazan \"sia -a nyɔɔnnan bɛ, -te -a san -le -cɛ a 'kɔ oo, e \"sia \"man. ");
INSERT INTO yreNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ɛn min -tʋ a fɛ 'bɔ zɩɛ -a -nan, -cɛ a \"man. -A -cɛ zɩɛ -a -nan lɛ -fuba yaaga 'wlɛ 'sɔra nɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Zɩ Zozi -a 'yɩ 'e nyinnandɩ bɛ, ɛn yaa -tɔ 'nan -cɛ nɛn \"man \"bɛ -a yi \"fli 'bɔ, -a -nan nɛn yaa laabʋ -yrɔ 'nan: «I ya \"vale -cɛ 'e 'si 'i man?» ");
INSERT INTO yreNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ɛn min zɩɛ e 'nan Zozi lɛ nan: «Minsan, \"mɛɛn -mie \"ka -e 'yaan 'fɔ 'yi 'va te 'yi nyɔɔn \"ji \"dɩ. Ɛn -te \"mɛɛn vɩnan 'an -pli 'yi 'bɔ man bɛ, -e min -tʋ 'e 'fɔ \"va 'an 'lɔ 'e 'flin.» ");
INSERT INTO yreNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","-A -nan nɛn Zozi -a 'vɩ -yrɛ 'nan: «'I 'wluan lou, 'i 'yie nyinnan \"davɛ 'sia, 'i 'ta wʋ!» ");
INSERT INTO yreNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","'Nun tɔɔn -cɛ 'si min zɩɛ -a man, e 'yee nyinnan \"davɛ 'sia, ɛn e 'ta wʋdɩ 'sia. Yi zɩɛ -a da bɛ, te Zuif 'nɔn 'le 'flinla \"yi nɛn waa laabo Saba bɛ -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ɛn zɩ Zuif 'nɔn 'tanɔn -a 'yɩ bɛ, ɛn waa 'vɩ -yrɛ 'nan: «Cɛɛgʋ 'flinla \"yi nɛn, -yee \"wɛan -a -si 'ka 'e 'nɔndɩ 'yiɛ -e 'i 'kʋ 'yie nyinnan \"davɛ -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ɛn e 'nan -wlɛ 'nan: «Min nɛn e -cɛ 'si 'an man bɛ, e 'nan 'mɛn 'nan: ‹'I 'yie nyinnan \"davɛ 'sia, 'i 'ta wʋ.› » ");
INSERT INTO yreNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Waa laabʋ -yrɔ 'nan: «Min \"cɛn 'bɛ 'vɩ 'yiɛ 'nan 'i 'yie nyinnan \"davɛ 'sia, 'i 'ta wʋ?» ");
INSERT INTO yreNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","'Pian min nɛn -cɛ 'si \"man \"bɛ, ya'a min zɩɛ -a tɔa dɩ. Kɔɔ Zozi 'si fɛ zɩɛ -a -nan min \"kaga \"le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","\"Bɛ -sru, Zozi min zɩɛ -a 'yɩ Bali -pan 'kuin, ɛn e 'nan -yrɛ 'nan: «'I \"trɔɛn \"tɔ 'wɩ 'gʋɛ -yrɛ 'kpa! -Cɛ 'si 'i man, te 'i 'wɩ 'wlidɩ \"drɛ \"nyian dɩ, \"tɔgɔ 'wɩ nɛn e -ciala 'wɩ zɩɛ 'bɛ da bɛ, 'e bɔ 'i man.» ");
INSERT INTO yreNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Min zɩɛ e -kʋ, ɛn yaa 'vɩ Zuif 'nɔn lɛ \"mɛn 'nan Zozi 'bɛ -cɛ 'si 'e man. ");
INSERT INTO yreNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","-Yee \"wɛan Zuif 'nɔn Zozi -wɛɛdɩ 'sia 'nan e 'wɩ zɩɛ -a drɛ 'flinla \"yi da. ");
INSERT INTO yreNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","'Pian Zozi 'wɩ 'ci 'vɩ -wlɛ, yaa 'vɩ 'nan: «'An \"tɩ 'nyranman \"paa tian tʋ 'gʋɛ -a, -yee \"wɛan 'an 'bɔ \"nyian, \"an \"ya wo -a 'panan.» ");
INSERT INTO yreNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'Wɩ zɩɛ -yee \"wɛan Zuif 'nɔn a Zozi -wɛɛnan 'kpa tɩglɩ 'nan o -tɛa. Wa'a vɩlɛ 'nan e -wee 'flinla \"yi 'srɔɛn srɛ -yee \"wɛan dɩ, 'pian 'nan, e 'nan Bali 'bɛ cɩ 'e \"tɩ \"a, te 'e 'fli -kɔɔnnan Bali man. ");
INSERT INTO yreNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ɛn Zozi 'e 'fli -le 'wɩ 'vɩ -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, Bali -pɩ 'ka 'kɔlaman 'wɩ 'tʋ drɛdɩ -a 'e 'bɔ 'wulo -ji wɩ -a dɩ, 'pian 'wɩ nɛn yaa -nan 'yɩ 'e \"tɩ 'lɔ bɛ -nyrɛn yaa dra. 'Wɩ pɛɛnɔn nɛn -a \"tɩ -a dra bɛ, -nyrɛn -a -pɩ -a dra \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","-Yɛɛ cɩ 'nan -kaa \"tɩ Bali 'e 'pɩ ye \"yi, ɛn 'wɩ pɛɛnɔn nɛn Bali -a dra bɛ, yaa -kɔɔnman 'e 'pɩ lɛ. 'Wɩnun nɛn e cɩ -dandan 'kpa e -ciala 'gʋ da bɛ, yaa -kɔɔnman -yrɛ, 'nan -e 'wɩ 'e 'ka 'kan 'le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Zɩ -kaa \"tɩ Bali minnun wuanla -kanɔn 'va -e 'e 'belidɩ -nɔn -wlɛ \"bɛ, -a -tʋwli \"nɛn \"nyian -a -pɩ -a dra -e min nɛn e 'sɔ \"ji \"bɛ 'e 'belidɩ -nɔn -a san lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ɛn \"nyian bɛ, -kaa \"tɩ Bali \"cɛɛ min -le 'wɩ tin 'baa dɩ, 'pian e 'wɩ tin 'badɩ pɛɛnɔn -pɛba 'wʋ 'e 'pɩ -lɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Yaa drɛ zɩɛ 'nan -e minnun pɛɛnɔn 'o -pɩ 'tɔ bɔ \"le zɩ o -a 'bɔ 'tɔ bɔa \"bɛ -yee 'wɩ 'zʋ. Min nɛn ya'a -pɩ 'tɔ bɔlɛ dɩɛ, te -a \"tɩ \"nɛn yaa 'pa 'sia bɛ, ya'a 'tɔ bɔlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min nɛn yaan wei 'man \"yi, ɛn e yi -tɛra Bali nɛn yaan 'pa 'sia bɛ -a da bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ e ya -a san -le vɛ -a. -A san -le tin 'badɩ 'ka 'kɔan 'mlɔnmlɔn dɩ, 'pian e 'sʋ 'ka -lɔ ɛn e 'belidɩ 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, tʋ -tʋ -taa \"bɔlɛ, ɛn e 'bɔ 'va. Tʋ zɩɛ -a man nɛn minnun nɛn o cɩ minnun -kadɩ -a Bali 'lɛ bɛ, o Bali -pɩ wei maan. Ɛn minnun nɛn waa 'man \"yi \"bɛ o \"belia. ");
INSERT INTO yreNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","-Yɛɛ cɩ 'nan zɩ 'plɛblɛ a -kaa \"tɩ Bali 'lɔ -e 'e 'belidɩ -nɔn minnun lɛ bɛ, -a -tʋwli \"nɛn yaa -nɔn 'e 'pɩ lɛ 'nan 'e 'belidɩ -nɔn minnun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ɛn yaa -si -nɔn -yrɛ 'nan 'e minnun -le 'wɩ tin 'ba, e ya blamin -pɩ -a -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Te 'wɩ 'gʋɛ 'e 'ka 'kan dɩ, kɔɔ -a tʋ -a -tanan bɔdɩ -a. Tʋ zɩɛ -a man nɛn minnun nɛn o kaa o ya -yrɛ -ji bɛ, o Blamin -pɩ wei maan, ");
INSERT INTO yreNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ɛn o bɔala 'yrɛ -ji. Minnun nɛn o 'wɩ \"yi drɛ bɛ, o wuanla -e 'o 'belidɩ yɩ. Ɛn minnun nɛn o 'wɩ 'wlidɩ drɛ bɛ, o wuanla -e tin 'e 'tɛ o da. ");
INSERT INTO yreNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ma'an 'kɔlaman -e 'an 'wɩ 'tʋ drɛ 'an 'bɔ 'wulo -ji wɩ -a dɩ. 'Wɩ nɛn 'an \"tɩ -a ve 'mɛn bɛ, -a da nɛn an min -le 'wɩ tin \"baa. Kɔɔ an 'ka 'an 'bɔ 'ci 'sɔ wɩnun -wɛɛnan dɩ, 'pian Bali nɛn yaan 'pa 'sia bɛ, -a ci 'sɔ wɩnun -wɛɛnan nɛn an cɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","-Te 'an 'bɔ mɛɛn cɩ 'an 'bɔ 'fli -le 'wɩ 'nan yɩzan -a bɛ, min 'ka 'an wei siala 'wɩ 'kpa -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","'Pian 'mɛn 'wɩ 'nan yɩzan a, ɛn maan -tɔa 'nan 'wɩ nɛn yaa ve 'an man bɛ 'wɩ 'kpa nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","'Ka 'bɔ, 'ka minnun 'pa 'sia Zan -va, ɛn e 'wɩ tɩglɩ 'vɩ 'an man. ");
INSERT INTO yreNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","An 'bɔ 'le vɛ bɛ, ma'an wɛɛman 'nan min nɛn 'e drɛ 'mɛn 'wɩ 'nan yɩzan -a dɩ, 'pian 'an Zan -le 'wɩ ve cɛɛ 'nan -e 'ka yi -tɛra \"da, -e Bali 'e 'ka 'si 'wɩ 'ji. ");
INSERT INTO yreNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zan a \"le 'nan 'tɛ nɛn waa -fɔ \"nɛn ɛn e blɩ bɛ -yee 'wɩ 'zʋ. Ka wɩɩ \"man, ɛn 'ka 'ci nran -a -san man tʋ \"wɛnnɛn 'a. ");
INSERT INTO yreNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","'Wɩ nɛn 'bɛ 'mɛn 'wɩ -kɔɔnman bɛ, 'bɛ -dan \"mlian 'wɩ nɛn Zan -a 'vɩ 'an man bɛ -a da. 'Wɩnun nɛn 'an \"tɩ -a -nɔn 'mɛn 'nan 'an drɛ bɛ, -a 'wɩnun 'bɔ nɛn maan dra 'gʋ. -Yɛɛ -kɔɔnman 'nan 'an \"tɩ 'bɛ 'an 'pa 'sia. ");
INSERT INTO yreNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'An \"tɩ 'bɔ nɛn yaan 'pa 'sia bɛ, -yɛɛ 'an 'man wɩ 'vɩ 'e 'bɔ 'a. 'Pian ka'a tian 'li -a wei manlɛ 'mlɔnmlɔn dɩ, ɛn ka'a tian 'li -a yra yɩlɛ 'mlɔnmlɔn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ɛn -a wei -cin 'ka 'fɔla 'ka 'ji dɩ, kɔɔ ka'a yi 'tɛala -a -pɩ nɛn yaa 'pa 'sia bɛ -a da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kaa -tɔa 'nan Bali wei nɛn 'e 'crɛn -tɛdɩ bɛ, e 'belidɩ nɛn ya'a 'nyaan dɩɛ -a -nɔan \"min lɛ, -yee \"wɛan kaa ta ve tʋ pɛɛnɔn man. 'Fluba 'crɛnnun zɩɛ, -wɛɛ 'an 'man wɩ ve minnun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","'Pian ka 'ka \"vale 'ka -taa 'an -sru, -e 'belidɩ 'kpa 'e drɛ 'cee vɛ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","An 'ka -a -wɛɛnan 'nan minnun 'waan 'tɔ bɔ dɩ, ");
INSERT INTO yreNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","'pian an 'ka -tɔa. Maan -tɔa 'nan Bali yɩdɩ \"yi 'ka 'ka 'ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","'An \"tɩ 'bɛ 'an 'pa 'sia, ɛn ka 'ka \"vale 'kaan \"sia 'cee vɛ -a dɩ. -Te min pee -ta 'e 'bɔ 'tɔ da bɛ, cɛɛ \"sia 'cee vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kaa -wɛɛman 'nan 'ka bɔɛzan -tʋ 'e 'ka 'tɔ bɔ. Ka'a wɛɛman 'pian 'nan Bali -tʋwli \"nɛn 'e 'ka 'tɔ bɔ dɩ. Ɛn -te ka ya zɩɛ 'wɩ 'kpa bɛ, e dra 'kɔ -e 'ka yi -tɛra 'an da? ");
INSERT INTO yreNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Te 'ka 'ci \"nrɔn 'nan 'an \"tɩ 'va nun bɛ, 'an 'bɔ 'bɛ 'wɩ -tɔa 'ka man dɩ! Min nɛn e 'wɩ -tɔa 'ka man bɛ, Moizi nɛn 'ka 'ci \"nrɔn man \"da 'nan e -taa 'palɛ 'ka 'va bɛ -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","-Yɛɛ cɩ 'nan \"te ka yi -tɛala Moizi da bɛ, \"te ka yi -tɛala 'an da \"nyian, kɔɔ 'mɛn 'wɩ nɛn Moizi -a crɛn -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","'Pian 'wɩ nɛn yaa crɛn -tɛ bɛ, ka'a yi 'tɛala \"da \"dɩ, e dra \"mɛn 'kɔ 'lɔɔ -e 'ka yi -tɛra 'wɩ nɛn maan ve bɛ -a da?» ");
INSERT INTO yreNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","\"Bɛ -sru ɛn Zozi 'kʋ Galile 'yi nɛn waa laabo \"nyian Tiberia 'yi bɛ -a -sru. ");
INSERT INTO yreNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Min \"kaga 'kʋla Zozi -sru, -yee 'lɛbo \"fɔ wɩnun nɛn yaa drɛ -cɛ -tɛnɔn 'belidɩ -a ɛn waa -nan 'yɩ bɛ -yee \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Zozi pɔn -tʋ tri 'o 'vale 'e -srunɔn 'a, ɛn o -nyran. ");
INSERT INTO yreNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Te Zuif 'nɔn 'le 'si nɔanba -ji \"fɛdi drɛdɩ 'bɔ 'kogo. ");
INSERT INTO yreNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Zɩ Zozi 'e 'wulo wluan, ɛn e min \"kaga 'yɩ -tanan 'o 'va zia bɛ, -a -nan nɛn yaa laabʋ Filipʋ -lɔ 'nan: «Nyin zia nɛn, -kaa -blɩfɛ \"lɔa, -e -kaa -nɔn min \"kaga 'labɛ -wlɛ?» ");
INSERT INTO yreNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Zɩ kɔ Zozi 'e drɛ bɛ -a -cin a \"ji, 'pian e 'tan Filipʋ man -a ci wɩ mandɩ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ɛn Filipʋ \"e -yrɛ 'nan: «-Te -kaa -blɩfɛ 'lɔ -kpi fuba sinjɛn bɛ, ya'a 'bɔa waa \"fo \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ɛn Zozi -sruzan 'pee nɛn, waa laabo Andre, Simɔn Piɛri \"bʋɩ -a bɛ e 'nan: ");
INSERT INTO yreNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«'Kpɔun 'soolu 'lee pɔ \"fli \"a 'nɛn 'klɔnmɔn -tʋ -lɔ 'gʋ, 'pian ya'a 'bɔa waa \"fo \"dɩ?» ");
INSERT INTO yreNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ɛn Zozi \"e 'nan 'e -srunɔn lɛ 'nan: «'Ka min pɛɛnɔn -nyran \"tra.» Waa 'vɩ -wlɛ, ɛn o -nyran lu da, kɔɔ -a -nan lu a fɛnyian -nyran \"davɛ -a. Minnun zɩɛ, -klɔnmɔn a o va -kpi 'soolu. ");
INSERT INTO yreNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Zozi 'kpɔun 'soolu zɩɛ -a 'si, e Bali muo \"fɔ, ɛn yaa pli o man. E pɔ 'si ɛn yaa drɛ \"nyian zɩ. Min -tʋ \"e blɩ \"le zɩ e cɩ \"va \"bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Zɩ e o 'kan bɛ, ɛn Zozi \"e 'nan 'e -srunɔn lɛ 'nan: «'Ka -nyranman \"koola! Te 'ka 'blɩfɛ 'tʋɩ -e 'e srɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɛn -a -srunɔn -a koola. 'Kpɔun 'soolu bɛ e min \"kaga zɩɛ o 'kan, ɛn -a -nyranman saannɛn -fuda \"fli 'fa. ");
INSERT INTO yreNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Zɩ minnun Zozi 'le 'lɛbo \"fɔ wɩ -dan zɩɛ, -a -nan 'yɩ bɛ, ɛn o 'nan: «'Wɩ 'kpa! Min 'labɛ, e ya Bali 'lewei vɩzan nɛn o 'nan e -taa \"bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Zɩ Zozi -a -kɔnnɛn 'yɩ 'nan, o \"ta -daa 'e 'kunlɛ -e 'wee 'tɔ 'wee mingɔnnɛn -a bɛ, ɛn e 'li 'e da \"nyian pɔn da nun 'e 'saza. ");
INSERT INTO yreNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Zɩ funninmlan 'pla bɛ, ɛn -a -srunɔn sɔɔn \"ji 'yi man. ");
INSERT INTO yreNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","O -fɔ -klʋ -tʋ -ji, ɛn o -kʋdɩ 'sia 'fla nɛn waa laabo Kapanamo bɛ -a da. E ya 'yi 'bɔ -sru. Klun -trɔa, te Zozi 'ka tian bɔlɛ o man dɩ, ");
INSERT INTO yreNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ɛn fulɔ 'plɛblɛ 'tʋ \"fɛɛndɩ 'sia, te 'yi 'bɔ 'nyɔɔnman. ");
INSERT INTO yreNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","O -klʋ -fɔ o -sru 'bɔ 'kɔɔbli, waa drɛ kilo 'soolu te 'bɛ \"cɛɛ dɩ kilo 'shɛɛdʋ. \"Wɛɛ vɩnan 'o yiɛ -tɔa \"bɛ, te o Zozi ye -tanan 'ta wʋdɩ -a 'yi yiɛ da, ɛn \"klan -sɛn o ji. ");
INSERT INTO yreNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","'Pian Zozi \"e 'nan -wlɛ 'nan: «'An 'bɔ nɛn. Te \"klan 'e 'ka 'tɛ dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","-A -nan nɛn o ya \"vale 'nan 'o Zozi -fɔa 'o 'va 'klʋ -ji. 'Nun tɔɔn ɛn o bɔla fɛnan nɛn o cɩ -kʋnan bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Zɩ tʋ cɛɛn bɛ, minnun nɛn o -fʋ \"yi -sru \"bɛ, ɛn -a -cin -trɔa o ji 'nan -klʋ a 'sɩ 'tʋwli, ɛn Zozi 'ka 'fɔlɛ -ji dɩ. Waa -tɔa 'pian 'nan -a -srunɔn 'kʋ 'o 'saza. ");
INSERT INTO yreNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tɔɔn ɛn -klʋ -mienun 'si minnun -a Tiberia. O 'bɔla fɛnan nɛn Minsan Bali muo \"fɔ 'vaa ɛn o fɛnun blɩ bɛ, -a -nan \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Zɩ wa'a Zozi yɩlɛ dɩɛ, te wa'a \"nyian -a -srunɔn 'ye dɩɛ, ɛn minnun pɛɛnɔn 'fɔ -klʋnun zɩɛ -a -ji, ɛn o -kʋ Zozi -wɛɛlɛ Kapanamo. ");
INSERT INTO yreNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","O 'bɔ Zozi man 'yi -sru \"nun, ɛn waa laabʋ -yrɔ 'nan: «Bali -le 'wɩ \"paazan, tʋ \"cɛn \"man nɛn i -ta 'gʋ?» ");
INSERT INTO yreNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, ka -blɩfɛ 'yɩ, kaa blɩ, ka 'kan, -yee \"wɛan ka ya 'an -wɛɛnan. Ka 'ka 'an -wɛɛnan 'nan -cɛ -srɔn \"wɩnun nɛn maan drɛ bɛ, kaa -ci 'man 'le \"wɛan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Te 'ka -wɛɛ 'nan -blɩfɛ nɛn e srɛman bɛ, -nyrɛn 'ka ye dɩ. 'Pian 'ka -wɛɛ 'nan -blɩfɛ nɛn e \"mɔan ɛn e 'belidɩ -nɔan \"min lɛ bɛ, -nyrɛn 'ka ye. 'An 'bɔ Blamin -pɩ 'bɛ -blɩfɛ zɩɛ -a -nɔan 'cɛɛ, kɔɔ 'an \"tɩ Bali -a 'plɛblɛ 'nɔn 'mɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ɛn waa laabʋ -yrɔ 'nan: «Kʋa dra 'kɔ, 'wɩnun nɛn e cɩ Bali ci 'sɔ 'a bɛ, -e 'kʋ -kɔla -a drɛdɩ -a?» ");
INSERT INTO yreNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «'Wɩ -tʋwli \"nɛn Bali cɩ \"vale 'ka drɛ bɛ, -nyrɛn 'nan, 'ka yi -tɛra min nɛn Bali 'bɔ -a 'pa 'sia bɛ -a da.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","-A -nan nɛn waa laabʋ Zozi 'lɔ 'nan: «'Lɛbo \"fɔ wɩ \"kɔ \"nɛn yia dra -e 'kʋ yi -tɛra 'i da? -Mɛ \"wɩ nɛn i -taa -a drɛlɛ? ");
INSERT INTO yreNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","'Li te 'kʋ tranun a \"bui \"da bɛ, o fɛ -tʋ nɛn waa laabo manɛn bɛ, -a blɩ. E ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji nan: ‹E -blɩfɛ nɛn e 'si laji bɛ -a -nɔn -wlɛ.› » ");
INSERT INTO yreNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, Moizi \"cɛɛ -blɩfɛ tɩglɩ 'si laji ɛn yaa -nɔn 'cɛɛ dɩ. 'Pian 'an \"tɩ 'bɛ -blɩfɛ tɩglɩ 'si laji, ɛn yaa -nɔn 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","-Yɛɛ cɩ 'nan fɛ nɛn Bali -a -nɔn -blɩfɛ -a bɛ, min nɛn e 'si laji te e 'belidɩ -nɔan 'trɛdanɔn lɛ bɛ -nyrɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ɛn minnun -a 'vɩ -yrɛ 'nan: «Minsan, -blɩfɛ zɩɛ 'i -nɔn 'kʋɛ tʋ pɛɛnɔn man.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Zozi \"e 'nan \"mɛn -wlɛ 'nan: «'An 'bɔ 'bɛ cɩ -blɩfɛ nɛn e 'belidɩ -nɔan \"bɛ -a. Min nɛn e -ta 'an 'va bɛ, dra 'ka -a tɛa \"nyian 'mlɔnmlɔn dɩ, ɛn min nɛn e yi -tɛra 'an da bɛ, 'yi dra 'ka \"nyian -a tɛa 'mlɔnmlɔn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Maan 'vɩ 'cɛɛ 'va, ɛn kaan 'yɩ 'ka 'bɔa, 'pian ka'a yi 'tɛala 'an da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Minnun pɛɛnɔn nɛn 'an \"tɩ \"o -nɔn 'mɛn bɛ, o -taa 'an 'va, ɛn min \"ɛ -ta 'an 'va bɛ, ma'an pian 'mlɔnmlɔn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kɔɔ ma'an 'silɛ laji 'nan -e 'an 'bɔ 'fli ci 'sɔ wɩnun drɛ dɩ, 'pian 'nan -e 'an min nɛn yaan 'pa 'sia bɛ -a ci 'sɔ wɩnun drɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Min nɛn yaan 'pa 'sia bɛ, -a ci 'sɔ wɩnun nɛn 'nan: Minnun nɛn e o -nɔn 'mɛn bɛ, te 'an -tʋwli \"cɛ 'san \"va \"dɩ, 'pian 'nan 'an o wluan -kanɔn 'va yi -fɔla \"da \"ji. ");
INSERT INTO yreNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","'An \"tɩ 'ci 'sɔ wɩnun nɛn \"nyian 'nan, minnun pɛɛnɔn nɛn waan 'yɩ -a -pɩ -a ɛn o yi -tɛra \"da \"bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ e ya -wee vɛ -a. 'An 'bɔ 'bɛ o wuanla -kanɔn 'va yi -fɔla \"da \"ji.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Zozi -a 'vɩ 'nan 'e ya -blɩfɛ nɛn e 'si laji, ɛn e 'belidɩ -nɔan \"min lɛ bɛ -a, -yee \"wɛan minnun wunwun \"vɩdɩ 'sia 'o cin yei. ");
INSERT INTO yreNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Waa ve 'nan: «Min 'labɛ, Zozɛfʋ -pɩ Zozi bɛ -nyrɛn. -Kaa \"tɩ -tɔa, ɛn kaa \"bʋ -tɔa. E drɛ \"mɛn 'kɔ, ɛn yaa ve 'nan 'e 'si laji?» ");
INSERT INTO yreNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Ka wunwun \"vɩdɩ 'le 'tɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Min -tʋ 'ka 'kɔlaman -e 'e 'ta 'an 'va, te 'an \"tɩ \"nɛn yaan 'pa 'sia bɛ -yɛɛ \"cɛɛ 'taa 'mɛn dɩ. Ɛn -te e -ta bɛ, maan wuanla -kanɔn 'va yi -fɔla \"da \"ji. ");
INSERT INTO yreNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","E ya 'e 'crɛn -tɛdɩ Bali 'lewei vɩnɔn 'le 'fluba 'ji 'nan: ‹Bali 'bɛ 'wɩ \"paaman min pɛɛnɔn 'ji.› Min nɛn e -kaa \"tɩ Bali wei 'man, ɛn e wɩɩ -yee 'wɩ \"paadɩ man bɛ, -a san 'bɛ -taa 'an 'va. ");
INSERT INTO yreNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","E 'ka 'nan min -tʋ -kaa \"tɩ 'yɩ dɩ. An 'bɔ nɛn 'an 'si \"va \"nun bɛ, mɛɛn -kaa \"tɩ Bali 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan min nɛn e yi -tɛala 'an da bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ, e ya -a san -le vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","'An 'bɔ 'bɛ cɩ -blɩfɛ nɛn e 'belidɩ -nɔan \"bɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","'Ka tranun fɛ -tʋ nɛn waa laabo Manɛn bɛ -a blɩ \"bui \"da, ɛn ya'a 'kadɩ si 'lɛ wʋlɛ -wlɔ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","'Pian -blɩfɛ 'gʋɛ, 'bɛ 'si laji, min nɛn yaa blɩ bɛ, ya'a 'kaa \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","'An 'bɔ 'bɛ cɩ -blɩfɛ nɛn e 'belidɩ -nɔan \"bɛ -a. Min nɛn e -blɩfɛ zɩɛ -a blɩ bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ e ya -a san -le vɛ -a. -Blɩfɛ 'bɔ nɛn an -taa -a -nɔnlɛ bɛ, 'an 'bɔ 'kɔlɛ nɛn. Maan -nɔan 'trɛdanɔn pɛɛnɔn 'beli vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","-A -nan nɛn Zuif 'nɔn 'sa -fɔdɩ 'sia 'o cin yei, te waa ve 'nan: «Yaa dra 'kɔ -e 'e 'kɔlɛ 'nɔn min lɛ -blɩfɛ -a?» ");
INSERT INTO yreNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -te ka'an 'bɔ Blamin -pɩ 'kɔlɛ 'blɩlɛ dɩɛ, ɛn -te ka'an nyɛn mlinlɛ dɩɛ, te 'belidɩ 'ka 'ka 'lɔ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Min nɛn yaan 'kɔlɛ 'ble, ɛn yaan nyɛn -mlian \"bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ, e ya -a san -le vɛ -a. Maan wuanla -kanɔn 'va yi -fɔla \"da \"ji. ");
INSERT INTO yreNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","-Yɛɛ cɩ 'nan 'an 'kɔlɛ bɛ, -blɩfɛ tɩglɩ nɛn, ɛn 'an nyɛn bɛ, mlin vɛ tɩglɩ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Min nɛn yaan 'kɔlɛ 'ble ɛn yaan nyɛn -mlian \"bɛ, te 'kʋ 'vale -a san -a kʋ drɛ min -tʋwli \"a, kʋ'a 'sia 'e cin man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","-Kaa \"tɩ \"nɛn yaan 'pa 'sia bɛ 'belidɩ a -yrɔ, ɛn -yɛɛ 'belidɩ -nɔn 'mɛn, -a -tʋwli \"nɛn \"nyian min nɛn yaan 'kɔlɛ blɩ bɛ, an 'belidɩ -nɔan -a san lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","'An 'kɔlɛ bɛ, -blɩfɛ tɩglɩ nɛn e 'si laji bɛ -nyrɛn. E 'ka \"le 'nan fɛ nɛn 'ka tranun -a blɩ \"bui \"da bɛ -yee 'wɩ 'zʋ dɩ. Waa blɩ, ɛn ya'a 'kadɩ si 'lɛ wʋlɛ -wlɔ \"dɩ. Min nɛn e -blɩfɛ 'gʋɛ -a blɩ bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ e ya -a san -le vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","'Wɩ zɩɛ, -a 'bɔ nɛn Zozi -a 'vɩ te e ya 'wɩ \"paanan minnun ji Zuif 'nɔn 'le cin yɩ 'kuin, 'fla nɛn waa laabo Kapanamo bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ɛn zɩ -a -srunɔn 'wɩnun zɩɛ -a 'man bɛ, -a -nan nɛn o va min \"kaga \"e 'nan: «'Wɩ nɛn yaa \"paaman 'gʋɛ, e ya 'plɛblɛ, min -tʋ 'ka 'kɔlaman -e 'e \"trɔɛn \"tɔ -yrɛ \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Te Zozi -a -tɔ 'e 'fli -lɔ 'va 'nan 'wɩ zɩɛ e wunwun \"vɩdɩ 'pla 'e -srunɔn 'nɛan. Ɛn yaa laabʋ -wlɔ 'nan: «'Wɩ nɛn maan 'vɩ 'gʋɛ e 'ka 'ci baa 'ji? ");
INSERT INTO yreNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'Lɔɔ -te ka Blamin -pɩ 'yɩ te e \"ta wuanla -e 'e 'kʋ fɛnan nɛn e cɩ 'e tɛdɛ bɛ -a -nan bɛ, e dra 'cɛɛ 'kɔ? ");
INSERT INTO yreNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Bali lei 'saun 'bɛ 'belidɩ -nɔan \"min lɛ. Min 'bɔ 'saza 'ka 'kɔlaman -e 'e 'belidɩ yɩ dɩ. Wei nɛn maan 'vɩ 'cɛɛ 'gʋɛ, min nɛn e yi -tɛra \"da \"bɛ, e Bali lei 'saun ye, ɛn e 'belidɩ ye. ");
INSERT INTO yreNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","'Pian min -mienun a 'ka yei te wa'a yi 'tɛala \"da \"dɩ.» -Te Zozi 'wɩ zɩɛ -a 'vɩ bɛ, -yɛɛ cɩ 'nan -a pou sianan \"bɛ, te e minnun nɛn wa'a yi 'tɛala -a wei da dɩɛ o -tɔa, ɛn min nɛn e -taa -a -nɔnlɛ minnun lɛ bɛ yaa -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tɔɔn ɛn Zozi -a 'vɩ \"nyian 'nan: «-Yee \"wɛan nɛn maan 'vɩ 'cɛɛ 'nan min 'ka 'kɔlaman -e 'e 'ta 'an 'va te 'an \"tɩ \"cɛɛ -si -nɔn -yrɛ \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tʋ zɩɛ -a man nɛn Zozi -srunɔn \"kaga 'li 'o da, ɛn wa'a \"nyian -sɔɔnlɛa -a -sru \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ɛn Zozi -a laabʋ min -fuda \"fli \"nɛn o -fʋ -a -sru \"bɛ -wlɔ 'nan: «Kaa \"nun, ka 'ka \"vale \"ka -koo \"nyian dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","-A -nan nɛn Simɔn Piɛri -a 'vɩ -yrɛ 'nan: «Minsan, -tɩ -va nɛn kʋ lia 'kʋ da? 'I wei 'bɛ 'belidɩ nɛn ya'a 'nyaan dɩɛ -a -nɔan \"min lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kʋ yi -tɛra \"da ɛn kʋa -tɔ 'nan yiɛ cɩ min nɛn Bali -a 'si \"va \"bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «'An 'bɔ 'bɛ 'ka 'si \"va -fuda \"fli, 'pian 'ka 'va min -tʋ a Satan -le 'nɛn 'a!» ");
INSERT INTO yreNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Min nɛn Zozi cɩ -yee 'wɩ vɩnan bɛ, Simɔn Karioti -pɩ Zudazi nɛn. -A -srunɔn 'fuda \"fli 'bɔ 'va min -tʋ nɛn, -yɛɛ -taa Zozi 'bɔ 'nɔnlɛ minnun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","\"Bɛ -sru ɛn Zozi ciɩ Galile 'lɛglɔn 'ji. E 'ka \"vale 'e 'ko Zude 'lɛglɔn 'ji dɩ, kɔɔ Zuif 'nɔn 'tanɔn a -a -wɛɛnan 'nan -e 'o -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Zuif 'nɔn 'le \"fɛdi nɛn waa -ble lo 'la -paannun wlu bɛ -a tʋ 'bɔ 'kogo. ");
INSERT INTO yreNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ɛn Zozi \"bʋɩnun \"e Zozi lɛ 'nan: «'I 'si 'gʋ! 'I 'kʋ Zude 'lɛglɔn 'ji -e 'i -srunɔn 'o 'lɛbo \"fɔ wɩnun nɛn yia dra bɛ -a -nan yɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Min nɛn yaa -wɛɛman 'nan min pɛɛnɔn 'o 'e 'tɔ bɛ, ya'a 'yɔɔman dɩ. 'Wɩnun nɛn yia dra 'gʋɛ, 'i drɛ -e min pɛɛnɔn 'o -nan yɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Zozi 'bɔ \"bʋɩnun 'ka \"nyian \"o yi 'tɛala Zozi da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Mɛn tʋ 'ka tian bɔlɛ dɩ. 'Pian tʋ pɛɛnɔn a \"yi 'cee vɛ \"le \"a. ");
INSERT INTO yreNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","-A -ci \"ka -e 'trɛdanɔn 'o 'nan \"cee \"man dɩ, 'pian o \"naan \"mɛɛn \"man, kɔɔ maan -tɛala o yra 'nan o drɛ wɩ a -wlidɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","'Ka 'bɔ, 'ka 'kʋ \"fɛdi da. Ma'an 'koo \"fɛdi 'labɛ -a da dɩ, kɔɔ 'mɛn tʋ 'ka tian bɔlɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","E 'wɩ zɩɛ -a 'vɩ -wlɛ, ɛn e -fʋ Galile. ");
INSERT INTO yreNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Zɩ Zozi \"bʋɩnun -kʋ \"fɛdi 'bɔ da bɛ, ɛn Zozi 'bɔ 'kʋla o -sru \"mɛn. 'Pian ya'a 'yee -kʋdɩ -ci -tɛlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Zuif 'nɔn 'tanɔn -a -wɛɛdɩ 'sia minnun nɛn o -kʋ \"fɛdi zɩɛ -a da bɛ o yei, te waa laabo -wlɔ 'nan: «-Vɛ -mie 'gʋɛ e ya nyin zia?» ");
INSERT INTO yreNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Minnun wunwun \"vɩdɩ 'sia fɛ zɩɛ -a -nan \"kaga. Min -mienun -a ve 'nan: «E ya min tɩglɩ 'a.» Te -a -mienun \"o \"ve 'nan: «-Cɛjɛ! Min nɛn e min see \"paaman bɛ -nyrɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","'Pian min -tʋ 'ka 'wɩ 'bɔ zɩɛ -a vɩlɛ wei 'plɛblɛ 'ji dɩ, kɔɔ \"klan a o ji Zuif 'nɔn 'tanɔn 'le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Zɩ \"fɛdi drɛdɩ 'bɔ 'e yei \"bɛ, Zozi 'kʋ Bali -pan 'kuin, ɛn e 'wɩ \"paadɩ 'sia minnun ji. ");
INSERT INTO yreNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","-Yee 'wɩ \"paadɩ Zuif 'nɔn 'tanɔn 'bɔ 'kan te waa ve 'nan: «Min 'labɛ ya'a drɛlɛ min -tʋ -sruzan 'a dɩ, e drɛ 'kɔ ɛn e 'wɩ nɛn 'e 'crɛn -tɛdɩ bɛ -a -tɔa zɩɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Wɩ nɛn maan \"paaman minnun ji 'gʋɛ, ya'a 'sia 'an 'bɔ 'va dɩ, 'pian e \"sia Bali nɛn yaan 'pa 'sia bɛ -a va. ");
INSERT INTO yreNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Min nɛn e ya \"vale 'e Bali zɩɛ -a ci 'sɔ wɩnun dra bɛ, -yɛɛ 'mɛn 'wɩ \"paadɩ 'gʋɛ -a -tɔa. -Te Bali va nɛn e \"sia oo, ɛn te 'an 'bɔ 'va nɛn e \"sia oo, -a san 'bɛ -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Min nɛn 'e 'bɔ 'wulo -ji wɩ \"paaman minnun ji bɛ, te e ya 'e 'bɔ 'fli 'tɔ -wɛɛnan. 'Pian min nɛn e ya \"vale 'nan min nɛn yee 'pa 'sia bɛ minnun 'o bɔ bɛ, -a san zɩɛ min tɩglɩ nɛn, ya'a 'wɩ 've 'wlu 'a dɩɛ, -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moizi -pei -tɔ wɩnun paa 'ka 'ji, 'pian 'ka pɛɛnɔn ka'a 'ta wʋla \"da \"dɩ. Ɛn ka ya \"vale 'kaan -tɛa \"nyian, -mɛ \"le \"wɛan?» ");
INSERT INTO yreNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Minnun \"kaga \"bɛ waa 'vɩ -yrɛ 'nan: «Fɛ -wlidɩ \"tʋ a 'i -sru. -Tɩɛ cɩ -a -wɛɛnan 'nan 'yei -tɛa?» ");
INSERT INTO yreNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Zozi \"e 'nan -wlɛ 'nan: «An 'lɛbo \"fɔ wɩ -tʋwli drɛ 'gʋɛ, -a 'wɩ 'nan 'ka pɛɛnɔn man. ");
INSERT INTO yreNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moizi -a 'vɩ 'cɛɛ 'nan, 'ka 'nɛn 'fɔ -klɔnmɔn -va 'e -ya yi 'sɔra da. Ɛn -te yi 'sɔrazan zɩɛ e -tria 'flinla \"yi da bɛ, kaa dra -kpɔ. -Pɛ -tʋ da zia bɛ, Moizi \"cɛɛ -pei -trɔa dɩ, 'pian -a tranun -a dra 'e 'cɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","'Flinla \"yi da bɛ ka 'nɛn -fɔa \"klɔnmɔn -va, -e 'ka vɩlɛ 'ka Moizi -le -pei 'srɔɛn srɛ dɩ -le \"wɛan. -Te 'bɛ a zɩɛ, -mɛ \"le \"wɛan 'bli 'fɔ 'ka 'ji 'an man 'nan, \"an \"blamin -munmuan beli 'flinla \"yi da? ");
INSERT INTO yreNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ka min -le 'wɩ ve \"ta lou. 'Cɛɛ 'le 'tɔ, 'ka 'wɩ 'fa 'si 'vaa -e 'ka min -le 'wɩ 'cɛn!» ");
INSERT INTO yreNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","-A -nan nɛn Zeruzalɛm 'nɔn -mienun \"o 'nan: «\"Ka 'yiɔ, min nɛn o cɩ -a -wɛɛnan 'nan 'o -tɛa \"bɛ -nyrɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ɛn -yɛɛ 'wɩ tin \"baa minnun yei te wa'a 'wɩ tʋ ve -yrɛ \"bɛ dɩ. Maan ye \"le -kaa 'tanɔn -a -tɔ 'nan -yɛɛ cɩ min nɛn Bali -a 'si \"va \"bɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","'Pian min 'labɛ -cɛɛ 'sinan -tɔa. Min nɛn Bali -a 'si \"va \"bɛ -te 'bɛ 'ta bɛ, min -tʋ 'ka 'bɛ 'sinan 'tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tʋ zɩɛ -a wlu bɛ, te Zozi a 'wɩ \"paanan minnun ji Bali -pan 'kuin, ɛn yaa 'vɩ wei 'plɛblɛ 'ji 'nan: «Kaa \"nrɔnman 'ka 'ji 'nan, kaan -tɔa, ɛn -a -nan nɛn an 'si bɛ kaa -tɔa. 'Pian ma'an 'talɛ 'an 'bɔ 'fli -ji dɩ. Min nɛn yaan 'pa 'sia bɛ e ya tɩglɩ, ɛn ka'a min zɩɛ -a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","'Mɛn vɛ bɛ \"an -tɔa, kɔɔ -a va nɛn an 'si, ɛn -yɛɛ 'an 'pa 'sia.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","-A -nan nɛn Zeruzalɛm 'nɔn zɩɛ o ya \"vale 'o Zozi \"kuan. 'Pian min -tʋ 'ka -kɔlalɛ -a 'kundɩ -a dɩ, kɔɔ -yee tʋ 'ka tian bɔlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Min -mienun \"o \"yi -tɛra Zozi 'bɔ da. Minnun zɩɛ o ya \"kaga ɛn \"o laabʋ 'nan: «Min nɛn Bali -a 'si \"va \"bɛ, yi nɛn e -ta bɛ, e -cɛ -srɔn \"wɩ \"kaga \"dra e \"mlian min 'labɛ -a da?» ");
INSERT INTO yreNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wunwun \"nɛn minnun cɩ -a vɩnan Zozi man bɛ, Farizɛn 'nɔn -a 'man. -A -nan nɛn 'o 'vale Bali -pannɔn 'tanɔn 'a o minnun 'pa 'sia 'nan 'o 'kun. ");
INSERT INTO yreNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ɛn Zozi \"e 'nan -wlɛ 'nan: «An \"flian tian 'ka yei tʋ \"wɛnnɛn 'a, \"bɛ -sru -e 'an li 'an da min nɛn yaan 'pa 'sia bɛ -a va. ");
INSERT INTO yreNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ka -taa 'an -wɛɛlɛ, 'pian ka'a 'kɔlaman 'an yɩdɩ -a dɩ. Ɛn fɛnan nɛn an -kɔan \"bɛ, ka'a 'kɔlaman -e 'ka 'kʋ -nan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ɛn Zuif 'nɔn 'tanɔn -a laabʋ 'o cin lɔ 'nan: «Nyin zia nɛn e -taa \"kʋlɛ -e -kaa vɩlɛ -kaa yɩ dɩ? E -ko Zuif 'nɔn nɛn 'o fuiladɩ \"man 'trɛda bɛ o va, -e 'e 'wɩ \"paa minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ o ji? ");
INSERT INTO yreNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","'Wɩ nɛn yaa 'vɩ 'labɛ -a -ci nɛn 'nɔn? Kɔɔ yaa 'vɩ 'nan: ‹Ka -taa 'an -wɛɛlɛ, 'pian ka'a 'kɔlaman 'an yɩdɩ -a dɩ.› Ɛn: ‹Fɛnan nɛn an -kɔan \"bɛ, ka'a 'kɔlaman -e 'ka 'kʋ -nan dɩ.› » ");
INSERT INTO yreNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","\"Fɛdi yi -nyranman da nɛn, -yɛɛ cɩ yi -dan 'bɔ 'a. Yi zɩɛ -a da nɛn Zozi a minnun yei 'e 'tɔdɩ, ɛn yaa 'vɩ wei 'plɛblɛ 'ji 'nan: «Min nɛn 'yi dra -a -tɛa \"bɛ, -a san 'e 'ta 'an 'va -e 'e 'yi 'mlin. ");
INSERT INTO yreNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Min nɛn e yi -tɛra 'an da bɛ, -a san -kɔan \"le 'yi ku nɛn e 'belidɩ -nɔan \"min lɛ bɛ -yee 'wɩ 'zʋ. Zɩ e cɩ 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji zɩɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Lei 'saun nɛn minnun nɛn o yi -tɛra Zozi da o -taa -a yɩlɛ bɛ, -yee 'wɩ nɛn Zozi 'bɔ cɩ -a vɩnan. Tʋ zɩɛ -a man bɛ, te Bali lei 'saun 'ka tian 'talɛ dɩ, kɔɔ Zozi 'ka tian 'kʋlɛ 'e \"tɩ \"le mingɔnnɛn trɛ nɛn e \"bia bɛ -a da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Zɩ min \"kaga 'wɩ zɩɛ -a 'man bɛ, ɛn o -mienun -a 'vɩ 'nan: «Min 'labɛ, 'wɩ 'kpa e ya Bali 'lewei vɩzan nɛn o 'nan e -taa \"bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Min plɔɛnnun \"o 'vɩ 'nan: «Min 'labɛ, min nɛn Bali -a 'si \"va \"bɛ -nyrɛn.» Ɛn min peenun \"o 'vɩ 'nan: «Min nɛn Bali -a 'si \"va \"bɛ ya'a 'kɔlaman -e 'e 'si Galile dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kɔɔ e ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan, min nɛn Bali -a 'si \"va \"bɛ, e -kɔan David kluda min -a, ɛn e \"sia Bɛtelɛm, David -ya trɛ -da.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Zozi 'le \"wɛan, -sa -fɔla minnun \"kaga zɩɛ o yei. ");
INSERT INTO yreNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ɛn o va min -mienun a \"vale 'o \"kuan, 'pian min -tʋ 'ka -kɔlalɛ -a 'kundɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","-A -nan nɛn minnun nɛn Bali -pannɔn 'tanɔn 'lee Farizɛn 'nɔn o 'pa 'sia bɛ o 'li 'o da o 'va. Ɛn Bali -pannɔn 'tanɔn 'lee Farizɛn 'nɔn -a laabʋ -wlɔ 'nan: «-Mɛ \"le \"wɛan nɛn ka'a 'kunlɛ -e 'ka 'ta -a dɩ?» ");
INSERT INTO yreNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ɛn 'pa 'sianɔn \"o -wlɛ 'nan: «'Wɩ nɛn yaa ve bɛ, min -tʋ 'ka tian 'li -a vɩlɛ 'mlɔnmlɔn dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ɛn Farizɛn 'nɔn \"o 'nan: «'Ka 'bɔ \"nyian, maan ye \"le -yee 'wɩ 'ka 'sia 'nan. ");
INSERT INTO yreNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","-Kaa Farizɛn 'nɔn -ka'a tɔlɛ -a -sru \"dɩ, ɛn -kaa tazan -tʋ 'ka 'tɔlɛ -a -sru \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","'Pian minnun nɛn wa'a Moizi -le -pei -tɔ wɩ tɔa dɩ, ɛn Bali wei a 'e 'pladɩ o man bɛ, o 'saza 'bɛ -tɔa -a -sru.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodɛm nɛn e -kʋ Zozi 'man yɩlɛ 'e tɛdɛ bɛ, e ya Farizɛn 'nɔn 'bɔ 'va. Ɛn yaa 'vɩ Farizɛn 'nɔn zɩɛ -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«-Cee -pei \"e 'nan, -te wa'a tian min -le tin 'balɛ dɩɛ, wa'a 'wɩ 'tɔa -a san man dɩ. 'Pian -te min 'wɩ drɛ bɛ, waa wei maan 'vaa, ɛn o 'wɩ -tɔa \"man.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɛn Farizɛn 'nɔn -a laabʋ -yrɔ 'nan: «Galile min nɛn \"nyian \"yie \"a? 'I -nanjɛn Bali -le 'fluba 'ji 'kpa tɩglɩ -e 'i -tɔ 'nan Bali 'lewei vɩzan 'ka 'li 'sia Galile dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","\"Bɛ -sru ɛn o pɛɛnɔn 'kʋ 'wee \"kɔnnɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","-A -nan nɛn Zozi 'kʋ Olivie pɔn da. ");
INSERT INTO yreNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","-A ta tʋ cɛɛn, bodrun puunɔn ɛn Zozi 'li 'e da Bali -pan 'kuin. Tɔɔn min \"kaga \"kʋ \"va. Zozi -nyran, ɛn e 'wɩ \"paadɩ 'sia o ji. ");
INSERT INTO yreNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","-A -nan nɛn 'fluba 'ci vɩnɔn 'lee Farizɛn 'nɔn 'ta lɩmɔn -tʋ -a, ɛn waa -tɔ minnun yei. Lɩ zɩɛ o 'bɔ \"man, te e ya nyinnan -kɔnnɛn -sru. ");
INSERT INTO yreNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ɛn o 'nan Zozi lɛ 'nan: «Bali -le 'wɩ \"paazan, lɩ 'gʋɛ, kʋ 'bɔ \"man te e ya nyinnan -kɔnnɛn -sru. ");
INSERT INTO yreNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moizi -a crɛn -tɛ -pei 'fluba 'ji 'nan lɩmɔn nɛn e 'wɩ zɩɛ -a drɛ bɛ, 'o -tɛ -kɔlɛ -a. Bii \"nun \"i 'vɩ 'nɔn?» ");
INSERT INTO yreNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","O 'wɩ zɩɛ -a laabʋ 'nan -e 'o wei 'kun, -e 'o -kɔla 'wɩ 'tɔdɩ -a \"man. 'Pian Zozi 'kunnan, ɛn e fɛ -tʋ crɛn -tɛdɩ 'sia 'e 'pɛ 'wlɛ 'a 'trɛ da, ");
INSERT INTO yreNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","te Farizɛn 'nɔn 'lee 'fluba 'ci vɩnɔn 'wɩ laabo Zozi 'lɔ. O ya 'wɩ laabʋnan Zozi 'lɔ \"bʋʋ \"le \"wɛan, 'e 'wulo wluan, ɛn e 'nan -wlɛ 'nan: «Min nɛn 'ka yei, te ya'a tian 'wɩ 'wlidɩ \"drɛlɛ dɩɛ, -a san 'e -kɔlɛ tɛdɛ tuʋ -yrɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","E 'kunnan \"nyian 'e \"pa 'ji, ɛn yaa crɛn -tɛdɩ 'sia \"nyian 'trɛ da. ");
INSERT INTO yreNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Zɩ Farizɛn 'nɔn 'lee 'fluba 'ci vɩnɔn 'bɔ 'wɩ zɩɛ -a 'man bɛ, ɛn o pɛɛnɔn 'kʋ -tʋdʋ. Min cejenun 'bɛ 'kʋdɩ 'sia 'e 'flin. -A -nan nɛn lɩ bɛ e -fʋ 'e 'tɔdɩ Zozi 'lɛ 'e -tʋwli minnun yei. ");
INSERT INTO yreNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Zozi 'e 'wulo wluan, ɛn yaa laabʋ -yrɔ 'nan: «Minnun nɛn o 'wɩ 'tɔ 'i man bɛ, o ya nyin zia? Min -tʋ 'ka \"nyian -nan -e 'e 'wɩ 'tɔ 'i man dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ɛn lɩ zɩɛ e 'nan Zozi lɛ 'nan: «'An 'san, min -tʋ 'ka \"nyian -nan dɩ.» Zozi \"e -yrɛ 'nan: «'An 'bɔ \"nyian, ma'an 'wɩ tɔa 'i man dɩ. 'I 'kʋ! Te 'i 'wɩ 'wlidɩ \"drɛ \"nyian dɩ!» ");
INSERT INTO yreNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tʋ pee -a bɛ, ɛn Zozi 'wɩ tin 'badɩ 'sia \"nyian minnun lɛ. Yaa 'vɩ -wlɛ 'nan: «'An 'bɔ 'bɛ cɩ 'tɛ 'san nɛn e 'trɛdanɔn 'man dra 'wein bɛ -a. Min nɛn e sɔɔnla 'an -sru \"bɛ, te ya'a \"nyian 'ta wo klun va dɩ, ɛn 'tɛ 'san nɛn e 'belidɩ -nɔan \"min lɛ bɛ e ya -a san -le vɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ɛn Farizɛn 'nɔn -a 'vɩ Zozi lɛ 'nan: «'Wɩ nɛn yia ve bɛ, e 'ka 'wɩ 'kpa 'a dɩ, kɔɔ yiɛ cɩ -a vɩnan 'i 'fli man.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Zozi -a 'vɩ -wlɛ 'nan: «-Te 'an 'bɔ mɛɛn cɩ 'an 'bɔ 'fli -le 'wɩ vɩnan oo, 'wɩ nɛn maan ve 'gʋɛ, 'wɩ 'kpa nɛn. Kɔɔ fɛnan nɛn an 'si bɛ, maan -tɔa. Ɛn fɛnan nɛn an cɩ -kʋnan bɛ, maan -tɔa. 'Pian 'cee vɛ bɛ, fɛnan nɛn an \"sia bɛ, ka'a -nan tɔa dɩ, ɛn fɛnan nɛn an cɩ -kʋnan bɛ, ka'a -nan tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","\"Ka \"tin -tɛa \"min da blamin -wulo -ji wɩ yra man. 'An 'bɔ 'le vɛ bɛ, ma'an tin tɛa min da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","'Pian -te an tin -tɛ min da bɛ, e ya 'e 'nɔan da. Kɔɔ an 'ka 'an -tʋwli \"dɩ, 'kʋ 'vale 'an \"tɩ \"nɛn yaan 'pa 'sia bɛ -a kʋɛ cɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","E ya 'e 'crɛn -tɛdɩ 'cee -pei 'fluba 'ji 'nan: ‹-Te min \"fli \"wei a -tʋwli 'wɩ 'tʋ da bɛ, te 'wɩ zɩɛ e ya 'wɩ 'kpa -a.› ");
INSERT INTO yreNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","'An 'bɔ 'an 'fli -le 'wɩ ve, ɛn 'an \"tɩ \"nɛn yaan 'pa 'sia bɛ, e 'mɛn 'wɩ ve.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ɛn waa laabʋ -yrɔ 'nan: «'I \"tɩ 'bɔ a nyin zia?» Zozi \"e -wlɛ 'nan: «Ka'an tɔa dɩ, ɛn ka'an \"tɩ tɔa dɩ. \"Te kaan -tɔa \"bɛ, \"te kaan \"tɩ -tɔa \"nyian.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Zozi a 'wɩ zɩɛ -a \"paanan minnun ji, te e ya Bali -pan 'kuin, fɛnan nɛn minnun \"lala -sɛan -gbogbo -ji Bali -le vɛ -a bɛ -a -nan. Ɛn min -tʋ 'ka -a 'kunlɛ dɩ, kɔɔ -yee tʋ 'ka tian bɔlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Zozi -a 'vɩ \"nyian -wlɛ 'nan: «An \"ta -ko. Ka -taa 'an -wɛɛlɛ, 'pian ka'an 'ye dɩ. Ɛn 'cee 'wɩ 'wlidɩ \"fo 'ka 'lɔ -e 'ka 'ka. Fɛnan nɛn an \"ta -ko 'gʋɛ, ka'a 'kɔlaman -e 'ka 'kʋ -nan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ɛn Zuif 'nɔn 'tanɔn -a laabʋ 'o 'fli -lɔ 'nan: «E \"ta -ko 'e 'fli -tɛlɛ -baalɛ, kɔɔ yaa 'vɩ 'nan, fɛnan nɛn 'e \"ta -ko bɛ, -ka'a 'kɔlaman -e -kaa kʋ -nan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ɛn e 'nan -wlɛ 'nan: «'Trɛ 'gʋɛ -a da 'nɔn nɛn \"cee \"a. \"Ka 'si wo 'trɛda 'gʋ, 'pian \"an 'si wo laji lou. Ma'an 'sia 'trɛda 'gʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","-Yee \"wɛan maan 'vɩ 'cɛɛ 'nan, 'cee 'wɩ 'wlidɩ \"fo 'ka 'lɔ -e 'ka 'ka. Kɔɔ min nɛn an cɩ -a bɛ, -te ka'a yi 'tɛala \"da 'nan an ya min zɩɛ -a dɩɛ, 'cee 'wɩ 'wlidɩ \"fo 'ka 'lɔ -e 'ka 'ka.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ɛn waa laabʋ Zozi 'lɔ 'nan: «-Tɩ nɛn 'yia?» Zozi -a 'vɩ -wlɛ 'nan: «Min nɛn an cɩ -a bɛ, maan ve 'cɛɛ, te maan ve. ");
INSERT INTO yreNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'Wɩ \"kaga \"a -e 'an vɩ 'ka man -e tin 'e 'tɛ 'ka da. 'Pian 'wɩ nɛn maan 'man min nɛn yaan 'pa 'sia bɛ -a da bɛ, -nyrɛn maan ve 'trɛdanɔn lɛ. Min zɩɛ ya'a 'wɩ 've 'wlu 'a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wa'a -ci manlɛ \"le 'nan -a \"tɩ \"le 'wɩ nɛn e cɩ -a vɩnan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «Tʋ nɛn ka Blamin -pɩ \"paa yiba \"man lou \"bɛ, -a tʋ zɩɛ -a man nɛn kaa -tɔa 'nan min nɛn an cɩ -a bɛ -nyrɛn 'maan. Ɛn kaa -tɔa 'nan ma'an 'wɩ 'dra 'an 'bɔ 'fli -ji dɩ, 'pian 'wɩ nɛn maan 'man 'an \"tɩ \"da bɛ -nyrɛn maan ve. ");
INSERT INTO yreNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Min nɛn yaan 'pa 'sia bɛ, 'kʋ 'vale -a kʋɛ cɩ. Ya'an 'tʋɩlɛ 'an -tʋwli \"dɩ, kɔɔ -a ci 'sɔ wɩnun nɛn maan dra tʋ pɛɛnɔn man.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Zɩ Zozi 'wɩnun zɩɛ -a 'vɩ bɛ, ɛn min \"kaga yi -tɛra Zozi 'bɔ da. ");
INSERT INTO yreNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","-A -nan nɛn Zuif 'nɔn nɛn o yi -tɛra Zozi 'bɔ da bɛ, Zozi -a 'vɩ -wlɛ 'nan: «-Te 'ka 'ta 'wʋla 'an wei da 'kpa bɛ, te ka ya 'an -srunɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ka -taa 'wɩ tɩglɩ 'tɔlɛ, -e 'wɩ tɩglɩ 'e 'ka drɛ minnun nɛn o 'ka nɔan -a dɩɛ waa.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɛn Zuif 'nɔn 'bɔ -a 'vɩ -yrɛ 'nan: «Kʋ ya Abraam kluda 'nɔn 'a, ɛn kʋ'a tian 'li drɛlɛ min -tʋ -le nɔan -a dɩ. -Mɛ \"le \"wɛan nɛn yia ve 'nan: ‹Kʋ dra minnun nɛn o 'ka nɔan -a dɩɛ waa?› » ");
INSERT INTO yreNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min oo min nɛn e 'wɩ 'wlidɩ \"dra bɛ, te e ya 'wɩ 'wlidɩ \"le nɔan -a. ");
INSERT INTO yreNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nɔan 'ka 'fo \"kɔnnɛn 'li 'trilii dɩ, 'pian 'nɛn nɛn e cɩ 'yee vɛ -nan bɛ, -yɛɛ fo \"kɔnnɛn 'li 'trilii. ");
INSERT INTO yreNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","-Te 'an 'bɔ Bali -pɩ an 'ka 'si nɔanba -ji bɛ, ka'a 'kɔan \"nyian fɛ -tʋ -lɔ nɔan -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Maan -tɔa 'nan ka ya Abraam kluda 'nɔn 'a, 'pian ka ya -a -wɛɛnan 'nan 'kaan -tɛa, kɔɔ ka 'ka \"vale 'ka 'ta wʋla 'mɛn 'wɩ \"paadɩ da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","'Wɩ nɛn maan -nan 'yɩ 'an \"tɩ 'lɔ bɛ, -nyrɛn maan ve, ɛn 'cee vɛ bɛ, 'wɩ nɛn kaa 'man 'ka \"tɩ \"da bɛ, -nyrɛn kaa dra.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɛn o 'nan Zozi lɛ 'nan: «Abraam 'bɛ cɩ 'kʋ \"tɩ \"a.» Ɛn Zozi \"e 'nan -wlɛ 'nan: «\"Te Abraam -le 'nɛnnun nɛn 'kaa bɛ, \"te Abraam drɛ wɩ nɛn kaa dra. ");
INSERT INTO yreNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","'Wɩ tɩglɩ nɛn maan 'man Bali da bɛ, maan ve 'cɛɛ tʋ pɛɛnɔn man. 'Pian 'bɛ nɛn 'gʋɛ, ka ya -a -wɛɛnan 'nan 'kaan -tɛa. 'Wɩ zɩɛ Abraam 'ka 'bɛ drɛlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","'Pian 'cee vɛ bɛ, 'ka \"tɩ \"drɛ wɩ nɛn kaa dra.» Ɛn o 'nan Zozi lɛ 'nan: «Bɔɛda nɛn \"cɛɛ 'kʋa dɩ, Bali -tʋwli 'bɛ cɩ 'kʋ \"tɩ \"a.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ɛn Zozi \"e 'nan -wlɛ 'nan: «\"Te Bali 'bɛ cɩ 'ka \"tɩ \"a bɛ, \"te kaan ye \"yi. Kɔɔ Bali va nɛn an 'si, ɛn an -ta. Ma'an 'talɛ 'an 'bɔ 'fli -ji dɩ, 'pian -yɛɛ 'an 'pa 'sia. ");
INSERT INTO yreNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ka 'ka \"vale 'ka \"trɔɛn -tɔa 'an wei lɛ dɩ, -yee \"wɛan nɛn ka'an wei -ci maan dɩ? ");
INSERT INTO yreNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Satan nɛn e 'wɩ 'wlidɩ \"paa min lɔ bɛ, -yɛɛ cɩ 'ka \"tɩ \"a, ɛn 'ka \"tɩ 'ci 'sɔ wɩnun nɛn kaa dra. -A pou sianan 'li 'trilii -e 'e bɔ cɛɛgʋɛ, min -tɛzan nɛn. Ya'a 'ta wʋla 'wɩ tɩglɩ da 'mlɔnmlɔn dɩ, kɔɔ ya'a 'tɔa 'wɩ tɩglɩ -sru \"dɩ. 'Wlu 'sɛndɩ -cin nɛn \"ji, kɔɔ 'wluzan nɛn, ɛn -a va nɛn 'wlu wɩ pɛɛnɔn \"sia. ");
INSERT INTO yreNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","'Mɛn vɛ bɛ, an 'wɩ tɩglɩ ve, -yee \"wɛan ka'a yi 'tɛala 'an da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Min -tʋ 'ka 'ka yei -e 'e -ci -kɔɔn 'nan an 'wɩ 'wlidɩ drɛ dɩ. Ɛn -te 'wɩ tɩglɩ nɛn maan ve bɛ, -mɛ \"le \"wɛan ka'a yi 'tɛala 'an da dɩ? ");
INSERT INTO yreNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Min nɛn Bali cɩ -a \"tɩ \"a bɛ, 'wɩ nɛn Bali -a ve bɛ 'e \"trɔɛn -tɔa -yrɛ. 'Pian 'cee vɛ bɛ, Bali \"cɛɛ 'ka \"tɩ \"a dɩ -yee \"wɛan ka'a \"trɔɛn 'tɔa -a wei lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Zuif 'nɔn 'tanɔn \"e Zozi lɛ 'nan: «'Kʋe tin a 'nɔnnɔn -a vɩdɩ -a 'nan Samari min nɛn yia, ɛn -yʋ -wlidɩ \"a 'i -sru.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Zozi -a 'vɩ -wlɛ 'nan: «-Yʋ -wlidɩ 'ka 'an -sru \"dɩ. 'An \"tɩ \"nɛn maan 'tɔ dra -dan, ɛn 'cee vɛ bɛ, \"kaan 'tɔ srɛman. ");
INSERT INTO yreNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'An 'bɔ an 'ka -a -wɛɛnan 'nan min 'e 'an 'tɔ drɛ -dan dɩ. 'Pian min -tʋ 'bɛ cɩ -a -wɛɛnan. Ɛn -a min zɩɛ, -yɛɛ 'cee tin \"baa. ");
INSERT INTO yreNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan min nɛn e 'ta 'wʋla 'an wei da bɛ, -a san 'ka 'kaa 'mlɔnmlɔn dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ɛn Zuif 'nɔn -a 'vɩ -yrɛ 'nan: «Kʋa -tɔ \"mɛn 'nan -yʋ -wlidɩ \"a 'i -sru. Abraam -ka, ɛn Bali 'lewei vɩnɔn \"o \"ka 'wʋ \"nyian. -E 'i vɩ 'nan: ‹Min nɛn e 'ta 'wʋla 'i wei da bɛ, -a san 'ka 'kaa 'mlɔnmlɔn dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","'Kʋ tra Abraam -ka, ɛn Bali 'lewei vɩnɔn \"o \"ka 'wʋ \"nyian. 'I -dan \"mlian Abraam da? 'I 'bɔ 'i 'fli \"siala 'kɔ?» ");
INSERT INTO yreNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ɛn Zozi \"e 'nan -wlɛ 'nan: «-Te 'an 'bɔ mɛɛn 'an 'fli 'tɔ dra -dan bɛ, 'mɛn 'tɔ -dan zɩɛ, e ya 'wɩ \"tun \"a. 'An \"tɩ 'bɔ 'bɛ 'an 'tɔ dra -dan. 'Ka 'bɔ cɛɛ 'vɩ 'nan -yɛɛ cɩ 'cee Bali -a, ");
INSERT INTO yreNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","'pian ka'a tɔa dɩ. 'An 'bɔ 'bɛ -tɔa. -Te maan 'vɩ 'nan ma'an tɔa dɩɛ, te an drɛ 'wluzan 'a \"le 'cee 'wɩ 'zʋ. 'Pian maan -tɔa, ɛn an 'ta 'wʋla -a wei da. ");
INSERT INTO yreNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tʋ nɛn an -taa \"man 'trɛda bɛ, Bali -a 'vɩ 'ka tra Abraam lɛ. 'Wɩ zɩɛ e Abraam ci -ta \"tra. Abraam -a -nan 'yɩ, ɛn yaa ci nran.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ɛn Zuif 'nɔn -a vɩ Zozi lɛ 'nan: «'I lɛ -fuba 'soolu 'ka 'bɔa dɩ -e 'i Abraam yɩ?» ");
INSERT INTO yreNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Zozi -a 'vɩ -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, tʋ nɛn te wa'a tian Abraam -yalɛ dɩɛ, te an ya.» ");
INSERT INTO yreNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","'Wɩ zɩɛ -a da nɛn o -kɔlɛ siila 'nan -e 'o Zozi 'tɛ -a. 'Pian Zozi yɔɔ, ɛn e 'bɔla Bali -pan 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Zozi a ciɩnan ɛn e min -tʋ nɛn waa -ya 'e yiɛ 'a 'e 'widɩ bɛ -a 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ɛn Zozi -srunɔn 'a laabʋ Zozi 'lɔ 'nan: «Bali -le 'wɩ \"paazan, -mɛ \"le \"wɛan nɛn o min 'gʋɛ -a -ya 'e yiɛ 'a 'e 'widɩ? -A 'bɔ 'le 'wɩ 'wlidɩ \"man nɛn, -baa -a \"tɩ 'lee -a \"bʋ \"le 'wɩ 'wlidɩ \"man nɛn?» ");
INSERT INTO yreNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ɛn Zozi \"e -wlɛ 'nan: «Wa'a vɩlɛ 'nan -a 'bɔ 'le 'wɩ 'wlidɩ \"man nɛn dɩ, ɛn -te 'bɛ \"cɛɛ dɩ, -a \"tɩ 'lee -a \"bʋ \"le 'wɩ 'wlidɩ \"man nɛn -a yiɛ 'wi dɩ. 'Pian -a yiɛ 'wi 'nan -e minnun 'o 'wɩ -dan nɛn Bali \"ta -daa -a drɛlɛ -yrɛ \"bɛ -a -nan yɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","'Bɛ nɛn tʋ a tian 'e 'cɛndɩ 'gʋɛ, min nɛn yaan 'pa 'sia bɛ, -kaa -yee 'nyranman 'pa. -Pei -taa \"tanlɛ, te min -tʋ 'ka 'kɔlaman -e 'e 'nyranman 'pa \"nyian dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","'Bɛ nɛn an ya tian 'trɛda 'gʋɛ, mɛɛn cɩ 'tɛ 'san nɛn e 'trɛdanɔn 'man dra 'wein bɛ -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Zɩ Zozi cɛɛn 'wɩ zɩɛ -a vɩdɩ man bɛ, ɛn 'e 'le 'yi -sran \"tra. E -feli drɛ 'e 'le 'yi 'bɔ 'a, yaa ciɩ yiɛ 'wizan zɩɛ -a yiɛ da, ");
INSERT INTO yreNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ɛn e 'nan -yrɛ 'nan: «'I 'kʋ 'i yra \"foe 'yi nɛn waa laabo Siloe bɛ -a va.» Siloe -ci nɛn 'nan 'padɩ -sia. E -kʋ 'e yra foe, ɛn e 'li 'e da te e fɛnan ye 'wein. ");
INSERT INTO yreNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yiɛ 'wizan zɩɛ -a \"srɔn 'nɔn 'lee minnun nɛn waa 'yɩ te e fɛ trʋ \"baa bɛ, \"o laabʋ 'nan: «Min nɛn \"nɛn e -nyɛanla 'gʋ te e fɛ trʋ \"baa bɛ, -njɛɛ bɛ dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Min -mienun \"o 'vɩ 'nan: «-A 'bɔ nɛn.» Min plɔɛnnun \"o 'vɩ 'nan: «-A 'bɔ \"cɛɛ dɩ, 'pian -a siazan \"nɛn.» Ɛn -a 'bɔ \"e 'nan: «'Wɩ 'kpa, 'e 'bɔ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","-A -nan nɛn waa laabʋ -yrɔ 'nan: «E drɛ 'kɔ ɛn 'i yiɛ 'lɛ 'sʋ?» ");
INSERT INTO yreNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɛn e 'nan -wlɛ 'nan: «Min nɛn waa laabo Zozi bɛ, e -feli drɛ, yaa ciɩ 'an yiɛ da, ɛn e 'mɛn 'nan 'an 'kʋ 'an yra \"foe Siloe 'yi 'va. An -kʋ -nan nun, zɩ 'an yra foe bɛ, ɛn 'an yiɛ 'lɛ 'sʋ.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɛn waa laabʋ -yrɔ 'nan: «Min 'bɔ -a nyin zia?» E 'nan -wlɛ 'nan: «Ma'an 'tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","O -kʋ min nɛn -a yiɛ 'lɛ 'sʋ bɛ -a Farizɛn 'nɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","'Flinla \"yi da nɛn Zozi 'feli drɛ, ɛn e min zɩɛ -a yiɛ 'lɛ 'sʋ 'a. ");
INSERT INTO yreNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farizɛn 'nɔn \"o laabʋ \"nyian min bɛ -yrɔ 'nan: «E drɛ 'kɔ ɛn 'i yiɛ 'lɛ 'sʋ?» Ɛn e 'nan -wlɛ 'nan: «E -feli ciɩ 'an yiɛ da, 'an yra foe, ɛn an fɛnan 'yɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Zɩ e 'wɩ zɩɛ -a 'vɩ bɛ, ɛn Farizɛn 'nɔn -mienun \"o 'nan: «Min nɛn e 'wɩ 'labɛ -a drɛ bɛ, ya'a 'sia Bali va dɩ, kɔɔ e 'flinla \"yi 'srɔɛn srɛ.» Te min plɔɛnnun \"o \"ve 'nan: «'Wɩ 'wlidɩ \"drɛzan 'ka 'kɔlaman -e 'e 'cɛ -srɔn \"wɩ zɩɛ -a drɛ dɩ.» -A -nan nɛn o wei 'ka \"nyian drɛlɛ -tʋwli \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Waa laabʋ min nɛn -a yiɛ 'lɛ 'sʋ bɛ -yrɔ 'nan: «'I 'bɔ \"i \"ve min nɛn yei yiɛ 'lɛ 'sʋ bɛ -a man 'nɔn?» Ɛn e 'nan -wlɛ 'nan: «Bali 'lewei vɩnan nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Zuif 'nɔn 'tanɔn 'ka yi -tɛlɛa \"da 'nan min zɩɛ -a yiɛ a 'e 'widɩ 'e 'cɛn dɩ. Ɛn waa \"tɩ 'lee -a \"bʋ laabʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Zɩ o -ta bɛ, ɛn waa laabʋ -wlɔ 'nan: «'Cee 'nɛn nɛn ka 'nan waa -ya 'e yiɛ 'a 'e 'widɩ bɛ -nyrɛn 'gʋ? E drɛ \"mɛn 'kɔ, ɛn -a yiɛ 'lɛ 'sʋ 'siɛn?» ");
INSERT INTO yreNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","-A \"tɩ 'lee -a \"bʋ \"o 'nan: «Kʋa -tɔa 'nan 'kʋe 'nɛn nɛn, ɛn kʋa -ya te -a yiɛ a 'e 'widɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","'Pian fɛ nɛn e drɛ 'lɔɔ ɛn -a yiɛ 'lɛ 'sʋ 'siɛn 'gʋɛ, kʋ'a tɔa dɩ. Ɛn min 'bɔ nɛn yaa yiɛ 'lɛ 'sʋ bɛ, kʋ'a 'bɛ 'tɔa \"nyian dɩ. 'Ka 'wɩ laabʋ -a 'bɔ 'lɔ, e ya ceje -e 'e -ci vɩ 'e 'bɔ 'a.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","-A \"tɩ 'lee -a \"bʋ \"klanman Zuif 'nɔn 'tanɔn 'lɔ -yee \"wɛan o 'wɩ zɩɛ -a 'vɩ. Kɔɔ Zuif 'nɔn 'o 'ci 'pa 'nan, min oo min nɛn yaa 'vɩ 'nan, Zozi 'bɛ cɩ min 'sizan 'wɩ 'ji Crizi -a bɛ, 'o -pian 'wee cin yɩ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","-Yee \"wɛan -a \"tɩ 'lee -a \"bʋ -a 'vɩ 'nan: «E ya ceje 'ka 'wɩ laabʋ -a 'bɔ 'lɔ.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","-A -nan nɛn min nɛn -a yiɛ 'lɛ 'sʋ bɛ, Farizɛn 'nɔn -a 'pa \"flizan laabʋ \"nyian, ɛn o 'nan -yrɛ 'nan: «'I Bali 'tɔ drɛ -dan 'wɩ tɩglɩ vɩdɩ -a! Kʋa -tɔa 'nan min bɛ 'wɩ 'wlidɩ \"drɛzan nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ɛn e 'nan -wlɛ 'nan: «-Te e ya 'wɩ 'wlidɩ \"drɛzan -a bɛ, ma'an tɔa dɩ. Maan -tɔa 'pian 'nan, 'an yiɛ a \"nɛn 'e 'widɩ ɛn 'bɛ nɛn 'gʋɛ, an fɛnan ye 'siɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Waa laabʋ -yrɔ \"nyian 'nan: «-Mɛ \"nɛn yaa drɛ 'yiɛ? Yaa drɛ 'kɔ ɛn yei yiɛ 'lɛ 'sʋ?» ");
INSERT INTO yreNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ɛn e 'nan -wlɛ 'nan: «Maan 'vɩ 'cɛɛ 'va ɛn ka'a \"trɔɛn \"tɔlɛ -yrɛ \"dɩ. -Mɛ \"le \"wɛan ka ya \"nyian -a mandɩ va? \"Ka \"ya wo \"nyian \"vale 'ka dra -a -srunɔn 'a?» ");
INSERT INTO yreNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","-A -nan nɛn waa \"srɔndɩ 'sia, ɛn o 'nan -yrɛ 'nan: «'I 'bɔ 'bɛ cɩ -a -sruzan 'a, \"kʋ \"ya wo Moizi -srunɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kʋa -tɔa 'nan Bali 'wɩ tin 'ba Moizi lɛ, 'pian min 'labɛ, kʋ'a 'bɛ 'sinan 'tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ɛn min nɛn -a yiɛ 'lɛ 'sʋ bɛ, yaa 'vɩ -wlɛ 'nan: «\"Ka 'yiɔ 'wɩ 'a bɛ, fɛnan nɛn e 'si bɛ, ka'a tɔa dɩ, ɛn yaan yiɛ 'lɛ 'sʋ! ");
INSERT INTO yreNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","-Kaa -ci -tɔa 'nan Bali 'ka 'wɩ 'wlidɩ \"drɛnɔn wei maan dɩ. 'Pian -te min Bali bɔa ɛn yaa ci 'sɔ wɩnun dra bɛ, min zɩɛ Bali -a wei maan. ");
INSERT INTO yreNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ɛn ka'a tian 'li -a manlɛ 'nan min nɛn waa -ya 'e yiɛ 'a 'e 'widɩ bɛ, min -tʋ -a yiɛ 'lɛ 'sʋ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","\"Te min 'bɛ ya'a 'silɛ Bali va dɩɛ, \"te ya'a -kɔlalɛ -a drɛdɩ -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɛn waa 'vɩ -yrɛ 'nan: «'I 'bɔ nɛn wei 'ya 'wɩ 'wlidɩ va \"fo \"bɛ, yiɛ 'wɩ \"paaman 'kʋ 'ji?» Ɛn waa -pin 'o yei. ");
INSERT INTO yreNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Zɩ Zozi -a 'man 'nan waa -pin 'o yei \"bɛ, e -kʋ \"va ɛn yaa laabʋ -yrɔ 'nan: «I yi -tɛala Blamin -pɩ da?» ");
INSERT INTO yreNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ɛn e 'nan Zozi lɛ 'nan: «'An 'san, -tɩɛ cɩ \"nyian 'bɛ 'a -e 'an yi -tɛra \"da?» ");
INSERT INTO yreNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Zozi \"e -yrɛ 'nan: «Yia 'yɩ, 'an 'bɔ nɛn an 'wɩ tin \"baa yiɛ 'gʋɛ, 'an 'bɔ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","-A -nan nɛn e 'nan: «Minsan, 'an yi -tɛala 'i da.» Ɛn e blula \"wlu. ");
INSERT INTO yreNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","-A -nan nɛn Zozi \"e 'nan: «An -ta 'trɛ 'gʋɛ -a da 'nan -e 'an minnun 'cɛn 'e cin man. -Yɛɛ cɩ 'nan minnun nɛn wa'a fɛnan ye dɩɛ, o fɛnan ye, ɛn minnun nɛn 'o 'fli \"siala fɛnan yɩnɔn 'a bɛ o yiɛ -wia.» ");
INSERT INTO yreNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farizɛn 'nɔn -mienun nɛn -a \"srɔn \"bɛ, zɩ o 'wɩ zɩɛ -a 'man bɛ, ɛn waa laabʋ -yrɔ 'nan: «Yie 'nan 'i ve 'nan, 'kʋ yiɛ a 'e 'widɩ?» ");
INSERT INTO yreNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Zozi \"e 'nan -wlɛ 'nan: «\"Te 'ka 'kɔn yiɛ 'winɔn 'a bɛ, \"te 'cee 'wɩ 'wlidɩ \"ka \"fo \"dɩ. 'Pian 'bɛ nɛn 'gʋɛ, 'ka 'nan, 'ka fɛnan ye, te ka'a 'we 'mɛn 'wɩ \"paadɩ man dɩ, -yee \"wɛan 'cee 'wɩ 'wlidɩ \"a tian.» ");
INSERT INTO yreNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Zozi \"e 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min nɛn ya'a 'wlamlan 'bla 'klɔn -ji -klɔn 'bɔ -yrɛ \"nɛn \"dɩɛ, 'pian yaa -tria \"fɛ pee -nan bɛ, min zɩɛ crinzan nɛn, ɛn 'bla 'tɛzan nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","'Pian min nɛn e -wlamlan 'klɔn -yrɛ \"nɛn \"bɛ, -yɛɛ cɩ 'blanun 'bɔ -sru \"pinzan -a. ");
INSERT INTO yreNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Min nɛn 'e -nyrandɩ -klɔn 'bɔ -yrɛ \"nɛn \"bɛ, e -klɔn 'lɛ \"so -yrɛ. Ɛn 'blanun nɛn o cɩ -yee vɛ -a bɛ, 'o \"trɔɛn -tɔa -a wei lɛ, e o laabo 'o 'tɔ man -e 'e bɔla waa bei. ");
INSERT INTO yreNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","-Te e cɛɛn 'blanun nɛn o cɩ -yee vɛ -a bɛ o bɔladɩ man bɛ, -e 'e -trɔa o 'lɛ, te 'blanun -kʋla -a -sru, kɔɔ waa wei -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wa'a 'sɔɔnmlan min nɛn e cɩ -pɛn -a bɛ -a -sru 'mlɔnmlɔn dɩ. O flan \"blia 'pian -yrɔ, kɔɔ minnun nɛn o cɩ -pɛn -a bɛ wa'a o wei tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Zozi -kɔnnɛn zɩɛ -a -fɔ -wlɛ, 'pian 'wɩ 'bɔ nɛn yaa tin 'ba -wlɛ \"bɛ, wa'a -ci manlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ɛn Zozi -a -ci 'vɩ \"nyian -wlɛ 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, 'blanun man -klɔn 'bɔ bɛ, mɛɛn cɩ -a -yrɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Minnun pɛɛnɔn nɛn o -trɔa 'an 'lɛ 'e tɛdɛ bɛ, crinnɔn nɛn waa, ɛn 'bla 'tɛnɔn nɛn waa. 'Pian 'blanun 'ka 'o \"trɔɛn \"tɔlɛ o wei lɛ 'mlɔnmlɔn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","-Klɔn 'bɔ man -yrɛ bɛ, 'an bɔ nɛn. Min nɛn e ciɩla 'an 'va, ɛn e wla 'klɔn -ji bɛ, e \"sia 'wɩ 'ji. E bɔala e \"tun, ɛn e -wlamlan 'e \"tun, -a -blɩfɛ a -e 'e -blɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Crinzan bɛ, \"e \"ta wo crin wʋdɩ 'lee 'bla 'tɛdɩ 'lee fɛ srɛdɩ 'tɔ 'ji. 'Pian 'mɛn vɛ bɛ, \"an \"ta 'wʋ 'nan -e 'blanun 'o 'beli, -e -wee 'belidɩ 'e 'kɔn 'e 'lɛ sɔɔdɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mɛɛn cɩ 'bla -sru \"pinzan 'kpa -a. 'Bla -sru \"pinzan 'kpa bɛ, e \"we \"man -e 'e 'ka 'yee 'blanun -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","'Pian min nɛn 'bɛ 'nyranman \"paa \"lala -le \"wɛan bɛ, te 'blanun 'bɔ 'ka -a san -le vɛ -a dɩɛ, -te e beli 'yɩ 'tanan bɛ, e \"sia 'blanun -sru -e 'e flan 'bli. Beli 'bɔ o fuimlan \"man -e 'e o \"kuun. ");
INSERT INTO yreNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Min nɛn 'bɛ 'nyranman \"paa \"lala -le \"wɛan bɛ, 'bɛ flan \"blia, kɔɔ 'blanun -tɛdɩ bɛ, -a 'wɩ 'ka 'naan \"man \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mɛɛn cɩ 'bla -sru \"pinzan 'kpa -a. An 'mɛn 'blanun -tɔa, ɛn waan -tɔa, ");
INSERT INTO yreNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","\"le zɩ 'an \"tɩ 'an -tɔa ɛn 'an \"tɩ 'bɔ -tɔa \"bɛ -yee 'wɩ 'zʋ. 'An 'man a 'e wʋʋdɩ -e 'an 'ka 'mɛn 'blanun -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","'Mɛn 'bla -mienun a te o 'ka tian -klɔn 'gʋɛ -a -ji dɩ. 'Blanun zɩɛ, an o -fɔa \"ji, o -taa 'an wei manlɛ -e 'o drɛ 'blanun nɛn o -sru \"pinzan a -tʋwli \"bɛ waa. ");
INSERT INTO yreNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","'An \"tɩ 'an ye \"yi, kɔɔ 'an 'fli -nɔn 'nan -e 'an 'ka, -e 'an 'belidɩ yɩ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Min -tʋ 'ka 'mɛn 'belidɩ sia 'an 'lɔ dɩ, 'pian 'an 'bɔ 'bɛ -nɔan 'an 'fli -a. 'Plɛblɛ a 'an 'lɔ -e 'an -nɔn, ɛn 'plɛblɛ a 'an 'lɔ -e 'an 'si \"nyian 'e \"pa 'ji. 'Wɩ nɛn 'an \"tɩ \"e 'mɛn 'nan 'an drɛ bɛ, -nyrɛn \"bɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","'Wɩ nɛn Zozi -a 'vɩ zɩɛ, -yee \"wɛan Zuif 'nɔn cɛɛn \"nyian 'e cin man. ");
INSERT INTO yreNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Min \"kaga \"a o yei te \"o \"ve 'nan: «-Yʋ -wlidɩ \"a -a -sru, ɛn klin \"a -a -wulo -ji. Te 'ka \"trɔɛn \"tɔ -a wei lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Min -mienun \"o 'vɩ 'nan: «Ya'a 'wɩ 've \"le min nɛn -yʋ -wlidɩ \"a -a -sru \"bɛ -yee 'wɩ 'zʋ dɩ. -Yʋ -wlidɩ 'ka 'kɔlaman -e 'e min nɛn -a yiɛ cɩ 'e 'widɩ bɛ -a yiɛ 'lɛ 'sʋ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Minnun a Bali -pan 'kɔn 'le \"fɛdi drɛnan Zeruzalɛm. \"Fɛdi zɩɛ, waa dra lɛ pɛɛnɔn man 'nan -e Bali -pan 'kɔn nɛn waa 'lɛ 'sʋ \"nyian 'e 'pee bɛ, -a -cin 'e -trɔa o ji. Tʋ zɩɛ -a man bɛ te trun -taa. ");
INSERT INTO yreNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ɛn Zozi ciɩdɩ 'sia Bali -pan 'kɔn 'lɛ \"nɛn, fɛnan nɛn waa 'tɔ 'pa Salomɔn man bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ɛn Zuif 'nɔn 'o cin 'yɩ \"man, waa laabʋ -yrɔ 'nan: «Tʋ \"cɛn \"a nɛn, i 'wɩ 'ci \"sia 'kʋɛ 'wein -e 'kʋ vɩnan 'kʋ 'ci -tɔɔ \"nyian dɩ? -Te min 'sizan 'wɩ 'ji Crizi nɛn 'yia bɛ, 'i -ci 'si 'kʋɛ tɩglɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Zozi -a 'vɩ -wlɛ 'nan: «Maan 'vɩ 'cɛɛ 'va, ɛn ka'a yi 'tɛala 'an da dɩ. 'Wɩnun nɛn maan dra 'an \"tɩ 'tɔ da 'gʋɛ, yaa -ci -kɔɔnman 'nan, min 'sizan 'wɩ 'ji nɛn 'maan. ");
INSERT INTO yreNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","'Pian ka'a yi 'tɛala 'an da dɩ, 'mɛn 'blanun \"cɛɛ 'kaa dɩ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","'Blanun nɛn 'o cɩ 'mɛn vɛ -a bɛ, 'waan wei maan, an 'o -tɔa, ɛn 'o 'ta wʋla 'an -sru. ");
INSERT INTO yreNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'Belidɩ nɛn ya'a 'nyaan dɩɛ, maan -nɔan -wlɛ, wa'a 'li 'kaa 'mlɔnmlɔn dɩ. Ɛn min -tʋ 'ka 'kɔlaman -e 'e o 'si 'an 'lɔ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","'An \"tɩ \"nɛn e o -nɔn 'mɛn bɛ, -a 'plɛblɛ \"mlian fɛ pɛɛnɔn da, ɛn min -tʋ 'ka 'kɔlaman -e 'e o 'si 'an \"tɩ 'lɔ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","'An 'bɔ 'lee 'an \"tɩ \"bɛ, kʋ ya min -tʋwli \"a.» ");
INSERT INTO yreNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tɔɔn ɛn Zuif 'nɔn -kɔlɛ koola 'nan -e 'o wɛɛn \"nyian Zozi 'va. ");
INSERT INTO yreNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ɛn Zozi \"e 'nan -wlɛ 'nan: «An 'wɩ -dandan drɛ 'ka yiɛ man \"kaga 'an \"tɩ \"le 'plɛblɛ 'a. 'Wɩ 'bɔ \"cɛn \"le \"wɛan nɛn ka \"ta -kɔlɛ wɛɛnman 'an 'va?» ");
INSERT INTO yreNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ɛn Zuif 'nɔn -a 'vɩ -yrɛ 'nan: «Wa'a vɩlɛ 'nan 'wɩ 'tʋ nɛn yia drɛ \"yi \"bɛ, -a 'tɔ 'ji nɛn kʋ \"ta -kɔlɛ wɛɛnman 'i 'va dɩ, 'pian 'nan i Bali srɔn \"le \"wɛan. 'I ya min -a ɛn 'i 'fli drɛ Bali -a, -yee \"wɛan kʋ \"ta -kɔlɛ wɛɛnman 'i 'va.» ");
INSERT INTO yreNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Zozi \"e 'nan -wlɛ 'nan: «E ya 'e 'crɛn -tɛdɩ 'cee -pei 'fluba 'ji 'nan: ‹Bali \"e 'nan, 'ka ya balinun -a.› ");
INSERT INTO yreNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ɛn -kaa -tɔa 'nan 'wɩ nɛn Bali -le 'fluba 'ji bɛ, 'wɩ 'kpa 'nɛn. Minnun nɛn Bali 'wɩ tin \"baa -wlɛ \"bɛ, e o laabo balinun. ");
INSERT INTO yreNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ɛn 'an 'bɔ bɛ, Bali 'an 'si \"va ɛn yaan 'pa 'sia 'trɛda. -Mɛ \"le \"wɛan nɛn -te maan 'vɩ 'nan Bali -pɩ nɛn 'maan bɛ, ɛn kaa ve 'nan an Bali srɔn? ");
INSERT INTO yreNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","-Te 'wɩ nɛn maan dra 'gʋɛ, 'an \"tɩ \"drɛ wɩ \"cɛɛ dɩɛ, te 'ka yi -tɛra 'an da dɩ! ");
INSERT INTO yreNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","'Pian -te -a 'bɔ nɛn maan dra bɛ, 'ka yi -tɛra 'an da. -Te 'bɛ \"cɛɛ dɩ, 'ka yi -tɛra 'wɩ 'bɔ nɛn maan dra bɛ -a da. 'Ka drɛ zɩɛ, -e 'ka -tɔ 'kpa tɩglɩ 'nan 'kʋ 'vale 'an \"tɩ \"a bɛ, kʋ ya min -tʋwli \"a.» ");
INSERT INTO yreNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","'Wɩ zɩɛ -a da nɛn, o ya \"nyian \"va 'nan 'o \"kuan, 'pian e 'sʋ -wlɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Zozi 'kʋ \"nyian Zudan 'yi -sru, fɛnan nɛn Zan minnun -batize drɛ 'e tɛdɛ bɛ -a -nan, ɛn e -fʋ -nan nun. ");
INSERT INTO yreNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Min \"kaga \"kʋla Zozi -sru. Minnun zɩɛ waa 'vɩ 'nan: «Zan 'ka -cɛ -srɔn \"wɩ -tʋ drɛlɛ dɩ, 'pian 'wɩ pɛɛnɔn nɛn yaa 'vɩ min 'gʋɛ -a man bɛ, e ya 'wɩ 'kpa -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Minnun nɛn o -kʋ fɛ zɩɛ -a -nan bɛ, o \"kaga \"yi -tɛra Zozi da. ");
INSERT INTO yreNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Min -tʋ nɛn waa laabo Laza bɛ, -a man \"yaaman. E -nyɛanla 'fla nɛn waa laabo Betani bɛ -a da. -A \"blu Mari 'lee Mat \"o \"nyɛnwla \"nyian 'fla 'bɔ zɩɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari zɩɛ, -yɛɛ \"ta -daa -laziglɔ -sɛnlɛ Minsan cɛin -da, -e 'e man bʋʋ 'e 'wulo \"jɛ \"a. -A \"bʋɩ Laza man 'bɛ \"yaaman. ");
INSERT INTO yreNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","-A \"blunun zɩɛ, o min 'pa 'sia 'nan 'e vɩ Zozi lɛ 'nan: «Minsan, 'i bee bɛ -a man \"yaaman.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Zɩ Zozi 'wɩ zɩɛ -a 'man bɛ, ɛn e 'nan: «Laza -le -cɛ 'labɛ, -a -tɛ vɛ \"cɛɛ dɩ. 'Pian e -fɔ Laza man 'nan -e 'e Bali -le 'plɛblɛ 'ci -kɔɔn. Ɛn \"nyian 'dʋ -e Bali -pɩ 'tɔ 'e drɛ -dan -cɛ 'bɔ 'le \"wɛan.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mat 'lee Mari 'lee o \"bʋɩ Laza 'bɔ bɛ, Zozi o ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Zɩ yaa 'man 'nan Laza man \"yaaman bɛ, ɛn e yi drɛ \"nyian fɛnan nɛn e cɩ bɛ -a -nan 'fiili. ");
INSERT INTO yreNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","\"Bɛ -sru, ɛn yaa 'vɩ \"e -srunɔn lɛ 'nan: «-Kaa 'li -kaa da Zude.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ɛn -a -srunɔn -a laabʋ -yrɔ 'nan: «Bali -le 'wɩ \"paazan, tʋ nɛn e \"sia ciɩnan -kogo 'gʋɛ -a -ji \"cɛɛ Zuif 'nɔn nɛn Zude bɛ, o ya -a -wɛɛnan 'nan 'wei -tɛa \"kɔlɛ -a 'gʋ dʋʋ? Yie 'nan 'i 'ko -nan nun?» ");
INSERT INTO yreNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «-Te tʋ cɛɛn bɛ, fɛnan a 'wein bodrun 'trilii -e funnin 'e 'pla. Min nɛn e 'ta wo te tʋ cɛɛn bɛ, -a srɔɛn 'ka 'wia dɩ, kɔɔ 'tɛ nɛn e \"bia 'trɛda bɛ, -a -san man nɛn e 'ta wo. ");
INSERT INTO yreNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","'Pian min nɛn e 'ta wo klun va bɛ, -a srɔɛn -wia, kɔɔ 'tɛ 'ka -a 'lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Zɩ e cɛɛn 'wɩ zɩɛ -a vɩdɩ man bɛ, ɛn e 'nan -wlɛ 'nan: «-Kaa bee Laza a yi -tɛnan, 'pian 'an 'ko -a fuʋlɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ɛn -a -srunɔn -a 'vɩ -yrɛ 'nan -te e ya yi -tɛnan bɛ, -a fa dra \"yi -e 'e 'beli. ");
INSERT INTO yreNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Laza -kadɩ 'wɩ nɛn Zozi -a 'vɩ, 'pian e ya -a -srunɔn \"le 'ji 'nan yi tɩglɩ 'bɛ 'fɔla Laza da. ");
INSERT INTO yreNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ɛn Zozi -a -ci 'vɩ -wlɛ \"mɛn 'wein 'nan: «Laza -ka. ");
INSERT INTO yreNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","'Cee \"wɛan, ɛn 'dʋ -e 'ka yi -tɛra 'an da bɛ -yee \"wɛan, 'an 'ci \"nranman. Kɔɔ an 'ka 'nan nun dɩ ɛn e drɛ. 'Pian -kaa kʋ \"va \"nun.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","'Wɩ zɩɛ -a da nɛn Toma nɛn waa laabo \"nyian \"flɛn bɛ, e 'nan Zozi -srunɔn -mienun lɛ 'nan: «-Kaa kʋla Zozi -sru -e -kaa ka 'e cin va waa.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Zozi \"ɛ bɔla 'nan nun bɛ, te o Laza 'wʋ -a -nan yi sinjɛn 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani 'lee Zeruzalɛm bɛ, o yei bɔa kilo \"fli, -te 'bɛ \"cɛɛ dɩ kilo yaaga. ");
INSERT INTO yreNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","-Yee \"wɛan Zuif 'nɔn \"kaga \"ta -nyɛnlɛa Mat 'lee Mari \"srɔn o \"bʋɩ nɛn e -ka bɛ -a -cɛ -da. ");
INSERT INTO yreNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Zɩ Mat -a 'man 'nan Zozi -a -tanan bɛ, ɛn e -kʋ -a 'silɛ -sia te Mari yra 'e -nyrandɩ \"kɔnnɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mat -a 'vɩ Zozi lɛ 'nan: «'An 'san, \"te 'i 'kɔn 'gʋɛ, \"te 'an \"bʋɩ 'ka 'kalɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","'Pian 'bɛ 'bɔ nɛn 'gʋɛ, an yi -tɛala \"da 'nan 'wɩ pɛɛnɔn nɛn yia laabo Bali lɔ bɛ, yaa 'lɛ sɔɔman 'yiɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ɛn Zozi \"e 'nan -yrɛ 'nan: «I \"bʋɩ bɛ, e wuanla -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mat \"e -yrɛ 'nan: «'Wɩ 'kpa nɛn, maan -tɔa 'nan tʋ -fɔla \"da \"ji bɛ, minnun nɛn o kaa bɛ, o wuanla -kanɔn 'va. 'An \"bʋɩ wuanla -kanɔn 'va \"nyian.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ɛn Zozi \"e -yrɛ 'nan: «'An 'bɔ 'bɛ min wuanla -kanɔn 'va, ɛn mɛɛn 'belidɩ -nɔan \"min lɛ. Min nɛn e yi -tɛala 'an da bɛ, -te e -ka oo, 'belidɩ a -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Min nɛn -a yiɛ a \"man ɛn e yi -tɛra 'an da bɛ, -a san 'ka kaa 'li 'mlɔnmlɔn dɩ. 'I yi -tɛala 'wɩ zɩɛ -a da?» ");
INSERT INTO yreNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ɛn Mat \"e 'nan Zozi lɛ 'nan: «'An 'san 'wɩ 'kpa nɛn. An yi -tɛala \"da 'nan yiɛ cɩ min nɛn Bali -a 'si \"va \"bɛ -a. Bali -pɩ nɛn waa 'vɩ 'e 'cɛn 'nan e -taa 'trɛda bɛ -nyrɛn 'yia.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Zɩ Mat 'wɩ zɩɛ -a 'vɩ bɛ, ɛn e 'li 'e da. E \"blu Mari laabʋ, ɛn yaa 'vɩ -yrɛ 'o \"fli yei 'nan: «'Kʋ 'san bɛ e -ta, e ya \"vale yei 'man ye.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Zɩ Mari 'wɩ zɩɛ -a man bɛ, e wluan \"klɩ, ɛn e -kʋ fɛnan nɛn Zozi cɩ bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Zozi 'ka tian bɔlɛa 'fla yei \"dɩ, e ya tian fɛnan nɛn Mat -kʋ -a 'silɛ -sia 'o cin yɩ 'a bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Zuif 'nɔn nɛn o -kʋ -nyɛnlɛa Mari \"srɔn \"bɛ, zɩ o Mari yɩ e wluan \"klɩ e bɔla bɛ, ɛn o sɔɔnla -a -sru. Waa nrɔn 'o 'ji 'nan e \"ta -ko -wuɔlɛ 'e \"bʋɩ -yrɛ da. ");
INSERT INTO yreNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Zɩ Mari 'bɔla fɛnan nɛn Zozi cɩ bɛ -a -nan, ɛn e Zozi 'bɔ yɩ bɛ, -a -nan nɛn e -tria \"wlu ɛn e 'nan: «'An 'san, \"te 'i 'kɔn 'gʋɛ, \"te 'an \"bʋɩ 'ka 'kalɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Zɩ Zozi Mari 'yɩ 'wuɔnan 'o 'vale Zuif 'nɔn nɛn o -tra -a -sru \"bɛ waa bɛ, -a -wulo -man -ta, ɛn -a 'wɩ 'nan \"man 'kpa tɩglɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yaa laabʋ 'nan: «Nyin zia nɛn kaa 'wʋ?» Ɛn o 'nan -yrɛ 'nan: «'I 'ta -e 'kʋ -kɔɔn 'yiɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Zozi 'wuɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Zɩ Zuif 'nɔn -a -nan 'yɩ bɛ, ɛn o 'nan: «'Ka 'yiɔ, yaa ye \"yi e -ciala \"da.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","-A -nan nɛn Zuif 'nɔn 'bɔ 'va min -mienun \"o 'vɩ 'nan: «E min nɛn -a yiɛ cɩ 'e 'widɩ bɛ -a 'lɛ 'sʋ, ɛn ya'a -kɔlalɛ -a drɛdɩ -a -e Laza 'e vɩlɛ 'e 'ka dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Zozi 'wulo -man -ta, ɛn e -kʋ -yrɛ da. -Wee min -yrɛ bɛ, -kɔlɛ -dan tʋ nɛn -a ci a 'e bʋdɩ bɛ -nyrɛn, ɛn -kɔlɛ nɛn waa -tɔa \"nɛn -a 'lɛ wʋvɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Zozi \"e 'nan: «-Kɔlɛ 'labɛ 'ka 'si \"nɛn.» Ɛn Laza 'bɔ \"blu Mat \"e 'nan: «Minsan, -a -koei bɔa, kɔɔ waa 'wʋ -a -nan yi sinjɛn nɛn 'gʋ.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ɛn Zozi \"e Mat lɛ 'nan: «Maan 'nan 'yiɛ 'nan -te i yi -tɛra 'an da bɛ, i Bali -le -dan ci ye.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tɔɔn ɛn o -kɔlɛ bɛ -a 'si -yrɛ \"nɛn. Zozi 'e yra -tɔ lou ɛn e 'nan: «'An \"tɩ, mɛin muo -fɔa 'nan yian wei 'man. ");
INSERT INTO yreNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","An 'bɔ 'le vɛ bɛ, maan -tɔa 'nan yian wei maan tʋ pɛɛnɔn man. 'Pian minnun nɛn 'an \"srɔn 'gʋɛ, -wee \"wɛan maan 'vɩ 'dʋ -e 'o -tɔ 'nan yiɛ 'an 'pa 'sia.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Zɩ e 'wɩ zɩɛ -a 'vɩ bɛ, ɛn e paan wei 'plɛblɛ 'ji. E 'nan: «Laza, 'i bɔla!» ");
INSERT INTO yreNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ɛn min -kadɩ zɩɛ e 'bɔla te -a cɛin 'lee -a -pɛ a 'e -yrɩdɩ sɔ -a. -A yra a 'e -yrɩdɩ \"nyian. Zozi \"e 'nan -wlɛ -nan: «'Ka sɔnun \"flu \"man -e 'ka 'si \"man!» ");
INSERT INTO yreNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Zuif 'nɔn nɛn o -ta Mari \"srɔn, ɛn o 'wɩ nɛn Zozi -a drɛ bɛ -a -nan 'yɩ bɛ, o \"kaga \"yi -tɛradɩ 'sia Zozi da. ");
INSERT INTO yreNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","'Pian o va min -mienun -kʋ Farizɛn 'nɔn 'va, ɛn 'wɩ nɛn Zozi -a drɛ bɛ, waa 'vɩ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bali -pannɔn 'tanɔn 'lee Farizɛn 'nɔn bɛ, o tin 'banɔn cin 'yɩ, ɛn waa laabʋ -wlɔ 'nan: «-Kaa dra kɔ? Min 'labɛ e ya -cɛ srɔn \"wɩ \"kaga \"drɛnan. ");
INSERT INTO yreNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","-Te e -fʋ 'wɩ zɩɛ -a drɛnan 'nan -ka'a 'wɩ 'silɛ \"da \"man \"dɩɛ, min \"kaga \"yi -tɛala \"da -e Rɔm 'nɔn 'o -cee Bali -pan 'kɔn 'wi, -e 'o -cee 'lɛglɔn 'wi.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","O va min -tʋ nɛn waa laabo Kaifa bɛ, -yɛɛ cɩ 'lɛ 'bɔ zɩɛ -a -ji Bali -pannɔn 'tazan -a. Yaa 'vɩ -wlɛ 'nan: «'Wɩ 'tʋ a bɛ, ka'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","'Ka \"nrɔn 'ka 'ji 'nan, e ya 'cee 'wɩ \"yi \"a -e min -tʋwli 'e min pɛɛnɔn 'ji -ka wʋ, \"tɔgɔ -cee 'lɛglɔn 'ji minnun pɛɛnɔn 'nan 'e 'nyan.» ");
INSERT INTO yreNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","'Wɩ nɛn Kaifa -a 'vɩ bɛ, ya'a 'silɛ -a 'bɔ 'le ci \"nrɔndɩ va dɩ. 'Pian lɛ 'bɔ zɩɛ -a -ji bɛ Bali -pannɔn 'tazan nɛn, -yee \"wɛan Bali ciɩla \"va ɛn e 'wɩ zɩɛ -a 'vɩ 'nan, Zozi -taa \"kalɛ Zuif 'nɔn 'lɛji. ");
INSERT INTO yreNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Wa'a vɩlɛ 'nan e -kaa Zuif 'nɔn 'saza 'lɛji dɩ, 'pian Bali -le 'nɛnnun pɛɛnɔn nɛn 'o fuiladɩ \"man 'trɛda bɛ, o 'lɛji nɛn e -kaa, -e 'o 'tɛ 'e cin da min 'pa 'tʋ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yi 'lein nɛn Kaifa 'wɩ zɩɛ -a 'vɩ \"da \"bɛ, -a nyan nɛn Zuif 'nɔn 'tɔ \"da 'nan 'o Zozi 'tɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","-Yee \"wɛan ya'a \"nyian bɔlɛa 'ji Zude 'lɛglɔn 'ji dɩ. 'Pian e 'si Zude, ɛn e -kʋ 'trɛ 'tʋ da \"bui \"da zia 'fla nɛn waa laabo Efrai bɛ -a da. 'O 'vale 'e -srunɔn 'a o -fʋ 'fla zɩɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Zuif 'nɔn 'le 'si nɔanba -ji \"fɛdi drɛdɩ 'bɔ 'kogo. Ɛn 'lɛglɔn pɛɛnɔn 'ji minnun bɛ, o \"kaga \"kʋ Zeruzalɛm. O -kʋ -nan nun te \"fɛdi 'bɔ 'ka tian bɔlɛ dɩ, 'nan -e 'o 'fli drɛ 'saun Bali 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ɛn o Zozi -wɛɛdɩ 'sia. Zɩ 'o cin 'yɩ Bali -pan 'kɔn 'lɛ \"nɛn \"bɛ, ɛn waa laabʋ 'o cin lɔ 'nan: «Zozi 'ka 'kɔlaman -e 'e 'ta \"fɛdi 'gʋɛ -a da dɩ, \"ka \"nrɔnman 'ka 'ji 'kɔ?» ");
INSERT INTO yreNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fɛ -le \"wɛan nɛn o 'wɩ zɩɛ -a 'vɩ bɛ, Bali -pannɔn 'tanɔn 'lee Farizɛn 'nɔn -a 'vɩ 'nan min nɛn e Zozi 'yɩ bɛ, -a san 'e srɔɛn wʋ \"man 'wlɛ 'dʋ -e 'o 'kun. ");
INSERT INTO yreNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","E -fʋ yi 'shɛɛdʋ -e Zuif 'nɔn 'le 'si nɔanba -ji \"fɛdi 'e bɔ, ɛn Zozi 'kʋ 'fla nɛn waa laabo Betani bɛ -a da. Laza nɛn e -ka ɛn yaa fuʋ bɛ -a fla nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Zɩ e 'bɔla Betani nun bɛ, o fɛnun tɔɛn ɛn waa -nɔn -yrɛ. Mat 'bɛ fɛ zɩɛ -a -pliman. Ɛn minnun nɛn o cɩ 'o -nyrandɩ Zozi \"srɔn fɛnun -sru \"bɛ, Laza a o va. ");
INSERT INTO yreNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tɔɔn Mari -laziglɔ -pɔn -tʋ 'si, yaa -sɛn Zozi 'cɛin -da, ɛn yaa man bʋʋ 'e 'wulo \"jɛ \"a. -A -koei 'kɔn 'bɔ 'ji 'si 'e pɛɛnɔn. -Laziglɔ zɩɛ waa drɛ fɛ -tʋ nɛn waa laabo Nard bɛ -a, e 'ka 'e baadɩ fɛ -tʋ -a dɩ, ɛn -a 'flɛ a. ");
INSERT INTO yreNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","O Zozi -sruzan 'tʋ laabo Zudazi Karioti, -yɛɛ \"ta -daa Zozi 'nɔnlɛ minnun lɛ. Min zɩɛ e 'nan: ");
INSERT INTO yreNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«-Mɛ \"le \"wɛan nɛn wa'a -laziglɔ 'labɛ -a -tanlɛ dɩ? -Kaa taan paan, -a \"lala bɔa -kpi fuba 'shɛɛdʋ, -e -kaa -pli 'yalɛ -tɛnɔn man.» ");
INSERT INTO yreNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","'Yalɛ -tɛnɔn 'le 'wɩ \"cɛɛ \"naan \"man -yee \"wɛan e 'wɩ zɩɛ -a 'vɩ dɩ. 'Pian crinzan nɛn, ɛn -wee \"lala nɛn yaa \"paala bɛ, yaa \"sia \"va te yaa -ble. ");
INSERT INTO yreNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ɛn Zozi \"e 'nan: «'Ka lɩ 'labɛ -a 'tʋɩ flɩɩ, yaan 'man drɛ yi nɛn waan wo bɛ -yee \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tʋ pɛɛnɔn 'a bɛ, te 'yalɛ -tɛnɔn a 'ka 'va. 'Pian 'mɛn vɛ bɛ, ma'an 'fo 'ka 'va tʋ pɛɛnɔn 'a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zuif 'nɔn \"kaga -a 'man 'nan Zozi a Betani, ɛn o -kʋ -nan nun. Wa'a 'kʋlɛ Zozi yɩdɩ 'saza 'le \"wɛan dɩ, 'pian o -kʋ 'nan -e 'o Laza nɛn e -ka ɛn yaa fuʋ bɛ -a yɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","-A -nan nɛn Bali -pannɔn 'tanɔn -a 'pla \"da 'nan 'o Laza -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kɔɔ Laza -le \"wɛan Zuif 'nɔn \"kaga \"a 'sinan o -sru, te o yi -tɛala Zozi da. ");
INSERT INTO yreNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","-A ta tʋ nɛn e cɛɛn bɛ, Zuif 'nɔn \"kaga \"nɛn o -kʋ Zeruzalɛm Zuif 'nɔn 'le 'si nɔanba -ji \"fɛdi da bɛ, zɩ waa 'man 'nan Zozi -a -tanan Zeruzalɛm bɛ, ");
INSERT INTO yreNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","o lo 'lanun 'sia, ɛn o -kʋ Zozi 'silɛ -sia te o plaman. Waa ve 'nan: «-Fɛavɛa o! -Fɛavɛa o! Min nɛn e cɩ -tanan Minsan 'tɔ da bɛ, Bali -le -fɛa 'e 'kɔn -a san man. Izraɛl 'nɔn 'le mingɔnnɛn nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Zozi -aflumun pla 'nɛn 'tʋ 'yɩ, ɛn e -nyran \"da \"le 'wɩ nɛn 'e 'crɛn -tɛdɩ 'e 'cɛn Bali -le 'fluba 'ji bɛ -yee 'wɩ 'zʋ. E ya 'e 'crɛn -tɛdɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Zeruzalɛm minnun, te nyɛn 'e 'kɔn 'ka 'ji dɩ! \"Ka 'yiɔ, 'cee mingɔnnɛn a -tanan 'e -nyrandɩ -aflumun pla 'nɛn da.» ");
INSERT INTO yreNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tʋ zɩɛ -a wlu bɛ, Zozi -srunɔn 'ka 'wɩ nɛn e cɩ 'e 'lɛ sɔɔnan zɩɛ -a -ci manlɛ dɩ. 'Pian tʋ nɛn Zozi 'kʋ 'e \"tɩ \"le mingɔnnɛn trɛ nɛn e \"bia bɛ -a da bɛ, -a -nan nɛn -a -cin -tɔ o ji 'nan 'wɩ nɛn e crɛn -tɛdɩ Zozi 'bɔ 'le 'wɩ 'a bɛ, -yɛɛ 'lɛ sɔɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tʋ nɛn te Laza -ka e ya -yrɛ -ji -e Zozi 'e fuʋ bɛ, minnun pɛɛnɔn nɛn waa -nan 'yɩ bɛ, o Zozi 'le 'wɩ 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ɛn minnun \"kaga \"ta Zozi 'silɛ -sia 'lɛbo \"fɔ wɩ nɛn yaa drɛ waa 'man bɛ -yee \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","-A -nan nɛn Farizɛn 'nɔn -a vɩdɩ 'sia 'o cin lɛ 'nan: «Kaa ye, ka'a 'kɔlaman fɛ -tʋ drɛdɩ -a \"nyian dɩ. \"Ka 'yiɔ, 'trɛda minnun pɛɛnɔn -sɛn -a -sru.» ");
INSERT INTO yreNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Minnun nɛn o -kʋ Bali bɔlɛ \"fɛdi da Zeruzalɛm bɛ, minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ o -mie a o va. ");
INSERT INTO yreNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","O 'nɔn zɩɛ, o pli Filipʋ man. Filipʋ bɛ, Bɛzaida min nɛn Galile 'lɛglɔn 'ji. Ɛn o kɔala \"man -a vɩdɩ -a 'nan: «'Kʋ 'san, kʋ ya \"vale 'kʋ Zozi ye.» ");
INSERT INTO yreNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipʋ -kʋ -a vɩlɛ Andre lɛ, ɛn Andre 'lee Filipʋ -kʋ -a vɩlɛ Zozi lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «Tʋ nɛn 'an 'bɔ Blamin -pɩ 'an -ko 'an \"tɩ \"le mingɔnnɛn trɛ nɛn e \"bia bɛ -a da bɛ e 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, -te wa'a 'saa 'wlɛ 'fɔlɛ 'trɛ 'ji -e 'e fʋlɩ \"ji \"dɩɛ, e -fo 'e -tʋwli, yaa 'bɔa \"da \"dɩ. 'Pian -te e fʋlɩ \"ji \"bɛ, -a -kɔn bɔa \"da -e 'e 'sɛn \"da \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Min nɛn -yee 'belidɩ wɩ cɩ \"man \"bʋʋ \"bɛ, e -taa 'yee 'belidɩ 'bɔ srɛlɛ, 'pian min nɛn 'e 'pɛ 'si 'trɛda wɩnun -sru \"bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ e ya -a san -le vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","-Te min a \"va 'nan 'an drɛ 'e 'san -a bɛ, 'e -sɔɔnla 'an -sru. -Te e sɔɔnla 'an -sru \"bɛ, fɛnan nɛn an cɩ bɛ, 'an 'suzan zɩɛ e -kɔan \"nan \"nyian. Min nɛn yaan \"sua bɛ, 'an \"tɩ -a 'tɔ dra -dan. ");
INSERT INTO yreNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","'Bɛ nɛn 'gʋɛ, 'an 'ci baa 'ji. -Mɛ \"wɩ nɛn an -taa -a vɩlɛ 'an \"tɩ \"lɛ? Maan ve 'an \"tɩ \"lɛ 'nan, 'e yra yɩdɩ 'labɛ -a 'si 'an man -kɔɔbli. -Cɛjɛ, ma'an 'wɩ zɩɛ -a ve dɩ, kɔɔ -yee \"wɛan nɛn an -ta 'trɛda. ");
INSERT INTO yreNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Maan ve 'pian 'nan: ‹'An \"tɩ, 'i drɛ -e minnun 'o -tɔ 'nan 'i 'tɔ a -dan.› » 'Nun tɔɔn, ɛn wei -tʋ wɩɩ laji. E 'nan: «Maan -ci kɔɔn 'nan 'an 'tɔ a -dan 'va, ɛn maan dra \"nyian -dan.» ");
INSERT INTO yreNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Min \"kaga \"nɛn fɛ zɩɛ -a -nan, ɛn o 'wɩ zɩɛ -a 'man bɛ, o 'nan: «Laa -paan 'bɛ klun.» Ɛn o -mienun \"o 'vɩ 'nan: «Bali -le 'pasianɔn nɛn laji bɛ, -a -tʋ 'bɛ 'wɩ tin 'ba -yrɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ɛn Zozi 'bɔ -a 'vɩ -wlɛ 'nan: «Wei nɛn e wɩɩ 'gʋɛ, 'mɛn \"wɛan \"cɛɛ e wɩɩ dɩ, 'pian 'ka lɛ nɛn e 'wɩ tin 'ba. ");
INSERT INTO yreNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","'Bɛ nɛn 'gʋɛ, 'trɛdanɔn 'le tin 'badɩ bɛ e 'bɔ. Satan nɛn e 'trɛ 'gʋɛ -a \"paala bɛ -a -pin tʋ 'bɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","'Mɛn vɛ bɛ, tʋ nɛn minnun 'an \"paa yiba \"plan da -e 'an 'si 'trɛda bɛ, -te -a tʋ 'bɔ bɛ, maan dra -e min pɛɛnɔn 'o yi -tɛra 'an da.» ");
INSERT INTO yreNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","-Te Zozi 'wɩ zɩɛ -a 'vɩ bɛ, zɩ e -taa \"kalɛ bɛ -a -nan wɩ nɛn yaa 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ɛn minnun -a 'vɩ -yrɛ 'nan: «Kʋa 'man -pei 'fluba 'ji 'nan, min nɛn Bali -a 'si \"va \"bɛ, ya'a kaa 'li \"fo \"dɩ. -Mɛ \"le \"wɛan nɛn yia ve 'nan: ‹Yi nɛn o Blamin -pɩ \"paa yiba \"plan da? Blamin -pɩ zɩɛ -tɩ nɛn?› » ");
INSERT INTO yreNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ɛn Zozi \"e -wlɛ 'nan: «'Tɛ 'san a tian 'ka 'va tʋ \"wɛnnɛn 'a. 'Ka 'ta wʋ te -a 'san a tian 'ka 'va, \"tɔgɔ klun 'e bɔ 'ka man kligli. Min nɛn e 'ta wo klun va bɛ, fɛnan nɛn e cɩ -kʋnan bɛ, ya'a tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","'Ka yi -tɛra 'tɛ 'san da te e ya tian 'ka 'va, -e 'ka 'kɔn minnun nɛn o ya 'tɛ 'san da bɛ waa.» Zɩ Zozi 'wɩ zɩɛ -a 'vɩ bɛ, e 'si o \"srɔn, ɛn e yɔɔ -wlɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Zozi 'lɛbo \"fɔ wɩ \"kaga drɛ Zuif 'nɔn yiɛ man, 'pian wa'a yi -tɛlɛa Zozi da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","E drɛ zɩɛ 'nan -e 'wɩ nɛn Bali 'lewei vɩzan Ezai -a 'vɩ bɛ 'e 'lɛ sɔɔ. Yaa 'vɩ 'nan: «Minsan, -tɩɛ yi -tɛra 'wɩnun nɛn kʋa 'vɩ bɛ -a da? Ɛn -tɩ lɛ nɛn Minsan 'yee -pɛ 'plɛ 'ci kɔɔn?» ");
INSERT INTO yreNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","'Wɩ nɛn -yee \"wɛan wa'a 'kɔlaman -e 'o yi -tɛra 'wɩ da dɩɛ, Ezai -a 'vɩ \"nyian. Yaa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Bali o yiɛ 'wi, -e 'o vɩlɛ 'o fɛnan 'yɩ dɩ, ɛn e o -pɔan \"da -tɔ 'plɛblɛ, -e 'o vɩlɛ 'o 'wɩ 'wɩ man dɩ. E drɛ zɩɛ 'nan \"tɔgɔ 'o -sɔɔnla 'e -sru, -e 'e o 'si 'wɩ 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Zozi 'le 'wɩ nɛn Ezai -a 'vɩ. E Zozi 'le -dan ci 'yɩ, -yee \"wɛan e 'wɩ zɩɛ -a 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Zuif 'nɔn 'tanɔn 'bɔ bɛ, o \"kaga \"yi -tɛala Zozi da. 'Pian Farizɛn 'nɔn 'le \"wɛan o 'ka \"vale 'o ve 'wein dɩ, \"tɔgɔ 'o o -pin cin yɩ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","-Te minnun o 'tɔ \"yi \"ve bɛ, waa ye \"yi e \"mlian Bali -le o 'tɔ \"yi \"vɩdɩ da. ");
INSERT INTO yreNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Zozi paan 'nan: «Min nɛn e yi -tɛala 'an da bɛ, 'an 'saza da \"cɛɛ e yi -tɛala dɩ, 'pian e yi -tɛala \"nyian min nɛn yaan 'pa 'sia bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Min nɛn yaan 'yɩ bɛ, te e min nɛn yaan 'pa 'sia bɛ -a 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mɛɛn cɩ 'tɛ 'san -a, an -ta 'trɛda 'nan -e min nɛn e yi -tɛra 'an da bɛ, -a san 'e vɩlɛ 'e 'fʋ klun va -trilii dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","-Te min 'an wei 'man, ɛn -a san 'ka 'ta wʋlɛa \"da \"dɩɛ, mɛɛn \"cɛɛ tin -tɛa -a san da dɩ. -Yɛɛ cɩ 'nan an -ta 'trɛda 'nan -e 'an 'trɛdanɔn 'si 'wɩ 'ji, ma'an 'talɛ 'nan -e 'an tin -tɛ 'trɛdanɔn da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Min nɛn yaan tuʋ 'e 'pɛla koda, ɛn ya'a 'an wei 'silɛa 'wɩ 'a dɩɛ, -a san -le 'wɩ tin 'bazan a. 'An wei nɛn maan 'vɩ bɛ, -yɛɛ tin -tɛa -a san da yi -fɔla \"da \"ji. ");
INSERT INTO yreNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","'Wɩ nɛn maan ve bɛ, ya'a 'sia 'an 'bɔ 'va dɩ, 'pian 'an \"tɩ \"nɛn yaan 'pa 'sia bɛ, -yɛɛ 'wɩ nɛn kɔ 'an vɩ bɛ -a 'pa 'an 'le. ");
INSERT INTO yreNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ɛn maan -tɔa 'nan 'an \"tɩ \"le 'wɩ nɛn yaa 'vɩ bɛ, e 'belidɩ nɛn ya'a 'nyaan dɩɛ -a -nɔan \"min lɛ. 'Wɩnun nɛn maan ve 'gʋɛ, zɩ 'an \"tɩ -a 'vɩ 'mɛn bɛ -a da nɛn maan ve.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","E -fʋ yi -tʋ -e Zuif 'nɔn 'le 'si nɔanba -ji \"fɛdi yi 'e bɔ. Zozi -a -tɔa 'nan 'yee tʋ 'bɔ -e 'e 'si 'trɛ 'gʋɛ -a da -e 'e 'kʋ 'e \"tɩ \"srɔn. Minnun nɛn o yi -tɛra Zozi da 'trɛda bɛ, e o 'yɩ \"yi, e o 'yɩ \"yi \"trilii, ɛn yaa 'le 'sran. ");
INSERT INTO yreNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yi zɩɛ -a funninmlan nɛn Zozi 'lee 'e -srunɔn a fɛnun -blɩnan 'e cin va. Tʋ zɩɛ -a man bɛ, te Satan ci \"nrɔndɩ 'pla Simɔn -pɩ Zudazi Karioti man. Yaa -cin -trɔa \"ji 'nan 'e Zozi 'nɔn 'e 'nanmannɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Zozi -a -tɔa 'nan 'e \"sia Bali va ɛn 'e lia 'e da Bali va. Yaa -tɔa \"nyian 'nan 'e \"tɩ 'e 'tɔ fɛ pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","E wluan fɛnun nɛn o cɩ -a -blɩnan bɛ -a -sru, e 'yee sɔ 'si 'e da, ɛn e sɔ -tʋ 'si yaa -trɔa 'e -tiɛn \"da. ");
INSERT INTO yreNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","E 'yi 'sɛn 'kpɔngbo 'tʋ -ji, ɛn 'e -srunɔn 'cɛin -man \"foedɩ 'sia, te yaa man bʋʋman sɔ nɛn -a -tiɛn \"da bɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Zɩ e 'bɔ Simɔn Piɛri da bɛ, ɛn 'bɛ laabʋ -yrɔ 'nan: «Minsan, yiɛ 'an 'cɛin -man \"foeman?» ");
INSERT INTO yreNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «'Wɩ nɛn an cɩ -a drɛnan 'gʋɛ yi'a -ci maan tʋ 'gʋɛ -a dɩ, 'pian yia -ci maan 'e 'fɔla \"da.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ɛn Piɛri \"e -yrɛ 'nan: «Maan 'we \"man \"dɩ, yi'a 'li 'an 'cɛin -man foeman \"fo \"dɩ.» Zozi \"e -yrɛ 'nan: «-Te ma'an 'i 'cɛin -man \"foelɛ dɩɛ, te i 'ka 'mɛn vɛ -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","-A -nan nɛn Simɔn Piɛri \"e Zozi lɛ 'nan: «Te 'yian 'cɛin 'saza 'man \"foe dɩ. Minsan, 'an 'pɛ 'lee 'an 'wulo nɛn 'gʋ, 'i o man \"foe \"nyian.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ɛn Zozi \"e 'nan -yrɛ 'nan: «Min nɛn 'e sru 'va bɛ, -a 'kɔlɛ pɛɛnɔn da a 'saun. -A cɛin -man 'saza nɛn yaa \"foeman. Ka ya 'saun, 'pian 'ka pɛɛnɔn \"cɛɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Min nɛn e \"ta -daa Zozi 'nɔnlɛ 'e 'nanmannɔn lɛ bɛ, Zozi -a -tɔa, -yee \"wɛan yaa 'vɩ 'nan, o pɛɛnɔn 'ka 'saun dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Zɩ Zozi cɛɛn 'e -srunɔn 'cɛin -man \"foedɩ man bɛ, ɛn e 'yee sɔ 'wʋ \"nyian 'e da. E -nyran fɛnun -sru 'e \"pa 'ji, ɛn yaa laabʋ -wlɔ 'nan: «'Wɩ nɛn maan drɛ 'cɛɛ 'gʋɛ, kaa -ci 'man? ");
INSERT INTO yreNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kaan laabo Bali -le 'wɩ \"paazan, ɛn kaan laabo Minsan. Kaa ve 'e 'nɔan da, kɔɔ an ya -a. ");
INSERT INTO yreNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","'An 'bɔ 'bɛ cɩ Bali -le 'wɩ \"paazan -a, ɛn mɛɛn cɩ Minsan -a, -yee \"wɛan -te an 'ka 'cɛin -man foe bɛ, 'ka cin cɛin -man \"foe \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","'Wɩ -kɔɔn \"man wɩ nɛn man drɛ 'cɛɛ, 'dʋ -e 'ka drɛ \"le zɩ maan drɛ 'cɛɛ bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min 'suzan -dan 'ka 'mlian 'e 'tazan da dɩ. Ɛn 'pasiazan -dan 'ka 'mlian min nɛn yaa 'pa 'sia bɛ -a da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","'Wɩnun zɩɛ kaa -tɔa 'siɛn. -Te ka 'ta 'wʋla \"da \"bɛ, Bali -le -fɛa a 'ka man. ");
INSERT INTO yreNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","'Ka pɛɛnɔn \"cɛɛ maan ve dɩ. Minnun nɛn an o 'si \"va \"bɛ, an o -tɔa, 'pian 'wɩ nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ, e ya \"le 'e 'lɛ sɔɔ. E ya 'e 'crɛn -tɛdɩ 'nan: ‹Min nɛn 'kʋ fɛ blɩ a 'e cin va bɛ, e drɛ 'an 'nanmanzan 'a.› ");
INSERT INTO yreNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Maan ve 'cɛɛ 'vaa -e -a tʋ 'e bɔ. Tʋ nɛn 'wɩnun zɩɛ e dra \"man \"bɛ, -e min nɛn an cɩ -a bɛ 'ka -tɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min nɛn maan 'pa 'sia bɛ, -te min nɛn yaa -pɛ 'kun bɛ, 'an 'bɔ nɛn -a san 'an 'pɛ 'kun. Ɛn min nɛn yaan 'pɛ 'kun bɛ, te min nɛn yaan 'pa 'sia bɛ, -a 'bɔ nɛn -a san -a -pɛ 'kun.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Zɩ Zozi 'wɩ zɩɛ -a 'vɩ bɛ, ɛn -a ci baa 'ji. -A -nan nɛn yaa 'vɩ -wlɛ 'wein 'nan: «Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min -tʋ a 'ka yei, -yɛɛ 'an -nɔan 'an 'nanmannɔn lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ɛn Zozi -srunɔn 'o yiɛ 'tɔ 'o cin yra, kɔɔ min nɛn e cɩ -yee 'wɩ vɩnan bɛ, wa'a san tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Zozi -sruzan 'tʋ nɛn Zozi -a ye \"yi 'kpa tɩglɩ bɛ, -yɛɛ cɩ 'e -nyrandɩ Zozi 'bɔ \"srɔn \"kogo. ");
INSERT INTO yreNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ɛn Simɔn Piɛri 'wɩ 'tʋ drɛ -yrɛ 'nan 'e laabʋ Zozi 'lɔ 'nan -tɩ nɛn Zozi 'bɔ -a ve. ");
INSERT INTO yreNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Zozi -sruzan zɩɛ, e tɛɛn \"ji Zozi kugu da, ɛn yaa laabʋ Zozi 'lɔ 'nan: «Minsan, -tɩ nɛn?» ");
INSERT INTO yreNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Zozi \"e -yrɛ 'nan: «Min nɛn an 'kpɔun ponɛn 'fɔdɩ -nɔn -yrɛ \"bɛ, te -a san nɛn.» -A -nan nɛn Zozi 'kpɔun ponɛn 'si, yaa 'fɔ, ɛn yaa -nɔn Simɔn -pɩ Zudazi Karioti lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zɩ Zudazi 'kpɔun ponɛn zɩɛ -a 'si bɛ, ɛn Satan -fɔ -a -sru. Zozi \"e -yrɛ 'nan: «'Wɩ nɛn i \"ta -a dra bɛ, 'i drɛ tada.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Minnun nɛn o cɩ 'o -nyrandɩ waa fɛnun -sru \"bɛ, o -tʋ 'ka 'wɩ nɛn Zozi 'wɩ zɩɛ -a 'vɩ \"man \"bɛ -a -ci manlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Zudazi \"kuan 'wee \"lala man, -yee \"wɛan min -mienun -a nrɔn 'o 'ji 'nan, Zozi -a 'vɩ -yrɛ 'nan 'e 'kʋ fɛ nɛn e klɩ 'o man \"fɛdi fɛ -a bɛ -a 'lɔ. -Te 'bɛ \"cɛɛ dɩ 'nan 'e 'kʋ fɛ -tʋ -nɔn 'yalɛ -tɛnɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Zudazi 'kpɔun ponɛn zɩɛ -a 'si, nun tɔɔn ɛn e 'bɔla bei \"nyiandʋ klun va. ");
INSERT INTO yreNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zɩ Zudazi bɔla bɛ, ɛn Zozi \"e 'nan: «'Bɛ nɛn 'gʋɛ, Blamin -pɩ 'tɔ drɛ -dan \"mɛn, ɛn minnun Bali -le -dan ci ye Blamin -pɩ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ɛn -te minnun Bali -le -dan ci 'yɩ Blamin -pɩ -le \"wɛan bɛ, -e Bali 'bɔ 'e 'pɩ 'tɔ drɛ -dan 'e 'bɔ 'a. -A -nan 'ka \"nyian mɔan dɩ -e 'e 'wɩ zɩɛ -a drɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","'Mɛn 'nɛnnun, an ya tian ka yei tʋ \"wɛnnɛn 'a, 'pian ka -taa 'an -wɛɛlɛ. 'Wɩ nɛn maan 'vɩ Zuif 'nɔn lɛ bɛ, an \"cee \"ve \"nyian. Ka'a 'kɔlaman -e 'ka 'kʋ fɛnan nɛn an \"ta -ko bɛ -a -nan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","An -pei -trɛ -tɔa 'cɛɛ, -nyrɛn 'nan 'ka cin yɩ \"yi \"le zɩ an 'ka 'yɩ \"yi \"bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","-Te 'ka cin ye \"yi \"bɛ, minnun pɛɛnɔn -taa -a -tɔlɛ 'nan ka ya 'an -srunɔn 'a.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simɔn Piɛri -a laabʋ Zozi 'lɔ 'nan: «Minsan, i \"ta -ko nyin zia?» Ɛn Zozi \"e -yrɛ 'nan: «Fɛnan nɛn an \"ta -ko tʋ 'gʋɛ -a bɛ, yi'a 'kɔlaman -e 'i -tra 'an -sru \"dɩ, 'pian \"bɛ -sru, i -taa -sɔɔnlɛa 'an -sru.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ɛn Piɛri -a laabʋ -yrɔ \"nyian 'nan: «Minsan, -mɛ \"le \"wɛan ma'an 'kɔlaman -e 'an 'kʋla 'i -sru tʋ 'gʋɛ -a dɩ? 'An 'man a 'e wʋʋdɩ -e 'an 'ka 'yie \"wɛan.» ");
INSERT INTO yreNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ɛn Zozi \"e 'nan Piɛri lɛ 'nan: «Yia ve 'nan, 'i 'man a 'e wʋʋdɩ -e 'i 'ka 'mɛn \"wɛan? 'Pian 'an 'bɔ \"an \"ve 'yiɛ 'wɩ tɩglɩ 'a 'nan, yia ve 'e 'pa -a yaaga 'nan, yi'an 'tɔa dɩ, 'vaa -e mannɛn tɛdɛ 'e 'wɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Zozi \"e 'nan 'e -srunɔn lɛ 'nan: «Te 'ka 'ci 'e baa -ji 'mlɔnmlɔn dɩ! 'Ka yi -tɛra Bali da, ɛn 'ka yi -tɛra \"nyian 'an da! ");
INSERT INTO yreNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","'An \"tɩ \"le \"kɔnnɛn \"bɛ, -nyrannan \"kaga \"a -nan. An \"ta -ko 'ka -nyrannan \"man drɛlɛ. \"Te -nyrannan 'ka 'nan dɩɛ, \"te ma'an vɩlɛ 'cɛɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","-Yee \"wɛan -te an -kʋ ɛn an 'ka -nyrannan \"man drɛ bɛ, an -taa 'ka 'silɛ -e -kaa kʋ -nan nun. -Kaa -nyrannan -kɔan 'e cin va. ");
INSERT INTO yreNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Fɛ nɛn an \"ta -ko -nan 'gʋɛ, -kaa -nan si -tɔa.» ");
INSERT INTO yreNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ɛn Toma \"e -yrɛ 'nan: «Minsan, fɛ nɛn i \"ta -ko -nan bɛ, kʋ'a -nan si tɔa dɩ. Kʋa dra 'kɔ -e 'kʋ -nan si -tɔ?» ");
INSERT INTO yreNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Zozi \"e -yrɛ 'nan: «Mɛɛn cɩ -si -a, ɛn mɛɛn cɩ 'wɩ tɩglɩ 'a, ɛn mɛɛn cɩ 'belidɩ -a. Min 'ka 'kɔlaman -e 'e 'kʋ 'an \"tɩ 'va, te ya'a 'ciɩlɛa 'an 'va dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Min nɛn an cɩ -a bɛ kaa -tɔ, -yee \"wɛan kaan \"tɩ -tɔa. 'Bɛ nɛn 'gʋɛ kaan \"tɩ 'yɩ, ɛn zɩ e cɩ bɛ, kaa -tɔdɩ 'sia.» ");
INSERT INTO yreNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ɛn Filipʋ \"e 'si \"va 'nan: «Minsan, 'i \"tɩ 'bɔ bɛ, 'i -kɔɔn 'kʋɛ, te 'kʋ 'ci 'sɔ.» ");
INSERT INTO yreNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Zozi \"e -yrɛ 'nan: «Filipʋ, an 'mɔn 'ka yei \"kaga, ɛn yia tian 'an 'tɔlɛ dʋʋ? Min nɛn yaan 'yɩ bɛ, te -a san 'an \"tɩ 'yɩ. -Mɛ \"le \"wɛan yia ve 'nan 'an \"tɩ -kɔɔn 'cɛɛ? ");
INSERT INTO yreNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yi'a yi 'tɛala \"da 'nan 'kʋ 'vale 'an \"tɩ \"a kʋ ya min -tʋwli \"a dʋʋ? 'Wɩnun nɛn maan ve 'cɛɛ 'gʋɛ, ya'a 'sia 'an 'bɔ 'va dɩ. 'An \"tɩ 'bɔ nɛn kʋ ya -a min -tʋwli \"bɛ, -yɛɛ -ciala 'an 'va -e 'e 'yee 'wɩnun 'lɛ sɔɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","'Ka yi -tɛra \"da 'nan 'kʋ 'vale 'an \"tɩ \"a kʋ ya min -tʋwli \"a. Ɛn -te ka'a yi 'tɛala 'an da 'an 'lewei 'le \"wɛan dɩɛ, 'ka yi -tɛra 'an da, wɩnun nɛn maan dra bɛ -yee \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, min nɛn e yi -tɛra 'an da bɛ, 'wɩnun nɛn maan dra 'gʋɛ, -a san \"e \"dra \"nyian. -A -san -taa 'wɩ -dandan drɛlɛ e \"mlian 'mɛn vɛ da, kɔɔ an \"ta -ko 'an \"tɩ 'va. ");
INSERT INTO yreNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","'Wɩ pɛɛnɔn nɛn kaa laabo 'an \"tɩ 'lɔ te ka ya 'mɛn vɛ -a bɛ, maan dra, 'dʋ -e 'an \"tɩ 'tɔ 'e drɛ -dan 'mɛn \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","-Te ka 'wɩ 'tʋ laabʋ 'an 'lɔ te ka ya 'mɛn vɛ -a bɛ, maan dra.» ");
INSERT INTO yreNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«-Te kaan ye \"yi \"bɛ, 'an wei da nɛn 'ka 'ta wʋla. ");
INSERT INTO yreNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tɔɔn 'an \"tɩ trʋ \"baa -e 'e 'ka 'pa \"vazan 'pa 'sia 'cɛɛ, -yɛɛ fo 'ka 'va 'li 'trilii. ");
INSERT INTO yreNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'Ka 'pa \"vazan zɩɛ Bali lei nɛn 'e 'wɩ tɩglɩ -kɔɔnman min lɛ bɛ -nyrɛn. Minnun nɛn 'trɛda 'wɩnun 'gʋɛ -nyrɛn waa ye \"yi \"bɛ, ya'a 'kɔlaman -e 'e drɛ -wee vɛ -a dɩ, kɔɔ o yra 'ka \"da 'zia dɩ, ɛn wa'a -tɔlɛ dɩ. 'Pian 'cee vɛ bɛ, \"ka \"tɔ, kɔɔ e ya 'ka 'va, ɛn 'ka -taa \"drɛlɛ waa min -tʋwli \"a. ");
INSERT INTO yreNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma'an 'ka 'tʋe 'ka 'saza \"le 'nɛn nɛn -a \"tɩ 'lee -a \"bʋ \"ka 'e da bɛ -yee 'wɩ 'zʋ dɩ. An lia 'an da 'ka 'va. ");
INSERT INTO yreNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","E -fʋ tʋ \"wɛnnɛn 'a, te 'trɛda minnun 'ka \"nyian 'an 'ye dɩ. 'Pian 'cee vɛ bɛ, ka -taa -a yɩlɛ 'nan 'an yiɛ a \"man \"nyian 'e \"pa 'ji. Ɛn \"cee yiɛ 'fo \"man \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tʋ zɩɛ -a man nɛn kaa -tɔa 'nan 'an \"tɩ 'bɔ bɛ, kʋ ya -a min -tʋwli. Ɛn 'ka 'bɔ 'lee 'an 'bɔ bɛ, -kaa ya min -tʋwli \"a. ");
INSERT INTO yreNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Min nɛn 'mɛn -pei -tɔ wɩnun -cin a \"ji, te e 'ta 'wʋla \"da \"bɛ, -a san 'bɛ 'an ye \"yi. Min nɛn yaan ye \"yi \"bɛ, 'an \"tɩ -taa -a san yɩlɛ \"yi, 'an 'bɔ an -taa -a san yɩlɛ \"yi \"nyian, ɛn 'an 'fli -kɔɔnman -yrɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ɛn -a -sruzan 'tʋ nɛn \"nyian waa laabo Zudazi, te Zudazi Karioti \"cɛɛ 'bɛ 'a dɩɛ, 'bɛ laabʋ -yrɔ 'nan: «Minsan, -mɛ \"le \"wɛan 'i 'fli -kɔɔnman 'kʋɛ, ɛn yi'a 'i 'fli kɔɔnman 'trɛda minnun lɛ dɩ?» ");
INSERT INTO yreNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «-Te min 'an ye \"yi te e 'ta 'wʋla 'an wei da bɛ, -a -nan nɛn 'an \"tɩ -taa -a san yɩlɛ \"yi. Tɔɔn 'kʋ 'vale 'an \"tɩ \"a bɛ, kʋ -taa \"talɛ -a san va -e 'kʋ -nyran \"va. ");
INSERT INTO yreNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","'Pian min nɛn ya'an ye \"yi \"dɩɛ, ya'a 'ta wʋla 'an wei da dɩ. Wei nɛn ka cɩ -a mannan 'gʋɛ, ya'a 'sia 'an 'va dɩ, 'pian 'an \"tɩ 'nɛn yaan 'pa 'sia bɛ -a va nɛn e \"sia. ");
INSERT INTO yreNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","'Wɩnun 'gʋɛ maan tin \"baa 'cɛɛ te an ya tian 'ka yei. ");
INSERT INTO yreNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","'An \"tɩ -taa \"talɛ 'ka 'pa \"vazan 'a 'an 'lɛji, Bali lei 'saun nɛn. -Yɛɛ 'wɩ pɛɛnɔn nɛn maan 'vɩ bɛ -a -cin -tɔa 'ka 'ji, ɛn -yɛɛ -ci \"sia 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","'Ka 'fʋ -trɔɔ, 'mɛn -fʋdɩ -trɔɔ bɛ, maan -nɔn 'cɛɛ. Ma'an -fʋdɩ -trɔɔ ve 'ka 'man \"le 'nan 'trɛda minnun -a ve 'ka man bɛ -yee 'wɩ 'zʋ dɩ. Te nyɛn 'e 'ka 'cɛn dɩ, ɛn te \"klan 'e 'ka 'tɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Maan 'vɩ 'cɛɛ 'nan, an \"ta -ko -e 'an li 'an da \"nyian 'ka 'va. \"Te kaan ye \"yi \"bɛ, \"te 'ka 'ci \"nranman, kɔɔ an \"ta -ko 'an \"tɩ 'va, ɛn 'an \"tɩ -dan \"mlian 'an da. ");
INSERT INTO yreNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","'Wɩnun zɩɛ, maan 'vɩ 'cɛɛ 'vaa -e -a drɛ tʋ 'e bɔ. 'Dʋ -e \"yɛɛ vɩnan 'e drɛ bɛ, -e 'ka yi -tɛra 'an da. ");
INSERT INTO yreNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","'Mɛn tʋ 'ka \"nyian \"kaga -e 'an 'wɩ tin 'ba 'cɛɛ dɩ, kɔɔ Satan nɛn e 'trɛ 'gʋɛ -a \"paala bɛ, e ya -tanan. -Yee 'plɛblɛ 'ka 'an da dɩ, ");
INSERT INTO yreNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","'pian -e 'trɛda minnun 'o -tɔ 'nan, 'an \"tɩ ye \"yi \"bɛ, 'wɩ nɛn yaa 'vɩ 'mɛn bɛ an 'ta 'wʋla \"da. 'Ka 'wluan lou, -kaa kʋ!» ");
INSERT INTO yreNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yaa vɩdɩ 'sia -wlɛ 'nan: «Mɛɛn cɩ rɛzɛn yiba 'kpa -a, ɛn 'an \"tɩ 'bɛ cɩ min nɛn e rɛzɛn 'bɔ 'ta bɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","'An pɛ 'nɛnnun nɛn wa'a 'baa dɩɛ, 'an \"tɩ o \"cɛan, ɛn 'an pɛ 'nɛnnun nɛn o baa \"bɛ, 'an \"tɩ \"o man dra 'dʋ -e 'o ba 'kpa \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Cɛɛ cɩ 'an pɛ 'nɛnnun nɛn o -taa \"balɛ \"kaga \"bɛ waa, kɔɔ 'wɩ nɛn maan paa 'ka 'ji 'gʋɛ, e 'ka drɛ 'saun 'va. ");
INSERT INTO yreNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","'Ka 'fʋ 'ka lɛadɩ 'an man te -kaa ya min -tʋwli \"a. Yiba \"pɛ 'ka 'kɔlaman -e 'e ba 'e 'saza, te e 'ka 'e lɛadɩ yiba 'bɔ man dɩ. -A -tʋwli \"nɛn \"nyian 'cee vɛ -a, -te ka'a 'fʋlɛ 'ka lɛadɩ 'an man dɩɛ, ka'a 'kɔlaman 'wɩ 'tʋ drɛdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mɛɛn cɩ rɛzɛn yiba \"a, ɛn cɛɛ cɩ 'an pɛ 'nɛnnun -a. Min nɛn e -fʋ 'e lɛadɩ 'an man bɛ, kʋ 'vale -a kʋ dra min -tʋwli \"a. -A san -kɔan \"le yiba \"pɛ nɛn e baa \"kaga \"bɛ -yee 'wɩ 'zʋ. -Yɛɛ cɩ 'nan -te ma'an 'palɛ 'ka 'va dɩɛ, ka'a 'kɔlaman 'wɩ 'tʋ drɛdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Min nɛn ya'a -fʋlɛ 'e lɛadɩ 'an man dɩɛ, waa -tua bei. -A san a \"le 'nan yiba \"pɛ nɛn waa cɛɛn ɛn waa tuʋ bei \"bɛ -yee 'wɩ 'zʋ. E -kaa, waa \"siala -e 'o -fɔ 'tɛa. ");
INSERT INTO yreNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","-Te ka -fʋ 'ka lɛadɩ 'an man, ɛn 'an wei -cin -fɔla 'ka 'ji bɛ, fɛ oo fɛ nɛn ka cɩ \"va \"bɛ, 'ka laabʋ 'an \"tɩ 'lɔ, yaa -nɔan 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","-Te ka ya \"le 'nan yiba \"pɛ nɛn e baa \"kaga \"bɛ -yee 'wɩ 'zʋ bɛ, 'an \"tɩ 'tɔ dra -dan. 'Wɩ zɩɛ -yɛɛ -kɔɔnman 'nan ka ya 'an -srunɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Zɩ 'an \"tɩ 'an ye \"yi \"bɛ, -a da nɛn an 'ka ye \"yi. 'Ka 'fʋ 'ka lɛadɩ 'an man -e 'an 'ka yɩ \"yi. ");
INSERT INTO yreNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","-Te ka 'ta 'wʋla 'mɛn -pei -tɔ wɩnun da bɛ, an 'ka ye \"yi. An 'bɔ \"nyian, \"an 'ta wʋla 'an \"tɩ \"le -pei -tɔ wɩnun da ɛn yaan 'yɩ \"yi. ");
INSERT INTO yreNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","'Wɩnun zɩɛ maan 'vɩ 'cɛɛ 'nan -e ci \"nrandɩ nɛn an 'lɔ 'gʋɛ -e 'kɔn \"nyian \"cee 'lɔ. -E 'cee vɛ 'e 'ciɩla \"da \"fo. ");
INSERT INTO yreNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","'Mɛn -pei -tɔ wɩ nɛn 'nan, 'ka cin yɩ \"yi \"le zɩ an 'ka ye \"yi \"bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yɩdɩ \"yi \"nɛn e \"mlian yɩdɩ \"yi pɛɛnɔn da bɛ, -nyrɛn 'nan min 'e 'wɩ \"man -e 'e 'ka 'e beenun \"pa 'ji. ");
INSERT INTO yreNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","-Te ka 'ta 'wʋla 'wɩ nɛn maan 'vɩ 'cɛɛ bɛ -a da bɛ, te ka ya 'an beenun -a. ");
INSERT INTO yreNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma'an \"nyian 'ka laabo 'an 'sunɔn dɩ, 'pian an 'ka laabo 'an beenun. Min 'suzan 'ka 'e 'tazan drɛ wɩ tɔa dɩ, 'pian 'wɩ pɛɛnɔn nɛn maan 'man 'an \"tɩ \"da bɛ, maan 'vɩ 'cɛɛ, -yee \"wɛan an 'ka laabo 'an beenun. ");
INSERT INTO yreNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","'Ka 'bɔ \"cɛɛ 'an 'si \"va ɛn ka sɔɔnla 'an -sru \"dɩ, 'pian mɛɛn 'ka 'si \"va. An 'ka 'si \"va 'nan -e 'ka 'nyranman 'pa, -e 'ka drɛ yiba \"pɛ nɛn e baa \"kaga \"bɛ -a. 'Cee 'nyranman \"nɛn 'ka 'fo 'e \"tun \"dɩ. -Te kaa drɛ zɩɛ, fɛ pɛɛnɔn nɛn kaa laabo 'an \"tɩ 'lɔ te ka ya 'mɛn vɛ -a bɛ, yaa -nɔan 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","'Wɩnun nɛn maan 'vɩ 'cɛɛ 'gʋɛ, 'ka 'ta wʋla \"da 'dʋ -e 'ka cin yɩ \"yi.» ");
INSERT INTO yreNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«'Trɛdanɔn \"naan 'ka man, 'pian 'ka -tɔ 'nan o 'nan 'an man 'ka 'lɔ 'e 'flin. ");
INSERT INTO yreNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","\"Te ka ya \"le 'trɛdanɔn 'zʋ bɛ, \"te o 'ka ye \"yi \"le 'o 'va minnun zʋ. 'Pian an 'ka 'si o yei, ɛn ka 'ka \"nyian 'trɛdavɛ -a dɩ, -yee \"wɛan o \"naan 'ka man. ");
INSERT INTO yreNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","'Wɩ nɛn maan 'vɩ 'cɛɛ bɛ, -a -cin 'e 'fɔla 'ka 'ji. Maan 'vɩ 'nan, min 'suzan -dan 'ka 'mlian 'e 'tazan da dɩ, -yee \"wɛan -te minnun 'tɛ 'pa 'an da bɛ, 'ka -tɔ 'nan o 'tɛ \"paa \"nyian \"cee \"da. -Te minnun 'ta 'wʋla 'an wei da bɛ, 'ka -tɔ 'nan o 'ta wʋla \"nyian \"cee \"wei da. ");
INSERT INTO yreNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","'Wɩnun pɛɛnɔn zɩɛ waa dra 'cɛɛ, ka ya 'mɛn vɛ -a -le \"wɛan. Min nɛn yaan 'pa 'sia bɛ, wa'a tɔa dɩ, -yee \"wɛan nɛn waa dra. ");
INSERT INTO yreNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","\"Te ma'an 'talɛ -e 'an 'wɩ tin 'ba -wlɛ \"dɩɛ, \"te o 'ka 'wɩ 'wlidɩ \"drɛnɔn 'a dɩ. 'Pian 'bɛ nɛn 'gʋɛ, -wee 'wɩ 'pa \"davɛ pee \"ka \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kɔɔ min nɛn e \"naan 'an man bɛ, te -a san \"nan \"nyian 'an \"tɩ \"man. ");
INSERT INTO yreNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","'Wɩnun nɛn min -tʋ 'ka tian 'li -a drɛlɛ dɩɛ, \"te ma'an drɛlɛ o yiɛ man dɩɛ, \"te o 'ka 'wɩ 'wlidɩ \"drɛnɔn 'a dɩ. 'Pian 'bɛ nɛn 'gʋɛ, waan drɛ wɩnun 'yɩ, te o \"naan tian 'kʋ 'vale 'an \"tɩ \"a 'kʋ man. ");
INSERT INTO yreNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","'Wɩ zɩɛ e dra 'nan -e 'wɩ nɛn 'e 'crɛn -tɛdɩ -wee -pei 'fluba 'ji bɛ 'e 'lɛ sɔɔ. E ya 'e 'crɛn -tɛdɩ 'nan: ‹Minnun 'nan 'an man te -a -ci \"ka \"dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Tʋ nɛn an -ko 'an \"tɩ 'va bɛ, an 'ka 'pa \"vazan \"paa -sia. Bali lei nɛn, e \"sia 'an \"tɩ 'va, ɛn e 'wɩ tɩglɩ 'ci \"sia min lɛ. -Te e -ta bɛ, -yɛɛ 'an 'nan wɩ ve. ");
INSERT INTO yreNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","'Ka 'bɔ \"nyian, cɛɛ 'an 'nan wɩ ve minnun lɛ. Kɔɔ -e 'e 'sia 'mɛn 'nyranman pou sianan \"trilii -e 'e bɔ cɛɛgʋ yi -a bɛ, ka -fʋ 'an \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","'Wɩnun 'gʋɛ maan 'vɩ cɛɛ 'nan -e \"wɛɛ vɩnan 'o 'tɛ \"paa 'ka da bɛ -e 'ka vɩlɛ 'ka 'si 'an -sru \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Minnun -taa 'ka 'pinlɛ 'wee cin yɩ 'kɔnnun -ji. Ɛn tʋ -mie -taa \"bɔlɛ bɛ, minnun 'ka -tɛɛman, te o 'ci \"nrɔnman 'nan 'o ya Bali 'sunan. ");
INSERT INTO yreNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","'Wɩnun zɩɛ waa dra, kɔɔ wa'an \"tɩ 'tɔa dɩ, ɛn wa'an 'tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","'Wɩnun zɩɛ maan 'vɩ 'cɛɛ 'nan -te -a -tʋ 'bɔ bɛ, -e 'an wei -cin 'e 'trɔa 'ka 'ji. Ma'an vɩlɛ 'cɛɛ -a pou sianan \"dɩ, kɔɔ te an ya 'ka yei.» ");
INSERT INTO yreNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«'Bɛ nɛn 'gʋɛ, an \"ta lia 'an da min nɛn yaan 'pa 'sia bɛ -a va. 'Wɩ zɩɛ maan 'vɩ 'cɛɛ, ɛn min -tʋ 'ka yɩlɛ 'ka yei -e 'e laabʋ 'an 'lɔ 'nan nyin zia nɛn an \"ta -ko dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'Pian zɩ an 'wɩ zɩɛ -a 'vɩ 'cɛɛ bɛ, ɛn 'ka 'ta drɛ 'trɔdrɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, e ya 'cee 'wɩ \"yi \"a -e 'an 'kʋ. Kɔɔ -te ma'an 'kʋlɛ dɩɛ, 'ka 'pa \"vazan 'ka 'taa dɩ. 'Pian -te an -kʋ bɛ, maan \"paa -sia 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","-Te e -ta bɛ, 'wɩ nɛn e cɩ 'wɩ 'wlidɩ \"a bɛ 'lee 'wɩ nɛn e cɩ 'wɩ tɩglɩ 'a bɛ 'lee Bali -le tin 'badɩ bɛ, -yɛɛ -ci -kɔɔnman 'trɛdanɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","-Wee 'wɩ 'wlidɩ \"nɛn 'nan wa'a yi 'tɛala 'an da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Bali -le 'wɩ tɩglɩ drɛdɩ nɛn 'nan an lia 'an da 'an \"tɩ 'va, ɛn ka'a \"nyian 'an 'ye dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bali -le tin 'badɩ nɛn 'nan Satan nɛn e 'trɛ 'gʋɛ -a \"paala bɛ tin -tɛ \"da. ");
INSERT INTO yreNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","'Wɩ \"kaga \"a -e 'an vɩ 'cɛɛ, 'pian ka'a 'kɔlaman -e 'ka -ci man tʋ 'gʋɛ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bali lei nɛn e 'wɩ tɩglɩ 'ci \"sia min lɛ bɛ, -te e -ta bɛ, -yɛɛ 'wɩ tɩglɩ pɛɛnɔn 'ci \"sia 'cɛɛ. Ya'a 'wɩ 've 'e 'bɔ 'le 'plɛblɛ 'a dɩ, 'pian 'wɩ nɛn yaa man bɛ, -nyrɛn yaa ve minnun lɛ. 'Wɩ nɛn e -taa \"drɛlɛ -kɔɔbli bɛ, -nyrɛn yaa -ci \"sia minnun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","-Yɛɛ 'mɛn -dan ci -kɔɔnman minnun lɛ, kɔɔ 'wɩnun nɛn e -taa -a vɩlɛ 'cɛɛ bɛ, e \"sia an 'va. ");
INSERT INTO yreNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Fɛ pɛɛnɔn nɛn e cɩ 'an \"tɩ 'lɔ bɛ, te e ya 'mɛn vɛ -a \"nyian, -yee \"wɛan maan 'vɩ 'nan, 'wɩnun nɛn yaa ve 'cɛɛ bɛ, e \"sia 'an 'va.» ");
INSERT INTO yreNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Zozi -a 'vɩ \"nyian 'nan: «Tʋ -fʋ \"wɛnnɔn -e 'ka vɩlɛ 'kaan yɩ \"nyian dɩ, ɛn tʋ \"wɛnnɛn 'a \"nyian -e 'kaan yɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Zɩ Zozi 'wɩ zɩɛ -a 'vɩ bɛ, ɛn -a -srunɔn -mienun 'wɩ vɩdɩ 'sia o cin yei. Waa 'vɩ 'nan: «'Wɩ nɛn yaa 'vɩ -cɛɛ 'gʋɛ, -a -ci nɛn 'nɔn? Yaa 'vɩ 'nan, tʋ -fʋ \"wɛnnɔn -e 'ka vɩlɛ 'kaan yɩ \"nyian dɩ, ɛn tʋ \"wɛnnɛn 'a \"nyian -e 'kaan yɩ. Ɛn yaa 'vɩ \"nyian 'nan an \"ta -ko 'an \"tɩ \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tʋ \"wɛnnɛn 'bɔ nɛn yaa ve 'gʋɛ -a -ci nɛn 'nɔn? 'Wɩ nɛn e cɩ \"vale 'e ve bɛ, -ka'a -ci maan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Zozi -a -tɔ 'nan o ya \"vale 'o 'wɩ zɩɛ -a -ci laabo 'e 'lɔ, ɛn e 'nan -wlɛ 'nan: «Maan 'vɩ 'cɛɛ 'nan tʋ -fʋ \"wɛnnɔn, te ka'a \"nyian 'an 'ye dɩ ɛn tʋ \"wɛnnɛn 'a \"nyian -e 'kaan yɩ. 'Wɩ zɩɛ -a da nɛn ka 'wɩ laabo 'ka cin lɔ 'gʋ? ");
INSERT INTO yreNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, ka -taa \"wuɔlɛ 'kpa tɩglɩ, 'pian te 'trɛdanɔn \"le 'ci \"nranman. 'Ka 'ta dra -trɔdrɔ, 'pian 'cee ta drɛdɩ -trɔdrɔ zɩɛ e limlan \"da ci \"nrandɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","'Ka 'ci \"nrɔn -pɔnzan da. -Te -yee 'nɛn 'ya tʋ 'bɔ bɛ, -a ta dra -trɔdrɔ, kɔɔ -yee yra yɩdɩ 'bɔ. 'Pian -te e 'nɛn 'bɔ 'ya bɛ, -e 'yee yra yɩdɩ -cin 'e 'san \"ji. -A ci \"nranman 'siɛn 'nan 'e min 'bɔla 'trɛda. ");
INSERT INTO yreNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","-A -tʋwli \"nɛn \"nyian 'cee vɛ -a. Tʋ 'gʋɛ -a bɛ 'ka 'ta a -trɔdrɔ, 'pian an 'ka yɩ pee wo -e 'ka 'ci 'e \"nran. Ɛn min -tʋ 'ka 'kɔlaman -e 'e ci \"nrandɩ zɩɛ -a 'si 'ka 'lɔ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tʋ zɩɛ -a man bɛ, ka'a \"nyian 'wɩ 'tʋ laabo 'an 'lɔ dɩ. Maan ve 'cɛɛ 'wɩ tɩglɩ 'a 'nan, fɛ nɛn kaa laabo 'an \"tɩ 'lɔ te ka ya 'mɛn vɛ -a bɛ yaa -nɔan 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ka'a tian fɛ -tʋ laabʋlɛ 'an \"tɩ 'lɔ te ka ya 'mɛn vɛ -a dɩ. 'Ka laabʋ -yrɔ, yaa -nɔan 'cɛɛ -e 'cee ci \"nrandɩ 'e 'ciɩla \"da \"fo.» ");
INSERT INTO yreNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«'Wɩnun zɩɛ, maan 'vɩ 'cɛɛ -kɔnnɛn \"ji. Tʋ -tʋ -taa \"bɔlɛ, te ma'an \"nyian 'wɩ tin 'baa 'cɛɛ -kɔnnɛn \"ji dɩ, 'pian 'an \"tɩ \"le 'wɩ tin \"baa 'cɛɛ 'wein. ");
INSERT INTO yreNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tʋ zɩɛ -a man bɛ, 'ka fɛ laabʋ 'an \"tɩ 'lɔ te ka ya 'mɛn vɛ -a. 'An 'bɔ \"cɛɛ 'an \"tɩ trʋ \"baa -yee fɛ -nɔndɩ 'cɛɛ -a dɩ, ");
INSERT INTO yreNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kɔɔ 'an \"tɩ 'bɔ 'ka ye \"yi, kaan 'yɩ \"yi \"le \"wɛan. Kaan ye \"yi, ɛn ka yi -tɛala \"da 'nan an 'si Bali va, -yee \"wɛan 'an \"tɩ 'bɔ 'ka ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","An 'si 'an \"tɩ 'va, ɛn an -ta 'trɛ 'gʋɛ -a da. 'Bɛ nɛn 'gʋɛ, an \"ta \"sia 'trɛda -e 'an li 'an da 'an \"tɩ 'va.» ");
INSERT INTO yreNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ɛn -a -srunɔn \"e 'nan -yrɛ 'nan: «I ya 'wɩ tin 'banan \"mɛn 'e 'ci -a 'wein te e 'ka -kɔnnɛn \"ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","'Bɛ nɛn 'gʋɛ, kʋa -tɔ \"mɛn 'nan i 'wɩ pɛɛnɔn -tɔa. 'Wɩ nɛn kʋ cɩ \"vale 'kʋ laabo 'i 'lɔ bɛ yia -tɔa, te kʋ'a tian -a laabʋlɛ dɩ. -Yee \"wɛan kʋ yi -tɛala 'i da 'nan i 'si Bali va.» ");
INSERT INTO yreNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Ka yi -tɛala 'an da, 'bɛ a zɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","'Pian maan ve 'cɛɛ 'nan, tʋ -tʋ -taa \"bɔlɛ, 'ka pɛɛnɔn fuimlan \"man -e min -tʋ 'e 'kʋ 'e 'lɛ zia. -A tʋ 'bɔ 'bɔ 'va. Tʋ zɩɛ -a man nɛn kaan \"tʋe 'an -tʋwli. 'Pian an 'ka 'an -tʋwli \"dɩ, kɔɔ 'an \"tɩ -kɔan 'an \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","An -fɔ 'e 'flin an 'wɩnun pɛɛnɔn 'gʋɛ -a 'vɩ 'cɛɛ 'nan -e 'ka 'fʋ -trɔɔ, -e -kaa drɛ min -tʋwli \"a -le \"wɛan. Ka -taa 'ka yra yɩlɛ 'trɛda, 'pian 'ka -pɔan 'e 'sɔ, an 'trɛda 'plɛblɛ pɛɛnɔn klɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Zɩ Zozi cɛɛn 'wɩ zɩɛ -a vɩdɩ man bɛ, 'e yra -tɔ laji, ɛn e 'nan: «'An \"tɩ, -a tʋ 'bɔ. 'An 'bɔ nɛn 'i 'pɩ -a bɛ, 'yian 'tɔ drɛ -dan, -e 'mɛin 'tɔ drɛ -dan \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","I 'plɛblɛ 'nɔn 'mɛn, ɛn yian 'pla fɛ pɛɛnɔn 'ta lou, -yee \"wɛan minnun nɛn i o -nɔn 'mɛn bɛ, an 'belidɩ nɛn ya'a 'nyaan dɩɛ -a -nɔan -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","'Belidɩ nɛn ya'a 'nyaan dɩɛ, -nyrɛn 'nan, min 'e 'i 'tɔ, 'nan 'i 'bɔ 'tʋwli yiɛ cɩ Bali tɩglɩ 'a, ɛn 'an 'bɔ Zozi Crizi nɛn yian 'pa 'sia bɛ min 'e 'an 'tɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mɛin 'tɔ drɛ -dan 'trɛda, ɛn 'nyranman nɛn yia -nɔn 'mɛn 'nan 'an 'pa bɛ, maan 'lɛ sɔɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","'Bɛ nɛn 'gʋɛ, 'an \"tɩ, 'yian drɛ -dan 'i \"srɔn \"nun. Zɩ an cɩ -dan 'i \"srɔn \"nun 'e 'cɛn, te 'trɛ \"ka tian dɩɛ, 'yian drɛ -a 'e \"pa 'ji. ");
INSERT INTO yreNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Zɩ i cɩ bɛ, maan -ci 'si minnun nɛn i o 'si \"va 'trɛdanɔn yei ɛn i o -nɔn 'mɛn bɛ -wlɛ. O ya 'yie vɛ -a, ɛn i o -nɔn 'mɛn. O 'ta 'wʋla 'i wei da, ");
INSERT INTO yreNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ɛn waa -tɔ \"mɛn 'nan, fɛ pɛɛnɔn nɛn yia -nɔn 'mɛn bɛ, e \"sia 'i 'va 'kpagba. ");
INSERT INTO yreNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","-Yɛɛ cɩ 'nan weinun nɛn yia -nɔn 'mɛn bɛ, maan 'vɩ -wlɛ ɛn waa 'sia \"da. Waa -tɔ 'nan 'wɩ tɩglɩ an 'si 'i 'va, ɛn o yi -tɛra \"da 'nan yiɛ 'an 'pa 'sia. ");
INSERT INTO yreNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","-Wee \"wɛan nɛn an cɩ 'i trʋ 'banan. An 'ka 'i trʋ 'banan 'trɛdanɔn pɛɛnɔn 'le \"wɛan dɩ. 'Pian minnun nɛn i o -nɔn 'mɛn bɛ, -wee \"wɛan nɛn an cɩ 'i trʋ 'banan, kɔɔ o ya 'yie vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Minnun pɛɛnɔn nɛn o cɩ 'mɛn vɛ -a bɛ, o ya 'yie vɛ -a. Ɛn minnun nɛn yie vɛ -a bɛ, o ya 'mɛn vɛ -a, -wee \"wɛan nɛn 'an 'tɔ drɛ -dan. ");
INSERT INTO yreNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","An \"ta \"sia 'trɛda -e 'an 'lʋ 'i 'va nun te \"o \"ya wo 'trɛda 'gʋ. 'An \"tɩ \"nɛn e ya 'saun bɛ, 'i 'tɔ nɛn yia -nɔn 'mɛn bɛ -yee 'plɛblɛ 'a, 'i yiɛ 'tɔ o va, 'dʋ -e -kaa fʋ waa -tʋwli \"le zɩ 'kʋ cɩ 'yia min -tʋwli \"a bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tʋ nɛn te an ya o va 'trɛda bɛ, 'an yiɛ 'tɔ o va, 'i 'tɔ nɛn yia -nɔn 'mɛn bɛ, -yee 'plɛblɛ 'a. Min -tʋwli 'ka 'sanlɛ dɩ, -te yaa 'silɛa min -wlidɩ \"a dɩɛ. -Yɛɛ 'san 'nan -e Bali wei nɛn 'e 'crɛn -tɛdɩ bɛ 'e 'lɛ sɔɔ. ");
INSERT INTO yreNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","'Bɛ nɛn 'gʋɛ an \"ta \"lo 'i 'va, ɛn 'wɩnun 'gʋɛ maan ve trɛda 'gʋ 'nan -e ci \"nrandɩ nɛn 'an 'lɔ bɛ, 'e 'kɔn \"nyian -wee 'lɔ 'e 'ciɩladɩ \"da \"fo. ");
INSERT INTO yreNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","'I wei bɛ, maan 'vɩ -wlɛ, -yee \"wɛan 'trɛdanɔn 'nandɩ 'sia o man. O 'nandɩ 'sia o man 'nan o 'ka \"nyian 'wee vɛ -a dɩ, \"le zɩ an 'ka -wee vɛ -a dɩɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","An 'ka 'i trʋ 'banan 'nan 'i o 'si 'trɛdanɔn yei \"dɩ. An ya 'i trʋ 'banan 'pian 'nan, 'i yiɛ 'tɔ o va Satan nɛn e 'wɩ 'wlidɩ \"paa 'nyranman -a bɛ -yee \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","O 'ka 'trɛdavɛ -a dɩ, \"le zɩ an 'ka 'trɛdavɛ -a dɩɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","'I 'wɩ tɩglɩ -kɔɔn -wlɛ -e 'o drɛ 'yie vɛ -a \"fo. 'Wɩ tɩglɩ zɩɛ 'i wei nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Zɩ yian 'pa 'sia 'trɛda bɛ, -a -tʋwli \"nɛn \"nyian an o 'pa 'sia 'trɛda. ");
INSERT INTO yreNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","An 'fli -nɔan -e 'an 'ka -wee \"wɛan, 'dʋ -e 'o drɛ 'yie vɛ -a \"fo. ");
INSERT INTO yreNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","-Wee \"wɛan nɛn an ya 'i trʋ 'banan, ɛn minnun nɛn o yi -tɛra 'an da o wei -le \"wɛan bɛ, an ya 'i trʋ 'banan \"nyian -wee 'wɩ man. ");
INSERT INTO yreNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","An ya 'i trʋ 'banan 'nan -e 'o drɛ min -tʋwli \"a. 'An \"tɩ, 'o 'kɔn 'o lɛadɩ 'kʋ man, \"le zɩ 'kʋ 'vale 'yia, kʋ ya min -tʋwli \"a bɛ -yee 'wɩ 'zʋ. 'O drɛ min -tʋwli \"a -e 'trɛdanɔn 'o -tɔ 'nan yiɛ 'an 'pa 'sia. ");
INSERT INTO yreNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","An o drɛ -dan \"le zɩ yian drɛ -dan bɛ -yee 'wɩ 'zʋ. An o drɛ -dan 'nan -e 'o drɛ min -tʋwli \"a, \"le zɩ kʋ cɩ 'yia min -tʋwli \"a bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kʋ ya waa min -tʋwli \"a, ɛn kʋ ya 'yia min -tʋwli \"a 'nan -e 'o drɛ min -tʋwli \"a 'kpa tɩglɩ. 'E drɛ zɩɛ -e 'trɛdanɔn 'o -tɔ 'nan, yiɛ 'an 'pa 'sia, ɛn i o ye \"yi \"le zɩ yian ye \"yi \"bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","'An \"tɩ, minnun pɛɛnɔn nɛn i o -nɔn 'mɛn bɛ, an ya \"va 'nan 'kʋ 'kɔn waa fɛnan nɛn an -kɔan \"bɛ -a -nan. An ya \"va 'nan 'o 'mɛn -dan ci yɩ. Yian drɛ -dan, kɔɔ yian 'yɩ \"yi, te yi'a tian 'trɛ drɛlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","'An \"tɩ, i ya tɩglɩ. 'Trɛdanɔn 'ka 'i 'tɔa dɩ, 'pian 'an 'bɔ 'mɛin -tɔa. Ɛn 'an -srunɔn \"o \"tɔ \"nyian 'nan yiɛ 'an 'pa 'sia. ");
INSERT INTO yreNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Zɩ i cɩ bɛ, maan kɔɔn -wlɛ, ɛn maan -kɔɔnman tian -wlɛ, 'nan -e 'o cin yɩ \"yi \"le zɩ yian ye \"yi \"bɛ -yee 'wɩ 'zʋ, te kʋ ya waa min -tʋwli \"a.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Zɩ Zozi cɛɛn Bali trʋ 'badɩ man bɛ, ɛn 'o 'vale 'e -srunɔn 'a, o -kʋ 'yi nɛn waa laabo Cedrɔn bɛ -a -sru. Fei -tʋ a fɛ zɩɛ -a -nan, -a da nɛn o -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zozi 'lee 'e -srunɔn 'o cin ye 'e 'cɛn fɛ zɩɛ -a -nan, -yee \"wɛan Zudazi nɛn e \"ta -daa Zozi 'nɔnlɛ 'e 'nanmannɔn lɛ bɛ, yaa -nan -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","'Sounja 'pa 'tʋ 'lee minnun nɛn Bali -pannɔn 'tanɔn 'lee Farizɛn 'nɔn o 'pa 'sia bɛ, Zudazi -trɔa o 'lɛ, ɛn e -kʋ waa fei zɩɛ -a da. \"Wɛɛ vɩnan 'o 'kʋ bɛ, srɔannun a -wlɔ, -kannɛnnun a -wlɔ, ɛn -kuli -tan fɛnun a -wlɔ. Zɩ o 'bɔla bɛ, ");
INSERT INTO yreNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ɛn Zozi 'kʋ o 'lɛ, te e 'wɩ nɛn e \"ta -daa \"bɔlɛ \"man \"bɛ -a -tɔa, ɛn yaa laabʋ -wlɔ 'nan: «-Tɩ nɛn -kaa -wɛɛman?» ");
INSERT INTO yreNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","O 'nan -yrɛ 'nan: «Nazarɛtɩ min Zozi nɛn kʋa -wɛɛman.» Ɛn Zozi \"e -wlɛ 'nan: «'An 'bɔ nɛn 'gʋ.» Zudazi nɛn e Zozi 'bɔ 'nɔn 'e 'nanmannɔn lɛ bɛ e ya o yei. ");
INSERT INTO yreNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Zɩ Zozi -a 'vɩ -wlɛ 'nan, 'e 'bɔ nɛn 'gʋɛ, o -kʋ 'o koda ɛn o tiila \"tra. ");
INSERT INTO yreNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","-A -nan nɛn Zozi -a laabʋ \"nyian -wlɔ 'nan: «-Tɩ nɛn kaa -wɛɛman?» Ɛn o -yrɛ 'nan: «Nazarɛtɩ min Zozi nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Zozi \"e 'nan -wlɛ 'nan: «Maan 'vɩ 'cɛɛ 'va 'nan 'an 'bɔ nɛn 'gʋ. -Yee \"wɛan -te maan nɛn ka cɩ 'an -wɛɛnan bɛ, ka minnun 'gʋɛ o 'tʋɩ 'o 'kʋ.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Zɩ 'wɩ nɛn Zozi -a 'vɩ 'e 'cɛn bɛ 'e 'lɛ sɔɔ zɩɛ. Yaa 'vɩ 'e 'cɛn 'nan: «Minnun nɛn i o -nɔn 'mɛn bɛ, o va min -tʋwli 'ka 'sanlɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","-A -sruzan nɛn Simɔn Piɛri -a bɛ, sɛn a -yrɔ, yaa 'sʋ 'e 'kɔlɛ 'ji, ɛn e Bali -pannɔn 'tazan 'suzan 'tʋ -pɛ \"yi \"da \"trɔɛn cɛɛn. Min zɩɛ waa laabo Maku. ");
INSERT INTO yreNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ɛn Zozi \"e Piɛri lɛ 'nan: «'I 'yie sɛn wʋ 'e 'kɔlɛ 'ji! 'Kulenɛn nɛn yra yɩdɩ cɩ -ji 'gʋɛ, 'an \"tɩ -a 'pla 'mɛn, ma'an ve \"man \"cɛjɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","'Sounjanun 'lee 'o 'tazan 'lee minnun nɛn Zuif 'nɔn 'tanɔn o 'pa 'sia bɛ, o Zozi 'kun, waa yrɩ, ");
INSERT INTO yreNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ɛn o -kʋ -a 'e tɛdɛ min -tʋ nɛn waa laabo Ane bɛ -a va. Waa nan \"tɩ laabo Kaifa, -yɛɛ cɩ lɛ 'bɔ zɩɛ -a -ji Bali -pannɔn 'tazan -a. ");
INSERT INTO yreNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifa zɩɛ, -yɛɛ 'wɩ tin 'ba \"nɛn Zuif 'nɔn 'tanɔn lɛ. Yaa 'vɩ -wlɛ 'nan, -a \"yi mlin -e min -tʋwli 'e min pɛɛnɔn 'lɛji -ka wʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔn Piɛri 'lee Zozi -sruzan 'tʋ, 'bɛ sɔɔnla Zozi 'bɔ -sru. Zozi -sruzan 'tʋ zɩɛ Bali -pannɔn 'tazan 'bɔ -a -tɔa. -Yee \"wɛan -yɛɛ wlala 'o 'vale Zozi 'a Bali -pannɔn 'tazan 'bɔ 'le -klɔn -ji. ");
INSERT INTO yreNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","'Pian Piɛri \"e -fʋʋ bei -klɔn -yrɛ \"nɛn. -A -sruzan 'tʋ bɛ, e 'li 'e da, ɛn e 'wɩ tin 'ba lɩmɔn nɛn 'e yiɛ -tɔa -klɔn 'bɔ -yrɛ \"nɛn \"bɛ -yrɛ. Tɔɔn, ɛn e -si -nɔn Piɛri lɛ, ");
INSERT INTO yreNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","yaa laabʋ Piɛri -lɔ 'nan: «Bii 'gʋɛ, -a -sruzan 'tʋ nɛn \"nyian \"yie \"a?» Ɛn Piɛri \"e 'nan -yrɛ 'nan: «An 'ka -a -sruzan 'a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Bali -pannɔn 'tazan 'bɔ 'sunɔn 'lee 'sounjanun nɛn -nan bɛ, o 'tɛ 'fɔ \"nɛn, ɛn waa si -fɔ trun -taa \"le \"wɛan. Piɛri -tɔ o va, ɛn e 'tɛ \"klandɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bali -pannɔn 'tazan 'wɩ laabʋ Zozi 'lɔ. Yaa laabʋ -yrɔ -a -srunɔn da, ɛn yaa laabʋ -yee 'wɩ \"paadɩ da. ");
INSERT INTO yreNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ɛn Zozi \"e 'nan -yrɛ 'nan: «An 'wɩ tin 'ba min pɛɛnɔn yiɛ man, ɛn yi pɛɛnɔn man te an 'wɩ \"paaman minnun ji Bali trʋ 'ba 'kɔnnun -ji 'lee Bali -pan 'kɔnnun nɛn Zuif 'nɔn o cin ye -ji bɛ -a -ji. Ma'an 'wɩ 'tʋ drɛlɛ 'e yɔɔdɩ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","-Mɛ \"le \"wɛan i 'wɩ laabo 'an 'lɔ 'wɩ zɩɛ -a da? Minnun nɛn waan wei 'man bɛ, 'wɩ nɛn maan tin 'ba -wlɛ \"bɛ, waa -tɔa. O lɔ nɛn 'i laabʋ.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Zɩ Zozi 'wɩ zɩɛ -a 'vɩ bɛ, ɛn Bali -pannɔn 'tazan 'suzan 'tʋ nɛn 'e 'tɔdɩ Zozi \"srɔn \"bɛ, e 'pa 'fɔ Zozi yra, ɛn e 'nan -yrɛ 'nan: «-Tɩɛ 'vɩ 'yiɛ 'nan 'i 'wɩ tin 'ba Bali -pannɔn 'tazan lɛ zɩɛ?» ");
INSERT INTO yreNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «-Te maan 'vɩ 'wlidɩ \"bɛ, 'wɩ nɛn maan 'vɩ \"va \"wlidɩ \"bɛ, 'i vɩ 'mɛn. Ɛn -te ma'an 'wɩ 'wlidɩ \"vɩlɛ dɩɛ, -mɛ \"le \"wɛan nɛn i fɛ 'lɛ wo 'an 'ji?» ");
INSERT INTO yreNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ane Zozi 'tʋɩ 'e -yrɩdɩ, ɛn yaa -nɔn 'nan 'o 'kʋ -a Kaifa lɛ. -Yɛɛ cɩ Bali -pannɔn 'tazan -a lɛ 'bɔ zɩɛ -a -ji. ");
INSERT INTO yreNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tʋ zɩɛ -a wlu bɛ, te Simɔn Piɛri a tian 'e 'tɔdɩ 'tɛ man 'tɛ \"klannan. Ɛn waa laabʋ -yrɔ 'nan: «Bii 'gʋɛ, -a -sruzan 'tʋ nɛn \"nyian \"yie \"a?» Simɔn yɔɔ \"da, ɛn e 'nan: «An 'ka -a -sruzan 'a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Bali -pannɔn 'suzan 'tʋ a fɛ 'bɔ zɩɛ -a -nan. Min nɛn Piɛri -a \"trɔɛn cɛɛn bɛ, -a drɩ nɛn, e 'nan Piɛri lɛ 'nan: «Mɛin 'yɩ 'ka 'vale Zozi 'a fei.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piɛri yɔɔ \"da \"nyian. 'Nun tɔɔn, ɛn mannɛn wɩɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bodrun puunɔn nɛn Zuif 'nɔn 'tanɔn 'si Zozi 'a Kaifa -va, ɛn o -kʋ -a Rɔm min -kɔnmandan -le -klɔn -ji. Zuif 'nɔn 'ka \"o -wla \"wʋlɛ Rɔm min -kɔnmandan -le -klɔn -ji dɩ, \"tɔgɔ 'o \"tri \"tɔ Bali 'lɛ, -e 'o vɩlɛ 'o -kɔla Zuif 'nɔn 'le 'si nɔanba -ji \"fɛdi da fɛnun -blɩdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","-Yee \"wɛan -kɔnmandan Pilati 'bɔ 'bɛ 'bɔla ɛn e -kʋ o va. Yaa laabʋ -wlɔ 'nan: «-Mɛ \"wɩ nɛn min 'labɛ yaa drɛ, ɛn ka 'wɩ -tɔa \"man?» ");
INSERT INTO yreNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɛn o 'nan Pilati lɛ 'nan: «\"Te 'wɩ 'wlidɩ \"drɛzan \"cɛɛ dɩɛ, \"te kʋa 'talɛ -a 'i 'va 'gʋ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ɛn Pilati -a 'vɩ -wlɛ 'nan: «'Ka 'bɔ, 'ka 'kʋ -a -e 'ka -yee 'wɩ tin 'ba \"le zɩ 'cee -pei -a 'vɩ bɛ -yee 'wɩ 'zʋ.» Ɛn Zuif 'nɔn \"o 'nan -yrɛ 'nan: «Ka'a -si -nɔnlɛ 'kʋɛ 'nan 'kʋ min -tɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Zɩ 'wɩ nɛn Zozi -a 'vɩ 'e 'cɛn 'yee -kadɩ da bɛ 'e 'lɛ sɔɔ zɩɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tɔɔn ɛn Pilati 'li 'e da 'yee -klɔn -ji. E Zozi laabʋ, ɛn yaa laabʋ -yrɔ 'nan: «Zuif 'nɔn 'le mingɔnnɛn nɛn 'yia?» ");
INSERT INTO yreNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ɛn Zozi -a laabʋ -yrɔ 'nan: «'I 'bɔ, yiɛ 'wɩ zɩɛ -a 'vɩ 'i 'bɔ 'a, -baa minnun 'bɛ 'vɩ ɛn \"i \"man?» ");
INSERT INTO yreNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilati \"e -yrɛ 'nan: «Zuif min nɛn maan? 'I 'bɔ flanɔn 'lee Bali -pannɔn 'tanɔn 'bɛ 'i 'nɔn 'nan 'mɛin 'tɛ. -Mɛ \"nɛn yia drɛ?» ");
INSERT INTO yreNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ɛn Zozi \"e 'nan: «'Trɛda minnun \"cɛɛ 'an 'tɔ mingɔnnɛn -a dɩ. \"Te -wɛɛ 'an 'tɔ mingɔnnɛn -a bɛ, \"te 'an 'sunɔn 'an 'ta kuli -tan, -e minnun 'o vɩlɛ 'waan 'nɔn Zuif 'nɔn 'tanɔn lɛ dɩ. 'Trɛ 'gʋɛ -a da minnun \"cɛɛ 'an 'tɔ mingɔnnɛn -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ɛn Pilati -a 'vɩ -yrɛ 'nan: «Yioo, mingɔnnɛn nɛn 'yia?» Zozi \"e 'nan: «-Inyan, -a 'bɔ nɛn i \"sia -a vɩnan bɛ an ya -a. An -ta 'trɛda 'nan -e 'an 'wɩ tɩglɩ vɩ minnun lɛ. -Yee \"wɛan waan 'ya, minnun pɛɛnɔn nɛn o 'wɩ tɩglɩ -tɔa \"bɛ, 'o \"trɔɛn -tɔa 'an wei lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilati -a laabʋ -yrɔ 'nan: «-Mɛ \"nɛn 'wɩ tɩglɩ 'a?» Zɩ Pilati 'wɩ zɩɛ -a laabʋ bɛ, e 'bɔla, ɛn e -kʋ \"nyian Zuif 'nɔn 'va. Ɛn e 'nan -wlɛ 'nan: «Ma'an 'wɩ 'tʋ yɩlɛ min 'gʋɛ -a man, -e min 'e 'ka -a 'wɩ 'ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","'Pian 'wɩ nɛn -cɛɛ dra 'e 'cɛn bɛ, 'bɛ cɩ 'nan -te Zuif 'nɔn 'le 'si nɔanba -ji \"fɛdi 'bɔ bɛ, an \"sia -pʋ 'kɔnzan 'tʋ man. -Yee \"wɛan maan laabo 'ka 'lɔ 'nan, ka ya \"va 'nan 'an 'si Zuif 'nɔn 'le mingɔnnɛn man?» ");
INSERT INTO yreNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tɔɔn, ɛn o pɛɛnɔn -paandɩ 'sia 'e cin va. Waa ve 'nan: «-Cɛjɛ oo! -Cɛjɛ oo! Te 'i 'si min 'labɛ 'bɛ man dɩ oo! Barabazi man nɛn 'i 'si o!» Barabazi 'bɔ zɩɛ, min nɛn e min -tɛ bɛ -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ɛn Pilati \"e 'nan 'sounjanun lɛ 'nan 'o Zozi 'kun, -e 'o -sɔn -ngble -a. ");
INSERT INTO yreNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","'Sounjanun 'bɔ lei 'tan, ɛn waa 'wʋ -a -wulo -man \"le -yee mingɔnnɛn kle 'zʋ. O mingɔnnɛn -tralɛ 'tɛndɛn 'tʋ 'si, ɛn waa 'wʋ \"da. ");
INSERT INTO yreNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","O -pli \"man -a \"srɔn te waa ve -yrɛ 'nan: «Zuif 'nɔn 'le mingɔnnɛn, 'tɩɩ 'tɔ bo», -e 'o 'pa 'fɔ -a yra. ");
INSERT INTO yreNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilati 'bɔla \"nyian, ɛn e 'nan Zuif 'nɔn lɛ 'nan: «An \"ta -a bɔala 'cɛɛ bei -e 'ka -tɔ 'nan ma'an 'wɩ 'tʋ yɩlɛ \"man -e 'e 'ka -a 'wɩ 'ji dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ɛn Zozi 'bɔla te lei kle \"a -a -wulo -man, ɛn mingɔnnɛn -tralɛ a \"da. -A -nan nɛn, Pilati \"e 'nan -wlɛ 'nan: «'Cee min bɛ, -nyrɛn \"bɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Zɩ Bali -pannɔn 'tanɔn 'lee o 'sunɔn -a 'yɩ bɛ, ɛn o -paandɩ 'sia. Waa ve 'nan: «'I -pɛin yiba \"plan da! 'I -pɛin yiba \"plan da!» Ɛn Pilati \"e -wlɛ 'nan: «'Ka 'si, -e 'ka -pɛin yiba \"plan da 'ka 'bɔ 'a! Kɔɔ ma'an 'wɩ 'tʋ yɩlɛ \"man -e 'e 'ka -a 'wɩ 'ji dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Zuif 'nɔn \"o 'nan -yrɛ 'nan: «'Kʋe -pei -tɔ 'wɩ 'tʋ a. 'Kʋe -pei -tɔ wɩ zɩɛ -a pɛ -ji nɛn waa -tɛa, kɔɔ e 'nan Bali -pɩ nɛn 'yaa.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Zɩ Pilati 'wɩ zɩɛ -a 'man bɛ, ɛn -yee \"klandɩ 'pa \"da. ");
INSERT INTO yreNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilati wla \"nyian 'yee -klɔn -ji, ɛn yaa laabʋ Zozi 'lɔ 'nan: «I \"sia nyin?» 'Pian Zozi 'ka 'wɩ 'tʋ 'silɛ \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ɛn Pilati \"e -yrɛ \"mɛn 'nan: «'An 'bɔ 'lɛ nɛn yi'a 'wɩ 'tʋ sia \"da \"dʋʋ? Yi'a tɔa 'nan -a -si a 'an 'lɔ -e 'an 'si 'i man dʋʋ, ɛn -te 'bɛ \"cɛɛ dɩ -e 'mɛin -pɛin yiba \"plan da dʋʋ?» ");
INSERT INTO yreNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Zozi \"e 'nan -yrɛ 'nan: «Yi'a 'kɔlaman fɛ -tʋ drɛdɩ -a 'mɛn, te Bali \"cɛɛ -si -nɔn dɩ, -yee \"wɛan min nɛn yaan 'nɔn 'yiɛ bɛ, -yee 'wɩ 'wlidɩ 'bɛ cɩ -dan.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Zɩ Pilati 'wɩ zɩɛ -a 'man bɛ, ɛn yaa -wɛɛdɩ 'sia 'nan 'e \"sia Zozi man. 'Pian te Zuif 'nɔn -paanman 'nan: «-Te i 'si \"man \"bɛ, te 'i 'ka Rɔm 'nɔn 'le mingɔnnɛn tazan Seza bee -a dɩ. Kɔɔ min nɛn e 'fli drɛ mingɔnnɛn -a bɛ, te -a pei a 'e 'padɩ \"man.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Zɩ Pilati 'wɩ zɩɛ 'bɛ 'man \"nyian bɛ, ɛn e 'nan 'o Zozi bɔla bei. Tɔɔn ɛn Pilati 'bɔ -nyran 'yee tin 'ba pɛin -da. Fɛ zɩɛ -a -nan a 'e wluandɩ, waa drɛ -kɔlɛ -a \"le lazo nɛn waa -fɔ. Waa laabo Ebre wei -ji «Gabata». ");
INSERT INTO yreNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Te yidɛ 'bɔ min -win -ji 'sɛzɛ, ɛn Zuif 'nɔn a 'wee 'si nɔanba -ji \"fɛdi man drɛnan. -A -nan nɛn Pilati \"e 'nan Zuif 'nɔn 'tanɔn lɛ 'nan: «'Cee mingɔnnɛn 'bɔ nɛn bɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ɛn o -paandɩ 'sia 'nan: «'O -tɛ, 'o -tɛ! 'I -pɛin yiba \"plan da!» Ɛn Pilati -a laabʋ -wlɔ 'nan: «'An 'cee mingɔnnɛn -pɛin yiba \"plan da?» Tɔɔn ɛn Bali -pannɔn 'tanɔn -a 'vɩ -yrɛ 'nan: «'Kʋe mingɔnnɛn a -tʋwli \"cɛ, waa laabo mingɔnnɛn Seza.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","'Wɩ zɩɛ -a da nɛn Pilati 'e 'pɛ 'si Zozi da, ɛn yaa -pɛindɩ yiba \"plan da -si -nɔn. 'Sounjanun -kʋ Zozi 'a. ");
INSERT INTO yreNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Zozi 'bɔ 'bɛ 'yee yiba \"plan 'sia, ɛn o -kʋ -a fɛnan nɛn waa laabo min -wulo klo bɛ -a -nan. Waa ve Ebre wei -ji «Gɔlgota». ");
INSERT INTO yreNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Fɛ zɩɛ -a -nan nɛn waa pɛin yiba \"plan da. O min -tʋ pɛin yiba \"plan da -a -pɛ \"yi \"da, ɛn o min -tʋ pɛin \"nyian yiba \"plan da -a -pɛ bʋ da. ");
INSERT INTO yreNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilati \"e 'nan 'o yiba 'fʋɩnɛn da 'crɛn -tɛ, -e 'o 'pa Zozi 'le yiba \"plan ta lou. Waa 'crɛn -tɛ \"da 'nan: ");
INSERT INTO yreNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","'Wɩ 'bɔ a 'e 'crɛn -tɛdɩ Ebre wei -ji, ɛn e ya 'e 'crɛn -tɛdɩ Latɛn wei -ji, ɛn e ya 'e 'crɛn -tɛdɩ \"nyian Grɛk wei -ji. Zuif 'nɔn \"kaga 'wɩ zɩɛ -a ta 'vɩ, kɔɔ fɛnan nɛn o Zozi pɛin yiba \"plan da bɛ, e ya 'fla \"srɔn \"kogo. ");
INSERT INTO yreNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ɛn Bali -pannɔn 'tanɔn 'kʋ -a vɩlɛ Pilati lɛ 'nan: «Te 'e 'kɔn 'e 'crɛn -tɛdɩ Zuif 'nɔn 'le mingɔnnɛn dɩ! 'Pian 'i crɛn -tɛ 'nan, e 'nan 'e ya Zuif 'nɔn 'le mingɔnnɛn -a!» ");
INSERT INTO yreNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilati -a 'vɩ -wlɛ 'nan: «'Wɩ nɛn maan crɛn -tɛ bɛ, ma'an \"nyian -a limlan dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Zɩ 'sounjanun cɛɛn Zozi -pɛindɩ man yiba \"plan da bɛ, ɛn o sɔnun nɛn waa 'sʋ \"da \"bɛ, waa 'pla sinjɛn, ɛn waa 'sia 'tʋdʋ. -Yee sɔ -gblɔ -tʋ nɛn wɛɛ pee 'tʋwli \"plɔun bɛ, wɛɛ 'si, ");
INSERT INTO yreNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ɛn waa 'vɩ 'o cin yei 'nan: «Te -kaa 'fʋɩ bʋʋ dɩ, 'pian -kaa 'lein 'wlɛ tuʋla, -e min nɛn e -tria \"da \"bɛ, 'o -nɔn -yrɛ.» Zɩ Bali wei nɛn 'e 'crɛn -tɛdɩ 'e 'cɛn bɛ e 'lɛ sɔɔ zɩɛ. E ya 'e 'crɛn -tɛdɩ 'nan: «O 'mɛn sɔ pli 'o cin yei, ɛn o 'mɛn sɔ -gblɔ 'si 'lein 'wlɛ 'tuʋladɩ da.» 'Wɩ zɩɛ -a 'bɔ nɛn 'sounjanun -a drɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tʋ zɩɛ -a wlu bɛ, te yiba \"plan nɛn o Zozi pɛin \"da \"bɛ, lɩmɔn sinjɛn a 'o 'tɔdɩ \"wlu. Zozi 'bɔ \"bʋ 'lee Zozi \"bʋ \"blu 'lee Klopa nan Mari 'lee Madala lɩ Mari. ");
INSERT INTO yreNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Zɩ Zozi 'e \"bʋ 'yɩ, te 'e -sruzan nɛn yaa ye \"yi \"bɛ -a ye 'e 'tɔdɩ 'e \"bʋ \"srɔn \"bɛ, ɛn e 'nan 'e \"bʋ \"lɛ 'nan: «'I 'pɩ nɛn bɛ o.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ɛn Zozi -a 'vɩ 'e -sruzan zɩɛ -yrɛ 'nan: «'I \"bʋ \"nɛn bɛ o.» 'Wɩ nɛn Zozi -a 'vɩ bɛ, -a da nɛn -a -sruzan -a drɛ, 'e yiɛ 'tɔ -a \"bʋ 'va. ");
INSERT INTO yreNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Zozi -a -tɔ 'nan 'e 'wɩ pɛɛnɔn 'lɛ sɔɔ, ɛn e 'nan \"mɛn 'nan: «'Yi dra 'an -tɛa.» Zɩ 'wɩ nɛn 'e 'crɛn -tɛdɩ bɛ 'e 'lɛ sɔɔ zɩɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","-Wɛn 'wlɛ nɛn e -fɔla -trilii bɛ, -a -pɔ -tʋ a 'sounjanun 'bɔ 'lɔ -wee mlinvɛ -a. Ɛn o sɔ -tʋ 'si, waa 'fɔ -wɛn zɩɛ -a, waa yrɩ -cɛan \"nɛn, ɛn waa -tɔ -a 'lɛbo \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Zɩ Zozi cɛɛn -a flɔndɩ man \"ji \"bɛ, ɛn e 'nan: «'Wɩ pɛɛnɔn 'e 'lɛ sɔɔ \"mɛn.» -A -nan nɛn 'e 'wulo -fɔ 'e 'wlu, ɛn 'e yiɛ 'lɛ 'wʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","'Yaa yi da nɛn, ɛn Zuif 'nɔn 'tanɔn 'kʋ Pilati trʋ 'balɛ 'nan minnun nɛn o o -pɛin yiba \"plan da bɛ, o o cɛin \"yee -e 'o o 'si 'nan. Waa drɛ zɩɛ, kɔɔ -te tʋ cɛɛn bɛ, -wee 'flinla \"yi nɛn, ɛn o 'ka \"vale min -kadɩ 'e 'fʋ 'e 'padɩ yiba \"plan da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pilati 'sounjanun 'pa 'sia 'nan 'o 'kʋ -a drɛ. Zɩ 'o 'bɔla 'nan nun bɛ, ɛn min \"fli \"nɛn o o pɛin Zozi \"srɔn \"bɛ, waa -tʋ cɛin \"fli yee, ɛn waa -tʋ cɛin \"fli yee. ");
INSERT INTO yreNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","O 'bɔ Zozi da, ɛn waa 'yɩ 'nan e ya 'e 'kadɩ -yee \"wɛan wa'a cɛin \"yeelɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","'Pian 'sounja min -tʋ Zozi 'fɔn 'e 'sɛan da 'yee -tin -a. 'Nun tɔɔn 'yi -sran, ɛn nyɛn -sran. ");
INSERT INTO yreNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Min 'bɔ nɛn e 'wɩ 'gʋɛ -a -nan 'yɩ bɛ, -a san 'bɛ 'vɩ. Yaa 'vɩ 'nan -e 'ka 'bɔ \"nyian 'ka yi -tɛra \"da. 'Wɩ nɛn yaa 'vɩ 'gʋɛ, 'wɩ 'kpa nɛn, ɛn -a 'bɔ \"e -tɔa 'nan e ya 'wɩ 'kpa -a. ");
INSERT INTO yreNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","'Wɩnun 'bɔ zɩɛ e drɛ 'nan -e Bali wei nɛn 'e 'crɛn -tɛdɩ bɛ 'e 'lɛ sɔɔ. E ya 'e 'crɛn -tɛdɩ 'nan: «-A 'wlɛ -tʋwli 'ka 'wia dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ɛn e ya \"nyian 'e 'crɛn -tɛdɩ fɛ pee -nan 'nan: «Min nɛn waa 'fɔn bɛ, -a lɛ nɛn min pɛɛnɔn yiɛ 'e 'fʋ.» ");
INSERT INTO yreNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Min -tʋ nɛn waa laabo Zozɛfʋ bɛ, e \"sia Arimate, Zozi -sruzan nɛn. 'Pian 'e \"klanman Zuif 'nɔn 'tanɔn 'lɔ 'le \"wɛan, e ya -a -sru 'e yɔɔdɩ. Zozɛfʋ -si trʋ 'ba Pilati -lɔ 'nan 'e Zozi pa -nɔn 'yrɛ -e 'e wʋ. Pilati -a -si -nɔn -yrɛ, ɛn e -kʋ Zozi 'kadɩ 'bɔ 'silɛa. ");
INSERT INTO yreNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛm nɛn yi -tʋ da e -kʋ Zozi 'va -pei -man bɛ, \"e \"ta wʋ \"nyian 'e 'lɔ le 'yile nɛn waa wo min pa man bɛ -a. 'Yile zɩɛ, e ya 'e baadɩ mire 'lee aloe -a, ɛn -a kilo a -fuba yaaga. ");
INSERT INTO yreNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","'O 'vale Zozɛfʋ -a, -wɛɛ Zozi pa yrɩ. O 'yile -sɛn sɔ ji ɛn waa drɛ 'a. Zɩ Zuif 'nɔn 'wee pa dra zɩɛ -e 'o wʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Fɛnan 'bɔ nɛn o Zozi pɛin yiba \"plan da bɛ, fei -tʋ a -a \"srɔn. Fei zɩɛ -a da bɛ, min -yrɛ nɛn waa cɛɛn -kɔlɛ -ji bɛ -a -tʋ a -nan. -Yrɛ zɩɛ wa'a tian min wʋlɛ \"ji \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","-A 'bɔ 'ji nɛn o Zozi 'wʋ. Zuif 'nɔn 'le 'flinla \"yi a -tanan bɔdɩ -a, ɛn -yrɛ 'bɔ a \"nyian -kogo -yee \"wɛan -a ji nɛn o Zozi 'wʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","'Mɔnnɛn yi da, bodrun puunɔn, te klunglun 'nɛn a tian, ɛn Madala lɩ Mari -kʋ Zozi -yrɛ da. -Kɔlɛ nɛn o -yrɛ 'bɔ 'lɛ 'wʋ 'a bɛ, yaa 'yɩ 'e 'sidɩ \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mari 'li 'e da flan -a, ɛn e -kʋ e 'bɔ Simɔn Piɛri 'lee Zozi -sruzan 'tʋ nɛn Zozi -a ye \"yi \"bɛ o man, ɛn e 'nan -wlɛ 'nan: «O Minsan pa 'si 'yrɛ -ji, ɛn fɛnan nɛn o kʋ -a bɛ kʋ'a tɔa dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piɛri 'lee Zozi -sruzan zɩɛ o 'bɔla ɛn o -kʋ -yrɛ da. ");
INSERT INTO yreNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","O \"flinɔn 'ko flan -a, 'pian min -tʋ bɛ, e flan bli e mlin Simɔn Piɛri da. -Yɛɛ 'bɔla -yrɛ da 'e 'flin. ");
INSERT INTO yreNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","'Pian ya'a -wlalɛ -nan nun dɩ, e 'kunnan ɛn 'e yiɛ 'tɔ -yrɛ 'bɔ 'ji. Sɔnun nɛn waa 'pa Zozi man bɛ yaa 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔn Piɛri 'bɔla -yee -sru, ɛn \"bɛ wla 'wʋ 'yrɛ 'bɔ 'ji nun. E sɔnun nɛn waa 'pa Zozi man bɛ -a 'yɩ 'e -srandɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sɔ nɛn waa -tɔ Zozi 'wulo -man bɛ, yɛɛ 'yɩ 'e -srandɩ 'e 'to, te e ya 'e plindɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ɛn Zozi -sruzan nɛn e 'bɔla paan 'e tɛdɛ bɛ, \"e wla 'wʋ \"nyian -yrɛ 'bɔ 'ji nun. Zɩ yaa -nan 'yɩ bɛ, ɛn e yi -tɛra \"da 'nan Zozi wluan -kanɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tʋ zɩɛ -a wlu bɛ, te 'wɩ nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji 'nan: Zozi -kaa -e 'e 'wluan -kanɔn 'va bɛ, -a -srunɔn 'ka tian -a -ci manlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Zozi -srunɔn \"fli \"bɛ, o 'li 'o da 'wee vɛ -nan. ");
INSERT INTO yreNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ɛn Mari \"e fʋʋ 'e 'tɔdɩ -yrɛ 'bɔ \"srɔn, te e -wua. E ya -wuɔnan ɛn e 'kunnan 'e yiɛ 'tɔ -yrɛ -ji nun. ");
INSERT INTO yreNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ɛn e Bali -le 'pasianɔn nɛn laji bɛ o \"fli 'yɩ 'o 'ta le sɔ 'fuvu 'a fɛnan nɛn o Zozi pa 'pla bɛ -a -nan. -A -tʋ a 'e -nyrandɩ -a -wulo -man zia, ɛn -a -tʋ a 'e -nyrandɩ -a cɛin -man zia. ");
INSERT INTO yreNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bali -le 'pasianɔn -a laabʋ lɩ zɩɛ -yrɔ 'nan: «-Mɛ \"le \"wɛan nɛn i ya -wuɔnan?» Ɛn lɩ bɛ e -wlɛ 'nan: «Minnun 'an 'san pa 'si 'yrɛ -ji, ɛn fɛnan nɛn waa 'pla bɛ ma'an tɔa dɩ, -yee \"wɛan an ya -wuɔnan.» ");
INSERT INTO yreNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","E 'wɩ zɩɛ -a 'vɩ, \"yɛɛ vɩnan 'e man lila, te e min -tʋ ye 'e 'tɔdɩ. Min zɩɛ Zozi nɛn, 'pian ya'a -tɔlɛ 'nan Zozi nɛn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ɛn Zozi 'bɔ -a laabʋ -yrɔ 'nan: «-Mɛ \"le \"wɛan nɛn i ya -wuɔnan? -Tɩ nɛn yia -wɛɛman?» Mari -a nrɔn 'e 'ji 'nan min nɛn e 'nyranman \"paa fei 'bɔ da bɛ -nyrɛn. Ɛn e 'nan -yrɛ 'nan: «'An 'san, -te yiɛ 'si 'yrɛ -ji bɛ, fɛnan nɛn yia 'pla bɛ, 'i vɩ 'mɛn -e 'an 'kʋ -a 'sia.» ");
INSERT INTO yreNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ɛn Zozi -a laabʋ: «Mari!» Mari 'e man lila, ɛn yaa 'vɩ -yrɛ Ebre wei -ji 'nan: «Rabuni!» -A -ci nɛn 'nan Bali -le 'wɩ \"paazan. ");
INSERT INTO yreNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Zozi \"e -yrɛ 'nan: «Te 'i klɛ 'an man dɩ! Ma'an tian 'kʋlɛ 'an \"tɩ 'va dɩ. 'I 'kʋ -a vɩ 'an \"bʋɩnun lɛ 'nan: ‹An \"ta -ko 'an \"tɩ 'va, e ya 'ka \"tɩ \"a. An \"ta -ko 'mɛn Bali va, e ya 'cee Bali -a.› » ");
INSERT INTO yreNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ɛn Madala lɩ Mari -kʋ -a vɩlɛ Zozi -srunɔn lɛ. Yaa 'vɩ -wlɛ 'nan 'e Minsan 'yɩ, ɛn e 'wɩ nɛn Zozi -a 'vɩ -yrɛ \"bɛ, -a tin 'ba -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","'Mɔnnɛn yi 'bɔ 'lein zɩɛ -a funninmlan, ɛn Zozi -srunɔn 'o cin 'yɩ 'kɔn 'tʋ -ji. 'Kɔn zɩɛ waa -fɔ -ji, o ya \"klannan Zuif 'nɔn 'tanɔn 'lɔ 'le \"wɛan. 'Nun tɔɔn, ɛn Zozi 'bɔla o va, e -tɔ o yei, ɛn e -wlɛ 'nan: «Bali 'e 'fʋdɩ -trɔɔ -nɔn 'cɛɛ!» ");
INSERT INTO yreNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","E 'wɩ zɩɛ -a 'vɩ, ɛn 'e -pɛlanun kɔɔn -wlɛ 'lee 'e 'sɛan da. Zɩ o Minsan 'yɩ bɛ, o 'ci nran. ");
INSERT INTO yreNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ɛn Zozi -a 'vɩ \"nyian -wlɛ 'nan: «Bali 'e 'fʋdɩ -trɔɔ -nɔn 'cɛɛ! Zɩ 'an \"tɩ 'an 'pa 'sia bɛ, -a da nɛn 'an 'bɔ \"nyian \"an 'ka \"paa -sia.» ");
INSERT INTO yreNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","E cɛɛn 'wɩ zɩɛ -a vɩdɩ man, tɔɔn ɛn 'e 'le fulɔ fɛɛn o man, ɛn yaa 'vɩ -wlɛ 'nan: «Bali lei 'saun nɛn bɛ, e ya 'cee vɛ -a, 'ka 'si. ");
INSERT INTO yreNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Minnun nɛn o 'wɩ 'wlidɩ drɛ, ɛn kaa 'vɩ 'nan -wee 'wɩ 'wlidɩ fui bɛ, te Bali -wee 'wɩ 'wlidɩ fui. Ɛn -te ka'a -wee 'wɩ 'wlidɩ \"fuilɛ dɩɛ, Bali 'ka -wee 'wɩ 'wlidɩ 'fuiman dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tʋ zɩɛ -a wlu bɛ, -a -sruzan 'tʋ nɛn waa laabo Toma bɛ, te e 'ka 'nan dɩ. Waa laabo \"nyian \"flɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Zɩ e -ta bɛ, ɛn Zozi -srunɔn -mienun -a 'vɩ -yrɛ 'nan: «Kʋ Minsan 'yɩ.» Ɛn e 'nan -wlɛ 'nan: «-Te ma'an tian -a -pɛ nɛn waa pɛin bɛ -a \"pa 'ji yɩlɛ dɩɛ, ma'an yi 'tɛala \"da 'mlɔnmlɔn dɩ. 'An 'pɛ 'wlɛ -tɔala -a \"pa 'ji, ɛn 'an 'pɛ \"paa -a 'sɛan 'ji 'vaa, ɛn an yi -tɛala 'wɩ nɛn kaa 'vɩ 'gʋɛ -a da.» ");
INSERT INTO yreNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yi 'sɔra \"bɛ -sru, Zozi -srunɔn a 'o cin yɩdɩ \"nyian 'kuin, te Toma a 'siɛn o va. 'Kɔn 'bɔ -kpɛinnun a 'e 'fɔdɩ -ji, 'nun tɔɔn ɛn Zozi bɔla o va, e -tɔ o yei ɛn e 'nan -wlɛ 'nan: «Bali 'e 'fʋdɩ -trɔɔ -nɔn 'cɛɛ.» ");
INSERT INTO yreNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ɛn Zozi -a 'vɩ Toma lɛ 'nan: «'An -pɛlanun nɛn 'gʋ, 'i -pli 'i -pɛ 'wlɛ 'a 'gʋ, ɛn 'i 'pɛ 'pa \"nyian 'an 'sɛan 'ji. 'I yi -tɛra \"da, te 'i 'ci -fɔɔ \"nyian dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma \"e -yrɛ 'nan: «Yiɛ cɩ 'an 'san -a, ɛn yiɛ cɩ 'mɛn Bali -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ɛn Zozi -a 'vɩ -yrɛ \"mɛn 'nan: «Yian 'yɩ, -yee \"wɛan nɛn i yi -tɛra 'an da. Minnun nɛn o yi -tɛala 'an da te wa'a 'an yɩlɛ dɩɛ, Bali -le -fɛa a o man.» ");
INSERT INTO yreNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zozi 'lɛbo \"fɔ wɩ \"kaga drɛ 'e -srunɔn yiɛ man, te 'bɛ 'ka 'e 'crɛn -tɛdɩ 'fluba 'gʋɛ -a -ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","'Pian 'wɩnun nɛn 'gʋɛ, wɛɛ 'crɛn -tɛ 'nan -e 'ka yi -tɛra \"da 'nan min nɛn Bali -a 'si \"va, ɛn e ya Bali -pɩ -a bɛ Zozi nɛn. -Te ka yi -tɛra Zozi da bɛ, 'belidɩ nɛn ya'a 'nyaan dɩɛ, e dra 'cee vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","\"Bɛ -sru ɛn Zozi 'e 'fli kɔɔn 'e -srunɔn lɛ \"nyian 'yi nɛn waa laabo Tiberia bɛ -a man. Zɩ 'e 'fli kɔɔn -wlɛ \"bɛ, -a -nan wɩ nɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Yi -tʋ da te -a -srunɔn a 'o cin yɩdɩ. Simɔn Piɛri, 'lee Toma nɛn waa laabo \"nyian \"flɛn bɛ, 'lee Natanaɛl nɛn 'e \"sia 'fla nɛn waa laabo Kanan bɛ -a da Galile 'lɛglɔn 'ji bɛ, 'lee Zebede -pɩnun 'lee Zozi -srunɔn \"fli \"pee 'bɛ cɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ɛn Simɔn Piɛri -a 'vɩ -wlɛ 'nan: «An \"ta -ko pɔ -tɛlɛ.» O 'nan -yrɛ 'nan: «'Kʋ 'bɔ \"nyian, \"kʋ -koo 'i -sru.» O -kʋ, ɛn o -fɔ -klʋ -ji. -Pei zɩɛ -a man bɛ, wa'a pɔ -tɛlɛ 'mlɔnmlɔn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tʋ \"ɛ vɩnan 'e 'cɛn bodrun, te Zozi a 'e 'tɔdɩ 'yi 'plo da. 'Pian Zozi -srunɔn 'ka -a -tɔlɛ \"le Zozi nɛn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ɛn Zozi -a laabʋ -wlɔ 'nan: «-Gobonun, ka pɔ \"tiɛnnɛn 'yɩ?» O 'nan -yrɛ 'nan: «-Cɛjɛ, kʋ'a -vɛ -tɛlɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ɛn Zozi \"e 'nan -wlɛ 'nan: «'Ka 'cee \"se 'wɛɛn -klʋ 'bɔ -pɛ \"yi \"da zia, pɔ -sɛan \"ji.» Waa drɛla \"da, ɛn pɔ \"kaga \"sɛn -wee \"se \"ji, -yee \"wɛan wa'a -kɔlalɛ \"nyian \"se zɩɛ -a -klandɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","-A -nan nɛn Zozi -sruzan 'tʋ nɛn Zozi -a ye \"yi \"bɛ, e 'nan Piɛri lɛ 'nan: «Minsan nɛn!» Zɩ Simɔn Piɛri -a 'man 'nan Minsan nɛn bɛ, ɛn e 'yee sɔ nɛn yaa wo sɔ ta lou \"bɛ -a 'sia, yaa 'wʋ 'e man, ɛn e -fɔ 'yi 'va 'nan -e 'e 'kʋ 'yi 'plo man. E sɔ zɩɛ -a 'sʋ 'e man 'nyranman 'padɩ -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Zozi -srunɔn -mienun bɛ, \"o \"ta 'wʋla 'klʋ -ji, te o -taa \"se \"nɛn 'e fadɩ pɔ -a bɛ -a -klandɩ -a 'o -sru. Fɛnan nɛn o 'si bɛ, -a -nan bɔa -mɛnliɛ -fuba 'soolu. ");
INSERT INTO yreNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Zɩ o sɔɔnla 'klʋ -ji bɛ, ɛn o 'tɛ 'yɩ 'e 'sɔndɩ, te pɔ a \"da 'e 'padɩ, ɛn 'kpɔun a -a \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ɛn Zozi \"e 'nan -wlɛ 'nan: «Pɔ nɛn kaa -tɛ bɛ, 'ka 'ta -a -mie -a.» ");
INSERT INTO yreNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simɔn Piɛri -fɔ -klʋ -ji, ɛn e \"se \"nɛn 'e fadɩ pɔ -dandan -a bɛ -a klan 'yi 'plo man. Pɔ a \"se 'bɔ 'ji \"kaga, -a -yaa tʋ -fuba 'soolu 'wlɛ yaaga bɔa, 'pian ya'a 'fʋɩ bʋlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ɛn Zozi -a 'vɩ -wlɛ 'nan: «'Ka 'ta fɛnun -blɩ!» -A -srunɔn 'bɔ 'tʋ 'ka -kɔlalɛ -a laabʋdɩ -a -yrɔ 'nan -tɩ nɛn dɩ. Kɔɔ o pɛɛnɔn -a -tɔ 'nan Minsan 'bɔ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Zozi pli o \"srɔn, e 'kpɔun 'sia, yaa pli o man, ɛn e pɔ 'sia, yaa pli o man. ");
INSERT INTO yreNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Zozi 'fli -kɔɔndɩ 'e -srunɔn lɛ te 'e wluan -kanɔn 'va bɛ, -a 'pa yaagazan nɛn zɩɛ. ");
INSERT INTO yreNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Zɩ o cɛɛn fɛnun -blɩdɩ man bɛ, ɛn Zozi -a laabʋ Simɔn Piɛri -lɔ 'nan: «Zan -pɩ Simɔn, yian ye \"yi e \"mlian 'i bɔɛnun 'gʋɛ -wee 'an yɩdɩ \"yi \"da?» Simɔn \"e -yrɛ 'nan: «-Inyan, Minsan, yia -tɔa 'nan mɛin ye \"yi.» Ɛn Zozi \"e -yrɛ 'nan: «'I yiɛ 'tɔ 'mɛn 'bla 'nɛnnun va!» ");
INSERT INTO yreNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Zozi -a 'pa \"flizan laabʋ -yrɔ. E 'nan: «Zan -pɩ Simɔn, yian ye \"yi?» Piɛri \"e -yrɛ 'nan: «-Inyan, Minsan, yia -tɔa 'nan mɛin ye \"yi.» Ɛn Zozi \"e -yrɛ 'nan: «'I yiɛ 'tɔ 'mɛn 'blanun va!» ");
INSERT INTO yreNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Zozi -a 'pa yaagazan laabʋ \"nyian -yrɔ. E 'nan: «Zan -pɩ Simɔn, yian ye \"yi?» Ɛn Piɛri ta drɛ 'trɔdrɔ, kɔɔ e 'wɩ -tʋwli laabʋ -yrɔ 'e cin -sru 'e 'pa -a yaaga. Ɛn Piɛri -a 'vɩ -yrɛ 'nan: «Minsan, i 'wɩ pɛɛnɔn tɔa. Yia -tɔa 'nan mɛin ye \"yi.» Ɛn Zozi -a 'vɩ -yrɛ 'nan: «'I yiɛ 'tɔ 'mɛn 'blanun va! ");
INSERT INTO yreNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Maan ve yiɛ 'wɩ tɩglɩ 'a 'nan: Tʋ nɛn te i ya \"wɛnnɔn bɛ, yiɛ 'i -tiɛn -tɔa 'i 'bɔ 'a -e 'i 'kʋ fɛnan nɛn i cɩ \"va \"bɛ -a -nan. 'Pian tʋ nɛn i dra ceje bɛ, min pee 'bɛ 'i -yrɩman -e 'e 'kʋ 'yia fɛnan nɛn i 'ka \"va \"dɩɛ -a -nan.» ");
INSERT INTO yreNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Zɩ Piɛri -taa \"kalɛ -e 'e Bali 'tɔ drɛ -dan bɛ, -a da -kɔnnɛn \"nɛn Zozi -a -fɔ. E cɛɛn 'wɩ zɩɛ -a vɩdɩ man, ɛn e 'nan Piɛri lɛ 'nan: «'I -sɔɔnla 'an -sru!» ");
INSERT INTO yreNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piɛri 'e 'man 'lila, ɛn 'e yiɛ 'tɔ 'o -sru, te e Zozi -sruzan nɛn Zozi -a ye \"yi 'kpa bɛ -a ye. -A -sruzan zɩɛ, -yɛɛ tɛɛn yi -tʋ da Zozi 'pɛ -ji, te o ya fɛnun -blɩnan, ɛn yaa laabʋ -yrɔ 'nan: «Minsan, -tɩɛ \"ta 'i -nɔan 'i 'nanmannɔn lɛ?» ");
INSERT INTO yreNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Zɩ Piɛri -a 'yɩ bɛ, ɛn yaa laabʋ Zozi 'lɔ 'nan: «Minsan, min 'labɛ \"nun, -mɛ \"wɩ 'bɛ bɔa -yee \"man?» ");
INSERT INTO yreNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ɛn Zozi -a 'vɩ -yrɛ 'nan: «-Te an ya \"va 'nan 'e 'fʋ -trilii -e 'an 'tadɩ 'e bɔ bɛ, 'yie 'wɩ 'tʋ 'ka 'ji dɩ. 'I 'bɔ, 'i -sɔɔnla 'an -sru.» ");
INSERT INTO yreNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","\"Wɩ zɩɛ e fuila \"man \"bʋɩnun yei 'nan Zozi -sruzan zɩɛ, ya'a 'li 'kaa 'mlɔnmlɔn dɩ. 'Pian Zozi 'ka -a vɩlɛ Piɛri lɛ 'nan ya'a 'kaa dɩ. Zozi \"e 'vɩ 'nan: «-Te an ya \"va 'nan 'e 'fʋ -nan -trilii -e 'an 'tadɩ 'e bɔ bɛ, 'yie 'wɩ 'tʋ 'ka 'ji dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Zozi -sruzan zɩɛ, -yɛɛ cɩ 'wɩnun 'gʋɛ -a -nan yɩzan -a, ɛn -yɛɛ crɛn -tɛ. Kʋa -tɔa 'nan 'wɩnun nɛn yaa 'vɩ bɛ 'wɩ 'kpa nɛn. ");
INSERT INTO yreNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zozi 'wɩ \"kaga \"pee drɛ \"nyian. -Te waa pɛɛnɔn 'crɛn -tɛ paan bɛ, 'an 'ci \"nrɔnman 'nan -a 'flubanun 'bɔ 'ka 'sɔa 'trɛ 'gʋɛ -a da \"fo \"dɩ.");
INSERT INTO yreNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","'Tɩɩ Teofil, 'mɛn 'fluba tɛdɛ -ji bɛ, Zozi 'le 'wɩ nɛn yaa drɛ 'lee yaa paa minnun ji bɛ, maan crɛn -tɛdɩ 'sia 'e pou sianan \"trilii, ");
INSERT INTO yreNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ɛn e 'bɔ yi nɛn Bali -a 'si bɛ -a. Te e \"ta -ko laji bɛ, -yee 'wɩ nɛn 'kɔ 'o 'ta wʋla \"da \"bɛ, yaa paa 'yee 'pasianɔn nɛn, e o 'si \"va \"bɛ, o ji Bali lei 'saun -le 'plɛblɛ 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Zɩ -yee yra yɩdɩ tʋ -nyan bɛ, o lɛ nɛn 'e 'fli kɔɔn 'e 'pa -a \"kaga. Yaa -ci kɔɔn -wlɛ 'nan, 'e yiɛ a \"man. 'E 'fli kɔɔn -wlɛ yi -fuba sinjɛn wlu te e Bali -le mingɔnnɛn -blɩdɩ 'wɩ ve -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yi -tʋ da te Zozi a o yei \"bɛ, ɛn e 'nan -wlɛ 'nan: «Te 'ka 'si Zeruzalɛm dɩ! Bali lei 'saun nɛn maan 'nan 'an -nɔan 'cɛɛ bɛ, 'kaa man -pɛn! ");
INSERT INTO yreNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Zan \"e \"min -batize drɛ 'yi 'a, 'pian 'cee vɛ bɛ, tʋ -fʋ \"wɛnnɔn -e Bali 'e \"cee -batize drɛ 'yee lei 'saun 'a.» ");
INSERT INTO yreNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ɛn minnun nɛn Zozi \"srɔn \"bɛ, waa laabʋ Zozi 'lɔ 'nan: «Minsan, tʋ zɩɛ -a man nɛn Izraɛl 'nɔn dra 'yie mingɔnnɛn trɛdanɔn 'a?» ");
INSERT INTO yreNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Zozi \"e -wlɛ 'nan: «'An \"tɩ 'ka 'si -nɔnlɛ 'nan -e \"ka \"tɔ dɩ, -a 'bɔ 'tʋwli 'bɛ yi 'lee tʋ nun zɩɛ -a 'pla. ");
INSERT INTO yreNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ɛn Bali lei 'saun -taa 'ka da, e 'plɛblɛ -nɔan 'cɛɛ, -e 'ka drɛ 'mɛn 'wɩ 'nan yɩnɔn 'a. Ka 'mɛn 'wɩ ve Zeruzalɛm, 'lee Zude 'lɛglɔn pɛɛnɔn 'ji 'lee Samari 'lɛglɔn 'ji 'lee 'trɛ pɛɛnɔn da.» ");
INSERT INTO yreNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Zɩ Zozi cɛɛn 'wɩ zɩɛ -a vɩdɩ man bɛ, ɛn e wluan laji. O yiɛ a -a -sru ɛn \"lolu -koei -a -sru 'san -wlɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","O yiɛ yra tian -a -sru laji, ɛn min \"fli 'bɔla 'ji o va kligli 'o 'ta le sɔ 'fuvu 'a, ɛn o 'nan -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«Galile 'nɔn, -mɛ \"le \"wɛan nɛn ka ya 'ka 'tɔdɩ te 'ka yiɛ a laji? Bali Zozi 'si 'ka yei, ɛn e -kʋ -a laji. E -ta pee wo \"le zɩ kaa 'yɩ 'kʋnan bɛ, -yee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","-A -nan nɛn Zozi 'le 'pasianɔn 'si Olivie pɔn da, ɛn o 'li 'o da Zeruzalɛm. Pɔn zɩɛ e 'ka Zeruzalɛm man -kɔɔbli \"bʋʋ \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Zɩ o 'bɔla Zeruzalɛm bɛ, ɛn o -kʋ 'kɔn \"bʋ \"tʋ -ji 'kɔn 'ta lou. 'Kɔn 'bɔ zɩɛ, -a -ji nɛn 'o cin ye 'e 'cɛn. Piɛri 'lee Zan 'lee Zaji 'lee Andre 'lee Filipʋ 'lee Toma 'lee Batelemi 'lee Matie 'lee Alife -pɩ Zaji 'lee Simɔn nɛn waa laabo \"nyian Zelo bɛ, 'lee Zaji -pɩ Zude, 'bɛ cɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","O 'ci a -tʋwli, ɛn o pɛɛnɔn Bali trʋ \"baa 'kɔn zɩɛ -a -ji tʋ pɛɛnɔn man. -Wɛɛ cɩ 'o 'vale lɩmɔn -mienun 'lee Zozi \"bʋ Mari 'lee Zozi \"bʋɩnun -a. ");
INSERT INTO yreNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Yi -tʋ da, minnun nɛn o yi -tɛala Zozi da bɛ, 'o cin 'yɩ. O ya min -yaa tʋ -yɔ -tʋ (120). Piɛri wluan lou, ɛn e 'nan -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«\"Bʋɩnun, 'wɩ nɛn 'e 'crɛn -tɛdɩ Zudazi man bɛ 'e 'lɛ sɔɔ. Bali lei 'saun Zudazi -le 'wɩ 'bɔla David 'le 'nan, Zudazi 'bɛ -si -kɔɔnmlan Zozi 'kunnɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","E ya \"nɛn -kaa 'va, ɛn -cɛɛ 'nyranman -tʋwli 'pa waa. ");
INSERT INTO yreNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","\"Lala nɛn waa -pan 'wʋ 'a, 'nan -e 'e Zozi -kɔɔn \"bɛ, e fei -tʋ 'lɔ 'a. 'Pian -a fei 'bɔ da nɛn e -ka. -A -pɔn fɛa, ɛn -a -pɔan wɛɛn bei. ");
INSERT INTO yreNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Zeruzalɛm 'nɔn pɛɛnɔn 'wɩ zɩɛ -a 'man, -yee \"wɛan nɛn o fei zɩɛ -a 'tɔ 'pa 'o wei -ji 'nan: ‹Akɛldama›, -a -ci nɛn 'nan: ‹nyɛn fei›. ");
INSERT INTO yreNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ɛn e ya 'e 'crɛn -tɛdɩ \"dre 'fluba 'ji 'nan: ‹-Yee 'kuin 'e 'fʋ 'e \"tun. Te min -tʋ 'e 'nyran ji dɩ.› Ɛn e ya \"nyian 'e 'crɛn -tɛdɩ -ji 'nan: ‹Min pee 'e \"pa 'ji nyranman 'pa.› ");
INSERT INTO yreNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Zɩ Zan Zozi -batize drɛ, -trilii -e 'e 'bɔ yi nɛn Bali -a 'si -kaa yei \"bɛ -a man bɛ, minnun nɛn o -ko -kaa 'palɛ fɛ pɛɛnɔn 'nan te Minsan Zozi a -kaa 'va bɛ, -kaa o -tʋ -tɔ -a \"pa 'ji. -Kaa min -tʋ 'si o yei, -e 'e 'pa -kaa 'va, -e 'e drɛ Zozi 'le wluandɩ -kanɔn 'va -nan yɩzan -tʋ -a.» ");
INSERT INTO yreNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","-A -nan nɛn o min \"fli kɔɔn, -a -tʋ 'tɔ nɛn Matias, ɛn -a -tʋ 'tɔ nɛn Zozɛfʋ. Waa laabo \"nyian Barsaba, -te bɛ \"cɛɛ dɩ Zuti. ");
INSERT INTO yreNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tɔɔn ɛn o Bali trʋ 'ba, o 'nan: «Minsan, 'i 'bɔ nɛn, i min pɛɛnɔn souba ji ye bɛ, min \"fli 'gʋɛ o yei \"bɛ, min nɛn yia 'si \"va \"bɛ, 'i -kɔɔn 'kʋɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Zudazi 'si 'kʋ 'va, ɛn e -kʋ -a -nan nɛn kɔ 'e 'kʋ bɛ -a -nan. Min \"fli 'gʋɛ o yei \"bɛ -tɩɛ \"pa 'ji nyranman \"paa?» ");
INSERT INTO yreNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ɛn o 'lein 'wlɛ tuʋla o 'tɔ da. Matias da nɛn e -tria, ɛn e 'pa Zozi 'le 'pasianɔn 'fuda -tʋ bɛ o va. ");
INSERT INTO yreNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","\"Fɛdi -tʋ nɛn waa laabo Pantekɔt bɛ -a yi da, te minnun pɛɛnɔn nɛn o yi -tɛra Zozi da bɛ, o ya 'o cin yɩdɩ 'wee Bali trʋ 'banan 'cɛn 'nan. ");
INSERT INTO yreNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","'Nun tɔɔn ɛn fɛ -tʋ -cin 'wɩdɩ 'plɛblɛ 'si laji. 'E 'cin wɩɩ \"le fulɔ 'plɛblɛ 'bɛ cɩ \"fɛɛnnan. -A -cin 'wɩdɩ zɩɛ, e 'kɔn nɛn o cɩ o -nyrandɩ -ji bɛ -a -ci 'si. ");
INSERT INTO yreNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Fɛnun o 'fli kɔɔn -wlɛ \"le 'tɛ nrɛn -le 'wɩ 'zʋ, te o \"siiman 'e cin man. 'Tɛ nrɛn zɩɛ, e sɔɔn o -tʋdʋ pɛɛnɔn da. ");
INSERT INTO yreNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bali lei 'saun 'ta o pɛɛnɔn da 'nun, ɛn o 'wɩdɩ 'sia wei peenun -ji. Bali lei 'bɛ 'wɩ zɩɛ -a 'pa o 'le. ");
INSERT INTO yreNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yi 'bɔ 'lein zɩɛ -a da bɛ, minnun nɛn o \"sia 'trɛda fɛ pɛɛnɔn 'nan te o 'ta wʋla Moizi -le -pei da tɩglɩ bɛ, o ya Zeruzalɛm. ");
INSERT INTO yreNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Zɩ o fɛ -cin 'wɩdɩ zɩɛ -a 'man bɛ, ɛn o -kʋ 'o cin yɩlɛ -nan. 'Wɩ o 'kan 'e 'ciɩla \"da, kɔɔ minnun zɩɛ te o ya 'wɩnan bɛ, min -tʋ \"e 'e 'bɔ fla wei 'man. ");
INSERT INTO yreNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","'Wɩ o 'kan, ɛn 'wɩ nɛn kɔ 'o yɩ 'o 'vɩ bɛ, wa'a tɔa dɩ, te waa ve 'nan: «Minnun nɛn o \"we 'labɛ, Galile 'nɔn nɛn waa 'o pɛɛnɔn, ");
INSERT INTO yreNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ɛn e drɛ \"mɛn 'kɔ 'lɔɔ, ɛn o \"we -kaa wei -ji te -kaa maan? ");
INSERT INTO yreNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","-Kaa \"sia Part 'trɛda. Ɛn -kaa -mie \"sia Medi 'trɛda 'lee Elam 'trɛda. Ɛn -kaa -mie \"sia Mesopotami 'trɛda 'lee Zude 'trɛda 'lee Kapadɔs 'trɛda 'lee Pɔnt 'trɛda 'lee Azi 'trɛda. ");
INSERT INTO yreNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ɛn -kaa -mie \"sia Pirigi 'lee Panfili 'trɛda. Ɛn -kaa -mie \"sia \"nyian Ezipti 'trɛda. Ɛn -kaa -mie \"sia \"nyian Sirene 'trɛda Libi 'nɔn 'va. Ɛn -kaa -mie \"sia Rɔm 'nɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","-Kaa -mie a Crɛt 'nɔn 'a, ɛn -kaa -mie a Arabi 'nɔn 'a. Ɛn Zuif 'nɔn a -kaa yei, ɛn min -mienun nɛn o yi -tɛala Zuif 'nɔn 'le Bali da bɛ o ya -kaa yei. Ɛn -kaa -tʋdʋ pɛɛnɔn -kaa fla wei maan, te minnun zɩɛ o ya 'wɩ -dandan nɛn Bali -a drɛ bɛ -a vɩnan.» ");
INSERT INTO yreNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","'Wɩ o pɛɛnɔn 'kan 'e 'ciɩla \"da, ɛn 'wɩ nɛn kɔ 'o yɩ 'o vɩ bɛ, wa'a tɔa dɩ, te waa laabo 'o cin lɔ 'nan: «'Wɩ zɩɛ 'bɛ 'ci bɛ cɩ 'nɔn?» ");
INSERT INTO yreNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","'Pian te min -mienun o sɛɛ wo, -a vɩdɩ -a 'nan: «-Wɛn o -tɛa 'e 'ciɩladɩ \"da.» ");
INSERT INTO yreNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piɛri 'lee Zozi 'le 'pasianɔn 'fuda -tʋ -tɔ lou, ɛn Piɛri -a 'vɩ o yei wei 'plɛblɛ 'ji minnun pɛɛnɔn lɛ 'nan: «Zuif 'nɔn, 'lee 'ka pɛɛnɔn nɛn ka cɩ Zeruzalɛm 'gʋ, 'wɩ 'gʋɛ 'ka man, ɛn 'ka \"trɔɛn \"tɔ 'an wei lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Te 'ka vɩ zɩɛ dɩ! Minnun 'gʋɛ, -wɛn \"cɛɛ o -tɛa \"dɩ. Bodrun nɛn tian, wa'a -wɛn mlinlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","'Pian 'wɩ nɛn Bali 'lewei vɩzan Zoɛl -a 'vɩ bɛ, -yɛɛ cɩ drɛnan. ");
INSERT INTO yreNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yaa 'vɩ 'nan: ‹Bali \"e 'nan, tʋ -fɔla \"da \"ji bɛ, an -taa 'mɛn lei 'saun 'a minnun da. 'Cee 'nɛn 'klɔnmɔnnun 'lee 'cee 'nɛn lɩmɔnnun Bali 'lewei ve. Bali fɛnan -kɔɔnman 'yiɛ -goei 'wein 'a 'cee -gobonun lɛ. Bali fɛnan -kɔɔnman nyrinvla min cejenun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","'Wɩ 'kpa, an -taa 'mɛn lei 'saun 'a -klɔnmɔn 'lee lɩmɔn pɛɛnɔn nɛn waan \"sua bɛ o da, tʋ zɩɛ -a man -e 'o Bali 'lewei vɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","An -cɛ -srɔn \"wɩnun dra laji lou, -e 'an 'lɛbo \"fɔ wɩnun drɛ 'trɛda. E -kɔan 'tɛ 'a, e -kɔan \"nyɛn -a, e -kɔan \"lolu -koei \"a. ");
INSERT INTO yreNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Klun -tɔala yidɛ yra, mlɛn dra 'tɛndɛn \"le nyɛn -zʋ, 'vaa -e Minsan -le yi -dan nɛn e \"bia bɛ, 'e bɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tʋ zɩɛ -a man bɛ, min nɛn e Minsan laabʋ bɛ, Minsan -a \"sia 'wɩ 'ji.› » ");
INSERT INTO yreNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ɛn Piɛri \"e 'nan \"nyian 'nan: «Izraɛl 'nɔn 'ka \"trɔɛn \"tɔ: Nazarɛtɩ min Zozi 'ta 'trɛda, -cɛ -srɔn \"wɩnun nɛn Bali ciɩla \"va, ɛn yaa drɛ bɛ, yaa -kɔɔnman 'wein 'nan Bali 'bɛ 'pa 'sia. ");
INSERT INTO yreNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ɛn o min 'bɔ 'nɔn 'cɛɛ 'nan 'ka -tɛ. Bali 'bɔ 'bɛ 'vɩ 'nan 'e drɛ zɩɛ, ɛn yaa -tɔa 'e 'cɛn 'nan e dra. Kaa -nɔn minnun nɛn wa'a Bali tɔa dɩɛ -wlɛ, ɛn waa -tɛ -a -pɛindɩ -a yiba \"plan da. ");
INSERT INTO yreNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","'Pian Bali -a wluan -kanɔn 'va, yaa 'si 'ka -lɔ, -yɛɛ cɩ 'nan ya'a 'kɔlaman -e 'e 'fʋ -ka -le 'plɛblɛ 'wlu dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ɛn mingɔnnɛn David 'wɩ 'gʋɛ -a 'vɩ 'e 'cɛn Zozi man. Yaa 'vɩ 'nan: ‹Maan -tɔa 'nan 'kʋ 'vale Minsan -a 'kʋɛ cɩ tʋ pɛɛnɔn man. E ya tʋ pɛɛnɔn man 'an \"srɔn te 'e 'klan \"sia 'an 'ji 'wɩ drɛnan. ");
INSERT INTO yreNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tʋ pɛɛnɔn man ci \"nrandɩ a 'an 'lɔ, ɛn an Bali 'tɔ bɔ \"dre -fɔa. Ɛn -te an -ka oo, Bali ci 'ka 'saan 'an man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","-Yɛɛ cɩ 'nan Bali 'ka 'an lei tʋe -ka -lɔ dɩ, ɛn ya'a 'e 'suzan 'tʋe -e 'e fʋlɩ -yrɛ -ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","-Si nɛn waa \"siala -e 'o 'belidɩ nɛn ya'a 'nyaan dɩɛ -a yɩ bɛ, yia kɔɔn 'mɛn, ɛn yie -kɔndɩ 'an \"srɔn \"le \"wɛan 'an 'ci \"nranman \"fo.› ");
INSERT INTO yreNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","\"Bʋɩnun, -si a 'e 'nɔndɩ 'mɛn -e 'an vɩ 'cɛɛ 'nan: -Kaa tra David -ka, waa 'wʋ, ɛn a -yrɛ a tian -kaa 'va 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","'Pian, e ya Bali 'lewei vɩzan -a \"nɛn, ɛn yaa -tɔa 'e 'cɛn 'nan Bali -tɔ 'e wei -da -a vɩdɩ -a 'yrɛ 'nan: ‹'E kluda min -tʋ 'e 'lɛji mingɔnnɛn -ble.› ");
INSERT INTO yreNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","'Wɩ nɛn Bali -a 'vɩ 'nan 'e dra bɛ, David -a -nan 'yɩ 'e 'cɛn -yee \"wɛan nɛn, e min 'sizan 'wɩ 'ji -le wluandɩ -kanɔn 'va wɩ 'vɩ 'vaa ɛn e drɛ. E 'nan: ‹Bali 'ka -a 'tʋɩlɛ -ka -lɔ dɩ, ɛn ya'a fʋlɩlɛ -yrɛ -ji dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Zozi 'bɔ nɛn an -yee 'wɩ ve 'gʋɛ, Bali -a wluan -kanɔn 'va, ɛn -kaa pɛɛnɔn -kaa ya -a -nan yɩnɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Bali -a -nyran 'e 'pɛ \"yi \"da, ɛn e lei 'saun nɛn e 'nan 'e -nɔan \"bɛ yaa -nɔn -yrɛ. -A lei 'saun 'bɔ zɩɛ ɛn Zozi 'ta -a 'kʋ da. -A 'bɔ nɛn ka cɩ -a -nan yɩnan, ɛn ka cɩ -a da weinun mannan 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","-Yɛɛ cɩ 'nan, David 'bɔ 'ka \"e -kʋʋlɛ laji dɩ, 'pian -a 'bɔ 'bɛ 'vɩ 'nan: ‹Bali -a 'vɩ 'an 'san lɛ 'nan, 'i -nyran 'an 'pɛ \"yi \"da, ");
INSERT INTO yreNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","-trilii -e 'mɛin 'nanmannɔn drɛ 'i 'cɛin -trɔa \"davɛ -a.› ");
INSERT INTO yreNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","-Yee \"wɛan 'ka Izraɛl 'nɔn pɛɛnɔn 'ka -ci -tɔ 'wein 'nan, Zozi nɛn kaa -tɛ -a -pɛindɩ -a yiba \"plan da bɛ, Bali -a drɛ Minsan -a, ɛn yaa drɛ 'trɛdanɔn pɛɛnɔn 'sizan 'wɩ 'ji Crizi -a.» ");
INSERT INTO yreNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Zɩ minnun nɛn -nan bɛ, o 'wɩnun zɩɛ -a 'man bɛ, -a 'wɩ wla o man. Ɛn waa laabʋ Piɛri 'lee Zozi 'le 'pasianɔn -mienun lɔ 'nan: «\"Bʋɩnun, \"kʋ \"dra \"mɛn 'kɔ?» ");
INSERT INTO yreNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ɛn Piɛri 'e 'nan wlɛ 'nan: «'Ka 'si 'wɩ 'wlidɩ \"drɛdɩ man, -e 'ka 'fli -nɔn Bali lɛ, -e o 'ka -tʋdʋ pɛɛnɔn -batize drɛ Zozi 'tɔ da, -e Bali 'e 'cee 'wɩ 'wlidɩ fui, -e 'e 'yee lei 'saun 'nɔn 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","-Yɛɛ cɩ 'nan, Bali -le 'wɩ nɛn yaa 'vɩ 'nan 'e dra bɛ, 'ka lɛ nɛn, ɛn 'cee 'nɛnnun lɛ nɛn, 'lee minnun pɛɛnɔn nɛn o ya tian -kɔɔbli ɛn Minsan nɛn -cee Bali -a bɛ, e \"ta -daa \"o laabʋlɛ bɛ, o lɛ nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ɛn Piɛri 'wɩ \"kaga \"pee 'vɩ \"nyian -wlɛ, -e 'o -tɔ 'nan 'wɩ 'kpa nɛn bɛ, e 'wɩ 'pla -wlɛ. Yaa 'vɩ -wlɛ 'nan: «'Ka 'fli -nɔn Bali lɛ, -e Bali 'e 'ka 'si yra yɩdɩ nɛn e \"ta -daa \"bɔlɛ 'wɩ 'wlidɩ \"drɛnɔn man bɛ -yrɔ.» ");
INSERT INTO yreNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Minnun nɛn o Piɛri wei 'man \"yi \"bɛ, Zozi 'le 'pasianɔn o -batize drɛ. Yi 'bɔ zɩɛ -a da, min -kpi yaaga bɛ 'o 'fli -nɔn Bali lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ɛn tʋ pɛɛnɔn man 'wɩnun nɛn Zozi 'le 'pasianɔn -a \"paaman o ji bɛ, waa maan te o 'ta wʋla \"da 'o 'ci 'fɩdaa 'a. O ci a -tʋwli, o \"paa 'o cin va te 'o cin man wɩ dra. O pɛɛnɔn fɛ -tʋwli \"ble 'e cin va Minsan -cin -trɔadɩ o ji -a, ɛn o Bali trʋ \"baa 'e cin va. ");
INSERT INTO yreNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Zeruzalɛm 'nɔn nɛn -nan bɛ nyɛn o cɛɛn kɔ Zozi 'le 'pasianɔn -cɛ -srɔn \"wɩnun 'lee 'lɛbo \"fɔ wɩnun dra. ");
INSERT INTO yreNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Minnun pɛɛnɔn nɛn o yi -tɛra Zozi da bɛ, o ya 'e cin va, ɛn -wee fɛnun pɛɛnɔn a 'e cin va. ");
INSERT INTO yreNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","'O 'lɔ fɛnun pɛɛnɔn 'tan, ɛn waa man \"lala pli minnun man. O min -tʋ \"le \"nɔn \"le zɩ \"lala 'wɩ cɩ \"man \"bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tʋ -tʋdʋ pɛɛnɔn man, te 'o cin ye Bali -pan 'kuin, 'kɔn 'tʋdʋ nɛn o -wee -blɩfɛ -tɔɔmlan 'ji bɛ, 'o cin -pliman -e 'o 'kʋ -a -blɩ ci \"nran 'lee ci 'fɩdaa 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","O Bali bɔa te minnun o 'tɔ \"yi \"ve. Ɛn tʋ pɛɛnɔn man bɛ, Minsan minnun \"sia 'wɩ 'ji te e o -sɛan \"o va. ");
INSERT INTO yreNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yi -tʋ da, te yidɛ tɛɛnla, ɛn Zan 'lee Piɛri \"ta -ko yidɛa Bali trʋ 'balɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bali -pan 'kɔn 'bɔ man -klɔn -yrɛ nɛn waa laabo -kpɛin fɛnyian bɛ, min -srandɩ \"tra \"tʋ yra -a \"nɛn. -A min 'bɔ, waa -ya zɩɛ. Tʋ pɛɛnɔn man, o -taa min 'bɔ 'nyɛnlɛa -kpɛin 'bɔ \"srɔn 'nan te e \"lala trʋ \"baa minnun nɛn o -wlamlan Bali -pan 'kuin bɛ -wlɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Zɩ e Piɛri 'lee Zan 'yɩ te o \"ta -wlamlan bɛ, ɛn e fɛ trʋ 'ba -wlɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tɔɔn ɛn Piɛri 'lee Zan 'o yiɛ 'sɛn \"da, waa -nanjɛɛn, ɛn Piɛri \"e -yrɛ 'nan: «'I 'kʋ 'nanjɛn.» ");
INSERT INTO yreNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ɛn e o -nanjɛɛn, \"yee 'ji \"le o \"ta fɛ -tʋ -nɔan 'yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ɛn Piɛri \"e -yrɛ 'nan: «\"Lala 'ka 'an 'lɔ dɩ, ɛn -siga 'ka 'an 'lɔ dɩ, 'pian fɛ nɛn 'an 'lɔ bɛ, maan -nɔan 'yiɛ: Nazarɛtɩ min Zozi Crizi 'tɔ da, 'i 'wluan lou, 'i 'ta wʋ!» ");
INSERT INTO yreNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","-A -nan nɛn yaa 'kun 'e 'pɛ \"yi \"man, ɛn yaa wluan lou. 'Nun tɔɔn ɛn min -srandɩ \"tra zɩɛ -a cɛin 'lee -a -sezenɛnnun -tɔ 'e man 'plɛblɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","E drɛ \"klɩ, ɛn e -tɔ lou, ɛn e 'ta wʋdɩ 'sia 'o 'vale Piɛri 'lee Zan -a. O wla Bali -pan 'kuin, te e -ko 'ta wʋdɩ -a. E -ko 'sʋdɩ -a lou, te e Bali 'tɔ bɔa. ");
INSERT INTO yreNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Minnun pɛɛnɔn -a 'yɩ 'ta wʋnan, te e Bali 'tɔ bɔa. ");
INSERT INTO yreNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Waa -tɔa 'nan, min nɛn 'e -nyrandɩ -klɔn -yrɛ nɛn waa laabo -kpɛin fɛnyian bɛ -a \"nɛn te e fɛ trʋ \"baa bɛ -nyrɛn. Ɛn 'wɩ nɛn e drɛ -yrɛ \"bɛ -a 'wɩ ciɩla minnun pɛɛnɔn da, 'wɩ o 'kan. ");
INSERT INTO yreNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Te ya'a tian 'silɛ Piɛri 'lee Zan \"srɔn \"dɩ, ɛn o 'bɔ Bali -pan 'kɔn 'lɛ \"nɛn \"nɛn waa 'tɔ 'pa Salomɔn man bɛ -a -nan, tɔɔn ɛn minnun nɛn 'wɩ o 'kan 'gʋɛ, o -kʋ o 'lɛ flan -a. ");
INSERT INTO yreNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Zɩ Piɛri 'wɩ zɩɛ -a -nan 'yɩ bɛ, tɔɔn ɛn e -wlɛ 'nan: «Izraɛl 'nɔn, -mɛ \"le \"wɛan nɛn 'wɩ 'ka 'kan? -Mɛ \"le \"wɛan nɛn ka 'kʋ -nanjɛan? Bali -le 'plɛblɛ 'bɛ min 'gʋɛ -a beli, 'kʋ 'bɔ 'le 'plɛblɛ \"cɛɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Bali nɛn e cɩ Abraam -le Bali -a 'lee Izak -le Bali -a 'lee Zago 'le Bali -a 'lee -kaa tranun -le Bali -a bɛ, -yɛɛ e 'suzan Zozi Crizi -le 'plɛblɛ 'ci kɔɔn. -A -pɩ Zozi zɩɛ, Pilati \"e 'vɩ 'nan 'o 'si \"man 'pian ka'a 'wɩlɛ \"man \"dɩ. Ka kɔala \"man, ɛn kaa -nɔn minnun lɛ, ɛn waa -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Min nɛn 'bɛ a Bali 'lɛ 'saun ɛn 'bɛ a min tɩglɩ 'a bɛ, 'cɛɛ 'nɔn ɛn wɛɛ 'tɛ, ɛn ka wɩɩ min -tɛzan man 'bɛ \"pa 'ji 'nan te 'wɛɛ 'tɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ka min nɛn e cɩ 'belidɩ nɛn ya'a 'nyaan dɩɛ -a san -a bɛ, -a -tɛ, 'pian Bali -a wluan -kanɔn 'va, ɛn kʋ ya -a -nan yɩnɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yi -tɛradɩ -a 'tɔ da -le \"wɛan, -a 'tɔ 'bɔ 'le 'plɛblɛ min nɛn kaa -tɔa ɛn kaa ye 'gʋɛ e beli. Yi -tɛradɩ Zozi da 'bɛ beli \"fo 'ka pɛɛnɔn yiɛ man 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","'An \"bʋɩnun, maan -tɔa 'nan 'wɩ nɛn 'ka 'bɔ 'lee 'ka 'tanɔn 'a drɛ Zozi lɛ bɛ, ka'a -ci -tɔlɛ 'vaa, ɛn kaa drɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","'Pian Bali 'bɛ 'vɩ 'nan 'e drɛ zɩ, -e 'wɩ nɛn Bali 'lewei vɩnɔn pɛɛnɔn -a 'vɩ bɛ, 'e 'lɛ sɔɔ. -A 'wɩ zɩɛ, -yɛɛ cɩ -yee min 'sizan 'wɩ 'ji Crizi -le yra yɩdɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","-Yee \"wɛan 'ka 'si 'wɩ 'wlidɩ \"drɛdɩ man, -e 'ka 'fli -nɔn Bali lɛ, -e Bali 'e 'cee 'wɩ 'wlidɩ 'fui. ");
INSERT INTO yreNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","-Te kaa drɛ zɩɛ -e Minsan Bali 'e 'fʋdɩ -trɔɔ -nɔn 'cɛɛ, -e min 'sizan 'wɩ 'ji Zozi nɛn yaa 'pla 'cee vɛ -a bɛ, 'e -ta -a. ");
INSERT INTO yreNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","'Bɛ nɛn 'gʋɛ, Zozi Crizi -fo tian laji -trilii -e tʋ nɛn Bali \"e 'nan 'wɩ 'wlidɩ 'ka 'kɔan 'trɛda dɩ \"le 'trɛda pou sianan 'zʋ bɛ, 'e 'bɔ. 'Wɩ zɩɛ, Bali 'lewei vɩnɔn 'saun -a 'vɩ 'e 'cɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moizi -a 'vɩ 'e 'cɛn 'nan: ‹Minsan nɛn 'cee Bali -a bɛ, e -taa Bali 'lewei vɩzan -tʋ -a 'cɛɛ \"le 'mɛn 'wɩ 'zʋ. 'Ka 'va nɛn e min zɩɛ -a \"sia, 'ka min zɩɛ -a wei man -e 'ka 'ta wʋla \"da. ");
INSERT INTO yreNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","'Pian bii nɛn yi'a min zɩɛ -a wei manlɛ dɩɛ, 'i klu \"so Bali -le minnun yei.› ");
INSERT INTO yreNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ɛn 'wɩ nɛn Bali 'lewei vɩzan Sanmian 'lee Bali 'lewei vɩnɔn pɛɛnɔn nɛn o -ta -yee -sru \"bɛ, waa 'vɩ bɛ, -yɛɛ cɩ \"mɛn \"drɛnan 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bali 'lewei vɩnɔn zɩɛ ka ya o kludanɔn 'a, ɛn 'wɩ nɛn Bali -a 'vɩ -kaa tranun lɛ 'nan 'e dra bɛ, 'cɛɛ cɩ -a \"nɛn \"blɩnɔn 'a. Bali -a 'vɩ Abraam lɛ 'nan: ‹'I kluda min -tʋ 'tɔ 'ji an -fɛa ve 'trɛdanɔn pɛɛnɔn man, tɔɔn ɛn Bali -ta 'e 'suzan 'a.› ");
INSERT INTO yreNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","-Yee \"wɛan Bali 'e 'suzan Zozi Crizi 'bɔla 'ka 'va 'e 'flin 'nan -e 'ka 'si 'wɩ 'wlidɩ \"drɛdɩ man -e 'ka 'fli -nɔn -yrɛ -e 'e -fɛa vɩ 'ka man.» ");
INSERT INTO yreNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piɛri 'lee Zan -fʋ tin 'banan minnun lɛ, ɛn Bali -pannɔn 'lee min nɛn e yiɛ -tɔa Bali -pan 'kɔn 'va bɛ 'lee Saduze 'nɔn 'ta. ");
INSERT INTO yreNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","'Bli 'fɔ o ji 'nan, Zozi 'le 'pasianɔn \"fli zɩɛ o ya 'wɩ \"paanan minnun ji, te waa ve -wlɛ 'nan, Zozi wluan -kanɔn 'va, -yee \"wɛan minnun nɛn o -ka bɛ o wuanla -kanɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","O Zozi 'le 'pasianɔn \"fli zɩɛ o 'kun, ɛn o -kʋ o -fɔlɛ -pʋ 'kuin 'nan -e tʋ 'e 'cɛn o man, kɔɔ fɛnan -kʋ -kɔɔbli. ");
INSERT INTO yreNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","'Pian minnun nɛn o 'wɩ zɩɛ -a 'man bɛ, o \"kaga \"fɔ Zozi 'va, ɛn Zozi -sru 'ta wʋnɔn \"nɛn 'bɔ -kpi 'soolu (5.000). ");
INSERT INTO yreNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Zɩ tʋ cɛɛn bɛ, ɛn Zuif 'nɔn 'tanɔn 'lee min cejenun 'lee 'fluba 'ci vɩnɔn 'o cin 'yɩ Zeruzalɛm. ");
INSERT INTO yreNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bali -pannɔn 'tazan Ane a o va, 'lee Kaifa 'lee Zan 'lee Alɛzandre 'lee Bali -pannɔn 'tazan \"srɔnnɔn -mienun \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɛn o 'nan 'o 'ta Piɛri 'lee Zan -a 'o yei. Zɩ Piɛri 'lee Zan -ta bɛ, ɛn waa laabʋ -wlɔ 'nan: «'Plɛblɛ \"cɛn \"a nɛn ka min -srandɩ \"tra beli, ɛn -tɩ 'tɔ da nɛn ka 'wɩnun zɩɛ -a dra?» ");
INSERT INTO yreNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ɛn Piɛri nɛn 'e fadɩ Bali lei 'saun 'le 'plɛblɛ 'a bɛ, e 'nan -wlɛ 'nan: «Zuif 'nɔn 'tanɔn 'lee min cejenun, ");
INSERT INTO yreNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","-te cɛɛgʋ o 'wɩ laabʋ 'kʋ 'lɔ \"yi \"nɛn kʋa drɛ min -srandɩ \"tra \"lɛ bɛ -a da bɛ 'lee min nɛn kʋa drɛ -a 'tɔ da bɛ -a da bɛ, ");
INSERT INTO yreNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kʋa ve 'cɛɛ -e 'ka -tɔ, ɛn \"nyian -e Izraɛl 'nɔn pɛɛnɔn 'o -tɔ 'nan: Nazarɛtɩ min Zozi Crizi nɛn kaa -tɛ -a -pɛindɩ -a yiba \"plan da, ɛn Bali -a wluan -kanɔn 'va bɛ, -a 'tɔ da nɛn ka min 'labɛ -a ye 'e 'belidɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","E ya 'e 'crɛn -tɛdɩ Bali -le 'fluba 'saun 'ji 'nan: ‹-Kɔlɛ nɛn 'ka 'kɔn 'tɔnɔn, kaa tuʋ 'ka 'pɛla koda bɛ, -yɛɛ drɛ 'kɔn 'tɔ -kɔlɛ tɩglɩ 'a.› ");
INSERT INTO yreNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","-A 'saza 'va nɛn 'belidɩ cɩ, -yɛɛ cɩ 'nan lakɔlɛ 'wlu 'gʋ, Bali 'ka 'tɔ 'tʋ -nɔnlɛ minnun lɛ -e min 'e 'ciɩla \"va -e 'e 'belidɩ yɩ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tɔɔn ɛn tin 'banɔn nɛn 'o cin 'yɩ bɛ 'wɩ o 'kan. -Yɛɛ cɩ 'nan, waa -ci -tɔ 'nan, Piɛri 'lee Zan -le 'wɩ nɛn waa 'vɩ bɛ, o yi -tɛra 'o 'fli da ɛn nyɛn 'ka o ji dɩ. Ɛn waa -ci -tɔ \"nyian 'nan, Zan 'lee Piɛri bɛ 'flanɔn \"tun \"nɛn waa, ɛn wa'a Bali -le 'fluba -tranlɛa dɩ. 'Pian waa -tɔa 'nan, 'o 'vale Zozi nun -a o 'ta wʋla, ");
INSERT INTO yreNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ɛn min -srandɩ \"tra \"nɛn -cɛ 'si \"man te waa ye 'e 'tɔdɩ o \"srɔn \"bɛ, -yee \"wɛan 'wɩ 'tʋ 'ka o ji -e 'o vɩ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tɔɔn ɛn o 'nan -wlɛ 'nan 'o 'man 'tɛn \"tiɛnnɔn. -A -nan nɛn -sa -fɔla tin 'banɔn 'bɔ yei. ");
INSERT INTO yreNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ɛn waa laabʋdɩ 'sia 'o cin lɔ 'nan: «Kaa dra minnun 'labɛ -wlɛ 'kɔ? Zeruzalɛm 'nɔn pɛɛnɔn -a -ci -tɔa 'wein, 'nan -cɛ -srɔn \"wɩ -dan nɛn 'labɛ -wɛɛ drɛ. Ɛn -ka'a 'kɔlaman -a -sa -fɔdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","'Pian -e o \"fli zɩɛ, -e -wee 'wɩ 'bɔ 'e vɩlɛ 'e fuila \"man \"minnun pɛɛnɔn 'va dɩɛ, -kaa 'wɩ 'pla -wlɛ 'klagla 'nan, te o 'wɩ tin 'ba min -tʋ lɛ \"nyian -wee Zozi zɩɛ -a 'tɔ da dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tɔɔn ɛn o Zan 'lee Piɛri laabʋ, ɛn o 'wɩ 'pla -wlɛ 'klagla 'nan, te 'o 'wɩ tin 'ba \"nyian minnun lɛ Zozi 'tɔ da dɩ, ɛn te 'o 'wɩ \"paa \"nyian minnun ji Zozi 'tɔ da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ɛn Piɛri 'lee Zan \"e 'nan -wlɛ 'nan: «'Wɩ nɛn e cɩ tɩglɩ bɛ, 'ka vɩ 'ka 'bɔ 'a: 'Kʋ 'ta wʋla 'ka wei da, -baa 'kʋ 'ta wʋla Bali wei da? ");
INSERT INTO yreNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","'Pian 'kʋe vɛ bɛ 'wɩ nɛn kʋa -nan 'yɩ, ɛn kʋa 'man bɛ, kʋ'a 'kɔlaman -e 'kʋ 'lɛbo 'pla \"da -a 'wɩ zɩɛ -a vɩdɩ -a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tɔɔn ɛn tin 'banɔn 'wɩ 'pla \"nyian -wlɛ 'klagla 'kpa, ɛn o -si -nɔn -wlɛ 'nan 'o 'kʋ. Tin 'banɔn 'bɔ 'ka -kɔlalɛ -si -tʋ yɩdɩ -a -e 'o 'wɩ 'nɔn -wlɛ \"dɩ, kɔɔ minnun pɛɛnɔn a Bali 'tɔ bɔnan 'wɩ nɛn e drɛ bɛ -yee \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ɛn \"nyian min -srandɩ \"tra \"nɛn -cɛ -srɔn \"wɩ zɩɛ e drɛ, ɛn -cɛ 'si \"man \"bɛ, min ceje nɛn -a lɛ -fuba sinjɛn -cia \"bɛ -nyrɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Zɩ o 'si o man bɛ, ɛn o -kʋ 'o \"bʋɩ Zozinɔn -mienun va, ɛn 'wɩ nɛn Bali -pannɔn 'tanɔn 'lee min cejenun -a 'vɩ -wlɛ \"bɛ, o -wee 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ɛn zɩ o 'wɩ zɩɛ -a 'man bɛ, o pɛɛnɔn 'ci drɛ 'tʋ, ɛn o Bali trʋ 'ba 'nan: «'Kʋ 'san, yiɛ 'trɛ drɛ, yiɛ lakɔlɛ 'pla, yiɛ jemie 'lee 'e 'va fɛnun pɛɛnɔn drɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yiɛ 'pa 'kʋ tra David 'le 'yie lei 'saun 'a 'nan: ‹-Mɛ \"le \"wɛan nɛn 'bli a 'e 'fɔdɩ 'lɛglɔn pɛɛnɔn da minnun ji zɩɛ, ɛn -mɛ \"le \"wɛan nɛn 'wɩ nɛn -a -ci \"ka \"dɩɛ, -a -cin a minnun ji zɩɛ? ");
INSERT INTO yreNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","'Trɛda mingɔnnɛn nun 'o man wʋʋ 'kuli da, ɛn 'o 'ci 'pa 'o 'vale minnun tanɔn 'a Minsan Bali 'lee -yee min nɛn yaa 'si \"va ɛn yaa 'pa 'sia 'nan 'e min 'si 'wɩ 'ji bɛ o man.› ");
INSERT INTO yreNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","'Wɩ 'kpa nɛn, -yɛɛ cɩ 'nan Erodi 'lee Ponzʋ Pilati 'o cin 'yɩ 'fla zɩɛ -a da 'o 'vale -pɛnnɔn 'lee Izraɛl 'nɔn 'a, ɛn 'o 'ci 'pa 'i 'suzan 'saun Zozi nɛn yia 'si \"va, ɛn yia 'pa 'sia, 'nan 'e min 'si 'wɩ 'ji bɛ -a man. ");
INSERT INTO yreNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'Wɩ nɛn yia 'vɩ 'i 'bɔ 'le 'plɛblɛ 'lee 'i 'bɔ 'ci 'sɔ 'a 'e 'cɛn bɛ, -a 'bɔ nɛn waa 'lɛ sɔɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","-Yee \"wɛan, 'bɛ nɛn 'gʋɛ Minsan Bali, 'i 'wɩ nɛn waa dra -wlɛ \"bɛ, 'i yɩ 'i drɛ -e 'i 'sunɔn 'o 'yie 'wɩ 'nɔnnɔn vɩ minnun lɛ yi -tɛradɩ 'o 'fli da -a. ");
INSERT INTO yreNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","'I 'yie 'plɛblɛ 'ci -kɔɔn 'dʋ -e 'i 'sunɔn 'o -cɛ 'si minnun man -e 'o 'lɛbo \"fɔ wɩnun 'lee -cɛ -srɔn \"wɩnun drɛ 'i 'suzan 'saun Zozi nɛn yia 'si \"va \"bɛ -a 'tɔ da.» ");
INSERT INTO yreNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Zɩ o cɛɛn Bali trʋ 'badɩ man bɛ, ɛn fɛnan nɛn o cɩ 'o cin yɩdɩ bɛ -a -nan nyɔɔndɩ 'sia, tɔɔn ɛn Bali lei 'saun o pɛɛnɔn 'fa, ɛn o Bali -le 'wɩ 'nɔnnɔn vɩdɩ 'sia minnun lɛ te \"klan 'ka o ji \"nyian dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Minnun pɛɛnɔn nɛn o yi -tɛra Zozi Crizi da bɛ, o drɛ min -tʋwli \"a, o ci wɩ a -tʋwli. -Te min -tʋ yɩfɛ a bɛ, te o pɛɛnɔn 'le vɛ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","'Plɛblɛ -dan nɛn -wlɔ \"bɛ, -a 'bɔ 'a nɛn o Minsan Zozi 'le wluandɩ -kanɔn 'va wɩ ve minnun lɛ, ɛn \"nyian bɛ, Bali -le -fɛa a o man 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Fɛ -tʋ 'ka 'kle min -tʋ man o va dɩ. Kɔɔ minnun nɛn -wee fei 'lee 'kɔnnun a bɛ waa -tan, ɛn o -ta -a man \"lala -a, ");
INSERT INTO yreNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ɛn waa -sran Zozi 'le 'pasianɔn 'wlu. Zozi 'le 'pasianɔn zɩɛ, o min -tʋ \"le \"nɔn \"le zɩ \"lala 'wɩ cɩ \"man \"bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Levi min -tʋ a o va, waa -ya Sipri 'lɛglɔn 'ji, -a 'tɔ nɛn Zozɛfʋ, ɛn Zozi 'le 'pasianɔn -a 'tɔ 'pa \"nyian Barnaba, 'bɛ 'ci 'bɛ cɩ 'nan min nɛn e min \"koe -tɔa 'e da. ");
INSERT INTO yreNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","-Yee fei nɛn 'e 'lɔ bɛ yaa -tan, ɛn e -ta -a man \"lala -a, yaa -sran Zozi 'le 'pasianɔn 'wlu. ");
INSERT INTO yreNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","'Pian min -tʋ a, -a 'tɔ nɛn Anania, 'o 'vale 'e nan Safira -a o 'wee -yɔ -tan. ");
INSERT INTO yreNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yaa man \"lala -mie 'si \"va, ɛn yɛɛ 'pla 'yee vɛ -a, -a nan -a -tɔa zɩɛ, ɛn e -kʋ -a -nyranman -a Zozi 'le 'pasianɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tɔɔn ɛn Piɛri \"e -yrɛ 'nan: «Anania, -mɛ \"le \"wɛan nɛn 'i 'fli 'tʋɩ ɛn Satan wla 'i 'ji, ɛn i 'wlu 'sɛn Bali lei 'saun lɛ, ɛn i 'yie -yɔ man \"lala -mie 'pla 'yie vɛ -a? ");
INSERT INTO yreNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","'I 'bɔ 'le -yɔ nɛn, ɛn yia -tan. Ɛn zɩ yia -tan, -a man \"lala bɛ, 'i 'bɔ 'le vɛ \"cɛɛ dʋʋ? Ɛn -mɛ \"le \"wɛan nɛn 'wɩ 'wlidɩ zɩɛ, yia nrɔn 'i 'ji? Minnun lɛ \"cɛɛ i 'wlu 'sɛn dɩ, 'pian Bali lɛ nɛn i 'wlu 'sɛn.» ");
INSERT INTO yreNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Zɩ Anania 'wɩ zɩɛ -a 'man bɛ, e -tria, ɛn e -ka. Minnun pɛɛnɔn nɛn o 'wɩ zɩɛ -a 'man bɛ, \"klan -dan -sɛn o ji. ");
INSERT INTO yreNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","-Gobonun nɛn -nan bɛ, o sɔ 'pa -a -kadɩ man, ɛn o -kʋ -a wʋlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","-A -nan 'mɔn -trilii, \"bɛ -sru ɛn -a nan -ta, te 'wɩ nɛn e drɛ bɛ, ya'a tian \"e \"manlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ɛn Piɛri -a laabʋ -yrɔ 'nan: «-Yɔ nɛn kaa -tan bɛ, -a man \"lala nɛn 'gʋ?» Ɛn -a nan -a wun -fɔ 'nan -a man \"lala nɛn bɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tɔɔn ɛn Piɛri \"e -yrɛ 'nan: «-Mɛ \"le \"wɛan nɛn 'ka 'ci 'pa, ɛn ka Minsan lei 'man -tan? \"I 'yiɔ, minnun nɛn wei -sran 'wʋ bɛ, o nɛn 'kɔn 'lɛ \"nɛn \"bɛ, o \"ta -ko \"nyian \"yie \"a.» ");
INSERT INTO yreNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","'Nun tɔɔn e -tria Piɛri 'wlu, ɛn e -ka. -A -nan nɛn -gobonun wla o 'bɔ \"man te e ya 'e 'kadɩ, ɛn waa 'sia o -kʋ -a wʋlɛ 'e -sran \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","-Leglizi 'nɔn 'lee minnun pɛɛnɔn nɛn o 'wɩ zɩɛ -a 'man bɛ, \"klan -dan -sɛn o ji. ");
INSERT INTO yreNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Zozi 'le 'pasianɔn 'lɛbo \"fɔ wɩ 'lee -cɛ -srɔn \"wɩ \"kaga drɛ minnun yiɛ man. Zozinɔn pɛɛnɔn a 'o cin yɩdɩ Bali -pan 'kɔn 'lɛ \"nɛn \"nɛn waa 'tɔ 'pa Salomɔn man bɛ -a -nan. -A -nan nɛn 'o cin ye 'e 'cɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ɛn minnun nɛn o 'ka Zozi 'va dɩɛ o -tʋ 'ka -plilɛ o man dɩ, 'pian te o Zozinɔn 'tɔ \"yi \"ve. ");
INSERT INTO yreNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Minnun \"kaga \"yi -tɛra Minsan da, -e 'e 'sia lɩmɔn 'lee 'klɔnmɔn man, te o -ko -sɛndɩ -a Zozinɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Minnun 'bɔla 'ji -cɛ -tɛnɔn 'a 'fla yei, te o -cɛ -tɛnɔn 'bɔ nyianla -saa 'lee nyinnan \"davɛ -mienun da. Minnun zɩɛ, waa \"nrɔnman 'o 'ji, 'nan -te Piɛri \"ɛ ciɩ -e -a fulɔ lei \"tun 'e 'ciɩ min -tʋ da 'fɛndaa. ");
INSERT INTO yreNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Minnun \"kaga \"sia 'flanun nɛn Zeruzalɛm \"srɔn \"bɛ -a da, te o -taa \"nyian -cɛ -tɛnɔn 'lee minnun nɛn pɔn 'e 'pɛ klɛ o man bɛ waa, te o pɛɛnɔn \"belia. ");
INSERT INTO yreNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Man bʋdɩ wlala Bali -pannɔn 'tazan 'lee Saduze 'nɔn 'ji Zozi 'le 'pasianɔn man. ");
INSERT INTO yreNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","-A -nan nɛn o Zozi 'le 'pasianɔn 'kun, ɛn o o -fɔ -pʋ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","'Pian zɩ -pei 'tan bɛ, ɛn Minsan -le 'pasiazan -tʋ -ta -pʋ 'kɔn 'lɛ 'sʋlɛ o da, e o 'bɔla bei, ɛn e 'nan -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«'Ka 'kʋ Bali -pan 'kuin -e 'ka Bali wei nɛn e 'belidɩ -nɔan \"bɛ -a -nan wɩ vɩ minnun lɛ.» ");
INSERT INTO yreNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ɛn o wɩɩ \"man. Bodrun puunɔn o -kʋ Bali -pan 'kuin, ɛn o 'wɩ \"paadɩ 'sia minnun ji. Tʋ 'bɔ zɩɛ -a wlu bɛ, Bali -pannɔn 'tazan 'lee 'e \"srɔnnɔn tin 'banɔn cin 'yɩ 'o 'vale Zuif min cejenun -a. Ɛn o minnun 'pa 'sia -pʋ 'kuin 'nan 'o 'ta Zozi 'le 'pasianɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","'Pian, minnun nɛn o o 'pa 'sia bɛ, wa'a Zozi 'le 'pasianɔn yɩlɛ -pʋ 'kuin dɩ. Ɛn o 'li 'o da tin 'banɔn 'va, o 'wɩ zɩɛ -a 'sinan 'pa -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Waa 'vɩ -wlɛ 'nan: «-Pʋ 'kɔn a 'e 'fɔdɩ -ji \"fo, ɛn 'sounjanun a -a 'lɛ \"nɛn 'pian zɩ kʋ 'kɔn 'lɛ 'sʋ bɛ, kʋ'a Zozi 'le 'pasianɔn yɩlɛ -ji dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Zɩ min nɛn o yiɛ -tɔa Bali -pan 'kɔn 'va bɛ, 'lee Bali -pannɔn 'tanɔn 'wɩ zɩɛ -a 'man bɛ, wa'a 'wɩ 'tʋ yɩlɛ -e 'o vɩ Zozi 'le 'pasianɔn 'le 'sandɩ da dɩ, ɛn waa laabʋ 'o cin lɔ 'nan, -mɛ \"wɩ 'bɛ cɩ zɩɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","-A -nan nɛn min -tʋ -ta -a vɩlɛ -wlɛ 'nan: «\"Ka 'yiɔ, minnun nɛn ka o -fɔ -pʋ 'kuin 'gʋɛ, o ya 'wɩ \"paanan minnun ji Bali -pan 'kuin.» ");
INSERT INTO yreNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ɛn min nɛn e yiɛ -tɔa Bali -pan 'kɔn 'va bɛ 'lee 'yee minnun -kʋ o 'kunlɛ, ɛn o -ta waa. 'Pian wa'a drɛlɛ -sa -a dɩ, kɔɔ \"klan a o ji 'nan minnun \"ta -kɔlɛ wɛɛnman 'o 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Zɩ o -ta waa bɛ, ɛn o -kʋ waa tin 'banɔn 'lɛ. -A -nan nɛn Bali -pannɔn 'tazan 'wɩ laabʋ -wlɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","E 'nan -wlɛ 'nan: «Kʋ 'wɩ 'pla 'cɛɛ 'klagla 'nan, te 'ka 'wɩ \"paa \"nyian minnun ji 'tɔ 'labɛ -a da dɩ. \"Ka 'yiɔ \"le kaa drɛ, ɛn 'cee 'wɩ \"paadɩ fuila \"man Zeruzalɛm \"fo, ɛn ka 'nan minnun lɛ 'nan, 'kʋɛ min zɩɛ -a -tɛ.» ");
INSERT INTO yreNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tɔɔn Piɛri 'lee Zozi 'le 'pasianɔn -mienun -a 'vɩ -wlɛ 'nan: «Bali wei da nɛn min 'ta 'wʋla 'e 'flin 'vaa -e 'e 'ta wʋla min wei da. ");
INSERT INTO yreNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Zozi nɛn kaa -tɛ -a -pɛindɩ -a yiba \"plan da bɛ, 'kʋ tranun -le Bali -a wluan -kanɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Bali -a -nyran 'e 'pɛ \"yi \"da, ɛn yaa drɛ min 'sizan 'wɩ 'ji -a. Ɛn yaa drɛ min tazan -a. Yaa drɛ zɩɛ 'nan -e Izraɛl 'nɔn o 'si 'o drɛ wɩ -wlidɩ \"man -e Bali 'e -wee 'wɩ 'wlidɩ 'fui. ");
INSERT INTO yreNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kʋ ya 'wɩ zɩɛ -a -nan yɩnɔn 'a, ɛn lei 'saun nɛn Bali -a -nɔn minnun nɛn o 'ta 'wʋla Bali 'bɔ wei da bɛ -wlɛ \"bɛ, e ya \"nyian -a -nan yɩzan -a.» ");
INSERT INTO yreNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Zɩ tin 'banɔn 'wɩ zɩɛ -a 'man o da bɛ, ɛn 'bli 'fɔ o ji 'e 'ciɩla \"da, o ya \"vale o Zozi 'le 'pasianɔn 'bɔ -tɛɛman. ");
INSERT INTO yreNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","'Pian Farizɛn min -tʋ nɛn waa laabo Gamaliɛl, e Moizi -le -pei 'fluba \"paaman, ɛn minnun pɛɛnɔn -a bɔa \"bɛ, e -tɔ lou tin 'banɔn yei, ɛn e 'nan 'o Zozi 'le 'pasianɔn 'man 'tɛn \"tiɛnnɔn. ");
INSERT INTO yreNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","-A -nan nɛn e 'nan tin 'banɔn lɛ 'nan: «Izraɛl 'nɔn, 'wɩ nɛn ka \"ta -a dra minnun 'labɛ -wlɛ \"bɛ, 'ka 'wulo -ji \"nrɔn \"da 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Min -tʋ nɛn waa laabo Tɛida bɛ, e 'bɔla -a -nan 'ka tian 'mɔnlɛ \"bʋʋ dɩ. Zɩ -yee 'wɩ 'bɔla zɩɛ, e 'nan 'e 'fli man 'nan 'e ya min -dan tʋ -a, ɛn min -yaa sinjɛn sɔɔnla -a -sru. 'Pian waa -tɛ, ɛn minnun nɛn o sɔɔnla -a -sru \"bɛ o fuila \"man. Min -tʋ 'ka \"nyian -fʋlɛ -nan dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","\"Bɛ -sru, te min \"nrɔndɩ tʋ 'bɔ, ɛn Galile min Zuda \"e \"ta wʋ, \"bɛ minnun \"kaga \"sɛn 'e -sru. 'Pian wɛɛ 'tɛ \"nyian, ɛn minnun pɛɛnɔn nɛn o sɔɔnla -a -sru \"bɛ, o fuila \"man. ");
INSERT INTO yreNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","'Bɛ nɛn 'gʋɛ maan ve 'cɛɛ 'nan, te 'ka \"trɔɛn \"tɔ \"nyian minnun 'labɛ o va dɩ, ɛn 'ka 'si o man 'o 'kʋ. -Yɛɛ cɩ 'nan, -te -wee 'wɩ nɛn 'o cɩ \"man \"bɛ 'nan min wei da nɛn o 'ta 'wʋla bɛ, \"te 'li 'pei te -a 'wɩ 'nyan. ");
INSERT INTO yreNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","'Pian -te Bali wei da nɛn o 'ta 'wʋla bɛ, \"te ka'a 'kɔlaman o fuiladɩ -a \"man \"dɩ. 'Ka drɛ \"yi, \"tɔgɔ 'ka 'kuli -tan Bali man.» Tɔɔn ɛn tin 'banɔn -a 'sia Gamaliɛl -le vɛ da. ");
INSERT INTO yreNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","O Zozi 'le 'pasianɔn laabʋ, ɛn o 'nan 'sounjanun lɛ 'nan 'o o -sɔn -ngble -a, ɛn o 'wɩ 'pla -wlɛ 'nan, te 'o 'wɩ tin 'ba \"nyian min lɛ Zozi 'tɔ da dɩ. Tɔɔn ɛn o 'si o man. ");
INSERT INTO yreNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","-A -nan nɛn Zozi 'le 'pasianɔn 'si tin 'banɔn 'lɛ. O 'si o 'lɛ ci \"nran -a, kɔɔ 'o yra 'yɩ Zozi 'tɔ 'ji. ");
INSERT INTO yreNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yi -tʋdʋ pɛɛnɔn man te o ya Bali -pan 'kuin 'lee 'wee 'kɔnnun -ji, wa'a 'flinlɛ 'wɩ \"paadɩ -a dɩ, ɛn wa'a 'flinlɛ Zozi Crizi -le 'wɩ 'nɔnnɔn vɩdɩ -a minnun lɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tʋ zɩɛ -a man te Zozinɔn a bɔnan \"kaga \"bɛ, ɛn minnun nɛn o Grɛk wei -fɔa \"bɛ, o Zuif 'nɔn nɛn o Ebre wei -fɔa \"bɛ, o man wɩ 'pla 'nan, tʋ pɛɛnɔn man, -te \"wɛɛ -blɩfɛnun -pli \"bɛ o ci \"saan 'o 'va -calenun man. ");
INSERT INTO yreNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ɛn Zozi 'le 'pasianɔn 'fuda \"fli Zozinɔn pɛɛnɔn cin 'yɩ, ɛn o 'nan -wlɛ 'nan: «E 'ka \"yi, -e -kaa Bali -le 'wɩ 'tʋɩ -e -kaa \"trɔɛn \"tɔ -blɩfɛ -le 'wɩ \"ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","-Yee \"wɛan \"bʋɩnun, 'ka min -wɛɛ 'ka 'va 'sɔravli -e -kaa o 'pla 'nyranman zɩɛ -a da. O 'nɔn zɩɛ, 'o 'tɔ \"yi 'e 'kɔn minnun 'le, 'o 'kɔn minnun nɛn o 'ta wʋla Bali lei 'saun 'le 'wɩ da bɛ waa, ɛn 'o 'kɔn 'wɩ 'tɔnɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","-Cee vɛ bɛ, -e -kaa yiɛ 'trɔa Bali -le 'wɩ da te -kaa Bali trʋ \"baa.» ");
INSERT INTO yreNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","'Wɩ zɩɛ, e Zozinɔn pɛɛnɔn 'ci 'sɔ, ɛn o Etiɛnɛn -tɔ. Etiɛnɛn zɩɛ, e yi -tɛala Bali da 'kpa, ɛn e 'ta 'wʋla Bali lei 'saun 'le 'wɩ da. Ɛn o Filipʋ 'lee Prokɔr 'lee Nikanor 'lee Timɔn 'lee Parmena 'lee Antiɔs min Nikola nɛn e drɛ Zuif min -a bɛ, o 'yi. ");
INSERT INTO yreNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Zozinɔn o kɔɔn Zozi 'le 'pasianɔn lɛ, tɔɔn ɛn 'o 'pɛ 'pla o da, ɛn o Bali trʋ 'ba -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bali -le 'wɩ 'nɔnnɔn 'ko fuiladɩ -a \"man, te Zozinɔn 'ko bɔdɩ -a \"kaga Zeruzalɛm, ɛn te Bali -pannɔn \"kaga 'ta wʋla \"nyian Zozi 'le 'wɩ da. ");
INSERT INTO yreNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Bali 'yee 'plɛblɛ 'lee 'yee yɩdɩ \"yi \"nɔn Etiɛnɛn lɛ, -a 'bɔ 'a nɛn e -cɛ -srɔn \"wɩnun 'lee 'lɛbo \"fɔ wɩnun dra minnun yiɛ man. ");
INSERT INTO yreNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","'Pian minnun nɛn o -ko Bali trʋ 'balɛ nɔannun nɛn o 'si o man bɛ, -wee cin yɩ 'kuin bɛ, o -sa -fɔdɩ 'sia 'o 'vale Etiɛnɛn -a. Minnun zɩɛ Zuif 'nɔn nɛn waa, o \"sia Sirene, ɛn o -mie \"sia Alɛzandri, ɛn o -mie \"sia Silisi 'lee Azi 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","'Pian Etiɛnɛn o \"kle \"sa -fɔdɩ -a. -Yɛɛ cɩ 'nan 'wɩ 'tɔdɩ nɛn Bali lei 'saun -a -nɔan -yrɛ \"bɛ -a 'bɔ 'a nɛn 'e \"we. ");
INSERT INTO yreNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ɛn o -kʋ -fɔlɛ minnun -sru \"lala -a 'nan 'o vɩ Etiɛnɛn man 'nan, 'o 'bɔ \"man te e ya Moizi 'lee Bali 'tɔ srɛnan. ");
INSERT INTO yreNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","'Wɩ zɩɛ, e 'bli 'fɔ min cejenun 'lee 'fluba 'ci vɩnɔn 'ji, ɛn o -kʋ -a 'kunlɛ -sa -a, ɛn o -kʋ -a tin 'banɔn 'cɛin -da. ");
INSERT INTO yreNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","O -fɔ \"nyian minnun peenun -sru, ɛn 'o 'ta 'wlu 'sɛnlɛ \"man \"nyian. Waa 'vɩ 'nan: «Min 'gʋɛ, e wɩɩ 'wlidɩ Bali -pan 'kɔn nɛn Bali -le vɛ -a bɛ -a man, ɛn e wɩɩ \"nyian -wlidɩ Moizi -le -peinun man. ");
INSERT INTO yreNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kʋa 'man \"da 'nan: Nazarɛtɩ min Zozi 'kɔn zɩɛ -a -wia, ɛn Moizi -le -peinun nɛn yaa -tɔ -kaa tranun lɛ bɛ, Zozi -a limlan -e -ka'a vɩlɛ -kaa 'ta wʋla \"da \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","-A -nan nɛn minnun pɛɛnɔn nɛn tin 'banan bɛ, 'o yiɛ 'sɛn Etiɛnɛn da, ɛn waa yra 'yɩ \"le Bali -le 'pasianɔn nɛn laji bɛ -a -tʋ -zʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tɔɔn ɛn Bali -pannɔn 'tazan -a laabʋ Etiɛnɛn -lɔ 'nan: «'Wɩ 'kpa nɛn?» ");
INSERT INTO yreNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ɛn Etiɛnɛn \"e 'nan: «'An \"bʋɩnun, 'an \"tɩnun, 'ka \"trɔɛn \"tɔ 'an wei lɛ. 'Li 'kpa te Abraam -nyɛanla Mesopotami bɛ, ɛn -cee Bali nɛn -a -kɔɔn \"manvɛ \"ka \"dɩɛ, 'e 'fli kɔɔn -yrɛ 'vaa, ɛn e -kʋ -nyɛnlɛa Aran. ");
INSERT INTO yreNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","E 'nan Abraam lɛ 'nan: ‹'I 'si 'yie 'lɛglɔn 'ji, 'i si 'i 'mangulinun va, -e 'i 'kʋ 'trɛ nɛn an \"ta -daa -a -kɔɔnlɛ 'yiɛ 'gʋɛ -a da.› ");
INSERT INTO yreNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ɛn Abraam 'si Kalde 'lɛglɔn 'ji, ɛn e -kʋ -nyɛnlɛa Aran. E -fʋ -nan nun. Zɩ -a \"tɩ \"ka bɛ, ɛn Bali -ta -a 'lɛglɔn nɛn ka cɩ -ji cɛɛgʋ 'gʋɛ -a -ji. ");
INSERT INTO yreNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Bali 'ka -yee -yɔ -nɔnlɛ 'lɛglɔn zɩɛ -a -ji dɩ. Bali 'ka -yee \"blɩnan \"wɛnnɛn 'nɔnlɛ dɩ. 'Pian e -tɔ 'e wei da 'nan 'e 'lɛglɔn zɩɛ -a -nɔan -yrɛ -yee vɛ -a, ɛn -yee -sru 'e -nɔan -a klu lɛ. Bali 'wɩ zɩɛ -a 'vɩ, te Abraam -le 'nɛn \"ka \"dɩ. 'Pian Bali -a 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","‹'Lɛglɔn nɛn -pɛn da bɛ, -a 'ji nɛn 'i kludanɔn -nyɛanla. O -kɔan \"minnun -le nɔannun -a -nan nun. Minnun 'tɛ \"paa o da lɛ -yaa sinjɛn wlu. ");
INSERT INTO yreNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","'Pian 'lɛglɔn nɛn o drɛ -wee nɔannun -a bɛ, an 'wɩ \"nɛn -kɔɔnman -wlɛ. 'An 'bɔ Bali 'bɛ 'vɩ. \"Bɛ -sru 'i kludanɔn lia 'o da -e 'o 'ta 'an trʋ 'ba Kanan 'lɛglɔn 'bɔ 'gʋɛ -a -ji.› ");
INSERT INTO yreNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bali -tɔ 'e wei da Abraam lɛ 'nan e 'lɛglɔn zɩɛ -a -nɔan -yrɛ. -A -nɔan -kɔɔn \"vɛ nɛn 'e 'fɔdɩ -klɔnmɔn -va -a. -Yee \"wɛan Abraam Izak -ya, ɛn yaa -fɔ -klɔnmɔn -va -a -ya yi 'sɔravli \"da. -A -tʋwli \"nɛn Izak \"e drɛ Zago lɛ, ɛn Zago \"e drɛ \"nyian 'yee 'nɛnnun -fuda \"fli \"nɛn -kaa tra \"le \"tranun -a bɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Zozɛfʋ \"bʋɩnun man bʋ Zozɛfʋ -va, ɛn waa -tan \"le nɔan -zʋ Ezipti. 'Pian Bali 'pa \"va, ");
INSERT INTO yreNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ɛn yaa 'si 'wɩ 'plɛblɛ pɛɛnɔn 'ji. Bali 'wɩ 'tɔdɩ -nɔn -yrɛ, ɛn Ezipti mingɔnnɛn -a 'yɩ \"yi. Mingɔnnɛn zɩɛ e Zozɛfʋ -tɔ 'e 'wluzan -dan tʋ -a Ezipti 'lɛglɔn da 'lee 'e yɩfɛnun da. ");
INSERT INTO yreNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tɔɔn ɛn dra -dan tʋ -ta Ezipti 'lɛglɔn 'lee Kanan 'lɛglɔn 'ji. Dra zɩɛ -a cibɛn a \"bʋʋ \"le \"wɛan, -kaa tranun 'ka 'blɩfɛ ye -e 'o -blɩ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","-A -nan nɛn Zago -a man 'nan -blɩfɛ a Ezipti, ɛn e Zozɛfʋ \"bʋɩnun nɛn -kaa tranun -a bɛ, o 'pa 'sia 'e tɛdɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","-A \"flizan da bɛ, ɛn Zozɛfʋ 'e 'fli -kɔɔn 'e \"bʋɩnun lɛ. -A -nan nɛn Ezipti mingɔnnɛn Zozɛfʋ 'sinan 'tɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Zozɛfʋ \"e 'nan 'e \"bʋɩnun lɛ 'nan, 'o 'kʋ 'e \"tɩ Zago 'si 'o -taa. -A \"tɩ Zago 'lee 'e 'mangulinun a min -fuba 'sɔravli 'wlɛ 'soolu. ");
INSERT INTO yreNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zago 'kʋ Ezipti, ɛn e -ka -nan nun 'o 'vale 'yee 'nɛnnun nɛn -kaa tranun -a bɛ waa. ");
INSERT INTO yreNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","O -ta o pɛɛnɔn wʋlɛ Sizɛm 'fla Kanan 'lɛglɔn 'ji. Minnun o 'wʋ min wʋnan nɛn Abraam -a 'lɔ \"lala -a Emor -pɩnun lɔ bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Zɩ tʋ nɛn Bali 'e wei -nɔn Abraam lɛ 'nan e 'wɩ 'tʋ dra -yrɛ \"bɛ, e ya bɔnan -kogo bɛ, ɛn Abraam kludanɔn fadɩ 'sia \"da, ɛn o bɔdɩ 'sia \"kaga Ezipti 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","-A -nan nɛn mingɔnnɛn -trɛ -tʋ mingɔnnɛn -blɩdɩ \"sia Ezipti 'lɛglɔn da. Mingɔnnɛn zɩɛ, ya'a Zozɛfʋ -tɔlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","-A mingɔnnɛn zɩɛ, e -cee minnun see paa, ɛn e 'tɛ 'pa -kaa tranun da, e -tɔ -kaa tranun man -sa -a, 'nan 'o 'si 'nɛn 'linɛnnun -sru, -e 'o kaa. ");
INSERT INTO yreNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","-A tʋ zɩɛ -a man nɛn o Moizi -ya. Moizi 'sɔ Bali lɛ tɩglɩ, ɛn e -fʋ 'e \"tɩ \"le \"kɔnnɛn mlɛn yaaga te e 'nyɔn -mlian. ");
INSERT INTO yreNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ɛn zɩ o 'si -a -sru \"bɛ, -a -nan nɛn Ezipti mingɔnnɛn 'lu -a 'sia, ɛn yaa 'lɛbʋ \"le 'yee 'nɛn 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","O Moizi 'lɛbʋ Ezipti 'nɔn 'le 'wɩ 'tɔdɩ -a, ɛn Moizi 'lewei 'lee -a drɛ wɩnun -a kɔɔn 'nan e ya min 'plɛblɛ 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Zɩ Moizi lɛ 'bɔ -fuba sinjɛn bɛ, -a -nan nɛn -a -cin -trɔa \"ji 'nan 'e 'kʋ 'e \"bʋɩ Izraɛl 'nɔn 'nanjɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ɛn e Ezipti min -tʋ 'yɩ, te e ya 'tɛ 'panan Izraɛl min -tʋ da, te -a -ci \"ka \"dɩ, ɛn e 'padɩ 'sia Izraɛl min zɩɛ -a va, ɛn Ezipti min -ka -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moizi 'e 'ci nrɔn 'nan 'e \"bʋɩ Izraɛl 'nɔn -a -ci -tɔa paan 'nan Bali 'e 'si \"va 'nan -e 'e o 'si nɔanba -ji. 'Pian wa'a -ci manlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","\"Bɛ -sru, tʋ cɛɛn te Moizi Izraɛl 'nɔn \"fli \"ye te o ya 'wɩ 'blɩnan, ɛn e ya \"vale e o yei \"paamlan. E 'nan -wlɛ 'nan: ‹'An beenun, ka ya \"bʋɩnun -a. -Mɛ \"le \"wɛan nɛn ka 'tɛ \"paa 'ka cin da te -a -ci \"ka \"dɩ?› ");
INSERT INTO yreNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","'Pian min nɛn e cɩ 'tɛ 'panan 'e bɔɛzan -tʋ da bɛ, e 'nan Moizi lɛ 'nan: ‹-Tɩɛ i -tɔ 'kʋ 'tazan -a? -Tɩɛ i -tɔ 'kʋe tin 'bazan 'a? ");
INSERT INTO yreNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","I ya \"vale 'yian -tɛa \"le zɩ i Ezipti min -tɛ 'sɩ bɛ -yee 'wɩ 'zʋ?› ");
INSERT INTO yreNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Zɩ Moizi 'wɩ zɩɛ -a 'man bɛ, ɛn e -tɛ -ji, e -kʋ yɔɔlɛ Mandian 'lɛglɔn 'ji. E 'nɛn 'ya -nan nun \"fli. ");
INSERT INTO yreNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Lɛ -fuba sinjɛn \"bɛ -sru, ɛn Bali -le 'pasiazan -tʋ 'e 'fli kɔɔn -yrɛ \"bui \"da Sinai pɔn \"srɔn. 'E 'fli kɔɔn -yrɛ 'tɛ nrɛn yei yibanɛn 'tʋ -va. ");
INSERT INTO yreNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Zɩ Moizi 'wɩ zɩɛ -a -nan 'yɩ bɛ, 'wɩ -a 'kan, 'pian zɩ e ya -plinan \"man 'nan -e 'e -nan yɩ bɛ, ɛn e Minsan wei 'man 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹An ya 'i tranun -le Bali -a. An ya 'i tranun Abraam 'lee Izak 'lee Zago 'le Bali -a.› Ɛn Moizi nyɔɔndɩ 'sia, ya'a -kɔlalɛ Bali -nanjɛndɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","-A -nan nɛn Minsan \"e -yrɛ 'nan: ‹'I 'yie -manwua 'sʋ 'i 'cɛin -man, kɔɔ fɛnan nɛn i cɩ 'i 'tɔdɩ bɛ, e yra kɔnglɔn 'mɛn vɛ -a. ");
INSERT INTO yreNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","An 'mɛn minnun nɛn Ezipti bɛ, -wee yra yɩdɩ 'yɩ, an -wee -paandɩ 'man, ɛn an sɔɔnla 'nan -e 'an o 'si nɔanba -ji. -Yee \"wɛan, mɛin \"paa -sia Ezipti 'lɛglɔn 'ji.› ");
INSERT INTO yreNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Moizi -tʋwli \"nɛn, \"nɛn minnun zɩɛ wa'a yɩlɛ \"yi \"dɩ, waa 'vɩ \"man 'nan: ‹-Tɩɛ i -tɔ 'kʋ 'tazan -a? -Tɩɛ i -tɔ 'kʋe tin 'bazan 'a?› bɛ, -a 'lein nɛn Bali -a 'pa 'sia 'nan 'e 'tɔ o tazan 'lee o 'sizan nɔanba -ji -a. Bali -le 'pasiazan -tʋ 'bɛ 'e 'fli kɔɔn -yrɛ yibanɛn 'va, ɛn e 'wɩ zɩɛ -a 'vɩ -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moizi 'bɛ o 'si Ezipti 'lɛglɔn 'ji -cɛ -srɔn \"wɩ 'lee 'lɛbo \"fɔ wɩnun drɛdɩ -a. -Cɛ -srɔn \"wɩnun zɩɛ yaa drɛ Ezipti 'lɛglɔn 'ji, ɛn yaa drɛ jemie 'tɛndɛn man, ɛn yaa drɛ \"bui \"da lɛ -fuba sinjɛn wlu. ");
INSERT INTO yreNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moizi 'bɔ zɩɛ, -yɛɛ 'vɩ Izraɛl 'nɔn lɛ 'nan: ‹Bali -taa \"talɛ Bali 'lewei vɩzan -tʋ nɛn \"le 'mɛn 'wɩ 'zʋ bɛ -a 'cɛɛ. -A Bali 'lewei vɩzan zɩɛ, 'ka 'bɔ 'va nɛn e bɔala.› ");
INSERT INTO yreNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tʋ nɛn Izraɛl 'nɔn 'o cin 'yɩ \"bui \"da bɛ, Moizi 'bɔ 'bɛ 'tɔ Bali 'lee Izraɛl 'nɔn yei, e -tɔ 'ka tranun 'lee Bali -le 'pasiazan nɛn e 'wɩ tin 'ba -yrɛ Sinai pɔn da bɛ o yei. Moizi lɛ nɛn Bali wei nɛn e 'belidɩ -nɔan \"bɛ, Bali 'bɔ -a -nɔn 'nan 'e vɩ 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ɛn -kaa tranun 'ka -a wei 'silɛa 'wɩ 'kpa -a dɩ, o 'ci 'pa \"man. Ɛn waa nrɔn 'o 'ji 'nan 'o lia 'o da Ezipti 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Waa 'vɩ Arɔn lɛ 'nan: ‹'I -cee balinun drɛ -e 'o 'si -kɔɔn -cɛɛ. -Yɛɛ cɩ 'nan Moizi 'bɔ nɛn e -kaa 'si Ezipti 'lɛglɔn 'ji bɛ, 'wɩ nɛn e 'bɔ \"man \"nun bɛ, -ka'a tɔa dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","-A -nan nɛn o fɛ -tʋ drɛ \"le tri -zʋ 'nan -e 'o -pan, ɛn o tri zɩɛ -a -pan. Ɛn o ci \"nrandɩ 'sia 'o 'bɔ 'pɛ drɛvɛ lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tɔɔn ɛn Bali 'e koda -tɔ o va, e o 'tʋɩ 'nan 'o laji fɛnun -pan \"le zɩ e cɩ 'e 'crɛn -tɛdɩ Bali 'lewei vɩnɔn 'le 'fluba 'ji bɛ -yee 'wɩ 'zʋ. E ya 'e 'crɛn -tɛdɩ 'nan: ‹Izraɛl 'nɔn, lɛ -fuba sinjɛn wlu te ka ya \"bui \"da bɛ, ka -wi -tɛ 'mɛn? Ɛn ka 'sraga drɛ 'mɛn? ");
INSERT INTO yreNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","-Cɛjɛ! 'Pian 'cee bali nɛn waa laabo Molok bɛ -yee -tandan nɛn 'ka 'lɔ, 'lee 'cee bali Rɔnfa -le mlɛn crɛn nɛn kaa drɛ bɛ, -nyrɛn 'ka 'lɔ. Fɛnun nɛn kaa drɛ 'nan -e 'ka -pan bɛ -nyrɛn 'ka 'lɔ. -Yee \"wɛan nɛn an 'ka \"tua, an -ko 'ka 'a Babilɔn 'lɛglɔn -sru, ka dra -wee nɔannun -a.› ");
INSERT INTO yreNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Te -kaa tranun a \"bui \"da bɛ, -tandan nɛn Bali -taa \"ji bɛ, e ya -wlɔ. Moizi -tandan zɩɛ -a -tɔ \"le zɩ Bali -a 'vɩ -yrɛ \"bɛ -yee 'wɩ 'zʋ, ɛn -a 'lein nɛn yaa 'yɩ bɛ, -nyrɛn yaa -tɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","\"Bɛ -sru ɛn -tandan 'lein zɩɛ, e -fʋ -kaa tranun -le 'nɛnnun lɔ. Zozue -trɔa o 'lɛ, ɛn o -kʋ -nyɛnlɛa 'lɛglɔn nɛn Bali -a -ji 'nɔn 'pin o 'lɛ bɛ -a -ji. O -kʋ -tandan zɩɛ -a 'lɛglɔn zɩɛ -a -ji, -tandan 'bɔ 'fʋ -nan nun -trilii, ɛn e 'bɔ David da. ");
INSERT INTO yreNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David zɩɛ e 'sɔ Bali lɛ, ɛn yaa laabʋ Bali lɔ 'nan 'e 'si -nɔn 'yrɛ -e 'e 'kɔn 'tɔ -yrɛ, 'dʋ -e Bali nɛn Zago kludanɔn 'le Bali -a bɛ 'e -nyran ji, ");
INSERT INTO yreNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","'pian Salomɔn 'bɛ 'kɔn zɩɛ -a -tɔ Bali lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Te e ya 'e vɩdɩ 'nan Bali nɛn min ta lou \"bɛ ya'a 'nyɛanla min -tɔ 'kɔn -ji dɩ. Bali 'lewei vɩzan 'wɩ zɩɛ -a 'vɩ 'e 'cɛn. Yaa 'vɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹'An Minsan, 'mɛn mingɔnnɛn pɛin a labli 'ji, ɛn 'trɛ a 'an 'cɛin -trɔa \"davɛ -a. 'Kɔn \"cɛn \"nɛn ka -kɔlaman -a -tɔdɩ -a 'mɛn? Ɛn nyin zia 'bɛ -kɔan 'an 'flinla \"nan \"a? ");
INSERT INTO yreNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","-Yɛɛ cɩ 'nan 'an 'bɔ 'pɛ drɛvɛ fɛnun pɛɛnɔn zɩɛ -a.› » ");
INSERT INTO yreNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ɛn Etiɛnɛn \"e 'nan tin 'banɔn lɛ 'nan: «Ka ya minnun nɛn 'wɩ 'ka 'ko o -wulo -ji dɩɛ, waa. Ka ya \"le minnun nɛn wa'a Bali tɔa dɩɛ -wee 'wɩ 'zʋ. 'Ka \"trɔɛn \"a \"yuyu, ɛn 'ka 'ci 'pa Bali lei 'saun 'le 'wɩ man \"le 'ka tranun 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bali 'lewei vɩzan \"cɛn \"da nɛn 'ka tranun 'ka 'tɛ 'palɛ dɩ? Bali 'lewei vɩnɔn nɛn waa 'vɩ 'nan Bali -le min tɩglɩ -taa \"talɛ bɛ, 'ka tranun o tɛɛ, ɛn 'cɛɛ min tɩglɩ zɩɛ 'bɛ 'nɔn \"nyian minnun lɛ, ɛn waa -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Zɩ Bali -le -pei -tɔ wɩnun cɩ bɛ, Bali -le 'pasianɔn -a -nɔn 'cɛɛ, ɛn ka'a 'ta wʋlɛa \"da \"dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Zɩ tin 'banɔn 'wɩ zɩɛ -a 'man bɛ, 'bli 'fɔ o ji Etiɛnɛn man, ɛn 'o 'shɛ da -blɩdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","'Pian Etiɛnɛn nɛn 'e fadɩ Bali lei 'saun 'a bɛ, 'e yiɛ 'tɔ laji, ɛn e Bali -le 'tɛ 'san 'yɩ, te e Zozi ye 'e 'tɔdɩ lou Bali -pɛ \"yi \"da. ");
INSERT INTO yreNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ɛn e 'nan: «\"Ka 'yiɔ, an labli ye 'e 'lɛ 'sʋdɩ, ɛn an Blamin -pɩ ye 'e 'tɔdɩ lou Bali -pɛ \"yi \"da.» ");
INSERT INTO yreNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Minnun -paandɩ 'sia 'plɛblɛ, te 'o 'pɛ 'wlɛ wo 'o \"trɔɛn 'ji. Ɛn o pɛɛnɔn 'kʋ Etiɛnɛn -va, waa 'kun. ");
INSERT INTO yreNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Waa plila, o -kʋ -a 'fla lunɛn, ɛn waa -sɔn -kɔlɛ -a. Minnun nɛn waa drɛ bɛ, o 'wee sɔnun -sran -gobo \"tʋ nɛn waa laabo Saul bɛ -a \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Minnun Etiɛnɛn -sɔan \"kɔlɛ -a, 'pian te Etiɛnɛn \"e Bali trʋ \"baa 'nan: «Minsan Zozi, 'an lei -nɔan 'yiɛ 'e \"pa 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","-A -nan nɛn 'e \"po sɔɔn, ɛn e paan 'plɛblɛ 'kpa. E 'nan: «Minsan, 'i 'wɩ 'wlidɩ 'gʋɛ -a 'cɛ -wlɛ.» Zɩ e cɛɛn 'wɩ zɩɛ -a vɩdɩ man bɛ, ɛn 'e yiɛ 'lɛ 'wʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul \"le 'ci 'sɔ nɛn 'nan minnun Etiɛnɛn -tɛ. Yi 'bɔ 'lein zɩɛ -a da nɛn minnun 'tɛ 'padɩ 'sia Zozinɔn nɛn Zeruzalɛm bɛ o da. Zozinɔn pɛɛnɔn fuila \"man Zude 'lee Samari 'lɛglɔn 'ji, 'pian Zozi 'le 'pasianɔn \"o -fʋʋ Zeruzalɛm. ");
INSERT INTO yreNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ɛn minnun nɛn o 'ta wʋla Bali wei tɩglɩ da bɛ, o Etiɛnɛn -wuɔ, ɛn o -kʋ -a wʋlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","'Pian Saul -le vɛ bɛ, e 'tɛ 'padɩ 'sia Zozinɔn da. E -cia 'kɔnnun 'lɛ \"nɛn 'nan -e 'e Zozinɔn \"kuun. E 'sia lɩmɔn 'lee 'klɔnmɔn man, e o 'kun, ɛn e -kʋ o -fɔlɛ -pʋ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Zozinɔn nɛn o fuila \"man \"bɛ, o ciɩ Zeruzalɛm fɛnan pɛɛnɔn 'nan Bali -le 'wɩ 'nɔnnɔn vɩdɩ -a minnun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipʋ -kʋ Samari 'lɛglɔn 'ji, ɛn e min 'sizan 'wɩ 'ji -le 'wɩ 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Samari 'nɔn 'ta \"kaga, o pɛɛnɔn o \"trɔɛn \"tɔ Filipʋ wei lɛ 'kpa tɩglɩ, te o -cɛ -srɔn \"wɩnun nɛn yaa dra bɛ -a -nan ye, 'lee 'wɩnun nɛn yaa ve bɛ, -a maan. ");
INSERT INTO yreNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","-Yɛɛ cɩ 'nan, -yʋ -wlidɩnun nɛn o ya minnun -sru \"bɛ o 'si o -sru -paandɩ -a, ɛn minnun nɛn o \"tun \"bo bɛ, 'lee minnun nɛn o -srandɩ \"tra \"bɛ, -cɛ 'si o man. ");
INSERT INTO yreNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","-A -nan nɛn ci \"nran -dan drɛ 'fla zɩɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Min -tʋ a 'fla 'bɔ zɩɛ -a da 'e 'cɛn waa laabo Simɔn. E fɛnun dra 'bui da. -Yee 'bui wɩnun drɛdɩ Samari 'nɔn 'plo 'fɔ, ɛn yaa ve 'e 'fli man 'nan 'e ya min -dan a. ");
INSERT INTO yreNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","-E 'e 'sia 'nɛn \"wɛnnɛn 'lee min ceje man, o pɛɛnɔn 'wɩnun nɛn Simɔn -a dra bɛ e o 'sianan, te waa ve 'nan: «Min 'labɛ, Bali nɛn, 'plɛblɛ -dan bɛ -nyrɛn.» ");
INSERT INTO yreNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","-Yɛɛ cɩ 'nan, o pɛɛnɔn -a wei \"siala 'wɩ 'a, kɔɔ e o 'plo 'fɔ 'yee 'bui wɩnun drɛdɩ -a, -a -nan 'mɔn. ");
INSERT INTO yreNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","'Pian zɩ Filipʋ Bali -le mingɔnnɛn -blɩdɩ 'wɩ 'vɩ, te e Zozi Crizi -le 'wɩ ve -wlɛ \"bɛ, ɛn o yi -tɛra \"da. Tɔɔn lɩmɔn 'lee 'klɔnmɔn pɛɛnɔn 'o -batize drɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔn 'bɔ \"nyian \"e \"yi -tɛra \"da, ɛn waa -batize drɛ. Zɩ waa -batize drɛ bɛ, ya'a 'silɛ \"nyian Filipʋ \"srɔn \"dɩ. -Cɛ -srɔn \"wɩ 'lee 'lɛbo \"fɔ wɩnun nɛn Simɔn -a -nan ye Filipʋ -lɔ bɛ, yaa 'plo 'fɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Zɩ Zozi 'le 'pasianɔn nɛn o -fʋ Zeruzalɛm bɛ, waa 'man 'nan Samari 'nɔn yi -tɛra Bali wei da bɛ, ɛn o Piɛri 'lee Zan 'pa 'sia o va. ");
INSERT INTO yreNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Zɩ Piɛri 'lee Zan 'bɔla o va nun bɛ, ɛn o Bali trʋ 'ba -wlɛ 'nan -e 'o Bali lei 'saun yɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","-Yɛɛ cɩ 'nan, min -tʋ 'ka tian Bali lei 'saun yɩlɛ o va dɩ, o 'o -batize drɛ 'e tɛdɛ Minsan Zozi 'tɔ da 'e \"tun. ");
INSERT INTO yreNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","-A -nan nɛn Piɛri 'lee Zan 'o 'pɛ 'pla o da, ɛn o Bali lei 'saun 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simɔn -a 'yɩ 'nan, Zozi 'le 'pasianɔn 'o 'pɛ 'pla minnun da ɛn o Bali lei 'saun 'yɩ, -a -nan nɛn Simɔn \"lala 'si, ɛn e 'nan -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«'Ka \"mɛɛn 'plɛblɛ 'nɔn \"nyian, -e -te 'an 'pɛ 'pla min da bɛ, -a san 'e Bali lei 'saun yɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","'Pian Piɛri \"e -yrɛ 'nan: «'Yie \"lala 'e 'kʋ 'yia 'tɛ nɛn ya'a 'driman dɩɛ -a va. Kɔɔ \"yie 'ji \"le o Bali -le 'plɛblɛ zɩɛ -a \"lɔa \"lala -a. ");
INSERT INTO yreNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","'Yie 'wɩ 'tʋ 'ka 'wɩ zɩɛ -a -ji dɩ, ɛn 'i 'blɩnan 'ka 'nan dɩ, kɔɔ 'i 'wulo -ji wɩ 'ka tɩglɩ Bali 'lɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","-Yee \"wɛan 'i 'si 'wɩ 'wlidɩ \"drɛdɩ man -e 'i 'fli -nɔn Bali lɛ. 'I Minsan trʋ 'ba, 'dʋ -e 'e -kɔla 'wɩ 'wlidɩ \"nɛn 'i 'wulo -ji bɛ -a fuidɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","-Yɛɛ cɩ 'nan maan -tɔa 'nan i ya 'i fadɩ 'wɩ 'wlidɩ \"nɔnnɔan -a, ɛn i ya 'wɩ 'wlidɩ \"le nɔan -a.» ");
INSERT INTO yreNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","-A -nan nɛn Simɔn \"e 'nan Piɛri 'lee Zan lɛ 'nan: «'Ka 'bɔ 'ka Minsan trʋ 'ba 'mɛn 'wɩ man -e 'wɩ nɛn kaa 'vɩ bɛ 'e vɩlɛ 'e bɔ 'an man dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","'Wɩnun nɛn Minsan Zozi -a 'vɩ 'lee 'wɩnun nɛn yaa drɛ Zan 'lee Piɛri yiɛ man bɛ, o Samari 'nɔn \"le 'vɩ. Zɩ o cɛɛn -a vɩdɩ man bɛ, ɛn o 'li 'o da Zeruzalɛm. \"Wɛɛ -ta -sia bɛ, o -tɔ Samari 'fla -mie da, te o Bali -le 'wɩ 'nɔnnɔn ve minnun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Minsan -le 'pasiazan -tʋ 'wɩ tin 'ba Filipʋ lɛ 'nan: «'I -kʋ 'trɛda \"tre 'zia, -e 'i -si nɛn e \"sia Zeruzalɛm -e 'e 'kʋ 'fla nɛn waa laabo Gaza bɛ -a 'sia. -A da 'bɛ cɩ flɩɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipʋ wluan, ɛn e -kʋ. \"Yɛɛ -kɔn -kʋnan -sia bɛ, ɛn e min -tʋ 'yɩ 'e 'lɛ. Min zɩɛ, Etiopi min nɛn, ɛn e ya 'e 'sadɩ. Etiopi lɩ Kandas nɛn mingɔnnɛn -a bɛ, -a yɩfɛ va nɛn 'e yiɛ -tɔa. E -ta Bali trʋ 'balɛ Zeruzalɛm, ");
INSERT INTO yreNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ɛn e \"ta lia 'e da 'e fla. E ya 'e -nyrandɩ odro nɛn -sʋ -a -klanman bɛ -a -ji, te e Bali 'lewei vɩzan Ezai -le 'fluba 'ta ve. ");
INSERT INTO yreNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Bali lei \"e Filipʋ lɛ 'nan: «'I -pli odro 'labɛ -a man.» ");
INSERT INTO yreNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ɛn Filipʋ sɔɔnla odro zɩɛ -a -sru, te e Etiopi min -le 'fluba ta vɩdɩ maan. E ya -a ta vɩnan Bali 'lewei vɩzan Ezai -le 'fluba 'ji, ɛn Filipʋ \"e -yrɛ 'nan: «'Fluba nɛn yia ta ve bɛ yia -ci maan?» ");
INSERT INTO yreNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Etiopi min \"e -yrɛ 'nan: «Te min 'ka 'a -kɔɔnlɛ 'mɛn dɩɛ, maan dra kɔ -e 'an -ci man?» Ɛn e Filipʋ laabʋ 'nan 'e -nyran 'e \"srɔn odro -ji. ");
INSERT INTO yreNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","'Wɩ nɛn e cɩ -a ta vɩnan Ezai -le 'fluba 'ji bɛ -nyrɛn 'gʋ: «O -kʋ -a -tɛlɛ \"le 'bla 'zʋ, ɛn o -kʋ -a \"le 'bla 'nɛn nɛn o cɩ -a \"cɛ \"bʋnan ya'a 'we dɩɛ -yee 'wɩ 'zʋ. Ya'a 'wɩ 'tʋ 'silɛ \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wa'a 'silɛa fɛ -tʋ -a dɩ, ɛn min -tʋ 'ka 'tɔlɛ -a -sru \"dɩ. -Tɩɛ -kɔlaman -a kludanɔn 'le 'wɩ vɩdɩ -a? Kɔɔ minnun 'bɛ -yee 'belidɩ 'le 'tɔ 'trɛda.» ");
INSERT INTO yreNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ɛn Etiopi min -a laabʋ Filipʋ -lɔ 'nan: «-Tɩ nɛn Bali 'lewei vɩzan -a ve 'gʋ? -A 'bɔ 'fli nɛn yaa ve, -baa min pee nɛn yaa ve?» ");
INSERT INTO yreNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","-A -nan nɛn Filipʋ Zozi 'le 'wɩ 'nɔnnɔn vɩdɩ 'sia -yrɛ, 'wɩ nɛn 'e 'crɛn -tɛdɩ zɩɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","O ya -kʋnan 'o 'lɛ, ɛn o 'bɔ 'yi ba man, ɛn Etiopi min \"e 'nan -yrɛ 'nan: «'Yi nɛn 'gʋ, -mɛ -maan yi'an -batize dra dɩ?» ");
INSERT INTO yreNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","-A -nan nɛn Filipʋ \"e -yrɛ 'nan: «-Te i yi -tɛala \"da 'i 'bli pɛɛnɔn 'a bɛ, -e 'wei -batize drɛ.» Ɛn Etiopi min \"e 'nan: «Maan -tɔa 'nan Zozi Crizi a Bali -pɩ -a.» ");
INSERT INTO yreNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ɛn Etiopi min \"e 'nan 'o odro -tɔ. -A -nan nɛn o \"flinɔn sɔɔn 'yia, ɛn Filipʋ -a -batize drɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Zɩ o 'si 'yia bɛ, ɛn Minsan lei Filipʋ 'sia, -a -nan nɛn Etiopi min 'ka \"nyian -a yɩlɛ dɩ. -A ci -fʋ 'e \"nrandɩ, ɛn e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","'Pian Filipʋ \"e 'fli 'yɩ 'fla nɛn waa laabo Azo bɛ -a da, ɛn e Bali -le 'wɩ 'nɔnnɔn vɩdɩ 'sia 'fla pɛɛnɔn nɛn e 'bɔ \"man, ɛn e 'bɔla Sezare bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tʋ zɩɛ -a man te Saul -ko tian 'tɛ 'padɩ -a Minsan -srunɔn da, te e -ko o -tɛɛdɩ -a. Ɛn Saul -kʋ Bali -pannɔn 'tazan va, ");
INSERT INTO yreNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","'nan 'e 'fluba nɛn e -si -nɔan 'yrɛ -e 'e -wla Zuif 'nɔn 'le cin yɩ 'kɔn nɛn Damas bɛ -a -ji bɛ -a -nɔn 'yrɛ. Saul \"ta -ko 'nan -e 'e 'sia lɩmɔn 'lee 'klɔnmɔn nɛn o 'ta wʋla Minsan -sru \"bɛ, -e 'e o \"kuun -e 'e 'ta waa Zeruzalɛm. ");
INSERT INTO yreNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","E Damas si 'sia e ya -kʋnan, e \"ta bɔa 'fla 'bɔ \"srɔn \"kogo 'nun tɔɔn 'tɛ 'san -tʋ bii laji, ɛn e -sɛn \"da. ");
INSERT INTO yreNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saul -tria \"tra, ɛn e wei -tʋ 'man, te 'bɛ ve -yrɛ 'nan: «Saul, Saul, -mɛ \"le \"wɛan i 'tɛ \"paa 'an da?» ");
INSERT INTO yreNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ɛn Saul \"e -yrɛ 'nan: «'An 'san, -tɩ nɛn 'yia?» Ɛn Minsan wɩɩ \"man 'nan: «'An 'bɔ Zozi nɛn i 'tɛ \"paa 'an da bɛ, maan nɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","'I 'wluan lou, 'i 'kʋ 'fla. -Te i 'bɔla 'nan nun bɛ, 'wɩ nɛn kɔ 'i drɛ bɛ, waa ve 'yiɛ.» ");
INSERT INTO yreNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Minnun nɛn o cɩ -kʋnan 'o 'vale Saul nun -a bɛ, 'wɩ ciɩla o da, wa'a -kɔlalɛ 'wɩdɩ -a dɩ, \"o wei 'bɔ maan, 'pian wa'a min -tʋ ye dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul wluan, -a yiɛ a 'e 'lɛ 'sʋdɩ, 'pian te ya'a fɛnan ye dɩ. Waa 'kun 'e 'pɛ -man, ɛn o -kʋ -a Damas. ");
INSERT INTO yreNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","E yi drɛ yaaga te ya'a fɛnan ye dɩ, ya'a 'yi mlian dɩ, ɛn ya'a fɛ ble dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Te Zozi -sruzan -tʋ a Damas, waa laabo Anania, Minsan 'wɩ tin 'ba -yrɛ \"le nyrinvla -zʋ. Yaa laabʋ Anania, ɛn Anania \"e -yrɛ 'nan: «Minsan, maan nɛn 'gʋ.» ");
INSERT INTO yreNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ɛn Minsan \"e -yrɛ 'nan: «'I 'wluan, 'i 'kʋ 'fla yei \"si nɛn 'e 'sʋdɩ \"ji tɩglɩ 'labɛ -a da, 'i 'kʋ Zudazi -le \"kɔnnɛn. Min -tʋ nɛn waa laabo Saul bɛ e ya Bali trʋ 'banan 'nan nun. Saul zɩɛ, e \"sia 'fla nɛn waa laabo Tars bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Te Saul 'bɔ \"e min -tʋ nɛn waa laabo Anania bɛ -a ye \"nyian \"le nyrinvla zʋ e wla, ɛn 'e 'pɛ 'pla \"da 'nan -e -a yiɛ 'e 'lɛ 'sʋ.» ");
INSERT INTO yreNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ɛn Anania \"e 'nan: «Minsan, 'tɛ nɛn yaa 'pa 'i -srunɔn da Zeruzalɛm bɛ, maan 'man min \"kaga \"da. ");
INSERT INTO yreNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ɛn Bali -pannɔn 'tanɔn 'si -nɔn -yrɛ 'nan, minnun pɛɛnɔn nɛn o Bali trʋ \"baa 'i 'tɔ da bɛ, 'e o \"kuun.» ");
INSERT INTO yreNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","-A -nan nɛn Minsan \"e Anania lɛ 'nan: «'I 'kʋ! -Yɛɛ cɩ 'nan, 'an 'bɔ mɛɛn min 'labɛ -a 'si \"va 'nan -e 'e 'mɛn 'nyranman 'pa, 'dʋ -e 'an 'tɔ 'e bɔla 'ji 'lɛglɔn nun 'lɛ, 'lee mingɔnnɛn nun 'lɛ 'lee Izraɛl 'nɔn 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Zɩ e -taa 'e yra yɩlɛ -e 'an 'tɔ 'e fuila \"man \"bɛ, 'an 'bɔ 'bɛ -kɔɔnman -yrɛ.» ");
INSERT INTO yreNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tɔɔn ɛn Anania -kʋ. Zɩ e 'bɔla \"kɔnnɛn \"bɛ, 'e 'pɛ 'pla Saul da, ɛn e 'nan: «'An \"bʋɩ Saul, te i ya -tanan -sia, Minsan Zozi nɛn 'e 'fli kɔɔn 'yiɛ bɛ, yaan 'pa 'sia 'nan -e 'i yiɛ 'e 'lɛ 'sʋ, 'nan -e 'i 'kɔn 'i fadɩ Bali lei 'saun 'a.» ");
INSERT INTO yreNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","'Nun tɔɔn, fɛ -tʋ 'si Saul yiɛ da \"le pɔnɛn fɛɛ 'zʋ, e -fɔla, ɛn -a yiɛ 'lɛ 'sʋ. Saul wluan lou, ɛn waa -batize drɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Zɩ e -nyan bɛ, e fɛnun blɩ, ɛn -a \"koe \"tɔ 'e da. E yi \"fli yaa drɛ Zozi -srunɔn nɛn Damas bɛ o va. ");
INSERT INTO yreNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tɔɔn ɛn e Zozi 'le 'wɩ 'nɔnnɔn vɩdɩ 'sia minnun lɛ Zuif 'nɔn 'le cin yɩ 'kuin 'nan Zozi bɛ, Bali -pɩ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Minnun pɛɛnɔn nɛn waa ye -a vɩnan bɛ 'wɩ o \"kaan, te waa ve 'nan: «Min 'labɛ, -yɛɛ minnun nɛn o Bali trʋ \"baa Zozi 'tɔ da Zeruzalɛm bɛ, o tɛɛ te e 'tɛ \"paa o da 'gʋ, ɛn e -ta \"nyian Zozinɔn \"kuunlɛ 'gʋ, ɛn e -kʋ waa Bali -pannɔn 'tanɔn lɛ. E drɛ 'kɔ, ɛn -yɛɛ 'wɩ zɩɛ -a ve?» ");
INSERT INTO yreNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","'Pian te Saul -ko Zozi 'le 'wɩ 'nɔnnɔn vɩdɩ -a minnun lɛ 'kpa tɩglɩ. 'Wɩ nɛn Saul -a ve zɩɛ, Zuif 'nɔn nɛn Damas bɛ e o klɩ 'a, ɛn wa'a -kɔlalɛ -a -zi -fɔdɩ -a dɩ. Yaa -ci -kɔɔnman -wlɛ 'wein 'nan Zozi 'bɛ cɩ min 'sizan 'wɩ 'ji -a. ");
INSERT INTO yreNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Zɩ -a -nan 'mɔn 'trilii bɛ, ɛn Zuif 'nɔn 'o cin wei -ci 'man 'nan 'o -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","'Pian -wee 'wɩ nɛn waa 'pla \"da \"bɛ, Saul -a 'man. O Saul man -pɛnnan bodrun funnin -klɔn -yrɛ \"nɛn 'nan -e 'o -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","-Yee \"wɛan -pei -tʋ man, Saul -srunɔn Saul 'si, ɛn waa sɔɔnla 'fla man -klɔn -sru saannɛn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Zɩ Saul 'bɔla Zeruzalɛm bɛ, ɛn e ya \"vale 'e -fɔa Zozi -srunɔn 'va. 'Pian o pɛɛnɔn \"klanman -yrɔ, kɔɔ wa'a yi 'tɛala \"da 'nan Zozi -sruzan nɛn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","-A -nan nɛn Barnaba -a 'kun, ɛn e -kʋ -a Zozi 'le 'pasianɔn 'va, ɛn zɩ Minsan 'e 'fli -kɔɔn Saul lɛ -sia bɛ, 'lee 'wɩ nɛn yaa 'vɩ -yrɛ \"bɛ, Barnaba -a 'vɩ -wlɛ. Ɛn zɩ Saul Zozi 'le 'wɩ 'nɔnnɔn 'vɩ 'wein Damas bɛ, Barnaba -a 'vɩ \"nyian -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","-A -nan nɛn Saul -fɔ o va, o ciɩ waa Zeruzalɛm fɛ pɛɛnɔn 'nan, te e 'wɩ 'nɔnnɔn ve minnun lɛ 'wein Minsan 'tɔ da. ");
INSERT INTO yreNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Saul 'wɩ 'vɩ Zuif 'nɔn nɛn o Grɛk wei -fɔa \"bɛ -wlɛ, ɛn o -sa -fɔ waa. 'Pian minnun zɩɛ waa -wɛɛ \"man 'nan 'o -tɛa. ");
INSERT INTO yreNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","-A \"bʋɩ Zozinɔn 'wɩ zɩɛ -a 'man, ɛn o -kʋ Saul -a Sezare 'fla, ɛn o -yrɛ 'nan 'e 'kʋ Tars. ");
INSERT INTO yreNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","-A -nan nɛn -leglizinun nɛn Zude 'lee Galile 'lee Samari 'lɛglɔn 'ji bɛ, o man flin, ɛn o -tɔ 'plɛblɛ. O 'yra -tɛa Minsan 'man, ɛn o 'ta wʋla -a -sru tɩglɩ. Bali lei 'saun 'pa o va, ɛn -leglizi -ji 'nɔn drɛ \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piɛri a ciɩnan 'fla pɛɛnɔn zɩɛ -a da. Yi -tʋ da, ɛn e 'bɔla minnun nɛn Zozi 'le vɛ -a Lida 'fla bɛ o va. ");
INSERT INTO yreNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ɛn e 'bɔ min -srandɩ \"tra \"tʋ nɛn waa laabo Ene bɛ -a man 'e nyinnandɩ -saa da. E yra \"tra -a -nan lɛ 'sɔra nɛn 'gʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ɛn Piɛri \"e -yrɛ 'nan: «Zozi Crizi 'i beli, 'i 'wluan lou 'i 'bɔ 'a -e 'i 'yie nyinnan \"davɛ plin.» 'Nun tɔɔn ɛn e wluan lou. ");
INSERT INTO yreNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida 'nɔn pɛɛnɔn 'lee minnun pɛɛnɔn nɛn o -nyɛanla Sarɔn fɛnan pɛblɛ da bɛ, zɩ o min zɩɛ -a 'yɩ te e 'ta wo bɛ, ɛn 'o 'fli -nɔn Minsan lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lɩmɔn -tʋ a Zozi 'va, e ya 'fla nɛn waa laabo Zope bɛ -a da. Lɩ zɩɛ -a 'tɔ nɛn Tabita, ɛn -te 'bɛ \"cɛɛ dɩ Dɔrka. 'Tɔ zɩɛ -a -ci nɛn Grɛk wei -ji «srʋ». Lɩ zɩɛ, e \"yi \"dra min pɛɛnɔn lɛ, te e \"paa 'yalɛ -tɛnɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tʋ nɛn te Piɛri a Lida bɛ -a man, lɩ zɩɛ e -tria -cɛ -a, e -ka. Zɩ o cɛɛn -a -srudɩ man bɛ, ɛn o -kʋ -a 'palɛa 'kɔn \"bʋ \"tʋ -ji 'kɔn 'ta lou. ");
INSERT INTO yreNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida 'fla a Zope 'fla \"srɔn \"kogo, ɛn Zozi -srunɔn -a 'man 'e 'cɛn, 'nan Piɛri a Lida. -A -nan nɛn o min \"fli 'pa 'sia 'nan 'o 'kʋ -a trʋ 'ba, 'nan 'o vɩ -yrɛ 'nan 'e 'ta 'o 'va 'trɛlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Zɩ o 'bɔ Piɛri man bɛ, waa 'vɩ -yrɛ, 'nun tɔɔn ɛn 'o 'vale waa o -kʋ. Zɩ o 'bɔla 'nan nun bɛ, ɛn o -kʋ Piɛri -a 'kɔn \"bʋ \"ji lou. Lɩmɔnnun pɛɛnɔn nɛn o -sran -ka 'o da bɛ, o pli Piɛri man te o -wua, ɛn o Tabita -le -tralɛ 'lee -yee sɔnun nɛn yaa drɛ te o ya waa bɛ, -a kɔɔn -yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ɛn Piɛri min pɛɛnɔn 'sɛn bei, 'e \"po sɔɔnla, ɛn e Bali trʋ 'ba. Tɔɔn 'e yra -tɔ min pa zɩɛ -a da, ɛn e -yrɛ 'nan: «Tabita, 'i 'wluan lou.» Ɛn 'e yiɛ 'lɛ 'sʋ. Zɩ e Piɛri 'yɩ bɛ, ɛn e -nyran lou. ");
INSERT INTO yreNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piɛri 'e 'pɛ -nɔn -yrɛ, ɛn yaa wluan lou, ɛn e -calenun 'lee Zozinɔn -mienun laabʋ. -A -nan nɛn e lɩ zɩɛ -a kɔɔn -wlɛ 'e 'belidɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Zɩ Zope 'nɔn \"kaga 'wɩ zɩɛ -a 'man bɛ, ɛn o -mienun yi -tɛradɩ 'sia Minsan da. ");
INSERT INTO yreNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piɛri -fʋ Zope 'fla tʋ \"wɛnnɛn 'a. E -fʋ min -tʋ nɛn waa laabo Simɔn bɛ -a va. Simɔn zɩɛ e -jeliba 'kɔlɛ dra. ");
INSERT INTO yreNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Min -tʋ a waa laabo Kɔrneli, e ya 'fla nɛn waa laabo Sezare bɛ -a da. Itali 'sounjanun tazan nɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kɔrneli zɩɛ, e Bali ye \"yi, ɛn e 'yra -tɛa \"man. O 'vale 'e 'mangulinun pɛɛnɔn 'a o Bali trʋ \"baa, e \"yi \"dra Zuif 'nɔn nɛn 'yalɛ o -tɛ bɛ -wlɛ, ɛn e Bali trʋ \"baa tʋ pɛɛnɔn man. ");
INSERT INTO yreNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yi -tʋ da te yidɛ tɛɛnla bɛ, e drɛ -yrɛ \"le nyrinvla zʋ, ɛn e Bali -le 'pasiazan -tʋ 'yɩ -goezee, 'bɛ wlala \"va, ɛn 'bɛ laabʋ: «Kɔrneli!» ");
INSERT INTO yreNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","E Bali -le 'pasiazan zɩɛ -a -nanjɛɛn \"klan da, ɛn e 'nan -yrɛ 'nan: «Minsan, -mɛ \"nɛn -nan?» Ɛn Bali -le 'pasiazan \"e -yrɛ 'nan: «I Bali trʋ \"baa, ɛn i \"yi dra 'yalɛ -tɛnɔn lɛ Bali -a -nan 'yɩ, ɛn -a ci 'ka 'sanlɛ 'i man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","'Bɛ nɛn 'gʋɛ, 'i minnun 'pa 'sia Zope -e 'o 'kʋ Simɔn nɛn waa laabo \"nyian Piɛri bɛ -a laabʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Simɔn zɩɛ, e -nyɛanla Simɔn nɛn e -jeliba 'kɔlɛ dra bɛ -a va. -Yee 'kɔn a jemie \"srɔn.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Zɩ Bali -le 'pasiazan nɛn e 'wɩ tin 'ba -yrɛ \"bɛ, e 'si -a \"srɔn \"bɛ, tɔɔn ɛn Kɔrneli 'yee 'nyranman 'pazan \"fli laabʋ, ɛn e 'yee 'sounjanun va 'sounja -tʋ nɛn e Bali ye \"yi, ɛn e 'yra -tɛa \"man \"bɛ -a laabʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","'Wɩ pɛɛnɔn nɛn e drɛ bɛ, e -wee 'vɩ, ɛn e o 'pa 'sia Zope. ");
INSERT INTO yreNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","-A ta tʋ cɛɛn \"wɛɛ -kɔn -kʋnan, o pli 'fla 'bɔ \"srɔn \"kogo, te Piɛri -kʋ 'kɔn 'ta lou Bali trʋ 'balɛ, te yidɛ 'bɔ min -win -ji 'sɛzɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dra Piɛri zɩɛ -a -tɛa, ɛn e ya \"vale 'e fɛ -ble. Te o ya -yee fɛ -tɔɛnnan, ɛn e drɛ -yrɛ \"le nyrinvla zʋ, ");
INSERT INTO yreNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","e labli 'yɩ 'e 'lɛ 'sʋdɩ, te e fɛ -tʋ ye \"le sɔla -dan nɛn o ya 'o 'kundɩ -a \"nɛn \"sinjɛn man bɛ -yee 'wɩ 'zʋ. E -tadɩ 'sia \"tra, te e -pliman 'trɛ man. ");
INSERT INTO yreNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","-Wi 'tɔ 'tʋdʋ pɛɛnɔn nɛn o 'ta wo 'o 'pɛ \"fli 'lee 'o 'cɛin \"fli \"da bɛ, 'lee -winun nɛn o -plimlan 'o 'kɔlɛnɛn \"bɛ 'lee \"loman 'tɔ 'tʋdʋ pɛɛnɔn a sɔ zɩɛ -a -ji. ");
INSERT INTO yreNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ɛn wei -tʋ \"e -yrɛ 'nan: «Piɛri 'i 'wluan lou, 'i -tɛ -e 'i -blɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","'Pian Piɛri \"e 'nan -yrɛ 'nan: «Minsan, te 'i vɩ 'mlɔnmlɔn dɩ. Ma'an tian 'li fɛnun nɛn e cɩ min 'srɔɛn 'a 'lee fɛnun nɛn e min \"tri -tɔa Bali 'lɛ bɛ, -a -blɩlɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ɛn wei zɩɛ e 'nan -yrɛ -a \"flizan da 'nan: «Fɛnun nɛn Bali -a vɩ 'nan e ya -blɩvɛ -a bɛ, te 'i drɛ 'i 'srɔɛn 'a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","E 'vɩ zɩɛ 'e 'pa -a yaaga, 'nun tɔɔn \"bɛ -sru, ɛn fɛ zɩɛ e -kʋ laji. ");
INSERT INTO yreNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Te Piɛri 'ka 'wɩ nɛn yaa -nan 'yɩ bɛ -a -ci maan dɩ, -a tʋ 'bɔ zɩɛ -a wlu bɛ, te minnun nɛn Kɔrneli o 'pa 'sia bɛ, o Simɔn -le 'kɔn 'yɩ, ɛn o 'bɔla \"nɛn 'sɛzɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","O min -tʋ laabʋ, ɛn o 'wɩ laabʋ -yrɔ 'nan: «Simɔn nɛn waa laabo Piɛri bɛ, e ya -nan?» ");
INSERT INTO yreNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piɛri -fʋ 'e ci \"nrɔnnan 'wɩ nɛn yaa -nan 'yɩ bɛ -a da, tɔɔn ɛn Bali lei 'saun \"e -yrɛ 'nan: «\"I 'yiɔ, min yaaga a 'i -wɛɛnan. ");
INSERT INTO yreNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","'I 'wluan lou, 'i sɔɔnla, te 'i 'ci -fɔɔ \"dɩ, -e 'ka 'kʋ waa. -Yɛɛ cɩ 'nan 'an 'bɔ 'bɛ o 'pa 'sia.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piɛri sɔɔnla, ɛn e 'nan minnun zɩɛ -wlɛ 'nan: «'An 'bɔ nɛn ka cɩ 'an -wɛɛnan bɛ, 'an 'bɔ nɛn 'gʋ. -Mɛ \"wɩ man nɛn ka -ta 'gʋ.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ɛn o 'nan -yrɛ 'nan: «'Sounjanun tazan Kɔrneli 'bɛ 'kʋ 'pa 'sia. E ya min tɩglɩ 'a Bali 'lɛ, e 'yra -tɛa Bali man, ɛn Zuif 'nɔn pɛɛnɔn -a 'tɔ \"yi \"ve. Bali -le 'pasiazan \"e 'nan -yrɛ 'nan, 'o 'lʋ 'yia 'yee vɛnan -e 'yei wei man.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tɔɔn ɛn Piɛri o wla 'yee 'kuin, ɛn o 'nyin 'nan nun. Zɩ tʋ cɛɛn bɛ, ɛn 'o 'vale Zope Zozinɔn -mienun -a, o -si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","'Bɛ 'ta tʋ cɛɛn, ɛn o 'bɔla Sezare. Kɔrneli 'e 'mangulinun 'lee 'e bee tɩglɩ tɩglɩ laabʋ 'e 'va te o ya o -pɛnnan. ");
INSERT INTO yreNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Zɩ Piɛri 'bɔla bɛ, tɔɔn ɛn Kɔrneli -kʋ -a 'lɛ, ɛn 'e \"po sɔɔn \"wlu, ɛn 'e 'wulo -fɔ 'e 'wlu. ");
INSERT INTO yreNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","'Pian Piɛri -a wluan lou te yaa ve -yrɛ 'nan: «'An 'bɔ 'gʋ, min nɛn maan \"nyian, -yee \"wɛan 'i 'wluan.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","O -kʋ -sɛɛ \"wʋdɩ -a, o wlala 'kuin, ɛn Piɛri min \"kaga 'yɩ 'o cin yɩdɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","-A -nan nɛn e 'nan -wlɛ 'nan: «Kaa -tɔa 'nan Zuif 'nɔn 'le -pei \"e 'nan: ‹Te Zuif min 'lee -pɛn min 'e 'kɔn 'e cin va dɩ, ɛn te Zuif min 'e -wla -pɛn min -le 'kuin dɩ.› 'Pian Bali -a kɔɔn 'mɛn 'nan, te min 'e vɩ min -tʋ man 'nan e ya 'e \"tri -tɔdɩ Bali 'lɛ, ɛn te 'o -pli -a san man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","-Yee \"wɛan, zɩ ka min 'pa 'sia 'an 'va bɛ, ma'an 'wɩ 'tʋ vɩlɛ dɩ, ɛn an -ta. Maan laabo \"mɛn 'ka 'lɔ 'nan, -mɛ \"wɩ man nɛn ka 'nan, 'an 'ta.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ɛn Kɔrneli \"e 'nan: «An ya Bali trʋ 'banan 'mɛn 'kuin -a -nan yi yaaga nɛn 'gʋ, te yidɛ tɛɛnla. -A -nan nɛn min -tʋ 'bɔla 'an 'lɛ. Min zɩɛ sɔ 'fuvu 'yrɩyrɩ nɛn \"da, ");
INSERT INTO yreNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ɛn e 'nan 'mɛn 'nan: ‹Kɔrneli, Bali 'i wei 'man, ɛn 'yie \"yi \"nɛn yia dra bɛ -a -cin -trɔa \"ji. ");
INSERT INTO yreNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","-Yee \"wɛan 'i min 'pa 'sia Zope Simɔn nɛn waa laabo Piɛri bɛ -a va. E -nyɛanla jemie man, Simɔn nɛn e -jeliba 'kɔlɛ dra bɛ -a va.› ");
INSERT INTO yreNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","'Nun tɔɔn ɛn an min 'pa 'sia 'i -sru, ɛn i 'bɔ \"nyian, \"i drɛ \"yi, ɛn i -ta. 'Bɛ nɛn \"mɛn 'gʋɛ, -kaa pɛɛnɔn -kaa ya Bali 'lɛ, -e 'wɩ nɛn Minsan -a 'vɩ \"yie \"lɛ bɛ -e -kaa man.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","-A -nan nɛn Piɛri -a 'bɔla 'e 'le 'nan: «'Wɩ 'kpa nɛn, maan -tɔ \"mɛn 'nan, Bali 'ka min bo \"va \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","'Pian 'trɛ pɛɛnɔn da, min nɛn e 'yra -tɛa \"man, ɛn e 'ta wʋla 'wɩ nɛn yaa 'vɩ bɛ -a da bɛ, te yaa san ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bali -ta 'e wei -a Izraɛl 'nɔn lɛ, ɛn e 'wɩ 'nɔnnɔn 'gʋɛ -a 'vɩ -wlɛ, e 'nan min -fʋdɩ -trɔɔ ye Zozi Crizi 'tɔ 'ji. -Yɛɛ cɩ min pɛɛnɔn 'san -a. ");
INSERT INTO yreNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Zɩ Zan Bali -le 'wɩ 'vɩ, ɛn e min -batize drɛ bɛ, 'wɩ nɛn e drɛ Galile 'lee Zude 'lɛglɔn pɛɛnɔn 'ji bɛ, kaa -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ɛn zɩ Bali Nazarɛtɩ min Zozi Crizi 'si \"va, ɛn -yee lei 'saun 'ta \"da \"bɛ, kaa -tɔa. Zozi ciɩ 'flanun da, te e \"yi \"dra minnun lɛ, te minnun nɛn o cɩ Satan -le 'plɛblɛ 'wlu bɛ, e -cɛ \"sia o man, kɔɔ Bali a 'e 'padɩ \"va. ");
INSERT INTO yreNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","'Wɩ pɛɛnɔn nɛn yaa drɛ Zuif 'nɔn fla 'lee Zeruzalɛm bɛ, -kaa ya -a -nan yɩnɔn 'a. Ɛn waa -tɛ -a -pɛindɩ -a yiba \"plan da. ");
INSERT INTO yreNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","-A yi yaagazan da, Bali -a wluan -kanɔn 'va, Bali -a drɛ, ɛn 'e 'fli kɔɔn. ");
INSERT INTO yreNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","'Pian min pɛɛnɔn lɛ \"cɛɛ dɩ, -kaa nɛn Bali -kaa 'si \"va 'e 'cɛn 'yee 'wɩ 'nan yɩnɔn 'a bɛ, -kaa lɛ nɛn. Zɩ e wluan -kanɔn 'va bɛ, -kaa nɛn -kaa fɛnun 'lee 'yi mlin waa 'e cin va bɛ, ");
INSERT INTO yreNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","-kaa lɛ nɛn yaa 'vɩ 'nan, -kaa 'yee 'wɩ 'nɔnnɔn vɩ Izraɛl 'nɔn lɛ. Ɛn 'nan -kaa vɩ minnun lɛ 'nan Bali 'bɛ 'si \"va, ɛn yaa -tɔ minnun nɛn o yiɛ cɩ \"man 'lee minnun nɛn o -ka bɛ -wee tin 'bazan 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bali 'lewei vɩnɔn pɛɛnɔn Zozi 'le 'wɩ 'vɩ 'nan min nɛn e yi -tɛra \"da \"bɛ, Bali -a san -le 'wɩ 'wlidɩ \"fuiman.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piɛri -fʋ 'wɩ zɩɛ -a vɩnan, ɛn Bali lei 'saun 'ta min pɛɛnɔn nɛn o cɩ -a wei mannan bɛ, o da. ");
INSERT INTO yreNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Zuif 'nɔn nɛn o cɩ Zozi 'va, ɛn o -ta Piɛri 'palɛ bɛ, zɩ Bali lei 'saun 'ta minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ o da bɛ, ɛn 'wɩ o 'kan. ");
INSERT INTO yreNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","-Yɛɛ cɩ 'nan minnun nɛn o \"we wei peenun -ji, te o Bali 'tɔ bɔa \"bɛ, \"o maan. Ɛn Piɛri -a 'vɩ \"nyian 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Min 'ka 'kɔlaman -e 'e vɩ 'nan ya'a minnun 'labɛ o -batize dra dɩ, kɔɔ o Bali lei 'saun 'yɩ \"le -cee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ɛn yaa 'vɩ minnun lɛ 'nan 'o o -batize drɛ Zozi Crizi 'tɔ da. -A -nan nɛn minnun zɩɛ, waa 'vɩ Piɛri nun lɛ 'nan, 'o yi \"fli \"drɛ 'o 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Zozi 'le 'pasianɔn 'lee o \"bʋɩ Zozinɔn nɛn Zude bɛ, waa man 'nan minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ, o wɩɩ Bali -le 'wɩ man. ");
INSERT INTO yreNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Zɩ Piɛri 'li 'e da Zeruzalɛm bɛ, ɛn Zuif 'nɔn nɛn Zozi 'va bɛ, o 'wɩ 'tɔ \"man -a vɩdɩ -a 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«I wla minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ -wee 'kuin, ɛn ka fɛnun blɩ waa 'e cin va.» ");
INSERT INTO yreNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","-A -nan nɛn 'wɩ nɛn e drɛ bɛ, Piɛri -a -ci 'vɩ -wlɛ 'e \"nɛn 'e \"nɛn. E 'nan -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«An ya Bali trʋ 'banan Zope 'fla. -A -nan nɛn e drɛ 'mɛn \"le nyrinvla zʋ, an fɛ -tʋ 'yɩ, te e -taa \"tra 'an 'va. E ya \"le sɔla -dan nɛn o ya 'o 'kundɩ -a \"nɛn \"sinjɛn man bɛ -yee 'wɩ 'zʋ, te e ya 'sinan laji, ɛn e -ta 'an \"srɔn \"kogo. ");
INSERT INTO yreNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","'An yiɛ 'tɔ -ji tɛin, ɛn an trʋvɛnun, 'lee luji winun, 'lee -winun nɛn o -plimlan o 'kɔlɛnɛn \"bɛ, 'lee \"lomannun 'yɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ɛn an wei -tʋ 'man \"nyian te 'bɛ ve 'mɛn 'nan: ‹Piɛri 'i 'wluan, 'i -tɛ, -e 'i -blɩ.› ");
INSERT INTO yreNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","'Pian maan 'vɩ 'nan: ‹Minsan, te 'i vɩ 'mlɔnmlɔn dɩ. Ma'an tian 'li fɛnun nɛn o cɩ min 'srɔɛn 'a, 'lee fɛnun nɛn o min \"tri -tɔa Bali 'lɛ bɛ -a -blɩlɛ dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Wei zɩɛ, ɛn yaa 'vɩ \"nyian laji 'e 'pee 'nan: ‹Fɛnun nɛn Bali -a 'vɩ 'nan e ya -blɩvɛ -a bɛ, te 'i drɛ 'i 'srɔɛn 'a dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","'Wɩ zɩɛ, e drɛ 'e 'pa -a yaaga, ɛn fɛnun 'bɔ 'sinan 'e -kʋ laji. ");
INSERT INTO yreNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tʋ 'bɔ 'lein zɩɛ -a wlu bɛ, te min yaaga bɔala 'kɔn nɛn an cɩ -ji bɛ -a 'lɛ \"nɛn. O o 'pa 'sia 'an 'va, o 'si Sezare. ");
INSERT INTO yreNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ɛn Bali lei 'saun \"e 'mɛn 'nan, te 'an 'ci -fɔɔ \"dɩ! 'Kʋ 'kʋ waa. \"Bʋɩnun 'shɛɛdʋ nɛn 'gʋɛ, -wɛɛ kʋ 'an 'palɛ, ɛn kʋ wla Kɔrneli -le 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","'Wɩ nɛn Kɔrneli -a 'vɩ 'kʋɛ bɛ -nyrɛn 'gʋ. E 'nan Bali -le 'pasiazan -tʋ 'bɔala 'ji 'e 'lɛ 'yee 'kuin, ɛn \"bɛ 'yrɛ 'nan: ‹'I minnun 'pa 'sia Zope -e 'o 'kʋ Simɔn nɛn waa laabo Piɛri bɛ -a laabʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","'Wɩ nɛn e -taa 'i 'silɛ 'wɩ 'ji 'ka 'vale 'i 'mangulinun -a bɛ, yaa ve 'yiɛ.› ");
INSERT INTO yreNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","An 'wɩ tin 'badɩ 'sia, tɔɔn ɛn Bali lei 'saun 'ta o da \"le zɩ e -ta -kaa da 'e tɛdɛ bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","-A -nan nɛn Minsan -le 'wɩ nɛn yaa 'vɩ bɛ, -a -cin -trɔa an 'ji. Yaa 'vɩ 'nan: ‹Zan min -batize drɛ 'yi 'a 'pian 'cee vɛ bɛ, 'ka -batize dra Bali lei 'saun 'a.› ");
INSERT INTO yreNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bali 'yee lei 'saun 'nɔn minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ -wlɛ \"le zɩ yaa -nɔn -cɛɛ te -kaa wɩɩ Minsan Zozi Crizi -le 'wɩ man bɛ -yee 'wɩ 'zʋ. -Tɩ nɛn maan -e 'an vɩ Bali lɛ 'nan, te 'e 'wɩ zɩɛ -a drɛ dɩ?» ");
INSERT INTO yreNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Zɩ o 'wɩ zɩɛ -a 'man bɛ, ɛn o ci -ta \"tra, ɛn o Bali 'tɔ bɔdɩ 'sia -a vɩdɩ -a 'nan: «\"Ka 'yiɔ, Bali -a drɛ ɛn minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ, o 'si 'o drɛ wɩ -wlidɩ \"man, ɛn o 'belidɩ tɩglɩ 'yɩ!» ");
INSERT INTO yreNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Zɩ Etiɛnɛn -ka bɛ, ɛn o 'tɛ 'padɩ 'sia Zozinɔn da. 'Tɛ 'padɩ o da zɩɛ, -yee \"wɛan Zozinɔn fuila \"man. O va min -mienun -kʋ Fenizi 'lee Sipri 'lee Antiɔs. 'Pian Zuif 'nɔn 'saza lɛ nɛn o Bali -le 'wɩ 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ɛn o va min -mienun nɛn Sipri 'nɔn 'a bɛ, 'lee Sirene 'nɔn 'a bɛ, \"o -kʋʋ Antiɔs, ɛn \"o Minsan Zozi 'le 'wɩ 'nɔnnɔn 'vɩ minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Minsan 'pa o va, ɛn min \"kaga \"yi -tɛra Zozi da, ɛn o sɔɔnla Minsan -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Zɩ Zeruzalɛm -leglizi 'nɔn 'wɩ zɩɛ -a 'man bɛ, -a -nan nɛn o Barnaba 'pa 'sia Antiɔs 'nan 'e 'kʋ -a -nan yɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Zɩ e 'bɔla 'nan nun bɛ, Bali -le \"yi \"nɛn yaa drɛ -wlɛ \"bɛ yaa -nan 'yɩ, ɛn yaa ci nran. -A -nan nɛn Barnaba o \"koe \"tɔ 'o da 'nan, te 'o 'si Minsan -sru \"fo \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","-Yɛɛ cɩ 'nan Barnaba ci a \"yi, e ya 'e fadɩ Bali lei 'saun 'a, ɛn e yi -tɛala Bali da. -A -nan nɛn min \"kaga 'kpa sɔɔnla Minsan -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ɛn Barnaba -kʋ Tars Saul -wɛɛlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Zɩ yaa 'yɩ bɛ, ɛn o -ta 'o 'vale -a Antiɔs. Waa drɛ lɛ -tʋ Antiɔs -leglizi -ji. O 'pa o va, ɛn o Bali -le 'wɩ paa minnun \"kaga 'ji. Antiɔs nɛn o minnun nɛn o 'ta 'wʋla Zozi 'le 'wɩ da bɛ o 'tɔ 'pa 'e tɛdɛ Crizi -le minnun. ");
INSERT INTO yreNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tʋ zɩɛ -a man nɛn Bali 'lewei vɩnɔn 'si Zeruzalɛm, ɛn o -kʋ Antiɔs. ");
INSERT INTO yreNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Waa -tʋ laabo Agabo, -a 'le nɛn Bali lei 'saun -a 'pa 'nan: «Dra -dan -taa \"talɛ 'trɛ pɛɛnɔn da.» Dra zɩɛ e -ta, te Klodu 'bɛ cɩ mingɔnnɛnnun tazan -a Rɔm. ");
INSERT INTO yreNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ɛn Zozinɔn -a 'pla \"da 'nan, min -tʋ 'e fɛ nɛn e -kɔlaman -a yɩdɩ -a -e 'e 'pa \"bʋɩ Zozinɔn nɛn Zude bɛ o va bɛ, -a -nɔn. ");
INSERT INTO yreNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Zɩ waa drɛ zɩɛ, ɛn -wee \"yi \"nɛn waa 'yɩ bɛ, waa -nɔn Barnaba 'lee Saul lɛ, ɛn o -kʋ -a Zude -leglizi min cejenun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tʋ zɩɛ -a man nɛn mingɔnnɛn Erodi 'tɛ 'padɩ 'sia -leglizi 'nɔn da. ");
INSERT INTO yreNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","-Yee 'sounjanun Zan \"bʋɩ Zaji -tɛ -kuli -tan sɛn -a. ");
INSERT INTO yreNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Zɩ yaa 'yɩ 'nan, 'wɩ zɩɛ e ya Zuif 'nɔn 'ci 'sɔ 'a bɛ, ɛn e 'nan 'yee 'sounjanun lɛ 'nan, 'o Piɛri 'kun. \"Fɛdi nɛn o 'kpɔun nɛn 'mannyan 'ka \"va \"dɩɛ -a -ble \"da \"bɛ -a drɛnan nɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Zɩ o Piɛri 'kun, ɛn waa -fɔ -pʋ 'kuin bɛ, -a -nan nɛn Erodi min -fuda 'shɛɛdʋ 'pla 'nan 'o yiɛ 'tɔ \"va. E bɔa \"o da min siɛnziɛn. E ya Erodi 'ji 'nan, -te 'si nɔanba -ji \"fɛdi ciɩ bɛ, -e 'o -yee tin 'ba min pɛɛnɔn yiɛ man. ");
INSERT INTO yreNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piɛri a -pʋ 'kuin, 'pian te Zozinɔn -yee Bali trʋ \"baa 'kpa tɩglɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","'Bɛ ta tʋ nɛn e \"cɛan bɛ, -a 'bɔ 'a nɛn Erodi Piɛri -le tin \"baa min pɛɛnɔn yiɛ man. -Pei zɩɛ -a man, te Piɛri a 'e nyinnandɩ 'sounja \"fli yei, te e ya yi -tɛnan. E ya 'e -yrɩdɩ -bulalɛ baa \"fli \"a, ɛn minnun nɛn o yiɛ cɩ \"va \"bɛ o yra 'o \"pa 'ji -pʋ 'kɔn 'lɛ \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","'Nun tɔɔn Minsan -le 'pasianɔn nɛn laji bɛ -a -tʋ -ta, ɛn 'tɛ 'san -tʋ bii 'kɔn \"bʋ 'bɔ 'ji. 'Pasiazan zɩɛ, 'e 'pɛ -tɛ Piɛri man, yaa fʋʋ, ɛn e -yrɛ 'nan: «'I 'wluan lou \"nyiandʋ.» -A -nan nɛn -bulalɛ baa 'si -a -pɛ -man. ");
INSERT INTO yreNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ɛn Minsan -le 'pasiazan \"e -yrɛ 'nan: «'I 'yie sɔnun -yrɩ 'i man tɩglɩ -e 'i 'yie -manwua \"wʋ.» Yaa drɛ zɩ. E 'nan \"nyian -yrɛ 'nan: «'I 'yie sɔ -gblɔ -fɔ 'i da -e 'i sɔɔnla 'an -sru.» ");
INSERT INTO yreNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piɛri 'bɔla, ɛn e sɔɔnla -a -sru. \"Yee 'ji \"le 'nan nyrinvla nɛn, \"tɔgɔ te Bali -le 'pasiazan -ta 'palɛ 'va 'yiɛ -goei 'wein 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","O ciɩ 'sounja tɛdɛ da, ɛn o ciɩ -a \"flizan da, tɔɔn ɛn o 'bɔ -bulalɛ -kpɛin \"nɛn, e 'lɛ \"so -e 'o bɔla 'ji 'fla bɛ -a man. -Kpɛin zɩɛ 'e 'lɛ 'sʋ 'e 'bɔ 'a o 'lɛ. O 'bɔla, ɛn o sɔɔnla 'fla yei \"si -tʋ da, 'nun tɔɔn ɛn Bali -le 'pasiazan 'si -a \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Zɩ Piɛri yiɛ da 'si tɩglɩ bɛ, ɛn e 'nan: «'Bɛ 'gʋɛ maan -tɔ \"mɛn 'nan 'wɩ 'kpa nɛn, Minsan 'bɛ 'yee 'pasiazan -tʋ 'pa 'sia, ɛn yaan 'si Erodi 'lee 'wɩ pɛɛnɔn nɛn Zuif 'nɔn cɩ -a -pɛnnan bɛ -yrɔ.» ");
INSERT INTO yreNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Zɩ 'wɩ zɩɛ -a -cin -trɔa Piɛri ji bɛ, ɛn e -kʋ Zan nɛn waa laabo Mark bɛ -a \"bʋ Mari -le \"kɔnnɛn. Min -mienun a 'o cin yɩdɩ -nan nun Bali trʋ 'banan. ");
INSERT INTO yreNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Zɩ Piɛri 'kɔn 'tɛ bɛ, ɛn lɩmɔn -tʋ nɛn e 'nyranman \"paa 'kɔn zɩɛ -a -ji, waa laabo Rode bɛ, e pli \"man 'nan -e 'e 'lɛ 'sʋ, ");
INSERT INTO yreNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ɛn e Piɛri wei -kɔnnɛn 'yɩ. Tɔɔn -a ci \"nrandɩ 'sia, ɛn -a ci 'san 'kɔn 'lɛ 'sʋdɩ man, ɛn e -kʋ 'pian flan -a 'kuin zia nun -a vɩlɛ 'nan: «Piɛri a bei.» ");
INSERT INTO yreNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɛn waa laabʋ -yrɔ 'nan: «'I 'ta 'ka 'e yɩdɩ dʋʋ?» 'Pian te lɩ zɩɛ yaa ve 'nan: «'Wɩ 'kpa nɛn.» -A -nan nɛn o 'nan -yrɛ 'nan: «Piɛri lei nɛn.» ");
INSERT INTO yreNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Te Piɛri 'ka 'flian 'kɔn 'tɛdɩ -a dɩ. Zɩ o 'kɔn 'lɛ 'sʋ bɛ, o Piɛri 'yɩ, ɛn 'wɩ o 'kan \"fo. ");
INSERT INTO yreNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ɛn Piɛri 'e 'pɛ drɛ -wlɛ 'nan 'o 'lɛbo 'pla \"da. -A -nan nɛn zɩ Minsan -a 'bɔla 'pʋ 'kuin bɛ, yaa pɛɛnɔn 'sinan 'pa -wlɛ. Ɛn e 'nan -wlɛ 'nan: «'Ka 'wɩ zɩɛ -a vɩ Zaji 'lee -kaa \"bʋɩ Zozinɔn -mienun lɛ.» Tɔɔn ɛn e 'bɔla e -kʋ fɛ pee -nan. ");
INSERT INTO yreNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Zɩ tʋ cɛɛn bɛ, 'wɩ -dan fɔla 'sounjanun yei, te waa laabo 'o cin lɔ 'nan: «Piɛri wla nyin?» ");
INSERT INTO yreNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erodi \"e 'nan 'sounjanun 'o -wɛɛ, waa wɛɛ, 'pian wa'a yɩlɛ dɩ. Erodi 'wɩ laabʋ 'sounjanun nɛn o yiɛ 'tɔ \"va \"bɛ -wlɔ, ɛn e 'nan 'o 'sounjanun zɩɛ 'o -tɛɛ. -A -nan nɛn Erodi 'si Zude 'lɛglɔn 'ji, ɛn e -kʋ Sezare 'fla, e 'mɔn 'nan nun. ");
INSERT INTO yreNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","'Bli a 'e 'fɔdɩ Erodi 'ji Tir 'nɔn 'lee Sidɔn 'nɔn man. 'Pian minnun zɩɛ o ci drɛ 'tʋ, ɛn o -fɔ min -tʋ nɛn waa laabo Blasitu bɛ -a -sru, 'nan -e 'e 'o yei \"paala 'o 'vale Erodi nun -a. Blasitu zɩɛ, -yɛɛ Erodi 'bɔ 'le 'kɔn 'ta -nanjɛan. -Yɛɛ cɩ 'nan -wee -blɩfɛ pɛɛnɔn \"sia 'trɛ nɛn Erodi -a \"paala bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Yi 'bɔ nɛn o -sɛan 'e cin va \"da \"bɛ, zɩ e 'bɔ bɛ, Erodi 'yee mingɔnnɛn sɔ 'wʋ, ɛn e -nyran 'yee mingɔnnɛn pɛin -da, ɛn e 'wɩ tin 'ba -wlɛ min pɛɛnɔn yiɛ man. ");
INSERT INTO yreNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Minnun pla \"man -a vɩdɩ -a 'nan: «Blamin \"cɛɛ \"we \"bɛ dɩ, Bali 'bɛ cɩ 'wɩnan.» ");
INSERT INTO yreNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","'Nun tɔɔn tʋ 'bɔ zɩɛ -a wlu bɛ, ɛn Minsan -le 'pasianɔn nɛn laji bɛ -a -tʋ 'wɩ \"nɛn kɔɔn Erodi lɛ, kɔɔ 'e 'fli 'sia \"le Bali -le 'wɩ 'zʋ. -Cɛ -tʋ -sɛn \"man, 'e sri 'si, ɛn e -ka. ");
INSERT INTO yreNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","-A -nan nɛn Bali -le 'wɩ 'nɔnnɔn 'kʋ fuiladɩ -a \"man te minnun yi -tɛala \"da 'kpa tɩglɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Zɩ Barnaba 'lee Saul cɛɛn 'wɩ nɛn o -kʋ \"man Zeruzalɛm bɛ -a drɛdɩ man bɛ, ɛn o 'li 'o da Antiɔs. -Wɛɛ ta 'o 'vale Zan nɛn waa laabo Mark bɛ waa. ");
INSERT INTO yreNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bali 'lewei vɩnɔn 'lee Bali -le 'fluba \"paanɔn a -leglizi nɛn Antiɔs bɛ -a -ji. O 'tɔ nɛn Barnaba 'lee Simeɔn nɛn waa laabo min tiidii \"bɛ 'lee Sirene min Lusiyu 'lee Manaɛl nɛn o 'vale Galile 'lɛglɔn plazan Erodi -a o o 'lɛbʋ 'e cin va bɛ 'lee Saul. ");
INSERT INTO yreNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Yi -tʋ da, te o Minsan trʋ 'ba, te o ya fɛ 'sɔnnan, -a -nan nɛn Bali lei 'saun \"e -wlɛ 'nan: «'Ka Barnaba 'lee Saul 'si \"va -e o 'nyranman nɛn an o laabʋ 'nan 'o 'pa bɛ -a 'pa.» ");
INSERT INTO yreNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","-A -nan nɛn zɩ o cɛɛn Bali trʋ 'badɩ 'lee fɛ 'sɔndɩ man bɛ, ɛn 'o 'pɛ 'pla o da, ɛn o 'si o man, o -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnaba 'lee Saul nɛn Bali lei 'saun o 'pa 'sia bɛ, o -kʋ Selusi 'fla jemie man, ɛn o -fɔ -klʋ -dan ji, ɛn o -kʋ Sipri 'trɛda 'yi yei. ");
INSERT INTO yreNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Zɩ o 'bɔla 'fla nɛn waa laabo Salami bɛ -a da bɛ, ɛn o Bali -le 'wɩ 'nɔnnɔn vɩdɩ 'sia minnun lɛ Zuif 'nɔn 'le cin yɩ 'kuin. Zan nɛn waa laabo \"nyian Mark bɛ, e ya o va, te e \"paa o va. ");
INSERT INTO yreNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","O cɛɛn 'yi yei 'trɛ zɩɛ -a 'cɛndɩ man -ji, tɔɔn ɛn o 'bɔla 'fla nɛn waa laabo Pafo bɛ -a da, ɛn o -dravia drɛzan -tʋ 'yɩ. Waa laabo Barzozi, Zuif min nɛn, 'e 'fli \"siala Bali 'lewei vɩzan -a, te e 'ka 'a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","E ya -kɔnmandan Sɛrji Polo bee -a. -Kɔnmandan zɩɛ, e 'wɩ -tɔa 'kpa tɩglɩ. -A -nan nɛn e Barnaba 'lee Saul laabʋ 'e 'va, kɔɔ e ya \"vale 'e Bali wei maan. ");
INSERT INTO yreNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","'Pian te -dravia drɛzan -tʋwli \"nɛn waa laabo \"nyian Elima Grɛk wei -ji bɛ e 'ka \"vale 'o 'ta dɩ, te yaa -wɛɛ \"man 'nan, te -kɔnmandan 'e yi -tɛra Barnaba 'lee Saul da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","-A -nan nɛn Saul nɛn waa laabo \"nyian Pɔl bɛ, e ya 'e fadɩ Bali lei 'saun 'a, ɛn e -dravia drɛzan zɩɛ -a -nanjɛɛn tɛin, ");
INSERT INTO yreNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ɛn e 'nan: «Bii 'gʋɛ, i ya 'i fadɩ -dawli wɩnun 'lee 'wɩ 'wlidɩ 'tɔ 'tʋdʋ pɛɛnɔn 'a. I ya Bali 'nanmanzan 'le 'nɛn 'a, 'wɩ \"yi pɛɛnɔn 'nanmanzan nɛn 'yia. 'I 'flin Minsan -le -si tɩglɩ ta srɛdɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","'Bɛ nɛn 'gʋɛ, \"i 'yiɔ, Minsan \"ta 'wɩ \"nɛn -kɔɔnman 'yiɛ -e 'i 'flin yidɛ 'san yɩdɩ -a fɔɔnɔn.» 'Nun tɔɔn ɛn Elima yiɛ 'wi, e -fʋ klun va, te 'e 'man limlan -pɛ pɛɛnɔn da min -wɛɛdɩ -a 'nan -e 'e 'kun 'e 'pɛ -man. ");
INSERT INTO yreNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Zɩ -kɔnmandan 'wɩ zɩɛ -a -nan 'yɩ bɛ, ɛn e -fɔ Zozi 'va. Minsan -le 'wɩ nɛn yaa 'man, ɛn yaa -nan 'yɩ bɛ, yaa 'kan 'e 'ciɩla \"da. ");
INSERT INTO yreNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔl 'lee 'e beenun -fɔ -klʋ -ji Pafo, ɛn o -kʋ Pergi 'fla Panfili 'lɛglɔn 'ji. Zan nɛn waa laabo Mark bɛ, e 'si o -sru, ɛn e 'li 'e da Zeruzalɛm. ");
INSERT INTO yreNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","O 'si Pergi, ɛn o -kʋ Antiɔs 'fla Pisidi 'lɛglɔn 'ji. 'Flinla \"yi da, o wla Zuif 'nɔn 'le cin yɩ 'kuin, ɛn o -nyran. ");
INSERT INTO yreNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Zɩ o cɛɛn Bali -le 'wɩ mandɩ man -pei 'fluba 'ji 'lee Bali 'lewei vɩnɔn 'le 'fluba 'ji bɛ, ɛn Zuif 'nɔn 'le cin yɩ 'kɔn 'tazan min 'pa 'sia Pɔl 'lee Barnaba -va 'nan 'o laabʋ -wlɔ 'nan: «\"Bʋɩnun, -te 'wɩ -mie a 'ka 'ji -e 'ka 'kʋ \"koe \"tɔ 'kʋ da bɛ, 'ka vɩ \"mɛn!» ");
INSERT INTO yreNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ɛn Pɔl wluan 'e 'pɛ nyɔɔn 'nan, te 'o sɔɔ -tɔ \"nyian dɩ, ɛn e 'nan: «'Ka Izraɛl 'nɔn, 'lee kaa nɛn ka Izraɛl 'nɔn 'le Bali bɔa \"bɛ, 'ka \"trɔɛn \"tɔ 'mɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Izraɛl 'nɔn 'le Bali -kaa tranun 'si \"va, ɛn o 'pa Izraɛl 'nɔn 'va, ɛn o 'bɔ \"kaga te o ya Ezipti 'lɛglɔn 'ji. \"Bɛ -sru, ɛn Bali o 'si Ezipti 'yee 'plɛblɛ 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Bali 'e yiɛ 'tɔ 'yee 'nɛnnun va \"bui \"da lɛ -fuba sinjɛn wlu. ");
INSERT INTO yreNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Bali 'lɛglɔn 'sɔravli srɛ Kanan 'lɛglɔn 'ji, ɛn e -wee 'trɛ 'nɔn 'yee minnun lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","-A pɛɛnɔn zɩɛ e drɛ lɛ yaa sinjɛn -fuba 'soolu 'wlu. \"Bɛ -sru, ɛn e -kaa tranun -le tin 'banɔn 'nɔn 'trilii, ɛn e 'bɔ Bali 'lewei vɩzan Sanmian da. ");
INSERT INTO yreNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","-A -nan nɛn -kaa tranun -a laabʋ 'nan Sanmian 'e mingɔnnɛn -tɔ 'o da. Ɛn Bali Kis -pɩ Saul -tɔ o da, Bɛnzamɛn -le 'lɛglɔn 'ji min nɛn. Zɩ e mingɔnnɛn blɩ o da lɛ -fuba sinjɛn wlu bɛ, ");
INSERT INTO yreNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","\"bɛ -sru Bali -a -nyran, ɛn yaa ta fɔɔ David -a. David zɩɛ Bali 'bɔ -a 'vɩ \"man 'nan: ‹An Jese -pɩ David 'yɩ, 'an 'ci 'sɔ \"ji \"min nɛn, e -taa 'an 'ci 'sɔ wɩ pɛɛnɔn drɛlɛ bɛ -a.› ");
INSERT INTO yreNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","David zɩɛ, -a kluda nɛn, Bali 'bɔ Zozi 'bɔla min 'sizan 'wɩ 'ji -a, \"le zɩ yaa 'vɩ 'e 'cɛn bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Te Zozi 'ka tian Bali -le 'wɩ 'nɔnnɔn vɩdɩ 'silɛa dɩɛ, Zan -a 'vɩ Izraɛl 'nɔn lɛ 'nan, 'o 'si 'o drɛ wɩ -wlidɩ \"man, 'o 'fli -nɔn Bali lɛ, -e 'o 'ta 'o -batize drɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Te Zan -le 'nyranman 'padɩ \"ta -nyan \"bɛ, yaa 'vɩ 'nan: ‹Min nɛn 'ka 'ci \"nrɔnman \"da \"bɛ, ma'an \"cɛɛ dɩ, 'pian e -taa \"mɛn -sru. 'An 'bɔ an 'ka -a cɛin -man -manwua \"tun \"da baa \"fluzan -a dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","\"Bʋɩnun, kaa nɛn ka cɩ Abraam kludanɔn 'a bɛ, 'lee minnun nɛn 'ka yei te o 'yra -tɛa Bali man bɛ, -kaa lɛ nɛn Bali cɩ 'yee 'wɩ nɛn e min \"sia 'wɩ 'ji bɛ -a vɩnan. ");
INSERT INTO yreNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","-Yɛɛ cɩ 'nan, Zeruzalɛm minnun tanɔn 'lee Zeruzalɛm 'nɔn 'ka -a -tɔlɛ 'nan Zozi 'bɛ cɩ min 'sizan 'wɩ 'ji -a dɩ, ɛn wa'a Bali 'lewei vɩnɔn wei nɛn waa ta 'vɩ -wlɛ 'flinla \"yi -tʋdʋ pɛɛnɔn da bɛ -a -ci manlɛ dɩ. 'Pian 'wɩ nɛn Bali 'lewei vɩnɔn -a 'vɩ bɛ, waa 'lɛ sɔɔ Zozi 'tɛdɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wa'a 'wɩ 'tʋ yɩlɛ Zozi man -e min 'e 'ka -a 'wɩ 'ji dɩ, 'pian waa 'vɩ Pilati lɛ 'nan, 'e -nɔn minnun lɛ -e 'o -tɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","'Wɩ pɛɛnɔn nɛn e cɩ 'e 'crɛn -tɛdɩ Zozi 'le 'wɩ 'a bɛ, zɩ 'e 'lɛ sɔɔ bɛ, waa 'si yiba \"plan da, ɛn o -kʋ -a wʋlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","'Pian Bali -a wluan -kanɔn 'va, ");
INSERT INTO yreNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ɛn 'e 'fli kɔɔn yi \"kaga 'wlu minnun nɛn o 'si waa Galile, ɛn o -kʋ Zeruzalɛm bɛ -wlɛ. Ɛn 'bɛ 'gʋɛ -wɛɛ drɛ -yee 'wɩ 'nan yɩnɔn 'a, te o -yee 'wɩ ve Izraɛl 'nɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ɛn 'kʋ 'bɔ 'gʋ, kʋ -ta 'wɩ 'nɔnnɔn nɛn Bali -tɔ 'e wei da -kaa tranun lɛ 'nan 'e dra bɛ -a vɩlɛ 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","'Wɩ zɩɛ, yaa 'lɛ sɔɔ -kaa nɛn -kaa cɩ o kluda 'nɔn 'a bɛ -cɛɛ: E Zozi wluan -kanɔn 'va. E ya 'e 'crɛn -tɛdɩ \"dre 'fluba 'la \"fli \"ji 'e 'cɛn 'nan: ‹Yiɛ cɩ 'mɛn 'nɛn 'a, -e 'e 'sia cɛɛgʋ man bɛ, an drɛ 'i \"tɩ \"a.› ");
INSERT INTO yreNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","'Wɩ nɛn Bali -a 'vɩ 'e 'cɛn 'nan, 'e Zozi wuanla -kanɔn 'va, 'dʋ -e 'e vɩlɛ 'e 'fʋ -a -nan nɛn min fʋlɩman bɛ -a -nan dɩɛ -nyrɛn 'gʋ: ‹-Fɛa tɩglɩ nɛn an -tɔ 'an wei da 'nan 'an ve David man bɛ, ya'a 'nyaan dɩ, ɛn e ya tian 'cee vɛ -a.› ");
INSERT INTO yreNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","-Yee \"wɛan nɛn Bali -a 'vɩ David -le \"dre 'fluba pee ji 'nan: ‹Yi'a 'yie 'nɛn 'saun 'tʋe -e 'e fʋlɩ -yrɛ -ji dɩ.› ");
INSERT INTO yreNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David -le vɛ bɛ, \"e Bali 'su \"le zɩ Bali -a 'vɩ bɛ -yee 'wɩ 'zʋ. Ɛn -a -kadɩ 'bɔ, waa 'wʋ 'e tranun \"srɔn, ɛn e fʋlɩ 'yrɛ -ji. ");
INSERT INTO yreNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","'Pian Zozi 'ka fʋlɩlɛ -yrɛ -ji dɩ, Bali -a wluan -kanɔn 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","-Yee \"wɛan, \"bʋɩnun, 'ka -tɔ 'nan Zozi 'tɔ 'ji nɛn waa ve 'cɛɛ cɛɛgʋ 'nan, Bali 'cee 'wɩ 'wlidɩ fui. 'Ta wʋladɩ Moizi -le -pei -tɔ wɩnun da 'ka -kɔlalɛ 'cee 'wɩ 'wlidɩ \"fuidɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","'Pian minnun pɛɛnɔn nɛn o yi -tɛra Zozi da bɛ, Bali o \"siala min tɩglɩ 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","-Yee \"wɛan, 'wɩ nɛn 'e vɩdɩ Bali 'lewei vɩnɔn 'le 'fluba 'ji bɛ, 'ka drɛ \"yi, te 'e bɔ 'ka man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","E ya 'e 'crɛn -tɛdɩ 'nan: ‹Min sɛɛ wʋnɔn \"ka 'yiɔ, 'wɩ 'e 'ka 'kan -e 'ka 'san \"fo. -Yɛɛ cɩ 'nan 'ka yiɛ -kɔan \"man -e 'an 'wɩ 'tʋ nɛn e -ciala min da bɛ -a drɛ. -Te waa -nan -sɛɛ \"wʋ 'cɛɛ -e 'ka vɩlɛ 'ka yi -tɛra \"da \"dɩ.› » ");
INSERT INTO yreNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Zɩ Pɔl 'lee Barnaba \"ta bɔala -wee cin yɩ 'kuin bɛ, ɛn o 'nan -wlɛ 'nan, 'o 'ta 'flinla \"yi pee -a -e 'o 'wɩ 'lein zɩɛ -a vɩ \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Zɩ cin yɩdɩ -nyan bɛ, o \"ta fuimlan \"man, ɛn Zuif 'nɔn \"kaga 'lee minnun nɛn o Izraɛl 'nɔn 'le Bali bɔa \"bɛ, o sɔɔnla Pɔl 'lee Barnaba -sru. Pɔl 'lee Barnaba 'bɔ 'bɛ 'wɩ tin 'ba -wlɛ, ɛn o o \"koe \"tɔ 'o da 'nan 'o 'fʋ Bali -le \"yi 'wlu 'li 'trilii. ");
INSERT INTO yreNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","'Flinla \"yi pee nɛn e 'bɔ bɛ, 'fla 'bɔ da 'nɔn pɛɛnɔn 'bɛ cin 'yɩ 'nan -e 'o Bali wei man. ");
INSERT INTO yreNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Zɩ Zuif 'nɔn min \"kaga zɩɛ o 'yɩ bɛ, ɛn man bʋdɩ wla o ji, te 'wɩ nɛn Pɔl -a ve bɛ, waa fuimlan 'nan 'wɩ 'pee -a, te waa \"srɔn man. ");
INSERT INTO yreNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","-A -nan nɛn Pɔl 'lee Barnaba -a -ci 'vɩ -wlɛ 'wein 'nan: «'Ka Zuif 'nɔn, 'ka lɛ nɛn paan 'kʋ Bali -le 'wɩ 'nɔnnɔn ve 'e 'flin, 'pian kaa -tua 'ka 'pɛla koda. \"Cɛɛ drɛ zɩɛ, kaa -kɔɔnman 'nan, ka'a 'ka 'fli ye 'belidɩ nɛn ya'a 'nyaan dɩɛ -a yɩnɔn 'a dɩ. -Yee \"wɛan kʋ -ko 'siɛn minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ o va. ");
INSERT INTO yreNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","-Yɛɛ cɩ 'nan 'wɩ nɛn Minsan \"e 'nan 'kʋ drɛ bɛ -nyrɛn 'nan: ‹Mɛin drɛ 'tɛ 'san nɛn e 'lɛglɔn pɛɛnɔn 'ji dra 'wein bɛ -a. 'I vɩ minnun lɛ 'trɛ pɛɛnɔn da 'nan Bali 'o \"sia 'wɩ 'ji.› » ");
INSERT INTO yreNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Zɩ minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ o 'wɩ zɩɛ -a 'man bɛ, o ci nran, ɛn o 'nan, Minsan wei a 'nɔnnɔn. -A -nan nɛn minnun pɛɛnɔn nɛn Bali o 'si \"va 'nan -e 'o 'kɔn 'belidɩ nɛn ya'a 'nyaan dɩɛ -a yɩnɔn 'a bɛ, o yi -tɛradɩ 'sia Zozi da. ");
INSERT INTO yreNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tɔɔn ɛn Minsan -le 'wɩ 'nɔnnɔn 'kʋ fuiladɩ -a \"man 'lɛglɔn zɩɛ -a da \"fo. ");
INSERT INTO yreNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","'Pian Antiɔs 'fla 'bɔ da bɛ lɩmɔnnun nɛn o Izraɛl 'nɔn 'le Bali bɔa, te o mangulinun a fɛnɔn 'a bɛ, o ya -nan. Zuif 'nɔn o 'pa 'o 'va 'lee 'fla 'bɔ da min cejenun, ɛn o 'tɛ 'padɩ 'sia Pɔl 'lee Barnaba da, ɛn o Pɔl 'lee Barnaba -pin 'o fla. ");
INSERT INTO yreNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tɔɔn 'o 'cɛin -man fuɔn -koei plu o da, -a -kɔɔndɩ -a -wlɛ 'nan 'o 'pɛ 'si -wee 'wɩ 'ji, ɛn o -kʋ 'fla nɛn waa laabo Ikomiɛn bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","'Pian Zozinɔn nɛn Antiɔs bɛ o -fʋ ci \"nran -a, ɛn o -fʋ 'o fadɩ Bali lei 'saun 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Zɩ Pɔl 'lee Barnaba 'bɔla Ikomiɛn bɛ, ɛn o wla \"nyian Zuif 'nɔn 'le cin yɩ 'kuin. O Bali -le 'wɩ 'nɔnnɔn 'vɩ -wlɛ, -a -nan nɛn Zuif 'nɔn \"kaga 'lee minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ, o -fɔ Zozi 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","'Pian Zuif 'nɔn nɛn o 'ka \"vale o yi -tɛala 'wɩ zɩɛ -a da dɩɛ, o 'wɩ wʋʋman minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ 'o 'ji, te 'o 'wulo -ji \"nrɔnman -wlidɩ \"bʋɩ Zozinɔn man. ");
INSERT INTO yreNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔl 'lee Barnaba 'mɔn 'kpa tɩglɩ Ikomiɛn. O yi -tɛra Minsan da, ɛn o -yee 'wɩ 'nɔnnɔn nɛn e min \"sia 'wɩ 'ji bɛ -a 'vɩ 'kpa tɩglɩ. Bali 'pa o va, -a -nan nɛn o -cɛ -srɔn \"wɩnun 'lee 'lɛbo \"fɔ wɩnun drɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Min \"kaga cɛɛn 'e cin man 'fla 'bɔ da, min -mienun a Zuif 'nɔn -sru, ɛn min -mienun a Zozi 'le 'pasianɔn -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Zɩ minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ, 'lee Zuif 'nɔn, 'lee 'o 'tanɔn a 'o man wʋʋnan 'nan -e 'o 'tɛ 'pa Pɔl 'lee Barnaba da, -e 'o -kɔlɛ wɛɛn o va bɛ, ");
INSERT INTO yreNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ɛn Pɔl 'lee Barnaba a -kɔnnɛn 'yɩ, -a -nan nɛn o flan bli, o -kʋ Lisiani 'lɛglɔn 'ji 'flanun nɛn o o laabo Lisitri 'lee Dɛrbʋ bɛ -a da, 'lee o \"srɔn 'flanun da. ");
INSERT INTO yreNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ɛn o Bali -le 'wɩ 'nɔnnɔn 'vɩ 'nan nun. ");
INSERT INTO yreNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Min -tʋ a Lisitri 'fla, e ya 'e -srandɩ \"tra. Waa -ya 'e 'lɔ le -a, ya'a tian 'li 'ta wʋlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","'Wɩ nɛn Pɔl cɩ -a vɩnan bɛ, -a \"trɔɛn \"a -yrɛ, -a -nan nɛn Pɔl -a -nanjɛn tɛin, ɛn Pɔl -a -tɔ 'nan min zɩɛ e yi -tɛala 'yee 'belidɩ da, ");
INSERT INTO yreNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ɛn Pɔl \"e -yrɛ wei 'plɛblɛ 'ji 'nan: «'I 'wluan lou 'i 'cɛin -da tɩglɩ.» 'Nun tɔɔn e drɛ \"klɩ, ɛn e wluan, ɛn e 'ta wʋdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","'Wɩ nɛn Pɔl -a drɛ bɛ, zɩ minnun -a -nan 'yɩ bɛ, ɛn o -paandɩ 'sia -a vɩdɩ -a Lisiani wei -ji 'nan: «Bali lila \"da \"minnun -a, ɛn o 'bɔla -kaa 'va.» ");
INSERT INTO yreNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Te o Barnaba laabo «Zeus», ɛn o Pɔl \"le laabo «Ermɛs», kɔɔ -yɛɛ 'wɩ tin 'ba 'le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","\"Wɛɛ bɔla -wee fla 'bɔ da bɛ, -wee bali Zeus 'bɔ 'pan 'kɔn a 'e 'tɔdɩ -nan. -A -nan nɛn -wee Zeus -panzan -ta trinun -a 'fla 'bɔ man -klɔn -yrɛ \"nɛn te lu -fui \"a 'e 'fɔdɩ o -blɔ -man. Zeus -panzan 'bɔ 'lee minnun \"kaga \"a \"vale 'nan 'o Zozi 'le 'pasianɔn 'bɔ -paan. ");
INSERT INTO yreNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","'Pian zɩ Zozi 'le 'pasianɔn Barnaba 'lee Pɔl 'wɩ zɩɛ -a 'man bɛ, o ta kli, -a 'wɩ 'nan o man, ɛn o 'wee sɔnun 'fʋɩ bʋʋ 'o da, ɛn o -kʋ minnun yei \"nun, te o -paan \"man -wlɛ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«-Mɛ \"wɛan nɛn kaa dra zɩɛ, minnun \"tun \"nɛn 'kʋ 'a \"le 'cee 'wɩ 'zʋ. Kʋ -ta Bali -le 'wɩ 'nɔnnɔn vɩlɛ 'cɛɛ, 'nan -e 'ka 'si 'cee 'wɩ \"tun \"nun 'labɛ -a drɛdɩ man, -e 'ka -sɔɔnla Bali nɛn -a yiɛ cɩ \"man \"bɛ -a -sru. -Yɛɛ 'trɛ drɛ, ɛn -yɛɛ la drɛ, ɛn -yɛɛ jemie drɛ 'lee 'e 'va fɛnun pɛɛnɔn. ");
INSERT INTO yreNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","'Li 'e tɛdɛ bɛ, e minnun 'tʋɩ, ɛn o sɔɔnla 'o 'bɔ 'ci 'sɔ wɩnun -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","'Pian ya'a 'flinlɛ 'yee \"yi \"ci -kɔɔndɩ -a dɩ. -Yɛɛ cɩ 'nan e laa \"sia laji te yaa -fɛan 'cɛɛ, e 'cee fɛ 'wlɛnun dra 'e tʋ -man, e ci \"nrandɩ 'lee -blɩfɛ -nɔan 'cɛɛ \"kaga.» ");
INSERT INTO yreNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pɔl 'lee Barnaba \"koe \"nyan -a vɩdɩ -a -wlɛ 'nan, te 'o 'o 'pan dɩ, 'vaa ɛn waa 'man. ");
INSERT INTO yreNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","-A -nan nɛn Zuif 'nɔn 'si Antiɔs 'lee Ikomiɛn, ɛn o -sɛn minnun zɩɛ o va, ɛn o Pɔl -sɔn -kɔlɛ -a. Waa plila, o -kʋ -a lunɛn 'o 'ci nrɔn 'nan e -ka. ");
INSERT INTO yreNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","'Pian zɩ Zozinɔn -a si -fɔ bɛ, ɛn Pɔl wluan lou, e -ta 'fla. -A ta tʋ cɛɛn ɛn Pɔl 'lee Barnaba -kʋ Dɛrbʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","O Bali -le 'wɩ 'nɔnnɔn 'vɩ 'fla zɩɛ -a da, ɛn min \"kaga \"fɔ Zozi 'va. -A -nan nɛn o 'li 'o da Lisitri 'lee Ikomiɛn 'lee Antiɔs Pisidi. ");
INSERT INTO yreNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","O -ta Zozinɔn \"koe \"tɔdɩ -a 'o da, te o 'wɩ \"paala -wlɛ 'nan, 'o yi -tɛra Bali da 'li 'trilii, te waa ve -wlɛ 'nan: «-Kaa yra ye \"kaga 'vaa, -e -kaa kʋ Bali -le mingɔnnɛn trɛda.» ");
INSERT INTO yreNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","-Te o 'bɔla -leglizi -tʋ -nan -e 'o -wee min cejenun -tɔɔ, ɛn -te o cɛɛn Bali trʋ 'badɩ 'lee fɛ 'sɔndɩ man, -e 'o o -pɛba wʋ Minsan nɛn o yi -tɛra \"da \"bɛ -yrɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Zɩ Pɔl 'lee Barnaba Pisidi 'lɛglɔn cɛɛn bɛ, ɛn o 'bɔla Panfili 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","O Bali -le 'wɩ 'nɔnnɔn 'vɩ Pergi, ɛn o sɔɔn \"ji Atali. ");
INSERT INTO yreNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","'Fla zɩɛ -a da nɛn o -fɔ -klʋ -ji, ɛn o 'li 'o da Antiɔs. Antiɔs 'bɔ 'nan nɛn o o -pɛba 'wʋ Bali lɔ 'nan 'e \"yi drɛ -wlɛ, -e 'nyranman nɛn o \"sia -a 'panan zɩɛ bɛ o 'pa. ");
INSERT INTO yreNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Zɩ o 'bɔla Antiɔs bɛ, ɛn o -leglizi 'nɔn cin 'yɩ, ɛn 'wɩnun nɛn Bali ciɩla o va yaa drɛ bɛ, waa 'sinan 'pa. Waa -ci 'vɩ \"nyian -wlɛ 'nan, minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ, Bali -si 'lɛ 'sʋ -wlɛ 'nan 'o yi -tɛra 'e da. ");
INSERT INTO yreNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","\"Bɛ -sru Pɔl 'lee Barnaba -fʋ o va tʋ \"kaga 'kpa -a. ");
INSERT INTO yreNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Min -mienun 'si Zude 'lɛglɔn 'ji. Zɩ o 'bɔla Antiɔs bɛ, ɛn o 'wɩ \"paadɩ 'sia \"bʋɩ Zozinɔn 'ji, waa 'vɩ -wlɛ 'nan: «-Te min 'ka 'fɔlɛ -klɔnmɔn -va \"le zɩ Moizi -le -pei -a 'vɩ bɛ -yee 'wɩ 'zʋ dɩɛ, Bali 'ka -a san sia 'wɩ 'ji dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔl 'lee Barnaba 'ka 'wɩ zɩɛ -a manlɛ \"yi \"fo \"dɩ, ɛn -sa 'plɛblɛ 'fɔla o yei 'wɩ zɩɛ -a da. -A -nan nɛn minnun -a 'pla \"da 'nan, Pɔl 'lee Barnaba 'lee Zozinɔn -mienun 'o 'kʋ 'wɩ zɩɛ -a tin 'ba Zeruzalɛm 'o 'vale Zozi 'le 'pasianɔn 'lee -a -nan -leglizi min cejenun -a. ");
INSERT INTO yreNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ɛn Antiɔs -leglizi 'pa o va -wee -kʋdɩ -ji. \"Wɛɛ -kʋ, o ciɩla Fenizi 'lee Samari, te 'wɩ nɛn e drɛ 'lɔɔ, ɛn minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ, o sɔɔnla Bali -sru \"bɛ, te o -ko -a -nan wɩ vɩdɩ -a Zozinɔn lɛ. 'Wɩ zɩɛ -a vɩdɩ ci \"nran -dan nɔn \"bʋɩ Zozinɔn pɛɛnɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Zɩ o 'bɔla Zeruzalɛm bɛ, -leglizi 'nɔn 'lee Zozi 'le 'pasianɔn 'lee -leglizi min cejenun o 'sia 'kpa tɩglɩ, ɛn 'wɩ pɛɛnɔn nɛn Bali ciɩla o va yaa drɛ bɛ, waa -nan 'sinan 'pa -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","-A -nan nɛn Farizɛn 'nɔn 'va min -mienun nɛn o drɛ Zozinɔn 'a bɛ, o wluan lou, ɛn o 'nan: «Minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ, o o -fɔa paan 'klɔnmɔn -va -e 'o vɩ -wlɛ 'nan 'o 'ta wʋla Moizi -le -peinun da.» ");
INSERT INTO yreNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Zozi 'le 'pasianɔn 'lee -leglizi min cejenun 'o cin 'yɩ, 'nan -e 'o 'wɩ zɩɛ -a 'pla \"da. ");
INSERT INTO yreNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Zɩ o cɛɛn -sa 'plɛblɛ 'fɔdɩ man 'o cin yei \"bɛ, Piɛri wluan lou, ɛn e -wlɛ 'nan: «'An \"bʋɩnun, kaa -tɔa 'nan 'cee Bali an 'si \"va -e 'an 'yee 'wɩ 'nɔnnɔn vɩ minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ -wlɛ, 'dʋ -e 'o 'fli -nɔn Bali lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ɛn Bali 'bɔ nɛn e min ci wɩ -tɔa \"bɛ, yaa -ci kɔɔn 'yee lei 'saun 'nɔndɩ -a -wlɛ 'nan o ya 'yee vɛ -a \"le zɩ yaa -nɔn -cɛɛ bɛ -yee 'wɩ 'zʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Bali 'ka -kaa 'cɛnlɛ 'e cin man -kaa 'vale waa dɩ. E -wee 'wɩ 'wlidɩ fui 'nan o yi -tɛra 'e da -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ɛn -mɛ \"le \"wɛan nɛn ka Bali man -wɛɛman? -Yɛɛ cɩ 'nan -trɔ cibɛn nɛn -kaa tranun 'ka -kɔlalɛ -a siadɩ -a dɩ, ɛn -kaa 'bɔ 'ka 'kɔlaman -a siadɩ -a dɩɛ, ka ya \"vale 'ka -tɔa \"mɛn Zozinɔn 'win -ji. ");
INSERT INTO yreNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","'Pian -kaa yi -tɛala \"da 'nan, Minsan Zozi 'bɔ 'le \"yi \"le \"wɛan nɛn -kaa 'si 'wɩ 'ji \"le -wee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","'Nun tɔɔn minnun nɛn 'o cin yɩdɩ bɛ, 'o 'ta -sɛn, ɛn o Barnaba 'lee Pɔl wei mandɩ 'sia, ɛn 'lɛbo \"fɔ wɩ nɛn Bali ciɩla o va yaa drɛ minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ o yei \"bɛ, waa 'vɩ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Zɩ o cɛɛn -a vɩdɩ man bɛ, ɛn Zaji -a vɩdɩ 'sia 'nan: «\"Bʋɩnun, 'ka \"trɔɛn \"tɔ 'mɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɔn \"sia 'wɩ 'tʋ vɩnan -cɛɛ. E 'nan: Bali 'bɔ minnun 'sidɩ 'sia 'yee vɛ -a, minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ o yei, 'nan -e 'wee 'tɔ bɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ɛn Bali 'lewei vɩnɔn 'le 'wɩ nɛn waa crɛn -tɛ bɛ, 'wɩ zɩɛ yaa 'lɛ sɔɔ. -Yɛɛ cɩ 'nan, e ya 'e 'crɛn -tɛdɩ 'nan: ");
INSERT INTO yreNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Bali \"e 'nan: ‹\"Bɛ -sru an lia 'an da -e 'an David -le 'kɔn nɛn e -wi bɛ, -a pee -tɔ. -A \"pa 'ji nɛn e -fʋ -nan bɛ, maan -tɔɔman 'e cin da -e 'an 'wluan lou, ");
INSERT INTO yreNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","'dʋ -e min -mienun nɛn o -fʋ bɛ, 'o Minsan -wɛɛ 'o 'vale 'lɛglɔn -mienun nɛn 'an 'tɔ yra o man bɛ waa. ");
INSERT INTO yreNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","'An 'bɔ Minsan, 'wɩ nɛn maan 'vɩ 'e 'cɛn -a -nan lɛ 'ka lɛ va dɩɛ, maan 'lɛ sɔɔman.› » ");
INSERT INTO yreNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ɛn Zaji -a 'le 'sran 'nan: «-Yee \"wɛan, e ya 'an 'ji 'nan, minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ, ɛn o sɔɔnla Bali -sru \"bɛ, e ya \"yi -e min 'e vɩlɛ 'e 'tɔ o -sru 'nan 'o 'ta wʋla Moizi -le -pei da dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","'Pian -kaa 'fluba 'crɛn -tɛ -wlɛ 'nan, te 'o 'wi nɛn waa -tɛ -yʋ lɛ bɛ -a -blɩ dɩ, ɛn te 'o cin nan 'lee 'o cin -sran -wɛɛ \"dɩ, ɛn te min 'e \"blu -wɛɛ \"dɩ. Ɛn te 'o 'wi nɛn min 'ka -a -blɔ 'cɛnlɛ -e -a nyɛn 'e -sran dɩɛ -a -blɩ dɩ, ɛn te 'o 'wi nyɛn -blɩ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","-Yɛɛ cɩ 'nan, 'li 'e 'cɛn bɛ Moizi -le -pei -tɔ wɩnun zɩɛ 'flanɔn pɛɛnɔn -a -tɔa, kɔɔ waa ta ve minnun lɛ Zuif 'nɔn 'le cin yɩ 'kuin tʋ pɛɛnɔn man 'flinla \"yi da.» ");
INSERT INTO yreNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","-A -nan nɛn Zozi 'le 'pasianɔn, 'lee min cejenun, 'lee -leglizi 'nɔn pɛɛnɔn wei drɛ 'tʋ, ɛn o min -mienun 'si o yei, ɛn o o 'pa 'sia Antiɔs 'o 'vale Pɔl 'lee Barnaba -a. Zudazi nɛn waa laabo \"nyian Barsaba bɛ 'lee Sila nɛn Zozinɔn 'yra -tɛa \"o man bɛ, o nɛn o o 'si o yei. ");
INSERT INTO yreNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","'Fluba nɛn waa -nɔn -wlɛ \"bɛ -nyrɛn 'gʋ: «'Kʋ Zozi 'le 'pasianɔn 'lee min cejenun 'bɛ 'fluba 'crɛn -tɛ 'ka Zozinɔn nɛn ka cɩ Antiɔs 'lee Siri 'lɛglɔn 'ji 'lee Silisi 'lɛglɔn 'ji, te o 'ka Zuif 'nɔn 'a dɩɛ, 'cɛɛ. Kʋ ya 'ka \"bʋɩnun -a, kʋ \"we 'ka 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kʋa 'man 'nan, 'kʋ 'va min -mienun nɛn kʋ'a 'si -nɔnlɛ 'wlɛ \"dɩɛ, o 'lʋ 'ka 'ci baalɛ -ji 'wee 'wɩ \"paadɩ -a, ɛn o 'ka \"koe 'si 'ka da. ");
INSERT INTO yreNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","-Yee \"wɛan, zɩ 'kʋ cin wei -ci 'man bɛ, ɛn kʋa 'yɩ 'nan, e ya \"yi -e 'kʋ min -mienun 'si \"va -e 'kʋ o 'pa 'sia 'cɛɛ 'o 'vale 'kʋ \"bʋɩ Barnaba 'lee Pɔl nɛn kʋ o ye \"yi \"bɛ waa. ");
INSERT INTO yreNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Min \"fli zɩɛ, e -fʋ \"wɛnnɔn -e 'o 'ka -kaa san Zozi Crizi 'tɔ 'ji. ");
INSERT INTO yreNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ɛn kʋ Zudazi 'lee Sila 'pa 'sia 'nan 'o 'wɩ 'bɔ 'lein 'gʋɛ -a vɩ 'cɛɛ 'o 'bɔ 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","-Yɛɛ cɩ 'nan Bali lei 'saun 'lee 'kʋ 'bɔ, 'wɩ nɛn 'kɔ 'ka 'ta wʋla \"da \"bɛ, kʋɛ 'vɩ 'cɛɛ, kʋ'a 'wɩ 'pee 'palɛ \"va \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","'Bɛ 'wɩ zɩɛ, 'bɛ cɩ 'nan: Te 'ka 'wi nɛn waa -tɛ -yʋ lɛ bɛ -a -blɩ dɩ, ɛn te 'ka 'wi nyɛn -blɩ dɩ, ɛn te 'ka 'wi nɛn min 'ka -a -blɔ 'cɛnlɛ -e -a nyɛn 'e -sran dɩɛ -a -blɩ dɩ, ɛn te 'ka cin nan 'lee 'ka cin -sran -wɛɛ \"dɩ, ɛn te min 'e \"blu -wɛɛ \"dɩ. 'Wɩnun zɩɛ, 'ka 'ta wʋla \"da. Kʋ 'ka 'tɔ bo.» ");
INSERT INTO yreNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","-A -nan nɛn o o 'pa 'sia, ɛn o -kʋ Antiɔs. Zɩ o 'bɔla 'nan nun bɛ, ɛn o Zozinɔn cin 'yɩ, ɛn o 'fluba zɩɛ -a -nɔn -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Waa ta 'vɩ, ɛn o pɛɛnɔn 'ci nran, e o \"koe \"tɔ 'o da -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Zudazi 'lee Sila nɛn Bali 'lewei vɩnɔn 'a bɛ, o 'wɩ \"kaga tin 'ba -wlɛ, o man -tɔ 'plɛblɛ, ɛn o \"koe \"tɔ 'o da. ");
INSERT INTO yreNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","O -fʋ Antiɔs 'fla tʋ \"wɛnnɛn 'a 'vaa, ɛn Zozinɔn 'kʋ o 'palɛ -sia -trɔɔ 'nan -e 'o li 'o da Zeruzalɛm. ");
INSERT INTO yreNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","'Pian Sila \"e 'vɩ 'nan \"e -foo Antiɔs 'fla. ");
INSERT INTO yreNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔl 'lee Barnaba \"o -fʋʋ Antiɔs, ɛn 'o 'vale min \"kaga \"a o 'wɩ paa minnun ji, ɛn o Minsan -le 'wɩ 'nɔnnɔn 'vɩ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Yi \"fli yaa \"bɛ -sru, ɛn Pɔl \"e 'nan Barnaba lɛ 'nan: «'Fla pɛɛnɔn nɛn kʋ ciɩ \"da Minsan -le 'wɩ 'nɔnnɔn vɩdɩ -a bɛ, 'kʋ 'ciɩ \"nyian \"da -e 'kʋ \"bʋɩ Zozinɔn nɛn -nan nun bɛ o yɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba a \"vale 'nan Zan nɛn waa laabo Mark bɛ 'e 'kʋla 'o -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","'Pian Pɔl 'ka 'wɩlɛ \"man -e 'o 'kʋ waa dɩ, kɔɔ Mark 'nyranman 'tʋɩ o man Panfili 'lɛglɔn 'ji, ɛn e 'si o -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pɔl 'lee Barnaba wei 'ka drɛlɛ -tʋwli \"fo \"dɩ, -a -nan nɛn o cɛɛn 'e cin man. Barnaba Mark -fɔ 'e -sru, ɛn o -fɔ -klʋ -dan ji, o -kʋ Sipri 'trɛda. ");
INSERT INTO yreNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pɔl \"e Sila -fɔ 'e -sru, ɛn Zozinɔn o -pɛba 'wʋ Bali lɔ, ɛn o -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","O ciɩla Siri 'lɛglɔn 'lee Silisi 'lɛglɔn 'ji, te o -ko Zozinɔn \"koe \"tɔdɩ -a 'o da. ");
INSERT INTO yreNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","-A -nan nɛn Pɔl ciɩla Dɛrbʋ, ɛn e 'bɔla Lisitri. 'Fla zɩɛ -a da bɛ, Zozi -sruzan 'tʋ a -nan, waa laabo Timote. -A \"tɩ \"a Grɛk min -a, lɩmɔn -tʋ nɛn e ya Zozi 'va bɛ -yee 'nɛn nɛn, Zuif lɩ nɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","-A 'tɔ \"yi \"a Zozinɔn nɛn Lisitri 'lee Ikomiɛn bɛ o 'le. ");
INSERT INTO yreNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔl a \"vale 'e 'kʋ 'o 'vale 'waa, ɛn e -kʋ -a -fɔlɛ -klɔnmɔn -va, Zuif 'nɔn nɛn fɛ zɩɛ -a -nan bɛ -wee \"wɛan. Kɔɔ o pɛɛnɔn -a -tɔa 'nan Timote \"tɩ \"a Grɛk min -a. ");
INSERT INTO yreNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","'Flanun nɛn o ciɩla \"da \"bɛ, 'wɩ nɛn Zozi 'le 'pasianɔn 'lee Zeruzalɛm min cejenun -a 'vɩ bɛ, waa 'vɩ 'fla zɩɛ -a da 'nɔn lɛ, 'nan 'o 'ta wʋla \"da. ");
INSERT INTO yreNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","-A -nan nɛn Zozinɔn 'le yi -tɛradɩ Bali da 'pa \"da, te Zozinɔn 'ko bɔdɩ -a \"kaga yi -tʋdʋ pɛɛnɔn man. ");
INSERT INTO yreNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔl a \"vale 'o 'kʋ Bali -le 'wɩ 'nɔnnɔn vɩ Azi 'lɛglɔn 'ji, 'pian Bali lei 'saun 'ka 'wɩlɛ \"man \"dɩ. -Yee \"wɛan o ciɩla Pirigi 'lee Galatɩ 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Zɩ o 'bɔla Misi 'lɛglɔn 'ji bɛ, ɛn waa man wɛɛ 'nan 'o 'ko Bitini 'lɛglɔn 'ji, 'pian Zozi lei 'saun 'ka 'wɩlɛ \"man \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","-A -nan nɛn o ciɩla Misi, ɛn o 'bɔla Troas 'fla. ");
INSERT INTO yreNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","-Pei -man, e drɛ Pɔl lɛ \"le nyrinvla -zʋ, e drɛ -yrɛ \"le Masedɔa min -tʋ a 'e 'tɔdɩ lou, te yaa trʋ \"baa -a vɩdɩ -a 'nan: «'I ciɩla Masedɔa 'lɛglɔn 'ji, 'i 'ta 'pa 'kʋ 'va!» ");
INSERT INTO yreNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Zɩ Pɔl 'wɩ zɩɛ -a -nan 'yɩ \"le nyrinvla -zʋ bɛ, ɛn kʋa man wɛɛ 'nan 'kʋ 'kʋ Masedɔa 'lɛglɔn 'ji, kɔɔ kʋa -tɔa 'nan Bali 'kʋ laabʋ 'nan -e 'kʋ 'yee 'wɩ 'nɔnnɔn vɩ -nan nun. ");
INSERT INTO yreNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Zɩ kʋ -fɔ -klʋ -dan ji Troas bɛ, ɛn kʋ -kʋ Samotras. 'Bɛ 'ta tʋ cɛɛn ɛn kʋ -kʋ Neapoli. ");
INSERT INTO yreNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kʋ 'si 'bɛ 'nan, ɛn kʋ -kʋ Filipʋ 'fla. Filipʋ 'fla zɩɛ, -yɛɛ cɩ Masedɔa 'lɛglɔn 'ji 'fla tɛdɛ -a, ɛn Rɔm 'nɔn 'bɛ 'fla 'bɔ 'tɔ. Kʋ -fʋ 'fla zɩɛ -a da tʋ \"wɛnnɛn 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","'Flinla \"yi da, kʋ 'si 'fla zɩɛ -a da, ɛn kʋ -kʋ lu \"nɛn 'yi 'tʋ \"srɔn. -A -cin a 'kʋ 'ji 'nan Zuif 'nɔn 'le Bali trʋ 'banan -kɔan fɛ zɩɛ -a -nan. Zɩ kʋ cɛɛn -nyrandɩ man bɛ, ɛn lɩmɔnnun nɛn 'o cin yɩdɩ fɛ zɩɛ -a -nan bɛ, kʋ 'wɩ tin 'badɩ 'sia -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lɩmɔn -tʋ a fɛ zɩɛ -a -nan te e 'yra -tɛa Bali man, -a 'tɔ nɛn Lidi, e \"sia Tiatire. Min -dandan nun ta sɔ nɛn yaa -taan. E ya 'wɩ zɩɛ -a mannan, ɛn Minsan -a \"trɔɛn 'lɛ 'sʋ, ɛn 'wɩ nɛn Pɔl cɩ -a vɩnan bɛ, yaa -ci 'man 'kpa tɩglɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","-A -nan nɛn waa -batize drɛ 'o 'vale 'e 'mangulinun -a, ɛn e 'kʋ trʋ 'ba -a vɩdɩ -a 'nan: «-Te kaa \"nrɔnman 'ka 'ji 'nan, an wɩɩ Minsan man 'an 'bli pɛɛnɔn 'a bɛ, 'ka 'fʋ 'an 'va tʋ \"wɛnnɛn 'a.» E kɔala 'wɩ zɩɛ -a man, ɛn kʋ wɩɩ \"man. ");
INSERT INTO yreNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Te kʋ \"ta -ko fɛnan nɛn o Bali trʋ \"baa bɛ -a -nan, ɛn nɔan lɩmɔn -tʋ -ta 'kʋ 'lɛ. Lɩ zɩɛ -mlɛngan a -a -sru, e -pɛ -tɔala, -yee \"wɛan minnun nɛn waa \"paala bɛ o \"lala ye \"man \"kaga. ");
INSERT INTO yreNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","E sɔɔnla 'kʋ 'vale Pɔl -a 'kʋ -sru, te e -paan \"man 'nan: «Minnun 'labɛ, Bali nɛn min ta lou \"bɛ, -yee 'nyranman 'panɔn nɛn waa. O ya Bali -le 'wɩ nɛn e min \"sia 'wɩ 'ji bɛ -a vɩnan 'cɛɛ.» ");
INSERT INTO yreNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Yaa 'vɩ zɩɛ yi \"kaga 'wlu, tɔɔn Pɔl 'ka 'vale e 'wɩ zɩɛ -a maan \"nyian dɩ, ɛn e 'man lila \"da, e 'nan -yʋ nɛn -a -sru \"bɛ -yrɛ 'nan: «'An 'bɔ \"e 'yiɛ 'nan Zozi Crizi 'tɔ da, 'i 'si lɩ 'gʋɛ -a -sru.» Ɛn -yʋ zɩɛ e 'si -a -sru 'nun. ");
INSERT INTO yreNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nɔan lɩmɔn zɩɛ minnun nɛn waa \"paala bɛ, zɩ waa 'yɩ 'nan wa'a \"nyian \"lala ye lɩ zɩɛ -a man dɩɛ, ɛn o Pɔl 'lee Sila 'kun, o -kʋ waa 'fla 'tanɔn 'lɛ fɛnan nɛn o tin \"baa bɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Zɩ o -kʋ waa tin 'banɔn 'lɛ bɛ, ɛn o 'nan: «-Vɛ -mienun 'gʋɛ, o -tein -tria 'kʋ flanɔn yei, Zuif 'nɔn nɛn waa. ");
INSERT INTO yreNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","O ya \"vale o 'wɩ -trɛ \"paaman 'kʋ 'ji, kʋ'a 'we \"man \"dɩ, ɛn kʋ'a 'kɔlaman -e 'kʋ 'ta wʋla \"da \"dɩ, kʋ ya Rɔm 'nɔn 'a -le \"wɛan.» ");
INSERT INTO yreNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","-A -nan nɛn 'bli 'fɔ min \"kaga 'ji o man, ɛn tin 'banɔn \"e 'nan minnun lɛ 'nan, 'o -wee sɔnun \"koo 'o man, ɛn 'o o -sɔn sɔnba \"a. ");
INSERT INTO yreNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Zɩ o cɛɛn o -sɔndɩ man bɛ, ɛn o o -fɔ -pʋ 'kuin. Waa 'vɩ min nɛn 'e yiɛ -tɔa \"o va bɛ -yrɛ 'nan, 'e yiɛ 'tɔ o va 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Zɩ min zɩɛ e 'wɩ zɩɛ -a 'man bɛ, ɛn e o -fɔ -pʋ 'kɔn kplo -ji, ɛn e 'ploblo 'fɔ o cɛin -man. ");
INSERT INTO yreNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","-Pei -man te bada -tɔ, ɛn Pɔl 'lee Sila Bali trʋ 'badɩ 'sia, te o Bali 'tɔ bɔ \"dre -fɔa, te minnun nɛn -pʋ 'kuin bɛ, o o wei maan. ");
INSERT INTO yreNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","'Nun tɔɔn ɛn 'trɛ nyɔɔn, e nyɔɔn 'plɛblɛ \"bʋʋ \"le \"wɛan -pʋ 'kɔn nyɔɔn 'e 'klu -ji. Tʋ 'bɔ zɩɛ -a wlu, ɛn -pʋ 'kɔn -kpɛin pɛɛnɔn 'lɛ 'sʋ, ɛn fɛnun nɛn 'e 'fɔdɩ -pʋ 'kɔnnɔn 'cɛin -man bɛ, -a pɛɛnɔn 'lɛ 'sʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Zɩ min nɛn 'e yiɛ -tɔa \"o va bɛ e fuʋ bɛ, e -kpɛinnun 'yɩ 'e 'lɛ 'sʋdɩ, ɛn e 'yee srɛn 'sʋ 'ji 'nan -e 'e 'fli -tɛ, kɔɔ yaa nrɔn 'e 'ji 'nan -pʋ 'kɔnnɔn pɛɛnɔn 'tɛ -ji. ");
INSERT INTO yreNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","'Pian Pɔl paan -yrɛ wei 'plɛblɛ 'ji 'nan: «Te 'i 'wɩ 'wlidɩ \"drɛ 'i 'fli lɛ dɩ, kʋ ya 'gʋ 'kʋ pɛɛnɔn.» ");
INSERT INTO yreNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tɔɔn ɛn min zɩɛ e 'nan 'o 'tɛ 'bi, ɛn e wla \"nyiandʋ -pʋ 'kɔnnɔn 'va, ɛn e blula Pɔl 'lee Sila wlu, te e nyɔɔnman. ");
INSERT INTO yreNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","\"Bɛ -sru e o 'bɔla bei, ɛn yaa laabʋ -wlɔ 'nan: «'An \"tɩnun, maan dra 'kɔ -e 'an 'si 'wɩ 'ji?» ");
INSERT INTO yreNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ɛn o -yrɛ 'nan: «'I yi -tɛra Minsan Zozi da -e 'ka 'vale 'yie \"kɔnnɛn 'nɔn 'a 'ka 'si 'wɩ 'ji.» ");
INSERT INTO yreNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","-A -nan nɛn o Minsan -le 'wɩ 'nɔnnɔn 'vɩ -yrɛ 'o 'vale 'yee \"kɔnnɛn 'nɔn pɛɛnɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","-Pei 'bɔ 'lein zɩɛ -a man bɛ, min nɛn 'e yiɛ -tɔa -pʋ 'kɔnnɔn 'va bɛ, e -kʋ Pɔl 'lee Sila mlɔn 'ji \"foelɛ. 'Nun tɔɔn ɛn waa -batize drɛ 'o 'vale 'yee \"kɔnnɛn 'nɔn 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","E -kʋ waa 'yee 'kuin, ɛn e fɛnun -nɔn -wlɛ, waa blɩ. -A -nan nɛn -a ci \"nrandɩ 'sia 'o 'vale 'yee \"kɔnnɛn 'nɔn pɛɛnɔn 'a, e yi -tɛra Bali da -le \"wɛan. ");
INSERT INTO yreNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Zɩ tʋ cɛɛn bɛ, ɛn tin 'banɔn minnun 'pa 'sia, 'nan 'o vɩ min nɛn e yiɛ -tɔa -pʋ 'kɔnnɔn 'va bɛ -yrɛ 'nan, 'e 'si o man. ");
INSERT INTO yreNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ɛn min nɛn 'e yiɛ -tɔa -pʋ 'kɔnnɔn 'va bɛ, e 'wɩ 'gʋɛ -a 'vɩ Pɔl lɛ. E 'nan: «Tin 'banɔn min 'pa 'sia 'nan, 'an 'si 'ka man. -Yee \"wɛan 'ka bɔla, 'ka 'kʋ, 'ka 'fʋ -trɔɔ.» ");
INSERT INTO yreNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","'Pian Pɔl -a 'vɩ 'pasianɔn lɛ 'nan: «O 'kʋ 'sɔn minnun yiɛ man, ɛn o 'kʋ 'fɔ -pʋ 'kuin, wa'a 'wɩ zɩɛ -a -ci vɩlɛ dɩ, -e te kʋ ya Rɔm 'nɔn 'a, ɛn o ya \"vale 'o \"sia 'kʋ man 'e yɔɔdɩ. -Yee \"wɛan kʋ'a 'we \"man \"dɩ. 'O 'ta 'kʋ bɔla 'o 'bɔ 'a.» ");
INSERT INTO yreNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ɛn 'pasianɔn 'kʋ 'wɩ zɩɛ -a vɩlɛ tin 'banɔn lɛ. Zɩ tin 'banɔn -a 'man 'nan, Rɔm 'nɔn nɛn waa bɛ, nyɛn o cɛɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tin 'banɔn 'ta toba -fɔlɛ -wlɛ, ɛn o o 'bɔla -pʋ 'kuin, ɛn waa 'vɩ -wlɛ 'nan, 'o yra 'si, 'o 'si 'fla 'bɔ da. ");
INSERT INTO yreNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Zɩ o 'bɔla -pʋ 'kuin bɛ, ɛn o -kʋ Lidi -va, 'o cin 'yɩ 'o 'vale 'o \"bʋɩ Zozinɔn 'a. O o \"koe \"tɔ o da 'vaa, ɛn o 'si 'fla 'bɔ da. ");
INSERT INTO yreNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","O ciɩla Anfipoli 'fla 'lee Apoloni 'fla, ɛn o 'bɔla Tesalonik. Zuif 'nɔn 'le cin yɩ 'kɔn a fɛ zɩɛ -a -nan. ");
INSERT INTO yreNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔl wla cin yɩ 'kɔn zɩɛ -a -ji \"le yaa dra 'e 'cɛn bɛ -yee 'wɩ 'zʋ. 'Flinla \"yi yaaga 'a 'e cin -sru, te Pɔl 'wɩ nɛn 'e 'crɛn -tɛdɩ Bali -le 'fluba 'ji bɛ -a ve -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pɔl -a ta ve -wlɛ, te yaa -ci ve -wlɛ 'nan, e ya 'e vɩdɩ 'nan min 'sizan 'wɩ 'ji 'e yra yɩ, -e 'e 'ka, -e 'e 'wluan -kanɔn 'va. Ɛn e 'nan: «Zozi nɛn an -yee 'wɩ ve 'cɛɛ 'gʋɛ, -yɛɛ cɩ min 'sizan 'wɩ 'ji -a.» ");
INSERT INTO yreNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Min plɔɛnnun 'wɩ zɩɛ -a 'man 'wɩ 'kpa -a, ɛn o -fɔ Pɔl 'lee Sila -sru, 'lee Grɛk 'nɔn \"kaga \"nɛn o 'yra -tɛa Bali man bɛ, 'lee lɩmɔn -mienun nɛn o 'yra -tɛa \"o man 'fla bɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","'Pian man bʋdɩ wla Zuif 'nɔn 'ji, ɛn o yiɛ 'plɛnɔn kuun 'fla yei, o o -sɛn 'o 'va, ɛn o 'wɩ 'fɔla 'fla. O -kʋ 'wɩ 'tɔlɛ min -tʋ nɛn waa laabo Zasɔn bɛ -a man 'yee \"kɔnnɛn 'nan, 'e Pɔl 'lee Sila -nɔn 'wlɛ -e 'o 'kʋ waa 'flanɔn 'lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Wa'a Pɔl 'lee Sila yɩlɛ dɩ, ɛn o Zasɔn 'lee \"bʋɩ Zozinɔn -mienun 'kun, ɛn o -kʋ waa 'fla 'tanɔn 'lɛ, te o -paanman -a vɩdɩ -a 'nan: «Minnun nɛn o 'trɛda baa 'ji bɛ, o -ta 'gʋ, ɛn Zasɔn o 'sia. ");
INSERT INTO yreNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Mingɔnnɛnnun tazan nɛn Rɔm bɛ, -yee -pei -tɔ wɩnun bɛ, o ya -a srɛnan. Waa 'vɩ 'nan, mingɔnnɛn -tʋ a \"nyian, wɛɛ laabo Zozi.» ");
INSERT INTO yreNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","'Wɩ zɩɛ e 'nan 'fla 'tanɔn 'lee minnun man. ");
INSERT INTO yreNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Zasɔn 'lee \"bʋɩ Zozinɔn -mienun -a man pan 'wʋ -wlɛ 'vaa, ɛn o 'si o man. ");
INSERT INTO yreNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Zɩ -pei 'tan bɛ, ɛn Zozinɔn 'kʋ Pɔl 'lee Sila 'palɛ -sia, ɛn o -kʋ Bere 'fla. Zɩ o 'bɔla 'nan nun bɛ, ɛn o wla Zuif 'nɔn 'le cin yɩ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","'Fla zɩɛ -a da 'nɔn bɛ -wee 'wɩ a \"yi, ɛn o 'wɩ maan e \"mlian Tesalonik 'nɔn da. Waa -wɛɛman 'nan 'o Bali wei maan. Bali wei nɛn 'e 'crɛn -tɛdɩ bɛ, waa ta ve tʋ pɛɛnɔn man, -e 'wɩ nɛn Pɔl a ve -wlɛ \"bɛ, 'o -tɔ 'nan 'wɩ 'kpa nɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","O va Zuif 'nɔn \"kaga \"yi -tɛra Zozi da, 'lee Grɛk lɩmɔn -mienun nɛn o 'yra -tɛa \"o man bɛ, 'lee -klɔnmɔn \"kaga 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","'Pian zɩ Tesalonik Zuif 'nɔn -a 'man 'nan, Pɔl a Bali -le 'wɩ 'nɔnnɔn vɩnan Bere bɛ, ɛn o -ta 'wɩ 'fɔlɛa 'fla zɩɛ -a da 'nɔn yei. ");
INSERT INTO yreNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","-A -nan nɛn Zozinɔn 'kʋ Pɔl 'palɛ -sia jemie man. 'Pian Sila 'lee Timote \"o fʋʋ 'fla 'bɔ da. ");
INSERT INTO yreNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Minnun nɛn o -kʋ Pɔl 'palɛ -sia bɛ o 'bɔ 'a Atɛn 'fla, ɛn o 'li 'o da. Pɔl o kalɩ 'nan 'o vɩ Timote 'lee Sila lɛ 'nan 'o 'lʋ tada. ");
INSERT INTO yreNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Te Pɔl a Sila 'lee Timote -pɛnnan Atɛn 'fla bɛ, ɛn e 'fla zɩɛ -a da 'yɩ 'e fadɩ -yʋ nɛn waa -paan \"bɛ -a. 'Wɩ zɩɛ e 'nan \"man. ");
INSERT INTO yreNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","-Yee \"wɛan Pɔl 'wɩ tin 'ba Zuif 'nɔn 'lee minnun nɛn o 'yra -tɛa Bali man bɛ -wlɛ cin yɩ 'kuin, ɛn minnun nɛn e bɔa \"o man -guada tʋ pɛɛnɔn man bɛ, e 'wɩ tin 'ba \"nyian -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","'Fluba 'tɔnɔn nɛn o cɩ Epikuri -sru \"bɛ, 'lee o nɛn Sitoiki -sru \"bɛ, o -sa -fɔdɩ 'sia 'o 'vale Pɔl -a. O -mienun -a laabʋ 'nan: «-Mɛ \"wɩ nɛn sɔɔ -tɔzan 'labɛ yaa ve?» O -mienun \"o \"ve 'nan: «Maan ye \"le 'nan 'lɛglɔn pee -le Bali -le 'wɩ nɛn yaa ve.» -Yɛɛ cɩ 'nan Pɔl a Zozi 'le 'wɩ 'nɔnnɔn vɩnan, te e minnun nɛn o -ka bɛ -wee wluandɩ -kanɔn 'va 'wɩ ve, -yee \"wɛan o 'wɩ zɩɛ -a 'vɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","-A -nan nɛn o Pɔl 'kun, ɛn o -kʋ -a tin 'banɔn 'lɛ fɛnan nɛn waa laabo Aeropaz bɛ -a -nan. Waa laabʋ -yrɔ 'nan: «'Wɩ -trɛ nɛn i cɩ -a \"paanan 'gʋɛ, kʋ ya \"vale \"kʋ maan. ");
INSERT INTO yreNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","-Yɛɛ cɩ 'nan 'wɩ nɛn e -ciala 'kʋ da bɛ, -nyrɛn yia ve 'kʋɛ. -Yee \"wɛan kʋ ya \"vale 'kʋ 'wɩ zɩɛ -a -ci maan.» ");
INSERT INTO yreNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atɛn 'nɔn 'lee -pɛn 'nɔn nɛn Atɛn 'fla bɛ, -sɛɛ \"wʋdɩ 'lee 'sinan -trɛnun nɛn waa mandɩ ye \"yi. ");
INSERT INTO yreNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ɛn Pɔl wluan lou tin 'ba 'nɔn yei, ɛn e 'nan: «Atɛn 'flanɔn, maan -tɔa 'nan 'cee balinun a 'ka 'yra -tɛa \"o man 'kpa. ");
INSERT INTO yreNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","-Yɛɛ cɩ 'nan \"mɛɛn vɩnan 'an 'ciɩ 'ka fla yei \"bɛ, an 'cee balinun -pannan 'yɩ. An Bali -pan \"davɛ -tʋ 'yɩ te waa crɛn -tɛ \"man 'nan: ‹E ya Bali nɛn kʋ'a tɔa dɩɛ -yee vɛ -a.› Bali 'bɔ nɛn kaa -paan te ka'a tɔa dɩɛ, an -ta 'nan -e 'an -yee 'wɩ vɩ 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Bali nɛn e 'trɛ 'lee 'e ta fɛnun pɛɛnɔn drɛ bɛ, -yɛɛ cɩ Minsan nɛn e 'trɛ 'lee la \"paala bɛ -a, ɛn ya'a 'nyɛanla min -pɛ drɛ fɛnun ji dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ɛn ya'a wɛɛman 'nan min 'e 'pɛ \"nɛn \"fɛ 'si -e 'e -nɔn 'yrɛ dɩ. -Yɛɛ cɩ 'nan Bali 'bɔ 'bɛ min ci fulɔ 'lee 'belidɩ 'lee fɛ pɛɛnɔn -nɔan \"min lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Bali 'bɔ -a drɛ, ɛn 'lɛglɔn pɛɛnɔn \"tɩ \"a -tʋwli, ɛn e -wee 'trɛ 'leda drɛ, ɛn e -wee lɛ \"nɛn 'pla. ");
INSERT INTO yreNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yaa drɛ zɩɛ, 'nan -e minnun 'o 'e -wɛɛ 'o 'pɛ \"paadɩ -a fɛ pɛɛnɔn 'nan, 'nan -e 'wee yɩ. 'Pian -e te Bali 'bɔ 'ka -kaa man -kɔɔbli dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","-Yɛɛ drɛ ɛn -kaa ya 'trɛda, ɛn -yɛɛ -maan -kaa kla -kaa man, ɛn -yɛɛ 'belidɩ -nɔn -cɛɛ. 'Ka 'bɔ 'va 'fluba 'tɔnɔn 'wɩ zɩɛ -a crɛn -tɛ 'va, waa crɛn -tɛ 'nan: ‹'Wɩ 'kpa, -kaa ya -yee 'nɛnnun -a.› ");
INSERT INTO yreNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ɛn -te -kaa ya -yee 'nɛnnun -a bɛ, -ka'a 'kɔlaman paan -e -kaa ci \"nrɔn 'nan, -kaa Bali -kɔɔnman -siga minnun 'lee \"lala minnun 'lee -kɔlɛ minnun nɛn minnun o nyaan 'o 'pɛ -a 'lee 'o 'wulo -ji wɩnun da bɛ -a man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ɛn tʋ nɛn te min 'ka Bali tɔa dɩɛ, Bali 'ka -a paa bɛ man dɩ, 'pian 'bɛ nɛn 'gʋɛ, e 'lɛglɔn pɛɛnɔn 'ji 'nɔn laabʋ 'nan 'o 'si 'o drɛ wɩ -wlidɩ \"man -e 'o 'fli 'nɔn 'yrɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kɔɔ Bali yi -tʋ 'pla 'nan -e 'e 'trɛda 'nɔn pɛɛnɔn 'le 'wɩ tin 'ba 'e 'nɔan da. Bali min -tʋ 'si \"va, yaa -tɔ 'wɩ zɩɛ -a -ji tin 'bazan 'a, ɛn yaa -ci kɔɔn -wlɛ -a wluandɩ -a -kanɔn 'va.» ");
INSERT INTO yreNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Zɩ o -kanɔn wluandɩ da wɩ 'man bɛ, ɛn o plɔɛnnun -a sɛɛ wʋdɩ 'sia, ɛn o -mienun \"o 'vɩ 'nan: «Yi pee nyan, -e 'kʋi wei man \"nyian.» ");
INSERT INTO yreNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","-A -nan nɛn Pɔl 'bɔla o yei. ");
INSERT INTO yreNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","'Pian min -mienun -fɔ -a -sru, ɛn o yi -tɛra Zozi da. Dioni 'bɔ nɛn tin 'bazan 'tʋ -a bɛ e ya o va, 'lee lɩmɔn -tʋ nɛn waa laabo Damari bɛ, 'lee min -mienun \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","\"Bɛ -sru ɛn Pɔl 'si Atɛn 'fla, e -kʋ Korɛnti. ");
INSERT INTO yreNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","E Zuif min -tʋ nɛn waa laabo Akila bɛ -a 'yɩ 'nan nun. Waa -ya Pɔnt 'lɛglɔn 'ji. 'O 'vale 'e nan Priskil -a, o \"sia 'sinan Itali 'lɛglɔn 'ji 'e -trɛ. Kɔɔ mingɔnnɛnnun tazan Klodu nɛn Rɔm bɛ, e 'nan, Zuif 'nɔn pɛɛnɔn 'o 'si Rɔm 'lɛglɔn 'ji. Ɛn Pɔl -kʋ Akila 'lee Priskil -va. ");
INSERT INTO yreNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","O 'pa nyranman a -tʋwli \"le \"wɛan Pɔl -fʋ o va, ɛn o 'nyranman 'pa 'e cin va. -Wee 'nyranman nɛn 'nan 'o -tandannun drɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","'Flinla \"yi -tʋdʋ pɛɛnɔn da bɛ, te Pɔl 'wɩ \"paaman Zuif 'nɔn 'le cin yɩ 'kuin, yaa -wɛɛman 'nan Zuif 'nɔn 'lee Grɛk 'nɔn 'o -sɔɔnla 'e -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","'Pian zɩ Sila 'lee Timote 'si Masedɔa 'lɛglɔn 'ji o -ta bɛ, ɛn Pɔl Bali -le 'wɩ 'nɔnnɔn 'saza \"paadɩ \"sia. Yaa ve Zuif 'nɔn lɛ 'nan, Zozi 'bɛ cɩ min 'sizan 'wɩ 'ji -a. ");
INSERT INTO yreNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Zuif 'nɔn 'ka 'o \"trɔɛn \"tɔlɛ -a wei lɛ dɩ. Ɛn zɩ waa wei fuimlan 'nan te waa \"srɔnman bɛ, ɛn Pɔl 'yee sɔ ci plu -a -ci -kɔɔndɩ -a 'nan, 'e 'pɛ 'si -wee 'wɩ 'ji. E 'nan -wlɛ 'nan: «'Wɩ nɛn e -taa \"bɔlɛ 'ka man bɛ 'ka 'bɔ 'lɔ wɩ nɛn. Te 'ka 'an 'tɔ vɩ dɩ. 'Bɛ nɛn 'siɛn 'gʋɛ minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ, o va nɛn an -ko.» ");
INSERT INTO yreNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pɔl 'bɔla cin yɩ 'kuin, ɛn e -kʋ min -tʋ nɛn e 'yra -tɛa Bali man bɛ -yee 'kuin. Min zɩɛ waa laabo Titu Zuti -yee 'kɔn a Zuif 'nɔn 'le cin yɩ 'kɔn 'bɔ \"srɔn. ");
INSERT INTO yreNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","'Pian Cripu 'bɔ nɛn cin yɩ 'kɔn 'tazan -a bɛ, e yi -tɛra Minsan da 'o 'vale 'yee \"kɔnnɛn 'nɔn 'a. Ɛn Korɛnti 'nɔn \"kaga \"nɛn o cɩ Pɔl wei mannan bɛ, o yi -tɛra Minsan da \"nyian, ɛn o o -batize drɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","-A -nan nɛn Minsan 'wɩ tin 'ba Pɔl lɛ -pei -man \"le nyrinvla -zʋ. Yaa 'vɩ 'nan: «Te \"klan 'e 'kɔn 'i 'ji dɩ. 'I 'wɩ vɩ minnun lɛ, te 'i 'flin 'wɩdɩ -a dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","-Yɛɛ cɩ 'nan, an ya 'i \"srɔn, ɛn min -tʋ 'ka 'kɔlaman 'i 'kundɩ -a -e 'e 'wɩ 'wlidɩ \"drɛ 'yiɛ dɩ, kɔɔ 'mɛn minnun a \"kaga 'fla 'gʋɛ -a da.» ");
INSERT INTO yreNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔl -fʋ 'fla zɩɛ -a da lɛ -tʋ mlɛn 'shɛɛdʋ te e Bali -le 'wɩ \"paaman minnun ji. ");
INSERT INTO yreNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tʋ nɛn Rɔm 'nɔn 'le -kɔnmandan Galiɔn -tɔ Akai 'lɛglɔn da bɛ, ɛn Zuif 'nɔn 'o 'ci 'pa Pɔl man, waa 'kun, ɛn o -kʋ -a -a cɛin -da. ");
INSERT INTO yreNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Waa 'vɩ -kɔnmandan zɩɛ -yrɛ 'nan: «-Vɛ -mie 'gʋɛ, e 'wɩ \"paaman minnun ji 'nan, minnun 'o Bali 'tɔ bɔ 'e 'pee, -pei -tɔ wɩnun man.» ");
INSERT INTO yreNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔl \"ta 'wɩ \"sia \"va, 'nun tɔɔn ɛn Galiɔn \"e Zuif 'nɔn lɛ 'nan: «\"Te min 'gʋɛ, 'wɩ 'wlidɩ -dan tʋ nɛn yaa drɛ bɛ, \"te maan 'sinan \"va 'yɩ 'ka Zuif 'nɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","'Pian ɛn ka ya 'wɩ 'blɩnan 'wɩ \"paadɩ 'lee 'wɩ \"paanɔn da bɛ, 'lee 'ka 'bɔ 'le -pei -tɔ wɩnun da bɛ, 'ka 'bɔ 'lɔ wɩ 'bɛ. Ma'an 'we \"man -e 'an drɛ 'bɛ tin 'bazan 'a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ɛn Galiɔn \"e 'nan -wlɛ 'nan, 'o bɔla tin 'ba 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","-A -nan nɛn minnun pɛɛnɔn Sostɛn nɛn cin yɩ 'kɔn 'tazan -a bɛ -a 'kun, ɛn waa -sɔndɩ 'sia tin 'ba 'kɔn 'bɔ 'lɛ \"nɛn. 'Pian Galiɔn 'ka 'wɩ 'tʋ 'silɛ \"da \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Zɩ 'wɩ zɩɛ e drɛ bɛ, Pɔl tʋ \"kaga drɛ Korɛnti, ɛn e 'si \"bʋɩ Zozinɔn nɛn -nan nun bɛ o va 'o 'vale Priskil 'lee Akila -a, o -kʋ Cɛncre 'nan -e 'o 'fɔ -klʋ -dan nɛn e -ko Siri bɛ -a -ji. Pɔl -tɔ 'e wei -da Bali lɛ, -yee \"wɛan 'e 'wulo \"jɛ 'bʋ \"klɔglɔ 'vaa ɛn e 'si Cɛncre. ");
INSERT INTO yreNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","O 'bɔla Efɛz, ɛn Akila 'lee Priskil -fʋ 'fla zɩɛ -a da, ɛn Pɔl -kʋ cin yɩ 'kuin, e 'wɩ tin 'ba Zuif 'nɔn lɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","-A -nan nɛn Zuif 'nɔn \"e -yrɛ 'nan 'e yi -mie drɛ 'o 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","'Pian Pɔl 'ka 'wɩlɛ \"man \"dɩ, ɛn e -si trʋ 'ba -wlɔ. E -wlɛ 'nan: «-Te Bali wɩɩ \"man \"bɛ, an -taa \"nyian 'ka 'va 'gʋ.» Pɔl 'si Efɛz, ɛn e -fɔ -klʋ -dan nɛn e -ko Sezare bɛ -a -ji. ");
INSERT INTO yreNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Zɩ e 'bɔla Sezare bɛ, ɛn e -kʋ 'e cɛin -ji Zeruzalɛm Zozinɔn 'tɔ bʋlɛ. \"Bɛ -sru ɛn e Antiɔs si 'sia. ");
INSERT INTO yreNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pɔl 'mɔn \"wɛnnɔn Antiɔs, ɛn e -kʋ 'e 'lɛ. E ciɩla Galatɩ, \"bɛ -sru Pirigi te e -ko -a -nan Zozinɔn pɛɛnɔn \"koe \"tɔdɩ -a 'o da. ");
INSERT INTO yreNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Zuif min -tʋ nɛn waa laabo Apolo, ɛn waa -ya Alɛzandri bɛ, e 'bɔla Efɛz. Apolo zɩɛ, e \"we 'wɩ 'tɔ wei -ji, ɛn e Bali -le 'fluba 'wlɛ \"kaga -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Zɩ kɔ min 'e 'ta wʋla Minsan -sru \"bɛ, -nyrɛn waa paa \"ji. Apolo 'e 'fli -nɔn Bali -le 'nyranman 'padɩ -ji, ɛn e Zozi 'le 'wɩ 'nɔnnɔn ve minnun lɛ \"le zɩ Zozi -a 'vɩ bɛ -yee 'wɩ 'zʋ 'sɛzɛ, 'pian 'wɩ nɛn Zan min -batize drɛ \"man \"bɛ -nyrɛn yaa -tɔa \"cɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolo yi -tɛra 'e 'fli da, ɛn e Bali -le 'wɩ vɩdɩ 'sia Zuif 'nɔn 'le cin yɩ 'kuin. Zɩ Priskil 'lee Akila -a wei 'man bɛ, ɛn waa laabʋ 'o 'va, ɛn zɩ kɔ min 'e 'ta wʋla Bali -sru \"bɛ, waa paa \"ji 'kpa tɩglɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Zɩ Apolo a \"vale 'e 'ko Akai 'lɛglɔn 'ji bɛ, ɛn Zozinɔn -a \"koe \"tɔ 'e da -kʋdɩ -a. -A -nan nɛn o 'fluba 'crɛn -tɛ, waa -nɔn -yrɛ. Waa crɛn -tɛ -ji 'nan, Zozinɔn nɛn -nan nun bɛ 'o Apolo 'sia tɩglɩ. Zɩ e 'bɔla Korɛnti bɛ, minnun nɛn Bali -le \"yi \"le \"wɛan o yi -tɛra Zozi da bɛ, e 'pa o va -dan. ");
INSERT INTO yreNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","-Yɛɛ cɩ 'nan 'wɩ nɛn Zuif 'nɔn -a dra te e 'ka \"yi \"dɩɛ, yaa -tɛala o yra minnun yiɛ man 'e klɔ ji. 'Wɩ zɩɛ yaa -ci kɔɔn -wlɛ Bali wei nɛn 'e 'crɛn -tɛdɩ bɛ -a 'nan Zozi 'bɛ cɩ min 'sizan 'wɩ 'ji -a. ");
INSERT INTO yreNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Te Apolo a Korɛnti, ɛn Pɔl ciɩla Azi pɔnnun yei 'zia, -a -nan nɛn e 'bɔla Efɛz. 'O 'vale Zozinɔn -mienun -a 'o cin 'yɩ, ");
INSERT INTO yreNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ɛn yaa laabʋ -wlɔ 'nan: «Zɩ ka yi -tɛra Zozi da bɛ, ka Bali lei 'saun 'yɩ?» Ɛn o 'nan -yrɛ 'nan: «Kʋ'a 'bɔ manlɛ 'nan Bali lei 'saun a dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ɛn Pɔl -a laabʋ -wlɔ 'nan: «O 'ka -batize drɛ 'wɩ \"cɛn \"man?» O 'nan -yrɛ 'nan: «O 'kʋ -batize drɛ \"le zɩ Zan -a 'vɩ bɛ -yee 'wɩ 'zʋ.» ");
INSERT INTO yreNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","-A -nan nɛn Pɔl \"e 'nan: «Zan minnun nɛn o 'si 'o drɛ wɩ -wlidɩ \"man, ɛn 'o 'fli -nɔn Bali lɛ bɛ o -batize drɛ. Zan 'bɔ -a 'vɩ minnun lɛ 'nan, min nɛn e -taa \"talɛ 'an -sru \"bɛ, 'ka yi -tɛra -a san da. -Yɛɛ cɩ Zozi 'a.» ");
INSERT INTO yreNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Zɩ o 'wɩ zɩɛ -a 'man bɛ, ɛn o o -batize drɛ Minsan Zozi 'tɔ da. ");
INSERT INTO yreNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔl 'e 'pɛ 'pla o da ɛn Bali lei 'saun 'ta o da. -A -nan nɛn o 'wɩdɩ 'sia wei peenun -ji, ɛn o Bali 'lewei vɩdɩ 'sia. ");
INSERT INTO yreNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Minnun zɩɛ o pɛɛnɔn \"nɛn bɔa -fuda \"fli. ");
INSERT INTO yreNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ɛn Pɔl wla Zuif 'nɔn 'le cin yɩ 'kuin. E yi -tɛala 'e 'fli da, ɛn -a mlɛn yaaga 'bɔ te e 'wɩ \"paaman minnun ji. Bali -le mingɔnnɛn -blɩdɩ -le 'wɩ nɛn yaa ve minnun lɛ, te yaa -wɛɛman 'nan minnun 'o man \"yi, -e 'o -sɔɔnla Bali -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","'Pian zɩ min -mienun 'ka 'wɩ zɩɛ -a siala 'wɩ 'a dɩ, ɛn wa'a 'we \"man -e 'o yi -tɛra \"da \"dɩɛ, te o \"we 'wɩ \"paadɩ zɩɛ -a man -wlidɩ min pɛɛnɔn yiɛ man bɛ, -a -nan nɛn Pɔl 'si o va. Yi -tʋdʋ pɛɛnɔn man e 'wɩ \"paaman 'siɛn Zozinɔn 'ji, min -tʋ nɛn waa laabo Tirani bɛ -yee -lugɔlu 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pɔl -a drɛ zɩɛ -trilii lɛ 'fiili, ɛn minnun pɛɛnɔn nɛn o -nyɛanla Azi 'lɛglɔn 'ji, te o ya Zuif 'nɔn 'a oo, te o 'ka Zuif 'nɔn 'a dɩ oo, o Minsan 'le 'wɩ 'nɔnnɔn 'man. ");
INSERT INTO yreNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bali -ciala Pɔl -va te Pɔl 'lɛbo \"fɔ wɩ -dandan dra. ");
INSERT INTO yreNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","-Yee \"wɛan sɔnun 'lee sɔ plɩnun nɛn o klɛ Pɔl 'kɔlɛ man bɛ, waa \"sia te waa \"paaman man \"yaa 'nɔn man te e -cɛ \"sia o man te e -yʋ -wlidɩ \"sia o -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ɛn Zuif 'nɔn -mienun nɛn o -cia \"wʋdɩ -a 'fla 'tʋdʋ pɛɛnɔn da bɛ, o -yʋ -wlidɩ -pian \"minnun -sru Minsan Zozi 'tɔ da. Waa ve -yʋ -wlidɩnun lɛ 'nan: «Zozi nɛn Pɔl -yee 'wɩ ve bɛ, -a 'tɔ da maan vɩ 'cɛɛ 'nan, 'ka 'si min 'gʋɛ -a -sru.» ");
INSERT INTO yreNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Minnun nɛn o 'wɩ zɩɛ -a dra bɛ, min -tʋ nɛn waa laabo Seva bɛ -yee 'nɛnnun nɛn waa, o ya 'sɔravli. Seva zɩɛ, Zuif min nɛn, ɛn e ya Bali -pannɔn 'tazan -tʋ -a. ");
INSERT INTO yreNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ɛn -yʋ -wlidɩ -a 'vɩ -wlɛ 'nan: «An Zozi -tɔa. Ɛn min nɛn 'bɛ cɩ Pɔl -a bɛ mɛɛn -tɔa. -Tɩ nun nɛn \"cee \"a?» ");
INSERT INTO yreNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","-A -nan nɛn min nɛn -yʋ -wlidɩ \"cɩ -a -sru \"bɛ, e 'wʋ o da, -a -pɛ 'bɔ o pɛɛnɔn man -le \"wɛan o 'bɔla 'kɔn zɩɛ -a -ji flan -a 'o plʋdɩ te nyɛn a o da. ");
INSERT INTO yreNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","'Wɩ zɩɛ, Zuif 'nɔn pɛɛnɔn 'lee Grɛk 'nɔn pɛɛnɔn nɛn Efɛz bɛ waa 'man, ɛn o klan Bali lɔ. -A -nan nɛn e drɛ Minsan Zozi 'tɔ bɔ wɩ -a. ");
INSERT INTO yreNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Minnun nɛn o yi -tɛra Zozi da bɛ, o \"kaga \"ta 'wee 'wɩ 'wlidɩ \"vɩlɛ minnun yiɛ man 'wein. ");
INSERT INTO yreNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ɛn minnun nɛn o 'bui -fɔa \"bɛ, o \"kaga \"ta 'wee 'bui 'flubanun -a, 'lee 'wee fɛnun -a, ɛn waa 'tɛ 'blɩ minnun yiɛ man. 'Flubanun zɩɛ, -te waa man \"lala nrɔn bɛ, e bɔa yi -kpi fuba 'soolu da nyranman \"lala -a (50.000). ");
INSERT INTO yreNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Bali -le 'plɛblɛ 'le \"wɛan zɩ Minsan -le 'wɩ 'nɔnnɔn fuila \"man zɩɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Zɩ 'wɩ zɩɛ e drɛ bɛ, \"bɛ -sru ɛn Pɔl \"e 'nan, 'e \"ta -ko Zeruzalɛm. 'Pian e 'nan, 'e 'ko Masedɔa 'lee Akai 'vaa -e 'e 'kʋ. E 'nan, -te 'e 'kʋ bɛ, 'e bɔala Rɔm. ");
INSERT INTO yreNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","-A -nan nɛn e Timote 'lee Eras nɛn o \"paa \"va \"bɛ o 'pa 'sia Masedɔa, ɛn -a 'bɔ \"e fʋʋ tʋ \"wɛnnɛn 'a Azi 'lɛglɔn 'ji. ");
INSERT INTO yreNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tʋ zɩɛ -a man nɛn -tein -tria Minsan -le 'wɩ 'nɔnnɔn da Efɛz 'fla. ");
INSERT INTO yreNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Min -tʋ nɛn waa laabo Demetri bɛ, e ya fɛ zɩɛ -a -nan. E -siga man nyranman \"paa, ɛn e -siga 'kɔn \"wɛnwɛnnɛn nun dra -wee Bali -tʋ nɛn waa laabo Artemi bɛ -yee vɛ -a. -Yee minnun nɛn waa dra waa bɛ, e \"lala \"kaga \"ye o da. ");
INSERT INTO yreNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Minnun nɛn o 'nyranman -tʋwli 'bɔ zɩɛ -a \"paa bɛ e 'o cin 'yɩ, ɛn e -wlɛ 'nan: «'Ka pɛɛnɔn kaa -tɔa 'nan, -cee 'nyranman 'gʋɛ -yɛɛ -maan, ɛn -kaa cɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ɛn kaa 'man 'nan, Pɔl a -a vɩnan minnun lɛ 'nan balinun nɛn min o drɛ 'o 'pɛ -a bɛ, o 'ka bali tɩglɩ 'a dɩ. 'Wɩ zɩɛ, ya'a vɩlɛ Efɛz 'saza \"cɛ \"dɩ, 'pian yaa 'vɩ Azi 'lɛglɔn pɛɛnɔn 'ji. Ɛn zɩ yaa 'vɩ bɛ, min \"kaga \"yi -tɛra \"da, ɛn o 'si -cee bali Artemi -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","'Wɩ zɩɛ e -taa -cee 'nyranman klu -sɛnlɛa ji, ɛn -cee bali Artemi bɛ, -yee 'kɔn klu -taa \"sɛnlɛa ji, ɛn \"yɛɛ 'le 'sran bɛ, Artemi 'bɔ 'tɔ 'ka \"nyian taa -kɔnlɛ min 'le dɩ. Te Artemi 'bɔ nɛn minnun pɛɛnɔn -a ye \"yi Azi 'lɛglɔn 'ji 'lee 'trɛ pɛɛnɔn da.» ");
INSERT INTO yreNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Zɩ minnun 'wɩ zɩɛ -a 'man bɛ, 'bli 'fɔ 'o 'ji, ɛn o -paandɩ 'sia te waa ve 'nan: «Efɛz 'nɔn 'le bali Artemi a -dan.» ");
INSERT INTO yreNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","'Wɩ zɩɛ e 'fla nyɔɔn, ɛn 'flanɔn 'ci drɛ 'tʋ. -A -nan nɛn o Gai 'lee Ariza 'kun 'sa -a, ɛn o -kʋ waa fɛnan nɛn 'flanɔn 'o cin ye bɛ -a -nan. Gai 'lee Ariza zɩɛ Masedɔa 'nɔn nɛn waa, -wɛɛ Bali -le 'nyranman 'pa 'o 'vale Pɔl nun -a 'e cin va. ");
INSERT INTO yreNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Zɩ Pɔl a \"vale 'e bɔala 'ji minnun zɩɛ o 'lɛ bɛ, Zozinɔn 'ka 'wɩlɛ \"man \"dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ɛn Pɔl bee -mienun nɛn o 'fla \"paala bɛ o min 'pa 'sia -yrɛ 'nan, te 'e bɔla 'ji minnun 'lɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tʋ zɩɛ -a wlu bɛ, te minnun nɛn 'o cin 'yɩ bɛ, wa'a tian 'o cin wei -ci manlɛ dɩ. Min -mienun -paanman, \"o 'wɩ 'pee ve -e min -mienun \"o -paan \"wʋ 'wɩ 'pee -a. Ɛn min \"kaga \"a o yei, te 'wɩ 'bɔ nɛn 'o cin 'yɩ \"man \"bɛ, wa'a tian \"o -ci manlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Min -tʋ nɛn waa laabo Alɛzandre bɛ, Zuif 'nɔn a 'ta 'tɔnan \"man, 'nan -e 'e bɔla 'ji minnun 'lɛ, ɛn min -mienun 'wɩ zɩɛ -a -ci 'vɩ -yrɛ. -A -nan nɛn 'e 'pɛ wluan minnun lɛ 'nan, 'o sɔɔ 'pla, -e 'e 'wɩ tin 'ba -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","'Pian zɩ minnun -a -tɔ 'nan Zuif min nɛn bɛ, ɛn o pɛɛnɔn -paandɩ 'sia 'e cin va 'wɩ -tʋwli \"vɩdɩ -a 'nan: «Efɛz 'nɔn 'le bali Artemi a -dan.» O 'mɔn -paandɩ zɩɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","E drɛ zɩɛ fɔɔnɔn, ɛn min nɛn e -tɔa 'flanɔn 'lee 'fla 'tanɔn yei \"bɛ, 'e -kɔla 'e 'pɛ -tɔdɩ -a o da, ɛn e 'nan -wlɛ 'nan: «Efɛz 'nɔn, min pɛɛnɔn -a -tɔa 'nan Efɛz 'bɛ yiɛ -tɔa -cee bali Artemi -le 'kɔn 'va. Ɛn Artemi 'bɔ -a yiba \"min nɛn e 'si laji e -tria bɛ -cɛɛ yiɛ -tɔa \"va. ");
INSERT INTO yreNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Min -tʋ 'ka 'kɔlaman -e 'e -sa -fɔ dɩ. -Yee \"wɛan 'ka 'lɛbo 'pla \"da -e 'ka 'wulo -ji \"nrɔn 'vaa, -e 'ka 'ta wɩ drɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","-Yɛɛ cɩ 'nan, minnun nɛn ka -ta waa 'gʋɛ, wa'a -cee bali -le fɛ -tʋ crin wʋlɛ dɩ, ɛn waa -cee bali \"srɔnlɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","-Yee \"wɛan -te Demetri 'lee 'yee 'nyranman 'panɔn a \"vale o 'wɩ -tɔa \"min man bɛ, yinun nɛn o tin 'ba \"da \"bɛ o ya, ɛn minnun nɛn o tin 'ba o va bɛ o ya. O va nɛn 'o 'kʋ o -sanman drɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ɛn -te 'wɩ 'pee a \"nyian 'ka 'ji -e 'ka vɩ bɛ, yi nɛn minnun 'o cin ye -e 'o 'wɩ tin 'ba bɛ -e 'ka 'wɩ 'bɔ zɩɛ -a bɔla -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","'Wɩ nɛn e drɛ cɛɛgʋɛ -yee \"wɛan bɛ, o -kɔlaman -e 'o 'wɩ 'tɔ -kaa man 'nan, -kaa wluan minnun man. -Cee cin yɩdɩ 'gʋɛ -a -ci \"ka \"dɩ, ɛn -ka'a 'kɔlaman -e -kaa -ci tɩglɩ yɩ -e -kaa vɩ minnun lɛ dɩ.» ");
INSERT INTO yreNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Zɩ e cɛɛn 'wɩ zɩɛ -a vɩdɩ man bɛ, ɛn e 'nan minnun lɛ 'nan, 'o 'kʋ 'wee vɛ -nan. ");
INSERT INTO yreNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Zɩ 'wɩ nɛn e 'fla nyɔɔn bɛ e -ta \"tra \"bɛ, ɛn Pɔl Zozinɔn cin 'yɩ, e o \"koe \"tɔ 'o da, ɛn e -wlɛ 'nan, 'e \"ta -ko Masedɔa. ");
INSERT INTO yreNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pɔl 'bɔla Masedɔa, ɛn e Zozinɔn \"koe \"tɔ 'o da wei \"kaga \"a. \"Bɛ -sru, ɛn e -kʋ Grɛk. ");
INSERT INTO yreNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","E mlɛn drɛ 'nan nun yaaga. Te Pɔl 'e 'man wʋʋ 'nan -e 'e -klʋ -dan nɛn e \"ta -ko Siri bɛ -a 'sia bɛ, ɛn yaa 'man 'nan, Zuif 'nɔn 'o 'ci 'pa 'e man, -a -nan nɛn e 'nan, 'e lia 'e da -e 'e ciɩla Masedɔa \"nyian. ");
INSERT INTO yreNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Min 'sɔravli \"nɛn o -kʋ Pɔl 'palɛ bɛ, o 'tɔ nɛn 'gʋ: Min -tʋ 'si Bere 'fla, Pirus -pɩ Sopatɛr nɛn. Min \"fli 'si Tesalonik 'fla, Ariza 'lee Sekundus 'bɛ 'waa. Min -tʋ 'si Dɛrbʋ 'fla, Gai 'bɛ. Min yaaga 'si Azi 'lɛglɔn 'ji, Timote 'lee Tisik 'lee Trofi 'bɛ 'waa. ");
INSERT INTO yreNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","O zɩɛ o -trɔa 'kʋ 'lɛ, ɛn o -kʋ 'kʋ 'pɛnlɛ Troas. ");
INSERT INTO yreNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","'Kʋe vɛ bɛ, \"kʋ \"fɔ 'wʋ -klʋ -dan ji Filipʋ 'fla, te \"fɛdi nɛn o 'kpɔun nɛn 'mannyan 'ka \"va \"dɩɛ -a -ble \"da \"bɛ e -nyan. Yi 'soolu \"bɛ -sru, ɛn kʋ 'bɔ o man Troas, kʋ yi drɛ Troas 'sɔravli. ");
INSERT INTO yreNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","'Mɔnnɛn yi -tʋ da, 'kʋ cin 'yɩ 'nan -e fɛ nɛn Minsan \"e 'nan 'kʋ -blɩ 'e cin va bɛ 'kʋ -blɩ. -A -nan nɛn Pɔl 'wɩ tin 'badɩ 'sia Zozinɔn lɛ, kɔɔ -te tʋ cɛɛn bɛ, e -ko -le \"wɛan. E 'wɩ tin 'ba -wlɛ \"trilii, ɛn bada -tɔ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kʋ ya 'kʋ cin yɩdɩ 'kɔn \"bʋ \"nɛn 'kɔn 'ta lou \"bɛ -a -ji. 'Kɔn \"bʋ zɩɛ -a -ji bɛ, -kannɛn \"kaga \"a 'e 'fɔdɩ \"nɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","-Gobo 'nɛn 'tʋ nɛn waa laabo Etiko bɛ, e ya 'e -nyrandɩ -fenɛdi 'plo da. Pɔl a 'wɩ tin 'banan \"kaga, ɛn yi 'nɛn zɩɛ -a -tɛdɩ 'sia. Yi -wlamlan \"bʋʋ \"le \"wɛan e 'si -fenɛdi da 'kɔn 'ta lou 'kɔn yaagazan 'win -ji, ɛn e -ta -tilɛa \"tra. Minnun -ta, ɛn waa wluan lou, 'pian te e -ka 'va. ");
INSERT INTO yreNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔl sɔɔnla e 'kunnan 'nɛn zɩɛ -a da, ɛn yaa 'si 'e 'pɛ -ji, e 'nan: «Te nyɛn 'e 'ka 'cɛndɩ, e beli 'va.» ");
INSERT INTO yreNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","\"Bɛ -sru, ɛn Pɔl -kʋ 'e \"pa 'ji 'kɔn 'ta lou. E 'kpɔun \"nɛn jɛɛn, waa blɩ 'e cin va, ɛn e 'wɩ tin 'ba 'trilii tʋ cɛɛn \"man, -a -nan nɛn e -kʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","O -kʋ -gobo 'nɛn zɩɛ -a 'yee \"kɔnnɛn te e ya 'e 'belidɩ, -a -nan nɛn e drɛ ci \"nran -dan tʋ -a. ");
INSERT INTO yreNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kʋɛ -trɔa 'e tɛdɛ Pɔl lɛ -klʋ -dan ji, ɛn kʋ -kʋ 'fla nɛn waa laabo Azo bɛ -a da. 'Fla zɩɛ -a da nɛn kʋ Pɔl -fɔa 'kʋ 'va, -yɛɛ cɩ 'nan Pɔl \"e 'nan 'e -ciala 'e 'cɛin -ji zia. ");
INSERT INTO yreNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pɔl 'bɔ 'kʋ man Azo, ɛn e -fɔ 'kʋ 'va -klʋ -dan ji, -a -nan nɛn kʋ -kʋ 'fla nɛn waa laabo Mitilɛn bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kʋ 'si 'bɛ 'nan, ɛn kʋ -kʋla \"nyian -klʋ -dan ji. 'Bɛ 'ta tʋ cɛɛn, kʋ 'bɔla 'yi yei 'trɛ 'tʋ nɛn waa laabo Kio bɛ -a \"srɔn. \"Bɛ -sru \"yi -a, ɛn kʋ 'bɔla 'yi yei 'trɛ nɛn waa laabo Samos bɛ -a da. 'Bɛ 'ta tʋ cɛɛn \"nyian, ɛn kʋ 'bɔla 'fla nɛn waa laabo Mile bɛ -a da. ");
INSERT INTO yreNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","-Yɛɛ cɩ 'nan Pɔl 'ka \"vale 'e -tɔa Efɛz dɩ, kɔɔ e 'ka \"vale 'e \"mɔan Azi 'lɛglɔn 'ji dɩ, ɛn yaa -wɛɛ \"man 'nan 'e bɔala Zeruzalɛm Pantekɔt \"fɛdi yi da. ");
INSERT INTO yreNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","'Pian zɩ Pɔl 'bɔla Mile bɛ, ɛn e min 'pa 'sia 'nan 'o 'kʋ Efɛz -leglizi min cejenun laabʋ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Zɩ min cejenun zɩɛ o -ta bɛ, ɛn e 'nan -wlɛ 'nan: «Te an 'bɔla 'e tɛdɛ 'ka 'va, 'nyranman nɛn maan 'pa Azi 'lɛglɔn 'ji -trilii -e 'e 'bɔ cɛɛgʋɛ, kaa -tɔa. ");
INSERT INTO yreNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ma'an 'fli drɛlɛ -dandan Minsan -le 'nyranman 'panan dɩ. An yra 'yɩ Zuif 'nɔn 'lɔ, ɛn an 'nyranman 'pa 'an 'ta le 'an yiɛ 'yi 'a. -Yɛɛ cɩ 'nan Zuif 'nɔn a \"vale 'o 'wɩ 'wlidɩ \"dra 'mɛn. ");
INSERT INTO yreNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ma'an 'wɩ 'tʋ yɔɔlɛ 'ka man dɩ, an Bali -le 'wɩ 'vɩ cɛɛ, ɛn an -yee 'wɩ nɛn e ka dra tɩglɩ bɛ -a paa 'ka 'ji min pɛɛnɔn yiɛ man 'kɔnnun -ji. ");
INSERT INTO yreNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Maan 'vɩ Zuif 'nɔn 'lee minnun nɛn o 'ka Zuif 'nɔn 'a dɩɛ -wlɛ, 'nan 'o 'si 'wɩ 'wlidɩ \"drɛdɩ man -e 'o -sɔɔnla Bali -sru -e 'o yi -tɛra -cee Minsan Zozi Crizi da. ");
INSERT INTO yreNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ɛn 'bɛ nɛn 'gʋɛ, an \"ta -ko Zeruzalɛm \"le zɩ Bali lei 'saun -a 'vɩ 'mɛn 'nan 'an drɛ bɛ -yee 'wɩ 'zʋ. 'Pian 'wɩ nɛn e bɔa 'an man -nan nun bɛ, ma'an tɔa dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Maan -tɔa 'pian 'nan 'fla 'tʋdʋ pɛɛnɔn da bɛ, Bali lei 'saun -a ve 'mɛn 'nan minnun 'tɛ \"paa 'an da -e 'waan 'fɔ -pʋ 'kuin. ");
INSERT INTO yreNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","'Pian 'mɛn vɛ bɛ, 'mɛn 'belidɩ -cin 'ka 'an 'ji \"le 'nyranman nɛn Minsan Zozi -a -nɔn 'mɛn 'nan 'an 'pa bɛ -yee 'wɩ 'zʋ dɩ. 'Wɩ nɛn Minsan \"e 'nan 'mɛn 'an drɛ bɛ, -nyrɛn 'nan, 'an Bali -le 'wɩ 'nɔnnɔn vɩ minnun lɛ 'nan Bali \"yi drɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","An ciɩ 'ka pɛɛnɔn 'va te an Bali -le mingɔnnɛn -blɩdɩ 'wɩ ve 'cɛɛ. 'Pian 'bɛ nɛn 'gʋɛ, maan -tɔa 'nan 'ka 'va min -tʋ 'ka \"nyian 'an ye dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","-Yee \"wɛan maan ve 'cɛɛ cɛɛgʋ 'nan: Zɩ kɔ \"an \"drɛ bɛ, maan drɛ 'ka pɛɛnɔn lɛ. -Te 'li 'pei ka'a yi -tɛlɛa 'mɛn 'wɩ \"paadɩ da dɩɛ, mɛɛn \"cɛɛ drɛ dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","-Yɛɛ cɩ 'nan 'wɩ nɛn Bali -a drɛ 'nan -e min 'e pli 'e man bɛ, maan 'vɩ 'cɛɛ 'e pɛɛnɔn. Ma'an 'wɩ 'tʋ yɔɔlɛ 'ka man dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","-Yee \"wɛan 'ka drɛ \"yi 'ka 'fli -va 'lee minnun nɛn Bali lei 'saun o -nɔn 'cɛɛ 'nan 'ka yiɛ 'tɔ o va bɛ o va. 'Ka yiɛ 'tɔ Bali -le -leglizi bɛ -a va, Minsan Bali -a 'lɔ 'e 'pɩ nyɛn -a. ");
INSERT INTO yreNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Maan -tɔa 'nan, -te an -kʋ bɛ, minnun nɛn o ya \"le plɔ wi -zʋ bɛ, o -taa -wlalɛa 'ka yei, -e 'o 'wɩ 'wlidɩ \"drɛ minnun nɛn 'ka yiɛ -tɔa \"o va bɛ -wlɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ɛn \"nyian 'ka yei min -mienun -taa 'wunlɛa, o 'wlu wɩnun ve Zozinɔn lɛ -e 'o 'sɛn o -sru. ");
INSERT INTO yreNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","-Yee \"wɛan 'ka yiɛ 'tɔ 'ka 'fli -va, ɛn -a -cin 'e 'fɔla 'ka 'ji 'nan lɛ yaaga 'wlu bodrun funnin te an 'wɩ \"paala 'cɛɛ 'an 'ta le 'an yiɛ 'yi 'a. ");
INSERT INTO yreNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ɛn 'bɛ 'gʋɛ, an \"ta \"mɛn 'ka -pɛba wo Bali 'lee Bali -le 'wɩ nɛn e \"yi \"dra min lɛ bɛ -wlɔ. -Yee 'wɩ zɩɛ, 'plɛblɛ a -yrɔ -e 'e 'ka \"koe \"tɔ 'ka da, \"bɛ -sru -e 'e \"yi \"nɛn yaa 'pla 'nan e dra minnun nɛn o cɩ -yee vɛ -a bɛ -wlɛ \"bɛ, 'e drɛ 'cɛɛ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ɛn ma'an -wɛɛlɛ 'nan min e 'yee \"lala 'lee 'yee -siga 'lee 'yee sɔnun -nɔn 'mɛn dɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kaa -tɔa 'ka 'bɔ 'a 'nan an 'nyranman 'pa 'an 'pɛ -a, ɛn maan \"nɛn \"fɛ blɩ, ɛn minnun nɛn o -kʋ 'an 'palɛ bɛ, ɛn waa \"nɛn \"fɛ blɩ. ");
INSERT INTO yreNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Zɩ kɔ min e 'nyranman 'pa -e '