﻿USE sofia;
DROP TABLE IF EXISTS sofia.yrb_vpl;
CREATE TABLE yrb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yrb_vpl WRITE;
INSERT INTO yrb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ewana Yesu Kerisonu sirorari sina. Dana Deiwidinu sisia amara. Dana Eibaramunu sisia amara. ");
INSERT INTO yrb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eibaramu dana Aisikinu damama. Aisiki dana Jeikofunu damama. Jeikofu dana Judaini danu dabuemutu emanu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda dana Feresini Sira emanu damama. Emanu danuana Teima. Feresi dana Esaromunu damama. Esaromu dana Remunu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Remu dana Aminadabunu damama. Aminadabu dana Neisoninu damama. Neisoni dana Samoninu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Samoni dana Bouasinu damama. (Bouasinu danuana Reiabu.) Bouasi dana Oubedinu damama. (Oubedinu danuana Ruta.) Oubedi dana Jesinu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi dana Deiwidinu damama. Deiwidi dana dera kini amara. Deiwidi dana Soromoninu damama. (Soromoninu danuana Uraianu aweta.) ");
INSERT INTO yrb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromoni dana Reoboamunu damama. Reoboamu dana Abaijanu damama. Abaija dana Asanu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa dana Jiosefetinu damama. Jiosefeti dana Joremanu damama. Jorema dana Usaianu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia dana Jotemunu damama. Jotemu dana Eiasinu damama. Eiasi dana Esikaianu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esikaia dana Manasanu damama. Manasa dana Eimosinu damama. Eimosi dana Josaianu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia dana Jekonaiaini danu dabuemutu emanu damama. I kowaro Babaronia orofa uwarama i Ju uwara mutate Babaronia orofaro dibura odinono uta. ");
INSERT INTO yrb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","I uwarama Ju uwara Babaronia orofaro woure oitaro Jekonaiama Sirutio yanae muni. Sirutio dana Serubabeonu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabeo dana Abaudinu damama. Abaudi dana Iriekiminu damama. Iriekimi dana Asonu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso dana Sadokonu damama. Sadoko dana Eikiminu damama. Eikimi dana Iriudinu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Iriudi dana Iriesanu damama. Iriesa dana Meitaninu damama. Meitani dana Jeikofunu damama. ");
INSERT INTO yrb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jeikofu dana Jousefanu damama. Josefa dana Merinu awera. Merima Yesu muni. Yesunu mui ifuna Keriso waita. ");
INSERT INTO yrb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Enoba bodere Eibaramubairoma abuamutu arebe arebe arebe are Deiwidibai fotini (14) are me sini. Nono Deiwidibairoma abuamutu are Babaronia orofaro oita kowabai mui fotini (14) are me sini. Nono i Babaronia orofaro oita kowabairoma abuamutu arebe are Godi Danu ma wiroe mune aneta Amara Yesubai mui fotini(14) are me sini. ");
INSERT INTO yrb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","I Yesu Keriso Danu danuama Dawa muni sinana eno, Yesunu danua Merina bodere datu mata. Josefama mubie datu mataro aweta awera mune matanawa utawa me inarebe dia muni. Godinu Imumu Kotofuma Merinu neno ubarero itariro iba dia munite ibi. ");
INSERT INTO yrb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jousefa dana Meri ekodifie we imuirogo nono dana kobere amaraba dawa unutawa emema Meri we iruotoba iba Meri kiwuma ekodifie we imutebi. ");
INSERT INTO yrb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Eno imutebina Godinu aneru tuberoma farite wei, Deiwidinu amara Jousefa, Meriba iya da uyate dawa anu aweta mua wei. I diaro kuitana Godinu Imumu Kotofuma masinu amara wei. ");
INSERT INTO yrb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Merima i amara mubiro Danu ifu Yesu maibasuba Dana Danu uwaranu neno neno uetaroma ma wirofisu aneruma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Godinu we bou ueta amarama weiba enanari ui. ");
INSERT INTO yrb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Godinu we bou ueta amarama eno wei, nauawe, mui awera munawa aruma dia mubite amara mubisu. I amaranu ifuna Imanuera weboita. (I ifunu ubina Godima yabai ibinu), Godinu we bou ueta amarama eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","25","Jousefa nauta ainibebe ido uyarite Godinu anerunu wei sina enanari uite Meri danu aweta muni. Jousefama ido Meri muniro uruama ainawa me ibisiro Merima i Amara ido muniro Jousefama i Amara Danu ifu Yesu mami. ");
INSERT INTO yrb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Merima Yesu Judia orofa Betiremu suro muni. I kowarona dera yawoeta amara Erodima i orofa yawotebi. I muni kowaro moana muinanu ubi iwata derawere uwarama i kowa amueta orofa yafawereroma Jerusaremu suro are fatate weita, i Ju uwaranu reka muninu yawoeta amara aboro? Kowa amueta afu Danu muina esiba iba Dawa guriguri ufene farisia weita. ");
INSERT INTO yrb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Erodima emanu sina nauite neno siosa ui. I Jerusaremu su uwara nesia enanari uta. ");
INSERT INTO yrb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Erodima weiro i dera fuyo ode sina weta uwaraini tarawatu tisa uwaraini dawabai fata. Fataro wei, i we bou ueta uwarama Keriso aboro mubie weita wei? I kuita, Ju uwaranu kini, aboro muninu wei? ");
INSERT INTO yrb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","weiro weita, Judia orofa Betiremu suro. Godinu we bou ueta amarama eno owawa ue odi, a Judia orofa Betiremu su, ana su kikiratu nono ana i Judia yawoeta uwarabai ana derawere, abairoma mui dera yawoeta amara uyafite Godinu Isaraero uwara yawofisu, eno owawa ue odi weita. ");
INSERT INTO yrb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Erodima i iwata derawere uwaraba kiwuma weiro dawabai fata. Fataro wei, i muina abo kowaro fariro eta wei? ");
INSERT INTO yrb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Weite wei, Betiremu suro aniawete i kuita doberegou uawe wei. Kuita doberebe atafoitana nabai are wiawero ma dari Dawabai animate guriguri umau wei. ");
INSERT INTO yrb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","I uwarama Erodinu sina nautate ekoitate anita. Aneda etana i kowa amueta afu muina arite su foubai eda urero inaibiro eta. ");
INSERT INTO yrb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","I muina etate emanu nenoma yaru derawere uta. ");
INSERT INTO yrb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","I uwarama i su ubarero amutate etana kuitaini Danu danua etate jejerigari uteda Dawa guriguri uta. Eno utate emanu kobere me maeta ememetu ma ifegari utate Dawaba goruini bonanawere faudaini bonanawere ogoini mata. ");
INSERT INTO yrb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Godima i iwata derawere uwarabai tuberoma farite wei, yanu owereta kowaro Erodibai da anibote yanu mui dabaro yanu suro ane faforo weiro enanari uta. ");
INSERT INTO yrb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","I uwarama ane me sitaro Godinu aneruma Jousefabai tuberoma farite wei, uyate i kuitaini Danu danua muate Ijifi orofaro sau ania. Erodima i kuita dobere ma uifie utasuba iro ane ibiaro Nana wemaro nono owere ara wei. ");
INSERT INTO yrb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","I dumuro Jousefa uyarite i kuitaini Danu danua munite iroma woure Ijifi orofaro ani. ");
INSERT INTO yrb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ijifi orofaro ane ibifiro Erodi uifiro fafie iba ani. Godinu we bou ueta amarama wei iba enanari ui. Godima Danu we bou ueta amaranu bebeturoma eno wei, Nanu amara Ijifiroma ara wei, iba eno ui. ");
INSERT INTO yrb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","I iwata derawere uwarama Erodibai ane farawa utaro Erodima i uwara na iruita we imuteda ibo derawere ui. Ibo uite dawa i uwarabai iwata uiba moana uwara siaia uteda eno wei, aniawete Betiremu suini nono i gigirari su suro oya sadei me sinawa masiguraratu nesia ma uiawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Erodima eno uiro Godinu we bou ueta amara Jeremaianu bodere sina i kowaro enanari ui. ");
INSERT INTO yrb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Jeremaiama eno wei, mui wate tanana Reima subairoma farite i weda sorara ui. Reisorobairoma sirorari uta awetabo emanu koiniboroba i webita, nesia ibawa, uitaba iba i wedibebita, Jeremaiama eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Erodi ido uiro Godinu aneruma Ijifiro Jousefabai tuberoma farite wei, uyate i kuitaini Danu danua muate Isaraero orofaro ania. I kuita ma uifitae utebita uwarana uie me sinitaya ania wei. ");
INSERT INTO yrb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josefa ido uyarite i kuitaini Danu danua munite woure Isaraero orofaro ani. ");
INSERT INTO yrb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Ane farite Jousefa mui sina nauina Akiriasima danu damama Erodinu kabesi muninute Judia orofa yawotasu eno nauite iyarite iro ibawa i orofa ekodite ani. Nono Godinu aneruma tuberoma wei iba Gareri orofaro ani. Ane Nasareta suro ibi. Enoba Godinu we bou ueta uwaranu sina ido enanari ui. Emanu sina eno, Dawa Nasareta su amara webitaita eno weita. ");
INSERT INTO yrb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","I kowaro Joni babataito amarama Judia eme ibawa orofaro fariro eme faiyawere dawabai fataro wei, Godinu yawoe anasu kowa fafie utasuba yanu neno neno ueta dubena afu sawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Godinu we bou ueta amara Isaiyama i amaraba eno wei, dana eme ibawa orofaro sina we inareda wasu, i Dera Amaranu daba wabue moya uawe wasu, Isaiyama eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Joni danu baruetana kemo eginu ofe, danu kafana borumakaunu ofe, danu ieta sisidomuini firukaini itebi. ");
INSERT INTO yrb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","7","Jerusaremu su uwaraini Judia orofa uwaraini i Jodani orofa mamamama uwara nesia Jonibai fatate emanu neno neno ueta we ma borobayataro Jonima ema Jodani ogoro babataito utebi. Jonima erina i Ferosi uwaraini Sadusi uwaraini dawabai fataro erite emaba wei, ya tabainu muneta! Anama Godinu fafisu neno ka ueta yaba weiba iba serigari ufote iya aniboe nabai durami ue faraita wei? ");
INSERT INTO yrb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aniawete yanu ueta ba me dubena afu sawete kobere ueta iboro odiawe. Eno uawero Godima efi wei. ");
INSERT INTO yrb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Eno weite nono wei, me sara uyafote Eibaramu dawa yanu baba yana danu sisia uwara weboitana Godima Eibaramunu moana sisia uwara gebiroma ubu ufie imufisuna ubu ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Godinu koto fanisi kowa fafie utasu. Mui amarama kowa ramamasute ana umafie utebasu enanari Godinu koto kowa i ari, yanu siosa ueta sineta umafie utasu. Mui ana kobere tai da uwafiro umane tufite mune inaro sabisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ya yanu neno neno ueta dubena afu sanaitana ya ogoma babataito utatane. Nono mui amara nanu buribi afiro Danu buna derawere na ari me. Nana kobererau meba Danu ibo didi da inare tumau. I amarama ya Godinu Imumuini ina yaretama babataito uegou ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Dana Danu uiti tai waiya ueta saboro agero ibinuba Danu uiti tai koru kafae ma kobererau ufie saboroma uiti tai etu sabisu. Etu sabiro oyauma ifuru afuru aika kabesiro woure odifiro uiti tai kafaero itafisu. Itafiro Dana Danu ba uiti tai su koruro odifite i ifuru afuru i uitawa inaro sabisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jonima Yesu babataito ufie iba Yesuma Gareriroma Jodani ogoro are fari. ");
INSERT INTO yrb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Joni dawa unutawa i babataito ueta iba Yesuba wei, nana Abai babataito uegou umau rairo aneba nabai are farinu wei? ");
INSERT INTO yrb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Weiro Yesuma wei, ido, Na babataito ufasuna Godinu kobere imueta enanari ufutu wei. Eno weiba Jonima Yesu babataito ui. ");
INSERT INTO yrb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jonima Yesu babataito ue me sinina Yesuma ogoroma duero amuteda erina ure eba uiro Godinu Imumu Kotofuma ubani ari tararite Danu deiro yauriro eri. ");
INSERT INTO yrb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eno uiro ureroma sina tararite wei, ewana Nanu amara ubiba Nanu neno Dawabai ibinuro yaru utatane wei. ");
INSERT INTO yrb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Godinu Imumu Kotofuma Yesu munite woure eme ibawa orofaro ani. Woure aniro seitanima Yesu ue efie Dawabai fari. ");
INSERT INTO yrb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesuma iro ibeda kowa fotini (40) dumu foti (40) ieta itawa. Ieta itawa me ibebe kowa foti (40) me siniro Yesu osi derawere uri. ");
INSERT INTO yrb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Osi uiro seitanima Yesubai farite wei, A Godinu amarana wiaro ewa gebiro ieta sibi wei. ");
INSERT INTO yrb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Weiro Yesuma moko wei, Godinu bukaroma eno wasu, emema ieta torowa ifitaitana emanu ibetana ba me. Nono Godinu bebeturoma sina nesia naufitaitana emanu ibetana ba, eno wasu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Seitanima Yesu ido munite woure Jerusaremu suro ani. Ane i dera dubu su etu fou deirowere odite wei, A Godinu Amarana ewadoroma bibu uate taniaro Godinu bukaroma eno wasu, Danu aneruma A yawoteda agema maibitaro merau itafaro Anu buri gebiroma da ufisu, wasuba iba bibu ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Weiro Yesuma dawaba wei, Godinu bukaroma nono eno wasu, anu Dera Godi da ue ea wasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Seitanima Yesu nono munite mui yafa maidani otoro woure mane odi. Mane odite i orofa atata kabesini uwaraini nesia tube tuberoma ari ma boroyariro Yesuma eri. ");
INSERT INTO yrb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Eriro seitanima Yesuba wei, nanu buri gigirari arubi ufate nabai guriguri ufasuna ina nesia Aba mamau wei. ");
INSERT INTO yrb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Weiro Yesuma ido wei, seitani Nabairoma ania! Godinu bukaroma eno wasu, anu dera Godibai torowa guriguri uawete Danu gaukara torowa uawe eno wasu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Seitanima Yesu ido ekodiro aneruma Dawabai taratate yawota. ");
INSERT INTO yrb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Moana uwarama Yesubai fatate weita, Joni budari uta weitaro nauite Gareri orofaro ani. ");
INSERT INTO yrb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","14","Nasareta suroma ane Sebiuronini Nafatarai orofa Kafenamu suro fari. Kafenamu su enea gigirari ibiro iro Godinu we bou ueta amara Isaiyama weiba iba iro fari. ");
INSERT INTO yrb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Isaiyama eno wei, Jodani ogo etarafu enea gigiraribai Sebiuroni Nafatarai orofaini i orofa sadei ibita. Gareri orofana aika uwaranu ibeta kabesi. Gareri orofa uwara faiyawere iro dumuro ari yaubebitana ario ari derawere uiro eta. ");
INSERT INTO yrb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","I uieta utumuro ari yaubeta uwarabai Godinu ario derawere ui, Isaiyama eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","I kowaroma Yesuma sina derawere eno wei, i urero yawotasu kowa fafie utasuba yanu neno neno ueta dubena afu sawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesuma Gareri mesau nioro inarebe erina dataeini dabue Saimoni danu mui ifu Fita dawaini danu dabue Enuduruini emanu iwame ogoro sane inarebisiro eri. I amara sadeina erio egi woureta amara sadei. ");
INSERT INTO yrb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","I amara sadei erite emaba wei, Na are yawoawaro anibete ya eme muneta amara sadei odimaro eme muawaro naueta uwara sibita wei. ");
INSERT INTO yrb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Weiro ido i amara sadei emanu iwame sau ekoisite Yesunu buribi anisi. ");
INSERT INTO yrb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","22","Iroma Yesu anebe erina mui dataeini dabue, Jebedinu amara sadei Jeimisini Jonini emanu damamaini boutiro yaubeda iwame ma wirotebitaro eri. Ema erite yua weiro emanu damamaini boutini ekoisite Danu buribi anisi. ");
INSERT INTO yrb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuma Gareri orofa aboro aboro inarebi. I Ju uwaranu dubu su suro we mawetu uteda Godinu kotofu yawotasu sina webite i uwaranu oferi aika maikaroma ma wirotebi. ");
INSERT INTO yrb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Eno utebiba i Siria orofa uwara Danu buna ueta nautate emanu oferi aika maika uwaraini siosa imumu bobo uwaraini meo uie uyare ueta uwaraini age sanawa buri inarawa uwaraini ema nesia Yesubai woure fare oitaro ema nesia ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ema ma wiroiro Gareri uwaraini Dikaforisi uwaraini Jerusaremu su uwaraini Judia orofa uwaraini Jodani eterafu uwaraini uwara fefera faiyawere ema Danu buribi anita. ");
INSERT INTO yrb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Yesuma i uwara faiyawere erite maidaniro manite yaurina Danu iwata ueta uwara Dawabai mane fata. Fataro emaba yare wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Weite Yesuma eno wei, ana anama emanu nauetaba Godibai weduru ue sasae utawa ue emanu torowa ma otowaratu uteda yaru utaita. I uwarana Godinu urero yawotasu orofana emanu. ");
INSERT INTO yrb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Awona emanu siosawere uetaba imuteda i waita uwara, Godima ema ma etoto ufiro yaru ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","I emanu torowa ma derawere utawa utaita uwara Godima emaba i reka orofa atata nesia mafiro iro ibeda yaru ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","I uwara emanu ununa Godinu kobere imueta ari uegou ufitae ogoini ieta nodo wourebaita i ari utaita uwarana Godima ema durua ufiro enanari kobererau ufitate yaru ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","I emeba ure nudarau utaita uwara Godima emaba moko ure nudarau ufiro yaru ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","I uwara emanu nenonu imueta roatarauba emana Godi efitate yaru ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ana anama wesarau ueta emebai mawetu uteda uteibitaitana Godima emaba Nanu aruma amara webiro naufitate yaru ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","I uwarama kobererau utaitaro emema emaba siosawere utaita. Enoba Godima i kobere uwaraba Danu ure yawoeta orofa mafiro iro ibeda yaru ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Emema yabai Naba siosa sina webitate siosawere ufitate meoma wawei sina webitaitana yaru uawe. ");
INSERT INTO yrb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yanu moko muneta derawere urero muboitaba yaru derawere uawe. Bodere i uwaranu danatamutuma Godinu we bou ueta uwaraba enanari siosa utebita. ");
INSERT INTO yrb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yana ewa orofa atata uwaranu soru ari. Emema imonawere soru itebaita i ari yana kobererau utebaitana emema ereda ina kobererau webaita. Sorunu imona me sibisuna anene danu imona nono imona ufisu? Ina ba meba mu sanaitaro emema deiro amune adire anaita, i ari yana siosawere ufoitana emema yanu sina da naufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yana ewa orofa atatanu nanefa ario ari. Mui maidani otoro ibinu su da feafisu. ");
INSERT INTO yrb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Emema nanefa beataitate okia ubarero odawa utaitate aiyo oeta kabesiro odaitaro i nanefama i su ubare nesia ario utasu. ");
INSERT INTO yrb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Enanari yanu kobere ueta nanefa ario ari uawero emema efitate yanu urero ibinu Baba Godinu ifu we ma derawere ufita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mosesinu tarawatuini Godinu we bou ueta uwaranu sina mune samau da imuawe. Ina mu samane farawa unete ina ma borobayamane farea wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nanu sina ba wemaro nauawe, ureini nasinini sau da me sibite ibifisu. I woworo Godinu tarawaturoma mui sina tai kikimuikiratu me sara da feafisu. Sara da ufiro nesia uegou ufisuna ina idoni me sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Anama Godinu tarawatu sina demurairatu nautawa utasute nono moana uwaraba enanari we mawetu utasuna dawa i ure yawoeta orofaro kikiratu sibisu wei. Nono anama Godinu tarawatu sina nesia nauegou utasute nono moana uwaraba enanari we mawetu utasuna i ure yawoeta orofaro dana derawere sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yaba wemaro nauawe wei. Weite wei, i Ferosi waita uwaraini tarawatu tisa uwarama aneane kobererau utaitate nono moana ueta uegou utawa utaita. Nono yana Godina torowa Kobererau uegou uforo yanu kobere ueta sinetama i Ferosi uwaraini tarawatu tisa uwaranu ueta sineta serigari ufisuna i ure yawoeta orofaro ane ibifoita wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mosesima i bodere uwaraba eno wei, i bodere uwaraba eno weita, eme da ma uiawe. Anama mui amara ma uifisuna dawa koto ufitaita weita. Nono yaba eno watane, anama danu domayaba ibo ufisuna dawa koto ufitaita. Nono anama danu domayaba siosawere webisuna i kanisoro uwarabai woure ane odifitaro dawaba sina kimuwere webitaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nono anama danu domayaba ana beforo siruru me amara webisuna dawa i uitawa inaro anibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ana Godinu fuyo oeta kabesiro anu fuyo oeta odifae anibate nono iro anu aiyema aba ibo utasu imufasuna anu fuyo oeta iro ibifiro anu aiyebai anibate nesia dawaini ma rorowarau ufawate nono owefate anu fuyo oeta odia wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mui amarama ya koto uwarabai wawei webie woure anibisuna dawaba sau naiye wiawe. Mena i ya wawei webisu amarama ya koto yawoeta dera amaranu age duro odifiro koto yawoeta dera amarama ya forisimaninu age duro odifiro forisimanima ya diburaro odifisu. ");
INSERT INTO yrb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nanu ba sina wemaro nauawe, ya diburaro odifiro sau wawaro da amufoita. Daido iro ibeda yanu moko faini oi nesia maforo ya odifiro wawaro aniboita wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Dita yagera da fawe eno weitaro ya nauta. ");
INSERT INTO yrb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nono yaba eno watane, anama mui aweta o aruma dita yagera fafie imutasuna dana nenoma dita yagera farasu Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Anu banibira afu ditima a ma siosa ufisuna ma guju uate mu sate diti demuraima ibifasuna ina kobererau, diti sadeima i uitawa inaro anibasuna ina siosawere iba ma guju uate mu sa. ");
INSERT INTO yrb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Anu banibira afu agema a ma siosa ufisuna i mui age umane tuate age demuraima ibifasuna ina kobererau. Ofe ubu nesiaini uitawa inaro anibasuna ina siosawere wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mosesima i bodere uwaraba eno wei, anama danu aweta ekodifie utedana danu awetaba dawa ekoeta koto feifa mafite ekodifisu weiya wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Eno weite wei, nono Nana yaba watane, anama danu igera sasae utawa aweta mui ubi mero me ekodifisu. Me ekodifisuna i aweta ma igera sasae ufisu. Iba i awetama mui amara danu awera mubisuna igera sasae daido utedibeibisu wei. Weite wei, eno uteibiro danu reka aweraini daido dita yagera utedibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mosesima i bodere uwaraba eno wei sina ya nauta. I sinana eno, buna we bou ufoitana meo da wiawete ane we bou ufoitana Godibai enanari uawe eno weiya wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nono Nana yaba watane, sina we bou utedana i sina ma buna ufoe ufoitana urenu ifuro da wiawe ina Godinu yaure yawoeta orofa wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nono enanari wei, nasininu ifuro da wiawe ina Danu buri amue ibeta kabesi wei. Jerusaremu sunu ifuro da wiawe ina i dera yawoeta amaranu su wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yanu kofiriro da wiawe yana i fouma iji da weboro inawere aba dubawaru da ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yanu sinana aiwia o me torowa wiawe. Nono mui aika buna sina weboe ufoitana seitaninu aramawere imueta yabai mafiro weboita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mosesinu wei sina ya nauta. I sina eno, mui amarama mui amaranu diti ma guju ufisuna danu diti moko ma guju uawe. Mui amarama mui amaranu nio ma furiafisuna danu nio moko ma furiawe eno weiya wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nono yaba watane, mui amarama yaba siosawere ufisuna moko da uawe. Mui amarama yanu mui taibau ufisuna yanu mui taibau dana nono ufie oweawe. ");
INSERT INTO yrb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nono mui amarama yanu seti mubie ya kotoro woure anibisuna yanu setini yanu dei baruetaini dawaba mawe. ");
INSERT INTO yrb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mui meremere amarama danu ununa danu ego yana woure daba fuyaratu aniboe bunawere webisuna dawaini i yafa dabaro aniawe. ");
INSERT INTO yrb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Moana uwarama nui webitaitana emaba mawete nono moana uwarama yabai ane we mubitaitana emaba mawe Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mosesinu wei sina ya nauta. I sinana eno, yanu yaiyemutuba neno arama uawete nono yanu wasai uwaraba neno ka uawe eno weiya wei. ");
INSERT INTO yrb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Eno weite wei, nono Nana yaba watane, yanu wasai uwaraba neno arama uawete yaba siosawere utaita uwaraba Godibai guriguri uawe. ");
INSERT INTO yrb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eno ufoitana yanu urero ibinu Babanu adarabu siboita. Godima i uwara nesiaba eno uteda Danu kowa ario i kobere uwaraini i siosa uwaraba matasute Danu obi i kobere uwaraini i siosa uwaraba enanari matasu. ");
INSERT INTO yrb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Moana uwarama ya neno arama utaitaro emaba moko neno arama utaitana Godima ina kobererau da webisu. I takesi muneta uwarama enanari utaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yanu yaiyemutu torowaba ario sina weboitana ina ba me. Uwara nesia enanari utaitaro i Godi iwata me aika uwaraini eno utaita. ");
INSERT INTO yrb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yanu ueta sineta Godinu kobere ueta sineta ari uegou uawe, Yesuma i sina eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yanu ununa emema yanu ueta sineta efitate yanu ifu we ma derawere ufitae iba da uforo. Emema efitate yanu ifu we ma derawere ufitae ufoitana ina yanu moko muneta nono yanu urero ibinu Babama yaba kobererau me maeta moko da mafisu. ");
INSERT INTO yrb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yanu ununa ibaiabai me uwaraba ane mafoitana emema naufitate efitae yua derawere da wiawete kiwuma mawe. I meoma weta uwarama Ju uwaranu dubu suini natofo su daba dabaro eno utaita. Yaba ba wemaro nauawe, emema eno utaita wei. Weite wei, yaba ba wemaro nauawe, emema eno utaitaba ina emanu moko muneta. ");
INSERT INTO yrb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yanu ununa ibaiabai me uwaraba ane mafoitana kiwuma maforo emema da efitaita. ");
INSERT INTO yrb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ido kiwuma uforo yanu Yamamama i kiwu ueta erasuba ya ma kobererau ufisu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yana guriguri utedana i meo meo uwaranu guriguri ueta ari da uforo. I uwarama emanu ununa emema ema ereta iba Ju uwaranu dubu suro o dabaro inaibeda emema efitae guriguri utaita. Yaba ba wemaro nauawe, Godima ema ma kobererau da ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yana guriguri utedana yanu su koruro aniawete kasimu garari uawete yanu urero Yamamabai kiwuma guriguri uawe. Eno ufoitana yanu Yamamama yanu kiwuma ueta erasuba ya ma kobererau ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Guriguri utedana i Godi iwata me aika uwaranu sina faiya faiyawere emanu ba me godibai guriguri ueta ari da uforo I uwarama sina faiya faiyawere webitaro Godima naufie imutaita. ");
INSERT INTO yrb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","I uwaranu ueta ari da uforo. Yanu urero Yamama yanu unu nesia iwata utasu. Yanu wenauereta wiawa utaitaro Dawa iwata utasu. ");
INSERT INTO yrb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Guriguri utedana eno wiawe, yanu urero ibinu Baba, Anu ifu kakarawereba Aba ititi kakara utaisi. ");
INSERT INTO yrb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Anu yawotasu kowa fafie waisi. Anu ununa ua, urero utasuba nasiniro enanari ua. ");
INSERT INTO yrb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Awonana yanu ainewaure matebasu ieta mai. ");
INSERT INTO yrb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yanu naiyemutunu ba me ueta yaba utaita, ina mune aika odaisi enanari yanu ba me ueta mune aika odia. ");
INSERT INTO yrb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","I siosa ue ereta ibaiabai yabai da woure arate i siosabairoma ya woure eta ania. ");
INSERT INTO yrb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yana emenu ba me ueta mune aika odifoitana yanu urero ibinu Yamamama yanu ba me ueta mune aika odifisu. ");
INSERT INTO yrb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nono emenu ba me ueta da mune aika odifoitana yanu Yamama yanu ba me ueta da mune aika odifisu. Yesuma i sina eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yana Godibai guriguri ufoe uteda ieta itawa utaitana yanu ibo nawata aika maika da uawe. I meoma weta uwarama Godibai guriguri ufitae uteda ieta itawa utaitana odakoko taraita. Eno da uawe. I uwarama eno utaitaba ina emanu moko muneta. ");
INSERT INTO yrb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Godibai guriguri ufoe uteda ieta da ifoitana yanu kofirini ibo nawata uroawero emema yanu ieta itawa ueta da efitaro yanu urero ibinu Yamama i yanu kiwuma ueta erasuba yaba kobererau maeta moko mafisu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","20","Ibaiabai derawere ewa sakairo deiro deiro da odiawe. Ewaro jirikoini towima ina itaitaro waira ueta uwarama ibaiabai waira utaitaba yanu nauetaini Godibai gaukara ueta ina urero ibaiabai ari iba nauegou uteda ibaiabai ewa sakairo deiro deiro da odiawe. ");
INSERT INTO yrb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yanu ibaiabai aboro ibasuna yanu nenoini iro ibasu. ");
INSERT INTO yrb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yanu ditina yanu ofe ubunu nanefa ario ari. Enoba yanu ditina kobererau yanu ofe ubuna ariowere. ");
INSERT INTO yrb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nono yanu diti aramawerena yanu ofe ubuna dumuwere. Enanari yabai ario mena yana dumu ariba eregou uforo! Yabai dumu derawere ibinu. Yanu imueta igawerena yanu ibeta aramawere. ");
INSERT INTO yrb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mui gaukara amarama dera amara sadeinu gaukara da ufisu. Eno ufisuna mui dera amara ma yaru uteda nono mui dera amara ma ibo ufisu. I dera amara demurainu gaukara uegou uteda nono i mui amaranu gaukara me sara ufisu. Enoba Godinu gaukara uteda gugua gubarini Godini nesia da ma demurai ufote gaukara da ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Enoba yaba watane, yanu ibetaini ofeba da imuforo! Yanu wiroeta ietabairoma da wirofeisi. Yanu ofena i baruetama da ma wirofisu. Iba ietaini barueta torowa woroworo da imuawe. ");
INSERT INTO yrb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","I gasira imue eawe. I gasirama ana tai waitawa ana tai fira utawa, emabai ietata oeta su mero nono yanu urero ibinu Babama emaba ieta matasu. Godima ema imuteda nono yabana derawere imuegou utasu. ");
INSERT INTO yrb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Anama eno imutebe imutebe danu ibeta kowa ma yafa ufisu? Me. ");
INSERT INTO yrb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Aneba wadiaba imutaita? I sigina imue eawe! I sigina emanu torowa gaukara utawa emanu torowa wadia ue yurawa me warataita. ");
INSERT INTO yrb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Soromonima danu araeta wadia baruina danu wadiana ba mero i siginanu fomueta araetana kobererau. ");
INSERT INTO yrb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nono Godima i koe awona ma werei werei ue odasuna nono waidumu i koe inama yafitaita. Godima eno utasuna nono ya kikiratu naueta uwaraini yaba wadia matasude wei. ");
INSERT INTO yrb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ibago ane ietaini ogoini ifete ane barufeisi da imue weboro! ");
INSERT INTO yrb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","I Ju me aika uwarama ina doberegou utaitaro nono yanu urero ibinu Baba ina yanu ibeta Dawa iwata utasu. ");
INSERT INTO yrb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ietaini ogoini ane ane nesia da doberegou ufote nono Godinu kobere yawoe anasu orofa doberegou uforo yanu ietaini ane ane nesia yaba mafisu. ");
INSERT INTO yrb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ibago waidumu ane ufisu eno da imuforo wei. Waidumu i ueta sineta ido fafisuna ido imufoita. Kowa demurainu ueta sineta i kowaro torowa imuegou ufoita, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Yesuma wei, moana uwarabai mui amaraba me sara wawei da weboro Godima yaba moko wawei da webisu. Wawei webote fanisi mafoitana Godima enanari yaba moko wawei webite fanisi mafisu. Ane ufoitana enanari muboita. ");
INSERT INTO yrb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aneba mui amaranu diti ubarero ifururatu eregou utaitate yanu diti ubarero ibinu ana tumi erawa utaita? ");
INSERT INTO yrb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Aneba waita, kaka, ueta siosawere kikiratu, ifuru ari, anu ditiro ibinu ma mumu umau waitana yanu diti ubarero ueta siosararabo, ana tumi ari, ibinuro ya erawa utaita? Ya meo meo uwara yanu diti ubarero ibinu ana tumi botai mu sabote eregou ufoitana nono yanu yatae yabuenu diti ubarero ifuru ma mumu ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Godinu kobere sina i nautawa uwarabai sara da mafoita. I uwarana kua ari enoba emabai me sara da mawe. Yanu Godinu matasu imueta, ina oi gebiro ari, ina borosiribai da saboita. Saboitana borosirima amune adire anibitate nono ma owere ya umafitaita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Wenaueawero mafiro muawe. Dobeawete atawe. Yaubinu wiawero ma ifegari ufi wei. ");
INSERT INTO yrb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Anama wenauefisuna mafiro mubisu. Anama dobefisuna atafisu. Anama yaubinu webisuna dawaba ma ifegari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ananu amarama ietaba nui webisuna gebiro mafisu? Me. ");
INSERT INTO yrb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ananu amarama erio egiba nui webisuna towi mafisu? Eno da ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ya siosa uwarama anene yanu koiniboroba kobere maeta mataitana ya iwata enoba ana anama ane Godibai wenauefoitana yanu urero ibinu Yamamama yaba kobererau maeta maegou ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Emema yaba enanari ufitae imutedana emaba enanari utebeawe. Eno ufoitana ina Godinu tarawatu sinaini Danu we bou ueta uwaranu sina ubi idoba eno ufoita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesuma nono wei, i kikiratu bebetoro fare aniawe. I uitawa yareiene yareiene ueta ina kabesinu bebetona derawerero i dabana kimu meba uwara faiyawere iro fare anaita. ");
INSERT INTO yrb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nono i ibene ibene me ibeta kabesinu bebetona amoworaturo i dabana kimuwereba uwara faiya me dobere fare anaita. ");
INSERT INTO yrb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","I meo we bou ueta uwaraba eregou uforo! Emanu ibo nawatana mamoe eginu ereta ari ema awe egi me nono emanu imuetana orowa kuanu imueta ari. ");
INSERT INTO yrb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ema anene utaitana yana ema iwata utaita. Emema gureifi nadidi tai me sara ruruwere nadidiro munawa utaitate boruba tai sinisini bobo anaro munawa utaita. ");
INSERT INTO yrb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Idoba kobere ana kobere tai uwanasu. Siosa ana siosa tai uwanasu. ");
INSERT INTO yrb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kobere ana siosa tai uwanawa utasu. Siosa ana kobere tai uwanawa utasu. ");
INSERT INTO yrb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","I siosa ana kobere tai uwanawa utasuba umane turaitate ina yaretaro sanaita. ");
INSERT INTO yrb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","I uwaranu ueta, ana tai ari, eraitate ema iwata utaita. ");
INSERT INTO yrb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Moana uwara faiyawere Naba Dera Amara, Dera Amara waitana nono i uwara nesia i ure yawoeta orofaro da anibitaro Nanu urero ibinu Babanu imueta utaita uwarama torowa iro anibitaita. ");
INSERT INTO yrb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","23","Nono uwara faiyawere Godinu koto kowaro Nabai webitaita, Anu ifuro we bou utebisite seitaninu siosa imumu we beratebisite buna ueta utebisi eno webitaitana ya siosawere utaita uwara Nana ya iwata meba Nabairoma aika aniawe wemau Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Anama Nanu sina nautasute utasuna dana iwata derawere amara ari. I amarama danu su tutubu eba yafawere daurite tutubu gebiro deiro sanite gebiroini sakaini sanite isuma yanairo kimu ui. ");
INSERT INTO yrb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Danu su eno ubu uiro obi matebiro oku farebiro oyau derawere farebiro su gebiro deiro ibiba jugari utawa ui. ");
INSERT INTO yrb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Anama Nanu sina nautasute gifena utasuna dana beforo me amara ari. I amarama danu su tutubu sanawa uite magua deiro ubu ui. ");
INSERT INTO yrb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Eno uiro obi matebiro oku farebiro oyau derawere farebe i su ma jugari uiro i su daido me sini Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuma Danu sina we me siniro i uwara nesia Danu we mawetu uetaba neno kirifu uta. ");
INSERT INTO yrb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yesuma bunawere we mawetu utebi. I tarawatu tisa uwaranu we mawetu ueta i ari meba i uwara neno kirifu derawere uta. ");
INSERT INTO yrb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuma maidaniroma tararina uwara faiya faiyawere Danu buribi anita. ");
INSERT INTO yrb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mui amaimawere amara Yesubai farite jegirari uteda nui wei, Dera Waria Amara, Anu unu ufasuna na ma wirofaro wiromau wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Weiro Yesuma Danu age sanite i amara buriteda wei, Nanu unu a ma wiromaro wiroa wei. Weina i amaranu amaima ido me siniro wiroi. ");
INSERT INTO yrb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesuma i amaraba wei, eme nesiabai da ane wiate fuyo ode sina weta amarabai torowa aniate anu ofe mawetu uaro efi wei. Anu ofe kobererau usinuba Mosesinu tarawatu buri age amaima fuyo oeta enanari uaro emema efitate anu ofe wirosinu iwata ufita wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Yesuma Kafenamu suro farina mui Romani gaemani ami kafitenima Yesubai farite nui wei, Dera Waria Amara, nanu gaukara amarana age sanawa buri inarawa me aineda ofe derawere wourinute me ainasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Weiro Yesuma dawaba wei, iro animate dawa ma wiromau wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Weiro ami kafitenima Dawaba wei, Dera Waria Amara, na kobererau meba nanu suro da arate me sina torowa wiaro nanu gaukara amara wirofi wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Eno weite wei, nana dera ami amara. Moana dera uwarama na yawotaitaro nana ami uwara faiyawere yawotatanete mui amaraba ania watanero anasu. Mui amaraba ara watanero arasu. Nanu gaukara amaraba eno ua watanero enanari utasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Weiro Yesuma i sina nauite neno kirifu uite Danu buribi aneta uwaraba wei, yaba ba wemaro nauawe. I Isaraero uwarabai imueta derawere ewa amaranu imueta i ari atanawa une wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","12","Yaba watane, eme faiyawere kowa amueta afuini kowa itareta afuini ure yawoeta orofaro fafitate Eibaramuini Aisikini Jeikofuini kaiyobai yaubeda ieta ifitaro nono i Ju uwara, i ba urero yawoeta kabesi mubitae utaita uwara, Godima ema wawa, i dumuwere kabesiro mu sabiro iro emanu nio bijari uteda i webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesuma eno weite i ami kafiteniba wei, ania, kimuwere imusinuba enanari ufisu wei, Weina i danu gaukara amarama ido wiroi. ");
INSERT INTO yrb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuma Fitanu suro amui. Amo erina Fitanu daroya ofe wakiki wourite ainibiro eri. ");
INSERT INTO yrb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Erite danu agero mamiro ofe wakiki ido toba ui. Toba uiro Fitanu daroyama uyarite Yesuba ieta mai. ");
INSERT INTO yrb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dumu sinebiro emanu seitaninu mui siosa imumu bobo uwara Dawabai woure oitaro Yesu bebetuma seitaninu mui siosa imumu we beraite i oferi woureta uwara nesia ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Bodere Godinu we bou ueta amara Isaiyama weiba Yesuma enanari ui. Isaiyama eno wei, Dawa yanu ofe ba me munite yanu oferi woureta mune ma wiroi, Isaiyama eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Uwara faiyawere Yesu ode kara utaro Yesuma erite Danu iwata ueta uwaraba etarafu yofefe wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Eno weina mui tarawatu tisa amarama Yesubai farite wei, Tisa, aboro aboro anibasuna naini animau wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Weiro Yesuma dawaba wei, i oi egina emanu su bobo, gasirana emanu mowa bobo, nono i Ba Eme Sini Amara Danu aineta kabesina me wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Weiro mui iwata ueta amarama wei, Dera Waria Amara, nanu baba uifiro uri ue odimate Anu buribi animau wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Weina Yesuma wei, me, awona Nanu buribi ara. Nanu buribi anawa uwarama Nanu buribi anawa uieta uwara uri ufitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesuma bouti ubarero amuiro Danu iwata ueta uwarama Danu buribi anitate amutate anita. ");
INSERT INTO yrb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Anitaro Yesu nauta ainibina oyabibi derawere fari. Oyau fariba enea ufe uyariro bouti inufie uiro Yesu daido nauta ainibi. ");
INSERT INTO yrb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eno uiba i iwata ueta uwarama Yesu ma uyatate derawere weita, Dera Waria Amara, ya uifene utaisia ma wiroa weita. ");
INSERT INTO yrb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Weitaro wei, ya naueta kikiratu uwara aneba iyaraita weite uyarite oyauini ogoini bana weiro nautaro binono sani. ");
INSERT INTO yrb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Enoba i uwarama neno kirifu uteda weita, ewa amara abo amararo oyauini ogoini Danu sina nautaita weita? ");
INSERT INTO yrb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gadarinisi orofa, mesau etarafu iro ane inata. Seitaninu moana siosa imumuma rewoi ibeta bobo amara sadei uri oeta gebiro eraboro ibebina. I amara sadei awe derawereba emema i dabaro anawa. ");
INSERT INTO yrb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","I amara sadeima Yesu atasite weisi, Godinu Amara waba ane ufae utasu? Wanu koto kowa farawaba waba fanisi da ma weisi. ");
INSERT INTO yrb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Weisina borosiri faiyawere etararo ieta ie inarebita. ");
INSERT INTO yrb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Idoba seitaninu moana imumu siosama weita, ya we ma berafasuna i borosirinu ubarero siaia uaro anibe weita. ");
INSERT INTO yrb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Weitaro Yesuma emaba wei, aniawe wei. Weina anitate i borosirinu ubarero itata. Itataba i borosiri nesia durami ue anitate maidani otoroma mesauro bibu utate imuie me sita. ");
INSERT INTO yrb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","I borosiri yawotebita uwarama i orofa ekoitate sau durami ue anita. Ane natofo suro fatate imumu siosa bobo amara sadei wirota sina weitaro nauta. ");
INSERT INTO yrb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","I natofo su uwara nesia suroma anita. Ane Yesubai fatate Yesu ereda yanu orofaroma sau ania weda nui weita. ");
INSERT INTO yrb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesuma bouti ubarero amuite etarafu, Danu su onamero yofere ani. ");
INSERT INTO yrb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ane fariro moana uwarama age sanawa buri inarawa amara wia warafaro oitaro ainiro Yesubai woure fare oita. Oitaro i amara woure fata uwaranu naueta kimuwere Yesuma erite i age sanawa buri inarawa amaraba wei, Nanu amara, anu neno neno ueta Nana mune imutawa unea neno kimu ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Eno weiba moana tarawatu tisa uwarama emanu aika eno weita, ewa amarama dawaini Godini arotorowa wasuna dawa Godiba sina siosa wasu weita. ");
INSERT INTO yrb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Weitaro Yesuma emanu imueta iwata uteda emaba wei, aneba nenoma siosawere imutaita? ");
INSERT INTO yrb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Abo sinama wemau? Anu neno neno ueta mumate imutawa umau aba uyate anu wia muate ania ari? Abo sinama kimuwere wei? ");
INSERT INTO yrb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yesuma eno weite wei, i nasiniro inarasu Ba Eme Sini Amaranu buna derawereba iba emenu neno neno ueta munasute imutawa utasuro yana nesia ereda iwata utaita weite i age sanawa buri inarawa amaraba wei, uyate anu wia muate anu suro ania wei. ");
INSERT INTO yrb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Weiro i amara uyarite danu suro ani. ");
INSERT INTO yrb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","I guruguru ubita uwara nesia ereda neno kirifu uta. Godima emeba buna derawere eno maiba we ma kobererau uta. ");
INSERT INTO yrb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuma iroma ani. Anebina mui takesi muneta amara, danu ifuna Matiu, dawa takesi muneta suro yaubiro Yesuma eri. Erite wei, Nanu buribi ara weina ido uyarite Yesunu buribi ani. ");
INSERT INTO yrb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesuma su ubarero ieta ifie yauri. Takesi muneta uwara faiyawereini neno neno ueta uwara faiyawere Yesuini Danu iwata ueta uwarabai ieta ifitae fata. ");
INSERT INTO yrb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fataro i Ferosi uwara etate Yesunu iwata ueta uwaraba weita, yanu tisa amaraini i takesi muneta uwaraini neno neno ueta uwaraini aneba uruama ieta itaita weita? ");
INSERT INTO yrb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Weitaro Yesuma nauite wei, i ofe wourawa uwaraba dogeta amara arawa uite i ofe woureta uwaraba fari wei. ");
INSERT INTO yrb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nanu ununa yanu neno arama ueta, Na unutawa yanu fuyo oeta, aniawete i sinanu ubi ue iwata uawe wei. I kobere uwaraba wemane waya farawa i neno neno ueta uwaraba wemane waya farea wei. ");
INSERT INTO yrb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Joninu iwata ueta uwarama Yesubai fatate weita, i Ferosi uwaraini yaini baetaba ieta itawa ka utaiside nono Anu iwata ueta uwarama aneba ka utawa ieta itaita weita? ");
INSERT INTO yrb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Eno weitaro Yesuma emaba wei, i reka aweta muneta amarama danu domayamutuini ogaro itasuba i ogaro itaita uwarama i da webitaita. Dawa emabai ibinuba iba i da webitaita. Nono mui kowaro i reka aweta muneta amara mubitate woure aika orofaro odifitaitana i uwarama ieta da ifitate ieta ka ufitaita. Enanari emema Na woure anibitaitana Nanu iwata ueta uwarama eno ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Anama reka wadia fifima bodere wadia ebaro fifinu ufisuna i bodere wadia babafite eba derawere ufisuba iba eno da ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Enoba nauawe, reka waini bodere egi ofero adu ufoitana bodere ofe da foafisuba iba eno da ufisu. Adu ufoitana i bodere egi ofe babafiro waini nasiniro itafiro egi ofeini waini ido arama ufisu. Reka waini reka egi ofero adu ufoitana wainini egi ofeini ido kobererau ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuma emaba eno webina mui Ju uwaranu dubu su yawoeta amarama farite Yesunu buri gigirariro jegirari uteda wei, nanu aruma uisinua arate Anu agema dawa buriaro wirofite me ibifi wei. ");
INSERT INTO yrb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Weiro Yesuma ido uyarite i amaranu buribi ani. Danu iwata ueta uwara dawaini anita. ");
INSERT INTO yrb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ido anitaro mui aweta ofe derawere wourebe onono woroworo munebi. Oya tuero (12) eno munebi. I awetama eno we imui, Danu wadia fifiro burimate wiromau we imuite Yesunu dubena afuro farite Danu wadia fifiro buri. ");
INSERT INTO yrb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Buriro Yesuma owerite i aweta ereda wei, aruma, neno kimu ua. Anu naueta derawereba iba wirosinu wei. Weina i aweta daido ba ido wiroi. ");
INSERT INTO yrb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesuma i yawoeta amaranu suro farina moana uwarama feku ari ubutaro i guruguru ubita uwarama sorara derawere utebitaro eri. ");
INSERT INTO yrb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Erite i uwaraba wei, eta seriawe i arumana ba uitawa me nauta ainibinu wei. Weiro i uwarama we iruteda yo weita. ");
INSERT INTO yrb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yesuma weiro i guruguru ubita uwara nesia wawaro itata. Itataro Yesu ido suro amuite i arumanu agero muniro i aruma uietaroma ido uyari. ");
INSERT INTO yrb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","I sina i orofa atata nesiaro we inarebita. ");
INSERT INTO yrb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuma iroma anebi. Anebina diti basugari amara sadeima Danu buribi aneda derawere weisi, Deiwidinu amara waba neno arama ua weisi. ");
INSERT INTO yrb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Weisiro suro amuina i amara sadei iro amusite Dawabai fasiro Yesuma emaba wei, eno umau imutaisi wei? Weina weita, Dera Waria Amara, aiwia weisi. ");
INSERT INTO yrb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Weisiro Yesuma emanu diti buriteda wei, yanu naueta derawereba yaba enanari umau wei. ");
INSERT INTO yrb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eno weiro emanu diti ido forairo esi. Yesuma emaba bunawere eno wei, moana uwarabai da wiawa wei. ");
INSERT INTO yrb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Weiro i amara sadei i wei sina naue nautawa ari usite i orofa atata nesiaro i ueta nesia we inarebisi. ");
INSERT INTO yrb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yesuini i uwaraini iroma anita. Anitana moana uwarama seitaninu mui siosa imumuma rewoi ibeta bobo sina wiawa amara Dawabai woure fare oita. ");
INSERT INTO yrb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesuma i seitaninu mui siosa imumu we berairo aniro i amara ido sina wate wei. Enoba i guruguru ubita uwarama neno kirifu utate weita, ya Ju uwarama eno ueta bodere erawa awona kamama eraisi weita. ");
INSERT INTO yrb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Weitaro i Ferosi uwarama weita, Dawa i dera siosa imumunu bunaroma seitaninu siosa imumu we beratasu weita. ");
INSERT INTO yrb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuma dera natofo suini kiki natofo su suro inareda Ju uwaranu dubu su suro we mawetu uteda Godinu yawotasu orofa sina weda i aika maika ofe woureta uwaraini oferi woureta uwaraini ema nesia ma wirotebi. ");
INSERT INTO yrb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesuma i guruguru ubita uwara erina i uwarana buna me, imueta aika maika imutebita. I uwarana mamoe ari. I mamoena yawoeta amara meba daba aika maika me inarebaita i ari i uwaranu imueta aika maika imutebitaba Yesuma emaba neno arama ui. ");
INSERT INTO yrb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iba wei, i daure ieta ietatana faiyawere, i ari i Godinu sina nautawa uwarana faiyawere. Nono i daureta uwarana faiyawere me, i ari Godinu sina we inareta uwarana faiya me. ");
INSERT INTO yrb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Enoba i daureta ubi Amarabai guriguri uteda gaukara uwara Danu daureta orofaro siaia ufiro anibitae wiawero mafiro anibita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuma weiro Danu iwata ueta uwara tuero (12) Dawabai fata. Fataro Yesuma ema seitaninu siosa imumu we yowefitate ofe aika maika wouretaini oferi aika maika ma wirofitae iba emaba buna mai. ");
INSERT INTO yrb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","I uwara tueronu (12) ifuna ewado, botaina Saimoni danu mui ifuna Fita. Dawaini danu dabue Enuduruini Jebedinu amara Jeimisini danu dabue Joni. Emaini Firifini Batoromiuini Tomasini i takesi muneta amara Matiu. Emaini Arofiasinu amara Jeimisini Tediasini Keinani amara Saimonini Yesu do mai amara Judasi Isikarioti. Emanu ifu ifu ido. ");
INSERT INTO yrb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Yesuma i uwara tuero (12) siaia uteda sina eno we kakara ui, i Ju me aika uwarabai da aniawete i Samaria uwaranu su suro da aniawete i Isaraero uwara, i uwarana feareta mamoe ari, i uwarabai aniawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","8","Ane Godinu yawotasu kowa fafie utasu wiawete i ofe woureta uwara ma wiroawete moana uieta uwara ma uyawete i amaimawere uwara ma wiroawete seitaninu siosa imumu we berawe wei. Yana i buna ueta derawere munaitana moko oi matawa utaitaba iba enanari moko da mubote me mafoita wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Yesuma nono wei, yanu fausiro oi da youawete yoate da muawete mui wadiaini buri baruetaini akurini da muawe wei. Weite wei, i uwarama i gaukara ueta amara dawaba danu ieta moko mafitaitaba iba i nesia da mune aniawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mui natofo suro aniboitana Godinu sina naufie uteda ya we mubisu amara dobere atawete danu suro ibiawe. Mui su suro da ibiawe. I su demurairo torowa ibebe nono i natofo su ekodiawete aniawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","13","I amaranu suro amufoitana ario sina wiawete i suro ibeta uwara kobererauna Godinu wesa kawewera ueta yabai ibifisu we ma kobererau uawe. Mena yanu wesa kawewera ue we ma kobererau ueta owefite yabai ibifie watane wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ana anama ya da mubitate yanu sina da naufitaitana yanu dubena emabai sawete sakai buriroma maituawero ema ekodifoita iwata ufitaro ido aniawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yaba watane Godinu koto kowa fafiro siosa Sodomu su uwaraini Gomora su uwaraini fanisi kikiratu mafite i ya ere kodifitaita su uwarabana fanisi derawere mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Eawe, ya mamoe ari orowa kuabai siaia umauba towi ari beforo buna uawete ubani gasira danu wate ari ure nudarau wiawete kobererau imuegou uawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Emeba eregou uforo ya kanisoro uwarabai woure odifitate Ju uwaranu dubu suro woure odifitaro isuma ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Eno ufitate gaemani dera yawoeta uwaraini kini uwaraini Ju me aika uwarabai woure odifitaita. Godima ya Nanu sina weboro naufitae ufisuba iba eno ufitaita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Eno ufitaitana sina daba anene webeisi da imuawe. Da imuawero i sina weta kowa ido fafisuna yana sina da weboro Godima yabai imueta ido mafiro weboita wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","I kowaro yanu sina da weboro yanu Godinu Imumu Kotofuma yanu bebeturoma sina webisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","I kowaro dataema dabue do mafiro ma uifitaita. Damama danu amara enanari ufisu. Aruma amarama emanu danua damamaba enanari ufitaro ma uifitaita. ");
INSERT INTO yrb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ya Nanu ifu munaitaba i uwara nesia yaba neno ka ufitaita. Anama buna ufiro dubu kowa ido fafiro dawa wirofisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yaba siosawere ufitaitana mui natofo suro sau aniawe wei. Yaba ba watane, i Isaraero uwaranu su suro anebe anebe sau da ane me siboro i Ba Eme Sini Amarama ido fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","I ue iwata amarana derawere me, danu tisa amarana derawere. I gaukara amarana derawere me, danu dawa yawoeta amarana derawere. I ue iwata amaraini tisa amaraini arotorowa sibisisina ina ido. I gaukara amaraini yawoeta amaraini arotorowa sibisisina ina ido Yesuma wei. Na i su ubi amaraba Biesabo, seitani waitana, ya i su gaukara uwaraini ifu siosararabo webitaita wei? ");
INSERT INTO yrb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Emeba iya da uyawe. Emanu obari ueta ememetu nesia ma uregari ufite emanu feareta ememetu nesia ma boroyafisuba iba emaba iya da uyawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Dumuro yaba ane sina wemaro naufoitana enanari nono yana kowaro weboita. Nono yaba gimumutaroma wemaro naufote nono yana su abanaro inawete sina derawere wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","I ma uieta uwaraba iya da uyawe. I uwarama yanu ofe ma uifitate nono yanu imumu da ma uifitaita. Enoba anama yanu ofe ma uifite nono yanu imumuini ofeini i uitawa inaro sabisuba Dawaba torowa iya uyawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Emema gui gasira sadei kiki gebiro oi demuraima oiya ue mataitaro itaita. Mui gasiraratu nasiniro me sara da itafisu. Yanu ure Babama i gasirararatunu itareta Dawa iwata. ");
INSERT INTO yrb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Godima yaba imuegou utasu. Dawa yanu fouma iji nesia yawiteda iwata utasu. ");
INSERT INTO yrb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Godima i gasiraratu imutasute nono yabana imuegou utasuba iya da uyawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Anama emebai nanu naueta Yesubai ode webisuna Nana Nanu urero ibinu Bababai dawa Na imutatane wemau. ");
INSERT INTO yrb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Anama emebai Yesu na iwata me webisuna Nana Nanu urero ibinu Bababai i amara dawa Na iwata me wemau wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ane we imutaita? Na yaba merau ibeta, wesa mamane fare, eno we imutaita? Enoba ewaro farawa ue. Na ewa nasiniro wesarau ueta mamane farawa. Na wesarau ueta mamane farawarogo Nanu sina wemaro moana uwara nauteibitaro moana uwara nautawa uteda urane yarane uteibitae iba farea wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Weite wei, mui amaraini danu damama ma saragari ue aika maika eno umane fare, mui arumaini danu danua ma saragari ue aika maika eno umane fare, mui awetaini danu dainau ma saragari ue aika maika eno umane farea wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Enoba duburo nanu gaukara ueta amaranu wasai uwarana dawaini su demurai uwara idoni wei ");
INSERT INTO yrb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Anama danua damamaba neno arama derawere utasute Naba neno arama kikiratu utasuna dawa kobererau meba Nanu amara da sibisu. Anama danu aruma amaraba derawere neno arama utasute Naba neno arama kikiratu utasuna dawa kobererau meba Nanu amara da sibisu. ");
INSERT INTO yrb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Anama danu unu da ekodifite kobere ueta korosi ari da woufisuna dana kobere amara meba Nanu amara da sibisu. ");
INSERT INTO yrb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Anama ewa orofaro merau ibifie ufisuna dawa daido uifisu. Nono anama Naba uifisuna dawa dubu kowaro ibene ibene me ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Anama ya mubisuna dawa Na mubisu. Anama Na mubisuna dana Na siaia ui Godi mubisu. ");
INSERT INTO yrb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Anama Godinu we bou ueta uwaranu sina naufisu, dana i uwara, Godinu we bou ueta uwaraba iba naufisuna Godima i we bou ueta uwaranu kobererau moko maeta enanari dawabai mafisu. Anama mui kobere amaranu sina naufisu, dana i amara, kobere amaraba iba naufisuna Godima i kobere amaranu moko maeta enanari dawabai mafisu. ");
INSERT INTO yrb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Anama Nanu iwata ueta amakanu nodo raraka ufie ogoratu mafisuna dana Nanu amaraba Godima i ogo maeta amaraba moko derawere mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuma Danu iwata ueta uwara tuero (12) emaba we mawetu ue me sinite ani. Anite i Ju uwaranu natofo su suro we mawetu utebi. ");
INSERT INTO yrb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Jonima diburaro ibina Yesunu sina weitaro nauite danu iwata ueta uwara Yesu Kerisobai siaia uiro anitate weita, Ana yanu yawotaisi Amara aba mui amarama fafiro efeisi weita? ");
INSERT INTO yrb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Weitaro Yesuma wei, oweawete Jonibai aniawete yanu awona eretaini nauetaini nesia dawaba eno wiawe, i diti basugari uwarana eraitaro i buri bebeu uwara rorowarau inaraitaro i buri age amaima uwara wirotaitaro ofe kobererau ue ibinita, ome gogore nautawa uwara nautaitaro uieta uwara uietaroma uyaraitaro aramawere me ibeta uwara Godinu kotofu sina nautaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Enoba anama Naba iwawa da ufisuna Godima dawa ma kobererau ufiro yaru derawere ufisu. Eno ane Jonibai wiawe Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","I uwarama Yesu ekoitate anita. Anitaro Yesuma i guruguru ubita uwaraba Joninu sina eno wei, i eme ibawa orofaro ane efoe anita? Oyauma oua ma wawana wawana utasuna i amara buna me, oua ari, efoe anita? ");
INSERT INTO yrb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ane efoe anita? Wadia dawana derawere bobo amara efoe anita? I wadia dawana derawere uwarana dera yawoeta uwaranu suro ibinita. ");
INSERT INTO yrb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aneba iro anita? Godinu we bou ueta amara efoe anita? Nanu sina nauawe. Dawa otowaratu we bou ueta amara me. Dawana dera we bou ueta amarawere. ");
INSERT INTO yrb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Godinu bukaro sinama dawaba eno wasu, ea, Nanu fo weta amara botai dawa ko sia umaro anibite Anu daba wabue moya ufiro A duburo anibasu ea, i sinama eno wasua wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Weite wei, Nanu ba sina nauawe. I awetabonu munaita adarabu nesiabai Joni babataito waita amara dawana derawere i uwarana kikiratu. Enorogo nono Godinu yawotasu orofaro ibinita otowaratu uwarana derawerero Jonina kikiratu. ");
INSERT INTO yrb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Joni babataito amaranu kowaroma are awona Godinu yawotasu sina bunawere webaisi. Eno webaisiba emema Godinu yawotasu orofaro anibitae uteda buna derawere utaita. ");
INSERT INTO yrb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Godinu we bou ueta uwaraini Mosesinu tarawatuini emana Godinu yawoeta sina we bou utaro Joni ido fari. ");
INSERT INTO yrb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Idoba yanu unu i sina imufoe ufoitana Joni dawana Iraija ido fari. ");
INSERT INTO yrb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ana anama ome bobona ewa sina nauawe Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Weite Yesuma nono wei, ewa ibinita uwara abo uwara ari? Ewa uwara ane ari wemau? Ewa uwarana koiniboro ari watane. Koiniboroma su abanaro yauraitate emanu domayamutuba waita, buma uraisiro ya yaura urawa utaita. Ya neno arama sorara utaisiro nono ya sorara utawa utaita. ");
INSERT INTO yrb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Joni babataito amarama farite ietaini ogoini itawa utebiba yana weita, dawa seitaninu mui siosa imumu bobo amara weita. ");
INSERT INTO yrb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nono i Ba Eme Sini Amarama farite buredini wainini itasuro yana eno meo waita, Dawa iteba gabariwere amara, waini itasuro beforo siosa utasu amara. Dana takesi muneta uwaraini neno neno ueta uwaranu domaya waitana Godinu imueta Godinu uwara imufitaitana Dawaini Danu imueta daido ba, i eraita uwarama eno imufitaita, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesuma buna ueta faiyawere moana natofo suro utebiro i su uwarama erebitate emanu neno neno ueta dubena afu sanawa utebita. ");
INSERT INTO yrb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Enoba Yesuma dua sina emaba wei, ya Korasini su uwaraini Besaida su uwaraini eforo! Godinu buna ueta faiyawere ya erebitaba i Taira su uwaraini Saidoni su uwaraini ina efitarona aramawere wadia barufitate konua kofiri deiro odeda emanu ba me ueta ekodifitae wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Godinu koto kowa fafiro Godima i Taira su uwaraini Saidoni su uwaraini fanisi kikiratu mafite ya Korasini su uwaraini ya Besaida su uwaraini fanisi derawere mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yesuma nono wei, ya Kafenamu su uwara, urero manibene waita? Iro da manibote uitawa inaro aniboita wei. Godinu buna ueta faiyawere erebitaba i Sodomu su uwarama ina efitarona emanu su awona ibifie wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Godinu koto kowa fafiro Godima i Sodomu su uwara fanisi kikiratu mafite ya fanisi derawere mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","I kowaro Yesuma eno wei, Baba, Ana ureini nasinini yawotasu. Ana Anu imueta nesia i orofa atata iwata derawere uwarabai ma fearasute i koiniboro ari uwarabai ma borobarasuro iba we ma kobererau utatane. ");
INSERT INTO yrb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","27","Ina Anu kobere imueta iba eno utasu Yesuma wei. Weite Danu iwata ueta uwaraba wei, Nanu Babama Danu imueta nesia Naba matasuro enanari utatane. Emema Nanu Babanu Amara anaiya iwawa utaitaro Godi torowana Danu Amara Dawa iwata utasu. Enanari Godi iwawa utaitaro Godinu Amarama Godi iwata utasute anabai Godi ma borobarasuro emana Godi iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ya gaukara derawere utaitate urumuwere ego wouraita uwara ari, uwara ya Nabai arawero yaba imoieta mamaro imoiteda merau ibiawe. ");
INSERT INTO yrb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nanu tobo ana ari wouawete Nanu imueta ue iwata uawe. Nanu nenona ure nudarau Na awe meba Nabai yanu neno ure nudarau ufote imoifoita. ");
INSERT INTO yrb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nanu tobo anana urumu me. Nanu egoini urumu meba yanu neno kobererau imoifoita, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mui sabate kowaro Yesuini Danu iwata ueta uwaraini feame waiyaro inarebita. Waiyaro inarebe Danu iwata ueta uwara osi uriba feame ma gogorugari utate agema burau ureda ie inarebita. ");
INSERT INTO yrb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Eno utebitaro Ferosi uwarama etate Yesuba weita, yanu tarawatuma wasu, sabate kowaro eno da uawe wasude Anu iwata ueta uwarade aneba eno utaita ea weita. ");
INSERT INTO yrb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Weitaro Yesuma emaba wei, Deiwidinu osi uriba ieta munebi ikiki yawitaita aba me? ");
INSERT INTO yrb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deiwidima osi uriba Godinu suro amuite weiro dera fuyo ode sina weta amarama Godima erebi kakarawere buredi mairo Deiwidini danu domayamutuini mutate ita. I buredina kakarawere. I dera dubu su yawoeta uwara torowama itebita, Godinu tarawatuba. ");
INSERT INTO yrb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Godinu tarawatu bukaro dera fuyo ode sina weta uwarama Godinu sabate kowa ma siosa utebita sina ibinuro ina yawitaita aba me wei? I uwarama Godinu sabate kowa ma siosa uteda enanari Godinu tarawatu ma siosa utebitana nono Godima emabai kerere odawa ui wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Idoro Na yabai ibine amarana derawerero yanu dera dubu suna otowaratu wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Godima eno wasu, Nanu ununa yanu neno arama ueta. Na unutawa yanu fuyo oeta. I sina iwata uforona i kerere me uwara wawei da weboe wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","I Ba Eme Sini Amara Dawana i sabate kowanu ubi amara. Dana i kowa yawotasu, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuma iroma anite Ju uwaranu dubu suro amui. ");
INSERT INTO yrb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Amuina age arama amarama ido yaubiro eri. Eriro moana uwarama Yesu meo wawei sina webitae Dawaba weita, sabate kowaro ma wiroetana kobererau aba me weita? ");
INSERT INTO yrb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Weitaro Yesuma emaba wei, yanu moana egi sabate kowaro sakai uri yafa derawere ubarero itafitaro ma youforo amufitaita aba me wei? ");
INSERT INTO yrb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yana egi imutaitate nono eme imuegou utawa utaita wei? Enoba sabate kowaro kobererau uetana ido aba me wei? ");
INSERT INTO yrb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Eno weite i age arama demurai amaraba wei, anu age sa weiro enanari uiro danu age wiroite mui age ari ui. ");
INSERT INTO yrb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Eno uiro i Ferosi uwarama wawaro itatate Dawa anene ufete ma uifeisi weda we matanebita. ");
INSERT INTO yrb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Yesuma emanu imueta iwata uiba ema ekodite iroma ani. Anina uwara faiyawere Danu buribi anitaro ema nesia ma wiroite emaba wei, moana uwarabai Nana ya ma wiroeta sina da wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Godinu we bou ueta amara Isaiyama weiba iba eno ui. Isaiyama eno wei, ");
INSERT INTO yrb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nanu we mune odine gaukara amara eawe. Dawa Nanu Amara ubiba Nanu neno Dawabai ibinu. Nanu Imumu Kotofuma Dawabai odimaro Dawa i Ju me aika uwaranu ueta sineta ma rorowarau ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dawa urane yarane da ufite dua sina derawere da webisu. Uwarama Danu wate tanana su abanaro da naufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dawa tafu ubeta oua da ma furiafisu, i buna me uwarana tafu ubeta oua ari. I uwaraba da ma siosa ufisu. Dawa nanefa uiki yareta da ma uifisu. I buna me uwarana nanefa uiki ari. I uwaraba da ma siosa ufisu. Dana nesia rorowarau ere webite kobererau ufiro i kobere uetama ueta nesia serigari ufite ibeibisu. ");
INSERT INTO yrb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","I Ju me aika uwarama Danu ifu naufitate Dawa naue imuegou ufitae Dawa yawoegou ufitaita, Isaiyama eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Moana uwarama diti basugari sina wiawa seitaninu mui siosa imumuma rewoeta bobo amara Dawabai woure oitaro Yesuma dawa ma wiroiro i amara sina wate weda danu diti kobererau siniro eri. ");
INSERT INTO yrb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","I uwara nesia neno kirifu utate weita, ewa amarana Godinu ma wiroe mune aneta amara aba me weita? ");
INSERT INTO yrb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","I Ferosi uwarama ina nautate weita, ewa amarama i botai siosa imumu Biesabonu bunaro torowa seitaninu siosa imumu we yowerasu weita. ");
INSERT INTO yrb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesuma emanu imueta iwata uite emaba wei, mui gaemani uwara emanu aika uraneda saragari ufitaitana arama ufitaita. Mui natofo su uwara emanu aika uraneda saragari ufitate aika maika da inafitaita. Su demurai uwara emanu aika uraneda saragari ufitaitana aika maika da inafitaita. ");
INSERT INTO yrb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Seitanima danu moana uwara we yowere sabisuna danu torowa sanono ufisu. Eno ufisuna danu torowa ma saragari ufiro danu yawoeta buna ureifisu. ");
INSERT INTO yrb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na Biesabonu bunaroma seitaninu siosa imumu we beratanena yanu uwarama seitaninu siosa imumu ananu bunaroma we berataita wei? Ibago i uwarama ya koto ufitate ya meo waita webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nono Godinu Imumu Kotofunu bunaroma seitaninu siosa imumu we beratanena Godinu yawoeta yabai ma boroyarasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mui amarama buna amaranu ibaiabai waira ufie uteda anene ufisu? Dawa i buna amaranu buri age ko botai uwane tarifite nono duburo danu ibaiabai waira ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Enanari anama Naini arotorowa fira fara utawa utasuna dawana Naini wasai utasu, enanari anama Naini arotorowa fira fara utawa utasuna dawana eme yowerasu Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Godima uwaranu neno neno uetaini siosa sina weta nesia mubite imutawa ufisu. Anama Godinu Imumu Kotofuba siosa sina webisuna Godima i siosa da mubite imutawa ufiro danu siosa ueta i amarabai daido ibeibisu. ");
INSERT INTO yrb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Anama i Ba Eme Sini Amaraba siosa sina webisuna ina mubite imutawa ufisu. Anama Godinu Imumu Kotofuba siosa sina webisuna ina da mubite imutawa ufiro i siosana dawabai ibene ibene ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kobere ana warafisuna kobere tai uwafisu. Siosa ana warafisuna siosa tai uwafisu. Mui ana kobere tai uwafisuna ina kobere ana webitaita. Mui ana siosa tai uwafisuna ina siosa ana webitaita. Ane uwafisu enanari webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ya towinu muneta! Yana siosawereba anene kobererau weboita wei? Mui amaranu neno ubarero i imuetama wate farinuba iba wasu. ");
INSERT INTO yrb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","I kobere amarana danu kobere nenoroma kobererau utasu. I siosa amarana danu siosa nenoroma siosawere utasu. ");
INSERT INTO yrb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Yaba ba watane. Godinu koto kowa fafiro Godima uwaranu me sara sina nesia wenauefisu wei. I kowaro yanu kotofurau sinaba Godima yaba kotofurau ufisu. I kowaro yanu siosawere sinaba Godima yaba siosawere ufisu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Moana tarawatu tisa uwaraini Ferosi uwaraini Yesuba weita, Tisa, buna ueta uaro efe weita. ");
INSERT INTO yrb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Weitaro wei, ewa siosawere ue Godinu sina nautawa uwarama buna ereta doberaita. Nono Jonanu buna ereta ma boroyariba yaba mui aika buna ereta da ufite nono i Jonanu buna ari da ma boroyafisu. ");
INSERT INTO yrb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonama dera erio eginu desini ubarero kowa rarogonu dumu rarogonu ibiba enanari i Ba Eme Sini Amarama nasini ubarero kowa rarogonu dumu rarogonu ibifisu. ");
INSERT INTO yrb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","I Niniwe su uwarama Godinu koto kowaro uyafitate ewa uwara wawei webitate do mafitaita. I uwarama Jonanu sina nautate emanu neno neno uetaroma dubena sata. Jonana dera amara me. Awonana yabai dera amarawere ibinuro ekodaitaba iba i Niniwe su uwarama ya wawei webitaita. ");
INSERT INTO yrb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Godinu koto kowa fafiro Siba orofanu yawoeta aweta, emanu kuini, uyafite ewa uwara wawei webite do mafisu. Boderewere dana orofa emiroma Soromoninu bunawere we mawetu ueta sina naufie fari. Soromonina dera amara me. Awonana yabai dera amarawere ibinuba i kowaro i awetama uyafite ya wawei webisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","Seitaninu mui siosa imumuma mui amara ekodasute yao orofaro ane imoifie dobere inarebasu. Doberebe doberebe dawa imoitawa utasuba eno wasu, nanu ekodine suro owemate animau wasu. Eno wasute i seitaninu mui siosa imumuma owere ane farasute erasuna i amara yawewe aitasuro su ubarero wawawere kobererau ibasuba siosa imumuma anasute seitaninu moana siosa imumu seweni (7) dawa ari me, ina siosawere, mune woure farasu. I nesia dawaini faraitate amutaitate ido ibaita. Enoba i amaranu bodere ibetana kikiratu ba me. Nono awonana siosa imumu faiyawere dawabai rewoe ibaitaba danu ibetana ba mewere. Enoba ewaro ibinita siosa uwaranu ibeta enanari ufisu, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuma sina webina Danu danuaini daburetaini atate Yesuba sina webitae inaibita. ");
INSERT INTO yrb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ido inaibitaro mui amarama Yesubai wei, Anu anuaini Anu abuemutuini emana aba sina webitae ewado are inaibinita wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Weiro Yesuma dawaba wei, Nanu bayaini nabuemutude anaiya wei? ");
INSERT INTO yrb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Weite Danu age Danu iwata ueta uwaraba fisu uteda wei, ewa Nabai nautaita uwarana Nanu bayaini nabuemutuini ido wei. ");
INSERT INTO yrb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ana anama Nanu urero ibinu Baba Godinu sina nautaitate enanari utaitana emana Nanu nabuemutuini arumaini baya ari wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","I kowaro Yesuma i suroma wawaro itarite enea gigirariro anite yauri. ");
INSERT INTO yrb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iro yaubiro uwara faiyawere Dawa inare kara utaba Yesuma uyarite bouti ubarero amui. Bouti ubarero amo yauriro i uwarama maguaro inata. ");
INSERT INTO yrb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesuma kasei sinaroma emaba faiyawere we mawetu uteda eno wei, mui amarama yo waifie waiyaro ani. ");
INSERT INTO yrb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ane yo sane inarebina moana yo dabaro itata. Dabaro itataro gasirama fatate ita. ");
INSERT INTO yrb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Moana yo gebirowere nasiniro itataro i nasini awewewereba yo sau warata. ");
INSERT INTO yrb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nasini awewewerero yo sau waratate kowama yanairo ini fuyaratuba yoie yoie uta. ");
INSERT INTO yrb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Moana yo sinisini bobo ruru ubarero itatate waratate orobuwereba tai uwanawa. ");
INSERT INTO yrb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","9","Moana yo kobere nasiniro itatate waraegou utate tai faiyawere uwata. Tai demurairoma tai wani aderedi (100) uwani. Mui tai demurairoma tai sikisiti (60) uwani. Mui tai demurairoma tai toti (30) uwani weite wei, ya ome bobo uwarana Nanu sina nauegou uawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesuma i sina we me siniro Danu iwata ueta uwarama Yesubai fatate weita, aneba emaba kasei sinaroma wasu weita? ");
INSERT INTO yrb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Weitaro Yesuma emaba wei, Godinu ununa ya Danu ure yawoeta kiwu sina naufote iwata ufoe utasute nono Dawa unutawa i uwara Danu ure yawoeta kiwu sina nauetaba iba emaba kasei sina torowaroma ma borobarasuro nautaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nanu sina naueta derawere bobo uwaraba mui naueta mafite nono i deramiratu nautaita uwaranu kikiratu naueta ma dare mubisu. ");
INSERT INTO yrb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Enoba emaba kasei sinaroma watane. Iba i uwarama eraitate bana erawa. Nauetana nautaitate i sinanu ubina iwawa utaita. ");
INSERT INTO yrb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaiyama bodere weiba iba enanari uta. Isaiyama eno wei, yanu ido nauegou ufote i sinanu ubina iwawa ufoita. Yanu ido eregou ufote ba ubina da efoita. ");
INSERT INTO yrb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ewa uwaranu nenona imuegou utawa. Emanu omena nautawa utaita. Emanu ditina nautama diti bumu utasuro aibitae utaita. Enoba erawa utaitate nautawa utaitate nenoma iwawa utaitate Nabai owerawa utaitaba ema ma wirotawa utatane. Eno da ufitarona ema ma wiromane, Isaiyama eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesuma i sina weite emaba wei, yana eregou utaitate nauegou utaitaba Godima ya ma kobererau utasuro kobererau ibinita wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yesuma wei, yaba ba sina wemaro nauawe wei, Godinu we bou ueta uwaraini Danu kobere uwara faiyawere yanu ane ane eraita efitae weitate erawa uta. Emanu ununa yanu ane ane nautaita naufitae utate nautawa uta, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","I yo sane inarasu amara sinanu ubi ewado nauegou uawe, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","I ubina eno, anama Godinu yawotasu sina nauteda iwawa utasuna seitanima farasute i sina i amaranu neno ubareroma ma dare munasu. Ina i dabaro itata yo ari. ");
INSERT INTO yrb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Anama Godinu sina nauteda yaru utasute danu nauetana derawere me, fuyaratu i yo ini ari, iba moana kowaro nautasuro Godinu sinaba awe uyareta farasuro i amarama Godinu sina sau ekodasu. Ina i gebiro duboro itata yo ari. ");
INSERT INTO yrb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Anama Godinu sina nauteda danu ununa aika maika imueta danu ununa ibaiabai derawere munasuba i sinanu daba garari utasuro i sina tai uwanawa utasu. Ina i ruru ubarero itata yo ari. ");
INSERT INTO yrb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Anama Godinu sina nauteda iwata utasuba dawa Godinu gaukara utasu. Mui amarama Godinu gaukara derawere utasu yawietana wani aderedi (100) ari utasu. Mui amarama Godinu gaukara deranono utasu yawietana sikisiti (60) ari utasu. Mui amarama Godinu gaukara kikiratu utasu yawietana toti (30) ari utasu, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuma emaba mui kasei sina eno wei, Godinu yawotasu kowa ewa sina ari. Mui amarama kobere uiti tai danu waiyaro waite ani. ");
INSERT INTO yrb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nono dumuro eme nauta ainibitaba mui wasai amarama farite uru tai i kobere uiti taibai waite ani. ");
INSERT INTO yrb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Duburo i uiti waratana i uruini warata. ");
INSERT INTO yrb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Enoba i gaukara uwarama su ubi amarabai fatate weita, dera amara, ana kobere tai wai aba me? Nono anene uru faiyawere waratasu weita? ");
INSERT INTO yrb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Weitaro wei, mui amarama naba wasai uite iba eno ui wei. Weiro i gaukara uwarama dawaba weita, i uru ma rerefeisi aba me weita? ");
INSERT INTO yrb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Weitaro wei, me, da ma rerefoita. Eno ufoitana moana uitini ma rerefoitoba ekodiawero uitini uruini uruama warafitate ayo ufitaitana i uiti muneta uwaraba eno wemau, i uru botai ma rereawete inaro yafoe utedana tobo uawe. Tobo uawete nono duburo i ba uiti ma rereawete nanu ieta oeta suro odiawe wemau wei. Yesuma i kasei sina eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuma mui kasei sina emaba eno wei, Godinu ure yawotasuna masita ana tai ari. Mui amarama i tai munite danu waiyaro wai. ");
INSERT INTO yrb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","I taina mui derawere ana tai ari me. I taina kikimusikiratu. Ina waratasute ana derawere utasuro i gasirama emanu mowa i ana iwararo utebaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesuma emaba mui kasei sina eno wei, Godinu urereo yawotasuna ewa sina ari, mui awetama wawareta ira yisitiratu munite dera faraua ubarero odiro yisitima i faraua nesia ma foai wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuma ewa sina nesia kasei sinaroma i guruguru ubita uwaraba wei. Wawuriro wiawa, kasei sinaroma torowa webi. ");
INSERT INTO yrb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Godinu we bou ueta amara Isaiyama bodere weiba iba Yesuma enanari wei. Isaiyama eno wei, nana kasei sinaroma wemau. I nasini tutubari ui kowaroma feareta sina we ma boroyamau, Isaiyama eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuma boutiroma itarite guruguru ubita uwara ido ekodite suro amui. Suro amuiro Danu iwata ueta uwarama Dawabai fatate weita, i waiyaro uru warataita sinanu ubi we ma boroyaro iwata ufe weita. ");
INSERT INTO yrb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Weitaro wei, i kobere tai waitasu amarana i Ba Eme Sini Amara. ");
INSERT INTO yrb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","I waiyana ewa orofa atata. I kobere taina Godinu yawotasu orofaro aneta uwara. I siosa taina seitaninu uwara. ");
INSERT INTO yrb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","I siosa tai waitasu wasai amarana seitani. I ayo ureta kowana ewa orofa atatanu me sibisu kowa. I muneta uwarana Godinu aneru. ");
INSERT INTO yrb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","I uru mune inama yaraita i ari i me sibisu kowaro enanari ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","I Ba Eme Sini Amarama Danu aneru siaia ufiro tarafitate Danu orofaro i siosa ue ereta uwaraini i siosa uwaraini nesia mubitate i uitawa inaro sabitaro iro anibitaita emema emanu nio bijari uteda i webitaita. ");
INSERT INTO yrb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","I kowaro Godinu sina nautaita uwara, i kobere uwarama Godinu yawotasu orofaro kowa ario ari ario ufitaita. I ome bobo uwarana nauegou uawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesuma wei, Godinu ure yawotasu ewa sina ari. Mui amarama mui waiyaro feare oitaro ibi i oi derawere daurite eri. I oi daure erite nono sakaima ma tafure odite ani. Suro ane farite danu ibaiabai nesia oiya ue maite oi munite nono i nasini oiya ui wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Godinu ure yawotasu ewa sina ari, mui sitowa amarama oi gebiro, danu ifuna fera agewa ari dobere ani. ");
INSERT INTO yrb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Doberebe doberebe kobere fera agewa danu dawana derawere atani. Ido atanite ane danu ibaiabai nesia oiya ue maite oi munite owerite i fera agewa oiya ui wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","Godinu ure yawotasu ewa sina ari. Moana uwarama emanu iwame enea ubarero satate erio egi aika maika nesia mutaro iwame wate fariba i uwarama duero ma youtaro amui. Duero amuiro i uwarama yautate i kobere erio egi bosioro youtate i siosawere erio egi mu sata. ");
INSERT INTO yrb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Ewa orofa atata dubu kowa me sibiro enanari ufisu. Godinu aneruma enanari ufitaita. Godinu aneruma tarafitate i siosawere uwara i kobere uwarabairoma mubitate uitawa inaro sabitaro iro anibitaita emema nio bijari uteda i webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesuma emaba wei, i watane sina nesia nautaita wei? Weina nautaisi weita. ");
INSERT INTO yrb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Weitaro Yesuma wei, Mosesinu tarawatu tisa amarama Godinu ure yawotasu sina ue iwata utasuna i ibaiabai, bodereini reka ibaiabai, ma borobarasu enanari Mosesinu tarawatu tisa amarama danu bodere imuetaini danu reka imuetaini we mawetu utasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuma i kasei sina we me sinite iroma ani. ");
INSERT INTO yrb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ane Danu orofaro farite i Ju uwaranu dubu suro we mawetu ui. We mawetu utebiro i uwarama neno kirifu utate weita, ewa amara Danu iwata derawere aboro muninute Danu buna ueta anene utasu? ");
INSERT INTO yrb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dawa etei su ma inareta amaranu amara aba me? Meride Danu danua aba me? Jeimisini Jousefaini Saimonini Judasini ema Danu dabureta aba me? ");
INSERT INTO yrb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Danu arumami yabai ibinita aba me? Ewa amarana anene dera amara? Danu iwata aboro muninu weita? ");
INSERT INTO yrb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eno weitate Dawaba ibo utaro Yesuma emaba wei, mui we bou ueta amaranu su uwaraini danu orofa uwarama dawa ititi kakara utawa utaitaro aika uwarama dawa ititi kakara utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I uwarama imutawa utaba emabai buna ueta utawa ui. ");
INSERT INTO yrb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Erodi, dana gaemani dera yawoeta amarama Yesunu buna ueta sina nauite danu gaukara uwaraba wei, i amarana Joni babataito amara. Dawa uietaroma uyariba iba i buna eno utasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Bodere Erodima Joni diburaro odi. Erodima danu dabue Firifinu aweta Erodiasi waira ue muni. ");
INSERT INTO yrb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Eno uiro Jonima dawaba wei, anu abuenu aweta muneta siosawereba kodia wei. ");
INSERT INTO yrb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Weiba Firifinu aweta Erodiasima ibo uite woroworo webiba Erodima Joni diburaro odite ma uifie wei. Weiro i uwara nesia Joni Godinu we bou ueta amara imutaba Erodima iyarite Joni ma uitawa ui. ");
INSERT INTO yrb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Duburo Erodinu danuama dawa muni kowa fariba ogaro derawere uiro uwara faiyawere ogaro ifitae fata. Ido fataro ogaro itebitana Erodiasinu aruma emabai yaura urebiba Erodima neno ubarero yaru ui. ");
INSERT INTO yrb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yaru uite i arumaba wei, nabai ane mubae webasuna ina aba mamau eno bunawere we bou ui. ");
INSERT INTO yrb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Eno weiro danu danuama weiba i arumama Erodiba wei, Joni babataito amaranu kofiri naberoro odiate mai wei. ");
INSERT INTO yrb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Eno weiro Erodi neno siosa ui. Nono dawa botai bunawere we bou uiba danu ogaro itebita uwarama nautaba Erodima danu wei enanari ui. ");
INSERT INTO yrb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Dana weiro danu uwarama dibura suro anitate Joninu nodo ture kofiri naberoro oita. ");
INSERT INTO yrb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Eno utate ane fatate i arumaba mataro i arumama munite ane danu danuaba mairo eri. ");
INSERT INTO yrb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Enoba Joninu iwata ueta uwarama diburaro fatate Joninu ofe mutate ane uri uta. Uri ue me sitaro Yesubai anitate Joninu uieta sina nesia weita. ");
INSERT INTO yrb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuma i sina ido nauite i orofa ekodite bouti ubarero amuite eme ibawa orofaro ani. Aniro uwara faiyawere nautate natofo su suroma duero Dawabai anita. ");
INSERT INTO yrb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Anitaro Yesuma etarafu farite maguaro inarite i uwara nesia ereda neno arama ui. Neno arama uiba emanu ofe woureta uwara ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dumu sinebiro Yesunu iwata ueta uwarama Dawabai fatate weita, ewa orofana eme ibawa orofa. Nono dumu siosoa sau wiaro i uwara nesia natofo su suro anibitate ieta oiya ufita weita. ");
INSERT INTO yrb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Weitaro Yesuma wei, aneba anibitaita? Emaba ieta mawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Weiro weita, yabai buredi faini (5) erio egi sadei torowa ibinu weita. ");
INSERT INTO yrb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Weitaro Yesuma wei, ina woure Nabai arawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Weite weiro i uwara nesia samarai deiro yauta. Yautaro Yesuma i buredi faini (5) erio egi sadeini munite urero ereda Godi we ma kobererau uite i buredi ma birabiarite Danu iwata ueta uwaraba mairo emana i guruguru ubita uwaraba nata nata uta. ");
INSERT INTO yrb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","I uwara nesia itaro dia uri. Ie me sitaro iwo muduna mutate bosioro youtaro bosio tuero (12) wate fata. ");
INSERT INTO yrb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Eme faiyawere fai tausani (5000) ieta itaro nono awetaboini koiniboroini ieta ita. ");
INSERT INTO yrb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesuma weiro Danu iwata ueta uwara ema ko boutiro amutate etarafu yofeta. Yoferebitana Yesuma i guruguru ubita uwaraba weiro anita. ");
INSERT INTO yrb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Anitaro Yesu Danu torowana guriguri ufie maidaniro mani. Manite dumu siniro Danu aika iro ibi. ");
INSERT INTO yrb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yesuma iro ibina i boutina ogo abanaro ane fari. Oyau fariro ufe uyariba etarafu anawa. ");
INSERT INTO yrb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Goso gigigiro Yesuma ogo deiro inarebe emabai ane fari. ");
INSERT INTO yrb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yesu farebina i iwata ueta uwarama Dawa etate iyareda arua derawere weitate weita, ina imumu weita. ");
INSERT INTO yrb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Weitana Yesuma emaba wei, neno kimu uawe. ewana Na, iya da uyawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Weiro Fitama wei, Dera Waria Amara, ina Ana wiaro ogo deiro Abai ama wei. ");
INSERT INTO yrb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Weiro Yesuma ara wei. Weina Fitama boutiroma itarite Yesubai ani. ");
INSERT INTO yrb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Anina oyau fariro ufe uyariro Fitama ereda iyarite ogoro inui. Inuteda derawere wei, Dera Waria Amara, na ma wiroa wei. ");
INSERT INTO yrb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Weiro Yesuma Fitanu agero sau munite wei, ana imueta kikiratu amara! Aneba imutawa usinu wei. ");
INSERT INTO yrb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Weiro bouti ubarero amusiro oyau ido me sini. ");
INSERT INTO yrb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Idoba i bouti ubarero yaubita uwarama Yesu guriguri uteda weita, Ana Godinu Amara weita. ");
INSERT INTO yrb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ogo etarafu yofetate Genesareta orofaro ane inata. ");
INSERT INTO yrb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ane inataro i orofa uwarama Yesu fari iwata utate emanu ofe woureta uwara Dawabai woure fare oita. ");
INSERT INTO yrb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Fare oitaro ofe woureta uwarama weita, Anu wadia fifi burifene waisi weita. Idoba ana anama Yesunu wadia fifiro buritana ido wirota. ");
INSERT INTO yrb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Moana Ferosi uwaraini tarawatu tisa uwaraini Jerusaremu suroma Yesubai ane fatate weita, Anu iwata ueta uwarama yanu baeta uwaranu ueta sina nautawa utaita. Ieta itaitana age urotawa utaita. Aneba eno utaita weita? ");
INSERT INTO yrb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Weitaro Yesuma emaba wei, yade, aneba yanu baeta sina nauegou utaitate nono Godinu tarawatu sina nautawa utaita? ");
INSERT INTO yrb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Godinu tarawatuma eno wasu, yanu yanua yamamanu sinaini uetaini munebeawete yawotebeawe. Anama danu danua damamaba sina siosawere webisuna dawa ure uiawe, Godinu tarawatuma eno wasu. ");
INSERT INTO yrb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Nono yana eno waita, mui amarama danu me maeta Godiba matasuba danu danua damamaba da mafisuba danu damama kakara da ufisuna ina ido waita. Eno utaitaba yanu baeta ma uyaraitate Godinu tarawatu sina abesanaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","8","Weite wei, ya meo meo ueta uwara! Bodere Isaiyama yaba ba we bou uteda wei, Godinu wei sina edono, ewa uwarana Naba bebeturoma waitate nenoma Na imutawa utaita. ");
INSERT INTO yrb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na guriguri me sara utaita. Emenu imuetana Godinu imueta eno we mawetu utaita, Isaiyama yaba eno weiya Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuma weiro i uwarama Dawabai fata. Fataro Yesuma wei, Nanu sina nauawete enanari ue iwata uawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ieta ane ane mui amaranu ubarero anibitaitana ima i amara da ma siosa ufitaita. Ane ane imuteda siosa neno ubareroma amufitaro bebetuma webisuna ima i amara ma siosa ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Danu iwata ueta uwarama Dawabai fatate weita, i Ferosi uwarama Anu sinaba dua uita weita. ");
INSERT INTO yrb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Weitaro Yesuma wei, Nanu urero Babanu waitawa ui yo nesia Dana ini bobo ma dorodafisu. ");
INSERT INTO yrb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","I uwaraba da imuawe. I uwarana diti basugari uwara ari, Godibai urero aneta daba iwawa utaita. I diti basugari bobo uwarama mui diti basugari bobo amaranu agero muneda woure anaitana ema nesia kawaro itaraita wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Fitama Yesuba wei, i kasei sinanu ubi wiaro naufe wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Weiro Yesuma wei, ya uwara imueta bobo meba ewa sina iwawa utaita? ");
INSERT INTO yrb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ina eno, ieta nesia mui amaranu desiniro anasute duburo wisi areta kabesiro farasu. ");
INSERT INTO yrb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nenoroma siosa ane ane imueta amutasuro bebetuma wasuba iba ina ima i amara ido ma siosa utasu. ");
INSERT INTO yrb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nenoroma siosa imueta faiyawere amutaita. Ma uieta imuetaini dita yagera fareta imuetaini waira ueta imuetaini meo wawei weta imuetaini eno amutaita. ");
INSERT INTO yrb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mui amaraba siosa sina weta imueta amutasu. I amutaita imuetama i amara ma siosa utaita. Yanu age urotawa utaitate ieta itaita baetana ina ima i amara ma siosa utawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesuma iroma anite Taira suini Saidoni suro ane fari. ");
INSERT INTO yrb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Iro ane fariro mui Keinani su awetama Dawabai farite derawere wei, Dera Waria Amara, naba neno arama ua. Mui seitaninu siosa imumuma nanu arumanu neno ubarero rewoe ibeda siosa utasuba Deiwidinu amara na durua ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Weiro Yesuma dawaba moko sina wiawa ui. Eno uiba Danu iwata ueta uwarama fatate weita, i aweta yabai derawere wasuba wiaro anibi weita. ");
INSERT INTO yrb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Weitaro wei, Godima Na i Isaraero uwarabai siaia ui. I uwarana feareta mamoe ari emabai torowa Na siaia ui wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Weiro i awetama fare Danu buri gigiraribai jegirari uteda wei, Dera Waria Amara, na durua ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Weiro Yesuma wei, i koiniboronu ieta mumate kuasiriba samauna ina ba me wei. I koiniborona Isaraero uwara ari i kuasirina Ju me aika uwara ari iba eno da umau wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Weiro i awetama wei, Dera Waria Amara, ba wasu. I kuasirima emanu ema yawoeta uwaranu ieta fufuno itarebasuro itaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Eno weiro Yesuma dawaba wei, aweta, anu imuetana derawere. Idoba anu ununa enanari ufisu wei. Weiro i awetanu aruma ido wiroi. ");
INSERT INTO yrb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuma iroma ani. Anedana Gareri mesau nioro inarebe iroma maidaniro mani. Mane farite yauri. ");
INSERT INTO yrb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","31","Mane yaubiro uwara faiyawere Dawabai mane fata. Emanu buri bebeu uwaraini buri age badami uwaraini diti basugari uwaraini sina wate wiawa uwaraini moana uwara faiyawere woure mane fatate Yesunu buri gigirariro oitaro Yesuma ema nesia ma wiroi. Eno uiro i sina wate wiawa uwara wate weitate i buri age badami uwarama buri age rorowarau ue fare anitate i buri bebeu uwarama buri rorowarau ue fare anitate i diti basugari uwarama ba eta. I uwara nesia eno utaro i guruguru ubita uwarama neno kirifu uteda i Isaraero uwaranu Godinu ifu we ma derawere uta. ");
INSERT INTO yrb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuma weiro Danu iwata ueta uwarama Dawabai fataro wei, ewa uwarana kowa rarogonu Nabai ibeda ieta itawa utaitaro emaba Na neno arama utatane. Ema ewadoroma odimaro dabaro anibitaitana osima uiotoba iba ema da siaia umau wei. ");
INSERT INTO yrb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Weiro Danu iwata ueta uwarama Dawaba weita, ewa yao orofade ieta aboro mubero i uwara nesia ifitaita weita? ");
INSERT INTO yrb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Weitaro Yesuma emaba wei, buredi aboabo yabai ibinu wei? Weiro buredi sewenini (7) erio egi ba torowaratu weita. ");
INSERT INTO yrb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","Weitaro wei, i uwara nasiniro we ma yauawe weite buredini erio egini munite Godibai we ma kobererau ui. We me sinite buredini erio egini ma birabiarite Danu iwata ueta uwaraba mairo mutate i guruguru ubita uwaraba mata. ");
INSERT INTO yrb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mataro i uwarama mune ie dia uta. Ie me sitaro ieta iwo muduna mutate bosioro youtaro bosio seweni (7) wate fata. ");
INSERT INTO yrb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Eme fo tausani (4,000) faiyawere itaro awetaboini koiniboroini ieta ita. ");
INSERT INTO yrb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuma ido weiro i guruguru ubita uwara nesia anita. I uwara ido anitaro Yesu bouti ubarero ido amuite boutiroma yofere Magadani orofaro ane fari. ");
INSERT INTO yrb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Moana Ferosi uwaraini Sadusi uwaraini Yesu ue efitae Dawabai fatate weita, buna ueta uaro urero ufiro efe weita. ");
INSERT INTO yrb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Weitaro Yesuma emaba wei, yawi sinebasuro gajigaji beatasu goso eraitate waidumu kowa inafisu waita. ");
INSERT INTO yrb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nono wai urasuro dubawaru goso eraitate awona obi mafisu waita wei. I urero goso ereta yana iwata uegou utaitate nono Godinu awona utasu ueta yana iwawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ewa siosawere ue Godinu sina nautawa utaita uwarama buna ereta efoe waitaro mui buna ereta yaba da mafiro Godima Jonabai ui i ueta torowa efoita wei. Eno weite ema ekodite ani. ");
INSERT INTO yrb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ogo etarafu yofere ane inatana Danu iwata ueta uwarama buredi imutawa utate munawa uta. ");
INSERT INTO yrb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ferosi uwaraini Sadusi uwaranu sinana wawareta ira yisiti ari. Sina kikiratu webitaitana derawere ufiro emema naufitaitaba eforo watane wei. ");
INSERT INTO yrb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Weiro Danu iwata ueta uwarama i sinanu ubi we mataneda weita, yana buredi munawa A iba eno wenu weita. ");
INSERT INTO yrb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Weitaro Yesuma emanu sina iwata uteda emaba wei, ya kikiratu naueta uwara. Aneba burediba sina we matanaita? ");
INSERT INTO yrb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Aneba iwawa utaita? Aubokona buredi fai ma birabiarero eme fai tausani (5,000) itaro bosaru bosio aboabo youta? Ina imutawa utaita? ");
INSERT INTO yrb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nono buredi seweni (7) ma birabiarero eme fo tausani (4,000) itaro bosaru bosio aboabo youta? ");
INSERT INTO yrb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ina imutawa utaita? Burediba wiawa unero aneba iwawa utaita? I Ferosi uwaraini Sadusi uwaranu wawareta ira yisiti eforo watane wei. ");
INSERT INTO yrb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Eno weiba Dawa i Ferosi uwaraini Sadusi uwaranu wawareta ira yisitiba wiawa uite Ferosi uwaraini Sadusi uwara emanu we mawetu uetaba weiro iwata uta. ");
INSERT INTO yrb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Duburo Yesuma Sesaria Firifai orofaro ane fari. Iro farite Danu iwata ueta uwaraba wei, ewa uwarama i Ba Eme Sini Amarana abo amara waita wei? ");
INSERT INTO yrb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Weiro weita, moana uwarama Dawana Joni babataito amara waita. Moana uwarama Dawana Iraija waita. Moana uwarama Dawana Jeremaia aba mui we bou ueta amara waita weita. ");
INSERT INTO yrb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Weitaro Yesuma emaba wei, yade, Naba anene waita wei? ");
INSERT INTO yrb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Weiro Saimoni Fitama wei, Ana Godinu Mesaia, Ana i me ibinu Godinu Amara wei. ");
INSERT INTO yrb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Weiro Yesuma wei, Saimoni Jonanu amara, Godima a we ma kobererau usinu. Mui amarama i moko sina aba wiawa usinuro Nanu urero ibinu Babama ina aba we ma boroyarinuro iba wenu wei. ");
INSERT INTO yrb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Fita Nanu sina naua. Ana Fita. Anu ifunu ubina gebiro. Nono i gebiro deiro Nanu sina naueta uwara odimaro i uietanu bunama ina da ma jugari ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","20","Aba i ure yawotasu orofa na widu ari mamaro ananu ueta ane ane uwane tarifaro dawabai ibifisu enanari urero uwane tarifiro dawabai ibifisu. Ananu ueta ane ane uregari ufate mune aika odifasu enanari urero uregari ufite mune aika odifisu wei. Yesuma eno weite nono bunawere wei, Nana Keriso i Mesaia, moana uwarabai eno da wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","I kowaroma Yesuma Danu iwata ueta uwaraba Danu ueta ufisu we mawetu ui. Dawa Jerusaremu suro anibiro i Ju uwaranu baeta uwaraini dera fuyo ode sina weta uwaraini tarawatu tisa uwaraini emana Dawa ure yanae ufitaro oferi derawere woufite uifite nono kowa rarogonu me sibiro Yesuma uietaroma ido uyafisu. Yesuma emaba eno we mawetu ui. ");
INSERT INTO yrb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Eno we mawetu uiro Fitama Yesu mune aika odite we kakara uteda wei, Dera Waria Amara, nanu ununa Godima i uwaranu ueta mune ekodifisuba Aba eno da ufitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Weiro Yesuma owerite Fitaba eno wei, seitani anu imuetama Nanu imueta garari ufie utasuba Nabairoma eta ania weite wei, ana Godinu imueta imutawa, emenu imueta imuteda iba eno wasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesuma Danu iwata ueta uwaraba wei, anama Nanu buribi afie ufisuna danu unu nesia ekodifite kobere ueta danu korosi ari mubite dawa uifie Nanu buribi afisu. ");
INSERT INTO yrb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Anama danu ewaro me ibeta yawoegou ufisuna ina feafiro Nabai ibene ibene da ibifisu. Anama danu me ibeta yawoegou utawa ufite Naba uifisuna dawa Nabai ibene ibene me ibeibisu. ");
INSERT INTO yrb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mui amarama ewa orofa atata ibaiabai nesia mubiro danu me ibeta imumu siosa kabesiro feafisuna ina kobererau me. Eno ufisuna danu imumu anene moko oiya ufisu wei? ");
INSERT INTO yrb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","I Ba Eme Sini Amaraini Danu aneruini ema Danu Damamanu bunaini araetaro fafisuna uwara nesia ane ane utaitaba emaba enanari moko mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yaba ba wemaro nauawe. Moana ewado inaibinita uwarama da uifitaro i Ba Eme Sini Amara Danu yawoeta orofaroma ido fafiro efitate nono uifitaita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kowa sikisi (6) me siniro Yesuma Fitaini Jeimisini danu dabue Jonini emanu aika munite dera maidaniro mani. ");
INSERT INTO yrb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iro mane farite emanu iboro Yesu Danu ofe aika ui. Danu ibo nawata kowa ario ari ario ui. Danu wadia goso ari inawere ui. ");
INSERT INTO yrb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Eno uiro Mosesini Iraijaini Yesubai ido me ari usite fare sina sina webisi. ");
INSERT INTO yrb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Enoba Fitama Yesuba wei, Dera Waria Amara yanu ewado ibinisina kobererau. Anu ununa nana moana kiki suraratu rarogonu umau. Anu mui, Mosesinu mui, Iraijanu mui, Anu ununa ina ubu umauna ubu umau wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Eno weina ariowere gosoma ema ma yariro gosoroma sina tararite wei, ewana Nanu Amara ubi. Nanu neno Dawabai ibinuba Danu sina nautebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Weiro iwata ueta uwarama i sina nautate nasiniro arubi uteda iya uyata. ");
INSERT INTO yrb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Eno utaro Yesuma emabai farite ema buriteda wei, uyawete iya da uyawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Weiro emanu diti foratana moana uwarana me. Yesu torowa inaibiro eta. ");
INSERT INTO yrb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Maidaniroma taratana Yesuma emaba bunawere wei, ewa tubetube erita imumu moana uwaraba da wiawero i Ba Eme Sini Amara uietaroma uyafisuna ido wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Weiro i iwata ueta uwarama weita, i tarawatu tisa uwarama Iraija dawa ko fafisu aneba eno webaita weita? ");
INSERT INTO yrb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Weitaro Yesuma wei, ba waita. Iraija dawa ko farite ibeda ane ane nesia ue bou bou utebi wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nanu sina wemaro nauawe. Iraija dawa fariro emana dawa iwawa utate dawaba siosawere uta. Enanari i Ba Eme Sini Amaraba siosawere ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Eno weiba Danu iwata ueta uwarama Dawa Joni babataito amaraba wasua we imuta. ");
INSERT INTO yrb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","I guruguru ubita uwarabai ta fataro mui amarama Yesubai farite jegirari uteda wei, Dera Waria Amara, nanu amaraba neno arama ua wei. Nanu amarama uieta ari utebasu. Moana kowaro inaini ogoro faiya faiyawere itarebasu. Enoba oferi derawere wourasu. ");
INSERT INTO yrb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nanu amara Anu iwata ueta uwarabai woure anero ma wirofitae uitana ma wirotawa uita wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Weiro Yesuma wei, ya imutawa jaja bujiji utaita uwara! Yabai kowa aboabo ibimaro Na naue imue ufoita wei? Eno weite wei, i amara ewaro Nabai woure ara weiro eno uta. ");
INSERT INTO yrb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesuma i seitaninu mui siosa imumuba sina bunawere weiro seitaninu mui siosa imumuma i amara ekodite aniro i amara ido wiroi. ");
INSERT INTO yrb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Duburo Danu iwata ueta uwara emanu aika Yesubai fatate weita, i seitaninu mui siosa imumu aneba we ma beratawa uisi weita? ");
INSERT INTO yrb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Weitaro Yesuma wei, yanu imueta kikiratuba iba we beratawa uita. Yaba ba wemaro nauawe. Yanu imuetana mui kikiratu masita ana tai arina etei maidaniba uyate etararo ania weboitana enanari ufisu wei. Anene webote kimuwere naue imue ufoitana enanari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nono guriguri ueta kowaro torowa ieta ka uteda Godibai guriguri ufoitana ewa siosa imumu ari we ma berafoita wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Duburo Gareri orofaro ibebitana Yesuma emaba wei, i Ba Eme Sini Amara mui uwaranu age duro odifitaro Dawa ufitaro uifiro kowa rarogonu me sibiro uietaroma nono uyafisu wei. Weiba Danu iwata ueta uwara neno siosa derawere uta. ");
INSERT INTO yrb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuini Danu uwara Kafenamu suro fata. Fataro i Ju uwaranu dubu su takesi muneta amarama Fitabai farite wei, anu tisa amarama i dubu su takesi oi sanasu aba me wei? ");
INSERT INTO yrb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Weiro Fitama wei, aiwia, Dawa sanasu wei. Duburo Fitama suro fariro Yesuma wei, Saimoni ane imutasu? I dera kini uwarama abo uwarabai takesi oi munaita? Emanu daburetabai aba moana uwarabai? Ane imutasu wei? ");
INSERT INTO yrb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Weiro Fitama wei, moana uwarabai wei. Weiro Yesuma wei, idoba i daburetana takesi oi sanawa utaitate me inaraita wei. ");
INSERT INTO yrb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nono i dubu su takesi muneta uwara yaba ibo da ufitaitana enearo aniate erio egi kimai ogo abanaro sa. Sate i botai erio egi muate danu bebeturo siriwa oi eate ina aini Naini wanu takesi oi. I oi ido mune i takesi muneta uwarabai ane ma wei. Yesuma eno weiro Fitama enanari ui. ");
INSERT INTO yrb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mui kowaro Yesunu iwata ueta uwarama Dawabai fatate weita, ure yawoeta orofaro yabaina abo amarama iro dera amara sibisu weita? ");
INSERT INTO yrb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Weitaro Yesuma weiro mui amakanu Dawabai woure fare oita. Woure fare oitaro Yesuma i amakanu munite emanu abanaro ma yaurite wei, yaba ba wemaro nauawe. Yana Godinu yawotasu koiniboronu imueta ari da muboitana ure yawoeta orofaro da aniboita. ");
INSERT INTO yrb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Anama ewa amakanunu imueta ari imuteda danu ifu da we ma derawere ufisuna dawa ure yawoeta orofaro botai dera amara sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Anama mui amakanu ewa amakanu ari Nanu ifuro ba durua ufisuna Naini durua ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nono anama Nanu sina naueta amakanuba ba me maosoro siosawere uosoba i ba me maeta amaranu nodoro gebiro derawere doifitate enearo sabitaro imuifirona ina kobererau Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ewa orofa atata uwarabai siosawere ue ereta faiyawere ibinuba siosawere utaita. Ba me ue ereta faiyawere fareibisu. Nono mui amarama mui amarabai ba me ue efisuna Godima dawa fanisi mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yanu mui buri agema ya ma siosa ufisuna i ya ma siosa ufisu buri age umane tuawete buri age demuraima ibifoitana ina kobererau. Buri age sadeima uitawa inaro ya sabitaitana ina siosawereba iba buri age umane tuawe. ");
INSERT INTO yrb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yanu mui ditima ya ma siosa ufisuna i diti torowa ma guju uawete mu sawete diti demuraima ibifoitana ina kobererau. Diti sadeima uitawa inaro ya sabitaitana ina siosawereba iba diti ma guju uawete diti demuraima ure orofaro aniboitana ina kobererau, diti sadei bobo uitawa inaro aniboitana siosawere wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Koiniboroba ewa amakanu ari emaba me sara nenoma ibo da uforo! Yaba ba wemaro nauawe. Emanu yawoeta aneruna urero Nanu Bababai ibinitaba iba emaba ibo da uforo wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Weite wei, i Ba Eme Sini Amarama i Godinu sina nautawa uwara ma wirofie iba ewaro fari wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ewa imue eawe! Mui amarama mamoe wani aderedi (100) boboro nono mamoe demurairatu feafisuna mamoe nainiti naini (99) maidaniro ekodifite i mamoe demurai dobere anibisu. Eno ufisu aba me? Aiwia eno ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Dawa ane doberebe doberebe i mamoe ido atafite neno wanai derawere ufite i nainiti naini (99) fearawa mamoe moanaba enanari yaru da ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Enanari yanu urero ibinu Baba Dawa unutawa ewa koiniboro ari uifitate uitawa inaro aneta wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Anu aiye aba siosawere ufisuna dawabai aniate dawa torowaba i siosa ueta wia. Eno wiaro naufisuna dawaini aini naiye webawaisi. ");
INSERT INTO yrb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Da naufisuna nono amara demurai aba amara sadei muate i amarabai nono owere aniawete i sina nono wiaro i amara sadei anu sina naufisite anu sinana ba imufisite i amaraba webisisi. ");
INSERT INTO yrb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Eno webisiro da naufisuna Godinu sina naueta uwara nesiabai i sina wiaro i uwarama dawaba webitaita. Eno webitaro da naufisuna Godinu sina naueta uwarama dawa ekodifitate dawa wawaro odifitaro i amarana aika amaraini takesi muneta amara ari imufoita wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yaba ba wemaro nauawe. Ananu ueta ane ane ewa nasiniro uwane tarifoitana urero enanari uwane tarifisu. Nono ananu ueta ane ane ewa nasiniro uregari ufote mune aika odifoitana urero enanari uregari ufite mune aika odifisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nono yaba ba wemaro nauawe. Yabai amara sadeima aba moana uwarama imueta daba demurai imuteda Godibai wenauefitaitana Nanu urero ibinu Babama ina emaba mafisu. ");
INSERT INTO yrb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nanu sina naueta uwara sadei aba rarogonu aboro aboro Nanu ifu weda ibeibitaitana iro emabai ibeimau wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Fitama Yesubai farite wei, Dera Waria Amara, nanu naiye naba aboabo siosawere ufiro mumate imutawa umau? Ba me nesia seweni (7) ufiro mumate imutawa umau wei? ");
INSERT INTO yrb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Weiro Yesuma dawaba wei, ba me nesia sewenina me. Ina da yawifasu. Danu ba me ueta faiya faiyawere muate imutawa ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Enoba Godinu ure yawotasuna ewa sina ari. Mui dera kini amarama danu dera gaukara uwaranu gaukaraini we muneta oini ma rorowarau ufie ui. ");
INSERT INTO yrb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eno utebina mui gaukara amarama dawabai fari. I amarama dera kinibai oi derawere teni mirioni kina (K10,000,00) munite nono moko matawa ui. ");
INSERT INTO yrb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dawabai oi meba moko da mafie weiba dera kinima wei, dawaini danu awetaini koiniboroini danu ibaiabai nesia oiya ue mateda oi muawete nesia naba maiwe wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Weiro i gaukara amarama dera kinibai jegirari uteda nui wei, dera amara yawoaro i oi nesia aba enanari mama wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Eno weiba dera kini i gaukara amaraba neno arama uteda i amarabai oi moko munawa uite ekodiro daido ani. ");
INSERT INTO yrb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","I gaukara amarama ane mui gaukara amara atani. Aubokona dubu atani gaukara amarama i botai gaukara amarabai oi tu tausani kina (K2000) we munite nono moko matawa ui. Enoba i botai gaukara amarama i mui amara atanite danu nodoro mamite wei, nanu oi moko mai wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Weiro i mui gaukara amarama jegirari uteda nui wei, yawoaro nesia moko mama wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Weiro i botai gaukara amara dawa unutawa yawoetaba weiro oi moko sau mafie mutate diburaro oita. ");
INSERT INTO yrb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","I botai amarama eno uiro moana gaukara uwarama i ueta etate neno siosa utate i dera kinibai anitate wawei weita. ");
INSERT INTO yrb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Weitaro dera kini amarama nauite weiro i botai amarama dawabai are fari. Are fariro dera kini amarama dawaba wei, a siosawere gaukara amara! Ana nabai nui weiro aba neno arama uete nesia mune imutawa ue wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Enorairo anu aiye aneba enanari neno arama utawa usinu wei. ");
INSERT INTO yrb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Weite ibo derawere uteda i amaranu moko oi nesia mafie iba i amara dibura yawoeta uwaranu age duro odi. ");
INSERT INTO yrb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Enoba yanu yaiyemutunu ba me ueta da mune imutawa ufoitana Nanu urero ibinu Baba Godima yanu ba me ueta da mune imutawa ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuma i sina nesia we me sinite Gareri orofa ekodite ani. Ane iroma Jodani ogo etarafu Judia orofaro fari. ");
INSERT INTO yrb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Uwara faiyawere Danu buribi anitate iro fataro ema ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","I Ferosi uwarama Yesubai ue efitae fatate woure ereda weita, mui amarama danu aweta me ekodifie ufisuna yanu tarawatu iba ane wasu weita? ");
INSERT INTO yrb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","6","Weitaro Yesuma wei, ewa sina yawita aba me? Godima awetaini awera ubu uite wei, idoro i amarama danu danua damama ekodifite danu awetabai taka ufiro emana sadeina merago demurai ari sibisisi Godima wei. I sina ya yawita aba me Yesuma wei? Weite nono wei, Godima eno uiba awetaini awera sadei ari me, emana demurai ari. Godima ema ma taka uiba mui amarama ema da ma darefisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Weiro weita, idorogo nono Mosesima aneba eno wei, mui amarama danu aweta ekodifie uteda ekoeta koto feifa danu awetaba mafite ekodifisu weiya weita? ");
INSERT INTO yrb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Eno weitaro Yesuma emaba wei, yanu neno kimuwereba iba Mosesima eno wei. I tutubari ui kowaroma ina eno utawa utebita. ");
INSERT INTO yrb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nono yaba watane, mui amaranu aweta uyare farawa ufiro nono i amarama i aweta me ekodifite mui aweta mubisuna dita yagera fafite danu botai awetaba siosa ufiro dana mui awera mubite uyare fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesuma eno weiro Danu iwata ueta uwarama weita, ina enoba mui amarama aweta munawa utasuna ina kobererau weita. ");
INSERT INTO yrb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Weitaro Yesuma wei, uwara nesia ewa sina da imufitaro Godima moana durua ufisuna imufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Moana uwara emanu danuamutuma ema eno mutaba aweta munawa utaita. Moana uwarama moana uwara kaiyama tutaba aweta munawa uta. Nono moana uwarama i ure yawotasu sina nauegou ufitae iba aweta munawa utaita. Anama ewa sina nauegou utasuna dawa enanari utasu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Moana uwarama emanu koiniboro Yesubai woure ane odifitaro Dana Danu age emanu kofiri deiro odifite guriguri ufie iba woure fata. Woure fataro i Danu iwata ueta uwarama emaba dua sina weita. ");
INSERT INTO yrb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Weitaba Yesuma emaba bunawere wei, i koiniboro Nabai afitae watane. I ure yawoeta orofana emanuba. Emanu Nabai areta daba garari da uforo wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Weite Danu age emanu kofiri deiro odite ema ekodite ani. ");
INSERT INTO yrb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mui amarama Yesubai farite wei, Tisa Amara, ane kobererau umate me ibene ibene ibimane wasu wei? ");
INSERT INTO yrb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Weiro Yesuma dawaba wei, ane kobererauba wenauerasu? Godi Danu torowana kobererau. Me ibene ibene ibifae ufasuna Godinu tarawatu sina nesia nauegou ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Weiro i amarama wei, abo sina wei? Weiro Yesuma wei, eme da ma uia, yagera da fa, waira da ua, wawei webasuna meo wawei da wia, anu anua amamaba uegou ua, anu aiyeba anu aika neno arama utasu enanari neno arama ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Eno weiro i reka amarama Yesuba wei, i wenu nesia utebatane, mui anene umau wei? ");
INSERT INTO yrb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Weiro Yesuma dawaba wei, anu ununa Godi ari kobererau sibae ufasuna aniate anu ibaiabai nesia oiya ue mate i oi nesia ibaiabai me uwaraba mate Nanu buribi ara wei. Eno ufasuna ana urero ibaiabai mubasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Weiro i reka amarama nauite dawabai ibaiabai faiyawereba neno siosa uteda Yesu ekodite ani. ");
INSERT INTO yrb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesuma Danu iwata ueta uwaraba wei, yaba ba wemaro nauawe. Ibaiabai derawere bobo amarama Godinu ure yawotasu dabaro anedana kimuwere anibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nono yaba watane, mui egi danu ifuna kemo, dawa mara ebaro fare anibisuna ina kimu me. Ibaiabai derawere bobo amaranu aneta dabana kimuwere wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Weiro Danu iwata ueta uwarama nautate neno kirifu derawere uteda weita, enoba anama wirofisu weita? ");
INSERT INTO yrb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Weitaro Yesuma ema ereda wei, emema eno da ufitaro Godima i nesia ufite Danu aika ema ma wirofisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Weiro Fitama moko wei, yanu ane ane nesia ekoisite Anu buribi araisia wei. Enoba ane mubeisi wei? ");
INSERT INTO yrb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Weiro Yesuma emaba wei, ba wemaro nauawe, i Ba Eme Sini Amarama i reka fafisu orofaro Danu kobere yawoeta yaureta deiro yaufisu. Yaubifiro yana Nanu buribi anaita uwarama mui yawoeta yaureta deiro yaufote i Isaraero uwaranu abua tuero (12) yawofoita wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Anama danu suini dataeini dabueini arumamini danuaini damamaini koiniboroini beataini Nanu ifuba ekodifisuna duburo mui faiya faiyawere mubite me ibene ibene me ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nono moana dera uwarana iro kikiratu sibitaita. Moana otowa uwarana iro derawere sibitaita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","I Godinu ure yawotasuna ewa sina ari. Mui su ubi amarama waikunaro uyarite moana uwara danu gureifi waiyaro gaukara ufitae gaukara mafie ani. ");
INSERT INTO yrb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ane farina dawaini i gaukara uwaraini oi sina we matatate ido weita. I uwarama mui kowaro gaukara ufitaro i waiya ubi amarama emaba siriwa oi demurai emaba moko mafie weita. Eno weitaba i waiya ubi amarama ema siaia uiro danu waiyaro anita. ");
INSERT INTO yrb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ane beata utebitaro kowa mane abanaro sinina i waiya ubi amara ido maketi ibi orofaro ane farite erina moana uwara waiya utawa me yaubitaro eri. ");
INSERT INTO yrb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eno erite emaba wei, nanu waiyaro aniawete gaukara uawero yanu moko fei ido mama wei. Weiro i uwara ido anita. ");
INSERT INTO yrb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kowa otoro mane inarite nono kowa osugari ue otoroma ane abanaro sinina nono anite enanari ui. ");
INSERT INTO yrb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yawi sinina nono anite erina moana uwara me inaibitaro erite wei, aneba ewa kowaro me inaibinita wei? ");
INSERT INTO yrb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Weiro weita, mui amarama gaukara yaba matawa usinuba me inaibinisi weita. Weitaro wei, yaini nanu waiyaro aniawete gaukara uawe wei. Weiro ido anita. ");
INSERT INTO yrb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kowa me siniro dumu sibie uiba waiya ubi amarama danu oi yawotebi amaraba wei, i gaukara uwara wiaro abai fafitaro i duburo waiyaro anita uwara emanu oi mafate nono i abanaro anita uwaraba mafate nono i botai anita uwaraba emanu oi duburo mafasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Eno weiro i oi yawotebi amarama weiro i kowa otoro anita uwara ido fata. Fataro emaba siriwa oi demurai amara demui demuiba eno matebi. ");
INSERT INTO yrb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Enoma enoma utebina i botai waiya ufitae anita uwarama fatate we imuta, ya oi derawere mubeisi we imutaro emaba siriwa oi demurai amara demui demuiba enanari matebi. ");
INSERT INTO yrb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Matebiro i botai uwarama waiya ubi amaraba kamena weitate weita, i duburo anita uwarama gaukara kikiratu uita. Ya botai anisi uwara waura warairoma ane yawiro kowa yarateda gaukara derawere uisiro nono emaini yaini moko fei arotorowa masinu weita. ");
INSERT INTO yrb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","14","Weitaro waiya ubi amarama emanu mui amaraba wei, naiye, aba siosawere utawa une. Botai oi sina we matanisite siriwa oi demurai yaini naini eno ufeisi weisiba anu oi ido muate ania. Nanu unu i dubu anita uwaraini ya botai anita uwara arotorowa maetaba iba eno mane wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ewa oina nanuba anene mamauna mamau. Ina ido aba me? Nanu kobererau uetaba ibo utasu, waiya ubi amarama eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Idoba i dubu uwarama iro botai sibitaro i botai uwarama iro dubu sibitaita, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Yesuini Danu iwata ueta uwaraini Jerusaremu suro anita. Anebitana Yesuma Danu iwata ueta uwara tuero (12) ema mune aika odite emaba wei, Jerusaremu suro anaisi eawe. Iro fafero i Ba Eme Sini Amara i dera fuyo ode sina weta uwaraini tarawatu tisa uwaranu age duro odifitaro Dawa uifie webitate i aika uwaranu age duro odifitaita. ");
INSERT INTO yrb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Odifitaro i aika uwarama Dawa iruteda domuma ufitate korosiro odifitaita. Dawa ido uifiro kowa rarogonu me sibiro nono uietaroma uyafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jebedinu awetama danu amara sadei mune Yesubai woure fari. Wo farite jegirari uteda danu ununa kobererau mubie iba eno ui. ");
INSERT INTO yrb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Eno uiro Yesuma wei, ane ufae wei? Weiro i awetama wei, wiaro Anu yawoeta orofaro anibasuna iro nanu mui amara Anu banibira age afuro yaufiro nanu mui amara Anu ewani age afuro yaufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Weiro Yesuma wei, yanu wenauereta ya iwata mero ya me sara waita. Nanu uraneta wakiki ogo ifawaisi aba me wei? Weina aiwia ifutu weisi. ");
INSERT INTO yrb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Weisiro Yesuma wei, ba waisi, Nanu imau uraneta wakiki ogo ifawaisi. Nono i yaureta kabesi sadei Nanu meba da wemaro da yaufawaisi. Godima i kabesi ue bou uiba Dana webiro yaufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Weiro i moana iwata ueta uwara teni (10) i sina nautate i amara sadeiba ibo uta. ");
INSERT INTO yrb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ibo utaro Yesuma weiro i iwata ueta uwara nesia Dawabai fata. Fataro Yesuma emaba wei, i aika uwaranu dera yawoeta uwarama emanu gaukara uwaraba kimuwere yawoteda emanu imueta emaba kimuwere odaita. Eno utaitana ina ya iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nono yabai eno da ufoita. Yabairoma anama dera amara sibisuna ya nesia durua ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Anama botai amara sibisuna dawa yanu sabua ueta amara sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Enanari i Ba Eme Sini Amara emema Dawaba durua da ufitaro emeba durua ufie iba ewaro fari. Dawa uifiro Danu wiroeta onono nasiniro itafiro nono Danu ononoma uwara faiyawere moko mae munono ari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jeriko suroma anita. Anitaro uwara faiyawere emanu buribi anita. ");
INSERT INTO yrb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Anebitana diti basugari amara sadei daba gigirariro yaubeda Yesu fare anebiro nausite derawere weisi, Dera Waria Amara, Deiwidinu sisia amara, waba neno arama ua weisi. ");
INSERT INTO yrb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Weisiro i guruguru ubita uwarama ibo uteda eno da wiawa weita. Weitana derawere weisi, Dera Waria Amara, Deiwidinu sisia amara, waba neno arama ua weisi. ");
INSERT INTO yrb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Weisiro Yesuma inarite wei, yaba ane umane waisi wei? ");
INSERT INTO yrb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Weiro weisi, Dera Waria Amara wanu ununa ditima ba efutu weisi. ");
INSERT INTO yrb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Weisiro Yesuma neno arama uteda emanu ditiro burina emanu diti forairo ido wirosite ereda Yesunu buribi anisi. ");
INSERT INTO yrb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Jerusaremu suro fafitae ureda mui su Oriwa Maidani gigiraribai ibi Betifeiji suro are fata. Fataro Yesuma Danu iwata ueta amara sadei siaia uite wei, etei kirisi weto suro aniawa. Ane fafawaisina mui donikini danu otowa natuini doie oitaro inaibinuba efawaisina ema ma uregari uawate woure Nabai arawa. ");
INSERT INTO yrb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eno uteibawaro mui amarama yaba ya ane utaisi webisuna yanu Dera Waria Amarama mubie wenu wiawaro yaba mafi wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Godinu we bou ueta amarama i sina bodere weiba iba Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","I we bou ueta amarama eno wei, I Saioni Orofa uwaraba wia, emanu Dera yawoeta amara emabai fafisu. Dawa dera amara ari da fafisu. Mui donikinu natu deiro yaufite fafisu wia, I we bou ueta amarama eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","I iwata ueta amara sadei ido anisite Yesunu wei sina enanari usi. ");
INSERT INTO yrb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","I amara sadei i donikini danu otowa natuini woure fasite emanu wadia otowa donikinu dubena deiro oisiro Yesuma ido deiro yauri. ");
INSERT INTO yrb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Uwara faiyawere emanu wadia dabaro sane oitaro moana uwara farai tata ture dabaro sane oita. ");
INSERT INTO yrb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Moana uwara ko botai anitaro Yesu abanaro aniro nono moana uwarama emanu buribi anebita. Eno utate i botai anebita uwaraini i dubu arebita uwara nesia derawere webita, Godima we mune odiro Deiwidibairoma sirorari ui amara Dawa kobererau. Dana Godinu ifuro ido farinu webita. Godima Dawa ma kobererau ufisu. Ure uwarama Danu ifu we ma derawere utaita. Enoma enoma derawere webita. ");
INSERT INTO yrb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Webitaro Yesuma Jerusaremu suro ido fari. Fariro i Jerusaremu uwarama neno wanai uteda weita, ewa amarana ana weita? ");
INSERT INTO yrb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Weitaro i dabaro anebita uwarama weita, ewa amarana Godinu we bou ueta amara. Dawana Gareri orofa Nasareta su amara weita. ");
INSERT INTO yrb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuma i dera dubu su ubarero amui. Amuite oiya ue maeta uwaraini oiya ueta uwaraini yoweriro wawaro anita. Yesuma i oi moko mae matata uwaranu kaiyoini fuyo oita ubani karaini oiya ue mata uwaranu yauretaini mu saniro dowata. ");
INSERT INTO yrb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yesuma eno uite wei, Godinu bukaroma eno wasu, Nanu suna emenu guriguri ueta su. Nono yana Nanu suna waira ueta uwaranu su ari uita wasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","I diti basugari uwaraini i buri bebeu uwaraini ema dera dubu suro Yesubai fataro ema ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","16","I dera fuyo ode sina weta uwaraini tarawatu tisa uwaraini Yesunu buna ueta etana i koiniboroma i dera dubu suro weroroka weda Godima we muni odiro Deiwidibairoma sirorari ui Amara Dawa kobererau weitaro nautate ibo utate Yesuba weita, i koiniboronu sina nautasu aba me weita? Weitana aiwia, nautatane wei. Weite wei, ewa sina yawita aba me? I sinana edono, i otowa koiniboroini ama itaita koiniboroini emanu Dera Amaranu ifu we ma derawere ue we ma kobererau utaita. Na iwata, i sina ya yawita wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Weite Yesu ema ekodite Jerusaremu suroma Beteni suro ane aini. ");
INSERT INTO yrb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wai uriro uyarite Jerusaremu suro owere anebe osi uri. ");
INSERT INTO yrb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Osi uriba ane erina mui boruba ana daba gigirariro inaibiro eri. Erite mune ifie ane farina boruba tai uwanawa me tata torowa ibitaro erite i boruba anaba wei, duburo mui tai da uwafasu wei. Weina boruba ana ido tata reora uite sibu uri. ");
INSERT INTO yrb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Eno uiro Danu iwata ueta uwarama etate neno kirifu utate weita, i boruba ana anene sau sibu urinu weita? ");
INSERT INTO yrb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Weitaro Yesuma emaba wei, yaba ba wemaro nauawe. Yana nauegou ufote imueta sadei sadei da ufoitana Nana i boruba taiba une i enanari ufote nono mui buna ueta ufoita. Etei maidaniba uyate enea ubarero ita weboitana yanu weboita enanari ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nauegou ufote imuegou uteda guriguri ufote aneba Godibai wenaueforo Godima yaba mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuma dera dubu su ubarero amuite we mawetu ui. We mawetu uina i dera fuyo ode sina weta uwaraini Ju uwaranu baeta uwaraini Yesubai fatate weita, ananu bunaro A eno utasu? Anama buna Aba mairo eno utasu weita? ");
INSERT INTO yrb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Weitaro Yesuma emaba wei, yaba Nanu wenauereta botai wemaro yana moko sina weboitana nono anama Naba buna masinuro eno utatane wemau wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Joninu babataito ueta, ina ureroma fari aba emebairoma fari wei? Weina sina we mataneda emanu aika weita ane webeisi? Ureroma fari webeisina Joni aneba nautawa uta webisu. ");
INSERT INTO yrb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nono emebairoma fari webeisina i uwara nesia Joni Godinu we bou ueta amara imutaitaba emema yaba ane ufitaita weita? ");
INSERT INTO yrb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Emanu aika eno weitate nono Yesuba weita, ya iwata me weita. Weitaro Yesuma wei, moko sina wiawa utaitaba idoba Nanu buna utatane sina yaba da wemau wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ewa sina imue eawe Yesuma wei. Mui amaranu amara sadei dawabai ibisi. Damamama danu botai amarabai anite wei, nanu gureifi tai waiyaro aniate gaukara ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Weiro botai amarama nauite da animau wei. Eno weite duburo danu imueta ma owereda waiyaro anite gaukara ui. ");
INSERT INTO yrb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Damamama nono dubu amarabai anite enanari wei. Weiro dubu amarama wei, na animau weirogo nono anawa ui. ");
INSERT INTO yrb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Abo amarama danu damamanu sina naui wei? Weina botai amarama weita. Weitaro Yesuma wei, yaba ba wemaro nauawe. I takesi muneta uwaraini emeba uyare fareta awetaini ema ko Godinu ure yawoeta orofaro anibitaro yana aniboita aba me Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Eno weite nono wei, Jonima farite Godinu kobere sina webina yana dawa nautawa utaro i takesi muneta uwaraini emeba uyare fareta awetaboini emana danu sina nauta. I uwarama eno utaro yana etate yanu ba me ueta dubena afu sanawaba danu sina nautawa uta Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mui kasei sina nauawe Yesuma wei. Mui amarama danu gureifi yo waiyaro waite dowa urite gureifi amune adidiarebita koru ubu uite danu waiya dobo uite danu waiya moana uwarama yawofitae maite mui orofaro ani. ");
INSERT INTO yrb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Duburo ayo ureta kowa ido fariro danu gaukara uwara i waiya yawoeta uwarabai gureifi moana mubitae ido siaia ui. ");
INSERT INTO yrb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Dawa mui amara siaia uiro ane fariro i amara isuma urebita. Nono dawa mui amara nono siaia uiro ane fariro i ani amara dawa ma uita. Dawa mui amara siaia uiro ane fariro gebiroma uta. ");
INSERT INTO yrb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nono dawa moana gaukara uwara faiyawere siaia utebiro ane farebitaro emaba enanari enoma enoma utebita. ");
INSERT INTO yrb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Duburo waiya ubi amarama wei, awonana nanu amara ubi siaia umaro dawaba kakara ufitaita wei. Weite danu amara ubi siaia uiro ani. ");
INSERT INTO yrb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ane fariro i uwarama dawa etate emanu aika weita, etei amarana danu amara ubiba dawa ma uifete danu waiya yana mubeisi weita. ");
INSERT INTO yrb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eno weitate i amara muneda waiya dowa dubenaro satate dawa ma uita Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Eno utaba i waiya ubi amarama fafite i waiya yawoeta uwaraba ane ufisu wei? ");
INSERT INTO yrb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Weiro weita, dawa i siosawere uwaraba kimuwere ufiro uifitaita. Eno ufite danu waiya ma dare moana yawoeta uwaraba mafiro ayo ureta kowa fafiro dawaba na didi tai mafitaita weita. ");
INSERT INTO yrb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Weitaro Yesuma emaba wei, ewa wemau sina Godinu bukaro yawita. I sinana edono, i su ubu ueta uwaranu mu sata gebirona i botai tutubu ari sini. Ewa yanu Godinu uetaba kamama eraisi. I sinana eno, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Idoba yaba watane, Godinu yawotasu orofa yabairoma ma darefite aika uwaraba mafiro i uwarama Godinu gaukara uegou ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Anama ewa gebiro deiro buridu ufite gebiro deiro ureifisuna danu torowa tai ure furufafisu wei. Weite wei, nono i gebiroma ananu deiro ureifisuna i gebiroma i amara ure ma musimusi ufiro daido i amara sakai ari sibisu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","I dera yawoeta uwaraini Ferosi uwaraini i kasei sina nauteda Dawa yaba wasu we imuta. ");
INSERT INTO yrb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eno we imutate Yesu budari ufitae weita. Weitaro i guruguru ubita uwarama Yesu Godinu we bou ueta amara imutaba dera fuyo ode sina weta uwaraini Ferosi uwaraini iyatate ekoita. ");
INSERT INTO yrb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuma emaba nono mui kasei sinaroma wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Dawa wei, Godinu ure yawotasu ewa wemau sina ari. Mui dera kini amarama danu amaranu aweta muneta ogaro ufie ui. ");
INSERT INTO yrb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Enoba danu gaukara uwara siaia uiro waya anita. Waya anitaro ogaro ietaba uwara farawa uta. ");
INSERT INTO yrb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ogaro ubi amarama nono moana gaukara uwara siaia ufie uteda wei, aniawete i ogaro ifitae wene uwaraba eno wiawe, nanu ogaro nesia ue bou une. I borumakauini keweawere borumakau nanatuini eno unero ietata nesia ue me sineba i aweta muneta ogaro are iawe wiawe wei. Weiro danu gaukara uwara ido anita. Ane fatate danu wei sina enanari weita. ");
INSERT INTO yrb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Weitaro i uwara i sina nautate moana uwarama ema iruteda emanu waiyaro sitowaro aboro aboro wo bagaru ue anita. ");
INSERT INTO yrb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Moana uwarama i kini amara danu gaukara uwara mune emaba siosawere uteda utaro uita. ");
INSERT INTO yrb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Eno utaba i dera kini amarama ibo derawere ui. Ibo derawere uite danu meremere uwara siaia uiro anita. I danu gaukara ueta uwara ma uita uwarabai ane fatate moko ema ma uitate emanu su su inama yata. ");
INSERT INTO yrb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","I dera kini amarama danu gaukara uwaraba wei, nanu ogaro me sininuba i botai wene uwarana siosawereba da ifitaita. ");
INSERT INTO yrb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Idoba i dera daba daba aboro aboro aniawete abo uwara atawete wiawero afita wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Weiro i gaukara uwarama anitate kobere uwaraini siosa uwaraini atatate woure fataro i aweta muneta ogaro su wate fari. ");
INSERT INTO yrb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","12","I dera kini amara i ogaro itebita uwara efie fari. Farina mui amarana i aweta muneta wadia yurawa uiro erite wei, naiye, a aweta muneta wadia bobo mede nono anene ewa suro amusinu wei? Weiro sina wiawa wate mu ui. ");
INSERT INTO yrb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Wate mu uiro kini amarama mui ogaro yawoeta amaraba wei, danu buri age uwane tariate dawa i wawa dumuwere kabesiro saro itafi. I kabesiro uwarama nio bijari uteda i webitaita. ");
INSERT INTO yrb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Godima wasu, eme faiyawere arawe wasuroma nono duburona demui demui torowa we mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","I Ferosi uwarama Yesu ekoitate wawaro anita. Ane emanu unu Yesu irufitaro Yesu ane moko sina webiro budari ufitae iba emanu aika sina sina we matata. ");
INSERT INTO yrb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","I uwarama eno we matatate emanu iwata ueta uwaraini Erodinu uwaraini siaia utaro Yesubai Danu sina irue naufitae anita. Ane fatate weita, tisa Ana ba amara. Mui amara derawerero nono mui amara kikiratu eno imutawa utasute Godinu sinaini Danu imueta we mawetu uegou utasu. ");
INSERT INTO yrb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Eno utasuba Romani gaemani uwarabai takesi mafeisina ina ido aba me? Wiaro naufe weita. ");
INSERT INTO yrb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Weitaro Yesuma emanu siosa imueta iwata uite wei, ya meoma weta uwara! Aneba Na iruteda wenaueraita? ");
INSERT INTO yrb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","I takesi oi maiwero ema wei. Weiro Dawaba siriwa oi mataro muni. ");
INSERT INTO yrb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mune ereda wei, ananu kofirini owawaini ewado ibinu wei? ");
INSERT INTO yrb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Weina Sisanu weita. Eno weitaba Yesuma emaba wei, idoro i dera gaemani yawoeta amara Sisanu ane ane dawaba mawete Godinu ane ane Godiba mawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Weiro i uwarama nautate neno kirifu utate Yesu ekoitate anita. ");
INSERT INTO yrb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","I kowaro moana Sadusi uwara ido fata. I uwarama eme uietaroma da uyafitaita eno imutebita. ");
INSERT INTO yrb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","I uwarama Yesubai fatate weita, tisa, Mosesinu tarawatu eno wasu, mui amarama aweta mubite aruma amara munawa me ibebe uifiro danu dabuema danu aweta wabu mubite i uieta amaraba aruma amara yanae mubisu wasu weita. ");
INSERT INTO yrb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yanu sina webero naua. Adarabu nesia seweni (7) ibita. I botai amarama aweta munite aruma amara yanae munawa me ibebe ui. ");
INSERT INTO yrb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Danu dabuema danu aweta wabu munite enanari me ibebe ui. Enoma enoma i amara seweni (7) enanari utate aruma amara yanae munawa me ibebe uita. ");
INSERT INTO yrb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Uie me sitaro duburo i aweta wabu ido ui. ");
INSERT INTO yrb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Idoba i uie uyareta kowaro ana amarama i aweta mubisu? Ewa orofaro i uwara nesia i aweta mutaba ana amarama i aweta iro mubisu weita? ");
INSERT INTO yrb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Eno Weitaro Yesuma emaba wei, Godinu bukaro sinaini Godinu buna ya iwata meba iba iwawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","I uietaroma uyafitaita kowaro aweta awera da mubitaita. Iro i uwarana Godinu aneru ari iba aweta awera da mubitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Weite wei, Mosesinu uietaroma ma uyareta sina imue eawe. Mosesima Godinu wei sina eno owawa ue odi, Nana Eibaramunu Godi, Aisikinu Godi, Jeikofunu Godi Mosesima eno owawa ue odiro yana yawita. Godi Dawa i uieta uwaranu Godi me. Dawana i wiroeta uwaranu Godi Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Weiro i guruguru ubita uwarama nautate Danu we mawetu uetaba neno kirifu uta. ");
INSERT INTO yrb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesuma i Sadusi uwaranu sina weta daba garari uiro Ferosi uwarama nautate nesia ma aitate Yesubai fata. ");
INSERT INTO yrb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Fataro mui amarama Yesu ue efie uteda wei, tisa abo tarawatuna i botai tarawatu wei? ");
INSERT INTO yrb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Weiro Yesuma dawaba wei, anu unu uetaini imueta nesia Godibai odegou uate utebea wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ina i dera botai tarawatu. ");
INSERT INTO yrb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nono muini eno, anu torowaba anu aika neno arama utasu enanari anu aiyemutuba neno arama uegou ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosesini i we bou ueta uwaranu sina nesia i tarawatu sadeibairoma fariro weita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","I Ferosi uwara guruguru utaro Yesuma emaba wenauereda eno wei, Godinu Kerisoba ane waita? Dawa ananu amara wei? Weiro Dawaba weita, Dawa Deiwidinu sisia amara weita. ");
INSERT INTO yrb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Weitaro Yesuma emaba wei, Godinu Imumu Kotofuma Deiwidiba bunawere imueta maiba aneba Deiwidima Keriso nanu Dera Waria Amara wei? ");
INSERT INTO yrb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dawa eno wei, Godima nanu Dera Waria Amaraba wei, Nanu banibira age afu yauaro Anu wasai uwaraba buna umate Anu buri eminaro odimau, Dawa eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Deiwidima i sina bodere aneba eno wei? Deiwidima Kerisoba nanu Dera Waria Amara weina Yesude anene danu sisia amara sini wei? ");
INSERT INTO yrb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Weiro nautate moko sina wiawa utate i kowaroma mui wenauereta wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Yesuma i guruguru ubita uwaraini Danu iwata ueta uwaraba wei, i tarawatu tisa uwaraini Ferosi uwaraini Mosesinu tarawatu iwata uteda i Ju uwaranu dubu suro we mawetu utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Enoba emanu we mawetu ueta sina nauawete enanari uawete nono emanu ueta sineta enanari da uawe wei. I uwarama sina derawere we mawetu utaitate nono enanari utawa utaita. ");
INSERT INTO yrb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","I uwarama emenu tarawatu ego ari urumuwere emenu eriro aberaitate emanu age rorou demurairatuma i ego mamawa utaita. ");
INSERT INTO yrb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ane ane uteda emema efitae iba eno utaita. Godinu sina obari ue ageini befororo uwane taritebaitaro ibaita. Kikiratu obarina me, deranono obari ue uwanaita. Nono emanu wadia yafawere barue sanaitaro fa tanasu. Emema ina nesia efitae iba eno barue inaraita. ");
INSERT INTO yrb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ogaro anaitate eme efitae i dera uwaranu yaureta kabesiro yauraita. Ju uwaranu dubu suro amutaitate eme efitae i botai yauraita kabesiro yauraita. ");
INSERT INTO yrb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Emanu ununa i maketi kabesiro inaraita uwaranu ario sina naueta. Emanu ununa emema ema dera tisa webitaro naufitae iba eno utaita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ya nesia yatae yabue ya nesia su demurai uwaraba yabai mui amaraba tisa amara da wiawe. Yabai tisa Amara demurai ibinua wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yana ewa orofaro mui amaraba Baba da wiawe. Yanu Baba demurai urero ibinua ");
INSERT INTO yrb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nono mui amaraba dera amara da wiawe. Yabai Dera Amara demurai ibinua Dana Keriso. ");
INSERT INTO yrb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Anama yabai derawere sibisuna dawa yanu gaukara amara sibisu. ");
INSERT INTO yrb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Anama danu torowa ma derawere ufisuna Godima dawa ma kikiratu ufisu. Anama danu torowa ma otowaratu ufisuna Godima dawa ma derawere ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesuma we kakara sina eno wei, ya tarawatu tisa uwaraini Ferosi uwaraini ya meoma weta uwara eregou uforo! Godinu ure yawoeta orofa daba garari utaitaba emema anawa utaita. Yana iro anawa utaitaro nono emema emanu unu i ure orofaro anibitae utaitana emanu anaita daba garari utaita. ");
INSERT INTO yrb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ya tarawatu tisa uwaraini Ferosi uwaraini ya meoma weta uwara eregou uforo! Yana wabu awetaboba meoma uteda emanu ibaiabai nesia suini waira utaitate nono guriguri yafawere irue utaita. Enoba Godima ya fanisi derawere mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ya tarawatu tisa uwaraini Ferosi uwaraini ya meoma weta uwara eregou uforo! Mui amara yanu iwata ueta amara sibie enea ubarero, duero, aboro aboro dobere anaita. Nono mui amarama yanu iwata ueta amara sibisuna yana yanu siosa ueta dawaba maforo siosa derararabo sibiro yaini dawaini uitawa inaro aniboro Godima yaba fanisi mateda dawaba fanisi derawere mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ya we mawetu ueta uwara diti basugari ueta uwara ariba eregou uforo! Ya eno waita, anama i dera dubu sunu ifuro buna we bou ufisuna ina ba me. Nono anama i dera dubu su ubarero gorunu ifuro buna we bou ufisuna dawa enanari ufisu waita wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ya diti basugari gogore uwara! Ane derawere, i goro aba i dera dubu su? I suma goro ma kakara uiba i suna derawere wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yana eno waita, anama sina weda fuyo oeta kabesinu ifuro we bou ufisuna i kabesi buna meba enanari da ufisu waita. Nono anama i sina weda i fuyonu ifuro we bou ufisuna i fuyona bunawereba enanari ufisu waita. ");
INSERT INTO yrb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ya diti basugari erawa utaita uwara! Anema derawere? I fuyo oeta aba fuyo oeta kabesi? I fuyo oeta kabesima fuyo oeta ma kakara utasuba i kabesina derawere. ");
INSERT INTO yrb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Anama sina weda fuyo oeta kabesinu ifuro buna sina wasuna i fuyo oeta kabesini fuyo nesia emanu ifuro buna sina wasu. ");
INSERT INTO yrb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Anama sina weda dera dubu sunu ifuro buna sina wasuna dera dubu suini i dera dubu suro ibinu Godinu ifuro buna sina wasu. ");
INSERT INTO yrb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Anama sina weda urenu ifuro buna sina wasuna Godinu yaure yawoeta orofaini iro yaubinu Godinu ifuro buna sina wasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ya tarawatu tisa uwaraini Ferosi uwaraini ya meoma weta uwara eregou uforo! Yana waiyaro ibaiabaini moana kikiratu ibaiabai nesia taisi odegou utaitate nono i tarawatu buna ememetu, uwaraba kobererau uetaini neno arama uetaini Godi naue imuetaini ina utawa utaita. I taisi oetaini ina nesia da imutawa ufote nono i tarawatu ueta nesia uegou uforo wei! ");
INSERT INTO yrb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ya diti basugari we mawetu ueta uwara! Yana ieta naberoro mimini yonitawa uteda mu sanaitarogo nono dera kemo, dana boro derawere ari nesia ido yonitaita i ari yana i kikiratu tarawatu uegou utaitate nono i derawere tarawatu me sara utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ya tarawatu yawoteda ueta uwaraini Ferosi uwara, yaba watane, eregou uforo! Yana eno utaita, kafusini nabero etu deiro torowa urotaitate nono ubarerona igabuga derawere ibebasu. Enanari yanu ofe deirona urotaitaro nono yanu neno ubarena igabugawere. Iro waira uetaini eme uretaini eno imueta faiyawere imutaita. ");
INSERT INTO yrb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ya Ferosi waita uwara. Yana diti basugari bobo uwara ari. I kafusi ubare botai urofoitana danu wawaro roatarau sibisu. ");
INSERT INTO yrb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ya tarawatu tisa uwaraini Ferosi uwaraini, ya meoma weta uwara eregou uforo! Yana eme uri oeta kabesi ari. Deiro ariowere ina kobererau. Nono ubarero uieta uwaranu taini igabuga ememetu faiyawere ibinu. Yana i ari. ");
INSERT INTO yrb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Emema yanu ofe ubuini ibo nawata eraitate dawa kobererau we imutaitaro nono yanu imuetana meorarabo Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","32","Ya tarawatu tisa uwaraini Ferosi uwaraini ya meoma weta uwara eregou uforo! Yana i we bou ueta uwaranu uri oeta kabesi ma wirotaitate Godinu kobere uwaranu uri oeta kabesiro werei werei ue odeda waita, yanu abuamutubai ibiferona i we bou ueta uwara da ma uifene waita. Eno waitana yana i we bou ueta uwara ma uitebita uwaranu koiniboro weda waita. Eno waitaba emanu siosawere ueta enanari ue me siboita wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yana towi ari. Ya towinu muneta nanatu! Ane ufote uitawa inaro da aniboita? ");
INSERT INTO yrb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Idoba yabai we bou ueta uwaraini iwata derawere uwaraini tarawatu tisa uwaraini ema nesia yabai siaia umaro fafitaita. Fafitaro moana ma uifote moana korosiro odifote moana yanu dubu suro isuma ufote yanu natofo su suro emaba siosawere ufote ure yowefoita. ");
INSERT INTO yrb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Eno ufoitaba Godima ya fanisi mafisu. I kobere uwaranu ma uietana yanu kerere. Eiborobairoma Barakaiasinu amara Sakaraiyabai, i amara i fuyo oeta kabesini dera dubu su abanaro yana dawa ma uita, i uwara nesianu ma uieta ina yanu kerere. ");
INSERT INTO yrb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yaba ba watane, i nesiaba Godima ewa ibinita uwara fanisi mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesuma nono wei, O Jerusaremu su uwara, yana Godinu we bou ueta uwara ma uitaitate Godinu siaia utasu uwara gebiroma uraitade. Kokora awetama danu nanatu fakinama obari utasu enanari Nanu ununa ya Jerusaremu su uwara yawomane watane nono ya unutawa Nanu yawoeta wei. ");
INSERT INTO yrb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","Idoba Godima yanu Jerusaremu su ekodinuba Na da efitate eno webitaita, Godinu ifuro farinu Amara Dawa kobererau webitaitana nono Na efitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuma dera dubu su ekodite anibie ui. Anibie uina Danu iwata ueta uwarama Dawabai fare weita, i dera dubu su su are ea weita. ");
INSERT INTO yrb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Weitaro Yesuma emaba wei, awona yana i dera dubu su su eraita? Yaba ba sina wemaro nauawe. Mui kowa fafiro i su gebiro nesia ma ubefitaro mui gebiroma mui gebironu deiro da ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesuma Oriwa maidaniro mane yauri. Ido yauriro Danu iwata ueta uwara emanu aika Dawabai mane fatate weita, Anu dera dubu suba wenu sina abo kowaro eno ufisu? I dubu kowaro anene ufiro efero a fafasu weita? ");
INSERT INTO yrb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Weitaro Yesuma wei, eregou uforo! Moana uwarama ya irufitae fafitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Uwara faiyawere Nanu ifuro fafitate nana Keriso webitate eme faiyawere irufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dera uranetanu rurua ewado baworo naufote emirowere orofaro me sina torowa naufoitana iba iya da uyawe. Ina eno ido fafiro nono i dubu fafisu kowa ina oidea wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mui orofa gaemanini mui orofa gaemanini urafitaita. I orofa atata uwara aika maika urafitaita. Orofa faiyawerero sinai derawere woufitaita. Orofa faiyawerero nasini wawana wawana ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ina nesia ufisuna eme emanu oferi awetama kuita mubie uteda oferi derawere wourebasu i ari ido reka woufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ina eno ufisuna emema ya siosawere ufitae uteda budari ufitate ma uifitaita. Yana Nanu sina naufoitaba eme nesia yaba neno ka ufitate iba eno ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","I kowaro uwara faiyawere Na ekodifitate emanu aika do mafitate emanu aika urane matafitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","I kowaro meoma we bou ueta uwarama uyafitate meo sina webitaro uwara faiyawere emanu sina naufitate emanu buribi anibitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","I kowaro emema ba me ueta derawere ufitaitaba neno arama ueta ekodifitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nono anama awonaroma inare kimu ue i dubu fafisu kowaro ane fafisuna dana wiroeta mubisu. ");
INSERT INTO yrb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Godinu yawotasu sina i orofa atata uwara nesiabai we inareibitaro i orofa atata uwara nesia naufitaro i dubu kowa ido fafisu. ");
INSERT INTO yrb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Boderewere Godinu we bou ueta amara Daniera dana eno wei, mui siosawere emetuma kakara su koruro inafiro efoita wei. Enoba ya yawitaita uwara ina iwata utaita, iba eregou ufoe watane Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Eno efoitana i kowaro i Judia orofaro ibifitaita uwara maidaniro sau manibitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","I ofadaro yaubifitaita uwara suro ibaiabai mubitae da amufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","I waiyaro gaukara uteibitaita uwara emanu wadia mubitae suro da owefitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","I kowaro i dia bobo awetaboini ama ieta kuita bobo awetaboini emanu anibitaita dabana siosawereba sau da anibitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Enoba guriguri uawero yanu sau aneta kowa i awe awe kowaro aba obi mafisu kowaro aba sabate kowaro sau da fafi, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","I kowaro awe derawere uyafisu. Boderewere Godi i orofa atata ubu ui kowaroma awona eno erawa utaisiba nono duburo eno da efoita. ");
INSERT INTO yrb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","I awe derawere uyareta kowa kowana siosararaboba iba Godima da ma fuyaratu ufirona eme nesia feafitae, enorogo Godi Danu mune odasu uwara nesia imuteda iba i kowa ma fuyaratu ui. ");
INSERT INTO yrb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","I kowaro mui amarama Keriso ewado aba Keriso iro ea webisuna danu sina da nauforo wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","I kowaro irueta kerisoini irueta we bou ueta uwaraini uyafitate buna uetaini eretaini eme irufitae ufitate Godinu muneta uwara irufitae ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yana i ueta nesia efoitaba awonana Nana yaba sina wemaro nauegou uawe! ");
INSERT INTO yrb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","I kowaro Dana eme ibawa orofaro ibinu webitaitana da naufote iro da aniboro Dana i su koruro yaubinu webitaitana emanu sina da naufoe iba awona yaba watane wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bidama kowa amueta afu kowa itareta afu tiriri ue fa taneda ario utasuro eraita enanari i Ba Eme Sini Amaranu fareta efoita wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","I uieta ofe aboro aboro ainibifitaro iro amuo gasirama ifitae anibitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","I dera awerarabo ememetu me sibitaitana daido sau ewa yana awona eraisi kowa dumu ufiro nono sakara da ario ufiro muina ureroma burubafitate nasiniro itafitaro i urenu buna derararabo nesia wawana wawana ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Idoba i kowaro i Ba Eme Sini Amaranu fareta tanana urero ufiro efitate i orofa atata uwara nesia i webitaita. I Ba Eme Sini Amara gosoro bunaini ario derawere ido fafiro efitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dawa fafite areda Danu aneru siaia ufie tawuyo ubufiro anibitate Danu muneta uwara kowa amueta afuro kowa itareta afuro ufuniro manamaro aboro aboro nesia ane mubitaita wei. |L");
INSERT INTO yrb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","I boruba ana eawete iwata uawe. Boruba ana reka tua ido yarebasuro obi kowa ido farinu webaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Enanari Nanu wene i sina nesia ufiro efoitana i Ba Eme Sini Amara fafie uteda bebetoro inarinu iwata ufoita. ");
INSERT INTO yrb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yaba ba wemaro nauawe. Ewa ibinita uwara da uifoitaro ewa nesia botai ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ureini nasinini me sibiro Nanu sina da me sibisu Yesuma wei. |L");
INSERT INTO yrb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","I fafisu kowa eme iwata me, i urero ibinita aneru iwata me, Godinu Amara Dawa iwata me, Godi torowa Dawa iwata utasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noanu kowaro ane ane utebita enanari i Ba Eme Sini Amaranu fareta kowaro ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Noanu kowaro emema ietaini ogoini itebitate aweta awera munebitana Noa danu bouti ubarero amuiro obi oku derawere ido fariba uwara nesia ogo okuro imuie me sita. Enorogo ema i emabai fafie arebi emetu iwata me. Emanu unu ibaiabai utebitaro oku farite ema woure ane me sinina ido nesia iwata uta. I arina i Ba Eme Sini Amaranu fafisu kowaro enanari ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","I kowaro amara sadei waiyaro uruama gaukara ufisisina mui amara woure anibiro mui amara ibifisu. ");
INSERT INTO yrb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aweta sadei uruama okia oufisisina mui aweta woure anibiro mui aweta ibifisu. ");
INSERT INTO yrb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yanu Dera Amaranu fareta kowa wai ufiro aba yawiro ya iwata meba eregou uforo wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ewa sina imue eawe. I su ubi amarama i waira ueta amaranu dumuro fareta iwata ufirona danu su yawofiro su ma siosa da ufie wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Idoba i Ba Eme Sini Amaranu fareta kowa ya iwata meba ainewaure toafurau yawoteiboro wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mui dera amara danu mui gaukara amara danu suini waiyaini ibaiabai nesia yawofie odiro i amarama i su uwara emanu ieta ido matebi. Eno utebina kobererau utebi aba me? ");
INSERT INTO yrb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Enanari i yawoeta amarama fafisuna danu gaukara ueta amarama enanari ufiro efite dawa we ma kobererau ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ba wemaro nauawe. I yawoeta amarama i amara danu ibaiabai nesia yawofie mune odifisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","Nono mui siosawere gaukara amara eno we imufisu, nanu dera amara sau da fafisu we imufite danu uruama gaukara utaita uwara isuma ufite ietaini kimu ogoini i beforo arama uwarabai iteibisuna danu dera amara kiwuma ido fafisu. ");
INSERT INTO yrb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ido fafite dawa fanisi mafite i meoma weta uwarabai sane odifiro iro emema nio bijari uteda i webitaita Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Godinu ure yawoetana ewa sina ari Yesuma wei. Arumami teni (10) emanu nanefa mutate i aweta muneta amara atafitae anita. ");
INSERT INTO yrb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Moana arumami fai (5) emanu beforona bunawere. Nono moana arumami fai emanu beforona buna me. ");
INSERT INTO yrb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","I beforo buna me arumami anibitae uteda emanu nanefa mutate nono nanefa ogo munawa me anita. ");
INSERT INTO yrb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","I beforo buna arumami emanu nanefaini ogoini ogo botoro mutate anita. ");
INSERT INTO yrb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","I arumami nesia anitana aweta muneta amara farawa uiro nauta aita. ");
INSERT INTO yrb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nauta ainibitaro dumu abanaro i aweta muneta amara ido farinu arawete eawe eno derawere weitaro nauta. ");
INSERT INTO yrb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","I arumami nautate uyatate nanefa beafitae uta. ");
INSERT INTO yrb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Eno utana i beforo buna me arumamima i beforo buna arumamiba weita, yanu nanefa uifitae utaitaya yaba ogoratu maiwe weita. ");
INSERT INTO yrb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Eno weitaro i beforo buna arumami weita, yabai ogo derawere meba yaini yaini arotorowa da mubeisia aniawete i sitowa uwarabai reka oiya uawe weita. Weitaba ido anita. ");
INSERT INTO yrb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Anitana i aweta muneta amara ido fariro i ue bou uta arumamini dawaini aweta muneta ogaro ifitae suro amutaro kasimu ido garari ui. ");
INSERT INTO yrb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Duburo i beforo buna me arumami fatate kasimubai inaibeda weita, dera amara, kasimu ma ifegari uaro ya amufe weita. ");
INSERT INTO yrb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Weitaro i amarama wei, ya na iwata meba kasimu da ma ifegari umau wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Enoba i fafisu kowaini waini wai ufiro aba yawiro ya iwata meba eregou uteda yawoegou uforo Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Godinu ure yawoetana ewa sina ari Yesuma wei. Mui amarama mui orofaro anibie uteda danu gaukara uwara weiro dawabai fata. Fataro ema danu waiyaini suini ibaiabai nesia yawofitae wei. Eno weite danu gaukara uwaraba oi mai. ");
INSERT INTO yrb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mui amaraba fai tausani kina (K5,000) maite mui amaraba tu tausani kina (K2,000) maite mui amaraba wani tausani kina (K1,000) mai. I uwaranu buna aika maikaba iba oi aika maika mai. I oi mae me sinite iroma mui orofaro ani. ");
INSERT INTO yrb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Aniro i fai tausani kina muni amarama sau anite besenesi gaukara uteda mui fai tausani kina deiro odi. ");
INSERT INTO yrb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Enanari i tu tausani kina muni amarama mui tu tausani kina deiro odi. ");
INSERT INTO yrb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nono i wani tausani kina muni amarama danu dera amaranu oi munite sakai uri daurite i oi i uriro ma feare odite ani. ");
INSERT INTO yrb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Dera amara mui orofaro ibebe ibebe kowa faiyawere ibebe nono owerite fari. Suro farite danu oi mai gaukara uwara besenesi gaukara anene utebita iwata ufie ema weiro dawabai fata. ");
INSERT INTO yrb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Fataro i fai tausani kina muni amarama danu mui fai tausani kina oi deiro woure farite wei, dera amara, ana naba fai tausani kina mairo nono mui fai tausani kina deiro ue odineba ewado mua wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Weiro danu dera amarama wei, ana rorowarauini kobere gaukara ueta amara. Ana kikiratu kobererau yawosinuba odimaro derawere yawofasu. Nabai are ibeda yaru ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nono i tu tausani kina muni amarama farite wei, dera amara, ana naba tu tausani kina mairo nono mui tu tausani kina deiro ue odineba ewado mua wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Weiro dera amarama wei, ana rorowarauini kobere gaukara ueta amara. Ana kikiratu kobererau yawosinuba odimaro derawere yawofasu. Nabai are ibeda yaru ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nono duburo i wani tausani kina muni amarama dawabai farite wei, dera amara, ana kimuwere yawotasu amara. A kimuwere yawoteda beata waitawa nono ietata munasute ane ane odawa utasute nono munasu. ");
INSERT INTO yrb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Enoba na a iwata uteda aba iyareda anu wani tausani kina sakairo uri uete ma feare ode. Idoa anu oi awona mua wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Weiro wei, ana siosawerero ofe ejiwawere gaukara amara! Nana kimu yawoeta amara. Beata waitawa ietata munatanete ane ane odawa odeda nono munatane. ");
INSERT INTO yrb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ina a iwata utasude nono aneba nanu oi banikaro odifaro fare nanu oi muneda mui oi deiro odifitaro fare munawa une wei? ");
INSERT INTO yrb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Weite wei, Danu wani tausani kina ma dareawete i fai tausani kina bobo amaraba mawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","I ibaiabai derawere bobo amarabai mui mafiro mubiro dawabai faiya faiyawere ibifisu. I kikimusikiratu uwaranu kikiratu ibaiabai ma dare mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","I siosawere gaukara amara muate i dumuwere wawa kabesiro mune sawero itafi. Idoba iro emema emanu nio bijari ufitate i webitaita, i dera amarama eno wei. Yesuma i sina emaba wei. ");
INSERT INTO yrb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","I Ba Eme Sini Amaraini danu aneruini ario derawerero fafitaitana Dawa Danu dera yaure yawoeta orofaro yaufisu. ");
INSERT INTO yrb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Ido yaufiro i orofa atata uwarama Danu iboro fafitate inafitaita. Inafitaro ema ma saragari ufisu. Mamoe yawoeta amarama danu mamoeini goutini ma saragari uteda aika maika odasu enanari i Ba Eme Sini Amarama i mamoe ari uwara Danu banibira age afuro odifite i gouti ari uwara Danu ewani age afuro odifisu. ");
INSERT INTO yrb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Odifite nono i Dera Waria Amarama Danu banibira age afu uwaraba eno webisu, Godima yaba we ma kobererau utasuba arawe. Godima ureini nasinini ubu uteda yanu yawoeta orofaini ido ubu uiba arawete i orofaro yauawe. ");
INSERT INTO yrb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nana osi wourero Naba ieta mata. Na ogo nodo uiro Naba ogo mata. Na aika amara ari yabai farero Na ario derawere weita. ");
INSERT INTO yrb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na wadia eruwere inarebitararo Naba wadia mata. Na ofe wourero Na durua uta. Na diburaro ibitararo Nabai fatate owiga uta webisu. ");
INSERT INTO yrb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Eno webiro Godinu sina naueta uwarama eno webitaita, Dera Waria Amara, abo kowaro osi wouriro ereda Aba ieta masi? Ogo nodo uiro Aba ogo masi? ");
INSERT INTO yrb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Abo kowaro aika amara ari yabai fariro A ario derawere weisi? Abo kowaro Anu wadia eruwere esite Aba wadia masi? ");
INSERT INTO yrb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Abo kowaro ofe wouriro ereda A durua usite A abo kowaro diburaro ibiro owiga usi webitaita. ");
INSERT INTO yrb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Eno webitaro Dera Amarama emaba eno webisu, ba sina wemaro nauawe. Nanu sina naueta uwaraba eno utebitana Naba utebita webisu. ");
INSERT INTO yrb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Eno webite Danu ewani age afu uwaraba webisu, ya siosawere uwara, Godima yaba we ma kobererau utawa utasu. Godima i uitawa ina seitanini danu aneruba ubu ui. Nabairoma i uitawa inaro aniawete iro ibiawe webisu. ");
INSERT INTO yrb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na osi wourero Naba ieta matawa. Na ogo nodo uiro Naba ogo matawa. ");
INSERT INTO yrb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yabai aika amara ari farero Na ario wiawa. Na wadia eruwere inarebitararo Naba wadia matawa. Na ofe wourero Na durua utawa. Na diburaro ibitararo Na owiga utawa uta webisu. ");
INSERT INTO yrb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Eno webiro webitaita, Dera Waria Amara, abo kowaro osi wouriro ogo nodo uiro aika amara ari farite ofe wourite diburaro ibiro esite A durua utawa usi webitaita. ");
INSERT INTO yrb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Webitaro webisu, yaba ba sina wemaro nauawe. Nanu sina naueta uwara durua utawa utebitana Na durua utawa utebita webisu. ");
INSERT INTO yrb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","I uwarama i uitawa inaro anibitaro Godinu sina kobererau naueta uwarama me ibene ibene ibeta orofaro anibitaita Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Yesuma i sina nesia we me sinite Danu iwata ueta uwaraba wei, kowa sadei me sibiro i Godima Isaraero uwara Ijifiroma woure aneta ogaro kowa fafisu. I kowaro i Ba Eme Sini Amara moana uwaranu age duro mafitaro korosiro ure odifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","4","I dera fuyo ode sina weta uwaraini Ju uwaranu baeta uwaraini i botai dera fuyo ode sina weta amaranu suro guruguru uta. I botai dera amaranu ifuna Kaiyafasi. Danu suro anitate Yesu kiwuma budari ufitate ma uifitae we turebita. ");
INSERT INTO yrb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ane fatate weita, i uwarama ibo uotote yaini uraotoba i ogaro kowaro Yesu da mubeisi weita. ");
INSERT INTO yrb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Yesuma Beteni suro ane yaubi. Dawa amaima derawere amara Saimoninu suro ane yaubiro mui awetama bonana ogowere, danu dawana derawere, gebiro kawaburo woure farina Yesu ieta itebiro i awetama bonana ogowere Danu kofiriro ma wegari uiro ogo kofiri deiro itari. ");
INSERT INTO yrb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Eno uiro Danu iwata ueta uwarama etate ibo uteda weita, aneba me sara ma wegari usinu? ");
INSERT INTO yrb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","I ogo oiya ufite oi me uwaraba i oi mafisuna ina kobererau weita. ");
INSERT INTO yrb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Weitaro Yesuma emanu imueta iwata uite wei, i aweta dua sina da wiawete kodiawe. Dana Naba kobererau usinu. ");
INSERT INTO yrb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ibaiabai me uwara ainewaure yabai ibaitaba Na yabai ainewaure da ibimau. ");
INSERT INTO yrb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","I ogo Nanu ofero ma wegari usinuba Nanu uri ue oeta ue bou usinu. ");
INSERT INTO yrb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yaba ba wemaro nauawe. Godinu sina i orofa atata kabesi aboro aboro we inareda ewa awetanu ueta webitaro naufitate dawa imufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Judasi Isikarioti dawana Yesunu mui tuero (12) iwata ueta amara. Dawa i dera fuyo ode sina weta uwarabai anite wei, Yesu yanu agero odimauna naba ane mafoita wei? Weiro dawaba siriwa oi toti (30) mata. ");
INSERT INTO yrb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Oi mataro Judasima Yesunu do maeta daba doberegou ui. ");
INSERT INTO yrb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","I wawareta ira yisiti me buredi ogaro kowa ido fari. I kowa ido fariro Danu iwata ueta uwara Dawabai fatate weita, anu Godima Isaraero uwara Ijifiroma woure aneta ogaro aboro ue bou ufeisi weita? ");
INSERT INTO yrb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Weitaro wei, etei natofo suro mui amarabai aniawete dawaba wiawe, yanu Tisa Amarama wenu, Nanu kowa farinuba anu suro Naini Nanu iwata ueta uwaraini i ogaro ifeisi wenu wiawe eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Weiro Danu iwata ueta uwarama Danu wei sina enanari utate i ogaro ue bou uta. ");
INSERT INTO yrb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yawi sinina Yesuini Danu iwata ueta uwara tuero (12) ieta itebita. ");
INSERT INTO yrb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ieta itebitana Yesuma wei, ba sina wemaro nauawe, yabairoma mui amarama Na do mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Eno weiba neno siosawere uteda naba wasu? Naba wasu? Demui demui nesia eno we fare anita. ");
INSERT INTO yrb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Eno webitaro Yesuma wei, dana Naini ewa ieta naberoro ieta mubisuna dana Na do mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","I Ba Eme Sini Amara uifisu Godinu bukaroma eno wasuba enanari uifisu. Nono Dawa do mafisu amaraba fanisi derawere mafisua wei. I do maeta amaranu danuama dawa da mubirona ina kobererau wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Weiro Judasi i do mai amarama wei, Dera Waria Amara, dana na aba me wei? Weiro Yesuma wei, ba wasu, dawa a wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yesuini Danu uwaraini ogaro ita. Ogaro iteda Yesuma buredi mune guriguri uite ma birabiarite Danu iwata ueta uwaraba mateda wei, ewana Nanu ofe, i mune iawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yesuma nono kafusi munite Godibai we ma kobererau uite Danu uwaraba mateda wei, ya nesia iawe. ");
INSERT INTO yrb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nanu onono ima Godinu reka unuro ue mataneta ma kimu ufite uwara faiyawereba itafisu. Itafite emenu neno neno ueta urofisu wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ba watane, ewa na didi tai dumamu duburo da imaro Nanu Babanu yawoeta kowa fafisuna Danu yawotasu orofaro kowaro yaini Naini nono ifeisi wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yesuini Danu uwaraini soni weitate i su ekoitate Oriwa maidaniro manita. ");
INSERT INTO yrb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oriwa maidaniro mane fataro Yesuma emaba wei, ya nesia awona dumuro Na ekodifoita wei. Godinu bukaroma eno wasu, i mamoe yawoeta amara umaro i mamoe nesia wo bogaru ue anibitaita wasu. ");
INSERT INTO yrb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Godima Na uietaroma ma uyafiro Na ko Gareri orofaro animaro ya iro aniboita wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Weiro Fitama bunawere wei, i uwara nesia aba maru ufitate A ekodifitaitarogo nono nana A da ekodimau wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Weiro Yesuma wei, Nanu ba sina wemaro naua wei. Kokora awona dumuro webiro a ko Nanu ifu rarogonu we ma feareda meo webasu wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Weiro Fitama wei, aini uimane umauna Aba meo da wemau wei. Eno weiro Danu iwata ueta uwara nesia enanari weita. ");
INSERT INTO yrb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesuini Danu iwata ueta uwaraini mui orofaro anita. I orofanu ifuna Gesemani. Iro ane fataro Yesuma emaba wei, ya ewado yaubiawero Na etararo animate guriguri uma wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","38","Weite Fitaini Jebedinu amara sadei munite ani. Anite neno siosa derawere uteda i amara rarogonuba wei, Nanu neno bomu kakei utasuba Na uieta neno utasu wei. Ewado yaubeda Naini yawoawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Weite ema ekodite fuyaratu anite arubi uteda guriguri uite eno wei, Baba, ewa siosawere wakiki ogo ari Nabairoma anibisuna anibisu. Nono Nanu ununa da uate Baba Anu unu torowa ua wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Weite uyarite Danu iwata ueta uwarabai ane farina nauta aitaro ereda Fitaba wei, ni furatu Naini aneba yawotawa utaita? ");
INSERT INTO yrb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yawoegou uawete guriguri uawe, siosawere ue ereta yabai faosoro uotoa wei. Yanu nenonu unu ufoitana nono yanu ofena buna meba da ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Eno weite nono anite guriguri uteda wei, Baba ewa siosawere urane yaraneta Nabairoma da anibisuna Anu unu umate uimau wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nono uyarite Danu iwata ueta uwarabai farina emanu diti bomuwere uiba daido nauta ainibitaro eri. ");
INSERT INTO yrb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","45","Erite nono owerite ani. Ane guriguri uteda enanari weite uyarite Danu iwata ueta uwarabai fari. Farite emaba wei, ya daido nauta ainibeda imoitaita? I kowa ido farinuba i Ba Eme Sini Amara siosawere uwaranu age duro odifitaita. ");
INSERT INTO yrb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Uyawero anibe. Na do masinu amara ido farinua eawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu eno weina Judasi, dana mui tuero iwata ueta amara, dawaini uwara faiyawereini ema goreini dera kaiyaini woure fata. I dera fuyo oeta uwaraini Ju uwaranu baeta uwaraini emana ema siaia utaba iba fata. ");
INSERT INTO yrb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aubokona Judasi, i do maeta amara, dana i uwaraba wei, abo amara nana koku umauna dawana i amaraba muawe eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judasima Yesubai farite wei, Dera Waria Amara, yaubinu weite yabaite koku ui. ");
INSERT INTO yrb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Eno uiro Yesuma wei, naiye, anu unu ane ua wei. Weiro i fata uwarama Yesu fare yabae budari uta. ");
INSERT INTO yrb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Eno utaba Yesunu mui iwata ueta amarama danu ba kaiya munite i dera fuyo ode sina weta amaranu gaukara amaranu ome umane kosari uiro itari. ");
INSERT INTO yrb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Eno uiro Yesuma dawaba wei, anu kaiya fausiro odia. I kaiyama uraneta uwarana enanari eno uifitaita. ");
INSERT INTO yrb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Imue eawe! Nanu unu umauna Nanu Bababa wemaro aneru faiyawere siaia ufiro tarafitate Na durua ufitaita. Na eno umauna Godinu bukaroma wasu sina enanari da ufisu. ");
INSERT INTO yrb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Godinu bukaroma ina eno ufisu wasuba iba ewa uwarama eno utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Eno weite i fata uwaraba wei, aneba Na waira ueta amara ari kaiyaini gorema muboe faraita? Kowa ainewaure dera dubu suro yaubeda yaba we mawetu utebitararo Na budari utawa uta. ");
INSERT INTO yrb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Godinu we bou ueta uwaranu weita sina enanari ufisuba iba eno utaita wei. Weiro Danu iwata ueta uwara nesia Dawa ekoitate iya wo bagaru ue anita. ");
INSERT INTO yrb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","I tarawatu tisa uwaraini Ju uwaranu baeta uwaraini Kaiyafasi dawa i botai fuyo ode sina weta amara, i uwara dawabai fare yaubitaba i Yesu muta uwarama Yesu Kaiyafasibai woure ane fata. ");
INSERT INTO yrb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Fitama etararowere i uwaranu buribi ani. Ane Kaiyafasinu su teteuro farite i forisimani uwarabai Yesuba ane ufitaro efie yaubi. ");
INSERT INTO yrb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","61","I dera fuyo ode sina weta uwaraini i kanisoro uwara nesia Yesuba meo wawei weda Yesu ma uifitae daba dobeta. Dobetana uwara faiyawere fatate Yesu meo wawei weita. Meo wawei weitaba Yesu ma uieta daba atanawa uta. I uwarama enoma enoma wawei weitaro nono amara sadei fasite weisi, ewa amarama wei, Godinu dera dubu su ma jugari umate kowa rarogonuro nono ubu umanu weiya weisi. ");
INSERT INTO yrb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Weisiro i botai dera fuyo ode sina weta amarama uyarite Yesuba wei, i sina nausinute aneba moko sina wiawa utasu wei? ");
INSERT INTO yrb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Weiro Yesuma sina mui wiawa uiro wei, i amara sadei aneba A wawei waita wei? Eno weite i botai dera fuyo ode sina weta amarama Yesuba nono wei, Godinu ifuro ba sina wiaro naufe. Ana Keriso Godinu Amara aba me? Wiaro naufe wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Weiro Yesuma wei, anu sinana ba wei. Weite wei, awonaroma i Ba Eme Sini Amarama i buna derawere Godinu banibira age afuro yaufite nono duburo i gosoro fafiro efoita wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Weiro i botai fuyo ode sina weta amarama neno siosa derawere uiba danu yafa asugari wadia ma babareda wei, Dawa Godiba sina siosa wenuro nauisiba moana wawei weta uwaranu sina da naufeisi wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Weite i kanisoro uwaraba nono wei, Dawaba ane ufoita wei? Weiro weita, Dawa siosawere wenuba uifisu weita. ");
INSERT INTO yrb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Weitate Yesunu ibo nawataro witua utate Danu diti wadiama garari utate agema ureda weita, anama A urinu? Ana Kerisoba we bou uaro naufe weita. ");
INSERT INTO yrb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Eno utebitana Fitama wawa i su teteuro yaubi. Yaubiro mui arumama dawabai farite wei, ana Yesu Gareri Amarabai ibi wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Weiro Fitama i uwara nesia emanu iboro yaubeda wei, anu sina na iwata me wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Weite ofadaro ane yauri. Yauriro mui arumama dawa ereda i uwaraba wei, ewa amaraini Yesu Nasareta Amaraini uruama ibisi wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Weiro Fitama wei, firisi, ba watane, i amara na iwata me wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Duburo i me inaibita uwarama Fitabai fatate weita, ana Danu mui amarade. Aini Danu wate tanana arotorowa waisiba ana Danu mui amara iwata utaisi weita. ");
INSERT INTO yrb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Weitaro Fitama wei, na meo me, ba watane. Na meo wemauna Godima na ma uifisu. I amara na iwata me eno meo wei. Eno weiro kokora ido wei. ");
INSERT INTO yrb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kokora ido weiro Fitama nauite Yesunu bodere wei sina, kokora webiro a ko Nanu ifu rarogonu we ma feafate meo webasu wei. I sina imuteda wawaro anite i derawere wei. ");
INSERT INTO yrb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wai urina i dera fuyo ode sina weta uwaraini Ju uwaranu dera uwaraini Yesunu ma uieta daba dobereda we matata. ");
INSERT INTO yrb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","We matatate Yesu mutate Danu age uwane taritate Dawa Romani gaemani dera yawoeta amara, Faeratibai woure ane oita. ");
INSERT INTO yrb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Eno utaro Judasi, Yesu do maeta amarama erina Yesu ma uifitae utaro erite danu imueta ma owerite siriwa oi toti (30) munite i dera fuyo ode sina weta uwaraini dera uwaraini emabai anite oi ma owere mafie wei, Dawa siosa amara me, kobere amara ma uifoe iba ba me ue wei. Weiro weita, ina yanu kerere me, ina anu kerere weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Weitaro Judasima i siriwa oi dera dubu su ubarero sanite owerite ani. Ane danu torowa nama nodo turite ui. ");
INSERT INTO yrb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","I dera fuyo ode sina weta uwarama i oi mutate weita, ina eme ma uieta oi, ina onono oi. Yanu tarawatuba i oi dera dubu su oibai da odifeisi weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Eno weitate mui sina we matatate jogo okia ubu ueta amaranu nasini aika uwara uifitaro ema iro uri ufitae iba i nasini oiya uta. ");
INSERT INTO yrb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eno utaba awona i nasiniba onono nasini waita. ");
INSERT INTO yrb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Godinu we bou ueta amara Jeremaiama boderewere eno weiba iba enanari uta. Jeremaiama eno wei, moana Isaraero uwarama Dawaba siriwa oi toti (30) mafeisi weita. I oi mutate okia ubu ueta amaranu nasini oiya uta. Godima naba eno wenuba iba watane Jeremaiama wei. ");
INSERT INTO yrb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesuma ido dera yawoeta amaranu iboro inari. Inariro dera amarama wei, Ana i Ju uwaranu dera yawoeta amara aba me wei? Weiro Yesuma dawaba wei, anu sinana ba, aiwia wei. ");
INSERT INTO yrb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","I dera fuyo ode sina weta uwaraini Ju uwaranu baeta uwaraini Yesu wawei weita. Weitaro Yesuma moko sina wiawa ui. ");
INSERT INTO yrb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sina wiawa uiba Faeratima Yesuba wei, emanu wawei weta nausinu? Aneba sina moko wiawa utasu wei? ");
INSERT INTO yrb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Weiro Yesuma wiawa uteda emanu wawei weta moko demurairatu wiawa uiro dera yawoeta amarama neno kirifu ui. ");
INSERT INTO yrb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","I Godima Isaraero uwara Ijifiroma woure aneta ogaro kowaro oya mui muiro Isaraero uwarama emanu unu webitaro dera yawoeta amarama enanari dibura amara demurai ma uregari utebiro anebi. ");
INSERT INTO yrb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","I kowaro mui siosawere dibura amara, danu ifuna Barabasi, dawa diburaro ibi. ");
INSERT INTO yrb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","I uwara nesia guruguru utaro Faeratima emaba wei, abo amara ma uregari umau? Barabasi aba Yesu i Keriso waita amara ma uregari umau? Wiawero nauma wei. ");
INSERT INTO yrb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I uwarama Yesuba ubusi uyareda iba Faeratibai oitaro Faeratima ina iwata ui. ");
INSERT INTO yrb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nono i koto uwaranu yaureta deiro yaubeda sina webina danu awetama mui sina siaia uite wei, Dawa kobere amaraba Dawa kodia. Awona na tuberoma Dawa enete neno siosa derawere uneba Dawa kodia wei. ");
INSERT INTO yrb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nono aubokona i dera fuyo ode sina weta uwaraini Ju uwaranu baeta uwaraini emana i guruguru uwaraba weita, Faeratima webisuna Barabasi ma uregari uate Yesu ma uia wiawe weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Dera yawoeta amarama nono wei, i amara sadei eawero abo amara ma uregari umau wiawero nauma wei. Weiro Barabasi ma uregari ua weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Weitaro Faeratima wei, Yesu i Keriso waita amaraba anene umau wei? Weina korosiro ure odia weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Weitaro Faeratima wei, ane siosawere usinu wei? Weina ibo derawere utate weita, korosiro odia weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Faeratima erina i uwarama danu sina munawa utate urafitae utaba Faeratima ogo danu agero ma wegari uite i uwaranu iboro danu age uroteda wei, Danu uietaba mui emeru da umauba uifisuna nanu kerere me, yanu aika uawe wei. ");
INSERT INTO yrb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Weiro i uwara nesia weita, ewa kerere yaini yanu koiniborobai ibeibisu weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eno weitaro Faeratima Barabasi ma uregari uite weiro i ami uwarama Yesu isuma uta. Utaro Faeratima Yesu korosiro ure odifitae ami uwara emaba mai. ");
INSERT INTO yrb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","I dera yawoeta amaranu ami uwarama Yesu woure dera yawoeta amaranu su fefenaro oita. Oitate i ami uwara nesia Yesubai fata. ");
INSERT INTO yrb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Fatate Yesunu wadia ma kosugari utate i dera yawoeta uwaranu kukuiwere yafa wadia ma baruta. ");
INSERT INTO yrb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Eno utate sinisini bobo emetu kofi ubu utate Danu kofiri deiro oita. Oitate akuri Danu banibira agero oitate jejerigari uteda irue weita, Ju uwaranu dera yawoeta amara eawe enoma enoma weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eno utate Dawa witua utate i akuri mutate ima Yesunu kofiriro uta. ");
INSERT INTO yrb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Eno irutate i kukui wadia ma kosugari utate Danu wadia ma barutate korosiro ure odifitae Dawa woure anita. ");
INSERT INTO yrb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Anebitana Sairina orofa amara danu ifuna Saimoni ido fariro atate yabai ara weita. Ewa amaranu korosi woua weitaba wouri. ");
INSERT INTO yrb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wouriro ane Gorogota orofaro fata. (I orofanu ifu ubina kofiri tai torowa.) ");
INSERT INTO yrb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Iro fatate waini iwi ari kawere iro ma dininu utate Dawaba mata. Mataro munite badu uite itawa ekodi. ");
INSERT INTO yrb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","I ami uwarama Yesu korosiro ure oita. Oitate Danu wadia abo amarama mubisu weitate kasi waribo uta. ");
INSERT INTO yrb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Eno utate yaubeda Yesu erebita. ");
INSERT INTO yrb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","I ami uwarama wawei weta owawa oitate korosi deiro Yesunu kofiribai ure oita. I sinana eno, ewana Yesu, i Ju uwaranu dera yawoeta amara. I sina eno owawa ue oitate korosi deiro ure oita. ");
INSERT INTO yrb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","I uwarama waira ueta amara sadeini korosiro ure oita. Mui amara Yesunu banibira age afuro oitate mui amara Yesunu ewani age afuro oita. ");
INSERT INTO yrb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","I fare anebita uwarama irueta sina weitate kofiri kereu kereu uteda yo weitate weita, A dera dubu su ma jugari ufate kowa rarogonu nono ubu ufasu weide, botai Anu torowa ma wiroa. Ana Godinu Amara aba me? Ana Godinu Amarana korosiroma ita, eno irue weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","I dera fuyo ode sina weta uwaraini tarawatu tisa uwaraini Ju uwaranu baeta uwaraini ema nesia Yesuba irue weita, Dawa aika uwara ma wirotebite Danu torowa da ma wirofisu eno irue weita. Dawa ya Ju uwaranu dera yawoeta amarana korosiroma itafisuna Dawa naue imue ufeisi weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dawa Godi imutasu. Nana Godinu amara wenuba Godinu neno Dawabai ibifisuna Godima Dawa durua ufiro efe irue weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","I waira ueta amara sadeima Dawaba enanari we irusi. ");
INSERT INTO yrb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kowa otoro inarite kowa ario utawa dumu sini ibi. Nono kowa osugari uite ane abanaro farina kowa nono ario ui. ");
INSERT INTO yrb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kowa ane abanaro siniro Yesuma derawere wei, Irai, Irai, rama sabatani, i sinanu ubina Nanu Godi, aneba Na ekodinu? Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Weiro i guruguru ubita uwarama nautate moana uwarama weita, etei Amarama Iraija yua wasu weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Weitaro mui amarama anite uriri ari munite isuro uwanite diririwere ana tai dumamuro ma inuite Yesu ifie woure ani. ");
INSERT INTO yrb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aniro moana uwarama weita, kodia, Iraija fafite Dawa ma wirofisu aba me ari, ina efeisi weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuma nono derawere weite ido ui. ");
INSERT INTO yrb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yesu uiro me sinina dera dubu sunu kakara korunu garari ueta dera wadia deiroma babare eminaro itari. I nasini wawana wawana uiro gebiro saragari uiro eme uri ue oita kabesi ifegari uta. ");
INSERT INTO yrb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ifegari utate i bodere Godinu sina nautate uita uwara, Godima ema ma uyari. ");
INSERT INTO yrb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Duburo Yesuma uietaroma uyariro i uietaroma uyata uwarama Jerusaremu suro anitaro uwara faiyawere ema eta. ");
INSERT INTO yrb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","I ami kafitenini danu ami uwaraini ema Yesu yawoteda i nasini wawana wawana uetaini nesia etate neno kirifu derawere uteda weita, ewana Godinu ba Amara weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Awetabo faiyawere etararo inaibeda erebita. I awetabo Yesunu buribi Gareriroma anitate Dawa yawotebita. ");
INSERT INTO yrb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Moana awetabonu ifuna eno, Meri Megidarina Jeimisini Jousefa emanu danua Merini Jebedinu adarabunu danua, i awetaboini moana awetaboini ema i utebi sinebi nesia erebita. ");
INSERT INTO yrb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yawi sinina mui ibaiabai derawere bobo Arimatia amara Jousefa ido ane fari. I amarana Yesunu iwata ueta amara. ");
INSERT INTO yrb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dawa ido ane farite Faeratibai ane Yesunu ofe mubie fari. Ido ane fariro Faeratima danu uwaraba weiro enanari Yesunu ofe mata. ");
INSERT INTO yrb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mataro Jousefama Yesunu ofe munite reka inawere wadiama wayari. ");
INSERT INTO yrb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Wayare me sinite danu reka gebiro uri ue oeta eraboro ane odite dera gebiro ma uberu uberu ue are bebeto garari uite ekodite ani. ");
INSERT INTO yrb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Megidarinaini etei mui Merini uri oeta kabesi etararo yausite erebisi. ");
INSERT INTO yrb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","I ogaro ue bou ueta kowa me siniro wai uriro i dera fuyo ode sina weta uwaraini Ferosi uwaraini Faeratibai fatate weita, dera amara, etei meo amara bodere me ibebi i odoro wei, kowa rarogonu me sibiro nono uyamau weiro nausite imutaisiba iba farisia weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Eno weiya wiaro anu ami uwarama i uri oeta kabesi kowa rarogonu yawoegou ufita. Danu iwata ueta uwarama Danu ofe waira uotote Dawa uietaroma uyarinu webiotoa weita. Eno ufitaitana Danu duburo meo uetana derawere, Danu auboko botai meo uetana kikiratu weita. ");
INSERT INTO yrb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Weitaro Faeratima wei, yabai ami uwara ibinita. Ema woure odiawero yawofita wei. ");
INSERT INTO yrb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Weiro anita. Ane fatate i dera garari ueta gebiro ma badami uegou utate nama widu utate ami uwara oitaro yawotebita. ");
INSERT INTO yrb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabate kowa me siniro wai kukuro Meri Megidarinaini mui Merini Yesunu uri oeta kabesiro anisi. ");
INSERT INTO yrb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ane fasina nasini derawere wawana wawana ui. Uiro Godinu aneru ureroma tararite i dera gebiro ma uberu uberu ue ane eta odite gebiro deiro amo yaubi. ");
INSERT INTO yrb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Danu ofe ubuna bidanu ario ari. Danu wadiana inawere goso ari. ");
INSERT INTO yrb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","I uri ue oeta kabesi yawotebita ami uwarama aneruba iya derawere uyatate dowatate uieta uwara ari sita. ");
INSERT INTO yrb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","I aneruma i aweta sadeiba wei, iya da uyawa. Na iwata, yana i korosiro oita Yesu doberaisi. ");
INSERT INTO yrb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","7","Dawa ewado me. Dawa uyarinu. Danu wei sina enanari usinu. Danu ainibi kabesi are eawate sau aniawate Danu iwata ueta uwaraba sina wiawa. Ane eno wiawa, Dawa uietaroma uyarinuba Dawa ko Gareri orofaro anibiro iro ane efoita eno wiawa. Yaba ba watane wei. ");
INSERT INTO yrb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Weiro nausite uri oeta kabesi ekoisite iya uyareda neno kirifu usirogo yaru uteda Danu iwata ueta uwaraba webisie durami ue anisi. ");
INSERT INTO yrb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Anisina Yesuma ema dabaro atanite wei, farisi wei. Weiro ema Danu buri gigirari jegirari uteda Dawa guriguri usi. ");
INSERT INTO yrb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Guriguri ue me sisiro Yesuma wei, iya da uyawa. Nanu naiyemutu Gareri orofaro anibitate Na iro efitaita. Aniawate emaba i sina eno wiawa wei. ");
INSERT INTO yrb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","I aweta sadeima dabaro anebisina moana uri oeta yawoeta uwarama Jerusaremu suro anitate i dera fuyo ode sina weta uwarabai fatate emaba i fare me siniro eta ememetu nesia weita. ");
INSERT INTO yrb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Weitaro dera fuyo ode sina weta uwarama nautate weitaro Ju uwaranu dera uwara emabai fata. Fataro sina sina we matatate i ami uwaraba oi mateda weita, i uwara nesiaba eno wiawe, Danu iwata ueta uwarama dumuro fatate ya nauta ainibisiro Danu ofe waira ue mutate anita eno wiawe. ");
INSERT INTO yrb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Romani gaemani dera yawoeta amarama i sina naufisuna yana dawaba eno webero ya fanisi da mafisu weita. ");
INSERT INTO yrb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eno weitaro ami uwarama i oi mutate anitate enanari meo weita. I Ju uwarabai awona i ikiki enanari waita. ");
INSERT INTO yrb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesunu iwata ueta uwara ireweni (11) Gareri orofaro anita. Ane fatate Yesunu wei maidani iro manita. ");
INSERT INTO yrb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mane fatana Yesu inaibiro etate moana arubi uteda guriguri utaro moana imutawa uta. ");
INSERT INTO yrb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesuma emabai farite wei, Godima buna derawere Naba masinuba ureini nasini yawotatane. ");
INSERT INTO yrb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","20","Idoba i orofa atata uwara nesiabai aniawete Godinu sina wiawero naufitate Nanu iwata ueta uwara sibitaro ema babataito uawe. Baba Godinu ifuro Danu Amaranu ifuro Danu Imumu Kotofunu ifuro ema babataito uawete Nanu yaba bunawere we sina emaba enanari we mawetu uawero naufita wei. Yabai ibimaro ureini nasini me sibiro yabai daido ibimau. Ina imue eawe Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Keriso Godinu Amara Danu kotofu sina ewado owawa ue odatane eawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaiya, Godinu we bou ueta amara danu bukaro Godinu sina arotorowa owawa ue odite efene wei, eawe, Nanu fo weta amara botai siaia umaro anibite Danu daba wabue moya ufisu enanari yanu neno wabue moya utebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","I fo weta amarama sina we derawere eme ibawa orofaro inareda iroma webi, Dera Amaranu daba ma nabini ma rorowarau ue bou utebeawe webi, Isaiyama eno owawa ue odi. ");
INSERT INTO yrb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Joni babataito ueta amara eme ibawa orofaro fariro eme faiyawere dawabai are fataro emaba webi, yanu neno neno ueta dubena sawero Godima yanu neno neno ueta mubite imutawa ufiro ya babataito umau wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Eno weiro Judia orofa uwaraini Jerusaremu su uwara nesia emanu neno neno ueta we ma borobatate Jonibai are fataro Jodani ogoro Joni ema babataito ui. ");
INSERT INTO yrb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Joni danu baruetana kemo eginu ofe, danu kafana borumakaunu ofe, danu ietana sisidomuini firukaini itebi. ");
INSERT INTO yrb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jonima wei, duburo mui amara nanu buribi afisuna Danu buna derawere na ari me wei. Na kobererau meba Danu ibo didi da inare tumau wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ogoma babataito utataneba Dana Godinu Imumu Kotofuma ya babataito ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mui kowaro Yesu Nasareta su Gareri orofaroma are Joni babataito utebi orofaro fari. Fariro Jonima Jodani ogoro Yesu babataito ui. ");
INSERT INTO yrb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","11","Babataito uiro Yesu ogoroma duero ido amuteda erina ure eba uiro Godinu Imumu Kotofuma ubani ari Dawabai tarariro ureroma sina tararite wei, A Nanu Amara ubiba Nanu neno Abai ibinuro yaru utatane wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Eno weiro Godinu Imumuma Yesu eme ibawa orofa iro we berairo ani. ");
INSERT INTO yrb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Anite Dawa kowa faiyawere foti (40) iro ane ibebiro seitanima Yesu ue efie Dawabai fari. Yesu awe egini ibebiro aneruma taratate Yesu yawotebita. ");
INSERT INTO yrb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Joni babataito ueta amara diburaro oita. Oitaro duburo Yesuma Gareri orofaro ane farite Godinu kotofu sina webie ani. Anite wei, Godima yawotasu kowa baworo baworo fafie usinuba yanu neno neno ueta dubena afu sawete Godinu kotofu sina naue imue uawe. uawete mune befororo odiawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu Gareri mesau nioro inarebe erina Saimonini danu dabue Enuduruini ogoro iwame sane inarebisiro eri. I amara sadeina erio egi woureta amara sadei. ");
INSERT INTO yrb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesuma emaba wei, Na are yawoawaro anibete ya eme muneta amara sadei odimaro eme we muawaro naueta uwara sibita wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Eno weiro sau emanu iwame ido ekoisite Yesubai are fasiro anita. ");
INSERT INTO yrb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","20","Nono yafa me Yesu aneda Jebedinu amara sadei Jeimisini Joni you ubarero emanu iwame ma wirotebisiro ereda emaba ara wei. Eno weiro sau emanu damamaini waiya ueta uwaraini you ubarero ekoisite Yesunu buribi anibisie dawabai are fasiro anita. ");
INSERT INTO yrb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","22","Kafenamu suro fata. Fatate ibebe sabate kowa wai uriro Ju uwaranu dubu su ubarero amuite we mawetu uiro Danu we mawetu uetaba neno kirifu uta. Danu we mawetu uetana buna derawere. I tarawatu tisa uwara emanu we mawetu uetana buna me. ");
INSERT INTO yrb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Seitaninu mui imumu siosama rewoe ibi amara dubu su ubarero ido amuiro seitaninu mui imumu siosama yua wei, Yesu Nasareta su amara ya seitaninu imumu siosaini ane ue matafene arinu wei? Na iwata A, Ana Godinu kobere amara wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Eno weiro Yesuma wei, da wiate i amarabairoma amuate ania wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eno weiba seitaninu mui siosa imumuma i amara ma iyari iyari uteda arua derawere weda neno ubareroma fare ani. ");
INSERT INTO yrb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","I ereta uwara neno kirifu derawere uteda emanu aika we mataneda ewa ane weita? Reka we mawetu uetana bunawere, seitaninu siosa imumuba wenuro nauitate fare anita weita. ");
INSERT INTO yrb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesunu we mawetu ueta Gareri orofa nesiaro we inarebita. ");
INSERT INTO yrb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ju uwaranu dubu su ekoitate Saimonini Enudurunu su ubarero Yesuini Jeimisini Jonini nesia ido ane amuta. ");
INSERT INTO yrb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","31","Ane amutaro Saimoninu daroya ofe wakikiwere wourite ainibi. Ainibiro Yesubai weitaba arite Saimoninu daroyanu agero munite ma uyariro ofe wakiki toba uiro ofe wiroite ani. Ane emaba ieta mairo ita. ");
INSERT INTO yrb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kowa itariro seitaninu moana siosa imumuma rewoe ibita uwaraini ofe woureta uwaraini nesia Yesubai woure fata. ");
INSERT INTO yrb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Su uwara nesia danu su bebetoro guruguru ubita. ");
INSERT INTO yrb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ofe aika maika woureta uwara faiyawere ma wiroite seitaninu imumu siosa faiyawere we berai. We berairo seitaninu siosa imumu Yesu Dawa iwata utaba emanu sina weta daba garari ui. Iba sina wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wai kukuro Yesu uyarite eme ibawa orofaro anite Godibai guriguri utebi. ");
INSERT INTO yrb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Utebina Saimonini danu domayamutuini uyatate etana Yesu meba Yesu dobere anitate etate weita, eme nesia a doberaita weita. ");
INSERT INTO yrb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Weitaro Yesuma emaba wei, mui suro anibete Godinu sina wemainiaba farea wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Weiro Gareri orofa su suro anitate Ju uwaranu dubu su faiyawerero sina weda seitaninu imumu siosa faiyawere we beratebi. ");
INSERT INTO yrb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Buri age amaima utebi amara Yesubai farite jegirari uteda nui wei, anu unu ufasuna na ma wirofaro wiromau wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","Weiba Yesu neno arama derawere uite burite wei, Nanu unu a ma wiromau wei. Amai me sia weiba ofe amaima ido me siniro wiroi. ");
INSERT INTO yrb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Wiroiro Yesuma buri age amaima me sini amara ido siaia uite wei, eme nesiabai da wiate fuyo ode sina weta amarabai aniate mawetu uaro efi wei. Mosesinu tarawatu buri age amaima fuyo oeta enanari odia. Iba anu ofe kobererau usinu. Iba eno usinuro anu ofe kobererau usinu. I i fuyo ode sina weta uwara efitate iwata ufita wei. ");
INSERT INTO yrb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Eno weiro i amara anedana uwara faiyawerebai Yesunu buna ueta nesia webiba nautate su su uwara faiyawere Dawa ode kara utaba Yesu suro farawa kebiro yaubiro su su uwara Yesubai fata. ");
INSERT INTO yrb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","3","Moana kowa me siniro Yesu owerite Kafenamu suro fari. Fariro nautate ane Danu su ubarero guruguru utate uwarama itare amue ueta su bebeto daba garari uta. Yesuma Godinu sina weina amara mui sadei eno mui sadei eno fata. Age sanawa inarawa amara wia warafaro woutate Dawabai anibitae fata. ");
INSERT INTO yrb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Fare emanu unu su ubarero anibitae utana eme faiyawereba Yesubai anawa utate emanu su fou dei fefewereba emanu amueta adiroma fou deiro amuta. Amutate fou ma eba utate age sanawa inarawa amaraini danu wia warafaini ebaro oitate kekerama mamitaro Yesubai itari. ");
INSERT INTO yrb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Itariro Yesu emanu imueta ereda age sanawa inarawa amaraba wei, nanu amara, anu neno neno ueta munete imutawa une wei. ");
INSERT INTO yrb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eno weiba moana tarawatu tisa uwara beforoma imuteda we imuta, aneba sina eno wasu we imuta. ");
INSERT INTO yrb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Eno we imutedaba we imuta, Godinu ifu ma siosa utasute dawa Godiba sina siosa wasu. I sinana sara siosa sina. Godi torowa neno neno ueta mune imutawa utasu we imuta. ");
INSERT INTO yrb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Eno we imutaba Yesu Dawa emanu imueta Dawa iwataba ido wei, sina aneba nenoma imutaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Weite wei, abo sinama ofe woureta amaraba anene wemau, anu neno neno ueta mumate imutawa umau, aba anu wia muate ania wemau wei. Eno weite wei, abo sinama kimuwere wei? ");
INSERT INTO yrb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Eno weite wei, Na Ba Eme Sire Amara. Nana ewa nasiniro ibeda uwaranu neno neno ueta mune imutawa ueta buna Nabai ibinuba iba eno utatanero yana ereda iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Eno weite age sanawa inarawa amaraba wei, uyate anu wia muate suro ania wei. ");
INSERT INTO yrb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Weiba uyarite aniro eme ereda neno kirifu derawere utate weita, ya bodere eno erawa rairo awona kamama eraisi weita. Iba Godinu ifu we ma derawere uegou uta. ");
INSERT INTO yrb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu nono owerite Gareri mesau gigirari fari. Fariro eme nesia ane guruguru utaro Yesu emaba we mawetu utebi. ");
INSERT INTO yrb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Duburo Yesu inarebe erina Arofiasinu amara Riwai danu takesi muneta su kabesiro yaubiro wei, arate iwata ueta amara sia wei. Weiba uyarite Dawabai fariro anisi. ");
INSERT INTO yrb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesuini Danu iwata ueta uwaraini Riwainu su ubarero yaubeda ieta itebita. Takesi muneta uwaraini neno neno ueta uwaraini faiyawere Danu buribi anitate moana uwara Yesuini yautate ieta itebita. ");
INSERT INTO yrb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Moana Ferosi ema tarawatu tisa uwarama etana Yesuini takesi muneta uwaraini neno neno ueta uwaraini ieta itebitaro etate Danu iwata ueta uwaraba weita, Yesuini takesi muneta uwaraini neno neno ueta uwaraini Yesu aneba emaini ieta eno itasu weita? ");
INSERT INTO yrb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Weitaro Yesu emanu sina nauite wei, i ofe wourawa uwaraba dogeta amara arawa uite i ofe woureta uwaraba fari wei. Weite wei, ya kobererau waita uwaraba sina wemane waya arawa neno neno ueta uwaraba wemane waya farea wei. ");
INSERT INTO yrb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Joni danu iwata ueta uwaraini Ferosi uwaraini emanu baeta tarawatuba moana kowaro torowa ieta itawa ka utebita. I kowaro eno utebitana moana uwarama fare Yesubai weita, Joninu iwata ueta uwaraini Ferosi iwata ueta uwaraini ieta itawa. Anu iwata ueta uwarade, aneba ieta itaita weita? ");
INSERT INTO yrb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Weitana Yesuma moko wei, i aweta reka mubisu amara danu ogaroratu ufiro danu domayamutu i ogaroratu da ifitaita? Ema enona me! I reka aweta mubisu amara danu domayamutubai ibifisuba ogaro are ifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mui kowaro aweta reka mubisu amara anibisuna ogaro da ifitate ka ufitaita. Enanari Na animauna Nanu iwata ueta uwara eno ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Anama reka wadia fifima bodere wadia ebaro fifinu ufisuna i bodere wadia babafite eba derawere ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Enoba nauawe. Anama reka waini bodere egi ofero adu ufisuna reka wainima bodere egi ofe babaosote itaosoba. I reka wainima bodere egi ofe ma arama ufisu. Iba i reka waini reka egi ofero adu ufisu wei. Yesuma i bodere tarawatunu we mawetu uetaini Danu reka we mawetu uetaba kasei wei. ");
INSERT INTO yrb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mui sabate kowaro Danu iwata ueta uwaraini feame waiya dabaro inareda Danu iwata ueta uwarama feame ma gogorugari ue ferae ie inarebita. ");
INSERT INTO yrb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Eno utebitaba Ferosi uwarama etate Yesuba weita, sabate kowaro eno aneba utaita weita? Yanu tarawatuma wasu, sabate kowaro eno da uawe wasu weita. ");
INSERT INTO yrb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Weitana Yesuma emaba wei, boderewere Deiwidini danu uwaraini osi utebiba ieta munebita ikiki yawitaitatema nono iwawa utaita. Eibieta Godinu dera fuyo ode sina weta amarama yawotebiro Deiwidi Godinu su ubarero amuite dera dubu su yawoeta uwaranu Godinu ereta kakara buredi mune iteda danu uwaraba mairo ita wei. ");
INSERT INTO yrb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Eno weite wei, Godima eme ko ubu uite nono duburo i sabate kowa emeba ubu uiba iba i Ba Eme Sini Amara, Dana i sabate kowaini daido yawotebasu wei. ");
INSERT INTO yrb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu nono i dubu su ubarero amuite erina age arama amara ido yaubi. ");
INSERT INTO yrb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ido yaubiro i uwarama Yesu ereda we imuta, Yesu i amara ewa sabate kowaro ma wirofisu aba me we imuta? Iba Yesu sabate kowa ma arama utasu we imutate wawei webitae erebita. ");
INSERT INTO yrb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesuma age arama amaraba wei, uyate abanaro ina wei. ");
INSERT INTO yrb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","5","Eno weite i uwara nesiaba wei, aboma kobererau, sabate kowaro durua umau aba ma siosa umau? Ma wiromau aba ma uimau wei? Weina wate muma utaro Yesu ibo ui. Ibo uteda i uwara nesia ere owere owere uite emanu Dawaini aya muneta iwata uite i age arama amaraba wei, anu age sa, weiba age saniro rorowarau uiro wiroi. ");
INSERT INTO yrb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","I Ferosi waita uwarama Ju uwaranu dubu suroma wawaro itata. Itataro moana Erodi waita uwara wawaro atatate we mataneda Yesu ma uieta daba doberebita. ");
INSERT INTO yrb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuini Danu iwata ueta uwaraini mesau gigirariro anitaro Gareri orofa uwaraini Judia orofa uwaraini Yesunu buribi anitate Yesunu we mawetu ueta nauta. ");
INSERT INTO yrb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","9","Nautate eme faiya faiyawere Yesubai ata. Gareri orofa uwaraini Judia orofa uwaraini Jerusaremu su uwaraini Idumeia orofa uwaraini Jodani etarafu orofa uwaraini Taira su uwaraini Saidoni su uwaraini eme faiyawere nautate ataba Yesuma Danu iwata ueta uwaraba wei, jamana mune bou uawe wei. I uwarama Dawa taka uotoba. ");
INSERT INTO yrb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bodere ofe woureta uwara ma wirotebiba faiyawere reka ofe woureta uwara emanu unu Dawa burifitate wirofitae fata. ");
INSERT INTO yrb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","I seitaninu moana siosa imumuma rewoe ibita uwarama Yesu etate deuwataro seitaninu moana siosa imumuma weita, Ana Godinu Amara weita. ");
INSERT INTO yrb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Weitaba wei, Nanu ifu da we ma boroyawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu maidaniro manite Danu unu utebi uwara yua weiro mare fata. ");
INSERT INTO yrb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Yesu eme nesina tuero (12) Dawaini ibetaba munite Danu sina webiro webitae munite seitaninu siosa imumu mune saneibitae buna derawere mai. ");
INSERT INTO yrb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Emanu ifu ewado. Saimoni reka ifu Fita mami. ");
INSERT INTO yrb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jebedinu amara sadei Jeimisini danu dabue Joni reka ifu Boanari mami. I ifunu ubina ure ruruanu adarabu mami. ");
INSERT INTO yrb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Enuduruini Firifini Batoromiuini Matiuini Tomasini Jeimisini dawa Arofiasinu amara Tediasini Keinani amara Saimonini Judasi Isikarioti, i amara Judasi Yesuba do mai amara. I uwara nesiaba Yesuma yua weiro fata. ");
INSERT INTO yrb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesuini Danu iwata ueta uwara su ubarero amuta. Amutaro eme faiyawere guruguru utaba Yesuini Danu uwaraini ieta itawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","I amara gogore usinu weitaba Yesunu su uwara nautate Yesu mubitae fata. ");
INSERT INTO yrb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moana tarawatu tisa uwarama Jerusaremu suroma fatate weita, Danu nenoro Biesabo ibinuba emanu botai siosa imumunu bunaroma seitaninu siosa imumu we beratasu weita. ");
INSERT INTO yrb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Eno weitana Yesuma arawe weiro fata. Fataro kasei sinaroma wei, anene seitani danu aika mune sanebasu wei? ");
INSERT INTO yrb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gaemani uwara emanu aika uraneda saragari ufitate da inafitaita. ");
INSERT INTO yrb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Su demurai uwara emanu aika uraneda saragari ufitate da inafitaita. ");
INSERT INTO yrb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Seitani danu aika uraneda saragari ufisuna da ibifisu. ");
INSERT INTO yrb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Enoba ewa sina nauawe wei, waira ueta amarama buna derawere amaranu su ubarero amufite buna amaranu age uwane tarifite danu ibaiabai waira ufite anibisu eno wei. ");
INSERT INTO yrb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yaba ba watane wei. Eme nesianu siosa uetaini sara siosa wetaini Godima mubite imutawa ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nono anama Godinu Imumu Kotofuba sara siosa sina webisuna Godima ewa siosa ueta da mubite imutawa ufiro danu sara siosa ueta dawabai ibene ibene ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","I tarawatu tisa uwarama auboko eno weita, Dana seitaninu mui imumu siosa bobo weitaba Yesu ewa kasei sinaroma wei. ");
INSERT INTO yrb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Danu danuaini Danu daburetaini atate wawaro inatate Yesubai sina webitae weita. ");
INSERT INTO yrb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Weitaro eme faiyawere Yesubai yaubitaro moana uwara Yesubai fatate weita, Anu anuaini aburetaini arumamini kebiro inaibeda a wenaueraita weita. ");
INSERT INTO yrb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Weitana Yesuma wei, Nanu bayaini naburetade anaiya wei? ");
INSERT INTO yrb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I guruguru ubita uwara ereda wei, eawe Nanu bayaini naburetaini ewado wei. ");
INSERT INTO yrb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Abo uwarama Godinu sina nauegou ufitate Dana unu ufitaitana emana Nanu bayaini naburetaini Nanu arumamini wei ido. ");
INSERT INTO yrb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","2","Mui kowaro Yesuma maguaro we mawetu utebiro eme faiyawere inare kara uta. Eno utaba youro amuite yaubiro i uwara enea gigirariro inaibita. ");
INSERT INTO yrb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Yesuma imueta faiyawere kasei sinaroma webie wei, Nanu sina nauawe, mui amara uiti yo waifie waiya umanite jiru turite nasini daure bou uite yo munite sanebi. ");
INSERT INTO yrb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sanebiro moana uiti yo dabaro itataro gasirama are fatate i uiti yo ie me sita. ");
INSERT INTO yrb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Moana yo gebiro duboro itatate sau warata. ");
INSERT INTO yrb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Warataro nasini awewewereba kowa farite yanairo ini fuyaraturo ini kimu meba yare yoie me sita. ");
INSERT INTO yrb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Moana uiti yo sinisini bobo orobu ubarero itatate warataro orobuwereba tai uwanawa. ");
INSERT INTO yrb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Moana uiti yo kobere nasiniro itatate waraegou utate tai faiyawere uwata. Moana faiya nono uwata, tai demurairoma tai nesia toti (30) uwata. Moana faiyawere uwata, tai demurairoma tai nesia sikisiti (60) uwata. moana faiya faiyawere uwata, tai demurairoma tai nesia wani aderedi uwata (100) wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Weite eno wei, ya ome bobo aba me? Ome bobo uwarana ewa Nanu sina nauegou uawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","11","Duburo i guruguru uta uwara anitaro moana inaibita uwaraini Danu iwata ueta uwara nesia tuero (12) i kasei sinanu ubi dobetate weitaro wei, Godima Danu ureroma nesia yawoe anasu kiwu sina ma borobarasuro ya iwata utaita. Nono Godinu sina nautawa uwara kasei sinaroma torowa nautaitate kasei sinanu ubi iwawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ewa Godinu sina nauawe. I Nautawa me uwarama i kobere ueta eraita. Eraitate nono i ba ubina erawa utaita. Nauetana nautaitate nono i sinanu ubi nauegou utawa. I sina nauegou uotote emanu neno neno ueta dubena saotoro Godima mune imutawa uosoba eno utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuma wei, ewa kasei sina ya iwata aba me ari? Iwata da ufoitana mui kasei sina anene iwata ufoita? ");
INSERT INTO yrb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","I yo waieta amara Godinu sina we inareta amara ari. ");
INSERT INTO yrb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","I dabana Godinu sina nautaita moana uwara ari. I amara Godinu sina we inarasuro i dabaro inaraita uwarama Godinu sina nautaitaro seitani sau farasute i sina emabairoma daido ma siosa utasu. ");
INSERT INTO yrb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Weite wei, i moana uiti yo gebiro deiro itari enanari moana uwara i gebiro ari wei. I uwarama Godinu sina nautaitate yaru utaitaro Godinu sinaba awe uyareta farasuro emanu naueta kimu me, emanu naueta i yo ini fuyaratu ari, iba i sina ekodaita. ");
INSERT INTO yrb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Moana uwara ema orobu ariba Godinu sina nautaitate aika maika imutaitate emanu unu ibaiabai munaitate emanu unu nesia utaitate i sinanu daba garari utaitaba i sina ba sinawa utasu. ");
INSERT INTO yrb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Moana uwara ema kobere nasini ari. Godinu sina nautaitate imuegou uteda emanu kobere ueta yawietana faiyanono toti (30) ari utaita. Moana uwara faiyawere nautaita, emanu kobere yawietana sikisiti (60) ari utaita. Moana uwara faiya faiyawere nautaita, emanu kobere yawietana wani aderedi (100) ari utaita, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuma eno eno weite emaba wei, nanefa beafote okia ubarero odifoita aba warafa wowonaro odifoita? Eno wenauerite wei, me, aiyo oeta kabesiro odifoita kasei sinaroma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Eno weite wei, mui kowaro i feare ibeta ememetu nesiaini ma borobafite kiwu imuetaini ueta nesia Godima ma borobafite arioro odifiro efitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ya ome bobo uwara Nanu sina nauegou uawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Emaba nono wei, yanu nautaita ememetu imuegou uforo wei. Yanu naueta Godibai kikiratu odifoitana yanu naueta ma kikiratu ufisu. Yanu naueta Godibai odegou ufoitana mui naueta mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Naueta derawere bobo amaraba mui naueta mafite deramiratu naueta bobo amara danu kikiratu naueta ma dare mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuma nono wei, Godinu yawoe anasu kowa ewa sina ari. Mui amara yo munasute waiyaro ane farasute oritasu. ");
INSERT INTO yrb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nono aine uyare aine uyare enoma enoma utasuro yo tua faraitate warataita. Yo tua anene faraitate warataita ari dawa iwata me. ");
INSERT INTO yrb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nasini torowama ma waratasuro tua faraitate tata odaitate derawere utaitate uwanaitate ayo uraita. ");
INSERT INTO yrb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ayo uraitaro tai woureta kowa ido farasuba kaiyama ido turasu wei. I Godinu yawoe anasu kowa ewa sina ari Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuma wei, Godinu yawoe anasu kowa abo ari wemau? Godinu yawoe anasu kowa abo kasei sina ari wemaro naufoita wei? ");
INSERT INTO yrb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Eno weite wei, Godinu yawoe anasu kowa masita ana tai ari. I tai deramiratu waitasuro ana derawere waratasuro gasira nesia utumuro yaubaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","I uwarama Danu sina naufitae utaba iba Godinu sina kasei sinaroma faiyawere webi. I uwara nesiaba wawuriro wiawa, kasei sinaroma torowa webi. Nono duburo Dawaini Danu iwata ueta uwara emanu aikana i sinanu ubi we ma borobariro nauta. ");
INSERT INTO yrb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yawi siniro Yesuma Danu iwata ueta uwaraba wei, mesau etarafu yofefe wei. ");
INSERT INTO yrb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","37","Weiba uwara fefera ekoitate Dawa woure ane youro amutate anita. Moana youini anitaro oyau derawere farite ufe uyariro you inufie ui. ");
INSERT INTO yrb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesuma you muduna afu gutoro nauta ainibiro ma uyareda weita, Tisa Amara, ya uifene utaisi. A imutasu aba me weita? ");
INSERT INTO yrb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Weitaro uyarite oyauini ogoba bunawere kodia weiro oyauini ogoini ido me sinite binono sani. ");
INSERT INTO yrb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu emaba wei, aneba iyareda imutawa utaita wei? ");
INSERT INTO yrb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Weiro neno kirifu utate iyatate weita, i amara abo amararo oyauini ogoini Danu sina nauita weita? ");
INSERT INTO yrb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesuini Danu uwarama Gerasini orofa, mesau etarafu iro yofere ane inata. ");
INSERT INTO yrb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ane inataro Yesu amo inariro seitaninu moana imumu siosa rewoe ibita amara Yesubai are fari. I amara eme uri ue oeta eraboro ainebi. ");
INSERT INTO yrb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Ainebiro danu su uwarama iyareda danu burini ageini aiyonima uwanebitaro ma furufarebiba eme nesia dawa yawoegou utawa utebita. ");
INSERT INTO yrb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dumuini kowaini eme uri ue oeta eraboroini maidaniroini inareda arua weda gebiroma danu torowa umanebi. ");
INSERT INTO yrb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Yesu inaibiro seitaninu moana imumu siosa rewoe ibita amara yafawereroma erite durami ue Yesunu iboro arite arubi uiro dawabai ibita seitaninu moana siosa imumuma derawere weita, Yesu, Dera Urero Ibinu Godinu Amara, yaba ane ufae utasu weita? Eno weitate weita, Godi Dawa erasua ya fanisi da mai weita. Auboko Yesuma seitaninu moana siosa imumuba amua weiba iba iyareda eno weita. ");
INSERT INTO yrb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesuma wei, yanu ifu anaiya wei? Weina yanu ifu fefera. Iba faiya faiyawere ibinisi weita. ");
INSERT INTO yrb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ewa orofaroma aniawe da wia weita. ");
INSERT INTO yrb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Borosiri faiyawere maidaniro ibeda emanu torowa gusuna ue itebitaro seitaninu moana siosa imumuma Yesubai weita, wiaro anibete borosirinu ubarero itafe weita. ");
INSERT INTO yrb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","13","Eno weitaro Yesuma wei, aniawe weiba fare anitate borosirinu ubarero itata. Itataro borosiri nesia faiyawere tu tausani (2,000) durami ue anitate maidaniroma mesauro bibu utate imuie me sita. ");
INSERT INTO yrb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Enoba i borosiri yawoeta uwara emanu suro durami ue anedana uwara nesiabai weitaro su uwara mesauro fare etate Yesubai fata. ");
INSERT INTO yrb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Fare etana i seitaninu moana siosa imumu faiyawerema rewoe ibita amara danu beforo kobererau uiro wadia yurite yaubiba etate i uwara iyata. ");
INSERT INTO yrb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","17","I uwarama seitaninu moana siosa imumuini boronu ueta nesia etate weitaro i uwara nesiama Yesuba weita, yanu orofaroma ekodiate ania weita. ");
INSERT INTO yrb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesuma youro amuiro i seitaninu moana siosa imumu me sini amarama wei, naini anibu wei. ");
INSERT INTO yrb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Weina Yesuma wei, me, aniate Godinu bunaini neno arama ueta nesia anu su uwarabai wia weiro ani. ");
INSERT INTO yrb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Anite Dikaforisi su teni (10) ibita orofaro ane Yesunu bunaini neno arama ueta nesia we inarebiro i uwara nesia nautebitate neno kirifu utebita. ");
INSERT INTO yrb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","23","Yesu owerite mesau yofere ane inari. Inariro eme faiyawere ode kara utate inaibitaro Ju uwaranu dubu su yawoeta amara, Jairasi, are farite Yesunu iboro arubi uteda wei, nanu arumaratu uifie utasu. Araro anibute anu age danu deiro odiaro wirofi wei. ");
INSERT INTO yrb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Weiro ido aniro eme faiyawere Yesunu buribi deiro deiro ue anita. ");
INSERT INTO yrb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","26","Mui awetaini anita. I aweta ofe derawere wourite onono munebi. Oya tuero (12) muneda dogetabai inarebi. Oya tuero danu oi sane me sinite wirotawa ofe derawere daido ibebi. Ibebiro iro Yesunu buna ueta nauite iba ani. ");
INSERT INTO yrb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Yesu inarasu weitaro nauite we imui, Danu wadiaro burimauna na wiromau we imui. Eno we imuite anite Yesunu wadiaro burina onono didi ido turiba wiroite na wironea we imui. ");
INSERT INTO yrb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","I aweta Yesunu wadia burina Yesunu buna i awetabai aniba ma wiroiro Yesu Dawa iwata ui. Iwata uite iba i uwaraba wei, Nanu wadiaro anama burisinu wei? ");
INSERT INTO yrb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Weina Danu iwata ueta uwarama weita, ea, ode kara ubinitaba emana burita aba? Aneba anama Na burisinu wasu weita? ");
INSERT INTO yrb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","34","Weitaro Yesu eta ere ewa ere uiba i aweta iyareda iwura mami. Yesunu buna Dawabai aniba iwata uteda Yesubai are arubi uite danu ui i kiwu utawa we ma borobareda ba sina weina Yesuma wei, aruma, anu nauetama a ma wirosinua da iyate ania. Anu oferi daido me sininuro wirosinu wei. ");
INSERT INTO yrb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuma eno webina mui amara Ju uwaranu dubu su yawoeta amaranu suroma are farite Jairasiba wei, anu aruma uisinua. Tisa Amarabai woroworo sina da wia wei. ");
INSERT INTO yrb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Weiro Yesuma nauite Jairasiba wei, iya da uyate kimuwere imuea wei. ");
INSERT INTO yrb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Weite i uwara nesia kodite Fitaini Jeimisini Jeimisinu dabue Joni woure ane dubu su yawoeta amaranu suro fari. ");
INSERT INTO yrb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Farite sorara nauite i sorara utebita uwaraba wei, ane utaita? Aneba sorara utaita? I aruma uitawa, nauta kunawere ainibinu wei. ");
INSERT INTO yrb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Weiro we iruteda yo weitaro i uwara nesia wawaro odiro itata. I aruma danu danuaini damamaini Fitaini Jeimisini Joni ema torowa su ubarero yaubita. ");
INSERT INTO yrb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu i arumanu agero munite wei, tarita kumi, i sinanu ubina arumaratu aba watane uya, eno wei. ");
INSERT INTO yrb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Weiro i daisinono ui aruma uyarite inarebiba i yaubita uwarama etate neno kirifu derawere uta. ");
INSERT INTO yrb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesuma wei, moana uwaraba da wiawete i aruma ieta mawero ifi wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jairasinu orofa ekodite Dawaini Danu iwata ueta uwaraini Danu orofaro anita. ");
INSERT INTO yrb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mui sabate kowaro Ju uwaranu dubu su ubarero amuite we mawetu utebi. Eno utebiro eme faiyawere imutebitate neno kirifu utate weita, Danu we mawetu uetaini iwata ueta ina aboro muninu? Danu iwata derawere anama masinu? Danu ueta buna derawere anene utasu? Ya iwata me weita. ");
INSERT INTO yrb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","4","Weitate weita, ewa amarana su ma inareta amara aba me? Danu danua Merini Danu dabureta Jeimisini Jousefaini Judasini Saimonini Danu arumamini yabai ibinita weita. Weitate Dawana dera amara me weda naue nautawari utaro Yesuma wei, Godinu we bou ueta amara moana uwarama eno imutaita. Nono danu su ubi uwara eno imutawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Eno uteda eno imutebita ueta buna derawere utawa ui. Ofe woureta uwara torowa demui demui Danu age deiro odiro wirota. ");
INSERT INTO yrb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Emanu imutawaba Yesuma neno kirifu ui. ");
INSERT INTO yrb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mui kowaro su su we mawetu ue inarebi. ");
INSERT INTO yrb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","I kowaro Yesuma siaia ufiro anibitae weiro Danu iwata ueta uwara tuero (12) Dawabai fata. Fatate sadei sadei aneibitate seitaninu moana siosa imumu mune saneibitae buna derawere maite wei, ietaini yoateini oini da mubote akurini sadoroini barueta wadia demurai torowa muboita wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mui natofo suro fafote mui suro amufote ibeda yanu sina i su uwaraba we me sibote aniboita wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mui su uwarama ya da mubitate yanu sina da naufitaitana yanu dubena emabai sawete aniawe. Eno ufoitana Godima ema da mubisu eno iwata ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eno weiro anitate weita, yanu neno neno ueta dubena sawe weita. ");
INSERT INTO yrb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Eno webitate seitaninu siosa imumu faiyawere we beratebitate ofe woureta uwara faiyawere emanu kofiriro oera odebitate ma wirotebita. ");
INSERT INTO yrb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Uwara nesia Yesunu ueta sineta iwata utate weitaro Erodi, gaemani dera yawoeta amarama nauite ina iwawa uiro moana uwarama weita, Joni babataito amara uietaroma uyariba buna ueta derawere utebi weita. ");
INSERT INTO yrb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Moana uwara eno weita, etei amarana Iraija weita. Moana uwara eno weita, Dawana Godinu we bou ueta amara, bodere we bou ueta uwara ari weita. ");
INSERT INTO yrb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Weitaro dera yawoeta amara Erodi i sina nesia nauite wei, ewana Joni. I amaranu nodo nana turero uietaroma uyari wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Bodere Erodima danu dabuenu aweta Erodiasi muniro Jonima wei, anu abuenu aweta muneta siosawerea kodia wei. Weiro Erodiasima ibo uite Joni ma uifie imui. Eno imuiro Erodi iyarite dawa iwata Jonina Godinu kobere amara, dawa iwata uiba Firifinu aweta Erodiasima Joni ma uitawa uite webe webe webe wei. Weiba Erodi danu uwara siaia uiro anitate Joni mune diburaro oitaro Erodima Joninu sina naufie anebite nauteda iwawa utebi. ");
INSERT INTO yrb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nono Erodi danu danuama dawa muni kowa fariba ogaro derawere uite weiro danu dera su uwaraini danu dera meremere uwaraini Gareri orofa dera uwaraini ido are fata. ");
INSERT INTO yrb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Fataro Erodiasima we imui, Joni ma uieta kowa farinua we imui. Erodiasinu aruma emabai farite yaura urebiro esega uwaraini Erodini yaru utaro Erodima wei, anu unu ane mamane webate nanu yawotatane orofa muduna mamane webasuna mamau wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Weiro i aruma danu danuabai ane wei, baya, ane wemau wei? Weiro wei, aniate Joni babataito amaranu kofiri mai wia wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Weiro owerite Erodibai ane farite wei, Joninu kofiri naberero awona odiate mai wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Weiba Erodi neno siosa ui. ");
INSERT INTO yrb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Auboko danu we bou ui sina weiro esega uwarama nautaba enanari ui. ");
INSERT INTO yrb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Enoba Erodima weiro danu meremere amara diburaro anite Joninu nodo ture kofiri naberoro odite owerite i arumabai are farite mai. Mairo munite ane danu danuabai mai. ");
INSERT INTO yrb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Joninu buribi inareta uwara nautate ane danu ofe mutate ane eme oeta eraboro uri ue oita. ");
INSERT INTO yrb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesunu iwata ueta uwara botai siaia uiro ane inarebe nono owetate Yesubai are fatate emanu utebita nesia weita. ");
INSERT INTO yrb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Uwara faiyawere ane fare ane fare enoma enoma utebitaro imoitawa, ieta itawa utebitaba Yesuma wei, eme ibawa orofaro anibete imoife wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eno weiro youro anitaro uwara faiyawere etana Yesu anebiba ema iwata Danu anebi orofa iba atate su suroma i orofaro ema ko fata. ");
INSERT INTO yrb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","34","Ema ko fataro Yesuini Danu iwata ueta uwaraini duburo fata. Fatate Yesu youro inarite i uwara nesia eri. I uwara nesia mamoe ari, yawoeta amara meba daba aika maika anebita enanari i uwara imueta aika maika imutebitaba Yesuma neno arama uite we mawetu utebi. ");
INSERT INTO yrb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Yawi siniro Danu iwata ueta uwara Dawabai are fatate weita, ewana eme ibawa orofa kowa itafie utasuba wiaro su aboro aboro anibitate ieta oiya ufitae weita. ");
INSERT INTO yrb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Weitaro Yesuma wei, ieta mawe weiro weita, ieta oiya ufene wasu weita. Weitate weita, mui amarama oya demurairo munasu oi derawere ina ewa arotorowa weita. Nono aneme ieta oiya ufeisi weita. ");
INSERT INTO yrb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Weitaro wei, aniawete buredi abo abo yabai ibinu? Ane eawe wei. Weiro ane etate owetate weita, buredi fai ibinu, erio egi sadeini ibinua weita. ");
INSERT INTO yrb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Weitaro Yesuma wei, wiawero kabesi aika maika yaufita wei. Weiro mui kabesiro uwara wani aderedi (100) yauta. Mui kabesiro uwara fifiti (50) yauta. ");
INSERT INTO yrb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Enoma enoma utaro Yesuma buredi faini erio egi sadeini munite urero ereda Godi we ma kobererau uteda guriguri uite ma birabiarite Danu iwata ueta uwaraba mai. Mairo buredini erio egini i guruguru ubita uwaraba nata nata utaro ita. ");
INSERT INTO yrb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Itaro dia uriro iwoiwo mutate bosio youtaro bosio tuero (12) wate fata. ");
INSERT INTO yrb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eme faiyawere, fai tausani (5,000) ieta ita. ");
INSERT INTO yrb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu Danu iwata ueta uwara ema ko boutiroma siaia uiro Besaida suro anebita. ");
INSERT INTO yrb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","47","Anebitaro Yesuma i uwara fefera siaia uiro anita. Anitaro Dawa maidaniro manite guriguri utebi. Wai ufie utebiro Danu aika nasiniro ibiro you mesau abanaro ibi. ");
INSERT INTO yrb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesuma erebiro oyau derawere fariro i uwara jawe urebitana you anawa utebi. ");
INSERT INTO yrb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Wai ufie uiro Yesu ogo deiro burima inare inare aneda you serigari ufie ui. ");
INSERT INTO yrb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","51","Eno uiro Danu iwata ueta uwarama Dawa ereda imumu aba ane eraisi weitate iyareda weitaro wei, iya da uyawete neno kimu uawe. Ewana Na wei. ");
INSERT INTO yrb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Weite youro amuiro oyau me sini. Oyau me siniro neno kirifu uta. Emanu neno kimuwereba buredini erio egini mairo ita i ueta iwata utawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Youro yofere ane Genesareta orofaro inata. ");
INSERT INTO yrb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Inataro uwara faiyawere Yesu etana ema iwataba anitate ofe woureta uwara woutate Yesunu yaubi kabesiro woure fata. ");
INSERT INTO yrb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Yesu kiki suro o dera suro o waiyaro aboro aboro anebiro ofe woureta uwara woutate fataro weita, Anu wadia fifiro burifete wirofene farisia weita. Weitate ana anama Yesunu wadiaro buriteda wirotebita. ");
INSERT INTO yrb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Moana Ferosi waita uwaraini tarawatu tisa uwaraini Jerusaremu suroma fatate Yesu atata. ");
INSERT INTO yrb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Atatate etana Danu iwata ueta uwara ieta iteda age urotawa utebitaro eta. ");
INSERT INTO yrb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Ferosini Ju uwaraini emanu sirorari baeta edono utebaita. Ieta itebaitana age uroegou utaita, o sitowaroma suro faraitana ieta itawa botai age uroegou utaita. Mui baeta deina! Kafusini okiaini naberoini enoma enoma uroegou utebaita. ");
INSERT INTO yrb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ferosi uwaraini tarawatu tisa uwarama Yesuba weita, Anu iwata ueta uwara yanu baeta uwaranu ueta sina munawa. Age urotawa ieta itaita weita. Aneba eno utaita weita? ");
INSERT INTO yrb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Weitaro wei, ya sara siosa ueta uwara, Isaiyama yanu eno utaita iba owawa ue odiro enanari utaita. Ya meo bobo uwarade, Yesuma weite wei, Isaiyama eno ba owawa ue odi, ewa uwaranu neno kimuwereba Naba nenoma imutawa bebetuma torowa wegou utaitate emanu guriguri Nabai me sara utaita. Emenu imuetana Godinu imueta eno waita, Isaiyama yaba eno weiya wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesuma nono wei, Godinu tarawatu utawa, emanu baeta torowa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Godinu tarawatu ekodaitate emenu baeta ueta munaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesima eno wei, yanu yanua yamamanu sinaini uetaini nautebeawete ititi kakara bobo yawotebeawe weiya wei. Weite wei, anama danuaini damamaba sina siosawere webisuna ma uiawe Mosesima eno weiya wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Weite wei, nono ya eno waita, mui amara danu danua damamaba eno wasu, nanu me maeta ibaiabai kobaniba yaba da mamau. I sinanu ubina Godiba me maeta, iba da mamau wasu, waita. ");
INSERT INTO yrb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","13","Eno waitaba emanu danua damamaba durua utawa uteda Godinu tarawatu abe sanaitate emenu baeta ma uyaraita. Yanu baeta deina enanari utebaita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mui kowaro Yesuma i uwaraba weiro are fataro wei, Nanu sina nauegou uawete iwata uawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ieta nesia mui amaranu ubarero anibitaitana da ma siosa ufitaita. Ietama dawa da ma siosa ufitaro ubareroma wawaro amufitaita ememetuma dawa ma siosa ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","17","(Ome bobo uwara ewa sina nauawe!) Eno weite i uwara nesia ekodite su ubarero amuiro Danu iwata ueta uwarama weita, kasei sinanu ubi anene weita? ");
INSERT INTO yrb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Weitaro wei, ya iwata aba me wei? Ieta nesia mui amaranu nenoro da anibitate desiniro anibitaro duburo wisi areta kabesiro fafitaita iba i amara ma siosa da ufitaita wei. Weina ietata nesiana kobererau weda wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ane ane neno ubareroma amufitaro bebetuma webisuna ina ima i amaranu neno ma siosa ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","23","Weite nono wei, nenoroma ememetu amufitaitana i amara ma siosa ufitaita. Siosa imuetaini aruma dita yagera faretaini waira uetaini eme uretaini aweta dita yagera faretaini yaru ue diti ure owere ma owere uetaini neno ka uetaini iruetaini siosa uetaini meo wawei wetaini meo wetaini sasae uetaini me sara uetaini nesina nenoroma wawaro amutaitana ima i uwara ma siosa utaitaro iba siosa ueta utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu eno weite i Gareri orofa ekodite Taira subai orofaro fari. Farite mui suro kiwuma amuite ibiro i uwara iwata uta. ");
INSERT INTO yrb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mui aweta, danu seitaninu mui siosa imumuma rewoeta bobo arumaratunu danua dana nauite ido are farite arubi ui. ");
INSERT INTO yrb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","I aweta Ju aweta me, dana Guriki aweta. Danu suna Sairofonisia. I aweta fareda arubi uite nui wei, i seitaninu mui siosa imumu nanu arumanu ubarero rewoe ibinua we beraro anibi wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Weiro Yesuma wei, koiniboro ieta iteibitaro dia ureibiro kuasiriba mateibitaro iteibitaita wei. I kasei sinanu ubina edono, Ju uwarama Godinu sina botai mubitaro nono aika uwara Godinu sina duburo mubitaita weda wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","29","Weiro wei, Dera Amara, ba wasu wei. Weite nono wei, i kuasiri koiniboronu ieta fufuno iteibitaita weina Yesuma wei, i sina ido rorowarau wenuro siosa imumu anu arumabairoma fare ainua, anu suro ania wei. ");
INSERT INTO yrb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eno weiba anite ane suro farite erina seitaninu mui siosa imumu i arumaratubairoma fare aniro i arumaratu me ainibi. ");
INSERT INTO yrb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuma Taira suini orofa ekodite Saidoni suini orofaro ane fari. Ane farite nono iroma owere Gareriro ani. Anedana i orofaini suini ekodite iroma ainewaure ue inarebe ane Dikaforisi orofaro farite iroma ane Gareri mesauro fari. ");
INSERT INTO yrb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iro ane fariro moana uwarama sina nautawa wegou utawa sina siosa webi amara woutate fareda weita, Anu age danu deiro odia weita. ");
INSERT INTO yrb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","34","Weitaro Yesuma i amara wawaro woure anite Danu age rorou i amaranu omero sanite witua uite i amaranu meana burite urero erite nenoma saneda wei, efata, i sinanu ubina uregari ua. ");
INSERT INTO yrb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eno weina i amara danu ome ido tarae yariro sina nauite sina kobererau webi. ");
INSERT INTO yrb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","I amara eno webiro Yesuma emaba wei, ewa ueta moana uwarabai da wiawe wei. Weiro nautawa utate daido webita. ");
INSERT INTO yrb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Emanu neno kirifu derawere utate weita, Danu ueta nesia uegou utasuba ome nautawa uwara nautaitaro sina wiawa uwara sina waita weita. ");
INSERT INTO yrb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Mui kowaro eme faiyawere guruguru uta. Utate ieta meba Yesu Danu iwata ueta uwaraba weiro fataro wei, i uwara Nabai kowa rarogonu ibinitaro ieta meba Na neno arama utatane wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Weite wei, odimaro anibitaitana emanu su yafawereba anebe dabaro osima uifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","6","Weiro weita, eme ibawa orofade ieta aboro mubero ifitae weitaro wei, yabai buredi aboabo ibinu wei? Weina buredi seweni (7) ibinu weita. Weitaro Yesuma i guruguru ubita uwaraba wei, yauawe weiro yautaro buredi munite Godi we ma kobererau uite we imuteda guriguri uite ma birabiarite Danu iwata ueta uwaraba mairo mutate mataro ita. ");
INSERT INTO yrb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kiki erio egi dawa meratu enanari uite maite ewa mawe weiro mataro ita. ");
INSERT INTO yrb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Itaro dia uriro ieta iwo muduna bosio nesia seweni (7) youta. ");
INSERT INTO yrb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eme faiyawere (4,000) uwarama ieta ita. Itaro Yesu ema odiro anita. ");
INSERT INTO yrb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Anitaro Yesuini Danu iwata ueta uwaraini youro anitate Damanuta orofaro ane inata. ");
INSERT INTO yrb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ferosi waita uwara fatate yaraneta sina weitate Yesu wenauereda weita, moana buna ueta uaro ureroma fafiro efe weita. ");
INSERT INTO yrb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Weitaro neno siosa uite neno saneda wei, ewa uwara aneba mui buna ueta doberaita wei? Nauawe wei. Mui buna ueta ewa uwaraba da umau weite i uwara ekodi. ");
INSERT INTO yrb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ekodite youro yofere mesau etarafu ani. ");
INSERT INTO yrb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","15","Yesunu uwara buredi faiyawere munawa demurairatu torowa mutate anitaro wei, eforo wei. Ferosini Erodi uwaranu wawareta ira yisiti eforo wei. Wawareta ira yisiti kikiratu odifitaro i buredi ma derawere utebasu enanari emanu we mawetu ueta derawere ufiro uwara faiyawere naufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eno weiro emanu emanu we mataneda weita, ya buredi munawaba iba eno wasu weita. ");
INSERT INTO yrb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Weitaro Yesu emanu sina iwata uite wei, aneba burediba sina waita wei? Ya iwata uegou utawa? Yanu neno daido kimuwere? ");
INSERT INTO yrb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Diti bobo eraitana erawa? Ome bobo nautaitana nautawa? Ya imutaita aba me wei? ");
INSERT INTO yrb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bodere Na buredi nesia fai (5) ma birabiarero eme faiyawere fai tausani (5,000) itaro iwo muduna bosio abo abo youta wei? Weina bosio nesia tuero (12) yousi weita. ");
INSERT INTO yrb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","21","Weitaro wei, nono buredi nesia seweni (7) ma birabiarero eme faiyawere fo tausani (4,000) itaro iwo muduna bosio abo abo youta wei? Weina bosio nesia seweni (7) yousi weitaro wei, awona i uero eta iwata utaita aba me wei? Ieta torowa da imuawete kobere naueta ueta imuawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Besaida orofaro are fatate inataro moana uwara diti basugari amara woutate fareda weita, ewa amara buriaro wirofi weita. ");
INSERT INTO yrb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Weitaro Yesuma i amaranu agero munite su wawaro woure ani. Wawaro woure anite i amaranu ditiro witua uite age deiro odeda wei, erasu aba me wei? ");
INSERT INTO yrb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Weiro wei, na eme inaraitaro eratanerogo na eregou utawa. Emana ana ari inaraitaro eratane wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Weiro Yesuma Danu age nono deiro odiro erebe erebe wiroite eregou ui. ");
INSERT INTO yrb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Eregou uiro Yesuma wei, yanu arisi suro da oweate anu suro torowa ania wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuini Danu iwata ueta uwaraini Sesaria Firifai su suro anita. Anebe Yesuma wei, i uwarama naba anaiya waita wei? ");
INSERT INTO yrb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Weiro weita, moana Joni babataito amara waita. Moana Iraija waita. Moana Godinu mui we bou ueta amara waita weita. ");
INSERT INTO yrb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Weitaro Yesuma wei, nono yade Naba anaiya waita wei? Weiro Fitama wei, A i Kerisode wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Weiro Yesuma wei, i sina moana uwaraba da wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuma mui sina nono eno wei, I Ba Eme Sini Amara faiyawere oferi woufiro baeta uwaraini fuyo ode sina weta uwaraini tarawatu tisa uwaraini Danu sina da mubitate Dawa ma uifitaro kowa rarogonu me sibiro uietaroma nono uyafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","33","Weiba Fitama Yesu mune eta odite dua sina weiro Yesu owerite Danu iwata ueta uwara erite Fitaba wei, seitani Nanu dubenaro fare ania wei. Anu imuetana Godinu imueta me, ina emenu imueta, Yesuma Fitaba eno dua sina wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Duburo Yesuma i uwaraini Danu iwata ueta uwaraba yua weiro fataro wei, anama Nanu buribi afie ufisuna danu unu nesia ekodifite kobere ueta korosi ari mubite Nanu buribi aredibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Weite wei, mui amarama danu unu ewa orofaro me ibifie ufisuna daido uifisu wei. Mui amarama Naini Godinu sinaba uifisuna dawa wirofite me ibene ibene ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Anama i orofa atata ibaiabairo danu unu nesia odifite i nesia mubiro danu me ibeta imumu siosa kabesiro feafisude ina kobererau aba me wei? Eno wenauerite ina ba me wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Weite wei, mui amara danu me ibeta imumu ma owere mubie uteda mui kobere emetu moko maeta kimuwereba iba eno da ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Anama ewa Godinu Sina nautawa kowaini siosa ueta kowaro Naini Nanu sinaba maru utasuna i Ba Eme Sini Amaraini Danu buna aneruini Danu Damamanu bunaini araetaro ido fafitaitana i amaraba moko a Na iwata me wemate ekodimau wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuma emaba wei, Nanu sina ba watane wei, moana ewado inaibinita uwara da uiforo Godinu yawotasu kowa botai bunawere fafiro efoita wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","3","Kowa sikisi (6) me siniro Yesuma Fitaini Jeimisini Jonini wouriro dera maidaniro manitaro Danu ofe ubu aika siniro Danu wadia arioini inakeorau ui. Mui wadia uroeta amarama eno urotawa utebasu. ");
INSERT INTO yrb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","5","Iraijaini Mosesini me ari ue fasite Yesuini sina sina webitaro i amara rarogonu etate Fitama Yesuba wei, Dera Amara, ewado kobererau yaubinisiba kiki suraratu rarogonu Anu mui Mosesinu mui Iraijanu mui ufeisi aba me wei? ");
INSERT INTO yrb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ema derawere iyataba iba eno wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Weina goso ma yariro gosoroma sina tararite wei, ewana Nanu Amara ubiba Danu sina nautebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Weiro sau etana moana uwara iro me, Yesu torowa eta. ");
INSERT INTO yrb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Maidaniroma owetate tarareda wei, i ueta eritaba da weboro wei. I Ba Eme Sini Amara botai uietaroma uyafisuna i ueta ido weboro wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Weiro nautate we mataneda weita, i uietaroma uyafisu sinade ane weita? ");
INSERT INTO yrb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Weitate Dawaba weita, tarawatu tisa uwarama eno waita, Iraija dawa ko afisu. Aneba eno waita weita? ");
INSERT INTO yrb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Weitaro wei, ba waita. Iraija dawa ko farite ibeda nesia ue bou bou utebi wei. Godinu bukaroma Ba Eme Sini Amaraba eno wasu, oferi derawere woufiro Dawaba uwarama neno ka ufitaita, eno wasu wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Enoba yaba watane, Iraija fariro emanu unu enanari dawabai uta. Godinu bukaroma edono wasu, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesuini Danu amara rarogonuini Danu inaibita iwata uwarabai are fatate etana uwara faiyawere inaibita. Iwata ueta uwarabai inare kara utaro tarawatu tisa uwaraini Yesunu moana iwata ueta uwaraini dua sina we mataneda inaibita. ");
INSERT INTO yrb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Inaibitaro Yesu ido fariro etate neno kirifu utate Dawabai durami ue ane fatate ario weita. ");
INSERT INTO yrb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Weitaro wei, ane sina waita wei? ");
INSERT INTO yrb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Weiro mui amarama i guruguru ubita uwaranu turoma wei, nanu seitaninu mui siosa imumuma rewoe ibeta bobo amara woure emabai fanea wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Weite wei, i seitaninu mui siosa imumuma nanu amara danu sina daba garari utasute moana kowaro mu sanasuro ureiteda bebeturoma gugu farasute nio ataritasuro danu ofe bedada utasuba iba woure emabai fanea wei. Fanete botai Anu iwata ueta uwaraba wenero i imumu siosa we beratawa uita wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Weiro Yesuma wei, ya imutawa utaita uwara. Yabai kowa abo abo ibimaro imufoitago wei? Weite wei, i amara woure ara wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Weiro woure fataro seitaninu mui siosa imumuma Yesu erite i amara ma iyari iyari uite mu saniro ureite iwura mameda bebeturoma gugu farebi. ");
INSERT INTO yrb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Eno utebiba Yesuma i amakanu danu damamaba wei, kowa abo abo eno utasu wei? Weiro wei, kikiraturoma dana eno utebe daisininu wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Moana kowaro ina buroini ogoro inufie danu torowa itarebasu wei. Enoba neno arama ufate durua ufasu aba me wei? ");
INSERT INTO yrb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Weiro Yesuma wei, aneba ufasu aba me wasu wei? Anama Naini Godini imue naue ufisuna nesia eno ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Weiro i amaranu damamama i bobo derawere wei, na naueta amara wei. Weite wei, nanu naueta kikiratuba na durua ua wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Weiro i guruguru ubita uwarama durami ue arebitaba Yesuma i seitaninu mui siosa imumuba wei, nautawa wiawa imumu anibate nono da owere afaro wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Weiro i seitaninu mui imumu siosama arua derawere weite i amara ma iyari iyari uite fare ani. Fare aniro i amara uieta ari ainibiba moana uwarama weita, dawa uisinu weita. ");
INSERT INTO yrb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Weitaro Yesu danu agero mamite ma uyariro yare inari. ");
INSERT INTO yrb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu su ubarero amuiro Danu iwata ueta uwarama kiwuma Dawabai weita, etei seitaninu mui siosa imumu aneba we beratawa utaisi weita? ");
INSERT INTO yrb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Eno weitaro wei, i eno seitaninu imumu siosa we berafoe utedana i guriguri ueta kowa torowa ieta ka ufote guriguri rorowarau ufoitana seitaninu imumu siosa we berafoita wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","I orofa ekoitate iroma Gareri orofa fare serigari ue oita. Danu iwata ueta uwaraba we mawetu ufie kiwuma anite eno we mawetu uteda wei, Ba Eme Sini Amara moana uwaranu agero mafitaro mubitate ma uifitaro kowa rarogonu me sibiro uietaroma nono uyafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eno weiro Danu sinanu ubi iwata utawa utate iyatate i sinanu ubi wenauerawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesuini Danu uwara inarebe Kafenamu suro are fataro Yesu mui suro amuite Danu uwaraba wei, dabaro inareda sina anene waita wei? ");
INSERT INTO yrb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Weiro sina wiawa uta. Ema inaredana yaraneta sina we inarebita. We inareda eno weita, anama dera amara sibisu? Eno webitaba wenauerina iba moko sina wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu ido yaurite yua weiro Dawabai fataro emaba wei, anama dera amara sibie ufisuna i amara botai otowa amara sibite uwara nesianu durua ueta amara sibisu wei. Ewa sina Yesuma Danu naueta uwaraba eno wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Weite mui amakanu munite emanu tafioro odite yabaite wei, anama mui amakanu ario weda mubisuna dana Naini mubisu. Dawa Na mubisuna dawa Na siaia ui Godini mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jonima wei, Tisa Amara mui amarama seitaninu moana siosa imumu Anu ifuroma we beratebiro esite weisi, ana yaini yanu buribi inareta amara me, a eno ueta kodia weisi wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Weiro Yesuma wei, kodia da wiawe wei. Anama buna ueta Nanu ifuro utedana dawa Naba sina siosawere wiawa utebasu wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Weite wei, anama yaini Naini wasai utawa utasuna dawana yaini Naini durua ueta amara wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Eno weite wei, yana Kerisonu buribi inaraitaba Nanu ifuro mui amarama yaba ogo ifoe mafiro Godima i ueta da imutawa ufite moko daido mafisu. Iba yaba wegou utatane wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mui amarama Nanu sina naueta amakanuba ba me maosoro siosawere uosoba i ba me maeta amaranu nodoro dera gebiro doifitate enearo sabitaro imuifirona ina kobererau Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Anu agema a ma siosa ufisuna mui age umane tuate age demuraima ibifasuna ina kobererau. Age sadeima uitawa inaro anibasuna ina siosawereba iba anu age umane tua wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Enoba (iro i yareibisu inaro emanu ririraratu da uifitaro ina da ma wairumi ufitaita wei). ");
INSERT INTO yrb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Anu burima a mune siosa dabaro odifisuna mui buri umane tuate buri demurai torowama ibene ibene me ibetaro anibasuna ina kobererau. Buri sadeima ina kabesiro anibasuna ina siosawereba iba anu mui buri umane tua wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Enoba (Iro i yareibisu inaro emanu ririraratu da uifitaro ina da ma wairumi ufitaita wei.) ");
INSERT INTO yrb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Anu ditima a ma siosa ufisuna diti enabira ma guju ue mu sate diti demuraima Godinu yawotasu orofaro eno anibasu ina kobererau. Diti sadei bobo ina kabesiro a sabisuna ina siosawere. ");
INSERT INTO yrb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Iro ririraratu uitawa, ainewaure ateibita ina uifiro daido yareiene yareiene yareibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yesuma weite nono wei, Godima Danu ba kimuwere naueta uwara nesiaba emema emanu wari inaro yare fije ure ma rorowarau utaita i ari Godima Danu uwara inama yare ma rorowarau unono utasu wei. Eno uteda emanu naueta ma kimu ufitae kimuwere inama eme ba yarebasu i ari utasu wei. ");
INSERT INTO yrb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Soruna kobererau. Sorunu imona me sibiro danu imona nono anene ibifisu? Enanari yana uteiboitana kobererau da sibisuna yana imona me sinasu soru ari. Enoba ya sorunu imona ari ibeda uwara nesiaba moko moko wesa kawewera utebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuma i orofa ekodite iroma Judiaini Jodani orofaro farite Jodani ogo yofere inariro i uwara Dawabai inare kara utebitaro Yesu Danu we mawetu ueta utebasu enanari utebi. ");
INSERT INTO yrb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eno utebina Ferosi waita uwarama Yesubai ue efitae fatate wenauereda weita, mui amara danu aweta ekodifisude, kobererau aba siosawere wiaro naufe weita? Danu moko sina anene webisu naufitae iba eno weita. ");
INSERT INTO yrb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Weitaro wei, Mosesima yanu sirorari uwaraba anene wei? ");
INSERT INTO yrb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yesuma eno weiro weita, Mosesima eno wei, mui amara danu aweta ekodifie utedana ekoeta feifaro owawa ufite mafite nono ekodifisu weiya weita. ");
INSERT INTO yrb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Weitaro Yesuma emaba wei, yanu neno kimuwereba iba eno webiya wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","7","Godima ana ana ma taka ufiro mui amarama da ma dare mune aika maika odifisu wei. Boderewere Godima orofa atata nesia odeda awetaini awera ubu uiba ana amara danu danuaini damama ekodifite danu awetabai taka ufisuna ema sadei mero demurai ari sibisu. ");
INSERT INTO yrb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","9","Iba emana sadei me, demurai. Godima ana ana ma taka ufiro mui amarama da ma dare mune aika maika odifisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","11","Duburo su ubarero Danu iwata ueta uwarama dawaba i wei sina wenauetaro wei, mui amara danu aweta ekodifite mui aweta daido mubisuna i amarama dita yagera fafite danu botai awetaba siosa ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","O mui aweta danu awera ekodifite mui awera daido mubisina uyare fafite danu botai aweraba siosa ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Moana uwara emanu koinibororaratu Dawabai woutate age deiro odifie wo fata. Fataro Danu iwata ueta uwarama dua sina weitaba Yesuma ibo uite emaba wei, ewaro da woure arawe da wiawe wei. I koiniboro fafitae watane wei. Godinu yawotasu emanu iba watane wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Eno weite wei, i uwara koiniboronu imueta ari imutaitaro Godima ema yawotasu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Anama Godinu yawotasu koiniboronu imueta ari da mubisuna Godinu yawotasu orofaro da anibisu. Ba watane wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","I koinibororaratu agema yabatebite mui age kofiri deiro odeda we ma kobererau utebi. ");
INSERT INTO yrb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu i orofa ekodite dabaro ani. Anebina mui amara durami ue are farite jegirari uteda wei, kobere Tisa Amara, anene umate ibene ibene me ibeta mumau wei? ");
INSERT INTO yrb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Eno weiba Yesuma wei, aneba Naba kobererau wasu wei? Mui amara kobererau me, Godi torowana kobererau. ");
INSERT INTO yrb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Godinu tarawatu a iwata utasu. Eme da ua, aiyenu awetanu buribi da yowea, waira da ua, da irua, wawei sina webasuna meo da wia, anu anuaini amamaba kobererau uegou ua. ");
INSERT INTO yrb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Enoma enoma weiro wei, Tisa Amara, na kikiraturoma eno utebatane wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Weiro Yesuma i amaraba neno arama uteda wei, demurairatu eno ufasu, aniate anu ibaiabai nesia maro oiya ufitaro nono ibaiabai me uwaraba anu oi nesia mafate Nanu buribi afasu wei. Anu i nesia emeba mafasu i ari ibaiabai duburo aba urero mafiro mubasu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Weiro i amaranu ibaiabai derawereba danu ibo aika uteda neno siosa uite owerite ani. ");
INSERT INTO yrb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesuma Danu iwata ueta uwaraba owere owere uteda wei, ibaiabai derawere ode ibeta amara Godinu yawotasu orofaro anibie uteda kimu derawere atafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Weiro ifowa ae furiataro Yesuma wei, masigu, Godinu yawotasu dabaro aneda kimu derawere utaitago wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Eno weite wei, dera kemo egima mara ebaro fare anibisuna nudawere. Ibaiabai derawere bobo amarama Godinu yawotasu dabaro anedana kimu derawere atafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Weiro i sina kamama nauteda neno kirifu derawere utate weita, ina ba anama wirofisu weita? ");
INSERT INTO yrb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Weitaro Yesuma ema ereda wei, emema eno da ufitaro Godima nesia ufite Danu aikana ma wirofisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Weiro Fitama yare wei, nono yade koiniboroini ibaiabai nesia dubena sasite Anu buribi anaisi wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Weiro Yesuma wei, Nanu sina nauegou uawe wei. Anama danu suini daburetaini arumamini danua damamaini koiniboroini nasinini nesia Godinu sinaini Naba danu ibaiabai nesia dubena sabisu. Dubena sabite duburo danu suini adarabuini arumamini danuaini koiniboroini nasinini i nesia danu kodifisu i ari faiya faiyawere mubisu. nono ini awe uyareta dawabai fafisu. Nono duburo me ibene ibene ibeta mubite ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Weite wei, moana dera uwara iro otowaratu sibitaita. Moana otowaratu uwara iro derawere sibitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","33","Jerusaremu dabaro Yesu ko manebi. Maniro Danu iwata ueta uwara neno kirifu utate manitaro moana uwara iyatate manita. Yesuma Danu uwara tuero (12) munite kebiro anite duburo fafisu uetaba wei, Jerusaremu suro anibero mui amarama Ba Eme Sini Amaraba wawei sina webite mafiro dera fuyo ode sina weta uwaraini tarawatu tisa uwara dawa mubitate ma uieta sina webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Eno ufitate aika emeba mafitaro mubitate irufitate Danu ibo nawataro witua uteda domuma ufitaita. Eno utebe ma uifitaro uifiro kowa rarogonu me sibiro uietaroma nono uyafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jebedinu amara sadei Jeimisini Joni Yesubai fasite weisi, Tisa Amara, wa sadei wanu imueta waba mai weisi. ");
INSERT INTO yrb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Weisiro wei, yaba anene yanu unu mamane waisi wei? ");
INSERT INTO yrb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Weiro weisi, Anu bunawere yaure yawoeta kowa ido fafiro A abanaro yaufaro Anu enabira enabira yaufune waitu weisi. ");
INSERT INTO yrb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Weisiro wei, yanu wenauereta ya iwata mero, me sara waisi wei. Nanu woumane utatane oferi wakiki ogo ari ifawaisi? Nanu woumane utatane oferi babataito ueta ari ufawaisi aba me wei? ");
INSERT INTO yrb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Weina aiwiade enanari ufutu weisi. Weisiro wei, aiwia, ba waisi. Nanu itatane wakiki ogo ifawate Nanu babataito ueta enanari ufawaisigo wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Eno weite wei, i yaureta kabesi sadei Nanu meba da mamaro da yaufawaisi wei. Moana uwaraba Godima i kabesi ue bou uiba Dana webiro yaufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","42","Danu moana uwara teni (10) i sina nautate Jeimisini Joniba ibo utaro Yesuma emaba yua weite wei, i aika dera yawoeta uwarama emanu uwaraba kimuwere yawoteda emanu imueta emaba kimuwere odaitaro ya ue iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Emanu ueta yanu me. Yabairoma anama dera amara sibisuna ya nesia durua ufisu. O botai amara sibisuna yanu sabua ueta amara sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ba Eme Sini Amara ido fariro eme Dawaba durua utawa utaro emaba enademi durua uteda iba fari. Duburo Danu wiroeta onono uwara faiyawereba sabisuba mae munono ari siboita wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jeriko suro fare aneda Dawaini Danu iwata ueta uwaraini uwara faiyawere iroma anebitaro Timeiasinu amara Batimeusi dawa diti basugari erawa nui webi amara daba gigirariro yaubi. ");
INSERT INTO yrb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yesu fariro Dawa Yesu Nasareta amara nauite yua weite wei, Deiwidinu sisia amara Yesu, naba neno arama ua wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Weiro uwara faiyawere fatate weita, sina da wia weitana derawere yua weite wei, Deiwidinu sisia amara, naba neno arama ua. ");
INSERT INTO yrb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Eno webiba Yesu inarite wei, i amaraba wiawero Nabai afi wei. Weiro diti erawa amaraba weita, iya da uyate uya weita. Weitate weita, Yesu aba yua wasua weitaba uyari. ");
INSERT INTO yrb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Uyarite danu dei barueta ma kosugari uteda mu sanite Yesubai sau ane fari. ");
INSERT INTO yrb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ane fariro Yesuma wei, aba anene umane wenu wei? Weiro i diti erawa amarama wei, Dera Amara, nanu unu diti ba emane watane wei. ");
INSERT INTO yrb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Weiro Yesuma wei, ania, anu imuetama a ma wirotasu weiro diti ido forairo erite Yesunu buribi ani. ");
INSERT INTO yrb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Yesuini Danu iwata ueta uwaraini Jerusaremu dera natofo suro fafitae arebita. Arebe arebe are mui su sadei Betifeijini Beteni i oriwa maidanibai ibita. Enoba inarebe i su sadei ibita orofa abanaro are fata. Nono iroma Jerusaremu suna yafa me. Are fatate Yesuma Danu iwata ueta mui amara sadei siaia uteda wei, etei yanu ibo afu ibinu mui kirisi weto su ifu Betifeiji iro aniawate eawaro mui su gigirari tubune tutubaro bodere mui amarama yaurawa i otowa doniki egi nama doie odifitaro ibifiro efawaisina ido na ma uregari ue muawate Nabai woure arawa wei. ");
INSERT INTO yrb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Eno weite wei, nono eno utebeawaro i doniki ubi uwarama ane utaisi webitate eno webitaita, aneba doniki na ma uregari ue munaisi webitaitana eno wiawa, yanu Dera Waria Amarama mubie wenuba munaisi wiawaro mafita wei. ");
INSERT INTO yrb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Weiro ido anisite otowa doniki atasina i doniki su bebetobai tutuburo uwane oitaro inaibiro esite na ma uregari utebisi. ");
INSERT INTO yrb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Eno utebisiro i doniki egi ubi uwarama weita, ya ane utaisi weita? Aneba doniki na ma uregari utaisi weita? ");
INSERT INTO yrb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","7","Weitaro i amara sadeima Yesunu wei sina weisiba ekoitaro doniki Yesubai woure anisi. Ane fasite emanu dei barueta wadia deiro oisiro Yesu ido amo yauri. ");
INSERT INTO yrb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","9","Eme faiyawere wadiaini farai tataini dabaro ode anebitaro Yesuma fare anebiro botairo anebita uwaraini duburo arebita uwaraini nesia derawere yua weitate weita, yanu Dera Waria Amara weita. Yanu Dera Godinu ifuro farasu Amarana ido farinu osana inu ubina kobererau weda weita. Godima dawaba kobererau utedibebasu weita. ");
INSERT INTO yrb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dawa ido farinuba yanu sirorari amara kini Deiwidima yaure yawotebi i ari nono fafisu. Iba Godima ina ma kobererau utasu weita. Weda derawere yua weita, yanu etua urero Dera Amara osana inu ubina kobererau weda enoma enoma webitaro fare ani. ");
INSERT INTO yrb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Fare anite Jerusaremu suro ane farite Dera dubu su ubare mui koruro amui. Amuite iro ane ane nesia erebiro yawi siniba ekodi. Dawaini Danu uwara tuero (12) owere Beteni suro ane fata. ");
INSERT INTO yrb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Waura warai Beteni su ekoitate aneda Yesu osi uri. ");
INSERT INTO yrb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","14","Osi uriro warae ibeta bobo boruba ana iro erite tai mune ifie ani. Ane farite erina tai uwaneta kowa me, tata torowaba wei, a tai da uwanebearo anu tai uwarama da iteibitae watane weiro Danu iwata ueta uwara nauta. ");
INSERT INTO yrb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nono owere Jerusaremu suro are fataro Yesuma dera dubu su ubarero amui. I kakara koruro anawa. Moana koruro amuite oiya ue maeta uwaraini oiya ueta uwaraini yoweriro itataro emanu oi moko mae matata uwaranu kaiyoini fuyo ubani oiya ue mata uwaranu yauretaini mu saniro ma regari uta. ");
INSERT INTO yrb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","17","I fefenaroma ego woureta uwara da anibitae garari uite wei, Godinu bukaroma eno wasu, Nanu suna eme nesianu guriguri ueta su. Eno wasu aba me wei? Yana waira ueta uwaranu su ari utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Weiro i dera fuyo ode sina weta uwaraini tarawatu tisa uwaraini i sina nautate Yesu ma uieta daba dobereda iyarebita. I uwara nesia Yesunu sina nauegou utebitaba iyarebita. ");
INSERT INTO yrb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yawi siniro Yesuini Danu uwaraini i su ekoitate anita. ");
INSERT INTO yrb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Wau urina dabaro fare aneda etana i dodoa wei boruba ana torowa sibu uriba Fitama wei, Dera Waria Amara, boruba anaba Ana dodoa weiro sibu urinu, ea wei. ");
INSERT INTO yrb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Weiro Yesuma wei, Godi kimuwere imutebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nanu sina wemaro nauawe wei. Anama i maidaniba webisu, uyate enearo ania, eno webite kimuwere imuteda da imutawa ufisuna enanari ufisu. ");
INSERT INTO yrb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ane ane wenauereda guriguri ufote kimuwere imuegou ufoitana mafiro muboita ina yanu wei. ");
INSERT INTO yrb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yana inaibeda guriguri ufoitana mui amarama yaba sara siosa ueta ufiro yana imutawa ufoitaba yanu urero Babama yanu neno neno ueta mubite imutawa ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yanu yaiyemutunu sara siosa ueta da mune imutawa ufoitana yanu urero ibinu Baba yanu sara siosa ueta da mune imutawa ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Jerusaremu suro nono owere anita. Dera dubu su fefenaro inarebina dera fuyo ode sina weta uwaraini tarawatu tisa uwaraini baeta uwaraini faiyawere Dawabai fatate weita, A arotorowaba Anu bunaro eno utasu? Anama aba buna mairo eno utasu weita? ");
INSERT INTO yrb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Weitaro Yesuma emaba wei, Nanu wenauereta botai yaba wemaro Naba yanu kobererau moko weboitana ananu bunaro utatane wemau wei. ");
INSERT INTO yrb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Joninu babataito ueta ureroma Godima weiro ui aba emema weitaro ui wiawero nauma wei. ");
INSERT INTO yrb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","33","Weiro sina we matatate weita, ane webeisi? Ureroma fari webisuna Dana eno webisu, aneba Joninu wei sina imutawa uta webisu weita. O emebairoma webeisi aba euwari weita? I uwara nesiama imuta, Joni ba we bou ueta amara imutaba iyareda weita, ya iwata me weitaba Yesuma wei, ananu bunaro utatane sina yaba da wemaro naufoita wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuma mui kasei sina Danu torowaba emabai eno wei, mui amara gureifi tai waiya umanite jiru turite gebiroma dowa ure kara uite gureifi amune adidiareta koru ubu uite danu dobo uite gureifi yo wai. Eno uite danu waiya moana uwaraba yawofitae mateda mui orofaro ani. ");
INSERT INTO yrb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Duburo ayo ureta kowa fariro danu mui waiya ueta amara danu gureifi mubie siaia uiro ani. ");
INSERT INTO yrb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ane fariro i waiya yawotebita uwarama i amara mutate isuma urebe gureifi matawa, ma owetate siaia utaro ani. ");
INSERT INTO yrb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aniro nono mui amara siaia uiro ani. Ane fariro mutate kofiriro urebe siosa ueta uteda siaia utaro ani. ");
INSERT INTO yrb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nono mui amara siaia uiro ani. Ane fariro mutate ma uitaro duburo uwara faiyawere siaia utebiro anebitaro moana isuma urebitate moana ma uitebita. ");
INSERT INTO yrb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Enoma enoma utebitaro moana uwara meba i waiya ubi amara danu torowa nenoro we imui, nanu amara ubi siaia umaro dawaba kakara ufitaita we imuite siaia uiro ani. ");
INSERT INTO yrb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","8","Ane fariro emanu emanu we mataneda weita, ewana danu amara ubiba ma uifete danu waiya yana mubeisi weitate dawa muneda ma uitate danu ofe dowa dubenaro sata. ");
INSERT INTO yrb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Eno utaba i waiya ubi amara anene ufisu? Dawa anibite i waiya yawoeta uwara nesia ma uifite danu waiya aika uwaraba mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Godinu bukaro i sina yawitaita aba me? Na iwata ya yawitaita. I bukaroma eno wasu, su ubu ueta uwarama mu sata gebirona i botai tutubu ari sini. ");
INSERT INTO yrb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ewa yanu Godinu uetaba kamama eraisi, eno wasu wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesuma i kasei sina emaba weiba Dawa mune ma uieta daba dobetate i uwara nesiaba iyareda ekoitate ane me sita. ");
INSERT INTO yrb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Moana uwarama Ferosi uwaraini Erodi uwaraini Yesunu sina irue nauteda mubitae siaia uta. ");
INSERT INTO yrb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Siaia utaro Yesubai ane fatate weita, Dera Amara, Ana meo amara me, ba amara ya iwata utaisi. Uwara nesia arotorowa imutasu. Eme derawere aba kikiratu eno imutawa utasute Godinu sina we mawetu uegou utebasuro ya iwata utaisi weita. Ibago Romani dera gaemani amara Sisaba takesi oi mafeisi aba me weita? ");
INSERT INTO yrb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Weitaro emanu irueta imueta Dawa iwataba wei, aneba Na woure eraita wei? Siriwa oi maiwero ema, weiro mata. ");
INSERT INTO yrb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mataro i oi ereda wei, ananu kofirini owawaini ewado ibinu wei? Weiro Sisanu weita. ");
INSERT INTO yrb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Weitaro wei, Sisanu ane ane dawaba mawete Godinu ane ane Dawaba mawe weiro kamama nauta. ");
INSERT INTO yrb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Duburo Sadusi uwara Yesubai fata. I uwarama webita, uwara uietaroma da uyafitaita we inarebita. Yesubai are fatate emanu wenauereta sina weita, Dera Amara, Mosesima wei, mui amara aweta mubite aruma amara yanae munawa me ibebe uifisu. Uifiro danu dabuema danu aweta wabu mubiro i uieta amaraba aruma amara yanae mubisu eno owawa ui weiya weita. ");
INSERT INTO yrb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Eno weitate weita, adarabu seweni (7) ibebe botai amarama aweta munite aruma amara yanae munawa me ibebe ui. ");
INSERT INTO yrb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Uiro danu abana dabuema danu aweta wabu munite aruma amara yanae munawa, me ibebe ui. Uiro danu mui abana dabuema munite aruma amara yanae munawa me ibebe ui. ");
INSERT INTO yrb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Uiro enoma enoma i amara sewenima mutate aruma amara yanae munawa uie me sitaro i aweta ido ui. ");
INSERT INTO yrb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Duburo i uie uyareta kowaro abo amarama i aweta mubisu? I amara seweni mutaba anama mubisu weita? ");
INSERT INTO yrb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Weitaro wei, Godinu bukaro sinaini Danu buna ya iwata meba imutawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Urero aneruma aweta munawa utaita enanari eme nesia uietaroma uyafitate awetaini awera da mubitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Uieta emenu uyareta Mosesinu bukaro yawitaita aba me? I ina yarebi ananu ikiki yawitaita aba me? I ikikiro Godima Mosesiba wei, Nana Eibaramunu Godi, Nana Aisikinu Godi, Nana Jeikofunu Godi eno wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Godina i uieta uwaranu Godi me, Dana i wiroeta uwaranu Godi, iba ya iwawa utaita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sina sina webitana mui tarawatu tisa amarama farite Yesunu kobere sina nautebe imuteda Yesuba wei, abo tarawatuna derawere wei? ");
INSERT INTO yrb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Weiro Yesuma wei, i dera tarawatuna eno, Isaraero uwara, nauawe, yanu Dera Godi, Dawa Godi demurai torowa. ");
INSERT INTO yrb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yanu Dera Godibai yanu unu uetaini imueta nesia odegou utebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mui dera tarawatuna eno, yanu yaiyemutuba yanu torowa ari neno arama utebeawe. Mui dera tarawatu me wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Weiro i amarama wei, ba wasu, Dawa demurai, Godi mui me. ");
INSERT INTO yrb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dawaba neno arama uegou ufete imuegou ufete uegou ufete yanu naiyemutuba yanu torowa ari neno arama uegou ufe, enona kobererau. Fuyo oetaini fuyo yaretaini kobererau me wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Weiro danu sina kobererauba Yesuma wei, Godinu yawoeta daba baworo anibae utasu wei. Weiro mui wenauereta wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuma dera dubu su ubarero we mawetu uteda wei, i tarawatu tisa uwarama Keriso Dawa Deiwidinu sisia amara aneba eno waita wei? ");
INSERT INTO yrb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Imumu Kotofuma Deiwidiba mawetu uiba Deiwidima wei, Godima Nanu Dera Waria Amaraba wei, Nanu banibira age afu yauaro Aini wasai utaita uwaraba buna umate Anu buri wowonaro odimau wei, Deiwidima eno weiya wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deiwidima Dawaba Waria Amara weide anene Keriso Dawa Deiwidinu sisia amara sini wei? ");
INSERT INTO yrb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","39","Yesuma eno weiro i uwara nesia Danu sina nauegou utaro mui we mawetu uteda wei, eforo moana tarawatu tisa uwara yafa asugari ueta wadia barufitate i maketiro inaraita uwaranu ario sina naufitate Ju uwaranu dubu su kobere yaureta kabesiro yaufitate ogaro kowaro kobere yaureta kabesiro yaufitae utebaita. ");
INSERT INTO yrb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","I uwara emanu unu enoma enoma utedana guriguri yafawere moana uwarama naufitae iba webaitate nono wabu awetabonu ibaiabai waira utebaitaba emaba fanisi derawere mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","43","Duburo Yesuma dera dubu sunu me maeta mauabai yaubeda erebiro uwara faiyawere emanu oi fare sanebita. Moana ibaiabai bobo derawere uwara oi faiyawere sanebitaro nono duburo ibaiabai faiya me wabu aweta are farite danu toea sadeiratu saniro Yesuma Danu iwata ueta uwaraba weiro fataro wei, Nanu sina nauawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Weite wei, ewa wabu aweta danu ieta oiya ueta oi nesia saninu iba dawa danu oi derawere saninu. Ibaiabai derawere bobo uwara oi faiyawere sanitaro emabai faiya faiyawere ibinuba iba kikiratu sanita wei. Nono i wabu aweta danu oi nesia saninu wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu I dera dubu su ekodite itarebiro Danu mui iwata ueta amarama wei, Dera Amara, gebiro deraraboini su su derawere ea wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Weiro Yesuma wei, i dera su su erasu? Gebiro nesia ubefitaro mui gebiroma mui gebiro deiro da ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Duburo Oriwa maidaniro yaubeda dera dubu su erebiro Fitaini Jeimisini Jonini Enuduruini emanu aika fatate Dawaba weita, Anu wenu sina enanari abododo ufisu? I dubu kowaro anene ufiro efero A fafasu weita? ");
INSERT INTO yrb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Weitaro Yesuma yare wei, eregou uforo wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Uwara faiyawere irufitae Nanu ifuro fafitate webitaita nana Keriso, nana Keriso, enoma enoma iruteda webitaro uwara faiyawere naufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Baworo uraneta rurua naufote emiro uraneta sina naufoitana da iyaforo wei. Enoma enoma ufiro i me sibisu kowa duburo fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","I orofa atata uwara aika maika urafitaro mui orofa gaemanini mui orofa gaemanini urafitaro orofa faiyawerero nasini wawana wawana ufiro orofa faiyawere sinai derawere woufitaro enoma enoma ufiro i awe uyareta kowa ido tutubari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Eregou uforo wei. Ya woufitate kanisoro uwarabai woure anibitaita. Ju uwaranu dubu su ubarero isuma ufitate gaemani uwaraini kini uwarabai woure anibitate Naba ya eno ufitaro emaba Nanu sina weboro iwata ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Godinu kotofu sina i orofa atata uwara nesiabai botai we anibitaro duburo i me sibisu kowa ido fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","I uwarama awe uyareta fafisu kowaro are ya mubitate woure anibitaro ya sina ane weboita da imuforo wei. Godima imueta yaba mafiro sina weboita wei. Ya i sina da weboro Godinu Imumu Kotofuma yanu bebeturoma webisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dataema dabueba do mafiro ma uifitaro damama danu amaraba enanari ufiro aruma amara emanu danuaini damamaba wawei webitaro ma uifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ya Nanu ifu munaitaba i uwara nesia yaba neno ka ufitaita. Anama buna ufiro dubu kowa fafiro dawa wirofisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mui kowaro i siosa emetu danu ibeta kabesi mero iro ibifiro efoita. Eforo i kabesiro ibeda siosa ueta faiyawere uteibiro ya yawitaita uwara ido iwata ufoita wei. Judia orofaro ibinita uwara maidaniro sau manibitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Su ofadaro yaubifitaita uwara su ubarero emanu ibaiabai mubitae da anibitaita. ");
INSERT INTO yrb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Waiya uteibitaita uwara da owefitate wadia da mubitaita. ");
INSERT INTO yrb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","I kowaro dia bobo awetaboini ama ieta kuita bobo awetaboini emanu anibitaita daba siosawere. ");
INSERT INTO yrb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Guriguri uteda i awe kowa obi derawere mafisu kowaro da fafie wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","I kowa faiyawere fafitaro awe awe derawere uyafitaita. Boderewere Godima i orofa atata ubu ui kowaroma eno me, awona eno erawa utaisi, i kowa me sibiro nono duburo eno da efeisi wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Godima i kowa faiyawere ma fuyaratu da ufirona eme nesina uifitae. Nono Danu we muni uwara imuteda iba i kowa faiyawere nono ma fuya ui wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nono mui amarama yaba webisu, keriso ewado o keriso iro eawe eno webisuna da nauforo wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Irueta kerisoini irueta we bou ueta uwaraini faiyawere fafitate buna uetaini buna eretaini derawere ufitaro emanu tanana emema efitaita. Eno ufitate Godima Danu we muneta uwara irufitae ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ewa sina nesia yaba wataneba nauegou uforo wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Awe kowa nesia me sibiro kowa basugari ufiro sakara ario da ufiro muina ureroma tarafitaro urenu buna derarabo nesia wawana wawana ufitaita. ");
INSERT INTO yrb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nono i Ba Eme Sini Amara gosoro bunaini ario derawere ido fafiro efitaita. ");
INSERT INTO yrb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dawa Danu aneru siaia ufiro anibitate kowa itarasu iroma kowa amutasu iroma ufuniro manamaro aboro aboro ure nasiniro Danu we mune odi uwara nesia mubitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Boruba ana eawete iwata uawe wei. Boruba ana tua reka oyarasuro eredana ya iwata, obi kowa ido farinu waita wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Enanari ewa watane nesia ufiro efote iwata ufoita. I Ba Eme Sini Amara Dawa fafie bebetoro inarinu iwata ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nanu sina ba wemaro nauawe wei. Ewa ibinita uwara da uifitaro i wene enanari botai nesia ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ureini nasini nesia me sibitaro Nanu sina daido ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","I Yesunu fafisu kowa eme iwata me, urero ibinita aneru iwata me, Godinu Amara Dawa iwata me, Godi torowa Dawa iwata utasu wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","I fafisu kowa ya iwata meba nauegou ufote eregou uforo wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ewana ewa sina ari, mui amara mui orofaro anibie uteda danu waiya ueta uwarabai emanu gaukara demui demui maite danu dera yawoeta amaraba wei, toafurau yawofaro wei. ");
INSERT INTO yrb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","37","Enanari yaba wataneba i Dera Amaranu fafisu kowa ya iwata me. Dawa dumu gisigisiro o dumu abanaro o waibai o waura warairo ido fafiro nauta ainibiforo eosoba yaini uwara nesiaba toafurau yawoforo watanea wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Godima i Isaraero uwara Ijifiroma woure ani ogaroini wawareta ira yisiti me buredi ogaro kowa sadei fafiro iteibitaitaba dera fuyo ode sina weta uwaraini tarawatu tisa uwarama Yesu kiwuma mubitae utate Yesunu ma uieta daba we turebe weita, ogaro kowaro da budari ufeisi weita. Eno uoisiro uwara nesia emanu emanu aika ibo uotote uraotoa weita. ");
INSERT INTO yrb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuma Beteni suro ibeda Saimoni, dera amaima boboro wiroi amaranu suro yaubeda ieta itebina mui aweta munowere ogo gebiro kawabu, i kawaburo munowere ogo danu dawana derawere, i kawabu woure amo farite ma fomuite i munowere ogo Yesunu kofiriro ma wegari ui. ");
INSERT INTO yrb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Eno uiba moana Dawaini yaubita uwarama ibo uteda dua sina weita, aneba me sara saninu? ");
INSERT INTO yrb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","6","Etei munowere ogo oiya ue mafite toti kina (K30) mubite ibaiabai me uwaraba mafisu ina ido weita. Weitate i awetaba ibo utaro Yesuma wei, kodiawete i awetaba dua sina da wiawe wei. Naba kobererau usinu. ");
INSERT INTO yrb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ibaiabai me uwara yabai ainewaure ibeibitaitaba yanu unu durua ufoe ufoitana ufoita. Na yabai ainewaure da ibimau wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dawa Nanu ofero munowere ogo ma wegari usinuba Nanu uri ue oeta ue bou usinu wei. Nanu sina wemaro nauawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Godinu kotofu sina orofa atata nesiaro we inareda danu ueta imuteibitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","11","Judasi Isikarioti, dawa Yesunu mui tuero (12) iwata ueta amara, dana dera fuyo ode sina weta uwaraba wawei webie fare anite weiro nautate yaru utate oi mafitae weita. Weitaro Judasi Isikariotima Yesu do mafie daba doberebi. ");
INSERT INTO yrb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wawareta ira yisiti me buredi ogaro, danu botai kowa ido fariro Godima Isaraero uwara Ijifiroma woure ani mamoenatu ogaro uetaba urebitaro Danu iwata ueta uwarama weita, Anu ogaro aboro ufete ifeisi weita? ");
INSERT INTO yrb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Weitaro Yesuma Danu mui iwata ueta amara sadei siaia uteda wei, natofo suro aniawate mui ogo woureta amara efawaisina danu buribi aniawa. ");
INSERT INTO yrb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","15","Aniawate danu suro fawate i su yawoeta amaraba eno wiawa, wanu Dera Amaraini Danu iwata ueta uwaraini ogaro aboro ifie wenu webawaisina i amara yaba dera su koru mui etu deiro mafisu. Mafiro ogaro ueta mune bou uawa wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Weiro suro anisite Yesunu sina enanari usite ogaro ueta ue bou usi. ");
INSERT INTO yrb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","18","Yawiro Dawaini Danu iwata ueta uwara tueroini i suro amo fataro yautate ogaro itebe wei, mui yaini ieta itaisi i amarama Na do mafisugo wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","20","Eno weiro neno siosa uteda weita, na aba anaiya? Enoma enoma nesina weitaro wei, mui tuero iwata ueta amara naberero dawaini Naini ieta munaitu. I munasu amarama Na do mafisu Naini ieta arotorowa itaitu idoni wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Godinu bukaroma wasu i Ba Eme Sini Amara enanari uifisu wei. I Ba Eme Sini Amaraba do mafisu amara danu siosa ueta derawereba danu danuama dawa da mubirona ina kobererau wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yesuini Danu uwaraini ogaro itebe ieta munite Godi kobererau we imuteda guriguri uite ma birabiarite mateda wei, muawe, ewana Nanu ofe wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","24","Kafusi munite Godiba we kobererau uteda guriguri uite mairo i uwara nesia itebitaro wei, ewana Nanu reka unuro ue matanetanu onono eme faiyawereba itafisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nanu sina wemaro nauawe wei. Ewa na didi tai dumamuba ba wemaro nauawe wei. Ewa na didi tai dumamu ewaro nono da imate nono duburo Godinu yawotasu orofaro nadidi tai dumamu nono imau wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Soniroma Godiba we kobererau uteda soni weitate Oriwa maidaniro manita. ");
INSERT INTO yrb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oriwa maidaniro manebe mane fata. Fatate Yesuma wei, ya nesia Naba maru ufote ekodifoitaba Godinu bukaroma eno wasu, i mamoe yawoeta amara umaro i mamoe nesina daba aika maika anibitaita eno wasu wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nono duburo Godinu bunama Na ma uyafiro Na ko Gareriro animau wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Weiro Fitama wei, i uwara nesia Aba maru ufitate ekodifitaro na Aba maru da umate da ekodimau wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Weiro Yesuma wei, Nanu sina naua wei, awona dumuro kokora nono webite nono webite ufiro a ko Nanu ifu rarogonu we ma feareda meo webasu wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Weiro Fitama daido webe wei, Aini naini uifutuba Aba meo da wemau wei. Weiro Danu moana iwata ueta uwara nesina enanari webita. ");
INSERT INTO yrb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gesemani orofaro ido ane fatana Yesuma Danu iwata ueta uwaraba wei, yauawero Na guriguri uma wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Fitaini Jeimisini Jonini wourite anite Danu neno siosa derawere uteda wei, Nanu neno bomu kakei utasuba Na uieta neno utasu wei. Yaubeda yawoawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Weite yafa me fuyaratu anite arubi ubeda guriguri uteda wei, Baba, ewa wai Nabairoma mubae ufasuna mua wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Eno weite wei, Nanu Baba, A nesia ufae watane. Ewa siosawere wakiki ogo ari Nabairoma anibisuna anibisu. Nanu unu da uate Anu unu torowa ua wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Eno weite owerite fariro nauta ainibitaro Fitaba wei, nauta ainibinu? Wai fuyaratu yawotasu aba me wei? ");
INSERT INTO yrb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yawoegou uawete guriguri uawe. Siosawere ue ereta yabai faosoro ya siosa uotoa wei. Yanu nenonu unu ufoitana nono yanu ofena buna meba da ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","40","Eno weite anite Danu bodere wei sina enanari guriguri uite owerite fariro nono nauta ainibitaro emanu diti nauta uiba moko sina wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Utaro anite nono owerite farite wei, nauta ainibeda imoitaita wei? Ido uyawe. Nanu do maeta kowa farasuba siosa uwara Na mubitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Uyawero anibe. Nanu do masinu amara ido farinua eawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu eno weina Judasi mui tuero iwata ueta amaraini uwara faiyawere kaiyaini isuini woutate fata. I dera fuyo oeta uwaraini Ju uwaranu baeta uwaraini emana ema siaia utaba iba fata. ");
INSERT INTO yrb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Auboko Judasima wei, i amara nana koku umaro efoitana ido muawete sau aniawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","46","I orofaro farite Yesubai anite wei, Tisa Amara weite koku uiro yabata. ");
INSERT INTO yrb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yabataro Danu mui inaibi iwata ueta amarama danu kaiya munite i dera fuyo ode sina weta amaranu waiya ueta amaranu ome umane kosari ui. ");
INSERT INTO yrb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesuma i uwaraba wei, aneba Na waira ueta amara ari munaita? ");
INSERT INTO yrb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dera dubu suro kowa faiyawere we mawetu utebitararo iro Na munawa utate aneba awona kaiyaini isuini mune faraita wei? Godinu bukaroma eno wasuba enanari utaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Weiro Danu iwata ueta uwara nesina Dawa ekoitate iya durami ue anita. ");
INSERT INTO yrb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Yesunu mui buribi inareta amara inaibeda wadia torowa baruite inaibiro dawa mamitaro danu wadia okodite ofe torowa durami ue ani. ");
INSERT INTO yrb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","I Dawa budari uta uwarama Yesu agero mamitate dera fuyo ode sina weta amaranu suro woure are fataro fuyo ode sina weta uwaraini Ju uwaranu baeta uwaraini tarawatu tisa uwaraini guruguru utebitaro iro are fata. ");
INSERT INTO yrb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Fataro Fitama yafawere emanu buribi anite dera fuyo ode sina weta amaranu su teteuro are farite yaubi. Dawaini moana waiya ueta uwaraini ina gigirariro yaubita. ");
INSERT INTO yrb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","I fuyo ode sina weta uwaraini kanisoro uwara nesia Yesu ma uieta daba doberebe atanawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Moana uwarama uyareda meoma wawei webitaba imueta daba demurai me. ");
INSERT INTO yrb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Moana uwarama uyareda meo sina weita, ewa amarama botai wei, eme agema uta dera dubu su ma jugari umate kowa rarogonu me sibiro reka su agema da umate sau ue me simau weiya weita. ");
INSERT INTO yrb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","60","Moana eno weitaro moana aika sina weitaro dera fuyo ode sina weta amara danu kabesiroma uyareda Yesuba wei, i uwaranu sina nausinu? Aneba A sina mui wiawa? Anene webasu? ");
INSERT INTO yrb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Weiba Yesu sina wiawa uiro dera fuyo ode sina weta amarama nono wei, Ana Godinu Amara Keriso aba me wei? ");
INSERT INTO yrb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Weina aiwiade weite wei, Ba Eme Sini Amara i buna derawere Godinu banibira age afuro yaufite gosoro fafiro efoita wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Eno weiba i dera fuyo ode sina weta amara i sinaba ibo uite danu wadia ma babareda wei, mui wawei weta uwara yua da webe wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Danu meo sina nauitaba anene weboita wei? Weiro sina daba demurai weita, Danu sina siosawereba ma uifitae weita. ");
INSERT INTO yrb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Weitaro moana uwarama Dawa witua uteda Danu diti wadiama garari utate agema ureda weita, anama A urasu? Wiaro naufe weita. Eno weitaro meremere uwarama Yesu mutate agema urebita. ");
INSERT INTO yrb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Fita su teteuro yaubi. Ido yaubiro dera fuyo ode sina weta amaranu mui waiya ueta aruma fare anebe erina Fita ina gigirariro yaubiro ereda wei, a i Nasareta Amara Yesuini iro ibi wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Eno weina Fitama wei, Yesu na iwata me wei. A ane wasu ari na i sina iwata me wei. Fita eno weite uyarite ofadaro aniro kokora webi. ");
INSERT INTO yrb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","70","Kokora webiro i arumama nono erite guruguru ubita uwaraba wei, ewa amara Yesunu amara weina Fitama na me wei. Duburo i guruguru ubita uwarama Fitaba weita, ana i uwara tuero (12) emanu domaya. Ana Gareri amarade weita. ");
INSERT INTO yrb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Weitaro Fitama sina siosa weda wei, etei Amara na iwata me wei. Na meo wemauna Godima na ma uifisu wei. ");
INSERT INTO yrb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Weiro kokora nono weiro Fitama Yesunu auboko dawaba wei sina imui. Yesuma Fitaba auboko eno wei, kokora nono webite nono webiro auboko a ko Nanu ifu rarogonu we ma feafasu eno wei. I sina Fitama imuteda i wei. ");
INSERT INTO yrb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wau uriro dera fuyo ode sina weta uwaraini dera uwaraini tarawatu tisa uwaraini kanisoro uwara nesia sina sina we matatate Yesu mune woure ane Faeratibai mata. ");
INSERT INTO yrb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mataro Faeratima Yesuba wei, A Ju uwaranu kinie weina aiwiade wei. ");
INSERT INTO yrb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Weiro dera fuyo ode sina weta uwarama wawei sina faiyawere webitaro Faeratima wei, emanu wawei sina derawere rairo a aneba sina mui wiawa utasu wei? ");
INSERT INTO yrb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Weiro Yesuma wiawa sina uiba Faerati neno kirifu ui. ");
INSERT INTO yrb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Godima Isaraero uwara Ijifiroma woure ani ogaro kowaro i uwarama dibura amara demuraiba webaitaro dera yawoeta amarama uregari utebasu. ");
INSERT INTO yrb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","I kowaro mui eme ma uieta amara Barabasini moana eme ma uieta urane yarane ueta uwaraini diburaro ibita. ");
INSERT INTO yrb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Guruguru ubita uwarama Faeratibai fatate weita, anu baeta edono ua weita. ");
INSERT INTO yrb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Weitaro Faeratima wei, Junu kini waita amara uregari uma wei? ");
INSERT INTO yrb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wei ina dawa iwata, i uwara Yesuba ubusi uyareda we imutate mutaba iba eno wei. ");
INSERT INTO yrb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Weiro fuyo ode sina weta uwarama i uwarabai inareda weita, Barabasi uregari ua wiawe weitaro nauteda Yesuba ibo derawere uta. ");
INSERT INTO yrb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Enoma enoma we inarebitaba weitaro Faeratima nono wei, Ju uwaranu kini waita amara anene umau wei? ");
INSERT INTO yrb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Weina korosiro odia weita. ");
INSERT INTO yrb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","15","Weitaro wei, Danu siosade, ane usinu wei? Weina korosiro odia derawere webitaba emanu unu ufie uteda Barabasi uregari uite weiro Yesu isuma urebita. Utaro Faeratima Yesu korosiro ure odifitae emaba mai. ");
INSERT INTO yrb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Meremere uwarama Yesu woutate wawaroma dera su fefenaro woure anitate emanu domayamutu yua weitaro fata. ");
INSERT INTO yrb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","18","Fataro i dera yawoeta uwaranu kukuiwere yafa wadia ma barutate sinisini bobo emetu ubu uteda kofiriro barue oitate irue weita, Ju uwaranu kini eawe weita. ");
INSERT INTO yrb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eno weitate isuma kofiriro ureda witua uteda jejerigari uteda irueta sina webita. ");
INSERT INTO yrb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Enoma enoma ue me sitate kukui wadia ma kosugari ue mutate Danu ba baruetama barue oita. Eno utate korosiro odifitae woure anita. ");
INSERT INTO yrb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","22","Anebitaro Sairina su amara Saimoni Arekisanaini Rufasi emanu damama danu unu dabaroma are fariro atatate weita, Yesunu korosi woua weitate Gorogota orofaro anita. Gorogota sinanu ubina kofiri tai torowa orofa. ");
INSERT INTO yrb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","24","Iro are fataro mui amara ira bobo waini Yesuma ifie mai. Mairo okodiro korosiro oitate Danu wadiaba kasi waribo uteda aika maika muta. ");
INSERT INTO yrb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kowa mare abanaro fariro korosiro oita. ");
INSERT INTO yrb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","27","Oitate owawa utate i sina eno ewana Ju uwaranu kini, korosi deiro oitate mui waira amara sadei mui korosi enabira afu oitate mui korosi enabira afu oita. ");
INSERT INTO yrb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Godinu bukaro sinama eno wasuba iba enanari uta, Dawana i siosa utaita uwaranu ubarero ibinu eno wasuba iba enanari uta). ");
INSERT INTO yrb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","I fare anebita uwarama irueta sina weitate kofirima kereu kereu uteda yo weitate weita, A dera dubu su ma jugari ufate kowa rarogonu nono ubu ufasu weide weita? ");
INSERT INTO yrb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Weitate weita, korosiroma itate Anu torowa ma wiroa weita. ");
INSERT INTO yrb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Weitaro fuyo ode sina weta uwaraini tarawatu tisa uwaraini ema iruteda weita, aika uwara ma wirotebasute Danu torowa ma wirotawa utasu eno weita. ");
INSERT INTO yrb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Keriso, Isaraero kini korosiroma itafiro efete imufe weita. Weitaro i korosiro ibisi amara sadei enanari sara siosa sina edono weisi. ");
INSERT INTO yrb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kowa otoro i orofa atata nesiaro kowa ario utawa dumu sini ibiro kowa osugari uite ane abanaro farina kowa nono ario ui. ");
INSERT INTO yrb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kowa ane abanaro siniro Yesuma derawere wei, irai, irai, rama sabatani, i sinanu ubina Nanu Godi, Nanu Godi, aneba Na ekodinu? ");
INSERT INTO yrb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Eno weiro moana inaibita uwara nautate weita, nauawe, Dawana Iraija yua wasu weita. ");
INSERT INTO yrb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Weitaro mui amara anite uriri ari munite isuro uwanite diririwere ana tai dumamuro ma inuite Yesunu bebeturo odite wei, Iraija ido fafite mubiro efe wei. ");
INSERT INTO yrb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","38","Weiro Yesuma derawere weite ido ui. Uina dera dubu sunu dera garari ueta wadia deiroma babare eminaro itari. ");
INSERT INTO yrb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","I dera meremere amara Yesunu uieta kowa erite wei, ewa amarana Godinu ba Amara wei. ");
INSERT INTO yrb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Awetabo faiyawere yafawereroma inaibeda erebita. Meri Megidarinaini Meri, Jousefaini Jeimisi dawa dubu amara, emanu danuaini Saroumuini erebita. ");
INSERT INTO yrb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesu Gareriro ibiro i awetaba Danu buribi inarebita. Inareda yawotebitaro i awetaboini moana awetaboini Dawaini Jerusaremu suro are fata. ");
INSERT INTO yrb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sabate ue bou ueta kowa fariro dumu gisigisi uiba Arimatia amara Jousefa, dawa kanisoro amara, dawa Godinu yawoe arasu kowa yawotebi amara, dana Faeratibai anite Yesunu ofe nui wei. ");
INSERT INTO yrb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Weiro Faeratima Yesu ui aba me ari imuite iba danu meremere amaraba yua weite wenaueri. ");
INSERT INTO yrb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wenauerina Yesu uisinu wei. Weiro Faeratima Yesunu ofe mubie i Arimatia amara Jousefa siaia uiro ani. ");
INSERT INTO yrb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Anite reka inawere wadia oiya uite owere anite Yesunu ofe korosiroma munite wayarite woure ani. Ane gebiro uri oeta eraboro odi. Odiro dera gebiro ma uberu uberu ue are bebeto garari uta. ");
INSERT INTO yrb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Eno utaro Meri Megidarinaini Meri Jousefanu danua erebe Yesunu uri oeta kabesi esi. ");
INSERT INTO yrb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Sabate kowa me siniro Meri Megidarinaini Meri Jeimisinu danuaini Saroumuini Yesunu ofero tare oetaba muno ira oiya ue bou utate aita. Aitate Waikukuro uyatate aneda kowa ibo odiro uri oeta kabesiro fatate eta. ");
INSERT INTO yrb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Dabaro anebe weita, i dera gebiro bebeto anama ma ubefisu weita? ");
INSERT INTO yrb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","5","Kowa fariro uri oeta eraboro fare etana i gebiro ifegari ue ibiba ubarero itata. Itatana inakeo wadia bobo ayada amara i erabo banibira afu yaubiba kirifu derawere uta. ");
INSERT INTO yrb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Eno utaro wei, iya da uyawe wei. Nasareta Amara Yesu Dawa korosiro ui efoe farita wei? Dawa ewado me, Dawa uyarinu wei. Danu ainibainu ewado kabesi eawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aniawete Danu iwata ueta uwaraini Fitaba wiawe, Yesu ko Gareriro anibiro efoita. Yesuma bodere yabai wei sina enanari anibiro efoita wei. ");
INSERT INTO yrb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aneruma eno weiro amutate durami ue aneda iya uyatate iwura mameda aika uwarabai Yesu uyarinu wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Fura botai kowa waikukuro Yesu uietaroma uyarite botai i Yesu Dana bodere seitaninu siosa imumu nesia seweni (7) dawabairoma we berairo anita i aweta Meri Megidarina Dana dawabai ane fariro erite ani. ");
INSERT INTO yrb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Meri Megidarina anite ane Yesunu iwata ueta uwaraini moana naueta uwaraini Dawaba neno arama uteda sorara utebita uwara emabai ane farite wei, Yesu ba uirogo nono awona wirosinute me ibinuro nana ene weiro i wei sina nautawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","13","Duburo amara sadei dabaro anebitaro Yesu aika ofema emabai fariro eta. Etate emana anitate Danu buribi inareta moana uwarabai ane weitaro nautawa uta. ");
INSERT INTO yrb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nono duburo Danu uwara ireweni (11) ieta iteda yaubitaro emabai ane fari. Farite Danu torowa ma boroyarite emanu imutawa uetaini neno kimu uetaini ieta uwaranu emaba are weita sina nautawa uetaba dua sina wei. ");
INSERT INTO yrb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Weite nono wei, yana orofa atata nesiaro anebeawete i uwara nesiaba Godinu kotofu sina webeawe wei. ");
INSERT INTO yrb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Anama Godinu kotofu sina naufite babataito ufiro ma wirofisu. Anama Godinu kotofu sina da naufisuna siosa kabesiro anibisu. ");
INSERT INTO yrb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Eno weite wei, Nabai kimuwere imue naue utaita uwara eno ufitaita. Nanu ifuroma imumu siosa we berafitate reka sina aika webitate awe towi mubitate kae ifitaitana da ufitate ofe woureta uwaraba emanu agema deiro odifitaro wirofitaita wei. ");
INSERT INTO yrb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesu Danu iwata ueta uwaraba sina we me sinebina Godima Yesu urero woure maniro Danu banibira age afuro mane yaurite daido yaubinu. ");
INSERT INTO yrb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","I Danu iwata ueta uwarama Godinu sina aboro aboro we inarebitae anita. Anitaro Godima ema durua utebiba sina bunawere weda buna ueta derawere utebitaro i erebita uwarama we imutebita, Godima ema durua utasuro eno utaita we imutebita. ");
INSERT INTO yrb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Naiye, Tiafarasi, nanu sina ewado ea. Yesu Kerisoma buna ueta faiyawere yabai utebi. Moana uwarama Danu buna ueta erebitate Danu sina yaba webitate owawa odebe yabai matebita. ");
INSERT INTO yrb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Eno utebitaba nanu imuetana eno, Yesunu buna ueta nesia nauegou utebitaraba nesia rorowarau odimate aba siaia umane eno imuteda iba owawa utatane. ");
INSERT INTO yrb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","I buna ueta naui sina ina ba iwata ufae iba ewa owawa siaia utatane. ");
INSERT INTO yrb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Boderewere Erodi, dana gaemani dera yawoeta amara. Dana Judia orofa yawotebi. Yawotebina i kowaro mui fuyo ode sina weta amara, danu ifu Sakaraiya, iro ibebi. Danu danata demurai uwarana Abaija waita uwara ido. Dawaini danu uwaraini dera dubu suro Godinu gaukara utebita. Sakaraiyanu awetanu ifuna Erisabeti. Erisabetinu waria amarana Eroni. Eroninu uwaraini Godinu fuyo ode sina webita. ");
INSERT INTO yrb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Awetaini awera Godinu dabaro rorowarau inareda Danu tarawatuini Danu sinaini nauteda imuegou utebisi. Eno utebisiro Godima emanu kobere ueta sineta erebi. ");
INSERT INTO yrb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eno ibeda Erisabeti desini kimu uiro ero uite kuita munawa me ibebe awetaini awera buruka usi. ");
INSERT INTO yrb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","I Abaija waita uwaranu gaukara kowa ido fari. I fuyo ode sina weta uwaranu baeta eno, emanu gaukara kowa farinuba emanu ifu ifu feifaro yanatebitate bosioro youtebita. Eno utebitate guriguri utebitate ifu demurai munebita. ");
INSERT INTO yrb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","10","Enoba i kowaro Sakaraiyanu ifu muta. Mutaba Sakaraiyama dera dubu suro fuyo mafie amuite ibina i guruguru ubita uwara nesia wawaro yaubeda guriguri utebita. ");
INSERT INTO yrb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakaraiya ido inaibebe erina Godinu aneru bonana ina gibori kaiyo banibira afuro bodere inaibinono inaibiro eri. ");
INSERT INTO yrb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Eno ereda neno siosa uteda iya derawere uyari. ");
INSERT INTO yrb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Iya uyariro aneruma wei, Sakaraiya, iya da uya wei. Godima anu guriguri ueta nausinuba anu aweta Erisabetima mui amara kuita mubiro ana danu ifu Joni maibasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kuita mubiro neno kobererau uteda yaru ufawaro uwara faiyawere ema enanari yaru ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","I amakanu daisibite Godinu dera amara sibiro Godima efisu wei. Idoba anu amarama wainini siosa ogoini da ifisu. Danu danua dawa mubiro Godinu Imumu Kotofuma danu neno ubarero itafisu. ");
INSERT INTO yrb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","I amarama Godinu sina bunawere wegou ufite eme faiyawere ma owefiro emanu Dera Godibai anibitaita aneruma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iraijanu ueta sinetaini bunaini dana mubite dawa ko anibisu. Anibite emanu damamamutuini koiniboroini ma demurai ufiro ibifitaita. I Godinu sina naue ekoeta uwaranu neno ma owereibiro nono imueta kobererau imuteibitaita. Dawa i uwara eno ue bou ufiro Dera Waria Amara ido fafisu, aneruma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Weiro Sakaraiyama aneruba wei, nanu awetaini naini buruka uwaraba anene umate iwata umau wei? ");
INSERT INTO yrb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Weiro aneruma dawaba wei, nanu ifuna Geibero. Na Godibai ibatane wei. Godima na ewa kobere sina aba wemane iba siaia usinuro iba fanea wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Weite nono wei, nanu sina nautawaba awonaroma i kuita mubisu kowaro wate mu ufate sina wate da webasute me ibifaro Nanu wene ba enanari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Eno utebisina i guruguru ubita uwarama Sakaraiya yowetebe osi utate we imuta, i amarana aneba ubarero yafawere ibinua we imuta. ");
INSERT INTO yrb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sakaraiyama dera dubu su ubareroma wawaro itarite emaba sina webie uite wiawa uiba i uwarama we imuta, dawa tubetube erinu aba we imuta. We imutaro Sakaraiyama wate mu uiba emaba sina wiawa uite agema torowa wanawana ui. ");
INSERT INTO yrb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Eno uite moana kowaro wate wiawa me mu ue ibebe danu gaukara kowa me siniro suro ido ani. ");
INSERT INTO yrb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Duburo Erisabetima dia munite sakara fai (5) suro feare yaubebi. ");
INSERT INTO yrb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Dana eno wei, na kuita munawaba nanu bodere ibetana aramawere. Awonana Godima na kobererau erasuba emema na da irufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Erisabeti sakara sikisi (6) dia bobo ibina Godima Danu aneru, Geibero siaia uiro aneruma tararite Gareri orofa Nasareta suro ani. ");
INSERT INTO yrb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","28","I suro mui udiri waribo iwata me aruma ibi. Iro ibebiro mui amarama i aruma buritawa me aworau ibi. Iro me ibebiro mui amarama i arumanu ofe buritawa, i arumama mui amara awera mubie me karu inaibi. I dana mubisu amaranu ifuna Jousefa. Dawa Deiwidinu sisia amara. I arumanu ifuna Meri. Aneruma i arumabai farite wei, yaubinu, Godima ama kobererau utasuba ana Godinu mune odi aruma. Godima abai ibinu wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Eno weiba Merima neno siosa derawere uteda we imui, aneba i ario sina nabai eno wasu we imui? ");
INSERT INTO yrb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","31","I aneruma Meriba wei, iya da uya wei. Godima a kobererau erasuba dia mubate amara mubasuna Danu ifu Yesu maibasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Dana dera amarawere sibiro uwara nesia Dawana I Dera Godinu Amara webitaita. I dera Godima Danu sisia amara Deiwidinu yawoeta kabesi mafiro i Isaraero uwara yawofiro Danu yawoetana da me sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Weiro Merima aneruba wei, na awera meba anene umau wei? ");
INSERT INTO yrb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aneruma dawaba wei, Godinu Imumu Kotofuma abai tarafiro i urero Dera Godinu buna derawerema abai mafiro tare a obari ufisuba iba amara mubaro Godinu kakara amara webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Weite wei, anu atae Erisabeti buruka awetama bodere dia munite i desini kimu waita awetanu sakara awona sikisi (6) me sininu wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ina kimu me, Godima anene webite Danu webisu enanari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aneruma eno weiba Merima dawaba wei, na Godinu gaukara aruma ewadoni eate anu wenu sina enanari ua wei. Eno weiro aneruma Meri ekodite ani. ");
INSERT INTO yrb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Merima moana kowaro yaubebe uyarite mui Judia orofa maidani suro mani. ");
INSERT INTO yrb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","43","Merima Sakaraiyanu suro mane farite Erisabeti ario weina Erisabetinu kuita desini ubarero wawana ui. Eno uiro Godinu Imumu Kotofuma Erisabetinu neno ubarero itariba Erisabetima derawere wei, Godima a i aweta nesiabairoma ma kobererau utasute anu mubasu kuita ma kobererau utasu weita wei, nanu Dera Waria Amaranu danuama aneba nabai farinu wei? ");
INSERT INTO yrb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Anu ario wenuro naunero nanu kuita desiniro yaru utedaba wawana usinu wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ana Godinu sina nautasuba Godima a ma kobererau utasu. Dawa aba we bou ui enanari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Eno weiro Merima wei, nanu neno ubareroma Godi we ma derawere utatanete Godi nanu Wiroeta Amara weda yaru uteda watane. ");
INSERT INTO yrb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Godima Danu gaukara aruma erasuba iba eno utatane. Enoba i duburo fafitaita uwara nesia na kobererau webitaita watane. ");
INSERT INTO yrb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nanu buna Godima na ma kobererau uiba Danu ifuna kakarawere. ");
INSERT INTO yrb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","51","Ana anama Dawa imuegou ufitaro awona uwaraini nesia neno arama derawere ufisu watane. Danu age bunawere. I siosa imueta sasae bobo uwara ma beratasuro aika maika anaita. ");
INSERT INTO yrb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I dera buna yawotaita uwara mu sanasute i dera me uwara ma uyarasu. ");
INSERT INTO yrb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I osi urasu uwaraba kobere kobere ibaiabai matasuro dia uraita. I ibaiabai faiyawere bobo uwaraba matawa utasute we yowereda aniawe wasu. ");
INSERT INTO yrb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Danu bodere durua ueta neno arama we bou ueta imutasute ya Isaraero uwara durua utasu. ");
INSERT INTO yrb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Godima yanu Babamutu, Eibaramuini danu abua demurai uwaraini nesia neno arama ueta we bou uiba enanari utasu watane, Merima i sina eno we ma kobererau utebi. ");
INSERT INTO yrb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri iro sakara rarogonu ibebe ekodite danu suro ani. ");
INSERT INTO yrb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Erisabetinu kuita muneta kowa fariro dana amara muni. ");
INSERT INTO yrb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Amara muniro danu abua demurai uwaraini su uwaraini nesia nautate we imuta, Godima Erisabeti neno arama derawere usinuba iba amara muninu, we imutate yaru uta. ");
INSERT INTO yrb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Kowa eita (8) me siniro i Ju uwaranu baeta kuitanu ofe tureta kowa fariba i uwara nesia fatate guruguru uteda weita, danu damamanu ifu, Sakaraiya mamia weitaro Erisabeti nauite wei, me, danu ifuna Joni wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","63","Weiro nautate weita, ema, yanu abua demurai uwarabai i eno ifu meya, kodia weitate danu damamaba age wanawana utaro Sakaraiyama age moko wawawana uiro feifa mataro Sakaraiyama owawa ue odi, danu ifuna Joni, odi. Eno odiro i uwara nesia neno kirifu uta. ");
INSERT INTO yrb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sakaraiyama owawa ue odiro danu sina wiawa utebi me siniro sina wate weite Godi we ma kobererau utebi. ");
INSERT INTO yrb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Eno utebiba i uwara nesia iya uyata. I sina Judia maidani orofa aboro we inarebitaro nautebita. ");
INSERT INTO yrb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","I sina nauta uwara nenoma we imuta, Godinu buna i amakanubai ibinuba daisibite ane ufisu we imuta. ");
INSERT INTO yrb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","68","Godinu Imumu Kotofuma Joninu damama Sakaraiyanu neno ubarero itariba Sakaraiyama sina eno we bou uite wei, ya Isaraero uwaranu Dera Godima ya uwarabai tararasute ya ma wirotasuba Dawa we ma kobererau utaisi. ");
INSERT INTO yrb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Godima Danu we bou ueta uwaranu bebeturoma bodere wei enanari utasu. Godima mui amara Deiwidinu sisia uwarabairoma ma uyari. I Amarana bunawere ma wiroeta Amara. ");
INSERT INTO yrb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","72","Yaba wasai utaita uwara ufite anama yaba neno ka utaita uwaranu ageroma ya ma darefite odifiro merau anibeisi. Danu bodere wei sina enanari utasu. ");
INSERT INTO yrb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Godima yanu baba Eibaramu imuteda neno arama uteda Danu we bou ui sina enanari utasuba yaba wasai utaita uwaranu ageroma ya ma darefite ya ma kobererauini we ma fira ufisu. Iba iya da uyafete Godinu iboro kobere ueta sineta ue ibeda rorowarau uteibeisi wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Weite wei, a nanu amararatu, aba yanu Dera Godinu we bou ueta amara webitaita. A ko anibate yanu Dera Waria Amaranu daba ue bou ufasu. ");
INSERT INTO yrb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Danu sina webaro naufitaro emanu neno neno mubite dubenaro sabisuba Dawa imufitaita. ");
INSERT INTO yrb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Godima ya neno arama derawere utasuba i dera ario ari ureroma tarafite i dumuini uietanu utumuro ibinita uwara ario ufite yanu daba mawetu ufiro merau ibifeisi watane wei. ");
INSERT INTO yrb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","I amakanu ibebe daisinite danu neno Godibai odeda neno kobererau ui. Dawa eme ibawa orofaro ibebe ibebe Isaraero uwarabai we mawetu ufie fari. ");
INSERT INTO yrb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","I kowaro Sisa Agasitasi dawa Romani gaemani amara, dana mui tarawatu owawa ue odite siaia uiro aboro aboro woure anitaro nauta. I tarawatuna ifu ifu yawieta tarawatu. I orofa atata uwara nesianu ifu ifu mubie iba i tarawatu owawa ue odi. ");
INSERT INTO yrb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kuiriniasima Siria orofa yawotebina ifu ifu yawieta tarawatu reka fari. ");
INSERT INTO yrb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","I uwara nesia emanu danua damamanu suro ifu bukaro odifitae anita. ");
INSERT INTO yrb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jousefa, dawa Deiwidinu sisia amaraba Gareri orofa Nasareta suroma Judia orofa Betiremu su, Deiwidinu suro mani. ");
INSERT INTO yrb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Dawaba datu mata dia bobo aruma Meri munite emanu ifu bukaro odifisie manisi. ");
INSERT INTO yrb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Mane ibisina Merima danu botai amara munite wadiama wayare borumakaunu ieta ieta kabesiro odiro ainibi. Ba suro kabesi meba iba borumakaunu ieta ieta kabesiro odi. ");
INSERT INTO yrb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","I orofaro moana mamoe yawoeta uwara emanu mamoe dumuro yawotebita. ");
INSERT INTO yrb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yawotebitana Godinu aneruma emabai fariro Godinu araetama ario derawere ari i mamoe yawoeta uwara ario uiba i uwara iya derawere uyata. ");
INSERT INTO yrb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","I aneruma emaba wei, iya da uyawete nanu sina nauawe wei, kobere sina wemaro eme nesia nauteda yaru ufitae iba yabai fanea wei. ");
INSERT INTO yrb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Weite nono wei, i ma wiroe mune aneta amara, Dawa i Mesaia, Godinu Keriso, Danu danuama awona muninu wei. ");
INSERT INTO yrb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Danu ereta tananana eno, aniawete eawe, wadiama wayareta bobo borumakaunu ieta ieta su kabesiro ainibinu iro dobere atafoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Eno weina ido buna aneru faiyawere i anerubai fatate Godi we ma kobererau utate weita, Godinu ifu ma derawere ufeisi weita. Ana anama Godinu sina naufitaitana Danu wesa mafiro merau ibifitaita. ");
INSERT INTO yrb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aneruma eno weitate i uwara ekoitate urero owere manita. Manitaro mamoe yawoeta uwarama weita, Godinu aneruma weita sina Betiremu suro i kuita anibete efe weita. ");
INSERT INTO yrb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eno weitate sau sau anita. Ane fatate etana Merini Jousefa yaubisiro kuitana borumakaunu ieta ieta kabesiro ainibiro eta. ");
INSERT INTO yrb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","18","Etate ane i aneruma i kuitaba wei sina eme faiyawereba weitaro i sina nauta uwarama neno kirifu uta. ");
INSERT INTO yrb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","20","I mamoe yawoeta uwarama owetate emanu orofaro anitate iro yaubeda anerunu sinaini emanu eretaini imuteda Godi we ma kobererau utebita. Merima emebai sina wiawa, nesia nenoma imuegou utebi. ");
INSERT INTO yrb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kowa eita (8) me siniro Danu ofe tutate Danu ifu Yesu mamita. I ifuna aneruma bodere Meri dia munawa kowaro we bou ui enanari mamita. ");
INSERT INTO yrb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Merinu kakara uroetaini fuyo oeta kowa ido fari. Ina Mosesinu tarawatuba Yesu mutate Jerusaremu suro Yesu Godibai odifitaro efie woure anita. ");
INSERT INTO yrb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Godinu bukaroma eno wasu, awetama amara botai mubisuna Godibai odifiro Godima efisu. ");
INSERT INTO yrb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eno wasuba Merini Jousefaini emanu kakara uroeta fuyo odifitae iba anita. I fuyona uku sadeini o ubani sadei. Ina emanu tarawatuba iba i Isaraero uwarama eno utebita. ");
INSERT INTO yrb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","I kowaro mui amara, danu ifuna Simioni, dawa Jerusaremu suro ibebi. I amarama iro ibeda Godi imuteda gaukara rorowarau utebi. Dana ya Isaraero uwaranu ma wiroeta efie uteda ibebi. Godinu Imumu Kotofuma auboko dawaba wei, ana da uifate Godinu we bou ue odi Keriso efate duburo uifasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Godinu Imumu Kotofuma Simioniba weiro iba Simionima dera dubu suro ani. Iro ane inaibina Merini Jousefama i tarawatu sina enanari ufitae Yesukanu woure fata. ");
INSERT INTO yrb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","32","Woure fatate Simioni etaro i kuita munite Godi we ma kobererau uteda wei, Dera Godi, Anu naba we bou ui amara eratane, Anu eme nesiabai odi ma wiroeta amara erataneba na ido uimane watane wei. Weite wei, Anu odi Amara, Dana i Ju me aika uwara nesianu dera ario ari. Dana yanu Isaraero uwaranu aretaba uwara efitaita, Simionima eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Eno weiro Merini Jousefaini i kuitaba wei sina nausite neno kirifu usite imutebisi. ");
INSERT INTO yrb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simionima Merini Jousefa we ma kobererau uite Meriba wei, ewa amakanu ea. Dawa Danu imueta derawere odifisuba moana uwarama ibo uteda Danu imueta da mubitaita. Dawa durua ufisuna moana uwarama Dawa ekodifitaro moana uwarama Dawa naufitate neno kobererau ufitaita. ");
INSERT INTO yrb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Dawa uwara faiyawerenu neno ubarero imueta ma boroyafisu. Enoba ana neno arama derawere ufasu, kaiyama anu neno umaneta ari ufasu. ");
INSERT INTO yrb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","I kowaro mui we bou ueta aweta danu ifuna Ena, dawa dera dubu su fefenaro ibi. Dana Fanueronu aruma, i Asura Ju uwarana danu abua demurai uwara. I awetana burukawere. Aweraini oya seweni (7) ibebisiro awera uiro danu torowa oya faiyawere, eiti fo (84) ibebi. I awetama dera dubu su ekodawa, iro kowaini dumuini ibeda guriguri uteda moana kowaro ieta itawa utebi. ");
INSERT INTO yrb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simionima sina we me sinina i aweta ido farite kuita erite Godi we ma kobererau ui. Duburona i ma wiroeta amara efitae Jerusaremu su uwarabai wei, i ma wiroe mune aneta Mesaia waita amara na ere. Enoma enoma webi. ");
INSERT INTO yrb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Merini Jousefa Godinu tarawatuma wei sina enanari utebisina Jerusaremu su ekoisite iroma Gareri orofa, emanu Nasareta suro anisi. ");
INSERT INTO yrb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","I amakanu daisinebina buna utebite iwata derawere munebiro Godima Dawa ma kobererau utebi. I Yesukanu dera dubu suro ani. ");
INSERT INTO yrb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Danu danuaini damama oya ainewaure Jerusaremu suro Godima Isaraero uwara Ijifiroma woure aneta ogaro anebisi. ");
INSERT INTO yrb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu oya tuero (12) muniro emanu kakara anebita enanari anita. Iro ane ibebita. ");
INSERT INTO yrb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","I ogaro me siniro danuaini damama Jerusaremu su ekoisite anisiro i otowa amara Yesu anawa, Danu torowa Jerusaremu suro me ibi. Danuaini damama Danu ibeta iwata meba we imuta, Danu domayamutuini uruama anaita we imuteda i kowaro rorowarau anebisi. Dumu sibie uiro Yesu emabai farawa uiba Dawa dobesi. Emanu su uwaraini domayamutuini ema nesiabai doberebe atanawa usi. ");
INSERT INTO yrb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Atanawa usiba owesite Jerusaremu suro dobefisie anisi. ");
INSERT INTO yrb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Iro ane fasite kowa rarogonu me siniro dera dubu suro atasi. Yesuma i dera tisa uwaranu abanaro yaubeda sina nautebite moko sina wenauereda webi. ");
INSERT INTO yrb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Eno utebina i uwaraboma Danu webi moko sina nauteda neno kirifu utebita. ");
INSERT INTO yrb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yesu eno utebina danuaini damama ereda neno kirifu usiro Danu danuama wei, nanu amara, aneba yaba eno usinu? Anu amamaimi naini a doberegou uisi wei. ");
INSERT INTO yrb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Weiro Yesuma wei, anene Na doberaita? Nanu Babanu suro yaubinero aneba iwawa utaita wei? ");
INSERT INTO yrb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Eno weiro Merini Jousefama Danu sina iwawa usi. ");
INSERT INTO yrb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesuini ema ido owetate Nasareta suro tanita. Yesuma emaba gifena utawa utebi. Danu danuama ina nesia wiawa uteda nenoma me imutebi. ");
INSERT INTO yrb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu daisinebina buna utebite iwata derawere munebiro Godima Dawa ma kobererau utebiro eme Dawa we ma kobererau utebita. ");
INSERT INTO yrb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Taibiriasi Sisa, Romani gaemani dera yawoeta amara, dawa oya fifitini (15) i orofa nesia yawotebi. Danu botai yawotebi oya fotini (14) me siniro dubu oya yawotebina Godima Danu sina Jonibai siaia uiro dawabai tarari. Joni Sakaraiyanu amara, dawa eme ibawa orofaro ibebiro Godinu sina dawabai tarari. I kowaro Faeratina Judia orofa yawotebi. Erodima Gareri orofa yawotebi. Erodi danu dabue Firifima Aituriaini Turekonaitini orofa yawotebi. Risaniasima Eibirina orofa yawotebi. Einasini Kaiyafasini ema i dera fuyo ode sina weta gaukara utebisi. ");
INSERT INTO yrb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","I kowaro Godinu sina Jonibai tarariro nauite Jonima Jodani ogo ewafuini etarafuini Godinu sina aboro aboro we inarebi. Yanu neno neno ueta dubena sawero Godima yanu neno neno ueta mubite imutawa ufiro ya babataito uma. I sina eno we inarebi. ");
INSERT INTO yrb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","5","Isaiyama Godinu we bou ueta amarama danu bukaroma eno owawa ue odi, dana eme ibawa orofaro sina we inareda wasu. I Dera Waria Amaranu daba wabue moya uawe. Daba maidanini fafaini kifuru kafuruini ma nabi uawete i daba ma rorowarau uawe. ");
INSERT INTO yrb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Eme nesia Godinu ma wiroeta amara efitaita wasu, Isaiyama eno owawa ue odiro Jonima enanari ui. ");
INSERT INTO yrb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Uwara faiyawere Jonibai babataito ufitae fataro Jonima emaba wei, ya tabainu nanatu! Anama Godinu fafisu neno ka yaba weiba iba serigari ufoe nabai durami ue farita wei? ");
INSERT INTO yrb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Aniawete ueta ba me dubena afu sawete kobere ueta iboro odiawero Godima efiro ya babataito uma wei. Weite nono wei, me sara uyafote yana Eibaramunu sisia weboitana Godima Eibaramunu sisiana gebiroma ubu ufie ufisuna ubu ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Godinu koto fanisi kowa fafiro ufie utasu. Amarama kowa ramamasute ana umafie utasu enanari Godinu koto, i ari, yanu siosa ueta sineta umafie utasu. Mui ana kobere tai da uwafiro umane tufite mune inaro sabisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Eno weiba i guruguru ubita uwarama weita, ya anene ufene wasu weita? ");
INSERT INTO yrb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Eno weitaba Jonima wei, dei barueta sadei bobo amarama barueta me amaraba demurai mafisu. Enanari ieta bobo amarama nata ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Moana takesi muneta uwarama Jonibai babataito ufitae fatate weita, ya anene ufene wasu weita? ");
INSERT INTO yrb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Weitaba Jonima emaba wei, i Romani gaemani uwaranu waita takesi torowa muawete nono mui me sara deiro takesi da muawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ami uwarama dawabai fatate weita, yade, anene ufene wasu weita? Weitaba Jonima emaba wei, eme me sara da uawete emanu oi waira da uawete yanu fei oi torowa muawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ju uwara nesia i ma wiroe mune aneta Mesaia waita Amara yawoegou utebitaba emanu aika we mataneda weita, Joni, dawa Godinu Mesaia aba me? Emanu emanu eno weita. ");
INSERT INTO yrb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eno webitana Jonima emanu imueta iwata uteda emaba wei, nana ogoma babataito utatane wei. Duburo mui Amara nanu buribi afiro Danu buna derawere na ari me. Na kobererau meba Danu ibo didi da inare tumau wei. Dawa Godinu Imumu Kotofuini ina yaretama ya babataito uegou ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dawa Danu uiti tai koru kafae ma kobererau ufie saboroma uiti tai etu sanasu. Etu sanasuro oyauma ifuru afuru aika kabesiro woure odasuro uiti tai kafaero itarasu. I ba tai su koruro odasute ifuru afuru da uifisu inaro sanasu. Inama ifuru afuru yareiene yareiene yareibisu Jonima wei. ");
INSERT INTO yrb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jonima enoma enoma we kakara utebite Godinu kotofu sina i uwaraba webi. ");
INSERT INTO yrb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Gareri orofaro dera yawoeta amara, Erodima danu dabuenu aweta Erodiasi ma dare munite danu ueta ba me faiyawere utebi iba Jonima dua sina wei, Erodiba, iba Erodima Joni diburaro odi. Erodima Joni diburaro odiba ina danu botai ueta siosawere. ");
INSERT INTO yrb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Jonima i uwara nesia babataito ue me sinite Yesu babataito uiro Yesuma guriguri uteda webina ure eba ui. Ure eba uiro Godinu Imumu Kotofu, ubani gasira ari, Dawabai tarariro ureroma sina tararite wei, A Nanu Amara ubiba Nanu neno Abai ibinuro yaru utatane wei. ");
INSERT INTO yrb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesunu daisineta oya toti (30) muniro uwarabai Danu kotofu sina webi. Uwarama weita, Dana Jousefanu amara, weita. Jousefa, dana Eirinu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eiri, dana Matatinu amara. Matati, dana Riwainu amara. Riwai, dana Merokainu amara. Merokai, dana Janainu amara. Janai, dana Jousefanu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jousefa, dana Matataiasinu amara. Matataiasi, dana Eimosinu amara. Eimosi, dana Naumunu amara. Naumu, dana Esorinu amara. Esori, dana Neigainu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Neigai, dana Metinu amara. Meti, dana Matataiasinu amara. Matataiasi, dana Simeinanu amara. Simeina, dana Jousekanu amara. Jouseka, dana Jodanu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda, dana Joananinu amara. Joanani, dana Reisanu amara. Reisa, dana Serubabeonu amara. Serubabeo, dana Sirutionu amara. Sirutio, dana Nerinu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, dana Merokainu amara. Merokai, dana Adinu amara. Adi, dana Kosaninu amara. Kosani, dana Emodamunu amara. Emodamu, dana Erunu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eru, dana Josuanu amara. Josua, dana Iriesanu amara. Iriesa, dana Joriminu amara. Jorimi, dana Matatinu amara. Matati, dana Riwainu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Riwai, dana Simioninu amara. Simioni, dana Judanu amara. Juda, dana Jousefanu amara. Jousefa, dana Jonamunu amara. Jonamu, dana Iriekiminu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Iriekimi, dana Mereanu amara. Merea, dana Menanu amara. Mena, dana Matatanu amara. Matata, dana Neiteninu amara. Neiteni, dana Deiwidinu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deiwidi, dana Jesinu amara. Jesi, dana Oubedinu amara. Oubedi, dana Bouasinu amara. Bouasi, dana Samoninu amara. Samoni, dana Neisoninu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Neisoni, dana Aminadabunu amara. Aminadabu, dana Adamininu amara. Adamini, dana Aninu amara. Ani, dana Esaronunu amara. Esaronu, dana Feresinu amara. Feresi, dana Judanu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda, dana Jeikofunu amara. Jeikofu, dana Aisikinu amara. Aisiki, dana Eibaramunu amara. Eibaramu, dana Tiranu amara. Tira, dana Neionu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neio, dana Seruganu amara. Seruga, dana Reunu amara. Reu, dana Fereginu amara. Feregi, dana Eberinu amara. Eberi, dana Siranu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sira, dana Kenaninu amara. Kenani, dana Afakadinu amara. Afakadi, dana Seminu amara. Semi, dana Noanu amara. Noa, dana Remekinu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Remeki, dana Metiuseranu amara. Metiusera, dana Inokinu amara. Inoki, dana Jeiredinu amara. Jeiredi, dana Mererianu amara. Mereria, dana Kenaninu amara. ");
INSERT INTO yrb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenani, dana Enosinu amara. Enosi, dana Setinu amara. Seti, dana Adamunu amara. Adamu, dana Godinu amara. ");
INSERT INTO yrb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Godinu Imumu Kotofuma Yesunu neno ubarero itarite inune ui. Yesuma Jodani ogo ekodite owere ani. Owere anebina Godinu Imumu Kotofuma Yesu eme ibawa orofaro woure ane odi. ");
INSERT INTO yrb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ane odiro Yesuma iro kowa foti (40) ibebina seitanima Yesu ue erebi. Yesuma kowa foti (40) iro ibeda ieta itawa me ibebe kowa me siniro osi derawere uiro. ");
INSERT INTO yrb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Enoba seitanima Yesuba wei, A ba Godinu Amarana wiaro ewa gebiro buredi sibi wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Weiro Yesuma seitaniba wei, Godinu bukaroma eno wasu, emema ieta torowa ifitaitana emanu ibetana ba me wasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Weiro seitanima Yesu munite mui orofaro woure ane odite i orofa atata kabesini uwaraini nesia sau ma boroyariro eri. ");
INSERT INTO yrb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Eriro seitanima Dawaba wei, i kabesini uwaraini nesia naba mairo ina nanuba anaba mamane umauna mamau. Ewa orofa atataini gugua gubarini ewa nesia aba mamaro yawofasu. ");
INSERT INTO yrb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nanu buri gigirariro arubi ufate na guriguri ufasuna i nesia Aba mamau wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Weiro Yesuma wei, ewa sina Godinu bukaro eno ibinu, i Dera Godi torowa guriguri uawete Danu gaukara torowa uawe eno ibinu, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Weiro seitanima Yesu munite Jerusaremu suro woure ani. Ane farite dera dubu su etu fou deirowere woure mane odite wei, Ana Godinu amarana ewadoroma bibu uate taniaro Godima Danu bukaro wei enanari Danu aneruma A yawoteda agema maibitaro merau tane itaro Anu buri gebiroma da ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Weiro Yesuma dawaba wei, Godinu bukaroma eno wasu, anu Dera Godi da ue ea wasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seitanima danu siosa ue ereta nesia me siniro Yesu ekodite mui kowaro ue efie ani. ");
INSERT INTO yrb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Godinu Imumu Kotofuma Yesu buna derawere mairo Yesuma Gareri orofaro nono ani. Uwara faiyawere Danu sina i orofa aboro aboro we inarebita. ");
INSERT INTO yrb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesuma i Ju uwaranu dubu su suro we mawetu utebiro nautebitate Dawa we ma derawere utebita. ");
INSERT INTO yrb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesuma Nasareta suro fari. Bodere Yesu Dawa kikiraturo i Nasareta suro ibebi. Danu baeta enanari sabate kowaro Ju uwaranu dubu suro amutebi, i kowaro enanari uite sina yawifie uyari. ");
INSERT INTO yrb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Uyariro i we bou ueta amara Isaiyanu buka mui amarama Dawaba mairo muni. Buka mairo munite ma wuraite i sina ane dobere atani. I sinana eno, ");
INSERT INTO yrb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Godinu Imumu Kotofuma Nabai ibinu iba Dana Naba wei, i ibaiabai me uwarabai Godinu kobere sina webia wei iba watane. Na siaia uina i sina wemane fare. I sina eno wemane ya diburaro ibinono ibinita uwara kodiawete aniawe. Ya diti basugari ue ibeta ari ibinita uwara ya eawe. Ya kimu yawotaitaro ibinita uwara iroma kodiawete aniawe. ");
INSERT INTO yrb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Godinu kobere yawoeta kowa fafie utasu eno wemane fare. ");
INSERT INTO yrb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","I sina eno yawite buka garari uite i buka yawotebi amaraba maite yauri. Yauriro i guruguru ubita uwarama Dawa eregou uta. ");
INSERT INTO yrb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesuma yaubeda wei, awonana yanu nauita Godinu bukaro sina enanari usinu wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Eno weiba i uwarama we mataneda weita, Danu sinana kobererau weitate Danu bebeturoma fari kobere sinaba neno kirifu utate weita, ewa anene? Dana Jousefanu amara aba me weita? ");
INSERT INTO yrb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Weitaro Yesuma emaba wei, yanu imueta Na iwataba yanu bodere ikiki eno weboita, dogeta amara anu torowa ma wiroa. I ubina eno, anu Kafenamu orofaro buna utebi anu ba suro enanari ua weboita wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Eno weite nono wei, Nanu ba sina wemaro nauawe wei. Mui we bou ueta amaranu su uwarama dawa kakara utawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ba watane, Iraija imue eawe! Iraijanu ibeda utebi gaukara kowaro wabu awetabo faiyawere ibita. I kowaro oya rarogonuini nono mui oya abanaro obi matawa me ibebiro sinai derawere fari. ");
INSERT INTO yrb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Fariro Godima Iraija danu su wabu awetabobai siaia utawa uite Iraija Saidoni orofa Serefati su wabu aweta torowabai siaia uiro aniro durua ui wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","I we bou ueta amara Iraisa imue eawe! Dana Siria orofa buri age amaima amara, Neimani ma wiroite i Ju buri age amaima uwara ma wirotawa ui wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","29","Yesu eno weina i Ju dubu suro yaubita uwarama ubusi uyareda uyatate Yesu badedema mutate su maidani woforo sabitae woure anita. ");
INSERT INTO yrb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Anebitana Yesuma ema ekodite me ari uite ani. ");
INSERT INTO yrb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","32","Yesuma Gareri orofa Kafenamu suro tarani. Iro tare farite sabate kowaro i uwara we mawetu uiro Danu buna sinaba neno kirifu uta. ");
INSERT INTO yrb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","I Ju uwaranu dubu suro seitaninu mui imumu siosama rewoeta bobo amara yaubi. I suro yaubeda iroma derawere wei, Yesu Nasareta Amara, kodia! A yaini ane ue matafene arinu wei? Na iwata, ya ma arama ufae iba arinu. Na iwata A, Ana Godinu kakara amara wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Eno weiba Yesuma sau wei, da wiate neno ubareroma amuate ania wei. Yesu eno weiba, i seitaninu mui siosa imumuma i amara mu saniro itariro i seitaninu mui siosa imumuma i amara mui me sara utawa uite ekodite ani. ");
INSERT INTO yrb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Eno uiro i ereta uwarama neno kirifu uteda emanu aika we matatate weita, Dana sina bunawere wasuro seitaninu mui imumunu siosama Danu sina nauteda anaita. Danu sina ane ari weita? ");
INSERT INTO yrb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","I uwarama Danu sina i Gareri orofa aboro aboro we inarebita. ");
INSERT INTO yrb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","39","Yesuma uyarite Ju uwaranu dubu su ekodite Saimoninu suro ani. Ane farite suro amuite erina Saimoninu daroyama ofe wakikiwere wourite ainibiro eri. Ido erebiro i uwarama nui weita, dawa ma wiroa weitaba Yesuma i awetabai inaibeda i ofe wakikiba me sia bunawere weiro wakiki ido toba uri. Wakiki me siniro i aweta uyarite emaba ieta mai. ");
INSERT INTO yrb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kowa itariro i su uwara emanu ofe aika maika woureta uwara nesia Yesubai woure ane oita. Yesubai woure ane oitaro Yesuma ema nesia agema buriro nesia wirota. ");
INSERT INTO yrb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Seitaninu moana siosa imumu bobo uwara woure ane oitaro Yesuma weiro seitaninu moana siosa imumuma i uwara ekoita. Ekoitate derawere weita, Ana Godinu Amara weita. I seitaninu siosa imumuma Yesu Dawa Keriso iwata utaba Yesuma emaba Na Keriso da wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Waikukuro Yesuma i su ekodite yaowere orofaro ani. I uwarama Dawa doberebe doberebe atatate nui weita, ya da ekodiate yanu Kafenamu suro yaini ibia weita. ");
INSERT INTO yrb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Eno weitaro Yesuma emaba wei, Godinu kotofu yawoeta sina mui su suro wemainiaba iba Godima Na siaia uiro ewaro farea wei. ");
INSERT INTO yrb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yesuma i Judia orofa Ju uwaranu dubu su su aboro aboro Godinu sina ane webi. ");
INSERT INTO yrb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mui kowaro Yesuma Genesareta mesau maguaro inaibeda i uwaraba Godinu sina we mawetu uiro i uwarama Dawabai fare deiro deiro uta. ");
INSERT INTO yrb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","3","Eno utaro inaibeda erina bouti sadei mesau gigirariro ibitaro eri. I bouti ubi uwarama bouti ekoitate emanu iwame mune ogoro urotebitaro erite Saimoninu boutiro ane amui. Ane amuite Saimoniba wei, jawe uaro eta eta anibe weiro enanari ui. Yesu i bouti ubarero yaubeda iroma i uwara we mawetu ui. ");
INSERT INTO yrb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","We mawetu ue me sinite Saimoniba wei, ogo sikoru ibinu i afu aniawete yanu iwame sawete erio egi wouawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Weiro Saimonima wei, Dera Waria Amara, dumuro iwame sane wourebe wourebe ogo egi wourawa usi weite nono wei, Ana wenuba iwame sabero itafisu weiro enanari uta. ");
INSERT INTO yrb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Eno utate iwame woutate erio egi faiyawere woutaba iwame ma babafie ui. ");
INSERT INTO yrb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Enoba emanu masigu agema fisufisu utaro ema durua ufitae boutiro ane fata. Ane fatate erio egi woutate boutiro oitaro bouti sadei wate fariba inufie ui. ");
INSERT INTO yrb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimoni Fitama ina erite Yesunu buri gigirari arubi uteda wei, Dera Waria Amara, nana neno neno ueta amaraba na ekodiate ania wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Dawaini danu erio egi uruama wouta uwaraini i erio egi faiyawereba iyata. ");
INSERT INTO yrb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jebedinu amara sadei Jeimisini Joni Saimoninu uruama wouta amara sadeima iba iyata. Yesuma Saimoniba wei, iya da uya wei. Awonaroma ane duburo erio egi wourasu i ari eme woufasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Emanu boutiroma maguaro ane fatate emanu ibaiabai nesia iro ekoitate Yesunu buribi anita. ");
INSERT INTO yrb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesuma mui natofo suro ibebina amaimawere amara i suro ibebi. Ibeda Yesu erite Yesubai fare buri gigirariro arubi uteda nui wei, Anu unu ufasuna na ma wirofaro wiromau wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Eno weina Yesuma age saneda i amara burite wei, ina Nanu unu. Amaima me sia weina amaima daido me sini. ");
INSERT INTO yrb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesuma i amaraba wei, eme nesiabai da wiate fuyo ode sina weta amarabai aniate mawetu uaro efi wei. Anu ofe kobererau usinuba Mosesinu tarawatu buri age amaima fuyo oeta enanari uaro emema efita wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesuma eno weiro iro eta uwarama Danu buna ueta i orofa nesiaro we inarebitaba ofe woureta uwara faiya faiyawere Yesubai wirofitae fata. ");
INSERT INTO yrb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesuma eme ibawa orofaro guriguri ufie ani. ");
INSERT INTO yrb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mui kowaro Yesuma we mawetu utebina Ferosi uwaraini tarawatu tisa uwara faiyawere farebitate Yesunu sina nautebita. I Ferosi uwarana Gareri su suini Judia su suini Jerusaremu suini iroma Yesubai fatate sina nauta. I kowaro Godinu ma wiroeta buna Yesubai ibegou ui. ");
INSERT INTO yrb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Moana uwarama age sanawa inarawa amara wiaro woutate Yesubai odifitaro ma wirofie woure fata. ");
INSERT INTO yrb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Eme faiyawere su bebeto garari utaba anawa uta. Bebetoro anawa utate emanu su fou deina fefewereba iba i sunu fou deiro amutate fou ma eba utate age sanawa inarawa amaraini danu ainibi wia warafaini ebaro oitaro Yesubai itari. ");
INSERT INTO yrb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Eno utaro Yesu emanu imueta derawere iwata uite wei, Nanu amara anu neno neno ueta munete imutawa une wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yesuma eno weiba i tarawatu tisa uwaraini Ferosi uwaraini nenoma eno imuta, i Godinu ifu ma kikiratu utasu amara anaiya? Godi torowana emenu neno neno ueta mubite imutawa ufisu eno we imuta. ");
INSERT INTO yrb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu emanu wenauereta Dawa iwataba emaba wei, yanu nenoma aneba eno imutaita wei? ");
INSERT INTO yrb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Abo sinama ofe woureta amaraba wemau? Anu neno neno ueta mumate imutawa umau, aba uyate anu wia muate ania ari? Abo sinana kimuwere wei? Ane kimu ueta umaro Nanu buna efoita wei? ");
INSERT INTO yrb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","I nasiniro inareta Ba Eme Sini Amaranu buna derawereba iba emenu neno neno ueta munatanete imutawa utatane. Ina iwawa uotoba eno umau weite i age sanawa inarawa amaraba wei, uyate anu wia muate anu suro ania wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Eno weina i amarama emanu iboro uyarite wia munite Godi we ma kobererau uteda danu suro ani. ");
INSERT INTO yrb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Eno uiro eme nesia etate neno kirifu derawere uteda iyatate Godi we ma kobererau uteda weita, awonana kamama eraisi weita. ");
INSERT INTO yrb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesu i natofo su ekodite ani. Anebina mui takesi muneta amara, danu ifuna Riwai, dawa danu takesi muneta su ubarero yaubiro eri. Yesuma erite i amaraba wei, Nanu buribi arate iwata ua wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Eno weiba i amarama ido uyarite iro ane ane nesia ekodite Yesunu buribi ani. ");
INSERT INTO yrb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Riwaima Yesunu ogaro derawere ui. Takesi muneta uwaraini moana uwara faiyawere ogaro ifitae fata. ");
INSERT INTO yrb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Emaini Yesunu uwaraini ieta uruama itebita. Enoba i Ferosi uwaraini tarawatu tisa uwaraini emana Yesunu iwata ueta uwaraba kamena weda weita, yaini i takesi muneta uwaraini neno neno ueta uwaraini aneba uruama ieta itaita weita? ");
INSERT INTO yrb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Weitaro Yesuma emaba wei, i ofe wourawa uwaraba dogeta amara arawa usinute i ofe woureta uwaraba arinu wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Enanari i kobere uwaraba wemane waya arawa i neno neno ueta uwaraba neno neno ueta dubena afu sabitae wemane waya farea wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Moana uwarama Yesuba weita, Joninu iwata ueta uwarama emanu baetaba kowa faiyawere ieta itawa ka utaitate guriguri utaita, enanari i Ferosi uwaranu iwata ueta uwarama eno utaita. Nono Anu iwata ueta uwarama eno utawa utaitate ietaini ogoini itebaita weita. ");
INSERT INTO yrb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Weitaro Yesuma emaba wei, reka aweta muneta amara ogaro ufite danu domayamutubai ibifisuba domayamutu dawabai are ifitaita. Mui kowaro reka aweta muneta amara anibisuna i kowaro ieta da ifitate ka ufitaita. Enanari emema Na woure anibitaitana Nanu iwata ueta uwarama eno ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu eno weite nono ewa kasei sina emaba wei, mui amarama reka wadia da ma babafite bodere wadia ebaro fifinu da ufisu. Eno ufisuna reka wadiaini bodere wadiaini aika maikaba i reka wadia ma arama ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nono mui sina eno wei, anama reka waini ogo bodere egi ofero adu uosoro reka wainima bodere egi ofe ma babafite itafisuba i reka wainima bodere egi ofe ma arama ufisu. ");
INSERT INTO yrb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Reka waini reka egi ofero adu ufisu. ");
INSERT INTO yrb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Enoba anama bodere waini ifite reka waini unutawa ufite webisu, i bodere wainina kobererau webisu. ");
INSERT INTO yrb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mui sabate kowaro Yesuini Danu iwata ueta uwaraini feame waiyaro inarebita. Waiyaro inareda Danu iwata ueta uwarama feame ma gogorugari utate agema burau ureda ie inarebita. ");
INSERT INTO yrb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Eno utaro Ferosi uwarama etate weita, aneba eno utaita? Tarawatuma wasu, sabate kowaro eno da uawe wasude aneba eno utaita weita? ");
INSERT INTO yrb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Weitaro Yesuma emaba wei, yanu dera sisia amara Deiwidini danu uwaraini osi urebiba ieta munebi ikiki yawitaita aba me wei? ");
INSERT INTO yrb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Weite nono wei, Deiwidima osi urebiba Godinu suro amuite weiro dera fuyo ode sina weta amarama Godinu ereta kakarawere buredi i dera dubu su yawoeta uwara torowanu itebita buredi mairo munite iteda danu uwaraba mairo ita wei. ");
INSERT INTO yrb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesuma emaba nono wei, i Ba Eme Sini Amara Dana i sabate kowanu ubi Amara. Iba Dana i sabate kowa yawotasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mui sabate kowaro i Ju uwaranu dubu suro amuite we mawetu ui. We mawetu uina banibira age arama amara ido yaubiro eri. ");
INSERT INTO yrb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","I tarawatu tisa uwaraini Ferosi uwaraini Yesu i sabate kowaro i amara ma wirofisu aba me iba erebita. Erebitaro Yesu sabate kowaro i amara ma wirofiro Danu kerere ubina ido webitate Yesu wawei webitae iba eregou utebita. ");
INSERT INTO yrb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesuma emanu imueta iwata uite age arama amaraba wei, ewado arate ina wei. Eno weiba i amarama uyarite Yesubai ane inari. ");
INSERT INTO yrb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesuma i uwaraba wei, aboma kobererau, sabate kowaro durua umau aba ma siosa umau? Ma wiromau aba ma uimau wei? ");
INSERT INTO yrb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eno weite i uwara nesia ere owere owere uite i amaraba wei, anu age sa, weiba age saniro rorowarau uite wiroi. ");
INSERT INTO yrb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Enoba i uwarama neno ka derawere utate Yesu anene ufeisi we matata. ");
INSERT INTO yrb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","I kowaro Yesuma maidaniro guriguri ufie mani. Maidaniro manite Godibai dumu nubo guriguri utebi. ");
INSERT INTO yrb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Waikukuro Danu buribi aneta uwara nesia yua weiro Dawabai mane fata. Mane fataro emabairoma amara tuero (12) we munite emaba ya afosoro uwara wei. ");
INSERT INTO yrb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","I uwaranu ifuna eno, Saimoni, mui ifu Fita mami. Fitanu dabue Enuduru, Jeimisini Jonini Firifini Batoromiuini Matiuini Tomasini Arofiasinu amara Jeimisini mui Saimoni, dawa Keinani su amara, dawaini Jeimisinu amara Judasini mui Judasi Isikarioti, Yesu do maeta amaraini, Yesuma i uwara mune odi. ");
INSERT INTO yrb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Yesuini Danu uwaraini maidaniroma fafaro tarata. Yesunu buribi aneta uwara faiyawereini Judia orofa uwaraini Jerusaremu su uwaraini enea su Tairaini Saidoni uwaraini eme faiyawere Dawabai Danu sina naufitate ofe woureta aika maika wirofitae fata. Yesuma i seitaninu siosa imumu bobo uwara nesia ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yesunu buna Dawabairoma fare amuiba i uwarama Yesu buritate wirota. ");
INSERT INTO yrb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesuma Danu iwata ueta uwara ereda wei, Godinu ure yawotasu orofa ya arama ibeta uwaranu iba yaru uawe. ");
INSERT INTO yrb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ya awona osi wouraitana duburo Godima ya durua ufiro merau ibifoitaba iba yaru uawe. Ya awonana i waita, ya duburo yo weboitaba iba yaru uawe. ");
INSERT INTO yrb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Yana i Ba Eme Sini Amaranu uwaraba emema yaba neno ka ufitate yaba me sara ufitate yanu ifu ma siosa ufitaitaba iba yaru uawe. ");
INSERT INTO yrb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","I kowaro yanu moko muneta urero muboitaba yaru uawete yanu yaru derawereba bibu uawe. I uwaranu danatamutuma Godinu we bou ueta uwaraba enanari utebita. ");
INSERT INTO yrb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Eforo! Ya eno uawero ibaiabai derawere uwara i webita. Ema awona yaru utaitana duburo i webitaita. ");
INSERT INTO yrb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Eforo! Awonana ema dia uraitana duburo osi ufitaitaba iba i webitaita. Awonana yo waitana duburo neno arama ufitaitaba i webitaita. ");
INSERT INTO yrb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Eforo! Awonana emema emaba we ma kobererau utaitana duburo Godima ema da we ma kobererau ufisuba iba i webitaita. Emanu danatamutuma i meo we bou ueta uwaraba enanari we ma kobererau uta. ");
INSERT INTO yrb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesuma i sina eno weite nono wei, ya nautaita uwaraba sina wemaro nauawe wei, Yanu wasai uwara ibo da uawero yanu neno emabai ibifi. Emema ya neno ka ufitaitana emaba kobererau uawe. ");
INSERT INTO yrb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Emema yaba sina siosa webitaitana emaba kobere sina wiawete emaba Godibai guriguri uawe. ");
INSERT INTO yrb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Anama yanu taibau ufisuna yanu mui taibau ufie oweawe. Anama yanu seti mubie webite mubisuna yanu dei baruetaini dawaba mawe. ");
INSERT INTO yrb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ana Anama emanu unu derawere ane nui webitaitana emaba mawe. Anama yanu ibaiabai yana mafaro mubisuna ibaiabai demurai nono da we muawe. ");
INSERT INTO yrb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Emema yaba ane ufitae weboitana moko enanari uawe. ");
INSERT INTO yrb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yabai anama neno arama moko moko ue matafoitana aneba urero kobere muneta muboe ufoita? I neno neno ueta uwarama enanari utaita. ");
INSERT INTO yrb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yabai anama kobererau moko moko ue matafoitana aneba urero kobere muneta muboe ufoita? I neno neno ueta uwarama enanari utaita. ");
INSERT INTO yrb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yabai anama moko moko we muboitana aneba urero muneta muboe ufoita? I neno neno ueta uwarama enanari utaita. ");
INSERT INTO yrb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yaba wasai utaita uwara neno arama uawete emaba kobererau uawete emaba me mawe. Eno ufote moko da imufoitana yanu urero moko muneta derawere muboita. Eno ufoitana i urero ibinu Godinu adarabu siboita. Yanu Godina kobererau. Dana i imutawa uwaraini siosa utaita uwaraba siosa utawa utasu. Dana wawi me. ");
INSERT INTO yrb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yanu Baba Godima uwaraba neno arama utasu enanari ya enanari uawe. Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Eno weite nono wei, moana uwaraba wawei da weboro Godima yaba wawei da webisu. Moana uwara fanisi da maforo yaba fanisi da mafisu. Moana uwaranu ueta imutawa uforo yanu ueta imutawa ufisu. ");
INSERT INTO yrb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Moana uwaraba ane ane maforo yaba mafite nono mui deiro mafite yanu negoro odifiro wate fafisu. Ane ari mafoitana enanari muboita, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesuma emaba mui kasei sina eno wei, diti basugari amarama mui diti basugari amaranu agero muneda woure anibisuna i amara sadeina kawaro itafisisi. ");
INSERT INTO yrb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ue iwata utasu amarana derawere me, tisa amarana derawere. Ue iwata utasu amara nesia ue iwata ufite duburona danu tisa amara ari sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Aneba mui amaranu diti ubarero ifururatu eregou utaitate yanu diti ubarero ibinu ana tumi erawa utaita? ");
INSERT INTO yrb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Aneba waita, kaka, ueta siosawere kikiratu ifuru ari ma mumu umau waitana nono yanu diti ubarero ueta siosararabo, ana tumi ari ibinuro erawa utaita? Ya meo meo uwara yanu diti ubarero ibinu ana tumi botai mu sabote eregou ufoitana nono yanu yatae yabuenu diti ubareroma ifuru ma mumu ufoita wei. Yesuma yanu neno neno uetaba i ikiki wei. ");
INSERT INTO yrb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesuma nono wei, kobere ana siosa tai da uwafiro siosa ana kobere tai da uwafisu. ");
INSERT INTO yrb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Emema eraita, i ana aika maika emanu tai bobo eraitate waita, i anana siosawere, i anana kobererau eno waita. Boruba tai sinisini bobo anaro munawa utaita. I gureifi nadidi tai iwuwu bobo nadidiro munawa utaita. ");
INSERT INTO yrb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","I ari, i kobere amarama danu kobere nenoroma kobererau utasu. I siosa amarama danu siosa nenoroma siosawere utasuro danu neno wate farebasuba iba eno webasu, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Aneba Na Dera Waria Amara, Dera Waria Amara waitate Nanu sina munawa uteda gifena utaita? ");
INSERT INTO yrb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ana anama Nabai fafitate Nanu sina naufitate enanari ufitaita, i uwarana i ari we enanari umau. ");
INSERT INTO yrb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mui amarama su ubu ufie ui. Su tutubu eba yafawere daure taranite tutubu gebiro deiro sanite gebiroini sakaini sanite isuma yanairo kimu ui. Danu su eno ubu uiro obi oku farite su ma jugari utawa ui. ");
INSERT INTO yrb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","I uwarama Nabai fafitate Nanu sina naufitate gifena ufitaitana i uwara ewa sina i ari we enanari umau. Mui amarama su ubu ufie uite tutubu sanawa uite su sakai deiro ubu ui. Eno uiro obi oku farite su sau ma jugari uiro i su daido me sini, Yesuma eno wei ");
INSERT INTO yrb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuma Danu we mawetu utebi sina we me sinite Kafenamu natofo suro ane fari. ");
INSERT INTO yrb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mui Romani ami kafiteninu gaukara ubi amara ofe wourite uifie utebi. ");
INSERT INTO yrb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Moana uwarama Yesunu sina weitaro ami kafitenima nauite danu gaukara amara ma wirofie moana Ju dera uwara Yesubai siaia ui. ");
INSERT INTO yrb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Siaia uiro ane Yesubai fata. Yesubai fatate nui weda weita, i amarana kobere amara, ya Ju uwaraba neno arama utasu. Dana yanu dubu su ubu ui weita. ");
INSERT INTO yrb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Eno weitaba Yesuini emaini uruama anita. Daba nubo me anebitana i ami kafiteninu siaia ui domayamutu ido are fatate Yesuba i amaranu sina eno weita, Dera Amara, na kobererau meba iba Abai farawa une. Nanu suro da arate sina torowa wiaro nanu gaukara amara wirofi. ");
INSERT INTO yrb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nana dera ami amara. Moana dera uwarama na yawotaitaro nana ami uwara faiyawere yawotatane. Enoba mui amaraba ania watanero anasu. Mui amaraba ara watanero arasu. Nanu gaukara amaraba eno ua watanero enanari utasu watane weiro are weita. ");
INSERT INTO yrb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Are weitaro Yesuma neno kirifu uite owere ereda Danu buribi aneta uwara faiyawereba wei, nautaita? I Isaraero uwarabai naueta derawere mui amara i ari atanawa une wei. ");
INSERT INTO yrb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Weiro i ami kafiteninu domayamutuma Yesu ekoitate owere suro anita. Ane fatana i amara wiroite yaubiro eta. ");
INSERT INTO yrb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mui kowaro Yesuini Danu iwata ueta uwaraini moana uwara faiyawereini Neina suro anita. ");
INSERT INTO yrb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ane farebitana i su uwarama uieta amara suroma woure amo fata. I uieta amarana danu danua waburatunu amara ubi demurai. Wabubai mui amara me. I wabu awetaini su uwara faiyawereini suroma ido amo fata. ");
INSERT INTO yrb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","14","Amo fatate anebitaro Dera Waria Amara i wabu aweta erite neno arama uteda wei, i da wia weite ane i ui amaranu wiaro buriro i wia wouta uwara ido inata. Ido inataro Yesuma wei, reka amara uya wei. ");
INSERT INTO yrb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Weina i amara yare yaurite sina wei. Yesuma i amara danu danuaba mai. ");
INSERT INTO yrb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Eno uiba i uwarama iyatate Godi we ma kobererau uteda weita, awonana dera we bou ueta amara yabairoma uyarinu. Awonana Godima ba gaukara usinuro erisi weita. ");
INSERT INTO yrb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesunu ueta Judia orofa aboro aboro mui su suro we inarebita. ");
INSERT INTO yrb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Joninu iwata ueta uwarama i sina nesia Joniba weita. Eno weitaro Jonima danu mui iwata ueta amara sadei weiro dawabai fasiro Jonima wei, yanu Waria Amarabai aniawate wiawa, ana yanu yawotaisi amara aba mui amarama fafiro efeisi? Eno ane wenaueawa wei. ");
INSERT INTO yrb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Weiro i amara sadei anisite Yesubai fasina Yesuma ofe aika maika uwaraini buri bebeu uwaraini diti basugari uwaraini seitaninu siosa imumu bobo uwaraini ma wiroiro esite Yesuba weisi, Joni babataito amarama ya siaia usinuba danu sina abai webune iba faritua weisi. Weisite Joninu sina eno weisi, Ana yanu yawotaisi amara aba mui amarama fafiro efeisi weisi? ");
INSERT INTO yrb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Weisiro Yesuma emaba wei, oweawate Jonibai aniawate yanu awona eretaini nauetaini nesia dawaba eno wiawa, i diti basugari uwarana eraitaro i buri bebeu uwarana rorowarau inaraitaro, i buri age amaima uwarana wirotaitaro ofe kobererau utasuro ibinitaro i ome gogore bobo nautawa uwarana ome nautaitaro, i uieta uwarama uietaroma uyaraitaro, i aramawere me sara ibeta uwarama Godinu kotofu sina nautaita. ");
INSERT INTO yrb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Anama Na iwawa da ufisuna Godima dawa ma kobererau ufiro yaru derawere ufisu. Jonibai aniawate eno wiawa, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","25","Joninu sina weta amara sadei anisiro Yesuma i guruguru ubita uwaraba ereda Joninu sina wei. I eme ibawa orofaro ane efoe anita? Oyauma oua ma wawana wawana utasu i ari i amara buna me, i oua ari, efoe anita? Ane efoe anita? Wadia dawana derawere bobo amara efoe anita? I wadia dawana derawere bobo uwarana eme ibawa orofaro ibawa utaitate i dera yawoeta su suro ibinita. ");
INSERT INTO yrb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Eno mena ane efoe anita? We bou ueta amara efoe anita? Nanu sina nauawe, dawa otowa we bou ueta amarana me. Dana dera we bou ueta amarawere. ");
INSERT INTO yrb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Godinu bukaroma nono dawaba eno wasu, ea, Nanu fo weta amara botai mamaro anibite Anu daba wabue moya ufiro A duburo anibasu ea wasu. ");
INSERT INTO yrb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nanu sina nauawe. I awetabonu muneta koiniborobairoma Jonina derawere, danu gaukarana botai. Ina ba. Nono Godinu yawotasu orofaro ibinu otowaratu amaranu gaukarana derawerero Joninu gaukarana kikiratu, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Eno weiro i uwaraini takesi muneta uwaraini nautate auboko Jonibai babataito utaba Godi we ma kobererau uta. ");
INSERT INTO yrb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","I Ferosi uwaraini Mosesinu tarawatu tisa uwaraini Jonibai babataito utawa utaba Godinu imueta ekoita. ");
INSERT INTO yrb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuma wei, ewa ibinita eme abo eme ari? Ewa eme ane ari wemau? ");
INSERT INTO yrb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ewa uwarana koiniboro ari watane. Koiniboroma su abanaro yauraitate emanu domayamutuba waita, buma uraisiro ya yaura urawa utaita. Sorara utaisiro ya sorara utawa utaita eno waita. ");
INSERT INTO yrb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Joni babataito amara farite moana ietata aika maika itawa, wainini itawa utebiba yana waita, dawa seitaninu mui siosa imumu bobo amara. ");
INSERT INTO yrb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","I Ba Eme Sini Amarama farinute moana ietata aika maikaini waini ogoini itasuro ereda ya eno waita, Dawa iteba gabariwere amara, waini itasuro beforo siosa utasu amara. Dana takesi muneta uwaraini neno neno ueta uwaranu domaya waita. ");
INSERT INTO yrb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ya eno waitana, nono Godinu imueta Godinu uwara imufitaitana Dawaini Danu imueta daido ba, i ere waita uwarana eno imufitaita, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mui Ferosi amarama Yesuba wei, nanu suro arate ieta ia wei. Weiba Yesuma i amaranu suro ani. ");
INSERT INTO yrb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ane ieta ifie yaubina i natofo su mui neno neno bobo aweta nauite bonana ogo gebiro kawaburo woure amo fari. ");
INSERT INTO yrb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Amo farite Yesu yaubiro i aweta Danu buri dubena afu gigirariro inaibeda i webiro inodi Yesunu buriro itari. Enoba i awetama Yesunu danu buri fouma ijima maiturite Yesunu buri koku uite i bonana ogo buriro ma wegari uiro ogo buri deiro itari. ");
INSERT INTO yrb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Eno uiro i Ferosi ieta ubi amarama erite we imui, ewa amarana we bou ueta amararona danu ofe buritasu awetana neno neno bobo aweta iwata ufi we imui. ");
INSERT INTO yrb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","41","Yesuma i amaraba wei, Saimoni, Nanu sina wemaro naua wei. Weiro i amarama wei, Tisa, wiaro nauma. Weina Yesuma wei, mui amara sadeima mui amarabai oi we musi. Mui amarama fai aderedi kina muni, (K500). Mui amarama fifiti kina, (K50) ba torowa muni. ");
INSERT INTO yrb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","I amara sadeima eno usite nono duburo oi meba moko matawa usiro i oi ubi amarama kodiawa wei. Eno weiba abo amarama i oi ubi amara neno arama derawere utasu? Imue ea, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Eno weiro Saimonima wei, nanu imuetana eno, i oi derawere we munite moko matawa ui amarama neno arama derawere utasu wei. Weina Yesuma wei, ba wasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Eno weite owerite i aweta ereda Saimoniba wei, ewa aweta erasu? Anu suro amunero a buri uroeta ogo Naba matawa usinuro i awetama Nanu buri diti inodima urosinute danu fouma ijima maiturinu. ");
INSERT INTO yrb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ana Na koku utawa usinuro dana Nanu buri koku utedibinu. ");
INSERT INTO yrb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ana Nanu kofiri deiro bonana ogo ma wegari utawaro dana Nanu buriro bonana ogo ma wegari usinu. ");
INSERT INTO yrb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Enoba aba watane, i awetama Na neno arama derawere utasuba danu neno neno ueta faiyawere muninute imutawa usinu. Ananu neno neno ueta kikiratu munasute imutawa utasuro dawa neno arama kikiratu utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Eno weita i awetaba wei, anu neno neno ueta Nana munete imutawa une wei. ");
INSERT INTO yrb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Weiro i ieta iteda sina nauta uwarama we mataneda weita, i neno neno ueta mune imutawa utasu amarana ana weita? ");
INSERT INTO yrb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesuma i awetaba wei, anu imueta derawereba wirosinu. Aniate merau ibia wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Mui kowaro Yesuma Godinu yawotasu orofa kobere sina we inarebi. Danu uwara tueroini (12) Dawaini anitaro Yesuma seitaninu moana siosa imumu bobo ofe woureta ma wiroi awetabo Dawaini anita. Moana awetabonu ifuna eno, Meri, Maderini waita aweta. Yesuma i awetanu neno ubareroma seitaninu siosa imumu nesia seweni (7) we yowerite i aweta ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","I awetaini Jusanu aweta Joana, danu awerana Erodinu mui botai mameta amara. I awetaini Susanaini moana awetabo faiyawere anitate Yesuini Danu iwata ueta uwaraba ietaini oi matebita. ");
INSERT INTO yrb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","5","Su su uwara faiyawere guruguru utaro Yesuma emaba kasei sinaroma we mawetu uteda eno wei, mui amarama yo waifie waiyaro ani. Ane farite jiru turi. Jiru turi me sinite yo mune sane inarebi. Yo sanebiro moana yo dabaro itataro emema deiro amune adire inarebitaro gasirama itebita. ");
INSERT INTO yrb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Moana yo gebirowere sakairo itatate sau waratate nasini awewewerero raraka meba yoie yoie uta. ");
INSERT INTO yrb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Moana yo sinisini bobo orobu ubarero itatate waratate orobuwereba tai uwanawa uta. ");
INSERT INTO yrb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Moana yo kobere nasiniro itatate waraegou utate tai faiya faiyawere uwata. Yo demurairaturoma mui tai wani aderedi (100) uwani weite wei, i ome bobo uwara Nanu watane sina nauegou uawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Danu iwata ueta uwarama Yesuma weita, i kasei sinanu ubina ane ari weita? ");
INSERT INTO yrb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Weitaro Yesuma wei, Godinu ununa ya Danu urero yawotasu kiwu sina naufote iwata ufoe utasute nono Dawa unutawa i uwara Danu urero yawotasu kiwu sina nauetaba iba emaba kasei sina torowa ma borobarasuro nautaita. I sinanu ubi iwawa utaitaba iba eraitate bana erawa. Nauetana nautaitate nautawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesuma eno weite nono wei, i kasei sinanu ubina eno, i yona Godinu sina ari. ");
INSERT INTO yrb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","I dabana Godinu sina nautaita uwara ari. I amarama Godinu sina we inarasuro i dabaro inaibeta uwarama Godinu sina nautaitaro seitanima sau farasute sina daido mune ma imutawa utasu, i uwarama imuotote wiroaotoba. ");
INSERT INTO yrb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Enanari moana uwarana gebirowere sakairo sani, i ari. Godinu sina nautaitate yaru utaitaro Godinu sinaba awe uyareta farasuro i sina nauegou utawa utaitaba emanu nauetana kobererau me. Kobererau meba iba i sina ekodaita. ");
INSERT INTO yrb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Moana uwara emana orobuwere orofa ariba Godinu sia nautaitate aika maika imutaitate emanu unu ibaiabai munaitate emanu unu nesia utaitate i sinanu daba garari utaitaba kobererau uegou utawa utaita. ");
INSERT INTO yrb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Moana uwara emana i yonu itarebasu kobere nasini ari. Godinu sina nautaitate emanu kobere nenoma imuegou uteda kobere sina wegou utaitate kobererau uegou utaitaro emema eraita, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesuma nono eno wei, nanefa mune beafote okiama wotutu ufoita aba warafa wowonaro feare odifoita? Eno ufoita? Me, eno da ufoita. Nanefa mune beafote aiyo oeta kabesiro odiforo eregou ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Enanari feareta ememetu nesia, imueta ane ane ma borobafite i kiwuma ueta nesia ma borobafite arioro odifiro efitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ibago i naueta ibaiabai ane ane naufoitana nauegou uawe wei. Anama nauegou ufisuna mui naueta mafisu. I naueta derawere bobo amaraba mui naueta mafite i deramiratu imutasu amarama we imutasu, nanu nauetana ido we imutasuna danu naueta kikiratu ma dare mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Danu danuaini danu dabuemutuini Yesubai anibitae fata. Fatate uwara faiyawere guruguru ubitaba Yesubai ane farawa uta. ");
INSERT INTO yrb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ane farawa utaba moana uwarama Yesuba weita, Anu anuaini abuemutuini A efitae ido faritate wawaro inaibinita weita. ");
INSERT INTO yrb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Weitaro Yesuma emaba wei, Nanu bayaini Nanu naburetana Godinu sina nauteda utaita uwara ido eawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mui kowaro Yesuini Danu iwata ueta uwaraini boutiro amutaro Yesuma wei, mesau etarafu yofefe wei. Weiba enanari anebita. ");
INSERT INTO yrb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Anebitana Yesu nauta ainibiro oyau derawere fari. Oyau fariba ufe uyariro bouti inufie uiba uifitae uta. ");
INSERT INTO yrb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","I uwarama Yesu ma uyatate weita, Dera Waria Amara, ya uifene utaisi weita. Weitaro Yesuma diti forateda yare yaurite oyauini ufeba bunawere bana weina oyauini ufeini ido me sinite binono sani. ");
INSERT INTO yrb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesuma Danu uwaraba wei, Na imuegou utaita aba me? Yanu imueta aboro wei? Eno weiro iyareda neno kirifu utate we mataneda weita, ewa amara abo amararo oyauini ogoini Danu sina nauita weita. ");
INSERT INTO yrb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gerasi orofa, mesau etarafu iro ane inata. Gareri orofa mui afu, Gerasi orofa mui afu, mesau abanaro ibi. ");
INSERT INTO yrb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Gerasi orofaro ane inataro Yesuma maguaro itarina mui Gadara suro seitaninu moana imumu siosama rewoeta bobo amarama Yesu ido atani. I amara kowa faiyawere wadia barutawa ofe torowa inareda suro ainawa uri oeta gebiro eraboro ainebi. (I seitaninu moana siosa imumuma i amarabai kowa faiyawere ure bonoibiba uwarama i amaranu buri age senima uwane tarita. Eno utaro i amarama aiyoni ma furiariro seitaninu mui siosa imumuma dawa ma berairo yaowere orofaro ani). I amarama Yesubai arebina auboko Yesuma seitaninu mui siosa imumuba ania webina i amarama Yesu ereda Yesunu buri gigirariro arubi uite sina derawere wei, Yesu dera urero ibinu Godinu Amara, kodiate na fanisi da ma wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesuma i amaranu ifu wenaueriro seitaninu imumu siosa faiyawere i amaranu nenoro itataba i amarama wei, nanu ifuna fefera wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Weiro seitaninu moana siosa imumuma Yesuba weita, i siosa kabesiro ya siaia da ua weita. ");
INSERT INTO yrb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Weitana borosiri faiyawere i maidaniro ieta gusuna ue itebitaro etate Yesubai nui weita, yanu ununa i borosirinu ubarero anibene waisi weitaro Yesuma wei, aniawego wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Weiba i seitaninu moana siosa imumu i amaranu nenoroma amo fatate anitate i borosirinu ubarero itata. eno utaba i borosiri nesia durami ue anitate maidaniroma mesauro bibu utate imuie me sita. ");
INSERT INTO yrb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","I borosiri yawoeta uwarama nesia etate suro durami ue anedana i sina weitaro i nesia nauta. ");
INSERT INTO yrb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Su uwarama i ueta nesia efitae anita. Ane Yesubai fatana seitaninu moana siosa imumuma ekoita amara, dawa beforo kobererau uiro wadia yuriro wadia bobo yaubiro etate iyata. ");
INSERT INTO yrb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","I ereta uwarama seitaninu moana siosa imumuini boronu ueta nesia etate i reka fata uwaraba nesia weitaro nauta. ");
INSERT INTO yrb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","I Gerasi uwara nesia iya derawere uyatate Yesuba weita, yanu orofa kodiate ania weitaba Yesuma boutiro anibie amui. ");
INSERT INTO yrb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Amuina i siosa imumu me sini amarama wei, naini anibu. Weina Yesuma me weite wei, anu suro aniate Godinu aba dera neno arama ueta nesia wiaro naufita wei. Weiro i amarama anite i natofo su uwara nesiabai Yesuma dawaba ane ui sina nesia wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesuma owerite Gareri afu nono ane inari. Uwara faiyawere Yesu yawotebitana Yesu ido fariro ario sina weita. ");
INSERT INTO yrb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mui amara, danu ifuna Jairasi, dawa mui Ju uwaranu dubu su yawoeta amara. Dana Yesubai farite Yesunu buri gigirariro arubi ui. ");
INSERT INTO yrb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","I amaranu aruma demuraina uifie utebiba iba Yesubai farite wei, nanu suro ara wei. Weiba Yesu ido ani. Anebina uwara faiyawere Dawabai deiro deiro ue anita. ");
INSERT INTO yrb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mui awetaini ani. I aweta ofe derawere woureda oya tuero (12) onono munebi. Oya tuero (12) onono munedaba dogetabai inarebe danu oi sane me siniro wirotawa ui. ");
INSERT INTO yrb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","I awetama Yesunu dubena afu farite Danu wadia burina onono ido didi turi. ");
INSERT INTO yrb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Enoba Yesuma wei, anama Na burisinu wei? Weina i uwara nesia ya me weita. Eno weitaro Fitama wei, Dera Waria Amara, uwara faiyawere Abai deiro deiro utaita ea wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Weiro Yesuma wei, anama Na burisinu ari. Nanu buna Nabairoma dawabai ainuro Na iwata utatane wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Eno weiba i awetama we imui, Dawa iwata utasu we imuite iya derawere uyarite iwura mameda Yesubai farite arubi uteda danu ofe woureta sina i uwaraba weite wei, nana Dawa burinena na onono ido didi turinuro wirone wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Eno weiro Yesuma wei, aruma anu naueta derawereba wirosinu. Aniate merau ibia wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuma eno webina mui amarama Jairasinu suroma emabai farite Jairasiba wei, anu aruma uisinu. Uisinua tisa amarabai woroworo sina da wia wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Weiro Yesuma nauite Jairasiba wei, iya da uyate imuegou uaro wirofi wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Suro ane fataro Yesuma i uwara nesia kodite Fitaini Jonini Jeimisini i arumanu danua damamaini suro woure amui. ");
INSERT INTO yrb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Amuina suro yaubita uwarama sorara utaro nauite wei, i da wiawe. I aruma me siniro iwata utate iba yo weita. ");
INSERT INTO yrb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Eno weiba i uwarama yo weita. I aruma me siniro iwata utate iba yo weita. ");
INSERT INTO yrb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesuma i arumanu agero munite ma uyareda wei, arumaratu, uya wei. ");
INSERT INTO yrb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","56","Weina i daisinono ui aruma ido neno saneda uyari. Yesuma wei, dawaba ieta maro ifi weiro danua damama neno kirifu uta. Yesuma emaba wei, moana uwarabai i sina da wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mui kowaro Yesuma weiro Danu iwata ueta uwara tuero (12) Dawabai fata. Fataro Yesuma ema seitaninu moana siosa imumu we yowefitate ofe aika maika woureta ma wirofitae iba emaba buna mai. ");
INSERT INTO yrb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","I afosoro uwaraba buna maite wei, aniawete Godinu yawotasu orofa sina wiawete ofe aika maika woureta uwara ma wiroawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yaini woure aneta ibaiabai da muawe. Akurini yoateini ietaini oini mui wadiaini i nesia da mune aniawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Natofo su fafote mui suro amufote ibeda yanu sinai natofo su uwaraba we me sibote aniboita wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Abo su uwarama ya da mubitate yanu sina da naufitaitana yanu dubena emabai sawete sakai buriro maituawero ya ema ekodifote ufoita iwata ufitaro aniawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesuma eno weiba ido anita. Su suro aneda Godinu kotofu sina webitate ofe aika maika woureta uwara ma wirotebita. ");
INSERT INTO yrb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erodi, gaemani dera yawoeta amarama Yesunu ueta sineta nesia nauite ina iwawa derawere ui. Moana uwarama weita, Dawana Joni uietaroma uyari. ");
INSERT INTO yrb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Moana uwarama weita, Iraija dawa ido owere fari. Moana uwarama weita, mui bodere we bou ueta amara ido fari. ");
INSERT INTO yrb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eno webitaro Erodi i sina nauite iwawa utebe wei, Joninu nodo umane ture. Umane ture rairo anama i buna ueta utasuro nautatane wei? Eno weite Yesu efie doberebi. ");
INSERT INTO yrb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesunu afosoro uwarama owetate Yesubai are fatate emanu utebita nesia weita. Yesuma Danu afosoro uwara munite Besaida suro woure ani. ");
INSERT INTO yrb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","I guruguru ubita uwarama Danu aneta sina nautate Danu buribi anita. Ane fataro Yesuma emaba ario weite Godinu kotofu yawotasu sina emaba weite i ofe woureta uwara ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yawi sinebina Danu iwata ueta uwarama Dawabai fatate weita, wiaro i guruguru ue ibinita uwara anibitate su aboro aboro ieta ifitate aibitaita. Ewa orofaro suini kabaru me weita. ");
INSERT INTO yrb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Weitaro Yesuma emaba wei, i uwaraba ieta mawero ifita wei. Weiro weita, yabai buredi faini (5) erio egi sadeiratu torowa ibinu weita. Anibete i uwaraba ieta oiya ufene wasu weita? ");
INSERT INTO yrb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","15","Uwara faiyawere eme torowa fai tausani (5000) iro ibita. Yesuma Danu iwata ueta uwaraba wei, i uwara mui kabesiro fifiti (50) we ma yauawe. Enoma enoma ue me siawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Weiro enanari ue me sitaro Yesuma i buredi faini (5) erio egi sadeini munite urero ereda Godi kobererau we imuteda guriguri uite ma birabiarite Danu iwata ueta uwaraba mairo i guruguru ubita uwaraba nata nata uta. ");
INSERT INTO yrb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nata nata utaro mune itaro dia uri. Ie me sitaro ieta iwo muduna mutate bosio youta. Bosio nesia tuero (12) youtaro wate fari. ");
INSERT INTO yrb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mui kowaro Yesuma Danu aika ibeda guriguri utebi. Utebiro Danu iwata ueta uwara Dawabai baworo ibita. Yesu guriguri uite Danu iwata ueta uwaraba wei, ewaro uwarama Naba ana waita wei? ");
INSERT INTO yrb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Weiro weita, moana uwarama Ana Joni babataito amara waita. Moana uwarama Ana Iraija waita. Moana uwarama Ana mui bodere we bou ueta amara uietaroma uyariba ido owere farinu waita weita. ");
INSERT INTO yrb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Weitaro Yesuma emaba wei, yade! Naba anene waita wei? Weiro Fitama wei, Ana Godinu Kerisode wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Yesuma wei, i sinana ba weite wei, enoba ewa sina moana uwarabai da wiawe wei. Weite wei, i Ba eme Sini Amarama neno oferi faiyawere woufiro i Ju dera uwaraini fuyo ode sina weta uwaraini tarawatu tisa uwaraini Danu sina da muneibitaro Dawa ma uifitaro kowa rarogonu me sibiro Dawa ido uyafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesuma i guruguru ubita uwara nesiaba wei, anama Nanu buribi afie ufisuna danu unu nesia ekodifite Nanu unu uteda kobere ueta korosi ari ainewaure mameda Nanu buribi daido areibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yesuma nono wei, mui amarama ewa orofaro me ibifie ufisuna daido ba uifisu. Anama Naba uifisuna dawa ba wirofisurogo wirofite me ibene ibene ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Anama ewa orofa atata ibaiabai nesia mubite danu neno da ma wirofiro siosa kabesiro feafisuna ina ba me. ");
INSERT INTO yrb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Anama Naini Nanu sinaba maru ufiro i Ba Eme Sini Amaraini Danu buna aneruini Danu araetaini Godinu dera arioro fafisuna amaraba moko Na a iwata me wemau wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nanu ba sina wemau, moana ewado inaibinita uwara da uifitate Godinu yawotasu kowa efitate nono ido uifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kowa eita (8) me siniro Yesuma Fitaini Jonini Jeimisini munite guriguri ufie maidaniro mani. ");
INSERT INTO yrb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iro mane farite guriguri uina Danu ibo nawataini wadia inakeowere dera ario ari ui. ");
INSERT INTO yrb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Eno uina amara sadei iro me ari fasite Yesuba weisi. Mosesini Iraijaini Godinu araetaro fasite Godinu unu Yesu Jerusaremu suro uieta sina Dawaba weisi. ");
INSERT INTO yrb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Fitaini i amara sadeima nauta aibitae uteda i weita sinanu ubi nautawa utate Yesunu araetaini Yesunu uruama inasi amara sadei torowa eta. ");
INSERT INTO yrb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mosesini Iraijaini Yesu ekodifitae utana Fitama Yesuba wei, Dera Amara, yanu ewado yaubinisina kobererauba kiki suraratu rarogonu Anu mui, Mosesinu mui, Iraijanu mui ubu ufeisi wei. Danu imuetana rorowarau meba iba eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Fitama eno weina goso ido farite ema ma yariro iya uyata. ");
INSERT INTO yrb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gosoroma sina tararite wei, ewana Nanu Amara ubi, Nana Dawa we mune odeba Danu sina nautebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","I sina eno weiro etana Yesu torowa inaibiro eta. Iba i kowaro emeba i sinaini eretaini wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Maidaniroma tarataro etei mui kowaro uwara faiyawere Yesu atata. ");
INSERT INTO yrb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mui amarama i guruguru ubita uwaranu turoma derawere wei, Tisa, nanu amara ubi, nanu amara demurairatu eregou ua. ");
INSERT INTO yrb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Moana kowaro seitaninu mui siosa imumuma nanu amaranu ubarero itarasuba i wasu. seitaninu mui siosa imumuma nanu amara ma iyari iyari utasuba bebeturoma gugu farasuro seitaninu mui siosa imumuma dawa ureda ekodawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Anu iwata ueta uwaraba nui wenero seitaninu mui siosa imumu we ma beratawa uita wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","I amarama eno weiro Yesuma wei, ya imutawa jaja bobo utaita uwara. Yabai kowa aboabo ibimaro imufoita? Anu amara Nabai woure ara wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","I amara ido woure arina seitaninu mui siosa imumuma ma iyari iyari uteda mu saniro urei. Yesuma seitaninu mui siosa imumuba sina bunawere weite i amara ma wiroite danu damamabai mai. ");
INSERT INTO yrb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yesuma eno uiro uwarama ereda Godinu bunaba neno kirifu uta. ");
INSERT INTO yrb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","I uwarama eno utana Yesuma Danu iwata ueta uwaraba wei, Nanu sina nauegou uawe. Godima bana da webiro Na moana uwaranu age duro odifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Weiro Danu wei sina iwawa uta. Iwata uotoba emanu imueta daba garari ui. Iba i uwarama iyareda i sinanu ubi wenauerawa uta. ");
INSERT INTO yrb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","I iwata ueta uwarama bebetuma yaraneda weita, yabai abo amarana dera amara weita? ");
INSERT INTO yrb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Yesuma emanu imueta iwata uite mui amakanu munite Dawabai ma yaurite emaba wei, anama ewa amakanu ari Nanu ifuro durua ufisuna Naini durua ufisu. Anama Na durua ufisuna Na siaia ui Godini durua ufisu. Anama yabai otowaratu sibisu I ari dana derawere wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jonima Yesuba wei, Dera Waria Amara, mui amarama Anu ifuro seitaninu mui siosa imumu we beratebiro esite dana Anu iwata ueta amara meba kodia weisi wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Weiro Yesuma wei, kodia da wiawe. Anama yaba wasai utawa utasuna ya durua utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesunu urero maneta kowa fafie uiba Yesuma Jerusaremu suro rorowarau anibie ui. ");
INSERT INTO yrb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yesuma mui Samaria suro Danu aineta ue bou ufitae siaia uiro anita. ");
INSERT INTO yrb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ane fatate i Samaria uwarama ema unutawa Danu aineta. Yesuma Jerusaremu suro anibie aniba ema unutawa Yesu emanu suro aineta. ");
INSERT INTO yrb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesunu iwata ueta amara sadei, Jeimisini Jonini i sina nausite Yesuba weisi, sina weburo ureroma ina tarafite ema yare me sibisu, eno webutu aba me weisi? ");
INSERT INTO yrb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Eno weisiba Yesuma emaba bunawere wei, kodiawa wei. I su ekoitate mui suro anita. ");
INSERT INTO yrb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dabaro anebitana mui amarama Yesuba wei, aboro aboro anibasuna naini animau wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Weiro Yesuma wei, oi egina emanu su bobo gasirana mowa bobo, nono i Ba Eme Sini Amara Danu aineta kabesina me wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Weite mui amaraba wei, Nanu buribi ara wei. Weiro i amarama wei, Dera Amara, nanu baba uri umauna Anu buribi ido animau wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Weina Yesuma wei, me, Nanu buribi anawa uwarama Nanu buribi anawa uieta uwara uri ufitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Eno weite i amaraba nono wei, ade, aniate Godinu kotofu yawoeta sina we inarebea wei. Mui amarama Yesuba wei, nanu su uwaraba ario wemate ekodimate Anu buribi animau wei. ");
INSERT INTO yrb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Weiro Yesuma wei, anama Nanu gaukara munasute nono danu bodere ueta imuteda owerasuna i amara kobererau meba Godima dawa yawotawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mui kowaro Yesuma eme torowa seweniti (70) ema ko sina we anibitaro Dawa duburo we anibie iba ema mune odi. Ema sadei sadei, Danu anibisu su aboro aboro sina we anibitae mune odi. ");
INSERT INTO yrb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mune odite wei, i daureta ietata faiyawere i ari i Godinu sina nautawa uwarana faiyawere. Nono i daureta uwarana faiyawere me i ari Godinu sina we inareta uwarana faiya me. Enoba i daureta ubi Amarabai guriguri uteda wiawero gaukara uwara moana mafiro anibita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aniawete eawe, yana mamoe ari. I mamoena orowa kuabai siaia utatane wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Aniawete fausini yoateini mui sadoroini da wouawete eme dabaro atafoitana ario yafawere da wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ane suro amufoitana eno wiawe, neno kobererau uawe, eno wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","I suro kobere amara ibifisuna i su we ma kobererau uawe, mena yanu we ma kobererau ueta owefite yabai ibifie watane wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yana Godinu gaukara uwaraba abo suro amufoitana i su uwaranu ietaini ogoini me ifoita. ");
INSERT INTO yrb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Abo natofo suro aniboitana i su uwarama ya mubitate ane ieta mafitaitana iawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","I suro ofe woureta uwara ma wirotedana eno wiawe, Godinu yawotasu kowa baworo fafie usinu wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Nono abo suro aniboro i uwarama ya ekodifitaitana dabaro aniawete eno wiawe, ya uwaranu natofo su sakai yanu aika buriro maitureda ekodifero efote Godinu yawotasu kowa fafie usinu efoita, eno wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yesuma eno weite wei, Godinu koto kowa fafiro Godima i Sodomu su siosawere uwara fanisi kikiratu mafite i su uwara fanisi derawere mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ya Korasani su uwaraini Besaida su uwaraini eforo. Godinu buna ueta faiyawere ya erebitaba i Taira su uwaraini Saidoni su uwaraini ina efitarona aramawere wadiaini barufitate konua kofiri deiro odeda emanu ba me ueta ekodifitae wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Godinu koto kowa fafiro Godima i Taira su uwaraini Saidoni su uwaraini fanisi kikiratu mafite ya Korasani su uwaraini ya Besaida su uwaraini yanu ba me ueta ekodawaba fanisi derawere mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yesuma nono wei, ya Kafenamu su uwaraba anene wemau? Urero manibene waita? Ya urero da woure manibite ya mu sabiro uitawa inaro taniboita wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ana anama yanu sina naufitaitana Nanu sina naufitaita. Ana anama ya ekodifitaitana Na ekodifitate Na siaia ui Godi ekodifitaita, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Duburo i uwara nesia sewenitina (70) owetate Yesubai fatate weita, Dera Waria Amara, Anu ifuro weisiro i seitaninu siosa imumuma yanu sina nautate anita weita. ");
INSERT INTO yrb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Weitaro Yesuma emaba wei, eno utebitana bida mamebasu i ari seitanima ureroma ewaro tare ureiro ere wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yesuma nono wei, yaba buna mateda wataneba towini begara ari emetu deiro amune adire anibote yaba wasai utasu amaranu buna serigari uforo ane anema ya ma arama da ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","I seitaninu siosa imumuma yanu sina nautaita. Ewaba yaru da uawete yanu ifu urero owawa ue odinuba iba yaru uawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","I kowaro Yesu nenoma yaru uite guriguri uteda wei, Baba, Ana ureini nasinini yawotasu. Ana ewa imueta nesia i orofa atata iwata derawere uwarabai ma fearasute i koiniboro ari uwara emaba ma boroyarasuro iba we ma kobererau utatane. Ina Anu kobere imueta iba eno utasu. ");
INSERT INTO yrb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nanu Babama Danu imueta nesia matasuro enanari utatane. I uwarama Nanu Babanu Amara iwawa utaitaro Godi torowana Dawa iwata utasu. Enanari Godi iwawa utaitaro Godinu Amarama Godi iwata utasute anabai ma boroyarasuro Godi iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesuma Danu iwata ueta uwara owere ereda emanu aikaba wei, ane ane erebitaba kobererau ibaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Godinu moana we bou ueta uwaraini moana dera yawoeta uwaraini yanu ereta efitae weitate erawa uta. Yanu nautaita sina naufitae weitate nautawa uta wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mui kowaro Mosesinu tarawatu tisa amarama uyarite Yesu ue efie uteda wei, Tisa, anene umate me ibene ibene ibeta mumau wei? ");
INSERT INTO yrb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Weiro Yesuma wei, Mosesinu tarawatuma ane wasu wei? Ina a iwata aba me wei? ");
INSERT INTO yrb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Eno weiro i amarama wei, Mosesinu tarawatuma eno wasu, anu unu uetaini imueta nesia Godibai odegou utebea. Godi beforoma imuawete neno arama imuegou uawe, yanu imueta nesia Godi imuawete neno arama uegou uawe, yanu yaiyemutuba yanu aika ari nenoma uegou uawe, eno wasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Eno weiro Yesuma wei, ba wasu, enanari ufasuna me ibene ibene ibifasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Weiro i amarama danu torowa ma kobererau ufie uteda wei, nanu naiye ana wei? ");
INSERT INTO yrb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Weiro Yesuma wei, mui Ju amarama Jerusaremu suroma Jeriko suro tarani. Tanebina moana waira ueta uwarama danu wadia waira utate isuma utaba uieta ari ainibi. ");
INSERT INTO yrb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ainibiro mui fuyo ode sina weta amarama dabaro me inarebe i amara uieta ari ainibiro erite daba enabira afu kaike uite ani. ");
INSERT INTO yrb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mui Ju baeta utasu Riwai waita amarama enanari ui. Dana i amara erite daba etei afuro kaike uite fare ani. ");
INSERT INTO yrb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nono aika amara dawa Samaria su amarama dabaro anebe fare erite neno arama ui. ");
INSERT INTO yrb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Neno arama uiba i amarabai ane jegirari uteda ira amairo odite badesina danu amai wayari. Eno uite i amara mune danu doniki egi deiro ma yaurite ani. Ane otere suro farite i amara yawoegou ui. ");
INSERT INTO yrb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wai uriro uyarite i otere su yawoeta amaraba tu kina (K2) maite wei, i amara yawoegou uaro owemate famaro mui oi deiro sabasuna moko mamau wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesuma i ikiki eno weite i Mosesinu tarawatu tisa amaraba wei, i amara rarogonuma i waira ueta uwarama urebita amara etana abo amarana danu daiye wei? ");
INSERT INTO yrb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Weiro wei, i neno arama ui amara wei. Weina Yesuma wei, aniate enanari ua wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuini Danu uwaraini anebe mui suro fatana mui aweta, danu ifuna Mata, dana bana wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","I awetanu dataenu ifuna Meri. Merima Yesunu buri gigirariro yaubeda Yesunu we mawetu ueta naui. ");
INSERT INTO yrb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Matama okia ouite imueta aika maika imuiba Yesubai farite wei, Dera Amara, nanu kaka na ekodinuro nanu torowana yaba okia outatane, A imutasu aba me weite wei, wiaro na durua ufi wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Weiro Yesuma dawaba moko wei, Mata, ana ane ane imuteda neno siosa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Demurairatu ufasuna kobererau ufasu. Merima ina utasuba na da ma daremau wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mui kowaro Yesuma guriguri ui. Guriguri ue me siniro Danu mui iwata ueta amarama wei, Dera Waria Amara, Jonima danu iwata ueta uwaraba guriguri uteda we mawetu ui, enanari ya we mawetu ua wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Weiro Yesuma emaba wei, guriguri utedana eno wiawe, Baba yaini eme nesiani Anu ifu we ma kobererau ufene waisi. Anu yawotasu kowa fafie waisi. ");
INSERT INTO yrb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yanu ieta ainewaure matebea. ");
INSERT INTO yrb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yanu naiyemutunu yaba utaita ba me ueta ina mune aika odaisi, enanari yanu ba me ueta mune aika odia. I siosa ue ereta ibaiabai yabai da woure arate i siosabairoma ya woure eta aika ania wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Eno weite nono wei, anama danu domayabai dumu abanaro anibite eno webisu, naiye, nanu naiye inarebe farinuro na ieta meba kau rarogonu mai webisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Eno webisuna i ainibifisu amarama webisu, ieta nui da wiate ania, nanu koiniboroini naini wiaro nauta ainibinisiba da uyamate ieta aba da mamau webisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nanu sina nauawe. Danu daiyeba da uyafisu. Iba merogo i amarama woroworo nui weda weibisuba iba uyafite ieta mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ibago wenaueawero mafi, dobeawete atawe, yaubinu wiawero yaba ma ifegari ufi wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Anama wenauefisuna mubisu, anama dobefisuna atafisu, anama yaubinita webisuna ma ifegari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mui amarama erio egiba wenauefisuna ananu damamama dawaba towi mafisu? ");
INSERT INTO yrb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O kokora bakaba wenauefisuna begara mafisu? Eno da ufisu. ");
INSERT INTO yrb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ya siosa uwarana yanu koiniboroba kotofu maeta mataitana ana anama wenauefitaitana yanu urero ibinu Babama Danu Imumu Kotofu yaba maegou ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mui kowaro seitaninu mui siosa imumuma mui amaranu ubarero ibiba i amara sina wiawa ui. Yesuma i seitaninu mui siosa imumu we berairo aniro i amara ido sina wei. Eno uiba i ereta uwarama neno kirifu uta. ");
INSERT INTO yrb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Moana uwarama weita, Danu nenoro Biesabo ibinuba i botai siosa imumunu bunaroma seitaninu siosa imumu we beratasu weita. ");
INSERT INTO yrb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Moana uwarama Yesu ue efitae uteda weita, Godinu buna ereta ureroma fafiro uaro efe weita. ");
INSERT INTO yrb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesuma emanu imueta iwata uite emaba wei, gaemani uwara emanu aika uraneda saragari ufitate arama ufitaita. Enanari mui su uwara eno ufitaitana saragari ufitate arama ufitaita. ");
INSERT INTO yrb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Seitaninu uwara emanu aika urafitaitana anene ewa orofa yawofitaita? Yana meo waita, Biesaboma Naba buna maiba iba seitaninu siosa imumu we beratatane waitana ya meo waita. ");
INSERT INTO yrb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eno utatanena yanu uwarama seitaninu siosa imumu ananu ifuro we berataita? Ibago i uwarama ya koto ufitate ya meo waita webitaita. ");
INSERT INTO yrb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nono Godinu agema seitaninu siosa imumu we beratanena Godinu yawoeta yabai ma boroyarinu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mui warini goreini fidi bobo amarama danu su yawotasuba danu ibaiabai kobererau ibasu. ");
INSERT INTO yrb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nono mui buna derawere amarama fafisuna urafite i amaranu biraini uraneta ememetu nesia mubite danu ibaiabai mubite nata nata ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Anama Na durua utawa utasute Na wasai sinasu, enanari anama Naini eme fira utawa utasute me sara sanasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Seitaninu mui siosa imumuma mui amara ekodasute yao orofaro imoifie dobere inarebasu. Doberebe doberebe imoitawa utasuba eno wasu, nanu ekodine suro owere animau wasu. ");
INSERT INTO yrb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","26","Seitaninu mui siosa imumuma owere ane farasute erasuna i amara yawewe aieta tutuba ari kobererau ibasuba seitaninu mui siosa imumuma anasute seitaninu moana siosa imumu nesia seweni (7) dawa ari me, ina siosawere mune woure farasu. Farasuro ido faraitate amutaitate ido ibaita. Enoba i amaranu bodere ibetana kikiratu ba me. Nono awonana seitaninu siosa imumu faiyawere fare ibaitaba danu ibetana ba mewere. Ewa ibinita uwaranu ibeta enanari ufisu, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuma eno weiro i guruguru ubita uwarabai inaibi awetama derawere wei, Anu anuama A munite ama maiba Godima anu anua ma kobererau utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Weiro Yesuma wei, anama Godinu sina naue imue utaitana Godima ema ma kobererau uegou utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Uwara faiyawere farebitana Yesuma yare wei, ewa awona ibinita uwarana siosawere. Ainewaure buna ereta doberaita. Jonanu buna ereta ma boroyariba yaba aika buna ereta da ma boroyafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonama Niniwe suro buna ereta uiro eta, enanari i Ba Eme Sini Amarama buna ereta ufiro ewa ibinita uwarama efoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Godinu koto kowa fafiro Siba orofanu yawoeta aweta, emanu kuini, uyafite ewa uwara wawei webite do mafisu. Boderewere dana yafawereroma Soromoninu bunawere we mawetu ueta sina naufie fari. Soromonina dera amara me. Nono awonana mui amara, Dana Dera Amarawere yabai ibinuro ekodaitaba iba i kowaro i awetama yaba wawei webisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","I koto kowaro i Ninewe su uwarama uyafitate ewa uwaraba wawei webitate do mafitaita. Jonama sina sina webiba emanu neno neno mune dubena afu sata. Nono awona mui amara, Dana derawere, Jonana kikiratu, Dawa yabai ibinuro yana ekodaitaba iba wawei webitaita. ");
INSERT INTO yrb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Anama nanefa beafisuna ina da ma feafite aiyo oeta kabesiro odifiro i fafitaita uwara i ario efitaita. ");
INSERT INTO yrb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yanu ditina yanu ofe ubunu ario. Yanu diti kobererauna yanu ofe ubuna ariowere. Yanu diti aramawerena yanu ofe ubuna dumu. ");
INSERT INTO yrb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","36","Ibago eregou uforo yanu ariona dumu sibisu. Yanu neno ubarero ario derawere ufisuna dumu mena yanu ofe ario ari ufisu, nanefanu ario ari, Yesuma wei. Yanu imueta dumuwerena yanu ibeta aramawere. ");
INSERT INTO yrb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuma sina we me siniro mui Ferosi amarama wei, nanu suro arate ieta ia wei. Weiba Yesu ido ane suro amuite ieta ifie yauri. ");
INSERT INTO yrb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","I Ferosi amarama erina Yesu age urotawa uiro emanu baeta eno utawaba neno kirifu ui. ");
INSERT INTO yrb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesuma dawaba wei, ya Ferosi uwarama i kafusini fereitini uroegou utaitana nono yanu neno ubarero imuetana siosararabo. Mui uwaranu ibaiabai nenoma imutaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yana daido farafa beforo me! Godima emenu dei ofeini neno ubareroini nesia ubu ui aba me wei? ");
INSERT INTO yrb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","I kafusini fereitini ibinu ieta, ibaiabai me uwaraba nata nata ufoitana yanu neno roatarau ufiro merau ibifoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ya Ferosi uwara, eregou uforo! Yana waiyaro ibaiabai nesiaini moana kikiratu ibaiabai taisi odaita, nono moana uwaraba kobererau utawa utaitate Godi imutawa uteda neno arama utawa utaita wei. Yanu taisi oetaini Godi imuetaini neno arama uetaini nesia uegou uawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ya Ferosi uwara eregou uforo! Yana i Ju uwaranu dubu su kobere yaureta kabesi doberegou utaitate yauraita enanari yanu ununa i maketiro inaraita uwaranu ario weta. Eno utaitate yaru utaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Eregou uforo! Yana ewa ari! emema uri ue oeta kabesi erawa utaitate kakara utawa uteda burima amune adire anaitaro ima ema ma siosa utaita. Yana i feare ibeta uri kabesi ari. Yana eme ma siosa utaitana ema iwata me wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesuma eno weiro mui Mosesinu tarawatu tisa amarama wei, Tisa A eno wasuba yaba sina siosa wasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Weiro Yesuma wei, ya tarawatu tisa uwaraini eregou uforo! Yana kimuwere tarawatu sina eme mubitae waita. Ina urumuwereba emema munawa utaitaro yana ema durua utawa utaita. I urumuna age rorou demurairatuma mamawa utaita. Emanu torowama wouraita wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Eregou uforo! Yanu yamamamutuma i we bou ueta uwara ma uita. Yana enanari imutaitate i uri oeta kabesi ma wirotaita. ");
INSERT INTO yrb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yanu yamamamutuma Godinu we bou ueta uwara ma uitana ina kobererau yana waitate emanu uri oeta kabesiro werei werei ue odaita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Weite nono wei, ibago Godima kobererau imuteda yaba wei, Nanu we bou ueta uwaraini Nanu afosoro uwaraini siaia umaro anibitaro moana ma uifitate moana ma siosa ufitaita Godima eno weiya wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yesuma i sina weite wei, Godinu we bou ueta uwara ma uita. I botai kowaroma i uieta nesia ewa ibinita uwaranu kerere. Iba Godima ya koto ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Eiboronu ma uieta kowaroma are Sakaraiya, i amara i fuyo oeta kabesini dera dubu su abanaro ma uita, danu ma uieta kowaro, i uwara nesiaba Godima ya fanisi mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ya Mosesinu tarawatu tisa uwara eregou uforo! Yana Godinu kobere imueta emebai ma fearaita. Godinu kobere imuetana su ari. Yana i ki ma fearaitate ubarero amutawa utaitate emenu amueta daba garari utaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesuma iroma anebina i Mosesinu tarawatu tisa uwaraini Ferosi uwaraini ibo derawere uteda wenauereta faiyawere weitate sina siosa weita. ");
INSERT INTO yrb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Emanu ununa Yesunu sina mubitate koto ufitae iba sina derawere weita. ");
INSERT INTO yrb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Uwara faiya faiyawere guruguru uteda deiro deiro uteda inataro Yesuma Danu iwata ueta uwara emanu aika eno we kakara ui, i Ferosi uwaranu wawareta ira yisiti eforo wei. Ina meo ueta ema sina waitate aika utaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Emanu obari ueta nesia ma uregari ufite i feareta ememetu nesia ma borobafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ibago yanu dumuro waita sina kowaro naufitaita. Ane sina su ubarero gimumutaroma weboitana su abanaro derawere webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Masigu, Nanu sina wemaro nauawe. I ma uieta uwaraba iya da uyawe. I uwarama yanu ofe ma uifitate nono yanu imumu da ma uifitaita. ");
INSERT INTO yrb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Anaba iya uyafoita? We kakara umaro nauegou uawe. Anama yanu ofe ma uifite nono yanu imumu uitawa ina kabesiro sabisuba Godi Dawaba torowa iya uyawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Emema gui gasirararatu fai (5) oiya uteda toea sadei sanaitaba Godima i gasiraratu imutasu. ");
INSERT INTO yrb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Godima yanu fouma iji nesia yawitasu iba iya da uyawe. Godima i gasirararatu imutasute nono yabana derawere imuegou utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesuma wei, anama emebai Yesu imutatane webisuna enanari Na i Ba Eme Sire Amarama Godinu anerubai i amara dawa Na iwata utatane wemau. ");
INSERT INTO yrb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Anama emebai Yesu na iwata me webisuna enanari Godinu anerubai i amara dawa Na iwata me wemau wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Anama i Ba Eme Sini Amaraba sina siosa webisuna Godima danu ba me ueta mubite imutawa ufisu. Nono anama Godinu Imumu Kotofuba ma kikiratu ufisuna danu ba me ueta da mubiro i amarabai daido ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Mui kowaro ya budari ufitate Ju uwaranu dubu suro woure odifitaita. Dera Ju yawoeta uwaraini gaemani dera yawoeta uwarabai odifitaitana iya da uyawete yanu moko sina ane weboita da imuegou uforo Godinu Imumu Kotofuma i kowaro yaba Danu imueta mafiro sina enanari weboita Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","I guruguru ubita uwarabai mui amarama Yesuba wei, Tisa, nanu kakaba wiaro kakama babanu ibaiabai nata ufite naba mui mafi wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Weiro Yesuma wei, anama Na anu koto yawoeta amara odi? Anama Na anu ibaiabai nata nata ueta amara odi? ");
INSERT INTO yrb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Efaro! Mui amaranu ibaiabaiba diti urowere ma owere da uforo! Yanu ibetana ibaiabai torowa me. Ana amarama danu unu ibaiabai muneta torowa iba danu ibeta ba me wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Eno weite kasei sinaroma eno wei, mui ibaiabai derawere, kobere nasini bobo amara yaubi. ");
INSERT INTO yrb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","19","I amarama yaubeda we imui, nanu waiya ieta faiyawerero mui su meba aboro odimau we imuite wei, eno umau, nanu ietata oeta su nesia ma jugari umate reka derawere ietata oeta su ubu umate iro nanu feameini nanu ibaiabai nesia odimate nanu torowaba wemau, na ane imumane nabai ibaiabai faiya faiyawere ibinuba ietaini ogoini woroworo iteimate yaru uteimau eno wemau weiya wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dawa eno weiro Godima dawaba wei, gogore amara! Awona dumuro a uifasuba anama i ibaiabai mubisu Godima weiya wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesuma i ikiki weite wei, enanari anama ibaiabai derawere mune bomu ue munebe munebe, enoma enoma utasute Godinu iborona urero ibaiabai ari me, dana i gogore amara ari sinasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesuma Danu iwata ueta uwaraba wei, yanu ibetaini ofeba da imuforo! Yanu wiroeta ietabairoma da wirofeisi. Yanu ofena i baruetama da ma wirofisu. ");
INSERT INTO yrb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yanu ibetana ieta torowa me. Yanu ofena barueta torowa me. ");
INSERT INTO yrb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","I oaoa gasira imue eawe. I gasirama ana tai waitawa ana tai fira utawa, emabai ietata oeta su mero nono Godima emaba ieta matasu wei. Godima i gasira imutasute nono yabana derawere imuegou utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aneba ainewaure yanu ibetaba imutaita? Anama imutebe imutebe danu kowa ma yafa ufisu wei? ");
INSERT INTO yrb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ido i kikiratu gaukara da ufoitaba aneba dera gaukaraba imutaita wei? ");
INSERT INTO yrb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","I sigina imue eawe. I sigina emanu torowa gaukara utawa, emanu torowa wadia yurawa utaita wei. Soromonima danu ibeta araetaro wadia baruiro danu wadiana ba mero i siginanu fomuetana kobererau wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Godima i koe awona ma waratasute werei werei utasuro nono waidumuna i koe demurai inama yarasu. Godima eno utasuna ya kikiratu naueta uwaraini kowa aboabo yaba wadia yure odifisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yanu ietaini ogoini da doberegou ufote da imuforo wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","I orofa atata uwara nesia ina doberegou utaita. Yanu urero Baba Dawa iwata ina yanu ibeta. ");
INSERT INTO yrb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","I da doberegou ufote nono Godinu kobere yawoeta doberegou uforo yanu ietaini ane ane nesia mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ya otowa mamoenanatu ari uwara, iya da uyawe wei. Godima Danu yawoeta orofa yaba mafie weite iba ya yawoteda yaru utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yanu ibaiabai oiya ue mawete i ba me ibeta uwaraba oi moana mawe wei. Eno ufoitana yanu ibaiabai urero ibene ibene ibifisu. Iro waira uwarana me. Iro jirikoma ibaiabai ma arama da ufisu. ");
INSERT INTO yrb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yanu ibaiabai aboro ibeibisuna yanu nenona iro ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yanu wadiaini nanefaini mune bou uawe. Wadia baruawete nanefa beawete yanu Dera Wari Amara yawoawe. Yanu Dera Waria Amarama aweta muneta ogaroroma fafite yaubinita webisuna kasimu sau ma ifegari ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","I dera amara ido fafite danu gaukara uwara nauta ainawa me yaubifitaro efisuna ema we ma kobererau ufisu wei. Yaba ba sina wemaro nauawe. Eno efisuna danu gaukara uwara ma yaufite gaukara wadia ma baruteda danu torowama emaba ieta nabero mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dumu abanaro o waibai fafite ema eno efite we ma kobererau ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Imue eawe! I su ubi amarama i waira ueta amaranu dawabai fareta kowa iwata ufirona danu su yawofiro su ma siosa da ufie wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Enanari yawoegou uforo! I Ba Eme Sini Amara kiwuma fafisuba, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Fitama wei, Dera Waria Amara, i kasei sina yanu aikaba wasu, aba i uwara nesiaba wasu wei? ");
INSERT INTO yrb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Weiro Yesuma wei, i kobere uetaini imueta uwaraba watane. I dera yawoeta amarama i kobere ueta imueta derawere amara eme yawoeta amara odifiro i su uwara yawofite emanu ieta mafisu. ");
INSERT INTO yrb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","I dera yawoeta amara ido fafisuna danu gaukara amara eno ufiro efite we ma kobererau ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","46","I amara danu ibaiabai nesia yawofie odifisu wei. Nono i gaukara amarama eno we imufisu, nanu dera amara sau da fafisu we imufite i su gaukara arumaini amaraini isuma ureibite ieta derawere ifite siosa ogo iteda beforo arama ufisuna danu dera amarama kiwuma ido fafite i amara fanisi mafite i nautawa uwarabai odifisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mui gaukara amarana danu dera amaranu imueta iwata ufite i wene sina enanari da ufisuna i dera amarama i amara isuma derawere ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nono mui gaukara amarana danu dera amaranu imueta iwata meba isuma kikiratu ufisu wei. Anama derawere mafite nono derawere moko ma, webisu. Anama derawere mubisuna derawere mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesuma wei, ewa ina nasiniro moamane iba farea wei. Weite wei, iba farero ewa inama ido yare sinasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Weite Danu uietaba wei, mui kimu babataito ueta ari mumauba iba awonana neno siosa derawere utatanena ina me sibiro duburo kobererau ibimau wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ane we imutaita? Na ya orofa atata uwaraba merau ibeta mamane farea eno we imutaita? Enoba farawa uete mui su uwara, mui su uwara ma saragari umane farea wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Awonaroma mui suro uwara fai (5) ibifitaitana ma saragari ue aika maika ufitate i uwara rarogonuba wasai ufitaita. Nono i uwara rarogonuma aika yaubeda i uwara sadeiba wasai ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mui suro damamaini amaraini saragari ufisite aika maika ufisisi. Danuaini aruma saragari ufisite aika maika ufisisi. Datamaini dainau saragari ufisite aika maika ufisisi wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuma i guruguru ubita uwaraba wei, kowa itareta afu goso eraitate waita, awona obi mafisu waitaro enanari utasu. ");
INSERT INTO yrb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ufuniro oyauma farasuna ido kowa inarasu eno waitaro enanari utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ya meoma bobo uwara! I ureini nasini ibaiabai eregou uteda iwata utaita. Nono Godinu buna ueta eregou utawa uteda iwawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Aneba i ba ueta iwawa utaitate yanu aika ba me ueta ma rorowarau utawa utaita? ");
INSERT INTO yrb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mui amarama ya koto uwarabai wawei webie woure anibisuna dawaba sau naiye wiawe. Mena i koto dera amarama ya forisimaninu age duro odifiro i forisimanima ya diburaro odifisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yaba wemaro nauawe, diburaro odifisuna iro ibeda i faini nesia uforo ya ido ekodifiro wawaro amufoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","I kowaro moana uwarama i Gareri uwaranu fuyo odebita sina weita, i Gareri uwarama Jerusaremu suro Godibai emanu fuyo odebitana Faeratima ema ma uitebi eno weita. ");
INSERT INTO yrb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Eno weitaro Yesuma wei, imue eawe, moana Gareri uwarana siosawere uwaraba iba uita, nono moana Gareri uwarana siosawere meba iba uitawa, eno we imutaita? ");
INSERT INTO yrb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ina ba me. Ya nesia yanu neno neno ueta dubena afu da saboitana me sara uifote i ina yareta kabesiro aniboita wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","I Sairomu uita uwaranu ikiki nauta? Uwara eitini (18) etu yafa gebiro su ubu utaro i su jugari uite i uwara uriro uita. I uita uwarana siosawere uwara nono i moana Jerusaremu suro ibeta uwarana siosa me we imutaita? ");
INSERT INTO yrb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ina ba me watane. Ya nesia yanu neno neno ueta dubena afu da saboitana me sara uifote ina yareta kabesiro aniboita wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesuma ewa kasei sina emaba eno wei, mui amarama boruba ana danu waiyaro waite ekodite ani. Ane ibebe duburo boruba tai mubie fare erina boruba tai uwanawa me. ");
INSERT INTO yrb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Meba danu waiya yawotebi amaraba wei, oya rarogonu na fare ane, ane fare uteda eratanena boruba tai uwanawa me ibinuba kowama uma wei. Weite wei, aneba nanu waiyaro me sara inaibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Eno weiro i waiya yawotebi amarama wei, dera amara, kodia, mui ragani ibifiro ina yawoegou umate danu inibai kawaratu daumate borumakau wisi mune are odimau. ");
INSERT INTO yrb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Eno umaro tai uwafisuna ibifisu, mena umafasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mui sabate kowaro Yesuma Ju uwaranu dubu suro we mawetu ui. ");
INSERT INTO yrb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","We mawetu uite erina seitaninu mui siosa imumuma mui aweta ma arama uiro ragani eitini (18) rorowarau anawa daubite yaubiro Yesuma eri. ");
INSERT INTO yrb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","I aweta erite weiro Dawabai fari. Dawabai fariro Yesuma wei, aweta anu oferi woureta me sininuro ana wirosinu weda i aweta agema buriba rorowarau yare inarite Godinu ifu we ma derawere ui. ");
INSERT INTO yrb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Eno uiba i Ju dubu su yawoeta amara ibo uteda wei, gaukara ueta kowana sikisi ibinu rairo aneba sabate kowaro ewa aweta ma wirotasu wei? ");
INSERT INTO yrb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eno weiro Yesuma dawaba wei, ya meo uwara! Yana sabate kowaro gaukara utaita. Yanu borumakauini donikini ieta mataita. ");
INSERT INTO yrb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Eno utaitaba ewa aweta Eibaramunu sisia aruma, seitanima dawa oya eitini (18) ma arama uiro ibasu iba dawa sabate kowaro wirofisu aba me wei? ");
INSERT INTO yrb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Eno weiro Dawaba wasai ueta uwarama maru utaro moana uwara Yesunu buna uetaba yaru uta. ");
INSERT INTO yrb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesuma Godinu kobere yawotasu sina we mawetu uteda wei, Godinu yawotasu ane ari? Ane emate ina i ari wemau? ");
INSERT INTO yrb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Godinu yawoetana kikiratu masita ana tai ari. I tai mui amarama munite danu waiyaro wairo waratebe waratebe ana derawere waraegou ui. Derawere uiro gasirama emanu mowa i ananu iwararo ubu utebita wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Eno weite nono wei, Godinu yawotasu ane ari? ");
INSERT INTO yrb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ina ewa ari, mui awetama wawareta ira yisitiratu munite i dera faraua ubarero odiro yisitima i faraua nesia ma foai wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesuma Jerusaremu suro ani. Anedana dera natofo suini kiki suro we mawetu utebi. ");
INSERT INTO yrb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Eno utebina mui amarama wei, Dera Amara, uwara ba torowa wirofitaita wei? Weiro Yesuma emaba wei, Godinu kiki bebetoro anegou uawete eawe wei. Awona uwara faiyawere i bebeto doberaitate anawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","I su ubi amarama uyafite kasimu garari ufiro ya wawaro inaibeda yaubinu weboita, Dera Waria Amara ma ifegari uaro amufe weboro webisu, ya uwara Na iwata me webisu. ");
INSERT INTO yrb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Eno webiro weboita, abai ietaini ogoini itebisiro yanu suro we mawetu utebi weboita. ");
INSERT INTO yrb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Eno weboro webisu, ya Na iwata me watane, ya sara siosa utaita uwara Nabairoma aniawe webisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eibaramuini Aisikini Jeikofuini Godinu we bou ueta uwaraini Godinu yawoeta orofaro ibifitaro eforo yanu aneta daba garari ufisuba da anibote nio bijari uteda i weboita wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Eme faiyawere kowa amuetaini kowa itaretaini ewa ufuniroini manamaro aboro aboro fafitate Godinu yawoeta orofa emanu kabesiro yaufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Imue eawe. Moana otowaratu uwarama iro dera uwara sibitaita. Nono moana derawere uwarama iro otowaratu uwara sibitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","I kowaro moana Ferosi uwarama fatate Yesuba weita, Erodima A ma uifie utasua ewadoroma ania weita. ");
INSERT INTO yrb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Weitaro Yesuma emaba wei, aniawete etei orowa kua ari amaraba eno wiawe, ea, Nana seitaninu siosa imumu we beratanete eme ma wirotatane. Awonaini waidumuini etadoini eno umate Nanu gaukara ue me simau. ");
INSERT INTO yrb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Godinu we bou ueta uwarama Jerusaremu suro torowa uitebaitaba Naini we bou ueta amaraba awonaini waidumuini etadoini Nanu gaukara uteimau, eno ane wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Eno weite wei, O Jerusaremu su uwara, Jerusaremu su uwara, yana Godinu we bou ueta uwara ma uitaitate Godinu siaia utasu uwara gebiroma uraita. Kokora awetama danu nanatu fakinama obari utasu, enanari Nanu ununa ya Jerusaremu su uwara yawotatanero ya unutawa Nanu yawoeta wei. ");
INSERT INTO yrb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Eawe! Godima yanu Jerusaremu su ekodasuba Na da efitate eno webitaita, Godinu ifuro farinu amara Dawa kobererau webitaitana nono Na duburo efitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Mui sabate kowaro Yesuma mui Ferosi dera yawoeta amaranu suro ieta ifie ani. Ane farina mui buri age wawari amara ido yaubiba i uwarama Yesu i amara sabate kowaro ma wirofisu aba me iba eregou uta. ");
INSERT INTO yrb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesuma i Mosesinu tarawatu tisa uwaraini Ferosi uwaraba wei, Mosesinu tarawatuma ane wasu? Sabate kowaro ma wiroetana kobererau aba me? Ane wasu wei? ");
INSERT INTO yrb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Weiro i uwarama sina moko wiawa, weroro mu uta. Mu utaro Yesuma i amara mune ma wiroite siaia uiro ani. ");
INSERT INTO yrb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesuma emaba wei, yanu egi ane ane sabate kowaro sakai uri yafa derawere ubarero itafitaro ma youforo amufitaita aba me wei? ");
INSERT INTO yrb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eno weiro Dawaba moko sina wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","9","I ieta itebita uwarama i botai kabesi mubitae fatana Yesuma ema erite emaba wei, mui amarama ya aweta muneta ogaro are iawe webisuna i botai kabesiba da dobeforo utebe mui dera amarawere faosoro yanu kabesi i amaraba maotote maru siotote me sara kabesiro yauotoa wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mui amaranu ogaro ifoe aniboitana emina ubiro yauforo ogaro ubi amarama fafite webisu, naiye, etei kobere kabesiro yaua, webisuna ieta ifitae fafitaita uwarama ya we ma derawere ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Anama danu torowa ma derawere ufisuna Godima dawa ma kikiratu ufisu. Nono anama danu torowa ma otowaratu ufisuna Godima dawa ma derawere ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesuma i ieta ubi amaraba wei, ofua o ogaro ufasuna anu su uwaraini ibaiabai derawere uwaraini torowa waya da youforo emana enanari moko ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ogaro ufasuna ibaiabai me uwaraini buri age aramawere uwaraini buri bebeu uwaraini diti basugari uwaraini waya youa wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Eno ufasuna i uwarama aba moko utawa ufitaro Godima a ma kobererau ufite i naueta uwaranu ma uyareta kowaro Godima a moko mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesuma eno weiro mui ieta ifie yauri amarama wei, anama ieta Godinu orofaro ifisuna Godima dawa ma kobererau ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Weiro Yesuma mui kasei sina dawaba wei, mui kowaro mui amarama ogaro derawere ufie uteda uwara faiyawere waya youri. ");
INSERT INTO yrb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","I ogoro ieta kowa farina i ogaro ubi amarama danu gaukara amara siaia ui. I uwara are ieta ifitae siaia uiro ani. ");
INSERT INTO yrb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","I amara waya anina i uwara nesia ema unutawa danu ieta. Ieta unutawaba mui amarama eno wei, na nasini oiya uneba iro animate ere bou umauba iba ogaro da animau wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mui amarama wei, na borumakau nesia teni (10) oiya uneba animate ema ere bou umauba iba ogaro da animau wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mui amarama wei, na aweta reka muneba ogaro da animau wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","I uwara enoma enoma weitaba i amara ekodite danu dera amarabai anite i sina nesia dawaba wei. Weiro i su ubi amarama ibo uite danu gaukara amaraba wei, natofo su demurai su suini sau aniate ibaiabai me uwaraini buri age arama uwaraini diti basugari uwaraini buri bebeu uwaraini woure ewaro ara wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Weiro i amara ido anite enanari uite danu dera amarabai farite wei, dera amara, anu wenu sina enanari unero nono kabesi faiyawere ibinu wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Weiro i ogaro ubi amarama wei, oiroini waiyaro aniate i uwaranu agero muate woure ewaro araro nanu su wate fafi wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","I botai wenero arawa uita uwara nanu ogaro da are ifitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Yesu ido dabaro ani. Dawa anina uwara faiyawereini uruama Dawaini anebitaro Yesu Dana emaba wei, anama Nanu iwata ueta amara sibie ufite danu danua damamaini awetaini koiniboroini datae dabueini danu unuini emaba danu dubena da sabisuna dawa Nanu iwata ueta amara da sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Anama danu korosi ari da woufisuna dawa Nanu iwata ueta amara da sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","30","Weite wei, yabairoma anama dera yafa su ubu ufie utedana botai yaurasute danu oi yawitasu. Danu oi idoba i su ubu ueta gaukara ue me sibisu aba me, yaurasute imuegou utasu. Nono danu oi arotorowa mena su tutubu sabiro oi me sibisuba ekodifiro emema i su efitate dawa irue webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Imue eawe! Mui dera yawoeta kini amarama mui kini amaraini ane urafie uteda botai yaufite danu meremere uwara yawifisu. Danu meremere uwara faiya me teni tausani (10,000) torowa nono i mui kini amaranu meremere uwarana faiya faiyawere tueniti tausaniba (20,000) iba imuegou ufisu. ");
INSERT INTO yrb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ina ido aba me eno imufisu. Arotorowa mena danu fo weta amara siaia ufite webisu, naiye aini naini uruama wesa ue matafutu webisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Enanari ana anama yanu ane ane da ekodifoitana Nanu iwata ueta uwara da siboita wei. ");
INSERT INTO yrb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Soruna kobererau. Sorunu imona me sibiro danu imona nono anene ibifisu? ");
INSERT INTO yrb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Imona meba i soruna siosawere ina ba meba emema mune sanaita. Enanari ya kobererau da uteiboitana yana imona me soru ari. Anama ya ome bobona ewa sina nauegou uforo wei. ");
INSERT INTO yrb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yesuma we mawetu utebina takesi muneta uwaraini siosa ueta uwaraini Danu sina naufitae ido fata. ");
INSERT INTO yrb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","I Ferosi uwaraini tarawatu tisa uwaraini gimumutaroma weita, ewa amarama siosa uwaraini uruama yaubeda ieta itasu weita. ");
INSERT INTO yrb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Yesuma emaba kasei sinaroma wei, yabai mui amarama mamoe wani aderedi (100) boboro nono mamoe demurairatu feafisuna mamoe nainiti naini (99) eme ibawa orofaro ekodifite i mamoe demurai doberebe doberebe atafisu. Eno ufisu aba me? ");
INSERT INTO yrb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aiwia eno ufisu. Dawa doberebe doberebe atafite woure eriro odeda yaru ue anibisu. ");
INSERT INTO yrb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Suro ane fafite webiro danu su uwaraini domayamutuini fafitaro webisu, nanu fearinu mamoe ataneba naini yaru uawe webisu. ");
INSERT INTO yrb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Enanari amara demurai danu siosa ueta dubena afu sabisuna i urero ibinita uwarama yaru derawere ufitate i nainiti naini (99) uwaraba yaru kikiratu ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesuma eno weite mui kasei sina nono eno wei, aweta demurai danu teni (10) siriwa oi boboro nono demurai feafisuna nanefa beafite yawewe aifite doberegou utebe utebe atafisu. Eno ufisu aba me wei? ");
INSERT INTO yrb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aiwia eno ufite webiro danu daikemutuini su su uwaraini fafitaro webisu, nanu fearinu siriwa oi ataneba naini yaru uawe webisu. ");
INSERT INTO yrb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Enanari mui amarama danu siosa ueta dubena afu sabisuna Godinu aneruma yaru ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuma nono mui kasei sina eno wei, mui amarama amara sadei yanae muni. ");
INSERT INTO yrb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","I dubu yanae muni amarama wei, baba, anu ibaiabai nesia bebeate nanu mairo muma wei. Eno weiba danu damama enanari ui. ");
INSERT INTO yrb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mui kowaro dubu amara danu ibaiabai nesia fira uteda moana uwarabai oiya uite oi munite mui orofaro ani. Daba yafawere anite i aika orofaro me sara utebe oi nesia sane me sini. ");
INSERT INTO yrb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Oi ido sane me siniro i orofaro sinai derawere fariro i amara ido osi woure. ");
INSERT INTO yrb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Enoba uyarite mui amarabai gaukara ufie ani. Aniro i amarama wei, aniate nanu boro yawotebea wei. Weiro ido ani. ");
INSERT INTO yrb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Dawa osi derawere edebari uteda boronu rau ifie imuiro matawa uta. ");
INSERT INTO yrb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","I amarama yaubeda imuegou utebe imuite we imui, nanu babanu gaukara uwara faiyawere iro ibeda ieta derawere itaitaro ieta moanaini ibinuro na sinaima uine wei. ");
INSERT INTO yrb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eno we imuite wei, awona uyamate nanu bababai animate eno wemau, baba, Godini aba siosawere utebitara. ");
INSERT INTO yrb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nanu ueta sineta siosawereba anu gaukara amara na odia wemau eno we imuiya wei. ");
INSERT INTO yrb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eno we imuite uyarite danu damamabai ani. I amara ido arebiro danu damama danu amara baworo me etararowere dabaro erite neno arama uteda durami ue mane danu amara yabaite koku ui. ");
INSERT INTO yrb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Eno uiro i amarama wei, baba, Godini aba siosawere utebitara. Nanu ueta sineta siosawereba awonana na anu amara da wia wei. ");
INSERT INTO yrb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","Weiro damamama wei, nanu amara uieta ari usinute feare ibebe awona farinuba kobere wadia woure are yure odiawete age bubuke odiawete buri barueta odiawete reka keweawere borumakau uawete uda uawere ifete yaura ufe weiro enanari uta. ");
INSERT INTO yrb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","I botai amarama waiyaro gaukara utebe ekodite farina suro buma ureda yaura urebitaro naui. ");
INSERT INTO yrb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nauite mui gaukara amaraba wei, aneba eno utaita wei? ");
INSERT INTO yrb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Weiro gaukara amarama wei, anu abue awona idowere farinuba amamama i reka keweawere borumakau urinuro itaisi wei. ");
INSERT INTO yrb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Weiro i amara ibo derawere uite suro anawa ui. Dawa i suro anawa uiba damamama wawaro dawabai ido are farite ara nui wei. ");
INSERT INTO yrb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Weiro botai amarama wei, oya faiyawere anu gaukara utebe anu sina woroworo munebitarana reka borumakau naba eno ure matawa utasuro nanu naiyemutuini naini yaru utawa utaisi. ");
INSERT INTO yrb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Anu amarama anu oi sasae arumamiba me sara sane me sinite owere farinuro kobere reka borumakau urinute yaru utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Weiro damamama wei, nanu amara, aini naini uruama ibinitu. Nanu ibaiabai ane anena anu. ");
INSERT INTO yrb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Anu abue uieta ari usinute feare ibebe farinuro ataneba iba yaru utaisi wei, Yesuma kasei sina eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuma Danu iwata ueta uwaraba mui ikiki eno wei, mui amarama danu dera amaranu ibaiabaini oini yawotebi. Yawotebina moana uwarama dera amarabai fatate weita, anu yawotasu amarama anu ibaiabaini oini me sara yawotasu weita. ");
INSERT INTO yrb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Weitaba i dera amarama weiro danu yawoeta amara ido dawabai are fariro wei, i sina anene nautatane? Ina ba aba me? Anu gaukara me sininuba aniate anu kabaru buka woure mai, weiro ani. ");
INSERT INTO yrb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Anite we imui, anene umau? Na buna meba reiba gaukara da umau. Na unutawa nui weta. ");
INSERT INTO yrb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na imutatane, eno umate nanu gaukara ekodimaro nanu naiyemutuma na yawofitaita we imui. ");
INSERT INTO yrb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Idoroma danu dera amaranu moko mafitaita uwara demui demuiba eno wei. I botai amaraba eno wei, nanu dera amara ane moko mafasu wei? ");
INSERT INTO yrb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Weina wani aderedi (100) kerosini duromu ari wei. Weiro yawoeta amarama wei, anu feifa mune anu moko fifiti (50) owawa ue odia wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Eno weite mui amaraba wei, nanu dera amaraba ane moko mafasu wei? Weina raisi begi ari wani aderedi (100) mamau wei. Weiro yawoeta amarama wei, anu feifa sau mune anu moko eiti (80) owawa ue odia wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Eno uiba danu dera amarama we imui, i gagau amarana beforo bunawere we imui. I orofa atata nautawa uwarama iwata derawere uteda Godinu sina naueta uwara iwata kikiratuba ema serigari utaita. ");
INSERT INTO yrb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nanu sina wemane utatane Yesuma wei, ewa amaranu ueta ari da uawete yanu ewa orofa atata oi kobererau yawoawete uwara faiyawere durua uawero yanu naiyemutu sibita. Duburo oi me sibiro uifoitana Godima ya me ibene ibene ibeta suro durua ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Anama ibaiabai kikiratuba sara siosa utawa yawoegou utasuna ibaiabai derawere dawaba matasuro yawoegou utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ewa orofa atata oi yawoegou utawa utaitana anama yaba i urero ba ibaiabai mafiro yawofoita wei? ");
INSERT INTO yrb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mui amaranu ibaiabai yawoegou utawa utaitana anama yanu aikanu ibaiabai mafisu wei? ");
INSERT INTO yrb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mui gaukara amarama dera amara sadeinu gaukara da ufisu. Eno ue efisuna dera amara demuraiba ibo ufiro danu neno mui dera amarabai ibifisu. I dera amara demurainu gaukara uegou ufite i mui amaranu gaukara me sara ufisu wei. Enoba Godinu gaukaraini oi gaukaraini arotorowa da ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","I Ferosi uwaranu ununa oi. I uwarama Yesunu sina nauteda Yesuba sina siosa weita. ");
INSERT INTO yrb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesuma emaba wei, ya emebai yanu torowa ma kobererau utaitaro nono Godima yanu neno ubarero imueta iwata utasu. Eme emanu ununa yanu ma kobererau uetaro nono Godi Dawa erasute unutawa i ueta wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Bodereroma Joninu kowaro emema Mosesinu tarawatu sinaini i we bou ueta uwaranu sina webita. Joninu kowaroma Godinu kobere yawotasu sina webaisi. Eno webaisiba eme faiyawere Godinu yawotasu orofaro bunawere anaita. ");
INSERT INTO yrb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ureini nasinini me sibisuna ina kimu me. Nono Godinu tarawatu kikiratuna da me sibisu, dana kimuwere, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Anama danu aweta ekodasute mui aweta munasuna dita yagera farasu wei. Anama mui awera ekodi aweta munasuna dita yagera farasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesuma wei, mui ibaiabai derawere wadia kobererau bobo amara ido ibi. I amara dawa ainewaure ieta kobererau iteda kobererau ibebi. ");
INSERT INTO yrb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","I amara ainewaure eno utebina mui ba me amaimawere amarama danu bebetobai ainibeda ibaiabai derawere amaranu ieta fufuno ifie utebi. Eno uteda ainibiro kuasirima fare danu amaima badu utebita. ");
INSERT INTO yrb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mui kowaro i aramawere ibeta amara uiro Godinu aneruma dawa woure Eibaramubai ane oita. Nono i ibaiabai derawere amaraini uiro mune uri uta. ");
INSERT INTO yrb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","24","I ibaiabai derawere bobo amaranu imumuma ina yarebi kabesiro tarani. I amarama ina kabesiro oferi derawere woureda diti foraina Eibaramuini Rasarosini uruama yaubisiro erite derawere wei, baba Eibaramu, naba neno arama uate Rasarosi siaia uaro danu age rorou ogoro ma inufite nanu meanaro odifiro meana toba ufi wei. Ewa inaro oferi derawere wouratane wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Weiro Eibaramuma wei, nanu amara, anu bodere ibebi imue ea. I kowaro ana kobere ibaiabai faiyawere munebiro Rasarosina siosawere ibebi wei. Awonana Rasarosi merau ibinuro ana iro oferi wourasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nono yanu orofa anu orofa abanaro kawa derawere ibinuba ewadoroma abai anene anibitaita? Nono iroma yabairo da afitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Weiro i amarama wei, baba Eibaramu, Rasarosi ewaro nabai da afisuna nanu babanu suro siaia uaro anibite nanu kaka nabue nesia fai (5) we kakara ufiro ewa oferi woureta kabesiro da afitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Weiro Eibaramuma wei, Mosesinu tarawatuini Godinu we bou ueta uwaranu buka emabai ibinuba i buka yawifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Weina i amarama wei, me, baba Eibaramu, i buka da yawifitaitaba nono mui amarama uietaroma emabai anibite we kakara ufiro dawa naufitate emanu ba me ueta mune aika odifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Weiro Eibaramuma wei, Mosesinu tarawatu bukaini Godinu we bou ueta uwaranu bukaini da yawifitaitana mui amara uietaroma uyafite emabai anibiro dawa da naufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuma Danu iwata ueta uwaraba wei, ba me ue ereta ido fafisu. Nono mui amarama mui amara ba me ue efisuna Godima dawa fanisi mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mui amarama Nanu sina naueta amakanubai ba me maosoro siosawere uosoba i ba me maeta amaranu nodoro gebiro derawere doifitate enea ogoro sabitaro imuifirona ina kobererau yaba we kakara utatane wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yanu yatae yabuema siosawere utasuna dawa we kakara uawe. Eno uforo danu ba me ueta mune aika odifisuna danu ba me ueta imutawa uawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dawa mui kowaro yaba ueta siosa seweni (7) siosawere ufite nono owefite neno arama sina webisuna danu ba me ueta mune imutawa utebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","I afosoro uwarama Yesuba weita, Dera Amara yanu naueta ma derawere ua weita. ");
INSERT INTO yrb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Weitaro Yesuma emaba wei, yanu nauetana mui kikiratu masita ana tai arina etei sikamai anaba uyate enea ubarero ita weboitana yanu weboita enanari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","Yesuma yaba watane wei, mui gaukara amarama kowaro waiyaro gaukara utebe dumu sibiro suro fafisu. Fafiro yana weboita, amara are yauate ieta ia weboita? Enona da weboita. Eno da webote i gaukara amaraba weboita, nanu ieta ue bou uate anu torowa werei uegou uate na yawotebearo ietaini ogoini ie me simaro ido yauate ieta ia weboita wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Eno utasuna, ina danu gaukaraba dera amarama dawa we ma kobererau utawa utasu. ");
INSERT INTO yrb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Enanari Godinu wasu sina nesia ufoitana yana kobere uwarana me, ya yanu gaukara torowa utaisi, wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu Jerusaremu suro aneda Gareri orofa Samaria orofa abanaro fare ani. ");
INSERT INTO yrb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Yesu ido ane mui suro farina moana amaima bobo uwara nesia teni (10) dawa atatate etararo inaibeda derawere yua weita, Yesu, Dera Amara, ya neno arama ua weita. ");
INSERT INTO yrb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Weitana Yesuma ema ereda wei, aniawete yanu torowa i fuyo ode sina weta uwarabai yanu ibo mawetu uawe wei. Weiro anitana ema ido wirota. ");
INSERT INTO yrb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mui amaima boboro wiroi amarama danu ofe kobererau ui iwata uite owerite anedana Godi we ma kobererau uteda we ma derawere ui. ");
INSERT INTO yrb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Eno uite Yesubai farite Yesunu buri gigirariro arubi uteda we ma kobererau uteda we ma derawere ui. I amarana Samaria amara. ");
INSERT INTO yrb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","I amara eno uiro Yesuma wei, uwara nesia teni (10) wirota aba me? I moana uwara naini (9) aboro anita wei? ");
INSERT INTO yrb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aneba ewa aika amara torowana owerinute are Godinu ifu we ma derawere utasu wei? ");
INSERT INTO yrb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eno weite i amaraba wei, uya, anu imuetama a ma wirosinu wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Moana Ferosi uwarama weita, Godinu yawoe arasu kowa abododo fafisu weita? Weitaro Yesuma wei, Godinu yawoeta kowanu fareta dawa ereta tanana me iba da efoita. ");
INSERT INTO yrb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Awona ewado yawotasu da weboita, awona iro yawotasu da weboita. Godinu yawoeta ewado yabai ibinu eawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesuma Danu iwata ueta uwaraba wei, duburo i kowa ido fafiro i Ba Eme Sini Amara kowa demurairatu efene weboitana da efoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Moana uwarama yaba eno webitaita, Dawa ewado, Dawa iro eno webitaitana emanu sina da nauawete emabai Na dobere da aniawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bidama urero enabirafu enabirafu tiriri ue fa taneda ario utasuro eraita i ari I Ba Eme Sini Amaranu fareta enanari fafiro efoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nono botaina Dawa neno oferi derawere woufiro ewa orofa atata ibinita uwarama Dawa ekodifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noanu kowaro emema ane ane utebita, i Ba Eme Sini Amaranu fareta kowaro enanari ufitaita. ");
INSERT INTO yrb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noanu kowaro emema ietaini ogoini itebitate awetabo awerasi mune matanebitaro Noa ido danu boutiro amuiro obi oku derawere fariro uwara ido uie me sita. ");
INSERT INTO yrb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Rotinu kowaro enanari utebita. I kowaro emema ietaini ogoini itebitate oiya ue matebitate oiya utebitate waiya waitebitate su ubu utebitaro Roti Sodomu su ekodiro i kowaro Godima inaini barai gebiro wakiki derawere ureroma odiro tararite i uwara nesia yare me sini. ");
INSERT INTO yrb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Awona enanari emema emanu ietaini ogoini ifitate emanu unu gaukara uteibitaro i Ba Eme Sini Amara ido fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","I kowaro i orofaro yaubeta uwarana su ubarero emanu ibaiabai mubitae da anibitaita. Enanari i waiyaro gaukara ueta uwarama suro da owefitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rotinu aweta imue eawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Anama ewa orofaro me ibifie ufisuna daido ba uifisu. Nono anama dawa unutawa ewa orofaro me ibetana dawa duburo me ibene ibene ibifisu wei. Yaba ba wemaro nauawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","I dumuro amara sadei uruama nauta ainibifisiro mui amara woure anibiro mui amara iro ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aweta sadei uruama okia outeibisiro demurai woure anibiro demurai iro ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Amara sadei uruama waiyaro gaukara uteibisiro demurai woure anibiro amara demurai iro ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Eno weiro weita, Dera Waria Amara aboro ina eno ufisu? Weitaro Yesuma wei, emenu ofena i uieta ofe aboro ainibifitaro iro amuoma ifitae anibitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","2","Yesuma eme guriguri uteibitate da ekodifitae iba ewa kasei sina emaba wei, mui suro koto dera yawoeta amara dawa Godini emeba iyarawa ue me ibebi. ");
INSERT INTO yrb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","I suro mui wabu awetama ibeda i koto amarabai farebite webi, naba wasai utasu amara wiaro eno ueta ekodifi webi. ");
INSERT INTO yrb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","I wabu aweta enoma enoma webina i koto dera yawoeta amarama danu unu utawa i awetanu unu weta. I awetanu danu unu utawa uiro woroworo fare webiro dawa nautebe osi uite we imui, na Godini emeba iyarawa utebatane. ");
INSERT INTO yrb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nono ewa wabu aweta nabai sina woroworo wasuro danu sina nautebe na arama uneba awonana danu unu umate dawa durua umau. Utebe woroworo webiosoro nanu ibeta ba me uosoa wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yesuma eno weite wei, i siosawere koto dera amaranu sina nauawe. ");
INSERT INTO yrb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dawa eno utasuna Godinu sina nautaita uwarama Godiba woroworo waitaro emanu waita sina Godima nauegou utasu aba me? ");
INSERT INTO yrb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aiwia, emanu waita sina enanari sau utasu wei. Idoro i Ba Eme Sini Amarama nasiniro nono owefite fafisuna uwarama Godinu sina naufitaro efisu aba me wei? ");
INSERT INTO yrb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Moana uwarama emanu torowaba we imuta, yana kobererau nono moana uwara kobererau me, eno we imutaba Yesuma ewa kasei sina emaba eno wei, amara sadeima dera dubu suro guriguri ufisie anisi. Mui amarana Ferosi amara. Mui amarana takesi muneta amara. ");
INSERT INTO yrb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","I Ferosi amarama uyarite danu aika imuite guriguri uteda eno wei, Baba Godi, nana moana uwara ari meba we ma kobererau utatane. Na waira amarana me. Na siosa ueta amarana me. Na dita yagera fareta amarana me. Na ewa takesi muneta amara arina me. ");
INSERT INTO yrb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mui fura kowa sadei ieta itawa utatanete nanu ibaiabai nesia taisi matatane, eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nono i takesi muneta amarama maru uteda etararo inarite guriguri uteda danu dinamaro ureda wei, Baba Godi nana siosawere amaraba na neno arama ua wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesuma i sina weite emaba wei, Nanu sina nauawe, Godima i takesi muneta amaranu ba me ueta mune imutawa uiro suro tarani. Godima i Ferosi amaranu ba me ueta munawa ui wei. Anama danu torowa ma derawere utasuna dawa kikiratu ufisu. Anama danu torowa ma otowaratu utasuna Godima dawa ma derawere ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Moana uwarama emanu koiniboro Dawabai woutate Yesuma ema burifie woure fata. Eno utaba Yesunu iwata ueta uwarama etate dua sina weita. ");
INSERT INTO yrb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Weitaro Yesuma i koiniboroba yua weite Danu iwata ueta uwaraba wei, i koiniboro Nabai fafitae watane. Emanu areta daba garari da ufoita. Anama koiniboronu imueta ari imufisuna Godinu yawoeta orofana danu wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yaba ba sina wemaro nauawe. Anama Godinu yawotasu amakanunu imueta ari da mubisuna Godinu yawotasu orofaro da anibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mui yawoeta amarama Yesuba eno wei, kobere Tisa, anene umate me ibene ibene ibimau wei? ");
INSERT INTO yrb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Weiro Yesuma wei, aneba Naba kobererau wasu? Godi torowana kobererau, mui amarana kobererau me wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Godinu tarawatu a iwata utasu. I tarawatuna eno, dita yagera da fa, eme da ma uia, waira da ua, wawei webasuna meo da wia, anu anuaini amamaba uegou ua. I tarawatuna eno, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Weiro i amarama wei, i tarawatu nesia kikiraturoma eno utebatane wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Weiro Yesuma nauteda wei, demurairatu utawa utasu, ina eno, anu ibaiabai nesia moana uwarabai oiya ue mafate ibaiabai me uwaraba anu oi mate ido Nanu buribi ara. Eno ufasuna aba urero ibaiabai mafiro i ibaiabai urero ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yesuma i sina eno weiro i amarama nauite danu ibaiabai derawereba danu ibo aika uteda neno siosa ui. ");
INSERT INTO yrb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesuma i neno arama bobo amara ereda wei ibaiabai derawere bobo amarama Godinu yawotasu dabaro anibie ufisuna kimu derawere ue anibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mui egi danu ifuna kemo, dawa mara ebaro fare anibisuna ina kimu me, nono ibaiabai derawere bobo amaranu Godinu ure orofaro anetana kimuwere wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Eno weiro i nauta uwarama weita, enoba anama wirofisu weita? ");
INSERT INTO yrb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Weitaro Yesuma wei, emema da ufitaitana Godima nesia ufite Danu aikana ma wirofisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Weiro Fitama Yesuba wei, yanu su ekoisite Anu buribi anisi ea wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Weiro Yesuma emaba wei, ba sina wemaro nauawe wei, anama danu suini awetaini datae dabueini danua damamaini koiniboroini Godinu yawoetaba ekodinuba awonana faiya faiyawere mubite duburona me ibene ibene ibifisu, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuma Danu amara tuero (12) mune aika odite emaba wei, Jerusaremu suro anaisi eawe wei. Iro fafeisina Godinu we bou ueta uwarama i Ba Eme Sini Amaraba anene webita sina enanari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iro Dawa i aika uwaranu age duro odifitaro mune Dawa iruteda siosawere uteda witua ufitaita. ");
INSERT INTO yrb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Eno ufitate domuma ufitate ma uifitaro kowa rarogonu me sibiro uietaroma ido uyafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesuma eno weiro Danu sina kasei sina ari imuteda ubi kimuwereba iwawa uta. ");
INSERT INTO yrb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesuma Jeriko suro fafie uina mui diti basugari bobo amarama daba gigirariro yaubeda nui webi. ");
INSERT INTO yrb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eno uite i farebi uwaranu rurua nauteda wei, anene utaita wei? ");
INSERT INTO yrb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Weina weita, Yesu, Nasareta amara ido fare anasu weita. ");
INSERT INTO yrb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Weitaro diti basugari bobo amarama derawere wei, Yesu Deiwidinu sisia amara naba neno arama ua wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Eno weiba i uwarama kodia weitaro derawere wei, Deiwidinu sisia amara naba neno arama ua wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Weiro Yesuma inarite wei, i amara Nabai woure arawe weiro enanari uta. ");
INSERT INTO yrb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","I amarama Yesubai fariro Yesuma wei, anu ununa ane ufae wasu wei? Weiro i amarama wei, Dera Waria Amara nanu ununa ba emane watane wei. ");
INSERT INTO yrb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","43","Weina Yesuma wei, anu nauetama a ma wirosinuba ditima ba ea weina i amarama ba erite Yesunu buribi anedana Godinu ifu we ma derawere ui. I guruguru ubita uwarama i ueta etate Godi we ma kobererau uta. ");
INSERT INTO yrb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesuma Jeriko suro fare ani. ");
INSERT INTO yrb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Iro fare anebiro mui amara danu ifuna Sakiyasi i suro ibi. Sakiyasi dana dera takesi muneta amara. Dana oini ibaiabai derawere bobo amara. ");
INSERT INTO yrb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yesuma ido fare anebiro Sakiyasima Yesu efie anina eme faiyawere guruguru utate dawa garari utaro dawa fuyaratu amaraba Yesu erawa ui. ");
INSERT INTO yrb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Enoba ekodite durami ue anite sikamo ana daro mane yauri. ");
INSERT INTO yrb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mane yaubiro Yesu i orofa ido fare anedana etu ana daro ereda i amaraba wei, Sakiyasi, awona anu suro animaua sau ita wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Eno weiba i amara Sakiyasi sau ido itarite yaru derawere uteda Yesu woure danu suro ane odi. ");
INSERT INTO yrb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","I guruguru ubita uwarama i etate gimumutaroma weita, Yesuma etei siosawere amaranu suro dawaini aibie ainu weita. ");
INSERT INTO yrb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiyasima Yesunu iboro inarite wei, Dera Amara ea, nanu ibaiabai bebemate enabirafu nabai ibifiro enabirafu ibaiabai me uwaraba mamau wei. Weite wei, mui amaranu ibaiabai waira uena dawaba ini nono mui fo (4) deiro mamau wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Eno weiro Yesuma wei, awonana Godinu wiroeta ewa suro farinua wei. Ewa amaraini dawa Eibaramunu sisia amara. ");
INSERT INTO yrb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","I Ba Eme Sini Amarama dawaini i feareta uwara dobefite ma wirofie iba farinua wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","12","Yesuma anite Jerusaremu suro fafie ui. Fafie uina i uwarama Godinu yawotasu orofa sina ma boroyafie usinu we imutaba Yesuma ewa kasei sina emaba eno wei, mui dera amarama danu orofa ekodite mui orofaro anibiro iro dawa danu orofa yawoeta dera amara sina webitaro naufite owere afie ani. ");
INSERT INTO yrb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Enoba danu gaukara uwara nesia teni (10) weiro dawabai fata. Dawabai fataro emaba tueniti kina (K20) tueniti kina maite wei, ewa oi yawoegou uawete besenesi gaukara uawero fama wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Danu orofa uwara ema unutawa danu yawoetaba moana uwara dawabai siaia utaro anitate weita, ya unutawa anu yawoetaba iba ya da yawofasu weita. ");
INSERT INTO yrb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Duburo i amarama danu yawoeta sina nauite owerite suro fari. Suro farite danu oi mai gaukara uwara besenesi gaukara anene uita iwata ufie ema weiro dawabai fata. ");
INSERT INTO yrb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Fatate i botai amarama wei, dera amara, anu mai tueniti kina (K20) mui tu aderedi kina (K200) deiro odine wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Weiro dera amarama wei, ana kobere gaukara amara. Ana kikiratu kobererau yawosinuba natofo su teni (10) yawofasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mui abana amarama wei, dera amara, anu mai tueniti kina (K20) mui wani aderedi kina (K100) deiro odine wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Weiro i dera amarama wei, natofo su fai (5) yawofasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Mui abana amarama farite wei, dera amara, anu tueniti kina (K20) ewado ea wei. Weite wei, a kimu yawoteda beata waitawa nono ietata munasute anu ane odawa utasute munasu. Enoba a na iwata uteda aba iyareda anu tueniti kina (K20) wadiama obari unete ma feare odinete awona munea wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Weiro i dera amarama wei, a siosa gaukara amara! Ana nanu imueta iwata uteda utawa usinuba aba fanisi mamau wei. Na kimu yawoeta amara beata waitawa ietata munatanete ane ane odawa odeda munatane. Ina a iwata utasude nono aneba nanu oi banikaro odawa usinuro iro oi deiro mafitaro fare munawa une wei? ");
INSERT INTO yrb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Eno weite i guruguru ubita uwaraba wei, danu tueniti kina (K20) ma dare muawete etei tu aderedi kina (K200) bobo amaraba mawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Weiro weita, dera amara, dawabai tu aderedi (K200) ibinu weita! ");
INSERT INTO yrb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Weitaro dera amarama emaba wei, nanu sina nauawe wei, i derawere bobo uwaraba mui mafisu. I kikimuikiratu bobo uwaranu kikiratu ma dare mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Eno weite wei, nanu moana orofa uwarana wasai uwara ari nanu yawoeta ema unutawaba ewaro woure arawete nanu iboro uawero uifita weiya wei. Yesuma i kasei sina emaba eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","I sina we me sinite Dawa ko Jerusaremu suro anebiro Danu iwata ueta uwarama Danu buribi anebita. ");
INSERT INTO yrb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Anebe ane Betifeijini Beteni suro fafitae uta. I su sadei Oriwa maidani gigiraribai. Iro fafitae utaro Yesuma weiro Danu iwata ueta amara sadei Dawabai fasiro wei, etei mui natofo suro aniawate i suro fafawaisina su gigirari tubune tutuburo otowa doniki egi doie oitaro inaibinuba eawate na ma uregari uawate woure Nabai arawa wei. I donikinu deiro mui amara yaurawa. ");
INSERT INTO yrb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Eno weite wei, i otowa doniki aneba na ma uregari utaisi webitaitana emaba eno wiawa, wanu Dera Amarama mubite yaure Jerusaremuro anibisu wiawa wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Weiro ane fasite Danu wei sina enanari esi. ");
INSERT INTO yrb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","I otowa doniki esite ane na ma uregari utebisina i otowa doniki ubi uwarama emaba weita, ya sadei aneba i otowa doniki na ma uregari utaisi weita? ");
INSERT INTO yrb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Weitana weisi, wanu Dera Amarama mubite yaure Jerusaremuro anibisu weisi. ");
INSERT INTO yrb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","I amara sadeima otowa doniki ido wo fare oisi. Oisiro Danu iwata ueta uwarama wadia doniki deiro oitate Yesu deiro weitaro amo yauri. Yesuma ido deiro amo yaurite ani. ");
INSERT INTO yrb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","38","Yesuma yaurite aniro uwarama emanu wadia dabaro ode anita. Ane Oriwa maidaniroma tarani daba gigirari farebina Danu sina naueta uwara faiyawere buna ueta faiyawere etaba yaru uteda Godinu ifu we ma derawere uteda derawere eno weita, yanu Dera Yawoeta Amara, Godinu ifuro ido farinua weita. Godima Dawa ma kobererau ufisu. Urero wesarau ibinuba Godinu ifu we ma derawere utaisi weita. ");
INSERT INTO yrb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eno weitaba moana Ferosi uwarama Yesuba weita, Tisa, Anu iwata ueta uwaraba wiaro sina ekodifita weita. ");
INSERT INTO yrb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Weitaro Yesuma emaba wei, yaba wemaro nauawe, ewa uwarama sina ekodifitaitana i gebiroma sina derawere webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Yesuma Jerusaremu su baworo fareda i su erite i suini i uwaraba i weda wei, awonana Godinu merau ibeta iwawa utasuba Godima Danu merau ibeta abai ma fearasu. ");
INSERT INTO yrb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Mui kowa fafiro aba wasai ufitaita uwarama fafitate ewaro sakai daure makara ue sakai anu marauro sabitate ode kara ufitate a ma jugari uteda anu uwara ma uifitaita. Eno ufitaro i maraunu gebiro muima muinu deiro da ibifisu. A Godinu me maeta unutawaba iba eno ufitaita Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Yesuma i dera dubu suro amui. Amuite i oiya ueta uwara suroma we ma yowereda emaba wei, Godinu bukaroma eno wasu, Nanu suna guriguri ueta su. Yana Nanu suna waira ueta uwaranu su uta wasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","48","Yesuma kowa ainewaure dera dubu suro we mawetu utebi. Eno utebina i dera fuyo ode sina weta uwaraini i Ju uwaranu yawoeta uwaraini Yesunu ma uieta daba dobetana i uwara nesia Danu sina nauegou utaba Danu ma uieta daba atanawa uta. ");
INSERT INTO yrb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mui kowaro Yesuma we mawetu uteda Godinu kotofu sina webina i dera fuyo ode sina weta uwaraini tarawatu tisa uwaraini dera baeta uwaraini ema Yesubai fata. ");
INSERT INTO yrb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Fatate weita, Anu bunaro eno utasu? Anama Aba buna masinuro eno utasu? Wiaro naufe weita. ");
INSERT INTO yrb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Weitaro Yesuma emaba wei, Nanu wenauereta botai wemaro yanu moko sina wiawero nauma weite wei, Joni Babataito uetade ureroma fari aba emebairoma fari wei? ");
INSERT INTO yrb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Weina sina we mataneda emanu aika weita, ane webeisi? Ureroma fari webeisina Joni aneba nautawa uta webisu. ");
INSERT INTO yrb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Emebairoma fari webeisina i uwara nesia Joni dawa Godinu we bou ueta amara imutaitaba ya gebiroma ufitaita weita. ");
INSERT INTO yrb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Emanu aika eno weitate Yesuba weita, ya iwata me weita. ");
INSERT INTO yrb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eno weitaba Yesuma emaba wei, idoba Nanu buna utatane sina anama mairo utatane yaba da wemau wei. ");
INSERT INTO yrb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesuma i uwara nesiaba ewa kasei sina yare wei, mui amarama gureifi yo waiyaro waite danu waiya moana uwaraba yawofitae mateda mui orofaro ani. Ane iro sakara faiyawere ibebi. ");
INSERT INTO yrb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Duburo ayo ureta kowa ido fariro danu waiya ueta amara danu gureifi tai moana mubie siaia uiro ani. Ane fariro i waiya yawoeta uwara ema unutawa maeta iba i amara mutate isuma urebe gureifi tai matawa uteda ma owetate siaia utaro ani. ");
INSERT INTO yrb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nono dawa mui amara siaia uiro ani. Ane fariro enanari isuma urebe siosawere uteda gureifi tai matawa, ma owetate siaia utaro ani. ");
INSERT INTO yrb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dawa nono mui amara siaia uiro ani. Ane fariro enanari ure ma iwiji awiji utate dawa yowetaro ani. ");
INSERT INTO yrb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Eno utaba i waiya ubi amarama we imui, anene umau? Nanu amara ubi siaia umaro dawa kakara ufitaita we imui. ");
INSERT INTO yrb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Eno We imuite danu amara ubi siaia uiro ani. Ane fariro emanu emanu we matatate weita, ewana danu amara ubiba ma uifete danu waiya yana mubeisi weita. ");
INSERT INTO yrb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eno weitate i amara muneda waiya dowa dubenaro satate dawa ma uita, Yesuma eno wei. Eno weite emaba wei, i waiya ubi amara emaba ane ufisu? ");
INSERT INTO yrb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Dawa anibite i waiya yawoeta uwara nesia ma uifite danu waiya aika uwaraba mafisu wei. Eno weiro nauteda weita, ema! eno da ufisu weita. ");
INSERT INTO yrb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Weitaro Yesuma ema ereda wei, ane waita? Godinu bukaroma eno wasu, i su ubu ueta uwaranu mu sata gebirona i botai tutubu ari sini, Godinu bukaroma aneba eno wasu wei? ");
INSERT INTO yrb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Anama i gebiroro ureifisuna danu tai furiafisu. Nono i gebiroma ananu deiro ureifisuna i amara ure ma musimusi ue sakai ari sibisu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesuma i kasei sinana emanu sina webie imutate i tarawatu tisa uwaraini dera fuyo ode sina weta uwaraini Yesu budari ufitae utate i uwaraba iyataba ekoita. ");
INSERT INTO yrb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ekoitate imuegou utate moana uwara Yesubai siaia utaro anita. I uwarama Yesu me iruteda gagau ue anita. Yesu i gaemani dera amaranu age duro odifitae iba Danu sina ane nauegou uta. ");
INSERT INTO yrb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","I uwarama Yesuba weita, Tisa, Ana eme nesiaba arotorowa utebasu. Eme derawere aba kikiratu eno unutawa utasute ba we mawetu utasute emeba meo utawa utasute Godinu sina ba wasu weita. ");
INSERT INTO yrb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Weitate weita, idoba Romani gaemani amara, Sisabai takesi mafeisina ina ido aba me weita? ");
INSERT INTO yrb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Weitaro Yesuma emanu irueta imueta iwata uteda wei, siriwa oi maiwero ema wei. Weiro mataro ereda wei, ananu kofirini owawaini ewado ibinu wei? Weina Sisanu weita. ");
INSERT INTO yrb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eno weitaba Yesuma wei, idoro Sisanu ane ane Sisaba mawete Godinu ane ane Godiba mawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eno weiba nautate i uwaranu iboro Yesu meo gagau utawa utate Danu sinaba neno kirifu uteda wate wiawa wate mu uta. ");
INSERT INTO yrb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Duburo moana Mosesinu tarawatu utaita uwara, Sadusi waita uwarama Yesubai fata. I Sadusi uwarama eme uietaroma da uyafitaita we mawetu utebita. ");
INSERT INTO yrb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","I uwarama Yesubai fatate weita, Mosesinu tarawatu eno wasu, mui amarama aweta mubite aruma amara munawa me ibebe uifiro danu dabuema danu aweta wabu mubite i uieta amaraba aruma amara yanae mubisu wasu weita. ");
INSERT INTO yrb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Eno weitate weita, adarabu nesia seweni ibita. I botai amarama aweta munite aruma amara yanae munawa me ibebe ui. ");
INSERT INTO yrb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Me uiro danu buribi dabuema dataenu aweta wabu munite aruma amara yanae munawa me ibebe ui. ");
INSERT INTO yrb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","I mui abana dabuema i aweta wabu enanari muniro enoma enoma enanari nesia mutate aruma amara yanae munawa me uie me sitaro nono duburo i aweta ido ui. ");
INSERT INTO yrb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","I aweta amara sewenima mutaba duburo i uietaroma uyareta kowaro abo amarama i aweta mubisu weita? ");
INSERT INTO yrb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Eno weitaro Yesuma emaba wei, ewa kowaro ibinita uwarama aweta awera munaita. ");
INSERT INTO yrb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nono i kobere uwara, i uietaroma uyafitate me ibene ibene ibifitaita uwarama aweta awera da mubitaita. ");
INSERT INTO yrb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iro Godinu aneruini i uwaraini arotorowa. I uwarana Godinu adarabuba iro da uifitaita. Godima ema uietaroma ma uyafite me ibene ibene ibeta emaba mafisuba iba nono iro da uifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Eno weite wei, Mosesima wei, Godima i uieta uwara ma uyarasu wei. Mosesima i uitawa yareta ana ereda wei, Godina yanu sirorari uwara Eibaramuini Aisikini Jeikofuini emanu Godi wei. ");
INSERT INTO yrb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yesuma weite wei, Godina i wiroeta uwaranu Godiba iba uieta uwara nesia me ibinita, Godina i ba me sita nautawa uwaranu Godi me, Godima wasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Eno weiba moana tarawatu tisa uwarama mui sina weta unutawaba weita, Tisa, ba wasu weita. ");
INSERT INTO yrb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","I uwarama eno weitaro Yesuma emaba nono wei, i tarawatu tisa uwarama Keriso Deiwidinu sisia amara aneba eno waita? ");
INSERT INTO yrb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Deiwidima i Samusi bukaro Mesaiaba eno wasu, Godima nanu Dera Waria Amaraba wei, Nanu banibira age afu yauaro aba wasai utebaita uwara buna umate Anu buri eminaro odimau weiya wasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yesuma weite wei, Deiwidima Kerisoba Nanu Dera Waria Amara weiba anene Keriso Deiwidinu sisia amara sini wei? ");
INSERT INTO yrb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Yesuma eno weite i uwara nesianu iboro Danu iwata ueta uwaraba wei, i tarawatu tisa uwaraba eregou uforo wei! I uwaranu ununa yafa asugari ueta wadia barufitate maketi kabesiro inaraita uwaranu ario sina naufitate Ju uwaranu dubu su kobere yaureta kabesiro yaufitate ogaro botai yaureta kabesiro yaufitae utaita. ");
INSERT INTO yrb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","I uwarama wabu awetanu ibaiabai waira utaitate guriguri yafawere eme naufitae iba utaita. Eno utaitaba Godima ema fanisi derawere mafisu, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mui kowaro Dawa dera dubu suro inaibeda erebina gugua gubari uwara faiyawere me maeta mauaro oi fare sanebita. I ibaiabai derawere bobo uwarama oi derawere fare sata. ");
INSERT INTO yrb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","3","Nono mui ibaiabai me wabu awetama fare toea sadei saniro Yesuma erite wei, Nanu sina ba yaba wemaro nauawe wei. Ewa wabu aweta oi derawere saninuro i uwara nesia oi kikiratu sanita. ");
INSERT INTO yrb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","I uwarabai oi faiya faiyawere ibinuba iba emanu oi kikiratu ari sanita. Ewa wabu aweta danu ieta oiya ueta oi nesia saninuba iba danu oi derawere saninu wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Moana uwarama i dera dubu suba eno weita, i dera gebiroraraboini werei werei eawe weita! ");
INSERT INTO yrb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Weitaro Yesuma nauite wei, yanu awona eraisi, i, mui kowa ido fafiro gebiro nesia ma ubefitaro mui gebiroma mui gebiro deiro da ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesuma eno weiba Dawaba weita, abo kowaro eno ufisu? Ane ueta ufiro efero eno ufisu weita? ");
INSERT INTO yrb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Weitaro Yesuma emaba wei, moana uwarama ya irufitae webitaitaba eregou uforo wei. Uwara faiyawere irufitae Nanu ifuro fafitate nana keriso i kowa farinu eno webitaitana emanu sina da naufote emanu buribi da aniboro wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dera urane yarane ueta sina naufote iya da uyaforo wei. Ina botai ufisuna i dubu kowa duburo ido fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","11","Yesuma emaba nono wei, mui orofa gaemanini mui orofa gaemanini urafitaita, orofa atata uwara aika maika urafitaita, orofa faiyawere nasini wawana wawana ufisu, orofa faiyawerero sinai derawere woufitate oferi derawere woufitaita, urero ereta efitate iya derawere uyafitate nono urero mui buna ereta efitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","13","Yesuma eno weite wei, botai ko uwarama ya mune siosawere ufitaita. Ya Ju uwaranu dubu su yawoeta uwaranu age duro odifitate diburaro odifitate dera kini uwaraini gaemani yawoeta uwarabai Nanu ifuba woure odifitaita. Eno ufitaitana i kowaro Nanu sina weboita. ");
INSERT INTO yrb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","I uwaranu wawei weta, ane moko sina weboita da imuegou uforo yaba wemate buna imueta mamaro weboro yaba wasai ufitaita uwarama moko sina da webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yanu yanua yamama yatae yabue yanie yauwa yanu su uwara, ema nesia ya budari ufitae wawei webitaro ya ufitaro moana uifoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Uwara nesia ya Nanu ifuba neno ka ufitaro Godima ya durua ufisuba yanu fouma iji me sara da itafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Bunawere ufote inare kimu ufoitana duburo me ibene ibene ibifoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesuma i sina weite wei, meremere uwarama Jerusaremu suro ode kara ufitaitana eforo Jerusaremu sunu ma arama ueta kowa ido fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","I kowa ido fafiro i Judia orofa uwarama maidaniro sau manibitaro i waiyaro gaukara ufitaita uwarama Jerusaremu suro da owefitate anibitaita. ");
INSERT INTO yrb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Godinu we bou ueta uwaranu webita sina i kowaro Godima Jerusaremu su uwara enanari fanisi mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","I kowaro dia bobo awetaboini ama ieta kuita bobo awetaboini emanu anibitaita dabana siosawere. Ewa orofaro siosawere ufitate i uwaraba neno ka derawere ufitaita. ");
INSERT INTO yrb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Neno ka derawere ufitate uwara faiyawere dera kaiyama umane tufitaro uifitaro uwara faiyawere budari ufitate mui orofa atata aboro aboro woure anibitaita wei. I aika uwarama Jerusaremu su ma jugari ufitate amune adire anebe anebe emanu kowa ido me sibiro ekodifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesuma emaba mui sina eno wei, urero kowaini sakaraini muinaini iro ereta aika maika efoita. Ewa orofaro enea ufe rurua derawere weda uyafisuba emema iya uyafitate ina iwawa ufitaita. ");
INSERT INTO yrb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ure ibaiabai nesia wawana wawana ufisuna emema i fafisu ane aneba neno siosa ufitate uieta ari dowafitaita. ");
INSERT INTO yrb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nanu wene nesia ufisuna i Ba Eme Sina Amarama gosoro bunaini ario derawere ido fafiro efitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","I nesia tutubari ufisuna rorowarau inawete urero eawero yanu ma wiroeta amara ido fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesuma emaba kasei sina eno wei, i boruba anaini aika ana eawete iwata uawe. ");
INSERT INTO yrb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Reka tua oyafisuna kowa kowa ido farinu waita. ");
INSERT INTO yrb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Enanari nanu wene sina reka ufiro eforo Godinu yawotasu kowa ido fafie usinu iwata ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yaba ba sina wemaro nauawe. Ewa ibinita uwara da me sibitaro i nesia ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ureini nasinini me sibiro Nanu sina da me sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Eregou uforo! Me sara da ibifote kimu ogo iteda gogore da ufote ewa orofa ibaiabai torowa da imufoitaba ogama gasira kiwuma munasu i ari i kowa kiwuma yabai faosoba wei. I kowana orofa atata ibifitaita uwara nesiabai fafisu. ");
INSERT INTO yrb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eregou uforo! Buna muboe guriguri uforo i siosawere fafisu uetama ya ma siosa da ufiro i Ba Eme Sini Amaranu iboro me inafoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesuma ainewaure dera dubu suro we mawetu utebi. Kowaro we mawetu utebite nono dumurona Oriwa maidaniroma ane ainebi. ");
INSERT INTO yrb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Eno utebina i uwarama waura warairo dera dubu suro Dawabai Danu sina naufitae fata. ");
INSERT INTO yrb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Godima i Isaraero uwara Ijifiroma woure aneta ogaro kowa fafie ui. Ina wawareta ira yisiti me buredi itebita ogaro. ");
INSERT INTO yrb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","I kowaro dera fuyo ode sina weta uwaraini i Tarawatu Tisa uwaraini Yesunu ma uieta daba dobetate i uwara nesiaba iyataba atanawa uta. ");
INSERT INTO yrb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","I kowaro seitanima Judasi Isikariotinu neno ubarero itari. Judasina Yesunu mui tuero (12) iwata ueta amara. ");
INSERT INTO yrb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judasima i dera fuyo ode sina weta uwarabai Yesu do mafie ane fari. ");
INSERT INTO yrb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eno uiba i uwarama yaru utate Judasiba oi mafitae weita. ");
INSERT INTO yrb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Enoba Judasima Yesunu do maeta daba doberebi. Dawa unutawa eme faiyawerebai do maetaba iba doberebe doberebe eno ui. ");
INSERT INTO yrb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Godima Isaraero uwara Ijifiroma woure aneta ogaro kowa ido fari. I kowaro wawareta ira yisita me buredi itebitate ogaronu fuyo mamoenatu urebita. ");
INSERT INTO yrb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Enoba Yesuma Fitaini Joniba wei, aniawate i ogaro ue bou uawaro ife wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Weiro Dawaba weisi, aboro ane ufutu weisi? ");
INSERT INTO yrb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Weisiro Yesuma wei, natofo suro aniawate mui ogo woureta amara eawate danu buribi aniawa. ");
INSERT INTO yrb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ane danu suro amufawaisina i su ubi amaraba wiawa, wanu Tisa amarama wenu, anu owiga uwaranu yaureta koru mawetu uaro iro Naini Nanu iwata ueta uwaraini i ogaro ife wenu, eno wiawa wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eno wiawaro yaba dera yauretaini kaiyo bobo koru mawetu ufiro iro yanu ogaro uawa wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Weiro anisite Yesunu wei enanari esite i ogaro ue bou usi. ");
INSERT INTO yrb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","I ogaro ieta wai ido fariro Yesuini Danu afosoro uwaraini ieta ifitae yauta. ");
INSERT INTO yrb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesuma emaba wei, Nanu oferi woureta kowa fafie utasuba yaini ewa ogaro iegou umane watane wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yaba wemaro nauawe. Ewa ogaro yaini nono da imate uimauna Godinu yawotasu kowa ido fafiro iro imau wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesuma eno weite waini kafusi mune Godiba we ma kobererau uite emaba wei, ewa kafusi nata nata uawete iawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yaba wemaro nauawe, nadidi tai dumamu nono da imaro Godinu yawotasu kowa ido fafisuna ido nono imau wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Eno weite buredi mune Godiba we ma kobererau uite ina ma birabiarite emaba mateda wei, ewana nanu ofe yaba ma birabiaratane. (Ina iteda Na imuawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ieta ie me sitaro Yesuma mui kafusi munite wei, ewa kafusina Nanu reka unuro ue mataneta onono yaba itarasu wei.) ");
INSERT INTO yrb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yesuma eno weite wei, Na do masinu amaraini ewa kaiyobai yaubinisi eawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","I Ba Eme Sini Amarana uifisu Godima wasuba enanari uifisu. Nono Na masinu amaraba fanisi derawere mafisua wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Eno weiba Danu iwata ueta uwarama emanu aika we mataneda weita, anama eno ufisu weita? ");
INSERT INTO yrb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","I iwata ueta uwarama bebetuma yaraneda weita, yabai abo amarade dera amara weita? ");
INSERT INTO yrb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Weitaba Yesuma emaba wei, i aika dera yawoeta uwarama emanu gaukara uwara kimuwere yawotaitaro gaukara uwarama ema yanu dera uwara waita. ");
INSERT INTO yrb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yabaina eno me. Yabai, yanu dera amarana otowaratu ari sibisu. Dawa yanu gaukara utasu. ");
INSERT INTO yrb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","I kaiyobai yaubeda ieta itasu amara dana derawere. I ieta gaukara utasu amara dana otowaratu. Nono yabai, Nana yanu gaukara utatane Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","29","Yesuma emaba wei, Nanu awe kowa nesiaro yana nabai ibebaitaba Nanu Babama Naba yawoeta orofa mai enanari yaba matatane. ");
INSERT INTO yrb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nanu yawoeta orofa iro Nanu kaiyobai yaubeda Naini ietaini ogoini ifote i Isaraero uwaranu abua tuero (12) yawoteiboita wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","32","Yesuma Fitaba wei, Saimoni, emema uiti tai tore sanaitaro oyauma ifuru afuru ure wawanasu enanari seitani danu ununa ya uwaranu imueta mune ma iwawa iwawa ufiro yanu kobere imueta me sibie utasuba iba Godibai aba guriguri une. Nono duburo anu imueta Godibai ma owefasuna anu aiyemutunu imueta ma kimu ua wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Weiro Fitama wei, Dera Waria Amara, Aini diburaro animau. Aini ba uimau wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Eno weiba Yesuma wei, Fita, Nanu sina naua wei. Kokora awona da webiro a ko Nanu ifu rarogonu ma feareda meo webasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesuma Danu iwata ueta uwaraba wei, bodere ya siaia uero fausini yoateini mui sadoroini munawa me anita. Yanu anetana ido aba me wei? Weina yanu anetana kobererau weita. ");
INSERT INTO yrb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Weitaro wei, awonana i fausini yoate bobo uwara ina woure aniawete ba kaiya me uwara emanu dei barueta emebai oiya ue mawete oi muawete ba kaiya oiya uawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Eno weite nono wei, Godinu bukama Naba eno wasu, Dawaini i siosawere uwaraini arotorowa waita wasu. Ido Godinu bukaro Naba eno owawa ue odiba enanari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yesuma eno weiro weita, Dera Waria Amara, ba kaiya sadeina ewado ea weitana wei, idoya sina kodiawe wei, Yesuma. ");
INSERT INTO yrb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesuma suroma itarite Danu Oriwa maidaniro anebi i enanari aniro Danu iwata ueta uwarama Danu buribi anita. ");
INSERT INTO yrb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Iro ane farite emaba wei, guriguri uawe utebe siosawere ueta muotote siosawere uotoa wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Eno weite ema ekodite fuyaratu ani. Anite yajigoma jegirari uite guriguri uteda wei, ewa siosawere wakiki ogo ari, ewa wai Nabairoma mubae ufasuna mua wei. Weite wei, Nanu unu da uate Anu unu ua wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","(Ureroma aneru Yesubai me ari ue tararite Yesu ma kimu ui. ");
INSERT INTO yrb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma kimu uiro Yesuma neno oferi derawere woureda guriguri uegou uiba Danu oferoma wadada onono ari nasiniro itari.) ");
INSERT INTO yrb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesuma guriguri utebe ekodite uyarite Danu uwarabai anina emanu nenonu imueta urumu derawere uiba nauta ainibitaro eri. ");
INSERT INTO yrb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ema erite wei, aneba nauta ainibinita? Uyawete guriguri uawe utebe siosawere ue ereta yabai faosoro siosawere uotoa wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","48","Yesuma eno weina eme fefera ido fata. Judasi mui tuero (12) iwata ueta amara dawa ko fariro i uwara nesia danu buribi fata. Fataro Judasima Yesubai farite Yesu koku uiba Yesuma wei, Judasi, i Ba Eme Sini Amarabai koku utasuna ina eno uraneta uwara woure fareda utasu wei? ");
INSERT INTO yrb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Danu iwata ueta uwarama i uwaranu imueta iwata utate Yesuba weita, i uwaraini urafeisi? Yanu ba kaiya ewado ea weita. ");
INSERT INTO yrb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Eno weitaro mui iwata ueta amarama ba kaiya munite i dera fuyo ode sina weta amaranu gaukara amaranu banibira ome umane kosari uiro nasiniro itari. ");
INSERT INTO yrb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Eno uiro Yesuma wei, eno da uate kodia weite i gaukara amaranu ome burite ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Eno uite Yesuma dera fuyo ode sina weta uwaraini dera dubu su forisimani kafitenini Ju dera uwaraini, Dawa mubitaita uwaraba wei, Na waira ueta amara me rairo aneba ba kaiyaini goreini woure farita wei? ");
INSERT INTO yrb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Eno weite wei, i dera dubu suro yabai ibebitararo i kowaro Na budari utawa utate nono awonana yanu kowa. Awonana seitanima buna utasu wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","I uwarama Yesunu agero mune anita. I dera fuyo ode sina weta amaranu suro ane oita. Ema ko anitaro Fitama yafawere emanu buribi ani. ");
INSERT INTO yrb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","I uwarama su teteuro ina moatate ina gigirariro yautaro Fitaini iro ane yauri. ");
INSERT INTO yrb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Iro yaubitana ina ario uiro mui gaukara arumama Fita erebe wei, ewa amaraini Yesuini arotorowa ibisi wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Weiro Fitama wei, aruma, i Amara na iwata me wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yaubebe mui amarama wei, dana Yesunu mui iwata ueta amara wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yaubebe yaubebe mui amarama wei, ewa amarana Gareri amaraba dawaini Yesuini arotorowa ibisi wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Weiro Fitama wei, amara mera, anu sina na iwata me weina kokora ido wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","62","Weiro Yesuma owere Fita erina Fitama Yesunu kokora webiro a ko Na rarogonu me webasu wei sina imuite wawaro anite i wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesu budari uta uwarama Yesu iruteda isuma uta. ");
INSERT INTO yrb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Emana Yesunu diti wadiama garari utate agema ureda weita, anama A urinu? We bou uaro naufe weita. ");
INSERT INTO yrb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Eno weitate moana siosa sina faiyawere weitate Dawaba siosawere uta. ");
INSERT INTO yrb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wai urina Ju uwaranu dera kanisoro uwarama mitini uta. I dera fuyo ode sina weta uwaraini tarawatu tisa uwaraini dera uwaraini ema nesia kanisoro mitini ufitae utate Yesu mune emanu kabesiro anita. ");
INSERT INTO yrb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","Ane fatate Yesuba weita, Ana Kerisona wiaro naufe weita. Weitaro Yesuma emaba wei, ina wemaro Nanu sina da nauforo yaba wenauereta wemaro moko weboita wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Eno weite wei, awonaroma i Ba Eme Sini Amarama i buna derawere Godinu banibira age afuro yaufiro efoita wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Weiro weita, Ana Godinu Amara wasu weita? Weitaro Yesuma wei, ba waita wei. ");
INSERT INTO yrb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Eno weiba weita, Danu wenu sina nausiba mui wawei weta uwaranu sina da naufeisi weita. ");
INSERT INTO yrb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","I kanisoro uwara nesia uyatate Yesu Faeratibai woure anita. ");
INSERT INTO yrb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ane fatate eno wawei weita, ewa amarama Ju uwara nesia irutasute takesi oi i Romani gaemani uwaraba da mawe wasute Nana Keriso, yanu Dera Yawoeta Amara wasu, eno wawei weita. ");
INSERT INTO yrb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eno weitaba Faeratima Yesuba wei, Ana i Ju uwaranu dera yawoeta amara aba me wei? Weina ba wasu, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Weiro Faeratima i dera fuyo ode sina weta uwaraini i guruguru ubita uwaraba wei, i amarabai kerere atanawa une wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Eno weiba derawere weita, i Judia orofa uwara, Gareriroma ewaro, i eme nesiabai we mawetu utasute kerere utasugo weita. ");
INSERT INTO yrb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","I kanisoro uwara eno weitaro Faeratima nauite wei, i amarana Gareri amara aba me wei? ");
INSERT INTO yrb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Weina aiwia weitaba Yesu Erodibai woure anibitae Faeratima wei, Erodima Gareri orofa yawoteda i kowaro Jerusaremu suro ibiba Yesu dawabai woure anibitae wei. Weiro enanari uta. ");
INSERT INTO yrb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erodima Yesu efie utebe i kowaro dana Yesu erite yaru ui. Erodima Yesunu buna ueta sina nauite danu ununa Yesunu buna ueta efie ui. ");
INSERT INTO yrb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Enoba Erodima buna ueta efie uteda Yesuba wenauereta faiyawere weiro Yesuma moko wiawa ui. ");
INSERT INTO yrb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Erodima eno weina i dera fuyo ode sina weta uwaraini tarawatu tisa uwaraini emana wawei derawere weita. ");
INSERT INTO yrb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erodini danu ami uwaraini Yesuba siosawere uteda irutate kobere wadia barue oitate Yesu ma owetate Faeratibai siaia uta. ");
INSERT INTO yrb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bodere Erodini Faerati moko moko wasai ue matanebisina nono i kowaro naiye we matasi. ");
INSERT INTO yrb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Faeratima weiro i dera fuyo ode sina weta uwaraini tarawatu tisa uwaraini i uwara nesia dawabai fataro emaba wei, ewa amara nabai oitate Dawa i Ju uwara nesiabai kerere utasu waitaba Dawa wenauegou unete Dawabai kerere atanawa une. ");
INSERT INTO yrb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Enanari Erodima Dawabai kerere atanawaba Dawa nabai moko ma owere siaia usinu wei. Dawabai kerere meba da ma uimau. ");
INSERT INTO yrb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kerere meba wemaro isuma derawere ufitaro me anibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(I Ju uwaranu baeta edono, mui oya mui oyaro Faeratima dibura amara demurai ma uregari utebi.) ");
INSERT INTO yrb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Faeratima weiba i uwara nesia derawere weita, i amara ma uiate Barabasi yabai odia weita. ");
INSERT INTO yrb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabasi dawa Ju uwaraini Romani gaemani uwara urafitae weite eme ma uiba iba diburaro oitaro ibi.) ");
INSERT INTO yrb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","21","Faeratima Yesu ekodifie uite i uwara nesiaba weina derawere weita, korosiro odia! Korosiro odia weita! ");
INSERT INTO yrb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Faeratima sadei weite nono wei, ane kerere usinu? Dawabai kerere meba da ma uimate wemaro isuma ufitaro me anibisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Weiro Dawa korosiro odia eno derawere webitaba Faeratima Yesu uieta sina ido wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ido weite Barabasi, i urane yarane ma uieta amara ma uregari uiro i uwarama emanu unu Yesuba ane ufitae utaba Faeratima Yesu emaba mai. ");
INSERT INTO yrb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","I uwarama Yesu mune anita. Mune anebitana Sairina orofa amara Saimoni waiyaroma are fariro etate i amara Yesunu korosi woufie weita. Eno weitaro i amara korosi wourite ema anitaro i amara Yesunu buribi ani. ");
INSERT INTO yrb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","28","Uwara faiya faiyawere emanu buribi anita. Sorara utebita awetaboini anitaro Yesuma owerite emaba wei, ya Jerusaremu su awetabo, Naba i da wiawete yaini yanu koiniboroba i wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","30","Mui kowaro siosa kowa ido fafiro emema webitaita, i aruma amara me awetabo yaru ufitaita, i dera maidanini kiki maidanini ureiawete ya ma tafuawero uifene webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Na, i waratasu tata bobo ana ari eno utaitaba ya i sibu ana ariba ane ufitaita, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mui amara sadei, kerere ue diburaro ibeta amara sadeini Dawaini ma uifitae woure anita. ");
INSERT INTO yrb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ane kofiri tai torowa webaita orofaro fata. Fatate Dawa korosiro oita. Mui diburaro ibeta amara enabira afu korosiro oitate mui diburaro ibeta amara enabira afu korosiro oitate Yesu abana korosiro oita. ");
INSERT INTO yrb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Eno utaro Yesuma wei, Baba, emanu ueta iwawa utaitaba emanu ba me ueta da imua wei. Danu wadia anama mubisu we imutate iba kasi uta. ");
INSERT INTO yrb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","I guruguru ubita uwarama inaibeda erebitana i Ju yawoeta uwarama irue weita, Dana eno wei, Nana Godinu ma wiroe mune aneta Amara, Godinu Keriso Na, eno weiba moana uwara ma wirotebi enanari Danu torowa ma wirofi weita. ");
INSERT INTO yrb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","I ami uwarama Dawa iruteda diririwere ana tai dumamu Dawa ifie matate weita, Ana i Ju uwaranu dera yawoeta Amarana anu torowa ma wiroa weita. ");
INSERT INTO yrb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mui sina, ewana i Ju uwaranu dera yawoeta amara, eno owawa ue odiro korosi deiro ure oitaro ibi. ");
INSERT INTO yrb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mui diburaro ibi amara, dawa enabira afu korosiro ibeda Yesuba wei, Ana Godinu Keriso aba me? Aini waini ma wiroa wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Eno weiro etei mui amarama dawaba we kakara uteda wei, eno da wia. Ana anu ueta siosaba uitasude Godiba iya uyarasu aba me wei? Eno weite wei, aini naini wana siosawere utuba iba aidoro uitaitu. Nono ewa amarana siosawere utawa ui. ");
INSERT INTO yrb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eno weite wei, Dera Waria Amara, Anu yawofasu kowa fafisuna na imuegou ua wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","I amarama eno weiro Yesuma dawaba wei, awonana aini Naini i kobere Faradisia waita orofaro ane ibifutu wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Kowa otoro nono kowa ario utawa dumu sini ibiro kowa ane osugari uite ane abanaro farina kowa nono ario ui. I dera dubu su garari ueta wadia deiroma abanaro babare eminaro itari. ");
INSERT INTO yrb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nesia eno uiro Yesuma derawere wei, Baba, Nanu imumu Anu age duro odine weite ido ui. ");
INSERT INTO yrb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Eno uiro ami kafiteni amarama erite Godinu ifu we ma derawere uite wei, ewa amarabai kerere me. Dana kobere amara wei. ");
INSERT INTO yrb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","I efitae guruguru ubita uwarama nesia etaro Yesu uiba owetate neno siosa derawere uteda suro wo bogaru ue anita. ");
INSERT INTO yrb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesunu domayamutuini i awetaboini Gareriroma Yesunu buribi ata. I ata uwara nesia iro inaibeda i ueta sineta nesia eta. ");
INSERT INTO yrb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mui Arimatia su amara Jousefa dana kanisoro amara, dawa Godinu sina nautebi. Dana kobere amara. Dawa Godinu yawotasu kowa yawotebi. I kanisoro uwarama Yesu ma uifitae weitaro dawa unutawa Yesu ma uieta. ");
INSERT INTO yrb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","53","I amarama Faeratibai anite Yesunu ofe nui weite Yesunu ofe korosiroma munite inawere wadiama wayari. Wayare me sinite reka gebiro uri oeta erabo, mui amara iro odawa, dana Yesu i kabesiro woure ane odi. ");
INSERT INTO yrb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Odiro i sabate kowa ue bou ueta kowa me sibiro sabate kowa ido fafie ui. ");
INSERT INTO yrb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yesunu buribi i Gareriroma ata awetabo Jousefanu buribi anitate i uri oeta kabesi eta. ");
INSERT INTO yrb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Etana Yesunu ofe iro oitaro eta. Etate owetate suro anita. Ane fatate Danu uri oeta bonanawere faudaini ogoini ue bou uta. Eno utaro sabate kowa fariro Godinu tarawatuba imoita. ");
INSERT INTO yrb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sabate kowa me siniro waikukuro i awetaboma emanu ue bou ueta fauda mutate i uri oeta kabesiro anita. ");
INSERT INTO yrb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ane fatana i dera garari ueta gebiro ifegari ubiro eta. ");
INSERT INTO yrb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","I gebiro ifegari ubiba eraboro itatate etana Yesunu ofe me! ");
INSERT INTO yrb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","I awetaboma inaibeda imutebitana inakeowere wadia bobo amara sadei emabai ido inaibisi. ");
INSERT INTO yrb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ido inaibisiba iya uyatate tafu derawere uta. I amara sadeima weisi, i me ibeta amara uieta uwaranu kabesiro aneba doberaita weisi? ");
INSERT INTO yrb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Weisite Dawa ewado me. Dawa uyarite me ibinu weisi. Ya nesia Gareri orofaro ibitana Dana ya uwaraba wei, i Ba Eme Sini Amara siosawere uwaranu age duro odifitaro Dawa ma uifitaro kowa rarogonu me sibiro Dawa nono uyafisu eno wei. Ina imutaita aba me weisi? ");
INSERT INTO yrb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Eno weisiro Danu sina imutate uri oeta kabesi ekoitate anita. Ane Yesu Danu iwata ueta uwara nesia irewenini (11) nono moana uwarabai i eta sina nesia weita. ");
INSERT INTO yrb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","11","I awetabonu ifuna Meri Megidarina Joanaini Jeimisinu danua Meri moana awetaboini emana i afosoro uwarabai i sina weitaro nautate ba sina aba me ari we imutate iba imutawa uta. ");
INSERT INTO yrb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Fita danu torowana efie uri oeta kabesiro durami ue ani. Ane farite tafu uteda erina uri oeta erabo ubarero i wayareta wadia torowa ibiro erite owerite i nesia nenoma imuteda suro ani. ");
INSERT INTO yrb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","I kowana fura derawere Sade, Godinu sina naueta amara sadei Jerusaremu suroma Emeiasi suro anisi. ");
INSERT INTO yrb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Dabaro anetana Yesu me sini sina sina we mataneda anebisi. ");
INSERT INTO yrb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Eno we mataneda anebisina Yesu, Danu aika, ema ataniro emaini uruama anita. ");
INSERT INTO yrb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Eno aneda Godima i amara sadeinu ewana Yesu eno iwata ueta daba garari uiba Yesu iwawa usi. ");
INSERT INTO yrb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","18","Yesuma emaba wei, ane sina wewe anaisi wei? Weiro i amara sadeima neno siosa derawere usite ibo aika usite mui amara danu ifu Kiriofasi, dana Yesuba wei, Jerusaremu su uwara nesia i yaina kowaro kawai kewekewe utaro nono ana kamama fafate banono i ueta a iwata me wei? ");
INSERT INTO yrb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Weiro Yesuma emaba wei, ane ueta wei? Weiro weisi, Yesu Nasareta amaraba waisi. Dana Godinu bunawere we bou ueta amara. Danu buna ueta utebiro Godini emeini Dawa kobere Tisa Amara we imutebita. ");
INSERT INTO yrb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yanu dera fuyo ode sina weta uwaraini Ju yawoeta uwarama Dawa uifie weitate Romani gaemani uwaranu agero oitaro korosiro oita. ");
INSERT INTO yrb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Eno utaro yana we imusi, Dawa Isaraero uwaranu ma wiroeta amara we imusi. Dawa uina awona kowa rarogonu me sininu. ");
INSERT INTO yrb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Yanu moana Godinu sina naueta awetaboma yaba sina weitaro neno kirifu uisi. I awetaboma awona waikukuro Danu uri oeta kabesiro anitate owere fare yabai weita, Danu ofe iro ibawa me erisi. Nono tube tuberoma erisina aneru sadeima yaba weisi, Dana uyarinute me ibinu weisi weita. ");
INSERT INTO yrb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","I awetabo eno weitaba moana eme efitae durami ue anitate eritana i awetabonu weita sina enanari erita weisi. ");
INSERT INTO yrb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","I amara sadei sina eno webisiba Yesuma emaba wei, ya beforo me uwara! Godinu we bou ueta uwarama Godinu bukaro sina faiyawere owawa ue oitade aneba i sina eregou utawa utaita? ");
INSERT INTO yrb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","27","Godinu we bou ueta uwarama eno weita, Godinu Kerisoma neno oferi woufite uifite nono uyafite Danu kobere araetawere orofaro manibisu weita, Yesu eno weite Mosesini Godinu we bou ueta uwaranu bukaro ibinu sina Dawaba weita i sina emaba weda i sinanu ubi wegou ui. ");
INSERT INTO yrb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Yesuma emaba eno webina i natofo suro fafitae uta. Fafitae utaro Yesuma ema serigari uite fare anibie uina bana weisite weisi, dumu sibisuba ewado wabai aibasu weisi. Eno weisiro Yesuini emaini emanu suro anita. ");
INSERT INTO yrb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Suro ane fatate ieta ifitae yautaro Yesuma Godibai guriguri uite ieta munite ma birabiarite nata nata ui. ");
INSERT INTO yrb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Eno uina emanu diti iroaro ui. Ido kobererau uiro esite Dana Yesu iwata usi. Dawa iwata usiro Yesu emabairoma me ari ui. ");
INSERT INTO yrb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eno uiro i amara sadei emanu emanu eno weisi, dabaro araisiro Godinu bukaroma sina wenuro wa neno kobererau usinu weisi. ");
INSERT INTO yrb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Idoba i amara sadeima emanu su ekoisite iroma Jerusaremu suro owere anisi. Jerusaremu suro ane fasiro Yesuma iwata ueta uwara nesia irewenini (11) Yesunu buribi aneta uwaraini i amara sadeiba weita, yanu Dera Amara uyarinu. Dawa Fitabai farinua weita! ");
INSERT INTO yrb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Eno weitaro i amara sadeima i dabaro aneda ane eta i sina weisite Yesuma buredi ma birabiarinuro ido wa Dawa iwata uitu weisi. ");
INSERT INTO yrb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sina eno weisina Yesu Danu aikana me ari uite fare emabai inaibeda ario sina wei. ");
INSERT INTO yrb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Eno uiba i uwara nesia imumu enono utaisi we imutate iya derawere uyata. ");
INSERT INTO yrb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesuma emaba wei, aneba iya uyaraitate Na iwawa iwawa utaita? ");
INSERT INTO yrb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nanu burini ageini eawe. Ina Na. Agema Na buriawete iwata uawe. Imumuna taini damaini me. Na taini dama bobo eawe wei. ");
INSERT INTO yrb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eno weite Danu buri age iwiji awiji ema efitae mawetu ui. ");
INSERT INTO yrb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yesuma eno uiro i uwarama yaru derawere uteda iwawa utate ina imutaro Yesuma emaba wei, yabai ieta ibinu aba me wei? ");
INSERT INTO yrb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Weiro Dawaba abuna erio egi mataro i. ");
INSERT INTO yrb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ie me siniro eta. ");
INSERT INTO yrb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yesuma emaba wei, imue eawe! Aubokona yabai ibeda Mosesini i we bou ueta uwaraini Samusi bukaro Naba webita sina enanari ufisu webitara. ");
INSERT INTO yrb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","46","Ina ido usinu weite Godinu buka sina we ma boroyareda emaba eno wei, boderewere uwarama eno owawa ue oita, Godinu Kerisoma neno oferi ufite uifiro kowa rarogonu me sibiro nono uyafisu. ");
INSERT INTO yrb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Godinu wiroeta sina i orofa atata uwara nesiabai we inareibitaita. Anama danu neno neno dubena afu sabisuna Godima danu ba me ueta mubite imutawa ufisu. I sina Jerusaremu suroma aboro aboro we inareibitaita eno owawa ue oita. ");
INSERT INTO yrb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Emanu owawa ue oita enanari usinuba yana eraita. ");
INSERT INTO yrb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Godinu we bou ui enanari Danu Imumu Kotofu, yabai siaia umaro tarafisu. Ewa natofo suro ibiawero Dawa tarafite Godinu buna yaba maegou ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","51","Yesuma emaba eno weite Jerusaremu suroma Beteni suro aniro Danu buribi anita. Duburo Yesuma Danu age ramameda i uwara we ma kobererau utebiro Godima Dawa urero wo mani. ");
INSERT INTO yrb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","I uwara ido owetate yaru derawere uteda Jerusaremu suro anita. ");
INSERT INTO yrb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ane fatate ainewaure dera dubu suro anebitate Godinu ifu we ma derawere utebita. ");
INSERT INTO yrb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Boderewere eme ibawa kowaro i Sina ibebi. I Sinana Yesu Keriso, Dana Godibai ibebi. I Sinana Godi. ");
INSERT INTO yrb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","I eme ibawa kowaro i Sina Godibai ibebi. ");
INSERT INTO yrb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iro ibeda Dana nesia ubu ui. Godima weiba Yesuma i ememetu nesia Danu aika ubu uiro i ememetu nesia ema me farawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","I me ibene ibene ibetana Yesu, Danu. I me ibetana ario ari. Emema i ariobai faraitate iwata utaita. ");
INSERT INTO yrb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","I ario derawere utasute dumu garari utasuro ido me ari utasu. Dumuma i ario garari utawa utasu. ");
INSERT INTO yrb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Godima Danu fo weta amara Joni siaia uiro fari. ");
INSERT INTO yrb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Joni ido farite Yesunu arioba i ario sina webiro eme nesia naufitate Yesunu dabaro anibitae iba fari. ");
INSERT INTO yrb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Joni dawa i webie fari i ariona me. I arioba webie fari. ");
INSERT INTO yrb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","I webi ba ariona farite eme nesia ario utasu. ");
INSERT INTO yrb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dana i orofa atata ememetu nesia ubu uite nasiniro farite ibiro i orofa atata uwara nesia Dawa iwawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Dawa Danu Isaraero uwarabai farite ibiro eme faiyawere Dawa munawa utaro ya uwara ba torowa Dawa musi. ");
INSERT INTO yrb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yesunu sina naue muneta uwara Yesuma Godinu adarabu mune odite buna mairo Godinu adarabu sita. ");
INSERT INTO yrb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yesunu sina naue muneta uwarana nono danuamutuma reka muneta ari utaita. Emanu damamanu iwama ema ubu utawa, emenu unuma ema ubu utawa, emenu ofe ubu utawa, nono Godinu imuetama ema ubu uiro Godinu adarabu sita. ");
INSERT INTO yrb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","I Sinana eme sinite yabai ibeda Dana yaba neno arama derawere uteda ba sina wei. Danu araetarau ya esi. Dawa Godinu amara ubiba Dana araetawere. ");
INSERT INTO yrb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jonima Dawa erite i guruguru ubita uwaraba wei, nanu we amara ewadoni eawe wei. Nauawe eno we, nanu buribi fafisu we amara ido farinu wei. Dawa derawere, na ari me, boderewere Dawa ko ibebiro na duburo fare weya wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Dana ya nesiaba neno arama utasute ainewaure durua uteda ma kobererau utasuro merau ibinisi wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosesima Godinu tarawatu yaba mairo nono Yesu Kerisoma yaba Godinu neno arama uetaini ba sinaini mai. ");
INSERT INTO yrb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mui amarama Godi erawa uiro i Danu Amara Ubi, Godini uruama ibi Amara, Dana Godi erite yabai nesia wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Ju uwarama fuyo ode sina weta uwaraini i dera dubu su yawoeta Riwai waita uwaraini Jerusaremu suroma siaia utaro Jonibai ane fatate weita, a anaiya, weitaro Jonima bunawere wei, nana Keriso me wei. Godima Dawa siaia ufiro fafite i Ju uwara durua ufisu. Nana i amara me wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eno weiro weita, anene, ana Iraija aba anaiya weitana nana Iraija me wei. Jonima eno weiro nono weita, ana i we bou ueta amara aba anaiya? Godinu sina webasu aba me weitana nana i dera we bou ueta amarana me wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eno weiro weita, a anaiya? Wiaro naufete ane yanu ya siaia uitaro arisi uwarabai ane webero naufita weitate weita, a anu torowaba anene wasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Weitaro Jonima wei, Isaiyama naba weiya wei, nana i we bou ueta amara wei, enanari na eme ibawa orofaro eno watane, i Dera Waria Amaranu daba ma nabini ma rorowarau ue bou utebeawe watane, Isaiyama Joniba weiro Jonima i sina eno wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","I Ferosi uwarama siaia uta uwarama nono weita, nana Keriso me, Iraija me, i we bou ueta amara me wenude nono ade aneba babataito utasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Weitaro Jonima wei, nana ogoma babataito utatane wei. Yabai mui amara inaibinuro yana Dawa iwawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dana nanu buribi afiro Dawa Dera Amaraba Danu ibo nana da inare tumau wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jonima i Jodani ogo etarafu Beteni suro babataito utebina i sina nesia ido fare weita. ");
INSERT INTO yrb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Etei mui kowaro Jonima eriro Yesu farebina Jonima wei, eawe, Godinu Reka Mamoe waita amara ido farinu. Dana i orofa atata uwara nesianu neno neno ueta mubite abe sabisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","I amaraba eno we, Dana derawere. Dawa ko ibi. Na derawere me weya wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aubokona Dawa iwawa uete ya Isaraero uwara nesia Dawa iwata ufoe iba ogoma babataito utebitara wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Nono Godinu Imumu Kotofuma ubani gasira ari ureroma tararite Dawabai tare ibiro erete we imue, bodere Godima naba wei, Nanu Imumu Kotofuma mui amarabai itafiro efasuna i Amara Dana Nanu Imumu Kotofuma babataito ufisu wei, eno we imue. ");
INSERT INTO yrb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jonima eno weite wei, na ereba Dana Godinu Amara ubi demurai iba yabai watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","37","Etei mui kowaro Jonini danu iwata ueta amara sadeini uruama inaibitana Yesu fare ani. Fare anebiro Jonima wei, Godinu reka mamoe waita amara eawa weiro danu iwata ueta amara sadeima nautate Yesunu buribi anita. ");
INSERT INTO yrb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Anitaro Yesu owerite ema ereda wei, aneba araisi weiro weita, Rabai, i ifunu ubina Tisa. ");
INSERT INTO yrb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Rabai, anu su aboro weita? Weitana wei, are eawa wei. Weiro Dawaini anitate Danu su eta. Kowa mare oto serigari uite ane abanaro inarite usinuba i kowana Dawabai ibita. ");
INSERT INTO yrb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","I mui amarama Joninu sina nauite ani. I amaranu ifuna Enuduru. Dana Saimoni Fitanu dabue. ");
INSERT INTO yrb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","42","I amarama danu datae, Saimoni, doberebe atanite wei, i Mesaia Dana i Keriso, Dawa atanisi weite danu datae Yesubai woure fare odi. Odiro Yesuma Fita ereda wei, ana Joninu amara Saimoni. Aba reka ifu Sifasu maimau wei. Sifasuini Fitaini ifu demurai. I ifunu ubina kiki gebiro. ");
INSERT INTO yrb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Etei mui kowaro Yesuma Gareri orofaro anibie uite Firifi doberebe atanite wei, Nanu buribi ara wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Firifini Enuduruini Fitaini emana Besaida su uwara. ");
INSERT INTO yrb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Firifima Natania doberebe atanite wei, Mosesini tarawatu bukaini i we bou ueta uwaranu weita amara atanisi wei. Jousefanu amara Yesu Nasareta su amara atanisi wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Weiro Nataniama wei, dana Nasareta su amara wei? Iroma kobere amara da afisu weite Dana i Keriso me wei. Weiro Firifima wei, are ea wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","48","Arebitana Yesuma Natanianu areta ereda wei, eawe, ba Isaraero amara ewado, dawabai meo me weiro Nataniama wei, anene na iwata utasu wei? Weiro Yesuma wei, i boruba ana ubiro inaibainuro Firifi abai sau ane farawa usinuro Na ko a ene wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Weina Nataniama wei, Rabai Ana Godinu Amara. Ana ya Isaraero uwaranu Dera Yawoeta Amara wei. ");
INSERT INTO yrb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","51","Weiro Yesuma wei, anu boruba ana ubiro inaibeta enete weneba iba eno imutasu? Mui buna ueta derawere ewa ari me duburona derawere efasu wei. Weite nono emaba wei, Nanu ba sina nauawe wei. Duburo ure eba ufiro Godinu aneruma na, Ba Eme Sire Amarabai tarareibitate urero amutebitaro efoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kowa sadei me siniro Yesunu danua mui aweta muneta amaranu ogaroba Gareri orofa Keina suro ane yaubi. ");
INSERT INTO yrb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesuini danu iwata ueta uwaraini waya youtaro iro ane yaubita. ");
INSERT INTO yrb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","4","I ogaro itebita uwarama waini ie me sitaro Yesunu danuama Yesu Dawaba wei, wainina me sininu weiro Yesuma wei, baya aneba Nabai wenauerasu? Nanu kowa farawa oide iba durua da umau wei. ");
INSERT INTO yrb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Weiro nauite i ogaro utebita gaukara uwaraba wei, Dana sina ane webisuna enanari uawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Dera gebiro okia sikisi (6) inaibita. Kikiratuna me, yafararabo dera kasa okia ari sikisi inaibita. Ju uwarama ogo totate emanu kakara uroeta i ogoma urota. ");
INSERT INTO yrb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesuma wei, i inaibinita okia ogo adu uawe weiro enanari utaro wate fata. ");
INSERT INTO yrb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","9","Yesuma nono wei, kikiratu toawete ogaro yawoeta amaraba mawero ifi wei. Weiro enanari utaro i ogaro yawoeta amarama kikiratu i. Ie erina i ogo ido waini siniro aboroma fari dawa iwawa ui. (I ogo tota gaukara uwarama iwata uta). I ogaro yawoeta amarama ite weiro aweta muneta amara dawabai fari. ");
INSERT INTO yrb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Fariro i ogaro yawoeta amarama wei, ewa wainina kobererau wei. I ogaro saneta uwaranu baetana aika. Kobere waini botai mataitaro ie dia uraitana duburona i aramawere waini mataita wei. Anu kobere waini botai matawa usinute nono duburo masinu wei. ");
INSERT INTO yrb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","I buna uetana Yesunu botai buna ueta. I buna uetana Gareri orofa Keina suro uite Danu dera buna ma boroyariro Danu iwata ueta uwarama Dawa imuegou uta. ");
INSERT INTO yrb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yesu eno uite Keina su ekodiro Dawaini Danu danuaini Danu daburetaini Danu arumamini Danu iwata ueta uwaraini Kafenamu suro tanita. Tare fatate moana kowa iro ibita. ");
INSERT INTO yrb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Godima Isaraero uwara Ijifiroma woure aneta ogaro kowa fafie uiba Yesuma Jerusaremu suro mane fari. ");
INSERT INTO yrb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mane farite dera dubu suro amuite erina moana uwarama borumakauini mamoeini ubanini oiya ue mataro moana uwarama oi kaiyobai yautate oi moko mae matanebitaro eri. ");
INSERT INTO yrb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Erite na munite egi ureta na ari uwanite i uwaraini egini yoweriro wawaro itata. I oi moko mata uwaranu kaiyo ma regari uiro oi fitata ui. ");
INSERT INTO yrb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Eno uteda i ubani oiya mata uwaraba wei, ewa nesia woure aniawe wei. Nanu Babanu suro sitowa su ari da uawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Eno uiba Danu iwata ueta uwarama imuta. Godinu bukaro i sina eno ibinu, Godinu su imuegou utataneba uimau, i sina eno ibiba iba eno imuta. ");
INSERT INTO yrb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","I Ju uwarama Yesuba weita, ane buna ueta ufaro ereda Ana Dera Amaraba iba ewa gaukara eno usinu iwata ufeisi weita? ");
INSERT INTO yrb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Weitaro Yesuma wei, ewa dera dubu su ma jugari uforo nono kowa rarogonuro nono ubu umau wei. ");
INSERT INTO yrb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Weiro weita, ewa dera dubu su oya foti sikisi (46) ubu utedibebita nono anu aikana i kowa rarogonuro ubu ufae wasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Eno wei ina Yesuma Danu ofe ububa wei. ");
INSERT INTO yrb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Duburo uietaroma uyariro Danu iwata ueta uwarama Danu wei sina imutate i sinaini Godinu bukaini naue imue uta. ");
INSERT INTO yrb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesuma Godima Isaraero uwara Ijifiroma woure aneta ogaro kowaro Jerusaremu suro ibebiba moana uwarama Danu buna ueta etate Dana Godinu Amara naue imue uta. ");
INSERT INTO yrb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesuma emanu imueta iwata uiba iba emanu agero Danu torowa odawa ui. ");
INSERT INTO yrb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Eme nesianu neno iwata uiba mui amarama Dawabai emenu imueta aika maika wiawa ui. ");
INSERT INTO yrb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","I Ferosi uwaranu tarawatu yawoeta amara danu ifuna Nikodimasi Dawa Ju uwaranu kanisoro amara. ");
INSERT INTO yrb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dawa dumuro Yesubai are farite wei, Rabai, Ana Godibairoma farite Danu sina wasuba ya iwata utaisi wei. Godima A siaia uiba fare ewaro buna ueta utasuba Ana Godibairoma fari ya iwata utaisia wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Weiro Yesuma wei, aba ba sina wemaro naua wei. Anama reka danuama muneta ari da ufisuna Godinu kobere yawotasu orofa da efisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Weiro Nikodimasima wei, Dera Amara, anene reka danuama muneta ari ufisu weite wei, anene kikiratu sibite danu danuanu desini ubarero amufiro danu danuama dawa nono mubisu wei? ");
INSERT INTO yrb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Weiro Yesuma wei, aba ba sina wemaro naua wei. Anama ogoini Godinu Imumu Kotofuma reka muneta ari da ufisuna Godinu yawotasu orofaro da anibisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Weite wei, danuama kuita mubiro itafite eme sibisu wei. Nono Godinu Imumu Kotofuma reka mubiro Danu Imumu mubite wiroeta reka ureroma mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Reka danuama muneta ari mubisu weneba imueta kirifu da ufaro wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Oyauma danu torowa fare anasuro danu rurua nautasute danu are aneta daba iwawa utasu, enanari Godinu Imumu Kotofuma mui amara reka munasuro iwawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Weiro Nikodimasima wei, ewa anene wei? ");
INSERT INTO yrb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","11","Weiro Yesuma wei, aba ba sina wemaro naua wei. Ana Isaraero uwaranu mui tisa amara. Aneba iwawa utasu wei? Yanu eretaini imueta ibaiabaini aba waisiro munawaba iwawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ewa nasininu imueta aba wenero iwawa usinuba urenu imueta aba wemaro anene iwata ufasu wei? ");
INSERT INTO yrb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","14","Mui amarama urero manawa ui. Na, i Ba Eme Sire Amara iro ibebe nasiniro tarare wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mosesima towi eme ibawa orofaro isuro aiyo odiro ana anama kimuwere imuteda etate uitawa uta, enanari i Ba Eme Sire Amara, Na, korosiro odifitaro anama danu naueta Nabai odifisuna urero me ibene ibene mubite ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Godima i orofa atata uwara nesia neno arama derawere uite Danu Amara ubi yabai maiba anama danu naueta Dawabai odifite dawa me sara da uifite urero me ibene ibene ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Godima Danu Amarana uwara fanisi mafie siaia utawa uite nono i uwara nesia Dawabai wirofitae iba siaia uiro fari wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Anama Danu naueta Yesu Kerisobai odasuna Godima dawaba koto da ufiro me sara da uifisu Godima eno wei. Anama danu naueta Yesu Kerisobai odawa utasuna Godima dawa koto daido uite uieta afu mune odiba dawana me sara uifisu. Godinu Amara ubi imutawa utasuba me sara uifisu, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Aneba eno koto ufisu? I orofa atata uwara nesiabai ario derawere fariro i uwara unutawa ario fareta. Emanu ueta sineta siosawereba iba emanu ununa dumu iba koto ufisu. ");
INSERT INTO yrb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","I siosa ueta utaita uwara ema unutawa ario. Emanu siosa ueta ario uosote ma boroyaosoba i ario unutawa utaita. ");
INSERT INTO yrb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","I kobere ueta utasu amarama i arioba iyarawa utasu. I arioro arasuba eme nesia eraitate Godima dawa durua utasuba eno utasua we imutaita, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesuma eno weiro Dawaini Danu iwata ueta uwaraini Judia orofaro anitate ibitaro uwara emabai fatate babataito uta. ");
INSERT INTO yrb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","I kowaro Jonima eme babataito utebi. Dera ogo Enoni suro Seiramu subai ibiba uwara faiyawere Jonibai fataro ema babataito utebi. ");
INSERT INTO yrb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Joni dibura suro odawa me ibebi i odoro uwara babataito utebi. ");
INSERT INTO yrb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","26","Joninu buribi aneta uwaraini mui Ju amaraini emanu babataito aikaba iba yaranebitaro Joninu uwara dawabai fatate weita, Rabai, i Jodani etarafu yabai ibi amara, anu sina wei amara, imutasu? Eme nesia i amarabai faraitate babataito utaita weita. ");
INSERT INTO yrb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Weitaro Jonima wei, i urero ibinu Godima i gaukara masinuba iba eno utasu, Godima da mafisuna uwara nesia eno da ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nana Keriso me wero nauta wei. Na ko siaia uiro farero Dawa nanu buribi fari wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","I reka aweta bobo amara reka aweta muneta amara waitaro i reka aweta danu awerabai anasu i ari Yesunu uwara Dawabai anaita. Reka aweta muneta amarama wasuro danu domaya nauteda yaru utasu, enanari, Yesunu sina nauteda na yaru utatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dana derawere sibiro nana kikiratu simau wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Danu kabesi ureroba Dawana derawerero eme ari me. I nasiniro ibinita uwarama nasini ibaiabai torowa waita. I ureroma fari amara, Dawa derawere. ");
INSERT INTO yrb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Danu eretaini ueta nesia wasuro naue imutawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Anama Yesunu sinana ba we imutasuna Godi Dawana ba we imuteda iba eno wasu. ");
INSERT INTO yrb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Godinu siaia uiro fari Amarama Godinu sina wasuro Godima Dawabai Danu Imumu Kotofu maegou utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Godinu neno Danu Amarabai ibinuba Godima ane ane nesia Yesunu age duro odi wei. ");
INSERT INTO yrb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Anama Godinu Amarabai danu naueta odasute me ibene ibene ibeta munasu. Anama Godinu Amaranu sina da naufisuna i ibene ibene ibeta orofa da efisuba dawabai Godinu ibo ueta daido ibeibisu Jonima wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Uwara faiyawere Yesubai babataito utaro uwara faiya me Jonibai babataito uta weitaro i Ferosi uwara nauta. ");
INSERT INTO yrb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Yesuma i uwara babataito utawa uiro Danu iwata ueta uwarama deina ba i uwara babataito utebita). ");
INSERT INTO yrb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","I Dera Amara Yesuma i Ferosi uwaranu imueta iwata uite Judia orofa ekodite owerite nono Gareri orofaro ani. ");
INSERT INTO yrb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Danu ani dabana Samaria orofa abanaro amune ture fare ani. ");
INSERT INTO yrb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesuma ane Samaria orofa suro fari. I su ifuna Saika. I suna yanu sirorari amara Jeikofuma danu amara Jousefaba bodere mai nasini gigiraribai. ");
INSERT INTO yrb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jeikofunu dauri ogo koto i nasiniro ibi. Kowa mare otoro reka fare serigari uiro Yesuma i ogo kotobai farite daba yafawere arebe ofe arama uiba yaubi. ");
INSERT INTO yrb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mui Samaria su aweta ogo tofie fariro Yesuma wei, ogo toate mairo Na ima wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Yesunu uwarana iro Dawaini yaubawa. Samaria suro ieta oiya ufitae anita. Yesu Danu aikaratu yaubebe i sina wei.) ");
INSERT INTO yrb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Eno weiro i awetama wei, ana Ju amara. Aneba na Samaria su awetabai sina wasu wei? Aneba naba ogo mai ima wasu wei? Ju uwarama Samaria uwaraba sina wiawa utebaitaro nono aneba a naini sina webae wasu wei? ");
INSERT INTO yrb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Weiro Yesuma wei, Godinu me maetaini i ogo mai ima watane amaraini a iwata ufarona nabai webaro aba i me ibene ibene ibeta ogo ari aba mamaro ifae wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Eno weiro i awetama wei, abai ogo toretana me. Ewa ogo nasini ubare nubowere ibinuba me ibene ibene ibeta ogo ari aboro tofasu wei? ");
INSERT INTO yrb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yanu baba Jeikofu, dawaini danu adarabuini danu borumakauini emana ewa ogo itaro i ogo koto yaba mai. Dawa kikiratu A derawere eno imutasu wei? ");
INSERT INTO yrb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Weiro Yesuma wei, ana anama ewa ogo ifitaitana nono ogo nodo ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ana anama Nanu mamau ogo ifitaitana nono ogo nodo da ufitaita. Nanu mamau ogo gebiroro amutasu ubi erio ari, da yaraifisu. Enanari i ogo emanu nenoro ubi erio ari amufisu. I ogona me ibene ibene ibeta ariba da yaraifisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Weiro i awetama wei, Dera Amara, i ogo mai imaro ogo nodo da ufiro ewa ogo are da toreimau wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","17","Eno weiro Yesuma wei, aniate anu awera woure ara weina na awera me wei. Eno weiba Yesuma wei, ba wasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Awera fai (5) munite ekodite awona anu suro aini ibinu amara anu awera meba iba ba wenu wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","20","Eno weiba i awetama dawaba wei, Dera Amara, Ana Godinu we bou ueta Amara weite wei, yanu Samaria babamutu etei maidaniro guriguri utebita. Ya Ju uwarama Jerusaremu suro torowa guriguri uforo waita wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Weiro Yesuma wei, aweta, Nanu sina nauegou ua wei. Mui kowa fafiro etei maidaniro o Jerusaremu suro Bababai guriguri da ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ya Samaria uwara Godi iwawa utaitaba iba Godi ba guriguri utawa utaita. Ya Ju uwarama Godi iwata utaisi. Danu ma wiroeta Amara Ju uwarabairoma fariba iba Godi ba guriguri utaisi wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Reka kowa farinuba i Godi ba guriguri utaita uwarama Godi nenoma guriguri utaitana ina ba guriguri ueta idoni. Godi Danu unu i nenoma imue guriguri ueta uwara wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Godina kobere Imumuba ya erawa utaisiba iba Dawa yanu nenoroma guriguri utaisina ba guriguri utaisi wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yesuma eno weiro i awetama dawaba wei, i Mesaia fafisu weitaro naue wei. Danu mui ifuna Keriso. Dawa fafite nesia ma boroyafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Weina Yesuma wei, I Mesaiana Na ewado wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesuma eno webina Danu iwata ueta uwara fatate etana Yesuini i awetaini sina we matanebisiro etate neno kirifu utate ya sina ane waisi we imuteda nono ya sina ane waisi wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","30","I awetama danu okia ekodite owerite suro ani. Ane farite su uwaraba wei, mui amarama nabai farinute nanu ueta sineta nesia wenuba Dana Keriso aba me, arawete eawe weiro i su uwara ido anita. ");
INSERT INTO yrb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","32","I aweta eno utebina Yesunu iwata ueta uwarama Yesu Dawaba weita, Rabai, ieta ia weitana wei, Nanu ieta aika iba ya iwawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","34","Weiro weita, mui amarama ieta Dawaba masinuro isinu aba, eno we matataro Yesuma wei, Nanu ietana Godinu imuetaini gaukaraini Danu mai gaukara ue me simau, ina Nanu ieta ari wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yesu eno weite wei, ya eno waita, sakara fo (4) me sibiro yanu beataro ieta ibaiabai daufeisi waitaro nono Nana yaba eno watane, i eme nesia eawe, emanu nenona ba sineta ieta ariba i daureta kowa ido farinu watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Anama daure fira fara utasuna moko muneta munasuro danu muneta uwarama me ibene ibene ibeta munaitaba iba i waieta uwaraini i daure fira fara ueta uwaraini yaru utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","I bodere ikiki sinana ba. I sinana eno, mui amarama waitasuro mui amarama daurasu, i sina eno wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yesuma ewana kasei sina weda eno wei, yanu yo waitawa uta ememetu daufoe siaia ue wei. Aika uwarama yo waie me sitaro yana emanu waieta ememetu dauraitaba iba emaini yaini i gaukara uruama utaita wei. I sinanu ubina eno, moana uwarama Godinu sina we inaraitaro moana uwarama buribi areda i uwara mune Godibai odaitana emana gaukara uruama utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","I awetama suro anite wei, mui amarama nanu bodere ueta sineta nesia wenu weiba moana su uwarama emanu imueta nesia Yesubai oita. ");
INSERT INTO yrb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","42","I Samaria uwarama Yesubai fatate bana weitaro emabai kowa sadei ibeda Yesuma ema we mawetu utebina i su uwara faiyawere emanu naueta Yesubai oitate i awetaba weita, ana i amaranu buna uetaini weta yaba weiro nausi weita. Nono Danu wenu sina nauegou utaisite Dana i orofa atata uwaranu ma wiroeta Amara iwata utaisiba iba nauegou utaisi weita. ");
INSERT INTO yrb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kowa sadei me siniro wai uriro uyarite Gareri orofaro ani. ");
INSERT INTO yrb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Auboko Yesuma wei, Godinu we bou ueta amaranu su uwarama dawa kakara utawa utaitate iba eno we imutaita, dawa dera amara me we imutaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ane Gareri orofaro fariro i Gareri uwarama yaru utate ario derawere weita. I Gareri uwarama Jerusaremu suro Godima Isaraero uwara Ijifiroma woure aneta ogaro anitate Yesunu ueta nesia etate iba nono yaru uta. ");
INSERT INTO yrb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Yesuma ane Gareri orofa Keina suro fari. Bodere i Keina suro Yesuma ogoma waini ui. Yesu iro fariro Yesu Judiaroma Keina suro farinu weitaro mui Kafenamu gaemani amara naui. I Kafenamu gaemani amaranu amararatu ofe derawere wourite uifie utebiba Yesubai are farite wei, arate nanu amararatu ma wiroa nui wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Weiro Yesuma wei, buna uetaini eretaini efasuna imufate da efasuna da imufasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Weina nui wei, Dera Waria Amara ara, nanu amara uifisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Weiro Yesuma dawaba wei, ania, anu amara wirosinuba ibifisu weina Danu sina kimuwere naue imuteda ani. ");
INSERT INTO yrb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","I ami amara owerite tanebina danu gaukara uwara dabaro marebe dawa atatate weita, anu amara merau ibinua weita. ");
INSERT INTO yrb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Weitaro wei, abo kowaro wirosinu weiro weita, arena kowa oto serigari uite kikiratu ani i odona ofe wakiki me siniro wiroi weita. ");
INSERT INTO yrb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Eno weitaba danu damama we imui, arena i kowaro Yesuma anu amara wirosinu weiba iba wiroi we imuiba dawaini danu su uwara nesia emanu naueta Yesubai oita. ");
INSERT INTO yrb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesuma Judiaroma Gareriro farite ewa buna uetaini mui buna uetaini i buna ueta sadei ui. ");
INSERT INTO yrb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mui kowaro Yesuma Ju uwaranu mui ogaro ietaba Jerusaremu suro mani. ");
INSERT INTO yrb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","I Jerusaremu suro mamoenu fare aneta bebeto gigiraribai mesauratu ibi. Ju uwarama emanu sinaroma Beseda webita. Ofada fai (5) i mesau ode kara utaro ubita. ");
INSERT INTO yrb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Oferi aika maika woureta uwara faiyawere i ofadaro ainibebita. Moanana buri anawa uwara, moanana buri bebeuwere aneta uwara, moanana diti basugari uwara, moanana buri age bedada buwere uwara. (I uwarama ogo taritari ufie yawotebita. ");
INSERT INTO yrb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mui kowa kowaro aneruma ogoro itareda ogo ma taritari utebina i botai ogoro itarebi amarama wirotebi). ");
INSERT INTO yrb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nono mui amarana oya toti eita (38) oferi woureda me ainibebi. ");
INSERT INTO yrb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","7","Dawa eno ainibebiro Yesuma farite ereda wei, dawa kowa faiyawere ainibebasua we imuite wei, anu ununa wiroeta wei? Weiro i oferi wourebi amarama wei, Dera Waria Amara, ogo taritari utebasuna na ogoro woure tare oeta amara meba mui amara dawa ko itarebasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","10","Weiro Yesuma wei, uyate anu wia muate ania weina i amara ido wiroiba uyarite danu wia munite ani. Danu aneta kowana sabate kowaba moana Ju uwarama dawa etate weita, awonana sabate kowa. Anu wia da woufate anibasu. Yanu tarawatuba kodia weita. ");
INSERT INTO yrb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Weitaro i amarama wei, i Amarama na ma wirosinute wenu, anu wia muate ania wenu wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","13","Eno weiro weita, anama aba anu wia muate ania wenu, weitana dawa iwata me. Yesuma i guruguru ubita uwaranu ubarero aniba i amara Yesu erawa uite iwawa ui. ");
INSERT INTO yrb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Duburo Yesuma i Dana ma wiroi amara dera dubu suro atanite wei, Nanu sina naua wei. Awona a wirosinuba nono duburo siosa ueta da ufaro ufasuna i wouri oferi ari mui oferi deranono wouosoa wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Weiro i amara Yesu kodite, i Ju uwarabai anite wei, Yesuma na ma wirosinu wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Weiro nautate Yesu sabate kowa ma siosa usinu we imutate Yesuba ibo uta. ");
INSERT INTO yrb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Eno utaro Yesuma emaba wei, Nanu Baba kobere gaukara utebasuba Nana kobere gaukara utebatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu eno weiba ubusi uyatate Yesu ma uifitae uta. Yesuma sabate kowa imutawa uite wei, Godina Nanu Baba weiba Godini Dawaini weda we ma arotorowa uiba iba ubusi uyata. ");
INSERT INTO yrb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesuma emaba wei, Nanu ba sina wemaro nauawe wei. Godinu Amara Danu aika Danu imuetama gaukara utawa utasu wei. Danu Damamanu gaukara erasute utasu. Godima ane ane utasuro Danu Amarama enanari utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Godinu neno Danu Amarabai ibinuba Danu gaukara nesia Danu Amarabai ibinuba Danu gaukara nesia Danu Amarabai mawetu utasu wei. Nono duburo mui buna ueta i bodere ueta ari me, buna ueta derawere Dawabai mawetu ufiro neno kirifu ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Godima uieta uwara ma uyarasuro me ibaita enanari Danu Amarama ana anaba me ibeta matasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Godima uwara koto utawa utasute i gaukara Danu Amaraba masinuro utasuba eme nesia Godi Dawa we ma kobererau uteda waitana enanari Yesu we ma kobererau uteda webitaita wei. Anama Danu Amara we ma kobererau utawa utasu enanari Danu Damama we ma kobererau utawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nanu ba sina wemaro nauawe wei. Ana anama Nanu sina nautaitate Na siaia ui Godi imutaitate me ibene ibene ibeta munaita. Munaitaba Godinu kotobai anawa utaitaba uieta serigari utaitate me ibene ibene ibaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nanu ba sina wemaro nauawe wei, i kowa farinuba i reka wiroetana me, emana uieta uwara ari, ema Godinu Amaranu sina naufitate i reka wiroeta mubitate wiroeta me ibene ibene ibifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Godima me ibene ibene ibeta Imumuba Danu Amara mairo iba Danu Amarana me ibene ibene ibeta Amara. ");
INSERT INTO yrb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Godinu Amarana Ba Eme Sini Amaraba Godima Dawa buna maiba eme nesia koto utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Nanu sinaba neno kirifu da uawe wei. Mui kowa fafiro i uieta uwara nesia Danu sina naufitate uyafitate Danu kotobai fafitaro i kobere ueta uwarama me ibene ibene ibifitaro i siosa ueta uwarama i fanisi orofaro anibitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nanu imuetama utawa utatanero Godima Danu buna matasute wasuro nautatanete koto utatane wei. Nanu imueta kodatanete Godinu imueta dobere ereda utataneba iba koto rorowarau utatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nana Nanu sina wemauna Danu sina ba me weboita, weite wei, nono Nanu Babama Nabai wasu i sinana ba wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","33","Yanu uwara Jonibai siaia utaro Jonibai fataro Nanu sina ba weiro nauta. Nautate owetate yabai fatate weitaro nauta Yesuma wei. Joninu sinana emenu sina. ");
INSERT INTO yrb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jonima Naba wasuna ina idorogo nono Nanu torowa i sina wataneba ya nesia Na naue imue ufote wirofoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yesuma nono wei, Joni dana nanefa ario ari uiba danu arioro inaibeda danu sina kowa faiya me nautate yaru uta. ");
INSERT INTO yrb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jonima i sina weda Na ma boroyariro danu ma boroyaretana derawere me. Awonana Nanu ma boroyaretana derawere ibinu. I ma boroyaretana Nanu buna ueta. Ima Na ma boroyaregou utasuro emema ereda Godima Na siaia ui iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Godima Na siaia uite Nanu gaukara kobererau wei. Yana Godinu wate tanana nautawa utaitate Dawa erawa utaita. ");
INSERT INTO yrb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Danu siaia uiro ewaro tarari Amara imutawa utaitaba Godinu sina yanu nenoro ibawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yana Godinu buka eregou utaita. I bukaroma ere me ibene ibene ibeta muboe imutaitana i bukaro sinama Na yanu wiroeta Amara wasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Na imutawa utaitate Nabai yanu wiroeta fare munawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Emema Naba kobere sina waitana Na unutawa i sina weta. ");
INSERT INTO yrb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yanu neno Godibai ibawa utaitaro Na iwata utatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Godinu ifuro yabai farero Na munawa utaita. Duburo mui amarama danu aika ifuro yabai fafisuna dawa muboita wei. ");
INSERT INTO yrb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yanu ununa emema ya kobere uwara webitae utaitate nono Godima ya kobere uwara weta ya unutawa utaitaba iba Godi imutawa utaita. ");
INSERT INTO yrb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yanu imuetana eno imutaita, Dawa Godibai ya wawei webisu. Nana yaba eno wawei da wemau. Yana Mosesinu tarawatu imuegou utaitaba ima ya wawei webisu. ");
INSERT INTO yrb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosesinu tarawatu imutaitana ina Na imutaitaba Mosesi Naba bukaro owawa ue odi. ");
INSERT INTO yrb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Danu owawaro sina ereda da naue imue ufoitana anene Nanu sina naue imue ufoita, Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Duburo Yesuma Gareri mesau yofere ani. I mesaunu mui ifuna Taibiriasi waita. ");
INSERT INTO yrb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yesu ido yofere aniro uwara faiyawere Danu buribi anita. I uwarama Yesunu bunama ofe aika maika ma wirotebiro etaba Danu buribi anita. ");
INSERT INTO yrb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesuma i mesau yofere ane amuite Danu iwata ueta uwara maidaniro woure mani. Maidaniro manebe mane yaubita. ");
INSERT INTO yrb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Godima Isaraero uwara Ijifiroma woure aneta ogaro kowa ido fafie uiba iba eme faiyawere Danu buribi manita. ");
INSERT INTO yrb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Manitaro Yesuma Danu ditima ere ane are uite i eme fefera ereda Firifiba wei, ieta anene oiya ufero i uwara nesia ieta ifitaita wei? ");
INSERT INTO yrb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yesu Dawa iwataro nono Firifi me woure ereda iba eno wei). ");
INSERT INTO yrb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Eno weiro Firifima wei, tueniti kinana (K20) aido me. Ima ieta oiya ufeisina ewa uwara nesia ifitaro aido da sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Weiro Saimoni Fitanu dabue, Enuduruma Yesuba wei, buredi faini (5) erio egi sadeiratuini mui amararatubai ibinua wei. Ibinurogo ina ieta derawere meba anene uwara faiyawere ieta ifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","11","Weiro Yesuma wei, i uwara wiawero kabesi demurairo yaufita wei. I kabesina samarai bobo kabesiba i uwara eme torowa fai tausani (5,000) yautaro Yesuma i buredini erio egini munite Godiba guriguri uteda we ma kobererau uteda ma birabiarite nata nata uiro itaro dia uri. ");
INSERT INTO yrb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ie me sitaro Yesuma Danu iwata ueta uwaraba wei, iwo muduna nesia fira uawero me sara da ibifi wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Weiro buredi iwo muduna mutate bosio youtaro bosio tuero (12) wate fata. ");
INSERT INTO yrb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","I ieta ita uwarama i buna ueta etate weita, i amara, Dawana Godinu we bou uite fafisu wei amara idoni weita. ");
INSERT INTO yrb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu Dawa iwata i uwarama Dawa agema mubitate emanu dera yawoeta amara ma uyafitae imutaba ema ekodite maidaniro mani. ");
INSERT INTO yrb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yawiro Yesunu iwata ueta uwarama mesauro tanitate Yesu yawota. ");
INSERT INTO yrb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Yawotebitana yawi siniro ekoitate boutiro amutate Kafenamu suro yofere anita. Anebitana dumu siniro Yesu daido farawa ui. ");
INSERT INTO yrb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Anebitana oyau derawere fariro ufe derawere uyari. ");
INSERT INTO yrb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","20","Jawe ure ogo abanaro anebitaro Yesu ogo deiro inarebiro eta. Etaro emabai fafie uina iya derawere uyataro Yesuma wei, ewana Na, iya da uyawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Weiro i uwarama yaru uteda Yesu durua utaro boutiro amui. Amuiro ido emanu unu orofaro daido me ari utate sau fata. ");
INSERT INTO yrb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wai uriro i mesau etarafu uwarama Yesu efitae guruguru utate yawota. Yesuini Danu iwata ueta uwaraini emanu guruguru ueta kabesi arena fatana bouti demurai ibiro eta. Nono Yesunu iwata ueta uwarama Dawa koitate emanu aika boutiro ane yofeta. I uwarama ina iwata utaba iba Yesu yawotebita. ");
INSERT INTO yrb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Moana bouti Taibiriasi orofaroma ieta ita kabesiro fare inata. ");
INSERT INTO yrb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","I uwarama Yesuini Danu iwata ueta uwaraini etana meba ekoitate i bouti nesiaro amutate Kafenamu suro Yesu dobere yofeta. ");
INSERT INTO yrb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","I uwarama mesau etarafu yofetate amutate Yesu doberebe atatate weita, Rabai, abododo ewado fari weita? ");
INSERT INTO yrb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Weitaro Yesuma wei, Nanu ba sina wemaro nauawe wei. Nanu buna ueta imutawa utaitate nono buredini erio egini ie me sitaba iba Nabai ibifoe utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yanu nasini ibeta gaukara yajara ieta ari ina da uegou uforo wei. Nono i me ibene ibene ibeta ieta ari ina kobere gaukara uegou uawe wei. Godima Danu imueta Na, Ba Eme Sire Amarabai odiba Nana i me ibene ibene ibeta matatane, Yesuma eno wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","I uwarama Yesuba weita, anene Godinu gaukara ufero Godima ina kobererau webisu weita? ");
INSERT INTO yrb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Weitaro Yesuma wei, Godinu yabai siaia ui Amara imutaitana ina Godinu gaukara wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","I uwarama Yesuba weita, ane buna ueta ufaro efete A naue imue ufeisi weita? Ane gaukara ufasu? ");
INSERT INTO yrb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yanu babamutuma eme ibawa orofaro inareda ieta danu ifuna mana itebita. Godinu bukaro eno odi. Dana emaba ureroma itari ieta mairo ita, i bukaro eno ibinu weita. ");
INSERT INTO yrb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Weitaro Yesuma wei, Nanu ba sina nauawe wei. Mosesima ureroma itari ieta matawa uiro Godima i urero ieta mai wei. Nanu Babama i ba ieta ureroma matasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Godinu ieta ureroma tararasuba i orofa atata uwarama ina ifitate me ibene ibene ibifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Weina Dera Waria Amara, i ieta yaba matebea weita. ");
INSERT INTO yrb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","36","Yesuma emaba wei, Nana yanu me ibene ibene ibeta ieta. Ana anama Nabai fafitaitana i uwara osi da ufitaita wei. Ana anama Na imufitaitana ogo nodo da ufitaita, eno Yesuma weite wei, auboko Na yaba wene, yana Na eraitate imutawa utaita wene wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nanu Babama moana uwara Naba matasuba i uwara nesia Nabai fafitaitana da we yowemau wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na ureroma Nanu unu umane tararawa. Godinu unu umane tarare. ");
INSERT INTO yrb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Godima Na siaia uiro Danu unu umane iba tarare wei. Godinu ununa eno, Danu Naba matasu uwara da we ma feamate i uwara nesia i dubu kowaro we ma uyamaro me ibene ibene ibifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nanu urero ibinu Baba Danu ununa eno, ana anama Danu Amara efitate emanu naueta Dawabai odifitaitana me ibene ibene ibeta mubitaro i dubu kowaro ema we ma uyamau wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","Yesuma wei, Nana i ureroma tarari ieta weiba iba i Ju uwarama kamena weda weita Dawana Yesu, Jousefanu amara. Danu danuaini damamaini ya iwata. Anene wasu, Na ureroma tarane wasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Weitaro Yesuma wei, yanu torowa kamena da wiawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Eme me sara Nabai da fafitaro Nanu Na siaia ui Godima ema we ma youfisuna Nabai fafitaro i dubu kowaro ema we ma uyamau wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","I we bou ueta uwarama eno owawa ue oita, Godima ema nesia we mawetu ufisu eno owawa ue oita. Ana anama Godi naufitate iwata ufitate Nabai fafitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Eme nesia Godi erawaro i Godibairoma tarari Amara Danu torowa Godi eri wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nanu ba sina wemaro nauawe wei, ana anama emanu naueta Nabai odaitana me ibene ibene ibeta munaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nana i me ibene ibene ibeta ieta wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yanu yamamamutuma eme ibawa orofaro ieta danu ifuna mana itebitate uitebita wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","I me ibene ibene ieta ureroma tarariba mui amarama ifisuna da uifisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Anama i ieta ifisuna me ibene ibene ibifisu wei. I ieta matataneba i orofa atata uwara nesia ifitate me ibene ibene ibifitaita, i ietana Nanu ofe wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesuma eno weiro nautate emanu emanu weitate weita, i amara anene danu ofe mafiro yana ifene wasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Weitaro Yesuma emaba wei, Nanu ba sina wemaro nauawe wei. I Ba Eme Sini Amaranu ofeini iwaini da ifoitana me ibene ibene ibeta yabai me wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Anama Nanu ofeini iwaini ifisuna me ibene ibene ibeta dawabai ibifisuba i dubu kowaro dawa we ma uyamau wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nanu ofena ba ieta. Nanu iwana ba ogo wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Anama Nanu ofeini iwaini ifisuna dawaini Naini ibifutu wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Eno weite wei, i me ibetanu ubina Baba Godiba iba Nana me ibine, enanari anama Nanu ofe ifite me ibene ibene ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ewa ietana i ureroma tarari ieta. Yanu yamamamutuma mana ieta itate uita, i mana ietana aika. Anama ewa ieta ifisuna me ibene ibene ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuma Kafenamu suro ibeda i Ju uwaranu dubu su ubarero i sina we mawetu utebi. ");
INSERT INTO yrb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Moana iwata ueta uwarama i sina nautate weita, ewa sina kimuwere anama nautasuro wasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Weitaro Yesuma emanu emanu webita sina iwataba emaba wei, i sinaba Naini ibo uteda waita wei? ");
INSERT INTO yrb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","I Ba Eme Sini Amarama Danu bodere ibebi orofaro maneibisuna yana efote nono ya anene imufoita wei? ");
INSERT INTO yrb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Godinu Imumu Kotofuma me ibene ibene ibeta matasuro ba ofema me ibene ibene ibeta matawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yaba eno watanero moana uwara imutawa utaita wei. (Yesuma bodereroma i nautawa uwara iwata uite Danu wawei weta amara Dawa iwata ui). ");
INSERT INTO yrb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesuma wei, iba wene, Nanu Babama ana ana da we mubisuna Nabai da fafitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesunu buribi aneta uwara faiyawerema i sina nautate Yesu ekoitate owetate emanu unu daba enanari anita. ");
INSERT INTO yrb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Anitaro Yesuma Danu iwata ueta uwara tueroba (12) wei, ya enanari Na ekodifote yanu unu dabaro aniboita, wei? ");
INSERT INTO yrb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Weiro Saimoni Fitama wei, Dera Waria Amara, abo amarabai anibeisi wei? Abai torowa me ibene ibene ibeta ibinuba imutaisite Ana Godinu Kakarawere Amara we imutaisi wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Weiro Yesuma emaba wei, ya uwara tuero (12) Nana we mune odero nono mui amara dawana seitani wei. ");
INSERT INTO yrb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesuma Saimoni Isikariotinu amara Judasiba wei. Judasi dawa mui tuero (12) iwata ueta amara. Judasima Yesu do mafisu amara. ");
INSERT INTO yrb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesuma i sina weite Kafenamu su ekodite Gareri orofa aboro aboro me inarebi. Dawa unutawa Judia orofaro aneta. I Ju uwaranu dera uwarama Danu uieta daba doberebitaba iba iro anawa ui. ");
INSERT INTO yrb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","I Ju uwaranu su kikiratu ue ieta daure ogaro ueta kowa ido fafie uiba Yesunu daburetama Dawaba weita, i Judia orofaro ogaro aniate buna ueta uaro anu buribi aneta uwara efita weita. ");
INSERT INTO yrb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Anama emema danu ueta efitae utasute kiwuma utawa utebasute eme nesiabai utebasu weita. ");
INSERT INTO yrb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Danu dabureta emanu naueta Dawabai odawaba iba eno weita.) ");
INSERT INTO yrb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Weitaro Yesuma emaba wei, Nanu buna ueta umau kowa farawaro yanu ueta utaita kowa ainewaure ido ibinu wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","I orofa atata uwarama yaba neno ka utawa utaita. I uwaranu siosa uetaba wataneba Naba neno ka utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yanu torowa i ogaro aniboro Nanu kowa farawa uegou uiba Na awona iro da animau wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Eno weite Yesu Dawa Gareriro ibi. ");
INSERT INTO yrb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","11","Duburo Yesunu daburetama ogaroba anitaro Yesuma kiwuma ogaroro aniro emema Dawa erawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","I Ju uwarama i ogaro kabesiro Yesu doberebe weita, Dawa aboro weitana uwara faiyawere Dawaba kekerama gimumutaroma weita. Moana uwarama weita, Dawa kobere amara, weitaro moanama weita, Dana i uwara irutasu weita. ");
INSERT INTO yrb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","I Ju dera uwaraba iyatate iba gimumutaroma webita. ");
INSERT INTO yrb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","I ogaro kowa rarogonu me siniro Yesuma i Ju uwaranu dera dubu suro amuite we mawetu ui. ");
INSERT INTO yrb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","We mawetu utebiro i Ju uwarama nautate neno kirifu uteda weita, i Amara sikuru utawa ui rairo Danu iwata aboro muninu weita? ");
INSERT INTO yrb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Weitaro Yesuma emaba wei, Nanu imueta wiawa utatanete Na siaia ui Godinu imueta watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Anama Godinu unu uegou ufisuna dawa eno iwata ufisu, Nana Godinu imueta watane o Nanu imueta watane, dawa iwata ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Anama danu imuetaroma webasuna emenu we ma kobererau ueta mubie iba webasu. Anama dawa siaia ui Godi we ma kobererau ufitae utasuna i amarana kobererauro dawabai meo mero ba amara wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bodere Mosesima danu tarawatu yaba mai. Nono i tarawatu yana imutawa utaitade aneba Na ma uifoe utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Weiro i uwarama weita, Ana seitaninu mui imumu siosa bobo amaraba ana gogore bobo weita. Anama A ma uifisu weita? ");
INSERT INTO yrb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Weitaro Yesuma emaba wei, sabate kowaro i ofe wouri amara demurai ma wiroeba iba ya neno kirifu utaita. ");
INSERT INTO yrb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesima yanu ofe tureta mai. (Mosesibairoma me, ina yanu babamutubairoma fari) Emabairoma fariba sabate kowaro mui amakanunu ofe turaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Eno utaitana Mosesinu tarawatu imutaitate nono Godinu sabate kowa imutawa utaita wei. Eno utaitaba i amara ma wiroeba kobererau ibinuro aneba Naba ibo utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yana koto utaitana me sara da uawete rorowarau uawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","26","Yesuma eno weiba moana Jerusaremu su uwarama weita, ewana emanu ma uifitae weita amara aba me? Eno weitate weita, Dawa yabai sina derawere wasuro i uwarama wate mu utaita weita. Yanu dera uwarama Dana i Keriso we imutaita aba? ");
INSERT INTO yrb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ewa amaranu su ya iwata utaisi. I Mesaianu fareta orofa emema iwata me, aboroma fafisu weita? ");
INSERT INTO yrb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Weitaro Yesuma i Ju uwaranu dera dubu suro we mawetu utebe i sina nauite Yesuma nono derawere wei, Nanu suini Naini ya iwata utaisi waita? Eno weite wei, Nanu torowa Nanu unuro ewaro farawa uero Na siaia ui Godi Dawana ba. Yana Dawa iwawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nana Dawa iwataro Dana Na siaia uiro Dawabairoma ewaro fare wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesuma eno weiba i uwarama Yesu budari ufitae utaro Danu kowa farawa uiba Dawa mame munawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","I dera dubu suro guruguru ubita uwara faiyawere emanu naueta Yesubai oitate eno weita, ewa Amarana i Mesaia. Mui amarama duburo fafisuna danu uetama ewa Amaranu buna ueta serigari da ufisu weita. ");
INSERT INTO yrb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Eno weda gimumutaroma webitaro nautate i Ferosi waita uwara emaini i dera fuyo ode sina weta uwaraini forisimanima Yesu budari ufitae siaia utaro anita. ");
INSERT INTO yrb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ane Yesubai fataro Yesuma wei, yabai kikiratu ibimate Na siaia uiro ewaro fare Godibai animau wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yana Na doberebe da atafote Nanu ibimau orofaro da afoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Eno weiba i Ju uwarama we mataneda weita, ewa Amara aboro anibiro dawa da atafeisi weita? Yanu we berasiro Guriki uwaranu orofaro anita uwarabai anibite ema we mawetu uteibisu aba? ");
INSERT INTO yrb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ane wenu, yana Na doberebe da atafote Nanu animau orofaro da afoita wenu weita? ");
INSERT INTO yrb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","I ogaro ie me sinebita kowaro Yesuma yare wei, ana anama ogo nodo utaitana Nabai afote ifoe watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Godinu bukaroma eno wasu, anama Danu naueta Nabai odasuna danu nenoroma me ibene ibene ibeta dera ogo ari amufite emebai anibisu, wasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(I sinana Godinu Imumu Kotofuba wei. Ana anama emanu naueta Yesubai odifitaro Godinu Imumu Kotofuma emabai itafiro mubitaita. I kowaro Yesuma urero manawa uiba Godima Danu Imumu Kotofu matawa ui.) ");
INSERT INTO yrb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","41","Yesunu sina nautaro moana uwarama weita, ewa Amarana Godinu ba we bou ueta fafisu weita Amara weitaro moana uwarama weita, I Mesaiama Gareriroma da fafisu weita. ");
INSERT INTO yrb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Godinu bukaroma wasu, i Mesaiana Deiwidinu sisia amara. Deiwidinu su, Betiremu suroma fafisu, Godinu bukaroma eno wasu weita. ");
INSERT INTO yrb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Enoba i uwarama abanaro saragari uta. ");
INSERT INTO yrb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Saragari utaba moana uwarama Yesu budari ufitae weitana Yesu mame munawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","I forisimani uwarama owetate i dera fuyo ode sina weta uwaraini Ferosi uwarabai fataro weita, aneba Dawa woure arawa me farita weita? ");
INSERT INTO yrb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Weitaro forisimanima weita, Danu wenu sina bunawerero moana uwarama Danu wenu sina ari wiawa utaita weita. ");
INSERT INTO yrb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Weitaro i Ferosi uwarama weita, Dawa yade irusinuro danu sina nautedibaita weita? ");
INSERT INTO yrb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Eno weitate weita, i dera yawoeta uwaraini yaini Dawa imutawa utaisi. ");
INSERT INTO yrb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","I guruguru ubaita uwarama Mosesinu tarawatu iwata meba Godima ema fanisi derawere mafisu weita. ");
INSERT INTO yrb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Eno weitaro Nikodimasi dawa i auboko Yesubai ani amara, dawa Ferosi amara, i amarama emaba wei, yanu tarawatuma eno wasu, mui amara me sara fanisi da uawe wasu. Koto ufote danu ueta sineta naufote iwata ufote ido fanisi mafoita wasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Weiro dawaba weita, aini Gareriroma farinu? Weitate weita, Godinu buka eregou ufasuna we bou ueta uwarama Gareriroma da fafitaita iwata ufasu weita. ");
INSERT INTO yrb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Eno weitaro i uwara nesia ekoitate emanu su suro wo bogaru ue anita. ");
INSERT INTO yrb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesuma Oriwa maidaniro manite iro aini. ");
INSERT INTO yrb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wai uriro Yesuma owerite taranite dera dubu suro amui. Amuiro uwara faiyawere farebitate guruguru utebitaro Yesuma yaubeda we mawetu utebi. ");
INSERT INTO yrb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Yesuma webina moana tarawatu tisa uwaraini Ferosi uwaraini ema moana emeba utebi aweta mutate woure Yesubai fata. Fatate i guruguru ubita uwaranu iboro ma inatate Yesuba weita, tisa amara, ewa aweta kerere usinuro erisite munisite iba Abai woure farisia weita. ");
INSERT INTO yrb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesinu tarawatuma eno wasu, i dita yagera fareta uwara gebiroma ure ma uiawe wasu weita, nono Ade anene webasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","8","Yesu wenauefitate Yesunu webisu sina naufitate Yesu ue efitae iba eno weita. Eno weitaro Yesu ubiri tafu uteda agema sakairo owawa yanaina woroworo webita, wiaro naufe webitaba Yesuma uyarite wei, i neno neno utawa amarama i awetabai dana botai gebiro sabiro dawa uifisu weite yaurite nono tafu uteda agema sakairo nono owawa yanai. ");
INSERT INTO yrb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yesuma eno uiro i Ju uwarama kiwuma wo bagaru ue demui demui dera uwara ko anitaro Yesuini i awetaini i guruguru ubita uwaranu iboro emanu aika ibita. ");
INSERT INTO yrb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Enoba Yesuma uyarite i awetaba wei, anu wawei weta uwara aboro? Aba wawei waita aba me? ");
INSERT INTO yrb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Weina i awetama wei, Dera Amara, moana uwara me wei. Weiro Yesuma wei Nade, aba a siosawere weda wawei da wemau. Enoba aniate mui neno neno ueta da ua wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mui kowaro Yesuma i dera dubu suro yaubita uwaraba wei, Nana ewa orofa atatanu dera nanefa ario ari. I orofa atata uwara nesia we mawetu utataneba iba Nana emanu dera ario ari. Nanu buribi afitaita uwarana dumuro da inareibitaita. Enoba Nanu wiroeta arioro anedibeibitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Weiro i Ferosi uwarama weita, anu torowa anu sina wasuba iba meo wasu weita. ");
INSERT INTO yrb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Weitaro Yesuma wei, meo me, ba watane wei. Nanu torowa Nanu ueta sineta sina wataneba iba ina ba sina wei. Nanu are orofa Na iwata utatanete Nanu animau orofa Na iwataro nono ina ya iwata me wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yanu utaita kotona emenu koto ari. Na uwara koto utawa utatane. ");
INSERT INTO yrb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nono Nana eme koto uteimarona Nanu torowana me, Na siaia ui Godi Dawa Na durua ufiro Nanu kotona ba sibie wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ya uwaranu tarawatuma eno wasu, amara sadeima mui iba sina waisina, i sinana ba wasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Naini Na siaia ui Godini Nanu sina waitu wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yesuma eno weiro Dawaba weita, Anu Amama aboro weitana wei, Naini Nanu Babaini ya iwata me wei. Na iwata uforona Nanu Baba iwata ufoe watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuma i sina dera dubu su oi muneta koruro weiro Danu kowa farawa uiba i Ju uwarama Dawa budari utawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nono Yesuma emaba mui sina eno wei, Na animaro Na doberebe doberebe Na da atafoitana yanu neno neno ueta yabai daido ibifiro uifoita wei. Nanu animau orofaro da aniboita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Weiro i Ju uwarama weita, Danu torowa Danu nodo tufisu aba? Aneba eno wasu, Nanu animau orofaro da aniboita wasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","24","Weitaro Yesuma wei, yana sakairoma uyataro Nana ureroma fare. Yana sakai ubi uwara. Nana ure ubi Amara, weite wei, iba wene, yanu neno neno ueta yabai ibifiro uifoita. Nana i ma wiroeta Amara da imufote yanu neno neno ueta yabai ibifiro uifoita wene wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Weiro Dawaba weita, a anaiya? Weitana wei, Nanu sina yaba boderewereroma webatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yaba Nanu sina faiyawere wemate ya koto derawere umau wei. Na siaia ui Godi, Dana ba, iba ane ane Naba wasuro enanari orofa atata uwara nesiabai watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","28","Yesuma Baba Godiba weiro i uwara i sina iwawa utaba Yesuma emaba wei, yana i Ba Eme Sini Amara korosiro ikokoma ufoita i kowaro Nana i Amara, Godinu Amara, iwata ufote mui eno iwata ufoita. Nana Nanu imueta utawa utatanete Godinu imuetaini we mawetu uetaini torowa watane, eno iwata ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na siaia ui Godi Nabai ibinu. Danu imueta utataneba Dawa yaru utasute Na ekodawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesuma eno weiba uwara faiyawere emanu naueta Dawabai oita. ");
INSERT INTO yrb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","32","Yesuma Danu sina naue imue utebita Ju uwaraba wei, Nanu sina nauegou ufoitana Nanu ba iwata ueta uwara sibote Nanu ba sina iwata ufoitaba yanu siosanu sabua ueta arina ido me sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Weiro weita, yana Eibaramunu sisia uwara moana uwarama ya yawotawaba aneba yanu sabua ueta arina me sibisu wasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Eno weitaba Yesuma emaba wei, Nanu ba sina wemaro nauawe wei. Ana anama siosa ueta utaitaro i siosa uetama ema yawotasuba emana siosa uetanu i sabua ueta uwara ari. ");
INSERT INTO yrb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","I sabua ueta amarama danu yawotasu amaranu suro da ibeibisu. Nono i yawotasu amaranu amara torowama danu ewa nasiniro ibeibisu kowaro danu damamanu suro ibeibisu. ");
INSERT INTO yrb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ibago Na Godinu Amarama ya ma wiromauna yanu siosa ueta sineta ekodifote merau ibegou ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yana Eibaramunu sisia uwara Na iwataro nono ya unutawa Nanu sina yaba weta iba yana Na ma uifoe utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nana Nanu Babanu ba sina naueba yaba webatanero yana yanu yamamanu wei sina nautebaitate iba eno utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Weiro i uwarama Yesuba weita, Eibaramu, dana yanu baba weitaro wei, yana Eibaramunu uwararona danu utebi enanari uteiboe watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nana Godima weiro naue ba sina yaba ba webatanero nono yana Nanu uieta daba doberebaita. Eibaramunu ueta gaukara enanari me wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Eno utaitana yanu yamama seitaninu ueta sineta enanari utaita wei. Weiro weita, yanu bayamutuma ya dabaro munawa uta. Yanu babana demurai, Dawa Godi weita. ");
INSERT INTO yrb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Eno weitaro Yesuma emaba wei, Godi Dawa yanu yamamana me. Dawa yanu yamamarona yanu neno Nabai odifoe. Na Dawabai ibebitararo Godi Dawa Na siaia uiro Dawa ekodete Dawabairoma fareba Godi yanu yamamarona yanu neno Nabai odifoe watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aneba Nanu sina nautawa utaita? Ya unutawa Nanu sina weta iba yanu ome garari utaitate Nanu sina nautawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yanu yamamana seitani. Yana danu adarabuba yana danu ueta utaita. Boderewereroma seitani dawa ma uieta amara. Dawa unutawa ba ueta. Dana meo bobo amara torowa, dawabai ba me. Dawa sina wasuna meo torowa wasu. Dana meo weta ubinu damama. ");
INSERT INTO yrb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ibago yaba ba sina watanero ya naue imue utawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Anama Naba A siosa utasu webisu? Eno da webisu. Nana ba sina watanero aneba Na naue imue utawa utaita wei? ");
INSERT INTO yrb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Anama Godibairoma fafisuna Godinu sina naufisu wei. Yana Godibairoma farawa utaba Godinu sina nautawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yesuma eno weiro i Ju uwarama Dawaba weita, eno waisi, Ana seitaninu mui siosa imumu bobo Samaria orofa amara waisi ina ba aba me weita? ");
INSERT INTO yrb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Weitana Yesuma wei, Na seitaninu mui siosa imumu bobo me wei. Nana Nanu Baba we ma kobererau utatanero yana Naba sina siosa waita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nanu torowaba we ma kobererau utawa utatanero Godi Dana Na we ma kobererau utasuba i meo uwara nesia koto rorowarau ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Eno weite nono wei, Nanu ba sina wemaro nauawe wei, ana anama Nanu sina nauegou uteda yawoegou ufitaitana da uifitate me ibene ibene ibifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Weiro i Ju uwarama Dawaba weita, abai seitaninu mui siosa imumu ibinuro ya iwata utaisi weita. Eibaramuini i we bou ueta uwara nesia uitaba aneba anama Nanu sina nauegou ufisuna da uifite me ibene ibene ibifisu wasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yanu baba Eibaramu dawa ui. I we bou ueta uwara nesia uita, aneba eno wasu? Ana derawere, i uwarana kikiratu we imutasu? Ade anaiya? Wiaro naufe weita. ");
INSERT INTO yrb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Eno weitaro Yesuma wei, Nanu torowa Na we ma kobererau umauna ina ba me. Ya eno waita, Godina yanu Baba waita, i Godima Na we ma kobererau utasute Na ma derawere utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ya Dawa iwawa utaitaro Nana Dawa iwata utatane. Nana Godi iwata me wemauna yanu meo sina ari wemau. Nana Godi iwata utatanete Danu sina nauteda uegou utatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yanu yamama Eibaramuma Nanu fareta kowa efie utebe farero erite yaru ui wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Weiro i Ju dera uwarama weita, A reka Amara. Anene Anu oyana fifiti (50) munawaro nono Ana Eibaramu erite wasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Eno weitana Yesuma wei, boderewere Na ko ibebitararo danu danuama Eibaramu dawa duburo muni wei. ");
INSERT INTO yrb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yesuma eno weiba i Ju dera uwarama gebiro mutate Yesu ma uifitae utaro Yesuma me ari uite dera dubu su ekodite ani. ");
INSERT INTO yrb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mui kowaro Yesuini Danu iwata ueta uwarama inarebitaro mui amara danu danuama dawa muni kowaroma diti basugari bobo ido yaubi. ");
INSERT INTO yrb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","I uwarama dawa serigari ue fare aneda Yesunu iwata ueta uwarama Yesuba weita, ewa amara siosa uiro aba danu danua damama siosa usiba iba danu danuama dawa diti basugari bobo muniro yaubinu weita? ");
INSERT INTO yrb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Weitaro Yesuma wei, dawa siosa ueta utawa danu danua damamama siosa ueta utawa usiro danu danuama dawa me eno torowa muni. Godi Danu buna ueta dawabai ufiro uwarama i buna efitae iba danu danuama dawa eno muniro yaubinu wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Na siaia ui Godinu gaukara kowa arioro sau ufero nono dumu sau sibisuna gaukara da ufeisi wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ewa orofa atataro ibedana Nana ewa orofa atatanu ario ari wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Eno weite sakairo witua uite witua ma bisibasa uite sakai mune i amaranu ditiro mameda wei, Sairomu waita mesauraturo aniate anu diti uroa. (Sairomu ifunu ubina siaia ueta). Yesuma eno weiro i amara nauite enanari ane uite owerite ditima ba erere fari. ");
INSERT INTO yrb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Danu su uwaraini danu domayamutuini dawa emebai nui webi amara iwata utaba iba eno weita, i nui weda me yaubebasu amarana ewa amara aba dawa anaiya weita? ");
INSERT INTO yrb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Weitaro moana uwarama weita, aiwia i amara idoni weitaro moana uwarama weita, me, dana dawa ari weita. Weitaro i diti wiroiro ba eregou ui amarama wei, na idode wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Weina anu diti anene wirosinu weita? ");
INSERT INTO yrb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Weitaro i amarama wei, mui amara Danu ifuna Yesu Dawa Danu witua sakairo usinute nanu ditiro mameda wenu, Sairomu mesauro aniate anu diti iro uroa wenuro enanari ane diti uronete wironea wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Weina weita, i Amara aboro? Weitana na iwata me wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","I uwarama i diti basugari wiroi amara Ferosi waita uwarabai woure fare oita. ");
INSERT INTO yrb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuma sabate kowaro i sakairo witua uite i amaranu ditiro mamite ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","I uwarama i amara woure oitaro Ferosi uwarama weita, anene usinute erasu weita? Weitaro wei, Dana sakai nanu ditiro maminuro uronete ene wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","17","Weiro moana Ferosi uwarama weita, sabate kowa imutawa utasuba dawa Godibairoma farawa weitaro moanama weita, mui siosa ueta amara eno da ufisu weita. Enoba abanaro saragari utaba nono i amaraba weita, anu diti ma wirosinu amaraba ane wasu? Weitana Dana Godinu we bou ueta Amara wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","I amarana diti basugari boboro wiroi amara imutawa utate i amaranu danua damama yua weitaro fataro weita, ewa amarana yanu muneta diti basugari bobo amara aba me? Awona anene erasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Weitaro weisi, aiwia, ewana wanu muneta diti basugari bobo amara. ");
INSERT INTO yrb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Anene erasu ari, wana iwata me. Dawa dera amaraea dawabai wenaueawe weisi. ");
INSERT INTO yrb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Danua damamama i Ferosi uwaraba iyasite iba eno weisi. I Ju dera uwarama auboko weita, anama Yesuna i Mesaia webisuna dera dubu suroma yowefeisi weitaba iba danua damamama enanari weisi, dawa dera amaraea dawabai wenaueawe weisi. ");
INSERT INTO yrb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Eno weisiba Ferosi uwarama nono weitaro diti basugariroma wiroi amarama emabai fariro dawaba weita, Yesu, Dana siosa amaraba Godi Dawa torowa we ma kobererau utebea weita. ");
INSERT INTO yrb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Weitaro i amarama wei, Dana siosa amara aba me, na iwata me. Nono nana diti basugari ue ibebe ibebe awonana eratanete ina na iwata utatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Weiro weita, Dawa aba ane usinu? Anu diti anene ma wirosinu weita? ");
INSERT INTO yrb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Weitana i amarama wei, yaba auboko wenero nautawa uita. Aneba nono wemaro naufoita? Yanu ununa Danu iwata ueta uwara siboita wei? ");
INSERT INTO yrb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Weiro dawaba siosa sina weitate bunawere weita, ana Danu iwata ueta amara. Yana Mosesinu iwata ueta uwara. ");
INSERT INTO yrb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","30","Godima Mosesiba sina webi, ina ya iwata utaisi. Ewa Yesu, Dawa aboroma fari? Ya iwata me, weitaro wei, kamama nautatane weite wei, Dana nanu diti ma wirosinuro yana Dawa iwata me. ");
INSERT INTO yrb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","32","Godima i siosa ueta uwaranu sina nautawa utasuro ina ya Ju uwara nesia iwata utaisi wei. Anama Godi guriguri utasute Godinu unu utasuro Godima danu sina nautasuro ina ya iwata utaisi. I amarama eno weite wei, boderewereroma uwarama diti basugariroma eme ma wirotawa utebita. ");
INSERT INTO yrb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Godima Dawa siaia utawa ufirona gaukara me sara da ufie uteibie wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Eno weiro i uwarama dua utate sina siosa weitate eno weita, anu munetaroma siosa ueta utebiba awona ya we mawetu ufae utasu weita? Eno weitate i Ju uwaranu dera dubu suroma dawa we yowetaro ani. ");
INSERT INTO yrb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesuma i sina nauite i amara dobere ane atanite wei, i Ba Eme Sini Amarabai naue imue utasu aba me? ");
INSERT INTO yrb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Weiro i amarama wei, Dawa anaiya wiaro naumate naue imue umau wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Eno weiro Yesuma dawaba wei, ana Dawa erasuro Dana awona aini sina wasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Weina i amarama wei, Dera Waria Amara, na kimuwere nautatane. Eno weite Yesunu buri gigirariro jerigari ui. ");
INSERT INTO yrb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesuma wei, dera koto umane iba ewa orofaro fare wei. Enoba i diti basugari uwara efitae farete i eraita uwara diti basugari ufitae fare wei. ");
INSERT INTO yrb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Weiro moana inaibita Ferosi uwarama nautate weita, yaini diti basugari utaisi aba me weita? ");
INSERT INTO yrb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Weitaro Yesuma wei, yana diti basugari ufirona yabai kerere me, ya eraisite iwata utaisi waitaba yanu kerere yabai ibeibisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nanu ba sina wemaro nauawe, Yesuma wei, anama i mamoe dowa bebetoro da fare amufite nono i dowa bebefite ubarero me sara itafisuna i amarana wairawere meo amara. ");
INSERT INTO yrb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","I mamoe yawoeta amarama i dowa bebetoro torowa fare itarasu. ");
INSERT INTO yrb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","I kasimu yawoeta amarama dawaba i kasimu ma ifegari utasuro mamoe yawoeta amarama danu mamoenu ifu ifuro dabitasuro nautaitaro ema woure anasu. ");
INSERT INTO yrb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Dawa ko anasuro mamoema Danu wate tanana iwata uteda nautaitate Danu buribi anaita. ");
INSERT INTO yrb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","I mamoema aika amaranu buribi danu wate naue anawa utaitate danu wate tanana iwawa uteda ekodaitate iya durami ue anaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","7","I sina nautaita uwarama Danu kasei sina iwawa utaba Yesuma i sina eno we ma boroyarite wei, Nanu ba sina wemaro nauawe wei. Nana i mamoe dowa bebeto ari. ");
INSERT INTO yrb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","I auboko fare anebita tisa uwarana waira uwara, meo uwaraba i mamoema emanu sina nautawa utebita. ");
INSERT INTO yrb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nana i mamoe dowa bebeto ari. Ana anama Nabai afitate ubarero anibitate Nabai wirofitaro ema kobererau yawomaro merau ibeda ane fare uteda ieta ataneibitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","I waira ue meoma weta amarama waira ue ma uie ma siosa ufie iba arasu wei. Nana i mamoenu ibeta ma kobererau umaro ibegou ufitae iba farea wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nana i mamoenu kobere ema yawoeta Amara. I mamoenu kobere yawoeta amarama danu mamoe yawoegou ufie iba mamoeba uietabana iya uyarawa emaba daido uitebasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","I oi gaukara amarana ba yawoeta amara meba wurufu, dera orowa kua ari, farasuro erasute i mamoe danu meba ekodasute durami ue anasuro dera orowa kua arima i mamoe turo amuteda mamasute ma beratasuro wo bogaru ue anaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","I amarana oi gaukara amaraba dawa unutawa mamoe kobere yawoeta. I mamoe danu meba iba ekodasute iya durami ue anasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nana i mamoenu kobere yawoeta amara. Nanu Babama Na iwata utasuro Nana Nanu Baba iwata utatane, enanari Nanu mamoe Na iwata utatanero mamoema Na iwata utaitaba Nanu mamoeba uimau wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Moana aboro aboro ibinita mamoe Nanu. I mamoema ewa dowa ubarero ibawa utaitaba ane mune woumaro Nanu sina naufitate mamoe nesia tu demurai sibitaro mamoe yawoeta amara demurai sibisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nanu ununa uimate uietaroma uyamate nono nanu me ibeta mumate ibimauba Nanu Babanu neno Nabai ibinu wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mui amara danu torowana Na da ma uifiro Nanu unu eno uimau. Nanu Babama Na buna derawere maite weiba iba Nanu torowana uimate nono uyamau wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","20","I Ju uwarama Danu sina nautate imueta aika maika imutaba abanaro saragari utate moana eno weita, Dana seitaninu mui siosa imumu boboro gogore sina wasuba aneba naufeisi? ");
INSERT INTO yrb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Weitaro moanama weita, Danu sinana seitaninu mui siosa imumu bobo amaranu sina ari me weitate weita, i seitaninu siosa imumuma diti basugari uwara da ma wirofisu weita. ");
INSERT INTO yrb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","24","I kowaro Ju uwarama emanu dera dubu su ma wiroeta ogaro itebita. I kowana iwuwere kowa. I kowaro Yesuma dera dubu su Soromoninu ofadaro inarebina i Ju uwarama Dawabai fatate Dawa ode kara uteda weita, Anu ba sina abododo webaro naufeisi weita? Ana i Mesaia aba me? Wegou uaro naufe weita. ");
INSERT INTO yrb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","27","Weitaro Yesuma emaba wei, Na wenero nautawa uita wei. Nanu Babanu wei gaukara utatanero i gaukarama Na ma boroyarasuro eraita weite wei, yana Nanu mamoe meba Nanu sina nautawa utaita wei. Nanu mamoe Na iwata utatanero nanu sina nauteda Nanu buribi araita. ");
INSERT INTO yrb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Araitaro emaba me ibene ibene ibeta matataneba me sara da uifitate fanisi orofaro da anibitaro mui amarama ema Nanu age duroma da ma dare mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nanu Babama ema Naba mai. Dana derawerero emena derawere me. Dana derawereba mui amarama Nanu Babanu age duro ema da ma dare mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nanu Babaini Naini wana demurai wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","33","Yesuma eno weiba i Ju uwarama Yesu nono ma uifitae iba gebiro mutaro Yesuma wei, Nana Godinu buna ueta faiyawere yanu ditiro utebatane wei. Abo buna uetaba Na gebiroma ma uifoita weiro i Ju uwarama weita, Anu kobere uetaba da ufeisi weita. Ana Godiba sina siosa wenute Ana emero nono Godini Naini arotorowa wenuba iba gebiroma ufeisi weita. ");
INSERT INTO yrb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Weitaro Yesuma emaba wei, yanu tarawatu bukaroma Godi eno wasu, yana godi ari watane eno wasu Yesuma weite nono wei, Godima Danu sina i uwaraba maite emaba yana godi ari wei. Godinu bukana ba iba i sina ba ibifisu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Godima eno weiro aneba Godinu mune odiro fare Amaraba eno waita? Dana wenu, Godini Naini demurai wenuba iba Godiba siosa sina wasu waita wei? ");
INSERT INTO yrb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nanu Babanu gaukara utawa uteimauna Na da naue imue ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nanu Babanu gaukara utataneba Nabai da naue imue ufoitana Nanu ueta imuegou uawe wei. Eno ufoitana Nanu Babama Nabai ibinuro Nana Dawabai ibine iwata ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesuma eno weiba i uwarama Yesu budari ufitae weitaro Yesuma ema ekodite me ari uite aniro munawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesuma Jerusaremu suroma anite Jodani ogo yoferite Joni babataito amaranu botai babataito utebi orofaro farite iro ibi. ");
INSERT INTO yrb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Eme faiyawere Yesunu sina naufitae Dawabai fatate emanu emanu weita, Jonima buna utawa uite anene Yesuba wei i sinana ba weita. ");
INSERT INTO yrb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Weitaro eme faiyawere emanu naueta Yesubai oita. ");
INSERT INTO yrb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mui amara danu ifuna Rasarosi, dawa ofe wouri. Dawaini danu aruma sadei, Merini Mata Beteni suro ibebita. ");
INSERT INTO yrb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(I ofe wouri amaranu aruma, Meri, dawa Yesunu buriro bononawere ogo ma wegari uite Yesunu buri danu yafa fouma ijima maituri). ");
INSERT INTO yrb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","4","I uwara Beteni suro ibebitana Rasarosi ofe ido wouri. Dawa ofe wouriba i aruma sadeima sina weisiro Yesuba ane weita, Dera Waria amara, anu aiye warai Rasarosi, dawa ofe derawere wourinu weitaro Yesu nauite wei, danu ofe wouretana ba uieta ofe wourawaba mena emema i wourinu ofe efitate Godinu ifuini Nanu ifuini we ma derawere ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuma Mataini Merini Rasarosiba neno arama utebi. ");
INSERT INTO yrb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesuma Rasarosi ofe woureta sina nauite sau Beteni suro anawa uite i suro kowa sadei ibi. ");
INSERT INTO yrb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kowa sadei me siniro Yesuma Danu iwata ueta uwaraba wei, Judia orofaro nono anibe wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Weiro i iwata ueta uwarama weita, Tisa, i Ju uwarama A auboko iro gebiroma ufitae utade aneba iro anibasu weita? ");
INSERT INTO yrb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Weitaro Yesuma emaba wei, kowa amutasuna ario farasuro kobere inareta farasu. I kowanu arioro inareda ewa orofa atatanu ario erasuba buridu urawa utasu weite wei, anama dumuro inarasuna i ario dawabai meba buridu urasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Eno weite emaba wei, yanu yaiye Rasarosina nauta ainibinuba animate dawa ma uyamau wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Weiro i Danu iwata ueta uwarama weita, dawa nauta ainibifisuna wirofisu weita. ");
INSERT INTO yrb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","14","Rasarosi ba me siniba Yesuma iba eno weiro iwata ueta uwarama iwawa utate Rasarosi ba nauta ainibi imutaba Yesuma emaba wei, Rasarosi me sini wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na botai iro anawa ueba iro animate buna ueta derawere umauna yanu imueta ma buna ufoitaba iba yaru utatane weite wei, dawabai anibe wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Eno weiro, i sokaka waita amara Tomasima danu domayamutu iwata ueta uwaraba wei, yaini anibete dawa ma uifitae ufitaitana yaini nesia uifeisi wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu Beteni suro ido ane farina Rasarosi uri ue oitaro kowa fo (4) uriro ainibi. ");
INSERT INTO yrb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Jerusaremu suroma Beteni suro daba yafawere me, fuyanono iba Ju uwara faiyawere Mataini Meribai fatate i weda yaubita. ");
INSERT INTO yrb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yesu ido arasu weitaro Mata nauite durami ue ane Yesu ataniro Meri suro yaubi. ");
INSERT INTO yrb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","22","Matama Yesubai farite wei, A auboko sau ewaro fafarona nanu eweri uitawa me ibifie weite wei, na iwata awona ane Godibai webasuna Godima aba mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","24","Eno weiro Yesuma dawaba wei, anu aena nono uyafisu weiro Matama Yesuba wei, i uietaroma uyareta kowa muiro uyafisu imutatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Weina Yesuma wei, Nana i uietaroma ma uyaretaini me ibene ibene ibetanu ubi weite nono wei, anama danu naueta Nabai odifite uifite nono uyafite me ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ana anama me ibinitaro Na nautaitana da uifitate me ibene ibene ibifitaita. A imutasu wei? ");
INSERT INTO yrb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Weiro Matama Dawaba wei, Dera Waria Amara, aiwia ina na imutatane. Ana i Mesaia imutatanete Ana Godibairoma ewa nasiniro fari Amara imutatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","29","Matama i sina weite owerite suro ane farite kekeramaratu Meriba wei, yanu Tisa Amara farinute aba wenu weiro Merima nauite sau uyarite ani. ");
INSERT INTO yrb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Yesuma i natofo suro ane farawa uite i botai Matama Dawa atani iro ibi). ");
INSERT INTO yrb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","I uieta suro yaubita Ju uwarama Merinu aneta etate we imuta, i aruma danu daenanu uri ue oeta kabesiro anibite daenaba iro i webie anasu we imutate danu buribi anita. ");
INSERT INTO yrb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Merima Yesubai ane farite Danu buri gigiraribai arubi uteda wei, A auboko ewaro sau fafarona nanu eweri da uifite me ibifie wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","34","Da uifie weite Meri dawaini i Ju uwaraini nesia i weitaro Yesuma ema erite neno siosa uteda wei, Rasarosi aboro uri ue oita weiro weita, Dera Waria Amara are ea weita. ");
INSERT INTO yrb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","36","Eno weitana Yesuma i weiro i Ju uwarama weita, Yesu Rasarosiba neno arama derawere utasu weita. ");
INSERT INTO yrb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Eno weitaro moana uwarama weita, ewa amarama diti basugari amara ma wiroi rairo nono aneba Rasarosi webiro wirotawa ui weita? ");
INSERT INTO yrb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Eno weitaro nauite Yesu neno siosa nono uite ane Rasarosi uri ue oita kabesiro ane fari. I uiro uri ue oeta kabesina gebiro erabo. ");
INSERT INTO yrb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Mui gebiroma i uri bebetoro garari ue oitaro ibiba Yesuma wei, i gebiro mune eta kebiro odiawe wei. Weiro i uiro uri ue oita amara dawaini uruama itasi aruma, Matama wei, danu uieta kowa nesia fo (4) me sininuba urara fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Eno weiro Yesuma i aruma dawaba wei, auboko Nana aba wene enanari kimuwere imufasuna Godinu buna derawere efasu wene wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yesu eno weiba i gebiro ma ubere eta kebiro oita. Oitaro Yesuma diti etu urero erite guriguri uteda wei, Baba, awonana Na Ana Nanu sina nautasuro A we ma kobererau utatane. ");
INSERT INTO yrb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na iwata, A Na woroworo nautasuro ewa inaibinita uwarama Ana Na ewaro siaia uiro fare imufitae iba eno watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eno weite sina derawere weda yua wei, Rasarosi, uriroma uyate wawaro amua wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Eno weina i ba uiro uri ue oita amara Rasarosi dawa ba ido uietaroma uyarite amo fari. Danu buri age wadiama wayare wayare utate kofiri ibo nawata mui wadiama obari utate oitaro ainibi. Eno ainibebe eno bobo amo fari. Amo fariro Yesuma wei, i amaranu ofero ibinu wadia ma uregari uawero suro anibi wei. ");
INSERT INTO yrb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","46","Moana Ju uwara, Merini uruama anita uwarama Rasarosi uietaroma uyari i etate Yesu naue imue utaro nono moana Ju uwarama Jerusaremu suro anitate Ferosi uwarabai Yesunu buna ueta weitaro nauta. ");
INSERT INTO yrb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","I eno ueta sina nautate iba i dera fuyo ode sina weta uwaraini Ferosi uwarama weita, kanisoro mitini ufe weitaba i kanisoro uwara ido fare guruguru uta. Ido fare guruguru utaro weita, i Amarama buna ueta faiyawere utasuba anene ufeisi weita? ");
INSERT INTO yrb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Weitate weita, me ere kodeibero Dana eno uteibisuna uwara faiyawere danu buribi anibitaitaba i Romani dera yawoeta uwarama emanu ami uwara siaia ufitaro fafitate yanu dera dubu suini yanu Ju uwaranu su nesia ma siosa ufitaita weita. ");
INSERT INTO yrb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Eno weitaro i fuyo ode sina weta uwara emanu dera amara, danu ifuna Kaiyafasi, dana eno wei, yanu imuetana ba me. I amara yana Dawa da ma uifero Danu torowa uifisuna ina kobererau. Ya i sina imutawa utaita. Nono aneba ya Ju uwara nesia uifeisi wei? ");
INSERT INTO yrb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(I oyaro, i amara Kaiyafasi dawa dera fuyo ode sina weta amaraba Godima Dawabai Danu imueta maiba iba Yesuma i Ju uwaraba uifisu we bou ui. ");
INSERT INTO yrb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","I we bou uetana Ju uwara torowaba wiawa ui. Wiawa uite Godinu arumami adarabu aboro aboro ema nesiaba uifite Dana uwara nesia mune uwara demurai odifisu). ");
INSERT INTO yrb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Enoba i dera Ju uwarama weita, Yesu Dawa ma uifeisi weita. ");
INSERT INTO yrb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","I kowaroma Yesuma i Ju uwarabai emanu iboro baworo inarawa ui. Idoba Yesu Jerusaremu su ekodite Efaramu suro ani. I suna eme ibawa orofa gigirariro ibebi. Yesu iro anite Dawaini Danu iwata ueta uwaraini iro ibebita. ");
INSERT INTO yrb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Duburo i Godima Isaraero uwara Ijifiroma woure ani ogaro kowa baworo uiba uwara faiyawere aboro aboroma Jerusaremu suro emanu ogaroro kakara uroeta urofitae fata. ");
INSERT INTO yrb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Iba iro fatate Yesu doberebe doberebe osi utate dera dubu su ubarero inatate weita, ya uwara ane imutaita? Yesu Dawa ogaro fafisu aba me weita? ");
INSERT INTO yrb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","I dera fuyo ode sina weta uwaraini Ferosi uwarama auboko weita, anama i amara Yesu efisuna yabai are webiro naufe weita. I weita ina emanu ununa Yesu yabae budari ufitae iba eno weita. ");
INSERT INTO yrb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kowa sikisi (6) me sibiro i Godima Isaraero uwara Ijifiroma woure aneta ogaro fafisu. I kowaro Yesuma Beteni suro ani. I uietaroma ma uyari amara Rasarosi, danu suro ani. ");
INSERT INTO yrb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ieta outaro moana uwaraini Yesuini Rasarosini eno yautaro Rasarosinu aruma Matama ieta nabero mairo ita. ");
INSERT INTO yrb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ieta itebitana Merima bonanawere ira ogo, danu dawana derawere, ima munite Yesunu buriro ma wegari ui. Eno uite tafu uteda Meri danu fouma ijima Danu buri maituriro bonana derawere farite i su inune ui. ");
INSERT INTO yrb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Judasi Isikarioti, dawa mui Yesunu iwata ueta amara, dawa Yesu ma uifitae do mai amara, dana wei, i bonanawere ogo aneba moana emebai oiya ufate moni toti kina (K30) mubate ibaiabai me uwaraba matawa usinu wei? ");
INSERT INTO yrb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","I amara dawa ba ibaiabai me uwara imufite wiawarogo dawana i iwata ueta uwaranu oi banika yawoteda emanu oi waira utebiba iba eno wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Eno weiro Yesuma wei, i arumaba sina fusama kodiawete dua sina da wiawe wei, i ibinu munowere ogo dawabai ibifiro Na uri ufitaita i kowaro Nanu ofero ma wegari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","I ibaiabai me uwarama ainewaure yabai ibaitaro nono Na yabai ainewaure da ibimau wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ju uwara faiyawere Yesuma Beteni suro yaubiro nautate Yesuini Rasarosi i uietaroma ma uyari amaraini efitae iba ane fata. ");
INSERT INTO yrb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Uwara faiyawere Rasarosi uietaroma uyari kamama etate emanu naueta Yesubai oitaba i dera fuyo ode sina weta uwarama Rasarosini Yesunu ma uieta daba dobere imuta. ");
INSERT INTO yrb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Etei mui kowaro Yesuma Jerusaremu suro fafie arebiro i ogaro fata uwarama i sina nautate farai tata woutate Yesu atafitae anita. I uwarama aneda weita, yanu ma wiroeta amarama arasu. Dawa Godinu ifuro arasuba we ma kobererau ufeisi weita. Ana ya Ju uwaranu dera yawoeta amarawere weita. ");
INSERT INTO yrb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Yesuma otowa doniki dobere atanite i donikinu deiro yauri. Godinu bukaroma enanari wasu, ya Saioni orofaro ibinita uwara iya da uyawero yanu Dera Yawoeta Amarawere otowa doniki deiro yaurasute ido yabai farasu eawe, eno wasu. ");
INSERT INTO yrb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesunu iwata ueta uwara iwawa utarogo nono Dawa urero araeta munina ido Godinu bukaroma wasu sina imutana ina Yesu Dawaba uta. ");
INSERT INTO yrb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesu Rasarosi uietaroma ma uyarite uriroma yua weiro amui kowaro i eme nesia Dawaini inarebitaba iba Yesuma utebi sinebi i nesia we me sitaro nauta. ");
INSERT INTO yrb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nautaba iba i uwara nesia Yesu atafitae anita. ");
INSERT INTO yrb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","I uwara nesia anitaba Ferosi uwarama sina we matatate weita, eawe, yanu sina nautawa utaitate i uwara nesia Danu buribi anaita weita. ");
INSERT INTO yrb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Moana Guriki uwaraini i ogaro kowaro Godibai guriguri ufitae Jerusaremu suro manita. ");
INSERT INTO yrb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","22","Iro manitate mane Firifi, dawa Gareri orofa Beseda su amara, dawabai mane fatate weita, dera amara, yana Yesu efene iba ewaro mare farisia weitaro Firifima nauite ema ekodite Enudurubai ani. Firifima Enudurubai ane weiro ema sadei Yesubai anisite weisi. ");
INSERT INTO yrb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Weisiro Yesuma wei, i Ba Eme Sini Amaranu kowa farinuba Godima Dawa ma derawere ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nanu ba sina wemaro nauawe wei, feame tai nasiniro itafite nuda ufite warafite tai faiyawere uwafisu, mena i feame yo danu torowa nasiniro daido ibifisu. Ibebe tai da uwafisu enanari Na uimauna uwara faiyawere uietaroma uyafitaita, mena uwara faiyawere uietaroma da uyafitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Anama danu ununa ewa orofaro ibifie ufisuna dawa ba uifisu wei. Anama ewa orofaro ibeta dawa unutawana dawa me ibene ibene mubite ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Anama Nanu gaukara mubite uifie ufisuna Nanu buribi ido afisu wei. Na aboro ibimauna dawaini iro Nanu gaukara amara ibifisu wei. Anama Nanu gaukara uegou ufiro Godima dawa we ma kobererau ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesuma wei, Nanu neno siosa utasu. Ane wemau? Baba, Nanu uieta kowa Nabairoma mune eta aika odia wemau? Me, eno da wemau wei, Nana eno umane iba ewa orofaro fareba uimau wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baba, Anu ifu ma derawere ua wei. Yesuma eno weina ureroma sina tararite wei, Nanu ifu botai ma derawere uete enanari nono awona ma derawere umau wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Godima urero sina eno weiro i guruguru ubita uwarama i sina nautaro nono moana uwarama weita, ure urinu weitaro moana uwarama weita, aneruma Dawaba wenu weita. ");
INSERT INTO yrb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","31","Eno weitaba Yesuma wei, i sina Naba wiawa usinute yabai wenu weite wei, Godinu koto kowa farinuba i nautawa uwaraba fanisi mafite ewa orofa yawoeta amara, seitani, mu sabiro danu bunaroma nesia dowafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na korosiro odifitaroma eme nesia we ma youre fare Nabai odimau wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Danu uieta daba emaba ma boroyariba iba eno wei.) ");
INSERT INTO yrb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Weiro i guruguru ubita uwarama weita, yanu tarawatu bukaroma eno wasu, i Mesaia da uifite me ibene ibene ibifisu wasu. Eno wasude a aneba wenu, i Ba Eme Sini Amara korosiro odifitaita weitate weita, i Ba Eme Sini Amara, Dawa anaiya weita? ");
INSERT INTO yrb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Weitaro Yesuma wei, Nanu ikiki wemaro nauawe wei, Nana dera nanefa ario ari. Yabai kikiratu ibimaro Nanu arioro afote Nanu sina nauforo dumuma ya da garari ufiro daba da iwawa ufoita. I dumuro inarebaita uwara ema iwata me aboro anebaita ari wei. Nana ario ari. ");
INSERT INTO yrb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Na naue imue ufoitana i arionu adarabu siboita wei. Yesuma eno weite ema ekodite me ari uite aniro Yesu erawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesuma buna ueta faiyawere utebiro erebitate nono imutawa utebita. ");
INSERT INTO yrb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","39","Eno utebitaba Godinu we bou ueta amara Isaiyanu bodere sina awona enanari ui. Isaiyanu bodere sinana eno, Dera Godi, yanu ba sina nautawa utaitate Yesunu buna eraitate imutawa utaitaba ibago yanu Dera Waria Amara naue imue utawa utaita, Isaiyama weite nono eno wei, ");
INSERT INTO yrb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Emanu diti ma basugari usinute emanu neno ma kimu usinuro iba ditima eotote nenoma imuotote Nabai aotote wiroaotoba, eno utaita, Isaiyama eno wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiyama Yesunu bunaini araeta erite iba eno wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Moana dera Ju yawoeta uwarama emanu naueta Yesubai oitate mui uwarabai Yesunu sina wiawa uta Yesunu sina wiotoro Ferosi uwarama ema dera dubu suroma we yoweotoba iya uyatate iba Yesunu sina wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Emanu ununa emenu we ma kobererau ueta. Ema unutawa Godima ema we ma kobererau ueta iba emebai Yesunu sina wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesuma yua weite wei, anama Na naue imue utasute Na siaia ui Godini naue imue utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Weite wei, Anama Na erasute Na sisia ui Godini erasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na ewa orofa atatanu ario ari umane iba ewaro fareba anama Na naue imue ufisuna dumuro da ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Anama Nanu sina naufite nono da ufiro dawa koto da umau. Eme koto umane farawa uete eme ma wiromane iba fare wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Anama Nanu sina nautawa utasute Na ekodasuna danu dera koto amara ibinu. Nanu watane sinama danu dera koto amara ari. Nanu watane sinama dawa duburo koto ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nanu imueta torowa wiawa utatane. Nanu Babama eno wia wasuro enanari watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Anama Nanu Babanu sina naufisuna me ibene ibene ibifisu. Nanu Babama Naba eno wia wenuba iba Nana enanari watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","I kowa me sibiro wai ufiro Godima Isaraero uwara Ijifiroma woure aneta ogaro kowa fafisu. Eno Yesu Danu uwaraba neno arama ue ane Danu urero maneta kowaroma emaba neno arama derawere ui. ");
INSERT INTO yrb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Seitanima danu do maeta imueta Judasi Isikariotiba mai. Yesuini Danu iwata ueta uwaraini ieta itebitana Yesu Dawa iwata, Godima Dawaba buna nesia mairo Godibairoma ewaro fariba enanari Godibai nono owere manibisu. ");
INSERT INTO yrb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ina iwata uite uyarite Danu dei barueta ma kosugari uite tawero munite abagoro uwani. ");
INSERT INTO yrb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Eno uite ogo munite dera disiro ma wegari uite i iwata ueta uwaranu buri ogoma uroite Danu abagoro uwani taweroma maituri. ");
INSERT INTO yrb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Enoma enoma utebe Saimoni Fitabai fari. Fariro Fitama Yesuba wei, Dera Waria Amara, nanu buri urotasu wei? ");
INSERT INTO yrb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Weiro Yesuma wei, Nanu gaukara awona iwawa utasuna duburo iwata ufasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Weina Fitama wei, kodia nanu buri da urofasu weiro Yesuma wei, anu buri da uromauna ana Nanu iwata ueta amarana me wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Eno weiba Saimoni Fitama wei, Dera Waria Amara, nanu buri torowa me, nanu ageini kofirini nesia uroa wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Weiro Yesuma dawaba wei, anama ogo tarasuna iga meba buri torowa urotasu weite wei, yana iga mero nono amara demurai dana igawere wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu Dawa iwata Danu Dawa do maeta amara iba wei, ya nesiana iga mero nono amara demurai dawa igawere wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Emanu buri uroe me sinite Danu dei barueta baruite Danu kabesiro ane yaurite emaba wei, Nanu awona yaba une imutaita aba me? ");
INSERT INTO yrb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yana Na Dera Waria Amaraini Tisa Amara waita. Yana ba waita, ina Na wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nana yanu Dera Waria Amaraini Tisa Amara, Na yanu buri uroneba yanu buri enanari uroawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na yanu Dera Waria Amara yanu buri uronero eritaba Nanu yaba une gaukara enanari utebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yesuma eno weite nono wei, Nanu ba sina wemaro nauawe wei, i gaukara amarana derawere me, danu dawa yawoeta amarana dawa derawere, enanari siaia uiro ani amarana dawa derawere me, i siaia uteda wei amarana dawa derawere wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nanu sina nautaitaba enanari ufoitana Godima yanu neno ma kobererau ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ya uwara nesiaba wiawa utatanete i Nana we mune odero ibinita uwara Na iwata utatanete emaba torowa watane wei. Eno uneba Godinu bukaro sinama wasu enanari usinu. Godinu bukaro sinama eno wasu, Naini ieta itaitu, i amarama Na do mafisu Godinu bukaro sinama eno wasu. ");
INSERT INTO yrb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","I sina yaba awona wataneba duburo enanari ufiro efote ido iwata ufote Na naue imue ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Weite nono wei, Nanu ba sina wemaro nauawe wei, anama Nanu siaia utatane uwara mubisuna dawa Na mubisu wei. Anama Na mubisuna dawa Na siaia ui Godi mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuma eno weite neno siosa uteda wei, Nanu ba sina wemaro nauawe, mui yabai ibinu amarama Na do mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Eno weiba Danu iwata ueta uwarama ere mataneda Danu sina iwawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mui iwata ueta amarama Yesubai yaubi. I amarana Yesunu unu faiya utebi amara. ");
INSERT INTO yrb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","I iwata ueta uwarama Yesunu sina iwawa utaba Fitama i amaraba age fisu uteda wei, Dana anaba wasu wenauea wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Weiro i amara Yesubai baworo yaubiba dana Yesuba wei, Dera Waria Amara, anama Aba eno ufisu wei? ");
INSERT INTO yrb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Weiro Yesuma wei, ya erebeawero ewa ieta suriaro tore mamaro mubisu, i mubisu amarama Na do mafisu weite enanari uite Saimoni Isikariotinu amara Judasiba mairo mune i. ");
INSERT INTO yrb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ie me siniro seitanima Judasinu neno ubarero itari. Yesuma Judasiba wei, anu unu gaukara sau ua wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","29","(Eno weiro i Danu iwata ueta uwarama i sina iwawa utate we imuta, Judasima yanu oi banika yawotasuba Yesuma wenu yanu ogaro ieta ane oiya ua oi ibaiabai me uwaraba oi ma weda wenu we imuta.) ");
INSERT INTO yrb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasima i ieta mune ie me sinite wawaro sau ani. Wawarona dumuwere. ");
INSERT INTO yrb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judasima wawaro aniro Yesuma wei, i Ba Eme Sini Amaranu kowa farinuba Godima Nanu buna derawere ma boroyafiro efote iba Godinu araetawere efoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Dana Godinu buna ma boroyafiro enanari Godima Danu buna awona ma boroyafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yesuma nono wei, Nanu adarabu, yabai kowa kikiratu ibimau wei. Nanu Ju uwaraba bodere we sina, enanari yaba watane. Na animauna yana Na doberebe doberebe da atafote Nanu animau kabesiro da afoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Yaba reka tarawatu eno mamau, Nanu neno yabai ibinu, enanari yanu yanu neno arama ue matanebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Orofa atata uwarama yanu neno arama ueta efitate ya uwarana Yesunu iwata ueta uwara iwata ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yesuma eno weiba Saimoni Fitama wei, Dera Waria Amara, aboro anibasu wei? Weina Yesuma wei, Nanu animau kabesiro awona Nanu buribi da afate nono duburo Nanu buribi afasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Eno weiro Fitama wei, aneba awona Anu anasu iro da animau weite wei, Aba uimau wei. ");
INSERT INTO yrb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Weiro Yesuma Fitaba wei, Naba uifasu? Nanu ba sina aba wemaro naua wei, kokora da webiro a ko Nanu ifu nesia rarogonu we ma feareda meo webasu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuma wei, neno siosa da uawete Godi naue imue uawete Naini enanari naue imue uawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nanu Babanu ibinu orofaro su faiyawere ibinu, iro su merona yaba da wemane wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Iro animate yanu su ue bou umate duburo owemate famate ya woure animau wei. Iro woure animaro yaini Naini uruama ibifeisi wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nanu animau daba ya iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yesu eno weiro Tomasima wei, Dera Waria Amara, Anu anibasu kabesini daba ya iwata meba Anu anibasu daba anene iwata ufeisi wei? ");
INSERT INTO yrb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Weiro Yesuma Tomasiba wei, Nana i urero aneta dabanu ubi, Nana i ba wetanu ubi nana i wiroetanu ubi iba mui amarama mui dabaroma Bababai da fafisu wei. Enoba Nana Bababai aneta daba demurai idoni wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Na iwata uforona Nanu Baba iwata ufoe watane wei Awonana Godi eraitaba Dawa iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Weiro Firifima Yesuba wei, Ana Baba Godi we mawetu uaro efete ya neno kobererau ufe wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Weiro Yesuma wei, Firifi, yabai kowa faiyawere ibebitarade, aneba Na iwawa utaita wei? Anama Na erinute Nanu Baba erinu wei. Aneba yanu Baba Godi we mawetu ua wenu wei? ");
INSERT INTO yrb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nanu sina naua, Nanu Babaini Naini Wa demurai, Wana arotorowa. Dana Na, Nana Dawa wei. Nanu imueta torowa wiawa utatanero Nanu neno ubarero ibinu Babama Danu gaukara Nabai utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nanu sina nauawe, Nanu Babaini Naini Wa demurai, ina imuawe. Mena bodere Nanu buna utebitara ueta sineta imuawete Naini imuawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yesuma nono wei, Nanu ba sina wemaro nauawe wei. Ana anama emanu neno Nabai odegou ufitaitana Nanu buna ueta ufitaro Na Nanu Bababai animauba emana buna ueta derarabo, Nanu otowa buna ueta ari, da ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ane Nanu ifuro wenauefitaro eno umaro Godinu buna Nabai efitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ane Nanu ifuro webote ane weboita enanari yaba umau wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesuma nono wei, Naba neno arama ufoitana Nanu sina nauegou ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Eno ufoitana Nanu Bababa eno wemau, emabai mui Durua Ueta Imumu Kotofu siaia ua wemaro siaia ufiro yabai tarafite ibene ibene ibifisu wei. I wei sina Dana Godinu Imumu Kotofu. Dawa Godinu ba sina torowa yaba we mawetu ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","We mawetu utasuro i orofa atata nautawa uwarama Dawa ere naue utawa utedaba iba Dawa munawa utaitarogo nono Dawa yabai ibinuba nono duburo yanu neno ubarero itafisuba yana Dawa iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yesuma wei, ya da kodimaro benono da ufoita yabai fare ibimau wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ewaro kowa faiya meratu ibimaro i orofa atata nautawa utaita uwarama nono Na da efitaita wei. Yana Na efoita. Na merau ibimauba yaini merau ibifoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Godinu Imumu Kotofu fafisu kowaro eno iwata ufoita, Nana Godibai ibine yana Nabai ibinita, Nana yabai ibine, eno iwata ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ana anama Nanu tarawatu nauegou ufitaitana Nabai emanu neno odifitaro Godima i uwarabai Danu neno odifisu. Odifiro Nana Nanu neno emabai odimate Nanu torowa emaba mawetu umau wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Eno weiba mui Judasi (Judasi Isikariotina me) dana wei, Dera Waria Amara, anene ya naueta uwara torowaba Anu torowa ma boroyafate i orofa atata nautawa uwaraba da ma boroyafasu wei? ");
INSERT INTO yrb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Weiro Yesuma wei, ana anama emanu neno Nabai odifitate Nanu sina nauegou ufitaro Nanu Babama emabai Danu neno odifiro Dawaini Naini emabai ibifutu wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ana anama emanu neno Nabai odawa utaitana Nanu watane sina naue enanari utawa utaita wei. Nanu imuetama wiawa utatanete Godinu imuetama watane Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yesuma wei, awona yabai ibedaba iba eno watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Duburo Godima Danu Imumu Kotofu, yanu Durua Ueta Imumu Kotofu, Nanu ifuro yabai siaia ufiro itafite ya nesia we mawetu ufite yanu beforo ma owefiro Nanu watane sina nesia imufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Wesarau ueta yabai odeda ina Nanu wesarau ueta yaba matatane. Ina i orofa atata uwaranu wesarau ueta arina me. Neno siosa da uawete iya da uyawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nana animate owemate yabai famau wenero nauita wei. Nanu Babana derawere, Nana kikiratu. Nanu Bababai animauba yana yanu neno Nabai odifote neno arama ufoitana yaru ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yabai ibeda wene sina enanari ufiro Na naue imue ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sina yafawere yaba da wemau. Ewa orofa atatanu siosa yawoeta amara fafie utasu. Danu buna derawere meba Na da yawofisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Godinu wasu sina enanari utataneba i orofa atata uwara nesia eno we imufitaita, Dawa Godi nautasute neno arama derawere utasu we imufitaita wei. Yesuma wei, uyawero ewadaroma anibe wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesuma wei, Nana i ba na didi ubi ari. Nanu Babana i beata yawotasu amara. ");
INSERT INTO yrb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nanu tai uwanawa iwarana Dana umane ture sanasute ereda kaitu ue sanasu. Nono i tai uwanasu iwara tai faiyawere uwafie iba risi risi kekerama turasu. ");
INSERT INTO yrb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","I arina yana Nanu watane sina nautaitaba Godima yanu naueta ma derawere utasu. ");
INSERT INTO yrb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yana i tai uwanasu nadidi iwara ari wei. Nabai ibegou ufoitana Na yabai ibegou umau wei. I iwara na didi ubi mena tai da uwafisu, enanari Nabai da ibifoitana yanu ueta sinetana kobererau me wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nana i nadidi ubi ari yana i nadidinu iwara ari. Anama Nabai ibegou ufiro dawabai ibegou umaro danu ueta sineta kobererau, i tai faiyawere uwanasu iwara ari wei. Na ekodifoitana Godinu unu da ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mui amarama Nabai da ibifisuna Godima dawa iwara i tai uwanawa ari mu sabiro sibu ufisu wei. Sibu ufiro iwara fira ufite inaro sabiro yafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yana Nabai ibegou ufote Nanu sina nauegou ufoitana anene wenaueforo enanari yaba ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yanu ueta sineta kobererauba emema eno imufitaita, i uwarana Yesunu ba iwata ueta uwara eno we imufitate Godi we ma derawere ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Godima Danu neno Nabai ibinu, enanari Nanu neno yabai ibinuba kobererau ibiawero Nanu neno yabai ibifi wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nana Godinu sina nauegou utatanero Danu neno Nabai ibinu, enanari yana Nanu sina nauegou utaitana Nanu neno yabai ibinu wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","I sina yaba wataneba Nanu yaru ueta yabai ibifiro yana yaru derawere ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yesuma eno weite nono wei, Nanu tarawatuna eno, Nana yaba neno arama utatane enanari yana yanu yaiyemutuba neno arama utebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mui amarama danu domayamutuba uifie neno arama derawere ufisu, ina neno arama uetanu ubi idoni wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nanu wemau sina nauegou ufoitana yana Nanu naiyemutu siboita wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ya Nanu gaukara uwara mui da wemate naiyemutu wemau. I gaukara uwarama emanu yawoeta amaranu imueta iwata me. Nanu Babanu wei sina nesia yaba wataneba iba naiyemutu watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yana Na munawa utaita. Kobere ueta uforo yanu kobere ueta me ibene ibene ibeibie iba ya munataneba anene Godibai Nanu ifuro wenaueforo yaba mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ewa tarawatu sina yaba eno watane, yana yanu yanu neno anama ue matanebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesuma wei, i orofa atata uwarama yaba neno ka utaitana Na ko neno ka utaba iba yaba neno ka utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yana i orofa atata nautawa uwara ari ibiforona ema yaba neno arama uteibitae nono Nana ya emabairoma we mune eta aika odeba ya ema ari meba iba yaba neno ka utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nanu bodere we sina imuawe. Nana eno we, i gaukara amarana derawere, i yawoeta amarana kikiratu, ina ba me. I yawoeta amarana derawere. I gaukara amarana kikiratu, eno weya wei. Na i yawoeta amaraba siosawere utaba enanari ya i gaukara uwaraba siosawere ufitaita. Nanu sina bodere naufitarona enanari yanu sina naufitae wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ewa orofa atata uwarama Na siaia ui Godi iwawa utaitaba yana Nanu uwaraba iba yaba siosawere ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Botai emabai farawa uete Nanu sina emabai wiawa uena emabai kerere me. Nono emabai farete Nanu sina emaba weba emanu kerere ibinuba yabai kerere me da webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Anama Naba neno ka utasute Nanu Bababa neno ka utasu wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mui amarama emabai mui buna ueta da ufiro nono Nanu torowa mui buna ueta emabai umarona emabai siosa uetana me. Buna eno utebitararo erebitaba Naini Nanu Baba Godini Waba neno ka uta wei. ");
INSERT INTO yrb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Emanu tarawaturo ibinu i ari ufitae iba ewa eno utaba ina ido. Ema Naba ubi mero me sarawere neno ka uta emanu tarawaturo eno ibinu. ");
INSERT INTO yrb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","I Durua Ueta Kobere Imumu Kotofu Godibairoma siaia umaro yabai itafisu. Dana Godinu ba sina we mawetu ufisu. I Imumu Kotofu, Dawa Godibairoma itafite Naba sina webisu. ");
INSERT INTO yrb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yade, boderewereroma Nabai ibeda erebitaba yana Naba sina weta uwara wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesuma wei, i sina nesia yaba weneba nono duburo yana Na da ekodifoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Moana uwarama ya Ju uwaranu dubu suroma we ma yowefitaita wei. I kowa ido fafisuba i kowaro moana uwarama Godinu gaukara ufitae webitate ya ma uifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","I uwarana Nanu Babaini Naini iwata meba iba eno ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sina eno wataneba duburo i watane sina enanari ufiro Nanu yaba we kakara utatane sina imufoita wei. Weite wei, auboko yabai ibitara iba ewa watane sina yabai wiawa ue wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","Nono awonana Na siaia ui Godi Dawabai animauba yabai mui amarama Naba A aboro anasu da webisu wei. Weite wei, A aboro anibasu wiawa utaitate Nanu wene sinaba neno arama utaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nanu sinana ba. Nanu aneta dabana kobererau. Na da animauna yanu Durua Ueta Imumu Kotofu Dawa yabai da fafisu. Nana iro animate Dawa siaia umaro yabai itafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yabai itafisuna i orofa atata nautawa uwaraba emanu neno neno ueta we mawetu ufite Godinu kobere imueta we mawetu ufite Godima koto ufite fanisi mafie wei i sina nesia we mawetu ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Na naue imue utawa utaitaba emanu neno neno ueta we mawetu ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nana Nanu Bababai animaro Na nono da efoitaba Godinu kobere imueta we mawetu ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ewa orofa atata siosa yawoeta amarama Godibai koto daido usinuba iba Imumu Kotofuma Godinu koto ueta emabai we mawetu ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nanu sina faiyawere wemaro awona iwawa uotoba iba yaba da wemau wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Godinu ba Imumu Kotofuma fafite yaba ba sina we mawetu ufisu. Danu imueta da webiro Babaini wanu sina weburo naufite i sina webite i fafisu ememetu nesia yaba webisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nanu imueta nesia mubite we mawetu ufiro nauteda Na we ma kobererau ufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nanu Babanu imueta ibaiabaina Nanuba iba wene, Nanu imueta mubite yaba we mawetu ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kowa faiya me yaini ibebe animaro yana Na nono da efote nono kowa faiya mena yana Na nono efoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Eno weiba Danu moana iwata ueta uwarama we mataneda weita, ane wenu, kowa faiya mena yana Na da efote nono kowa faiya mena nono efoita wenute Nanu Bababai animauba wenu, weitate weita, i kowa faiya me sinana ane sina? Danu sina ya iwata me weita. ");
INSERT INTO yrb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesuma emanu Dawaba wenauefitae utebita, i sina, iwata uite emaba wei, Nana wene, kowa faiya mero Na da efote nono kowa faiya mero Na efoita wene, iba iwawa uteda waita wei? ");
INSERT INTO yrb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nanu ba sina wemaro nauawe wei, yana i weda neno arama uforo i orofa atata nautawa uwarama yaru ufitaita. Yana neno arama ufote nono neno arama ekodifote yaru ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mui awetama kuita mubie uteda botai yaru da ufisu. Kuita mubitema oferi ido me sibiro i oferi woufasu da imufite kuita ido mubisuba yaru ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Enanari awonana yabai yaru me. Duburo ya emauna nenoma yaru uforo yanu yaru yabairoma moana uwarama da ma dare mubitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","I kowaro Na mui wenauereta da wenauefoita wei. Nanu ba sina wemaro nauawe wei. Nanu Bababai Nanu ifuro ane wenaueforo yaba mafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Boderewereroma are awona Yana Nanu ifuro ane wenauerawa utebita. Nono awonaroma ane Nanu ifuro wenaueawete muawete yaru derawere utebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yaba kasei sinaroma watane wei. Mui kowa fafiro kasei sinaroma da wemate Nanu Babanu sina nesia yaba ba wemau wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","I kowaro Nanu ifuro wenaueforo Bababai yaba yanu sina da wemau wei. Yanu neno Nabai oitate Na Godibairoma fare eno imutaitaba Godi Danu neno yabai ibinuba iba yanu sina Dawabai da wemau wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na Godibairoma ewa orofaro fareba nono ewa orofa ekodimate owemate Godibai animau wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesuma eno weiro Danu iwata ueta uwarama weita, ido awonana kasei sinaroma wiawa utasute ba sina wawuriro wasu weita. ");
INSERT INTO yrb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ana nesia iwata utasute yanu wenauereta iwata utasuba iba da wenauefeisi weita. Enoba Godima A siaia ui, imutaisi weita. ");
INSERT INTO yrb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Weitaro Yesuma wei, aiwia awona Na imutaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","I kowa fafie usinuba ya nesia Na ekodifote yanu su suro wo bogaru ue aniboro Nanu torowa ibimau wei. Nono Nanu aika me, Babama Nabai ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nana wene sinana yanu neno Nabai odifote kobererau ibifoe iba wene. Ewa nasiniro ibedana oferi woureiboita. Nono Nana ewa nasininu ueta sinetaini ibaiabai nesia arisiareba iba inare kimu uawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuma i sina nesia we me sinite diti urero sanite ereda wei, Baba, i kowa ido farinuba Anu amara we ma derawere uate Anu araeta mairo Anu Amara Nana A we ma derawere umane watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ana Naba weiba ewa orofa atata uwara nesia yawotataneba Ana Nanu age duro odi i uwara me ibene ibene ibeta emaba mamane watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","I me ibene ibene ibetana i ari, ana anama A, i Ba Godini, Na, Yesu Keriso, Anu siaia ui Amaraini imufitaitana emana me ibene ibene ibifitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Anu Naba mai gaukara nesia ewa orofaro ue me sinataneba A we ma derawere uteda watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Baba, boderewere, eme me, nasini me, ana oma me, i kowaro Abai ibebitararo Ana Na ma derawere uite Anu araeta mai. Awonana enanari Abai Na ma derawere uate Anu araeta Naba mai watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ana moana orofa atata uwara munite Nanu age duro odi. I uwaraba Anu imueta webitararo nautebita. I uwarana Anu uwara, iba Naba mairo Anu sina nauteda uegou utebita. ");
INSERT INTO yrb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Anu Naba mai ibaiabai nesia Abairoma farinuro iwata utaita watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Anu Naba wei sina emaba wero nautaba Ana Na siaia uiro Abairoma fare imuegou utaita watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","I uwara durua ua. I orofa atata uwara nesia durua ua wiawa utatane. Ana Nanu age duro mai uwarana Nanu uwara. Iba i uwarana Anuba durua ua watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nanu uwarana Anu. Anu uwarana Nanu. Emanu gaukaraba emema Na we ma kobererau utaita watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Awonana ewa orofa ekodimate Abai manimaro i uwara ewa orofaro ibifitaita. Kobere Baba, Anu bunama Ana Naba mai uwara yawoegou ufaro Aini Naini demurai ibinitu enanari ema demurai ibifitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ana Naba mai uwarabai ibebe ema Nanu bunama yawoegou utebitara. Eno yawoegou utebitararo moana fearawaro i Godinu bukaroma wasu amara, i uitawa ina kabesiro anibisu amara, dawa torowa fearinu. Idoro Godinu bukaroma wasu enanari ufisu watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Awonana Abai famauba i sina wataneba i uwarama Nanu yaru ueta ari yaru ufitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Anu sina Nanu uwara emaba webitararo nautebita. I orofa atata nautawa uwaranu imueta imutawa utatanero Nanu uwaraini enanari imutawa utaitaba iba i orofa atata nautawa uwarama ema neno ka utaita watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","I nautaita uwara ema ewadoroma da muate ema durua uaro seitaninu bunama ema da yawofie watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nana ewa orofa atata amarana me, enanari ema ewa orofa atata uwarana me watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Anu sinana ba, iba ema ma kakara uaro ewa sina naufitaitaba ewa orofa atatanu siosa ueta sineta ekodifitate kakarawere aika ibifitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ana Na ewa orofa atata uwarabai siaia uiro fare enanari Nanu uwara ewa orofa atata uwarabai siaia utatane. ");
INSERT INTO yrb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nana Nanu neno Abai odeda rorowarau ibebatane. Nanu ununa ema Anu sina nauteda enanari ufitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Baba, ewa uwara torowa wiawa utatane. Nono ewa uwarama Anu sina webitaro naufitaita. I naufitaita uwara nesia durua ufae watane. ");
INSERT INTO yrb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nanu ununa i uwara nesia demurai sibitate imueta demurai imufitae watane. A Nabai ibinuro Abai ibine, enanari wabai ibifitae watane. Wabai ibifitaro i orofa atata uwarama efitate Ana Na siaia ui iwata ufitae watane. ");
INSERT INTO yrb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","23","Anu araeta Naba mai enanari emaba maeba Aini Naini demurai ibinitu, enanari demurai ibegou ufero i orofa atata nautawa uwarama efita. Ana Na siaia uite Anu neno Nabai ui, enanari Anu neno emabai utasu iwata ufitae iba sina eno watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baba, Nanu ununa Ana Nanu age duro mai uwara Nabai ibeta. Ana Na boderewere, emeini nasinini ana omaini me, i kowaro Anu unu Naba uite Nanu araeta maiba iba Nanu ununa ema Nabai ibeda Nanu araeta efitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O kobere Baba, i orofa atata nautawa uwarama A iwawa utaitaro Nana A iwata utatanero ewa uwarama Ana Na siaia ui iwata utaita. ");
INSERT INTO yrb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nana Anu ifu emaba webitararo nautebita enanari wemauba Anu unu Naba ui enanari emaba ufaro Na emanu neno ubarero ibimaro ido iwata ufitae watane wei. ");
INSERT INTO yrb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuma i sina we me siniro Dawaini Danu iwata ueta uwaraini anita. Anebe ane Kidironi kafuru etarafu ane fata. I orofaro mui oriwa beata ibiro i beata wetoro fare ubarero anita. ");
INSERT INTO yrb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesuini Danu iwata ueta uwaraini bodere i orofaro ane farebitaba Judasi, Yesu do maeta amarama i orofa dawa iwata ui. ");
INSERT INTO yrb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","I dera fuyo ode sina weta uwaraini Ferosi uwarama ami uwaraini forisimani Judasiba mataro woure ani. I uwara nesia nanefaini ekiwaini ureta yanaeta ibaiabai nesia iro woure anita. ");
INSERT INTO yrb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ane fataro Yesuma i Dawabai ane fafisu ueta nesia iwata uite emaba wei, ana doberaita wei? ");
INSERT INTO yrb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Weina Yesu Nasareta Amara weita. Weitaro Yesuma wei, Na ewado wei. Judasi Yesu do maeta amara i fata uwarabai inaibi. ");
INSERT INTO yrb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuma eno weina i uwara dubenama ane dowata. ");
INSERT INTO yrb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesuma nono wei, ana doberaita? Weina Yesu Nasareta amara doberaisi weita. ");
INSERT INTO yrb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Eno weitaro Yesuma wei, Na ewadode ane doberaitaba ewa Nanu iwata ueta uwara ekodiawero anibita wei. ");
INSERT INTO yrb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Aubokona Yesuma wei, Ana Nanu agero mai uwara nesiana Nabairoma fearawa eno we bou uiba iba ewa uwara ekodiawero Nabairoma anibita sina wei.) ");
INSERT INTO yrb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yesuma eno weiro Saimoni Fitama danu ba kaiya muni. Munite i dera fuyo ode sina weta amaranu gaukara amaranu banibira ome umane kosari uiro nasiniro itari. I gaukara amaranu ifuna Marakasi. ");
INSERT INTO yrb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Fita eno uiro Yesuma wei, anu kaiya, kaiya youetaro odiate kodiaro eno ufitate emanu wakiki ogo mafitaro Nana ima wei. ");
INSERT INTO yrb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yesuma weiro i ami uwaraini emanu kafitenini i Ju uwaranu forisimanini Yesu mutate budari utate woure anita. ");
INSERT INTO yrb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ane Enasibai ko ane oita. Enasina Kaiyafasi danu darome. Kaiyafasi Dawa i botai dera fuyo ode sina weta gaukara i oyaro utebi. ");
INSERT INTO yrb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Bodere Kaiyafasima i Ju uwaraba wei, aneba ya nesia uifeisi. Amara demuraima yaba uifisu, ina ido, wei. I sina enanari ui. ");
INSERT INTO yrb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","16","I uwarama Yesu woure anebitana Saimoni Fitaini mui iwata ueta amaraini emanu buribi anisi. Ane i auboko dera fuyo ode sina weta amara Enasinu su teteuro fata. Dana i mui iwata ueta amara iwataba i iwata ueta amaraini Yesu ubarero anitaro Fitana marau bebeto wawaro inaibi. I mui iwata ueta amarama kasimu yawoeta arumaba weiro kasimu ma ifegari uite Fitaba wei, amua weiro Fitama marau ubarero ani. ");
INSERT INTO yrb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aniro i kasimu yawoeta arumama Fitaba wei, ana i Amaranu mui iwata ueta amara aba me wei? Weina Fitama wei nana me wei. ");
INSERT INTO yrb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Iwu farebiba i gaukara uwara ofe iwuma arama utate ina moataro ina gigirariro inaibita. Fitaini i ina gigirariro inaibi. ");
INSERT INTO yrb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","I dera fuyo ode sina weta amarama Yesuba wei, Anu iwata ueta uwara ana ana? Ane sina we mawetu utebasu? ");
INSERT INTO yrb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Enoma enoma webiba Yesuma wei, kiwuma we mawetu utawa utebitara. I uwara nesiabai we mawetu utebe i Ju uwaranu dubu suini i dera dubu su ubarero we mawetu utebitararo i Ju uwarama Na nautebita wei. ");
INSERT INTO yrb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aneba Na wenauerasu wei? Nanu sina nautebita uwara wenauearo Nanu sina ema iwataba aba webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Eno weiba mui inaibi forisimanima Yesunu ibo nawataro agema urite wei, aneba i dera fuyo ode sina weta amaraba eno wasu wei? ");
INSERT INTO yrb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Weiro Yesuma dawaba wei, Na ane sina siosa wenego wiaro nauma wei. Na mui sina siosa wiawa rairo aneba Na urinu wei? ");
INSERT INTO yrb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Weiro Enasima ekodite Yesu i botai dera fuyo ode sina weta amara, Kaiyafasibai siaia uiro Danu age uwane tarieta bobo woure ane oita. ");
INSERT INTO yrb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Fitama ina gigirariro inaibina i uwarama weita, ana Danu mui iwata ueta amaraba aba me weita? Weitana Fitama na me wei. ");
INSERT INTO yrb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","I dera fuyo ode sina weta amaranu mui gaukara amara, dawa i ome umane turi amaranu su amara, dana Fitaba wei, i beataro aini Dawaini ene aba me wei? ");
INSERT INTO yrb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Weiro Fitama me weina kokora ido wei. ");
INSERT INTO yrb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Waikunaro i uwarama Yesu mutate Kaiyafasinu su ekoitate i gaemani yawoeta amaranu dera suro woure ane oita. I uwara i su ubarero amutawa, emanu kakara tarawatuba. Godima Isaraero uwara Ijifiroma woure aneta ogaro itawa uotoba iba i Ju uwarama su ubarero amutawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Amutawa utaba Faeratima wawaro emabai itarite wei, ewa amaraba ane wawei sina weboita wei? ");
INSERT INTO yrb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Weiro weita, Dawa siosa ueta amara iba woure farisia weita. Merona anu agero da odifene uteibene weita. ");
INSERT INTO yrb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Weitaro Faeratima wei, yanu torowama Dawa mubote yanu tarawatuma Dawa koto ufoita wei. Weiro weita, yana Dawa da ma uifeisi, Romani gaemani uwaranu tarawatuba, weita. ");
INSERT INTO yrb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Yesuma bodere Danu uieta eno we bou ui enanari ufisu iba eno weita.) ");
INSERT INTO yrb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Faeratima i gaemani su ubarero amuite weiro enanari Yesu woure are oitaro Faeratima wei, Ana i Ju uwaranu dera yawoeta amara aba me wei? ");
INSERT INTO yrb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Weiro Yesuma wei, anu torowa wenauerasu aba moana uwarama i sina aba waitaro wenauerasu wei? ");
INSERT INTO yrb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Weiro Faeratima wei, na Ju amara me. Anu Ju uwaraini dera fuyo ode sina weta uwarama a woure are oita. A ane usinu wei? ");
INSERT INTO yrb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Weiro Yesuma wei, Na ewa orofa atata yawotawa utatane. Nana ewa nasiniro yawoeta kini uwara ari me. Na ewado yawoteimarona Nanu gaukara uwarama Na garari uteda urafitaro i Ju uwaranu age duro Na da odifasu. Nono Na ewa orofa atata yawotawa utatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Weiro Faeratima wei, Ana dera yawoeta amara wei? Weiro Yesuma wei, Na dera yawoeta amara, ba wasu. Ibago Nanu bayama Na muniro ewa orofaro farena ba sina wemane fare. I ba sina naueta uwarama Nanu sina nautaita wei. ");
INSERT INTO yrb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","39","Yesu eno weiro Faeratima wei, ba sina ina ane wei? Eno weite wawaro itarite i Ju uwaraba wei, Dawabai kerere me weite wei, ya Ju uwaranu baeta eno, Godima Isaraero uwara Ijifiroma woure aneta ogaro kowa mui muiro dibura amaraba webaitaro uregari utebataneba yanu ununa i Ju uwaranu dera yawoeta amara ma uregari umau aba me wei? ");
INSERT INTO yrb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Weina derawere weita, ewa amarana me, Barabasi ma uregari ua weita. (Barabasi, dana waira ueta amara). ");
INSERT INTO yrb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","3","Faeratima weiro danu ami uwarama Yesu mutate isuma uta. Utate sinisini bobo emetu kofi ubu utate Yesunu kofiriro barue oitate Yesunu wadia ma kosugari utate I dera yawoeta uwaranu kukui wadiawere mutate barue oita. Eno utate Yesubai fatate irue weita, Ju uwaranu dera yawoeta amara ea weda agema Yesu urebita. ");
INSERT INTO yrb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Eno utebitana Faeratima wawaro i Ju uwarabai anite wei, Yesu fafisuna Dawabai kerere me imutataneba ya imufoe iba fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","6","Eno weiro Yesuma sinisini kofini kukuiwere wadiaini baruite wawaro ido amo fari. Fariro Faeratima i guruguru ubita uwaraba wei, i amarana ewado eawe, weina i dera fuyo ode sina weta uwaraini dera Ju uwaraini emana weita, korosiro odia, korosiro odia weita. Enoma enoma webitaba Faeratima wei, Dawabai kerere me imutataneba yanu torowa Dawa muawete korosiro odiawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Weiro i Ju uwarama moko weita, yabai tarawatu ibinu weitate weita, Dawa Nana Godinu Amara weiba yanu tarawatuba uifisu weita. ");
INSERT INTO yrb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","9","Eno weitaro Faeratima nauite iyareda gaemani su ubarero amuite Yesuba wei, aboroma farinu wei? Weina Yesuma moko wiawa ui. ");
INSERT INTO yrb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Wiawa uiba Faeratima nono wei, sina naba moko wiawa? Nanu buna derawereba a uregari uawe wemaro enanari ufitaita. A korosiro odiawe wemaro enanari ufitaita rairo aneba sina moko wiawa utasu wei? ");
INSERT INTO yrb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Eno weiro Yesuma dawaba wei, Godima anu buna maiba iba Naba eno ufasu. Godima aba buna matawana Naba eno da ufasu. Ibago anu neno neno uetana kikiratu. I amarama Na anu age duro masinu, i amaranu neno neno uetana derawere wei. ");
INSERT INTO yrb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Eno weiba Faeratima Yesu ekodite i uwarabai anite Yesu uregari ufie weina i Ju uwara ema unutawa uregari uetaba weita, ewa amara uregari ufasuna ana i dera yawoeta amara Sisanu domaya me weitate weita, anama na dera yawoeta amara webisuna Sisa ma kikiratu ufisu weita. ");
INSERT INTO yrb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Weitaro Faeratima i sina nauite weiro, enanari Yesu woure i koto kabesiro oita. I Ju uwarama i kabesinu ifuna Gabata webaita. I ifunu ubina fetawawere gebiro kabesi, semenesi ari. ");
INSERT INTO yrb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","15","Godima Isaraero uwara Ijifiroma woure aneta ogaro ue bou ueta kowa ido fariro kowa mare otoro inari. Faeratima i Ju uwaraba wei, yanu dera yawoeta amara Dawa ewado weina Dawa ma uia, Dawa ma uia, korosiro odia derawere weita. Enoma enoma webitaro wei, ya Ju uwaranu dera yawoeta amara korosiro odimane waita wei? Weiro i dera fuyo ode sina weta uwarama moko weita, yanu dera yawoeta amarana Sisa. Yabai mui dera yawoeta amara me weita. ");
INSERT INTO yrb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eno weitaro Faeratima Yesu ma uifitae emanu age duro daido mai. ");
INSERT INTO yrb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","I uwarama Yesu mutaro Yesuma Danu korosi Danu torowa woure ani. Anebe anebe mui orofaro ane fari. (I orofana Kofiri Tai Torowa Orofa webaita). Ju uwaranu sinaroma Gorogata webaita. ");
INSERT INTO yrb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","I orofaro fatate Yesu korosiro oita. Mui amara enabira afu mui korosiro ure oitate mui amara enabira afu mui korosiro oitate Yesu abana mui korosiro oita. ");
INSERT INTO yrb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Faeratima sina yanaite i korosi deiro odi. I sinana eno owawa ue odi, Yesu Nasareta Amara, Ju uwaranu Dera Yawoeta Amara. ");
INSERT INTO yrb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Faeratima i sina Ju uwaranu sinaroma odite Romani uwaranu Ratani sinaroma odite Guriki sinaroma odi. I sina rarogonuroma odite Yesunu korosi deiro odi. I kabesi Jerusaremu su baworoba Ju uwara faiyawerema i sina yawitebita. ");
INSERT INTO yrb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","I dera fuyo ode sina weta uwarama Faeratiba weita, Ju uwaranu dera yawoeta amara eno da owawa ua weitate weita, ewa amara danu imueta iba wenu, Nana Ju uwaranu dera yawoeta amara eno owawa ua weita. ");
INSERT INTO yrb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Weitana Faeratima wei, eno owawa ue odineba enanari ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","I ami uwarama Yesu korosiro oitate Yesunu wadia mune nata nata utate kabesi fo (4) ode ode uta. Ami uwara foma (4) Yesu korosiro oitaba iba eno uta. Danu dei baruetaini mutaro nono i dei baruetana kobere wadia, abanaro fifinu ueta me. I wadia deiroma wowonaro rorowarau ubu uiba i ami uwarama we mataneda weita, ewa wadia da ma babafete kasi waribo ufero anama mubisu weita. Godinu bukaroma wasu sina enanari ufisuba iba eno uta. Godinu bukaroma wasu, Nanu wadia mune nata nata ufitate Nanu dei baruetaba kasi waribo ufitaita, eno wasuba iba i ami uwarama enanari uta. ");
INSERT INTO yrb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesunu danuaini Kirofasinu aweta Merini Meri Megidarina awetaini Yesunu korosi gigirariro fare inaibita. ");
INSERT INTO yrb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Inaibitana Yesuma Danu danuaini Danu iwata ueta ubi amara erite Danu danuaba wei, baya, anu amara ewado ea wei. ");
INSERT INTO yrb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Weite Danu iwata ueta amaraba wei, i awetana anu anua ewado ea wei. Eno weiba duburo Danu iwata ueta amarama Danu danua ido danu suro odifie muni. ");
INSERT INTO yrb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Eno webina Yesu Dawa iwata Danu me sibisu kowa fariba wei, Na ogo nodo utasu wei. Godinu bukaroma wasu sina enanari ufisuba iba eno wei. ");
INSERT INTO yrb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","30","Mui diririwere ana tai dumamu okiaro ibiro uriri ari emetu mutate isuro uwatate dumamuro ma inutate Yesunu bebeturo oitaro Yesuma ite wei, Nanu gaukara ido me sininu wei. Weite Danu kofiri tafu uite ido ui. ");
INSERT INTO yrb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","I kowana i Ju uwaranu sabate ue bou ueta kowa. I sabate kakarawere, Godima Isaraero uwara Ijifiroma woure aneta ogaro i kowaro fafisuba. Ibago i Ju uwara unutawa i amara rarogonu korosiro ibetaba Faeratiba weita, i amara rarogonunu buri ma furiawete woure ane odiawe weita. ");
INSERT INTO yrb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eno weitaba ami uwarama anitate enabira afu amaraini enabira afu amaraini emanu buri ma furiata. ");
INSERT INTO yrb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma furiatate Yesubai fatate etana Yesu uiba Danu buri ma furiarawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma furiyarawa utaro mui ami amarama wari munite Yesunu gaumaro yanairo ogoini onono ido fare itari. ");
INSERT INTO yrb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","I ueta sineta na nesia ereba iba owawa odatane. Nanu sinana ba iba owawa odataneba ya eforo yanu naueta derawere ufie watane. ");
INSERT INTO yrb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Godinu bukaroma wasu sina enanari ufisuba ina nesia enanari ui. Godinu bukaroma eno wasu, Danu mui tairatu da ma furiafitaita, eno wasute nono mui sina eno wasu, emanu gaumaro yanata amara nono efitaita, eno wasu. ");
INSERT INTO yrb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Duburo Jousefa, Aramatia su amara, dawa i Ju uwaraba iyariba Yesu kiwuma nautebi, dawa Faeratibai Yesunu ofe mubie anina Faeratima ido wei. Ido weiro Jousefama Yesunu ofe korosiroma munite ani. ");
INSERT INTO yrb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimasi, dawa bodere dumuro Yesubai fari, i amarama uri oeta bonanawere fauda, danu ifuna muraini aroaini, ina faiyawere, danu urumuna fifiti (50) kiro, woure fari. ");
INSERT INTO yrb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wo fariro Jousefaini Nikodimasini Yesunu ofe musite kobere inawere wadia musite i fauda bobo Yesunu ofe wayasi. I Ju uwaranu baeta eno iba eno uta. ");
INSERT INTO yrb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesunu korosi oeta kabesi gigirariro mui oriwa ana beata ibi. I beataro reka uri oeta erabo mui amara iro odawa, kabesi ibi. ");
INSERT INTO yrb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","I Ju uwaranu sabate sau fafisuba i uri oeta kabesi baworoba i amara sadeima Yesu mune iro ane ma aine oisi. ");
INSERT INTO yrb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sabate kowa me siniro waikukuro Meri Megidarina i uri oeta eraboro fari. Fare erina uri garari ueta gebiro mu saniro eta aika ainibiro eri. ");
INSERT INTO yrb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Eno erite owerite Fitaini etei Yesunu unu faiya utebi iwata ueta amarabai durami ue ani. Emabai ane farite wei, yanu Dera Waria Amara eraboroma munitate aboro oita ari na iwata me wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Fitaini etei mui iwata ueta amaraini uri oeta eraboro durami ue anisi. ");
INSERT INTO yrb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Anisina etei mui iwata ueta amarama Fita serigari uite i eraboro dawa ko ane fari. ");
INSERT INTO yrb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dawa ko ane farite tafu uite erabo ubarero erina i inawere wayata wadia ainibiro erite iro itarawa ui. ");
INSERT INTO yrb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Itarawa uina Fitama danu buribi farite i erabo ubarero itari. Itarite i ainibi inawere wadia erite Yesunu kofiri wayata wadia uregari utawaro i mui wadiabai ainawa, danu kabesiro eno ura ue odiro ainibiro eri. ");
INSERT INTO yrb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Eriro mui dawa ko fari iwata ueta amarama itarite ereda Yesu uietaroma uyarinu imui. ");
INSERT INTO yrb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Boderena Godinu bukaro Yesu uietaroma uyafisu wei sina iwawa usite esite imusi.) ");
INSERT INTO yrb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","I iwata ueta amara sadei ido owesite emanu suro anisi. ");
INSERT INTO yrb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Merima i eraboro nono fari. Fare bebeto gigirariro inaibeda i webi. I weda kofiri tafu uteda erabo ubarero erina inakeorau wadia bobo aneru sadei mui kofiri afu kabesiro yauriro mui buri afu kabesiro yauriro eri. ");
INSERT INTO yrb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eriro i aneru sadeima weisi, aweta, aneba i wasu weisi? Weisiro wei, Nanu Dera Waria Amara ewadoroma munitate aboro oita ari na iwata meba iba i watanea wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Eno weite owerite Yesu ereda Dawa Yesu iwawa ui. ");
INSERT INTO yrb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iwawa uiro Yesuma wei, aneba i weda, ana doberasu wei? Weiro Merima Dawana beata yawoeta amara imuite wei, amara, ana Dawa ewadoroma wourinute mui orofaro ane odinuba i orofa wiaro iro animate Danu ofe woure animau wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Eno weiro Yesuma wei, Meri. Eno weina Meri owerite Yesu iwata uteda Ju uwaranu sinaroma wei, Rabonai wei. (I sinanu ubina nanu tisa amara.) ");
INSERT INTO yrb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuma Meriba wei, Nanu Bababai manawaya Nanu ofero da mamiate Nanu iwata ueta uwarabai aniate eno wia, Nana Baba Godibai manatane. Nanu Baba yaini yanu yamama, Nanu Godi yaini yanu Godibai manatane wia wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Eno weiba Meri owerite ani. I iwata ueta uwarabai ane farite wei, yanu Dera Waria Amara ene weite Yesunu wei sina nesia emaba enanari wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","I kowana Sade kowa, yawi siniro i iwata ueta uwarama suro yaubita. I uwarama Ju uwaraba iyataba kasimu garari uta. Kasimu garari utaro Yesuma i su ubarero emabai me ari uite inaibeda wei, iya da uyawete merau ibiawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Weite Danu ageini Danu gaumaini emaba mawetu ui. I iwata ueta uwarama i Dera Waria Amara etate neno kobererau utate yaru uta. ");
INSERT INTO yrb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesuma emaba nono wei, merau ibiawe wei. Nanu Baba Na siaia ui enanari Nana ya siaia utatane wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Weite Danu bebetu oeno emanu deiro ubuite wei, Godinu Imumu Kotofu muawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Weite nono wei, yana uwaraba eno weboita, yanu neno neno ueta muneda imutawa usinu, weboitana enanari ufisu. Nono yanu neno neno ueta munawa usinu weboitana enanari emabai emanu neno neno ueta daido ibifisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesu fare eno utebina Tomasi, sokaka waita amara, dawa i uwarabai ibawa ui. ");
INSERT INTO yrb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Dawa fariro i iwata ueta uwarama dawaba weita, yana i Dera Waria Amara erisi weita. Weitaro Tomasima wei, nanu age rorouma Danu age amairo da burimate nanu agema Danu gauma amairo da maimauna da imumau weite wei, agema amairo burimauna imumau wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kowa eita (8) me siniro i iwata ueta uwaraini Tomasini suro nono yaubita. Kasimu garari utate yaubitaro Yesuma nono emabai me ari uite inaibeda wei, iya da uyawete merau ibiawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Eno weite Tomasiba wei, Nanu age eate anu age rorouma buriate anu age Nanu gauma amairo buria. Aneba imutawa? Eno da uate imuegou ua wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Weiro Tomasima wei, Ana nanu Dera Waria Amara ubi. Ana nanu Godi ubi wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Weiro Yesuma Tomasiba wei, ana Na erinuba iba naue imue usinu weite wei, ana anama Na da efitate me naue imue ufitaitana emana yaru derawere wei. ");
INSERT INTO yrb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuma buna ereta faiyawere utebiro Danu iwata ueta uwarama i nesia erebita. Nono i ereta nesia ewa bukaro owawa ue odawa ue. ");
INSERT INTO yrb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","I owawa ode buna ueta efote Yesu Dana Godinu we mune odi Amara, Dana Godinu Amara imufote me ibene ibene ibifoita. ");
INSERT INTO yrb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesuma Danu torowa Gareri mesauro nono emabai fariro Danu iwata ueta uwarama Dawa eta. Ina eno ui. ");
INSERT INTO yrb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimoni Fitaini Tomasi, sokaka waita amaraini, Natania, Gareri orofa Keina su amaraini, Jebedinu amara sadeini Yesunu mui iwata ueta amara sadeini yaubita. ");
INSERT INTO yrb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Yaubitana Saimoni Fitama wei, na erio egi woumane anatane, weina yaini anibeisi weita. Weitate anitate boutiro amutate jawe ure anita. Anitate i dumuro erio egi wourawa daido me yaubita. ");
INSERT INTO yrb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Waikukuro Yesu maguaro inaibiro Danu iwata ueta uwarama etate Dawa iwawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesuma wei, masigu, erio egi wourita aba me wei? Weina me weita. ");
INSERT INTO yrb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Weitaro Yesuma wei, yanu ogo egi woureta woto banibira afu sawete erio egi wouawe wei. Weiro enanari utate erio egi faiyawere iba emanu woto woure amutawa uta. ");
INSERT INTO yrb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesunu iwata ueta ubi amarama wei, Dana yanu Dera Waria Amara wei. Weiro Saimoni Fitama nauite seti meba danu dei wadia mune baruteda ogoro bibu urite aine maguaro ani. ");
INSERT INTO yrb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Eno uina i moana iwata ueta uwarana boutiro anita. Ane erio egi wate fari woto ma youre maguaro ane fata. Emanu daba yafa me, fuyaratu, wani aderedi (100) mita torowa. ");
INSERT INTO yrb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Maguaro ane fatate etana Yesuma erio egini buredi ina imuro abuna utebiro eta. ");
INSERT INTO yrb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuma wei, yanu moana wourita erio egi woure arawe wei. ");
INSERT INTO yrb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Weiba Saimoni Fitama boutiro anite erio egi bobo woto fokia ma youre maguaro odi. Wotoro erio egi wanaderedi fifiti tiri (153) faiyawererogo woto ma babarawa ui. ");
INSERT INTO yrb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuma emaba wei, arawete ieta iawe wei. Eno weiba Danu iwata ueta uwarama a anaiya wenauerawa utate Dawa iwata uta. ");
INSERT INTO yrb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesuma buredini erio egi munite emabai ane nata nata ui. ");
INSERT INTO yrb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesuma uietaroma uyarite Danu iwata ueta uwarabai kowa sadei fariro eta. Etaro inarebe ewana nono ane fariro eta. ");
INSERT INTO yrb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ieta ie me sitaro Yesuma Saimoni Fitaba wei, Joninu amara Saimoni ewa uwaranu neno arama ueta ari mero ana Na neno arama derawere utasu aba me wei? Weiro Fitama wei, aiwia Dera Waria Amara, A iwata Aba neno arama utatane wei. Weiro Yesuma wei, mamoe yawoeta amarama mamoenanatu ieta matasu enanari Nanu mamoenanatu ari Nanu Na naue imue utaita uwaraba Nanu sina wia wei. ");
INSERT INTO yrb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Weite Fitaba nono wei, Joninu amara Saimoni, ana Na neno arama utasu aba me wei? Weiro Fitama Dawaba wei, Aiwia, Dera Waria Amara, A iwataro Aba neno arama utatane wei. Weiro Yesuma wei, mamoe yawotasu amarama mamoenanatu yawotasu enanari Nanu Na naue imue utaita uwara yawoegou ua wei. ");
INSERT INTO yrb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesuma Saimoni Fitaba rarogonu nono wei, Joninu amara Saimoni, Naba neno arama utasu aba me wei? Eno rarogonu weiba Fitama neno siosa uteda wei, Dera Waria Amara, A nesia iwata utasute A iwataro Aba Neno arama utatane wei. Weiro Yesuma dawaba wei, mamoe yawoeta amarama mamoe ieta matasu enanari Nanu Na naue imue utaita uwaraba Nanu sina wia wei. ");
INSERT INTO yrb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yesuma eno weite nono wei, Nanu ba sina wemaro naua wei. A reka amara sinite inareda anu wadia baruite anu unu daba aboro aboro anibae uite enanari ui wei. A ofe kimu sibate anu age sabaro mui amarama anu ofero wadia ma barufite anu agero maibite anu unu dabana me, danu unu aika dabaro a woure anibisu wei. ");
INSERT INTO yrb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesuma Fitanu uieta daba ma boroyafiro Fitama Godinu ifu ma derawere ufie iba eno wei.) Eno weite wei, Nanu buribi arate Na da ekodia wei. ");
INSERT INTO yrb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Yesu eno weiro Fitama owere erina Yesunu unu faiya utebi iwata ueta amara, i amarama auboko ieta nabero itebita kowa muiro Yesubai yaubeda wei, Dera Waria Amara, anama Aba do mafisu wei? ");
INSERT INTO yrb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","I amarama emanu buribi fariro Fitama erite wei, etei amarade? ");
INSERT INTO yrb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Weiro Yesuma dawaba wei, dawa da uifite me ibifiro Na famate ina Nanu unu umauna ina anu uetana me. Enoba Nanu buribi arate da ekodia wei. ");
INSERT INTO yrb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesuma eno weiba i sina Yesunu sina naueta uwarabai eno we inarebita, Yesunu unu faiya utebi mui iwata ueta amara da uifite me ibifisu eno we inarebita. Yesuma eno wiawa uite eno wei, Dawa da uifite me ibifiro Na famate ina eno umauna ina anu uetana me, eno torowa wei. ");
INSERT INTO yrb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","I iwata ueta amarana na Joni. Nana nesia ereba nanu sinana ba iba owawa ue odatane. ");
INSERT INTO yrb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuma ueta faiyawere utebi. Danu ueta nesia buka faiyawerero odifitarona i orofa atata su nesia kikiratuba iba wate fafitae uyafitae wei. ");
INSERT INTO yrb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Nanu naiye warai, Tiafarasi, nanu botai owawaro Yesu Danu botai gaukara tutubari ui i odoroma i ue arebi ueta sineta abai wero naui. Eno ue arebe Godima Dawa muniro urero mani i odoro Danu we muneta uwaraba Godinu Imumu Kotofunu bunaro iba sina webi. ");
INSERT INTO yrb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","4","Yesuma ba uite uietaroma uyarite emaba Danu torowa ma boroyariba Dawa uitawa awonana urero me ibinu. Dana emabai sakara demurai kowa teni, ina nesia kowa foti (40), ibeda Godinu yawotasu orofaba weda wei, Jerusaremuro ibeda aika da aniawe wei. Nono emaba wei, ewaro yawoawe weite wei Godinu we bou ui sina bodere wero nauta enanari ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","I ari Jonima ogoma eme babataito utebi. Duburo kowa faiya me, me sibisuna Godima ya nesia Danu Imumu Kotofuma babataito ufisu Yesuma wei. ");
INSERT INTO yrb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","I uwara guruguru utate Yesuba wenauetate weita, Dera Waria Amara, awona i yawoeta orofa Isaraero uwaraba mafasu aba me weita? ");
INSERT INTO yrb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wenauetaro wei, Godima torowa kowaini wai nesia odiba ya da iwata ufoita wei. ");
INSERT INTO yrb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Imumu Kotofuma yabai itafisuba buna ufote Nanu fo weta uwara sibote Jerusaremuini Judiaini Samariaini i orofa ata nesia Nanu sina we inareiboita wei. ");
INSERT INTO yrb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","I sina Weiro nautate erebitaro Yesu ido urero mani. Maniro gosoma garari uiro Yesu erawa uta. ");
INSERT INTO yrb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","Yesuma ido manebiro erebitana mui wadia inakeo bobo amara sadei emabai fare inaibeda weisi, ya Gareri uwara aneba inaibeda etu urero eraita weisi? Yesu i manasuro eraita enanari ewaro eno owefite fafisu weisi. ");
INSERT INTO yrb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Oriwa maidani sabate kowaro inareta daba ni yafa meratu Jerusaremu su baworo. ");
INSERT INTO yrb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","14","Iroma Jerusaremu suro are fatate emanu su ubarero amuta. Fitaini Jonini Jeimisini Enuduruini Firifini Tomasini Batoromuini Matiuini Arofiasinu amara Jeimisini Keinani orofa amara Saimonini Jeimisinu amara Judasini moana awetaboini Yesunu danua Merini Danu daburetaini ema ainewaure guriguri utedibebita. ");
INSERT INTO yrb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","I kowaro Fitama uyarite guruguru ubita uwara faiyawere, wani aderedi tueniti (120) emaba wei, masigu, Godinu bukaro wei, enanari ui. Imumu Kotofuma Judasinu ueta nesiaba Deiwidinu bebeturoma wei. I amarama Yesuba do maiba Yesu muta. ");
INSERT INTO yrb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","19","Dawaini yaini ibeda Yesunu gaukara uteda i Judasi danu do maeta oima nasini oiya uite anite urei. Ureiro desini babariro yajiwa fariro Jerusaremu su uwara nesia iwata utate i nasini Ekedama mamita. I sinanu ubina onono nasini mamita wei. ");
INSERT INTO yrb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Fitama nono wei, Godinu buka Samusiro ewa sina ibinu, Danu su me ibifiro mui amara iro da ibifiro mui amarama danu kabesi mubisu. ");
INSERT INTO yrb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ewa sina Samusi bukaro ibinu weite wei, Jonima Yesu babataito ui. I kowaroma ane fare utebe urero mani kowa erebi amara mubero fafite Yesunu uyareda ui sina fo weta amara sibi wei. ");
INSERT INTO yrb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","25","Weiba ifu sadei oita. Mui amaranu ifuna Jousefa, danu mui ifuna Basabasi, danu mui ifuna Jasitasi oitate mui amaranu ifuna Mataiusi oitate guriguri utate weita, O Dera Waria Amara, Ana uwara nesianu neno iwata utasuba abo amara Judasinu ekodi kabesi mubisu weita? ");
INSERT INTO yrb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Weitate erawa utate mui ifu mutate etana Mataiusinu ifu muta. Eno utaba Mataiusima mui afosoro tueronu (12) kabesi munite mui afosoro amara sini. ");
INSERT INTO yrb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Fenitikosi kowa ido fari. Fariro i uwara su demurairo yaubita. ");
INSERT INTO yrb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","3","Yaubitaro ureroma rurua oyabibi ari sau tararite i su inune uiro ina kuido ari bububu ui. Eno uite i uwaranu deiro yaure yaure ui. ");
INSERT INTO yrb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Uiro Godinu Imumu Kotofuma tararite i uwara nesianu neno ubarero inune uteda iwata mairo sina aika maika webita. ");
INSERT INTO yrb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","6","Jerusaremu suro naueta Ju uwara faiyawere yaubita. Mui orofa atataroma fatate yaubebe i rurua nautebitaba iro anitate emanu aika maika sina tanana naue naue utate neno kirifu derawere uta. ");
INSERT INTO yrb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Eno utate we imuteda weita, i sina waita uwarana Gareri uwara. ");
INSERT INTO yrb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Anene yanu ba sina waitaro yanu sina tanana nautaisi weita? ");
INSERT INTO yrb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Orofa atata aika maikaroma fata. I orofanu ifu ifuna ewado, Fatiaini Midini Iramaitini Mesofateimiaini Judiaini Kafadosiaini Fonitusini Eisiaini Furigiaini Famufiriaini Ijifini Ribia Sairinabaini Romanini iroma ba Ju uwaraini Jubai guriguri utebita aika uwara, Kuritini Areibia orofa uwaraini Jerusaremu suro fatate nauteda Godinu buna ueta yanu ba sinaroma waitaro nautaisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Weitate neno kirifu utate we imuteda moanama weita, ewa ane weita? ");
INSERT INTO yrb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Weitaro moanama irutate weita, reka waini ogo ita iba eno waita weita. ");
INSERT INTO yrb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","I nautebita uwarama eno weitaba Fitaini i amara ireweni (11) ido uyatate Fitama wei, nanu Ju uwaraini Jerusaremu suro yaubinita uwara nesia, nanu sina nauegou uawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","16","Ewa uwara reka waini ogoma arama utawa. Awonana kowa abanarowere iba ewa uwara waini itawa wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Iba Godinu bodere we bou ueta amara Joerama eno wei, Godima wasu, dubu kowaro Nanu Imumu Kotofu siaia umaro uwara nesiabai itafisuba yanu arumamini adarabuini sina we bou ufitaita. Ufitaro yanu reka masigu tubetube efitaro yanu baeta uwara tuberoma efitaita. ");
INSERT INTO yrb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Efitaro Nanu Imumu Kotofu siaia umaro Nanu waiya ueta aruma amara nesiabai itafisu. Itafisuba sina we bou ufitaita. ");
INSERT INTO yrb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Ufitaro urero buna ueta umate nasiniro buna ueta umate ononoini inaini giborini umaro kowa ario mero dumu torowa. Sakara onono ari sibiro nono i Dera Waria Amaranu bunawerero ario derawere fareta kowa ido fafisu. ");
INSERT INTO yrb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Anama i Dera Waria Amaraba ya ma wiroa webitaitana ma wirofisu, Godima wasu Joerama eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Fitama i uwaraba eno weite nono emaba wei, Isaraero uwara nanu sina nauawe wei. Yesu Nasareta Amaraba watane wei. I Amara Godima muniro ya nesia Danu neno kirifu uetaini Danu buna uetaini Danu ueta nesia eta. Godima yaba i ueta Yesubai uiro ereda iwata uta. ");
INSERT INTO yrb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Godima imuite Dawa yabai mairo yana sina webe webe utebitaba aika uwarama korosiro oitaro ui. ");
INSERT INTO yrb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Uiro Godima ma uyariba Dawa nono da uifite me ibene ibene ibeibiro uietama Dawa da mubisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","26","Deiwidima Yesunu sina eno wei, nana erebatanero Godima nabai me ibene ibebe ibeda nanu banibira age afu ibebasuba neno ubarero iya da uyamauba nanu nenoma yaru uete nanu bebetuma yaru ueta sina we. wete i duburo fafiro mumau daido ba yawotatane ");
INSERT INTO yrb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nanu imumu Eidisiro da ekodifiro anu kakara amaranu ofe yajara da ufisuba iba ewa orofaro ibimauna da iyamau. ");
INSERT INTO yrb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ana i me ibene ibene ibeta muneta daba naba ma boroyarite nabai ibebasuba na yaru umau, Deiwidima eno weiro Fitama eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Eno weite wei, nanu naiyemutu, i sina ma boroyamane watane wei. Yanu waria amara Deiwidi uiro uri utaro Danu uri oeta kabesi ewaro ibinu. ");
INSERT INTO yrb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Deiwidina we bou ueta amara. Godima ba webou uiro Deiwidi dawa iwata ui, Godima danu mui sirorari amara mubite dera yawoeta amaranu yauretaro odifisu. ");
INSERT INTO yrb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawa iwata uite Yesunu uyareta kowa imuite iba weite wei, Danu Imumu uieta orofaro ekodawa uiro Danu ofe yajara utawa ui, Deiwidima eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Fitama weite wei, Godima Yesu uietaroma ma uyariro ya nesia esi. ");
INSERT INTO yrb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Godi Danu banibira buna agema Yesuba ma ario uite wei, Imumu Kotofu aba mamau wei. Enanari mairo muniba eretaini uetaini nesia Dawabairoma arasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Fitama eno weite wei, Deiwidima urero anawarogo ewa sina wei, i Godima Nanu Dera Waria Amaraba wei, Nanu banibira age afu yauaro aba wasai utaita uwaraba buna umate mumate Anu buri eminaro odimau Godima weiro Deiwidima eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Fitama eno weite wei, Isaraero uwara, ewa Yesu yana korosiro oita Amara, Godima Dera Waria Amaraini Keriso mamiba imufoe watane wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Weiro nautate neno siosa uteda weita, anene ufeisi weita? ");
INSERT INTO yrb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Weitaro Fitama wei, yanu siosa uetaini imueta dubena afu sawete Yesu Kerisonu ifuro babataito uawero Yesu Kerisoma yanu neno neno nesia mubite imutawa ufite Godinu Imumu Kotofu mafiro muboita wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Weite wei, i we bou ueta yaini yanu koiniboroini aika maika Godinu yua webisu uwaraini ya nesia yanu we bou ueta wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Enoma enoma webe wei, ewa siosa sirorari ueta ma wiroawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Fita danu sina nautebita uwara babataito utaro eme faiya faiyawere tiri tausani (3,000) i afosoro uwara emabai ane taka uta. ");
INSERT INTO yrb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eno utate ainewaure guruguru utebitate afosoro uwaranu sina nautebitate emanu owiga ueta utebitate ieta ma birabiarebitate iteda imutebita. Yesu yaba uiba yaru utaisi imutebitate guriguri utebita. ");
INSERT INTO yrb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Godima Danu afosoro uwara buna mairo buna ueta utebitaro uwara nesia iyarebita. ");
INSERT INTO yrb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","45","Imueta uwara daba demurai nesia ma dinunu utate i naueta uwara nesia arotorowa utate emanu nasini ibaiabai oiya ue matate ibaiabai me uwaraba nata uta. ");
INSERT INTO yrb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Eno utate imueta demuraiba dera dubu su ubarero amutebitate su aika maika ieta ma birabiarebitate ieta yaru bobo nata utebitate Godiba we ma kobererau utebitate uwara nesiaba wesa utebita. Godima moana uwara ma wiroteda i naueta uwarabai odebi. ");
INSERT INTO yrb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mui yawiro guriguri kowa fariba Fitaini Joni dera dubu suro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Guriguri ufisie anebisiro mui amara danu danuama dawa muni, iroma buri arama uiba moana uwarama dera dubu su kobere kasimubai woure ane odebitaro yaubeda oi nui webi. ");
INSERT INTO yrb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","4","Fitaini Jonima dera dubu suro anebisiro i amara sadei ereda nui weiro dawa esite Fitama wei, Jonini wa ea wei. ");
INSERT INTO yrb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","6","Weiro i amara oi mubie waita weda eregou uiro Fitama wei, na oi me. nanu nabai ane ibinu ima aba mamau wei. Yesu Keriso Nasareta Amaranu ifuro uyate ania wei. ");
INSERT INTO yrb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Weite danu agero mamite ma uyariro danu buri ekini burini nabi uiro wiroite ido uyarite ani. ");
INSERT INTO yrb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ane Fitaini Jonini dera dubu su ubarero amuite bibu ureda Godiba we kobererau ui. ");
INSERT INTO yrb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Eno utebiro i uwara etate i amara kobere kasimubai yaubeda ane aneba nui webasu amara iwata uteda danu nabi uite wiroi iba neno kirifu derawere uta. ");
INSERT INTO yrb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","I amara Fitaini Joninu age mamiro i uwara Soromoninu ofadaro sau durami ue are fata. ");
INSERT INTO yrb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Fataro Fitama wei, Isaraero uwara aneba neno kirifu uitate igera utaita wei? I amaranu buri wanu bunaini kobererau uetama ma nabi uitu eno we imutaita wei? ");
INSERT INTO yrb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Weite wei, Eibaramuini Aisikini Jeikofunu Godi, yanu babamutunu Godima Danu waiya ueta Amara Yesu we ma derawere usinuba Dawa ma nabi usinu. I kobere kakara Amara Faeratibai oitate wawei weitaro Faeratima Dawabai kerere meba me siaia ufie ui. ");
INSERT INTO yrb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","15","Eno uiro yanu unu utawa Dawa me siaia ueta. Iba eme ma uietaini sara siosa ueta amara mafie nui weitate nono i me ibeta maeta Amara ma uitaro Godima uietaroma ma uyariro ya nesia esi. ");
INSERT INTO yrb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesunu ifuma ma nabi usinu weite wei, i ifuro imuituba i amara kobererau yanu iboro ma nabi usinuro i amara ereda iwata utaita weite wei, ba watane. Yesu Kerisoro imuituba i amara kobererau ma nabi usinuro buna usinuro eraita wei. ");
INSERT INTO yrb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","18","Fitama nono wei, naiyemutu, na iwata utatane. Yaini yanu dera uwaraini bodere yanu utebita inu ubi ya iwata meba iba eno utaba Godima Yesunu oferi woureta Danu we bou ueta uwaraba wei enanari ui wei. ");
INSERT INTO yrb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Iba yanu sara siosa uetaini imueta dubena sabote Godibai owefoitana yanu sara siosa uetaini imueta maitufiro me sibiro Godima yabai ibeda yanu imoieta kowa faiyawere yabai siaia ufiro fafisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Boderewere i Keriso, Godinu munite yaba mateda weite mai Amara Yesu, yabai siaia ufisu. ");
INSERT INTO yrb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Awona Dawa urero ibinuba duburo orofa atata ma wiroeta kowa me sibiro ido tarafisu wei. Bodere Godima Danu we bou ueta uwaraba i kowa wei, Fitama wei. ");
INSERT INTO yrb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nono wei, Mosesima eno wei, Godima yabairoma mui we bou ueta Amara na ari mubiro Danu sina anene webiro naufoita. ");
INSERT INTO yrb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Anama Danu sina da naufisuna ma uifisu Mosesima wei. ");
INSERT INTO yrb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","I we bou ueta uwara nesia Samuerobairoma eno webita Fitama wei. ");
INSERT INTO yrb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","26","Ya nesiana we bou ueta uwaranu adarabu. Yana Godinu we bou ueta naueta uwara. Godima Eibaramuba we bou uiro yanu babamutu nautaro awona ya nesia nautaisi. Godima Eibaramuba wei, anu koiniboroba i orofa atata uwara nesia we ma kobererau umau, Godima eno wei. Godima Danu waiya ueta Amara Yesu, ma uyarite yabai ko siaia ui. Eno uite yanu neno neno uetabairoma ya nesia ma owefite we ma kobererau ufie uteda iba siaia ui wei. ");
INSERT INTO yrb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Fitaini Jonima i guruguru ubita uwaraba sina webisiro fuyo ode sina weta uwaraini dera dubu su forisi kafitenini Sadusi tisa uwaraini emabai ido are fata. ");
INSERT INTO yrb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","3","I afosoro amara sadeima Yesu uietaroma uyari enanari eme nesia uietaroma uyafitaita, we mawetu utebisiba iba dera uwara ibo utate emabai fatate dumu gisigisi utebiro fatate budari utate ana ebaro oita. ");
INSERT INTO yrb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Eme faiyawere Yesunu uietaroma uyareta sina nautate moana nautawa utaro moana naue imue uta. Godinu sina naueta uwara nesina fai tausani (5,000) faiya faiyawere. ");
INSERT INTO yrb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Wai uriro Ju dera uwaraini baeta uwaraini Mosesinu tarawatu tisa uwaraini nesina Jerusaremu suro guruguru uta. Utaro i dera fuyo ode sina weta amara Enasini danu dera uwara Kaiyafasini Jonini Arekisanaini danu su uwaraini emabai Jerusaremu suro are fata. ");
INSERT INTO yrb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Are fatate moana uwarama i afosoro uwaraini buri arama bobo ma wiroeta i amaraini guruguru ubita uwarabai woure are abanaro oita. Oitaro kanisoro uwarama weita, yanu iboro inawe weitate nono weita, ewa anene usi? ");
INSERT INTO yrb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Ananu bunaro o ananu ifuro eno usi weita? Eno weitaro Godinu Imumu Kotofuma Fitanu neno ubarero inune uiba Fitama yare wei, ewa uwara dera uwaraini baeta uwaraini nanu sina nauawe weite wei, i amaranu buri wiroeta wenaueraita wei? ");
INSERT INTO yrb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","I wiroeta ubi wemaro yaini Ju uwara nesiaini nauawete iwata uawe wei. Yesu Keriso, Nasareta Amaranu bunama i amaranu buri ma wirosinuro yabai kobererau inaibinu wei. I Yesu yana korosiro oita. Oitaro uiro Godima uietaroma ma uyari. ");
INSERT INTO yrb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Godinu bukaroma Dawaba wasu, I su ubu ueta uwaranu mu sata tutubu ina botai tutubu ari sini, Godinu bukaroma eno wasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Dana torowa ya ma wirofisu. Ewa orofa atataro ibeta mui amarama ya da ma wirofisu. Godi Dana Dawa ifu derawere maiba Danu ifuma ya ma wirofisu Fitama eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","14","Fitaini Joni ema iyarawa usi. Nono bodere i amara sadei ema sikuru utawarogo sina bunawere weisi. Weisiro i kanisoro uwarama i weisi sina imutate neno kirifu uteda we imuta, i amara sadeina Yesunu buri ura imutate i buri aramaroma wiroeta amara Fitaini Jonibai inaibiro etate iba moko sina wiawa utate weita, wawaro aniawe weitaro anita. ");
INSERT INTO yrb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Anitaro kanisoro uwarama eno weita, i uwaraba anene ufeisi weita? Jerusaremu uwara nesia emanu buna ueta iwata utaita. ");
INSERT INTO yrb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","18","Iba i amaranu buri ma wirotawa uita da webeisi weita. Weitate nono weita, moana uwarama i ueta nauotoba Yesunu ifuro da webawaro we kakara ufeisi weitate arawe weitaro fataro weita, Yesunu ifuro uetaini wetaini daido da uforo weita. ");
INSERT INTO yrb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","20","Eno weitaro Fitaini Jonima yare weisi, Godinu sinama kobererau, o yanu sinama kobererau, ananu sina naufutu wiawero naufu weisi. Yanu nauetaini eretaini nesia webutu weisi. ");
INSERT INTO yrb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Weisiro i kanisoro uwarama bunawere we kakara uta. I Jerusaremu su uwara nesia i ueta erebitaba Godiba we ma kobererau utebita. ");
INSERT INTO yrb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","I wiroi amarana reka amara me. Danu oyana foti (40). Kanisoro uwarama buna derawere sina we kakara utate fanisi matawa uteda me siaia utaro anita. ");
INSERT INTO yrb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Fitaini Jonima i kanisoro uwara ekoisite i amara sadeima emanu domayamutubai sau anisite i dera uwaraini baeta uwarama emaba weita sina nesia weisi. ");
INSERT INTO yrb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nesia weisiro nautate i uwara nesina Godiba sina weita, yanu Baba Godi, Ana orofa atataini ureini eneaini ana omaini idina madinaini erawa nautawa ane ane nesia Ana ubu ui. ");
INSERT INTO yrb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ana weiro Imumu Kotofuma Anu gaukara amara Deiwidi yanu sirorari amarabai weiba Deiwidima wei, i aika uwara aneba neno ka utebita? I Isaraero uwara nesia aneba me sara imutebita? ");
INSERT INTO yrb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","I kini uwara nesina emanu aika ue bou utebitaro i yawoeta uwara nesina Godini Danu we mune odi Amaraini urafitae inata, Deiwidima eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","I uwarama weitate weita, Erodini Fonitia Faeratini aika uwaraini Isaraero uwaraini, Jerusaremu suro kobere Yesu Keriso, Anu we mune odi Amaraini urafitae fata. ");
INSERT INTO yrb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","I ueta nesia Ana bodere ufitae wei enanari uta. ");
INSERT INTO yrb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Baba, awona i kanisoro uwaranu uraneta sina nauate ya, Anu gaukara ueta uwara, durua uaro Anu sina bunawere webene waisi. ");
INSERT INTO yrb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Anu buna age sate uwara ma wiroate Anu neno neno utawa Kotofu Amara Yesunu ifuro buna ueta ua weita. ");
INSERT INTO yrb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Godibai i guriguri ue me sitaro emanu yaubita kabesi wawana wawana uiro Godinu Kotofu Imumu emanu neno ubarero itariba Godinu sina bunawere webita. ");
INSERT INTO yrb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Godinu sina naueta uwarana imueta daba demurai uwara. I uwara nesia emanu waiyaini ibaiabaini, nanu wiawa utate nesia nata nata uta. ");
INSERT INTO yrb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","I afosoro uwarama Yesunu uyareta kowa bunawere webitaro Godima emaba derawere ma kobererau utebi. ");
INSERT INTO yrb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Mui amara osi urawa ui. Nesia kobererau ibebita. I waiyaini su bobo uwara emanu waiyaini suini oiya ue matate i oi afosoro uwaraba mataro afosoro uwarama i oi mutate i oi me uwaraba nata nata uta. ");
INSERT INTO yrb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mui Riwai amara danu ifu Jousefa danu orofa Saifurasi, i afosoro uwarama i amara Banabasi webita, i ifunu ubina we ma nabi ueta amara. ");
INSERT INTO yrb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","I amarama enanari danu yawotebi waiya ane mairo oiya utaro oi munite afosoro uwaraba mai. ");
INSERT INTO yrb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Mui amara Ananaiasi danu awetanu ifu Safaira, i amara mui nasini oiya uite i oi munite moana oi suro odite nono moana oi i afosoro uwaraba are mai. Aweta aweranu ueta kiwu nesia dawa iwata. ");
INSERT INTO yrb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ananaiasi moana oi wo fariro Fitama wei, Ananaiasi Seitaninu mai imueta aneba munite Godinu Imumu Kotofuba irutasu wei? Anu nasini mairo oiya utaro muni i oi moana ma feare odinute moana are matasu, iba Imumu Kotofu irutasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bodere i nasini anu. Nono weiro i nasini oiya utaro i oi nesia ana muni iba i oi nesina anu. Aneba siosa imueta nenoma imutasu? Emeba irutawaro Godibai irutasugo wei. ");
INSERT INTO yrb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Eno weiro Ananaiasi nauite dowareda daido ba ui. Ba uiro me siniba iba iro ibita naueta uwara iya derawere uyata. ");
INSERT INTO yrb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Moana reka uwara are fatate Ananaiasinu ofe wayatate anitate uri uta. ");
INSERT INTO yrb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Duburo i kowa marebiro danu aweta i ueta iwata utawa uite are fari. ");
INSERT INTO yrb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","9","Fariro Fitama wei, ewa oina anu nasini weiro oiya utaro muni oi? Mui me aba? Wiaro nauma wei, Eno weiro aiwiade, idoni weina Fitama wei, aneba Godinu Imumu Kotofu ue efae wasu wei? Anu aweranu uri ueta uwarama bebetobai faritaba a woufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Eno weiro i aweta ido dowareda ui. Daido ba uiro me sini. I reka uwara fareda etana me siniba woutate danu awerabai ane uri uta. ");
INSERT INTO yrb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Godinu sina naueta uwaraini moana uwaraini i ueta sina nautate iya derawere uyata. ");
INSERT INTO yrb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","I afosoro uwarama uwara faiyawerebai Godinu buna uetaini kamama ueta utebita. Godinu naueta uwara nesina mui dera dubu su ofadaro, danu ifuna Soromoninu ofada, iro guruguru utedibebita. ");
INSERT INTO yrb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","I aika uwara emaba kobere uwara imutebitate iyarebitaba emabai emaini ane yaurawa. ");
INSERT INTO yrb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Moana uwara Godinu sina nauteda imutebitate emeini awetaboini i naueta uwarabai ane taka utebita. ");
INSERT INTO yrb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","I afosoro uwarama enoma enoma utebita i uwara emanu ofe woureta uwara wiaro woure dababai ane odebita. Fitama fare inareibiro kowa dagioma danu imumu eme emanu deiro utumu saneibiro wirofitae iba emanu ofe woureta uwara woure ane dababai odebita. ");
INSERT INTO yrb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusaremu kirisi weto su su uwara emanu ofe woureta uwara woure fataro siosa imumu bobo uwaraini ofe woureta uwara nesina wirota. ");
INSERT INTO yrb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","I dera fuyo ode sina weta amaraini danu domayamutuini i Sadusi tisa uwara emana i afosoro uwaraba neno ka uteda madudu sina weitate i afosoro uwara budari utate ana ebaro oita. ");
INSERT INTO yrb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Oitaro dumuro Godinu aneruma ana eba sunu kasimu ma erearite i uwara woure wawaro fare ani. ");
INSERT INTO yrb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Anite wei, dera dubu su ubarero inafote Yesunu reka me ibeta sina weboro wei. ");
INSERT INTO yrb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Eno weiro nauegou uta. Wai urina dera dubu su ubarero i sina we mawetu utebita. I kowaro dera fuyo ode sina weta amaraini danu domayamutuini emana i kanisoro uwaraini Isaraero baeta uwaraini dera mitini ufitae yua weita. Yua weitate moana uwara i ana ebaro afosoro uwara woure afitae siaia utaro anita. ");
INSERT INTO yrb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Anebe ane fatate etana eme me. Eme meba owetate are fatate weita, i ana eba sunu kasimu nesia garari ubinuro yawoeta uwarama yawoegou utaitaro ubarero amuisite erisina eme iro me weita. ");
INSERT INTO yrb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","25","Eno weitaro nauteda aboro anita ari we imutana mui amarama farite i sina webie uteda wei, i ana ebaro oita uwarana dera dubu su ubarero inaibeda we mawetu utaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","27","Weiba forisi kafitenini forisimanini ido anitate Isaraero uwara ema gebiroma uotoba iyatate i afosoro uwara kekerama woure fatate kanisoro uwaranu iboro inawe weitaro inaibita. ");
INSERT INTO yrb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","29","Inaibitaro i dera fuyo ode sina weta amarama wei, etei Amaranu ifuro da weboe we kakara usi wei. Yanu ueta eawe. Jerusaremu su uwara nesina yanu sina nauita wei. Eno uteda yana waita, Yesunu uieta sina urumu yabai ibinu eno waita weiro nautate Fitaini afosoro uwarama weita, Godinu imueta mubeisi. Nono emenu imueta da mubeisi weita. Yana Yesu korosiro oitaro ui. ");
INSERT INTO yrb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","31","Nono yanu Babamutunu Godima Dawa uietaroma ma uyarite Danu enabiraro odite Yesu yanu dera Amararo ma wiroeta Amara odi. Isaraero uwarama emanu neno neno ueta dubena sabitaro emanu neno neno ueta nesia mubite imutawa ufisuba iba Godima eno odi. ");
INSERT INTO yrb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","I uetana nesia eraisi. Godinu Imumu Kotofu Danu naueta uwarabai mai. Imumu Kotofuini yaini i ueta nesia eraisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","I kanisoro uwara i sina nautate ubusi derawere uyatate i afosoro uwara ufene weita. ");
INSERT INTO yrb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","35","Weitaro mui kanisoro amara danu ifu Gameiria, dawana Ju uwaranu tarawatu dera tisa amara. I uwara nesina dawa kobere amara imuta. I amarama uyarite i afosoro uwara anibitae weiro anitaro wei, Isaraero uwara, i uwaraba anene ufote eregou uforo wei. ");
INSERT INTO yrb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bodere mui amara danu ifu Teudasi ido yare inarite na dera amara weiro uwara faiyawere fo aderedi (400) dawabai ane taka uta. Eno utaro Teudasi ido ma uitaba danu buribi inareta uwara nesina daba aika maika anita. ");
INSERT INTO yrb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nono duburo Gareri amara danu ifu Judasi, i ifu ifu yawieta kowaro inariro moana uwara dawabai taka uta. Judasima me siniro danu uwara nesina daba aika maika anita. ");
INSERT INTO yrb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Iba ewa uwara ekodiawe watane wei. Emanu uetana emenu uetana dowafisu. ");
INSERT INTO yrb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","40","Emanu uetana Godinu ueta uteibitaitana da mu saboita. Mu saboitana Godini uraneiboita iba watane. Weiba kanisoro uwarama danu sina nautate i afosoro uwara yua weitaro fataro isuma utate Yesunu ifuro da we mawetu uforo we kakara uteda siaia uta. ");
INSERT INTO yrb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Eno utaro dera mitini ekoitate anita. I uwarana Yesu Kerisonu uwaraba moana uwarama emaba siosawere utebita. Utebitaro Godima bana wiawa afosoro uwaraba kobererau imuiba afosoro uwarama maru utawa yaru uta. ");
INSERT INTO yrb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kowa woroworo dera dubu su ubarero o uwaranu su ubarero Yesu Kerisonu kotofu sina we inarebita. ");
INSERT INTO yrb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Duburo i iwata ueta uwara faiyawere uyarebitate Guriki sina webita Ju uwaraini ba Ju uwaraini yaranebita. Guriki sina webita Ju uwarama weita, yanu wabu awetaboba emanu ietaini oini ba torowa matebaita weitaba iba yaranebita. ");
INSERT INTO yrb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","3","Eno utaba i tuero (12) afosoro uwarama i Godinu sina naueta uwara nesia yua weitaro fata. Fataro weita, Godinu sina da webete ietaini oini nata nata ufeisina ina kobererau meba iba Godinu Imumu Kotofu bobo beforo bunawere uwara seweni (7) muawero i nata nata ueta gaukararo odife weita. ");
INSERT INTO yrb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yanu aika guriguri utedibeibete Godinu sina wedibeibeisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Weitaro emanu sina nautate Godinu sina naueta Imumu Kotofu bobo amara Sitiwanini moana uwara Firifini Fokorasini Naikeini Taimonini Famenasini Nikorasini danu orofa Anitiyoka, dawa Ju amara ari sini, i uwaranu sina nautate afosoro uwarabai oita. ");
INSERT INTO yrb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Woure oitaro i afosoro uwarama guriguri uteda age kofiri deiro oita. ");
INSERT INTO yrb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Godinu sina we inarebitaro Godinu iwata ueta uwara Jerusaremu suro faiyawere uyarebita. Fuyo ode sina weta uwara faiyawere Godinu naueta uwara sinebita. ");
INSERT INTO yrb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Godima Sitiwani ma kobererau uite buna derawere maiba Sitiwanima buna uetaini kamama uetaini faiyawere utebiro erebita. ");
INSERT INTO yrb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Moana dubu su uwara, yana aika yawoeta waita uwara, i uwaraini moana Sairina uwaraini moana Arekisana uwaraini moana Sirisia uwaraini moana Eisia uwaraini i orofa aika maika uwara nesina uyareda Sitiwanini yarata. ");
INSERT INTO yrb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Eno utaro danu iwata derawerero Godinu Imumuma danu bebeturo webiba ekoita. ");
INSERT INTO yrb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ekoitate anitate moana meoma bobo uwara mutaro i meoma bobo uwarama weita, Sitiwanima Mosesini Godiba sina siosa wasu weita. ");
INSERT INTO yrb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eno weitaba i guruguru ubita uwara nautate Sitiwaniba ubusi uyata. I dera Ju uwarama Sitiwani budari utate i kanisoro uwarabai woure anita. ");
INSERT INTO yrb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Woure anitaro i meoma bobo uwarama weita, etei amarama i dera dubu suini Mosesinu tarawatuba sina siosa wasu weita. ");
INSERT INTO yrb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Weitate weita, etei amarama wei, Yesu Nasareta Amarama i dera dubu su ma siosa ufite Mosesinu tarawatu nesia mu sabisu weiro nausi weita. ");
INSERT INTO yrb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Weitaro i kanisoro uwara nesina Sitiwaninu ibo nawata etana ario derawere ui. Anerunu ibo nawata ari eta. ");
INSERT INTO yrb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","I dera fuyo ode sina weta amarama wei, emanu wawei sina meo aba ba wei? ");
INSERT INTO yrb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Weiro Sitiwanima sina moko wei, babamutu kaka nabue, nanu sina nauawe wei, yanu sirorari amara Eibaramu danu orofa Mesofateimiaro ibebi, Erani suro anawa. Iro me ibebiro yanu Baba Godi, yanu kobere Godiwere Eibaramubai are fari. ");
INSERT INTO yrb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Farite wei, anu su uwaraini orofaini ekodiate mui orofaro ania wei. Iro aniaro i reka orofa aba mawetu uma wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Weiro Karidia orofa ekodite ani. Ane Erani suro fari. Farite iro ibebiro danu damama uiro me sini. Me siniro Godima Eibaramu ewa Isaraero orofa, yanu ibinisi orofaro wo fare odi. ");
INSERT INTO yrb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Odite nasini matawa uite ewa orofa atata nesia aini anu koiniboroba mamau we bou ui. I we bou ui kowaroma Eibaramu dawa koiniboro me. ");
INSERT INTO yrb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Godima mui sina Eibaramuba eno wei, anu koiniboro ewa orofa duburo ekodifitate aika orofaro anibitaita. Iro oya faiyawere, fo aderedi (400) ibifitaro aika emema ema kimuwere yawofitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","I aika emenu ema yawoetana ba meba Nana ema fanisi mamau. Eno umaro anu uwara owefitate ewa orofaro nono fare ibeda Naba ainewaure guriguri uteibitaita Godima wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Godima Danu we bou ueta Eibaramuba mai. I we bou uetanu towanana ofe tureta. Eibaramuma Aisiki yanae muniro kuitanu kowa eita (8) me siniro danu ofe turi. Aisikima Jeikofu yanae muni. Jeikofu yanu sirorari uwara tuero (12) yanae muni. ");
INSERT INTO yrb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jeikofuma ema yanae mune me siniro yanu sirorari uwarama Jousefaba ibo utate moana uwarabai mataro oiya utaro Ijifi orofaro woure anitaro sabua ueta amara sini. ");
INSERT INTO yrb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Iro woure anitaro Godima Jousefa yawotebiro ani. Ane Ijifi orofaro fariro Jousefa durua uiba siosa ueta utawa ui. Godima Jousefa buna mairo Feroma, dera Ijifi yawoeta amara, Jousefa kobere amara we imuite mune danu su yawoeta amara we odi. ");
INSERT INTO yrb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mui waina Ijifini Keinani orofaro arumu derawere yauta, yanu babamutu sinai derawere wouta, ieta meba. ");
INSERT INTO yrb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ieta Ijifi orofaro ibinu weitaro Jeikofu nauite danu adarabu ireweni (11) iro siaia uiro anitate oweta. ");
INSERT INTO yrb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nono siaia uiro anita. Ane fataro Jousefa emabai danu torowa mawetu uteda nana Jousefa weiro i dera amara Feroini Jousefanu dataemutu iwata uegou ui. ");
INSERT INTO yrb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jousefama weiro danu damamaini danu su uwara nesia wo fata, eme faiyawere (75) wo fata. ");
INSERT INTO yrb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jeikofu Ijifi orofaro taranite iro ibebe ui. Dawaini yanu babamutu uie me sita. ");
INSERT INTO yrb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Uie me sitaro woure ane Sikamu orofanu eraboro uri uta. I uri ue oeta kabesina Eibaramuma Eimo waita abuabairoma danu adarabuba oima oiya ue mateda muni. ");
INSERT INTO yrb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Godima Eibaramuba Isaraero orofa mamau we bou ui. Godinu we bou ui kowa fafie uiro yanu sirorari uwarama koiniboro faiyawere yanae munebitaba eme faiyawere Ijifi orofaro ibebita. ");
INSERT INTO yrb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mui kini amara uyarite Jousefa uiro danu ifu dawa iwata meba iba yanu uwaraba ba mewere utebi. ");
INSERT INTO yrb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Utebe emanu reka muneta amakanu nesia ma uifie weiba emanu reka muneta amakanu nesia oiro sataro uita. ");
INSERT INTO yrb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","I kuita adarabu sanebita kowaro Mosesi danu danuama Mosesi muniro Godima erina kobere amara eri. Mosesinu danua damama sakara rarogonu yawotebe daido ekoisi. ");
INSERT INTO yrb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ekoisiro Feronu arumama i amakanu munite omuiro danu amara sini. ");
INSERT INTO yrb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mosesima Ijifi uwaranu sikuru utebe iwata derawere muniba danu wetaini ueta derawere ui wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mosesima Feronu suro ibebe ibebe oya foti (40) munite uyarite danu Isaraero masigu efie ani. ");
INSERT INTO yrb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ane erina mui Ijifi amarama Isaraero amara isuma urebi. Urebiba Mosesima i Ijifi amara ba ureiro ui. ");
INSERT INTO yrb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosesima eno we imui, nanu uwara iwata utaita, Godima na siaia usinuba nanu uwara Ijifi orofaroma woure animane fare eno iwata utaita we imuirogo danu uwara i imueta ema iwata utawa utaba danu torowa irui. ");
INSERT INTO yrb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wai uriro danu su uwarabai nono ani. Ane erina Isaraero amara sadeima uranebisi. Uranebisiro wei, kodiawa ya su demurai amara sadei aneba uranaisi wei? ");
INSERT INTO yrb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","28","Weiro mui yaranebi amarama wei, a ana? Anama a dera amara odinu? Arena i Ijifi amara uri, awona na enanari ufae wasu wei? ");
INSERT INTO yrb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Weiro Mosesima i sina nauite iya uyarite Ijifi orofa ekodite mui orofaro sau ani. Ane Midiani orofaro fari. Fare ibebe aweta munite danu amara sadei yanae muni wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","32","Mosesima iro oya foti (40) ibebe mui kowaro Sainai maidani gigirariro ani. Anebe erina anaraturo ina yarebi. Ina ubarero aneru inaibiro ereda we imui, ewa ane? we imuite durami ue farina Godima wei, Nana anu sirorari uwaranu Godi, Eibaramuini Aisikini Jeikofunu Godina Na wei. Weiro Mosesima iya derawere uyareda erawa ui. ");
INSERT INTO yrb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Uiro Godima wei, anu sadoro buriroma ma kosugari ua wei, ewa sakaina kakarawereba iba watane wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Weite wei, Ijifi uwaranu yawoetana kimuwereba Nanu uwaranu ibetana aramawere. Emanu ibetaini i wetaini naueba ema nesia iroma woure animau wei. Iba a Ijifiro siaia umaro aniate i uwara woure ania wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Bodere Isaraero uwarama Mosesi unutawa utate weita, anama a dera amara odi weita? Godima i amara siaia uiro ani. Aniro ina ubarero inaibi aneruma dawa durua uiba emanu wiroeta amarana dawa. ");
INSERT INTO yrb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Buna uetana faiyawere utebite danu uwara Ijifiroma Kukui Enea ubarero woure fare ani. Yao orofaro ane fatate iro ane fare ane fare utebe oya foti (40) enoma enoma utebita. ");
INSERT INTO yrb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ewa Mosesima danu uwaraba wei, Godima na we mune odi, i ari mui we bou ueta amara, yabai we mubite odifisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ewa Mosesini eme ibawa orofaro ibeda iro sina weta gaukara utebi. Sainai maidaniro maniro aneruma dawaba sina wei. Iro yanu buna tarawatu munite yabai tarari wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Yanu abuamutuma danu sina nautawa utate i amara we ma beratate we imuta, yanu Ijifiro ainetana kobererau, ewa orofana aramawere we imuta. ");
INSERT INTO yrb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nono Eroniba weita, yanu godi nesia ubu uaro ina ya woure anibe weita, ewa Mosesi, i woure areta amara, aboro ainu weita? ");
INSERT INTO yrb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Weitate borumakaunatu goruma ubu utate borumakauba fuyo mata. Emanu ubu uetaba yaru derawere uta. ");
INSERT INTO yrb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Utaba Godima i uwara ekodiro i uwarama muinaini kodaraba guriguri utebita. Emanu uetaba Godima we bou ueta uwaranu bukaro wei, yanu eme ibawa orofa oya foti (40) ibeta kowaro fuyo nabai odebita. ");
INSERT INTO yrb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nabai me, wei, i ba me godiba imutebita wei, Morokinu aineta suratu wourebitate Refaninu muina wourebitate yanu agema ubu ueta ememetuba imutebita wei, eno utebitaba ya nesia Babaronia orofaro siaia umaro aniboita wei, i we bou ueta uwaranu bukaro Godima eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sitiwanima wei, yanu abuamutuma farai dubu su eme ibawa orofaro woure inarebita. Godima Mosesiba weiro i farai dubu su enanari ubu uta. ");
INSERT INTO yrb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Duburo emanu areta kowaro eme faiyawere uranebitaro iya wo bagaru ue anita. I kowaro Josuaini i farai dubu su woure anita. Eno utebe Josua ido uiro me siniro i farai dubu su oya faiyawere ibebe ane Deiwidinu kowa ido fari. ");
INSERT INTO yrb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Godima Deiwidi erite dawana kobere amara imuiba Deiwidi danu ununa Jeikofunu Godinu dera dubu su ufie wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Weirogo dana me, danu amara Soromonima i dera dubu su ubu ui. ");
INSERT INTO yrb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","49","Godima emenu ubu ueta suro ibawa utasu. I bodere we bou ueta amarama wei, urena Nanu yaureta kabesi, sakaina Nanu buri amueta kabesi. Enoba ane su Naba ufoita? Aboro imoimau wasu? ");
INSERT INTO yrb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nanu agema nesia ubu ue wasu, i we bou ueta amarama eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitiwanima wei, ya ome bobo me uwara yanu imueta ma kimu ue naue nautawa utaitate Imumu Kotofunu daba garari garari utaita wei. Yanu yamamamutuma eno utebitaba ya enanari utaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yanu yamamamutuma i we bou ueta uwara nesia emaini urane yarane utebitate i Yesu fafisu sina webita uwara utaro uita. I fari Amara Godinu Kobere Amara, yana meo wawei weitate utaro ui wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","I aneruma mai tarawatu, Godinu tarawatu, yana ma siosa utebita wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sitiwani eno weiro Isaraero dera uwarama ibo derawere utate abate gabari uta. ");
INSERT INTO yrb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","56","Utaro Imumu Kotofuma Sitiwaninu neno ubarero itariba Sitiwanima urero erite wei, Yesuma Godinu banibira age afuro inaibinuro eratane wei. ");
INSERT INTO yrb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Eno weiro emanu ome garari utate derawere we mamitate i amara ma youtate su wawaro mu satate gebiroma uta. Eno utate emanu dei wadia reka amara Soroma yawofie mata. ");
INSERT INTO yrb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","60","Eno utebitana Sitiwanima guriguri uteda wei, Baba Godi, nanu imumu mua weite jegirari uite wei, Baba, emanu ueta ba mewereba emabai da odifaro wei. Eno weite ido ui. ");
INSERT INTO yrb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Soro danu unu Sitiwani ureta iba Sitiwani utana Foronu neno ido itari. Moana Isaraero Godi naueta uwara are fatate i weda Sitiwaninu ofe mune uri uta. Danu uieta kowaroma moana uwarama Jerusaremu dubu su naueta uwaraba ba me uta. Eno utaba wo bagaru ue aika maika anita. Judiaini Samaria orofaro anita. I afosoro uwara torowama Jerusaremu suro ibebita. ");
INSERT INTO yrb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Soroma i naueta uwaranu su suro anite uwara budari uite emeini awetaboini budari uite ana ebaro mune ane odi. ");
INSERT INTO yrb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","I wo bagaru ue anita uwarama mui su suro Godinu sina we inarebita. ");
INSERT INTO yrb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","6","Firifima mui Samaria suro tarani. Tare Yesu Kerisonu sina i uwarabai weiro i uwara nesia danu sina nauegou uta. Danu buna ueta ereda danu sina nauteda yaru uta. ");
INSERT INTO yrb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","8","Firifima weiro seitaninu moana siosawere imumuma emenu ubareroma amuteda arua weda iya wo bagaru ue anita. Moana buri age bebeu bobo uwaraini buri aramararabo uwara wirotaro iba i Samaria su uwara yaru uta. ");
INSERT INTO yrb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Saimoni dana dodoa weta amara Samaria suro ibebi. Ibeda eno webi, nana dera amara webi. ");
INSERT INTO yrb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Eno webiba i uwara nesianu imuetana ba dera amaraea weita. Dana dodoa weda buna ueta utebiba iba dana dera amara weita. ");
INSERT INTO yrb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Weitate etana Firifima Godinu yawoetaini Yesu Kerisonu ifuba sina webi. Webiro nautate Yesu imutate Firifibai emeini awetaboini babataito uta. ");
INSERT INTO yrb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Eno utaro Saimonima nauite Firifibai babataito ui. Uiro Firifini Saimoni uruama inarebisi. Inarebe Saimonima Firifinu buna ueta nesia erite neno kirifu ui. ");
INSERT INTO yrb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria uwara Godinu sina nautaita weitaro Jerusaremu suro ibita afosoro uwarama nauta. Nautate Fitaini Joni siaia utaro tanisi. ");
INSERT INTO yrb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tane i uwarabai guriguri usite weisi, Baba, Anu Imumu Kotofu siaia uaro emabai itafi weisi. ");
INSERT INTO yrb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Godinu Imumu Kotofu i Samaria uwarabai bodere itarawa ui. Yesunu ifuro torowa babataito uta. ");
INSERT INTO yrb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Utaba Fitaini Jonima emanu age i uwaranu kofiri deiro oisiro Godinu Imumu Kotofuma emanu neno ubarero itari. ");
INSERT INTO yrb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Saimonima Imumu Kotofu itariro erite wei, Fitaini Joniba oi mamaro yanu buna maiwero nanu age moana uwaranu kofiri deiro odimaro Godinu Imumu Kotofu itafisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","21","Weina Fitama wei, ane imutasu? Godinu me maeta oiya ufasu wei? Eno imutasuba anu oini arama ufasu wei. Anu imuetana ba meba yabai gaukara da ufasu. Anu nenona Godibai imutawa utasuba yabai gaukara da ufasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Anu imuetana aramawereba Godiba guriguri uaro anu neno neno ueta maitufi wei. ");
INSERT INTO yrb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Anu imuetana aramawereba siosa ueta utebasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Weiro Saimonima wei, na unutawa i siosa uetaba naba Godibai guriguri uawero na ma wirofi wei. ");
INSERT INTO yrb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Fitaini Jonima emanu sinaini Yesunu sina we me sisite owesite moana Samaria su suro anisi. Ane Godinu sina we inarebe ane Jerusaremu suro ane fasi. ");
INSERT INTO yrb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Godinu aneruma Firifibai tare wei, taniate etei Jerusaremu suroma Geisaro tarane ibinu daba tania wei. Etei dabana eme inarawaba yao orofa weiro ani. ");
INSERT INTO yrb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ane farina mui dera Itiofia amara, Kuini Kadasinu oi yawoeta amara ido fari. Dana Jerusaremu dera dubu suro anite guriguri uite owerite ido fari. ");
INSERT INTO yrb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Danu osi egi ma youreta uiri bobo warafaro yaubeda Godinu buka Isaiya yawie yawie ido fari. ");
INSERT INTO yrb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ido farina Godinu Imumu Kotofuma Firifiba wei, dawabai ania wei. ");
INSERT INTO yrb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Weiro durami ue ani. Ane fariro i amara Isaiya buka yawiro nauite wei, anu yawitasuna i ubi nautasu aba me wei? ");
INSERT INTO yrb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Weiro i amarama wei, ane naumau mui amarama na we mawetu ufisu deina ido wei. Weite yua wei, nabai amo yaua weiro amo yauri. ");
INSERT INTO yrb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","I amaranu yawitebi sinana edono, Emema mamoe ma uifitae mune anaitana mamoe arua wiawa utasu o mamoenatunu iji turaitana arua wiawa utasu enanari emema Dawa ma uifitae mune anitana arua wiawa ui. ");
INSERT INTO yrb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dana arua wiawa uiba mui amarama bana weda kodiawe wiawa ui. Dana uite urero manite iro ibinu. Anama ewa uwaranu siosa ueta webisu, i amarama i sina edono yawi. ");
INSERT INTO yrb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yawie me sinite Itiofia amarama Firifiba wei, i we bou ueta amarade ewa sina anaba wasu? Danu torowaba aba mui amaraba wasu wei? ");
INSERT INTO yrb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Weiba Firifima i sinaroma wei enanari Yesunu kotofu sina nesia i amarabai we mawetu utebi. ");
INSERT INTO yrb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Eno we mawetu ue anebe ogo ane atasi. Ane atasiro Itiofia amarama Firifiba wei, na babataito umane watane. Na babataito ufasu aba me wei? ");
INSERT INTO yrb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Weiro Firifima wei, anu naueta kobererauna babataito umanu, nono anu naueta siosawerena babataito da umau wei. Weina Yesu Keriso Godinu Amara imutatane wei.) ");
INSERT INTO yrb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Weite osi ma youreta emetu duero odiro ogoro itasi. Tare Firifima Itiofia amara babataito ui. ");
INSERT INTO yrb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Eno uiro ogoroma duero amutebisiro Godinu Imumu Kotofuma Firifi munite sau woure ani. Aniro Itiofia amara Firifi erawa uite nenoma yaru ui. ");
INSERT INTO yrb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Firifima Asotu suro farite iro Godinu sina weite moana su suro we inarebe Sesaria suro ane fari. ");
INSERT INTO yrb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Soro ibo uteda Yesunu naueta uwaraba ba me utebi. Uite botai dera fuyo ode sina weta amarabai anite wei, owawa mairo Damasikosi Ju uwaranu su suro animate i naueta uwara emeini awetaboini nesia budari umate mune Jerusaremu suro famau wei. Eno weiro owawa eno ue mairo woure ani. ");
INSERT INTO yrb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","4","Damasikosi orofaro anebiro ario derawere ureroma tararite dawa wokuku uiro Soro ido sakairo urei. Ureiro ureroma sina tararite wei, Soro, aneba Naba ba me utasu wei? ");
INSERT INTO yrb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Weina a anaiyade wei? Weiro wei, Nana Yesu. Ainewaure Naba ba me utasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Awona uyate Damasikosi suro aniaro anu ufasu gaukara aba mui amarama webiro naua wei. ");
INSERT INTO yrb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Weiro dawaini inarebita danu domayamutu i sina nautatego ba eme erawa utate wate wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Soro uyarite diti foraite efie erina erawa uiba agero mutate Damasikosi suro mune ane fata. ");
INSERT INTO yrb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ido mune ane fataro kowa rarogonu ditima ba erawa uite ogoini ietaini itawa uite me ibi. ");
INSERT INTO yrb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Godinu mui naueta amara Ananaiasi dawa Damasikosi suro ibebi. Iro i amara Ananaiasi ainibebe tubetube erina Yesuma wei, Ananaiasi, weina na ewado wei. ");
INSERT INTO yrb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Weiro Yesuma wei, uyate ane daba rorowarau ane Judasinu su ubarero amua. I suro amuate i Tarasu su amara Soro aboro wia wei. Soro iro ibeda guriguri utasuba dawa atafasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Weite wei, Soro dawa iwata anu iro ane fareta. Dana tubetuberoma a iro ane fafasu erinuba iba dawa iwata, ana iro ane fafate anu age danu deiro odifaro diti wirofisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Weiro Ananaiasima wei, Dera Waria Amara Soro na iwata, etei amara anu Jerusaremu suro ibeta uwaraba ba mewere utebasu. ");
INSERT INTO yrb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","I dera fuyo ode sina weta uwarama dawaba we enanari utate owawa mataro muni. Munite iba dawa ewa suro fari. Fari ina Anu ifuro waita Anu uwara woure anibie iba fari wei. ");
INSERT INTO yrb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Weiro Yesuma wei, aniaro etei amara awona Nanu amara mune odineba anibite aika uwara faiyawere emanu dera yawoeta uwaraini Isaraero uwaraba Nanu sina we inareibisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Dana Nanu amaraba emema dawaba siosawere ufitaita. Ina dawaba we mawetu umaro naufisu eno weiro Ananaiasi nauite ido ani. ");
INSERT INTO yrb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ane suro farite amuite age deiro odeda wei, kaka Soro, i Dera Yesu, i abai dabaro fari Amarama na abai siaia usinuro fane. Anu diti basugari me sibisuba Godinu Imumu Kotofu anu neno ubarero itafie iba fanea wei. ");
INSERT INTO yrb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Weiro danu ditiro ibi emetu itariro ido eri. ");
INSERT INTO yrb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Eriro dawa babataito utaro ieta ite buna ui. ");
INSERT INTO yrb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Soroma Damasikosi su naueta uwarabai ibeda Godinu sina Ju uwaranu dubu su suro anite wei, Yesu, Dana Godinu Amara wei. ");
INSERT INTO yrb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Weiro i sina naueta uwara neno kirifu utate weita, ewa amarana i Jerusaremu su Godinu naueta uwaraba ba me utebi amara danu ununa ewa naueta uwara budari ufite woure fuyo ode sina weta uwarabai odifie farinu weita. ");
INSERT INTO yrb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Soro danu iwata derawere uiba eno wei, Yesu Dana Keriso, Godima ya ma wirofie mune yabai odi Amara wei. Eno weiba i Ju uwarama sina mui wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kowa faiyawere me siniro moana Ju uwarama Soro danu ma uieta daba doberebita. ");
INSERT INTO yrb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Soro emanu imueta dawa iwata. I Ju uwarama i suini dera dowa kasimuini dabaini Soro ma uifitae kowaini dumuini eregou uteda yawoegou uta. ");
INSERT INTO yrb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Eno utaro i naueta uwarama dumuro Soro dera bosioro oitate nama i dera bosioro doitate dowa deiroma ma bebere kiwuma oitaro itarite ani. ");
INSERT INTO yrb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Iroma Jerusaremu suro farite i naueta uwarabai ibifie ani. Aniro dawaba weita dawa naueta amara meba iba iya uyaraisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mui amara, danu ifu Banabasi, i amarama Soro munite i naueta uwarabai woure ani. Woure anite i afosoro uwarabai wei, ewa amarama Yesu Damasikosi dabaro eriro Yesuma dawaba weiro Soroma i Damasikosi su uwarabai sina bunawere weiya wei. ");
INSERT INTO yrb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Eno weiro Soroma i uwarabai ibeda Jerusaremu su suro ane fare ane fare uteda Godinu sina webi. ");
INSERT INTO yrb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Dawaini Guriki sina waita Ju uwaraini sina sina we matata. Soro danu iwata derawereba i Guriki uwarama danu ma uieta daba doberebita. ");
INSERT INTO yrb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","I naueta uwarama emanu imueta iwata utate Soro mutate Sesaria suro woure ane oita. Iro oitate iroma Tarasu suro siaia utaro ani. ");
INSERT INTO yrb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","I kowaro Judiaini Garerini Samaria orofaro ibeta naueta uwarama merau ibeda wesarau ue ibebita. I kowaro eno ibebitaro emanu naueta derawere ui. I naueta uwarama Godiba we ma kobererau utebitaro Godinu Imumu Kotofuma ema durua utebiba eme faiyawere Godinu sina nautebitaba i naueta uwarabai ane taka utebita. ");
INSERT INTO yrb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Mui kowaro Fitama aboro aboro ani. Anebe Godinu Rida suro ibeta uwarabai owiga ufie tarani. ");
INSERT INTO yrb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tare farite mui buri badami uiro inarawa me ibebi amara eri. I amarana oya eita (8) inarawa wiaro ainibebi. ");
INSERT INTO yrb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Fitama i amara erite wei, Enasi Yesu Kerisoma a ma wirotasuba uyate anu wia mua wei. Weina i amara ido uyari. ");
INSERT INTO yrb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","I Rida suini Seroni fafaro ibebita uwarama i wiroi amara etate Godibai imue naue uta. ");
INSERT INTO yrb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","I kowaro mui naueta wabu aweta Tabita (danu Guriki ifuna Dokasi) Jafa suro ibeda kobere ueta sineta faiyawere utebi. Kobererau uteda, ieta nata nata utebi. ");
INSERT INTO yrb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Enoma enoma utebe ofe wourite ainibebe ui. Uiro emanu baeta uteda danu ofe mutate ogoma urotate sunu dei koruro oita. Moana naueta uwarama Fita Rida suro ibinu weitaro nautate amara sadei siaia utaro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Iro aneta dabana yafa me, fuyaratu. Jafaroma Ridaro ane Fitabai fasite weisi, yanu suro sau ara weisi. ");
INSERT INTO yrb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Eno weitaro Fitaini ido owetate ata. Are fataro moana uwaraini Fita i dei koruro manita. Mane fatana i wabu awetabo iro inaibeda i weda Tabitanu wadia fifinu utebi ibaiabai Fitaba mawetu utaro eri. ");
INSERT INTO yrb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Fitama i uwara nesia wawaro odiro tanita. Tanitaro Fitama owerite jegirari uite guriguri uteda wei, Tabita uya wei. Weina diti ido foraite Fita erite ido yare yauri. ");
INSERT INTO yrb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Yare yauriro Fitama danu agero munite ma uyarite i naueta uwaraini moana wabu awetaboini yua weite emaba mairo i wabu aweta wiroite me inaibiro eta. ");
INSERT INTO yrb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","I Jafa su uwara i ueta nautate Yesubai naue imue uta. ");
INSERT INTO yrb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Fita dawa Saimoni, egi ofe faureta amaranu suro ibebi. I Jafa suro kowa faiyawere ibebi. ");
INSERT INTO yrb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Koniriasima Sesaria suro ibebi. Ami kafitenina dawa. Danu meremere uwarana Itaria waita uwara. ");
INSERT INTO yrb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Koniriasi dana kobere amara. Dawaini danu sisia uwara nesina Godiba kakara uteda iyareda Godi guriguri utebita. Ainewaure i aramawere ibeta Ju gugua gubari me uwaraba ietaini ibaiabai matebite Godibai guriguri utebi. ");
INSERT INTO yrb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mui kowaro, yawi sinono uiro yaubebe tubetube eri. Erina aneruma dawabai farite wei, Koniriasi. ");
INSERT INTO yrb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Eno weiro dawa iya derawere uyareda wei, aneba farinu wei? Weiro aneruma wei, Godima anu guriguri uetaini kobere ueta sineta nesia erinute Dawa a kobere amara erinuba na siaia usinuro fanea wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Awona moana uwara siaia uaro Jafa suro Saimonibai, danu mui ifu Fita, iro anibitate dawa woure abai afita wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Dana i suro mui su ubi amara Saimoni, dawa egi ofe faureta amara danu suro me fare ibinu, i suna enea gigiraribai ibinu weite aneru ido ani. ");
INSERT INTO yrb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Aneru ido aniro Koniriasima weiro danu gaukara amara sadeini danu meremere amara danu dawa yawotebi amara dawa Godinu mui naueta amaraini dawabai fataro i aneruma dawabai wei i sina emaba weite Jafa suro siaia uiro anita. ");
INSERT INTO yrb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Anebe abanaro ane aita. Wau uriro uyatate anita. Anebitana kowa otoro Fitama su deiro guriguri ufie amui. ");
INSERT INTO yrb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Amuite osi uriba ieta ifie wei. Weiro ieta outebitana me yaubebe tubetuberoma eri. ");
INSERT INTO yrb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Erina ure eba ui. Uiro erina wadia derawere koru ubu uite odiro tarari. Tarariro Fitama egi ibo aika maika nesia koruro eri. ");
INSERT INTO yrb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","13","Boro, warai, kuike, kariri gasira, towi, nesia koruro ibitaro eri. Eno eriro mui wate iroma wei, Fita uyate i egiana uate ia wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Eno weiro Fitama wei, Baba, ina Ju uwaranu itawa ibaiabaiba na da imau wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Weiro Godima wei, ibaiabai ma kobererau unede aneba siosawere wasu weite ma owere muniro mani. ");
INSERT INTO yrb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","I egi bobo wadia nono tararite mani, nono tararite mani. Enoma enoma ui. ");
INSERT INTO yrb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","18","Eno uiro Fita iwawa uteda yaubi. Yaubina i amara rarogonu ido fatate weita, Saimoni Fita ewado yaubinu aba me weita? ");
INSERT INTO yrb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","20","Weitaro Fitama danu tubetube eri i imutebina Godinu Imumu Kotofuma wei, Nana siaia ue amara rarogonu abai ido farita, emabai taniate emaini ania wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Weiro Fita ido uyarite taranite wei, yanu doberaita amarana na ewado, aneba farita wei? ");
INSERT INTO yrb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","23","Weiro weita, yanu kafiteni amara Koniriasima a woufete anibero anu sina naufie wenuba abai farisia weita. Aneruma Koniriasibai a are woureta sina weiba iba farisia weita. Yanu kafiteni amarana kobere amara dawa Godibai guriguri utebasu. I Ju uwarama dawa kobere amara eno we imutaita weitaro nauite Fitama i amara rarogonu bana weiro dawaini aita. Wau uriro anita. I amara rarogonuini Fitaini moana Jafa naueta uwaraini nesia anita. ");
INSERT INTO yrb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Anebe abanaro ane aita. Wau uriro anita. Anebitana Koniriasima ema yawoteda danu su uwara weiro fata. Fare yawotebitaro Fitaini danu uwara Sesaria suro fata. ");
INSERT INTO yrb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Fataro Koniriasima uyarite Fitanu buri gigirariro arubi ui. ");
INSERT INTO yrb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Arubi uina Fitama agero munite ma uyareda wei, na Godi me, uya wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Weite suro woure amuite erina eme faiyawere yaubita. ");
INSERT INTO yrb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Yaubitaro wei, Ju uwaraini aika uwaranu uruama owiga uetana kakara derawereba iba eno utawa utaisi. Nono Godima naba wei, awonana kakara me. Eme nesia arotorowa weiro nauete iba ewaro yabai fanea wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Anu uwarama fare weitaro ido uyarete ane wei. Aneba na ewaro woure arita wei? ");
INSERT INTO yrb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","32","Eno weiro Koniriasima wei, i auboko kowaro yawi sinebiro guriguri uteda yaubitararo mui aneruma fare wei, Koniriasi, Godima anu guriguri uetaini kobere ueta nesia ere naue utasu. Enoba anu suroma moana uwara siaia uaro Jafa suro anibitate i amara Fita dawa i mui egi ofe faureta amara Saimoninu su enea gigiraribai iro ibinu webitaro abai afi weiya wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aneruma eno weiba eno wero awona ewado farinu wei. Awona Godima erasuro yaubinisi uwara Godima abai wasu sina wiaro naufe wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Fitama wei, Godima eme nesia arotorowa imutasuba awona ina na iwata utatane. Godima Ju uwaraini aika uwara imutawa utasu. ");
INSERT INTO yrb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Anama Godi iyareda Danu ueta utasuna Godima i amara kobere amara weda imutasu. ");
INSERT INTO yrb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Godi Danu unu Yesu Keriso Danu kobere sina Isaraero uwarabai webiro naufitate neno kobererau ufitae iba Yesu Keriso siaia uiro ewaro fari. Yesu Kerisona eme nesianu Dera Waria Amara. ");
INSERT INTO yrb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ya iwata utaita i sina, Judia orofa su suro we inarebi. Joni babataito amara danu sina me siniro Yesu Gareri suroma Judia su suro we inarebi. ");
INSERT INTO yrb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ya iwata, Godima Nasareta Amara Yesubai Danu Imumu Kotofu mairo kobere uetaini wetaini uite seitaninu imumu siosa we berairo anita. Godima Dawabai ibiba iba eno ui. ");
INSERT INTO yrb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Danu Judia su suro uetaini, Danu Jerusaremu suro ueta nesia yana esi. Eno esiro Ju uwarama Yesu korosiro ure oitaro ui. ");
INSERT INTO yrb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kowa rarogonu me siniro Godima Dawa uietaroma ma uyari. Ma uyariro Yesuma uietaroma uyarite moana uwarabai fari. ");
INSERT INTO yrb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Uwara nesiabai farawa, Godinu muneta uwara torowabai fariro esi. Esite Dawaini ieta isi wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","43","Yesuma yaba wei, aniawete uwara nesiaba eno wiawe, i uieta uwaraini me ibeta uwaraini nesina Nabai koto ufitaita wiawe wei. Nana Godinu we mune oeta Amaraba iba ema koto umau wiawe wei. I we bou ueta uwara nesina Yesuba eno weita, Yesu Kerisoma eme nesiaba uiba ana anama Yesu imuegou ufitaro Godima emanu ba me ueta mubite imutawa ufisu weita, Fitama wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Fitama eno webina Godinu Imumu kotofuma i sina naueta uwaranu neno ubarero itari. ");
INSERT INTO yrb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Itariro Fitaini Ju naueta uwaraini ereda neno kirifu uta. Godinu Imumu Kotofuma i Ju me aika uwaranu neno ubarero itariba iba neno kirifu uta. ");
INSERT INTO yrb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Godinu Imumu Kotofuma emabai itariba sina aika maika weda Godi we ma kobererau utebita. ");
INSERT INTO yrb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Eno utaro Fitama wei, Godinu Imumu Kotofuma yabai itari, enanari emabai itarinuba ema babataito ufene watane wei. ");
INSERT INTO yrb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Weite weiro i uwara mutate Yesunu ifuro babataito uta. Eno utaro Fitaini danu uwara moana kowa emabai ibebita. ");
INSERT INTO yrb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","I aika uwarama Godi nautaita weitaro i afosoro uwaraini Judia orofaro naueta uwara i sina nauta. ");
INSERT INTO yrb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Fitama Jerusaremu suro are fari. Fariro moana Ju naueta uwarama dawaba dua sina weita, ofe turawa uwaraini aneba owiga utasu weita? ");
INSERT INTO yrb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","Weitaro Fitama i auboko ueta nesia emaba wei, Jafa suro guriguri uete yaubebe tubetube erena wadia derawere ureroma nabai tarari. ");
INSERT INTO yrb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","7","Tarariro boro, warai, kuike, kariri, gasira, towi egi nesia koruro ibiro erero ureroma sina wei, Fita, uyate uate ia wei. ");
INSERT INTO yrb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","9","Weiro, Baba, ina Ju uwaranu itawa ibaiabaiba da imau wero ureroma sina nono wei, Na Godima i ibaiabai ma kobererau unea i ibaiabai siosawere da wia weiya wei. ");
INSERT INTO yrb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Weiro i ueta nesia rarogonu tarare mane ui. ");
INSERT INTO yrb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Eno utebina amara rarogonu Sesaria suroma Jafa suro na woufitae ido fata. ");
INSERT INTO yrb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Fataro Godinu Imumu Kotofuma naba wei, i aika uwaraba da imuate aini i uwaraini ania wei. Eno weiro ewa moana uwara sikisi (6) naini anisi. Iro anisite ane i amaranu suro amusi. ");
INSERT INTO yrb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Amusiro i amarama wei, aneruma nabai farite wei, moana uwara wiaro anibitate Jafa suro Saimoni, danu mui ifu Fita, woufitate afita. ");
INSERT INTO yrb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Afitaro sina webiro naufote wirofoita wei. ");
INSERT INTO yrb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","I amara eno weiba anisiro sina wemane utebitarana Imumu Kotofuma emabai tarari. Auboko yabai tarari enanari nono emabai tarari. ");
INSERT INTO yrb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Enoba Yesunu sina imue. Yesuma wei, Jonima ogoma babataito ui. Duburo ya Imumu Kotofuma babataito ufisu. Eno wei sina imueya wei. ");
INSERT INTO yrb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Yaini naini Yesu imusiro Godinu me maeta, Danu Imumu Kotofu yaba mai. Enanari i aika uwarama Yesu imutaro emaba Danu me maeta mai. Eno uiba na derawere meba Godinu me maeta daba garari da umau wei. ");
INSERT INTO yrb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Weiro nautate Godi we ma kobererau uteda weita, aika uwarama Godibai fataro Godima ema ma wiroite me ibene ibene ibeta mai weita. Enoba aika uwara emanu unu Godibai fafitaitana fafitaita weita. ");
INSERT INTO yrb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sitiwaninu ui kowaroma moana uwarama uyatate i naueta uwaraba ba mewere utebita. Utebitaba i naueta uwarama orofa aika maikaro wo bagaru ue anita. Moana Fonisia orofaro anita. Moana Saifurasi orofaro anita. Moana Anitiyoka suro anita. Anitate Ju uwara torowaba Godinu kobere sinaini Yesunu sina weita. ");
INSERT INTO yrb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Moana Saifurasini Sairina waita naueta uwarama Anitiyoka suro anita. ");
INSERT INTO yrb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Anitaro Yesu Danu buna mairo Godinu kobere sina weitaro eme faiyawere nautate Yesunu buribi anita. ");
INSERT INTO yrb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","I ikiki Jerusaremu suro ibeta naueta uwarama nautate Banabasi siaia utaro ani. ");
INSERT INTO yrb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Anitiyoka suro ane farite Godinu ma kobererau utebi erite yaru derawere uteda wei, i aika naueta uwaraba wei, yanu imueta nesia Yesubai mawete ainewaure Yesunu buribi inarebeawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasina kobere amara. Godinu Imumu Kotofuma dawabai ibegou uiba, danu nauetana derawere. Dana weiro eme faiyawere nautate Yesunu buribi anita. ");
INSERT INTO yrb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabasima Anitiyoka su ekodite Tarasu suro Soro dobefie ani. ");
INSERT INTO yrb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ane farite Soro munite owerite Anitiyoka suro woure fari. Anitiyoka suro i naueta uwarabai oya demurairo ibeda uwara faiyawere Godinu sina we mawetu utebisi. Anitiyoka suro ko naueta uwarana Kurisitini uwara weita. ");
INSERT INTO yrb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","I kowaro moana Godinu we bou ueta uwarama Jerusaremu suroma Anitiyoka suro tarata. ");
INSERT INTO yrb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mui Godinu we bou ueta amara, danu ifuna Agabasi, Godinu Imumu Kotofu dawabai ibegou uiba dana yare wei, ewa orofa atata uwara nesia osi derawere woufitaita wei. (Danu wei sina enanari i dera yawoeta amara, Kurodiasinu kowaro ido fari). ");
INSERT INTO yrb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Agabasima eno weiba i naueta uwara nesia weita, ya nesina oi mafero yanu Judia ibeta naueta uwaraba mafitaita weita. ");
INSERT INTO yrb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Weitate oi mataro Banabasini Soroma musite i Judia naueta uwaranu yawoeta uwaraba ane masi. ");
INSERT INTO yrb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","3","I kowaro i dera yawoeta amara Erodima moana naueta uwaraba ba mewere ui. Joninu datae Jeimisi Erodima weiro warima yanataro ui. Eno uiro Ju uwarama i ueta etate yaru uta. Yaru utaba Erodima Fita ana eba suro mune odifie dobere wei. (I kowaro Ju uwara emanu Godima ema Ijifiroma woure aneta ogaro itebita.) I kowaro Erodima Fita dobere wei. ");
INSERT INTO yrb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Weiro anitate Fita budari utate mune ana eba suro oita. Oitaro Erodima weiro meremere uwara faiyawere nesia sikisitini (16) dawa yawota. Erodima eno we imui, Godima Isaraero uwara Ijifiroma woure aneta ogaro me sibiro Fita i Ju uwaranu iboro woure odimate ma uimau we imui. Eno we imuiro Fita diburaro oitaro ibi. ");
INSERT INTO yrb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Iro ibiro iba i naueta uwarama Fitaba Godibai guriguri utebita. ");
INSERT INTO yrb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Erodima Fita waidumu wemaro ane woufitaita we imui. I dumuro Fita senima buri age uwane taritaro Fitama meremere amara sadeinu abanaro nauta ainibi. Mui amara sadeima kasimubai inaibeda yawotebisi. ");
INSERT INTO yrb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ainibiro Godinu aneruma dibura su ubarero farina ario derawere ui. Aneruma Fitanu manamaro fare urite agero munite ma uyareda uya wei. Weina seni uregari uite itari. ");
INSERT INTO yrb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Itariro aneruma wei, anu wadia yuate sadoro odia. Weiro eno uiro aneruma wei, anu dei wadia baruate nanu buribi ara wei. ");
INSERT INTO yrb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Eno weite aniro Fita danu buribi ani. Fita anerunu utebi dawa iwata me, ina ba o meo, eno we imui. Danu imuetana tube eratanea we imui. ");
INSERT INTO yrb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Yawoeta amara sadei inaibisiro mui amara serigari usite nono mui amara serigari usi. Eno usite bebetobai fasina i aiyoni kasimu danu torowa ifegari ui. Uiro wawaro anisi. Wawaro anisite daba demurairo anedana aneru ido me ari ui. ");
INSERT INTO yrb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Aneruma dawa ekodiro Fita i ane ane nesina ba eno iwata uite wei, Godi Danu aneru siaia usinuro tararinute Erodini Ju uwaranu siosa imuetaroma na mune wawaro odinu wei. ");
INSERT INTO yrb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","13","Eno weite Merinu suro ani. Meri dana Joni Makanu danua. I suro uwara faiyawere guruguru ubeda guriguri utebitana Fita ido farite kasimuro goigoi uteda yaubinita weiro mui aruma danu ifuna Roda dana i kasimu ma ifegari ufie fari. ");
INSERT INTO yrb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Fare Fitanu wate tanana nauite yaru uteda i kasimu ma ifegari utawa owerite i guruguru ubita uwarabai durami ue ani. Ane wei, Fita su wawaro inaibinu wei. ");
INSERT INTO yrb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","16","Weina ana gogore bobo meo wasu weita. Weitaro Rodama nono bebetu kimu uite wei, meo me, ba watane wei. Weiro weita, ina danu aneru weita. Weitana Fita dawa inaibeda goigoi uteda inaibi. Eno utebiba kasimu ane ma ifegari utana Fita dawa ido inaibiro etate iba i uwara emanu neno kirifu derawere uteda sina sina weita. ");
INSERT INTO yrb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Weitaba Fitama age ramamiro weroroka ekoita. Ekoitaro Fitama danu ana eba suro ibiro aneruma dawa iroma wawaro woure amo odi sina wei. Weite emaba wei, Jeimisini i naueta uwaraba ewa sina wiawe weite ema ekodite mui orofaro ani. ");
INSERT INTO yrb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wai uriro meremere uwarama Fita erawa utaba dawa dobere weda weroroka derawere weita. ");
INSERT INTO yrb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erodima weiro danu uwara Fita doberebe doberebe atanawa utaro danu dibura yawoteda inaibita meremere uwara koto ui. Koto uite wei, i meremere uwara nesia uawe wei. Weite Judia orofa ekodite Sesaria suro ane ibi. ");
INSERT INTO yrb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erodima Tairaini Saidoni uwaraba ibo derawere ui. Uiba i Tairaini Saidoni uwarama we imuta, Erodinu orofaro ieta munebaisi we imuta. Iba Erodinu su yawoeta amara Barasusibai fatate weita, yanu ununa Erodini sina ma rorowarau ufene farisia weita. Weitaro Barasusima Erodibai i sina ane wei. Erodima kowa odiro dawabai are fata. ");
INSERT INTO yrb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","I kowaro Erodima danu kininu werei werei odite danu dera yaureta deiro yaubeda sina derawere wei. ");
INSERT INTO yrb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Weiro nautate derawere weita, danu wate tanana emenu wate tanana me, mui godinu wate tanana ari wasu weita. ");
INSERT INTO yrb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Weitaro emaba kodiawe wiawa uite emanu sina naufie uiba Godinu aneruma fanisi mairo kiki tabairaratuma danu yajiwa ie me sitaro Erodi ui. ");
INSERT INTO yrb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Godinu sina derawere uiba, iba eme faiyawere naue imue utebita. ");
INSERT INTO yrb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasini Soro emanu gaukara ue me sisite Jerusaremu suroma owesite aneda Joni Maka emaini woure anisi. ");
INSERT INTO yrb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anitiyoka suro naueta uwara ibebita. Emabai Godinu we bou ueta uwaraini tisa uwara ibebita. Emanu ifuna Banabasini Simioni, danu mui ifu Naiga, dawaini Rusiasi, dawa Sairina su amara, dawaini Manaeni, Erodinu dabue, dawaini Soroini, i uwarama emabai ibebita. ");
INSERT INTO yrb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mui kowaro iro ibeda guriguri uteda ieta itawa utate ka utaro Godinu Imumu Kotofuma emaba wei, Banabasini Soro mune odiawero Nanu gaukara ufisisi wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Weiro ieta itawa, guriguri uteda age Soroini Banabasinu kofiri deiro oitate guriguri utate ema siaia utaro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Emana anisiro Godinu Imumu Kotofuma emanu daba mawetu uiro Serusia suro anisi. Ane fasite boutiro amusite Saifurasi mutumuturo anisi. ");
INSERT INTO yrb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ane Saramisa suro fasi. Fasite Ju uwaranu dubu suro Joni Makaini amuta. Amo Godinu sina i uwaraba weita. ");
INSERT INTO yrb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","7","Duburo Saramisa su ekoitate Saifurasi su su nesiaro Godinu sina we inarebita. We inarebe Feifasu suro fata. I suro mui Ju wada barau amara ibi. Dana irueta meo we bou ueta amara. I amaranu ifuna Barayesu, dawa i suro ibiro Soroini danu uwarama fatate i amara eta. I amarana Saifurasi mutumutu yawoeta amara, Suragasi Forusinu domaya. I yawoeta amara Soroini Banabasinu Godinu sina naufie emaba weiro danu suro amusi. ");
INSERT INTO yrb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Godinu sina webisie amusiro nono i wada barau amara, danu Guriki ifuna Iramasi, emanu sina weta daba garari ufie yawoeta amaraba wei, emanu sina da naua wei. Dawa unutawa i dera yawoeta amara Godi nauetaba, iba eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Eno weiro Imumu Kotofuma Sorobai ibegou uiba Soro danu mui ifu Foro, dana i wada barau amara erebe ero ite wei, ana seitaninu amara. Ana kobere uetaba wasai amara. Anu imuetana ba me, irueta imuetana torowa. Godinu kotofu sina weta daba aneba ma bebeu ue garari ufae utasu? Eno ueta kodia wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nanu sina naua wei, Godima a awona fanisi matasuba moana kowaro diti basugari ufate kowa da efasu Foroma wei. Eno weiro danu ereta daba garari uiro mui amara danu agero mubite woure inareibie dobere ani. ");
INSERT INTO yrb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","I dera yawoeta amarama nesia erite Godinu buna wetaini uetaba kirifu uteda Godi naue imue ui. ");
INSERT INTO yrb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Foroini danu uwaraini Feifasu su ekoitate boutiro amutate Famufiria orofaro anita. Ane Fega suro fata. Fataro Joni Makama i uwara ekodite owerite Jerusaremu suro ani. ");
INSERT INTO yrb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Banabasini Foroma Anitiyoka, Fisidia orofa, suro anisi. Ane fasite sabate kowaro Ju uwaranu dubu suro amusi. ");
INSERT INTO yrb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Amusiro mui amarama Mosesinu tarawatu bukaini we bou ueta bukaroma yawi. Yawie me siniro i dubu su yawoeta uwarama Foroini danu uwaraba weita, naiyemutu, yanu unu durua ueta sina weboitana naufeisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Weitaro Foroma uyareda age ramamite wei, Isaraero uwaraini Godiba iyaraita uwaraini nanu sina nauawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isaraero uwaranu Godi yanu sirorari uwara ema munite Ijifi orofaro ema ma derawere uiro ibita. Ibitaro nono iroma danu buna agema woure ani. ");
INSERT INTO yrb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","19","Woure ane eme ibawa orofaro odite ema oya foti (40) yawotebi. Duburo Godima i Isaraero uwara durua utebiro mui Keinani orofa su su uwaraini uranebita. Enoma enoma utebe orofa su su uwara seweni (7) ure me sitaro Keinani orofa yanu sirorari uwaraba mai. Mairo oya faiyawere fo aderedi fifiti (450) Keinani orofaro ibebita. ");
INSERT INTO yrb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ibebitaro Godima emabai koto ueta uwara odi. Samueronu kowa fariro emanu we bou ueta amara Samuero dawa emabai mune odi. ");
INSERT INTO yrb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Odiro yanu sirorari uwarama Godiba weita, yanu ununa kini yabai odia weita. Weitaba Godima Kisanu amara Soro, Benijameninu abuaroma sirorari ui amara emaba mai. Mairo Soroma oya foti (40) ema yawotebi. ");
INSERT INTO yrb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Oya foti (40) yawotebiro Godima dawa kodite Deiwidi ma uyare emanu kini mune odi. Mune odite wei, ewa amara Jesinu amarana Nanu unu amara. Dana Nanu sina nesia naufisu Godima wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Foroma wei, Godima we bou uite Deiwidinu sisia Amara Yesu munite Isaraero uwara emanu ema ma wiroeta Amara mune odi, Foroma wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Weite wei, Joni dawa ko fari. Farite Isaraero uwaraba wei, yanu neno neno ueta dubena sawete babataito muawe Jonima wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Weiro Joni danu kowa me sibie uiro nono wei, na ana amara imutaita wei? Yanu yawotaita amara na me. Mui Amarama nanu buribi afisu. Dana Dera Amarawere. Nana dera amara meba Danu iboro da inare tumau wei, Jonima. Foroma i sina emaba eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Foroma wei, nanu kaka nabue, ya Eibaramunu sisia uwaraini ya Godiba iyaraita uwaraini nauawe wei. Godima ewa ma wiroeta sina yabai siaia uiro arinu wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","I Jerusaremu suro ibebita uwaraini emanu dera uwaraini emana Yesu utaro ui. I uwarama Dawa iwata meba imutawa uta. I we bou ueta uwaranu sina sabate kowaro ainewaure yawitebitaro nautebitate imutawa utebita. Eno utebitaba i we bou ueta uwaranu weita sina enanari ba ui. ");
INSERT INTO yrb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","I Jerusaremu suro uwarama Yesunu ueta sineta siosa me atanawa utate Faeratibai anitate me sara weitaro utaro ui. ");
INSERT INTO yrb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Uiro i uwarama i we bou ueta uwaranu Yesu uieta we bou uta sina enanari uta. Utaro Yesuma uiro Danu ofe korosiroma mutate gebiro uri ue oeta kabesiro oita. ");
INSERT INTO yrb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Eno utaro duburo Godima Dawa ma uyariro ibinu. ");
INSERT INTO yrb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yesu inarebiro Danu Gareriroma Jerusaremu buribi aneta uwarama Dawa erebita. Erebitaba awona i sina i erawa uwarabai waitaro nautaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Godima yanu sirorari uwaraba Danu kotofu we bou ueta mairo awonana yabai i kotofu sina waitu wei. Godima Yesu ma uyarite awonana Danu we bou uetana yabai ido usinu wei. Samusi bukaro sadei ewa sina ibinu, Ana Nanu Amara, Anu Amamana Na. I sina eno ibinu. ");
INSERT INTO yrb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Foroma wei, Godima Yesu ma uyarite wei, Danu ofe yajara da ufisu wei. Samusi bukaro i sina eno ibinu, Aba ma kobererau umau, Deiwidiba we bou ue enanari Aba umau. ");
INSERT INTO yrb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","I Samusi bukaro ewa mui sina ibinu, Ana weiba Anu kakara Amaranu ofe yajara da ufisu. I sina Samusi bukaro eno ibinu. ");
INSERT INTO yrb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Foroma wei, ewa sinana Deiwidinu me, Yesunu. Deiwidima Godinu gaukara danu uwarabai uite ui. Uiro danu sirorari uwarabai uri utaro danu ofe yajara ui. ");
INSERT INTO yrb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Godinu ma uyareta Amaranu ofena yajara utawa ui wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Nauawe, ewa Amara torowama yanu neno neno ueta maitufisu wei. Ana anama Dawa imutaitaro Dana torowa emanu neno neno ueta maiturasuro Godima emana kobere uwara imutasu. Mosesinu tarawatuma i neno neno ueta maiturawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Eforo, i we bou ueta uwaranu sina yabai fafisu aba? Emanu sina eno, ");
INSERT INTO yrb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ya Godiba siosa sina waita uwara eno imufote uifoita weita. Yabai Nanu uetana derawere. Mui amarama yaba i ueta nesia we mawetu ufiro da naufoita, i uwarama eno weita. ");
INSERT INTO yrb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Foro danu sina eno weiro dawaini Banabasi wawaro anita. Anitaro weita, etei mui sabate kowaro nono wiawaro naufe weita. ");
INSERT INTO yrb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","I uwara nesia wo bagaru ue anitaro moana Ju uwaraini moana Godiba iyarebita uwarama Foroini Banabasinu buribi anita. Anitaro weisi, Godima ya kobererau durua utasuba Danu dabaro inaregou uforo we enanari usi. ");
INSERT INTO yrb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Etei mui sabate kowaro i su uwara faiyawere Godinu sina naufitae anita. Eme ba torowa suro yaubita. ");
INSERT INTO yrb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Eme faiyawere anitaro moana Ju uwara i eme fefera etate unutawa iba dua sina weitate Foronu we mawetu uetaini wetaini meo weitate i amara sadeina siosawere weita. ");
INSERT INTO yrb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Eno weitaro Foroini Banabasima iyarawa usite weisi, Godi Danu unuba i sina yabai ko waitu. Awona Godinu sina mu sanaitate yanu torowa koto utaitaba Godinu me ibene ibene ibeta da muboita weisi. Eno utaitaba i aika uwaraba webutu weisi. ");
INSERT INTO yrb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Godima Danu bukaroma yaba eno wei, i Ju me aika uwaranu ariona ya. Anibote i orofa atata aika maika uwara nesiabai weboro naufitaitana wiroeta mubitaita, eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Foroma eno weiro i Ju me aika uwara nautate yaru uteda Godiba we ma kobererau uta. Godinu mune oeta uwara faiyawere Godi imuta. ");
INSERT INTO yrb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Godinu sinama aboro aboro nesia anegou ui. ");
INSERT INTO yrb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","I Ju uwara ema unutawaba ejiwa sina weitaro moana baeta awetaboini emeini nautate Foroini Banabasi natofo su uwarama yowetaro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ane emanu buriro sakai maitusiro i Ju uwarama ema ekoita iwata uta. Foroini Banabasi Anitiyoka suroma Aikoniamu suro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Godinu Imumu Kotofuma Danu iwata ueta uwarabai ibegou uiro yaru derawere uta. ");
INSERT INTO yrb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aikoniamu suro ane fasite Ju uwaranu dubu suro amusite Godinu sina bunawere weisi. Weisiro moana Ju uwaraini Guriki uwaraini nautate Godi imuta. ");
INSERT INTO yrb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Godinu sina nautawa Ju uwarama dua sina weitaro i aika uwarama nautate i Godinu sina naueta uwaraba ubusi uyata. ");
INSERT INTO yrb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Foroini Banabasi iro kowa faiyawere ibeda Yesunu kobere durua ueta sina weisi. Weisiro Yesu erite emabai buna uetaini ereta faiyawere mairo usi. ");
INSERT INTO yrb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","I Aikoniamu su uwara imueta daba demuraina me. Moana uwarama Ju uwaranu sina nauta. Moana uwarama afosoro uwaranu sina nauta. ");
INSERT INTO yrb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","I aika uwaraini Ju uwaraini emanu yawoeta uwaraini i afosoro uwara gebiroma ufitae utaro nausi. ");
INSERT INTO yrb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Nausite i su sau ekoisite Raikonia orofa su sadeiro anisi. Risitaini Debi suro anisi. I su sadeini i orofa kabesi faiyawere ane iro Yesunu sina we inarebisi. ");
INSERT INTO yrb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","9","Mui Risita su amara danu buri takami uiro anawa, dawa danu muneta kowaroma buri anawa eno ibebi. ");
INSERT INTO yrb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Dana Foronu sina nauiro Foroma i amara eregou uteda i amarana wirofie imutasu we imuite derawere wei, anu burima yare ina wei. Weina sau uyari. ");
INSERT INTO yrb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Eno uiro i guruguru uta uwarama etate emanu Raikonia sinaroma weita, godi eme ari yabai farita eawe weita. ");
INSERT INTO yrb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Weitate emanu godi Jufata, danu ifu Banabasinu mui ifu mata. Emanu mui godi Makari, danu ifu Foronu mui ifu mata. Foro dawa sina weta amaraba iba Makari ifu mata. ");
INSERT INTO yrb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","I godi Jufatanu dubu su barunaro inaibi. I dubu su fuyo oeta amaraini moana uwaraini siginaini borumakau mutate fuyo i afosoro uwaraba odifitae su barunabai woure fata. ");
INSERT INTO yrb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Fataro Banabasini Foro nausite imuteda emanu wadia ma bujebaje usite i uwarabai fare weisi, aneba eno utaita weisi? Wana godi me, wana ba eme, ya ari weisi. Kotofu sina webune yabai farisia weisi. I kotofu sina eno, i ba me godina kodiawete oweawete i me ibene ibene ibeta Godibai aniawe weisi. I ba Godima ureini nasini eneaini ibaiabai nesia ubu ui. ");
INSERT INTO yrb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Boderewereroma uwarama emanu unu utebita. Utebitaro Godima emanu sara siosa ueta ereda me yawotebi. ");
INSERT INTO yrb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ereda yawotebe ibo utawa uite ema obi ureroma siaia uiro itari. Obi matebiro emanu ieta derawere waratebiro yaru utebita. Godima eno uite awona enanari utasuba Danu aika eno ma boroyarasuba Dawa ba Godi iwata utaisi weisi. ");
INSERT INTO yrb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Enoma enoma webe webe oisiro i uwarama fuyo oeta ekoita. ");
INSERT INTO yrb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Moana Ju uwarama Anitiyokaini Aikoniamu suroma i Risita su uwarabai are fatate Foroini Banabasiba wawei weita. Eno woroworo webitaba i uwara nautebe arama utate gebiro mutate Foro sane uta. Eno utaro sakairo urei. Ureiro agero mutate ma youre su baruna wawaro sane oita. Dana uisinua we imutate iba iro sane oita. ");
INSERT INTO yrb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Sane oitaro Yesunu buribi aneta uwarama Foro ode kara utana Foroma uyarite suro ani. Wai uriro uyarite Banabasini iroma Debi suro ane fasi. ");
INSERT INTO yrb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","22","Debi su uwarabai Yesunu kotofu sina weisiro uwara faiyawere nautate Godi imue naue uta. Duburo Debi su ekoisite owesite Risita suini Aikoniamu suini Anitiyoka su Godinu sina naueta uwarabai ane Godinu sina eno weisi, Godibai ibegou uawe. Awe awe kowa faiyawere uyafiro duburo Godinu yawoeta orofaro aniboita weisi. Eno weisiba i Godinu sina naueta uwarama nautate buna uta. ");
INSERT INTO yrb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Foroini Banabasima i dubu su su yawoeta uwara mune emabai oisite ieta itawa ka utate i uwaraba guriguri uteda weisi, Yesu, ema yawoegou ua weisi. Enoma enoma usite anisi. ");
INSERT INTO yrb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ane Fisidia orofa serigari usite Famufiria orofaro fasi. ");
INSERT INTO yrb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Fega suro fasite Godinu sina weisite ekoisite anisi. Ane Ataria suro tanisi. ");
INSERT INTO yrb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Boutiro amusite iroma Anitiyoka suro anisi. I Anitiyoka suro aubokona Godima weiro i uwarama Foroini Banabasi mune oitate Godibai emaba guriguri utaro anisite nono reka owere fasi. ");
INSERT INTO yrb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Fare weisiro i Godinu sina naueta uwara nesia fata. Fataro weisi, Godima i aika uwaranu neno ma ifegari uiba i aika uwarama emanu naueta Godibai odaita weisite Godinu ueta nesia emaba weisi. ");
INSERT INTO yrb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Foroini Banabasima Anitiyoka suro i naueta uwarabai kowa faiyawere ibisi. ");
INSERT INTO yrb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Foroini Banabasima Anitiyoka suro ibebitana moana Judia uwarama Anitiyoka suro fatate weita, Ju uwaranu ofe tureta da tufoitana nono Godima ya da ma wirofisu weita. ");
INSERT INTO yrb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Foroini Banabasima derawere weisi ina ba me weisi. Eno webisina i Anitiyoka su Godinu sina naueta uwarama Foroini Banabasini moana Anitiyoka Godinu sina naueta uwara i sina Jerusaremu afosoro uwaraini dubu su yawoeta uwarabai i sina webitae siaia uta. Siaia utate su baruna wawaro woure oitaro anita. ");
INSERT INTO yrb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ane Fonisia orofa su suini Samaria orofa su suro Godinu sina weita. Eno weita, Godima i aika uwara awona ma wirotasu weita. Eno weitaro naueta uwarama yaru derawere uta. ");
INSERT INTO yrb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusaremu suro ane fataro i naueta uwaraini afosoro uwaraini dubu su yawoeta uwaraini ario weita. Duburo i uwara nesina dubu suro guruguru uta. Utaro Godinu emabai ueta nesia emaba weita. ");
INSERT INTO yrb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Eno weitaro moana Ferosi waita uwarama yare weita. I aika uwaranu ofe tufete Mosesinu tarawatu nesia uforo webeisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","I afosoro uwaraini dubu su yawoeta uwarama i sina ma rorowarau ufitae guruguru uta. Utate sina faiyawere we matata. ");
INSERT INTO yrb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","We matataro Fitama uyarite wei, naiyemutu nanu sina nauawe wei. I bodere kowaro yabairoma na mune odi. I aika uwarabai Danu sina wemaro naufitate imufitae na mune odi. ");
INSERT INTO yrb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Godima i aika uwaranu nenoma imueta Dana iwataba Danu Imumu Kotofu siaia uiro emabai itari. Yana Godinu Imumu Kotofu musi, i ari muta. ");
INSERT INTO yrb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Godima emaini yaini arotorowa imui. I uwarama nautate Godi imutaro emanu neno neno ueta maituri wei. ");
INSERT INTO yrb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Eno uiba aneba ofe tureta sina waita? Eno waitana Godinu sina garari ufoe utaita wei. Eno utaitana Godinu sina naueta uwaranu nodoro urumuwere ayuayu ari doifoe utaita wei. Bodere yanu abuamutuini yaini i ayuayu ari woure anawa aneba ya aika uwara yanu ofe tuawe waita wei? ");
INSERT INTO yrb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Emanu wiroetaini yanu wiroetana arotorowa. Emaini yaini naufeisina yanu Dera Waria Amara Yesu Kerisonu kobere durua uetaba Godima ya ma wirofisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Fitama eno weiro i guruguru ubita uwarama nauteda sina wiawa uta. Wiawa utaro Foroini Banabasinu Godi i aika uwarabai buna ueta sina weisiro nauta. ");
INSERT INTO yrb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Emanu sina we me sisiro Jeimisima yare wei, kaka nabue, nanu sina nauawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Fitama wenu, Godima i aika uwara munasute ma wirotasuro nono Danu sina naueta uwara sinaita, wenuro nauisi Jeimisima wei. ");
INSERT INTO yrb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","I sinana i we bou ueta uwaranu weita sinaini arotorowa wei. Emanu sina eno, ");
INSERT INTO yrb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Godima eno wei, mui jugari ui su ma kobererau ufiro uyafisu i ari, Deiwidinu ma jugari ui su nono maimaro uyafisu. Uyafiro Dera yawoeta Amara odimau. ");
INSERT INTO yrb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Enoba uwara nesia, Nanu ifu waita aika uwaraini dobefitate i Dera Amaranu buribi anibitae iba eno umau wei. ");
INSERT INTO yrb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Boderewere Godima i sina eno wei, i we bou ueta uwarama eno weitaya wei. ");
INSERT INTO yrb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jeimisima nono wei, nanu imuetana eno, i Yesunu buribi aneta aika uwaranu ibeta ma kimu da ufeisi wei. ");
INSERT INTO yrb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Emaba eno owawa ufeisi. I ba me godinu fuyo oeta ieta da iforo, dita yagera da faforo, mimi utaisiro onono itarawa utasu egi da iforo, onono da iforo, eno owawa ufete emabai siaia ufeisi wei. ");
INSERT INTO yrb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bodere kowaroma moana uwarama Mosesinu tarawatu natofo su suini Ju uwaranu dubu su nesiaro sabate ainewaure ina yawitebitaro iro ane nautebita. Awona enanari dubu suro ane yawitaisiro nautaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","23","Eno weiro i afosoro uwaraini yawoeta uwaraini Godinu sina naueta uwara nesia nautate idoni, weitate amara sadei, Judasi Basabasini Sairasi muta. I amara sadeina dubu su yawoeta amara sadei. I amara sadeima Foroini Banabasini arotorowa Anitiyoka suro siaia ufitae we mutate emanu imueta owawa ue oita. Emanu owawana eno, ya Godinu sina naueta uwara nesia, afosoro uwaraini yawoeta uwaraini yana ya Anitiyokaini Siriaini Sirisia su aika naueta uwaraba ario weisi. Yanu sina nauawe. ");
INSERT INTO yrb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Moana uwarama ewadoroma yabai anitate weita, Mosesinu ofe tureta uawe weitaro ya iwawa utaro nausi. I uwara yana siaia utawa usiro emanu imuetama me weita. ");
INSERT INTO yrb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Awonana yanu imuetana eno, amara sadei munisiba emaini Banabasini Foro warai siaia ufero yabai anibitaita. ");
INSERT INTO yrb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Banabasini Foroma Yesunu gaukara utebisiba moana uwarama ma uifitae utaro ema uietaba iyarawa usi. ");
INSERT INTO yrb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Judasini Sairasi siaia utaisiba fafisisina bebetuma i owawa sina nesia webisisi. ");
INSERT INTO yrb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Imumu Kotofuini yanu imuetana eno ya aika uwaranu ibeta ma kimu utawa utaisi. I sinaratu torowa waisi. ");
INSERT INTO yrb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Eno, i ba me godinu fuyo oeta egi da iawe, onono da iawe, mimi utebaitaro onono nasiniro itarawa utebasu egi da iawe, dita yagera da fawe. Eno ufoitana kobererau ibifoita. Ido yanu sina me sininu. ");
INSERT INTO yrb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","I amara sadei siaia utaro anita. Ane Anitiyoka suro tanita. Tare weitaro i naueta uwarama guruguru uta. Utaro i owawa mataro yawita. ");
INSERT INTO yrb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","32","Yawie me sitate sina kobererauba yaru uta. I we bou ueta amara sadei, Judasini Sairasima sina faiyawere i uwaraba weisina i uwaranu imueta kobererau uta. ");
INSERT INTO yrb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Moana kowaro iro itebitaro i Godinu sina naueta uwarama Judasini Sairasi siaia utaro owesite Jerusaremu su Godi naueta uwarabai ario sina woure ane fasi. ");
INSERT INTO yrb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Sairasi danu aika iro ibebi dawa anawa.) ");
INSERT INTO yrb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Foroini Banabasima Anitiyoka suro ibeda emaini moana Godinu sina naueta uwarama Godinu sina weda we mawetu utebisi. ");
INSERT INTO yrb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","38","Mui kowaro Foroma Banabasiba wei, wanu bodere Godinu sina we inarebitu iro nono anibute efutu wei. Kobererau aba aramawere ibinita efutu weiro nauite Banabasima Joni Maka woufie wei. Weiro Foro dawa unutawa Joni Maka woureta. Bodere Joni Maka ema Famufiria orofaro ekodite aniba iba Foro dawa unutawa Joni Maka woureta. ");
INSERT INTO yrb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Emanu imuetana aikaba Banabasini Joni Makama anisi. Boutiro amusite Saifurasi mutumuturo anisi. ");
INSERT INTO yrb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Foroini Sairasima iro anisi. I naueta uwarama Godibai Foroini Sairasiba guriguri utate siaia utaro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ane Siriaini Sirisia orofa su suro Godinu sina we inarebisiro i Godi nautebita uwara emanu imueta ma kobererau uta. ");
INSERT INTO yrb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Foroini Sairasima Debi suro ko anisite ekoisite Risita suro ane fasi. I suro mui amara danu ifu Timoti atasi. Timoti danu danuana Godinu sina naueta Ju aweta, danu damamana Guriki amara. ");
INSERT INTO yrb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","I Risitaini Aikoniamu Godinu sina naueta uwarama Timoti dana kobere amara we imutebita. ");
INSERT INTO yrb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Eno imutaba Foroma Timotiba wei, aini Godinu sina we inareta dabaro anibeisi wei. I Ju uwara emanu baeta uteda Timoti munite danu ofe turi. Timoti danu damamana Guriki amaraba iba danu ofe turawa uiro i Ju uwara nesia dawa iwata utaba eno ui. ");
INSERT INTO yrb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Duburo Foroini danu uwara moana orofaroini su suro aboro aboro ane inareda i aika uwarabai anitate emaba Jerusaremu suro ibita afosoro uwaraini dubu su yawoeta uwaranu imueta sina webita. I uwara naufitate ane ane webitae iba webita. ");
INSERT INTO yrb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Eno utebitaba i Godinu sina naueta uwaranu imuetana derawere uyariro uwara faiyawere Godi imutaba i dubu su uwara faiyawere uyata. ");
INSERT INTO yrb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Iroma Eisia orofaro anibitae utaro Godinu Imumu Kotofuma i daba garari ui. Garari uiba Firigiaini Gareisia orofa aboro aboro inarebita. ");
INSERT INTO yrb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","8","Ane Misia orofa gigirari fatate Bitinia orofaro anibitae utaro Yesunu Imumu Kotofuma iro da aniawe weiba Misia orofa serigari utate Toroasi suro tanitate iro aita. ");
INSERT INTO yrb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Dumuro Foroma nauta ainibebe tube eri. Tuberoma mui Masadonia amara inaibeda nui wei, Masadonia orofaro arate ya durua ua wei. ");
INSERT INTO yrb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Foroma i tube erite yaba weiba Godi Danu ununa Danu sina i uwarabai webene i daba usinu imusite i daba dobefene usi. ");
INSERT INTO yrb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Yana boutiro amusite Toroasiroma Samotureisiro anisi. Anisite aisite wau uriro Samotureisiroma Niaforusiro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Iroma Firifai suro fasi. Firifaina i Masadonia orofanu botai su. I suna Romani uwaranu su. Iro fasite kowa faiyawere ibisi. ");
INSERT INTO yrb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabate kowaro moana uwara ogo gigirariro guruguru uteda guriguri utebaita weitaro nausite anisi. Su baruna wawaro anisite ogo gigirariro ane fasite moana guruguru uta awetaboba Godinu sina weisi. ");
INSERT INTO yrb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Yanu sina naui mui awetana danu ifu Ridia. Danu su Taiataira. I awetana Godi guriguri utebi. Danu gaukarana kukui wadia oiya ueta. Dana Foronu sina nauiro Godima danu neno ma ifegari uiba Foronu sina nauegou ui. ");
INSERT INTO yrb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Dawaini danu suro ibebita uwara nesia yabai babataito utaro Ridiama wei, yana na Godi nauegou utatane imuteiboitana nanu suro are ibiawe wei. Eno webiba danu suro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mui kowaro i guriguri ueta kabesiro anedana wada barau aruma atasi. I arumana seitaninu mui imumu siosa bobo aruma. Dana wada barau gaukara uteda oi derawere munebite danu yawoeta uwaraba matebi. ");
INSERT INTO yrb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","I arumama yanu buribi arite orere derawere wei, ewa uwarana Godinu gaukara uwara. Godima ya ma wirofie farita eawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kowa ainewaure woroworo eno webiro Foro nautebe arama uite wei, i aruma danu neno ubarero ibi siosa imumuba bunawere wei, Yesunu ifuro watane a danu neno ubareroma amuate fare wawaro ania wei. Weina sau ido amuite fare ani. ");
INSERT INTO yrb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","I arumanu yawoeta uwarama etate we imuta, yanu oi muneta daba ido me sininu we imuta. Foroini Sairasi budari utate i su tutububai yaubeta koto uwarabai woure ane oita. ");
INSERT INTO yrb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Eno utate weita, i Ju amara sadeima siosa sina waisiro ewa uwarama siosa siosa imutaita weita. ");
INSERT INTO yrb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","I Romani uwaranu tarawatu da nauawe waisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Weitaba eme faiyawere guruguru uteda ibo utaba i koto ueta uwarama Foroini Sairasinu wadia ma babare satate weitaro isuma uta. ");
INSERT INTO yrb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Isuma urebe urebe ekoitaro onono farebi. Enoma enoma utate ema woure dibura su ubarero ane oitate i dibura yawoeta amaraba weita, i amara sadei yawoegou ufaro weita. ");
INSERT INTO yrb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Eno weitaba i amara sadei mune ane i dibura sunu ubare koruro odi. Odite senima emanu buri sadei mune anaro uwane badame ue odi. ");
INSERT INTO yrb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Dumu abanaro Foroini Sairasima Godiba guriguri uteda soni webisiro i dibura su ubarero yaubita uwara nauta. ");
INSERT INTO yrb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Soni webisina sakai wawana wawana derawere uiro dibura su wawana wawana uiba dibura su kasimu nesia ifegari utaro i dibura uwaranu seni nesia kokosugari utate itata. ");
INSERT INTO yrb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","I dibura yawoeta amara nauta ainibiro eno utebina danu diti forairo uyareda kasimu ifegari ueta erite we imui, i dibura uwara nesia iya anita, we imuite danu kaiya munite danu nodo tufie utebi. ");
INSERT INTO yrb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Eno utebiro Foroma derawere wei, eno da ua wei, ya nesina ewado wei. ");
INSERT INTO yrb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Weiro nauite iya derawere uyareda nanefa mai wei. Ekiwa munite dibura su ubarero sau itarite iya derawere uteda iwura mameda Foroini Sairasinu buri gigirariro arubi ui. ");
INSERT INTO yrb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Eno uite uyarite Foroini Sairasi woure wawaro odite wei, yawe, wiroeta anene mumau wei? ");
INSERT INTO yrb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Weina Dera Waria Amara Yesu imuegou ua weisi. Eno ufasuna aini anu suro ibeta uwara nesia Dawabai wirofoita weisi. ");
INSERT INTO yrb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","I dibura yawoeta amaranu su ubarero amutaro Foroini Sairasima i amaraini danu suro ibeta uwaraba Godinu sina weisi. ");
INSERT INTO yrb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Weisiro i amarama Foroini Sairasi munite emanu ofe uburo iwiji awiji ogoma uroiro dawaini danu sisia uwara nesia emabai babataito uta. ");
INSERT INTO yrb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Babataito utaro i amarama ema woure danu suro ane ieta nabero mairo ita. Eno uiro dawaini danu sisia uwarama emanu naueta Godibai oitate yaru derawere uta. ");
INSERT INTO yrb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wai urina i koto ueta uwarama forisimani siaia utaro anita. I amara sadei ma uregari ufitae anita. Ane fatate weita, i amara sadei ma uregari uaro anibisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Weitana i dibura yawoeta amarama Foroba i sina eno wei, i koto ueta uwarama ya ma uregari umane waya siaia uitaba iba wawaro aniawate kobererau aniawa wei. ");
INSERT INTO yrb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Weina Foroma wei, emana wa emenu ditiro isuma urebita. Wana siosa ueta utawa utu. Wana Romani uwara. Emanu ununa wanu kiwuma aneta. Ina da ufutu. Fafitate wa woure ane odifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Weiro forisimani anitate i koto uwaraba Foronu sina weita. Foroini Sairasima yaini ya Romani uwara weita i sina nautate iyata. ");
INSERT INTO yrb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Iyataba Foroini Sairasibai anitate nenoro imutate ario weitate nui weita, yanu natofo su kodiawate aniawa nui weita. Eno weitaro dibura suroma amusite anisi. ");
INSERT INTO yrb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ridianu suro anisite i Godinu sina naueta uwaraba Godinu sina weisite emanu imueta ma kobererau usite natofo su ekoisite anisi. ");
INSERT INTO yrb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","2","Foroini Sairasima ane Amofiforisi suini Aforonia suro fare fare daido fare anisi. I su sadeiro fare fare daido fare ane Tesoronaika suro fasi. Iro Ju uwaranu dubu su inaibiba Foroma amuite Godinu sina wei. Danu eno ainewaure utebi iba sabate kowa rarogonu i dubu suro amutebite Godinu bukaroma sina bunawere webi. ");
INSERT INTO yrb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Eno wei, yanu fafisu yawoeta Amara awe awe derawere muneda oferi derawere woufite uifite nono uietaroma uyafisu wei. Nana ewa Yesu Kerisoba watane. ");
INSERT INTO yrb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Eno bunawere weiro moana nautate ina Yesu Keriso eno we imutate iba Foroini Sairasibai ane taka uta. Moana Godi naueta dera Guriki uwara, emeini awetaboini emanu naueta Yesubai oitate emabai ane taka uta. ");
INSERT INTO yrb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Eno utaro moana Ju uwara ema Godi nautawaba iba dua sina weitate siosa uwara faiyawere mutate Foroini Sairasi ufitae imutaro eme fefera guruguru uteda weroroka derawere weita. Weitate Jesoninu suro anitate fare Foroini Sairasi i kanisoro uwarabai woure ane odifitaro fanisi mafitae iba anita. ");
INSERT INTO yrb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Jesoninu suro fatate Foroini Sairasi dobetana meba munawa uta. Munawa utaba Jesonini moana naueta uwara budari utate i kanisoro uwarabai woure ane oita. Woure ane oitate weita, Foroini Sairasi, i amara sadeima orofa atata uwara nesianu imueta ma siosa siosa usite awona ewaro farisia weita. ");
INSERT INTO yrb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Awona farisite Jesoninu suro ainibinisi weita. I amara sadeima dera yawoeta amara Sisanu tarawatu nautawa utaisia weita. Mui kini Amara, Danu ifu Yesu, ibinu waisia weita. ");
INSERT INTO yrb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","9","Eno weitaro i natofo su uwaraini kanisoro uwarama i sina nautate jaja utate weita, Foroini Sairasiba yabai oi maiwe weita. I amara sadeima merau ibebe anibisisina yanu oi ma owere mafeisi weita. Eno weitaro oi mataro kanisoro uwarama ema siaia utaro anita. ");
INSERT INTO yrb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Foroini Sairasibai ane fatate dumuro siaia utaro Foroini Sairasi anisi. Ane Beria suro fata. Beria suro fatate dubu su ubarero Godinu sina webitae amuta. ");
INSERT INTO yrb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","I Beria Ju uwarana kobere uwara. Tesoronaika su uwara ari me. I Beria uwarama Godinu sina nauegou utate Godinu buka ainewaure yawiegou utebita. Foroini Sairasinu sina ba aba me we imutaba iba Godinu buka yawiegou utebita. ");
INSERT INTO yrb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Eno utebitaba Ju uwara faiyawereini dera Guriki emeini awetaboini emanu naueta Yesubai oita. ");
INSERT INTO yrb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Foroma Godinu sina Beria suro webina Tesoronaika uwarama nautate Beria suro ane fatate ibo uteda ejiwa sina weitaba uwara faiyawere Foroba jaja uta. ");
INSERT INTO yrb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Eno utaba i Godinu sina naueta uwarama Foro siaia utaro ane bouti munite moana uwaraini ani. Sairasini Timotima Beria suro ibebisi. ");
INSERT INTO yrb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Foroini danu uwarama Atena suro fataro Foroma emaba wei, aniawete Sairasini Timoti nabai siaia uawero nabai sau fafisisi wei. ");
INSERT INTO yrb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Foroma Atena suro i amara sadei yawotebina i Atena su uwaranu agema ubu ueta godi fefera deina ereda neno siosa utebi. ");
INSERT INTO yrb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Eno utebiba Ju uwaranu dubu su ubareini natofo su guruguru ueta kabesiro i Ju uwaraini guruguru ueta uwaraba Godinu sina bunawere webi. ");
INSERT INTO yrb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Moana Efikuriani waita uwaraini moana Sitoiki waita uwara atanite emaba Godinu sina wei. Weiro nautate moanama weita, ewa sina bana bobo amarama ane wasu weitaro moanama weita, dana aika siboro uetaba wasu weita. Foroma Yesuini Danu uietaroma uyareta sina webiba iba eno weita. ");
INSERT INTO yrb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Eno weitate Foronu agero mutate emanu guruguru utebita maidaniraturo woure mane oita. I maidaninu ifuna Areafagu. Iro woure mane oitate weita, anu reka siboro ueta sina wiaro naufe weita. ");
INSERT INTO yrb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","I sina bodere nautawa awona kamama nautaisi weita. I sinanu ubi iwata ufene waisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atena uwaranu karana eno, ainewaure kamama wetaini uetaini naueta iwata ufitae utedibebita. Iba uwaranu aika maika sina nauteda sina faiyawere wedibebita). ");
INSERT INTO yrb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ibago Foroma Areafagu guruguru ueta abanaro yare wei, Atena uwara nanu sina nauawe wei, yana siboro uegou utebaitaro na eratane wei. Yanu siboro ememetuna faiyawere, nana ane ene wei. ");
INSERT INTO yrb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Na anedana mui fuyo oeta enero danu owawa oeta ibinu. I owawa oetana eno, ewa fuyo oetana ya iwata me godinu. Ewa Godi yaba watane wei. ");
INSERT INTO yrb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ewa Godina ureini nasini i ibaiabai nesia ubu ui. Ewa Godi Dawa ureini nasini yawotasuba, Dana emema ueta suratu ubarero ibawa utasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Emenu agema Dawaba ane ane matawa utaisi, Danu torowama yanu neno sanetaini me ibeta ane ane matebasuba iba Dawaba matawa utaisi wei. ");
INSERT INTO yrb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Godima amara demurairatu munite orofa atata uwara nesia Dawabairoma ubu uite emanu orofa aika maikaro odite emanu ibeta oya enanari weiba eno me ibebaisi wei. ");
INSERT INTO yrb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Eno uite uwara nesia Dawa dobefitate imufitae iba eno ui. Yabairoma Dawabai daba yafa me, Dana baworo. ");
INSERT INTO yrb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Foroma emaba wei, awonana Dawa Godiba iba inaraisite me ibebaisi. Ya uwaranu owawa oeta uwarama eno weita, yana Danu sisia uwara weita. ");
INSERT INTO yrb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","30","Yana Danu sisia uwaraba Godi Dawa siriwa, o goro, o gebiro, o emenu imueta ememetuna i ari me, eno da imufeisi wei. Bodere uwarama Godi iwata meba iba Godima ema ibo utawa. Awonana Dana ya uwara nesiaba eno buna wasu, yanu neno neno ueta dubena afu sawe wasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Godima, Danu odi kowaro, ewa orofa atata uwara nesia mui amarabai rorowarau koto ufisu wei. I Amarama uietaroma ma uyariba ya nesia iwata ufene iba eno ui wei. ");
INSERT INTO yrb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","I uietaroma uyareta sina nautate moana uwarama meo, weita. Moana uwarama yanu ununa nono naufeisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Foroma sina we me sinite i uwara ekodite wawaro ani. ");
INSERT INTO yrb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wawaro aniro moana uwaraini dawabai anitate emanu naueta Godibai oita. Daionisia, dawa Areafagu koto amara, dawaini mui aweta Damarasini moana uwaraini dawabai anitate emanu naueta Godibai oita. ");
INSERT INTO yrb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Foroma Atena su ekodite Korinita suro ane fari. ");
INSERT INTO yrb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","I suro Ju amara danu ifu Akuira atani. Danu danuama dawa muni orofana Fonitia. Akuirama danu aweta, Fasiraini Itaria orofaroma reka fasi. Korodiasi Sisa, Romani dera yawoeta amarama Ju uwara nesianu ibeta unutawaba weiro awetaini awera Itariaroma Korinita suro are fasi. Foroma ema efie emanu suro ani. ");
INSERT INTO yrb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Foroini Akuira emanu gaukara arotorowa. Emanu gaukarana farai wadia ueta iba Foroma emabai ibeda arotorowa farai wadia gaukara utebita. ");
INSERT INTO yrb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabate kowaro ainewaure Ju uwaranu dubu suro amutebiro Ju uwaraini Guriki uwaraini sina sina we matanebitaro moana Ju uwaraini Guriki uwarama Foronu sina nautebita. ");
INSERT INTO yrb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Duburo Sairasini Timotima Masadoniaroma are ido fasi. Are fasiro Foroma Ju uwaraba wei, Yesuna ya Ju uwaranu ma wiroeta Amara wei. ");
INSERT INTO yrb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","I Ju uwarama Foronu sina munawa utate emanu imueta ma kimu uteda Yesuba siosa sina weita. Eno utaba Foroma uyarite i uwara ema ekodifie uteda iba danu wadia ure fufuteda wei, yana Godi unutawaba ina yanu kerere, nanu kerere me wei. Awonana ya Ju uwara ekodimate i aika uwarabai animate Godinu sina wemau wei. ");
INSERT INTO yrb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Foroma i Ju uwaranu dubu su ekodite Taitasi Jasitasinu su, i dubu subai, ane amui. Taitasi Jasitasi dawa Godinu mui naueta amara. ");
INSERT INTO yrb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kurisifasi, dawa i Ju uwaranu dubu su yawoeta amara, danu suro ibeta uwara nesiaini moana Korinita uwaraini emanu naueta Yesubai oitate emabai babataito uta. ");
INSERT INTO yrb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Mui dumuro Foroma nauta ainibebe tube erina Yesuma wei, iya da uyate wate mu da ua wei. ");
INSERT INTO yrb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Weite wei, abai ibineba eme aba da urafitaita wei. Nanu Na imufitaita uwara faiyawere ewa suro ibinita wei. ");
INSERT INTO yrb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Foroma tube eno eriba Korinita suro mui oyaroma ane mui oya abanaro iro ibeda ainewaure i uwarabai Godinu sina webi. ");
INSERT INTO yrb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","I amara Garioma i Akeiya orofa yawotebina i Ju uwara faiyawerema Foroba ibo utate urafitae uteda yare Foro i koto ueta uwarabai woure ane oita. ");
INSERT INTO yrb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Iro woure ane oitate weita, ewa amarama eno wasu, Godi torowa imutebeawe wasuba yanu tarawatu ma siosa utasu weita. ");
INSERT INTO yrb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Weitaro Foroma danu ununa sina webie uina nono i koto yawoeta amara, Garioma Foronu sina weta daba garari uite i Ju uwaraba wei, danu kerere anene? Dawa waira utawa, eme urawa eno utawaba iba dawa koto da umau wei. ");
INSERT INTO yrb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","16","Yanu Ju uwaranu tarawatu sina ma siosa ui o yanu buruka uwaraba siosa sina wei o ina na iwata me, weite danu koto su ubareroma ema yoweriro anita. ");
INSERT INTO yrb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ane reka Ju uwaranu dubu su yawoeta amara Sositinisi mune isuma urebita. Koto subai Sositinisi isuma urebitana Garioma i uetaba sina mui wiawa ui. ");
INSERT INTO yrb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Foroma kowa faiyawere Korinita suro ibebe nono i su ekodite boutiro amuite Fasiraini Akuira munite Siria orofaro anibie ui. Iro anibie aneda Sinikuria suro farite Godiba bodere we bou uiba danu kofiri giriri ui. Ina Ju uwaranu baeta. ");
INSERT INTO yrb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Iroma Efesa suro ane fata. Fataro Foroma Fasiraini Akuira ekodite Ju uwaranu dubu suro amuiro dawaini i Ju uwara sina sina bunawere we matanebita. ");
INSERT INTO yrb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","21","I Ju uwarama bana weitana Foroma me weite wei, Godi nanu owereta webisuna ido owemate famau wei. Weite Efesa suroma ane boutiro amuite Sesaria suro ani. ");
INSERT INTO yrb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Anebe ane Sesaria suro farite i Godinu sina naueta uwarabai manite iro mane yaubi. Mane yaubebe i uwara ekodite Anitiyoka suro tarani. ");
INSERT INTO yrb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tane Anitiyoka suro ibebe i su ekodite Gareisiaini Firigia orofa su suro aneda Godinu sina weite i Godinu sina naueta uwaranu imueta ma buna ui. ");
INSERT INTO yrb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Duburo mui Ju amara, danu ifu Aforasi, danu Arekisania suroma Efesa suro fari. Dana kobere sina wetaini Godinu buka yawieta amara. ");
INSERT INTO yrb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Aubokona moana uwarama dawa Yesunu imueta we mawetu utebitaro dana Joninu babataito ueta torowa iwata uite Yesunu imueta nesia nautawaba iba iwata utawa ui. ");
INSERT INTO yrb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","I amarama Efesa suro farite danu neno nesia sina weta unu uiba Ju uwaranu dubu su ubarero amuite Godinu sina bunawere wei. Weiro Fasiraini Akuirama nausite i amara musite Godinu imueta nesia dawaba we mawetu uegou usi. ");
INSERT INTO yrb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Duburo Aforasima danu unu Akeiya orofaro anetaba i naueta uwarama owawa oitate i Akeiya orofa naueta uwarabai siaia utate weita, ewa amaranu ueta sineta kobererauba dawa muawe. I owawaro eno we oitate siaia uta. Aforasima iro farite Godinu sina naueta uwaranu imueta ma kobererau ui. ");
INSERT INTO yrb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Dana Godinu buka muneda iroma Yesuna i Ju uwaranu ma wiroeta Amara bunawere we mawetu uiba i Ju uwarama sina mui wiawa uta. ");
INSERT INTO yrb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","2","Aforasima Korinita suro ibebina Foroma i maidani orofaro inarebe iroma Efesa suro tarani. Tare moana naueta uwara ataneda wei, yanu Godi imuta kowaro Godinu Imumu Kotofuma yanu neno ubarero itariro muta aba me wei? Weina ane wasu, Godinu Imumu Kotofude ane weita? ");
INSERT INTO yrb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Weitaro Foroma wei, ananu imueta mutate babataito uta weina Joninu weita. ");
INSERT INTO yrb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","6","Weitaro Foroma wei, Jonima wei, yanu neno neno ueta dubena afu sawete nanu buribi areta Amara imuawe, Jonima wei. I amarana Yesu, Foroma weiro i uwara nautate emabai Yesunu ifuro babataito utaro Foroma age emanu kofiri deiro odi. Eno uiro Godinu Imumu Kotofuma emanu neno ubarero itariro sina aika maika weitate Godinu we bou ueta sina weita. ");
INSERT INTO yrb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Amara tuero (12) eno uta. ");
INSERT INTO yrb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","9","Foroma sabate ainewaure Ju uwaranu dubu su ubarero amutebite Godima ya kobererau yawotasu webi. Sakara rarogonuro eno utebiro moana uwarama emanu imueta ma kimu uteda imutawa utate i guruguru ubita uwara nesiaba weita, ewa Yesunu dabana siosawere weitana Foroma Godinu sina naueta uwara munite woure ani. Ane Tiranasinu sikuru su ubarero kowa woroworo guriguri uteda Godinu sina webi. ");
INSERT INTO yrb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Oya sadeiro eno utebitaro i Eisia uwara nesia, Ju uwaraini Guriki uwara nesina Yesunu sina nautate moana naueta uwara sitaro moana nautawa uta. ");
INSERT INTO yrb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Godima Foro danu buna mairo Foroma buna ueta derawere ui. ");
INSERT INTO yrb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Uiba danu agesifi o wadia mutate ofe woureta uwaranu ofero oitaro sau wirotaro seitaninu moana imumu siosa emanu neno ubareroma amutate anita. ");
INSERT INTO yrb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Moana Ju me inareta wada barau uwarama Yesunu ifuro seitaninu moana imumu siosa yowetate eno weita, Foronu wasu Yesunu ifuro aniawe weita. ");
INSERT INTO yrb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","15","Mui Ju fuyo oeta amaranu adarabu nesia sewenima (7) eno utana i seitaninu mui imumu siosama wei, Yesu na iwata, Foro na iwata, nono yade anaiya wei? ");
INSERT INTO yrb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Weina i seitaninu mui imumu siosa bobo amara iroma kiubaro i amara seweni (7) urite emanu wadia mune eta kebiro sane ure yanae ui. Eno utebiba i uwara su ubareroma ofe torowa wawaro sau fare anita. ");
INSERT INTO yrb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","I Efesa su uwara nesia, Ju uwaraini Guriki uwara i ueta nautate iya derawere uyatate Yesunu ifu we ma kobererau uta. ");
INSERT INTO yrb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Reka naueta uwara faiyawere emabai fatate emanu dodoa wetaini siosa ueta sineta we ma borobayata. ");
INSERT INTO yrb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Moana wada barau uwarama emanu barau ibaiabaini bukaini woure kabesi demurairo sane oitate inama yata. I bukana faiyawere. I bukanu dawana teni tausani kina (K10,000). ");
INSERT INTO yrb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Eno utaba Godinu sina derawere weitaro eme faiyawere emanu naueta Godibai oita. ");
INSERT INTO yrb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Duburo Godinu Imumu Kotofuma Foro Danu imueta mairo Foroma nenoma we imui, Masadoniaini Akeiyaro fare animate Jerusaremu suro animau eno we imuite wei, nono duburo iroma Romani dera suro animau wei. ");
INSERT INTO yrb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Foroma danu dawa durua ueta amara sadei Timotini Erasitasini Masadonia orofaro siaia uiro anisina dawa Eisia orofaro moana kowaro iro ibebi. ");
INSERT INTO yrb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","I kowaro uwara faiyawerema Godinu sina naueta uwaraini urafitae uta. ");
INSERT INTO yrb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Dimitirisima weiba iba urafitae uta. I amara danu gaukarana i ba me godi, Daienanu kiki suraratu siriwama ubu ueta. Ina danu gaukara. Moana uwarama i gaukara utebitate oi derawere munebita. ");
INSERT INTO yrb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","26","Dimitirisi i uwaraba weiro guruguru utaro wei, yawe, ewa gaukara utaisite oi derawere munaisi weite wei, Foroma wasu, agema ueta godina ba godi me wasuba Efesa uwaraini Eisia orofaro ibinita uwara faiyawere danu sina nautaitate i agema ubu ueta godi ekodaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","29","Eno wasuba yanu besenesi ureifisu wei. Eisia orofa uwaraini orofa atata uwara nesina yanu aruma godi Daienanu dera dubu su da imufitate dawaba siboro da ufitaro danu ifu kikiratu ufisu wei. Weiro nautate ibo derawere uteda derawere weita, Efesa sunu Daiena dana derawere, weitaba Efesa su uwara nesia imueta aika maika utate dera guruguru kabesiro sau anedana Masadonia amara sadei, Geiasini Aritikasi mune ma youre anita. I amara sadeina Foroini uruama inarebita. ");
INSERT INTO yrb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","31","Foro dana i guruguru kabesiro anibie uiba moana Godinu sina naueta uwarama danu daba garari utaro moana dera Eisia yawoeta uwara, Foronu domayamutuma sina siaia utate weita iro da ania weitaba ekodi. ");
INSERT INTO yrb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Moana uwarama emanu imueta derawere weitaro moana uwarama emanu aika imueta derawere weita. Enoma enoma webitaba i me yaubita uwarama emanu imueta iwata meba we imuta, aneba ya ewaro farisi we imuta. ");
INSERT INTO yrb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","34","Enoba moana Ju uwarama Arekisana ma berabera utaro i uwaranu iboro ane inari. Iro ane inarite i uwaraba moko sina webie age ramamiro i uwarama dana Ju amara etate sina derawere weita, Efesa sunu Daiena dana derawere weita. Weitate i sina fefera webitaro kowa ane serigari ui. ");
INSERT INTO yrb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kowa serigari uiro, i natofo sunu owawa oeta mui amarama age ramamite weroroka ekodiawe weiba i uwarama weroroka ekoitana i amarama wei, ya Efesa su uwarama Daienanu dubu su yawotaisite i ureroma sakairo itareta kakara gebiro yawotaisiro i orofa atata uwara nesia iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Iwata utaitaba weroroka kodiawete siosa ueta da uawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","I afosoro uwarama yanu godinu ibaiabai waira utawa uitate yanu godiba siosa sina wiawa uita wei. ");
INSERT INTO yrb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Dimitirisini danu uwarama wawei sina webitae ufitaitana i koto ueta uwarabai anibitate emanu wawei sina webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Yade, wawei sina weboitana i koto uwarabai weboita wei. ");
INSERT INTO yrb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Romani yawoeta uwarama yanu uraneta yaraneta naufitate fanisi mafitaita wei. Yanu uraneta yaranetana ba me wei. ");
INSERT INTO yrb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Eno weite i uwara nesia siaia uiro wo bagaru ue anita. ");
INSERT INTO yrb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Duburo i weroroka me siniro, Foroma weiro Godinu sina naueta uwarama dawabai guruguru utaro Godinu sina weite ema ario weda ekodite Masadonia orofaro ani. ");
INSERT INTO yrb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Masadonia orofa aboro aboro ane Godinu sina naueta uwaranu imueta ma kobererau utebe ekodi. ");
INSERT INTO yrb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Masadonia orofa ekodite Gurisi orofaro ani. Ane farite sakara rarogonu ibebe Siria orofaro anibie uteda boutiro amufie ui. Uina moana uwarama dawa ma uieta daba doberebitaro nauiba ekodite Masadonia orofaro owemate burima duero animau wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Moana uwaraini anita. Safatu, Beria su amara, dawa Firusunu amara, dawaini ani. Aritikanisi Sekunada Tesoronaika su amara sadeini anisi. Geiasi Debi su amaraini ani. Timoti ani. Eisia orofa amara sadei, Tisikasini Torofimasini anisi. Foroini i uwaraini Gurisi orofa ekoitate Firifai suro ane fata. Na Ruka, Firifai suro ema yawotebitarana ido are fata. ");
INSERT INTO yrb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Foroini aneta uwara ema ko botai Firifai suroma Toroasi suro anitate iro ya yawotebita. ");
INSERT INTO yrb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","I Godima Isaraero uwara Ijifiroma woure aneta ogaro kowa me siniro boutiro amusite Firifai suroma Toroasi suro anisi. Anebe anebe kowa fo (4) me siniro Toroasi su musi. Iro fasite kowa seweni (7) yaubisi. ");
INSERT INTO yrb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","I uiki botai kowa, Sadero, areto ieta ifene guruguru usiro Foroma Godinu sina wei. Foro dawa waidumu anibisu iba sina fefera webiro sakara serigari uite mare otoro fari. ");
INSERT INTO yrb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","I sunu etu dei koru rarogonuro yaubisiro nanefararatu bububu utebita. ");
INSERT INTO yrb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mui reka amara, danu ifu Yutikasi, dana su ario areta ebaro yaubeda nauta ainibiro Foroma sina fefera webiba i amarama nauta kunawere ainibebe ureite etuaroma tare sakairo dowarite ui. ");
INSERT INTO yrb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","11","Uiba Foroma sau taranite i amara yabateda wei, weroroka kodiawe wei, awonana neno saneda ibinu wei. Weiro su dei koruro nono manisiro Foroma ieta nata nata uiro isi. Ie me sisiro Foroma Godinu sina webe webe wau uriro ekodi. ");
INSERT INTO yrb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ekodiro i guruguru uwarama i reka amara mutate neno kobererau ue anitaro yana anisi. ");
INSERT INTO yrb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ane bouti ubarero amusite anisi. Forona duero ani. Yana boutiroma Foro Eisosa suro atafene anisi. ");
INSERT INTO yrb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Eisosa suro ane fasite yawotebisiro Foroma farite bouti ubarero amuiro Mitarina suro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Iroma ane Kiosa orofa serigari usite ane aisite wau uriro uyasite Samosa suro ane fasi. Samosa suro ane fasite ane aisite wau uriro uyasite ido Mairitasi suro ane fasi. ");
INSERT INTO yrb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","17","Foro dawa unutawa Eisiaro ibeta. Danu ununa mui Ju uwaranu ogaro kowa, Fenitikosi waita, fafisuba Jerusaremu suro ibeta, iba Efesa su serigari ufie uiba i Efesa dubu su yawoeta uwara sina fo odiro aniro dawabai ane fata. ");
INSERT INTO yrb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","19","Ane fataro wei, nanu sina nauawe wei, nanu yabai ibebitara ya iwata. Nanu fare kowaroma Godinu gaukarabai neno nesia ure nudarau utebe i webe sasae utawa utebe Godinu gaukara kobererau utebatane wei. I Ju uwarama na ma uifitae utebitaba awe kowa uyarebiro Godinu gaukara uegou utebitara wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","21","Yabai Godinu kobere sina dubu suini yanu su suro Ju uwaraini Guriki uwarabai sina demurai eno webitara, yanu neno neno dubena afu sawete yanu naueta yanu Dera Amara Yesu Kerisobai odiawe eno webitara wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Godinu Imumu Kotofuma naba wasuba awonana Jerusaremu suro animau wei. Iro anene naba ufitaita na iwata me wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Godinu Imumu Kotofuma naba eno wasu, mui su suro anibaro a diburaro odifitate siosawere ufitaita wasu, wei. Eno ufitaitana da ekodimau, nanu me ibetaba da imumaubaro wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","I Dera Amara Yesunu mai gaukara rorowarau umane animau wei. Moana uwarabai Godinu kobere sinaini Danu kobere durua uetaini ido wemane animau wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Aubokona yabai ibebe Godima ya yawotasuba Danu sisia uwara sinaisi wero nauta wei. Awonana mui sina da wemaro yana nanu ibo nawata nono da efoita wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Mui sina kikiratu yaba wemau wei. Godinu kobere sina yaba wegou utebitaraba ana anama me ibebe ibebe yanu naueta Godibai da odifote me uifoitana i uietana nanu kerere me wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Godinu Imumu Kotofuma ya yawoeta uwara mune odiba yanu torowa eregou ufote yanu Godinu sina naueta uwara yawoegou uforo wei. Godima Danu sina naueta uwara Yesunu ononoma oiya uiba Godinu sina emaba maforo naufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Na animaro moana siosa uwarama uyafitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","31","(Awe boroma gasira ifie yowere anasuro iya anaita i ari) siosa uwarama uyafitate Godinu sina naueta uwarabai fafitate we berafitaita wei. Moana meo uwarama yabairoma uyafitate meo sina webitate irufitaitaba moana uwarama emanu buribi anibitaitaba ibago yawoegou uforo wei. Nana yabai neno arama uteda i weda ainewaure Godinu sina wegou utedibebitara wei. Oya rarogonu eno utebitara wei. Awonana ya Godibai odimaro ya yawofisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Godinu sina wegou uforo yanu imueta ma kobererau ufite Danu we mune oeta uwarabai yanu kabesi odifisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","34","Mui amaranu oini wadiaba nana yaru ue diti ure owere ma owere utawa ue, nanu agema gaukara uteda naini nanu uwaranu ietaini wadiaini oiya utebitara wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nanu utebitara i ari ufote i buna me uwara durua ufoita wei. Yesunu sina imuawe wei. Yesuma eno wei, i maeta amaranu yaruna derawere, i muneta amaranu yaruna otowaratu. Eno weiba iba imuawe Foroma wei. ");
INSERT INTO yrb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Eno weiro yajigoma jejerigari utate guriguri utate uyata. ");
INSERT INTO yrb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Uyatate i weda Foro yabatate koku uteda dawa nono da efeisi we imutate neno arama derawere uteda boutiro woure ane oita. ");
INSERT INTO yrb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","I Efesa dubu su yawoeta uwara ekoisite boutiroma Kosi suro anisi. Ane aisite uyasi. Iroma uyasite ane Rouda su musi. ");
INSERT INTO yrb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Iroma Fatara suro ane fasite yanu anisi bouti ekoisi. Ekoisite mui Fonisia orofaro aneta bouti ubarero amusite anisi. ");
INSERT INTO yrb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","4","Anebe Saifurasi mutumutu ereda serigari usite Siria orofaro anisi. Anebe ane Taira su musi. I bouti ego woure uwafuro odifitae iro ane inata. Ane inataro tanisite i su Godinu sina naueta uwara doberebe emabai uiki demurai sane aisi. Godinu Imumu Kotofuma Danu naueta uwaraba weiro i uwarama Foroba eno we kakara utate weita, Jerusaremu suro da ania weita. ");
INSERT INTO yrb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","6","I uiki me siniro i Godinu sina naueta uwara, emeini awetaboini koiniboro nesiama ya woure ane enea gigirariro oitaro maguaro yajigoma jejerigari uteda guriguri usite ario weisite yana bouti ubarero amusiro emana owetate suro anita. ");
INSERT INTO yrb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","8","Taira su ekoisite Torimai suro ane fasi. Fasite i Godinu sina naueta uwarabai owiga usite aisite wau uriro Sesaria suro anisi. Ane fasite bouti ekoisite Firifinu su ubarero ane amusi. Firifina Godinu sina weta amara. Firifi demurai dawana i sewenini (7) afosoro durua ueta uwarabai oita amara. I amarabai yaubisi. ");
INSERT INTO yrb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Firifi danu karu arumami fo (4). I arumamina awerasi munawa me karu ibeda Godinu sina fo webita. ");
INSERT INTO yrb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","I suro ibisina Godinu mui we bou ueta amara Agabasima Judiaroma iro are fari. ");
INSERT INTO yrb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yabai farite Foronu yafa wadia kafa ari munite danu torowa buri age uwane tarite wei, Godinu Imumu Kotofuma wasu, i Jerusaremu Ju uwarama ewa wadia bobo amara mubitate, i aika uwaranu agero odifitaita wasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Eno weiro nausite i su uwaraini yaini Foroba weisi, iro da anebea i weda weisi. ");
INSERT INTO yrb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Weisiro Foroma wei, aneba i waita wei? Eno utaitaba neno arama derawere utatane wei. Nanu neno nesia iro animane imutatane wei. Dibura odifitaitana idorogo nono na Yesunu ifuba na ma uifitaitana ina ido. Idorogo nanu neno nesia iroba animau wei. Foro eno weiro nausi. ");
INSERT INTO yrb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Danu imueta kimu uiba ekoisite weisi, Yesu, Anu ununa ua weisi. ");
INSERT INTO yrb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","16","Yanu Sesariaro ibeta kowa me siniro yanu ibaiabai fira usite Jerusaremu suro manebe manebe mane fasi. Moana Sesaria Godinu naueta uwarama ya Sesaria suroma Jerusaremu suro woure mane fata. Mane fatate Neisonanu suro oita. Neisona dawa Saifurasi mutumutu amara. Dawa bodere Yesu Kerisonu buribi anite awonaini daido inarebasu. I amara Neisonabai ibifene iba woure ane oita. ");
INSERT INTO yrb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusaremu suro fasiro i Jerusaremu Godinu sina naueta uwarama yaba ario derawere weita. ");
INSERT INTO yrb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Etei mui kowaro Jeimisini i Godinu sina naueta yawoeta uwara yaubitaro emabai ane fasi. ");
INSERT INTO yrb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Foroini yaini emabai ane fasiro Foroma ema nesia ario weite Godinu aika uwarabai gaukara utebi sina eno wei, Godima Danu imuetaini buna maiba i Ju me aika uwarabai Godinu sina nesia we inarebitararo i aika uwarama nauteda Godi imutebita wei. ");
INSERT INTO yrb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Eno weiro nautate Godi we ma kobererau uta. Utate Foroba weita, kaka naua, Ju uwara faiyawere, tausani emanu naueta Godibai oita. I uwara nesia Mosesinu tarawatu imuegou utaita weita. ");
INSERT INTO yrb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Moana uwarama emaba weita, Foro dawa unutawa Mosesinu tarawatu weita. Foro dawa unutawa yanu Ju uwaranu baeta weita. Foroma eno wasu weita. Yanu amarararatunu ofe da tuawe wasu weitaro ewa Ju uwarama nauta, Godinu sina naueta uwarama Forobai i sina eno weita. ");
INSERT INTO yrb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","23","Weitate iba anene ufeisi weita? Anu ewaro fareta sina naufitaitaba iba yanu sina naua weita. Yabai amara fo (4) Godiba we bou utaba awona me yaubinita. ");
INSERT INTO yrb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","I uwara muate emanu fuyo oeta oiya uaro emanu kofiri giriri ufita weita. Emaini dera dubu suro aniate Mosesinu kakara uroeta ogo eno uroa weita. Eno ufasuna i uwarama efitate Foro Mosesinu tarawatu uegou utasu imufitaitana ina ido webitaita weita. ");
INSERT INTO yrb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nono Godinu aika naueta uwara yanu imueta owawa oisite emabai siaia usi. Yanu imuetana eno, i meo godiba maeta fuyo ieta da iawe, egi onono da iawe, i mimi utaro onono farawa egi da iawe, dita yagera fareta da uawe. Yanu imuetana eno oisite Godinu sina aika naueta uwarabai siaia usi weita. ");
INSERT INTO yrb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Weitaro Foroma naui. Etei mui kowaro Foroini i amara fo (4) dera dubu suro uruama anitate kakara uroeta ogoma urotate dera dubu su ubarero i fuyo oeta uwarabai amuta. I fuyo oeta uwarama emanu kakara kowa ido tutubari uiro kowa seweni (7) me sibiro emanu fuyo egi odifitaro efitae iba emabai amo fata. ");
INSERT INTO yrb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","28","I kakara kowa seweni (7) me sibie uiro moana Eisia orofa Ju uwarama Foro dera dubu su ubarero etate eme faiyawerebai ane Foroba wawei sina weita. I uwarama Foro budari utate eno weita, Isaraero uwara ya durua uawe weita. Ewa amarama yaini Mosesinu tarawatuini dera dubu suba siosa sina wasuro eme faiyawerema nautaita weita. Dana Guriki uwara dera dubu su ubarero woure odiba yanu kakara su ma siosa ui weita. ");
INSERT INTO yrb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Auboko Foroini Efesa amara Torofimasi Jerusaremu natofo suro inarebitaro etate iba Foroma i Guriki amara yanu dera dubu su ubarero woure odi we imuta iba eno weitaro i Jerusaremu su uwara nesia nautate ubusi uyata. ");
INSERT INTO yrb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ubusi uyatate Forobai fatate agero muneda dera dubu su ubareroma wawaro ma youre anita. Wawaro anitaro i dera dubu su kasimu sau garari uta. ");
INSERT INTO yrb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","32","I uwarama Foro ma uifitae urebitana moana uwarama dera ami yawoeta amarabai fare weitaro nauite danu ami kafiteni uwaraini dawaini sau anita. Iro ane fatana i uwarama i dera ami yawoeta amara etate Foro urebita ido ekoita. ");
INSERT INTO yrb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ami yawoeta dera amarama fare Foro budari uite weiro seni sadeima Foronu age uwane tarita. Ami yawoeta dera amarama wei, ewa amara ane usinu weite dawa abo amara wei? ");
INSERT INTO yrb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Weiro moana uwarama mui wawei sina weitaro moana uwarama aika wawei sina weita. Emanu weroroka derawereba yawoeta dera amarama we imui, ane waita we imuite weiro ami uwarama Foro woure emanu suro ane oita. ");
INSERT INTO yrb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","I su adibai fataro i Jerusaremu su uwara ubusi derawere uyatate weita, i amara ma uia weitaba ami uwarama Foro woure eriro oita. ");
INSERT INTO yrb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Oitate su ubarero woure amufitae utaro Foroma ami dera yawoeta amaraba wei, aba sina wemau aba me wei? Dera ami yawoeta amarama neno kirifu uteda wei, a Guriki sina iwata utasu wei? ");
INSERT INTO yrb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Weite wei, ana etei Ijifi amara aba me? Etei amarama mui odoro uraneta uwara fo tausani (4000) munite emaini gaemanini uranite eme ibawa orofaro woure ani wei. ");
INSERT INTO yrb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Weiro Foroma wei, nana i amara me. Nana Ju amara. Nana Sirisia orofa Tarasu su amara. Tarasu suna derawere wei. Enoba ewa uwaraba sina wemane watane wei. ");
INSERT INTO yrb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Eno weiro dera ami yawoeta amarama wei, anu sina wiaro naufita wei. Weiro Foroma adiro amo inarite age ramamiba weroroka ekoita. ");
INSERT INTO yrb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Weroroka muma utate ekoitaro Foroma Ju uwaranu sinaroma wei, babamutu kaka nabue nanu moko sina nauawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Weiro emanu ba sina nautate weroro mu utaro wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Nana Ju amara. Nanu bayama na Sirisia orofa Tarasu suro muniro ibebitara wei. Gameiriama na yanu abuamutunu tarawatu we mawetu utebiba Godinu tarawatu imuegou utebitara. Yana awona Godinu tarawatu imuegou utaita i ari imuegou utebitara wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Boderewere Godinu sina naueta uwara ma siosa uete emanu uieta daba doberete emeini awetaboini nesia dibura su ubarero woure fare ode. ");
INSERT INTO yrb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Eno ueba i dera fuyo ode sina weta amaraini danu kanisoro uwara nesia iwata utaita wei. I kanisoro uwarama emanu imueta owawa oitate yanu ba Ju uwarabo woumane naba mata. Mataro Damasikosi suro i Godinu sina naueta uwara budari umate Jerusaremu suro woure amaro fanisi mafitae ane wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","7","Foro eno weite wei dabaro anete Damasikosi su famane anena ario derawere ureroma tararite na wokuku uiro sakairo ureiero sina tararite wei, Soro, aneba Naba ba me utasu wei? ");
INSERT INTO yrb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Weina nana we, A anaiyade wero wei, Nana Yesu Nasareta Amara. Naba ba me utasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Naini nanu uwara i ario esirogo nanu uwarana i ario etate i sina nautawa uta. ");
INSERT INTO yrb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Dana naba weiro nana we, Dera Waria Amara, ane umau wero wei, uyate Damasikosi suro aniaro mui amarama aba mamau gaukara sina webiro naufasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Weiro uyarero arioma diti basugari uiba nanu naiyemutuma nanu agero muneda Damasikosi suro woure anita, Foroma eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","13","Iro ane farero mui tarawatu yawoegou ueta amara, Ananaiasima nabai fari. I Ju uwara nesina Ananaiasiba weita, dana kobere amara webita. I amarama nabai farite wei, kaka Soro diti ea wei. Eno weiro daido i amara ere wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","16","Ananaiasima naba wei, yanu abuamutunu Godima a mune odi. Godinu imueta iwata ufate Danu rorowarauini roatarau Amara efate Danu Amaranu sina Danu bebeturoma naufae iba odi weite wei, uwara nesiabai anibate Godinu sina webasu wei. Anu nauetaini ereta nesia emabai webasu weite wei, aneba yaubinu? Uyaro a babataito umaro anu neno neno ueta Yesubai we ma boroearo maitufisu wei. Ananaiasima naba eno weiya Foroma wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","Foroma weite wei, duburo owerete Jerusaremu suro farete dera dubu su ubarero amuete guriguri ue. Guriguri uete tubetube erero Yesu Kerisoma tubetuberoma wei, ewa uwarana emabai Nanu sina da naufitaitaba sau Jerusaremu su ekodiate ania wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Weiro we, Dera Waria Amara, uwara nesiana nanu ema Ju uwaranu dubu su ubarero amuetaini Godinu sina naueta uwara mune dibura ane oetaini nanu uraneta sina ema nesia iwata utaita. ");
INSERT INTO yrb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Sitiwani Anu sina weta amara utaro danu onono itariro na ere. Emanu Sitiwani ureta ina nanu unu ido. I urebita uwaranu dei barueta nana yawoe we. ");
INSERT INTO yrb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Wero wei, daba yafawere i Ju me aika uwarabai siaia umaro ania weiya wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","23","Foro i aika uwarabai eno webina i guruguru ubita uwara nautate nono weita, danu yabai ibetana aramawere uaro uifi weitate emanu wadia ma buruburu uteda konua mutate urero sata. ");
INSERT INTO yrb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Eno utaba ami yawoeta dera amarama weiro Foro ami uwaranu su ubarero woure ane oita. Woure ane oitaro dera yawoeta amarama i uwaranu weroroka iwata ufie wei, isu muawete uawero ba sina webiro nauma wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Weiro buri age nama uwane taritaro Foroma ami kafiteniba wei, nana Romani amara, yana na koto utawa uitaba anu uretana kobererau aba siosawere, Romani uwaranu tarawatuba, Foroma wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Eno weiro kafiteni i ufie utebi ekodite ami yawoeta dera amarabai ane farite wei, a ane utasu wei? Etei amarana Romani amara wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","28","Weiro dera yawoeta amara uyarite Forobai ane farite wei, ana Romani amara aba me weina aiwiade weiro wei, nanu ba orofa ekodete Romani orofa oi derawere oiya uete Romani amara sirete ibine wei. Weiro Foroma wei, nanu babana Romani amaraba nana Romani amara wei. ");
INSERT INTO yrb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Eno weiba i Foro uwane tarieta uwarama ekoitaro ami dera yawoeta amara iyari. Dana weiba danu ami uwarama Foro uwane taritaro Foroma na Romani amara weiba iba iya uyari. ");
INSERT INTO yrb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Etei mui kowaro dera yawoeta amarama i uwaranu wawei weta iwata ufie uite weiro Foro ma uregari uta. Ami dera yawoeta amarama i fuyo oeta uwaraini i kanisoro uwara nesia yua weiro dawabai fataro Foro ma uregari utate woure i uwarabai oitaro emanu iboro inari. ");
INSERT INTO yrb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Foroma i kanisoro uwara eregou uteda wei, kaka nabue nanu sina nauawe wei. Boderewereroma awona nanu ueta sinetana kobererau, Godima erasuro nana iyarawa utatane wei. Nanu ueta sinetana kobererau wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Weiro i dera fuyo ode sina weta amara, Ananaiasima, i inaibita uwaraba wei, danu bebeturo uawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Eno weiro ido utaro Foroma wei, Godima a moko ufisu wei. A imueta sadei bobo amara iba anu wasu i ba utawa me sara utasu. Uteda Mosesinu tarawatuma na koto uteda wenuro na uritaba tarawatu ma siosa usinu wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Weiro i inaibita uwarama weita, aneba Godinu dera fuyo ode sina weta amaraba siosa sina wasu weita? ");
INSERT INTO yrb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Weitaro Foroma wei, ari, kaka nabue, dana Godinu dera fuyo ode sina weta amara na iwata meba iba wene wei. Godinu bukaroma eno wasu, yanu uwaranu yawoeta amaraba siosa sina da wiawe wasu Foroma wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Foroma i kanisoro uwara ereda we imui, moana uwarana Sadusi waita uwara, moana uwarana Ferosi waita uwara, we imuite wei, kaka nabue nanu sina nauawe wei, nana Ferosi amara. Nanu abuamutuna Ferosi uwara. Na uietaroma uyareta imutataneba yana na koto utaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","I Sadusi uwaraini Ferosi uwaranu imuetana demurai me. Emanu imuetana aika maika. ");
INSERT INTO yrb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(I Sadusi uwaranu imuetana eno, uietaroma uyareta mui daba me, aneru me, imumu me, eno we imutebita. Nono Ferosi uwarama i imueta nesia rarogonu imuegou utebita.) ");
INSERT INTO yrb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Enoba yare yaranebita. I Ferosi tarawatu tisa uwarama uyatate weita, ewa amarana kobere amara dawabai siosa me. Aneruma dawaba sina wasuro wasu aba me, ya iwata me weita. ");
INSERT INTO yrb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Eno weitaro derawere yaranebitate Foronu enabiraro inare enabiraro inare utate agero mune ma yourebita. Enoma enoma utebitaba dera ami yawoeta amara iyareda we imui, i amara abanaro ma saragari ufitaita we imuite weiro ami uwarama sau fatate i yaraneta uwarama ma beratate Foro emanu ami suro woure ane oita. ");
INSERT INTO yrb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Dumu siniro Yesuma Forobai fare inarite wei, iya da uyate buna ua wei. Auboko Jerusaremu su uwarabai Nanu sina wei, enanari Romani uwarabai Nanu sina webasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wau uriro moana Ju uwarama we bou utate eno weita, ietaini ogo da ifete Foro ma uifeisina ogoini ieta ido ifeisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","14","Uwara foti (40) eno utate i fuyo ode sina weta uwaraini emanu baeta uwarabai anitate weita, ieta da ifete Foro ma uifetema ido ifeisi, we bou utaisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Eno utaisiba yana wiawero dera ami yawoeta amarama Foro yabai woure afiro Foroba sina webitae irufitaro Foro afiro ma uifeisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Foro danu teworero amara i Ju uwaranu we bou ueta sina nauite ami uwaranu suro Forobai anite i sina wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Weiro Foroma nauite mui kafiteni amaraba wei, ewa amarama dera ami yawoeta amaraba sina webisuba yawoeta amarabai woure ania wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Weiro mune yawoeta amarabai woure ane odite wei, ewa amarama aba sina webisu wei. I dibura amara, Foroma naba wenu ewa amarama ami yawoeta amaraba sina webisuba woure ania wenuba iba abai woure fanea wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Weiro i dera yawoeta amarama i amaranu agero mune aika odite wei, ane webasu wei? ");
INSERT INTO yrb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Weiro i amarama wei, i Ju uwarama imueta daba demurai uita wei. Waidumu aba eno webitaita, Foro kanisoro uwarabai siaia uaro afiro mui sina webeisi webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Emanu sinana meo sinaba iba da naua wei, uwara foti (40) feare yaubifitaro Foro fafiro ma uifitaita wei. Anu sina naufitae awona ue bou utaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Weiro dera ami yawoeta amarama nauite wei, ewa sina mui amarabai da webaro weite siaia uiro i amara ido owere ani. ");
INSERT INTO yrb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","24","Dera ami yawoeta amarama mui kafiteni amara sadei yua weiro fata. Dawabai fataro wei, burima aneta ami uwara tu aderedi (200), osi egiro yaure aneta ami uwara seweniti (70), wari bobo ami uwara tu aderedi (200) ue bou uawate dumu abanaro Foro muawete Sesaria suro Firiki, gaemani dera yawoeta amarabai anegou uawe wei. Foroba mui osi egi mawaro yaufite anibi wei. ");
INSERT INTO yrb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Weite owawa eno yanai, na Korodiasi Risiama a kobere yawoeta amara Firikiba ario watane. ");
INSERT INTO yrb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Nanu sina kikiratu naua. ");
INSERT INTO yrb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ewa siaia utatane amara, I Ju uwarama budari utate ma uifitae utaro nana farete i amara ma darete dana Romani amara iwata ue. ");
INSERT INTO yrb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nanu ununa aneba wawei sina weita iwata umane uete Ju kanisoro uwarabai i amara woure ane ode. ");
INSERT INTO yrb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Woure ane odero i Ju uwarama emanu dubu su tarawatuba wawei sina weita. Yanu tarawatuba wawei sina wiawa utaba iba diburaro aneba ibifisu o aneba uifisu, ina ba me. ");
INSERT INTO yrb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","I Ju uwarama ewa amara ma uifitaita weitaro mui amakanuma nabai wenuro nauneba iba abai sau siaia utatane. I wawei weta uwara duburo fafitate abai dawaba wawei sina webitaita. Nanu sina ido me sininu. ");
INSERT INTO yrb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Dera ami yawoeta amarama eno yanaite danu kafitenibai owawa mairo muta. Mutate dumu abanaro Foro mutate anita. Ane Atifatasi suro fatate aita. ");
INSERT INTO yrb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","33","Wai uriro i burima aneta ami uwara ido owetate emanu suro ataro i osiro yaure anita uwarama Foro woure anita. Ane Sesaria suro fatate i dera gaemani yawoeta amaraba owawaini Foro mata. ");
INSERT INTO yrb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","35","I yawoeta amarama owawa yawite Foroba wei, anu orofa aboro wei? Weiro Foroma wei, nanu orofana Sirisia weiro nauite wei, ido i wawei weta uwarama fafitaitana anu sina naumau wei. Danu uwaraba weiro Foro mutate Erodinu dera gaemani su ubarero woure oitate kasimu garari utate yawota. ");
INSERT INTO yrb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","I kowa fai (5) me siniro dera fuyo ode sina weta amara, Ananaiasini baeta uwaraini mui koto sina weta amara Tetarasini Foro koto ufitae fata. I gaemani dera yawoeta amarabai fata. ");
INSERT INTO yrb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Fataro yawoeta amarama weiro Tetarasima danu sina wawei webie uteda uyarite wei, Firiki, a kobere amara. Anu yawoetana kobererauba yanu ueta sineta ibetana kobererau wei. Ana kobere tarawatu yabai odinuba awona kobererau ibinisi wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Anu yawoeta kobererauba tenikiu derawere waisi wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","A arama uosoba yanu sina kikiratu wemaro naua wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ewa amara Foro dana ba me. Dana i orofa atata Ju uwaranu imueta ma siosa utasu wei. Dana i Nasareta waita uwaranu mui dera amara. ");
INSERT INTO yrb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Dana yanu dera dubu su ma siosa ufie aniba iba i amara budari usi wei. Weite wei, yanu wawei sinana ba. Yanu ununa dawa yanu tarawatuma koto ufene usina i ami dera yawoeta amarama farite i amara bunawere yabairoma ma dare munite ani. Eno uite nono Raisusima eno wei, dawaba wawei weta uwara abai afene weiba iba farisi wei. I amara wenauearo webiro nauate yanu wawei sinana ba iwata ufasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Eno weina i Ju uwara nesia enanari weita. ");
INSERT INTO yrb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","I gaemani dera yawoeta amarama Foronu sina naufie age fisu uiro Foroma uyarite wei, ana ewa orofa uwara oya faiyawere yawotebiba nanu neno kobererau umate nanu imueta sina moko wemau Foroma wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kowa tuero (12) me sini, i buribi dera dubu suro anete guriguri ue wei. I kowa iwata utasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","13","I kowaro Ju uwaranu dera dubu suro o dubu su suro o natofo suro na uranawa yaranawa, emanu imueta ma siosa utawa rairo aneba na koto utaita wei? Emanu abai naba wawei waita sinana ba me wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nanu mui sina eno, etei amaranu mui wenu sina ina ba. I uwaranu meo waita dabana na imutatane wei. Yanu babamutunu Godibai guriguri utatane wei. I tarawatunu sina nesia na imutatane. I we bou ueta uwaranu sina nesia imutatane wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Godima uwara nesia, kobere uwaraini siosa uwaraini uietaroma ma uyafisu wei. I inaibinita uwaraini naini i yawoegou utaisi wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Godinu uwarabai na siosa utawa uegou utataneba neno kobererau ue ibine wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Moana oya mui orofaro ibebe iroma nanu uwarabai fuyo odimane fare wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Farete Mosesinu kakara ueta uete dera dubu su ubarero amue wei. Amuero nabai eme me, weroroka wiawa ue wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Eno utebitarana moana Eisia orofa Ju uwarama na eta wei. I uwarama na etate budari utaba aneba na muta inu ubi fare anu iboro nabai wawei wiawa utaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bodere kanisoro uwaranu iboro inarero nanu siosa uetade ewa uwarama ane eta wei? ");
INSERT INTO yrb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nanu sina demurairatu eno we, uietaroma uyareta na imutataneba iba awona na koto utaita we, Foroma wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","23","Firiki dawa i naueta uwaranu imueta iwataba i Ju uwaraba wei, awona koto kodiawe wei. Eno weite Foroba wei, ami dera yawoeta amara Risia fafisuna aba ane umate wemau weite danu kafiteniba wei, Foro dibura suro odiaro danu domayamutu fafitate ane mafitae ufitaitana mafitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","25","Duburo Firikima weiro Foroma Firikini danu Ju aweta danu ifuna Durisira emabai fari. Fare emaba sina bunawere wei, Yesu Keriso imuawate emebai kobererau uawate yanu unu torowa da uawaro Godima duburo fafite koto ufisu wei. Eno weiro Firikima iya uyarite wei, aniaro nanu odimau kowaro wemaro fafasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Firiki danu imuetana eno, Foroma Firiki dawaba oi mafisua we imuteda iba Foro webiro woroworo dawabai farebiro sina sina webisi. Firikini Foro eno utebisi. ");
INSERT INTO yrb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Oya sadei me siniro Fosia Fesama Firikinu kabesi muni. Firikima i Ju uwara garo uite wei, Foro dibura suro ibifisu wei. |L");
INSERT INTO yrb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fesama fariro kowa rarogonu me siniro Fesama Sesaria suroma Jerusaremu suro mani. ");
INSERT INTO yrb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","Iro mane fariro i dera fuyo ode sina weta uwaraini dera Ju uwaraini dawabai fatate Foroba sina wawei weitate nui weita, Foro siaia uaro Jerusaremu suro fafi weita. Emanu ununa feare yaubebe Foro ma uifitae iba eno weita. ");
INSERT INTO yrb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","5","Eno weitaro Fesama wei, Foro Sesaria suro yaubinu wei. Na iro tanimaro yanu dera uwaraini iro tarafitate danu siosa ueta sina wawei webitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesama Jerusaremu suro ibebe kowa eita (8) me siniro ekodite Sesaria suro tarani. Wai uriro Fesama danu koto koruro anite danu yaureta deiro yaurite wei, aniawete Foro woure arawe weiro ane woutate fata. ");
INSERT INTO yrb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Foro ido fariro i Sesaria suro tarata Ju uwarama Foro ode kara utate sina faiyawere wawei weitarogo emanu sina ba meba Fesa emanu sina nautawa ui. ");
INSERT INTO yrb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ju uwarama weitaro Foroma moko sina eno wei, i Ju uwaranu tarawatuini dera dubu suini gaemani dera yawoeta amara Sisaba siosa utawa utebitara wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fesama i Ju uwara garo uite Foroba wei, Jerusaremu suro manibero aba sina wawei nabai webitaita. Eno ufasua aba me wei? ");
INSERT INTO yrb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Weina Foroma me weite wei, awona Sisanu kotoro inaibine, ina kobererau wei. I Ju uwaraba siosa utawa uero a iwata utasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Na siosa uteda uieta kerere umarona uimane na iyarawa uietaba kerere mena da uimau wei. Emanu agero na da odia wei. Nanu unu dera amara Sisabai animau deina ido wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesaini danu kanisoro uwaraini sina we matatate Fesama Foroba wei, Sisabai anibae wenuba Sisabai anibasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Moana kowa me siniro Kini Agirifaini danu aweta Benisini Sesaria suro fatate Fesa ario weita. ");
INSERT INTO yrb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Sesaria suro kowa faiyawere ibebitaba Fesama Foronu dibura sina emaba eno wei, Firikima mui amara, Foro, dibura suro odiro ibebe ibebe awona dibura suro me yaubinu wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Na Jerusaremu suro ane farena, i Ju uwarama i amaraba nabai wawei weitate i amara uaro uifi weita. ");
INSERT INTO yrb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Weitaba we, yanu Romani uetana eno, dibura uwaraini wawei weta uwaraini sina sina we matafitaita, mena dibura oeta amara wawei weta uwaranu agero me sara da odifeisi we wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Weite wei, i Ju uwarama i amara koto ufitae fata. Fataro ido wai uriro nana wero i uwaraini Foroini koto ufitae nabai are fata. ");
INSERT INTO yrb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Fatate emanu wawei sina weitana Foronu siosa ueta sina wiawa emanu aika weita. ");
INSERT INTO yrb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Emanu dera dubu su siboro ueta sina wawei weita. Eno weita, Yesu Dawa me sini weitaro Foroma wei, Yesu uitawa Dawa me ibinu wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Eno weitaba ane umau na iwata meba, Foroba we, Jerusaremu suro anibero iro wawei webitaita. Eno ufasu aba me? ");
INSERT INTO yrb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Wena Foroma me weite wei, nanu ununa Sisabai animau wei. Eno weiba wero owetate dibura suro woure oita. Duburo Sisabai siaia umaro anibisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Fesama eno weiro Agirifama wei, i amaranu sina naumane watane wei. Weina Fesama wei, waidumu naufasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wai uriro Agirifaini Benisini werei werei utaro emanu dera ami uwaraini i koto su ubarero amuta. Amutaro Fesama weiro ane Foro woure fata. ");
INSERT INTO yrb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesama yare wei, Kini Agirifa, ya uwara nesia ewa amara eawe wei. I Ju uwara nesia Jerusaremu su uwaraini ewa su uwaraini ewa amaraba sina nabai wawei weitate eno weita, i amara uaro uifi weita. ");
INSERT INTO yrb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Weitaro dawabai kerere meba aneba uifisu? Daba aika Sisabai animau weiba dawa siaia umau wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Siaia uteda owawa anene yanamate nanu dera amarabai siaia umau wei? Na dawa wawei weta sina mena wiawero Foro naufite webiro naufe wei. Kini Agirifa danu sina nauate wiaro enanari owawa ue odimau wei. ");
INSERT INTO yrb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Wawei weta daba meba na unutawa dawa Sisabai me sara siaia ueta wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agirifama Foroba wei, anu ikiki wiaro naufe wei. Foroma uyarite age sanite ramameda danu moko sina eno webi. ");
INSERT INTO yrb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","I Ju uwarama naba wawei webitaba awona abai nanu moko sina wemane yaru uteda nenorau une wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ana i Ju uwaranu baeta uraneta yaraneta nesia iwata uegou utasuba nanu sina nauegou ua wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Nanu suini Jerusaremu suro ibebitaraba i Ju uwarama nanu ueta sineta kikiraturoma iwata utaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","I Ferosi uwaranu kimu imueta na munegou utebitara. Ina i uwara iwata utaitaba eno aba webitaita aba me wei? ");
INSERT INTO yrb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","7","Godima yanu abuamutuba eme uietaroma uyareta we bou ui. I we bou ueta na imutatanero i Ju uwara nesia ainewaure guriguri uteda imuegou utaita wei. Eno utaitate nono na iba koto utaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Godima uieta uwara uietaroma ma uyarasuro aneba imuteda kirifu utaita wei? ");
INSERT INTO yrb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Bodere nanu imuetana eno, Yesunu buribi aneta uwaraba ba mewere umau, ina kobererau na eno we imue. Eno we imuete enanari utebitara wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","11","I fuyo ode sina weta uwarama weitaro nana Godinu sina naueta uwara Jerusaremu dibura suro mune ode. I uwarama Godinu sina naueta uwara ma uifitae weitaro nana aiwia, ma uiawe weya wei. Nana ubusi derawere uyarete Godinu sina naueta uwara Godiba siosa sina webitae uete emaba siosawere ue. Jerusaremu suroma aika su su aboro aboro eno utebitara wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Iba i fuyo ode sina weta uwarama naba owawa matate ane ua weitaro na Damasikosi suro ane. ");
INSERT INTO yrb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Foroma nono wei, na anebitarana kowa otoro ario derawere, kowana danu ario kikiratu. Kini nanu sina naua, i ario derawere ureroma tararite naini nanu uruama aneta uwaraini wokuku ui. ");
INSERT INTO yrb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Eno uiba ya nesia sakairo dowasina Ju uwaranu sinaroma mui sina weiro naue. I sina eno wei, Soro, aneba Naba ba me utasu weita wei, ana Godini uranasuba oferi wourasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","16","Weina a anaiyade wero Yesuma wei, Nana Yesu. Naba ba me utasu weite naba wei, uyaro a siaia uma wei. Abai fanete Nanu sina weta amara odine. Nanu gaukara amara odineba siaia umaro anibate i orofa atata uwaraba anu awona eretaini duburo ereta webaro naufitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","18","A durua umaro aba siosa ueta Ju uwaraini aika uwaraini da ufitaita. I uwarabai anibate nanu sina webaro emanu ditima efitate dumu daba ekodifitate Godibai anibitaita wei. Eno ufitaro Godima emanu neno neno ueta mubite imutawa ufite ema Nanu naueta uwarabai odifisu Yesuma Naba wei, Foroma i sina eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","20","Foroma eno weite wei, Kini Agirifa, i ure tubetube ereta erete enanari ue. I Damasikosi su uwarabai ko we. Nono Jerusaremu uwaraba wete nono duburo i Judia uwaraini aika uwarabai ane eno we, yanu neno neno kodiawete Godibai aniawe we. Godibai aniboitaba siosa ueta kodiawete kobere ueta torowa uawe we. ");
INSERT INTO yrb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Eno weba i Ju uwara na dera dubu suro budari utate na ma uifitae uta wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Godima na durua utasuba awona ewado inaibeda yabai dera uwaraini otowa uwarabai Godinu sina watane. Mosesini i we bou ueta uwarama weitaro enanari watane wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","I uwarama weita, I Mesaia oferi derawere woufite Dawa ko uietaroma uyafite Ju uwaraini aika uwarabai ario derawere odifisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Foroma danu moko sina eno weiro Fesama derawere wei, Foro, ana gogore usinu. Sikuru derawere utebiba gogore usinu wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Weiro Foroma wei, O kobere amara Fesa, nana gogore me wei. Na ba sina watane wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nanu watane sina Kini Agirifa a iwata utasu. I ueta nesia dumuro utawa uite arioro uiba a iwata utasu wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kini Agirifa, i we bou ueta uwaranu sina imutasu aba me weite wei, a imutasuna na iwata wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Weiro Agirifama wei, anu ununa nana nanu naueta Yesubai sau odimau wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Foroma wei, sau odifasu aba kekerama odifasu ina ido. Nanu ununa aini ewa nautaita uwaraini nesia yanu naueta Yesubai odifoita wei. Na ari siboita, nanu dibura budari uetana me, nono ba naueta uwara siboita wei. ");
INSERT INTO yrb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","31","Foroma eno weiro Kini Agirifaini Fesaini Benisini emanu uwara nesia uyatate wawaro anitate emanu torowa weita, etei amarabai kerere me, uieta kerere me, dibura kerere me weita. ");
INSERT INTO yrb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Weitaro Agirifama Fesaba wei, dana Sisabai animau da webirona awona dawa dibura ekodifite wawaro anibie wei. ");
INSERT INTO yrb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Yanu Itaria orofaro aneta ue bou utate Foroini moana dibura uwaraini mui ami kafiteniba mata. I kafiteninu ifuna Juriasi. Dana Sisa Agasitasi waita danu ami amara. ");
INSERT INTO yrb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","I amaraini boutiro amusi. I boutina Adamitiuma suroma fari. Nono owefite Eisia orofa su suro mubie ani. I boutiro yaini mui amaraini danu ifuna Aritikasi, dana Masadonia orofa Tesoronaika su amara, dawaini i boutiro amusite anisi. ");
INSERT INTO yrb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Wai uriro anebe Saidoni su fasi. Juriasima danu imueta derawere Forobai odiro Foroma boutiroma itarite suro ani. Danu domayamutubai yadama ani. ");
INSERT INTO yrb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ane farite iroma owere ariro nono boutiro anisi. Oyau derawere fariba Saifurasi mutumutu dubenaro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Anebe anebe ane enea abanaro fasi. Iroma anebe Sirisiaini Famufiria su serigari usite amusite Risia orofa Maira su ido fasi. ");
INSERT INTO yrb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","I ami kafitenima mui Itariaro aneta bouti dobere ane atanite ya nesia woure i Arekisana suroma fari boutiro odi. ");
INSERT INTO yrb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Maira su ekoisite anisi. Oyau derawere fariba moana kowaro kekerama anebe anebe Sinadasi su serigari usi. Oyau derawere farite yanu aneta daba garari uiba Kuriti mutumutu iboro Saramone su baworo fare anisi. ");
INSERT INTO yrb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Yanu anetana kimuwereba kekerama anisi. Kekerama anebe i kobere Dera Boutinu ibeta orofaro fasi. Rasia suna i orofabai. ");
INSERT INTO yrb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","10","Yanu aneta kowa kekerama anebe sau ane farawa usiba yanu mui aneta dabana aramawere. I Godima Isaraero uwara Ijifiroma woure aneta ogaro me siniba iba bouti kowana me. Kowa serigari uiba Foroma wei, yawe, nanu imuetana eno, anibeisina yanu boutini egoini arama ufitaro moana uwara ofe arama ufiro uifitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Eno weiro ami kafiteni amarama nautawa uite i bouti yawoeta uwaranu sina naui. ");
INSERT INTO yrb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Oyauini obi kowa fariba yanu bouti ibeta orofa ba meba mui Kuriti mutumutu bouti ibeta orofa, Finiki su mubete iro ibifene weita. ");
INSERT INTO yrb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kiki oyau farite kobererau uiro we imuta, yanu aneta kowa farinu we imutate emanu bouti anika ma youtaro Kuriti magua gigirari anisi. ");
INSERT INTO yrb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Anebisiro oyabibi derawere farite enea abanaro bouti woure ani. ");
INSERT INTO yrb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Bouti ma owefitae utana enanari utawa uiba ekoitaro oyabibima bouti ure ma berairo ani. ");
INSERT INTO yrb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Anebe anebe Kauda mutumutu dubenaro anisite yanu ma yousi dinigi ma youre bouti deiro oisi. ");
INSERT INTO yrb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Bouti saragari uosoba imusite kimu na musite bouti uwane ma kimu usi. I bouti yawoeta uwarama weita, Afirika maguaro ma berafiro anibene weitate iya uyareda i dei farai mune wo tarata. Eno utaro oyabibima bouti ma berairo anisi. ");
INSERT INTO yrb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Wai urina ufe derawere uyariba i boutiro uwarama ego mu sataro enearo itari. ");
INSERT INTO yrb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Etei mui kowaro bouti ibaiabai nesia ane ane mune sataro enearo itari. ");
INSERT INTO yrb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Oyabibi kowa faiyawere farebe kowaini sakaraini muinaini ba me uiba yana imusina uifeisi eno we imusi. ");
INSERT INTO yrb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","22","Kowa faiyawere ieta itawaba Foroma i uwarabai farite wei, yawe, aneba nanu auboko we sina nautawa uta? Aneba Kuriti orofa ekoitaba ewa ibaiabai nesia abe sanaita weite wei, iya da uyawete neno kimu uawe wei. Yana da uifeisi wei. I bouti torowa arama ufisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ewa dumuro Godinu aneru nabai farinu wei. I Godi, na imuegou utatane wei. ");
INSERT INTO yrb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Danu aneruma nabai farinute wenu, Foro iya da uya wenu, Sisabai anibate danu iboro inafasu wenu. Ewa boutiro anaita uwara nesia da uifoita wenu. ");
INSERT INTO yrb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Eno wenuba enanari ufisu, na imutatane, Foroma weite wei, ibago buna uawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mui mutumutu maguaro bouti amufisu wei. ");
INSERT INTO yrb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","28","Uiki sadei me siniro Eidiria enearo me anisi. Dumu abanaro bouti gaukara uwarama we imuta, magua baworo we imutate emanu towoeta na sataro enea ubarero itari. Itariro danu yafa etana foti (40) mita eta. Bouti aniro nono sataro enea ubarero itariro etana toti (30) mita eta. ");
INSERT INTO yrb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Etate we imuta dera gebiro ane amufeisi we imutate anika fo (4) mune jogono afu enearo sataro itari. Itariro bouti kimu ui. Emanu unu kowa amufie iba guriguri uta. ");
INSERT INTO yrb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Moana bouti gaukara uwarama bouti ekodifitae dinigi nama doitate oitaro itari. Itariro weita, mui anika bouti iboro sabeisi irue weita. ");
INSERT INTO yrb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Eno weitaro Foroma ami kafitenini ami uwaraba wei, i uwara anibitaitana ya nesia uifoita wei. ");
INSERT INTO yrb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Weiro ami uwarama na umane tutaro dinigi ani. ");
INSERT INTO yrb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","34","Waibai Foroma wei, uiki sadei ieta itawa ibinitaba ieta iawe weite wei, buri age ofe ubu arama da ufisu. Ieta iawete buna uawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Eno weite i uwarabai buredi munite Godiba we ma kobererau uite buredi ma biraite i. ");
INSERT INTO yrb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Eno uiro etate ido ieta ita. ");
INSERT INTO yrb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","I boutiro anita uwara nesia tu aderedi seweniti sikisi (276) uwara etate ita. ");
INSERT INTO yrb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ieta ie me sitate uiti tai mutate enearo sataro bouti fe ui. ");
INSERT INTO yrb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","40","Wai urina magua etate i orofa iwawa uta. Utate i wanasi etana kobere magua eta. Etate iro anibitae weitate anika umane tutaro ibi. Eno uteda jogono ma owereta jawe nesia na uregari utate ibo farai sataro maguaro anisi. ");
INSERT INTO yrb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ane bouti ibo enea ubare gebiro duboro amusiro bouti kimu ui. Ufe derawere boutinu jogonoro urebiro bouti berugari ui. ");
INSERT INTO yrb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ami uwarama emanu kafiteniba weita, dibura uwara me sara aine anibitaitana ma uifeisi weita. ");
INSERT INTO yrb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Weitaro ami kafiteni dawa unutawa Foro uieta iba kodiawe weite wei, ogo iwata uwara itawete aine aniawe wei. ");
INSERT INTO yrb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ogo iwata me uwara i boutiro ibinu ibaiabai o ana o ane ane mune sawete deiro aine aniawe wei. Weiro eno utate i uwara nesia maguaro ane amue me sita. ");
INSERT INTO yrb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Maguaro fasite i mutumutunu ifuna Mota nausi. ");
INSERT INTO yrb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","I Mota uwarama yaba kobererau utebita. Obi matebiro iwu farebiba ina moatate yaba ario weita. ");
INSERT INTO yrb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","6","Foroma ina mune inaro odina awe towi ina buburaroma amuite Foronu agero aite siroro ubiro Foro age fisu uiro itari. I su uwarama etate weita, ewa amarana ma uieta amara, ogoro imu uitawa uiba awonana uifisu weita. Danu age wawafiro dowafite uifisu weitate yawotebitana me. Foro merau ibiba weita, dana ma uieta amara me, dana mui godi weita. ");
INSERT INTO yrb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","I mutumutu dera yawoeta amara Fubiasinu nasinina baworoba dana arawe weiro dawabai anisi. Kowa rarogonu yaba ieta nata nata utebiro itebisi. ");
INSERT INTO yrb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Fubiasinu damama ofe derawere wouri. Ofe wakikiwere wouriba Foro dawabai anite guriguri uteda age danu ofe deiro odiro wiroi. ");
INSERT INTO yrb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Foro eno uiba i ofe woureta uwara nesia Forobai fatate wirota. ");
INSERT INTO yrb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Enoba i uwarama yanu aneta kowaro me maeta faiyawere boutiro oita. ");
INSERT INTO yrb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Sakara rarogonu me siniro ya anisi. Yanu boutina Arekisana suroma fari bouti. Oyabibi kowaro iro ibebe anibie ui. Danu towanana Sokaka Amara sadei ari. Ina emanu godi sadeinu ereta tanana. ");
INSERT INTO yrb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ya ane Sirakiu suro fasite kowa rarogonu iro aisi. Kowa rarogonu me siniro nono anisi. ");
INSERT INTO yrb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Bebeuwere ane Regiuma suro fasite nono iroma anisi. Ane aisiro wai uriro kobere oyau fariro anisi. Ane Futiori suro fasi. ");
INSERT INTO yrb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Fasite bouti iro ekoisi. Godinu sina naueta uwara dobere ane atasi. Atasiro bana weitate uiki demurai ibiawe weitaba emabai kowa seweni (7) ibisi. Kowa seweni me siniro Romani dabaro burima duero anisi. ");
INSERT INTO yrb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Anisina Godinu sina naueta uwarama nautate atafitae fata. Fatana moana uwarama Kabaru Rarogonu kabesiro yawotebitaro moana uwarama are Afiasi guruguru ueta kabesiro atafitae are fata. Fataro Foroma erite Godi we ma kobererau uite neno kimu ui. ");
INSERT INTO yrb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Romani suro fasiro ami kafitenima Foroba wei, anu suro ibiaro mui ami amarama a iro yawofi weiro eno ui. ");
INSERT INTO yrb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kowa rarogonu me siniro Foroma weiro i Ju uwaranu yawoeta uwara dawabai fata. Fataro emaba wei, kaka nabue, nanu sina nauawe wei. Yanu su uwaraba ba me utawa uete yanu babamutunu baetaba ba me utawa uero Jerusaremu su uwara na me sara mutate Romani uwaranu agero oitaro na ewaro are. ");
INSERT INTO yrb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","I Romani uwarama na koto utate nabai kerere mero uieta kerere meba na ekodifitae weita. ");
INSERT INTO yrb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Eno weitaro Ju uwarama dua sina weitaro nana we, Sisabai animane watane we. Sisabai animate nanu Ju uwaraba meo wawei da wemau wei. ");
INSERT INTO yrb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ewa sina wemane wenero iba farita wei. Ju uwarama Mesaia fafisu imutaitaro nana Mesaia fari imutataneba na dibura amara wei. ");
INSERT INTO yrb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Weiro weita, Judia uwarama anu sina owawa matawa utaro yanu Ju uwara yabai fatate aba wawei wiawa uta weita. ");
INSERT INTO yrb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","I Godinu sina naueta uwaranu sina wiaro naufe weita. Uwara nesia i Godinu sina naueta uwaraba wawei webitaba iba wiaro naufe weita. ");
INSERT INTO yrb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Eno weitate kowa oitate anita. I kowa fariro Foronu suro eme faiyawere fata. Fataro Foroma emaba waura warairoma yawiro we mawetu utebi. Mosesinu bukaini i we bou ueta uwaranu bukaini munite i bukaroma Godinu yawoeta orofaini Yesuini we mawetu utebiro nautebita. ");
INSERT INTO yrb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","I uwara Yesu imufitae iba eno uiro moana uwarama naue imue utaro moana uwarama nautawa utaba iba yaranebita. ");
INSERT INTO yrb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","26","Yarane me sitaro Foroma wei, Godinu Imumu Kotofuma weiba i we bou ueta amara Isaiya enanari eno wei, i Ju uwaraba wia, naufote efoitana iwawa ufoita wia. ");
INSERT INTO yrb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Yanu neno kimuwere, yanu ome nautawa, yanu diti erawaba iba imutawa ufoita. Ereta, naueta, wiroeta, ya unutawaba Nabai da afoitana ya da ma wiromau wia, Isaiyama eno wei. ");
INSERT INTO yrb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Foroma eno weite wei, ewa sina nauegou uawe wei, Godima Danu wiroeta i aika uwarabai matasuba mubitaita wei. ");
INSERT INTO yrb_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Eno we me sinina i Ju uwara emanu emanu bebetuma bunawere urane yarane ue mataneda anita. ");
INSERT INTO yrb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Foroma danu su oiya uite oya sadei iro ibebi. Danu sina weta daba garari utawa utaba uwara faiyawere dawabai fata. ");
INSERT INTO yrb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Fataro Foroma emaba Godinu yawoeta orofa sinaini Dera Waria Amara Yesu Kerisonu sina wegou uiro nauta. ");
INSERT INTO yrb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Na Foro Yesu Kerisonu sabua ueta amara. Godima na afosoro amara mune odi. Danu kobere sina wemane iba na mune odi. Godima na eno mune odiba awona yaba ewa owawa ue odeda watane. ");
INSERT INTO yrb_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Boderewere Godima Danu kobere sina we bou uiro i we bou ueta uwarama i sina Godinu bukaro eno owawa ue oita. ");
INSERT INTO yrb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Godinu kobere sinana Danu Amaraba wasu sina. Danu Amarama eme sinite Deiwidinu sisia amara sini. ");
INSERT INTO yrb_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Dawa eme sinite Dawaini Godini kakarawere iba Danu ueta sineta kobererau, Godinu ueta sineta ari. Enoba Godima buna derawere uteda Yesu Dawa uietaroma ma uyariba Dawa Godinu Amara ina ya nesia iwata utaisi. Yanu dera Waria Amara Yesu Kerisoba watane. ");
INSERT INTO yrb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Godi Danu unu uteda i afosoro gaukara ueta yaba me maite Yesu Kerisoba ya Danu afosoro uwara sibene we mune odi. I orofa atata uwara nesia Yesu Kerisonu ifu nauteda imufitate Danu dabaro anibitae iba ya we mune odi. ");
INSERT INTO yrb_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ya Romani uwarabaini nanu afosoro gaukara utatane. Enoba Godi Danu ununa moana uwara torowa me, ya Romani uwaraini Yesu Kerisonu uwara siboe iba yaba Nanu uwara wasu. ");
INSERT INTO yrb_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Godima ya Romani uwaraba neno arama uteda iba ya Danu uwara we mune odi. Yaba ario watane, yanu Baba Godini yanu Dera Waria Amara Yesu Kerisoini emana yaba me durua ufisite emanu wesa ueta yaba mafisiro merau ibifoe watane. ");
INSERT INTO yrb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nanu botai sina eno, yana Yesu Keriso imuegou utaitaro i orofa atata uwara faiyawere nautaitaba Godibai yaba Yesu Kerisonu ifuro we ma kobererau utatane. ");
INSERT INTO yrb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nanu neno nesia Godinu amaranu sinabai maete iba wegou utatane. I ueta, Godi Dawa iwata, na yaba guriguri Godibai woroworo utatane. ");
INSERT INTO yrb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Nanu unu Godima na siaia ufiro yabai amane iba guriguri woroworo utebatane. ");
INSERT INTO yrb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nanu unu Godinu Imumu Kotofunu imueta nesia me maeta ari yaba we mawetu umate yanu naueta ma derawere umane iba yabai amane watane. ");
INSERT INTO yrb_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Na yabai famauna yanu nauetaini nanu naueta we matafete yanu neno ma kobererau ufete yaru ufeisi. ");
INSERT INTO yrb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Naiyemutu, na yabai amane utebitarana ane anema nanu aneta daba garari utebi. Nana uwara faiyawere i Ju me aika uwarabairoma Godibai we mune odebitara enanari ya Godibai mune odimane watane. ");
INSERT INTO yrb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Na Godinu imueta na iwataba naba kobererau ui i ari Danu kobere sina i Guriki uwaraini i Guriki me uwaraini iwata derawere uwaraini iwata me uwaraini eme nesiabai wemau. ");
INSERT INTO yrb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Enoba nana Godinu weta kobere sina ya Romani suro ibinita uwarabai wemane watane. ");
INSERT INTO yrb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nana Godinu weta kobere sinaba maru utawa utatane. I sinana Godinu buna derawere sina. I buna sinama i nautaita uwara ma wirotasu. I Ju uwara ma wirotasute nono duburo emanu buribi i Ju me aika uwara ma wirotasu. ");
INSERT INTO yrb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Godima eme ma rorowarau utasu. Godinu wasu kobere weta sinama anene Godima eme ma rorowarau utasu i we ma boroyarebasu. Ina etua botairoma ane emeda duburoma emanu naueta Yesu Kerisobai odaitana Godima ema ma rorowarau utasu. Godinu bukaroma eno wasu, ana anama emanu nauetaba Godima ema ma rorowarau ufisuna emana me ibene ibene ibeibitaita. ");
INSERT INTO yrb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Godinu sina nautawa siosawere utaita uwarama i ba sinanu daba garari utaitaba Godima emaba ibo uteda Danu fanisi maeta siaia utasuro ureroma emabai tararasuro eraisi. ");
INSERT INTO yrb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Godima Danu imueta emabai ma boroyarebiba ana anama Godi iwata ufitae imufitaitana Dawa iwata ufitaita. Nono i moana uwarama Godi unutawa iba Dawa ekoita. ");
INSERT INTO yrb_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Godima i ureini nasinini erawa nautawa ane ane ubu uite i ubu ui ememetu nesiaro Danu feare ibetawere ueta sineta, Danu bunaini Danu ba Godi imuetaini ma borobarasuba Danu koto kowa fafiro uwarama Dawa ya iwata me sina da webitaita. ");
INSERT INTO yrb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","I uwarama Godi iwata utedana Dawaba kakara utawa utate we ma kobererau utawa uta. Emana sara siosa imueta aika maika imutedaba emanu imuetana ario me, dumuwere. ");
INSERT INTO yrb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Yana iwata derawere uwara weitana nono emanu iwatana derawere meba iba me sara utaita. ");
INSERT INTO yrb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Emana i araetawere me ibene ibene ibeta Godi imutawa utate agema ubu ueta uitebaita eme ari ememetuini gasiraini egini towini utate i nesia emanu godi weita. ");
INSERT INTO yrb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Eno utaro Godima emanu siosawere uetaba i eno ueta kodiawe wiawa uiba emanu unu ibaiabai siosararabo daido utebita. Enoma enoma utebitate ofe marurarabo ibaiabai emanu emanu ue matanebita. ");
INSERT INTO yrb_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","I uwarama Godinu ba sina ekoitate emanu meo sina nautaba iba siosa uetararabo eno utebita. I uwarama i Godima ubu ui ememetubai guriguri uteda nono i ememetu ui Godibai guriguri utawa utebita. Yana Godinu ifu we ma derawere uene uene uteibene watane idoni. ");
INSERT INTO yrb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","I uwarama eno utebitaro Godima emaba eno ueta kodiawe wiawa uiro emanu unu siosawere dabaro anebita. I awetaboma awerasiba emanu ofe garari utedana aweta muini aweta muini eno udiri utebita. ");
INSERT INTO yrb_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Enanari emema awetabo ekoitate amara muini amara muini eno udiri utebita. Emema moana eme emaba neno uyareda siosawere utebita. Eno igabugawere utebitaba Godima emaba fanisi derawere mai. ");
INSERT INTO yrb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","I uwara ema unutawa Godi. Enoba Godima ema ekodiro emanu unu ibaiabai siosararabo utebita. Enoma enoma utebitana emanu imueta igawere utebiba siosawere ueta torowa utebita. ");
INSERT INTO yrb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","30","Eno utebitaba emanu beforonu imueta ba me uetama ma wate fari. Enoba emenu ba ueta sineta utawa siosawere torowa uegou utebita. Emanu ueta sinetana eno, diti ure owere ma owere ueta eme rekaro ma uieta, urane yarane ueta, meo weta, neno ka ueta, emanu ueta sineta enoba sina tobu ture inarebaita. Mui amaranu ifu ma siosa ueta, ema Godi unutawa, dera uwaranu sina nautawa, emana sasaerarabo uwara, emanu ifu torowa we ma derawere utebaita, siosa ueta rekaini rekaini utebaita, danua damamaba gifena utebaita. ");
INSERT INTO yrb_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","I uwarama neno neno utebaitana ema imutawa ina ane utebaita, bebetuma gugu fare fare inarebaita uwarama emanu su uwara imutawa utebaita. Uwaraba neno arama utawa utebaita. ");
INSERT INTO yrb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","I uwara ema iwata, anama eno ufisuna Godima dawa koto ufiro uifisu. Ina ema iwata utaitarogo ekodawa daido utedibaita. Nono moana uwarama enanari utaitana ema yaru utaita. Emanu yaru uetana siosararabo utaita. ");
INSERT INTO yrb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nono ya uwarade! Yana aika uwaraba wawei waitate enanari siosawere utaitaba iba Godi yaba da inafisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Anama nanu wene sina i, enanari siosawere ufisuna Godima dawa koto ba ufisu. Eno koto ueta deina ido waisi. ");
INSERT INTO yrb_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Naiyemutu, yana i ari utaita uwaraba ere wawei waitarogo nono ya enanari utebaita. Enoba ya Godinu kotoroma iya aniboita? Enona me. Yana eno siosawere utaitaba Godinu kotoro daido aniboro fanisi mafisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Godima ya neno arama uteda sau ibo utawa utasu. Nono ya unutawa Danu yaba kobererau ueta. Godima ya uwara yanu neno neno ueta dubena afu saboe iba yaba neno arama uteda kobererau utasu. ");
INSERT INTO yrb_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Yana Godinu sina nautawa ue yanu neno neno ueta dubena saneta iba unutawa utaitate yanu imueta kimuwere utaitaba yanu siosawere ueta derawere ufisu. Enoba i fanisi maeta kowaro Godima ya fanisi derawere mafisu. I kowaro Godima uwara nesia koto rorowarau ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Godima uwara nesianu uetaba ane ane mafisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ana anama kobere uetaini Godinu araetaini kobere ifu wetaini ibene ibene me ibetaini mubitae utedana kobererau uegou utebaitana Godima emaba ibene ibene me ibeta mafisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Anama emanu unu torowa utedana kobere ueta ekodaitate siosawere utebaitana Godima emaba ibo derawere uteda fanisi derawere mafisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","I siosawere utaita uwarama neno siosa uteda fanisi mubitate oferi derawere woufitaita. Ya Ju uwara, ya ko oferi eno wouforo nono yanu buribi i Ju me aika uwara nesia eno woufitaita. ");
INSERT INTO yrb_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Godima i kobererau utaita uwaranu ifu we ma derawere ufite kobere kabesiro odifite ma kobererau ufisu. I Ju uwarabai ko ufite nono emanu buribi i Ju me aika uwara nesiaba eno ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Godi Danu unu uwara torowana me Danu unu uwara nesia arotorowa iba uwara nesiaba arotorowa ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Enoba Mosesinu tarawatu iwata me amarama siosawere ufite uifisuna uitawa ina kabesiro anibisu. Iro anibiro Godima i amaraba Mosesinu tarawaturoma koto da ufisu. Nono i Mosesinu tarawatu yawiteda imutasu amarama siosawere ufite uifisuna enanari uitawa ina kabesiro anibiro Godima i amaraba Mosesinu tarawaturoma koto ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Mosesinu tarawatu sina nautaita uwarana Godima emaba kobere uwara da webisu. I tarawatu sina nautaitate enanari utaita uwarana kobere uwara webisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","I aika uwara, emabai Mosesinu tarawatu ibawa, nono i uwarama emanu beforoma i tarawatu sina iwata uteda utaitana emabai tarawatu meba emanu imuetana emanu tarawatu ari. ");
INSERT INTO yrb_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","16","Ema eno utaitana Godima i tarawatunu ubi emanu nenoro owawa ue odiba iba eno utaita. Godima eme nesia emanu nenoro feare ibetawere imueta nesia Yesu ma borobafite ido emabai koto derawere ufisu. Nana Godinu kobere sina eno watane enanari ufisu. I kowaro i uwaranu nenona emanu ere weta, ima emanu uetana siosawere wawei webisu aba emanu uetana kobererau eno webisu. ");
INSERT INTO yrb_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Nono yade! Yana Ju waita uwara. Yabai Mosesinu tarawatu ibinuro imutaitate yana Godi iwata utaita eno sina faiyawere waita. ");
INSERT INTO yrb_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Yana Godinu unu iwata utaita. Yanu tisa uwarama Mosesinu tarawaturoma we mawetu utebitaba siosawere uetaini kobererau uetaini yanae ture aika maika odaita. ");
INSERT INTO yrb_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ya eno waita, yana Godinu imueta iwataba i diti basugari uwara ari uwara Godinu dabaro woure are odifeisi waita. ");
INSERT INTO yrb_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Yana eno waita, i me sara siosa weta uwaranu imueta ma wirofete i iwata derawere me uwara ue mawetu ufeisi waita. Mosesinu tarawatu yabai ibinuba iwata nesiaini ba imuetaini iwata utaisi waita. ");
INSERT INTO yrb_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ido, yana aika uwara we mawetu utaitade nono yanu torowa we mawetu utaita aba me? Waira da ua waitade ya waira utaita aba me? ");
INSERT INTO yrb_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Dita yagera da fa waitade, ya dita yagera faraita aba me? I ba me godi ya unutawa waitade, i ba me godinu su ibaiabai waira utaita aba me? ");
INSERT INTO yrb_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Mosesinu tarawatuna yanu waitade, Mosesinu tarawatu ma furufareda Godinu ifu ma igabuga utaita aba me? ");
INSERT INTO yrb_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Godinu bukaroma eno wasu, yana siosawere utaitaba Godinu sina nautawa uwarama Godinu ifu ma siosa utaita wasu. ");
INSERT INTO yrb_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ya uwarama Mosesinu tarawatu uegou utaitana yanu ofe turetana kobererau, ima ya durua utasu. Yana Mosesinu tarawatu ma siosa utaitana yanu ofe turetana kobererau me. Ina ofe turawa uwara ari. ");
INSERT INTO yrb_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nono mui ofe turawa amarama i tarawatu nesia uegou utasuna dawa ofe tureta amara ari dawa ba Ju amara ari sinasu. ");
INSERT INTO yrb_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Enoba i ofe turawa amarama i tarawatu utasuro ya ofe tureta sina owawa uta tarawatu bobo uwarama i tarawatu utawa utaitaba dana ya ereda wawei wasu. ");
INSERT INTO yrb_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ana amarana ba Ju amara? Danu danua damama ba Ju uwarana dawa ba Ju amara? Me. I ba ofe turetana ofe tureta torowa me. ");
INSERT INTO yrb_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","I ba Ju amara dawa ba kobere neno imutasu amara. I ba ofe turetana neno tai tunono ueta. Ina Godinu Imumu Kotofunu ueta. Ina emenu kaiyama tureta me. Emema emanu ifu we ma derawere utawa utaitaro Godima emanu ifu we ma derawere utasu. ");
INSERT INTO yrb_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ya Ju uwara yabai ane kobere tai ibinu. Yabai ibinu i ari i moana uwarabai ibawa? Ane kobere emeru muboita i ofe turetaroma? ");
INSERT INTO yrb_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Yabai kobere emetu ibinu. I botaina Godinu kobere sina. Godima Danu kobere sina yawofene ya uwarabai ko mai. ");
INSERT INTO yrb_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Moana Ju uwaranu naueta ba me. Emanu ba me nauetama Godinu ba we bou ueta ma siosa ufisu aba me? ");
INSERT INTO yrb_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ema, enona me! Uwara nesia meo meo boboro Godi Dawa torowana ba. Godinu bukaroma Godiba eno wasu, a sina webasuna i sinana ba. Emema a koto ufitaitana ema serigari ufasu, eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Moana uwara eno waita, ya ba me ufeisina emema Godinu ma rorowarau ueta efitaita waita. Iba anene webeisi? Ya siosawere usiba Godima yaba fanisi mai. Eno uide Dawa siosawere ui? Me. Ina emenu imueta sina. ");
INSERT INTO yrb_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ema, enona me! Enorona Godi Dawana rorowarau meba i orofa atata uwara nesia anene koto ufisu? ");
INSERT INTO yrb_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Moana uwarama eno waita, yanu ba me uetaba emema Godinu sina ina ba iwata ufitate Danu ifu we ma derawere ufitaitana Godima yana siosa uwara aneba eno wasu? ");
INSERT INTO yrb_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Yana siosawere uteibe Godinu kobere ueta uyafisu waita. Moana uwarama eno meoma waita, Foroma i sina enanari wasu waita. I sinana nana wiawaro meowereba Godima i uwaraba fanisi derawere mafisu. ");
INSERT INTO yrb_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Anene wemau ari? Ya Ju uwara torowana kobererau nono i Ju me i aika uwarana siosawere? Me! Nana wene, uwara nesia arotorowa wene. Ueta siosawere ima Ju uwaraini i Ju me aika uwaraini ya nesia yawotasu. ");
INSERT INTO yrb_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Godinu bukaroma eno wasu, mui amarana rorowarau me, ya nesia siosawere. ");
INSERT INTO yrb_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ya nesia Godinu ba daba iwata me. Ya nesia Godi doberawa utaita. ");
INSERT INTO yrb_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Uwara nesia emanu unu aika dabaro anitate siosawere uta. Mui amarama kobererau utawa utasu. Nesia siosawere utaita. ");
INSERT INTO yrb_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Emanu nodoroini bebetuna eme uri utaitaro eba ubasu kabesi ari. Iroma urarawere sina farasu. Emanu meanana irueta emetu. Emanu bebetu fifiro towinu kae ari ibinu. ");
INSERT INTO yrb_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Emanu bebetuna imona me kawere sinama wate fare ibinu. ");
INSERT INTO yrb_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Emanu burima sau anaitate eme ma uitaita. ");
INSERT INTO yrb_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Emanu aika dabaro aneda eme ma siosa utaita. ");
INSERT INTO yrb_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Godinu kobere wesa kawewera ueta daba ema iwata me. ");
INSERT INTO yrb_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ema Godiba iya uyarawa uteda ema Godi imue ititi kakara utawa utaita, Godinu bukaroma eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ya iwata utaisi, Godinu tarawatuma we mawetu utasu sinana i tarawatuma yawotasu uwaraba wasu. Enoba moana uwarana i siosa uetade ane da iwawa ufitaita. Iba i Ju uwaraini i orofa atata uwara nesiaba kerere ibinuba emana Godibai moko sina wiawa wate mu utaitaba Godima ema koto daido rorowarau ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Enoba imue eawe! I tarawatu sina uegou utaita uwarama Godinu iboro rorowarau da inafitaita. Godinu tarawatu sina, ima yanu siosawere ueta ma borobarasuro yanu torowa yanu siosawere ueta iwata utaisi. ");
INSERT INTO yrb_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Enoba nono Godinu awona reka imueta imue eawe. Godima eme ma rorowarau ueta reka daba odiro ina ya iwata utaita iba ina i tarawatu daba me, i dabana aika. I tarawatu owawa yanaeta amaraini i we bou ueta uwaraini ema i reka dababana kobere daba idoni weita. ");
INSERT INTO yrb_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Anama Yesu Kerisobai danu naueta odasuna Godima dawa ma rorowarau utasu. Dawabai ewa uwarana Nanu oname uwara ido wiawa utasute Dana uwara nesiaba arotorowa we imutasu. Ana anama emanu naueta Yesu Kerisobai odifitaitana ema ma rorowarau ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Eme nesia siosawere utaro Godinu mafie utebi araeta emabairoma feari. ");
INSERT INTO yrb_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Godima yaba kobererauro rorowarau imuteda me durua utebiba awona ya Danu kobere durua uetaba Danu iboro rorowarau inaibinisi. Yesu Kerisoma yanu neno neno ueta mune imutawa uiba Godinu iboro yaini naini rorowarau ibinisi. ");
INSERT INTO yrb_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Godima Danu ununa Yesu Keriso uifite emenu neno neno ueta mubite imutawa ufie iba siaia uiro tararite yaba ui. Godima eme ma rorowarau ufie iba Yesu Keriso siaia uiro tararite uiba awona Godima Yesu Kerisoro eme ma rorowarau utasuro ya iwata utaita. I bodere uwarama siosawere utebitaro Yesu Keriso farawa Godima yawofie uteda emanu neno neno ueta ekodi. ");
INSERT INTO yrb_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Nono awona Godima i neno neno ueta uwara eno munasu, ana anama emanu naueta Yesubai odaitaro Yesu Kerisoma emanu neno neno ueta mune imutawa utasuna Godima ema eno munasu. Godi Dana rorowarauba eme eno ma rorowarau utebasuro iwata utebaisi. ");
INSERT INTO yrb_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Enoba ya Ju uwara yanu ueta sinetaba aneba sina yafawere webaisi? Yanu ueta sinetaba sina yafawere da webeisi. Godinu tarawatu sina nautaisite enanari utaisiba sina yafawere webeisi? Me. Ya Yesu Kerisobai yanu naueta odaisiba iba we ma derawere ufeisi. Mui amarama i tarawatu utasuba we ma derawere ufeisi? Me! Mui amarama danu naueta Yesu Kerisobai odasuna iba we ma derawere ufeisi. ");
INSERT INTO yrb_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Nana eno watane, anama Yesu Kerisobai danu naueta odasuna dawa Godibai ibinu. I tarawatu sina ima dawa ma rorowarau utawa utasu. I naueta torowa ima dawa ma rorowarau utasu iba eno watane. ");
INSERT INTO yrb_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Godina i Ju uwara torowanu Godi? Dana i aika uwaraini emanu Godi aba me? Aiwia Dawana i aika uwaraini emanu Godi. ");
INSERT INTO yrb_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Godi Dawa demuraiba Dawana i aika uwaraini emanu Godi. Godima i ofe tureta uwaranu Yesu Kerisobai nauetaba ema ma rorowarau utasute i ofe turawa uwaranu Yesu Kerisobai nauetaba ema enanari ma rorowarau utasu. ");
INSERT INTO yrb_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ya eno utaisiba yanu nauetama Godinu tarawatu sina ma siosa utaisi? Me! Yanu nauetama Godinu tarawatu sina ma kimu utaisi. ");
INSERT INTO yrb_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Eibaramu dawana ya Ju uwaranu botai sirorari amara. Eibaramunu naueta sina wemaro nauawe. Eibaramu dawa i naueta doberebe ane atani aba me? ");
INSERT INTO yrb_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Eibaramu danu aika gaukara uetama Godinu iboro eno rororowarau inafirona danu torowa ma uyareda sina faiyawere webie. Meba danu torowa Godinu iboro danu ueta ma uyareda sina faiyawere wiawa ui. Nanu sina nauawe. Eibaramu dawa danu torowa ma kobererau utawa uiba sina faiyawere da webisu. ");
INSERT INTO yrb_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Godinu bukaroma eno wasu, Eibaramuma Godinu sina nauite danu naueta Godibai odiba Godima i amaranu neno ma rorowarau uite ana kobere amara wei. ");
INSERT INTO yrb_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Mui amarama gaukara ufisuna danu moko mubisu. Ina me maetana me. Dawa gaukara utasuba iba danu moko munasu. ");
INSERT INTO yrb_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Emanu wiroetaba emanu torowa gaukara utawa utaita uwara, Godima emanu neno, me ma rorowarau utasu. Enoba anama i tarawatunu ueta utawa utasute danu naueta Godibai odegou utasuna Godima eno we imutasu, i amaranu nauetaba danu nenona rorowarau we imutasu. ");
INSERT INTO yrb_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Deiwidima boderewere enanari wei. Godima i tarawatu ueta utawa uwara mune emanu neno ma rorowarau utasuro yaru derawere utaita. ");
INSERT INTO yrb_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Deiwidima i imuetaba eno wei, Godima ananu siosawere ueta mune imutawa utasute emanu siosawere ueta maiturasuba i uwarana yaru derawere utaita. ");
INSERT INTO yrb_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Yanu Dera Waria Amarama i siosawere ueta Danu uwarabai odawa Dana mune aika odasute mune imutawa utasuba yaru derawere utaita, Deiwidima eno wei. ");
INSERT INTO yrb_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","I yaru uetana i ofe tureta uwara torowanu yaru ueta aba i ofe turawa uwaraini emanu yaru ueta? I yaru uetana i naueta uwara nesianu. Nanu botai yaba wene sina nono wemaro nauawe, Eibaramuma danu naueta Godibai odi, ima danu neno ma rorowarau ui. ");
INSERT INTO yrb_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Abo kowaro eno ui? Danu ofe turi kowaro ko aba danu ofe turawa kowaro eno ui? Dawa danu ofe turawa kowaro ko eno ui. ");
INSERT INTO yrb_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Eibaramu danu ofe turawa kowaro Godibai danu naueta odiro Godima danu neno ma rorowarau ui. Nono danu neno rorowarauba danu ofe turi. I ofe turetana danu neno rorowarau uetanu towana. Enoba dawana i ofe turawa naueta uwara nesianu damama. I ofe turawa uwaranu nauetana emanu kobere ueta Godima eno we imutasu. ");
INSERT INTO yrb_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Nono dawana i ofe tureta uwaranu damama. Eibaramu dawa danu ofe turawa danu naueta Godibai odi, enanari, i ofe tureta uwarama emanu ofe turetaba imuegou utawa emanu naueta Godibai odaitana dawana emanu damama. ");
INSERT INTO yrb_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Godima Eibaramuini danu sisia uwaraini i orofa atata nesia mubitae we bou ui. Eibaramuma i tarawatu sina naui iba Godima i tarawatu naui webite i sina we bou utawa ui. Eno utawa uiro Eibaramu dawa danu naueta Godibai odi iba Godima dawa ma rorowarau uite i sina we bou ui. ");
INSERT INTO yrb_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Godima tarawatuba i sina we bou ufirona i Godibai nauetana kobererau mero nono emema i tarawatu uegou utawa utaitaba Godinu we bou uetana me sibie. ");
INSERT INTO yrb_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Emema Godinu tarawatu ma siosa utaitana Godima ibo derawere utasu. Enoba i tarawatuini Godinu ibo ueta ma arotorowa ue ibinisi. Nono i tarawatu merona emema i tarawatu da ma siosa uteibitae. ");
INSERT INTO yrb_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Enoba Godima i Godibai nauetaba i sina we bou ui. Godi Danu unuba Dana i we bou ueta me mai. Enoba Eibaramunu sisia uwara nesiabai enanari mai. I tarawatu bobo uwaraini i tarawatu me naueta, Eibaramunu naueta ari uwaraini ema nesiaba i we bou ueta me mai. Eibaramu dawana ya nesia yanu baba. ");
INSERT INTO yrb_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Godinu bukaroma Eibaramuba eno wasu, Nana i orofa atata faiyawere uwaranu damamana a ido ode wasu. Godima i we bou ueta sina weiba ina ba. Eibaramu i Godibai danu naueta odi. I Godima uieta uwara uietaroma ma uyarasute i boderewereroma ibawa ememetu wawaro odasuro faraita wasu. ");
INSERT INTO yrb_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Godi Dawa eno ueta Godiba Eibaramu danu naueta Godibai odegou uite i kimuwere ueta iwawa utawa ui. Dana Godi Eibaramu dawaba amara mafisu imuteda yawoi. Danu naueta Godibai odegou uiba dawa orofa atata faiyawere uwaranu sirorari amara sini. Godinu bukaroma enanari wasu, anu sisia uwara faiyawere sibitaita wasu. ");
INSERT INTO yrb_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Dawa iwata, danu ofe kimu uiba ina uieta amaranu ofe ari sinono ui. Danu oyana wanaderedi (100). Danu aweta Sera dawa burukawereba dawa kuita da mubisu eno iwata uite danu naueta ma wawana wawana utawa Godibai kimuwere odegou ui. ");
INSERT INTO yrb_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Eibaramuma Godinu sinana meo sina we imutawa uite i sina nauegou ui. Danu nauetana kimuwereba Godibai we ma kobererau ui. ");
INSERT INTO yrb_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Dawa eno we imui, Godi ane ane we bou utasute Dana bunawereba daido enanari utasu eno imuegou ui. ");
INSERT INTO yrb_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Eno uiba Godima danu nauetaba dana rorowarauro kobere amara wei. ");
INSERT INTO yrb_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","24","Dana kobere amara sina Eibaramu dawa torowaba i sina owawa odawa ya nesia i sina efene iba owawa odi. Yanu Dera Waria Amara Yesu uietaroma ma uyari Godi, Dawabai yanu naueta odifeisina yana rorowarauro kobere uwara eno webisu. ");
INSERT INTO yrb_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yesu Keriso Dawa yanu siosawere uetaba uiro nono Yesu yanu neno ma rorowarau ufie iba Godima Dawa ma uyari. ");
INSERT INTO yrb_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ido, yanu naueta Yesu Kerisobai oisi. Oisiro yanu nauetaba Godima yanu neno ma rorowarau ui. Nono Yanu Dera Waria Amara Yesu Kerisoro yaini Godini wesarau ibinisi. ");
INSERT INTO yrb_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Yanu naueta Yesu Kerisobai oisi. Oisiro Dana ya nesiaba i me rorowarau ibeta daba wabue moya uiro awona i me maeta Dawabairoma musite iro inaraisi. Iro inareda nono yaini Godinu kobere araetawere efene utebaisi ibaiabaiba duburo efeisiba iba awona yaru derawere utaisi. ");
INSERT INTO yrb_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Awona i ueta aika maikama yanu naueta ma siosa ufie utebasu ima yanu naueta ma kima uteibisuba iba jaja utawa ure nudarau uteda yaru derawere utaisi. ");
INSERT INTO yrb_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","5","Yanu ure nudarau uetaba yanu naueta kimu utasuro Godima ina kobererau we imutasu. Godima eno we imutasuba Danu we bou ueta nesia mubene yawotaisi. Godinu Imumu Kotofuma Godinu neno arama ueta yanu neno ubarero woure odegou uiro ibinuba yanu mubene yawotaisi ina daido fafite yanu neno da ma siosa ufisu ina ya iwata utaisi. ");
INSERT INTO yrb_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Yana buna mewereba me ibisiro Godinu we odi ba kowa enanari Kerisoma i Godi imutawa uteda siosawere utebita uwaraba tare ui. ");
INSERT INTO yrb_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Mui amarama mui rorowaru ueta amaraba uietana ina kimu derawere. Enorogo nono mui amara neno kimu ufite mui kobere amaraba uifie rairogo ina ido. ");
INSERT INTO yrb_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ya bodere siosa utebisi uwararogo Godima yaba neno arama uite Keriso siaia uiro tararite yaba ui. Godima eno uiba Dawa yaba neno arama utasuro ereda iwata utaisi. ");
INSERT INTO yrb_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Enoba awona Yesunu uietaba Godima Yesu Kerisonu oferoma itari wiroeta ononoma yanu neno ma rorowarau uite ya kobere uwara we odi. Ina eno uiba ya nesia iwata utaisi, duburo Godima i siosawere uetaba ibo derawere ufisurogo nono i Dana derawere ibo uetaro ya da inafite ya ma wirofisu. ");
INSERT INTO yrb_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","11","Boderewere yaini Godini wasai utebisi. Eno ue ibisiro Yesu Kerisoma yaba tare uite Godinu ibo turi. Eno uite Yesu Dana ya ma owere mune Danu reka wiroeta dabaro ma rorowarau ue odiba i reka dabaro torowa wiroegou ufeisi. Nono i torowaba merogo yanu Dera Waria Amara Yesu Kerisoma Godinu ibo turiba yaini Godini demurairo ibeda iba yaru derawere utaisi. ");
INSERT INTO yrb_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Mui amara demuraima siosawere uiro siosawere ueta ewa nasiniro ido fari. Ewa nasiniro ido fariba uietaini ido fari. Enoba eme nesia siosawere utebaisite uitebaisi. ");
INSERT INTO yrb_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Bodere i tarawatu emebai ibawa utebina siosawere ueta faiyawere utebitarogo nono tarawatu meba Godima i siosawere uetaba ibo utawa me ere ekodebi. ");
INSERT INTO yrb_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","I sinana ba, nono Adamubairoma are Mosesibai i odoro eme nesia uitebita. Adamuma Godinu unu ma siosa uiba dawa iba ui. I bodere uwarama Adamunu siosawere ueta ari enanari utawa aika utebitarogo daido uitebita. Adamu danu ueta sinetaroma Yesunu fareta ma boroyari. ");
INSERT INTO yrb_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Adamu danu ueta demurairatuna siosawere. Godi Danu me maetana kobererau. Adamu dawa siosawere uiba eme nesia uitebaita. Nono Godi Danu imueta aika ui. Dawa emeba neno arama uteda Danu me maeta, Yesu Keriso odiro ya me durua ufite yanu siosawere ueta mune imutawa ufie ewa nasiniro tarari. Enoba Danu kobere ma wiroeta eme nesiabai fari. ");
INSERT INTO yrb_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Nono Godinu me maetana aika, i amara demurainu siosa uetana aika. I siosa uetanu ubina uieta. Godinu me maetanu ubina me ibene ibene ibeta. Godinu me maetana eno, Godima Yesu Keriso odiro ewaro farite emenu siosawere ueta faiyawere munite ema ma wiroi. ");
INSERT INTO yrb_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","I amara demurai Adamu danu siosawere uetaba iba eme nesia uitaisiro i uietama ya nesia yawotasurogo nono i amara demurai Yesu Kerisoba Godima Danu me maeta matasuro ima ya Godibai ma rorowarau utasuro Dawabai ibegou utaisi. Enoba yaini Yesu Kerisoini kobererau ibaisite i siosawere ueta serigari utaisiro ima ya yawotawa utasu. ");
INSERT INTO yrb_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","I amara demurainu siosa ueta demurairatuba eme nesia uitebaita, enanari Yesu Kerisonu kobere uetaba emema me ibene ibene ibifitaita. ");
INSERT INTO yrb_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","I amara demurai Adamunu siosawere uetaba eme nesia emana siosawere ueta uwara sinebita, enanari i Amara Demurai Yesunu kobere uetaba eme faiyawere emana kobere uwara sinaita. ");
INSERT INTO yrb_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Godima Danu tarawatu maiba emema siosawere ueta dera emetuwere utebitarogo nono Godima emeba Danu kobere me durua ueta mai. Idoba emenu siosawere uetaini Godinu kobere durua uetaini ibinurogo nono Godinu kobere durua uetana bunawereba emenu siosawere ueta ma seserigari utasu. ");
INSERT INTO yrb_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Enoba i siosa uetama eme nesia yawoteda ema ma uitebi. Nono awonana Godima ya me durua uteda Yesu Kerisoro ya ma rorowarau utasute yawotasuba me ibene ibene ibifeisi. ");
INSERT INTO yrb_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Nana eno weneba anene webeisi? Godima ya woroworo durua uteibisuba iba ainewaure siosawere uteibero Dana yaba derawere kobererau durua uteibisu eno webeisi? ");
INSERT INTO yrb_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ema, enona me! Ya siosawere ueta ekoisite uieta eme ari sisiba anene siosawere ainewaure uteibeisi? ");
INSERT INTO yrb_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ya Yesu Kerisonu ifuro babataito musite Dawaini demurai ari sisite Dawaini uinono usi. ");
INSERT INTO yrb_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","I babataito uetama ya Yesubai ma taka uiba Yesuini yaini uri uta. Nono Baba Godi Danu ariowere bunama Keriso uietaroma ma uyari i ari yaini reka ueta sineta ufeisi. ");
INSERT INTO yrb_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ya Dawabai ma taka uiro Danu uieta ari enanari Dawaini uisina Dawabai ma taka ufiro Danu uietaroma Godima ma uyariro me ibinu i ari ya enanari ma uyafiro me ibifeisi. ");
INSERT INTO yrb_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ya iwata, yanu bodere ueta sineta Dawaini korosiro ure badami ue oita. Enoba yanu ewa awona ibinisi oferoma siosa woroworo ufene utaisirogo nono ewa ofenu unu nesia Godima ma nuda ui. Eno uiba i siosa uetama yanu ewa ibinisi ofe yawotawa utasu. ");
INSERT INTO yrb_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Enoba anama uitasuna i siosa uetama dawa yawotawa utasu. ");
INSERT INTO yrb_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nono yana Yesu Dawaini uisiba Dawaini me ibifeisi eno imutaisi. ");
INSERT INTO yrb_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ya iwata, Godima Keriso uietaroma ma uyariba Keriso Dawa nono da uifisu. I uietanu bunama Dawa yawotawa utasu. ");
INSERT INTO yrb_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Dana i siosawere uetaba Dawa demuraima daido demurai ui. Nono awona Danu reka wiroetaro Dawa me ibeda Godinu unu uegou utasu. ");
INSERT INTO yrb_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Nanu ununa ya eno imufoe watane. Yana i siosawere uetaroma uita. Eno utate nono awonana Godibai Yesu Kerisoini arotorowa ibeda inaraita iba imuegou uawe. ");
INSERT INTO yrb_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Enoba i siosa uetama yanu ofe ubu yawotawa utasuba i siosawere uetanu unu da ufoita. ");
INSERT INTO yrb_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Yanu ofe ubuma siosawere uotoba yanu ofe ubu ememetuini bunaini siosawere uetabai da odiawete Godibai odiawe. Yana uitate nono awona me ibinitaba yanu ofe ubu ememetuini bunaini Godibai odiawete yanu ofe ubuma kobererau torowa utebeawe. ");
INSERT INTO yrb_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ya i tarawatu sinabai ibawa utaisite Godinu kobere durua uetabai ibaisiba i siosawere uetama ya da yawofisu. ");
INSERT INTO yrb_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Enoba ya i tarawatu sinabai ibawa Godinu kobere durua uetabai ibaisiba siosawere uegou ufene waita? Ema, enona me! ");
INSERT INTO yrb_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ya ewana iwata utaita, mui dera yawoeta amarabai yanu torowa sabua ueta uwara ari mafoitana yana daido i dera yawoeta amaranu ba sabua ueta uwara. Siosawere uetaini kobererau uetaini ema dera yawoeta amara sadei ari. Enoba yana ueta siosanu sabua ufoitana inu ubina uieta. Nono kobererau uetanu sabua ufote gifena da ufoitana Godima ya ma rorowarau ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Bodere yana siosawere uetabai ane sabua utebita. Nono awona moana uwarama Godinu kobere sina yaba we mawetu utaitaro ya nautaitate enanari uegou utaitaba Godibai we ma kobererau utatane. ");
INSERT INTO yrb_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Yana yanu bodere yawoetana siosawere uetaba ekoitate awonana Godinu kobere uetanu sabua ueta uwara sita. ");
INSERT INTO yrb_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Nanu ununa ya uwara iwata ufoe iba ema sabua ueta sinaroma watane. Bodere yana yanu ofe ubu ememetuini bunaini siosawere ufitae i siosawere uetabai oita enanari awona yanu ofe ubu ememetuini bunaini nesia i kobererau uetabai odiawete kobererau torowa ufoe watane. ");
INSERT INTO yrb_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Bodere yana siosawere uetanu sabua utebitate kobererau uetaba imutawa utebita. ");
INSERT INTO yrb_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Yana eno utate ane moko muta? Awona iba maru utaita. Yanu bodere uetanu mokona uieta. ");
INSERT INTO yrb_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Nono awona i siosawere uetabairoma ma dare munite odiro yana Godinu sabua ueta uwara sita. Enoba yanu mokona Godinu kobererau uetaini me ibene ibene ibetaini ido. ");
INSERT INTO yrb_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","I siosawere uetanu mokona uieta. Nono Godinu me maetanu mokona yanu Dera Waria Amara Yesu Kerisoini yaini me ibene ibene ibeta ido. ");
INSERT INTO yrb_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Naiyemutu, tarawatu sina ya iwata utaita. Ewa mui tarawatuna ewaro i me ibinita uwara torowa yawotasu. Nono i uieta uwara yawotawa utasu. ");
INSERT INTO yrb_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","I awerasi bobo awetaboma tarawatuba emanu awerasini ibedana merau emanu awerasibai taka ue ibifitaita. Nono mui awetanu awera uifisuna i awetanu danu awerabai taka ue ibeta tarawatu ekodifisu. Tarawatu me sibisuba iba ima i aweta da yawofisu. ");
INSERT INTO yrb_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Enoba mui awetanu awera uitawa me ibifiro i awetama mui amarabai taka ufisuna dana dita yagera uyare fareta aweta. Nono danu awera uifiro danu awerabai taka ue ibeta tarawatu ido me sibisuba i awetana mui amara mubisuna dana dita yagera uyare fareta aweta me. ");
INSERT INTO yrb_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Naiyemutu, nanu sina edono, yana i korosiro ui Kerisonu ofe ememetu ari sitaba uitebaita i ari utate i tarawatu ekoita. Ekoitaba yana mui amarabai taka ufoe iba uitate ekoita. Nana i uietaroma ma uyari Yesu Kerisoba watane. Enoba Godibai kobererau ufoita. ");
INSERT INTO yrb_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Bodere yanu sara siosa ueta nenoma ya yawotebina i tarawatuma yaba webiba ya yanu ofero siosawere utebisi. Enoba yana uieta uwara ari sisi. ");
INSERT INTO yrb_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Awonana ya i Ju uwaranu tarawatu sinaini baetaba neno siosa da uawe. I tarawatu sinama ya diburaro odinono uite yawotebiba inu sabua ueta uwara sita. Nono awonana i owawa oeta tarawatubai uitate i sabua utebita gaukara ekoita. Enoba yana Godinu gaukara i bodere owawa oeta tarawaturo da ufote i reka Imumu Kotofuro uegou ufoita. ");
INSERT INTO yrb_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Nana eno weneba ane imutaisi? I tarawatuini siosawere uetaini ema demurai ari eno imufeisi? Ema enona me! I tarawatuma nabai siosawere ueta we mawetu utawa ufirona nana i siosawere ueta iwawa umane. I sina edono, tarawatuma naba eno wei, diti uro owere ma owere da ua weiba ina siosawere ueta na iwata ue. ");
INSERT INTO yrb_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","I tarawatuma siosawere ueta sina naba webiba nanu ununa siosa ueta derawere umane utebitara. Tarawatu mena siosawere uetana me. ");
INSERT INTO yrb_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","10","Bodere nana i tarawatu iwata meba nana yaru ue kobererau ibebitara. Nono duburo i tarawatu ido farina nana i tarawatu iwata uero siosawere ueta nabai ido uyariba na uinono ue. Na eno we imue, i me ibeta tarawatu ima naba wiroeta we bou uirogo nono naba matawa uite nabana uieta mai na eno we imue. ");
INSERT INTO yrb_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","I tarawatuba siosawere uetama nanu nenoro uyarite na iruite ma ui. ");
INSERT INTO yrb_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Nanu sina nauawe. I tarawatuna kakarawere, ina rorowarau, ina kobererau. ");
INSERT INTO yrb_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","I kobere tarawatu ima nanu me ibeta mu sanite nabai uieta odi eno imutaita? Ema, enona me! I siosawere uetama i kobere tarawaturo nanu me ibeta mu sanite nabai uieta odi. Eno uiba ba me uetana siosa derawere eno we imutaisi. I tarawatuma ya eno we mawetu utasu, i siosa uetana siosa derawere eno we mawetu utasuro iwata utaisi. ");
INSERT INTO yrb_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ya iwata, Godinu tarawatuna kobererau. Nono nana me eme torowa. Nanu nenona siosawereba nana siosawere uetanu sabua ueta amara. ");
INSERT INTO yrb_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Nanu utatane, i uetana na iwawa iwawa utatane. Nanu unu umane utebatane i ane ane na utawa utatane. Nono na unutawa utebatane i ane ane ina utatane. ");
INSERT INTO yrb_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Na unutawa utebatane i ane ane daido utataneba i tarawatunu weta sinaini baini kobererau we imutatane. ");
INSERT INTO yrb_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Imue eawe. Nanu torowa eno utawa utatane. I siosawere uetama nanu nenoro ibinuba iba siosawere utatane. ");
INSERT INTO yrb_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Na iwata, kobere ueta sineta nanu sara siosa ueta nenoro ibawa utasu. Nanu unu i kobere ueta sineta umau. Umaurogo nono nabai buna meba iba kobere ueta sineta utawa utatane. ");
INSERT INTO yrb_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Nanu unu umane utebatane ane ane ina na utawa utatanete nono na unutawa utatane ane ane ima na daido utatane. ");
INSERT INTO yrb_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Enoba na unutawa utebatane ane ane utatanena nana utawaro nanu nenoro ibinu siosawere ueta ima eno utasu. ");
INSERT INTO yrb_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","I sinanu ubina edono, nanu unu kobererau umauna siosawere ueta nabai ibinuba kobererau utawa siosawere utatane. ");
INSERT INTO yrb_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Nana Godinu tarawatu imuteda nenoma yaru utatane. ");
INSERT INTO yrb_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Nono nanu sara siosa ueta nenoro aika tarawatuma ibeda nanu unu tarawatuini uraneda na budari utasute wasuba nanu siosawere unu umane utatane ane ane imuetaini daido utatane. ");
INSERT INTO yrb_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Enoba nana neno siosa utatane. Anama na ewa uieta oferoma ma wirofisu? ");
INSERT INTO yrb_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Yanu Dera Waria Amara Yesu Kerisoma na ma wirofisuba nana Godibai we ma kobererau utatane. Nanu sina nauawe. Nana Godinu tarawatu beforoma imuegou utatanete nono nanu sara siosa ueta nenoba i aika tarawatunu siosawere ueta utatane. ");
INSERT INTO yrb_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nana eno wemaro nauawe. Ana anama emanu naueta Yesu Kerisobai oitate Dawabai ibinitaba Godima emaba fanisi da mafisu. ");
INSERT INTO yrb_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Nana nanu naueta Yesu Kerisobai odete Dawabai ibitararo Danu Imumu Kotofuma naba me ibene ibene ibeta mai. Danu me ibene ibene ibeta tarawatuma i uieta tarawatubairoma na mune aika odi. ");
INSERT INTO yrb_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nono ya uwarana siosawerero buna meba Mosesinu tarawatuma yaba eno utawaro nono Godima yaba eno utebi. Godima Danu Amara siaia uiro ewaro tararite yanu siosawere ofe ari ofe muneda ba eme sini. Godi Danu ununa Yesu Kerisoma siosa ueta mu sabie iba siaia uiro tararite ba eme sini. ");
INSERT INTO yrb_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Dawa eno uite i siosawere uetanu buna mu saniba i tarawatuma ma rorowarau ueta wasu sina ya Godinu Imumu Kotofunu bunaro inaraisi uwarabai nesia enanari ui. ");
INSERT INTO yrb_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ana ananu sara siosa ueta nenoma ema yawotasuna emana siosawere uetaba imutaita. Imumu Kotofuma ana ana yawotasuna emana Imumu Kotofunu kobere uetaba imutaita. ");
INSERT INTO yrb_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Anama i nenonu siosa uetaba imufisuna dawa daido uifisu. Anama Imumu Kotofunu kobere wesarau uetaba imufisuna dawa merau ibeda me ibene ibene ibifisu. ");
INSERT INTO yrb_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ana anama emanu bodere siosawere nenonu ueta utaitana Godini wasai utaita. Emana eno utaitaba Godinu tarawatu sina nautawa utaita. Emanu bodere nenona siosawereba iba gifena utaita. ");
INSERT INTO yrb_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ana anama emanu naueta Godibai odawa uteda emanu bodere nenonu unu siosawere utaitana Godima emaba ibo utasu. ");
INSERT INTO yrb_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Nono yade. Godinu Imumu Kotofuma yabai ibinuba yana i siosa nenonu ueta utawa yana Imumu Kotofubai ibeda kobererau utaita. Enoba Kerisonu Imumu Kotofuma anabai ibawana dawana Yesu Kerisonu amara me. ");
INSERT INTO yrb_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Nono Yesu Kerisoma yanu nenoro ibinuba yanu ofe uifiro nono Godima yanu neno ma rorowarau utasuba yanu imumu Godibai ane me ibene ibene ibifisu. ");
INSERT INTO yrb_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Godima Yesu Keriso uietaroma ma uyari. Enanari nono Danu Imumu Kotofu yanu nenoro ibifisuna Godima Keriso uietaroma ma uyari enanari yanu ewa uietawere ofe ma uyafisu. Danu Imumu Kotofu yanu neno ubarero ibinuba iba ya ma uyafisu. ");
INSERT INTO yrb_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Enoba, naiyemutu, ya yanu sara siosa ueta nenonu we mune maeta uwarana me. Danu siosa ueta da ufeisi. ");
INSERT INTO yrb_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Yana yanu sara siosa ueta nenonu ueta ufoe ufoitana uifoita. Nono yana Godinu Imumu Kotofunu buna mubote i sara siosa ueta nenonu ueta mune aika saboitana me ibene ibene ibifoita. ");
INSERT INTO yrb_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ana anama Godinu Imumu Kotofunu sina nautaitate enanari utaitana emana Godinu koiniboro. ");
INSERT INTO yrb_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Godinu Imumu Kotofu yanu nenoro itarina sabua ueta uwara sinawa Godinu koiniboro sisi. Bodere Godiba iya derawere uyasite nono awonana ya iyarawa utaisi. Godinu Imumu Kotofuma yabai ibinuba Godiba yanu Baba waisi. ");
INSERT INTO yrb_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Godinu Imumu Kotofuma yaba wasuba yana Godinu koiniboro nenoma we imutaisi. ");
INSERT INTO yrb_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Nono yana Godinu koiniborona yana Danu we bou utasu muneta uwara. Yana Kerisoini i we bou ueta uruama mubeisi. Yana Dawaba neno oferi woufeisina Dawaini Godinu araetawere orofaro ane ibifeisi. ");
INSERT INTO yrb_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nanu imueta wemaro nauawe. Yanu neno oferi wouretana derawere me. Godima Danu kobere araetawere yabai odifisuba yanu neno oferi wouretaba da imufeisi. ");
INSERT INTO yrb_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Godima Danu uwara mawetu ufiro Godinu ubu ui ememetu nesiama Godinu naueta uwarade abo uwara efitae iba yawotaita. ");
INSERT INTO yrb_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ana omaini erawa nautawa nesia me sara siosa ibinita. I ememetu ema unutawa ema eno ue siosa ibeta. Godi Danu unuma ema eno ibifitae we odi. I ememetu emana i kobere ma wirofisu kowa yawotaita. ");
INSERT INTO yrb_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","I ana omaini erawa nautawa nesia awona sibu uraitate yajara utaita. Nono duburo Godima ema ma wirofisu. Godima ema ma wirofiro Godinu koiniboroini emana uietaini yajara uetaini nesia ekodifitate kobererau araetaro ibeibitaita. ");
INSERT INTO yrb_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Awonana ana omaini nesia oferi woureda arua wenono utebaita. Awetama aruma amara mubie uteda i webasu i ari arua wenono uteda siosawere ibinita. ");
INSERT INTO yrb_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Nono i ana omaini erawa nautawa emanu torowa eno ibawaro yaini eno ibaisi. Godima Danu Imumu Kotofu yaba ko mai uwara yana enanari nenoro i weda Godima yanu ofe ma wirofite Danu omueta uwara odifiro yanu reka ofe daido ba mubeisiba iba imuegou uteda yawotaisi. ");
INSERT INTO yrb_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Yana eno naue imue usiba Godima ya ma wiroi. Nono i reka ofe yabai ibinude aneba i reka ofe mubene imuegou utaisi? Yabai i reka ofe ibawana iba i reka ofe mubene yawoteibeisi. ");
INSERT INTO yrb_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Nono ya i erawa emetu mubene yawofeisina ya jajabujiji me kekerama yawoteibeisi. ");
INSERT INTO yrb_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Yana buna meba Godinu Imumu Kotofuma ya durua utasu. Godibai guriguri uteda anene waisi ya iwata meba i weda neno sanaisiro Imumu Kotofuma durua uteda Godibai kobere sina wasu. ");
INSERT INTO yrb_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Godi Dawa yanu nenoro imueta ereda Danu Imumu Kotofunu imueta iwata utasu. Imumu Kotofu Dawa Godinu unu ueta iwata uteda iba Godibai ya Godinu naueta uwaraba nui webasuro Godima Danu imueta iwata utebasu. ");
INSERT INTO yrb_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ya nesia eno iwata uteda we imutaisi Godima Danu unu uite ya Danu uwara we mune odi. Eno we mune odiro Danu ba uwara sisite ibinisirogo nono yabai ane ane ueta kimurarabo faraita. Faraitarogo Godinu Imumu Kotofuma ya kobererau ibifene i ueta nesia munasute ima Dana ya durua utasuro kobererau ibebaisi. ");
INSERT INTO yrb_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Bodere i eme ibawa kowaro Danu Dawabai naue imue ufitaita uwara nesia Dawa iwata ui. Eno iwata uite ema Danu amara Yesu ari sibitae we mune odi. We mune odite Danu ununa Danu adarabu nesiabai Yesu Keriso Dawana botai Amara sibie iba eno ui. ");
INSERT INTO yrb_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Godima i boderewere we mune odi uwara ema awona yua we mune odasu. Ema yua we mune odasute emanu neno daido ma rorowarau utasu. Emanu neno daido ma rorowarau utasuba Danu araetaro ema daido ma inafisu. ");
INSERT INTO yrb_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Enoba anene webeisi? Eno webeisi, Godi Dawa ya durua utasude anama yaba wasai ufisu? ");
INSERT INTO yrb_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Godima Danu Amara ubi ma wawi utawa uite odiro yaba tare uiba enanari ya iwata Godima yaba ane ane nesia da ma feafite maegou ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Anama Godinu we muneta uwaraba wawei webisu? Godima ya ma rorowarau utasuba Dana yaba wawei da webisu. ");
INSERT INTO yrb_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Anama yaba do mafisu? Yanu abanaro inareta Amara Yesu Keriso Dawa uitema uyarite Godinu banibira age afu mane yaubine. Enoba Dana abanaro inareda yanu sina Godibai wasu. ");
INSERT INTO yrb_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ane Anema Yesu Kerisonu neno arama ueta yabairoma ma taie sabisu? Kerere ueta aba yanu ofe urumu ueta aba awe uyareta aba osi ueta aba wadia me ibeta aba ya ma siosa ufie arebasu siosawere ememetu aba rekaro ma uieta, i ueta nesia ima Yesu Kerisobairoma ya da ma taifisu. ");
INSERT INTO yrb_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Godinu bukaroma eno wasu, Yesuba ya uietanu iboro ainewaure Yana ya nesia mamoe egi ari ufitae imutaita, eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Yesu Kerisoma yaba neno arama uteda durua utasuba ane ane yabai uyarasuna ya ma siosa utawaba arisiaraisi. ");
INSERT INTO yrb_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","Nana eno imutatanero Godima yaba neno arama utasuba erawa nautawa ane anema Dawabairoma ya da ma taifisu. I uieta uretaini reka ibetaini aneruini i aika bunawere imumuini ema nesia ya Dawabairoma da ma taie aika odifitaita. I ure abanaro ibinita imumuini i nasini ubarero ibinita imumuini Godinu ubu ui orofa orofa aboro aboro ibinita ane aneini ema nesiama ya Godibairoma da mune sabitaita. Godima yaba neno arama utedaba Yesu Keriso odiro yaba ewaro tare uiba Godibairoma ya da mune sabitaita. ");
INSERT INTO yrb_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Nanu ba sina wemaro nauawe. Na naueta amaraba nanu sinana meo me, ba sina. Godinu Imumu Kotofuma nanu nenoro ibeda durua utasuba ewa sina watane. ");
INSERT INTO yrb_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Nana i Ju uwara nesiaba na neno siosa uteda ofe urumu derawere utatane. ");
INSERT INTO yrb_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Nana nanu Ju uwara, babamutu, kaka, nabueba imuegou utataneba emanu kerereba nanu ununa Godima emanu fanisi maeta naba mafite na Yesu Kerisobairoma ma taifirona ema wirofitate kobererau ibifitae eno imuteda iba watane. ");
INSERT INTO yrb_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Emana Ju uwara Godi Danu adarabu sibitae ema Danu torowabai ma taka uteda we mune odi. Eno we mune odite Danu kobere araeta emaba nata nata ui. Eno uite Danu unuro ue matanetaini dera dubu suro ba guriguri uetaini we bou ueta tarawatu emaba mai. ");
INSERT INTO yrb_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","I bodere sirorari uwarararabona i Ju uwara emanu danatamutu. Godinu ma wiroe mune aneta Amara Dawaini ba ofe muni iba enanari emana Danu danatamutu. Ido Godi Dawa uwaraini ane ane nesia yawotasuba Danu ifu ainewaure we ma derawere uteibene watane. ");
INSERT INTO yrb_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Godinu we bou ui sina dowarinu wiawa utatane. Imue eawe, i Isaraero sisiaroma sirorari uta Isaraero uwara ema nesiana Godinu we muneta ba Isaraero uwarana me. ");
INSERT INTO yrb_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Enoba ya eno da imufe. I Eibaramubairoma arebe are fari sisia, ema nesiana Eibaramunu ba sisia me. Godinu bukaroma eno wasu, Aisikibairoma anu sisia uwarama afitaita wasu. ");
INSERT INTO yrb_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Enoba Eibaramunu ofe torowaroma sirorari ue arebita uwarana Godinu koiniboro merogo nono i Danu unuro ue matanetaro we bou utebiro nautebita uwara emana ba Godinu koiniboro. Emana Eibaramunu ba sisia uwara. ");
INSERT INTO yrb_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Godinu we bou ui sina edono, ewa watane ba kowa etei oyaro nono owemate abai famaro Sera amara mubisu, Godima Eibaramuba eno wei. ");
INSERT INTO yrb_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Nono ina i torowana me. Rebekama amara sadei sokaka muni. Emanu damamana demurai. Dana Godinu we bou ui yanu sirorari amara Aisiki. ");
INSERT INTO yrb_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","I aweta Rebeka dia munebina i amara sadei desini ubarero ibeda kobererau aba siosawere utawa usiro Godima ereda Rebekaba wei, i botai amarama i dubu amaranu gaukara ueta amara sibisu wei. Godi Danu unu ufie uteda iba eno wei. Dawa unutawa mui amara ueta derawere ufisuba botai amara sineta. Danu unu dubu amara Dana weiba botai amara sini. ");
INSERT INTO yrb_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Godinu bukaroma i ari eno wasu, Jeikofuba neno arama utatanete Isoba ibo utatane eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Enoba anene webeisi? Godi Dawa kobererau utawa eno webeisi? Ema, enona me! ");
INSERT INTO yrb_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Godima Mosesiba wei, anaba durua umane imumauna durua umau. Anaba neno arama umane imumauna daido dawaba neno arama umau wei. ");
INSERT INTO yrb_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Enoba emenu unuini emanu utaita sinaitaini kobererau weda iba eno da ufisu. Godi Danu unu durua uetaba iba eno ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Godinu bukaroma Feroba eno wasu, emema Nanu buna efitae Nana a anu kabesiro ma uyare odine. Nanu ununa ewa sina i orofa atata uwara nesiabai we anibitae iba eno une wasu. ");
INSERT INTO yrb_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Enoba Godi Danu unu uwara durua ufisuna durua ufisu. Nono uwaranu neno ma kimu ufisuna ma kimu ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Godima Danu unu eno ufisuba yana naba eno weboita, Godima eno ufisutema nono anene moana uwaraba siosawere waita uwara webisu weboita? Eno utasuba emema emanu unuro da ufitate Godinu unu torowa ufitaitade nono anene sina eno webisu weboita? ");
INSERT INTO yrb_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Nono a anaiyade. Ana ba amara torowade aneba Godiba moko sina wasu? I ubu ui emetuma i ubu ueta amaraba eno webisu, aneba na eno ubu ui webisu? Eno me, eno da webisu. ");
INSERT INTO yrb_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","I sakaima okia ubu ueta amara dawa okia sadei ubu ufisuna danu unu uteda ubu ufisu. Dawa okia demurai kobererau ubu ufite kobere ieta ubarero odifisu. Nono dawa mui okia me sara ubu ufite gamo ubarero sabisu. Dawa eno ufisude eno ufisu aba me? Aiwia eno ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Godima Danu buna efitae uteda i bodere siosawere uteda uieta mubitae utebita uwaraba imutebe imutebe ibo uteda kekerema yawotebi. ");
INSERT INTO yrb_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Nono ya, Danu kobere ue bou ueta okia ari ufero yaba neno arama ufite Danu araeta yaba mafie iba eno ui. ");
INSERT INTO yrb_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Yana i ari. Dana ya yua we muni. I Ju uwaraini i aika uwaraini ema nesiabairoma ya mune aika odi. ");
INSERT INTO yrb_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","26","Godima Osea bukaro eno wasu, i bodere Nabai guriguri utawa uwara Nana emaba Nanu uwara wemau. Bodere emaba imutawa uero Nanu neno emabai ibawa uite nono duburo emabai ibifiro emaba Nanu kobere uwarararau wemau. Bodere i orofaro ibebitana Godima emaba wei, yana Nanu uwara me wei. Nono i orofaro emema emaba eno webitaita, yana i me ibene ibene ibeta Godinu koiniboro eno webitaita, Godima eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Bodere Isaiyama i Isaraero uwaraba eno wei, i Isaraero uwarana faiya faiyawere. Emana i enea magua ari. Godima ema nesia da ma wirofite moana torowa ma wirofisu Isaiyama eno wei. ");
INSERT INTO yrb_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Godima Danu wei sina enanari ewa nasiniro ibeta uwarabai fanisi daido sau bunawere mafisu. ");
INSERT INTO yrb_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Isaiya dawa bodere eno wei, i eme nesia yawotasu Godi, Dawa ya durua da ufirona yana i Sodomuini Gomora uwara ari sibete eme me ibifene Isaiyama sina eno wei. ");
INSERT INTO yrb_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ibago anene webeisi? Eno webeisi, i aika uwarama i kobere ueta mubitae uteda gaukara utawa uteda emanu naueta torowa Godibai odebitaro Godima ema ma rorowarau utebi. ");
INSERT INTO yrb_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Nono i Isaraero uwarana emanu neno i tarawatubai ma rorowarau ufitae utebitate i tarawatu sina nesia atane utawa utebita. ");
INSERT INTO yrb_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Aneba i tarawatunu sina nesia utawa utebita? Emana emanu naueta Godibai odawa emanu gaukara ueta torowa utebita. I uwarama Yesu Dawana i buridu ue ureieta gebiro ariba iba iro buridu ure ureitebita. ");
INSERT INTO yrb_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Godinu bukaroma Yesuba eno wasu, Nana Saioni orofaro buridu ue ureieta gebiro odimaro ina eme ma ureifisu. Nono anama danu naueta Yesubai odifite dawa maru da ufisu, Godinu bukaroma eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Naiyemutu, nanu unu derawerena Godima Danu fanisi uetaroma i Isaraero uwara ma wirofie watane. Eno imuteda iba Godibai guriguri utebatane. ");
INSERT INTO yrb_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Na iwata, i Isaraero uwara emanu unu derawere Godinu dabaro anibitae imuegou utaitate nono Godinu sina nauegou utawaba Danu dabaro anawa utaita iba watane. ");
INSERT INTO yrb_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Godima emenu neno Danu torowabai ma rorowarau utasu emana i ueta imutawa utaitate emanu aika buna uetama emanu neno ma rorowarau ufitae ue eraita. Ema unutawa Godima emanu neno ma rorowarau ueta. ");
INSERT INTO yrb_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ya iwata utaisi, Yesu Keriso Dawa i tarawatu nesia ue me siniba anama danu naueta Dawabai odasuna Dana i amaranu neno ma rorowarau ue Godibai ma taka utasu. ");
INSERT INTO yrb_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mosesima eno wei, anama tarawatuma dawa ma rorowarau ufie imufisuna i tarawatunu we kakara utasu sina enanari nesia yawoegou uteda ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ana anama emanu naueta Godibai ode rorowarau inaretaba sinana edono, yabairoma anama etua urero manibite iroma Keriso ewaro wo tarafiro ya durua ufisu eno da we imuawede. ");
INSERT INTO yrb_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Enanari nono anama emeda nasini ubarero i uieta uwarabai tanibite Keriso iroma woure etu deiro amufiro me ibifisu eno da we imuawede. I eno imueta daba ibawa me. ");
INSERT INTO yrb_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","I sina edono, Godinu sina yabai ibinu, ina yanu nenoini bebeturo ibinu. Nono i Godibai naueta sina ya uwaraba waisi. ");
INSERT INTO yrb_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Yana Yesu Dawa i Dera Waria Amara weda bebetuma eno waitate Godima Dawa uietaroma ma uyari yanu nenoma imutaitana Godima ya ma wirofisu. ");
INSERT INTO yrb_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Yana nenoma Godi imutaisiba Godima yanu neno ma rorowarau utasu. Yanu bebetuma yanu naueta waisiba Godima ya ma wirotasu. ");
INSERT INTO yrb_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Godinu bukaroma eno wasu, anama danu naueta Godibai odasuna dawa maru da ufisu eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","I Ju uwaraini i aika uwaraini ema nesia arotorowa. I Dera Waria Amara Dawa i uwara nesia emanu Waria Amara. Anama Dawabai guriguri uteda Danu ifuro ane ane wenaueraitana Yesu Kerisoma ema we ma kobererau utasu. ");
INSERT INTO yrb_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Godinu bukaroma eno wasu, ana anama yanu Dera Waria Amarabai emanu naueta odeda Dawabai Dera Waria Amara ya ma wiroa weda nui webitaitana Yesu Kerisoma ema ma wirofisu. ");
INSERT INTO yrb_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Emanu naueta Dawabai da odifitaitade anene Dawabai nui webitaita? Nono Danu sina nautawa ufitaitade anene emanu naueta Dawabai odifitaita? Godinu sina botai wiawa ufitaitade i sina anene naufitaita? ");
INSERT INTO yrb_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Godinu sina weta uwara da siaia ufitaitade i sina aboroma fare webitaita? Nono Godinu bukaro sinama eno wasu, Godinu kobere sina woure fare waita uwarana kobererau eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Nono i Ju uwara nesia Godinu kobere sina munawa uta. Boderewere Isaiyama eno wei, Dera Waria Amara, i uwarama yanu waisi sina nautawa utaita, dana eno wei. ");
INSERT INTO yrb_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Godinu kobere yaba waitaro nauteda sina Yesu Kerisoba nautaisiba yanu naueta Godibai odaisi. ");
INSERT INTO yrb_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","I Isaraero uwara ema i sina nautawaba iba me ibebita? Me, ema i sina nauta. Godinu bukaro sinama eno wasu, i sina i orofa atata kabesi nesiaro we inarebita. Emanu sina i orofa atata aboro aboro ibebita uwarabai ani, Godinu sinama eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","I Isaraero uwarama i sinanu ubi iwawa uteda iba i sina nautawa? Mosesinu sina wemaro nauawe. Godima Mosesinu bukaro eno wei, i aika uwarabai kobererau umauba Isaraero uwarama i ereta ereda madudu webitaita. i me sara siosa utaita aika uwarabai kobererau umaro Isaraero uwarama ubusi uyafitaita, Godima eno wei. ");
INSERT INTO yrb_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Nono Isaiyanu bukaro eno bunawere wei, i Na doberawa uwarama Na atanita. Nana Naba dobere wiawa utebita uwarabai Nanu torowa ma boroyare, Godima eno wei. ");
INSERT INTO yrb_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Nono Godima i Isaraero uwaraba wasu, i gifena wasai ueta uwara emaba Nanu age woroworo fisu uteda Nabai arawe webatane, wasu. ");
INSERT INTO yrb_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Nanu wenauereta nauawe. Godima Danu uwara imutawa uite ekodi aba me? Ema, enona me! Nana Isaraero amara, nana Eibaramu danu sisia, nana Benijameninu abua amara. ");
INSERT INTO yrb_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","4","Godi Dawa Danu boderewere we muni uwara ekodawa ema imutasu. Yana Iraijanu wei sina imutaita aba me? Dana Godinu bukaro Godibai Isaraero uwaraba eno wawei wei, Baba Godi, emana Anu we bou ueta uwara ma uitate Anu fuyo oeta kabesi ma jujuwegari utaro nanu torowa ibinero na ma uifitae waita wei. Dana eno weiba Godinu wei moko sina imutaita aba me? Dana eno weiro Godima moko wei, Nana eme torowa faiyawere nesia seweni tausani (7000) mune aika odine. I uwarama i ba me godi Beirabai jejerigari utawa uteda dawabai guriguri utawa utebita wei. ");
INSERT INTO yrb_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Awonana i ari Godima Danu unu uteda moana i Ju uwara faiyawere merogo moana uwara torowaratuba kobererau imuteda ema mune aika odinu. ");
INSERT INTO yrb_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Godi Danu unu derawere utedaba ema mune odi. Nono yanu ueta kobererau uforo efite iba eno utawa, Danu unu ya, iba eno durua ui. Yanu gaukara uetaba eno ufirona Danu yabai durua uetana ba durua ueta me. ");
INSERT INTO yrb_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Enoba i Isaraero uwara anene utebita? Isaraero uwara emanu ununa Godinu rorowarau daba atafitae utedana faiyawere atanawa utaro Godinu we muneta uwara faiya meratu emanu torowana i rorowarau ueta daba atata. ");
INSERT INTO yrb_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Godinu bukaroma eno wasu, i Ju uwara faiyawere emanu ome gogore uiba Godinu sina nautawa Godima emanu ditini omeini garari uiba ditima erebitate nono bana erawa, omema nautebitate nono bana nautawa utebita. Eno utebita enanari awona eno utaita wasu. ");
INSERT INTO yrb_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Deiwidima Godinu bukaro eno wasu, emanu unu ueta, emanu ogaroini ofuaini ina ema muneta oga ari sibie watane. Emanu ogaro itedana eno imutaita yana Godini arotorowa meo we imufitaitaba Dawabairoma dowafitate emanu mokona fanisi muneta daido mubitaita. ");
INSERT INTO yrb_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Godima emanu diti ma basugari ufiro da efitae watane. Emanu siosa uetana ego urumu ari sibiro woufitate daubi ue anibitae watane, eno wei. ");
INSERT INTO yrb_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Eno utaba Godima ema daido ekodi aba me? Enona me. Emanu siosa uetaba Godima Danu ma wiroeta i aika uwaraba mai. I Isaraero uwarama efitate neno siosa uteda wiroeta imufitae iba i aika uwara ma wirotebi. ");
INSERT INTO yrb_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","I Isaraero uwara ema siosawere utebitaba Godima Danu kobere maeta i orofa atata aika uwaraba mai. Isaraero uwara ema unutawa Godinu wiroetaba Godima Danu wiroeta i aika uwarabai mairo merau ibita. Nono duburo i Isaraero uwara nesia emana owefitate Godibai fafitaitana i orofa atata uwarana kobere kimu kakeirau ibifitaita. ");
INSERT INTO yrb_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","14","Nana Ju uwara me, ya aika uwaraba watane. Nana ya aika uwarabai afosoro gaukara utatane. Nanu sina nauawe. Nana eno umaro efitate i moana Isaraero uwarama neno siosa ufitate Godibai wirofitae iba yabai nanu afosoro gaukara yaru bobo uegou utatane. ");
INSERT INTO yrb_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Imue eawe! Isaraero uwarama Godi ekoitaba moko ema ekodi. Ekodite nono i orofa atata uwaranu ma wiroeta Godi sini. Enoba Isaraero uwara duburo emanu Godibai owere fafitaita ina ane ari? Ina uietaroma uyareta ari sibitaita. ");
INSERT INTO yrb_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","I fuyo ode sina weta uwarama buredi demurairoma muduna afu ma birabiareda Godibai matebita. I fuyo buredini i iwo buredina arotorowa Godinu. Enanari i ana ini kobererauba i ana nesia kobererau. I kasei sinanu ubina edono, i Isaraero sirorari uwarana Godinu uwaraba i Isaraero uwara nesia emana Godinu uwara. ");
INSERT INTO yrb_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","18","Godima i botai ba emema waieta oriwa waita ana iwara umane tasire mune eta aika odi. Eno odite nono ya Ju me aika uwarana i me waratasu oriwa waita ana iwara ari, ya eno umane ture munite i ba iwaranu kabesiro yaino ue odi. Dana eno utasuro yana i ana ininu ogo itebaitaba sasae da uawete i ba iwaraba we ma siosa da uawete yanu ifu we ma derawere da uawe. Yana i ana ini yawotawade ana inima ya yawotasugo. Enanari Godima i Ju uwara we ma kobererau utasuro yana i Ju uwarabai i we ma kobererau ueta munaisi. ");
INSERT INTO yrb_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Ya ba iwaranu kabesiro mune yaino ue odifie iba ba iwara umane tasire sani waita. ");
INSERT INTO yrb_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","21","Ba waita. Ema unutawa emanu naueta Godibai oetaba iba umane tasire sani. Nono yana yanu naueta Godibai odaitaba iba ibinita. Enoba sasae da uawete Godiba iya uyareda merau ibiawe. I Isaraero uwarana ba iwara ari emana ibeda Godi imutawaba Godima ema umane tasire sani. I ari yana ibeda Godi da imufoitana Godima ya ana iwara ari umane tasire sabisu. ");
INSERT INTO yrb_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Godinu neno arama uetaini Danu ibo uetaini nesia imuawe. Godima i siosawere utebita uwaraba ibo ui. Nono ya Dawa imue naue uteda imutebaita uwaraba kobererau durua utasuba imuawe. Yana Godinu neno arama ueta imuegou uteda yanu ueta sineta da imufoitana merau ibifoita. Mena Godima ya ana iwara ari umane tasire sabisu. ");
INSERT INTO yrb_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Nono i Isaraero uwarama emanu i nautawa utaita daba ekodifitate i naueta dabaro anibitaitana Godima ema nono mune emanu bodere ana iwararo ma badami ufisu. Godi Danu buna derawereba iba eno ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Ya Ju me aika uwarama yana bodere i me waratasu oriwa waita ana ari ibebitaba Godima ya umane ture munite ba oriwa waita ana baro yaino ue odi. I eno uetana ina i waratasu ememetunu ueta me. Ina Godinu ueta. Godima eno utebiba Dawa i ba iwara nono mubite ba ana abanaro ma yaino ue odegou ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Naiyemutu, na unutawa ya uwarama yanu imuetaba sasae ueta. Nanu ununa Godinu kiwuma imueta iwata ufote sasae da ufoe iba watane. I imuetanu ubina edono, awonana i Isaraero uwarama Godi imutawa awona torowa eno me ibinitaba Godima i aika uwara ma wirotasu. Eno uteibiro i Ju me aika uwaranu muneta are arotorowa ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Eno ufisu i odoro Godima Isaraero uwara nesia ma wirofisu. Godinu bukaroma iba eno wasu, i ma wiroeta Amara Dawa Saioni orofaroma fafite i Jeikofu abua uwaranu siosawere ueta nesia mune sabisu. ");
INSERT INTO yrb_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Godima wei, i uwaranu siosawere ueta mune aika samauna ina ido emaini naini yanu unuro ue mataneta ido wei, Godinu bukaroma eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Isaraero uwara ema unutawa Yesu Kerisonu kobere sina. Iba emana Godiba wasai utaitaba Godima ya aika uwaraba imutasu. Nono Godima i Isaraero uwara bodere mune odi. Dawa emanu sirorari uwaraba imuegou utebiba Isaraero uwara nesiaba neno arama utebasu. ");
INSERT INTO yrb_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Godima Danu imueta ure owere ma owere utawa utasu. Ane matasuna Dawa da ma darefisu. Dawa Danu muneta uwara da ekodifisu. ");
INSERT INTO yrb_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ya aika uwarama bodere Godiba gifena uteda ejiwa utebita. Nono awonana i Isaraero uwarama Godiba gifena uteda ejiwa utaitaba yana Godinu me maeta munaitaro Godima yaba neno arama utasu. ");
INSERT INTO yrb_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Enanari i Ju uwara emana awona Godiba gifena utaita. Godi Danu ununa ya Ju me aika uwarama Godinu me maeta neno arama ueta munaita i ari Isaraero uwarama nono mubitaita. ");
INSERT INTO yrb_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Godima eme nesiaba neno arama ufite durua ufie iba emanu gifena ueta ere ekodiro daido utebita. ");
INSERT INTO yrb_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Godi Danu gugua gubarina derawere, Danu imuetana bunawere, Danu iwatana derawere. Anama Danu imuetanu ubi we ma boroyafisu? Anene utasuna eme ema iwata me. ");
INSERT INTO yrb_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Godinu bukaroma iba eno wasu, anama Godinu imueta iwata utasu? ");
INSERT INTO yrb_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Anama Godiba we mawetu utasu? Anama Godiba ane maiba Godima dawaba moko mafisu? eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Godima i nesia ubu ui. Dana nesia yawotasuro ibinita. I nesina Danu. Enoba Danu ifu ibene ibene we ma derawere uteibeisi. Deina ido. ");
INSERT INTO yrb_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Naiyemutu nauawe. Godima yaba ure nudarau ue neno arama utasuba yanu ofe me ibinu kakara fuyo oeta ari Godibai odiawero mubite yaru ufi. Ina yanu kobere ba guriguri ueta ari. ");
INSERT INTO yrb_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ewa orofa atata nautawa uwaranu me ibeta ari da uawe. Yanu imueta Godibai odiawero Dana yaba reka imueta mafi. Eno ufiro yana Godinu imueta iwata ufote yaru uteda kobere ueta torowa uegou uteiboita. ");
INSERT INTO yrb_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Godima naba neno arama uteda nanu gaukara maiba iba wemaro nauawe. Yana yanu torowaba ya derawere eno da we imuawe. Yanu ifu we ma derawere da uawe. Godima naueta yabai odiba iba yanu torowa kekerama imuawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Yanu ofe demurairo ofe ememetu faiyawere ibinita. Buri, age, ome, diti eno ibinita. I ememetuma yanu ofero gaukara aika maika utaita. ");
INSERT INTO yrb_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","I ari ya naueta uwarana faiyawerero yana Yesu Kerisobai taka utaisina yana ofe demurai ari. Enoba yanu yanu durua ue matanaisi. ");
INSERT INTO yrb_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Enoba Godima yaba neno arama uteda me maeta buna aika maika maiba iba enanari ufene watane. Mui amaranu me maeta bunana sina weta maiba imuegou uteda Godinu sina webasu. ");
INSERT INTO yrb_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ananu bunana eme yawoeta mai enanari utebasu. Ananu bunana we mawetu ueta mai enanari utebasu. ");
INSERT INTO yrb_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Ananu bunana emeba we kakara ueta mai enanari bebetuma we kakara utebasu. Ananu bunana moana emeba nata nata ueta mai enanari uegou utebasu. Ananu bunana durua ueta mai enanari uegou utebasu. Ananu bunana neno arama ue durua ueta maiba yaru uteda enanari durua utebasu. ");
INSERT INTO yrb_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Neno arama ufoitana meo me ba uawe. Yana siosawere ueta kodiawete kobererau uetaba imuegou uteda enanari kobererau uawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Yana yanu yatae yabue neno arama utaita i ari yanu yanu neno arama ue matawete yanu yaiyemutuba ititi kakara uteda emanu ifu we ma derawere uawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Yanu gaukaraba ofe ejiwa da uawete bunawere uawe. Yanu imueta ma derawere uawete yanu Dera Waria Amaranu gaukara uegou uawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Godinu ma wiroeta duburo muboita iba yawoteda yaru uawe. Awe uyareta yabai fafisuna jajabujiji ue neno siosa da uawete Godibai ure nudarau ue guriguri utebeawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","I naueta uwaraba nata nata uawete yanu suro aika uwara afitae bana wiawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Ana anama yaba ueta siosawere ufitaitana ema we ma kobererau uawete nono ema we ma siosa da uawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","I yaru utaita uwarabai yaru uawe. I i waita uwarabai i wiawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Yanu yanu wesarau ue arotorowa ibiawe. Sasae da uteda yanu torowa ya dera uwara da wiawete i ibaiabai me uwarabai owiga uawe. Yana beforo bunawere uwara eno da we imuawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Mui amarama yaba siosawere ufisuna yana dawaba moko siosawere da uawe. Anene eme ema kobererau imutaita i ari uawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ya yanu ununa wesarau ibifoitana urane yarane da uawete uwara nesia emaini uruama wesarau ibiawe. ");
INSERT INTO yrb_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Naiyemutu, me sara uwarama yaba siosawere ufitaitana emaba moko da uawete kodiawe. Ekodiawero Godi Dana emaba ibo uteda moko ufisu. Godinu bukaroma eno wasu, yanu Dera Waria Amarama wasu, i moko uetana Nanu gaukara. Nana moko umau wasu, Godinu bukaroma eno wasu. ");
INSERT INTO yrb_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Enoba yabai wasai utaita uwara osima arama ufitaitana yana emaba ieta mawe. Ema ogo nodo ufitaitana ogo mawe. Yana eno ufoitana emanu maru inama yare weri weri unono ufisu. ");
INSERT INTO yrb_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Siosa ueta ya da arisiafiro kobere ueta uegou uawete ima i siosawere ueta arisiawe. ");
INSERT INTO yrb_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ya uwara nesia i gaemani dera uwaranu sina naufene watane. Godima weiba iba gaemani dera uwarama yaini orofa atataini eno yawotaita. Godima i uwara emanu kabesiro mune odi. ");
INSERT INTO yrb_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Enoba yana gaemani dera uwaranu sina da naufoitana Godinu sinaini da naufoitago. Ana anama dera uwara emanu sina da naufitana gaemani uwarama ema fanisi mafitaita ina ido. Eno ufitaita ina i sina nautawa ufitaita uwara emanu kerere. ");
INSERT INTO yrb_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Anama kobere ueta sineta utasuna dawa i koto yawoeta amaraba iya da uyafisu. Anama siosawere utasuna dawa i koto yawoeta amaraba iya uyafisu. A unutawa gaemani uwaraba iya uyareta? Enonago ana kobererau uaro dana aba kobererau webi. ");
INSERT INTO yrb_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","I gaemani dera amara dana Godinu gaukara ueta amara. Dana aba kobererau durua utebasu. Nono ana siosawere ufasuna dana aba fanisi maosoba iba iya uya. Dana Godinu gaukara amara dana Godinu ibo ueta ma boroyareda i siosawere ueta amaraba fanisi mafisu. ");
INSERT INTO yrb_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ya unutawa Godinu ibo uetaba kobererau ufoita, iba torowa me, yanu neno siosa uotoba iba kobererau uawe. ");
INSERT INTO yrb_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Enoba yana yanu takesi oi mawe. I takesi muneta uwara emana Godinu uwaraba iba i gaukara eno utaita. ");
INSERT INTO yrb_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","I dera uwarama ane ba mafoe webitaitana mawe. Yanu takesi aika maikaba oi mawe. I dera uwaraba ititi kakara uawete emanu ifu we ma derawere uawe. ");
INSERT INTO yrb_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Nanu mui sina edono, yanu we muneta ane ane nesia ma owere mawete nono woroworo yanu yanu neno arama ue matanebeawe, i yabai kobererau utaita, i, daido moko uawete nono neno arama uteda ainewaure utebeawe. Anama danu daiyeba neno arama utasuna dawa Godinu tarawatunu ueta nesia utasu. ");
INSERT INTO yrb_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Godinu tarawatu sinana eno, dita yagera da fawe, eme da ma uiawe, waira da uawe, diti ure owere ma owere da uawe. I sinaini mui tarawatu sinanu ubina demurai edono, yanu torowa neno arama utaita i ari yanu yaiyemutu neno arama uawe. ");
INSERT INTO yrb_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Anama danu daiyeba neno arama utasuna dawaba ueta siosawere utawa utasu. Enoba neno arama ueta ina i tarawatu nesia danu ubi. Eno utaitana i tarawatunu sina nesia enanari ba ido utaita. ");
INSERT INTO yrb_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Nanu mui sina wemaro nauawe. Ewa wai ya iwata utaita. Ina nauta ainibeta kowana me, ina uyareta kowa. Yana Godi imusite Godima ya mubisu kowa baworo me eno we imusi. Nono awonana Godima ya mubisu kowana baworo. ");
INSERT INTO yrb_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","I dumuna me sibie utasuro i waina sau farasu. Enoba i dumunu sio