﻿USE sofia;
DROP TABLE IF EXISTS sofia.yor_vpl;
CREATE TABLE yor_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yor_vpl WRITE;
INSERT INTO yor_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1"," Ní ìbẹ̀rẹ̀ ohun gbogbo Ọlọ́run dá àwọn ọ̀run àti ayé. ");
INSERT INTO yor_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ayé sì wà ní rúdurùdu, ó sì ṣófo, òkùnkùn sì wà lójú ibú omi, Ẹ̀mí Ọlọ́run sì ń rábàbà lójú omi. ");
INSERT INTO yor_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ọlọ́run sì wí pé, “Jẹ́ kí ìmọ́lẹ̀ kí ó wà,” ìmọ́lẹ̀ sì wà. ");
INSERT INTO yor_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ọlọ́run rí i pé ìmọ́lẹ̀ náà dára, ó sì ya ìmọ́lẹ̀ náà sọ́tọ̀ kúrò lára òkùnkùn. ");
INSERT INTO yor_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ọlọ́run sì pe ìmọ́lẹ̀ náà ní “ọ̀sán,” àti òkùnkùn ní “òru.” Àṣálẹ́ àti òwúrọ̀ sì jẹ́ ọjọ́ kìn-ín-ní. ");
INSERT INTO yor_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ọlọ́run sì wí pé, “Jẹ́ kí òfúrufú kí ó wà ní àárín àwọn omi, láti pààlà sí àárín àwọn omi.” ");
INSERT INTO yor_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ọlọ́run sì dá òfúrufú láti ya omi tí ó wà ní òkè òfúrufú kúrò lára omi tí ó wà ní orí ilẹ̀. Ó sì rí bẹ́ẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ọlọ́run sì pe òfúrufú ní “ọ̀run.” Àṣálẹ́ àti òwúrọ̀ sì jẹ́ ọjọ́ kejì. ");
INSERT INTO yor_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ọlọ́run sì wí pé, “Jẹ́ kí omi abẹ́ ọ̀run wọ́ papọ̀ sí ojú kan, kí ilẹ̀ gbígbẹ sì farahàn.” Ó sì rí bẹ́ẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ọlọ́run sì pe ilẹ̀ gbígbẹ náà ní “ilẹ̀,” àti àpapọ̀ omi ní “òkun.” Ọlọ́run sì rí i wí pé ó dára. ");
INSERT INTO yor_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ọlọ́run sì wí pé, “Jẹ́ kí ilẹ̀ kí ó hu ọ̀gbìn: ewéko ti yóò máa mú èso wá àti igi tí yóò máa so èso ní irú tirẹ̀, tí ó ní irúgbìn nínú.” Ó sì rí bẹ́ẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ilẹ̀ sì hù ọ̀gbìn: ewéko tí ó ń so èso ní irú tirẹ̀, àti igi tí ń so èso, tí ó ní irúgbìn nínú ní irú tirẹ̀. Ọlọ́run sì ri pé ó dára. ");
INSERT INTO yor_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Àṣálẹ́ àti òwúrọ̀ sì jẹ́ ọjọ́ kẹta. ");
INSERT INTO yor_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ọlọ́run sì wí pé, “Jẹ́ kí ìmọ́lẹ̀ kí ó wà ní ojú ọ̀run, láti pààlà sí àárín ọ̀sán àti òru, kí wọn ó sì máa wà fún àmì láti mọ àwọn àsìkò, àti àwọn ọjọ́ àti àwọn ọdún. ");
INSERT INTO yor_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Kí wọn ó jẹ́ ìmọ́lẹ̀ ní ojú ọ̀run láti tan ìmọ́lẹ̀ sí orí ilẹ̀.” Ó sì rí bẹ́ẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ọlọ́run dá ìmọ́lẹ̀ ńlá ńlá méjì, ìmọ́lẹ̀ tí ó tóbi láti ṣe àkóso ọ̀sán àti ìmọ́lẹ̀ tí ó kéré láti ṣe àkóso òru. Ó sì dá àwọn ìràwọ̀ pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ọlọ́run sì ṣe wọ́n lọ́jọ̀ sí ojú ọ̀run láti máa tan ìmọ́lẹ̀ si orí ilẹ̀, ");
INSERT INTO yor_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","láti ṣàkóso ọ̀sán àti òru àti láti pààlà sí àárín ìmọ́lẹ̀ àti òkùnkùn. Ọlọ́run sì rí i pé ó dára. ");
INSERT INTO yor_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Àṣálẹ́ àti òwúrọ̀ sì jẹ́ ọjọ́ kẹrin. ");
INSERT INTO yor_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ọlọ́run sì wí pé, “Jẹ́ kí omi kí ó kún fún àwọn ohun alààyè, kí àwọn ẹyẹ kí ó sì máa fò ní òfúrufú.” ");
INSERT INTO yor_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nítorí náà Ọlọ́run dá àwọn ẹ̀dá alààyè ńlá ńlá sí inú òkun, àwọn ohun ẹlẹ́mìí àti àwọn ohun tí ń rìn ní onírúurú tiwọn, àti àwọn ẹyẹ abìyẹ́ ní onírúurú tiwọn. Ọlọ́run sì rí i pé ó dára. ");
INSERT INTO yor_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ọlọ́run súre fún wọn, ó sì wí pé, “Ẹ máa bí sí i, ẹ sì máa pọ̀ sí i, ẹ kún inú omi òkun, kí àwọn ẹyẹ náà sì máa pọ̀ sí i ní orí ilẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Àṣálẹ́ àti òwúrọ̀ sì jẹ́ ọjọ́ karùn-ún. ");
INSERT INTO yor_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ọlọ́run sì wí pé, “Kí ilẹ̀ kí ó mú ohun alààyè jáde ní onírúurú wọn: ẹran ọ̀sìn, àwọn ohun afàyàfà àti àwọn ẹran inú igbó, ọ̀kọ̀ọ̀kan ní irú tirẹ̀.” Ó sì rí bẹ́ẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ọlọ́run sì dá ẹranko inú igbó àti ẹran ọ̀sìn gbogbo ní irú tirẹ̀ àti gbogbo ohun alààyè tí ń rìn ní ilẹ̀ ní irú tirẹ̀. Ọlọ́run sì rí i pé ó dára. ");
INSERT INTO yor_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Lẹ́yìn náà ni Ọlọ́run wí pé, “Ẹ jẹ́ kí a dá ènìyàn ní àwòrán ara wa, gẹ́gẹ́ bí àwa ti rí, kí wọn kí ó jẹ ọba lórí ẹja òkun, ẹyẹ ojú ọ̀run, ẹran ọ̀sìn, gbogbo ilẹ̀ àti lórí ohun gbogbo tí ń rìn lórí ilẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nítorí náà, Ọlọ́run dá ènìyàn ní àwòrán ara rẹ̀, ní àwòrán Ọlọ́run ni ó dá a, akọ àti abo ni ó dá wọn. ");
INSERT INTO yor_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ọlọ́run sì súre fún wọn, Ọlọ́run sì wí fún wọn pé, “Ẹ máa bí sí i, kí ẹ sì máa pọ̀ sí i, kí ẹ sì gbilẹ̀, kí ẹ ṣe ìkápá ayé. Ẹ ṣe àkóso àwọn ẹja inú òkun, ẹyẹ ojú ọ̀run àti gbogbo ẹ̀dá alààyè tí ó ń rìn ní orí ilẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nígbà náà ni Ọlọ́run wí pé, “Mo fi gbogbo ohun ọ̀gbìn tí ń so èso fún un yín bí oúnjẹ àti àwọn igi eléso pẹ̀lú. Gbogbo rẹ̀ yóò jẹ́ oúnjẹ fún un yín. ");
INSERT INTO yor_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Àti fún àwọn ẹranko inú igbó àti ẹyẹ ojú ọ̀run àti àwọn ohun afàyàfà, gbogbo ohun tó ní èémí ìyè nínú ni mo fi ewéko fún bí oúnjẹ.” Ó sì rí bẹ́ẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ọlọ́run sì rí àwọn ohun gbogbo tí ó dá, ó dára gidigidi. Àṣálẹ́ àti òwúrọ̀ sì jẹ́ ọjọ́ kẹfà. ");
INSERT INTO yor_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Báyìí ni Ọlọ́run parí dídá àwọn ọ̀run àti ayé, àti ohun gbogbo tí ó wà nínú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ní ọjọ́ keje Ọlọ́run sì parí iṣẹ́ rẹ̀ tí ó ti ń ṣe; ó sì sinmi ní ọjọ́ keje kúrò nínú iṣẹ́ rẹ̀ gbogbo tí ó ti ń ṣe. ");
INSERT INTO yor_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ọlọ́run sì súre fún ọjọ́ keje, ó sì yà á sí mímọ́, nítorí pé ní ọjọ́ náà ni ó sinmi kúrò nínú iṣẹ́ dídá ayé tí ó ti ń ṣe. ");
INSERT INTO yor_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Èyí ni ìtàn bí Ọlọ́run ṣe dá àwọn ọ̀run àti ayé nígbà tí ó dá wọn. Nígbà tí Olúwa Ọlọ́run dá ayé àti àwọn ọ̀run. ");
INSERT INTO yor_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Kò sí igi igbó kan ní orí ilẹ̀, bẹ́ẹ̀ ni kò sí ewéko igbó kan tí ó tí ì hù jáde ní ilẹ̀, nítorí Olúwa Ọlọ́run kò tí ì rọ̀jò sórí ilẹ̀, kò sì sí ènìyàn láti ro ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ṣùgbọ́n ìsun omi ń jáde láti ilẹ̀, ó sì ń bu omi rin gbogbo ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Olúwa Ọlọ́run sì fi erùpẹ̀ ilẹ̀ mọ ènìyàn, ó si mí èémí ìyè sí ihò imú rẹ̀, ènìyàn sì di alààyè ọkàn. ");
INSERT INTO yor_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Olúwa Ọlọ́run sì gbin ọgbà kan sí Edeni ní ìhà ìlà-oòrùn, níbẹ̀ ni ó fi ọkùnrin náà tí ó ti dá sí. ");
INSERT INTO yor_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Olúwa Ọlọ́run sì mú kí onírúurú igi hù jáde láti inú ilẹ̀, àwọn igi tí ó dùn ún wò lójú, tí ó sì dára fún oúnjẹ. Ní àárín ọgbà náà ni igi ìyè àti igi tí ń mú ènìyàn mọ rere àti búburú wà. ");
INSERT INTO yor_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Odò kan sì ń ti Edeni sàn wá láti bu omi rin ọgbà náà, láti ibẹ̀ ni odò náà gbé ya sí ipa mẹ́rin. ");
INSERT INTO yor_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Orúkọ èkínní ni Pisoni, òun ni ó sàn yí gbogbo ilẹ̀ Hafila ká, níbi tí wúrà gbé wà. ");
INSERT INTO yor_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Wúrà ilẹ̀ náà dára, òjìá àti òkúta óníkìsì oníyebíye wà níbẹ̀ pẹ̀lú). ");
INSERT INTO yor_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Orúkọ odò kejì ni Gihoni, òun ni ó sàn yí gbogbo ilẹ̀ Kuṣi ká. ");
INSERT INTO yor_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Orúkọ odò kẹta ni Tigirisi, òun ni ó sàn ní apá ìlà-oòrùn ilẹ̀ Asiria. Odò kẹrin ni Eufurate. ");
INSERT INTO yor_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Olúwa Ọlọ́run mú ọkùnrin náà sínú ọgbà Edeni láti máa ṣe iṣẹ́ níbẹ̀, kí ó sì máa ṣe ìtọ́jú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Olúwa Ọlọ́run sì pàṣẹ fún ọkùnrin náà pé, “Ìwọ lè jẹ lára èyíkéyìí èso àwọn igi inú ọgbà; ");
INSERT INTO yor_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ṣùgbọ́n ìwọ kò gbọdọ̀ jẹ nínú èso igi ìmọ̀ rere àti èso igi ìmọ̀ búburú, nítorí ní ọjọ́ tí ìwọ bá jẹ ẹ́ ni ìwọ yóò kùú.” ");
INSERT INTO yor_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Olúwa Ọlọ́run wí pé, “Kò dára kí ọkùnrin wà ní òun nìkan. Èmi yóò ṣe olùrànlọ́wọ́ tí ó rí bí i rẹ̀ fún un.” ");
INSERT INTO yor_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Lẹ́yìn tí Olúwa Ọlọ́run ti dá àwọn ẹranko inú igbó àti gbogbo ẹyẹ ojú ọ̀run láti inú erùpẹ̀ ilẹ̀. Ó sì kó wọn tọ ọkùnrin náà wá láti wo orúkọ tí yóò sọ wọ́n; orúkọ tí ó sì sọ gbogbo ẹ̀dá alààyè náà ni wọ́n ń jẹ́. ");
INSERT INTO yor_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Gbogbo ohun ọ̀sìn, ẹyẹ ojú ọ̀run àti gbogbo ẹranko igbó ni ọkùnrin náà sọ ní orúkọ. Ṣùgbọ́n fún Adamu ni a kò rí olùrànlọ́wọ́ tí ó rí bí i rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Nígbà náà ni Olúwa Ọlọ́run mú kí ọkùnrin náà sùn fọnfọn; nígbà tí ó sì ń sùn, Ọlọ́run yọ egungun ìhà rẹ̀ kan, ó sì fi ẹran-ara bò ó padà. ");
INSERT INTO yor_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Olúwa Ọlọ́run sì dá obìnrin láti inú egungun tí ó yọ ní ìhà ọkùnrin náà, Ó sì mu obìnrin náà tọ̀ ọ́ wá. ");
INSERT INTO yor_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ọkùnrin náà sì wí pé, “Èyí ni egungun láti inú egungun mi àti ẹran-ara nínú ẹran-ara mi; ‘obìnrin’ ni a ó máa pè é, nítorí a mú un jáde láti ara ọkùnrin.” ");
INSERT INTO yor_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nítorí ìdí èyí, ọkùnrin yóò fi baba àti ìyá rẹ̀ sílẹ̀, yóò sì dàpọ̀ mọ́ aya rẹ̀, wọn yóò sì di ara kan. ");
INSERT INTO yor_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ọkùnrin náà àti aya rẹ̀ sì wà ní ìhòhò, ojú kò sì tì wọ́n. ");
INSERT INTO yor_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ejò sá à ṣe alárékérekè ju àwọn ẹranko igbó yòókù tí Olúwa Ọlọ́run dá lọ. Ó sọ fún obìnrin náà pé, “Ǹjẹ́ òtítọ́ ha ni Ọlọ́run wí pé, ‘Ẹ̀yin kò gbọdọ̀ jẹ èso èyíkéyìí lára àwọn igi tí ó wà nínú ọgbà’?” ");
INSERT INTO yor_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Obìnrin náà dá ejò lóhùn pé, “Àwa lè jẹ lára àwọn èso igi tí ó wà nínú ọgbà, ");
INSERT INTO yor_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ṣùgbọ́n Ọlọ́run sọ pé, ‘Ẹ̀yin kò gbọdọ̀ jẹ lára èso igi tí ó wà láàrín ọgbà, ẹ kò sì gbọdọ̀ fi ọwọ́ kàn án, bí ẹ̀yin bá ṣe bẹ́ẹ̀, ẹ̀yin yóò kùú.’ ” ");
INSERT INTO yor_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ejò wí fún obìnrin náà pé, “Ẹ̀yin kì yóò kú ikúkíkú kan.” ");
INSERT INTO yor_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“Nítorí Ọlọ́run mọ̀ wí pé, bí ẹ̀yin bá jẹ nínú rẹ̀, ojú yín yóò là, ẹ̀yin yóò sì dàbí Ọlọ́run, ẹ̀yin yóò sì mọ rere yàtọ̀ sí búburú.” ");
INSERT INTO yor_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Nígbà tí obìnrin náà rí i wí pé èso igi náà dára fún oúnjẹ àti pé, ó sì dùn ún wò, àti pé ó ń mú ni ní ọgbọ́n, ó mú díẹ̀ níbẹ̀, ó sì jẹ ẹ́. Ó sì mú díẹ̀ fún ọkọ rẹ̀, ẹni tí ó wà pẹ̀lú rẹ̀, òun náà sì jẹ ẹ́. ");
INSERT INTO yor_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nígbà náà ni ojú àwọn méjèèjì sì là, wọ́n sì mọ̀ pé àwọn wà ní ìhòhò; wọ́n sì rán ewé ọ̀pọ̀tọ́ pọ̀, wọ́n sì fi bo ara wọn. ");
INSERT INTO yor_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Nígbà náà ni ọkùnrin náà àti aya rẹ̀ gbọ́ ìró Olúwa Ọlọ́run bí ó ti ń rìn nínú ọgbà, nígbà tí ojú ọjọ́ tura, wọ́n sì fi ara pamọ́ kúrò níwájú Olúwa Ọlọ́run sí àárín àwọn igi inú ọgbà. ");
INSERT INTO yor_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ṣùgbọ́n Olúwa Ọlọ́run ké pe ọkùnrin náà pé, “Níbo ni ìwọ wà?” ");
INSERT INTO yor_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ó dáhùn pé, “Mo gbúròó rẹ̀ nínú ọgbà, ẹ̀rù sì bà mí, nítorí pé, mo wà ní ìhòhò, mo sì fi ara pamọ́.” ");
INSERT INTO yor_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ọlọ́run wí pé, “Ta ni ó wí fún ọ pé ìhòhò ni ìwọ wà? Ṣé ìwọ ti jẹ nínú èso igi tí mo pàṣẹ fún ọ pé ìwọ kò gbọdọ̀ jẹ nínú rẹ̀ ni?” ");
INSERT INTO yor_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ọkùnrin náà wí pé, “Obìnrin tí ìwọ fi fún mi, ni ó fún mi nínú èso igi náà, mo sì jẹ ẹ́.” ");
INSERT INTO yor_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nígbà náà ni Olúwa Ọlọ́run wí pé, “Èwo ni èyí tí ìwọ ṣe yìí?” Obìnrin náà dáhùn pé, “Ejò ni ó tàn mí jẹ, mo sì jẹ ẹ́.” ");
INSERT INTO yor_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Nígbà náà ni Olúwa Ọlọ́run wí fún ejò náà pé, “Nítorí tí ìwọ ti ṣe èyí, “Ègún ni fún ọ ju gbogbo ohun ọ̀sìn àti gbogbo ẹranko igbó tókù lọ! Àyà rẹ ni ìwọ yóò fi máa wọ́, ìwọ yóò sì máa jẹ erùpẹ̀ ilẹ̀ ní gbogbo ọjọ́ ayé rẹ. ");
INSERT INTO yor_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Èmi yóò sì fi ọ̀tá sí àárín ìwọ àti obìnrin náà, àti sí àárín irú-ọmọ rẹ àti irú-ọmọ obìnrin náà; òun yóò fọ́ orí rẹ, ìwọ yóò sì bù ú jẹ ní gìgísẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ọlọ́run wí fún obìnrin náà pé, “Èmi yóò fi kún ìrora rẹ ní àkókò ìbímọ; ni ìrora ni ìwọ yóò máa bí ọmọ. Ọ̀dọ̀ ọkọ rẹ ni ìfẹ́ rẹ yóò máa fà sí, òun ni yóò sì máa ṣe àkóso rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ọlọ́run sì wí fún Adamu pé, “Nítorí pé ìwọ fetí sí aya rẹ, ìwọ sì jẹ nínú èso igi tí mo pàṣẹ fún ọ pé, ‘Ìwọ kò gbọdọ̀ jẹ nínú rẹ̀,’ “Ègún ni fún ilẹ̀ nítorí rẹ; nínú ọ̀pọ̀ làálàá ni ìwọ yóò jẹ nínú rẹ̀, ní gbogbo ọjọ́ ayé rẹ. ");
INSERT INTO yor_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ilẹ̀ yóò sì hu ẹ̀gún àti èṣùṣú fún ọ, ewéko igbó ni ìwọ yóò sì máa jẹ. ");
INSERT INTO yor_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Nínú òógùn ojú rẹ ni ìwọ yóò máa jẹun títí tí ìwọ yóò fi padà sí ilẹ̀, nítorí inú ilẹ̀ ni a ti mú ọ jáde wá; erùpẹ̀ ilẹ̀ sá à ni ìwọ, ìwọ yóò sì padà di erùpẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu sì sọ aya rẹ̀ ní Efa nítorí òun ni yóò di ìyá gbogbo alààyè. ");
INSERT INTO yor_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Olúwa Ọlọ́run, sì dá ẹ̀wù awọ fún Adamu àti aya rẹ̀, ó sì fi wọ̀ wọ́n. ");
INSERT INTO yor_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Olúwa Ọlọ́run sì wí pé, “Ọkùnrin náà ti dàbí ọ̀kan lára wa, ó mọ rere àti búburú. A kò gbọdọ̀ jẹ́ kí ó na ọwọ́ rẹ̀ kí ó mú lára èso igi ìyè kí ó sì jẹ, kí ó sì wà láààyè títí láéláé.” ");
INSERT INTO yor_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nítorí náà, Olúwa Ọlọ́run lé e kúrò nínú ọgbà Edeni láti lọ máa ro ilẹ̀ nínú èyí tí a ti mú un jáde wá. ");
INSERT INTO yor_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Lẹ́yìn tí ó ti lé ènìyàn jáde tán, ó fi àwọn kérúbù àti idà iná tí ó ń kọ mọ̀nàmọ́ná síwájú àti sẹ́yìn láti ṣọ́ ọ̀nà tí ó lọ sí ibi igi ìyè, ní ìhà ìlà-oòrùn ọgbà Edeni. ");
INSERT INTO yor_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu sì bá aya rẹ̀ Efa lòpọ̀, ó sì lóyún, ó sì bí Kaini. Ó wí pé, “Pẹ̀lú ìrànlọ́wọ́ Olúwa ni mo bí ọmọ ọkùnrin.” ");
INSERT INTO yor_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Lẹ́yìn náà, ó sì bí ọmọkùnrin mìíràn tí a pè ní Abeli. Abeli jẹ́ darandaran, Kaini sì jẹ́ àgbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ó sì ṣe lẹ́yìn ìgbà díẹ̀, Kaini mú ọrẹ wá fún Olúwa nínú èso ilẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ṣùgbọ́n Abeli mú ẹran tí ó sanra wá fún Olúwa nínú àkọ́bí ẹran ọ̀sìn rẹ̀. Olúwa sì fi ojúrere wo Abeli àti ọrẹ rẹ̀, ");
INSERT INTO yor_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ṣùgbọ́n Olúwa kò fi ojúrere wo Kaini àti ẹbọ rẹ̀. Nítorí náà inú bí Kaini gidigidi, ojú rẹ̀ sì fàro. ");
INSERT INTO yor_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Nígbà náà ni Olúwa bi Kaini pé, “Èéṣe tí ìwọ ń bínú? Èéṣe tí ojú rẹ sì fàro? ");
INSERT INTO yor_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Bí ìwọ bá ṣe ohun tí ó tọ́, ṣé ìwọ kò ní jẹ́ ìtẹ́wọ́gbà? Ṣùgbọ́n bí ìwọ kò bá ṣe ohun tí ó tọ́, ẹ̀ṣẹ̀ ń bẹ ní ẹnu-ọ̀nà rẹ, ó fẹ́ ní ọ ní ìní, ṣùgbọ́n ìwọ gbọdọ̀ ṣe àkóso rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kaini wí fún Abeli arákùnrin rẹ̀ pé, “Jẹ́ kí a lọ sí oko.” Ó sì ṣe, bí wọ́n ti wà ní oko; Kaini da ojú ìjà kọ Abeli arákùnrin rẹ̀, ó sì pa á. ");
INSERT INTO yor_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Nígbà náà ni Olúwa béèrè lọ́wọ́ Kaini pé, “Níbo ni Abeli arákùnrin rẹ wà?” Ó sì dáhùn pé, “Èmi kò mọ ibi tí ó wà, èmí ha ń ṣe olùṣọ́ arákùnrin mi bí?” ");
INSERT INTO yor_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Olúwa wí pé, “Kín ni ohun tí ìwọ ṣe yìí? Gbọ́! Ẹ̀jẹ̀ arákùnrin rẹ ń kígbe pè mí láti ilẹ̀ wá. ");
INSERT INTO yor_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Láti ìsinsin yìí lọ, ìwọ ti wà lábẹ́ ègún, a sì ti lé ọ lórí ilẹ̀ tí ó ya ẹnu gba ẹ̀jẹ̀ arákùnrin rẹ lọ́wọ́ rẹ. ");
INSERT INTO yor_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bí ìwọ bá ro ilẹ̀, ilẹ̀ kì yóò fi agbára rẹ̀ so èso rẹ̀ fún ọ mọ́. Ìwọ yóò sì jẹ́ ìsáǹsá àti alárìnkiri ni orí ilẹ̀ ayé.” ");
INSERT INTO yor_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini wí fún Olúwa pé, “Ẹrù ìyà ẹ̀ṣẹ̀ mi pọ̀ ju èyí tí mo le rù lọ. ");
INSERT INTO yor_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lónìí, ìwọ lé mi kúrò lórí ilẹ̀, mó sì di ẹni tí ó fi ara pamọ́ kúrò ní ojú rẹ, èmi yóò sì di ìsáǹsá àti alárìnkiri ní ayé, ẹnikẹ́ni tí ó bá rí mi, yóò sì pa mí.” ");
INSERT INTO yor_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ṣùgbọ́n, Olúwa wí fún pé, “Bẹ́ẹ̀ kọ́, bí ẹnikẹ́ni bá pa Kaini, èmi yóò gbẹ̀san ní ara onítọ̀hún ní ìgbà méje.” Nígbà náà ni Ọlọ́run fi àmì sí ara Kaini, kí ẹnikẹ́ni tí ó bá ri má ba à pa á. ");
INSERT INTO yor_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kaini sì kúrò níwájú Olúwa, ó sì ń gbé ilẹ̀ Nodi ní ìhà ìlà-oòrùn Edeni. ");
INSERT INTO yor_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini sì bá aya rẹ̀ lòpọ̀, ó sì lóyún, ó sì bí Enoku. Kaini sì tẹ ìlú kan dó, ó sì fi orúkọ ọmọ rẹ̀ ọkùnrin Enoku sọ ìlú náà. ");
INSERT INTO yor_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoku sì bí Iradi, Iradi sì ni baba Mehujaeli, Mehujaeli sì bí Metuṣaeli, Metuṣaeli sì ni baba Lameki. ");
INSERT INTO yor_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki sì fẹ́ aya méjì, orúkọ èkínní ni Adah, àti orúkọ èkejì ni Silla. ");
INSERT INTO yor_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah sì bí Jabali, òun ni baba irú àwọn tí ń gbé inú àgọ́, tí wọ́n sì ń sin ẹran ọ̀sìn. ");
INSERT INTO yor_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Orúkọ arákùnrin rẹ̀ ni Jubali, òun ni baba irú àwọn tí ń tẹ dùùrù tí wọ́n sì ń fọn fèrè. ");
INSERT INTO yor_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silla náà sì bí ọmọkùnrin tí ń jẹ́ Tubali-Kaini, tí ó ń rọ oríṣìíríṣìí ohun èlò láti ara idẹ àti irin. Arábìnrin Tubali-Kaini ni Naama. ");
INSERT INTO yor_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki wí fún àwọn aya rẹ̀, “Adah àti Silla, ẹ tẹ́tí sí mi; ẹ̀yin aya Lameki, ẹ gbọ́ ọ̀rọ̀ mi. Mo ti pa ọkùnrin kan tí ó kọlù mí, ọ̀dọ́mọkùnrin tí ó pa mí lára. ");
INSERT INTO yor_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Bí a ó bá gbẹ̀san Kaini ní ìgbà méje, ǹjẹ́ kí a gba ti Lameki nígbà mẹ́tàdínlọ́gọ́rin (77).” ");
INSERT INTO yor_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu sì tún bá aya rẹ̀ lòpọ̀, ó sì bí ọmọkùnrin kan tí ó pe orúkọ rẹ̀ ní Seti, tí ó túmọ̀ sí pé, “Ọlọ́run fún mi ní ọmọkùnrin mìíràn ní ipò Abeli tí Kaini pa.” ");
INSERT INTO yor_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti náà sì bí ọmọkùnrin kan, ó sì pe orúkọ rẹ̀ ní Enoṣi. Láti àkókò náà lọ ni àwọn ènìyàn ti bẹ̀rẹ̀ sí ní ké pe orúkọ Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Èyí ni àkọsílẹ̀ ìran Adamu. Nígbà tí Ọlọ́run dá ènìyàn, ní àwòrán Ọlọ́run ni ó dá a. ");
INSERT INTO yor_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Àti akọ àti abo ni Ó dá wọn, ó sì súre fún wọn, ó sì pe orúkọ wọ́n ní Adamu ní ọjọ́ tí ó dá wọn. ");
INSERT INTO yor_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Nígbà tí Adamu di ẹni àádóje ọdún, ó bí ọmọkùnrin kan tí ó jọ ọ́, tí ó jẹ́ àwòrán ara rẹ̀, ó sì pe orúkọ rẹ̀ ní Seti. ");
INSERT INTO yor_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ọjọ́ Adamu, lẹ́yìn ìgbà tí ó bí Seti, jẹ́ ẹgbẹ̀rin (800) ọdún, ó sì bí àwọn ọmọkùnrin àti ọmọbìnrin. ");
INSERT INTO yor_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Àpapọ̀ ọdún tí Adamu gbé ní orí ilẹ̀ jẹ́ ẹ̀ẹ́dẹ́gbẹ̀rún ọdún ó lé ọgbọ̀n (930), ó sì kú. ");
INSERT INTO yor_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Nígbà tí Seti pé àrùnlélọ́gọ́rùn-ún ọdún, ó bí Enoṣi. ");
INSERT INTO yor_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Lẹ́yìn ìgbà tí ó bí Enoṣi, Seti sì gbé fún ẹgbẹ̀rin ọdún ó lé méje (807), ó sì bí àwọn; ọmọkùnrin àti ọmọbìnrin. ");
INSERT INTO yor_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Àpapọ̀ ọdún Seti sì jẹ́ ẹ̀ẹ́dẹ́gbẹ̀rún ọdún ó lé méjìlá (912), ó sì kú. ");
INSERT INTO yor_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Nígbà tí Enoṣi di ẹni àádọ́rùn-ún ọdún ni ó bí Kenani. ");
INSERT INTO yor_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Lẹ́yìn tí ó bí Kenani, Enoṣi sì wà láààyè fún ẹgbẹ̀rin ọdún ó lé mẹ́ẹ̀ẹ́dógún (815), ó sì bí àwọn ọkùnrin àti obìnrin. ");
INSERT INTO yor_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Àpapọ̀ ọdún Enoṣi jẹ́ ẹ̀ẹ́dẹ́gbẹ̀rún ọdún ó lé márùn-ún (905), ó sì kú. ");
INSERT INTO yor_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Nígbà tí Kenani di àádọ́rin ọdún ni ó bí Mahalaleli. ");
INSERT INTO yor_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Lẹ́yìn tí ó bí Mahalaleli, Kenani wà láààyè fún òjìlélẹ́gbẹ̀rin ọdún (840), ó sì bí àwọn ọmọkùnrin àti ọmọbìnrin. ");
INSERT INTO yor_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Àpapọ̀ ọjọ́ Kenani jẹ́ ẹ̀ẹ́dẹ́gbẹ̀rún ọdún ó lé mẹ́wàá (910), ó sì kú. ");
INSERT INTO yor_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Nígbà tí Mahalaleli pé ọmọ àrùnlélọ́gọ́ta ọdún ni ó bí Jaredi. ");
INSERT INTO yor_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalaleli sì gbé fún ẹgbẹ̀rin ọdún ó lé ọgbọ̀n (830) lẹ́yìn ìgbà tí ó bí Jaredi, ó sì bí àwọn ọmọkùnrin àti ọmọbìnrin. ");
INSERT INTO yor_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Àpapọ̀ iye ọdún Mahalaleli jẹ́ ẹ̀ẹ́dẹ́gbẹ̀rún ọdún ó dín márùn-ún (895), ó sì kú. ");
INSERT INTO yor_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Nígbà tí Jaredi pé ọmọ ọgọ́jọ ọdún ó lé méjì ni ó bí Enoku. ");
INSERT INTO yor_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Lẹ́yìn èyí, Jaredi wà láààyè fún ẹgbẹ̀rin (800) ọdún Enoku sì bí àwọn ọmọkùnrin àti ọmọbìnrin. ");
INSERT INTO yor_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Àpapọ̀ ọdún Jaredi sì jẹ́ ẹgbẹ̀rún dín méjìdínlógójì (962), ó sì kú. ");
INSERT INTO yor_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Nígbà tí Enoku pé ọmọ ọgọ́ta ọdún ó lé márùn ni ó bí Metusela. ");
INSERT INTO yor_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Lẹ́yìn tí ó bí Metusela, Enoku sì bá Ọlọ́run rìn ní ọ̀ọ́dúnrún (300) ọdún, ó sì bí àwọn ọmọkùnrin àti ọmọbìnrin. ");
INSERT INTO yor_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Àpapọ̀ ọjọ́ Enoku sì jẹ́ irinwó ọdún dín márùndínlógójì (365). ");
INSERT INTO yor_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoku bá Ọlọ́run rìn; a kò sì rí i mọ́ nítorí Ọlọ́run mú un lọ. ");
INSERT INTO yor_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Nígbà tí Metusela pé igba ọdún dín mẹ́tàlá ní o bí Lameki. ");
INSERT INTO yor_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lẹ́yìn èyí Metusela wà láààyè fún ẹgbẹ̀rin ọdún dín méjìdínlógún (782), lẹ́yìn ìgbà tí ó bí Lameki, ó sì bí àwọn ọmọkùnrin àti ọmọbìnrin. ");
INSERT INTO yor_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Àpapọ̀ ọdún Metusela jẹ́ ẹgbẹ̀rún ọdún dín mọ́kànlélọ́gbọ̀n (969), ó sì kú. ");
INSERT INTO yor_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Nígbà tí Lameki pé ọdún méjìlélọ́gọ́sàn án ni ó bí ọmọkùnrin kan. ");
INSERT INTO yor_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ó sì pe orúkọ rẹ̀ ní Noa, ó sì wí pé, “Eléyìí ni yóò tù wá nínú ni iṣẹ́ àti làálàá ọwọ́ wa, nítorí ilẹ̀ tí Olúwa ti fi gégùn ún.” ");
INSERT INTO yor_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lẹ́yìn tí ó bí Noa, Lameki gbé fún ẹgbẹ̀ta ọdún dín márùn-ún (595), ó sì bí àwọn ọmọkùnrin àti ọmọbìnrin. ");
INSERT INTO yor_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Àpapọ̀ ọdún Lameki sì jẹ́ ẹgbẹ̀rin ọdún dín mẹ́tàlélógún (777), ó sì kú. ");
INSERT INTO yor_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Lẹ́yìn tí Noa pé ọmọ ẹ̀ẹ́dẹ́gbẹ̀ta (500) ọdún ni ó bí Ṣemu, Hamu àti Jafeti. ");
INSERT INTO yor_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nígbà tí ènìyàn bẹ̀rẹ̀ sí ní pọ̀ si ní orí ilẹ̀, wọ́n sí bí àwọn ọmọbìnrin. ");
INSERT INTO yor_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Àwọn ọmọ Ọlọ́run rí i wí pé àwọn ọmọbìnrin ènìyàn lẹ́wà, wọ́n sì fẹ́ èyíkéyìí tí ó wù wọ́n ṣe aya. ");
INSERT INTO yor_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Nígbà náà ni Olúwa wí pé, “Èémí ìyè tí mo mí sínú ènìyàn kò ní máa gbé inú ènìyàn títí láé, nítorí ẹran-ara sá à ni òun, ọgọ́fà ọdún ni ọjọ́ rẹ̀ yóò jẹ́.” ");
INSERT INTO yor_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Àwọn òmíràn wà láyé ní ọjọ́ wọ̀n-ọn-nì, àti lẹ́yìn ìgbà náà; nígbà tí àwọn ọmọ Ọlọ́run lọ bá àwọn ọmọbìnrin ènìyàn lòpọ̀ tí wọ́n sì bímọ fún wọn. Àwọn náà ni ó di akọni àti olókìkí ìgbà náà. ");
INSERT INTO yor_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Olúwa sì rí bí ìwà búburú ènìyàn ti ń gbilẹ̀ si, àti pé gbogbo èrò inú rẹ̀ kìkì ibi ni, ní ìgbà gbogbo. ");
INSERT INTO yor_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Inú Olúwa sì bàjẹ́ gidigidi nítorí pé ó dá ènìyàn sí ayé, ọkàn rẹ̀ sì gbọgbẹ́. ");
INSERT INTO yor_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nítorí náà, Olúwa wí pé, “Èmi yóò pa ènìyàn tí mo ti dá run kúrò lórí ilẹ̀, ènìyàn àti ẹranko, àti ohun tí ń rákò, àti ẹyẹ ojú ọ̀run, nítorí inú mi bàjẹ́ pé mo ti dá wọn.” ");
INSERT INTO yor_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ṣùgbọ́n, Noa rí ojúrere Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Wọ̀nyí ni ìtàn Noa. Noa nìkan ni ó jẹ́ olóòótọ́ ènìyàn àti ẹni tí ó pé ní ìgbà ayé rẹ̀, ó sì fi òtítọ́ bá Ọlọ́run rìn. ");
INSERT INTO yor_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa sì bí ọmọkùnrin mẹ́ta, Ṣemu, Hamu àti Jafeti. ");
INSERT INTO yor_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ayé sì kún fún ìbàjẹ́ gidigidi ní ojú Ọlọ́run, ó sì kún fún ìwà ipá pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ọlọ́run sì rí bí ayé ti bàjẹ́ tó, nítorí àwọn ènìyàn inú ayé ti bá ara wọn jẹ́ ní gbogbo ọ̀nà wọn. ");
INSERT INTO yor_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ọlọ́run sì wí fún Noa pé, “Èmi yóò pa gbogbo ènìyàn run, nítorí ilẹ̀ ayé kún fún ìwà ipá nípasẹ̀ wọn. Èmi yóò pa wọ́n run àti ayé pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nítorí náà fi igi ọ̀mọ̀ kan ọkọ̀, kí o sì yọ yàrá sí inú rẹ̀, kí o sì fi ọ̀dà ilẹ̀ rẹ́ ẹ tinú-tẹ̀yìn. ");
INSERT INTO yor_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Báyìí ni ìwọ yóò ṣe kan ọkọ̀ náà: Gígùn rẹ̀ ní òró yóò jẹ́ ọ̀ọ́dúnrún (300) ìgbọ̀nwọ́, ìbú rẹ̀ yóò jẹ́ àádọ́ta ìgbọ̀nwọ́, nígbà tí gíga rẹ̀ yóò jẹ́ ọgbọ̀n ìgbọ̀nwọ́. ");
INSERT INTO yor_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ṣe òrùlé sí orí ọkọ̀ náà ní ìgbọ̀nwọ́ kan, sì ṣe ọkọ̀ náà ní alájà mẹ́ta, ipá kan ní ìsàlẹ̀, ọ̀kan ní àárín àti ọ̀kan tí ó kù ní òkè, ẹ̀gbẹ́ ni kí ó ṣe ẹnu-ọ̀nà ọkọ̀ náà sí. ");
INSERT INTO yor_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Èmi yóò mú ìkún omi wá sí ayé láti pa gbogbo ohun ẹlẹ́mìí run lábẹ́ ọ̀run. Gbogbo ẹ̀dá tí ó ní èémí ìyè ní inú. Gbogbo ohun tí ó wà nínú ayé yóò parun. ");
INSERT INTO yor_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ṣùgbọ́n èmi ó dá májẹ̀mú mi pẹ̀lú rẹ, ìwọ yóò sì wọ ọkọ̀, ìwọ àti àwọn ọmọ rẹ pẹ̀lú aya rẹ. ");
INSERT INTO yor_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ìwọ yóò mú gbogbo ohun alààyè takọ tabo wá sí inú ọkọ̀, kí wọn le wà láààyè pẹ̀lú rẹ. ");
INSERT INTO yor_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Mú onírúurú àwọn ẹyẹ, ẹranko àti àwọn ohun tí ń rákò ní méjì méjì, kí a bá lè pa wọ́n mọ́ láààyè. ");
INSERT INTO yor_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Mú onírúurú oúnjẹ wá sínú ọkọ̀, kí o pa wọ́n mọ́ fún jíjẹ gbogbo ẹ̀yin tí ẹ wà nínú ọkọ̀ àti ènìyàn àti ẹranko.” ");
INSERT INTO yor_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa sì ṣe ohun gbogbo bí Ọlọ́run ti pàṣẹ fún un. ");
INSERT INTO yor_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Nígbà náà ni Olúwa wí fún Noa pé, “Wọ inú ọkọ̀ lọ ìwọ àti gbogbo ìdílé rẹ, nítorí ìwọ nìkan ni mo rí bí olódodo nínú ìran yìí. ");
INSERT INTO yor_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Mú méje méje nínú àwọn ẹran tí ó mọ́, akọ àti abo, mú méjì méjì takọ tabo nínú àwọn ẹran aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Sì mú méje méje pẹ̀lú nínú onírúurú ẹyẹ, takọ tabo ni kí o mú wọn, wọlé sínú ọkọ̀ pẹ̀lú rẹ, kí á ba à lè pa wọ́n mọ́ láààyè ní gbogbo ayé. ");
INSERT INTO yor_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Nítorí ní ọjọ́ méje sí ìhín, èmi yóò rọ òjò sórí ilẹ̀ fún ogójì ọ̀sán àti ogójì òru, èmi yóò sì pa gbogbo ohun alààyè tí mo ti dá run kúrò lórí ilẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa sì ṣe ohun gbogbo tí Olúwa pàṣẹ fún un. ");
INSERT INTO yor_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa jẹ́ ọmọ ẹgbẹ̀ta (600) ọdún nígbà tí ìkún omi dé sórí ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa àti ìyàwó rẹ̀ pẹ̀lú àwọn ọmọ rẹ̀ àti àwọn aya ọmọ rẹ̀ sì wọ inú ọkọ láti sá àsálà fún ìkún omi. ");
INSERT INTO yor_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Méjì méjì ni àwọn ẹran tí ó mọ́ àti aláìmọ́, ti ẹyẹ àti ti gbogbo àwọn ẹ̀dá afàyàfà, ");
INSERT INTO yor_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","akọ àti abo ni wọ́n wọlé pẹ̀lú Noa sínú ọkọ̀ bí Ọlọ́run ti pàṣẹ fún Noa. ");
INSERT INTO yor_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Lẹ́yìn ọjọ́ keje, ìkún omi sì dé sí ayé. ");
INSERT INTO yor_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ní ọjọ́ kẹtàdínlógún oṣù kejì, tí Noa pé ọmọ ẹgbẹ̀ta (600) ọdún, ni gbogbo ìsun ibú ya, fèrèsé ìṣàn omi ọ̀run sì ṣí sílẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Òjò àrọ̀ìrọ̀dá sì rọ̀ fún ogójì ọ̀sán àti ogójì òru. ");
INSERT INTO yor_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ní ọjọ́ tí ìkún omi yóò bẹ̀rẹ̀ gan an ni Noa àti Ṣemu, Hamu àti Jafeti pẹ̀lú aya Noa àti aya àwọn ọmọ rẹ̀ wọ inú ọkọ̀. ");
INSERT INTO yor_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Wọ́n mú ẹranko igbó àti ohun ọ̀sìn ní onírúurú wọn, àwọn ẹ̀dá afàyàfà àti ẹyẹ àti àwọn ohun abìyẹ́ ni onírúurú wọn. ");
INSERT INTO yor_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Méjì méjì ni gbogbo ẹ̀dá tí ó ní èémí ìyè nínú wọlé pẹ̀lú Noa sínú ọkọ̀. ");
INSERT INTO yor_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Gbogbo wọ́n wọlé ní takọ tabo bí Ọlọ́run ti pàṣẹ fún Noa, Olúwa sì tì wọn mọ́ inú ọkọ̀. ");
INSERT INTO yor_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Òjò náà sì rọ̀ ní àrọ̀ìrọ̀dá fún ogójì ọ̀sán àti ogójì òru, ọkọ̀ náà sì ń léfòó lórí omi, kúrò lórí ilẹ̀ bí omi náà ti ń pọ̀ sí i. ");
INSERT INTO yor_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Bí omi náà ti ń pọ̀ sí i, bẹ́ẹ̀ náà ni ọkọ̀ náà sì ń léfòó lójú omi. ");
INSERT INTO yor_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Omi náà pọ̀ tó bẹ́ẹ̀ tí ó bo gbogbo àwọn òkè gíga tí ó wà lábẹ́ ọ̀run. ");
INSERT INTO yor_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Omi náà kún bo àwọn òkè, bí ìwọ̀n ìgbọ̀nwọ́ mẹ́ẹ̀ẹ́dógún. ");
INSERT INTO yor_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Gbogbo ohun alààyè tí ó wà lórí ilẹ̀ parun: ẹyẹ, ohun ọ̀sìn, ẹranko igbó, àwọn ẹ̀dá afàyàfà àti ènìyàn. ");
INSERT INTO yor_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Gbogbo ohun tí ó wà lórí ìyàngbẹ ilẹ̀ tó ní èémí ìyè ní ihò imú wọn ni ó kú. ");
INSERT INTO yor_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Gbogbo ohun alààyè tí ó wà lórí ilẹ̀ ayé ni a parẹ́: ènìyàn àti ẹranko, àwọn ohun tí ń rìn nílẹ̀, àwọn ẹyẹ ojú ọ̀run pátápátá ló ṣègbé. Noa àti àwọn tí ó wà pẹ̀lú rẹ̀ nínú ọkọ̀ ni ó ṣẹ́kù. ");
INSERT INTO yor_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Omi náà sì bo ilẹ̀ fún àádọ́jọ ọjọ́. ");
INSERT INTO yor_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ọlọ́run sì rántí Noa àti ohun alààyè gbogbo tí ó wà pẹ̀lú rẹ̀, bí àwọn ẹranko igbó àti ohun ọ̀sìn, ó sì mú kí afẹ́fẹ́ fẹ́ sórí ilẹ̀, omi náà sì fà. ");
INSERT INTO yor_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Gbogbo ìsun ibú àti fèrèsé ìṣàn ọ̀run tì, òjò pẹ̀lú sì dáwọ́ rírọ̀ dúró. ");
INSERT INTO yor_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Omi sì bẹ̀rẹ̀ sí ní gbẹ kúrò lórí ilẹ̀, lẹ́yìn àádọ́jọ ọjọ́, ó sì ti ń fà. ");
INSERT INTO yor_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ní ọjọ́ kẹtàdínlógún oṣù kejì ni ọkọ̀ náà gúnlẹ̀ sórí òkè Ararati. ");
INSERT INTO yor_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Omi náà sì ń gbẹ si títí di oṣù kẹwàá. Ní ọjọ́ kìn-ín-ní oṣù kẹwàá, orí àwọn òkè sì farahàn. ");
INSERT INTO yor_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Lẹ́yìn ogójì ọjọ́, Noa sí fèrèsé tí ó ṣe sára ọkọ̀. ");
INSERT INTO yor_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ó sì rán ẹyẹ ìwò kan jáde, tí ó ń fò káàkiri síwá àti sẹ́yìn títí omi fi gbẹ kúrò ní orí ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ó sì rán àdàbà kan jáde láti wò ó bóyá omi ti gbẹ kúrò lórí ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ṣùgbọ́n àdàbà náà kò rí ìyàngbẹ ilẹ̀ bà lé nítorí omi kò tí ì tan lórí ilẹ̀, ó sì padà sọ́dọ̀ Noa. Noa na ọwọ́ rẹ̀ jáde ó sì mú ẹyẹ náà wọlé sọ́dọ̀ ara rẹ̀ nínú ọkọ̀. ");
INSERT INTO yor_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ó sì dúró fún ọjọ́ méje sí i; ó sì tún rán àdàbà náà jáde láti inú ọkọ̀. ");
INSERT INTO yor_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Nígbà tí àdàbà náà padà sọ́dọ̀ rẹ̀ ní àṣálẹ́, ó já ewé igi olifi tútù há ẹnu! Nígbà náà ni Noa mọ̀ pé omi ti ń gbẹ kúrò lórí ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noa tún mú sùúrù fún ọjọ́ méje, ó sì tún rán àdàbà náà jáde, ṣùgbọ́n àdàbà náà kò padà sọ́dọ̀ rẹ̀ mọ́. ");
INSERT INTO yor_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ní ọjọ́ kìn-ín-ní oṣù kìn-ín-ní, ní ọdún kọ́kànlélẹ́gbẹ̀ta (601) ni omi náà gbẹ kúrò lórí ilẹ̀; Noa sì ṣí ọkọ̀, ó sì ri pé ilẹ̀ ti gbẹ. ");
INSERT INTO yor_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ní ọjọ́ kẹtàdínlọ́gbọ̀n oṣù kejì, ilẹ̀ ti gbẹ pátápátá. ");
INSERT INTO yor_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Nígbà náà ni Ọlọ́run wí fún Noa pé. ");
INSERT INTO yor_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Jáde kúrò nínú ọkọ̀, ìwọ àti aya rẹ, pẹ̀lú àwọn ọmọ rẹ àti àwọn aya wọn. ");
INSERT INTO yor_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kó gbogbo àwọn ẹ̀dá alààyè tí ó wà pẹ̀lú rẹ jáde: àwọn ẹyẹ, ẹranko àti gbogbo àwọn ẹ̀dá tí ń rìn nílẹ̀, kí wọn lè bí sí i, kí wọn sì pọ̀ sí i, kí wọn sì máa gbá yìn lórí ilẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noa, àwọn ọmọ rẹ̀, aya rẹ̀ àti àwọn aya ọmọ rẹ̀ sì jáde. ");
INSERT INTO yor_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Gbogbo àwọn ẹranko àti àwọn ẹ̀dá tí ń rìn nílẹ̀ àti gbogbo ẹyẹ pátápátá ni ó jáde kúrò nínú ọkọ̀, ní ọ̀wọ̀ọ̀wọ́ ní irú tiwọn. ");
INSERT INTO yor_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noa sì mọ pẹpẹ fún Olúwa, ó sì mú lára àwọn ẹran tí ó mọ́ àti ẹyẹ tí ó mọ́, ó sì fi rú ẹbọ sísun lórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Olúwa sì gbọ́ òórùn dídùn; ó sì wí ní ọkàn rẹ̀ pé, “Èmi kì yóò tún fi ilẹ̀ ré nítorí ènìyàn mọ, bí ó tilẹ̀ jẹ́ pé gbogbo èrò inú rẹ̀ jẹ́ ibi láti ìgbà èwe rẹ̀ wá, èmi kì yóò pa gbogbo ohun alààyè run mọ́ láé, bí mo ti ṣe. ");
INSERT INTO yor_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Níwọ́n ìgbà tí ayé bá sì wà, ìgbà ọ̀gbìn àti ìgbà ìkórè ìgbà òtútù àti ìgbà ooru, ìgbà ẹ̀ẹ̀rùn àti ìgbà òjò, ìgbà ọ̀sán àti ìgbà òru, yóò wà títí láé.” ");
INSERT INTO yor_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ọlọ́run sì súre fún Noa àti àwọn ọmọ rẹ̀ wí pé, “Ẹ máa bí sí i, kí ẹ sì pọ̀ ní iye, kí ẹ sì kún ayé. ");
INSERT INTO yor_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ẹ̀rù yín yóò mú ojo wà lára gbogbo ẹranko àti gbogbo ẹyẹ ojú ọ̀run, àti gbogbo àwọn ẹ̀dá tí ń rìn nílẹ̀; àti gbogbo ẹja òkun; a fi wọ́n lé e yín lọ́wọ́. ");
INSERT INTO yor_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Gbogbo ohun tó wà láààyè tí ó sì ń rìn, ni yóò jẹ́ oúnjẹ fún un yín, bí mo ṣe fi ewéko fún un yín náà ni mo fi ohun gbogbo fún un yín. ");
INSERT INTO yor_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Ṣùgbọ́n ẹ̀yin kò gbọdọ̀ jẹ ẹran tòun-tẹ̀jẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Nítòótọ́ ẹ̀jẹ̀ yín, àní ẹ̀mí yín, ni èmi yóò sì béèrè; lọ́wọ́ gbogbo ẹranko ni èmí yóò béèrè rẹ̀, àti lọ́wọ́ ènìyàn, lọ́wọ́ arákùnrin olúkúlùkù ènìyàn ni èmi yóò béèrè ẹ̀mí ènìyàn. ");
INSERT INTO yor_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Ẹnikẹ́ni tí ó bá ta ẹ̀jẹ̀ ènìyàn sílẹ̀, láti ọwọ́ ènìyàn ni a ó gbà ta ẹ̀jẹ̀ rẹ̀ sílẹ̀. Nítorí ní àwòrán Ọlọ́run ni Ọlọ́run dá ènìyàn. ");
INSERT INTO yor_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ṣùgbọ́n ní tiyín, ẹ máa bí sí i, kí ẹ sì máa pọ̀ sí i, ẹ máa gbá yìn lórí ilẹ̀, kí ẹ sì pọ̀ sí i lórí rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ọlọ́run sì wí fún Noa àti àwọn ọmọ rẹ̀ pé, ");
INSERT INTO yor_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Mo dá májẹ̀mú mi pẹ̀lú yín àti pẹ̀lú àwọn ìran yín tí ń bọ̀ lẹ́yìn. ");
INSERT INTO yor_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Àti pẹ̀lú gbogbo ẹ̀dá alààyè tí ó wà pẹ̀lú yín, ìbá à ṣe ẹyẹ, ẹja, ẹran ọ̀sìn, ẹranko igbó, gbogbo ohun tí ó jáde kúrò nínú ọkọ̀ pẹ̀lú yín, àní gbogbo ẹ̀dá alààyè ní ayé. ");
INSERT INTO yor_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mo dá májẹ̀mú mi pẹ̀lú yín láéláé, Èmi kì yóò fi ìkún omi pa ayé run kúrò mọ láéláé, a kì yóò fi omi pa ayé run.” ");
INSERT INTO yor_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ọlọ́run sì wí pé, “Èyí ni àmì májẹ̀mú tí mo ń dá yìí láàrín èmi àti ẹ̀yin àti ẹ̀dá alààyè tí ó wà pẹ̀lú yín, májẹ̀mú àtìrandíran tó ń bọ̀: ");
INSERT INTO yor_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mo ti fi òṣùmàrè sí àwọsánmọ̀, yóò sì jẹ́ àmì májẹ̀mú láàrín èmi àti ayé. ");
INSERT INTO yor_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Nígbàkígbà tí mo bá mú kí òjò ṣú, tí òṣùmàrè bá farahàn ní àwọsánmọ̀. ");
INSERT INTO yor_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Èmi yóò rántí májẹ̀mú mi, tí ó wà láàrín èmi àti ẹ̀yin àti gbogbo ẹ̀dá alààyè, kì yóò sì tún sí ìkún omi mọ́ láti pa gbogbo ẹ̀dá run. ");
INSERT INTO yor_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nígbàkígbà tí òṣùmàrè bá yọ ní àwọsánmọ̀, èmi yóò rí i, èmi yóò sì rántí májẹ̀mú ayérayé tí ń bẹ láàrín Ọlọ́run àti gbogbo ẹ̀dá alààyè tí ń bẹ ní ayé.” ");
INSERT INTO yor_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ọlọ́run sì wí fún Noa pé, “Èyí ni àmì májẹ̀mú tí mo ti fi ìdí rẹ̀ múlẹ̀ láàrín èmi àti gbogbo alààyè ní ayé.” ");
INSERT INTO yor_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Àwọn ọmọ Noa tí ó jáde nínú ọkọ̀ ni Ṣemu, Hamu àti Jafeti. (Hamu ni baba Kenaani.) ");
INSERT INTO yor_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Láti ọ̀dọ̀ àwọn ọmọ Noa mẹ́tẹ̀ẹ̀ta yìí ni gbogbo ènìyàn ti tàn ká gbogbo ilẹ̀ ayé. ");
INSERT INTO yor_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa bẹ̀rẹ̀ iṣẹ́ àgbẹ̀, ó sì gbin ọgbà àjàrà. ");
INSERT INTO yor_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ó mu àmupara nínú ọtí wáìnì àjàrà rẹ̀, ó sì tú ara rẹ̀ sí ìhòhò, ó sì sùn nínú àgọ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu tí í ṣe baba Kenaani sì rí baba rẹ̀ ní ìhòhò bẹ́ẹ̀ ni ó sì lọ sọ fún àwọn arákùnrin rẹ̀ méjèèjì ní ìta. ");
INSERT INTO yor_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ṣùgbọ́n Ṣemu àti Jafeti mú aṣọ lé èjìká wọn, wọ́n sì fi ẹ̀yìn rìn, wọ́n sì bo ìhòhò baba wọn. Wọ́n kọjú sẹ́yìn kí wọn kí ó má ba à rí ìhòhò baba wọn. ");
INSERT INTO yor_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nígbà tí Noa kúrò ní ojú ọtí, tí ó sì mọ ohun tí ọmọ rẹ̀ kékeré ṣe sí i. ");
INSERT INTO yor_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ó wí pé, “Ègún ni fún Kenaani. Ìránṣẹ́ àwọn ìránṣẹ́ ni yóò máa ṣe fún àwọn arákùnrin rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ó sì tún wí pé, “Olùbùkún ni Olúwa, Ọlọ́run Ṣemu Kenaani yóò máa ṣe ẹrú fún Ṣemu. ");
INSERT INTO yor_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ọlọ́run yóò mú Jafeti gbilẹ̀, Jafeti yóò máa gbé ní àgọ́ Ṣemu Kenaani yóò sì jẹ́ ẹrú fún un.” ");
INSERT INTO yor_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noa wà láààyè fún irinwó ọdún dín àádọ́ta (350) lẹ́yìn ìkún omi. ");
INSERT INTO yor_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Àpapọ̀ ọjọ́ ayé Noa jẹ́ ẹgbẹ̀rún ọdún dín làádọ́ta (950), ó sì kú. ");
INSERT INTO yor_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Èyí ni ìran àwọn ọmọ Noa: Ṣemu, Hamu àti Jafeti, tí àwọn náà sì bí ọmọ lẹ́yìn ìkún omi. ");
INSERT INTO yor_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Àwọn ọmọ Jafeti ni: Gomeri, Magogu, Madai, Jafani, Tubali, Meṣeki àti Tirasi. ");
INSERT INTO yor_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Àwọn ọmọ Gomeri ni: Aṣkenasi, Rifati àti Togarma. ");
INSERT INTO yor_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Àwọn ọmọ Jafani ni: Eliṣa, Tarṣiṣi, Kittimu, àti Dodanimu. ");
INSERT INTO yor_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Láti ọ̀dọ̀ àwọn wọ̀nyí ni àwọn tí ń gbé agbègbè tí omi wà ti tàn ká agbègbè wọn, gẹ́gẹ́ bí ẹ̀yà wọn, ìdílé wọn ní orílẹ̀-èdè wọn, olúkúlùkù pẹ̀lú èdè tirẹ̀). ");
INSERT INTO yor_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Àwọn ọmọ Hamu ni: Kuṣi, Ejibiti, Puti àti Kenaani. ");
INSERT INTO yor_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Àwọn ọmọ Kuṣi ni: Seba, Hafila, Sabta, Raama, àti Sabteka. Àwọn ọmọ Raama ni: Ṣeba àti Dedani. ");
INSERT INTO yor_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuṣi sì bí Nimrodu, ẹni tí ó di alágbára jagunjagun ní ayé. ");
INSERT INTO yor_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ó sì jẹ́ ògbójú ọdẹ níwájú Olúwa; nítorí náà ni a ṣe ń wí pé, “Bí Nimrodu, ògbójú ọdẹ níwájú Olúwa.” ");
INSERT INTO yor_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ìjọba rẹ̀ bẹ̀rẹ̀ ni Babeli, Ereki, Akkadi, Kalne, gbogbo wọn wà ní ilẹ̀ Ṣinari. ");
INSERT INTO yor_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Láti ilẹ̀ náà ni ó ti lọ sí Asiria, níbi tí ó ti tẹ ìlú Ninefe, Rehoboti àti Kala, ");
INSERT INTO yor_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","àti Resini, tí ó wà ní àárín Ninefe àti Kala, tí ó jẹ́ ìlú olókìkí. ");
INSERT INTO yor_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ejibiti sì bí Ludimu, Anamimu, Lehabimu, Naftuhimu. ");
INSERT INTO yor_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusimu, Kasluhimu (láti ọ̀dọ̀ ẹni tí àwọn ará Filistini ti wá) àti àwọn ará Kaftorimu. ");
INSERT INTO yor_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenaani sì bí Sidoni àkọ́bí rẹ̀, àti Heti. ");
INSERT INTO yor_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Àti àwọn ará Jebusi, àti àwọn ará Amori, àti àwọn ará Girgaṣi, ");
INSERT INTO yor_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","àti àwọn ará Hifi, àti àwọn ará Arki, àti àwọn ará Sini, ");
INSERT INTO yor_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","àti àwọn ará Arfadi, àti àwọn ará Semari, àti àwọn ará Hamati. Lẹ́yìn èyí ni àwọn ẹ̀yà Kenaani tànkálẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ààlà ilẹ̀ àwọn ará Kenaani sì dé Sidoni, lọ sí Gerari títí dé Gasa, lọ sí Sodomu, Gomorra, Adma àti Seboimu, títí dé Laṣa. ");
INSERT INTO yor_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Àwọn wọ̀nyí ni àwọn ọmọ Hamu, gẹ́gẹ́ bí ẹ̀yà wọn, àti èdè wọn, ní ìpínlẹ̀ wọn àti ní orílẹ̀-èdè wọn. ");
INSERT INTO yor_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","A bí àwọn ọmọ fún Ṣemu tí Jafeti jẹ́ ẹ̀gbọ́n rẹ̀ ọkùnrin: Ṣemu sì ni baba gbogbo àwọn ọmọ Eberi. ");
INSERT INTO yor_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Àwọn ọmọ Ṣemu ni: Elamu, Aṣuri, Arfakṣadi, Ludi àti Aramu. ");
INSERT INTO yor_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Àwọn ọmọ Aramu ni: Usi, Huli, Geteri àti Meṣeki. ");
INSERT INTO yor_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfakṣadi sì bí Ṣela, Ṣela sì bí Eberi. ");
INSERT INTO yor_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi sì bí ọmọ méjì: ọ̀kan ń jẹ́ Pelegi, nítorí ní ìgbà ọjọ́ rẹ̀ ni ilẹ̀ ya; orúkọ arákùnrin rẹ̀ ni Joktani. ");
INSERT INTO yor_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktani sì bí Almodadi, Ṣelefi, Hasarmafeti, Jera. ");
INSERT INTO yor_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoramu, Usali, Dikla, ");
INSERT INTO yor_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimaeli, Ṣeba. ");
INSERT INTO yor_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Hafila àti Jobabu. Gbogbo àwọn wọ̀nyí ni ọmọ Joktani. ");
INSERT INTO yor_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Agbègbè ibi tí wọn ń gbé bẹ̀rẹ̀ láti Meṣa títí dé Sefari, ní àwọn ilẹ̀ tó kún fún òkè ní ìlà-oòrùn. ");
INSERT INTO yor_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Àwọn wọ̀nyí ni àwọn ẹ̀yà ọmọ Ṣemu gẹ́gẹ́ bí ìdílé wọn, ní èdè wọn, ní ilẹ̀ wọn àti ní orílẹ̀-èdè wọn. ");
INSERT INTO yor_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Àwọn wọ̀nyí ni àwọn ẹ̀yà ọmọ Noa gẹ́gẹ́ bí ìran wọn, ní orílẹ̀-èdè wọn. Ní ipasẹ̀ wọn ni àwọn ènìyàn ti tàn ká ilẹ̀ ayé lẹ́yìn ìkún omi. ");
INSERT INTO yor_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Lẹ́yìn náà, gbogbo àgbáyé sì ń sọ èdè kan ṣoṣo. ");
INSERT INTO yor_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Bí àwọn ènìyàn ṣe ń tẹ̀síwájú lọ sí ìhà ìlà-oòrùn, wọ́n rí pẹ̀tẹ́lẹ̀ kan ní ilẹ̀ Ṣinari, wọ́n sì tẹ̀dó síbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wọ́n sì wí fún ara wọn pé, “Ẹ wá, ẹ jẹ́ kí a mọ bíríkì kí a sì sún wọ́n jìnà.” Bíríkì ni wọ́n ń lò ní ipò òkúta, àti ọ̀dà ilẹ̀ tí wọn ń lò láti mú wọn papọ̀ dípò ẹfun (òkúta láìmù tí wọ́n fi ń ṣe símẹ́ńtì àti omi). ");
INSERT INTO yor_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Nígbà náà ni wọ́n wí pé, “Ẹ wá, ẹ jẹ́ kí a tẹ ìlú kan dó fún ara wa, kí a sì kọ́ ilé ìṣọ́ kan tí yóò kan ọ̀run, kí a ba à lè ní orúkọ, kí a má sì tú káàkiri sórí gbogbo ilẹ̀ ayé.” ");
INSERT INTO yor_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ṣùgbọ́n, Olúwa sọ̀kalẹ̀ láti wo ìlú àti ilé ìṣọ́ tí àwọn ènìyàn náà ń kọ́. ");
INSERT INTO yor_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Olúwa wí pé, “Bí àwọn ènìyàn bá ń jẹ́ ọ̀kan àti èdè kan tí wọ́n sì bẹ̀rẹ̀ sí í ṣe iṣẹ́ yìí, kò sí ohun tí wọ́n gbèrò tí wọn kò ní le ṣe yọrí. ");
INSERT INTO yor_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ẹ wá, ẹ jẹ́ kí a sọ̀kalẹ̀ lọ, kí a da èdè wọn rú kí èdè wọn má ba à yé ara wọn mọ́.” ");
INSERT INTO yor_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Olúwa sì tú wọn ká sórí ilẹ̀ gbogbo, wọ́n sì ṣíwọ́ ìlú náà tí wọn ń tẹ̀dó. ");
INSERT INTO yor_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ìdí èyí ni a fi pè é ní Babeli nítorí ní ibẹ̀ ni Olúwa ti da èdè gbogbo ayé rú. Olúwa tí sì tú àwọn ènìyàn ká sí gbogbo orí ilẹ̀ ayé. ");
INSERT INTO yor_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Wọ̀nyí ni ìran Ṣemu. Ọdún méjì lẹ́yìn ìkún omi, tí Ṣemu pé ọgọ́rùn-ún ọdún ni ó bí Arfakṣadi. ");
INSERT INTO yor_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Lẹ́yìn tí ó bí Arfakṣadi, Ṣemu tún wà láààyè fún ẹ̀ẹ́dẹ́gbẹ̀ta ọdún (500), ó sì bí àwọn ọmọkùnrin àti àwọn ọmọbìnrin mìíràn. ");
INSERT INTO yor_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Nígbà tí Arfakṣadi pé ọdún márùndínlógójì ni ó bí Ṣela. ");
INSERT INTO yor_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfakṣadi sì wà láààyè fún ọdún mẹ́tàlénírinwó (403) lẹ́yìn tí ó bí Ṣela, ó sì bí àwọn ọmọbìnrin àti àwọn ọmọkùnrin mìíràn. ");
INSERT INTO yor_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Nígbà tí Ṣela pé ọmọ ọgbọ̀n ọdún ni ó bí Eberi. ");
INSERT INTO yor_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ṣela sì wà láààyè fún ọdún mẹ́tàlénírinwó (403) lẹ́yìn tí ó bí Eberi tán, ó sì bí àwọn ọmọkùnrin àti àwọn ọmọbìnrin mìíràn. ");
INSERT INTO yor_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberi sì jẹ́ ọmọ ọdún mẹ́rìnlélọ́gbọ̀n, ó sì bí Pelegi. ");
INSERT INTO yor_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eberi sì wà láààyè fún irinwó ọdún ó lé ọgbọ̀n (430) lẹ́yìn tí ó bí Pelegi, ó sì bí àwọn ọmọkùnrin àti àwọn ọmọbìnrin mìíràn. ");
INSERT INTO yor_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Nígbà tí Pelegi pé ọmọ ọgbọ̀n ọdún ni ó bí Reu. ");
INSERT INTO yor_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pelegi sì tún wà láààyè fún igba ọdún ó lé mẹ́sàn-án (209) lẹ́yìn tí ó bí Reu, ó sì bí àwọn ọmọkùnrin àti àwọn ọmọbìnrin mìíràn. ");
INSERT INTO yor_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Nígbà tí Reu pé ọdún méjìlélọ́gbọ̀n ni ó bí Serugu. ");
INSERT INTO yor_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu tún wà láààyè lẹ́yìn tí ó bí Serugu fún igba ọdún ó lé méje (207), ó sì bí àwọn ọmọkùnrin àti ọmọbìnrin mìíràn. ");
INSERT INTO yor_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Nígbà tí Serugu pé ọmọ ọgbọ̀n ọdún ni ó bí Nahori. ");
INSERT INTO yor_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serugu sì wà láààyè fún igba ọdún lẹ́yìn tí ó bí Nahori, ó sì bí àwọn ọmọkùnrin àti àwọn ọmọbìnrin mìíràn. ");
INSERT INTO yor_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nígbà tí Nahori pé ọmọ ọdún mọ́kàndínlọ́gbọ̀n, ó bí Tẹra. ");
INSERT INTO yor_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahori sì wà láààyè fún ọdún mọ́kàn dín lọ́gọ́fà lẹ́yìn ìbí Tẹra, ó sì bí àwọn ọmọkùnrin àti àwọn ọmọbìnrin mìíràn. ");
INSERT INTO yor_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Lẹ́yìn tí Tẹra pé ọmọ àádọ́rin ọdún ó bí Abramu, Nahori àti Harani. ");
INSERT INTO yor_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Wọ̀nyí ni ìran Tẹra. Tẹra ni baba Abramu, Nahori àti Harani. Harani sì bí Lọti. ");
INSERT INTO yor_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harani sì kú ṣáájú Tẹra baba rẹ̀ ní ilẹ̀ ìbí rẹ̀ ní Uri ti ilẹ̀ Kaldea. ");
INSERT INTO yor_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramu àti Nahori sì gbéyàwó. Orúkọ aya Abramu ni Sarai, nígbà tí aya Nahori ń jẹ́ Milka, tí ṣe ọmọ Harani. Harani ni ó bí Milka àti Iska. ");
INSERT INTO yor_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai sì yàgàn, kò sì bímọ. ");
INSERT INTO yor_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tẹra sì mú ọmọ rẹ̀ Abramu àti Lọti ọmọ Harani, ọmọ ọmọ rẹ̀, ó sì mú Sarai tí i ṣe aya ọmọ rẹ̀. Abramu pẹ̀lú gbogbo wọn sì jáde kúrò ní Uri ti Kaldea láti lọ sí ilẹ̀ Kenaani. Ṣùgbọ́n nígbà tí wọn dé Harani wọ́n tẹ̀dó síbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Nígbà tí Tẹra pé ọmọ igba ọdún ó lé márùn-ún (205) ni ó kú ní Harani. ");
INSERT INTO yor_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Olúwa sì wí fún Abramu, “Jáde kúrò ní orílẹ̀-èdè rẹ àti kúrò lọ́dọ̀ àwọn ènìyàn rẹ, lọ sí ilẹ̀ kan tí èmi yóò fihàn ọ́. ");
INSERT INTO yor_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Èmi yóò sọ ọ́ di orílẹ̀-èdè ńlá, èmi yóò sì bùkún fún ọ; èmi yóò sọ orúkọ rẹ di ńlá, ìbùkún ni ìwọ yóò sì jásí. ");
INSERT INTO yor_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Èmi yóò bùkún fún àwọn tí ó súre fún ọ, ẹni tí ó fi ọ́ ré ni Èmi yóò fi ré; nínú rẹ ni a ó bùkún gbogbo ìdílé ayé.” ");
INSERT INTO yor_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Bẹ́ẹ̀ ni Abramu lọ bí Olúwa ti sọ fún un. Lọti náà sì bá a lọ. Abramu jẹ́ ẹni àrùndínlọ́gọ́rin ọdún nígbà tí ó jáde kúrò ní Harani. ");
INSERT INTO yor_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abramu sì mú Sarai aya rẹ̀, àti Lọti ọmọ arákùnrin rẹ̀: gbogbo ohun ìní tí wọ́n ti kójọ àti àwọn ènìyàn tí wọ́n ní ní Harani. Wọ́n sì jáde lọ sí ilẹ̀ Kenaani. Wọ́n sì gúnlẹ̀ síbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abramu sì rìn la ilẹ̀ náà já títí dé ibi igi ńlá kan tí à ń pè ni More ní Ṣekemu. Àwọn ará Kenaani sì wà ní ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Olúwa sì farahan Abramu, ó sì wí fún un pé, “Irú-ọmọ rẹ ni Èmi yóò fi ilẹ̀ yìí fún.” Abramu tẹ́ pẹpẹ kan síbẹ̀ fún Olúwa tí ó fi ara hàn án. ");
INSERT INTO yor_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ó sì kúrò níbẹ̀ lọ sí agbègbè àwọn òkè kan ní ìhà ìlà-oòrùn Beteli, ó sì pàgọ́ rẹ̀ síbẹ̀. Beteli wà ní ìwọ̀-oòrùn, Ai wà ní ìlà-oòrùn. Ó tẹ́ pẹpẹ kan níbẹ̀ fún Olúwa, ó sì ké pe orúkọ Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Nígbà náà ni Abramu tẹ̀síwájú sí ìhà gúúsù. ");
INSERT INTO yor_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ìyàn kan sì mú ní ilẹ̀ náà, Abramu sì sọ̀kalẹ̀ lọ sí Ejibiti láti ṣe àtìpó níbẹ̀ fún ìgbà díẹ̀, nítorí ìyàn náà mú gidigidi. ");
INSERT INTO yor_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Bí ó ti ku díẹ̀ kí ó wọ Ejibiti, ó wí fún Sarai, aya rẹ̀ pé, “Mo mọ̀ pé arẹwà obìnrin ni ìwọ, ");
INSERT INTO yor_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","nígbà tí àwọn ará Ejibiti bá rí ọ, wọn yóò wí pé, ‘Aya rẹ̀ nìyí.’ Wọn yóò si pa mí, ṣùgbọ́n wọn yóò dá ọ sí. ");
INSERT INTO yor_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nítorí náà, sọ pé, arábìnrin mi ni ìwọ, wọn yóò sì ṣe mí dáradára, a ó sì dá ẹ̀mí mi sí nítorí tìrẹ.” ");
INSERT INTO yor_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Nígbà tí Abramu dé Ejibiti, àwọn ará Ejibiti ri i pé aya rẹ̀ rẹwà gidigidi. ");
INSERT INTO yor_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Nígbà tí àwọn ìjòyè Farao sì rí i, wọ́n ròyìn rẹ̀ níwájú Farao, wọ́n sì mú un lọ sí ààfin. ");
INSERT INTO yor_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ó sì kẹ́ Abramu dáradára nítorí Sarai, Abramu sì ní àgùntàn àti màlúù, akọ àti abo kẹ́tẹ́kẹ́tẹ́, ìránṣẹ́kùnrin àti ìránṣẹ́bìnrin, pẹ̀lú ìbákasẹ. ");
INSERT INTO yor_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Olúwa sì rán àjàkálẹ̀-ààrùn búburú sí Farao àti ilé rẹ̀, nítorí Sarai aya Abramu. ");
INSERT INTO yor_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Nítorí náà Farao ránṣẹ́ pe Abramu, ó sì wí fun pé, “Èwo ni ìwọ ṣe sí mi yìí? Kí ló dé tí ìwọ kò sọ fún mi pé aya rẹ ní í ṣe? ");
INSERT INTO yor_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Èéṣe tí o fi wí pé, ‘Arábìnrin mi ni,’ tí èmi sì fi fẹ́ ẹ gẹ́gẹ́ bí aya? Nítorí náà nísinsin yìí, aya rẹ náà nìyí, mú un kí o sì máa lọ.” ");
INSERT INTO yor_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Nígbà náà ni Farao pàṣẹ fún àwọn ìránṣẹ́ rẹ̀ nípa Abramu, wọ́n sì lé e jáde ti òun ti aya rẹ̀ àti ohun gbogbo tí ó ní. ");
INSERT INTO yor_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramu sì gòkè láti Ejibiti lọ sí ìhà gúúsù, pẹ̀lú aya rẹ̀ àti ohun gbogbo tí ó ní àti Lọti pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramu sì ti di ọlọ́rọ̀ gidigidi; ní ẹran ọ̀sìn, ó ní fàdákà àti wúrà. ");
INSERT INTO yor_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Láti gúúsù, ó ń lọ láti ibìkan sí ibòmíràn títí ó fi dé ilẹ̀ Beteli, ní ibi tí àgọ́ rẹ̀ ti wà ní ìṣáájú rí, lágbedeméjì Beteli àti Ai. ");
INSERT INTO yor_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ní ibi pẹpẹ tí ó ti tẹ́ síbẹ̀ ní ìṣáájú, níbẹ̀ ni Abramu sì ń ké pe orúkọ Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Àti Lọti pẹ̀lú, tí ó ń bá Abramu rìn kiri, ní agbo ẹran, ọ̀wọ́ ẹran àti àgọ́. ");
INSERT INTO yor_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ṣùgbọ́n ilẹ̀ náà kò le gbà wọ́n tí wọ́n bá ń gbé pọ̀, nítorí, ohun ìní wọn pọ̀ tó bẹ́ẹ̀ gẹ́ẹ́, dé bi wí pé wọn kò le è gbé pọ̀. ");
INSERT INTO yor_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Èdè-àìyedè sì bẹ̀rẹ̀ láàrín àwọn darandaran Abramu àti ti Lọti. Àwọn ará Kenaani àti àwọn ará Peresi sì ń gbé ní ilẹ̀ náà nígbà náà. ");
INSERT INTO yor_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abramu sì wí fún Lọti pé, “Èmi bẹ̀ ọ́, má ṣe jẹ́ kí èdè-àìyedè kí ó wà láàrín èmi àti ìrẹ, àti láàrín àwọn darandaran wa, nítorí pé ẹbí kan ni àwa ṣe. ");
INSERT INTO yor_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Gbogbo ilẹ̀ ha kọ́ nìyí níwájú rẹ? Jẹ́ kí a pínyà. Bí ìwọ bá lọ sí apá ọ̀tún, èmi yóò lọ sí apá òsì, bí ó sì ṣe òsì ni ìwọ lọ, èmi yóò lọ sí apá ọ̀tún.” ");
INSERT INTO yor_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lọti sì gbójú sókè, ó sì ri wí pé gbogbo pẹ̀tẹ́lẹ̀ Jordani ni omi rin dáradára bí ọgbà Olúwa, bí ilẹ̀ Ejibiti, ní ọ̀nà Soari. (Èyí ní ìṣáájú kí Olúwa tó pa Sodomu àti Gomorra run.) ");
INSERT INTO yor_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Nítorí náà Lọti yan gbogbo pẹ̀tẹ́lẹ̀ Jordani yìí fún ara rẹ̀, ó sì ń lọ sí ọ̀nà ìlà-oòrùn. Òun àti Abramu sì pínyà. ");
INSERT INTO yor_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramu ń gbé ni ilẹ̀ Kenaani, Lọti sì jókòó ní ìlú agbègbè àfonífojì náà, ó sì pàgọ́ rẹ̀ títí dé Sodomu. ");
INSERT INTO yor_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ṣùgbọ́n àwọn ọkùnrin Sodomu jẹ́ ènìyàn búburú, wọn sì ń dẹ́ṣẹ̀ gidigidi ni iwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Olúwa sì wí fún Abramu lẹ́yìn ìpinyà òun àti Lọti pé, “Gbé ojú rẹ sókè nísinsin yìí, kí o sì wò láti ibi tí o gbé wà a nì lọ sí ìhà àríwá àti sí ìhà gúúsù, sí ìlà-oòrùn àti sí ìwọ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Gbogbo ilẹ̀ tí ìwọ ń wò o nì ni èmi ó fi fún ọ àti irú-ọmọ rẹ láéláé. ");
INSERT INTO yor_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Èmi yóò mú kí irú-ọmọ rẹ kí ó pọ̀ bí erùpẹ̀ ilẹ̀, tó bẹ́ẹ̀ tí ó bá ṣe pé ẹnikẹ́ni bá le è ka erùpẹ̀ ilẹ̀, nígbà náà ni yóò tó lè ka irú-ọmọ rẹ. ");
INSERT INTO yor_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Dìde, rìn òró àti ìbú ilẹ̀ náà já, nítorí ìwọ ni Èmi yóò fi fún.” ");
INSERT INTO yor_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Nígbà náà ni Abramu kó àgọ́ rẹ̀, ó sì wá, ó sì jókòó ní ẹ̀gbẹ́ igi ńlá igbó Mamre, tí ó wà ní Hebroni. Níbẹ̀ ni ó gbé tẹ́ pẹpẹ kan sí fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ní àsìkò yìí ni Amrafeli ọba Ṣinari, Arioku ọba Ellasari, Kedorlaomeri ọba Elamu àti Tidali ọba Goyimu ");
INSERT INTO yor_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","jáde lọ láti bá Bera ọba Sodomu, Birṣa ọba Gomorra, Ṣenabu ọba Adma, Ṣemeberi ọba Seboimu àti ọba Bela (èyí ni Soari) jagun. ");
INSERT INTO yor_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Gbogbo àwọn ọba wọ̀nyí ni ó kó ogun wọn jọ pọ̀ sí àfonífojì Siddimu (ti o túmọ̀ sí Òkun Iyọ̀). ");
INSERT INTO yor_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Fún ọdún méjìlá gbáko ni wọ́n ti ń sin Kedorlaomeri bí ẹrú. Ṣùgbọ́n nígbà tí ó di ọdún kẹtàlá wọ́n ṣọ̀tẹ̀ sí i. ");
INSERT INTO yor_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ní ọdún kẹrìnlá, ni Kedorlaomeri àti àwọn ọba tí wọ́n ti jọ ni májẹ̀mú àṣepọ̀ wá, wọ́n ṣígun, wọ́n sì ṣẹ́gun ará Refaimu ní Aṣteroti-Karnaimu, àwọn ará Susimu ni Hamu, àwọn ará Emimu ní pẹ̀tẹ́lẹ̀ Kiriataimu, ");
INSERT INTO yor_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","àti àwọn ará Hori ní orí òkè wọ̀n-ọn-nì Seiri, títí ó fi dé Eli-Parani ní etí ijù. ");
INSERT INTO yor_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Wọ́n sì tún yípadà lọ sí En-Miṣpati (ti o túmọ̀ sí Kadeṣi), wọ́n sì ṣẹ́gun gbogbo ilẹ̀ àwọn Amaleki, àti àwọn ará Amori tí ó tẹ̀dó sí Hasason Tamari pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Nígbà náà ni ọba Sodomu, ọba Gomorra, ọba Adma, ọba Seboimu àti ọba Bela (èyí ni Soari), kó àwọn ọmọ-ogun wọn, wọ́n sì pa ibùdó ogun wọn sí Àfonífojì Siddimu, ");
INSERT INTO yor_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","láti kojú ìjà sí Kedorlaomeri ọba Elamu, Tidali ọba Goyimu, Amrafeli ọba Ṣinari àti Arioku ọba Ellasari (ọba mẹ́rin kọjú ìjà sí ọba márùn-ún). ");
INSERT INTO yor_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Àfonífojì Siddimu sì kún fún kòtò ọ̀dà ilẹ̀, nígbà tí ọba Sodomu àti ọba Gomorra sì sá, díẹ̀ nínú àwọn ọkùnrin ogun náà ṣubú sínú àwọn kòtò náà, àwọn tókù sì sálọ sì orí òkè. ");
INSERT INTO yor_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Àwọn ọba mẹ́rẹ̀ẹ̀rin náà sì kó gbogbo ẹrù Sodomu àti Gomorra àti oúnjẹ wọn; wọ́n sì lọ. ");
INSERT INTO yor_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Wọ́n sì mú Lọti ọmọ arákùnrin Abramu tí ń gbé ní Sodomu àti gbogbo ohun ìní rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ẹnìkan tí ó sá àsálà sì wá ròyìn fún Abramu, ará Heberu ni. Abramu sá ti tẹ̀dó sí ẹ̀gbẹ́ igi ńlá igbó Mamre ará Amori, arákùnrin Eṣkolu àti Aneri: àwọn ẹni tí ó ń bá Abramu ní àṣepọ̀. ");
INSERT INTO yor_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Nígbà tí Abramu gbọ́ wí pé, a di Lọti ní ìgbèkùn, ó kó àwọn ọmọ ọ̀dọ̀ rẹ̀ tí a bí sí ilẹ̀ rẹ̀ tí ó sì ti kọ́ ni ogun jíjà jáde, wọ́n jẹ́ okòó lé lọ́ọ̀dúnrún ó dín méjì (318) ènìyàn, ó sì lépa wọn títí dé Dani. ");
INSERT INTO yor_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ní ọ̀gànjọ́ òru, Abramu pín àwọn ọmọ-ogun rẹ̀ sí méjì, ó sì kọlù wọ́n, ó sì ṣẹ́gun wọn, ó sì lé wọn títí dé Hoba tí ó wà ní apá òsì Damasku. ");
INSERT INTO yor_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Gbogbo ìkógun ni ó rí gbà padà àti ọmọ arákùnrin rẹ̀, Lọti pẹ̀lú ohun ìní rẹ̀, àti àwọn obìnrin pẹ̀lú àwọn ènìyàn tókù. ");
INSERT INTO yor_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Nígbà tí Abramu ti ṣẹ́gun Kedorlaomeri àti àwọn ọba tí ó pẹ̀lú rẹ̀, ọba Sodomu lọ pàdé rẹ̀ ní àfonífojì Ṣafe (èyí ni àfonífojì Ọba). ");
INSERT INTO yor_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedeki ọba Salẹmu sì mú oúnjẹ àti ọtí wáìnì jáde wá. Òun ni àlùfáà Ọlọ́run Ọ̀gá-ògo. ");
INSERT INTO yor_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ó sì súre fún Abramu, wí pé, “Ìbùkún ni fún Abramu ti Ọlọ́run Ọ̀gá-ògo, Ẹni tí ó dá ọ̀run òun ayé. ");
INSERT INTO yor_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ìbùkún sì ni fún Ọlọ́run Ọ̀gá-ògo jùlọ, tí ó fi àwọn ọ̀tá rẹ lé ọ lọ́wọ́.” Abramu sì fún un ní ìdámẹ́wàá ohun gbogbo. ");
INSERT INTO yor_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ọba Sodomu sì wí fún Abramu pé, “Kó àwọn ènìyàn mi fún mi, ṣùgbọ́n mú àwọn ẹrù fún ara rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ṣùgbọ́n Abramu dá ọba Sodomu lóhùn pé, “Mo ti búra fún Olúwa, Ọlọ́run Ọ̀gá-ògo, tí ó dá ọ̀run àti ayé, mo sì ti gbọ́wọ́ sókè, ");
INSERT INTO yor_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","pé, èmi kì yóò mú láti fọ́nrán òwú títí dé okùn bàtà, àti pé, èmi kí yóò mú ohun kan tí ṣe tìrẹ, kí ìwọ kí ó má ba à wí pé, ‘Mo sọ Abramu di ọlọ́rọ̀.’ ");
INSERT INTO yor_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Èmi kì yóò gba ohunkóhun yàtọ̀ sí ohun tí àwọn ọkùnrin mi ti jẹ́, ṣùgbọ́n fi ìpín fún àwọn ọkùnrin tí ó bá mi lọ, Aneri, Eṣkolu àti Mamre. Jẹ́ kí wọn kí ó gba ìpín wọn.” ");
INSERT INTO yor_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Lẹ́yìn èyí, ọ̀rọ̀ Olúwa tọ Abramu wá lójú ìran pé, “Abramu má ṣe bẹ̀rù. Èmi ni ààbò rẹ, Èmi sì ni èrè ńlá rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ṣùgbọ́n Abramu wí pé, “Olúwa Olódùmarè, kí ni ìwọ yóò fi fún mi níwọ̀n ìgbà tí èmi kò bímọ, Elieseri ará Damasku ni yóò sì jogún mi,” ");
INSERT INTO yor_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abramu sì tún tẹ̀síwájú pé, “Ìwọ kò fún mi ní ọmọ, nítorí náà ẹrú nínú ilé mi sì ni yóò jẹ́ àrólé mi.” ");
INSERT INTO yor_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ọ̀rọ̀ Olúwa sì tún tọ̀ ọ́ wá pé, “Ọkùnrin yìí kọ́ ni yóò jẹ́ àrólé rẹ bí kò ṣe ọmọ tí ìwọ bí fúnra rẹ̀ ni yóò jẹ́ àrólé rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Olúwa sì mú Abramu jáde sí ìta ó sì wí fún un pé, “Gbé ojú sókè sí ọ̀run kí o sì ka àwọn ìràwọ̀ bí ó bá ṣe pé ìwọ le è kà wọ́n.” Ó sì wí fun un pé, “Nítorí náà, báyìí ni irú-ọmọ rẹ yóò rí.” ");
INSERT INTO yor_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abramu gba Olúwa gbọ́, a sì kà á sí òdodo fún un. ");
INSERT INTO yor_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ó sì tún wí fún un pé, “Èmi ni Olúwa tí ó mú ọ jáde láti Uri ti Kaldea láti fún ọ ní ilẹ̀ yìí láti jogún.” ");
INSERT INTO yor_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ṣùgbọ́n Abramu wí pé, “Olúwa Olódùmarè, báwo ni mo ṣe lè mọ̀ pé ilẹ̀ náà yóò jẹ́ ohun ìní mi?” ");
INSERT INTO yor_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Nítorí náà, Olúwa wí fún un pé, “Mú abo màlúù, ewúrẹ́ àti àgbò ọlọ́dún mẹ́ta mẹ́ta wá, àti àdàbà kan àti ọmọ ẹyẹlé kan.” ");
INSERT INTO yor_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abramu sì mú gbogbo nǹkan wọ̀nyí wá, ó sì là wọ́n sí méjì méjì, ó sì fi ẹ̀là èkínní kọjú sí èkejì, ṣùgbọ́n kò la àwọn ẹyẹ ní tiwọn. ");
INSERT INTO yor_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Àwọn ẹyẹ igún sì ń wá sórí òkú ẹran náà, Abramu sì ń lé wọn. ");
INSERT INTO yor_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Bí oòrùn ti ń wọ̀, Abramu sùn lọ fọnfọn, òkùnkùn biribiri tí ó kún fún ẹ̀rù sì bò ó. ");
INSERT INTO yor_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Nígbà náà ni Olúwa wí fún Abramu pé, “Mọ èyí dájú pé, irú-ọmọ rẹ yóò ṣe àtìpó ní ilẹ̀ àjèjì, wọn ó sì sọ wọn di ẹrú, wọn ó sì pọ́n wọn lójú fún irinwó (400) ọdún. ");
INSERT INTO yor_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ṣùgbọ́n orílẹ̀-èdè náà tí wọn yóò máa sìn, ni èmi ó dá lẹ́jọ́, lẹ́yìn náà ni wọn ó sì jáde pẹ̀lú ọrọ̀ púpọ̀. ");
INSERT INTO yor_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ṣùgbọ́n ìwọ yóò tọ àwọn baba rẹ lọ ni àlàáfíà, bẹ́ẹ̀ ni ìwọ yóò sì di arúgbó kí a tó gbé ọ sin. ");
INSERT INTO yor_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ní ìran kẹrin àwọn ìran rẹ yóò padà wá sí ibi. Nítorí ẹ̀ṣẹ̀ àwọn ará Amori kò ì tí ì kún òsùwọ̀n.” ");
INSERT INTO yor_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Nígbà tí oòrùn wọ̀ tí ilẹ̀ sì ṣú, ìkòkò iná tí ń ṣèéfín àti ọwọ́ iná sì ń kọjá láàrín ẹ̀là ẹran náà. ");
INSERT INTO yor_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ní ọjọ́ náà gan an ni Olúwa dá májẹ̀mú pẹ̀lú Abramu, ó sì wí pé, “Àwọn ìran rẹ ni èmi yóò fi ilẹ̀ yìí fún, láti odò Ejibiti dé odò ńlá Eufurate: ");
INSERT INTO yor_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ilẹ̀ àwọn ará Keni, àti ti ará Kenissiti, àti ará Kadmoni, ");
INSERT INTO yor_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","àti ti ará Hiti, àti ti ará Peresi, àti ti ará Refaimu. ");
INSERT INTO yor_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Àti ti ará Amori, àti ti ará Kenaani, àti ti ará Girgaṣi àti ti ará Jebusi.” ");
INSERT INTO yor_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, aya Abramu kò bímọ fún un, ṣùgbọ́n ó ní ọmọ ọ̀dọ̀ obìnrin ará Ejibiti kan tí ń jẹ́ Hagari. ");
INSERT INTO yor_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Nítorí náà, Sarai wí fún Abramu pé, “Kíyèsi i Olúwa ti sé mi ní inú, èmi kò sì bímọ, wọlé tọ ọmọ ọ̀dọ̀ mi lọ, bóyá èmi yóò le ti ipasẹ̀ rẹ̀ ní ọmọ.” Abramu sì gba ohun tí Sarai sọ. ");
INSERT INTO yor_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Lẹ́yìn ọdún mẹ́wàá tí Abramu ti ń gbé ni Kenaani ni Sarai mú ọmọbìnrin, ọmọ ọ̀dọ̀ rẹ Hagari, tí í ṣe ará Ejibiti fún Abramu ọkọ rẹ̀ láti fi ṣe aya. ");
INSERT INTO yor_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abramu sì bá Hagari lòpọ̀, ó sì lóyún. Nígbà tí ó sì ti mọ̀ pé òun lóyún, ó bẹ̀rẹ̀ sì ní kẹ́gàn ọ̀gá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Nígbà náà ni Sarai wí fún Abramu pé, “Ìwọ ni ó jẹ́ kí ẹ̀gbin yìí máa jẹ mí, mo fa ọmọ ọ̀dọ̀ mi lé ọ lọ́wọ́, nígbà tí ó sì rí i pé òun lóyún, mo di ẹni ẹ̀gàn ní ojú rẹ̀. Kí Olúwa kí ó ṣe ìdájọ́ láàrín tèmi tìrẹ.” ");
INSERT INTO yor_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abramu dáhùn pé, “Ìwọ ló ni ọmọ ọ̀dọ̀ rẹ, ṣe ohunkóhun tí ó bá tọ́ ní ojú rẹ sí i.” Nígbà náà ni Sarai fi ìyà jẹ Hagari, ó sì sálọ. ");
INSERT INTO yor_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Angẹli Olúwa sì rí Hagari ní ẹ̀gbẹ́ ìsun omi ní ijù, ìsun omi tí ó wà ní ẹ̀gbẹ́ ọ̀nà tí ó lọ sí Ṣuri. ");
INSERT INTO yor_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ó sì wí pé, “Hagari, ìránṣẹ́ Sarai, níbo ni o ti ń bọ̀, níbo sì ni ìwọ ń lọ?” Ó sì dáhùn pé, “Mo ń sálọ kúrò lọ́dọ̀ ọ̀gá mi Sarai ni.” ");
INSERT INTO yor_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Angẹli Olúwa sì wí fún un pé, “Padà lọ sí ọ̀dọ̀ ọ̀gá rẹ kí o sì tẹríba fún un.” ");
INSERT INTO yor_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Angẹli Olúwa náà sì fi kún fún un pé, “Èmi yóò sọ ọ́ di orílẹ̀-èdè ńlá, ìran rẹ kì yóò sì lóǹkà.” ");
INSERT INTO yor_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Angẹli Olúwa náà sì wí fún un pé, “Ìwọ ti lóyún, ìwọ yóò sì bí ọmọkùnrin kan. Ìwọ yóò sì pe orúkọ rẹ̀ ní Iṣmaeli, nítorí tí Olúwa ti rí ìpọ́njú rẹ. ");
INSERT INTO yor_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Òun yóò jẹ́ oníjàgídíjàgan ènìyàn ọwọ́ rẹ̀ yóò wà lára ènìyàn gbogbo, ọwọ́ ènìyàn gbogbo yóò sì wà lára rẹ̀, yóò sì máa gbé ní ìkanra pẹ̀lú àwọn arákùnrin rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ó sì pe orúkọ Olúwa tí o bá sọ̀rọ̀ ní, “Ìwọ ni Ọlọ́run tí ó rí mi,” nítorí tí ó wí pé, “Mo ti ri ẹni tí ó rí mi báyìí.” ");
INSERT INTO yor_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nítorí náà ni a ṣe ń pe kànga náà ní Beeri-Lahai-Roi; kànga ẹni alààyè tí ó rí mi. Ó wà ní agbede-méjì Kadeṣi àti Beredi. ");
INSERT INTO yor_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagari sì bí ọmọkùnrin kan fún Abramu, Abramu sì pe orúkọ rẹ̀ ní Iṣmaeli. ");
INSERT INTO yor_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramu jẹ́ ẹni ọdún mẹ́rìndínláàádọ́rùn-ún nígbà tí Hagari bí Iṣmaeli fún un. ");
INSERT INTO yor_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ní ìgbà tí Abramu di ẹni ọ̀kàndínlọ́gọ́rùn-ún ọdún, Olúwa farahàn án, ó sì wí pé, “Èmi ni Ọlọ́run alágbára, máa rìn níwájú mi, kí o sì jẹ́ aláìlábùkù. ");
INSERT INTO yor_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Èmi yóò sì fi ìdí májẹ̀mú mi múlẹ̀ pẹ̀lú rẹ. Èmi yóò sì sọ ọ́ di púpọ̀ gidigidi.” ");
INSERT INTO yor_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abramu sì dojúbolẹ̀, Ọlọ́run sì wí fún un pé. ");
INSERT INTO yor_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ní ti èmi, májẹ̀mú mi pẹ̀lú rẹ nìyí. Ìwọ yóò di baba orílẹ̀-èdè púpọ̀. ");
INSERT INTO yor_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","A kì yóò pe orúkọ rẹ̀ ní Abramu mọ́, bí kò ṣe Abrahamu, nítorí, mo ti sọ ọ́ di baba orílẹ̀-èdè púpọ̀. ");
INSERT INTO yor_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Èmi yóò mú ọ bí si lọ́pọ̀lọ́pọ̀, ọ̀pọ̀ orílẹ̀-èdè ni èmi yóò sì mú ti ara rẹ jáde wá, àwọn ọba pẹ̀lú yóò sì ti inú rẹ jáde. ");
INSERT INTO yor_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Èmi yóò sì gbé májẹ̀mú mi kalẹ̀ láàrín tèmi tìrẹ, ní májẹ̀mú ayérayé àti láàrín irú-ọmọ rẹ ní ìran-ìran wọn, láti máa ṣe Ọlọ́run rẹ àti ti irú-ọmọ rẹ lẹ́yìn rẹ. ");
INSERT INTO yor_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Gbogbo ilẹ̀ Kenaani níbi tí ìwọ ti ṣe àjèjì ni èmi yóò fi fún ọ àti fún irú-ọmọ rẹ lẹ́yìn rẹ láéláé. Èmi yóò sì jẹ́ Ọlọ́run wọn.” ");
INSERT INTO yor_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nígbà náà ni Ọlọ́run wí fún Abrahamu pé, “Ìwọ máa pa májẹ̀mú mi mọ́, ìwọ àti irú-ọmọ rẹ lẹ́yìn rẹ àti àwọn ìran tí ó ń bọ̀. ");
INSERT INTO yor_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Èyí ni májẹ̀mú mi pẹ̀lú rẹ àti ìran rẹ lẹ́yìn rẹ, májẹ̀mú tí ẹ̀yin yóò máa pamọ́. Gbogbo ọkùnrin yín ni a gbọdọ̀ kọ ní ilà. ");
INSERT INTO yor_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ẹ̀yin yóò kọ ara yín ní ilà, èyí ni yóò jẹ́ àmì májẹ̀mú láàrín tèmi tiyín. ");
INSERT INTO yor_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ní gbogbo ìran tí ń bọ̀ lẹ́yìn, gbogbo ọkùnrin ni a gbọdọ̀ kọ ni ilà ní ọjọ́ kẹjọ tí a bí wọn, àti àwọn tí a bí ní ilé rẹ, tàbí tí a fi owó rà lọ́wọ́ àwọn àjèjì, àwọn tí kì í ṣe ọmọ rẹ̀. Èyí yóò sì jẹ́ májẹ̀mú láéláé tí yóò wà láàrín Èmi àti irú-ọmọ rẹ. ");
INSERT INTO yor_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ìbá à ṣe ẹni tí a bí nínú ilé rẹ, tàbí ẹni tí o fi owó rà, a gbọdọ̀ kọ wọ́n ní ilà; májẹ̀mú mí lára yín yóò jẹ́ májẹ̀mú ayérayé. ");
INSERT INTO yor_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Gbogbo ọmọkùnrin tí kò bá kọ ilà, tí a kò kọ ní ilà abẹ́, ni a ó gé kúrò láàrín àwọn ènìyàn rẹ̀, nítorí pé ó da májẹ̀mú mi.” ");
INSERT INTO yor_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ọlọ́run wí fún Abrahamu pé, “Ní ti Sarai, aya rẹ̀, ìwọ kì yóò pè é ní Sarai mọ́, bí kò ṣe Sara. ");
INSERT INTO yor_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Èmi yóò bùkún fún un, èmi yóò sì fun ọ ní ọmọkùnrin kan nípasẹ̀ rẹ̀. Èmi yóò bùkún un, yóò sì di ìyá àwọn orílẹ̀-èdè, àwọn ọba àwọn orílẹ̀-èdè yóò sì ti ara rẹ̀ jáde wá.” ");
INSERT INTO yor_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrahamu sì dojúbolẹ̀, ó rẹ́rìn-ín, ó sì wí fún ara rẹ̀ pé, “A ó ha bí ọmọ fún ẹni ọgọ́rùn-ún ọdún? Sara tí í ṣe ẹni àádọ́rùn-ún ọdún yóò ha bímọ bí?” ");
INSERT INTO yor_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abrahamu sì wí fún Ọlọ́run pé, “Sá à jẹ́ kí Iṣmaeli kí ó wà láààyè lábẹ́ ìbùkún rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nígbà náà ni Ọlọ́run wí pé, “Mo gbọ́, ṣùgbọ́n Sara aya rẹ̀ yóò bí ọmọkùnrin kan fún ọ, ìwọ yóò sì pe orúkọ rẹ̀ ní Isaaki, èmi yóò fi ìdí májẹ̀mú mi múlẹ̀ pẹ̀lú rẹ̀ ní májẹ̀mú ayérayé àti àwọn irú-ọmọ rẹ̀ lẹ́yìn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ṣùgbọ́n ní ti Iṣmaeli, mo gbọ́ ohun tí ìwọ wí, èmi yóò bùkún fún un nítòótọ́, èmi ó sì mú un bí sí i, yóò sì pọ̀ sí i, òun yóò sì jẹ́ baba fún àwọn ọmọ ọba méjìlá, bẹ́ẹ̀ ni èmi yóò sì sọ ọ́ di orílẹ̀-èdè ńlá. ");
INSERT INTO yor_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ṣùgbọ́n èmi yóò fi ìdí májẹ̀mú mi múlẹ̀ pẹ̀lú Isaaki, ẹni tí Sara yóò bí fún ọ ni ìwòyí àmọ́dún.” ");
INSERT INTO yor_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Nígbà tí ó ti bá Abrahamu sọ̀rọ̀ tán, Ọlọ́run sì gòkè lọ kúrò lọ́dọ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ní ọjọ́ náà gan an ni Abrahamu mú Iṣmaeli ọmọ rẹ̀ àti àwọn ẹrú tí a bí ní ilé rẹ̀ àti àwọn tí ó fi owó rà, ó sì kọ wọ́n ní ilà. Bẹ́ẹ̀ ni ó sì kọ gbogbo ọkùnrin tí ń bẹ ní ilé rẹ̀ ní ilà gẹ́gẹ́ bí àṣẹ Ọlọ́run. ");
INSERT INTO yor_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamu jẹ́ ẹni ọ̀kàndínlọ́gọ́rùn-ún ọdún nígbà tí a kọ ọ́ ní ilà. ");
INSERT INTO yor_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Iṣmaeli ọmọ rẹ̀ jẹ́ ẹni ọdún mẹ́tàlá. ");
INSERT INTO yor_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ní ọjọ́ náà gan an ni a kọ Abrahamu ní ilà pẹ̀lú Iṣmaeli ọmọ rẹ̀ ọkùnrin. ");
INSERT INTO yor_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Àti gbogbo ọkùnrin tí ó wà ní ilé Abrahamu, ìbá à ṣe èyí tí a bí ní ilé rẹ̀ tàbí èyí tí a fi owó rà lọ́wọ́ àlejò ni a kọ ní ilà pẹ̀lú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Olúwa sì farahan Abrahamu nítòsí àwọn igi ńlá Mamre, bí ó ti jókòó ní ẹnu-ọ̀nà àgọ́ rẹ̀, nígbà tí ọjọ́-kanrí tí oòrùn sì mú. ");
INSERT INTO yor_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahamu gbójú sókè, ó sì rí àwọn ọkùnrin mẹ́ta tí wọn dúró nítòsí rẹ̀. Nígbà tí ó rí wọn, ó sáré láti lọ pàdé wọn, ó sì tẹríba bí ó ti ń kí wọn. ");
INSERT INTO yor_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ó wí pé, “Bí mo bá rí ojúrere yín Olúwa mi, ẹ má ṣe lọ láì yà sọ́dọ̀ ìránṣẹ́ yín. ");
INSERT INTO yor_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ẹ jẹ́ kí a bu omi díẹ̀ wá kí ẹ̀yin kí ó wẹ ẹsẹ̀ yín, kí ẹ sì sinmi lábẹ́ igi níhìn-ín. ");
INSERT INTO yor_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ẹ jẹ́ kí n wá oúnjẹ wá fún un yín, kí ẹ̀yin kí ó lè jẹ, kí ara sì tù yín, kí ẹ si tẹ̀síwájú ní ọ̀nà yín, nígbà tí ẹ ti yà ní ọ̀dọ̀ ìránṣẹ́ yín.” Wọn sì wí pé “Ó dára.” ");
INSERT INTO yor_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abrahamu sì yára tọ Sara aya rẹ̀ lọ nínú àgọ́, ó wí pé, “Tètè mú òsùwọ̀n ìyẹ̀fun dáradára mẹ́ta kí o sì pò ó pọ̀, kí o sì ṣe oúnjẹ.” ");
INSERT INTO yor_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abrahamu sì tún sáré lọ sí ibi agbo ẹran, ó sì mú ọmọ màlúù kan fún ìránṣẹ́ rẹ̀, ìránṣẹ́ náà sì tètè ṣè é. ");
INSERT INTO yor_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ó sì mú wàrà àti mílíìkì àti màlúù tí ó ti pèsè, ó sì gbé síwájú wọn. Ó sì dúró nítòsí wọn lábẹ́ igi bí wọn ti ń jẹ ẹ́. ");
INSERT INTO yor_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Wọn béèrè pé, “Sara aya rẹ ń kọ́?” Ó dáhùn pé, “Ó wà nínú àgọ́.” ");
INSERT INTO yor_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Nígbà náà ni Olúwa wí fún un pé, “Èmi yóò sì tún padà tọ̀ ọ́ wá nítòótọ́ ní ìwòyí àmọ́dún; Sara aya rẹ yóò sì bí ọmọkùnrin kan.” Sara sì ń dẹtí gbọ́ láti ẹnu-ọ̀nà àgọ́ tí ó wà lẹ́yìn ọkùnrin náà. ");
INSERT INTO yor_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahamu àti Sara sì ti di arúgbó, Sara sì ti kọjá àsìkò ìbímọ. ");
INSERT INTO yor_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Nítorí náà, Sara rẹ́rìn-ín nínú ara rẹ̀ bí ó ti ń rò ó lọ́kàn rẹ̀ pé, “Lẹ́yìn ìgbà tí mo ti di arúgbó tán tí olúwa mi pẹ̀lú sì ti gbó jọ̀kújọ̀kú, èmi yóò ha tún lè bímọ?” ");
INSERT INTO yor_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Nígbà náà ni Olúwa wí fún Abrahamu pé, “Kín ló dé tí Sara fi rẹ́rìn-ín tí ó sì wí pé, ‘Èmi yóò ha bímọ nítòótọ́, nígbà tí mo di ẹni ogbó tán?’ ");
INSERT INTO yor_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ǹjẹ́ ohunkóhun wà tí ó ṣòro jù fún Olúwa? Èmi ó padà tọ̀ ọ́ wá ní ìwòyí àmọ́dún, Sara yóò sì bí ọmọkùnrin.” ");
INSERT INTO yor_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ẹ̀rù sì ba Sara, ó sì sẹ́ pé òun kò rẹ́rìn-ín. Ṣùgbọ́n Olúwa wí fún un pé, “Dájúdájú ìwọ rẹ́rìn-ín.” ");
INSERT INTO yor_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nígbà tí àwọn ọkùnrin náà dìde láti máa lọ, wọn kọjú sí ọ̀nà Sodomu, Abrahamu sì sìn wọ́n dé ọ̀nà. ");
INSERT INTO yor_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nígbà náà ni Olúwa wí pé, “Ǹjẹ́ èmi yóò ha pa ohun tí mo fẹ́ ṣe mọ́ fún Abrahamu bí? ");
INSERT INTO yor_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Dájúdájú Abrahamu yóò sá à di orílẹ̀-èdè ńlá àti alágbára, àti gbogbo orílẹ̀-èdè ayé ni a ó bùkún fún nípasẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nítorí tí èmi ti yàn án láti kọ́ àwọn ọmọ rẹ̀ àti àwọn ará ilé rẹ̀ lẹ́yìn rẹ̀, láti máa pa ọ̀nà Olúwa mọ nípa ṣíṣe olóòtítọ́ àti olódodo: kí Olúwa le è mú ìlérí rẹ̀ fún Abrahamu ṣẹ.” ");
INSERT INTO yor_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Olúwa sì wí pé, igbe Sodomu àti Gomorra pọ̀ púpọ̀ àti pé ẹ̀ṣẹ̀ wọn burú jọjọ. ");
INSERT INTO yor_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","“Èmi yóò sọ̀kalẹ̀ síbẹ̀ láti ṣe ìwádìí igbe tí ó dé sí etí ìgbọ́ mi nípa wọn, kí èmi sì mọ òtítọ́ tí ó wà níbẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Àwọn ọkùnrin náà yí padà, wọ́n sì ń lọ sí ìhà Sodomu. Ṣùgbọ́n Abrahamu dúró níbẹ̀ níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Nígbà náà ni Abrahamu súnmọ́ ọ̀dọ̀ Olúwa, ó sì wí pé, “Ìwọ yóò ha pa olódodo ènìyàn àti ènìyàn búburú run papọ̀ bí?” ");
INSERT INTO yor_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","“Bí ó bá ṣe pé ìwọ rí àádọ́ta olódodo nínú ìlú náà, ìwọ yóò ha run ún, ìwọ kì yóò ha dá ìlú náà sí nítorí àwọn àádọ́ta olódodo tí ó wà nínú rẹ̀ náà? ");
INSERT INTO yor_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kò jẹ́ rí bẹ́ẹ̀! Dájúdájú ìwọ kì yóò ṣe ohun tí ó jọ bẹ́ẹ̀, láti pa olódodo pẹ̀lú àwọn ènìyàn rere àti àwọn ènìyàn búburú. Dájúdájú, ìwọ kì yóò ṣe èyí tí ó tọ́ bi?” ");
INSERT INTO yor_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Olúwa wí pé, “Bí mo bá rí àádọ́ta olódodo ní ìlú Sodomu, èmi yóò dá ìlú náà sí nítorí tiwọn.” ");
INSERT INTO yor_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrahamu sì tún tẹ̀síwájú pé, “Wò ó nísinsin yìí, níwọ̀n bí èmi ti ní ìgboyà láti bẹ̀rẹ̀ sí sọ̀rọ̀ níwájú Olúwa, èmi ẹni tí í ṣe erùpẹ̀ àti eérú, ");
INSERT INTO yor_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","bí ó bá ṣe pe olódodo márùndínláàádọ́ta ni ó wà nínú ìlú, ìwọ yóò ha pa ìlú náà run nítorí ènìyàn márùn-ún bí?” Olúwa dáhùn pé, “Èmi kì yóò pa ìlú náà run bí mo bá rí olódodo márùndínláàádọ́ta nínú rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Òun sì tún wí lẹ́ẹ̀kan si pé, “Bí ó bá ṣe pé ogójì ni ń kọ́?” Olúwa sì tún wí pé, “Èmi kì yóò pa ìlú náà run bí mo bá rí olódodo ogójì nínú rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abrahamu sì tún bẹ Olúwa pé, “Kí Olúwa má ṣe bínú, ṣùgbọ́n èmi yóò sọ̀rọ̀. Bí ó bá ṣe pé ọgbọ̀n ni a rí níbẹ̀ ń kọ́?” Olúwa dáhùn pé, “Bí mó bá rí ọgbọ̀n, èmi kì yóò pa ìlú run.” ");
INSERT INTO yor_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahamu wí pé, “Níwọ́n bí mo ti ní ìgboyà láti bá Olúwa sọ̀rọ̀ báyìí, jẹ́ kí n tẹ̀síwájú. Bí o bá ṣe pé olódodo ogún péré ni ó wà nínú ìlú náà ń kọ́?” Olúwa sì dáhùn pé, “Èmi kì yóò pa á run nítorí ogún ènìyàn náà.” ");
INSERT INTO yor_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrahamu sì wí pé, “Jọ̀wọ́ má ṣe bínú Olúwa. Jẹ́ kí ń béèrè lẹ́ẹ̀kan si. Bí ó bá ṣe pé ènìyàn mẹ́wàá ni ó jẹ́ olódodo ń kọ́?” Olúwa wí pé, “Nítorí ènìyàn mẹ́wàá náà, èmi kì yóò pa á run.” ");
INSERT INTO yor_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Olúwa sì bá tirẹ̀ lọ, nígbà tí ó bá Abrahamu sọ̀rọ̀ tán, Abrahamu sì padà sílé. ");
INSERT INTO yor_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ní àṣálẹ́, àwọn angẹli méjì sì wá sí ìlú Sodomu, Lọti sì jókòó ní ẹnu ibodè ìlú. Bí ó sì ti rí wọn, ó sì dìde láti pàdé wọn, ó kí wọn, ó sì foríbalẹ̀ fún wọn. ");
INSERT INTO yor_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ó wí pé, “Ẹ̀yin olúwa mi, èmi bẹ̀ yín, ẹ yà sí ilé ìránṣẹ́ yín kí ẹ sì wẹ ẹsẹ̀ yín, kí n sì gbà yín lálejò, ẹ̀yin ó sì dìde ní kùtùkùtù òwúrọ̀ láti máa bá ìrìnàjò yín lọ.” Wọ́n sì wí pé, “Rárá o, àwa yóò dúró ní ìgboro ní òru òní.” ");
INSERT INTO yor_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ṣùgbọ́n Lọti rọ̀ wọ́n gidigidi tó bẹ́ẹ̀ tí wọ́n gbà láti bá a lọ sì ilé. Ó sì ṣe àsè fún wọn, ó sì dín àkàrà aláìwú fún wọ́n, wọ́n sì jẹ. ");
INSERT INTO yor_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ṣùgbọ́n kí ó tó di pé wọ́n lọ sùn, àwọn ọkùnrin ìlú Sodomu tọmọdé tàgbà yí ilé náà ká. ");
INSERT INTO yor_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Wọ́n pe Lọti pé, “Àwọn ọkùnrin tí ó wọ̀ sí ilé rẹ lálẹ́ yìí ń kọ́? Mú wọn jáde fún wa, kí a le ní ìbálòpọ̀ pẹ̀lú wọn.” ");
INSERT INTO yor_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lọti sì jáde láti pàdé wọn, ó sì ti ìlẹ̀kùn lẹ́yìn rẹ̀ bí ó ti jáde. ");
INSERT INTO yor_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ó sì wí pé, “Rárá, ẹ̀yin ará mi, ẹ má ṣe ṣe ohun búburú yìí, ");
INSERT INTO yor_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","kíyèsi i, mo ní ọmọbìnrin méjì tí kò mọ ọkùnrin rí, ẹ jẹ́ kí n mú wọn tọ̀ yín wá kí ẹ sì ṣe ohun tí ẹ fẹ́ pẹ̀lú wọn. Ṣùgbọ́n ẹ má ṣe ṣe àwọn ọkùnrin wọ̀nyí ní ibi kan nítorí wọ́n wá wọ̀ lábẹ́ ààbò ní ilé mi.” ");
INSERT INTO yor_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Wọ́n sì wí fún pé, “Bì sẹ́yìn fún wa. Èyí yìí wá ṣe àtìpó láàrín wa, òun sì fẹ́ ṣe onídàájọ́! Aburú tí a ó fi ṣe ọ́ yóò pọ̀ ju tí wọn lọ.” Wọn rọ́ lu Lọti, wọ́n sì súnmọ́ ọn láti fọ́ ìlẹ̀kùn. ");
INSERT INTO yor_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ṣùgbọ́n àwọn ọkùnrin náà nawọ́ fa Lọti wọlé, wọ́n sì ti ìlẹ̀kùn. ");
INSERT INTO yor_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Wọ́n sì bu ìfọ́jú lu àwọn ọkùnrin tí ó wà ní ẹnu-ọ̀nà ilé náà, àti èwe àti àgbà: wọ́n kò sì rí ẹnu-ọ̀nà mọ́. ");
INSERT INTO yor_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Àwọn ọkùnrin náà sì wí fún Lọti pé, “Ǹjẹ́ ó ní ẹlòmíràn ní ìlú yìí bí? Àna rẹ ọkùnrin, àwọn ọmọ rẹ lọ́kùnrin àti lóbìnrin, tàbí ẹnikẹ́ni tí ìwọ ní ní ìlú yìí, kó wọn jáde kúrò ní ibí yìí, ");
INSERT INTO yor_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","nítorí a ó pa ìlú yìí run, nítorí igbe iṣẹ́ búburú wọn ń dí púpọ̀ níwájú Olúwa, Olúwa sì rán wa láti pa á run.” ");
INSERT INTO yor_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Nígbà náà ni Lọti jáde, ó sì wí fún àwọn àna rẹ̀ ọkùnrin tí ó ti bá jẹ́ ẹ̀jẹ́ láti fẹ́ àwọn ọmọ rẹ̀ pé, “Ẹ ṣe kánkán, kí ẹ jáde ní ìlú yìí, nítorí Olúwa fẹ́ pa ìlú yìí run!” Ṣùgbọ́n àwọn ọkọ ọmọ rẹ̀ wọ̀nyí rò pé àwàdà ló ń ṣe. ");
INSERT INTO yor_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ní àfẹ̀mọ́júmọ́, àwọn angẹli náà rọ Lọti pé, “Ṣe wéré, mú aya rẹ àti àwọn ọmọbìnrin rẹ méjèèjì tí ó wà níhìn-ín, àìṣe bẹ́ẹ̀, ìwọ yóò parun pẹ̀lú ìlú yìí nígbà tí wọ́n bá ń jìyà ẹ̀ṣẹ̀ wọn.” ");
INSERT INTO yor_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Nígbà tí ó ń jáfara, àwọn ọkùnrin náà nawọ́ mú un lọ́wọ́, wọ́n sì nawọ́ mú aya rẹ̀ náà lọ́wọ́ àti àwọn ọmọbìnrin rẹ̀ méjèèjì, wọ́n sì mú wọn jáde sẹ́yìn odi ìlú, nítorí Olúwa ṣàánú fún wọn. ");
INSERT INTO yor_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ní kété tí wọ́n mú wọn jáde sẹ́yìn odi tán, ọ̀kan nínú wọn wí pé, “Sá àsálà fún ẹ̀mí rẹ! Má ṣe wo ẹ̀yìn rẹ, bẹ́ẹ̀ ni kí ìwọ kí ó má ṣe dúró ní gbogbo pẹ̀tẹ́lẹ̀! Sá àsálà lọ sí orí òkè, kí ìwọ ó má ba ṣègbé!” ");
INSERT INTO yor_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ṣùgbọ́n Lọti wí fún wọn pé, “Rárá, ẹ̀yin Olúwa mi, ẹ jọ̀wọ́! ");
INSERT INTO yor_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nígbà tí ìránṣẹ́ rẹ ti rí ojúrere rẹ, tí o sì ti fi àánú rẹ hàn nípa gbígba ẹ̀mí mi là, èmi kò le è sálọ sórí òkè, kí búburú yìí má ba à lé mi bá, kí n sì kú. ");
INSERT INTO yor_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Wò ó, ìlú kékeré kan nìyí ní tòsí láti sá sí: jẹ́ kí n sálọ síbẹ̀, ìlú kékeré ha kọ́? Ẹ̀mí mi yóò sì yè.” ");
INSERT INTO yor_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ó sì wí fún un pé, “Ó dára, mo gba ẹ̀bẹ̀ rẹ. Èmi kì yóò run ìlú náà tí ìwọ sọ̀rọ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Tètè! Sálọ síbẹ̀, nítorí èmi kò le ṣe ohun kan àyàfi tí ó bá dé ibẹ̀.” (ìdí nìyí tí a fi ń pe ìlú náà ní Soari). ");
INSERT INTO yor_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Nígbà tí Lọti yóò fi dé ìlú Soari, oòrùn ti yọ. ");
INSERT INTO yor_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Nígbà náà ni Olúwa rọ̀jò iná àti sulfuru sórí Sodomu àti Gomorra láti ọ̀run lọ́dọ̀ Olúwa wá. ");
INSERT INTO yor_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Báyìí ni ó run àwọn ìlú náà àti gbogbo ilẹ̀ pẹ̀tẹ́lẹ̀, pẹ̀lú gbogbo àwọn tí ó wà ní ìlú ńlá ńlá wọ̀n-ọn-nì àti ohun gbogbo tí ó hù jáde nílẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ṣùgbọ́n aya Lọti bojú wo ẹ̀yìn, ó sì di ọ̀wọ́n iyọ̀. ");
INSERT INTO yor_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ní kùtùkùtù òwúrọ̀ ọjọ́ kejì, Abrahamu sì dìde ó sì padà lọ sí ibi tí ó gbé dúró níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ó sì wo ìhà Sodomu àti Gomorra àti àwọn ilẹ̀ pẹ̀tẹ́lẹ̀ wọ̀n-ọn-nì, ó sì rí èéfín tí ń ti ibẹ̀ jáde bí èéfín iná ìléru. ");
INSERT INTO yor_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ọlọ́run sì rántí Abrahamu, nígbà tí ó run ìlú pẹ̀tẹ́lẹ̀ wọ̀n-ọn-nì tan, ó sì mú Lọti jáde kúrò láàrín ìparun náà, tí ó kọlu ìlú tí Lọti ti gbé. ");
INSERT INTO yor_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lọti àti àwọn ọmọ rẹ̀ obìnrin méjèèjì sì kúrò ní Soari, wọ́n sì ń lọ gbé ní orí òkè ní inú ihò àpáta, nítorí ó bẹ̀rù láti gbé ní ìlú Soari. ");
INSERT INTO yor_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ní ọjọ́ kan, èyí ẹ̀gbọ́n sọ fún àbúrò rẹ̀ pé, “Baba wa ti dàgbà, kò sì sí ọkùnrin kankan ní agbègbè yìí tí ìbá bá wa lòpọ̀, bí ìṣe gbogbo ayé. ");
INSERT INTO yor_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Wá, jẹ́ kí a mú baba wa mu ọtí yó, kí ó ba à le bá wa lòpọ̀, kí àwa kí ó lè bí ọmọ, kí ìran wa má ba à parẹ́.” ");
INSERT INTO yor_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ní òru ọjọ́ náà, wọ́n rọ baba wọn ní ọtí yó. Èyí ẹ̀gbọ́n sì wọlé tọ̀ ọ́, ó sì bá a lòpọ̀, baba wọn kò mọ̀ ìgbà tí ó sùn ti òun àti ìgbà tí ó dìde. ");
INSERT INTO yor_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ní ọjọ́ kejì èyí ẹ̀gbọ́n wí fún àbúrò rẹ̀ pé, “Ní àná mo sùn ti baba mi. Jẹ́ kí a tún wọlé tọ̀ ọ́, kí a lè ní irú-ọmọ láti ọ̀dọ̀ baba wa.” ");
INSERT INTO yor_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Bẹ́ẹ̀ ni wọ́n tún fún baba wọn ní ọtí mu yó ni alẹ́ ọjọ́ náà, èyí àbúrò náà sì wọlé tọ̀ ọ́ lọ, ó sì bá a lòpọ̀, kò sì tún mọ ìgbà tí ó wọlé sùn ti òun tàbí ìgbà tí ó dìde. ");
INSERT INTO yor_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Àwọn ọmọbìnrin Lọti méjèèjì sì lóyún fún baba wọn. ");
INSERT INTO yor_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Èyí ẹ̀gbọ́n sì bí ọmọkùnrin, ó sì pe orúkọ rẹ̀ ní Moabu. Òun ni baba ńlá àwọn ará Moabu lónìí. ");
INSERT INTO yor_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Èyí àbúrò náà sì bí ọmọkùnrin, ó sì pe orúkọ rẹ̀ ní Bene-Ami. Òun ni baba ńlá àwọn ará Ammoni lónìí. ");
INSERT INTO yor_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahamu sì kó kúrò níbẹ̀ lọ sí ìhà gúúsù ó sì ń gbé ní agbede-méjì Kadeṣi àti Ṣuri; ó sì gbé ní ìlú Gerari fún ìgbà díẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abrahamu sì sọ ní ti Sara aya rẹ̀ níbẹ̀ pé, “Arábìnrin mi ni.” Abimeleki ọba Gerari sì ránṣẹ́ mú Sara wá sí ààfin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ṣùgbọ́n Ọlọ́run tọ Abimeleki wá ní ojú àlá lọ́jọ́ kan, ó sì wí fún un pé, “Kíyèsi, kò sí ohun tí o fi sàn ju òkú lọ, nítorí obìnrin tí ìwọ mú sọ́dọ̀ n nì, aya ẹni kan ní íṣe.” ");
INSERT INTO yor_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ṣùgbọ́n Abimeleki kò tí ìbá obìnrin náà lòpọ̀, nítorí náà ó wí pé, “Olúwa ìwọ yóò run orílẹ̀-èdè aláìlẹ́bi bí? ");
INSERT INTO yor_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ǹjẹ́ òun kò sọ fún mi pé, ‘Arábìnrin mi ni,’ obìnrin náà pẹ̀lú sì sọ pé, ‘Arákùnrin mí ni’? Ní òtítọ́ pẹ̀lú ọkàn mímọ́ àti ọwọ́ mímọ́, ni mo ṣe èyí.” ");
INSERT INTO yor_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Nígbà náà ni Ọlọ́run wí fún un nínú àlá náà pé, “Bẹ́ẹ̀ ni, mo mọ̀ pé pẹ̀lú òtítọ́ inú ni ìwọ ṣe èyí, èyí ni mo fi pa ọ́ mọ́ tí ń kò jẹ́ kí o ṣẹ̀ sí mi. Ìdí nìyí tí n kò fi jẹ́ kí o ní ìbálòpọ̀ pẹ̀lú obìnrin náà. ");
INSERT INTO yor_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nísinsin yìí, dá aya ọkùnrin náà padà, nítorí pé wòlíì ni, yóò sì gbàdúrà fún ọ, ìwọ yóò sì yè. Ṣùgbọ́n bí ìwọ kò bá dá a padà, mọ̀ dájú pé ìwọ àti gbogbo ẹni tí í ṣe tìrẹ yóò kú.” ");
INSERT INTO yor_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ní òwúrọ̀ kùtùkùtù ọjọ́ kejì, Abimeleki pe gbogbo àwọn ìjòyè rẹ̀. Nígbà tí ó sì sọ gbogbo ohun tí ó ṣẹlẹ̀ fún wọn, ẹ̀rù bà wọ́n gidigidi. ");
INSERT INTO yor_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Nígbà náà ni Abimeleki pe Abrahamu ó sì wí fún un pé, “Èwo ni èyí tí ìwọ ṣe sí wa yìí? Ẹ̀ṣẹ̀ wo ni mo ṣẹ̀ ọ́ tí ìwọ fi mú ìdálẹ́bi ńlá wá sí orí èmi àti ìjọba mi? Kò yẹ kí ìwọ hu irú ìwà yìí sí mi.” ");
INSERT INTO yor_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleki sì bi Abrahamu pé, “Kín ló dé tí ìwọ fi ṣe èyí?” ");
INSERT INTO yor_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahamu sì dáhùn pé, “Mo ṣe èyí nítorí mo rò nínú ara mi pé, ẹ̀yin tí ẹ wà níhìn-ín, ẹ kò bẹ̀rù Ọlọ́run, pé, ẹ sì le pa mí nítorí aya mi. ");
INSERT INTO yor_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Yàtọ̀ fún ìyẹn, òtítọ́ ni pé arábìnrin mi ni. Ọmọ baba kan ni wá, bí ó tilẹ̀ jẹ́ pé, a kì í ṣe ọmọ ìyá kan. Mo sì fẹ́ ẹ ní aya. ");
INSERT INTO yor_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Nígbà tí Ọlọ́run sì mú mi rìn kiri kúrò ní ilé baba mi, mo wí fún un pé, ‘Èyí ni ọ̀nà tí ó lè gbà fihàn pé ó fẹ́ràn mi. Gbogbo ibi tí a bá dé máa sọ pé, “Arákùnrin rẹ ni mí.” ’ ” ");
INSERT INTO yor_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Nígbà náà ni Abimeleki mú àgùntàn àti màlúù wá, àti ẹrúkùnrin àti ẹrúbìnrin, ó sì kó wọn fún Abrahamu, ó sì dá Sara aya rẹ̀ padà fún un. ");
INSERT INTO yor_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki sì tún wí fún un pé, “Gbogbo ilẹ̀ mí nìyí níwájú rẹ, máa gbé ní ibikíbi tí o fẹ́ níbẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimeleki sì wí fún Sara pé, “Mo fi ẹgbẹ̀rún (1,000) owó ẹyọ fàdákà fún arákùnrin rẹ. Èyí ni owó ìtánràn ẹ̀ṣẹ̀ mi sí ọ níwájú gbogbo ẹni tí ó wà pẹ̀lú rẹ àti pé, a dá ọ láre pátápátá.” ");
INSERT INTO yor_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Nígbà náà, Abrahamu gbàdúrà sí Ọlọ́run, Ọlọ́run sì wo Abimeleki àti aya rẹ̀ àti àwọn ẹrúbìnrin rẹ̀ sàn. Wọ́n sì tún ń bímọ, ");
INSERT INTO yor_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","nítorí Olúwa ti sé gbogbo ará ilé Abimeleki nínú nítorí Sara aya Abrahamu. ");
INSERT INTO yor_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Olúwa sì bẹ Sara wò bí ó ti wí, Olúwa sì ṣe fún Sara gẹ́gẹ́ bí ó ti ṣèlérí. ");
INSERT INTO yor_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara sì lóyún, ó sì bí ọmọkùnrin kan fún Abrahamu ní ọjọ́ ogbó rẹ̀, ní àkókò náà gan an tí Ọlọ́run ti ṣèlérí fún un. ");
INSERT INTO yor_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abrahamu sì sọ orúkọ ọmọ náà tí Sara bí fun un ní Isaaki. ");
INSERT INTO yor_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Nígbà tí Isaaki pé ọmọ ọjọ́ mẹ́jọ, Abrahamu sì kọ ọ́ ní ilà gẹ́gẹ́ bí Ọlọ́run ti pàṣẹ fún un. ");
INSERT INTO yor_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ẹni ọgọ́rùn-ún ọdún ni Abrahamu nígbà tí ó bí Isaaki. ");
INSERT INTO yor_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara sì wí pé, “Ọlọ́run ti pa mí lẹ́rìn-ín. Gbogbo ẹni tí ó bá sì gbọ́ pé mo bímọ yóò rẹ́rìn-ín pẹ̀lú mi.” ");
INSERT INTO yor_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ó sì fi kún un pé, “Ta ni ó le sọ fún Abrahamu pé, Sara yóò di ọlọ́mọ? Síbẹ̀síbẹ̀, mo sì tún bí ọmọ fún Abrahamu ní ìgbà ogbó rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nígbà tí ọmọ náà dàgbà, ó sì gbà á lẹ́nu ọmú, ní ọjọ́ tí a gba Isaaki lẹ́nu ọmú, Abrahamu ṣe àsè ńlá. ");
INSERT INTO yor_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ṣùgbọ́n Sara rí ọmọ Hagari ará Ejibiti tí ó bí fún Abrahamu tí ó fi ṣe ẹlẹ́yà, ");
INSERT INTO yor_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ó sì wí fún Abrahamu pé, “Lé ẹrúbìnrin yìí àti ọmọ rẹ̀ jáde, nítorí ọmọ ẹrú yìí kò ní bá ọmọ mi Isaaki pín ogún.” ");
INSERT INTO yor_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ọ̀rọ̀ náà sì ba Abrahamu lọ́kàn jẹ́ gidigidi nítorí ọmọ rẹ̀ náà sá à ni Iṣmaeli i ṣe. ");
INSERT INTO yor_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ṣùgbọ́n Ọlọ́run wí fun Abrahamu pé, “Má ṣe ba ọkàn jẹ́ nítorí ọmọ náà àti ẹrúbìnrin rẹ. Gbọ́ ohun tí Sara wí fún ọ, nítorí nínú Isaaki ni a ó ti pe irú-ọmọ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Èmi yóò sọ ọmọ ẹrúbìnrin náà di orílẹ̀-èdè pẹ̀lú, nítorí ọmọ rẹ ni.” ");
INSERT INTO yor_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abrahamu sì dìde ní kùtùkùtù òwúrọ̀ ọjọ́ kejì, ó sì mú oúnjẹ àti ìgò omi kan, ó sì kó wọn fún Hagari, ó kó wọn lé e léjìká, ó sì lé e jáde pẹ̀lú ọmọ náà. Ó sì lọ lọ́nà rẹ, ó sì ń ṣe alárìnkiri ní ijù Beerṣeba. ");
INSERT INTO yor_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Nígbà tí omi inú ìgò náà tan, ó gbé ọmọ náà sí abẹ́ igbó. ");
INSERT INTO yor_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ó sì lọ, ó sì jókòó nítòsí ibẹ̀, níwọ̀n bí ìtafà kan, nítorí, ó rò ó nínú ara rẹ̀ pé, “Èmi kò fẹ́ wo bí ọmọ náà yóò ṣe kú.” Bí ó sì ti jókòó sí tòsí ibẹ̀, ó bẹ̀rẹ̀ sí ní sọkún. ");
INSERT INTO yor_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ọlọ́run gbọ́ ohun ẹkún náà, Angẹli Ọlọ́run sì pe Hagari láti ọ̀run, ó sì wí fun un pé, “Hagari, kín ni ó ṣe ọ́? Má bẹ̀rù nítorí Ọlọ́run ti gbọ́ ẹkún ọmọ náà níbi tí o tẹ́ ẹ sí. ");
INSERT INTO yor_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Dìde, gbé ọmọ náà sókè, kí o sì dìímú (tù ú nínú) nítorí èmi yóò sọ ọmọ náà di orílẹ̀-èdè ńlá.” ");
INSERT INTO yor_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ọlọ́run sì ṣí ojú Hagari, ó sì rí kànga kan, ó lọ síbẹ̀, ó rọ omi kún inú ìgò náà, ó sì fún ọmọ náà mu. ");
INSERT INTO yor_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ọlọ́run sì wà pẹ̀lú ọmọ náà bí ó ti ń dàgbà, ó ń gbé nínú ijù, ó sì di tafàtafà. ");
INSERT INTO yor_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nígbà tí ó ń gbé ni aginjù ní Parani, ìyá rẹ̀ fẹ́ ìyàwó fún un láti ilẹ̀ Ejibiti wá. ");
INSERT INTO yor_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ní àkókò yìí ni ọba Abimeleki àti Fikoli, olórí ogun rẹ̀ wí fún Abrahamu pé, “Ọlọ́run wà pẹ̀lú rẹ̀ nínú gbogbo ohun tí ó ń ṣe. ");
INSERT INTO yor_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ǹjẹ́ nísinsin yìí, fi Ọlọ́run búra fún mi, ìwọ kì yóò tàn mí àti àwọn ọmọ mi àti àwọn ìran mi, ìwọ yóò fi inú rere hàn fún mi àti orílẹ̀-èdè tí ìwọ ti ṣe àtìpó, bí mo ti fihàn fún ọ pẹ̀lú.” ");
INSERT INTO yor_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahamu sì wí pé, “Èmí búra.” ");
INSERT INTO yor_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Nígbà náà ni Abrahamu fi ẹ̀dùn ọkàn rẹ̀ hàn fún Abimeleki nípa kànga tí àwọn ọmọ ọ̀dọ̀ rẹ̀ gbà lọ́wọ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ṣùgbọ́n Abimeleki dáhùn pé, “Èmi kò mọ ẹni tí ó ṣe nǹkan yìí. Ìwọ kò sì sọ fún mi, bẹ́ẹ̀ ni èmi kò gbọ́, bí kò ṣe lónìí.” ");
INSERT INTO yor_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abrahamu sì mú àgùntàn àti màlúù wá, ó sì kó wọn fún Abimeleki. Àwọn méjèèjì sì dá májẹ̀mú. ");
INSERT INTO yor_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahamu sì ya abo ọ̀dọ́-àgùntàn méje nínú agbo àgùntàn rẹ̀ sọ́tọ̀. ");
INSERT INTO yor_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki sì béèrè lọ́wọ́ Abrahamu pé, “Kín ni ìtumọ̀ yíyà tí ìwọ ya àwọn ọ̀dọ́-àgùntàn méje wọ̀nyí sọ́tọ̀ sí.” ");
INSERT INTO yor_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ó dalóhùn pé, “Gba àwọn abo ọ̀dọ́-àgùntàn méje wọ̀nyí lọ́wọ́ mi gẹ́gẹ́ bí ẹ̀rí pé èmi ni mo gbẹ́ kànga yìí.” ");
INSERT INTO yor_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Nítorí náà ni a ṣe ń pe ibẹ̀ náà ni Beerṣeba nítorí níbẹ̀ ni àwọn méjèèjì gbé búra. ");
INSERT INTO yor_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Lẹ́yìn májẹ̀mú tí wọ́n dá ní Beerṣeba yìí, ni Abimeleki àti Fikoli olórí ogun rẹ̀ padà sí ilẹ̀ àwọn ará Filistini. ");
INSERT INTO yor_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahamu lọ́ igi tamariski kan sí Beerṣeba, níbẹ̀ ni ó sì pe orúkọ Olúwa Ọlọ́run ayérayé. ");
INSERT INTO yor_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahamu sì gbé ilẹ̀ àwọn ará Filistini fún ọjọ́ pípẹ́. ");
INSERT INTO yor_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nígbà tí ó ṣe, Ọlọ́run dán Abrahamu wò, ó pè é, ó sì wí pé, “Abrahamu.” Abrahamu sì dáhùn pé, “Èmi nìyí.” ");
INSERT INTO yor_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ọlọ́run sì wí pé, “Mú ọmọ rẹ, àní Isaaki ọmọ rẹ kan ṣoṣo nì, tí ìwọ fẹ́ràn, lọ sí ilẹ̀ Moria, kí o sì fi rú ẹbọ sísun níbẹ̀ lórí ọ̀kan nínú àwọn òkè tí èmi yóò sọ fún ọ.” ");
INSERT INTO yor_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abrahamu sì dìde ní kùtùkùtù òwúrọ̀ ọjọ́ kejì, ó sì di kẹ́tẹ́kẹ́tẹ́ rẹ̀ ní gàárì, ó sì mú méjì nínú àwọn ìránṣẹ́ rẹ̀ àti Isaaki ọmọ rẹ̀, ó sì ṣẹ́ igi fún ẹbọ sísun, ó sì gbéra lọ sí ibi tí Ọlọ́run ti sọ fún un. ");
INSERT INTO yor_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nígbà tí ó di ọjọ́ kẹta, Abrahamu gbé ojú sókè, ó sì rí ibi tí ó ń lọ ní òkèrè, ");
INSERT INTO yor_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abrahamu sì wí fún àwọn ìránṣẹ́ rẹ̀ pé, “Ẹ̀yin, ẹ dúró níhìn-ín pẹ̀lú kẹ́tẹ́kẹ́tẹ́, èmi àti ọmọ yìí yóò lọ sí ohunkóhun láti sin Ọlọ́run, a ó sì tún padà wá bá a yín.” ");
INSERT INTO yor_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahamu sì gbé igi ẹbọ sísun náà ru Isaaki, òun fúnra rẹ̀ sì mú iná àti ọ̀bẹ. Bí àwọn méjèèjì ti ń lọ, ");
INSERT INTO yor_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaaki sì sọ fún Abrahamu baba rẹ̀ wí pé, “Baba mi.” Abrahamu sì dalóhùn pé, “Èmi nìyí ọmọ mi.” Isaaki sì tún wí pé, “Wò ó iná àti igi nìyí, ṣùgbọ́n níbo ni ọ̀dọ́-àgùntàn fún ẹbọ sísun náà wà?” ");
INSERT INTO yor_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahamu sì dáhùn pé, “Ọmọ mi, Ọlọ́run fúnra rẹ̀ ni yóò pèsè ọ̀dọ́-àgùntàn fún ẹbọ sísun náà.” Bẹ́ẹ̀ ni àwọn méjèèjì jùmọ̀ ń lọ. ");
INSERT INTO yor_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Nígbà tí wọn sì dé ibi tí Ọlọ́run sọ fún Abrahamu, ó mọ pẹpẹ kan, ó sì to igi lé e lórí, ó sì di Isaaki ọmọ rẹ̀, ó sì da dùbúlẹ̀ lórí pẹpẹ náà. ");
INSERT INTO yor_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abrahamu sì nawọ́ mú ọ̀bẹ, láti dúńbú ọmọ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ṣùgbọ́n angẹli Olúwa ké sí i láti ọ̀run wá wí pé “Abrahamu! Abrahamu!” Abrahamu sì dáhùn pé, “Èmi nìyí.” ");
INSERT INTO yor_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Angẹli Olúwa sì wí pé, “Má ṣe fọwọ́ kan ọmọ náà, ìwọ kò sì gbọdọ̀ ṣe é ni ohun kan. Nísinsin yìí ni mo mọ̀ pé o bẹ̀rù Ọlọ́run, nítorí pé ìwọ kò fi ọmọ rẹ, àní, ọmọ rẹ kan ṣoṣo dù mí.” ");
INSERT INTO yor_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrahamu sì gbójú sókè, ó sì rí àgbò kan tí ó fi ìwo há pàǹtírí, ó sì lọ mú un, ó sì fi rú ẹbọ sísun dípò ọmọ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abrahamu sì pe orúkọ ibẹ̀ ni, Jehofah Jire. Bẹ́ẹ̀ ni a sì ń wí títí di òní olónìí pé, “Ní orí òkè Olúwa, ni a ó ti pèsè.” ");
INSERT INTO yor_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Angẹli Olúwa sì tún pe Abrahamu láti ọ̀run wá lẹ́ẹ̀kejì. ");
INSERT INTO yor_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Ó sì wí pé, Olúwa wí pé, “Mo fi ara mi búra, níwọ̀n bí ìwọ ti ṣe èyí, tí ìwọ kò fi ọmọ rẹ, àní, ọmọ rẹ kan ṣoṣo dù mí, ");
INSERT INTO yor_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","nítòótọ́, ní bíbùkún èmi ó bùkún fún ọ, àti ní bíbísí èmi ó sì mú ọ bí sí i bí i ìràwọ̀ ojú ọ̀run àti bí iyanrìn etí Òkun. Irú-ọmọ rẹ yóò sì gba ẹnu ibodè àwọn ọ̀tá wọn, ");
INSERT INTO yor_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","àti nípasẹ̀ irú-ọmọ rẹ ni a ó ti bùkún fún gbogbo orílẹ̀-èdè ayé nítorí tí ìwọ gbọ́rọ̀ sí mi lẹ́nu.” ");
INSERT INTO yor_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Nígbà náà ni Abrahamu padà tọ àwọn ìránṣẹ́ rẹ̀ lọ. Gbogbo wọn sì padà lọ sí Beerṣeba. Abrahamu sì jókòó ní Beerṣeba. ");
INSERT INTO yor_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Lẹ́yìn nǹkan wọ̀nyí ni a wí fún Abrahamu pé, “Milka aya Nahori bí àwọn ọmọkùnrin fún un. ");
INSERT INTO yor_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Usi àkọ́bí rẹ̀, Busi arákùnrin rẹ̀, Kemueli (baba Aramu). ");
INSERT INTO yor_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Haso, Pildasi, Jidlafi, àti Betueli.” ");
INSERT INTO yor_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betueli sì ni baba Rebeka. Milka sì bí àwọn ọmọ mẹ́jọ wọ̀nyí fún Nahori arákùnrin Abrahamu. ");
INSERT INTO yor_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Àlè rẹ̀ tí ń jẹ́ Reuma náà bí àwọn ọmọkùnrin wọ̀nyí fun un: Teba, Gahamu, Tahasi àti Maaka. ");
INSERT INTO yor_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara sì pé ọmọ ọdún mẹ́tàdínláàádóje (127). ");
INSERT INTO yor_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ó sì kú ní Kiriati-Arba (ìyẹn ní Hebroni) ní ilẹ̀ Kenaani, Abrahamu lọ láti ṣọ̀fọ̀ àti láti sọkún nítorí Sara. ");
INSERT INTO yor_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abrahamu sì dìde lẹ́gbẹ̀ẹ́ òkú aya rẹ̀, ó sì sọ fún àwọn ará Hiti wí pé, ");
INSERT INTO yor_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Èmi jẹ́ àtìpó àti àlejò láàrín yín, ẹ ta ilẹ̀ ìsìnkú fún mi kí èmi le sin òkú tí ó kú fún mi sí.” ");
INSERT INTO yor_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Àwọn ọmọ Hiti dá Abrahamu lóhùn pé, ");
INSERT INTO yor_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Olúwa mi, gbọ́ tiwa, ó jẹ́ alágbára ọmọ-aládé láàrín wa, sin òkú rẹ sí ibojì tí ó dára jù nínú àwọn ibojì wa, kò sí ẹni tí yóò fi ibojì rẹ dù ọ́ láti sin òkú rẹ sí.” ");
INSERT INTO yor_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Nígbà náà ni Abrahamu dìde, ó sì tẹríba níwájú àwọn ará ilẹ̀ náà, àwọn ará Hiti. ");
INSERT INTO yor_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ó sì wí fún wọn pé, “Bí ó bá ṣe pé, lóòótọ́ ni ẹ fẹ́ kí n sin òkú mi kúrò nílẹ̀, ẹ gbọ́ tèmi, ẹ bá mi bẹ Efroni ọmọ Sohari, ");
INSERT INTO yor_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kí ó ta ihò àpáta Makpela tí ó jẹ́ tirẹ̀ fún mi, èyí tí ó wà ni orí oko rẹ̀, kí ó tà á fún mi ni iye owó tí à ń ta irú rẹ̀ fún ilẹ̀ ìsìnkú láàrín yín.” ");
INSERT INTO yor_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efroni ará Hiti sì wà níbẹ̀ pẹ̀lú, ó sì dá Abrahamu lóhùn lójú gbogbo àwọn ará ìlú tí ó wà níbẹ̀, lẹ́nu ibodè ìlú, ");
INSERT INTO yor_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","pé, “Rárá, olúwa mi. Gbọ́ tèmi; mo fún ọ ní ilẹ̀ náà àti ihò àpáta tí ó wà níbẹ̀. Mo fún ọ níwájú gbogbo àwọn ènìyàn mi. Sin òkú rẹ síbẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrahamu sì tún tẹríba níwájú àwọn ènìyàn ìlú náà, ");
INSERT INTO yor_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ó sì wí fún Efroni lójú gbogbo wọn pé, “Bí ìwọ bá fẹ́, gbọ́ tèmi, èmi yóò san owó ilẹ̀ náà, gbà á lọ́wọ́ mi kí n lè sin òkú mi síbẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efroni sì dá Abrahamu lóhùn pé, ");
INSERT INTO yor_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Gbọ́ tèmi Olúwa mi, irinwó (400) òsùwọ̀n owó fàdákà ni ilẹ̀ náà, ṣùgbọ́n kín ni ìyẹn já mọ láàrín àwa méjèèjì? Sá à sin òkú rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahamu sì gbọ́ tí Efroni wí, Abrahamu sì wọn iye fàdákà náà fún Efroni, tí ó sọ ní etí àwọn ọmọ Hiti, irinwó (400) òsùwọ̀n ṣékélì fàdákà, tí ó kọjá lọ́dọ̀ àwọn oníṣòwò. ");
INSERT INTO yor_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Báyìí ni ilẹ̀ Efroni tí ó wà ni Makpela nítòsí Mamre, ilẹ̀ náà àti ihò àpáta tí ó wà nínú rẹ̀ àti gbogbo igi tí ó wà nínú ilẹ̀ náà ni a ṣe ètò rẹ̀ dájú, ");
INSERT INTO yor_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","bí ohun ìní fún Abrahamu níwájú gbogbo ará Hiti tí ó wá sí ẹnu ibodè ìlú náà. ");
INSERT INTO yor_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Lẹ́yìn náà ni Abrahamu sin aya rẹ̀ Sara sínú ihò àpáta ní ilẹ̀ Makpela nítòsí Mamre (tí í ṣe Hebroni) ní ilẹ̀ Kenaani. ");
INSERT INTO yor_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ilẹ̀ náà àti ihò àpáta tí ó wà nínú rẹ̀ ni àwọn ará Hiti fi fún Abrahamu gẹ́gẹ́ bí ohun ìní títí láé, bí ilẹ̀ ìsìnkú fún àwọn òkú tí ó bá kú fun un. ");
INSERT INTO yor_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahamu sì ti di arúgbó ní àkókò yìí, Olúwa sì ti bùkún fún un ni gbogbo ọ̀nà, ");
INSERT INTO yor_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abrahamu wí fún olórí àwọn ìránṣẹ́ ilẹ̀ rẹ̀, tí ó jẹ́ alábojútó ohun gbogbo tí ó ní pé, “Fi ọwọ́ rẹ sí abẹ́ itan mi. ");
INSERT INTO yor_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Èmi yóò mú ọ búra lórúkọ Olúwa Ọlọ́run ọ̀run àti ayé, pé, ìwọ kì yóò fẹ́ aya fún ọmọ mi nínú àwọn ọmọbìnrin ará Kenaani, láàrín àwọn ẹni tí èmi ń gbé. ");
INSERT INTO yor_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ṣùgbọ́n, ìwọ yóò lọ sí orílẹ̀-èdè mi, láàrín àwọn ará mi láti fẹ́ aya fún Isaaki, ọmọ mi.” ");
INSERT INTO yor_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ìránṣẹ́ náà bi í wí pé, “Ǹjẹ́ bí ọmọbìnrin náà bá kọ̀ láti bá mi wá sí ilẹ̀ yìí ń kọ́? Ǹjẹ́ mo lè mú ọmọ rẹ padà lọ sí orílẹ̀-èdè níbi tí ìwọ ti wá?” ");
INSERT INTO yor_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahamu sì wí fún un pé, “Rí i dájú pé ìwọ kò mú ọmọ mi padà lọ sí ibẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“Olúwa, Ọlọ́run ọ̀run tí ó mú mi jáde láti ilẹ̀ baba mi àti ní ilẹ̀ tí a bí mi, tí ó bá mi sọ̀rọ̀ tí ó sì búra fún mi pé, ‘Irú-ọmọ rẹ ni n ó fi ilẹ̀ yìí fún,’ yóò rán angẹli rẹ̀ ṣáájú rẹ, kí ìwọ kí ó lè rí aya fẹ́ wá fún ọmọ mi láti ibẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Bí obìnrin náà kò bá fẹ́ tẹ̀lé ọ wá, nígbà náà ni a tú ọ sílẹ̀ kúrò nínú ìbúra yìí, ṣùgbọ́n pàtàkì ni pé ìwọ kò gbọdọ̀ mú ọmọ mi padà lọ sí ibẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ìránṣẹ́ náà sì fi ọwọ́ rẹ̀ sí abẹ́ itan Abrahamu olúwa rẹ̀, ó sì búra fún nítorí ọ̀rọ̀ náà. ");
INSERT INTO yor_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ìránṣẹ́ náà sì mú ìbákasẹ mẹ́wàá, pẹ̀lú onírúurú ohun dáradára láti ọ̀dọ̀ olúwa rẹ̀, ó sì dìde ó sì lọ sí Aramu-Naharaimu, sí ìlú Nahori, ");
INSERT INTO yor_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ó sì mú àwọn ìbákasẹ náà kúnlẹ̀ nítòsí kànga lẹ́yìn ìlú, ó ti ń di ọwọ́ ìrọ̀lẹ́ ní àkókò tí àwọn obìnrin máa ń lọ pọn omi. ");
INSERT INTO yor_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ó sì gbàdúrà wí pé, “Olúwa, Ọlọ́run Abrahamu olúwa à mi; jẹ́ kí n ṣe àṣeyọrí lónìí, sì fi àánú hàn fún Abrahamu olúwa mi. ");
INSERT INTO yor_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kíyèsi i, mo dúró ní ẹ̀bá kànga omi yìí, àwọn ọmọbìnrin ìlú yìí sì ń jáde wá pọn omi. ");
INSERT INTO yor_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Jẹ́ kí ó ṣe pé nígbà tí mo bá wí fún ọ̀kan nínú àwọn ọmọbìnrin pe, ‘Jọ̀wọ́ sọ ládugbó rẹ kalẹ̀, kí n le mu omi,’ tí ó bá sì wí pé, ‘Mu ún, èmi ó sì fún àwọn ìbákasẹ rẹ náà mu pẹ̀lú,’ jẹ́ kí ó ṣe èyí tí o yàn fún ìránṣẹ́ rẹ Isaaki. Nípa èyí ni n ó fi mọ̀ pé o ti fi àánú hàn fún olúwa mi.” ");
INSERT INTO yor_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Kí o tó di pé, ó parí àdúrà, Rebeka dé pẹ̀lú ìkòkò omi rẹ̀ ní èjìká rẹ̀. Ọmọ Betueli ni. Betueli yìí ni Milka bí fún Nahori arákùnrin Abrahamu. ");
INSERT INTO yor_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ọmọbìnrin náà rẹwà, wúńdíá ni, kò sì tí ì mọ ọkùnrin, ó lọ sí ibi ìsun omi náà, ó sì pọn omi sínú ìkòkò omi, ó sì gbé e, ó ń gòkè bọ̀ kúrò níbi omi. ");
INSERT INTO yor_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ìránṣẹ́ náà súré lọ pàdé rẹ̀, ó sì wí fun un pé, “Jọ̀wọ́ fún mi ni omi díẹ̀ nínú ìkòkò omi rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Òun náà dáhùn pé, “Mu, olúwa mi,” ó sì yára sọ ìkòkò omi náà ka ọwọ́ rẹ̀, ó sì fún un mu. ");
INSERT INTO yor_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Lẹ́yìn tí ó ti fún un ni omi mu tán, ó wí pé, “Èmi ó bu omi fún àwọn ìbákasẹ rẹ pẹ̀lú títí wọn yóò fi mu àmutẹ́rùn.” ");
INSERT INTO yor_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ó sì yára da omi inú ìkòkò omi rẹ̀ sínú ìbùmu, ó sáré padà lọ sí ibi omi láti pọn sí i wá fún àwọn ìbákasẹ, títí tí ó fi pọn fún gbogbo wọn. ");
INSERT INTO yor_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Láìsọ ọ̀rọ̀ kan, ìránṣẹ́ yìí ń wo ọmọbìnrin náà fínní fínní láti mọ̀ bóyá Olúwa ti ṣe ìrìnàjò òun ní rere tàbí bẹ́ẹ̀ kọ́. ");
INSERT INTO yor_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Lẹ́yìn tí àwọn ìbákasẹ náà ti mu omi tán, ni ọkùnrin náà mú òrùka wúrà ààbọ̀ ìwọ̀n ṣékélì àti júfù méjì fún ọwọ́ rẹ̀, tí ìwọ̀n ṣékélì wúrà mẹ́wàá. ");
INSERT INTO yor_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Lẹ́yìn náà, ó béèrè pé, “Ọmọ ta ni ìwọ í ṣe? Jọ̀wọ́ wí fún mi, ǹjẹ́ ààyè wà ní ilé baba rẹ láti wọ̀ sí ní alẹ́ yìí?” ");
INSERT INTO yor_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ó dáhùn pé, “Betueli ọmọ tí Milka bí fún Nahori ni baba mi.” ");
INSERT INTO yor_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ó sì fi kún un pé, “Àwa ní koríko àti ṣakaṣaka tó pẹ̀lú, àti ààyè láti wọ̀ sí.” ");
INSERT INTO yor_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nígbà náà ni ọkùnrin náà tẹríba, ó sì sin Olúwa, ");
INSERT INTO yor_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","wí pe, “Olùbùkún ni fún Olúwa, Ọlọ́run Abrahamu olúwa mi ti kò jẹ́ kí àánú àti òtítọ́ rẹ̀ kí ó yẹ̀ lọ́dọ̀ olúwa mi. Ní ti èmi Olúwa ti darí ìrìnàjò mi sí ilé ìbátan olúwa mi.” ");
INSERT INTO yor_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ọmọbìnrin náà sì sáré, ó sì lọ sọ ohun gbogbo wọ̀nyí fún àwọn ará ilé ìyá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka ní arákùnrin tí ń jẹ́ Labani; Labani sì sáré lọ bá ọkùnrin náà ní etí odò. ");
INSERT INTO yor_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Bí ó sì ti rí òrùka imú àti ẹ̀gbà ní ọwọ́ arábìnrin rẹ̀ tí ó sì tún gbọ́ ohun tí Rebeka sọ pé ọkùnrin náà sọ fún òun, ó jáde lọ bá ọkùnrin náà, ó sì bá a, ó dúró ti ìbákasẹ wọ̀n-ọn-nì ní ẹ̀bá ìsun omi. ");
INSERT INTO yor_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ó wí fún ọkùnrin náà pé, “Wá, ìwọ ẹni ìbùkún Olúwa, èéṣe tí o dúró sí ìta níhìn-ín? Mo ti pèsè ààyè sílẹ̀ fún ọ àti ààyè fún àwọn ìbákasẹ rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ọkùnrin náà sì bá Labani lọ ilé, ó sì tú ẹrù orí ìbákasẹ rẹ̀ sílẹ̀, ó sì fún wọn ni koríko àti oúnjẹ. Ó sì bu omi fún ọkùnrin náà àti àwọn arákùnrin rẹ̀ láti wẹ ẹsẹ̀ wọn. ");
INSERT INTO yor_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Wọ́n sì gbé oúnjẹ síwájú rẹ̀, ṣùgbọ́n, ó wí pé, “Èmi kò ní jẹun àyàfi bí mo bá sọ ohun tí mo ní í sọ.” Labani sì wí pé, “Kò burú, sọ ọ́.” ");
INSERT INTO yor_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Nítorí náà, ó wí pé, “Ìránṣẹ́ Abrahamu ni èmi. ");
INSERT INTO yor_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Olúwa sì ti bùkún olúwa mi gidigidi. Ó sì ti di ọlọ́rọ̀, Ó sì ti fún un ní àgùntàn, màlúù, àti fàdákà àti wúrà, ìránṣẹ́kùnrin àti ìránṣẹ́bìnrin àti ìbákasẹ àti kẹ́tẹ́kẹ́tẹ́. ");
INSERT INTO yor_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara aya olúwa mi sì ti bí ọmọkùnrin kan fún un, ní ìgbà ogbó rẹ̀, olúwa mi sì ti fún ọmọ náà ní ohun gbogbo tí ó ní. ");
INSERT INTO yor_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Olúwa mi sì ti mú mi búra wí pé, ‘Ìwọ kò gbọdọ̀ fẹ́ aya fún ọmọ mi, láàrín àwọn ọmọbìnrin Kenaani, ní ilẹ̀ ibi tí èmi ń gbé, ");
INSERT INTO yor_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ṣùgbọ́n lọ sí ìdílé baba mi láàrín àwọn ìbátan mi kí o sì fẹ́ aya fún ọmọ mi.’ ");
INSERT INTO yor_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Mo sì bí olúwa mi léèrè pé, ‘Ǹjẹ́ bí ọmọbìnrin náà kò bá fẹ́ bá mi wá ń kọ́?’ ");
INSERT INTO yor_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ó sì dáhùn wí pé, ‘Olúwa, níwájú ẹni tí èmi ń rìn yóò rán Angẹli rẹ̀ ṣáájú rẹ yóò sì jẹ́ kí o ṣe àṣeyọrí ní ìrìnàjò rẹ, kí ìwọ kí ó ba le fẹ́ aya fún ọmọ mi, láàrín àwọn ìbátan mi, àti láàrín àwọn ìdílé baba mi. ");
INSERT INTO yor_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Nígbà tí ìwọ bá lọ sí ọ̀dọ̀ ìdílé baba mi (gẹ́gẹ́ bí mo tí wí), nígbà náà ni ìwọ tó bọ́ nínú ìbúra yìí.’ ");
INSERT INTO yor_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Nígbà tí mo dé ibi ìsun omi lónìí, mo wí pé, ‘Olúwa Ọlọ́run Abrahamu olúwa mi, bí ìwọ bá fẹ́, jọ̀wọ́ jẹ́ kí n ṣe àṣeyọrí lórí ohun tí mo bá wá yìí. ");
INSERT INTO yor_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Wò ó, mo dúró ní ẹ̀bá ìsun omi yìí, kí ó ṣe pé, nígbà tí wúńdíá kan bá jáde wá pọn omi, tí èmi sì wí fún un pé, “Jọ̀wọ́ fún mi ní ìwọ̀nba omi díẹ̀ mu nínú ládugbó rẹ,” ");
INSERT INTO yor_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","tí ó bá sì wí fún mi pé, “Mu ún, èmi yóò sì tún pọn omi fún àwọn ìbákasẹ rẹ pẹ̀lú,” jẹ́ kí ẹni náà jẹ́ ẹni tí Olúwa yàn fún ọmọ Abrahamu, olúwa mi.’ ");
INSERT INTO yor_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Kí n sì tó gbàdúrà tán nínú ọkàn mi, Rebeka jáde wá pẹ̀lú ìkòkò omi rẹ̀ ní èjìká rẹ̀, ó sì lọ sí ibi ìsun omi ó sì pọn omi. Mo sì wí fun un pé, ‘Jọ̀wọ́ fún mi ni omi mu.’ ");
INSERT INTO yor_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Kíákíá ni ó sọ ìkòkò rẹ̀ kalẹ̀ láti èjìká rẹ̀, ó sì wí fún mi pé, ‘Mu ún, èmi yóò sì tún fún àwọn ìbákasẹ rẹ mu pẹ̀lú.’ Mo sì mu, ó sì tún fún àwọn ìbákasẹ mi mu pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Mo béèrè lọ́wọ́ rẹ̀ pé, ‘Ọmọ ta ní ìwọ í ṣe?’ “Ó sì wí fún mi pé, ‘Ọmọbìnrin Betueli tí í ṣe ọmọ Nahori ni òun, Milka sì ni ìyá òun.’ “Nígbà náà ni mo fi òrùka náà bọ imú rẹ̀, mo sì fi ẹ̀gbà ọwọ́ náà si ní ọwọ́. ");
INSERT INTO yor_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Èmi sì tẹríba, mo sì wólẹ̀ fún Olúwa, mó sì fi ìbùkún fún Ọlọ́run Abrahamu olúwa mi, ẹni tí ó mú mi tọ ọ̀nà títọ́ láti rí ọmọ ọmọ arákùnrin olúwa mi mú wá fún ọmọ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ǹjẹ́ nísinsin yìí bí ẹ̀yin yóò bá fi inú rere àti òtítọ́ bá olúwa mi lò, ẹ sọ fún mi, bí bẹ́ẹ̀ sì kọ́, ẹ sọ fún mi, kí ń le è mọ ọ̀nà tí èmi yóò yà sí.” ");
INSERT INTO yor_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labani àti Betueli sì dáhùn pé, “Lọ́dọ̀ Olúwa ni èyí ti wá, nítorí náà àwa kò le sọ rere tàbí búburú fún ọ. ");
INSERT INTO yor_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka nìyí, mú un kí ó máa lọ, kí ó sì di aya ọmọ olúwa à rẹ, bí Olúwa ti fẹ́.” ");
INSERT INTO yor_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Nígbà tí ọmọ ọ̀dọ̀ Abrahamu gbọ́ ohun tí wọ́n wí, ó wólẹ̀ níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Nígbà náà ni ó kó ohun èlò wúrà àti fàdákà jáde àti aṣọ, ó sì fi wọ́n fún Rebeka, ó fún arákùnrin Rebeka àti ìyá rẹ̀ ní ẹ̀bùn olówó iyebíye pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Lẹ́yìn náà ni òun àti àwọn ọkùnrin tí ó bá a wá tó jẹ, tí wọ́n sì mu, tí wọn sì sùn níbẹ̀ ní òru ọjọ́ náà. Bí wọ́n ti dìde ní òwúrọ̀ ọjọ́ kejì, ó wí pé, “Ẹ rán mi padà lọ sí ọ̀dọ̀ olúwa mi.” ");
INSERT INTO yor_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ṣùgbọ́n arákùnrin Rebeka àti ìyá rẹ̀ fèsì pé, “A fẹ́ kí Rebeka wà pẹ̀lú wa fún nǹkan bí ọjọ́ mẹ́wàá sí i, lẹ́yìn èyí, ìwọ le máa mu lọ.” ");
INSERT INTO yor_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ṣùgbọ́n ó wí fún wọn pé, “Ẹ má ṣe dá mi dúró, Olúwa sá à ti ṣe ọ̀nà mi ní rere. Ẹ rán mi lọ, kí èmi kí ó le è tọ olúwa à mi lọ.” ");
INSERT INTO yor_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Nígbà náà ni wọ́n sọ pé, “Jẹ́ kí a pe ọmọ náà gan an kí a sì bi í.” ");
INSERT INTO yor_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Wọ́n sì pe Rebeka wọ́n sì bi í, wí pé, “Ṣe ìwọ yóò bá ọkùnrin yìí lọ.” Ó sì dáhùn pé, “Bẹ́ẹ̀ ni, èmi yóò lọ.” ");
INSERT INTO yor_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Wọ́n sì gbà kí Rebeka àti olùtọ́jú rẹ̀, pẹ̀lú ìránṣẹ́ Abrahamu àti àwọn ọkùnrin tí ó wà pẹ̀lú rẹ̀ máa lọ. ");
INSERT INTO yor_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Wọ́n sì súre fún Rebeka, wọn sì wí fun un pé, “Ìwọ ni arábìnrin wa ìwọ yóò di ìyá ẹgbẹ̀rún lọ́nà ẹgbẹ̀rún; ǹjẹ́ kí àwọn irú-ọmọ rẹ kí ó ni ẹnu ibodè ọ̀tá wọn.” ");
INSERT INTO yor_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Nígbà náà ni Rebeka àti àwọn ìránṣẹ́bìnrin rẹ̀ múra, wọn sì gun àwọn ìbákasẹ, wọ́n sì bá ọkùnrin náà padà lọ. Ìránṣẹ́ náà sì mú Rebeka, ó sì bá tirẹ̀ lọ. ");
INSERT INTO yor_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaaki sì ń ti ọ̀nà kànga Lahai-Roi bọ, nítorí ìhà gúúsù ni ó ń gbé. ");
INSERT INTO yor_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaaki sì jáde lọ sí oko ni ìrọ̀lẹ́ láti ṣe àṣàrò, bí ó sì ti gbé ojú sókè, ó rí àwọn ìbákasẹ tí ń bọ̀ wá. ");
INSERT INTO yor_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka pẹ̀lú sì gbójú sókè, ó sì rí Isaaki. Ó sọ̀kalẹ̀ lórí ìbákasẹ, ");
INSERT INTO yor_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ó sì béèrè lọ́wọ́ ìránṣẹ́ náà wí pé, “Ta ni ọkùnrin tí ń bọ̀ wá pàdé wa láti inú oko?” Ìránṣẹ́ náà sì wí fun un pé, “Olúwa mi ni,” nítorí náà ni Rebeka mú ìbòjú, ó sì bo ojú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nígbà náà ni ìránṣẹ́ náà ròyìn fún Isaaki ohun gbogbo tí ó ti ṣe. ");
INSERT INTO yor_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Nígbà náà ni Isaaki mú Rebeka wọ inú àgọ́ ìyá rẹ̀, Sara, ó sì di aya rẹ̀, ó sì fẹ́ràn rẹ̀; ó sì jẹ́ ìtùnú fún Isaaki lẹ́yìn ikú ìyá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamu sì tún fẹ́ aya mìíràn, tí orúkọ rẹ̀ ń jẹ́ Ketura. ");
INSERT INTO yor_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ó sì bí Simrani, Jokṣani, Medani, Midiani, Iṣbaki, àti Ṣua ");
INSERT INTO yor_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokṣani ni baba Ṣeba àti Dedani, àwọn ìran Dedani ni àwọn ara Asṣuri, Letusi àti Leumiti. ");
INSERT INTO yor_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Àwọn ọmọ Midiani ni Efani, Eferi, Hanoku, Abida àti Eldaa. Gbogbo àwọn wọ̀nyí ni ìran Ketura. ");
INSERT INTO yor_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahamu sì fi ohun gbogbo tí ó ní fún Isaaki. ");
INSERT INTO yor_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ṣùgbọ́n kí Abrahamu tó kú, Abrahamu fún àwọn ọmọ tí àwọn àlè rẹ̀ bí fún un ní ẹ̀bùn, ó sì lé wọn jáde lọ fún Isaaki ọmọ rẹ sí ilẹ̀ ìlà-oòrùn. ");
INSERT INTO yor_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Gbogbo àpapọ̀ ọdún tí Abrahamu lò láyé jẹ́ igba kan ó dín mẹ́ẹ̀ẹ́dọ́gbọ̀n (175). ");
INSERT INTO yor_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abrahamu sì kú ní ọjọ́ ogbó rẹ̀. Ó dàgbà, ó darúgbó kí ó tó kú. A sì sin ín sí ibojì àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Àwọn ọmọ rẹ̀, Isaaki àti Iṣmaeli sì sin ín sínú ihò àpáta ni Makpela ní ẹ̀gbẹ́ Mamre, ní oko Efroni ọmọ Sohari ará Hiti, ");
INSERT INTO yor_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","inú oko tí Abrahamu rà lọ́wọ́ ara Hiti yìí ni a sin Abrahamu àti Sara aya rẹ̀ sí. ");
INSERT INTO yor_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Lẹ́yìn ikú Abrahamu, Ọlọ́run sì bùkún fún Isaaki ọmọ rẹ̀, tí ó ń gbé nítòsí kànga Lahai-Roi ní ìgbà náà. ");
INSERT INTO yor_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Wọ̀nyí ni ìran Iṣmaeli, ọmọ Abrahamu ẹni tí Hagari ará Ejibiti, ọmọ ọ̀dọ̀ Sara bí fún un. ");
INSERT INTO yor_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Wọ̀nyí ni orúkọ àwọn ọmọ Iṣmaeli bí a ṣe bí wọn, bẹ̀rẹ̀ láti orí: Nebaioti àkọ́bí, Kedari, Adbeeli, Mibsamu, ");
INSERT INTO yor_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Miṣima, Duma, Massa, ");
INSERT INTO yor_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi, Tema, Jeturi, Nafiṣi, àti Kedema. ");
INSERT INTO yor_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Wọ̀nyí sì ni orúkọ àwọn ọmọ Iṣmaeli, wọ̀nyí ni orúkọ àwọn ọba méjìlá gẹ́gẹ́ bí ẹ̀yà wọn. ");
INSERT INTO yor_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Àpapọ̀ ọdún tí Iṣmaeli lò láyé jẹ́ ẹ̀tàdínlógóje (137) ọdún, a sì sin ín pẹ̀lú àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Àwọn ìran rẹ̀ sì tẹ̀dó sí agbègbè Hafila títí tí ó fi dé Ṣuri, ní ẹ̀bá ààlà Ejibiti, bí ìwọ ti ń lọ sí ìhà Asiria. Ó sì kú níwájú àwọn arákùnrin rẹ̀ gbogbo. ");
INSERT INTO yor_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Wọ̀nyí ni ìtàn ìran Isaaki ọmọ Abrahamu. Abrahamu bí Isaaki. ");
INSERT INTO yor_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Nígbà tí Isaaki di ọmọ ogójì ọdún ni ó gbé Rebeka ọmọ Betueli ará Aramu ti Padani-Aramu tí í ṣe arábìnrin Labani ará Aramu ní ìyàwó. ");
INSERT INTO yor_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaaki sì gbàdúrà sì Olúwa, nítorí aya rẹ̀ tí ó yàgàn, Olúwa sì gbọ́ àdúrà rẹ̀, Rebeka sì lóyún. ");
INSERT INTO yor_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Àwọn ọmọ náà ń gbún ara wọn nínú rẹ̀, ó sì wí pé, “Èéṣe tí èyí ń ṣẹlẹ̀ sí mi,” ó sì lọ béèrè lọ́dọ̀ Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Olúwa sì wí fún un pé, “Orílẹ̀-èdè méjì ni ń bẹ nínú rẹ, irú ènìyàn méjì ni yóò yà láti inú rẹ; àwọn ènìyàn kan yóò jẹ́ alágbára ju èkejì lọ, ẹ̀gbọ́n ni yóò máa sin àbúrò.” ");
INSERT INTO yor_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Nígbà tí ó tó àkókò fún un láti bímọ, ìbejì ni ó wà nínú rẹ̀, ọkùnrin sì ni wọ́n. ");
INSERT INTO yor_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Èyí tí ó kọ jáde jẹ́ ọmọ pupa, irun sì bo gbogbo ara rẹ̀ bí aṣọ onírun, nítorí náà, wọ́n pè é ní Esau. ");
INSERT INTO yor_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Lẹ́yìn èyí ni arákùnrin èkejì jáde wá, ọwọ́ rẹ̀ sì di Esau ni gìgísẹ̀ mú, nítorí náà ni wọn ṣe pe orúkọ rẹ ni Jakọbu. Ọmọ ọgọ́ta ọdún ni Isaaki, nígbà tí Rebeka bí wọn. ");
INSERT INTO yor_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Àwọn ọmọkùnrin náà sì dàgbà. Esau sì di ọlọ́gbọ́n ọdẹ, ẹni tí ó fẹ́ràn àti máa dúró ní oko. Jakọbu sì jẹ́ ènìyàn jẹ́ẹ́jẹ́ tí ó ń gbé láàrín ìlú. ");
INSERT INTO yor_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaaki, ẹni tí ó fẹ́ràn ẹran igbó fẹ́ràn Esau nítorí ẹran igbó tí Esau máa ń pa, ṣùgbọ́n Rebeka fẹ́ràn Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ní ọjọ́ kan, Jakọbu sì pa ìpẹ̀tẹ̀, Esau sì ti igbó ọdẹ dé, ó sì ti rẹ̀ ẹ́. ");
INSERT INTO yor_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau wí fún Jakọbu pé, “Èmí bẹ̀ ọ, fi ìpẹ̀tẹ̀ rẹ pupa n nì bọ́ mi, nítorí tí ó rẹ̀ mí gidigidi.” (Nítorí náà ni a ṣe ń pe orúkọ rẹ̀ ní Edomu.) ");
INSERT INTO yor_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakọbu dáhùn pé, “Kò burú, ṣùgbọ́n kọ́kọ́ ta ogún ìbí rẹ fún mi ná.” ");
INSERT INTO yor_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau sì dáhùn pé, “Wò ó mo ti fẹ́rẹ kú, àǹfààní kín sì ni ogún ìbí jẹ́ fún mi?” ");
INSERT INTO yor_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ṣùgbọ́n, Jakọbu dáhùn pé, “Kọ́kọ́ búra fún mi pé tèmi ni ogún ìbí náà yóò jẹ́.” Báyìí ni Esau búra tí ó sì gbé ogún ìbí rẹ̀ tà fún Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Nígbà náà ni Jakọbu fi àkàrà àti ìpẹ̀tẹ̀ lẹntili fún Esau. Ó sì jẹ, ó sì mu, ó sì bá tirẹ̀ lọ. Báyìí ni Esau gan ogún ìbí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ìyàn kan sì mú ní ilẹ̀ náà, yàtọ̀ fún èyí tí ó mú ní ìgbà ayé Abrahamu, Isaaki sì lọ sọ́dọ̀ Abimeleki ọba àwọn Filistini ni Gerari. ");
INSERT INTO yor_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Olúwa sì fi ara han Isaaki, ó sì wí pé, “Má ṣe sọ̀kalẹ̀ lọ sí Ejibiti, jókòó ní ilẹ̀ tí èmi ó fún ọ. ");
INSERT INTO yor_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Máa ṣe àtìpó ní ilẹ̀ yìí fún ìgbà díẹ̀, èmi ó sì wà pẹ̀lú rẹ, èmi yóò sì bùkún fún ọ. Nítorí ìwọ àti irú-ọmọ rẹ ni èmi yóò fi gbogbo àwọn ilẹ̀ wọ̀nyí fún, èmi yóò sì fi ìdí ìbúra tí mo ṣe fún Abrahamu baba rẹ múlẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Èmi yóò sọ ìran rẹ di púpọ̀ bí ìràwọ̀ ojú ọ̀run, èmi yóò sì fi gbogbo ilẹ̀ yìí fún irú àwọn ọmọ rẹ, àti nípasẹ̀ irú-ọmọ rẹ ni a ó bùkún fún gbogbo orílẹ̀-èdè ayé, ");
INSERT INTO yor_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","nítorí tí Abrahamu gba ohùn mi gbọ́, ó sì pa gbogbo ìkìlọ̀, àṣẹ, ìlànà àti òfin mi mọ́.” ");
INSERT INTO yor_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Nítorí náà Isaaki jókòó ní Gerari. ");
INSERT INTO yor_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Nígbà tí àwọn ọkùnrin ìlú náà bi í léèrè ní ti aya rẹ̀, ó sì wí pé, “Arábìnrin mi ní í ṣe,” nítorí tí ó bẹ̀rù láti jẹ́wọ́ wí pé, “Aya mi ni.” Ó ń rò wí pé, “Kí àwọn ọkùnrin ibẹ̀ náà má ba à pa mí nítorí Rebeka, nítorí tí òun ní ẹwà púpọ̀.” ");
INSERT INTO yor_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nígbà tí Isaaki sì ti wà níbẹ̀ fún ọ̀pọ̀lọpọ̀ ọjọ́, Abimeleki ọba Filistini yọjú lójú fèrèsé, ó sì rí Isaaki ń bá Rebeka aya rẹ̀ tage. ");
INSERT INTO yor_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Nígbà náà ni Abimeleki ránṣẹ́ pe Isaaki ó sì wí fun pé, “Nítòótọ́, aya rẹ ni obìnrin yìí í ṣe, èéṣe tí ìwọ fi wí fún wa pé arábìnrin mi ni?” Isaaki sì fèsì pé, “Nítorí mo rò pé mo le pàdánù ẹ̀mí mi nítorí rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Nígbà náà ni Abimeleki dáhùn pé, “Èwo ni èyí tí ìwọ ṣe sí wa yìí? Bí ọ̀kan nínú àwọn ènìyàn wọ̀nyí bá ti bá a lòpọ̀ ń kọ́? Ìwọ ìbá wá mú ẹ̀bi wá sórí wa.” ");
INSERT INTO yor_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Nígbà náà ni Abimeleki pàṣẹ fún gbogbo ènìyàn pé, “Ẹnikẹ́ni tí ó bá fọwọ́ kan ọkùnrin yìí tàbí aya rẹ̀ yóò jẹ̀bi ikú.” ");
INSERT INTO yor_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ní ọdún náà, Isaaki gbin ohun ọ̀gbìn sí ilẹ̀ náà, ó sì kórè rẹ̀ ní ìlọ́po ọgọ́rùn-ún ọdún ni ọdún kan náà, nítorí Olúwa bùkún un. ");
INSERT INTO yor_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ọkùnrin náà sì di ọlọ́rọ̀ púpọ̀, ọrọ̀ rẹ̀ sì ń pọ̀ si, títí ó fi di ènìyàn ńlá. ");
INSERT INTO yor_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ó ní ọ̀pọ̀lọpọ̀ ẹran ọ̀sìn àti agbo ẹran àti àwọn ìránṣẹ́ tó bẹ́ẹ̀ tí àwọn Filistini ń ṣe ìlara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Nítorí náà àwọn ará Filistini ru erùpẹ̀ di gbogbo kànga tí àwọn ìránṣẹ́ Abrahamu baba rẹ̀ ti gbẹ́. ");
INSERT INTO yor_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Nígbà náà ni Abimeleki wí fún Isaaki pé, “Jáde kúrò ní ilẹ̀ wa, nítorí tí ìwọ ti di alágbára púpọ̀ jù wá lọ.” ");
INSERT INTO yor_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaaki sì ṣí kúrò níbẹ̀, ó sì pàgọ́ sí àfonífojì Gerari ó sì ń gbé ibẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaaki sì ṣe àtúngbẹ́ àwọn kànga tí Abrahamu baba rẹ̀ ti gbẹ́ nígbà ayé rẹ̀, èyí tí àwọn Filistini ti dí lẹ́yìn ikú Abrahamu baba rẹ̀, ó sì fún wọn lórúkọ tí baba rẹ̀ ti sọ wọ́n tẹ́lẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Àwọn ìránṣẹ́ Isaaki sì gbẹ́ kànga ní àfonífojì náà, wọ́n kan ìsun omi níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ṣùgbọ́n àwọn darandaran Gerari ń bá àwọn darandaran Isaaki jà sí kànga náà pé àwọn ni àwọn ni í. Nítorí náà ni ó fi pe orúkọ kànga náà ní Eseki, nítorí pé wọ́n bá a jà sí kànga náà. ");
INSERT INTO yor_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Àwọn ìránṣẹ́ Isaaki tún gbẹ́ kànga mìíràn, wọ́n sì tún jà nítorí rẹ̀ pẹ̀lú, ó sì sọ orúkọ rẹ̀ ní Sitna. ");
INSERT INTO yor_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ó sì tún kúrò níbẹ̀, ó sì gbẹ́ kànga mìíràn, wọn kò sì jásí èyí rárá, ó sì pe orúkọ rẹ̀ ní Rehoboti, ó wí pé, “Nísinsin yìí, Olúwa ti fi ààyè gbà wá, a ó sì gbilẹ̀ si ní ilẹ̀ náà.” ");
INSERT INTO yor_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Láti ibẹ̀, ó kúrò lọ sí Beerṣeba. ");
INSERT INTO yor_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ní òru ọjọ́ tí ó dé ibẹ̀, Olúwa sì fi ara hàn án, ó sì wí pé, “Èmi ni Ọlọ́run Abrahamu baba rẹ. Má ṣe bẹ̀rù nítorí èmi wà pẹ̀lú rẹ, èmi yóò sì bùsi fún ọ, èmi yóò sì sọ iye ìran rẹ di púpọ̀, nítorí Abrahamu ìránṣẹ́ mi.” ");
INSERT INTO yor_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaaki sì kọ́ pẹpẹ kan síbẹ̀, ó sì pe orúkọ Olúwa. Níbẹ̀ ni ó pàgọ́ rẹ̀ sí, àwọn ìránṣẹ́ rẹ sì gbẹ́ kànga kan níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nígbà náà ni Abimeleki tọ̀ ọ́ wá láti Gerari, àti Ahussati, olùdámọ̀ràn rẹ̀ àti Fikoli, olórí ogun rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaaki sì bi wọ́n léèrè pé, “Èéṣe tí ẹ̀yin tọ̀ mí wá, níwọ̀n ìgbà tí ẹ̀yin kórìíra mi tí ẹ sì lé mi jáde kúrò lọ́dọ̀ yín?” ");
INSERT INTO yor_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Wọ́n dáhùn pé, “A rí i dájú pé Olúwa wà pẹ̀lú rẹ, nítorí náà ni a fi rò ó wí pé, ó yẹ kí májẹ̀mú kí o wà láàrín àwa àti ìwọ. Jẹ́ kí a ṣe àdéhùn ");
INSERT INTO yor_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","pé ìwọ kì yóò ṣe wá ní ibi, bí àwa pẹ̀lú kò ti ṣe ọ́ ní aburú, tí a sì ń ṣe ọ́ dáradára, tí a sì rán ọ jáde ní àlàáfíà láìṣe ọ́ ní ibi, kíyèsi Olúwa sì ti bùkún fún ọ.” ");
INSERT INTO yor_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaaki sì ṣe àsè fún wọn, wọn sì jẹ, wọ́n sì mu. ");
INSERT INTO yor_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ní òwúrọ̀ ọjọ́ kejì wọn búra fún ara wọn. Isaaki sì rán wọn lọ, wọ́n sì lọ ní àlàáfíà. ");
INSERT INTO yor_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ní ọjọ́ náà gan an ni àwọn ìránṣẹ́ Isaaki wá sọ fún un pé àwọn ti kan omi ní kànga kan tí àwọn gbẹ́. ");
INSERT INTO yor_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ó sì pe orúkọ kànga náà ní Ṣiba, títí di òní olónìí, orúkọ ìlú náà ni Beerṣeba. ");
INSERT INTO yor_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Nígbà tí Esau pé ọmọ ogójì ọdún ó fẹ́ ọmọbìnrin kan tí a ń pè ní Juditi, ọmọ Beeri, ará Hiti, ó sì tún fẹ́ Basemati, ọmọ Eloni ará Hiti. ");
INSERT INTO yor_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Fífẹ́ tí a fẹ́ àwọn obìnrin wọ̀nyí jẹ́ ìbànújẹ́ fún Isaaki àti Rebeka. ");
INSERT INTO yor_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Nígbà ti Isaaki di arúgbó, ojú rẹ̀ sì ti di bàìbàì tó bẹ́ẹ̀ tí kò le ríran. Ó pe Esau àkọ́bí rẹ̀, ó sì wí fún un pé, “Ọmọ mi.” Esau sì dáhùn pé, “Èmi nìyí.” ");
INSERT INTO yor_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaaki sì wí pé, “Nísinsin yìí mo di arúgbó, èmi kò sì mọ ọjọ́ tí èmi yóò kú. ");
INSERT INTO yor_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nítorí náà, mú ohun èlò ọdẹ rẹ, apó àti ọrún, nísinsin yìí kí o sì lọ pa ẹran wá fún mi nínú igbó. ");
INSERT INTO yor_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kí o sì ṣe ẹran àdídùn fún mi, irú èyí tí mo fẹ́ràn, kí o gbe wá fún mi kí n jẹ, kí n sì súre fún ọ kí n tó kú.” ");
INSERT INTO yor_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ṣùgbọ́n Rebeka ń fetí léko gbọ́ nígbà tí Isaaki ń bá Esau ọmọ rẹ̀ sọ̀rọ̀. Nítorí náà, nígbà ti Esau ti ṣe ọdẹ lọ sínú igbó, ");
INSERT INTO yor_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka sọ fún Jakọbu ọmọ rẹ̀ pé, “Wò ó, mo gbọ́ tí baba rẹ ń wí fún Esau ẹ̀gbọ́n rẹ pé, ");
INSERT INTO yor_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Pa ẹran fún mi wá, kí o sì ṣe oúnjẹ àdídùn fún mi láti jẹ, kí n ba à le súre fún ọ níwájú Olúwa kí èmi tó kú.’ ");
INSERT INTO yor_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nísinsin yìí ọmọ mi, gbọ́ tèmi, kí o sì ṣe ohun tí èmi yóò wí fún ọ. ");
INSERT INTO yor_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Lọ sínú agbo ẹran, kí o sì mú ọmọ ewúrẹ́ méjì, kí ó lè ṣe oúnjẹ àdídùn fún baba rẹ, irú èyí tí ó fẹ́ràn dáradára. ");
INSERT INTO yor_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ìwọ yóò sì gbé e tọ baba rẹ lọ, kí òun ba à lè jẹ ẹ́, kí ó sì súre fún ọ, kí ó tó kú.” ");
INSERT INTO yor_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakọbu sì wí fún Rebeka ìyá rẹ̀ pé, “Ṣùgbọ́n Esau ẹ̀gbọ́n mi jẹ́ ènìyàn onírun lára, bẹ́ẹ̀ alára ọ̀bọ̀rọ́ sì ni èmi, ");
INSERT INTO yor_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","bí baba mi bá fọwọ́ kàn mi ń kọ́? Èmi yóò jọ ẹlẹ́tàn lójú rẹ̀, dípò kí ó súre fún mi, èmi yóò sì mú ègún wá sórí ara mi.” ");
INSERT INTO yor_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ìyá rẹ̀ wá wí fun un pé, “Ọmọ mi jẹ́ kí ègún náà wá sórí mi, sá à ṣe ohun tí mo wí, kí o sì mú wọn wá fún mi.” ");
INSERT INTO yor_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jakọbu sì ṣe ohun gbogbo tí ìyá rẹ̀ wí fun un, Rebeka sì ṣe oúnjẹ àdídùn náà, irú èyí tí Isaaki fẹ́ràn. ");
INSERT INTO yor_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Nígbà náà ni Rebeka mú èyí tí ó dára jù nínú aṣọ Esau ọmọ rẹ̀ àgbà tí ó wà nínú ilé Rebeka, ó sì fi wọ Jakọbu ọmọ rẹ̀ àbúrò. ");
INSERT INTO yor_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ó sì fi awọ ewúrẹ́ wọ̀n-ọn-nì bo ọwọ́ àti ibi tí ọ̀bọ̀rọ́ ọrùn. ");
INSERT INTO yor_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Nígbà náà ni ó gbé ẹran dídùn náà àti oúnjẹ tí ó ti sè lé Jakọbu ọmọ rẹ̀ lọ́wọ́. ");
INSERT INTO yor_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jakọbu wọlé lọ sí ọ̀dọ̀ baba rẹ̀ ó sì wí pé, “Baba mi.” Baba rẹ sì dáhùn pé, “Èmi nìyí, ìwọ ta ni, ọmọ mi?” ");
INSERT INTO yor_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakọbu sì fèsì pé, “Èmi ni Esau àkọ́bí rẹ, èmi ti ṣe gẹ́gẹ́ bí ìwọ ti sọ fún mi, jọ̀wọ́ dìde jókòó, kí o sì jẹ nínú ẹran igbó mi tí mo ti sè, kí o ba à le súre fún mi pẹ̀lú gbogbo ọkàn rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaaki tún béèrè pé, “Ọmọ mi, báwo ni ó ṣe tètè yá ọ bẹ́ẹ̀?” Jakọbu sì tún dáhùn pé, “Olúwa Ọlọ́run rẹ ló fún mi pa.” ");
INSERT INTO yor_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Nígbà náà ni Isaaki wí fún Jakọbu pé, “Súnmọ́ mi, kí n le è fọwọ́ kàn ọ́, kí n lè mọ̀ bóyá Esau ọmọ mi ni nítòótọ́ tàbí òun kọ́.” ");
INSERT INTO yor_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakọbu sì súnmọ́ Isaaki baba rẹ̀. Isaaki sì fọwọ́ kàn án, ó sì wí pé, “Ohùn ni ohùn Jakọbu; ṣùgbọ́n ọwọ́ ni ọwọ́ Esau.” ");
INSERT INTO yor_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Kò sì dá Jakọbu mọ̀ nítorí ọwọ́ rẹ̀ ní irun bí i ti Esau arákùnrin rẹ, nítorí náà, ó súre fún un ");
INSERT INTO yor_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ó sì bi í léèrè pé, “Ǹjẹ́ ìwọ ni Esau ọmọ mi ni tòótọ́?” Jakọbu sì dáhùn pé, “Èmi ni.” ");
INSERT INTO yor_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Nígbà náà ni Isaaki wí pé, “Gbé ẹran igbó náà súnmọ́ ọ̀dọ̀ mi, kí èmi kí ó jẹ ẹ́, kí èmi sì súre fún ọ láti inú ọkàn mi wá.” Jakọbu sì gbé e wá ó sì jẹ ẹ́, ó sì tún fún un ní wáìnì, ó sì mú un pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nígbà náà ni Isaaki baba rẹ̀ wí fun un pé, “Súnmọ́ mi, ọmọ mi, kí o sì fẹnukò mí ní ẹnu.” ");
INSERT INTO yor_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ó sì súnmọ́ ọn, ó sì fẹnukò ó ní ẹnu. Nígbà tí Isaaki gbọ́ òórùn aṣọ rẹ̀, ó súre fún un ó wí pé, “Wò ó òórùn ọmọ mi dàbí òórùn oko tí Olúwa ti bùkún. ");
INSERT INTO yor_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kí Ọlọ́run kí ó fún ọ nínú ìrì ọ̀run àti nínú ọ̀rá ilẹ̀ àti ọ̀pọ̀lọpọ̀ ọkà àti wáìnì tuntun. ");
INSERT INTO yor_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kí àwọn orílẹ̀-èdè kí ó máa sìn ọ́, kí àwọn ènìyàn sì máa tẹríba fún ọ, máa ṣe olórí àwọn arákùnrin rẹ, kí àwọn iyèkan rẹ sì máa wólẹ̀ fún ọ Fífibú ni àwọn ẹni tó fi ọ́ bú, ìbùkún ni fún àwọn ẹni tí ó súre fún ọ.” ");
INSERT INTO yor_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Bí Isaaki ti súre tán tí Jakọbu ṣẹ̀ṣẹ̀ jáde kúrò ní ọ̀dọ̀ baba rẹ̀ ni Esau ti oko ọdẹ dé. ");
INSERT INTO yor_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Òun pẹ̀lú ṣe ẹran dídùn, ó sì gbé e tọ baba rẹ̀ wá, ó sì wí fún un pé, “Baba mi, dìde jókòó, kí o sì jẹ nínú ẹran igbó tí mo ti ṣè, kí o sì súre fún mi.” ");
INSERT INTO yor_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaaki baba rẹ̀ sì bi í wí pé, “Ìwọ ta ni?” Ó sì dáhùn pé, “Èmi Esau, àkọ́bí rẹ ni.” ");
INSERT INTO yor_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nígbà náà ni Isaaki wárìrì gidigidi, ó sì wí pé, “Ta ni ẹni náà, tí ó ti pa ẹran igbó tí ó sì ti gbe wá fún mi, tí mo sì ti jẹ ẹ́ kí ó tó dé? Mo sì ti súre fún un, sì wò ó dájúdájú a ó sì bùkún un!” ");
INSERT INTO yor_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Nígbà tí Esau gbọ́ ọ̀rọ̀ baba rẹ̀, ó ké, ó sì bẹ̀rẹ̀ sí ní sọkún kíkorò, ó sì wí fún baba rẹ̀ pé, “Baba mi súre fún èmi náà, àní fún èmi náà pẹ̀lú.” ");
INSERT INTO yor_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ṣùgbọ́n Isaaki wí pé, “Àbúrò rẹ ti fi ẹ̀tàn wá, ó sì ti gba ìbùkún rẹ lọ.” ");
INSERT INTO yor_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau sì wí pé, “Lásán ni a pe orúkọ rẹ̀ ní Jakọbu bí? Ní ìgbà méjì yìí ni ó ti tàn mí jẹ: ní àkọ́kọ́, ó gba ogún ìbí mi, nísinsin yìí, ó tún gba ìbùkún mi!” O sì béèrè pé, “Ṣe o kò wá fi ìre kankan sílẹ̀ fun mi ni?” ");
INSERT INTO yor_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaaki sì dá Esau lóhùn pé, “Mo ti fi ṣe olórí rẹ àti àwọn ìbátan rẹ ni mo fi ṣe ìránṣẹ́ fún un, àti ọkà àti wáìnì ni mo ti fi lé e lọ́wọ́ lọ́pọ̀lọ́pọ̀, kí ni ó tún kù tí ǹ bá tún fún ọ báyìí ọmọ mi?” ");
INSERT INTO yor_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau sì wí fún baba rẹ̀ pé, “Ṣe ìre kan ṣoṣo ni ìwọ ní lẹ́nu ni baba mi? Súre fún èmi náà, baba mi.” Esau sì sọkún kíkankíkan. ");
INSERT INTO yor_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaaki baba rẹ̀ sì dá a lóhùn pé, “Ibùjókòó rẹ yóò jìnnà sí ọ̀rá ilẹ̀, àti sí ibi ìrì ọ̀run láti òkè wá. ");
INSERT INTO yor_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nípa idà rẹ ni ìwọ yóò máa gbé, ìwọ yóò sì máa sin àbúrò rẹ, ṣùgbọ́n ní ìkẹyìn, nígbà tí ìwọ bá di alágbára ìwọ yóò já àjàgà rẹ̀ kúrò lọ́rùn rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau sì kórìíra Jakọbu nítorí ìre tí baba rẹ̀ sú fún un, ó sì wí fún ara rẹ̀ pé, “Baba mi sá à ti fẹ́rẹ kú, nígbà náà ni èmi ó pa Jakọbu, arákùnrin mi.” ");
INSERT INTO yor_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Nígbà tí Rebeka sì gbọ́ ohun tí Esau àkọ́bí rẹ̀ wí, ó sì ránṣẹ́ sí Jakọbu, ó sì wí fun un pé, “Esau ẹ̀gbọ́n rẹ ń tu ara rẹ̀ nínú pẹ̀lú èrò à ti pa ọ́. ");
INSERT INTO yor_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nítorí náà ọmọ mi, ṣe ohun tí èmi yóò sọ fún ọ, sálọ sọ́dọ̀ Labani ẹ̀gbọ́n mi ní Harani. ");
INSERT INTO yor_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Jókòó sí ibẹ̀ títí di ìgbà tí ìbínú ẹ̀gbọ́n rẹ yóò fi rọ̀. ");
INSERT INTO yor_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Nígbà tí ẹ̀gbọ́n rẹ kò bá bínú sí ọ mọ́, tí ó sì ti gbàgbé ohun tí ìwọ ṣe sí i, èmí ó ránṣẹ́ sí ọ láti padà wá. Èéṣe tí èmi ó fi pàdánù ẹ̀yin méjèèjì ní ọjọ́ kan náà?” ");
INSERT INTO yor_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Nígbà náà ni Rebeka wí fún Isaaki pé, “Ayé sì sú mi nítorí àwọn ọmọbìnrin Hiti wọ̀nyí. Bí Jakọbu bá fẹ́ ọ̀kan nínú àwọn ọmọbìnrin Hiti wọ̀nyí, ó kúkú sàn kí n má wà láààyè.” ");
INSERT INTO yor_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Nítorí náà Isaaki pe Jakọbu, ó sì súre fún un, ó sì pàṣẹ fún un pé, “Ìwọ kò gbọdọ̀ fẹ́ aya láàrín àwọn ọmọbìnrin Kenaani. ");
INSERT INTO yor_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Dípò bẹ́ẹ̀ lọ sí Padani-Aramu, sí ilé Betueli, baba ìyá rẹ, kí ìwọ kí ó sì fẹ́ aya fún ara rẹ nínú àwọn ọmọbìnrin Labani arákùnrin ìyá rẹ. ");
INSERT INTO yor_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kí Ọlọ́run Olódùmarè El-Ṣaddai kí ó bùkún fún ọ, kí ó sì mú ọ bí sí i, kí ó sì mú ọ pọ̀ sí i ní iye títí tí ìwọ yóò di àgbájọ àwọn ènìyàn. ");
INSERT INTO yor_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kí Ọlọ́run kí ó fún ìwọ àti irú-ọmọ rẹ ní ìre tí ó sú fún Abrahamu, kí ìwọ kí ó le gba ilẹ̀ níbi tí a ti ń ṣe àtìpó yìí, ilẹ̀ tí Ọlọ́run ti fi fún Abrahamu.” ");
INSERT INTO yor_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Bẹ́ẹ̀ ni Isaaki sì rán Jakọbu lọ. Ó sì lọ sí Padani-Aramu, lọ́dọ̀ Labani ọmọ Betueli, ará Aramu, tí í ṣe arákùnrin Rebeka ìyá Jakọbu àti Esau. ");
INSERT INTO yor_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Nígbà tí Esau gbọ́ pé, Isaaki ti súre fún Jakọbu, ó sì ti rán Jakọbu lọ sí Padani-Aramu láti fẹ́ aya níbẹ̀ àti pé nígbà tí ó súre fún un, ó kìlọ̀ fun un pé, kò gbọdọ̀ fẹ́ nínú àwọn ọmọbìnrin Kenaani ");
INSERT INTO yor_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","àti pé, Jakọbu ti gbọ́rọ̀ sí ìyá àti baba rẹ̀ lẹ́nu, ó sì ti lọ sí Padani-Aramu. ");
INSERT INTO yor_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Nígbà náà ni Esau mọ bí Isaaki baba rẹ ti kórìíra àwọn ọmọbìnrin Kenaani tó. ");
INSERT INTO yor_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Nítorí náà Esau tọ Iṣmaeli lọ, ó sì fẹ́ Mahalati, arábìnrin Nebaioti, ọmọbìnrin Iṣmaeli tí í ṣe ọmọ Abrahamu. Ó fẹ́ ẹ, kún àwọn ìyàwó tí ó ti ní tẹ́lẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakọbu kúrò ní Beerṣeba, ó sì kọrí sí ìlú Harani. ");
INSERT INTO yor_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nígbà tí ó dé ibìkan, ó dúró ní òru náà nítorí tí ilẹ̀ ti ń ṣú, ó sì gbé òkúta kan ó fi ṣe ìrọ̀rí, ó sì sùn. ");
INSERT INTO yor_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ó sì lá àlá pé, a gbé àkàsọ̀ kan dúró ti ó fi ìdí lélẹ̀, orí rẹ̀ sì kan ọ̀run, àwọn angẹli Ọlọ́run sì ń gòkè, wọ́n sì ń sọ̀kalẹ̀ lórí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Olúwa sì dúró lókè rẹ̀, ó sì wí pé, “Èmi ni Olúwa, Ọlọ́run baba rẹ Abrahamu àti Ọlọ́run Isaaki, ìwọ àti ìran rẹ ni èmi yóò fi ilẹ̀ tí ìwọ dùbúlẹ̀ sórí rẹ̀ yìí fún. ");
INSERT INTO yor_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ìran rẹ yóò pọ̀ bí erùpẹ̀ ilẹ̀, ìwọ yóò sì tànkálẹ̀ dé ìlà-oòrùn àti ìwọ̀-oòrùn, àti dé gúúsù àti àríwá. A ó sì bùkún gbogbo orílẹ̀-èdè ayé nípasẹ̀ ìwọ àti àwọn ọmọ rẹ. ");
INSERT INTO yor_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Èmi wà pẹ̀lú rẹ, èmi yóò sì pa ọ mọ́ ní ibikíbi tí ìwọ bá lọ, èmi yóò sì mú ọ padà wá sí ilẹ̀ yìí ní àlàáfíà. Èmi kì yóò fi ọ sílẹ̀ ní ìgbà kan, títí tí èmi yóò fi mú gbogbo ìlérí mi ṣẹ.” ");
INSERT INTO yor_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Nígbà tí Jakọbu jí lójú oorun rẹ̀, ó rò nínú ara rẹ̀ pé, “Dájúdájú Olúwa ń bẹ ní ìhín yìí, èmi kò sì mọ̀.” ");
INSERT INTO yor_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ẹ̀rù sì bà á, ó sì wí pé, “Ìhín yìí ní ẹ̀rù gidigidi; ibí kì í ṣe ibòmíràn bí kò ṣe ilé Ọlọ́run, àní ẹnu ibodè ọ̀run nìyìí.” ");
INSERT INTO yor_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jakọbu sì dìde ní kùtùkùtù òwúrọ̀, ó sì gbé òkúta tí ó fi ṣe ìrọ̀rí lélẹ̀ bí ọ̀wọ́n, ó sì da òróró si lórí. ");
INSERT INTO yor_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ó sì pe orúkọ ibẹ̀ ní Beteli, bí ó tilẹ̀ jẹ́ pé ìlú náà ń jẹ́ Lusi tẹ́lẹ̀ rí. ");
INSERT INTO yor_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jakọbu sì jẹ́ ẹ̀jẹ́ níbẹ̀ pé, “Bí Ọlọ́run yóò bá wà pẹ̀lú mi, tí yóò sì pa mí mọ́ ní ìrìnàjò mi tí mo ń lọ, tí yóò sì fún mi ní oúnjẹ láti jẹ àti aṣọ láti wọ̀, ");
INSERT INTO yor_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","tí mo sì padà sílé baba mi ní àlàáfíà, nígbà náà Olúwa ni yóò jẹ́ Ọlọ́run mi, ");
INSERT INTO yor_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Òkúta yìí tí mo gbé kalẹ̀ bí ọ̀wọ́n yóò jẹ́ ilé Ọlọ́run, nínú gbogbo ohun tí ìwọ ó fi fún mi, èmi yóò sì fi ìdámẹ́wàá rẹ̀ fún ọ.” ");
INSERT INTO yor_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jakọbu sì tẹ̀síwájú nínú ìrìnàjò rẹ̀, ó sì dé ilẹ̀ àwọn ará ìlà-oòrùn. ");
INSERT INTO yor_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ó sì rí kànga kan ní pápá, agbo àgùntàn mẹ́ta sì dúró láti mu omi ní ibi kànga náà, nítorí pé láti inú kànga náà ni wọ́n ti ń fi omi fún agbo àgùntàn. Òkúta tí a gbé dí ẹnu kànga náà sì tóbi gidigidi. ");
INSERT INTO yor_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Nígbà tí gbogbo agbo ẹran bá péjọpọ̀ sí ibẹ̀ tán ni àwọn darandaran yóò tó yí òkúta náà kúrò, tí wọn yóò sì fún àwọn ẹran náà ní omi, tí wọ́n bá sì ti ṣe bẹ́ẹ̀ tán, wọn yóò tún yí òkúta náà padà sí ẹnu kànga náà. ");
INSERT INTO yor_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakọbu béèrè lọ́wọ́ àwọn darandaran náà pé, “Ẹ̀yin arákùnrin mi níbo ni ẹ̀yin ti wá?” Àwọn náà sì dáhùn pé, “Láti Harani ni.” ");
INSERT INTO yor_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ó sì bi wọ́n pé, “Ǹjẹ́ ẹ mọ Labani ọmọ ọmọ Nahori?” Wọ́n sì dáhùn pé, “Bẹ́ẹ̀ ni, àwa mọ̀ ọ́n.” ");
INSERT INTO yor_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jakọbu béèrè pé, “Ṣe àlàáfíà ni ó wà?” Wọ́n sì dáhùn pé, “Bẹ́ẹ̀ ni, àlàáfíà ni. Wò ó, Rakeli ọmọ rẹ̀ ni ó ń bọ̀ yìí pẹ̀lú agbo àgùntàn.” ");
INSERT INTO yor_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ó sì wí pé, “Kíyèsi, ilẹ̀ ò tí ì ṣú, kò tì í tó àkókò fún àwọn ohun ọ̀sìn láti wọ̀. Ẹ fún àwọn ẹran wọ̀nyí ní omi, kí ẹ ba à le tètè dà wọ́n padà láti jẹun.” ");
INSERT INTO yor_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Wọ́n dá a lóhùn pé, “Àwa kì í yí òkúta kúrò ní ẹnu kànga láti pọn omi fún àwọn ẹran títí gbogbo àwọn darandaran àti àwọn ẹran yóò fi péjọ tán.” ");
INSERT INTO yor_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Bí wọ́n sì ti ń sọ̀rọ̀ lọ́wọ́ ni Rakeli dé pẹ̀lú agbo àgùntàn baba rẹ̀, nítorí darandaran ni òun náà. ");
INSERT INTO yor_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Nígbà tí Jakọbu rí Rakeli ọmọbìnrin Labani tí í ṣe ẹ̀gbọ́n ìyá rẹ̀, pẹ̀lú àgùntàn Labani, Jakọbu súnmọ́ kànga náà, ó sì yí òkúta kúrò lẹ́nu rẹ̀, ó sì fún àwọn ẹran arákùnrin ìyá rẹ̀ Labani ní omi. ");
INSERT INTO yor_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jakọbu sì fẹnu ko Rakeli ní ẹnu. Ó sì bẹ̀rẹ̀ sí í sọkún. ");
INSERT INTO yor_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jakọbu sì wí fún Rakeli pé ìbátan baba rẹ̀ ni òun, àti pé, òun jẹ́ ọmọ Rebeka. Rakeli sì sáré lọ sọ fún baba rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ní kété tí Labani gbúròó Jakọbu ọmọ arábìnrin rẹ̀, ó jáde lọ pàdé Jakọbu, ó dì mọ́ ọn, ó fi ẹnu kò ó ní ẹnu, ó sì mú un lọ sí ilé. Nígbà náà ni Jakọbu ròyìn ohun gbogbo fún un. ");
INSERT INTO yor_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labani sì wí pé, “Ẹran-ara àti ẹ̀jẹ̀ ara mi ni ìwọ jẹ́.” Lẹ́yìn tí Jakọbu sì wà pẹ̀lú rẹ̀ fún odidi oṣù kan, ");
INSERT INTO yor_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labani wí fún Jakọbu pé, “Bí a tilẹ̀ jẹ́ ìbátan, kò yẹ kí o máa ṣiṣẹ́ fún mi lásán láìgba ohun kankan. Sọ ohun tì ìwọ fẹ́ gbà fún iṣẹ́ tí ìwọ ń ṣe fún mi!” ");
INSERT INTO yor_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Wàyí o, Labani ní ọmọbìnrin méjì, orúkọ èyí ẹ̀gbọ́n ń jẹ́ Lea, orúkọ àbúrò sì ń jẹ́ Rakeli. ");
INSERT INTO yor_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea kò ní ẹwà púpọ̀, ṣùgbọ́n Rakeli ní ẹwà gidigidi. Ojú rẹ̀ sì fanimọ́ra. ");
INSERT INTO yor_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakọbu sì fẹ́ràn Rakeli, ó sì wí fún baba rẹ̀ pé, “Èmi yóò ṣiṣẹ́ sìn ọ fún ọdún méje, bí ìwọ yóò bá fún mi ní Rakeli ọmọ rẹ ní aya.” ");
INSERT INTO yor_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani sì dáhùn wí pé, “Ó kúkú sàn kí ń fi fún ọ, ju kí ń fi fún ẹlòmíràn lọ, nítorí náà wà ní ọ̀dọ̀ mi.” ");
INSERT INTO yor_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jakọbu sì ṣiṣẹ́ sin Labani fún ọdún méje láti fẹ́ Rakeli. Àwọn ọdún wọ̀nyí sì dàbí ọjọ́ díẹ̀ lára rẹ̀, nítorí ó fẹ́ràn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jakọbu sì wí fún Labani pé, “Mo ti parí àsìkò tí a jọ ṣe àdéhùn rẹ̀, nítorí náà fún mi ní aya mi, kí òun lè ṣe aya fún mi.” ");
INSERT INTO yor_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labani sì pe gbogbo ènìyàn ibẹ̀ jọ, ó sì ṣe àsè ìyàwó fún wọ́n. ");
INSERT INTO yor_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ṣùgbọ́n nígbà tí ó di òru, Labani mú Lea tọ Jakọbu lọ. Jakọbu sì bá a lòpọ̀. ");
INSERT INTO yor_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labani sì fi Silipa ọmọ ọ̀dọ̀ rẹ̀ obìnrin fún Lea gẹ́gẹ́ bí ìránṣẹ́. ");
INSERT INTO yor_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sì kíyèsi, nígbà ti ilẹ̀ mọ́, Jakọbu rí i pé Lea ni! Ó sì wí fún Labani pé, “Èwo ni ìwọ ṣe sí mi yìí? Ṣe bí nítorí Rakeli ni mo ṣe ṣiṣẹ́ sìn ọ, èéṣe tí ìwọ tàn mi?” ");
INSERT INTO yor_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani sì dáhùn pé, “Kò bá àṣà wa mu láti fi àbúrò fún ọkọ ṣáájú ẹ̀gbọ́n rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mú sùúrù parí ọ̀sẹ̀ ìgbéyàwó yìí náà, nígbà náà ni èmi yóò fi àbúrò rẹ̀ fún ọ pẹ̀lú, bí ìwọ ó bá ṣiṣẹ́ sìn mi fún ọdún méje mìíràn.” ");
INSERT INTO yor_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakọbu sì gbà láti sin Labani fún ọdún méje mìíràn. Labani sì fi Rakeli ọmọ rẹ̀ fún un bí aya. ");
INSERT INTO yor_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani sì fi Biliha ọmọ ọ̀dọ̀ rẹ̀ obìnrin fún Rakeli bí ìránṣẹ́. ");
INSERT INTO yor_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakọbu sì bá Rakeli náà lòpọ̀. Ó sì fẹ́ràn Rakeli ju Lea lọ, ó sì ṣiṣẹ́ sin Labani fún ọdún méje mìíràn. ");
INSERT INTO yor_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Nígbà tí Olúwa sì ri pé, Jakọbu kò fẹ́ràn Lea, ó ṣí i ni inú ṣùgbọ́n Rakeli yàgàn. ");
INSERT INTO yor_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea sì lóyún, ó sì bí ọmọkùnrin kan, ó sì pe orúkọ rẹ̀ ní Reubeni, nítorí ó wí pé, “Nítorí Olúwa ti mọ ìpọ́njú mi, dájúdájú, ọkọ mi yóò fẹ́ràn mi báyìí.” ");
INSERT INTO yor_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ó sì tún lóyún, ó bí ọmọkùnrin kan. Ó sì pe orúkọ rẹ̀ ní Simeoni, wí pé, “Nítorí tí Olúwa ti gbọ́ pé a kò fẹ́ràn mi, ó sì fi èyí fún mi pẹ̀lú.” ");
INSERT INTO yor_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ó sì tún lóyún, ó bí ọmọkùnrin kan, ó sì wí pé, “Nígbà yìí ni ọkọ mi yóò fi ara mọ́ mi, nítorí tí mo ti bí ọmọkùnrin mẹ́ta fún un,” nítorí náà ni ó ṣe pe orúkọ rẹ̀ ní Lefi. ");
INSERT INTO yor_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ó sì tún lóyún, ó sì tún jẹ́ pé ọmọkùnrin ni ó bí, ó sì wí pé, “Nígbà yìí ni èmi yóò yin Olúwa.” Ó sì pe orúkọ rẹ̀ ní Juda. Ó sì dáwọ́ ọmọ bíbí dúró. ");
INSERT INTO yor_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Nígbà tí Rakeli rí i pe òun kò bímọ, ó bẹ̀rẹ̀ sí ṣe ìlara sí Lea, arábìnrin rẹ̀, ó sì wí fún Jakọbu pé, “Fún mi lọ́mọ, bí kò ṣe bẹ́ẹ̀, èmi ó kú!” ");
INSERT INTO yor_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Inú sì bí Jakọbu sí i, ó sì wí pé, “Èmi ha wà ní ipò Ọlọ́run, ẹni tí ó mú ọ yàgàn bí?” ");
INSERT INTO yor_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Nígbà náà ni Rakeli wí pé, “Biliha ìránṣẹ́bìnrin mi nìyìí, bá a lòpọ̀, kí ó ba à le bí ọmọ fún mi, kí èmi si le è tipasẹ̀ rẹ̀ ní ọmọ.” ");
INSERT INTO yor_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Báyìí ni Rakeli fi Biliha fún Jakọbu ní aya, ó sì bá a lòpọ̀. ");
INSERT INTO yor_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha sì lóyún, ó sì bí ọmọkùnrin kan fún Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rakeli sì wí pé, “Ọlọ́run ti ṣe ìdájọ́ mi; ó sì ti gbọ́ ohùn ẹ̀bẹ̀ mi, ó sì fún mi ni ọmọkùnrin kan.” Nítorí ìdí èyí ni ó ṣe pe orúkọ rẹ̀ ní Dani. ");
INSERT INTO yor_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha, ọmọ ọ̀dọ̀ Rakeli sì tún lóyún, ó sì bí ọmọkùnrin kejì fún Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Nígbà náà ni Rakeli wí pé, “Mo ti bá ẹ̀gbọ́n mi ja ìjàkadì ńlá, èmi sì ti borí.” Ó sì pe orúkọ rẹ̀ ní Naftali. ");
INSERT INTO yor_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Nígbà tí Lea sì ri pé òun ko tún lóyún mọ́, ó sì fi ọmọ ọ̀dọ̀ rẹ̀ obìnrin, Silipa fún Jakọbu bí aya. ");
INSERT INTO yor_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silipa ọmọ ọ̀dọ̀ Lea sì bí ọmọkùnrin kan fún Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Nígbà náà ni Lea wí pé, “Orí rere ni èyí!” Ó sì pe orúkọ rẹ̀ ní Gadi. ");
INSERT INTO yor_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silipa ọmọ ọ̀dọ̀ Lea sì tún bí ọmọkùnrin kejì fún Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Nígbà náà ni Lea wí pé, “Mo ní ayọ̀ gidigidi! Àwọn ọmọbìnrin yóò sì máa pe mí ní Alábùkún fún.” Ó sì pe orúkọ rẹ̀ ní Aṣeri. ");
INSERT INTO yor_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ní ọjọ́ kan, ní àkókò ìkórè ọkà jéró, Reubeni jáde lọ sí oko, ó sì rí èso mándrákì, ó sì mú un tọ Lea ìyá rẹ̀ wá. Rakeli sì wí fún Lea pé, “Jọ̀wọ́ fún mi ní ara èso mándrákì tí ọmọ rẹ mú wá.” ");
INSERT INTO yor_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ṣùgbọ́n Lea dalóhùn pé, “Ọkọ mi tí o gbà kò tó kọ́? Ṣe ìwọ yóò tún gba èso mándrákì ọmọ mi pẹ̀lú?” Rakeli sì dáhùn pé, “Ó dára, yóò sùn tì ọ́ lálẹ́ yìí nítorí èso mándrákì ọmọ rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Nítorí náà, nígbà tí Jakọbu ti oko dé ní ìrọ̀lẹ́ ọjọ́ náà, Lea jáde lọ pàdé rẹ̀, ó sì wí pé, “O ní láti sun ọ̀dọ̀ mi ní alẹ́ yìí nítorí mo ti fi èso mándrákì tí ọmọ mi wá bẹ̀ ọ́ lọ́wẹ̀.” Nítorí náà ni Jakọbu sùn tì í ní alẹ́ ọjọ́ náà. ");
INSERT INTO yor_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ọlọ́run sì gbọ́ ti Lea, ó sì lóyún, ó sì bí ọmọkùnrin karùn-ún fún Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Nígbà náà ni Lea wí pé, “Ọlọ́run ti sẹ̀san ọmọ ọ̀dọ̀ mi ti mo fi fún ọkọ mi fún mi,” ó sì pe orúkọ rẹ̀ ní Isakari. ");
INSERT INTO yor_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea sì tún lóyún, ó sì bí ọmọkùnrin kẹfà fún Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Nígbà náà ni Lea tún wí pé “Ọlọ́run ti fún mi ní ẹ̀bùn iyebíye, nígbà yìí ni ọkọ mi yóò máa bu ọlá fún mi.” Nítorí náà ni ó ṣe pe orúkọ rẹ̀ ni Sebuluni. ");
INSERT INTO yor_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Lẹ́yìn èyí, ó sì bí ọmọbìnrin kan, ó sì pe orúkọ rẹ̀ ní Dina. ");
INSERT INTO yor_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nígbà náà ni Ọlọ́run rántí Rakeli, Ọlọ́run sì gbọ́ tirẹ̀, ó sì ṣí i ní inú. ");
INSERT INTO yor_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ó lóyún, ó sì bí ọmọkùnrin kan ó sì wí pé, “Ọlọ́run ti mú ẹ̀gàn mi kúrò.” ");
INSERT INTO yor_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ó sì pe orúkọ rẹ̀ ni Josẹfu, ó sì wí pé, “Ǹjẹ́ kí Olúwa kí ó fi ọmọkùnrin mìíràn kún un fún mi.” ");
INSERT INTO yor_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Lẹ́yìn tí Rakeli ti bí Josẹfu, Jakọbu wí fún Labani pé, “Jẹ́ kí èmi máa lọ sí ilẹ̀ mi tí mo ti wá. ");
INSERT INTO yor_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kó àwọn ọmọ àti ìyàwó mi fún mi, àwọn ẹni tí mo ti torí wọn sìn ọ́. Ki èmi lè máa bá ọ̀nà mi lọ. O sá à mọ bí mo ti ṣiṣẹ́ sìn ọ́ tó.” ");
INSERT INTO yor_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ṣùgbọ́n Labani wí fún un pé, “Bí o bá ṣe pé mo rí ojúrere rẹ, jọ̀wọ́ dúró, nítorí, mo ti ṣe àyẹ̀wò rẹ, mo sì rí i pé Olúwa bùkún mi nítorí rẹ. ");
INSERT INTO yor_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Sọ ohun tí o fẹ́ gẹ́gẹ́ bí owó iṣẹ́ ẹ̀ rẹ, èmi yóò sì san án.” ");
INSERT INTO yor_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakọbu sì wí fún un pé, “Ìwọ sá à mọ bí mo ti ṣiṣẹ́ sìn ọ́ àti bí ẹran ọ̀sìn rẹ ti pọ̀ si lábẹ́ ìtọ́jú mi. ");
INSERT INTO yor_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ìwọ̀nba díẹ̀ sá à ni o ní kí èmi tó dé, ó sì ti pọ̀ sí i gidigidi, Olúwa sì ti bùkún ọ nínú gbogbo èyí tí mo ṣe. Ṣùgbọ́n nísinsin yìí, nígbà wo ní èmi yóò pèsè fún ìdílé tèmi.” ");
INSERT INTO yor_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ó sì tún béèrè wí pé, “Kín ni kí èmi ó fi fún ọ?” Jakọbu dáhùn pé, “Má fun mi ni ohunkóhun, ṣùgbọ́n bí ìwọ yóò bá ṣe ohun tí mo fẹ́ sọ yìí, èmi yóò sì máa bá ọ tọ́jú àwọn agbo ẹran rẹ, èmi yóò sì máa bọ́ wọn. ");
INSERT INTO yor_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Jẹ́ kí èmi kí ó la agbo ẹran kọjá ní òní, èmi yóò sì mú gbogbo àgùntàn onílà àti èyí tí ó ní àmì, àti gbogbo àgbò dúdú pẹ̀lú ewúrẹ́ onílà tàbí tí ó ní àmì. Àwọn wọ̀nyí ni yóò dúró fún owó iṣẹ́ mi. ");
INSERT INTO yor_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Òtítọ́ inú mi yóò sì jẹ́rìí fún mi ní ọjọ́ iwájú nígbà tí ìwọ bá wo owó iṣẹ́ mi tí ìwọ san fún mi, yóò sì ṣe pé gbogbo èyí tí kì í bá ṣe onílà tàbí alámì nínú ewúrẹ́ tàbí tí kì í ṣe dúdú nínú àgùntàn, tí o bá rí ni ọ̀dọ̀ mi ni kí o kà sí mi lọ́rùn pé jíjí ni mo jí gbé.” ");
INSERT INTO yor_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani sì dáhùn pé, “Mo fi ara mọ́ ọn, ṣe bí ìwọ ti wí.” ");
INSERT INTO yor_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ní ọjọ́ náà gan an ni Labani kó gbogbo ewúrẹ́ tí ó ní àmì tàbí ilà (àti òbúkọ àti abo, tí ó ní funfun díẹ̀ lára), pẹ̀lú gbogbo àgùntàn dúdú, ó sì fi wọ́n sí ìtọ́jú àwọn ọmọ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ibi tí Labani àti Jakọbu sì wà sí ara wọn, sì tó ìrìn ọjọ́ mẹ́ta. Jakọbu sì ń tọ́jú agbo ẹran Labani tí ó kù. ");
INSERT INTO yor_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Nígbà náà ni Jakọbu gé ọ̀pá tẹ́ẹ́rẹ́ tútù kan lára igi Poplari, àti igi almondi àti igi Pileeni. Ó sì bó èèpo kúrò ní ibi kọ̀ọ̀kan lára igi náà láti fún igi náà ní àwọ̀ ju ẹyọ kan lọ. ");
INSERT INTO yor_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ó sì mú àwọn ọ̀pá wọ̀nyí tì sí ọ̀ọ́kán agbada omi níbi tí àwọn ẹran ti lè rí i nígbà tí wọ́n bá wá mu omi. ");
INSERT INTO yor_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Tí àwọn ẹran bá sì ń gùn, níwájú àwọn ọ̀pá náà, wọn sì bí àwọn ẹran onílà àti alámì, àwọn tí ó ní tótòtó lára. ");
INSERT INTO yor_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Nígbà náà ni ó ya àwọn abo ẹran kúrò nínú agbo ẹran Labani, ó sì yà wọ́n sọ́tọ̀ kúrò lára àgbò, ó sì mú kí wọn máa gùn pẹ̀lú àwọn àgbò Jakọbu dúdú nìkan, bẹ́ẹ̀ ni ó kó agbo ẹran jọ fún ara rẹ̀ láti ara agbo ẹran Labani. ");
INSERT INTO yor_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Nígbàkígbà tí àwọn ẹran tí ó lera bá ń gùn, Jakọbu yóò fi àwọn ọ̀pá wọ̀nyí lélẹ̀ níwájú wọn, ní ibi tí wọn ti ń mu omi. ");
INSERT INTO yor_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ṣùgbọ́n tí ó bá jẹ́ wí pé wọn kò lera, kò ní fi àwọn ọ̀pá náà lélẹ̀. Nítorí náà, àwọn tí kò lera ń jẹ́ ti Labani, nígbà tí àwọn tí ó lera ń jẹ́ ti Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Nítorí ìdí èyí, Jakọbu di ọlọ́rọ̀ gidigidi, agbo ẹran rẹ̀ pọ̀ àti àwọn ìránṣẹ́kùnrin, ìránṣẹ́bìnrin pẹ̀lú ìbákasẹ àti kẹ́tẹ́kẹ́tẹ́. ");
INSERT INTO yor_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakọbu sì gbọ́ pé àwọn ọmọ Labani ń wí pé, “Jakọbu ti gba gbogbo ohun ìní baba wa, ó sì ti kó ọrọ̀ jọ fún ara rẹ̀ lára àwọn ohun tí í ṣe ti baba wa.” ");
INSERT INTO yor_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakọbu sì ṣàkíyèsí pé ìwà Labani sí òun ti yí padà sí ti àtẹ̀yìnwá. ");
INSERT INTO yor_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Nígbà náà ni Olúwa wí fún Jakọbu pé, “Padà lọ sí ilẹ̀ àwọn baba à rẹ, sí ọ̀dọ̀ àwọn ará rẹ, èmi ó sì wà pẹ̀lú rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jakọbu sì ránṣẹ́ pe Rakeli àti Lea sí pápá níbi tí àwọn ohun ọ̀sìn rẹ̀ wà. ");
INSERT INTO yor_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ó sì wí fún wọn pé, “Mo rí i wí pé ìwà baba yín sí mi ti yí padà sí ti tẹ́lẹ̀, ṣùgbọ́n Ọlọ́run baba mi wà pẹ̀lú mi. ");
INSERT INTO yor_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ẹ sá à mọ̀ pé, mo ti fi gbogbo agbára mi ṣiṣẹ́ fún baba yín, ");
INSERT INTO yor_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","síbẹ̀síbẹ̀ baba yín ti rẹ́ mi jẹ ní ẹ̀ẹ̀mẹwàá ọ̀tọ̀ọ̀tọ̀ ni ó sì ti yí owó iṣẹ́ mi padà. Ṣùgbọ́n Ọlọ́run kò jẹ́ kí ó le è pa mi lára. ");
INSERT INTO yor_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tí ó bá wí pé, ‘Àwọn ẹran onílà ni yóò dúró fún owó iṣẹ́ rẹ,’ nígbà náà ni gbogbo àwọn ẹran ń bí onílà; bí ó bá sì wí pé, ‘Àwọn ẹran onítótòtó ni yóò dúró fún owó iṣẹ́ rẹ,’ nígbà náà ni gbogbo ẹran ń bi onítótòtó. ");
INSERT INTO yor_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Bẹ́ẹ̀ ni Ọlọ́run gba ẹran baba yín, ó sì fi fún mi. ");
INSERT INTO yor_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ní àsìkò tí àwọn ẹran ń gùn, mo la àlá mo sì ri pé àwọn òbúkọ tí wọ́n ń gun àwọn ẹran jẹ́ onítótòtó, onílà àti alámì. ");
INSERT INTO yor_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Angẹli Ọlọ́run wí fún mi nínú àlá náà pé, ‘Jakọbu.’ Mo sì wí pé, ‘Èmi nìyí.’ ");
INSERT INTO yor_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ó sì wí pé, ‘Gbé ojú rẹ sókè kí o sì wò ó, gbogbo àwọn òbúkọ tí ó ń gun àwọn ẹran jẹ́ onítótòtó, onílà àti alámì, nítorí mo ti rí gbogbo ohun ti Labani ń ṣe sí ọ. ");
INSERT INTO yor_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Èmi ni Ọlọ́run Beteli, níbi tí ìwọ ti ta òróró sí ọ̀wọ́n, ìwọ sì jẹ́ ẹ̀jẹ́ láti sìn mi. Nísinsin yìí, kúrò ní ilẹ̀ yìí kíákíá kí o sì padà sí ilẹ̀ ibi tí a gbé ti bí ọ.’ ” ");
INSERT INTO yor_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Nígbà náà ni Rakeli àti Lea dáhùn pé, “Ìpín wo ní a ní nínú ogún baba wa? ");
INSERT INTO yor_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Àjèjì ha kọ́ ni ó kà wá sí? Kì í ṣe torí pé ó tà wá nìkan, ṣùgbọ́n ó ti ná gbogbo owó tí ó gbà lórí wa tán. ");
INSERT INTO yor_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Dájúdájú gbogbo ọrọ̀ ti Ọlọ́run gbà lọ́wọ́ baba wa fún ọ, tiwa àti ti àwọn ọmọ wa ní í ṣe. Nítorí náà ohun gbogbo tí Ọlọ́run bá pàṣẹ fun ọ láti ṣe ni kí ìwọ kí ó ṣe.” ");
INSERT INTO yor_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Nígbà náà ni Jakọbu gbé àwọn ọmọ àti aya rẹ̀ gun ìbákasẹ. ");
INSERT INTO yor_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ó sì da gbogbo agbo ẹran rẹ̀ ṣáájú pẹ̀lú gbogbo ọrọ̀ tí ó ti kójọ ni Padani-Aramu, láti lọ sí ọ̀dọ̀ Isaaki baba rẹ̀ ni ilẹ̀ Kenaani. ");
INSERT INTO yor_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Nígbà tí Labani sì lọ láti rẹ́run àgùntàn, Rakeli sì jí àwọn ère òrìṣà ilé baba rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Síwájú sí i, Jakọbu tan Labani ará Aramu, nítorí kò sọ fún un wí pé òun ń sálọ. ");
INSERT INTO yor_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ó sì sálọ pẹ̀lú ohun gbogbo tí ó ni, ó sì la odò kọjá (Eufurate), ó sì kọrí sí àwọn ilẹ̀ olókè ti Gileadi. ");
INSERT INTO yor_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ní ọjọ́ kẹta ni Labani gbọ́ pé Jakọbu ti sálọ. ");
INSERT INTO yor_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ó sì mú àwọn arákùnrin rẹ̀ pẹ̀lú rẹ̀, ó sì lépa Jakọbu, ó sì lépa wọn fún ọjọ́ méje, ó sì bá wọn ní òkè Gileadi. ");
INSERT INTO yor_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ọlọ́run sì yọ sí Labani ará Aramu lójú àlá ní òru, ó sì wí fun un pé, “Ṣọ́ra, má ṣe sọ ohunkóhun fún Jakọbu, ìbá à ṣe rere tàbí búburú.” ");
INSERT INTO yor_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jakọbu ti pa àgọ́ rẹ̀ si orí òkè kan, nígbà tí Labani bá a. Labani àti àwọn tí ó wá pẹ̀lú rẹ̀ sì pàgọ́ tì wọ́n sí ilẹ̀ òkè Gileadi. ");
INSERT INTO yor_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Nígbà náà ni Labani wí fún Jakọbu pé, “Èwo ni ìwọ ṣe yìí? Tí ìwọ sì tàn mi, ó sì kó àwọn ọmọbìnrin mi bi ìgbèkùn tí a fi idà mú. ");
INSERT INTO yor_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Èéṣe tí ìwọ yọ́ lọ tí ìwọ sì tàn mi? Kí ló dé tí ìwọ kò sọ fún mi pé ìwọ ń lọ, kí èmi fi ayọ̀ àti orin, pẹ̀lú ìlù àti ohun èlò orin sìn ọ́. ");
INSERT INTO yor_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ìwọ kò tilẹ̀ jẹ́ kí èmi fi ẹnu ko àwọn ọmọ ọmọ mi lẹ́nu, pẹ̀lú àwọn ọmọbìnrin mi pé ó dìgbà? Ìwọ ṣiwèrè ní ohun tí ìwọ ṣe yìí. ");
INSERT INTO yor_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mo ní agbára láti ṣe ọ ni ibi, ṣùgbọ́n ní òru àná, Ọlọ́run baba rẹ sọ fún mi pé, kí èmi ṣọ́ra, kí èmi má ṣe sọ ohun kan fún Jakọbu, ìbá à ṣe rere tàbí búburú. ");
INSERT INTO yor_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nísinsin yìí, ìwọ ti lọ nítorí ìwọ fẹ́ láti padà lọ sí ilé baba rẹ, ṣùgbọ́n èéṣe tí ìwọ fi jí àwọn òrìṣà mi?” ");
INSERT INTO yor_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakọbu dá Labani lóhùn pé, “Ẹ̀rù ni ó bà mi nítorí, mo rò pé ìwọ le fi tipátipá gba àwọn ọmọbìnrin rẹ lọ́wọ́ mi. ");
INSERT INTO yor_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ṣùgbọ́n bí o bá ri ẹnikẹ́ni pẹ̀lú ère rẹ, kí ẹni náà di òkú. Ó tún wí pé, níwájú gbogbo ìbátan wa báyìí, wò ó fúnra rẹ̀, bí o bá rí ohunkóhun tí í ṣe tìrẹ, mú un.” Jakọbu kò sì mọ̀ pé, Rakeli ni ó jí àwọn òrìṣà náà. ");
INSERT INTO yor_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labani sì lọ sínú àgọ́ Jakọbu àti ti Lea àti ti àwọn ìránṣẹ́bìnrin méjèèjì, kò sì rí ohunkóhun. Lẹ́yìn ìgbà tí ó jáde nínú àgọ́ Lea ni ó lọ sí àgọ́ Rakeli. ");
INSERT INTO yor_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rakeli sì gbé àwọn òrìṣà náà sínú gàárì ìbákasẹ, ó sì jókòó lé e lórí. Labani sì wá gbogbo inú àgọ́, kò sì rí ohunkóhun. ");
INSERT INTO yor_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rakeli sì wí fún baba rẹ̀ pé, “Má ṣe bínú pé èmi ò le dìde dúró níwájú rẹ baba à mi, ohun tí ó fà á ni pé, mò ń ṣe nǹkan oṣù lọ́wọ́.” Ó sì wá àgọ́ kiri, kò sì rí àwọn òrìṣà ìdílé náà. ");
INSERT INTO yor_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Inú sì bí Jakọbu, ó sì pe Labani ní ìjà pé, “Kí ni ẹ̀ṣẹ̀ mi? Ẹ̀ṣẹ̀ wo ni mo ṣẹ̀ ọ tí ìwọ fi ń lépa mi bí ọ̀daràn? ");
INSERT INTO yor_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nísinsin yìí tí ìwọ ti tú gbogbo ẹrù mi wò, kí ni ohun tí í ṣe tirẹ̀ tí ìwọ rí? Kó wọn kalẹ̀ báyìí níwájú gbogbo ìbátan rẹ àti tèmi, kí wọn kí ó sì ṣe ìdájọ́ láàrín àwa méjèèjì. ");
INSERT INTO yor_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Mo ti wà lọ́dọ̀ rẹ fún ogún ọdún, àwọn àgùntàn tàbí ewúrẹ́ rẹ kò sọnù bẹ́ẹ̀ n kò pa ọ̀kan jẹ rí nínú àwọn àgbò rẹ. ");
INSERT INTO yor_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Èmi kò mú ọ̀kankan wá fún ọ rí nínú èyí tí ẹranko búburú fàya, èmi ni ó fi ara mọ́ irú àdánù bẹ́ẹ̀. Ẹrankẹ́ran tí wọ́n bá sì jí lọ, lọ́sàn án tàbí lóru, ìwọ ń gba owó rẹ̀ lọ́wọ́ mi. ");
INSERT INTO yor_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Báyìí ni mo wà; oòrùn ń pa mi lọ́sàn án, òtútù ń pa mi lóru, mo sì ń ṣe àìsùn. ");
INSERT INTO yor_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Báyìí ni ohun gbogbo rí fún ogún ọdún tí mo fi wà nínú ilé rẹ. Ọdún mẹ́rìnlá ni mo fi sìn ọ́ fún àwọn ọmọbìnrin rẹ méjèèjì, mo sì sìn ọ fún ọdún mẹ́fà fún àwọn ẹran ọ̀sìn, lẹ́ẹ̀mẹ́wàá ni o sì yí owó iṣẹ́ mi padà. ");
INSERT INTO yor_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Bí ó bá ṣe pé Ọlọ́run àwọn baba mi, Ọlọ́run Abrahamu àti ẹ̀rù Isaaki kò wà pẹ̀lú mi ni, ìwọ ìbá ti lé mi jáde lọ́wọ́ òfo. Ṣùgbọ́n, Ọlọ́run ti rí gbogbo ìpọ́njú mi àti iṣẹ́ àṣekára tí mo fi ọwọ́ mi ṣe, ó sì kìlọ̀ fún ọ lóru àná.” ");
INSERT INTO yor_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani sì dá Jakọbu lóhùn, “Tèmi ni àwọn obìnrin wọ̀nyí, ọmọ mi ni àwọn ọmọ wọ̀nyí pẹ̀lú, àwọn agbo ẹran yìí, tèmi ni wọ́n pẹ̀lú. Gbogbo ohun tí o rí wọ̀nyí, tèmi ni. Kí ni mo wá le ṣe sí àwọn ọmọbìnrin wọ̀nyí àti àwọn ọmọ wọn tí wọn bí? ");
INSERT INTO yor_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Wá, jẹ́ kí a dá májẹ̀mú pẹ̀lú ara wa, èyí yóò sì jẹ́ ẹ̀rí ní àárín wa.” ");
INSERT INTO yor_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jakọbu sì mú òkúta kan ó sì gbé e dúró bí ọ̀wọ́n. ");
INSERT INTO yor_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ó sì wí fún àwọn ìbátan rẹ̀ pé, “Ẹ kó àwọn òkúta díẹ̀ jọ.” Wọ́n sì kó òkúta náà jọ bí òkìtì wọ́n sì jẹun níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani sì pe orúkọ rẹ̀ ní Jegari-Sahaduta, ṣùgbọ́n Jakọbu pè é ni Galeedi. ");
INSERT INTO yor_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani sì wí pé, “Òkìtì yìí jẹ́ ẹ̀rí láàrín èmi àti ìwọ ní òní.” Ìdí nìyí tí a fi pe orúkọ rẹ̀ ni Galeedi. ");
INSERT INTO yor_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ó tún pè é ni Mispa nítorí, ó wí pé, “Kí Olúwa kí ó máa ṣọ́ èmi àti ìwọ nígbà tí a bá yà kúrò lọ́dọ̀ ara wa tán. ");
INSERT INTO yor_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Bí o bá fìyà jẹ àwọn ọmọbìnrin mi, tàbí tí o fẹ́ aya mìíràn yàtọ̀ sí wọn, rántí pé, Ọlọ́run ń bẹ láàrín wa bí ẹlẹ́rìí bí ẹnikẹ́ni kò tilẹ̀ sí.” ");
INSERT INTO yor_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labani tún sọ síwájú fún Jakọbu pé, “Òkìtì àti ọ̀wọ̀n tí mo gbé kalẹ̀ láàrín èmi àti ìwọ yìí, ");
INSERT INTO yor_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","yóò jẹ́ ẹ̀rí wí pé èmi kò ni ré ọ̀wọ̀n àti òkìtì yìí kọjá láti bá ọ jà àti pé ìwọ pẹ̀lú kì yóò kọjá òkìtì tàbí ọ̀wọ̀n yìí láti ṣe mí ní ibi. ");
INSERT INTO yor_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ǹjẹ́ kí Ọlọ́run Abrahamu àti Ọlọ́run Nahori, àti Ọlọ́run baba wọn ṣe ìdájọ́ láàrín wa.” Jakọbu sì fi ẹ̀rù Isaaki baba rẹ̀ búra. ");
INSERT INTO yor_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jakọbu sì rú ẹbọ níbẹ̀ ni orí òkè, ó sì pe àwọn ẹbí rẹ̀ láti jẹun. Lẹ́yìn ìgbà tí wọ́n ti jẹun, ibẹ̀ náà ni wọ́n sùn ní ọjọ́ náà. ");
INSERT INTO yor_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ní kùtùkùtù òwúrọ̀ ọjọ́ kejì, Labani fi ẹnu ko àwọn ọmọ ọmọ rẹ̀ lẹ́nu àti àwọn ọmọbìnrin rẹ̀ pẹ̀lú, ó sì súre fún wọn. Labani sì padà lọ sí ilé. ");
INSERT INTO yor_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakọbu sì ń bá ọ̀nà tirẹ̀ lọ, àwọn angẹli Ọlọ́run sì pàdé rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Nígbà tí Jakọbu rí wọn, ó wí pé, “Àgọ́ Ọlọ́run ni èyí!” Ó sì pe orúkọ ibẹ̀ ni Mahanaimu. ");
INSERT INTO yor_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakọbu sì rán àwọn oníṣẹ́ ṣáájú ara rẹ̀ sí Esau arákùnrin rẹ̀ ni ilẹ̀ Seiri ní orílẹ̀-èdè Edomu. ");
INSERT INTO yor_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ó pàṣẹ fún wọn pé, “Èyí ni ẹ̀yin yóò wí fún Esau olúwa mi, Jakọbu ìránṣẹ́ rẹ̀ wí pé, ‘Mo ti ṣe àtìpó lọ́dọ̀ Labani títí ó fi di àsìkò yìí. ");
INSERT INTO yor_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mo ní màlúù, kẹ́tẹ́kẹ́tẹ́, àgùntàn àti ewúrẹ́. Mo tún ni àwọn ìránṣẹ́kùnrin àti ìránṣẹ́bìnrin. Mo ń ránṣẹ́ yìí sí olúwa mi kí èmi le è rí ojúrere rẹ.’ ” ");
INSERT INTO yor_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nígbà tí àwọn ìránṣẹ́ náà padà tọ Jakọbu wà, wọ́n wí pé “Esau arákùnrin rẹ ti múra láti wá pàdé rẹ pẹ̀lú irinwó (400) ọkùnrin.” ");
INSERT INTO yor_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Pẹ̀lú ìbẹ̀rù àti ìbànújẹ́ ni Jakọbu fi pín àwọn ènìyàn tí ó wà lọ́dọ̀ rẹ̀ sí ìpín méjì, ó sì pín àwọn ẹran ọ̀sìn, agbo ẹran àti ìbákasẹ bẹ́ẹ̀ pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nítorí ó rò ó nínú rẹ̀ pé, “Bí Esau bá kọjú ogun sí ìpín kan, ìpín kejì yóò sá àsálà.” ");
INSERT INTO yor_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Nígbà náà ni Jakọbu gbàdúrà pe, “Ọlọ́run Abrahamu baba mi, àti Ọlọ́run Isaaki baba mi, Olúwa tí ó wí fún mi pé, ‘Padà sí orílẹ̀-èdè rẹ àti sọ́dọ̀ àwọn ìbátan rẹ, èmi yóò sì ṣe ọ́ ní rere,’ ");
INSERT INTO yor_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","èmi kò tilẹ̀ yẹ fún àánú àti òtítọ́ tí o ń fihàn fún ìránṣẹ́ rẹ. Nítorí pé, kìkì ọ̀pá mi ni mo mu kúrò ni ilé kọjá Jordani yìí, ṣùgbọ́n nísinsin yìí, èmi ti di ẹgbẹ́ méjì. ");
INSERT INTO yor_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Jọ̀wọ́ Olúwa gbà mí lọ́wọ́ Esau arákùnrin mi, nítorí ẹ̀rù ń bà mí pé yóò wá dojú ìjà kọ mí àti àwọn ìyàwó pẹ̀lú àwọn ọmọ mi. ");
INSERT INTO yor_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ṣùgbọ́n ìwọ ti ṣèlérí pé, ‘Èmi yóò mú ọ gbilẹ̀, èmi yóò sì mú kí àwọn ìran rẹ dà bì í yanrìn òkun tí ẹnikẹ́ni kò le è kà.’ ” ");
INSERT INTO yor_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ó sì lo òru ọjọ́ náà níbẹ̀. Ó mú ẹ̀bùn fún Esau arákùnrin rẹ̀ nínú ohun ìní rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Igba ewúrẹ́, ogún òbúkọ, igba àgùntàn, ogún àgbò, ");
INSERT INTO yor_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ọgbọ̀n abo ìbákasẹ pẹ̀lú ọmọ wọn, ogójì abo màlúù àti akọ màlúù mẹ́wàá, ogún abo kẹ́tẹ́kẹ́tẹ́ àti akọ kẹ́tẹ́kẹ́tẹ́ mẹ́wàá. ");
INSERT INTO yor_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ó sì fi wọ́n lé àwọn ìránṣẹ́ rẹ̀ lọ́wọ́ ní ọ̀wọ̀ọ̀wọ́, ó sì wí fún wọn pé, “Ẹ lọ ṣáájú mi, kí ẹ sì jẹ́ kí àlàfo wà láàrín ọ̀wọ́ agbo ẹran kọ̀ọ̀kan sí èkejì.” ");
INSERT INTO yor_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ó pàṣẹ fún èyí tí ó ṣáájú pé, “Nígbà tí arákùnrin mi Esau bá pàdé rẹ tí ó sì béèrè ẹni tí ìwọ í ṣe àti ibi tí ìwọ ń lọ àti ẹni tí ó ni agbo ẹran tí ó wà lọ́dọ̀ rẹ, ");
INSERT INTO yor_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","nígbà náà ni ìwọ yóò wí pé, ‘Ti ìránṣẹ́ rẹ Jakọbu ni wọ́n. Ẹ̀bùn ni ó sì fi wọ́n ṣe fún Esau olúwa mi, òun pàápàá ń bọ̀ lẹ́yìn wa.’ ” ");
INSERT INTO yor_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jakọbu sì pàṣẹ bẹ́ẹ̀ gẹ́gẹ́ fún ọ̀wọ́ kejì àti ẹ̀kẹta àti àwọn tókù tí ó tẹ̀lé agbo ẹran pé, “Ohun kan ṣoṣo yìí náà ni kí ẹ sọ fún Esau nígbà tí ẹ bá pàdé rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kí ẹ rí i dájú wí pé, ẹ sọ fún un pé, ‘Jakọbu ìránṣẹ́ rẹ̀ ń bọ̀ lẹ́yìn wa.’ ” Èrò Jakọbu ni láti fi àwọn ẹ̀bùn wọ̀nyí tu Esau lójú pé bóyá inú Esau yóò dùn sí òun nígbà tí àwọn bá pàdé. ");
INSERT INTO yor_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Nítorí náà ẹ̀bùn Jakọbu ṣáájú rẹ̀ lọ, Jakọbu pàápàá sì lo òru ọjọ́ náà nínú àgọ́. ");
INSERT INTO yor_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ó sì dìde ní òru ọjọ́ náà, ó mú àwọn aya rẹ̀ méjèèjì, àwọn ìránṣẹ́bìnrin rẹ̀ méjèèjì, àti àwọn ọmọkùnrin rẹ̀ mọ́kọ̀ọ̀kànlá, wọ́n sì kọjá ní ìwọdò Jabbok. ");
INSERT INTO yor_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Lẹ́yìn ìgbà tí ó ti rán wọn kọjá odò tán sí òkè odò, ó sì rán àwọn ohun ìní rẹ̀ kọjá pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ó sì ku Jakọbu nìkan, ọkùnrin kan sì bá a ja ìjàkadì títí ó fi di àfẹ̀mọ́júmọ́. ");
INSERT INTO yor_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ṣùgbọ́n nígbà tí ọkùnrin náà rí i pé òun kò le borí Jakọbu, ó fọwọ́ kàn án ní ọ̀ọ́kán ibi tí eegun itan ti bẹ̀rẹ̀, egungun náà sì yẹ̀ kúrò lórí ike, bí ó ti ń ja ìjàkadì. ");
INSERT INTO yor_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nígbà náà ni ọkùnrin náà wí fún un pé, “Jẹ́ kí ń máa lọ, nítorí ojúmọ́ ti mọ́.” Ṣùgbọ́n Jakọbu dá a lóhùn pé, “Èmi kò ní jẹ́ kí o lọ, àyàfi bí o bá súre fún mi.” ");
INSERT INTO yor_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ọkùnrin náà béèrè orúkọ rẹ̀. Ó sì wí fún un pé, “Jakọbu ni òun ń jẹ́.” ");
INSERT INTO yor_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nígbà náà ni ọkùnrin náà wí pé, “Orúkọ rẹ kì yóò jẹ́ Jakọbu mọ́ bí kò ṣe Israẹli, nítorí pé ìwọ ti bá Ọlọ́run àti ènìyàn jà, o sì borí.” ");
INSERT INTO yor_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakọbu sì bẹ ọkùnrin náà pé, “Sọ orúkọ rẹ fún mi.” Ṣùgbọ́n ọkùnrin náà sá à dáhùn pé, “Èéṣe tí o ń béèrè orúkọ mi?” Lẹ́yìn náà ó súre fún Jakọbu níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakọbu sì pe orúkọ ibẹ̀ ní Penieli pé, “Mo rí Ọlọ́run ní ojúkojú, síbẹ̀ a dá ẹ̀mí mi sí.” ");
INSERT INTO yor_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Bí ó sì ti ń kọjá Penieli, oòrùn ràn bá a, ó sì ń tiro nítorí itan rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ìdí nìyí tí àwọn ọmọ Israẹli kì í fi í jẹ iṣan tí ó wà ní ọ̀ọ́kán ibi tí eegun itan ti bẹ̀rẹ̀ títí di òní olónìí, nítorí níbi iṣan náà ni a ti fọwọ́ kan ibi tí egungun itan Jakọbu ti bẹ̀rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakọbu sì gbójú sókè, ó sì rí Esau àti irinwó (400) ọkùnrin tí wọ́n ń bọ̀, ó sì pín àwọn ọmọ fún Lea, Rakeli àti àwọn ìránṣẹ́bìnrin méjèèjì. ");
INSERT INTO yor_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ó sì ti àwọn ìránṣẹ́bìnrin àti àwọn ọmọ wọn síwájú, Lea àti àwọn ọmọ rẹ̀ sì jẹ ọ̀wọ́ kejì tí ó tẹ̀lé wọn, Rakeli àti Josẹfu sì wà lẹ́yìn pátápátá. ");
INSERT INTO yor_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jakọbu fúnra rẹ̀ wa lọ síwájú pátápátá, ó sì tẹríba ní ìgbà méje bí ó ti ń súnmọ́ Esau, arákùnrin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ṣùgbọ́n Esau sáré pàdé Jakọbu, ó sì dì mọ́ ọn, ó rọ̀ mọ́ ọn lọ́rùn, ó sì fẹnukò ó lẹ́nu. Àwọn méjèèjì sì sọkún. ");
INSERT INTO yor_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Nígbà tí Esau sì ṣe àkíyèsí àwọn ìyàwó àti ọmọ Jakọbu, ó béèrè lọ́wọ́ Jakọbu pé, “Ti ta ni àwọn wọ̀nyí?” Jakọbu sì fèsì wí pé, “Èyí ni àwọn ọmọ tí Ọlọ́run nínú àánú rẹ̀ ti fi fún ìránṣẹ́ rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Nígbà náà ni àwọn ìránṣẹ́bìnrin àti àwọn ọmọ wọn súnmọ́ tòsí, wọ́n sì tẹríba. ");
INSERT INTO yor_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lẹ́yìn náà ni Lea àti àwọn ọmọ rẹ̀ pẹ̀lú dé, wọ́n sì tún tẹríba. Ní ìkẹyìn ni Josẹfu àti Rakeli dé, wọ́n sì tún tẹríba pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau sì béèrè pé, “Kí ni èrò rẹ tí o fi to àwọn ọ̀wọ̀ọ̀wọ́ tí mo pàdé wọ̀nyí?” Jakọbu dáhùn pé, “Kí n ba le rí ojúrere rẹ ni olúwa mi.” ");
INSERT INTO yor_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ṣùgbọ́n Esau wí pé, “Tèmi ti tó mi, pa èyí tí o ní mọ́ fún ara rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakọbu bẹ̀ ẹ́ wí pé, “Rárá bẹ́ẹ̀ kọ́, bí ó bá ṣe pé, mo rí ojúrere rẹ, jọ̀wọ́ gba ọrẹ lọ́wọ́ mi. Bí mo ṣe rí ojú rẹ̀ yìí, ó dàbí wí pé mo rí ojú Ọlọ́run ni báyìí, tí inú rẹ̀ ti dùn sí mi. ");
INSERT INTO yor_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Jọ̀wọ́ gba àwọn ohun tí mo mú wá wọ̀nyí lọ́wọ́ mi. Nítorí Ọlọ́run ti fi oore-ọ̀fẹ́ rẹ̀ hàn sí mi, gbogbo ohun tí mo fẹ́ sì ni mo ní.” Nígbà tí Jakọbu sì rọ̀ ọ́ pé Esau gbọdọ̀ gbà wọ́n, Esau sì gbà á. ");
INSERT INTO yor_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Nígbà náà ni Esau wí pé, “Jẹ́ kí a máa lọ, n ó sìn ọ.” ");
INSERT INTO yor_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ṣùgbọ́n Jakọbu wí fún un pé, “Ṣe ìwọ náà ṣe àkíyèsí pé ọ̀pọ̀ nínú àwọn ọmọ wọ̀nyí kéré, àwọn màlúù àti àgùntàn pẹ̀lú sì ní àwọn ọmọ kéékèèké. Bí a bá dà wọ́n rìn jìnnà ju bí agbára wọn ṣe mọ lọ, wọ́n lè kú. ");
INSERT INTO yor_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Èmi bẹ̀ ọ́, máa lọ síwájú ìránṣẹ́ rẹ, àwọn ó sì máa rọra bọ̀, títí èmi àti àwọn ọmọ yóò fi dé ọ̀dọ̀ olúwa mi ní Seiri.” ");
INSERT INTO yor_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau wí pé, “Jẹ́ kí n fi díẹ̀ sílẹ̀ fún ọ nínú àwọn ọkùnrin mi nígbà náà.” Jakọbu wí pé, “Èéṣe, àní kí n sá à rí ojúrere olúwa mi?” ");
INSERT INTO yor_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ní ọjọ́ náà gan an ni Esau padà lọ sí Seiri. ");
INSERT INTO yor_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jakọbu sì lọ sí Sukkoti, ó sì kọ́ ilé fún ara rẹ̀, ó sì ṣe ọgbà fún àwọn ẹran. Ìdí èyí ní a fi ń pe ibẹ̀ ní Sukkoti. ");
INSERT INTO yor_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Lẹ́yìn ìgbà tí Jakọbu tí Padani-Aramu dé, àlàáfíà ni Jakọbu dé ìlú Ṣekemu ní ilẹ̀ Kenaani, ó sì pàgọ́ sí itòsí ìlú náà. ");
INSERT INTO yor_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ó sì ra ilẹ̀ kan tí ó pàgọ́ sí ni ọgọ́rùn-ún owó fàdákà lọ́wọ́ àwọn ọmọ Hamori tí í ṣe baba Ṣekemu. ");
INSERT INTO yor_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Níbẹ̀ ni ó gbé tẹ́ pẹpẹ kan tí ó pè ní El Elohe Israẹli. ");
INSERT INTO yor_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ní ọjọ́ kan, Dina ọmọbìnrin tí Lea bí fún Jakọbu jáde lọ bẹ àwọn ọmọbìnrin ilẹ̀ náà wò. ");
INSERT INTO yor_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nígbà tí Ṣekemu ọmọ ọba Hamori ará Hifi rí i, ó mú un, ó sì fi ipá bá a lo pọ̀. ");
INSERT INTO yor_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ọkàn rẹ sì fà sí Dina ọmọ Jakọbu gan an, ó sì fẹ́ràn rẹ̀ ó sì bá ọmọbìnrin náà sọ̀rọ̀ ìfẹ́. ");
INSERT INTO yor_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ṣekemu sì wí fún Hamori baba rẹ̀ pé, “Fẹ́ ọmọbìnrin yìí fún mi bí aya.” ");
INSERT INTO yor_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Nígbà tí Jakọbu gbọ́ ohun tí ó ṣẹlẹ̀ pé a fi ipá bá Dina ọmọbìnrin òun ní ògo jẹ́, ṣùgbọ́n àwọn ọmọ rẹ̀ wà nínú pápá níbi tí wọ́n ti ń daran nítorí náà ó mú sùúrù títí tí wọ́n fi dé. ");
INSERT INTO yor_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamori baba Ṣekemu sì jáde wá láti bá Jakọbu sọ̀rọ̀. ");
INSERT INTO yor_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Àwọn ọmọ Jakọbu sì ti oko dé, wọ́n sì gbọ́ ohun tí ó ṣẹlẹ̀ inú wọn sì bàjẹ́, ó sì ń bí wọn nínú gidigidi, nítorí tí ó ṣe ohun búburú ní Israẹli, ní ti ó bá ọmọbìnrin ọmọ Jakọbu lòpọ̀—irú ohun tí kò yẹ kí ó ṣẹlẹ̀ rárá. ");
INSERT INTO yor_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamori sì bá wọn sọ̀rọ̀ pé, “Ọkàn ọmọ mi Ṣekemu fà sí ọmọ rẹ. Jọ̀wọ́ fi fún un gẹ́gẹ́ bí aya. ");
INSERT INTO yor_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ẹ jẹ́ kí a máa ṣe ìgbéyàwó láàrín ara wa, kí àwọn ọmọ yín kó máa fẹ́ àwọn ọmọ wa. ");
INSERT INTO yor_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ẹ lè máa gbé láàrín wa, ibikíbi tí ó bá tẹ́ yín lọ́rùn láàrín wa ni ẹ lè gbé, ẹ máa ṣe òwò yín kí ẹ sì kó ọrọ̀ jọ fún ara yín.” ");
INSERT INTO yor_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ṣekemu sì wí fún baba àti arákùnrin Dina pé, “Ẹ jọ̀wọ́, ẹ jẹ́ kí n rí ojúrere yín, èmi yóò sì fún yín ní ohunkóhun tí ẹ̀yin bá fẹ́ gbà. ");
INSERT INTO yor_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Iyekíye tí owó orí rẹ̀ bá jẹ́ àti ẹ̀bùn gbogbo tí ẹ bá fẹ́, bí ó ti wù kí ó pọ̀ tó, èmi yóò san án, kí ẹ sá à jẹ́ kí ń fi ọmọ náà ṣe aya.” ");
INSERT INTO yor_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Àwọn ọmọ Jakọbu sì fi ẹ̀tàn dá Ṣekemu àti Hamori baba rẹ̀ lóhùn, wọ́n sì wí pé, nítorí tí ó ti ba ògo Dina arábìnrin wọn jẹ́. ");
INSERT INTO yor_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Wọ́n wí fún wọn pé, “Àwa kò le ṣe nǹkan yìí láti fi arábìnrin wa fún aláìkọlà, nítorí àbùkù ni èyí yóò jẹ́ fún wa. ");
INSERT INTO yor_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Àwa yóò fi ara mọ́ ọn bí ẹ̀yin yóò bá gbà láti dàbí i tiwa, wí pé ẹ̀yin pẹ̀lú yóò kọ gbogbo ọkùnrin yín ní ilà. ");
INSERT INTO yor_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Nígbà náà ni àwa yóò le máa fún yín ní ọmọ wa, tí àwa náà yóò máa fẹ́ ẹ yín. A ó máa gbé láàrín yín, a ó sì di ara kan pẹ̀lú yín. ");
INSERT INTO yor_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ṣùgbọ́n bí ẹ̀yin bá kọ̀ láti kọlà, àwa yóò mú arábìnrin wa, á ó sì máa lọ.” ");
INSERT INTO yor_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Àbá náà sì dùn mọ́ Hamori àti Ṣekemu ọmọ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ọ̀dọ́mọkùnrin náà, ẹni tí ó jẹ́ ẹni iyì jùlọ ní ilé baba rẹ̀, kò jáfara láti ṣe ohun tí wọ́n wí. Nítorí tí ó fẹ́ràn ọmọbìnrin Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamori àti Ṣekemu ọmọ rẹ̀ sì wá sí ẹnu ibodè ìlú náà wọn sì bá àwọn ará ìlú náà sọ̀rọ̀. ");
INSERT INTO yor_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Wí pé, “Ìwà àwọn ọkùnrin wọ̀nyí dára, ẹ jẹ́ kí wọn máa gbé ní àárín wa, kí wọn sì máa ṣòwò, ilẹ̀ kúkú wà rẹpẹtẹ tó gba ààyè dáradára. A lè fẹ́ àwọn ọmọ wọ́n, ki wọn sì fẹ́ tiwa pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ṣùgbọ́n kín ní kan ni a lè ṣe kí wọn tó gbà láti gbé pẹ̀lú wa, ìyẹn sì ni pé àwọn ọkùnrin wa yóò kọlà bí i tiwọn. ");
INSERT INTO yor_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ṣe bí àwọn ẹran wọn àti ẹrú wọn àti àwọn ohun ọ̀sìn wọn ni yóò di tiwa bí a bá lè gbà bẹ́ẹ̀, wọn yóò sì máa gbé ni àárín wa.” ");
INSERT INTO yor_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Gbogbo àwọn ọkùnrin tí ń jáde ní ẹnu-bodè ìlú náà sì gbọ́ ti Hamori àti Ṣekemu ọmọ rẹ̀. Gbogbo ọkùnrin ìlú náà sì kọlà. ");
INSERT INTO yor_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Lẹ́yìn ọjọ́ kẹta, nígbà tí gbogbo wọn sì wà nínú ìrora. Àwọn ọmọ Jakọbu méjì, Simeoni àti Lefi tí ó jẹ́ ẹ̀gbọ́n fún Dina, sì mú idà wọn pẹ̀lú ìgboyà, wọ́n sì pa gbogbo ọkùnrin ìlú náà. ");
INSERT INTO yor_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Wọ́n sì fi idà pa Hamori àti Ṣekemu ọmọ rẹ̀, wọ́n mú Dina kúrò ní ilé wọn, wọ́n sì jáde. ");
INSERT INTO yor_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Àwọn ọmọ Jakọbu sì wọlé àwọn tí a pa, wọ́n sì kó ẹrù ìlú tí a ti ba ògo arábìnrin wọn jẹ́. ");
INSERT INTO yor_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wọ́n kó màlúù wọn àti agbo ẹran wọn àti kẹ́tẹ́kẹ́tẹ́, àti ohun gbogbo tí ó wà nínú ìlú àti ní oko. ");
INSERT INTO yor_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Gbogbo ọrọ̀ wọn, gbogbo obìnrin ìlú àti àwọn ọmọ wẹẹrẹ pátápátá ni wọ́n kó. Wọ́n sì kó gbogbo ohun tí ó wà nínú ilé wọn bí ìkógun. ");
INSERT INTO yor_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Nígbà náà ni Jakọbu wí fún Simeoni àti Lefi wí pé, “Ẹ̀yin ti kó ìyọnu bá mi nípa sísọ mí di olóòórùn láàrín ará Kenaani àti Peresi, tí ó ń gbé ilẹ̀ yìí. Àwa kò pọ̀, bí wọn bá wá parapọ̀ ṣígun sí wa, gbogbo wa pátápátá ni wọn yóò parun.” ");
INSERT INTO yor_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ṣùgbọ́n wọ́n dáhùn pé, “Ǹjẹ́ ó yẹ kí ó ṣe arábìnrin wa bí panṣágà?” ");
INSERT INTO yor_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Nígbà náà ni Ọlọ́run wí fún Jakọbu pé, “Gòkè lọ sí Beteli kí o sì tẹ̀dó síbẹ̀, kí ó mọ pẹpẹ níbẹ̀ fún Ọlọ́run tó farahàn ọ́ nígbà tí o ń sálọ kúrò níwájú Esau arákùnrin rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Nítorí náà, Jakọbu wí fún gbogbo ará ilé rẹ̀ pé, “Ẹ mú gbogbo àjèjì òrìṣà tí ó wà lọ́dọ̀ yín kúrò, kí ẹ ya ara yín sí mímọ́, kí ẹ sì pààrọ̀ aṣọ yín. ");
INSERT INTO yor_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nígbà náà ni kí ẹ wá, kí ẹ jẹ́ kí a lọ sí Beteli, níbi tí n ó ti mọ pẹpẹ fún Ọlọ́run, tí ó dá mi lóhùn ní ọjọ́ ìpọ́njú mi tí ó sì ti ń pẹ̀lú mi níbi gbogbo tí mo ń lọ.” ");
INSERT INTO yor_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Bẹ́ẹ̀ ni wọ́n fún Jakọbu ní gbogbo àjèjì òrìṣà tí ó wà lọ́wọ́ wọn, àti yẹtí etí wọn, Jakọbu sì bo gbogbo wọn mọ́lẹ̀ sábẹ́ igi óákù ní Ṣekemu. ");
INSERT INTO yor_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Wọ́n sì bẹ̀rẹ̀ ìrìnàjò wọn. Ìbẹ̀rù Ọlọ́run sì ń bẹ lára gbogbo ìlú tí ó yí wọn ká, wọ́n kò sì lépa àwọn ọmọ Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakọbu àti gbogbo àwọn tí ó wà pẹ̀lú rẹ̀ sì dé sí Lusi (ti o túmọ̀ sí Beteli) tí ó wà ní ilẹ̀ Kenaani. ");
INSERT INTO yor_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Níbẹ̀ ni ó sì mọ pẹpẹ kan tí ó pè ní El-Beteli, nítorí níbẹ̀ ni Ọlọ́run ti gbé fi ara hàn án nígbà tí ó ń sálọ fún arákùnrin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Kò pẹ́ lẹ́yìn èyí ni Debora, olùtọ́jú Rebeka kú, a sì sin ín sábẹ́ igi óákù ní ìsàlẹ̀ Beteli. Nítorí náà a sọ ọ́ ní Aloni-Bakuti. ");
INSERT INTO yor_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Lẹ́yìn tí Jakọbu padà dé láti Padani-Aramu, Ọlọ́run tún fi ara hàn án, ó sì súre fún un. ");
INSERT INTO yor_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ọlọ́run sì wí fun un pé, “Jakọbu ni orúkọ rẹ, a kì yóò pè ọ́ ní Jakọbu mọ́; bí kò ṣe Israẹli.” Nítorí náà, ó sọ orúkọ rẹ̀ ní Israẹli. ");
INSERT INTO yor_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ọlọ́run sì wí fún un pé, “Èmi ni Ọlọ́run alágbára, El-Ṣaddai; máa bí sí i, kí o sì máa pọ̀ sí i. Orílẹ̀-èdè àti ọ̀pọ̀lọpọ̀ orílẹ̀-èdè ni yóò ti ọ̀dọ̀ rẹ̀ wá, àwọn ọba yóò sì jáde wá láti ara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Gbogbo ilẹ̀ tí mo fi fún Abrahamu àti Isaaki ni èmi yóò fún ọ pẹ̀lú, àti fún àwọn ìran rẹ tí ó ń bọ̀ lẹ́yìn.” ");
INSERT INTO yor_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Nígbà náà ni Ọlọ́run gòkè lọ kúrò ní ibi tí ó ti ń bá a sọ̀rọ̀. ");
INSERT INTO yor_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakọbu sì fi òkúta ṣe ọ̀wọ̀n kan sí ibi tí Ọlọ́run ti bá a sọ̀rọ̀, ó sì ta ọrẹ ohun mímu sí orí rẹ̀, ó sì da òróró olifi sí orí rẹ̀ pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jakọbu sì pe orúkọ ibi tí Ọlọ́run ti bá a sọ̀rọ̀ ní Beteli. ");
INSERT INTO yor_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Nígbà náà ni wọ́n ń tẹ̀síwájú nínú ìrìnàjò wọn láti Beteli. Nígbà tí ó sì ku díẹ̀ kí wọn dé Efrata, Rakeli bẹ̀rẹ̀ sí ní rọbí, ó sì ní ìdààmú púpọ̀. ");
INSERT INTO yor_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Bí ó sì ti ń rọbí pẹ̀lú ìrora yìí, agbẹ̀bí wí fún un pé, “Má bẹ̀rù nítorí ọmọkùnrin mìíràn ni ó ń bọ̀ yìí.” ");
INSERT INTO yor_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Bí o sì ti fẹ́ gbé ẹ̀mí mi, torí pé ó ń kú lọ, ó pe ọmọ rẹ̀ náà ní Bene-Oni, ọmọ ìpọ́njú. Ṣùgbọ́n Jakọbu sọ ọmọ náà ní Benjamini, ọmọ oókan àyà mi. ");
INSERT INTO yor_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Báyìí ni Rakeli kú, a sì sin ín sí ọ̀nà Efrata (ti o túmọ̀ sí, Bẹtilẹhẹmu). ");
INSERT INTO yor_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakọbu sì mọ ọ̀wọ́n kan sí ibojì rẹ̀, ọ̀wọ̀n náà sì tọ́ka sí ojú ibojì Rakeli títí di òní. ");
INSERT INTO yor_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israẹli sì ń bá ìrìnàjò rẹ̀ lọ, ó sì pa àgọ́ rẹ̀ sí Migida-Ederi, ilé ìṣọ́ Ederi. ");
INSERT INTO yor_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Nígbà tí Israẹli sì ń gbé ní ibẹ̀, Reubeni wọlé tọ Biliha, àlè baba rẹ̀ lọ, ó sì bá a lòpọ̀, Israẹli sì gbọ́ ọ̀rọ̀ náà. Jakọbu sì bí ọmọkùnrin méjìlá. ");
INSERT INTO yor_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Àwọn ọmọ Lea, Reubeni tí í ṣe àkọ́bí Jakọbu, Simeoni, Lefi, Juda, Isakari àti Sebuluni. ");
INSERT INTO yor_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Àwọn ọmọ Rakeli: Josẹfu àti Benjamini. ");
INSERT INTO yor_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Àwọn ọmọ Biliha ìránṣẹ́bìnrin Rakeli: Dani àti Naftali. ");
INSERT INTO yor_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Àwọn ọmọ Silipa ìránṣẹ́bìnrin Lea: Gadi àti Aṣeri. Àwọn wọ̀nyí ni ọmọ tí Jakọbu bí ní Padani-Aramu. ");
INSERT INTO yor_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakọbu sì padà dé ilé lọ́dọ̀ Isaaki baba rẹ̀ ni Mamre nítòsí i Kiriati-Arba (ti o túmọ̀ sí Hebroni). Níbi tí Abrahamu àti Isaaki gbé. ");
INSERT INTO yor_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ẹni ọgọ́sàn-án ọdún ni Isaaki. ");
INSERT INTO yor_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaaki sì kú láìpẹ́ lẹ́yìn ìpadàbọ̀ Jakọbu, a sì sin ín pẹ̀lú àwọn ènìyàn rẹ̀ ní ọjọ́ ogbó rẹ̀. Esau àti Jakọbu ọmọ rẹ̀ sì sin ín. ");
INSERT INTO yor_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Wọ̀nyí ni ìran Esau, ẹni tí a ń pè ní Edomu. ");
INSERT INTO yor_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nínú àwọn ọmọbìnrin Kenaani ni Esau ti fẹ́ àwọn ìyàwó rẹ̀: Adah ọmọbìnrin Eloni ará Hiti àti Oholibama, ọmọbìnrin Ana, ọmọ ọmọ Sibeoni ará Hifi. ");
INSERT INTO yor_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ó sì tún fẹ́ Basemati ọmọ Iṣmaeli arábìnrin Nebaioti. ");
INSERT INTO yor_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah bí Elifasi fún Esau, Basemati sì bí Reueli, ");
INSERT INTO yor_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama pẹ̀lú sì bí Jeuṣi, Jalamu, àti Kora. Àwọn wọ̀nyí ni ọmọ tí Esau bí ní Kenaani. ");
INSERT INTO yor_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau sì mú àwọn aya rẹ̀, àwọn ọmọkùnrin rẹ̀, àwọn ọmọbìnrin rẹ̀ àti gbogbo àwọn ará ilé rẹ̀, àwọn ohun ọ̀sìn rẹ̀ àti àwọn ẹran ọ̀sìn mìíràn àti gbogbo ohun ìní mìíràn tí ó ní, ni Kenaani, ó sì kó lọ sí ilẹ̀ mìíràn, jìnà sí ibi tí Jakọbu arákùnrin rẹ̀ wà. ");
INSERT INTO yor_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ohun ìní wọn pọ̀ ju èyí tí àwọn méjèèjì lè máa gbé ní ojú kan lọ. Ilẹ̀ tí wọ́n wà kò le gba àwọn méjèèjì nítorí àwọn ohun ọ̀sìn wọn. ");
INSERT INTO yor_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Báyìí ni Esau (tí a tún mọ̀ sí Edomu) tẹ̀dó sí àwọn orílẹ̀-èdè olókè tí Seiri. ");
INSERT INTO yor_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Èyí ni ìran Esau baba àwọn ará Edomu ní àwọn orílẹ̀-èdè olókè Seiri. ");
INSERT INTO yor_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Wọ̀nyí ni orúkọ àwọn ọmọ Esau: Elifasi ọmọ Adah aya Esau àti Reueli, ọmọ Basemati tí í ṣe aya Esau pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Àwọn ọmọ Elifasi ni ìwọ̀nyí: Temani, Omari, Sefi, Gatamu, àti Kenasi. ");
INSERT INTO yor_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifasi ọmọ Esau sì tún ní àlè tí a ń pè ní Timna pẹ̀lú, òun ló bí Amaleki fún un. Wọ̀nyí ni àwọn ọmọ ọmọ Adah aya Esau. ");
INSERT INTO yor_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Àwọn ọmọ Reueli: Nahati, Sera, Ṣamma àti Missa. Àwọn ni ọmọ ọmọ Basemati aya Esau. ");
INSERT INTO yor_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Wọ̀nyí ni àwọn ọmọ Oholibama ọmọbìnrin Ana ọmọ ọmọ Sibeoni: tí ó bí fún Esau: Jeuṣi, Jalamu àti Kora. ");
INSERT INTO yor_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Àwọn wọ̀nyí ni olórí nínú àwọn ọmọ Esau: àwọn ọmọ Elifasi, àkọ́bí Esau, Temani, Omari, Sefi, Kenasi, ");
INSERT INTO yor_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatamu àti Amaleki. Àwọn wọ̀nyí ló jẹ́ olórí ìdílé tí ó ti ọ̀dọ̀ Elifasi ní Edomu wá, wọ́n jẹ́ ọmọ ọmọ Adah. ");
INSERT INTO yor_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Wọ̀nyí sì ni àwọn ọmọ Esau, ọmọ Rueli: Nahati olórí, Sera olórí, Ṣamma olórí, Missa olórí. Àwọn wọ̀nyí ló jẹ́ olórí ìdílé tí ó ti ọ̀dọ̀ Reueli jáde ní Edomu. Ọmọ ọmọ Basemati aya Esau ni wọ́n jẹ́. ");
INSERT INTO yor_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Àwọn ọmọ Oholibama aya Esau: Jeuṣi, Jalamu, àti Kora, àwọn wọ̀nyí ló jẹ́ olórí ìdílé tí ó ti ọ̀dọ̀ Oholibama ọmọ Ana, ìyàwó Esau wá. ");
INSERT INTO yor_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Àwọn wọ̀nyí ni ọmọ Esau (ti o túmọ̀ sí Edomu). Àwọn wọ̀nyí ni olórí wọn. ");
INSERT INTO yor_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Wọ̀nyí ni àwọn ọmọ Seiri ará Hori tí ó ń gbé ní ilẹ̀ náà: Lotani, Ṣobali, Sibeoni, Ana, ");
INSERT INTO yor_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Diṣoni, Eseri, àti Diṣani, àwọn wọ̀nyí olórí ènìyàn Hori, àwọn ọmọ Seiri ni ilẹ̀ Edomu. ");
INSERT INTO yor_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Àwọn ọmọ Lotani: Hori àti Homamu: Timna sì ni arábìnrin Lotani. ");
INSERT INTO yor_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Àwọn ọmọ Ṣobali: Alifani, Manahati, Ebali, Ṣefo àti Onamu. ");
INSERT INTO yor_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Àwọn ọmọ Sibeoni: Aiah àti Ana. Èyí ni Ana tí ó rí ìsun omi gbígbóná ní inú aginjù bí ó ti ń da àwọn kẹ́tẹ́kẹ́tẹ́ Ṣebeoni baba rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Wọ̀nyí ni àwọn ọmọ Ana: Diṣoni àti Oholibama ọmọbìnrin Ana. ");
INSERT INTO yor_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Àwọn ọmọ Diṣoni ni: Hemdani, Eṣbani, Itrani àti Kerani. ");
INSERT INTO yor_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Àwọn ọmọ Eseri: Bilhani, Saafani àti Akani. ");
INSERT INTO yor_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Àwọn ọmọ Diṣani ni: Usi àti Arani. ");
INSERT INTO yor_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Àwọn wọ̀nyí ni olórí ìdílé Hori: Lotani, Ṣobali, Sibeoni, Ana, ");
INSERT INTO yor_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Diṣoni Eseri, àti Diṣani. Àwọn ni olórí ìdílé àwọn ará Hori gẹ́gẹ́ bí ìpín wọn ní ilẹ̀ Seiri. ");
INSERT INTO yor_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Àwọn wọ̀nyí ni ọba tí ó jẹ ní Edomu kí ó tó di pé ọba kankan jẹ lórí Israẹli: ");
INSERT INTO yor_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela ọmọ Beori jẹ ní Edomu. Orúkọ ìlú rẹ̀ ni Dinhaba. ");
INSERT INTO yor_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Nígbà tí Bela kú, Jobabu ọmọ Sera ti Bosra sì jẹ ọba ní ipò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Nígbà tí Jobabu kú, Huṣamu láti ilẹ̀ Temani sì jẹ ọba ní ipò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Nígbà tí Huṣamu kú, Hadadi ọmọ Bedadi tí ó kọlu Midiani ní ìgbẹ́ Moabu, ó sì jẹ ọba ní ipò rẹ̀. Orúkọ ìlú rẹ̀ ni Afiti. ");
INSERT INTO yor_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Nígbà tí Hadadi sì kú, Samla láti Masreka, ó sì jẹ ọba ní ipò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla sì kú, Saulu ti Rehoboti, létí odò sì jẹ ọba ní ipò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Nígbà tí Saulu kú, Baali-Hanani ọmọ Akbori jẹ ọba ní ipò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Nígbà tí Baali-Hanani ọmọ Akbori kú, Hadadi ni ó jẹ ọba ní ipò rẹ̀. Orúkọ ìlú rẹ̀ ni Pau, orúkọ ìyàwó sì ni Mehetabeeli ọmọbìnrin Matiredi, ọmọbìnrin Mesahabu. ");
INSERT INTO yor_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Àwọn wọ̀nyí ni orúkọ àwọn baálẹ̀ tí ó ti ọ̀dọ̀ Esau jáde wá, ní orúkọ ìdílé wọn, bí ìpínlẹ̀ wọn ti rí: baálẹ̀ Timna, baálẹ̀ Alfa, baálẹ̀ Jeteti. ");
INSERT INTO yor_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Baálẹ̀ Oholibama, baálẹ̀ Ela, baálẹ̀ Pinoni, ");
INSERT INTO yor_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","baálẹ̀ Kenasi, baálẹ̀ Temani, baálẹ̀ Mibsari, ");
INSERT INTO yor_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdieli, àti Iramu. Àwọn wọ̀nyí ni baálẹ̀ Edomu, gẹ́gẹ́ bí wọn ti tẹ̀dó sí ilẹ̀ tí wọ́n gbà. Èyí ni Esau baba àwọn ará Edomu. ");
INSERT INTO yor_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakọbu sì gbé ilẹ̀ Kenaani ní ibi ti baba rẹ̀ ti gbé. ");
INSERT INTO yor_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Èyí ni àwọn ìtàn Jakọbu. Nígbà tí Josẹfu di ọmọ ọdún mẹ́tàdínlógún, ó ń ṣọ́ agbo ẹran pẹ̀lú àwọn arákùnrin rẹ̀, àwọn ọmọ Biliha àti Silipa aya baba rẹ̀ Josẹfu sì ń ròyìn àwọn aburú tí wọ́n ń ṣe fún baba wọn. ");
INSERT INTO yor_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israẹli sì fẹ́ràn Josẹfu ju gbogbo àwọn ọmọ rẹ̀ tókù lọ, nítorí ní ọjọ́ ogbó rẹ̀ ni ó bí i. O sì dá aṣọ aláràbarà tí ó kún fún onírúurú ọnà lára fún un. ");
INSERT INTO yor_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nígbà tí àwọn arákùnrin rẹ̀ rí i pé baba àwọn fẹ́ràn rẹ̀ ju gbogbo wọn lọ, wọ́n kórìíra rẹ̀, wọ́n sì ń fi ẹ̀tanú bá a gbé, kò sì sí àlàáfíà láàrín wọn. ");
INSERT INTO yor_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Josẹfu lá àlá kan, nígbà tí ó sì sọ fún àwọn arákùnrin rẹ̀, wọ́n túbọ̀ kórìíra rẹ̀ sí i. ");
INSERT INTO yor_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","O wí fún wọn pé, “Ẹ fetí sí àlá tí mo lá, ");
INSERT INTO yor_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","sá à wò ó, àwa ń yí ìtí ọkà nínú oko, ó sì ṣe ìtí ọkà tèmi sì dìde dúró ṣánṣán, àwọn ìtí ọkà tiyín sì dúró yí ìtí tèmi ká, wọ́n sì ń foríbalẹ̀ fún un.” ");
INSERT INTO yor_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Àwọn arákùnrin rẹ̀ wí fún un pé, “Ìwọ ń gbèrò àti jẹ ọba lé wa lórí bí? Tàbí ìwọ ó ṣe olórí wa nítòótọ́?” Wọn sì túbọ̀ kórìíra rẹ̀ sí i, nítorí àlá rẹ̀ àti nítorí ohun tí ó wí. ");
INSERT INTO yor_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","O sì tún lá àlá mìíràn, ó sì tún sọ ọ́ fún àwọn arákùnrin rẹ̀. Ó wí pé, ẹ tẹ́tí sí mi, “Mo tún lá àlá mìíràn, wò ó, oòrùn, òṣùpá àti ìràwọ̀ mọ́kànlá ń foríbalẹ̀ fún mi.” ");
INSERT INTO yor_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Nígbà tí ó sọ fún baba rẹ̀ àti àwọn arákùnrin rẹ̀ pẹ̀lú, baba rẹ̀ bá a wí pé, “Irú àlá wo ni ìwọ lá yìí? Ṣé ìyá rẹ, pẹ̀lú èmi àti àwọn ẹ̀gbọ́n rẹ yóò wá foríbalẹ̀ níwájú rẹ ni?” ");
INSERT INTO yor_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Àwọn arákùnrin rẹ̀ sì ń ṣe ìlara rẹ̀ ṣùgbọ́n baba rẹ̀ pa ọ̀rọ̀ náà mọ́ lọ́kàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Àwọn arákùnrin rẹ̀ sì da ẹran baba wọn lọ sí Ṣekemu. ");
INSERT INTO yor_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israẹli sì wí fún Josẹfu pé, “Ṣé o mọ̀ pé, àwọn arákùnrin rẹ ń da ẹran ní Ṣekemu, wá, jẹ́ kí n rán ọ sí wọn.” Josẹfu sì dáhùn pé, “Èmi nìyí.” ");
INSERT INTO yor_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","O sì wí fún un pé, “Lọ wò bí àwọn arákùnrin rẹ àti àwọn agbo ẹran bá wà ní àlàáfíà, kí o sì wá jíṣẹ́ fún mi.” Ó sì rán Josẹfu lọ láti àfonífojì Hebroni. Nígbà tí Josẹfu dé Ṣekemu, ");
INSERT INTO yor_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ọkùnrin kan sì rí i tí ó ń rìn kiri inú pápá, ó sì bi í pé, “Kín ni ò ń wá?” ");
INSERT INTO yor_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ó sì dáhùn pé, “Àwọn arákùnrin mi ni mò ń wá, ǹjẹ́ o mọ ibi tí wọ́n wà pẹ̀lú agbo ẹran?” ");
INSERT INTO yor_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ọkùnrin náà dáhùn pé, “Wọ́n ti kúrò ní ìhín, mo gbọ́ tí wọ́n ń wí pé, ‘Ẹ jẹ́ kí a lọ sí Dotani.’ ” Josẹfu sì wá àwọn arákùnrin rẹ̀ lọ, ó sì rí wọn ní tòsí Dotani. ");
INSERT INTO yor_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ṣùgbọ́n bí wọ́n sì ti rí i tí ń bọ̀ lókèèrè, kí ó sì tó dé ọ̀dọ̀ wọn, wọn gbìmọ̀ pọ̀ láti pa á. ");
INSERT INTO yor_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Alálàá ni ń bọ̀ yìí,” ni wọ́n ń wí fún ara wọn. ");
INSERT INTO yor_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Ẹ wá, ẹ jẹ́ kí a pa á. Kí a sì ju òkú rẹ̀ sínú kòtò, a ó sì wí pé, ẹranko búburú ni ó pa á, kí a máa wo ọ̀nà tí àlá rẹ̀ yóò gbà ṣẹ.” ");
INSERT INTO yor_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Nígbà tí Reubeni gbọ́ èyí, ó gbìyànjú láti gbà á sílẹ̀ ní ọwọ́ wọn, ó sì wí pé, “Ẹ má ṣe jẹ́ kí a gba ẹ̀mí rẹ̀, ");
INSERT INTO yor_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ẹ má ṣe jẹ́ kí a ta ẹ̀jẹ̀ sílẹ̀, ẹ má ṣe fọwọ́ kàn án, ẹ kúkú jù ú sínú kòtò láààyè nínú aginjù níbí.” Reubeni sọ èyí, kí ó ba à le gbà á kúrò lọ́wọ́ wọn, kí ó sì dá a padà lọ fún baba rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Nítorí náà, nígbà tí Josẹfu dé ọ̀dọ̀ àwọn arákùnrin rẹ̀, wọ́n bọ́ ẹ̀wù rẹ̀—Ẹ̀wù ọlọ́nà, aláràbarà tí ó wọ̀— ");
INSERT INTO yor_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","wọ́n mú un, wọ́n sì jù ú sínú kòtò. Kòtò náà sì ṣófo, kò sí omi nínú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Bí wọ́n sì ti jókòó láti jẹun, wọ́n gbójú sókè, wọ́n sì rí àwọn oníṣòwò ará Iṣmaeli tí wọ́n ń wọ́ bọ̀ láti Gileadi. Ìbákasẹ wọn sì ru tùràrí, ìkunra àti òjìá, wọ́n ń lọ sí Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juda wí fún àwọn arákùnrin rẹ̀ pé, “Èrè kí ni ó jẹ́ bí a bá pa arákùnrin wa tí a bo ẹ̀jẹ̀ rẹ̀ mọ́lẹ̀ ti ọkàn wa sì ń dá wa lẹ́bi? ");
INSERT INTO yor_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ẹ wá, ẹ jẹ́ kí á tà á fún àwọn ará Iṣmaeli, kí àwa má sì pa á, ṣè bí àbúrò wa ni, ẹran-ara wa àti ẹ̀jẹ̀ wa ní i ṣe.” Àwọn arákùnrin rẹ̀ sì fi ara mọ́ ohun tí ó sọ. ");
INSERT INTO yor_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Nítorí náà, nígbà tí àwọn oníṣòwò ara Midiani ń kọjá, àwọn arákùnrin Josẹfu fà á jáde láti inú kòtò, wọ́n sì tà á fún àwọn ará Iṣmaeli ní ogún owó wúrà, wọ́n sì mú Josẹfu lọ sí ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nígbà tí Reubeni padà dé ibi kòtò tí ó sì ri pé Josẹfu kò sí níbẹ̀ mọ́, ó fa aṣọ rẹ̀ ya pẹ̀lú ìbànújẹ́. ");
INSERT INTO yor_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ó padà lọ sí ọ̀dọ̀ àwọn arákùnrin rẹ̀, ó sì wí pé, “Ọmọdékùnrin náà kò sí níbẹ̀ mọ́! Níbo ni ẹ fẹ́ kí n wọ̀ báyìí?” ");
INSERT INTO yor_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nígbà náà ni wọ́n mú aṣọ Josẹfu, wọ́n pa ewúrẹ́ kan, wọ́n sì tẹ aṣọ náà bọ inú ẹ̀jẹ̀ ewúrẹ́ náà. ");
INSERT INTO yor_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Wọ́n sì mú aṣọ ọlọ́nà aláràbarà náà padà sí ọ̀dọ̀ baba wọn, wọ́n sì wí pé, “A rí èyí he nínú oko, yẹ̀ ẹ́ wò, kí o sì mọ̀ bóyá ti ọmọ rẹ ni.” ");
INSERT INTO yor_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ó sì dá a mọ̀, ó wí pé, “Háà! Aṣọ ọmọ mi ni, ẹranko búburú ti pa á jẹ, láìṣe àní àní, ó ti fa Josẹfu ya pẹ́rẹpẹ̀rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Nígbà náà ni Jakọbu fa aṣọ rẹ̀ ya, ó sì wọ aṣọ ọ̀fọ̀, ó sì ṣọ̀fọ̀ ọmọ rẹ̀ fún ọ̀pọ̀lọpọ̀ ọjọ́. ");
INSERT INTO yor_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Gbogbo àwọn ọmọ rẹ̀ lọ́kùnrin, lóbìnrin wá láti tù ú nínú, ṣùgbọ́n kò gbà. Ó wí pé, “Rárá, nínú ọ̀fọ̀ yìí ni èmi yóò lọ sí isà òkú lọ́dọ̀ ọmọ mi.” Baba Josẹfu sì sọkún fún un. ");
INSERT INTO yor_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ní gbogbo àkókò wọ̀nyí, àwọn ará Midiani ta Josẹfu ní Ejibiti fún Potifari, ọ̀kan nínú àwọn ìjòyè Farao, tí í ṣe olórí ẹ̀ṣọ́. ");
INSERT INTO yor_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ní àkókò náà, Juda lọ kúrò lọ́dọ̀ àwọn arákùnrin rẹ̀ láti lọ dúró lọ́dọ̀ ọkùnrin ará Adullamu kan tí ń jẹ́ Hira. ");
INSERT INTO yor_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Juda sì pàdé ọmọbìnrin Kenaani kan níbẹ̀ ẹni ti orúkọ rẹ̀ ń jẹ́ Ṣua. Ó sì fi ṣe aya, ó sì bá a lòpọ̀; ");
INSERT INTO yor_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ó sì lóyún, ó sì bí ọmọkùnrin kan, tí ó sọ orúkọ rẹ̀ ní Eri. ");
INSERT INTO yor_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ó sì tún lóyún, ó sì bí ọmọkùnrin, ó sì sọ orúkọ rẹ̀ ní Onani. ");
INSERT INTO yor_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ó sì tún bí ọmọkùnrin mìíràn, ó sì pe orúkọ rẹ̀ ní Ṣela. Ní Kesibu ni ó wà nígbà tí ó bí i. ");
INSERT INTO yor_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda sì fẹ́ aya fún Eri, àkọ́bí rẹ̀, orúkọ aya náà ni Tamari. ");
INSERT INTO yor_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ṣùgbọ́n Eri àkọ́bí Juda ṣe ènìyàn búburú níwájú Olúwa, Ọlọ́run sì pa á. ");
INSERT INTO yor_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Nígbà náà ni Juda wí fún Onani, “Bá aya arákùnrin rẹ lòpọ̀, kí o ṣe ojúṣe rẹ fun un gẹ́gẹ́ bí àbúrò ọkọ, kí ó ba à le bí ọmọ fún un ní orúkọ arákùnrin rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ṣùgbọ́n Onani mọ̀ pé àwọn ọmọ náà kì yóò jẹ́ ti òun, nítorí náà ni gbogbo ìgbà tí ó bá wọlé tọ aya arákùnrin rẹ̀ lọ, ilẹ̀ ni ó ń da nǹkan ọkùnrin rẹ̀ sí, kí ó má bá a bímọ fún arákùnrin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ohun tí ó ń ṣe yìí burú lójú Olúwa, ó sì pa òun náà pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Nígbà náà ni Juda wí fún Tamari, ìyàwó ọmọ rẹ̀ pé, “Lọ máa gbé bí opó ní ilé baba rẹ, títí tí Ṣela yóò fi dàgbà ó lérò pé òun náà lè kú bí àwọn arákùnrin rẹ̀ tókù.” Nígbà náà ni Tamari ń lọ gbé ilé baba rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Lẹ́yìn ìgbà pípẹ́, ìyàwó Juda, ọmọbìnrin Ṣua sì kú, nígbà tí ọjọ́ ọ̀fọ̀ Juda sì pé, ó gòkè lọ sí Timna, sí ọ̀dọ̀ àwọn tí ń bá a rẹ́run àgùntàn rẹ̀, Hira ará Adullamu tí í ṣe ọ̀rẹ́ rẹ̀ sì bá a lọ. ");
INSERT INTO yor_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Nígbà tí ẹnìkan sọ fún Tamari pé, “Baba ọkọ ọ̀ rẹ̀ wà ní ọ̀nà àjò rẹ̀ sí Timna láti rẹ́run àgùntàn rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ó bọ́ aṣọ opó rẹ̀, ó sì fi ìbòjú bo ojú ara rẹ̀ kí wọn má ba à mọ̀ ọ́n. Ó sì jókòó sí ẹnu-bodè Enaimu, èyí tí ó wà ní ọ̀nà Timna. Nítorí ó rí i wí pé, bí ó tilẹ̀ jẹ́ pé Ṣela ti dàgbà, síbẹ̀, a kò fi òun fún un gẹ́gẹ́ bí aya. ");
INSERT INTO yor_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Nígbà tí Juda rí i, ó rò pé panṣágà ni, nítorí ó ti bo ojú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Láìmọ̀ pé, aya ọmọ òun ní í ṣe, ó yà tọ̀ ọ́ ní ẹ̀bá ọ̀nà, ó wí pé, “Wá kí èmi kí ó lè wọlé tọ̀ ọ́.” Òun sì wí pé, “Kín ni ìwọ yóò fi fún mi kí ìwọ kó lè wọlé tọ̀ mí.” ");
INSERT INTO yor_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ó sì wí pé, “Èmi yóò fi ọmọ ewúrẹ́ kan ránṣẹ́ sí ọ láti inú agbo ẹran.” Obìnrin náà sì dáhùn pé, “Ṣé ìwọ yóò fún mi ní ohun kan gẹ́gẹ́ bí ẹ̀rí títí tí ìwọ yóò fi fi ránṣẹ́?” ");
INSERT INTO yor_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Juda sì bi í pé, “Ẹ̀rí wo ni kí n fún ọ?” Ó sì dáhùn pé, “Èdìdì ìdámọ̀ okùn àti ọ̀pá ìtìlẹ̀ rẹ ti ń bẹ ní ọwọ́ rẹ.” Ó sì kó wọn fún un, ó sì sùn tì í, obìnrin náà sì lóyún nípasẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Lẹ́yìn ìgbà tí ó lọ, ó bọ́ ìbòjú ojú rẹ̀, ó sì tún wọ aṣọ opó rẹ̀ padà. ");
INSERT INTO yor_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda sì rán ọmọ ewúrẹ́ náà láti ọwọ́ ọ̀rẹ́ rẹ̀, ará Adullamu náà lọ láti gba ògo n nì wá lọ́wọ́ obìnrin náà. Ṣùgbọ́n wọn kò bá obìnrin náà níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ó béèrè lọ́wọ́ àwọn ènìyàn àdúgbò náà pé, “Níbo ni alágbèrè ojúbọ òrìṣà tí ó wà ní etí ọ̀nà Enaimu wà?” Wọ́n sì dá a lóhùn pé, “Kò sí alágbèrè ojúbọ òrìṣà kankan níbí.” ");
INSERT INTO yor_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ó sì padà lọ sọ́dọ̀ Juda ó wí fún un pé, “Èmí kò rí i, à ti pé àwọn aládùúgbò ibẹ̀ sọ pé kò sí alágbèrè ojúbọ òrìṣà kankan níbẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Nígbà náà ni Juda wí pé, “Jẹ́ kí ó máa kó àwọn ohun tí ó wà lọ́wọ́ rẹ̀ lọ bí kò ṣe bẹ́ẹ̀ a ó di ẹlẹ́yà. Mo sá à fi ọmọ ewúrẹ́ ránṣẹ́ sí i, ṣùgbọ́n ìwọ kò rí òun.” ");
INSERT INTO yor_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Lẹ́yìn nǹkan bí oṣù mẹ́ta, wọn sọ fún Juda pé, “Tamari aya ọmọ rẹ̀ ṣe àgbèrè, ó sì ti lóyún.” Juda sì wí pé, “Ẹ mú un jáde, kí ẹ sì dá iná sun ún.” ");
INSERT INTO yor_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Bí wọ́n sì ti ń mú un jáde, ó ránṣẹ́ sí baba ọkọ rẹ̀ pé, “Ọkùnrin tí ó ni àwọn nǹkan wọ̀nyí ni ó fún mi lóyún. Wò ó, bóyá o lè mọ ẹni tí ó ni èdìdì ìdámọ̀, okùn àti ọ̀pá ìtìlẹ̀ wọ̀nyí.” ");
INSERT INTO yor_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda sì dá wọn mọ̀, ó sì wí pé, “O ṣe olódodo jù mí lọ, níwọ̀n ìgbà tí n kò fi fún Ṣela ọmọ mi.” Kò sì bá a lòpọ̀ mọ́ láti ọjọ́ náà. ");
INSERT INTO yor_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Nígbà tí àsìkò ìbímọ rẹ̀ tó. Ìbejì ọkùnrin ni ó bí. ");
INSERT INTO yor_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Bí ó sì ti ń bímọ, ọ̀kan nínú àwọn ọmọ náà na ọwọ́ jáde; agbẹ̀bí sì so okùn òdòdó mọ́ ọmọ náà ní ọrùn ọwọ́. Ó sì wí pé, “Èyí ni o kọ́kọ́ jáde.” ");
INSERT INTO yor_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ṣùgbọ́n nígbà tí ó fa ọwọ́ rẹ̀ padà, èkejì rẹ̀ jáde. Tamari sì wí pé, “Níbo ni ìwọ ti wá?” Ó sì pe orúkọ rẹ̀ ní Peresi. ");
INSERT INTO yor_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Nígbà náà ni èkejì tí a ti so okùn olódòdó mọ́ lọ́rùn ọwọ́ jáde, wọ́n sì pe orúkọ rẹ̀ ni Sera. ");
INSERT INTO yor_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nígbà tí wọ́n mú Josẹfu dé Ejibiti, Potifari, ará Ejibiti tí i ṣe ọ̀kan nínú àwọn ìjòyè Farao. Òun ni olórí àwọn ọmọ-ogun Farao. Ó ra Josẹfu lọ́wọ́ àwọn ará Iṣmaeli tí wọ́n mú un lọ síbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Olúwa sì wà pẹ̀lú Josẹfu, ó sì bùkún un, ó sì ń gbé ní ilé ọ̀gá rẹ̀ ará Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nígbà tí ọ̀gá rẹ̀ rí i pé Olúwa wà pẹ̀lú rẹ̀, àti pé Olúwa jẹ́ kí ó máa ṣe àṣeyọrí nínú ohun gbogbo tí ó dáwọ́ rẹ̀ lé. ");
INSERT INTO yor_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Josẹfu sì rí ojúrere Potifari, ó sì di aṣojú rẹ̀, Potifari fi Josẹfu ṣe olórí ilé rẹ̀ àti ohun gbogbo tí ó ní. ");
INSERT INTO yor_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Láti ìgbà tí ó ti fi Josẹfu jẹ olórí ilé rẹ̀ àti ohun ìní rẹ̀ gbogbo, ni Ọlọ́run ti bẹ̀rẹ̀ sí ní bùkún àwọn ará Ejibiti nítorí Josẹfu. Ìbùkún Olúwa wà lórí gbogbo ohun tí Potifari ní, nílé àti lóko. ");
INSERT INTO yor_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ó sì fi Josẹfu ṣe àkóso gbogbo ohun tí ó ní. Kò sì ṣe ìyọnu lórí ohunkóhun mọ àyàfi nípa oúnjẹ tí ó ń jẹ láti ìgbà tí ó ti fi Josẹfu ṣe àkóso ilé e rẹ̀. Josẹfu sì jẹ́ arẹwà ọkùnrin ní ìdúró àti ìrísí rẹ̀, ");
INSERT INTO yor_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","lẹ́yìn ìgbà díẹ̀, aya rẹ̀ ṣe àkíyèsí Josẹfu, ó sì wí fún un pé, “Wá bá mi lòpọ̀!” ");
INSERT INTO yor_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ṣùgbọ́n Josẹfu kọ̀, ó sì wí fún aya ọ̀gá rẹ̀ pé, “Kíyèsi, Olúwa mi kò fi ohunkóhun dù mi nínú ilé yìí, gbogbo ohun ìní rẹ̀ ni ó fi lé mi lọ́wọ́. ");
INSERT INTO yor_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Kò sí ẹni tí ó jù mi lọ nínú ilé yìí, ọ̀gá mi kò fi ohunkóhun dù mi àyàfi ìwọ, tí í ṣe aya rẹ̀. Báwo ni mo ṣe lè ṣe ohun búburú yìí, kí ń sì ṣẹ̀ sí Ọlọ́run?” ");
INSERT INTO yor_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bí ó tilẹ̀ jẹ́ pé gbogbo ìgbà ni ó ń tẹnumọ́ èyí fún Josẹfu, Josẹfu kọ̀ láti bá a lòpọ̀. Ó tilẹ̀ kọ̀ láti máa dúró ni ibi tí ó bá wà. ");
INSERT INTO yor_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ní ọjọ́ kan, Josẹfu lọ sínú ilé láti ṣe iṣẹ́, kò sì sí èyíkéyìí nínú àwọn ìránṣẹ́ ní tòsí. ");
INSERT INTO yor_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ó sì di aṣọ Josẹfu mú, ó sì wí pé, “Wá bá mi lòpọ̀!” Ṣùgbọ́n Josẹfu fi aṣọ rẹ̀ sílẹ̀ sí i lọ́wọ́, ó sì sá jáde. ");
INSERT INTO yor_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Nígbà tí ó rí i pé ó ti fi aṣọ rẹ̀ sílẹ̀ sí òun lọ́wọ́, ó sì ti sá jáde, ");
INSERT INTO yor_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ó pe àwọn ìránṣẹ́ ilé náà, ó sì wí fún wọn pé, “Ẹ wò ó, ọkọ ọ̀ mi mú Heberu kan wọlé tọ̀ wá wá láti fi wá ṣe ẹlẹ́yà. Ó wọlé tọ̀ mí wá, láti bá mi lòpọ̀, ṣùgbọ́n mo kígbe. ");
INSERT INTO yor_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Nígbà tí ó gbọ́ pé mo gbé ohùn mi sókè, tí mo sì kígbe, ó jọ̀wọ́ aṣọ rẹ̀ sọ́dọ̀ mi, ó sì sá, ó bọ́ sóde.” ");
INSERT INTO yor_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ó sì fi aṣọ náà sọ́dọ̀ títí tí ọkọ rẹ̀ fi dé. ");
INSERT INTO yor_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ó rò fún un pé, “Ẹrú ará Heberu tí o rà wá ilé láti fi wá ṣẹlẹ́yà wá láti bá mi lòpọ̀. ");
INSERT INTO yor_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ṣùgbọ́n bí mo ti kígbe fún ìrànlọ́wọ́, ó sì sá kúrò nínú ilé.” ");
INSERT INTO yor_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nígbà tí Potifari gbọ́ ọ̀rọ̀ aya rẹ̀ pé báyìí ni ẹrú rẹ̀ ṣe sí aya rẹ̀, ó bínú gidigidi. ");
INSERT INTO yor_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ó sì ju Josẹfu sí ẹ̀wọ̀n, níbi tí a ń ju àwọn ẹlẹ́wọ̀n ọba sí. Ṣùgbọ́n, nígbà tí Josẹfu wà nínú ẹ̀wọ̀n níbẹ̀, ");
INSERT INTO yor_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Olúwa sì wà pẹ̀lú rẹ̀, ó sì ṣàánú fún un, ó sì mú kí ó rí ojúrere àwọn alábojútó ọgbà ẹ̀wọ̀n. ");
INSERT INTO yor_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Nítorí náà, alábojútó ọgbà ẹlẹ́wọ̀n fi Josẹfu ṣe alákòóso ohun gbogbo tí ó wà nínú ẹ̀wọ̀n, àti ohun tí wọn ń ṣe níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wọ́dà náà kò sì mikàn nípa gbogbo ohun tí ó fi sí abẹ́ àkóso Josẹfu, nítorí pé Olúwa wà pẹ̀lú Josẹfu, ó sì ń jẹ́ kí ó ṣe àṣeyọrí nínú ohun gbogbo tí ó dáwọ́lé. ");
INSERT INTO yor_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kò pẹ́ lẹ́yìn èyí, ni agbọ́tí ọba àti alásè rẹ̀ ṣẹ̀ ọba Ejibiti, olúwa wọn. ");
INSERT INTO yor_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao sì bínú sí méjì nínú àwọn ìjòyè rẹ̀, olórí agbọ́tí àti olórí alásè, ");
INSERT INTO yor_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ó sì fi wọ́n sí ìhámọ́ ní ilé olórí ẹ̀ṣọ́, ní inú ẹ̀wọ̀n ibi tí Josẹfu pẹ̀lú wà. ");
INSERT INTO yor_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Olórí ẹ̀ṣọ́ sì yan Josẹfu láti máa ṣe ìránṣẹ́ wọn. Lẹ́yìn ìgbà tí wọ́n ti wà ní ìhámọ́ fún ìgbà díẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ni ọ̀kọ̀ọ̀kan àwọn ọkùnrin méjèèjì náà—olórí agbọ́tí àti olórí alásè ọba Ejibiti, tí a dè sínú túbú, lá àlá ní òru kan náà, àlá kọ̀ọ̀kan sì ní ìtumọ̀ tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Nígbà tí Josẹfu dé ọ̀dọ̀ wọn ní òwúrọ̀ ọjọ́ kejì, ó ṣe àkíyèsí pé, inú wọn kò dùn. ");
INSERT INTO yor_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ó sì bi àwọn ìjòyè Farao tí ó wà pẹ̀lú rẹ̀ nínú ìhámọ́, nínú ilé olúwa rẹ̀ léèrè pé, “Èéṣe tí ojú yín fi fàro bẹ́ẹ̀ ní òní, tí inú yín kò sì dùn?” ");
INSERT INTO yor_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wọ́n wí pé, “Àwa méjèèjì ni a lá àlá, kò sì sí ẹni tí yóò túmọ̀ rẹ̀.” Josẹfu sì wí fún wọn pé, “Ọlọ́run nìkan ni ó ni ìtumọ̀. Ẹ sọ àwọn àlá yín fún mi.” ");
INSERT INTO yor_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Olórí agbọ́tí sì ṣọ́ àlá rẹ̀ fún Josẹfu, wí pé, “Ní ojú àlá mi, mo rí àjàrà kan (tí wọn ń fi èso rẹ̀ ṣe wáìnì) níwájú mi, ");
INSERT INTO yor_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","mo sì rí ẹ̀ka mẹ́ta lórí àjàrà náà, ó yọ ẹ̀ka tuntun, ó sì tanná, láìpẹ́, ó bẹ̀rẹ̀ sí ní í ní èso tí ó ti pọ́n. ");
INSERT INTO yor_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ife Farao sì wà lọ́wọ́ mi, mo sì mú àwọn èso àjàrà náà, mo sì fún un sínú ife Farao, mo sì gbé ife náà fún Farao.” ");
INSERT INTO yor_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josẹfu wí fún un pé, “Èyí ni ìtumọ̀ àlá rẹ. Ẹ̀ka mẹ́ta náà dúró fún ọjọ́ mẹ́ta. ");
INSERT INTO yor_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Láàrín ọjọ́ mẹ́ta Farao yóò mú ọ jáde nínú ẹ̀wọ̀n padà sí ipò rẹ, ìwọ yóò sì tún máa gbé ọtí fún un, gẹ́gẹ́ bí ìṣe rẹ àtẹ̀yìnwá. ");
INSERT INTO yor_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ṣùgbọ́n nígbà tí ohun gbogbo bá dára fún ọ, rántí mi kí o sì fi àánú hàn sí mi. Dárúkọ mi fún Farao, kí o sì mú mi jáde kúrò ní ìhín. ");
INSERT INTO yor_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nítorí á jí mi gbé tà kúrò ní ilẹ̀ àwọn Heberu ni, àti pé níhìn-ín èmi kò ṣe ohunkóhun tí ó fi yẹ kí èmi wà ní ìhámọ́ bí mo ti wà yìí.” ");
INSERT INTO yor_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Nígbà tí olórí alásè rí i wí pé ìtumọ̀ tí Josẹfu fún àlá náà dára, ó wí fún Josẹfu pé, “Èmi pẹ̀lú lá àlá, mo ru agbọ̀n oúnjẹ mẹ́ta lórí. ");
INSERT INTO yor_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nínú agbọ̀n tí ó wà lókè, onírúurú oúnjẹ ló wà níbẹ̀ fún Farao, ṣùgbọ́n àwọn ẹyẹ sì ń ṣà wọ́n jẹ láti inú apẹ̀rẹ̀ náà tí ó wà lórí mi.” ");
INSERT INTO yor_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josẹfu dáhùn, “Èyí ni ìtumọ̀ àlá rẹ. Agbọ̀n mẹ́ta náà túmọ̀ sí ọjọ́ mẹ́ta. ");
INSERT INTO yor_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Láàrín ọjọ́ mẹ́ta, Farao yóò tú ọ sílẹ̀, yóò sì bẹ́ orí rẹ, yóò sì gbé ara rẹ kọ́ sí orí igi. Àwọn ẹyẹ yóò sì jẹ ara rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ọjọ́ kẹta sì jẹ́ ọjọ́ ìbí Farao, ó sì ṣe àsè fún gbogbo àwọn ìjòyè e rẹ̀. Ó sì mú olórí agbọ́tí àti olórí alásè jáde kúrò nínú ẹ̀wọ̀n. ");
INSERT INTO yor_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ó dá olórí agbọ́tí padà sí ipò tí ó wà tẹ́lẹ̀, kí ó ba à le máa fi ago lé Farao ní ọwọ́, ");
INSERT INTO yor_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ṣùgbọ́n, ó so olórí alásè kọ́ sórí igi, gẹ́gẹ́ bí Josẹfu ti sọ fún wọn nínú ìtumọ̀ rẹ̀ sí àlá wọn. ");
INSERT INTO yor_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ṣùgbọ́n, olórí agbọ́tí kò rántí Josẹfu mọ́, kò tilẹ̀ ronú nípa rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Nígbà tí odindi ọdún méjì sì ti kọjá, Farao lá àlá: ó rí ara rẹ̀ tó dúró ní etí odò Naili. ");
INSERT INTO yor_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nígbà náà ni màlúù méje jáde láti inú odò, wọ́n dára láti wò, wọ́n sì sanra, wọ́n sì ń jẹ koríko. ");
INSERT INTO yor_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Lẹ́yìn àwọn wọ̀nyí, ni àwọn màlúù méje mìíràn tí kò lẹ́wà tí ó sì rù jáde wá láti inú odò Naili, wọ́n sì dúró ti àwọn méje tí ó sanra tí ó wà ní bèbè odò náà. ");
INSERT INTO yor_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Àwọn màlúù tí ó rù, tí kò sì lẹ́wà sì gbé àwọn tí ó lẹ́wà tí ó sanra jẹ. Nígbà náà ni Farao jí. ");
INSERT INTO yor_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ó sì tún padà sùn, ó sì lá àlá mìíràn: ó rí síírí ọkà méje tí ó kún, ó yómọ, ó sì dára, ó sì jáde lára igi ọkà kan ṣoṣo. ");
INSERT INTO yor_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Lẹ́yìn wọn ni síírí ọkà méje mìíràn yọ, wọn kò yómọ, afẹ́fẹ́ ìlà-oòrùn ti rẹ̀ ẹ́ dànù. ");
INSERT INTO yor_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Àwọn síírí ọkà méje tí kò yómọ (ọmọ rẹ̀ kò tóbi) wọ̀nyí sì gbé àwọn tí ó yómọ (ọmọ rẹ̀ tóbi) mì. Nígbà náà ni Farao jí lójú oorun, ó sì rí i pé àlá ni. ");
INSERT INTO yor_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ní òwúrọ̀, ọkàn rẹ̀ dàrú, nítorí náà, ó ránṣẹ́ pe gbogbo àwọn onídán àti ọ̀mọ̀ran ilẹ̀ Ejibiti. Farao rọ́ àlá rẹ̀ fún wọn, ṣùgbọ́n kò rí ọ̀kan nínú wọn tí ó le sọ ìtumọ̀ àlá náà fún un. ");
INSERT INTO yor_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Nígbà náà ni olórí agbọ́tí wí fún Farao pé, “Lónìí ni mo rántí ẹ̀ṣẹ̀ mi. ");
INSERT INTO yor_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Nígbà kan tí Farao bínú sí àwọn ìránṣẹ́ rẹ̀, tí ó sì fi èmi àti olórí alásè sínú ẹ̀wọ̀n ní ilé olórí ẹ̀ṣọ́. ");
INSERT INTO yor_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ọ̀kọ̀ọ̀kan wa lá àlá, àlá kọ̀ọ̀kan sì ní ìtumọ̀ tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ọmọkùnrin ará Heberu kan tí ó jẹ́ ìránṣẹ́ olórí ẹ̀ṣọ́ wà níbẹ̀ pẹ̀lú wa. A rọ́ àwọn àlá wa fún un, ó sì túmọ̀ wọn fún wa, ó sọ ìtumọ̀ àlá ẹnìkọ̀ọ̀kan fún un. ");
INSERT INTO yor_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Bí ó sì ti túmọ̀ àlá wọ̀nyí náà ni ohun gbogbo rí. A dá mi padà sí ipò mi, a sì so ọkùnrin kejì kọ́ sórí ọ̀wọ̀n.” ");
INSERT INTO yor_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Nítorí náà Farao ránṣẹ́ pe Josẹfu, wọn sì mú un wá kíákíá láti inú ìhámọ́. Nígbà tí ó fá irun rẹ̀, tí ó sì pààrọ̀ aṣọ rẹ̀, ó wá síwájú Farao. ");
INSERT INTO yor_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao wí fún Josẹfu, “Mo lá àlá kan, kò sì sí ẹni tí o le è túmọ̀ rẹ̀. Ṣùgbọ́n mo ti gbọ́ nípa rẹ pé bí o bá ti gbọ́ àlá, o le è túmọ̀ rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josẹfu dá Farao ní ohùn pé, “Kì í ṣe agbára mi, ṣùgbọ́n, Ọlọ́run ni yóò fi ìdáhùn àlàáfíà fún Farao ní ìtumọ̀ àlá náà.” ");
INSERT INTO yor_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Nígbà náà ni Farao wí fún Josẹfu pé, “Ní inú àlá mi, mo dúró ni etí bèbè odò Naili, ");
INSERT INTO yor_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","sì kíyèsi i, màlúù méje tí ó sanra tí o sì lẹ́wà jáde wá, wọ́n sì ń jẹ koríko ní tòsí ibẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Lẹ́yìn wọn, màlúù méje mìíràn jáde wá, wọ́n rù hángógó, wọn kò sì lẹ́wà tó bẹ́ẹ̀ tí n kò tí ì rí irú màlúù tí ó ṣe àìlẹ́wà tó bẹ́ẹ̀ rí ní ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Àwọn màlúù tí ó rù tí kò sì lẹ́wà sì jẹ àwọn màlúù tí ó sanra tí ó kọ́ jáde nínú odò. ");
INSERT INTO yor_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ṣùgbọ́n lẹ́yìn ìgbà tí wọ́n jẹ́ wọ́n tan, kò sì ẹni tí ó le mọ̀ pé wọ́n jẹ ohunkóhun, nítorí wọn kò sanra sí i, wọn sì bùrẹ́wà síbẹ̀. Nígbà náà ni mo tají. ");
INSERT INTO yor_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Ní ojú àlá mi, mo tún rí síírí ọkà méje tí ó yó ọmọ tí ó sì dára, wọ́n jáde láti ara igi ọkà kan. ");
INSERT INTO yor_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Lẹ́yìn wọn, àwọn méje mìíràn yọ jáde, tí kò yó ọmọ bẹ́ẹ̀ ni afẹ́fẹ́ ìlà-oòrùn ti rẹ̀ ẹ́ dànù tán. ");
INSERT INTO yor_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Àwọn síírí ọkà méje tí kò yómọ sì gbé àwọn méje tí ó dára wọ̀nyí mì. Mo sọ àlá yìí fún àwọn onídán mi, ṣùgbọ́n kò sí ẹni tí ó le túmọ̀ rẹ̀ fún mi.” ");
INSERT INTO yor_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Nígbà náà ni Josẹfu wí fún Farao, “Ìtumọ̀ kan náà ni àwọn àlá méjèèjì ní. Ọlọ́run fi ohun tí ó fẹ́ ṣe hàn fún Farao. ");
INSERT INTO yor_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Àwọn màlúù méje ti ó dára jẹ́ ọdún méje, síírí ọkà méje tí ó dára náà sì jẹ́ ọdún méje: ọ̀kan ṣoṣo ni wọn, àlá kan náà ni. ");
INSERT INTO yor_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Àwọn màlúù méje tí kò sanra, tí kò sì rẹwà tí ó jáde gbẹ̀yìn jẹ́ ọdún méje, bẹ́ẹ̀ náà ni síírí ọkà méje tí kò dára, tí afẹ́fẹ́ ìlà-oòrùn ti rẹ̀ dànù tan, wọn jẹ́ ọdún méje tí ìyàn yóò fi mú. ");
INSERT INTO yor_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Bí mo ti wí fún Farao ní ìṣáájú náà ni: Ọlọ́run fi ohun tí yóò ṣẹlẹ̀ han Farao. ");
INSERT INTO yor_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ọdún méje tí oúnjẹ yóò pọ̀ yanturu ń bọ̀ wà ní Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ṣùgbọ́n ọdún méje mìíràn tí ìyàn yóò mú ń bọ̀, nígbà náà ni a ó tilẹ̀ gbàgbé gbogbo ọ̀pọ̀ ní ilẹ̀ Ejibiti, ìyàn yóò sì run gbogbo ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","A kò ní rántí àsìkò ọ̀pọ̀ oúnjẹ yanturu náà mọ́ nítorí pé ìyàn tí yóò tẹ̀lé e yóò pọ̀ púpọ̀. ");
INSERT INTO yor_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ìdí tí Ọlọ́run fi fi àlá náà han fún Farao ní ọ̀nà méjì ọ̀tọ̀ọ̀tọ̀ ni pé, Ọlọ́run ti pinnu pé yóò ṣẹlẹ̀ bẹ́ẹ̀ dandan, àti pé kò ni pẹ́ tí Ọlọ́run yóò fi ṣe é. ");
INSERT INTO yor_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ìmọ̀ràn mi ni wí pé, jẹ́ kí Farao wá ọlọ́gbọ́n ènìyàn kan ní ilẹ̀ Ejibiti, kí ó sì fi ṣe alákòóso iṣẹ́ àgbẹ̀ ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kí Farao sì yan àwọn alábojútó láti máa gba ìdámárùn-ún ìkórè oko ilẹ̀ Ejibiti ní àsìkò ọdún méje ọ̀pọ̀. ");
INSERT INTO yor_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kí wọn kó gbogbo oúnjẹ ilẹ̀ náà ni àwọn ọdún méje ọ̀pọ̀ yìí, kí wọn sì kó àwọn ọkà tí wọn jẹ ṣẹ́kù pamọ́ lábẹ́ àṣẹ Farao. Kí a kó wọn pamọ́ ni àwọn ìlú fún jíjẹ. ");
INSERT INTO yor_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Kí wọn kó oúnjẹ náà pamọ́ fún orílẹ̀-èdè yìí, kí a ba à le lò ó ni ọdún méje tí ìyàn yóò fi jà ní ilẹ̀ Ejibiti, kí ìyàn náà má ba à pa orílẹ̀-èdè yìí run.” ");
INSERT INTO yor_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Èrò náà sì dára lójú Farao àti àwọn ìjòyè rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Farao sì bi wọ́n pé, “Ǹjẹ́ a le rí ẹnikẹ́ni bi ọkùnrin yìí, nínú ẹni tí ẹ̀mí Ọlọ́run ń gbé?” ");
INSERT INTO yor_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Nígbà náà ni Farao wí fún Josẹfu, “Níwọ́n bí Ọlọ́run ti fi gbogbo èyí hàn ọ́, kò sí ẹni náà tí ó gbọ́n tí ó sì mọ̀ràn bí i tìrẹ ní ilẹ̀ Ejibiti yìí, ");
INSERT INTO yor_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ìwọ yóò ṣe àkóso ààfin mi gbogbo àwọn ènìyàn gbọdọ̀ tẹríba fún àṣẹ ẹ̀ rẹ. Ìtẹ́ mi nìkan ni èmi yóò fi jù ọ́ lọ.” ");
INSERT INTO yor_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Farao wí fún Josẹfu pé, “Mo fi ọ́ ṣe alábojútó gbogbo ilẹ̀ Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Farao sì bọ́ òrùka èdìdì ọwọ́ rẹ̀, ó sì fi wọ Josẹfu ó wọ̀ ọ́ ní aṣọ ọ̀gbọ̀ dáradára, ó sì fi ẹ̀gbà tí ó dára sí i lọ́rùn. ");
INSERT INTO yor_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ó sì mú un kí ó gun kẹ̀kẹ́-ẹṣin bí igbákejì ara rẹ̀, àwọn ènìyàn sì ń pariwo níwájú rẹ̀ pé, “Ẹ yàgò lọ́nà.” Báyìí ni ó sì fi ṣe alábojútó gbogbo ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Nígbà náà ni Farao wí fún Josẹfu pé, “Èmi ni Farao. Ṣùgbọ́n láìsí àṣẹ rẹ, ẹnikẹ́ni kò gbọdọ̀ ṣe ohunkóhun ní ilẹ̀ Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao sì sọ Josẹfu ní orúkọ yìí Safenati-Panea (èyí tí ó túmọ̀ sí ẹni tí ó ni agbára ikú àti ìyè ní ìkáwọ́ bí òrìṣà). Ó sì fun un ní Asenati ọmọ Potifẹra, alábojútó òrìṣà Oni, gẹ́gẹ́ bí aya. Josẹfu sì rin gbogbo ilẹ̀ Ejibiti já. ");
INSERT INTO yor_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ọmọ ọgbọ̀n ọdún ni Josẹfu nígbà tí ó wọ iṣẹ́ Farao ọba Ejibiti. Josẹfu sì jáde kúrò níwájú Farao, ó sì ṣe ìbẹ̀wò káàkiri gbogbo ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ní ọdún méje ọ̀pọ̀, ilẹ̀ náà so èso lọ́pọ̀lọ́pọ̀. ");
INSERT INTO yor_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Josẹfu kó gbogbo oúnjẹ tí a pèsè ni ilẹ̀ Ejibiti ní ọdún méje ọ̀pọ̀ yìí, ó sì pa wọ́n mọ́ sí àwọn ìlú. Ní ìlú kọ̀ọ̀kan ni ó kó gbogbo oúnjẹ tí wọ́n gbìn ní àyíká ìlú wọn sí. ");
INSERT INTO yor_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josẹfu pa ọ̀pọ̀lọpọ̀ ọkà mọ́ bí iyanrìn Òkun; ó pọ̀ tó bẹ́ẹ̀ gẹ́ẹ́ tí kò ṣe àkọsílẹ̀ mọ́ nítorí, ó tayọ kíkà. ");
INSERT INTO yor_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kí ó tó di pé ọdún ìyàn dé, Asenati ọmọ Potifẹra alábojútó Oni bí ọmọkùnrin méjì fún Josẹfu. ");
INSERT INTO yor_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josẹfu sọ orúkọ àkọ́bí rẹ̀ ni Manase, ó sì wí pé, “Nítorí tí Ọlọ́run ti mú mi gbàgbé gbogbo ìdààmú mi àti gbogbo ilé baba mi.” ");
INSERT INTO yor_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ó sì sọ orúkọ èkejì ní Efraimu, ó sì wí pé, “Nítorí pé Ọlọ́run fún mi ní ọmọ ní ilẹ̀ ìpọ́njú mi.” ");
INSERT INTO yor_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ọdún méje ọ̀pọ̀ oúnjẹ sì wá sí òpin ní ilẹ̀ Ejibiti, ");
INSERT INTO yor_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ọdún méje ìyàn sì bẹ̀rẹ̀, bí Josẹfu ti wí gan an. Ìyàn sì mú ní gbogbo ilẹ̀ tókù, ṣùgbọ́n oúnjẹ wà ní gbogbo ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nígbà tí àwọn ará Ejibiti bẹ̀rẹ̀ sí ní rí ipá ìyàn náà, wọ́n kígbe sí Farao. Nígbà náà ni Farao wí fún wọn pé, “Ẹ lọ bá Josẹfu, ẹ ṣe ohun tí ó bá wí fún un yín.” ");
INSERT INTO yor_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nígbà tí ìyàn sì ti tàn ká gbogbo ilẹ̀ náà, Josẹfu ṣí inú àká, ó sì bẹ̀rẹ̀ sí ní ta ọkà fún àwọn ènìyàn, nítorí ìyàn náà mú gan an ní gbogbo ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Gbogbo àwọn orílẹ̀-èdè sì ń wá sí Ejibiti láti ra oúnjẹ lọ́wọ́ Josẹfu, nítorí ìyàn náà pọ̀ gidigidi káàkiri gbogbo ayé. ");
INSERT INTO yor_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Nígbà tí Jakọbu mọ̀ pé ọkà wà ní Ejibiti, ó wí fún àwọn ọmọ rẹ̀ ọkùnrin pé, “Èéṣe tí ẹ ń wo ara yín lásán?” ");
INSERT INTO yor_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","“Mo tí gbọ́ pé ọkà wà ní ilẹ̀ Ejibiti. Ẹ sọ̀kalẹ̀ lọ sí ibẹ̀ kí ẹ sì rà wá fún wa, kí a má ba à kú.” ");
INSERT INTO yor_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Nígbà náà ni mẹ́wàá nínú àwọn arákùnrin Josẹfu sọ̀kalẹ̀ lọ sí Ejibiti láti ra ọkà. ");
INSERT INTO yor_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ṣùgbọ́n Jakọbu kò rán Benjamini àbúrò Josẹfu lọ pẹ̀lú wọn nítorí ẹ̀rù ń bà á kí aburú má ba à ṣẹlẹ̀ sí i. ");
INSERT INTO yor_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Nítorí náà, àwọn ọmọ Israẹli wà lára àwọn tó lọ Ejibiti lọ ra oúnjẹ nítorí ìyàn náà mú ni ilẹ̀ Kenaani pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Nísinsin yìí, Josẹfu ni alábojútó fún gbogbo ilẹ̀ Ejibiti, òun sì ni ó ń bojútó ọkà títà fún gbogbo ènìyàn ìlú náà. Nítorí náà nígbà tí àwọn arákùnrin Josẹfu dé, wọ́n tẹríba, wọ́n sì foríbalẹ̀ fún Josẹfu. ");
INSERT INTO yor_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Lọ́gán tí Josẹfu ti rí àwọn arákùnrin rẹ̀ ni ó ti dá wọn mọ̀, ṣùgbọ́n ó ṣe bí i wí pé kò mọ̀ wọ́n, ó sì sọ̀rọ̀ líle sí wọn. Ó béèrè pé, “Níbo ni ẹ ti wá?” Wọ́n sì dáhùn pé, “Láti ilẹ̀ Kenaani ni a ti wá ra oúnjẹ.” ");
INSERT INTO yor_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Bí ó tilẹ̀ jẹ́ wí pé, Josẹfu mọ àwọn arákùnrin rẹ̀, síbẹ̀ àwọn arákùnrin rẹ̀ kò mọ̀ ọ́n. ");
INSERT INTO yor_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nígbà náà ni ó rántí àlá rẹ̀ tí ó lá sí wọn, ó sì wí fún wọn pé, “Amí ni yín, ẹ wá láti wo àṣírí ilẹ̀ wa ni.” ");
INSERT INTO yor_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wọ́n dáhùn pé, “Bẹ́ẹ̀ kọ́ olúwa wa, àwọn ìránṣẹ́ rẹ wá láti ra oúnjẹ ni. ");
INSERT INTO yor_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ọmọ baba ni wá, olóòtítọ́ ènìyàn sì ni wá pẹ̀lú, àwa kì í ṣe ayọ́lẹ̀wò.” ");
INSERT INTO yor_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ó wí fún wọn pé, “Rárá! Ẹ wá láti wo àṣírí ilẹ̀ wa ni.” ");
INSERT INTO yor_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ṣùgbọ́n wọ́n tún dáhùn pé, “Arákùnrin méjìlá ni àwa ìránṣẹ́ rẹ, ọmọ baba kan náà, tí ó ń gbé ní ilẹ̀ Kenaani. Èyí tí ó jẹ́ àbíkẹ́yìn wa ń bẹ lọ́dọ̀ baba wa, ọ̀kan sì ti kú.” ");
INSERT INTO yor_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josẹfu wí fún wọn pé, “Bí mo ti wí fún un yín náà ni, Ayọ́lẹ̀wò ni yín! ");
INSERT INTO yor_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Èyí sì ni a ó fi dán an yín wò, èmi búra pé, níwọ̀n ìgbà tí Farao bá wà láààyè, ẹ kì yóò kúrò níbí, àyàfi bí arákùnrin yín kan tókù bá wá sí ibí. ");
INSERT INTO yor_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ẹ rán ọ̀kan nínú yín lọ láti mú arákùnrin yín wá, àwa yóò fi ẹ̀yin tókù pamọ́ sínú túbú, kí àwa ba à lè mọ bóyá òtítọ́ ni ẹ̀yin ń wí. Ṣùgbọ́n bí ó bá jẹ́ pé irọ́ ni ẹ̀yin ń pa, ní òtítọ́ bí Farao ti ń bẹ láààyè ayọ́lẹ̀wò ni yín!” ");
INSERT INTO yor_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ó sì fi gbogbo wọn sínú túbú fún ọjọ́ mẹ́ta. ");
INSERT INTO yor_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ní ọjọ́ kẹta, Josẹfu wí fún wọn pé, “Èyí ni ẹ̀yin yóò ṣe kí ẹ̀yin ba à le yè nítorí mo bẹ̀rù Ọlọ́run. ");
INSERT INTO yor_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Tí ó bá jẹ́ pé olóòtítọ́ ènìyàn ni yín, ẹ jẹ́ kí ọ̀kan nínú yín dúró ni túbú ní ìhín, nígbà tí àwọn yòókù yín yóò gbé ọkà lọ fún àwọn ará ilé e yín tí ebi ń pa. ");
INSERT INTO yor_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ṣùgbọ́n ẹ gbọdọ̀ mú arákùnrin tí ó jẹ́ àbíkẹ́yìn yín wá, kí n ba à le mọ òtítọ́ ohun ti ẹ ń wí, kí ẹ má ba à kú.” Wọn sì gbà láti ṣe èyí. ");
INSERT INTO yor_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Wọ́n ń sọ ọ́ láàrín ara wọn wí pé, “Àwa jẹ̀bi nítòótọ́ nípa ti arákùnrin wa. A rí ìbànújẹ́ ọkàn rẹ̀ nígbà tí ó ń bẹ̀ wá nítorí ẹ̀mí rẹ̀, ṣùgbọ́n a kò gbẹ́bẹ̀, nítorí náà ni ìdààmú yìí fi dé bá wa.” ");
INSERT INTO yor_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reubeni dá wọn ní ohùn pé, “Èmi kò wí fún yín pé kí ẹ má se ṣẹ̀ sí ọmọdékùnrin náà? Ṣùgbọ́n ẹ kò gbọ́! Ṣùgbọ́n nísinsin yìí a ń béèrè ẹ̀jẹ̀ rẹ̀ lọ́wọ́ wa.” ");
INSERT INTO yor_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Wọn kò sì mọ̀ pé, Josẹfu ń gbọ́ wọn ní àgbọ́yé nítorí ògbufọ̀ ni ó ń lò tẹ́lẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ó yípadà kúrò lọ́dọ̀ wọn, ó sì bẹ̀rẹ̀ sí ní sọkún. Ó sì tún yí padà sí wọn, ó sì bẹ̀rẹ̀ sí ní sọ̀rọ̀. Ó mú Simeoni kúrò láàrín wọn, ó sì dè é ní ojú wọn. ");
INSERT INTO yor_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josẹfu pàṣẹ pé kí wọn bu ọkà kún inú àpò wọn, kí wọn sì mú owó ẹnìkọ̀ọ̀kan padà sínú àpò rẹ̀, kí wọn sì fún wọn ní ohun tí wọn yóò lò nírín-àjò wọn padà sílé. Lẹ́yìn ìgbà tí a ti ṣe èyí fún wọn, ");
INSERT INTO yor_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","wọn gbé ẹrù wọn lé kẹ́tẹ́kẹ́tẹ́, wọn sì padà lọ sí ilé. ");
INSERT INTO yor_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Níbi tí wọ́n ti dúró láti sùn lóru ọjọ́ náà, ọ̀kan nínú wọn tú àpò rẹ̀ láti mú oúnjẹ fún kẹ́tẹ́kẹ́tẹ́ rẹ̀, ó sì rí owó rẹ̀ ní ẹnu àpò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ó sì wí fún àwọn arákùnrin rẹ̀ pé, “a ti dá owó mi padà, òun nìyí ní ẹnu àpò mi.” Ẹ̀rù bà wọ́n, wọ́n sì ń gbọ̀n, wọ́n sì wí pé, “Èwo nìyí tí Ọlọ́run ṣe sí wa yìí.” ");
INSERT INTO yor_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Nígbà tí wọ́n padà dé ọ̀dọ̀ Jakọbu baba wọn ní ilẹ̀ Kenaani, wọ́n ròyìn gbogbo ohun tí ó ṣẹlẹ̀ fún un wí pé, ");
INSERT INTO yor_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ọkùnrin náà tí í ṣe alábojútó ilẹ̀ náà, sọ̀rọ̀ líle sí wa, ó sì fi ẹ̀sùn kàn wá pé a wá yọ́ ilẹ̀ náà wò ni. ");
INSERT INTO yor_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ṣùgbọ́n, a wí fún un pé, ‘Rárá o, olóòtítọ́ ènìyàn ni wá, a kì í ṣe ayọ́lẹ̀wò. ");
INSERT INTO yor_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Arákùnrin méjìlá ni wá, ọmọ baba kan náà, ọ̀kan ti kú, èyí tí ó jẹ́ àbíkẹ́yìn wà lọ́dọ̀ baba wa ni ilẹ̀ Kenaani.’ ");
INSERT INTO yor_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Nígbà náà ni ọkùnrin tí ó jẹ́ alábojútó ilẹ̀ náà wí fún wa pé, ‘Báyìí ni n ó ṣe mọ̀ bóyá olóòtítọ́ ènìyàn ni yín, ẹ fi ọ̀kan nínú àwọn arákùnrin yín sílẹ̀ níbí, pẹ̀lú mi, ẹ sì mú oúnjẹ lọ fún àwọn ará ilé yín tí ebi ń pa kú lọ, lọ́wọ́ ìyàn. ");
INSERT INTO yor_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ṣùgbọ́n ẹ mú arákùnrin yín tí ó kéré jùlọ wá fún mi kí n le mọ̀ pé dájúdájú ẹ kì í ṣe ayọ́lẹ̀wò bí kò ṣe ènìyàn tòótọ́. Nígbà náà ni n ó mú arákùnrin yín padà fún un yín, lẹ́yìn náà ẹ le máa wá ṣe òwò bí ó ti wù yín ní ilẹ̀ yìí.’ ” ");
INSERT INTO yor_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bí wọ́n sì ti ń tú àpò ẹrù wọn, ẹnìkọ̀ọ̀kan bá owó tí ó san fún ọjà náà lẹ́nu àpò rẹ̀! Ẹ̀rù sì bà wọ́n gidigidi, àwọn àti baba wọn. ");
INSERT INTO yor_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jakọbu baba wọn wí fún wọn pé, “Ẹ ti mú mi pàdánù àwọn ọmọ mi. N kò rí Josẹfu mọ́, bẹ́ẹ̀ ni n kò sì rí Simeoni náà mọ. Ẹ sì tún fẹ́ mú Benjamini lọ. Èmi ni gbogbo ohun búburú yìí wá ń ṣẹlẹ̀ sí!” ");
INSERT INTO yor_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Nígbà náà ni Reubeni wí fún baba rẹ̀ pé, “Pa àwọn ọmọ mi méjèèjì bí n kò bá mú Benjamini padà wá fún ọ, èmi ni kí o fà á lé lọ́wọ́, n ó sì mu un padà wá.” ");
INSERT INTO yor_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ṣùgbọ́n Jakọbu wí pé, “Ọmọ mi kì yóò bá a yín lọ, ẹ̀gbọ́n rẹ̀ ti kú, òun nìkan sì ni ó kù nínú àwọn ọmọ ìyá rẹ̀. Bí ohunkóhun bá ṣẹlẹ̀ sí i, ìbànújẹ́ ni yóò sì pa mi kú ni ọjọ́ ogbó mi yìí.” ");
INSERT INTO yor_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Báyìí, ìyàn náà sì mú gidigidi ní ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Nígbà tí wọ́n sì ti jẹ gbogbo ọkà tí wọ́n rà ní Ejibiti tan, baba wọn wí fún wọn pé, “Ẹ padà lọ ra oúnjẹ díẹ̀ si wá fún wa.” ");
INSERT INTO yor_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ṣùgbọ́n Juda wí fún un pé, “Ọkùnrin náà tẹnumọ́ ọn nínú ìkìlọ̀ rẹ̀ fún wa pé, ‘Ẹ̀yin kì yóò rí ojúrere mi mọ́, àyàfi bí arákùnrin yín bá bá a yín wá’. ");
INSERT INTO yor_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tí ìwọ yóò bá rán Benjamini arákùnrin wa lọ pẹ̀lú wa, a ó lọ ra oúnjẹ wá fún ọ. ");
INSERT INTO yor_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ṣùgbọ́n bí ìwọ kò bá ni jẹ́ kí ó bá wa lọ, àwa kì yóò lọ, nítorí ọkùnrin náà sọ fún wa pé, ‘Ẹ̀yin kì yóò rí ojúrere mi mọ́ àyàfi bí arákùnrin yín bá bá a yín wá.’ ” ");
INSERT INTO yor_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israẹli béèrè pé, “Èéṣe tí ẹ fi kó ìdààmú yìí bá mi nípa sísọ fún ọkùnrin náà wí pé ẹ ní arákùnrin mìíràn?” ");
INSERT INTO yor_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wọ́n dáhùn pé, “Ọkùnrin náà fi pẹ̀lẹ́pẹ̀lẹ́ wádìí lọ́wọ́ wa nípa ìdílé wa àti àwa fúnra wa. Ó béèrè pé, ‘Ṣe baba yín ṣì wà láààyè? Ǹjẹ́ ẹ tún ní arákùnrin mìíràn?’ A kàn dáhùn ìbéèrè rẹ̀ ni. Báwo ni a ṣe le mọ̀ pé yóò wí pé, ‘Ẹ mú arákùnrin yín wá’?” ");
INSERT INTO yor_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda sì wí fún Israẹli baba rẹ̀, “Jẹ́ kí ọmọkùnrin náà lọ pẹ̀lú mi, a ó sì lọ ní kíákíá, kí àwa àti ìwọ àti àwọn ọmọ wa le yè, kí a má sì kú. ");
INSERT INTO yor_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Èmi fúnra mi yóò ṣe onídùúró fún un, èmi ni kí o gbà pé o fi lé lọ́wọ́. Bí n kò bá sì mú un padà tọ̀ ọ́ wá, jẹ́ kí ẹ̀bi rẹ̀ kí ó jẹ́ tèmi ní gbogbo ọjọ́ ayé mi níwájú rẹ. ");
INSERT INTO yor_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Bí ó bá ṣe pé a kò fi falẹ̀ ni, àwa ìbá ti lọ, à bá sì ti padà ní ìgbà méjì ọ̀tọ̀ọ̀tọ̀.” ");
INSERT INTO yor_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Nígbà náà ni Israẹli baba wọn wí fún wọn, “Bí ó bá rí bẹ́ẹ̀, èyí ni kí ẹ ṣe, ẹ mú àwọn ohun dáradára ilẹ̀ yìí lọ́wọ́ lọ bí ẹ̀bùn fún ọkùnrin náà—ìkunra díẹ̀, oyin díẹ̀, tùràrí àti òjìá, èso pisitakio àti èso almondi ");
INSERT INTO yor_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ìlọ́po owó méjì ni kí ẹ mú lọ́wọ́, nítorí ẹ gbọdọ̀ dá owó tí ẹ bá lẹ́nu àpò yín padà. Bóyá ẹnìkan ló ṣèèṣì fi síbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ẹ mú arákùnrin yín lọ́wọ́ pẹ̀lú ki ẹ sì tọ arákùnrin náà lọ. ");
INSERT INTO yor_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kí Ọlọ́run alágbára jẹ́ kí ẹ rí àánú gbà lọ́dọ̀ ọkùnrin náà kí ó ba à le jẹ́ kí arákùnrin yín tí ó wà lọ́hùn ún àti Benjamini padà wá pẹ̀lú yín. Ní tèmi, bí mo bá pàdánù àwọn ọmọ mi, n ó ṣọ̀fọ̀ wọn náà ni.” ");
INSERT INTO yor_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Nítorí náà wọ́n mú àwọn ẹ̀bùn náà àti owó ìlọ́po méjì àti Benjamini, wọ́n sì yára lọ sí ilẹ̀ Ejibiti, wọ́n sì fi ara wọn hàn níwájú Josẹfu. ");
INSERT INTO yor_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Nígbà tí Josẹfu rí Benjamini pẹ̀lú wọn, ó sọ fún ìránṣẹ́ ilé rẹ̀, “Mú àwọn ọkùnrin wọ̀nyí lọ sí ilé mi, pa ẹran kí o sì ṣe àsè; wọn ó jẹun ọ̀sán pẹ̀lú mi.” ");
INSERT INTO yor_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ọkùnrin náà sì ṣe bí Josẹfu ti wí fún un, ó sì mú àwọn ọkùnrin náà lọ sí ilé Josẹfu. ");
INSERT INTO yor_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ẹ̀rù sì ba àwọn ọkùnrin náà nígbà tí wọ́n mú wọn lọ sí ilé Josẹfu. Wọ́n rò ó pé, “A mú wa wá sí ìhín nítorí owó tí a fi sí inú àpò wa ní ìgbà àkọ́kọ́. Ó fẹ́ bá wa jà, kí ó mú wa lẹ́rú kí ó sì gba àwọn kẹ́tẹ́kẹ́tẹ́ wa.” ");
INSERT INTO yor_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Nítorí náà wọ́n lọ bá ìránṣẹ́ Josẹfu, wọ́n sì ba sọ̀rọ̀ ní ẹnu-ọ̀nà àbáwọlé ilé náà. ");
INSERT INTO yor_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Wọ́n wí pé, “Jọ̀wọ́ ọ̀gá, ní òtítọ́ ni àwa ti sọ̀kalẹ̀ síyìn-ín láti wá ra oúnjẹ ní ìṣáájú. ");
INSERT INTO yor_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ṣùgbọ́n níbi tí a ti dúró ní ọ̀nà láti sùn ní alẹ́, nígbà tí a tú àpò oúnjẹ wa, ẹnìkọ̀ọ̀kan wa bá owó oúnjẹ tirẹ̀ tí ó rà lẹ́nu àpò láì lé, láì dín. Nítorí náà òun nìyí, a ti mu un padà wá pẹ̀lú wa. ");
INSERT INTO yor_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","A sì tún mú owó mìíràn lọ́wọ́ láti fi ra oúnjẹ. A ò mọ ẹni tí ó fi owó wa sí ẹnu àpò.” ");
INSERT INTO yor_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ó sì wí fún wọn pé, “Àlàáfíà ni fún yín, ẹ má bẹ̀rù, Ọlọ́run yín, àní Ọlọ́run baba yín ni ó fi ìṣúra sí inú àpò yín; mo rí owó tí ẹ san gbà.” Nígbà náà ni ó mú Simeoni jáde tọ̀ wọ́n wá. ");
INSERT INTO yor_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ìránṣẹ́ náà mú àwọn ọkùnrin náà lọ sí ilé Josẹfu, ó fún wọn ní omi láti fi wẹ ẹsẹ̀ wọn nu, ó sì fún àwọn kẹ́tẹ́kẹ́tẹ́ wọn lóúnjẹ pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Wọ́n pèsè ẹ̀bùn wọn sílẹ̀ fún Josẹfu di ọ̀sán nígbà tí yóò dé, nítorí wọ́n ti gbọ́ pé ibẹ̀ ni àwọn yóò ti jẹun ọ̀sán. ");
INSERT INTO yor_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Nígbà tí Josẹfu dé sí ilé, wọ́n kó àwọn ẹ̀bùn tí wọ́n ti mú wá fún un, wọ́n sì wólẹ̀ níwájú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ó béèrè àlàáfíà wọn, ó sì wí pé, “Ṣé àlàáfíà ni baba yín wà, baba arúgbó tí ẹ sọ̀rọ̀ rẹ̀ fún mi, ṣé ó sì wà láààyè?” ");
INSERT INTO yor_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wọ́n dáhùn pé, “Ìránṣẹ́ rẹ, baba wa sì wà láààyè, àlàáfíà sì ni ó wà pẹ̀lú.” Wọn sì tẹríba láti bọ̀wọ̀ fún un. ");
INSERT INTO yor_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Bí ó ti wò yíká tí ó sì rí Benjamini àbúrò rẹ̀, tí í ṣe ọmọ ìyá rẹ̀ gan an. Ó béèrè lọ́wọ́ wọn pé, “Ṣe àbúrò yín tí ó jẹ́ àbíkẹ́yìn tí ẹ sọ fún mi nípa rẹ̀ nìyìí?” Ó sì tún wí pe, “Kí Ọlọ́run kí ó ṣàánú fún ọ, ọmọ mi.” ");
INSERT INTO yor_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ọkàn rẹ̀ sì fà sí i gidigidi nígbà tí ó rí arákùnrin rẹ̀, nítorí náà Josẹfu yára jáde láti wá ibi tí ó ti le sọkún. Ó lọ sí iyàrá rẹ̀, ó sì sọkún níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Lẹ́yìn ìgbà tí ó ti bọ́jú tan, ó jáde wá, ó ṣe ọkàn ọkùnrin, ó sì wí fún wọn pé, kí wọ́n gbé oúnjẹ wá kí wọ́n le è jẹun. ");
INSERT INTO yor_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Wọ́n gbé oúnjẹ tirẹ̀ fún un lọ́tọ̀, àti fún àwọn ará Ejibiti tí ó wá ba jẹun náà lọ́tọ̀, nítorí ará Ejibiti kò le bá ará Heberu jẹun nítorí ìríra pátápátá ló jẹ́ fún àwọn Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","A mú àwọn ọkùnrin náà jókòó lẹ́gbẹ̀ẹ́ rẹ̀, bí wọ́n ṣe dàgbà sí, láti orí ẹ̀gbọ́n pátápátá dé orí èyí tí ó kéré pátápátá, wọ́n sì ń wo ara wọn tìyanu tìyanu. ");
INSERT INTO yor_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","A sì bu oúnjẹ fún wọn láti orí tábìlì Josẹfu. Oúnjẹ Benjamini sì tó ìlọ́po márùn-ún ti àwọn tókù. Wọ́n ń jẹ, wọ́n sì ń mu lọ́dọ̀ rẹ̀ láìsí ìdíwọ́. ");
INSERT INTO yor_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Nígbà náà ni Josẹfu pàṣẹ fún ìránṣẹ́ rẹ̀ pé, “Di oúnjẹ kún inú àpò àwọn ọkùnrin náà tó ìwọ̀n èyí tí wọ́n le rù, kí o sì mú owó olúkúlùkù àwọn ọkùnrin náà padà sí ẹnu àpò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nígbà náà ni kí o mú kọ́ọ̀bù idẹ mi sí ẹnu àpò èyí tí ó jẹ́ àbíkẹ́yìn nínú wọn pẹ̀lú owó tí ó fi ra ọkà,” ó sì ṣe bí Josẹfu ti sọ. ");
INSERT INTO yor_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Bí ilẹ̀ ti ń mọ́, wọ́n bẹ̀rẹ̀ ìrìnàjò wọn padà lọ pẹ̀lú kẹ́tẹ́kẹ́tẹ́ wọn. ");
INSERT INTO yor_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Wọn kò tí ì rìn jìnnà sí ìlú náà tí Josẹfu fi wí fún ìránṣẹ́ rẹ̀ pé, “Lépa àwọn ọkùnrin náà, nígbà tí o bá sì bá wọn, kí o wí pé, ‘Èéṣe ti ẹ fi búburú san rere? ");
INSERT INTO yor_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Èyí ha kọ́ ni kọ́ọ̀bù tí olúwa mi ń lò fún ohun mímu tí ó sì tún ń fi í ṣe àyẹ̀wò? Ohun tí ẹ ṣe yìí burú púpọ̀.’ ” ");
INSERT INTO yor_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Nígbà tí ó sì bá wọn, o sọ ọ̀rọ̀ wọ̀nyí fún wọn. ");
INSERT INTO yor_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ṣùgbọ́n wọ́n dá a lóhùn pé, “Kí ló dé tí olúwa mi sọ irú nǹkan wọ̀nyí? Ká má rí i! Àwọn ìránṣẹ́ rẹ kò le ṣe irú nǹkan bẹ́ẹ̀! ");
INSERT INTO yor_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","A tilẹ̀ mú owó tí a rí lẹ́nu àpò wa padà tọ̀ ọ́ wá láti ilẹ̀ Kenaani. Nítorí náà èéṣe tí àwa yóò fi jí wúrà tàbí idẹ ní ilé olúwa à rẹ? ");
INSERT INTO yor_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bí a bá rí i lọ́wọ́ èyíkéyìí nínú àwọn ìránṣẹ́ rẹ, kíkú ni yóò kú, àwọn tí ó kù yóò sì di ẹrú fún olúwa à rẹ.” ");
INSERT INTO yor_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ó wí pé, “Ó dára, kí ó rí bí ẹ ti ṣe sọ. Ẹnikẹ́ni tí mo bá rí i lọ́wọ́ rẹ̀ yóò di ẹrú mi. Ẹ̀yin tí ó kù yóò sì wà láìlẹ́bi.” ");
INSERT INTO yor_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Olúkúlùkù wọn yára sọ àpò rẹ̀ kalẹ̀, wọ́n sì tú u. ");
INSERT INTO yor_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Nígbà náà ni ìránṣẹ́ náà bẹ̀rẹ̀ sí ní í wá a, bẹ̀rẹ̀ láti orí ẹ̀gbọ́n títí lọ sórí àbúrò pátápátá. Ó sì rí kọ́ọ̀bù náà nínú àpò ti Benjamini. ");
INSERT INTO yor_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Nígbà tí wọ́n rí èyí, wọ́n fa aṣọ wọn ya, wọ́n sì banújẹ́ gidigidi, wọn tún ẹrù wọn dì sórí kẹ́tẹ́kẹ́tẹ́, wọ́n sì padà sí inú ìlú. ");
INSERT INTO yor_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Josẹfu sì wà nínú ilé nígbà tí Juda àti àwọn arákùnrin rẹ̀ wọlé wá. Gbogbo wọn sì wólẹ̀ níwájú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Josẹfu wí fún wọn pé, “Èwo ni èyí tí ẹ ṣe yìí? Ṣe ẹ kò mọ pé, ènìyàn bí èmi le è rí ìdí nǹkan nípa ṣíṣe àyẹ̀wò?” ");
INSERT INTO yor_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda dáhùn pé, “Kí ni à bá sọ fún olúwa mi? Báwo ni a ṣe lè wẹ ara wa mọ́? Ọlọ́run ti tú àṣírí ẹ̀ṣẹ̀ àwọn ìránṣẹ́ rẹ̀, a ti di ẹrú olúwa à mi báyìí àwa fúnra wa àti ẹni náà tí a rí kọ́ọ̀bù lọ́wọ́ rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ṣùgbọ́n Josẹfu dáhùn pé, “Ká má rí i pé mo ṣe irú nǹkan bẹ́ẹ̀! Ẹni tí a bá kọ́ọ̀bù mi lọ́wọ́ rẹ̀ nìkan ni yóò di ẹrú mi, ẹ̀yin tí ó kù, ẹ máa lọ sọ́dọ̀ baba yín ní àlàáfíà.” ");
INSERT INTO yor_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Nígbà náà ni Juda súnmọ́ ọ̀dọ̀ rẹ̀, ó sì wí pé, “Jọ̀wọ́ olúwa mi, jẹ́ kí ìránṣẹ́ rẹ kí ó sọ ọ̀rọ̀ kan fún olúwa mi, má ṣe bínú sí ìránṣẹ́ rẹ bí ó tilẹ̀ jẹ́ wí pé ìwọ pẹ̀lú láṣẹ bí i ti Farao. ");
INSERT INTO yor_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Olúwa mi béèrè lọ́wọ́ àwọn ìránṣẹ́ rẹ̀ pé, ‘Ǹjẹ́ ó ní baba tàbí arákùnrin?’ ");
INSERT INTO yor_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Àwa sì wí fún olúwa mi pé, ‘A ni baba tí ó ti darúgbó, ọmọkùnrin kan sì wà pẹ̀lú tí a bí fún un ní ọjọ́ ogbó rẹ̀. Ẹ̀gbọ́n rẹ̀ ti kú, òun nìkan sì ni ó kù nínú àwọn ọmọ ìyá rẹ̀, baba rẹ̀ sì fẹ́ràn án rẹ̀.’ ");
INSERT INTO yor_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Nígbà náà ni ó sọ fún àwọn ìránṣẹ́ rẹ̀ pé, ‘Ẹ mu un tọ̀ mí wá kí n le fojú ara mi rí i.’ ");
INSERT INTO yor_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","A sì sọ fún olúwa à mi pé, ‘Ọmọkùnrin náà kò le è fi baba rẹ̀ sílẹ̀, bí ó bá dán an wò baba rẹ̀ yóò kú.’ ");
INSERT INTO yor_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ṣùgbọ́n ìwọ wí fún àwọn ìránṣẹ́ rẹ̀ pé, ‘Ẹ má ṣe padà tọ̀ mí wá àyàfi bí àbíkẹ́yìn yín bá bá yín wá.’ ");
INSERT INTO yor_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nígbà tí a padà lọ sọ́dọ̀ baba wa, tí í ṣe ìránṣẹ́ rẹ, a sọ ohun tí olúwa à mi wí fún un. ");
INSERT INTO yor_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Nígbà náà ni baba wa wí pé, ‘Ẹ padà lọ láti lọ ra oúnjẹ díẹ̀ wá.’ ");
INSERT INTO yor_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ṣùgbọ́n a wí pe, ‘Àwa kò le è padà lọ, àyàfi bí àbúrò wa pátápátá yóò bá bá wa lọ. A kò le è rí ojú ọkùnrin náà àyàfi tí àbúrò wa bá lọ pẹ̀lú wa.’ ");
INSERT INTO yor_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Baba mi, ìránṣẹ́ rẹ wí fún wa pé, ‘Ẹ mọ̀ pé ìyàwó mi bí ọmọkùnrin méjì fún mi. ");
INSERT INTO yor_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ọ̀kan nínú wọn lọ kúrò lọ́dọ̀ mi, mo sì wí pé, “Dájúdájú a ti fà á ya pẹ́rẹpẹ̀rẹ.” N kò sì tí ì ri láti ọjọ́ náà. ");
INSERT INTO yor_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tí ẹ bá tún mú èyí lọ, kúrò lọ́dọ̀ mi, tí ohunkóhun bá ṣe é, ìbànújẹ́ ni ẹ ó fi mú ewú orí mi lọ sí ipò òkú.’ ");
INSERT INTO yor_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Nítorí náà, bí a bá padà tọ baba wa lọ láìsí ọmọ náà pẹ̀lú wa nígbà tí a mọ̀ pé, ọmọ náà ni ẹ̀mí baba wa. ");
INSERT INTO yor_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Tí ó bá ri pé ọmọkùnrin náà kò wá pẹ̀lú wa, yóò kùú. Àwọn ìránṣẹ́ rẹ yóò wá mú baba wa tòun ti ewú orí lọ sí ipò òkú ní ìbànújẹ́. ");
INSERT INTO yor_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ìránṣẹ́ rẹ ló ṣe onídùúró fún ààbò ọmọ náà lọ́dọ̀ baba mi. Mo wí pé, ‘Bí n kò bá mú un padà tọ̀ ọ́ wá, baba mi, èmi ó ru ẹ̀bi rẹ̀ ní gbogbo ọjọ́ ayé mi!’ ");
INSERT INTO yor_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Nítorí náà, jẹ́ kí ìránṣẹ́ rẹ kí ó dúró ní ìhín lọ́dọ̀ olúwa à mi bí ẹrú dípò ọmọ náà. Kí ọmọ náà bá àwọn arákùnrin rẹ̀ padà. ");
INSERT INTO yor_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Báwo ni mo ṣe lè padà tọ baba mi lọ láì bá ṣe pé ọmọ náà wà pẹ̀lú mi? Rárá, èmi kò fẹ́ kí n rí ìbànújẹ́ tí yóò dé bá baba mi.” ");
INSERT INTO yor_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Josẹfu kò sì le è pa á mọ́ra mọ́ níwájú gbogbo àwọn tí ó dúró tì í. Ó sì sọkún sókè tó bẹ́ẹ̀ tí àwọn tí ó wà ní àyíká gbọ́ ohun ẹkún rẹ̀. “Jẹ́ kí gbogbo ènìyàn kúrò ní ọ̀dọ̀ mi.” Kò sì sí ẹnikẹ́ni lọ́dọ̀ rẹ̀ nígbà tí ó fi ara rẹ̀ hàn fún àwọn arákùnrin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ó sì sọkún sókè kíkankíkan tó bẹ́ẹ̀ tí àwọn Ejibiti gbọ́ ohùn ẹkún rẹ̀, àwọn ilé Farao pẹ̀lú sì gbọ́ nípa rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josẹfu wí fún àwọn arákùnrin rẹ̀ pé, “Èmi ni Josẹfu! Ṣe baba mi sì wà láààyè?” Ṣùgbọ́n àwọn arákùnrin rẹ̀ kò le è dá a lóhùn nítorí ẹ̀rù bà wọ́n gidigidi, ẹnu sì yà wọ́n níwájú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Nígbà náà ni Josẹfu wí fún àwọn arákùnrin rẹ̀ pé, “Ẹ súnmọ́ ọ̀dọ̀ mi.” Nígbà tí wọ́n sì ti ṣe bẹ́ẹ̀, ó wí pé, “Èmi ni Josẹfu arákùnrin yín tí ẹ tà sí ilẹ̀ Ejibiti! ");
INSERT INTO yor_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ṣùgbọ́n báyìí, ẹ má ṣe banújẹ́, ẹ má sì ṣe bínú sí ara yín ní títà tí ẹ tà mí sí ìhín, nítorí, ọ̀nà àti gba ẹ̀mí yín là ni Ọlọ́run ṣe rán mi sí ìhín ṣáájú yín. ");
INSERT INTO yor_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ìyàn tí ó ti mú láti ọdún méjì sẹ́yìn yìí yóò tẹ̀síwájú fún ọdún márùn-ún sí i nínú èyí tí ẹnikẹ́ni kò ní gbìn, bẹ́ẹ̀ ni wọn kò ni kórè. ");
INSERT INTO yor_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ṣùgbọ́n Ọlọ́run rán mi ṣáájú yín sí ìhín láti da irú-ọmọ yín sí fún un yín lórí ilẹ̀ ayé àti láti fi ìgbàlà ńlá gba ẹ̀mí yín là. ");
INSERT INTO yor_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Nítorí náà, kì í ṣe ẹ̀yin ni ó rán mi wá sí ibí yìí, bí kò ṣe Ọlọ́run. Ó fi mí ṣe baba, Olùdámọ̀ràn fún Farao, olúwa fún gbogbo ilé Farao àti alákòóso gbogbo ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Nísinsin yìí, ẹ yára padà sọ́dọ̀ baba mi kí ẹ sì wí fun un pé, èyí ni ohun tí Josẹfu ọmọ rẹ wí, Ọlọ́run ti fi mí ṣe olúwa fún gbogbo ilẹ̀ Ejibiti, ẹ sọ̀kalẹ̀ wá láì jáfara. ");
INSERT INTO yor_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ìwọ yóò gbé ní agbègbè Goṣeni, ìwọ kì yóò jìnnà sí mi, àwọn ọmọ rẹ àti àwọn ọmọ ọmọ rẹ, àwọn agbo ẹran rẹ àti agbo màlúù rẹ àti gbogbo ohun tí ìwọ ní. ");
INSERT INTO yor_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Èmi yóò pèsè fún yín níbẹ̀. Nítorí ó ṣì ku ọdún márùn-ún gbáko ti ìyàn yóò fi mú. Kí ìwọ àti ilé rẹ àti ohun tí í ṣe tìrẹ má ba à di aláìní. ");
INSERT INTO yor_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Ẹ̀yin fúnra yín àti Benjamini arákùnrin mi pẹ̀lú rí i pé, lóòótọ́ lóòótọ́, èmi Josẹfu ni mo ń bá a yín sọ̀rọ̀. ");
INSERT INTO yor_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ẹ sọ fún baba mi nípa gbogbo ọlá tí a fún mi ní ilẹ̀ Ejibiti àti ohun gbogbo tí ẹ̀yin ti rí, kí ẹ sì mú baba mi tọ̀ mí wá sí ìhín yìí kíákíá.” ");
INSERT INTO yor_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Nígbà náà ni ó dì mọ́ Benjamini arákùnrin rẹ̀, ó sì sọkún, Benjamini náà sì dì mọ́ ọn, pẹ̀lú omijé lójú. ");
INSERT INTO yor_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ó sì tún fẹnu ko gbogbo àwọn arákùnrin rẹ̀ lẹ́nu, ó sì sọkún sí wọn lára. Lẹ́yìn èyí, Josẹfu àti àwọn arákùnrin rẹ̀ sọ̀rọ̀ pọ̀. ");
INSERT INTO yor_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Nígbà tí ìròyìn náà dé ààfin Farao pé àwọn arákùnrin Josẹfu dé, inú Farao àti àwọn ìjòyè rẹ̀ dùn. ");
INSERT INTO yor_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao wí fún Josẹfu pé, “Wí fún àwọn arákùnrin rẹ pé, ‘Èyí ni kí ẹ ṣe, ẹ di ẹrù lé ẹranko yín kí ẹ sì padà sí ilẹ̀ Kenaani, ");
INSERT INTO yor_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","kí ẹ sì mú baba yín àti ìdílé yín tọ̀ mí wá. Èmi yóò fún un yín ní ibi tí ó dára jùlọ ní ilẹ̀ Ejibiti, ẹ̀yin yóò sì le è gbádùn ilẹ̀ yìí.’ ");
INSERT INTO yor_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“A pàṣẹ fún ọ láti sọ fún wọn pé, ‘Ẹ ṣe èyí. ẹ mú kẹ̀kẹ́ ẹrù láti ilẹ̀ Ejibiti fún àwọn ọmọ yín àti àwọn aya yín. Kí ẹ sì mú baba yín tọ mí wá. ");
INSERT INTO yor_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ẹ má ṣe àníyàn nípa ohun ìní yín nítorí èyí tí ó dára jù nínú ilẹ̀ Ejibiti yóò jẹ́ tiyín.’ ” ");
INSERT INTO yor_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Àwọn ọmọ Israẹli sì ṣe èyí. Josẹfu fún wọn ni kẹ̀kẹ́ ẹrù bí Farao ti pàṣẹ, ó sì fún wọn ní oúnjẹ fún ìrìnàjò wọn pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ó fún ẹni kọ̀ọ̀kan wọn ní aṣọ tuntun. Ṣùgbọ́n Benjamini ni ó fún ní ọ̀ọ́dúnrún (300) ẹyọ owó idẹ fàdákà àti ìpààrọ̀ aṣọ márùn-ún. ");
INSERT INTO yor_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Àwọn nǹkan wọ̀nyí ni ó kó ránṣẹ́ sí baba rẹ̀: kẹ́tẹ́kẹ́tẹ́ mẹ́wàá tí ó ru àwọn ohun mèremère ilẹ̀ Ejibiti àti abo kẹ́tẹ́kẹ́tẹ́ mẹ́wàá tí ó ru ọkà àti oríṣìíríṣìí oúnjẹ. ");
INSERT INTO yor_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Nígbà náà ni ó rán àwọn arákùnrin rẹ̀ lọ, bí wọ́n ṣe ń pínyà, ó wí fún wọn pé, “Ẹ má ṣe jà ní ọ̀nà o!” ");
INSERT INTO yor_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Báyìí ni wọ́n jáde kúrò ní ilẹ̀ Ejibiti wá sí ọ̀dọ̀ Jakọbu baba wọn ní ilẹ̀ Kenaani. ");
INSERT INTO yor_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wọn wí fún un pé, “Josẹfu ṣì wà láààyè! Kódà òun ni alákòóso ilẹ̀ Ejibiti.” Ẹnu ya Jakọbu, kò sì gbà wọ́n gbọ́. ");
INSERT INTO yor_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ṣùgbọ́n nígbà tí wọ́n sọ ohun gbogbo tí Josẹfu ti sọ fún wọn fún un tí ó sì rí kẹ̀kẹ́ ẹrù tí Josẹfu fi ránṣẹ́ láti gbé e padà wá, iyè Jakọbu, baba wọn sọ. ");
INSERT INTO yor_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israẹli sì wí pé, “Mo gbà dájúdájú wí pé, Josẹfu ọmọ mi wà láààyè. Èmi ó lọ rí i kí n tó kú.” ");
INSERT INTO yor_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Báyìí ni Israẹli mú ìrìnàjò rẹ̀ pọ̀n pẹ̀lú ohun gbogbo tí ó ní, nígbà tí ó sì dé Beerṣeba, ó rú ẹbọ sí Ọlọ́run Isaaki baba rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ọlọ́run sì bá Israẹli sọ̀rọ̀ ní ojú ìran ní òru pé, “Jakọbu! Jakọbu!” Ó sì dáhùn pé, “Èmi nìyí.” ");
INSERT INTO yor_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ọlọ́run sì wí pé, “Èmi ni Ọlọ́run, Ọlọ́run baba rẹ, má ṣe bẹ̀rù láti sọ̀kalẹ̀ lọ sí ilẹ̀ Ejibiti nítorí, èmi yóò sọ ọ́ di orílẹ̀-èdè ńlá níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Èmi yóò sì sọ̀kalẹ̀ pẹ̀lú rẹ lọ sí Ejibiti, èmi yóò sì tún mú ọ padà wá. Ọwọ́ Josẹfu fúnra rẹ̀ ni ìwọ yóò sì kú sí.” ");
INSERT INTO yor_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Nígbà náà ni Jakọbu kúrò ní Beerṣeba, àwọn ọmọ Israẹli sì mú Jakọbu baba wọn àti àwọn aya wọn àti àwọn ọmọ wọn, wọ́n sì kó wọn sí inú kẹ̀kẹ́ ẹrù tí Farao fi ránṣẹ́ fún ìrìnàjò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Wọ́n tún kó àwọn ohun ọ̀sìn wọn àti gbogbo ohun ìní tí wọ́n ti ní láti ilẹ̀ Kenaani, Jakọbu àti gbogbo irú-ọmọ rẹ̀ sọ̀kalẹ̀ lọ sí Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ó kó àwọn ọmọ rẹ̀ ọkùnrin pẹ̀lú àwọn ọmọ ọmọ rẹ̀ ọkùnrin, àwọn ọmọ rẹ̀ obìnrin pẹ̀lú àwọn ọmọ ọmọ rẹ̀ obìnrin, gbogbo irú-ọmọ rẹ̀ lọ sí Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Èyí ni orúkọ àwọn ọmọ Israẹli (Jakọbu àti ìran rẹ̀) tí ó sọ̀kalẹ̀ lọ Ejibiti: Reubeni àkọ́bí Jakọbu. ");
INSERT INTO yor_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Àwọn ọmọkùnrin Reubeni: Hanoku, Pallu, Hesroni àti Karmi. ");
INSERT INTO yor_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Àwọn ọmọkùnrin Simeoni: Jemueli, Jamini, Ohadi, Jakini, Sohari àti Saulu, tí ìyá rẹ̀ jẹ́ ọmọbìnrin ará Kenaani. ");
INSERT INTO yor_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Àwọn ọmọkùnrin Lefi: Gerṣoni, Kohati àti Merari. ");
INSERT INTO yor_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Àwọn ọmọkùnrin Juda: Eri, Onani, Ṣela, Peresi àti Sera (ṣùgbọ́n Ẹri àti Onani ti kú ní ilẹ̀ Kenaani). Àwọn ọmọ Peresi: Hesroni àti Hamulu. ");
INSERT INTO yor_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Àwọn ọmọkùnrin: Isakari! Tola, Pua, Jaṣibu àti Ṣimroni. ");
INSERT INTO yor_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Àwọn ọmọkùnrin Sebuluni: Seredi, Eloni àti Jahaleli. ");
INSERT INTO yor_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Wọ̀nyí ni àwọn ọmọkùnrin Lea tí ó bí fún Jakọbu ní Padani-Aramu yàtọ̀ fún Dina ọmọbìnrin rẹ̀. Àwọn ọmọkùnrin rẹ̀ àti ọmọbìnrin rẹ̀ wọ̀nyí jẹ́ mẹ́tàlélọ́gbọ̀n (33) lápapọ̀. ");
INSERT INTO yor_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Àwọn ọmọkùnrin Gadi: Sefoni, Haggi, Ṣuni, Esboni, Eri, Arodi, àti Areli. ");
INSERT INTO yor_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Àwọn ọmọkùnrin Aṣeri: Imina, Iṣifa, Iṣfi àti Beriah. Arábìnrin wọn ni Sera. Àwọn ọmọkùnrin Beriah: Heberi àti Malkieli. ");
INSERT INTO yor_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Wọ̀nyí ni àwọn ọmọ tí Jakọbu bí nípasẹ̀ Silipa, ẹni tí Labani fi fún Lea ọmọbìnrin rẹ̀. Gbogbo wọn jẹ́ mẹ́rìndínlógún lápapọ̀. ");
INSERT INTO yor_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Àwọn ọmọkùnrin Rakeli aya Jakọbu: Josẹfu àti Benjamini. ");
INSERT INTO yor_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ní Ejibiti, Asenati ọmọbìnrin Potifẹra, alábojútó àti àlùfáà Oni, bí Manase àti Efraimu fún Josẹfu. ");
INSERT INTO yor_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Àwọn ọmọ Benjamini: Bela, Bekeri, Aṣbeli, Gera, Naamani, Ehi, Roṣi, Mupimu, Huppimu àti Ardi. ");
INSERT INTO yor_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Wọ̀nyí ni àwọn ọmọkùnrin tí Rakeli bí fún Jakọbu. Wọ́n jẹ́ mẹ́rìnlá lápapọ̀. ");
INSERT INTO yor_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Àwọn ọmọ Dani: Huṣimu. ");
INSERT INTO yor_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Àwọn ọmọ Naftali: Jasieli, Guni, Jeseri, àti Ṣillemu. ");
INSERT INTO yor_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Wọ̀nyí ni àwọn ọmọ tí Biliha ẹni tí Labani fi fún Rakeli ọmọ rẹ̀ bí fún Jakọbu. Wọ́n jẹ́ méje lápapọ̀. ");
INSERT INTO yor_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Gbogbo àwọn tí ó lọ pẹ̀lú Jakọbu sí Ejibiti, àwọn tí ó jẹ́ ìran rẹ̀ tààrà láìka àwọn aya ọmọ rẹ̀, jẹ́ ènìyàn mẹ́rìndínláàádọ́rin. ");
INSERT INTO yor_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Pẹ̀lú àwọn ọmọkùnrin méjì tí a bí fún Josẹfu ní Ejibiti àwọn ará ilé Jakọbu tí ó lọ sí Ejibiti jẹ́ àádọ́rin lápapọ̀. ");
INSERT INTO yor_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jakọbu sì rán Juda ṣáájú rẹ̀ lọ sọ́dọ̀ Josẹfu, kí wọn bá à le mọ ọ̀nà Goṣeni. Nígbà tí wọ́n dé agbègbè Goṣeni, ");
INSERT INTO yor_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josẹfu tọ́jú kẹ̀kẹ́-ẹṣin rẹ̀ ó sì lọ sí Goṣeni láti pàdé Israẹli baba rẹ̀. Bí Josẹfu ti dé iwájú baba rẹ̀, ó dì mọ́ baba rẹ̀ ó sì sọkún fún ìgbà pípẹ́. ");
INSERT INTO yor_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israẹli wí fún Josẹfu pé, “Wàyí o, mo le kú, níwọ̀n bí mo ti rí i fún ara mi pé, o wà láààyè síbẹ̀.” ");
INSERT INTO yor_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Nígbà náà ni Josẹfu wí fún àwọn arákùnrin rẹ̀ àti fún àwọn ará ilé baba rẹ̀ pé, “Èmi yóò gòkè lọ, èmi yóò sì bá Farao sọ̀rọ̀, èmi yóò sì wí fún un pé, ‘Àwọn arákùnrin mi àti ìdílé baba mi tí ń gbé ní Kenaani ti tọ̀ mí wá. ");
INSERT INTO yor_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Darandaran ni àwọn ènìyàn náà, wọ́n ń tọ́jú ẹran ọ̀sìn, wọ́n sì kó agbo ẹran wọn àti agbo màlúù wọn àti gbogbo ohun tí wọ́n ní pẹ̀lú wá.’ ");
INSERT INTO yor_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Nígbà tí Farao bá pè yín wọlé tí ó sí béèrè irú iṣẹ́ tí ẹ ń ṣe, ");
INSERT INTO yor_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ẹ fún un lésì pé, ‘Àwọn ìránṣẹ́ rẹ ń tọ́jú ẹran ọ̀sìn ni láti ìgbà èwe wa wá gẹ́gẹ́ bí a ṣe ba a lọ́wọ́ àwọn baba wa.’ Nígbà náà ni wọn yóò fún un yín láààyè láti tẹ̀dó sí ilẹ̀ Goṣeni, nítorí pé àwọn ará Ejibiti kórìíra ẹnikẹ́ni tí ó bá jẹ́ darandaran.” ");
INSERT INTO yor_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josẹfu lọ sọ fún Farao pé, “Baba mi àti àwọn arákùnrin mi, pẹ̀lú agbo ẹran, agbo màlúù àti ohun gbogbo tí wọ́n ní, ti dé láti ilẹ̀ Kenaani, wọ́n sì ti wà ní ilẹ̀ Goṣeni báyìí.” ");
INSERT INTO yor_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ó yan márùn-ún àwọn arákùnrin rẹ́, ó sì fi wọ́n han Farao. ");
INSERT INTO yor_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao béèrè lọ́wọ́ àwọn arákùnrin rẹ̀ pé, “Kí ni iṣẹ́ yín?” Wọ́n sì fèsì pé, “Darandaran ni àwọn ìránṣẹ́ rẹ, gẹ́gẹ́ bí àwọn baba wa ti jẹ́ darandaran.” ");
INSERT INTO yor_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Wọ́n sì tún sọ fun un síwájú sí i pé, “A wá láti gbé ìhín yìí fún ìgbà díẹ̀ nítorí ìyàn náà mú púpọ̀ ní ilẹ̀ Kenaani, àwọn ohun ọ̀sìn àwa ìránṣẹ́ rẹ kò sì rí ewéko jẹ. Nítorí náà jọ̀wọ́ má ṣàì jẹ́ kí àwọn ìránṣẹ́ rẹ tẹ̀dó sí ilẹ̀ Goṣeni.” ");
INSERT INTO yor_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farao wí fún Josẹfu pé, “Baba rẹ àti àwọn arákùnrin rẹ tọ̀ ọ́ wá, ");
INSERT INTO yor_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ilẹ̀ Ejibiti sì nìyí níwájú rẹ, mú àwọn arákùnrin rẹ tẹ̀dó sí ibi tí ó dára jù nínú ilẹ̀ náà. Jẹ́ kí wọn máa gbé ní Goṣeni. Bí o bá sì mọ ẹnikẹ́ni nínú wọn tí ó ní ẹ̀bùn ìtọ́jú ẹran, fi wọ́n ṣe olùtọ́jú ẹran ọ̀sìn mi.” ");
INSERT INTO yor_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Nígbà náà ni Josẹfu mú Jakọbu baba rẹ̀ wọlé wá sí iwájú Farao. Lẹ́yìn ìgbà tí Jakọbu súre fún Farao tán. ");
INSERT INTO yor_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao béèrè lọ́wọ́ Jakọbu pé, “Ọmọ ọdún mélòó ni ọ́?” ");
INSERT INTO yor_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakọbu sì dá Farao lóhùn, “Ọdún ìrìnàjò ayé mi jẹ́ àádóje, ọjọ́ mi kò pọ̀, ó sì kún fún wàhálà, síbẹ̀ kò ì tí ì tó ti àwọn baba mi.” ");
INSERT INTO yor_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Nígbà náà ni Jakọbu tún súre fún Farao, ó sì jáde lọ kúrò níwájú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Josẹfu sì fi baba rẹ̀ àti àwọn arákùnrin rẹ̀ sí ilẹ̀ Ejibiti, ó sì fún wọn ní ohun ìní ní ibi tí ó dára jù ní ilẹ̀ náà, ní agbègbè Ramesesi bí Farao ti pàṣẹ. ");
INSERT INTO yor_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josẹfu sì pèsè oúnjẹ fún baba rẹ̀ àti àwọn arákùnrin rẹ̀ àti gbogbo ìdílé baba rẹ̀ gẹ́gẹ́ bi iye àwọn ọmọ wọn. ");
INSERT INTO yor_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ṣùgbọ́n kò sí oúnjẹ ní gbogbo ilẹ̀ náà nítorí tí ìyàn náà mú púpọ̀ tó bẹ́ẹ̀ tí ilẹ̀ Ejibiti àti ilẹ̀ Kenaani gbẹ nítorí ìyàn náà. ");
INSERT INTO yor_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josẹfu gba gbogbo owó tí ó wà ní ilẹ̀ Ejibiti àti Kenaani ní ìpààrọ̀ fún ti ọkà tí wọn ń rà, ó sì mú owó náà wá sí ààfin Farao. ");
INSERT INTO yor_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Nígbà tí owó wọn tán pátápátá ní Ejibiti àti Kenaani, gbogbo Ejibiti wá bá Josẹfu, wọ́n wí pé, “Fún wa ní oúnjẹ, èéṣe tí a ó fi kú ní ojú rẹ? Gbogbo owó wa ni a ti ná tán.” ");
INSERT INTO yor_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Josẹfu wí pé, “Ẹ mú àwọn ẹran ọ̀sìn yín wá, èmi yóò fún un yín ní oúnjẹ ní ìpààrọ̀ fún ẹran ọ̀sìn yín, níwọ̀n bí owó yín ti tan.” ");
INSERT INTO yor_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Nítorí náà wọ́n mú àwọn ẹran ọ̀sìn wọn tọ Josẹfu wá, ó sì fún wọn ní oúnjẹ ní ìpààrọ̀ fún ẹṣin, àgùntàn, ewúrẹ́, màlúù àti kẹ́tẹ́kẹ́tẹ́ wọn. Ó sì mú wọn la ọdún náà já, tí ó ń fún wọn ní oúnjẹ ní ìpààrọ̀ fún ẹran ọ̀sìn wọn. ");
INSERT INTO yor_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Nígbà tí ọdún náà parí, wọn padà tọ̀ ọ́ wá ní ọdún tí ó tẹ̀lé, wọn wí pé, “A kò le fi pamọ́ fun olúwa wa pé níwọ̀n bí owó wa ti tan tí gbogbo ẹran ọ̀sìn wa sì ti di tirẹ̀ pé, kò sí ohunkóhun tókù fún olúwa wa bí kò ṣe ara wa àti ilẹ̀ wa. ");
INSERT INTO yor_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Èéṣe tí àwa yóò fi parun lójú rẹ, ra àwa tìkára wa àti ilẹ̀ wa ní ìpààrọ̀ fún oúnjẹ, àwa àti ilẹ̀ wa yóò sì wà nínú ìgbèkùn Farao. Fún wa ni oúnjẹ kí àwa kí ó má ba à kú, kí ilẹ̀ wa má ba à di ahoro.” ");
INSERT INTO yor_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Nítorí náà Josẹfu ra gbogbo ilẹ̀ tí ó wà ní Ejibiti fún Farao, kò sí ẹnìkan tí ó ṣẹ́kù ní Ejibiti tí kò ta ilẹ̀ tirẹ̀ nítorí ìyàn náà mú jù fún wọn. Gbogbo ilẹ̀ náà sì di ti Farao, ");
INSERT INTO yor_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Josẹfu sì sọ gbogbo ará Ejibiti di ẹrú láti igun kan dé èkejì. ");
INSERT INTO yor_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ṣùgbọ́n ṣá, kò ra ilẹ̀ àwọn àlùfáà, nítorí wọ́n ń gba ìpín oúnjẹ lọ́wọ́ Farao, wọn sì ní oúnjẹ tí ó tó láti inú ìpín tí Farao ń fún wọn. Ìdí nìyí tí wọn kò fi ta ilẹ̀ wọn. ");
INSERT INTO yor_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Josẹfu wí fún àwọn ènìyàn náà pé, “Níwọ́n ìgbà tí mo ti ra ẹ̀yin àti ilẹ̀ yín tan lónìí fún Farao, irúgbìn rèé, ẹ lọ gbìn ín sí ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ṣùgbọ́n nígbà tí ìre oko náà bá jáde, ẹ ó mú ìdákan nínú ìdámárùn-ún rẹ̀ fún Farao. Ẹ le pa ìdámẹ́rin tókù mọ́ fún ara yín àti ìdílé yín àti àwọn ọmọ yín.” ");
INSERT INTO yor_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wọ́n dá á lóhùn pé, “O ti gbà wá là, ǹjẹ́ kí a rí ojúrere níwájú olúwa wa, àwa yóò di ẹrú Farao.” ");
INSERT INTO yor_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nítorí náà Josẹfu sọ ọ́ di òfin nípa ọ̀rọ̀ ilẹ̀ ni Ejibiti, ó sì wà bẹ́ẹ̀ di òní olónìí pé, ìdákan nínú ìdámárùn-ún ìre oko jẹ́ ti Farao, ilẹ̀ àwọn àlùfáà nìkan ni kò di ti Farao. ");
INSERT INTO yor_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Àwọn ará Israẹli sì tẹ̀dó sí Ejibiti ní agbègbè Goṣeni. Wọ́n ní ohun ìní fún ara wọn, wọ́n sì bí sí i tó bẹ́ẹ̀ tí wọ́n pọ̀ si gidigidi ní iye. ");
INSERT INTO yor_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakọbu gbé ní Ejibiti fún ọdún mẹ́tàdínlógún iye ọdún ọjọ́ ayé rẹ̀ sì jẹ́ ẹẹ́tàdínlàádọ́jọ (147). ");
INSERT INTO yor_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Nígbà tí àkókò ń súnmọ́ etílé fún Israẹli láti kú, ó pe Josẹfu, ọmọ rẹ̀, ó sì wí fún un pé, “Bí mo bá rí ojúrere ni ojú rẹ̀ fi ọwọ́ rẹ sí abẹ́ itan mi, kí o sì ṣe ìlérí pé ìwọ yóò fi àánú àti òtítọ́ hàn sí mi. Má ṣe sin òkú mi sí ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ṣùgbọ́n, nígbà tí mo bá sinmi pẹ̀lú àwọn baba mi, gbé mí jáde kúrò ní Ejibiti kí o sì sin mí sí ibi tí wọ́n sin àwọn baba mi sí.” Josẹfu sì dáhùn wí pé, “Èmi ó ṣe bí ìwọ ti wí.” ");
INSERT INTO yor_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jakọbu wí pé, “Búra fún mi,” Josẹfu sì búra fún un. Israẹli sì tẹ orí rẹ̀ ba, bí ó ti sinmi lé orí ibùsùn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Lẹ́yìn ìgbà díẹ̀ si, a wí fún Josẹfu pé, “Baba rẹ ń ṣàìsàn,” nítorí náà, ó mú àwọn ọmọ rẹ̀ méjèèjì, Manase àti Efraimu lọ́wọ́ lọ pẹ̀lú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Nígbà tí a sọ fún Jakọbu pé, “Josẹfu ọmọ rẹ wá sí ọ̀dọ̀ rẹ,” Israẹli rọ́jú dìde jókòó lórí ibùsùn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakọbu wí fún Josẹfu pé, “El-Ṣaddai, fi ara hàn mí ní Lusi ní ilẹ̀ Kenaani, níbẹ̀ ni ó sì ti súre fún mi. ");
INSERT INTO yor_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ó sì wí fún mi pé, ‘Èmi yóò mú kí o bí sí i, ìwọ yóò sì pọ̀ sí i, èmi yóò sì sọ ọ́ di orílẹ̀-èdè ńlá, èmi yóò sì fún ìwọ àti irú-ọmọ rẹ lẹ́yìn rẹ ní ilẹ̀ yìí gẹ́gẹ́ bí ohun ìní ayérayé.’ ");
INSERT INTO yor_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Nítorí náà báyìí, àwọn ọmọ rẹ méjèèjì tí a bí fún ọ ní ilẹ̀ Ejibiti, kí èmi kí ó tó tọ̀ ọ́ wá ní ìhín, ni mo sọ di ọmọ mi fúnra mi. Manase àti Efraimu yóò jẹ́ tèmi gẹ́gẹ́ bí Reubeni àti Simeoni ti jẹ́ tèmi. ");
INSERT INTO yor_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Àwọn ọmọ mìíràn tí ìwọ bá bí lẹ́yìn wọn yóò jẹ́ ọmọ rẹ. Ní ilẹ̀ tí wọn yóò jogún, orúkọ arákùnrin wọn ni a ó máa fi pè wọ́n. ");
INSERT INTO yor_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Bí mo ti ń padà láti Padani, Rakeli kú ní ọ̀nà nígbà tí ó ṣì wà ní ilẹ̀ Kenaani, èyí tó mú ìbànújẹ́ bá mi, níbi tí kò jìnnà sí Efrata. Nítorí náà èmí sì sin ín sí ẹ̀bá ọ̀nà tí ó lọ sí Efrata” (tí ṣe Bẹtilẹhẹmu). ");
INSERT INTO yor_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Nígbà tí Israẹli rí àwọn ọmọ Josẹfu, ó béèrè wí pé, “Àwọn wo nìyí?” ");
INSERT INTO yor_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josẹfu fún baba rẹ̀ lésì pé, “Wọ̀nyí ni àwọn ọmọkùnrin tí Ọlọ́run ti fi fún mi ní ìhín.” Nígbà náà ni Israẹli wí pé, “Kó wọn wá sí ọ̀dọ̀ mi kí èmi kí ó ba à le súre fún wọn.” ");
INSERT INTO yor_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Báyìí, ojú Israẹli ti ń di bàìbàì nítorí ogbó, agbára káká sì ni ó fi ń ríran. Josẹfu sì kó àwọn ọmọ rẹ̀ súnmọ́ ọ̀dọ̀ rẹ̀, baba rẹ̀ fẹnukò wọ́n ni ẹnu, ó sì dì mọ́ wọn. ");
INSERT INTO yor_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israẹli wí fún Josẹfu pé, “Èmi kò lérò rárá pé, mo tún le rí ojú rẹ mọ́ láéláé, ṣùgbọ́n Ọlọ́run tún fún mi ní àǹfààní, mo sì tún rí àwọn ọmọ rẹ pẹ̀lú.” ");
INSERT INTO yor_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Nígbà náà ni Josẹfu kó àwọn ọmọ náà kúrò ní orí eékún baba rẹ̀, ó wólẹ̀, ó sì tẹríba. ");
INSERT INTO yor_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Josẹfu sì mú àwọn méjèèjì, Efraimu ni o fi sí ọwọ́ ọ̀tún òun tìkára rẹ̀, èyí tí í ṣe ọwọ́ òsì fún Israẹli, ó sì fi Manase sí ọwọ́ òsì ara rẹ̀, èyí tí ó bọ́ sí ọwọ́ ọ̀tún Israẹli. ");
INSERT INTO yor_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israẹli sì na ọwọ́ ọ̀tún rẹ̀ jáde, ó sì gbe lé Efraimu lórí, bí ó tilẹ̀ jẹ́ pé òun ni àbúrò, ó sì fi ọwọ́ rẹ̀ tàsé ara wọn, ó sì na ọwọ́ òsì lé Manase lórí, bí ó tilẹ̀ jẹ́ pé Manase ni àkọ́bí. ");
INSERT INTO yor_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Nígbà náà ni ó súre fún Josẹfu wí pé, “Ǹjẹ́ kí Ọlọ́run, ẹni tí baba mi Abrahamu àti Isaaki rìn níwájú rẹ̀, Ọlọ́run tí ó ti jẹ́ olùtọ́jú àti aláàbò mi ní gbogbo ọjọ́ ayé mi títí di òní, ");
INSERT INTO yor_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Angẹli tí ó dá mi ní ìdè kúrò lọ́wọ́ gbogbo ewu, kí ó súre fún àwọn ọmọkùnrin wọ̀nyí. Kí a máa fi orúkọ mi pè wọ́n àti orúkọ àwọn baba mi Abrahamu àti Isaaki, kí wọn kí ó sì pọ̀ sí i lọ́pọ̀lọ́pọ̀ lórí ilẹ̀ ayé.” ");
INSERT INTO yor_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Nígbà tí Josẹfu rí i pé baba òun gbé ọwọ́ ọ̀tún lé Efraimu lórí, inú rẹ̀ bàjẹ́, ó sì gbá ọwọ́ baba rẹ̀ mú láti gbé ọwọ́ rẹ̀ kúrò lórí Efraimu lọ sí orí Manase. ");
INSERT INTO yor_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Josẹfu wí fun pé, “Rárá, baba mi, èyí ni àkọ́bí, orí rẹ̀ ni kí ìwọ kí o gbé ọwọ́ ọ̀tún rẹ lé.” ");
INSERT INTO yor_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ṣùgbọ́n baba rẹ̀ kò gbà, ó wí pé, “Mo mọ̀, ọmọ mi, mo mọ̀. Òun náà yóò di orílẹ̀-èdè, òun náà yóò sì di ńlá. Ṣùgbọ́n àbúrò rẹ̀ yóò di ẹni ńlá jù ú lọ, irú-ọmọ rẹ yóò sì di ọ̀pọ̀lọpọ̀ orílẹ̀-èdè.” ");
INSERT INTO yor_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ó súre fún wọn lọ́jọ́ náà pé, “Ní orúkọ yín ni Israẹli yóò máa súre yìí pé, ‘Kí Ọlọ́run ṣe ọ́ bí i ti Efraimu àti Manase.’ ” Ó sì gbé Efraimu gẹ́gẹ́ bí ẹ̀gbọ́n sí Manase. ");
INSERT INTO yor_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nígbà náà ni Israẹli wí fún Josẹfu pé, “Ọjọ́ ikú mi súnmọ́ etílé, ṣùgbọ́n Ọlọ́run yóò wà pẹ̀lú yín, yóò sì mú un yín padà sí ilẹ̀ àwọn baba yín. ");
INSERT INTO yor_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Pẹ̀lúpẹ̀lú èmi yóò fún ọ ní ìpín kan ju ti àwọn arákùnrin rẹ lọ. Ilẹ̀ tí mo fi idà àti ọ̀kọ̀ mi gbà lọ́wọ́ àwọn ará Amori.” ");
INSERT INTO yor_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Nígbà náà ni Jakọbu ránṣẹ́ pe àwọn ọmọ rẹ̀, ó sì wí pé, “Ẹ kó ara yín jọ pọ̀, kí n le è sọ ohun tí yóò ṣẹlẹ̀ ní ọjọ́ iwájú fún un yín. ");
INSERT INTO yor_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ẹ kó ara yín jọ pọ̀, kí ẹ sì tẹ́tí, ẹ̀yin ọmọ Jakọbu; ẹ fetí sí Israẹli baba yín. ");
INSERT INTO yor_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reubeni, ìwọ ni àkọ́bí mi, agbára mi, ìpilẹ̀ṣẹ̀ ipá mi, títayọ ní ọlá àti títayọ ní agbára. ");
INSERT INTO yor_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ẹni ríru bí omi Òkun, ìwọ kì yóò tayọ mọ́, nítorí pé ìwọ gun ibùsùn baba rẹ, lórí àkéte mi, ìwọ sì bà á jẹ́ (ìwọ bá ọ̀kan nínú àwọn aya baba rẹ lòpọ̀). ");
INSERT INTO yor_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeoni àti Lefi jẹ́ arákùnrin— idà wọn jẹ́ ohun èlò ogun alágbára. ");
INSERT INTO yor_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Kí ọkàn mi má ṣe ni àṣepọ̀ pẹ̀lú wọn, kí n má sì ṣe dúró níbí ìpéjọpọ̀ wọn, nítorí wọ́n ti pa àwọn ènìyàn ní ìbínú wọn, wọ́n sì da àwọn màlúù lóró bí ó ti wù wọ́n. ");
INSERT INTO yor_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ìfibú ni ìbínú wọn nítorí tí ó gbóná púpọ̀, àti fún ìrunú wọn nítorí tí ó kún fún ìkà! Èmi yóò tú wọn ká ní Jakọbu, èmi ó sì fọ́n wọn ká ní Israẹli. ");
INSERT INTO yor_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Juda, àwọn arákùnrin rẹ yóò yìn ọ, ọwọ́ rẹ yóò wà ní ọrùn àwọn ọ̀tá rẹ, àwọn ọmọkùnrin baba rẹ yóò foríbalẹ̀ fún ọ. ");
INSERT INTO yor_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ọmọ kìnnìún ni ọ́, ìwọ Juda, o darí láti igbó ọdẹ, ọmọ mi. Bí i kìnnìún, o ba mọ́lẹ̀, o sì sùn sílẹ̀ bí i abo kìnnìún, ta ni ó tó bẹ́ẹ̀, kí o lé e dìde? ");
INSERT INTO yor_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ọ̀pá oyè kì yóò kúrò ní Juda bẹ́ẹ̀ ni ọ̀pá-ìṣàkóso kì yóò kúrò láàrín ẹsẹ̀ rẹ̀, títí tí Ṣilo tí ó ni í yóò fi dé, tí gbogbo àwọn orílẹ̀-èdè yóò máa wárí fún un. ");
INSERT INTO yor_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yóò má so ọmọ ẹṣin rẹ̀ mọ́ igi àjàrà, àti ọmọ kẹ́tẹ́kẹ́tẹ́ rẹ̀ mọ́ ẹ̀ka tí ó dára jù. Yóò fọ aṣọ rẹ̀ nínú wáìnì àti ẹ̀wù rẹ̀ nínú omi-pupa ti èso àjàrà. ");
INSERT INTO yor_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ojú rẹ̀ yóò rẹ̀ dòdò ju wáìnì lọ, eyín rẹ yóò sì funfun ju omi-ọyàn lọ. ");
INSERT INTO yor_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebuluni yóò máa gbé ní etí Òkun, yóò sì jẹ́ èbúté fún ọkọ̀ ojú omi, agbègbè rẹ yóò tàn ká títí dé Sidoni. ");
INSERT INTO yor_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakari jẹ́ kẹ́tẹ́kẹ́tẹ́ alágbára tí ó dùbúlẹ̀ láàrín agbo àgùntàn. ");
INSERT INTO yor_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Nígbà tí ó bá rí bí ibi ìsinmi òun ti dára tó, àti bí ilẹ̀ rẹ̀ ti ní ìdẹ̀ra tó, yóò tẹ èjìká rẹ̀ ba láti ru àjàgà, yóò sì fi ara rẹ̀ fún iṣẹ́ ipá. ");
INSERT INTO yor_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani yóò ṣe ìdájọ́ àwọn ènìyàn rẹ̀ gẹ́gẹ́ bí ọ̀kan nínú àwọn ẹ̀yà Israẹli. ");
INSERT INTO yor_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani yóò jẹ́ ejò ni pópónà àti paramọ́lẹ̀ ní ẹ̀bá ọ̀nà, tí ó bu ẹṣin jẹ ní ẹsẹ̀, kí ẹni tí ń gùn ún bá à le è ṣubú sẹ́yìn. ");
INSERT INTO yor_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Mo ń dúró de ìtúsílẹ̀ rẹ, Olúwa. ");
INSERT INTO yor_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Ẹgbẹ́ ogun àwọn ẹlẹ́ṣin yóò kọlu Gadi, ṣùgbọ́n yóò kọlu wọ́n ní gìgísẹ̀ wọn. ");
INSERT INTO yor_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Oúnjẹ Aṣeri yóò dára; yóò ṣe àsè tí ó yẹ fún ọba. ");
INSERT INTO yor_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali yóò jẹ́ abo àgbọ̀nrín tí a tú sílẹ̀ tí ó ń bí ọmọ dáradára. ");
INSERT INTO yor_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Josẹfu jẹ́ àjàrà eléso, àjàrà eléso ní etí odò, tí ẹ̀ka rẹ̀ gun orí odi. ");
INSERT INTO yor_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Pẹ̀lú ìkorò, àwọn tafàtafà dojú ìjà kọ ọ́, wọ́n tafà sí í pẹ̀lú ìkanra. ");
INSERT INTO yor_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ṣùgbọ́n ọrun rẹ̀ dúró ni agbára, ọwọ́ agbára rẹ̀ ni a sì mu lára le, nítorí ọwọ́ alágbára Jakọbu, nítorí olùtọ́jú àti aláàbò àpáta Israẹli, ");
INSERT INTO yor_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","nítorí Ọlọ́run baba rẹ tí ó ràn ọ́ lọ́wọ́, nítorí Olódùmarè tí ó bùkún ọ pẹ̀lú láti ọ̀run wá, ìbùkún ọ̀gbìn tí ó wà ní ìsàlẹ̀, ìbùkún ti ọmú àti ti inú. ");
INSERT INTO yor_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ìbùkún baba rẹ pọ̀ púpọ̀ ju ìbùkún àwọn òkè ńlá ìgbàanì, ju ẹ̀bùn ńlá àwọn òkè láéláé. Jẹ́ kí gbogbo èyí sọ̀kalẹ̀ sí orí Josẹfu, lé ìpéǹpéjú ọmọ-aládé láàrín arákùnrin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamini jẹ́ ìkookò tí ó burú; ní òwúrọ̀ ni ó jẹ ẹran ọdẹ rẹ, ní àṣálẹ́, ó pín ìkógun.” ");
INSERT INTO yor_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Gbogbo ìwọ̀nyí ni àwọn ẹ̀yà Israẹli méjìlá, èyí sì ni ohun tí baba wọn sọ fún wọn nígbà tí ó súre fún wọn, tí ó sì fún ẹnìkọ̀ọ̀kan ní ìbùkún tí ó tọ́ sí i. ");
INSERT INTO yor_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Nígbà náà ni ó fún wọn ní àwọn ìlànà yìí, “Ọjọ́ ikú mi kù fẹ́ẹ́rẹ́. Kí ẹ sin mí sí ibojì pẹ̀lú àwọn baba mi ní inú àpáta ní ilẹ̀ Hiti ará Efroni. ");
INSERT INTO yor_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ihò àpáta tí ó wà ní ilẹ̀ Makpela, nítòsí Mamre ní Kenaani, èyí tí Abrahamu rà gẹ́gẹ́ bí ilẹ̀ ìsìnkú lọ́wọ́ Efroni ará Hiti pẹ̀lú ilẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Níbẹ̀ ni a sin Abrahamu àti aya rẹ̀ Sara sí, níbẹ̀ ni a sin Isaaki àti Rebeka aya rẹ̀ sí, níbẹ̀ sì ni mo sìnkú Lea sí. ");
INSERT INTO yor_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ilẹ̀ náà àti ihò àpáta tí ó wà nínú rẹ̀ ni a rà lọ́wọ́ ará Hiti.” ");
INSERT INTO yor_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nígbà tí Jakọbu ti pàṣẹ yìí fún àwọn ọmọ rẹ̀, ó gbé ẹsẹ̀ rẹ̀ sókè sórí ibùsùn, ó sì kú, a sì ko jọ pọ̀ mọ́ àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Josẹfu sì ṣubú lé baba rẹ̀, ó sọkún, ó sì fẹnukò ó ní ẹnu. ");
INSERT INTO yor_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Nígbà náà ni Josẹfu pàṣẹ fún àwọn oníṣègùn tí ó wà ní ìkáwọ́ rẹ̀ pé kí wọn kí ó ṣe òkú Israẹli baba rẹ̀ lọ́jọ̀, àwọn oníṣègùn náà sì ṣe bẹ́ẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Fún ogójì ọjọ́ ni wọ́n fi ṣe èyí, nítorí èyí ni àsìkò tí a máa ń fi ṣe ẹ̀ǹbáàmù òkú. Àwọn ará Ejibiti sì ṣọ̀fọ̀ rẹ̀ fún àádọ́rin ọjọ́. ");
INSERT INTO yor_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Nígbà tí ọjọ́ ìṣọ̀fọ̀ náà kọjá. Josẹfu wí fún àwọn ará ilé Farao pé, “Bí mo bá bá ojúrere yín pàdé, ẹ bá mi sọ fún Farao. ");
INSERT INTO yor_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Baba mi mú mi búra ó sì wí fún mi pé, “Mo ti fẹ́rẹ kú: sinmi sínú ibojì tí mo gbẹ́ fún ara mi ní ilẹ̀ Kenaani.” Nísinsin yìí, jẹ́ kí n lọ kí n sì sìnkú baba mi, lẹ́yìn náà èmi yóò padà wa.’ ” ");
INSERT INTO yor_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao wí pé, “Gòkè lọ, kí o sì sin baba rẹ, bí ó tí mú ọ búra.” ");
INSERT INTO yor_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Báyìí ni Josẹfu gòkè lọ láti sìnkú baba rẹ̀. Gbogbo àwọn ìjòyè Farao ni ó sìn ín lọ—àwọn àgbàgbà ilé rẹ̀, àti gbogbo àwọn àgbàgbà ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yàtọ̀ fún gbogbo àwọn ará ilé Josẹfu àti ti àwọn arákùnrin rẹ̀ àti àwọn tí ó jẹ́ ilé baba rẹ̀, àwọn ọmọ wọn nìkan àti agbo ẹran pẹ̀lú agbo màlúù ni ó sẹ́ kù ní Goṣeni. ");
INSERT INTO yor_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kẹ̀kẹ́-ẹṣin àti àwọn ẹlẹ́ṣin pẹ̀lú gòkè lọ. Àìmoye ènìyàn ni ó lọ. ");
INSERT INTO yor_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Nígbà tí wọ́n dé ilẹ̀ ìpakà Atadi, ní ẹ̀bá Jordani, wọn pohùnréré ẹkún, níbẹ̀ ni Josẹfu sì tún dúró ṣọ̀fọ̀ baba rẹ̀ fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Nígbà tí àwọn ará Kenaani tí ń gbé níbẹ̀ rí i bí wọ́n ti ń ṣọ̀fọ̀ náà ni ilẹ̀ ìpakà Atadi, wọ́n wí pé, “Ọ̀fọ̀ ńlá ni àwọn ará Ejibiti ń ṣe yìí.” Ìdí èyí ni a fi ń pe ibẹ̀ ní Abeli-Misraimu. Kò sì jìnnà sí Jordani. ");
INSERT INTO yor_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Báyìí ni àwọn ọmọ Jakọbu ṣe ohun tí baba wọn pàṣẹ fún wọn. ");
INSERT INTO yor_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Wọ́n gbé e lọ sí ilẹ̀ Kenaani, wọ́n sì sin ín sínú ihò àpáta tí ó wà ní oko Makpela, ní tòsí i Mamre tí Abrahamu rà gẹ́gẹ́ bí ilẹ̀ ìsìnkú lọ́wọ́ Efroni ará Hiti, pẹ̀lú ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Lẹ́yìn ìgbà tí ó ti sìnkú baba rẹ̀ tan, Josẹfu padà sí Ejibiti pẹ̀lú àwọn arákùnrin rẹ̀ àti àwọn mìíràn tí ó tẹ̀lé e lọ láti sin baba rẹ̀. ");
INSERT INTO yor_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nígbà tí àwọn arákùnrin Josẹfu rí i pé baba wọn kú, wọ́n wí fún ara wọn pé, “Ǹjẹ́ bí ó bá ṣe pé Josẹfu ṣì fi wá sínú ń kọ́, tí ó sì fẹ́ gbẹ̀san gbogbo aburú tí a ti ṣe sí i?” ");
INSERT INTO yor_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Nítorí náà wọ́n ránṣẹ́ sí Josẹfu wí pé, “Baba rẹ fi àṣẹ yìí sílẹ̀ kí ó tó lọ wí pé, ");
INSERT INTO yor_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Èyí ni kí ẹ̀yin kí ó sọ fún Josẹfu, mo bẹ̀ ọ́ kí o dáríjì àwọn arákùnrin rẹ, gbogbo ẹ̀ṣẹ̀ àti aburú tí wọ́n ṣe sí ọ, èyí tí ó mú ibi bá ọ’. Nísinsin yìí, jọ̀wọ́ dárí ẹ̀ṣẹ̀ àwọn ìránṣẹ́ Ọlọ́run baba rẹ jì wọ́n.” Nígbà tí iṣẹ́ ti wọ́n rán dé ọ̀dọ̀ rẹ̀, Josẹfu sọkún. ");
INSERT INTO yor_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Àwọn arákùnrin rẹ̀ wá, wọ́n sì wólẹ̀ níwájú rẹ̀, wọ́n wí pé, “Ẹrú rẹ ni a jẹ́.” ");
INSERT INTO yor_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ṣùgbọ́n Josẹfu wí fún wọn pé, “Ẹ má ṣe bẹ̀rù, èmi ha wà ní ipò Ọlọ́run bí? ");
INSERT INTO yor_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Bí ó tilẹ̀ jẹ́ pé ẹ gbèrò láti ṣe mi ní ibi, ṣùgbọ́n Ọlọ́run gbèrò láti fi ṣe rere tí ń ṣe lọ́wọ́ yìí; ni gbígba ẹ̀mí ọ̀pọ̀lọpọ̀ ènìyàn là. ");
INSERT INTO yor_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Nítorí náà, ẹ má ṣe bẹ̀rù. Èmi yóò pèsè fún ẹ̀yin àti àwọn ọmọ yín.” Ó tún fi wọ́n lọ́kàn balẹ̀, ó sì sọ ọ̀rọ̀ rere fun wọn. ");
INSERT INTO yor_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josẹfu sì ń gbé ní Ejibiti pẹ̀lú gbogbo ìdílé baba rẹ̀. Ó sì wà láààyè fún àádọ́fà ọdún. ");
INSERT INTO yor_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ó sì rí ìran kẹta ọmọ Efraimu-Àwọn ọmọ Makiri, ọmọkùnrin Manase ni a sì gbé le eékún Josẹfu nígbà tí ó bí wọn. ");
INSERT INTO yor_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Nígbà náà ni Josẹfu wí fún àwọn arákùnrin rẹ̀ pé, “Mo ti fẹ́rẹ kú, ṣùgbọ́n dájúdájú Ọlọ́run yóò wá sí ìrànlọ́wọ́ yín, yóò sì mú un yín jáde kúrò ní ilẹ̀ yìí lọ sí ilẹ̀ tí ó ti ṣèlérí ní ìbúra fún Abrahamu, Isaaki àti Jakọbu.” ");
INSERT INTO yor_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Josẹfu sì mú kí àwọn ọmọ Israẹli búra májẹ̀mú kan wí pé, “Dájúdájú Ọlọ́run yóò wá sí ìrànlọ́wọ́ yín, nígbà náà ni ẹ gbọdọ̀ kó egungun mi lọ́wọ́ kúrò ní ìhín.” ");
INSERT INTO yor_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Báyìí ni Josẹfu kú nígbà tí ó pé àádọ́fà ọdún. Lẹ́yìn ìgbà tí wọ́n ṣe òkú rẹ̀ lọ́jọ̀ tan, a gbé e sí inú pósí ní Ejibiti.");
INSERT INTO yor_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1"," Ìwọ̀nyí ni àwọn orúkọ ọmọ Israẹli tí wọ́n bá Jakọbu lọ sí Ejibiti, ẹnìkọ̀ọ̀kan pẹ̀lú ìdílé rẹ̀: ");
INSERT INTO yor_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reubeni, Simeoni, Lefi àti Juda; ");
INSERT INTO yor_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakari, Sebuluni àti Benjamini; ");
INSERT INTO yor_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani àti Naftali; Gadi àti Aṣeri. ");
INSERT INTO yor_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Àwọn ìran Jakọbu sì jẹ́ àádọ́rin ní àpapọ̀; Josẹfu sì ti wà ní Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Wàyí o, Josẹfu àti gbogbo àwọn arákùnrin rẹ̀ àti gbogbo ìran náà kú, ");
INSERT INTO yor_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ṣùgbọ́n àwọn ará Israẹli ń bí sí i, wọ́n ń pọ̀ sí i gidigidi, wọ́n kò sì ní òǹkà tí ó fi jẹ́ pé wọ́n kún ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Nígbà náà ni ọba tuntun mìíràn tí kò mọ Josẹfu jẹ ní ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ó sọ fún àwọn ènìyàn rẹ̀, “Ẹ wò ó, àwọn ará Israẹli ti pọ̀ ní iye àti agbára jù fún wa. ");
INSERT INTO yor_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ẹ wá, ẹ jẹ́ kí a lo ọgbọ́n àlùmọ̀kọ́rọ́yí láti dá wọn lẹ́kun, bí kò ṣe bẹ́ẹ̀ wọn yóò túbọ̀ máa pọ̀ sí i. Bí ogun bá sì bẹ́ sílẹ̀, wọn yóò darapọ̀ mọ́ àwọn ọ̀tá wa, wọn yóò sì da ojú ìjà kọ wá, wọn yóò sì sá àsálà kúrò ní ilẹ̀ yìí.” ");
INSERT INTO yor_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nítorí náà, wọ́n yan àwọn ọ̀gá akóniṣiṣẹ́ lé wọn lórí láti máa ni wọ́n lára pẹ̀lú iṣẹ́ àṣekára. Wọ́n sì kọ́ Pitomi àti Ramesesi gẹ́gẹ́ bí ìlú ìṣúra pamọ́ sí fún Farao. ");
INSERT INTO yor_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ṣùgbọ́n bí a ti ń ni wọ́n lára tó, bẹ́ẹ̀ ni wọ́n ń pọ̀ sí i, tí wọ́n sì ń tànkálẹ̀. Nítorí náà, àwọn ará Ejibiti bẹ̀rù nítorí àwọn ará Israẹli. ");
INSERT INTO yor_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Àwọn ará Ejibiti sì mú àwọn ọmọ Israẹli sìn ní àsìnpa. ");
INSERT INTO yor_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wọ́n mú wọn gbé ìgbé ayé kíkorò nípa iṣẹ́ bíríkì àti àwọn onírúurú iṣẹ́ oko; àwọn ará Ejibiti ń lò wọ́n ní ìlòkulò. ");
INSERT INTO yor_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ọba Ejibiti sọ fún àwọn agbẹ̀bí Heberu ti orúkọ wọn ń jẹ́ Ṣifura àti Pua pé, ");
INSERT INTO yor_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Nígbà ti ẹ̀yin bá ń gbẹ̀bí àwọn obìnrin Heberu, tí ẹ sì kíyèsi wọn lórí ìkúnlẹ̀ ìrọbí wọn, bí ó bá jẹ́ ọkùnrin ni ọmọ náà, ẹ pa á; ṣùgbọ́n bí ó bá jẹ́ obìnrin, ẹ jẹ́ kí ó wà láààyè.” ");
INSERT INTO yor_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ṣùgbọ́n àwọn agbẹ̀bí bẹ̀rù Ọlọ́run, wọn kò sì ṣe gẹ́gẹ́ bí ọba Ejibiti ti wí fún wọn; wọ́n jẹ́ kí àwọn ọmọkùnrin wà láààyè. ");
INSERT INTO yor_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ọba Ejibiti pe àwọn agbẹ̀bí ó sì béèrè lọ́wọ́ wọn pé, “Èéṣe tí ẹ̀yin fi ṣe èyí? Èéṣe tí ẹ̀yin fi dá àwọn ọmọkùnrin si?” ");
INSERT INTO yor_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Àwọn agbẹ̀bí náà sì dá Farao lóhùn pé, “Àwọn obìnrin Heberu kò rí bí àwọn obìnrin Ejibiti, wọ́n ní agbára, wọ́n sì ti máa ń bí ọmọ kí àwọn agbẹ̀bí tó dé ọ̀dọ̀ wọn.” ");
INSERT INTO yor_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nítorí náà Ọlọ́run ṣàánú fún àwọn agbẹ̀bí náà, àwọn ọmọ Israẹli sì ń le sí i, wọ́n sì ń pọ̀ sí i jọjọ. ");
INSERT INTO yor_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Nítorí pé àwọn agbẹ̀bí bẹ̀rù Ọlọ́run, Ọlọ́run sì fún wọn ni ìdílé tiwọn. ");
INSERT INTO yor_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Nígbà náà ni Farao pàṣẹ yìí fún gbogbo àwọn ènìyàn rẹ̀ pé, “Gbogbo ọmọkùnrin tí a bí ni kí ẹ gbé jù sínú odò Naili, ṣùgbọ́n gbogbo àwọn ọmọbìnrin ni kí ẹ jẹ́ kí wọn ó wà láààyè.” ");
INSERT INTO yor_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ó sì ṣe, ọkùnrin ará ilé Lefi kan fẹ́ ọmọbìnrin ará Lefi kan ni ìyàwó. ");
INSERT INTO yor_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Obìnrin náà sì lóyún, ó sì bí ọmọkùnrin kan. Nígbà tí ó rí í pé ọmọ náà rẹwà, ó gbé ọmọ náà pamọ́ fún oṣù mẹ́ta. ");
INSERT INTO yor_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ṣùgbọ́n nígbà tí kò le è gbé e pamọ́ mọ́, ó fi ewé papirusi hun apẹ̀rẹ̀, ó sì fi ọ̀dà àti òjé igi sán apẹ̀rẹ̀ náà. Ó sì tẹ́ ọmọ náà sínú rẹ̀, ó sì gbe é sí inú eèsún ni etí odò Naili. ");
INSERT INTO yor_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Arábìnrin rẹ̀ dúró ni òkèèrè láti wo ohun tí yóò ṣẹlẹ̀ sí ọmọ náà. ");
INSERT INTO yor_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Nígbà náà ni ọmọbìnrin Farao sọ̀kalẹ̀ wá sí etí odò Naili láti wẹ̀, àwọn ọmọ ọ̀dọ̀ rẹ̀ sì ń rìn ni etí bèbè odò. Ó sì ri apẹ̀rẹ̀ náà ni àárín eèsún, ó sì rán ọmọ ọ̀dọ̀ rẹ̀ obìnrin kan láti lọ gbé e wá, ");
INSERT INTO yor_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ó ṣí i, ó sì rí ọmọ náà. Ọmọ náà ń sọkún, àánú ọmọ náà sì ṣe é. Ó wí pé, “Ọ̀kan nínú àwọn ọmọ Heberu ni èyí.” ");
INSERT INTO yor_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Nígbà náà ni arábìnrin rẹ̀ béèrè lọ́wọ́ ọmọbìnrin Farao pé, “Ṣé kí èmi lọ wá ọ̀kan lára àwọn obìnrin Heberu wá fún ọ láti bá ọ tọ́jú ọmọ náà?” ");
INSERT INTO yor_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ó sì dáhùn pé, “Bẹ́ẹ̀ ni; lọ.” Arábìnrin náà sì lọ, ó sì pe ìyá ọmọ náà wá. ");
INSERT INTO yor_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ọmọbìnrin Farao sì wí fún un pé, “Gba ọmọ yìí kí o sì tọ́jú rẹ̀ fún mi, èmi yóò san owó iṣẹ́ ẹ̀ rẹ fún ọ.” Ọmọbìnrin náà sì gbé ọmọ náà lọ, ó sì tọ́jú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nígbà tí ọmọ náà sì dàgbà, ó mú un tọ ọmọbìnrin Farao wá, ó sì di ọmọ rẹ̀. Ó sì pe orúkọ rẹ̀ ní Mose, ó wí pé, “Nítorí tí mo fà á jáde nínú omi.” ");
INSERT INTO yor_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ní ọjọ́ kan, nígbà tí Mose ti dàgbà, ó jáde lọ sí ibi ti àwọn ènìyàn rẹ̀ wà, ó ń wò wọ́n lẹ́nu iṣẹ́ líle wọn, ó ri ará Ejibiti tí ń lu ará Heberu, ọ̀kan nínú àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ó wo ìhín, ó wo ọ̀hún, nígbà tí kò rí ẹnìkankan, ni ó bá pa ará Ejibiti náà, ó sì bò ó mọ́ inú iyanrìn. ");
INSERT INTO yor_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ní ọjọ́ kejì, ó jáde lọ, ó rí àwọn ará Heberu méjì tí wọ́n ń jà. Ó béèrè lọ́wọ́ èyí tí ó jẹ̀bi pé, “Èéṣe tí ìwọ fi ń lu Heberu arákùnrin rẹ?” ");
INSERT INTO yor_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ọkùnrin náà sì dáhùn pé, “Ta ni ó fi ọ́ jẹ olórí àti onídàájọ́ lórí wa? Ṣé ìwọ fẹ́ pa mí bí o ti pa ará Ejibiti?” Nígbà náà ni ẹ̀rù ba Mose, ó sì wí pé, “Lóòótọ́ ni ọ̀ràn yìí ti di mí mọ̀.” ");
INSERT INTO yor_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Nígbà ti Farao sì gbọ́ nípa èyí, ó wá ọ̀nà láti pa Mose, ṣùgbọ́n Mose sá kúrò ní àrọ́wọ́tó o Farao, ó lọ sí Midiani láti máa gbé, nígbà tí ó dé bẹ̀, ó jókòó ni ẹ̀bá a kànga kan. ");
INSERT INTO yor_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ó sì ṣe, àlùfáà Midiani kan ni àwọn ọmọbìnrin méje, wọn sì wá láti pọn omi kún ọpọ́n ìmumi fún ẹran ọ̀sìn baba wọn. ");
INSERT INTO yor_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Àwọn darandaran kan wá, wọ́n sì lé wọn sẹ́yìn, ṣùgbọ́n Mose dìde láti gbà wọ́n sílẹ̀ àti láti ràn wọ́n lọ́wọ́ láti fún ẹran wọn ní omi. ");
INSERT INTO yor_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Nígbà ti àwọn ọmọbìnrin náà padà dé ọ̀dọ̀ Reueli baba wọn, ó béèrè lọ́wọ́ wọn pé, “Èéṣe tí ẹ̀yin fi tètè dé ni òní?” ");
INSERT INTO yor_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Wọ́n dá a lóhùn pé, “Ará Ejibiti kan ni ó gbà wá sílẹ̀ lọ́wọ́ àwọn darandaran, ó tilẹ̀ ràn wá lọ́wọ́ láti fa omi àti láti fún agbo ẹran ní omi.” ");
INSERT INTO yor_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ó sọ fún àwọn ọmọbìnrin rẹ̀, “Níbo ni ó wà? Èéṣe ti ẹ fi fi ọkùnrin náà sílẹ̀? Ẹ pè é wá jẹun.” ");
INSERT INTO yor_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mose gbà láti dúró lọ́dọ̀ ọkùnrin náà, ẹni tí o fi Sippora, ọmọbìnrin rẹ̀ fún Mose láti fi ṣe aya. ");
INSERT INTO yor_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ó sì bí ọmọkùnrin kan tí ó pe orúkọ rẹ̀ ní Gerṣomu, ó wí pé, “Èmi ń ṣe àtìpó ní ilẹ̀ àjèjì.” ");
INSERT INTO yor_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Lẹ́yìn ìgbà pípẹ́, ọba Ejibiti kú. Àwọn ará Israẹli ń kérora ní oko ẹrú wọn, wọ́n ń ké fún ìrànlọ́wọ́ nítorí oko ẹrú tí wọ́n wà, igbe wọ́n sì dé ọ̀dọ̀ Ọlọ́run. ");
INSERT INTO yor_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ọlọ́run gbọ́ igbe wọn, Ó sì rántí májẹ̀mú rẹ̀ pẹ̀lú Abrahamu, Isaaki àti pẹ̀lú Jakọbu. ");
INSERT INTO yor_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nítorí náà, Ọlọ́run bojú wo àwọn ará Israẹli, Ó sì wà láti gbà wọ́n sílẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ní ọjọ́ kan nígbà tí Mose ń ṣọ́ agbo ẹran Jetro baba ìyàwó rẹ̀, àlùfáà Midiani. Ó da agbo ẹran náà lọ sí ọ̀nà jíjìn nínú aginjù. Ó dé Horebu, òkè Ọlọ́run. ");
INSERT INTO yor_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Níbẹ̀ ni angẹli Olúwa ti yọ sí i nínú ọ̀wọ́-iná tí ń jó láàrín igbó. Mose rí i pé iná ń jó nínú igbó ṣùgbọ́n igbó kò run. ");
INSERT INTO yor_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Nígbà náà ni Mose sọ pé, “Èmi yóò lọ wo ohun ìyanu yìí, ìdí tí iná kò fi jó igbó run.” ");
INSERT INTO yor_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Nígbà tí Olúwa rí i pe Mose ti lọ láti lọ wò ó, Ọlọ́run ké pè é láti àárín igbó náà, “Mose! Mose!” Mose sì dáhùn ó wí pé, “Èmi nìyìí.” ");
INSERT INTO yor_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Olúwa sì wí fún Mose pé, “Má ṣe súnmọ́ ìhín yìí, bọ́ sálúbàtà rẹ kúrò ní ẹsẹ̀ rẹ, nítorí ibi tí ìwọ dúró sí i nì ilẹ̀ mímọ́ ni.” ");
INSERT INTO yor_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Nígbà náà ní ó wí pé, “Èmi ni Ọlọ́run baba rẹ, Ọlọ́run Abrahamu, Ọlọ́run Isaaki àti Ọlọ́run Jakọbu.” Nítorí ìdí èyí, Mose sì pa ojú rẹ̀ mọ́, nítorí ó bẹ̀rù láti bojú wo Ọlọ́run. ");
INSERT INTO yor_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Olúwa si wí pé, “Èmí ti rí ìpọ́njú àwọn ènìyàn mi ní ilẹ̀ Ejibiti, mo sì ti gbọ́ ohùn igbe wọn nítorí àwọn akóniṣiṣẹ́ wọn. Ìyà tí ń jẹ wọ́n sì kan mi lára. ");
INSERT INTO yor_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Èmi sì ti sọ̀kalẹ̀ wá láti gbà wọ́n lọ́wọ́ àwọn ará Ejibiti, àti láti mú wọn gòkè kúrò ní ilẹ̀ náà lọ sí ilẹ̀ tí ó dára tí ó sì ní ààyè, àní ilẹ̀ tí ó ń sàn fún wàrà àti oyin; ibùgbé àwọn ará Kenaani, ará Hiti, Amori, Peresi, Hifi àti Jebusi. ");
INSERT INTO yor_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ǹjẹ́ nísinsin yìí, wò ó, igbe àwọn ará Israẹli ti dé ọ̀dọ̀ mi, Èmi sì ti rí bí àwọn ará Ejibiti ti ṣe ń gbà ń jẹ wọ́n ní ìyà. ");
INSERT INTO yor_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ǹjẹ́ nísinsin yìí, lọ, èmi yóò rán ọ sí Farao láti kó àwọn ènìyàn Israẹli jáde kúrò ní ilẹ̀ Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ṣùgbọ́n Mose wí fún Ọlọ́run pé, “Ta ni èmi, tí èmi yóò tọ Farao lọ, ti èmi yóò sì kó àwọn ará Israẹli jáde kúrò ni ilẹ̀ Ejibiti?” ");
INSERT INTO yor_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nígbà náà ni Ọlọ́run wí fún Mose pé, “Èmi yóò wà pẹ̀lú rẹ. Èyí ni yóò jẹ́ àmì fún ọ, tí yóò fihàn pé, èmi ni ó rán ọ lọ, nígbà tí ìwọ bá kó àwọn ènìyàn náà jáde kúrò ní ilẹ̀ Ejibiti, ẹ̀yin yóò sin Ọlọ́run ni orí òkè yìí.” ");
INSERT INTO yor_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mose sì wí fún Ọlọ́run pé, “Bí mo bá tọ àwọn ará Israẹli lọ tí mo sì sọ fún wọn pé, ‘Ọlọ́run àwọn baba yín ni ó rán mi sí i yín,’ tí wọ́n sì béèrè lọ́wọ́ mi pé, ‘Kí ni orúkọ rẹ̀?’ Kí ni èmi yóò sọ fún wọn ní ìgbà náà?” ");
INSERT INTO yor_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ọlọ́run sì sọ fún Mose pé, “èmi ni ti ń jẹ́ èmi ni. Èyí ni ìwọ yóò sọ fún àwọn ará Israẹli: ‘èmi ni ni ó rán mi sí i yín.’ ” ");
INSERT INTO yor_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ọlọ́run sì wí fún Mose pẹ̀lú pé, “Báyìí ni kí ìwọ sọ fún àwọn ọmọ Israẹli, ‘Olúwa Ọlọ́run àwọn baba yín; Ọlọ́run Abrahamu, Ọlọ́run Isaaki àti Ọlọ́run Jakọbu; ni ó rán mi sí i yín.’ “Èyí ni orúkọ mi títí ayérayé, orúkọ ti ẹ ó fi máa rántí mi láti ìran dé ìran. ");
INSERT INTO yor_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Lọ, kó àwọn àgbàgbà Israẹli jọ, kí o sì wí fún wọn pé, ‘Olúwa Ọlọ́run àwọn baba yín, Ọlọ́run Abrahamu, ti Isaaki, àti ti Jakọbu; ni ó farahàn mi, ó sì wí pé, lóòótọ́ èmi ti ń bojú wò yín, èmi sì ti rí ohun tí wọ́n ṣe sí i yín ni ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Èmi sì ti ṣe ìlérí láti mú un yín jáde kúrò nínú ìpọ́njú yín ni ilẹ̀ Ejibiti wá sí ilẹ̀ Kenaani, ará Hiti, Amori, Peresi, Hifi àti Jebusi; ilẹ̀ tí ó ń sàn fún wàrà àti oyin.’ ");
INSERT INTO yor_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Àwọn àgbàgbà Israẹli yóò fetísílẹ̀ sí ohùn rẹ. Nígbà náà ni ìwọ, àti àwọn àgbàgbà yóò jọ tọ ọba Ejibiti lọ, ẹ ó sì wí fún un pé, ‘Olúwa, Ọlọ́run àwọn ará Heberu ti pàdé wa. Jẹ́ kí a lọ ni ìrìn ọjọ́ mẹ́ta sí inú aginjù láti lọ rú ẹbọ sí Olúwa Ọlọ́run.’ ");
INSERT INTO yor_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ṣùgbọ́n èmi mọ̀ pé ọba Ejibiti kò ní jẹ́ kí ẹ lọ bí kò ṣe pé ọwọ́ ńlá Ọlọ́run wà ni ara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Nítorí náà, èmi yóò na ọwọ́ mí láti lu àwọn ará Ejibiti pẹ̀lú gbogbo ohun ìyanu tí èmi yóò ṣe ni àárín wọn. Lẹ́yìn náà, òun yóò jẹ́ kí ẹ máa lọ. ");
INSERT INTO yor_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Èmi yóò sì jẹ́ kí ẹ bá ojúrere àwọn ará Ejibiti pàdé. Tí yóò fi jẹ́ pé ti ẹ̀yin bá ń lọ, ẹ kò ní lọ ní ọwọ́ òfo. ");
INSERT INTO yor_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Gbogbo àwọn obìnrin ni ó ní láti béèrè lọ́wọ́ àwọn aládùúgbò wọn àti gbogbo àwọn obìnrin ti ń gbé nínú ilé rẹ fún ohun fàdákà àti wúrà àti fún aṣọ, èyí ti ẹ̀yin yóò wọ̀ sí ọrùn àwọn ọmọ yín ọkùnrin àti obìnrin. Báyìí ni ẹ̀yin yóò sì kó ẹrù àwọn ará Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mose dáhùn ó sì wí pé, “Ṣùgbọ́n bí wọn kò bá gbà mí gbọ́ ń kọ́? Tàbí tí wọn kò fi etí sílẹ̀ láti gbọ́ ọ̀rọ̀ ẹnu mi, tí wọn sì wí pé, ‘Olúwa kò farahàn ọ́’?” ");
INSERT INTO yor_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ní ìgbà náà ni Olúwa sọ fún un pé, “Kí ni ó wà ní ọwọ́ rẹ n nì?” Ó sì dáhùn pé, “Ọ̀pá ni.” ");
INSERT INTO yor_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Olúwa sì sọ pé, “Sọ ọ̀pá náà sílẹ̀.” Mose sì sọ ọ̀pá náà sílẹ̀, lọ́gán ni ọ̀pá náà di ejò, ó sì sá fún un. ");
INSERT INTO yor_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Nígbà náà ni Olúwa wá sọ fún un pé, “Na ọwọ́ rẹ, kí o sì mú un ni ìrù.” Mose sì na ọwọ́ rẹ̀, ó sì mu ejò náà, ejò náà sì padà di ọ̀pá tí ó wà ni ọwọ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Olúwa sì wí pé, “Èyí rí bẹ́ẹ̀ kí wọn bá à le è gbàgbọ́ pé, Olúwa Ọlọ́run àwọn baba wọn, Ọlọ́run Abrahamu, Ọlọ́run Isaaki, àti Ọlọ́run Jakọbu; tí farahàn ọ́.” ");
INSERT INTO yor_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ní ìgbà náà ni Olúwa wí pé, “Ti ọwọ́ rẹ bọ inú aṣọ ní igbá àyà rẹ̀.” Mose sì ti ọwọ́ rẹ̀ bọ inú aṣọ ní igbá àyà rẹ̀, ní ìgbà ti ó sì yọ ọ́ jáde, ọwọ́ rẹ̀ ti dẹ́tẹ̀, ó sì ti funfun bí ẹ̀gbọ̀n òwú. ");
INSERT INTO yor_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ó sì wí pé, “Nísinsin yìí, fi ọwọ́ náà padà sí abẹ́ aṣọ ní igbá àyà rẹ.” Mose sì ṣe bẹ́ẹ̀, ọwọ́ rẹ̀ sì padà bọ́ sípò bí àwọn ẹ̀yà ara rẹ̀ tókù. ");
INSERT INTO yor_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ní ìgbà náà ni Olúwa wí pé, “Bí wọn kò bá gbà ọ́ gbọ́ tàbí kọ ibi ara sí iṣẹ́ ìyanu àkọ́kọ́, wọ́n le è ti ipasẹ̀ iṣẹ́ ìyanu kejì gbàgbọ́. ");
INSERT INTO yor_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ṣùgbọ́n bí wọn kò bá gba àmì méjèèjì wọ̀nyí gbọ́, tí wọn kò sì fetí sí ọ̀rọ̀ rẹ, bu omi díẹ̀ láti inú odò Naili kí o si dà á sí orí ìyàngbẹ ilẹ̀, omi tí ìwọ bù láti inú odò yìí yóò sì di ẹ̀jẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mose sì sọ fún Olúwa pé, “Èmi jẹ́ akólòlò, èmi kì í ṣe ẹni tó lè sọ̀rọ̀ já gaara láti ìgbà àtijọ́ wá tàbí láti ìgbà ti o ti ń bá ìránṣẹ́ rẹ sọ̀rọ̀, mo jẹ́ ẹni ti ahọ́n rẹ̀ lọ́, tí ó sì ń lọ́ra àti sọ̀rọ̀.” ");
INSERT INTO yor_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Olúwa sì sọ fún un pé, “Ta ni ó fún ènìyàn ni ẹnu? Ta ni ó mú un ya odi tàbí adití? Ta ni ó mú un ríran, tàbí mú un fọ́jú? Ǹjẹ́ kì í ṣe èmi Olúwa? ");
INSERT INTO yor_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Lọ nísinsin yìí, Èmi yóò ràn ọ́ lọ́wọ́ láti sọ̀rọ̀. Èmi yóò sì kọ́ ọ ni ohun ti ìwọ yóò sọ.” ");
INSERT INTO yor_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mose dáhùn ó wí pé, “Olúwa jọ̀wọ́ rán ẹlòmíràn láti lọ ṣe iṣẹ́ yìí.” ");
INSERT INTO yor_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ìbínú Olúwa ru sókè sí Mose, ó sì sọ pé, “Aaroni ará Lefi arákùnrin rẹ ń kọ́? Mo mọ̀ pé ó lè sọ̀rọ̀ já gaara, ó ti wà ní ọ̀nà rẹ̀ báyìí láti pàdé e rẹ. Inú rẹ̀ yóò sì dùn ti ó bá rí ọ. ");
INSERT INTO yor_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ìwọ yóò sọ̀rọ̀ fún un, ìwọ yóò sì fi ọ̀rọ̀ sí i lẹ́nu, èmi yóò ràn yín lọ́wọ́ láti sọ̀rọ̀. Èmi yóò kọ́ ọ yín ni ohun ti ẹ ó ṣe. ");
INSERT INTO yor_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Òun yóò bá ọ sọ̀rọ̀ sí àwọn ènìyàn, yóò sì dàbí i pé ẹnu un rẹ ni a gbà sọ ọ̀rọ̀ náà, ìwọ yóò sì dàbí Ọlọ́run ní iwájú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ṣùgbọ́n mú ọ̀pá yìí ni ọwọ́ rẹ kí ìwọ bá à lè fi ṣe àwọn iṣẹ́ àmì ìyanu pẹ̀lú rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mose padà sí ọ̀dọ̀ Jetro baba ìyàwó rẹ̀, ó sì sọ fún un pé, “Jọ̀wọ́ jẹ́ kí n padà tọ àwọn ènìyàn mi lọ ni ilẹ̀ Ejibiti láti wò bóyá wọ́n ṣì wà láààyè síbẹ̀.” Jetro sì dáhùn, ó wí pé, “Máa lọ ni àlàáfíà.” ");
INSERT INTO yor_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Nísinsin yìí, Olúwa ti sọ fún Mose ni ilẹ̀ Midiani pé, “Máa padà lọ sí Ejibiti, nítorí àwọn ti ó fẹ́ pa ọ ti kú.” ");
INSERT INTO yor_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mose mú ìyàwó rẹ̀ àti àwọn ọmọ rẹ̀, ó kó wọn lé orí kẹ́tẹ́kẹ́tẹ́, ó sì bẹ̀rẹ̀ ìrìnàjò rẹ̀ padà sí Ejibiti. Ó sì mú ọ̀pá Ọlọ́run sí ọwọ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Olúwa sì sọ fún Mose pé, “Ní ìgbà tí ìwọ bá padà sí Ejibiti rí i pé ìwọ ṣe iṣẹ́ ìyanu ni iwájú Farao. Èmi ti fún ọ lágbára láti ṣe é. Èmi yóò sì sé àyà rẹ̀ le, òun kì yóò jẹ́ kí àwọn ènìyàn náà kí ó lọ. ");
INSERT INTO yor_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Lẹ́yìn náà, kí o sọ fún Farao pé, ‘Èyí ni Olúwa sọ: Israẹli ní àkọ́bí ọmọ mi ọkùnrin, ");
INSERT INTO yor_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","mo sọ fún ọ, “Jẹ́ kí ọmọ mi lọ, ki òun kí ó lè máa sìn mí.” Ṣùgbọ́n ìwọ kọ̀ láti jẹ́ kí ó lọ; nítorí náà, èmi yóò pa àkọ́bí ọmọ rẹ ọkùnrin.’ ” ");
INSERT INTO yor_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ní ọ̀nà ìrìnàjò rẹ, ni ibi tí wọ́n gbé sùn ní ilé èrò ní alẹ́, Olúwa pàdé Mose, ó sì fẹ́ láti pa á. ");
INSERT INTO yor_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ṣùgbọ́n Sippora mú ọ̀bẹ òkúta mímú, ó sì kọ ọmọ rẹ̀ ní ilà abẹ́, ó sì fi awọ rẹ̀ kan ẹsẹ̀ Mose. Sippora sì wí pé, “Ọkọ ẹlẹ́jẹ̀ ni ìwọ jẹ́ sí mi.” ");
INSERT INTO yor_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Nítorí náà Olúwa yọ̀ǹda rẹ láti ìgbà tí ó ti wí pé, “Ẹlẹ́jẹ̀ ni ìwọ í ṣe.” Èyí tó túmọ̀ sí ìkọlà abẹ́. ");
INSERT INTO yor_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Olúwa sì sọ fún Aaroni pé, “Lọ sínú aginjù láti lọ pàdé Mose.” Ní ìgbà náà ni ó lọ pàdé Mose ní orí òkè Ọlọ́run, ó sì fi ẹnu kò ó ní ẹnu. ");
INSERT INTO yor_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ní ìgbà náà ni Mose sì sọ ohun gbogbo tí Ọlọ́run ti rán fún Aaroni àti nípa gbogbo iṣẹ́ ìyanu tí Olúwa ti pàṣẹ fún un láti ṣe ní iwájú Farao. ");
INSERT INTO yor_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mose àti Aaroni pe gbogbo àwọn àgbàgbà Israẹli jọ. ");
INSERT INTO yor_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaroni sọ ohun gbogbo tí Olúwa sọ fún Mose fún wọn, ó sì ṣe iṣẹ́ àmì náà ní ojú àwọn ènìyàn náà. ");
INSERT INTO yor_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Wọ́n sì gbàgbọ́. Nígbà tí wọ́n gbọ́ pé Olúwa ti bẹ àwọn ọmọ Israẹli wò àti pé Olúwa ti gbọ́ nípa ìpọ́njú wọn, wọ́n tẹríba, wọ́n sì sìn ín. Ó sì ṣe àwọn iṣẹ́ àmì náà níwájú àwọn ènìyàn náà. ");
INSERT INTO yor_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Lẹ́yìn náà ni Mose àti Aaroni tọ Farao lọ, wọ́n sì wí pé, “Èyí ni ohun tí Olúwa, Ọlọ́run Israẹli sọ, ‘Jẹ́ kí àwọn ènìyàn mi kí ó lọ, kí wọn kí ó lè ṣe àjọ mi ní ijù.’ ” ");
INSERT INTO yor_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farao dáhùn wí pé, “Ta ni Olúwa, tí èmi yóò fi gbọ́rọ̀ sí i lẹ́nu, tí èmi yóò fi jẹ́ kí Israẹli ó lọ? Èmi kò mọ Olúwa, èmi kò sì ní jẹ́ kí Israẹli ó lọ.” ");
INSERT INTO yor_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Lẹ́yìn náà ni wọ́n wí pé, “Ọlọ́run àwọn Heberu tí pàdé wa. Ní ìsinsin yìí, jẹ́ kí a lọ ní ìrìn ọjọ́ mẹ́ta sínú aginjù láti rú ẹbọ sí Olúwa Ọlọ́run wa, kí Ó má ba á fi àjàkálẹ̀-ààrùn tàbí idà bá wa jà.” ");
INSERT INTO yor_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ṣùgbọ́n ọba Ejibiti sọ wí pé, “Mose àti Aaroni, èéṣe ti ẹ̀yin fi mú àwọn ènìyàn kúrò lẹ́nu iṣẹ́ wọn? Ẹ padà sẹ́nu iṣẹ́ yín.” ");
INSERT INTO yor_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Nígbà náà ni Farao sọ pé, “Ẹ wò ó àwọn ènìyàn náà ti pọ̀ sí ì nílẹ̀ yìí ní ìsinsin yìí, ẹ̀yin sì ń dá wọn dúró láti máa bá iṣẹ́ lọ.” ");
INSERT INTO yor_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ní ọjọ́ yìí kan náà ni Farao pàṣẹ fún àwọn akóniṣiṣẹ́ àti àwọn ti ń ṣe alábojútó iṣẹ́ lórí àwọn ènìyàn. ");
INSERT INTO yor_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Ẹ̀yin kò ní láti pèsè koríko gbígbẹ fún bíríkì sísun mọ́ fún àwọn ènìyàn wọ̀nyí; ẹ jẹ́ kí wọn máa wá koríko gbígbẹ fún ara wọn. ");
INSERT INTO yor_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ṣùgbọ́n ẹ jẹ́ kí wọn ó ṣe iye bíríkì kan náà bí ì ti àtẹ̀yìnwá, kí ẹ má ṣe dín iye rẹ̀ kú. Ọ̀lẹ ni wọ́n, ìwà ọ̀lẹ yìí náà ló mú wọn pariwo pé, ‘Ẹ jẹ́ kí a lọ, kí a sì rú ẹbọ sí Ọlọ́run wa.’ ");
INSERT INTO yor_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ẹ mú iṣẹ́ náà le fún wọn, kí wọn bá a le è tẹramọ́ iṣẹ́ wọn, ẹ má fi ààyè gba irọ́ wọn.” ");
INSERT INTO yor_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ní ìgbà náà ni àwọn akóniṣiṣẹ́ àti àwọn tí ń ṣe alábojútó iṣẹ́ jáde tọ̀ wọ́n lọ láti sọ fún àwọn ènìyàn náà pé, “Èyí ni ohun tí Farao sọ, ‘Èmi kò ní fún un yín ni koríko gbígbẹ mọ́. ");
INSERT INTO yor_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ẹ lọ wá koríko gbígbẹ ni ibi tí ẹ bá ti lè rí i, ṣùgbọ́n iṣẹ́ yín kí yóò dínkù.’ ” ");
INSERT INTO yor_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Gbogbo wọn sí fọ́n káàkiri ni ilẹ̀ Ejibiti láti sa ìdì koríko tí wọn yóò lò bí ì koríko gbígbẹ fún sísun bíríkì. ");
INSERT INTO yor_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Àwọn akóniṣiṣẹ́ sì ń ni wọ́n lára, wọ́n wí pé, “Ẹ parí iṣẹ́ tí ẹ ni láti ṣe fún ọjọ́ kan bí ìgbà ti a ń fún un yin ní koríko gbígbẹ.” ");
INSERT INTO yor_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Àwọn alábojútó iṣẹ́ tí àwọn akóniṣiṣẹ́ Farao yàn lára ọmọ Israẹli ni wọn ń lù, tí wọn sì ń béèrè lọ́wọ́ wọn pé, “Èéṣe tí ẹ̀yin kò ṣe iye bíríkì ti ẹ̀yin ń ṣe ní àná ní òní bí i tí àtẹ̀yìnwá?” ");
INSERT INTO yor_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Nígbà náà ni àwọn alábojútó iṣẹ́ tí a yàn lára àwọn ọmọ Israẹli tọ Farao lọ láti lọ bẹ̀bẹ̀ pé, “Èéṣe tí ìwọ fi ọwọ́ líle mú àwa ọmọ ọ̀dọ̀ rẹ̀ báyìí? ");
INSERT INTO yor_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Wọn kò fún àwọn ọmọ ọ̀dọ̀ rẹ̀ ni koríko gbígbẹ, síbẹ̀ wọn sọ fún wa pé, ‘Ẹ ṣe bíríkì!’ Wọ́n na àwọn ọmọ ọ̀dọ̀ rẹ, ṣùgbọ́n ẹ̀bi náà wá láti ọ̀dọ̀ àwọn ènìyàn rẹ.” ");
INSERT INTO yor_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Farao sí dáhùn wí pé, “Ọ̀lẹ ni yín, ọ̀lẹ! Èyí ni ó mú kí ẹ̀yin máa sọ ní ìgbà gbogbo pé, ‘Ẹ jẹ́ kí a lọ, kí a sì rú ẹbọ sí Olúwa.’ ");
INSERT INTO yor_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Nísinsin yìí ẹ padà lọ sí ẹnu iṣẹ́ yín, a kò ní fún un yín ni koríko gbígbẹ, síbẹ̀ ẹ gbọdọ̀ ṣe iye bíríkì tí ó yẹ kí ẹ ṣe.” ");
INSERT INTO yor_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Àwọn ọmọ Israẹli tí ó jẹ́ alábojútó iṣẹ́ mọ̀ dájú wí pé àwọn ti wà nínú wàhálà ńlá ní ìgbà tí a sọ fún wọn pé, “Ẹ kò ní láti dín iye bíríkì tí ẹ ń ṣe ni ojoojúmọ́ kù.” ");
INSERT INTO yor_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ní ìgbà tí wọ́n kúrò ni ọ̀dọ̀ Farao wọ́n rí Mose àti Aaroni tí ó dúró láti pàdé wọn. ");
INSERT INTO yor_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Wọn sì wí pé, “Kí Olúwa kí ó wò yín, kí ó sì ṣe ìdájọ́! Ẹ̀yin ti mú wa dàbí òórùn búburú fún Farao àti àwọn òṣìṣẹ́ rẹ̀, ẹ sì ti fún wọn ni idà láti fi pa wá.” ");
INSERT INTO yor_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mose padà tọ Olúwa lọ, ó sì wí pé, “Olúwa, èéṣe tí ìwọ fi mú ìyọnu wá sí orí àwọn ènìyàn wọ̀nyí? Ṣe torí èyí ni ìwọ fi rán mi? ");
INSERT INTO yor_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Láti ìgbà ti mo ti tọ Farao lọ láti bá a sọ̀rọ̀ ni orúkọ rẹ ni ó ti mú ìyọnu wá sí orí àwọn ènìyàn wọ̀nyí, bẹ́ẹ̀ ni ìwọ kò sì gba àwọn ènìyàn rẹ sílẹ̀ rárá.” ");
INSERT INTO yor_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Nígbà náà ní Olúwa sọ fún Mose pé, “Ní ìsin yìí, ìwọ yóò rí ohun tí èmi yóò ṣe sí Farao pẹ̀lú ọwọ́ agbára ńlá mi ni yóò fi jẹ́ kí wọn lọ; pẹ̀lú ọwọ́ agbára ńlá mi, òun yóò lé wọn jáde kúrò ní orílẹ̀-èdè rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ọlọ́run sì tún sọ fún Mose pé, “Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mo fi ara hàn Abrahamu, Isaaki àti Jakọbu bí Ọlọ́run alágbára, ṣùgbọ́n nípa orúkọ mi Olúwa, Èmi kò fi ara mi hàn wọ́n. ");
INSERT INTO yor_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Èmí sì tún fi ìdí májẹ̀mú mi múlẹ̀ pẹ̀lú wọn láti fún wọn ní ilẹ̀ Kenaani, ilẹ̀ tí wọn gbé gẹ́gẹ́ bí àjèjì. ");
INSERT INTO yor_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Èmi sì ti tún gbọ́ kíkùn àwọn ọmọ Israẹli àwọn tí àwọn ará Ejibiti mú gẹ́gẹ́ bí ẹrú, àti pé èmi sì ti rántí májẹ̀mú mi. ");
INSERT INTO yor_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Sọ fún àwọn ará ilé Israẹli, ‘Èmi ni Olúwa, Èmi yóò sọ yín di òmìnira kúrò nínú àjàgà àwọn ará Ejibiti. Èmi yóò sì gbà yín sílẹ̀ kúrò ní oko ẹrú wọn. Èmi yóò dá a yín sílẹ̀ pẹ̀lú apá nínà (àwọn iṣẹ́ ìyanu) àti pẹ̀lú ìdájọ́ ńlá. ");
INSERT INTO yor_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Èmi yóò mú un yín bí ènìyàn mi, èmi yóò sì jẹ́ Ọlọ́run yín. Nígbà náà ni ẹ̀yin yóò mọ̀ pé, èmi ni Olúwa Ọlọ́run yín, ẹni tí ó mú un yín jáde kúrò nínú àjàgà àwọn ará Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Èmi yóò mú un yín wá ilẹ̀ náà ti èmi ti búra pẹ̀lú ìgbọ́wọ́sókè láti fi fún Abrahamu. Isaaki àti Jakọbu. Èmi yóò fi fún un yín bí ohun ìní, Èmi ni Olúwa.’ ” ");
INSERT INTO yor_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mose sì sọ èyí fún àwọn ará Israẹli, ṣùgbọ́n wọn kò fi etí sílẹ̀ sí Mose nítorí ọkàn wọn tó rẹ̀wẹ̀sì àti nítorí ìgbèkùn búburú bí ohun tí ó ti kọ́ sọ kó wọn sí ní oko ẹrú wọn. ");
INSERT INTO yor_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Nígbà náà ni Olúwa sọ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Lọ, sọ fún Farao ọba Ejibiti pé kí ó jẹ́ kí àwọn ará Israẹli lọ kúrò ní orílẹ̀-èdè rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ṣùgbọ́n Mose sọ fún Olúwa pé, “Nígbà ti àwọn ará Israẹli tó jẹ́ ènìyàn mi kó fetí sí ọ̀rọ̀ mi, báwo ni Farao yóò ṣe fetí sí ọ̀rọ̀ mi, nígbà ti mo jẹ́ akólòlò?” ");
INSERT INTO yor_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Olúwa bá ìran Mose àti Aaroni sọ̀rọ̀ nípa àwọn ará Israẹli àti Farao ọba Ejibiti, ó pàṣẹ fún wọn pé kí wọn kó àwọn Israẹli jáde kúrò ni ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Wọ̀nyí ni olórí ìran wọn: àwọn ọmọ Reubeni àkọ́bí Israẹli ni: Hanoku, Pallu, Hesroni àti Karmi. Àwọn wọ̀nyí ni ìdílé Reubeni. ");
INSERT INTO yor_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Àwọn ọmọ Simeoni ni: Jemueli, Jamini, Ohadi, Jakini, Sohari àti Saulu ọmọ obìnrin Kenaani. Àwọn wọ̀nyí ni ìran Simeoni. ");
INSERT INTO yor_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ìwọ̀nyí ni orúkọ àwọn ọmọ Lefi gẹ́gẹ́ bí àkọsílẹ̀ wọn: Gerṣoni, Kohati àti Merari. Lefi lo ẹ̀tàdínlógóje (137) ọdún láyé. ");
INSERT INTO yor_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Àwọn ọmọ Gerṣoni ni ìran wọn ni: Libni àti Ṣimei. ");
INSERT INTO yor_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Àwọn ọmọ Kohati ni: Amramu, Isari, Hebroni àti Usieli. Kohati lo ẹ̀tàléláádóje (133) ọdún láyé. ");
INSERT INTO yor_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Àwọn ọmọ Merari ni: Mahili àti Muṣi. Ìwọ̀nyí ni ìran Lefi gẹ́gẹ́ bí àkọsílẹ̀ wọn. ");
INSERT INTO yor_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amramu sì fẹ́ Jokebedi arábìnrin baba rẹ̀ ní ìyàwó. Jokebedi sì bí Aaroni àti Mose fún un. Amramu lo ẹ̀tàdínlógóje (137) ọdún láyé. ");
INSERT INTO yor_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Àwọn ọmọ Isari ni: Kora, Nefegi àti Sikri. ");
INSERT INTO yor_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Àwọn ọmọ Usieli ni: Miṣaeli, Elsafani àti Sitiri. ");
INSERT INTO yor_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaroni fẹ́ Eliṣeba ọmọbìnrin Amminadabu tí í ṣe arábìnrin Nahiṣoni, ó sì bí Nadabu, Abihu, Eleasari àti Itamari. ");
INSERT INTO yor_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Àwọn ọmọ Kora ni: Asiri, Elkana àti Abiasafu. Ìwọ̀nyí ni ìran Kora. ");
INSERT INTO yor_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasari ọmọ Aaroni fẹ́ ọ̀kan lára àwọn ọmọbìnrin Putieli ní ìyàwó, ó sì bí Finehasi fún un. Ìwọ̀nyí ni olórí àwọn Lefi ni ìdílé ìdílé. ");
INSERT INTO yor_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aaroni àti Mose yìí kan náà ni Olúwa sọ fún pé, “Ẹ kó àwọn ará Israẹli jáde kúrò ni ilẹ̀ Ejibiti ní ìsọ̀rí ìsọ̀rí.” ");
INSERT INTO yor_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Àwọn ni ó bá Farao ọba Ejibiti sọ̀rọ̀ nípa kíkó àwọn ará Israẹli jáde kúrò ni Ejibiti, àní Mose àti Aaroni yìí kan náà ni. ");
INSERT INTO yor_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Nígbà tí Olúwa bá Mose sọ̀rọ̀ ni Ejibiti, ");
INSERT INTO yor_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Olúwa sì sọ fún Mose pé, “Èmi ni Olúwa. Sọ ohun gbogbo ti mo ti sọ fún ọ fún Farao ọba Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ṣùgbọ́n Mose sì wí ní iwájú Olúwa pé, “Níwọ́n ìgbà ti mo jẹ́ akólòlò, ọ̀nà dà ti Farao yóò ṣe fi etí sí mi?” ");
INSERT INTO yor_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Nígbà náà ni Olúwa sọ fún Mose pé, “Wò ó, Èmi ti ṣe ọ bí Ọlọ́run fún Farao, Aaroni arákùnrin rẹ ni yóò jẹ́ agbẹnusọ rẹ. ");
INSERT INTO yor_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ìwọ yóò sì sọ ohun gbogbo tí Èmi ti pàṣẹ fún ọ, Aaroni arákùnrin rẹ yóò sísọ fún Farao kí ó jẹ́ kí àwọn ọmọ Israẹli jáde kúrò ni ilẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ṣùgbọ́n èmi yóò sé Farao lọ́kàn le. Bí Mo tilẹ̀ ṣe ọ̀pọ̀lọpọ̀ iṣẹ́ àmì àti ìyanu ni Ejibiti, ");
INSERT INTO yor_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","síbẹ̀ òun kì yóò fi etí sí ọ. Nígbà náà ni Èmi yóò gbé ọwọ́ mi lé Ejibiti, pẹ̀lú agbára ìdájọ́ ńlá mi ni èmi yóò mú àwọn ènìyàn mi Israẹli jáde ní ọ̀wọ̀ọ̀wọ́. ");
INSERT INTO yor_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Àwọn ará Ejibiti yóò sì mọ̀ pé Èmi ni Olúwa ní ìgbà tí mo bá na ọwọ́ mi jáde lé Ejibiti, tí mo sì mú àwọn ọmọ Israẹli jáde kúrò níbẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mose àti Aaroni sì ṣe gẹ́gẹ́ bí Olúwa ti pàṣẹ fún wọn. ");
INSERT INTO yor_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mose jẹ́ ọmọ ọgọ́rin ọdún Aaroni sì jẹ́ ọmọ ọdún mẹ́tàlélọ́gọ́rin ni ìgbà tí wọ́n bá Farao sọ̀rọ̀. ");
INSERT INTO yor_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Olúwa sọ fún Mose àti Aaroni, ");
INSERT INTO yor_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ní ìgbà tí Farao bá sọ fún un yín pé, ‘Ẹ ṣe iṣẹ́ ìyanu kan,’ sọ fún Aaroni ní ìgbà náà pé, ‘Mú ọ̀pá rẹ kí ó sì sọ ọ́ sílẹ̀ níwájú Farao,’ yóò sì di ejò.” ");
INSERT INTO yor_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Nígbà náà ni Mose àti Aaroni tọ Farao lọ, wọ́n sì ṣe bí Olúwa ti pàṣẹ fún wọn, Aaroni ju ọ̀pá rẹ̀ sílẹ̀ ní iwájú Farao àti àwọn ìjòyè rẹ̀, ọ̀pá náà sì di ejò. ");
INSERT INTO yor_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Farao sì pe àwọn amòye, àwọn oṣó àti àwọn onídán ilẹ̀ Ejibiti jọ, wọ́n sì fi idán wọn ṣe ohun tí Mose àti Aaroni ṣe. ");
INSERT INTO yor_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ẹnìkọ̀ọ̀kan wọn sọ ọ̀pá rẹ̀ sílẹ̀, ọ̀pá náà sì di ejò. Ṣùgbọ́n ọ̀pá Aaroni gbé ọ̀pá tiwọn mì. ");
INSERT INTO yor_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Síbẹ̀ ọkàn Farao sì yigbì, kò si fetí sí wọn gẹ́gẹ́ bí Olúwa ti sọ. ");
INSERT INTO yor_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Nígbà náà ni Olúwa sọ fún Mose pé, “Ọkàn Farao ti di líle, ó kọ̀ láti jẹ́ kí àwọn ènìyàn náà ó lọ. ");
INSERT INTO yor_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Tọ Farao lọ ni òwúrọ̀ kùtùkùtù bí ó ti ń lọ sí etí odò, dúró ni etí bèbè odò Naili láti pàdé rẹ, mú ọ̀pá rẹ tí ó di ejò ni ọwọ́ rẹ. ");
INSERT INTO yor_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Sọ fún un pé, ‘Olúwa Ọlọ́run àwọn Heberu rán mi sí ọ láti sọ fún ọ pé, Jẹ́ kí àwọn ènìyàn mi kí ó lọ, kí wọn kí ó lè sìn mi ni aginjù. Ṣùgbọ́n títí di àkókò yìí, ìwọ kò gba. ");
INSERT INTO yor_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Èyí ni Olúwa wí, nípa èyí ni ìwọ yóò mọ̀ pé Èmi ni Olúwa. Wò ó, èmi yóò fi ọ̀pá ti ó wà ní ọwọ́ mi, èmi yóò ná omi tí ó wà nínú odò Naili yóò sì di ẹ̀jẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Àwọn ẹja tí ó wà nínú odò Naili yóò kú, odò náà yóò sì máa rùn, àwọn ará Ejibiti kò sì ni lè mu omi rẹ̀.’ ” ");
INSERT INTO yor_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Olúwa sọ fún Mose, “Sọ fún Aaroni, ‘Mú ọ̀pá rẹ kí ó sì na ọwọ́ rẹ jáde lórí àwọn omi Ejibiti. Lórí àwọn odò kéékèèké àti odò ńlá, lórí àbàtà àti adágún omi, wọn yóò sì di ẹ̀jẹ̀.’ Ẹ̀jẹ̀ yóò wà ni ibi gbogbo ni Ejibiti, àní nínú ọpọ́n àti nínú kete omi àti nínú ìkòkò tí a pọn omi sí nínú ilé.” ");
INSERT INTO yor_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mose àti Aaroni sí ṣe gẹ́gẹ́ bí Olúwa ti pàṣẹ fún wọn. Ó gbé ọ̀pá rẹ̀ sókè ni iwájú Farao àti àwọn ìjòyè rẹ̀, ó sì lu omi odò Naili, omi odò náà sì yípadà sí ẹ̀jẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ẹja inú odò Naili sì kú, odò náà ń rùn gidigidi tí ó fi jẹ́ pé àwọn ará Ejibiti kò le è mu omi inú rẹ̀. Ẹ̀jẹ̀ sì wà ni ibi gbogbo ni ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ṣùgbọ́n àwọn apidán ilẹ̀ Ejibiti sì ṣe bákan náà pẹ̀lú agbára òkùnkùn wọn, ọkàn Farao sì yigbì síbẹ̀ kò sì fetí sí wọn gẹ́gẹ́ bí Olúwa ti sọ. ");
INSERT INTO yor_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Dípò bẹ́ẹ̀, ó yíjú padà, ó sì lọ sí ààfin rẹ̀, kò sì jẹ́ kí àwọn nǹkan wọ̀nyí wà ni oókan àyà rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nígbà náà ni gbogbo àwọn ará Ejibiti bẹ̀rẹ̀ sí í gbẹ́ etí odò Naili láti wá omi tí wọn yóò mu, nítorí wọn kò le è mu omi tí ó wà nínú odò náà. ");
INSERT INTO yor_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ọjọ́ méje sì kọjá ti Olúwa ti lu odò Naili. ");
INSERT INTO yor_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nígbà náà ni Olúwa sọ fún Mose pé, “Padà tọ Farao lọ kí ó sì sọ fún un pé, ‘Èyí ni Olúwa wí: Jẹ́ kí àwọn ènìyàn mi kí ó lọ, kí wọn ó bá à lè sìn mi. ");
INSERT INTO yor_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Bí ìwọ bá kọ̀ láti jẹ́ kí wọn ó lọ, èmi yóò fi ọ̀pọ̀lọpọ̀ àwọn ọ̀pọ̀lọ́ kọlu gbogbo orílẹ̀-èdè rẹ. ");
INSERT INTO yor_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Odò Naili yóò kún fún ọ̀pọ̀lọpọ̀ àwọn ọ̀pọ̀lọ́. Wọn yóò gòkè wá sí ààfin rẹ, àti yàrá rẹ ni orí ibùsùn rẹ. Wọn yóò gòkè wá sí ilé àwọn ìjòyè rẹ àti sí ara àwọn ènìyàn rẹ, àti sí ibi ìdáná rẹ, àti sí inú ìkòkò ìyẹ̀fun rẹ. ");
INSERT INTO yor_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Àwọn ọ̀pọ̀lọ́ yóò gun ara rẹ àti ara àwọn ìjòyè rẹ, àti ara gbogbo àwọn ènìyàn rẹ.’ ” ");
INSERT INTO yor_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ní ìgbà náà ni Olúwa sọ fún Mose pé, “Sọ fún Aaroni, ‘Kí ó na ọwọ́ rẹ̀ jáde pẹ̀lú ọ̀pá sí orí àwọn odò kéékèèké àti odò ńlá, àti sí orí àwọn àbàtà kí ó sì mú àwọn ọ̀pọ̀lọ́ gòkè wá sí ilẹ̀ Ejibiti.’ ” ");
INSERT INTO yor_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ní ìgbà náà ni Aaroni sì na ọwọ́ rẹ̀ jáde sí orí àwọn omi Ejibiti, àwọn ọ̀pọ̀lọ́ sì wá, wọ́n sì bo gbogbo ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ṣùgbọ́n àwọn onídán ilẹ̀ Ejibiti ṣe bákan náà pẹ̀lú agbára òkùnkùn wọn. Àwọn náà mú kí ọ̀pọ̀lọ́ gún wá sí orí ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Farao ránṣẹ́ pe Mose àti Aaroni, ó sì sọ fún wọn pé, “Gbàdúrà sí Olúwa kí ó mú àwọn ọ̀pọ̀lọ́ wọ̀nyí kúrò lọ́dọ̀ mi àti lára àwọn ènìyàn mi, Èmi yóò sì jẹ́ kí àwọn ènìyàn rẹ kí ó lọ láti rú ẹbọ sí Olúwa.” ");
INSERT INTO yor_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose sọ fún Farao pé, “Jọ̀wọ́ sọ fún mi ìgbà ti èmi yóò gbàdúrà fún ọ àti àwọn ìjòyè rẹ àti fún àwọn ènìyàn rẹ, kí àwọn ọ̀pọ̀lọ́ wọ̀nyí bá lè lọ lọ́dọ̀ rẹ àti ní àwọn ilé yín tí wọn yóò sì wà nínú odò Naili nìkan.” ");
INSERT INTO yor_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao wí pé, “Ni ọ̀la.” Mose sì dáhùn pé, “Yóò sì rí bí ìwọ ti sọ, kí ìwọ kí ó lè mọ̀ pé kò sí ẹni bí Olúwa Ọlọ́run wa. ");
INSERT INTO yor_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Àwọn ọ̀pọ̀lọ́ yóò fi ìwọ àti àwọn ilé yín àti ìjòyè rẹ, àti àwọn ènìyàn rẹ sílẹ̀, wọn yóò sì wà nínú Naili nìkan.” ");
INSERT INTO yor_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Lẹ́yìn tí Mose àti Aaroni tí kúrò ní iwájú Farao, Mose gbé ohùn ẹ̀bẹ̀ rẹ̀ sókè sí Olúwa nípa àwọn ọ̀pọ̀lọ́ tí ó ti rán sí Farao. ");
INSERT INTO yor_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Olúwa sì ṣe gẹ́gẹ́ bí Mose tí béèrè. Àwọn ọ̀pọ̀lọ́ sì kú nínú ilé àti ní ìta, gbangba àti nínú oko. ");
INSERT INTO yor_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Wọ́n sì kó wọn jọ ni òkìtì òkìtì gbogbo ilẹ̀ sì ń rùn. ");
INSERT INTO yor_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ṣùgbọ́n ni ìgbà tí Farao rí pé ìtura dé, ó sé ọkàn rẹ̀ le kò sì fetí sí Mose àti Aaroni gẹ́gẹ́ bí Olúwa ti wí. ");
INSERT INTO yor_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Olúwa sọ fún Mose pé, “Sọ fún Aaroni, ‘Na ọ̀pá rẹ jáde kí ó sì lu eruku ilẹ̀,’ jákèjádò gbogbo ilẹ̀ Ejibiti ni erùpẹ̀ ilẹ̀ yóò ti di kòkòrò-kantíkantí.” (Kòkòrò kan tí ó ní ìyẹ́ méjì tí ó ṣì ń ta ni.) ");
INSERT INTO yor_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Wọ́n sì ṣe bẹ́ẹ̀, nígbà tí Aaroni na ọwọ́ rẹ́ jáde pẹ̀lú ọ̀pá ní ọwọ́ rẹ̀, tí ó sì lu eruku ilẹ̀, kòkòrò-kantíkantí sì wà lára àwọn ènìyàn àti àwọn ẹranko wọn. Gbogbo eruku jákèjádò ilẹ̀ Ejibiti ni ó di kòkòrò-kantíkantí. ");
INSERT INTO yor_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ṣùgbọ́n nígbà tí àwọn onídán gbìdánwò láti da kòkòrò-kantíkantí pẹ̀lú agbára òkùnkùn wọn, wọn kò le è ṣé. Nígbà tí kòkòrò-kantíkantí sì wà lára àwọn ẹranko wọn, ");
INSERT INTO yor_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","àwọn onídán sì sọ fún Farao pé, “Ìka Ọlọ́run ni èyí.” Ṣùgbọ́n àyà Farao sì yigbì, kò sì fetísílẹ̀, gẹ́gẹ́ bí Olúwa ti sọ. ");
INSERT INTO yor_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Nígbà náà ni Olúwa sọ fún Mose pé, “Lọ ní òwúrọ̀ kùtùkùtù kí o sì ko Farao lójú bí ó ṣe ń lọ sí odò, kí o sì sọ fún un pé, ‘Èyí ni Olúwa sọ: Jẹ́ kí àwọn ènìyàn mi kí ó lọ, kí wọn kí ó bá à lè sìn Mi. ");
INSERT INTO yor_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Bí ìwọ kò bá jẹ́ kí àwọn ènìyàn Mi kí ó lọ, èmi yóò rán ọ̀pọ̀lọpọ̀ eṣinṣin sí ara rẹ àti sí ara àwọn ìjòyè rẹ, àti sí ara àwọn ènìyàn rẹ̀, sí àwọn ilẹ̀ rẹ̀. Gbogbo ilé àwọn ará Ejibiti ni yóò kún fún eṣinṣin àti orí ilẹ̀ tí wọ́n wà pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Ṣùgbọ́n ni ọjọ́ náà, Èmi yóò ya ilẹ̀ Goṣeni sọ́tọ̀, níbi tí àwọn ènìyàn mi ń gbé, ọ̀wọ́ eṣinṣin kankan ki yóò dé ibẹ̀. Kí ìwọ kí ó lè mọ̀ pé, Èmi ni Olúwa, mo wà ni ilẹ̀ yìí. ");
INSERT INTO yor_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Èmi yóò pààlà sáàárín àwọn ènìyàn mi àti àwọn ènìyàn rẹ. Àwọn iṣẹ́ ìyanu yìí yóò ṣẹlẹ̀ ni ọ̀la.’ ” ");
INSERT INTO yor_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Olúwa sì ṣe èyí. Ọ̀pọ̀lọpọ̀ eṣinṣin sì ya wọ ààfin Farao àti sí ilé àwọn ìjòyè rẹ̀. Gbogbo ilẹ̀ Ejibiti bàjẹ́ pẹ̀lú ọ̀wọ́ eṣinṣin wọ̀n-ọn-nì. ");
INSERT INTO yor_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Nígbà náà ni Farao ránṣẹ́ pe Mose àti Aaroni, ó sì wí fún wọn pé, “Ẹ máa lọ kí ẹ sì rú ẹbọ sí Ọlọ́run yín ní ilẹ̀ yìí.” ");
INSERT INTO yor_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ṣùgbọ́n Mose sọ pé, “Èyí ló tọ́, ẹbọ tí a ó rú sí Olúwa Ọlọ́run wa yóò jẹ́ ohun ìríra sí àwọn ará ilẹ̀ Ejibiti. Bí a bá ṣe ìrúbọ ti yóò jẹ́ ìríra ni ojú wọn ṣé wọn, ó ní sọ òkúta lù wá? ");
INSERT INTO yor_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","A gbọdọ̀ lọ ni ìrìn ọjọ́ mẹ́ta sí inú aginjù láti rú ẹbọ sí Olúwa Ọlọ́run gẹ́gẹ́ bí ó ti pàṣẹ fún wa.” ");
INSERT INTO yor_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Nígbà náà ni Farao wí pé, “Èmi yóò jẹ́ ki ẹ lọ rú ẹbọ sí Olúwa Ọlọ́run yín nínú aginjù, ṣùgbọ́n ẹ kò gbọdọ̀ rìn jìnnà jù. Ẹ gbàdúrà fún mi.” ");
INSERT INTO yor_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose dáhùn ó wí pé, “Bí èmi bá ti kúrò ní ọ̀dọ̀ rẹ, èmi yóò gbàdúrà sí Olúwa, àwọn ọ̀wọ́ eṣinṣin yóò fi Farao, àwọn ìjòyè rẹ, àti àwọn ènìyàn rẹ sílẹ̀ ní ọ̀la ṣùgbọ́n ǹjẹ́ ìdánilójú wa pé Farao kò tún ni lo ẹ̀tàn láti má jẹ́ kí àwọn ènìyàn kí ó lọ rú ẹbọ sí Olúwa.” ");
INSERT INTO yor_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Nígbà náà ni Mose kúrò ni ọ̀dọ̀ Farao, ó sì gbàdúrà sí Olúwa; ");
INSERT INTO yor_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Olúwa sì ṣe gẹ́gẹ́ bí Mose ti béèrè. Àwọn ọ̀wọ́ eṣinṣin kúrò lára Farao àti àwọn ìjòyè rẹ̀ àti lára àwọn ènìyàn rẹ̀ pẹ̀lú, eṣinṣin kan kò sì ṣẹ́kù. ");
INSERT INTO yor_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ṣùgbọ́n ni àkókò yìí náà, Farao sé ọkàn rẹ le, kò sì jẹ́ kí àwọn ènìyàn ó lọ. ");
INSERT INTO yor_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Nígbà náà ni Olúwa sọ fún Mose pé, “Lọ sọ fún Farao, ‘Èyí ni Olúwa Ọlọ́run àwọn Heberu sọ, “Jẹ́ kí àwọn ènìyàn Mi kí ó lọ, kí wọn bá à lè sìn Mí.” ");
INSERT INTO yor_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Bí ìwọ bá kọ̀ láti jẹ́ kí wọn ó lọ, tí ó sì dá wọn dúró. ");
INSERT INTO yor_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Ọwọ́ Olúwa yóò mú ààrùn búburú wá sí ara ẹran ọ̀sìn nínú oko, sí ara ẹṣin, kẹ́tẹ́kẹ́tẹ́, ìbákasẹ, màlúù, àgùntàn àti ewúrẹ́ yín. ");
INSERT INTO yor_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ṣùgbọ́n Olúwa yóò pààlà sí àárín ẹran ọ̀sìn tí ó jẹ́ ti Israẹli àti ti àwọn ara Ejibiti tí yóò fi jẹ́ pé kò sí ẹran ọ̀sìn ti ó jẹ́ ti ará Israẹli tí yóò kùú.’ ” ");
INSERT INTO yor_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Olúwa sì dá àkókò kan wí pé, “Ní ọ̀la ni Olúwa yóò ṣe èyí ni ilẹ̀ yìí.” ");
INSERT INTO yor_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Olúwa sí ṣe é ni ọjọ́ kejì. Gbogbo ẹran ọ̀sìn ará Ejibiti kú, ṣùgbọ́n ẹyọ kan kò kú lára ẹran ọ̀sìn àwọn Israẹli. ");
INSERT INTO yor_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao rán àwọn ènìyàn rẹ̀ láti lọ ṣe ìwádìí, wọ́n sì rí pé ẹyọ kan kò kú lára àwọn ẹran ọ̀sìn ará Israẹli. Síbẹ̀ náà, Farao kò yí ọkàn rẹ̀ padà àti pé kò jẹ́ kí àwọn ènìyàn ó lọ. ");
INSERT INTO yor_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Nígbà náà ni Olúwa sọ fún Mose àti Aaroni, “Ẹ bu ẹ̀kúnwọ́ eérú gbígbóná láti inú ààrò, kí Mose kù ú sí inú afẹ́fẹ́ ni iwájú Farao. ");
INSERT INTO yor_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Yóò sì di eruku lẹ́búlẹ́bú ni gbogbo ilẹ̀ Ejibiti, yóò sì di oówo ti ń tú pẹ̀lú ìléròrò sí ara àwọn ènìyàn àti ẹran jákèjádò gbogbo ilẹ̀ Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Nígbà náà ni wọ́n bú eérú gbígbóná láti inú ààrò, wọ́n dúró ní iwájú Farao. Mose sì ku eérú náà sínú afẹ́fẹ́, ó sì di oówo tí ń tú pẹ̀lú ìléròrò ni ara àwọn ènìyàn àti lára ẹran. ");
INSERT INTO yor_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Àwọn onídán kò le è dúró níwájú Mose nítorí oówo ti ó wà lára wọn àti ni ara gbogbo àwọn ara Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ṣùgbọ́n Ọlọ́run sé ọkàn Farao le, kò sì gbọ́ ti Mose àti Aaroni, gẹ́gẹ́ bí Olúwa ti sọ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Nígbà náà ni Olúwa sọ fún Mose pé, “Dìde ni òwúrọ̀ kùtùkùtù, kí o sì tọ Farao lọ, kí o sì wí fún un pé, ‘Èyí ni ohun tí Olúwa Ọlọ́run àwọn Heberu wí, Jẹ́ kí àwọn ènìyàn mi kí ó lọ, kí wọn bá à lè sìn mí, ");
INSERT INTO yor_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","nítorí nígbà yìí ni èmi yóò rán àjàkálẹ̀-ààrùn ti ó ní agbára gidigidi sí ọ, sí àwọn ìjòyè rẹ àti sí àwọn ènìyàn rẹ, kí ìwọ kí ó lè mọ̀ pé, kò sí ẹni bí èmi ni gbogbo ayé. ");
INSERT INTO yor_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ó ti yẹ kí n ti na ọwọ́ mi jáde láti kọlù ọ́ àti àwọn ènìyàn rẹ pẹ̀lú ààrùn búburú ti kò bá ti run yín kúrò ni orí ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ṣùgbọ́n nítorí èyí ni èmi ṣe mú ọ dúró, kí èmi kí ó le fi agbára mi hàn lára rẹ, àti kí a bá à le máa ròyìn orúkọ mi ká gbogbo ayé. ");
INSERT INTO yor_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Síbẹ̀ ìwọ tún gbógun ti àwọn ènìyàn mi, ìwọ kò sì jẹ́ kí wọn lọ. ");
INSERT INTO yor_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Nítorí náà, ni ìwòyí ọ̀la, Èmi yóò rán òjò o yìnyín tí irú rẹ̀ kò tí i rọ̀ rí ni Ejibiti láti ìpilẹ̀ṣẹ̀ rẹ̀ títí di àkókò yìí. ");
INSERT INTO yor_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Pàṣẹ nísinsin yìí láti kó ẹran ọ̀sìn yín àti ohun gbogbo ti ẹ ni ní pápá wá sí abẹ́ ààbò, nítorí òjò yìnyín yóò rọ̀ sí orí àwọn ènìyàn àti ẹran ti a kò kó wá sí abẹ́ ààbò tí wọ́n sì wà ni orí pápá, wọn yóò sì kú.’ ” ");
INSERT INTO yor_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Àwọn ti ó bẹ̀rù ọ̀rọ̀ Olúwa lára àwọn ìjòyè Farao yára lọ láti kó àwọn ẹrú àti àwọn ẹran ọ̀sìn wọn wá sí abẹ́ ààbò. ");
INSERT INTO yor_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ṣùgbọ́n àwọn ti kò kà ọ̀rọ̀ Olúwa sí fi àwọn ẹrú wọn àti àwọn ẹran ọ̀sìn wọn sílẹ̀ ni pápá. ");
INSERT INTO yor_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Olúwa sọ fún Mose pé, “Gbé ọwọ́ rẹ sókè sí ọ̀run kí yìnyín bá à lè rọ̀ sí orí gbogbo ilẹ̀ Ejibiti, sí orí ènìyàn àti ẹranko, àti sí orí gbogbo ohun ọ̀gbìn tí ó wà ni inú oko.” ");
INSERT INTO yor_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Nígbà tí Mose gbé ọ̀pá rẹ̀ sókè sí ojú ọ̀run, Olúwa rán àrá àti yìnyín, mọ̀nàmọ́ná sì bùsi orí ilẹ̀. Olúwa rọ òjò yìnyín sí orí ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Yìnyín rọ̀, mọ̀nàmọ́ná sì bẹ̀rẹ̀ sí bùsi orí ilẹ̀ èyí ni ó tí ì burú jù ti ó ṣẹlẹ̀ láti ìgbà ti Ejibiti ti di orílẹ̀-èdè. ");
INSERT INTO yor_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Jákèjádò gbogbo ilẹ̀ Ejibiti ni yìnyín ti pa gbogbo ohun tí ó wà ni orí pápá; ènìyàn àti ẹranko, ó wò gbogbo ohun ọ̀gbìn lulẹ̀ ó sì fa gbogbo igi ya pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ilẹ̀ Goṣeni ni ibi ti àwọn Israẹli wà nìkan ni òjò yìnyín náà kò rọ̀ dé. ");
INSERT INTO yor_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Nígbà náà ni Farao pe Mose àti Aaroni sì ọ̀dọ́ rẹ̀, ó sì wí fún wọn pé, “Èmi ti ṣẹ̀ ní àkókò yìí; Olúwa jẹ́ olódodo ṣùgbọ́n èmi àti àwọn ènìyàn mi ni aláìṣòdodo. ");
INSERT INTO yor_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Èyí ti òjò yìnyín àti àrá rọ̀ yìí tó gẹ́ẹ́, gbàdúrà sí Olúwa kí ó dáwọ́ rẹ̀ dúró. Èmi yóò jẹ́ kí ẹ lọ, n kò tún ni dá a yín dúró mọ́.” ");
INSERT INTO yor_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose dá a lóhùn pé, “Bí mo bá ti jáde kúrò ní àárín ìlú, èmi yóò gbé ọwọ́ mi sókè sí Olúwa, sísán àrá yóò dáwọ́ dúró, yìnyín kò sì ni rọ̀ mọ́, kí ìwọ kí ó lè mọ̀ pé Olúwa ni ó ni ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ṣùgbọ́n èmi mọ̀ pé síbẹ̀síbẹ̀ ìwọ àti àwọn ìjòyè rẹ kò bẹ̀rù Olúwa Ọlọ́run.” ");
INSERT INTO yor_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(A sì lu ọ̀gbọ̀ àti ọkà barle bolẹ̀; nítorí barle wà ní ìpẹ́, ọ̀gbọ̀ sì rudi. ");
INSERT INTO yor_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Alikama àti ọkà ni a kò lù bolẹ̀, nítorí tí wọ́n kò tí ì dàgbà.) ");
INSERT INTO yor_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Nígbà náà ni Mose jáde kúrò ni iwájú Farao, ó kúrò ni àárín ìgboro kọjá lọ sí ẹ̀yìn odi ìlú, ó sì gbé ọwọ́ rẹ̀ sókè sí Olúwa, sísán àrá àti òjò yìnyín ti ń rọ̀ sì dáwọ́ dúró, òjò kò sì rọ̀ sí orí ilẹ̀ mọ́. ");
INSERT INTO yor_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Nígbà tí Farao rí i pé òjò àti yìnyín àti àrá ti ń sán ti dáwọ́ dúró, ó tún ṣẹ̀ ní ẹ̀ẹ̀kan sí i. Òun àti àwọn ìránṣẹ́ rẹ̀ ṣì sé àyà wọn le. ");
INSERT INTO yor_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Àyà Farao sì le, bẹ́ẹ̀ ni kò sì jẹ́ kí àwọn ọmọ Israẹli kí ó lọ, bí Olúwa ti sọ láti ẹnu Mose. ");
INSERT INTO yor_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Nígbà náà ni Olúwa sọ fún Mose pé, “Lọ sí ọ̀dọ̀ Farao, mo ti ṣé àyà Farao le àti àyà àwọn ìránṣẹ́ rẹ̀, kí èmi kí o ba le ṣe àwọn iṣẹ́ ìyanu mi láàrín wọn. ");
INSERT INTO yor_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Kí ẹ̀yin ki ó le sọ fún àwọn ọmọ yín àti àwọn ọmọ ọmọ yín; bí mo ti jẹ àwọn ará Ejibiti ní yà àti bí mo ti ṣe àwọn iṣẹ́ ìyanu láàrín wọn. Kí ìwọ ba á le mọ̀ pé Èmi ni Olúwa.” ");
INSERT INTO yor_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Nígbà náà ni Mose àti Aaroni tọ Farao lọ, tiwọn sí wí fún un pé, “Èyí ni Olúwa, Ọlọ́run àwọn Heberu sọ, ‘Yóò ti pẹ́ to ti ìwọ yóò kọ̀ láti tẹrí ara rẹ ba ní iwájú mi? Jẹ́ kí àwọn ènìyàn mi kí ó lọ, kí wọn kí ó sìn mi. ");
INSERT INTO yor_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Bí ìwọ bá kọ̀ láti jẹ́ kí wọn lọ, èmi yóò mú eṣú wa sí orílẹ̀-èdè rẹ ní ọ̀la. ");
INSERT INTO yor_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Wọn yóò bo gbogbo ilẹ̀. Wọn yóò ba ohun gbogbo tí ó kù fún ọ lẹ́yìn òjò yìnyín jẹ́, tí ó fi dórí gbogbo igi tí ó ń dàgbà ni ilẹ̀ rẹ. ");
INSERT INTO yor_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Wọn yóò kún gbogbo ilé rẹ àti ilé àwọn ìjòyè rẹ àti ilé gbogbo àwọn ará Ejibiti. Ohun ti baba rẹ tàbí baba baba rẹ kò tí ì rí láti ìgbà tí wọ́n ti wà ní ilẹ̀ náà títí di àkókò yìí.’ ” Nígbà náà ni Mose pẹ̀yìndà kúrò níwájú Farao. ");
INSERT INTO yor_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Àwọn ìjòyè Farao sọ fún un, “Yóò ti pẹ́ to tí ọkùnrin yìí yóò máa jẹ́ ìkẹ́kùn fún wa? Jẹ́ kí àwọn ènìyàn yìí lọ, kí wọn kí ó le sìn Olúwa Ọlọ́run wọn. Ṣe ìwọ kò ṣe àkíyèsí síbẹ̀ pé, ilẹ̀ Ejibiti ti parun tán?” ");
INSERT INTO yor_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Nígbà náà ni a mú Aaroni àti Mose padà wá sí iwájú Farao ó sì wí fún wọn pé, “Ẹ lọ sìn Olúwa Ọlọ́run yín. Ṣùgbọ́n àwọn ta ni nínú yín ni yóò ha lọ.” ");
INSERT INTO yor_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose dáhùn ó wí pé, “A ó lọ pẹ̀lú àwọn ọmọdé àti àgbà wa, pẹ̀lú àwọn ọmọ wa ọkùnrin àti ọmọ wa obìnrin pẹ̀lú agbo àgùntàn wa àti agbo màlúù wa nítorí pé a gbọdọ̀ ṣe àjọ fún Olúwa.” ");
INSERT INTO yor_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao sì wí pé, “Mo fi Olúwa búra pé èmi kí yóò jẹ́ kí ẹ lọ, pẹ̀lú àwọn obìnrin yín àti àwọn ọmọ wẹ́wẹ́, dájúdájú èrò ibi ní ń bẹ nínú yín. ");
INSERT INTO yor_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Rárá! Ọkùnrin yín nìkan ni kí ó lọ, láti lọ sin Olúwa, níwọ̀n ìgbà tí ó jẹ́ pé èyí ni ẹ̀yin ń béèrè fún.” Wọ́n sì lé Mose àti Aaroni kúrò ní iwájú Farao. ");
INSERT INTO yor_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ní ìgbà náà ni Olúwa sọ fún Mose, “Gbé ọwọ́ rẹ sókè lórí Ejibiti kí ọ̀pọ̀lọpọ̀ eṣú bo gbogbo ilẹ̀, kí ó sì ba gbogbo ohun ọ̀gbìn tí ó wà ni inú oko wọn jẹ́, àní gbogbo ohun tí òjò yìnyín kò bàjẹ́ tan.” ");
INSERT INTO yor_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Nígbà náà ni Mose na ọ̀pá ọwọ́ rẹ̀ sórí ilẹ̀ Ejibiti, Olúwa sì mú kí afẹ́fẹ́ láti ìlà-oòrùn fẹ́ kọjá lórí ilẹ̀ náà ni gbogbo ọ̀sán àti ni gbogbo òru ni ọjọ́ náà. Ní òwúrọ̀ afẹ́fẹ́ náà ti gbá ọ̀pọ̀lọpọ̀ eṣú wá; ");
INSERT INTO yor_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","wọ́n sì bo gbogbo ilẹ̀ Ejibiti, wọ́n wà ní ibi gbogbo ní orí ilẹ̀ ní àìmoye, ṣáájú àkókò yìí kò sí irú ìyọnu eṣú bẹ́ẹ̀ rí, kò sì ní sí irú rẹ mọ́ lẹ́yìn èyí. ");
INSERT INTO yor_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Wọ́n bo gbogbo ilẹ̀ tí ilẹ̀ fi di dúdú. Wọ́n ba gbogbo ohun tókù ní orí ilẹ̀ lẹ́yìn òjò yìnyín jẹ́; gbogbo ohun ọ̀gbìn tí ó wà ní inú oko àti gbogbo èso tí ó wà lórí igi. Kò sí ewé tí ó kù lórí igi tàbí lórí ohun ọ̀gbìn ní gbogbo ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Farao yára ránṣẹ́ pe Mose àti Aaroni, ó sì sọ fún wọn pé, “Èmi ti ṣẹ̀ sí Olúwa Ọlọ́run yín àti sí i yín pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Nísinsin yìí ẹ dáríjì mi lẹ́ẹ̀kan sí i kí ẹ sì gbàdúrà sí Olúwa Ọlọ́run yín kí ó lè mú ìpọ́njú yìí kúrò ní ọ̀dọ̀ mi.” ");
INSERT INTO yor_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Nígbà náà ni Mose kúrò ní iwájú Farao ó sì gbàdúrà sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Olúwa sì yí afẹ́fẹ́ náà padà di afẹ́fẹ́ líle láti apá ìwọ̀-oòrùn wá láti gbá àwọn eṣú náà kúrò ní orí ilẹ̀ Ejibiti lọ sínú Òkun Pupa. Bẹ́ẹ̀ ni ẹyọ eṣú kan kò ṣẹ́kù sí orí ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Síbẹ̀ Olúwa ṣe àyà Farao le, kò sì jẹ́ kí àwọn ọmọ Israẹli lọ. ");
INSERT INTO yor_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Nígbà náà ni Olúwa sọ fún Mose pé, “Gbé ọwọ́ rẹ sókè sí ojú ọ̀run kí òkùnkùn bá à le bo gbogbo ilẹ̀ Ejibiti; àní òkùnkùn biribiri.” ");
INSERT INTO yor_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Nígbà náà ni Mose gbé ọwọ́ rẹ sókè sí ojú ọ̀run, òkùnkùn biribiri sì bo gbogbo ilẹ̀ Ejibiti fún ọjọ́ mẹ́ta. Ṣùgbọ́n àwọn ọmọ Israẹli ní ìmọ́lẹ̀ ní ibi tí wọn ń gbé. ");
INSERT INTO yor_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Kò sí ẹni tí ó le è ríran rí ẹlòmíràn tàbí kí ó kúrò ní ibi tí ó wà fún ọjọ́ mẹ́ta. Síbẹ̀ àwọn ọmọ Israẹli ni ìmọ́lẹ̀ ni gbogbo ibi tí wọ́n ń gbé. ");
INSERT INTO yor_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Farao sì ránṣẹ́ pe Mose ó sì wí fún un pé, “Lọ sin Olúwa, kódà àwọn obìnrin àti àwọn ọmọdé lè lọ pẹ̀lú yín, ṣùgbọ́n kí ìwọ kí ó fi agbo àgùntàn àti agbo màlúù yín sílẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ṣùgbọ́n Mose sọ pé, “Ìwọ gbọdọ̀ fún wa láààyè láti rú ẹbọ àti ọrẹ ẹbọ sísun ní iwájú Olúwa Ọlọ́run wa. ");
INSERT INTO yor_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Àwọn ohun ọ̀sìn wa gbọdọ̀ lọ pẹ̀lú wa, a kì yóò fi pátákò ẹsẹ̀ ẹran sílẹ̀. A ní láti lò lára wọn fún sínsin Olúwa Ọlọ́run wa, ìgbà tí a bá sì dé ibẹ̀ ni a ó to mọ̀ ohun ti a ó lò láti fi sin Olúwa.” ");
INSERT INTO yor_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ṣùgbọ́n Olúwa sé ọkàn Farao le, kò sì ṣetán láti jẹ́ kí wọn lọ. ");
INSERT INTO yor_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao sọ fún Mose pé, “Kúrò ní iwájú mi! Rí i dájú pé o kò wá sí iwájú mi mọ́! Ọjọ́ tí ìwọ bá rí ojú mi ni ìwọ yóò kùú.” ");
INSERT INTO yor_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose sì dáhùn pé, gẹ́gẹ́ bí ìwọ ti wí, “Èmi kí yóò wá sí iwájú rẹ mọ́.” ");
INSERT INTO yor_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Nísinsin yìí, Olúwa sọ fún Mose pé èmi yóò mú ààrùn kan sí i wá sí orí Farao àti ilẹ̀ Ejibiti. Lẹ́yìn náà yóò jẹ́ kí ẹ̀yin kí ó lọ kúrò níhìn-ín yìí, nígbà tí ó bá sì ṣe bẹ́ẹ̀ yóò lé yín jáde pátápátá. ");
INSERT INTO yor_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Sọ fún àwọn ènìyàn náà pé kí tọkùnrin tobìnrin wọn béèrè fún ohun èlò fàdákà àti wúrà lọ́wọ́ aládùúgbò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Olúwa jẹ́ kí wọn rí ojúrere àwọn ará Ejibiti, pàápàá, Mose fúnra rẹ̀ di ènìyàn pàtàkì ní ilẹ̀ Ejibiti ní iwájú àwọn ìjòyè Farao àti ní iwájú àwọn ènìyàn pẹ̀lú). ");
INSERT INTO yor_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Nígbà náà ni Mose wí pé, “Èyí ni ohun tí Olúwa sọ, ‘Ní ọ̀gànjọ́ òru èmi yóò la ilẹ̀ Ejibiti kọjá. ");
INSERT INTO yor_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Gbogbo àkọ́bí ọmọkùnrin tí ó wà ní ilẹ̀ Ejibiti ni yóò kùú, bẹ̀rẹ̀ lórí àkọ́bí ọkùnrin Farao tí ó jókòó lórí ìtẹ́ rẹ̀, tí ó fi dé orí àkọ́bí ọmọkùnrin ti ẹrúbìnrin tí ń lọ ọlọ àti gbogbo àkọ́bí ẹran ọ̀sìn pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Igbe ẹkún ńlá yóò sọ jákèjádò gbogbo ilẹ̀ Ejibiti. Irú ohun búburú tí kò ṣẹlẹ̀ rí tí kò sí tún ni ṣẹlẹ̀ mọ́. ");
INSERT INTO yor_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ṣùgbọ́n láàrín àwọn ará Israẹli ajá lásán kò ní gbó àwọn ènìyàn tàbí àwọn ẹran wọn.’ Nígbà náà ni ẹ̀yin yóò mọ̀ pé Olúwa ti fi ìyàtọ̀ sáàrín àwọn ará Ejibiti àti Israẹli. ");
INSERT INTO yor_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Gbogbo àwọn ìjòyè rẹ̀ wọ̀nyí yóò tọ̀ mí wá, wọn yóò wólẹ̀ ni iwájú, mi wọn yóò sì máa wí pé, ‘Lọ àti àwọn ènìyàn tí ó tẹ̀lé ọ!’ Lẹ́yìn náà èmi yóò jáde.” Nígbà náà ni Mose fi ìbínú jáde kúrò ní iwájú Farao. ");
INSERT INTO yor_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Olúwa ti sọ fún Mose pé, “Farao yóò kọ̀ láti fetísílẹ̀ sí ọ kí iṣẹ́ ìyanu mí le pọ̀ sí ní Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mose àti Aaroni ṣe àwọn iṣẹ́ ìyanu wọ̀nyí níwájú Farao, ṣùgbọ́n Olúwa sé ọkàn Farao le, òun kò sí jẹ́ kí àwọn Israẹli jáde kúrò ni orílẹ̀-èdè rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Olúwa sọ fún Mose àti Aaroni ni ilẹ̀ Ejibiti pé, ");
INSERT INTO yor_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Oṣù yìí ni yóò jẹ́ oṣù àkọ́kọ́ fún yín, oṣù àkọ́kọ́ nínú ọdún yín. ");
INSERT INTO yor_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Sọ fún gbogbo àwọn ènìyàn Israẹli pé ni ọjọ́ kẹwàá oṣù yìí, ọkùnrin kọ̀ọ̀kan yóò mú ọ̀dọ́-àgùntàn kọ̀ọ̀kan fún ìdílé rẹ̀, ọ̀kan fún agbo ilé kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Bí ìdílé kan bá kéré jù fún odidi ọ̀dọ́-àgùntàn kan, kí wọn kí ó ṣe àjọpín ọ̀kan pẹ̀lú aládùúgbò wọn ti ó sun mọ́ wọn kí wọ́n lo iye ènìyàn tiwọn jẹ láti ṣe òdínwọ̀n irú ọ̀dọ́-àgùntàn tiwọn yóò lò ní ìbámu pẹ̀lú ìwọ̀n ti ẹni kọ̀ọ̀kan lè jẹ. ");
INSERT INTO yor_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ọ̀dọ́-àgùntàn tí ìwọ yóò mú gbọdọ̀ jẹ́ akọ ọlọ́dún kan tí kò lábùkù, ìwọ lè mú lára àgbò tàbí ewúrẹ́. ");
INSERT INTO yor_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ṣe ìtọ́jú wọn títí di ọjọ́ kẹrìnlá oṣù yìí nígbà tí gbogbo ìjọ ènìyàn Israẹli yóò pa ẹran náà ní àfẹ̀mọ́júmọ́. ");
INSERT INTO yor_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Wọn yóò mú lára ẹ̀jẹ̀ ẹran náà, wọn yóò fi kan ẹ̀gbẹ́ méjèèjì àti òkè ẹnu-ọ̀nà àbáwọlé níbi tí wọ́n bá ti jẹ ẹran ọ̀dọ́-àgùntàn náà. ");
INSERT INTO yor_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ní òru ọjọ́ kan náà, wọn yóò jẹ ẹran tí a ti fi iná sun, pẹ̀lú ewé ewúro àti àkàrà aláìwú. ");
INSERT INTO yor_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ẹ má ṣe jẹ ẹran náà ni tútù tàbí ní bíbọ̀ nínú omi, ṣùgbọ́n kí ẹ fi iná sun orí, ẹsẹ̀ àti àwọn nǹkan inú ẹran náà. ");
INSERT INTO yor_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ẹ má ṣe fi èyíkéyìí sílẹ̀ di òwúrọ̀ ọjọ́ kejì, bí ó bá ṣẹ́kù di òwúrọ̀ ọjọ́ kejì, kí ẹ jó o níná. ");
INSERT INTO yor_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Báyìí ni ẹ̀yìn yóò ṣe jẹ́ tí ẹ̀yin ti àmùrè ní ẹ̀gbẹ́ yín, sáńdà yín ní ẹsẹ̀ yín àti ọ̀pá yín ni ọwọ́ yín. Ẹ yára jẹ ẹ́, oúnjẹ àjọ ìrékọjá Olúwa ni. ");
INSERT INTO yor_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Ní òru ọjọ́ yìí kan náà ni Èmi yóò la gbogbo ilẹ̀ Ejibiti kọjá, èmi yóò sì pa gbogbo àkọ́bí àti ènìyàn, àti ẹranko, èmi yóò mú ìdájọ́ wà sí orí àwọn òrìṣà ilẹ̀ Ejibiti. Èmi ni Olúwa.” ");
INSERT INTO yor_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ẹ̀jẹ̀ ni yóò jẹ́ àmì fún un yín ní àwọn ilé tí ẹ̀yin wà, nígbà tí èmi bá rí ẹ̀jẹ̀ náà, Èmi yóò ré e yín kọjá. Ààrùn kan kì yóò kàn yín nígbà tí èmi bá kọlu Ejibiti láti pa wọ́n run. ");
INSERT INTO yor_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ọjọ́ òní ni yóò sì máa ṣe ọjọ́ ìrántí fún yín, ẹ́yin yóò sì máa láàrín àwọn ìran tí ó ń bọ̀ lẹ́yìn ni ẹ̀yin yóò ti máa ṣe ní àjọ fún Olúwa; ní ìran-ìran yín bí ìlànà tí yóò wà títí ayé. ");
INSERT INTO yor_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Fún ọjọ́ méje ni ẹ̀yin yóò fi jẹ àkàrà tí kò ní ìwúkàrà. Ní ọjọ́ kìn-ín-ní, ẹ ó gbé ìwúkàrà kúrò ni ilé yín, nítorí ẹnikẹ́ni tí ó bá jẹ ohunkóhun tí ó ni ìwúkàrà nínú láti ọjọ́ kìn-ín-ní di ọjọ́ keje ni kí a yọ kúrò ni Israẹli. ");
INSERT INTO yor_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ní ọjọ́ kìn-ín-ní kí àpéjọ mímọ́ kí ó wà; àti ní ọjọ́ keje àpéjọ mímọ́ mìíràn yóò wà fún yín. Ẹ má ṣe ṣe iṣẹ́kíṣẹ́ kan ní àwọn ọjọ́ wọ̀nyí, bí kò ṣe oúnjẹ tí olúkúlùkù yóò jẹ; kìkì èyí ni gbogbo ohun tí ẹ̀yin lè ṣe. ");
INSERT INTO yor_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Ẹ ó sì kíyèsí àjọ àìwúkàrà, nítorí ní ọjọ́ náà gan an ni mo mú ogun yín jáde kúrò ni ilẹ̀ Ejibiti. Nítorí náà ni kí ẹ máa kíyèsi ọjọ́ náà ní ìran-ìran yín bí ìlànà tí yóò wà títí ayé. ");
INSERT INTO yor_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Àkàrà ti kò ni ìwúkàrà ni ẹ̀yin yóò jẹ láti ìrọ̀lẹ́ ọjọ́ kẹrìnlá títí di ìrọ̀lẹ́ ọjọ́ kọ̀kànlélógún oṣù àkọ́kọ́. ");
INSERT INTO yor_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Fún ọjọ́ méje ni ẹ kò gbọdọ̀ ni ìwúkàrà nínú ilé yín, ẹnikẹ́ni tí ó bá jẹ ohun tí ó ni ìwúkàrà nínú ni a ó yọ kúrò ni àárín àwùjọ Israẹli, ìbá à ṣe àlejò tàbí ẹni tí a bí ní ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ẹ kò gbọdọ̀ jẹ ohunkóhun tí a fi ìwúkàrà ṣe. Ní ibikíbi tí ẹ̀yin bá ń gbé, kí ẹ̀yin kí ó jẹ àkàrà tí kò ní ìwúkàrà.” ");
INSERT INTO yor_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ní ìgbà náà ni Mose pé gbogbo àwọn àgbàgbà Israẹli jọ, ó sì sọ fún wọn pé, “Ẹ jáde lọ, kí ẹ sì yan ọ̀dọ́-àgùntàn fún àwọn ìdílé yín, kí ẹ sì pa ẹran àjọ ìrékọjá Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ẹ̀yin yóò sì mú ìdí-ewé hísópù, ẹ tì í bọ inú ẹ̀jẹ̀ tí ó wà nínú ọpọ́n kí ẹ sì fi kun òkè à bá wọ ẹnu-ọ̀nà ilé yín àti ẹ̀gbẹ́ méjèèjì ìlẹ̀kùn yín. Ẹnikẹ́ni nínú yín kò gbọdọ̀ jáde sí òde títí di òwúrọ̀. ");
INSERT INTO yor_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ní ìgbà tí Olúwa bá ń lọ káàkiri ní ilẹ̀ Ejibiti láti kọlù wọn, yóò rí ẹ̀jẹ̀ ni òkè ẹnu-ọ̀nà àti ni ẹ̀gbẹ́ ẹnu-ọ̀nà ilé yín, yóò sì ré ẹnu-ọ̀nà ilé náà kọjá, kì yóò gba apanirun láààyè láti wọ inú ilé e yín láti kọlù yín. ");
INSERT INTO yor_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Ẹ pa ìlànà yìí mọ́ gẹ́gẹ́ bí ohun tí ẹ ó máa ṣe títí ayérayé láàrín yín àti àwọn ìran yín. ");
INSERT INTO yor_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Nígbà tí ẹ̀yin bá de ilẹ̀ tí Olúwa yóò fi fún un yín bí òun ti ṣe ìlérí, ẹ máa kíyèsi àjọ yìí. ");
INSERT INTO yor_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ní ìgbà tí àwọn ọmọ yín bá béèrè lọ́wọ́ yín, ‘Kí ni ohun tí àjọ yìí túmọ̀ sí fún un yín?’ ");
INSERT INTO yor_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Ẹ sọ fún wọn ni ìgbà náà, ‘Ẹbọ ìrékọjá sí Olúwa ni, ẹni tí ó rékọjá ilé àwọn ọmọ Israẹli ni ìgbà tí ó kọlu àwọn ara Ejibiti. Tí ó si da wa sí nígbà ti ó pa àwọn ara Ejibiti.’ ” Àwọn ènìyàn sì tẹríba láti sìn. ");
INSERT INTO yor_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Àwọn ọmọ Israẹli ṣe gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose àti Aaroni. ");
INSERT INTO yor_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ní ọ̀gànjọ́ òru Olúwa kọlu gbogbo àwọn àkọ́bí ilẹ̀ Ejibiti, láti orí àkọ́bí. Farao tí ó wà ní orí ìtẹ́ títí dé orí àkọ́bí ẹlẹ́wọ̀n tí ó wà nínú túbú àti àkọ́bí ẹran ọ̀sìn pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Farao àti àwọn ìjòyè rẹ̀ àti gbogbo àwọn ara Ejibiti dìde ní ọ̀gànjọ́ òru, igbe ẹkún ńlá sì gba gbogbo ilẹ̀ Ejibiti, nítorí kò sí ilé kan tí ó yọ sílẹ̀ tí ènìyàn kan kò ti kú. ");
INSERT INTO yor_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Farao sì ránṣẹ́ pe Mose àti Aaroni ní òru, ó sì wí pé, “Ẹ kúrò lọ́dọ̀ mi ẹ̀yin àti àwọn ènìyàn Israẹli! Ẹ lọ láti sin Olúwa gẹ́gẹ́ bí ẹ ti béèrè. ");
INSERT INTO yor_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ẹ kó agbo àgùntàn yín àti agbo màlúù yín gẹ́gẹ́ bí ẹ̀yin ti sọ, kí ẹ sì máa lọ, kí ẹ sì súre fún mi.” ");
INSERT INTO yor_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Àwọn ara Ejibiti ń rọ àwọn ènìyàn náà láti yára máa lọ kúrò ní ilẹ̀ wọn. Wọ́n wí pé, “Bí bẹ́ẹ̀ kọ́ gbogbo wa ni yóò kú!” ");
INSERT INTO yor_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Àwọn ènìyàn náà sì mú ìyẹ̀fun púpọ̀ kí wọn tó fi ìwúkàrà sí i, wọ́n gbe le èjìká wọn nínú ọpọ́n tí wọ́n ti fi aṣọ dì. ");
INSERT INTO yor_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Àwọn ọmọ Israẹli ṣe gẹ́gẹ́ bí Mose ti sọ fún wọn. Wọ́n sì béèrè lọ́wọ́ ará Ejibiti fún ohun èlò fàdákà àti wúrà àti fún aṣọ pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Olúwa ti mú kí àwọn ènìyàn yìí rí ojúrere àwọn ará Ejibiti wọ́n sì fún wọn ní ohun tí wọ́n béèrè fún, wọ́n sì ko ẹrù àwọn ará Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Àwọn ọmọ Israẹli sì rìn láti Ramesesi lọ sí Sukkoti. Àwọn ọkùnrin tó ń fi ẹsẹ̀ rìn tó ọgbọ̀n ọ̀kẹ́ (600,000) ni iye láìka àwọn obìnrin àti àwọn ọmọdé. ");
INSERT INTO yor_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ọ̀pọ̀ àwọn ènìyàn mìíràn ni ó bá wọ́n lọ àti ọ̀pọ̀lọpọ̀ ẹran ọ̀sìn, agbo àgùntàn àti agbo màlúù. ");
INSERT INTO yor_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Pẹ̀lú ìyẹ̀fun tí kò ní ìwúkàrà nínú tí wọ́n gbé jáde láti Ejibiti wá ni wọ́n fi ṣe àkàrà aláìwú. Ìyẹ̀fun náà kò ni ìwúkàrà nínú nítorí a lé wọn jáde láti ilẹ̀ Ejibiti wọn kò si rí ààyè láti tọ́jú oúnjẹ fún ara wọn. ");
INSERT INTO yor_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Iye ọdún ti àwọn ará Israẹli gbé ní ilẹ̀ Ejibiti jẹ́ irinwó ọdún ó lé ọgbọ̀n (430). ");
INSERT INTO yor_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ó sì ní òpin irinwó ọdún ó le ọgbọ̀n (430), ní ọjọ́ náà gan an, ni ó sì ṣe tí gbogbo ogun Olúwa jáde kúrò ní ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Nítorí pé, Olúwa ṣe àìsùn ni òru ọjọ́ náà láti mú wọn jáde kúrò ní ilẹ̀ Ejibiti, ní òru yìí ni gbogbo Israẹli ní láti máa ṣe àìsùn láti fi bu ọlá fún Olúwa títí di àwọn ìran tí ń bọ̀. ");
INSERT INTO yor_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Olúwa sọ fún Mose àti Aaroni pé, “Ìwọ̀n yìí ni àwọn òfin fún àjọ ìrékọjá: “Àjèjì kò gbọdọ̀ jẹ nínú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ẹrú tí ẹ̀yin bá rà lè jẹ́ nínú rẹ̀ lẹ́yìn tí ẹ̀yin bá ti kọ ọ́ ní ilà, ");
INSERT INTO yor_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ṣùgbọ́n àtìpó àti alágbàṣe kò ni jẹ nínú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Nínú ilé ni ẹ ti gbọdọ̀ jẹ ẹ́; ẹ kò gbọdọ̀ mú èyíkéyìí nínú ẹran náà jáde kúrò nínú ilé. Ẹ má ṣe ṣẹ́ ọ̀kankan nínú egungun rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Gbogbo àjọ Israẹli ni ó gbọdọ̀ ṣe àjọyọ̀ ọ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Àjèjì ti ó bá ń gbé ní àárín yín ti ó bá fẹ́ kópa nínú àjọ ìrékọjá Olúwa, ni o gbọdọ̀ kọ gbogbo àwọn ọmọkùnrin ilé rẹ̀ ní ilà; ní ìgbà náà ni ó lè kó ipa gẹ́gẹ́ bí àwọn ọmọ tí a bí ní ilẹ̀ náà. Gbogbo àwọn ọmọkùnrin tí a kò bá kọ ní ilà, wọ́n kò ni jẹ nínú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Òfin yìí kan náà ni ó mú àwọn ọmọ tí a bí ni ilẹ̀ náà àti àwọn àlejò tí ń gbé ní àárín yín.” ");
INSERT INTO yor_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Gbogbo àwọn ọmọ Israẹli ṣe gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose àti Aaroni. ");
INSERT INTO yor_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Àti pé ní ọjọ́ náà gan an ni Olúwa mú àwọn ọmọ Israẹli jáde kúrò ní ilẹ̀ Ejibiti gẹ́gẹ́ bí ìpín ìpín wọn. ");
INSERT INTO yor_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ẹ ya àwọn àkọ́bí yín ọkùnrin sọ́tọ̀ fún mi. Èyí ti ó bá jẹ́ àkọ́bí láàrín àwọn ọmọ Israẹli jẹ́ tèmi, ìbá à ṣe ènìyàn tàbí ẹranko.” ");
INSERT INTO yor_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Nígbà náà ni Mose sọ fún àwọn ènìyàn náà pé, “Ẹ rántí ọjọ́ òní, ọjọ́ ti ẹ jáde kúrò ni ilẹ̀ Ejibiti, kúrò ní ilẹ̀ tí ẹ̀yin ti ń ṣe ẹrú, nítorí Olúwa mú un yín jáde kúrò ni inú rẹ̀ pẹ̀lú ọwọ́ agbára. Ẹ má ṣe jẹ ohunkóhun tí ó ni ìwúkàrà nínú. ");
INSERT INTO yor_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Òní, ní oṣù Abibu (oṣù kẹta ọdún tiwa) lónìí ẹ̀yin ń jáde kúrò ní Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ní ìgbà tí Olúwa mú un yín jáde wá sí ilẹ̀ Kenaani, Hiti, Amori, Hifi àti ilẹ̀ àwọn Jebusi; ilẹ̀ tí ó ti ṣe búra láti fi fún àwọn baba ńlá yín, ilẹ̀ tí ó ń sàn fún wàrà àti oyin, ẹ ni láti pa ìsìn yìí mọ́ ní oṣù yìí. ");
INSERT INTO yor_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Fún ọjọ́ méje ni ìwọ yóò fi jẹ àkàrà tí kò ní ìwúkàrà nínú àti pé ní ọjọ́ keje ni àjọ yóò wà fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Kí ẹ̀yin ó jẹ àkàrà tí kò ní ìwúkàrà fún ọjọ́ méje yìí; kó má ṣe sí ohunkóhun tí a fi ìwúkàrà ṣe ní sàkání yín. ");
INSERT INTO yor_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ní ọjọ́ náà, ìwọ yóò sì sọ fún àwọn ọmọ rẹ ọkùnrin, ‘Mo ń ṣe èyí nítorí ohun tí Olúwa ṣe fún mi nígbà tí èmi jáde kúrò ni ilẹ̀ Ejibiti.’ ");
INSERT INTO yor_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ṣíṣe èyí yóò wà fún àmì ní ọwọ́ rẹ, àti bí àmì ìrántí ni iwájú orí rẹ, tí yóò máa rán ọ létí òfin Olúwa ní ẹnu rẹ. Nítorí Olúwa mú ọ jáde láti ilẹ̀ Ejibiti pẹ̀lú ọwọ́ agbára ńlá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ìwọ gbọdọ̀ pa òfin náà mọ́ ní àkókò tí a yàn bí ọdún tí ń gorí ọdún. ");
INSERT INTO yor_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Lẹ́yìn tí Olúwa tí mú ọ wá sí ilẹ̀ àwọn ará Kenaani tí ó sì fi fún ọ gẹ́gẹ́ bí òun ti ṣe ìlérí pẹ̀lú ìbúra fún ọ àti fún àwọn baba ńlá rẹ̀, ");
INSERT INTO yor_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ìwọ yóò fi àkọ́bí inú rẹ fún Olúwa. Gbogbo àkọ́bí ti ó jẹ́ akọ ti ẹran ọ̀sìn rẹ ní ó jẹ́ ti Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ìwọ yóò fi ọ̀dọ́-àgùntàn ra àkọ́bí kẹ́tẹ́kẹ́tẹ́ padà, ṣùgbọ́n bí ìwọ kò bá rà á padà, ǹjẹ́ kí ìwọ ṣẹ́ ẹ ní ọrùn, gbogbo àkọ́bí ọkùnrin ni kí ìwọ kí ó rà padà. ");
INSERT INTO yor_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Yóò sí ṣe ní àwọn ọjọ́ tí ń bọ̀, ní ìgbà tí àwọn ọmọ yín yóò béèrè lọ́wọ́ yín, ‘Kí ni èyí túmọ̀ sí?’ Kí ìwọ kí ó sọ fún wọn pé, ‘Pẹ̀lú ọwọ́ agbára ní Olúwa fi mú wa jáde kúrò ni ilẹ̀ Ejibiti, kúrò ní oko ẹrú. ");
INSERT INTO yor_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ní ìgbà ti Farao ṣe orí kunkun, ti ó kọ̀ láti jẹ́ kí a lọ, Olúwa pa gbogbo àwọn àkọ́bí ilẹ̀ Ejibiti, àti ènìyàn àti ẹranko. Ìdí èyí ni àwa fi ń fi gbogbo àkọ́bí tí í ṣe akọ rú ẹbọ sí Olúwa láti fi ṣe ìràpadà fún àwọn àkọ́bí wa ọkùnrin.’ ");
INSERT INTO yor_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Èyí yóò sì jẹ́ àmì ni ọwọ́ yín àti àmì ní iwájú orí yín pé Olúwa mú wa jáde láti ilẹ̀ Ejibiti wá pẹ̀lú ọwọ́ agbára ńlá.” ");
INSERT INTO yor_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ní ìgbà tí Farao jẹ́ kí àwọn ènìyàn ó lọ, Ọlọ́run kò mú wọn tọ ojú ọ̀nà ti ó la orílẹ̀-èdè àwọn Filistini kọjá, bí o tilẹ̀ jẹ́ pé ọ̀nà náà kúrú. Nítorí Ọlọ́run sọ pé, “Bí wọ́n bá dojúkọ ogun, wọ́n lè yí ọkàn wọn padà kí wọ́n padà sí ilẹ̀ Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Nítorí náà Ọlọ́run darí àwọn ènìyàn rọkọ gba ọ̀nà aginjù ní apá Òkun Pupa. Àwọn ọmọ Israẹli jáde kúrò ní ilẹ̀ Ejibiti pẹ̀lú ìmúra fún ogun. ");
INSERT INTO yor_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose kó egungun Josẹfu pẹ̀lú rẹ̀ nítorí Josẹfu tí mú kí àwọn ọmọ Israẹli búra. Ó ti wí pé, “Dájúdájú Ọlọ́run yóò dìde fún ìrànlọ́wọ́ yín ẹ sì gbọdọ̀ kó egungun mi lọ pẹ̀lú yín kúrò níhìn-ín yìí.” ");
INSERT INTO yor_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Wọ́n sì mú ọ̀nà wọn pọ̀n láti Sukkoti lọ, wọ́n sì pàgọ́ sí Etamu ní etí aginjù. ");
INSERT INTO yor_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Olúwa sì ń lọ níwájú wọn, nínú ọ̀wọ̀n ìkùùkuu ní ọ̀sán láti máa ṣe amọ̀nà wọn àti ní òru nínú ọ̀wọ̀n iná láti máa tan ìmọ́lẹ̀ fún wọn, kí wọn lè máa lọ nínú ìrìnàjò wọn ní tọ̀sán tòru. ");
INSERT INTO yor_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ìkùùkuu náà kò kúrò ní ààyè rẹ̀ ní ọ̀sán, bẹ́ẹ̀ ni, ọ̀wọ̀n iná kò kúrò ní ààyè rẹ̀ ni òru, ní iwájú àwọn ènìyàn náà. ");
INSERT INTO yor_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Sọ fún àwọn ọmọ Israẹli kí wọn padà sẹ́yìn, kí wọ́n sì pàgọ́ sí tòsí Pi-Hahirotu láàrín Migdoli òun Òkun, kí wọn kí ó pàgọ́ sí ẹ̀bá Òkun, ní òdìkejì Baali-Ṣefoni. ");
INSERT INTO yor_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao yóò ronú pé àwọn ọmọ Israẹli ń ráre káàkiri ní ìdààmú ni àti wí pé aginjù náà ti sé wọn mọ́. ");
INSERT INTO yor_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Èmi yóò sé ọkàn Farao le ti yóò fi lépa wọn. Ṣùgbọ́n èmi yóò gba ògo fún ará mi láti ìpàṣẹ Farao àti ogun rẹ̀, àti pé àwọn ará Ejibiti yóò mọ̀ pé Èmi ni Olúwa.” Àwọn Israẹli sì ṣe bẹ́ẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Nígbà tí wọ́n sọ fún ọba Ejibiti pé àwọn ènìyàn náà ti sálọ, ọkàn Farao àti àwọn ìránṣẹ́ rẹ̀ yí padà sí àwọn ènìyàn, wọ́n sì wí pé, “Kí ni ohun tí àwa ṣe yìí? Àwa ti jẹ́ kí àwọn ọmọ Israẹli kí ó lọ, a sì ti pàdánù ìsìnrú wọn.” ");
INSERT INTO yor_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ó sì di kẹ̀kẹ́-ẹṣin rẹ̀, ó sì kó àwọn ọmọ-ogun rẹ̀ pẹ̀lú rẹ̀, ");
INSERT INTO yor_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ó mú ẹgbẹ̀ta (600) ọmọ-ogun oníkẹ̀kẹ́ tí ó jáfáfá jùlọ àti gbogbo ọmọ-ogun oníkẹ̀kẹ́ mìíràn ní Ejibiti, olórí sì wà fún olúkúlùkù wọn. ");
INSERT INTO yor_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Olúwa sé ọkàn Farao ọba Ejibiti le, ó sì bẹ̀rẹ̀ sí lépa àwọn ọmọ Israẹli ti ń jáde lọ ní àìbẹ̀rù. ");
INSERT INTO yor_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Àwọn ará Ejibiti ń lépa wọn pẹ̀lú gbogbo ẹṣin kẹ̀kẹ́ ogun Farao àti àwọn ẹlẹ́ṣin rẹ̀, wọ́n sì lé wọn bá ni ibi tí wọ́n pa àgọ́ sí lẹ́bàá òkun ní ìhà Pi-Hahirotu, ni òdìkejì Baali-Ṣefoni. ");
INSERT INTO yor_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Bí Farao ti súnmọ́ tòsí ọ̀dọ̀ wọn, àwọn ọmọ Israẹli gbé ojú wọn sókè, wọn sì rí àwọn ará Ejibiti tó súnmọ́ wọn. Ẹ̀rù ńlá sì bá àwọn ará Israẹli, wọ́n kígbe sókè sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Wọ́n sọ fún Mose pé, “Ṣe nítorí pé kò sí ibojì ni Ejibiti ní ìwọ ṣe mú wa wá láti kú sínú aginjù? Kí ni èyí tí ìwọ ṣe sí wa ti ìwọ fi mú wa jáde láti Ejibiti wá? ");
INSERT INTO yor_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ǹjẹ́ èyí kọ́ ni àwa sọ fún ọ ni Ejibiti, ‘Fi wá sílẹ̀, jẹ́ kí àwa máa sin ará Ejibiti’? Nítorí kò bá sàn fún wa kí a sin àwọn ará Ejibiti ju kí a kú sínú aginjù yìí lọ!” ");
INSERT INTO yor_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nígbà náà ni Mose sọ fún àwọn ènìyàn náà pé, “Ẹ má bẹ̀rù, ẹ dúró ṣinṣin kí ẹ sì rí ìdáǹdè tí Olúwa yóò fi fún un yín lónìí, àwọn ará Ejibiti ti ẹ̀yin rí lónìí ni ẹ kò ni tún padà rí wọn mọ́. ");
INSERT INTO yor_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Olúwa yóò jà fún un yín; kí ẹ̀yin kí ó sá à mu sùúrù.” ");
INSERT INTO yor_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Nígbà náà ni Olúwa sọ fún Mose pé, “Èéṣe tí ìwọ fi ń ké pè mí? Sọ fún àwọn ará Israẹli kí wọn máa tẹ̀síwájú. ");
INSERT INTO yor_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ṣùgbọ́n, gbé ọ̀pá rẹ̀ sókè, kí o sì na ọwọ́ rẹ sí orí omi Òkun, kí ó lè pín ní yà kí àwọn ọmọ Israẹli lè la òkun kọjá ni orí ìyàngbẹ ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nígbà náà ni èmi yóò sé ọkàn àwọn ará Ejibiti le, wọn yóò sì máa lépa wọn; Èmi yóò gba ògo fún ara mi lórí Farao; lórí gbogbo ogun rẹ̀, lórí kẹ̀kẹ́ ogun àti lórí àwọn ẹlẹ́ṣin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Àwọn ará Ejibiti yóò mọ̀ pé Èmi ni Olúwa nígbà ti èmi bá gba ògo fún ara mi lórí Farao: lórí kẹ̀kẹ́ ogun rẹ̀ àti lórí àwọn ẹlẹ́ṣin rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Nígbà náà ni angẹli Ọlọ́run tó ti ń ṣáájú ogun Israẹli lọ, padà o sì rìn ni ẹ̀yìn wọn; Òpó ìkùùkuu tí ń rìn ni iwájú wọn sì padà sí í rìn ni ẹ̀yìn wọn. ");
INSERT INTO yor_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ó sì wà láàrín àwọn ọmọ-ogun Ejibiti àti Israẹli. Ìkùùkuu sì ṣú òkùnkùn sí àwọn ará Ejibiti ni òru náà. Ṣùgbọ́n ó tan ìmọ́lẹ̀ sí àwọn Israẹli ni òru náà, ọ̀kan kò sì súnmọ́ èkejì ni gbogbo òru náà. ");
INSERT INTO yor_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Nígbà náà ni Mose na ọwọ́ rẹ̀ sí orí Òkun, ni gbogbo òru náà ni Olúwa fi lé òkun sẹ́yìn pẹ̀lú ìjì líle láti ìlà-oòrùn wá, ó sì sọ ọ́ di ìyàngbẹ ilẹ̀. Omi òkun sì pínyà, ");
INSERT INTO yor_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","àwọn ọmọ Israẹli sì la ìyàngbẹ ilẹ̀ kọjá nínú òkun pẹ̀lú ògiri omi ní ọ̀tún àti òsì. ");
INSERT INTO yor_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Àwọn ará Ejibiti sì ń lépa wọn, gbogbo ẹṣin Farao, kẹ̀kẹ́ ogun àti àwọn ẹlẹ́ṣin rẹ̀ wọ́ tọ̀ wọ́n lọ sínú òkun. ");
INSERT INTO yor_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ní ìṣọ́ òwúrọ̀ Olúwa bojú wo ogun àwọn ará Ejibiti láàrín ọ̀wọ̀n iná àti ìkùùkuu, ó sì kó ìpayà bá àwọn ọmọ-ogun Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ó sì yọ àgbá ẹsẹ̀ kẹ̀kẹ́ ogun wọn kí ó bá à le ṣòro fún wọn láti fi kẹ̀kẹ́ ogun náà rìn. Àwọn ará Ejibiti wí pé, “Ẹ jẹ́ kí a sá àsálà kúrò ní iwájú àwọn ará Israẹli nítorí Olúwa ń bá wa jà nítorí wọn.” ");
INSERT INTO yor_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Olúwa sì wí fún Mose pé, “Na ọwọ́ rẹ sí orí òkun kí omi òkun lè ya padà sórí àwọn ará Ejibiti, kẹ̀kẹ́ ogun wọn àti sórí ẹlẹ́ṣin wọn.” ");
INSERT INTO yor_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mose sì na ọwọ́ rẹ̀ sí orí òkun, òkun sì padà bọ́ sí ipò rẹ̀ nígbà ti ilẹ̀ mọ́. Àwọn ará Ejibiti ń sá fún omi òkun, Olúwa sì gbá wọn sínú òkun. ");
INSERT INTO yor_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Omi òkun sì ya padà, ó sì bo kẹ̀kẹ́ ogun àti àwọn ẹlẹ́ṣin: àní, gbogbo ọmọ-ogun Farao tiwọn wọ inú òkun tọ àwọn ọmọ Israẹli lọ kò sí ọ̀kan nínú wọn tí ó yè. ");
INSERT INTO yor_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ṣùgbọ́n àwọn ará Israẹli la òkun kọjá lórí ìyàngbẹ ilẹ̀ pẹ̀lú ògiri omi ni ọ̀tún àti òsì wọn. ");
INSERT INTO yor_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ni ọjọ́ yìí ni Olúwa gba Israẹli là kúrò lọ́wọ́ àwọn ará Ejibiti; Israẹli sì rí òkú àwọn ará Ejibiti ni etí òkun. ");
INSERT INTO yor_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Nígbà ti àwọn ọmọ Israẹli rí iṣẹ́ ìyanu ńlá ti Olúwa ṣe fún wọn lára àwọn ará Ejibiti, àwọn ènìyàn bẹ̀rù Olúwa, wọ́n sì gba Olúwa àti Mose ìránṣẹ́ rẹ gbọ́. ");
INSERT INTO yor_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Nígbà náà ni Mose àti àwọn ọmọ Israẹli kọ orin yìí sí Olúwa, Èmi yóò kọrin sí Olúwa, nítorí òun pọ̀ ní ògo. Ẹṣin àti ẹni tí ó gùn ún ni ó ti sọ sínú Òkun. ");
INSERT INTO yor_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Olúwa ni agbára àti orin mi; òun ti di Olùgbàlà mi, òun ni Ọlọ́run mi, èmi ó yìn ín, Ọlọ́run baba mi, èmi ó gbé e ga. ");
INSERT INTO yor_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ológun ni Olúwa, Olúwa ni orúkọ rẹ, ");
INSERT INTO yor_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","kẹ̀kẹ́ ogun Farao àti ogun rẹ̀ ni ó mú wọ inú Òkun. Àwọn ọmọ-ogun Farao tó jáfáfá jùlọ ni ó rì sínú Òkun Pupa. ");
INSERT INTO yor_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ibú omi bò wọ́n mọ́lẹ̀; wọ́n sì rì sí ìsàlẹ̀ omi òkun bí òkúta. ");
INSERT INTO yor_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Ọwọ́ ọ̀tún rẹ, Olúwa, pọ̀ ní agbára. Ọwọ́ ọ̀tún rẹ, Olúwa, fọ́ àwọn ọ̀tá túútúú. ");
INSERT INTO yor_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Nínú agbára ńlá rẹ ti ó tóbi ìwọ bi àwọn ti ó dìde sí ọ ṣubú. Ìwọ rán ìbínú gbígbóná rẹ; tí ó run wọ́n bí àgémọ́lẹ̀ ìdí koríko. ");
INSERT INTO yor_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Pẹ̀lú èémí imú rẹ ni omi fi ń wọ́jọ pọ̀. Ìṣàn omi dìde dúró bí odi; ibú omi sì dìpọ̀ láàrín Òkun. ");
INSERT INTO yor_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ọ̀tá ń gbéraga, ó ń wí pé, ‘Èmi ó lépa wọn, èmi ó bá wọn. èmi ó pín ìkógun; èmi ó tẹ́ ìfẹ́kúfẹ̀ẹ́ mi lọ́run lára wọn. Èmi yóò fa idà mi yọ, ọwọ́ mi yóò pa wọ́n run.’ ");
INSERT INTO yor_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ìwọ fẹ́ èémí rẹ, òkun ru bò wọ́n mọ́lẹ̀. Wọ́n rì bí òjé ni àárín omi ńlá. ");
INSERT INTO yor_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ta ni nínú àwọn òrìṣà tó dàbí rẹ, Olúwa? Ta ló dàbí rẹ: ní títóbi, ní mímọ́ Ẹlẹ́rù ni yìn, tí ń ṣe ohun ìyanu? ");
INSERT INTO yor_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“Ìwọ na apá ọ̀tún rẹ, ilẹ̀ si gbé wọn mì. ");
INSERT INTO yor_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nínú ìfẹ́ rẹ ti kì í sákí Ìwọ ṣe amọ̀nà àwọn ènìyàn náà tí Ìwọ ti rà padà. Nínú agbára rẹ Ìwọ yóò tọ́ wọn, lọ sí ibi ìjókòó rẹ mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Orílẹ̀-èdè yóò gbọ́ wọn yóò wárìrì. Ìkáàánú yóò mi àwọn ènìyàn Filistia. ");
INSERT INTO yor_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ìbẹ̀rù yóò mú àwọn ìjòyè Edomu, àwọn olórí Moabu yóò wárìrì. Àwọn ènìyàn Kenaani yóò sì yọ́ dànù. ");
INSERT INTO yor_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ìbẹ̀rù bojo yóò ṣubú lù wọ́n, nítorí nína títóbi apá rẹ̀ wọn yóò dúró jẹ́ẹ́ láì mira bí i òkúta, títí àwọn ènìyàn rẹ yóò fi rékọjá, Olúwa, títí tí àwọn ènìyàn tí o ti rà yóò fi rékọjá. ");
INSERT INTO yor_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ìwọ yóò mú wọn wá láti gbìn wọ́n ni orí òkè ti ìwọ jogún, ní ibi ti ìwọ ṣe fún ara rẹ, Olúwa. Láti máa gbé ibi mímọ́ ti ìwọ fi ọwọ́ rẹ gbé kalẹ̀, Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Olúwa yóò jẹ ọba láé àti láéláé.” ");
INSERT INTO yor_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Nígbà ti ẹṣin Farao, kẹ̀kẹ́ ogun àti àwọn ẹlẹ́ṣin rẹ̀ wọ inú Òkun, Olúwa mú kí omi òkun padà bò wọ́n mọ́lẹ̀, ṣùgbọ́n àwọn ọmọ Israẹli rìn lórí ìyàngbẹ ilẹ̀ la òkun kọjá. ");
INSERT INTO yor_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriamu wòlíì obìnrin, arábìnrin Aaroni, mú ohun èlò orin ni ọwọ́ rẹ̀, gbogbo àwọn obìnrin sì jáde tẹ̀lé e pẹ̀lú ìlù òun ijó. ");
INSERT INTO yor_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamu kọrin sí wọn báyìí pé, “Ẹ kọrin sí Olúwa, nítorí òun ni ológo jùlọ. Ẹṣin àti ẹni tí ó gùn ún, ni òun bi ṣubú sínú Òkun.” ");
INSERT INTO yor_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Nígbà náà ni Mose ṣe amọ̀nà àwọn ènìyàn Israẹli jáde láti Òkun Pupa lọ sínú ijù Ṣuri. Wọ́n lọ ní ìrìn ọjọ́ mẹ́ta sínú ijù náà, wọn kò sì rí omi. ");
INSERT INTO yor_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Nígbà tí wọ́n dé Mara, wọn kò lè mu omi Mara nítorí omi náà korò. (Nítorí náà ni a ṣe pe ibẹ̀ ni Mara: ibi ìkorò.) ");
INSERT INTO yor_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Àwọn ènìyàn ń kùn sí Mose wí pé, “Kí ni àwa yóò mu?” ");
INSERT INTO yor_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mose sì ké pe Olúwa, Olúwa sì fi igi kan hàn án, ó sì sọ igi náà sínú omi, omi náà sì dùn. Níbẹ̀ ni Olúwa ti gbé ìlànà àti òfin kalẹ̀ fún wọn, níbẹ̀ ni ó sì ti dán wọn wò. ");
INSERT INTO yor_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ó wí pé, “Bí ìwọ bá fetísílẹ̀ dáradára sí òfin Olúwa Ọlọ́run, ti ìwọ sì ṣe ohun tí ó tọ́ ni ojú rẹ̀, ti ìwọ sì tẹ̀lé ohun tí ó pàṣẹ, ti ìwọ si pa ìlànà rẹ̀ mọ́. Èmi kì yóò jẹ́ kí èyíkéyìí nínú àwọn ààrùn wọ̀n-ọn-nì ti mo mú wá sórí àwọn ará Ejibiti wá sí ara rẹ, nítorí Èmi ni Olúwa ti ó mú ọ láradá.” ");
INSERT INTO yor_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Nígbà ti wọ́n dé Elimu, níbi ti kànga omi méjìlá àti àádọ́rin ọ̀pẹ gbé wà, wọ́n pàgọ́ síbẹ̀ ni etí omi. ");
INSERT INTO yor_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ìjọ àwọn ọmọ Israẹli mú ọ̀nà wọn pọ̀n kúrò ni Elimu, wọ́n dé sí ijù Sini tí ó wà láàrín Elimu àti Sinai, ni ọjọ́ kẹ́ẹ̀dógún oṣù kejì tí wọ́n jáde kúrò ni ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Gbogbo ìjọ àwọn ọmọ Israẹli sì ń kùn sí Mose àti Aaroni ní ijù náà. ");
INSERT INTO yor_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Àwọn ọmọ Israẹli wí fún wọn pé, “Àwa ìbá ti ọwọ́ Olúwa kú ni Ejibiti! Níbi tí àwa ti jókòó ti ìkòkò ẹran ti a sì ń jẹ ohun gbogbo tí a fẹ́ ni àjẹyó, ṣùgbọ́n ẹ̀yin mú wa wá sí inú ijù yìí láti fi ebi pa wá tí a ó fi kú.” ");
INSERT INTO yor_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Nígbà náà ni Olúwa sọ fún Mose pé, “Èmi yóò rọ òjò oúnjẹ láti ọ̀run wá fún yín. Àwọn ènìyàn yóò sì máa jáde lọ ni ọjọ́ kọ̀ọ̀kan láti kó ìwọ̀nba oúnjẹ ti ó tó fún oúnjẹ òòjọ́ wọn. Ní ọ̀nà yìí ni, èmi yóò fi dán wọn wò láti mọ bóyá wọn yóò máa tẹ̀lé ìlànà mi. ");
INSERT INTO yor_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ní ọjọ́ kẹfà, ki wọn kó ìlọ́po méjì èyí tiwọn ń ko ni ojoojúmọ́ tẹ́lẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mose àti Aaroni sọ fún gbogbo àwọn ọmọ Israẹli pé, “Ní ìrọ̀lẹ́, ẹ̀yin yóò mọ̀ pé Olúwa ni ó mú un yín jáde láti Ejibiti wá. ");
INSERT INTO yor_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ní òwúrọ̀, ẹ̀yin yóò ri ògo Olúwa, nítorí òun ti gbọ́ kíkùn tí ẹ kùn sí i. Ta ni àwa ti ẹ̀yin yóò máa kùn sí wa?” ");
INSERT INTO yor_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mose tún wí pé, “Ẹ̀yin yóò mọ pé Olúwa ni, nígbà ti ó bá fún un yín ni ẹran ni ìrọ̀lẹ́ àti gbogbo oúnjẹ ti ẹ̀yin ń fẹ́ ni òwúrọ̀, nítorí kíkùn ti ẹ̀yin ń kùn sí i. Ta ni àwa? Ẹ̀yin kò kùn sí àwa, Olúwa ni ẹ̀yin kùn sí i.” ");
INSERT INTO yor_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Nígbà náà ni Mose sọ fún Aaroni pe, “Sọ fún gbogbo ìjọ àwọn ọmọ Israẹli pe, ‘Ẹ wá sí iwájú Olúwa, nítorí òun ti gbọ́ kíkùn yín.’ ” ");
INSERT INTO yor_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ó sì ṣe bí Aaroni ti ń bá gbogbo ìjọ àwọn ọmọ Israẹli sọ̀rọ̀, wọn si bojú wo ìhà ijù, sì kíyèsi ògo Olúwa si farahàn ni àwọsánmọ̀. ");
INSERT INTO yor_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Èmi ti gbọ́ kíkùn àwọn ọmọ Israẹli. Sọ fun wọn, ‘Ní àṣálẹ́, ẹ̀yin yóò jẹ ẹran, àti ni òwúrọ̀ ni ẹ̀yin yóò jẹ oúnjẹ. Nígbà náà ni ẹ̀yin yóò mọ̀ pé Èmi ni Olúwa Ọlọ́run yín.’ ” ");
INSERT INTO yor_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ní àṣálẹ́ ọjọ́ náà ni àwọn àparò fò dé, wọ́n sì bo àgọ́ mọ́lẹ̀, ní òwúrọ̀ ìrì sì sẹ̀ yí gbogbo àgọ́ náà ká. ");
INSERT INTO yor_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Nígbà tí ìrì tí ó sẹ̀ bo ilẹ̀ ti lọ, kíyèsi i, ohun tí ó dì, tí ó sì ń yooru bí i yìnyín wà lórí ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Nígbà tí àwọn ọmọ Israẹli rí i, wọ́n bi ara wọn léèrè pé, “Kí ni èyí?” Nítorí pé wọn kò mọ ohun tí i ṣe. Mose sì wí fún wọn pé, “Èyí ni oúnjẹ tí Olúwa fi fún un yín láti jẹ. ");
INSERT INTO yor_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Èyí ni ohun tí Olúwa ti pàṣẹ, ‘Kí olúkúlùkù máa kó èyí ti ó tó fún un láti jẹ. Ẹ mú òsùwọ̀n omeri kan fún ẹnìkọ̀ọ̀kan ti ó wà nínú àgọ́ yín.’ ” ");
INSERT INTO yor_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Àwọn ọmọ Israẹli sì ṣe bí a ti sọ fún wọn; àwọn kan kó púpọ̀, àwọn kan kó kékeré. ");
INSERT INTO yor_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Nígbà tí wọ́n fi òsùwọ̀n omeri wọ̀n-ọ́n, ẹni tí ó kó púpọ̀ kò ní púpọ̀ jù, bẹ́ẹ̀ ni ẹni tí ó kó ìwọ̀nba kò ní kéré jù. Ẹnìkọ̀ọ̀kan kó ìwọ̀nba ti ó tó fún un. ");
INSERT INTO yor_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mose sì wí fún wọ́n pé, “Kí ẹnikẹ́ni ó má ṣe kó pamọ́ lára rẹ̀ di òwúrọ̀ ọjọ́ kejì.” ");
INSERT INTO yor_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ṣùgbọ́n, àwọn kan nínú wọn kò fetí sí Mose, wọ́n kó lára rẹ̀ pamọ́ di òwúrọ̀ ọjọ́ kejì, ohun ti wọ́n kó pamọ́ kún fún ìdin, ó sì ti bẹ̀rẹ̀ sí ní rùn. Nítorí náà Mose bínú sí wọn. ");
INSERT INTO yor_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ní òwúrọ̀, ni ojoojúmọ́ ni ẹnìkọ̀ọ̀kan ń lọ kó ìwọ̀nba ti ó tó fún un láti jẹ, bí oòrùn bá sì mú, a sì yọ́. ");
INSERT INTO yor_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ní ọjọ́ kẹfà, wọ́n kó ìlọ́po méjì èyí tiwọn ń kó tẹ́lẹ̀: òsùwọ̀n omeri méjì fún ẹnìkọ̀ọ̀kan; àwọn olórí ìjọ ènìyàn sì wá, wọ́n sì sọ èyí fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ó sì wí fún wọn pé, “Èyí ni ohun tí Olúwa pàṣẹ: ‘Ọ̀la jẹ́ ọjọ́ ìsinmi, ìsinmi mímọ́ fún Olúwa. Ẹ yan èyí ti ẹ̀yin ní yan, kí ẹ sì bọ èyí ti ẹ̀yin ní bọ̀. Ẹ tọ́jú èyí ti ó kù sílẹ̀, kí ẹ pa á mọ́ di òwúrọ̀.’ ” ");
INSERT INTO yor_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Wọ́n sì tọ́jú rẹ̀ di òwúrọ̀ bí Mose ti pàṣẹ; kò sì rùn bẹ́ẹ̀ ni kò sì ní ìdin. ");
INSERT INTO yor_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose sì wí fún wọn pé, “Ẹ jẹ ẹ́ ní òní nítorí òní jẹ́ ọjọ́ ìsinmi Olúwa. Ẹ̀yin kò ni rí i ni orí ilẹ̀ ní ọjọ́ òní. ");
INSERT INTO yor_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ní ọjọ́ mẹ́fà ni kí ẹ fi kó o, ṣùgbọ́n ni ọjọ́ keje ọjọ́ ìsinmi, kò ní sí i fún un yín ni ọjọ́ náà.” ");
INSERT INTO yor_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Síbẹ̀síbẹ̀ àwọn ènìyàn kan jáde lọ ní ọjọ́ keje láti kó o, ṣùgbọ́n wọn kò ri nǹkan kan kó. ");
INSERT INTO yor_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Olúwa sì sọ fún Mose pé, “Yóò ti pẹ́ tó ti ẹ ó kọ̀ láti pa àṣẹ mi àti ìlànà mi mọ́? ");
INSERT INTO yor_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Wò ó? Olúwa ti fún un yín ni ọjọ́ ìsinmi, nítorí náà, ni ọjọ́ kẹfà, ó fún un yín ni oúnjẹ ọjọ́ méjì; kí ẹnìkọ̀ọ̀kan dúró ni ibi tí ó gbé wà; kí ẹ má ṣe kúrò ni ibi tí ẹ wà ni ọjọ́ keje.” ");
INSERT INTO yor_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Nítorí náà, àwọn ènìyàn sinmi ní ọjọ́ keje. ");
INSERT INTO yor_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Àwọn ènìyàn Israẹli sì pe oúnjẹ náà ní manna. Ó funfun bí irúgbìn korianderi, ó sì dùn bí àkàrà fẹ́lẹ́fẹ́lẹ́ ti a fi oyin ṣe. ");
INSERT INTO yor_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mose wí pé, “Èyí ni ohun tí Olúwa pàṣẹ, ‘Ẹ mú òsùwọ̀n omeri manna kí ẹ sì pa á mọ́ de àwọn ìran ti ń bọ̀, kí wọn kí ó lè rí oúnjẹ ti èmi fi fún un yín jẹ ní ijù, nígbà tí mo mú un yín jáde ni ilẹ̀ Ejibiti.’ ” ");
INSERT INTO yor_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Nígbà náà ni Mose sọ fún Aaroni pe, “Mú ìkòkò kan, kí o sì kó manna tí ó kún òsùwọ̀n omeri kan sí inú rẹ̀, kí o sì gbé e kalẹ̀ ni iwájú Olúwa láti tọ́jú rẹ̀ pamọ́ de àwọn ìran ti ń bọ̀.” ");
INSERT INTO yor_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Bí Olúwa ti pàṣẹ fún Mose, Aaroni gbé manna sí iwájú ẹ̀rí láti pa á mọ́. ");
INSERT INTO yor_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Àwọn ará Israẹli jẹ manna fún ogójì ọdún títí wọ́n fi dé ilẹ̀ Kenaani ni ibi ti èso ti wà fún wọn láti jẹ, wọ́n jẹ manna títí tí wọ́n fi dé ilẹ̀ agbègbè Kenaani. ");
INSERT INTO yor_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Òsùwọ̀n omeri kan sì jẹ́ ìdákan nínú ìdámẹ́wàá efa.) ");
INSERT INTO yor_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Gbogbo ìjọ ènìyàn Israẹli si gbéra láti jáde kúrò láti aginjù Sini wọ́n ń lọ láti ibi kan de ibi kan gẹ́gẹ́ bí Olúwa ti pàṣẹ. Wọ́n pàgọ́ sí Refidimu, ṣùgbọ́n kò sí omi fún àwọn ènìyàn láti mú. ");
INSERT INTO yor_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Àwọn ènìyàn sì sọ̀ fún Mose, wọ́n wí pé, “Fún wa ni omi mu.” Mose dá wọn lóhùn wí pé, “Èéṣe ti ẹ̀yin fi ń bá mi jà? Èéṣe ti ẹ̀yin fi ń dán Olúwa wò?” ");
INSERT INTO yor_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ṣùgbọ́n òǹgbẹ ń gbẹ àwọn ènìyàn, wọ́n sì ń kùn sí Mose, wọ́n wí pé, “Èéṣe tí ìwọ fi mú wa jáde kúrò ní Ejibiti láti mú kí òǹgbẹ pa àwa, àwọn ọmọ wa àti ohun ọ̀sìn wa ku fún òǹgbẹ.” ");
INSERT INTO yor_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Nígbà náà ni Mose gbé ohùn rẹ̀ sókè sí Olúwa pé, “Kí ni kí èmi kí ó ṣe fún àwọn ènìyàn yìí? Wọ́n múra tan láti sọ mi ni òkúta.” ");
INSERT INTO yor_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Olúwa sì dá Mose lóhùn pé, “Máa lọ síwájú àwọn ènìyàn, mú nínú àwọn àgbàgbà Israẹli pẹ̀lú rẹ, mú ọ̀pá tí ìwọ fi lu odò Naili lọ́wọ́ kí ó sì máa lọ. ");
INSERT INTO yor_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Èmi yóò dúró ni ibẹ̀ dè ọ ni orí àpáta ni Horebu. Ìwọ ó sì lu àpáta, omi yóò sì jáde nínú rẹ̀ fún àwọn ènìyàn láti mu.” Mose sì ṣe bẹ́ẹ̀ ni iwájú àwọn àgbàgbà Israẹli. ");
INSERT INTO yor_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ó sì sọ orúkọ ibẹ̀ ni Massa àti Meriba, nítorí àwọn ọmọ Israẹli sọ̀, wọ́n sì dán Olúwa wò, wọ́n wí pé, “Ǹjẹ́ Olúwa ń bẹ láàrín wa tàbí kò sí?” ");
INSERT INTO yor_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Àwọn ara Amaleki jáde, wọ́n sì dìde ogun sí àwọn ọmọ Israẹli ni Refidimu. ");
INSERT INTO yor_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mose sì sọ fún Joṣua pé, “Yàn lára àwọn ọkùnrin fún wa, kí wọn ó sì jáde lọ bá àwọn ará Amaleki jà. Ní ọ̀la, èmi yóò dúró ni orí òkè pẹ̀lú ọ̀pá Ọlọ́run ní ọwọ́ mi.” ");
INSERT INTO yor_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Joṣua ṣe bí Mose ti wí fún un, ó sì bá àwọn ará Amaleki jagun; nígbà tí Mose, Aaroni àti Huri lọ sí orí òkè náà. ");
INSERT INTO yor_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Níwọ́n ìgbà tí Mose bá gbé apá rẹ̀ sókè, Israẹli n borí ṣùgbọ́n nígbà tí ó bá sì rẹ apá rẹ̀ sílẹ̀, Amaleki a sì borí. ");
INSERT INTO yor_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ṣùgbọ́n apá ń ro Mose, wọ́n mú òkúta, wọ́n sì fi sí abẹ́ rẹ̀, ó sì jókòó lé òkúta náà; Aaroni àti Huri sì mu ní apá rẹ̀, ọ̀kan ní apá ọ̀tún àti èkejì ni apá òsì; apá rẹ̀ méjèèjì sì dúró gangan títí di ìgbà ti oòrùn wọ. ");
INSERT INTO yor_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Joṣua sì fi ojú idà ṣẹ́gun àwọn ará Amaleki. ");
INSERT INTO yor_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Olúwa sì sọ fun Mose pé. “Kọ èyí sì inú ìwé fún ìrántí, kí o sì sọ fún Joṣua pẹ̀lú; nítorí èmi yóò pa ìrántí Amaleki run pátápátá kúrò lábẹ́ ọ̀run.” ");
INSERT INTO yor_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mose sì tẹ́ pẹpẹ kan, ó sì sọ orúkọ pẹpẹ náà ní Olúwa ni Àsíá mi. ");
INSERT INTO yor_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ó wí pé, “A gbé ọwọ́ sókè sí ìtẹ́ Olúwa. Olúwa yóò bá Amaleki jagun láti ìran dé ìran.” ");
INSERT INTO yor_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetro, àlùfáà Midiani, àna Mose, gbọ́ gbogbo ohun tí Ọlọ́run ti ṣe fún Mose àti fún Israẹli àwọn ènìyàn rẹ̀, àti bí Olúwa ti mú àwọn ènìyàn Israẹli jáde láti Ejibiti wá. ");
INSERT INTO yor_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Nígbà náà ni Jetro mu aya Mose tí í ṣe Sippora padà lọ sọ́dọ̀ rẹ (nítorí ó ti dá a padà sí ọ̀dọ̀ baba rẹ̀ tẹ́lẹ̀), ");
INSERT INTO yor_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Òun àti àwọn ọmọkùnrin rẹ̀ méjèèjì. Orúkọ àkọ́bí ń jẹ́ Gerṣomu; nítorí Mose wí pé, “Èmi ń ṣe àlejò ni ilẹ̀ àjèjì.” ");
INSERT INTO yor_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Èkejì ń jẹ́ Elieseri; ó wí pé, “Ọlọ́run baba mi ni alátìlẹ́yìn mi, ó sì gbà mí là kúrò lọ́wọ́ idà Farao.” ");
INSERT INTO yor_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetro, àna Mose, òun àti aya àti àwọn ọmọ Mose tọ̀ ọ́ wá nínú aginjù tí ó tẹ̀dó sí, nítòsí òkè Ọlọ́run. ");
INSERT INTO yor_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jetro sì ti ránṣẹ́ sí Mose pé, “Èmi Jetro, àna rẹ, ni mo ń bọ̀ wá sí ọ̀dọ̀ rẹ, èmi àti aya àti àwọn ọmọkùnrin rẹ méjèèjì.” ");
INSERT INTO yor_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mose sì jáde lọ pàdé àna rẹ̀, ó tẹríba fún un, ó sì fi ẹnu kò ó ni ẹnu. Wọ́n sì béèrè àlàáfíà ara wọn, wọ́n sì wọ inú àgọ́ lọ. ");
INSERT INTO yor_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose sọ fún àna rẹ̀ nípa ohun gbogbo ti Olúwa tí ṣe sí Farao àti àwọn ará Ejibiti nítorí Israẹli. Ó sọ nípa gbogbo ìṣòro tí wọn bá pàdé ní ọ̀nà wọn àti bí Olúwa ti gbà wọ́n là. ");
INSERT INTO yor_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Inú Jetro dùn láti gbọ́ gbogbo ohun rere ti Olúwa ṣe fún Israẹli, ẹni tí ó mú wọ́n jáde kúrò ni ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jetro sì wí pé, “Ìyìn ni fún Olúwa, ẹni tí ó gba yín là kúrò lọ́wọ́ àwọn ará Ejibiti àti lọ́wọ́ Farao, ẹni tí ó sì gba àwọn ènìyàn là kúrò lọ́wọ́ àwọn ará Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Mo mọ nísinsin yìí pé Olúwa tóbi ju gbogbo àwọn òrìṣà lọ; nítorí ti ó gba àwọn ènìyàn rẹ̀ kúrò lọ́wọ́ ìgbéraga àti ìkà àwọn ará Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jetro, àna Mose, mú ẹbọ sísun àti ẹbọ wá fún Ọlọ́run. Aaroni àti gbogbo àgbàgbà Israẹli sì wá láti bá àna Mose jẹun ní iwájú Ọlọ́run. ");
INSERT INTO yor_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ní ọjọ́ kejì, Mose jókòó láti máa ṣe ìdájọ́ fún àwọn ènìyàn gẹ́gẹ́ bí ìṣe rẹ̀; àwọn ènìyàn sì dúró ti Mose fún ìdájọ́ wọn láti òwúrọ̀ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Nígbà tí àna Mose rí bí àkókò ti èyí ń gba ti pọ̀ tó àti ti àwọn ènìyàn ti ń dúró pẹ́ tó, ó wí pé, “Kí ni èyí tí ìwọ ń ṣe sí àwọn ènìyàn? Èéṣe ti ìwọ nìkan jókòó gẹ́gẹ́ bí adájọ́, nígbà tí àwọn ènìyàn wọ̀nyí dúró yí ọ ká láti òwúrọ̀ di ìrọ̀lẹ́?” ");
INSERT INTO yor_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose dá a lóhùn pé, “Nítorí àwọn ènìyàn ń tọ̀ mí wá láti mọ́ ìfẹ́ Ọlọ́run. ");
INSERT INTO yor_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Nígbà tí wọ́n bá ní ẹjọ́, wọn a mú un tọ̀ mí wá, èmi a sì ṣe ìdájọ́ láàrín ẹnìkínní àti ẹnìkejì, èmi a sì máa mú wọn mọ òfin àti ìlànà Ọlọ́run.” ");
INSERT INTO yor_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Àna Mose dá a lóhùn pé, “Ohun tí o ń ṣe yìí kò dára. ");
INSERT INTO yor_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ìwọ àti àwọn ènìyàn ti ń tọ̀ ọ́ wá yìí yóò dá ara yín ní agara; iṣẹ́ yìí pọ̀jù fún ọ, ìwọ nìkan kò lè dá a ṣe. ");
INSERT INTO yor_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Nísinsin yìí, fetísílẹ̀ sí mi, èmi yóò sì gbà ọ́ ni ìmọ̀ràn, Ọlọ́run yóò sì wà pẹ̀lú rẹ. Ìwọ gbọdọ̀ jẹ́ aṣojú àwọn ènìyàn wọ̀nyí níwájú Ọlọ́run, ìwọ yóò sì mú èdè-àìyedè wá sí iwájú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kọ́ wọn ní òfin àti ìlànà Ọlọ́run, fi ọ̀nà igbe ayé ìwà-bí-Ọlọ́run hàn wọ́n àti iṣẹ́ tí wọn yóò máa ṣe. ");
INSERT INTO yor_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ṣa àwọn tí ó kún ojú òsùwọ̀n nínú gbogbo àwọn ènìyàn, àwọn tó bẹ̀rù Ọlọ́run, ti wọ́n jẹ́ olóòtítọ́, tí wọ́n kórìíra ìrẹ́jẹ; yàn wọ́n ṣe olórí, lórí ẹgbẹ̀rún ẹgbẹ̀rún, ọgọ́rùn-ún ọgọ́rùn-ún, àádọ́ta-dọ́ta àti mẹ́wàá mẹ́wàá. ");
INSERT INTO yor_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Jẹ́ kí wọn ó máa ṣe ìdájọ́ àwọn ènìyàn ni gbogbo ìgbà, ṣùgbọ́n jẹ́ kí wọn mú ẹjọ́ tí ó bá nira fún wọn láti dá tọ̀ ọ́ wá; kí wọn kí ó máa dá ẹjọ́ kéékèèké. Èyí ni yóò mú iṣẹ́ rẹ rọrùn, wọn yóò sì máa ràn ọ́ lọ́wọ́ lórí ìdájọ́ ṣíṣe. ");
INSERT INTO yor_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Bí ìwọ bá ṣe èyí, bí Ọlọ́run bá sì fi àṣẹ sí i fún ọ bẹ́ẹ̀, àárẹ̀ kò sì ní tètè mu ọ, àwọn ènìyàn wọ̀nyí yóò sì padà lọ ilé wọn ni àlàáfíà.” ");
INSERT INTO yor_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose fetísílẹ̀ sí àna rẹ̀, ó sì ṣe ohun gbogbo tí ó wí fún un. ");
INSERT INTO yor_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mose sì yan àwọn ènìyàn tí wọ́n kún ojú òsùwọ̀n nínú gbogbo Israẹli; ó sì fi wọ́n jẹ olórí àwọn ènìyàn, olórí ẹgbẹẹ̀rún, olórí ọ̀rọ̀ọ̀rún, olórí àràádọ́ta, àti olórí mẹ́wàá mẹ́wàá. ");
INSERT INTO yor_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Wọ́n sì ń ṣe ìdájọ́ àwọn ènìyàn ní ìgbà gbogbo. Wọ́n sì ń mú ẹjọ́ tó le tọ Mose wá; ṣùgbọ́n wọ́n ń dá ẹjọ́ tí kò le fúnra wọn. ");
INSERT INTO yor_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mose sì jẹ́ kí àna rẹ̀ lọ ní ọ̀nà rẹ̀, Jetro sì padà sí ilẹ̀ ẹ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ní oṣù kẹta tí àwọn Israẹli jáde kúrò ni ilẹ̀ Ejibiti, ni ọjọ́ náà gan an ni wọ́n dé aginjù Sinai. ");
INSERT INTO yor_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Lẹ́yìn ìgbà tí wọ́n gbéra kúrò ní Refidimu, wọ́n wọ ijù Sinai, wọ́n sì tẹ̀dó síbẹ̀, níbẹ̀ ni Israẹli sì dó sí ní iwájú òkè ńlá. ");
INSERT INTO yor_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mose sì gòkè tọ Ọlọ́run lọ. Olúwa sì ké pè é láti orí òkè náà wá pé, “Èyí ni ìwọ yóò sọ fún ilé Jakọbu àti ohun tí ìwọ yóò sọ fún àwọn ọmọ Israẹli: ");
INSERT INTO yor_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Ẹ̀yin ti rí ohun tí mo ti ṣe sí àwọn ará Ejibiti, àti bí mo ti gbé e yín ní apá ìyẹ́ idì. ");
INSERT INTO yor_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Nísinsin yìí, bí ẹ̀yin bá ṣe ìgbọ́ràn sí mi dé ojú àmì, tí ẹ sì pa májẹ̀mú mi mọ́, nígbà náà ni ẹ̀yin ó jẹ́ ìṣúra fún mi ju gbogbo orílẹ̀-èdè yòókù lọ. Bí ó tilẹ̀ jẹ́ pé gbogbo ayé ni tèmi. ");
INSERT INTO yor_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ẹ̀yin yóò sì máa jẹ́ ilẹ̀ ọba àwọn àlùfáà fún mi, orílẹ̀-èdè mímọ́.’ Ìwọ̀nyí ni ọ̀rọ̀ ti ìwọ yóò sọ fún àwọn ọmọ Israẹli.” ");
INSERT INTO yor_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mose sì tọ àwọn ènìyàn wá, ó sí pe àwọn àgbàgbà láàrín àwọn ènìyàn jọ. Ó sì gbé gbogbo ọ̀rọ̀ ti Olúwa pàṣẹ fún un láti sọ ní iwájú wọn. ");
INSERT INTO yor_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Gbogbo àwọn ènìyàn náà sì pa ohùn wọn pọ̀ wọ́n sì dáhùn wí pé, “Àwa yóò ṣe ohun gbogbo ti Olúwa wí.” Mose sì mú ìdáhùn wọn padà tọ Olúwa lọ. ");
INSERT INTO yor_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Olúwa sọ fún Mose pé, “Èmi yóò tọ̀ ọ́ wá nínú ìkùùkuu ṣíṣú dudu, kí àwọn ènìyàn lè gbọ́ ohùn mi nígbà ti mo bá ń bá ọ sọ̀rọ̀, kí wọn kí ó lè máa gbà ọ́ gbọ́.” Nígbà náà ni Mose sọ ohun tí àwọn ènìyàn wí fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Olúwa sì wí fún Mose pé, “Tọ àwọn ènìyàn lọ kí o sì yà wọ́n sí mímọ́ ni òní àti ni ọ̀la. Jẹ́ kí wọn kí ó fọ aṣọ wọn. ");
INSERT INTO yor_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Kí wọn kí ó sì múra di ọjọ́ kẹta, nítorí ni ọjọ́ náà ni Olúwa yóò sọ̀kalẹ̀ sí orí òkè Sinai ni ojú gbogbo àwọn ènìyàn. ");
INSERT INTO yor_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kí ìwọ kí ó ṣe ààlà fún àwọn ènìyàn, kí ìwọ kí ó sì wí fún wọn pé, ‘Ẹ kíyèsí ara yín, kí ẹ má ṣe gun orí òkè lọ, kí ẹ má tilẹ̀ fi ọwọ́ ba etí rẹ̀; ẹnikẹ́ni tí ó bá fi ọwọ́ kan òkè náà, ó dájú, pípa ni a ó pa á. ");
INSERT INTO yor_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","A ó sọ ọ́ ní òkúta tàbí kí a ta á ní ọfà, ọwọ́kọ́wọ́ kò gbọdọ̀ kàn án. Ìbá à ṣe ènìyàn tàbí ẹranko, òun kì yóò wà láààyè.’ Nígbà ti ìpè bá dún nìkan ni kí wọn ó gun òkè wá.” ");
INSERT INTO yor_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mose sì sọ̀kalẹ̀ láti orí òkè náà wá sí ọ̀dọ̀ àwọn ènìyàn, ó yà wọ́n sí mímọ́, wọ́n sì fọ aṣọ wọn. ");
INSERT INTO yor_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ó sì sọ fún àwọn ènìyàn pé, “Ẹ múra sílẹ̀ di ọjọ́ kẹta; ẹ má ṣe bá aya yín lòpọ̀.” ");
INSERT INTO yor_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ní òwúrọ̀ ọjọ́ kẹta, àrá àti mọ̀nàmọ́ná sì wà pẹ̀lú ìkùùkuu tí ó ṣú dudu ní orí òkè, ìpè ńlá sì dún kíkankíkan tó bẹ́ẹ̀ tí gbogbo àwọn tí ó wà ni ibùdó wárìrì. ");
INSERT INTO yor_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mose sì kó àwọn ènìyàn tí ó jáde láti ibùdó wá pàdé Ọlọ́run, wọ́n dúró nítòsí òkè. ");
INSERT INTO yor_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Èéfín sì bo òkè Sinai nítorí Olúwa sọ̀kalẹ̀ sí orí rẹ̀ nínú iná. Èéfín náà sì ń ru sókè bí èéfín iná ìléru, gbogbo òkè náà sì mì tìtì. ");
INSERT INTO yor_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ohùn ìpè sì ń rinlẹ̀ dòdò. Mose sọ̀rọ̀, Ọlọ́run sì fi àrá dá a lóhùn. ");
INSERT INTO yor_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Olúwa sọ̀kalẹ̀ sí orí òkè Sinai, o sì pe Mose wá sí orí òkè náà. Mose sì gun orí òkè. ");
INSERT INTO yor_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Olúwa sọ fún Mose pé, “Sọ̀kalẹ̀, kí ó sì kìlọ̀ fún àwọn ènìyàn, kí wọn má ṣe fi tipátipá wá ọ̀nà láti wo Olúwa, bí wọn bá ṣe bẹ́ẹ̀, ọ̀pọ̀ wọn yóò ṣègbé. ");
INSERT INTO yor_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Kódà àwọn àlùfáà tí ó ń wá síwájú Olúwa gbọdọ̀ ya ara wọn sí mímọ́ bí bẹ́ẹ̀ kọ́. Olúwa yóò kọlù wọ́n.” ");
INSERT INTO yor_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose wí fún Olúwa pé, “Àwọn ènìyàn kì yóò lè wá sí orí òkè Sinai, nítorí ìwọ fúnra rẹ̀ ti kìlọ̀ fún wa pé, ‘Ṣe ààlà yí òkè ká, kí o sì yà á sí mímọ́.’ ” ");
INSERT INTO yor_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Olúwa sì wí fún Mose pé, “Sọ̀kalẹ̀ lọ, mú Aaroni gòkè wá pẹ̀lú rẹ. Ṣùgbọ́n kí àwọn àlùfáà àti àwọn ènìyàn má ṣe fi tipátipá gòkè tọ Olúwa. Bí bẹ́ẹ̀ kọ́ yóò kọlù wọ́n.” ");
INSERT INTO yor_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mose sọ̀kalẹ̀ tọ àwọn ènìyàn lọ. Ó sì sọ ohun tí Olúwa wí fún wọn. ");
INSERT INTO yor_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ọlọ́run sì sọ gbogbo ọ̀rọ̀ yìí pé, ");
INSERT INTO yor_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Èmi ni Olúwa Ọlọ́run yín, tí ó mú un yín jáde láti ilẹ̀ Ejibiti, láti oko ẹrú jáde wá. ");
INSERT INTO yor_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Ìwọ kò gbọdọ̀ ní ọlọ́run mìíràn pẹ̀lú mi. ");
INSERT INTO yor_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ìwọ kò gbọdọ̀ ṣe ère fún ara yín, tàbí àwòrán ohun kan tí ń bẹ ní òkè ọ̀run, tàbí ti ohun kan tí ń bẹ ní ìsàlẹ̀ ilẹ̀, tàbí ti ohun kan tí ń bẹ nínú omi ní ìsàlẹ̀ ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ìwọ kò gbọdọ̀ tẹ orí ara rẹ ba fún wọn, bẹ́ẹ̀ ni ìwọ kò gbọdọ̀ sìn wọ́n; nítorí Èmi Olúwa Ọlọ́run rẹ, Ọlọ́run owú ni mí, tí ń bẹ ẹ̀ṣẹ̀ àwọn baba wò lára àwọn ọmọ, láti ìran kẹta títí dé ẹ̀kẹrin nínú àwọn tí ó kórìíra mi. ");
INSERT INTO yor_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Èmi a sì máa fi àánú hàn sí ẹgbẹẹgbẹ̀rún àwọn tí ó fẹ́ mi, tí wọ́n sì ń pa òfin mi mọ́. ");
INSERT INTO yor_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ẹ má ṣe ṣi orúkọ Olúwa Ọlọ́run yín lò, torí pé ẹnikẹ́ni tí o bá ṣi orúkọ rẹ̀ lò kì yóò lọ láìjẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Rántí ọjọ́ ìsinmi láti yà á sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ọjọ́ mẹ́fà ni ìwọ yóò fi ṣiṣẹ́, kí ìwọ kí ó ṣe gbogbo iṣẹ́ rẹ, ");
INSERT INTO yor_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ṣùgbọ́n ọjọ́ keje ni ọjọ́ ìsinmi Olúwa Ọlọ́run rẹ: nínú rẹ̀ ìwọ kò gbọdọ̀ ṣe iṣẹ́kíṣẹ́ kan: ìwọ, àti ọmọ rẹ ọkùnrin àti ọmọ rẹ obìnrin, ọmọ ọ̀dọ̀ rẹ ọkùnrin àti ọmọ ọ̀dọ̀ rẹ obìnrin, àti ẹran ọ̀sìn rẹ, àti àlejò rẹ, tí ń bẹ nínú ibodè rẹ. ");
INSERT INTO yor_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Nítorí ní ọjọ́ mẹ́fà ni Olúwa dá ọ̀run àti ayé, òkun àti ohun gbogbo tí ń bẹ nínú wọn, ó sì sinmi ní ọjọ́ keje: nítorí náà ni Olúwa ṣe bùkún ọjọ́ ìsinmi tí ó sì yà á sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Bọ̀wọ̀ fún baba òun ìyá rẹ, kí ọjọ́ rẹ kí ó lè pẹ́ ní orí ilẹ̀ tí Olúwa Ọlọ́run rẹ fi fún ọ. ");
INSERT INTO yor_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ìwọ kò gbọdọ̀ pànìyàn. ");
INSERT INTO yor_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ìwọ kò gbọdọ̀ ṣe panṣágà. ");
INSERT INTO yor_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ìwọ kò gbọdọ̀ jalè. ");
INSERT INTO yor_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ìwọ kò gbọdọ̀ jẹ́rìí èké sí ẹnìkejì rẹ. ");
INSERT INTO yor_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ìwọ kò gbọdọ̀ ṣe ojúkòkòrò sí ilé ẹnìkéjì rẹ. Ìwọ kò gbọdọ̀ ṣe ojúkòkòrò sí aya ẹnìkéjì rẹ, ọmọ ọ̀dọ̀ rẹ̀ ọkùnrin àti ọmọ ọ̀dọ̀ rẹ̀ obìnrin, akọ màlúù rẹ̀ àti kẹ́tẹ́kẹ́tẹ́ rẹ̀ àti ohun gbogbo tí í ṣe ti ẹnìkéjì rẹ.” ");
INSERT INTO yor_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nígbà tí àwọn ènìyàn náà rí mọ̀nàmọ́ná tí wọ́n sí gbọ́ ohùn ìpè àti èéfín tí ń rú láti orí òkè, tí wọ́n sì gbọ́ sísán àrá, dídún ìpè kíkankíkan; wọ́n dúró ní òkèrè wọ́n sì ń gbọ̀n ṣìgàṣìgà fún ìbẹ̀rù. ");
INSERT INTO yor_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Wọ́n wí fún Mose pé, “Ìwọ fúnra rẹ̀ máa bá wa sọ̀rọ̀, àwa yóò sì gbọ́. Má ṣe jẹ́ kí Ọlọ́run fúnra rẹ̀ kí ó bá wa sọ̀rọ̀, bí bẹ́ẹ̀ kọ́, àwa yóò kú.” ");
INSERT INTO yor_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mose sì sọ fún àwọn ènìyàn náà pé, “Ẹ má bẹ̀rù. Ọlọ́run wá láti dán an yín wò, kí ẹ̀rù Ọlọ́run kí ó lè máa wà ní ara yín, kí ẹ̀yin kí ó má ṣe ṣẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Àwọn ènìyàn sì dúró ní òkèèrè nígbà tí Mose súnmọ́ ibi òkùnkùn biribiri níbi tí Ọlọ́run wà. ");
INSERT INTO yor_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Olúwa sì sọ fún Mose pé, “Sọ àwọn nǹkan wọ̀nyí fún àwọn ará Israẹli, ‘Ẹ̀yin ti rí i fúnra yín bí èmi ti bá a yín sọ̀rọ̀ láti ọ̀run wá. ");
INSERT INTO yor_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ẹ̀yin kò gbọdọ̀ sin ọlọ́run mìíràn pẹ̀lú mi: ẹ̀yin kò gbọdọ̀ rọ ọlọ́run fàdákà tàbí ọlọ́run wúrà fún ara yín. ");
INSERT INTO yor_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Pẹpẹ erùpẹ̀ ni kí ìwọ mọ fún mi. Ní orí pẹpẹ yìí ni kí ìwọ ti máa rú ẹbọ sísun rẹ sí mi àti ẹbọ àlàáfíà rẹ, àgùntàn rẹ, ewúrẹ́ àti akọ màlúù rẹ. Ní ibi gbogbo tí mo gbé fi ìrántí orúkọ mi sí, èmi yóò sì máa tọ̀ ọ́ wá, èmi yóò sì máa bùkún ọ níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Bí ìwọ bá ṣe pẹpẹ òkúta fún mi, má ṣe fi òkúta tí a ṣe lọ́ṣọ̀ọ́ kọ́ ọ, nítorí bí ìwọ bá lo ohun ọnà rẹ lórí rẹ̀, ìwọ sọ ọ di àìmọ́. ");
INSERT INTO yor_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ìwọ kò gbọdọ̀ gun àkàsọ̀ lọ sí ibi pẹpẹ mi, kí àwọn ènìyàn má ba à máa wo ìhòhò rẹ láti abẹ́ aṣọ tí ìwọ wọ̀ nígbà tí ìwọ bá ń gòkè lọ sí ibi pẹpẹ.’ ");
INSERT INTO yor_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Wọ̀nyí ni àwọn òfin tí ìwọ yóò gbé sí iwájú wọn. ");
INSERT INTO yor_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Bí ìwọ bá yá ọkùnrin Heberu ní ìwẹ̀fà, òun yóò sìn ọ́ fún ọdún mẹ́fà. Ṣùgbọ́n ní ọdún keje, òun yóò lọ ni òmìnira láìsan ohunkóhun padà. ");
INSERT INTO yor_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Bí ó bá wá ní òun nìkan, òun nìkan náà ni yóò padà lọ ní òmìnira; ṣùgbọ́n tí ó bá mú ìyàwó wá, ó ní láti mú ìyàwó rẹ̀ padà lọ. ");
INSERT INTO yor_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Bí olówó rẹ̀ bá fún un ní aya, tí aya náà sì bímọ ọkùnrin àti obìnrin, aya àti àwọn ọmọ rẹ̀ yóò jẹ́ ti olówó rẹ̀, yóò sì lọ ní òmìnira ní òun nìkan. ");
INSERT INTO yor_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Bí ẹrú náà bá sì wí ní gbangba pé, mo fẹ́ràn olúwa mi, ìyàwó mi àti àwọn ọmọ, èmi kò sì fẹ́ ẹ́ gba òmìnira mọ́, ");
INSERT INTO yor_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","nígbà náà ni olúwa rẹ̀ yóò mu wá sí iwájú ìdájọ́. Òun yóò sì mú un lọ sí ẹnu-ọ̀nà tàbí lọ sí ibi ọ̀wọ̀n, yóò sì fi ìlu lu etí rẹ̀, òun yóò sì máa sin olówó rẹ̀ títí ayé. ");
INSERT INTO yor_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Bí ọkùnrin kan bá ta ọmọbìnrin rẹ̀ bí ìwẹ̀fà, ọmọbìnrin yìí kò ní gba òmìnira bí i ti ọmọkùnrin. ");
INSERT INTO yor_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Bí òun kò bá sì tẹ́ olówó rẹ̀ lọ́rùn, ẹni tí ó fẹ́ ẹ fún ara rẹ̀, yóò jẹ́ kí wọn ó rà á padà, òun kò ní ẹ̀tọ́ láti tà á bí ẹrú fún àjèjì, nítorí pé òun ni kò ṣe ojúṣe rẹ̀ pẹ̀lú ìwẹ̀fà náà. ");
INSERT INTO yor_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Bí ó bá fẹ́ ẹ fún ọmọkùnrin rẹ̀, kò ní máa lò ó bí ìwẹ̀fà mọ́, ṣùgbọ́n yóò máa ṣe sí i gẹ́gẹ́ bí ọmọ rẹ̀ obìnrin. ");
INSERT INTO yor_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Bí ó bá fẹ́ obìnrin mìíràn, kò gbọdọ̀ kùnà ojúṣe rẹ̀ nípa fífún un ní oúnjẹ àti aṣọ, bẹ́ẹ̀ ni kò gbọdọ̀ kùnà ojúṣe rẹ̀ gẹ́gẹ́ bí ọkọ sí aya. ");
INSERT INTO yor_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Bí ó bá kùnà láti ṣe àwọn nǹkan mẹ́ta wọ̀nyí fún un, òun yóò lọ ní òmìnira láìsan owó kankan padà. ");
INSERT INTO yor_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Ẹnikẹ́ni tí ó bá lu arákùnrin rẹ̀ pa, pípa ni a ó pa á. ");
INSERT INTO yor_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ṣùgbọ́n bí kò bá mọ̀ ọ́n mọ̀ pa á, tí ó bá jẹ́ àmúwá Ọlọ́run ni, òun yóò lọ sí ibi tí èmi yóò yàn fún un. ");
INSERT INTO yor_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ṣùgbọ́n tí ó bá mú arákùnrin rẹ̀, tí ó sì fi ẹ̀tàn pa á. Ẹ mú un kúrò ní iwájú pẹpẹ mi kí ẹ sì pa á. ");
INSERT INTO yor_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ẹnikẹ́ni tí ó bá pa baba tàbí ìyá rẹ̀, pípa ni a ó pa á. ");
INSERT INTO yor_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ẹnikẹ́ni ti ó bá jí ènìyàn gbé, tí ó sì tà á tàbí tí ó fi pamọ́, pípa ni a ó pa á. ");
INSERT INTO yor_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ẹnikẹ́ni tí ó bá ṣépè fún baba tàbí ìyá rẹ̀, pípa ni a ó pa á. ");
INSERT INTO yor_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Bí àwọn ọkùnrin méjì bá ń jà, ti ọ̀kan sọ òkúta tàbí fi ìkùùkuu lu ẹnìkejì rẹ̀, tí ó sì pa á lára, ti irú ìpalára bẹ́ẹ̀ mu kí ó wà lórí ìdùbúlẹ̀ àìsàn. ");
INSERT INTO yor_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Ẹni tó lu ẹnìkejì rẹ̀ kò ní ní ẹ̀bi, níwọ̀n ìgbà ti ẹni tí a lù bá ti lè dìde, tí ó sì lé è fi ọ̀pá ìtìlẹ̀ ní ọwọ́ rẹ̀ rìn káàkiri. Ẹni náà ni láti san owó ti ó fi tọ́jú ara rẹ̀ padà fún un, lẹ́yìn ìgbà tí ara rẹ̀ bá ti yá tan pátápátá. ");
INSERT INTO yor_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Bí ọkùnrin kan bá fi ọ̀pá lu ẹrúkùnrin tàbí ẹrúbìnrin rẹ̀, ti ẹrú náà sì kú lójú ẹsẹ̀, a ó fi ìyà jẹ ẹ́. ");
INSERT INTO yor_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ṣùgbọ́n a kò ní fi ìyà jẹ ẹ́, ti ẹrú náà bá yè, tí ó dìde lẹ́yìn ọjọ́ kan tàbí méjì, nítorí ẹrú náà jẹ́ dúkìá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Bí àwọn ènìyàn ti ń jà bá pa aboyún lára, tí aboyún náà bá bímọ láìpé ọjọ́, ṣùgbọ́n tí kò sí aburú mìíràn mọ́ lẹ́yìn rẹ̀, ẹni tí ó fa ìpalára yìí yóò san iyekíye tí ọkọ aboyún náà bá béèrè fún, bí ilé ẹjọ́ bá ṣe gbà láààyè gẹ́gẹ́ bí owó ìtánràn. ");
INSERT INTO yor_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ṣùgbọ́n bí ìpalára náà bá yọrí sí ikú aboyún náà, pípa ni a ó pa ẹni ti ó fa ikú aboyún náà. ");
INSERT INTO yor_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ojú fún ojú, eyín fún eyín, ọwọ́ fún ọwọ́, ẹsẹ̀ fún ẹsẹ̀, ");
INSERT INTO yor_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ìjóná fún ìjóná, ọgbẹ́ fún ọgbẹ́, ìnà fún ìnà. ");
INSERT INTO yor_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Bí ọkùnrin kan bá lu ẹrúkùnrin tàbí ẹrúbìnrin rẹ̀ ní ojú, ti ojú náà sì fọ́, ó ni láti jẹ́ kí ẹrú náà lọ ní òmìnira fún ìtánràn ojú rẹ̀ ti ó fọ́. ");
INSERT INTO yor_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Bí ó bá sì lu ẹrúkùnrin tàbí ẹrúbìnrin rẹ̀ ti eyín rẹ̀ fi ká, ó ni láti jẹ́ kí ó lọ ní òmìnira ni ìtánràn fún eyín rẹ̀ tí ó ká. ");
INSERT INTO yor_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Bí akọ màlúù bá kan ọkùnrin tàbí obìnrin kan pa, a ó sọ akọ màlúù náà ní òkúta pa, a kò sì gbọdọ̀ jẹ ẹran rẹ̀. Ṣùgbọ́n a kò ní dá ẹni tí ó ni akọ màlúù náà lẹ́bi, ọrùn oní akọ màlúù náà yóò sì mọ́. ");
INSERT INTO yor_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ṣùgbọ́n tí ó bá ti di ìgbà gbogbo ti akọ màlúù náà ti máa ń kan ènìyàn, tí a sì ti ń kìlọ̀ fún olówó rẹ̀, ti olówó rẹ̀ kò sì mú un so, tí ó bá kan ọkùnrin tàbí obìnrin pa, a ó sọ akọ màlúù náà ní òkúta pa, a ó sì pa olówó rẹ̀ pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Bí àwọn ará ilé ẹni tí ó kú bá béèrè fún owó ìtánràn, yóò san iye owó tí wọ́n bá ní kí ó san fún owó ìtánràn láti fi ra ẹ̀mí ara rẹ̀ padà. ");
INSERT INTO yor_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Bí akọ màlúù bá kan ọmọkùnrin tàbí ọmọbìnrin pa, a ó ṣe gẹ́gẹ́ bí òfin yìí ti là á kalẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Bí akọ màlúù bá kan ẹrúkùnrin tàbí ẹrúbìnrin pa, olówó rẹ̀ yóò san ọgbọ̀n ṣékélì fàdákà fún ẹni tó ni ẹrú, a ó sì sọ akọ màlúù náà ni òkúta pa. ");
INSERT INTO yor_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Bí ọkùnrin kan bá ṣí kòtò sílẹ̀ láìbò tàbí kí ó gbẹ́ kòtò sílẹ̀ láìbò, tí màlúù tàbí kẹ́tẹ́kẹ́tẹ́ bá ṣe bẹ́ẹ̀ bọ́ sínú kòtò náà. ");
INSERT INTO yor_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Ẹni tí ó ni kòtò yóò san owó àdánù yìí fún ẹni tí ó ni ẹran. Òkú ẹran náà yóò sì di tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Bí akọ màlúù ọkùnrin kan bá pa akọ màlúù ẹlòmíràn lára tí ó sì kú, wọn yóò ta akọ màlúù tó wà láààyè, wọn yóò sì pín owó èyí tiwọn tà àti ẹran èyí tí ó kú dọ́gbadọ́gba. ");
INSERT INTO yor_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ṣùgbọ́n tí ó bá ti di ìgbà gbogbo tí akọ màlúù náà máa ń kan òmíràn, tí olówó rẹ̀ kò sì mú un so, olówó rẹ̀ yóò san ẹran dípò ẹran. Ẹran tí ó kú yóò sì jẹ́ tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Bí ọkùnrin kan bá jí akọ màlúù tàbí àgùntàn, tí ó sì pa á tàbí tà á. Ó gbọdọ̀ san akọ màlúù márùn-ún padà fún ọ̀kan tí ó jí, àti àgùntàn mẹ́rin mìíràn fún ọ̀kan tí ó jí. ");
INSERT INTO yor_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Bí a bá mú olè níbi ti ó ti ń fọ́lé, ti a sì lù ú pa, ẹni tí ó lù ú pa náà kò ní ẹ̀bi ìtàjẹ̀ sílẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ṣùgbọ́n ti ó bá ṣẹlẹ̀ ni ojú ọ̀sán, a ó kà á si ìpànìyàn. Ọkùnrin ti ó lù ú pa náà yóò ni ẹ̀bi ìtàjẹ̀ sílẹ̀. “Olè gbọdọ̀ san ohun tí ó jí padà. Ṣùgbọ́n tí kò bá ni ohun ti ó lè fi san án padà, a ó tà á, a ó sì fi sanwó ohun tí ó jí gbé padà. ");
INSERT INTO yor_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Bí a bá rí ẹran tí ó jí gbé náà ni ọwọ́ rẹ̀ ní ààyè: ìbá ṣe akọ màlúù, akọ kẹ́tẹ́kẹ́tẹ́ tàbí àgùntàn, yóò san án padà ní ìlọ́po méjì. ");
INSERT INTO yor_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Bí ọkùnrin kan bá ń bọ́ ẹran ọ̀sìn rẹ̀ lórí pápá tàbí nínú ọgbà àjàrà, tí ó sì jẹ́ kí ó lọ jẹ nínú oko ẹlòmíràn, a ó mú kí ó san ohun ti ẹran rẹ̀ jẹ padà pẹ̀lú èyí tí ó dára jù nínú oko tàbí nínú ọgbà rẹ̀ (ẹlòmíràn padà fún un). ");
INSERT INTO yor_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Bí iná bá ṣẹ́ tí ó kán lu igbó tí ó sì jó àká ọkà tàbí gbogbo oko náà, ẹni tí iná ṣẹ́ lọ́wọ́ rẹ̀ yóò san ohun tí iná ti ó ṣẹ́ jó padà. ");
INSERT INTO yor_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Bí ọkùnrin kan bá fún aládùúgbò rẹ̀ ní fàdákà tàbí ohun èlò fún ìtọ́jú, ti wọ́n sì jí gbé lọ́dọ̀ aládùúgbò rẹ̀, tí a bá mú irú olè bẹ́ẹ̀, yóò san án padà ní ìlọ́po méjì. ");
INSERT INTO yor_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ṣùgbọ́n ti a kò bá rí olè náà mú, baálé ilé náà yóò fi ara hàn níwájú ìdájọ́ láti jẹ́ kí a mọ̀ bí òun fúnra rẹ̀ ni ó gbé ohun ti ó sọnù náà. ");
INSERT INTO yor_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Bí ẹnìkan bá ni akọ màlúù, kẹ́tẹ́kẹ́tẹ́, àgùntàn, aṣọ tàbí ohun ìní mìíràn tí ó sọnù ní ọ̀nà ti kò bá òfin mu, tí a sì rí ẹni ti ó sọ pé òun ni ó ní ín, àwọn méjèèjì yóò mú ẹjọ́ wọn wá sí iwájú adájọ́. Ẹnikẹ́ni tí adájọ́ bá dá lẹ́bi yóò san án ni ìlọ́po méjì padà fún ẹnìkejì rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Bí ẹnikẹ́ni bá fún aládùúgbò rẹ̀ ní kẹ́tẹ́kẹ́tẹ́, akọ màlúù, àgùntàn tàbí ẹranko mìíràn láti bá òun tọ́jú rẹ̀, tí ó sì kú, tàbí tí ó fi ara pa, tàbí tí a jí gbé, níbi tí kò ti sí ẹni tí o ṣe àkíyèsí. ");
INSERT INTO yor_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Wọn yóò búra sí ọ̀rọ̀ náà láàrín ara wọn ni iwájú Olúwa láti fihàn pé òun kò ní ọwọ́ nínú sísọnù ohun ọ̀sìn náà, olóhun gbọdọ̀ gba bẹ́ẹ̀, a kò sì ní san ohunkóhun fún un. ");
INSERT INTO yor_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ṣùgbọ́n ti wọ́n bá jí ẹranko náà gbé ni ọ̀dọ̀ aládùúgbò rẹ̀, yóò san ẹ̀san padà fún olúwa rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Bí ẹranko búburú bá fà á ya, ó ní láti mú àyakù ẹran náà wá gẹ́gẹ́ bí ẹ̀rí, kò sì ní san ẹran náà padà. ");
INSERT INTO yor_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Bí ẹnìkan bá sì yá ẹranko lọ́dọ̀ aládùúgbò rẹ̀, tí ẹranko náà sì fi ara pa, tàbí kí ó kú nígbà tí ẹni tí ó ni í kò sí nítòsí. O gbọdọ̀ san án padà. ");
INSERT INTO yor_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ṣùgbọ́n ti ó bá jẹ́ wí pé olóhun bá wà pẹ̀lú ẹranko náà, ẹni tí ó ya lò kò ní san ẹ̀san padà. Bí a bá yá ẹranko náà lò, owó tí ó fi yá a lò ni yóò fi tan àdánù ẹranko tí ó kú. ");
INSERT INTO yor_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Bí ọkùnrin kan bá fi àrékérekè mú wúńdíá kan, ẹni tí kò pinnu láti fẹ́, tí ó sì bá a lòpọ̀, yóò san owó orí rẹ̀, yóò sì fi ṣe aya rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Bí baba ọmọbìnrin náà bá kọ̀ jálẹ̀ láti fi fún un ní aya, ó ni láti san owó tó tó owó orí rẹ̀ fún fífẹ́ ẹ ní wúńdíá. ");
INSERT INTO yor_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Má ṣe jẹ́ kí àjẹ́ kí ó wà láààyè. ");
INSERT INTO yor_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ẹnikẹ́ni ti ó bá bá ẹranko lòpọ̀ ní a ó pa. ");
INSERT INTO yor_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Ẹnikẹ́ni ti ó bá rú ẹbọ sí òrìṣà yàtọ̀ sí Olúwa nìkan, ni a ó yà sọ́tọ̀ fún ìparun. ");
INSERT INTO yor_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Ẹ má ṣe fi ìyà jẹ àlejò tàbí ni wọ́n lára, nítorí ìwọ pẹ̀lú ti jẹ́ àjèjì ni ilẹ̀ Ejibiti rí. ");
INSERT INTO yor_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Má ṣe yan opó tàbí ọmọ òrukàn jẹ. ");
INSERT INTO yor_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Bí ìwọ bá ṣe bẹ́ẹ̀, bí wọn bá ké pè mi. Èmi yóò sì gbọ́ ohùn igbe wọn. ");
INSERT INTO yor_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ìbínú mi yóò ru sókè. Èmi yóò sì fi idà pa ọ. Ìyàwó rẹ yóò di opó, àwọn ọmọ rẹ yóò sì di aláìní baba. ");
INSERT INTO yor_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Bí ìwọ bá yá ọ̀kan nínú àwọn ènìyàn mi tí ìyà ń jẹ láàrín yín lówó, má ṣe dàbí ayánilówó, kí o má sì gba èlé. ");
INSERT INTO yor_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Bí ìwọ bá gba aṣọ aládùúgbò rẹ ni ẹ̀jẹ́, ìwọ gbọdọ̀ fún un padà kí oòrùn tó ó wọ̀, ");
INSERT INTO yor_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","nítorí aṣọ yìí nìkan ní ó ní ti ó lè fi bo àṣírí ara. Kí ni ohun mìíràn ti yóò fi sùn? Nígbà ti ó bá gbé ohun rẹ̀ sókè sí mi, èmi yóò gbọ́ nítorí aláàánú ni èmi. ");
INSERT INTO yor_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Ìwọ kò gbọdọ̀ sọ̀rọ̀-òdì sí Ọlọ́run tàbí gégùn lé orí ìjòyè àwọn ènìyàn rẹ. ");
INSERT INTO yor_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Ìwọ kò gbọdọ̀ lọ́ra láti mú ọrẹ wá fún mi láti inú ìre oko rẹ àti láti inú wáìnì rẹ. “Àkọ́bí ọmọ rẹ ọkùnrin ni ìwọ yóò fi fún mi. ");
INSERT INTO yor_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ṣe bẹ́ẹ̀ gẹ́gẹ́ pẹ̀lú agbo màlúù rẹ àti agbo àgùntàn rẹ. Jẹ́ kí wọn wà lọ́dọ̀ ìyá wọn fún ọjọ́ méje, kí ìwọ kí ó sì fi wọ́n fún mi ní ọjọ́ kẹjọ. ");
INSERT INTO yor_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Ẹ̀yin yóò jẹ́ ènìyàn mímọ́ mi. Nítorí náà má ṣe jẹ ẹran ti ẹranko búburú fàya: ẹ fi fún ajá jẹ. ");
INSERT INTO yor_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Ìwọ kò gbọdọ̀ tan ìròyìn èké kalẹ̀. Ìwọ kò gbọdọ̀ ran ènìyàn búburú lọ́wọ́ láti jẹ́rìí èké. ");
INSERT INTO yor_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Ìwọ kò gbọdọ̀ tẹ̀lé ọ̀pọ̀ ènìyàn láti ṣe aburú. Nígbà tí ìwọ bá jẹ́rìí sí ẹjọ́, ìwọ kò gbọdọ̀ yí ìdájọ́ po nípa gbígbé lẹ́yìn ọ̀pọ̀ ènìyàn. ");
INSERT INTO yor_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Bẹ́ẹ̀ ni ìwọ kò gbọdọ̀ ṣe ojúsàájú sí tálákà nínú ẹjọ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Bí ìwọ bá ṣe alábàápàdé akọ màlúù tàbí akọ kẹ́tẹ́kẹ́tẹ́ ọ̀tá rẹ tí ó ṣìnà lọ, rí i dájú pé o mú un padà wá fún un. ");
INSERT INTO yor_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Bí ìwọ bá rí kẹ́tẹ́kẹ́tẹ́ ẹnìkan tí ó kórìíra rẹ tí ẹrù ṣubú lé lórí, má ṣe fi í sílẹ̀ bẹ́ẹ̀; rí i dájú pé o ran án lọ́wọ́ nípa rẹ. ");
INSERT INTO yor_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Ìwọ kò gbọdọ̀ du aláìní ní ìdájọ́ òdodo. ");
INSERT INTO yor_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Má ṣe lọ́wọ́ nínú ẹ̀sùn èké, bẹ́ẹ̀ ni ìwọ kò gbọdọ̀ pa aláìṣẹ̀ tàbí olódodo ènìyàn, nítorí Èmi kò ní dá ẹlẹ́bi láre. ");
INSERT INTO yor_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Ìwọ kò gbọdọ̀ gba àbẹ̀tẹ́lẹ̀, nítorí pé àbẹ̀tẹ́lẹ̀ ń fọ́ ojú ọlọ́gbọ́n, ó sì ń ba ọ̀rọ̀ olódodo jẹ́. ");
INSERT INTO yor_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Ìwọ kò gbọdọ̀ pọ́n àjèjì kan lójú, ẹ̀yin sa ti mọ inú àjèjì, nítorí ẹ̀yin náà ti jẹ́ àjèjì ní ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Ní ọdún mẹ́fà ni ìwọ yóò gbin oko rẹ, ìwọ yóò sì kóre èso rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ṣùgbọ́n ní ọdún keje, jẹ́ kí ilẹ̀ náà wà ní àìkọ àti ní àìlò, jẹ́ kí ilẹ̀ náà kí ó sinmi. Nígbà náà ni tálákà láàrín yín yóò rí oúnjẹ láti ibẹ̀. Ẹranko igbó yóò sì jẹ èyí tí wọ́n fi sílẹ̀. Ìwọ ṣe bákan náà pẹ̀lú ọgbà àjàrà rẹ àti ọgbà olifi rẹ. ");
INSERT INTO yor_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ọjọ́ mẹ́fà ni ìwọ yóò ṣe iṣẹ́ rẹ, ìwọ yóò sì sinmi ní ọjọ́ keje, kí akọ màlúù àti kẹ́tẹ́kẹ́tẹ́ rẹ bá à lè ní ìsinmi, kí a sì tú ọmọ ìránṣẹ́bìnrin rẹ àti àlejò ti ń gbé ni ilé rẹ lára. ");
INSERT INTO yor_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Ẹ máa ṣọ́ra, kí ẹ sì ṣe ohun gbogbo tí mo wí fún un yín. Ẹ má ṣe pe orúkọ òrìṣà, kí a má ṣe gbọ́ orúkọ wọn ní ẹnu yín. ");
INSERT INTO yor_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ní ìgbà mẹ́ta ni ìwọ yóò ṣe àjọ fún mi nínú ọdún. ");
INSERT INTO yor_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Ṣe àjọ àkàrà àìwú; jẹ àkàrà ti kò ní ìwúkàrà fún ọjọ́ méje, bí mo ṣe pàṣẹ fún ọ. Ṣe èyí ní àkókò tí a ti yàn ní oṣù Abibu, nítorí ni oṣù yìí ni ìwọ jáde kúrò ni ilẹ̀ Ejibiti. “Ẹnikẹ́ni kò gbọdọ̀ wá sí iwájú mi ní ọwọ́ òfo. ");
INSERT INTO yor_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Ṣe àjọ ìkórè pẹ̀lú èso àkọ́so ọ̀gbìn oko rẹ. “Ṣe àjọ àkójọ oko rẹ ní òpin ọdún, nígbà tí ìwọ bá kó ìre oko rẹ jọ tan. ");
INSERT INTO yor_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Ní ìgbà mẹ́ta ọ̀tọ̀ọ̀tọ̀ ni àwọn ọkùnrin yín yóò máa wá fi ara hàn ní iwájú Olúwa Olódùmarè. ");
INSERT INTO yor_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Ìwọ kò gbọdọ̀ rú ẹbọ ẹ̀jẹ̀ sí mi ti òun ti àkàrà tó ní ìwúkàrà. “Bẹ́ẹ̀ ni ọ̀rá ẹbọ àjọ mi ni kò gbọdọ̀ kù títí di òwúrọ̀. ");
INSERT INTO yor_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Mú àkọ́ká èso ilẹ̀ rẹ tí ó dára jùlọ wá sí ilé Olúwa Ọlọ́run rẹ. “Ìwọ kò gbọdọ̀ bọ ọmọ ewúrẹ́ nínú omi ọmú ìyá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Kíyèsi èmi rán angẹli kan lọ ní iwájú rẹ, láti ṣọ́ ọ ni ọ̀nà àti láti mú ọ dé ibi ti mo ti pèsè sílẹ̀ fún. ");
INSERT INTO yor_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Fi ara balẹ̀, kí o sì fetísílẹ̀ sí i, kí o sì gba ohùn rẹ̀ gbọ́; má ṣe ṣọ̀tẹ̀ sí i, nítorí kò ní fi àìṣedéédéé yín jì yín, orúkọ mi wà lára rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Bí ìwọ bá fetísílẹ̀ dáradára sí ohùn rẹ̀ tí ẹ sì ṣe ohun gbogbo ti mo ní kí ẹ ṣe, èmi yóò jẹ́ ọ̀tá àwọn ọ̀tá yín. Èmi yóò sì fóòro àwọn tí ń fóòro yín. ");
INSERT INTO yor_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Angẹli mi yóò lọ níwájú rẹ, yóò sì mú ọ dé ọ̀dọ̀ àwọn ará: Amori, Hiti, Peresi, Kenaani, Hifi àti Jebusi, èmi a sì gé wọn kúrò. ");
INSERT INTO yor_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ìwọ kò gbọdọ̀ foríbalẹ̀ fún òrìṣà wọn, bẹ́ẹ̀ ni, ìwọ kò gbọdọ̀ sìn wọ́n, tàbí kí ẹ tẹ̀lé ìṣe wọn. Kí ìwọ kí ó si wó wọn lulẹ̀, kí ìwọ kí ó sì fọ́ ère òkúta wọ́n túútúú. ");
INSERT INTO yor_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ẹ̀yin yóò sí máa sin Olúwa Ọlọ́run yin, òun yóò si bùsi oúnjẹ rẹ. Èmi yóò mú àìsàn kúrò láàrín rẹ. ");
INSERT INTO yor_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Oyún kò ní bàjẹ́ lára obìnrin kan, bẹ́ẹ̀ ni obìnrin kan kì yóò yàgàn ni ilẹ̀ rẹ. Èmi yóò fún ọ ní ẹ̀mí gígùn. ");
INSERT INTO yor_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Èmi yóò rán ẹ̀rù mi lọ ṣáájú rẹ, ìdàrúdàpọ̀ yóò sì wà láàrín àwọn orílẹ̀-èdè tí ẹ bá da ojú kọ. Èmi yóò mú kí àwọn ọ̀tá rẹ yí ẹ̀yìn padà sí ọ, kí wọn sì sá ní iwájú rẹ. ");
INSERT INTO yor_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Èmi yóò rán oyin ṣáájú rẹ láti lé àwọn ará: Hifi, Kenaani àti Hiti kúrò ni ọ̀nà rẹ. ");
INSERT INTO yor_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ṣùgbọ́n, Èmi kò ni lé gbogbo wọn jáde ni ọdún kan ṣoṣo, ki ilẹ̀ náà má ba à di ahoro, àwọn ẹranko búburú yóò sì ti pọ̀jù fún ọ. ");
INSERT INTO yor_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Díẹ̀díẹ̀ ni èmi yóò máa lé wọn jáde kúrò ní iwájú rẹ, títí ìwọ yóò fi pọ̀ tó láti gba gbogbo ilẹ̀ náà gẹ́gẹ́ bí ìní. ");
INSERT INTO yor_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Èmi yóò fi ìdí òpin ààlà ilẹ̀ rẹ lélẹ̀ láti etí Òkun Pupa títí dé òkun àwọn ara Filistini, láti aṣálẹ̀ títí dé etí odò Eufurate, Èmi yóò fa àwọn ènìyàn ti ń gbé ilẹ̀ náà lé ọ lọ́wọ́, ìwọ yóò sì lé wọn jáde kúrò ní iwájú rẹ. ");
INSERT INTO yor_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ìwọ kò gbọdọ̀ dá májẹ̀mú kankan pẹ̀lú wọn tàbí pẹ̀lú àwọn òrìṣà wọn. ");
INSERT INTO yor_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ìwọ kò gbọdọ̀ jẹ́ kí wọn gbé ni ilẹ̀ rẹ, bí bẹ́ẹ̀ kọ́, wọn yóò mú ọ dẹ́ṣẹ̀ sí mi: nítorí bí ìwọ bá sin òrìṣà wọn, èyí yóò jẹ́ ìdẹ̀kùn fun ọ nítòótọ́.” ");
INSERT INTO yor_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ní ìgbà náà ni Olúwa sọ fún Mose pé, “Gòkè tọ Olúwa wá, ìwọ àti Aaroni, Nadabu àti Abihu àti àádọ́rin àwọn àgbàgbà Israẹli. Ẹ̀yin kì ó sìn ni òkèèrè réré. ");
INSERT INTO yor_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ṣùgbọ́n Mose nìkan ṣoṣo ni yóò súnmọ́ Olúwa; àwọn tókù kò gbọdọ̀ súnmọ́ tòsí ibẹ̀. Bẹ́ẹ̀ ni àwọn ènìyàn kò gbọdọ̀ gòkè wá pẹ̀lú rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Nígbà ti Mose lọ láti sọ fún àwọn ènìyàn, gbogbo ọ̀rọ̀ àti òfin Olúwa, wọ́n wí ní ohùn kan pé, “Gbogbo ohun ti Olúwa wí ni àwa yóò ṣe.” ");
INSERT INTO yor_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Nígbà náà ni Mose kọ gbogbo ohun tí Olúwa sọ sílẹ̀. Ó dìde ní kùtùkùtù òwúrọ̀ ọjọ́ kejì, ó sì mọ pẹpẹ ni ẹsẹ̀ òkè náà. Ó ṣe ọ̀wọ́n òkúta méjìlá. Èyí ti ó dúró fún àwọn ẹ̀yà Israẹli méjìlá. ");
INSERT INTO yor_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Nígbà náà ni ó rán àwọn ọ̀dọ́mọkùnrin Israẹli, wọ́n sì rú ẹbọ sísun, wọ́n fi ọ̀dọ́ màlúù rú ẹbọ àlàáfíà si Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mose bu ìlàjì ẹ̀jẹ̀ ẹran sínú abọ́, ó sì fi ìlàjì tókù wọn ara pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Nígbà náà ni ó sì mú ìwé májẹ̀mú, ó sì kà á sí àwọn ènìyàn. Wọ́n dáhùn pé, “Àwa yóò ṣe gbogbo ohun tí Olúwa wí. Àwa yóò sì gbọ́rọ̀.” ");
INSERT INTO yor_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Nígbà náà ni Mose gbé ẹ̀jẹ̀, ó sì wọn sí àwọn ènìyàn náà lára pé, “Èyí ni ẹ̀jẹ̀ májẹ̀mú tí Olúwa ti ṣe pẹ̀lú yín ni ìbámu pẹ̀lú àwọn ọ̀rọ̀ wọ̀nyí.” ");
INSERT INTO yor_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mose àti Aaroni, Nadabu àti Abihu àti àádọ́rin àwọn àgbàgbà Israẹli gòkè lọ. ");
INSERT INTO yor_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Wọ́n sì rí Ọlọ́run Israẹli. Ní abẹ́ ẹsẹ̀ rẹ̀ ni ohun kan bí i pèpéle ti a fi òkúta safire ṣe wà. Èyí ti ó mọ́ nigínnigín bí àwọ̀ sánmọ̀ fúnra rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ṣùgbọ́n Ọlọ́run kò gbé ọwọ́ rẹ̀ sókè sí àwọn àgbàgbà Israẹli wọ̀nyí; wọ́n ri Ọlọ́run, wọ́n jẹ, wọ́n sì mu. ");
INSERT INTO yor_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Olúwa sì sọ fún Mose pé, “Gòkè wá sí ọ̀dọ̀ mi, kí o sì dúró níhìn-ín. Èmi yóò sì fún ọ ní wàláà òkúta pẹ̀lú òfin àti ìlànà tí mo ti kọ sílẹ̀ fún ìtọ́sọ́nà wọn.” ");
INSERT INTO yor_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Nígbà náà ni Mose jáde lọ pẹ̀lú Joṣua arákùnrin rẹ̀. Mose lọ sí orí òkè Ọlọ́run. ");
INSERT INTO yor_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ó sì wí fún àwọn àgbàgbà pé, “Ẹ dúró dè wá níhìn-ín yìí, títí àwa yóò fi tún padà tọ̀ yín wá, sì kíyèsi i, Aaroni àti Huri ń bẹ pẹ̀lú yín, bí ẹnìkan bá ni ọ̀ràn kan, kí ó tọ̀ wọ́n lọ.” ");
INSERT INTO yor_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Nígbà tí Mose gun orí òkè lọ, ìkùùkuu bo orí òkè náà. ");
INSERT INTO yor_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ògo Olúwa sì wà ní orí òkè Sinai. Ìkùùkuu bo orí òkè náà fún ọjọ́ mẹ́fà, ni ọjọ́ keje ni Olúwa kọ sí Mose láti inú ìkùùkuu náà wá. ");
INSERT INTO yor_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ni ojú àwọn ọmọ Israẹli ògo Olúwa náà dàbí iná ajónirun ni orí òkè. ");
INSERT INTO yor_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Nígbà náà ni Mose wọ inú ìkùùkuu náà bí ó ti ń lọ ní orí òkè. Ó sì wà ni orí òkè náà ni ogójì ọ̀sán àti ogójì òru. ");
INSERT INTO yor_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Olúwa sì wí fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Sọ fún àwọn ọmọ Israẹli kí wọn mú ọrẹ wá fún mi, ìwọ yóò gba ọrẹ náà fún mi ni ọwọ́ ọkùnrin kọ̀ọ̀kan ti ọkàn rẹ bá fẹ́ láti fi fún mi. ");
INSERT INTO yor_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Wọ̀nyí ni ọrẹ ti ìwọ yóò gbà ni ọwọ́ wọn: “wúrà, fàdákà àti idẹ; ");
INSERT INTO yor_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","aṣọ aláró, elése àlùkò, òdòdó, ọ̀gbọ̀; irun ewúrẹ́. ");
INSERT INTO yor_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Awọ àgbò tí a rẹ ní pupa àti awọ ewúrẹ́ igbó; igi kasia; ");
INSERT INTO yor_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Òróró olifi fún iná títàn; òróró olóòórùn dídùn fún ìtasórí àti fún tùràrí olóòórùn dídùn; ");
INSERT INTO yor_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","àti òkúta óníkìsì àti òkúta olówó iyebíye ti a fi ṣe ọ̀ṣọ́ sí ara ẹ̀wù efodu àti ẹ̀wù ìgbàyà. ");
INSERT INTO yor_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Nígbà náà ni ìwọ yóò jẹ́ kí wọn kọ́ ibi mímọ́ fún mi. Èmi yóò sì máa gbé ní àárín wọn. ");
INSERT INTO yor_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Gẹ́gẹ́ bí gbogbo èyí ti mo fihàn ọ́, nípa àpẹẹrẹ àgọ́, àti àpẹẹrẹ gbogbo ohun èlò inú rẹ̀, bẹ́ẹ̀ ni kí ẹ̀yin kí ó sì ṣe é. ");
INSERT INTO yor_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Wọn yóò sì fi igi ṣittimu ṣe àpótí, ìgbọ̀nwọ́ méjì ààbọ̀ ni gígùn rẹ̀, ìgbọ̀nwọ́ kan ààbọ̀ ni fífẹ̀ rẹ̀, ìgbọ̀nwọ́ kan ààbọ̀ ni gíga rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ìwọ ó sì fi ojúlówó wúrà, bò ó ní inú àti ní òde, ìwọ ó sì fi wúrà gbá etí rẹ̀ yíká. ");
INSERT INTO yor_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ìwọ ó sì da òrùka wúrà mẹ́rin fún. Ìwọ ó sì fi wọ́n sí igun mẹ́rẹ̀ẹ̀rin ẹsẹ̀ rẹ̀, òrùka wúrà méjì yóò wà ní ẹ̀gbẹ́ kìn-ín-ní, òrùka wúrà méjì yóò wà ní ẹgbẹ́ kejì. ");
INSERT INTO yor_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ìwọ ó sì fi igi kasia ṣe ọ̀pá mẹ́rin, ìwọ ó sì fi wúrà bò wọ́n. ");
INSERT INTO yor_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ìwọ ó sì fi ọ̀pá náà bọ òrùka ní ẹ̀gbẹ́ kọ̀ọ̀kan àpótí ẹ̀rí náà láti fi gbé e. ");
INSERT INTO yor_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Òpó náà yóò wá nínú òrùka lára àpótí ẹ̀rí; a kò ní yọ wọ́n kúrò. ");
INSERT INTO yor_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Nígbà náà ni ìwọ yóò fi ẹ̀rí ti èmi yóò fi fún ọ sínú àpótí náà. ");
INSERT INTO yor_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Ìwọ ó sì fi ojúlówó wúrà ṣe ìtẹ́ àánú; ìgbọ̀nwọ́ méjì àti ààbọ̀ ní gígùn àti ìgbọ̀nwọ́ kan àti ààbọ̀ ní fífẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ìwọ ó sì ṣe kérúbù méjì láti inú wúrà tí a fi òòlù sí igun ìtẹ́ àánú náà. ");
INSERT INTO yor_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ìwọ ó ṣe kérúbù kan sí igun kìn-ín-ní àti kérúbù kejì sí igun kejì, kí kérúbù náà jẹ́ irú kan náà ní igun méjèèjì pẹ̀lú ìbòrí wọn. ");
INSERT INTO yor_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Àwọn kérúbù sì na ìyẹ́ apá wọn sókè, tí wọn yóò sì fi ìyẹ́ apá wọn ṣe ibòòji sí orí ìtẹ́ àánú. Àwọn kérúbù náà yóò kọ ojú sí ara wọn, wọn yóò máa wo ọ̀kánkán ìtẹ́. ");
INSERT INTO yor_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Gbé ọmọrí orí àpótí ẹ̀rí kí o sì fi ẹ̀rí èyí tí èmí yóò fi fún ọ sínú àpótí ẹ̀rí. ");
INSERT INTO yor_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Níbẹ̀, ni òkè ìtẹ́, ní àárín kérúbù méjèèjì ti ó wà ni orí àpótí ẹ̀rí ni èmi yóò ti pàdé rẹ, ti èmi yóò sì fún ọ ní àwọn òfin mi fún àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Fi igi kasia kan tábìlì: ìgbọ̀nwọ́ méjì ní gígùn ìgbọ̀nwọ́ kan ní fífẹ̀, ìgbọ̀nwọ́ kan àti ààbọ̀ ní gíga. ");
INSERT INTO yor_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ìwọ ó sì fi ojúlówó wúrà bò ó, ìwọ ó sì ṣe ìgbátí wúrà yí i ká. ");
INSERT INTO yor_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ìwọ sì ṣe etí kan ní ìbú àtẹ́lẹwọ́ sí i yíká, ó sì ṣe ìgbátí wúrà yí etí rẹ̀ ká. ");
INSERT INTO yor_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ìwọ ó sì da òrùka wúrà mẹ́rin fún tábìlì náà, ìwọ ó sì fi òrùka kọ̀ọ̀kan sí igun mẹ́rẹ̀ẹ̀rin tí ó wà ní ẹsẹ̀ rẹ̀ mẹ́rẹ̀ẹ̀rin. ");
INSERT INTO yor_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ní abẹ́ ìgbátí náà ni àwọn òrùka náà yóò wà fún ibi ọ̀pá láti máa fi gbé tábìlì náà. ");
INSERT INTO yor_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ìwọ ó sì fi igi kasia ṣe àwọn ọ̀pá, ìwọ ó sì fi wúrà bò wọ́n, láti máa fi wọ́n gbé tábìlì náà. ");
INSERT INTO yor_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ìwọ ó sì fi ojúlówó wúrà ṣe àwo àti ṣíbí rẹ̀, kí o sì ṣe àwokòtò àti ago pẹ̀lú fún dída ọrẹ jáde. ");
INSERT INTO yor_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Gbé àkàrà ìfihàn sí orí tábìlì yìí, kí ó le wà ní iwájú mi ni gbogbo ìgbà. ");
INSERT INTO yor_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Ìwọ ó sì ojúlówó wúrà, lù ú dáradára, ṣe ọ̀pá fìtílà kan, ìsàlẹ̀ àti apá rẹ̀, kọ́ọ̀bù rẹ̀ ti ó dàbí òdòdó, ìṣọ àti ìtànná rẹ̀ yóò jẹ́ ara kan náà pẹ̀lú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ẹ̀ka mẹ́fà ni yóò yọ ní ẹ̀gbẹ́ ọ̀pá fìtílà: mẹ́ta ní ẹ̀gbẹ́ kìn-ín-ní mẹ́ta ni ẹ̀gbẹ́ kejì. ");
INSERT INTO yor_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Àwo mẹ́ta ni kí a ṣe bí ìtànná almondi, tí ó ṣọ tí ó sì tanná ni yóò wà ni ẹ̀ka kan, mẹ́ta yóò sì wà ní ẹ̀ka kejì, àti bẹ́ẹ̀ fún àwọn ẹ̀ka mẹ́fẹ̀ẹ̀fà tí ó jáde lára ọ̀pá fìtílà. ");
INSERT INTO yor_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ní ara ọ̀pá fìtílà ni àwo mẹ́rin ti a ṣe gẹ́gẹ́ bí òdòdó almondi ti ó ni ìṣọ àti ìtànná yóò wà. ");
INSERT INTO yor_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Irúdì kan yóò sì wà ní abẹ́ ẹ̀ka rẹ̀ méjì àkọ́kọ́ tí ó yọ lára ọ̀pá fìtílà, irúdì kejì ó sì wà ní abẹ́ ẹ̀ka rẹ̀ méjì kejì, irúdì kẹta yóò sì wà ní abẹ́ ẹ̀ka rẹ̀ méjì kẹta, ẹ̀ka mẹ́fà ní àpapọ̀. ");
INSERT INTO yor_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Irúdì wọn àti ẹ̀ka wọn kí ó rí bákan náà, kí gbogbo rẹ̀ kí ó jẹ́ lílù ojúlówó wúrà. ");
INSERT INTO yor_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Nígbà náà ni ìwọ yóò ṣe fìtílà méje. Ìwọ yóò sì gbe ka orí rẹ̀, kí wọn kí ó lè máa ṣe ìmọ́lẹ̀ sí iwájú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Àti alumagaji rẹ̀, àti àwo alimagaji rẹ̀, kí ó jẹ́ kìkì wúrà. ");
INSERT INTO yor_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Tálẹ́ǹtì kìkì wúrà ni ó fi ṣe é, pẹ̀lú gbogbo ohun èlò wọ̀nyí. ");
INSERT INTO yor_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Kíyèsí i, kí ìwọ kí ó ṣe wọ́n gẹ́gẹ́ bí àpẹẹrẹ wọn, ti a fi hàn ọ́ ni orí òkè. ");
INSERT INTO yor_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ṣe àgọ́ náà pẹ̀lú aṣọ títa mẹ́wàá, aṣọ ọ̀gbọ̀ olókùn wíwẹ́ àti aṣọ aláró, ti elése àlùkò, àti ti òdòdó, pẹ̀lú àwọn kérúbù ni kí ó ṣe iṣẹ́ ọlọ́nà sí wọn. ");
INSERT INTO yor_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Gbogbo aṣọ títa náà ni kí ó jẹ́ ìwọ̀n kan náà: ìgbọ̀nwọ́ méjìdínlọ́gbọ̀n (28) ní gígùn àti ìgbọ̀nwọ́ mẹ́rin ni fífẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Aṣọ títa márùn-ún ni kí a so papọ̀ mọ́ ara wọn, àti aṣọ títa márùn-ún ni kí a so papọ̀ mọ́ ara wọn. ");
INSERT INTO yor_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ìwọ yóò ṣì ṣe ajábó aṣọ aláró sí aṣọ títa kan láti ìṣẹ́tí rẹ̀ wá níbi ìsopọ̀, àti bẹ́ẹ̀ gẹ́gẹ́ ni ìwọ yóò ṣe ni etí ìkangun aṣọ títa kejì, ni ibi ìsopọ̀ kejì. ");
INSERT INTO yor_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Àádọ́ta ajábó ní ó pa lára aṣọ títa kan, àti àádọ́ta ajábó ni ó sì lò pa ní etí aṣọ títa tí ó wà ní ìsolù kejì, ajábó náà sì wà ní ọ̀kánkán ara wọn. ");
INSERT INTO yor_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ó sì ṣe àádọ́ta ìkọ́ wúrà, ó sì lò ìkọ́ wọ̀n-ọn-nì láti fi aṣọ títa kan kọ́ èkejì, bẹ́ẹ̀ ó sì di odidi àgọ́ kan. ");
INSERT INTO yor_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Ìwọ ó sì ṣe aṣọ títa irun ewúrẹ́ láti fi ṣe ìbò sórí àgọ́ náà—aṣọ títa mọ́kànlá ni ìwọ ó ṣe é. ");
INSERT INTO yor_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Gbogbo aṣọ títa mọ́kọ̀ọ̀kànlá náà jẹ́ ìwọ̀n kan náà, ọgbọ̀n ìgbọ̀nwọ́ ní gígùn àti ìgbọ̀nwọ́ mẹ́rin ní fífẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ìwọ ó so aṣọ títa márùn-ún pọ̀ mọ́ ara wọn se ọ̀kan, ó sì tún so mẹ́fà tókù mọ́ ara wọn se ọ̀kan. Ìwọ ó sì ṣẹ́ aṣọ títa kẹfà po sí méjì níwájú àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ìwọ ó sì pa àádọ́ta ajábó sí ìṣẹ́tí ìkangun aṣọ títa ní apá kan, wọ́n sì tún pa ajábó mìíràn sí ìṣẹ́tí ìkangun aṣọ títa ní apá kejì. ");
INSERT INTO yor_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Nígbà náà ṣe àádọ́ta ìkọ́ idẹ kí o sì kó wọn sínú ọ̀jábó láti fi so àgọ́ náà pọ̀ kí ó lè jẹ́ ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Àti ìyókù tí ó kù nínú aṣọ títa àgọ́ náà, ìdajì aṣọ títa tí ó kù, yóò rọ̀ sórí ẹ̀yìn àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Aṣọ títa àgọ́ náà yóò jẹ́ ìgbọ̀nwọ́ kan gígùn ní ìhà méjèèjì, èyí tí ó kù yóò rọ̀ sórí ìhà àgọ́ náà láti fi bò ó. ");
INSERT INTO yor_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ìwọ ó sì ṣe ìbòrí awọ àgbò tí a rì ní pupa fún àgọ́ náà, kí ó sì ṣe ìbòrí awọ seali sórí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Ìwọ ó sì ṣe pákó igi kasia tí ó dúró òró fún àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kí pákó kọ̀ọ̀kan jẹ́ ìgbọ̀nwọ́ mẹ́wàá ní gígùn àti ìgbọ̀nwọ́ kan ààbọ̀ ní fífẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Pẹ̀lú ìtẹ̀bọ̀ méjì ni kí ó kọjú sí ara wọn. Ṣe gbogbo àwọn pákó àgọ́ náà bí èyí. ");
INSERT INTO yor_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ìwọ ó sì ṣe ogún pákó sí ìhà gúúsù àgọ́ náà, ");
INSERT INTO yor_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ìwọ ó sì ṣe ogójì ìhà ìtẹ̀bọ̀ fàdákà kí ó lọ sí ìsàlẹ̀ wọn. Méjì fún pákó kọ̀ọ̀kan, ọ̀kan ní ìsàlẹ̀ ìtẹ̀bọ̀ kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Àti ìhà kejì, ni ìhà àríwá àgọ́ náà, ṣe ogún pákó síbẹ̀ ");
INSERT INTO yor_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","àti ogójì ihò ìtẹ̀bọ̀ fàdákà méjì ní abẹ́ pákó kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kí ìwọ kí ó ṣe pákó mẹ́fà sì ìkangun, ní ìkangun ìhà ìwọ̀-oòrùn àgọ́ náà, ");
INSERT INTO yor_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","kí o sì ṣe pákó méjì fún igun ní ìhà ẹ̀yìn. ");
INSERT INTO yor_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ní igun méjèèjì yìí, wọ́n gbọdọ̀ jẹ́ méjì láti ìdí dé orí rẹ̀, a ó sì so wọ́n pọ̀ sí òrùka kan: méjèèjì yóò sì rí bákan náà. ");
INSERT INTO yor_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Wọn ó sì jẹ́ pákó mẹ́jọ, àti ihò ìtẹ̀bọ̀ fàdákà mẹ́rìnlélógún, méjì wà ní ìsàlẹ̀ ọ̀kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Ìwọ ó sì ṣe ọ̀pá ìdábùú igi kasia; márùn-ún fún pákó ìhà kan àgọ́ náà, ");
INSERT INTO yor_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","márùn-ún fún àwọn ìhà kejì, àti márùn-ún fún pákó ni ìhà ìwọ̀-oòrùn ní ìhà ẹ̀yìn àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ọ̀pá ìdábùú àárín ni agbede-méjì gbọdọ̀ tàn láti ìkangun dé ìkangun pákó náà. ");
INSERT INTO yor_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ìwọ́ ó sì bo àwọn pákó náà pẹ̀lú wúrà, kí o sì ṣe òrùka wúrà kí ó lè di ọ̀pá ìdábùú mu. Kí o sì tún bo ọ̀pá ìdábùú náà pẹ̀lú wúrà. ");
INSERT INTO yor_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Gbé àgọ́ náà ró gẹ́gẹ́ bí àpẹẹrẹ tí a fihàn ọ́ lórí òkè. ");
INSERT INTO yor_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Ìwọ ó sì ṣe aṣọ ìgélé aláró, àti elése àlùkò, àti òdòdó, àti ọ̀gbọ̀ olókùn wẹ́wẹ́ tí í ṣe ọlọ́nà, tí òun ti àwọn kérúbù ni kí á ṣe é. ");
INSERT INTO yor_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ìwọ yóò sì fi rọ̀ sára òpó tí ó di igi kasia mẹ́rin ró tí a fi wúrà bò, tí ó dúró lórí ihò ìtẹ̀bọ̀ mẹ́rin mẹ́rin. ");
INSERT INTO yor_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ṣo aṣọ títa náà sí ìsàlẹ̀ àwọn ìkọ́, kí o sì gbé àpótí ẹ̀rí sí ẹ̀gbẹ́ aṣọ títa náà. Aṣọ títa náà yóò pínyà Ibi Mímọ́ kúrò ní Ibi Mímọ́ Jùlọ. ");
INSERT INTO yor_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Fi ìtẹ́ àánú bo àpótí ẹ̀rí náà ni Ibi Mímọ́ Jùlọ. ");
INSERT INTO yor_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Gbé tábìlì náà sí ìta aṣọ títa náà sí ìhà gúúsù àgọ́ náà, kí o sì gbé ọ̀pá fìtílà sí òdìkejì rẹ̀ ní ìhà àríwá. ");
INSERT INTO yor_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Fún ti ẹnu-ọ̀nà àgọ́ náà, ìwọ yóò ṣe aṣọ títa aláró, elése àlùkò, ti òdòdó àti ti ọ̀gbọ̀ olókùn wíwẹ́ tí a fi iṣẹ́ abẹ́rẹ́ ṣe. ");
INSERT INTO yor_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ìwọ ó sì ṣe ìkọ́ wúrà fún aṣọ títa yìí, àti òpó igi ṣittimu márùn-ún tí a sì fi wúrà bò. Kí o sì dà ihò ìtẹ̀bọ̀ idẹ márùn-ún fún wọn. ");
INSERT INTO yor_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ìwọ yóò sì kọ pẹpẹ igi kasia kan, ìgbọ̀nwọ́ mẹ́ta ní gígùn; kí ìhà rẹ̀ mẹ́rẹ̀ẹ̀rin jẹ́ ìwọ̀n kan, ìgbọ̀nwọ́ márùn-ún ní gíga àti ìgbọ̀nwọ́ márùn-ún ní fífẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ìwọ yóò ṣì ṣe ìwo orí igun mẹ́rẹ̀ẹ̀rin, kí àwọn ìwo náà àti pẹpẹ náà lè ṣe ọ̀kan, ìwọ yóò sì bo pẹpẹ náà pẹ̀lú idẹ. ");
INSERT INTO yor_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ìwọ yóò sì ṣe abọ́ ìtẹ́dìí rẹ láti máa gba eérú rẹ̀, àti ọkọ̀ rẹ̀, àwokòtò rẹ̀, àti fọ́ọ̀kì ẹran rẹ̀, àti àwo iná rẹ̀, gbogbo ohun èlò rẹ̀ ni ìwọ yóò fi idẹ ṣe. ");
INSERT INTO yor_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ìwọ yóò sí ṣe ni wẹ́wẹ́, iṣẹ́ àwọ̀n idẹ, kí o sì ṣe òrùka idẹ sí igun mẹ́rẹ̀ẹ̀rin iṣẹ́ àwọ̀n náà. ");
INSERT INTO yor_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Gbé e sí abẹ́ igun pẹpẹ náà, kí ó lè dé ìdajì pẹpẹ náà. ");
INSERT INTO yor_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ìwọ yóò sí ṣe òpó igi kasia fún pẹpẹ náà, kí o sì bò ó pẹ̀lú idẹ. ");
INSERT INTO yor_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","A ó sì bọ àwọn òpó náà ní òrùka, wọn yóò sì wà ní ìhà méjèèjì pẹpẹ nígbà tí a bá rù ú. ");
INSERT INTO yor_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ìwọ yóò sì ṣe pákó náà ni oníhò nínú. Ìwọ yóò sí ṣe wọ́n bí èyí tí a fihàn ọ́ ní orí òkè. ");
INSERT INTO yor_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Ìwọ yóò sì ṣe àgbàlá fún àgọ́ náà. Ní ìhà gúúsù, ó gbọdọ̀ jẹ́ ọgọ́rùn-ún ìgbọ̀nwọ́ (mita mẹ́rìndínláàádọ́ta) ní gíga, kí ó sì ní aṣọ títa ti ọ̀gbọ̀ olókùn wíwẹ́, ");
INSERT INTO yor_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","pẹ̀lú ogún òpó àti ogún ihò ìtẹ̀bọ̀ idẹ pẹ̀lú ìkọ́ fàdákà, kí ó sì di àwọn òpó mú. ");
INSERT INTO yor_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Kí ìhà àríwá náà jẹ́ mita mẹ́rìndínláàádọ́ta ní gíga, kí ó sì ní aṣọ títa, pẹ̀lú ogun òpó àti ogún ihò ìtẹ̀bọ̀ idẹ, pẹ̀lú ìkọ́ fàdákà tí ó sì di àwọn òpó mú. ");
INSERT INTO yor_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Ní ìhà ìwọ̀-oòrùn, àgbàlá náà yóò jẹ́ mita mẹ́tàlélógún ní fífẹ̀, kí ó sì ní aṣọ títa pẹ̀lú òpó mẹ́wàá àti ihò ìtẹ̀bọ̀ mẹ́wàá. ");
INSERT INTO yor_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ní ìhà ìlà-oòrùn, sí ibi tí oòrùn tí ń jáde, àgbàlá náà yóò jẹ́ mita mẹ́tàlélógún ní fífẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Aṣọ títa ìgbọ̀nwọ́ mẹ́ẹ̀ẹ́dógún ní gíga ní yóò wà ní ìhà ẹnu-ọ̀nà, pẹ̀lú òpó mẹ́ta àti ihò ìtẹ̀bọ̀ mẹ́ta, ");
INSERT INTO yor_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","àti aṣọ títa ìgbọ̀nwọ́ mẹ́ẹ̀ẹ́dógún ní gíga yóò wá ní ìhà kejì, pẹ̀lú òpó mẹ́ta àti ihò ìtẹ̀bọ̀ mẹ́ta. ");
INSERT INTO yor_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Àti fún ẹnu-ọ̀nà àgbàlá náà, pèsè aṣọ títa, mita mẹ́sàn-án ní gíga, ti aláró, elése àlùkò, ti òdòdó, àti ti ọ̀gbọ̀ olókùn wíwẹ́ tí a fi iṣẹ́ abẹ́rẹ́ ṣe, pẹ̀lú òpó mẹ́rin àti ihò ìtẹ̀bọ̀ mẹ́rin. ");
INSERT INTO yor_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Gbogbo òpó ti ó wà ní àyíká àgbàlá náà ni a ó fi fàdákà ṣo pọ̀ àti ìkọ́, àti ihò ìtẹ̀bọ̀ idẹ. ");
INSERT INTO yor_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Àgbàlá náà yóò jẹ́ mita mẹ́rìndínláàádọ́ta ni gíga àti mita mẹ́tàlélógún ní fífẹ̀, pẹ̀lú aṣọ títa ti ọ̀gbọ̀ olókùn mita méjì ní gíga, àti pẹ̀lú ihò ìtẹ̀bọ̀ idẹ. ");
INSERT INTO yor_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Gbogbo irú iṣẹ́ tí ó wà kí ó ṣe, papọ̀ pẹ̀lú gbogbo èèkàn àgọ́ náà àti fún tí àgbàlá náà, kí ó jẹ́ idẹ. ");
INSERT INTO yor_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ìwọ yóò sì pàṣẹ fún àwọn ọmọ Israẹli, kí wọn kí ó mú òróró olifi dáradára tí a gún fún ọ wá, fún ìmọ́lẹ̀, kí fìtílà lè máa tàn síbẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ní àgọ́ àjọ, lẹ́yìn òde aṣọ ìkélé tí ó wá níwájú ẹ̀rí náà, Aaroni àti òun àti àwọn ọmọ rẹ̀, ni yóò tọ́jú rẹ̀ láti alẹ́, títí di òwúrọ̀ níwájú Olúwa: yóò sì di ìlànà láéláé ni ìrandíran wọn lọ́dọ̀ àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ìwọ sì mú Aaroni arákùnrin rẹ wá sí ọ̀dọ̀ rẹ, mú un kúrò ni àárín àwọn ọmọ Israẹli, pẹ̀lú àwọn ọmọ rẹ̀ Nadabu, Abihu, Eleasari, àti Itamari, kí wọn kí ó lè sìn mí gẹ́gẹ́ bí àlùfáà. ");
INSERT INTO yor_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ìwọ yóò sì dá aṣọ mímọ́ fún Aaroni arákùnrin rẹ, láti fún un ni ọ̀ṣọ́ àti ọlá. ");
INSERT INTO yor_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ìwọ yóò sì sọ fún gbogbo àwọn ọlọ́gbọ́n ènìyàn, àwọn ẹni tí mo fún ní ọgbọ́n, kí wọn kí ó lè dá aṣọ fún Aaroni, fún ìyàsímímọ́ rẹ̀, kí ó lè ba à sìn mí gẹ́gẹ́ bí àlùfáà. ");
INSERT INTO yor_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Wọ̀nyí ni àwọn aṣọ tí wọn yóò dá: ìgbàyà kan, ẹ̀wù efodu, ọ̀já àmùrè kan, ẹ̀wù àwọ̀tẹ́lẹ̀ ọlọ́nà, fìlà àti aṣọ ìgúnwà. Kí wọn kí ó dá àwọn aṣọ mímọ́ yìí fún Aaroni arákùnrin rẹ àti àwọn ọmọ rẹ̀, kí wọn kí ó lè sìn mí gẹ́gẹ́ bí àlùfáà. ");
INSERT INTO yor_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Wọn yóò sì lo wúrà, aṣọ aláró, elése àlùkò àti ti òdòdó àti ti ọ̀gbọ̀ dáradára. ");
INSERT INTO yor_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Wọn yóò sì dá ẹ̀wù efodu ti wúrà, tí aṣọ aláró, elése àlùkò àti ti òdòdó àti ti ọ̀gbọ̀ olókùn wíwẹ́, iṣẹ́ ọlọ́nà. ");
INSERT INTO yor_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kí ó ni aṣọ èjìká méjì tí a so mọ́ igun rẹ̀ méjèèjì, kí a lè so ó pọ̀. ");
INSERT INTO yor_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Àti onírúurú ọnà ọ̀já rẹ̀, tí ó wà ni orí rẹ̀, yóò rí bákan náà, gẹ́gẹ́ bi iṣẹ́ rẹ̀, tí wúrà, ti aṣọ aláró, òdòdó àti ọ̀gbọ̀ olókùn wíwẹ́. ");
INSERT INTO yor_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Ìwọ yóò sì mú òkúta óníkìsì méjì, ìwọ yóò sì fín orúkọ àwọn ọmọ Israẹli sára wọn. ");
INSERT INTO yor_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ní ti ìbí wọn, orúkọ àwọn mẹ́fà sára òkúta kan àti orúkọ àwọn mẹ́fà tókù sára òkúta kejì. ");
INSERT INTO yor_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Iṣẹ́ ọnà òkúta fínfín, bí ìfín èdìdì àmì, ni ìwọ yóò fún òkúta méjèèjì gẹ́gẹ́ bí orúkọ àwọn ọmọ Israẹli: ìwọ yóò sì dè wọ́n sí ojú ìdè wúrà. ");
INSERT INTO yor_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ìwọ yóò sì so wọ́n pọ̀ mọ́ èjìká efodu náà ní òkúta ìrántí fún àwọn ọmọ Israẹli. Aaroni yóò sì máa ní orúkọ wọn níwájú Olúwa ní èjìká rẹ̀ méjèèjì fún ìrántí. ");
INSERT INTO yor_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ìwọ yóò sì ṣe ojú ìdè wúrà, ");
INSERT INTO yor_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","àti okùn ẹ̀wọ̀n méjì ti kìkì wúrà, gẹ́gẹ́ bí ọ̀já àmùrè kí o sì so ẹ̀wọ̀n náà mọ́ ojú ìdè náà. ");
INSERT INTO yor_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Ìwọ yóò fi iṣẹ́ ọgbọ́n ṣe ìgbàyà fún ìpinnu iṣẹ́ ọnà gbẹ́nàgbẹ́nà. Ìwọ yóò ṣe é bí ẹ̀wù efodu ti wúrà, ti aṣọ aláró, ti elése àlùkò, ti òdòdó àti ti ọ̀gbọ̀ olókùn wíwẹ́ dáradára. ");
INSERT INTO yor_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kí ìhà mẹ́rẹ̀ẹ̀rin rẹ̀ ṣe déédé—kí ó jẹ́ ìwọ̀n ìka kan ní ìnà àti ìwọ̀n ìka kan ní ìbú, kí o sì ṣe é ní ìṣẹ́po méjì. ");
INSERT INTO yor_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Nígbà náà ni ìwọ yóò de òkúta oníyebíye mẹ́rin sára ẹsẹ̀ rẹ̀. Ní ẹsẹ̀ àkọ́kọ́ ni kí rúbì, topasi àti berili wà; ");
INSERT INTO yor_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ní ẹsẹ̀ kejì turikuose, emeradi, safire, àti diamọndi; ");
INSERT INTO yor_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ní ẹsẹ̀ kẹta, jasiniti, agate, àti ametisiti; ");
INSERT INTO yor_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ní ẹsẹ̀ kẹrin, topasi, àti óníkìsì àti jasperi. A ó sì tò wọ́n sí ojú wúrà ní dìde wọn. ");
INSERT INTO yor_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Òkúta méjìlá yóò wà, ọ̀kọ̀ọ̀kan fún orúkọ àwọn ọmọ Israẹli olúkúlùkù èdìdì àmì pẹ̀lú orúkọ ẹnìkọ̀ọ̀kan bí ẹ̀yà Israẹli méjìlá. ");
INSERT INTO yor_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Fún ìgbàyà náà, ìwọ yóò ṣe okùn ẹ̀wọ̀n ti kìkì wúrà, gẹ́gẹ́ bí ọ̀já àmùrè. ");
INSERT INTO yor_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ìwọ yóò ṣe òrùka wúrà méjì fún un, kí o sì so wọ́n mọ́ igun méjèèjì ìgbàyà náà. ");
INSERT INTO yor_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ìwọ yóò so ẹ̀wọ̀n wúrà méjèèjì mọ́ òrùka ní igun ìgbàyà náà, ");
INSERT INTO yor_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","àti etí ẹ̀wọ̀n méje ni kí o so mọ́ ojú ìdè méjèèjì, kí o sì fi sí èjìká ẹ̀wù efodu náà níwájú. ");
INSERT INTO yor_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ìwọ yóò ṣe òrùka wúrà méjì, ìwọ yóò sì so wọ́n mọ́ igun méjì ìgbàyà kejì ní ìhà inú tí ó ti ẹ̀wù efodu náà. ");
INSERT INTO yor_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ìwọ yóò sì ṣe òrùka wúrà méjì, ìwọ yóò sì fi wọ́n sí èjìká ẹ̀wù efodu méjèèjì ní ìsàlẹ̀, sí ìhà iwájú rẹ̀, tí ó súnmọ́ ojú sí ìránṣọ náà, lókè onírúurú ọnà ọ̀já ẹ̀wù efodu náà. ");
INSERT INTO yor_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Wọn yóò sì so òrùka ìgbàyà mọ́ òrùka ẹ̀wù efodu pẹ̀lú ọ̀já aláró, pa á pọ̀ mọ́ ìgbànú, kí a má ba à tú ìgbàyà náà kúrò lára ẹ̀wù efodu náà. ");
INSERT INTO yor_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Nígbàkígbà tí Aaroni bá wọ Ibi Mímọ́, òun yóò ru orúkọ àwọn ọmọ Israẹli ní gbogbo ọ̀kan rẹ̀ ni ìgbàyà ìpinnu bí ìrántí nígbà gbogbo níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Bákan náà ìwọ yóò sì mu Urimu àti Tumimu sínú ìgbàyà, kí wọn kí ó wà ní ọkàn Aaroni nígbàkígbà tí ó bá ń wólẹ̀ níwájú Olúwa. Aaroni yóò sì máa ru ohun ti a ń fi ṣe ìpinnu fún àwọn ọmọ Israẹli ní ọkàn rẹ̀ nígbà gbogbo níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Ìwọ yóò ṣì ṣe aṣọ ìgúnwà ẹ̀wù efodu náà ní kìkì aṣọ aláró, ");
INSERT INTO yor_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","pẹ̀lú ojú ọrùn kí ó wà láàrín rẹ̀ fún orí. Kí iṣẹ́ ọ̀nà wà létí rẹ̀ bí ìṣẹ́tí yí i ká bí agbádá, kí ó má ba à ya. ");
INSERT INTO yor_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ṣe pomegiranate ti aṣọ aláró, ti elése àlùkò àti ti òdòdó yí ìṣẹ́tí ọ̀já àmùrè náà ká, pẹ̀lú ṣaworo wúrà láàrín wọn. ");
INSERT INTO yor_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Àwọn ṣaworo wúrà àti àwọn pomegiranate ni kí ó yí ìṣẹ́tí ọ̀já àmùrè náà ká. ");
INSERT INTO yor_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaroni gbọdọ̀ máa wọ̀ ọ́ nígbà tí o bá ń ṣiṣẹ́. A ó sì máa gbọ́ ìró àwọn agogo nígbà tí ó bá ń wọ Ibi Mímọ́ níwájú Olúwa àti nígbà tí ó bá ń jáde bọ̀, kí ó má ba à kú. ");
INSERT INTO yor_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ìwọ yóò sì ṣe àwo kìkì wúrà, ìwọ yóò sì fín sára rẹ̀ bí, fínfín èdìdì àmì pé. Mímọ́ sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ìwọ yóò fi ọ̀já aláró sára rẹ̀ ìwọ yóò sì so ó mọ́ fìlà náà; kí ó sì wà níwájú fìlà náà. ");
INSERT INTO yor_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Kí ó wà níwájú orí Aaroni, kí ó sì lè máa ru ẹ̀bi tí ó jẹ mọ́ ẹ̀bùn mímọ́ ti àwọn ọmọ Israẹli ti yà sí mímọ́, èyíkéyìí tí ẹ̀bùn wọn lè jẹ́. Yóò máa wà níwájú orí Aaroni nígbà gbogbo, kí wọn lè jẹ́ ìtẹ́wọ́gbà fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Ìwọ yóò sì fi ọ̀gbọ̀ dáradára hun ẹ̀wù àwọ̀tẹ́lẹ̀, ìwọ yóò sì fi ọ̀gbọ̀ dáradára ṣe fìlà. Ìwọ yóò sì fi iṣẹ́ abẹ́rẹ́ ṣe ọ̀já àmùrè. ");
INSERT INTO yor_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ìwọ yóò sì dá ẹ̀wù àwọ̀tẹ́lẹ̀, ọ̀já àmùrè àti ìgbàrí fún àwọn ọmọ Aaroni, láti fún wọn ní ọ̀ṣọ́ àti ọlá. ");
INSERT INTO yor_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Lẹ́yìn tí ìwọ ti fi àwọn aṣọ wọ̀nyí wọ Aaroni arákùnrin rẹ, ìwọ yóò sì fi wọ àwọn ọmọ rẹ̀ pẹ̀lú, ìwọ ó ta òróró sí wọn ní orí, ìwọ yóò sì ya wọ́n sí mímọ́. Ìwọ yóò sì sọ wọ́n di mímọ́, kí wọn kí o lè máa ṣe iṣẹ́ àlùfáà. ");
INSERT INTO yor_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Ìwọ yóò dá ṣòkòtò ọ̀gbọ̀ fún wọn, kí wọn lè máa fi bo ìhòhò wọn, kí ó dé ìbàdí dé itan. ");
INSERT INTO yor_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaroni àti àwọn ọmọ rẹ̀ gbọdọ̀ wọ̀ wọ́n nígbàkígbà tí wọ́n bá wọ àgọ́ àjọ lọ tàbí nígbà tí wọ́n bá súnmọ́ pẹpẹ láti ṣiṣẹ́ ní Ibi Mímọ́ kí wọn kí ó má ba à dẹ́ṣẹ̀, wọn a sì kú. “Èyí jẹ́ ìlànà láéláé fún Aaroni àti fún irú-ọmọ rẹ̀ lẹ́yìn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Èyí ni ohun tí ìwọ yóò ṣe láti yà wọ́n sí mímọ́, kí wọn lè máa ṣe àlùfáà fún mi. Mú ọ̀dọ́ akọ màlúù kan àti àgbò méjì tí kò ní àbùkù. ");
INSERT INTO yor_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Láti ara ìyẹ̀fun aláìwú dídùn, ṣe àkàrà àti àkàrà tí a pò pẹ̀lú òróró, àti àkàrà fẹ́lẹ́fẹ́lẹ́ aláìwú tí a da òróró sí. ");
INSERT INTO yor_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ìwọ yóò sì kó wọn sínú apẹ̀rẹ̀ kan, ìwọ yóò sì mú wọn wà nínú apẹ̀rẹ̀ náà papọ̀ pẹ̀lú akọ màlúù àti àgbò méjì náà. ");
INSERT INTO yor_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Nígbà náà ni ìwọ yóò mú Aaroni àti àwọn ọmọ rẹ̀ wá sí ẹnu-ọ̀nà àgọ́ àjọ, ìwọ yóò sì fi omi wẹ̀ wọ́n. ");
INSERT INTO yor_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ìwọ yóò sì fi ẹ̀wù àwọ̀tẹ́lẹ̀ wọ Aaroni, àti aṣọ ìgúnwà efodu, àti efodu, àti ìgbàyà, kí ó sì fi onírúurú ọnà ọ̀já ẹ̀wù efodu dì í. ");
INSERT INTO yor_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ìwọ yóò sì fi fìlà dé e ní orí, ìwọ yóò sì ṣe adé mímọ́ sára fìlà náà. ");
INSERT INTO yor_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Nígbà náà ni ìwọ yóò sì mú òróró ìtasórí, ìwọ yóò sì yà á sí mímọ́ nípa dída òróró sí i ní orí. ");
INSERT INTO yor_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ìwọ yóò sì mú àwọn ọmọ rẹ̀ ìwọ yóò sì fi aṣọ àwọ̀tẹ́lẹ̀ wọ̀ wọ́n ");
INSERT INTO yor_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ìwọ yóò sì fi fìlà dé wọn ni orí. Nígbà náà fi ọ̀já àmùrè di Aaroni àti àwọn ọmọ rẹ̀. Iṣẹ́ àlùfáà yóò máa jẹ́ tiwọn ní ìlànà títí ayé. “Báyìí ni ìwọ yóò sì ya Aaroni àti àwọn ọmọ rẹ̀ sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Ìwọ yóò sì mú akọ màlúù wá síwájú àgọ́ àjọ, Aaroni àti àwọn ọmọ rẹ̀ yóò sì fi ọwọ́ wọn lé akọ màlúù ní orí. ");
INSERT INTO yor_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ìwọ yóò sì pa àwọn akọ màlúù náà níwájú Olúwa ní ẹnu-ọ̀nà àgọ́ àjọ. ");
INSERT INTO yor_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ìwọ yóò sì mú nínú ẹ̀jẹ̀ akọ màlúù náà, ìwọ yóò sì fi ìka rẹ tọ́ ọ sára ìwo pẹpẹ náà, kí o sì da gbogbo ẹ̀jẹ̀ tókù sí ìsàlẹ̀ pẹpẹ náà. ");
INSERT INTO yor_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Kí o mú gbogbo ọ̀rá tí ó yí inú ká, èyí tí ó bo ẹ̀dọ̀ àti ìwé méjèèjì pẹ̀lú ọ̀rá tí ó wà lára wọn, ìwọ yóò sì sun wọ́n lórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ṣùgbọ́n fi iná sun ẹran akọ màlúù, awọ rẹ̀ àti ìgbẹ́ rẹ̀ lẹ́yìn òde. Ẹbọ ẹ̀ṣẹ̀ ni. ");
INSERT INTO yor_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Ìwọ yóò sì mú àgbò kan, Aaroni àti àwọn ọmọ rẹ̀ yóò sì gbọ́wọ́ lé orí àgbò náà. ");
INSERT INTO yor_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ìwọ yóò sì pa àgbò náà, ìwọ yóò sì mú ẹ̀jẹ̀ rẹ̀, ìwọ yóò sì fi wọ́n pẹpẹ náà yíká. ");
INSERT INTO yor_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ìwọ yóò sì gé àgbò náà sí wẹ́wẹ́, ìwọ yóò sì fọ inú àti àwọn ẹsẹ̀ rẹ̀, ìwọ yóò sì tò wọ́n pẹ̀lú orí rẹ̀ lé ara wọn. ");
INSERT INTO yor_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Nígbà náà ni ìwọ yóò sun àgbò náà lórí pẹpẹ. Ẹbọ sísun ni sí Olúwa, olóòórùn dídùn ni, ẹbọ ti a fi iná ṣe sí Olúwa ni. ");
INSERT INTO yor_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Ìwọ yóò mú àgbò kejì, Aaroni àti àwọn ọmọ rẹ̀ yóò fi ọwọ́ wọn lé àgbò náà lórí. ");
INSERT INTO yor_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ìwọ yóò sì pa àgbò náà, ìwọ yóò mú nínú ẹ̀jẹ̀ rẹ̀, ìwọ yóò sì tọ́ ọ sí etí ọ̀tún Aaroni àti àwọn ọmọ rẹ̀, sí àtàǹpàkò ọwọ́ ọ̀tún wọn, àti sí àtàǹpàkò ẹsẹ̀ ọ̀tún wọn. Ìwọ yóò sì fi ẹ̀jẹ̀ wọ́n pẹpẹ náà yíká. ");
INSERT INTO yor_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ìwọ yóò mú nínú ẹ̀jẹ̀ tí ó wà lórí pẹpẹ àti nínú òróró ìtasórí, ìwọ yóò sì wọ́n ọn sára Aaroni àti sára aṣọ rẹ̀, sára àwọn ọmọ rẹ àti sára aṣọ wọn. Nígbà náà ni òun àti àwọn ọmọ rẹ̀ àti aṣọ wọn yóò di mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ìwọ yóò mú lára ọ̀rá àgbò náà, ìrù tí ó lọ́ràá, ọ̀rá tí ó yí inú ká, èyí ti ó bo ẹ̀dọ̀, ìwé méjèèjì pẹ̀lú ọ̀rá tí ó wà lára wọn àti itan ọ̀tún. (Èyí ni àgbò fún ìyàsímímọ́.) ");
INSERT INTO yor_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Láti inú apẹ̀rẹ̀ ìṣù àkàrà aláìwú, èyí tí ó wà níwájú Olúwa, mú ìṣù kan, àkàrà tí a fi òróró dín àti àkàrà fẹ́lẹ́fẹ́lẹ́ kan. ");
INSERT INTO yor_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ìwọ yóò fi gbogbo rẹ̀ lé Aaroni àti àwọn ọmọ rẹ̀ lọ́wọ́, ìwọ yóò sì fì wọ́n gẹ́gẹ́ bí ẹbọ fífì níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Nígbà náà ni ìwọ yóò sì gbà wọ́n ní ọwọ́ wọn, ìwọ yóò sì sun wọ́n lórí pẹpẹ pẹ̀lú ẹbọ sísun fún òórùn dídùn níwájú Olúwa, ẹbọ ti a fi iná sun sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ìwọ yóò sì mú igẹ̀ àgbò ìyàsímímọ́ Aaroni, ìwọ yóò si fí ì ni ẹbọ fífì níwájú Olúwa; ìpín tìrẹ ni èyí. ");
INSERT INTO yor_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Ìwọ yóò sì ya igẹ̀ ẹbọ fífì náà sí mímọ́, àti ìtàn ẹbọ à gbé sọ sókè tí a fì, tí a sì gbé sọ sókè nínú àgbò ìyàsímímọ́ náà, àní nínú èyí tí í ṣe Aaroni àti nínú èyí tí ì ṣe tí àwọn ọmọ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Èyí ni yóò sì máa ṣe ìpín ti Aaroni àti àwọn ọmọ rẹ̀ láti ọwọ́ àwọn ọmọ Israẹli nígbà gbogbo. Nítorí ẹbọ à gbé sọ sókè ni ẹbọ tí yóò ṣì ṣe èyí ni ẹbọ tí àwọn ọmọ Israẹli yóò máa ṣe sí Olúwa láti inú ẹbọ àlàáfíà wọn. ");
INSERT INTO yor_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Aṣọ mímọ́ Aaroni yóò jẹ́ ti irú àwọn ọmọ rẹ̀, nítorí kí a lè máa fi òróró yàn wọ́n kí a sì lè máa yà wọ́n sì mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ọmọ rẹ̀ tí ó bá jẹ àlùfáà ní ipò rẹ̀, tí ó bá wọ̀ yóò máa sì wá sí àgọ́ àjọ láti ṣiṣẹ́ ní Ibi Mímọ́, yóò sì máa wọ̀ wọ́n ní ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ìwọ yóò sì mú àgbò fún ìyàsímímọ́, ìwọ yóò sì bọ ẹran rẹ̀ ní ibi mímọ́ kan. ");
INSERT INTO yor_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ní ẹnu-ọ̀nà àgọ́ àjọ ni Aaroni àti àwọn ọmọ rẹ̀ yóò ti jẹ ẹran àgbò náà àti àkàrà náà tí ó wà nínú apẹ̀rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Wọn yóò sì jẹ nǹkan wọ̀nyí èyí tí a fi ṣe ètùtù náà fún ìyàsímímọ́ àti ìsọdimímọ́ wọn. Ṣùgbọ́n àlejò ni kò gbọdọ̀ jẹ nínú rẹ̀, nítorí pé mímọ́ ni. ");
INSERT INTO yor_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Bí ohun kan nínú ẹran àgbò ìyàsímímọ́ tàbí nínú àkàrà náà bá kù di òwúrọ̀, nígbà náà ni kí ìwọ fi iná sun wọn. A kò gbọdọ̀ jẹ ẹ́, nítorí mímọ́ ni. ");
INSERT INTO yor_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Báyìí ni ìwọ yóò ṣì ṣe fún Aaroni àti àwọn ọmọ rẹ̀ bí ohun gbogbo ti mo paláṣẹ fún ọ, ọjọ́ méje ni ìwọ yóò fi yà wọ́n sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ìwọ yóò sì máa pa akọ màlúù kọ̀ọ̀kan ní ojoojúmọ́ bí ẹbọ ẹ̀ṣẹ̀ láti ṣe ètùtù. Ìwọ yóò sì wẹ pẹpẹ mọ́ nípa ṣíṣe ètùtù fún un, ìwọ yóò sì ta òróró sí i láti sọ ọ́ dí mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ní ọjọ́ méje ni ìwọ yóò ṣe ètùtù sí pẹpẹ náà, ìwọ yóò sì sọ ọ́ di mímọ́. Nígbà náà ni pẹpẹ náà yóò jẹ́ mímọ́ jùlọ, àti ohunkóhun tí ó bá fi ọwọ́ kàn án yóò jẹ́ mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Èyí ni ìwọ yóò máa fi rú ẹbọ ní orí pẹpẹ náà: Ọ̀dọ́-àgùntàn méjì ọlọ́dún kan ni ojoojúmọ́ láéláé. ");
INSERT INTO yor_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ọ̀dọ́-àgùntàn kan ni ìwọ yóò fi rú ẹbọ ní òwúrọ̀ àti ọ̀dọ́-àgùntàn èkejì ní àṣálẹ́. ");
INSERT INTO yor_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Pẹ̀lú ọ̀dọ́-àgùntàn ti àkọ́kọ́ rú ẹbọ ìdámẹ́wàá òsùwọ̀n ìyẹ̀fun dídára tí a fi ìdámẹ́rin hínì òróró lára olifi tí a gún, àti ìdámẹ́rin hínì wáìnì bí ẹbọ mímu. ");
INSERT INTO yor_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ọ̀dọ́-àgùntàn kejì ni kí ìwọ kí ó pa rú ẹbọ ní àṣálẹ́ ìwọ yóò sì ṣe sí í gẹ́gẹ́ bí ẹbọ jíjẹ àti ẹbọ mímu bí ti òwúrọ̀ fún òórùn dídùn, ẹbọ tí a fi iná ṣe ni sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Fún ìrandíran tó ń bọ̀, ni ẹ ó máa ṣe ẹbọ sísun nígbà gbogbo ní ẹnu-ọ̀nà àgọ́ àjọ níwájú Olúwa. Níbẹ̀ èmi yóò pàdé yín, èmi yóò sì bá a yín sọ̀rọ̀; ");
INSERT INTO yor_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","níbẹ̀ sì tún ni èmi yóò pàdé àwọn ọmọ Israẹli, a ó sì fi ògo mi ya àgọ́ náà sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Bẹ́ẹ̀ ni èmi yóò ya àgọ́ àjọ náà sí mímọ́ àti pẹpẹ náà, èmi yóò sì ya Aaroni àti àwọn ọmọ rẹ̀ sí mímọ́ láti máa ṣe iṣẹ́ bí àlùfáà fún mi. ");
INSERT INTO yor_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nígbà náà ni èmi yóò máa gbé láàrín àwọn ọmọ Israẹli, èmi yóò sì máa ṣe Ọlọ́run wọn. ");
INSERT INTO yor_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Wọn yóò sì mọ̀ pé Èmi ni Olúwa Ọlọ́run wọn, ẹni tí ó mú wọn jáde láti ilẹ̀ Ejibiti wá, nítorí kí èmi lè máa gbé àárín wọn. Èmi ni Olúwa Ọlọ́run wọn. ");
INSERT INTO yor_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ìwọ yóò sì ṣe pẹpẹ igi kasia kan; máa jó tùràrí lórí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kí igun mẹ́rẹ̀ẹ̀rin rẹ̀ ṣe déédé, kí ó jẹ́ ìdajì mita ní gígùn, ìdajì mita ní fífẹ̀ àti ìgbọ̀nwọ́ méjì ni gíga rẹ̀—kí ìwo rẹ̀ wà pẹ̀lú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ìwọ yóò sì bo òkè rẹ̀, gbogbo ìhà rẹ̀ àti ìwo rẹ̀ pẹ̀lú u kìkì wúrà, ìwọ yóò sì ṣe wúrà gbà á yíká. ");
INSERT INTO yor_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ìwọ yóò sì ṣe òrùka wúrà méjì fún pẹpẹ náà níṣàlẹ̀ ìgbátí méjèèjì ní òdìkejì ìhà rẹ̀—láti gbá àwọn òpó rẹ̀ mú, láti lè máa fi gbé e. ");
INSERT INTO yor_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ìwọ yóò sì ṣe òpó igi kasia, ìwọ yóò sì bọ́ wọ́n pẹ̀lú wúrà. ");
INSERT INTO yor_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ìwọ yóò gbé pẹpẹ náà sí iwájú aṣọ ìkélé, èyí tí ó wà níwájú àpótí ẹ̀rí níwájú ìtẹ́ àánú èyí tí ó wà lórí àpótí ẹ̀rí níbi ti èmi yóò ti máa bá ọ pàdé. ");
INSERT INTO yor_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Aaroni yóò sì máa jó tùràrí dídùn lórí pẹpẹ náà ní àràárọ̀, nígbà tí ó tún àwọn fìtílà náà ṣe. ");
INSERT INTO yor_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aaroni yóò sì tún jó tùràrí nígbà tí ó bá tan fìtílà ní àṣálẹ́, bẹ́ẹ̀ ní tùràrí yóò máa jó títí láé níwájú Olúwa fún àwọn ìran tó ń bọ̀. ");
INSERT INTO yor_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ẹ̀yin kò gbọdọ̀ mú àjèjì tùràrí wá sórí pẹpẹ yìí tàbí ẹbọ sísun kankan tàbí ọrẹ oúnjẹ, bẹ́ẹ̀ ni ẹ̀yin kò gbọdọ̀ da ẹbọ ohun mímu sórí i rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaroni yóò sì máa ṣe ètùtù sórí àwọn ìwo rẹ̀ lẹ́ẹ̀kan lọ́dún. Òun yóò sì máa ṣe ètùtù ọdọọdún yìí pẹ̀lú ẹ̀jẹ̀ ẹbọ ètùtù fún ìran tó ń bọ̀. Mímọ́ jùlọ ni sí Olúwa.” ");
INSERT INTO yor_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Nígbà náà ni Olúwa wí fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Nígbà tí ìwọ bá ka iye àwọn ọmọ Israẹli láti mọ iye wọn, ẹnìkọ̀ọ̀kan wọn gbọdọ̀ mú ìràpadà ọkàn rẹ̀ wá fún Olúwa ní ìgbà tí o bá ka iye wọn. Nígbà náà ni àjàkálẹ̀-ààrùn kì yóò súnmọ́ wọn, nígbà tí o bá ń ka iye wọn. ");
INSERT INTO yor_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Olúkúlùkù ẹrù tí ó bá kọjá lọ sọ́dọ̀ àwọn tí a ti kà yóò san ìdajì ṣékélì, gẹ́gẹ́ bí ṣékélì ibi mímọ́, èyí tí ó wọn ogún gera. Ìdajì ṣékélì yìí ní ọrẹ fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Gbogbo àwọn tí ó bá kọjá sínú àwọn tí a kà láti ẹni ogún ọdún tàbí jù bẹ́ẹ̀ lọ, ni yóò fi ọrẹ fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Àwọn olówó kì yóò san ju ìdajì ṣékélì lọ, àwọn tálákà kò sì gbọdọ̀ dín ní ìdajì ṣékélì nígbà tí ẹ̀yin bá mú ọrẹ wá fún Olúwa láti ṣe ètùtù fún ọkàn yín. ");
INSERT INTO yor_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ìwọ yóò sì gba owó ètùtù náà lọ́wọ́ àwọn ọmọ Israẹli, ìwọ yóò sì fi lélẹ̀ fún ìsìn àgọ́ àjọ. Yóò jẹ́ ìrántí fún àwọn ọmọ Israẹli níwájú Olúwa, láti ṣe ètùtù fún ọkàn yín.” ");
INSERT INTO yor_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Nígbà náà ni Olúwa wí fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Ìwọ yóò sì ṣe agbada idẹ kan, àti ẹsẹ̀ rẹ̀ idẹ, fún wíwẹ̀. Ìwọ yóò sì gbé e sí àárín àgọ́ àjọ àti pẹpẹ náà, ìwọ yóò sì pọn omi sínú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaroni àti àwọn ọmọ rẹ̀ yóò máa wẹ ọwọ́ àti ẹsẹ̀ wọn pẹ̀lú omi tí ó wà nínú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Nígbàkígbà tí wọ́n bá wọ inú àgọ́ àjọ, wọ́n yóò wẹ̀ pẹ̀lú omi nítorí kí wọ́n má ba à kú. Bákan náà, nígbà tí wọ́n bá súnmọ́ ibi pẹpẹ láti ṣe ìsìn, láti mú ẹbọ ti a fi iná sun wá fún Olúwa, ");
INSERT INTO yor_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","wọn yóò sì wẹ ọwọ́ wọn àti ẹsẹ̀ wọn, nítorí kí wọn máa ba à kú. Èyí ni yóò jẹ́ ìlànà títí láé fún Aaroni àti irú àwọn ọmọ rẹ̀ fún ìrandíran wọn.” ");
INSERT INTO yor_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ìwọ yóò mú ààyò tùràrí olóòórùn sí ọ̀dọ̀ rẹ; ẹ̀ẹ́dẹ́gbẹ̀ta ṣékélì (kilogiramu mẹ́fà) tí òjìá ṣíṣàn, ìdajì bí ó bá yẹ àádọ́ta lé nígba (250) ṣékélì tí kinamoni dídùn, àti kénì dídùn àádọ́ta lé nígba (250) ṣékélì, ");
INSERT INTO yor_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","kasia ẹ̀ẹ́dẹ́gbẹ̀ta (500) ṣékélì gbogbo rẹ̀ ní ìlànà ṣékélì ibi mímọ́ àti hínì òróró olifi kan (lita mẹ́rin). ");
INSERT INTO yor_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ṣe ìwọ̀nyí ní òróró mímọ́ ìkunra, tí a pò gẹ́gẹ́ bí olùṣe òórùn dídùn tì í ṣe. Yóò jẹ òróró mímọ́ ìtasórí. ");
INSERT INTO yor_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ìwọ yóò sì lò ó láti ya àgọ́ sí mímọ́ àti àpótí ẹ̀rí náà, ");
INSERT INTO yor_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","tábìlì àti gbogbo ohun èlò rẹ̀, ọ̀pá fìtílà àti ohun èlò rẹ̀, àti pẹpẹ tùràrí, ");
INSERT INTO yor_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","pẹpẹ ẹbọ sísun àti gbogbo ohun èlò rẹ̀, àti agbada pẹ̀lú ẹsẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ìwọ yóò sì sọ wọ́n di mímọ́, nítorí kí wọn lè jẹ́ mímọ́ jùlọ, àti ohunkóhun tí ó bá fi ọwọ́ kàn wọn yóò di mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Ìwọ yóò sì ta òróró sí orí Aaroni àti àwọn ọmọ rẹ̀, ìwọ yóò sì sọ wọ́n di mímọ́, nítorí kí wọn lè sìn mí bí àlùfáà. ");
INSERT INTO yor_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ìwọ yóò sì sọ fún àwọn ọmọ Israẹli pé, ‘Èyí ni yóò ṣe òróró mímọ́ ìtasórí mi fún ìrandíran tó ń bọ̀. ");
INSERT INTO yor_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Má ṣe dà á sí ara ènìyàn kí o má sì ṣe ṣe òróró kankan ni irú rẹ̀. Mímọ́ ni, ẹ̀yin sì gbọdọ̀ kà á sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ẹnikẹ́ni tí ó bá po irú rẹ̀, tàbí ẹnikẹ́ni tí ó bá fi sára àlejò yàtọ̀ sí àlùfáà, a ó gé e kúrò nínú àwọn ènìyàn rẹ̀.’ ” ");
INSERT INTO yor_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Olúwa sọ fún Mose pé, “Mú tùràrí olóòórùn dídùn sọ́dọ̀ rẹ, onika, àti galibanumu àti kìkì tùràrí dáradára, òsùwọ̀n kan fún gbogbo rẹ, ");
INSERT INTO yor_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ṣe tùràrí olóòórùn dídùn tí a pò, iṣẹ́ àwọn olóòórùn, tí ó ní iyọ̀, ó dára, ó sì jẹ́ mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ìwọ yóò sì lọ díẹ̀ nínú rẹ̀ kúnná, ìwọ yóò sì gbé e síwájú ẹ̀rí ní àgọ́ àjọ, níbi tí èmi yóò ti pàdé yín. Yóò sì jẹ́ mímọ́ jùlọ fún yín. ");
INSERT INTO yor_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ẹ má ṣe ṣe tùràrí kankan ní irú èyí fúnra yín; ẹ kà á ní mímọ́ sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ẹnikẹ́ni tí ó bá ṣe irú rẹ̀ láti máa gbádùn òórùn rẹ̀, òun ni a ó gé kúrò nínú àwọn ènìyàn rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Olúwa wí fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Wò ó, Èmi ti yan Besaleli ọmọ Uri, ọmọ Huri, ti ẹ̀yà Juda, ");
INSERT INTO yor_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Èmi sì ti fi Ẹ̀mí Ọlọ́run kún un pẹ̀lú ọgbọ́n, òye àti ìmọ̀ ní gbogbo onírúurú iṣẹ́ ọnà. ");
INSERT INTO yor_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Láti ṣe aláràbarà iṣẹ́ ní wúrà, fàdákà àti idẹ, ");
INSERT INTO yor_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","láti gbẹ́ òkúta àti láti tò wọ́n, láti ṣiṣẹ́ ní igi, àti láti ṣiṣẹ́ ní gbogbo onírúurú iṣẹ́ ọnà. ");
INSERT INTO yor_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Síwájú sí i, èmi ti yan Oholiabu ọmọ Ahisamaki, ti ẹ̀yà Dani, láti ràn án lọ́wọ́. “Bákan náà, Èmi ti fi ọgbọ́n fún gbogbo àwọn oníṣẹ́-ọnà láti ṣe ohun gbogbo tí mo pàṣẹ fún ọ: ");
INSERT INTO yor_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“àgọ́ àjọ náà, àpótí ẹ̀rí pẹ̀lú ìtẹ́ àánú tí ó wà lórí rẹ̀, àti gbogbo ohun èlò àgọ́ náà, ");
INSERT INTO yor_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tábìlì àti ohun èlò rẹ̀, ọ̀pá fìtílà tí ó jẹ́ kìkì wúrà àti gbogbo ohun èlò rẹ̀, pẹpẹ tùràrí, ");
INSERT INTO yor_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","pẹpẹ ẹbọ sísun àti gbogbo ohun èlò rẹ̀, agbada pẹ̀lú ẹsẹ̀ rẹ̀, ");
INSERT INTO yor_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","àti aṣọ híhun pẹ̀lú, papọ̀ pẹ̀lú aṣọ mímọ́ fún Aaroni àlùfáà àti aṣọ fún àwọn ọmọ rẹ̀ nígbà tí wọ́n bá ń ṣiṣẹ́ bí àlùfáà, ");
INSERT INTO yor_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","òróró ìtasórí àti tùràrí olóòórùn dídùn fún Ibi Mímọ́. “Kí wọ́n ṣe wọ́n gẹ́gẹ́ bí mo ṣe pàṣẹ fún ọ.” ");
INSERT INTO yor_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Olúwa wí fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Kí ìwọ kí ó sọ fún àwọn ọmọ Israẹli pé, ‘Ẹ̀yin gbọdọ̀ máa pa ọjọ́ ìsinmi mi mọ́. Èyí ni yóò jẹ́ àmì láàrín Èmi àti ẹ̀yin fún ìrandíran tó ń bọ̀, nítorí kí ẹ̀yin lè mọ̀ pé Èmi ni Olúwa, ẹni tí ó yà yín sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Nítorí náà, kí ẹ̀yin kí ó máa pa ọjọ́ ìsinmi mọ́, nítorí mímọ́ ni fún un yín. Ẹnikẹ́ni tí ó bá bà á jẹ́, ni a yóò pa; ẹnikẹ́ni tí ó bá ṣe iṣẹ́ kankan ní ọjọ́ náà ni a yóò gé kúrò nínú àwọn ènìyàn rẹ. ");
INSERT INTO yor_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ọjọ́ mẹ́fà ni kí ẹ fi ṣiṣẹ́, ṣùgbọ́n ọjọ́ keje ní ọjọ́ ìsinmi tí ẹ̀yin yóò fi sinmi, mímọ́ ni fún Olúwa. Ẹnikẹ́ni tí ó bá ṣiṣẹ́ ní ọjọ́ ìsinmi ni a ó pa nítòótọ́. ");
INSERT INTO yor_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Nítorí náà ni àwọn ọmọ Israẹli yóò ṣe máa pa ọjọ́ ìsinmi mọ́, ẹ máa ṣe àkíyèsí rẹ̀ dé ìrandíran tó ń bọ̀ bí i májẹ̀mú títí láé. ");
INSERT INTO yor_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Yóò jẹ́ àmì láàrín Èmi àti àwọn ọmọ Israẹli títí láé, nítorí ní ọjọ́ mẹ́fà ni Olúwa dá ọ̀run àti ayé, àti ní ọjọ́ keje ni ó fi iṣẹ́ sílẹ̀, ó sì sinmi.’ ” ");
INSERT INTO yor_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Nígbà tí Olúwa parí ọ̀rọ̀ sísọ fún Mose lórí òkè Sinai, ó fún un ní òkúta wàláà ẹ̀rí méjì, òkúta wàláà òkúta tí a fi ìka Ọlọ́run kọ. ");
INSERT INTO yor_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Nígbà tí àwọn ènìyàn rí i pé Mose pẹ́ kí ó tó sọ̀kalẹ̀ láti orí òkè wá, wọn péjọ yí Aaroni ká, wọ́n sì wí pé, “Wá, dá òrìṣà tí yóò máa ṣáájú wa fún wa. Bí ó ṣe ti Mose tí ó mú wa jáde láti Ejibiti wá, àwa kò mọ́ ohun tí ó ti ṣẹlẹ̀ sí i.” ");
INSERT INTO yor_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaroni dá wọn lóhùn pé, “Ẹ bọ́ òrùka wúrà tí ó wà ní etí àwọn ìyàwó yín, tí àwọn ọmọkùnrin yín, àti tí àwọn ọmọbìnrin yín, kí ẹ sì mú wọn wá sí ọ̀dọ̀ mi.” ");
INSERT INTO yor_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Bẹ́ẹ̀ ni gbogbo àwọn ènìyàn bọ́ òrùka etí wọn, wọn sì kó wọn wá fún Aaroni. ");
INSERT INTO yor_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ó sì gbà wọ́n ní ọwọ́ wọn, ó sì fi ṣe ohun ọnà fínfín, ó sì dà á ní àwòrán ẹgbọrọ màlúù. Nígbà náà ni wọn wí pé, “Israẹli, wọ̀nyí ni òrìṣà, ti ó mú un yín jáde wá láti Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Nígbà ti Aaroni rí èyí, ó kọ́ pẹpẹ kan níwájú ẹgbọrọ màlúù náà, ó sì kéde pé, “Lọ́la ni àjọyọ̀ sí Olúwa.” ");
INSERT INTO yor_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Bẹ́ẹ̀ ni àwọn ènìyàn dìde ní kùtùkùtù ọjọ́ kejì, wọ́n sì rú ẹbọ sísun, wọ́n sì mú ẹbọ àlàáfíà wá. Lẹ́yìn náà wọ́n jókòó láti jẹ àti láti mu, wọ́n sì dìde láti ṣeré. ");
INSERT INTO yor_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Olúwa sì wí fún Mose pé, “Sọ̀kalẹ̀ lọ, nítorí àwọn ènìyàn rẹ, tí ìwọ mú gòkè wá láti Ejibiti, wọ́n ti dẹ́ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Wọ́n ti yí kánkán kúrò nípa ọ̀nà tí mo ti mo pàṣẹ fún wọn, wọ́n sì ti dá ère ẹgbọrọ màlúù fún ara wọn. Wọ́n ti foríbalẹ̀ fún un, wọ́n sì ti rú ẹbọ sí i, wọ́n sì ti sọ pé, ‘Israẹli wọ̀nyí ní òrìṣà tí ó mú un yín jáde láti Ejibiti wá.’ ” ");
INSERT INTO yor_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Olúwa wí fún Mose pé, “Èmi ti rí àwọn ènìyàn wọ̀nyí, wọ́n sì jẹ́ ọlọ́rùn líle ènìyàn. ");
INSERT INTO yor_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ǹjẹ́ nísinsin yìí fi mí sílẹ̀, nítorí kí ìbínú mi lè gbóná sí wọn, kí Èmi sì lè pa wọ́n run. Nígbà náà ni Èmi yóò sọ ọ́ di orílẹ̀-èdè ńlá.” ");
INSERT INTO yor_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ṣùgbọ́n Mose kígbe fún ojúrere Olúwa Ọlọ́run rẹ̀, ó wí pé, “Olúwa, èéṣe tí ìbínú rẹ yóò ṣe gbóná sí àwọn ènìyàn rẹ, tí ìwọ mú jáde láti Ejibiti wá pẹ̀lú agbára ńlá àti ọwọ́ agbára? ");
INSERT INTO yor_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Èéṣe tí àwọn ará Ejibiti yóò ṣe wí pé, ‘Nítorí ibi ni ó ṣe mọ̀ ọ́n mọ̀ mú wọn jáde, láti pa wọ́n ní orí òkè àti láti gbá wọn kúrò lórí ayé’? Yípadà kúrò nínú ìbínú rẹ tí ó múná, yí ọkàn padà, kí o má sì ṣe mú ìparun wá sórí àwọn ènìyàn rẹ. ");
INSERT INTO yor_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Rántí àwọn ọmọ ọ̀dọ̀ rẹ Abrahamu, Isaaki àti Israẹli, ẹni tí ìwọ búra fún fúnra rẹ̀, ‘Tí o wí fún wọn pé, Èmi yóò mú irú-ọmọ rẹ pọ̀ bí ìràwọ̀ ojú ọ̀run, Èmi yóò sì fún irú-ọmọ rẹ ní gbogbo ilẹ̀ tí mo ti pinnu fún wọn, yóò sì jẹ́ ogún ìní wọn láéláé.’ ” ");
INSERT INTO yor_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Nígbà náà ni Olúwa dáwọ́ ìbínú rẹ̀ dúró, kò sì mú ìparun náà tí ó sọ wá sórí àwọn ènìyàn rẹ̀ mọ́. ");
INSERT INTO yor_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mose sì yípadà, ó sì sọ̀kalẹ̀ láti orí òkè náà pẹ̀lú òkúta wàláà ẹ̀rí méjì ní ọwọ́ rẹ̀. Wọ́n kọ ìwé síhà méjèèjì, iwájú àti ẹ̀yin. ");
INSERT INTO yor_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Iṣẹ́ Ọlọ́run sì ni wàláà náà; ìkọ̀wé náà jẹ́ ìkọ̀wé Ọlọ́run, a fín in sára àwọn òkúta wàláà náà. ");
INSERT INTO yor_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Nígbà tí Joṣua gbọ́ ariwo àwọn ènìyàn tí wọ́n ń kígbe, ó sọ fún Mose pé, “Ariwo ogun wà nínú àgọ́.” ");
INSERT INTO yor_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mose dáhùn pé, “Kì í ṣe ariwo fún ìṣẹ́gun, kì í ṣe ariwo fún aṣẹ́gun; ohùn àwọn tí ń kọrin ni mo gbọ́.” ");
INSERT INTO yor_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Nígbà tí Mose dé àgọ́, ó sì rí ẹgbọrọ màlúù náà àti ijó, ìbínú rẹ gbóná, ó sì sọ wàláà ọwọ́ rẹ̀ sílẹ̀, ó sì fọ́ wọn sí wẹ́wẹ́ ní ìsàlẹ̀ òkè náà. ");
INSERT INTO yor_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ó sì gbé ẹgbọrọ màlúù tí wọ́n ṣe, ó sì fi iná jó wọn; ó sì lọ̀ wọ́n kúnná, ó dà á sínú omi, ó sì mú àwọn ọmọ Israẹli mu ún. ");
INSERT INTO yor_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mose sọ fún Aaroni pé, “Kí ni àwọn ènìyàn wọ̀nyí ṣe sí ọ, tí ìwọ ṣe mú wọn dá ẹ̀ṣẹ̀ ńlá yìí?” ");
INSERT INTO yor_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaroni dáhùn wí pé, “Má ṣe bínú olúwa mi. Ìwọ mọ bí àwọn ènìyàn yìí ṣe burú tó. ");
INSERT INTO yor_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Wọ́n sọ fún mi pé, ‘Ṣe òrìṣà fún wa, tí yóò máa ṣáájú wa. Bí ó ṣe ti Mose ẹni tí ó mú wa jáde láti Ejibiti wá àwa kò mọ ohun tí ó ṣẹlẹ̀ sí i.’ ");
INSERT INTO yor_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Bẹ́ẹ̀ ni mo sọ fún wọn pé, ‘Ẹnikẹ́ni tí ó ní òrùka wúrà, kí ó bọ́ ọ wá.’ Nígbà náà ni wọ́n fún mi ní wúrà, mo sì jù ú sínú iná, a sì fi ṣe ẹgbọrọ màlúù yìí!” ");
INSERT INTO yor_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mose rí pé àwọn ènìyàn náà kò ṣe ṣàkóso àti pé Aaroni ti sọ wọ́n di aláìlákóṣo láàrín àwọn ọ̀tá tí ó dìde sí wọn. ");
INSERT INTO yor_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Bẹ́ẹ̀ ni Mose dúró ní ẹnu-ọ̀nà àgọ́, ó sì wí pé, “Ẹnikẹ́ni tí ó bá wà fún Olúwa, kí ó wá sí ọ̀dọ̀ mi.” Gbogbo àwọn ará Lefi sì péjọ yí i ká. ");
INSERT INTO yor_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Nígbà náà ni ó sọ fún wọn pé, “Èyí ni Olúwa, Ọlọ́run Israẹli, wí pé, ‘Kí olúkúlùkù ọkùnrin kí ó kọ idà rẹ̀ sí ẹ̀gbẹ́ rẹ̀. Ẹ lọ padà, kí ẹ jà láti àgọ́ kan dé òmíràn, olúkúlùkù kí ó pa arákùnrin rẹ̀ ọ̀rẹ́ rẹ̀ àti aládùúgbò rẹ.’ ” ");
INSERT INTO yor_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Àwọn ará Lefi ṣe gẹ́gẹ́ bí Mose ṣe pàṣẹ, àti ní ọjọ́ náà àwọn tí ó kú tó ẹgbẹ̀rún mẹ́ta (3,000) ènìyàn. ");
INSERT INTO yor_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Nígbà náà ni Mose wí pé, “Ẹ ti ya ara yín sọ́tọ̀ fún Olúwa lónìí, nítorí ìwọ ti dìde sí àwọn ọmọ rẹ àti arákùnrin rẹ, ó sì ti bùkún fún ọ lónìí.” ");
INSERT INTO yor_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ní ọjọ́ kejì Mose sọ fún àwọn ènìyàn náà pé, “Ẹ̀yin ti dá ẹ̀ṣẹ̀ tí ó pọ̀. Ṣùgbọ́n nísinsin yìí èmi yóò gòkè lọ bá Olúwa; bóyá èmi lè ṣe ètùtù fún ẹ̀ṣẹ̀ yín.” ");
INSERT INTO yor_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Bẹ́ẹ̀ ni Mose padà tọ Olúwa lọ, ó sì wí pé, “Yé, kí ni ẹ̀ṣẹ̀ ńlá tí àwọn ènìyàn ti dá yìí! Wọ́n ti ṣe òrìṣà wúrà fún ara wọn. ");
INSERT INTO yor_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ṣùgbọ́n nísinsin yìí, jọ̀wọ́ dárí ẹ̀ṣẹ̀ wọn jì wọ́n ṣùgbọ́n tí kò bá sì ṣe bẹ́ẹ̀, pa orúkọ mi rẹ́ kúrò nínú ìwé tí ìwọ ti kọ.” ");
INSERT INTO yor_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Olúwa dá Mose lóhùn pé, “Ẹnikẹ́ni tí ó bá dẹ́ṣẹ̀ sí mi, Èmi yóò pa á rẹ́ kúrò nínú ìwé mi. ");
INSERT INTO yor_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ǹjẹ́ nísinsin yìí lọ, máa darí àwọn ènìyàn yìí lọ sí ibi ti mo sọ, angẹli mi yóò sì máa lọ ṣáájú yín. Ìgbà ń bọ̀ fún mi tì Èmi yóò ṣe ìbẹ̀wò, Èmi yóò fi yà jẹ wọ́n fún ẹ̀ṣẹ̀ wọn.” ");
INSERT INTO yor_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Olúwa sì yọ àwọn ènìyàn náà lẹ́nu, pẹ̀lú ààrùn nítorí ohun tí wọ́n ṣe ní ti ẹgbọrọ màlúù tí Aaroni ṣe. ");
INSERT INTO yor_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Olúwa sọ fún Mose pé, “Fi ìhín yìí sílẹ̀, ìwọ àti àwọn ènìyàn tí o mú gòkè láti Ejibiti wá, kí ẹ sì gòkè lọ sí ilẹ̀ tí Èmi ti pinnu ní ìbúra fún Abrahamu, Isaaki àti Jakọbu wí pé, ‘Èmi yóò fi fún irú-ọmọ rẹ.’ ");
INSERT INTO yor_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Èmi yóò rán angẹli ṣáájú yín, Èmi yóò sì lé àwọn Kenaani, àwọn ará Amori, àwọn ará Hiti, àwọn ará Peresi, àwọn ará Hifi àti àwọn ará Jebusi jáde. ");
INSERT INTO yor_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ẹ gòkè lọ sí ilẹ̀ tí ó ń sàn fún wàrà àti oyin. Ṣùgbọ́n èmi kò ní lọ pẹ̀lú yín, nítorí ènìyàn ọlọ́rùn líle ni ẹ̀yin, kí èmi má ba à run yín ní ọ̀nà.” ");
INSERT INTO yor_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Nígbà tí àwọn ènìyàn náà gbọ́ ọ̀rọ̀ ìparun wọ̀nyí, wọ́n bẹ̀rẹ̀ sì ní kùn, ẹnìkankan kò sì le è wọ ohun ọ̀ṣọ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Nítorí Olúwa ti wí fún Mose pé, “Sọ fún àwọn ọmọ Israẹli pé, ‘Ènìyàn Ọlọ́rùn líle ní ẹ̀yin, bí Èmi bá lè wá sí àárín yín ni ìṣẹ́jú kan, Èmi lè pa yín run. Nísìnsinyìí, bọ́ ohun ọ̀ṣọ́ rẹ kúrò, Èmi yóò sì gbèrò ohun tí Èmi yóò ṣe pẹ̀lú rẹ.’ ” ");
INSERT INTO yor_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Bẹ́ẹ̀ àwọn ọmọ Israẹli bọ́ ohun ọ̀ṣọ́ wọn kúrò lára wọn ní òkè Horebu. ");
INSERT INTO yor_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mose máa ń gbé àgọ́ náà, ó sì pa á sí ìta ibùdó, ó jìnnà díẹ̀ sí ibùdó, ó pè é ni “Àgọ́ àjọ.” Ẹnikẹ́ni tí ó bá ń béèrè Olúwa yóò lọ sí ibi àgọ́ àjọ náà ní ìta ibùdó. ");
INSERT INTO yor_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Nígbàkígbà tí Mose bá jáde lọ sí ibi àgọ́, gbogbo ènìyàn á dìde, wọ́n á sì dúró sí ẹnu-ọ̀nà àgọ́ wọn, wọn yóò máa wo Mose títí yóò fi wọ inú àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Bí Mose ṣe wọ inú àgọ́ náà, ọ̀wọ́n àwọsánmọ̀ yóò sọ̀kalẹ̀, yóò sì dúró sí ẹnu ọnà, nígbà tí Olúwa ń sọ̀rọ̀ pẹ̀lú Mose. ");
INSERT INTO yor_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Nígbàkígbà tí àwọn ènìyàn bá rí i ti ọ̀wọ́n àwọsánmọ̀ bá dúró ní ẹnu-ọ̀nà àgọ́, gbogbo wọn yóò dìde wọn yóò sì sìn, olúkúlùkù ní ẹnu-ọ̀nà àgọ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Olúwa máa ń bá Mose sọ̀rọ̀ lójúkojú, gẹ́gẹ́ bí i pé ènìyàn ń bá ọ̀rẹ́ rẹ̀ sọ̀rọ̀. Nígbà náà ni Mose yóò tún padà lọ sí ibùdó, ṣùgbọ́n ọ̀dọ́mọkùnrin Joṣua ìránṣẹ́ rẹ̀ ọmọ Nuni kò fi àgọ́ sílẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mose sọ fún Olúwa pé, “Ìwọ ti ń sọ fún mi, ‘Darí àwọn ènìyàn wọ̀nyí,’ ṣùgbọ́n ìwọ kò jẹ́ kí ń mọ ẹni tí ìwọ yóò rán pẹ̀lú mi. Ìwọ ti wí pé, ‘Èmi mọ̀ ọ́n nípa orúkọ, ìwọ sì ti rí ojúrere mi pẹ̀lú.’ ");
INSERT INTO yor_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Bí ìwọ bá ní inú dídùn pẹ̀lú mi, kọ́ mi ní ọ̀nà rẹ, kí èmi kí ó lè mọ̀ ọ́n, kí n sì le máa wá ojúrere rẹ pẹ̀lú. Rántí wí pé orílẹ̀-èdè yìí ènìyàn rẹ ni.” ");
INSERT INTO yor_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Olúwa dáhùn wí pé, “Ojú mi yóò máa bá ọ lọ, Èmi yóò sì fún ọ ní ìsinmi.” ");
INSERT INTO yor_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Nígbà náà ni, Mose wí fún un pé, “Bí ojú rẹ kò bá bá wa lọ, má ṣe rán wa gòkè láti ìhín lọ. ");
INSERT INTO yor_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Báwo ni ẹnikẹ́ni yóò ṣe mọ̀ pé inú rẹ dùn pẹ̀lú mi àti pẹ̀lú àwọn ènìyàn rẹ àyàfi ti o bá bá wa lọ? Kí ni yóò lè yà mí àti àwọn ènìyàn rẹ kúrò lára gbogbo ènìyàn tí ó wà ní ayé?” ");
INSERT INTO yor_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Olúwa sì sọ fún Mose pé, “Èmi yóò ṣe ohun gbogbo tí ìwọ ti béèrè, nítorí inú mi dún sí o, Èmi sì mọ̀ ọ́n nípa orúkọ rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mose sì wí pé, “Nísinsin yìí fi ògo rẹ hàn mí.” ");
INSERT INTO yor_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Olúwa sì wí pé, “Èmi yóò sì mú gbogbo ìre mí kọjá níwájú rẹ, Èmi yóò sì pòkìkí orúkọ Olúwa níwájú rẹ. Èmi yóò ṣàánú fún ẹni tí Èmi yóò ṣàánú fún, Èmi yóò sì ṣoore-ọ̀fẹ́ fún ẹni tí Èmi yóò ṣoore-ọ̀fẹ́ fún. ");
INSERT INTO yor_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ṣùgbọ́n,” ó wí pé, “Ìwọ kò le è rí ojú mi, nítorí kò sí ènìyàn kan tí ń rí mi, tí ó lè yè.” ");
INSERT INTO yor_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Olúwa sì wí pé, “Ibìkan wà lẹ́gbẹ̀ẹ́ ọ̀dọ̀ mi, níbi tí o ti lè dúró lórí àpáta. ");
INSERT INTO yor_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Nígbà tí ògo mi bá kọjá, Èmi yóò gbé ọ sínú pàlàpálá àpáta, Èmi yóò sì bò ọ́ pẹ̀lú ọwọ́ mi títí Èmi yóò fi rékọjá. ");
INSERT INTO yor_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Nígbà tí Èmi yóò mú ọwọ́ mi kúrò, ìwọ yóò sì rí ẹ̀yìn mi; ṣùgbọ́n ojú mi ni o kò ní rí.” ");
INSERT INTO yor_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Olúwa sọ fún Mose pé, “E gé òkúta wàláà méjì jáde bí i ti àkọ́kọ́, Èmi yóò sì kọ àwọn ọ̀rọ̀ ìwé tó wà lára tí àkọ́kọ́ tí ìwọ ti fọ́ sára wọn. ");
INSERT INTO yor_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Múra ní òwúrọ̀, kí o sì wá sórí òkè Sinai. Kí o fi ara rẹ hàn mí lórí òkè náà. ");
INSERT INTO yor_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ẹnikẹ́ni kò gbọdọ̀ wá pẹ̀lú rẹ tàbí kí a rí wọn lórí òkè náà; bẹ́ẹ̀ ni agbo àgùntàn tàbí ọwọ́ ẹran kó má ṣe jẹ níwájú òkè náà.” ");
INSERT INTO yor_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Bẹ́ẹ̀ Mose sì gbẹ́ òkúta wàláà méjì bí ti àkọ́kọ́, ó sì gun orí òkè Sinai lọ ní kùtùkùtù òwúrọ̀, gẹ́gẹ́ bí Olúwa ti pa á láṣẹ fún un; Ó sì gbé òkúta wàláà méjèèjì náà sí ọwọ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Nígbà náà ni Olúwa sọ̀kalẹ̀ nínú àwọsánmọ̀, ó sì dúró níbẹ̀ pẹ̀lú rẹ̀, ó sì pòkìkí orúkọ Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ó sì kọjá níwájú Mose, ó sì ń ké pé, “Olúwa, Olúwa, Ọlọ́run aláàánú àti olóore-ọ̀fẹ́, Ẹni tí ó lọ́ra láti bínú, tí ó pọ̀ ní ìfẹ́ àti olóòtítọ́, ");
INSERT INTO yor_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ẹni tí ó ń pa ìfẹ́ mọ́ fún ẹgbẹ̀rún (1,000), ó sì ń dáríjì àwọn ẹni búburú, àwọn ti ń ṣọ̀tẹ̀ àti ẹlẹ́ṣẹ̀. Síbẹ̀ kì í fi àwọn ẹlẹ́bi sílẹ̀ láìjìyà; Ó ń fi ìyà jẹ ọmọ àti àwọn ọmọ wọn fún ẹ̀ṣẹ̀ àwọn baba dé ìran kẹta àti ẹ̀kẹrin.” ");
INSERT INTO yor_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mose foríbalẹ̀ lẹ́ẹ̀kan náà ó sì sìn. ");
INSERT INTO yor_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ó wí pé, “Olúwa, bí èmi bá rí ojúrere rẹ, nígbà náà jẹ́ kí Olúwa lọ pẹ̀lú wa. Bí ó tilẹ̀ jẹ́ pé, ènìyàn ọlọ́rùn líle ni wọn, dárí búburú àti ẹ̀ṣẹ̀ wa jì, kí o sì gbà wá gẹ́gẹ́ bí ìní rẹ.” ");
INSERT INTO yor_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Nígbà náà ni Olúwa wí pé, “Èmi dá májẹ̀mú kan pẹ̀lú yín. Níwájú gbogbo ènìyàn rẹ Èmi yóò ṣe ìyanu, tí a kò tí ì ṣe ní orílẹ̀-èdè ní gbogbo ayé rí. Àwọn ènìyàn tí ìwọ ń gbé láàrín wọn yóò rí i bí iṣẹ́ tí Èmi Olúwa yóò ṣe fún ọ ti ní ẹ̀rù tó. ");
INSERT INTO yor_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ṣe ohun tí Èmi pàṣẹ fún ọ lónìí. Èmi lé àwọn ará Amori, àwọn ará Kenaani, àwọn ará Peresi, àwọn ará Hiti, àwọn ará Hifi àti àwọn ará Jebusi jáde níwájú rẹ. ");
INSERT INTO yor_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Máa ṣọ́ra kí o má ba à bá àwọn ti ó n gbé ilẹ̀ náà tí ìwọ ń lọ dá májẹ̀mú, nítorí wọn yóò jẹ́ ìdẹwò láàrín rẹ. ");
INSERT INTO yor_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Wó pẹpẹ wọn lulẹ̀, fọ́ òkúta mímọ́ wọn, kí o sì gé òpó Aṣerah wọn. (Ère òrìṣà wọn.) ");
INSERT INTO yor_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ẹ má ṣe sin ọlọ́run mìíràn, nítorí Olúwa, orúkọ ẹni ti ń jẹ́ Òjòwú, Ọlọ́run owú ni. ");
INSERT INTO yor_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Máa ṣọ́ra kí ẹ má ṣe bá àwọn ènìyàn tí ń gbé ilẹ̀ náà dá májẹ̀mú; nígbà tí wọ́n bá ń ṣe àgbèrè tọ òrìṣà wọn, tí wọ́n sì rú ẹbọ sí wọn, wọn yóò pè yín, ẹ̀yin yóò sì jẹ ẹbọ wọn. ");
INSERT INTO yor_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Nígbà tí ìwọ bá yàn nínú àwọn ọmọbìnrin wọn fún àwọn ọmọkùnrin rẹ ní ìyàwó, àwọn ọmọbìnrin wọ̀nyí yóò ṣe àgbèrè tọ òrìṣà wọn, wọn yóò sì mú kí àwọn ọmọkùnrin yín náà ṣe bẹ́ẹ̀ gẹ́gẹ́. ");
INSERT INTO yor_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Ìwọ kò gbọdọ̀ dá ère òrìṣàkórìṣà fún ara rẹ. ");
INSERT INTO yor_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Àjọ àkàrà àìwú ni kí ìwọ máa pamọ́. Fún ọjọ́ méje ni ìwọ yóò jẹ àkàrà aláìwú, gẹ́gẹ́ bí Èmi ti pa á láṣẹ fún ọ. Ṣe èyí ní ìgbà tí a yàn nínú oṣù Abibu, nítorí ní oṣù náà ni ẹ jáde láti Ejibiti wá. ");
INSERT INTO yor_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Gbogbo àkọ́bí inú kọ̀ọ̀kan tèmi ní i ṣe, pẹ̀lú àkọ́bí gbogbo ohun ọ̀sìn rẹ, bóyá ti màlúù tàbí ti àgùntàn. ");
INSERT INTO yor_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Àkọ́bí kẹ́tẹ́kẹ́tẹ́ ni kí ìwọ kí ó fi ọ̀dọ́-àgùntàn rà padà, ṣùgbọ́n bí ìwọ kò bá rà á padà, dá ọrùn rẹ̀. Ra gbogbo àkọ́bí ọkùnrin rẹ padà. “Ẹnikẹ́ni kò gbọdọ̀ wá síwájú mi ní ọwọ́ òfo. ");
INSERT INTO yor_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Ọjọ́ mẹ́fà ni ìwọ yóò ṣiṣẹ́, ṣùgbọ́n ní ọjọ́ keje ìwọ yóò sinmi; kódà ní àkókò ìfúnrúgbìn àti ní àkókò ìkórè ìwọ gbọdọ̀ sinmi. ");
INSERT INTO yor_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Ṣe àjọ ọ̀sẹ̀ pẹ̀lú àkọ́so èso alikama àti àjọ ìkórè ní òpin ọdún. ");
INSERT INTO yor_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ní ẹ̀ẹ̀mẹ́ta lọ́dún, gbogbo àwọn ọkùnrin ni kí ó farahàn níwájú Olúwa Olódùmarè, Ọlọ́run Israẹli. ");
INSERT INTO yor_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Èmi yóò lé orílẹ̀-èdè jáde níwájú rẹ, Èmi yóò sì mú kí ìpín rẹ fẹ̀, ẹnikẹ́ni kì yóò gba ilẹ̀ rẹ nígbà tí ìwọ bá gòkè lọ ní ìgbà mẹ́ta lọ́dún kọ̀ọ̀kan láti farahàn níwájú Olúwa Ọlọ́run rẹ. ");
INSERT INTO yor_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Má ṣe ta ẹ̀jẹ̀ ẹbọ sí mi pẹ̀lú ohunkóhun tí ó bá ní ìwúkàrà, kí o má sì ṣe jẹ́ kí ẹbọ ìrékọjá kù títí di òwúrọ̀. ");
INSERT INTO yor_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Mú àkọ́ká èso ilẹ̀ rẹ tí ó dára jùlọ wá sí ilé Olúwa Ọlọ́run rẹ. “Ìwọ kò gbọdọ̀ bọ ọmọ ewúrẹ́ nínú omi ọmú ìyá rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Olúwa sì wí fún Mose pé, “Kọ àwọn ọ̀rọ̀ wọ̀nyí sílẹ̀, nítorí nípa àwọn ọ̀rọ̀ wọ̀nyí ni Èmi bá ìwọ àti Israẹli dá májẹ̀mú.” ");
INSERT INTO yor_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mose wà níbẹ̀ pẹ̀lú Olúwa fún ogójì ọ̀sán àti ogójì òru láìjẹ oúnjẹ tàbí mu omi. Ó sì kọ ọ̀rọ̀ májẹ̀mú náà òfin mẹ́wàá sára wàláà. ");
INSERT INTO yor_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Nígbà tí Mose sọ̀kalẹ̀ láti orí òkè Sinai pẹ̀lú wàláà ẹ̀rí méjì ní ọwọ́ rẹ̀, òun kò mọ̀ pé ojú òun ń dán nítorí ó bá Olúwa sọ̀rọ̀. ");
INSERT INTO yor_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Nígbà tí Aaroni àti gbogbo àwọn ọmọ Israẹli rí Mose, ojú rẹ̀ ń dán, ẹ̀rù sì ń bà wọ́n láti súnmọ́ ọn. ");
INSERT INTO yor_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ṣùgbọ́n Mose pè wọn; Aaroni àti gbogbo àwọn olórí àjọ padà wá bá a, ó sì bá wọn sọ̀rọ̀. ");
INSERT INTO yor_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Lẹ́yìn èyí gbogbo àwọn ọmọ Israẹli súnmọ́ ọn, ó sì fún wọn ní gbogbo àṣẹ tí Olúwa fún un lórí òkè Sinai. ");
INSERT INTO yor_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Nígbà tí Mose parí ọ̀rọ̀ sísọ fún wọn. Ó fi ìbòjú bo ojú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ṣùgbọ́n nígbàkígbà tí Mose bá wà níwájú Olúwa láti bá a sọ̀rọ̀, á ṣí ìbòjú náà títí yóò fi jáde. Nígbà tí ó bá sì jáde, á sì sọ fún àwọn ọmọ Israẹli ohun tí a ti pàṣẹ fún un, ");
INSERT INTO yor_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","àwọn ọmọ Israẹli sì rí i pé ojú rẹ̀ ń dán. Mose á sì tún fi ìbòjú bo ojú rẹ̀ títí á fi lọ bá Olúwa sọ̀rọ̀. ");
INSERT INTO yor_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mose pe gbogbo ìjọ Israẹli ó sì wí fún wọn pé, “Wọ̀nyí ni àwọn ohun ti Olúwa ti pàṣẹ fún un yín láti ṣe. ");
INSERT INTO yor_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Fún ọjọ́ mẹ́fà ni kí ẹ fi ṣiṣẹ́, ṣùgbọ́n ọjọ́ keje yóò jẹ́ ọjọ́ mímọ́ fún yín, ọjọ́ ìsinmi ni sí Olúwa. Ẹnikẹ́ni tí ó bá ṣe iṣẹ́ kankan ni ọjọ́ náà ní a ó pa. ");
INSERT INTO yor_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ẹ má ṣe dáná kankan ní ibùgbé yín ní ọjọ́ ìsinmi.” ");
INSERT INTO yor_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mose sọ fún gbogbo ìjọ àwọn ọmọ Israẹli pé, “Èyí ni ohun tí Olúwa pàṣẹ. ");
INSERT INTO yor_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Láti inú ohun tí ẹ ni ni kí ẹ ti mú ọrẹ fún Olúwa. Ẹnikẹ́ni tí ó bá fẹ́ ni kí ó mú ọrẹ fún Olúwa ní ti: “wúrà, fàdákà àti idẹ; ");
INSERT INTO yor_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","aṣọ aláró, elése àlùkò, òdòdó àti ọ̀gbọ̀ dáradára; àti irun ewúrẹ́; ");
INSERT INTO yor_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","awọ àgbò tí a kùn ní pupa àti awọ màlúù; odò igi kasia; ");
INSERT INTO yor_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","òróró olifi fún títan iná; olóòórùn fún òróró ìtasórí, àti fún tùràrí dídùn; ");
INSERT INTO yor_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","òkúta óníkìsì àti òkúta tí a tò sí ẹ̀wù efodu àti ìgbàyà. ");
INSERT INTO yor_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Gbogbo ẹni tí ó ní ọgbọ́n láàrín yín, kí ó wa, kí ó sì wá ṣe gbogbo ohun tí Olúwa ti pàṣẹ: ");
INSERT INTO yor_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“àgọ́ náà pẹ̀lú àgọ́ rẹ àti ìbòrí rẹ̀, kọ́kọ́rọ́ rẹ̀, pákó rẹ̀, ọ̀pá rẹ̀, ọ̀wọ́n rẹ̀ àti ihò ìtẹ̀bọ̀ rẹ̀; ");
INSERT INTO yor_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Àpótí náà pẹ̀lú ọ̀pá rẹ̀, ìbò àánú àti aṣọ títa náà tí ó síji bò ó. ");
INSERT INTO yor_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Tábìlì náà pẹ̀lú òpó rẹ̀ àti gbogbo ohun èlò rẹ̀ àti àkàrà ìfihàn náà. ");
INSERT INTO yor_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Ọ̀pá fìtílà tí ó wà fún títanná pẹ̀lú ohun èlò rẹ̀, fìtílà àti òróró fún títanná. ");
INSERT INTO yor_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Pẹpẹ tùràrí náà pẹ̀lú ẹsẹ̀ rẹ̀, òróró ìtasórí àti tùràrí dídùn; aṣọ títa fún ọ̀nà ìlẹ̀kùn ní ẹnu-ọ̀nà sí àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Pẹpẹ ẹbọ sísun pẹ̀lú ojú ààrò idẹ rẹ̀, òpó rẹ̀ àti gbogbo ohun èlò rẹ̀; agbada idẹ pẹ̀lú ẹsẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Aṣọ títa ti àgbàlá pẹ̀lú, ọ̀wọ́n àti ihò ìtẹ̀bọ̀ rẹ̀ àti aṣọ títa fún ẹnu-ọ̀nà àgbàlá náà. ");
INSERT INTO yor_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Èèkàn àgọ́ náà fún àgọ́ náà àti fún àgbàlá àti okùn wọn. ");
INSERT INTO yor_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Aṣọ híhun láti ṣiṣẹ́ ní ibi mímọ́ aṣọ mímọ́ fún Aaroni àlùfáà àti aṣọ fún àwọn ọmọ rẹ̀ nígbà tí wọ́n sìn bí àlùfáà.” ");
INSERT INTO yor_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Gbogbo ìjọ àwọn ọmọ Israẹli sì kúrò níwájú Mose, ");
INSERT INTO yor_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","olúkúlùkù ẹni tí ó fẹ́ àti ẹni tí ọkàn rẹ̀ gbé sókè wá, wọ́n sì mú ọrẹ fún Olúwa, fún iṣẹ́ àgọ́ àjọ, fún gbogbo ìsìn rẹ̀ àti fún aṣọ mímọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Gbogbo àwọn tí ó fẹ́, ọkùnrin àti obìnrin, wọ́n wá wọ́n sì mú onírúurú ìlẹ̀kẹ̀ wúrà: òrùka etí, òrùka àti ọ̀ṣọ́. Gbogbo wọn mú wúrà gẹ́gẹ́ bí ọrẹ wá fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Olúkúlùkù ẹni tí ó ni aṣọ aláró elése àlùkò, òdòdó àti ọ̀gbọ̀ dáradára, tàbí irun ewúrẹ́, awọ àgbò tí a rì ní pupa tàbí awọ màlúù odò, kí ó mú wọn wá. ");
INSERT INTO yor_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Àwọn tí ó mú ọrẹ fàdákà tàbí idẹ wá, mú ọrẹ wá fún Olúwa, àti olúkúlùkù ẹni tí ó ní igi ṣittimu fún ipa kankan nínú iṣẹ́ mú un wá. ");
INSERT INTO yor_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Gbogbo àwọn obìnrin tí ó ní ọgbọ́n ríran owú pẹ̀lú ọwọ́ rẹ̀, kí ó mú èyí ti ó ti ran wá ti aláró, ti elése àlùkò, ti òdòdó tàbí ti ọ̀gbọ̀ dáradára. ");
INSERT INTO yor_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Gbogbo àwọn obìnrin tí ó fẹ́, tí ó sì ní ọgbọ́n ń ran òwú irun ewúrẹ́. ");
INSERT INTO yor_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Àwọn olórí mú òkúta óníkìsì wá láti tò ó lórí ẹ̀wù efodu àti ìgbàyà. ");
INSERT INTO yor_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Wọ́n sì tún mú olóòórùn àti òróró olifi wá fún títanná àti fún òróró ìtasórí àti fún tùràrí dídùn. ");
INSERT INTO yor_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Gbogbo àwọn ènìyàn Israẹli ọkùnrin àti obìnrin ẹni tí ó fẹ́ mú ọrẹ àtinúwá fún Olúwa fún gbogbo iṣẹ́ tí Olúwa ti pàṣẹ fún wọn láti ṣe nípasẹ̀ Mose. ");
INSERT INTO yor_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Nígbà náà ni Mose wí fún àwọn ọmọ Israẹli pé, “Wò ó, Olúwa ti yan Besaleli ọmọ Uri, ọmọ Huri, ti ẹ̀yà Juda, ");
INSERT INTO yor_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ó sì ti fi Ẹ̀mí Ọlọ́run kún un, pẹ̀lú ọgbọ́n, òye, ìmọ̀ àti gbogbo onírúurú iṣẹ́ ọnà. ");
INSERT INTO yor_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Láti máa ṣe aláràbarà iṣẹ́ ní ti wúrà, fàdákà àti idẹ, ");
INSERT INTO yor_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","láti gbẹ́ òkúta àti láti tò ó, láti fún igi àti láti ṣiṣẹ́ ni gbogbo onírúurú iṣẹ́ ọnà. ");
INSERT INTO yor_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ó sì fún òun àti Oholiabu ọmọ Ahisamaki ti ẹ̀yà Dani, ni agbára láti kọ́ àwọn tókù. ");
INSERT INTO yor_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ó sì fi ọgbọ́n kún wọn láti ṣe gbogbo onírúurú iṣẹ́, ti oníṣọ̀nà, ti ayàwòrán, ti aránsọ, ti aláṣọ aláró, ti elése àlùkò, ti òdòdó àti ní ọ̀gbọ̀ dáradára àti ti ahunṣọ, gbogbo èyí tí ọ̀gá oníṣẹ́-ọnà àti ayàwòrán ń ṣe. ");
INSERT INTO yor_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Besaleli, Oholiabu àti olúkúlùkù ọlọ́gbọ́n ẹni tí Olúwa tí fún ní ọgbọ́n àti òye láti mọ bí a ti í ṣe gbogbo iṣẹ́ ibi mímọ́ ni kí wọn ṣe iṣẹ́ náà gẹ́gẹ́ bí Olúwa ti pa á láṣẹ.” ");
INSERT INTO yor_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mose sì pe Besaleli àti Oholiabu àti gbogbo ọlọ́gbọ́n ènìyàn ẹni tí Olúwa ti fún ni agbára àti gbogbo ẹni tí ó fẹ́ láti wá sé iṣẹ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Wọ́n gba gbogbo ọrẹ tí àwọn ọmọ Israẹli ti mú wá lọ́wọ́ Mose fún kíkọ́ ibi mímọ́ náà. Àwọn ènìyàn sì ń mú ọrẹ àtinúwá wá ní àràárọ̀. ");
INSERT INTO yor_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Bẹ́ẹ̀ ni gbogbo àwọn ọlọ́gbọ́n oníṣẹ́-ọnà tí wọn ń ṣe gbogbo iṣẹ́ ibi mímọ́ náà fi iṣẹ́ wọn sílẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Mose sì wí pé, “Àwọn ènìyàn mú púpọ̀ wá fún ṣíṣe iṣẹ́ náà ju bi Olúwa ti pa á láṣẹ láti ṣe lọ.” ");
INSERT INTO yor_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mose sì pàṣẹ, wọ́n sì rán iṣẹ́ yìí sí gbogbo ibùdó: “Kí ọkùnrin tàbí obìnrin má ṣe ṣe ohun kankan bí ọrẹ fún ibi mímọ́ náà mọ́.” Bẹ́ẹ̀ ni a dá àwọn ènìyàn lẹ́kun láti mú un wá sí i, ");
INSERT INTO yor_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","nítorí ohun tí wọ́n ti ní ti ju ohun tí wọn fẹ́ fi ṣe gbogbo iṣẹ́ náà lọ. ");
INSERT INTO yor_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Gbogbo àwọn ọlọ́gbọ́n ọkùnrin láàrín àwọn òṣìṣẹ́ ni wọ́n ṣe iṣẹ́ náà pẹ̀lú aṣọ títa mẹ́wàá ti ọ̀gbọ̀ olókùn dáradára, tí aṣọ aláró, ti elése àlùkò àti ti òdòdó, pẹ̀lú àwọn kérúbù ṣe iṣẹ́ sí wọn nípa ọgbọ́n iṣẹ́ ọnà. ");
INSERT INTO yor_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Gbogbo aṣọ títa náà ni kí ó jẹ́ ìwọ̀n kan náà: ìgbọ̀nwọ́ méjìdínlọ́gbọ̀n (28) ní gígùn àti ìgbọ̀nwọ́ mẹ́rin ni fífẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Aṣọ títa márùn-ún ni kí a so papọ̀ mọ́ ara wọn, àti aṣọ títa márùn-ún ni kí a so papọ̀ mọ́ ara wọn. ");
INSERT INTO yor_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ìwọ yóò ṣì ṣe ajábó aṣọ aláró sí aṣọ títa kan láti ìṣẹ́tí rẹ̀ wá níbi ìsopọ̀, àti bẹ́ẹ̀ gẹ́gẹ́ ni ìwọ yóò ṣe ni etí ìkangun aṣọ títa kejì, ni ibi ìsopọ̀ kejì. ");
INSERT INTO yor_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Àádọ́ta ajábó ní ó pa lára aṣọ títa kan, àti àádọ́ta ajábó ni ó sì lò pa ní etí aṣọ títa tí ó wà ní ìsolù kejì, ajábó náà sì wà ní ọ̀kánkán ara wọn. ");
INSERT INTO yor_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ó sì ṣe àádọ́ta ìkọ́ wúrà, ó sì lò ìkọ́ wọ̀n-ọn-nì láti fi aṣọ títa kan kọ́ èkejì, bẹ́ẹ̀ ó sì di odidi àgọ́ kan. ");
INSERT INTO yor_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ìwọ ó sì ṣe aṣọ títa irun ewúrẹ́ láti fi ṣe ìbò sórí àgọ́ náà—aṣọ títa mọ́kànlá ni ìwọ ó ṣe é. ");
INSERT INTO yor_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Gbogbo aṣọ títa mọ́kọ̀ọ̀kànlá náà jẹ́ ìwọ̀n kan náà, ọgbọ̀n ìgbọ̀nwọ́ ní gígùn àti ìgbọ̀nwọ́ mẹ́rin ní fífẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ó so aṣọ títa márùn-ún pọ̀ mọ́ ara wọn se ọ̀kan, ó sì tún so mẹ́fà tókù mọ́ ara wọn se ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ó sì pa àádọ́ta ajábó sí ìṣẹ́tí ìkangun aṣọ títa ní apá kan, wọ́n sì tún pa ajábó mìíràn sí ìṣẹ́tí ìkangun aṣọ títa ní apá kejì. ");
INSERT INTO yor_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Wọ́n ṣe àádọ́ta ìkọ́ idẹ láti so àgọ́ náà pọ̀ kí o lè jẹ́ ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ó sì ṣe ìbòrí awọ àgbò tí a rì ní pupa fún àgọ́ náà, àti ìbòrí awọ seali sórí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ó sì ṣe pákó igi kasia tí ó dúró òró fún àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ọ̀kọ̀ọ̀kan pákó náà jẹ́ ìgbọ̀nwọ́ mẹ́wàá ní gígùn àti ìgbọ̀nwọ́ kan ààbọ̀ ní fífẹ̀, ");
INSERT INTO yor_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","pẹ̀lú ìtẹ̀bọ̀ méjì tí ó kọjú sí ara wọn. Wọ́n ṣe gbogbo pákó àgọ́ náà bí èyí. ");
INSERT INTO yor_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ó sì ṣe ogún pákó sí ìhà gúúsù àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ó sì ṣe ogójì fàdákà ihò ìtẹ̀bọ̀ lọ sí ìsàlẹ̀ wọn ìtẹ̀bọ̀ méjì fún pákó kọ̀ọ̀kan, ọ̀kọ̀ọ̀kan ní ìsàlẹ̀ ìtẹ̀bọ̀. ");
INSERT INTO yor_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Fún ìhà kejì, ìhà àríwá àgọ́ náà, wọ́n ṣe ogún pákó ");
INSERT INTO yor_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","àti ogójì ihò ìtẹ̀bọ̀ fàdákà méjì ní abẹ́ pákó kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ó ṣe pákó mẹ́fà sì ìkangun, ní ìkangun ìhà ìwọ̀-oòrùn àgọ́ náà, ");
INSERT INTO yor_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","pákó méjì ni ìwọ ó ṣe fún igun àgọ́ náà ní ìhà ẹ̀yìn. ");
INSERT INTO yor_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ní igun méjèèjì yìí, pákó méjì ni ó wà níbẹ̀ láti ìdí dé orí rẹ̀ wọ́n sì kó wọ́n sí òrùka kan; méjèèjì rí bákan náà. ");
INSERT INTO yor_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Wọ́n ó sì jẹ́ pákó mẹ́jọ, àti ihò ìtẹ̀bọ̀ fàdákà mẹ́rìnlélógún, méjì wà ní ìsàlẹ̀ ọ̀kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ó sì ṣe ọ̀pá igi kasia márùn-ún fún pákó ìhà kan àgọ́ náà, ");
INSERT INTO yor_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","márùn-ún fún àwọn tí ó wà ní ìhà kejì, márùn-ún fún pákó tí ó wà ní ìhà ìwọ̀-oòrùn ní ìkangun àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Wọ́n sì ṣe ọ̀pá àárín tí yóò fi jáde láti ìkangun dé ìkangun ní àárín àwọn pákó náà. ");
INSERT INTO yor_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ó sì bo àwọn pákó pẹ̀lú wúrà, wọ́n sì ṣe àwọn òrùka wúrà láti gbá ọ̀pá náà mú. Wọ́n sì tún bo ọ̀pá náà pẹ̀lú wúrà. ");
INSERT INTO yor_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ó ṣe aṣọ títa aláró, àti elése àlùkò, àti òdòdó, àti ọ̀gbọ̀ olókùn wẹ́wẹ́ tí í ṣe ọlọ́nà, tí òun ti àwọn kérúbù ni kí á ṣe é. ");
INSERT INTO yor_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Wọ́n sì ṣe òpó igi ṣittimu mẹ́rin fún un wọ́n sì bò wọ́n pẹ̀lú wúrà. Wọ́n sì ṣe àwọn ìkọ́ wúrà fún wọn, wọ́n sì dá ihò ìtẹ̀bọ̀ fàdákà mẹ́rin mẹ́rin fún wọn. ");
INSERT INTO yor_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Fún ẹnu-ọ̀nà àgọ́ náà wọ́n ṣe aṣọ títa ti aṣọ aláró, ti elése àlùkò, ti òdòdó àti ti ọ̀gbọ̀ olókùn dáradára tí a fi iṣẹ́ abẹ́rẹ́ ṣe; ");
INSERT INTO yor_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ó sì ṣe òpó márùn-ún pẹ̀lú ìkọ́ wọn. Ó bo orí àwọn òpó náà àti ìgbànú wọn pẹ̀lú wúrà, ó sì fi idẹ ṣe ihò ìtẹ̀bọ̀ wọn márààrún. ");
INSERT INTO yor_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besaleli sì fi igi ṣittimu ṣe àpótí náà, ìgbọ̀nwọ́ méjì ààbọ̀ ni gígùn rẹ̀, ìgbọ̀nwọ́ kan ààbọ̀ ni fífẹ̀ rẹ̀, ìgbọ̀nwọ́ kan ààbọ̀ ni gíga rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ó sì fi ojúlówó wúrà bò ó ní inú àti ní òde, ó sì fi wúrà gbá etí rẹ̀ yíká. ");
INSERT INTO yor_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ó sì da òrùka wúrà mẹ́rin fún, láti fi wọ́n sí igun mẹ́rẹ̀ẹ̀rin ẹsẹ̀ rẹ̀, òrùka wúrà méjì yóò wà ní ẹ̀gbẹ́ kìn-ín-ní, òrùka wúrà méjì yóò wà ní ẹgbẹ́ kejì. ");
INSERT INTO yor_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ó sì fi igi kasia ṣe ọ̀pá, ó sì fi wúrà bò wọ́n. ");
INSERT INTO yor_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ó sì fi ọ̀pá náà bọ òrùka ní ẹ̀gbẹ́ kọ̀ọ̀kan àpótí ẹ̀rí náà láti fi gbé e. ");
INSERT INTO yor_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ó fi ojúlówó wúrà ṣe ìtẹ́ àánú; ìgbọ̀nwọ́ méjì àti ààbọ̀ ní gígùn àti ìgbọ̀nwọ́ kan ààbọ̀ ní fífẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ó sì ṣe kérúbù méjì láti inú wúrà tí a fi òòlù sí igun ìtẹ́ àánú náà. ");
INSERT INTO yor_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ó ṣe kérúbù kan ní igun kìn-ín-ní, àti kérúbù kejì sí igun kejì; kí kérúbù náà jẹ́ irú kan náà ní igun méjèèjì pẹ̀lú ìbòrí wọn. ");
INSERT INTO yor_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Àwọn kérúbù sì na ìyẹ́ apá wọn sókè, tí wọn yóò sì fi ìyẹ́ apá wọn ṣe ibòòji sí orí ìtẹ́ àánú. Àwọn kérúbù náà yóò kọ ojú sí ara wọn, wọn yóò máa wo ọ̀kánkán ìtẹ́. ");
INSERT INTO yor_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ó ṣe tábìlì igi ṣittimu ìgbọ̀nwọ́ méjì ní gígùn, ìgbọ̀nwọ́ kan ní fífẹ̀, àti ìgbọ̀nwọ́ kan ààbọ̀ ní gíga. ");
INSERT INTO yor_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ó sì fi ojúlówó wúrà bò ó, ó sì ṣe ìgbátí wúrà yí i ká. ");
INSERT INTO yor_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ó sì ṣe etí kan ní ìbú àtẹ́lẹwọ́ sí i yíká, ó sì ṣe ìgbátí wúrà yí etí rẹ̀ ká. ");
INSERT INTO yor_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ó sì da òrùka wúrà mẹ́rin fún tábìlì náà, ìwọ ó sì fi òrùka kọ̀ọ̀kan sí igun mẹ́rẹ̀ẹ̀rin tí ó wà ní ẹsẹ̀ rẹ̀ mẹ́rẹ̀ẹ̀rin. ");
INSERT INTO yor_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ní abẹ́ ìgbátí náà ni àwọn òrùka náà yóò wà, ààyè láti máa fi gbé tábìlì náà. ");
INSERT INTO yor_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ó sì fi igi kasia ṣe àwọn ọ̀pá, ó sì fi wúrà bò wọ́n, láti máa fi wọ́n gbé tábìlì náà. ");
INSERT INTO yor_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ó sì ṣe àwọn ohun èlò tí ó wà lórí tábìlì náà ní ojúlówó wúrà, abọ́ rẹ̀, àwo rẹ, àwokòtò rẹ̀ àti ìgò rẹ̀ fún dída ọrẹ mímu jáde. ");
INSERT INTO yor_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ó sì ṣe ọ̀pá fìtílà náà ní ojúlówó wúrà, ó sì lù ú jáde, ọ̀pá rẹ̀, ìtànná ìfẹ́ rẹ̀, ìrudí rẹ àti agogo rẹ̀, wọ́n jẹ́ ọ̀kan náà. ");
INSERT INTO yor_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ẹ̀ka mẹ́fà ni yóò yọ ní ẹ̀gbẹ́ ọ̀pá fìtílà: mẹ́ta ní ẹ̀gbẹ́ kìn-ín-ní mẹ́ta ni ẹ̀gbẹ́ kejì. ");
INSERT INTO yor_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Àwo mẹ́ta ni a ṣe bí ìtànná almondi pẹ̀lú ìrudí àti ìtànná wà ni ẹ̀ka kan, mẹ́ta sì tún wà ní ẹ̀ka mìíràn, bẹ́ẹ̀ ni ní ẹ̀ka mẹ́fẹ̀ẹ̀fà jáde lára ọ̀pá fìtílà. ");
INSERT INTO yor_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ní ara ọ̀pá fìtílà ni àwo mẹ́rin ti a ṣe gẹ́gẹ́ bí òdòdó almondi ti ó ni ìṣọ àti ìtànná yóò wà. ");
INSERT INTO yor_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Irúdì kan yóò sì wà ní abẹ́ ẹ̀ka rẹ̀ méjì àkọ́kọ́ tí ó yọ lára ọ̀pá fìtílà, irúdì kejì ó sì wà ní abẹ́ ẹ̀ka rẹ̀ méjì kejì, irúdì kẹta yóò sì wà ní abẹ́ ẹ̀ka rẹ̀ méjì kẹta: ẹ̀ka mẹ́fà ní àpapọ̀. ");
INSERT INTO yor_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Irúdì wọn àti ẹ̀ka wọn kí ó rí bákan náà, kí gbogbo rẹ̀ kí ó jẹ́ lílù ojúlówó wúrà. ");
INSERT INTO yor_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ó ṣe fìtílà rẹ̀, méje, àti alumagaji rẹ̀, àti àwo rẹ̀, kìkì wúrà ni. ");
INSERT INTO yor_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ó sì ṣe ọ̀pá fìtílà náà àti gbogbo ohun èlò rẹ̀ láti ara tálẹ́ǹtì kan tí ó jẹ́ kìkì wúrà. ");
INSERT INTO yor_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Igi kasia ní ó fi ṣe pẹpẹ tùràrí náà. Igun mẹ́rẹ̀ẹ̀rin rẹ̀ jẹ́ déédé, gígùn rẹ̀ jẹ ìgbọ̀nwọ́ kan, fífẹ̀ rẹ̀ náà jẹ́ ìgbọ̀nwọ́ kan àti gíga rẹ̀ sì jẹ́ ìgbọ̀nwọ́ méjì, ìwo rẹ̀ sì jẹ́ bákan náà. ");
INSERT INTO yor_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Kìkì wúrà ni ó fi bo orí rẹ̀, gbogbo ìhà rẹ̀ àti ìwo rẹ̀, ó sì fi ìgbátí wúrà yìí ká. ");
INSERT INTO yor_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ó ṣe òrùka wúrà méjì sí ìsàlẹ̀ ìgbátí náà méjì ní òdìkejì ara wọn láti gbá òpó náà mú láti máa fi gbé e. ");
INSERT INTO yor_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ó ṣe òpó igi ṣittimu, ó sì bò wọ́n pẹ̀lú u wúrà. ");
INSERT INTO yor_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ó sì túnṣe òróró mímọ́ ìtasórí àti kìkì òórùn dídùn tùràrí—iṣẹ́ àwọn tí ń ṣe nǹkan olóòórùn. ");
INSERT INTO yor_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ó sì fi igi kasia kọ́ pẹpẹ ẹbọ sísun, ìgbọ̀nwọ́ mẹ́fà ni gíga rẹ̀ àti ìgbọ̀nwọ́ márùn-ún, igun rẹ̀ ṣe déédé. ");
INSERT INTO yor_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ó ṣe ìwo sí igun mẹ́rẹ̀ẹ̀rin, nítorí kí ìwo àti pẹpẹ náà lè jẹ́ ọ̀kan, ó sì bo pẹpẹ náà pẹ̀lú idẹ. ");
INSERT INTO yor_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Idẹ ni ó ṣe gbogbo ohun èlò pẹpẹ, ìkòkò rẹ̀, ọkọ, àwokòtò rẹ̀, fọ́ọ̀kì tí a fi n mú ẹran àti àwo iná rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ó ṣe ààrò fún pẹpẹ náà, àwọ̀n onídẹ, kí ó wà níṣàlẹ̀ ẹsẹ̀ rẹ̀, dé ìdajì òkè pẹpẹ náà. ");
INSERT INTO yor_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ó dá òrùka idẹ láti mú kí ó di òpó igun mẹ́rẹ̀ẹ̀rin idẹ ààrò náà mú. ");
INSERT INTO yor_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ó sì fi igi kasia ṣe àwọn òpó náà, ó sì bò wọ́n pẹ̀lú idẹ. ");
INSERT INTO yor_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ó sì fi òpó náà bọ inú òrùka, nítorí kí ó lè wà ní ìhà pẹpẹ náà láti máa fi gbé e. Ó sì fi pákó ṣé pẹpẹ náà ní oníhò nínú. ");
INSERT INTO yor_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ó ṣe agbada idẹ, o sì fi idẹ ṣe ẹsẹ̀ rẹ̀ ti àwòjìji àwọn obìnrin tí ó ń sìn ní ẹnu-ọ̀nà àgọ́ àjọ. ");
INSERT INTO yor_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ó sì ṣe àgbàlá inú náà. Ní ìhà gúúsù ni aṣọ títa ti ọ̀gbọ̀ olókùn dáradára wà, ó jẹ́ mita mẹ́rìndínláàádọ́ta ní gígùn, ");
INSERT INTO yor_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","pẹ̀lú ogún òpó àti ogún ihò ìtẹ̀bọ̀ idẹ, àti pẹ̀lú fàdákà tí ó kọ́ ọ, tí ó sì de àwọn òpó náà. ");
INSERT INTO yor_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ní ìhà àríwá náà tún jẹ mita mẹ́rìndínláàádọ́ta ní gígùn, ó sì ní ogún òpó àti ogun ihò ìtẹ̀bọ̀ idẹ, pẹ̀lú fàdákà tí ó kọ́ ọ, tí ó sì de àwọn òpó náà. ");
INSERT INTO yor_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ìhà ìwọ̀-oòrùn jẹ́ mita mẹ́tàlélógún ní fífẹ̀, ó sì ní aṣọ títa pẹ̀lú òpó mẹ́wàá àti ihò ìtẹ̀bọ̀ mẹ́wàá, pẹ̀lú fàdákà tí ó kọ́ ọ, tí ó sì de àwọn òpó náà pọ̀. ");
INSERT INTO yor_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Fún ìhà ìlà-oòrùn, sí ibi tí oòrùn ti ń yọ náà jẹ́ mita mẹ́tàlélógún ni fífẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Aṣọ títa ìhà ẹnu-ọ̀nà kan jẹ́ mita mẹ́fà ààbọ̀, pẹ̀lú òpó mẹ́ta àti ihò ìtẹ̀bọ̀ mẹ́ta, ");
INSERT INTO yor_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","àti aṣọ títa ní ìhà kejì tí ó wà ní ẹnu-ọ̀nà àgbàlá náà jẹ́ mita mẹ́fà ààbọ̀ pẹ̀lú òpó mẹ́ta àti ihò ìtẹ̀bọ̀ mẹ́fà. ");
INSERT INTO yor_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Gbogbo aṣọ tí ó yí àgbàlá náà jẹ́ ọ̀gbọ̀ olókùn dáradára. ");
INSERT INTO yor_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ihò ìtẹ̀bọ̀ fún òpó náà idẹ ni. Ìkọ́ òpó náà àti ìgbànú tí ó wà lára òpó náà jẹ́ fàdákà, a sì bo orí wọn pẹ̀lú fàdákà; gbogbo àwọn òpó àgbàlá náà ní ìgbànú fàdákà. ");
INSERT INTO yor_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Aṣọ títa fún ẹnu-ọ̀nà àgbàlá náà jẹ́ ti aṣọ aláró, ti elése àlùkò, ti òdòdó àti ti ọ̀gbọ̀ olókùn wẹ́wẹ́ tí a fi iṣẹ́ abẹ́rẹ́ ṣe; ogún ìgbọ̀nwọ́ sì ni gígùn rẹ̀, àti gíga rẹ̀ ní ìbò rẹ̀ jẹ ìgbọ̀nwọ́ márùn-ún, ó bá aṣọ títa àgbàlá wọ̀n-ọn-nì ṣe déédé, ");
INSERT INTO yor_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","pẹ̀lú òpó mẹ́rin àti ihò ìtẹ̀bọ̀ idẹ mẹ́rin. Ìkọ́ àti ìgbànú wọn jẹ́ fàdákà, a sì bo orí wọn pẹ̀lú fàdákà. ");
INSERT INTO yor_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Gbogbo èèkàn àgọ́ tabanaku náà àti ti àyíká àgbàlá náà jẹ́ idẹ. ");
INSERT INTO yor_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Wọ̀nyí ni iye ohun èlò tí a lò fún tabanaku náà, tabanaku ẹ̀rí, èyí ti a kọ bí òfin Mose nípa àwọn ọmọ Lefi ní abẹ́ àkóso Itamari ọmọ Aaroni àlùfáà. ");
INSERT INTO yor_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(Besaleli ọmọ Uri, ọmọ Huri, ti ẹ̀yà Juda, ṣe ohun gbogbo ti Olúwa pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Pẹ̀lú rẹ̀ ni Oholiabu ọmọ Ahisamaki, ti ẹ̀yà Dani: alágbẹ̀dẹ, àti oníṣẹ́-ọnà àti oníṣọ̀nà tí a fi iṣẹ́ abẹ́rẹ́ ṣe ní aṣọ aláró àti elése àlùkò àti òdòdó àti ọ̀gbọ̀ dáradára.) ");
INSERT INTO yor_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Àròpọ̀ iye wúrà lára wúrà ọrẹ tí a lò fún gbogbo iṣẹ́ ibi mímọ́ náà jẹ́ tálẹ́ǹtì mọ́kàndínlọ́gbọ̀n àti òjìlélẹ́ẹ̀gbẹ́rín ó dín mẹ́wàá (730) ṣékélì gẹ́gẹ́ bí i ṣékélì ibi mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Fàdákà tí a rí nínú ìjọ, ẹni tí a kà nínú ìkànìyàn jẹ́ ọgọ́rùn-ún tálẹ́ǹtì àti òjìdínlẹ́gbẹ̀san ó lé mẹ́ẹ̀ẹ́dógún (1,775) ṣékélì, gẹ́gẹ́ bí ìwọ̀n ṣékélì ibi mímọ́, ");
INSERT INTO yor_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ààbọ̀ ṣékélì kan ní orí ẹnìkọ̀ọ̀kan, gẹ́gẹ́ bí ìwọ̀n ṣékélì ibi mímọ́, lórí olúkúlùkù ẹni tí ó ti kọjá tí a ti kà, láti ẹni ogún ọdún tàbí jù bẹ́ẹ̀ lọ, àròpọ̀ wọ́n jẹ́ ọgbọ̀n ọ̀kẹ́ lé ẹgbẹ̀tadínlógún ó lé àádọ́jọ (603,550) ọkùnrin. ");
INSERT INTO yor_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ọgọ́rùn-ún tálẹ́ǹtì fàdákà ní a lò láti fi dá ihò ìtẹ̀bọ̀ fún ibi mímọ́ àti fún aṣọ títa ọgọ́rùn-ún ihò ìtẹ̀bọ̀ nínú ọgọ́rùn-ún tálẹ́ǹtì náà tálẹ́ǹtì kan fún ihò ìtẹ̀bọ̀ kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ó lo òjìdínlẹ́gbẹ̀san ó lé mẹ́ẹ̀ẹ́dógún (1,775) ṣékélì ni ó fi ṣe ìkọ́ fún òpó náà, láti fi bo orí òpó náà àti láti fi ṣe ọ̀já wọn. ");
INSERT INTO yor_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Idẹ ara ọrẹ náà jẹ́ àádọ́rin tálẹ́ǹtì àti egbèjìlá (2,400) ṣékélì. ");
INSERT INTO yor_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ó lò ó láti fi ṣe ihò ìtẹ̀bọ̀ fún ẹnu-ọ̀nà àgọ́ àjọ, pẹpẹ idẹ náà pẹ̀lú ààrò idẹ rẹ̀ àti gbogbo ohun èlò rẹ̀, ");
INSERT INTO yor_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ihò ìtẹ̀bọ̀ àgbàlá náà àyíká àti ihò ìtẹ̀bọ̀ ẹnu-ọ̀nà àgbàlá àti gbogbo èèkàn àgọ́ náà, àti gbogbo èèkàn àgbàlá náà yíká. ");
INSERT INTO yor_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nínú aṣọ aláró, ti elése àlùkò àti ti òdòdó ni wọ́n fi ṣe aṣọ híhun fún àwọn òṣìṣẹ́ ní ibi mímọ́. Ó sì tún dá aṣọ mímọ́ fún Aaroni gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ó ṣe ẹ̀wù efodu wúrà, ti aṣọ aláró, ti elése àlùkò, ti òdòdó àti ti ọ̀gbọ̀ olókùn dáradára. ");
INSERT INTO yor_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ó sì lu wúrà náà di ewé fẹ́lẹ́fẹ́lẹ́, ó sì tún gé e láti fi ṣe iṣẹ́ sí aṣọ aláró, ti elése àlùkò, ti òdòdó, àti sínú ọ̀gbọ̀ dáradára, iṣẹ́ ọlọ́nà. ");
INSERT INTO yor_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ó ṣe aṣọ èjìká fún ẹ̀wù efodu náà, èyí tí ó so mọ igun rẹ̀ méjèèjì, nítorí kí ó lè so ó pọ̀. ");
INSERT INTO yor_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ọnà ìgbànú híhun rẹ̀ rí bí i ti rẹ̀ ó rí bákan náà pẹ̀lú ẹ̀wù efodu ó sì sé e pẹ̀lú wúrà, àti pẹ̀lú aṣọ aláró, elése àlùkò, òdòdó àti pẹ̀lú ọ̀gbọ̀ olókùn dáradára, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ó ṣiṣẹ́ òkúta óníkìsì tí a tò sí ojú ìdè wúrà, tí a sì fín wọn gẹ́gẹ́ bí èdìdì pẹ̀lú orúkọ àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ó sì so wọ́n mọ́ aṣọ èjìká ẹ̀wù efodu náà bí òkúta ìrántí fún àwọn ọmọ Israẹli, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ó ṣe iṣẹ́ ọnà sí ìgbàyà náà iṣẹ́ ọgbọ́n ọlọ́nà. Ó ṣe é bí ẹ̀wù efodu: ti wúrà ti aṣọ aláró, ti elése àlùkò, ti òdòdó àti ti ọ̀gbọ̀ olókùn dáradára. ");
INSERT INTO yor_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Igun rẹ̀ mẹ́rẹ̀ẹ̀rin rẹ̀ ṣe déédé ìwọ̀n ìka kan ní ìnà rẹ̀, ìwọ̀n ìka kan ní ìbú rẹ̀, ó sì jẹ́ ìṣẹ́po méjì. ");
INSERT INTO yor_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ó sì to ipele òkúta oníyebíye mẹ́rin sí i. Ní ipele kìn-ín-ní ní rúbì wà, topasi àti berili; ");
INSERT INTO yor_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ní ipele kejì, turikuose, safire, emeradi àti diamọndi; ");
INSERT INTO yor_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ní ipele kẹta, jasiniti, agate àti ametisiti; ");
INSERT INTO yor_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ní ipele kẹrin, karisoliti, óníkìsì, àti jasperi. Ó sì tò wọ́n ní ojú ìdè wúrà ní títò wọn. ");
INSERT INTO yor_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Wọ́n jẹ́ òkúta méjìlá, ọ̀kan fún orúkọ àwọn ọmọ Israẹli kọ̀ọ̀kan, a fín ọ̀kọ̀ọ̀kan gẹ́gẹ́ bí èdìdì pẹ̀lú orúkọ ẹnìkọ̀ọ̀kan ẹ̀yà méjèèjìlá. ");
INSERT INTO yor_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Fún ìgbàyà náà, wọ́n ṣe ẹ̀wọ̀n iṣẹ́ kìkì wúrà, gẹ́gẹ́ bi okùn. ");
INSERT INTO yor_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Wọ́n sì ṣe ojú ìdè wúrà méjì àti òrùka wúrà méjì, wọ́n sì so àwọn òkúta náà mọ́ igun méjèèjì ìgbàyà náà. ");
INSERT INTO yor_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Wọ́n sì so ẹ̀wọ̀n wúrà méjèèjì náà mọ́ àwọn òrùka náà ni igun ìgbàyà náà, ");
INSERT INTO yor_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","àti ní àwọn òpin ẹ̀wọ̀n tókù ni wọ́n fi mọ ojú ìdè méjèèjì, wọ́n so wọ́n mọ́ aṣọ èjìká ẹ̀wù efodu náà ní iwájú. ");
INSERT INTO yor_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Wọ́n ṣe òrùka wúrà méjì, wọ́n sì so wọ́n mọ́ igun méjèèjì ìgbàyà náà ní etí tí ó wà ní inú lẹ́gbẹ̀ẹ́ ẹ̀wù efodu náà. ");
INSERT INTO yor_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Wọ́n sì túnṣe òrùka wúrà méjì sí i, wọ́n sì so wọ́n mọ́ ìdí aṣọ èjìká ní iwájú ẹ̀wù efodu náà tí ó súnmọ́ ibi tí a ṣe lọ́ṣọ̀ọ́ ní òkè ìgbànú ẹ̀wù efodu náà. ");
INSERT INTO yor_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Wọn so àwọn òrùka ìgbàyà mọ́ àwọn òrùka ẹ̀wù efodu ọ̀já aṣọ aláró, kí a pa á pọ̀ mọ́ ìgbànú, nítorí kí ìgbàyà náà má ṣe tú kúrò lára ẹ̀wù efodu náà gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ó sì ṣe ọ̀já àmùrè ẹ̀wù efodu gbogbo rẹ̀ jẹ́ aṣọ aláró iṣẹ́ aláṣọ híhun, ");
INSERT INTO yor_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","pẹ̀lú ihò ní àárín ọ̀já àmùrè náà gẹ́gẹ́ bí i ojú kọ́là, àti ìgbànú yí ihò yìí ká, nítorí kí ó má ba à ya. ");
INSERT INTO yor_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ó sì ṣe pomegiranate ti aṣọ aláró, elése àlùkò, òdòdó àti ti ọ̀gbọ̀ olókùn dáradára yí ìṣẹ́tí ọ̀já àmùrè náà ká. ");
INSERT INTO yor_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ó sì ṣe agogo kìkì wúrà, ó sì so wọ́n mọ́ àyíká ìṣẹ́tí àárín pomegiranate náà. ");
INSERT INTO yor_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ago àti pomegiranate kọjú sí àyíká ìṣẹ́tí ọ̀já àmùrè láti máa wọ̀ ọ́ fún iṣẹ́ àlùfáà, bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Fún Aaroni àti àwọn ọmọ rẹ, wọ́n ṣe àwọ̀tẹ́lẹ̀ ti ọ̀gbọ̀ dáradára tí iṣẹ́ aláṣọ híhun. ");
INSERT INTO yor_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Àti fìlà ọ̀gbọ̀ dáradára, ìgbàrí ọ̀gbọ̀ àti aṣọ abẹ́ ọ̀gbọ̀ olókùn dáradára. ");
INSERT INTO yor_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ọ̀já náà jẹ́ ti ọ̀gbọ̀ olókùn dáradára, aṣọ aláró, elése àlùkò àti òdòdó tí a fi iṣẹ́ abẹ́rẹ́ ṣe bí Olúwa ṣe pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ó ṣe àwo, adé mímọ́, láti ara kìkì wúrà, wọ́n sì kọ̀wé sí i, gẹ́gẹ́ bí i ìkọ̀wé lórí èdìdì: Mímọ́ sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Wọ́n sì so ọ̀já aláró mọ́ ọn láti ṣo ó mọ́ fìlà náà, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Bẹ́ẹ̀ ni gbogbo iṣẹ́ àgọ́ náà, ti àgọ́ àjọ parí. Àwọn ọmọ Israẹli ṣe ohun gbogbo gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Wọ́n sì mú tabanaku náà tọ Mose wá: àgọ́ náà àti gbogbo ohun ọ̀ṣọ́ rẹ̀, ìkọ́ rẹ̀, pákó rẹ̀, ọ̀pá rẹ̀, òpó rẹ̀ àti àwọn ihò ìtẹ̀bọ̀ rẹ̀; ");
INSERT INTO yor_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ìbòrí awọ àgbò tí a kùn ní pupa, ìbòrí awọ àti ìji aṣọ títa; ");
INSERT INTO yor_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","àpótí ẹ̀rí pẹ̀lú àwọn òpó rẹ̀ àti ìbòrí àánú; ");
INSERT INTO yor_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tábìlì pẹ̀lú gbogbo ohun èlò rẹ̀ àti àkàrà ìfihàn; ");
INSERT INTO yor_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ọ̀pá fìtílà kìkì wúrà pẹ̀lú ipele fìtílà rẹ̀ àti gbogbo ohun èlò rẹ̀, àti òróró fún títanná rẹ̀; ");
INSERT INTO yor_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","pẹpẹ wúrà àti òróró ìtasórí, tùràrí dídùn, àti aṣọ títa fún ẹnu-ọ̀nà àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Pẹpẹ idẹ pẹ̀lú idẹ ọlọ, àwọn òpó rẹ̀ àti gbogbo ohun èlò rẹ̀; agbada pẹ̀lú ẹsẹ̀ rẹ̀; ");
INSERT INTO yor_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","aṣọ títa ti àgbàlá pẹ̀lú àwọn òpó rẹ̀ àti àgbàlá, àti aṣọ títa fún ẹnu-ọ̀nà àgbàlá; ọ̀já àmùrè àti èèkàn àgọ́ fún àgbàlá náà; gbogbo ohun ọ̀ṣọ́ fún àgọ́, àgọ́ àjọ náà; ");
INSERT INTO yor_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","aṣọ híhun tí wọ́n ń wọ̀ fún iṣẹ́ ibi mímọ́, aṣọ mímọ́ fún Aaroni àlùfáà àti aṣọ fún àwọn ọmọ rẹ̀ nígbà tí wọ́n bá ń ṣiṣẹ́ àlùfáà. ");
INSERT INTO yor_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Àwọn ọmọ Israẹli ti ṣe gbogbo iṣẹ́ náà gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mose bẹ iṣẹ́ náà wò, ó sì rí i wí pé wọ́n ti ṣe é gẹ́gẹ́ bí Olúwa ti pàṣẹ. Nítorí náà Mose sì bùkún fún wọn. ");
INSERT INTO yor_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Olúwa sì wí fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ní ọjọ́ kìn-ín-ní, oṣù kìn-ín-ní ni kí ó gbé àgọ́ náà, àgọ́ àjọ náà ró. ");
INSERT INTO yor_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Gbé àpótí ẹ̀rí sí inú rẹ̀, kí ó sì bo àpótí náà pẹ̀lú aṣọ títa. ");
INSERT INTO yor_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Gbé tábìlì náà wọ ilé, kí o sì to àwọn ohun tí ó jẹ́ tirẹ̀ lé e lórí. Nígbà náà gbé ọ̀pá fìtílà wọlé, kí o sì to àwọn fìtílà rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Gbé pẹpẹ wúrà ti tùràrí sí iwájú àpótí ẹ̀rí, kí o sì fi aṣọ títa ẹnu-ọ̀nà sí ara àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Gbé pẹpẹ ẹbọ sísun sí iwájú ẹnu-ọ̀nà àgọ́ náà, àgọ́ àjọ; ");
INSERT INTO yor_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","gbé agbada sí àárín àgọ́ àjọ àti pẹpẹ, kí o sì fi omi sí inú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Gbé àgbàlá ró yìí ka, kí ó sì fi aṣọ títa sí ẹnu-ọ̀nà àgbàlá náà. ");
INSERT INTO yor_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Mú òróró ìtasórí, kí ó sì ta á sára àgọ́ náà àti ohun gbogbo tí ó wà nínú rẹ̀, yà pẹpẹ sí mímọ́ àti gbogbo ọ̀ṣọ́ rẹ̀, yóò sì jẹ́ mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ta òróró sára pẹpẹ ẹbọ sísun àti gbogbo ohun èlò rẹ̀, ya pẹpẹ náà sí mímọ́, yóò sì jẹ́ mímọ́ jùlọ. ");
INSERT INTO yor_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ta òróró sára agbada náà àti ẹsẹ̀ rẹ, kí o sì yà wọ́n sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Mú Aaroni àti àwọn ọmọ rẹ̀ wá sí ẹnu-ọ̀nà àgọ́ àjọ, kí o sì wẹ̀ wọ́n pẹ̀lú omi. ");
INSERT INTO yor_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Nígbà náà wọ Aaroni ní aṣọ mímọ́, ta òróró sí i ní orí, kí o sì yà á sí mímọ́, nítorí kí ó lè máa sìn mi bí àlùfáà. ");
INSERT INTO yor_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Mú àwọn ọmọ rẹ̀ kí o sì fi aṣọ àwọ̀tẹ́lẹ̀ wọ̀ wọ́n. ");
INSERT INTO yor_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ta òróró sí wọn ní orí gẹ́gẹ́ bí o ti ta òróró sí baba wọn ní orí, nítorí kì wọn lè máa sìn mi bí àlùfáà. Ìtasórí wọn yóò jẹ́ iṣẹ́ àlùfáà ti yóò máa lò fún gbogbo ìrandíran tó ń bọ̀.” ");
INSERT INTO yor_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mose ṣe ohun gbogbo gẹ́gẹ́ bí Olúwa ti pàṣẹ fún un. ");
INSERT INTO yor_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Bẹ́ẹ̀ ni wọ́n gbé àgọ́ náà ró ní ọjọ́ kìn-ín-ní oṣù kìn-ín-ní ní ọdún kejì. ");
INSERT INTO yor_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Nígbà tí Mose gbé àgọ́ náà ró ó fi ihò ìtẹ̀bọ̀ sí ààyè rẹ̀, ó to pákó rẹ̀, ó fi ọ̀pá rẹ̀ bọ̀ ọ́, ó sì gbé àwọn òpó rẹ̀ ró. ");
INSERT INTO yor_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ó na aṣọ àgọ́ náà sórí àgọ́, ó sì fi ìbòrí bo orí àgọ́ náà, bí Olúwa ṣe pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ó mu ẹ̀rí, ó sì fi sínú àpótí, ó so àwọn òpó mọ́ àpótí náà, ó sì fi àánú bo orí rẹ. ");
INSERT INTO yor_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ó sì gbé àpótí náà wá sínú àgọ́; ó sì sọ aṣọ títa, ó sì ta á bo àpótí ẹ̀rí, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mose gbé tábìlì sínú àgọ́ àjọ sí ìhà àríwá àgọ́ náà lẹ́yìn aṣọ títa, ");
INSERT INTO yor_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ó sì to àkàrà sórí rẹ̀ níwájú Olúwa, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ó gbé ọ̀pá fìtílà sínú àgọ́ àjọ ní òdìkejì tábìlì ní ìhà gúúsù àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ó sì tan àwọn fìtílà náà níwájú Olúwa, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mose gbé pẹpẹ wúrà sínú àgọ́ àjọ níwájú aṣọ títa ");
INSERT INTO yor_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ó sì jó tùràrí dídùn lórí rẹ̀, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ó sì ta aṣọ títa sí ẹnu-ọ̀nà àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ó gbé pẹpẹ ẹbọ sísun sí ẹ̀gbẹ́ ẹnu-ọ̀nà àgọ́ àjọ, ó sì rú ẹbọ sísun àti ẹbọ oúnjẹ, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ó gbé agbada sí àárín àgọ́ àjọ àti pẹpẹ, ó sì pọn omi sínú rẹ̀ fún wíwẹ̀, ");
INSERT INTO yor_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mose, Aaroni àti àwọn ọmọ rẹ̀ lò ó láti fi wẹ ọwọ́ àti ẹsẹ̀ wọn. ");
INSERT INTO yor_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Wọ́n máa ń wẹ̀ nígbàkígbà tí wọ́n bá wọ àgọ́ àjọ tàbí tí wọ́n bá súnmọ́ pẹpẹ, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mose sì gbé àgbàlá tí ó yí àgọ́ náà kà ró àti pẹpẹ, ó sì ta aṣọ títa ti ẹnu-ọ̀nà sí àgbàlá náà. Bẹ́ẹ̀ ni Mose ṣe parí iṣẹ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Nígbà náà ni àwọsánmọ̀ bo àgọ́ àjọ, ògo Olúwa bo àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mose kò sì lè wọ inú àgọ́ àjọ, nítorí àwọsánmọ̀ wà ní orí àgọ́, ògo Olúwa sì ti kún inú àgọ́ náà. ");
INSERT INTO yor_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ní gbogbo ìrìnàjò àwọn ọmọ Israẹli nígbàkígbà tí a bá ti fa ìkùùkuu àwọsánmọ̀ náà sókè kúrò lórí àgọ́, wọ́n máa ń jáde lọ; ");
INSERT INTO yor_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ṣùgbọ́n tí àwọsánmọ̀ kò bá gòkè wọn kò ní jáde títí di ọjọ́ tí ó bá gòkè. ");
INSERT INTO yor_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Nítorí náà àwọsánmọ̀ Olúwa wà lórí àgọ́ ní ọ̀sán, iná sì wà nínú àwọsánmọ̀ ní alẹ́, ní ojú gbogbo ilé Israẹli ní gbogbo ìrìnàjò wọn.");
INSERT INTO yor_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Olúwa sì pe Mose, ó sì bá a sọ̀rọ̀ láti inú àgọ́ àjọ. Ó wí pé, ");
INSERT INTO yor_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Bá àwọn ọmọ Israẹli sọ̀rọ̀ kí o sì wí fún wọn pé, ‘Bí ẹnikẹ́ni nínú yín bá mú ọrẹ ẹbọ wá fún Olúwa, kí ọrẹ ẹbọ yín jẹ́ ẹran ọ̀sìn láti inú agbo ẹran tàbí láti inú ọ̀wọ́ ẹran. ");
INSERT INTO yor_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Bí ọrẹ ẹbọ náà bá jẹ́ ẹbọ sísun láti inú agbo ẹran kí òun kí ó mú akọ màlúù tí kò lábùkù. Ó sì gbọdọ̀ mú un wá sí ẹnu-ọ̀nà àgọ́ àjọ kí ó ba à lè jẹ́ ìtẹ́wọ́gbà níwájú Olúwa ");
INSERT INTO yor_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","kí ó gbé ọwọ́ rẹ̀ lé orí ẹbọ sísun náà yóò sì jẹ́ ìtẹ́wọ́gbà dípò o rẹ̀, yóò sì jẹ́ ètùtù fún un. ");
INSERT INTO yor_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Kí ó pa ọ̀dọ́ akọ màlúù náà níwájú Olúwa, lẹ́yìn náà ni àwọn àlùfáà tí í ṣe ọmọ Aaroni yóò gbé ẹ̀jẹ̀ ẹran náà, wọn yóò sì wọ́n ẹ̀jẹ̀ náà yí pẹpẹ tí ó wà ní ẹnu-ọ̀nà àgọ́ àjọ ká. ");
INSERT INTO yor_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Òun yóò bó awọ ara ẹbọ sísun náà, òun yóò sì gé e sí wẹ́wẹ́. ");
INSERT INTO yor_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Àwọn ọmọ Aaroni tí í ṣe àlùfáà yóò fi iná sí orí pẹpẹ, wọn yóò sì to igi sórí pẹpẹ náà. ");
INSERT INTO yor_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Lẹ́yìn náà ni àwọn ọmọ Aaroni tí í ṣe àlùfáà yóò tó ègé ẹran náà, pẹ̀lú orí àti ọ̀rá rẹ̀ sí orí igi tó ń jó lórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Kí ó fi omi sàn nǹkan inú àti àwọn ẹsẹ̀ rẹ̀, kí àlùfáà sì sun gbogbo rẹ̀ lórí pẹpẹ, ó jẹ́ ọrẹ ẹbọ sísun, ọrẹ ẹbọ tí a fi iná ṣe, àní òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Bí ọrẹ ẹbọ náà bá jẹ́ ẹbọ sísun láti inú ọ̀wọ́ ẹran, láti ara àwọn àgùntàn tàbí ewúrẹ́ tàbí àgùntàn, kí ó mú akọ tí kò lábùkù, ");
INSERT INTO yor_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","kí ó pa á ní apá àríwá pẹpẹ níwájú Olúwa, kí àwọn ọmọ Aaroni tí í ṣe àlùfáà sì wọ́n ẹ̀jẹ̀ rẹ̀ yí gbogbo ẹ̀gbẹ́ pẹpẹ náà ká. ");
INSERT INTO yor_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Kí ó gé e sí wẹ́wẹ́, kí àlùfáà sì to ègé ẹran náà; orí àti ọ̀rá rẹ̀ sí orí igi tó ń jó lórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Kí ó fi omi ṣan nǹkan inú àti àwọn ẹsẹ̀ rẹ̀, kí àlùfáà sì gbé gbogbo rẹ̀ wá láti sun lórí pẹpẹ. Ó jẹ́ ẹbọ sísun tí a fi iná ṣe, àní òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Bí ó bá sì ṣe pé ti ẹyẹ ni ẹbọ sísun ọrẹ ẹbọ rẹ̀ sí Olúwa, ǹjẹ́ kí ó mú ọrẹ ẹbọ rẹ̀ wá nínú àdàbà tàbí ọmọ ẹyẹlé. ");
INSERT INTO yor_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kí àlùfáà mu wá sí ibi pẹpẹ, kí ó yín in lọ́rùn, kí ó sì sun ún lórí pẹpẹ, kí ó sì ro ẹ̀jẹ̀ rẹ̀ ní ẹ̀gbẹ́ pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Kí ó yọ àjẹsí ẹyẹ náà pẹ̀lú gbogbo ohun tí ó wà nínú rẹ̀, kí ó gbe lọ ṣí apá ìlà-oòrùn pẹpẹ níbi tí eérú wà. ");
INSERT INTO yor_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kí ó gbá apá rẹ̀ méjèèjì mú, kí ó fà á ya, ṣùgbọ́n kí ó má ya á tan pátápátá. Lẹ́yìn náà ni àlùfáà yóò sun ún lórí igi tí ó ń jó lórí pẹpẹ, ẹbọ sísun ni ọrẹ tí a fi iná ṣe, àní òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Bí ẹnìkan bá mú ọrẹ ẹbọ ohun jíjẹ wá fún Olúwa ọrẹ rẹ̀ gbọdọ̀ jẹ́ ìyẹ̀fun dáradára, kí ó da òróró sí i, kí o sì fi tùràrí sí i, ");
INSERT INTO yor_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","kí ó sì gbé lọ fún àwọn ọmọ Aaroni tí í ṣe àlùfáà. Àlùfáà yóò bu ẹ̀kúnwọ́ kan nínú ìyẹ̀fun àti òróró náà, pẹ̀lú gbogbo tùràrí kí ó sì sun ún gẹ́gẹ́ bí ẹbọ ìrántí lórí pẹpẹ, ọrẹ tí a fi iná ṣe, àní òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ìyókù nínú ọrẹ ohun jíjẹ náà jẹ́ ti Aaroni àti àwọn ọmọ rẹ̀, ó jẹ́ ìpín tí ó mọ́ jùlọ nínú ọrẹ tí a fi iná sun sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Bí ẹ bá mú ọrẹ ohun jíjẹ, èyí tí a yan lórí ààrò iná, kí ó jẹ́ ìyẹ̀fun kíkúnná dáradára, àkàrà tí a ṣe láìní ìwúkàrà, tí a sì fi òróró pò àti àkàrà fẹ́lẹ́fẹ́lẹ́ tí a ṣe láìní ìwúkàrà èyí tí a fi òróró pò. ");
INSERT INTO yor_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Bí ọrẹ ẹbọ rẹ bá jẹ́ inú àwo pẹẹrẹ ni o ti ṣe ohun jíjẹ rẹ, kí ó jẹ́ ìyẹ̀fun dáradára tí a fi òróró pò, kò sì gbọdọ̀ ní ìwúkàrà. ");
INSERT INTO yor_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Rún un kí o sì da òróró sí i lórí, ọrẹ ohun jíjẹ ni. ");
INSERT INTO yor_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Bí ọrẹ ẹbọ rẹ bá jẹ́ ẹbọ ohun jíjẹ, tí a yan nínú apẹ, ìyẹ̀fun dáradára ni kí o fi ṣè é pẹ̀lú òróró. ");
INSERT INTO yor_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Mú ọrẹ ohun jíjẹ tí a fi àwọn nǹkan wọ̀nyí ṣe wá fún Olúwa gbé e fún àlùfáà, ẹni tí yóò gbe e lọ sí ibi pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Àlùfáà yóò sì mú ẹbọ ìrántí nínú ọrẹ ohun jíjẹ yìí, yóò sì sun ún lórí pẹpẹ gẹ́gẹ́ bí ọrẹ tí a fi iná sun, àní òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ìyókù nínú ọrẹ ohun jíjẹ yìí jẹ́ ti Aaroni àti àwọn ọmọ rẹ̀, ó jẹ́ èyí tí ó mọ́ jùlọ nínú ọrẹ tí a fi iná sun sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Gbogbo ọrẹ ohun jíjẹ tí ẹ bá mú wá fún Olúwa kò gbọdọ̀ ní ìwúkàrà nínú, nítorí pé ẹ kò gbọdọ̀ sun ohun wíwú tàbí oyin nínú ọrẹ tí ẹ fi iná sun sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ẹ lè mú wọn wá fún Olúwa gẹ́gẹ́ bí ọrẹ àkọ́so ṣùgbọ́n ẹ kò gbọdọ̀ mú wọn wá sórí pẹpẹ gẹ́gẹ́ bí òórùn dídùn. ");
INSERT INTO yor_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ẹ fi iyọ̀ dun gbogbo ọrẹ ohun jíjẹ yín. Ẹ má ṣe aláìfi iyọ̀ májẹ̀mú Ọlọ́run yín sínú àwọn ọrẹ ohun jíjẹ yín, ẹ fi iyọ̀ sí gbogbo ọrẹ yín. ");
INSERT INTO yor_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Bí ẹ bá mú ọrẹ ohun jíjẹ ti àkọ́so oko yín wá fún Olúwa kí ẹ mú ọkà tuntun tí a fi iná yan. ");
INSERT INTO yor_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kí ẹ da òróró lé e lórí, kí ẹ sì fi tùràrí sí i, ó jẹ́ ọrẹ ohun jíjẹ. ");
INSERT INTO yor_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Àlùfáà yóò sun ẹbọ ìrántí lára ọkà àti òróró náà, pẹ̀lú gbogbo tùràrí gẹ́gẹ́ bí ọrẹ tí a fi iná sun sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Bí ọrẹ ẹnìkan bá jẹ́ ọrẹ àlàáfíà, tí ó sì mú ẹran wá láti inú agbo màlúù yálà akọ tàbí abo, kí ó mú èyí tí kò ní àbùkù wá síwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Kí ó gbé ọwọ́ rẹ̀ lé e lórí, kí ó sì pa á ní ẹnu-ọ̀nà àgọ́ àjọ. Nígbà náà ni àwọn ọmọ Aaroni tí í ṣe àlùfáà yóò wọ́n ẹ̀jẹ̀ ẹran náà yí pẹpẹ ká. ");
INSERT INTO yor_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Láti ara ọrẹ àlàáfíà ni kí ẹni náà ti mú ẹbọ tí a fi iná sun sí Olúwa, gbogbo ọ̀nà tí ó bo nǹkan inú ẹran náà àti gbogbo ọ̀rá tí ó so mọ́ wọn. ");
INSERT INTO yor_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Kíndìnrín méjèèjì pẹ̀lú ọ̀rá ara rẹ̀ tí ń bẹ lẹ́bàá ìhà rẹ̀, àti gbogbo ọ̀rá tí ó bo ẹ̀dọ̀, kí ó yọ ọ́ jáde pẹ̀lú kíndìnrín. ");
INSERT INTO yor_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Nígbà náà ni àwọn ọmọ Aaroni yóò sun ún lórí pẹpẹ gẹ́gẹ́ bí ẹbọ sísun tí a fi iná sun, àní òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Bí ó bá ṣe inú agbo ewúrẹ́ àti àgùntàn ni ó ti mú ọrẹ àlàáfíà wá fún Olúwa kí ó mú akọ tàbí abo tí kò ní àbùkù. ");
INSERT INTO yor_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Bí ó bá ṣe pé ọ̀dọ́-àgùntàn ni ó mú, kí ó mú un wá síwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Kí ó gbé ọwọ́ rẹ̀ lé e lórí, kí ó sì pa á níwájú àgọ́ ìpàdé, kí àwọn ọmọ Aaroni wọ́n ẹ̀jẹ̀ ẹran náà yí pẹpẹ ká. ");
INSERT INTO yor_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Kí o sì mú wá nínú ẹbọ àlàáfíà náà, fún ẹbọ tí a fi iná ṣe sí Olúwa; ọ̀rá rẹ̀ àti gbogbo ìrù rẹ̀ tí ó ní ọ̀rá, òun ni kí o mú kúrò súnmọ́ egungun ẹ̀yìn àti ọ̀rá tí ó bo ìfun lórí; àti gbogbo ọ̀rá tí ń bẹ lára ìfun. ");
INSERT INTO yor_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Kíndìnrín méjèèjì pẹ̀lú ọ̀rá tí ń bẹ lẹ́bàá ìhà rẹ̀ àti ọ̀rá tí ó bo ẹ̀dọ̀, kí o yọ ọ́ jáde pẹ̀lú kíndìnrín. ");
INSERT INTO yor_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Kí àlùfáà sun ún lórí pẹpẹ bí oúnjẹ ọrẹ tí a fi iná sun sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Bí ó bá ṣe pé ewúrẹ́ ni ó mú, kí ó mú un wá síwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Kí ó gbé ọwọ́ lé e lórí. Kí ó sì pa á ní iwájú àgọ́ ìpàdé. Nígbà náà ni àwọn ọmọ Aaroni yóò wọ́n ẹ̀jẹ̀ ẹran náà yí pẹpẹ ká. ");
INSERT INTO yor_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Lára ọrẹ tó mú wá, kí ó mú ẹbọ sísun fún Olúwa, gbogbo ọ̀rá tí ó bo nǹkan inú rẹ̀ àti ohun gbogbo tó so mọ́ ọn. ");
INSERT INTO yor_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Kíndìnrín méjèèjì pẹ̀lú ọ̀rá ara rẹ̀ tí ń bẹ lẹ́bàá ìhà rẹ̀ àti ọ̀rá tí ó bo ẹ̀dọ̀, kí ó yọ ọ́ jáde pẹ̀lú kíndìnrín. ");
INSERT INTO yor_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kí àlùfáà sun ún lórí pẹpẹ bí oúnjẹ, ọrẹ tí a fi iná sun, ní òórùn dídùn. Gbogbo ọ̀rá rẹ̀ jẹ́ ti Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Èyí jẹ́ ìlànà láéláé fún àwọn ìran tó ń bọ̀, ní gbogbo ibi tí ẹ bá ń gbé, ẹ kò gbọdọ̀ jẹ ọ̀rá tàbí ẹ̀jẹ̀.’ ” ");
INSERT INTO yor_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Sọ fún àwọn ọmọ Israẹli pé, ‘Bí ẹnìkan bá ṣẹ̀ láìmọ̀, tí ó ṣe ohun tí kò yẹ kó ṣe sí ọ̀kan nínú àwọn òfin Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Bí àlùfáà tí a fi òróró yàn bá ṣẹ̀, tí ó sì mú ẹ̀bi wá sórí àwọn ènìyàn, ó gbọdọ̀ mú ọmọ akọ màlúù tí kò lábùkù wá fún Olúwa gẹ́gẹ́ bí ẹbọ ẹ̀ṣẹ̀ fún ẹ̀ṣẹ̀ tí ó ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Kí ó mú ọ̀dọ́ màlúù wá síwájú Olúwa ní ẹnu-ọ̀nà àgọ́ ìpàdé. Kí ó gbé ọwọ́ rẹ̀ lé e lórí, kí ó sì pa á níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Kí àlùfáà tí a fi òróró yàn mú díẹ̀ nínú ẹ̀jẹ̀ akọ màlúù, kí ó sì gbé e lọ sínú àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Kí ó ti ìka bọ inú ẹ̀jẹ̀ náà kí ó sì wọ́n díẹ̀ nínú rẹ̀ ní ẹ̀ẹ̀méje níwájú Olúwa, níwájú aṣọ títa ibi mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Àlùfáà yóò tún mú díẹ̀ nínú ẹ̀jẹ̀ náà sórí ìwo pẹpẹ tùràrí tó wà níwájú Olúwa nínú àgọ́ ìpàdé. Kí ó da gbogbo ẹ̀jẹ̀ akọ màlúù tókù sí ìsàlẹ̀ pẹpẹ ẹbọ sísun ní ẹnu-ọ̀nà àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Kí ó yọ gbogbo ọ̀rá tí ń bẹ nínú akọ màlúù ẹbọ ẹ̀ṣẹ̀ náà ọ̀rá tí ó bo nǹkan inú àti gbogbo ohun tó so mọ́ wọn. ");
INSERT INTO yor_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Kíndìnrín méjèèjì pẹ̀lú ọ̀rá wọn tí ń bẹ lẹ́bàá ìhà àti ọ̀rá tí ó bo ẹ̀dọ̀, kí ó yọ ọ́ pẹ̀lú kíndìnrín. ");
INSERT INTO yor_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Gẹ́gẹ́ bí a ṣe ń yọ ọ̀rá kúrò lára màlúù tí a fi rú ẹbọ àlàáfíà; àlùfáà yóò sì sun wọ́n lórí pẹpẹ ẹbọ sísun. ");
INSERT INTO yor_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ṣùgbọ́n awọ màlúù àti gbogbo ara rẹ̀, àti ẹsẹ̀, gbogbo nǹkan inú àti ìgbẹ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Èyí túmọ̀ sí pé gbogbo ìyókù akọ màlúù náà ni kí ẹ gbé jáde síta lẹ́yìn ibùdó sí ibi tí a sọ di mímọ́ níbi tí à ń da eérú sí, kí ẹ sì sun wọ́n lórí iná igi, níbi eérú tí a kójọ. ");
INSERT INTO yor_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Bí gbogbo àpapọ̀ ènìyàn Israẹli bá ṣèèṣì ṣẹ̀, tí wọ́n sì ṣe ohun tí kò yẹ kí wọ́n ṣe sí ọ̀kan nínú àwọn òfin Olúwa, bí ó tilẹ̀ jẹ́ pé àpapọ̀ ènìyàn náà kò mọ̀ sí ọ̀rọ̀ náà, wọ́n jẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Nígbà tí wọ́n bá mọ̀, gbogbo ìjọ ènìyàn yóò mú akọ màlúù wá sí àgọ́ ìpàdé gẹ́gẹ́ bí ẹbọ ẹ̀ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Kí àwọn àgbàgbà ìjọ Israẹli gbé ọwọ́ lórí akọ ọmọ màlúù náà níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Kí àlùfáà tí a fi òróró yàn sì mú díẹ̀ lára ẹ̀jẹ̀ akọ ọmọ màlúù náà wá sínú àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Kí ó ti ìka rẹ̀ bọ inú ẹ̀jẹ̀ náà kí ó sì wọn ní ẹ̀ẹ̀méje níwájú Olúwa níbi aṣọ títa ẹnu-ọ̀nà. ");
INSERT INTO yor_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Kí ó sì mú díẹ̀ nínú ẹ̀jẹ̀ náà sórí ìwo pẹpẹ tó wà níwájú Olúwa nínú àgọ́ ìpàdé. Ìyókù ẹ̀jẹ̀ náà ni kí ó dà sí ìsàlẹ̀ pẹpẹ ẹbọ sísun ní ẹnu-ọ̀nà àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Kí ó yọ gbogbo ọ̀rá kúrò lára rẹ̀, kí ó sì sun ún lórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Kí ó sì ṣe akọ ọmọ màlúù yìí gẹ́gẹ́ bí ó ṣe ṣe akọ màlúù tó wà fún ẹbọ ẹ̀ṣẹ̀. Báyìí ni àlùfáà yóò ṣe ṣe ètùtù fún wọn, á ó sì dáríjì wọ́n. ");
INSERT INTO yor_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Lẹ́yìn náà ni yóò sun màlúù yìí lẹ́yìn ibùdó, yóò sì sun ún gẹ́gẹ́ bó ṣe sun màlúù àkọ́kọ́. Èyí ni ẹbọ ẹ̀ṣẹ̀ fún gbogbo ìjọ ènìyàn Israẹli. ");
INSERT INTO yor_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Bí olórí kan bá ṣèèṣì ṣẹ̀ láìmọ̀ tí ó sì ṣe ohun tí kò yẹ kí ó ṣe sí ọ̀kan nínú àwọn òfin Olúwa Ọlọ́run rẹ̀, ó jẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Nígbà tí a bá sì sọ ẹ̀ṣẹ̀ rẹ̀ fún un, ó gbọdọ̀ mú akọ ewúrẹ́ tí kò ní àbùkù wá gẹ́gẹ́ bí ẹbọ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Kí ó gbé ọwọ́ rẹ̀ lórí ewúrẹ́ náà, kí ó sì pa á níbi tí wọ́n ti ń pa ẹran ẹbọ sísun níwájú Olúwa. Ẹbọ ẹ̀ṣẹ̀ ni. ");
INSERT INTO yor_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Lẹ́yìn èyí, kí àlùfáà ti ìka rẹ̀ bọ inú ẹ̀jẹ̀ ẹbọ ẹ̀ṣẹ̀ náà, kí ó fi sí orí ìwo pẹpẹ ẹbọ sísun, kí ó sì da ẹ̀jẹ̀ yòókù sí ìsàlẹ̀ pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Kí ó sun gbogbo ọ̀rá rẹ̀ lórí pẹpẹ bí ó ṣe sun ọ̀rá ọrẹ àlàáfíà. Báyìí ní àlùfáà yóò ṣe ètùtù fún ẹ̀ṣẹ̀ ọkùnrin náà, a ó sì dáríjì í. ");
INSERT INTO yor_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Bí ènìyàn nínú àwọn ará ìlú bá ṣèèṣì ṣẹ̀ láìmọ̀ tí ó sì ṣe ohun tí kò yẹ sí ọ̀kan nínú àwọn òfin Olúwa, ó jẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Nígbà tí a bá sọ ẹ̀ṣẹ̀ rẹ̀ fún un, ó gbọdọ̀ mú abo ewúrẹ́ tí kò ní àbùkù wá gẹ́gẹ́ bí ẹbọ fún ẹ̀ṣẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Kí ó gbé ọwọ́ rẹ̀ lórí ewúrẹ́ ẹbọ ẹ̀ṣẹ̀ náà, kí ó sì pa á níbi ẹbọ sísun. ");
INSERT INTO yor_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Àlùfáà yóò sì ti ìka rẹ̀ bọ́ ẹ̀jẹ̀ náà, yóò fi sí orí ìwo pẹpẹ ẹbọ sísun, kí ó sì da ìyókù ẹ̀jẹ̀ náà sí ìsàlẹ̀ pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Kí ó yọ gbogbo ọ̀rá ẹran náà gẹ́gẹ́ bó ṣe yọ ọ̀rá ẹran fún ọrẹ àlàáfíà. Kí àlùfáà sì sun ọ̀rá yìí lórí pẹpẹ bí òórùn dídùn sí Olúwa. Báyìí ni àlùfáà yóò ṣe ètùtù fún ẹni náà, a ó sì dáríjì í. ");
INSERT INTO yor_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Bí ó bá mú ọ̀dọ́-àgùntàn wá gẹ́gẹ́ bí ẹbọ ẹ̀ṣẹ̀, kí ó mú abo tí kò lábùkù. ");
INSERT INTO yor_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Kí ó gbé ọwọ́ rẹ̀ lé e lórí, kí ó sì pa á fún ẹbọ ẹ̀ṣẹ̀ níbi tí wọ́n ti ń pa ẹran ẹbọ sísun. ");
INSERT INTO yor_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Àlùfáà yóò sì ti ìka rẹ̀ bọ inú ẹ̀jẹ̀ ẹbọ ẹ̀ṣẹ̀ náà, yóò sì fi sí orí ìwo pẹpẹ ẹbọ sísun, yóò sì da ìyókù ẹ̀jẹ̀ náà sí ìsàlẹ̀ pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Kí ó yọ gbogbo ọ̀rá rẹ̀ bó ti yọ ọ̀rá lára ọ̀dọ́-àgùntàn ọrẹ àlàáfíà, àlùfáà yóò sì sun ún ní orí pẹpẹ, lórí ọrẹ tí a fi iná sun sí Olúwa. Báyìí ni àlùfáà yóò ṣe ètùtù fún ẹni náà, nítorí ẹ̀ṣẹ̀ tí ó sẹ̀, a ó sì dáríjì í. ");
INSERT INTO yor_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Bí ẹnìkan bá dẹ́ṣẹ̀ nítorí pé kò sọ̀rọ̀ nígbà tí a bi í ní gbangba pé kó jẹ́rìí nípa nǹkan tó rí tàbí nǹkan tó mọ̀ nípa ìṣẹ̀lẹ̀ kan, a ó di ẹ̀bi rẹ̀ rù ú. ");
INSERT INTO yor_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Tàbí bí ẹnìkan bá fọwọ́ kan ohun tí a kà sí àìmọ́ yálà òkú ẹranko aláìmọ́ tàbí òkú ẹran ọ̀sìn aláìmọ́ tàbí òkú ẹ̀dá yówù tó ń rìn lórí ilẹ̀ bí ó tilẹ̀ jẹ́ pé ẹni náà kò mọ̀, ó ti di aláìmọ́, ó sì ti jẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Tàbí bí ó bá fọwọ́ kan ohun àìmọ́ ti ènìyàn, ohunkóhun tó lè mú ènìyàn di aláìmọ́, bí ó tilẹ̀ jẹ́ pé ẹni náà kò mọ̀, nígbà tí ó bá mọ̀ nípa rẹ̀ yóò jẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Tàbí bí ẹni kan bá búra láti ṣe ohun kan láì ronú lé e lórí, yálà ohun tó dára tàbí ohun búburú, nínú ọ̀rọ̀ yówù tó ti búra láì kíyèsi ara, bí ó tilẹ̀ jẹ́ pé, kò mọ̀ nípa rẹ̀ tẹ́lẹ̀, bí ó ti wù kó rí, nígbà tó bá mọ̀ yóò jẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Bí ẹnikẹ́ni bá jẹ̀bi ọ̀kan nínú àwọn nǹkan wọ̀nyí, ó gbọdọ̀ jẹ́wọ́ irú ọ̀nà tó ti dẹ́ṣẹ̀ ");
INSERT INTO yor_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","àti pé gẹ́gẹ́ bí ìtánràn fún ẹ̀ṣẹ̀ tí ó ṣẹ̀, ó gbọdọ̀ mú wa fún Olúwa, abo àgùntàn tàbí abo ewúrẹ́ láti inú agbo ẹran wá gẹ́gẹ́ bí ẹbọ ẹ̀ṣẹ̀, àlùfáà yóò sì ṣe ètùtù fún ẹ̀ṣẹ̀ tí ó ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Bí kò bá lágbára àti mú ọ̀dọ́-àgùntàn wá, kí ó mú àdàbà méjì tàbí ọmọ ẹyẹlé méjì fún Olúwa gẹ́gẹ́ bí ìtánràn fún ẹ̀ṣẹ̀ rẹ̀—ọ̀kan fún ẹbọ ẹ̀ṣẹ̀, èkejì fún ẹbọ sísun. ");
INSERT INTO yor_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Kí ó kó wọn wá fún àlùfáà tí yóò kọ́kọ́ rú ẹbọ ẹ̀ṣẹ̀ kí ó yín in lọ́rùn, ṣùgbọ́n kí ó má já orí rẹ̀ tan, ");
INSERT INTO yor_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","kí ó sì wọ́n díẹ̀ lára ẹ̀jẹ̀ ẹbọ ẹ̀ṣẹ̀ náà sí ẹ̀gbẹ́ pẹpẹ, ìyókù ẹ̀jẹ̀ náà ni kí ó ro sí ìsàlẹ̀ pẹpẹ. Ẹbọ ẹ̀ṣẹ̀ ni. ");
INSERT INTO yor_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Lẹ́yìn èyí àlùfáà yóò wá rú ẹbọ sísun gẹ́gẹ́ bí ìlànà, yóò sì ṣe ètùtù fún un nítorí ẹ̀ṣẹ̀ tí ó ṣẹ̀, a ó sì dáríjì í. ");
INSERT INTO yor_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Bí ó bá sì jẹ́ pé kò ní agbára àti mú àdàbà méjì tàbí ọmọ ẹyẹlé méjì wá, kí ó mú ìdámẹ́wàá òsùwọ̀n ìyẹ̀fun kíkúnná dáradára wá fún ẹbọ ẹ̀ṣẹ̀ rẹ, kò gbọdọ̀ fi òróró tàbí tùràrí sí i nítorí pé ẹbọ ẹ̀ṣẹ̀ ni. ");
INSERT INTO yor_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Kí ó gbé e wá sí ọ̀dọ̀ àlùfáà, àlùfáà yóò sì bu ẹ̀kúnwọ́ ìyẹ̀fun gẹ́gẹ́ bí ẹbọ ìrántí, kí ó sì sun ún lórí pẹpẹ, gẹ́gẹ́ bí ẹbọ tí a fi iná sun sí Olúwa. Ẹbọ ẹ̀ṣẹ̀ ni. ");
INSERT INTO yor_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Báyìí ni àlùfáà yóò ṣe ètùtù fún ẹni náà fún èyíkéyìí nínú àwọn ẹ̀ṣẹ̀ tí ó dá, a ó sì dáríjì í: ìyókù sì jẹ́ ti àlùfáà, bí ẹbọ ohun jíjẹ.’ ” ");
INSERT INTO yor_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Nígbà tí ẹnìkan bá dẹ́ṣẹ̀ ìrékọjá tí ó sì ṣe láìmọ̀ ní ti àwọn ohun mímọ́ Olúwa, kí ó mú àgbò láti inú agbo ẹran wá fún Olúwa gẹ́gẹ́ bí ìtánràn, àgbò tí kò lábùkù tí ó sì níye lórí gẹ́gẹ́ bí iye owó ibi mímọ́. Ẹbọ ẹ̀bi ni. ");
INSERT INTO yor_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kí ó ṣe àtúnṣe nítorí ẹ̀ṣẹ̀ tí ó ti ṣẹ̀ nínú ti àwọn ohun mímọ́, kí ó sì fi ìdámárùn-ún kún iye rẹ̀, kí ó sì kó gbogbo rẹ̀ fún àlùfáà. Àlùfáà yóò sì fi àgbò ẹbọ ẹ̀ṣẹ̀ náà ṣe ètùtù fún, a ó sì dáríjì í. ");
INSERT INTO yor_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Bí ẹnìkan bá dẹ́ṣẹ̀ tí ó sì ṣe ohun tí kó yẹ ko ṣe sí ọ̀kan nínú òfin Olúwa, bí kò tilẹ̀ mọ̀, ó jẹ̀bi, yóò sì ru ẹ̀bi ẹ̀ṣẹ̀ rẹ̀ ");
INSERT INTO yor_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","kí ó mú àgbò kan láti inú agbo ẹran wá sọ́dọ̀ àlùfáà, fún ẹbọ ẹ̀ṣẹ̀ àgbò tí kò lábùkù tí ó sì níye lórí bí iye owó ibi mímọ́. Báyìí ni àlùfáà yóò ṣe ètùtù fún ẹni náà, fún àṣìṣe tí ó ṣe láìmọ̀, a ó sì dáríjì í. ");
INSERT INTO yor_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ẹbọ ẹ̀bi ni, ó ti jẹ̀bi ẹ̀ṣẹ̀ tí ó ṣẹ̀ sí Olúwa.” ");
INSERT INTO yor_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Bí ẹnikẹ́ni bá dẹ́ṣẹ̀ tí ó sì ṣe àìṣòótọ́ sí Olúwa nípa títan ẹnìkejì rẹ̀ lórí ohun tí wọ́n fi sí ìkáwọ́ tàbí tí wọ́n fi pamọ́ sí i lọ́wọ́, tàbí bí ó bá jalè, tàbí kí ó yan ẹnìkejì rẹ̀ jẹ, ");
INSERT INTO yor_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","tàbí kí ó rí ohun tó sọnù he tó sì parọ́ tàbí kí ó búra èké, tàbí kí ó tilẹ̀ dẹ́ṣẹ̀ kan, irú èyí tí ènìyàn lè ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Bí ó bá dẹ́ṣẹ̀ báyìí tó sì jẹ̀bi, ó gbọdọ̀ dá ohun tó jí tàbí ohun tó fi agbára gbà, tàbí ohun tí a fi sí ìkáwọ́ rẹ̀, tàbí ohun tó sọnù tó rí he, ");
INSERT INTO yor_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","tàbí ohunkóhun tó búra èké lé lórí. Ó gbọdọ̀ dá gbogbo rẹ̀ padà ní pípé, kí ó fi ìdámárùn-ún iye rẹ̀ kún, kí ó sì dá gbogbo rẹ̀ padà fún ẹni tí ó ni í, ní ọjọ́ tó bá ń rú ẹbọ ẹ̀bi rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Fún ìtánràn rẹ̀, ó gbọdọ̀ mú àgbò kan láti inú agbo ẹran wá fún àlùfáà, àní síwájú Olúwa, ẹbọ ẹ̀bi, àgbò aláìlábùkù, tó sì níye lórí bí iye owó ibi mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Báyìí ní àlùfáà yóò ṣe ètùtù fún un ètùtù ìwẹ̀nùmọ́ níwájú Olúwa, a ó sì dáríjì í nítorí ohun tó ti ṣe tó sì mú un jẹ̀bi.” ");
INSERT INTO yor_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Pàṣẹ fún Aaroni àti àwọn ọmọ rẹ̀ pé, ‘Èyí ni ìlànà fún ẹbọ sísun; ẹbọ sísun gbọdọ̀ wà lórí pẹpẹ láti alẹ́ di òwúrọ̀, kí iná sì máa jó lórí pẹpẹ ");
INSERT INTO yor_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","kí àlùfáà sì wọ ẹ̀wù funfun rẹ̀ pẹ̀lú àwọ̀tẹ́lẹ̀ lára rẹ̀, yóò sì kó eérú tó wà níbi ẹbọ sísun tí iná ti jó lórí pẹpẹ, sí ẹ̀gbẹ́ pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Nígbà náà ni yóò bọ́ aṣọ rẹ̀, yóò sì wọ òmíràn, yóò wá gbé eérú náà lọ sí ẹ̀yìn ibùdó níbi tí a kà sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Iná tó wà lórí pẹpẹ gbọdọ̀ máa jó, kò gbọdọ̀ kú, ní àràárọ̀ ni kí àlùfáà máa to igi si, kí ó sì to ẹbọ sísun sórí iná, kí ó sì máa sun ọ̀rá ẹran ẹbọ àlàáfíà níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Iná gbọdọ̀ máa jó lórí pẹpẹ títí, kò gbọdọ̀ kú. ");
INSERT INTO yor_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Ìwọ̀nyí ni ìlànà fún ẹbọ ohun jíjẹ, kí àwọn ọmọ Aaroni gbé ẹbọ sísun náà wá síwájú Olúwa níwájú pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kí àlùfáà bu ẹ̀kúnwọ́ ìyẹ̀fun kíkúnná dáradára àti òróró pẹ̀lú gbogbo tùràrí tó wà lórí ẹbọ ohun jíjẹ náà kí ó sì sun ẹbọ ìrántí náà lórí pẹpẹ gẹ́gẹ́ bí òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aaroni àti àwọn ọmọ rẹ̀ ni yóò jẹ ìyókù ṣùgbọ́n wọ́n gbọdọ̀ jẹ ẹ́ láìsí máa wú máa wú ohun tí ń mú àkàrà wú nínú rẹ̀ ní ibi mímọ́, ní àgbàlá àgọ́ ìpàdé ni kí wọn ó ti jẹ ẹ́. ");
INSERT INTO yor_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ẹ má ṣe ṣè é pẹ̀lú ìwúkàrà. Èmi ti fún àwọn àlùfáà gẹ́gẹ́ bí ìpín wọn nínú ẹbọ tí a fi iná sun sí mi. Ó jẹ́ mímọ́ jùlọ gẹ́gẹ́ bí ẹbọ ẹ̀ṣẹ̀ àti ẹbọ ẹ̀bi náà ṣe jẹ́. ");
INSERT INTO yor_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Èyíkéyìí nínú àwọn ọmọkùnrin ìran Aaroni ló le jẹ ẹ́. Èyí ni ìpín rẹ tí ó gbọdọ̀ máa ṣe déédé lára àwọn ẹbọ tí a fi iná sun sí Olúwa láti ìrandíran. Ohunkóhun tí ó bá kàn án yóò di mímọ́.’ ” ");
INSERT INTO yor_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Èyí ni ọrẹ tí Aaroni àti àwọn ọmọ rẹ gbọdọ̀ mú wá fún Olúwa ní ọjọ́ tí a bá fi òróró yan ọ̀kọ̀ọ̀kan wọn; ìdámẹ́wàá òsùwọ̀n ìyẹ̀fun kíkúnná dáradára fún ẹbọ ohun jíjẹ lójoojúmọ́, ìdajì rẹ̀ ní àárọ̀ àti ìdajì rẹ̀ ní ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ẹ pèsè rẹ̀ pẹ̀lú òróró nínú àwo fífẹ̀, ẹ pò ó pọ̀ dáradára, kí ẹ sì gbé ọrẹ ohun jíjẹ náà wá ní ègé kéékèèké bí òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ọmọkùnrin Aaroni tí yóò rọ́pò rẹ̀ gẹ́gẹ́ bí àlùfáà tí a fi òróró yàn ni yóò rú ẹbọ náà. Ó jẹ́ ìpín ti Olúwa títí láé, wọn sì gbọdọ̀ sun ún pátápátá. ");
INSERT INTO yor_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Gbogbo ọrẹ ohun jíjẹ ti àlùfáà ni wọ́n gbọdọ̀ sun pátápátá, wọn kò gbọdọ̀ jẹ ẹ́.” ");
INSERT INTO yor_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Sọ fún Aaroni àti àwọn ọmọ rẹ̀ ọkùnrin, ‘Wọ̀nyí ni ìlànà fún ẹbọ ẹ̀ṣẹ̀, kí ẹ sì pa ẹran ẹbọ ẹ̀ṣẹ̀ níwájú Olúwa, níbi tí ẹ ti ń pa ẹran ẹbọ sísun, ó jẹ́ mímọ́ jùlọ. ");
INSERT INTO yor_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Àlùfáà tó rú ẹbọ náà ni kí ó jẹ ẹ́, ibi mímọ́ ni kí ó ti jẹ ẹ́, ní àgbàlá àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ohunkóhun tí ó bá kàn án yóò di mímọ́, bí ẹ̀jẹ̀ rẹ̀ bá sì ta sí ara aṣọ kan, ẹ gbọdọ̀ fọ̀ ọ́ ní ibi mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ẹ gbọdọ̀ fọ́ ìkòkò amọ̀ tí ẹ fi se ẹran náà, ṣùgbọ́n bí ó bá ṣe ìkòkò idẹ ni ẹ fi sè é, ẹ gbọdọ̀ bó o, kí ẹ sì fi omi sìn ín dáradára. ");
INSERT INTO yor_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Gbogbo ọkùnrin ní ìdílé àlùfáà ló lè jẹ ẹ́, ó jẹ́ mímọ́ jùlọ. ");
INSERT INTO yor_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ẹ kò gbọdọ̀ jẹ ẹbọ ẹ̀ṣẹ̀ kankan, èyí tí wọ́n bá mú ẹ̀jẹ̀ rẹ̀ wá sínú àgọ́ ìpàdé láti fi ṣe ètùtù ní Ibi Mímọ́, sísun ni kí ẹ sun ún. ");
INSERT INTO yor_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Wọ̀nyí ni àwọn ìlànà fún rírú ẹbọ ẹ̀bi, tí ó jẹ́ mímọ́ jùlọ. ");
INSERT INTO yor_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Níbi tí wọn ti ń pa ẹran ẹbọ sísun ni kí ẹ ti pa ẹran ẹbọ ẹ̀bi, kí ẹ sì wọ́n ẹ̀jẹ̀ rẹ̀ yí pẹpẹ náà ká. ");
INSERT INTO yor_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Gbogbo ọ̀rá rẹ̀ ni kí ẹ sun, ọ̀rá ìrù rẹ̀ àti ọ̀rá tí ó bo nǹkan inú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Kíndìnrín méjèèjì pẹ̀lú ọ̀rá tí ó wà lẹ́bàá ìhà rẹ̀, àti ọ̀rá tí ó bo ẹ̀dọ̀, kí ó yọ ọ́ pẹ̀lú àwọn kíndìnrín. ");
INSERT INTO yor_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Àlùfáà yóò sun wọ́n lórí pẹpẹ gẹ́gẹ́ bí ọrẹ tí a fi iná sun sí Olúwa. Ẹbọ ẹ̀bi ni. ");
INSERT INTO yor_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Gbogbo ọkùnrin ní ìdílé àlùfáà ló lè jẹ ẹ́ ní ibi mímọ́, ó jẹ́ mímọ́ jùlọ. ");
INSERT INTO yor_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Òfin yìí kan náà ló wà fún ẹbọ ẹ̀ṣẹ̀ àti ẹbọ ẹ̀bi: méjèèjì jẹ́ tí àlùfáà, tó fi wọ́n ṣe ètùtù. ");
INSERT INTO yor_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Àlùfáà tó rú ẹbọ sísun fún ẹnikẹ́ni le è mú awọ ẹran ìrúbọ náà. ");
INSERT INTO yor_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Gbogbo ẹbọ ohun jíjẹ tí a bá yan lórí ààrò, àti gbogbo èyí tí a yan nínú apẹ, àti nínú àwopẹ̀tẹ́, ni kí ó jẹ́ ti àlùfáà tí ó rú ẹbọ náà. ");
INSERT INTO yor_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Bẹ́ẹ̀ náà ni ẹbọ ohun jíjẹ yálà a fi òróró pò ó tàbí èyí tó jẹ́ gbígbẹ, wọ́n jẹ́ ti gbogbo ọmọ Aaroni. ");
INSERT INTO yor_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Wọ̀nyí ni àwọn ìlànà fún ọrẹ àlàáfíà tí ẹnikẹ́ni bá gbé wá síwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Bí ẹni náà bá gbé e wá gẹ́gẹ́ bí àfihàn ọkàn ọpẹ́, pẹ̀lú ẹbọ ọpẹ́ yìí, ó gbọdọ̀ mú àkàrà aláìwú tí a fi òróró pò wá àti àkàrà aláìwú fẹ́lẹ́fẹ́lẹ́ tí a dà òróró sí àti àkàrà tí a fi ìyẹ̀fun kíkúnná dáradára tí a fi òróró pò ṣe. ");
INSERT INTO yor_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pẹ̀lú ọrẹ àlàáfíà rẹ̀, kí ó tún mú àkàrà wíwú wá fún ọpẹ́, ");
INSERT INTO yor_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","kí ó mú ọ̀kọ̀ọ̀kan nínú oríṣìíríṣìí ọrẹ àlàáfíà rẹ wá gẹ́gẹ́ bí ẹ̀bùn fún Olúwa, ó jẹ́ tí àlùfáà tí ó wọ́n ẹ̀jẹ̀ ọrẹ àlàáfíà. ");
INSERT INTO yor_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ẹran ọrẹ àlàáfíà ti ọpẹ́ yìí ni wọ́n gbọdọ̀ jẹ ní ọjọ́ gan an tí wọ́n rú ẹbọ, kò gbọdọ̀ ṣẹ́ ẹran kankan kù di àárọ̀ ọjọ́ kejì. ");
INSERT INTO yor_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Ṣùgbọ́n bí ó bá jẹ́ pé ó mú ọrẹ wá, nítorí ẹ̀jẹ́ tó jẹ́ tàbí kí ó jẹ́ ọrẹ àtinúwá, wọn yóò jẹ ẹbọ náà ní ọjọ́ tí wọ́n rú ẹbọ yìí, ṣùgbọ́n wọ́n lè jẹ èyí tó ṣẹ́kù ní ọjọ́ kejì. ");
INSERT INTO yor_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Gbogbo ẹran tó bá ṣẹ́kù di ọjọ́ kẹta ní ẹ gbọdọ̀ sun. ");
INSERT INTO yor_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Bí ẹ bá jẹ ọ̀kankan nínú ẹran ọrẹ àlàáfíà ní ọjọ́ kẹta, kò ni jẹ́ ìtẹ́wọ́gbà. A kò ní í kà á sí fún ẹni tó rú ẹbọ náà, nítorí pé ó jẹ́ àìmọ́, ẹnikẹ́ni tó bá sì jẹ ẹ́, ni a ó di ẹ̀bi rẹ̀ rù. ");
INSERT INTO yor_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Ẹ kò gbọdọ̀ jẹ ẹran tí ó bá ti kan ohun tí a kà sí àìmọ́, sísun ni kí ẹ sun ún. Ẹnikẹ́ni tí a ti kà sí mímọ́ le è jẹ nínú ẹran tí ó kù. ");
INSERT INTO yor_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ṣùgbọ́n bí ẹni tí kò mọ́ bá jẹ́ ẹran ọrẹ àlàáfíà tí ó jẹ́ tí Olúwa, a ó gé irú ẹni bẹ́ẹ̀ kúrò lára àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Bí ẹnikẹ́ni bá fọwọ́ kan ohun aláìmọ́ yálà ohun àìmọ́ ti ènìyàn, ẹranko aláìmọ́, ohun àìmọ́ yówù kí ó jẹ́ tàbí ohunkóhun tí ó jẹ́ ìríra, tí ó sì tún jẹ́ ẹran ọrẹ àlàáfíà tó jẹ́ ti Olúwa, a ó gé irú ẹni bẹ́ẹ̀ kúrò lára àwọn ènìyàn rẹ.’ ” ");
INSERT INTO yor_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Sọ fún àwọn ọmọ Israẹli pé, ‘Ẹ má ṣe jẹ ọ̀rá màlúù, àgùntàn tàbí ewúrẹ́. ");
INSERT INTO yor_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ẹ lè lo ọ̀rá ẹran tó kú fúnra rẹ̀ tàbí èyí tí ẹranko igbó pa, fún nǹkan mìíràn, ṣùgbọ́n ẹ kò gbọdọ̀ jẹ ẹ́. ");
INSERT INTO yor_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ẹnikẹ́ni tó bá jẹ ọ̀rá ẹran tí a fi rú ẹbọ sísun sí Olúwa ni ẹ gbọdọ̀ gé kúrò lára àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ẹ kò sì gbọdọ̀ jẹ ẹ̀jẹ̀ ẹyẹ tàbí ẹran ní gbogbo ibi tí ẹ bá ń gbé. ");
INSERT INTO yor_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Bí ẹnikẹ́ni bá jẹ ẹ̀jẹ̀, a ó gé ẹni bẹ́ẹ̀ kúrò lára àwọn ènìyàn rẹ̀.’ ” ");
INSERT INTO yor_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Sọ fún àwọn ọmọ Israẹli pé, ‘Ẹnikẹ́ni tó bá mú ọrẹ àlàáfíà wá fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Pẹ̀lú ọwọ́ ara rẹ̀ ni kí ó fi mú ọrẹ tí a fi iná sun wá fún Olúwa, kí ó mú ọ̀rá àti igẹ̀, kí ó sì fi igẹ̀ yìí níwájú Olúwa bí ọrẹ fífì. ");
INSERT INTO yor_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Àlùfáà yóò sun ọ̀rá náà lórí pẹpẹ ṣùgbọ́n igẹ̀ ẹran náà jẹ́ ti Aaroni àti àwọn ọmọ rẹ̀, ");
INSERT INTO yor_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","kí ẹ fún àlùfáà ní itan ọ̀tún lára ọrẹ àlàáfíà yín gẹ́gẹ́ bí ìpín tiyín fún àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ọmọ Aaroni ẹni tí ó rú ẹbọ ẹ̀jẹ̀ àti ọ̀rá ọrẹ àlàáfíà ni kí ó ni itan ọ̀tún gẹ́gẹ́ bí ìpín tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Nínú ọrẹ àlàáfíà àwọn ọmọ Israẹli, mo ti ya igẹ̀ tí a fi àti itan tí ẹ mú wá sọ́tọ̀ fún Aaroni àlùfáà àti àwọn ọmọ rẹ̀ gẹ́gẹ́ bí ìpín wọn ní gbogbo ìgbà láti ọ̀dọ̀ ara Israẹli.’ ” ");
INSERT INTO yor_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Èyí ni ìpín tí a yà sọ́tọ̀ fún Aaroni àti àwọn ọmọ rẹ̀ nínú ẹbọ tí a finá sun sí Olúwa lọ́jọ́ tí wọ́n mú wọn wá láti sin Olúwa gẹ́gẹ́ bí àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Lọ́jọ́ tí a fi òróró yàn wọ́n, ni Olúwa ti pa á láṣẹ pé kí àwọn ọmọ Israẹli máa fún wọn ní àwọn nǹkan wọ̀nyí gẹ́gẹ́ bí ìpín wọn ìgbà gbogbo fún àwọn ìran tó ń bọ̀. ");
INSERT INTO yor_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Nítorí náà, àwọn nǹkan wọ̀nyí jẹ́ ìlànà fún ẹbọ sísun, ẹbọ ẹ̀ṣẹ̀, ẹbọ ẹ̀bi, ìfinijoyè àlùfáà àti ẹbọ àlàáfíà ");
INSERT INTO yor_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","èyí tí Olúwa fún Mose lórí òkè Sinai lọ́jọ́ tí Olúwa pa á láṣẹ fún àwọn ọmọ Israẹli pé kí wọ́n máa mú ọrẹ wọn wá fún Olúwa ni ijù Sinai. ");
INSERT INTO yor_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Mú Aaroni àti àwọn ọmọ rẹ̀, aṣọ wọn, òróró ìtasórí, akọ màlúù fún ẹbọ ẹ̀ṣẹ̀, àgbò méjì àti apẹ̀rẹ̀ tí a kó àkàrà aláìwú sínú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Kí o sì kó gbogbo ìjọ ènìyàn jọ sí ẹnu-ọ̀nà àgọ́ ìpàdé.” ");
INSERT INTO yor_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mose sì ṣe bí Olúwa ti pa á láṣẹ fún un, gbogbo ènìyàn sì péjọ sí ẹnu-ọ̀nà àgọ́ àjọ. ");
INSERT INTO yor_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mose sì sọ fún ìjọ ènìyàn pé, “Èyí ni ohun tí Olúwa ti pàṣẹ pé kí á ṣe.” ");
INSERT INTO yor_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Nígbà náà ni Mose mú Aaroni àti àwọn ọmọ rẹ̀ wá síwájú, ó sì fi omi wẹ̀ wọ́n. ");
INSERT INTO yor_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ó sì fi aṣọ àwọ̀tẹ́lẹ̀ wọ Aaroni, ó fi àmùrè dì í, ó wọ̀ ọ́ ní efodu; aṣọ ìgúnwà, ó sì tún wọ̀ ọ́ ni aṣọ ìlekè oyè àlùfáà tí ó ní ìgbànú tí a ṣe ọnà dáradára sí. ");
INSERT INTO yor_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ó fi ìgbàyà sí àyà rẹ̀, ó sì fi Urimu àti Tumimu sí ibi ìgbàyà náà. ");
INSERT INTO yor_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ó dé e ní fìlà, ó sì fi àwo wúrà tí í ṣe adé mímọ́ síwájú rẹ̀ gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Mose sì fi òróró ìtasórí ya àgọ́ àti ohun gbogbo tó wà nínú rẹ̀ sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ó wọ́n díẹ̀ nínú òróró yìí sórí pẹpẹ lẹ́ẹ̀méje, ó ta òróró sórí pẹpẹ àti gbogbo ohun èlò àti agbada pẹ̀lú ohun tó gbé agbada yìí dúró láti lè yà á sí mímọ́, ");
INSERT INTO yor_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ó da díẹ̀ lára òróró ìtasórí yìí sórí Aaroni, ó sì yà á sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Lẹ́yìn èyí ló mú àwọn ọmọ Aaroni wá síwájú, ó sì fi ẹ̀wù àwọ̀tẹ́lẹ̀ wọ̀ wọ́n, ó fi àmùrè dìwọ́n lára, ó fi fìlà dé wọn lórí gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ó sì mú akọ màlúù wá fún ẹbọ ẹ̀ṣẹ̀. Aaroni àti àwọn ọmọ rẹ̀ sì gbọ́wọ́ lé orí ẹran náà. ");
INSERT INTO yor_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mose pa akọ màlúù náà, ó sì ti ìka bọ inú ẹ̀jẹ̀ náà, ó fi sí orí gbogbo ìwo pẹpẹ láti wẹ pẹpẹ náà mọ́. Ó da ìyókù ẹ̀jẹ̀ náà sí ìsàlẹ̀ pẹpẹ. Bẹ́ẹ̀ ní ó ṣe yà á sí mímọ́ láti ṣe ètùtù fún un. ");
INSERT INTO yor_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mose tún mú gbogbo ọ̀rá tí ó bo nǹkan inú, èyí tí ó bo ẹ̀dọ̀, kíndìnrín méjèèjì àti ọ̀rá wọn, ó sì sun gbogbo rẹ̀ lórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ṣùgbọ́n akọ màlúù yìí pẹ̀lú awọ àti ara ẹran àti ìgbẹ́ rẹ̀ ní ó sun lẹ́yìn ibùdó gẹ́gẹ́ bí Olúwa ti paláṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Lẹ́yìn náà ló mú àgbò wá fún ẹbọ sísun Aaroni àti àwọn ọmọ rẹ̀ sì gbọ́wọ́ lé orí àgbò náà. ");
INSERT INTO yor_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mose sì pa àgbò náà, ó sì wọ́n ẹ̀jẹ̀ rẹ̀ yí pẹpẹ náà ká. ");
INSERT INTO yor_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ó gé àgbò náà sí wẹ́wẹ́, Mose sì sun orí àti àwọn ègé àti ọ̀rá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ó fi omi fọ gbogbo nǹkan inú àti ẹsẹ̀ rẹ̀, ó sì sun odidi àgbò náà lórí pẹpẹ bí ẹbọ sísun òórùn dídùn, ẹbọ tí a fi iná ṣe sí Olúwa gẹ́gẹ́ bí Olúwa tí pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ó sì mú àgbò kejì wa, èyí ni àgbò ìfinijoyè àlùfáà, Aaroni àti àwọn ọmọ rẹ̀ sì gbọ́wọ́ lé e lórí. ");
INSERT INTO yor_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mose sì pa àgbò náà, ó sì mú díẹ̀ nínú ẹ̀jẹ̀, ó tọ́ ọ sí etí ọ̀tún Aaroni, sórí àtàǹpàkò ọwọ́ ọ̀tún àti ti ẹsẹ̀ ọ̀tún rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Mose sì tún mú àwọn ọmọ Aaroni wá síwájú, ó sì mú ẹ̀jẹ̀ díẹ̀ ó fi sí etí ọ̀tún wọn, àtàǹpàkò ọwọ́ ọ̀tún wọn, ó sì wọ́n ẹ̀jẹ̀ yí pẹpẹ náà ká. ");
INSERT INTO yor_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ó mú ọ̀rá ẹran náà, ìrù rẹ̀ tí ó lọ́ràá, gbogbo ọ̀rá tó wà lára nǹkan inú àti èyí tí ó bo ẹ̀dọ̀, kíndìnrín méjèèjì àti ọ̀rá wọn pẹ̀lú itan ọ̀tún. ");
INSERT INTO yor_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Lẹ́yìn náà ló mú àkàrà aláìwú sí, èyí tó wà níwájú Olúwa àti àkàrà tí a fi òróró ṣe, àti àkàrà fẹ́lẹ́fẹ́lẹ́, ó sì kó gbogbo rẹ̀ sórí ọ̀rá àti itan ọ̀tún ẹran náà. ");
INSERT INTO yor_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ó kó gbogbo àwọn nǹkan wọ̀nyí lé Aaroni àti àwọn ọmọ rẹ̀ lọ́wọ́, wọ́n sì fì wọ́n gẹ́gẹ́ bí ẹbọ fífì níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Lẹ́yìn náà, Mose gba gbogbo rẹ̀ lọ́wọ́ wọn, ó sì sun wọn lórí ẹbọ sísun tó wà lórí pẹpẹ gẹ́gẹ́ bí ẹbọ ìfinijoyè àlùfáà òórùn dídùn, ẹbọ tí a fi iná sun sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mose sì mú igẹ̀ ẹran náà, èyí tó jẹ́ ìpín rẹ̀ nínú àgbò fún ìfinijoyè, ó sì fì í níwájú Olúwa gẹ́gẹ́ bí ẹbọ fífì, bi Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mose sì mú díẹ̀ lára òróró ìtasórí àti díẹ̀ nínú ẹ̀jẹ̀ láti orí pẹpẹ, ó wọ́n sára àwọn ọmọ Aaroni àti aṣọ rẹ̀, ó sì tún wọ́n sára àwọn ọmọ Aaroni àti aṣọ wọn. Bẹ́ẹ̀ ní Mose ya Aaroni àti àwọn ọmọ rẹ̀ pẹ̀lú aṣọ wọn sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mose sì sọ fún Aaroni àti àwọn ọmọ rẹ̀ pé, “Ẹ se ẹran náà ní ẹnu-ọ̀nà àgọ́ ìpàdé kí ẹ sì jẹ ẹ́ níbẹ̀ pẹ̀lú àkàrà tí a mú láti inú apẹ̀rẹ̀ ọrẹ ìfinijoyè àlùfáà gẹ́gẹ́ bí mo ti pa á láṣẹ pé, ‘Aaroni àti àwọn ọmọ rẹ̀ ni kí ó jẹ ẹ́.’ ");
INSERT INTO yor_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kí ẹ fi iná sun ìyókù àkàrà àti ẹran náà. ");
INSERT INTO yor_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ẹ má ṣe kúrò ní ẹnu-ọ̀nà àgọ́ ìpàdé fún ọjọ́ méje, títí tí ọjọ́ ìfinijoyè àlùfáà yín yóò fi pé, nítorí pé ìfinijoyè àlùfáà yín yóò gba ọjọ́ méje gbáko. ");
INSERT INTO yor_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ohun tí a ṣe lónìí jẹ́ ohun tí Olúwa ti pàṣẹ láti ṣe ètùtù fún yín. ");
INSERT INTO yor_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ẹ gbọdọ̀ wà ní ẹnu-ọ̀nà àgọ́ ìpàdé lọ́sàn án àti lóru fún ọjọ́ méje kí ẹ sì ṣe ohun tí Olúwa fẹ́, kí ẹ má ba à kú, nítorí ohun tí Olúwa pàṣẹ fún mi ni èyí.” ");
INSERT INTO yor_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Báyìí ni Aaroni àti àwọn ọmọ rẹ̀ ṣe ohun gbogbo tí Olúwa pàṣẹ láti ẹnu Mose. ");
INSERT INTO yor_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ní ọjọ́ kẹjọ, Mose pe Aaroni àti àwọn ọmọ rẹ̀ pẹ̀lú àwọn àgbàgbà Israẹli. ");
INSERT INTO yor_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ó sọ fún Aaroni pé, “Mú akọ ọmọ màlúù kan wá fún ẹbọ ẹ̀ṣẹ̀ àti àgbò kan fún ẹbọ sísun, kí méjèèjì jẹ́ aláìlábùkù, kí o sì mú wọn wá sí iwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Kí o sì sọ fún àwọn ará Israẹli pé, ‘Ẹ mú òbúkọ kan wá fún ẹbọ ẹ̀ṣẹ̀, ọmọ màlúù àti ọ̀dọ́-àgùntàn kan, kí méjèèjì jẹ́ ọlọ́dún kọ̀ọ̀kan tí kò ní àbùkù fún ẹbọ sísun, ");
INSERT INTO yor_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","àti akọ màlúù kan àti àgbò kan fún ẹbọ àlàáfíà àti ẹbọ ohun jíjẹ tí a fi òróró pò láti fi rú ẹbọ ní iwájú Olúwa. Nítorí pé Olúwa yóò farahàn yín ní òní.’ ” ");
INSERT INTO yor_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Wọ́n kó gbogbo àwọn nǹkan tí Mose pàṣẹ wá sí iwájú àgọ́ ìpàdé, gbogbo ìjọ ènìyàn sì súnmọ́ tòsí, wọ́n sì dúró níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Nígbà náà ni Mose wí pé, “Ohun tí Olúwa pàṣẹ fún yín láti ṣe nìyìí, kí ògo Olúwa bá à lè farahàn yín.” ");
INSERT INTO yor_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mose sọ fún Aaroni pé, “Wá sí ibi pẹpẹ kí o sì rú ẹbọ ẹ̀ṣẹ̀ rẹ àti ẹbọ sísun rẹ, kí o sì ṣe ètùtù fún ara rẹ àti fún àwọn ènìyàn; rú ẹbọ ti àwọn ènìyàn náà, kí o sì ṣe ètùtù fún wọn gẹ́gẹ́ bí Olúwa ti pa á láṣẹ.” ");
INSERT INTO yor_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaroni sì wá sí ibi pẹpẹ, ó pa akọ ọmọ màlúù fún ẹbọ ẹ̀ṣẹ̀ ara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Àwọn ọmọ Aaroni sì mú ẹ̀jẹ̀ náà tọ̀ ọ́ wá, ó sì ti ìka ọwọ́ rẹ̀ bọ inú ẹ̀jẹ̀ náà, ó fi sí orí ìwo pẹpẹ, ó sì da ìyókù ẹ̀jẹ̀ náà sí ìsàlẹ̀ pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ó sun ọ̀rá, kíndìnrín àti ọ̀rá tí ó bo ẹ̀dọ̀, èyí tó mú láti inú ẹbọ ẹ̀ṣẹ̀, lórí pẹpẹ bí Olúwa ti pa á láṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ó sì sun ara ẹran àti awọ rẹ̀ ní ẹ̀yìn ibùdó. ");
INSERT INTO yor_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Lẹ́yìn èyí ó pa ẹran tó wà fún ẹbọ sísun. Àwọn ọmọ Aaroni sì mú ẹ̀jẹ̀ rẹ̀ tọ̀ ọ́ wá, ó sì wọn yí pẹpẹ náà ká. ");
INSERT INTO yor_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Wọ́n sì ń mú ẹbọ sísun náà fún un ní ègé kọ̀ọ̀kan, pẹ̀lú orí rẹ̀, ó sun gbogbo rẹ̀ lórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ó fọ nǹkan inú rẹ̀ àti ẹsẹ̀ rẹ̀, ó sun wọ́n lórí ẹbọ sísun tó wà lórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Aaroni mú ẹbọ tó jẹ́ ti àwọn ènìyàn wá. Ó mú òbúkọ èyí tó dúró fún ẹbọ ẹ̀ṣẹ̀ àwọn ènìyàn ó sì pa á, ó fi rú ẹbọ ẹ̀ṣẹ̀ gẹ́gẹ́ bí ó ti ṣe ti àkọ́kọ́. ");
INSERT INTO yor_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ó mú ẹbọ sísun wá, ó sì rú u gẹ́gẹ́ bí ìlànà tí a fi lélẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ó tún mu ẹbọ ohun jíjẹ wá, ó bu ẹ̀kúnwọ́ kan nínú rẹ̀, ó sì sun ún lórí pẹpẹ ní àfikún ẹbọ sísun tí àárọ̀. ");
INSERT INTO yor_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ó pa akọ màlúù àti àgbò bí ẹbọ àlàáfíà fún àwọn ènìyàn. Àwọn ọmọ Aaroni sì mú ẹ̀jẹ̀ ẹran náà tọ̀ ọ́ wá, ó sì wọn yí pẹpẹ náà ká. ");
INSERT INTO yor_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ṣùgbọ́n ọ̀rá akọ màlúù àti àgbò náà: ìrù rẹ̀ tí ó lọ́ràá, básí ọ̀rá, ọ̀rá kíndìnrín, àti ọ̀rá tí ó bo ẹ̀dọ̀: ");
INSERT INTO yor_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","gbogbo rẹ̀ ni wọ́n kó lórí igẹ̀ ẹran náà. Aaroni sì sun ọ̀rá náà lórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aaroni fi igẹ̀ àti itan ọ̀tún ẹran náà níwájú Olúwa gẹ́gẹ́ bí ẹbọ fífì bí Mose ṣe pa á láṣẹ. ");
INSERT INTO yor_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aaroni sì gbé ọwọ́ rẹ̀ sókè sí àwọn ènìyàn, ó sì súre fún wọn. Lẹ́yìn tó sì ti rú ẹbọ ẹ̀ṣẹ̀, ẹbọ sísun àti ẹbọ àlàáfíà, ó sọ̀kalẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mose àti Aaroni sì wọ inú àgọ́ ìpàdé. Nígbà tí wọ́n jáde, wọ́n súre fún àwọn ènìyàn, ògo Olúwa sì farahàn sí gbogbo ènìyàn. ");
INSERT INTO yor_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Iná sì jáde láti ọ̀dọ̀ Olúwa, ó sì jó ẹbọ sísun àti ọ̀rá orí pẹpẹ. Nígbà tí gbogbo ènìyàn sì rí èyí wọ́n hó ìhó ayọ̀, wọ́n sì dojúbolẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadabu àti Abihu tí í ṣe ọmọ Aaroni sì mú àwo tùràrí kọ̀ọ̀kan, wọ́n fi iná àti tùràrí sínú rẹ̀, wọ́n sì rú iná àjèjì níwájú Olúwa, èyí tó lòdì sí àṣẹ Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Torí èyí, iná jáde láti ọ̀dọ̀ Olúwa, ó sì jó wọn pa, wọ́n sì kú níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mose sì sọ fún Aaroni pé, “Ohun tí Olúwa ń sọ nípa rẹ̀ nìyìí nígbà tó wí pé, “ ‘Ní àárín àwọn tó súnmọ́ mi, Èmi yóò fi ara mi hàn ní mímọ́ ojú gbogbo ènìyàn Ní a ó ti bu ọlá fún mi.’ ” Aaroni sì dákẹ́. ");
INSERT INTO yor_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mose pe Miṣaeli àti Elsafani ọmọ Usieli tí í ṣe arákùnrin Aaroni, ó sọ fún wọn pé, “Ẹ wá, kí ẹ sì gbé àwọn arákùnrin yín jáde kúrò níwájú ibi mímọ́ lọ sí ẹ̀yìn ibùdó.” ");
INSERT INTO yor_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Wọ́n sì wá gbé wọn, pẹ̀lú ẹ̀wù àwọ̀tẹ́lẹ̀ wọn ní ọrùn wọn lọ sí ẹ̀yìn ibùdó bí Mose ti sọ. ");
INSERT INTO yor_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mose sọ fún Aaroni àti àwọn ọmọ rẹ̀ yòókù, Eleasari àti Itamari pé, “ẹ má ṣe ṣọ̀fọ̀ nípa ṣíṣe aláìtọ́jú irun yín tàbí kí ẹ ṣí orí yín sílẹ̀, ẹ kò sì gbọdọ̀ ya aṣọ, bí ẹ bá ṣe bẹ́ẹ̀, ẹ ó kùú, Olúwa yóò sì bínú sí gbogbo ìjọ ènìyàn. Ṣùgbọ́n àwọn ẹbí yín, àti gbogbo ilé Israẹli le è ṣọ̀fọ̀ lórí àwọn tí Olúwa fi iná parun. ");
INSERT INTO yor_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ẹ má ṣe kúrò ní ẹnu-ọ̀nà àgọ́ ìpàdé, bí ẹ bá kúrò níbẹ̀, ẹ ó kù ú, nítorí pé òróró ìtasórí Olúwa wà lórí yín.” Wọ́n sì ṣe bí Mose ti wí. ");
INSERT INTO yor_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Olúwa sì sọ fún Aaroni pé. ");
INSERT INTO yor_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Ìwọ àti àwọn ọmọ rẹ̀ kò gbọdọ̀ mu ọtí wáìnì tàbí ọtí líle mìíràn nígbàkígbà tí ẹ bá n lọ inú àgọ́ ìpàdé, bí ẹ bá ṣe bẹ́ẹ̀, ẹ ó kù ú, èyí jẹ́ ìlànà títí láé fún un yín láti ìrandíran. ");
INSERT INTO yor_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ẹ gbọdọ̀ mọ ìyàtọ̀ láàrín mímọ́ àti àìmọ́, láàrín èérí àti àìléèérí. ");
INSERT INTO yor_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ẹ gbọdọ̀ kọ́ àwọn ara Israẹli ní gbogbo àṣẹ tí Olúwa fún wọn láti ẹnu Mose.” ");
INSERT INTO yor_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mose sì sọ fún Aaroni, Eleasari àti Itamari àwọn ọmọ rẹ̀ yòókù pé, “Ẹ mú ẹbọ ohun jíjẹ tó ṣẹ́kù láti inú ẹbọ àfinásun sí Olúwa, kí ẹ jẹ ẹ́ láìní ìwúkàrà nínú, lẹ́gbẹ̀ẹ́ pẹpẹ nítorí ó jẹ́ mímọ́ jùlọ. ");
INSERT INTO yor_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ẹ jẹ́ ní ibi mímọ́, nítorí pé òun ni ìpín rẹ àti ti àwọn ọmọ rẹ nínú ẹbọ tí a finá sun sí Olúwa nítorí pé bẹ́ẹ̀ ni mo ṣe pa á láṣẹ. ");
INSERT INTO yor_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ṣùgbọ́n ìwọ àti àwọn ọmọkùnrin àti àwọn ọmọbìnrin rẹ le jẹ igẹ̀ ẹran tí a fì níwájú Olúwa àti itan tí wọ́n gbé síwájú Olúwa, kí ẹ jẹ wọ́n ní ibi tí a kà sí mímọ́, èyí ni a ti fún ìwọ àti àwọn ọmọ rẹ gẹ́gẹ́ bí ìpín yín nínú ẹbọ àlàáfíà àwọn ara Israẹli. ");
INSERT INTO yor_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Itan tí wọ́n mú wá àti igẹ̀ ẹran tí ẹ fì ni ẹ gbọdọ̀ mú wá pẹ̀lú ọ̀rá ẹbọ tí a finá sun láti le è fì wọ́n níwájú Olúwa bí ẹbọ fífì. Èyí yóò sì jẹ́ ìpín tìrẹ àti ti àwọn ọmọ rẹ nígbà gbogbo bí Olúwa ṣe pàṣẹ.” ");
INSERT INTO yor_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Nígbà tí Mose wádìí nípa ewúrẹ́ ẹbọ ẹ̀ṣẹ̀ tó sì rí i pé wọ́n ti sun ún, ó bínú sí Eleasari àti Itamari, àwọn ọmọ Aaroni yòókù, ó sì béèrè pé, ");
INSERT INTO yor_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Èéṣe tí ẹ kò jẹ ẹbọ ẹ̀ṣẹ̀ náà ní agbègbè ibi mímọ́? Ó jẹ́ mímọ́ jùlọ, a fi fún yín láti lè mú ẹ̀ṣẹ̀ ìjọ ènìyàn kúrò nípa fífi ṣe ètùtù fún wọn níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Níwọ́n ìgbà tí ẹ kò mú ẹ̀jẹ̀ rẹ̀ wá sí Ibi Mímọ́, ẹ̀ bá ti jẹ ewúrẹ́ náà ní agbègbè Ibi Mímọ́ bí mo ṣe pa á láṣẹ.” ");
INSERT INTO yor_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaroni sì dá Mose lóhùn pé, “Lónìí tí wọ́n rú ẹbọ ẹ̀ṣẹ̀ àti ẹbọ sísun wọn níwájú Olúwa ni irú èyí tún ṣẹlẹ̀ sí mi. Ǹjẹ́ inú Olúwa yóò wá dùn bí mo bá jẹ ẹbọ ẹ̀ṣẹ̀ lónìí?” ");
INSERT INTO yor_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Nígbà tí Mose gbọ́ èyí, ọkàn rẹ̀ balẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Olúwa sọ fún Mose àti Aaroni pé, ");
INSERT INTO yor_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Ẹ sọ fún àwọn ara Israẹli pé, ‘Nínú gbogbo ẹranko tí ń gbé lórí ilẹ̀, àwọn wọ̀nyí ni ẹ le jẹ. ");
INSERT INTO yor_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Gbogbo ẹranko tí pátákò ẹsẹ̀ rẹ̀ bá là tí ó sì ń jẹ àpọ̀jẹ. ");
INSERT INTO yor_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Àwọn mìíràn wà tó ń jẹ àpọ̀jẹ nìkan. Àwọn mìíràn wà tó jẹ́ pé pátákò ẹsẹ̀ wọn nìkan ni ó là, ìwọ̀nyí ni ẹ kò gbọdọ̀ jẹ fún àpẹẹrẹ bí ó tilẹ̀ jẹ́ pé ìbákasẹ ń jẹ àpọ̀jẹ kò ya pátákò ẹsẹ̀, àìmọ́ ni èyí jẹ́. ");
INSERT INTO yor_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Bí ó tilẹ̀ jẹ́ pé gara (ẹranko tí ó dàbí ehoro tí ń gbé inú àpáta) ń jẹ àpọ̀jẹ; aláìmọ́ ni èyí jẹ́ fún yín. ");
INSERT INTO yor_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Bí ó tilẹ̀ jẹ́ pé ehoro ń jẹ àpọ̀jẹ, ṣùgbọ́n kò ya pátákò ẹsẹ̀; aláìmọ́ ni èyí jẹ́ fún yín. ");
INSERT INTO yor_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Bí ó tilẹ̀ jẹ́ pé ẹlẹ́dẹ̀ ya pátákò ẹsẹ̀ ṣùgbọ́n kì í jẹ àpọ̀jẹ; aláìmọ́ ni èyí jẹ́ fún yín. ");
INSERT INTO yor_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ẹ má ṣe jẹ ẹran wọn, ẹ kò sì gbọdọ̀ fọwọ́ kan òkú wọn. Àìmọ́ ni wọ́n jẹ́ fún yín. ");
INSERT INTO yor_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Nínú gbogbo ohun tí Ọlọ́run dá tí ń gbé inú omi Òkun, àti nínú odò: èyíkéyìí tí ó bá ní lẹbẹ àti ìpẹ́ ni ẹ lè jẹ́. ");
INSERT INTO yor_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ṣùgbọ́n nínú gbogbo ẹ̀dá tí ń gbé inú òkun àti nínú odò tí kò ní lẹbẹ àti ìpẹ́, yálà nínú gbogbo àwọn tí ń rákò tàbí láàrín gbogbo àwọn ẹ̀dá alààyè yòókù tí ń gbé inú omi àwọn ni kí ẹ kórìíra. ");
INSERT INTO yor_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Nígbà tí ẹ ti kórìíra wọn ẹ kò gbọdọ̀ jẹ ẹran wọn: ẹ gbọdọ̀ kórìíra òkú wọn. ");
INSERT INTO yor_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ohunkóhun tí ń gbé inú omi tí kò ní lẹbẹ àti ìpẹ́ gbọdọ̀ jásí ìríra fún yín. ");
INSERT INTO yor_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Àwọn ẹyẹ wọ̀nyí ni ẹ gbọdọ̀ kórìíra tí ẹ kò gbọdọ̀ jẹ wọ́n torí pé ohun ìríra ni wọ́n: idì, oríṣìíríṣìí igún, ");
INSERT INTO yor_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","àwòdì àti onírúurú àṣá, ");
INSERT INTO yor_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","onírúurú ẹyẹ ìwò, ");
INSERT INTO yor_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Òwìwí, onírúurú ògòǹgò, onírúurú ẹ̀lúùlú, onírúurú àwòdì, ");
INSERT INTO yor_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Òwìwí kéékèèké, onírúurú òwìwí, ");
INSERT INTO yor_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Òwìwí funfun àti òwìwí ilẹ̀ pápá, àti àkàlà, ");
INSERT INTO yor_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","àkọ̀, onírúurú òòdẹ̀, atọ́ka àti àdán. ");
INSERT INTO yor_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Gbogbo kòkòrò tí ń fò tí ó sì ń fi ẹsẹ̀ mẹ́rẹ̀ẹ̀rin rìn ni wọ́n jẹ́ ìríra fún yín, ");
INSERT INTO yor_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","irú àwọn kòkòrò oniyẹ̀ẹ́ tí wọn sì ń fi ẹsẹ̀ mẹ́rẹ̀ẹ̀rin rìn tí ẹ le jẹ nìyí, àwọn kòkòrò tí wọ́n ní ìṣẹ́po ẹsẹ̀ láti máa fi fò lórí ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Nínú àwọn wọ̀nyí ni ẹ lè jẹ onírúurú eṣú, onírúurú ìrẹ̀ àti onírúurú tata. ");
INSERT INTO yor_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ṣùgbọ́n gbogbo ohun ìyókù tí ń fò, tí ń rákò, tí ó ní ẹsẹ̀ mẹ́rin, òun ni kí ẹ̀yin kí ó kà sí ìríra fún yín. ");
INSERT INTO yor_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Nípa àwọn wọ̀nyí ni ẹ le fi sọ ara yín di àìmọ́. Ẹnikẹ́ni tí ó bá fọwọ́ kan òkú wọn yóò di aláìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ẹnikẹ́ni tí ó bá gbé òkú wọn gbọdọ̀ fọ aṣọ rẹ̀, yóò sì jẹ́ aláìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Àwọn ẹranko tí pátákò wọn kò là tan tàbí tí wọn kò jẹ àpọ̀jẹ jẹ́ àìmọ́ fún yín. Ẹni tí ó bá fọwọ́ kan òkú èyíkéyìí nínú wọn yóò jẹ́ aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Nínú gbogbo ẹranko tí ń fi ẹsẹ̀ mẹ́rẹ̀ẹ̀rin rìn, àwọn tí ń fi èékánná wọn rìn jẹ́ aláìmọ́ fún yín, ẹni tí ó bá fọwọ́ kan òkú wọn yóò jẹ́ aláìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ẹni tí ó bá gbé òkú wọn gbọdọ̀ fọ aṣọ rẹ̀, yóò sì jẹ́ aláìmọ́ títí di ìrọ̀lẹ́. Wọ̀nyí jẹ́ àìmọ́ fún yín. ");
INSERT INTO yor_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Nínú gbogbo ẹranko tí ń rìn lórí ilẹ̀ ìwọ̀nyí ni ó jẹ́ àìmọ́ fún yín: Asé, eku àti oríṣìíríṣìí aláǹgbá, ");
INSERT INTO yor_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Ọmọnílé, alágẹmọ, aláǹgbá, ìgbín àti ọ̀gà. ");
INSERT INTO yor_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Nínú gbogbo ohun tí ń rìn lórí ilẹ̀, ìwọ̀nyí jẹ́ àìmọ́ fún yín. Ẹnikẹ́ni tí ó bá fọwọ́ kan òkú wọn yóò di aláìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Bí ọ̀kan nínú wọn bá kú tí wọ́n sì bọ́ sórí nǹkan kan, bí ó ti wù kí irú ohun náà wúlò tó, yóò di aláìmọ́ yálà aṣọ ni a fi ṣe é ni tàbí igi, irun aṣọ tàbí àpò, ẹ sọ ọ́ sínú omi yóò jẹ́ aláìmọ́ títí ìrọ̀lẹ́ lẹ́yìn náà ni yóò tó di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Bí èyíkéyìí nínú wọn bá bọ́ sínú ìkòkò amọ̀, gbogbo ohun tí ó wà nínú rẹ̀ ti di àìmọ́. Ẹ gbọdọ̀ fọ ìkòkò náà. ");
INSERT INTO yor_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Bí omi inú ìkòkò náà bá dà sórí èyíkéyìí nínú oúnjẹ tí ẹ̀ ń jẹ oúnjẹ náà di aláìmọ́. Gbogbo ohun mímu tí a lè mú jáde láti inú rẹ̀ di àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Gbogbo ohun tí èyíkéyìí nínú òkú wọn bá já lé lórí di àìmọ́. Yálà ààrò ni tàbí ìkòkò ìdáná wọn gbọdọ̀ di fífọ́. Wọ́n jẹ́ àìmọ́. Ẹ sì gbọdọ̀ kà wọ́n sí àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Bí òkú wọn bá bọ́ sínú omi tàbí kànga tó ní omi nínú, omi náà kò di aláìmọ́ ṣùgbọ́n ẹnikẹ́ni tí ó bá yọ òkú wọn jáde tí ó fi ọwọ́ kàn án yóò di aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Bí òkú ẹranko wọ̀nyí bá bọ́ sórí ohun ọ̀gbìn tí ẹ fẹ́ gbìn wọ́n sì jẹ́ mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ṣùgbọ́n bí ẹ bá ti da omi sí ohun ọ̀gbìn náà tí òkú wọn sì bọ́ sí orí rẹ̀ àìmọ́ ni èyí fún un yín. ");
INSERT INTO yor_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Bí ẹran kan bá kú nínú àwọn tí ẹ lè jẹ, ẹnikẹ́ni tí ó bá fọwọ́ kan òkú rẹ̀ yóò di aláìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ẹnikẹ́ni tí ó bá jẹ èyíkéyìí nínú òkú ẹranko náà gbọdọ̀ fọ aṣọ rẹ̀, yóò sì di aláìmọ́ títí ìrọ̀lẹ́. Ẹnikẹ́ni tí ó bá gbé òkú ẹranko yóò fọ aṣọ rẹ̀ yóò sì wà ní àìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Ìríra ni gbogbo ohun tí ń rìn káàkiri lórí ilẹ̀ jẹ́, ẹ kò gbọdọ̀ jẹ wọ́n. ");
INSERT INTO yor_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ẹ kò gbọdọ̀ jẹ ohunkóhun tí ń rìn ká orí ilẹ̀ yálà ó ń fàyàfà tàbí ó ń fi ẹsẹ̀ mẹ́rẹ̀ẹ̀rin rìn, tàbí ó ń fi ọ̀pọ̀lọpọ̀ ẹsẹ̀ rìn ìríra ni èyí. ");
INSERT INTO yor_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ẹ̀yin kò gbọdọ̀ fi ohun kan tí ń rákò, sọ ara yín di ìríra, bẹ́ẹ̀ ni ẹ̀yin kò gbọdọ̀ fi wọ́n sọ ara yín di aláìmọ́, tí ẹ̀yin yóò fi ti ipa wọn di eléèérí. ");
INSERT INTO yor_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Èmi ni Olúwa Ọlọ́run yín, ẹ ya ara yín sọ́tọ̀ kí ẹ sì jẹ́ mímọ́ torí pé mo jẹ́ mímọ́. Ẹ má ṣe sọ ara yín di àìmọ́ nípasẹ̀ ohunkóhun tí ń rìn káàkiri lórí ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Èmi ni Olúwa tí ó mú yín jáde láti ilẹ̀ Ejibiti wá láti jẹ́ Ọlọ́run yín torí náà, ẹ jẹ́ mímọ́ torí pé mímọ́ ni èmi. ");
INSERT INTO yor_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Àwọn wọ̀nyí ni ìlànà fún ẹranko, ẹyẹ, gbogbo ẹ̀dá alààyè tí ń gbé inú omi àti àwọn ẹ̀dá tí ó ń rìn lórí ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ẹ gbọdọ̀ mọ ìyàtọ̀ láàrín àìmọ́ àti mímọ́ láàrín ẹ̀dá alààyè, tí ẹ le jẹ àti èyí tí ẹ kò le jẹ.’ ” ");
INSERT INTO yor_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Sọ fún àwọn ará Israẹli pé: ‘Obìnrin tí ó bá lóyún tí ó sì bí ọmọkùnrin, yóò wà láìmọ́ fún ọjọ́ méje bí ìgbà tí ó wà ní ipò àìmọ́ lákokò nǹkan oṣù rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ní ọjọ́ kẹjọ ni kí ẹ kọ ọmọ náà ní ilà. ");
INSERT INTO yor_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Obìnrin náà yóò sì dúró fún ọjọ́ mẹ́tàlélọ́gbọ̀n láti di mímọ́ kúrò nínú ìsun ẹ̀jẹ̀ rẹ̀. Kò gbọdọ̀ fi ọwọ́ kan ohunkóhun tí ó jẹ́ mímọ́ tàbí kí ó lọ sí ibi mímọ́ Olúwa títí di ọjọ́ tí ìwẹ̀nùmọ́ rẹ̀ yóò kọjá. ");
INSERT INTO yor_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Bí ó bá ṣe obìnrin ni ó bí, fún ọ̀sẹ̀ méjì ni obìnrin náà yóò fi wà ní ipò àìmọ́, gẹ́gẹ́ bí àkókò nǹkan oṣù rẹ̀. Ó sì gbọdọ̀ dúró ní ọjọ́ mẹ́rìndínláàádọ́rin láti di mímọ́ kúrò nínú ìsun ẹ̀jẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Nígbà tí ọjọ́ ìwẹ̀nùmọ́ rẹ̀ fún ọmọkùnrin tàbí ọmọbìnrin bá kọjá kí ó mú ọ̀dọ́-àgùntàn ọlọ́dún kan wá fún àlùfáà ní ẹnu-ọ̀nà àgọ́ ìpàdé fún ẹbọ sísun àti ọmọ ẹyẹlé tàbí àdàbà kan fún ẹbọ ẹ̀ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Ó gbọdọ̀ fi wọ́n rú ẹbọ níwájú Olúwa láti ṣe ètùtù fún obìnrin náà lẹ́yìn náà ni yóò di mímọ́ kúrò nínú ìsun ẹ̀jẹ̀ rẹ̀. “ ‘Ìwọ̀nyí ni àwọn ìlànà fún obìnrin tí ó bá bí ọmọkùnrin tàbí ọmọbìnrin. ");
INSERT INTO yor_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Bí kò bá lágbára àti fi àgùntàn ṣe é, ó gbọdọ̀ le mú àdàbà méjì tàbí ọmọ ẹyẹlé méjì, ọ̀kan fún ẹbọ ẹ̀ṣẹ̀, àti èkejì fún ẹbọ sísun. Báyìí ni àlùfáà yóò ṣe ètùtù fún un. Òun yóò sì di mímọ́.’ ” ");
INSERT INTO yor_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Olúwa sọ fún Mose àti Aaroni pé, ");
INSERT INTO yor_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Bí ẹnikẹ́ni bá ní ìwú, èélá tàbí àmì dídán kan ní ara rẹ̀, èyí tí ó le di ààrùn awọ ara tí ó le ràn ká. Ẹ gbọdọ̀ mú un tọ́ Aaroni àlùfáà lọ tàbí sí ọ̀dọ̀ ọ̀kan nínú àwọn ọmọ rẹ̀ tí ó jẹ́ àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Àlùfáà náà ni ó gbọdọ̀ yẹ egbò ara rẹ̀ wò: bí irun egbò náà bá di funfun tí egbò náà sì dàbí i pé ó jinlẹ̀ kọjá awọ ara: èyí jẹ́ ààrùn ara tí ó le è ràn, bí àlùfáà bá yẹ̀ ẹ́ wò kí ó sọ ọ́ di mí mọ̀ pé aláìmọ́ ni ẹni náà. ");
INSERT INTO yor_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Bí àpá ara rẹ̀ bá funfun tí ó sì dàbí ẹni pé kò jinlẹ̀ jù awọ ara, tí irun rẹ̀ kò sì yípadà sí funfun kí àlùfáà fi ẹni náà pamọ́ fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ní ọjọ́ keje ni kí àlùfáà yẹ̀ ẹ́ wò, bí ó bá rí i pé egbò náà wà síbẹ̀ tí kò sì ràn ká àwọ̀ ara, kí ó tún fi pamọ́ fún ọjọ́ méje mìíràn. ");
INSERT INTO yor_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ní ọjọ́ keje ni kí àlùfáà tún padà yẹ̀ ẹ́ wò, bí egbò náà bá ti san tí kò sì ràn ká awọ ara rẹ̀. Kí àlùfáà pè é ní mímọ́. Kí ọkùnrin náà fọ aṣọ rẹ̀, yóò sì mọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ṣùgbọ́n bí èélá náà bá ń ràn ká awọ ara rẹ̀ lẹ́yìn ìgbà tí ó ti fi ara rẹ̀ han àlùfáà láti sọ pé ó ti mọ́. Ó tún gbọdọ̀ fi ara rẹ̀ hàn níwájú àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kí àlùfáà yẹ̀ ẹ́ wò, bí èélá náà bá ràn ká awọ ara rẹ̀, kí àlùfáà fihàn pé kò mọ́. Ààrùn ara tí ń ràn ni èyí. ");
INSERT INTO yor_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Ẹnikẹ́ni tí ó bá ní ààrùn awọ ara tí ń ràn yìí ni kí a mú wá sọ́dọ̀ àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kí àlùfáà yẹ̀ ẹ́ wò bí ìwú funfun kan bá wà lára rẹ̀, èyí tí ó ti sọ irun ibẹ̀ di funfun, tí a sì rí ojú egbò níbi ìwú náà. ");
INSERT INTO yor_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Ààrùn ara búburú gbá à ni èyí, kí àlùfáà jẹ́ kí ó di mí mọ̀ pé irú ẹni bẹ́ẹ̀ kò mọ́: kí ó má ṣe ya ẹni náà sọ́tọ̀ fún àyẹ̀wò torí pé aláìmọ́ ni ẹni náà jẹ́ tẹ́lẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Bí ààrùn náà bá ràn yíká gbogbo awọ ara rẹ̀ tí àlùfáà sì yẹ̀ ẹ́ wò, tí ó rí i pé ààrùn náà ti gba gbogbo ara rẹ̀ láti orí títí dé ẹsẹ̀, ");
INSERT INTO yor_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","àlùfáà yóò yẹ̀ ẹ́ wò, bí ààrùn náà bá ti ran gbogbo awọ ara rẹ̀, kí àlùfáà sọ pé ó di mímọ́, torí pé gbogbo ara ẹni náà ti di funfun, ó ti mọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ṣùgbọ́n bí ẹran-ara rẹ̀ bá tún hàn jáde, òun yóò di àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Bí àlùfáà bá ti rí ẹran-ara rẹ̀ kan kí ó pè é ni aláìmọ́. Ẹran-ara rẹ̀ di àìmọ́ torí pé ó ní ààrùn tí ń ràn. ");
INSERT INTO yor_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Bí ẹran-ara rẹ̀ bá yípadà sí funfun, kí o farahan àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kí àlùfáà yẹ̀ ẹ́ wò: bí egbò rẹ̀ bá ti di funfun kí àlùfáà pe ẹni náà ni mímọ́. Òun yóò sì di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Bí oówo bá mú ẹnikẹ́ni nínú ara rẹ̀ tí ó sì san. ");
INSERT INTO yor_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Tí ìwú funfun tàbí àmì funfun tí ó pọ́n díẹ̀ bá farahàn ní ojú ibi tí oówo náà wà: kí ẹni náà lọ sọ fún àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kí àlùfáà yẹ̀ ẹ́ wò, bí ó bá jinlẹ̀ ju awọ ara rẹ̀ lọ tí irun tirẹ̀ sì ti di funfun, kí àlùfáà pe ẹni náà ni aláìmọ́. Ààrùn ara tí ó le ràn ló yọ padà lójú oówo náà. ");
INSERT INTO yor_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Bí àlùfáà bá yẹ̀ ẹ́ wò tí kò sì sí irun funfun níbẹ̀ tí ó sì ti gbẹ, kí àlùfáà fi ẹni náà pamọ́ fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Bí ó bá ràn ká awọ ara, kí àlùfáà pe ẹni náà ní aláìmọ́. Ààrùn tí ó ń ràn ni èyí. ");
INSERT INTO yor_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ṣùgbọ́n bí ojú ibẹ̀ kò bá yàtọ̀, tí kò sì ràn kára, èyí jẹ́ àpá oówo lásán, kí àlùfáà pe ẹni náà ni mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Bí iná bá jó ẹnìkan tí àmì funfun àti pupa sì yọ jáde lójú egbò iná náà. ");
INSERT INTO yor_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Kí àlùfáà yẹ ojú ibẹ̀ wò. Bí irun ibẹ̀ bá ti di funfun tí ó sì jinlẹ̀ ju àwọ̀ ara lásán lọ, ààrùn tí ń ràn ká ti wọ ojú iná náà, kí àlùfáà pè é ní aláìmọ́. Ààrùn tí ń ràn ni ni èyí. ");
INSERT INTO yor_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ṣùgbọ́n bí àlùfáà bá yẹ̀ ẹ́ wò tí kò sí irun funfun lójú egbò náà tí kò sì jinlẹ̀ ju àwọ̀ ara lọ tí ó sì ti gbẹ, kí àlùfáà fi ẹni náà pamọ́ fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Kí àlùfáà yẹ ẹni náà wò ní ọjọ́ keje, bí ó bá ń ràn ká àwọ̀ ara, kí àlùfáà kí ó pè é ní aláìmọ́. Ààrùn ara tí ń ràn ni èyí. ");
INSERT INTO yor_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ṣùgbọ́n bí ojú iná náà kò bá yípadà tí kò sì ràn ká àwọ̀ ara. Ṣùgbọ́n tí ó gbẹ, ìwú lásán ni èyí láti ojú iná náà; kí àlùfáà pè é ní mímọ́. Ojú àpá iná lásán ni. ");
INSERT INTO yor_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Bí ọkùnrin tàbí obìnrin kan bá ní egbò lórí tàbí ní àgbọ̀n. ");
INSERT INTO yor_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Kí àlùfáà yẹ̀ ẹ́ wò bí ó bá jinlẹ̀ ju awọ ara lọ tí irun ibẹ̀ sì pọ́n fẹ́ẹ́rẹ́ tí kò sì kún; kí àlùfáà pe ẹni náà ní aláìmọ́; làpálàpá ni èyí. Ààrùn tí ń ràn ká orí tàbí àgbọ̀n ni. ");
INSERT INTO yor_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ṣùgbọ́n bí àlùfáà bá yẹ egbò yìí wò tí kò sì jinlẹ̀ ju àwọ̀ ara lọ tí kò sì sí irun dúdú kan níbẹ̀. Kí àlùfáà fi ẹni náà pamọ́ fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ní ọjọ́ keje kí àlùfáà yẹ ojú ibẹ̀ wò, bí làpálàpá náà kò bá ràn mọ́ tí kò sì sí irun pípọ́n fẹ́ẹ́rẹ́ nínú rẹ̀ tí kò sì jinlẹ̀ ju àwọ̀ ara lọ. ");
INSERT INTO yor_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Kí a fá gbogbo irun rẹ̀ ṣùgbọ́n kí ó dá ojú àpá náà sí, kí àlùfáà sì tún fi pamọ́ fún ọjọ́ méje mìíràn. ");
INSERT INTO yor_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Kí àlùfáà yẹ làpálàpá náà wò, ní ọjọ́ keje bí kò bá ràn ká gbogbo àwọ̀ ara, tí kò sì jinlẹ̀ ju inú àwọ̀ ara lọ. Kí àlùfáà pè é ní mímọ́, kí ó fọ aṣọ rẹ̀, òun yóò sì mọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ṣùgbọ́n bí làpálàpá náà bá ràn ká àwọ̀ ara rẹ̀ lẹ́yìn tí a ti fihàn pé ó ti mọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Kí àlùfáà yẹ̀ ẹ́ wò bí làpálàpá náà bá ràn ká àwọ̀ ara; kí àlùfáà má ṣe yẹ irun pupa fẹ́ẹ́rẹ́ wò mọ́. Ẹni náà ti di aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ṣùgbọ́n pẹ̀lú ìdájọ́ àlùfáà pé ẹni náà kò mọ́, tí ojú làpálàpá náà kò bá yípadà, tí irun dúdú si ti hù jáde lójú rẹ̀. Làpálàpá náà ti san. Òun sì ti di mímọ́. Kí àlùfáà fi í hàn gẹ́gẹ́ bí ẹni tí ó ti di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Bí ọkùnrin tàbí obìnrin kan bá ní ojú àpá funfun lára àwọ̀ ara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Kí àlùfáà yẹ̀ ẹ́ wò, bí ojú àpá náà bá funfun ààrùn ara tí kò léwu ni èyí tí ó farahàn lára rẹ̀, ẹni náà mọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Bí irun ẹnìkan bá rẹ̀ dànù tí ó sì párí. Ẹni náà mọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Bí irun ẹnìkan bá rẹ̀ dànù níwájú orí tí ó sì párí níwájú orí. Ẹni náà mọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ṣùgbọ́n bí ó bá ní egbò pupa fẹ́ẹ́rẹ́ ní ibi orí rẹ̀ tí ó pá, tàbí níwájú orí rẹ̀, ààrùn tí ń ràn ká iwájú orí tàbí ibi orí ni èyí. ");
INSERT INTO yor_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Kí àlùfáà yẹ̀ ẹ́ wò bí egbò tó wù níwájú orí rẹ̀ tàbí tí orí rẹ̀ bá pupa díẹ̀ tí ó dàbí ààrùn ara tí ń rànkálẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Aláàrùn ni ọkùnrin náà, kò sì mọ́, kí àlùfáà pe ẹni náà ní aláìmọ́ torí egbò tí ó wà ní orí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Kí ẹni tí ààrùn náà wà ní ara rẹ̀ wọ àkísà. Kí ó má ṣe gé irun rẹ̀, kí ó daṣọ bo ìsàlẹ̀ ojú rẹ̀ kí ó sì máa ké wí pé, ‘Aláìmọ́! Aláìmọ́!’ ");
INSERT INTO yor_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Gbogbo ìgbà tí ààrùn náà bá wà ní ara rẹ̀; aláìmọ́ ni, kí ó máa dágbé. Kí ó máa gbé lẹ́yìn ibùdó. ");
INSERT INTO yor_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Bí ààrùn ẹ̀tẹ̀ bá ba aṣọ kan jẹ́ yálà aṣọ onírun àgùntàn tàbí aṣọ funfun. ");
INSERT INTO yor_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Ìbá à ṣe títa tàbí híhun tí ó jẹ́ aṣọ funfun tàbí irun àgùntàn, bóyá àwọ̀ tàbí ohun tí a fi àwọ̀ ṣe. ");
INSERT INTO yor_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Bí ààrùn náà bá ṣe bí ọbẹdo tàbí bi pupa lára aṣọ, ìbá à ṣe awọ, ìbá à ṣe ní ti aṣọ títa, ìbá à ṣe ní ti aṣọ híhun tàbí ohun tí a fi awọ ṣe bá di aláwọ̀ ewé tàbí kí ó pupa, ààrùn ẹ̀tẹ̀ ni èyí, kí a sì fihàn àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Àlùfáà yóò yẹ ẹ̀tẹ̀ náà wò, yóò sì pa gbogbo ohun tí ẹ̀tẹ̀ náà ti ràn mọ́ fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ní ọjọ́ keje kí ó yẹ̀ ẹ́ wò bí ààrùn ẹ̀tẹ̀ náà bá ràn ká ara aṣọ tàbí irun àgùntàn, aṣọ híhun tàbí awọ, bí ó ti wù kí ó wúlò tó, ẹ̀tẹ̀ apanirun ni èyí jẹ́, irú ohun bẹ́ẹ̀ kò mọ́. ");
INSERT INTO yor_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ó gbọdọ̀ sun aṣọ náà tàbí irun àgùntàn náà, aṣọ híhun náà tàbí awọ náà ti ó ni ààrùn kan lára rẹ̀ ni iná torí pé ààrùn ẹ̀tẹ̀ tí í pa ni run ni. Gbogbo nǹkan náà ni ẹ gbọdọ̀ sun ní iná. ");
INSERT INTO yor_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Ṣùgbọ́n bí àlùfáà bá yẹ̀ ẹ́ wò tí ẹ̀tẹ̀ náà kò ràn ká ara aṣọ náà yálà aṣọ títa, aṣọ híhun tàbí aláwọ. ");
INSERT INTO yor_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Kí ó pàṣẹ pé kí wọ́n fọ ohunkóhun tí ó bàjẹ́ náà kí ó sì wà ní ìpamọ́ fún ọjọ́ méje mìíràn. ");
INSERT INTO yor_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Lẹ́yìn tí ẹ bá ti fọ ohun tí ẹ̀tẹ̀ náà mú tan, kí àlùfáà yẹ̀ ẹ́ wò, bí ẹ̀tẹ̀ náà kò bá yí àwọn aṣọ náà padà, bí kò tilẹ̀ tí ì ràn, àìmọ́ ni ó jẹ́. Ẹ fi iná sun un, yálà ẹ̀gbẹ́ kan tàbí òmíràn ni ẹ̀tẹ̀ náà dé. ");
INSERT INTO yor_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Bí àlùfáà bá yẹ̀ ẹ́ wò ti ẹ̀tẹ̀ náà bá ti kúrò níbẹ̀, lẹ́yìn tí a ti fọ ohunkóhun tí ó mú, kí ó ya ibi tí ó bàjẹ́ kúrò lára aṣọ náà, awọ náà, aṣọ híhun náà tàbí aṣọ títa náà. ");
INSERT INTO yor_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ṣùgbọ́n bí ó bá tún ń farahàn níbi aṣọ náà, lára aṣọ títa náà, lára aṣọ híhun náà tàbí lára ohun èlò awọ náà, èyí fihàn pé ó ń ràn ká. Gbogbo ohun tí ẹ̀tẹ̀ náà bá wà lára rẹ̀ ni kí ẹ fi iná sun. ");
INSERT INTO yor_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Aṣọ náà, aṣọ títa náà, aṣọ híhun náà tàbí ohun èlò awọ náà tí a ti fọ̀ tí ó sì mọ́ lọ́wọ́ ẹ̀tẹ̀ náà ni kí a tún fọ̀ lẹ́ẹ̀kan sí i. Yóò sì di mímọ́.” ");
INSERT INTO yor_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Èyí ni òfin ààrùn, nínú aṣọ bubusu, ti aṣọ ọ̀gbọ̀, ti aṣọ títa, ti aṣọ híhun tàbí ti ohun èlò awọ, láti fihàn bóyá wọ́n wà ní mímọ́ tàbí àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Èyí ni àwọn ìlànà fún ẹni tí ààrùn ẹ̀tẹ̀ bá mú ní àkókò ìwẹ̀nùmọ́ rẹ̀, bí a bá mú un tọ àlùfáà wá. ");
INSERT INTO yor_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Kí àlùfáà yẹ̀ ẹ́ wò ní ẹ̀yìn ibùdó bí ara rẹ̀ bá ti yá kúrò nínú ààrùn ẹ̀tẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Kí àlùfáà pàṣẹ pé kí a mú ààyè ẹyẹ mímọ́ méjì, igi kedari, òdòdó àti ẹ̀ka hísópù wá fún ẹni tí a fẹ́ wẹ̀mọ́. ");
INSERT INTO yor_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Kí àlùfáà pàṣẹ pé kí wọn pa ọ̀kan nínú àwọn ẹyẹ náà sórí omi tí ó mọ́ tó wà nínú ìkòkò amọ̀. ");
INSERT INTO yor_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Lẹ́yìn náà kí ó ri ààyè ẹyẹ pẹ̀lú igi kedari, òdòdó àti ẹ̀ka hísópù bọ inú ẹ̀jẹ̀ ẹyẹ tí a ti pa sínú omi náà. ");
INSERT INTO yor_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ìgbà méje ni kí o wọ́n omi yìí sí ara ẹni tí a fẹ́ wẹ̀mọ́ kúrò nínú ààrùn ara náà kí ó ju ààyè ẹyẹ náà sílẹ̀ ní ìta gbangba. ");
INSERT INTO yor_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Ẹni tí a fẹ́ wẹ̀mọ́ náà gbọdọ̀ fọ aṣọ rẹ̀, fá gbogbo irun rẹ̀, kí ó sì wẹ̀, lẹ́yìn èyí ó ti di mímọ́. Lẹ́yìn náà ó le wá sínú ibùdó ṣùgbọ́n kí ó wà lẹ́yìn àgọ́ rẹ̀ ní ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Kí ó fá gbogbo irun rẹ̀ ní ọjọ́ keje: irun orí rẹ̀, irùngbọ̀n rẹ̀, irun ìpéǹpéjú rẹ̀, àti gbogbo irun rẹ̀ tókù. Kí ó fọ aṣọ rẹ̀, kí ó sì wẹ̀, yóò sì mọ́. ");
INSERT INTO yor_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Ní ọjọ́ kẹjọ kí ó mú àgbò aláìlábùkù méjì àti abo ọ̀dọ́-àgùntàn ọlọ́dún kan tí wọn kò ní àlébù wá, pẹ̀lú ìdámẹ́wàá nínú mẹ́wàá òsùwọ̀n ìyẹ̀fun tí à pòpọ̀ mọ́ òróró fún ọrẹ ohun jíjẹ àti òsùwọ̀n lógù òróró kan. ");
INSERT INTO yor_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Àlùfáà tí ó pè é ní mímọ́, yóò mú ẹni náà tí a ó sọ di mímọ́ àti ọrẹ rẹ̀ wá síwájú Olúwa ní ẹnu-ọ̀nà àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Kí àlùfáà mú ọ̀kan nínú àwọn àgbò àti lógù òróró kí ó sì fi rú ẹbọ ẹ̀bi. Kí ó sì fì wọ́n níwájú Olúwa gẹ́gẹ́ bí ẹbọ fífì. ");
INSERT INTO yor_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Kí ó pa àgbò náà ní ibi mímọ́ níbi tí wọ́n ti ń pa ẹran ẹbọ ẹ̀ṣẹ̀ àti ọrẹ ẹbọ sísun. Bí ẹbọ ẹ̀ṣẹ̀, ẹbọ ẹ̀bi náà jẹ́ ti àlùfáà: ó jẹ́ mímọ́ jùlọ. ");
INSERT INTO yor_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kí àlùfáà mú nínú ẹ̀jẹ̀ ẹbọ ẹ̀bi náà kí ó fi sí etí ọ̀tún ẹni náà tí a ó wẹ̀mọ́, kí ó tún fi sí àtàǹpàkò ọwọ́ ọ̀tún rẹ̀ àti orí àtàǹpàkò ẹsẹ̀ ọ̀tún rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Àlùfáà yóò sì mú díẹ̀ nínú lógù òróró, yóò sì dà á sí àtẹ́lẹwọ́ òsì ara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Yóò sì ti ìka ìfábẹ̀lá ọ̀tún rẹ̀ bọ inú òróró àtẹ́lẹwọ́ rẹ̀, yóò sì wọ́n díẹ̀ nínú rẹ̀ níwájú Olúwa nígbà méje. ");
INSERT INTO yor_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Àlùfáà yóò mú lára òróró tí ó kù ní àtẹ́lẹwọ́ rẹ̀ yóò fi sí etí ọ̀tún, àtàǹpàkò ọwọ́ ọ̀tún àti àtàǹpàkò ẹsẹ̀ ọ̀tún ẹni tí à ó wẹ̀mọ́, lórí ẹ̀jẹ̀ ẹbọ ẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Àlùfáà yóò fi òróró tí ó kù ní àtẹ́lẹwọ́ rẹ̀ ra orí ẹni tí a ó wẹ̀mọ́, yóò sì ṣe ètùtù fún un níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Àlùfáà yóò sì rú ẹbọ ẹ̀ṣẹ̀, yóò ṣe ètùtù fún ẹni tí a ó wẹ̀ kúrò nínú àìmọ́ rẹ̀, lẹ́yìn náà àlùfáà yóò pa ẹran ọrẹ ẹbọ sísun. ");
INSERT INTO yor_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Kí àlùfáà kí ó sì rú ẹbọ sísun, àti ẹbọ ohun jíjẹ lórí pẹpẹ, kí àlùfáà kí ó sì ṣe ètùtù fún un, òun yóò sì di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Bí ẹni náà bá jẹ́ tálákà tí kò sì le è kó gbogbo nǹkan wọ̀nyí wá, kí ó mú ọ̀dọ́ àgbò kan bí ẹbọ ẹ̀bi, tí yóò fì, láti ṣe ètùtù fún un, pẹ̀lú ìdámẹ́wàá òsùwọ̀n ìyẹ̀fun dídára, a pò mọ́ òróró fún ọrẹ ohun jíjẹ òsùwọ̀n lógù òróró ");
INSERT INTO yor_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","àti àdàbà méjì tàbí ẹyẹlé méjì èyí tí agbára rẹ̀ ká, ọ̀kan fún ẹbọ ẹ̀ṣẹ̀ àti èkejì fún ẹbọ sísun. ");
INSERT INTO yor_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Kí ó mú wọn wá ní ọjọ́ kẹjọ fún ìwẹ̀nùmọ́ rẹ̀ síwájú àlùfáà ní ẹnu-ọ̀nà àgọ́ ìpàdé níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Àlùfáà náà yóò sì mú ọ̀dọ́-àgùntàn ẹbọ ẹ̀bi pẹ̀lú lógù òróró yóò sì fì wọ́n níwájú Olúwa bí ẹbọ fífì. ");
INSERT INTO yor_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Kí ó pa ọ̀dọ́-àgùntàn ẹbọ ẹ̀bi kí ó sì mú lára ẹ̀jẹ̀ rẹ̀. Kí ó fi sí etí ọ̀tún, àtàǹpàkò ọwọ́ ọ̀tún àti àtàǹpàkò ẹsẹ̀ ọ̀tún ẹni tí a ó ṣe ìwẹ̀nùmọ́ fún. ");
INSERT INTO yor_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Àlùfáà yóò sì da díẹ̀ lára òróró náà sí àtẹ́lẹwọ́ òsì ara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Yóò sì fi ìka ìfábẹ̀lá ọ̀tún rẹ̀ wọ́n òróró tí ó wà ní àtẹ́lẹwọ́ òsì rẹ̀ nígbà méje níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Àlùfáà yóò sì mú lára òróró ọwọ́ rẹ̀ sí etí ọ̀tún, àtàǹpàkò ọwọ́ ọ̀tún àti àtàǹpàkò ẹsẹ̀ ọ̀tún ẹni tí a ń ṣe ìwẹ̀nùmọ́ fún ní ibi kan náà tí wọ́n ta ẹ̀jẹ̀ ẹbọ ẹ̀bi sí. ");
INSERT INTO yor_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Kí àlùfáà fi ìyókù nínú òróró ọwọ́ rẹ̀ sí orí ẹni náà tí a ń ṣe ìwẹ̀nùmọ́ fún, láti ṣe ètùtù fún un ní iwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Lẹ́yìn náà kí ó fi àdàbà tàbí ọmọ ẹyẹlé rú ẹbọ níwọ̀n tí agbára rẹ̀ mọ. ");
INSERT INTO yor_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Ọ̀kan fún ẹbọ ẹ̀ṣẹ̀ àti èkejì fún ẹbọ sísun pẹ̀lú ẹbọ ohun jíjẹ, àlùfáà yóò sì ṣe ètùtù níwájú Olúwa ní ipò ẹni tí a fẹ́ wẹ̀mọ́.” ");
INSERT INTO yor_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Òfin nìyí fún ẹnikẹ́ni tí ó bá ní ààrùn ara tí ó le ran tí kò sì lágbára láti rú ẹbọ tí ó yẹ fún ìwẹ̀nùmọ́ bí a ti fi lélẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Olúwa sọ fún Mose àti Aaroni pé. ");
INSERT INTO yor_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Nígbà tí ẹ bá dé ilẹ̀ Kenaani tí mo fi fún yín ní ìní, tí mo sì fi ààrùn ẹ̀tẹ̀ sínú ilé kan ní ilẹ̀ ìní yín. ");
INSERT INTO yor_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Kí ẹni tí ó ní ilé náà lọ sọ fún àlùfáà pé, ‘Èmi tí rí ohun tí ó jọ ààrùn ẹ̀tẹ̀ ní ilé mi.’ ");
INSERT INTO yor_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Àlùfáà yóò pàṣẹ kí ẹnikẹ́ni tàbí ohunkóhun má ṣe wà nínú ilé náà, kí ó tó lọ yẹ ẹ̀tẹ̀ náà wò, kí ohunkóhun nínú ilé náà má bá à di àìmọ́. Lẹ́yìn èyí àlùfáà yóò wọlé lọ láti yẹ ilé náà wò. ");
INSERT INTO yor_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Yóò yẹ ààrùn náà wò, bí ààrùn náà bá ti wà lára ògiri ilé náà nípa àmì àwọ̀ ewé tàbí àmì pupa tí ó sì jinlẹ̀, ju ara ògiri lọ. ");
INSERT INTO yor_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Àlùfáà yóò jáde kúrò nínú ilé náà, yóò sì ti ìlẹ̀kùn ilé náà pa fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Àlùfáà yóò padà wá yẹ ilé náà wò ní ọjọ́ keje. Bí ààrùn náà bá ti tàn ká ara ògiri. ");
INSERT INTO yor_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Àlùfáà yóò pàṣẹ kí a yọ àwọn òkúta tí ààrùn náà ti bàjẹ́ kúrò kí a sì kó wọn dànù sí ibi tí a kà sí àìmọ́ lẹ́yìn ìlú. ");
INSERT INTO yor_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Yóò sì mú kí wọ́n ha ògiri inú ilé náà yíká. Gbogbo ohun tí wọ́n fi rẹ́ ilé náà tí ó ti ha ni kí wọ́n kó dànù sí ibi tí a kà sí àìmọ́ lẹ́yìn ìlú náà. ");
INSERT INTO yor_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Òkúta mìíràn ni kí wọ́n fi dípò àwọn tí a ti yọ dànù, kí wọ́n sì rẹ́ ilé náà pẹ̀lú àwọn ohun ìrẹ́lé tuntun. ");
INSERT INTO yor_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Bí ààrùn yìí bá tún farahàn lẹ́yìn tí a ti yọ àwọn òkúta wọ̀nyí tí a sì ti ha ilé náà ti a sì tún rẹ́ ẹ. ");
INSERT INTO yor_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Àlùfáà yóò tún lọ yẹ̀ ẹ́ wò bí ààrùn náà bá tún gbilẹ̀ sí i nínú ilé náà: ẹ̀tẹ̀ apanirun ni èyí, ilé náà jẹ́ aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Wíwó ni kí a wó o, gbogbo òkúta ilé náà, àwọn igi àti gbogbo ohun tí a fi rẹ́ ẹ ni kí a kó jáde nínú ìlú sí ibi tí a kà sí àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Ẹni tí ó bá wọ inú ilé náà lẹ́yìn tí a ti tì í, yóò di aláìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ẹni tí ó bá sùn nínú ilé náà tàbí tí ó bá jẹun nínú rẹ̀ gbọdọ̀ fọ aṣọ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Bí àlùfáà bá wá yẹ̀ ẹ́ wò tí ààrùn náà kò gbilẹ̀ mọ́ lẹ́yìn tí a ti rẹ́ ilé náà: kí àlùfáà pe ilé náà ní mímọ́, torí pé ààrùn náà ti lọ. ");
INSERT INTO yor_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Láti sọ ilé yìí di mímọ́. Àlùfáà yóò mú ẹyẹ méjì àti igi kedari òdòdó àti hísópù. ");
INSERT INTO yor_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Yóò sì pa ọ̀kan nínú àwọn ẹyẹ náà sórí omi tí ó mọ́ nínú ìkòkò amọ̀. ");
INSERT INTO yor_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Kí ó ri igi kedari, hísópù, òdòdó àti ààyè ẹyẹ náà bọ inú ẹ̀jẹ̀ òkú ẹyẹ àti omi tí ó mọ́ náà kí ó fi wọ́n ilẹ̀ náà lẹ́ẹ̀méje. ");
INSERT INTO yor_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Yóò fi ẹ̀jẹ̀ ẹyẹ náà, omi tí ó mọ́, ààyè ẹyẹ, igi kedari, hísópù àti òdòdó sọ ilé náà di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kí àlùfáà ju ààyè ẹyẹ náà sílẹ̀ lẹ́yìn ìlú. Báyìí ni yóò ṣe ètùtù fún ilé náà. Ilé náà yóò sì mọ́.” ");
INSERT INTO yor_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Àwọn wọ̀nyí ni ìlànà fún èyíkéyìí ààrùn àwọ̀ ara tí ó le è ràn ká, fún làpálàpá, ");
INSERT INTO yor_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","àti fún ẹ̀tẹ̀ nínú aṣọ, àti ti ilé, ");
INSERT INTO yor_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","fún ara wíwú, fún èélá àti ibi ara tí ó ń dán yàtọ̀. ");
INSERT INTO yor_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Láti mú kí a mọ̀ bóyá nǹkan mọ́ tàbí kò mọ́. Ìwọ̀nyí ni àwọn òfin fún ààrùn àwọ̀ ara tí ó ń ràn ká àti ẹ̀tẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Olúwa sọ fún Mose àti Aaroni pé, ");
INSERT INTO yor_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Ẹ bá àwọn ọmọ Israẹli sọ̀rọ̀, kí ẹ wí fún wọn pé, ‘Bí ìsunjáde bá ń jáde lára ọkùnrin kan lójú ara, ìsunjáde náà jẹ́ àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Yálà ó ń jáde léraléra tàbí ó dúró, èyí yóò sọ ọ́ di aláìmọ́. Báyìí ni ìsunjáde rẹ̀ ṣe le è sọ ọ́ di aláìmọ́: ");
INSERT INTO yor_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Gbogbo ibùsùn tí irú ẹni tí ó ní ìsunjáde náà bá sùn di àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Bí ẹnikẹ́ni bá fi ara kan ibùsùn rẹ̀, ó gbọdọ̀ fọ aṣọ rẹ̀ kí ó sì wẹ̀. Yóò sì wà ní ipò àìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ẹnikẹ́ni tí ó bá jókòó lórí ohunkóhun tí ọkùnrin tí ó ní ìsunjáde bá jókòó le gbọdọ̀ fọ aṣọ rẹ̀, kí ó sì wẹ̀, kí ó sì wà láìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Ẹnikẹ́ni tí ó bá fọwọ́ kan ọkùnrin náà tí ó ní ìsunjáde gbọdọ̀ fọ aṣọ rẹ̀, kí ó sì wẹ̀, yóò sì di aláìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Bí ẹni tí ó ní ìsunjáde bá tu itọ́ sí ẹni tí ó mọ́ lára, ẹni tí ó mọ́ náà gbọdọ̀ fọ aṣọ rẹ̀ kí ó sì wẹ̀, yóò sì wà ní ipò àìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Gàárì ẹranko tí ẹni náà bá gùn yóò di àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Ẹnikẹ́ni tí ó bá fọwọ́ kan ohunkóhun tí ó wà lábẹ́ ọkùnrin náà di aláìmọ́ títí di ìrọ̀lẹ́. Ẹnikẹ́ni tí ó bá mú irú nǹkan bẹ́ẹ̀ gbọdọ̀ fọ aṣọ rẹ̀, kí ó wẹ ara rẹ̀. Yóò sì jẹ́ aláìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Ẹnikẹ́ni tí ọkùnrin tí ó ní ìsunjáde ní ara rẹ̀ bá fi ara kàn láìfi omi fọ ọwọ́ rẹ̀, gbọdọ̀ fọ aṣọ rẹ̀ kí ó sì wẹ̀. Yóò sì wà ní ipò àìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Ìkòkò amọ̀ tí ọkùnrin náà bá fọwọ́ kàn ni kí ẹ fọ́, gbogbo ohun èlò igi tí ó fọwọ́ kàn ni kí ẹ fi omi sàn. ");
INSERT INTO yor_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Ẹnikẹ́ni tí a bá wẹ̀nù kúrò nínú ìsunjáde rẹ̀ gbọdọ̀ ka ọjọ́ méje fún àwọn ọjọ́ ìwẹ̀nùmọ́: kí ó fọ aṣọ rẹ̀, kí ó sì fi omi wẹ ara rẹ̀, yóò sì di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ní ọjọ́ kẹjọ kí ó mú àdàbà méjì tàbí ọmọ ẹyẹlé méjì, kí ó sì wá sí ẹnu-ọ̀nà àgọ́ ìpàdé níwájú Olúwa, kí ó sì kó wọn fún àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kí àlùfáà fi wọ́n rú ẹbọ: ọ̀kan fún ọrẹ ẹ̀ṣẹ̀ àti èkejì fún ọrẹ ẹbọ sísun níwájú Olúwa ní ipò ọkùnrin náà nítorí ìsunjáde rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Bí nǹkan ọkùnrin kan bá tú jáde, kí ó wẹ gbogbo ara rẹ̀, kí ó wà ní ipò àìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Yálà àwọ̀ tàbí aṣọ tí nǹkan ọkùnrin bá dà sí lórí ni kí ẹ fọ̀, yóò sì wà ní ipò àìmọ́ di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Bí ọkùnrin kan bá bá obìnrin lòpọ̀ tí nǹkan ọkùnrin sì tú jáde lára rẹ̀. Àwọn méjèèjì gbọdọ̀ fi omi wẹ̀, kí wọ́n sì wà ní ipò àìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Bí obìnrin bá ń ṣe nǹkan oṣù rẹ̀, obìnrin yìí wà ní àìmọ́ títí di ọjọ́ méje. Ẹnikẹ́ni tí ó bá fọwọ́ kàn án yóò wà ní ipò àìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Gbogbo ohun tí ó bá sùn lé ní àkókò nǹkan oṣù rẹ̀ di àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ẹnikẹ́ni tí ó bá fọwọ́ kan ibùsùn rẹ̀ gbọdọ̀ fọ aṣọ rẹ̀ kí ó sì wẹ̀, yóò sì wà ní ipò àìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ẹnikẹ́ni tí ó bá fọwọ́ kan ohunkóhun tí ó bá jókòó lé gbọdọ̀ fọ aṣọ rẹ̀, kí ó sì wẹ̀, yóò sì wà ní ipò àìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ìbá à ṣe ibùsùn tàbí ohunkóhun tí ó jókòó lé. Ẹnikẹ́ni tí ó bá fọwọ́ kàn án yóò jẹ́ aláìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Bí ọkùnrin kan bá bá a lòpọ̀, tí nǹkan oṣù rẹ̀ sì kàn án lára, yóò jẹ́ aláìmọ́ fún ọjọ́ méje, gbogbo ibùsùn tí ọkùnrin náà bá sùn yóò jẹ́ aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Bí obìnrin bá ní ìsun ẹ̀jẹ̀ fún ọjọ́ púpọ̀ yálà sí àkókò nǹkan oṣù rẹ̀ tàbí tí nǹkan oṣù rẹ̀ bá kọjá ìgbà tí ó yẹ. Gbogbo ìgbà tí ó bá fi ń ní ìsun ẹ̀jẹ̀ náà ni yóò fi wà ní àìmọ́ gẹ́gẹ́ bí àkókò nǹkan oṣù rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ibùsùn tí ó wù kí ó sùn sí ní gbogbo ìgbà tí ẹ̀jẹ̀ náà ń wá yóò jẹ́ àìmọ́ bí ibùsùn rẹ̀ ṣe jẹ́ ní àkókò nǹkan oṣù rẹ̀. Gbogbo ohun tí ó bá jókòó lé yóò wà ní àìmọ́, gẹ́gẹ́ bí àkókò nǹkan oṣù rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ẹnikẹ́ni tí ó bá fọwọ́ kàn wọ́n yóò wà ní àìmọ́. Ó gbọdọ̀ fọ aṣọ rẹ̀, kí ó sì wẹ̀ kí ó sì wà ní àìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Nígbà tí ó bá di mímọ́ kúrò nínú ìsun rẹ̀, kí ó ka ọjọ́ méje lẹ́yìn náà, a ó kà á sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ní ọjọ́ kẹjọ kí ó mú àdàbà méjì àti ọmọ ẹyẹlé wá síwájú àlùfáà ní ẹnu-ọ̀nà àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kí àlùfáà fi ọ̀kan rú ẹbọ ẹ̀ṣẹ̀ àti èkejì fún ẹbọ sísun. Báyìí ni yóò ṣe ètùtù fún un, níwájú Olúwa fún àìmọ́ ìsun ẹ̀jẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Ẹ ya ará Israẹli sọ́tọ̀ kúrò nínú ohun tí ó ń sọ wọ́n di aláìmọ́, kí wọ́n má bá a kú nínú àìmọ́ wọn nípa bíba ibùgbé mímọ́ mi jẹ́, èyí tí ó wà láàrín wọn.’ ” ");
INSERT INTO yor_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ìwọ̀nyí ni àwọn òfin fún ọkùnrin tí ó ni ìsunjáde fún ẹnikẹ́ni tí a sọ di àìmọ́ nípa ìsunjáde nǹkan ọkùnrin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Fún obìnrin ní nǹkan oṣù rẹ̀, fún ọkùnrin tàbí obìnrin tí ó ní ìsunjáde, àti fún ọkùnrin tí ó ní ìbálòpọ̀ pẹ̀lú obìnrin tí ó jẹ́ aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Olúwa sọ fún Mose lẹ́yìn ikú àwọn ọmọ Aaroni méjèèjì tí wọ́n kú nígbà tí wọ́n súnmọ́ Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Olúwa sì sọ fún Mose pé, “Kìlọ̀ fún Aaroni arákùnrin rẹ pé kí ó má ṣe máa wá nígbà gbogbo sí Ibi Mímọ́ Jùlọ tí ó wà lẹ́yìn aṣọ títa ní ibi tí àpótí ẹ̀rí àti ìtẹ́ àánú wà, kí ó má ba à kú nítorí pé Èmi ó farahàn nínú ìkùùkuu lórí ìtẹ́ àánú. ");
INSERT INTO yor_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Báyìí ni Aaroni yóò ṣe máa wá sí Ibi Mímọ́ Jùlọ pẹ̀lú ọ̀dọ́ akọ màlúù fún ẹbọ ẹ̀ṣẹ̀ àti àgbò fún ẹbọ sísun. ");
INSERT INTO yor_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Òun yóò sì wọ aṣọ funfun mímọ́ pẹ̀lú àwọ̀tẹ́lẹ̀ funfun, yóò sì fi àmùrè funfun mímọ́ dì í, yóò sì dé fìlà funfun, àwọn aṣọ mímọ́ nìwọ̀nyí. Òun yóò sì fi omi wẹ̀, kí ó tó wọ̀ wọ́n. ");
INSERT INTO yor_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Òun yóò sì mú ọmọ ewúrẹ́ méjì láti ọ̀dọ̀ gbogbo àgbájọpọ̀ àwọn ọmọ Israẹli láti fi ṣe ẹbọ ẹ̀ṣẹ̀ wọ́n, àti àgbò kan fún ẹbọ sísun. ");
INSERT INTO yor_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aaroni yóò sì fi akọ màlúù rú ẹbọ ẹ̀ṣẹ̀ èyí tí ṣe ti ara rẹ̀ òun yóò sì ṣe ètùtù fún ara rẹ̀ àti ìdílé rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Lẹ́yìn náà yóò sì mú ewúrẹ́ méjì náà wá sí iwájú Olúwa ní ibi ìlẹ̀kùn àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaroni yóò sì dìbò ní ti àwọn ewúrẹ́ méjèèjì náà, ìbò àkọ́kọ́ fún ti Olúwa, àti èkejì fún ewúrẹ́ ìpààrọ̀. ");
INSERT INTO yor_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaroni yóò sì mú ewúrẹ́ tí ìbò Olúwa mú, yóò sì fi rú ẹbọ ẹ̀ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ṣùgbọ́n ewúrẹ́ tí ìbò bá mú gẹ́gẹ́ bí ewúrẹ́ ìpààrọ̀ ni a ó mú wá láààyè síwájú Olúwa láti fi ṣe ètùtù sí i àti láti jẹ́ kí ó lọ lọ́fẹ̀ẹ́, sí aginjù. ");
INSERT INTO yor_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aaroni yóò sì mú akọ màlúù fún ẹbọ ẹ̀ṣẹ̀ wá láti ṣe ètùtù fún ara rẹ̀ àti ìdílé rẹ̀. Yóò sì pa akọ màlúù náà fún ẹbọ ẹ̀ṣẹ̀ tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Yóò sì mú àwo tùràrí tí ó kún fún èédú tí a ti sun pẹ̀lú iná láti orí pẹpẹ wá síwájú Olúwa: àti ẹ̀kúnwọ́ méjì tùràrí tí a gún kúnná yóò sì mú un wá sí ẹ̀yìn aṣọ títa. ");
INSERT INTO yor_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Yóò sì fi tùràrí náà lé orí iná níwájú Olúwa: kí èéfín tùràrí náà ba à le bo ìtẹ́ àánú tí ó wà ní orí àpótí ẹ̀rí kí o má ba à kú. ");
INSERT INTO yor_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Yóò sì mú nínú ẹ̀jẹ̀ ọmọ màlúù náà yóò sì fi ìka rẹ̀ wọ́n ọn, ní iwájú ìtẹ́ àánú, yóò sì fi ìka rẹ̀ wọ́n ọn nígbà méje níwájú ìtẹ́ àánú. ");
INSERT INTO yor_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Nígbà yìí ni yóò pa ewúrẹ́ ẹbọ ẹ̀ṣẹ̀ tí ó wà fún àwọn ènìyàn yóò sì mú ẹ̀jẹ̀ rẹ̀ wá sí ẹ̀yìn aṣọ títa, bí ó ti ṣe ẹ̀jẹ̀ akọ màlúù náà ni yóò ṣe ti ewúrẹ́ yìí, yóò sì wọ́n ọn sórí ìtẹ́ ètùtù àti síwájú ìtẹ́ ètùtù. ");
INSERT INTO yor_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Báyìí ni yóò ṣe ètùtù fún Ibi Mímọ́ Jùlọ nítorí àìmọ́ àwọn ará Israẹli àti nítorí gbogbo ìrékọjá wọn àti ìṣọ̀tẹ̀ wọn nípa ẹ̀ṣẹ̀ wọn gbogbo, bákan náà ni yóò sì ṣe fún àgọ́ ìpàdé, èyí tí ó wà láàrín wọn nínú àìmọ́ wọn. ");
INSERT INTO yor_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kí ó má ṣe sí ẹyọ ènìyàn kan nínú àgọ́ ìpàdé nígbà tí òun bá wọ Ibi Mímọ́ Jùlọ lọ láti ṣe ètùtù, títí di ìgbà tí yóò fi jáde lẹ́yìn tí ó ba ṣe ètùtù fúnra rẹ̀ fún ìdílé rẹ̀ àti fún gbogbo àgbájọpọ̀ Israẹli. ");
INSERT INTO yor_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Lẹ́yìn náà òun yóò lọ sí ibi pẹpẹ tí ó wà níwájú Olúwa, yóò sì ṣe ètùtù fún pẹpẹ náà. Yóò sì mú nínú ẹ̀jẹ̀ akọ màlúù àti nínú ẹ̀jẹ̀ ewúrẹ́ náà, yóò sì fi sí orí ọ̀kọ̀ọ̀kan ìwo pẹpẹ náà yíká. ");
INSERT INTO yor_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Lẹ́yìn náà, òun yóò wọ́n ẹ̀jẹ̀ náà sórí rẹ̀ pẹ̀lú ìka rẹ̀ nígbà méje láti wẹ̀ ẹ́ mọ́ àti láti sọ ọ́ dí mímọ́ kúrò nínú àìmọ́ àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Lẹ́yìn ti Aaroni ti parí ṣíṣe ètùtù ti Ibi Mímọ́ Jùlọ, ti àgọ́ ìpàdé àti ti pẹpẹ, òun yóò sì mú ààyè ewúrẹ́ wá. ");
INSERT INTO yor_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaroni yóò sì gbé ọwọ́ rẹ̀ méjèèjì lé orí ààyè ewúrẹ́ náà, yóò sì jẹ́wọ́ gbogbo ìwà búburú àti ìṣọ̀tẹ̀ àwọn ara Israẹli lé e lórí. Gbogbo ìrékọjá wọn àti ẹ̀ṣẹ̀ wọn ni yóò sì gbé ka orí ewúrẹ́ náà. Yóò sì rán an lọ sí ijù láti ọwọ́ ẹni tí a yàn fún iṣẹ́ náà. ");
INSERT INTO yor_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ewúrẹ́ náà yóò sì ru gbogbo àìṣedéédéé wọn lọ sí ilẹ̀ tí ènìyàn kò gbé. Òun yóò sì jọ̀wọ́ ewúrẹ́ náà lọ́wọ́ lọ sínú ijù. ");
INSERT INTO yor_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Aaroni yóò sì padà wá sí ibi àgọ́ ìpàdé, yóò sì bọ́ aṣọ ọ̀gbọ̀ wọ̀n-ọn-nì sílẹ̀, tí ó wọ̀ nígbà tí ó lọ sí Ibi Mímọ́ Jùlọ, yóò sì fi wọ́n sílẹ̀ níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Yóò sì fi omi wẹ ara rẹ̀ ní ibi mímọ́ kan, yóò sì wọ aṣọ rẹ̀ yóò sì wá ṣí iwájú, yóò sì rú ẹbọ sísun ti ara rẹ̀ àti ẹbọ sísun ti àwọn ènìyàn láti ṣe ètùtù fún ara rẹ̀ àti fún àwọn ènìyàn. ");
INSERT INTO yor_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Òun yóò sì sun ọrẹ ẹbọ ẹ̀ṣẹ̀ náà lórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Ẹni tí ó tú ewúrẹ́ ìpààrọ̀ náà sílẹ̀ yóò sì fọ aṣọ rẹ̀, yóò sì wẹ ara rẹ̀ nínú omi, lẹ́yìn èyí ó lè wá sí ibùdó. ");
INSERT INTO yor_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ọ̀dọ́ akọ màlúù àti ewúrẹ́ ẹbọ ẹ̀ṣẹ̀ tí a ti mú ẹ̀jẹ̀ wọn wá sí Ibi Mímọ́ Jùlọ ni kí a gbe jáde kúrò ní ibùdó. Awọ wọn ni a ó fi iná sun bákan náà. ");
INSERT INTO yor_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ẹni tí ó sun wọ́n yóò sì fọ aṣọ rẹ̀, yóò sì wẹ ara rẹ̀, lẹ́yìn èyí ni ó tó le wọ ibùdó. ");
INSERT INTO yor_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Èyí ni yóò jẹ́ ìlànà títí láé fún un yín, pé ní ọjọ́ kẹwàá oṣù keje ni ẹ gbọdọ̀ ṣẹ́ ara yín, kí ẹ má ṣe ṣe iṣẹ́ kankan, yálà onílé tàbí àlejò tí ó ń gbé pẹ̀lú yín. ");
INSERT INTO yor_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Torí pé ní ọjọ́ yìí ni àlùfáà yóò ṣe ètùtù fún yín láti sọ yín di mímọ́, kí ẹ̀yin bá à le mọ́ níwájú Olúwa yín kúrò nínú ẹ̀ṣẹ̀ yín gbogbo. ");
INSERT INTO yor_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ọjọ́ yìí yóò jẹ́ ọjọ́ ìsinmi pátápátá fún un yín, ẹ̀yin yóò sì ṣẹ́ ara yín. Èyí yóò sì jẹ́ ìlànà títí láé. ");
INSERT INTO yor_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Àlùfáà náà tí a ti fi òróró yàn tí a sì ti sọ di mímọ́ láti máa ṣe iṣẹ́ ìránṣẹ́ ní ilé ìsìn ní ipò baba rẹ̀, òun ni kí ó ṣe ètùtù, yóò sì wọ aṣọ funfun gbòò àní aṣọ mímọ́ náà, òun yóò sì ṣe ètùtù. ");
INSERT INTO yor_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Yóò sì ṣe ètùtù fún Ibi Mímọ́ Jùlọ, fún ìpàdé àti fún pẹpẹ, yóò sì ṣe ètùtù fún àlùfáà àti fún gbogbo àgbájọpọ̀ àwọn ènìyàn náà. ");
INSERT INTO yor_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Èyí ni yóò jẹ́ ìlànà ayérayé fún yín: láti máa ṣe ètùtù fún àwọn ará Israẹli fún gbogbo ẹ̀ṣẹ̀ wọn lẹ́ẹ̀kan lọ́dún.” Ó sì ṣe gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Sọ fún Aaroni àti àwọn ọmọ rẹ̀ pẹ̀lú gbogbo àwọn ọmọ Israẹli: ‘Ohun tí Olúwa pàṣẹ nìyí, ");
INSERT INTO yor_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","bí ẹnikẹ́ni nínú ìdílé Israẹli bá pa màlúù tàbí ọ̀dọ́-àgùntàn tàbí àgbò nínú ibùdó tàbí bí ó bá pa á lẹ́yìn ibùdó ");
INSERT INTO yor_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","tí kò sì mú un wá sí ibi àgọ́ ìpàdé láti fi rú ẹbọ sí Olúwa níwájú àgọ́ ìpàdé, ẹ̀bi ìtàjẹ̀ sílẹ̀ ni kí ẹ kà sí ẹni náà lọ́rùn: torí pé ó ti ta ẹ̀jẹ̀ sílẹ̀, ẹni náà ni a ó sì gé kúrò láàrín àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Èyí rí bẹ́ẹ̀ kí àwọn ọmọ Israẹli le è máa mú ẹbọ wọn tí wọn ti rú ní ìta gbangba wá sí iwájú Olúwa: wọ́n gbọdọ̀ mú un wá síwájú àlùfáà àní sí Olúwa ní ẹnu-ọ̀nà àgọ́ ìpàdé, kí wọ́n sì rú wọn gẹ́gẹ́ bí ẹbọ àlàáfíà sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Àlùfáà náà yóò sì fi ẹ̀jẹ̀ náà wọ́n ibi pẹpẹ Olúwa ní ẹnu-ọ̀nà àgọ́ ìpàdé, yóò sì sun ọ̀rá rẹ̀ ní òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Nítorí náà, kí wọn má ṣe rú ẹbọ wọn sí ère ẹranko mọ́, nínú èyí tí wọ́n ti ṣe àgbèrè tọ̀ lọ. Èyí yóò sì jẹ́ ìlànà títí láé láti ìran dé ìran wọn tí ń bọ̀.’ ");
INSERT INTO yor_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Kí ó sọ fún wọn pé, ‘Ọkùnrin yówù kí ó jẹ́ ní ìdílé Israẹli tàbí ti àwọn àlejò tí ń gbé láàrín wọn tí ó bá rú ẹbọ sísun tàbí ṣe ẹbọ ");
INSERT INTO yor_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","tí kò sì mú un wá sí ẹnu-ọ̀nà àgọ́ ìpàdé láti fi rú ẹbọ sí Olúwa irú ẹni bẹ́ẹ̀ ni a ó gé kúrò láàrín àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Bí ẹnikẹ́ni bá jẹ ẹ̀jẹ̀ yálà nínú ìdílé Israẹli tàbí àwọn àlejò tí ń gbé láàrín wọn, Èmi yóò bínú sí irú ẹni náà tí ó jẹ ẹ̀jẹ̀, èmi yóò sì gé e kúrò láàrín àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Nítorí pé nínú ẹ̀jẹ̀ ni ẹ̀mí ẹ̀dá wà, èmi sì ti fi fún yín lórí pẹpẹ fún ètùtù ọkàn yín: nítorí pé ẹ̀jẹ̀ ni a fi ń ṣe ètùtù fún ẹ̀mí ènìyàn. ");
INSERT INTO yor_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ìdí nìyí tí mo fi sọ fún àwọn ọmọ Israẹli pé, ọ̀kankan nínú yín kò gbọdọ̀ jẹ ẹ̀jẹ̀, bẹ́ẹ̀ ni àlejò kan tí ń ṣe àtìpó nínú yín kò gbọdọ̀ jẹ ẹ̀jẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Ẹnikẹ́ni yálà nínú àwọn ọmọ Israẹli tàbí àlejò tí ń gbé láàrín wọn, tí ó bá pa ẹranko tàbí ẹyẹ tí ó yẹ fún jíjẹ gbọdọ̀ ro ẹ̀jẹ̀ rẹ̀ sílẹ̀ kí ó sì bò ó mọ́lẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Torí pé ẹ̀mí gbogbo ẹ̀dá ni ẹ̀jẹ̀ rẹ̀, torí náà ni mo fi kìlọ̀ fún àwọn ọmọ Israẹli pé wọn kò gbọdọ̀ jẹ ẹ̀jẹ̀ ohun abẹ̀mí kankan, torí pé nínú ẹ̀jẹ̀ ohun abẹ̀mí wọ̀nyí ni ẹ̀mí wọn wà, ẹnikẹ́ni tí ó bá jẹ ẹ́ ni a ó gé kúrò. ");
INSERT INTO yor_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Ẹnikẹ́ni tí ó bá jẹ ohun tí ó kú sílẹ̀ fúnra rẹ̀, tàbí èyí tí ẹranko búburú pa kálẹ̀ yálà onílé tàbí àlejò, ó ní láti fọ aṣọ rẹ̀. Kí ó sì fi omi wẹ ara rẹ̀, yóò sì wà ní ipò àìmọ́ títí di àṣálẹ́ lẹ́yìn èyí ni yóò tó di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ṣùgbọ́n bí ó bá kọ̀ láti wẹ ara rẹ̀ tí kò sì fọ aṣọ rẹ̀ náà: ẹ̀bi rẹ̀ yóò wà lórí ara rẹ̀.’ ” ");
INSERT INTO yor_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Olúwa sọ fún Mose pé: ");
INSERT INTO yor_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Sọ fún àwọn ọmọ Israẹli pé: ‘Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ẹ kò gbọdọ̀ ṣe bí wọ́n ti ń ṣe ní Ejibiti níbi tí ẹ ti gbé rí, bẹ́ẹ̀ ni ẹ kò sì gbọdọ̀ ṣe bí wọ́n ti ń ṣe ní ilẹ̀ Kenaani níbi tí èmi ń mú yín lọ. Ẹ kò gbọdọ̀ tẹ̀lé ìṣe wọn. ");
INSERT INTO yor_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Kí ẹ̀yin kí ó sì máa ṣe òfin mi, kí ẹ̀yin sì máa pa ìlànà mi mọ́, láti máa rìn nínú wọn, Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ẹ̀yin ó sì máa pa ìlànà mi mọ́ àti òfin mi; Ẹni tí ó ba ṣe, yóò yè nípa wọn. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Ẹnikẹ́ni nínú yín kò gbọdọ̀ súnmọ́ ìbátan rẹ̀ láti bá a lòpọ̀. Èmí ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Ìwọ kò gbọdọ̀ tàbùkù baba rẹ nípa bíbá ìyá rẹ lòpọ̀, ìyá rẹ̀ ni, ìwọ kò gbọdọ̀ bá a lòpọ̀. ");
INSERT INTO yor_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Ìwọ kò gbọdọ̀ tàbùkù baba rẹ nípa bíbá ìyàwó baba rẹ lòpọ̀, nítorí ìhòhò baba rẹ ni. ");
INSERT INTO yor_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Ìwọ kò gbọdọ̀ bá arábìnrin rẹ tí ó jẹ́ ọmọ ìyá rẹ lòpọ̀, yálà a bí i nílé yín tàbí lóde. ");
INSERT INTO yor_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Ìwọ kò gbọdọ̀ bá ọmọbìnrin, ọmọ rẹ ọkùnrin lòpọ̀ tàbí ọmọbìnrin ọmọ rẹ obìnrin lòpọ̀ nítorí pé ìhòhò wọn, ìhòhò ìwọ fúnra rẹ̀ ni. ");
INSERT INTO yor_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Ìwọ kò gbọdọ̀ bá ọmọbìnrin aya baba rẹ lòpọ̀; èyí tí a bí fún baba rẹ nítorí pé arábìnrin rẹ ni. ");
INSERT INTO yor_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Ìwọ kò gbọdọ̀ bá arábìnrin baba rẹ lòpọ̀ nítorí pé ìbátan baba rẹ ni. ");
INSERT INTO yor_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Ìwọ kò gbọdọ̀ bá arábìnrin màmá rẹ lòpọ̀ nítorí pé ìbátan ìyá rẹ ni. ");
INSERT INTO yor_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Ìwọ kò gbọdọ̀ tàbùkù arákùnrin baba rẹ nípa sísún mọ́ aya rẹ̀ láti bá a lòpọ̀ nítorí pé ìyàwó ẹ̀gbọ́n baba rẹ ni. ");
INSERT INTO yor_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Ìwọ kò gbọdọ̀ bá ọmọ àna obìnrin rẹ lòpọ̀ nítorí pé aya ọmọ rẹ ni. Má ṣe bá a lòpọ̀. ");
INSERT INTO yor_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Má ṣe bá aya ẹ̀gbọ́n rẹ ọkùnrin lòpọ̀ nítorí pé yóò tàbùkù ẹ̀gbọ́n rẹ. ");
INSERT INTO yor_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Má ṣe bá ìyá àti ọmọ rẹ obìnrin lòpọ̀, bẹ́ẹ̀ ni ìwọ kò gbọdọ̀ bá ọmọbìnrin ọmọkùnrin rẹ tàbí ọmọbìnrin ọmọbìnrin rẹ lòpọ̀ nítorí pé ìbátan rẹ tímọ́tímọ́ ni: nítorí àbùkù ni. ");
INSERT INTO yor_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Má ṣe fẹ́ àbúrò ìyàwó rẹ obìnrin ní aya gẹ́gẹ́ bí orogún tàbí bá a lòpọ̀, nígbà tí ìyàwó rẹ sì wà láààyè. ");
INSERT INTO yor_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Má ṣe súnmọ́ obìnrin láti bá a lòpọ̀ nígbà tí ó bá ń ṣe nǹkan oṣù, nítorí àkókò àìmọ́ ni. ");
INSERT INTO yor_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Ìwọ kò gbọdọ̀ bá aya aládùúgbò rẹ lòpọ̀, kí ìwọ má ba à ba ara rẹ jẹ́ pẹ̀lú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Ìwọ kò gbọdọ̀ fi èyíkéyìí nínú àwọn ọmọ rẹ rú ẹbọ lórí pẹpẹ sí òrìṣà Moleki, kí o sì tipa bẹ́ẹ̀ ba orúkọ Ọlọ́run rẹ jẹ́. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Ìwọ kò gbọdọ̀ bá ọkùnrin lòpọ̀ bí ìgbà tí ènìyàn ń bá obìnrin lòpọ̀: ìríra ni èyí jẹ́. ");
INSERT INTO yor_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Ìwọ kò gbọdọ̀ bá ẹranko lòpọ̀ kí ìwọ má ba à ba ara rẹ jẹ́. Obìnrin kò sì gbọdọ̀ jọ̀wọ́ ara rẹ̀ sílẹ̀ fún ẹranko láti bá a lòpọ̀, ohun tó lòdì ni. ");
INSERT INTO yor_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Má ṣe fi àwọn nǹkan wọ̀nyí ba ara rẹ jẹ́, torí pé nínú àwọn nǹkan wọ̀nyí ni àwọn orílẹ̀-èdè tí mo lé kúrò níwájú yín ti ba ara wọn jẹ́. ");
INSERT INTO yor_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Nítorí pé ilẹ̀ náà di àìmọ́ nítorí náà mo fi ìyà jẹ ẹ́ nítorí ẹ̀ṣẹ̀ rẹ̀. Ilẹ̀ náà sì pọ àwọn olùgbé ibẹ̀ jáde. ");
INSERT INTO yor_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ṣùgbọ́n kí ẹ máa pa àṣẹ àti òfin mi mọ́. Onílé tàbí àjèjì tó ń gbé láàrín yín kò gbọdọ̀ ṣe ọ̀kan nínú àwọn ohun ìríra wọ̀nyí. ");
INSERT INTO yor_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Nítorí pé gbogbo ohun ìríra wọ̀nyí ni àwọn ènìyàn tí wọ́n ti gbé ilẹ̀ náà ṣáájú yín ti ṣe tí ó sì mú kí ilẹ̀ náà di aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Bí ẹ bá sọ ilẹ̀ náà di àìmọ́ yóò pọ̀ yín jáde bí ó ti pọ àwọn orílẹ̀-èdè tí ó ti wá ṣáájú yín jáde. ");
INSERT INTO yor_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Ẹnikẹ́ni tí ó bá ṣe ohun ìríra wọ̀nyí, kí ẹ gé irú ẹni náà kúrò láàrín àwọn ènìyàn. ");
INSERT INTO yor_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Nítorí náà ẹ gbọdọ̀ ṣe ohun tí mo fẹ́, kí ẹ má sì lọ́wọ́ nínú àṣà ìríra wọ̀nyí, tí wọn ń ṣe kí ẹ tó dé. Ẹ má ṣe fi wọ́n ba ara yín jẹ́. Èmi ni Olúwa Ọlọ́run yín.’ ” ");
INSERT INTO yor_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Bá gbogbo àpéjọpọ̀ àwọn ọmọ Israẹli sọ̀rọ̀, sì wí fún wọn pé, ‘Ẹ jẹ́ mímọ́ nítorí Èmi Olúwa Ọlọ́run yín jẹ́ mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Ẹnìkọ̀ọ̀kan yín gbọdọ̀ bọ̀wọ̀ fún ìyá àti baba rẹ̀, kí ẹ sì ya ọjọ́ ìsinmi mi sí mímọ́. Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Ẹ má ṣe yípadà tọ ère òrìṣà lẹ́yìn, bẹ́ẹ̀ ni ẹ kò gbọdọ̀ rọ ère òrìṣà idẹ fún ara yín. Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Nígbà tí ẹ̀yin bá sì rú ẹbọ àlàáfíà sí Olúwa, kí ẹ̀yin kí ó ṣe é ní ọ̀nà tí yóò fi jẹ́ ìtẹ́wọ́gbà dípò yín. ");
INSERT INTO yor_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ní ọjọ́ tí ẹ bá rú u náà ni ẹ gbọdọ̀ jẹ ẹ́ tàbí ní ọjọ́ kejì; èyí tí ó bá ṣẹ́kù di ọjọ́ kẹta ni kí ẹ fi iná sun. ");
INSERT INTO yor_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Bí ẹ bá jẹ nínú èyí tí ó ṣẹ́kù di ọjọ́ kẹta, àìmọ́ ni èyí jẹ́, kò ní jẹ́ ìtẹ́wọ́gbà. ");
INSERT INTO yor_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Nítorí náà ẹnikẹ́ni tí ó bá jẹ ẹ́ ni a ó di ẹ̀bi rẹ̀ rù, nítorí pé ó ti ba ohun mímọ́ Olúwa jẹ́, irú ẹni bẹ́ẹ̀ ni kí ẹ gé kúrò láàrín àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Nígbà tí ẹ̀yin bá kórè nǹkan oko yín, kí ẹ̀yin kí ó fi díẹ̀ sílẹ̀ láìkórè ní àwọn igun oko yín, ẹ̀yin kò sì gbọdọ̀ ṣa ẹ̀ṣẹ́ (nǹkan oko tí ẹ ti gbàgbé tàbí tí ó bọ́ sílẹ̀). ");
INSERT INTO yor_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ẹ̀yin kò gbọdọ̀ kórè oko yín tan pátápátá, bẹ́ẹ̀ ni ẹ̀yin kò gbọdọ̀ ṣa èso tí ó rẹ̀ bọ́ sílẹ̀ nínú ọgbà àjàrà yín. Ẹ fi wọ́n sílẹ̀ fún àwọn aláìní àti fún àwọn àlejò. Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Ìwọ kò gbọdọ̀ jalè. “ ‘Ìwọ kò gbọdọ̀ parọ́. “ ‘Ẹ kò gbọdọ̀ tan ara yín jẹ. ");
INSERT INTO yor_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Ìwọ kò gbọdọ̀ fi orúkọ mi búra èké, kí o sì tipa bẹ́ẹ̀ ba orúkọ Ọlọ́run rẹ jẹ́. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Ìwọ kò gbọdọ̀ rẹ́ aládùúgbò rẹ jẹ bẹ́ẹ̀ ni ìwọ kò gbọdọ̀ jà á lólè. “ ‘Ìwọ kò gbọdọ̀ dá owó iṣẹ́ alágbàṣe dúró di ọjọ́ kejì. ");
INSERT INTO yor_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Ìwọ kò gbọdọ̀ ṣépè lé adití, bẹ́ẹ̀ ni o kò gbọdọ̀ fi ohun ìdìgbòlù sí iwájú afọ́jú, ṣùgbọ́n bẹ̀rù Ọlọ́run rẹ. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Ìwọ kò gbọdọ̀ yí ìdájọ́ po, má ṣe ojúsàájú sí ẹjọ́ tálákà, bẹ́ẹ̀ ni o kò gbọdọ̀ gbé ti ọlọ́lá lẹ́yìn, ṣùgbọ́n fi òdodo ṣe ìdájọ́, àwọn aládùúgbò rẹ. ");
INSERT INTO yor_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Ìwọ kò gbọdọ̀ máa ṣèyíṣọ̀hún bí olóòfófó láàrín àwọn ènìyàn rẹ. “ ‘Ìwọ kò gbọdọ̀ ṣe ohunkóhun tí yóò fi ẹ̀mí aládùúgbò rẹ wéwu. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Ìwọ kò gbọdọ̀ kórìíra arákùnrin rẹ lọ́kàn rẹ, bá aládùúgbò rẹ wí, kí o má ba à jẹ́ alábápín nínú ẹ̀bi rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Ìwọ kò gbọdọ̀ gbẹ̀san: má sì ṣe bínú sí èyíkéyìí nínú àwọn ènìyàn rẹ. Ṣùgbọ́n, kí ìwọ kí ó fẹ́ ẹnìkejì rẹ bí ara rẹ. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Máa pa àṣẹ mi mọ́. “ ‘Ìwọ kò gbọdọ̀ jẹ́ kí ohun ọ̀sìn rẹ máa gùn pẹ̀lú ẹ̀yà mìíràn. “ ‘Ìwọ kò gbọdọ̀ gbin dàrúdàpọ̀ oríṣìí irúgbìn méjì sínú oko kan. “ ‘Ìwọ kò gbọdọ̀ wọ aṣọ èyí tí a fi oríṣìí ohun èlò ìhunṣọ méjì ṣe. ");
INSERT INTO yor_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Bí ọkùnrin kan bá bá obìnrin tí ó jẹ́ ẹrú lòpọ̀, ẹni tí a ti mọ̀ pọ̀ pẹ̀lú ọkùnrin mìíràn tí a kò sì tí ì rà á padà tàbí sọ ọ́ di òmìnira. Ẹ gbọdọ̀ ṣe ìwádìí kí ẹ sì jẹ wọ́n ní ìyà tó tọ́ ṣùgbọ́n ẹ kò gbọdọ̀ pa wọ́n, torí pé kò ì tí ì di òmìnira. ");
INSERT INTO yor_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Kí ọkùnrin náà mú àgbò kan wá sí ẹnu-ọ̀nà àgọ́ ìpàdé bí i ẹbọ ẹ̀bi sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Àlùfáà yóò sì ṣe ètùtù fún un, pẹ̀lú àgbò ẹbọ ẹ̀bi náà níwájú Olúwa fún ìdáríjì ẹ̀ṣẹ̀ tí ó ti ṣẹ̀. A ó sì dárí ẹ̀ṣẹ̀ náà jì í. ");
INSERT INTO yor_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Nígbà tí ẹ bá dé ilẹ̀ náà tí ẹ sì gbin igi eléso, kí ẹ ká èso wọn sí ohun èèwọ̀. Fún ọdún mẹ́ta ni kí ẹ kà á sí èèwọ̀, ẹ kò gbọdọ̀ jẹ ẹ́. ");
INSERT INTO yor_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ṣùgbọ́n ní ọdún kẹrin, gbogbo èso wọ̀nyí yóò jẹ́ mímọ́, ọrẹ fún ìyìn Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ní ọdún karùn-ún ni ẹ̀yin tó lè jẹ nínú èso igi náà, kí èso wọn ba à le máa pọ̀ sí i. Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Ẹ má ṣe jẹ ẹrankẹ́ran pẹ̀lú ẹ̀jẹ̀ rẹ̀. “ ‘Ẹ kò gbọdọ̀ lọ sí ọ̀dọ̀ yẹ̀míwò tàbí oṣó. ");
INSERT INTO yor_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Ẹ má ṣe dá òṣù sí àárín orí yín (fífá irun ẹ̀gbẹ́ orí, tí a ó sì dá irun àárín orí sí) tàbí kí ẹ ré orí irùngbọ̀n yín bí àwọn aláìkọlà ti ń ṣe. ");
INSERT INTO yor_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Ẹ má ṣe tìtorí òkú, gé ibi kankan nínú ẹ̀yà ara yín, ẹ kò sì gbọdọ̀ sín gbẹ́rẹ́ kankan. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Ẹ má ṣe ba ọmọbìnrin yín jẹ́ láti sọ ọ́ di panṣágà, kí ilẹ̀ yín má ba à di ti àgbèrè, kí ó sì kún fún ìwà búburú. ");
INSERT INTO yor_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Ẹ gbọdọ̀ máa pa ìsinmi mi mọ́ kí ẹ sì fi ọ̀wọ̀ fún ibi mímọ́ mi. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Ẹ má ṣe tọ abókùúsọ̀rọ̀ tàbí àwọn àjẹ́ lọ, ẹ kò gbọdọ̀ tọ̀ wọ́n lẹ́yìn láti jẹ́ kí wọ́n sọ yín di aláìmọ́. Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Fi ọ̀wọ̀ fún ọjọ́ orí arúgbó, ẹ sì bu ọlá fún àwọn àgbàlagbà kí ẹ sì bẹ̀rù Ọlọ́run yín. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Nígbà tí àjèjì kan bá ń gbé pẹ̀lú yín ní ilẹ̀ yín, ẹ má ṣe ṣe é ní ibi ");
INSERT INTO yor_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","kí àjèjì tí ń gbé pẹ̀lú yín dàbí onílé láàrín yín kí ẹ sì fẹ́ràn rẹ̀ bí i ara yín, torí pé ẹ̀yin ti jẹ́ àjèjì ní ilẹ̀ Ejibiti rí. Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Ẹ má ṣe lo òsùwọ̀n èké, nígbà tí ẹ bá ń díwọ̀n yálà nípa òsùwọ̀n ọ̀pá, òsùwọ̀n ìwúwo tàbí òsùwọ̀n onínú. ");
INSERT INTO yor_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ẹ jẹ́ olódodo pẹ̀lú àwọn òsùwọ̀n yín òsùwọ̀n ìtẹ̀wọ̀n, òsùwọ̀n wíwúwo, òsùwọ̀n ìyẹ̀fun àti òsùwọ̀n nǹkan olómi yín ní láti jẹ́ èyí tí kò ní èrú nínú. Èmi ni Olúwa Ọlọ́run yín tí ó mú yín jáde láti ilẹ̀ Ejibiti. ");
INSERT INTO yor_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Ẹ ó sì máa pa gbogbo àṣẹ àti òfin mi mọ́, ẹ ó sì máa ṣe wọ́n. Èmi ni Olúwa.’ ” ");
INSERT INTO yor_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Sọ fún àwọn ará Israẹli pé, ‘Ẹnikẹ́ni nínú àwọn ará Israẹli tàbí àwọn àlejò tí ń gbé láàrín Israẹli, tí ó bá fi èyíkéyìí nínú àwọn ọmọ rẹ̀ fún Moleki, kí wọ́n pa á, kí àwọn olùgbé ilẹ̀ náà sọ ọ́ ní òkúta pa. ");
INSERT INTO yor_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Èmi tìkára mi yóò bínú sí irú ẹni bẹ́ẹ̀, ń ó sì gé e kúrò láàrín àwọn ènìyàn rẹ̀ fún òrìṣà Moleki ó ti ba ibi mímọ́ mi jẹ́ pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Bí àwọn ènìyàn ilẹ̀ náà bá mójú kúrò lára irú ẹni bẹ́ẹ̀ tí ó fi ọ̀kan nínú àwọn ọmọ rẹ̀ fún òrìṣà Moleki tí wọn kò sì pa irú ẹni bẹ́ẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Èmi yóò bínú sí irú ẹni bẹ́ẹ̀ àti gbogbo ìdílé rẹ̀, èmi yóò sì ké wọn kúrò láàrín àwọn ènìyàn wọn, òun àti gbogbo àwọn tí ó jọ ṣe àgbèrè tọ òrìṣà Moleki lẹ́yìn. ");
INSERT INTO yor_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Bí ẹnikẹ́ni bá tọ àwọn abókùúsọ̀rọ̀ àti àwọn ẹlẹ́mìí òkùnkùn lọ, tí ó sì ṣe àgbèrè tọ̀ wọ́n lẹ́yìn, Èmi yóò bínú sí irú ẹni bẹ́ẹ̀, Èmi yóò sì gé e kúrò láàrín àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Torí náà ẹ ya ara yín sí mímọ́ kí ẹ sì jẹ́ mímọ́, torí pé, Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ẹ máa kíyèsi àṣẹ mi, kí ẹ sì máa pa wọ́n mọ́. Èmi ni Olúwa tí ó sọ yín di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Ẹnikẹ́ni tí ó bá ṣépè lé baba tàbí ìyá rẹ̀ ni kí ẹ pa, ẹ̀jẹ̀ rẹ̀ wà lórí ara rẹ̀ torí pé ó ti ṣépè lé baba àti ìyá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Bí ẹnikẹ́ni bá bá aya aládùúgbò rẹ̀ lòpọ̀: ọkùnrin àti obìnrin náà ni kí ẹ sọ ní òkúta pa. ");
INSERT INTO yor_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Ẹnikẹ́ni tí ó bá bá aya baba rẹ̀ lòpọ̀ ti tàbùkù baba rẹ̀. Àwọn méjèèjì ni kí ẹ pa. Ẹ̀jẹ̀ wọn yóò wà lórí wọn. ");
INSERT INTO yor_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Bí ọkùnrin kan bá bá arábìnrin ìyàwó rẹ̀ lòpọ̀, àwọn méjèèjì ni kí ẹ pa, wọ́n ti ṣe ohun tí ó lòdì, ẹ̀jẹ̀ wọn yóò wà lórí wọn. ");
INSERT INTO yor_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Bí ọkùnrin kan bá bá ọkùnrin mìíràn lòpọ̀ bí wọ́n ti í bá obìnrin lòpọ̀: àwọn méjèèjì ti ṣe ohun ìríra, pípa ni kí ẹ pa wọ́n, ẹ̀jẹ̀ wọn yóò wà lórí wọn. ");
INSERT INTO yor_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Bí ọkùnrin kan bá fẹ́ tìyátọmọ papọ̀, ìwà búburú ni èyí: iná ni kí ẹ fi sun wọ́n, òun àti àwọn méjèèjì, kí ìwà búburú má ba à gbilẹ̀ láàrín yín. ");
INSERT INTO yor_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Bí ọkùnrin kan bá bá ẹranko lòpọ̀, ẹ gbọdọ̀ pa ọkùnrin náà àti ẹranko náà. ");
INSERT INTO yor_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Bí obìnrin kan bá súnmọ́ ẹranko tí ó sì bá a lòpọ̀ obìnrin náà àti ẹranko náà ni kí ẹ pa, ẹ̀jẹ̀ wọn yóò sì wà lórí ara wọn. ");
INSERT INTO yor_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Bí ọkùnrin kan bá fẹ́ arábìnrin rẹ̀ yálà ọmọbìnrin baba rẹ̀ tàbí ọmọbìnrin ìyá rẹ̀ tí ó sì bá a lòpọ̀, ohun ìtìjú ni èyí, ẹ ó gé wọn kúrò lójú àwọn ènìyàn wọn, ó ti tàbùkù arábìnrin rẹ̀. Ẹ̀bi rẹ̀ yóò wá sórí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Bí ọkùnrin kan bá súnmọ́ obìnrin, ní àkókò nǹkan oṣù rẹ̀ tí ó sì bá a lòpọ̀. Ó ti tú orísun ẹ̀jẹ̀ rẹ̀. Òun náà sì gbà á láààyè. Àwọn méjèèjì ni a ó gé kúrò láàrín àwọn ènìyàn wọn. ");
INSERT INTO yor_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Má ṣe bá arábìnrin baba tàbí ti ìyá rẹ lòpọ̀, nítorí o ti tú ìhòhò ìbátan rẹ, ẹ̀yin méjèèjì ni yóò ru ẹ̀bi yín. ");
INSERT INTO yor_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Bí ọkùnrin kan bá bá aya arákùnrin baba rẹ̀ lòpọ̀ ó ti tàbùkù arákùnrin baba rẹ̀. A ó jẹ wọ́n ní ìyà; wọn yóò sì kú láìlọ́mọ. ");
INSERT INTO yor_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Bí ọkùnrin kan bá gba aya arákùnrin rẹ̀, ohun àìmọ́ ni èyí, ó ti tàbùkù arákùnrin rẹ̀, wọn ó wà láìlọ́mọ. ");
INSERT INTO yor_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Kí ẹ pa gbogbo àṣẹ àti òfin mi mọ́, kí ẹ sì máa ṣe wọ́n. Kí ilẹ̀ náà tí èmi ó fi fún yín láti máa gbé má ba à pọ̀ yín jáde. ");
INSERT INTO yor_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ẹ má ṣe tẹ̀lé àṣà àwọn orílẹ̀-èdè tí mo lé jáde níwájú yín torí pé gbogbo nǹkan wọ̀nyí ni wọ́n ń ṣe, tí mo kórìíra wọn. ");
INSERT INTO yor_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ṣùgbọ́n mo ti sọ fún yín pé, “Ẹ̀yin ni yóò jogún ilẹ̀ wọn, Èmi yóò sì fi fún yín láti jogún ilẹ̀ tí ó ń sàn fún wàrà àti oyin.” Èmi ni Olúwa Ọlọ́run yín tí ó ti yà yín sọ́tọ̀ kúrò láàrín àwọn ènìyàn yòókù. ");
INSERT INTO yor_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Ẹ gbọdọ̀ pààlà sáàrín ẹran tí ó mọ́ àti àwọn tí kò mọ́. Láàrín ẹyẹ tí ó mọ́ àti àwọn tí kò mọ́. Ẹ má ṣe sọ ara yín di àìmọ́ nípasẹ̀ àwọn ẹranko tàbí ẹyẹ tàbí ohunkóhun tí ń rìn lórí ilẹ̀: èyí tí mo yà sọ́tọ̀ fún yín gẹ́gẹ́ bí ohun àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ẹ gbọdọ̀ jẹ́ mímọ́ fún mi torí pé, Èmi Olúwa fẹ́ mímọ́. Mó sì ti yà yín kúrò nínú àwọn orílẹ̀-èdè yòókù kí ẹ le jẹ́ tèmi. ");
INSERT INTO yor_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Ọkùnrin tàbí obìnrin tí ó jẹ́ abókùúsọ̀rọ̀ tàbí oṣó láàrín yín ni kí ẹ pa. Ẹ sọ wọ́n ní òkúta, ẹ̀jẹ̀ wọn yóò wà lórí wọn.’ ” ");
INSERT INTO yor_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Olúwa sọ fún Mose wí pe, “Bá àwọn àlùfáà tí wọ́n jẹ́ ọmọ Aaroni sọ̀rọ̀, kí o sì sọ fún wọn pé, ‘Ẹnikẹ́ni nínú wọn kò gbọdọ̀ sọ ara rẹ̀ di aláìmọ́ nítorí àwọn ènìyàn wọn tí ó kù. ");
INSERT INTO yor_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Ṣùgbọ́n bí ó bá ṣe àwọn tí ó súnmọ́ ọn bí ìyá rẹ̀, baba rẹ̀, ọmọ rẹ̀ ọkùnrin tàbí obìnrin, àti arákùnrin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Tàbí fún arábìnrin rẹ̀ tí kò ì tí ì wọ ilé ọkọ tí ó ń gbé lọ́dọ̀ rẹ̀. Nítorí tí arábìnrin bẹ́ẹ̀, ó lè sọ ara rẹ̀ di aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Nítorí tí ó jẹ́ olórí, òun kò gbọdọ̀ sọ ara rẹ̀ di aláìmọ́, bẹ́ẹ̀ ni kò gbọdọ̀ ba ara rẹ̀ jẹ́ láàrín àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Àlùfáà kò gbọdọ̀ fá irun orí rẹ̀ bẹ́ẹ̀ ni kò gbọdọ̀ rẹ́ irùngbọ̀n rẹ̀. Kò gbọdọ̀ fi abẹ ya ara rẹ̀ láti fihàn pé òun wà ní ipò ọ̀fọ̀. ");
INSERT INTO yor_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Wọ́n gbọdọ̀ jẹ́ mímọ́ fún Ọlọ́run, kí wọ́n má ba à sọ orúkọ Ọlọ́run wọn di àìmọ́, nítorí pé àwọn ni wọ́n ń fi iná sun ẹbọ sí Olúwa wọn, ti ó jẹ oúnjẹ Ọlọ́run wọn. Nítorí náà wọn gbọdọ̀ jẹ́ mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Àwọn àlùfáà kò gbọdọ̀ fẹ́ panṣágà tàbí obìnrin tí ó ti fi ọkùnrin ba ara rẹ̀ jẹ́ tàbí obìnrin tí ọkọ rẹ̀ ti kọ̀sílẹ̀ nítorí pé àwọn àlùfáà jẹ́ mímọ́ sí Ọlọ́run wọn. ");
INSERT INTO yor_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Àwọn ènìyàn gbọdọ̀ máa kà wọ́n sí mímọ́, nítorí pé àwọn ni wọ́n ń rú ẹbọ oúnjẹ fún mi. Èmi ni Olúwa, mo jẹ́ mímọ́, mo sì ya àwọn ènìyàn mi sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Bí ọmọbìnrin àlùfáà kan bá fi iṣẹ́ àgbèrè ba ara rẹ̀ jẹ́, ó dójútì baba rẹ̀, iná ni a ó dá sun ún. ");
INSERT INTO yor_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Lẹ́yìn tí a ti fi òróró yan olórí àlùfáà láàrín àwọn arákùnrin rẹ̀, tí a sì ti fi àmì òróró yàn án láti máa wọ aṣọ àlùfáà, ó gbọdọ̀ tọ́jú irun orí rẹ̀, bẹ́ẹ̀ ni kò gbọdọ̀ fa aṣọ rẹ̀ ya láti fihàn pé òun wà ní ipò ọ̀fọ̀. ");
INSERT INTO yor_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Kí ó ma ṣe wọlé tọ òkú lọ, kí ó má ṣe sọ ará rẹ di àìmọ́ nítorí baba tàbí nítorí ìyá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kò gbọdọ̀ kúrò ní ibi mímọ́ Ọlọ́run tàbí kí ó sọ ọ́ di aláìmọ́ torí pé a ti fi ìfòróróyàn Ọlọ́run yà á sí mímọ́. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Ọmọbìnrin tí yóò fẹ́ gbọdọ̀ jẹ́ ẹni tí kò mọ ọkùnrin rí. ");
INSERT INTO yor_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Kò gbọdọ̀ fẹ́ opó tàbí ẹni tí a kọ̀sílẹ̀ tàbí obìnrin tí ó ti fi àgbèrè ba ara rẹ̀ jẹ́, ṣùgbọ́n kí ó fẹ́ obìnrin tí kò mọ ọkùnrin rí, láàrín àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Kí ó má ba à sọ di aláìmọ́ nínú àwọn ènìyàn rẹ̀. Èmi ni Olúwa tí ó sọ ọ́ di mímọ́.’ ” ");
INSERT INTO yor_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Olúwa sì bá Mose sọ̀rọ̀ pé, ");
INSERT INTO yor_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Sọ fún Aaroni pé, ‘Ẹnikẹ́ni nínú irú-ọmọ rẹ̀ ní ìran-ìran wọn, tí ó bá ní ààrùn kan, kí ó má ṣe súnmọ́ tòsí láti rú ẹbọ ohun jíjẹ sí Ọlọ́run rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ẹnikẹ́ni tí ó bá ní àbùkù kò gbọdọ̀ súnmọ́ ibi ẹbọ náà. Kò gbọdọ̀ sí afọ́jú tàbí arọ, alábùkù ara tàbí àwọn tí ara wọn kò pé. ");
INSERT INTO yor_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Kò gbọdọ̀ sí ẹnikẹ́ni yálà ó rọ lápá lẹ́sẹ̀, ");
INSERT INTO yor_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","tàbí tí ó jẹ́ abuké, tàbí tí ó ya aràrá tàbí tí ó ní àìsàn ojú tàbí tí ó ní egbò tàbí tí a ti yọ nǹkan ọmọkùnrin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ẹnikẹ́ni tí ó ní àbùkù nínú irú-ọmọ Aaroni àlùfáà kò gbọdọ̀ súnmọ́ tòsí láti rú ẹbọ tí fi iná sun sí Olúwa. Nítorí pé ó jẹ́ alábùkù, kò gbọdọ̀ súnmọ́ tòsí láti rú ẹbọ àkàrà sí Ọlọ́run rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ó lè jẹ́ oúnjẹ Ọlọ́run rẹ̀ tàbí èyí tí ó mọ́ jùlọ, ṣùgbọ́n torí pé ó ní àbùkù kò gbọdọ̀ súnmọ́ ibi aṣọ títa tàbí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Nípa ṣíṣe bẹ́ẹ̀ yóò ba ibi mímọ́ mi jẹ́ torí pé, Èmi Olúwa ló ti sọ wọ́n di mímọ́.’ ” ");
INSERT INTO yor_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Wọ̀nyí ni àwọn ohun tí Mose sọ fún Aaroni, àwọn ọmọ Aaroni àti gbogbo ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Sọ fún Aaroni àti àwọn ọmọ rẹ̀ kí wọ́n fi ọ̀wọ̀ fún ọrẹ mímọ́ tí àwọn ọmọ Israẹli yà sọ́tọ̀ fún mi, kí wọ́n má ba à ba orúkọ mímọ́ mi jẹ́. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Sọ fún wọn pé, ‘Fún àwọn ìran tí ń bọ̀. Bí ẹnikẹ́ni nínú àwọn ọmọ yín tí kò mọ́ bá wá sí ibi ọrẹ mímọ́ tí àwọn ara Israẹli ti yà sọ́tọ̀ fún Olúwa, kí ẹ yọ ẹni náà kúrò nínú iṣẹ́ àlùfáà ní iwájú mi. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Bí ọ̀kan nínú àwọn ọmọ Aaroni bá ní ààrùn ara tí ń ran ni, tàbí ìtújáde nínú ara. Ó lè má jẹ ọrẹ mímọ́ náà títí di ìgbà tí a ó fi wẹ̀ ẹ́ mọ́. Òun tún lè di aláìmọ́ bí ó bá fọwọ́ kan ohunkóhun tí òkú nǹkan bá sọ di àìmọ́ tàbí bí ó bá farakan ẹnikẹ́ni tí ó ní ìtújáde. ");
INSERT INTO yor_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Tàbí bí ó bá fọwọ́ kan èyíkéyìí nínú ohun tí ń rákò, tí ó sọ ọ́ di aláìmọ́, tàbí ẹnikẹ́ni tí ó sọ ọ́ di àìmọ́, ohunkóhun yówù kí àìmọ́ náà jẹ́. ");
INSERT INTO yor_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ẹni náà tí ó fọwọ́ kan irú nǹkan bẹ́ẹ̀ yóò di aláìmọ́ títí ìrọ̀lẹ́. Kò gbọdọ̀ jẹ èyíkéyìí nínú ọrẹ mímọ́ àyàfi bí ó bá wẹ ara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Bí oòrùn bá wọ̀, ẹni náà di mímọ́, lẹ́yìn náà ni ó tó le jẹ ọrẹ mímọ́, torí pé wọ́n jẹ́ oúnjẹ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kò gbọdọ̀ jẹ ohunkóhun tí ó bá ti kú sílẹ̀, tàbí tí ẹranko fàya, kí ó sì tipa bẹ́ẹ̀ di aláìmọ́. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Kí àwọn àlùfáà pa ìlànà mi mọ́, kí wọn má ba à jẹ̀bi, kí wọn sì kú nítorí pé wọ́n ṣe ọrẹ wọ̀nyí pẹ̀lú fífojútẹ́ńbẹ́lú wọn. Èmi ni Olúwa tí ó sọ wọ́n di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Kò sí ẹnikẹ́ni lẹ́yìn ìdílé àlùfáà tí ó le jẹ ọrẹ mímọ́ náà, bẹ́ẹ̀ ni, àlejò àlùfáà tàbí alágbàṣe rẹ̀ kò le jẹ ẹ́. ");
INSERT INTO yor_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ṣùgbọ́n bí àlùfáà bá ra ẹrú, pẹ̀lú owó, tàbí tí a bí ẹrú kan nínú ìdílé rẹ̀, ẹrú náà lè jẹ oúnjẹ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Bí ọmọbìnrin àlùfáà bá fẹ́ ẹni tí kì í ṣe àlùfáà, kò gbọdọ̀ jẹ nínú èyíkéyìí nínú ohun ọrẹ mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ṣùgbọ́n bí ọmọbìnrin àlùfáà bá jẹ́ opó tàbí tí a ti kọ ọ́ sílẹ̀, ṣùgbọ́n tí kò lọ́mọ tí ó sì padà sínú ilé baba rẹ̀ láti máa gbé bẹ̀, gẹ́gẹ́ bí ìgbà èwe rẹ̀, ó le jẹ oúnjẹ baba rẹ̀. Bí ó ti wù kí ó rí, àlejò tí kò lẹ́tọ̀ọ́ kò gbọdọ̀ jẹ èyíkéyìí nínú oúnjẹ náà. ");
INSERT INTO yor_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Bí ẹnikẹ́ni bá ṣèèṣì jẹ ọrẹ mímọ́ kan, ó gbọdọ̀ ṣe àtúnṣe lórí ẹbọ náà fún àlùfáà, kí ó sì fi ìdámárùn-ún ohun tí ọrẹ náà jẹ́ kún un. ");
INSERT INTO yor_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Àwọn àlùfáà kò gbọdọ̀ sọ ọrẹ mímọ́ tí àwọn ọmọ Israẹli mú wá síwájú Olúwa di àìmọ́. ");
INSERT INTO yor_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Nípa fífi ààyè fún wọn láti jẹ ọrẹ mímọ́ náà, kí wọ́n sì tipa bẹ́ẹ̀ mú ẹ̀bi tí wọn yóò san nǹkan fún wá sórí wọn. Èmi ni Olúwa, tí ó sọ wọ́n di mímọ́.’ ” ");
INSERT INTO yor_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Sọ fún Aaroni, àwọn ọmọ rẹ̀ àti fún gbogbo Israẹli kí o sì wí fún wọn pé, ‘Bí ẹnikẹ́ni nínú yín yálà ọmọ Israẹli ni tàbí àlejò tí ń gbé ní Israẹli bá mú ẹ̀bùn wá fún ọrẹ ẹbọ sísun sí Olúwa, yálà láti san ẹ̀jẹ́ tàbí ọrẹ àtinúwá. ");
INSERT INTO yor_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Ẹ gbọdọ̀ mú akọ láìní àbùkù láti ara màlúù, àgùntàn tàbí ewúrẹ́, kí ó ba à lè jẹ́ ìtẹ́wọ́gbà fún yín. ");
INSERT INTO yor_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ẹ má ṣe mú ohunkóhun tí ó ní àbùkù wá, torí pé kò ní jẹ́ ìtẹ́wọ́gbà fún yín. ");
INSERT INTO yor_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Bí ẹnikẹ́ni bá mú ọrẹ àlàáfíà wá láti inú agbo màlúù tàbí ti àgùntàn, fún Olúwa láti san ẹ̀jẹ́ pàtàkì tàbí fún ọrẹ àtinúwá. Ó gbọdọ̀ jẹ́ ìtẹ́wọ́gbà láìní àbùkù. ");
INSERT INTO yor_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ẹ má ṣe fi ẹranko tí ó fọ́jú, tí ó fi ara pa, tí ó yarọ, tí ó ní kókó, tí ó ní èkúkú, èépá àti egbò kíkẹ̀ rú ẹbọ sí Olúwa. Ẹ kò gbọdọ̀ gbé èyíkéyìí nínú wọn sórí pẹpẹ gẹ́gẹ́ bi ọrẹ tí a fi iná ṣe sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ẹ le mú màlúù tàbí àgùntàn tí ó ní àbùkù tàbí tí ó yọ iké wá fún ọrẹ àtinúwá, ṣùgbọ́n kò jẹ́ ìtẹ́wọ́gbà fún ọrẹ ẹ̀jẹ́. ");
INSERT INTO yor_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ẹ má ṣe fi ẹranko tí kóró ẹpọ̀n rẹ̀ fọ́ tàbí tí a tẹ̀, tàbí tí a yà tàbí tí a là rú ẹbọ sí Olúwa. Ẹ kò gbọdọ̀ ṣe èyí ní ilẹ̀ yín. ");
INSERT INTO yor_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ẹ kò gbọdọ̀ gba irú ẹranko bẹ́ẹ̀ lọ́wọ́ àlejò kankan láti fi rú ẹbọ gẹ́gẹ́ bí oúnjẹ sí Ọlọ́run yín. A kò nígbà wọ́n fún yín nítorí pé wọ́n ní àbùkù, wọ́n sì díbàjẹ́.’ ” ");
INSERT INTO yor_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Nígbà tí màlúù bá bímọ, tí àgùntàn bímọ, tí ewúrẹ́ sì bímọ, ọmọ náà gbọdọ̀ wà pẹ̀lú ìyá rẹ̀ fún ọjọ́ méje. Láti ọjọ́ kẹjọ ni ó ti di ìtẹ́wọ́gbà fún ọrẹ àfinásun sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ẹ má ṣe pa màlúù àti ọmọ rẹ̀ tàbí àgùntàn àti ọmọ rẹ̀ ní ọjọ́ kan náà. ");
INSERT INTO yor_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Nígbà tí ẹ bá rú ẹbọ ọpẹ́ sí Olúwa, ẹ rú u ní ọ̀nà tí yóò fi jẹ́ ìtẹ́wọ́gbà fún yín. ");
INSERT INTO yor_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ẹ gbọdọ̀ jẹ ẹ́ ní ọjọ́ náà gan an, ẹ má ṣe ṣẹ́ ọ̀kankan kù di àárọ̀. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ẹ pa òfin mi mọ́, kí ẹ sì máa ṣe wọ́n. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ẹ má ṣe ba orúkọ mímọ́ mi jẹ́. Àwọn ọmọ Israẹli gbọdọ̀ mọ̀ mí ní mímọ́. Èmi ni Olúwa tí ó sọ yín di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Tí ó sì mú yín jáde láti Ejibiti wá láti jẹ́ Ọlọ́run yín. Èmi ni Olúwa.” ");
INSERT INTO yor_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Olúwa sọ fún Mose wí pé, ");
INSERT INTO yor_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Sọ fún àwọn ọmọ Israẹli, kí o sì wí fún wọn pé, ‘Ìwọ̀nyí ni àwọn àjọ̀dún tí a yàn, àwọn àjọ̀dún ti Olúwa èyí tí ẹ gbọdọ̀ kéde gẹ́gẹ́ bí àjọ̀dún tí a yàn. ");
INSERT INTO yor_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Ọjọ́ mẹ́fà ni ẹ le fi ṣiṣẹ́, ṣùgbọ́n ọjọ́ keje ni ọjọ́ ìsinmi. Ọjọ́ àjọ̀dún tí a yàn. Ẹ kò gbọdọ̀ ṣe iṣẹ́ kankan, níbikíbi tí ẹ bá ń gbé. Ọjọ́ ìsinmi Olúwa ni. ");
INSERT INTO yor_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Àwọn wọ̀nyí ni àwọn ọdún tí Olúwa yàn, àjọ̀dún tí a yàn tí ẹ gbọdọ̀ kéde lákokò wọn. ");
INSERT INTO yor_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Àjọ ìrékọjá Olúwa bẹ̀rẹ̀ ní ìrọ̀lẹ́ ọjọ́ kẹrìnlá oṣù kìn-ín-ní. ");
INSERT INTO yor_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ní ọjọ́ kẹ́ẹ̀dógún oṣù kìn-ín-ní, ni àjọ̀dún àkàrà àìwú tí Olúwa yó bẹ̀rẹ̀, fún ọjọ́ méje ni ẹ gbọdọ̀ fi jẹ àkàrà tí kò ní ìwúkàrà. ");
INSERT INTO yor_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ní ọjọ́ kìn-ín-ní kí àpéjọ mímọ́ kí ó wà; ẹ́yin kò gbọdọ̀ ṣe iṣẹ́ agbára kankan nínú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ọjọ́ méje ni kí ẹ fi mú ọrẹ tí a fi iná ṣe wá fún Olúwa. Ní ọjọ́ keje, ẹ pe ìpàdé àjọ mímọ́, ẹ kò gbọdọ̀ ṣe iṣẹ́ kankan.’ ” ");
INSERT INTO yor_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Olúwa sọ fún Mose pe, ");
INSERT INTO yor_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Sọ fún àwọn ará Israẹli, kí o sì wí fún wọn pé, ‘Nígbà tí ẹ bá dé ilẹ̀ tí èmi yóò fún yín, tí ẹ bá ń ṣe ìkórè, kí ẹ mú síírí ọkà àkọ́kọ́ tí ẹ kórè wá fún àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kí ó fi síírí ọkà náà níwájú Olúwa, kí ó le jẹ́ ìtẹ́wọ́gbà fún yín: kí àlùfáà fì í ní ọjọ́ kejì ìsinmi. ");
INSERT INTO yor_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ní ọjọ́ tí ẹ bá fi síírí ọkà náà, kí ẹ mú ọ̀dọ́-àgùntàn ọlọ́dún kan láìní àbùkù rú ẹbọ sísun sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Pẹ̀lú ọrẹ ọkà rẹ tí ó jẹ́ ìdá méjì nínú mẹ́wàá òsùwọ̀n efa (èyí jẹ́ lita mẹ́rin ààbọ̀) ti ìyẹ̀fun, tí a fi òróró pò ọrẹ tí a fi iná ṣe fún Olúwa òórùn dídùn pẹ̀lú ọrẹ ohun mímu rẹ̀ tí í ṣe ìdámẹ́rin òsùwọ̀n hínì (èyí jẹ́ lita kan). ");
INSERT INTO yor_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ẹ kò gbọdọ̀ jẹ àkàrà kankan tàbí kí ẹ sun ọkà tuntun títí di ọjọ́ tí ẹ fi mú ọrẹ yín wá fún Ọlọ́run yín. Èyí ni ìlànà ayérayé fún ìran tí ń bọ̀, níbikíbi tí ẹ bá ń gbé. ");
INSERT INTO yor_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Ẹ ka ọ̀sẹ̀ méje gbangba, láti ọjọ́ kejì ọjọ́ ìsinmi, àní ọjọ́ tí ẹ mú ìdì ọkà fífì wá. ");
INSERT INTO yor_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ẹ ka àádọ́ta ọjọ́ títí dé ọjọ́ kejì ọ̀sẹ̀ méjèèje, kí ẹ sì mú ọrẹ ọkà tuntun wá fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Láti ibikíbi tí ẹ bá ń gbé, ẹ mú ìṣù àkàrà méjì tí a fi òsùwọ̀n ìdá méjì nínú mẹ́wàá tí efa (èyí jẹ́ lita mẹ́rin ààbọ̀) ti ìyẹ̀fun, tí a fi ìwúkàrà ṣe, gẹ́gẹ́ bí ọrẹ fífì àkọ́so sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ẹ fi akọ ọ̀dọ́-àgùntàn méje ọlọ́dún kọ̀ọ̀kan tí kò ní àbùkù, ọmọ màlúù kan àti àgbò méjì kún àkàrà yìí, wọn yóò jẹ́ ẹbọ sísun sí Olúwa, pẹ̀lú ẹbọ ohun jíjẹ àti ẹbọ ohun mímu wọn, àní ẹbọ tí a fi iná ṣe, olóòórùn dídùn ni sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Lẹ́yìn náà kí ẹ fi akọ ewúrẹ́ kan rú ẹbọ ẹ̀ṣẹ̀, àti ọ̀dọ́-àgùntàn méjì ọlọ́dún kọ̀ọ̀kan fún ọrẹ àlàáfíà. ");
INSERT INTO yor_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Kí àlùfáà fi ọ̀dọ́-àgùntàn méjèèjì náà níwájú Olúwa bí i ọrẹ fífì pẹ̀lú oúnjẹ àkọ́so wọn jẹ́ ọrẹ mímọ́ sí Olúwa fún àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ní ọjọ́ yìí náà ni kí ẹ kéde ìpàdé àjọ mímọ́: ẹ kò sì gbọdọ̀ ṣe iṣẹ́ kankan. Èyí yóò jẹ́ ìlànà ayérayé fún àwọn ìran tí ń bọ̀ níbi yówù tí ẹ ń gbé. ");
INSERT INTO yor_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Nígbà tí ẹ bá kórè ilẹ̀ yín ẹ má ṣe kórè dé ìkangun oko yín, tàbí kí ẹ padà gé èyí tí ó ṣẹ́kù sílẹ̀ nínú ìkórè yín. Ẹ fi wọ́n sílẹ̀ fún àwọn tálákà àti àwọn àlejò. Èmi ni Olúwa Ọlọ́run yín.’ ” ");
INSERT INTO yor_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Sọ fún àwọn ará Israẹli, ‘Ní ọjọ́ kìn-ín-ní oṣù keje, kí ẹ ní ọjọ́ ìsinmi, ìpàdé àjọ mímọ́ tí a fi fèrè fífọn ṣe ìrántí. ");
INSERT INTO yor_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ẹ má ṣe ṣe iṣẹ́ ojúmọ́, ṣùgbọ́n ẹ mú ọrẹ tí a fi iná sun wá síwájú Olúwa.’ ” ");
INSERT INTO yor_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ọjọ́ kẹwàá oṣù keje yìí ni ọjọ́ ètùtù. Ẹ ni ìpàdé àjọ mímọ́, kí ẹ sì ṣẹ́ ara yín kí ẹ sì mú ọrẹ tí a fi iná ṣe wá fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ẹ má ṣe ṣe iṣẹ́ kankan ní ọjọ́ náà, torí pé ọjọ́ ètùtù ni, nínú èyí tí a ń ṣe ètùtù fún yín níwájú Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ẹnikẹ́ni tí kò bá ṣẹ́ ara rẹ̀ ní ọjọ́ náà ni a ó gé kúrò láàrín àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Èmi yóò pa ẹnikẹ́ni tí ó bá ṣiṣẹ́kíṣẹ́ ní ọjọ́ náà run kúrò láàrín àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ẹ kò gbọdọ̀ ṣe iṣẹ́ kankan rárá. Èyí yóò jẹ́ ìlànà ayérayé fún àwọn ìran tí ń bọ̀, níbikíbi tí ẹ bá ń gbé. ");
INSERT INTO yor_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ọjọ́ ìsinmi ni fún un yín, ẹ gbọdọ̀ ṣẹ́ ara yín, láti ìrọ̀lẹ́ ọjọ́ kẹsànán oṣù náà, títí di ìrọ̀lẹ́ ọjọ́ tí ó tẹ̀lé e, ni kí ẹ fi sinmi.” ");
INSERT INTO yor_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Sọ fún àwọn ará Israẹli pé, ‘Ní ọjọ́ kẹ́ẹ̀dógún oṣù keje ni kí àjọ̀dún ọdún àgọ́ ti Olúwa bẹ̀rẹ̀ kí ó sì wà títí di ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ọjọ́ kìn-ín-ní jẹ́ ọjọ́ ìpàdé mímọ́, ẹ kò gbọdọ̀ ṣe iṣẹ́ ojúmọ́. ");
INSERT INTO yor_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ọjọ́ méje ni kí ẹ fi mú ọrẹ tí a fi iná ṣe wá, ní ọjọ́ kẹjọ, ẹ pe ìpàdé mímọ́ kí ẹ sì mú ọrẹ tí a fi iná ṣe wá fún Olúwa, èyí jẹ́ ìpàdé tí ó gbẹ̀yìn; ẹ má ṣe ṣe iṣẹ́ ojoojúmọ́. ");
INSERT INTO yor_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘Ìwọ̀nyí ni àwọn àjọ̀dún tí Olúwa ti yàn tí ẹ gbọdọ̀ kéde gẹ́gẹ́ bí i àjọ̀dún tí a yàn fún mímu àwọn ọrẹ tí a fi iná ṣe sí Olúwa wá—ẹbọ sísun àti ọrẹ ọkà, ọrẹ ẹbọ àti ọrẹ ohun mímu, fún ọjọ́ kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Àwọn ọrẹ wọ̀nyí wà ní àfikún pẹ̀lú àwọn ọrẹ ọjọ́ ìsinmi Olúwa, àti pẹ̀lú ẹ̀bùn yín àti ohunkóhun tí ẹ ti jẹ́ ẹ̀jẹ́ àti gbogbo ọrẹ àtinúwá yín fún Olúwa.) ");
INSERT INTO yor_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Torí náà, bẹ̀rẹ̀ láti ọjọ́ kẹ́ẹ̀dógún oṣù keje lẹ́yìn ìgbà tí ẹ ti kórè ilẹ̀ náà, ẹ ṣe àjọ̀dún yìí fún Olúwa ní ọjọ́ méje. Ọjọ́ kìn-ín-ní jẹ́ ọjọ́ ìsinmi, ọjọ́ kẹjọ pẹ̀lú si tún jẹ́ ọjọ́ ìsinmi. ");
INSERT INTO yor_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ní ọjọ́ kìn-ín-ní, kí ẹ mú àṣàyàn èso láti orí igi dáradára, imọ̀ ọ̀pẹ, àti ẹ̀ka igi tó rúwé, àti igi wílò odò, kí ẹ sì máa yọ̀ níwájú Olúwa Ọlọ́run yín fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ẹ ṣe èyí ní àjọ̀dún sí Olúwa fún ọjọ́ méje lọ́dọọdún. Èyí yóò jẹ́ ìlànà ayérayé fún àwọn ìran tí ń bọ̀, ẹ ṣe é ní oṣù keje. ");
INSERT INTO yor_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ẹ gbé inú àgọ́ fún ọjọ́ méje. Kí gbogbo ọmọ bíbí Israẹli gbé nínú àgọ́. ");
INSERT INTO yor_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Kí àwọn ìran yín le mọ̀ pé mo mú kí Israẹli gbé nínú àgọ́, nígbà tí mo mú wọn jáde ní Ejibiti. Èmi ni Olúwa Ọlọ́run yín.’ ” ");
INSERT INTO yor_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Báyìí ni Mose kéde àwọn àjọ̀dún tí a yàn Olúwa fún àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Pàṣẹ fún àwọn ọmọ Israẹli láti mú òróró tí ó mọ́ tí a fún láti ara olifi wá láti fi tan iná, kí fìtílà lè máa jò láì kú. ");
INSERT INTO yor_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Lẹ́yìn aṣọ ìkélé ti ibi àpótí ẹ̀rí tí ó wà ní inú àgọ́ ìpàdé, ni kí Aaroni ti tan iná náà níwájú Olúwa, láti ìrọ̀lẹ́ di àárọ̀ lójoojúmọ́. Èyí yóò jẹ́ ìlànà ayérayé fún àwọn ìran tí ń bọ̀. ");
INSERT INTO yor_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Àwọn Àtùpà tí wọ́n wà lórí ojúlówó ọ̀pá fìtílà tí a fi wúrà ṣe níwájú Olúwa ni kí ó máa jó lójoojúmọ́. ");
INSERT INTO yor_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Mú ìyẹ̀fun dáradára, kí o sì ṣe ìṣù àkàrà méjìlá, kí o lo ìdá méjì nínú mẹ́wàá òsùwọ̀n efa (èyí jẹ́ lita mẹ́rin ààbọ̀) fún ìṣù kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Tò wọ́n sí ọ̀nà ìlà méjì, mẹ́fà mẹ́fà ní ìlà kọ̀ọ̀kan lórí tábìlì tí a fi ojúlówó wúrà bọ̀. Èyí tí ó wà níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ẹ fi ojúlówó tùràrí sí ọnà kọ̀ọ̀kan, gẹ́gẹ́ bí ìpín ìrántí láti dípò àkàrà, àti láti jẹ ẹbọ sísun sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Àkàrà yìí ni kí ẹ gbé wá síwájú Olúwa nígbàkígbà, lọ́ṣọ̀ọ̀ṣẹ̀, nítorí tí àwọn ọmọ Israẹli gẹ́gẹ́ bí májẹ̀mú ayérayé. ");
INSERT INTO yor_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Aaroni àti àwọn ọmọ rẹ̀ ló ni í. Wọ́n gbọdọ̀ jẹ ẹ́ ní ibi mímọ́ torí pé ó jẹ́ ipa tí ó mọ́ jùlọ ti ìpín wọn ojoojúmọ́ nínú ọrẹ tí a fi iná ṣe sí Olúwa.” ");
INSERT INTO yor_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ọmọkùnrin kan wà tí ìyá rẹ̀ jẹ́ ọmọ Israẹli baba rẹ̀ sì jẹ́ ará Ejibiti. Ó jáde lọ láàrín àwọn ọmọ Israẹli, ìjà sì ṣẹlẹ̀ nínú àgọ́ láàrín òun àti ọmọ Israẹli kan. ");
INSERT INTO yor_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ọmọkùnrin arábìnrin Israẹli náà sọ̀rọ̀-òdì sí orúkọ Olúwa pẹ̀lú èpè, wọ́n sì mú un tọ Mose wá. (Orúkọ ìyá rẹ̀ ní Ṣelomiti, ọmọbìnrin Debiri, ti ẹ̀yà Dani.) ");
INSERT INTO yor_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Wọ́n fi í sínú túbú kí Olúwa to sọ ohun tí wọn yóò ṣe fún wọn. ");
INSERT INTO yor_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Olúwa sì sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mú asọ̀rọ̀-òdì náà jáde wá sẹ́yìn àgọ́, kí gbogbo àwọn tí ó gbọ́ pé ó ṣépè gbé ọwọ́ wọn lórí ọkùnrin náà láti fihàn pé ó jẹ̀bi. Lẹ́yìn náà ni kí gbogbo àpéjọpọ̀, sọ ọ́ ní òkúta pa. ");
INSERT INTO yor_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Sọ fún àwọn ará Israẹli pé, ‘Bí ẹnikẹ́ni bá ṣépè lé Ọlọ́run rẹ̀, yóò jìyà ẹ̀ṣẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ẹnikẹ́ni tí ó bá sọ̀rọ̀-òdì sí orúkọ Olúwa ni kí ẹ pa, kí gbogbo àpéjọpọ̀ sọ ọ́ ní òkúta pa, yálà àlejò ni tàbí ọmọ bíbí Israẹli, bí ó bá ti sọ̀rọ̀-òdì sí orúkọ Olúwa, pípa ni kí ẹ pa á. ");
INSERT INTO yor_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Ẹni tí ó bá gba ẹ̀mí ènìyàn pípa ni kí ẹ pa á. ");
INSERT INTO yor_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ẹni tí ó bá gba ẹ̀mí ẹran ọ̀sìn ẹlòmíràn, kí ó dá a padà—ẹ̀mí dípò ẹ̀mí. ");
INSERT INTO yor_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Bí ẹnìkan bá pa ẹnìkejì rẹ̀ lára, ohunkóhun tí ó ṣe ni kí ẹ ṣe sí i. ");
INSERT INTO yor_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ẹ̀yà fún ẹ̀yà, ojú fún ojú, eyín fún eyín; bí òun ti ṣe àbùkù sí ara ènìyàn, bẹ́ẹ̀ ni kí a ṣe sí i. ");
INSERT INTO yor_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ẹni tí ó bá sì lu ẹran pa, kí ó sán an padà; ẹni tí ó bá sì lu ènìyàn pa, a ó pa á. ");
INSERT INTO yor_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Òfin kan náà ló wà fún àlejò àti fún ọmọ Israẹli. Èmi ni Olúwa Ọlọ́run yín.’ ” ");
INSERT INTO yor_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Nígbà náà ni Mose sọ fún àwọn ọmọ Israẹli, wọ́n sì mú asọ̀rọ̀-òdì náà lọ sí ẹ̀yìn àgọ́, wọ́n sì sọ ọ́ ní òkúta pa. Àwọn ọmọ Israẹli sì ṣe ohun tí Olúwa pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Olúwa sọ fún Mose ní orí òkè Sinai pé, ");
INSERT INTO yor_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Sọ fún àwọn ọmọ Israẹli, kí o sì wí fún wọn pé, ‘Nígbà tí ẹ bá dé ilẹ̀ náà tí èmi ó fi fún yín, ilẹ̀ náà gbọdọ̀ sinmi fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ọdún mẹ́fà ni ìwọ ó fi gbin oko rẹ, ọdún mẹ́fà ni ìwọ ó fi tọ́jú ọgbà àjàrà rẹ, tí ìwọ ó sì fi kó èso wọn jọ. ");
INSERT INTO yor_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ṣùgbọ́n ní ọdún keje kí ilẹ̀ náà ní ìsinmi: ìsinmi fún Olúwa. Bẹ́ẹ̀ ni ìwọ kò gbọdọ̀ tọ́jú ọgbà àjàrà rẹ. ");
INSERT INTO yor_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ẹ má ṣe kórè ohun tí ó tìkára rẹ̀ hù, ẹ má ṣe kórè èso àjàrà ọgbà tí ẹ ò tọ́jú. Ilẹ̀ náà gbọdọ̀ ní ìsinmi fún ọdún kan. ");
INSERT INTO yor_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ohunkóhun tí ilẹ̀ náà bá mú jáde ní ọdún ìsinmi ni yóò jẹ́ oúnjẹ fún yín àní fún ẹ̀yin tìkára yín, àwọn ìránṣẹ́kùnrin àti ìránṣẹ́bìnrin yín, àwọn alágbàṣe àti àwọn tí ń gbé pẹ̀lú yín fún ìgbà díẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Fún àwọn ohun ọ̀sìn yín, àti àwọn ẹranko búburú ní ilẹ̀ yín. Ohunkóhun tí ilẹ̀ náà bá mú jáde ní ẹ lè jẹ. ");
INSERT INTO yor_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Ọdún ìsinmi méje èyí tí í ṣe ọdún mọ́kàndínláàádọ́ta (49) ni kí ẹ kà. ");
INSERT INTO yor_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Lẹ́yìn náà, kí ẹ fọn fèrè ní gbogbo ibikíbi ní ọjọ́ kẹwàá oṣù keje ní ọjọ́ ìwẹ̀nùmọ́. Ní ọjọ́ ètùtù yìí, ẹ fọn fèrè yíká gbogbo ilẹ̀ yín. ");
INSERT INTO yor_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ẹ ya àádọ́ta ọdún náà sọ́tọ̀ kí ẹ sì kéde òmìnira fún gbogbo ẹni tí ń gbé ilẹ̀ náà. Yóò jẹ́ ọdún ìdásílẹ̀ fún yín. Kí olúkúlùkù padà sí ilẹ̀ ìní rẹ̀ àti sí ọ̀dọ̀ àwọn ẹbí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Àádọ́ta ọdún ni yóò jẹ́ ọdún ìdásílẹ̀ fún yín. Ẹ má ṣe gbin ohunkóhun, ẹ kò sì gbọdọ̀ kórè ohun tí ó hù fúnra rẹ̀ tàbí kí ẹ kórè ọgbà àjàrà tí ẹ kò dá. ");
INSERT INTO yor_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Torí pé ọdún ìdásílẹ̀ ni ó sì gbọdọ̀ jẹ́ mímọ́ fún yín. Ẹ jẹ ohun tí ẹ mú jáde nínú oko náà. ");
INSERT INTO yor_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Ní ọdún ìdásílẹ̀ yìí, kí olúkúlùkù gbà ohun ìní rẹ̀ padà. ");
INSERT INTO yor_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Bí ẹ bá ta ilẹ̀ fún ọ̀kan nínú àwọn ènìyàn yín tàbí bí ẹ bá ra èyíkéyìí láti ọ̀dọ̀ rẹ̀, ẹ má ṣe rẹ́ ara yín jẹ. ");
INSERT INTO yor_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kí ẹ ra ilẹ̀ lọ́wọ́ àwọn ènìyàn yín ní gẹ́gẹ́ bí iye owó tí ó kù kí ọdún ìdásílẹ̀ pé, kí òun náà sì ta ilẹ̀ fún yín gẹ́gẹ́ bí iye ọdún rẹ̀ tókù láti kórè. ");
INSERT INTO yor_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Bí iye ọdún rẹ̀ bá gùn, kí iye owó rẹ̀ pọ̀, bí iye ọdún rẹ̀ bá kúrú, kí iye owó rẹ̀ kéré, torí pé ohun tí ó tà gan an ní iye èso rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ẹ má ṣe rẹ́ ara yín jẹ, ṣùgbọ́n ẹ bẹ̀rù Ọlọ́run. Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Ẹ tẹ̀lé àwọn ìlànà mi, kí ẹ sì kíyèsi láti pa òfin mi mọ́, kí ẹ ba à le máa gbé láìléwu ní ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Nígbà yìí ni ilẹ̀ náà yóò so èso rẹ̀, ẹ ó sì jẹ àjẹyó, ẹ ó sì máa gbé láìléwu. ");
INSERT INTO yor_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ẹ le béèrè pé, “Kí ni àwa ó jẹ ní ọdún keje, bí a kò bá gbin èso tí a kò sì kórè?” ");
INSERT INTO yor_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Èmi ó pèsè ìbùkún sórí yín tó bẹ́ẹ̀ tí ilẹ̀ yín yóò so èso tó tó fún ọdún mẹ́ta lẹ́yìn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Bí ẹ bá gbin èso yín ní ọdún kẹjọ, àwọn èso ti tẹ́lẹ̀ ní ẹ ó máa jẹ, títí tí ìkórè ti ọdún kẹsànán yóò fi dé. ");
INSERT INTO yor_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Ẹ má ṣe ta ilẹ̀ yín ní àtàpa torí pé ẹ̀yin kọ́ lẹ ni ín, ti Ọlọ́run ni, ẹ̀yin jẹ́ àjèjì àti ayálégbé. ");
INSERT INTO yor_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ní gbogbo orílẹ̀-èdè ìní yín, ẹ fi ààyè sílẹ̀ fún ìràpadà ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Bí ọ̀kan nínú àwọn ènìyàn yín bá tálákà, dé bi pé ó ta ara àwọn ẹrù rẹ̀, kí ará ilé rẹ̀ tí ó súnmọ́ ọ ra ohun tí ó tà padà. ");
INSERT INTO yor_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ẹni tí kò ní ẹni tó lè rà á padà fún un, tí òun fúnra rẹ̀ sì ti lọ́rọ̀, tí ó sì ní ànító láti rà á. ");
INSERT INTO yor_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Kí ó mọ iye owó tí ó jẹ fún iye ọdún tí ó tà á, kí ó dá iye tí ó kù padà fún ẹni tí ó tà á fún, lẹ́yìn náà, ó lè padà sí ilẹ̀ ìní rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ṣùgbọ́n bí kò bá rí ọ̀nà àti san án padà fún un. Ohun tí ó tà wà ní ìkáwọ́ ẹni tí ó rà á títí di ọdún ìdásílẹ̀. Kí ó dá a padà fún ẹni tí ó ni i ní ọdún ìdásílẹ̀, ẹni tí ó ni í tẹ́lẹ̀ lè tún padà gbà ohun ìní rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Bí arákùnrin kan bá ta ilé gbígbé kan ní ìlú olódi, kí ó rà á padà ní ìwọ̀n ọdún kan sí àkókò tí ó tà á, ní ìwọ̀n ọdún kan ni kí ó rà á padà. ");
INSERT INTO yor_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ṣùgbọ́n bí kò bá rà á padà láàrín ọdún náà ilé náà tí ó wà láàrín ìlú ni kí ó yọ̀ǹda pátápátá fún ẹni tí ó rà á, àti àwọn ìdílé rẹ̀. Kí wọ́n má da padà ní ọdún ìdásílẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ṣùgbọ́n àwọn ilé tí ó wà ní abúlé láìní odi ni kí a kà gẹ́gẹ́ bí ilẹ̀ oko, a lè rà wọ́n padà, kí wọ́n sì da padà ní ọdún ìdásílẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Àwọn ọmọ Lefi ní ẹ̀tọ́, nígbàkígbà láti ra ilẹ̀ wọn, tí ó jẹ́ ohun ìní wọn ní àwọn ìlú tí ó jẹ́ ti ọmọ Lefi. ");
INSERT INTO yor_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Torí náà ohun ìní àwọn ọmọ Lefi ni wọ́n rà padà, fún àpẹẹrẹ, èyí ni pé ilẹ̀ tí a bá tà ní ìlúkílùú tí ó jẹ́ tiwọn, ó sì gbọdọ̀ di dídápadà ní ọdún ìdásílẹ̀, torí pé àwọn ilẹ̀ tí ó wà ní ìlú àwọn Lefi ni ìní wọn láàrín àwọn ará Israẹli. ");
INSERT INTO yor_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ṣùgbọ́n ilẹ̀ tí wọ́n ti ń da ẹran tí ó jẹ́ ti ìlú wọn, wọn kò gbọdọ̀ tà wọ́n, ilẹ̀ ìní wọn láéláé ni. ");
INSERT INTO yor_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Bí arákùnrin yín kan bá tálákà tí kò sì le è pèsè fún àìní ara rẹ̀, ẹ pèsè fún un bí ẹ ti ń ṣe fún àwọn àlejò tàbí àwọn tí ẹ gbà sílé: kí ó ba à le è máa gbé láàrín yín. ");
INSERT INTO yor_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ẹ kò gbọdọ̀ gba èlé kankan lọ́wọ́ rẹ̀, ẹ bẹ̀rù Olúwa kí arákùnrin yín le è máa gbé láàrín yín. ");
INSERT INTO yor_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ẹ má ṣe gba èlé lórí owó tí ẹ yá a bẹ́ẹ̀ ni ẹ kò gbọdọ̀ jẹ èrè lórí oúnjẹ tí ẹ tà fún un. ");
INSERT INTO yor_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Èmi ni Olúwa Ọlọ́run yín tí ó mú yín jáde láti ilẹ̀ Ejibiti láti fún yín ní ilẹ̀ Kenaani àti láti jẹ́ Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Bí arákùnrin yín kan bá tálákà dé bi pé ó ta ara rẹ̀ fún ọ bí ẹrú. Má ṣe lò ó bí ẹrú. ");
INSERT INTO yor_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Jẹ́ kí ó wà lọ́dọ̀ rẹ bí alágbàṣe tàbí àlejò láàrín yín, kí ó máa ṣiṣẹ́ sìn ọ́ títí di ọdún ìdásílẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Nígbà náà ni kí ó yọ̀ǹda òun àti àwọn ọmọ rẹ̀, kí wọ́n padà sí ìdílé wọn àti sí ilẹ̀ ìní baba wọn. ");
INSERT INTO yor_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Torí pé ìránṣẹ́ mi ni àwọn ará Israẹli jẹ́. Ẹni tí mo mú jáde láti ilẹ̀ Ejibiti wá, torí èyí ẹ kò gbọdọ̀ tà wọ́n lẹ́rú. ");
INSERT INTO yor_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ẹ má ṣe rorò mọ́ wọn: ṣùgbọ́n ẹ bẹ̀rù Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Àwọn ẹrúkùnrin àti ẹrúbìnrin yín lè jẹ́ láti orílẹ̀-èdè tí ó yí yín ká, ẹ lè ra àwọn ẹrú wọ̀nyí lọ́wọ́ wọn. ");
INSERT INTO yor_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Bákan náà, ẹ sì le è ra àwọn àlejò tí ń gbé láàrín yín, àti àwọn ìdílé wọn tí a bí sáàrín yín. Wọn yóò sì di ohun ìní yín. ");
INSERT INTO yor_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ẹ lè fi wọ́n sílẹ̀ bí ogún fún àwọn ọmọ yín, wọ́n sì lè sọ wọ́n di ẹrú títí láé. Ṣùgbọ́n ẹ kò gbọdọ̀ rorò mọ́ ọmọ Israẹli kankan. ");
INSERT INTO yor_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Bí àlejò kan láàrín yín tàbí ẹni tí ń gbé àárín yín fún ìgbà díẹ̀ bá lọ́rọ̀ tí ọmọ Israẹli sì tálákà dé bi pé ó ta ara rẹ̀ lẹ́rú fún àlejò tàbí ìdílé àlejò náà. ");
INSERT INTO yor_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Ó lẹ́tọ̀ọ́ si ki a rà á padà lẹ́yìn ìgbà tí ó ti ta ara rẹ̀. Ọ̀kan nínú ìbátan rẹ̀ le è rà á padà. ");
INSERT INTO yor_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Àbúrò baba rẹ̀ ọkùnrin tàbí àbúrò rẹ̀ obìnrin tàbí ẹnikẹ́ni tí ó bá tan nínú ìdílé rẹ̀ le è rà wọ̀n padà. Bí ó bá sì ti lọ́rọ̀, ó lè ra ara rẹ̀ padà. ");
INSERT INTO yor_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Kí òun àti olówó rẹ̀ ka iye ọdún tí ó ta ara rẹ̀ títí dé ọdún ìdásílẹ̀ kí iye owó ìdásílẹ̀ rẹ̀ jẹ́ iye tí wọ́n ń san lórí alágbàṣe fún iye ọdún náà. ");
INSERT INTO yor_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Bí iye ọdún rẹ̀ tí ó ṣẹ́kù bá pọ̀, kí iye owó fún ìràpadà rẹ̀ pọ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Bí ó bá sì ṣe pé kìkì ọdún díẹ̀ ni ó kù títí di ọdún jubili, kí ó ṣe ìṣirò rẹ̀, kí ó sì san owó náà bí iye ìṣirò rẹ̀ padà. ");
INSERT INTO yor_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Bí ẹ ti ń ṣe sí i lọ́dọọdún, ẹ rí i dájú pé olówó rẹ̀ kò korò mọ́ ọ. ");
INSERT INTO yor_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Bí a kò bá rà á padà nínú gbogbo ọ̀nà wọ̀nyí, kí ẹ tú òun àti àwọn ọmọ rẹ̀ sílẹ̀ ní ọdún ìdásílẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Nítorí pé ìránṣẹ́ ni àwọn ọmọ Israẹli jẹ́ fún mi. Ìránṣẹ́ mi ni wọ́n, tí mo mú jáde láti Ejibiti wá. Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Ẹ̀yin kò gbọdọ̀ mọ ère òrìṣà, tàbí kí ẹ̀yin gbe ère kalẹ̀ tàbí kí ẹ̀yin gbẹ́ ère òkúta: kí ẹ̀yin má sì gbẹ́ òkúta tí ẹ̀yin yóò gbé kalẹ̀ láti sìn. Èmi ni Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Ẹ pa ọjọ́ ìsinmi mi mọ́ kí ẹ̀yin sì bọ̀wọ̀ fún ibi mímọ́ mi. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Bí ẹ̀yin bá tẹ̀lé àṣẹ mi, tí ẹ̀yin sì ṣọ́ra láti pa òfin mi mọ́. ");
INSERT INTO yor_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Èmi yóò rọ̀jò fún yín ní àkókò rẹ̀, kí ilẹ̀ yín le mú èso rẹ̀ jáde bí ó tí yẹ kí àwọn igi eléso yín so èso. ");
INSERT INTO yor_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Èrè oko yín yóò pọ̀ dé bi pé ẹ ó máa pa ọkà títí di àsìkò ìkórè igi eléso, ẹ̀yin yóò sì máa gbé ní ilẹ̀ yín láìléwu. ");
INSERT INTO yor_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Èmi yóò fún yín ní àlàáfíà ní ilẹ̀ yín, ẹ̀yin yóò sì sùn láìsí ìbẹ̀rù ẹnikẹ́ni. Èmi yóò mú kí gbogbo ẹranko búburú kúrò ní ilẹ̀ náà, bẹ́ẹ̀ ni idà kì yóò la ilẹ̀ yín já. ");
INSERT INTO yor_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ẹ̀yin yóò lé àwọn ọ̀tá yín, wọn yóò sì tipa idà kú. ");
INSERT INTO yor_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Àwọn márùn-ún péré nínú yín yóò máa ṣẹ́gun ọgọ́rùn-ún ènìyàn, àwọn ọgọ́rùn-ún yóò sì máa ṣẹ́gun ẹgbẹ̀rún mẹ́wàá (10,000), àwọn ọ̀tá yín yóò tipa idà kú níwájú yín. ");
INSERT INTO yor_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Èmi yóò fi ojúrere wò yín, Èmi yóò mú kí ẹ bí sí i, Èmi yóò jẹ́ kí ẹ pọ̀ sí i, Èmi yóò sì pa májẹ̀mú mi mọ́ pẹ̀lú yín. ");
INSERT INTO yor_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Àwọn èrè oko yín yóò pọ̀ tó bẹ́ẹ̀ tí ẹ̀yin ó máa jẹ èrè ọdún tí ó kọjá, ẹ̀yin ó sì kó wọn jáde, kí ẹ̀yin lè rí ààyè kó tuntun sí. ");
INSERT INTO yor_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Èmi yóò kọ́ àgọ́ mímọ́ mi sí àárín yín. Èmi kò sì ní kórìíra yín. ");
INSERT INTO yor_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Èmi yóò wà pẹ̀lú yín, Èmi yóò máa jẹ́ Ọlọ́run yín, ẹ̀yin yóò sì máa jẹ́ ènìyàn mi. ");
INSERT INTO yor_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Èmi ni Olúwa Ọlọ́run yín tí ó mú yín jáde kúrò ní ilẹ̀ Ejibiti, kí ẹ̀yin má ba à jẹ́ ẹrú fún wọn mọ́. Mo sì já ìdè àjàgà yín, mo sì mú kí ẹ̀yin máa rìn gẹ́gẹ́ bí ẹni tí a gbé lórí sókè. ");
INSERT INTO yor_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Bí ẹ̀yin kò bá fetí sí mi tí ẹ̀yin kò sì ṣe gbogbo òfin wọ̀nyí. ");
INSERT INTO yor_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Bí ẹ̀yin bá kọ àṣẹ mi tí ẹ̀yin sì kórìíra òfin mi, tí ẹ̀yin sì kùnà láti pa ìlànà mi mọ́, nípa èyí tí ẹ̀yin ti ṣẹ̀ sí májẹ̀mú mi. ");
INSERT INTO yor_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Èmi yóò ṣe àwọn nǹkan wọ̀nyí sí yín, Èmi yóò mú ìpayà òjijì bá yín: àwọn ààrùn afiniṣòfò, àti ibà afọ́nilójú, tí í pa ni díẹ̀díẹ̀. Ẹ̀yin yóò gbin èso ilẹ̀ yín lásán, nítorí pé àwọn ọ̀tá yín ni yóò jẹ gbogbo ohun tí ẹ̀yin ti gbìn. ");
INSERT INTO yor_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Èmi yóò dojúkọ yín títí tí ẹ̀yin ó fi di ẹni ìkọlù; àwọn tí ó kórìíra yín ni yóò sì ṣe àkóso lórí yín. Ìbẹ̀rù yóò mú yín dé bi pé ẹ̀yin yóò máa sá káàkiri nígbà tí ẹnikẹ́ni kò lé yín. ");
INSERT INTO yor_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Bí ẹ̀yin kò bá wá gbọ́ tèmi lẹ́yìn gbogbo èyí, Èmi yóò fi kún ìyà yín ní ìlọ́po méje nítorí ẹ̀ṣẹ̀ yín. ");
INSERT INTO yor_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Èmi yóò fọ́ agbára ìgbéraga yín, ojú ọ̀run yóò le koko bí irin, ilẹ̀ yóò sì le bí idẹ (òjò kò ní rọ̀: ilẹ̀ yín yóò sì le). ");
INSERT INTO yor_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ẹ ó máa lo agbára yín lásán torí pé ilẹ̀ yín kì yóò so èso, bẹ́ẹ̀ ni àwọn igi yín kì yóò so èso pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Bí ẹ bá tẹ̀síwájú láì gbọ́ tèmi, Èmi yóò tún fa ìjayà yín le ní ìgbà méje gẹ́gẹ́ bí ẹ̀ṣẹ̀ yín. ");
INSERT INTO yor_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Èmi yóò rán àwọn ẹranko búburú sí àárín yín, wọn yóò sì pa àwọn ọmọ yín, wọn yóò run agbo ẹran yín, díẹ̀ nínú yín ni wọn yóò ṣẹ́kù kí àwọn ọ̀nà yín lè di ahoro. ");
INSERT INTO yor_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Bí ẹ kò bá tún yípadà lẹ́yìn gbogbo ìjìyà wọ̀nyí, tí ẹ sì tẹ̀síwájú láti lòdì sí mi. ");
INSERT INTO yor_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Èmi náà yóò lòdì sí yín. Èmi yóò tún fa ìjìyà yín le ní ìlọ́po méje ju ti ìṣáájú. ");
INSERT INTO yor_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Èmi yóò mú idà wá bá yín nítorí ẹ̀ṣẹ̀ yín láti fi gbẹ̀san májẹ̀mú mi tí ẹ kò pamọ́. Bí ẹ ba sálọ sí ìlú yín fún ààbò, Èmi yóò rán àjàkálẹ̀-ààrùn sí àárín yín, àwọn ọ̀tá yín, yóò sì ṣẹ́gun yín. ");
INSERT INTO yor_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Èmi yóò dá ìpèsè oúnjẹ yín dúró, dé bi pé: inú ààrò kan ni obìnrin mẹ́wàá yóò ti máa se oúnjẹ yín. Òsùwọ̀n ni wọn yóò fi máa yọ oúnjẹ yín, ẹ ó jẹ ṣùgbọ́n, ẹ kò ní yó. ");
INSERT INTO yor_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Lẹ́yìn gbogbo èyí, bí ẹ kò bá gbọ́ tèmi, tí ẹ sì lòdì sí mi, ");
INSERT INTO yor_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ní ìbínú mi, èmi yóò korò sí yín, èmi tìkára mi yóò fìyà jẹ yín ní ìgbà méje nítorí ẹ̀ṣẹ̀ yín. ");
INSERT INTO yor_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ebi náà yóò pa yín dé bi pé ẹ ó máa jẹ ẹran-ara àwọn ọmọ yín ọkùnrin, àti àwọn ọmọ yín obìnrin. ");
INSERT INTO yor_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Èmi yóò wó àwọn pẹpẹ òrìṣà yín, lórí òkè níbi tí ẹ ti ń sìn, Èmi yóò sì kó òkú yín jọ, sórí àwọn òkú òrìṣà yín. Èmi ó sì kórìíra yín. ");
INSERT INTO yor_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Èmi yóò sọ àwọn ìlú yín di ahoro, èmi yóò sì ba àwọn ilé mímọ́ yín jẹ́. Èmi kì yóò sì gbọ́ òórùn dídùn yín mọ́. ");
INSERT INTO yor_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Èmi yóò pa ilẹ̀ yín run dé bi pé ẹnu yóò ya àwọn ọ̀tá yín tí ó bá gbé ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Èmi yóò sì tú yín ká sínú àwọn orílẹ̀-èdè, Èmi yóò sì yọ idà tì yín lẹ́yìn, ilẹ̀ yín yóò sì di ahoro, àwọn ìlú yín ni a ó sì parun. ");
INSERT INTO yor_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Ilẹ̀ náà yóò ní ìsinmi fún gbogbo ìgbà tí ẹ fi wà ní ilẹ̀ àjèjì tí ẹ kò fi lò ó. Ilẹ̀ náà yóò sinmi láti fi dípò ọdún tí ẹ kọ̀ láti fún un. ");
INSERT INTO yor_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Níwọ́n ìgbà tí ẹ kò lò ó, ilẹ̀ náà yóò ní ìsinmi tí kò ní lákòókò ìsinmi rẹ̀ lákokò tí ẹ fi ń gbé orí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Èmi yóò jẹ́ kí ó burú fún àwọn tí ó wà ní ilẹ̀ ìgbèkùn dé bi pé ìró ewé tí ń mì lásán yóò máa lé wọn sá. Ẹ ó máa sá bí ẹni tí ń sá fún idà. Ẹ ó sì ṣubú láìsí ọ̀tá láyìíká yín. ");
INSERT INTO yor_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Wọn yóò máa ṣubú lu ara wọn, bí ẹni tí ń sá fún idà nígbà tí kò sí ẹni tí ń lé yín. Ẹ̀yin kì yóò sì ní agbára láti dúró níwájú ọ̀tá yín. ");
INSERT INTO yor_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ẹ̀yin yóò ṣègbé láàrín àwọn orílẹ̀-èdè abọ̀rìṣà. Ilẹ̀ ọ̀tá yín yóò sì jẹ yín run. ");
INSERT INTO yor_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Àwọn tí ó ṣẹ́kù nínú yín ni yóò ṣòfò dànù ní ilẹ̀ ọ̀tá yín torí ẹ̀ṣẹ̀ yín àti ti àwọn baba ńlá yín. ");
INSERT INTO yor_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Bí wọ́n bá jẹ́wọ́ ẹ̀ṣẹ̀ wọn àti ti baba ńlá wọn, ìwà ìṣọ̀tẹ̀ wọn àti bí wọ́n ti ṣe lòdì sí mi. ");
INSERT INTO yor_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Èyí tó mú mi lòdì sí wọn tí mo fi kó wọn lọ sí ilẹ̀ àwọn ọ̀tá wọn. Nígbà tí wọ́n bá rẹ àìkọlà àyà wọn sílẹ̀ tí wọ́n bá sì gba ìbáwí ẹ̀ṣẹ̀ wọn. ");
INSERT INTO yor_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Nígbà náà ni Èmi yóò rántí májẹ̀mú mi pẹ̀lú Jakọbu àti pẹ̀lú Isaaki àti pẹ̀lú Abrahamu, Èmi yóò sì rántí ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Àwọn ènìyàn náà yóò sì fi ilẹ̀ náà sílẹ̀, yóò sì ní ìsinmi rẹ̀ nígbà tí ó bá wà lófo láìsí wọn níbẹ̀. Wọn yóò sì jìyà ẹ̀ṣẹ̀ wọn torí pé wọ́n kọ àwọn òfin mi. Wọ́n sì kórìíra àwọn àṣẹ mi. ");
INSERT INTO yor_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Pẹ̀lú gbogbo nǹkan wọ̀nyí, nígbà tí wọ́n bá wà nílé àwọn ọ̀tá wọn, èmi kì yóò ta wọ́n nù, bẹ́ẹ̀ ni èmi kì yóò kórìíra wọn pátápátá, èyí tí ó lè mú mi dá májẹ̀mú mi pẹ̀lú wọn. Èmi ni Olúwa Ọlọ́run wọn. ");
INSERT INTO yor_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nítorí wọn, èmi ó rántí májẹ̀mú mi tí mo ti ṣe pẹ̀lú baba ńlá wọn. Àwọn tí mo mú jáde kúrò ní ilẹ̀ Ejibiti lójú gbogbo àwọn orílẹ̀-èdè láti jẹ́ Ọlọ́run wọn. Èmi ni Olúwa.’ ” ");
INSERT INTO yor_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ìwọ̀nyí ni òfin àti ìlànà tí Olúwa fún Mose ní orí òkè Sinai láàrín òun àti àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Olúwa sọ fún Mose pé. ");
INSERT INTO yor_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Sọ fún àwọn ọmọ Israẹli pé, ‘Bí ẹnìkan bá jẹ́ ẹ̀jẹ́ pàtàkì láti ya ènìyàn kan sọ́tọ̀ fún Olúwa nípa sísan iye tí ó tó, ");
INSERT INTO yor_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","kí iye owó ọkùnrin láti ọmọ ogún ọdún sí ọgọ́ta ọdún jẹ́ àádọ́ta òsùwọ̀n ṣékélì fàdákà, gẹ́gẹ́ bí òsùwọ̀n ṣékélì ti ibi mímọ́ Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Bí ẹni náà bá jẹ obìnrin, kí iye owó rẹ̀ jẹ́ ọgbọ̀n òsùwọ̀n ṣékélì. ");
INSERT INTO yor_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Bí ẹni náà bá jẹ́ ọmọ ọdún márùn-ún sí ogún ọdún, kí iye owó rẹ̀ jẹ́ ogún ṣékélì fún ọkùnrin àti òsùwọ̀n ṣékélì mẹ́wàá fún obìnrin. ");
INSERT INTO yor_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Bí ẹni náà bá jẹ́ ọmọ oṣù kan sí ọdún márùn-ún, kí iye owó rẹ̀ jẹ́ òsùwọ̀n ṣékélì fàdákà márùn-ún fún ọkùnrin àti òsùwọ̀n ṣékélì fàdákà mẹ́ta fún obìnrin. ");
INSERT INTO yor_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Bí ẹni náà bá jẹ́ ọmọ ọgọ́ta ọdún àti jù bẹ́ẹ̀ lọ, kí iye owó rẹ̀ jẹ́ òsùwọ̀n ṣékélì mẹ́ẹ̀ẹ́dógún fún ọkùnrin àti òsùwọ̀n ṣékélì mẹ́wàá fún obìnrin. ");
INSERT INTO yor_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Bí ẹnìkan tí ó jẹ́ ẹ̀jẹ́ bá tálákà púpọ̀ dé bi pé kò lè san iye owó náà, kí a mú ẹni náà wá síwájú àlùfáà, àlùfáà yóò sì dá iye owó tí ó lè san lé e gẹ́gẹ́ bí agbára ẹni náà tí ó jẹ́ ẹ̀jẹ́. ");
INSERT INTO yor_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Bí ẹ̀jẹ́ tí ó jẹ́ bá jẹ́ ẹranko èyí tí ó jẹ́ ìtẹ́wọ́gbà gẹ́gẹ́ bí ọrẹ fún Olúwa, irú ẹran bẹ́ẹ̀ tí a bá fi fún Olúwa di mímọ́. ");
INSERT INTO yor_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ẹni tí ó jẹ́ ẹ̀jẹ́ náà kò gbọdọ̀ pàrọ̀ ẹran mìíràn, yálà kí ó pàrọ̀ èyí tí ó dára sí èyí tí kò dára tàbí èyí tí kò dára sí èyí tí ó dára. Bí ó bá ṣe bẹ́ẹ̀ ti Olúwa ni ẹranko méjèèjì. ");
INSERT INTO yor_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ṣùgbọ́n bí ó bá jẹ́ ẹ̀jẹ́ ní ti ẹranko àìmọ́ tí a fi tọrẹ: èyí tí kò jẹ́ ìtẹ́wọ́gbà bí i ọrẹ fún Olúwa. Kí ọkùnrin náà mú ọrẹ náà lọ fún àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Kí àlùfáà díye lé e, gẹ́gẹ́ bí ó ti dára tàbí bí ó ti bàjẹ́ sí. Iye owó náà ni kí ó jẹ́. ");
INSERT INTO yor_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Bí ẹni náà bá fẹ́ rà á padà, ó gbọdọ̀ san iye owó rẹ̀ àti ìdá ogún iye owó náà láfikún. ");
INSERT INTO yor_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Bí ẹnikẹ́ni bá ya ilẹ̀ rẹ̀ sí mímọ́ fún Olúwa: kí àlùfáà kó sọ iye tí yóò san gẹ́gẹ́ bí ilẹ̀ náà ti dára tàbí bàjẹ́ sí, iye owó náà ni kí ó jẹ́. ");
INSERT INTO yor_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Bí ẹni tí ó yá ilé náà sí mímọ́ bá fẹ́ rà á padà. Jẹ́ kí ó fi ìdámárùn-ún owó ìdíyelé rẹ̀ kún ún, yóò si jẹ́ tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Bí ẹnìkan bá sì ya ara ilẹ̀ ìdílé rẹ̀ sí mímọ́ fún Olúwa. Iye tí ó bá jẹ́ ni kí wọ́n ṣètò gẹ́gẹ́ bí iye èso tí a ó fi gbìn ín. Àádọ́ta ṣékélì fàdákà fún òsùwọ̀n homeri irúgbìn barle. ");
INSERT INTO yor_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Bí ó ba ṣe pé ní ọdún ìdásílẹ̀ ni ó ya ilẹ̀ náà sí mímọ́. Iye owó tí wọn sọtẹ́lẹ̀ náà ni kí o san. ");
INSERT INTO yor_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Bí ó bá ya ilẹ̀ náà sí mímọ́ lẹ́yìn ọdún ìdásílẹ̀ kí àlùfáà sọ iye owó tí yóò san fún ọdún tókù kí ọdún ìdásílẹ̀ mìíràn tó pé iye owó tí ó gbọdọ̀ jẹ yóò dínkù. ");
INSERT INTO yor_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Bí ẹni tí ó ya ilẹ̀ sí mímọ́ bá fẹ́ rà á padà, kí ó san iye owó náà pẹ̀lú àfikún ìdámárùn-ún. Ilẹ̀ náà yóò sì di tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Bí kò bá ra ilẹ̀ náà padà tàbí bí ó bá tà á fún ẹlòmíràn kò le è ri rà padà mọ́. ");
INSERT INTO yor_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Bí a bá fi ilẹ̀ náà sílẹ̀ ní ọdún ìdásílẹ̀ yóò di mímọ́ gẹ́gẹ́ bí ilẹ̀ tí a fi fún Olúwa. Yóò sì di ohun ìní àlùfáà. ");
INSERT INTO yor_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Bí ẹnikẹ́ni bá ya ilẹ̀ tí ó ti rà tí kì í ṣe ilẹ̀ ìdílé rẹ̀ sí mímọ́ fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Kí àlùfáà sọ iye tí ó tọ títí di ọdún ìdásílẹ̀. Kí ọkùnrin náà sì san iye owó náà ní ọjọ́ náà gẹ́gẹ́ bí ohun mímọ́ sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ní ọdún ìdásílẹ̀ ilẹ̀ náà yóò padà di ti ẹni tí ó ni í, lọ́wọ́ ẹni tí a ti rà á. ");
INSERT INTO yor_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Gbogbo iye owó wọ̀nyí gbọdọ̀ wà ní ìbámu pẹ̀lú ṣékélì ibi mímọ́, ogún gera. ");
INSERT INTO yor_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Kò sí ẹni tí ó gbọdọ̀ ya gbogbo àkọ́bí ẹran sọ́tọ̀. Èyí jẹ́ ti Olúwa nípasẹ̀ òfin àkọ́bí: yálà akọ màlúù ni tàbí àgùntàn, ti Olúwa ni. ");
INSERT INTO yor_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Bí ó bá jẹ́ ọ̀kan nínú àwọn ẹran tí kò mọ́, nígbà náà ni kí ó rà á padà gẹ́gẹ́ bí ìdíyelé rẹ̀, kí ó sì fi ìdámárùn-ún lé e, tàbí bí a kò bá rà á padà kí ẹ tà á gẹ́gẹ́ bí ìdíyelé rẹ̀. ");
INSERT INTO yor_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Ohun tí a bá yà sí mímọ́ pátápátá láti ọwọ́ ẹnikẹ́ni sí Olúwa tàbí ẹranko tàbí ilẹ̀ tí ó jogún, òun kò gbọdọ̀ tà á kí ó rà á padà. Gbogbo ohun ìyàsọ́tọ̀ bẹ́ẹ̀ di mímọ́ jùlọ fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Ẹni tí ẹ bá ti yà sọ́tọ̀ fún pípa, ẹnikẹ́ni kò gbọdọ̀ rà á padà, pípa ni kí ẹ pa á. ");
INSERT INTO yor_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Gbogbo ìdámẹ́wàá ilẹ̀ náà yálà tí èso ilẹ̀ ni, tàbí tí èso igi, ti Olúwa ni. Mímọ́ ni fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Bí ẹnikẹ́ni bá fẹ́ ra ìdámẹ́wàá nǹkan rẹ̀ padà, o gbọdọ̀ fi márùn-ún kún un. ");
INSERT INTO yor_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Gbogbo ìdámẹ́wàá àgbò àti ẹran ọ̀sìn, àní ìdámẹ́wàá ẹran tó bá kọjá lábẹ́ ọ̀pá darandaran kí ó jẹ́ mímọ́ fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ènìyàn kò gbọdọ̀ wádìí bóyá ó dára tàbí kò dára, kò sì gbọdọ̀ pààrọ̀ rẹ̀. Bí ó bá pààrọ̀ rẹ̀: àti èyí tí ó pààrọ̀ àti èyí tí ó fi pààrọ̀ ni kí ó jẹ́ mímọ́. Wọn kò gbọdọ̀ rà á padà.’ ” ");
INSERT INTO yor_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Àwọn àṣẹ wọ̀nyí ni Olúwa pa fún Mose fún àwọn ọmọ Israẹli ní orí òkè Sinai.");
INSERT INTO yor_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Olúwa bá Mose sọ̀rọ̀ ní aginjù Sinai nínú àgọ́ àjọ ní ọjọ́ kìn-ín-ní oṣù kejì ní ọdún kejì tí àwọn ọmọ Israẹli jáde kúrò ní ilẹ̀ Ejibiti, ó wí pé, ");
INSERT INTO yor_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Ka gbogbo àgbájọ ènìyàn Israẹli nípa ẹbí wọn, àti nípa ìdílé baba wọn, to orúkọ wọn olúkúlùkù ọkùnrin ní ọ̀kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Ìwọ àti Aaroni ni kí ẹ kà gbogbo ọmọkùnrin Israẹli gẹ́gẹ́ bí ìpín wọn láti ọmọ ogún ọdún sókè, àwọn tí ó tó lọ sójú ogun. ");
INSERT INTO yor_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Kí ẹ mú ọkùnrin kọ̀ọ̀kan láti inú olúkúlùkù ẹ̀yà kí ó sì wá pẹ̀lú yín, kí olúkúlùkù jẹ́ olórí ilé àwọn baba rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Orúkọ àwọn ọkùnrin tí yóò ràn ọ́ lọ́wọ́ nìyí: “Láti ọ̀dọ̀ Reubeni, Elisuri ọmọ Ṣedeuri. ");
INSERT INTO yor_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Láti ọ̀dọ̀ Simeoni, Ṣelumieli ọmọ Suriṣaddai. ");
INSERT INTO yor_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Láti ọ̀dọ̀ Juda, Nahiṣoni ọmọ Amminadabu. ");
INSERT INTO yor_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Láti ọ̀dọ̀ Isakari, Netaneli ọmọ Suari. ");
INSERT INTO yor_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Láti ọ̀dọ̀ Sebuluni, Eliabu ọmọ Heloni. ");
INSERT INTO yor_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Láti ọ̀dọ̀ àwọn ọmọ Josẹfu: láti ọ̀dọ̀ Efraimu, Eliṣama ọmọ Ammihudu. Láti ọ̀dọ̀ Manase, Gamalieli ọmọ Pedasuri. ");
INSERT INTO yor_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Láti ọ̀dọ̀ Benjamini, Abidani ọmọ Gideoni. ");
INSERT INTO yor_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Láti ọ̀dọ̀ Dani, Ahieseri ọmọ Ammiṣaddai. ");
INSERT INTO yor_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Láti ọ̀dọ̀ Aṣeri, Pagieli ọmọ Okanri. ");
INSERT INTO yor_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Láti ọ̀dọ̀ Gadi, Eliasafu ọmọ Deueli. ");
INSERT INTO yor_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Láti ọ̀dọ̀ Naftali, Ahira ọmọ Enani.” ");
INSERT INTO yor_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Àwọn wọ̀nyí ni wọ́n yàn nínú àwùjọ ènìyàn, olórí àwọn ẹ̀yà baba wọn. Àwọn ni olórí àwọn ẹbí Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mose àti Aaroni mú àwọn ènìyàn tí a dárúkọ wọ̀nyí ");
INSERT INTO yor_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","wọ́n sì pe gbogbo àwùjọ ènìyàn Israẹli jọ ní ọjọ́ kìn-ín-ní oṣù kejì. Àwọn ènìyàn sì dárúkọ baba ńlá wọn nípa ẹbí àti ìdílé wọn. Wọ́n sì ṣe àkọsílẹ̀ orúkọ àwọn ọmọkùnrin ní ọ̀kọ̀ọ̀kan láti ọmọ ogún ọdún sókè, ");
INSERT INTO yor_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. Bẹ́ẹ̀ náà ló ṣe kà wọ́n nínú aginjù Sinai. ");
INSERT INTO yor_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Láti ìran Reubeni tí í ṣe àkọ́bí Israẹli, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ogún ọdún sókè tí wọ́n lè lọ sójú ogun ni wọ́n to orúkọ wọn, lẹ́yọ kọ̀ọ̀kan gẹ́gẹ́ bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Àwọn tí a kà ní ẹ̀yà Reubeni jẹ́ ẹgbàá mẹ́tàlélógún ó lé ẹ̀ẹ́dẹ́gbẹ̀ta (46,500). ");
INSERT INTO yor_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Láti ìran Simeoni, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ogún ọdún sókè, tí wọ́n lè lọ sójú ogun ni wọ́n kà, wọ́n sì to orúkọ wọn lẹ́yọ kọ̀ọ̀kan gẹ́gẹ́ bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Iye àwọn tí á kà nínú ẹ̀yà Simeoni jẹ́ ẹgbàá mọ́kàndínlọ́gbọ̀n ó lé ọ̀ọ́dúnrún (59,300). ");
INSERT INTO yor_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Láti ìran Gadi, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ogún ọdún sókè tí wọ́n lè lọ sójú ogun ni wọ́n to orúkọ wọn lẹ́yọ kọ̀ọ̀kan, gẹ́gẹ́ bí ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Iye àwọn tí a kà nínú ẹ̀yà Gadi jẹ́ ẹgbàá méjìlélógún ó lé àádọ́talélẹ́gbẹ̀jọ (45,650). ");
INSERT INTO yor_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Láti ìran Juda, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ogún ọdún sókè, tí wọ́n le lọ sójú ogun ni wọ́n to orúkọ wọn lẹ́yọ kọ̀ọ̀kan gẹ́gẹ́ bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Iye tí a kà nínú ẹ̀yà Juda jẹ́ ẹgbàá mẹ́tàdínlógójì ó lé ẹgbẹ̀ta (74,600). ");
INSERT INTO yor_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Láti ìran Isakari, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ogún ọdún sókè tí wọ́n le lọ sójú ogun ni wọ́n to orúkọ wọn lẹ́yọ kọ̀ọ̀kan bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Iye tí a kà nínú ẹ̀yà Isakari jẹ́ ẹgbàá mẹ́tàdínlọ́gbọ̀n ó lé irinwó (54,400). ");
INSERT INTO yor_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Láti ìran Sebuluni, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ogún ọdún sókè tí wọ́n lè lọ sójú ogun ni wọ́n to orúkọ wọn lẹ́yọ kọ̀ọ̀kan gẹ́gẹ́ bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Iye tí a kà nínú ẹ̀yà Sebuluni jẹ́ ẹgbàá méjìdínlọ́gbọ̀n ó lé egbèje (57,400). ");
INSERT INTO yor_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Láti inú àwọn ọmọ Josẹfu. Láti ìran Efraimu, gbogbo ọmọkùnrin tí ọjọ́ orí wọ́n jẹ́ ogún ọdún sókè tí wọ́n lè lọ sójú ogun ni wọ́n to orúkọ wọn lẹ́yọ kọ̀ọ̀kan gẹ́gẹ́ bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Iye tí a kà nínú ẹ̀yà Efraimu jẹ́ ọ̀kẹ́ méjì ó lé ẹ̀ẹ́dẹ́gbẹ̀ta (40,500). ");
INSERT INTO yor_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Láti ìran Manase, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ogún ọdún sókè, tí wọ́n lè lọ sójú ogun ni wọ́n to orúkọ wọn lẹ́yọ kọ̀ọ̀kan gẹ́gẹ́ bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Iye tí a kà nínú ẹ̀yà Manase jẹ́ ẹgbàá ẹẹ́rìndínlógún ó lé igba (32,200). ");
INSERT INTO yor_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Láti ìran Benjamini, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ogún ọdún sókè ni wọ́n to orúkọ wọn lẹ́yọ kọ̀ọ̀kan gẹ́gẹ́ bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Iye tí a kà nínú ẹ̀yà Benjamini jẹ́ ẹgbàá mẹ́tàdínlógún ó lé egbèje (35,400). ");
INSERT INTO yor_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Láti ìran Dani, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ọmọ ogún ọdún sókè, tí wọ́n lè lọ sójú ogun ni wọ́n to orúkọ wọn lẹ́yọ kọ̀ọ̀kan gẹ́gẹ́ bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Iye tí a kà nínú ẹ̀yà Dani jẹ́ ẹgbàá mọ́kànlélọ́gbọ̀n ó lé ẹ̀ẹ́dẹ́gbẹ̀rin (62,700). ");
INSERT INTO yor_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Láti ìran Aṣeri, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ogún ọdún sókè, tí wọ́n le lọ sójú ogun ni wọ́n to orúkọ wọn lẹ́yọ kọ̀ọ̀kan gẹ́gẹ́ bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Iye tí a kà nínú ẹ̀yà Aṣeri jẹ́ ọ̀kẹ́ méjì ó lé ẹ̀ẹ́dẹ́gbẹ̀jọ (41,500). ");
INSERT INTO yor_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Láti ìran Naftali, gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ogún ọdún ó lé, tí wọ́n lè lọ sójú ogun ni wọ́n to orúkọ wọn lẹ́yọ kọ̀ọ̀kan gẹ́gẹ́ bí àkọsílẹ̀ ẹbí àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Iye àwọn tí a kà nínú ẹ̀yà Naftali jẹ́ ẹgbàá mẹ́rìndínlọ́gbọ̀n ó lé egbèje (53,400). ");
INSERT INTO yor_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Wọ̀nyí ni àwọn ènìyàn tí Mose àti Aaroni kà, pẹ̀lú ìrànlọ́wọ́ àwọn olórí méjìlá fún Israẹli, tí ẹnìkọ̀ọ̀kan ṣojú fún ìdílé rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Gbogbo ọmọkùnrin Israẹli tó jẹ́ ọmọ ogún ọdún sókè, tó sì lè lọ sójú ogun ni wọ́n kà gẹ́gẹ́ bí ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Àpapọ̀ iye wọn jẹ́ ọgbọ̀n ọ̀kẹ́ ó lé egbèjìdínlógún dín làádọ́ta (603,550). ");
INSERT INTO yor_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","A kò ka àwọn ìdílé ẹ̀yà Lefi mọ́ àwọn ìyókù. ");
INSERT INTO yor_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Nítorí Olúwa ti sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ìwọ kò gbọdọ̀ ka ẹ̀yà Lefi, tàbí kí o kà wọ́n mọ́ àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Dípò èyí yan àwọn ọmọ Lefi láti jẹ́ alábojútó àgọ́ ẹ̀rí, lórí gbogbo ohun èlò àti ohun gbogbo tó jẹ́ ti àgọ́ ẹ̀rí. Àwọn ni yóò máa gbé àgọ́ àti gbogbo ohun èlò rẹ̀, wọn ó máa mójútó o, kí wọn ó sì máa pàgọ́ yí i ká. ");
INSERT INTO yor_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ìgbàkígbà tí àgọ́ yóò bá tẹ̀síwájú, àwọn ọmọ Lefi ni yóò tú palẹ̀, nígbàkígbà tí a bá sì tún pa àgọ́, àwọn ọmọ Lefi náà ni yóò ṣe é. Àlejò tó bá súnmọ́ tòsí ibẹ̀, pípa ni kí ẹ pa á ");
INSERT INTO yor_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","kí àwọn ọmọ Israẹli pa àgọ́ wọn gẹ́gẹ́ bí ìpín wọn olúkúlùkù ní ibùdó tirẹ̀ lábẹ́ ọ̀págun tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Àwọn ọmọ Lefi yóò jẹ́ alábojútó àti olùtọ́jú àgọ́ ẹ̀rí náà, kí ìbínú má ba à sí lára ìjọ àwọn ọmọ Israẹli; kí àwọn ọmọ Lefi sì máa ṣe ìtọ́jú àgọ́ ẹ̀rí náà.” ");
INSERT INTO yor_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Àwọn ọmọ Israẹli sì ṣe ohun gbogbo gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Olúwa sọ fún Mose àti Aaroni pé, ");
INSERT INTO yor_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Kí àwọn ọmọ Israẹli pa àgọ́ wọn yí àgọ́ ìpàdé ká, kí wọ́n jẹ́ kí àgọ́ wọn jìnnà sí i díẹ̀, oníkálùkù lábẹ́ ọ̀págun pẹ̀lú àsíá ìdílé wọn.” ");
INSERT INTO yor_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ní ìlà-oòrùn, ní ìdojúkọ àtiyọ oòrùn: ni kí ìpín ti Juda pa ibùdó wọn sí lábẹ́ ọ̀págun wọn. Olórí Juda ni Nahiṣoni ọmọ Amminadabu. ");
INSERT INTO yor_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Iye ìpín rẹ̀ jẹ́ ẹgbàá mẹ́tàdínlógójì ó lé ẹgbẹ̀ta (74,600). ");
INSERT INTO yor_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Ẹ̀yà Isakari ni yóò pa ibùdó tẹ̀lé wọn. Olórí Isakari ni Netaneli ọmọ Suari. ");
INSERT INTO yor_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Iye ìpín rẹ̀ jẹ́ ẹgbàá mẹ́tàdínlọ́gbọ̀n ó lé irinwó (54,400). ");
INSERT INTO yor_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ẹ̀yà Sebuluni ni yóò tẹ̀lé e. Olórí Sebuluni ni Eliabu ọmọ Heloni. ");
INSERT INTO yor_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Iye ìpín rẹ̀ jẹ́ ẹgbàá méjìdínlọ́gbọ̀n ó lé egbèje (57,400). ");
INSERT INTO yor_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Gbogbo àwọn tí a yàn sí ibùdó Juda, gẹ́gẹ́ bí ìpín wọn àpapọ̀ iye wọn jẹ́ ẹgbàá mẹ́tàléláàdọ́rùn-ún ó lé irinwó (186,400). Àwọn ni yóò kọ́kọ́ ṣáájú. ");
INSERT INTO yor_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ní ìhà gúúsù: ni ìpín ti Reubeni pa ibùdó sí lábẹ́ ọ̀págun wọn. Olórí Reubeni ni Elisuri ọmọ Ṣedeuri. ");
INSERT INTO yor_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Iye ìpín rẹ̀ jẹ́ ẹgbàá mẹ́tàlélógún ó lé ẹ̀ẹ́dẹ́gbẹ̀ta (46,500). ");
INSERT INTO yor_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ẹ̀yà Simeoni ni yóò pa ibùdó tẹ̀lé wọn. Olórí Simoni ni Ṣelumieli ọmọ Suriṣaddai. ");
INSERT INTO yor_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Iye ìpín rẹ̀ jẹ́ ẹgbàá mọ́kàndínlọ́gbọ̀n ó lé ẹ̀ẹ́dẹ́gbéje (59,300). ");
INSERT INTO yor_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ẹ̀yà Gadi ló tẹ̀lé wọn. Olórí Gadi ni Eliasafu ọmọ Deueli. ");
INSERT INTO yor_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Iye ìpín rẹ̀ jẹ́ ẹgbàá méjìlélógún ó lé àádọ́talélẹ́gbẹ̀jọ (45,650). ");
INSERT INTO yor_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Gbogbo ènìyàn tí a yàn sí ibùdó Reubeni, gẹ́gẹ́ bí ìpín wọn àpapọ̀ iye wọn jẹ́ ẹgbàá márùndínlọ́gọ́rin ó lé àádọ́talélégbèje (151,450). Àwọn ni yóò jáde sìkéjì. ");
INSERT INTO yor_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Nígbà náà ni àwọn ọmọ Lefi àti àgọ́ ìpàdé yóò tẹ̀síwájú láàrín ibùdó àwọn ènìyàn, wọn yóò tẹ̀síwájú ní ṣísẹ̀-n-tẹ̀lé gẹ́gẹ́ bí wọn ṣe pa ibùdó, olúkúlùkù láààyè rẹ̀, àti lábẹ́ ọ̀págun rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ní ìhà ìlà-oòrùn: ni ìpín Efraimu yóò pa ibùdó rẹ̀ sí lábẹ́ ọ̀págun rẹ̀. Olórí Efraimu ni Eliṣama ọmọ Ammihudu. ");
INSERT INTO yor_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Iye ìpín rẹ̀ jẹ́ ọ̀kẹ́ méjì lé ó lẹ̀ẹ́dẹ́gbẹ̀ta (40,500). ");
INSERT INTO yor_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ẹ̀yà Manase ni yóò tẹ̀lé wọn. Olórí Manase ni Gamalieli ọmọ Pedasuri. ");
INSERT INTO yor_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Iye ìpín rẹ̀ ni ẹgbàá mẹ́rìndínlógún ó lé igba (32,200). ");
INSERT INTO yor_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ẹ̀yà Benjamini ni yóò tẹ̀lé e. Olórí Benjamini ni Abidani ọmọ Gideoni. ");
INSERT INTO yor_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Iye ìpín rẹ̀ ni ẹgbàá mẹ́tàdínlógún ó lé egbèje (35,400). ");
INSERT INTO yor_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Gbogbo ènìyàn tí a yàn sí ibùdó Efraimu, gẹ́gẹ́ bí ìpín wọn, àpapọ̀ iye wọn jẹ́ ẹgbàá mẹ́rìnléláàádọ́ta ó lé ọgọ́rùn-ún (108,100). Àwọn ni yóò jáde sìkẹ́ta. ");
INSERT INTO yor_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ní ìhà àríwá: ni ìpín Dani yóò pa ibùdó sí lábẹ́ ọ̀págun wọn. Olórí Dani ni Ahieseri ọmọ Ammiṣaddai. ");
INSERT INTO yor_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Iye ìpín rẹ̀ jẹ́ ẹgbàá mọ́kànlélọ́gbọ̀n ó lé ẹ̀ẹ́dẹ́gbẹ̀rin (62,700). ");
INSERT INTO yor_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Ẹ̀yà Aṣeri ni yóò pa ibùdó tẹ̀lé wọn. Olórí Aṣeri ni Pagieli ọmọ Okanri. ");
INSERT INTO yor_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Iye ìpín rẹ̀ jẹ́ ọ̀kẹ́ méjì ó lé ẹ̀ẹ́dẹ́gbẹ̀jọ (41,500). ");
INSERT INTO yor_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ẹ̀yà Naftali ni yóò kàn lẹ́yìn wọn. Olórí Naftali ni Ahira ọmọ Enani. ");
INSERT INTO yor_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Iye ìpín rẹ̀ jẹ́ ẹgbàá mẹ́rìndínlógún ó lé egbèje (53,400). ");
INSERT INTO yor_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Gbogbo ènìyàn tí a yàn sí ibùdó Dani jẹ́ ẹgbàá méjìdínlọ́gọ̀rin ó lé ẹgbẹ̀jọ (157,600). Àwọn ni yóò jáde kẹ́yìn lábẹ́ ọ̀págun wọn. ");
INSERT INTO yor_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Wọ̀nyí ni àwọn ọmọ Israẹli tí wọ́n kà nípa ìdílé wọn. Gbogbo àwọn tó wà ní ibùdó, gẹ́gẹ́ bí ìpín wọn, wọ́n jẹ́ ọgbọ̀n ọ̀kẹ́ ó lé egbèjìdínlógún dín làádọ́ta (603,550). ");
INSERT INTO yor_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ṣùgbọ́n a kò ka àwọn ọmọ Lefi papọ̀ mọ́ àwọn Israẹli gẹ́gẹ́ bí Olúwa ti pa á láṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Àwọn ọmọ Israẹli ṣe gbogbo ohun tí Olúwa pàṣẹ fún Mose, báyìí ni wọ́n ṣe pa ibùdó lábẹ́ ọ̀págun wọn, bẹ́ẹ̀ náà sì ni wọ́n ṣe jáde, oníkálùkù pẹ̀lú ẹbí àti ìdílé rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ìwọ̀nyí ni ìdílé Aaroni àti Mose ní ìgbà tí Olúwa bá Mose sọ̀rọ̀ ní òkè Sinai. ");
INSERT INTO yor_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Orúkọ àwọn ọmọ Aaroni nìwọ̀nyí, Nadabu ni àkọ́bí, Abihu, Eleasari àti Itamari. ");
INSERT INTO yor_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Orúkọ àwọn ọmọ Aaroni ni ìwọ̀nyí, àwọn àlùfáà tí a fi òróró yàn, àwọn tí a fi joyè àlùfáà láti ṣiṣẹ́ gẹ́gẹ́ bí àlùfáà. ");
INSERT INTO yor_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ṣùgbọ́n Nadabu àti Abihu ti kú níwájú Olúwa nígbà tí wọ́n rú iná àjèjì níwájú Olúwa nínú ijù Sinai, àwọn méjèèjì kò sì ní ọmọ. Báyìí Eleasari àti Itamari ló ṣiṣẹ́ àlùfáà nígbà ayé Aaroni baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Kó ẹ̀yà Lefi wá, kí o sì fà wọ́n fún Aaroni àlùfáà láti máa ràn án lọ́wọ́. ");
INSERT INTO yor_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Wọn yóò máa ṣiṣẹ́ fún un àti fún gbogbo ìjọ ènìyàn ní àgọ́ ìpàdé bí wọ́n ti ń ṣiṣẹ́ ìsìn nínú àgọ́. ");
INSERT INTO yor_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Wọn yóò máa tọ́jú gbogbo ohun èlò inú àgọ́ ìpàdé, wọn yóò sì máa ṣe ojúṣe àwọn ọmọ Israẹli nípa ṣíṣe iṣẹ́ nínú àgọ́. ");
INSERT INTO yor_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Fi ẹ̀yà Lefi jì Aaroni àti àwọn ọmọ rẹ̀, àwọn nìkan ni a fi fún Aaroni nínú gbogbo àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Kí o sì yan Aaroni àti àwọn ọmọ rẹ̀ láti máa ṣiṣẹ́ àlùfáà; àlejò tó bá súnmọ́ ibi mímọ́ pípa ni kí ẹ pa á.” ");
INSERT INTO yor_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Olúwa tún sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Báyìí èmi fúnra mi ti mú ẹ̀yà Lefi láàrín àwọn ọmọ Israẹli dípò gbogbo àkọ́bí ọkùnrin àwọn ọmọbìnrin Israẹli. Ti èmi ni àwọn ọmọ Lefi, ");
INSERT INTO yor_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","nítorí pé ti èmi ni gbogbo àkọ́bí. Ní ọjọ́ tí mo pa gbogbo àkọ́bí ní ilẹ̀ Ejibiti ni mo ti ya gbogbo àkọ́bí sọ́tọ̀ ní Israẹli yálà ti ènìyàn tàbí ti ẹranko. Gbogbo wọn gbọdọ̀ jẹ́ ti èmi. Èmi ni Olúwa.” ");
INSERT INTO yor_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Nígbà náà ni Olúwa sọ fún Mose ní aginjù Sinai pé, ");
INSERT INTO yor_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Ka àwọn ọmọ Lefi nípa ilé baba wọn àti ìdílé wọn kí o ka gbogbo ọmọkùnrin láti ọmọ oṣù kan sókè.” ");
INSERT INTO yor_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Mose sì kà wọ́n gẹ́gẹ́ bí ọ̀rọ̀ Olúwa ti pa á láṣẹ fún un. ");
INSERT INTO yor_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Wọ̀nyí ni orúkọ àwọn ọmọ Lefi: Gerṣoni, Kohati àti Merari. ");
INSERT INTO yor_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Wọ̀nyí ni orúkọ àwọn ọmọ Gerṣoni: Libni àti Ṣimei. ");
INSERT INTO yor_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Àwọn ìdílé Kohati ni: Amramu, Isari, Hebroni àti Usieli. ");
INSERT INTO yor_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Àwọn ìdílé Merari ni: Mahili àti Muṣi. Wọ̀nyí ni ìdílé Lefi gẹ́gẹ́ bí ilé baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ti Gerṣoni ni ìdílé Libni àti Ṣimei; àwọn ni ìdílé Gerṣoni. ");
INSERT INTO yor_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Iye àwọn ọmọkùnrin tí ọjọ́ orí wọ́n jẹ́ oṣù kan ó lé, jẹ́ ẹgbàata ó lé ẹ̀ẹ́dẹ́gbẹ̀jọ (7,500). ");
INSERT INTO yor_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Àwọn ìdílé Gerṣoni yóò pa ibùdó sí ìhà ìwọ̀-oòrùn lẹ́yìn àgọ́. ");
INSERT INTO yor_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Olórí àwọn ìdílé Gerṣoni ni Eliasafu ọmọ Láélì. ");
INSERT INTO yor_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Iṣẹ́ àwọn ìdílé Gerṣoni nínú àgọ́ ìpàdé ni pé àwọn yóò máa tọ́jú àgọ́, ìbòrí àgọ́, aṣọ títa ẹnu-ọ̀nà àgọ́ ìpàdé, ");
INSERT INTO yor_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","aṣọ títa ti àgbàlá, aṣọ títa ti ẹnu-ọ̀nà àgbàlá tó yí àgọ́ àti pẹpẹ ká, àwọn okùn rẹ̀ àti gbogbo ohun tó jẹ mọ́ lílò wọn. ");
INSERT INTO yor_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ti Kohati ní ìdílé Amramu, Isari, Hebroni àti Usieli, wọ̀nyí ni ìran Kohati. ");
INSERT INTO yor_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Iye gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ọmọ oṣù kan ó lé jẹ́ ẹgbàá mẹ́rin ó lé ẹgbẹ̀ta (8,600), tí yóò máa ṣiṣẹ́ ní ibi mímọ́. ");
INSERT INTO yor_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Àwọn ìdílé Kohati yóò pa ibùdó wọn sí ìhà gúúsù ní ẹ̀gbẹ́ àgọ́. ");
INSERT INTO yor_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Olórí àwọn ìdílé Kohati ni Elisafani ọmọ Usieli. ");
INSERT INTO yor_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Àwọn ni yóò máa tọ́jú àpótí ẹ̀rí, tábìlì, ọ̀pá fìtílà, àwọn pẹpẹ, gbogbo ohun èlò ibi mímọ́ tí à ń lò fún iṣẹ́ ìsìn, aṣọ títa àti gbogbo ohun tó jẹ mọ́ lílò wọn. ");
INSERT INTO yor_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleasari ọmọ Aaroni àlùfáà ni alákòóso gbogbo àwọn olórí ìdílé Lefi. Òun ni wọ́n yàn lórí gbogbo àwọn tí yóò máa tọ́jú ibi mímọ́. ");
INSERT INTO yor_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ti Merari ni ìran Mahili àti Muṣi, àwọn ni ìran Merari. ");
INSERT INTO yor_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Iye gbogbo ọmọkùnrin tí ọjọ́ orí wọ́n jẹ́ oṣù kan ó lé, èyí tí wọ́n kà jẹ́ igba mọ́kànlélọ́gbọ̀n (6,200). ");
INSERT INTO yor_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Olórí àwọn ìdílé ìran Merari ni Ṣurieli ọmọ Abihaili. Wọn yóò pa ibùdó wọn sí ìhà àríwá àgọ́. ");
INSERT INTO yor_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Àwọn ìran Merari ni a yàn fún títọ́jú àwọn férémù àgọ́, ọ̀pá ìdábùú rẹ̀, òpó rẹ̀, ihò òpó rẹ̀ àti gbogbo ohun èlò tó jẹ mọ́ lílò wọn. ");
INSERT INTO yor_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Iṣẹ́ wọn tún ni títọ́jú àwọn òpó tó yí àgbàlá ká, ihò òpó rẹ̀, èèkàn àti okùn wọn. ");
INSERT INTO yor_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mose àti Aaroni pẹ̀lú àwọn ọmọ yóò pa àgọ́ ní ìdojúkọ ìwọ̀-oòrùn níwájú àgọ́ ìpàdé. Iṣẹ́ wọn ni láti máa mójútó iṣẹ́ ìsìn ibi mímọ́ àti láti máa ṣiṣẹ́ ìsìn fún àwọn ọmọ Israẹli. Àlejò tó bá súnmọ́ ibi mímọ́ yàtọ̀ sí àwọn tí a yàn, pípa ni kí ẹ pa á. ");
INSERT INTO yor_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Àpapọ̀ iye àwọn ọmọ Lefi tí a kà gẹ́gẹ́ bí Olúwa ti pa á láṣẹ fún Mose àti Aaroni gẹ́gẹ́ bí ìran wọn, pẹ̀lú gbogbo ọmọkùnrin tí ọjọ́ orí wọn jẹ́ ọmọ oṣù kan ó lé jẹ́ ẹgbẹ̀rún méjìlélógún (22,000). ");
INSERT INTO yor_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Olúwa sọ fún Mose pé, “Ka gbogbo àkọ́bí ọmọkùnrin Israẹli láti ọmọ oṣù kan ó lé kí o sì ṣe àkọsílẹ̀ orúkọ wọn. ");
INSERT INTO yor_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Kí o sì gba àwọn ọmọ Lefi dípò gbogbo àkọ́bí àwọn ọmọ Israẹli, kí o sì gba gbogbo ẹran ọ̀sìn àwọn ọmọ Lefi fún mi dípò gbogbo àkọ́bí àwọn ẹran ọ̀sìn àwọn ọmọ Israẹli. Èmi ni Olúwa.” ");
INSERT INTO yor_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mose sì ka gbogbo àkọ́bí àwọn ọmọ Israẹli gẹ́gẹ́ bí Olúwa ti pàṣẹ fún un. ");
INSERT INTO yor_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Àpapọ̀ iye àwọn àkọ́bí ọkùnrin láti ọmọ oṣù kan ó lé, ní àkọsílẹ̀ orúkọ wọn jẹ́ ẹgbẹ̀rún méjìlélógún ó lé ọ̀rìnlúgba ó dín méje (22,273). ");
INSERT INTO yor_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Olúwa tún sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Gba àwọn ọmọ Lefi dípò gbogbo àkọ́bí àwọn ọmọ Israẹli àti ohun ọ̀sìn àwọn ọmọ Lefi dípò ohun ọ̀sìn àwọn ọmọ Israẹli. Tèmi ni àwọn ọmọ Lefi. Èmi ni Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Nísinsin yìí, láti lè ra ọ̀rìnlúgba dín méje (273) àkọ́bí àwọn Israẹli tó ju iye àwọn ọmọ Lefi lọ, ");
INSERT INTO yor_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ìwọ yóò gba ṣékélì márùn-ún lórí ẹni kọ̀ọ̀kan gẹ́gẹ́ bí iye owó ibi mímọ́, èyí tí í ṣe ogún gera. ");
INSERT INTO yor_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Owó tí a fi ra àwọn àkọ́bí ọmọ Israẹli tó lé yìí, ni kí o kó fún Aaroni àti àwọn ọmọ rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Nígbà náà ni Mose gba owó ìràpadà àwọn ènìyàn tó ṣẹ́kù lẹ́yìn tí àwọn ọmọ Lefi ti ra àwọn yòókù padà. ");
INSERT INTO yor_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Mose sì gba egbèje ṣékélì ó dín márùndínlógójì (1,365) gẹ́gẹ́ bí iye ṣékélì ibi mímọ́ lọ́wọ́ àkọ́bí àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mose sì kó owó ìràpadà yìí fún Aaroni àti àwọn ọmọ rẹ̀, bí Olúwa ti pa á láṣẹ fún un. ");
INSERT INTO yor_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Olúwa sọ fún Mose àti Aaroni pé, ");
INSERT INTO yor_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Ka iye àwọn ọmọ Kohati láàrín àwọn ọmọ Lefi nípa ilé baba wọn àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ka gbogbo ọkùnrin láti ọmọ ọgbọ̀n ọdún títí dé àádọ́ta ọdún gbogbo àwọn tó ń ṣiṣẹ́ nínú àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Wọ̀nyí ni iṣẹ́ ìsìn àwọn ọmọ Kohati nínú àgọ́ àjọ, láti tọ́jú àwọn ohun èlò mímọ́ jùlọ. ");
INSERT INTO yor_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Nígbà tí àgọ́ yóò bá tẹ̀síwájú, Aaroni àti àwọn ọmọ rẹ̀ yóò wọ inú rẹ̀, wọn yóò sí aṣọ ìbòrí rẹ̀, wọn yóò sì fi bo àpótí ẹ̀rí. ");
INSERT INTO yor_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Wọn yóò sì fi awọ ewúrẹ́ bò ó, lórí awọ ewúrẹ́ yìí ni wọn ó tẹ̀ bọ ààyè rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Lórí tábìlì àkàrà ìfihàn ni kí wọn ó na aṣọ aláró kan sí, kí wọn kí ó sì fi àwopọ̀kọ́ sórí rẹ̀, àti ṣíbí àti àwokòtò àti ìgò fún ọrẹ ohun mímu; àti àkàrà ìgbà gbogbo ní kí ó wà lórí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Lórí gbogbo nǹkan wọ̀nyí ni wọn yóò da, wọn ó tún fi awọ ewúrẹ́ bò ó, wọn ó sì fi òpó rẹ̀ bọ ààyè rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Kí wọn kí ó sì mú aṣọ aláwọ̀ aláró kan, kí wọn kí ó sì fi bo ọ̀pá fìtílà àti fìtílà rẹ̀, àti alumagaji rẹ̀, àti àwo alumagaji rẹ̀, àti gbogbo ohun èlò òróró rẹ̀, èyí tí wọ́n fi ń ṣe iṣẹ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Kí wọn ó fi awọ ẹran yí fìtílà àti gbogbo ohun èlò rẹ, kí wọn kí ó sì gbé e lé orí férémù tí wọn yóò fi gbé e. ");
INSERT INTO yor_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Ní orí pẹpẹ wúrà ni kí wọn ó tẹ́ aṣọ aláró kan sí, wọn yóò sì fi awọ seali bò ó, kí wọ́n sì fi òpó rẹ̀ bọ ààyè rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Kí wọn kó gbogbo ohun èlò tí wọ́n ń lò fún iṣẹ́ ìsìn ní ibi mímọ́, kí wọn ó fi aṣọ aláwọ̀ búlúù yìí, kí wọn ó sì fi awọ seali bò ó, kí wọn ó sì fi gbé wọn ka orí férémù. ");
INSERT INTO yor_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Kí wọn ó kó eérú kúrò lórí pẹpẹ idẹ, kí wọn ó sì tẹ́ aṣọ aláwọ̀ àlùkò lé e lórí. ");
INSERT INTO yor_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Nígbà náà ni kí wọn ó kó gbogbo ohun èlò fún iṣẹ́ ìsìn níbi pẹpẹ, títí dórí àwo iná, fọ́ọ̀kì ẹran, ọkọ́ eérú àti àwokòtò. Kí wọn ó fi awọ ewúrẹ́ bo gbogbo rẹ̀, kí wọn ó sì fi òpó rẹ̀ bọ ààyè rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Lẹ́yìn tí Aaroni àti àwọn ọmọ rẹ̀ ti parí bíbo ibi mímọ́ àti gbogbo ohun èlò ibi mímọ́, nígbà tí àgọ́ bá sì ṣetán láti tẹ̀síwájú, kí àwọn ọmọ Kohati bọ́ síwájú láti gbé e, ṣùgbọ́n wọn kò gbọdọ̀ fọwọ́ kan ohun mímọ́ kankan, bí wọ́n bá ṣe bẹ́ẹ̀ wọn ó kú. Àwọn ọmọ Kohati ni yóò gbé gbogbo ohun tó wà nínú àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Iṣẹ́ Eleasari ọmọ Aaroni tí í ṣe àlùfáà ni ṣíṣe àbojútó òróró fìtílà, tùràrí dídùn, ẹbọ ohun jíjẹ ìgbà gbogbo àti òróró ìtasórí. Kí ó jẹ́ alábojútó gbogbo ohun tó jẹ mọ́ àgọ́ àti gbogbo ohun tó wà nínú rẹ̀, pẹ̀lú gbogbo ohun èlò ibi mímọ́.” ");
INSERT INTO yor_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Olúwa sọ fún Mose àti Aaroni pé, ");
INSERT INTO yor_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Rí i pé a kò gé ẹ̀yà Kohati kúrò lára àwọn ọmọ Lefi. ");
INSERT INTO yor_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Nítorí kí wọ́n lè yè, kí wọ́n má ba à kú nígbà tí wọ́n bá súnmọ́ tòsí àwọn ohun mímọ́ jùlọ: Aaroni àti àwọn ọmọ rẹ̀ ni kí ó wọ ibi mímọ́ láti pín iṣẹ́ oníkálùkù àti àwọn ohun tí wọn yóò gbé. ");
INSERT INTO yor_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ṣùgbọ́n àwọn ọmọ Kohati kò gbọdọ̀ wọlé láti wo àwọn ohun mímọ́, bó tilẹ̀ jẹ́ ìṣẹ́jú kan, bí wọ́n bá ṣe bẹ́ẹ̀, wọn yóò kú.” ");
INSERT INTO yor_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Tún ka iye àwọn ọmọ Gerṣoni nípa ilé baba wọn àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ka gbogbo ọkùnrin láti ọmọ ọgbọ̀n ọdún títí dé àádọ́ta ọdún, gbogbo àwọn tó ń wá ṣiṣẹ́ ní àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Èyí ni iṣẹ́ ìsìn ìdílé àwọn ọmọ Gerṣoni, bí wọ́n ti ń ṣiṣẹ́ àti ní ẹrù rírù. ");
INSERT INTO yor_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Àwọn ni yóò máa ru àwọn aṣọ títa ti àgọ́, ti àgọ́ ìpàdé àti ìbòrí rẹ̀, àti awọ ewúrẹ́ tí a fi bò ó, aṣọ títa ẹnu-ọ̀nà àgọ́ ìpàdé, ");
INSERT INTO yor_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","aṣọ títa ti àgbàlá tó yí àgọ́ àti pẹpẹ ká, aṣọ títa ti ẹnu-ọ̀nà àbáwọlé sí àgbàlá, okùn àti àwọn ohun èlò iṣẹ́ ìsìn, àti ohun gbogbo tí à ń lò fún wọn, bẹ́ẹ̀ ni wọn ó máa sìn. Àwọn ọmọ Gerṣoni ni yóò ṣe gbogbo ohun tó bá yẹ pẹ̀lú àwọn nǹkan wọ̀nyí. ");
INSERT INTO yor_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gbogbo iṣẹ́ ìsìn àwọn ọmọ Gerṣoni yálà ni iṣẹ́ ṣíṣe tàbí ní ẹrù rírù ni, Aaroni àti àwọn ọmọ rẹ̀ ni yóò máa darí wọn; ìwọ ni kí o sì yàn ẹrù tí oníkálùkù yóò rù fún un. ");
INSERT INTO yor_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Èyí ni iṣẹ́ ìdílé àwọn Gerṣoni ni àgọ́ ìpàdé Itamari, ọmọ Aaroni tí í ṣe àlùfáà ni yóò sì jẹ alábojútó iṣẹ́ wọn. ");
INSERT INTO yor_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Ka iye àwọn ọmọ Merari nípa ilé baba wọn àti ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ka gbogbo ọkùnrin láti ọmọ ọgbọ̀n ọdún títí dé àádọ́ta ọdún, gbogbo àwọn tó ń wá ṣiṣẹ́ ní àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Iṣẹ́ tí wọn yóò sì máa ṣe nínú àgọ́ ìpàdé nìyìí: gbígbẹ́ àwọn férémù àgọ́, pákó ìdábùú rẹ̀, òpó àti ihò òpó rẹ̀, ");
INSERT INTO yor_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","pẹ̀lú gbogbo òpó tó yí àgbàlá ká àti ohun èlò tó jẹ mọ́ lílò wọn, kí o sì yan ohun tí oníkálùkù yóò rù fún un. ");
INSERT INTO yor_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Èyí ni iṣẹ́ ìsìn ìdílé àwọn ọmọ Merari, bí wọn yóò ti máa ṣiṣẹ́ ní àgọ́ ìpàdé lábẹ́ àkóso Itamari ọmọ Aaroni tí í ṣe àlùfáà.” ");
INSERT INTO yor_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mose àti Aaroni pẹ̀lú àwọn olórí ìjọ ènìyàn ka àwọn ọmọ Kohati nípa ìdílé àti ilé baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Gbogbo ọmọkùnrin láti ọmọ ọgbọ̀n ọdún títí dé àádọ́ta ọdún gbogbo àwọn tó ń wá ṣiṣẹ́ ní Àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Iye wọn nípa ìdílé jẹ́ ẹgbẹ̀rìnlá ó dín làádọ́ta (2,750). ");
INSERT INTO yor_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Èyí ni àpapọ̀ iye àwọn ọmọ Kohati tó ń ṣiṣẹ́ ní àgọ́ ìpàdé; tí Mose àti Aaroni kà gẹ́gẹ́ bí Olúwa ti pa á láṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Wọ́n ka àwọn ọmọ Gerṣoni nípa ìdílé àti ilé baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Gbogbo ọmọkùnrin láti ọmọ ọgbọ̀n ọdún títí dé àádọ́ta, gbogbo àwọn tó lè ṣiṣẹ́ ní àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Iye wọn nípa ìdílé àti ilé baba wọn jẹ́ ẹgbẹ̀tàlá ó lé ọgbọ̀n (2,630). ");
INSERT INTO yor_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Èyí jẹ́ àpapọ̀ iye àwọn ọmọ Gerṣoni, àwọn tó ṣiṣẹ́ ní àgọ́ ìpàdé. Mose àti Aaroni ṣe bí àṣẹ Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Wọ́n ka àwọn ọmọ Merari nípa ìdílé àti ilé baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Gbogbo ọkùnrin láti ọmọ ọgbọ̀n ọdún títí dé àádọ́ta ọdún, àwọn tó ṣiṣẹ́ ní àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Iye wọn nípa ìdílé àti ilé baba wọn jẹ́ ẹgbẹ̀rìndínlógún (3,200). ");
INSERT INTO yor_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Èyí ni àpapọ̀ iye àwọn ọmọ Merari. Mose àti Aaroni kà wọ́n gẹ́gẹ́ bí àṣẹ Olúwa láti ẹnu Mose. ");
INSERT INTO yor_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Gbogbo àwọn tí a kà nínú àwọn ọmọ Lefi, ti Mose àti Aaroni àti àwọn olórí Israẹli kà, nípa ìdílé wọn àti gẹ́gẹ́ bí ilé baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Gbogbo ọkùnrin láti ọmọ ọgbọ̀n ọdún títí dé àádọ́ta, àwọn tó ń ṣiṣẹ́ ìsìn tó sì ń ru àwọn ẹrù inú Àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Àpapọ̀ iye wọn jẹ́ ẹgbẹ̀tàlá lé lẹ́gbàarin ó dín ogún (8,580). ");
INSERT INTO yor_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Wọ́n yan iṣẹ́ àti àwọn ohun tí ẹni kọ̀ọ̀kan yóò máa gbé fún un gẹ́gẹ́ bí Olúwa ti pàṣẹ láti ẹnu Mose. Bẹ́ẹ̀ ni wọ́n ṣe kà wọ́n gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Pàṣẹ fún àwọn ọmọ Israẹli pé kí wọn ó lé ẹnikẹ́ni tó bá ní ẹ̀tẹ̀, ìtújáde ara ní oríṣìíríṣìí tàbí ẹni tó jẹ́ aláìmọ́ nípa fífọwọ́ kan òkú. ");
INSERT INTO yor_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Irú ẹni bẹ́ẹ̀ yálà ọkùnrin tàbí obìnrin, ẹ lé wọn jáde kúrò nínú ibùdó kí wọn má ba à ba ibùdó wọn jẹ́ níbi tí èmi ń gbé láàrín wọn.” ");
INSERT INTO yor_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Àwọn ọmọ Israẹli sì ṣe bẹ́ẹ̀; wọ́n lé wọn jáde kúrò nínú ibùdó. Wọn ṣe gẹ́gẹ́ bí Olúwa ti sọ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Sọ fún àwọn ọmọ Israẹli: ‘Nígbà tí ọkùnrin kan tàbí obìnrin kan bá ṣẹ̀ ara wọn lọ́nà kan tàbí òmíràn, tí wọ́n sì ṣe àìṣòótọ́ sí Olúwa, ẹni náà jẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ó gbọdọ̀ jẹ́wọ́ ẹ̀ṣẹ̀ tí ó sẹ̀. Ó gbọdọ̀ san ẹ̀san rẹ̀ ní ojú owó, kí ó sì fi ìdámárùn-ún rẹ̀ lé e, kí ó sì fi fún ẹni tí òun jẹ̀bi rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ṣùgbọ́n bí irú ẹni bẹ́ẹ̀ kò bá ní ìbátan tí ó súnmọ́ ọn tí ó lè ṣe àtúnṣe àṣìṣe rẹ̀ náà fún, àtúnṣe náà jẹ́ ti Olúwa, ẹ sì gbọdọ̀ ko fún àlùfáà pẹ̀lú àgbò tí a fi ṣe ètùtù fún ẹni náà. ");
INSERT INTO yor_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Gbogbo ọrẹ ohun mímọ́ tí àwọn ọmọ Israẹli bá mú wá fún àlùfáà jẹ́ tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ọrẹ ohun mímọ́ ẹnìkọ̀ọ̀kan jẹ́ ti òun nìkan, ṣùgbọ́n ohunkóhun tó bá fún àlùfáà yóò jẹ́ ti àlùfáà.’ ” ");
INSERT INTO yor_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Olúwa sọ fún Mose wí pé, ");
INSERT INTO yor_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Bá àwọn ọmọ Israẹli sọ̀rọ̀ kí o sọ fún wọn pé, ‘Bí ìyàwó ọkùnrin kan bá yapa tó sì ṣe àìṣòótọ́ sí i, ");
INSERT INTO yor_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","nípa mímú kí ọkùnrin mìíràn bá a lòpọ̀ tí ó sì fi èyí pamọ́ fún ọkọ rẹ̀, tí a kò si gbá a mú nínú ìwà àìmọ́ rẹ̀ (nítorí pé kò sí ẹlẹ́rìí àti pé wọn kò ká a mọ́ nígbà tí ó ń dẹ́ṣẹ̀ náà). ");
INSERT INTO yor_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Ṣùgbọ́n tí ẹ̀mí owú jíjẹ bá bà lé ọkọ rẹ̀ dé bi pé ó ń funra sí ìyàwó rẹ̀ yìí tí ìyàwó rẹ̀ sì wà ní àìmọ́ nítòótọ́, tàbí tí ẹ̀mí owú bá bà lé ọkùnrin kan tó sì ń jowú ìyàwó rẹ̀ bí ó tilẹ̀ jẹ́ pé ó wà ní mímọ́, ");
INSERT INTO yor_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","nígbà náà ni ọkùnrin yìí yóò mú ìyàwó rẹ̀ lọ sọ́dọ̀ àlùfáà. Ọkùnrin náà yóò sì mú ọrẹ tí a yàn fún obìnrin náà, ìdámẹ́wàá òsùwọ̀n efa ìyẹ̀fun barle. Kò gbọdọ̀ da òróró sí i, bẹ́ẹ̀ ni kò gbọdọ̀ fi tùràrí dídùn sí i nítorí pé ẹbọ ohun jíjẹ fún owú ni, èyí ti n mú ẹ̀ṣẹ̀ wá sí ìrántí. ");
INSERT INTO yor_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Àlùfáà yóò sì mú un wá síwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Àlùfáà yóò sì bu erùpẹ̀ ilẹ̀ àgọ́ sínú omi mímọ́ tó bù láti ìkòkò amọ̀. ");
INSERT INTO yor_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Lẹ́yìn èyí, àlùfáà yóò mú obìnrin náà dúró níwájú Olúwa yóò sì tú irun orí obìnrin náà lé e lọ́wọ́, èyí ni ẹbọ ohun jíjẹ ti owú, àlùfáà fúnra rẹ̀ yóò sì gbé omi kíkorò tí ń mú ègún lọ́wọ́. ");
INSERT INTO yor_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Àlùfáà yóò sì mú obìnrin náà búra, yóò wí pé, “Bí ọkùnrin mìíràn kò bá bá ọ lòpọ̀, tí ó kò sì yapa, tí o kò sì di aláìmọ́ níwọ̀n ìgbà tí ó wà lábẹ́ àṣẹ ọkọ rẹ̀, a jẹ́ pé omi kíkorò tí ń mú ègún wá yìí kò ní ṣe ọ́ níbi. ");
INSERT INTO yor_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ṣùgbọ́n tí ìwọ bá ti yapa kúrò lọ́dọ̀ ọkọ rẹ, tí o bá ti ba ara rẹ jẹ́ nípa jíjẹ́ kí ọkùnrin tí kì í ṣe ọkọ rẹ bá ọ lòpọ̀,” ");
INSERT INTO yor_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","nígbà náà ni àlùfáà yóò mú obìnrin náà búra, yóò sọ fún obìnrin náà pé, “Kí Olúwa sọ ọ́ di ẹni ègún àti ẹni ìbáwí láàrín àwọn ènìyàn rẹ nípa mímú kí itan rẹ jẹrà, kí ikùn rẹ̀ sì wú. ");
INSERT INTO yor_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ǹjẹ́ kí omi yìí tí ń mú ègún wá wọ inú ara rẹ, kí ó mú ikùn rẹ̀ wú, kí ó sì mú itan rẹ̀ jẹrà dànù.” “ ‘Obìnrin náà yóò sì wí pé, “Àmín. Bẹ́ẹ̀ ni kó rí.” ");
INSERT INTO yor_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Nígbà náà ni àlùfáà yóò kọ ègún yìí sínú ìwé kíká, yóò sì sìn ín sínú omi kíkorò náà. ");
INSERT INTO yor_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Àlùfáà yóò sì mú kí obìnrin náà mu omi kíkorò tí ń mú ègún wá yìí, omi náà yóò wọ inú rẹ̀ yóò sì fa ìrora kíkorò fún obìnrin náà bí ó bá jẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Àlùfáà yóò gba ọrẹ ohun jíjẹ owú náà lọ́wọ́ rẹ̀, yóò fì í síwájú Olúwa, yóò sì mú iná sórí pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Àlùfáà yóò bu ẹ̀kúnwọ́ kan nínú ọrẹ ohun jíjẹ náà, yóò sun ún lórí pẹpẹ gẹ́gẹ́ bí ẹbọ ìrántí lẹ́yìn tí ó ti mú kí obìnrin náà mu omi. ");
INSERT INTO yor_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Bí ó bá ti mú obìnrin yìí mu omi náà, bí ó bá sì jẹ́ pé obìnrin náà ti ba ara rẹ̀ jẹ́, tí ó sì ṣe àìṣòótọ́ sí ọkọ rẹ̀, omi tí ń mú ègún wá, yóò wọ ara rẹ̀, yóò fa ìrora kíkorò fún un, ikùn rẹ̀ yóò wú, itan rẹ̀ yóò sì jẹrà dànù, yóò sì di ẹni ègún láàrín àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ṣùgbọ́n tó bá jẹ́ pé obìnrin náà kò ba ara rẹ̀ jẹ́, tó sì jẹ́ mímọ́, yóò bọ́ nínú ẹ̀bi, yóò sì le bímọ. ");
INSERT INTO yor_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Èyí ni òfin owú jíjẹ nígbà tí obìnrin tó wà lábẹ́ ọkọ bá ṣe a ṣe má ṣe, tí ó bá ba ara rẹ̀ jẹ́, ");
INSERT INTO yor_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","tàbí nígbà tí ẹ̀mí owú jíjẹ bá bà lé ọkùnrin kan nítorí pé ó funra sí ìyàwó rẹ̀. Àlùfáà yóò mú obìnrin náà dúró níwájú Olúwa yóò sì ṣe gẹ́gẹ́ bí òfin ti wí fún un. ");
INSERT INTO yor_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ara ọkọ rẹ̀ mọ́ nínú ẹ̀ṣẹ̀ yìí ṣùgbọ́n obìnrin náà yóò ru ẹ̀bi ẹ̀ṣẹ̀ rẹ̀.’ ” ");
INSERT INTO yor_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Sọ fún àwọn ọmọ Israẹli pé, ‘Bí ọkùnrin tàbí obìnrin kan bá jẹ́ ẹ̀jẹ́ pàtàkì, ẹ̀jẹ́ ìyara-ẹni-sọ́tọ̀ sí Olúwa nípa àìgé irun orí (Nasiri), ");
INSERT INTO yor_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","irú ẹni bẹ́ẹ̀ gbọdọ̀ yàgò fún wáìnì tàbí ọtí líle, ọtí wáìnì kíkan àti àwọn ohun mímu mìíràn tó bá kan. Kò gbọdọ̀ mu èso àjàrà tàbí kí ó jẹ èso àjàrà tútù tàbí gbígbẹ. ");
INSERT INTO yor_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Níwọ́n ìgbà tí ó sì jẹ́ Nasiri, ní kò gbọdọ̀ jẹ ohunkóhun tí a fi èso àjàrà ṣe, ìbá à ṣe kóró tàbí èèpo rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Ní gbogbo ìgbà ẹ̀jẹ́ ìyàsọ́tọ̀ rẹ̀ yìí, kí abẹ kankan má ṣe kàn án ní orí. Ó gbọdọ̀ jẹ́ mímọ́ títí tí àkókò ìyàsọ́tọ̀ rẹ̀ sí Olúwa yóò fi pé; ó gbọdọ̀ jẹ́ kí irun orí rẹ̀ gùn. ");
INSERT INTO yor_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘Ní gbogbo àkókò ìyàsọ́tọ̀ rẹ̀ sí Olúwa kò gbọdọ̀ súnmọ́ òkú ènìyàn. ");
INSERT INTO yor_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ìbá à ṣe òkú baba, àti ìyá rẹ̀, ẹ̀gbọ́n rẹ̀ ọkùnrin tàbí obìnrin tàbí àbúrò rẹ̀, kò gbọdọ̀ sọ ara rẹ̀ di aláìmọ́ nítorí wọn, nítorí pé àmì ìyàsọ́tọ̀ rẹ̀ sí Ọlọ́run wà ní orí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ní gbogbo àsìkò ìyàsọ́tọ̀ rẹ̀ yìí, ó jẹ́ mímọ́ sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Bí ẹnìkan bá kú ní ọ̀dọ̀ rẹ̀ ní òjijì, tí ó sì ba irun rẹ̀ tó yà sọ́tọ̀ jẹ́; ó gbọdọ̀ gé irun rẹ̀ ní ọjọ́ ìwẹ̀nùmọ́ rẹ̀ èyí tí í ṣe ọjọ́ keje. ");
INSERT INTO yor_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ní ọjọ́ kẹjọ, yóò mú àdàbà méjì àti ọmọ ẹyẹlé méjì wá sọ́dọ̀ àlùfáà ní ẹnu-ọ̀nà àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Àlùfáà yóò fi ọ̀kan rú ẹbọ ẹ̀ṣẹ̀ àti èkejì fún ẹbọ sísun láti fi ṣe ètùtù fún un nítorí pé ó ti ṣẹ̀ nípa wíwà níbi tí òkú ènìyàn wà. Yóò sì ya orí rẹ̀ sí mímọ́ ní ọjọ́ náà gan an. ");
INSERT INTO yor_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ó gbọdọ̀ ya ara rẹ̀ sọ́tọ̀ sí Olúwa fún àkókò ìyàsọ́tọ̀ rẹ̀, ó sì gbọdọ̀ mú akọ ọ̀dọ́-àgùntàn ọlọ́dún kan wá gẹ́gẹ́ bí ọrẹ ẹ̀bi. Kò sì ní í ka àwọn ọjọ́ ìyàsọ́tọ̀ rẹ̀ ti tẹ́lẹ̀ nítorí pé ó tí ba ara rẹ̀ jẹ́ ní àkókò ìyàsọ́tọ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Èyí ni òfin fún Nasiri nígbà tí àkókò ìyàsọ́tọ̀ rẹ̀ bá pé. Wọn ó mu wá sí ẹnu-ọ̀nà àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Níbẹ̀ ni yóò ti mú ọrẹ wá fún Olúwa, akọ ọ̀dọ́-àgùntàn ọlọ́dún kan tí kò ní àbùkù fún ẹbọ sísun àti ẹgbọrọ-àgùntàn ọlọ́dún kan, tí kò ní àbùkù fún ẹbọ ẹ̀ṣẹ̀, àgbò kan tí kò ní àbùkù fún ọrẹ àlàáfíà, ");
INSERT INTO yor_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","pẹ̀lú ọrẹ ohun jíjẹ àti ọrẹ ohun mímu, apẹ̀rẹ̀ àkàrà tí a kò fi ìwúkàrà ṣe, àkàrà tí a fi ìyẹ̀fun dáradára pò mọ́ òróró àti àkàrà fẹ́lẹ́fẹ́lẹ́ tí a fi òróró sọjọ̀ lé lórí. ");
INSERT INTO yor_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Àlùfáà yóò gbé gbogbo rẹ̀ wá síwájú Olúwa, yóò sì rú ẹbọ ẹ̀ṣẹ̀ àti ẹbọ sísun. ");
INSERT INTO yor_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Àlùfáà yóò fi àgbò náà rú ẹbọ àlàáfíà sí Olúwa, pẹ̀lú apẹ̀rẹ̀ àkàrà tí kò ní ìwúkàrà; yóò rú ẹbọ ohun jíjẹ àti ọrẹ ohun mímu. ");
INSERT INTO yor_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Nígbà náà ni Nasiri náà yóò fá irun ìyàsọ́tọ̀ rẹ̀ ní ẹnu-ọ̀nà àgọ́ ìpàdé. Yóò fi irun náà sínú iná tó wà lábẹ́ ẹbọ àlàáfíà. ");
INSERT INTO yor_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Lẹ́yìn tí Nasiri bá ti fá irun ìyàsọ́tọ̀ rẹ̀ tan, àlùfáà yóò mú apá àgbò bíbọ̀, àkàrà aláìwú kan àti àkàrà fẹ́lẹ́fẹ́lẹ́ tí kò ní ìwúkàrà láti inú apẹ̀rẹ̀ yóò sì kó gbogbo rẹ̀ lé e lọ́wọ́. ");
INSERT INTO yor_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Àlùfáà yóò fi gbogbo rẹ̀ níwájú Olúwa gẹ́gẹ́ bí ẹbọ fífì, wọ́n jẹ́ mímọ́, wọ́n sì jẹ́ ti àlùfáà pẹ̀lú igẹ̀ tí a fì àti itan tí wọ́n mú wá. Lẹ́yìn èyí, Nasiri náà lè mu wáìnì. ");
INSERT INTO yor_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Èyí ni òfin Nasiri tó jẹ́ ẹ̀jẹ́, ọrẹ rẹ̀ sí Olúwa, yóò wà ní ìbámu pẹ̀lú ìyàsọ́tọ̀ rẹ̀ gẹ́gẹ́ bí Nasiri, ní àfikún sí àwọn ohun mìíràn tó lágbára láti mú wá. Ó gbọdọ̀ mú ẹ̀jẹ́ tó jẹ́ ṣe gẹ́gẹ́ bí òfin Nasiri.’ ” ");
INSERT INTO yor_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Sọ fún Aaroni àti àwọn ọmọ rẹ̀ pé, ‘Báyìí ni kí ẹ ṣe máa súre fún àwọn ọmọ Israẹli. Ẹ sọ fún wọn pé, ");
INSERT INTO yor_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “Kí Olúwa bùkún un yín, kí ó sì pa yín mọ́. ");
INSERT INTO yor_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Kí Olúwa kí o mú ojú rẹ̀ kí ó mọ́lẹ̀ sí i yín lára. Kí ó sì ṣàánú fún un yín. ");
INSERT INTO yor_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Kí Olúwa bojú wò yín, kí ó sì fún un yín ní àlàáfíà.” ’ ");
INSERT INTO yor_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Báyìí ni wọn ó ṣe fi orúkọ mi sára àwọn ọmọ Israẹli, Èmi ó sì bùkún wọn.” ");
INSERT INTO yor_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Nígbà tí Mose ti parí gbígbé àgọ́ dúró, ó ta òróró sí i, ó sì yà á sí mímọ́ pẹ̀lú gbogbo àwọn ohun èlò rẹ̀, Ó tún ta òróró sí pẹpẹ, ó sì yà á sí mímọ́ pẹ̀lú gbogbo ohun èlò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Nígbà náà ni àwọn olórí Israẹli, àwọn ẹ̀yà kọ̀ọ̀kan, àwọn alábojútó àwọn tí a kà náà mú ọrẹ wá. ");
INSERT INTO yor_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Wọ́n mú ọrẹ wọn wá síwájú Olúwa: kẹ̀kẹ́ ẹrù mẹ́fà ti abo, àti akọ màlúù kan láti ọ̀dọ̀ olórí kọ̀ọ̀kan àti kẹ̀kẹ́ ẹrù kan láti ọ̀dọ̀ olórí méjì. Wọ́n sì kó wọn wá sí iwájú àgọ́. ");
INSERT INTO yor_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Gba gbogbo nǹkan wọ̀nyí lọ́wọ́ wọn, kí wọ́n ba à lè wúlò fún iṣẹ́ inú àgọ́ ìpàdé. Kó wọn fún àwọn ọmọ Lefi gẹ́gẹ́ bí iṣẹ́ ẹnìkọ̀ọ̀kan bá ṣe nílò rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Mose sì kó àwọn kẹ̀kẹ́ ẹrù àti akọ màlúù náà fún àwọn ọmọ Lefi. ");
INSERT INTO yor_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ó fún àwọn ọmọ Gerṣoni ní kẹ̀kẹ́ méjì àti akọ màlúù mẹ́rin, gẹ́gẹ́ bí iṣẹ́ wọn ṣe jẹ mọ́. ");
INSERT INTO yor_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ó fún àwọn ọmọ Merari ní kẹ̀kẹ́ mẹ́rin àti akọ màlúù mẹ́jọ gẹ́gẹ́ bí iṣẹ́ wọn ṣe jẹ mọ́. Gbogbo wọn wà lábẹ́ àkóso Itamari ọmọ Aaroni tí í ṣe àlùfáà. ");
INSERT INTO yor_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ṣùgbọ́n Mose kò fún àwọn ọmọ Kohati ní nǹkan kan nítorí pé èjìká wọn ni wọn yóò fi ru àwọn ohun mímọ́ èyí tí ó jẹ́ ojúṣe tiwọn. ");
INSERT INTO yor_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Nígbà tí a ta òróró sórí pẹpẹ. Àwọn olórí mú àwọn ọrẹ wọn wá fún ìyàsímímọ́ rẹ̀, wọ́n sì kó wọn wá síwájú pẹpẹ. ");
INSERT INTO yor_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Nítorí tí Olúwa ti sọ fún Mose pé, “Olórí kọ̀ọ̀kan ní ọjọ́ kọ̀ọ̀kan ni yóò máa mú ọrẹ tirẹ̀ wá fún ìyàsímímọ́ pẹpẹ.” ");
INSERT INTO yor_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Ẹni tí ó mú ọrẹ tirẹ̀ wá ní ọjọ́ kìn-ín-ní Nahiṣoni ọmọ Amminadabu láti inú ẹ̀yà Juda. ");
INSERT INTO yor_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ọrẹ rẹ̀ jẹ́: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò ti fàdákà tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́ àwo kọ̀ọ̀kan kún fún ìyẹ̀fun kíkúnná dáradára tí a fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí; ");
INSERT INTO yor_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ọ̀dọ́ akọ màlúù kan, àgbò kan, akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun, ");
INSERT INTO yor_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀, ");
INSERT INTO yor_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","akọ màlúù méjì, àgbò márùn-ún, òbúkọ ọlọ́dún kan márùn-ún tí wọn ó fi rú ẹbọ àlàáfíà. Wọ̀nyí ni ọrẹ Nahiṣoni ọmọ Amminadabu. ");
INSERT INTO yor_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ní ọjọ́ kejì ni Netaneli ọmọ Suari olórí àwọn ọmọ Isakari mú ọrẹ tirẹ̀ wá. ");
INSERT INTO yor_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ọrẹ tí ó kó wá ní: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí, ");
INSERT INTO yor_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ọ̀dọ́ akọ màlúù kan, àgbò kan, àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan, fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Màlúù méjì, àgbò márùn-ún, akọ ewúrẹ́ márùn-ún àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan márùn-ún tí wọn ó fi rú ẹbọ àlàáfíà. Èyí ni ọrẹ Netaneli ọmọ Suari. ");
INSERT INTO yor_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Eliabu ọmọ Heloni, olórí àwọn ọmọ Sebuluni ni ó mú ọrẹ rẹ̀ wá ní ọjọ́ kẹta. ");
INSERT INTO yor_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Àwọn ọrẹ rẹ̀ ni: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí; ");
INSERT INTO yor_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","akọ ọ̀dọ́ màlúù kan, àgbò kan àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Màlúù méjì, àgbò márùn-ún, òbúkọ márùn-ún akọ ọ̀dọ́-àgùntàn ọlọ́dún kan márùn-ún tí wọn o fi rú ẹbọ àlàáfíà. Èyí ni ọrẹ Eliabu ọmọ Heloni. ");
INSERT INTO yor_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Elisuri ọmọ Ṣedeuri olórí àwọn ọmọ Reubeni ni ó mú ọrẹ wá ní ọjọ́ kẹrin. ");
INSERT INTO yor_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ọrẹ rẹ̀ ni: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí, ");
INSERT INTO yor_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","akọ ọ̀dọ́ màlúù kan, àgbò kan àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","màlúù méjì, àgbò márùn-ún, akọ ewúrẹ́ márùn-ún àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan márùn-ún tí wọn ó fi rú ẹbọ àlàáfíà. Èyí ni ọrẹ Elisuri ọmọ Ṣedeuri. ");
INSERT INTO yor_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ṣelumieli ọmọ Suriṣaddai, olórí àwọn ọmọ Simeoni ni ó mú ọrẹ wá ní ọjọ́ karùn-ún. ");
INSERT INTO yor_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ọrẹ tí ó kó wá ni: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí; ");
INSERT INTO yor_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","akọ ọ̀dọ́ màlúù kan, àgbò kan àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","màlúù méjì, àgbò márùn-ún, akọ ewúrẹ́ márùn-ún àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan márùn-ún tí wọn ó fi rú ẹbọ àlàáfíà. Èyí ni ọrẹ Ṣelumieli ọmọ Suriṣaddai. ");
INSERT INTO yor_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Eliasafu ọmọ Deueli olórí àwọn ọmọ Gadi ní ó mú ọrẹ rẹ̀ wá ní ọjọ́ kẹfà. ");
INSERT INTO yor_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ọrẹ rẹ̀ ni: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí; ");
INSERT INTO yor_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","akọ ọ̀dọ́ màlúù kan, àgbò kan àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","màlúù méjì, àgbò márùn-ún, akọ ewúrẹ́ márùn-ún àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan márùn-ún, wọn ó fi rú ẹbọ àlàáfíà. Èyí ni ọrẹ Eliasafu ọmọ Deueli. ");
INSERT INTO yor_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Eliṣama ọmọ Ammihudu, olórí àwọn ọmọ Efraimu ni ó mú ọrẹ rẹ̀ wá ní ọjọ́ keje. ");
INSERT INTO yor_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ọrẹ rẹ̀ ni: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí; ");
INSERT INTO yor_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","akọ ọ̀dọ́ màlúù kan, àgbò kan àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","màlúù méjì, àgbò márùn-ún, akọ ewúrẹ́ márùn-ún àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan márùn-ún, tí wọn ó fi rú ẹbọ àlàáfíà. Èyí ni ọrẹ Eliṣama ọmọ Ammihudu. ");
INSERT INTO yor_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Gamalieli ọmọ Pedasuri, olórí àwọn ọmọ Manase ni ó mú ọrẹ tirẹ̀ wá ní ọjọ́ kẹjọ. ");
INSERT INTO yor_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ọrẹ tirẹ̀ ni: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí; ");
INSERT INTO yor_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","akọ ọ̀dọ́ màlúù kan, àgbò kan àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","màlúù méjì, àgbò márùn-ún, akọ ewúrẹ́ márùn-ún àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan márùn-ún tí wọn ó fi rú ẹbọ àlàáfíà. Èyí ni ọrẹ Gamalieli ọmọ Pedasuri. ");
INSERT INTO yor_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Abidani ọmọ Gideoni, olórí àwọn ọmọ Benjamini ni ó mú ọrẹ tirẹ̀ wá ní ọjọ́ kẹsànán. ");
INSERT INTO yor_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ọrẹ rẹ̀ ni: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí; ");
INSERT INTO yor_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","akọ ọ̀dọ́ màlúù kan, àgbò kan àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","màlúù méjì, àgbò márùn-ún, akọ ewúrẹ́ márùn-ún àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan márùn-ún tí wọn ó fi rú ẹbọ àlàáfíà. Èyí ni ọrẹ Abidani ọmọ Gideoni. ");
INSERT INTO yor_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ahieseri ọmọ Ammiṣaddai, olórí àwọn ọmọ Dani ni ó mú ọrẹ tirẹ̀ wá ní ọjọ́ kẹwàá. ");
INSERT INTO yor_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ọrẹ rẹ̀ ni: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí; ");
INSERT INTO yor_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","akọ ọ̀dọ́ màlúù kan, àgbò kan àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","àti fún ẹbọ ti ẹbọ àlàáfíà, akọ màlúù méjì, àgbò márùn-ún, òbúkọ márùn-ún, akọ ọ̀dọ́-àgùntàn márùn-ún ọlọ́dún kan. Èyí ni ọrẹ ẹbọ tí Ahieseri ọmọ Ammiṣaddai. ");
INSERT INTO yor_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Pagieli ọmọ Okanri, olórí àwọn ọmọ Aṣeri ni ó mú ọrẹ rẹ̀ wá ní ọjọ́ kọkànlá. ");
INSERT INTO yor_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ọrẹ rẹ̀ ni: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí; ");
INSERT INTO yor_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","akọ ọ̀dọ́ màlúù kan, àgbò kan àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","akọ ewúrẹ́ fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","màlúù méjì, àgbò márùn-ún, akọ ewúrẹ́ márùn-ún àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan márùn-ún, tí wọn ó fi rú ẹbọ àlàáfíà. Èyí ni ọrẹ Pagieli ọmọ Okanri. ");
INSERT INTO yor_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ahira ọmọ Enani, olórí àwọn Naftali ni ó mú ọrẹ rẹ̀ wá ní ọjọ́ kejìlá. ");
INSERT INTO yor_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ọrẹ rẹ̀ ni: àwo fàdákà kan tí ìwọ̀n rẹ̀ jẹ́ àádóje ṣékélì àti àwokòtò tí ìwọ̀n rẹ̀ jẹ́ àádọ́rin ṣékélì, méjèèjì gẹ́gẹ́ bí iye owó ibi mímọ́, àwo kọ̀ọ̀kan sì kún fún ìyẹ̀fun kíkúnná dáradára tí á fi òróró pò gẹ́gẹ́ bí ẹbọ ohun jíjẹ; ");
INSERT INTO yor_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","àwo wúrà kan tí ìwọ̀n rẹ̀ jẹ́ ṣékélì mẹ́wàá tí ó kún fún tùràrí; ");
INSERT INTO yor_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","akọ ọ̀dọ́ màlúù kan àgbò kan, àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan fún ẹbọ sísun; ");
INSERT INTO yor_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀; ");
INSERT INTO yor_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","màlúù méjì, àgbò márùn-ún, akọ ewúrẹ́ márùn-ún àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan márùn-ún, wọn ó fi rú ẹbọ àlàáfíà. Èyí ni ọrẹ Ahira ọmọ Enani. ");
INSERT INTO yor_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Wọ̀nyí ni ọrẹ tí àwọn olórí àwọn ọmọ Israẹli mú wá fún ìyàsímímọ́ pẹpẹ nígbà tí wọ́n ta òróró sí i lórí: àwo fàdákà méjìlá, àwokòtò méjìlá, àwo wúrà méjìlá. ");
INSERT INTO yor_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Àwo fàdákà kọ̀ọ̀kan wọn àádóje ṣékélì, àwokòtò kọ̀ọ̀kan sì wọn àádọ́rin. Àpapọ̀ gbogbo àwo fàdákà jẹ́ egbèjìlá (2,400) ṣékélì gẹ́gẹ́ bí iye owó ibi mímọ́. ");
INSERT INTO yor_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ọ̀kọ̀ọ̀kan àwo wúrà méjìlá tí tùràrí kún inú wọn ṣékélì mẹ́wàá mẹ́wàá gẹ́gẹ́ bí iye owó ibi mímọ́. Àpapọ̀ ìwọ̀n gbogbo àwo wúrà jẹ́ ọgọ́fà ṣékélì. ");
INSERT INTO yor_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Àpapọ̀ iye ẹran fún ẹbọ sísun jẹ́ akọ ọ̀dọ́ màlúù méjìlá, àgbò méjìlá, akọ ọ̀dọ́-àgùntàn ọlọ́dún kan méjìlá pẹ̀lú ọrẹ ohun jíjẹ. Akọ ewúrẹ́ fún ẹbọ ẹ̀ṣẹ̀ jẹ́ méjìlá. ");
INSERT INTO yor_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Àpapọ̀ iye ẹran fún ọrẹ àlàáfíà jẹ́ màlúù mẹ́rìnlélógún, ọgọ́ta àgbò, ọgọ́ta akọ ewúrẹ́ àti ọgọ́ta akọ ọ̀dọ́ màlúù ọlọ́dún kan. Wọ̀nyí ni ọrẹ ìyàsímímọ́ pẹpẹ lẹ́yìn tí a ta òróró sí i. ");
INSERT INTO yor_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Nígbà tí Mose wọ inú àgọ́ ìpàdé láti bá Olúwa sọ̀rọ̀, Olúwa sì sọ̀rọ̀ sí i láti àárín àwọn kérúbù méjì láti orí ìtẹ́ àánú tí ó bo àpótí ẹ̀rí, ohùn náà sì bá Mose sọ̀rọ̀. ");
INSERT INTO yor_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Bá Aaroni sọ̀rọ̀ kí o wí fún un pé. ‘Nígbà tí ó bá ń to àwọn fìtílà, àwọn fìtílà méjèèje gbọdọ̀ tan ìmọ́lẹ̀ sí àyíká níwájú ọ̀pá fìtílà.’ ” ");
INSERT INTO yor_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaroni sì ṣe bẹ́ẹ̀; ó to àwọn fìtílà náà tí wọ́n sì fi kojú síwájú lórí ọ̀pá fìtílà gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Bí a ṣe ṣe ọ̀pá fìtílà náà nìyìí, a ṣe é láti ara wúrà lílù: láti ìsàlẹ̀ títí dé ibi ìtànná rẹ̀. Wọ́n ṣe ọ̀pá fìtílà náà gẹ́gẹ́ bí bátànì tí Olúwa fihan Mose. ");
INSERT INTO yor_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Yọ àwọn ọmọ Lefi kúrò láàrín àwọn ọmọ Israẹli yòókù, kí o sì wẹ̀ wọ́n mọ́. ");
INSERT INTO yor_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Báyìí ni kí o ṣe wẹ̀ wọ́n mọ́. Wọ́n omi ìwẹ̀nùmọ́ sí wọn lára, mú kí wọn ó fá irun ara wọn, kí wọn ó fọ aṣọ wọn, kí wọn ó ba à lè wẹ ara wọn mọ́ nípa ṣíṣe bẹ́ẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Jẹ́ kí wọn ó mú akọ ọ̀dọ́ màlúù pẹ̀lú ẹbọ ohun jíjẹ rẹ̀ tí í ṣe ìyẹ̀fun ìyẹ̀fun kíkúnná dáradára tí a fi òróró pò, kí ìwọ náà mú akọ ọ̀dọ́ màlúù kejì fún ẹbọ ẹ̀ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ìwọ ó sì mú àwọn ọmọ Lefi wá síwájú àgọ́ ìpàdé, kí o sì kó gbogbo àpapọ̀ ọmọ Israẹli jọ síbẹ̀ pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Báyìí ni kí o mú àwọn ọmọ Lefi wá síwájú Olúwa, gbogbo ọmọ Israẹli yóò sì gbọ́wọ́ lé àwọn ọmọ Lefi lórí. ");
INSERT INTO yor_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaroni yóò sì mú àwọn ọmọ Lefi wá síwájú Olúwa gẹ́gẹ́ bí ọrẹ fífì láti ọ̀dọ̀ àwọn ọmọ Israẹli wá, kí wọn lè máa ṣiṣẹ́ Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Lẹ́yìn tí àwọn ọmọ Lefi bá gbé ọwọ́ wọn lé orí àwọn akọ ọmọ màlúù náà, ìwọ yóò sì fi ọ̀kan rú ẹbọ ẹ̀ṣẹ̀ àti èkejì fún ẹbọ sísun sí Olúwa, láti ṣe ètùtù fún àwọn ọmọ Lefi. ");
INSERT INTO yor_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Mú kí àwọn ọmọ Lefi dúró níwájú Aaroni àti àwọn ọmọ rẹ̀ kí ó sì gbé wọn kalẹ̀ gẹ́gẹ́ bí ọrẹ fífì sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Báyìí ni ìwọ yóò ṣe ya ọmọ Lefi sọ́tọ̀, kúrò láàrín àwọn ọmọ Israẹli yòókù, àwọn ọmọ Lefi yóò sì jẹ́ tèmi. ");
INSERT INTO yor_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Lẹ́yìn tí ó ti wẹ àwọn ọmọ Lefi mọ́, tí ó sì ti gbé wọn kalẹ̀ bí ẹbọ fífì nígbà náà ni kí wọn ó lọ máa ṣiṣẹ́ nínú àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Nítorí pé àwọn ni ó jẹ́ ti Èmi pátápátá nínú àwọn ọmọ Israẹli. Mo ti gbà wọ́n fún ara mi dípò àwọn àkọ́bí àní àkọ́bí ọkùnrin gbogbo Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Nítorí pé gbogbo àkọ́bí ọmọ lọ́kùnrin ní Israẹli jẹ́ tèmi, ti ènìyàn àti ti ẹranko, láti ọjọ́ tí mo ti pa gbogbo àkọ́bí ní ilẹ̀ Ejibiti ni mo ti yà wọ́n sọ́tọ̀ fún ara mi. ");
INSERT INTO yor_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Mo sì ti gba àwọn ọmọ Lefi dípò gbogbo àkọ́bí ọmọ ọkùnrin nínú Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Nínú Israẹli, mo fi àwọn ọmọ Lefi fún Aaroni àti àwọn ọmọ rẹ̀ gẹ́gẹ́ bí ẹ̀bùn láti máa ṣiṣẹ́ nínú àgọ́ ìpàdé fun àwọn ọmọ Israẹli àti láti máa ṣe ètùtù fún wọn kí àjàkálẹ̀-ààrùn má ba à kọlu àwọn ọmọ Israẹli nígbà tí wọ́n bá súnmọ́ ibi mímọ́.” ");
INSERT INTO yor_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mose, Aaroni àti gbogbo ìjọ ènìyàn Israẹli sì ṣe fún àwọn ọmọ Lefi gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Àwọn ọmọ Lefi wẹ ara wọn mọ́, wọ́n sì fọ aṣọ wọn. Aaroni sì mú wọn wá gẹ́gẹ́ bí ọrẹ fífì níwájú Olúwa, Aaroni sì ṣe ètùtù fún wọn láti wẹ̀ wọ́n mọ́. ");
INSERT INTO yor_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Lẹ́yìn èyí àwọn ọmọ Lefi lọ sínú àgọ́ ìpàdé láti lọ máa ṣiṣẹ́ wọn lábẹ́ àbojútó Aaroni àti àwọn ọmọ rẹ̀. Wọ́n ṣe fún àwọn ọmọ Lefi gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Èyí ni ohun tó jẹ mọ́ àwọn ọmọ Lefi, láti ọmọ ọdún kẹẹdọ́gbọ̀n (25) tàbí jù bẹ́ẹ̀ lọ ni kí ó máa kópa nínú iṣẹ́ àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ṣùgbọ́n ẹni tó bá ti pé ọmọ àádọ́ta ọdún gbọdọ̀ ṣíwọ́ nínú iṣẹ́ ojoojúmọ́ wọn nínú àgọ́, kí wọ́n sì má ṣiṣẹ́ mọ́. ");
INSERT INTO yor_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Wọ́n le máa ran àwọn arákùnrin wọn lọ́wọ́ nínú àgọ́ ìpàdé ṣùgbọ́n àwọn fúnra wọn kò gbọdọ̀ ṣe iṣẹ́ kankan. Báyìí ni kí o ṣe pín iṣẹ́ fún àwọn ọmọ Lefi.” ");
INSERT INTO yor_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Olúwa sọ fún Mose nínú aginjù Sinai ní oṣù kìn-ín-ní ọdún kejì lẹ́yìn tí wọ́n kúrò ní ilẹ̀ Ejibiti wí pé, ");
INSERT INTO yor_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Mú kí àwọn ọmọ Israẹli máa pa àjọ ìrékọjá mọ́ ní àsìkò rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ẹ ṣe é ní àsìkò rẹ̀ gan an ní ìdajì ọjọ́ kẹrìnlá oṣù yìí ní ìbámu pẹ̀lú àwọn òfin àti ìlànà rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Mose sì sọ fún àwọn ọmọ Israẹli pé kí wọ́n máa pa àjọ ìrékọjá mọ́. ");
INSERT INTO yor_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Wọ́n sì ṣe àjọ ìrékọjá ní aginjù Sinai ní ìdajì ọjọ́ kẹrìnlá oṣù kìn-ín-ní. Àwọn ọmọ Israẹli ṣe gbogbo nǹkan gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Àwọn díẹ̀ nínú wọn kò lè ṣe àjọ ìrékọjá lọ́jọ́ náà nítorí pé wọ́n di aláìmọ́ nítorí òkú ènìyàn. Nítorí èyí wọ́n wá sọ́dọ̀ Mose àti Aaroni lọ́jọ́ náà. ");
INSERT INTO yor_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Wọ́n sọ fún Mose pé, “A di aláìmọ́ nípa òkú ènìyàn, ṣùgbọ́n kí ló dé tí a kò fi ní í le è fi ọrẹ wa fún Olúwa pẹ̀lú àwọn ará Israẹli yòókù ní àsìkò tí a ti yàn.” ");
INSERT INTO yor_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose sì dá wọn lóhùn pé, “Ẹ dúró kí n ba lè mọ ohun tí Olúwa yóò pàṣẹ nípa yín.” ");
INSERT INTO yor_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Nígbà náà ni Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Sọ fún àwọn ará Israẹli: ‘Bí ẹnìkan nínú yín tàbí nínú ìran yín bá di aláìmọ́ nípa òkú ènìyàn tàbí bí ó bá lọ sí ìrìnàjò síbẹ̀ yóò pa àjọ ìrékọjá Olúwa mọ́. ");
INSERT INTO yor_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Wọn yóò ṣe tiwọn ní ìdajì ọjọ́ kẹrìnlá oṣù kejì. Wọn yóò jẹ ẹran náà, pẹ̀lú àkàrà aláìwú àti ewúro. ");
INSERT INTO yor_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Wọn kò gbọdọ̀ ṣẹ́ ọ̀kankan kù di àárọ̀, wọn kò sì gbọdọ̀ ṣẹ́ eegun rẹ̀. Wọ́n gbọdọ̀ tẹ̀lé gbogbo ìlànà fún ṣíṣe àjọ ìrékọjá. ");
INSERT INTO yor_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ṣùgbọ́n bí ẹnìkan tó wà ní mímọ́ tí kò sì lọ sí ìrìnàjò bá kọ̀ láti pa àjọ ìrékọjá mọ́, irú ẹni bẹ́ẹ̀ ni a ó gé kúrò láàrín àwọn ènìyàn rẹ̀ nítorí pé kò mú ọrẹ Olúwa wá ní àsìkò tí ó yẹ. Ẹni náà yóò sì ru ẹ̀bi ẹ̀ṣẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Bí àlejò tí ń gbé láàrín yín bá fẹ́ ṣe àjọ ìrékọjá Olúwa, ó gbọdọ̀ pa á mọ́ ní ìbámu pẹ̀lú ìlànà àti òfin rẹ̀. Ìlànà kan náà ni kí ẹ ní fún àlejò àti àwọn ọmọ bíbí ilẹ̀ yín.’ ” ");
INSERT INTO yor_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ní ọjọ́ tí wọ́n gbé àgọ́ ró, èyí tí í ṣe àgọ́ ẹ̀rí, dúró, ìkùùkuu àwọsánmọ̀ bò ó mọ́lẹ̀. Ìkùùkuu náà sì dàbí iná ní orí àgọ́ láti ìrọ̀lẹ́ títí di òwúrọ̀. ");
INSERT INTO yor_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Bẹ́ẹ̀ ni ó sì rí nígbà gbogbo; ìkùùkuu bò ó, àti pé ní alẹ́ ìrísí rẹ̀ sì dàbí iná. ");
INSERT INTO yor_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Nígbàkígbà tí ìkùùkuu yìí bá ká sókè kúrò lórí àgọ́ ni àwọn ọmọ Israẹli yóò dìde láti máa lọ; ibikíbi tí ìkùùkuu náà bá dúró sí ni àwọn ọmọ Israẹli yóò pa ibùdó wọn sí. ");
INSERT INTO yor_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Nípa àṣẹ Olúwa ni àwọn ọmọ Israẹli ń jáde lọ, nípa àṣẹ Olúwa náà sì ni wọ́n ń pa ibùdó wọn. Nígbà tí ìkùùkuu bá dúró sórí àgọ́, àwọn náà yóò dúró sí ibùdó. ");
INSERT INTO yor_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Nígbà tí ìkùùkuu bá dúró sórí àgọ́ fún ìgbà pípẹ́, síbẹ̀ àwọn ọmọ Israẹli gbọ́rọ̀ sí àṣẹ Olúwa wọn kò sì ní gbéra láti lọ. ");
INSERT INTO yor_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ìgbà mìíràn ìkùùkuu lè wà lórí àgọ́ fún ọjọ́ díẹ̀; síbẹ̀ ní àṣẹ Olúwa, wọn yóò dúró ní ibùdó, bí ó sì tún yá, ní àṣẹ rẹ̀ náà ni wọn yóò gbéra. ");
INSERT INTO yor_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ìgbà mìíràn ìkùùkuu lè dúró láti ìrọ̀lẹ́ di àárọ̀, nígbà tó bá ṣí kúrò ní àárọ̀, wọn ó gbéra. Ìbá à ṣe ní ọ̀sán tàbí òru, ìgbàkígbà tí ìkùùkuu bá tó kúrò náà ni wọn ó tó gbéra. ");
INSERT INTO yor_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ìbá à ṣe fún ọjọ́ méjì, oṣù kan tàbí ọdún kan ni ìkùùkuu fi dúró sórí àgọ́, àwọn ọmọ Israẹli yóò dúró ní ibùdó wọn, wọn kò ní gbéra; ṣùgbọ́n nígbà tí ó bá lọ sókè ni wọn ó tó o gbéra. ");
INSERT INTO yor_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Nípa àṣẹ Olúwa ni wọ́n ń pa ibùdó wọn, nípa àṣẹ Olúwa náà sì ni wọ́n ń gbéra. Wọ́n gbọ́rọ̀ sí àṣẹ Olúwa ní ìbámu pẹ̀lú àṣẹ Olúwa láti ẹnu Mose. ");
INSERT INTO yor_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Ṣe fèrè fàdákà méjì pẹ̀lú fàdákà lílù, kí o máa lò ó láti máa fi pe ìjọ ènìyàn àti láti máa fi darí ìrìnàjò lọ sí ibùdó yín. ");
INSERT INTO yor_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Nígbà tí o bá fọn méjèèjì gbogbo ìjọ ènìyàn yóò pé síwájú rẹ ní ẹnu-ọ̀nà àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Bí ó bá jẹ́ ọ̀kan ni o fọn, nígbà náà ni àwọn olórí ẹ̀yà Israẹli yóò péjọ síwájú rẹ. ");
INSERT INTO yor_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Nígbà tí o bá fun ìpè ìdágìrì, àwọn ẹ̀yà tó pa ibùdó sí ìhà ìlà-oòrùn ni yóò gbéra. ");
INSERT INTO yor_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Nígbà tí o bá fun ìpè ìdágìrì kejì, ibùdó tó wà ní ìhà gúúsù ni yóò gbéra. Ìpè ìdágìrì yìí ni yóò jẹ́ àmì fún gbígbéra. ");
INSERT INTO yor_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Nígbà tí o bá fẹ́ pe ìjọ ènìyàn jọ, fun fèrè nìkan, má ṣe fun ti ìdágìrì pẹ̀lú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Àwọn ọmọ Aaroni tí í ṣe àlùfáà ni kí ó máa fun fèrè. Èyí yóò jẹ́ ìlànà láéláé fún yín àti fún ìran tó ń bọ̀. ");
INSERT INTO yor_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Nígbà tí ẹ bá lọ jagun pẹ̀lú àwọn ọ̀tá tó ń ni yín lára ní ilẹ̀ yín, ẹ fun ìpè ìdágìrì pẹ̀lú fèrè. A ó sì rántí yín níwájú Olúwa, Ọlọ́run yín yóò sì gbà yín lọ́wọ́ àwọn ọ̀tá yín. ");
INSERT INTO yor_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Bẹ́ẹ̀ náà ni ní ọjọ́ ayọ̀ yín, ní gbogbo àjọ̀dún tí a yàn àti ní ìbẹ̀rẹ̀ oṣù yín, ni kí ẹ máa fun fèrè lórí ẹbọ sísun àti ọrẹ àlàáfíà yín, wọn yóò sì jẹ́ ìrántí fún yín níwájú Ọlọ́run. Èmi ni Olúwa Ọlọ́run yín.” ");
INSERT INTO yor_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ní ogúnjọ́ oṣù kejì, ní ọdún kejì ni ìkùùkuu kúrò lórí tabanaku ẹ̀rí. ");
INSERT INTO yor_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Àwọn ọmọ Israẹli sì gbéra kúrò ní aginjù Sinai wọ́n sì rin ìrìnàjò wọn káàkiri títí tí ìkùùkuu fi dúró sí aginjù Parani. ");
INSERT INTO yor_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Wọ́n gbéra nígbà àkọ́kọ́ yìí nípa àṣẹ Olúwa láti ẹnu Mose. ");
INSERT INTO yor_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Àwọn ìpín ti ibùdó Juda ló kọ́kọ́ gbéra tẹ̀lé wọn lábẹ́ ogun wọn Nahiṣoni ọmọ Amminadabu ni ọ̀gágun wọn. ");
INSERT INTO yor_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netaneli ọmọ Suari ni ọ̀gágun ti ẹ̀yà Isakari; ");
INSERT INTO yor_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliabu ọmọ Heloni ni ọ̀gágun ni ìpín ti ẹ̀yà Sebuluni. ");
INSERT INTO yor_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Nígbà náà ni wọ́n sọ tabanaku kalẹ̀ àwọn ọmọ Gerṣoni àti Merari tó gbé àgọ́ sì gbéra. ");
INSERT INTO yor_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Àwọn ìpín ti ibùdó ti Reubeni ló gbéra tẹ̀lé wọn, lábẹ́ ọ̀págun wọn. Elisuri ọmọ Ṣedeuri ni ọ̀gágun wọn. ");
INSERT INTO yor_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ṣelumieli ọmọ Suriṣaddai ni ọ̀gágun ti ẹ̀yà Simeoni. ");
INSERT INTO yor_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasafu ọmọ Deueli ni ọ̀gágun ìpín ti ẹ̀yà Gadi. ");
INSERT INTO yor_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Nígbà náà ni àwọn ọmọ Kohati tí ń ru ohun mímọ́ náà gbéra. Àwọn ti àkọ́kọ́ yóò sì ti gbé tabanaku dúró kí wọn tó dé. ");
INSERT INTO yor_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Àwọn ìpín tó wà ní ibùdó Efraimu ló tún kàn lábẹ́ ọ̀págun wọn. Eliṣama ọmọ Ammihudu ni ọ̀gágun wọn. ");
INSERT INTO yor_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalieli ọmọ Pedasuri ni ọ̀gágun ìpín ti ẹ̀yà Manase. ");
INSERT INTO yor_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidani ọmọ Gideoni ni ọ̀gágun ìpín ti ẹ̀yà Benjamini. ");
INSERT INTO yor_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Lákòótan, àwọn ọmọ-ogun tó ń mójútó ẹ̀yìn ló tún kàn, àwọn ni ìpín ti ibùdó Dani lábẹ́ ọ̀págun wọn. Ahieseri ọmọ Ammiṣaddai ni ọ̀gágun wọn. ");
INSERT INTO yor_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli ọmọ Okanri ni ìpín ti ẹ̀yà Aṣeri, ");
INSERT INTO yor_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira ọmọ Enani ni ọ̀gágun ti ẹ̀yà Naftali. ");
INSERT INTO yor_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Báyìí ni àwọn ọmọ Israẹli ṣe tò jáde gẹ́gẹ́ bí ogun nígbà tí wọ́n bẹ̀rẹ̀ ìrìnàjò wọn. ");
INSERT INTO yor_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mose sì sọ fún Hobabu ọmọ Reueli ará Midiani tí í ṣe àna rẹ̀ pé, “A ń gbéra láti lọ sí ibi tí Olúwa sọ pé, ‘Èmi ó fi fún un yín.’ Bá wa lọ, àwa ó ṣe ọ́ dáradára nítorí pé Olúwa ti ṣèlérí ohun rere fún Israẹli.” ");
INSERT INTO yor_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ó sì dáhùn pé, “Rárá, èmi kò ní bá yín lọ, mò ń padà lọ sí ilẹ̀ mi àti sí ọ̀dọ̀ àwọn ènìyàn mi.” ");
INSERT INTO yor_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mose sì sọ pé, “Jọ̀wọ́ ma fi wá sílẹ̀, ìwọ mọ ibi tí a lè pa ibùdó sí nínú aginjù, ìwọ yóò sì jẹ́ ojú fún wa. ");
INSERT INTO yor_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Bí o bá bá wa lọ, a ó sì pín fún ọ nínú ohun rere yówù tí Olúwa bá fún wa.” ");
INSERT INTO yor_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Wọ́n sì gbéra láti orí òkè Olúwa ní ìrìn ọjọ́ mẹ́ta. Àpótí ẹ̀rí Olúwa ń lọ níwájú wọn fún gbogbo ọjọ́ mẹ́ta yìí láti wá ibi ìsinmi fún wọn. ");
INSERT INTO yor_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ìkùùkuu Olúwa wà lórí wọn lọ́sàn nígbà tí wọ́n gbéra kúrò ní ibùdó. ");
INSERT INTO yor_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Nígbàkígbà tí àpótí ẹ̀rí bá gbéra Mose yóò sì wí pé, “Dìde, Olúwa! Kí a tú àwọn ọ̀tá rẹ ká, kí àwọn tí ó kórìíra rẹ sì sálọ níwájú rẹ.” ");
INSERT INTO yor_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Nígbàkígbà tí àpótí ẹ̀rí bá sinmi yóò wí pé, “Padà, Olúwa, sọ́dọ̀ àwọn àìmoye ẹgbẹẹgbẹ̀rún Israẹli.” ");
INSERT INTO yor_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Àwọn ènìyàn ń ṣe àròyé nípa wàhálà wọn sí etí ìgbọ́ Olúwa. Ìbínú Olúwa sì ru sókè nígbà tí ó gbọ́ àròyé yìí. Nígbà náà ni iná jáde láti ọ̀dọ̀ Olúwa bọ́ sí àárín wọn, ó sì run àwọn tó wà ní òpin ibùdó. ");
INSERT INTO yor_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Nígbà náà ni àwọn ènìyàn kígbe sí Mose, Mose sì gbàdúrà sí Olúwa iná náà sì kú. ");
INSERT INTO yor_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Wọ́n sì ń pe ibẹ̀ ní Tabera nítorí pé, iná láti ọ̀dọ̀ Olúwa jó láàrín wọn. ");
INSERT INTO yor_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Àwọn ọ̀pọ̀ ènìyàn aláìníláárí tó wà láàrín àwọn ọmọ Israẹli pẹ̀lú ọkàn ìfẹ́kúfẹ̀ẹ́ wọn fi ìtara béèrè fún oúnjẹ mìíràn, àwọn ọmọ Israẹli náà bá bẹ̀rẹ̀ sí í sọkún wí pé, “Bí i pé kí á rí ẹran jẹ báyìí! ");
INSERT INTO yor_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Àwa rántí ẹja tí à ń jẹ lọ́fẹ̀ẹ́ ní Ejibiti, apálà, bàrà, ewébẹ̀, àlùbọ́sà àti àwọn ẹ̀fọ́ mìíràn. ");
INSERT INTO yor_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ṣùgbọ́n báyìí gbogbo ara wa ti gbẹ, kò sí ohun mìíràn láti jẹ àfi manna nìkan tí a rí yìí!” ");
INSERT INTO yor_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna náà dàbí èso korianderi, ìrísí rẹ̀ sì dàbí oje igi. ");
INSERT INTO yor_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Àwọn ènìyàn náà ń lọ káàkiri láti kó o, wọn ó lọ̀ ọ́ lórí ọlọ tàbí kí wọ́n gún un nínú odó. Wọ́n le sè é nínú ìkòkò tàbí kí wọn ó fi ṣe àkàrà, adùn rẹ̀ yóò sì dàbí adùn ohun tí a fi òróró ṣe. ");
INSERT INTO yor_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Nígbà tí ìrì bá ẹ̀ sí ibùdó lórí ni manna náà máa ń bọ́ pẹ̀lú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mose sì gbọ́ tí àwọn ènìyàn ń sọkún ní gbogbo ìdílé wọn, oníkálùkù ní ẹnu-ọ̀nà àgọ́ tirẹ̀. Olúwa sì bínú gidigidi. Inú Mose sì bàjẹ́ pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mose sì béèrè lọ́wọ́ Olúwa pé, “Kí ló dé tí o fi mú wàhálà yìí bá ìránṣẹ́ rẹ? Kí ni mo ṣe tí n kò fi tẹ ọ lọ́rùn tí ìwọ fi di ẹrù àwọn ènìyàn wọ̀nyí lé mi lórí. ");
INSERT INTO yor_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Èmi ni mo ha lóyún gbogbo àwọn ènìyàn wọ̀nyí bí? Àbí èmi ló bí wọn? Tí ìwọ fi sọ fún mi pé, máa gbé wọn sí oókan àyà rẹ, gẹ́gẹ́ bí abiyamọ ti máa ń gbe ọmọ ọmú lọ sí ilẹ̀ tí o ti búra láti fún àwọn baba ńlá wọn. ");
INSERT INTO yor_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Níbo ni n ó ti rí ẹran fún àwọn ènìyàn wọ̀nyí? Nítorí wọ́n ń sọkún sí mi pé, ‘Fún wa lẹ́ran jẹ́!’ ");
INSERT INTO yor_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Èmi nìkan kò lè dágbé wàhálà àwọn ènìyàn wọ̀nyí, ẹrù wọn ti wúwo jù fún mi. ");
INSERT INTO yor_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Bí ó bá sì ṣe pé báyìí ni ìwọ ó ṣe máa ṣe fún mi, kúkú pa mí báyìí, tí mo bá ti bá ojúrere rẹ pàdé—kí ojú mi má ba à rí ìparun mi.” ");
INSERT INTO yor_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Nígbà náà ni Olúwa sọ fún Mose pé, “Mú àádọ́rin ọkùnrin nínú àwọn àgbàgbà àwọn ọmọ Israẹli, àwọn tí o mọ̀ gẹ́gẹ́ bí olórí àti olóyè láàrín àwọn ènìyàn wá sínú àgọ́ ìpàdé, kí wọ́n lé dúró níwájú mi. ");
INSERT INTO yor_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Èmi ó sì sọ̀kalẹ̀ wá bá yín sọ̀rọ̀ níbẹ̀. Èmi ó sì mú díẹ̀ nínú agbára Ẹ̀mí tí ń bẹ lára rẹ láti fi sí orí àwọn ènìyàn wọ̀nyí. Wọn ó sì máa ràn ọ́ lọ́wọ́ láti ru àjàgà àwọn ènìyàn kí ó má ṣe pé ìwọ nìkan ni ó o máa ru àjàgà náà. ");
INSERT INTO yor_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Sọ fún àwọn ènìyàn náà pé, ‘Ẹ ya ara yín sí mímọ́ ní ìmúrasílẹ̀ fún ọ̀la, ẹ ó sì jẹ ẹran. Nítorí pé Olúwa ti gbọ́ igbe ẹkún yín, èyí tí ẹ sun pé, “Ìbá ṣe pé a lè rí ẹran jẹ ni! Ó sàn fún wa ní Ejibiti jù báyìí lọ!” Nítorí náà ni Olúwa yóò fi fún yín ní ẹran, ẹ ó sì jẹ ẹ́. ");
INSERT INTO yor_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ẹ kò ní i jẹ ẹ́ fún ọjọ́ kan, ọjọ́ méjì, ọjọ́ márùn-ún, ọjọ́ mẹ́wàá tàbí ogúnjọ́ lásán, ");
INSERT INTO yor_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ṣùgbọ́n fún odidi oṣù kan, títí tí ẹran náà yóò fi máa yọ ní imú yín, tí yóò sì sú yín, nítorí pé ẹ ti kẹ́gàn Olúwa tí ó wà láàrín yín, ẹ sì ti sọkún fún un wí pé, “Kí ló dé tí a fi kúrò ní Ejibiti gan an?” ’ ” ");
INSERT INTO yor_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ṣùgbọ́n Mose sọ pé, “Mo wà láàrín ọgbọ̀n ọ̀kẹ́ ènìyàn (600,000) ni ìrìnkiri, ó sì sọ pé, ‘Èmi ó fún wọn ní ẹran láti jẹ fún oṣù kan gbáko!’ ");
INSERT INTO yor_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ǹjẹ́ bí a tilẹ̀ pa àgbò ẹran àti ọmọ ẹran, yóò ha tó wọn bí? Tàbí bí a tilẹ̀ pa gbogbo ẹja inú omi fún wọn, yóò wa tó bí?” ");
INSERT INTO yor_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Olúwa sì dá Mose lóhùn pé, “Ọwọ́ Olúwa ha kúrú bí? Ìwọ yóò ri nísinsin yìí bóyá ọ̀rọ̀ tí mo sọ yóò ṣẹ tàbí kò ni í ṣẹ.” ");
INSERT INTO yor_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mose sì jáde, ó sọ ohun tí Olúwa wí fún àwọn ènìyàn. Ó mú àwọn àádọ́rin àgbàgbà Israẹli dúró yí àgọ́ ká. ");
INSERT INTO yor_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Nígbà náà ni Olúwa sọ̀kalẹ̀ nínú àwọ̀ sánmọ̀ ó sì bá wọn sọ̀rọ̀, ó sì mú lára Ẹ̀mí tó wà lára Mose sí ara àwọn àádọ́rin àgbàgbà náà, Ó sì ṣẹlẹ̀ pé nígbà tí Ẹ̀mí náà bà lé wọn, wọ́n sọtẹ́lẹ̀, ṣùgbọ́n lẹ́yìn èyí wọn kò sọtẹ́lẹ̀ mọ́. ");
INSERT INTO yor_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Àwọn ọkùnrin méjì, tí orúkọ wọn ń jẹ́ Eldadi àti Medadi kò kúrò nínú àgọ́. Orúkọ wọn wà lára àádọ́rin àgbàgbà yìí ṣùgbọ́n wọn kò jáde nínú àgọ́ síbẹ̀ Ẹ̀mí náà bà lé wọn, wọ́n sì sọtẹ́lẹ̀ nínú àgọ́. ");
INSERT INTO yor_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ọmọkùnrin kan sì sáré lọ sọ fún Mose pé, “Eldadi àti Medadi ń sọtẹ́lẹ̀ nínú àgọ́.” ");
INSERT INTO yor_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joṣua ọmọ Nuni tí í ṣe ìránṣẹ́ Mose, láti kékeré tó jẹ́ ọ̀kan nínú àwọn ọmọkùnrin rẹ̀ dáhùn pé, “Mose olúwa mi, dá wọn lẹ́kun!” ");
INSERT INTO yor_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mose sì wí fún un pé, “Àbí ìwọ ń jowú nítorí mi? Ìbá ti wù mí tó, kí gbogbo àwọn ènìyàn Olúwa jẹ́ wòlíì, kí Olúwa sì fi Ẹ̀mí rẹ̀ sí wọn lára!” ");
INSERT INTO yor_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mose àti àwọn àgbàgbà Israẹli yìí sì padà sínú àgọ́. ");
INSERT INTO yor_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Afẹ́fẹ́ sì jáde láti ọ̀dọ̀ Olúwa ó sì kó àparò wá láti inú Òkun. Ó sì dà wọ́n káàkiri gbogbo ibùdó ní ìwọ̀n gíga ẹsẹ̀ bàtà mẹ́ta sórí ilẹ̀, bí ìwọ̀n ìrìn ọjọ́ kan ní gbogbo àyíká. ");
INSERT INTO yor_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ní gbogbo ọjọ́ náà àti òru, títí dé ọjọ́ kejì ni àwọn ènìyàn fi ń kó àparò yìí, ẹni tó kó kéré jùlọ kó ìwọ̀n homeri mẹ́wàá, wọ́n sì ṣà wọ́n sílẹ̀ fún ara wọn yí gbogbo ibùdó. ");
INSERT INTO yor_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ṣùgbọ́n nígbà tí ẹran náà sì wà láàrín eyín wọn, kó tó di pé wọ́n jẹ ẹ́, ìbínú Olúwa sì ru sí àwọn ènìyàn, ó sì pa wọ́n pẹ̀lú àjàkálẹ̀-ààrùn. ");
INSERT INTO yor_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Torí èyí ni wọ́n ṣe pe ibẹ̀ ní Kibirotu-Hattaafa nítorí pé níbẹ̀ ni wọ́n gbé sìnkú àwọn ènìyàn tó ní ọ̀kánjúwà oúnjẹ sí. ");
INSERT INTO yor_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Àwọn ènìyàn yòókù sì gbéra láti Kibirotu-Hattaafa lọ pa ibùdó sí Haserotu wọ́n sì dúró níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriamu àti Aaroni sọ̀rọ̀-òdì sí Mose nítorí pé ó fẹ́ obìnrin ará Etiopia. ");
INSERT INTO yor_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Wọ́n sì wí pé, “Nípa Mose nìkan ni Olúwa ti sọ̀rọ̀ bí, kò ha ti ipa wa sọ̀rọ̀ bí?” Olúwa sì gbọ́ èyí. ");
INSERT INTO yor_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Mose sì jẹ́ ọlọ́kàn tútù ju gbogbo ènìyàn tó wà lórí ilẹ̀ ayé lọ). ");
INSERT INTO yor_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Lẹ́ẹ̀kan náà ni Olúwa sọ fún Mose, Aaroni àti Miriamu pé, “Ẹ̀yin mẹ́tẹ̀ẹ̀ta, jáde wá sínú àgọ́ ìpàdé.” Àwọn mẹ́tẹ̀ẹ̀ta sì jáde síta. ");
INSERT INTO yor_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Nígbà náà ni Olúwa sọ̀kalẹ̀ nínú ọ̀wọ́n ìkùùkuu, ó sì dúró ní ẹnu-ọ̀nà àgọ́, ó ké sí Aaroni àti Miriamu. Àwọn méjèèjì sì bọ́ síwájú, ");
INSERT INTO yor_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ó wí pé, “Ẹ gbọ́ ọ̀rọ̀ mi, “Bí wòlíì Olúwa bá wà láàrín yín, Èmi Olúwa a máa fi ara à mi hàn án ní ojúran, Èmi a máa bá a sọ̀rọ̀ nínú àlá. ");
INSERT INTO yor_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ṣùgbọ́n èyí kò rí bẹ́ẹ̀ pẹ̀lú Mose ìránṣẹ́ mi; ó jẹ́ olóòtítọ́ nínú gbogbo ilé mi. ");
INSERT INTO yor_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mo sì ń bá a sọ̀rọ̀ ní ojúkojú, ọ̀rọ̀ yékéyéké tí kì í ṣe òwe, ó rí àwòrán Olúwa. Kí ló wá dé tí ẹ̀yin kò ṣe bẹ̀rù láti sọ̀rọ̀-òdì sí Mose ìránṣẹ́ mi?” ");
INSERT INTO yor_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ìbínú Olúwa sì ru sókè sí wọn Olúwa sì fi wọ́n sílẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Nígbà tí ìkùùkuu kúrò lórí àgọ́ lójijì ni Miriamu di adẹ́tẹ̀, ó funfun bí i yìnyín. Aaroni sì padà wo Miriamu ó sì rí i pé ó ti di adẹ́tẹ̀, ");
INSERT INTO yor_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aaroni sì wí fún Mose pé, “Jọ̀wọ́ olúwa mi, má ṣe ka ẹ̀ṣẹ̀, èyí tí a fi ìwà òmùgọ̀ dá sí wa lọ́rùn. ");
INSERT INTO yor_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Má ṣe jẹ́ kí ó dàbí òkú ọmọ tí a bí, tí ìdajì ara rẹ̀ ti rà dànù.” ");
INSERT INTO yor_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Torí èyí Mose sì kígbe sí Olúwa, “Ọlọ́run, jọ̀wọ́, mú un láradá!” ");
INSERT INTO yor_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Olúwa sì dá Mose lóhùn, “Bí baba rẹ̀ bá tutọ́ sí i lójú, ojú kò wa ní í tì í fún ọjọ́ méje? Dá a dúró sí ẹ̀yìn ibùdó fún ọjọ́ méje, lẹ́yìn èyí ki a tó ó le mú wọlé.” ");
INSERT INTO yor_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriamu sì dúró sí ẹ̀yìn ibùdó fún ọjọ́ méje, àwọn ènìyàn kò sì tẹ̀síwájú nínú ìrìnàjò wọn títí tí Miriamu fi wọ inú ibùdó padà. ");
INSERT INTO yor_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Lẹ́yìn èyí, àwọn ènìyàn kúrò ní Haserotu, wọ́n sì pa ibùdó sí aginjù Parani. ");
INSERT INTO yor_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Rán ènìyàn díẹ̀ láti lọ yẹ ilẹ̀ Kenaani wò èyí tí mo ti fún àwọn ọmọ Israẹli. Rán ẹnìkọ̀ọ̀kan, tí ó jẹ́ olórí láti inú ẹ̀yà kọ̀ọ̀kan.” ");
INSERT INTO yor_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mose sì rán wọn jáde láti aginjù Parani gẹ́gẹ́ bí àṣẹ Olúwa. Gbogbo wọn jẹ́ olórí àwọn ènìyàn Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Orúkọ wọn nìwọ̀nyí: láti inú ẹ̀yà Reubeni, Ṣammua ọmọ Sakkuri; ");
INSERT INTO yor_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","láti inú ẹ̀yà Simeoni, Ṣafati ọmọ Hori; ");
INSERT INTO yor_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","láti inú ẹ̀yà Juda, Kalebu ọmọ Jefunne; ");
INSERT INTO yor_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","láti inú ẹ̀yà Isakari, Igali ọmọ Josẹfu; ");
INSERT INTO yor_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","láti inú ẹ̀yà Efraimu, Hosea ọmọ Nuni; ");
INSERT INTO yor_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","láti inú ẹ̀yà Benjamini, Palti ọmọ Rafu; ");
INSERT INTO yor_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","láti inú ẹ̀yà Sebuluni, Daddieli ọmọ Sodi; ");
INSERT INTO yor_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","láti inú ẹ̀yà Manase (ẹ̀yà Josẹfu), Gaddi ọmọ Susi; ");
INSERT INTO yor_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","láti inú ẹ̀yà Dani, Ammieli ọmọ Gemalli; ");
INSERT INTO yor_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","láti inú ẹ̀yà Aṣeri, Seturu ọmọ Mikaeli. ");
INSERT INTO yor_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","láti inú ẹ̀yà Naftali, Nabi ọmọ Fofsi; ");
INSERT INTO yor_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","láti inú ẹ̀yà Gadi, Geueli ọmọ Maki. ");
INSERT INTO yor_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Wọ̀nyí ni orúkọ àwọn ènìyàn tí Mose rán láti lọ yẹ ilẹ̀ náà wò. (Hosea ọmọ Nuni ni Mose sọ ní Joṣua.) ");
INSERT INTO yor_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Nígbà tí Mose rán wọn lọ láti yẹ ilẹ̀ Kenaani wò, ó sọ fún wọn pé, “Ẹ gba ọ̀nà gúúsù lọ títí dé àwọn ìlú olókè. ");
INSERT INTO yor_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ẹ wò ó bí ilẹ̀ náà ti rí, bóyá àwọn tó ń gbé ilẹ̀ náà jẹ́ alágbára tàbí aláìlágbára, bóyá wọ́n pọ̀ tàbí wọn kéré. ");
INSERT INTO yor_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Irú ilẹ̀ wo ni wọ́n gbé? Ṣé ilẹ̀ tó dára ni àbí èyí tí kò dára? Báwo ni ìlú wọn ti rí? Ṣé ìlú olódi ni àbí èyí tí kò ní odi? ");
INSERT INTO yor_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Báwo ni ilẹ̀ náà ti rí? Ṣé ilẹ̀ ọlọ́ràá ni tàbí aṣálẹ̀? Ṣé igi wà níbẹ̀ àbí kò sí? E sa ipá yín láti rí i pé ẹ mú díẹ̀ nínú èso ilẹ̀ náà wá.” (Ìgbà náà sì jẹ́ àkókò àkọ́pọ́n èso àjàrà gireepu.) ");
INSERT INTO yor_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Bẹ́ẹ̀ ni wọ́n gòkè lọ láti yẹ ilẹ̀ náà wò, wọ́n lọ láti aginjù Sini títí dé Rehobu lọ́nà Lebo-Hamati. ");
INSERT INTO yor_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Wọ́n gba gúúsù lọ sí Hebroni níbi tí Ahimani, Ṣeṣai àti Talmai tí í ṣe irú-ọmọ Anaki ń gbé. (A ti kọ́ Hebroni ní ọdún méje ṣáájú Ṣoani ní Ejibiti.) ");
INSERT INTO yor_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Nígbà tí wọ́n dé àfonífojì Eṣkolu, wọ́n gé ẹ̀ka kan tó ní ìdì èso àjàrà gireepu kan. Àwọn méjì sì fi ọ̀pá kan gbé e; wọ́n tún mú èso pomegiranate àti èso ọ̀pọ̀tọ́ pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Wọ́n sì sọ ibẹ̀ ní àfonífojì Eṣkolu nítorí ìdì èso gireepu tí àwọn ọmọ Israẹli gé níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Wọ́n padà sílé lẹ́yìn ogójì ọjọ́ tí wọ́n ti lọ yẹ ilẹ̀ náà wò. ");
INSERT INTO yor_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Wọ́n padà wá bá Mose àti Aaroni àti gbogbo àwọn ọmọ Israẹli ní ijù Kadeṣi Parani. Wọ́n mú ìròyìn wá fún wọn àti fún gbogbo ìjọ ènìyàn, wọ́n fi èso ilẹ̀ náà hàn wọ́n. ");
INSERT INTO yor_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Wọ́n sì fún Mose ní ìròyìn báyìí, “A lọ sí ilẹ̀ ibi tí o rán wa, lóòtítọ́ ló sì ń sàn fún wàrà àti fún oyin! Èso ibẹ̀ nìyìí. ");
INSERT INTO yor_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ṣùgbọ́n àwọn ènìyàn tó ń gbé níbẹ̀ lágbára, àwọn ìlú náà jẹ́ ìlú olódi bẹ́ẹ̀ ni ó sì tóbi púpọ̀. A tilẹ̀ rí àwọn irú-ọmọ Anaki níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Àwọn Amaleki ń gbé ní ìhà gúúsù; àwọn ará Hiti, àwọn ará Jebusi àti àwọn ará Amori ni wọ́n ń gbé ní orí òkè ilẹ̀ náà, àwọn ará Kenaani sì ń gbé ẹ̀bá òkun àti ní etí bèbè Jordani.” ");
INSERT INTO yor_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalebu sì pa àwọn ènìyàn náà lẹ́nu mọ́ níwájú Mose, ó wí pé, “Ẹ jẹ́ kí á gòkè lọ lẹ́ẹ̀kan náà láti lọ gba ilẹ̀ náà, nítorí pé àwa le è gbà á.” ");
INSERT INTO yor_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ṣùgbọ́n àwọn ọkùnrin tí wọ́n jọ gòkè lọ yẹ ilẹ̀ wò sọ pé, “Àwa kò le gòkè lọ bá àwọn ènìyàn wọ̀nyí nítorí pé wọ́n lágbára jù wá lọ.” ");
INSERT INTO yor_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Báyìí ni wọ́n ṣe mú ìròyìn búburú ti ilẹ̀ náà, tí wọ́n lọ yọ́wò wá fún àwọn ọmọ Israẹli. Wọ́n wí pé, “Ilẹ̀ tí a lọ yẹ̀ wò jẹ́ ilẹ̀ tí ń run àwọn olùgbé ibẹ̀. Gbogbo àwọn ènìyàn tí a rí níbẹ̀ jẹ́ ènìyàn tó fìrìgbọ̀n tó sì síngbọnlẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","A sì tún rí àwọn òmíràn (irú àwọn ọmọ Anaki) àwa sì rí bí i kòkòrò tata ní ojú ara wa, bẹ́ẹ̀ ni àwa náà sì rí ní ojú wọn.” ");
INSERT INTO yor_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Gbogbo ìjọ ènìyàn sì gbóhùn sókè, wọ́n sì sọkún ní òru ọjọ́ náà. ");
INSERT INTO yor_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Gbogbo ọmọ Israẹli sì kùn sí Mose àti Aaroni, gbogbo ìjọ ènìyàn Israẹli sì wí fún wọn pé, “Àwa ìbá kúkú ti kú ní ilẹ̀ Ejibiti. Tàbí kí a kúkú kú sínú aginjù yìí. ");
INSERT INTO yor_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Kí ló dé tí Olúwa fi mú wa wá sí ilẹ̀ yìí láti fi idà pa wá? Àwọn ìyàwó wa, àwọn ọmọ wa yóò sì di ìjẹ. Ǹjẹ́ kò wa, ní í dára fún wa bí a bá padà sí Ejibiti?” ");
INSERT INTO yor_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Wọ́n sì sọ fún ara wọn pé, “Ẹ jẹ́ kí á yan olórí kí á sì padà sí Ejibiti.” ");
INSERT INTO yor_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Nígbà náà ni Mose àti Aaroni dojúbolẹ̀ níwájú gbogbo ìjọ ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joṣua ọmọ Nuni àti Kalebu ọmọ Jefunne, tí wọ́n wà lára àwọn to lọ yẹ ilẹ̀ wò sì fa aṣọ wọn ya. ");
INSERT INTO yor_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Wọ́n sì sọ fún gbogbo ìjọ ènìyàn Israẹli pé, “Ilẹ̀ tí a là kọjá láti yẹ̀ wò náà jẹ́ ilẹ̀ tí ó dára lọ́pọ̀lọ́pọ̀. ");
INSERT INTO yor_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Bí inú Olúwa bá dùn sí wa, yóò mú wa dé ilẹ̀ náà, ilẹ̀ tó ń sàn fún wàrà àti fún oyin, yóò fún wa ní ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ṣùgbọ́n ẹ má ṣe ṣọ̀tẹ̀ sí Olúwa. Kí ẹ sì má bẹ̀rù àwọn ènìyàn ìlú náà, nítorí pé a ó gbé wọn mì, ààbò wọn ti fi wọ́n sílẹ̀, Olúwa sì wà pẹ̀lú àwa, ẹ má ṣe bẹ̀rù wọn.” ");
INSERT INTO yor_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ṣùgbọ́n gbogbo ìjọ ènìyàn sì ń sọ pé àwọn yóò sọ wọ́n lókùúta pa. Nígbà náà ni ògo Olúwa fi ara hàn ní àgọ́ ìpàdé níwájú àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Olúwa sọ fún Mose pé, “Fún ìgbà wo ni àwọn ènìyàn yìí yóò ti kẹ́gàn mi tó? Báwo ni yóò ti pẹ́ tó tí wọ́n ó fi kọ̀ jálẹ̀ láti gbà mí gbọ́, pẹ̀lú gbogbo iṣẹ́ àmì tí mo ṣe láàrín wọn? ");
INSERT INTO yor_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Èmi ó kọlù wọ́n pẹ̀lú àjàkálẹ̀-ààrùn, èmi ó gba ogún wọn lọ́wọ́ wọn, èmi ó sì pa wọ́n run ṣùgbọ́n èmi ó sọ ọ́ di orílẹ̀-èdè ńlá tó sì lágbára jù wọ́n lọ.” ");
INSERT INTO yor_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ṣùgbọ́n Mose sọ fún Olúwa pé, “Nígbà náà ni àwọn ará Ejibiti yóò gbọ́! Nítorí pé nípa agbára rẹ ni ìwọ fi mú àwọn ènìyàn wọ̀nyí jáde kúrò láàrín wọn. ");
INSERT INTO yor_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Wọ́n ó sì sọ fún àwọn olùgbé ilẹ̀ yìí. Àwọn tó ti mọ̀ tẹ́lẹ̀ pé ìwọ Olúwa wà láàrín àwọn ènìyàn wọ̀nyí àti pé wọ́n rí ìwọ, Olúwa, ní ojúkojú, àti pé ìkùùkuu àwọsánmọ̀ rẹ dúró lórí wọn, bẹ́ẹ̀ ni ìwọ sì ń lọ níwájú wọn pẹ̀lú ìkùùkuu àwọsánmọ̀ ní ọ̀sán àti pẹ̀lú ọ̀wọ́n iná ní òru. ");
INSERT INTO yor_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Bí ìwọ bá pa àwọn ènìyàn wọ̀nyí lẹ́ẹ̀kan ṣoṣo, àwọn orílẹ̀-èdè tó bá gbọ́ ìròyìn yìí nípa rẹ yóò wí pé, ");
INSERT INTO yor_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Nítorí pé Olúwa kò le è mú àwọn ènìyàn wọ̀nyí dé ilẹ̀ tí ó ṣèlérí fún wọn; torí èyí ló ṣe pa wọ́n sínú aginjù yìí.’ ");
INSERT INTO yor_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Báyìí, mo gbàdúrà, jẹ́ kí agbára Olúwa tóbi gẹ́gẹ́ bí ìwọ ti sọ pé, ");
INSERT INTO yor_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Olúwa lọ́ra láti bínú, ó sì pọ̀ ní ìfẹ́ tó dúró ṣinṣin, tí ń dárí ẹ̀ṣẹ̀ àti ìrékọjá jì. Bẹ́ẹ̀ ni kì í jẹ́ kí ẹlẹ́bi lọ láìjìyà; tó ń fi ìyà ẹ̀ṣẹ̀ baba jẹ ọmọ títí dé ìran kẹta àti ìran kẹrin.’ ");
INSERT INTO yor_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Dárí ẹ̀ṣẹ̀ àwọn ènìyàn yìí jì wọ́n, mo bẹ̀ ọ́, gẹ́gẹ́ bí ìfẹ́ ńlá rẹ, bí o ti ṣe ń dárí ẹ̀ṣẹ̀ wọn jì wọ́n láti ìgbà tí o ti kó wọn kúrò ní Ejibiti di ìsin yìí.” ");
INSERT INTO yor_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Olúwa sì dáhùn pé, “Mo ti dáríjì wọ́n gẹ́gẹ́ bí ọ̀rọ̀ rẹ. ");
INSERT INTO yor_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ṣùgbọ́n nítòótọ́ bí mo ti wà láààyè, gbogbo ayé yóò kún fún ògo Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Kò sí ọ̀kan nínú àwọn ènìyàn tó rí ògo mi àti àwọn iṣẹ́ àmì tí mo ṣe ní ilẹ̀ Ejibiti àti nínú aginjù ṣùgbọ́n tí wọ́n ṣe àìgbọ́ràn sí mi, tí wọn sì dán mi wò ní ìgbà mẹ́wàá yìí, ");
INSERT INTO yor_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ọ̀kan nínú wọn kò ní rí ilẹ̀ náà tí mo ṣe ìlérí ní ìbúra láti fún baba ńlá wọn. Kò sí ọ̀kan nínú àwọn tó kẹ́gàn mi tí yóò rí ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ṣùgbọ́n nítorí pé Kalebu ìránṣẹ́ mi ní ẹ̀mí ọ̀tọ̀, tí ó sì tún tẹ̀lé mi tọkàntọkàn, èmi ó mu dé ilẹ̀ náà tó lọ yẹ̀ wò, irú àwọn ọmọ rẹ̀ yóò sì jogún rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Níwọ́n ìgbà tí àwọn ará Amaleki àti àwọn ará Kenaani ń gbé ní àfonífojì, ẹ yípadà lọ́la kí ẹ sì dojúkọ aginjù lọ́nà Òkun Pupa.” ");
INSERT INTO yor_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Olúwa sọ fún Mose àti Aaroni pé, ");
INSERT INTO yor_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Báwo ni yóò ti pẹ́ tó tí àwọn ìjọ ènìyàn búburú yìí yóò fi máa kùn sí mi? Mo ti gbọ́ kíkùn tí àwọn ọmọ Israẹli ń kùn sí mi. ");
INSERT INTO yor_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Sọ fún wọn, bí mo ti wà láààyè nítòótọ́ ni Olúwa wí, gẹ́gẹ́ bí ohun tí ẹ wí létí mi ni èmi ó ṣe fún un yín. ");
INSERT INTO yor_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Nínú aginjù yìí ni ẹ ó kú sí, gbogbo ẹ̀yin tí ẹ kùn láti ọmọ ogún ọdún ó lé àní gbogbo ẹ̀yin tí a kà. ");
INSERT INTO yor_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ọ̀kan nínú yín kò ní í dé ilẹ̀ tí mo búra nípa ìgbọ́wọ́sókè láti fi ṣe ibùgbé yín, bí kò ṣe Kalebu ọmọ Jefunne àti Joṣua ọmọ Nuni. ");
INSERT INTO yor_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ṣùgbọ́n ní ti àwọn ọmọ yín tí ẹ wí pé wọn ó di ìjẹ, àwọn ni n ó mú dé bẹ̀ láti gbádùn ilẹ̀ tí ẹ kọ̀sílẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ṣùgbọ́n ẹ̀yin, òkú yín yóò ṣubú ní aginjù yìí. ");
INSERT INTO yor_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Àwọn ọmọ wẹ́wẹ́ yín yóò sì máa rin kiri nínú aginjù fun ogójì ọdún wọn ó máa jìyà nítorí àìnígbàgbọ́ yín, títí tí ọkàn gbogbo yín yóò fi ṣòfò tán ní aginjù. ");
INSERT INTO yor_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Fún ogójì ọdún èyí jẹ́ ọdún kan fún ọjọ́ kọ̀ọ̀kan nínú ogójì ọjọ́ tí ẹ fi yẹ ilẹ̀ náà wò ẹ̀yin ó sì jìyà fún ẹ̀ṣẹ̀ yín, ẹ ó sì mọ bí ó ti rí láti lòdì sí mi. ");
INSERT INTO yor_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Èmi, Olúwa, lo sọ bẹ́ẹ̀; Èmi ó sì ṣe àwọn nǹkan wọ̀nyí sí ìjọ ènìyàn búburú yìí tí wọ́n kó ra wọn jọ lòdì sí mi. Nínú aginjù yìí ni òpin yóò dé bá wọn, ibẹ̀ ni wọn yóò kú sí.” ");
INSERT INTO yor_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Àwọn ọkùnrin tí Mose rán láti yẹ ilẹ̀ wò, tí wọ́n sì mú gbogbo ìjọ kùn sí i nípa ìròyìn búburú tí wọ́n mú wá nípa ilẹ̀ náà; ");
INSERT INTO yor_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Olúwa sì kọlu àwọn ọkùnrin tó mú ìròyìn búburú wá nípa ilẹ̀ náà, àjàkálẹ̀-ààrùn sì pa wọ́n níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Nínú gbogbo àwọn tó lọ yẹ ilẹ̀ náà wò, Joṣua ọmọ Nuni àti Kalebu ọmọ Jefunne ló yè é. ");
INSERT INTO yor_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Nígbà tí Mose sọ gbogbo ọ̀rọ̀ yìí fún àwọn ọmọ Israẹli, wọ́n sì sọkún gidigidi. ");
INSERT INTO yor_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Wọ́n dìde ní àárọ̀ ọjọ́ kejì wọ́n sì gòkè lọ sí ìlú orí òkè, wọ́n wí pé, “Àwa ti ṣẹ̀, àwa yóò lọ sí ibi tí Olúwa ṣèlérí fún wa.” ");
INSERT INTO yor_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mose sì dá wọn lóhùn pé, “Kí ló dé tí ẹ fi ṣẹ̀ sí òfin Olúwa? Èyí kò le yọrí sí rere! ");
INSERT INTO yor_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ẹ má ṣe gòkè lọ nítorí pé Olúwa kò sí láàrín yín. Ki á má ba à lù yín bolẹ̀ níwájú àwọn ọ̀tá yín. ");
INSERT INTO yor_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Nítorí pé àwọn ará Amaleki àti àwọn ará Kenaani ń bẹ níwájú yín, ẹ̀yin yóò sì ti ipa idà ṣubú. Nítorí pé, ẹ ti yà kúrò ní ọ̀nà Olúwa, Olúwa kò sì ní í wà pẹ̀lú yín.” ");
INSERT INTO yor_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Síbẹ̀síbẹ̀, pẹ̀lú àìfarabalẹ̀ wọn, wọ́n gòkè lọ sórí òkè náà, láìjẹ́ pé àpótí ẹ̀rí Olúwa tàbí Mose kúrò nínú ibùdó. ");
INSERT INTO yor_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Àwọn ará Amaleki àti àwọn ará Kenaani tó ń gbé lórí òkè sọ̀kalẹ̀ tọ̀ wọ́n, wọ́n bá wọn jà, wọ́n sì lé wọn títí dé Horma. ");
INSERT INTO yor_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Sọ fún àwọn ọmọ Israẹli pé, ‘Nígbà tí ẹ bá dé ilẹ̀ tí èmi ó fún yin gẹ́gẹ́ bí ibùgbé ");
INSERT INTO yor_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","tí ẹ̀yin ó bá sì ṣe ẹbọ iná sí Olúwa ẹbọ sísun, tàbí ẹbọ, láti san ẹ̀jẹ́ pàtàkì tàbí ọrẹ àtinúwá, tàbí nínú àjọ yín, láti ṣe òórùn dídùn sí Olúwa nínú agbo ẹran tàbí ọ̀wọ́ ẹran, ");
INSERT INTO yor_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","nígbà náà ni kí ẹni tí ó bá mú ọrẹ rẹ̀ wá, yóò tún mú ẹbọ ohun jíjẹ ìdámẹ́wàá òsùwọ̀n ìyẹ̀fun kíkúnná pẹ̀lú ìdámẹ́rin òsùwọ̀n òróró wá síwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Pẹ̀lú ọ̀dọ́-àgùntàn kọ̀ọ̀kan yálà fún ọrẹ tàbí ẹbọ sísun ni, kí ẹ pèsè ìdámẹ́rin òsùwọ̀n wáìnì gẹ́gẹ́ bí ohun mímu. ");
INSERT INTO yor_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Fún àgbò kan ni kí ẹ pèsè ọrẹ ohun jíjẹ ìdá méjì nínú mẹ́wàá òsùwọ̀n ìyẹ̀fun kíkúnná tí a fi ìdákan nínú mẹ́ta òsùwọ̀n òróró pò. ");
INSERT INTO yor_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Àti ìdákan nínú mẹ́ta òsùwọ̀n wáìnì fún ọrẹ ohun mímu gẹ́gẹ́ bí òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Nígbà tí ẹ bá sì pèsè ọ̀dọ́ akọ màlúù fún ọrẹ tàbí ẹbọ sísun, láti fi san ẹ̀jẹ́ tàbí fún ọrẹ àlàáfíà sí Olúwa, ");
INSERT INTO yor_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ẹni náà yóò mú ọ̀dọ́ akọ màlúù náà wá pẹ̀lú ọrẹ ohun jíjẹ, ìdámẹ́ta nínú mẹ́wàá òsùwọ̀n ìyẹ̀fun ìyẹ̀fun kíkúnná tí a fi ìdajì òsùwọ̀n òróró pò. ");
INSERT INTO yor_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Kí ó tún mú ìdajì òsùwọ̀n wáìnì wá fún ọrẹ ohun mímu. Yóò jẹ́ ọrẹ àfinásun, àní òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Báyìí ni kí ẹ ṣe pèsè ọ̀dọ́ akọ màlúù tàbí àgbò, ọ̀dọ́-àgùntàn tàbí ọmọ ewúrẹ́. ");
INSERT INTO yor_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ẹ ṣe bẹ́ẹ̀ fún ọ̀kọ̀ọ̀kan wọn, iyekíye tí ẹ̀yin ìbá à pèsè. ");
INSERT INTO yor_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Ẹnikẹ́ni tí ó bá jẹ́ ọmọ bíbí ilẹ̀ yín ni kí ó máa ṣe àwọn nǹkan wọ̀nyí nígbà tí ó bá mú ọrẹ àfinásun gẹ́gẹ́ bí òórùn dídùn wá fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Bí àlejò kan bá ń gbé láàrín yín ní gbogbo ìran yín, bí irú ẹni bẹ́ẹ̀ bá fẹ́ mú ọrẹ àfinásun bí òórùn dídùn wá fún Olúwa, gbogbo bí ẹ bá ṣe ń ṣe náà ni kí ó ṣe. ");
INSERT INTO yor_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Gbogbo ìjọ ènìyàn gbọdọ̀ ní òfin kan náà fún ọmọ bíbí ilẹ̀ yín àti fún àwọn àlejò tó ń gbé láàrín yín, èyí jẹ́ ìlànà títí láé fún àwọn ìran tó ń bọ̀. Ẹ̀yin àti àlejò tó ń gbé láàrín yín sì jẹ́ bákan náà níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Òfin kan àti ìlànà kan ni yóò wà fún yín àti fún àwọn àlejò tí ń gbé láàrín yín.’ ” ");
INSERT INTO yor_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Sọ fún àwọn ọmọ Israẹli pé, ‘Nígbà tí ẹ bá dé ilẹ̀ tí mo ń mú yín lọ. ");
INSERT INTO yor_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Tí ẹ sì jẹ oúnjẹ ilẹ̀ náà, ẹ mú nínú rẹ̀ gẹ́gẹ́ bí ọrẹ ìgbésókè wá fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ẹ mú àkàrà wá nínú àkọ́so oúnjẹ yín wá gẹ́gẹ́ bí ọrẹ ìgbésókè sí Olúwa, ọrẹ láti inú ilẹ̀ ìpakà yín. ");
INSERT INTO yor_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Nínú àkọ́so oúnjẹ yín ni kí ẹ ti máa mú ọrẹ ìgbésókè yìí fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Bí ẹ bá kùnà láìròtẹ́lẹ̀ láti pa àwọn òfin tí Olúwa fún Mose mọ́, ");
INSERT INTO yor_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","èyí ni gbogbo òfin tí Olúwa fún yín láti ẹnu Mose láti ọjọ́ tí Olúwa ti fún yín àti títí dé ìran tó ń bọ̀. ");
INSERT INTO yor_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Bí ẹ̀ṣẹ̀ bá wáyé láìròtẹ́lẹ̀ láìjẹ́ pé ìjọ ènìyàn mọ̀ sí i, nígbà náà ni kí gbogbo ìjọ ènìyàn mú ọ̀dọ́ akọ màlúù kan wá fún ẹbọ sísun bí òórùn dídùn sí Olúwa, pẹ̀lú ọrẹ ohun jíjẹ àti ọrẹ ohun mímu rẹ̀ gẹ́gẹ́ bí ìlànà, pẹ̀lú akọ ewúrẹ́ fún ẹbọ ẹ̀ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Àlùfáà yóò sì ṣe ètùtù, fun gbogbo ìjọ ènìyàn Israẹli, a ó sì dáríjì wọ́n, nítorí ẹ̀ṣẹ̀ àìròtẹ́lẹ̀, wọ́n sì ti mú ọrẹ àfinásun wá fún Olúwa nítorí ẹ̀ṣẹ̀ tí wọ́n ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","A ó dárí jí gbogbo ìjọ ènìyàn Israẹli àti àwọn àjèjì tí ń gbé ní àárín wọn nítorí pé ní àìròtẹ́lẹ̀ ni wọ́n sẹ ẹ̀ṣẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Ṣùgbọ́n bí ó bá jẹ́ pé ẹnìkan ló sẹ̀ ní àìròtẹ́lẹ̀, kí ó mú abo ewúrẹ́ ọlọ́dún kan wá fún ẹbọ ẹ̀ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Àlùfáà yóò ṣe ètùtù níwájú Olúwa fún ẹni tó ṣẹ̀ láìròtẹ́lẹ̀, tí wọ́n bá ṣe ètùtù fún un, a ó sì dáríjì í. ");
INSERT INTO yor_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Òfin kan kí ẹ̀yin kí ó ní fún ẹnikẹ́ni tó bá ṣẹ̀ ní àìmọ̀, àti fún àwọn ẹni tí a bí nínú àwọn ọmọ Israẹli, àti fún àlejò tí ń ṣe àtìpó. ");
INSERT INTO yor_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Ṣùgbọ́n bí ẹnikẹ́ni bá mọ̀ ọ́n mọ̀ dẹ́ṣẹ̀ yálà ó jẹ́ ọmọ bíbí ilẹ̀ yín tàbí àlejò, irú ẹni bẹ́ẹ̀ ti kó ẹ̀gàn bá orúkọ Olúwa, a ó sì gé irú ẹni bẹ́ẹ̀ kúrò lára àwọn ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Nítorí pé ẹni náà ti kẹ́gàn ọ̀rọ̀ Olúwa ó sì ti rú òfin rẹ̀, a gbọdọ̀ gé irú ẹni bẹ́ẹ̀ kúrò láàrín àwọn ènìyàn rẹ̀; ẹ̀bi rẹ̀ yóò sì wà lórí rẹ̀.’ ” ");
INSERT INTO yor_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Nígbà tí àwọn ọmọ Israẹli wà nínú aginjù, wọ́n rí ọkùnrin kan tí ń ṣá igi ní ọjọ́ Ìsinmi. ");
INSERT INTO yor_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Àwọn tó sì rí i níbi tó ti ń ṣá igi wọ́n sì mú un wá sí ọ̀dọ̀ Mose àti Aaroni àti síwájú gbogbo ìjọ ènìyàn, ");
INSERT INTO yor_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","wọ́n fi sí ìpamọ́ nítorí pé ohun tí wọn ó ṣe fún un kò tí ì yé wọn. ");
INSERT INTO yor_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Nígbà náà ni Olúwa sọ fún Mose pé, “Kíkú ni ọkùnrin náà yóò kú kí gbogbo ìjọ ènìyàn Israẹli sọ ọ́ lókùúta pa ní ẹ̀yìn ibùdó.” ");
INSERT INTO yor_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Wọ́n mú un jáde sí ẹ̀yìn ibùdó, gbogbo ìjọ ènìyàn sì sọ ọ́ lókùúta pa, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Bá àwọn ọmọ Israẹli sọ̀rọ̀, kí o sọ fún wọn pé: ‘Títí dé àwọn ìran tó ń bọ̀ ni kí wọn máa ṣe wajawaja sí etí aṣọ wọn, kí wọn sì fi okùn tẹ́ẹ́rẹ́ aláwọ̀ búlúù sí wajawaja kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Wajawaja yìí ni ẹ sì máa wọ̀ láti lè mú yín rántí gbogbo òfin Olúwa, kí ẹ bá à lè ṣe wọ́n, kí ẹ sì má bá à ṣe àgbèrè nípa títẹ̀lé ìfẹ́kúfẹ̀ẹ́ ọkàn àti ojú yín. ");
INSERT INTO yor_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Nígbà náà ni ẹ ó gbọ́rọ̀ láti pa gbogbo òfin mi mọ́, ẹ ó sì jẹ́ mímọ́ sí Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Èmi ni Olúwa Ọlọ́run yín tí ó mú yín jáde láti Ejibiti láti jẹ́ Ọlọ́run yín. Èmi ni Olúwa Ọlọ́run yín.’ ” ");
INSERT INTO yor_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora ọmọ Isari, ọmọ Kohati, ọmọ Lefi àwọn ọmọ Reubeni: Datani àti Abiramu, àwọn ọmọ Eliabu, àti Oni ọmọ Peleti mú ènìyàn mọ́ra. ");
INSERT INTO yor_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Wọ́n sì dìde sí Mose, pẹ̀lú àádọ́ta lé nígba (250) ọkùnrin nínú àwọn ọmọ Israẹli, ìjòyè nínú ìjọ, àwọn olórúkọ nínú àjọ, àwọn ọkùnrin olókìkí. ");
INSERT INTO yor_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Wọ́n kó ara wọn jọ láti tako Mose àti Aaroni, wọ́n sọ fún wọn pé, “Ẹ ti kọjá ààyè yín, ó tó gẹ́ẹ́! Mímọ́ ni gbogbo ènìyàn, kò sí ẹni tí kò mọ́ láàrín wọn, Olúwa sì wà pẹ̀lú wọn, nítorí kí wá ni ẹ̀yin ṣe gbé ara yín ga ju ìjọ ènìyàn Olúwa lọ?” ");
INSERT INTO yor_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Nígbà tí Mose gbọ́ èyí, ó dojúbolẹ̀, ");
INSERT INTO yor_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ó sì sọ fún Kora àti gbogbo ẹgbẹ́ rẹ̀ pé, “Ní ọ̀la ni Olúwa yóò fi ẹni tí í ṣe tirẹ̀ àti ẹni tó mọ́ hàn, yóò sì mú kí ẹni náà súnmọ́ òun. Ẹni tí ó bá yàn ni yóò mú kí ó súnmọ́ òun. ");
INSERT INTO yor_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Kí Kora àti gbogbo ẹgbẹ́ rẹ̀ ṣe èyí, ẹ mú àwo tùràrí. ");
INSERT INTO yor_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Kí ẹ sì fi iná àti tùràrí sínú rẹ̀ lọ́la níwájú Olúwa, yóò sì ṣe, ọkùnrin tí Olúwa bá yàn òun ni. Ẹ̀yin ọmọ Lefi, ẹ ti kọjá ààyè yín!” ");
INSERT INTO yor_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mose sì tún sọ fún Kora pé, “Ẹ gbọ́ báyìí o, ẹ̀yin ọmọ Lefi! ");
INSERT INTO yor_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Kò ha tọ́ fún yín pé Ọlọ́run Israẹli ti yà yín sọ́tọ̀ lára ìjọ Israẹli yòókù, tó sì mú yín súnmọ́ ara rẹ̀ láti ṣiṣẹ́ nínú àgọ́ Olúwa àti láti dúró ṣiṣẹ́ ìsìn níwájú àwọn ènìyàn? ");
INSERT INTO yor_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ó ti mú àwọn ènìyàn yín tó jẹ́ ọmọ Lefi súnmọ́ ara rẹ̀, ṣùgbọ́n báyìí ẹ tún ń wá ọnà láti ṣiṣẹ́ àlùfáà. ");
INSERT INTO yor_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Olúwa ni ìwọ àti gbogbo ẹlẹgbẹ́ rẹ takò. Ta a ni Aaroni jẹ́ tí ẹ̀yin ó fi kùn sí i?” ");
INSERT INTO yor_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mose sì ránṣẹ́ sí Datani àti Abiramu àwọn ọmọ Eliabu. Ṣùgbọ́n wọ́n wí pé, “Àwa kò ní í wá! ");
INSERT INTO yor_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Kò ha tó gẹ́ẹ́ pé o ti mú wa jáde láti ilẹ̀ tí ó ń sàn fún wàrà àti oyin láti pa wá sínú aginjù yìí? O tún wá fẹ́ sọ ara rẹ di olúwa lé wa lórí bí? ");
INSERT INTO yor_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Síbẹ̀síbẹ̀ ìwọ kò sì tí ì mú wa dé ilẹ̀ tí ó ń sàn fún wàrà àti oyin, bẹ́ẹ̀ ni o kò sì pín ilẹ̀ ìní àti ọgbà àjàrà. Ìwọ ha fẹ́ sọ wá di ẹrú bí? Rárá o, àwa kì yóò gòkè wá!” ");
INSERT INTO yor_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Nígbà náà ni Mose bínú gidigidi, ó sì sọ fún Olúwa pé, “Má ṣe gba ọrẹ wọn, èmi kò gba kẹ́tẹ́kẹ́tẹ́ lọ́wọ́ wọn, bẹ́ẹ̀ ni n kò sì pa ẹnikẹ́ni nínú wọn lára!” ");
INSERT INTO yor_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mose sọ fún Kora pé, “Ìwọ àti ọmọ lẹ́yìn rẹ gbọdọ̀ fi ara hàn níwájú Olúwa lọ́la—gbogbo yín, ìwọ, àwọn ọmọ lẹ́yìn rẹ àti Aaroni. ");
INSERT INTO yor_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Kí ẹnìkọ̀ọ̀kan yín mú àwo tùràrí, kí ó sì fi tùràrí sínú rẹ̀, kí gbogbo rẹ̀ jẹ́ àádọ́ta lé nígba (250) àwo tùràrí kí ẹ sì ko wá síwájú Olúwa. Ìwọ àti Aaroni yóò mú àwo tùràrí wá pẹ̀lú.” ");
INSERT INTO yor_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Nígbà náà ni oníkálùkù wọn mú àwo tùràrí, wọ́n fi iná àti tùràrí sí i nínú, wọ́n sì dúró sí ẹnu-ọ̀nà àgọ́ ìpàdé, àwọn pẹ̀lú Mose àti Aaroni. ");
INSERT INTO yor_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Nígbà tí Kora kó gbogbo àwọn ẹlẹgbẹ́ rẹ̀ jọ sí ẹnu-ọ̀nà àgọ́ ìpàdé, ògo Olúwa sì farahan gbogbo ìjọ ènìyàn. ");
INSERT INTO yor_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Olúwa sì sọ fún Mose àti Aaroni pé, ");
INSERT INTO yor_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Ẹ ya ara yín sọ́tọ̀ kúrò láàrín ìjọ wọ̀nyí, kí ń ba à le pa wọ́n run lẹ́ẹ̀kan náà.” ");
INSERT INTO yor_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ṣùgbọ́n Mose àti Aaroni dojúbolẹ̀ wọ́n sì kígbe sókè pé, “Ọlọ́run, Ọlọ́run ẹ̀mí gbogbo ènìyàn, Ìwọ ó wa bínú sí gbogbo ìjọ ènìyàn nígbà tó jẹ́ pé ẹnìkan ló ṣẹ̀?” ");
INSERT INTO yor_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Olúwa tún sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Sọ fún ìjọ ènìyàn pé, ‘Kí wọ́n jìnnà sí àgọ́ Kora, Datani àti Abiramu.’ ” ");
INSERT INTO yor_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mose sì dìde lọ bá Datani àti Abiramu àwọn àgbàgbà Israẹli sì tẹ̀lé. ");
INSERT INTO yor_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ó sì kìlọ̀ fún ìjọ ènìyàn pé, “Ẹ kúrò ní àgọ́ àwọn ènìyàn búburú yìí! Ẹ má ṣe fọwọ́ kan ohun kan tí í ṣe tiwọn kí ẹ má ba à parun nítorí ẹ̀ṣẹ̀ wọn.” ");
INSERT INTO yor_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Àwọn ènìyàn sì sún kúrò ní àgọ́ Kora, Datani àti Abiramu. Datani àti Abiramu jáde, àwọn ìyàwó wọn àti àwọn ọmọ wọn sì dúró sí ẹnu-ọ̀nà àgọ́ wọn. ");
INSERT INTO yor_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Nígbà náà ni Mose wí pé, “Báyìí ni ẹ ó ṣe mọ̀ pé Olúwa ló rán mi láti ṣe gbogbo iṣẹ́ wọ̀nyí àti pé kì í ṣe ìfẹ́ inú mi ni àwọn ohun tí mò ń ṣe. ");
INSERT INTO yor_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Bí àwọn ènìyàn yìí bá kú bí gbogbo ènìyàn ti ń kú, bí ìrírí wọn kò bá sì yàtọ̀ sí ti àwọn ènìyàn yòókù, a jẹ́ pé kì í ṣe Olúwa ló rán mi. ");
INSERT INTO yor_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ṣùgbọ́n bí Olúwa bá ṣe ohun tuntun, tí ilẹ̀ sì la ẹnu, tó gbé wọn mì, àwọn pẹ̀lú gbogbo ohun tí wọ́n ní, tí wọ́n sì wọ inú ibojì wọn lọ láààyè, nígbà náà ni ẹ̀yin ó mọ̀ pé àwọn ènìyàn yìí ti kẹ́gàn Olúwa.” ");
INSERT INTO yor_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Bí ó sì ṣe parí ọ̀rọ̀ wọ̀nyí, ilẹ̀ pín sí méjì nísàlẹ̀ wọn, ");
INSERT INTO yor_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ilẹ̀ sì lanu ó sì gbé wọn mì pẹ̀lú gbogbo ará ilé wọn àti àwọn ènìyàn Kora àti gbogbo ohun tí wọ́n ní. ");
INSERT INTO yor_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Gbogbo wọn sì sọ̀kalẹ̀ sínú ibojì wọn láààyè pẹ̀lú ohun gbogbo tí wọ́n ní, ilẹ̀ sì padé mọ́ wọn, wọ́n sì ṣègbé kúrò láàrín ìjọ ènìyàn. ");
INSERT INTO yor_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Gbogbo ènìyàn Israẹli tí ó yí wọn ká sì sálọ tí àwọn yòókù gbọ́ igbe wọn, wọ́n wí pé, “Ilẹ̀ yóò gbé àwa náà mì pẹ̀lú.” ");
INSERT INTO yor_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Iná sì jáde láti ọ̀dọ̀ Olúwa ó sì run àádọ́ta lé nígba (250) ọkùnrin tí wọ́n mú tùràrí wá. ");
INSERT INTO yor_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Sọ fún Eleasari ọmọ Aaroni tí í ṣe àlùfáà, pé kí ó mú àwọn àwo tùràrí jáde kúrò nínú iná nítorí pé wọ́n jẹ́ mímọ́, kí ó sì tan iná náà káàkiri sí ibi tó jìnnà. ");
INSERT INTO yor_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Èyí ni àwo tùràrí àwọn tí ó kú nítorí ẹ̀ṣẹ̀ wọn. Kí ẹ gún àwo tùràrí yìí, kí ẹ sì fi ṣe ìbòrí fún pẹpẹ, wọ́n jẹ́ mímọ́ nítorí pé wọ́n ti mú wọn wá síwájú Olúwa. Kí wọ́n jẹ́ àmì fún àwọn ọmọ Israẹli.” ");
INSERT INTO yor_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Eleasari tí í ṣe àlùfáà sì kó gbogbo àwo tùràrí tí àwọn tí ó jóná mú wa, ó gún wọn pọ̀, ó fi ṣe ìbòrí fún pẹpẹ, ");
INSERT INTO yor_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","gẹ́gẹ́ bí Olúwa ṣe sọ láti ẹnu Mose. Èyí yóò jẹ́ ohun ìrántí fún àwọn ọmọ Israẹli pé, àlejò yàtọ̀ sí irú-ọmọ Aaroni kò gbọdọ̀ jó tùràrí níwájú Olúwa, ẹni tí ó bá ṣe bẹ́ẹ̀, yóò dàbí Kora àti àwọn ẹgbẹ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ní ọjọ́ kejì gbogbo ìjọ àwọn ọmọ Israẹli kùn sí Mose àti Aaroni pé, “Ẹ ti pa àwọn ènìyàn Olúwa.” ");
INSERT INTO yor_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ṣùgbọ́n nígbà tí gbogbo ìjọ ènìyàn péjọ lòdì sí Mose àti Aaroni, níwájú àgọ́ ìpàdé, lójijì ni ìkùùkuu bolẹ̀, ògo Olúwa sì fi ara hàn. ");
INSERT INTO yor_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Nígbà náà ni Mose àti Aaroni lọ síwájú àgọ́ ìpàdé, ");
INSERT INTO yor_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Olúwa sì sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Yàgò kúrò láàrín ìjọ ènìyàn yìí, kí ń ba le run wọ́n ní ìṣẹ́jú kan.” Wọ́n sì dojúbolẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mose sì sọ fún Aaroni pé, “Mú àwo tùràrí, kí o fi iná sí i lórí pẹpẹ, fi tùràrí sínú rẹ̀, kí o sì tètè mu lọ sí àárín ìjọ ènìyàn láti ṣe ètùtù fún wọn nítorí pé ìbínú Olúwa ti jáde, àjàkálẹ̀-ààrùn sì ti bẹ̀rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaroni ṣe bí Mose ti wí, ó sáré lọ sí àárín àwọn ènìyàn, ṣùgbọ́n àjàkálẹ̀-ààrùn ti bẹ̀rẹ̀ láàrín wọn, ṣùgbọ́n Aaroni fín tùràrí, ó sì ṣe ètùtù fún wọn. ");
INSERT INTO yor_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ó dúró láàrín àwọn alààyè àti òkú, àjàkálẹ̀-ààrùn náà sì dúró. ");
INSERT INTO yor_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ṣùgbọ́n àjàkálẹ̀-ààrùn ti pa ẹgbàá méje ó lé lẹ̀ẹ́dẹ́gbẹ̀rin (14,700) ènìyàn ní àfikún sí àwọn tí ó kú níbi ìṣẹ̀lẹ̀ Kora. ");
INSERT INTO yor_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aaroni padà tọ Mose lọ ní ẹnu-ọ̀nà àgọ́ ìpàdé nítorí pé àjàkálẹ̀-ààrùn náà ti dúró. ");
INSERT INTO yor_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Olúwa sì sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Sọ fún àwọn ọmọ Israẹli kí o sì gba ọ̀pá méjìlá lọ́wọ́ wọn, ọ̀kọ̀ọ̀kan lọ́wọ́ olórí ìdílé ẹ̀yà ìran wọn, kọ orúkọ ènìyàn kọ̀ọ̀kan sí ara ọ̀pá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Lórí ọ̀pá Lefi kọ orúkọ Aaroni, nítorí ọ̀pá kọ̀ọ̀kan gbọdọ̀ wà fún olórí ìdílé kọ̀ọ̀kan tí yóò jẹ́ orí fún ẹ̀yà ìran kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Kó wọn sí àgọ́ ìpàdé níwájú ẹ̀rí níbi tí èmi ti ń pàdé yín. ");
INSERT INTO yor_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ọ̀pá tí ó bá yí jẹ́ ti ẹni tí èmi bá yàn yóò rúwé, èmi yóò sì dá kíkùn gbogbo ìgbà àwọn ọmọ Israẹli sí yín dúró.” ");
INSERT INTO yor_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Nígbà náà Mose bá àwọn ọmọ Israẹli sọ̀rọ̀, àwọn olórí wọn sì fún un ní ọ̀pá méjìlá, ọ̀pá kan fún olórí kọ̀ọ̀kan ẹ̀yà ìran wọn, ọ̀pá Aaroni sì wà lára àwọn ọ̀pá náà. ");
INSERT INTO yor_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mose sì fi ọ̀pá wọ̀nyí lélẹ̀ níwájú Olúwa nínú àgọ́ ẹ̀rí. ");
INSERT INTO yor_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ó sì ṣe ní ọjọ́ kejì Mose wọ inú àgọ́ ẹ̀rí lọ, ó sì rí ọ̀pá Aaroni, tí ó dúró fún ẹ̀yà Lefi, kì í ṣe wí pé ó hù nìkan, ṣùgbọ́n ó rúwé, ó yọ ìtànná, ó sì so èso almondi. ");
INSERT INTO yor_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Nígbà náà ni Mose kó gbogbo àwọn ọ̀pá jáde láti iwájú Olúwa wá fún àwọn ọmọ Israẹli. Wọ́n wò wọ́n, ẹnìkọ̀ọ̀kan sì mú ọ̀pá tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Olúwa sọ fún Mose pé, “Mú ọ̀pá Aaroni padà wá síwájú ẹ̀rí, láti fi pamọ́ gẹ́gẹ́ bí àmì fún àwọn ọlọ̀tẹ̀. Èyí ó sì mú òpin bá kíkùn sínú wọn sí mi, kí wọn kí ó má ba à kú.” ");
INSERT INTO yor_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mose sì ṣe gẹ́gẹ́ bí Olúwa ti páláṣẹ fún un. ");
INSERT INTO yor_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Àwọn ọmọ Israẹli sọ fún Mose pé, “Àwa yóò kú! A ti sọnù, gbogbo wa ti sọnù! ");
INSERT INTO yor_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ẹnikẹ́ni tí ó bá súnmọ́ tabanaku Olúwa yóò kú. Ṣé gbogbo wa ni yóò kú?” ");
INSERT INTO yor_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Olúwa sọ fún Aaroni pé, “Ìwọ, àti àwọn ọmọ rẹ àti ìdílé baba rẹ ni yóò ru gbogbo ẹ̀ṣẹ̀ tí wọ́n ti dá fún ilé tí a yà sí mímọ́ fún Ọlọ́run, àti ìwọ àti àwọn ọmọ rẹ nìkan ni yóò máa ru ẹ̀ṣẹ̀ iṣẹ́ àlùfáà yín. ");
INSERT INTO yor_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Kí o sì mú àwọn ènìyàn rẹ ará Lefi láti ẹ̀yà ìran rẹ láti dàpọ̀ mọ́ ìwọ láti ràn ọ́ lọ́wọ́ nígbà tí ìwọ àti àwọn ọmọ rẹ ọkùnrin bá ń ṣe iṣẹ́ ìránṣẹ́ níwájú Àgọ́ ẹ̀rí. ");
INSERT INTO yor_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Àwọn ni ó yẹ láti dúró fún ọ àti láti ṣe gbogbo iṣẹ́ ti Àgọ́, ṣùgbọ́n wọn kò gbọdọ̀ súnmọ́ ibi tí a ti ṣe lọ́ṣọ̀ọ́ tí a sì yà sí mímọ́ tàbí ibi pẹpẹ, tàbí gbogbo wọn àti ìwọ ló máa kú. ");
INSERT INTO yor_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ó yẹ kí wọ́n darapọ̀ mọ́ ọ láti jẹ ìyà iṣẹ́ fún àìtọ́jú ibi ti àgọ́ ìpàdé àti gbogbo iṣẹ́ tí ó wà ní ibi àgọ́, àti wí pé kò sí àlejò tí ó le wá sí ẹ̀gbẹ́ ibi tí o wà. ");
INSERT INTO yor_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Kí o sì mójútó iṣẹ́ ibi mímọ́ àti iṣẹ́ ibi pẹpẹ, kí ìbínú má ba wá sí orí àwọn ọmọ Israẹli mọ́. ");
INSERT INTO yor_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Èmi fúnra mi ti yan àwọn arákùnrin rẹ tí í ṣe ọmọ Lefi kún àwọn ọmọ Israẹli yòókù, wọn jẹ́ ẹ̀bùn fún ọ, èyí ni a fún Olúwa láti ṣe iṣẹ́ tí ó wà ní àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ṣùgbọ́n ìwọ àti àwọn ọmọ rẹ ni yóò mójútó iṣẹ́ àlùfáà yín fún gbogbo ohun tó bá jẹ mọ́ ibi pẹpẹ àti ti ẹ̀yin aṣọ títa, ẹ ó sì máa ṣiṣẹ́ ibi pẹpẹ àti nínú aṣọ tí a ta. Mo fún ọ ní iṣẹ́ àlùfáà gẹ́gẹ́ bí ẹ̀bùn. Ṣùgbọ́n àlejò tí ó bá súnmọ́ tòsí ibi ìyàsímímọ́ fún Ọlọ́run ni a ó pa.” ");
INSERT INTO yor_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Nígbà náà ni Olúwa sọ fún Aaroni pé, “Èmi fúnra mi ti fi ọ́ ṣọ́ ìdí gbogbo ẹbọ tí a bá mú wá fún gbogbo ọrẹ mímọ́ tí àwọn ọmọ Israẹli bá fún mi, mo fún ìwọ àti àwọn ọmọ rẹ gẹ́gẹ́ bí ìpín rẹ tí yóò máa ṣe. ");
INSERT INTO yor_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ìwọ ni kí o ni ìpín ọrẹ mímọ́ jùlọ tí a mú kúrò ní ibi iná, nínú gbogbo ọrẹ tí wọ́n mú wá gẹ́gẹ́ bí ẹbọ mímọ́ jùlọ, yálà ẹbọ ohun jíjẹ, ẹbọ ẹ̀ṣẹ̀ tàbí ẹbọ ẹ̀bi, ìpín wọ̀nyí jẹ́ ti ìwọ àti àwọn ọmọ rẹ. ");
INSERT INTO yor_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ẹ jẹ ẹ́ ní ibi mímọ́ jùlọ, gbogbo ọkùnrin ni ó gbọdọ̀ jẹ ẹ́. Ó gbọdọ̀ kà á sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Èyí tún jẹ́ tìrẹ pẹ̀lú: ohunkóhun tí a bá yà sọ́tọ̀ lára ẹ̀bùn ọrẹ fífì àwọn ọmọ Israẹli. Mó fún ìwọ àti àwọn ọmọ rẹ ọkùnrin àti ọmọ rẹ obìnrin gẹ́gẹ́ bí ìpín tí yóò máa ṣe déédé nínú ìdílé rẹ, tí o bá wà ní mímọ́ ni o le jẹ ẹ́. ");
INSERT INTO yor_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Mo fún ọ ní gbogbo òróró tí ó dára jùlọ àti gbogbo ọtí tuntun dáradára jùlọ àti ọkà tí wọ́n mú wá fún Olúwa ní àkọ́so ohun ọ̀gbìn wọn tí wọ́n kórè. ");
INSERT INTO yor_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Gbogbo àkọ́so nǹkan ilẹ̀ wọ́n tí wọn mú wá fún Olúwa yóò jẹ́ tìrẹ. Ẹnikẹ́ni nínú ìdílé rẹ, àwọn tí ó jẹ́ mímọ́ nínú ìdílé rẹ lè jẹ ẹ́. ");
INSERT INTO yor_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Gbogbo nǹkan tí a yà sọ́tọ̀ fún Olúwa ní Israẹli jẹ́ tìrẹ. ");
INSERT INTO yor_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Gbogbo àkọ́bí nínú gbogbo ohun alààyè tí wọ́n mú wá fún Olúwa, ìbá à jẹ́ ti ènìyàn tàbí ti ẹranko jẹ́ tìrẹ ṣùgbọ́n o gbọdọ̀ ra gbogbo àkọ́bí ọmọkùnrin padà àti àkọ́bí àwọn ẹranko aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Nígbà tí wọ́n bá pé oṣù kan, o gbọdọ̀ rà wọ́n padà ní iye owó ìràpadà tí í ṣe ṣékélì márùn-ún fàdákà, gẹ́gẹ́ bí iye ṣékélì ibi mímọ́ tí ó wọn ìwọ̀n ogún gera. ");
INSERT INTO yor_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Ṣùgbọ́n o kò gbọdọ̀ ra àwọn àkọ́bí ọmọ màlúù, àgùntàn tàbí ewúrẹ́; wọ́n jẹ́ mímọ́. Wọ́n ẹ̀jẹ̀ wọn sórí pẹpẹ kí o sì sun ọ̀rá rẹ̀ gẹ́gẹ́ bí ọrẹ àfinásun, ẹbọ òórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ẹran wọn gbọdọ̀ jẹ́ tìrẹ, gẹ́gẹ́ bí igẹ̀ ọrẹ ẹbọ fífì àti itan ọ̀tún ṣe jẹ́ tìrẹ. ");
INSERT INTO yor_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ohunkóhun tí a bá ti yà sọ́tọ̀ nínú ọrẹ àwọn ọmọ Israẹli tí wọ́n mú wá fún Olúwa ni mo fún ìwọ àti àwọn ọmọ rẹ ọkùnrin àti ọmọ rẹ obìnrin gẹ́gẹ́ bí ìpín rẹ tí yóò máa ṣe déédé. Ó jẹ́ májẹ̀mú iyọ̀ láéláé níwájú Olúwa fún ìwọ àti ọmọ rẹ.” ");
INSERT INTO yor_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Olúwa sọ fún Aaroni pé, “O kò ní ní ogún nínú ilẹ̀ wọn bẹ́ẹ̀ ni ìwọ kò ní ní ìpín láàrín wọn; Èmi ni ìpín àti ogún rẹ láàrín àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Mó ti fún àwọn ọmọ Lefi ní gbogbo ìdámẹ́wàá ní Israẹli gẹ́gẹ́ bí ogún fún iṣẹ́ tí wọ́n ṣe, nígbà tí wọ́n ń ṣiṣẹ́ níbi àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Láti ìsinsin yìí àwọn ọmọ Israẹli, kò gbọdọ̀ súnmọ́ àgọ́ ìpàdé, bí wọ́n bá ṣe bẹ́ẹ̀, wọn yóò jẹ ìyà ẹ̀ṣẹ̀ wọn, wọn á sì kú. ");
INSERT INTO yor_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Àwọn ọmọ Lefi ní ó gbọdọ̀ ṣe iṣẹ́ tí ó wà nínú àgọ́ ìpàdé, wọn yóò sì jìyà ẹ̀ṣẹ̀ wọn bí wọ́n bá kúrò láti ṣe é. Èyí ni ìlànà láéláé fún àwọn ìran tí ó ń bọ̀. Wọn kò nígbà ogún kankan láàrín àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Kàkà bẹ́ẹ̀, mo fún àwọn ọmọ Lefi gẹ́gẹ́ bí ogún wọn, ìdákan nínú ìdámẹ́wàá tí àwọn ọmọ Israẹli pèsè gẹ́gẹ́ bí ọrẹ sí Olúwa. Èyí ni mo wí nípa wọn. Wọn kò ní gba ogún kankan láàrín àwọn ọmọ Israẹli.” ");
INSERT INTO yor_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Sọ fún àwọn ọmọ Lefi kí o sì wí fún wọn pé: ‘Nígbà tí ìdámẹ́wàá bá ń wọlé láti ọ̀dọ̀ àwọn ọmọ Israẹli gẹ́gẹ́ bí ogún rẹ. O gbọdọ̀ mú ìdámẹ́wàá lára rẹ̀ gẹ́gẹ́ bí ọrẹ Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","A ó ka ọrẹ rẹ gẹ́gẹ́ bí ọkà irúgbìn láti ilẹ̀ ìpakà tàbí wáìnì láti fún wa. ");
INSERT INTO yor_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Báyìí ni ìwọ gan an náà yóò mú ọrẹ wa fún Olúwa láti ara ìdámẹ́wàá tí ìwọ gbà láti ọ̀dọ̀ àwọn ọmọ Israẹli. Láti ara ìdámẹ́wàá ó gbọdọ̀ mú ọrẹ Olúwa fún Aaroni àlùfáà. ");
INSERT INTO yor_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ìwọ gbọdọ̀ mú wá gẹ́gẹ́ bí ìpín Olúwa èyí tí ó dára jùlọ àti tí ó jẹ́ mímọ́ jùlọ lára gbogbo nǹkan tí wọ́n mú wá fún ọ.’ ");
INSERT INTO yor_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Sọ fún àwọn ọmọ pé, ‘Nígbà tí ẹ̀yin bá mú ìpín tí ó dára jù wá, a ó kà á sí fún àwọn ọmọ Lefi gẹ́gẹ́ bí ìkórè láti ilẹ̀ ìpakà tàbí ìfúntí yín. ");
INSERT INTO yor_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ìwọ àti àwọn ìdílé rẹ̀ le jẹ èyí tí ó kù ní ibikíbi gbogbo. Nítorí pé ó jẹ́ ọrẹ fún iṣẹ́ rẹ níbi àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Nípa ṣíṣe ìgbékalẹ̀ ìpín tí ó dára jùlọ o kò ní jẹ̀bi lórí ọ̀rọ̀ yìí, ìwọ kò sì ní ba ọrẹ mímọ́ àwọn ọmọ Israẹli jẹ́, ìwọ kì yóò sì kú.’ ” ");
INSERT INTO yor_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Olúwa sọ fún Mose àti Aaroni pé, ");
INSERT INTO yor_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Èyí ni ohun tí òfin Olúwa pàṣẹ béèrè lọ́wọ́ yín. Sọ fún àwọn ọmọ Israẹli, kí wọn mú ẹgbọrọ ọ̀dọ́ màlúù pupa tí kò lábùkù tàbí àbàwọ́n, lára èyí tí a kò tí ì di àjàgà mọ́. ");
INSERT INTO yor_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ẹ mú fún Eleasari àlùfáà, yóò sì mu jáde lọ sí ẹ̀yìn ibùdó kí ó sì pa á ní ojú rẹ. ");
INSERT INTO yor_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Nígbà náà ni Eleasari àlùfáà yóò mú lára ẹ̀jẹ̀ rẹ̀ sórí ìka ọwọ́ rẹ̀ yóò sì wọn lẹ́ẹ̀méje ní ọ̀kánkán iwájú àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ní ojú rẹ̀ ni àlùfáà yóò ti sun ọ̀dọ́ abo màlúù yìí: awọ ara rẹ̀, ẹ̀jẹ̀ rẹ̀, ẹran-ara àti ìgbẹ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Àlùfáà yóò mú igi kedari, hísópù àti òwú òdòdó yóò sì jù wọ́n sí àárín ọ̀dọ́ abo màlúù tí a ń sun. ");
INSERT INTO yor_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Lẹ́yìn náà, àlùfáà gbọdọ̀ fọ aṣọ rẹ̀, kí ó sì wẹ ara rẹ̀ pẹ̀lú omi lẹ́yìn náà ó lè wá sínú àgọ́. Ṣùgbọ́n yóò jẹ́ aláìmọ́ títí ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ẹni tí ó sun ún náà gbọdọ̀ fọ aṣọ rẹ̀ kí ó sì wẹ̀ pẹ̀lú omi, òun náà yóò jẹ́ aláìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Ẹni tó wà ní mímọ́ ni yóò kó eérú ọ̀dọ́ màlúù náà lọ sí ibi tí a yà sí mímọ́ lẹ́yìn ibùdó. Kí gbogbo ìjọ ènìyàn Israẹli kó o pamọ́ fún lílò fún omi ìwẹ̀nùmọ́. Ó jẹ́ ìwẹ̀nùmọ́ kúrò nínú ẹ̀ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ọkùnrin tí ó kó eérú ọ̀dọ́ abo màlúù náà gbọdọ̀ fọ aṣọ rẹ̀, òun náà yóò sì jẹ́ aláìmọ́ títí ìrọ̀lẹ́. Èyí ni yóò jẹ́ ìlànà láéláé fún àwọn ọmọ Israẹli àti fún àwọn àjèjì tí ó ń gbé láàrín wọn. ");
INSERT INTO yor_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Ẹnikẹ́ni tí ó bá fi ọwọ́ kan òkú ẹnikẹ́ni, yóò jẹ́ aláìmọ́ fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ó gbọdọ̀ wẹ ara rẹ̀ pẹ̀lú omi ní ọjọ́ kẹta àti ní ọjọ́ keje; nígbà náà ni yóò jẹ́ mímọ́. Ṣùgbọ́n tí ó bá jẹ́ pé kò wẹ ara rẹ̀ mọ́ ní ọjọ́ kẹta àti ní ọjọ́ keje yóò jẹ́ aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ẹnikẹ́ni tí ó bá fi ọwọ́ kan òkú ẹnìkan tí kò sì wẹ ara rẹ̀ mọ́, ó ba àgọ́ Olúwa jẹ́. A ó ké irú ẹni bẹ́ẹ̀ kúrò lára àwọn ọmọ Israẹli. Nítorí pé a kò tí ì wọ́n omi ìwẹ̀nùmọ́ lé e lórí, ó jẹ́ aláìmọ́, àìmọ́ rẹ̀ sì wà lára rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Èyí ni òfin tí ó jẹ mọ́ bí ènìyàn bá kú nínú àgọ́, ẹnikẹ́ni tí ó bá wọ inú àgọ́ àti ẹni tí ó wà nínú àgọ́ yóò di aláìmọ́ fún ọjọ́ méje, ");
INSERT INTO yor_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","gbogbo ohun èlò tí a kò bá fi omọrí dé ni yóò jẹ́ aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Ẹnikẹ́ni tí ó bá wà ní ìta tí ó sì fi ọwọ́ kan ẹni tí a fi idà pa tàbí ẹni tí ó kú ikú àtọ̀runwá, tàbí bí ẹnìkan bá fi ọwọ́ kan egungun òkú ènìyàn tàbí isà òkú, yóò jẹ́ aláìmọ́ fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Fún aláìmọ́ ènìyàn, mú eérú díẹ̀ lára eérú ọrẹ ìwẹ̀nùmọ́ sínú ìgò, kí o sì da omi tó ń sàn lé e lórí. ");
INSERT INTO yor_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Nígbà náà, ọkùnrin tí a yà sí mímọ́ yóò mú hísópù díẹ̀ yóò rì í sínú omi yóò sì fi wọ́n àgọ́ àti gbogbo ohun èlò tí a ṣe lọ́ṣọ̀ọ́ àti àwọn ènìyàn tí ó wà níbẹ̀. O gbọdọ̀ tún fi wọ́n ẹnikẹ́ni tí ó fi ọwọ́ kan egungun òkú ènìyàn tàbí isà òkú, tàbí ẹni tí ó kú ikú ara rẹ̀, tàbí ẹni tí ó kú ikú àti ọ̀run wá. ");
INSERT INTO yor_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Ọkùnrin tí ó mọ́ ni kí ó bu omi wọ́n àwọn ènìyàn aláìmọ́ ní ọjọ́ kẹta àti ọjọ́ keje, ní ọjọ́ keje ó gbọdọ̀ wẹ ara rẹ̀ mọ́. Ẹni tí a wẹ̀mọ́ gbọdọ̀ fọ aṣọ rẹ̀ kí ó sì wẹ̀ pẹ̀lú omi, ní ìrọ̀lẹ́ ọjọ́ náà yóò mọ́. ");
INSERT INTO yor_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ṣùgbọ́n bí ẹni tí ó bá jẹ́ aláìmọ́ kò bá wẹ ara rẹ̀ mọ́, a gbọdọ̀ gé e kúrò nínú ìjọ ènìyàn, nítorí wí pé ó ti ba àgọ́ Olúwa jẹ́. A kò tí ì fi omi ìwẹ̀nùmọ́ sí ara rẹ̀, ó sì jẹ́ aláìmọ́. ");
INSERT INTO yor_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Èyí jẹ́ ìlànà láéláé fún wọn. “Ọkùnrin tí ó wọ́n omi ìwẹ̀nùmọ́ náà gbọdọ̀ fọ aṣọ rẹ̀ àti ẹnikẹ́ni tí ó fi ọwọ́ kan omi ìwẹ̀nùmọ́ yóò di aláìmọ́ títí di ìrọ̀lẹ́. ");
INSERT INTO yor_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Gbogbo ohun tí ẹni tí ó jẹ́ aláìmọ́ bá fi ọwọ́ kàn yóò di àìmọ́, ẹnikẹ́ni tí ó bá sì fi ọwọ́ kàn án yóò jẹ́ aláìmọ́ títí di ìrọ̀lẹ́.” ");
INSERT INTO yor_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ní oṣù kìn-ín-ní, gbogbo àgbájọ ọmọ Israẹli gúnlẹ̀ sí pápá Sini, wọ́n sì dúró ní Kadeṣi. Níbẹ̀ ni Miriamu kú, wọ́n sì sin ín. ");
INSERT INTO yor_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Omi kò sí fún ìjọ ènìyàn, àwọn ènìyàn sì kó ara wọn jọ pọ̀ sí Mose àti Aaroni, ");
INSERT INTO yor_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","wọ́n bá Mose jà wọ́n sì wí pé, “Ìbá kúkú sàn kí a kú nígbà tí àwọn arákùnrin ti kú níwájú Olúwa! ");
INSERT INTO yor_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Kí ni ó dé tí o sì kó gbogbo ìjọ ènìyàn Olúwa wá sí aginjù yìí, kí àwa àti àwọn ẹran ọ̀sìn wa bá à kú síbí? ");
INSERT INTO yor_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Kí ni ó dé tí o fi mú wa gòkè kúrò ní Ejibiti wá sí ibi búburú yìí? Ibi tí kò ní oúnjẹ tàbí igi ọ̀pọ̀tọ́, èso àjàrà tàbí pomegiranate. Bẹ́ẹ̀ ni kò sí omi tí a ó mu níhìn-ín!” ");
INSERT INTO yor_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mose àti Aaroni kúrò ní ibi àpéjọ, wọ́n sì lọ dojúbolẹ̀ sí ẹnu-ọ̀nà àgọ́ ìpàdé, ògo Olúwa sì farahàn wọ́n. ");
INSERT INTO yor_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Mú ọ̀pá, náà kí o sì pe ìjọ àwọn ènìyàn jọ, ìwọ àti Aaroni arákùnrin rẹ, kí ẹ sọ̀rọ̀ sí àpáta náà ní ojú wọn, yóò sì tú omi rẹ̀ jáde, ìwọ ó sì fún ìjọ àti ẹran wọn mu.” ");
INSERT INTO yor_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Báyìí ni Mose mú ọ̀pá láti iwájú Olúwa wá, gẹ́gẹ́ bí ó ti pàṣẹ fún un. ");
INSERT INTO yor_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Òun àti Aaroni pe àwọn ènìyàn jọ sí ojú kan níwájú àpáta, Mose sì sọ fún wọn, “Ẹ gbọ́, ẹ̀yin ọlọ̀tẹ̀, àwa kì yóò lè mú omi jáde láti inú àpáta yìí wá bí?” ");
INSERT INTO yor_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Nígbà náà ni Mose gbé ọwọ́ rẹ̀ sókè ó sì fi ọ̀pá ọwọ́ rẹ̀ lu àpáta lẹ́ẹ̀méjì. Omi sì tú jáde, gbogbo ìjọ ènìyàn àti àwọn ẹran ọ̀sìn wọn sì mu. ");
INSERT INTO yor_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ṣùgbọ́n Olúwa sọ fún Mose àti Aaroni pé, “Nítorí pé ẹ̀yin kò gbà mí gbọ́ tó láti bu ọlá fún mi níwájú àwọn ọmọ Israẹli, ìwọ kò ní kó àwọn ìjọ ènìyàn yìí dé ilẹ̀ tí mo fún wọn.” ");
INSERT INTO yor_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Èyí ni omi ti Meriba, níbi tí àwọn ọmọ Israẹli ti bá Olúwa jà àti ibi tí O ti fi ara rẹ̀ hàn bí ẹni mímọ́ láàrín wọn. ");
INSERT INTO yor_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mose sì ránṣẹ́ láti Kadeṣi sí ọba Edomu, wí pé, “Èyí ni nǹkan tí arákùnrin rẹ Israẹli sọ, ìwọ ti mọ̀ nípa gbogbo ìnira, tí ó wá sí orí wa. ");
INSERT INTO yor_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Àwọn baba ńlá wa sọ̀kalẹ̀ wá sí Ejibiti, a sì gbé ibẹ̀ fún ọ̀pọ̀ ọdún. Àwọn ará Ejibiti ni wá lára àti àwọn baba wa, ");
INSERT INTO yor_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ṣùgbọ́n nígbà tí a sọkún sí Olúwa, ó gbọ́ ẹkún wa, ó sì rán angẹli kan sí wa, ó sì mú wa jáde láti Ejibiti. “Báyìí àwa wà ní Kadeṣi, ìlú tí ó wà ní ẹ̀gbẹ́ ilẹ̀ rẹ. ");
INSERT INTO yor_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Jọ̀wọ́ jẹ́ kí a gba orílẹ̀-èdè rẹ kọjá, àwa kì yóò gba inú oko tàbí ọgbà àjàrà rẹ kọjá, tàbí mu omi láti inú kànga. A ó ma kọjá ní òpópónà ọba, àwa kì yóò yà sí ọ̀tún tàbí sí òsì títí àwa yóò fi kọjá ní ilẹ̀ rẹ.” ");
INSERT INTO yor_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ṣùgbọ́n Edomu dáhùn pé, “Ẹ̀yin kò le gba ibí kọjá; bí ẹ bá dán an wò, a ó dìde ogun sí yín, a ó sì bá yín jà pẹ̀lú idà.” ");
INSERT INTO yor_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Àwọn ọmọ Israẹli dáhùn pé, “A ó gba ọ̀nà tóóró, bí àwa tàbí ẹran ọ̀sìn wa bá sì mú lára omi rẹ, a ó san owó rẹ̀. A kàn fẹ́ rìn kọjá lórí ilẹ̀ rẹ ni kò sí nǹkan kan mìíràn tí a fẹ́ ṣe.” ");
INSERT INTO yor_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Wọ́n tún dáhùn wí pé, “Ẹ kò lè kọjá.” Nígbà náà ni Edomu jáde wá láti kọjú ìjà sí wọn pẹ̀lú ọ̀pọ̀ àti alágbára ọmọ-ogun. ");
INSERT INTO yor_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Nígbà tí Edomu sì kọ̀ jálẹ̀ láti jẹ́ kí wọn kọjá ní ilẹ̀ wọn, Israẹli yípadà kúrò lọ́dọ̀ wọn. ");
INSERT INTO yor_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Gbogbo ìjọ ènìyàn Israẹli sì jáde láti Kadeṣi wọ́n sì wá sí orí òkè Hori. ");
INSERT INTO yor_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ní orí òkè Hori, ní ẹ̀gbẹ́ ààlà Edomu Olúwa sọ fún Mose àti Aaroni pé, ");
INSERT INTO yor_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaroni yóò kú. Kò ní wọ ilẹ̀ tí mo fi fún àwọn ọmọ Israẹli, nítorí ẹ̀yin méjèèjì ṣe àìgbọ́ràn sí òfin mi níbi omi Meriba. ");
INSERT INTO yor_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Mú Aaroni àti ọmọ rẹ̀ Eleasari lọ sí orí òkè Hori. ");
INSERT INTO yor_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Bọ́ aṣọ Aaroni kí o sì gbe wọ ọmọ rẹ̀ Eleasari, nítorí pé Aaroni yóò kú síbẹ̀.” ");
INSERT INTO yor_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mose sì ṣe gẹ́gẹ́ bí Olúwa ti pàṣẹ, wọ́n lọ sí orí òkè Hori ní ojú gbogbo ìjọ ènìyàn. ");
INSERT INTO yor_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mose bọ́ aṣọ Aaroni ó sì gbe wọ ọmọ rẹ̀ Eleasari, Aaroni sì kú sí orí òkè. Nígbà náà Mose àti Eleasari sọ̀kalẹ̀ láti orí òkè, ");
INSERT INTO yor_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","nígbà tí gbogbo ìjọ ènìyàn sì gbọ́ pé Aaroni ti kú, gbogbo ilé Israẹli ṣe ìdárò rẹ̀ fún ọgbọ̀n ọjọ́. ");
INSERT INTO yor_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Nígbà tí ọba Aradi ará Kenaani, tí ń gbé ní gúúsù gbọ́ wí pé Israẹli ń bọ̀ wá ní ojú ọ̀nà Atarimu, ó bá Israẹli jà ó sì fi agbára mú díẹ̀ lára wọn. ");
INSERT INTO yor_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Nígbà náà ni Israẹli jẹ́ ẹ̀jẹ́ fún Olúwa pé, “Bí o bá lè fi àwọn ènìyàn yìí lé wa lọ́wọ́, gbogbo ìlú wọn ni a ó parun.” ");
INSERT INTO yor_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Olúwa gbọ́ ẹ̀bẹ̀ àwọn ọmọ Israẹli, ó sì fi àwọn ará Kenaani lé wọn lọ́wọ́. Wọ́n pa wọ́n run pátápátá; torí náà ni a ṣe ń pe ibẹ̀ ní Horma. ");
INSERT INTO yor_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Wọ́n rin ìrìnàjò láti òkè Hori lọ sí ọ̀nà tó lọ sí Òkun Pupa, láti kọjá yípo Edomu. Ṣùgbọ́n àwọn ènìyàn bínú ní ojú ọ̀nà; ");
INSERT INTO yor_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","wọ́n sì sọ̀rọ̀ lòdì sí Ọlọ́run àti Mose, wọ́n wí pé, “Èéṣe tí ìwọ fi mú wa jáde láti Ejibiti kí a ba le wá kú sí aginjù yìí? Kò sí oúnjẹ! Kò sì sí omi! Àwa sì kórìíra oúnjẹ tí kò dára yìí!” ");
INSERT INTO yor_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Nígbà náà ni Olúwa rán ejò olóró sí àárín wọn; wọ́n gé àwọn ènìyàn jẹ, ọ̀pọ̀ àwọn ọmọ Israẹli sì kú. ");
INSERT INTO yor_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Àwọn ènìyàn sì wá sí ọ̀dọ̀ Mose wọn wí pé, “A ti dá ẹ̀ṣẹ̀ nígbà tí asọ̀rọ̀-òdì sí Olúwa àti sí ìwọ pẹ̀lú. Gba àdúrà pé kí Olúwa mú ejò náà kúrò lọ́dọ̀ wa.” Nígbà náà ni Mose gbàdúrà fún àwọn ènìyàn. ");
INSERT INTO yor_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Olúwa sọ fún Mose pé, “Rọ ejò, a ó sì gbé e kọ́ sókè lórí igi, ẹni tí ejò bá ti gé jẹ lè wò ó yóò sì yè.” ");
INSERT INTO yor_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Nígbà náà ni Mose sì rọ ejò onírin ó sì gbé e kọ́ sórí igi, bí ejò bá sì bu ẹnikẹ́ni jẹ bí ó bá ti wò ó yóò sì yè. ");
INSERT INTO yor_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Àwọn ọmọ Israẹli tẹ̀síwájú wọ́n sì péjọ sí Obotu. ");
INSERT INTO yor_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Wọ́n gbéra ní Obotu wọ́n sì pa ibùdó sí Iye-Abarimu, ní aginjù tí ó kọjú sí Moabu ní ìdojúkọ ìlà-oòrùn. ");
INSERT INTO yor_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Láti ibẹ̀ ni wọ́n ti gbéra wọ́n sì pa ibùdó ní àfonífojì Seredi. ");
INSERT INTO yor_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Láti ibẹ̀ lọ, wọn ṣí, wọ́n sì dó sí ìhà kejì Arnoni, tí ó wà ní aginjù tí ó wà ní agbègbè ilẹ̀ àwọn ọmọ Amori. Arnoni jẹ́ ààlà fún ilẹ̀ Moabu, láàrín Moabu àti Amori. ");
INSERT INTO yor_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ìdí nìyìí tí ìwé ogun Olúwa se wí pé, “…Wahebu ní Sufa, Òkun Pupa àti ní odò Arnoni ");
INSERT INTO yor_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","àti ní ìṣàn odò tí ó darí sí ibùjókòó Ari tí ó sì fi ara ti ìpínlẹ̀ Moabu.” ");
INSERT INTO yor_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Láti ibẹ̀ ni wọ́n ti bẹ̀rẹ̀ rìn dé Beeri, èyí ni kànga tí Olúwa sọ fún Mose, “Kó àwọn ènìyàn jọ èmi ó sì fún wọn ní omi.” ");
INSERT INTO yor_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Nígbà náà ni Israẹli kọ orin yìí pé, “Sun jáde, ìwọ kànga! Ẹ máa kọrin nípa rẹ̀, ");
INSERT INTO yor_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","nípa kànga tí àwọn ọmọ-aládé gbẹ́, nítorí àwọn ọlọ́lá ènìyàn ni ó gbẹ́ ẹ; tí àwọn ọlọ́lá àwọn ènìyàn sì fi ọ̀pá aládé àti ọ̀pá oyè wọn gbẹ́.” Nígbà náà wọ́n kúrò láti aginjù lọ sí Mattana, ");
INSERT INTO yor_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","láti Mattana lọ sí Nahalieli, láti Nahalieli lọ sí Bamoti, ");
INSERT INTO yor_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","àti láti Bamoti lọ sí àfonífojì ní Moabu níbi tí òkè Pisga, tí ó wà ní òkè ilé omi ti kọjú sí aginjù. ");
INSERT INTO yor_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israẹli rán oníṣẹ́ láti sọ fún Sihoni ọba àwọn ará Amori wí pé, ");
INSERT INTO yor_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Jẹ́ kí a kọjá ní orílẹ̀-èdè rẹ. A kò ní kọjá sí inú oko pápá tàbí ọgbà àjàrà àbí mu omi láti inú kànga. A máa gba òpópónà náà ti ọba títí tí a ó fi la ilẹ̀ rẹ kọjá.” ");
INSERT INTO yor_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ṣùgbọ́n Sihoni kò ní jẹ́ kí àwọn Israẹli kọjá ní ilẹ̀ wọn. Ó pe àwọn ọmọ-ogun rẹ̀ jọ wọ́n sì wọ́de ogun lọ sí aginjù nítorí àwọn ọmọ Israẹli. Nígbà tí ó dé Jahasi, ó bá àwọn ọmọ Israẹli jà. ");
INSERT INTO yor_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Àmọ́, Israẹli ṣẹ́gun, wọn fi ojú idà pa wọ́n, wọ́n sì gba ilẹ̀ láti ọwọ́ Arnoni lọ dé Jabbok, títí tí ó fi dé ilẹ̀ àwọn ará Ammoni, nítorí pé ààlà wọn jẹ́ olódi. ");
INSERT INTO yor_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israẹli sì gba gbogbo ìlú Amori wọ́n sì ń gbé ibẹ̀ pẹ̀lú Heṣboni, àti gbogbo ibùgbé ìlú tó yí i ká. ");
INSERT INTO yor_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heṣboni ni ìlú Sihoni ọba àwọn ará Amori, ẹni tí ó bá ọba Moabu ti tẹ́lẹ̀ jà tí ó sì gba gbogbo ilẹ̀ rẹ̀ ní ọwọ́ rẹ̀ títí dé Arnoni. ");
INSERT INTO yor_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ìdí nìyìí tí akọrin sọ wí pé, “Wá sí Heṣboni kí ẹ jẹ́ kí a tún un kọ́; jẹ́ kí ìlú Sihoni padà bọ̀ sípò. ");
INSERT INTO yor_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Iná jáde láti Heṣboni, ọ̀wọ́-iná láti Sihoni. Ó jó Ari àti Moabu run, àti ìlú àwọn olùgbé ibi gíga Arnoni. ");
INSERT INTO yor_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ègbé ní fún ọ, ìwọ Moabu! Ẹ ti parun, ẹ̀yin ènìyàn Kemoṣi! Ó ti fi ọmọ rẹ̀ ọkùnrin sílẹ̀ gẹ́gẹ́ bí ìsáǹsá àti ọmọ rẹ̀ obìnrin gẹ́gẹ́ bí ìgbèkùn fún Sihoni ọba àwọn Amori. ");
INSERT INTO yor_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Ṣùgbọ́n àti bì wọ́n ṣubú; a ti pa ìjẹgàba Heṣboni run, a pa wọ́n run títí dé Diboni. A sì ti bì wọ́n lulẹ̀ títí dé Nofa, tí ó sì fi dé Medeba.” ");
INSERT INTO yor_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Nígbà náà ni àwọn ọmọ Israẹli sì ń gbé ní ilẹ̀ Amori. ");
INSERT INTO yor_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Lẹ́yìn ìgbà tí Mose rán ayọ́lẹ̀wò lọ sí Jaseri, àwọn ọmọ Israẹli sì gba àwọn agbègbè tó yí wọn ká wọ́n sì lé àwọn Amori tó wà níbẹ̀ jáde. ");
INSERT INTO yor_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Nígbà náà wọ́n pẹ̀yìndà wọ́n sì gòkè lọ sí Baṣani, Ogu ọba ti Baṣani àti gbogbo àwọn ọmọ-ogun tí ó wọ́de ogun jáde láti pàdé wọn ní ojú ogun ní Edrei. ");
INSERT INTO yor_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Olúwa sọ fún Mose pé, “Má ṣe bẹ̀rù rẹ̀, nítorí tí mó tí fi òun lé ọ lọ́wọ́, àti àwọn ọmọ-ogun rẹ̀, àti ilẹ̀ rẹ̀, kí ìwọ kí ó ṣe sí i gẹ́gẹ́ bí ìwọ ti ṣe sí Sihoni ọba Amori ẹni tí ó ń jẹ ọba ní Heṣboni.” ");
INSERT INTO yor_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Wọ́n sì pa á, pẹ̀lú àwọn ọmọ rẹ̀ àti gbogbo àwọn ọmọ-ogun rẹ̀, wọn kò fi ku ẹnìkan fún un láàyè. Wọ́n sì gba ìní ilẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Nígbà náà àwọn ọmọ Israẹli rin ìrìnàjò lọ sí pẹ̀tẹ́lẹ̀ Moabu wọ́n sì pa ibùdó lẹ́gbẹ̀ẹ́ Jordani tí ó kọjá lọ sí Jeriko. ");
INSERT INTO yor_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Nísinsin yìí, Balaki ọmọ Sippori rí gbogbo ohun tí àwọn Israẹli ti ṣe sí àwọn ará Amori, ");
INSERT INTO yor_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ẹ̀rù sì ba Moabu nítorí pé ọ̀pọ̀ ènìyàn wà níbẹ̀ nítòótọ́, Moabu kún fún ẹ̀rù nítorí àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moabu sọ fún àwọn àgbàgbà Midiani pé, “Nísinsin yìí ni àwọn wọ̀nyí yóò lá gbogbo ohun tí ó yí wa ká, bí màlúù ṣe ń jẹ koríko tí ó wà nínú oko.” Bẹ́ẹ̀ ni Balaki ọmọ Sippori, tí ó jẹ́ ọba Moabu nígbà náà, ");
INSERT INTO yor_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","rán oníṣẹ́ pé Balaamu ọmọ Beori, tí ó wà ní Petori, ní ẹ̀bá odò Eufurate, ti ilẹ̀ àwọn ènìyàn rẹ. Balaki sọ pé, “Àwọn ènìyàn kan jáde wá láti Ejibiti; wọ́n bo gbogbo ilẹ̀ ayé wọ́n sì pa ibùdó súnmọ́ ọ̀dọ̀ mi. ");
INSERT INTO yor_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Nísinsin yìí, wá fi àwọn ènìyàn wọ̀nyí bú, nítorí wọ́n ní agbára jù fún mi. Nípa ṣíṣe èyí èmi ó ṣẹ́gun wọn, kí n sì lé wọn kúrò ní ilẹ̀ yìí. Nítorí tí mo mọ̀ pé ìbùkún ni fún àwọn tí ìwọ bá bùkún, ìfibú sì ni ẹni tí ìwọ bá fi bú.” ");
INSERT INTO yor_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Àti àwọn àgbàgbà Moabu àti Midiani sì lọ pẹ̀lú owó àyẹ̀wò lọ́nà wọn, nígbà tí wọ́n dé ọ̀dọ̀ Balaamu, wọ́n sọ nǹkan tí Balaki sọ fún wọn. ");
INSERT INTO yor_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","“Ẹ sùn níbí lálẹ́ yìí,” Balaamu sọ fún un pé, “èmi ó padà wá fún un yín ní èsì nǹkan tí Olúwa bá wí fún mi.” Nítorí tí àwọn ìjòyè Moabu dúró sọ́dọ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ọlọ́run tọ Balaamu wá ó sì wí pé, “Ta ni àwọn ọkùnrin tí ó wà pẹ̀lú rẹ yìí?” ");
INSERT INTO yor_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaamu sọ fún Ọlọ́run pé, “Balaki ọmọ Sippori, ọba Moabu, rán iṣẹ́ yìí sí mi pé, ");
INSERT INTO yor_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Àwọn ènìyàn kan ti ilẹ̀ Ejibiti jáde wá tí wọ́n bo ojú ilẹ̀. Nísinsin yìí, wá, kí o wá fi wọ́n bú fún mi. Bóyá èmi yóò lè bá wọn jà, èmi ó sì lé wọn jáde.’ ” ");
INSERT INTO yor_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ṣùgbọ́n Ọlọ́run sọ fún Balaamu pé, “Má ṣe bá wọn lọ. Ìwọ kò gbọdọ̀ gé ègún lé àwọn ènìyàn náà lórí, nítorí a ti bùkún wọn.” ");
INSERT INTO yor_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ní òwúrọ̀ ọjọ́ kejì Balaamu dìde ó sì sọ fún àwọn ìjòyè Balaki pé, “Ẹ padà sí orílẹ̀-èdè yín, nítorí tí Olúwa ti kọ̀ láti jẹ́ kí n tẹ̀lé yín.” ");
INSERT INTO yor_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Nígbà náà àwọn ìjòyè Moabu sì padà tọ Balaki lọ wọ́n sì wí pé, “Balaamu kọ̀ láti tẹ̀lé wa.” ");
INSERT INTO yor_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Nígbà náà Balaki rán àwọn ìjòyè mìíràn tí wọ́n pọ̀ àwọn tí wọ́n sì níyì ju alákọ́kọ́ lọ. ");
INSERT INTO yor_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Wọ́n lọ sí ọ̀dọ̀ Balaamu wọ́n sì sọ pé, “Èyí ni ohun tí Balaki ọmọ Sippori sọ, má ṣe jẹ́ kí ohunkóhun kí ó dè ọ́ lọ́nà láti wá sí ọ̀dọ̀ mi, ");
INSERT INTO yor_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","nítorí pé èmi yóò fún ọ ní ẹ̀bùn dáradára, èmi yóò sì ṣe ohunkóhun tí ìwọ bá sọ. Wá, kí o sì wá fi àwọn ènìyàn wọ̀nyí bú fún mi.” ");
INSERT INTO yor_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ṣùgbọ́n Balaamu dá wọn lóhùn pé, “Kódà tí Balaki bá fún mi ní ààfin rẹ̀ tí ó kún fún fàdákà àti wúrà, èmi kò ní ṣe ohunkóhun tí ó tóbi tàbí kéré tí ó kọjá òfin Olúwa Ọlọ́run mi. ");
INSERT INTO yor_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nísinsin yìí ẹ dúró níbí di ọjọ́ kejì gẹ́gẹ́ bí àwọn tókù ti ṣe nígbà náà èmi yóò mọ ohun tí Olúwa yóò tún sọ fún mi.” ");
INSERT INTO yor_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ní alẹ́ ọjọ́ náà Ọlọ́run sì tọ Balaamu wá ó sì sọ wí pé, “Nígbà tí ọkùnrin yìí ti wá pè ọ́, lọ pẹ̀lú wọn, ṣùgbọ́n ẹnu nǹkan tí mo sọ fún ọ ni kí o ṣe.” ");
INSERT INTO yor_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaamu dìde ní òwúrọ̀, ó sì di ẹrù lé kẹ́tẹ́kẹ́tẹ́ rẹ̀ òun pẹ̀lú àwọn ìjòyè Moabu. ");
INSERT INTO yor_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ṣùgbọ́n Ọlọ́run bínú gidigidi, angẹli Olúwa sì dúró lójú ọ̀nà láti dojú ìjà kọ ọ́. Balaamu ń gun kẹ́tẹ́kẹ́tẹ́ rẹ̀ lọ, àwọn ìránṣẹ́ rẹ̀ méjì sì wà pẹ̀lú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Nígbà tí kẹ́tẹ́kẹ́tẹ́ náà sì rí angẹli Olúwa tí ó dúró ní ojú ọ̀nà pẹ̀lú idà tí a fàyọ ní ọwọ́ rẹ̀, ó kọjú kúrò ní ọ̀nà lọ sínú oko. Balaamu sì lù ú pé kí ó gbé òhun padà lọ sí ojú ọ̀nà. ");
INSERT INTO yor_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Nígbà náà angẹli Olúwa dúró ní ojú ọ̀nà tóóró láàrín ọgbà àjàrà, pẹ̀lú ògiri ní ọ̀nà méjèèjì. ");
INSERT INTO yor_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Nígbà tí kẹ́tẹ́kẹ́tẹ́ rí angẹli Olúwa, ó lẹ̀ mọ́ ẹ̀gbẹ́ ògiri, ó sì rún ẹsẹ̀ Balaamu mọ́ ògiri. Nígbà náà, ó tún nà án, lẹ́ẹ̀kan sí i. ");
INSERT INTO yor_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Nígbà náà angẹli Olúwa súnmọ́ wájú ó sì dúró níbi ọ̀nà tóóró níbi tí kò ti sí ọ̀nà láti yípadà, bóyá ní ọ̀tún tàbí òsì. ");
INSERT INTO yor_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Nígbà tí kẹ́tẹ́kẹ́tẹ́ rí angẹli Olúwa, ó sì jókòó ní abẹ́ Balaamu, inú sì bí i tó sì nà án pẹ̀lú ọ̀pá rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Nígbà náà Olúwa ṣí ẹnu kẹ́tẹ́kẹ́tẹ́, ó sì sọ fún Balaamu pé, “Kí ni mo ṣe fún ọ tí o fi nà mí lẹ́ẹ̀mẹ́ta?” ");
INSERT INTO yor_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaamu sọ fún kẹ́tẹ́kẹ́tẹ́ pé, “Nítorí ìwọ fi mí ṣẹ̀sín! Bí mo bá ní idà ní ọwọ́ ni èmi ìbá pa ọ́ nísinsin yìí.” ");
INSERT INTO yor_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Kẹ́tẹ́kẹ́tẹ́ sọ fún Balaamu pé, “Ṣé mi kì í ṣe kẹ́tẹ́kẹ́tẹ́ rẹ ni, tí o máa ń gùn ní gbogbo ìgbà, láti ìgbà pípẹ́ wá? Ǹjẹ́ mo hu irú ìwà báyìí sí ọ rí?” “Rárá,” Ó dáhùn. ");
INSERT INTO yor_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Nígbà náà Olúwa ṣí ojú Balaamu, ó sì rí angẹli Olúwa tí ó dúró ní ojú ọ̀nà pẹ̀lú idà rẹ̀ tí ó fàyọ. Ó sì tẹ orí rẹ̀ ba. ");
INSERT INTO yor_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Nígbà náà angẹli Olúwa béèrè lọ́wọ́ rẹ̀ pé, “Kí ni ó dé tí o fi na kẹ́tẹ́kẹ́tẹ́ rẹ nígbà mẹ́ta yìí? Mo wá síbí láti kọ ojú ìjà sí ọ nítorí ọ̀nà rẹ kò tọ́ níwájú mi. ");
INSERT INTO yor_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Kẹ́tẹ́kẹ́tẹ́ rí mi ó sì yà kúrò fún mi lẹ́ẹ̀mẹ́ta yìí. Tí ó bá jẹ́ wí pé kò yà kúrò. Èmi kì ìbá ti pa ọ́ pátápátá nísinsin yìí, ṣùgbọ́n Èmi yóò sì dá òun sí.” ");
INSERT INTO yor_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaamu sọ fún angẹli Olúwa pé, “Mo ti dẹ́ṣẹ̀, èmi kò mọ̀ pé o dúró níwájú ọ̀nà láti dojúkọ mí, nísinsin yìí tí inú rẹ kò bá dùn, èmi ó padà.” ");
INSERT INTO yor_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Angẹli Olúwa sọ fún Balaamu pé, “Lọ pẹ̀lú àwọn arákùnrin náà, ṣùgbọ́n nǹkan tí mo sọ fún ọ nìkan ni kí o sọ.” Nígbà náà Balaamu lọ pẹ̀lú àwọn ìjòyè Balaki. ");
INSERT INTO yor_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Nígbà tí Balaki gbọ́ pé Balaamu ń bọ̀ wá, ó jáde lọ láti lọ pàdé rẹ̀ ní ìlú Moabu tí ó wà ní agbègbè Arnoni, ní ẹ̀gbẹ́ ilẹ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki sì sọ fún Balaamu pé, “Ǹjẹ́ èmi kò a ránṣẹ́ kánjúkánjú sí ọ? Kí ló dé tí ìwọ kò fi wá sí ọ̀dọ̀ mi? Ṣé èmi kò tó láti sọ ọ́ di ẹni ńlá?” ");
INSERT INTO yor_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaamu sì wí fún Balaki pé, “Kíyèsi, èmi tọ̀ ọ́ wá, èmi kò ha ní agbára kan nísinsin yìí rárá láti wí ohun kan? Mo gbọdọ̀ sọ nǹkan tí Ọlọ́run fi sí mi lẹ́nu.” ");
INSERT INTO yor_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Nígbà náà Balaamu lọ pẹ̀lú Balaki sí Kiriati-Hosotia. ");
INSERT INTO yor_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki rú ẹbọ akọ màlúù pẹ̀lú àgùntàn, ó sì fún Balaamu ní díẹ̀ pẹ̀lú àwọn ìjòyè tí ó wà ní ọ̀dọ̀ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ní òwúrọ̀ ọjọ́ kejì Balaki gbé Balaamu lọ sí Bamoti Baali, láti ibẹ̀ ló ti rí apá kan àwọn ènìyàn. ");
INSERT INTO yor_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaamu wí fún Balaki pé, “Kọ́ pẹpẹ méje fún mi níbí, kí o sì mú akọ màlúù méje àti àgbò méje wá fún mi.” ");
INSERT INTO yor_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki ṣe bí Balaamu ti sọ, àwọn méjèèjì fi akọ màlúù kọ̀ọ̀kan àti àgbò kọ̀ọ̀kan rú ẹbọ lórí pẹpẹ kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Nígbà náà Balaamu sọ fún Balaki pé, “Dúró ti ẹbọ sísun rẹ kí èmi sì lọ sí ẹ̀gbẹ́ kan. Bóyá Olúwa yóò farahàn mí. Ohunkóhun tí ó bá fihàn mí, èmi yóò wí fún ọ.” Nígbà náà ó sì lọ sí ibi gíga. ");
INSERT INTO yor_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ọlọ́run sì pàdé rẹ̀, Balaamu sì sọ pé, “Mo tí ṣe pẹpẹ méje, lórí pẹpẹ kọ̀ọ̀kan mo ti fi akọ màlúù àti àgbò kọ̀ọ̀kan rú ẹbọ.” ");
INSERT INTO yor_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Olúwa sì fi ọ̀rọ̀ sí ẹnu Balaamu ó wí pé, “Padà sí ọ̀dọ̀ Balaki kí o sì jẹ́ iṣẹ́ yìí fún un.” ");
INSERT INTO yor_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ó sì padà sí ọ̀dọ̀ rẹ̀ ó sì ba tí ó dúró ti ẹbọ sísun rẹ̀, pẹ̀lú gbogbo àwọn ìjòyè Moabu. ");
INSERT INTO yor_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Nígbà náà ni Balaamu sọ ọ̀rọ̀-ìjìnlẹ̀ jáde wí pé, “Balaki mú mi láti Aramu wá, ọba Moabu láti òkè ìlà-oòrùn wá Ó wí pé, ‘Wá fi Jakọbu bú fún mi; wá, kí o sì jẹ́rìí sí Israẹli.’ ");
INSERT INTO yor_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Báwo ní èmi ó ṣe fi bú àwọn tí Ọlọ́run kò fi bú? Báwo ni èmi ó ṣe bá wọn wí àwọn tí Olúwa kò bá wí? ");
INSERT INTO yor_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Láti ṣóńṣó ibi gíga orí àpáta ni mo ti rí wọn, láti orí ibi gíga ni mo ti ń wò wọ́n. Mo rí àwọn ènìyàn tí ń gbé lọ́tọ̀ wọn kò sì ka ará wọn kún ara àwọn orílẹ̀-èdè. ");
INSERT INTO yor_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ta ni ó lè ka eruku Jakọbu tàbí ka ìdámẹ́rin Israẹli? Jẹ́ kí èmi kú ikú olódodo, kí ìgbẹ̀yìn mi kí ó dà bí tirẹ̀!” ");
INSERT INTO yor_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki sọ fún Balaamu pé, “Kí lo ṣe fún mi? Mo gbé ọ wá láti fi àwọn ọ̀tá mi bú, ṣùgbọ́n o kò ṣe nǹkan kan, ṣùgbọ́n o bùkún wọn!” ");
INSERT INTO yor_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ó sì dáhùn wí pé, “Ṣé kí n má sọ nǹkan tí Olúwa fi sí mi lẹ́nu?” ");
INSERT INTO yor_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Nígbà náà Balaki sọ fún un pé, “Wá pẹ̀lú mi sí ibòmíràn tí o ti lè rí wọn; wà á rí díẹ̀, ṣùgbọ́n kì í ṣe gbogbo wọn. Láti ibẹ̀, wá fi wọ́n bú fún mi.” ");
INSERT INTO yor_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ó sì lọ sí pápá Sofimu ní orí òkè Pisga, ó sì kọ́ pẹpẹ méje síbẹ̀ ó sì fi akọ màlúù àti àgbò kọ̀ọ̀kan rú ẹbọ lórí pẹpẹ kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaamu ṣo fún Balaki pé, “Dúró níbí ti ẹbọ sísun rẹ nígbà tí mo bá lọ pàdé rẹ̀ níbẹ̀.” ");
INSERT INTO yor_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Olúwa pàdé Balaamu ó sì fi ọ̀rọ̀ sí ní ẹnu wí pé, “Padà lọ sí ọ̀dọ̀ Balaki kí o sì jíṣẹ́ fún un.” ");
INSERT INTO yor_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Nígbà náà ó lọ sí ọ̀dọ̀ rẹ̀ ó sì bá à tí ó dúró ti ẹbọ sísun rẹ̀ pẹ̀lú àwọn ìjòyè Moabu. Balaki sì béèrè lọ́wọ́ rẹ̀ pé, “Kí ni Olúwa wí?” ");
INSERT INTO yor_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Nígbà náà ó bẹ̀rẹ̀ ọ̀rọ̀ sísọ, “Dìde, Balaki; kí o sì gbọ́ mi ọmọ Sippori. ");
INSERT INTO yor_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ọlọ́run kì í ṣe ènìyàn, tí yóò fi purọ́, tàbí ọmọ ènìyàn, tí ó lè yí ọkàn rẹ̀ padà. Ǹjẹ́ ó sọ̀rọ̀ kí ó má ṣe é? Ǹjẹ́ ó ti ṣèlérí kí ó má mu un ṣẹ? ");
INSERT INTO yor_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Èmi gba àṣẹ láti bùkún; Ó sì ti bùkún, èmi kò sì lè yípadà. ");
INSERT INTO yor_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Kò rí ẹ̀ṣẹ̀ kankan nínú Jakọbu, kò sì rí búburú kankan nínú Israẹli. Olúwa Ọlọ́run wọn sì wà pẹ̀lú wọn. Ìhó ọba sì wà pẹ̀lú wọn. ");
INSERT INTO yor_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ọlọ́run mú wọn jáde láti Ejibiti wá, wọ́n ní agbára màlúù ẹhànnà. ");
INSERT INTO yor_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Kò ní àfọ̀ṣẹ sí Jakọbu, tàbí àfọ̀ṣẹ sí àwọn Israẹli. Nísinsin yìí a ó sọ nípa ti Jakọbu àti Israẹli, ‘Wo ohun tí Ọlọ́run ti ṣe!’ ");
INSERT INTO yor_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Àwọn ènìyàn náà yóò dìde bí abo kìnnìún; wọ́n yóò sì gbé ara wọn sókè bí i kìnnìún òun kì yóò sì dùbúlẹ̀ títí yóò fi jẹ ohun ọdẹ títí yóò sì fi mu nínú ẹ̀jẹ̀ ohun pípa.” ");
INSERT INTO yor_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Nígbà náà ni Balaki wí fún Balaamu pé, “O kò kúkú fi wọ́n bú, bẹ́ẹ̀ ni o kò súre fún wọn rárá!” ");
INSERT INTO yor_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaamu dáhùn ó sì wí fún Balaki pé, “Ǹjẹ́ èmi kò ha ti wí fún ọ pé, gbogbo èyí tí Olúwa bá sọ, òun ni èmi yóò ṣe?” ");
INSERT INTO yor_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Nígbà náà Balaki sọ fún Balaamu pé, “Wá jẹ́ kí èmi kí ó mú ọ lọ sí ibòmíràn bóyá yóò tẹ́ Ọlọ́run lọ́rùn kí ó fi wọ́n bú láti ibẹ̀ lọ.” ");
INSERT INTO yor_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaki gbé Balaamu wá sí orí òkè Peori, tí ó kọjú sí aginjù. ");
INSERT INTO yor_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaamu sì wí fún Balaki pé, “Mọ pẹpẹ méje fún mi níbí kí o sì pèsè akọ màlúù àti àgbò fún mi.” ");
INSERT INTO yor_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki sì ṣe bí Balaamu ti sọ fún un, ó sì gbé akọ màlúù kan àti àgbò lórí pẹpẹ kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Nísinsin yìí nígbà tí Balaamu rí i wí pé ó tẹ́ Olúwa lọ́rùn láti bùkún àwọn Israẹli, kò lo ọ̀nà ìṣoṣó gẹ́gẹ́ bí ti ìgbà ìṣáájú, ṣùgbọ́n ó yí ojú rẹ̀ sí apá aginjù. ");
INSERT INTO yor_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Nígbà tí Balaamu wo ìta ó sì rí Israẹli tí wọ́n pàgọ́ gẹ́gẹ́ bí ẹ̀yà wọn, Ẹ̀mí Ọlọ́run sì bà sórí rẹ̀ ");
INSERT INTO yor_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ó sì sọ àsọtẹ́lẹ̀ rẹ̀, “Àsọtẹ́lẹ̀ tí Balaamu ọmọ Beori, àsọtẹ́lẹ̀ ẹni tí ojú rẹ̀ ríran kedere, ");
INSERT INTO yor_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","àsọtẹ́lẹ̀ ẹni tí ó gbọ́ ọ̀rọ̀ Ọlọ́run, ẹni tí ó ríran láti ọ̀dọ̀ Olódùmarè, ẹni tí ó dojúbolẹ̀, tí ojú rẹ̀ là kedere. ");
INSERT INTO yor_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Àgọ́ rẹ ti dára tó, ìwọ Jakọbu, àti ibùgbé rẹ, ìwọ Israẹli! ");
INSERT INTO yor_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Gẹ́gẹ́ bí àfonífojì tí ó tàn jáde, gẹ́gẹ́ bí ọgbà tí ó wà ní ẹ̀bá odò ńlá, gẹ́gẹ́ bí igi aloe tí Olúwa gbìn, gẹ́gẹ́ bí igi kedari tí ó wà lẹ́bàá odò. ");
INSERT INTO yor_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Omi yóò sàn láti inú garawa: èso wọn yóò ní ọ̀pọ̀lọpọ̀ omi. “Ọba wọn yóò ga ju Agagi lọ; ìjọba wọn yóò di gbígbéga. ");
INSERT INTO yor_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Ọlọ́run mú wọn jáde láti Ejibiti wá; wọ́n ní agbára gẹ́gẹ́ bí i ti àgbáǹréré. Wọ́n jẹ orílẹ̀-èdè tí ń ṣe ọ̀tá rẹ̀ run, wọ́n sì fọ́ egungun wọn sí túútúú; wọ́n ó sì fi ọfà wọn ta wọ́n ní àtapòyọ. ");
INSERT INTO yor_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ó tẹríba ó sì dùbúlẹ̀ bí kìnnìún, bí abo kìnnìún: ta ni ó gbọdọ̀ jí wọn? “Ìbùkún ni fún ẹni tí ó bùkún fún ọ, kí ìfibú jẹ́ ti ẹni tí ó fi ọ́ bú!” ");
INSERT INTO yor_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Nígbà náà ni ìbínú Balaki sì dé sí Balaamu. Ó sì fi ọwọ́ lu ọwọ́ ó wí pé, “Mo pè ọ́ láti bú àwọn ọ̀tá mi ṣùgbọ́n o tún bùkún fún wọn nígbà mẹ́ta yìí. ");
INSERT INTO yor_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Nísinsin yìí sálọ sí ibùjókòó rẹ! Èmi ti rò láti sọ ọ́ di ẹni ńlá, ṣùgbọ́n Olúwa tí fà ọ́ sẹ́yìn láti gba èrè yìí.” ");
INSERT INTO yor_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaamu dá Balaki lóhùn, “Ǹjẹ́ èmi kò sọ fún àwọn ìránṣẹ́ tí o rán sí mi wí pé, ");
INSERT INTO yor_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Kódà bí Balaki bá fún mi ní ààfin rẹ̀ tí ó kún fún fàdákà àti wúrà, èmi kò le ṣe ohunkóhun lọ́wọ́ ara mi, yálà búburú tàbí rere, láti kọjá òfin Olúwa: ohun tí Olúwa bá wí ni èmi ó sọ’? ");
INSERT INTO yor_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Nísinsin yìí mò ń padà lọ sí ọ̀dọ̀ àwọn ènìyàn mi, ṣùgbọ́n jẹ́ kí èmi kí ó kìlọ̀ fún ọ nítorí nǹkan tí àwọn ènìyàn wọ̀nyí yóò ṣe sí àwọn ènìyàn rẹ ní ọjọ́ iwájú.” ");
INSERT INTO yor_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Nígbà náà ni ó bẹ̀rẹ̀ òwe: “Òwe Balaamu ọmọ Beori, òwe ẹni tí ojú rẹ̀ ríran kedere, ");
INSERT INTO yor_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ẹni tó gbọ́ ọ̀rọ̀ Ọlọ́run ń wí, tí ó sì mọ ìmọ̀ Ọ̀gá-ògo, tí ó ríran láti ọ̀dọ̀ Olódùmarè, ẹni tí ó dọ̀bálẹ̀, tí ojú rẹ̀ sì ṣí: ");
INSERT INTO yor_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Mo rí i, ṣùgbọ́n kì í ṣe ìsinsin yìí. Mo kíyèsi, ṣùgbọ́n kò súnmọ́. Ìràwọ̀ kan yóò jáde láti ọ̀dọ̀ Jakọbu; yóò yọ jáde láti Israẹli. Yóò tẹ̀ fọ́ orí Moabu, yóò sì fọ́ agbárí gbogbo ọmọ Seti. ");
INSERT INTO yor_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Wọn yóò borí Edomu; yóò ṣẹ́gun Seiri ọ̀tá rẹ̀, ṣùgbọ́n Israẹli yóò dàgbà nínú agbára. ");
INSERT INTO yor_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Olórí yóò jáde láti Jakọbu yóò sì pa àwọn tó ṣẹ́kù nínú ìlú náà run.” ");
INSERT INTO yor_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Nígbà náà ni Balaamu rí Amaleki ó sì bẹ̀rẹ̀ òwe: “Amaleki ni àkọ́kọ́ nínú àwọn orílẹ̀-èdè, ṣùgbọ́n yóò dahoro níkẹyìn.” ");
INSERT INTO yor_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Nígbà náà ní ó rí ará Keni ó sì bẹ̀rẹ̀ òwe: “Ibùgbé rẹ ní ààbò, ìtẹ́ rẹ ni a tò sínú àpáta; ");
INSERT INTO yor_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","síbẹ̀ ẹ̀yin ará Keni ni yóò di píparun nígbà tí Asiria bá mú yín ní ìgbèkùn.” ");
INSERT INTO yor_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Nígbà náà ni ó bẹ̀rẹ̀ òwe rẹ̀: “Háà, ta ni ó lè yè nígbà tí Ọlọ́run bá ṣe èyí? ");
INSERT INTO yor_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ọkọ̀ yóò wá láti ibùdókọ̀ Kittimu; wọn yóò ṣẹ́gun Asiria àti Eberi, ṣùgbọ́n àwọn náà yóò di píparun.” ");
INSERT INTO yor_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Nígbà náà ni Balaamu dìde ó sì padà sí ilé rẹ̀, Balaki sì lọ ní ọ̀nà tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Nígbà tí àwọn Israẹli dúró ní Ṣittimu, àwọn ènìyàn sì bẹ̀rẹ̀ sí í ṣe àgbèrè pẹ̀lú àwọn ọmọbìnrin Moabu, ");
INSERT INTO yor_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","tí ó pè wọ́n sí ibi ẹbọ òrìṣà wọn. Àwọn ènìyàn náà jẹun wọ́n sì foríbalẹ̀ níwájú òrìṣà wọn. ");
INSERT INTO yor_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Báyìí ni Israẹli ṣe darapọ̀ mọ́ wọn tí wọ́n sì jọ ń sin Baali-Peori. Ìbínú Olúwa sì ru sí wọn. ");
INSERT INTO yor_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Olúwa sọ fún Mose pé, “Mú gbogbo àwọn olórí àwọn ènìyàn wọ̀nyí, pa wọ́n kí o sì fi wọ́n kọ́ sórí igi ní gbangba nínú oòrùn níwájú Olúwa, kí ìbínú Olúwa lè kúrò ní ọ̀dọ̀ Israẹli.” ");
INSERT INTO yor_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Mose sọ fún àwọn onídàájọ́ Israẹli, “Ẹnìkọ̀ọ̀kan yín gbọdọ̀ pa arákùnrin rẹ̀ èyí tí ó darapọ̀ ní fífi orí balẹ̀ fún Baali-Peori.” ");
INSERT INTO yor_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Nítòótọ́ ọ̀kan lára àwọn ọmọkùnrin Israẹli sì mú obìnrin Midiani wá síwájú ojú Mose àti gbogbo ìjọ ti Israẹli wọ́n sì ń sọkún ní àbáwọlé àgọ́ ìpàdé. ");
INSERT INTO yor_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Nígbà tí Finehasi, ọmọ Eleasari, ọmọ Aaroni, àlùfáà, rí èyí, ó fi ìjọ sílẹ̀, pẹ̀lú ọ̀kọ̀ ní ọwọ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Ó sì tẹ̀lé arákùnrin Israẹli yìí lọ sínú àgọ́. Ó sì fi ọ̀kọ̀ gún àwọn méjèèjì ní àgúnyọ láti ara ọkùnrin Israẹli àti sí ara obìnrin náà. Nígbà náà ni àjàkálẹ̀-ààrùn lórí àwọn ọmọ Israẹli sì dúró; ");
INSERT INTO yor_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ṣùgbọ́n gbogbo àwọn tí ó kú nínú àjàkálẹ̀-ààrùn náà jẹ́ ẹgbàá méjìlá (24,000). ");
INSERT INTO yor_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Olúwa sì tún sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi ọmọ Eleasari ọmọ Aaroni, àlùfáà, ti yí ìbínú mi padà kúrò lọ́dọ̀ àwọn ọmọ Israẹli, nítorí tí ó ní ìtara bí èmi náà ti ní ìtara fún iyì mi láàrín wọn, kí ó lè jẹ́ pé èmi ló pa wọ́n run nínú ìtara mi sí wọn. ");
INSERT INTO yor_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Nítorí náà sọ fún un pé èmi ṣe májẹ̀mú àlàáfíà mi pẹ̀lú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Òun àti irú-ọmọ rẹ̀ yóò ní májẹ̀mú láéláé fún iṣẹ́ àlùfáà, nítorí pé ó ní ìtara fún Ọlọ́run rẹ̀ láti fi yẹ́ Ọlọ́run sí, ó sì ṣe ètùtù fún àwọn ọmọ Israẹli.” ");
INSERT INTO yor_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Orúkọ ọmọ Israẹli tí a pa pẹ̀lú obìnrin Midiani náà ni Simri, ọmọ Salu, olórí ilé kan nínú àwọn ọmọ Simeoni. ");
INSERT INTO yor_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Orúkọ ọmọbìnrin Midiani náà tí a pa ní Kosbi ọmọbìnrin Suri, tí ṣe olóyè àwọn ẹ̀yà kan nínú ìdílé kan ní Midiani. ");
INSERT INTO yor_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Olúwa sì tún sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Ka àwọn ará Midiani sí ọ̀tá, kí o sì pa wọ́n, ");
INSERT INTO yor_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","nítorí pé wọ́n ṣe sí yín gẹ́gẹ́ bí ọ̀tá nígbà tí wọ́n tàn yín nípa ìṣẹ̀lẹ̀ Peori, àti arábìnrin wọn Kosbi ọmọbìnrin ìjòyè Midiani kan, obìnrin tí a pa nígbà tí àjàkálẹ̀-ààrùn ṣẹlẹ̀ nítorí Peori.” ");
INSERT INTO yor_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Lẹ́yìn àjàkálẹ̀-ààrùn Olúwa sọ fún Mose àti Eleasari ọmọ Aaroni, àlùfáà pé, ");
INSERT INTO yor_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Ka iye gbogbo àwọn ọmọ Israẹli gẹ́gẹ́ bí ìdílé wọ́n; láti ẹni ogun ọdún àti jù bẹ́ẹ̀ lọ tí ó lè jà lójú ogun ní Israẹli.” ");
INSERT INTO yor_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Lórí pẹ̀tẹ́lẹ̀ ti Moabu pẹ̀lú Jordani tí ó kọjá Jeriko, Mose àti Eleasari àlùfáà sọ̀rọ̀ pẹ̀lú wọn ó wí pé, ");
INSERT INTO yor_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Ka iye àwọn ọkùnrin tí ó jẹ́ ọmọ-ogun ọdún tàbí jù bẹ́ẹ̀ lọ, gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose.” Èyí ni àwọn ọmọ Israẹli tí ó jáde láti Ejibiti wá. ");
INSERT INTO yor_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Àwọn ọmọ Reubeni, àkọ́bí ọmọkùnrin Israẹli, láti ẹni ti ìdílé Hanoku, láti ọ̀dọ̀ ẹni tí ìdílé Hanoku ti jáde wá, láti ìdílé Pallu, láti ọ̀dọ̀ ẹni tí ìdílé àwọn ọmọ Pallu ti jáde wá; ");
INSERT INTO yor_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ti Hesroni, ìdílé àwọn ọmọ Hesroni; ti Karmi, ìdílé àwọn ọmọ Karmi. ");
INSERT INTO yor_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Wọ̀nyí ni ìdílé àwọn ọmọ Reubeni; àwọn tí a sì kà nínú wọn jẹ́ ẹgbàá mọ́kànlélógún ó lé lẹ́gbẹ̀sán ó dín àádọ́rin (43,730). ");
INSERT INTO yor_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Àwọn ọmọkùnrin Pallu ni Eliabu, ");
INSERT INTO yor_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","àwọn ọmọkùnrin Elifelehu ni Nemueli àti Eliabu, Datani àti Abiramu. Èyí ni Datani àti Abiramu náà tí wọ́n ní òkìkí nínú ìjọ tí ó jẹ́ ọlọ̀tẹ̀ sí Mose àti Aaroni tí ó sì wà lára àwọn ẹgbẹ́ Kora nígbà tí wọ́n bá Olúwa jà. ");
INSERT INTO yor_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Ilẹ̀ sì la ẹnu rẹ̀, ó sì gbé wọn mì pọ̀ pẹ̀lú Kora, nígbà tí ẹgbẹ́ rẹ̀ kú níbi tí iná ti run àwọn àádọ́ta lé nígba (250) ọkùnrin. Tí wọ́n sì di àmì ìkìlọ̀. ");
INSERT INTO yor_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Àwọn ọmọ Kora, bí ó ti wù kí ó rí, wọn kò kú. ");
INSERT INTO yor_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Àwọn ọmọ ìran Simeoni bí ìdílé wọn: ti Nemueli, ìdílé Nemueli; ti Jamini, ìdílé Jamini; ti Jakini, ìdílé Jakini; ");
INSERT INTO yor_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ti Sera, ìdílé Sera; tí Saulu, ìdílé Saulu. ");
INSERT INTO yor_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Wọ̀nyí ni ìdílé àwọn ọmọ Simeoni, ẹgbẹ̀rún méjìlélógún ó lé igba (22,200) ọkùnrin. ");
INSERT INTO yor_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Àwọn ọmọ Gadi bí ìdílé wọn: ti Sefoni, ìdílé Sefoni; ti Haggi, ìdílé Haggi; ti Ṣuni, ìdílé Ṣuni; ");
INSERT INTO yor_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ti Osni, ìdílé Osni; ti Eri, ìdílé Eri; ");
INSERT INTO yor_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ti Arodi, ìdílé Arodi; ti Areli, ìdílé Areli. ");
INSERT INTO yor_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Wọ̀nyí ni àwọn ọmọ Gadi tí iye wọn sì jẹ́ ọ̀kẹ́ méjì ó lé lẹ̀ẹ́dẹ́gbẹ̀ta (40,500). ");
INSERT INTO yor_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Àwọn ọmọ Juda ni Eri àti Onani, ṣùgbọ́n Eri àti Onani kú ní ilẹ̀ Kenaani. ");
INSERT INTO yor_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Àti àwọn ọmọ Juda gẹ́gẹ́ bí ìdílé wọn: ti Ṣela, ìdílé Ṣela; ti Peresi, ìdílé Peresi; ti Sera, ìdílé Sera. ");
INSERT INTO yor_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Àwọn ọmọ Peresi: ti Hesroni, ìdílé Hesroni; ti Hamulu, ìdílé Hamulu. ");
INSERT INTO yor_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Wọ̀nyí ni ìdílé Juda; gẹ́gẹ́ bí àwọn tí a kà nínú wọn tí iye wọn sì jẹ́ ẹgbàá méjìdínlógójì ó lé lẹ̀ẹ́dẹ́gbẹ̀ta (76,500). ");
INSERT INTO yor_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Àwọn ọmọ Isakari gẹ́gẹ́ bí ìdílé wọn: ti Tola, ìdílé Tola; ti Pufa, ìdílé Pufa; ");
INSERT INTO yor_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ti Jaṣubu, ìdílé Jaṣubu; ti Ṣimroni, ìdílé Ṣimroni. ");
INSERT INTO yor_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Wọ̀nyí ni ìdílé Isakari gẹ́gẹ́ bí àwọn tí a kà nínú wọn tí iye wọn sì jẹ́ ẹgbàá méjìlélọ́gbọ̀n ó lé ọ̀ọ́dúnrún (64,300). ");
INSERT INTO yor_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Àwọn ọmọ Sebuluni gẹ́gẹ́ bí ìdílé wọn: ti Seredi, ìdílé Seredi; ti Eloni, ìdílé Eloni; ti Jaleeli, ìdílé Jaleeli. ");
INSERT INTO yor_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Wọ̀nyí ni ìdílé àwọn ọmọ Sebuluni gẹ́gẹ́ bí àwọn tí a kà nínú wọn tí iye wọn sì jẹ́ ọ̀kẹ́ mẹ́ta ó lé lẹ̀ẹ́dẹ́gbẹ̀ta (60,500). ");
INSERT INTO yor_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Àwọn ọmọ Josẹfu gẹ́gẹ́ bí ìdílé wọn; Manase àti Efraimu. ");
INSERT INTO yor_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Àwọn ọmọ Manase: ti Makiri, ìdílé Makiri (Makiri sì bí Gileadi); ti Gileadi, ìdílé àwọn ọmọ Gileadi. ");
INSERT INTO yor_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Wọ̀nyí ni àwọn ọmọ Gileadi: ti Ieseri, ìdílé Ieseri; ti Heleki, ìdílé Heleki ");
INSERT INTO yor_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","àti ti Asrieli, ìdílé Asrieli; àti ti Ṣekemu, ìdílé Ṣekemu; ");
INSERT INTO yor_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","àti Ṣemida, ìdílé àwọn ọmọ Ṣemida; àti ti Heferi, ìdílé àwọn ọmọ Heferi. ");
INSERT INTO yor_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Selofehadi ọmọ Heferi kò sì ni ọmọkùnrin, bí kò ṣe ọmọbìnrin; orúkọ àwọn ọmọbìnrin ni Mahila, Noa, àti Hogla, Milka àti Tirsa). ");
INSERT INTO yor_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Wọ̀nyí ni ìdílé Manase tí iye wọn sì jẹ́ ẹgbàá mẹ́rìndínlọ́gbọ̀n ó lé lẹ̀ẹ́dẹ́gbẹ̀rin (52,700). ");
INSERT INTO yor_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Wọ̀nyí ni àwọn ọmọ Efraimu gẹ́gẹ́ bí ìdílé wọn: láti ọ̀dọ̀ Ṣutelahi, ìdílé àwọn ọmọ Ṣutelahi; ti Bekeri, ìdílé àwọn ọmọ Bekeri; ti Tahani, ìdílé àwọn ọmọ Tahani. ");
INSERT INTO yor_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Wọ̀nyí ni àwọn ọmọ Ṣutelahi: ti Erani, ìdílé àwọn ọmọ Erani. ");
INSERT INTO yor_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Wọ̀nyí ni ìdílé àwọn ọmọ Efraimu, àwọn tí a kà nínú wọn sì jẹ́ ẹgbàá mẹ́rìndínlógún ó lé lẹ̀ẹ́dẹ́gbẹ̀ta (32,500). Wọ̀nyí ni àwọn ọmọ Josẹfu gẹ́gẹ́ bí ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Àwọn ọmọ Benjamini gẹ́gẹ́ bí ìdílé wọn nìyìí: tí Bela, ìdílé àwọn ọmọ Bela; ti Aṣbeli, ìdílé àwọn ọmọ Aṣbeli; ti Ahiramu, ìdílé àwọn ọmọ Ahiramu; ");
INSERT INTO yor_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ti Ṣufamu, ìdílé àwọn ọmọ Ṣufamu; ti Hufamu, ìdílé àwọn ọmọ Hufamu. ");
INSERT INTO yor_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Àwọn ọmọ Bela ní ipasẹ̀ Ardi àti Naamani nìyìí: ti Ardi, ìdílé àwọn ọmọ Ardi; ti Naamani, ìdílé àwọn ọmọ Naamani. ");
INSERT INTO yor_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Wọ̀nyí ni àwọn ọmọ Benjamini; gẹ́gẹ́ bí ìdílé wọn; àti àwọn tí a kà nínú wọn jẹ́ ẹgbàá méjìlélógún ó lé ẹgbẹ̀jọ (45,600). ");
INSERT INTO yor_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Wọ̀nyí ni àwọn ọmọ Dani gẹ́gẹ́ bí ìdílé wọn: ti Ṣuhamu, ìdílé àwọn ọmọ Ṣuhamu. Wọ̀nyí ni ìdílé Dani gẹ́gẹ́ bí ìdílé wọn. ");
INSERT INTO yor_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Gbogbo ìdílé àwọn ọmọ Ṣuhamu, gẹ́gẹ́ bí àwọn tí a kà nínú wọn jẹ́ ẹgbàá méjìlélọ́gbọ̀n ó lé irinwó (64,400). ");
INSERT INTO yor_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ti àwọn ọmọ Aṣeri gẹ́gẹ́ bí ìdílé wọn: ti Imina, ìdílé àwọn ọmọ Imina; ti Iṣfi, ìdílé àwọn ọmọ Iṣfi; ti Beriah, ìdílé àwọn ọmọ Berii. ");
INSERT INTO yor_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ti àwọn ọmọ Beriah: ti Heberi, ìdílé àwọn ọmọ Heberi; ti Malkieli, ìdílé àwọn ọmọ Malkieli. ");
INSERT INTO yor_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(Orúkọ ọmọ Aṣeri obìnrin nì jẹ́ Sera.) ");
INSERT INTO yor_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Wọ̀nyí ni ìdílé àwọn ọmọ Aṣeri gẹ́gẹ́ bí àwọn tí a kà nínú wọn jẹ́ ẹgbàá mẹ́rìndínlọ́gbọ̀n ó lé egbèje (53,400). ");
INSERT INTO yor_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ti àwọn ọmọ Naftali gẹ́gẹ́ bí ìdílé wọn: ti Jasieli, ìdílé àwọn ọmọ Jaseeli: ti Guni, ìdílé àwọn ọmọ Guni; ");
INSERT INTO yor_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ti Jeseri, ìdílé àwọn ọmọ Jeṣeri; ti Ṣillemu, ìdílé àwọn ọmọ Ṣillemu. ");
INSERT INTO yor_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Wọ̀nyí ni ìdílé ti Naftali gẹ́gẹ́ bí ìdílé wọn, àwọn tí a kà nínú wọn jẹ́ ẹgbàá méjìlélógún ó lé egbèje (45,400). ");
INSERT INTO yor_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Àpapọ̀ iye tí a kà nínú àwọn ọmọ Israẹli jẹ́ ọgbọ̀n ọ̀kẹ́ ó lé ẹgbẹ̀sán dín làádọ́rin (601,730). ");
INSERT INTO yor_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ilẹ̀ náà gbọdọ̀ jẹ́ pínpín fún wọn gẹ́gẹ́ bí ogún wọn gẹ́gẹ́ bí iye orúkọ wọn. ");
INSERT INTO yor_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Fún àwọn ọ̀pọ̀ ni kí ìwọ ó fún ní ogún ìlú púpọ̀ àti fún àwọn tí ó kéré ni kí ìwọ ó fi kékeré fún, ẹnìkọ̀ọ̀kan gbọdọ̀ gba ogún ìbí tirẹ̀ gẹ́gẹ́ bí ènìyàn tí a kọ. ");
INSERT INTO yor_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Rí dájú pé ilẹ̀ yìí gbọdọ̀ jẹ́ fífi ìbò pín gẹ́gẹ́ bí wọn sì ti pọ̀ tó. Gẹ́gẹ́ bí orúkọ ẹ̀yà àwọn baba wọn ni kí wọn kí ó ni í. ");
INSERT INTO yor_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Olúkúlùkù ogún ìní ni a gbọdọ̀ fi ìbò pín gẹ́gẹ́ bí wọ́n ti pọ̀ tó láàrín ńlá àti kékeré.” ");
INSERT INTO yor_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Wọ̀nyí ni àwọn ọmọ Lefi tí a kà nínú wọn gẹ́gẹ́ bí ìdílé wọn: ti Gerṣoni, ìdílé àwọn ọmọ Gerṣoni; ti Kohati, ìdílé àwọn ọmọ Kohati; ti Merari, ìdílé àwọn ọmọ Merari. ");
INSERT INTO yor_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Wọ̀nyí ni ìdílé àwọn ọmọ Lefi; ìdílé àwọn ọmọ Libni, ìdílé àwọn ọmọ Hebroni, ìdílé àwọn ọmọ Mahili, ìdílé àwọn ọmọ Muṣi, ìdílé àwọn ọmọ Kora. (Kohati ni baba Amramu, ");
INSERT INTO yor_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","orúkọ aya Amramu sì ń jẹ́ Jokebedi, ọmọbìnrin Lefi, tí ìyá rẹ̀ bí fún Lefi ní Ejibiti. Òun sì bí Aaroni, Mose, àti Miriamu arábìnrin wọn fún Amramu. ");
INSERT INTO yor_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaroni ni baba Nadabu àti Abihu, Eleasari àti Itamari. ");
INSERT INTO yor_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Ṣùgbọ́n Nadabu àti Abihu kú, nígbà tí wọ́n rú ẹbọ níwájú Olúwa nígbà tí wọ́n mú iná àjèjì wá.) ");
INSERT INTO yor_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Gbogbo àwọn ọmọkùnrin Lefi láti oṣù kan àti ju bẹ́ẹ̀ lọ ẹgbẹ̀rún méjìlélógún ó lé lẹ́gbẹ̀rún (23,000). Wọn kò ka wọ́n mọ́ àwọn ọmọ Israẹli tókù nítorí tí wọ́n kò gba ogún ìní lára wọn. ");
INSERT INTO yor_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Àwọn wọ̀nyí ni Mose àti Eleasari àlùfáà kà nígbà tí wọ́n ka àwọn ọmọ Israẹli ní pẹ̀tẹ́lẹ̀ Moabu lẹ́bàá odò Jordani létí Jeriko. ");
INSERT INTO yor_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Kò sí ẹnìkan nínú àwọn tí Mose àti Aaroni àlùfáà kà nígbà tí wọ́n ka àwọn ọmọ Israẹli ní aginjù Sinai. ");
INSERT INTO yor_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Nítorí Olúwa ti sọ fún àwọn ọmọ Israẹli pé kíkú ni wọn yóò kú sí aginjù, kò sì sí ẹnìkankan nínú wọn tí kò kú àfi Kalebu ọmọ Jefunne, àti Joṣua ọmọ Nuni. ");
INSERT INTO yor_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Ọmọbìnrin Selofehadi ọmọ Heferi, ọmọ Gileadi, ọmọ Makiri ọmọ Manase tó jẹ́ ìdílé Manase, ọmọ Josẹfu wá. Orúkọ àwọn ọmọbìnrin náà ni Mahila, Noa, Hogla, Milka àti Tirsa. ");
INSERT INTO yor_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Wọ́n súnmọ́ ẹnu-ọ̀nà àgọ́ ìpàdé wọ́n sì dúró níwájú Mose, àti Eleasari àlùfáà, àti níwájú àwọn olórí àti ìjọ, wọ́n sì wí pé, ");
INSERT INTO yor_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Baba wa kú sí aginjù. Kò sí lára àwọn ẹgbẹ́ Kora tí wọ́n kó ara wọn pọ̀ lòdì sí Olúwa, ṣùgbọ́n ó kú nítorí ẹ̀ṣẹ̀ rẹ̀ kò sì fi ọmọkùnrin sílẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Kín ni ó dé tí orúkọ baba wa yóò parẹ́ nínú ìdílé rẹ̀ nítorí pé kò ní ọmọkùnrin? Fún wa ní ilẹ̀ ìní láàrín àwọn arákùnrin baba wa.” ");
INSERT INTO yor_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Nígbà náà Mose mú ọ̀rọ̀ wọn wá síwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Olúwa sì wí fún un pé, ");
INSERT INTO yor_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Ohun tí àwọn ọmọbìnrin Selofehadi ń sọ tọ̀nà. O gbọdọ̀ fún wọn ní ogún ìní ti baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Sọ fún àwọn ọmọ Israẹli, ‘Tí ọkùnrin kan bá kú tí kò sì fi ọmọkùnrin sáyé, ẹ fún àwọn ọmọbìnrin rẹ̀ ní ogún ìní rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Tí kò bá ní ọmọbìnrin, fi ohun ìní rẹ́ fún àwọn arákùnrin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Tí kò bá ní arákùnrin, fi ogún ìní rẹ̀ fún arákùnrin baba rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Tí baba rẹ̀ kò bá ní arákùnrin, fún ará ilé rẹ̀ tí ó bá súnmọ́ jù ní ìdílé rẹ̀ ní ogún ìní rẹ̀, kí ó lè jogún rẹ̀. Èyí gbọdọ̀ jẹ́ ìlànà ìdájọ́ fún àwọn ọmọ Israẹli gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose.’ ” ");
INSERT INTO yor_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Nígbà náà Olúwa sọ fún Mose pé, “Lọ sì orí òkè Abarimu yìí, kí o sì lọ wo ilẹ̀ tí mo fún àwọn ọmọ Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Lẹ́yìn ìgbà tí o bá sì ti rí i, ìwọ náà yóò darapọ̀ mọ́ àwọn ènìyàn rẹ gẹ́gẹ́ bí Aaroni arákùnrin rẹ ṣe ṣe, ");
INSERT INTO yor_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","nítorí nígbà tí ìlú ṣọ̀tẹ̀ níbi omi ní aginjù Sini, tí gbogbo yín ṣe àìgbọ́ràn sí mi láti yà mí sí mímọ́ níwájú wọn.” (Èyí ni omi Meriba ní Kadeṣi ní aginjù Sini.) ");
INSERT INTO yor_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mose sọ fún Olúwa wí pé, ");
INSERT INTO yor_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Jẹ́ kí Olúwa, Ọlọ́run ẹ̀mí gbogbo ènìyàn, kí ó yan ọkùnrin kan sí orí ìjọ ènìyàn yìí, ");
INSERT INTO yor_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","láti máa darí wọn, ẹni tí yóò mú wọn jáde, tí yóò sì mú wọn wọlé, gbogbo ènìyàn Olúwa kí yóò dàbí àgùntàn tí kò ní olùṣọ́.” ");
INSERT INTO yor_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Nígbà náà ní Olúwa sọ fún Mose pé, “Mú Joṣua ọmọ Nuni, ọkùnrin nínú ẹni tí èmi wà, kí o sì gbé ọwọ́ rẹ lé e. ");
INSERT INTO yor_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Jẹ́ kí ó dúró níwájú Eleasari àlùfáà àti ojú gbogbo àwọn ìjọ ènìyàn Israẹli kí o sì fi àṣẹ fún un ní ojú wọn. ");
INSERT INTO yor_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Kí ìwọ kí ó sì fi nínú ọláńlá rẹ sí i lára, kí gbogbo ìjọ àwọn ọmọ Israẹli kí ó lè gbọ́rọ̀ sí i lẹ́nu. ");
INSERT INTO yor_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Kí ó dúró níwájú Eleasari àlùfáà, tí yóò gba ìpinnu fún láti béèrè Urimu níwájú Olúwa. Gẹ́gẹ́ bí òfin yìí ni òun pẹ̀lú gbogbo ìjọ ènìyàn Israẹli yóò jáde lọ, pẹ̀lú òfin rẹ̀ sì ni wọn ó wọlé.” ");
INSERT INTO yor_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mose sì ṣe gẹ́gẹ́ bí Olúwa ti sọ fún un. Ó mú Joṣua ó sì mú kí ó dúró níwájú Eleasari àlùfáà àti níwájú gbogbo ìjọ. ");
INSERT INTO yor_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Nígbà náà ni ó gbé ọwọ́ rẹ̀ le e, ó sì fi àṣẹ fún un gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Fún àwọn ọmọ Israẹli ní òfin yìí kí o sì wí fún wọn pé: ‘Ẹ rí i wí pé ẹ gbé e wá sí iwájú mi ní àkókò tí a ti yàn, oúnjẹ ọrẹ ẹbọ mi tí a fi iná ṣe sí mi, gẹ́gẹ́ bí òórùn dídùn sí mi.’ ");
INSERT INTO yor_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Sọ fún wọn, ‘Èyí ní ọrẹ ẹbọ tí a fi iná sun tí ẹ gbọdọ̀ mú wá fún Olúwa: akọ ọ̀dọ́-àgùntàn méjì ọlọ́dún kan aláìlábàwọ́n gẹ́gẹ́ bí ẹbọ sísun ní ojoojúmọ́. ");
INSERT INTO yor_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Pèsè ọ̀dọ́-àgùntàn kan ní òwúrọ̀ àti òmíràn ní àfẹ̀mọ́júmọ́. ");
INSERT INTO yor_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Pẹ̀lú ẹbọ ohun jíjẹ tí ó jẹ́ ìdámẹ́wàá efa ìyẹ̀fun dáradára tí a pò mọ́ ìdámẹ́rin hínì òróró tí a yọ lára Olifi. ");
INSERT INTO yor_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Èyí ni ẹbọ sísun gbogbo ìgbà tí a fi lélẹ̀ ní òkè Sinai gẹ́gẹ́ bí olóòórùn dídùn ẹbọ tí a fi iná sun fún Olúwa pẹ̀lú iná. ");
INSERT INTO yor_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Àfikún ọrẹ ohun mímu rẹ gbọdọ̀ jẹ́ ìdámẹ́rin ti hínì dídé omi mímu tí ó kan pẹ̀lú ọ̀kọ̀ọ̀kan ọ̀dọ́-àgùntàn. Da ẹbọ mímu náà síta sí Olúwa ní ibi mímọ́. ");
INSERT INTO yor_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Pèsè ọ̀dọ́-àgùntàn kejì ní àfẹ̀mọ́júmọ́, pẹ̀lú oríṣìí ẹbọ ohun jíjẹ àti ẹbọ ohun mímu èyí tí ó pèsè ní òwúrọ̀, èyí ni ẹbọ tí a fi iná ṣe, olóòórùn dídùn sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Ní ọjọ́ ìsinmi, pèsè akọ ọ̀dọ́-àgùntàn méjì ọlọ́dún kan tí kò lábùkù, pẹ̀lú ẹbọ ohun mímu àti ẹbọ ohun jíjẹ tí i ṣe ìdá méjì nínú ìdámẹ́wàá òsùwọ̀n ìyẹ̀fun tí a fi òróró pò. ");
INSERT INTO yor_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Èyí ni ẹbọ sísun fún gbogbo ọjọ́ ìsinmi kọ̀ọ̀kan, ní àfikún pẹ̀lú ẹbọ sísun àti ẹbọ ohun mímu. ");
INSERT INTO yor_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Àti ní ọjọ́ tí o bẹ̀rẹ̀ oṣù kọ̀ọ̀kan, kí ẹ̀yin kí ó gbé ẹbọ sísun fún Olúwa pẹ̀lú ọ̀dọ́ akọ màlúù méjì, àgbò kan àti akọ ọ̀dọ́-àgùntàn méje ọlọ́dún kọ̀ọ̀kan, kí gbogbo rẹ̀ sì jẹ́ aláìlábùkù. ");
INSERT INTO yor_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Pẹ̀lú akọ màlúù kọ̀ọ̀kan ni kí wọn ó rú ẹbọ ohun jíjẹ ẹbọ ìdámẹ́ta nínú mẹ́wàá ìyẹ̀fun tí a pòpọ̀ pẹ̀lú òróró; pẹ̀lú àgbò, ni kí wọn ó rú ẹbọ ohun jíjẹ tí í ṣe ìdá méjì nínú mẹ́wàá òsùwọ̀n ìyẹ̀fun tí a pòpọ̀ mọ́ òróró; ");
INSERT INTO yor_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","pẹ̀lú ọ̀kọ̀ọ̀kan ọ̀dọ́-àgùntàn, ni kí ẹ rú ẹbọ ìyẹ̀fun ìyẹ̀fun kíkúnná tí a pò mọ́ òróró. Èyí ni ẹbọ sísun, òórùn dídùn, àti ẹbọ tí a ṣe fún Olúwa pẹ̀lú iná. ");
INSERT INTO yor_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Kí ẹbọ ohun mímu wọn jẹ́ ààbọ̀ òsùwọ̀n hínì ti ọtí wáìnì, fún akọ màlúù kan, àti ìdámẹ́wàá òsùwọ̀n hínì fún àgbò kan àti ìdámẹ́rin òsùwọ̀n hínì fún ọ̀dọ́-àgùntàn kan. Èyí ni ẹbọ sísun tí wọn ó máa rú ní oṣù kọ̀ọ̀kan nínú ọdún. ");
INSERT INTO yor_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Yàtọ̀ sí ẹbọ sísun pẹ̀lú ẹbọ ohun mímu, ẹ gbọdọ̀ fi akọ ewúrẹ́ kọ̀ọ̀kan fún Olúwa gẹ́gẹ́ bí ẹbọ ẹ̀ṣẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Ní ọjọ́ kẹrìnlá oṣù kìn-ín-ní ni ìrékọjá Olúwa gbọdọ̀ wáyé. ");
INSERT INTO yor_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ní ọjọ́ kẹ́ẹ̀dógún oṣù yìí ẹ gbọdọ̀ ṣiṣẹ́ àjọ̀dún fún ọjọ́ méje kí ó jẹ àkàrà tí kò ní ìwúkàrà. ");
INSERT INTO yor_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Ní ọjọ́ kìn-ín-ní kí àpéjọ mímọ́ kí ó wà; ẹ́yin kò gbọdọ̀ ṣe iṣẹ́ agbára kankan. ");
INSERT INTO yor_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Ẹ rú ẹbọ sísun sí Olúwa, ẹ rú u pẹ̀lú ọ̀dọ́ màlúù méjì akọ, ẹbọ sísun pẹ̀lú iná àgbò kan àti ọ̀dọ́-àgùntàn méje ọlọ́dún kọ̀ọ̀kan kí wọn kí ó jẹ́ aláìlábùkù. ");
INSERT INTO yor_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Pẹ̀lú akọ màlúù kọ̀ọ̀kan ni kí ẹ pèsè ẹbọ ohun mímu pẹ̀lú ìdámẹ́ta nínú mẹ́wàá ìyẹ̀fun kíkúnná tí a fi òróró pò; pẹ̀lú àgbò, ìdá méjì nínú mẹ́wàá; ");
INSERT INTO yor_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","pẹ̀lú ọ̀dọ́-àgùntàn kọ̀ọ̀kan ìdákan nínú mẹ́wàá. ");
INSERT INTO yor_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Pẹ̀lú òbúkọ kan fún ẹbọ ẹ̀ṣẹ̀ láti ṣètùtù fún un yín. ");
INSERT INTO yor_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ṣe eléyìí ní àfikún sí ẹbọ sísun àràárọ̀. ");
INSERT INTO yor_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Báyìí ní kí ẹ̀yin rúbọ ní ọjọọjọ́, jálẹ̀ ní ọjọ́ méjèèje, oúnjẹ ẹbọ tí a fi iná ṣe, tí olóòórùn dídùn sí Olúwa; ó rú u pẹ̀lú ẹbọ sísun ìgbà gbogbo, àti ẹbọ ohun mímu. ");
INSERT INTO yor_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Ní ọjọ́ keje kí ẹ̀yin kí ó ní àpéjọ mímọ́, ẹ kò sì gbọdọ̀ ṣe iṣẹ́ kankan. ");
INSERT INTO yor_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Ní ọjọ́ àkọ́so pẹ̀lú, nígbà tí ẹ̀yin bá mú ẹbọ ohun jíjẹ tuntun wá fún Olúwa lẹ́yìn àsìkò àjọ̀dún, kí ẹ̀yin kí ó ní àpéjọ mímọ́, ẹ̀yin kò gbọdọ̀ ṣe iṣẹ́ kankan. ");
INSERT INTO yor_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Kí ẹ mú ẹbọ sísun ẹgbọrọ màlúù méjì, àgbò kan àti akọ ọ̀dọ́-àgùntàn méje ọlọ́dún kan gẹ́gẹ́ bí òórùn dídùn fún Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Pẹ̀lú ọ̀kọ̀ọ̀kan akọ màlúù ní kí ẹ rú ẹbọ ohun mímu ìdámẹ́ta pẹ̀lú òsùwọ̀n ìyẹ̀fun kíkúnná tí a fi òróró pò pẹ̀lú àgbò kan. ");
INSERT INTO yor_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Àti pẹ̀lú ọ̀kọ̀ọ̀kan ọ̀dọ́-àgùntàn méje, kí ó jẹ́ ìdákan nínú mẹ́wàá. ");
INSERT INTO yor_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Ẹ fi òbúkọ kan ṣe ètùtù fún ara yín. ");
INSERT INTO yor_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Kí ẹ̀yin kí ó rú wọn pẹ̀lú ẹbọ sísun ìgbà gbogbo, àti ẹbọ ohun mímu yín àti ẹbọ ohun jíjẹ yín. Kí ẹ sì ri dájú pé àwọn ẹranko náà jẹ́ aláìlábùkù. ");
INSERT INTO yor_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Ní ọjọ́ kìn-ín-ní, oṣù keje, kí ẹ ní àpéjọ mímọ́, ẹ kò gbọdọ̀ ṣe iṣẹ́ kankan. Ọjọ́ ìfùnpè ni ó jẹ́ fún yín. ");
INSERT INTO yor_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Gẹ́gẹ́ bí òórùn dídùn sí Olúwa, ẹ pèsè ẹgbọrọ akọ màlúù kan, àgbò kan àti akọ ọ̀dọ́-àgùntàn ọlọ́dún kan aláìlábùkù, kí ẹ fi ẹbọ sísun. ");
INSERT INTO yor_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Pẹ̀lú ẹbọ ohun jíjẹ wọn, ìyẹ̀fun kíkúnná tí a fi òróró pò, ìdámẹ́ta nínú mẹ́wàá òsùwọ̀n fún akọ màlúù kan, àti ìdá méjì nínú mẹ́wàá, òsùwọ̀n fún àgbò kan, ");
INSERT INTO yor_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","àti ìdámẹ́wàá òsùwọ̀n fún ọ̀dọ́-àgùntàn kan, àti fún ọ̀dọ́-àgùntàn méje. ");
INSERT INTO yor_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Àti òbúkọ kan fún ẹbọ ẹ̀ṣẹ̀ láti ṣètùtù fún yín. ");
INSERT INTO yor_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Pẹ̀lú ẹbọ sísun oṣù àti ẹbọ ohun jíjẹ rẹ̀ àti ẹbọ sísun ìgbà gbogbo àti ẹbọ mímu wọn gẹ́gẹ́ bí ìlànà wọn. Fún òórùn dídùn, ẹbọ tí a fi iná ṣe sí Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Ní ọjọ́ kẹwàá nínú oṣù keje, kí ẹ ṣe àpéjọ mímọ́. Kí ẹ̀yin kí ó sẹ́ ara yín, ẹ kò sì gbọdọ̀ ṣe iṣẹ́ kankan. ");
INSERT INTO yor_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Kí ẹ̀yin kí ó rú ẹbọ sísun olóòórùn dídùn sí Olúwa, ẹgbọrọ akọ màlúù kan, àgbò kan, àti akọ ọ̀dọ́-àgùntàn méje ọlọ́dún kan, kí wọn kí ó sì jẹ́ aláìlábùkù fún yín. ");
INSERT INTO yor_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Pẹ̀lú akọ màlúù, pèsè ọrẹ ìdámẹ́wàá mẹ́ta, òsùwọ̀n ìyẹ̀fun tí a fi òróró pò àti ìdámẹ́wàá méjì òsùwọ̀n fún àgbò kan, ");
INSERT INTO yor_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","àti fún ọ̀dọ́-àgùntàn kọ̀ọ̀kan, ìdámẹ́wàá òsùwọ̀n. ");
INSERT INTO yor_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Pẹ̀lú akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀, pẹ̀lú ẹbọ ẹ̀ṣẹ̀ fún ètùtù àti ẹbọ sísun gbogbo ìgbà àti ẹbọ jíjẹ rẹ̀ àti ẹbọ mímu wọn. ");
INSERT INTO yor_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Ní ọjọ́ kẹ́ẹ̀dógún oṣù keje, kí ẹ̀yin kí ó ní àpéjọ mímọ́, ẹ̀yin kò sì gbọdọ̀ ṣe iṣẹ́ kankan. Kí ẹ̀yin kí ó sì ṣe àjọyọ̀ fún Olúwa fún ọjọ́ méje. ");
INSERT INTO yor_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Kí ẹ sì rú ẹbọ sísun kan, ẹbọ tí a fi iná ṣe, tí ó ní òórùn dídùn sí Olúwa, ẹbọ tí ẹgbọrọ akọ màlúù mẹ́tàlá, àgbò méjì àti akọ ọ̀dọ́-àgùntàn mẹ́rìnlá tí ó jẹ́ ọdún kan, tí gbogbo rẹ̀ sì jẹ́ aláìlábùkù. ");
INSERT INTO yor_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Àti ẹbọ ohun jíjẹ wọn, ìyẹ̀fun tí a fi òróró pò, ìdámẹ́wàá mẹ́ta òsùwọ̀n fún akọ màlúù kan, bẹ́ẹ̀ ni fún akọ màlúù mẹ́tẹ̀ẹ̀tàlá, ìdámẹ́wàá méjì òsùwọ̀n fún àgbò kan, bẹ́ẹ̀ ni fún àgbò méjèèjì, ");
INSERT INTO yor_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","àti fún ọ̀kọ̀ọ̀kan ọ̀dọ́-àgùntàn kan. Bẹ́ẹ̀ ni fún ọ̀dọ́-àgùntàn mẹ́rẹ̀ẹ̀rìnlá. ");
INSERT INTO yor_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Àti akọ ewúrẹ́ kan gẹ́gẹ́ bí ẹbọ ẹ̀ṣẹ̀, pẹ̀lú ẹbọ sísun gbogbo ìgbà ẹbọ ohun jíjẹ àti ẹbọ ohun mímu rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Àti ní ọjọ́ kejì ni kí ẹ̀yin kí ó fi ẹgbọrọ akọ màlúù méjìlá, àgbò méjì àti ọ̀dọ́-àgùntàn mẹ́rìnlá ọlọ́dún kan aláìlábùkù rú ẹbọ. ");
INSERT INTO yor_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Pẹ̀lú fún akọ màlúù, fún àgbò, àti fún ọ̀dọ́-àgùntàn kí ẹ pe ẹbọ ohun jíjẹ, àti ẹbọ ohun mímu, kí ó jẹ́ bí iye wọn, gẹ́gẹ́ bí ìlànà. ");
INSERT INTO yor_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Àti òbúkọ fún ẹbọ ẹ̀ṣẹ̀ pẹ̀lú ẹbọ sísun gbogbo ìgbà pẹ̀lú ẹbọ jíjẹ àti ẹbọ ohun mímu. ");
INSERT INTO yor_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Ní ọjọ́ kẹta, pèsè akọ màlúù mọ́kànlá, àgbò méjì, akọ àgùntàn mẹ́rìnlá ti ọdún kan tí kò ní àbùkù. ");
INSERT INTO yor_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Pẹ̀lú akọ màlúù, àgbò, àti akọ àgùntàn, pèsè ọrẹ ohun jíjẹ àti ohun mímu gẹ́gẹ́ bí iye wọn. ");
INSERT INTO yor_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Pẹ̀lú akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀, àti ẹbọ sísun ìgbà gbogbo pẹ̀lú ẹbọ jíjẹ àti ẹbọ mímu. ");
INSERT INTO yor_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Ní ọjọ́ kẹrin, pèsè akọ màlúù mẹ́wàá, àgbò méjì, àti ọ̀dọ́-àgùntàn mẹ́rìnlá ti ọlọ́dún kọ̀ọ̀kan tí kò ní àbùkù. ");
INSERT INTO yor_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Àti akọ màlúù, àgbò àti àgùntàn, pèsè ẹbọ jíjẹ àti ẹbọ mímu gẹ́gẹ́ bí iye wọn, gẹ́gẹ́ bí ìlànà. ");
INSERT INTO yor_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Àti akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀ pẹ̀lú ẹbọ sísun gbogbo ìgbà, pẹ̀lú ẹbọ jíjẹ àti ẹbọ ohun mímu. ");
INSERT INTO yor_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Àti ní ọjọ́ karùn-ún, pèsè akọ màlúù mẹ́sàn-án, àgbò méjì àti akọ ọ̀dọ́-àgùntàn mẹ́rìnlá ti ọlọ́dún kọ̀ọ̀kan, tí gbogbo rẹ̀ kò ní àbùkù. ");
INSERT INTO yor_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Pẹ̀lú akọ màlúù, àgbò àti ọ̀dọ́-àgùntàn, pèsè ẹbọ ohun jíjẹ àti ẹbọ ohun mímu gẹ́gẹ́ bí iye wọn sí ìlànà. ");
INSERT INTO yor_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Àti akọ ewúrẹ́ kan gẹ́gẹ́ bí ẹbọ ẹ̀ṣẹ̀ pẹ̀lú ẹbọ sísun ìgbà gbogbo pẹ̀lú ẹbọ ohun jíjẹ àti ẹbọ ohun mímu. ");
INSERT INTO yor_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Ní ọjọ́ kẹfà, pèsè akọ màlúù mẹ́jọ, àgbò ọlọ́dún kan tí gbogbo rẹ̀ kò ní àbùkù. ");
INSERT INTO yor_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Pẹ̀lú akọ màlúù, àgbò, àti ọ̀dọ́-àgùntàn, pèsè ẹbọ ohun jíjẹ àti ẹbọ ohun mímu gẹ́gẹ́ bí iye wọn. ");
INSERT INTO yor_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Pẹ̀lú akọ ewúrẹ́ kan gẹ́gẹ́ bí ẹbọ ẹ̀ṣẹ̀, pẹ̀lú ẹbọ sísun gbogbo ìgbà pẹ̀lú ẹbọ ohun jíjẹ àti ẹbọ ohun mímu. ");
INSERT INTO yor_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Àti ní ọjọ́ keje, pèsè akọ màlúù méje, àgbò méjì, àti akọ ọ̀dọ́-àgùntàn mẹ́rìnlá ti ọlọ́dún kan, tí gbogbo rẹ̀ kò sì ní àbùkù. ");
INSERT INTO yor_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Pẹ̀lú akọ màlúù, àgbò, àti ọ̀dọ́-àgùntàn, pèsè ẹbọ ohun jíjẹ àti ẹbọ ohun mímu fún wọn gẹ́gẹ́ bí iye wọn. ");
INSERT INTO yor_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Pẹ̀lú akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀, pẹ̀lú ẹbọ sísun gbogbo ìgbà, pẹ̀lú ẹbọ ohun jíjẹ àti ẹbọ ohun mímu. ");
INSERT INTO yor_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Àti ní ọjọ́ kẹjọ kí ẹ̀yin kó ní àpéjọ, kí ẹ má sì ṣe iṣẹ́ kankan. ");
INSERT INTO yor_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Kí ẹ̀yin ṣe ìgbékalẹ̀ ẹbọ tí a fi iná ṣe tí ó ní òórùn dídùn sí Olúwa, ẹbọ sísun ti akọ màlúù kan, àgbò ọlọ́dún kan àti ọ̀dọ́-àgùntàn ọlọ́dún kan méje, gbogbo rẹ̀ tí kò ní àbùkù. ");
INSERT INTO yor_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Pẹ̀lú akọ màlúù, àgbò, àti ọ̀dọ́-àgùntàn, pèsè fún wọn ẹbọ ohun jíjẹ àti ẹbọ ohun mímu gẹ́gẹ́ bí iye wọn. ");
INSERT INTO yor_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Àti akọ ewúrẹ́ kan fún ẹbọ ẹ̀ṣẹ̀ pẹ̀lú ẹbọ sísun gbogbo ìgbà àti ẹbọ ohun jíjẹ àti ẹbọ ohun mímu. ");
INSERT INTO yor_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Pẹ̀lú ẹ̀jẹ́ yín, àti ẹbọ àtinúwá yín, kí ẹ̀yin kí o pèsè fún Olúwa ní àjọ̀dún tí a yàn yín, ẹbọ sísun, ẹbọ ohun jíjẹ, ẹbọ ohun mímu àti ẹbọ ìkẹ́gbẹ́ yín.’ ” ");
INSERT INTO yor_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Mose sì sọ fún àwọn ọmọ Israẹli gbogbo ohun tí Olúwa ti pàṣẹ fún un. ");
INSERT INTO yor_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mose sì sọ fún olórí àwọn ẹ̀yà ọmọ Israẹli pé, “Èyí ni ohun tí Olúwa pàṣẹ, ");
INSERT INTO yor_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","nígbà tí ọkùnrin kan bá jẹ́ ẹ̀jẹ́ sí Olúwa tàbí búra láti fi de ara rẹ̀ ní ìdè kí òun má bà ba ọ̀rọ̀ rẹ̀ jẹ́ kí ó ṣe gẹ́gẹ́ bí ó ti ṣe sọ. ");
INSERT INTO yor_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Nígbà tí ọmọbìnrin kan bá sì wà ní ilé baba rẹ̀ tó bá jẹ́ ẹ̀jẹ́ fún Olúwa tàbí búra láti fi de ara rẹ̀ ");
INSERT INTO yor_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","tí baba rẹ̀ bá sì gbọ́ ẹ̀jẹ́ rẹ̀ tàbí ìdè rẹ̀ tí kò sì sọ nǹkan kan sí i, kí gbogbo ẹ̀jẹ́ rẹ̀ kí ó dúró àti gbogbo ìdè tí ó fi de ara rẹ̀ yóò sì dúró. ");
INSERT INTO yor_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Ṣùgbọ́n tí baba rẹ̀ bá kọ̀ fun un ní ọjọ́ tí ó gbọ́, kò sí ọ̀kan nínú ẹ̀jẹ́ rẹ̀ tàbí nínú ìdè tí ó fi de ara rẹ̀ tí yóò dúró; Olúwa yóò sì tú u sílẹ̀ nítorí baba rẹ̀ kọ̀ fún un. ");
INSERT INTO yor_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Tí ó bá sì ní ọkọ lẹ́yìn ìgbà tí ó jẹ́ ẹ̀jẹ́ tàbí lẹ́yìn ìgbà tí ó sọ ọ̀rọ̀ kan láti ẹnu rẹ̀ jáde nínú èyí tí ó fi de ara rẹ̀ ní ìdè, ");
INSERT INTO yor_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","tí ọkọ rẹ̀ sì gbọ́ nípa èyí ṣùgbọ́n tí kò sọ nǹkan kan, nígbà náà ni ẹ̀jẹ́ tàbí ìdè tí ó fi de ara rẹ̀ tó dúró. ");
INSERT INTO yor_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ṣùgbọ́n tí ọkọ rẹ̀ bá kọ̀ nígbà tí ó gbọ́, ǹjẹ́ òun yóò mú ẹ̀jẹ́ rẹ̀ tí ó jẹ́ àti ohun tí ó ti ti ẹnu rẹ̀ jáde, èyí tí ó fi de ara rẹ̀ dasán, Olúwa yóò sì dáríjì í. ");
INSERT INTO yor_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Ṣùgbọ́n ẹ̀jẹ́ kí ẹ̀jẹ́ tàbí ìdè kí ìdè tí opó tàbí obìnrin tí a kọ̀sílẹ̀ bá ṣe yóò wà lórí rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Bí obìnrin tí ó ń gbé pẹ̀lú ọkọ rẹ̀ bá jẹ́ ẹ̀jẹ́ tàbí de ara rẹ̀ ní ìdè lábẹ́ ìbúra, ");
INSERT INTO yor_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","tí ọkọ rẹ̀ bá sì gbọ́, ṣùgbọ́n tí kò sọ̀rọ̀, tí kò sì kọ̀, nígbà náà ni ẹ̀jẹ́ rẹ̀ yóò dúró. ");
INSERT INTO yor_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ṣùgbọ́n tí ọkọ rẹ̀ bá sọ wọ́n dasán, nígbà tí ó gbọ́, nígbà náà kò sí ẹ̀jẹ́ tàbí ìdè tí ó ti ẹnu rẹ̀ jáde tí yóò dúró, ọkọ rẹ̀ ti sọ wọ́n dasán, Olúwa yóò tú u sílẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ọkọ rẹ̀ lè ṣe ìwádìí tàbí sọ ọ́ dasán ẹ̀jẹ́ tàbí ìbúra ìdè tí ó ti ṣe láti fi de ara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ṣùgbọ́n tí ọkọ rẹ̀ kò bá sọ nǹkan kan sí í nípa rẹ̀ ní ọjọ́ dé ọjọ́, nígbà náà ni ó ṣe ìwádìí nípa ẹ̀jẹ́ àti ìbúra ìdè tí ó dè é. Kí ọkùnrin náà ṣe ìwádìí lórí rẹ̀ láìsọ nípa rẹ̀ si nígbà tí ó gbọ́ nípa rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Bí ó ti wù kí ó rí, bí ọkùnrin náà bá sọ ọ́ dasán, ní àkókò kan lẹ́yìn tí ó ti gbọ́ wọn, nígbà náà ó jẹ̀bi ọ̀rọ̀ náà.” ");
INSERT INTO yor_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Èyí ni ìlànà tí Olúwa fún Mose nípa ìbátan láàrín ọkùnrin àti obìnrin àti láàrín baba àti ọ̀dọ́mọbìnrin rẹ̀ tí ó sì ń gbé ní ilé rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Gbẹ̀san lára àwọn Midiani fún àwọn ọmọ Israẹli. Lẹ́yìn ìgbà náà a ó kó ọ jọ pẹ̀lú àwọn ènìyàn rẹ.” ");
INSERT INTO yor_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mose sì sọ fún àwọn ènìyàn pé, “Ẹ wọ ogun fún àwọn kan nínú yín láti lọ da ojú ìjà kọ àwọn ọmọ Midiani láti gba ẹ̀san Olúwa lára wọn. ");
INSERT INTO yor_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Rán ẹgbẹ̀rún (1,000) ọmọ-ogun láti ẹ̀yà kọ̀ọ̀kan ní Israẹli.” ");
INSERT INTO yor_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Bẹ́ẹ̀ ni wọ́n sì yan nínú àwọn ẹgbẹẹgbẹ̀rún ènìyàn Israẹli, ẹgbẹ̀rún (1,000) ènìyàn láti inú ẹ̀yà kọ̀ọ̀kan, ẹgbàá mẹ́fà (12,000) ènìyàn tí ó wọ ìhámọ́ra ogun. ");
INSERT INTO yor_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mose rán wọn lọ sí ogun, ẹgbẹ̀rún (1,000) láti ẹ̀yà kọ̀ọ̀kan pẹ̀lú Finehasi ọmọ Eleasari, ti ó jẹ́ àlùfáà, ti òun ti ohun èlò ibi mímọ́ àti ìpè wọ̀n-ọn-nì ní ọwọ́ rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Wọ́n dojú ìjà kọ Midiani gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose, kí wọn sì pa gbogbo wọn. ");
INSERT INTO yor_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Wọ́n sì pa àwọn ọba Midiani pẹ̀lú: àwọn ìyókù tí wọ́n pa lára wọn ni Efi, Rekemu, Suri àti Huri, àti Reba: ọba Midiani márùn-ún, wọ́n sì fi idà pa Balaamu ọmọ Beori. ");
INSERT INTO yor_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Àwọn ọmọ Israẹli sì mú gbogbo obìnrin Midiani ní ìgbèkùn àti àwọn ọmọ kékeré wọn, wọ́n sì kó gbogbo ohun ọ̀sìn wọn àti gbogbo agbo ẹran wọn àti gbogbo ẹrù wọn. ");
INSERT INTO yor_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Wọ́n finá jó gbogbo ìlú wọn àti ibùdó wọn. ");
INSERT INTO yor_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Wọ́n sì kó gbogbo ìní wọn, àti ènìyàn àti ẹran. ");
INSERT INTO yor_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Wọ́n sì kó gbogbo ohun tí wọ́n bàjẹ́ àti ènìyàn àti ẹran wá sọ́dọ̀ Mose àti Eleasari àlùfáà, àti sọ́dọ̀ ìjọ àwọn ọmọ Israẹli ní ibùdó àgọ́ ní pẹ̀tẹ́lẹ̀ Moabu tí ń bẹ lẹ́gbẹ̀ẹ́ Jordani létí Jeriko. ");
INSERT INTO yor_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mose, Eleasari àlùfáà àti gbogbo olórí ìgbèríko lọ láti lọ bá wọn ní ìta ibùdó. ");
INSERT INTO yor_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Inú bí Mose sí àwọn olórí ọmọ-ogun, pẹ̀lú àwọn olórí ẹgbẹẹgbẹ̀rún àti olórí ọ̀rọ̀ọ̀rún tí wọ́n ti ogun dé. ");
INSERT INTO yor_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Mose sì béèrè wí pé, “Ẹ̀yin ha dá gbogbo àwọn obìnrin sí bí? ");
INSERT INTO yor_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Àwọn ni wọ́n tẹ̀lé ìmọ̀ràn Balaamu, àwọn ní ó ṣe okùnfà yíyí àwọn ọ̀mọ̀ Israẹli padà kúrò ní ọ̀dọ̀ Olúwa nínú èyí tí ó ṣẹlẹ̀ ní Peori, níbi tí àjàkálẹ̀-ààrùn ti kọlu ìjọ Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Nísinsin yìí, pa gbogbo ọ̀dọ́mọkùnrin àti àwọn obìnrin tí ó ti súnmọ́ ọkùnrin, ");
INSERT INTO yor_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ṣùgbọ́n kí o dá obìnrin tí kò bá tí ì súnmọ́ ọkùnrin sí fún ara yín. ");
INSERT INTO yor_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Ẹnikẹ́ni tí ó bá ti pa ènìyàn tàbí fọwọ́ kan ẹni tí a pa gbọdọ̀ dúró ní ìta ibùdó àgọ́ fún ọjọ́ méje. Ní ọjọ́ kẹta àti ọjọ́ keje ẹ gbọdọ̀ ya ara yín àti ẹni tí ẹ kó lẹ́rú sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Kí ẹ̀yin kí ó ya aṣọ yín sí mímọ́ àti gbogbo ohun tí a fi awọ ṣe àti gbogbo iṣẹ́ irun ewúrẹ́ àti ohun tí a fi igi ṣe.” ");
INSERT INTO yor_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eleasari àlùfáà sì wí fún àwọn olórí ogun náà pé, “Èyí ní ìlànà òfin tí Olúwa fi lélẹ̀ ní àṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Kìkì i wúrà, fàdákà, idẹ, irin, idẹ àti òjé. ");
INSERT INTO yor_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","Ohunkóhun tí ó lè la iná ni kí ẹ̀yin ó mú la iná, nígbà náà ni yóò jẹ́ mímọ́. Ṣùgbọ́n ẹ yóò fi omi ìyàsímímọ́ sọ ọ́ di mímọ́. Àti gbogbo ohun tí kò lè la iná kọjá ni kí a mú la inú omi. ");
INSERT INTO yor_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ní ọjọ́ keje, ẹ fọ aṣọ yín, ẹ̀yin yóò sì mọ́, nígbà náà ní ẹ̀yin yóò lè wọ inú ibùdó àjọ.” ");
INSERT INTO yor_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Ìwọ àti Eleasari àlùfáà àti àwọn olórí ilé baba ìjọ ni kí o ka iye àwọn ènìyàn àti ẹranko tí a kó ní ìgbèkùn. ");
INSERT INTO yor_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Pín ohun ìní àti ìkógun náà láàrín àwọn ọmọ-ogun náà tí ó kópa nínú ogun náà àti láàrín gbogbo ìjọ. ");
INSERT INTO yor_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Kí o sì gba ìdá ti Olúwa lọ́wọ́ àwọn ológun tí wọn jáde lọ sí ogun náà, ọ̀kan nínú ẹ̀ẹ́dẹ́gbẹ̀ta (500) nínú àwọn ènìyàn àti nínú màlúù àti nínú kẹ́tẹ́kẹ́tẹ́, àti nínú agbo ẹran. ");
INSERT INTO yor_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Gba ìdá yìí lára ààbọ̀ ìpín tiwọn, kí o sì fún Eleasari àlùfáà, fún ẹbọ ìgbésókè Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Lára ààbọ̀ ti Israẹli, yan ọ̀kan kúrò nínú àádọ́ta, yálà ènìyàn, ẹran ọ̀sìn, kẹ́tẹ́kẹ́tẹ́, àgùntàn, ewúrẹ́ tàbí ẹ̀yà ẹranko mìíràn. Kó wọn fún àwọn Lefi, tí ó dúró fún olùtọ́jú àgọ́ Olúwa.” ");
INSERT INTO yor_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Nígbà náà Mose àti Eleasari àlùfáà ṣe gẹ́gẹ́ bí Olúwa ti pàṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Èrè tí ó kù lára ìkógun tí àwọn ọmọ-ogun kó jẹ́, ọ̀kẹ́ mẹ́rìnlélọ́gbọ̀n ó dín ẹgbẹ̀ẹ́dọ́gbọ̀n (675,000) àgùntàn. ");
INSERT INTO yor_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Ẹgbàá méjìléláàádọ́rin (72,000) màlúù ");
INSERT INTO yor_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ọ̀kẹ́ mẹ́ta ó lé ẹgbẹ̀rin (61,000) kẹ́tẹ́kẹ́tẹ́, ");
INSERT INTO yor_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","pẹ̀lú obìnrin ẹgbàá mẹ́rìndínlógún (32,000), ni kò ní ìbálòpọ̀ pẹ̀lú ọkùnrin rí. ");
INSERT INTO yor_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ìpín ààbọ̀ àwọn tí ó jáde lọ sí ogun sì jẹ́: ẹgbàá méjìdínláàádọ́sàn-án ó lé lẹ̀ẹ́dẹ́gbẹ̀jọ (337,500) àgùntàn. ");
INSERT INTO yor_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Tí ìdá ti Olúwa sì jẹ́ ẹ̀ẹ́dẹ́gbẹ̀rin ó dín mẹ́ẹ̀ẹ́dọ́gbọ̀n (675) àgùntàn; ");
INSERT INTO yor_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ẹgbọrọ màlúù jẹ́ ẹgbàá méjìdínlógún (36,000), tí ìdá Olúwa sì jẹ́ méjìléláàádọ́rin (72); ");
INSERT INTO yor_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","kẹ́tẹ́kẹ́tẹ́ sì jẹ́ ẹgbàá mẹ́ẹ̀ẹ́dógún ó lé lẹ̀ẹ́dẹ́gbẹ̀ta (30,500), tí ìdá ti Olúwa sì jẹ́ mọ́kànlélọ́gọ́ta (61). ");
INSERT INTO yor_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Àwọn ènìyàn sì jẹ́ ẹgbàá mẹ́jọ (16,000) ìdá ti Olúwa sì jẹ́ méjìlélọ́gbọ̀n (32). ");
INSERT INTO yor_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mose fi ìdá náà fún Eleasari, àlùfáà gẹ́gẹ́ bí ìdá ti Olúwa, gẹ́gẹ́ bí Olúwa ti pa á láṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ààbọ̀ tí ó jẹ́ ti àwọn ọmọ Israẹli, tí Mose yà sọ́tọ̀ kúrò lára àwọn ọkùnrin tí ó ja ogun. ");
INSERT INTO yor_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Ààbọ̀ tí ìjọ jẹ́ ẹgbàá méjìdínláàádọ́sàn-án ó lé lẹ̀ẹ́dẹ́gbẹ̀jọ (337,500) àgùntàn, ");
INSERT INTO yor_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","pẹ̀lú ẹgbàá méjìdínlógún (36,000) màlúù ");
INSERT INTO yor_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","tí kẹ́tẹ́kẹ́tẹ́ sì jẹ́ ẹgbàá mẹ́ẹ̀ẹ́dógún ó lé lẹ̀ẹ́dẹ́gbẹ̀ta (30,500). ");
INSERT INTO yor_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","Àwọn ènìyàn sì jẹ́ ẹgbàá mẹ́jọ (16,000). ");
INSERT INTO yor_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Lára ààbọ̀ ti àwọn ọmọ Israẹli, Mose yan ọ̀kan lára àádọ́ta ènìyàn àti ẹranko gẹ́gẹ́ bí Olúwa ti pa á láṣẹ fún un. Ó sì fi wọ́n fún àwọn ọmọ Lefi, tí ń ṣe olùtọ́jú àgọ́ Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Pẹ̀lú àwọn olórí tí ó wà lórí ẹgbẹẹgbẹ̀rin ogun náà, àti àwọn balógun ọ̀rọ̀ọ̀rún wá sọ́dọ̀ Mose. ");
INSERT INTO yor_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Wọ́n sì sọ fún un pé, “Ìránṣẹ́ rẹ ti ka àwọn ọmọ-ogun náà tí ó wà lábẹ́ ìtọ́jú wa, kò sì sí ọ̀kọ̀ọ̀kan tó dín. ");
INSERT INTO yor_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Nítorí náà làwa ṣe mú ọrẹ ẹbọ wá fún Olúwa, gbogbo ọrẹ wíwà tí a ní, wúrà, ẹ̀wọ̀n, àti júfù, àti òrùka-àmi, àti òrùka etí, àti ìlẹ̀kẹ̀ láti fi ṣe ètùtù fún ọkàn an wa níwájú Olúwa.” ");
INSERT INTO yor_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mose àti Eleasari àlùfáà, gba wúrà náà lọ́wọ́ wọn pẹ̀lú gbogbo ohun iṣẹ́ ọ̀ṣọ́. ");
INSERT INTO yor_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Gbogbo wúrà tí àwọn balógun ẹgbẹẹgbẹ̀rún àti àwọn balógun ọ̀rọ̀ọ̀rún mú wá fún Mose àti Eleasari, èyí tí ó jẹ́ ẹbọ ìgbésókè fún Olúwa jẹ́ ẹgbàá mẹ́jọ ó lé lẹ̀ẹ́dẹ́gbẹ̀rin ó lé àádọ́ta (16,750) ṣékélì. ");
INSERT INTO yor_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Nítorí ológun kọ̀ọ̀kan ti kó ẹrù fún ara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mose àti Eleasari àlùfáà gba wúrà náà lọ́wọ́ àwọn balógun ẹgbẹẹgbẹ̀rún àti lọ́wọ́ balógun ọ̀rọ̀ọ̀rún wọ́n sì ko wá sínú àgọ́ ìpàdé fún ìrántí àwọn Israẹli níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Àwọn ọmọ Reubeni àti àwọn ọmọ Gadi, tí wọ́n ní ẹran ọ̀sìn àti ohun ọ̀sìn rí wí pé ilẹ̀ Jaseri àti Gileadi dára fún ohun ọ̀sìn. ");
INSERT INTO yor_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Àwọn ọmọ Gadi àti àwọn ọmọ Reubeni sì wá, wọ́n wá sí ọ̀dọ̀ Mose àti Eleasari àlùfáà àti sí olórí gbogbo ìlú, wọ́n sì wí pé, ");
INSERT INTO yor_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarotu, Diboni, Jaseri, Nimra, Heṣboni, Eleale, Sebamu, Nebo, àti Beoni. ");
INSERT INTO yor_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Ni ilẹ̀ tí Olúwa ti ṣẹ́gun níwájú ìjọ Israẹli tí ó sì dára fún ohun ọ̀sìn, ṣáwọn ìránṣẹ́ rẹ̀ sì ní ohun ọ̀sìn.” ");
INSERT INTO yor_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Wọ́n wí pé, “Tí a bá rí ojúrere rẹ, jẹ́ kí a fi ilẹ̀ yìí fún ìránṣẹ́ rẹ gẹ́gẹ́ bí ìní. Má ṣe jẹ́ kí a rékọjá odò Jordani.” ");
INSERT INTO yor_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mose sọ fún àwọn ọmọ Gadi àti fún ọmọ Reubeni pé, “Ṣé kí àwọn arákùnrin yín lọ sí ogun, kí ẹ̀yin kí ó sì jókòó sí bí? ");
INSERT INTO yor_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Kí ni ó dé tí o fi mú ìrẹ̀wẹ̀sì bá àwọn ọmọ Israẹli láti lọ sí ibi ilẹ̀ tí Olúwa ti fi fún wọn? ");
INSERT INTO yor_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Èyí ni nǹkan tí baba yín ṣe nígbà tí mo rán wọn láti Kadeṣi-Barnea láti lọ wo ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Lẹ́yìn ìgbà tí wọ́n lọ sí àfonífojì Eṣkolu tí wọ́n rí ilẹ̀ náà, wọ́n mú ìrẹ̀wẹ̀sì bá àwọn ọmọ Israẹli láti wọ ilẹ̀ tí Olúwa ti fi fún wọn. ");
INSERT INTO yor_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Ìbínú Olúwa sì dìde sí wọn ní ọjọ́ náà, ó sì búra, wí pé, ");
INSERT INTO yor_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Nítorí wọn kò tẹ̀lé mi tọkàntọkàn, kì í ṣe ọ̀kan nínú àwọn ọkùnrin náà tí ó jẹ́ ogún ọdún tàbí jù bẹ́ẹ̀ lọ tí ó gòkè láti Ejibiti ni yóò rí ilẹ̀ tí mo pinnu gẹ́gẹ́ bí ìbúra fún Abrahamu, fún Isaaki àti fún Jakọbu: ");
INSERT INTO yor_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","kò sí ẹnìkankan àyàfi Kalebu ọmọ Jefunne ti Kenissiti àti Joṣua ọmọ Nuni, nítorí wọ́n tẹ̀lé Olúwa tọkàntọkàn.’ ");
INSERT INTO yor_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Ìbínú Olúwa ru sí àwọn ọmọ Israẹli ó sì mú wọn rìn ní aginjù fún ogójì ọdún, títí tí àwọn ìran tí wọ́n ṣe búburú ní ojú rẹ̀ fi lọ. ");
INSERT INTO yor_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Níbí ni ẹ̀yin wà, ẹ̀yin ẹlẹ́ṣẹ̀, ẹ̀yin dìde ní ipò baba yín, ẹ sì jẹ́ kí ìbínú gbígbóná Olúwa ru sí Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Tí ẹ̀yin bá yípadà ní ẹ̀yìn rẹ̀ yóò sì fi àwọn ènìyàn wọ̀nyí sílẹ̀ ní aginjù, ìwọ yóò sì mú un ṣe ìparun.” ");
INSERT INTO yor_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Nígbà náà wọ́n wá sí òkè ní ọ̀dọ̀ rẹ̀, “Àwa yóò fẹ́ láti kọ́ ilé ẹran níhìn-ín yìí fún ohun ọ̀sìn wa, àti ìlú fún àwọn obìnrin àti ọmọ wẹ́wẹ́ wa. ");
INSERT INTO yor_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Ṣùgbọ́n àwa ṣetán láti dira ogun ṣáájú àwọn ọmọ Israẹli títí tí a yóò fi mú wọn dé ọ̀dọ̀ wọn lákokò yìí, àwọn obìnrin àti ọmọ wẹ́wẹ́ wa yóò gbé inú ìlú tí a mọ odi sí fún ìdáàbòbò wọn lọ́wọ́ olùgbé ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","A kì yóò padà sí ilẹ̀ wa láìṣe pé gbogbo àwọn ọmọ Israẹli ti gba ogún wọn. ");
INSERT INTO yor_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","A kì yóò gba ogún kankan pẹ̀lú wọn ní òdìkejì Jordani, nítorí ogún ti wa, ti wá sí ọ̀dọ̀ wa ní ìhà ìlà-oòrùn Jordani.” ");
INSERT INTO yor_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Nígbà náà ni Mose sọ fún wọn pé, “Tí ẹ̀yin yóò bá pa ara yín lára, níwájú Olúwa fún ogún. ");
INSERT INTO yor_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Bí gbogbo yín yóò bá lọ sí Jordani ní ìhámọ́ra níwájú Olúwa, títí yóò fi lé àwọn ọ̀tá rẹ̀ kúrò níwájú rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","Tí a ó sì fi ṣe ilẹ̀ náà níwájú Olúwa; ẹ̀yin lè padà tí yóò sì di òmìnira lọ́wọ́ ìdè níwájú Olúwa àti Israẹli. Ilẹ̀ yìí yóò sì jẹ́ tiyín níwájú Olúwa. ");
INSERT INTO yor_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Ṣùgbọ́n tí ẹ̀yin bá kọ̀ láti ṣe èyí, ẹ̀yin yóò máa dẹ́ṣẹ̀ sí Olúwa; kí ẹ̀yin kí ó sì mọ̀ dájú pé ẹ̀ṣẹ̀ yín yóò fi yín hàn. ");
INSERT INTO yor_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Ẹ kọ́ ilé fún àwọn obìnrin yín àti ọmọ wẹ́wẹ́ yín, àti ilé fún agbo ẹran yín, ṣùgbọ́n kí ẹ̀yin kí ó ṣe ohun tí ẹ ti pinnu.” ");
INSERT INTO yor_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Àwọn ọmọ Gadi àti ọmọ Reubeni sọ fún Mose pé, “Àwa ìránṣẹ́ rẹ yóò ṣe gẹ́gẹ́ bí olúwa wa ti pàṣẹ. ");
INSERT INTO yor_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Àwọn ọmọ wa àti ìyàwó wa, àwọn agbo ẹran àti ohun ọ̀sìn wa yóò dúró ní ìlú Gileadi. ");
INSERT INTO yor_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Ṣùgbọ́n àwọn ìránṣẹ́ rẹ, gbogbo ọkùnrin tí ó wọ ìhámọ́ra ogun, yóò rékọjá lọ láti jà níwájú Olúwa; gẹ́gẹ́ bí olúwa wa ti sọ.” ");
INSERT INTO yor_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Nígbà náà ni Mose pàṣẹ nípa wọn fún Eleasari àlùfáà àti Joṣua ọmọ Nuni àti sí gbogbo olórí ìdílé ẹ̀yà Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Mose sì wí fún wọn pé, “Tí àwọn ọmọ Gadi àti ọmọ Reubeni, gbogbo ọkùnrin tí ó wọ ìhámọ́ra fún ogun rékọjá odò Jordani pẹ̀lú níwájú Olúwa, nígbà tí ẹ ṣẹ́gun ilẹ̀ náà níwájú yín, fún wọn ní ilẹ̀ Gileadi gẹ́gẹ́ bí ìní wọn. ");
INSERT INTO yor_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ṣùgbọ́n tí wọn kò bá fẹ́ bá yín rékọjá pẹ̀lú ìhámọ́ra, wọn gbọdọ̀ gba ìní wọn pẹ̀lú yín ní Kenaani.” ");
INSERT INTO yor_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Àwọn ọmọ Gadi àti ọmọ Reubeni dáhùn pé, “Ìránṣẹ́ rẹ yóò ṣe ohun tí Olúwa ti sọ. ");
INSERT INTO yor_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","A máa rékọjá níwájú Olúwa lọ sí Kenaani pẹ̀lú ìhámọ́ra, ṣùgbọ́n ẹrù tí a jogún yóò wà ní ẹ̀bá Jordani.” ");
INSERT INTO yor_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Nígbà náà Mose fún àwọn ọmọ Gadi àti àwọn ọmọ Reubeni àti ààbọ̀ ẹ̀yà Manase ọmọ Josẹfu ní ilẹ̀ ọba Sihoni ọba àwọn ọmọ Amori àti ilẹ̀ ọba Ogu ọba Baṣani ní gbogbo ilẹ̀ náà pẹ̀lú ìlú rẹ̀ àti agbègbè tí ó yí i ka. ");
INSERT INTO yor_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Àwọn ará Gadi wọ́n kọ́ Diboni, Atarotu, Aroeri; ");
INSERT INTO yor_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","pẹ̀lú Atrotu Ṣofani, Jaseri, àti Jogbeha, ");
INSERT INTO yor_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","pẹ̀lú Beti-Nimra, àti Beti-Harani ìlú olódi, àti agbo fún àgùntàn. ");
INSERT INTO yor_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Àwọn ọmọ Reubeni sì kọ́ Heṣboni, Eleale, Kiriataimu, ");
INSERT INTO yor_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","pẹ̀lú Nebo pẹ̀lú Baali-Meoni (wọ́n pàrọ̀ orúkọ wọn) àti Sibma. Wọ́n sì sọ ìlú tí wọ́n tún kọ́ ní orúkọ mìíràn. ");
INSERT INTO yor_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Àwọn ọmọ Makiri ọmọ Manase lọ sí Gileadi, wọ́n sì lé àwọn ọmọ Amori tí ó wà níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Mose sì fi àwọn ọmọ Gileadi fún àwọn ọmọ Makiri àwọn ìran Manase, wọ́n sì tẹ̀dó síbẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jairi, ọmọ Manase gba ibùjókòó wọn, ó sì pè wọ́n ní Haffotu Jairi. ");
INSERT INTO yor_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba gba Kenati àti àwọn ìtẹ̀dó rẹ̀, ó sì pè é ní Noba lẹ́yìn orúkọ ara rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Wọ̀nyí ni ìrìnàjò àwọn ọmọ Israẹli ní ẹsẹẹsẹ, nígbà tí wọ́n tí ilẹ̀ Ejibiti jáde wá pẹ̀lú àwọn ogun wọn, nípa ọwọ́ Mose àti Aaroni. ");
INSERT INTO yor_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Mose sì kọ̀wé ìjáde lọ wọn ní ẹsẹẹsẹ gẹ́gẹ́ bí ìrìnàjò wọn, nípa àṣẹ Olúwa, wọ̀nyí sì ni ìrìnàjò wọn gẹ́gẹ́ bí ìjáde lọ wọn. ");
INSERT INTO yor_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Àwọn ọmọ Israẹli jáde kúrò láti Ramesesi ní ọjọ́ kẹ́ẹ̀dógún oṣù kìn-ín-ní, ọjọ́ kan lẹ́yìn àjọ ìrékọjá. Wọ́n yan jáde pẹ̀lú ìgboyà níwájú gbogbo àwọn ará Ejibiti. ");
INSERT INTO yor_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Tí wọ́n sì ń sin gbogbo àkọ́bí wọn, ẹni tí Olúwa ti gbé lulẹ̀ láàrín wọn; nítorí tí Olúwa ti mú ẹ̀san wá sórí àwọn òrìṣà wọn. ");
INSERT INTO yor_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Àwọn ọmọ Israẹli kúrò ní Ramesesi wọ́n sì pàgọ́ sí Sukkoti. ");
INSERT INTO yor_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Wọ́n kúrò ní Sukkoti, wọ́n sì pàgọ́ sí Etamu, ní ẹ̀bá aginjù. ");
INSERT INTO yor_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Wọ́n kúrò ní Etamu, wọ́n padà sí Pi-Hahirotu sí ìlà-oòrùn Baali-Ṣefoni, wọ́n sì pàgọ́ sí ẹ̀bá Migdoli. ");
INSERT INTO yor_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Wọ́n sì dìde láti lọ kúrò ní iwájú Pi-Hahirotu, wọ́n sì la àárín òkun kọjá lọ sí aginjù. Wọ́n sì rin ìrìn ọjọ́ mẹ́ta ní aginjù Etamu, wọ́n sì pàgọ́ sí Mara. ");
INSERT INTO yor_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Wọ́n kúrò ní Mara wọ́n sì lọ sí Elimu, níbi tí orísun omi méjìlá àti igi ọ̀pẹ àádọ́rin gbé wà, wọ́n sì pàgọ́ níbẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Wọ́n kúrò ní Elimu wọ́n sì pàgọ́ sí ẹ̀bá Òkun Pupa. ");
INSERT INTO yor_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Wọ́n kúrò ní ẹ̀bá Òkun Pupa wọ́n sì pàgọ́ sínú aginjù Sini. ");
INSERT INTO yor_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Wọ́n kúrò nínú aginjù Sini wọ́n sì pàgọ́ sí aginjù Dofka. ");
INSERT INTO yor_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Wọ́n kúrò ní Dofka wọ́n sì pàgọ́ ní Aluṣi. ");
INSERT INTO yor_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Wọ́n kúrò ní Aluṣi wọ́n sì pàgọ́ ní Refidimu níbi tí kò sí omi fún àwọn ènìyàn náà láti mu. ");
INSERT INTO yor_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Wọ́n kúrò ní Refidimu wọ́n sì pàgọ́ ní aginjù Sinai. ");
INSERT INTO yor_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Wọ́n kúrò ní aginjù Sinai wọ́n sì pàgọ́ ní Kibirotu-Hattaafa. ");
INSERT INTO yor_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Wọ́n kúrò ní Kibirotu-Hattaafa wọ́n sì pàgọ́ ní Haserotu. ");
INSERT INTO yor_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Wọ́n kúrò ní Haserotu wọ́n sì pàgọ́ ní Ritma. ");
INSERT INTO yor_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Wọ́n kúrò ní Ritma wọ́n sì pàgọ́ ní Rimoni-Peresi. ");
INSERT INTO yor_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Wọ́n kúrò ní Rimoni-Peresi wọ́n sì pàgọ́ ní Libina. ");
INSERT INTO yor_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Wọ́n kúrò ní Libina wọ́n sì pàgọ́ ní Rissa. ");
INSERT INTO yor_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Wọ́n kúrò ní Rissa wọ́n sì pàgọ́ ní Kehelata. ");
INSERT INTO yor_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Wọ́n kúrò ní Kehelata wọ́n sì pàgọ́ ní orí òkè Ṣeferi. ");
INSERT INTO yor_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Wọ́n kúrò lórí òkè Ṣeferi wọ́n sì pàgọ́ ní Harada. ");
INSERT INTO yor_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Wọ́n kúrò ní Harada wọ́n sì pàgọ́ ní Makhelotu. ");
INSERT INTO yor_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Wọ́n kúrò ní Makhelotu wọ́n sì pàgọ́ ní Tahati. ");
INSERT INTO yor_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Wọ́n kúrò ní Tahati wọ́n sì pàgọ́ ní Tẹra. ");
INSERT INTO yor_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Wọ́n kúrò ní Tẹra wọ́n sì pàgọ́ ní Mitka. ");
INSERT INTO yor_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Wọ́n kúrò ní Mitka wọ́n pàgọ́ ní Haṣmona. ");
INSERT INTO yor_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Wọ́n kúrò ní Haṣmona wọ́n sì pàgọ́ ní Moserotu. ");
INSERT INTO yor_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Wọ́n kúrò ní Moserotu wọ́n sì pàgọ́ ní Bene-Jaakani. ");
INSERT INTO yor_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Wọ́n kúrò ní Bene-Jaakani wọ́n sì pàgọ́ ní Hori-Haggidgadi. ");
INSERT INTO yor_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Wọ́n kúrò ní Hori-Haggidgadi wọ́n sí pàgọ́ ní Jotbata. ");
INSERT INTO yor_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Wọ́n kúrò ní Jotbata wọ́n sì pàgọ́ ní Abrona. ");
INSERT INTO yor_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Wọ́n kúrò ní Abrona wọ́n sì pàgọ́ ní Esioni-Geberi. ");
INSERT INTO yor_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Wọ́n kúrò ní Esioni-Geberi wọ́n sì pàgọ́ ní Kadeṣi nínú aginjù Sini. ");
INSERT INTO yor_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Wọ́n kúrò ní Kadeṣi wọ́n sì pàgọ́ ní orí òkè Hori, lẹ́bàá Edomu. ");
INSERT INTO yor_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Nípa àṣẹ Olúwa, Aaroni àlùfáà gùn orí òkè Hori, níbẹ̀ ni ó kú. Ní ọjọ́ kìn-ín-ní oṣù karùn-ún, ọdún ogójì, lẹ́yìn tí àwọn ọmọ Israẹli ti ilẹ̀ Ejibiti jáde wá. ");
INSERT INTO yor_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaroni jẹ́ ẹni ọgọ́fà ọdún ó lé mẹ́ta (123) ní ìgbà tí ó kú sí orí òkè Hori. ");
INSERT INTO yor_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Àwọn ará Kenaani, ọba Aradi, tí ń gbé ìhà gúúsù ní ilẹ̀ Kenaani gbọ́ pé àwọn ọmọ Israẹli ń bọ̀. ");
INSERT INTO yor_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Wọ́n kúrò ní orí òkè Hori, wọ́n sì pàgọ́ ní Salmona. ");
INSERT INTO yor_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Wọ́n kúrò ní Salmona wọ́n sì pàgọ́ ní Punoni. ");
INSERT INTO yor_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Wọ́n kúrò ní Punoni wọ́n sì pàgọ́ ní Obotu. ");
INSERT INTO yor_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Wọ́n kúrò ní Obotu wọ́n sì pàgọ́ ní Iye-Abarimu, ní agbègbè Moabu. ");
INSERT INTO yor_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Wọ́n kúrò ní Iyimu, wọ́n sì pàgọ́ ní Diboni-Gadi. ");
INSERT INTO yor_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Wọ́n kúrò ní Diboni-Gadi wọ́n sì pàgọ́ ní Alimon-Diblataimu. ");
INSERT INTO yor_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Wọ́n kúrò ní Alimon-Diblataimu wọ́n sì pàgọ́ sí orí òkè Abarimu lẹ́bàá Nebo. ");
INSERT INTO yor_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Wọ́n kúrò ní orí òkè Abarimu wọ́n sì pàgọ́ ní pẹ̀tẹ́lẹ̀ Moabu lẹ́bàá Jordani ní ìkọjá Jeriko. ");
INSERT INTO yor_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Níbí ní pẹ̀tẹ́lẹ̀ Moabu wọ́n pàgọ́ lẹ́gbẹ́ Jordani láti Beti-Jeṣimoti títí dé Abeli-Ṣittimu. ");
INSERT INTO yor_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Ní pẹ̀tẹ́lẹ̀ Moabu, lẹ́bàá Jordani, létí Jeriko, Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Sọ fún àwọn ọmọ Israẹli kí o sì wí fún wọn pé, ‘Ní ìgbà tí ẹ̀yin bá ń rékọjá odò Jordani lọ sí Kenaani, ");
INSERT INTO yor_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","lé gbogbo àwọn ará ilẹ̀ náà kúrò níwájú yín. Run gbogbo àwòrán ère wọn àti gbogbo ère dídá wọn, kí ẹ sì wó gbogbo ibi gíga wọn palẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Ẹ gba ilẹ̀ náà, kí ẹ̀yin sì máa gbé inú rẹ̀, nítorí èmi ti fi ilẹ̀ náà fún yín gẹ́gẹ́ bí ìní yín. ");
INSERT INTO yor_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Ẹ̀yin pín ilẹ̀ náà pẹ̀lú kèké, gẹ́gẹ́ bí ìdílé yín. Fún ọ̀pọ̀ ni kí ẹ̀yin ó fi ilẹ̀ ìní púpọ̀ fún, àti fún díẹ̀, ni kí ẹ̀yin kí ó fi ilẹ̀ ìní díẹ̀ fún. Ohunkóhun tí ó bá bọ́ sí ọ̀dọ̀ wọn nípa kèké yóò jẹ́ tiwọn. Pín wọn gẹ́gẹ́ bí ẹ̀yà ìran wọn. ");
INSERT INTO yor_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘Ṣùgbọ́n bí ẹ kò bá lé àwọn ará ilẹ̀ náà kúrò níwájú yín, àwọn tí ẹ bá jẹ́ kí ó kù yóò di ọfà nínú ojú yín, àti ẹ̀gún ní ìhà yín. Wọn yóò fún yín ní wàhálà ní ilẹ̀ náà tí ẹ̀yin yóò gbé. ");
INSERT INTO yor_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Nígbà náà, èmi yóò ṣe sí yín, ohun tí mo ti rò láti ṣe sí wọn.’ ” ");
INSERT INTO yor_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Pàṣẹ fún àwọn ọmọ Israẹli, kí o sì sọ fún wọn pé, ‘Tí ẹ bá wọ Kenaani, ilẹ̀ tí a ó fi fún yín, gẹ́gẹ́ bí ogún yín yóò ní ààlà wọn yí: ");
INSERT INTO yor_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Ìhà gúúsù yín yóò bọ́ sí ara aginjù Sini lẹ́bàá Edomu, àti ìlà-oòrùn, ààlà ìhà gúúsù yóò bẹ̀rẹ̀ láti òpin Òkun Iyọ̀, ");
INSERT INTO yor_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","kọjá lọ sí gúúsù Akrabbimu, tẹ̀síwájú lọ si Sini, kó bọ́ si gúúsù Kadeṣi-Barnea, kí o sì dé Hasari-Addari, kí o sì kọjá sí Asmoni. ");
INSERT INTO yor_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Kí òpin ilẹ̀ rẹ̀ kí ó sì yíká láti Asmoni lọ dé odò Ejibiti, Òkun Ńlá ni yóò sì jẹ òpin rẹ. ");
INSERT INTO yor_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Ìhà ìwọ̀-oòrùn yín yóò jẹ́ òpin lórí Òkun Ńlá. Èyí yóò jẹ́ ààlà yín lórí ìhà ìwọ̀-oòrùn. ");
INSERT INTO yor_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Fún ààlà ìhà àríwá, fa ìlà láti Òkun Ńlá lọ sí orí òkè Hori, ");
INSERT INTO yor_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","àti láti orí òkè Hori sí Lebo-Hamati. Nígbà náà ààlà náà yóò lọ sí Sedadi, ");
INSERT INTO yor_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","tẹ̀síwájú lọ sí Sifroni, kí o sì fò pín si ní Hasari-Enani, èyí yóò jẹ́ ààlà tìrẹ ní ìhà àríwá. ");
INSERT INTO yor_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Kí ẹ sì sàmì sí ilẹ̀ tiyín ní ìhà ìlà-oòrùn láti Hasari-Enani lọ dé Ṣefamu. ");
INSERT INTO yor_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Ààlà náà yóò ti Ṣefamu sọ̀kalẹ̀ wá lọ sí Ribla ní ìhà ìlà-oòrùn Aini, kí o sì sọ̀kalẹ̀ lọ dé ìhà Òkun Kinnereti ní ìhà ìlà-oòrùn. ");
INSERT INTO yor_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Nígbà náà, ààlà náà yóò sọ̀kalẹ̀ lọ sí apá Jordani, yóò sì dópin nínú Òkun Iyọ̀. “ ‘Èyí yóò jẹ́ ilẹ̀ yín, pẹ̀lú ààlà tirẹ̀ ní gbogbo ọ̀nà.’ ” ");
INSERT INTO yor_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Mose pa á láṣẹ fún àwọn ọmọ Israẹli pé, “Yan ilẹ̀ yìí pẹ̀lú kèké gẹ́gẹ́ bí ìní ogún: Olúwa ti pàṣẹ láti fi fún ẹ̀yà mẹ́sàn-án, àti ààbọ̀. ");
INSERT INTO yor_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Nítorí ará ilẹ̀ ẹ̀yà ti Reubeni, ẹ̀yà Gadi àti ẹ̀yà ààbọ̀ ti Manase ti gba ogún tiwọn. ");
INSERT INTO yor_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Ẹ̀yà méjèèjì àti ààbọ̀ yìí ti gba ogún tiwọn ní ìhà ìhín Jordani létí i Jeriko, ní ìhà ìlà-oòrùn, ní ìdojúkọ Jordani.” ");
INSERT INTO yor_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Èyí ni orúkọ àwọn ọkùnrin náà tí yóò pín ilẹ̀, náà fún yín gẹ́gẹ́ bí ogún: Eleasari àlùfáà àti Joṣua ọmọ Nuni. ");
INSERT INTO yor_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Kí o sì yan olórí kan nínú ẹ̀yà kọ̀ọ̀kan láti pín ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Èyí ni orúkọ wọn: “Kalebu ọmọ Jefunne, láti ẹ̀yà Juda; ");
INSERT INTO yor_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Ṣemueli ọmọ Ammihudu, láti ẹ̀yà Simeoni; ");
INSERT INTO yor_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Elidadi ọmọ Kisloni, láti ẹ̀yà Benjamini; ");
INSERT INTO yor_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Bukki ọmọ Jogli, láti ẹ̀yà olórí àwọn ọmọ Dani; ");
INSERT INTO yor_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Hannieli ọmọ Efodu, láti ẹ̀yà Manase, olórí àwọn ọmọ Josẹfu, ");
INSERT INTO yor_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kemueli ọmọ Ṣiftani, olórí ẹ̀yà àwọn ọmọ, Efraimu, ọmọ Josẹfu; ");
INSERT INTO yor_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Elisafani ọmọ Parnaki, olórí ẹ̀yà àwọn ọmọ Sebuluni; ");
INSERT INTO yor_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Paltieli ọmọ Assani, olórí ẹ̀yà àwọn ọmọ Isakari; ");
INSERT INTO yor_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ahihudu ọmọ Ṣelomi, olórí ẹ̀yà àwọn ọmọ Aṣeri; ");
INSERT INTO yor_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Pedaheli ọmọ Ammihudu, olórí ẹ̀yà àwọn ọmọ Naftali.” ");
INSERT INTO yor_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Èyí ni àwọn ẹni tí Olúwa yàn láti pín ogún náà fún àwọn ọmọ Israẹli ní ilẹ̀ Kenaani. ");
INSERT INTO yor_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Lórí pẹ̀tẹ́lẹ̀ Moabu ní Jordani tí ó rékọjá láti Jeriko, Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Pàṣẹ fún àwọn ọmọ Israẹli láti fún àwọn Lefi ní ilẹ̀ láti gbé lára ogún tí àwọn ọmọ Israẹli yóò jogún. Kí ẹ sì fún wọn ní ilẹ̀ lára pápá oko tútù, káàkiri ìlú. ");
INSERT INTO yor_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Nígbà náà, wọn yóò ní ìlú tí wọn yóò gbé àti ilẹ̀ pápá oko tútù fún ẹran ọ̀sìn, ọ̀wọ́ ẹran pẹ̀lú gbogbo ìní wọn. ");
INSERT INTO yor_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Ilẹ̀ pápá oko tútù káàkiri ìlú tí ẹ ó fi fún àwọn ọmọ Lefi, wíwọ̀n rẹ̀ yóò jẹ́ ẹgbẹ̀rún ìgbọ̀nwọ́ (1,500 ẹsẹ̀ bàtà) láti ògiri ìlú náà. ");
INSERT INTO yor_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Lẹ́yìn ìlú náà, wọn ẹgbẹ̀rún méjì (2,000) ìgbọ̀nwọ́ lápá ibi ìhà ìlà-oòrùn, ẹgbẹ̀rún méjì (2,000) ẹsẹ̀ bàtà ní ìhà gúúsù, ẹgbẹ̀rún méjì (2,000) ní ìhà ìwọ̀-oòrùn àti ẹgbẹ̀rún méjì (2,000) ní ìhà àríwá, kí ìlú náà sì wà ní àárín. Wọn yóò ní agbègbè yìí gẹ́gẹ́ bí ilẹ̀ pápá oko tútù fún ìlú náà. ");
INSERT INTO yor_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Mẹ́fà lára ìlú tí ẹ fún àwọn ọmọ Lefi yóò jẹ́ ìlú ààbò, tí ẹni tí ó bá pa ènìyàn yóò sá sí. Ní àfikún, ẹ fún wọn ní méjìlélógójì ìlú sí i. ");
INSERT INTO yor_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Ní gbogbo rẹ̀, kí ẹ fún àwọn ọmọ Lefi ní méjìdínláàádọ́ta ìlú lápapọ̀ pẹ̀lú ilẹ̀ pápá oko tútù wọn. ");
INSERT INTO yor_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Ìlú tí ẹ fún àwọn ọmọ Lefi láti ara ilẹ̀ tí àwọn ọmọ Israẹli jogún, olúkúlùkù kí ó fi nínú ìlú rẹ̀ fún àwọn ọmọ Lefi gẹ́gẹ́ bí ilẹ̀ ìní rẹ̀ tí ó ní. Gba púpọ̀ lọ́wọ́ ẹ̀yà tí ó ní púpọ̀ àti díẹ̀ lọ́wọ́ ẹ̀yà tí ó ní díẹ̀.” ");
INSERT INTO yor_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Nígbà náà ni Olúwa sọ fún Mose pé, ");
INSERT INTO yor_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Sọ̀rọ̀ sí àwọn ọmọ Israẹli, kí o sì sọ fún wọn: ‘Nígbà tí ẹ bá rékọjá odò Jordani sí Kenaani, ");
INSERT INTO yor_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","yan àwọn ìlú kan láti jẹ́ gẹ́gẹ́ bí ìlú ààbò fún yín, kí apani tó pa ènìyàn ní àìmọ̀ máa sálọ síbẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Wọn yóò jẹ́ ibi ìsásí kúrò lọ́wọ́ olùgbẹ̀san, kí ẹni tí a fi ẹ̀sùn ìpànìyàn kàn má ba à kú kí ó tó dúró níwájú àwọn ìjọ àwọn ènìyàn ní ìdájọ́. ");
INSERT INTO yor_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Mẹ́fà nínú ìlú tí ẹ ó fi fún wọn yóò jẹ́ ìlú ààbò fún yín. ");
INSERT INTO yor_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Yan ìlú mẹ́ta ní ìhà ti Jordani, kí ẹ sì yan ìlú mẹ́ta ní ìhà Kenaani tí yóò máa jẹ́ ìlú ìsásí. ");
INSERT INTO yor_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Ìlú mẹ́fà yìí yóò jẹ́ ìlú ìsásí fún àwọn ọmọ Israẹli, fún àjèjì àti ẹnikẹ́ni tí ó bá ń gbé láàrín wọn, kí ẹnikẹ́ni tí ó bá pa ènìyàn ní àìmọ̀ sálọ síbẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘Bí ọkùnrin kan bá fi ohun èlò irin lu ènìyàn tí ó kú, apànìyàn ni, pípa ni a ó pa, apànìyàn náà. ");
INSERT INTO yor_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Tàbí tí ènìyàn bá mú òkúta tí ó lè pa ènìyàn lọ́wọ́ tí ó sì fi lu ènìyàn, tí ó sì kú, apànìyàn ni, pípa ni a ó pa apànìyàn náà. ");
INSERT INTO yor_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Tàbí tí ènìyàn bá mú ohun èlò igi ní ọwọ́ rẹ̀ tí ó sì lẹ̀ ẹ́ pa ènìyàn, tí ó sì fi lu ènìyàn, tí ó sì kú, apànìyàn ni; pípa ní a ó pa apànìyàn náà. ");
INSERT INTO yor_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Olùgbẹ̀san ẹ̀jẹ̀ yóò pa apànìyàn náà; tí ó bá bá a, yóò pa á. ");
INSERT INTO yor_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Tí ẹnikẹ́ni tí ó bá ń yan odì pẹ̀lú ìríra tí ẹlòmíràn tàbí ju nǹkan sí i pẹ̀lú èrò, tí ó sì kú. ");
INSERT INTO yor_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","Tàbí pẹ̀lú ìjà gbangba lù ú pẹ̀lú ìkùùkuu tí ó sì kú, pípa ni a ó pa ẹni bẹ́ẹ̀; apànìyàn ni. Olùgbẹ̀san ẹ̀jẹ̀ yóò pa apànìyàn náà tí ó bá bá a. ");
INSERT INTO yor_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘Ṣùgbọ́n bí ó bá fi nǹkan gún un lójijì láìṣọ̀ta, tàbí tí ó sọ ohunkóhun lù ú láìmọ̀-ọ́n-mọ̀ ṣe ");
INSERT INTO yor_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","tàbí, láìri, ju òkúta sí tí ó lè pa á, tí ó sì kú, nígbà tí kì í ṣe ọ̀tá rẹ̀, láti ṣe é léṣe. ");
INSERT INTO yor_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Àwọn àpéjọ gbọdọ̀ dájọ́ láàrín rẹ̀ àti olùgbẹ̀san ẹ̀jẹ̀ gẹ́gẹ́ bí ìlànà. ");
INSERT INTO yor_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Àpéjọ gbọdọ̀ dá ààbò bo ẹni tí a fi ẹ̀sùn ìpànìyàn kàn, kí a sì rán an padà lọ sí ìlú ìsásí tí ó ti wá. Ó gbọdọ̀ dúró níbẹ̀ títí di ìgbà tí olórí àlùfáà bá kú, ẹni tí a fi àmì òróró yàn. ");
INSERT INTO yor_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘Ṣùgbọ́n ti ẹni tí a fi sùn kan bá jáde kọjá ààlà ìlú ìsásí tí ó sá sí. ");
INSERT INTO yor_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","Tí olùgbẹ̀san ẹ̀jẹ̀ sì ri ní ìta ìlú náà, olùgbẹ̀san lè pa ẹni tí a fi ẹ̀sùn kàn láìjẹ̀bi ẹ̀sùn ìpànìyàn. ");
INSERT INTO yor_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Ẹni tí a fi ẹ̀sùn kàn gbọdọ̀ dúró nínú ìlú ìsásí títí di ìgbà tí olórí àlùfáà bá kú; lẹ́yìn ikú olórí àlùfáà, ni ó tó lè padà sí ibi tí dúkìá rẹ̀ wà. ");
INSERT INTO yor_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘Wọ̀nyí ni ó jẹ́ ìlànà ìdájọ́ fún yín ní ìran yín tó ń bọ̀, ní ibikíbi tí ẹ bá ń gbé. ");
INSERT INTO yor_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘Ẹnikẹ́ni tí ó bá pa ènìyàn gbọdọ̀ kú gẹ́gẹ́ bí apànìyàn lórí ìjẹ́rìí àwọn ènìyàn. Ṣùgbọ́n ẹlẹ́rìí kan ṣoṣo. Kì yóò jẹ́rìí sí ẹnìkan láti pa. ");
INSERT INTO yor_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘Má ṣe gba ohun ìràpadà fún ẹ̀mí apànìyàn, tí ó jẹ̀bi kí ó kú. Ṣùgbọ́n pípa ni kí a pa á. ");
INSERT INTO yor_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘Má ṣe gba ìràsílẹ̀ fún ẹnikẹ́ni tí ó bá lọ sí ìlú ìsásí, pe kí ó padà máa gbé ní ilẹ̀ tirẹ̀ kí ó tó di ìgbà ikú olórí àlùfáà. ");
INSERT INTO yor_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘Má ṣe sọ ilẹ̀ tí ẹ wà di àìmọ́. Ìtàjẹ̀ sílẹ̀ sọ ilẹ̀ náà di àìmọ́. Àtúnṣe kì yóò sí fún ilẹ̀ tí a ti ta ẹ̀jẹ̀ lé lórí, àyàfi ẹ̀jẹ̀ ẹni tí ó ta á sílẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Má ṣe sọ di àìmọ́, ilẹ̀ tí ẹ ń gbé, àti èyí tí mo ń gbé, nítorí Èmi Olúwa ń gbé láàrín àwọn ọmọ Israẹli.’ ” ");
INSERT INTO yor_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Àwọn olórí ìdílé Gileadi, ọmọkùnrin Makiri ọmọ Manase tí ó wá láti ara ìdílé ìran Josẹfu wá, wọ́n sì sọ̀rọ̀ níwájú Mose àti àwọn olórí, àwọn ìdílé Israẹli. ");
INSERT INTO yor_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Wọ́n sọ pé, “Nígbà tí Olúwa pàṣẹ fún olúwa mi láti fi ilẹ̀ yìí fún àwọn ọmọ Israẹli gẹ́gẹ́ bí ogún nípa kèké ṣíṣẹ́. Ó pa á láṣẹ fún ọ láti fi ogún Selofehadi arákùnrin wa fún àwọn ọmọbìnrin rẹ̀. ");
INSERT INTO yor_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Wàyí, tí wọn bá fẹ́ ọkùnrin láti ẹ̀yà Israẹli mìíràn; nígbà náà a ó gba ogún un wọn kúrò nínú ogún ìran wa, a ó sì fi kún ogún ẹ̀yà tí a fẹ́ wọn sí. Bẹ́ẹ̀ ni a ó sì gbà á kúrò nínú ìpín ilẹ̀ ogún ti wa. ");
INSERT INTO yor_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Nígbà tí ọdún ìdásílẹ̀ àwọn ọmọ Israẹli bá dé, a ó pa ogún wọn pọ̀ mọ́ ẹ̀yà tí wọ́n fẹ́ wọn sí, a ó sì gba ogún ẹ̀yà wọn kúrò lọ́wọ́ baba ńlá wọn.” ");
INSERT INTO yor_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Gẹ́gẹ́ bí àṣẹ Olúwa, Mose pàṣẹ fún àwọn ọmọ Israẹli pé, “Ohun ti ẹ̀yà àwọn ìran Josẹfu ń sọ tọ̀nà. ");
INSERT INTO yor_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Èyí ni ohun tí Olúwa pàṣẹ fún àwọn ọmọbìnrin Selofehadi: wọ́n lè fẹ́ ẹni tí ọkàn wọn fẹ́, kìkì pé wọ́n fẹ́ nínú ẹ̀yà ìdílé baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Kò sí ogún kan ní Israẹli tí ó gbọdọ̀ kọjá láti ẹ̀yà kan sí ẹ̀yà mìíràn, nítorí gbogbo ọmọ Israẹli ni yóò fi ilẹ̀ ogún ẹ̀yà tí wọ́n jogún láti ọ̀dọ̀ baba ńlá wọn pamọ́. ");
INSERT INTO yor_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Gbogbo ọmọbìnrin tí ó bá jogún ilẹ̀ nínú ẹ̀yà Israẹli kọ̀ọ̀kan gbọdọ̀ fẹ́ ènìyàn nínú ẹ̀yà ìdílé baba rẹ̀, kí gbogbo ọmọ Israẹli lè ní ìpín nínú ogún baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Kò sí ogún kankan tí ó gbọdọ̀ kọjá láti ẹ̀yà kan sí ẹ̀yà òmíràn, nítorí olúkúlùkù ẹ̀yà ọmọ Israẹli gbọdọ̀ tọ́jú ilẹ̀ tí ó jogún.” ");
INSERT INTO yor_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Nígbà náà, àwọn ọmọbìnrin Selofehadi ṣe gẹ́gẹ́ bí Olúwa ti pa á láṣẹ fún Mose. ");
INSERT INTO yor_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Nítorí pé a gbé Mahila, Tirsa, Hogla, Milka, àti Noa, àwọn ọmọbìnrin Selofehadi ní ìyàwó fún àwọn ọmọ arákùnrin baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Wọ́n fẹ́ ọkọ nínú ìdílé ìran Manase, ọmọ Josẹfu ogún wọn kù nínú ìdílé àti ẹ̀yà baba wọn. ");
INSERT INTO yor_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Wọ̀nyí ni àṣẹ àti ìdájọ́ tí Olúwa ti ipasẹ̀ Mose fún àwọn ọmọ Israẹli ní pẹ̀tẹ́lẹ̀ Moabu lẹ́bàá Jordani létí Jeriko.");
INSERT INTO yor_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Wọ̀nyí ni àwọn ọ̀rọ̀ tí Mose sọ fún gbogbo Israẹli ní aginjù, aginjù ìlà-oòrùn Jordani, ni Arabah, ní òdìkejì Ṣufi, ní àárín Parani àti Tofeli, Labani, Haserotu àti Disahabu. ");
INSERT INTO yor_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Ọjọ́ mọ́kànlá ni ó gbà láti rin ìrìnàjò láti Horebu dé Kadeṣi-Barnea, bí a bá gba ọ̀nà òkè Seiri.) ");
INSERT INTO yor_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Ní ìgbà tí ó pé ogójì ọdún, ní ọjọ́ kìn-ín-ní oṣù kọ́kànlá, Mose sọ ohun gbogbo tí Olúwa pàṣẹ nípa àwọn ọmọ Israẹli fún wọn. ");
INSERT INTO yor_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Èyí ṣẹlẹ̀ lẹ́yìn ìgbà tí ó ti ṣẹ́gun Sihoni ọba àwọn Amori, tí ó jẹ ọba ní Heṣboni, àti Ogu ọba Baṣani ni ó ṣẹ́gun ní Edrei, ẹni tí ó jẹ ọba ní Aṣtarotu. ");
INSERT INTO yor_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Ní ìhà ìlà-oòrùn Jordani tí ó wà nínú ilẹ̀ Moabu ni Mose bẹ̀rẹ̀ sísọ àsọyé òfin wọ̀nyí wí pé: ");
INSERT INTO yor_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Olúwa Ọlọ́run wa bá wa sọ̀rọ̀ ní Horebu pé, “Ẹ ti dúró ní orí òkè yìí pẹ́ tó. ");
INSERT INTO yor_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Ẹ yípadà kí ẹ sì tẹ̀síwájú ní ìrìnàjò yín lọ sí ilẹ̀ òkè àwọn ará Amori, ẹ tọ gbogbo àwọn ènìyàn tí ó ń gbé Arabah lọ ní aginjù, ní àwọn orí òkè àti pẹ̀tẹ́lẹ̀, ní gúúsù àti ní etí Òkun, lọ sí ilẹ̀ àwọn ará Kenaani àti lọ sí Lebanoni, títí fi dé odò ńlá Eufurate. ");
INSERT INTO yor_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Wò ó, èmi tí fi ilẹ̀ yí fún un yín, ẹ wọ inú rẹ̀ lọ kí ẹ sì gba ilẹ̀ náà tí Olúwa ti búra wí pé òun yóò fún àwọn baba yín: fún Abrahamu, Isaaki, àti Jakọbu, àti fún àwọn àrọ́mọdọ́mọ wọn.” ");
INSERT INTO yor_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Mo wí fún un yín nígbà náà pé, “Èmi nìkan kò lè dá ẹrù u yín gbé. ");
INSERT INTO yor_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Olúwa Ọlọ́run yín ti sọ yín di púpọ̀ lónìí, ẹ̀yin sì ti pọ̀ bí ìràwọ̀ ní ojú ọ̀run. ");
INSERT INTO yor_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Kí Olúwa Ọlọ́run àwọn baba yín sọ yín di púpọ̀ ní ọ̀nà ẹgbẹ̀rún (1,000) sí i, kí ó sì bùkún un yín gẹ́gẹ́ bí ó ti ṣèlérí. ");
INSERT INTO yor_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Báwo ni èmi nìkan ṣe lè máa ru àjàgà àti ìṣòro yín àti èdè-àìyedè yín? ");
INSERT INTO yor_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Ẹ yan àwọn ọlọ́gbọ́n, olóye àti àwọn ẹni àpọ́nlé, láti inú ẹ̀yà yín kọ̀ọ̀kan, èmi yóò sì fi wọ́n ṣe olórí yín.” ");
INSERT INTO yor_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Ẹ̀yin sì dá mi lóhùn wí pé, “Ohun tí ìwọ ti gbèrò láti ṣe nì dára.” ");
INSERT INTO yor_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Bẹ́ẹ̀ ni mo yan olórí àwọn ẹ̀yà yín, àwọn ọlọ́gbọ́n ọkùnrin, ẹni àpọ́nlé, mo sì fi jẹ olórí yín, olórí ẹgbẹẹ̀rún, olórí ọ̀rọ̀ọ̀rún, olórí àràádọ́ta, àti olórí mẹ́wàá mẹ́wàá gẹ́gẹ́ bí àwọn ẹ̀yà yín. ");
INSERT INTO yor_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Mo sì kìlọ̀ fún àwọn onídàájọ́ yín nígbà náà pé, ẹ gbọ́ èdè-àìyedè tí ó wà láàrín àwọn ènìyàn an yín kí ẹ sì ṣe ìdájọ́ òdodo, bóyá ẹjọ́ tí ó ṣẹlẹ̀ láàrín Israẹli sí Israẹli ni tàbí láàrín Israẹli kan sí àlejò. ");
INSERT INTO yor_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ẹ má sì ṣe ojúsàájú ní ìdájọ́. Ẹ ṣe ìdájọ́ ẹni ńlá àti kékeré bákan náà. Ẹ má ṣe bẹ̀rù ẹnikẹ́ni torí pé ti Ọlọ́run ni ìdájọ́. Ẹjọ́ tí ó bá le jù fún un yín ni kí ẹ mú wá fún mi. Èmi yóò sì gbọ́ ọ. ");
INSERT INTO yor_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Nígbà náà ni èmi yóò sọ ohun tí ẹ ó ṣe fún un yín. ");
INSERT INTO yor_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Nígbà náà ní a gbéra láti Horebu, bí Olúwa Ọlọ́run wa ti pàṣẹ fún wá, a sì la àwọn ilẹ̀ lókè Amori kọjá lọ dé gbogbo aginjù ńlá tí ó ba ni lẹ́rù nì tí ẹ̀yin ti rí, bẹ́ẹ̀ ni a sì dé Kadeṣi-Barnea. ");
INSERT INTO yor_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Nígbà náà ni mo sọ fún un yín pé, “Ẹ ti dé ilẹ̀ òkè àwọn ará Amori, èyí tí Olúwa Ọlọ́run wa fún wa. ");
INSERT INTO yor_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Ẹ kíyèsi i, Olúwa Ọlọ́run yín ló ni ilẹ̀ náà. Ẹ lọ kí ẹ sì gba ilẹ̀ náà bí Olúwa Ọlọ́run àwọn baba yín tí sọ fún un yín. Ẹ má bẹ̀rù, ẹ má sì ṣe fòyà.” ");
INSERT INTO yor_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Nígbà náà ni gbogbo yín tọ̀ mí wá wí pé, “Jẹ́ kí a yan àwọn ayọ́lẹ̀wò láti yọ́ ilẹ̀ náà wò fún wa, kí wọn sì fún wa ní ìròyìn àwọn ọ̀nà tí a ó gbà àti àwọn ìlú tí a ó bá pàdé.” ");
INSERT INTO yor_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Èrò náà sì dára lójú mi, torí èyí ni mo ṣe yan àwọn ènìyàn méjìlá nínú yín, ẹnìkan láti inú ẹ̀yà kọ̀ọ̀kan. ");
INSERT INTO yor_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Wọ́n sì gòkè lọ sí ilẹ̀ òkè náà, wọ́n sì wá sí àfonífojì Eṣkolu, wọ́n sì yẹ̀ ẹ́ wò. ");
INSERT INTO yor_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Wọ́n sì mú lára èso ilẹ̀ náà wá fún wa pé, “Ilẹ̀ tí ó dára ni Olúwa Ọlọ́run wa fún wa.” ");
INSERT INTO yor_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Ṣùgbọ́n ẹ̀yin kò fẹ́ gòkè lọ; ẹ ṣọ̀tẹ̀ sí àṣẹ Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Ẹ kùn nínú àgọ́ ọ yín, ẹ sì wí pé, “Olúwa kórìíra wa, torí èyí ló fi mú wa jáde láti Ejibiti láti fi wá lé àwọn ará Amori lọ́wọ́ láti pa wá run. ");
INSERT INTO yor_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Níbo la ó lọ? Àwọn arákùnrin wa ti kó ìrẹ̀wẹ̀sì bá wa nípa sísọ pé, ‘Àwọn ènìyàn náà lágbára wọ́n sì ga jù wá lọ; àwọn ìlú náà tóbi jọjọ bẹ́ẹ̀ ni odi wọn ga kan ọ̀run. A tilẹ̀ rí àwọn òmíràn (ìran Anaki) níbẹ̀.’ ” ");
INSERT INTO yor_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Nígbà náà ni mo sọ fún un yín pé, “Ẹ má ṣojo, ẹ kò sì gbọdọ̀ bẹ̀rù wọn. ");
INSERT INTO yor_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Olúwa Ọlọ́run yín, tí ń ṣáájú yín yóò jà fún un yín; bí ó ti ṣe fún un yín ní Ejibiti lójú ẹ̀yin tìkára yín ");
INSERT INTO yor_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","àti ní aginjù. Níbẹ̀ ni ẹ ti rí i bí Olúwa Ọlọ́run yín ti gbé yín, bí baba ti í gbé ọmọ rẹ̀, ní gbogbo ọ̀nà tí ẹ lọ títí ẹ fi padà dé ibí yìí.” ");
INSERT INTO yor_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Pẹ̀lú gbogbo èyí tí mo wí, ẹ kò gbẹ́kẹ̀lé Olúwa Ọlọ́run yín, ");
INSERT INTO yor_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","tí ń ṣáájú u yín lọ ní gbogbo ọ̀nà yín, nípa fífi iná ṣe amọ̀nà yín ní òru àti ìkùùkuu ní ọ̀sán, láti fi àwọn ibi tí ẹ lè tẹ̀dó sí hàn yín àti àwọn ọ̀nà tí ẹ ó rìn. ");
INSERT INTO yor_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Nígbà tí Olúwa gbọ́ ohun tí ẹ sọ, inú bí i, ó sì búra wí pé, ");
INSERT INTO yor_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Kò sí ọ̀kan nínú ìran búburú yìí tí yóò dé ilẹ̀ rere tí mo ti búra láti fún àwọn baba ńlá a yín. ");
INSERT INTO yor_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Bí kò ṣe Kalebu ọmọ Jefunne. Òun ni yóò wọ̀ ọ́. Èmi yóò sì fún òun àti àwọn ìran rẹ̀ ní ilẹ̀ náà tí ó ti fi ẹsẹ̀ rẹ̀ tẹ̀; torí pé ó fi gbogbo ọkàn rẹ̀ tẹ̀lé Olúwa.” ");
INSERT INTO yor_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Torí i tiyín ni Olúwa fi bínú sí mi wí pé, “Ìwọ náà kì yóò wọ ibẹ̀ bákan náà, ");
INSERT INTO yor_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ṣùgbọ́n Joṣua ọmọ Nuni tí ń ṣe olùrànlọ́wọ́ rẹ ni yóò wọ ibẹ̀. Mú un, ní ọkàn le torí pé, òun yóò ṣáájú àwọn ọmọ Israẹli láti gba ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Àwọn èwe yín tí ẹ sọ pé wọn yóò kó lẹ́rú. Àwọn ọmọ yín tí ko tí ì mọ rere yàtọ̀ sí búburú ni yóò wọ ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Ṣùgbọ́n ẹ̀yin, ẹ yí padà sí aginjù tí ó wà ní ọ̀nà tí ó lọ sí Òkun Pupa.” ");
INSERT INTO yor_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Nígbà náà ni ẹ fèsì wí pé, “Àwa ti ṣẹ̀ sí Olúwa. A ó sì gòkè lọ láti jà, gẹ́gẹ́ bí Olúwa Ọlọ́run wa ti pàṣẹ fún wa.” Torí náà gbogbo yín ẹ mú ohun ìjà a yín, ẹ rò pé ó rọrùn láti gòkè lọ sí àwọn orílẹ̀-èdè olókè náà. ");
INSERT INTO yor_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Ṣùgbọ́n Olúwa sọ fún mi pé, “Sọ fún wọn, ‘Ẹ má ṣe gòkè lọ láti jà torí pé èmi kì yóò wà pẹ̀lú u yín. Àwọn ọ̀tá a yín yóò sì ṣẹ́gun yín.’ ” ");
INSERT INTO yor_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Bẹ́ẹ̀ ni mo sọ fún yín, ẹ̀yin kò sì gbọ́, ẹ̀yin ṣọ̀tẹ̀ sí òfin Olúwa, pẹ̀lú ìgbéraga yín, ẹ gòkè lọ sí ìlú olókè náà. ");
INSERT INTO yor_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Àwọn ará Amori tí ń gbé ní àwọn òkè náà, dojúkọ yín bí àgbájọpọ̀ oyin. Wọ́n sì lù yín bolẹ̀ láti Seiri títí dé Horma. ");
INSERT INTO yor_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Ẹ padà, ẹ sì sọkún níwájú Olúwa, òun kò sì fetí sí igbe ẹkún yín, Ó sì kọ etí dídi sí i yín. ");
INSERT INTO yor_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Báyìí ni ẹ sì dúró ní Kadeṣi fún ọ̀pọ̀lọpọ̀ ọjọ́ gẹ́gẹ́ bí ẹ̀yin ti ṣe. ");
INSERT INTO yor_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Nígbà náà ni a yípadà, tí a sì mú ọ̀nà wa pọ̀n lọ sí aginjù, a gba ọ̀nà Òkun Pupa, bí Olúwa ti darí mi. Ìgbà pípẹ́ ni a fi ń rìn kiri yíká agbègbè àwọn ìlú olókè Seiri. ");
INSERT INTO yor_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Nígbà náà ni Olúwa sọ fún mi pé, ");
INSERT INTO yor_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Ẹ ti rìn yí agbègbè ilẹ̀ olókè yìí pẹ́ tó, nísinsin yìí, ẹ yípadà sí ìhà àríwá. ");
INSERT INTO yor_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Fún àwọn ènìyàn náà ní àwọn òfin wọ̀nyí: ‘Ẹ ti fẹ́ la ilẹ̀ àwọn arákùnrin yín kọjá, àwọn ọmọ Esau; àwọn ará Edomu tí ń gbé ní Seiri. Ẹ̀rù yín yóò bà wọ́n, ṣùgbọ́n ẹ ṣọ́ra gidigidi. ");
INSERT INTO yor_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Ẹ má ṣe wá wọn níjà torí pé èmi kò ní fún un yín ní èyíkéyìí nínú ilẹ̀ wọn. Bí ó ti wù kí ó kéré mọ èmi kò ní fún un yín. Mo ti fi ilẹ̀ òkè Seiri fún Esau gẹ́gẹ́ bí ìní rẹ̀. ");
INSERT INTO yor_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Ẹ san owó oúnjẹ tí ẹ bá jẹ fún wọn àti omi tí ẹ bá mu.’ ” ");
INSERT INTO yor_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Olúwa Ọlọ́run yín ti bùkún un yín nínú gbogbo iṣẹ́ ọwọ́ yín. Ó ti mójútó ìrìnàjò yín nínú aginjù ńlá yìí. Olúwa Ọlọ́run yín wà pẹ̀lú u yín ní ogójì ọdún wọ̀nyí, dé bi pé ẹ̀yin kò ṣaláìní ohunkóhun. ");
INSERT INTO yor_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Bẹ́ẹ̀ ni a kọjá ọ̀dọ̀ àwọn arákùnrin wa, àwọn ọmọ Esau tí ń gbé ní Seiri. A yà kúrò ní ọ̀nà Arabah èyí tí ó wá láti Elati àti Esioni-Geberi, a sì rìn gba ọ̀nà aginjù Moabu. ");
INSERT INTO yor_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Olúwa sì sọ fún mi pé, “Ẹ má ṣe dẹ́rùba àwọn ará Moabu bẹ́ẹ̀ ni kí ẹ má ṣe bá wọn jagun torí pé n kò ní fi èyíkéyìí nínú ilẹ̀ wọn fún un yín. Mo ti fi Ari fún àwọn ọmọ Lọti bí i ìní.” ");
INSERT INTO yor_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Àwọn Emimu ti gbé ibẹ̀ rí, àwọn ènìyàn tó síngbọnlẹ̀ tó sì pọ̀, wọ́n ga bí àwọn Anaki. ");
INSERT INTO yor_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Gẹ́gẹ́ bí Anaki àwọn ènìyàn náà pè wọ́n ní ará Refaimu ṣùgbọ́n àwọn ará Moabu pè wọ́n ní Emimu. ");
INSERT INTO yor_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Àwọn ará Hori gbé ní Seiri, kí àwọn ọmọ Esau tó lé wọn kúrò níwájú wọn. Wọ́n sì gba ilẹ̀ wọn, wọ́n tẹ̀dó sí ààyè wọn gẹ́gẹ́ bí àwọn ọmọ Israẹli tí ṣe ní ilẹ̀ tí Olúwa yóò fún wọn ní ìní wọn.) ");
INSERT INTO yor_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Olúwa sì wí pé, “Ẹ dìde, kí ẹ sì la àfonífojì Seredi kọjá.” Bẹ́ẹ̀ ni a la àfonífojì náà kọjá. ");
INSERT INTO yor_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Ó gbà wá ní ọdún méjìdínlógójì kí ó tó di wí pé a la àfonífojì Seredi kọjá láti ìgbà tí a ti kúrò ní Kadeṣi-Barnea. Nígbà náà gbogbo ìran àwọn tí ó jẹ́ jagunjagun láàrín àwọn ènìyàn náà ti ṣègbé kúrò láàrín àwọn ènìyàn náà ní àsìkò yìí bí Olúwa ti búra fún wọn. ");
INSERT INTO yor_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Ọwọ́ Olúwa sì wà lòdì sí wọn nítòótọ́, láti run wọn kúrò nínú ibùdó, títí gbogbo wọn fi run tan. ");
INSERT INTO yor_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Lẹ́yìn tí ẹni tí ó gbẹ̀yìn pátápátá nínú àwọn jagunjagun àwọn ènìyàn wọ̀nyí ti kú, ");
INSERT INTO yor_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Olúwa sọ fún mi pé, ");
INSERT INTO yor_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Lónìí ni ẹ̀yin yóò la agbègbè Moabu kọjá ní Ari. ");
INSERT INTO yor_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Bí ẹ bá dé ọ̀dọ̀ àwọn ará Ammoni, ẹ má ṣe halẹ̀ mọ́ wọn, ẹ kò sì gbọdọ̀ bá wọn jagun, torí pé èmi kì yóò fi àwọn ilẹ̀ tí ó jẹ́ ti àwọn ará Ammoni fún un yín ní ìní. Mo ti fi fún àwọn ọmọ Lọti ní ìní.” ");
INSERT INTO yor_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(A ka ilẹ̀ yìí sí ilẹ̀ àwọn Refaimu, tí wọ́n ti gbé níbẹ̀ rí, ṣùgbọ́n àwọn ará Ammoni ń pè wọ́n ní ará Samsummimu. ");
INSERT INTO yor_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Wọ́n jẹ́ àwọn ènìyàn tó lágbára, wọ́n sì pọ̀, wọ́n sì ga gogoro bí àwọn ará Anaki. Olúwa run wọn kúrò níwájú àwọn ará Ammoni, tí wọ́n lé wọn jáde tí wọ́n sì gba ilẹ̀ wọn. ");
INSERT INTO yor_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Bákan náà ni Olúwa ṣe fún àwọn ọmọ Esau, tí wọ́n ń gbé ní Seiri, nígbà tí ó pa àwọn ará Hori run níwájú wọn. Wọ́n lé wọn jáde wọ́n sì ń gbé ní ilẹ̀ wọn títí di òní. ");
INSERT INTO yor_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Nípa ti àwọn ará Affimu, tí wọ́n ń gbé ní àwọn ìlú kéékèèké dé Gasa, àwọn ará Kaftorimu, tí wọ́n jáde láti Krete wá ni ó pa wọ́n run, wọ́n sì gba ilẹ̀ wọn.) ");
INSERT INTO yor_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Ẹ gbáradì, kí ẹ sì kọjá odò Arnoni. Kíyèsi, Mo ti fi Sihoni ará Amori, ọba Heṣboni àti ilẹ̀ rẹ̀ lé ọ lọ́wọ́. Ẹ bá ilẹ̀ náà jagun kí ẹ sì gbà á. ");
INSERT INTO yor_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Èmi bẹ̀rẹ̀ sí ní fi ìbẹ̀rù àti ìfòyà yín sára gbogbo orílẹ̀-èdè lábẹ́ ọ̀run láti òní lọ. Wọn yóò gbọ́ ìròyìn in yín, wọn yóò sì wárìrì, wọn yóò sì wà nínú ìdààmú ọkàn torí i tiyín.” ");
INSERT INTO yor_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Mo rán àwọn ìránṣẹ́ láti aginjù Kedemoti lọ́ sọ́dọ̀ Sihoni ọba Heṣboni pẹ̀lú ọ̀rọ̀ àlàáfíà wí pé, ");
INSERT INTO yor_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Jẹ́ kí a la ilẹ̀ ẹ yín kọjá. Àwa yóò gba ti òpópónà nìkan. A kò ní yà sọ́tùn tàbí sósì. ");
INSERT INTO yor_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Ẹ ta oúnjẹ tí a ó jẹ àti omi tí a ó mu fún wa ní iye owó wọn. Kìkì kí ẹ sá à jẹ́ kí a rìn kọjá: ");
INSERT INTO yor_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","gẹ́gẹ́ bí àwọn ọmọ Esau tí ó ń gbé ní Seiri àti àwọn ará Moabu tí ó ń gbé ní Ari, ti gbà wá láààyè títí a fi la Jordani já dé ilẹ̀ tí Olúwa Ọlọ́run wa yóò fún wa.” ");
INSERT INTO yor_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Ṣùgbọ́n Sihoni ọba Heṣboni kò gbà fún wa láti kọjá. Torí pé Olúwa Ọlọ́run yín ti mú ọkàn rẹ̀ yigbì, àyà rẹ̀ sì kún fún agídí kí ó ba à le fi lé e yín lọ́wọ́, bí ó ti ṣe báyìí. ");
INSERT INTO yor_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Olúwa sì bá mi sọ̀rọ̀ pé, “Kíyèsi i, mo ti bẹ̀rẹ̀ sí ní fi Sihoni àti ilẹ̀ rẹ̀ lé e yín lọ́wọ́. Báyìí, ẹ máa ṣẹ́gun rẹ̀, kí ẹ sì gba ilẹ̀ rẹ̀.” ");
INSERT INTO yor_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Nígbà tí Sihoni àti gbogbo àwọn jagunjagun rẹ̀ jáde wá láti bá wa jagun ní Jahasi, ");
INSERT INTO yor_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Olúwa Ọlọ́run wa fi lé wa lọ́wọ́ bẹ́ẹ̀ ni a ṣẹ́gun rẹ̀ pẹ̀lú àwọn ọmọ rẹ̀ àti gbogbo ológun rẹ̀. ");
INSERT INTO yor_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Nígbà náà, gbogbo ìlú wọn ni a kó tí a sì pa wọ́n run pátápátá tọkùnrin, tobìnrin àti gbogbo ọmọ wọn. A kò sì dá ẹnikẹ́ni sí. ");
INSERT INTO yor_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Ṣùgbọ́n a kó gbogbo ohun ọ̀sìn àti ìkógun àwọn ìlú tí a ṣẹ́gun fún ara wa. ");
INSERT INTO yor_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Láti Aroeri, létí odò Arnoni àti láti àwọn ìlú tí ó wà lẹ́bàá odò náà títí ó fi dé Gileadi, kò sí ìlú tí ó lágbára jù fún wa, Olúwa Ọlọ́run wa fi gbogbo wọn fún wa. ");
INSERT INTO yor_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Ní ìbámu pẹ̀lú òfin Olúwa Ọlọ́run wa, ẹ kò súnmọ́ ọ̀kan nínú ilẹ̀ àwọn ará Ammoni, bẹ́ẹ̀ ni ẹ kò dé ilẹ̀ tí ó lọ sí Jabbok, tàbí ilẹ̀ tí ó yí àwọn ìlú òkè e nì ká. ");
INSERT INTO yor_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Lẹ́yìn èyí ní a yípadà tí a sì kọrí sí ọ̀nà tí ó lọ sí Baṣani, Ogu ọba Baṣani àti gbogbo jagunjagun rẹ̀ ṣígun wá pàdé wa ní Edrei. ");
INSERT INTO yor_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Olúwa sọ fún mi pé, “Má ṣe bẹ̀rù rẹ̀, nítorí tí mó tí fi òun lé ọ lọ́wọ́, àti àwọn ọmọ-ogun rẹ̀, àti ilẹ̀ rẹ̀. Kí ìwọ kí ó ṣe sí i gẹ́gẹ́ bí ìwọ ti ṣe sí Sihoni ọba Amori ẹni tí ó ń jẹ ọba ní Heṣboni.” ");
INSERT INTO yor_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Bẹ́ẹ̀ ni Olúwa Ọlọ́run wa fi Ogu ọba Baṣani àti àwọn jagunjagun rẹ̀ lé wa lọ́wọ́. A kọlù wọ́n títí kò fi ku ẹnìkan fún un láàyè. ");
INSERT INTO yor_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Ní ìgbà náà ní a gba gbogbo àwọn ìlú rẹ̀. Kò sí ọ̀kankan tí a kò gbà nínú àwọn ọgọta ìlú tí wọ́n ní, gbogbo agbègbè Argobu, lábẹ́ ìjọba Ogu ní Baṣani. ");
INSERT INTO yor_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Gbogbo ìlú wọ̀nyí ní a mọ odi gíga yíká pẹ̀lú àwọn ìlẹ̀kùn àti irin. Ọ̀pọ̀ àwọn ìlú kéékèèké tí a kò mọ odi yíká sì tún wà pẹ̀lú. ");
INSERT INTO yor_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Gbogbo wọn ni a parun pátápátá gẹ́gẹ́ bí á ti ṣe sí Sihoni ọba Heṣboni, tí a pa gbogbo ìlú wọn run pátápátá: tọkùnrin tobìnrin àti àwọn ọmọ wọn. ");
INSERT INTO yor_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Ṣùgbọ́n a kó gbogbo ohun ọ̀sìn àti ìkógun àwọn ìlú wọn, fún ara wa. ");
INSERT INTO yor_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Ní ìgbà náà ni a ti gba ilẹ̀ tí ó wà ní Jordani láti odò Arnoni, títí dé orí òkè Hermoni lọ́wọ́ àwọn ọba Amori méjèèjì wọ̀nyí. ");
INSERT INTO yor_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Àwọn ará Sidoni ń pe Hermoni ní Sirioni. Àwọn Amori sì ń pè é ní Seniri). ");
INSERT INTO yor_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Gbogbo àwọn ìlú tí ó wà ní orí òkè olórí títẹ́ náà ni a gbà àti gbogbo Gileadi, àti gbogbo Baṣani, títí dé Saleka, àti Edrei, ìlú àwọn ọba Ogu ní ilẹ̀ Baṣani. ");
INSERT INTO yor_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Ogu tí í ṣe ọba Baṣani nìkan ni ó ṣẹ́kù nínú àwọn ará Refaimu. Ibùsùn rẹ̀ ni a fi irin ṣe, ó sì gùn ju ẹsẹ̀ bàtà mẹ́tàlá lọ ní gígùn àti ẹsẹ̀ bàtà mẹ́fà ní ìbú. Èyí sì wà ní Rabba ti àwọn Ammoni.) ");
INSERT INTO yor_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Nínú àwọn ilẹ̀ tí a gbà ní ìgbà náà, mo fún àwọn ọmọ Reubeni àti àwọn ọmọ Gadi, ní ilẹ̀ tí ó wà ní àríwá Aroeri níbi odò Arnoni, pọ̀ mọ́ ìdajì ilẹ̀ òkè Gileadi pẹ̀lú gbogbo ìlú wọn. ");
INSERT INTO yor_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Gbogbo ìyókù Gileadi àti gbogbo Baṣani, ní ilẹ̀ ọba Ogu ni mo fún ìdajì ẹ̀yà Manase. (Gbogbo agbègbè Argobu ni Baṣani tí a mọ̀ sí ilẹ̀ àwọn ará Refaimu. ");
INSERT INTO yor_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jairi ọ̀kan nínú àwọn ìran Manase gba gbogbo agbègbè Argobu títí dé ààlà àwọn ará Geṣuri àti àwọn ará Maakati; a sọ ibẹ̀ ní orúkọ rẹ̀ torí èyí ni Baṣani fi ń jẹ́ Hafoti-Jairi títí di òní.) ");
INSERT INTO yor_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Mo sì fi Gileadi fún Makiri, ");
INSERT INTO yor_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ṣùgbọ́n àwọn ọmọ Reubeni àti ọmọ Gadi ni mo fún ní ilẹ̀ láti Gileadi lọ dé odò Arnoni (àárín odò náà sì jẹ́ ààlà) títí ó fi dé odò Jabbok. Èyí tí i ṣe ààlà àwọn ará Ammoni. ");
INSERT INTO yor_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Pẹ̀tẹ́lẹ̀ Arabah pẹ̀lú, àti Jordani gẹ́gẹ́ bí òpin ilẹ̀ rẹ̀, láti Kinnereti lọ títí dé Òkun pẹ̀tẹ́lẹ̀ Arabah, àní Òkun Iyọ̀, ní ìsàlẹ̀ àwọn orísun Pisga ní ìhà ìlà-oòrùn. ");
INSERT INTO yor_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Mo pàṣẹ fún un yín ní ìgbà náà pé, “Olúwa Ọlọ́run yín ti fi ilẹ̀ yìí fún un yín láti ní i. Ṣùgbọ́n, gbogbo àwọn ọkùnrin yín tí ó lera tí wọ́n sì ti dira ogun, gbọdọ̀ kọjá síwájú àwọn arákùnrin yín: ará Israẹli. ");
INSERT INTO yor_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Àwọn ẹ̀yà a yín, àwọn ọmọ yín àti àwọn ohun ọ̀sìn in yín (mo mọ̀ pé ẹ ti ní ohun ọ̀sìn púpọ̀) lè dúró ní àwọn ìlú tí mo fi fún un yín, ");
INSERT INTO yor_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","títí di ìgbà tí Olúwa yóò fún àwọn arákùnrin yín ní ìsinmi bí ó ti fún un yín, àti ìgbà tí àwọn náà yóò fi gba ilẹ̀ náà tí Olúwa Ọlọ́run yín ti fún wọn ní ìhà kejì Jordani. Nígbà náà ni ọ̀kọ̀ọ̀kan yín tó lè padà lọ sí ìní rẹ̀ tí mo fún un.” ");
INSERT INTO yor_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Nígbà náà ni mo pàṣẹ fún Joṣua pé, “Ìwọ tí fi ojú rẹ rí ohun gbogbo tí Olúwa Ọlọ́run rẹ tí ṣe sí àwọn ọba méjèèjì wọ̀nyí. Bẹ́ẹ̀ ni Olúwa yóò ṣe sí àwọn ilẹ̀ ọba tí ẹ̀yin n lọ. ");
INSERT INTO yor_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ẹ má ṣe bẹ̀rù wọn, Olúwa Ọlọ́run yín tìkára rẹ̀ ni yóò jà fún un yín.” ");
INSERT INTO yor_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Nígbà náà ni mo bẹ Olúwa wí pé, ");
INSERT INTO yor_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Olúwa Olódùmarè, ìwọ tí bẹ̀rẹ̀ sí fi títóbi rẹ àti ọwọ́ agbára rẹ han ìránṣẹ́ rẹ. Ọlọ́run wo ló tó bẹ́ẹ̀ láyé àti lọ́run tí ó lè ṣe àwọn iṣẹ́ agbára ńlá tí o ti ṣe? ");
INSERT INTO yor_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Jẹ́ kí n kọjá lọ wo ilẹ̀ rere ti ìkọjá Jordani, ilẹ̀ òkè dídára nì àti Lebanoni.” ");
INSERT INTO yor_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Ṣùgbọ́n torí i tiyín, Olúwa Ọlọ́run bínú sí mi kò sì gbọ́ tèmi. Olúwa sọ wí pé, “Ó tó gẹ́ẹ́, ìwọ kò gbọdọ̀ sọ ohunkóhun lórí ọ̀rọ̀ yìí sí mi mọ́. ");
INSERT INTO yor_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Gòkè lọ sí orí òkè Pisga, sì wò yíká ìwọ̀-oòrùn, ìlà-oòrùn, àríwá àti gúúsù. Fi ojú ara rẹ wo ilẹ̀ náà níwọ̀n bí ìwọ kò tí ní kọjá Jordani yìí. ");
INSERT INTO yor_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Ṣùgbọ́n yan Joṣua, kí o sì gbà á níyànjú, mú un lọ́kàn le, torí pé òun ni yóò síwájú àwọn ènìyàn wọ̀nyí kọjá, yóò sì jẹ́ kí wọn jogún ilẹ̀ náà tí ìwọ yóò rí.” ");
INSERT INTO yor_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Báyìí ni a dúró ní àfonífojì ní ẹ̀bá Beti-Peori. ");
INSERT INTO yor_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Gbọ́ Israẹli, gbọ́ òfin àti ìlànà tí èmi yóò kọ́ ọ yín. Ẹ tẹ̀lé wọn kí ẹ ba à lè yè, kí ẹ ba à lè lọ láti gba ilẹ̀ tí Olúwa Ọlọ́run àwọn baba yín yóò fi fún un yín. ");
INSERT INTO yor_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ẹ má ṣe fi kún àwọn ohun tí mo pàṣẹ fún un yín, ẹ kò sì gbọdọ̀ yọ kúrò nínú wọn, ṣùgbọ́n ẹ pa òfin Olúwa Ọlọ́run yín tí mo fún un yín mọ́. ");
INSERT INTO yor_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Ẹ ti fi ojú ara yín rí ohun tí Olúwa ṣe ní Baali-Peori. Olúwa Ọlọ́run yín run gbogbo àwọn tí ó tẹ̀lé òrìṣà Baali-Peori kúrò ní àárín yín. ");
INSERT INTO yor_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Ṣùgbọ́n gbogbo ẹ̀yin tí ẹ gbẹ́kẹ̀lé Olúwa Ọlọ́run láìyẹsẹ̀ ni ẹ wà láààyè lónìí. ");
INSERT INTO yor_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Ẹ kíyèsi i, mo ti kọ́ ọ yín ní àwọn òfin àti àṣẹ bí Olúwa Ọlọ́run mi ti pàṣẹ fún mi, kí ẹ ba à le tẹ̀lé wọn ní ilẹ̀ náà tí ẹ ń lọ láti ní ní ìní. ");
INSERT INTO yor_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Ẹ máa kíyèsi wọn dáradára. Èyí ni yóò fi ọgbọ́n àti òye yín han àwọn orílẹ̀-èdè. Àwọn tí wọn yóò gbọ́ nípa àwọn ìlànà wọ̀nyí, tí wọn yóò sì máa wí pé, “Dájúdájú, orílẹ̀-èdè ńlá yìí kún fún ọgbọ́n àti òye.” ");
INSERT INTO yor_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Orílẹ̀-èdè olókìkí wo ni ọlọ́run wọn tún súnmọ́ wọn, bí Olúwa Ọlọ́run wa ti súnmọ́ wa nígbàkígbà tí a bá ń ké pè é? ");
INSERT INTO yor_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Orílẹ̀-èdè wo ló tún le lókìkí láti ní àwọn ìlànà òdodo, àti òfin gẹ́gẹ́ bí àwọn òfin wọ̀nyí tí mo ń gbé kalẹ̀ fún un yín lónìí. ");
INSERT INTO yor_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Kìkì i kí ẹ kíyèsára, kí ẹ sì ṣọ́ra a yín gidigidi kí ẹ má ba à gbàgbé àwọn ohun tí ojú yín ti rí, kí wọn má sì ṣe sá kúrò lóókan àyà yín níwọ̀n ìgbà tí ẹ sì wà láààyè. Ẹ máa fi wọ́n kọ́ àwọn ọmọ yín àti àwọn ọmọ wọn tí ń bọ̀ lẹ́yìn wọn. ");
INSERT INTO yor_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Ẹ rántí ọjọ́ tí ẹ dúró níwájú Olúwa Ọlọ́run yín ní Horebu, nígbà tí ó wí fún mi pé, “Kó àwọn ènìyàn wọ̀nyí jọ síwájú mi láti gbọ́ ọ̀rọ̀ mi, kí wọ́n lè kọ́ láti máa bu ọlá náà fún mi ní gbogbo ìgbà tí wọ́n bá gbé lórí ilẹ̀ náà, kí wọ́n sì le è fi wọ́n kọ́ àwọn ọmọ wọn.” ");
INSERT INTO yor_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Ẹ̀yin súnmọ́ tòsí, ẹ sì dúró ní ẹsẹ̀ òkè náà, òkè náà sì ń jóná dé agbede-méjì ọrun, pẹ̀lú òkùnkùn, àti àwọsánmọ̀, àti òkùnkùn biribiri. ");
INSERT INTO yor_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Olúwa sì bá yín sọ̀rọ̀ láti àárín iná náà wá. Ẹ gbọ́ àwọn ìró ohùn, ṣùgbọ́n ẹ kò rí ẹnikẹ́ni, ohùn nìkan ni ẹ gbọ́. ");
INSERT INTO yor_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ó sọ àwọn májẹ̀mú rẹ̀ fún un yín àní àwọn òfin mẹ́wẹ̀ẹ̀wá tí ó pàṣẹ fún un yín láti máa tẹ̀lé, ó sì kọ wọ́n sórí wàláà òkúta méjì. ");
INSERT INTO yor_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Olúwa sì pàṣẹ fún mi nígbà náà láti kọ yín ní ìlànà àti ìdájọ, kí ẹ̀yin kí ó lè máa ṣe wọ́n ní ilẹ̀ náà, ní ibi tí ẹ̀yin ń lọ láti gbà á. ");
INSERT INTO yor_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Ẹ kíyèsára gidigidi, torí pé, ẹ kò rí ìrísí ohunkóhun ní ọjọ́ tí Olúwa bá yín sọ̀rọ̀ ní Horebu láti àárín iná wá. Torí náà ẹ ṣọ́ra yín gidigidi, ");
INSERT INTO yor_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","kí ẹ ma ba à ba ara yín jẹ́ nípa ṣíṣe ère fún ara yín, àní ère lóríṣìíríṣìí yálà èyí tí ó ní ìrísí ọkùnrin tàbí tí obìnrin, ");
INSERT INTO yor_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","tàbí ti ẹranko orí ilẹ̀, tàbí ti ẹyẹ tí ń fò ní òfúrufú, ");
INSERT INTO yor_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","tàbí ti àwòrán onírúurú ẹ̀dá tí ń fà lórí ilẹ̀, tàbí ti ẹja nínú omi. ");
INSERT INTO yor_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Bí ẹ bá wòkè tí ẹ rí oòrùn, òṣùpá àti àwọn ìràwọ̀: àwọn ohun tí a ṣe lọ́jọ̀ sójú ọ̀run, ẹ má ṣe jẹ́ kí wọ́n tàn yín jẹ dé bi pé ẹ̀yin yóò foríbalẹ̀ fún wọn, àti láti máa sin ohun tí Olúwa Ọlọ́run yín dá fún gbogbo orílẹ̀-èdè lábẹ́ ọ̀run. ");
INSERT INTO yor_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Olúwa Ọlọ́run yín sì ti mú ẹ̀yin jáde kúrò nínú iná ìléru ńlá, àní ní Ejibiti, láti lè jẹ́ ènìyàn ìní i rẹ̀, bí ẹ̀yin ti jẹ́ báyìí. ");
INSERT INTO yor_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Inú Olúwa ru sí mi nítorí yín, ó sì ti búra pé èmi kì yóò la Jordani kọjá, èmi kì yóò sì wọ ilẹ̀ rere tí Olúwa Ọlọ́run fi fún un yín, ní ìní yín. ");
INSERT INTO yor_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Èmi yóò kú ní ilẹ̀ yìí, èmi kì yóò la Jordani kọjá, ṣùgbọ́n ẹ̀yin ti fẹ́ rékọjá sí òdìkejì odò láti gba ilẹ̀ rere náà. ");
INSERT INTO yor_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Ẹ ṣọ́ra, kí ẹ má ṣe gbàgbé májẹ̀mú Olúwa Ọlọ́run yín tí ó ti bá a yín dá. Ẹ má ṣe ṣe ère ní ìrísí ohunkóhun fún ara yín, èèwọ̀ ni Olúwa Ọlọ́run yín kà á sí. ");
INSERT INTO yor_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Torí pé iná ajónirun ni Olúwa Ọlọ́run yín, Ọlọ́run owú ni. ");
INSERT INTO yor_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Lẹ́yìn ìgbà tí ẹ ti ní àwọn ọmọ àti àwọn ọmọ ọmọ, tí ẹ sì ti gbé ní ilẹ̀ yìí pẹ́, bí ẹ bá wá ba ara yín jẹ́ nípa ṣíṣe irú ère yówù tó jẹ́, tí ẹ sì ṣe búburú lójú Olúwa Ọlọ́run yín, tí ẹ sì mú un bínú. ");
INSERT INTO yor_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Mo pe ọ̀run àti ayé láti jẹ́rìí takò yín lónìí, pé kíákíá ni ẹ ó parun ní ilẹ̀ náà tí ẹ ń la Jordani kọjá lọ láti gbà. Ẹ kò ní pẹ́ ní ilẹ̀ náà, ṣùgbọ́n ẹ̀yin yóò run pátápátá. ");
INSERT INTO yor_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Olúwa yóò fọ́n yín ká sí àárín àwọn ènìyàn náà, àwọn díẹ̀ nínú yín ni yóò yè láàrín orílẹ̀-èdè tí Olúwa yóò fọ́n yín sí. ");
INSERT INTO yor_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ẹ ó sì máa sin ọlọ́run tí á fi ọwọ́ ènìyàn ṣe: tí wọ́n fi igi àti òkúta ṣe, èyí tí kò le ríran, gbọ́rọ̀, jẹun tàbí gbọ́ òórùn. ");
INSERT INTO yor_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Bí ẹ̀yin bá wá Olúwa Ọlọ́run yín láti bẹ̀ ẹ́, ẹ ó ri i, bí ẹ bá wá a, pẹ̀lú gbogbo ọkàn yín àti gbogbo àyà a yín. ");
INSERT INTO yor_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Bí ẹ bá wà nínú wàhálà, bí gbogbo nǹkan wọ̀nyí bá ṣẹlẹ̀ sí yín, láìpẹ́ ẹ ó tún padà tọ Olúwa Ọlọ́run yín wá, ẹ ó sì gbọ́ tirẹ̀. ");
INSERT INTO yor_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Nítorí pé Olúwa Ọlọ́run yín aláàánú ni, kò ní gbàgbé tàbí pa yín rẹ́ tàbí kó gbàgbé májẹ̀mú pẹ̀lú àwọn baba ńlá yín, èyí tí ó fi ìdí rẹ̀ múlẹ̀ nípa ìbúra. ");
INSERT INTO yor_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Ẹ béèrè báyìí nípa ti àwọn ọjọ́ ìgbàanì ṣáájú kí a tó bí i yín, láti ìgbà tí Ọlọ́run ti dá ènìyàn sórí ilẹ̀ ayé. Ẹ béèrè láti igun ọ̀run kan sí èkejì. Ǹjẹ́ irú nǹkan olókìkí báyìí: ti ṣẹlẹ̀ rí? Ǹjẹ́ a ti gbọ́ irú u rẹ̀ rí? ");
INSERT INTO yor_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ǹjẹ́ àwọn ènìyàn mìíràn tí ì gbọ́ ohùn Ọlọ́run rí, tí ó sọ̀rọ̀ jáde láti inú iná, gẹ́gẹ́ bí ẹ̀yin ti gbọ́ tí ẹ sì yè? ");
INSERT INTO yor_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Ǹjẹ́ Ọlọ́run kan ti gbìyànjú àti mú orílẹ̀-èdè kan jáde kúrò nínú òmíràn fúnra rẹ̀ rí, nípa ìdánwò, nípa iṣẹ́ àmì, àti iṣẹ́ ìyanu nípa ogun, tàbí nípa ọwọ́ agbára tàbí nína apá, àti nípa ẹ̀rù ńlá: gẹ́gẹ́ bí gbogbo èyí tí Olúwa Ọlọ́run yín ṣe fún un yín ní Ejibiti ní ojú ẹ̀yin tìkára yín? ");
INSERT INTO yor_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","A fi gbogbo nǹkan wọ̀nyí hàn yín kí ẹ bá a lè gbà pé Olúwa ni Ọlọ́run. Kò sì sí ẹlòmíràn lẹ́yìn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Ó jẹ́ kí ẹ gbọ́ ohùn rẹ̀ láti ọ̀run wá, láti kọ́ ọ yín. Ní ayé, ó fi iná ńlá rẹ̀ hàn yín, ẹ sì gbọ́ ohùn rẹ̀ láti àárín iná wá, ");
INSERT INTO yor_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","torí pé ó fẹ́ràn àwọn baba ńlá yín, ó sì yan àwọn ọmọ wọn ní ipò lẹ́yìn wọn. Nípa ìwà láààyè àti nípa agbára ńlá rẹ̀ ni ó fi mú un yín kúrò ní Ejibiti. ");
INSERT INTO yor_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Láti lé àwọn orílẹ̀-èdè tí ó tóbi tí ó sì lágbára níwájú yín; láti le è mú un yín wá sí ilẹ̀ wọn kí ẹ lè jogún rẹ̀ bí ó ti rí lónìí. ");
INSERT INTO yor_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Ẹ gbà kí ẹ sì fi sọ́kàn lónìí pé Olúwa ni Ọlọ́run lókè ọ̀run lọ́hùn ún àti ní ilẹ̀ ní ìsàlẹ̀ níhìn-ín. Kò sí òmíràn mọ́. ");
INSERT INTO yor_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Ẹ pa àwọn ìlànà àti àṣẹ rẹ̀ mọ́ tí mo ń fún un yín lónìí; kí ó ba à le è yẹ yín, kí ẹ̀yin sì le è pẹ́ ní ilẹ̀ tí Olúwa Ọlọ́run yín fún un yín ní gbogbo ìgbà. ");
INSERT INTO yor_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Mose sì ya àwọn ìlú mẹ́ta kan sọ́tọ̀ ní apá ìwọ̀-oòrùn Jordani. ");
INSERT INTO yor_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Kí apànìyàn kí ó lè máa sá síbẹ̀, tí ó bá ṣi ẹnìkejì rẹ̀ pa, tí kò sì kórìíra rẹ̀ tẹ́lẹ̀ rí, àti pé bí ó bá sá sí ọ̀kan nínú ìlú wọ̀nyí kí ó lè là. ");
INSERT INTO yor_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Àwọn ìlú mẹ́tẹ̀ẹ̀ta náà nìwọ̀nyí: Beseri ní ijù, ní ilẹ̀ pẹ̀tẹ́lẹ̀, tí àwọn ọmọ Reubeni; Ramoti ní Gileadi, ti àwọn ọmọ Gadi àti Golani ní Baṣani, ti àwọn ará Manase. ");
INSERT INTO yor_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Èyí ni òfin tí Mose gbé kalẹ̀ fún àwọn ará Israẹli. ");
INSERT INTO yor_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Wọ̀nyí ni àwọn ẹ̀rí, àti ìlànà àti ìdájọ́ tí Mose fi lélẹ̀ fún ún àwọn ọmọ Israẹli, lẹ́yìn tí wọ́n ti jáde kúrò ní Ejibiti. ");
INSERT INTO yor_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Tí wọ́n sì wà ní ẹ̀bá àfonífojì Beti-Peori ní ìlà-oòrùn Jordani; ní ilẹ̀ Sihoni, ọba àwọn Amori tí ó jẹ ọba Heṣboni tí Mose àti àwọn ọmọ Israẹli ṣẹ́gun, bí wọ́n ṣe ń ti Ejibiti bọ̀. ");
INSERT INTO yor_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Wọ́n gba ilẹ̀ rẹ̀, àti ilẹ̀ Ogu ọba Baṣani àwọn ọba Amori méjèèjì tí ń bẹ ní ìlà-oòrùn Jordani. ");
INSERT INTO yor_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Ilẹ̀ wọ̀nyí bẹ̀rẹ̀ láti Aroeri ní etí odò Arnoni dé orí òkè Sirioni (èyí ni Hermoni). ");
INSERT INTO yor_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Àti gbogbo aginjù ní ìlà-oòrùn Jordani títí dé Òkun Iyọ̀ ní ìsàlẹ̀ gẹ̀rẹ́gẹ̀rẹ́ Pisga. ");
INSERT INTO yor_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mose sì pe gbogbo Israẹli jọ, ó sì wí pé, Gbọ́ ìwọ Israẹli, gbọ́ ìlànà àti òfin tí mo mú wá sí etí ìgbọ́ ọ yín lónìí. Ẹ kọ wọ́n, kí ẹ sì ri dájú pé ẹ̀ ń ṣe wọ́n. ");
INSERT INTO yor_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Olúwa Ọlọ́run wa bá wa dá májẹ̀mú ní Horebu. ");
INSERT INTO yor_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Kì í ṣe àwọn baba wa ni Olúwa bá dá májẹ̀mú yìí bí kò ṣe àwa, àní pẹ̀lú gbogbo àwa tí a wà láààyè níbí lónìí. ");
INSERT INTO yor_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Olúwa bá a yín sọ̀rọ̀ lójúkojú láàrín iná lórí òkè. ");
INSERT INTO yor_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(Ní ìgbà yìí, mo wà láàrín ẹ̀yin pẹ̀lú Ọlọ́run láti sọ ọ̀rọ̀ Olúwa fún un yín torí pé ẹ̀rù Ọlọ́run ń bà yín, ẹ kò sì lè kọjá lọ sórí òkè.) Ó sì wí pé, ");
INSERT INTO yor_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Èmi ni Olúwa Ọlọ́run yín, tí ó mú un yín jáde láti ilẹ̀ Ejibiti, láti oko ẹrú jáde wá. ");
INSERT INTO yor_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Ìwọ kò gbọdọ̀ ní ọlọ́run mìíràn pẹ̀lú mi. ");
INSERT INTO yor_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Ìwọ kò gbọdọ̀ ṣe ère fún ara yín, tàbí àwòrán ohun kan tí ń bẹ ní òkè ọ̀run, tàbí ti ohun kan tí ń bẹ ní ìsàlẹ̀ ilẹ̀, tàbí ti ohun kan tí ń bẹ nínú omi ní ìsàlẹ̀ ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Ìwọ kò gbọdọ̀ tẹ orí ara rẹ ba fún wọn, bẹ́ẹ̀ ni ìwọ kò gbọdọ̀ sìn wọ́n; nítorí Èmi Olúwa Ọlọ́run rẹ, Ọlọ́run owú ni mí, tí ń bẹ ẹ̀ṣẹ̀ àwọn baba wò lára àwọn ọmọ, láti ìran kẹta títí dé ẹ̀kẹrin nínú àwọn tí ó kórìíra mi. ");
INSERT INTO yor_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Èmi a sì máa fi àánú hàn sí ẹgbẹẹgbẹ̀rún àwọn tí ó fẹ́ mi, tí wọ́n sì ń pa òfin mi mọ́. ");
INSERT INTO yor_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Ẹ má ṣe ṣi orúkọ Olúwa Ọlọ́run yín lò, torí pé ẹnikẹ́ni tí o bá ṣi orúkọ rẹ̀ lò kì yóò lọ láìjẹ̀bi. ");
INSERT INTO yor_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Rántí ọjọ́ ìsinmi láti yà á sí mímọ́, bí Olúwa Ọlọ́run yín ti pàṣẹ fún un yín. ");
INSERT INTO yor_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Ọjọ́ mẹ́fà ni ìwọ yóò fi ṣiṣẹ́, kí ìwọ kí ó ṣe gbogbo iṣẹ́ rẹ. ");
INSERT INTO yor_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Ṣùgbọ́n ọjọ́ keje ni ọjọ́ ìsinmi Olúwa Ọlọ́run rẹ: nínú rẹ̀ ìwọ kò gbọdọ̀ ṣe iṣẹ́kíṣẹ́ kan: ìwọ, àti ọmọ rẹ ọkùnrin àti ọmọ rẹ obìnrin, ọmọ ọ̀dọ̀ rẹ ọkùnrin àti ọmọ ọ̀dọ̀ rẹ obìnrin, àti akọ màlúù rẹ, àti kẹ́tẹ́kẹ́tẹ́ rẹ, àti ohun ọ̀sìn rẹ kan, àti àlejò tí ń bẹ nínú ibodè rẹ; kí ọmọ ọ̀dọ̀ rẹ ọkùnrin àti ọmọ ọ̀dọ̀ rẹ obìnrin kí ó lè sinmi gẹ́gẹ́ bí ìwọ. ");
INSERT INTO yor_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Sì rántí pé, ìwọ ti jẹ́ ẹrú ní Ejibiti rí, àti pé Olúwa Ọlọ́run rẹ yọ ọ́ kúrò níbẹ̀ pẹ̀lú agbára ńlá, àti nína ọwọ́ rẹ̀. Torí èyí ni Olúwa Ọlọ́run rẹ ṣe pàṣẹ fún ọ láti ya ọjọ́ ìsinmi sí mímọ́. ");
INSERT INTO yor_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Bọ̀wọ̀ fún baba òun ìyá rẹ, bí Olúwa Ọlọ́run yín ti pàṣẹ fún ọ, kí ọjọ́ rẹ kí ó lè pẹ́, àti kí ó lè dára fún ọ ní ilẹ̀ tí Olúwa Ọlọ́run rẹ fi fún ọ. ");
INSERT INTO yor_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Ìwọ kò gbọdọ̀ pànìyàn. ");
INSERT INTO yor_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Ìwọ kò gbọdọ̀ ṣe panṣágà. ");
INSERT INTO yor_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Ìwọ kò gbọdọ̀ jalè. ");
INSERT INTO yor_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Ìwọ kò gbọdọ̀ jẹ́rìí èké sí ẹnìkejì rẹ. ");
INSERT INTO yor_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Ìwọ kò gbọdọ̀ ṣe ojúkòkòrò sí aya ẹnìkéjì rẹ, bẹ́ẹ̀ ni ìwọ kò gbọdọ̀ ṣe ojúkòkòrò sí ilé ẹnìkéji rẹ, oko rẹ̀, àti ọmọ ọ̀dọ̀ rẹ̀ ọkùnrin, àti ọmọ ọ̀dọ̀ rẹ̀ obìnrin, akọ màlúù rẹ̀ àti kẹ́tẹ́kẹ́tẹ́ rẹ̀, àti ohun gbogbo tí í ṣe ti ẹnìkéji rẹ.” ");
INSERT INTO yor_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Wọ̀nyí ni àwọn àṣẹ Olúwa tí a kéde rẹ̀ sí gbogbo ìpéjọpọ̀ ọ yín, níbẹ̀ ní orí òkè, láàrín iná, ìkùùkuu àti òkùnkùn biribiri, kò sì fi ohunkóhun kún un mọ́. Ó sì kọ wọ́n sínú wàláà méjì, Ó sì fi wọ́n lé mi lọ́wọ́. ");
INSERT INTO yor_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Nígbà tí ẹ gbóhùn láti inú òkùnkùn wá, nígbà tí iná náà ń yọ iná lala, àwọn aṣáájú ẹ̀yà a yín àti àwọn àgbàgbà yín tọ̀ mí wá. ");
INSERT INTO yor_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Ẹ sì sọ pé, “Olúwa Ọlọ́run wa ti fi ògo rẹ̀ hàn wá, àti títóbi rẹ̀ a sì ti gbóhùn rẹ̀ láti àárín iná wá. A ti rí i lónìí pé, ènìyàn sì lè wà láààyè lẹ́yìn tí Ọlọ́run bá bá a sọ̀rọ̀. ");
INSERT INTO yor_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Ṣùgbọ́n èéṣe tí àwa yóò fi kú? Iná ńlá yìí yóò jó wa run, bí àwa bá sì tún gbọ́ ohun Olúwa Ọlọ́run wa, àwa ó kú. ");
INSERT INTO yor_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Ta ni nínú ẹlẹ́ran ara tí ó ti gbọ́ ohun Ọlọ́run alààyè láti inú iná rí, bí àwa ti gbọ́ ọ, tí a sì wà láyé? ");
INSERT INTO yor_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Súnmọ́ tòsí ibẹ̀ kí o sì gbọ́ gbogbo ohun tí Olúwa Ọlọ́run wa yóò sọ, nígbà náà sọ ohunkóhun tí Olúwa Ọlọ́run wa sọ fún ọ fún wa. A ó sì fetísílẹ̀, a ó sì gbọ́rọ̀.” ");
INSERT INTO yor_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Olúwa ń gbọ́ nígbà tí ẹ̀yin ń bá mi sọ̀rọ̀, Olúwa sì sọ fún mi pé, “Mo ti gbọ́ ohun tí àwọn ènìyàn yí sọ fún ọ. Gbogbo ohun tí wọ́n sọ dára, ");
INSERT INTO yor_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","ìbá ti dára tó, bí ọkàn wọn bá lè bẹ̀rù mi, tí ó sì ń pa gbogbo òfin mi mọ́ nígbà gbogbo, kí ó bá à lè dára fún wọn, àti àwọn ọmọ wọn láéláé. ");
INSERT INTO yor_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“Lọ sọ fún wọn kí wọn padà sínú àgọ́ wọn. ");
INSERT INTO yor_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Ṣùgbọ́n ìwọ túbọ̀ dúró síbí pẹ̀lú mi, kí n bá à lè fún ọ ní àwọn àṣẹ tí o gbọdọ̀ fi kọ́ wọn láti máa tẹ̀lé ní ilẹ̀ náà tí èmi ó fi fún wọn láti ní.” ");
INSERT INTO yor_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Torí èyí, ẹ ṣọ́ra láti máa ṣe ohun tí Olúwa Ọlọ́run yín tí pa ní àṣẹ fún un yín; ẹ má ṣe yà sọ́tùn ún tàbí sósì. ");
INSERT INTO yor_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Ẹ rìn ní gbogbo ọ̀nà tí Olúwa Ọlọ́run yín ti pàṣẹ fún un yín, kí ẹ bá à le yè, kí ó sì dára fún un yín, kí ọjọ́ ọ yín bá à lè pẹ́ ní ilẹ̀ tí ẹ̀yin yóò gbà. ");
INSERT INTO yor_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Wọ̀nyí ni àwọn àṣẹ, ìlànà àti òfin tí Olúwa Ọlọ́run yín pàṣẹ fún mi láti kọ́ ọ yín kí ẹ lè kíyèsi i, ní ilẹ̀ náà tí ẹ ó ni lẹ́yìn tí ẹ bá kọjá a Jordani. ");
INSERT INTO yor_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Kí ẹ̀yin, àwọn ọmọ yín àti àwọn ọmọ wọn, lẹ́yìn wọn bá à lè bẹ̀rù Olúwa Ọlọ́run yín, ní gbogbo ìgbà tí ẹ bá wà láyé, nípa pípa àwọn ìlànà àti àṣẹ rẹ̀ tí mo fún un yín mọ́, kí ẹ bá à lè pẹ́ lórí ilẹ̀. ");
INSERT INTO yor_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Gbọ́ ìwọ Israẹli, kí o sì ṣọ́ra láti gbọ́rọ̀, kí ó bá à lè dára fún ọ, kí o bá à lè gbilẹ̀ lọ́pọ̀lọ́pọ̀ ní ilẹ̀ tí ń sàn fún wàrà àti fún oyin, gẹ́gẹ́ bí Olúwa Ọlọ́run àwọn baba rẹ ti ṣèlérí fún ọ. ");
INSERT INTO yor_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Gbọ́ ìwọ Israẹli, Olúwa Ọlọ́run wa, Olúwa kan ni. ");
INSERT INTO yor_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Fẹ́ràn Olúwa Ọlọ́run rẹ pẹ̀lú gbogbo àyà rẹ àti gbogbo ọkàn rẹ, àti gbogbo agbára rẹ. ");
INSERT INTO yor_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Àwọn àṣẹ tí mo fún un yín lónìí gbọdọ̀ máa wà lóókan àyà yín. ");
INSERT INTO yor_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Ẹ fi kọ́ àwọn ọmọ yín gidigidi. Bí ẹ bá jókòó nínú ilé, ẹ jíròrò nípa wọn, àti nígbà tí ẹ bá ń rìn ní ojú ọ̀nà, bí ẹ bá dùbúlẹ̀ àti nígbà tí ẹ bá dìde. ");
INSERT INTO yor_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Ẹ so wọ́n sí ọwọ́ yín fún àmì, ẹ so ó mọ́ iwájú orí yín. ");
INSERT INTO yor_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Kí ìwọ kí ó kọ wọ́n sára òpó ilé rẹ̀, àti sí ara ìlẹ̀kùn ọ̀nà òde rẹ. ");
INSERT INTO yor_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Nígbà tí Olúwa Ọlọ́run yín bá mú yín dé ilẹ̀ náà tí ó ti búra fún àwọn baba yín, fún Abrahamu, Isaaki, àti Jakọbu láti fi fún un yín, ilẹ̀ tí ó kún fún àwọn ìlú ńlá ńlá tí kì í ṣe ẹ̀yin ló kọ́ ọ, ");
INSERT INTO yor_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","àwọn ilé tí ó kún fún gbogbo ohun mèremère tí kì í ṣe ẹ̀yin ló rà wọ́n, àwọn kànga tí ẹ kò gbẹ́, àti àwọn ọgbà àjàrà àti èso olifi tí kì í ṣe ẹ̀yin ló gbìn wọ́n. Nígbà tí ẹ bá jẹ tí ẹ sì yó, ");
INSERT INTO yor_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ẹ ṣọ́ra kí ẹ má ṣe gbàgbé Olúwa, tí o mú un yín jáde láti Ejibiti wá, kúrò ní oko ẹrú. ");
INSERT INTO yor_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Bẹ̀rù Olúwa Ọlọ́run rẹ, Òun nìkan ni kí o sì máa sìn, búra ní orúkọ rẹ̀ nìkan. ");
INSERT INTO yor_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Ẹ̀yin kò gbọdọ̀ tẹ̀lé ọlọ́run mìíràn: ọlọ́run àwọn tí ó yí i yín ká; ");
INSERT INTO yor_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","torí pé Olúwa Ọlọ́run yín tí ó wà láàrín yín, Ọlọ́run owú ni, ìbínú rẹ̀ yóò sì run yín kúrò ní ilẹ̀ náà. ");
INSERT INTO yor_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Ẹ̀yin kò gbọdọ̀ dán Olúwa Ọlọ́run yín wò bí ẹ̀yin ti dán wò ní Massa. ");
INSERT INTO yor_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Ẹ rí i dájú pé ẹ̀ ń pa àwọn òfin Olúwa Ọlọ́run yín mọ́ àti àwọn àṣẹ àti àwọn ìlànà tí ó ti fún un yín. ");
INSERT INTO yor_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Ẹ ṣe èyí tí ó dára tí ó sì tọ́ lójú Olúwa, kí ó bá à lè dára fún un yín, kí ẹ̀yin bá à lè lọ láti gba ilẹ̀ dáradára náà tí Ọlọ́run ti fi ìbúra ṣèlérí fún àwọn baba ńlá a yín. ");
INSERT INTO yor_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Ẹ̀yin yóò sì ti àwọn ọ̀tá yín jáde níwájú u yín bí Olúwa ti ṣèlérí. ");
INSERT INTO yor_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Ní ọjọ́ iwájú, bí ọmọ rẹ bá béèrè pé, “Kí ni ìtumọ̀ àwọn àṣẹ, ìlànà àti òfin wọ̀nyí tí Olúwa Ọlọ́run wa ti pàṣẹ fún ọ?” ");
INSERT INTO yor_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Sọ fún un pé: “Ẹrú Farao ní ilẹ̀ Ejibiti ni wá tẹ́lẹ̀, ṣùgbọ́n Olúwa fi ọwọ́ agbára ńlá yọ wá jáde lóko ẹrú Ejibiti. ");
INSERT INTO yor_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Lójú wa ni Olúwa tí ṣe iṣẹ́ àmì àti iṣẹ́ ìyanu: tí ó lágbára tí ó sì ba ni lẹ́rù: lórí Ejibiti àti Farao, àti gbogbo ènìyàn rẹ̀. ");
INSERT INTO yor_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Ṣùgbọ́n ó mú wa jáde láti ibẹ̀ wá láti mú wa wọ inú àti láti fún wa ní ilẹ̀ tí ó ti fì búra fún àwọn baba ńlá wa. ");
INSERT INTO yor_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Olúwa pàṣẹ fún wa láti ṣe ìgbọ́ràn sí gbogbo ìlànà wọ̀nyí, láti bẹ̀rù Olúwa Ọlọ́run wa, kí ó ba à lè máa dára fún wa nígbà gbogbo, kí a sì lè wà láyé, bí a ṣe wà títí di òní. ");
INSERT INTO yor_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Bí a bá ṣọ́ra láti pa gbogbo òfin wọ̀nyí mọ́ níwájú Olúwa Ọlọ́run wa, bí ó ti pàṣẹ fún wa, èyí ni yóò máa jẹ́ òdodo wa.” ");
INSERT INTO yor_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Nígbà tí Olúwa Ọlọ́run rẹ bá mú ọ dé ilẹ̀ náà, tí ìwọ yóò wọ̀ lọ láti gbà, tí ìwọ yóò sì lé ọ̀pọ̀lọpọ̀ orílẹ̀-èdè kúrò níwájú rẹ. Àwọn ará Hiti, Girgaṣi, Amori, Kenaani, Peresi, Hifi àti àwọn ará Jebusi. Àwọn orílẹ̀-èdè méje tí wọ́n lágbára tí wọ́n sì pọ̀jù ọ lọ, ");
INSERT INTO yor_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","nígbà tí Olúwa Ọlọ́run rẹ bá sì ti fi wọ́n lé ẹ lọ́wọ́, tí ìwọ sì ti ṣẹ́gun wọn, kí ìwọ kí ó sì pa wọ́n run pátápátá. Má ṣe bá wọn ṣe àdéhùn àlàáfíà, ìwọ kò sì gbọdọ̀ ṣàánú fún wọn. ");
INSERT INTO yor_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Ìwọ kò gbọdọ̀ bá wọn dá àna. Àwọn ọmọbìnrin rẹ kò gbọdọ̀ fẹ́ àwọn ọmọkùnrin wọn, bẹ́ẹ̀ ni ìwọ kò gbọdọ̀ fẹ́ àwọn ọmọbìnrin wọn fún àwọn ọmọkùnrin rẹ, ");
INSERT INTO yor_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","torí pé wọ́n yóò yí àwọn ọmọ rẹ padà kúrò lẹ́yìn mi, láti jẹ́ kí wọn máa sin òrìṣà, ìbínú Olúwa yóò sì wá sórí rẹ, yóò sì run yín kíákíá. ");
INSERT INTO yor_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Èyí ni kí ẹ ṣe sí wọn, ẹ wó pẹpẹ wọn lulẹ̀, ẹ bi òpó òkúta ibi mímọ́ òrìṣà wọn lulẹ̀, òpó òrìṣà Aṣerah wọn ni kí ẹ gé lulẹ̀ kí ẹ sì sun ère òrìṣà wọn ní iná. ");
INSERT INTO yor_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Torí pé ènìyàn mímọ́ ni ẹ jẹ́ sí Olúwa Ọlọ́run yín, Olúwa Ọlọ́run yín ti yàn yín láàrín gbogbo ènìyàn lórí ilẹ̀ ayé, láti jẹ́ ènìyàn rẹ̀: ohun ìní iyebíye rẹ̀. ");
INSERT INTO yor_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Olúwa kò torí pé ẹ pọ̀ lọ́pọ̀lọ́pọ̀ ju àwọn ènìyàn yòókù lọ yàn yín, ẹ̀yin sá à lẹ kéré jù nínú gbogbo ènìyàn. ");
INSERT INTO yor_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Ṣùgbọ́n torí Olúwa fẹ́ràn yín, tí ó sì pa ìbúra tí ó ṣe pẹ̀lú àwọn baba ńlá yín mọ́ ni ó ṣe fi ọwọ́ agbára ńlá mú un yín jáde tí ó sì rà yín padà nínú oko ẹrú, àti láti ọwọ́ agbára Farao ọba Ejibiti. ");
INSERT INTO yor_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Nítorí náà ẹ mọ̀ dájúdájú pé Olúwa Ọlọ́run yín, Òun ni Ọlọ́run, Ọlọ́run olóòtítọ́ ni, tí ń pa májẹ̀mú ìfẹ́ rẹ̀ mọ́ fún ẹgbẹẹgbẹ̀rún ìran, àwọn tí ó fẹ́ ẹ tí ó sì ń pa àṣẹ rẹ̀ mọ́. ");
INSERT INTO yor_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Ṣùgbọ́n àwọn tí ó kórìíra rẹ̀ ni yóò san ẹ̀san fún ní gbangba nípa pípa wọ́n run; kì yóò sì jáfara láti san ẹ̀san fún àwọn tí ó kórìíra rẹ̀ ní gbangba. ");
INSERT INTO yor_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Nítorí náà ẹ kíyèsi láti máa tẹ̀lé àwọn àṣẹ, ìlànà àti òfin tí mo fun un yín lónìí. ");
INSERT INTO yor_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Bí ẹ bá ń kíyèsi àwọn òfin wọ̀nyí tí ẹ sì ń ṣọ́ra láti ṣe wọ́n, nígbà náà ni Olúwa Ọlọ́run yín yóò pa májẹ̀mú ìfẹ́ rẹ̀ mọ́ fún un yín, bí ó ti búra fún àwọn baba ńlá a yín. ");
INSERT INTO yor_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Yóò fẹ́ràn yín, yóò bùkún un yín yóò sì mú kí ẹ pọ̀ sí i. Yóò bùkún èso inú yín, ọ̀gbìn ilẹ̀ yín, oúnjẹ yín, wáìnì tuntun àti òróró yín, àwọn màlúù, agbo ẹran yín, àti àwọn àgùntàn, ọ̀wọ́ ẹran yín, ní ilẹ̀ tí ó ti búra fún àwọn baba ńlá yín láti fún un yín. ");
INSERT INTO yor_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","A ó bùkún un yín ju gbogbo ènìyàn lọ, kò sí ẹni tí yóò yàgàn nínú ọkùnrin tàbí obìnrin yín, bẹ́ẹ̀ ni kò sí ọ̀kan nínú àwọn ohun ọ̀sìn in yín tí yóò wà láìlọ́mọ. ");
INSERT INTO yor_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Olúwa yóò pa ọ́ mọ́ kúrò nínú ààrùn gbogbo, kì yóò jẹ́ kí èyíkéyìí ààrùn búburú tí ẹ mọ̀ ní Ejibiti wá sára yín, ṣùgbọ́n yóò fi wọ́n lé ara gbogbo àwọn tí ó kórìíra yín. ");
INSERT INTO yor_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Gbogbo àwọn ènìyàn tí Olúwa Ọlọ́run yín fi lé yín lọ́wọ́ ni kí ẹ parun pátápátá. Ẹ má ṣe ṣàánú fún wọn, ẹ má ṣe sin olúwa ọlọ́run wọn torí pé ìdánwò ni èyí jẹ́ fún un yín. ");
INSERT INTO yor_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Ẹ lè máa rò láàrín ara yín pé, “Àwọn orílẹ̀-èdè yìí lágbára jù wá lọ. Báwo ni a o ṣe lé wọn jáde?” ");
INSERT INTO yor_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Ṣùgbọ́n ẹ má ṣe bẹ̀rù wọn, ẹ rántí dáradára ohun tí Olúwa Ọlọ́run yín ṣe sí Farao àti gbogbo Ejibiti. ");
INSERT INTO yor_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Ẹ sá à fi ojú u yín rí àwọn àdánwò ńlá, àwọn iṣẹ́ àmì àti iṣẹ́ ìyanu ńlá, ọwọ́ agbára àti nínà ọwọ́ tí Olúwa Ọlọ́run yín fi mú un yín jáde. Olúwa Ọlọ́run yín yóò ṣe bákan náà sí gbogbo àwọn ènìyàn náà tí ẹ ń bẹ̀rù. ");
INSERT INTO yor_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Pẹ̀lúpẹ̀lú, Olúwa Ọlọ́run yín yóò rán oyin sáàrín wọn títí tí àwọn tí ó sálà tí wọ́n sá pamọ́ fún un yín, yóò fi ṣègbé. ");
INSERT INTO yor_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Ẹ má gbọ̀n jìnnìjìnnì torí wọn, torí pé Olúwa Ọlọ́run yín tí ó wà láàrín yín, Ọlọ́run alágbára ni, àti Ọlọ́run tí ó tóbi lọ́pọ̀lọ́pọ̀. ");
INSERT INTO yor_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Olúwa Ọlọ́run yín yóò lé gbogbo orílẹ̀-èdè wọ̀n-ọn-nì kúrò níwájú u yín díẹ̀díẹ̀. A kò nígbà yín láààyè láti lé wọn dànù lẹ́ẹ̀kan ṣoṣo. Kí àwọn ẹranko igbó má ba à gbilẹ̀ sí i láàrín yín. ");
INSERT INTO yor_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Ṣùgbọ́n Olúwa Ọlọ́run yín yóò fi wọ́n lé e yín lọ́wọ́, yóò sì máa fà wọ́n sínú dàrúdàpọ̀ títí tí wọn yóò fi run. ");
INSERT INTO yor_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Yóò fi àwọn ọba wọn lé e yín lọ́wọ́, ẹ̀yin ó sì pa orúkọ wọn rẹ́ lábẹ́ ọ̀run. Kò sí ẹni tí yóò lè dojú ìjà kọ yín títí tí ẹ ó fi pa wọ́n run. ");
INSERT INTO yor_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Dá iná sun àwọn ère òrìṣà wọn, ẹ má ṣe ṣe ojúkòkòrò sí fàdákà tàbí wúrà tí ó wà lára wọn. Ẹ má ṣe mú un fún ara yín, bí bẹ́ẹ̀ kọ́ yóò jẹ́ ìdẹ̀kùn fún un yín, torí pé ìríra ni sí Olúwa Ọlọ́run yín. ");
INSERT INTO yor_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Ẹ má ṣe mú ohun ìríra wá sí ilé yín, kí ìwọ má ba à di ẹni ìparun bí i rẹ̀. Ẹ kórìíra rẹ̀ kí ẹ sì kà á sí ìríra pátápátá, torí pé a yà á sọ́tọ̀ fún ìparun ni. ");
INSERT INTO yor_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Ẹ kíyèsi i láti máa tẹ̀lé gbogbo àṣẹ tí mo fún un yín lónìí, kí ẹ bá à le yè, kí ẹ sì pọ̀ sí i wọ ilẹ̀ náà, kí ẹ sì le gba ilẹ̀ náà, tí Olúwa fì búra ṣèlérí fún àwọn baba ńlá a yín. ");
INSERT INTO yor_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Ẹ rántí bí Olúwa Ọlọ́run yín ti tọ́ ọ yín ṣọ́nà ní gbogbo ọ̀nà ní aginjù fún ogójì ọdún wọ̀nyí láti tẹ orí yín ba àti láti dán an yín wò kí ó ba à le mọ bí ọkàn yín ti rí, bóyá ẹ ó pa òfin rẹ̀ mọ́ tàbí bẹ́ẹ̀ kọ́. ");
INSERT INTO yor_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Ó rẹ̀ yín sílẹ̀ nípa fífi ebi pa yín, Ó sì fi manna bọ́ ọ yín, èyí tí ẹ kò mọ̀, tí àwọn baba yín kò mọ̀, kí ó ba à lè kọ́ ọ yín pé, ènìyàn kò ti ipa oúnjẹ nìkan wà láààyè, bí kò ṣe ohun gbogbo tí ó jáde láti ẹnu Olúwa wá. ");
INSERT INTO yor_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Aṣọ yín kò gbó mọ́ ọn yín lọ́rùn bẹ́ẹ̀ ní ẹsẹ̀ yín kò sì wú, ní ogójì ọdún náà. ");
INSERT INTO yor_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Ẹ mọ̀ ní ọkàn an yín pé, bí baba ti ń kọ́ ọmọ rẹ̀, bẹ́ẹ̀ ni Olúwa Ọlọ́run yín ń kọ́ ọ yín. ");
INSERT INTO yor_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Nítorí èyí, ẹ gbọdọ̀ pa òfin Olúwa Ọlọ́run yín mọ́, nípa rínrìn ní ọ̀nà rẹ̀, àti bíbẹ̀rù rẹ̀. ");
INSERT INTO yor_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Nítorí pé Olúwa Ọlọ́run yín ń mú un yín bọ̀ wá sí ilẹ̀ rere ilẹ̀ tí ó kún fún odò àti ibú omi, pẹ̀lú àwọn ìsun tí ń sàn jáde láti orí òkè àti pẹ̀tẹ́lẹ̀. ");
INSERT INTO yor_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Ilẹ̀ tí ó kún fún jéró àti ọkà barle, tí ó sì kún fún àjàrà àti igi ọ̀pọ̀tọ́, igi pomegiranate, òróró olifi àti oyin. ");
INSERT INTO yor_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Ilẹ̀ tí oúnjẹ kò ti wọ́n, kò sí ohun tí ẹ̀yin yóò ṣe aláìní, ilẹ̀ tí irin ti pọ̀ bí òkúta, ẹ̀yin sì lè wa idẹ jáde láti inú òkè rẹ̀ wá. ");
INSERT INTO yor_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Nígbà tí ẹ bá ti jẹ tí ẹ sì yó tán ẹ yin Olúwa Ọlọ́run yín fún pípèsè ilẹ̀ rere fún un yín. ");
INSERT INTO yor_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Ẹ ṣọ́ra kí ẹ má gbàgbé Olúwa Ọlọ́run yín, nípa kíkùnà láti pa àṣẹ rẹ̀, àwọn òfin rẹ̀, àti àwọn ìlànà rẹ̀ tí mo ń fún un yín lónìí mọ́. ");
INSERT INTO yor_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Kí ó má ba à jẹ́ pé, nígbà tí ẹ bá jẹun yó tán, tí ẹ bá kọ́ ilé tí ó dára tán, tí ẹ sí ń gbé inú rẹ̀, ");
INSERT INTO yor_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","nígbà tí àwọn agbo màlúù yín àti tí ewúrẹ́ ẹ yín bá pọ̀ sí i tán, tí fàdákà àti wúrà yín sì ń peléke sí i, tí ohun gbogbo tí ẹ ní sì ń pọ̀ sí i, ");
INSERT INTO yor_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","nígbà náà ni ọkàn yín yóò gbéga, tí ẹ̀yin yóò sì gbàgbé Olúwa Ọlọ́run yín, tí ó mú un yín jáde láti Ejibiti wá, nínú oko ẹrú. ");
INSERT INTO yor_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Òun ni ó mú un yín la aginjù ẹlẹ́rù ńlá já, ilẹ̀ tí kò sí omi tí ó sì kún fún òǹgbẹ, pẹ̀lú àwọn ejò olóró ńlá ńlá àti àkéekèe. Ó mú omi jáde fún un yín láti inú àpáta. ");
INSERT INTO yor_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ó fún yín ní manna láti jẹ nínú aginjù,