﻿USE sofia;
DROP TABLE IF EXISTS sofia.yon_vpl;
CREATE TABLE yon_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yon_vpl WRITE;
INSERT INTO yon_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Yimin andowoon yiri kuu Godbed ambidiib okadiib ongmenaboon, ");
INSERT INTO yon_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","kumban okad kuu wuub nimingkindo, angkon kumkam maayiibban. Kwane kumun kumbed kebenoon. God ye Kingkin kuu ok animari wedyambed yarebeen. ");
INSERT INTO yon_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Godbed yedmoon “Namborok.” andoona namboroon. ");
INSERT INTO yon_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Namboroone, wedmekore “Amun kii.” andoon. Andekore, yembed nambiriyiib kumuniib kuu andokbe yeka yeka keroon. ");
INSERT INTO yon_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kwanekore, nambiri yaningko kuu “Awingyab” andekore, kumun yaningko kuu “Amnoom” ande keroon. Mirikne ware amkimo keroone, aron mimo keroon. ");
INSERT INTO yon_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kwanoone, Godbed yedmoon, “Ok yiri kuu yuka keruko, ok ari kuu yeka keroko, wedya kuu nuub yeman kerok.” andoona kwanoon. ");
INSERT INTO yon_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Godbed mindong yi dangimbon ongmekore ok ari dore ok yiri dore wedya kowoon. ");
INSERT INTO yon_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kowe Godbed mindong yi dangimbon yaningko kuu “Ambid” andoon. Mirikne ware amkimo keroone, aron ayoob keroon. ");
INSERT INTO yon_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kwanoone, Godbed yedmoon, “Ok yiri kuu kanmimyirimo keruko, bid kuu yaro angkimburuko.” andoona, kwanoon. ");
INSERT INTO yon_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Bid kuu “Okad” ande, ok kuu “Karamok” ande keroon. Kwane wedmekore “Amun kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kwanandekore yedmoon, “Aya kereeka nonga yuma oma mongkob animan maa maa animaibka animaibbanka korem dembok.” andoona, kwanoon. ");
INSERT INTO yon_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Yi korem kuu yi kawiib yowiib. Wedmekore, “Amun kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Mirikne ware amkimo keroone, aron ayoobmim keroon. ");
INSERT INTO yon_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kwanoone, Godbed yedmoon, “Nambiri kuu ambid arimbed menebok. Yi dowad kuu awingyab yemaniib amnoom yemaniib weeb kimingki yemaniib ");
INSERT INTO yon_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ambid arimbed okad yiri yuri yemaniib.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","aroniib woodiib mindongiib ongmenaboon. Aron kuu awingyab ye nambiri darewoob yeman. Wood kuu aron arebban amnoom ye nambiri embeng yeman. ");
INSERT INTO yon_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ongme dowan kerekore, ambid ari nongkoboon. Ambid ari nongkoboon kuu okad yiri yuri ye dowadiib, ");
INSERT INTO yon_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","awingyawiib kumuniib andokbi ye dowadiib nongkoboon. Yuriiwe, wedmekore, “Amun kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Mirikne ware amkimo keroone, aron kaning keroon. ");
INSERT INTO yon_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kwanoone, Godbed yedmoon, “Ok yiri dingkan maa maayiib muubnoko ayari on maa maayiib dembe ambid ari wanyarebime.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","karamok yiri ye dingkan miin kambari maa maayiib ok yiri dingkan yena koremiib kuu ongmenaboone ok yiri muubniwen. Ok yiri ye dingkan korem komarewa ongmenaboon kuu kwamunemo. Ayari on maa maa kangkon ongmenaboon. Ayari on korem komarewa ongmenaboon kuu kwamunemo. Wedmekore, “Amun kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Godbed yi yaa amun kerunde yedmendoon, “Yiib ok yiri ye dingkan kuu mana yemoon kere ok yiri muubne wonok. Ayari on yiib kangkon mana yemoon kere wonok.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Mirikne ware amkimo keroone, aron angko keroon. ");
INSERT INTO yon_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kwanoone, Godbed yedmoon, “Bid ari dingkan maa maayiib amongkowiib kiiwiib kuu okad yaambed dembenib yiib komarewa ongmenabaan kuu kwamunemo yemoon kerime.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","bid ari dingkan maa maa korem ongmenaboon. Dingkan korem komarewa ongmenaboon kuu kwamunemo. Wedmekore, “Amun kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kwanandekore yedmoon, “Nubbed nimakarub nuwareb ongmem. Yi kuu ok yiri ooniib ayari oniib dingkan kiiwiib amongkowiib darewoowiib embengiib dingkan korem yariman kerok.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Andekore, God ye kuruwak areb nimakarub ongmenaboon, ambiyiib yingkiyiib. ");
INSERT INTO yon_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Yi yaa kuu amun kerunde yedmoon, “Dana yemoon woongkanabime. Okad yimin yimin yaa muubnime. Okad kumundin yaa oonime. Dingkan korem kuu yariman kerime, ok yiri ooniib ayari oniib dingkan korem bid ari yarebimaiwiib kui.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kwanandekore yedmoon, “Kedi, yob irimaan yeman koremiib ayowiib yiib yaa kondaan, yiib animan kui. ");
INSERT INTO yon_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Bid ari dingkaniib ayari oniib dingkan korem bid ari yarebimaiwiib yaa kuu kereekiib bukiib kondaan, yi animan kui.” andoona, kwanoon. ");
INSERT INTO yon_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Godbed ongmenaboon korem yaa wedmendekore, “Korem amun yeman kii.” andoon. Mirikne ware amkimo keroone, aron benme keroon. ");
INSERT INTO yon_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kwane ambidiib okadiib kuna kuna dangoon ye kumkam korem ongmenabe dowan keroon. ");
INSERT INTO yon_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kowe, God kuu aron ed kuu deme korem dowan keroon kowe dibere yiidkoon. ");
INSERT INTO yon_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kwane, yembed aron kee amun kerunekore karadmo yeman ande kowoon, amborom kuu ongmenabi deme korem dowan keroon ye dowad dibere yiidkoon kowe. ");
INSERT INTO yon_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Kuye weng kuu Godbed ambidiib okadiib kumkam korem ongmenaboon ye weng kui.|H Yariman Godbed ongme dowan kerindo kuyaron kuu ");
INSERT INTO yon_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","yongbon kawa aya nonga kuu deedirindo amborom kuu am yedmindo kowe monokban keroon. Kwane kuyaa kuu karub maa yongbon kaab deme ambangkaneen ye karuwiibban. ");
INSERT INTO yon_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Am minindo kuned ok kuu okad yirimbed deedereen. Deedereenu, bid ari kuu okiib dange wuneen.|U ");
INSERT INTO yon_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kuyaron kuu okad aandune karub ongmene miiddem aombed inum konoone demboon. ");
INSERT INTO yon_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Demboone, Yariman Godbed aron dembimaun angka yongbon kaab arumoone demboon, Iden aom kuu. Arume dowan kerekore, kuyaom kuu karub ongmoon kuu kowoona doboroon. ");
INSERT INTO yon_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kwane, Yariman Godbed at amun maa maayiib dembok andoone daare wonoon kuu, at ani yemaniib wedme kubi yemaniib kui. Yongbon kidangka kuyaom kuu at ayoob demboon. At mimo kuu wadkeri ye at. At mamaa kuu arewa o amun inamen kaadkeri ye at.|H ");
INSERT INTO yon_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yongbon Iden kuyaombed ok kuu wene ari bokon kaningiib danganabeen. ");
INSERT INTO yon_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ok ibduruk doween kuu yaningko Paison, Havila ambibkin aom awanewandeen. ");
INSERT INTO yon_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Havila ambibkin aom kuu gold amuniib at nunung baeb amuniib od darewoob ye botiib dangoon.) ");
INSERT INTO yon_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ok mamaa yaningko kuu Gihon, Kus ambibkin aom awanewandeen. ");
INSERT INTO yon_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ok mamaa yaningko kuu Taigris, Asiria ambibkin kangkambed awanewandeen. Ok mamaa yaningko kuu Yufretes.|U ");
INSERT INTO yon_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yongbon Iden aom karub kuu Yariman Godbed kowoon ye dowad kuu oone dobere ambangki yeman. ");
INSERT INTO yon_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kwamune Yariman Godbed yedmoon, “Eb kuu ayob korem kee ananeeb kuu yimin, ");
INSERT INTO yon_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","kumban arewa o amun inamen kaadkeri ye ayob kuu anaab, kuu amob kowe. Ananeeb kuu anam bobnaneeb kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kwamune Yariman Godbed yedmoon, “Yembedmo dobiri kuu amunban kowe, nembed ye yaa awaneni ye angkodmiyiib ongmaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kwanekore, okad andune dingkan koremiib ayari on koremiib ongmenabe karub yaa benmonoona, yi aningko korem yeengkanandoon. ");
INSERT INTO yon_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Yeengkanande dowan keroon, kumban yangkodmi ma wedmindo. ");
INSERT INTO yon_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kwanoone, Yariman Godbed karub yaa meenoone unuk darewoob angkoone, karub ye anaatok mimo daandekore, ye kad ika ongmekore, ");
INSERT INTO yon_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","angkon anaatokbed wonong ongmekore, ye yaa nenmene ");
INSERT INTO yon_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","domonenoona, karub kuu yaro wedmendekore yedmoon, “Kwamune kowe, yu kono kuu ne konombed kandene, yu yom kuu ne yombed kandene keroon kowe, yu aningko kuu Wonong kowaan, amborom kuu karub yaambed kandoon kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kwamunekob, karub kuu yarian yaa domonde ye amban yoom dabokne yi ayoob kuu id mimo kerimaib. ");
INSERT INTO yon_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Yi ayoob ebkadiibban idmo doriib kuned karakiibban. ");
INSERT INTO yon_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yariman Godbed ongmenaboon ye dingkan korem yaa kuu niinbed nemengkandi kuu burudandoon. Kwane, niinbed wonong yaa kaamondoon, “Anam kuu Godbed ayob korem yaa kuu anaib ande amob kowoon dee?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Andoone, wonongbed niin yaa man yedmeen, “Nub kuu ayob korem kuu animaub kuu yimin, ");
INSERT INTO yon_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","kumban ayob mimo kee nub animokban Godbed amob kowoon nub yaa. Yembed yedmoon, ‘Anaib, awinaib. Kwane ananiib o awinaniib kuu bobnaniib.’ andoon.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Anduune, niinbed yedmendoon, “Dowan, anam kuu yiib kuu bobnaibban. ");
INSERT INTO yon_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","God yekaad yiib kuu ayob kee ananiib kuu yiib inamen nandaneene God areb keraniib. Kwane komo komo kuu inamen arewa o amun kuu kaadkeraniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Andoona, wonong ayob wedmeen kuu ani yeman amun dangoone wedme ani dowakeniib meeneen, “Ne dowaken kuu aneni meeni kangdom kandandid.” andekoru kande aneen. Anekoru, yu karuwiib kanwene konuune yeyiib anoon. ");
INSERT INTO yon_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ane dowan kerekoriwa, yi inamen nandoone wedme binangkiwen ebkadiibban idmo kowe. Kwani kowe, yi ayoob yedob biid wane kaarangke borokiwen. ");
INSERT INTO yon_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kwane, oobnon yaambed wengambiriiwe Yariman God kuu mongkob kidangkambed meneen. Wengamberekoriwa, awunumbon yaa bikniwen. ");
INSERT INTO yon_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Bikne doriiwe, Yariman Godbed karub yaa baande kaamonoon, “Kuna yaa doreeb?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Andoone, karubbed neman yedmoon, “Mongkob kidangkambed meneewe wengambaraan kowe, ebkadiibban idmo kowe uneni wene biknaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Andoone, Godbed kaamonoon, “Kanembed yedmebdoonkob ebkadiibban idmo doreeb? Ayob amob kowaan kuu anewenoo?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Andoone, karubbed neman yedmoon, “Wonong ebbed ne yaa kawewen kumbed ayob kee kawuune anaan kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Andoone, Yariman Godbed yu yaa kaamondoon, “Komarewa kwamewen kee?” andoon. Andoone, wonongbed man yedmeen, “Niinbed ne yaa nemengkawoone anaan kii.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kwani kowe, Yariman Godbed niin yaa yedmenoon, “Kwanewen kowe, eb kuu butun darewoob kandeeb, dingkan amongkowiib dingkan kiiwiib korem arebban. Kibirebyambed wene aron korem, eb kuu kabeyob din ingkud ari irin wananeeb. ");
INSERT INTO yon_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Dabab darewoob ke kowaan kee, eb yoom wonong yoom neman bon bon kamimamaniib kii. Kwani kowe, eb yob kuu wonong yu yowiib aron korem bon kerimamaniib. Yu yobbed eb korok kuu wowe monmaraneene ebbed yu yob ye yon daandum yaa domondaneeb.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kwanandekore, yembed wonong yaa yedmendoon, “Ongmaniina kub dana wooni yaron kuu yewed darewoob ariyiib. Dana woonaneeb kuu yewed darewoob kandaneeb kui. Kumban kub karub yaa dowaken keraneewe ye kuu kub korok keraneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kwanandekore, yembed Adam yaa yedmenoon, “Eb wonong yu weng wengamberekoreb anaib ande amob kowaan ye ayob kuu anewen kowe, okad kuu butun kande arewa keruun kii. Kwani kowe, ebkareb yongbon deme kuu yobdoodmo ambangkaneb ananeeb, kibikbed wene eb bobni yaron keranuun. ");
INSERT INTO yon_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kumban nongyikiib orikiib eb yongbon aom dembimamaneen kowe, animan kuu yiminban kerimamaneene dura animan bad wenebimamaneeb kii. ");
INSERT INTO yon_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ebkareb deme ambangke nimin kandenewe animan ananeeb. Eb kuu okadbed ongmaan kowe, bobnaneeb kuu okad keraneeb. Amborom kuu eb kuu ingkudmo kowe, bobnaneeb kuu ingkud ika keraneeb.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adambed yamban yu aningko Iv kowoon, amborom kuu yu kuu nimkarub korem yi ena kowe. ");
INSERT INTO yon_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kwani kowe, Yariman Godbed ba kadbed ebkad ongmekore, yi yaa bangkandoone borokiwen. ");
INSERT INTO yon_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kwane, Yariman Godbed yedmoon, “Karub kuu nuwareb keroon, komo komo kuu inamen arewa o amun kuu kaadkeroon kowe. Kwani kowe, yembed wadkeri ye ayob kuu kande ananeen kuu ne dowakenban, amborom kuu ananeen kuu bobnindeban keraneen kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Andekore, mongkob Iden aom kuu “Winime!” andoone bunangka winiwen. Winiiwe, Yariman Godbed yedmoon, “Eb kuu wene yongbon deme ambangke. Amborom kuu eb kuu okadbed ongmoon kowe. Yiib angkon mongkob Iden aom ika manaib, amob kowaan kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mongkob Iden kangkambed engyus ayoowiib kerewang arimbed amot yumbuyiib nongkoboone kerewang kuu kanawadmeen. Kerewang kee wadkeri ye at ye kiwaan ari kebenoon. ");
INSERT INTO yon_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam yamban yoom dangiiwe oyoomiib kereen. Kwanekoru, dana mingki wooneen. Woonekoru, yedmeen, “Yarimanbed awawoonkob mingki woone kandaan kii. Kwani kowe, yaningko kuu Kein.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Amaan, angkon dana mingki mamaa Abel wooneen. Abel kuu dingkan amongkob oonembirimaan. Kein kuu yongbon deme ye karub keroon. ");
INSERT INTO yon_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Amaanbed Kein kuu ye yongbonbed bene nengkane agedmo keroone baeb kuu Yariman yaa konoon. ");
INSERT INTO yon_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Kwane, Abel kuu ye dingkan wonob dana aye ye yom kowiib kumbed bunge kanmene nengkane agedmo keroone baeb kuu Yariman yaa konoon. Kwane, Abelbed konoon kuu Yariman ye dowaken kerenoon, ");
INSERT INTO yon_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","kumban Keinbed konoon kuu ye dowakenban kerenoon. Dowakenban keroone, Kein kuu norin ye murubia anammo keroon. ");
INSERT INTO yon_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kwanoone, Yarimanbed Kein yaa yedmenoon, “Eb kuu komandewed norin wandewen? Komoyiibkob norin ye murubia kerewen? ");
INSERT INTO yon_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Amun kamaneeb kuu dowaken kerubdaniine kubaneewoo? Kumban, amun kamaabban keraneeb kuu ambarakmimbed eb awinebdaneen. Ambarakmi inamenbed burudandubdandameen, kumban ebkareb ambarakmi yaa burudande dore!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kuye yoman kuu Keinbed ye daman yaa yedmenoon, “Mongkob angka wenem.” andoone winiwen. Wene dorekoriwa, ye daman kuu ayoone bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kwanoona, Yarimanbed Kein yaa kaamonenoon, “Eb daman Abel kuu kunaya doreen?” andoone, Keinbed neman yedmoon, “Nekaadban. Ne kuu ye oone dobiri ye karuwoo?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kwanandoone, Yarimanbed yedmenoon, “Komo kamewen kee? Wengambere. Eb daman ye umkan okad yiri kubudoroon kumbed ne yaa baandoona wengambaraan. ");
INSERT INTO yon_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kwani kowe, butun kabdaan kii, eb kuu yongbon deme awinideban amborom kuu ebbed eb daman aye wene ye umkan okad yiri kubudoroon kowe. ");
INSERT INTO yon_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Eb yongbon kuu dembaanban. Eb kuu nane kibine dobiri ye karubban kereeb! Eb kuu wedyamo dewenebi ye karub kereeb kii!” andoon.|H ");
INSERT INTO yon_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Andoone, Keinbed neman yedmoon “Kee dabab darewoob oi! Ne kuu yiminban! ");
INSERT INTO yon_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kibikee ne kuu yongbon deme ambangkideban, eb amob kaweeb kowe. Angkon ne kuu eb dia minideban. Ne kuu wedyamo dewenebi ye karub keraan kowe, karub mamaambed wedmewaneen kuu naneene bobnaniin!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Andoone, Yariman Godbed yedmoon “Dowan, kanembed eb aneen kuu neman karub kurubmim inaniin.” andoon. Kwane, Yariman Godbed Kein ye binad ari amob akmi yeman kowe yedmoon “Kane amob akmi yeman wedmenaneen kuu ayi yemanban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kwamunekore, Kein kuu Yariman God domonene wenene Dewenebi ambibkin angka doboroon. Aron dembimamuun angka Dewenebi ambibkin Iden yaa doboroon. ");
INSERT INTO yon_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kein yoom ye wonong yoom yi mingki Inok wooniwen. Kwanekore, Keinbed kambong nare yidmene ambib yenbekore kambong kuu ye karub dana yaningko Inok kowoon. ");
INSERT INTO yon_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Inok ye mingki kuu Irad. Irad ye mingki kuu Mehudyael. Mehudyael ye mingki kuu Metusael. Metusael ye mingki kuu Lamek. ");
INSERT INTO yon_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek kuu nima ayoob awanmoon, Adah yoom Silah yoom. ");
INSERT INTO yon_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adahbed dana mingki Yabal wooneen. Ye kuu dingkan amongkob ooni ye karub yi awoya. Yi kuu parai kombon aombed dobirimamiib. ");
INSERT INTO yon_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ye daman yaningko kuu Yubal. Ye kuu yok kuweng amun wangkenabi ye karub yi awoya. ");
INSERT INTO yon_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silahbed dana mingki Tubal-Kein wooneen. Ye kuu yeengbed kumkam korem ongmenabi ye karub. Ye nengkan kuu Naama. ");
INSERT INTO yon_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamekbed ye nima ayoob yaa daandoon “Wengambirime! Kewedmanbed noon kowe ayaane bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kwani kowe, Kein ayaniib ye kakman kuu karub kurubmimiib yeene inaniib, kumban ne naniib ye kakman kuu karub 77iib yeene inaniib kumbed yimin.” andoon.|U ");
INSERT INTO yon_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Amaanbed, Adam yoom ye wonong yoom dangiiwe karub dana maa wooniwen. Woonekoru, yedmeen, “Godbed ne yaa mimyob keewene karub dana maa kawoon. Dana kee Abel kuu Keinbed ayoon ye yumbon kandi yeman. Kwani kowe, ne dana yaningko Set yedma.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Angkon amaanbed Set yoom ye wonong yoom dana mingki Inos wooniwen. Kuyaron kumbed karub Yariman yaa baandi ye inamen andowiwen.|H ");
INSERT INTO yon_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adam ye awoya kuu kei. (Godbed karub kuu ye areb ongmoon. ");
INSERT INTO yon_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Karuwiib wonongiib ongmekore amuniib kerundoon. Kerundekore, yedmoon “Yiib kuu karuwa wononga kii.” andoon.) ");
INSERT INTO yon_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam kuu weeb 130yiib doberekore, ye mingki Set kuu woonoon. Ye kuu Adam areb. ");
INSERT INTO yon_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Kwanekore, Adam ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 800iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ye weeb korem kuu 930yiib doberene bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set kuu weeb 105iib doberekore, ye mingki Inos kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Kwanekore, Set ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 807iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ye weeb korem kuu 912iib doberene bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Inos kuu weeb 90yiib doberekore, ye mingki Kenan kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kwanekore, Inos ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 815iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ye weeb korem kuu 905iib doberene bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan kuu weeb 70yiib doberekore, ye mingki Mahalalel kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kwanekore, Kenan ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 840yiib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ye weeb korem kuu 910iib doberene bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel kuu weeb 65iib doberekore, ye mingki Yared kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Kwanekore, Mahalalel ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 830yiib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ye weeb korem kuu 895iib doberene bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared kuu weeb 162yiib doberekore, ye mingki Inok kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Kwanekore, Yared ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 800iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ye weeb korem kuu 962yiib doberene bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inok kuu weeb 65iib doberekore, ye mingki Metusela kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Kwanekore, Inok ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 300iib God ye dowakeniib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ye weeb korem kuu 365iib doboroon ");
INSERT INTO yon_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","kuned Godbed nendoon, amborom kuu ye kuu God ye murubia ari amunmo doboroon ye karub kowe. Kwani kowe, korem wonoon, okad yiri dobirindo. ");
INSERT INTO yon_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela kuu weeb 187iib doberekore, ye mingki Lamek kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Kwanekore, Metusela ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 782yiib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ye weeb korem kuu 969iib doberene bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek kuu weeb 182yiib doberekore, ye mingki kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Woonekore, Lamekbed yedmoon “Yariman Godbed arewa kondoon okad kiri kee kowe dana kee nub yaa awandi ye kiwaan ongmaneen. Kwani kowe, dana kee yaningko Noa andaan kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Kwanekore, Lamek ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 595iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ye weeb korem kuu 777iib doberene bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa kuu weeb 500iib doberekore, karub dana ayoobmim Sem yoom Hem yoom Yeefet yoom wanaboon. ");
INSERT INTO yon_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kuyaambed karuwa nimaya okad yemoon muubniwen. ");
INSERT INTO yon_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Kuye niindem aom kuu okad yiri ye nimakoyu kerengkandimboniib dobiriwen. God ye karubbed wedmibka nimakoyu kerengkandimbonmo kowe, ebka neka kame biwen. ");
INSERT INTO yon_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Angkon Yariman Godbed yedmoon “Kwana kowe, ne kuu kerendobaraina karub weeb darewoob dobaraibban, amborom kuu yi dobiri arewa keroon kowe. Weeb 120iib kwari burudande dobaraibban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Kurin kuyaron yaa dobiriwen kuu karub dareb dareb doboob doboob dobiriwen. Yi kuu God ye karubbed wene Godiibban yi nima biwen yi dana. Yi kuu kanangkod kayirin kamenabidan.|U ");
INSERT INTO yon_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Kwane, Yariman wedmoonka nimakarub yi dobiriyiib inameniib korem kuu miin arewamo keroon kowe ");
INSERT INTO yon_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","yedmoon, “Ne niindem aom miin kubiyiibban keroon, komande nimakarub ongmaankob okad yiri doriib? ");
INSERT INTO yon_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kwani kowe, nimakaruwiib dingkaniib ayari oniib korem kuu okad yirimbed araniin kumbed yimin, amborom kuu ne mimyob darewoob kowaan, komande ongmaanka.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kumban Yariman kuu ye kubi dowakeniib Noa yaa. ");
INSERT INTO yon_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Kekee Noa ye weng. Noa yembedmo inamen yorokmo awine doboroon. Kuyaron dobiriwen ye nimakarub kuu yembedmo ambarakmiyiib kii ande dedmone daandiyiibban ye karub keroon. Noamo kuu God ye murubia ari amunmo doboroon ye karub. ");
INSERT INTO yon_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ye karub dana ayoobmimiib kuu Sem yoom Hem yoom Yeefet yoom. ");
INSERT INTO yon_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Amunmo meenme doboroon kumban nimakarub korem korem kuu ambarakmiyiib ayub aya yaambed dobiriwen, God ye kiringkono ari. ");
INSERT INTO yon_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Godbed wedmoonka nimakarub yi dobiri korem kuu ambarakmimo. ");
INSERT INTO yon_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kwani kowe, Godbed Noa yaa yedmenoon, “Nimakarub korem monmaraniin, amborom kuu ayub aya yambedmo doriib kowe. Anamaa, nimakaruwiib okadiib monmaraniin. ");
INSERT INTO yon_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kwani kowe, ebbed at kamkonombed motod yenbe. Motod aombed ambinam yemoon ongmenabe. Angkon, at nunungbed motod aomiib angkayiib kuu ambe, ok aomnokban keri yeman. ");
INSERT INTO yon_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ku yenbaneeb kuu motod ye doboob kuu dingki bendom dore dingki birid dore kumbed kimingkanmo wene 300iib kere. Angkon, angkara angkara kuu dingki bendom dore dingki birid dore kumbed kimingkanmo wene 50iib kere. Angkon, yiri dore ari dore kuu kimingkanmo wene 30iib kere. ");
INSERT INTO yon_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ari kuu widbed kebene. Motod amkan dore ateni dore wedkuyaa nuub yeman ambongko dingki bendom dore dingki birid dore mimo aande. Ambongko mimo motod wedyambed aande. Motod aom kuu ambib yiriyiib ariyiib ayoobmim ongme. ");
INSERT INTO yon_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kedi, urok darewoob ongmaniina mananeen kumbed kane kane yi korem okad yiri wad doriib kuu duknaniib. ");
INSERT INTO yon_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kumban eb yaa ne weng ke yedme kowaan kei. Eb yoom eb karub dana yoom yiib amered yoom motod aom aomnaniib. ");
INSERT INTO yon_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ayari on maa maa koremiib dingkan maa maa koremiib wad doriib yeman maa maa koremiib ambiyiib yingkiyiib kuu menebiiwo motod aom be aomnekoreb oone. ");
INSERT INTO yon_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Wad doriib yeman maa maa korem yi animaniib yiib animaniib korem be nongkobe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noambed God ye weng kunduk dakmoon areb kuu korem kwanoon. ");
INSERT INTO yon_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kwane dowan kerekore, Yarimanbed Noa yaa yedmenoon, “Kibik yaron kuu ebbedmo amunmo doberewen kowe, eb yoom eb wonong yoom eb karub dana yi amered yoom motod aom aomnime. ");
INSERT INTO yon_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Dingkan ani yeman maa maa korem ambi ediib yingki ediib ayari on maa maa korem ambi ediib yingki ediib durukman ye dingkan maa maa korem ambi mimoyiib yingki mimoyiib be aomnibko oonime. Dingkan be aomne oonibko amaanbed yemoon kereniwe muubnaniib. ");
INSERT INTO yon_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Wene ari kuu aron ediib dowan keranuune nembed am darewoob yedmaniine mananuun. Aronki 40yiib amnoom 40yiib menembaranuun kii. Kwani kowe, nimakaruwa dingkana yi korem okad yiri dobirimaib kuu monmaraniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Andoone, Noambed Yariman ye weng kunduk dakmoon kuu korem kwamunemo kamoon.|H ");
INSERT INTO yon_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa ye weeb 600iib yaron kuu ");
INSERT INTO yon_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa yoom ye wonong yoom ye karub dana ayoobmim yi amered yoom motod aom aomniwen. ");
INSERT INTO yon_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","16","God ye weng kunduk dakmoon areb kuu dingkan korem amongkowiib kiiwiib darewoowiib embengiib ambiyiib yingkiyiib Noa yaa menebe motod aom aomnekoriwa, Yariman Godbed ambongko kebenoon. Aron ediib dowan keroon kowe, wood ayoob aron 17 arimbed kuu ok darewoob okad niindem yirimbed bangkanandedeerebeenan wunuune ambid arimbed am darewoob okad yimin yimin yaa munuune kameen kowe, urok muneen. Kuyaron kuu aron 40yiib am darewoob menembureen, amkiyiib aronkiyiib.|U ");
INSERT INTO yon_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Aronki 40yiib kuu urok derebeenu, motod kuu ok animari kanawaneen.|H ");
INSERT INTO yon_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Kanawanekoru, ok animari kanawadmenmo dewenebuun. ");
INSERT INTO yon_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Urok derebeenu, aangko darewoob korem kuu yukneen. ");
INSERT INTO yon_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Derebe dowan kerekoru, okad korem kuu yukneen. Aangko dungkunbed dingkimbed kimingkanmo wene ok animarimbed ye ambab kuu 15iib. ");
INSERT INTO yon_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","Yukne dowan keruune, wadkeri yeman korem karuwa dingkana korem kuu dukniwen.|U ");
INSERT INTO yon_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Nimakaruwiib dingkaniib ayari oniib, okad yiri wad doriibdan korem kuu monmare dowan keroon kuned, Noa awene yoom dingkan yoom motod aom aomniwendan kuu yimbedmo dobiriwen.|H ");
INSERT INTO yon_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Okad korem yukneen yaron kuu 150yiib. ");
INSERT INTO yon_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Noa awene yoom dingkan yoom motod aom aomniwen kuu Godbed nonondandindo. Kwani kowe, yedmoon “Nuub monok.” andoone monoone ok kuu igakman andowe keekne wuneen. ");
INSERT INTO yon_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Kwanoone, okad niindem yirimbed ok kuu menebuun kuu kebene am kebene keroone, ");
INSERT INTO yon_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","aron 150yiib kuyaron kuu ok ika keekne wuneen. ");
INSERT INTO yon_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Wood 7 aron 17 arimbed kuu motod kuu aangko Ararat ari angkibureen. ");
INSERT INTO yon_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ok keekne wuneene wood 10 arimbed kuu aangko maa maa kuu dian kereen. ");
INSERT INTO yon_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Wene aron 40yiib dowan keruune wene ari kuu Noambed bunangka wedmi yeman ambongko nandene ");
INSERT INTO yon_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ayari on binmo on kurud areb yaningko Reven kankoraroone wanwene ok animari wedyambed dewenebeen. ");
INSERT INTO yon_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Amaan on kawanmo on kawa areb yaningko Dav kankoraroon amborom kuu ok kuu keekne dowan kereen ande meenoon. ");
INSERT INTO yon_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kankoraroone wanwuneen kuned okad akmindo kowe, ika wanmuneen amborom kuu ok kuu keekne dowan kerindo kowe. Ika wanmunuune, Noambed nende motod aom kowoon. ");
INSERT INTO yon_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Wene aron ediib dowan keruune, on kawanmo ika kankoraroone, ");
INSERT INTO yon_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","wanyarebuune oobnembed ika wanmuneen kuu atbiidiib domone kanmuneen. Kwani kowe “Ok keekne dowan kereen yo.” ande meene yekaadkeroon. ");
INSERT INTO yon_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Wene aron ediib dowan keruune ika kankoraroone wanwuneen kuned kuu ika minindo. ");
INSERT INTO yon_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa ye weeb kuu 601iib kuyaron kuu wood mimo aron mimo keruune ok keekne dowan kereen. Kwanoone, Noambed wid yena bongme benkatmekore kerekanabe okad yiri wedmoon kuu okad kuu kamkono kere weneen. ");
INSERT INTO yon_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Wene wood ayoob aron 27 keruune, okad kuu kokne kamkono kere wuneen.|U (Aronki yemoon dowan keruune, urok kuu keekne dowan keroone okad kuu kamkono kere kereen.) ");
INSERT INTO yon_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kwane, Godbed Noa yaa yedmoon, ");
INSERT INTO yon_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Eb yoom eb wonong yoom eb karub dana yoom yi amered yoom ");
INSERT INTO yon_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","okad yiri yemaniib ayari yemaniib dingkan maa maa koremiib bunangka angkanime. Dingkan korem ke be angkaneeb kee wenebe yemoon kere muubnaniib kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kwanandoone, Noa yoom ye wonong yoom ye karub dana yoom yi amered yoom kuu bunangka angkaniwen. ");
INSERT INTO yon_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Angkaniiwa, dingkan maa maa korem kuu yeka yeka angkane wenebiwen. ");
INSERT INTO yon_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Angkon, Noambed bot wuube dingkan nengke agedmo keri yeman ye bon ongmekore, dingkan durukmanbaniib ayari oniib yaa maa maa bene kwari kiribekore, nengkane agedmo keroone baeb kuu Yariman yaa konoon. ");
INSERT INTO yon_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kwane, Yarimanbed kuyaa kuwekore yekareb yedmoon, “Amaan angkon okad kamune ne ika arewa kerundainban, kwane karubbed komo kamaniib yaa kui. Ne nekaad aron korem kuu nimakarub danambed wene aamkono yaa yi inamen kuu arewamo. Kumban, angkon nembed okad yiri wad doriibdan kuu angkon ika monmarainban, kibikee monmaraan kwamune.” andekore, ika yedmoon ");
INSERT INTO yon_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Aron kwane okad angkibaranuun yaa kuu animan kaab arumenabi yaroniib wanabi yaroniib, angkon yuruk aroniib nimin aroniib, angkon amaroniib yongkonbi aroniib, angkon amkiyiib aronkiyiib keremborok, dowan keraanban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kwane, Godbed Noa yoom ye karub dana yoom yaa amun kerunde yedmoon, “Yiib dana yemoon yidwarok. Okad korem muubnok. ");
INSERT INTO yon_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Dingkan koremiib ayari on koremiib okyiri oon koremiib kuu yiib yaa konob une dobirimamaniib. Yi kuu yiib dowakenmo komo kamaniib kuyaa kiribaana doriib. ");
INSERT INTO yon_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ne dingkan ye amob durukman bongmaan kowe, korem kuu ani yeman. Anuk kuu okad yirimbed kab kaini yeman ask: green plants kuu yiib ani yeman andaan kwamune areb kuu, kibikee dingkaniib ayari oniib okyiri ooniib korem kangkon yiib ani yeman andaan. ");
INSERT INTO yon_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Amob mimo kuu kei, dingkan id yaa umkaniib kwane anaib, amborom kuu umkanbed wadkeriyiib angkeen kowe. ");
INSERT INTO yon_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kanembed karub maa ayaneene bobnaneen kuu bobni ye dabab kandaneen. Dingkan kanembed karub ayaneene bobnaneen kwangkon bobni ye dabab kandaneen. ");
INSERT INTO yon_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Karub kuu God ye kuruwak areb ongmoon kowe, karub kanembed karub maa ayaneene bobnaneen kuu man kangkon karub yenambed aye kowaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kwanandekore, ika yedmoon, “Kwane, yiib kuu awoya dana yewudmo yidwarok, yiib kuu okad korem muubnok. Okad yiri yidwarok.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Weng kee Godbed Noa yoom ye karub dana yoom yaa yedmendoon, ");
INSERT INTO yon_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kedi, kibikee nekambed ne weng kunduk eb yoom eb awoya ari dobaraniibdan yoom yaa kondaan kii. ");
INSERT INTO yon_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Weng kunduk kee dingkaniib ayari oniib wadkeri yeman korem motod aombed angkadiriwen yaa kondaan. ");
INSERT INTO yon_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ne weng kunduk ke ongmaan kei, amaan ok urokbed wadkeri yeman korem ika monmarainban, kwane ok urokbed okad korem ika monmarainban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Kwanandekore, Godbed ika yedmoon, “Weng kunduk akmi yeman ke niinarikuru kei wiib wedaom kowaan, ne dore okad dore wedya kowaan kui. Weng kunduk akmi yeman kee kowaan kuu yiiwiib wadkeri yeman yenayiib korem yaa kowaan. Weng kunduk kuu nimakarub yaro dobere dobere yaro wananiib korem yiman. ");
INSERT INTO yon_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Komo aron amokambidiib ongmaniine niinarikuruyiib keraneen kuu, ");
INSERT INTO yon_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ne ika meenaniin ne weng kunduk yiib yoom dingkan maa maa korem yoom yaa kowaan kowe, angkon amaan ok urokbed wad doriibdan korem yainban andaniin.” andoon.|H ");
INSERT INTO yon_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ne kuu niinarikuru amukambiid ari wedmaniin kuu angkon ika meenaniin karuwiib dingkaniib yaa ne weng kunduk kowaan kuu. ");
INSERT INTO yon_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kukuu weng kunduk kuu wadkeri yeman yaa kondaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Sem yoom Hem yoom Yeefet yoom kuu Noa ye karub dana. Yi kuu motod aombed angkadiriwen. (Hem kuu Keenan ye awodki.) ");
INSERT INTO yon_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Karub dana ayoobmim kuyaambed karub korem yi awoya. ");
INSERT INTO yon_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa kuu yongbon deme ye karub kowe nong yob ibduruk yembed andowe kiiboon. ");
INSERT INTO yon_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kiiboona demboona, nong yob wande ondoobkekore, angkimberene wain ok keroona, wain ok kuu anoon. Anekore, awarak ayuuna ebkad biandekore, idmo ye kombon aom angkeen. ");
INSERT INTO yon_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hem Keenan yawodki kumbed yawodki Noa kombon aom idmo angkeena wedmenoon. Wedmenekore, wene ye ambanga ayoob yaa yedmendoon. ");
INSERT INTO yon_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem yoom Yeefet yoom tabua awine kankoone, yi kandom angkorom anuk kowe, kanwene yi angkorom korokbe weneniiwa kombon aom aomne yi awodki dabuneniwen. Yi murubia angkorom koniwen kuu yi awodki idmo angkeen kuu yi dowakenban wedmeni kuu. ");
INSERT INTO yon_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ok awarak dowan keroona, Hembed komo kamoon kuu Noambed wengamberekore, ");
INSERT INTO yon_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","yedmoon “Keenan yaa butun kamoon. Ye awoya kuu Hem ye ambanga ayoob yi awoya yi dabderem yirimo dobere yi dememo awine yaraniib.” andekore, ika yedmoon, ");
INSERT INTO yon_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","“Kubi konem, Sem ye Yariman God yaa. Keenan ye awoya kuu Sem ye awoya yi dabderem yiri dobere yi dememo awine yaraniib.” andekore, ika yedmoon, ");
INSERT INTO yon_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","“Godbed Yeefet ye okad kuu irin angkane darewoob kere. Kwane Sem yoom Yeefet yoom yi awoya kuu ibmo dobaraniib. Keenan ye awoya kuu Yeefet ye awoya yi dabderem yiri dobere yi dememo awine yaraniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Urok yondem kuu Noa kuu weeb 350yiib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ye weeb korem kuu 950yiib doberene bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa ye karub dana Sem, Hem, Yeefet urok kee ye yondem yi dana meed wanabiwen. ");
INSERT INTO yon_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yeefet ye karub dana kuu Gomer yoom Megog yoom Madai yoom Yavan yoom Tubal yoom Mesek yoom Tiras yoom kwane wanaboon. Kuyaambed ambibkin maa maa andowoon. ");
INSERT INTO yon_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer ye karub dana kuu Askenas yoom Rifat yoom Togarma yoom kwane wanaboon. ");
INSERT INTO yon_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavan ye karub dana kuu Elisa yoom Taasis yoom Kit yoom Rodan yoom kwane wanaboon. ");
INSERT INTO yon_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Keke Yeefet ye awoya ambibkin maa maa wenebe dobereniiwa weng maa maa dakmenabiwen. Yi kuu karamok dudbi ariyiib karamok kebed yayiib dobiriwen. ");
INSERT INTO yon_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hem ye karub dana kuu Kus yoom Misraim yoom Put yoom Keenan yoom kwane wanaboon. Kuyaambed ambibkin maa maa andowoon. ");
INSERT INTO yon_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus ye karub dana kuu Seba yoom Havila yoom Sabta yoom Raama yoom Sabteka yoom kwane wanaboon. Raama ye karub dana kuu Seeba yoom Dedan yoom kwane wanaboon. ");
INSERT INTO yon_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Nimrod kuu Kus ye mingki. Yembedmo nangmenmo wene okad yimin yimin yaa korok keroon. ");
INSERT INTO yon_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ye kuu dingkan yemoon bi ye karub keroon, Yariman God ye murubia ari. Kwanikob yikareb yedmimaib “Nimrod dingkan biman Yariman God ye murubia ari areb kerime.” andimaib. ");
INSERT INTO yon_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Yembed Babilonia ambibkin aom taun Babiloniib Erekiib Akadiib Kalneyiib kuyaambed ibduruk korok keroon. ");
INSERT INTO yon_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ambibkin kuyaambed wene Asiria ambibkin aombed taun Ninevayiib Rehobotiiyiib Kalayiib ");
INSERT INTO yon_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Reseniib yenbenaboon. Kambong Resen kuu Ninevayiib Kalayiib wedyirimbed yenbenaboon. Nineva taun kuu amaanbed darewoob kereen. ");
INSERT INTO yon_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim ye awoya kuu Ruddaniib Anamdaniib Lehabdaniib Naftudaniib ");
INSERT INTO yon_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusdaniib Kasludaniib Kaftordaniib. Kasludan yena andokbe yika dobereniib Filistiadan keriwen. ");
INSERT INTO yon_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Keenan ye awoya kuu Saidondaniib Hitdaniib ");
INSERT INTO yon_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusdaniib Amorodaniib Girgasdaniib ");
INSERT INTO yon_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivdaniib Arkdaniib Sindaniib ");
INSERT INTO yon_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvaddaniib Semardaniib Hamatdaniib. Saidon kuu Keenan ye wonob dana. Kwane yi awoya wenebiwen. ");
INSERT INTO yon_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Yi bid yimin kuu Saidonbed wene kuri kambong Kerar, kambong Kasa dia. Kwane wene kangka taun Sodomiib Gomorayiib Admayiib Seboyimiib, kambong Lasa dia. ");
INSERT INTO yon_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hem ye awoya kuu yi ambibkin maa maa yi amyenibon maa maa wenebe dobereniiwa yi weng maa maa dakmenabiwen. ");
INSERT INTO yon_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem kuu Yeefet ye daman. Sem ye awoya maa kuu Hibrudan. ");
INSERT INTO yon_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem ye karub dana kuu Elam yoom Asur yoom Arfasad yoom Lud yoom Aram yoom kwane wanaboon. ");
INSERT INTO yon_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram ye karub dana kuu Us yoom Hul yoom Geter yoom Mesek yoom kwane wanaboon. ");
INSERT INTO yon_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfasad ye mingki kuu Sela. Sela ye mingki kuu Eber. Eber ye awoya kuu Hibrudan. ");
INSERT INTO yon_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber ye karub dana ari wanaboon kuu Peleg yoom Yoktan yoom kwane wanaboon. Peleg yaron yaa kuu ambibkin maa maa andokbe yemoon keroon. ");
INSERT INTO yon_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan ye karub dana kuu Almodad yoom Selef yoom Hasarmavet yoom Yeraa yoom ");
INSERT INTO yon_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram yoom Usal yoom Dikla yoom ");
INSERT INTO yon_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal yoom Abimael yoom Seeba yoom ");
INSERT INTO yon_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir yoom Havila yoom Yobab yoom kwane wanaboon. Yi korem kuu Yoktan ye karub dana. ");
INSERT INTO yon_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Yi dobiriwen kuu kambong Mesambed wene kambong Sefar kangka aangko ambibkin yaa. ");
INSERT INTO yon_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sem ye awoya kuu yi ambibkin maa maa yi amyenibon maa maa wenebe dobereniiwa yi weng maa maa dakmenabiwen. ");
INSERT INTO yon_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Kuu Noa ye awoya kui. Kuyaambed urok yondem ambibkin korem yaa wenebe muubniwen.|U ");
INSERT INTO yon_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Kurin anuk kuu nimakarub korem kuu weng mimo dakmimaib, yeka yeka andokbindo. ");
INSERT INTO yon_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kuyaron kuu yi korem aron dembimaun angka awanawanmo yaronib wene okad dabon yiri Babilonia aom dobiriwen. ");
INSERT INTO yon_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Yi korem mene nedbenib yedmiwen, “Okadbed boyambib yeman ongmenabem. Ongmenabe aron nimin nongkobubko erebne kamkono kerok.” andiwen. Botban okadbed kwane ongmenabekoriwa, at nunung biwen, boyambib yeman dabokne awini yeman. ");
INSERT INTO yon_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kwamekoriwa yedmiwen, “Menebe boyambib yemoon taun keri dowad yenbenabem. Kwane, boyambib kongam darewoob yenbenmo daane ambid burudandem. Kwananuub kuu nub aningko kumbed darewoob keraneen. Nub aningkomo keruko okad yimin yimin yaa wenebe buyokbayok keraubban.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kwanoona, Yariman kuu ambib kongamiib tauniib yenbiib kuu wedmok kamene ");
INSERT INTO yon_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","wedmekore yedmoon, “Yi weng mimo kumbed kwane andowe ongmiib kowe, komo meene ongmandamaniib kuu kwane ongmaniib. ");
INSERT INTO yon_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kwani kowe, nub kawenenub yi weng amonombe weng maa maa yeka yeka keroko neman wengambere wengambere kerindeban kerok.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yarimanbed been buyokbayok keroona bidambib maa maa wenebene boyambib taun darewoob yenbiib kuu korondiwen. ");
INSERT INTO yon_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kowe, taun yaningko kuu Babel ande yedmiwen, amborom kuu Yarimanbed nimakarub korem yi weng amonombe weng maa maa kere wene karub kuu ben buyokbayok kere okad yimin yimin yaa nongkobenmo wonoon. ");
INSERT INTO yon_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sem ye awoya kuu kei. Urok yondem weeb ayoob dowan keroona, Sem ye weeb 100iib kerekore ye mingki Arfasad kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Kwanekore, Sem ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 500iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfasad kuu weeb 35iib doberekore ye mingki Sela kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Kwanekore, Arfasad ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 403yiib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela kuu weeb 30yiib doberekore ye mingki Eber kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Kwanekore, Sela ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 403yiib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber kuu weeb 34yiib doberekore ye mingki Peleg kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Kwanekore, Eber ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 430iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg kuu weeb 30yiib doberekore ye mingki Reu kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Kwanekore, Peleg ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 209iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu kuu weeb 32yiib doberekore ye mingki Serug kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Kwanekore, Reu ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 207iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug kuu weeb 30yiib doberekore ye mingki Nehor kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Kwanekore, Serug ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 200iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nehor kuu weeb 29iib doberekore ye mingki Tera kuu woonoon. ");
INSERT INTO yon_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Kwanekore, Nehor ye dana yenayiib ari wanaboon. Kuyaom doboroon kuu weeb 119iib doboroon. ");
INSERT INTO yon_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera kuu weeb 70yiib doberekore ye mingki Abram yoom Nehor yoom Haran yoom wanaboon. ");
INSERT INTO yon_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera ye awoya kuu kei. Tera kuu Abram yoom Nehor yoom Haran yoom yi awodki. Haran kuu Lot yawodki. ");
INSERT INTO yon_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Kwane Haran kuu ye taun Ur Babilonia ambibkin aombed bobnoon kuyaron kuu yawodki kuu doreen. ");
INSERT INTO yon_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram kuu Serai awanoona Nehor kuu Milka awanoon. Haran kuu Milka yoom Iska yoom yi awodki. ");
INSERT INTO yon_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Serai kuu kurong kowe yu dana kuu woonindo. ");
INSERT INTO yon_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Kwane, Tera yaro ye mingki Abram yoom ye awo Lot yoom Abram ye wonong Serai yoom kuu bekore Ur taun yaa koronde Keenan ambibkin yaa wene wedya Haran taun yaambed doboroon. ");
INSERT INTO yon_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera ye weeb korem kuu 205iib doberene bobnoon, Haran taun aom.|U (Weeb yemoon ari keruune, Noa ye dana mingki Sem ye awo aman ari Abram kuu wooneen.) ");
INSERT INTO yon_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kwane, Yarimanbed Abram yaa yedmenoon, “Ewambe yokadiib eb karubkimiib eb ambibkiniib domondekorewa, nembed ambibkin maa korokbebdaniin yaa wene. ");
INSERT INTO yon_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kwane, nembed eb awoya yemoon bangkabdaniina ambibkin yeweb kere yemoon kai keraniib. Kwane, amun kerubdaniin. Kwane, ongmaniina eb aningko kuu darewoob keraneen. Kwani kowe, eb yaambed yena kuu amun kerundaneen. ");
INSERT INTO yon_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Kanembed eb yaa amun kerubdaneen kuu nembed amun kerunaniin, kuned kanembed arewa kerubdaneen kuu nembed arewa kerunaniin. Eb yaambed ambibkindan korem yaa kuu amun kerundaneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Yarimanbed kwanandoone Abram wengamberekore kwanoon, ye kuu Haran taun angkambed Lot yoom domonde winiwen. Kuyaron kuu Abram ye weeb kuu 75iib. ");
INSERT INTO yon_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Yembed ye wonong Serai yoom ye daman ye mingki Lot yoom kuu ye deme karuwiib ye yiribman korem Haran angkambed booniib kuu be Keenan ambibkin yaa wonoon. Kwane wene Keenan ambibkin nandene, ");
INSERT INTO yon_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","wene More ye at kubun keedbon kambong Sekem dia kwane kuyaa doboroon. (Kuyaron kuu Keenandan kuu kuyaa doriib.) ");
INSERT INTO yon_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Doboroone, Yarimanbed wadbare angkaderene Abram yaa yedmenoon, “Ambibkin kee eb yob yaa kondaniin.” andoon. Kwanandoona, Abrambed bot wuuboon, Yarimanbed ne yaa angkadoroon kii ande korokbi yeman. (Abram yoom ye yoom winiwendan yoom kuu Keenan ambibkin aom dewinimaib, ye dingkan kab kuu kereek yemoon animaib kowe. Yi kuu ambib anam yenbenabindo, dingkan kadbed ongmiwen ye ambib kombon aombed dangimo kamen yariwen. Kwane, bidambib maa yaa wanande kaimaib kuu yi ambib kombon yeman kuu bedmenabe be kemo yi angkurom ari nongkobekorib bewinimaib.) (Yi kuu animan kab ma kibingkindo, dingkanmo bangkanandiwen. Yi dingkan yena kuu animaib, yena kuu ari berengkimaib, karub yena yi berengke yeen ani dowad. Kuye od kuu Abram ye nimakarub yoom kuu karub yena yaambed yongbon animan berengkimamiwen. Wiid yob kangkon berengkekorib flawa ongmenib bred nengkimamiwen.)|H ");
INSERT INTO yon_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Amaan angkon koronde kuri wene aangkobon ambibkin angka angkanoon. Kambong Betel kaom kere kambong Ai kangka kere wedyiri kombon be arume doboroon. Kuyaambed angkon bot wuube dingkan nengke agedmo keroone baeb kuu Yariman God yaa koni yeman ye bon wuubekore, kurikuriyiib kubiyiib Yariman God yaa konoon. ");
INSERT INTO yon_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kwane, mim kuyaamo dobirindo, wene kuyaambed dobere dobere Keenan aom kuri doboroon. ");
INSERT INTO yon_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Keenan ambibkin aom am kainoona animaniibban keroona mungimo dobereniiwa koronde anuk ambene wene Idyip ambibkin anuk wonoon. ");
INSERT INTO yon_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Wene Idyipdan yi okad dia aomnande yedmoon ye wonong yaa “Kub kuu kerengkandimbon kowe, ");
INSERT INTO yon_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Idyipdanbed meenaniib kuu kub kuu ne wonong ande meenenekoriwa, ne kuu nekoriwa, ub kuu nendaniib kowe, ");
INSERT INTO yon_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","minibka yedmende kub kuu ne daman ande. Kwane kub yaambed ne kuu nokban kere amun amun kamaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Andekore, Idyip bid aom aomnoona Idyipdan kuu ye wonong kuu wedmendiwen kuu kerengkandimbon wonong. ");
INSERT INTO yon_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kwane Idyip yi king Fero ye korok korok yena wedmendekoriwa, king yaa yedmeniiwa yembed yi yaa yedmendoone, wene Serai kuu nende king yambiwoom winiwen. ");
INSERT INTO yon_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Yu dowadbed Abram kuu kingbed ongme oonenoon. Kwane, sibi yemooniib naningkod yemooniib buromakau yemooniib donki yemooniib kemo yemooniib kakmaniibban deme ye karub yemooniib bangkanoon, Abram yaa. ");
INSERT INTO yon_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Serai nende yambiwoom kowoon ye dowadbed ye yoom yambiwoom karub doriib yoom yaa Yariman Godbed yi korem yaa korere darewoob maa maa kondoon. ");
INSERT INTO yon_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kwanoona, kingbed Abram yaa kaamonoon “Eb komo kamewen, ne yaa? Komoyiibkob Serai kuu ne wonong ande yedmewindo kerewen? ");
INSERT INTO yon_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Komande yu kuu eb daman andekorewa, yu kuu munuunkob ne wonong keraan? Eb wonong kei nenwene keyom koronde yaro wene!” andekore, ");
INSERT INTO yon_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","king ye korok korok yaa yedmendoona Abram nendeniiwa ye wonong nendeniiwa ye barang korem bekoriwa ambibkin kuyom kuu be wene bunangka domondiiwe winiwen. ");
INSERT INTO yon_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram yoom ye wonong yoom Lot yoom yi yiribman korem be Idyip ambibkin domonde ari wene Keenan ambibkin yaa winiwen. ");
INSERT INTO yon_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram kuu yiribman yemoon ye karub, sibiyiib naningkodiib buromakauiib od yeman silva yemooniib gold yemooniib boon. ");
INSERT INTO yon_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kwane angkon dobere dobere wene Betel kere Ai kere anukbed kombon be doboroon yaa ika monoon. ");
INSERT INTO yon_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Menekore, bot wuube dingkan nengke agedmo keroone baeb kuu Yariman God yaa koni yeman ye bon wuubekore, kurikuriyiib kubiyiib God yaa konoon.|U ");
INSERT INTO yon_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, ye kuu Abram yoom winiwenman, ye kangkon ye nimadanayiib deme karuwiib sibiyiib naningkodiib buromakauwiib. ");
INSERT INTO yon_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abram ye dingkan kawiib Lot ye dingkan kawiib kuu yemoon keroon kowe, kereek kirod dowan keroona yi ayoob ibmo dobiri yiminban keroon. ");
INSERT INTO yon_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kwane, Abram ye dingkan kab oonidaniib Lot ye dingkan kab oonidaniib arud weng dakmiwen. (Kuyaron kuu Keenandaniib Perisdaniib Keenan ambibkin aom doriib.) ");
INSERT INTO yon_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kwani kowe, Abrambed Lot yaa yedmoon, “Eb kuu ne daman kowe nub kuu wengbaraub, nub deme karub kangkon wengbaraib. ");
INSERT INTO yon_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Okad kumundin kemaombed nub dewenebi kuu yiminaa. Kwani kowe, nub kibikee andokbem. Eb dowaken an angka wene dobarande meenewen kuyaa wenebko, ne kuu wiwi angka wene dobarako. Eb dowaken wiwi angka wene dobarande meenewen kuyaa wenebko, ne kuu an angka wene dobarako.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kwane, Lot kuu indob kankoone darobe wedmoon kuu kankubunen yiri yaningko Yoodenbed wene kambong Soar yimin ok yemoon wedmoon, kukuu Yariman ye yongbon Iden areb Idyip okad areb. (Kuyaron kuu God kuu Sodom tauniib Gomora tauniib monmarindo.) ");
INSERT INTO yon_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kwane kuyaambed, Abram yoom Lot yoom kwane andokbiiwe, Lot kuu Yooden kankubunen yiri kangka angkanoon. ");
INSERT INTO yon_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Kwane, Abram kuu Keenan bid ari doboroona, Lot kuu wene Sodom taun dia kankubunen yiri doboroon. ");
INSERT INTO yon_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomdan kuu Yariman ye murubia ari miin arewa kame ambarakmi darewoob kamembirimaib. ");
INSERT INTO yon_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot wonoona kuye yoman Yarimanbed Abram yaa yedmenoon, “Ebbed doreeb kuyaambed indob kankoone kangka kere kaom kere kuri kere kari kere okad korem ongme wedme. ");
INSERT INTO yon_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Okad korem ke wedmeeb kee eb yoom eb yob yoom yaa kondaniin, aron korem. ");
INSERT INTO yon_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nembed eb yob yemoon bangkabdaniin kuu karub ma kimingke dorinban, ingkud korem kimingkindeban areb. ");
INSERT INTO yon_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Keenan okad korem kee eb yaa kabdaniin kowe, wene okad korem kee yimin yimin yaa dewene dore wedme.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kwanandoone, Abrambed Hebron aom wene Mamre ye at kubun keedbon dia wene kombon yenbe doboroon. Kwane, Yariman yaa meeni yeman ye bon botbed wuuboon.|H ");
INSERT INTO yon_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","4","Sodom taun yi king kuu Bera. Gomora taun yi king kuu Birsa. Kambong Adma yi king kuu Sinab. Kambong Seboim yi king kuu Semeber. Yi kaningiib yoom Soar yi king yoom, yi korok kuu Kedolaomer. Yembed oonoon kuu weeb wad ayoowiib dowan kereen kumban yikareb kerem ande meeniwen, yi king angkoyiib kuu. Kedolaomer kuu Elam ambibkindan yi king. Amrafel kuu Babilonia ambibkindan yi king. Ariok kuu Elasar ambibkindan yi king. Tidal kuu Goim ambibkindan yi king. Yi kaningiib yi ana nangmidaniib taun angkoyiib yi king yaa nangmok winiwen. Kambong angkoyiib yi ana nangmidaniib yi kingiib kankubunen yiri yaningko Sidim yaa nedbiwen. (Kibikee Sidim kuu karamok yaningko Ded Si.) ");
INSERT INTO yon_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","6","Weeb 14iib ari kuu Kedolaomer yoom ye king angkodmi yoom yi ana nangmidan yoom kambong Asterot Karnaim yaa wene Refaim karub yaa nangmene, kambong Hem yaa wene Sus karub yaa nangmene, kambong Save Kiriataim yaa wene Em karub yaa nangmene, aangko Seir ambibkin aom wene Hor karub yaa nangmene, kambong Elparan dia nangmeniwen. Kwanekoriwa, Kedolaomer yoom ye king angkodmi yoom yi korok keriwen. Kambong Elparan kuu amiibban koknoon ambibkin dia. ");
INSERT INTO yon_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kwanekoriwa, amonombe kambong Kades yaa wene Amelek karub korem yaa wene nangmene Amoro karub yaa kambong Hasason Tamar aom wene nangmeniwen. Kwanekoriwa, Kedolaomer yoom ye king angkodmi yoom yi korok keriwen.|U ");
INSERT INTO yon_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Aron maa, Sodoma Gomoraya Admaya Seboima Soara yi ana nangmidaniib yi kingiib kankubunen yiri yaningko Sidim yaa nangmok winiwen. ");
INSERT INTO yon_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Yi kuu Elamdan yi king Kedolaomer yoom Goimdan yi king Tidal yoom Babiloniadan yi king Amrafel yoom Elasardan yi king Ariok yoom yi ana nangmidaniib yaa nangmok winiwen. King angkoyiibbed king kaningiib yaa nangmok winiwen kui. ");
INSERT INTO yon_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kankubunen yiri yaningko Sidim kuu kolta bot dem yemoon dangoon. Nangmenib, Sodom yi ana nangmidan yoom Gomora yi ana nangmidan yoom yi king ayoob yoom kuu kirikmone wenenib dem yiri kirobiiwe, king yenayiib yi ana nangmidaniib kuu kirikmone wene aangko ari daaniwen. ");
INSERT INTO yon_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kedolaomer yoom ye king angkodmi ayoobmimiib yoom yi ana nangmidan yoombed Sodoma Gomoraya yi yiribmaniib yi animaniib korem kuu be winiwen. ");
INSERT INTO yon_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram ye daman ye mingki Lot kuu Sodom aom doreen kowe, ana nangmidanbed yeyiib ye yiribmaniib kangkon be winiwen. ");
INSERT INTO yon_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Karub mamaa kombere dore wenene komo keroon kuu Abram yaa daanoon. (Abram yaa kuu “Hibruman” andimaib. Ye kuu Mamre ye at kubun keedbon dia doboroon. Mamre yoom ye damana Eskol yoom Aner yoom yi ayoobmim kuu Amorodan. Yi kuu Abram yangkodmi.) ");
INSERT INTO yon_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram wengamboroone ye mingki Lot kuu bondanbed nenwiniwen kowe, ye nangmi karub korem 318iib benwene king kaningiib yaa nangmok wenene kambong Dan yaa nandekore, ");
INSERT INTO yon_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","amnoombed Abram kuu ye karub andokboone, wene nangmiiwa kirikmoniiwa nangmenmo wene kambong Hoba dia winiwen. Hoba kuu Damaskus taun burudande ari. ");
INSERT INTO yon_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kwane, Abram kuu benwiniwen ye yiribman koremiib Lotiib ye yiribmaniib Sodoma Gomoraya ye nimayiib nimakarub yenayiib be ika monoon. ");
INSERT INTO yon_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram kuu Kedolaomer awene yaa nangme burudande dorekore ika monoona, Sodom yi kingbed Abramiib yaa wedmenok wonoon, kankubunen yaningko Save yiri. ");
INSERT INTO yon_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kuyaron kuu Melkisedek kuu kambong Salem yi kingiib Korem Ari ye God dore karub dore wedyiri dobiri ye karuwiib. Kwane, yembed flawayiib nongyob ok ambodiib Abramiib yaa be menene, ");
INSERT INTO yon_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Abram amun kerunok ande yedmoon, “Korem Burudandoon Arimbed Ye God, ambidiib okadiib ongmenaboonman, Abram yaa amun kerunok. ");
INSERT INTO yon_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Yembed awabdoone nangmeneb burudandewen kowe, Korem Burudandoon Arimbed Ye God yaningko kankoonem.” andoon. Kwanandoone, Abrambed nangmene boon ye yiribman kuu andokbe wenore angko angkoyiib nongkobekore anded mimo kuu Melkisedek yaa konoon.|H ");
INSERT INTO yon_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Konoone, Sodom yi kingbed Abram yaa yedmoon “Nangmenib biwen yiribman kuu awine, kumban ne nimakarub kuu ika bangkawe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Andoone, Abrambed man yedmoon “Korem Ari ye Yariman Godbed yedmoonkob okadiib ambidiib kereen. Yaningko yaambed yedmaan kuu ");
INSERT INTO yon_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","eb yiribman kuu ma awinainban. Korem ebka bangkabdandamiin, ebkad nong o yonkad nong awinainban. Kwani kowe, ebbed kekane yedmaabban ‘Abram kuu nembed yiribman yemoon bangkanaan kowe, ye kuu yiribman yemoon ye karub keroon.’ andaabban. ");
INSERT INTO yon_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ne kuu eb yiribman ma kandainban, kuned ne karubkimbed ani yeman aniwen kumbedmo awinaniin. Ne angkodmia Mamre yoom Eskol yoom Aner yoom yimbedmo yi nangmenib biwen yiribman kuu bime.” andoon.|U ");
INSERT INTO yon_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kwane, amaan Yarimanbed Abram yaa wane korokbene yedmenoon, “Abram, eb unaab. Arud ye barang yaa kuu kombe areb kukbebdembaraniin. Ne kuu eb kakman amun miin darewoob keraan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Kumban, Abrambed yedmoon, “O Yariman Ambengkan, ne kuu danayiibban kowe, ne yaa kakman kuu komo kawaneeb? Ne yumbon kandaneen ye karub kuu ne deme karub Elieser, Damaskus ye karub kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kwanandekore Abrambed ika yedmoon, “Ebbed ne yaa danayiib kawindo kowe, ne deme karub yembed ne yumboniib yiribmaniib kuu baneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kwanandoone, Yarimanbed yedmenoon, “Eb deme karub kuu eb yumboniib yiribmaniib baanban. Eb bobnaneeb kuu eb dana mingki eb umkan anam kumbed eb yumboniib yiribmaniib kuu baneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kwanandekore, Abram nenwene bunangkambed yedmenoon, “Eb indob kankoone ambid ari wedme, mindong kimingke. Ebkareb kimingki kuu yiminoo? Eb awoya kuu mindong yemoon kwamune areb keraniib kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram kuu Yariman ye weng yaa anam ande meenoonkob, Yarimanbed ye dowad meenoon kuu “Ye kuu yorokmo ye karub ande kowaan kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kwanandekore, yembed Abram yaa yedmoon, “Ne kuu Yariman, Ur taun Babilonia ambibkin aombed nenyaro manaan ye id kuu okad kee eb yaa kabdandid.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kwanandoone, Abrambed kaamonoon, “O Yariman Ambengkan, komarewa kerenidned okad kuu neman keraneen kuu nekaadkeraniin?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Andoone, Yarimanbed yedmenoon, “Buromakau ingkod mimoyiib naningkod mimoyiib sibi ambi mimoyiib, yi korem kuu weeb ayoobmim dowan kereen kumbed, ayari on kawanmo mimo yaningko daviib ayari on kerekerek ingkod mimo yaningko pidyoniib kuu be mene.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kwanandoone, Abram kuu kuye dingkan yeene be monoon. Be mene, dingkan kuu wedyirimbed bunge baangkane angkara angkara nongkobekore, on kuu bunge baangkindo on maa angkara kowe on maa angkara kowoon, kiwaan wedyiri angkuun. ");
INSERT INTO yon_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Bob id animaib ye ayari on kumbed wanmene dingkan yom kuu anandamiiwa Abrambed wangmoon. ");
INSERT INTO yon_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Aron kuu kubune wenuune, Abram kuu unuk darewoob angkoone, kumun darewoob kebenenuune, uniwon karakwon keroon. ");
INSERT INTO yon_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kwane, Yarimanbed Abram yaa yedmoon, “Weng keyaa anam ande. Eb awoya ari kuu wene ambibkin mamaa yaa dobaraniiwe kuye ambibkindanbed yi ben kakmaniibban no deme awinembiridan kerundenib miin arewa kamendaniib, kwane dobaraniibbed wene weeb 400iib dowan keranuun. ");
INSERT INTO yon_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kumban, kwamendaniib ye kakman kuu nembed kuye ambibkindan yaa wengyundeni dabab kondaniin. Kwananiina, eb awoya ari kuu yiribman yemoon ben ambibkin yaro angkane wananiib. ");
INSERT INTO yon_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Kumban eb kuu keyaa yewenubmo dobere wene kiomne anam kerekoreb bobnaneewe mangkaniib. ");
INSERT INTO yon_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Eb awoya awoya kaningiib keraniib yaron yaa kuu ika mananiib. Kuyaron kuu Amoro ambibkindan yi dobiri arewa kuu darewoob keraneena dabab darewoob kondaniin kuyaambed eb awoya ari ika mananiib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kwanandoone, aron kuu kubune miriknoone, flawa nengki yeman amarengiib angkadkok amot yumbuyiib angkadere dingkan yom dangoone wedyirimbed dewonoone, ");
INSERT INTO yon_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Yarimanbed Abram yaa amob weng yedme kowoon, “Okad keembed kuri wene Idyip okad yimin, kari wene ok Yufretes yimin, eb awoya ari yaa kondaniin.” andoon.|H ");
INSERT INTO yon_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Okad kee Ken ambibkiniib Kenis ambibkiniib Kadmon ambibkiniib ");
INSERT INTO yon_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hit ambibkiniib Peris ambibkiniib kambong Refaimiib ");
INSERT INTO yon_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoro ambibkiniib Keenan ambibkiniib Kirgas ambibkiniib Yebus ambibkiniib kukui.” andoon.|U ");
INSERT INTO yon_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram ye wonong Serai kuu kurong kowe, yu deme no awinembiri ye Idyip wonong yu aningko Hagar konandameen kuu meeneen. ");
INSERT INTO yon_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Kwana kowe, Abram yaa yedmeen, “Yarimanbed ne dana nendi kiwaan kebenoon kowe, ne dowaken kuu ne deme no awinembiri ye wonong yoom dangime. Dana woonanuun kuu ne danayiib kera.” andeen. Seraimbed kwananduune Abrambed “Ee” andoon. ");
INSERT INTO yon_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kwana kowe, yumbed yu ambi Abram yaa Hagar konuune awanoon. Kuyaron kuu Abram awene kuu Keenan ambibkin aom weeb angko angkoyiib dobiriwen.|H ");
INSERT INTO yon_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Awanoona, Hagar kuu oyoomiib kereen. Oyoomiib keruune wedmekoru, kerengkan inamen kameenu Serai yaa karak kondeen. ");
INSERT INTO yon_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kwamune kowe, Seraimbed Abram yaa yedmeen “Hagarbed ne yaa karak kaween kuu ebbed ongmi yeman kii. Anam, nembed eb yaa kabdaan kumban oyoomiib kerekoru, ne yaa karak bangkawimamuun, kowe Yariman Godbed wengyundandok eb dee ne dee!” andeen. ");
INSERT INTO yon_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Anduune, Abrambed yedmoon “Eyoka, yu kuu kub deme ye kakmaniibban wonong kereene, ub kuu yu korok kowe, kubbed yu yaa komo kamaneeb kuu kub dowakenmo.” andoon. Seraimbed Hagar yaa wenbanduune koronde wuneen. ");
INSERT INTO yon_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Yariman God ye engyumbed wene Hagar yaa amiibban koknoon ambibkin aom kambong Sur ye kiwaan ari kirub okdobon yaa wengandene ");
INSERT INTO yon_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","yedmoon “Hagar, Serai yu deme ye kakmaniibban wonong, kuna yaambed menebko, kuna yaa weneeb?” andoone, man yedmeen “Ne kuu ne korok yaambed kombere dore meniin.” anduune, ");
INSERT INTO yon_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","yembed yedmoon “Angkon ika wene, yu deme ye kakmaniibban wonong ika kere. ");
INSERT INTO yon_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Nembed kub awoya yemoon bangkabdaniin kuu karub kane ma kimingkaanban.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","angkon ika amun kerune yedmoon “Kub kuu karub dana woonaneeb kuu yaningko Ismael andaneeb, amborom kuu Yariman Godbed kub ameng kami kuu wengamboroon. ");
INSERT INTO yon_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Kumban, kub karub dana kuu awon kiib areb dobaraneen. Ye kuu karub korem yaa bon keraneene karub korem kwangkon ye yaa bon kerunaniib. Ye karubkim yaa domonde yekamo dobaraneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Andoone, Hagar kuu God anam wedmenaan manok andeen. Kowe, Yariman God yaa yaningko baandeen “Wedmewewen ye God.” amborom kuu Godbed yu yaa daandoon kowe. ");
INSERT INTO yon_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kwanikob, okdobon yaningko kuu Beyalahairoi andimamiib. Okdobon kuu kambong Kades dore kambong Bered dore wedyiri angkuun.|U ");
INSERT INTO yon_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Amaan, Hagar kuu karub dana wooneene Abrambed dana yaningko Ismael andoon.|H ");
INSERT INTO yon_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Kuyaron kuu Abram ye weeb kuu 86iib.|U ");
INSERT INTO yon_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram ye weeb kuu 99iib keroone, Yarimanbed angkaderene yedmenoon, “Ne kuu Aromkono Darewoob Arimbed Ye God kowe, ne dowaken yaambed dobereneb eb yaa ambarakmoon kii ande kadwoniyiibban dobere. ");
INSERT INTO yon_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nembed eb yaa amob weng yedme kowaan kuu kwananiin. Kwane, eb awoya yemoon kai bangkabdaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram ye korok kankibene ye kiringkonombed okad badmendoone, Godbed ye yaa yedmenoon, ");
INSERT INTO yon_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Kedi, nembed kekane kamaniin kei. Ne amob weng yedme kowaan kuu kei, eb kuu ambibkin yemoon ye ambokab keraneeb kii. ");
INSERT INTO yon_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kibireb kei eb aningko Abram korondaan, kumban aningko yeeb Abraham kabdaan, amborom kuu ambibkin yemoon ye ambokab keraneeb kowe. ");
INSERT INTO yon_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Eb awoya yemoon bangkabdaniin. Eb awoya kuu yemoon kerenib andokbe ambibkin yena keraniib. Eb awoya yena kuu king keraniib. ");
INSERT INTO yon_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Amob weng kee aron korem eb yoom eb awoya yoom yaa angkimberembaraneen kuu ne kuu eb God angkon ne kuu eb awoya yi God. ");
INSERT INTO yon_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kibikee Keenan ambibkin okad kee eb okadban, kumban okad korem kuu eb awoya yaa kondaniine yiman keranuun, aron korem. Angkon, ne kuu yi God keraniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Godbed kwanandekore, Abraham yaa ika yedmoon, “Amob weng yedme kowaan kuu korobe awinime, eb yoom eb awoya ari yoom, yi yaro dobere dobere yaro wananiib aom kuu. ");
INSERT INTO yon_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Eb yoom eb awoya ari yoom yaa amob weng yedme kowaan kuu kei, karub dana korem kuu wekonokad wadmenabime. ");
INSERT INTO yon_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kad wadmi kuu eb dore ne dore amob weng yedme kowaan ye akmi yeman. ");
INSERT INTO yon_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Karub dana woonibka aron kaning kaningiib dowan keruko yi korem yi kad wadmenabime. Eb dana anam yoom, eb demedan yi dana yoom, owoddan yaambed deme no awinembiri ye dowad odbed moonaneeb ye dana yoom, eb dana anamban kui, yi kad wadmenabime. Kad wadmi ye amob weng kuu aron korem korem ye amob. ");
INSERT INTO yon_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Karub kanembed kad wadmindo kuu nembed yedme kowaan ye amob weng domokboon kowe, ye kuu dankarime.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Andekore, angkon ika yedmoon “Eb wonong yu aningko Serai kuu koronde, kumban aningko yeeb Sera ande. ");
INSERT INTO yon_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Yu yaa amun kerundaniin, angkon eb yaa yu yaambed dana mingki kabdaniine, yu kuu ambibkin yemoon yi awoya keranuun. Angkon, yu awoya yena kuu king keraniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Andoone, Abraham ye korok kankibene ye kiringkonombed okad badmendene meendobekore ambon kamoon. Ye meeni kuu “Karub weeb 100iib kuu danayiib keraneen dee? Sera weeb 90yiib kuu dana woonanuun dee?” ande meenekore ika demboon. ");
INSERT INTO yon_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Dembekore, God yaa kaamonenoon “Ismael kuu ne yumbon kandaneen kuu yimin dee?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Andoone, Godbed Abraham yaa yedmoon “Yii. Eb wonong Sera kuu karub dana woonanuun kuu yaningko Aisek ande. Ne weng kunduk kee ye yoom ye awoya yoom yaa kondaniin. ");
INSERT INTO yon_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Eb dowaken Ismael yaa wengamberekoreb, ye yaa amun kerunaniine dana yemoon keraneene, king wad ayoowiib yi awodki keraneen. Ye awoya yaa kuu ambibkin aromkonoyiib kerunaniin. ");
INSERT INTO yon_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kumban ne weng kunduk kuu Aisek yaamo konaniin. Ye kuu Serambed woonanuun weeb mimo dowan keranuun ari.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Dakme dowan kerekore, Godbed Abram domonene kawonoon. ");
INSERT INTO yon_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kuyaron kwarimbed Abraham kuu God ye weng wengamberekore, ye dana mingki Ismaeliib ye deme ye kakmaniibban ye karuwiib karub yambiwoom doriiwiib korem kuu kad wadmenabiwen. ");
INSERT INTO yon_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham ye weeb kuu 99iib dowan keruunkob kad wandiwen. ");
INSERT INTO yon_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Angkon, Ismael kwangkon ye weeb 13iib dowan keruunkob kad wandiwen. ");
INSERT INTO yon_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Aron mimo arimbed yi ayoowiib ye deme karub koremiib kuu kad wadmenabiwen. ");
INSERT INTO yon_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kuyaron kuu Abraham kuu Mamre ye at kubun keedbon dia ambib kombon yenbe doboroon. Kwane, aronkobbed Abraham kuu ye ambib kombon kiwaan ari diboroone Yarimanbed mene angkadoroon. ");
INSERT INTO yon_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Kwane, Abrahambed wedmoone karub ayoobmim kuu doriib. Wedmendekore, kirodmo wene wengandande wonoon. Wenene, ye korok kankibene ye kiringkonombed okad badmendene ");
INSERT INTO yon_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","yedmoon, “Ne yariman, eb dememan ne yaa dowakeniib kerebko, nambib yaa mene burudandaab. ");
INSERT INTO yon_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Yiib kuu ee andibka ok yunmonoko yiib yon ogekorib at kubun keyaom dibere yiidkime. ");
INSERT INTO yon_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ne angkon animaniib kanmanako, ane aromkono kandekoriwa yiib dowakenmo winime. Yiib dememan neyiib yaa miniwen kowe.” andoon. Andoone, yimbed inande yedmiwen, “Eyoka, eb weng dakmewen kuu kwamune kame.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Andiiwe, Abraham kuu kirodmo wene ambib kombon aom Sera yaa yedmendoon, “Kirod, flawa yemoon nengke.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kwanandekore, ye kirodmo dingkan doriib yaa wene buromakau mana kowiib kanmene kowoone ye deme karubbed kirod ayekore bunge nengkoon. ");
INSERT INTO yon_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kwane, Abrahambed naningkod muk ambod kodkobmo kerooniib naningkod muk ambodiib buromakau yomiib be karub ayoobmim yaa wene at kubun dem aombed nekwekore doboroone yi ayoobmim aniwen. ");
INSERT INTO yon_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Anekoriwa, yimbed Abraham yaa kaamoneniwen, “Eb wonong Sera gude?” andiwen. Kwanandiiwe, yembed yedmoon, “Yu kuu ambib kombon aom yakui.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yi ayoobmim ye karub maambed yedmoon, “Anam kuu wood wad ayoowiib ari kuu angkon ika mananiine eb wonong Sera kuu dana mingki woonanuun.” andoon. Sera kuu ambib kombon ye ambongko diambed wengambureen. ");
INSERT INTO yon_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","(Abraham yoom Sera yoom kuu kiomniwen kowe Sera yu dana nendi kuu yiminban.) ");
INSERT INTO yon_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kowe, Sera kuu yemyeb ambon kamenu yukareb yedmeen, “Dana nendi kuu kubi yeman kuned, ne kad kombaraan angkon ne korok kuu kiomnoon kowe, kwane kubaniinoo? Dowan.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kwananduune, Yarimanbed Abraham yaa yedmenoon, “Sera kuu komo andud ambon kamenu ‘Kiomnaan kuned dana nendaniinoo?’ andeen? ");
INSERT INTO yon_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nembed komo kamandamiin kuu kwananiin. Nembed yedmaan kuu wood wad ayoowiib dowan keranuune angkon ika mananiine Sera kuu dana mingki woonanuun.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sera kuu uneen kowe dude yedmeen, “Ne ambon kamindo.” andeen. Anduune, Godbed man yedmoon, “Yii, anam kuu ambon kamewen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kwaniiwe, karub ayoobmim kuu yaro dembenib Sodom taun yiri andowe winiwen. Kwane, Abraham kuu yi domondok wonoone, ");
INSERT INTO yon_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yarimanbed yedmoon, “Komo kamandamiin kuu Abraham yaa kuu biknenainban. ");
INSERT INTO yon_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ye awoya kuu ambibkin aromkono darewoob keraniib. Angkon, Abraham yaambed ambibkin korem kuu amun kerundaniin. ");
INSERT INTO yon_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ye kuu nembed kinaan kowe, yembed ye danayayiib ye awoyayiib yaa ne weng daandaneene wengamberekorib, inamen yorokmoyiib inamen yiminmoiib kamaniib. Kwamaniib kuu ye yaa ne weng kunduk yedmaan kuu kamaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kwanandekore, Yarimanbed Abraham yaa yedmoon, “Wengambaraan kuu Sodomiib Gomorayiib yi inamen kuu miin arewa kai, kwane yi ambarakmi kuu miin darewoob kai kowe, ");
INSERT INTO yon_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","nembed yiri wene weng kee anam dee anamban dee kuyaa wedmandamiin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Andoone, karub ayoob Sodom yaa winiiwe, Abraham kuu Yariman ye arinambo doboroon. ");
INSERT INTO yon_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abrahambed ye yaa yaro menene kaamonoon, “Ebbed arewa kamenabidan monmaraneeb kuu yorokmodan kangkon monmaraneewoo? ");
INSERT INTO yon_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Siti aom kuu yorokmodan 50iib keraneen kuu arewadaniib korem kuu monmaraneeb dee? Yorokmodan 50iib dobaraniib kuu taun domondaneeb dee yorokmodaniib arewadaniib ibmo monmaraneeb dee? ");
INSERT INTO yon_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Eb kuu okaddan korem ye Wengyundi Ye Karub kowe, yorokmo wengyundaneeb dee? Anamaa, ebbed ma kamaabban. Ebbed yorokmodaniib arewadaniib yaa ibmo wengyundande ukum mimo kondaabban, yorokmodaniib arewadaniib ben dabokne yenbandaawe duknaibban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Kwanandoone, Yarimanbed yedmoon, “Yorokmodan 50iib Sodom aom wedmaniin kuu taun kuu monmarainban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kwanandoone, Abrahambed God yaa inande yedmoon, “Ne kanangkod dakmaan kumban eb kuu Yariman, ne kuu karubmo, ingkud o yikbot areb. ");
INSERT INTO yon_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ma, yorokmodan 50iibban 45iibmo dobaraniib kuu komo kamaneeb? Karub angkoyiib kuyiibban kumbed taun kumundin monmaraneeb dee?” andoon. Kwanandoone, Godbed yedmoon, “Yorokmodan 45iib dobaraniiwe wedmaniin kuu monmarainban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kwanandoone, Abrahambed ika yedmoon, “Yorokmodan 40iib dobaraniib kuu komo kamaneeb?” andoone, Godbed yedmoon, “40iib dobaraniiwe wedmaniin kuu monmarainban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kwanandoone, Abrahambed God yaa yedmoon, “Yariman, ne yaa kongewaab, angkon ika dakmandamiin. Yorokmodan 30iibmo dobaraniib kuu komo kamaneeb?” andoone, Godbed yedmoon, “30iib dobaraniiwe wedmaniin kuu monmarainban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Kwanandoone, Abrahambed yedmoon, “Eb kuu Yariman kumban, eb yaa kanangkod dakmaan kuu amunban. Kumban, yorokmodan 20iibmo dobaraniib kuu komo kamaneeb?” andoone, Godbed yedmoon “20iib dobaraniiwe wedmaniin kuu monmarainban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kwanandoone, Abrahambed yedmoon, “Yariman, ne yaa kongewaab, angkon ika mimo dakmaniin kuu yimin dee? Yorokmodan angko angkoyiibmo dobaraniib kuu komo kamaneeb?” andoone, Godbed yedmoon, “Angko angkoyiib dobaraniiwe wedmaniin kuu taun kuu monmarainban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kwanandekore, Yariman kuu Abraham domonene wonoone Abraham kuu koronde ambiwoom ika wonoon. ");
INSERT INTO yon_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kuye oobnembed Lot kuu taun ye kuuk botbed wiriniwen yambongko yaambed diboroon. Kwane, engyus ayoob kee mene Sodom yaa miniiwe, Lotbed wedmendekore yaro wene ye korok kankibene ika dembe ");
INSERT INTO yon_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","yedmoon, “Ne korok korok ee! Ne kuu yiib yaa angkodmandamiin kowe nambiwoom minime. Yiib yon ogibko angkekoruwa, awari amkimombed wananiib kuu yimin.” andoon. Kwanandoone, yimbed yedmiwen, “Yii, taun kidangkambed amnoom kuu dobaranuuwe waraneen.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kwanandiiwe, Lotbed daande nangkandoone “Ee” andekoriwa, yambiwoom winiiwe, Lotbed ye deme karub yedmoone kabayingkindo ye flawayiib orok animaniib nengkiiwe nekwoone aniwen. ");
INSERT INTO yon_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Anekoriwa, amnoombed owoddan kuu dibiiwe, Sodom ye karub aamkonoyiib kewediib korem kuu mene yambib angkara awanewandiwen. ");
INSERT INTO yon_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Kwane, yimbed Lot yaa baande yedmiwen, “Karub kibik eb yoom doberem ande miniwen kuu kuna? Nub yaa benmenebko yi yaa nenem kamendem.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kwanandiiwe, Lotbed bunangka wene ambongko kebenekore ");
INSERT INTO yon_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","yedmoon, “Nangkodmia! Mokorondime, yiib kuu arewa kamendaib! ");
INSERT INTO yon_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ne dana koyu ayoob kuu karub yoom dangindo kumbed yiib yaa be mene domondaniine komo kamaniib kuu yiib dowakenmo. Kumban owoddan ayoob keyaa arewa kamendaib! Yi kuu nambiwoom miniwen kowe, nembed yi kukbaraniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kwanandoone, Sodomdanbed yedmiwen, “Angkane! Eb kuu nub ambibkinmanban kumban, eb kuu nub wengyundi korok kerandameewoo? Yiminban kii! Angkane! Angkanokban kuu yi ayoob yaa kuu arewa kerundanuub kuu burudande eb yaa kuu arewa darewoob arimbed kerubdanuub.” andiwen. Andekoriwa, Lot dedmonenib ambongko monmarande kamiwen. ");
INSERT INTO yon_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kumban owoddan ayoobbed bunangka yire Lot kuu angkon ika ambiwoom kirodmo binge wande nen aomnekorib, ambongko kuu kebeniwen. ");
INSERT INTO yon_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kwane, yimbed karub korem ambib bunangka doriib yi indob kuu kebengkiiwe, indob tut keroone, yi korem ambongko wedmindeban keriwen. ");
INSERT INTO yon_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kwanekoriwa, owoddan ayoobbed Lot yaa yedmiwen, “Eb kuu eb danayiib eb wonongkimiib eb karubkimiib taun keyaom doriib kee ben angkane, ");
INSERT INTO yon_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","amborom kuu taun kee monmarandamuub kowe. Yariman ye kiringkono arimbed ambarakmi yemoon keriwen kowe, yembed Sodom monmari dowad nub ben yuroone munuwen.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kwanandiiwe, Lot kuu wenene ye dana koyu ayoob awadmandamiib ye karub ayoob yaa yedmendoon, “Kirod minibko wenem, Yarimanbed taun kee monmarandameen kowe!” andoon, kumban ye kuu birondok monoon manok ande meeniwen. ");
INSERT INTO yon_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Warandameen yaambed, engyus ayoobbed Lot yaa yedmiwen, “Kirod! Eb wonong yoom eb dana koyu ayoob ke doriib kee yoom be angkane. Kirod angkanokban keraneeb kuu taun kee monmaranuuwe yiib kangkon duknaniib.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kwanandiiwe, kerebkarab kamoon kumban, Yarimanbed mimyob keenoon kowe, engyus ayoobbed ye yoom ye wonong yoom ye dana koyu ayoob yoom kuu taun bunangka be winiwen. ");
INSERT INTO yon_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Winiiwe, engyu ayoob ye karub maambed yedmoon, “Bobnaub ande kabaanmo winime! Ika anuk wedmaib! Kankubunen yiri wene yinmonaib! Kabaanmo wene aangko daanime! Kwamunaniib kuu duknaibban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kwanandoone, Lotbed yedmoon, “Ne korok, kwamunaabned, nub kuu yiminban ii! ");
INSERT INTO yon_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ebbed ne yaa dowakeniib keruwoon, kwane ne yaa amun kai kamewen kowe bobnainban. Kumban kombiri wene aangko daani kuu ne kuu yiminban kowe, neyiib monmaraneewe bobnaniin. ");
INSERT INTO yon_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kedi, kambong meb yaa kuu wedmeewoo? Kambong kuu dia kowe kombiri wananiin kuu yimin dee? Kambong kuu embengaa. Kukuu embengoo? Kambong embeng yaa wananiin kuu yimin andaneeb kuu bobnainban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kwanandoone, engyumbed yedmoon, “Ee, eweng kuu wengambaraan. Kambong ke dakmewen kee monmarainban. ");
INSERT INTO yon_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kowe, kirod kabaanmo wene! Ma kamainban, eb kuu wene yakuyaa nandaneeb kumbed.” andoon. Lotbed kambong kuu embeng andoon kowe yaningko kuu Soar andimaib. ");
INSERT INTO yon_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Aron kuu yaro menuune Lot kuu wene kambong Soar yaa wene nandoone, ");
INSERT INTO yon_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Yarimanbed yedmoone ambid arimbed bot sulfa amotiib taun Sodomiib Gomorayiib ari kirobeen. ");
INSERT INTO yon_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kwane, kankubunen yiriyiib nimakarub koremiib aya nonga buuk koremiib kuu monmaroon. ");
INSERT INTO yon_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kumban, Lot ye wonong kuu ika anuk wedmuune yu kuu karam kere at kongkab areb kereen. ");
INSERT INTO yon_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mirikne ware amkimo keruune, Abraham kuu uniyambed Yariman ye arinambo ari doboroon kuu ika wonoon. ");
INSERT INTO yon_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ye wene doberene Sodomiib Gomorayiib kankubunen yiriyiib yaa wedmoone, ambib yemoon amot denemoon yi amareng darewoob yeederebeen. ");
INSERT INTO yon_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Godbed Abraham yoom dakmiwen ye weng kuu nonondandindo kowe, Lot yaa awanenoone taun monmaroon kuu kombiri wonoon.|H ");
INSERT INTO yon_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot kuu kambong embeng aom dobiri kuu unoon kowe, ye yoom ye dana koyu ayoob yoom kuu koronde wene aangko daane aangko dem aombed dobiriwen. ");
INSERT INTO yon_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Angkaanbed nengkaan yaa yedmendeen “Nub ambe kuu kiomnoon. Angkon, nub yaa awani ye dowad kuu karuwiibban kowe, danayiib keraubban kii. ");
INSERT INTO yon_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Awarak ayi yeman ye ok yaningko wain konubko anekore awarak ayuko ye yoom dangenub danayiib kerem.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Anduune, amnoombed wain ok koniiwe anoone awarak ayuune angkaan yoom dangiwen. Awarakbed ayeen kowe komo kamoon kuu yekaadban. ");
INSERT INTO yon_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Awarimbed angkaanbed nengkaan yaa yedmeen “Ne yoom danguwen kowe, amnoom kuu angkon ika wain ok konubko anoko awarak ayuko kub yoom dangime. Nub ayoob kuu nub ambe yaambed danayiib kerem.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Anduune, amnoombed wain ok koniiwe anoone awarak ayuune nengkaan yoom dangiwen. Awarakbed ayeen kowe komo kamoon kuu yekaadban. ");
INSERT INTO yon_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kwanekoriwa, yi awodki yaambed oyoomiib keriwen. ");
INSERT INTO yon_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Angkaan kuu dana mingki woonekoru, yaningko Moab andeen. Moab kuu Moab ambibkin yi awoya. ");
INSERT INTO yon_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nengkaan kuu dana mingki woonekoru, yaningko Benami andeen. Benami kuu Amon ambibkin yi awoya. ");
INSERT INTO yon_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahambed Mamre ye okad yaa kuu domonde kuri wene Keenan ambibkin aom kambong Kades dore kambong Sur dore wedyiri doboroon. Amaan, kambong Gerar aom wene doberene ");
INSERT INTO yon_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","yedmoon “Sera kuu ne daman.” andimaan. Kwanoone, Gerar ye king ye aningko Abimelekbed ye deme karub yaa yedmoone, Sera kuu ye yaa nenwiniwen. ");
INSERT INTO yon_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Amnoom mamaambed kiyuum angkambed Godbed wene Abimelek yaa yedmenoon “Wonong kee awaneenbed nenminiwen kowe, bobnandameeb kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Kumban Abimelek kuu ayoob dangindo kowe, Yariman God yaa yedmoon “Ne ambarakmindo kowe, neyiib ne nimakarub koremiib monmaraneebdee? ");
INSERT INTO yon_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham yembed ne daman andoone angkon yu kangkon yembed yedmoon areb yedmeen kowe, inamen amunmo kere nendaan kowe, ne ambarakmindo.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Godbed kiyuum angkambed Abimelek yaa yedmoon “Ee, nekaadkeraan, eb kuu inamen amunmo kerewen kowe, ebbed ne yaa ambarakmaab andid kuu kebenaan, angkon yu yaa badmendaab andid kuu kebenaan. ");
INSERT INTO yon_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kwani kowe, kibireb kee ebbed wonong kuu domondene, yu karub yaa. Ye kuu ne weng dakmi ye karub kowe, yembed eb yaa kurikuri keraneene bobnaabban. Kumban, angkon ika konokban keraneeb kuu nembed yedmebdaan kuu eb yoom eb nimakarub yoom duknaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ware amkimo keruune, Abimelekbed ye korok korok baandoone menebiiwe kiyuum weng kuu dakmoone yi uni darewoob keriwen. ");
INSERT INTO yon_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kwani kowe, Abimelekbed Abraham baandoone monoone kaamonenoon “Eb kuu komo kamewen nub yaa kuu? Ne kuu eb yaa ambarakmindo kumbed ne yoom ne nimakarub yoom yaa dabab kee kondewen kuu komo dowad kerewen? Ebbed ne yaa ambarakmi darewoob kwamewen kuu kwamuwi yemanbanbed kwamuwewen. ");
INSERT INTO yon_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Komandewed kwamunewen?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahambed man yedmoon “Nembed meenaan kuu ambibkin kee ye karub korem kuu God yaa meenindodan kowe ne nene kowekorib, ne wonong nendaniib ande meenaan. ");
INSERT INTO yon_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Yu kuu ne daman anam amborom kuu nambe ye dana kowe. Kumban, awaan mamaa kowe, nembed awanaan. ");
INSERT INTO yon_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Godbed ne kuu daawoone wengamberekori, nambe yambiwoom kuu domonenekori, ambibkin mamaa yaa wanaan kowe, yu yaa yedmaan “Ne yaa inamen amun ye inamen keraneeb kuu ne yaa ‘Ye kuu nambang’ andimamaneeb.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Andoone, Abimelekbed Sera kuu Abraham yaa konekore, angkon sibiyiib buromakauiib ye deme no kakmaniibban awinembiri ye karuwiib baangkanekore, ");
INSERT INTO yon_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abraham yaa yedmoon “Keke ne okad kowe, eb dowakenmo kuna yaa dobaraneeb kuu kui.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sera yaa yedmoon “Nembed kub ambang yaa od yeman silva 1000iib konaniin kuu anam kub kuu ambarakmindo ande yi korem yikaadkeri yeman.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Andoone, Abrahambed God yaa kurikuri keroone Godbed Abimelek yoom ye wonong yoom ye deme no kakmaniibban awinembiri ye nima yoom yaa ongmoone wadkeriwen ");
INSERT INTO yon_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","amborom kuu Abimelekbed Sera nendoone yi kuu oyoomiib kerindeban, Yariman Godbed kebendoon kowe.|U ");
INSERT INTO yon_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Kwane, Yarimanbed Sera yaa komo yedmoon kuu kwanoon, kwane angkon yembed Sera yaa ye weng kunduk dakmoon kuu kwamunemo yu yaa kerundoon. ");
INSERT INTO yon_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Kowe, yu kuu oyoomiib kerekoru, Abraham kuu kiomnoon yaambed dana mingki wooneen. Dana wooneen kuu Godbed aron kowoon arimbed wooneen. ");
INSERT INTO yon_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham kuu Serambed wooneen ye dana mingki kuu yaningko Aisek ande kowoon. ");
INSERT INTO yon_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Aron kaning kaningiib dowan keruune, Abrahambed God ye weng yedme kowoon areb dana mingki kad wandoon. ");
INSERT INTO yon_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aisek wooneen yaron kuu Abraham ye weeb kuu 100iib. ");
INSERT INTO yon_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Kwane, Serambed yedmeen, “Godbed kube ambon kamiyiib kawoon kowe, kuyaa wengambaraniibdan korem kuu ne yoom kube ambon kamanuub.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Andekoru, ika yedmeen, “Karub maambed Sera yu dana woonenu oonenanuun andoonoo? Dowan, karub maa kwane andindo. Kumban, nembed Abraham kuu kiomnoon yaambed dana mingki woonaan.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Dana kaine muk animokban keroon yaron arimbed, Abrahambed orok darewoob ongmoone aniwen. ");
INSERT INTO yon_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Kwane, Ismael kuu Hagar Idyip wonongbed Abraham ye dana mingki wooneen kuu Aisek yaa daanimo kamoone, ");
INSERT INTO yon_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Serambed wedmekoru Abraham yaa yedmeen, “Dabderem yiri dobere no deme awinembiri ye wonongiib yu dana mingkiyiib kee yedmebko winime! Amborom kuu dana kee eb yiribman bi ye yumbon kandi kuu yiminban. Eb bobnaneeb kuu Aisekmo baneen.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kwananduune, Abraham kuu ye niindem aom miin yiminban keroon, amborom kuu Ismael kwangkon ye mingki kowe. ");
INSERT INTO yon_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kumban Godbed Abraham yaa yedmenoon, “Hagar yoom yu mingki yoom yaa miin yiminban keraab. Serambed yedmebduka wengambere kwane, amborom kuu eb yob kuu Aisek yaambed ande kowaniin kowe. ");
INSERT INTO yon_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nembed Hagar yu mingki yaa dana yemoon konaniine ambibkin mimodan keraniib, amborom kuu ye kwangkon eb dana kowe.” andoon.|H ");
INSERT INTO yon_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ware amkimo keruune, Abrahambed Hagar yaa animaniib ok yowo dingkan kadbed ongmiweniib kuu bene yu kandom ari nongkobekore, yedmendoone, yu mingki yoom winiwen. Amiibban koknoon ambibkin Berseba yaa kirinwanmo wuneen. ");
INSERT INTO yon_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ok dowan keroone, dana kuu at kubun aom kowuune diboroone ");
INSERT INTO yon_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","100 mita areb wenenu dibereenu yukareb yedmeen “Dana kuu bobnandameen kowe, ye bobni wedmaniin kuu ne dowakenban.” andeen. Andekoru, dibuun yirimbed ameng kamande kameen. ");
INSERT INTO yon_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Godbed dana ye ameng wengamberekore, ambid arimbed God ye engyumbed Hagar yaa dandoon “Komandewed meeni darewoob kerewen? Unaab! Godbed dana ye ameng kuu wengamboroon kowe. ");
INSERT INTO yon_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Dembe wene dana kuu nenkone nemengkane. Nembed ye awoya amun kerundaniine ambibkin darewoob keraniib.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Godbed yu indob nandoone okdobon wedmeen kowe, wene ok yowo aom yuundekoru, yu danayiib yunkonuune anoone wene okad maa doberekoriwa, ");
INSERT INTO yon_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","God kuu dana yaa oonenoone kainoon. Kaine, amiibban koknoon ambibkin yaningko Paran yaa doboroon. Dobere, anambed dingkan yenbandi ye karub keroon. ");
INSERT INTO yon_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Kainoone, yawaanbed Idyip wonong benuune awanoon. ");
INSERT INTO yon_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kuyaron kuu Abimelek yoom ye ana nangmidan yi korok yaningko Faikol yoom weneniiwa Abraham yaa Abimelekbed yedmenoon “Godbed eb yaa komo kamaneeb kuu dore awabdimameen. ");
INSERT INTO yon_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","God yaningko yaambed yedme kowe ebbed neyiib ne danayiib ne awoyayiib yaa nemengkandaab. Ne kuu eb yaa inamen amunmo meenimamiin kowe, neman kangkon ne yaa ambibkin kee doreeb aom kee God yaningko yaambed yedme kowe inamen amunmo meenimame.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Andoone, Abrahambed yedmoon “Ee, eb weng kuu God yaningko yaambed yedme kowaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Andekore, Abrahambed Abimelek yaa kongewoon okdobon ye dowad, amborom kuu Abimelek ye deme karubbed Abraham ye okdobon kuu kandiwen kowe. ");
INSERT INTO yon_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelekbed yedmoon “Nekaadban, karub kanembed kwamunoon? Eb kuu ne yaa yedmewindo kowe, kibirebmo wengambaraan kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Andoone, Abrahambed sibi yenayiib buromakau yenayiib kuu Abimelek yaa baangkanoone yi ayoob dakmenib amob ongmiwen. ");
INSERT INTO yon_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahambed ye sibi ediib be nongkoboone, ");
INSERT INTO yon_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelekbed ye yaa kaamonenoon “Komandewed kwamune kameeb? andoon. ");
INSERT INTO yon_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Andoone, Abrahambed yedmoon “Sibi ediib kee baneeb kuu anam nembed okdobon kuu nidkoon andi ye kumun.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kowe, okdobon yaningko Berseba andiwen, amborom kuu amob ongmiwen kowe. ");
INSERT INTO yon_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Amob ongme dowan kerekoriwa, Abimelek yoom Faikol yoom kuu angkon ika Filistia ambibkin yaa winiwen. ");
INSERT INTO yon_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Winiiwe, Abrahambed at kaab yaningko Tamaris Berseba yaa kibenekore, kurikuriyiib kubiyiib Yekawono ye Yariman God yaa konoon. ");
INSERT INTO yon_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham kuu Filistia ambibkin aom aron doboob doboroon.|U ");
INSERT INTO yon_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Amaanbed Godbed Abraham yaa kombon kaamonoon kuu kei. Yembed baandoon, “Abraham!” andoone, “Ne kei.” ande inandoon. ");
INSERT INTO yon_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kwane Godbed daanoon, “Eb dana mingki mimo, mimyob dowaken kerunewen ye dana Aisek kui, ye kuu bidambib Moraia aom nenwene. Kwane, ayekoreb ningkaneewa agedmo keraneene baeb kuu ne yaa kawe. Nembed aangko korokbebdaniin ari kumbed komo daabdaan kuu kwane.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kuye awari amkimo kai, Abraham yaro ye donki nekwene atok kuu nengkane agedmo keri ye dowad baangke ye donki ari nongkobe yerengke yuwekore, ye donkiyiib ye deme karub ayoowiib ye mingki Aisekiib be wonoon, Godbed bidambib yedmenoon yaa. ");
INSERT INTO yon_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Kwane wene aron ayoobmim arimbed, Abraham korok kankoone bidambib yedmenoon kuu ambabbed wedmoon. ");
INSERT INTO yon_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Wedmekore, ye deme karub yaa yedmendoon, “Yiib yoom donki yoom kiri dobirime. Ne yoom ne dana yoom kuu wene yakuyaambed kurikuri kere angkon ika yiiwiib yaa mananuub.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Andekore, atok be ye dana mingki bangkanoona karinoona, ye kuu wekiyiib amoyiib kuu yembed boona, yi ayoob winiwen. Wenoniiwa, ");
INSERT INTO yon_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisekbed awodki Abraham yaa yedmoon, “Ambe?” andoone Abrahambed inande “Ee ne dana, dakme.” ande yedmoon. Kwanandoona, Aisekbed kaamonoon, “Nub kuu amoyiib atokiib buwen kumban aye ningkane agedmo keri ye sibi kuu kuna?” andoona, ");
INSERT INTO yon_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahambed inande yedmoon, “Ne dana, Godbed yekarebmo sibi kuu kondaneena ningkanuuwa agedmo keraneene baeb kuu konanuub.” andoon. Kwane ibmo weniib. ");
INSERT INTO yon_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Wenenib Godbed bidambib kuyaa kii andoon yaa nandiwen. Nandiiwa, Abraham kuyaa bot be dingkan nengke agedmo keri yeman wuubekore, animari atok be nongkobekore, dana mingki Aisek kuu nong yerengkane kande atok animari kowekore, ");
INSERT INTO yon_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","weki kan oone ye dana mingki ayandamoon, ");
INSERT INTO yon_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","kumban ambid aombed Yariman ye engyumbed, “Abraham! Abraham!” ande baandoona, Abrahambed “Ee, ke doriin kei.” ande inandoon. ");
INSERT INTO yon_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kowe, engyumbed yedmoon, “Eb dana kuu ayaab! Kibireb kee eb wengambere anam ande kwami God yaa kuu wedmaan, eb dana mingki mimo kuu ebka amuknokban, ne yaa kuu.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Kwane, Abraham korok kankoone wedmoone sibi ambi durub yaambed amanayod dem aom angkanoon. Wedmekore, ye dana kuu dudmungkoone yaro demboone, sibi kuu Abraham ye dana ye dowad kande aye ningkane agedmo keroone baeb kuu God yaa konoon. ");
INSERT INTO yon_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kowe, Abrahambed aangko kuyaa aningko kuu “Yarimanbed kondimaan” ande kowoon. Kuyaronbed mene kibikee, kangkon kwane yedmimaib “Yariman ye aangko kwarimbed kondaneen.” andimaib. ");
INSERT INTO yon_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Angkon ika Yariman ye engyumbed ambid arimbed Abraham yaa baande ");
INSERT INTO yon_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","daanoon, “Yarimanbed yedmoon, ‘Eb dana mingki mimo kuu ne yaa kuu ebka awine amuknindo kowe, eb yaa neka naningko yaambed wiim aangke weng yedme kowaan kuu kei. ");
INSERT INTO yon_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Anam kuu eb yaa amun kerubdeni eb awoya yemoon kabdaniin. Yi kuu ambid ari mindong yemoon areb o karamok kebed yaa kubukbon mimmim kimingkindeban areb keraniib. Kwane yi bondan yi kambong kuu yimbed yeene burundadme dore oonaniib. ");
INSERT INTO yon_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Eb yob yaambed ambibkindan korem okad yimin yimin yaa kuu amun keendaniin, amborom kuu eb kuu ne weng wengamberewen kowe.’” andoon. ");
INSERT INTO yon_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Andoone, Abraham yoom Aisek yoom ye demedaniib yaa ika winiiwa igakman Berseba yaa yambiwoom winiwen. Kwane, Abraham kuyaa doboroon.|H ");
INSERT INTO yon_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Keke kwane dowan keroone, aron maa karub maambed Abraham yaa yedmoon “Eb aagorok Nehor yoom ye wonong Milka yoom kuu karub danayiib wanabiwen. ");
INSERT INTO yon_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Nehor ye mingki ibduruk kuu Us, kumbed kuu Bus, kumbed Kemuel (Amaan, Aram yawodki keraneen.), ");
INSERT INTO yon_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","kwane kuye yondem kuu Kesed, Haso, Pildas, Yidlaf, Betuel yoom wanabiwen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Amaan Betuel kuu Rebeka yu awodki keroon. Milka kuu karub dana kaning kaningiib kei wanabiwen, Abraham ye aagorok Nehor yaambed. ");
INSERT INTO yon_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Kwane, Nehor kuu karub dana yena kaningiib wanaboon, ye dungkud wonong Reumambed kuu. Yi aningko kuu Teba yoom Gaham yoom Tahas yoom Maaka yoom.|U ");
INSERT INTO yon_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sera dobureen yu weeb kuu 127iib ");
INSERT INTO yon_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","kwane bobneen, kambong Kiriat Arba aom, Keenan ambibkin aom. (Kibikee Kiriat Arba kuu Hebron andimaib.) Kwane, Abraham mimyob kowene bobon wene yu dowad ameng kamoon. ");
INSERT INTO yon_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ameng kamekore, ye wonong yu bob angkuun yaambed yaro Hitdan yaa dakmok wonoon. Dakme yedmoon ");
INSERT INTO yon_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ne kuu norod manaan kwane ne kuu owodman. Okad maa kawibko moonekori, ne wonong yu bob mangka.” andoona ");
INSERT INTO yon_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hitdanbed Abraham yaa inandiwen ");
INSERT INTO yon_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Angkodmi, wengambere. Eb kuu kayabak aromkono darewoowiib, nub aom kuu. Eb dowakenmo kuna yaambed nub bot bob mangkimbon amun kandaneeb kuu yimin. Nub kuu kane ye bot bob mangkimbon keya kee eb dowakenmo kandande meenewen kuu nub ma eb wonong yu bob mangki yaa kuu kebebdaubban.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Andiiwa, Abraham yaro dembekore Hit ambibkindan yaa bumangke kiringkonombed okad badmenekore ika demboon. ");
INSERT INTO yon_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Dembekore, yi yaa yedmoon “Yiib kuu ne yaa ‘Mangkaneeb kuu yimin’ anam andibka, Sohar ye mingki Efron yaa ne dowad kaamonime. ");
INSERT INTO yon_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Kaamonibko ye mongkob yerenbon yaa botdem yaningko Makpela kuu ne yaa moonoko, nembed ye od kumundin kuu komoyiib kowaneen kuu od amodane moona.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron kuu Hitdan numun dabokne yi taun kuuk darewoob wiriniwen yambongko kuye nedbimbon yaa dibiib. Yembed Hitdan yi arinambo arimbed Abraham yaa inandoon ");
INSERT INTO yon_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ne aamkono, kwamunemban. Wengambere, okadiib botdemiib kwaom kuu eb kabda, ne kambongdan kee anam kwanoon andi ye dowad nub weng wengambarande doriib. Eb wonong yu bob kuu mangke.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Andoone, Abraham ika yaro dembekore Hit ambibkindan yaa bumangke kiringkonombed okad badmenekore ika dembekore ");
INSERT INTO yon_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","karub korem yi arinambo arimbed Efron yaa yedmenoon “Ne yaa wengambere. Ne dowaken kuu okad kee kumundinmo od amodani, nod kee kandebko, ne bob kee kuyaa mangka.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Andoone, Efron Abraham yaa inandoon ");
INSERT INTO yon_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ne aamkono, ne yaa wengambere. Okad kuu yu kakman kuu od yeman silva 400iibmo kumban od kakman komoyiib kuye dowad wengbaraubban. Okad kuu kande, eb wonong yu bob mangke.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Andoone, Abraham ee andekore, Hitdan yi arinambo arimbed Efron yaa od konoon. Kumundinmo amodoon kuu od yeman silva 400iib od kimingkidan yaa korokbendoona kimingke anam andiiwa kowoon ");
INSERT INTO yon_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","kowe, Efron ye mongkobon okad Makpela aom, Mamre kangka, kuu taun kuuk ambongko yaambed Hitdan yi indob yi arinambo arimbed Abrahambed amodekore, okadiib botdemiib ayiib mongkoboniib kuu nekwane korem kwaom kuu yariman keroon. ");
INSERT INTO yon_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kwanekore, Abraham ye wonong Sera kuu mongkobon Makpela yu botdem aom mangkoon, Keenan ambibkin aom, Mamre dia. (Mamre kuu amaan ari Hebron andiwen.) ");
INSERT INTO yon_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kwani kowe, Abrahambed mongkoboniib botdemiib kuu Hitdan yaambed bobkonombon yeman okad moone amodoon. ");
INSERT INTO yon_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Kuyaron kuu Abraham kuu anam kiomnoon kumban Godbed od yemooniib animan yemooniib dingkan amongkob yemooniib deme karub yemooniib amun kerunoon kowe, ");
INSERT INTO yon_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","ye deme karub yembed yiribman korem oonoon ye korok yaa yedmoon “Ne dana ye awani dowad wonong kuu Keenan ambibkindan keye nimambed benaab. Kowe, nambibkin ne okad angka igakman wene ne karubkim doriib yaambed ne dana Aisek ye wonong kuu bene. Kwani kowe, ne dowaken kuu eb dingki kanmene ne yon muudkuk dabderem aom kowekore, Yariman God ambidiib okadiib ye God kuye aningko yaambed ne yaa kwananiin ande amob ongme.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Andoone, ye deme karubbed Abraham yaa kaamonoon “Wonong yu dowakenban mini korondanuun kuu komo keraniin? Kwamunanuun kuu eb danambed igakman eb ambibkin angka nenwananiin dee?” andoone, ");
INSERT INTO yon_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahambed yedmoon “Yii. Ne dana nambibkin kuyaa igakman kuyaa nenwanaab. ");
INSERT INTO yon_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yariman, Ambid Ari ye God, yembed nambe yambiwoom yaambed ne wooneen ye okad yaambed nenmonoon. Kwane weng kundukbed yedmewoon ‘Keenan ambibkin kee eb awoya yaa kondaniin.’ andoon kowe, Yariman God ye engyumbed yedin arinambo weneneena awabdaneena ne dana ye dowad wonong kuu kuyaambed nenmananeeb. ");
INSERT INTO yon_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Wonongbed eb yoom igakman mini kuu yu dowakenban keranuun kuu nub amob ongmuwen kuu eb dabab kandaabban. Kumban, ne dana mingki igakman nenwanaab.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kwane, ye dingki kuu ye korok Abraham ye mudkuk dabderem aom yiri kowene yedmoon “Weng kee dakmuub keye dowad kuu kwananiin.” ande amob ongmoon. ");
INSERT INTO yon_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kwane deme karub kuu ye korok Abraham ye yiribman amun amuniib be, Abraham ye kemo angko angkoyiib ari nongkobe yerengke yuwekore, kemoyiib be wonoon. Kwane wene Nehor ye taun Aram ambibkin ari wonoon. ");
INSERT INTO yon_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Wenekore, ye kemo kuu taun bunangka okdobon diambon nongkoboona bumangke dibere yiidkiwen. Kuyaron kuu oobnonya, nima ok yuungkok bad winimaib yaron. ");
INSERT INTO yon_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kwane yembed kurikuri keroon “Oo Yariman God, ne korok Abraham ye God, kibik aron kee ne yaa ne korok ye dana ye dowad wonong kawe, eb amob ne korok yaa ongmewen kwananeeb kuu amun yeman, ne korok yaa. ");
INSERT INTO yon_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ne kee doriin kei, okdobon dia. Okdobon kee kibireb yaa taundan yi dana meed nima koyumbed mene yuungkimaib. ");
INSERT INTO yon_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Wonong eb deme karub Aisek ye dowad kowewen ne nekaadkeri yeman kuu kui. Yu mananuun kuu ‘Ok maa yunkawebko ana.’ andaniina yedmanuun ‘Ok ane. Angkon, nembed eb kemo ok bangkanda.’ andanuun. Kwananuun kuu eb weng kunduk ne korok yaa kwananeeb kuu nekaadkeraniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Andeene, Rebeka kuu ok pot darewoowiib kandom ari karine menuun. Yu kuu Abraham ye ayi Nehor yoom ye wonong Milka yoom yi mingki Betuel ye mungkan. ");
INSERT INTO yon_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Yu kuu koyu kerengandimbon amun yeman, angkon karub yoom dangindo. Kwane dewene okdobon yiri kubune ok yuundekoru muneen. ");
INSERT INTO yon_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Dewunuune, deme karub kirodmo angkane yedmoon “Ok maa yunkawaneewa ananiin kuu yimin dee?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Andoone yedmeen “Ee, aamkono, ok ane.” andekoru kirodmo ok nande yiri kowekoru ok koneen. ");
INSERT INTO yon_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kwane ane dowan keroone, yedmeen “Eb kemo kwangkon ok bangkanda.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kwane, kirodmo ok ani yeman yabad aom bunekoru angkon kirodmo wenenu ok yena ika bune yuungkane kemo kuu ok bangkanduune aniwen yimin. ");
INSERT INTO yon_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kwane karub kuu iwari kwane doberene kerendoboroon, anam Yariman Godbed wonong kee kondoon dee kuyaa komboon darobeen. ");
INSERT INTO yon_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kemo ok ane dowan keriiwa, karub kuu yaro gold kumkum kande yu yangdem yaa derenendekore gold yeed ayoob been yu dingki ari deebendoon. ");
INSERT INTO yon_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kwane, kaamondoon “Kub ambe kuu kane? Yambiwoom ne yoom ne karub yoom kibik amnoom kuu ye yoom danganuub kuu yimin dee?” andoone ");
INSERT INTO yon_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","yedmeen “Nambe kuu Betuel, Nehor yoom Milka yoom yi mingki. ");
INSERT INTO yon_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Dingkan yi animaniib yi dangimboniib yiib kwangkon yiib dangimboniib nub ambiwoom kuu.” anduune ");
INSERT INTO yon_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","karub kuu yiri bumangke Yariman God yaa yubudkane ");
INSERT INTO yon_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","yedmoon “Kubem, Yariman God yaa, ne korok ye dowad kuu Godbed ye weng kunduk yaamo kwane ambangkoon. Yariman God kuu nenmene ne korok Abraham ye karubkim doriib yaamo nenmonoon.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kwane, Rebeka kuu kabaanmo wene ambiwoom awaan awene yaa komo keroon kuu kwane dandeen. ");
INSERT INTO yon_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebeka kuu yu ambangiib, yaningko kuu Leban. Ye kuu gold kumkumiib gold yeed ayoob deebeeniib wedmekore, yu weng wengamberekore, kirodmo wene wedmoone karub kuu kemoyiib okdobon diambon yaa doriib. ");
INSERT INTO yon_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Wene wedmendekore, yedmoon “Yiib minime, yiib Yariman Godbed amun kwendoondan yiib komande keyaa doriib? Yiib dowad nambib kuu nekwendaan, yiib kemo kwangkon yi dangimbon nekwendaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Andoone, karub kuu wene yambiwoom aomniiwa, kemo ari yiribman kuu Lebanbed be okad yiri nongkobekore, kemo kuu yi animaniib yi dangimboniib kondoon. Kwane ok yunmonoon Abraham ye demedan yi yon ogi yeman. ");
INSERT INTO yon_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kwane animan bemene yi arinambo ari woriwen kumban Abraham ye deme karubbed yedmoon “Animan anainban. Ibduruk kuu nembed komo mene manaan kuu yiib yedmendekorid, yoman ananiin.” andoone, Lebanbed yedmoon “Dakme.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Andoone yedmoon “Ne kuu Abraham ye deme karub. ");
INSERT INTO yon_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yiribman yemoon Godbed ne korok yaa amun konoone ye kuu yiribman yemoon ye karub keroon. Yiribman yemooniib, sibi yemooniib, naningkod yemooniib, buromakau yemooniib, silva od yeman yemooniib, gold od yeman yemooniib, deme nimakarub yemooniib, kemo yemooniib, donki yemooniib bangkanoon. ");
INSERT INTO yon_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ne korok ye wonong Sera kiomneen yaambed ye karub dana mimo wooneen. Kwane yiribman korem kuu ye dana yaa konoon. ");
INSERT INTO yon_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ne korokbed amob ongmene yedmewoon kuu ye dana ye awani dowad wonong kuu ‘Keenan nimambed wonong benaab. ");
INSERT INTO yon_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kumban ne dana ye awani dowad wonong kuu wene ne karubkim doriib kuyaa kuu ne amyenimbon yaambed wonong kuu bene.’ andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Andoone kaamonaan ‘Ma wonong kuu ne yoom monokban kuu komo keraniin.’ andaan. ");
INSERT INTO yon_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Andaane, yembed man yedmoon kuu ‘God ye weng aron korem wengambaraan kowe, ye engyumbed yedin wene awabdaneene nambe aweneyiib yaa ne amyenimbon yaambed wonong benaneeb. ");
INSERT INTO yon_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ne amob ongmaan kuyaa kuu ne karubkim yaa wananeewa yi yiminban andaniib kumbedmo eb kuu dabab kuu kandaabban.’ andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Kumban kibik okdobon yaa manaan kuu kurikuri keraan ‘Yariman God, ne korok Abraham ye God, nembed mene kwane ande manaan kuu ne korok ye dana ye dowad wonong kawe. ");
INSERT INTO yon_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Okdobon diambon kee doriin kei, wonong koyu kane mene ok yuundok mananuun kuu kaamondaniin ‘Ok maa yunkawaneewa ananiin kuu yimin dee?’ andaniine ");
INSERT INTO yon_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","yedmanuun ‘Ok ane. Angkon, nembed eb kemo ok bangkanda.’ andanuun kuu ne korok ye mingki ye dowad wonong beni yeman kuu kui yoo andeni baamonaniin.’ andaan. ");
INSERT INTO yon_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Kurikuri dowan kerindo kuned Rebeka ok pot darewoowiib kumbed wene ok yuundeen, kurikuri kere dowan keraankin. ‘Ok maa yunkawebko ana.’ andaane ");
INSERT INTO yon_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ok kirodmo yu kandom arimbed nanyiri kowenu yedmeen ‘Ok ane. Angkon, nembed eb kemo ok bangkanda.’ anduune, ok kuu anaane ne kemo kuu ok bangkandeen. ");
INSERT INTO yon_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kwane yu yaa kaamondaan ‘Ub ambe kuu kane?’ andaane ‘Nambe kuu Betuel, Nehor yoom Milka yoom yi mingki.’ anduune kumkum kande yangdem yaa derenendekore yeed dingki ari deebendaan. ");
INSERT INTO yon_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kwane ne korok Abraham ye God yaa bumangkane yubudkane kubiyiib konaan, amborom kuu ne kuu Godbed ne korok ye dana mingki awani ye dowad nenmonoone, ne korok ye ayi ye awo wedmaan kowe. ");
INSERT INTO yon_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kibireb kee yiib kuu ne korok yaa mimyowiib dee dowan dee, komo meeniwen ee o yi ye weng kuu ma yedmibko, kaadkerekori komo keraniin kuu kwana.” andoone, ");
INSERT INTO yon_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Leban yoom Betuel yoom yedmiwen “Weng maa kunambed ma yedme kebenebdaubban amborom kuu kiwaan kee Yariman Godbed korokbebdoon kowe. ");
INSERT INTO yon_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka kuu kei, nenwene. Nenwenebko eb korok ye mingki ye wonong kerok, Yariman Godbed korokbe kabdoon kowe.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kwane, Abraham ye deme karub kuu wengamboroonkin God yaa bumangke kiringkonombed okad badmenoon. Badmenekore demboon. ");
INSERT INTO yon_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kwanekore, goldiib silvayiib ebkadiib Rebeka yaa been bangkandekore, yu awaan yoom yu ayi yoom kwangkon yiribman miin amun amuniib been bangkandoon. ");
INSERT INTO yon_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kwane, ye yoom karub yena ye yoom miniwen yoom okiib animaniib ane amnoom kuu kuyaa dangekoriwa, yaro awari amkimombed yedmoon “Ne korokiib yaa domowibko wana.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Andoone, awaan mingki yoombed yedmiwen “Wonong koyu kuu korondebko aron angko angkoyiibmo nub yoom doberekoruwa kumbed domobduko nenwene.” andiib, ");
INSERT INTO yon_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","kumban Abraham ye deme karubbed yedmoon “Ne kiwaan kebengkawaib, keke Yariman Godbed kee kwanuwoon kowe. Korondibko, ne korok yaa wana.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Andoone, yedmiib “Wonong koyu kumbed baande kaamonubko yuka komandundanuun kuu kwananduk.” andekorib, ");
INSERT INTO yon_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","yi baandiiwa Rebeka munuuna kaamondiwen “Kub dowaken kuu karub kee yoom wanandameewoo?” andiiwe “Ee, ne dowaken wanandamiin.” andeen kowe, ");
INSERT INTO yon_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","yimbed Rebeka yoom yu deme wonong yoom Abraham ye deme karub yoom karub ye yoom miniwen yoom “Winime.” andekorib, ");
INSERT INTO yon_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","yi kwane amun kwende weng kee Rebeka yaa wengobendiwen “Nub odak ee, kub kuu wene ari dana yemoon yemoonbed wanabebko, kub awoya yewudmo kerok. Angkon yimbed yi bondan burudaandeniiwa yi bondan yaa yimbed korok keraniib.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kwane, Abraham ye deme karub yoom Rebeka yoom yu deme wonong yoom kemo ari yi yiribman nekwane yi korem igakman winiwen. ");
INSERT INTO yon_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Okdobon Beyalahairoi kuyaa kuu Keenan kanuk Aisek kuu mene doboroon. ");
INSERT INTO yon_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ye kuu oobnon yaa yirokaba mongkobon anuk yarone korok kankoone wedmoone kemo kuu meniib. ");
INSERT INTO yon_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka Aisek wedmenekoru, kemo ari kuu kubureenu ");
INSERT INTO yon_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Abraham ye deme karub yaa kaamoneen “Karub mongkobon aombed nub yaa wengandok meneen kuu kane?” andeene yedmendoon “Ye kuu ne korok.” andoone, yu kuu dabua nande yu murubia kiringkonombed kirimo kebeneen, yu kuu inamen amunmo ye wonong kowe. ");
INSERT INTO yon_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kwane, deme karubbed korem komo kamoon kuu kwane Aisek yaa wengkobenoon. ");
INSERT INTO yon_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Kwane Rebeka kuu Aisekbed nende ye awaan Serambed dobureen ye kombon aom nenaomne yu kuu awanoon. Awanoone, yu yaa mimyob dowaken keroon kowe, ye awaan yu bobneen yu mimyob kowoon kuu dowan keroon. ");
INSERT INTO yon_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham wonong maa yaningko Ketura awanoon. ");
INSERT INTO yon_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Yumbed Abraham ye karub dana yena wanabeen kuu Simran yoom Yoksan yoom Medan yoom Midian yoom Isbak yoom Sua yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan ye karub dana kuu Seeba yoom Dedan yoom kui. Dedan ye awoya kuu Asur ambibkindan yoom Letus ambibkindan yoom Leum ambibkindan yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian ye karub dana kuu Efa yoom Efer yoom Hanok yoom Abida yoom Eldaa yoom kui. Yi korem kuu Ketura yu awoya. ");
INSERT INTO yon_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Yiribman korem Abraham boon kuu mingki Aisek yaa yedmoon “Ne bobnaka ne yiribman korem ebbed be.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Kumban Abraham kuu wad doreen yaambed, ye dungkud nima yi karub dana yaa munob yena bangkandekore yedmendoonkob Aisekiib yaa kuu yi koronde ben ambibkin kangka winiwen. ");
INSERT INTO yon_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham ye weeb kuu 175iib kere kiomne anam keroon yaambed bobnekore, ye karuwayiib yaa daboknoon. ");
INSERT INTO yon_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Bobnoona, Hitman Soar ye mingki Efron ye mongkobon Mamre kangka yaningko Makpela botdem aom ye meed Aisek yoom Ismael yoombed mangkiwen. ");
INSERT INTO yon_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Bobkonombon kukuu Abraham yoom ye wonong Sera yoom kuyaom mangkenabiwen. Mongkobon kuu Hitman yaambed Abrahambed moonoon. ");
INSERT INTO yon_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham bobnoon ye yondem, Aisek kuu Okdobon Beyalahairoi dia doreen. Doreena, Godbed ye yaa amun kerenoon. ");
INSERT INTO yon_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Keke Ismael ye weng. Ismael kuu Abraham yoom Hagar yoom yi mingki, Yu kuu Sera yu kakmaniibban ye deme Idyip wonong. ");
INSERT INTO yon_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ye karub dana yi aningko kuu kei, Nebaiot, Kedar, Adbiil, Mibsam, ");
INSERT INTO yon_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO yon_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafis, Kedema yoom kui. Nebaiot kuu wonob dana, angkon Kedema kuu yeenbon dana. ");
INSERT INTO yon_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Yi andokbe amyenimbon wad ayoowiib yi ambokab keriwen. Angkon, yi aningko kuu yi kambongiib yi kombonboniib yaambed kondiwen. ");
INSERT INTO yon_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Amaan, Ismael kuu weeb 137iib dobere kiomnekore bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismael awene kuu bidambib Havila kere Sur kere wedkuri Idyip yimin kere wene Asiria kangka ye kiwaan kebed yaa dobiriwen. Abraham ye awoya yena yaa dowakeniibban keriwen kowe yi dia dobirindo, yi kuu yika angkara dobiriwen.|U ");
INSERT INTO yon_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Keke Abraham ye mingki Aisek ye weng. ");
INSERT INTO yon_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisek kuu weeb 40yiib kere Rebeka kuu awanoon. Yu kuu Aram ambibkin ye okad dabonmo ye karub Betuel ye mungkan. Yu kuu Aramman Leban ye daman. ");
INSERT INTO yon_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeka kuu kurong kowe, Aisekbed yu dowad Yariman yaa kurikuri keroon. Kwanoone, Yarimanbed inandoon kowe Rebeka oyoomiib kereen. ");
INSERT INTO yon_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Yu kabeyob aombed ayoob dabak dana neman kankorare kankorare kamiwen. Kwanoone, “Kwana kowe, ne yaa komarewa keroon?” andekoru, Yariman yaa kaamonuune, ");
INSERT INTO yon_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","yembed inande daandoon, “Kub kabeyob aom kuu ambibkindan ayoob yi ambokab. Kwane, ambibkindan ayoob kuu andokbaniib. Ningki ye awoyambed ayi ye awoya yaa burudande aromkono arimbed keraniib. Kwane, ayi kuu ningki ye dabderem yiri dobaraneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Amaan, wooni yaron munuuna karub dana ayoob dabak dana wooneen. ");
INSERT INTO yon_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Dana ibduruk kuu dodmo, ye kuu kimi mungkum kowe yaningko Isau ande kowiwen. ");
INSERT INTO yon_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ma ningki kuu ayi Isau ye yon daandum yaa awinoon kowe yaningko Yekob ande kowiwen. Yi wooneen yaron kuu Aisek ye weeb kuu 60yiib keroon. ");
INSERT INTO yon_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Karub kewed ayoob kuu kainenib, ayi Isau kuu dingkan kiib bi ye karub kere dura angka yari ye karub keroon. Kumban Yekob kuu yongbon deme awine kambong aom iwari dobiri ye karub keroon. ");
INSERT INTO yon_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisekbed Isau yaa mimyob dowaken keenimaan, amborom kuu dingkan kiib ani kuu ye dowaken darewoob kowe, kuned Rebekambed Yekob yaa mimyob dowaken keenimaun. ");
INSERT INTO yon_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Aron maa, Isau bad yaro meneen. Ye kuu mungi darewoob bobne mene wedmoonka, Yekob kuu katang dodmo dinaan kowe ");
INSERT INTO yon_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","yedmoon, “Ne kuu mungimbed kombaraan kowe, animan dodmo kuu kirod maawe!” andoon. (Kwanikob yaningko mamaa kuu Idom ande yedmimaib.) ");
INSERT INTO yon_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kwanandoone, Yekobbed inande yedmoon, “Eb ayi ye yumbon nub ambe bobni ye yiribman bi ye dowad kawebko animan kabda.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kwanandoone, Isaumbed yedmoon “Kedi, bobnandamiin kowe, ne ayi ye yumbon kuu kabamoon kii!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kowe, Yekobbed yedmoon, “Ibduruk kuu ne yaa amob weng ongme kawebka.” andoone, Isaumbed amob weng ongme ayi ye yumbon kuu Yekob yaa konoon. ");
INSERT INTO yon_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Konoone, Yekobbed flawayiib katang okiib bangkanoona anoon. Kwane Isau ayi ye yumbon kuu arewa ande meenoon. ");
INSERT INTO yon_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kurin Abraham doboroon yaambed am kaine animaniibban keroona dobiriwen kwane kuu Aisekbed doreen yambibkin aom kuu ika am kaine animaniibban keroon. Kowe, Aisekbed Filistiadan yi king Abimelek ye oonimbon aom kambong Gerar yaa wonoon. ");
INSERT INTO yon_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Wonoone, Yarimanbed angkaderene Aisek yaa yedmoon, “Idyip yiri wanaab. Nembed kunaya dobere ande yedmebdako kuyaombed dobere. ");
INSERT INTO yon_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ambibkin keyaom doberebko, ne kuu eb yoom doberenub amun kerubda. Nembed eb yoom eb awoya yoom yaa keye ambibkin korem wedmeeb kee kondaniin, ne amob eb ambe Abraham yaa ongme kowaan kuu eb yaa kangkon kowaniin. ");
INSERT INTO yon_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nembed eb awoya yemoon bangkabdaniin kuu mindong yemoon kimingkindeban ambid ari kwamune areb, angkon keye ambibkin okad korem wedmeeb kee yi yaa kondaniin. Angkon eb yob yaambed ambibkin koremdan okad yimin yimin yaa kuu amun kerundaniin. ");
INSERT INTO yon_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nembed kwamaniin ye id kuu amborom kuu eb ambe Abraham kuu ne amob nongkobaan korem kuu wengambere kwamoon kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kwani kowe, Aisek kuu Gerar aom doboroon.|H ");
INSERT INTO yon_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kambong karubbed Aisek ye wonong Rebeka yu dowad kumbed Aisek yaa kaamoniwena, “Ne wonong” andindo, “Yu kuu ne daman” andoon, amborom kuu Aisek kuu unekore, “Yu kuu kerengandimbon kowe, kambong karubbed ne nenekorib, yu kuu nendaniib.” ande meene unoon kowe. ");
INSERT INTO yon_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisek kuu aron doboob kuyaom doboroon ye yondem kuu, aron maa Filistia yi king Abimelekbed kerekni ambongko angkambed wedmoone Aisek kuu Rebeka yoom karub ye wonong yoom areb awinene awinene doriib. ");
INSERT INTO yon_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Doriiwe wedmekore, Abimelekbed ye deme karub yaa yedmenoonkob wene Aisek nenmonoone, Abimelekbed Aisek yaa kaamonoon “Yu kuu eb wonongoo? Komandewed ‘Yu kuu ne daman’ andewen?” andoone, Aisekbed yedmoon “Ne kuu unaan kuu ‘Ne nenekorib, yu kuu nendaniib’ ande meenaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kwane, Abimelekbed Aisek yaa kaamonenoon “Eb kuu komo kamewen nub yaa kuu? Karub maambed eb wonong yoom dangiwen karen, eb dowad nub kuu dabab kanduwen karen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kwani kowe, Abimelekbed karub korem yaa daandoon “Karub kanembed karub kee yoom ye wonong yoom yaa badmendaneen kuu ayanuuwe bobnaneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aron maa, Aisekbed kaawiib yowiib kibingkoon. Kibingkekore, kuye weeb aombed yemoon wane wenore mimyamo keroon kuu yob mimo kibingkoon kuu id 100iib boon, amborom kuu Godbed ye yaa amun kerenoon kowe. ");
INSERT INTO yon_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Kwanoone, Aisek kuu yiribman yemoon be wenore mimyamo keroone daane darewoob kereen kowe, yiribman karakiib ye karub keroon. ");
INSERT INTO yon_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ye kuu demedan yemooniib dingkan karakiib kowe Filistiadanbed ye yaa wungkaneniwen ");
INSERT INTO yon_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","kowe, Abraham kuu doboroon yaron yaambed ye deme karubbed okdobon nidkiwen kuu Filistiadanbed okadbed kebengkiwen. ");
INSERT INTO yon_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kwanekoriwa, Abimelekbed Aisek yaa yedmoon “Nub ambibkin keyaom kee koronde wene, amborom kuu eb kuu aromkono darewoob kerewen nub arebban kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Andoone, Aisek kuu koronde wene kankubunen Gerar yiri parai kombon bane ongme kuyaa doboroon. ");
INSERT INTO yon_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kurin Abraham doboroon kuu okdobon nidkanaboon kumban ye bobnoone Filistiadanbed okdobon kuu kebengkiwen kowe, Aisekbed angkon ika nidkanabekore, ye ambembed aningko yeengkanandoon kuu kwane ika yengkanandoon. ");
INSERT INTO yon_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aron maa, Aisek ye deme karubbed okdobon maa kuu kankubunen yirimbed nidkiiwe ok kuu yeederebeen ");
INSERT INTO yon_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","kumban Gerar yi sibi ooni yi karubbed Aisek ye deme karub yaa wengberenib yedmiwen “Ok kee nub ok.” andiwen kowe, Aisekbed okdobon yaningko kuu Esek ande kowoon. Ye id kuu ye yaa wengbereniwen. ");
INSERT INTO yon_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kwane, ye deme karubbed okdobon maa nidkiwen. Nidkiwen kumban ye yaa angkon wengbiriiwe okdobon yaningko kuu Sitna ande kowoon. ");
INSERT INTO yon_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Kwane kuyaa kuu koronde weneene okdobon maa nidkiiwe karub maa ye yaa wengbirindo kowe okdobon yaningko kuu Rehobot ande kowekore, ika yedmoon “Yariman Godbed dobiri yimin nub yaa kondoon kowe, okad keyaom kee yewenubmo dobaranuub.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kwane kuyaambed Aisek kuu Berseba ari wonoon. ");
INSERT INTO yon_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Wonoone, kuye amnoom aombed Yariman God kuu angkaderene ye yaa yedmenoon “Ne kuu eb ambe Abraham ye God. Eb unaab, amborom kuu ne kuu eb yaa dore awabdimain kowe. Kwani kowe, nembed eb yaa amun kerubdeni, eb awoya yemoon kabdaniin, amborom kuu ne deme karub Abraham yaa ne weng kunduk kowaan kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Andoone, Aisekbed bot wuube dingkan nengkane agedmo keri yeman ongmekore, Yariman God yaa kurikuriyiib kubiyiib konoon. Angkon ye parai kombon bane ongme doboroone ye deme karubbed okdobon nidkiwen. ");
INSERT INTO yon_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nidkiiwa, Abimelek kuu Gerar yaambed Aisek wedmenande monoon. Ye yoom ongkanimameen karub yaningko Ahusat yoom ana nangmi ye korok yaningko Faikol yoom kwane miniwen. ");
INSERT INTO yon_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Miniiwe, Aisekbed yi yaa kaamondoon “Yiib kuu komandiwed mene ne yaa wedmewok miniwen? Yiib kuu ne yaa dowakeniibban kerekoriwa, yiibbed ne yaa ‘Nub ambibkin aom kuu koronde wene’ andiibkob manaan kowe.” andoone, ");
INSERT INTO yon_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","yimbed man yedmiwen “Nubkaadkeruwen eb yaa kuu Yariman Godiib kowe, nub dore eb dore wiim aangkenub amob ongme kowem. ");
INSERT INTO yon_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Nub eb yaa mayindo kowe, neman ebbed nub yaa yab. ‘Wene!’ anduwen kumban nub kuu eb yaa amunmo keruuwa mene yewenubmo doreeb. Angkon Yariman Godbed eb yaa amun kerubdoon kowe.” andiiwe, ");
INSERT INTO yon_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Aisekbed orok ongme nekwoone yi korem animaniib okiib anekorib, ");
INSERT INTO yon_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","dangiiwe waroone, amkimokaimbed yi korem kuu wiim aangke amob weng ongmiwen. Kwanekorib, Aisek kuu kubiyiib yi yaa andoonkob yi kuu domonene yewenubmo winiwen. ");
INSERT INTO yon_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Winiiwe, kuyaron arimbed Aisek ye deme karubbed okdobon nidkiwen ye dowad mene yedmeniwen “Okdobon nidkuwen kuu ok wedmuwen.” andiwen ");
INSERT INTO yon_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","kowe, Aisekbed okdobon yaningko kuu Siiba ande kowoon. Kuu kowoon kuu kibik kwangkon kambong darewoob yaningko Berseba andimaib. ");
INSERT INTO yon_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isau kuu weeb 40yiib kerekore Hit ambibkin yi nima ayoob, Beeri ye mungkan Yudit yoom Elon ye mungkan Besmat yoom kwane awadmoon. ");
INSERT INTO yon_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Nima ayoob kuu Aisek yoom Rebeka yoom yaa kongendimaib kuu dabab kondiwen. ");
INSERT INTO yon_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Amaan, Aisek kuu kiomnoon kowe, indob kuu wiib yonoon kowe, korobe wedmimokban. Aron maa, ye dana ayi Isau yaa baande yedmoon “Ne dana.” andoone Isaumbed yedmoon “Ne kuu kei.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Andoone, Aisekbed yedmoon “Ne kuu kiomnaan. Bobnaniin dee, nekaadban. ");
INSERT INTO yon_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kwani kowe, eb anangkawiib anayiib ana ye kud aombed beneeb dura angka ne dowad dingkan kiib bad wene aye kanmene. ");
INSERT INTO yon_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kwane, animan ambod amun ne dowaken yaa nekwe nengke kanmenebko ana. Anekori, eb yaa amun kerubda, amaanbed bobnaniin kowe.” ande daaneene ");
INSERT INTO yon_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeka kuu wengaun. Wengambureene, daane dowan keroone, Isau kuu dura angka dingkan bad wonoon. ");
INSERT INTO yon_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Wonoone, yumbed yu dana Yekob yaa yedmeneen “Wengambere. Nembed wengambaraane eb ambe Aisekbed eb ambang Isau yaa daanoon ");
INSERT INTO yon_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Dingkan kuu ayekoreb animan ambod amun nekwe nengke kanmenebko, anekori nembed Yariman God ye arinambo arimbed amun kerubda, amaan kuu bobnaniin kowe.’ andoon ");
INSERT INTO yon_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","kowe ne weng kee ongme wengambere. Ne dana yee, nembed komo yedmaka kwane. ");
INSERT INTO yon_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ebbed wene nub naningkod mana amun ayoob yeene benmenebko, animan ambod amun eb ambe ye dowaken yaambed nekwe nengka. ");
INSERT INTO yon_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kwanako ebbed animan kuu ambeyiib yaa benwenebko anekore, yembed eb yaa amun kerubdekoreka, bobnaneen kowe.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kumban Yekobbed awaan Rebeka yaa yedmoon “Nambang Isau kuu kimi yemooniib ye karub, kumban ne kuu kimiyiibban ");
INSERT INTO yon_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","kowe, ambembed ne yaa angkorowe yekaad ne kuu Isaumban andekore, yembed ne yaa amun keruwaanban kerene butun kamewaneen, amborom kuu ye yaa nemengkandandamaan kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Andoone, awaanbed man yedmeen “Eb ambembed eb yaa butun kamaneen kuu nembed kandaniin kowe, nembed kwane ande yedmaka kwane, wene naningkod benmene.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Anduune, Yekob kuu wene naningkod ayoob yeenekore, awaaniib yaa benmonoone, yumbed animan ambod amun yawodki ye dowaken yaambed nengkanabeen. ");
INSERT INTO yon_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kwanekoru, Rebekambed ayi Isau yebkad amuniib ambiwoom dangoon kuu benu ningki Yekob yaa deebeneen. ");
INSERT INTO yon_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Kwanekoru, angkon yumbed naningkod kad benu Yekob ye dingki yaa deebenekoru, ye kongkono yaa kowe kereen. ");
INSERT INTO yon_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Kwane animan ambod amuniib flawayiib nengkeen kuu Yekob yaa bangkaneen. ");
INSERT INTO yon_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Bangkanuune Yekob kuu be wene awodki yaa yedmoon “Ambe.” andoone, “Ee, ne dana, eb kuu kane?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Andoone, Yekobbed yawodki yaa yedmoon “Ne kuu Isau, eb wonob dana. Ebbed ne yaa yedmewen kuu kwanaan kowe, yaro dibere ne dingkan yom kee anekoreb, ne yaa amun keruwe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kumban yawodki Aisekbed ye dana yaa kaamonenoon “Komarewa kere dingkan kuu kirodmo wedme ayewen?” andoon. Andoone, Yekobbed yedmoon “Eb Yariman Godbed awawoon kowe, wedme ayaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Andoone, Aisekbed yedmoon “Ne dana, dia menebko angkorobda. Kwananiin kuu nekaadkeri yeman, eb kuu ne dana Isau anam dee andid.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Andoone, Yekob kuu yawodki Aisek ye dia wonoone awodkimbed angkoronekore, yedmoon “Weng kuu Yekob ye weng areb, kumban dingki kuu Isau ye dingki.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Kwane, ye korobe meene yekaadkerindo, amborom kuu ye dingki yaa kuu kimiyiib, yambang Isau areb kowe, yembed ye yaa amun kerenoon. ");
INSERT INTO yon_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Angkon, yembed Yekob yaa kaamonoon “Eb kuu ne dana Isau anam dee?” andoone “Ee, ne kei.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kwanekore, Aisekbed yedmoon “Ne dana, dingkan yom ebbed kanmenewen kuu kawebko ana, anekori nembed eb yaa amun kerubda.” andoon. Andoone, Yekobbed animan kuu kankonoone anoon. Aneene, ok yaningko wainiib konoone anoon. ");
INSERT INTO yon_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Anekore, awodki Aisekbed ye yaa yedmoon “Ne dana, keya meneneeb ne yaa mandamuk kere.” ");
INSERT INTO yon_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","andoone, Yekob kuu wene awodki yaa mandamuk kerunoone, Aisek kuu Isau yebkad baeb kuuwekore amun kerune yedmoon “Aa, ne dana eb baeb kuu dura Yariman Godbed amun kerundoon ye baeb areb. ");
INSERT INTO yon_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Yariman Godbed eb yaa ambid arimbed am yimin kabdene okad amunmo kabdoko, yowiib ok yaningko wain yeewiib yewudmo kerok. ");
INSERT INTO yon_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ambibkin maa maa yi karubbed eb yaa bumangkekorib, eb deme awingkok. Ebbed korok kere eb aagoroka yaa kuu, yi kuu eb yaa bumangkime. Eb yaa butun arewa ambengkanebde kabdibka Godbed butun arewa kondaneen. Angkon eb yaa amun kerubdibka Godbed amun kerundaneen.” andoon. Kwane ande amun kerunoon. ");
INSERT INTO yon_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Kwane, Aisek kuu Yekob yaa amun kerune dowan keroone, yawodki yaambed kuu koronde wonoone, Isau bad wonoon kuu mene awudoroon. ");
INSERT INTO yon_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ye kangkon animan ambod amuniib nekwe nengkekore, awodkiyiib yaa kanmenene yedmoon “Ambe, yaro dibere ne dingkan yom kee anekoreb ne yaa amun keruwe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Andoone, yawodki Aisekbed ye yaa kaamonoon “Eb kuu kane?” andoone “Ne kuu eb wonob dana Isau kei.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Andoone Aisek kuu kiringmi darewoowiib kumbed yedmoon “Kanembed bad yarene aye nekwe nengke ne yaa kanmonoon? Kibireb yaa ne anekori ye yaa amun kerunaan kowe, anam, ye kuu amun kerundimamaneen!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Andoone, Isau kuu awodki ye weng wengamberekore, ye niindem aom yewed kandekore, naawonmo ameng kamene yambe yaa yedmoon “Ambe! Ne kangkon amun keruwe!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kumban yembed yedmoon “Eb damanbed mene nemengkawene eb yaa amun keri yeman kuu kanwonoon.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Andoone, Isaumbed yedmoon “Yekob yaningko ye id ye yaa kuu anam. Ye kuu ne yaa nemengkawe ayoob keroon. Yembed eb bobni ye yumbon ne kandi yeman kuu nemengkawe kandoon kumbed angkon ne yaa amun keri yeman kibireb yaa nemengkabde kandoon kii!” andekore, angkon kaamonoon “Amun keri yeman mamaayiib ne yaa keruwaneeb dee?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Andoone, Aisekbed Isau yaa man yedmoon “Nembed ye kuu eb korok kankoweni, ye karubkim kuu ye deme karub kereni, yowiib ok yaningko wain yeewiib yewudmo kerok kwane andaan kowe, ne dana, eb kuu komo yaambed amun kerubdaniin?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Andoone, Isaumbed yawodki yaa yedmoon “Ambe, eb kuu amun keri yeman mamaayiib dee? Ne kangkon amun keruwe yaa!” andekore naawonmo ameng kamoon. ");
INSERT INTO yon_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Awodki Aisekbed ye yaa amun kerune yedmoon “Eb kuu ambibkin amun amiib aom kuu koronde okad arewa ambab angkambed dobaraneeb. ");
INSERT INTO yon_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Eb kuu kerewangmo kande dobaraneeb. Eb daman ye deme karub keraneeb, kumban ebkareb aromneneb ye deme korondeeb ye dabderem aom korondeeb ebkareb dobaraneeb.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Andoone, kwane Isau ye niindem aom kuu norin ye inamen mene doreen, Yekob yaa, amborom kuu Aisekbed amun kerunoon kowe. Yekareb yedmoon “Nambe bobni aron kuu dia kereen. Bobaneene mimyob koweni yaron dowan keraneen kuu ne daman Yekob kuu ayaniine bobnaneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Andoone, Rebeka kuu karub maambed daandoone ayi Isaumbed Yekob yaa anambo weng dakmoon kuu kowe wene Yekob yaa yedmeen “Ne dana, eb ambang Isaumbed ‘Ne daman ayaniin kuu amun kii!’ ande inamen aom meenoon. ");
INSERT INTO yon_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kwane kowe, nembed yedmebdaka kwane. Nambang Lebaniib yaa Haran taun aom kombiri wene. ");
INSERT INTO yon_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Wene ye yoom doberebko eb ambang kuu ye norin dowan keroka. ");
INSERT INTO yon_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kwane eb ambang ye norin ebbed ye yaa kwanewen kuu dowan kere nonondandoka, nembed weng kowako, kumbed kuyaa kuu koronde mene. Yiib ayoob aron mimo aombed bobni kuu ne dowakenban.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Andekoru, wene Aisek yaa yedmeen “Ne kuu Hitdan yi nima keya kee otkeneb kerundaan. Angkon Yekob kwangkon ambibkin keyaom wonong maa awananeen Hit wonong kwamune areb kuu bobnaniin.” andeen.|U ");
INSERT INTO yon_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kowe, Aisekbed Yekob yaa baandoone monoone, amun kerunekore yedme kowoon “Keenan wonong kuu awanaab. ");
INSERT INTO yon_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kibireb kee, eb ena yu ambe Betuel awenembed Aram ambibkin ye okad dabonmo doriib yaa wene, wonong kuu eb mom Leban ye dana kuyaombed awane. ");
INSERT INTO yon_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Aromkono Korem ye Godbed eb yaa amun kerubdene dana yewudmo kere daanoko ambibkin yemoon kerok. ");
INSERT INTO yon_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Yembed Abraham yaa amun kerunoon areb kuu eb yoom eb awoya yoom yaa kangkon kondok, kwanoko ambibkin kibireb kee doreeb kuu ebmanban kuned Godbed Abraham yaa konoon kowe awabdoko okad kee yaa yariman kere.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kwanandekore, Aisekbed Yekob yaa yedmoonkob Aram ambibkin ye okad dabonmo yaa Lebaniib yaa andowe weneen. Leban kuu Aramman Betuel ye dana, ye kuu Rebeka yu ambang, yu kuu Yekob yoom Isau yoom yi awaan. ");
INSERT INTO yon_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Kwane, Isau kuu yekaadkeroon, Aisekbed Yekob yaa amun kerunekore yedmoon, “Keenan ambibkin wonong kuu awanaab.” andoone Aram ambibkin ye okad dabonmo yaa wonoon kuu wonong awani ye dowad wonoon. ");
INSERT INTO yon_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yangkon yekaadkeroon kuu Yekob kuu awodki yoom awaan yoom yi weng wengamboroon. ");
INSERT INTO yon_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Wonoone, Isau kuu Keenan wonong awani kuu yawodki Aisek ye dowakenban ande meenoon kowe, ");
INSERT INTO yon_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ismaeliib yaa wenene Nebaiot ye daman Mahalat awanoon, yu kuu Abraham ye dana Ismael ye mungkan. Kowe, Isau kuu nima ayoobmim awadmoon. ");
INSERT INTO yon_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yekob kuu Berseba yaambed koronde wene Haran yaa andowe wonoon. ");
INSERT INTO yon_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kwane kiwaan wedya kuu obonmo okad yaa nandoone, aron kuu kubuneen kowe, bot kande ambongkone angkene ");
INSERT INTO yon_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","kiyuum wedmoone, kuum kuu ambid arimbed okad yiri dedmonoon kuyaambed God ye engyus kuu kubune daane kamiib. ");
INSERT INTO yon_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kwari kuu Yariman doroon, kwane yembed yedmoon, “Ne kuu Yariman, eb awo Abraham ye God, angkon Aisek ye God. Nembed okad kee angkeeb yiri kuu ewiib eb awoyayiib yaa kondaniin. ");
INSERT INTO yon_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Eb awoya kuu yewudmo keraniib, ingkud mimim kimingkindeban kwamune areb keraniib, kwane yi kuu kuriyiib kariyiib kaomiib kangkayiib wenebenib, yi okad kuu irin angkane darewoob keranuun. Angkon karub korem okad yimin yimin yaa kuu eb yoom eb awoya yoom yaambed amun kerundaniin. ");
INSERT INTO yon_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kedi, ne kuu eb yaa dore awabdimain kowe, ebbed kuna yaa wananeeb kuu keebdombereni, angkon nembed eb kuu okad keyaom ika nenmananiin. Ne kuu eb yaa domobdainban, nembed eb yaa komo yedme kowaan kuu kwananiin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kiyuum wedmekore, Yekob kuu angkoon yirimbed dembene yeka meenoon, “Anam, Yariman kuu keyaom kumbed ne kuu nekaadkerindo keraan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ye kuu unekore yedmoon, “Keyaom kee unimbon, okad keyaom God yambib kii! Ewen ari daani ye kiwaan kuda!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Amkimo kaimbed Yekob kuu ye bot ambongkone angkoon kuu kande ongme numone kowoone angkimboroone kwari kuu meeni yeman ande kowekore oiyo bunoon. ");
INSERT INTO yon_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Bunekore, yembed okad kuyaom yaningko Betel kowoon, kuned kurin kuu kambong doreen yaningko Lus andimaib. ");
INSERT INTO yon_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kwanekore, Yekobbed amob ongme yedmoon “Ne dowaken kuu nembed wanandamiin yaa kuu Godbed dore oone awawimamaneen animaniib ebkad debi yemaniib kuu bangkawimamaneen kowe, ");
INSERT INTO yon_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kengbonmo ika nambe yambiwoom mananiin. Kwananeen kuu Yariman God kuu ne God andimamaniin. ");
INSERT INTO yon_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Angkon nembed bot kuu meeni yeman ambongkone angkaan kuu God yambib andaniin, angkon yembed korem bangkawaneen kuu ne kuu andokbe wenore angko angkoyiib nongkobekore anded mimo God yaa konaniin.” andoon.|U ");
INSERT INTO yon_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Kwanekore, Yekob kuu angkon wenene kangkadan yi karub yi ambibkin yaa aomnoon. ");
INSERT INTO yon_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Aomnekore, wedangka wedmoon kuu okdobon kuyaambed sibi nimingke dobaraiwa nimingke dobaraiwa nimingke dobaraiwa ayoobmim kamimamiib kuu menebe dibiriwen, amborom kuu okdobon kuyaambed sibi kuu ok bangkandiiwe animamiib kowe. Okdobon animari dabunimamiib ye bot kuu darewoob. ");
INSERT INTO yon_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kwane sibi nimingke dobiriwen korem kuu menebe nedbaiwe sibi ooniwendanbed okdobon animari bot darewoob kuu kanangkanekorib ok yuungke bangkandimamiib. Bangkandekorib, angkon ika bot kuu kande okdobon anim ari kebenimamiib. ");
INSERT INTO yon_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yekobbed sibi ooniwendan yaa kaamondoon “Nangkodmia! Yiib kambong kuu kane?” andoone yimbed man yedmiwen “Nub kambong kuu Haran.” andiiwe, ");
INSERT INTO yon_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","yembed yi yaa yedmoon “Yiib kuu Nehor ye awo Leban kuu yiibkaadoo?” andoone, “Ee, ye kuu nubkaadaa.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kwane Yekobbed yi yaa kaamondoon “Ye kuu amun dee?” andoone, yimbed yedmiwen “Ee, ye kuu amunmo doreen. Ye mungkan Reksel kuu sibi kee be menuun kei.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Andiiwe, yembed yedmoon “Wedmime. Kuu oobnonban, kuu aron angkaramo kowe, sibi kuu nedbi yaron kuu mokeed. Kwani kowe, ok bangkandekorib bewene kereek yemoon yaa wenebime.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kumban yimbed man yedmiwen “Nubbedmo kuu yiminban, sibi korem yoom yi oonidan korem yoom kuu mimyamo nedbaniiwe okdobon ari bot dabuniwen kuu nub korem kanangkonekorub kumbed ok kuu bangkandanuub.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ye kwane yi yoom dorone dakmiiwe, Reksel kuu yu ambe ye sibiyiib benu muneen, amborom kuu yu kangkon sibi oonimamuun ye wonong kereen kowe. ");
INSERT INTO yon_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kwane Yekob kuu ye mom Leban ye dana Reksel wedmendekore, wene okdobon animari bot kebeniwen kuu kanangkanekore, ye mom ye sibi kuu ok yuungke bangkandoon. ");
INSERT INTO yon_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kwanekore, Yekob kuu Reksel yaa mandamuk kerunde ameng kamande kamoon. ");
INSERT INTO yon_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Kwane yembed yu yaa yedmendoon “Ne kuu kub ambe ye karubkim, angkon ne kuu Rebeka yu dana.” andoone, yumbed kabaanmo wene yu ambe yedmeneen. ");
INSERT INTO yon_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Yedmenuune ye yangkura yu mingki monoon Lebanbed wengamberekore, kirodmo wene wenganok wonoon. Wenene yembed nenkangkunekore mandamuk kerekore, yambiwoom nenwonoon. Kuyaambed Yekobbed weng korem kuu daanoon. ");
INSERT INTO yon_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","daanoone, Lebanbed yedmoon “Eb kuu ne umkan anam.” andoon. Kwane Yekob kuu ye yoom doriiwe, wood mimo kereen. ");
INSERT INTO yon_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lebanbed ye yaa yedmoon “Eb kuu ne karubkim kuned ne deme ogoodmo ambangkeeb kuu amunban. Ebbed yedmewe, eb dowaken deme ambangki ye kakman yaa kuu komo andaneeb?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Leban kuu nimadana koyu ayoowiib, angkaan yu aningko kuu Lea, angkon nengkan yu aningko kuu Reksel. ");
INSERT INTO yon_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea yu indob kuu wuud korobe wedmindeban, kumban Reksel kuu kerengandimbon. ");
INSERT INTO yon_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yekob kuu Reksel yaa awani inamen meenendekore yedmoon “Ne kuu weeb ediib eb deme ambangkako eb dana nengkan Reksel kuu ne yaa domowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Andoone, Lebanbed yedmoon “Eb yaa kabdaniin kumbed amun, karub maa yaa koni kuu amunban kowe, neyiib yaa keya dobere.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Andoone, Yekob kuu weeb ediib Leban ye deme ambangkoon, Reksel awani ye dowad. Kumban ye dowaken kuu Reksel yaa meenendoon kowe aron doboobban ande meenoon. ");
INSERT INTO yon_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kwane, Yekobbed Leban yaa yedmoon “Weeb ediib dowan kereen kowe, Reksel kuu kawebko awana.” andoone, ");
INSERT INTO yon_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lebanbed orok ongmoone karub korem kuyaom doriib kuu nedbiiwa aniwen, ");
INSERT INTO yon_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","24","kumban miriknoone ye dana angkaan Lea nenwene Yekob yaa domonenekore, angkon ye deme wonong Silpa kuu ye dana angkaan yaa yu deme ambangki yeman kondekore, Yekob kuu Lea yoom dangiwena, ");
INSERT INTO yon_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","amkimo kerune, Yekob kuu yaro wedme binangkoon, “Ii, Lea kii!” ande meene wedmekore, Leban yaa wene yedmoon “Ne yaa kee komarewa kerewen? Ne kuu Reksel yu dowad eb deme ambangkaan, komandewed ne yaa nemengkawewen?” andoone, ");
INSERT INTO yon_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lebanbed neman yedmoon “Nengkandin awanekore angkaan yoman awani kuu nub ambibkin keyaom ma kwanimokban ");
INSERT INTO yon_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","kowe, ne mungkan kee yu awani ye dowad orok yaron ediib dobereewo dowan keruka, angkon Reksel kuu kabdubko awanekoreb, angkon ika weeb ediib ne deme ambangke.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Andoone, Yekobbed yedmoon “Ee kwananiin.” andoon. Kowe, Yekob kuu Lea yoom orok yaron ediib doberekoriwe, Lebanbed ye dana nengkan Reksel konoone ye wonong keroon. ");
INSERT INTO yon_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Angkon Lebanbed ye deme wonong Bilha kuu ye dana Reksel yaa yu deme ambangki yeman kondoon. ");
INSERT INTO yon_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Reksel konoone, Yekob kuu yu yoom dangiwen. Ye kuu Reksel yaamo dowaken darewoob kerundekore, Lea kuu dowakenban kerundoon. Kwanekore, angkon weeb ediib Leban ye deme ambangkoon. ");
INSERT INTO yon_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Kuu ye weeb ediib kuyaombed, Yariman Godbed wedmoone Lea yaa kuu Yekob ye dowakenban keroon kowe, Godbed yu dana wooni ye kiwaan nandoon, kumban Reksel kuu kurong kereen. ");
INSERT INTO yon_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea kuu oyoomiib kerekoru, dana mingki wooneen. Woonekoru, yumbed yedmeen “Yariman Godbed ne yaa dabab kandaan kuu wedmewoon kowe, anam ne ambimbed ne yaa dowaken keraneen.” andekoru, dana yaningko Ruben ande koween. ");
INSERT INTO yon_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Amaan angkon ika oyoomiib kerekoru, dana mingki wooneen. Woonekoru, yumbed yedmeen “Yariman Godbed wengamboroon ne yaa kuu ne ambimbed meenewindo kowe, Godbed dana kee kawoon.” andekoru, dana yaningko Simion ande koween. ");
INSERT INTO yon_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Amaan angkon ika oyoomiib kerekoru, dana mingki wooneen. Woonekoru, yumbed yedmeen “Kibikee, ne ambimbed ne yaa yubudkawaneen, amborom kuu nembed ye karub dana ayoobmim baan kowe.” andekoru, dana yaningko Livai ande koween. ");
INSERT INTO yon_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Amaan angkon ika oyoomiib kerekoru, dana mingki wooneen. Woonekoru, yumbed yedmeen “Kibikee, Yariman God yaningko kankoonaan.” andekoru, dana yaningko Yuda ande koween. Yoman, Lea kuu ika kurong kereen. ");
INSERT INTO yon_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Kwane Reksel kuu Yekob yaa dana woonimokban kere wedmekoru, yu oni yaa wungkandeen. Wungkandekoru, Yekob yaa yedmeen “Dana kawe! Kawaabban kuu bobnaniin!” andeen. ");
INSERT INTO yon_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Anduune, Yekob kuu arud wandene yu yaa yedmoon “Ne kuu God areb dee? Yembed dana nendi kebenoon kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Andoone, yumbed yedmeen “Kwane kowe, ne deme wonong Bilha kee eb yoom dangimo kamenib dana woonuko nendekori, kuyaambed ari kuu ne danayiib kera.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Andekoru, yumbed yu deme wonong Bilha ye yaa dana wooni ye dowad konuune, dungkud wonong areb awanoone, yu yoom dangiwen. ");
INSERT INTO yon_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Yu kuu oyoomiib kerekoru dana mingki wooneen. ");
INSERT INTO yon_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kwane Rekselbed yedmeen “Godbed ne yaa wengyundane ne weng wengamberekore, dana kawoon.” andekoru, dana yaningko Den ande koween. ");
INSERT INTO yon_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Amaan angkon Reksel yu deme wonong Bilha kuu oyoomiib kerekoru, Yekob ye dana mingki mamaa wooneen. ");
INSERT INTO yon_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Woonuune, Rekselbed yedmeen “Ne oni yaa kuu dedmone dedmone nekareb aromneni burudandaan.” andekoru, dana yaningko Naftalai ande koween. ");
INSERT INTO yon_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Kwane, Lea yu dana wooni kuu kebenoon kowe, yu deme wonong Silpa kuu Yekob yaa dana wooni ye dowad konuune, dungkud wonong areb awanoon. ");
INSERT INTO yon_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lea yu deme wonong Silpa kuu oyoomiib kerekoru, Yekob ye dana mingki wooneen. ");
INSERT INTO yon_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Woonuune, Leambed yedmeen “Ne kuu amun kandeni kubaan!” andekoru, dana yaningko Ged ande koween. ");
INSERT INTO yon_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Amaan angkon Lea yu deme wonong Silpa kuu Yekob ye dana mingki mamaa wooneen. ");
INSERT INTO yon_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Woonuune, Leambed yedmeen “Ne kuu kubaan kowe, nimambed ne yaa kubiyiib andaniib.” andekoru, dana yaningko Aser ande koween. ");
INSERT INTO yon_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Yob wi yaron arimbed, Ruben kuu wene mongkobon angka ane oyoomiib keri yeman yaningko mandreek kuu wedmekore, ye ena Leayiib yaa mandreek id benmonoon. Benmonoone, Rekselbed Lea yaa yedmeen “Anam, kub dana ye mandreek id kuu neyiib maawe.” andeen ");
INSERT INTO yon_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","kumban yumbed man yedmeen “Kubbed ne ambi kuu nenwenewen kumbed angkon ne dana ye mandreek id benwanandewedoo? Kuu yiminbanaa!” anduune Rekselbed yedmeen “Kub dana ye mandreek id kuu kawebko, ne korondaka kibik amnoom kee kub yoom nub ambi yoom dangime.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kwane oobnune Yekob kuu mongkobon angkambed menene Lea kuu wenganande muneen. Meneenu, yedmeen “Kibik eb kuu ne yoom danganuub, amborom kuu eb yoom dangi yeman kuu ne dana ye mandreek idbed moonaan kowe.” anduune, amnoom keruune ye yoom yu yoom dangiwen. ");
INSERT INTO yon_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God kuu Lea yu weng wengamboroon kowe, Lea kuu oyoomiib kerekoru, Yekob yaambed yu dana mingki angko wooneen. ");
INSERT INTO yon_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Woonekoru yedmeen “Godbed ne yaa kakman kawoon, amborom kuu ne deme wonong kuu ne karub yaa konaan kowe.” andekoru dana yaningko Isekar ande koween. ");
INSERT INTO yon_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Amaan angkon Lea kuu oyoomiib kerekoru, Yekob yaambed yu dana mingki kung wooneen. ");
INSERT INTO yon_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Woonekoru yedmeen “Godbed ne yaa amun yeka mamaa kawoon kowe, ne ambimbed ne yaa kuu amun meeni kawaneen, amborom kuu nembed ye karub dana kungiib woonaan kowe.” andekoru dana yaningko Sebulun ande koween. ");
INSERT INTO yon_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Amaan angkon dana wonong dana woonekoru, yu aningko Daina ande koween. ");
INSERT INTO yon_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kwane, Godbed Reksel yaa ika meenendekore, yembed dana wooni ye kiwaan nandoon. ");
INSERT INTO yon_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nandoone, oyoomiib kerekoru dana mingki woonekoru yedmeen “Godbed ne karak kuu kankoraroon.” andekoru, ");
INSERT INTO yon_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ika yedmeen “Ne dowaken kuu Yariman Godbed ne yaa dana mamaa ari kawaneen.” andekoru, dana yaningko Yosef ande koween. ");
INSERT INTO yon_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Kwane, Reksel kuu Yosef wooneen ye yondem kuu Yekobbed Leban yaa yedmoon “Ne kuu domowebko, nambibkin yaa wana. ");
INSERT INTO yon_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ne amerediib ne danayiib kuu domondebko benwana, eb ebkaad nembed eb deme yemoon ambangkaan kowe, domowebko nambibkin kiwaan yaa wana.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kumban Lebanbed ye yaa man yedmoon “Ne yaa eb dowaken kerebka keyaa dobere. Ne kuu kombon yorokmi yemanbed nekaadkeraan kuu Yariman Godbed ne yaa amun keruwoon, amborom kuu ewiib doriin kowe. ");
INSERT INTO yon_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kwani kowe, ne deme ye kakman eb dowakenmo kuu komoyiib kowok andewed kuu yedmebko, nembed eb yaa bangkabdimamaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Andoone, Yekobbed ye yaa yedmoon “Ebkaadkerewen, nembed eb deme ambangkaan kuu eb sibiyiib naningkodiib kuu nembed amunmo oonaan. ");
INSERT INTO yon_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kurin kuu eb dingkan kuu yemoonban kuned nembed mene oonaan kumbed Yariman Godbed eb yaa amun kerubdoonkob dingkan kab yewudmo kere daaneen. Kumban kibikee nekareb ne awene yaa andowe bangkandandamiin kuu yiminoo?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Andoone, Lebanbed kaamonoon “Eb kuu komo kabdaniin?” andoon. Andoone, Yekobbed man yedmoon “Yiribman ogood kuyaa kawaab. Kumban ebbed ma ne yaa kwananeeb kuu nembed angkon ika eb sibiyiib naningkodiib kuu oonimamaniin. ");
INSERT INTO yon_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ee andebko, kibikee nembed wene eb sibiyiib naningkodiib kuu nekweni sibi bodbod embengiib sibi bodbod darewoowiib naningkod bodbod embengiib naningkod bodbod darewoowiib yi mana kimi binmoyiib kuu andokbe kera kwananiin kuu eb deme ye kakman nembed awini yeman. ");
INSERT INTO yon_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ne yaa kakmanmo nembed baane akme anam andi yeman kuu ebbed wedmaneeb kuu ne dingkan kab nimingkaan aombed kuu dingkan bodbodiibbaniib angkon yi mana kimi binmoyiibbaniib kuu anam yid kandaan ebkaadkeri yeman.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Andoone, Lebanbed yedmoon “Eyoka, ebbed yedmeeb kuu kwane.” andoon kuned ");
INSERT INTO yon_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","kuyaron arimbed yembed ye karub dana meed yaa yemyeb yedmoonkob dingkan bodbodiib dingkan ambi akberekiniib yi mana kimi binmoyiib korem kuu ye dana meedbed yemyeb bene ");
INSERT INTO yon_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","aron ayoobmim ye ambab wenekorib nongkobiwen. Kwaniiwe, Yekob kuu Leban ye sibiyiib naningkodiib yemyeb bindo kuu oonimameen. ");
INSERT INTO yon_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kumban, Yekob kuu at yi aningko Poplariib Almoniib Pleeniib yi nondong kuu aangkekore kad yena doon kuu nondong id kawanmo angkaderebok anded, at nondong kuu akberekin areb keriwen. ");
INSERT INTO yon_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kwanekore, at nondong akberekiniib kuu sibiyiib naningkodiib yi arinambo arimbed ok yuungke bangkandimamiib yaambed nongkoboon kowe, dingkan kuu mene ok anandamenib at nondong dia yaambed durutkim keri yeman. ");
INSERT INTO yon_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kwanekorib, mana wanabiwen kuu bodbodiib akberekiniib kowe, Yekob yeman keroon. ");
INSERT INTO yon_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yekobbed mana kee andokbe yeka nongkoboon, kumban ambiyiib yingkiyiib kuu yi murubia kuu Leban ye dingkan kab binmoyiib akberekiniib yaa dedmobiwen. Kwanekore ye dingkan kuu yeka nongkobekore, angkon Leban ye dingkan kuu yeka nongkobe keroon. ");
INSERT INTO yon_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kwane dingkan yingki aromkonoyiib kuu amimbon ari dibarande kamiiwe, Yekobbed at nondong akberekiniib kuu kanwene yi indob ari kowoon kuu at nondong akberekiniib diambed durutkim dobiriwen, ");
INSERT INTO yon_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","kumban dingkan aromkonoyiibbanbed amimbon ari dibarande kamiiwe, Yekobbed at nondong akberekiniib kuyaa nongkobindo kowe, dingkan aromkonoyiibbanbed mana kiween kuu Leban yeman, angkon dingkan aromkonoyiibbed mana kiween kuu Yekob yeman. ");
INSERT INTO yon_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kwamunimaan kumbed Yekob kuu sibi yemooniib naningkod yemooniib boon kowe, ye kuu yiribman yemoon ye karub keroon. Kwane, ye kuu dingkan yemooniib ye deme karuwa nimayayiib kemoyiib donkiyiib. ");
INSERT INTO yon_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yekob wengamboroonka Leban ye karub danambed dakmiib “Yekobbed nub ambe ye yiribman korem kuu boon kii. Ye yiribman korem kuu nub ambe yaambed boon.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ye kwane wedmoon Leban kwangkon ye yaa amun amun kamindo, anukbed kamimaan arebban keroon. ");
INSERT INTO yon_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kwane Godbed Yekob yaa yedmenoon “Eb ambeya yi okad yaa angkon eb karubkim yaa ika wene. Ne kuu eb yaa dore awabdaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Andoona, Yekobbed Reksel yoom Lea yoom yaa weng kowoon “Yi ayoob kuu ne dingkan kab oone doriin yaa minime.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Miniiwa, yembed yi yaa daandoon “Ne nekaadkeraan, yiib ambe kuu ne yaa kubiyiibban keroon anukbed ne yaa kamimaan arebban. Kumban nambe ye God kuu ne yaa awawe doreen. ");
INSERT INTO yon_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Yiib kuu yiibkaad, ne kuu yiib ambe ye dowad ne aromkonoyiib korem ye deme awinaan. ");
INSERT INTO yon_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Kumban ye birawe ye deme awinaan ye kakman yeka mamaa kowe yeka mamaa kowe yeka mamaa kowe angkara angkara angko angkoyiib kere kowoon, kumban yembed ne yaa dabab maawindo amborom kuu Godbed ye yaa kebenoon kowe. ");
INSERT INTO yon_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Aron yena yaa Lebanbed ne yaa yedmimaan “Naningkod bodbodiib sibi bodbodiib kuu eb deme ye kakman kii” andimaane ari kuu naningkod koremiiwa sibi koremiiwa kuu mana bodbodiibmo wanabiwen. Amaan, sibiyiib naningkodiib Lebanbed akmekore, inamen maa kere ne yaa yedmimaan “Naningkod akberekiniib sibi akberekiniib ku eb deme ye kakman kii.” andimaane ari kuu naningkod koremiiwa sibi koremiiwa kuu mana akberekiniibmo wanabiwen. ");
INSERT INTO yon_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kwani kowe, Godbed yiib ambe ye sibiyiib naningkodiib kuu bene ne yaa bangkawoon.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Andekore ika yedmoon “Anuk kuu durutkim dobiri yaron muneen kuu kiyuum angkambed wedmaan kuu naningkod ambi bodbodiib akberekiniib kumbedmo yingki yaa durutkim dobiriwen. ");
INSERT INTO yon_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","God ye engyumbed kiyuum angka ne yaa baandoon ‘Yekob’ andoone ‘Ee, kee doriin kei.’ andaane, ");
INSERT INTO yon_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","yedmewoon ‘Wedme. Andaankob naningkod ambi bodbodiib akberekiniib kumbedmo yingki yaa durutkim doriib, amborom kuu Lebanbed eb yaa komo kameen kuu ne korem wedmiin. ");
INSERT INTO yon_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ne kuu God, Betel yaambed wane angkarene wengabdaane ebbed bot doboob numone kowekore, oil bune amob ongmewen ne yaa kii. Kibireb yaa eb yiribman korem nekwekoreb, ambibkin kee koronde eb wooneen ye okad yaa ika wene.’ andoon, kiyuum angkambed ne yaa.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Andoone, Reksel yoom Lea yoom Yekob yaa man yedmiwen “Nub ambe bobnaneene ye yiribman nekwiiwe nub kuu yiribman mimo maandaubban. Dowan! ");
INSERT INTO yon_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Yembed nub yaa owoddan areb ande meenimameen. Nub konid boon kuu korem anene kiradme dowan keroon. ");
INSERT INTO yon_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Yiribman korem ye yaambed Godbed be kabdoon kuu nub man nub danaya yi man keroon. Kowe, Godbed komo eb yaa kwane andoonka kwane.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Andekoriwa, Yekob ye amerediib ye meediib korem be kemo ari nongkoboona dibiriiwe, ");
INSERT INTO yon_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","yembed Aram ambibkin ye okad dabonmo aombed ye dingkan kab koremiib yiribman koremiib boon kuu korem nekwekore, dingkan kab yidin be ye awodki Aisekbed Keenan ambibkin doreen yaa ika andowe wonoon. ");
INSERT INTO yon_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kuye niindem aom Leban kuu wene ye sibi kimi wanabande wonoon, Reksel yaro dorenu yu ambe ye awad darewoob yi kuruwak akme meeni yeman (wedkongkono yi dowad areb) yid bene wuneen. ");
INSERT INTO yon_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Angkon Yekobbed Leban yaa nemengkanoon kuu ye yedmindo yemyebmo kombiri wonoon ");
INSERT INTO yon_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","kowe, Yekob yoom ye amered yoom ye meed yoom ye yiribman koremiib kombiri wene ok Yufretes yara yane wene aangko ambibkin Giliad aomnande winiwen. ");
INSERT INTO yon_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Aron ayoobmim dowan keruuna, Leban wengamboroonka Yekob kuu kombiri wonoon. ");
INSERT INTO yon_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kowe, Leban ye karubkim nekwane be yaro dore kerenenmo yoman wonoon. Aron ediib dowan keruune, Lebanbed Yekob durunenoon, aangko ambibkin Giliad aom. ");
INSERT INTO yon_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Kuye amnoom kuu God kiyuum angkambed mene Aram ambibkinman Leban yaa daanoon “Ebkaadkere! Weng amun o weng arewa Yekob yaa daanaab.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Kwane Yekob aangko ambibkin Giliad aombed parai kombon banaboon yaa Leban yoom ye karubkim yoom menekorib yi kwangkon yi parai kombon banabiwen. ");
INSERT INTO yon_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Kwanekoriwa, Lebanbed Yekob yaa yedmoon “Komarewa kerewen? Eb nemengkawene ne dana mungkana be menewen, ana nangbane be wenemoon areb kerewen. ");
INSERT INTO yon_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Komande nemengkaweneeb yemyebmo kombiri menewen? Yedmewindo kuu komoyiibkob kamewen? Yedmewewen karen, yiib wini dowad nubbed kubiyiib yok yeman haawa tamborina wangkanabe yokiib wingkanabe kamuubkob domowe miniwen karen. ");
INSERT INTO yon_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kumban, eb korondeewa ne awoyayiib ne mungkanayiib yaa be mandamuk bangkandi kuu kebenewen, eb kuu miin amunban korokiibban anam kamunewen kii. ");
INSERT INTO yon_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ne enbandi kuu yimin, kumban amnoom eb ambe ye Godbed daawene yedmewoon ‘Ebkaadkere! Weng amun o weng arewa Yekob yaa daanaab.’ andoon. ");
INSERT INTO yon_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ne nekaad, eb dowaken ika eb kurin doberewen yaa wanande menewen, kumban komande ne awad darewoob yi kuruwakiib yid benmenewen?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Andoone, Yekobbed Leban yaa inande yedmoon “Ne unaan, amborom kuu eb mungkana ayoob kee ebka baneeb ande meenaan. ");
INSERT INTO yon_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kane yaambed eb awad darewoob yi kuruwak wedmaneeb kuu ayiwed bobni yeman, nub karubkim yi arinambo arimbed, ebka kerekne wedmebko eb yiribman keroka kande.” andoon. Kumban Yekob kuu ye yekaadban, Rekselbed Leban ye awad darewoob yi kuruwak kuu yid benbikneen. ");
INSERT INTO yon_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kwane Leban kereknoon Yekob ye parai kombon aomiib deme nima ayoob yi parai kombon aomiib Lea yu parai kombon aomiib ongme kereknoon kumban ma wedmindo. Lea yu parai kombon aombed angkanekore, Reksel yu parai kombon aom aomnoon. ");
INSERT INTO yon_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rekselbed yu awodki ye awad darewoob yi kuruwak kuu benbikneen kuu yu kemo animari kurune dibiri yeman ye dabderem aom kowekoru kwari dibuun. Leban kombon dem korem kereknoon kumban wedmindo ");
INSERT INTO yon_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","kowe, Rekselbed yu awodki yaa yedmeen “Ambe, ne yaa kabawaab. Ne kuu yere yaro dobiri eb arinambo ari kuu yiminban, amborom kuu ne wood wedme dibiin kowe.” andeen. Kwane, Leban kombon dem korem kereknoon kumban ye awad darewoob yi kuruwak kuu ma bindo, dowan. ");
INSERT INTO yon_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ma bindo kowe, Yekob kuu norin wande yedmoon “Ne komo ambarakmaan? Amob komo domokbaankob ne yaa nenmo menewen? ");
INSERT INTO yon_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ebka onmewen, ne yiribman korem yuraan yaa, kumban eb yiribmaniib ma dabokne angkiboroona akmindo, dowan! Ma akmewen keroka kanmene nub karubkim arinambo ari korokbende, yi wedme kanembed ambarakmoon kanembed ambarakmindo kamime. ");
INSERT INTO yon_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ne weeb 20yiib eb deme ambangkaan. Kuye niindem aom aron korem kuu eb naningkod manayiib sibi manayiib kuu ma dana woonande bobnindo. Angkon, ne kuu eb sibi ambi ma aye anindo. ");
INSERT INTO yon_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Aron maa maa dingkan kiibbed eb sibi o naningkod ayimaib kuu kanmene korokbebdimokban, nembed sibi bobnoon ye dowadmo ne sibi maambed kankabdimamiin. Aronki o amnoom yaambed kanembed ma yid kandimaib kuu ebbed ne yaa baande yedmimaab ‘Yid kandiwen kowe, ye kakman kawe!’ andaawa kabdimain. ");
INSERT INTO yon_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Aronki kuu aronbed ne aromkono monmarimaun, ma amnoom kuu yuruk darewoob kandimain, unuk angkindeban. ");
INSERT INTO yon_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kwamune, deme darewoob weeb 20yiib awinaan, ma ibduruk weeb 14iib kuu eb dana mungkana ayoob yi awadmandid, ma ari kuu weeb kungiib kuu eb sibiyiib naningkodiib berengkandid awinaan. Kuyaron kumaom kuu ne deme ye kakman ebbed yeka mamaa ande kowe yeka mamaa ande kowe yeka mamaa ande kowe angkara angkara angko angkoyiib kere ande kowewen. ");
INSERT INTO yon_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kumban nambe Aisek ye God, Abraham ye God kuu ne yaa dore awawimameen. Godbed ne yaa dore awawindo karen, ne yaa kuu ebbed kwane ‘Wene!’ andeebkob kwane kamboknong manaan karen. Kumban God wedmoon dabab nembed kandaan kuu deme darewoob nembed ambangkimain kowe, eb yaa amnoombed ongkabdoon kui.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lebanbed Yekob yaa yedmoon “Nima kee ne mungkana. Angkon, yi meed kwangkon ne man. Angkon, sibiyiib naningkodiib kee kangkon ne dingkan kab. Angkon, yiribman korem akmeeb kuu ne yiribmanmo, kumban neka ne mungkanayiib yi meediib ika baniin dee? Yiminbanaa! ");
INSERT INTO yon_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kowe, nub ayoob weng mimo kere amob ongmem. Bot be wuubekoruwa, amaan kuyaa wedmekore meeni yeman kerem.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kwane, Yekobbed bot doboob kannumone kowoona doboroon. ");
INSERT INTO yon_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yembed yedmoonkob ye karubkim kwangkon bot be wuubiwen. Kwamunekoriwa, kuyaambed dibere animan aniwen. ");
INSERT INTO yon_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Leban kuye bot wuubiwen kuyaa kuu ye wengbed Yegasahaduta ande kowoone, Yekob kwangkon weng id mimo Hibru wengbed Galid ande kowoone kamiwen. ");
INSERT INTO yon_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lebanbed yedmoon “Kibikee bot kee wuubuwen keembed ewa neya amob weng ongmuwen akme meeni yeman.” andoon. Kwanikob aningko Galid andimamiib. ");
INSERT INTO yon_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Angkon aningko maa Mispa andimamiib, amborom kuu Lebanbed yedmoon “Kwane, nub kuu andokbe yeka yeka wenebanuub kuu Yariman Godbed ewa neya yaa kerendobere wengyunde doborok. ");
INSERT INTO yon_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Meenem, karub yena nub amob wedmindo kumban nub amob ongmuwen kuu Godbed wedmoon kowe, ne meed yaa arewa kamaneeb o nima yena ma awadmaneeb kuu Godbed wedme yekaadkeraneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Andekore, Leban ika yedmoon “Eb dore ne dore bot kee wuubaaniiwa bot doboob kannumone kowaaniiwa kuu kui. ");
INSERT INTO yon_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Keye bot wuubaan keyiiwaa, keye bot doboob kannumone kowaan keyiiwa kuu wedme meeni keriwen, nembed bot kee burudande mene eb yaa arewa kamainban, man kwangkon ebbed bot kee mene burudande ne yaa arewa kamaabban. ");
INSERT INTO yon_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Korondubko, amob kee domokbanuub kuu Abraham ye God, angkon Nehor ye God, angkon yi ambeya yi God kumbed ewa neya wengyunde dabab kondok.” andoon. Kwamuneene, Yekobbed amob weng yambe Aisek ye God yaningko yaambed ande kowoon. ");
INSERT INTO yon_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Kwane, Yekobbed aangko ambibkin aombed dingkan ma ayene ningkaneene agedmo keroone baeb kuu God yaa konoon, angkon Leban yoom yi karubkim yoom yaa baandoona korem miniiwa orok mana aniwen. Anekorib, amnoom kuu kuyaa kwari dangiwen. ");
INSERT INTO yon_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Awari amkimokaimbed Leban yeedere yaro ye awoyayiib ye mungkanayiib yaa mandamuk kerunde amun kerundekore, domonde ika yambib angka wonoon. ");
INSERT INTO yon_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kuye aron Yekob kwangkon ye okad yaa wini ye dowad weneena God ye engyusbed wedya wenganiwen. ");
INSERT INTO yon_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kwane, Yekob wedmendekore, yedmoon “Keke, God ye Kombonbonkibi kii!” andoon kowe, aningko kowe yedmoon “Bid kari kee, Mahanaim kii!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yekob yaro dore ye weng kanwini ye karub baandoona miniwen, ye dowaken kuu yambang Isaumbed Idom ambibkin aom okad Sia yiri doreen yaa ye weng kanwinime anded kowe, ");
INSERT INTO yon_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yekobbed yi yaa daandoon “Weng kuu kwamune dakme daanime, ne korok Isau yaa. Eb deme karub Yekobbed yedmoon ‘Ne kuu Lebaniibbed doberembaraan kuned kibikee manaan. ");
INSERT INTO yon_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ne kuu buromakauiib donkiyiib sibiyiib naningkodiib deme nimakaruwiib kii. Eb kuu ne korok kowe, ne weng kowaana eb yaa munuun kuu, ne yaa dowaken kerebka andid kaamonaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Weng kanwenekorib, ika mene Yekob yaa yimbed daaniwen “Nubbed eb ambang Isau yaa wunuwen kowe, kibireb yembed eb yaa wengabdande meneen, angkon ye karub 400iib dabokne doriiwa meniib.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yekob wengamberekore, uni darewoob kubiyiibban kerebkarab kamene meenoon. Yembed yaro dore ye yiribman korem andokboon, nimakaruwiib sibiyiib naningkodiib buromakauiib kemoyiib yiribmaniib yeka yeka andokbe ayoob nekwoon. ");
INSERT INTO yon_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yekob ye meeni kuu Isaumbed mene karub yenayiib dingkan kab yenayiib nekwoon kuu yoka, yena angkara nekwoon kuu kirikmone wananiib kowe yaibban ande meenmoon. ");
INSERT INTO yon_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kwamune, Yekob kurikuri kere yedmoon “Oo nawo Abraham ye God, nambe Aisek ye God! Yariman oo! Ebbed yedmewewen ‘Ika eb ambibkiniib eb ena ambeyiib eb karubkimiib yaa wene. Eb yaa oone amun amun kamaniin.’ andewen. ");
INSERT INTO yon_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ne kuu eb deme karub kuned ebbed aron korem ne yaa mimyob kewembirimameeb, ne yaa meenmewembirimameeb kuu ne kakmanban, ebbed munob kawewen. Kurin kuu nembed ok Yorden yanaan kuu ne yonamadmo awine yanaan. Kumban ne kibikee yiribman yemooniib baan kowe, nekwanabe ayoob keraan. ");
INSERT INTO yon_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nambang Isau ye arud wandi ne yaa kebene, amborom kuu ne kuu unaan, yembed mene ne yoom danaya awaana yoom kuu yaneen ande meenaan. ");
INSERT INTO yon_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ebbed ne yaa yedmewen ‘Ne kuu korobe ooneni awabdeni ongmaniina dobere dana yemoon kereneeb, karamok kebed yaa ye kubuk mimim kimingki yiminban areb keraniib.’ andewen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yekob kuyaa dobere miriknoona angkoone waroone ye yiribman yena Isau yaa munob bangkani yeman nekwoon kuu ");
INSERT INTO yon_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","naningkod yingki 200iib, naningkod ambi 20yiib, sibi yingki 200iib, sibi ambi 20yiib, ");
INSERT INTO yon_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kemo yingki 30yiib yi danayiib, buromakau yingki 40yiib, buromakau ambi angko angkoyiib, donki yingki 20yiib, donki ambi angko angkoyiib kwamune nekwoon. ");
INSERT INTO yon_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Yekob ye deme karub mimo mimo kwamune nekwoon kwane ooni yeman. Yembed yedmoon “Yiibdin arinambo winime. Karub mimo ye dingkaniib wonoko, karub mimo ye dingkaniib yoman wonoko yeka yeka kamime, ika daboknaib.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","karub arinoon yaa daanoon “Ewiib dingkaniib winiiwo nambang Isaumbed wedmebde wengabde kaamondene ‘Yiib kane ye karub, kuna yaa weniib, dingkan kab kee kane yeman?’ kamoonka, ");
INSERT INTO yon_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","eb kuu kwamune yedme ‘Dingkan kab korem kee eb deme karub Yekob yeman kii! Yi kuu munob dingkan ye korok Isau yaa bangkanoon. Angkon ye kuu nub yoman meneen.’ ande.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ye kwamune angkon yoman wonoon ye karub yaa kwangkon daanoon. Yi yoman wenebiwendan yaa kangkon weng mimo kwanamo bangkandoona yi kuu dingkan kawiib andowe benwiniwen. ");
INSERT INTO yon_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","daandekore, ika yedmoon “Yiib nonondandaib yedmenime ‘Eb deme karub Yekob kuu nub yoman meneen kii!’ andime.” ande Yekobbed yedmoon, amborom kuu yembed meenoon kuu “Mokuro, munobmo dingkan kab kee bangkananiin kuu, Isaumbed wedmekore, mimyob kewene ne yaa norin dowan kerok anded, ne yaa amunmo kame durunewok meneen dee?” ande meenoon. ");
INSERT INTO yon_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kwamune Yekob ye munob bangkandi yeman kuu ye deme karubbed arinambo benwiniwena, ye kuu ika parai kombon aom doboroone miriknoone angkoon. ");
INSERT INTO yon_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kuye amnoom Yekob yarone ye nima ayoowiib deme nima ayoowiib karub dana 11iib kuu bene yuroone ok Yabok yara okeed yaambed yaniwen. ");
INSERT INTO yon_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kwane benyuroone yaniiwe, ye yiribman korem kuu yomanbed benyuroone yaniwen. ");
INSERT INTO yon_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kwamune, Yekob kuu yembedmo domoneniwen kuye niindem aom amnoom kuu karub maa monoona, Yekob yoom nangme awine kanyiri kowoon kanyiri kowoon kamiiwa, indob yaamo waroon. ");
INSERT INTO yon_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Karub kumbed wedmoonka, ye kuu burudankorare winindeban keroon kowe, karub kumbed Yekob ye mookono God ye aromkonombed dedmonoon kob doomboroon. ");
INSERT INTO yon_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kwamune karub kumbed yedmoon “Ware weneen kii! Kui yaa, kwamune domowebko wana yaa!” kamoone, Yekobbed man yedmoon “Kwamaubbanaa! Ebbed ne yaa amuniib kawewedned domobdain oo!” andoone, ");
INSERT INTO yon_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","karub kumbed yedmoon “Eb aningko kuu kane?” andoone “Ne kuu Yekob.” andoone, ");
INSERT INTO yon_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","karub kumbed yedmoon “Kibikee eb aningko kuu Yekob andimban, Israel andaniib kii, amborom kuu eb yoom God yoom nangme awine kanyiri kowoon kanyiri kowoon kameniiwa burudandewen, angkon eb yoom karub maa maa yoom nangme awine kanyiri kowoon kanyiri kowoon kameniiwa burudandewen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yekobbed yedmoon “Kwani kowe, eb aningko kuu kane, yedmewe.” andoon, kumban karub kumbed yedmoon “Komandewed naningko kaadkerandewed?” andekore, Yekob yaa amun kerunekore wonoon. ");
INSERT INTO yon_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kumbed Yekobbed yedmoon “God ne indobbed wedmaan kumban ne bobnindo kowe, okad keyaa kee Peniel ande kowaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Andekore, aron yaro mene darewoob keruun yaambed yaro okad Peniel kuu domonde wonoon. Ye yon kuu kanenanmo wonoon, amborom kuu mookono doomboroon kowe. ");
INSERT INTO yon_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kwana kowe, wene kibikee, Israeldan kuu dingkan mookono yaa mekmeed yom kuu animokban, amborom kuu Godbed yom kee yaa kuu Yekob dedmonoon kowe. ");
INSERT INTO yon_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","2","Yekob korok kankoone wedmoonka yambang Isau kuu meneen kowe, Yekob mene deme nima Bilha yoom Silpa yoom yi dana yoom kuu be nekwekore yedmoon “Yiib kuu yiibdin wini yeman.” andekore, ma Lea yoom yu meed yoom kuu be nekwekore yedmoon “Yiib kuu wedya wini yeman.” andekore, Reksel yoom yu mingki Yosef yoom kuu be nekwekore yedmoon “Yiib kuu yoman wini yeman.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Andekore, yekareb yedinmo arinambo Isau yaa wenene bumangkane okad yiri korok kankibinene ika dembe kame ediib kere yambang Isau ye dia monoon. ");
INSERT INTO yon_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kumban Isau kabaanmo wene Yekob awinene nenkangkunekore mandamuk kowoone, yi ayoob amengiib kamenabiwen. ");
INSERT INTO yon_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kwamunekoriwa, Isau kerekanabe wedmoona nimayiib danayiib yayaa doriib. Wedmekore kaamonoon “Kee kaneya eb yoom meniib?” andoone Yekobbed man yedmoon “Ne korok ee! God kuu ne yaa amun kewoon kowe, yi kuu dana yembed ne yaa bangkawoon.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Andoone, deme nima yoom yi dana yoom kuu menekorib, bumangkane okad yiri korok kankibine yeediriwen. ");
INSERT INTO yon_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kwane, angkon yoman Lea yoom yu meed yoom kuu menekorib, bumangkane okad yiri korok kankibine yeediriwen. Kwane, angkon yoman Yosef yoom Reksel yoom kuu menekorib, bumangkane okad yiri korok kankibine yeediriwen. ");
INSERT INTO yon_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Kwanekoriwe, Isaumbed kaamonoon “Komo dowad eb deme karub dingkan kawiib kuu kwamune nekweebkob arinambo miniwen?” andoone Yekob man yedmoon “Yi kuu eb munob bangkabdandid kwamunaan kuu mimyob kewe andid.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kumban Isaumbed yedmoon “Ne daman ee, ne kuu yiribman yimin baan kowe, ebka amukne.” andoone, ");
INSERT INTO yon_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yekobed man yedmoon “Ne dowakenbanaa. Kwamune ne yaa eb niindem aom kuu dowakeniib kerebka, nembed komo bangkabdaan kuu be yaa. Angkon ebbed ne yaa eb niindem aom dowakeniib kerewen kowe, eb murubia wedmaan kuu God ye murubia wedmemoon areb keraan. ");
INSERT INTO yon_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","God kuu ne yaa amun amun keruwoon kuu, ne kuu animan yiminiib, dingkan kab yiminiib, od yiminiib kwamune doriin kowe, anam kuu bewed yimin.” ande kwamune yedme yedme kamoone Isau kuu inamen amonombekore dingkan boon. ");
INSERT INTO yon_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kwane Isaumbed yedmoon “Nub kandabokne ibmo kere wenem.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kumban Yekobbed yedmoon “Ne korok ee, eb ebkaad, dana kuu yi aromkonoyiibban kerene ne dingkan kab kwangkon manayiib kowe, emambed benwini kuu yimin. Ma ne dingkan kawiib kirodmo kabaanmo wenemoon areb kere aron mimo wananiin kuu dingkan kab kuu ma yowore wananiib. ");
INSERT INTO yon_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kwani kowe, koronde ebdin wene. Eb deme karub ne kuu yoman mananiin, emamo dingkan kawiib danayiib yi wini kara areb be menembaraniin kowe, emamo mene eb Idom ambibkin aom doreeb yaa daraniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Andoone, Isaumbed yedmoon “Ne karub yenayiib domobde wananiina dore awabdaniiwa mananeewoo?” andoone Yekobbed yedmoon “Dowanoo! Kwamaawaa! Ne yaa eb niindem aom dowakeniib kumbedmo kuu yiminaa.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kwanoone, kuyaron ari Isau andowe ika Idom yiri wonoon. ");
INSERT INTO yon_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kumban Yekob kuu okad mamaa yiri wenekore, yambib yenbe angkon dingkan kab yi dobiri ye kombon arumenaboon. Kwana kowe, okad kuyaa kuu aningko Sukot andiwen. ");
INSERT INTO yon_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yekobbed Keenan ambibkin aom aomnekore, wene Sekem taun yiri monoon kowe, anukbed Aram ambibkin ye okad dabonmombed mini kuu dowan keroon. Taun diambed parai kombon yenbe doboroon. ");
INSERT INTO yon_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ye kuu parai kombon yenbe doboroon ye okad kuu Hamor ye mingki Sekem yaambed od yeman silva 100iib moonoon. ");
INSERT INTO yon_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kuyaa God yaa dingkan aye ningkane agedmo keroone baeb God yaa koni yeman botbed wuubekore, aningko Eleloheyisrael ande kowoon. ");
INSERT INTO yon_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Kwane, Yekob yoom Lea yoom yi mungkan Daina kuu ambibkindan yi nima yaa ogood dakmok wuneen. ");
INSERT INTO yon_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kuye niindem aom Hiv ambibkin ye karub yi taun Sekem ye korok Hamor ye mingki Sekem kuu Daina wedmendekore, awine yu yaa ambarakmoon. ");
INSERT INTO yon_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ambarakmekore, ye mimyob dowaken darewoob yu yaa keroon kowe, angkon yu yaa mimyob dowaken ye weng daandoon. ");
INSERT INTO yon_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Kowe, yambe yaa wene yedmoon “Wonong koyu kee yu arian yaa dakme amodebko awana, ne wonong kera.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Amaan Yekob wengamboroonka, ye mungkan Daina kuu karub maambed awine ambarakmoon andiwen kumban, ye karub dana kuu mongkobon angka dingkan kab kereek ooniwena ano doriib kowe, weng kee dakmindo. Yiyiib miniwed weng dakmaub ande meene doreen. ");
INSERT INTO yon_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kwane, Sekem yambe Hamormbed Yekob yaa weng dakmok wonoon. ");
INSERT INTO yon_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Weneene, Yekob ye karub dana wengamberekorib, dingkan kab oone doriib angkambed miniwen. Yi korem niindem aom kubiyiibban kere noriniib wande miniwen, amborom kuu yembed Yekob ye mungkan awine ambarakmoon kuu karak bobni yeman arewa anam Yekob awene yaa kamoon kowe. Kwamuni kuu yiminban anam. ");
INSERT INTO yon_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Mene doriiwa, Hamormbed mene yi yaa yedmendoon “Ne dana Sekem kuu ye mimyob dowaken darewoowiib eb dana mungkan kuyaa keroon. Yu kuu ne dana konebko, awanene ye wonong keraneen kuu amunoo? ");
INSERT INTO yon_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Neman neman awadmem. Yiib nima koyu nub kewedbed awadmibko, man nub nima koyu yiib kewedbed awadmibko kamem. ");
INSERT INTO yon_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kwamenub yiib kuu nub yoom doberem, amborom kuu okad kuu yiib yaa amowiibban kowe. Dobereniiwa deme maa maa ambangkanabe yiibbed nub yaa berengkiiwo, man nubbed yiib yaa berengkuuwo kamenabe doberem. Angkon bidambib yena amodaniib kuu yimin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kwane Sekembed Daina yu awodki yaa yu ambanga yaa angkon daandoon “Kwamune ne yaa yiib niindem aom kuu dowakeniib keribka, yiibbed komo yiribman yedmaniib kuu kwane kondaniin. ");
INSERT INTO yon_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Yu konid komoyiib kuu kwane yedme koweniiwa yumaniib yu karubkim yimaniib yedmaniib kuu yimin, yiibka yiib dowakenmo. Kumban no koronde wonong koyu kumbedmo kawibko awane ne wonong kera.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yekob ye karub danambed neman yedmiwen kuu Sekem yoom yambe yoom yaa birondiwen, amborom kuu yi yangkura yaa Sekembed awine kanwene ambarakmoon kowe. ");
INSERT INTO yon_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Yimbed yedmiwen “Nub kuu ee andauwa nub yangkura awanaabban, amborom kuu yiib kuu nub arebban, wekono kad wanabindo kowe. No kwane kabdanuuwa awananeeb kuu nub kuu karak darewoob kandanuub. ");
INSERT INTO yon_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nub deme mimo yiib yaa kondanuuwa ee ande ambangkaniib kuu yimin, deme kuu wekono kad wanabenib nub areb keraniib kuu yimin. ");
INSERT INTO yon_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kwamuniwed, nub nima koyu yiibbed awadmiweda, man yiib nima koyu nubbed awadmuwed kami kumbed yimin. Yiib yoom dabokne doberenuwa, nimakarub weng mimo keranuub. ");
INSERT INTO yon_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kumban nub weng wengambere ee andokban wekono kad wokban keraniib kuu nub yangkura nendenuwa nub koronde wananuub.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Andekoriwa, Hamor yoom Sekem yoombed meeniib kuu Yekob ye karub danambed weng ongmiib kuu yimin amun andiwen. ");
INSERT INTO yon_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kewedman Sekem kuu wengamberekore, “Kibireb kwananuub kii!” ande meenoone yambe yoom kirod koronde winiwen, amborom kuu ye dowaken darewoob kuu Yekob ye mungkan awananded kowe. Ye kuu ye karubkim burudandoona taundanbed ye yaa karub amun ande yedmimamiib. ");
INSERT INTO yon_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kowe, Hamor yoom ye mingki Sekem yoom wene yi taun ye kuuk darewoob yambongko yaa nedbimbonbed dore yi taundan yaa daandiwen. ");
INSERT INTO yon_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Keyee karub kee nub yaa amun amun kamiib kii! Kowe, korondanuuwa nub okad ari dobaraniib kuu yimin. Nub kumkam yi yaa berengkanuuwa yi kumkam nub yaa berengkaniiwa kamanuub kwangkon yimin, bidambib kuu darewoob yimin yiyiib nuwiib dobiri kuu. Nubbed yi koyu awadmubko, man yimbed nub nima koyu awadmibko kamanuub kwangkon yimin. ");
INSERT INTO yon_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kumban, yimbed yedmiwen nuwiib yiyiib dabokne dobiri yeman kuu kei. Nub karub korem kuu wekono kad wanabi yeman, yi areb keri yeman. ");
INSERT INTO yon_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kwamanuub kuu yi sibiya buromakauya yiribmana dingkan kawa kuu korem nub man keraneen kii! Kowe korondekoruwa, weng mimo kere yi weng wengambere kere ee andekorub, ibmo doberem.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Karub korem taun ye kuuk darewoob yambongko yaa miniwendan kuu weng kei wengambiriwen kowe, yi korem Hamor yoom Sekem yoom yaa ee andekoriwa, yi korem yi wekono kad kuu wanabiwen. ");
INSERT INTO yon_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Aron ayoobmim dowan keruune, karub korem wekono kad wiwendan kuu yewed bobne dangiwena, Yekob ye karub dana ayoob Simion yoom Livai yoom, Daina yu ambangambed yaro yi kerewang be wene karub wekono kad wiwen korem kuu yenbandiwen, taun aom doriibdan yikaadkerindo kowe, korem yiwen, angkon ");
INSERT INTO yon_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","yi ayoobbed Hamor yoom Sekem yoom kangkon yenib, angkon Daina Sekem yambiwoom kuu nenkoronde winiwen. ");
INSERT INTO yon_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yekob ye karub dana yena kuu yi aagoroka ayoobbed karub yiwen yi bob id akmekorib, karub bob yi yiribman taun aom dangoon koremiib yi yid biib, amborom kuu Sekembed Daina yaa taun angka ambarakmoon kowe. ");
INSERT INTO yon_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Yid biiwa, Sekem taun aomiib ambunangka dingkan kab korem sibiyiib, naningkodiib donkiyiib komo komo kuu Yekob ye meedbed bekorib, ");
INSERT INTO yon_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","danayiib nimayiib ambiwoom korem yiribman amun amun dange weneen kuu korem yimbed yi kakman areb be winiwen. ");
INSERT INTO yon_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yekobbed ye karub dana Simion yoom Livai yoom yaa daandoon “Yiib kuu dabab darewoob kawekoriwa, ne ari kereknewiib kii. Kowe, kibikee ambibkin Keenandaniib Perisdaniib kuu nub yaa bondan keraniib. Nub karub kuu yemoonban kowe, yi daboknekorib nub yaa ana nangbaniib kuu nub korem yenbandaniiwe duknanuub.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Yi inande yedmiwen “Kumban, yembed nub yangkura kuu kande kiwaan ari ye wonong areb meenekore ambarakmoon kuu miin arewa kii!” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kwani kowe, Yekob yaa Godbed yedmenoon “Betel ari wene. Kuyaa dobere, eb ayi Isau yaa une kombiri weneewa, nembed wane angkadaraane wedmewewen kuyaambed botbed dingkan agedmo kereene ne yaa baeb koni yeman wuube.” andoon ");
INSERT INTO yon_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","kowe, Yekobbed karubkimiib karub ye yaa doriiwiib yaa yedmoon “Ambibkin maa yi awad darewoob yi kuruwak korem kuu benkirariiwa, ogambekorib, ambarakmaib, ebkad yeeb ben inwarime. ");
INSERT INTO yon_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kwane minime. Minibko, nub korem Betel ari wenem. Wene kwarimbed God yaa nembed botbed dingkan agedmo keri yeman wuubaniin. Yembed ne dabab kandimain yaa awawembirimaan, angkon kuna yaa yarebimain yaa yembed dore awawembirimaan kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kwanandoona, yi korem awad darewoob yi kuruwakiiwa kenooged witkon areb yi kenood dem aom nongkobiweniib korem Yekob yaa be miniiwa Sekem taun ye at kubun keedbon yiri mangkoon. ");
INSERT INTO yon_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mangkoona, yi korem winiwen. Winiiwa, taun yi angkara dobere weniib kuu Godbed uni kondoona yi dowad emderene ma winindo.|U ");
INSERT INTO yon_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Kwane, Yekob yoom ye nimakarub korem yoom Keenan ambibkin aom Lus taun kuyaambed winiwen. (Kibikee Lus kuu Betel andimaib.) ");
INSERT INTO yon_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Wenekoriwa, dingkan nengke baeb koni yeman kuu botbed wuuboon. Anuk yiri kuu ayi yaambed une kombiri weneenkob kuye okad yaa nandekore God kuu wane angkadere wedmenoon kowe, wuubimbon yaningko Elbetel ande kowoon. ");
INSERT INTO yon_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Kuyaron kuu Rebeka yu awandi wonong Debora kuu bobneen. Bobnuuna, okad Betel dia at ook ambokab dia mangkiwen. Kwane, at yaningko Alonbakut ande kowoon. ");
INSERT INTO yon_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yekob kuu Betel ika monoon kowe, Aram ambibkin ye okad dabonmo yaambed ye yare ika mene dowan keroon. Kwani kowe, Godbed ika wane angkadere amun kerune ");
INSERT INTO yon_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","yedmenoon, “Eb aningko kuu Yekob kumban, kibikbed nare ari kuu eb aningko yeeb Israel ande kowaan.” andoon. Godbed Yekob yaa aningko yeeb Israel ande kowekore, ");
INSERT INTO yon_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ari yedmenoon, “Ne kuu Aromkono Darewoob ye God kii. Eb kuu dana yemooniib kerebko eb awoya yemoon kerime. Ambibkin yemoon kuu eb yaambed andowaneen, angkon eb kuu king yemoon yi ambokab keraneeb. ");
INSERT INTO yon_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Okad ambibkin kee Abraham yoom Aisek yoom yaa kondaan kuu eb yoom eb awoya ari yoom yaa kangkon kondaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Dakme dowan kerekore, Godbed Yekob domonene kawonoon. ");
INSERT INTO yon_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","God yoom dobere dakmiwen yiri kuu Yekobbed bot doboob kan numonekore, God yaa amun dakmuwen andi ye dowad wain okiib oiyoyiib bunoon. ");
INSERT INTO yon_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kwanekore, yumbon kuu Yekobbed Betel ande ika yedme kowoon. ");
INSERT INTO yon_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Amaan, Yekob yoom ye nimadana yoom Betel koronde winiwen. Wene kambong Efrat dia weniib yaambed Reksel odibin woona dana woonande yewed darewoob kandeen. ");
INSERT INTO yon_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Odibin waan kuu yiminban yewedbed darewoob keroone, yu deme wonongbed yedmeen, “Dana kee kangkon karub dana kowe unaab!” andeen, ");
INSERT INTO yon_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","kumban Reksel kuu bobne wenenu inum yeenbon narenu yedmeen, “Dana yaningko kuu Benoni.” andeen, kumban yawodkimbed yedmoon kuu Benjamin andoon. ");
INSERT INTO yon_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Reksel bobnuuna, yu kuu kambong Efrat kiwaan kebed dia mangkiwen. (Kibikee Efrat kuu Betlehem andimaib.) ");
INSERT INTO yon_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Kuyaa kuu Yekobbed bot doboob kan numonoon. Kibik kangkon kuyaa kuu Reksel yu bobkonombon ye bot kan numonoon angkeen. ");
INSERT INTO yon_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Kwane, Israel kuu wenene Migdaleder burudandekore parai kombon bane doboroon. ");
INSERT INTO yon_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israel kuu ambibkin kuyaom doreen kuu ye dungkud wonong Bilha yaa kuu ye mingki Rubenbed nenem kamoone, Israel wengamberekore norin wandoon. Yekob ye karub dana kuu wad ayoowiib. ");
INSERT INTO yon_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leambed yu karub dana wanabeen kuu kei, Ruben yoom Simeon yoom Livai yoom Yuda yoom Isekar yoom Sebulun yoom kui. Ruben kuu Yekob ye wonob dana. ");
INSERT INTO yon_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rekselmbed yu karub dana wanabeen kuu kei, Yosef yoom Benjamin yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Reksel yu deme wonong Bilhambed yu karub dana wanabeen kuu kei, Den yoom Naftalai yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea yu deme wonong Silpambed yu karub dana wanabeen kuu kei, Ged yoom Aser yoom kui. Yekob ye karub dana Aram ambibkin ye okad dabonmo aombed wanabiwen kuu kui. ");
INSERT INTO yon_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yekob kuu awodki Aisekiib Mamre yaa wonoon, Abraham yoom Aisek yoom dobiriwen yaa. Mamre kuu Hebron dia. ");
INSERT INTO yon_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisek ye weeb korem doboroon kuu 180yiib ");
INSERT INTO yon_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","amunmo doberekore, bobnekore ye karuwayiib yaa daboknoon. Bobnoona, Isau yoom Yekob yoombed ye kuu mangkiwen.|H ");
INSERT INTO yon_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Keke Isau ye awoya yi weng. Isau yaningko mamaa kuu Idom. ");
INSERT INTO yon_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Isau kuu Besmat yoom Keenan nima Ada yoom Oholibama yoom awadmoon. Ada kuu Hitman Elon ye mungkan. Oholibama kuu Hitman Sibeon ye dana Ana ye mungkan. Besmat kuu Ismael ye mungkan, Nebaiot ye daman. ");
INSERT INTO yon_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adambed Isau ye dana Elifas wooneen. Besmat kuu Reuel wooneen. ");
INSERT INTO yon_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama kuu Yeus yoom Yalam yoom Kora yoom kwane wanabeen. Isau ye karub dana Keenan aombed wanabiwen kukui. ");
INSERT INTO yon_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isau kuu ye amerediib ye karub danayiib nimadanayiib yambiwoom doriib ye karuwiib ye dingkan kawiib ye dingkan yenayiib ye yiribman koremiib Keenan aombed boon kuu ye daman Yekob kuu domonene wene okad ambab angkambed doboroon. ");
INSERT INTO yon_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Kurin kuu yimbed ooniwen yi yiribman kumbed yemoon keroone, okad kuyaom yi ayoob dobiri kuu yiminban, amborom kuu yi dingkan kab yemoon keroon kowe yi animaib kuu kirod dowan kerimaan. ");
INSERT INTO yon_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kowe, Isau kuu aangko ambibkin Idom yaa wene doboroon. ");
INSERT INTO yon_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Isau ye awoya yi weng kuu kei. Ye awoya kuu aangko ambibkin Idomdan kui. ");
INSERT INTO yon_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Keke Isau ye karub dana yi aningko. Elifas kuu Isau yoom Ada yoom yi dana mingki. ");
INSERT INTO yon_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifas ye karub dana kuu Teman yoom Omar yoom Sefo yoom Gatam yoom Kenas yoom kwane. ");
INSERT INTO yon_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Isau ye mingki Elifas kuu dungkud wonong animari awanoon yu aningko kuu Timna, yumbed dana mingki Amalek wooneen. Kukuu Isau ye wonong Ada yu awoya. ");
INSERT INTO yon_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel kangkon Isau yoom Besmat yoom yi dana mingki. Reuel ye karub dana kuu Nahat yoom Seera yoom Sama yoom Misa yoom kwane. Kukuu Isau ye wonong Besmat yu awoya. ");
INSERT INTO yon_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isau ye wonong Oholibama, yu kuu Ana yu mungkan, Sibeon ye awo. Yumbed karub dana kuu Yeus yoom Yalam yoom Kora yoom kwamune wanabeen. ");
INSERT INTO yon_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Keke Isau ye awoyambed korok korok keriwen. Isau ye wonob dana Elifas ye karub dana kuu korok korok keriwen kuu Teman yoom Omar yoom Sefo yoom Kenas yoom ");
INSERT INTO yon_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora yoom Gatam yoom Amalek yoom kwane. Keke yi kuu Elifas ye awoyambed Idom aom korok keriwendan. Yi kuu Ada ye awoya. ");
INSERT INTO yon_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Isau ye dana Reuel ye karub dana kuu korok korok keriwen kuu Nahat yoom Seera yoom Sama yoom Misa yoom kwane. Yi kuu Besmat yu awoya. ");
INSERT INTO yon_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Isau ye wonong Oholibama yu karub dana kuu korok korok keriwen kuu Yeus yoom Yalam yoom Kora yoom. Keke Isau ye wonong Oholibama, Ana yu mungkan yaambed korok korok keriwen. ");
INSERT INTO yon_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Kukuu Isau ye karub dana, Idomdan yi korok korok. ");
INSERT INTO yon_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Keke Horman Sia ye karub dana, ambibkin kuyaom doriib kuu Lotan yoom Sobal yoom Sibeon yoom Ana yoom ");
INSERT INTO yon_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison yoom Eser yoom Disan yoom kwane. Yi kuu Idom aom Hordan yi korok korok keriwen. ");
INSERT INTO yon_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan ye karub dana kuu Hori yoom Homam yoom. Timna kuu Lotan ye yangkura. ");
INSERT INTO yon_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal ye karub dana kuu Alvan yoom Manahat yoom Ebal yoom Seefo yoom Onam yoom kwane. ");
INSERT INTO yon_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon ye karub dana kuu Aia yoom Ana yoom kwane. Ana, yembed awodki Sibeon ye donki bene amiibban koknoon ye okad yaa benwonoone kereek aniiwa kirubdem ok niminiib wedmoon. ");
INSERT INTO yon_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana ye dana mingki kuu Dison angkon ye wonong dana kuu Oholibama. ");
INSERT INTO yon_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison ye karub dana kuu Hemdan yoom Esban yoom Itran yoom Keran yoom kwane. ");
INSERT INTO yon_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser ye karub dana kuu Bilhan yoom Saavan yoom Akan yoom kwane. ");
INSERT INTO yon_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan ye karub dana kuu Us yoom Aran yoom. ");
INSERT INTO yon_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Keke Hordan yi korok korok, Lotan yoom Sobal yoom Sibeon yoom Ana yoom ");
INSERT INTO yon_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison yoom Eser yoom Disan yoom kwane. Kukuu yi kuu yi amyenimbon yi korok korok Hordan Idom ambibkin aom doriib. ");
INSERT INTO yon_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Keke Idom aom king kere ooniwen yi weng. Israeldan kuu yaro korok kerindo yaron. ");
INSERT INTO yon_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor ye dana Bela kuu Idomdan yi king keroon. Ye taun yaningko kuu Dinhaba. ");
INSERT INTO yon_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Kwane bobnoone, Seera ye mingki Yobab, Bosra taun ye karub kumbed king keroon. ");
INSERT INTO yon_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kwane bobnoone, Husam, Teman ambibkin ye karubbed king keroon. ");
INSERT INTO yon_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kwane bobnoone, Bedad ye mingki Hadadbed king keroon. Ye kuu Moab ambibkin kambong Midiandan yaa nangmene burudandoon. Ye taun yaningko kuu Avit. ");
INSERT INTO yon_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kwane bobnoone, Samla, Masreka ye karub kumbed king keroon. ");
INSERT INTO yon_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kwane bobnoone, Saulbed king keroon. Ye kuu ok Yufretes kung ari ye taun Rehobot ye karub. ");
INSERT INTO yon_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kwane bobnoone, Akbor ye mingki Baal-Hananbed king keroon. ");
INSERT INTO yon_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kwane bobnoone, Hadadbed king keroon. Ye taun yaningko kuu Pau, ye wonong yu aningko kuu Mehetabel. Yu kuu Matred yu mungkan, Me-Sahab yu awo. ");
INSERT INTO yon_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Keke Isau ye awoyambed yaro korok korok keriwen yi amyenimbon ambogawiib yi aningko kuu Timna yoom Alva yoom Yetet yoom ");
INSERT INTO yon_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama yoom Ela yoom Pinon yoom ");
INSERT INTO yon_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas yoom Teman yoom Mibsar yoom ");
INSERT INTO yon_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel yoom Iram yoom kwane. Kukuu Idomdan yi amyenimbon yi korok korok kerenib yi wenebe yi bidambib maa maa kuyaom doberenib yi kambong maa maa nariwen. Idomdan yi awodki kuu Isau.|U ");
INSERT INTO yon_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yekob yambembed Keenan ambibkin aom doboroon kuyaa kumbed kwane Yekobbed doboroon. ");
INSERT INTO yon_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Keke Yekob awene yi weng. Yosef kuu kewedman weeb 17iib kuu ye ambanga yoom ibmo dingkan kab oone dobiriwen. Ye ambanga kuu yi awodki ye amered Lea yoom Bilha yoom Silpa yoom yi meed. Kwane angkon yi komo komo arewa kamiwen kuu Yosefbed awodki yaa daanimaan. ");
INSERT INTO yon_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yekob yaningko mamaa kuu Israel. Israel ye mimyob dowaken darewoob kuu Yosef yamo, angkon ye karub dana yena yaa kuu embengmo, amborom kuu Yosef kuu kiomnoon yaa ye dana kowe. Yembed ebkad doboob kuu yeka amun yeman manimaniyiib yaambed ongme karane Yosef yaa konoona derenoon. ");
INSERT INTO yon_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kwane dorone, aron maa wedmibka yi ambe kuu Yosef yaamo dowaken darewoob, ma ayi yaa kuu dowan. Yi niindem aom arudiib keriwen kowe, yi daman Yosef yaa kongeni wengmo danimamiib. ");
INSERT INTO yon_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Kuye niindem aom Yosef kuu kiyuum wedmoon. Wedmekore, ye ambanga yaa dakmok wonoon. ");
INSERT INTO yon_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yembed yi yaa yedmoon “Wengambirime. Keke ne kiyuum wedmaan. ");
INSERT INTO yon_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nub korem flawa yeman ye yob imkonokawiib wanane anded yenbenabekorub, anded kuu okad yiri dedmone dobiriib, mongkobon angkambed, kwane kirodmo ne anded kuu yere doboobmo doboroona yiib anded kuu neman yaa nedbe okad yiri bumangkiwen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ye ambangambed ye yaa yedmiwen “Eb kuu kwane nub korok kere oonandameewoo? Eb anam nub korok kerandameewoo?” andiwen. Ayiya korem kongendi darewoob kerenib niindem aom arud kuu miin darewoob keriwen, amborom kuu kiyuum kuu yembed wedme dakmeen kuyaambed. ");
INSERT INTO yon_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kwane amaan angkon ye kiyuum mamaa wedmekore, ye ambanga yaa dakmoon “Wengambirime. Ne kuu angkon kiyuum mamaa wedmaan kii. Kowe kekamune woodiib aroniib mindong 11iib kuu ne diambed ne yaa kirobe bumangkiwen kii!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kwane awodki yaa kwangkon kiyuum weng kuu daanoon. Yambembed yedmoon “Eb kwamune dakmembaraab, amob kowe, koronde. Komo kwamune ye kiyuum id kuu? Anam, neya eb enaya eb ambanga nub mene eb yaa okad yiri bumangke kirobanuuwoo? Kwamaubbanaa!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ye ambanga kuu ye yaa wungkaniwen, kumban yambe kuu kiyuum kee ye id kuu komo manok ande meenimaan. ");
INSERT INTO yon_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Aron mamaa, ye ambanga kuu Sekem taun dia winiwen, yi ambe ye sibi awene be wene ooniiwe kereek ane doriib. ");
INSERT INTO yon_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Kowe, awodki Israelmbed Yosef yaa yedmoon “Ebkaadkerewen kuu eb ambanga kuu dingkan kab ooniiwe kereek ane doriib, Sekem taun dia. Ne dowaken kuu eb ambangayiib yaa wene.” andoone Yosefbed “Eyoka” andoon. ");
INSERT INTO yon_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kwane, Israelmbed Yosef yaa yedmoon “Wene eb ambanga wedmende amunmo doriib dee? Dingkan kab kwangkon wedme yi weng kande kanmene.” andekore yedmoona Hebron kankubuneen yirimbed wonoon. Wene, Yosef Sekem taun nandoon kuu yaron kuu ");
INSERT INTO yon_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ye ambanga ande odmenmo yareena karub maambed wengane kaamonenoon “Eb komo odmenmo yareeb?” andoone, ");
INSERT INTO yon_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","yembed yedmoon “Nambanga ande odmenmo yariin. Eb ebkaadoo, kuna yaa yi dingkan kab oone doriib?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Yembed man yedmoon “Yi kuu keyaa koronde winiwen kii. Ne wengambaraana dakmiwen kuu Dotan yiri wenem ande kamiwen kii.” andoon. Kwamune, Yosef ye ambanga yi yomanmo wenene wedmendoon, Dotan dia doriib. ");
INSERT INTO yon_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kumban yi kangkon man ambab meneen kumbed wedmeniwen, yi yedmiib komarewa ayanuub ande dakmiib. ");
INSERT INTO yon_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Yikarebmo yedmiib “Kuned kuu kiyuuman meneen kii! ");
INSERT INTO yon_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Wenem, ye ayenub kande okdobon dem kee dange wenuun kiri ma kaanem. Kwanekorub yedmem ‘Dura ye arud dingkanbed Yosef kuu aye birinde aniwen kii!’ andem. Kwanekorub, wedme ye kiyuum kuu komo keraneen kuyaa?” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Andekoriwa, Ruben wengamberekore yembed meenoon “Yimbed ne daman ayi kuu kebenda.” ande meenekore, yembed yedmoon “Nub ayaub. ");
INSERT INTO yon_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ayauwe ye umkan okad yiri onduknaan. No dem yiri awine kankaanem, amiibban koknoon ye okad keyambed. Kumban ayaib!” andoon. Ruben kuu meene yedmoon ye id kuu ye angkon ika menene Yosef dem yiri kuu yemyeb nenyaro kowene ika ye ambeyiib yaa nenwonok ande ye meenoon. ");
INSERT INTO yon_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kwane, Yosef ye ambanga yaa monoon, yi yaro dore awingkaneniiwa ye ebkad doboob manimaniyiib derenoon kuu biangkandiwen. ");
INSERT INTO yon_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kwane ye kuu nendore wene ok dobon dem yiri kaaniwen. Ok dobon dem kuu okiibban dowan bidmo kereen yiri kankaaniwen. ");
INSERT INTO yon_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kwamunekoriwa, yi dibone animan ano korok kankoone wedmibka, Ismaeldan yenayiib yi animan ambod mooni yemaniib, kad arewa ye muramura mooni yemaniib, baeb amun mooni yemaniib kemo ari nongkobekorib, Giliad ambibkin arimbed Idyip yiri deweniib. ");
INSERT INTO yon_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Diboniiwa, Yudambed ye aagoroka yaa yedmoon “Nub daman ayekorub, ye bob id mangke biknanuub kuu od kandanuub dee? ");
INSERT INTO yon_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kwana kowe, korondem, anam kuu no ye kuu kan ari moonem, Ismaeldan kee meniib keyaa. Nub ayaubban amborom kuu ye kuu nub daman umkan mimo kowe.” andoon. Yi korem weng mimo kerekoriwa, kwamunem andiwen. ");
INSERT INTO yon_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Andekorib wedmiiwa, Midian ambibkin yi berengkanabi ye karub deweniib kowe, Yosef kuu ye ambangambed dem yiri kowiwen doreen kuu awine nenyaro kowekoriwa, od yeman silva 20yiib murudkowiibbed mooniwen. Ismaeldan yaa kwaniiwa, nende Idyip yiri nenwiniwen. ");
INSERT INTO yon_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kwane yomanbed Ruben menene ok dobon dem yiri Yosef kuu dore wedmoonka, dobirindo dowan keroon! Ye kerebkarab kamene mimyob darewoob kowene yebkad kuu biringkoon, ye mimyob darewoob keroon kowe. ");
INSERT INTO yon_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ye ika wenene ye damana yaa yedmoon “Kewedman ok dobon dem yiri kuu dowan! Komo kamaniin?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kwamunekoriwa, Yosef yebkad doboob manimaniyiib kuu nandekoriwa, naningkod maa ayekorib, yebkad kuu kande umkanbed ambiwen. ");
INSERT INTO yon_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Yi kwame dowan kerekorib, ebkad kuu nande awodkiyiib yaa wenene yedmiwen “Nub kuu ebkad kee kitangkambed wedmuwen. Darobe wedme anduwed, mokuro eb dana yebkad dee?” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ye darobe wedmekore yedmoon “Oo anam, ne dana yebkad doboob kei! Arud awaan dingkan mamaambed ayoon kii! Anam Yosef kuu aye bunge aniwen!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kwamune, Yekob kwangkon yebkad biringkekore ebkad korobob arewambed bendebekore, aron doboob darewoob ye dana dowad ameng kamemboroon. ");
INSERT INTO yon_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ye dana korem kuu menene awodki yaa daane ongkanuuwo korondok ande kamiwen, kumban yembed yi yaa wengambirindo. Yembed yedmoon “Ne kwamune amengmo kamoni, neyiib bobneni ne danayiib angka angkanandamiin.” andekore, ye korondindo kwane amengmo kameboroon. ");
INSERT INTO yon_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kuu yaron kuu Midiandan kuu ari Yosef kandeniiwa Idyip ambibkin aom aomnekoriwa, karub maa yaningko Potifambed Yosef moonoon. Potifa kuu Idyip ye king Fero ye ana nangmidan yi korok mamaa. ");
INSERT INTO yon_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Kwanoon kuyaron yaa, Yuda kuu ye aagoroka domondekore, kambong Adulam ye karub yaningko Hirayiib yaa doborok wonoon. ");
INSERT INTO yon_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kuyaambed karub yaningko Sua ye mungkan wedmendekore awanoon. ");
INSERT INTO yon_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Awanekore, dangimamoniiwe oyoomiib kere, dana ibduruk wooneen kuu karub dana, yaningko kuu Er yedmiwen. ");
INSERT INTO yon_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Angkon ika oyoomiib kere karub dana maa wooneen yaningko kuu Onan yedmiwen. ");
INSERT INTO yon_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Angkon ika maa wooneen kangkon karub dana kowe yaningko kuu Sela yedmiwen. Ye kuu kambong Kesib yaambed wooneen. ");
INSERT INTO yon_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Amaan arimbed, Yudambed ye dana mingki wonob Er ye wonong benoon yu aningko kuu Tamar. ");
INSERT INTO yon_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er God yaa wengambirimokban kowe, ye dobiri kuu miin arewa keroone, God ye dowakeniibban kerekore, ayoona bobnoon ");
INSERT INTO yon_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","kowe, Onan yaa Yudambed yedmoon “Eb ambang ye dana wanabi dowad eb ambang ye wonong yoom dangiiwo dana wanabuk, ayi ye yumbon kandi yeman. Nub kara kui. Kwane.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kowe, Onam kuu ayi ye wonong yoom dangimaib kumban, ye kawad kuu bunangka okad yiri kirarimaan kumbed, ayi ye meed wanabi kuu kebenoon. Yekaadkeroon kuu ye dana keraanban kowe. ");
INSERT INTO yon_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onanbed kwamimaan kuu miin arewa kowe, God dowakeniibban kere, ye kangkon ayoona bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kwanoon kowe, Yudambed “Sela kuu ye ayi areb bobnaneen dee?” ande meene unekore, Tamar yaa yedmendoon “Kwani kowe, wene kub ambeyiib yaa irib kwane doberebko, ne dana Sela kuu kainoka.” andoona, Tamar kuu yu awodkimbed doreeniib yaa wuneen. ");
INSERT INTO yon_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kuye yondem amaan dobere wene, Yuda ye wonong bobneen. Bobneena, mimyob kowe doreene dowan kerekore, ye yoom yangkodmi Hira Adulam karub yoom Timna ari Yuda ye karubbed ye sibi wung wiib yaa wedmok winiwen. ");
INSERT INTO yon_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar wengamburuunka “Yuda kuu Timna ari ye sibi wung wok deweneen kii.” andiib ");
INSERT INTO yon_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","kowe, irib ebkad kuu biangke nongkobe kiwaan ari ye nima yi ebkad areb be debekoru, dabuambed kiringkonombed nare kirimo kebenekoru, wene kambong Enaim ye kuuk darewoob wiriniwen yambongko dia, Timna kiwaan kebed yaa Yuda biranande dibuun. Yukaadkereen Sela kuu kainoon kumban yu kuu ye wonong keri dowad konindo kowe. ");
INSERT INTO yon_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yu murubia kiringkonombed nare kiri kee kebeneen kowe, Yuda wedmendekore yembed meenoon kuu kiwaan ari ye wonong andoon. ");
INSERT INTO yon_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ma, ye kuu ye dana mingki ye wonong ande ma kaadkerindo kowe, kiwaan kebedbed wene yu yaa yedmoon “Kub yoom ne yoom wene dangem.” andoone, yumbed kaamoneen “Komo kawaneebkob eb yoom kuu wene danganuub?” anduune, ");
INSERT INTO yon_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","neman yedmoon “Ne naningkod mana kankebdaniin.” andoone yumbed kaamoneen “Komo amukni yeman kawaneebkob awine dobaraniinkob naningkod kuu kewaneeb?” anduune, ");
INSERT INTO yon_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“Kubbed yedme. Nembed komo amukni yeman kub yaa kabdaniinkob awine dobaraneeb?” andoona, yumbed neman inandeen “Eb yonamadiib, eb kerek kebeni yemaniiwa ye nongiiwa bangkawe.” anduuna, yu yaa bangkandekore yu yoom dangiiwa yu kuu oyoomiib kereen. ");
INSERT INTO yon_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kwane yu kuu wuneen kuu yu murubia ari dabua kebeneen kuu biangkendekoru, angkon irib ebkad ika bendebe doruun. ");
INSERT INTO yon_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kwane kuye yoman, Yudambed yangkodmi Adulam ye karub yaa naningkod kowoona, kanwene ye amukni yeman wonong kuyaa kondoon kuu igakman bemonok anded, kuned yembed yu wedmendindo kowe, ");
INSERT INTO yon_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","karub kuyaom dobiriib yaa kaamondoon “Keenan yi god yi kiwaan ari wonong Enaim kiwaan kebed yaa dibureen kuu kuna?” andoona, yimbed yedmiwen “Kemaom kee Keenan yi god yi kiwaan ari wonongiibban.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kowe, Yuda yaa ika wene yembed yedmoon “Nembed yu wedmendindo, angkon karub kuyaomdanbed yedmiib kuu kemaom kuu Keenan yi god yi kiwaan ari wonongiibban andiib.” andoona, ");
INSERT INTO yon_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yudambed yedmoon “Naningkod kabdaankob wonong kee kondaneeb manok ande wenewen kumban wedmendindo kowe, korondubko, ne yonamad awene kondaan kuu kwane yumbed buk. Korondaubban ika ika onme yarebbanuub kuu karub yenambed nub yaa daandi ye ambon yeman kerundaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kwane wood ayoobmim dowan keruuna, weng muneen “Eb wonongkim Tamar kuu kiwaan ari wonong areb kere oyoomiib kereen kii.” ande Yuda yaa yedmeniiwa, yedmoon “Nende, wat amotbed nengkibko dene bobnuk.” andoone, ");
INSERT INTO yon_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","kwane wonong kuu nende ningkandamiiwe, yumbed yu wonongkim yaa weng koween “Kee kane ye yonamadiib ye kerek kebeni yemaniiwa ye nongiiwa kawoonkob awinaan kee? Yembed yedmoonkob dangekorub oyoomiib keraan. Mene wedmebka, kumkam kee kane yeman ande.” andeen. ");
INSERT INTO yon_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda wedmekore, “Ii neman kii!” ande meenekore yedmoon “Yu inamen kuu amun kumban ne inamen kuu amunban, amborom kuu ne kuu anam ne dana Sela yaa konaniin andaan kuu kwanindo kowe, ne kuu anam ambarakmaan kii.” andoon. Kwanekore, Yuda yu yoom kuu angkon ma ika dangindo. ");
INSERT INTO yon_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Wooni yaron munuune wedmuunka, karub dana ayoob dabak dana woonandamuun. ");
INSERT INTO yon_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kowe, dana maa kuu yedin dingki yiroona, yu deme wonongbed ebkad nong dodmombed dingki yaa yuween kuu yedin wooneen andeen, ");
INSERT INTO yon_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","kumban ye dingki angkande ika aomnoon kowe, dana maa yedin wooneen. Kowe, yu deme wonongbed yedmeen “Keke kwane bamdaane yaro wenewen kii.” andeen kowe, yaningko kuu Peres yedmiwen. ");
INSERT INTO yon_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kwane ye yondem kuu ye aagorok kuu ebkad nong dodmoyiib kumbed wooneen kowe, yaningko kuu Seera yedmiwen. ");
INSERT INTO yon_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Kwane Yosef kuu Idyip yiri nenwiniwen. Nenwiniiwe, Idyipman yaningko Potifambed moonoon. Ye kuu Idyipdan yi king Fero ye deme karub. Ye kuu ana nangmidanbed king oonimaib yi korok. Yembed Ismaeldanbed Idyip yiri Yosef nenwiniwen kuu moonoon ");
INSERT INTO yon_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","kowe, ye korok Idyipman yambiwoom doboroon. Yariman God kuu Yosef yaa dore awanimaan kowe, komo komo kamoon kuu amunmo keroon. ");
INSERT INTO yon_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kwanoone, ye korok kuu wedmoonka, Yariman God kuu ye yaa dore awanimaankob, yembed deme ambangkimameen kuu amunmo kerimaan. ");
INSERT INTO yon_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yosef kuu kwanimaan kowe, Potifambed karub amun yeman ande meenekore, yeka ye deme karub nendoon. Kwani kowe, Potifa ye deme nimakarub korem yi korok kerekore, angkon Potifa ye yiribman korem yi ooni karub keroon. ");
INSERT INTO yon_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Nendoone Yosef ambiwoom korok keroon yaron yaambed ari kuu Yariman Godbed Potifa awene yambib aom doriibdan yaa amun kerundoon, amborom kuu Yosefiib kowe. Potifa ye yiribman korem ambiwoomiib yongbonbon angkayiib kuu Yariman Godbed amun kerundoon. ");
INSERT INTO yon_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kwane ye yiribman korem kuu Yosefbed oonene korok keroon kowe, Potifa kuu ye yiribman meenimokban, animan ani yeman yaamo meenoon. Yosef kuu aromkonoyiib angkon ye kuu kerengkanimbon ");
INSERT INTO yon_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","kowe, dobere wene ye korok ye wonongbed ye yaa nenem inamen meenenekoru, wengwadmeen “Menebko ne yoom dangem!” andeen ");
INSERT INTO yon_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","kumban, Yosefbed yu yaa yedmoon “Yii! Ne korokbed ne yaa yambiwoom yiribman korem kee oonaan yaa anam ande korok kowoon kowe, yembed ye yiribman yaa amun dee ande meenimokban. ");
INSERT INTO yon_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ambib keyaom kuu ne kuu korok darewoob. Karub maa kanembed kuu ne arewiibban. Kowe, ne korokbed ne yaa kuu ‘Ne kumkam kee araben awinaneeb kuu yimin.’ andoon, kumban ma kwamune andindo kubbed kwaneeb kii, amborom kuu kub kuu ye wonong kowe. Komande kub yaa ambarakmi arewa kamaniin? Kwananiin kuu God yaa ambarakmaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Yii andoon kuned, angke ware, angke ware, yumbed Yosef yaa wengwadmeen kumban, Yosef kuu yu yoom dangindo, angkon yu yoom dobirindo. ");
INSERT INTO yon_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Aron mamaa, ambiwoom deme karub kuu wenebiiwe yembedmo ambiwoom deme ambangkaane ");
INSERT INTO yon_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","yumbed ye yuruk ebkad yaa awinenekoru, wengwadmeen “Menebko ne yoom dangem!” andeen kumban, amonombe kombiri weneene ye yuruk ebkad kuu yu dingkimbed awine bianduune domonekore, ambiwoom kuu kombiri dore bunangka wonoon. ");
INSERT INTO yon_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Kwane, yumbed wedmuune kwanoone yuruk ebkad kandekoru, ");
INSERT INTO yon_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","yu ambiwoom deme nima yaa yumbed baanduune miniiwe yedmeen “Wedmime. Hibruman kee nenmene kowako nub yaa kwane emdangke doborok ande nenmonoon kii! Yembed mene neyiib yaa dangem ande monoon, kumban ne kuu kabang kamaane ");
INSERT INTO yon_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ye yuruk ebkad kuu kee korarundekore bunangka kombiri dore wonoon kii!” andeen. ");
INSERT INTO yon_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kwane ye yuruk ebkad kuu kankowuune ye korok monoone, ");
INSERT INTO yon_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","weng kuu ye yaa daaneen “Eb dabderem yiri dobere no deme awinembiri ye Hibru karub nub yaa kee nenmenewen kumbed ne yaa menene wengwaroon ");
INSERT INTO yon_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","kumban, ne kuu kabang kamaane, ye yuruk ebkad kuu kee korarundekore, bunangka kombiri dore kabaanmo wonoon kii!” andeen. ");
INSERT INTO yon_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kwanuune, ye korok kuu ye wonongbed daaneen kuu wengamberekore, ye niindem aom norinbed amot nimin areb keroon ");
INSERT INTO yon_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","kowe, Yosef kuu nenwene wii aom kamonoon, Idyip ye kingbed ye wiidan nongkoboon kuyaom kowoon. Kowoon kumban, wii aom kuu ");
INSERT INTO yon_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yariman Godbed amun kerune dore awanimaan kowe, wii yariman kuu Yosef yaa amun amun kamenekore, ");
INSERT INTO yon_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","yembed Yosef yaa kuu wiidan ooni yeman nendoone, wii aombed komo kamimamiib kuu yembed korok keroon. ");
INSERT INTO yon_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wii yariman kuu Yosefbed wiidan oonoon yaa kuu ma komo meenindo, amborom kuu Yariman Godbed Yosef yaa dore awanimaane yembed komo kamimameen kuu amunmo kerimameen. ");
INSERT INTO yon_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Aron maa amaan ari, Idyipdan yi king yaa ye wain ok koni ye karub yoom Idyipdan yi king ye flawa ongmidan yi korok yoom, yi ayoobbed Idyipdan yi king Fero yaa ambarakmiwen ");
INSERT INTO yon_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","kowe, Fero kuu karub ayoob yi yaa norin wandekore, ");
INSERT INTO yon_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","yedmoonkob yi ayoob awingke benwene Fero yaa oonidan yi korok yambiwoom kiribekorib, wii ambib Yosefiib doreen aom nongkobiwen. ");
INSERT INTO yon_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Fero yaa oonidan yi korokbed wii karub ayoob kuu be Yosef yaa domondoon, yembed oonoko dobirime anded. Kwamune wii aom doriib ye niindem aom aron doboob keroon. ");
INSERT INTO yon_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Aron maa, amnoom kuu king yaa ye wain ok koni ye karub yoom king ye flawa ongmidan yi korok yoom, yi ayoob kiyuum wanabiwen, amnoom mimo kuyaombed. Yi kiyuum kuu idiibmo yeka yeka. ");
INSERT INTO yon_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kwane awari amkimo Yosef dawuro menene wedmendoonka, yi ayoob kubiyiibban dibiib ");
INSERT INTO yon_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","kowe, yembed yi yaa kaamondoon “Komoyiibkob yiib kubiyiibban keriwen, kibikee wedmaan kee?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Yi ayoob inande yedmiwen “Nub ayoob ibonmo kiyuum wanabuwen kii! Kumban nub kiyuum weng id kuu kanembed kedmengkandaanban.” ande yedmiwen. Yosefbed yedmoon “God, yembedmo kuu kiyuum weng id kedmengkandi ye karub. Yiib kiyuum weng kuu dakmibko wengambara.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kowe kwane king yaa ye wain ok koni ye karub ye kiyuum weng Yosef yaa daanoon “Ne kiyuum wedmaan kuu nong yob wain ok ongmi ye nong ne kiringkono ari kamonoon ");
INSERT INTO yon_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","kuu nondong ayoobmimiib dangoon. Kirod kirodmo kwamunene dembene wuung ire yob dibere amnene yumundereboon. ");
INSERT INTO yon_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ne king Fero ye kabus kuu nembed awinaan kowe, nembed nong yob awine ondoobkaana ok kuu Fero ye kabus aom meneboona, nembed kabus nanwene Fero yaa konaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kwane Yosefbed yedmoon “Ye id kuu kei. Nong yob nondong ayoobmim kuu aron ayoobmim. ");
INSERT INTO yon_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Aron ayoobmim ari kuu Ferombed wii aombed eb nenangkane kowekore, eb korok nenkone ika eb deme yaa nenkowaneena, angkon Fero ye wain ok konimamaneeb, kurin kwanewen areb kii. ");
INSERT INTO yon_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kumban kuu dakmaan kwamune amunmo eb yaa ambangkoka ne nonondandaab. Meenewe mimyowiib kewe ne yaa ne kangkon Fero yaa daanebko ne wii aom kee nende ambun angka kowoko deedara. ");
INSERT INTO yon_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kwamune ne kuu dudimbed awine Hibru yi okad aombed kanminiwen, angkon kwamunene kibik keyaom kuu anam ma ambarakmindo kumbed ogoodmo kande wii kaaniwenkob doriin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kwane king ye flawa ongmidan yi korok wengamboroone, Yosefbed karub maa ye kiyuum woon kuu amunmo kedmengkandoone, ye kwangkon Yosef yaa yedmoon “Ne kangkon kiyuum kwamune wedmaan kii. Ne korok ari kuu kabed ayoobmimiib dangoon kumaom korem kuu flawayiibmo. ");
INSERT INTO yon_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kabed animari angkeen kuyaom kuu flawa yeka maa maa ningkanabiwen kumaom dangoon. Yi kuu Fero yeman, kumban ayari onbed benaniinmo kamiib kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kwane Yosefbed yedmoon “Kiyuum kuye id kuu kei. Kabed ayoobmim kuu aron ayoobmim. ");
INSERT INTO yon_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Aron ayoobmim ari kuu Ferombed wii aombed eb nenangkane kowekore, eb korok nenkone wandekore, eb id kuu kan at yitkang arimbed kaaraneena ayari onbed ananiib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Aron ayoobmim ari kuu king Fero ye wooneen ye aron kowe, ye orok ongmekore ye korok korok baandoona menebe aniwen. Anekoriwa, orokbon arimbed king yaa ye wain ok koni ye karub yoom king ye flawa ongmidan yi korok yoom kuu wii aombed benangkane nongkobekore ye korok korok yi arinambo arimbed yi ayoob yi korok benkonoon. ");
INSERT INTO yon_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","King yaa ye wain ok koni ye karub kuu Ferombed ika ye deme yaa kowoona, wain ok kabus aom onduknekore Fero yaa konimameen. ");
INSERT INTO yon_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kumban king ye flawa ongmidan yi korok kuu Ferombed ye korok wandekore, ye id kuu kan at yitkang arimbed kaaroon. Kwamune yi ayoob yaa Yosefbed komo dakmoon arebmo kamoon. ");
INSERT INTO yon_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kuned king yaa ye wain ok koni ye karub kuu Yosef meenenindo ye nonondandoon. ");
INSERT INTO yon_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Weeb ayoob dowan kereen ye yondem, Idyip yi king Fero kiyuum wedmoone, ye kuu ok Nail kebed yaa doreen. ");
INSERT INTO yon_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kwane, buromakau darewoob darewoob bingbingmo ediib kuu ok yirimbed yeedere yaroniib, kereek doboob ok kebed yaa ane doriib. ");
INSERT INTO yon_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kwane, buromakau yena konokonomo murubia didban ediib ok yirimbed yeedere yaro miniwen. Mene yena ok kebed yaa doriib yaa dabokne doriib. ");
INSERT INTO yon_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kwane, buromakau konokonomo kumbed buromakau darewoob bingbingmo kuu aniwen. Kwane, Fero kuu yaro demboon. ");
INSERT INTO yon_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ye angkon ika angkene kiyuum maa wedmoone, yakom irok mimo yaambed id ediib darewoob darewoob amun amun ire yumune weneen. ");
INSERT INTO yon_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Wonoone, yakom maa konokonomo dembene id ediib iroone nuub niminbed wuuroone koknoon kumbed ");
INSERT INTO yon_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","yakom id darewoob darewoob amun amun kuu been yoobkoon. Kwane Fero yeederene wedmoonka kiyuum waan. ");
INSERT INTO yon_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ye kuu meenmi darewoob kameen amkimo kereene, Idyip aom indob ayoob yi karub, inamen bangbangiib kuye karub weng kowoone meneniiwa, kiyuum kuu daandoon, kumban karub kuu miniwen kuu weng id anam kuu ma korokbenindo. ");
INSERT INTO yon_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","King yaa ye wain ok koni ye karubbed Fero yaa yedmoon “Ne kibik ika meenmaan kuu ne anuk kuu ambarakmaan. ");
INSERT INTO yon_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kurin kuu ne yoom flawa ongmidan yi korok yoom ebbed norin wandenekore, nub kuu eb yaa oonidan yi korok yambiwoom wii kamberewen. ");
INSERT INTO yon_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kuyaom kuu amnoombed nub kiyuum ye idiib yeka yeka wanabuwen. ");
INSERT INTO yon_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Hibru kewedman kuu nub yoom doruuwa ye kuu eb yaa oonidan yi korok ye deme karub keroon. Nub kiyuum kuu daanuuwa, ");
INSERT INTO yon_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","kiyuum weng id kuu yembed nub yaa kedmengkandoon. Kwamune yedmoon arebmo, nub yaa komo kwanandameen kuu nub yaa kwanoon. Yedmewenkob, flawa ongmidan yi korok ye korok kuu wande ye id kuu kan at yitkang arimbed kaaroon. Ne kuu ne deme yumbon kuu ika nenkowewen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kwane, Ferombed weng kowoone, wii ambiwoombed Yosef nenminiiwe, bomi de ebkad yeweb debe kwanoone, kirodmo Feroyiib yaa nenminiwen. ");
INSERT INTO yon_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kwane, Ferombed Yosef yaa yedmoon “Ne kiyuum wedmaan kumban, karub kanembed ma kedmengkandindo. Kumban ne wengambaraanka eb kuu kiyuum wengambere id kedmengkandimameeb.” andoone, ");
INSERT INTO yon_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosefbed Fero yaa inande yedmoon “Ne kuu yiminban, kumban eb dowaken kuu kwamune kowe, Godbed eb kiyuum weng id kuu kedmengkabdaneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kwane, Ferombed Yosef yaa yedmoon “Ne kiyuum angka wedmaane, ne kuu ok Nail kebed angka doriin. ");
INSERT INTO yon_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Kwane, buromakau darewoob darewoob bingbingmo ediib kuu ok yirimbed yeedere yaroniib, kereek doboob ok kebed yaa ane doriib. ");
INSERT INTO yon_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kuyi yondem buromakau yena konokonomo miin murubia didban ediib yeedere yaro meniib kii. Kwamune kuu Idyip ambibkin korem keyaom kee ne ma kwamune wedmindo. ");
INSERT INTO yon_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kwane, buromakau konokonomo murubia didban ediib kumbed buromakau ibduruk dembiwen kuu korem ane dowan keriwen. ");
INSERT INTO yon_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kwane aniwen kumban, yi ma kwanindo areb, yi kuu konokonomo miin murubia didban kuu kwanamo. Kwane ne dembaan. ");
INSERT INTO yon_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Kiyuum maa kuu kei. Yakom irok mimo yaambed id ediib darewoob darewoob amun amun ire yumune weneen. ");
INSERT INTO yon_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Wonoone, yakom maa konokonomo dembene id ediib iroone, nuub niminbed wuuroone koknoon kumbed ");
INSERT INTO yon_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","yakom id darewoob darewoob amun amun kuu been yoobkoon. Indob ayoob yi karub yaa ne kiyuum daandaan kuu weng id ne yaa maawindo.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kwane, Yosefbed Fero yaa yedmenoon “Godbed komo awinandameen kuu eb yaa korokbebdoon. Kiyuum ayoob kuu ye weng id kuu ibmo. ");
INSERT INTO yon_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Buromakau darewoob darewoob amun amun ediib, yakom darewoob darewoob amun amun ediib ye weng id mimo kuu weeb ediib. ");
INSERT INTO yon_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Buromakau konokonomo murubia didban ediib yoman yeediriweniib, yakom konokonomo nuub niminbed wuuroone koknoon ediib ye weng id mimo kuu weeb ediib kuu animaniibban keraneen. ");
INSERT INTO yon_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Eb yaa nembed kee yedmebdaan kuu kui. Godbed komo awinandameen kuu eb yaa korokbebdoon. ");
INSERT INTO yon_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Weeb ediib kuu Idyip ambibkin korem aom kuu animan yewudmo kere wananeen, ");
INSERT INTO yon_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","kumban yoman kuu weeb ediib aom kuu am kainaneena animaniibban keraneen. Kwane, Idyip aom kuu animan yewudmo kuu nonondandaniiwa am kaini kuu Idyip okad yimin yimin yaa waneene monmaraneen. ");
INSERT INTO yon_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Anam, animan yewudmo kuu ika meenmaibban amborom kuu animaniibban keri kuu miin arewa keraneen. ");
INSERT INTO yon_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Eb kuu kiyuum ayoob wedmewen ye id kuu anam Godbed aron doboobban kwanandameen, angkon inamen ma kerokban. ");
INSERT INTO yon_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Eb kuu Fero kowe, inamen bangbangiib kedmengkandi yemoon ye karub wedmekore, Idyip ye okad yi korok nenkowe. ");
INSERT INTO yon_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kwane, ebbed okad yimin yimin yaa animan ooni ye korok be nongkobe. Yi dowad kuu animan yewudmo ye weeb ediib aom animan wanabi kuu bekorib, andokbe wenore angkoyiib nongkobe anded mimo bekorib, animan angkara animan yi yariman ika bangkandimamaniib. ");
INSERT INTO yon_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Animan baniib kuu taun aombed eb animan nongkobi yi ambiwoom kuu benwenoraniib. Kwanekorib, oonaniib kuu amun. ");
INSERT INTO yon_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Animan wenore oonaniib kuu weeb ediib aom Idyip aom animaniibban keraneen ye niindem aom angkon bangkandaniib yeman. Kwananiib kumbed karub mungi bobnaibban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kwane, Fero yoom ye korok korok yoom weng kandekorib, weng amun ande meeniwen ");
INSERT INTO yon_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","kowe, Ferombed yi yaa yedmoon “Karub mim kwamune kee ma wedmaubban, God ye kingkiniib kee.” andekore ");
INSERT INTO yon_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ferombed Yosef yaa yedmoon “Korem kee Godbed korokbebdoon kowe, eb kuu inamen bangbangiib kedmengkandi yemooniib kuu karub ma kwaneyiibban kowe, ");
INSERT INTO yon_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","eb kuu nembed ne ambibkindaniib ne korok korokiib ye korok nenkowaniine, eb weng kondaneeb kuu eb wengmo awine kandaniib. Nembedmo kuu eb korok kii.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ika yedmoon “Kibik kee Idyip ambibkin korem aom kee ebbed ooni korok nenkowaan.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ferombed ye dingki kanding ye kuruyiib biande Yosef ye dingki birid ari derenekore, ebkad doboob amuniib derenekore, gold itoob ye kongkono yaa niinenoon ");
INSERT INTO yon_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","kowe, Fero yaa wengongke ye dabderem aom dobiri ye karub keroon. Kwane, Ferombed yedmoonkob ye hos mamaayiib ye hos yoman ari dobiriwed kirod yarebi yeman aningko seriot mamaayiib nekwiiwe, Yosef kuu nenkowoone, karub yena yidin wene ika ika baandiib “Angkane karub keyaa bumangkime.” andiiwe, Yosef kuu Fero yaa wengongke ye dabderem aom dobiri ye karub keroon kuu Ferombed Idyipdan yaa korokbendoon. ");
INSERT INTO yon_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kwane, Ferombed Yosef yaa yedmoon “Ne kuu Fero, kumban karub kanembed eb yimin andiyiibban kuu yoon o dingki ma kankoonaanban, Idyip korem aom.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Ferombed Yosef yaa Idyip wengbed aningko maa Sefenat Fanea konoon. Kwane, taun aningko On yi karub dore yi god dore wedyiri dobiri ye karub Potifera ye dana mungkan Asenat konoona awanoon. Yosef kuu weeb 30yiib yaambed Idyipdan yi king Fero ye yumbon aombed wene Fero ye deme andowe Idyip korem aom yeka awine deweneboon. ");
INSERT INTO yon_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Weeb ediib ibduruk kuyaom okad kuu animan yewudmo id ire wonoon kowe, ");
INSERT INTO yon_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yosefbed animan korem Idyip aom kuu id ire wonoon taun dia kuu taun kwamune aom be wenoroon, taun mimim kui. ");
INSERT INTO yon_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Animan id korem kuu kimingkindeban, karamok kebed yaa kubuk mimim areb kowe, Yosefbed kimingki kuu korondoon. ");
INSERT INTO yon_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kuu yaron kuu Yosef ye meed karub dana ayoob ye wonong Asenatbed wanabeen. ");
INSERT INTO yon_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosef ye mingki ibduruk wooneene yedmoon “Nambe awene yaa meeniyiib ne durud yewed koremiib Godbed boona nonondandaan kowe yaningko kuu Menase.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Yosef ye mingki maa wooneene yedmoon “Ne kuu okad maa aom dobere durud yewed kandaan, kumban Godbed amun keruwoone yowiib keraan kowe, yaningko kuu Efraim.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Idyip aom animan yewudmo ye weeb ediib kuu mene yimin wandoone, ");
INSERT INTO yon_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","animaniibban ye weeb ediib andowe muneen. Kwane, Yosefbed komo dakmoon kuu kwanoon. Ambibkin maa korem aom kuu animaniibban kere wonoon, kumban Idyip aom kuu animan yemooniib. ");
INSERT INTO yon_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Idyipdan animaniibban keroona wedmekoriwa, mene Fero yaa animan dowad ameng kamiwen kowe, Ferombed Idyipdan yaa yedmendoon “Yosefiib yaa winibko, yembed komo yedmendoka kwanime.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Animan kuu Idyip korem aom dowan kere weneene, Yosefbed animan ambib nandoone Idyipdanbed Yosef yaa andowe berengkiwen. ");
INSERT INTO yon_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ambibkin korem kwangkon animaniibban mungi ye yewedbed yiminban kowe, korem meneniiwa, Yosefiib yaa Idyip aombed animan andowe berengkiwen. ");
INSERT INTO yon_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kwane, Yekob awene yi kwangkon yi animan kuu dowan kowe, Yekob kuu wengamboroone Idyip ambibkin yaa kuu yob ani yeman (nati areb) kuu dangoon. Kwani kowe, yembed ye karub danaya yaa yedmendoon “Yiib komande ogood dibere keenombere keenombere kamiib? ");
INSERT INTO yon_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ne kuu wengambaraan, Idyip yaa kuu yob ani yeman dangoon kowe, wene yiri nubman berengke benminime. Kwananiib kuu anekorub bobnaubban dobaranuub.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Andoone, Yosef ye aagoroka angko angkoyiib kwane wene Idyip yaa yob ani yeman kuu berengkok winiwen. ");
INSERT INTO yon_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kumban, Yosef ye daman Benjaminiib winindo, amborom kuu yawodki Yekob kuu ne dana ayaan ande unoon. (Yekob yaningko mamaa kuu Israel) ");
INSERT INTO yon_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kowe, Israel ye mingki kuu Idyip yiri wene yob ani yeman kuu berengkande winiwendan numun winiwen, amborom kuu Keenan aom kwangkon animaniibban keroon kowe. ");
INSERT INTO yon_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yosef kuu Idyip ambibkin kuyaom ye korok kowe, karub kuu yob ani yeman ye yaa berengkande minimamiib. Kwane Yosef ye aagoroka kuu mene ye yaa bumangke yi kiringkono okad yiri kankubuniiwe, ");
INSERT INTO yon_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosef kuu wedmendekore yi kuu yekaadkeroon kumban, ye kuu yekaadban areb kerene yeka mamaa kere yi yaa amun amunban kamendene yi yaa daandoon “Yiib kuu kunambed miniwen?” andoone, yimbed yedmiwen “Keenan ambibkin yaambed munuwen animan berengkanduwed.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosef kuu ye aagoroka yaa kuu nemanmo yekaadkerundoon kumban, neman ye yaa kuu yikaadban, Idyipman areb keroon kowe. ");
INSERT INTO yon_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kwanekore, ye kiyuum yi yaa kuu meenekore, yi yaa yedmoon “Yiib kuu darobidan ye karub mene nub ambibkin yaa yi ana nangmidaniibban dee kuna kuyaa wedmok miniwen kii!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Andoone, yimbed man yedmiwen “Nub yariman, yii! Nub kuu eb deme karub kowe, mene animan berengkanduwed, kumbedmo. ");
INSERT INTO yon_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nub kuu ambe mimo ye meed. Nub kuu korem anam eb deme karub, nub kuu darobidan ye karubban, nub kuu anam ye karub.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Andiiwe, yembed yi yaa yedmoon “Yii, yiib kuu mene nub ambibkin yaa yi ana nangmidaniibban dee kuna kuyaa wedmok miniwen kii.” andoon ");
INSERT INTO yon_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","kumban yimbed neman yedmiwen “Nub kuu eb deme karub, nub kuu aagoroka wad ayoowiib, nub ambe kuu mimo Keenan ambibkin aom dobirimameen kowe, yeenbon dana kuu nub ambe yoom doriib, angkon aagorok mamaa kuu dowan.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Andiiwe, Yosefbed yi yaa yedmoon “Yiib kuu yedmendaan kui, yiib kuu darobidan ");
INSERT INTO yon_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","kowe, Idyipdan yi king Fero yaningko yaambed amob yedme kowaan yiib yaa kuu kombon wedmi yeman kuu yiib kwangkon keyaom dobaraniiwe yiib daman yeenbon kuu keyaom mananeen kumbed. ");
INSERT INTO yon_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Kowe, yiib kuyaom karub mamaa yedmibko wene yiib daman yeenbon kuu nenmonok yena yiib kuu wii aom awunime. Kwananiib kumbed yiib weng dakmiwen kuu anam dee kombon wedmi yeman. Anam, Fero yaningko yaambed amob yedme kowaan kuu kwanokban keraniib kuu nekaadkeri yeman, yiib kuu darobidan kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kwanekore, Yosefbed yi kuu bene wii aom aron ayoobmim nongkoboon. ");
INSERT INTO yon_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Aron ayoobmim arimbed yembed yi yaa yedmoon “Ne kuu God wengambiri ye karub kowe, kwananiib kumbed domondaniina wananiib, bobnaibban. ");
INSERT INTO yon_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Yiib kuu anam ye karub keroka, yiib aagorok mimo kuu wii aom keyaa domonenekorib winime. Kwanekorib, yiib aweneya kuu mungi bobniwen kowe, yiib wene animan bekorib yiyiib yaa winime. ");
INSERT INTO yon_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Kumban yiib daman yeenbon kuu ne yaa nenminime. Kwananiib kumbed yiib weng daawiwen kuu anam andaniine, yiib kuu bobnaibban.” andoone “Ee, kwananuub kii.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Kwanekorib, yikareb neman yedmenoon yedmenoon kamiwen “Anam kii. Nub kuu nub daman ye dowad dabab kanduub kii! Nub kuu ye dabab wedmuwen, ye wadkeri dowad nub yaa eekmoon kumban, nub kuu ye yaa wengamberenindo kowe, dabab kee nub yaa monoon kii.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Andiiwe, Rubenbed yedmoon “Ne kuu yedmendaan ‘Kewedman yaa ambarakmaib.’ andaan kui. Kumban, yiib kuu wengambirindo keriwen kowe, ye bobnoon ye kakman ye ukum kanduub kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yi kuu Yosef kuu yekaadkerundoon ande meenindo, amborom kuu ye kuu Idyip wengbed dakmeene amenengki ye karub Keenan wengbed dakmendeen kowe. ");
INSERT INTO yon_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kwanekore, yi yaa kuu amonombe angkorom korokbendekore, ameng kamande kamoon kumban ye mimyob kirod kebenoon kowe, ika amonombe yi yaa ika daandekore, yembed Simion kuu nende yi indob arimbed yengbenoon. ");
INSERT INTO yon_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kwanekore, Yosefbed ye deme karub yaa yedmendoone, yob ani yeman kuu aagoroka yi yowo aom age nambungkekorib, aagoroka yi od kuu angkon ika yi yowo aom benkambungkekorib, angkon animan yenayiib kiwaan yaa wananiib yeman bangkandiwen. Kwanekoriwa, ");
INSERT INTO yon_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","aagorokambed yi animan yowo kuu donki animari nongkobiiwe winiwen. ");
INSERT INTO yon_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Wene wedya angkande kamenib, yi aagorok mamaambed ye donki yaa animan bangkandande kamene yowo aom dande wedmoone ye od kuu angkon ika kuyaom angkuun kowe, yembed ye aagoroka yaa yedmoon ");
INSERT INTO yon_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","“Woyee! Ne yowo aom kuu ne odiib kedi!” andoone, yi mimyob yaa yiminban keroone une kiringmiyiib kamenib neman daane daane kame yedmiwen “Kee komo Godbed nub yaa kee kamunoon kee?” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kwane mene yi Keenan ambibkin aom awuderekorib, yi ambe Yekob yaa yi yaa komo kamoon kuu kwane daaniwen ");
INSERT INTO yon_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Karub okad yarimanbed nub kuu darobidan andekore, nub yaa yeka mamaa kere, amun amunban kamendoon. ");
INSERT INTO yon_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kumban nubbed ye yaa yedmuwen ‘Nub kuu anam ye karub, nub kuu darobidanban. ");
INSERT INTO yon_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nub kuu ambe mimo ye meed, aagoroka wad ayoowiib, mamaa kuu dowan, angkon yeenbon dana kuu kewedman kowe, ambe yoom Keenan yaa doriib.’ anduwen. ");
INSERT INTO yon_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Anduuwe, okad yarimanbed nub yaa yedmoon ‘Keke kwananiib kumbed nekaadkerekori, yiib kuu anam ye karub andaniin kuu yiib aagorok mimo kuu keyaa domonenekorib animan kuu benib winime, yiib awene kuu mungi bobniwen kowe. ");
INSERT INTO yon_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kumban yiib daman yeenbon kuu ne yaa nenminime. Kwananiib kumbed ne kuu nekaadkerekori, yiib kuu darobidanban, anam ye karub andaniin. Andekori, yiib aagorok kuu yiib yaa angkon ika kondaniin, angkon yiib kuu okad keyaom nub yaa berengkiiwo yiib yaa berengkuuwo kamenabanuub kuu yimin.’ andoon.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kwane, yi animan yowo aom kuu age wedmiiwe, yi od kuu ika kuyaom dangoon. Kowe, yi yoom yi awodki yoom kuu wedmekorib uniwen. ");
INSERT INTO yon_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kwane, yi ambe Yekobbed yi yaa yedmoon “Yiibbed ne dana benwiniiwe bikniwen. Yosef kuu dowan, Simion kuu dowan, kumbed angkon Benjamin nenwanandiwedoo? Ne yaa kuu korem ne bonman keroon kii!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Andoone, Rubenbed yawodki yaa yedmoon “Kwane, Benjamin kuu eb yaa angkon ika nenmonokban keraka, ne karub dana ayoob kuu yengkadme. Ebbed ne yaa ‘Ee, korobe oone.’ andekoreb, domowebko nenwenekori ika nenmana.” andoon ");
INSERT INTO yon_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","kumban, Yekobbed yedmoon “Ne mingki kee kuri eb yoom wanaibban. Ye ambang kuu bobnoon kowe, Reksel yu dana kuu yembedmo doreen. Nenwananeewe, kiwaan wedyambed ayaneen kuu ne kuu mimyob kowe wene bobnaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Keenan ambibkin aom kuu am minimokban kowe animaniibban keroon. ");
INSERT INTO yon_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yekob awenembed Idyip ambibkin yirimbed animan be miniwen kuu ane dowan kerekoriwa, Yekobbed ye danaya yaa yedmendoon “Yiib Idyip yiri ika winime. Angkon yob ani yeman yena berengkime.” andoon ");
INSERT INTO yon_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","kumban Yudambed yawodki yaa man yedmoon “Yi korokbed nub yaa amob darewoob ongme yedmoon ‘Yiib damaniib nenmanaibban kuu ne yumbon aom aomnaibban.’ andoon kowe, ");
INSERT INTO yon_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ebbed Benjamin yoom winime andebko nub animan berengkok wenem. ");
INSERT INTO yon_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kumban ebbed Benjamin yoom winime andaabban kuu nub wanaubban amborom kuu yembed nub yaa yedmendoon ‘Yiib damaniib nenmanaibban kuu ne yumbon aom aomnaibban.’ andoon kii!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kwane, Israelmbed yedmoon “Komande yiibbed yedmiwen ‘Nub kuu damaniib.’ andekoriwa, dabab ne yaa kankawiib?” andoone, ");
INSERT INTO yon_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","yimbed inande yedmiwen “Ye kuu nub yaa kaamobi yemoon keroon. Yembed nub yaa ‘Yiib ambe kuu wad doreen dee? Yiib kuu aagorok maayiib dee?’ ande kwamune kaamondoon kowe, nubbed no inande yedmuwen. Yembed amob ongme yedmoon ‘Yiib damaniib nenminime.’ andoon kuu anuk kuu nubkaadban kii!” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Andekoriwa, Yudambed yawodki yaa yedmoon “Eb yedmaneewa nembed kewedman kuu nendaniina kibireb kee wananuub dee? Kwananeeb kuu eb yoom nub yoom nub dana yoom wad dobaranuub, duknaubban. ");
INSERT INTO yon_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nembed ye yaa ongme oonaniin. Eb dana ooni kuu nembedmo. Ye kuu nembed eb arinambo ari ika nenkowokban keraniin kuu ne kuu karak dabab darewoob kandaniin. Dabab kee eb kiringkono ari bongmindeban wene bobnaniin kii. ");
INSERT INTO yon_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ogoodmo dobirindo karen, Idyip yiri wenekorub ika mene ayoob keruwen karen.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kwane, yi awodki Israelmbed yi yaa yedmoon “Anam, kiwaan mayiibban kowe, ambibkin keyaom ye barang amun yemaniib yiib yowo aom kambungke animan ooni ye karub yaa be wene bangkanime. Kad arewa ye muramurayiib, in okiib, animan ambod yemaniib, baeb amun yemaniib, pistasio yowiib, almon yowiib kui. ");
INSERT INTO yon_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Od silva animan berengki yemaniib be winime. Angkon od silva yiib yob yowo aom biknoone wedmiwen kuu yi kerebkarab kamiwen dee, nubkaadban kowe, ika be wene bangkanime. ");
INSERT INTO yon_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Yiib daman Benjamin kuu nende animan ooni ye karub yaa ika winime, kibireb kei. ");
INSERT INTO yon_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Angkon Aromkono Korem Ye Godbed yiib yaa awandoko, animan ooni ye karub kuu yiib yaa mimyob keendekore, ika wini kuu yimin andaneene, yiib aagorok maa yoom Benjamin yoom yiib yoom ika minime. Ne dana maa bobnaneene mimyob kowaniin kuu kiwaan mayiibban ee!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kwane yimbed barang amun bangkani yemaniib od silva animan berengki yeman ayoowiib bekorib, Benjamin nende Idyip yiri kirodmo wene Yosef ye yumbon aom aomniwen. ");
INSERT INTO yon_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kwane Yosefbed ye aagoroka yoom Benjamin yoom wedmendekore, ye demedan yi korok yaa yedmoon “Karub kee nambiwoom be wene. Dingkan aye animan nekwe ningkenabe. Yi kuu ne yoom aronkobbed ananuub kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kwanandoone, yi kuu Yosef yambiwoom be wonoon. ");
INSERT INTO yon_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Be weneene, uniwen amborom kuu “Od kuu nub yowo aom biknoon kowe, nub kuu keyaa kee benmonoon kii. Ye dowaken nub yaa kuu yenbande yerengkandaneene ye dabderem yiri dobere no deme awinembiridan keranuuwe angkon nub donki kuu baneen kii.” ande meene uniwen. ");
INSERT INTO yon_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kwane, yimbed Yosef ye demedan yi korok dia wenekorib, ambongko diambed ");
INSERT INTO yon_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","yedmiwen “Nub korok ee, anuk kuu kiri kee ibduruk animan berengkok munuwen. ");
INSERT INTO yon_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Berengkekorub igakman wunuwen. Wenenenub wedya angkandamenuwe, parai kombon yengbekorub, nub yowo nande, animan berengkuwen ye od korem kuu nub yowo aom biknoon kowe wedmuwen. Kwanikob od kee ika be munuub kii. ");
INSERT INTO yon_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kanembed od kee nub yowo aom kambungkoon kuu nubkaadban. Angkon od maayiib be munuwen kuu animan maa berengkanduwed.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kumban Yosef ye demedan yi korokbed yedmoon “Meenimbanaa. Unaiwaa. Yiib God, angkon yiib ambe ye God, yembed yiib dowad yiib yowo aom kuu od munob kambungkoon. Yiib od baan kii.” andekore, yi aagorok Simion nenmene yi yaa domondoon. ");
INSERT INTO yon_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kwane Yosef ye deme karubbed yi kuu ambiwoom be aomnekore, yon ogambi yeman ye ok bangkandekore, dingkan animan yi donki yaa bangkandoon. ");
INSERT INTO yon_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kwane yimbed yi yowiib, iniib, muramurayiib ambod yemaniib baeb amun yemaniib bangkandande nekwiwen, amborom kuu wengambiriiwe Yosef kuu aronkob ari mananeene ananiib. ");
INSERT INTO yon_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kowe, Yosef kuu yambiwoom mene aomnoone, yimbed yi barang amun kuu Yosef yaa bangkanekorib, bumangke kiringkonombed okad badmenekoriwa, ");
INSERT INTO yon_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosefbed yi yaa kaamondoon “Yiib kuu amun dee? Yiib ambe kiomnoon yiibbed daawiwen kuu amun dee? Wat doreen dee?” andoon. ");
INSERT INTO yon_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Andoone, yimbed yedmiwen “Nub ambe kuu eb deme karub. Ye kuu amunmo wad doreenaa.” andekorib, Yosef yaa karub amun yeman ande meeniwen kowe, ika bumangke kiringkonombed okad badmeniwen. ");
INSERT INTO yon_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kwane, Yosefbed kerekanabe ye daman anam ye ena yu dana Benjamin wedmekore yi yaa yedmoon “Karub kee yiib daman yeenbon kwamune yiibbed daawiwen kuiyoo?” andekore, Benjamin yaa yedmoon “Ne dana, Godbed eb yaa awabdok.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kwane ye daman wedmoon kowe, mimyob darewoob ye yaa keenekore, Yosef kuu domonde kombiri wene ye angkimbon ambinam aom aomnekore, ameng kamoon. ");
INSERT INTO yon_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ameng dowan kerekore, ye murubia ogambekore, ye mimyob kebene ika mene yedmoon “Animan akime.” andoone, ");
INSERT INTO yon_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ye deme karubbed Yosef ye arak arimbed ye animan akiiwe, arak mamaa arimbed Yosef ye aagoroka yi animan akiiwe, arak mamaa arimbed Idyipdan yi animan akiiwe kamiwen, amborom kuu Hibrudan yoom ani kuu Idyipdan yi dowakenban anam. ");
INSERT INTO yon_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yosefbed ye demedan yaa yemyeb yedmoone, ye aagoroka kuu arak yaa wonob dana arimbed wene yeenbon dana yirimbed kwamune be nongkobiwen. Kwane Yosef ye aagoroka kuu kwamune diburuuwe wedmekorib, binangke neman wedmene wedmene kamiwen. ");
INSERT INTO yon_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yosef ye arak arimbed animan be Yosef ye aagoroka bangkandiwen kumban Benjamin yaa kuu ye aagoroka angkoyiib yi animan be wenori areb animan miin darewoob bangkaniwen. Bangkandekoriwe, Yosef ye aagoroka kuu animan darewoob ane mikmoniwen. ");
INSERT INTO yon_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Kwane, Yosefbed ye demedan yi korok yaa yedmoon “Karub mimi mimi yi yowo aom kuu yi dembe yimin yaamo yob ani yeman bangkande. Kwane yi yowo aom yob ani yeman animari kuu yi od silva kuu ika kambungke, ");
INSERT INTO yon_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","angkon daman yeenbon etari ye yowo aom yob ani yeman animari kuu ne silva kabus od darewoob yemaniib ye od silva animan berengkooniib kambungke.” ande Yosefbed kwane yedmoone, kwane ambangkoon. ");
INSERT INTO yon_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Warewini amkimombed yedmendoona, Yosef ye aagoroka kuu yi donki be andowe winiwen. ");
INSERT INTO yon_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Taun domonde ambab winindombed Yosefbed ye demedan yi korok yaa yedmoon “Karub kee weniib ye yondem kirod wene wedmende durundebka yedmende ‘Ne korok kuu yiib yaa amunmo kamoon, kumban komande yiibbed ye yaa arewa kameniib? ");
INSERT INTO yon_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Komande yiibbed ne yariman ye kabus silva od darewoob yeman yid kandiwen? Kabus kee ye ok ani yeman angkon ye komon yorokmi yeman kii. Keke amob darewoob domokbiwen.’ ande yedme.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Andoona, wene wedmende durundekore, weng komo dakmoon kuu kwanemo daandoona, ");
INSERT INTO yon_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","yimbed inande yedmiwen “Komande kwane andeeb kii! Nub kuu kwamune kamindo. ");
INSERT INTO yon_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nub kuu Keenan ambibkin angkambed od kuu nub yowo aom dangeene wedmuwen kuu eb yaa ika be munuwen. Kwani kowe, komande nub kuu eb yariman yambiwoom ye od silvayiib od goldiib yid banubka? ");
INSERT INTO yon_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Nub kuu eb deme karub areb kedi. Kowe, nub keyaom kee kabus yid boon kuu wedmaneeb kuu mim kuu ayiwed bobni yeman, angkon nub kuu eb dabderem yiri dobere no deme awinembiridan keranuub.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Andiiwe, Yosef ye demedan yi korokbed man yedmoon “Eyoka, karub mim kane yid boon kuu wedmanuub kuu yembedmo ne dabderem yiri dobere no deme awinembiri ye karub keraneen, kumban karub yena yid bindo kuu koronde wananiib kuu yiminaa!” andoone, ");
INSERT INTO yon_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","yi korem kirod yi yowo been okad yiri nongkobe yi yowo danan winiiwe, ");
INSERT INTO yon_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","deme karub yi korok kumbed ayi yaambed andowe yorokmenmo wene yi daman etari yaambed yimin wandoon. Kwane, kabus kuu ningki yimin ari Benjamin ye yowo aombed wedmiwen. ");
INSERT INTO yon_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kwanoone, yi ebkad biringkaniiwa ameng kamekorib, yi yiribman donki ari ika nekwane, taun aom ika winiwen. ");
INSERT INTO yon_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yosef kuu yambiwoom doreena, Yuda yoom ye aagoroka yoom weneniiwa, Yosef ye arinambo ari okad yiri bumangke kirobiwen. ");
INSERT INTO yon_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Kowe, Yosefbed yedmoon “Yiib kuu komo keriwen? Yiib yiibkaadbankob kamiwen dee ne kuu ari komo kerandameen kuu wedmaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kwane, Yudambed inande yedmoon “Nub yariman ee. Nub kuu eb yaa komo andanuub? Nub yid bindo yaa akmi yeman ye dowad kuu komo kamanuub? Kumban nub ambarakmi biknuwen kuu Yariman Godbed been dian keroon kowe, karub mim kabusiib kuyoom nub korem yoom kuu eb dabderem yiri dobere no deme awinembiridan keruub kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kumban, Yosefbed yi yaa yedmoon “Yiminban oo! Ne kwanainban oo! Karub mimo kabusiib wedmiwen kumbedmo ne dabderem yiri dobere no deme awinembiri ye karub keraneen kuu yimin. Yiib korem yena kuu igakman amunmo yiib ambeyiib yaa winime.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kwanandoona, Yudambed yaro dore ye dia wenene ye yaa yedmoon “Ne yariman ee! Nub kuu eb deme karub kedi! Ne yaa kongewaab. Wengamberebko, ne weng yedma. Eb yoom Fero yoom kuu ibmo. ");
INSERT INTO yon_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ee, ebbed nub yaa kaamondewen ‘Yiib kuu yiib ambeyiib dee? Yiib aagoroka yenayiib dee?’ andeewa, ");
INSERT INTO yon_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","nubbed neman yedmuwen ‘Nub ambe kuu kiomnoon. Angkon kuu ye kiomnoon yaambed dana mingki mimo wooneen. Ye ambang maa awaan mimombed wooneen kuu bobnoon kowe, ye kuu ye awaan anam yaambed aagorok mayiibban. Kwani kowe, awodkimbed ye mimyob darewoob kuyaa kowene ye dowaken dana keroon.’ anduwen. ");
INSERT INTO yon_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Yariman ee! Ebbed ‘Nenminibko nekarewiib wedmandamiin.’ andewen, ");
INSERT INTO yon_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","kumban nubbed yedmuwen ‘Dana kewedman kuu nenmananuub kuu ye awodki kuu bobnaneen kii!’ anduwen. ");
INSERT INTO yon_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kumban ebbed yedmewen kuu ‘Kewedman kuyiibban kuu ne arinambo ari angkon ma manaibban.’ andeewa, ");
INSERT INTO yon_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","nub yoom nub ambe yoom kuu eb deme karub areb kowe, nub ambeyiib yaa eb amowiib kwane kanwunuwen. ");
INSERT INTO yon_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Wunuuwa, nub ambembed yedmoon ‘Yiib angkon wene animan embengmo moone minime.’ andoon, ");
INSERT INTO yon_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","kumban nubbed inande yedmuwen ‘Kewedman kuyiibban kuu ika karub kuye arinambo ari kuu wanaubban.’ anduwen. ");
INSERT INTO yon_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Kumban nub ambembed yedmoon ‘Ne wonong Rekselmbed karub dana ayoobmo wanabeen kowe, ");
INSERT INTO yon_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","mim kuu ne domowe wonoone wedmindo keraane, kiib dingkanbed ayenane biringke kurubkurub kiriwen ande meenekori korondaan, ika wedmindo ");
INSERT INTO yon_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","kowe, ye damaniib nenwananiibkob ye yaa arewa keraneen kuu ne kuu ye dowad mimyob darewoob kowe wene bobnaniin.’ andoon kii! ");
INSERT INTO yon_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Kwani kowe, nub ambe ye wadkeri kuu daman keembed ye wadkeri kuu awinemoon areb keroon kowe, kewedman keyoom nub ambeyiib yaa ika wonokban keranuub kuu dana kewedman keye mimyobbed aye kowaneene bobnaneen. ");
INSERT INTO yon_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Kowe, nembed ye dana yaa ongme oonaniin andaan nambe yaa, angkon yedmaan ‘Ye kuu nembed eb arinambo ari ika nenkowokban keraniin kuu ne kuu karak dabab darewoob kandaniin. Dabab kee eb kiringkono ari bongmindeban wene bobnaniin kii.’ andaan. ");
INSERT INTO yon_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Weng kee kwamune nambe yaa yedmenaan kowe, kewedman keyiib ye aagorokambed ika nenwananiib kuu yimin dee? Ne kuu yid bi ye kakman ye yumbon kandeni, eb dabderem yiri dobere no deme awinembiri ye karub keraniin kuu yimin dee? ");
INSERT INTO yon_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nembed yeyiibban nambe yaa ika wini kuu yiminban! Angkon, ne kuu nambembed mimyob durud yewed kandod wedmi kuu yiminban.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yuda ye weng wengamberekore, Yosef kuu ameng kamande kamoon kowe, ye deme karub kuu baandoone, ye dia kuu koronde winiiwe, ye aagoroka yoom ye yoommo wadnari ambiwoom kuu karub mamayiibban keroone, ye aagoroka yaa ye kuu kane ande andowe kedmengkandoon. ");
INSERT INTO yon_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Kwanekore, naawonmo ameng kamoone Idyipdan kuu wengambereniwen, angkon Idyipdan yi king Fero ye deme karub ambiwoom doriibdan kwangkon karub mamaambed daandoone wengambiriwen. ");
INSERT INTO yon_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosefbed ye aagoroka yaa yedmendoon “Ne kuu Yosef kii! Nambe kuu wad doreen dee?” andoon kumban, ye aagoroka kuu yi neman ma inandindo, amborom kuu ye yumbon aom kuu uniwen kowe. ");
INSERT INTO yon_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kwane Yosefbed yi yaa yedmoon “Ne dia minime.” andoone, ye dia winiiwe yedmendoon “Ne kuu Yosef, yiib aagorok kii. Yiibbed ne kuu Idyipdan yaa mooniwen kui. ");
INSERT INTO yon_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kowe, yiib kuu ne mooniwen kwande meenenib yiibkareb norin keraib angkon unaib, amborom kuu duknaubban, Godbed nedin keyaa nenmonoon kowe. ");
INSERT INTO yon_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kwane weeb ayoob ambibkin keyaom kee animan kuu idiibban keroon, angkon weeb angkoyiib kwangkon animan id wandaibban angkon animan kab kibingkaibban. ");
INSERT INTO yon_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kumban Godbed yiib yaa kuu nedin nenmonoone, dabab darewoob yaambed yiib kuu benmene awandanded, amborom kuu yiib yoom yiib awoya yoom korem duknaniib kuu God ye dowakenban kowe. Kwanikob, yiib kuu dukni miin arewa yeman koronde kombiri benmonoon kii. ");
INSERT INTO yon_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kwani kowe, keyaa manaan kuu yiibbed nenkondindo, Godbed nenmonoon. Yembed ne kuu awawoone Idyipdan yi king Fero ye wengongki ye karub kereni, yambiwoom doriibdan yi korok kereni, Idyip okad korem kuu nembed korok keraan ");
INSERT INTO yon_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","kowe, kirod ika wene nambe yaa yedmenime, keke eb dana Yosefbed yedmoon ‘Godbed Idyipdan korem yaa ne kuu korok nenkowoon kowe, neyiib yaa mene, aron yena dobaraab. ");
INSERT INTO yon_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Eb kuu ewiib eb danayiib eb awoyayiib eb dingkaniib dingkan oonidaniib eb yiribman koremiib kuu benmeneeb okad Gosen aom ne dia yaambed dobirime. ");
INSERT INTO yon_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nembed eb dowad kuu oonaniin, amborom kuu weeb angkoyiib kuu animaniibban keraneen kowe. Kwananeeb kuu eb yoom eb ambiwoom doriibdan eb awene yoom eb deme karub yoom eb dingkan yoom, yiib korem kuu mungi bobnenib duknaibban.’ ande yedmime.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yosefbed ye aagoroka yaa ika yedmoon “Yiib kuu ongme wedmiiwoo? Benjamin, eb kangkon ongme wedmeewoo? Keke ne kuu anam Yosef nembed yiib yaa daandiin kii. ");
INSERT INTO yon_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kowe, nambe yedmenime, nembed Idyip aom korok darewoob keraan, angkon yiibbed komo komo wedmiwen kuu daanime. Kwane nambe kuu kirod kiri nenminime.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kwanekore, ye dingki kuu ye daman Benjamin yaa awine nenkangkunekore ameng kamoone, Benjamin kangkon man awine nenkangkunekore ameng kamoone kamiwen. ");
INSERT INTO yon_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kwanekore, ye aagoroka korem yaa mandamuk keendekore awine nenkangkune ameng kamoone, man awine nenkangkune ameng kamiiwe kamiwen. Kwanekoriwa, ye aagoroka yoom ye yoom dakmenabiwen. ");
INSERT INTO yon_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Fero kuu wengamboroone Yosef ye aagoroka miniwen kii andiiwe, ye yoom ye korok korok yoom kuu kubekoriwa, ");
INSERT INTO yon_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ferombed Yosef yaa yedmoon “Eb aagoroka kuu yedmendebko, yiribman kuu nekwane yi dingkan ari nongkobekorib, Keenan ambibkin yaa ika winime. ");
INSERT INTO yon_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Wenenib, yi ambe yoom yi nimadana koremiib kuu benib, ika neyiib yaa keyaa minime, minibko nembed Idyip aom okad amun yeman kondako, animan amun kuu keyaombed kubiyiib ane dobirime. ");
INSERT INTO yon_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Eb kuu kwamune yi yaa yedmende, kekamunime, kwame kuyaombed dibiriwed benmini yeman yumboniib aningko waigon kuyiib waigon yi hosiib kuu Idyip aombed benbangkandebko, bewene yi danayiib yi amerediib yi ambeyiib kuu keyaa benminime. ");
INSERT INTO yon_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Yiib yiribman yaa meenaib, amborom kuu Idyip aom amunmo dangoon kuu yiibman keraniib kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Andoone, Israel ye karub dana kuu kwaniwen. Yosefbed kuyaom dibiriwed benmini yeman yumboniib aningko waigon kuyiib waigon yi hosiib animan wedya wene ananiib yemaniib kwane bangkandoon. Ferombed yedmoon areb kuu kwanoon. ");
INSERT INTO yon_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kwanekore, ye aagoroka korem yaa kuu ebkad yeweb bangkandoon, kumban Benjamin yaa kuu od silva 300iib ebkad yeweb angkoyiib kwane bangkanoon. ");
INSERT INTO yon_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Keke yambe yaa bangkani ye dowad Idyip aombed yiribman amun yeman kuu donki angko angkoyiib ari kuu nongkobekore angkon donki yingki angko angkoyiib animari kuu yob ani yeman yowoyiib flawayiib animan yena wedya ika mene ananeen yemaniib kwane nongkoboone nekwiwen. ");
INSERT INTO yon_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kwanekore, ye aagoroka kuu domondoone winiiwe, yembed yi yaa yedmoon “Ambiyaom wene wedya wengbaraib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Andoone, yi kuu wene Idyip domondekorib, yi ambe Yekowiib yaa Keenan ambibkin aom winiwen. ");
INSERT INTO yon_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Yimbed yi ambe yaa daaniwen “Yosef kuu bobnindo, wad doreen kii! Angkon yembed Idyip okad korem kuu yembed korok keroon.” andiwen, kumban Yekob binangki darewoob keroon kowe, yi weng kuu anam ande meenindo, kerebkarab kamoon. ");
INSERT INTO yon_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kumban yimbed ye yaa Yosefbed daandoon ye weng korem kuu daanekoriwa, Yosefbed diborodned ika nenwini yeman aningko waigon bangkandoone, benwiniwen kuu Yekob wedmekore, ye wedme binangki dowan kerekore ");
INSERT INTO yon_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","yedmoon “Kibireb kee, ne kuu anam ande meenaan, ne dana Yosef kuu wad doreen kowe, wene wedmenekoridned bobnaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Kwane, Israel awene kuu yi yiribman koremiib benib andowe winiwen. Wene, Berseba nandekoriwa, yembed dingkan yeene ningkenaboone agedmo keroone, baeb kuu yambe Aisek ye God yaa konoon. ");
INSERT INTO yon_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Miriknoone, Israel kuu angkoone, Godbed ye yaa wane korokbenoon. (Israel yaningko mamaa kuu Yekob.) Kwangkambed yedmoon “Yekob! Yekob!” andoone “Ne kei.” ande inandoon. ");
INSERT INTO yon_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kwane, Godbed daanoon “Ne kuu God, eb ambe ye God. Eb Idyip ambibkin yiri wini kuu unaab, amborom kuu kumaombed amun kerubdaniine, eb awoya kuu ambibkin darewoob keraniib. ");
INSERT INTO yon_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Idyip yiri wananeeb kuu oonebdaniin, angkon eb awene ika be mananiin. Angkon bobnaneewe, Yosef yembedmo eb indob kebenekore mangkaneen kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","7","Kwanoona, ware amkimo keroone, Yekob ye karub danambed kuyaom dibiriwed benmini yeman yumboniib aningko waigon kuyiib waigon yi hosiib Ferombed araben bangkandoon kuyaom kumbed yi yiribman korem Keenan aombed biweniib yi ambeyiib yi nimadanayiib, yi korem bennongkobekorib, yi dingkan kab korem Keenan aombed biweniib kuu Idyip yiri winiwen. Yekob ye dana yoom ye awoya yoom yi korem kuu winiwen. ");
INSERT INTO yon_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yekob awene Idyip yiri winiwen yi aningko kuu kei. Ruben kuu Yekob ye wonob dana. ");
INSERT INTO yon_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben ye karub dana kuu Hanok, Palu, Hesron, Karmi yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simion ye karub dana kuu Yemuel, Yamin, Ohad, Yakin, Sohar, Saul yoom kui. Saul kuu Keenan wonongbed wooneen. ");
INSERT INTO yon_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Livai ye karub dana kuu Gerson, Kohat, Merari yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda ye karub dana kuu Er, Onan, Sela, Peres, Seera yoom kui. (Kuned Er yoom Onan yoom kuu Keenan aombed bobniwen.) Peres ye karub dana kuu Hesron yoom Hamul yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isekar ye karub dana kuu Tola, Pua, Yasub, Simron yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulun ye karub dana kuu Sered, Elon, Yaleel yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Yekob yoom Lea yoom yi karub dana awene kukui. Yekob yoom Lea yoom yi karub dana Aram ambibkin ye okad dabonmo aombed wanabiwen. Yi yangkura kuu Daina. Yi korem kuu 33yiib. ");
INSERT INTO yon_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ged ye karub dana kuu Sefon, Hagi, Suni, Esbon, Eri, Arodi, Areli yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser ye karub dana kuu Imna, Isva, Isvi, Beraia yoom kui. Yi yangkura kuu Sera. Beraia ye karub dana kuu Heber yoom Malkiel yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Yi kuu Lebanbed Lea yaa kondoon ye wonong Silpa yoom Yekob yoom yi karub dana awene kui. Yi korem kuu 16iib. ");
INSERT INTO yon_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yekob yoom Reksel yoom yi karub dana kuu Yosef yoom Benjamin yoom. ");
INSERT INTO yon_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosef yoom taun aningko On yi karub dore yi god dore wedyiri dobiri ye karub yaningko Potifera ye mungkan Asenat yoom kumbed Menase yoom Efraim yoom wanabiwen, Idyip aombed. ");
INSERT INTO yon_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin ye karub dana kuu Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, Arid yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yi kuu Yekob yoom Reksel yoom yi karub dana awene kui. Yi korem kuu 14iib. ");
INSERT INTO yon_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Den ye mingki kuu Husim kui. ");
INSERT INTO yon_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftalai ye karub dana kuu Yahsiel, Guni, Yeser, Silem yoom kui. ");
INSERT INTO yon_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yi kuu Lebanbed Reksel yaa kondoon ye wonong Bilha yoom Yekob yoom yi karub dana awene kui. Yi korem kuu ediib. ");
INSERT INTO yon_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yekob yoom ye dana meed yoom ye awoya yoom Idyip yiri winiwen kuu 66iib, kumban ye karub dana yi amered kuu kimingkindo. ");
INSERT INTO yon_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yosef yaambed Idyip aom karub dana ayoob wanabiwen kowe, Yekob awene korem Idyip aom doriib kuu 70yiib. ");
INSERT INTO yon_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kwane, Yekobbed Yuda yaa yedmoone, yedin Yosef yaa wene Gosen okad kuna yaa aom dobaranuub andi ye dowad wonoon. Gosen okad aomniwen kuyaron kuu ");
INSERT INTO yon_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosefbed yedmoone, ye deme karubbed ye hosiib ye hos yoman ari dobiriwed kirod yarebi yeman aningko seriot kuyiib nekwiiwe, animari doberekore, Gosen yaa yambe wenganok wonoon. Yambeyiib yaa angkaderekore, yambe yaa awinene nenkangkunekore ameng kamemboroon. ");
INSERT INTO yon_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kwane Israelbed Yosef yaa yedmoon “Nembed wedmaane eb kuu wad doreeb kowe, bobnaniin kuu yimin.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kwane, Yosefbed ye aagoroka yoom yawodki aweneya yoom yaa daandoon “Ne kuu kari wene king Fero yaa daananiin ‘Ne aagoroka yoom nambe awene yoom Keenan ambibkin aom dobiriwen kuu ne yaa miniwen. ");
INSERT INTO yon_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Yi kuu dingkan kab oonidan kowe, yi dingkan kawiib yi yiribman koremiib benminiwen.’ andaniin. ");
INSERT INTO yon_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ferombed baandaneene ye yumbon aom aomnaniiwe kaamondaneen ‘Yiib deme komo awingkimaib?’ andoka, ");
INSERT INTO yon_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","neman inande yedmime ‘Nub kuu eb deme karub. Nub kuu dingkan kab oonidan, nub awoya yi deme areb kwane awingkimaub.’ andime. Yiib kuu kwamune andaniib kuu yiib kuu Gosen yaa dobaraniib kuu yimin ande yedmaneen, amborom kuu dingkan kab oonidan kuu Idyip yi dowakenban anam kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Andekore, Yosefbed ye aagoroka angkoyiib be, king Fero yaa wenekore yedmoon “Nambe yoom ne aagoroka yoombed yi dingkan kawiib yi yiribman koremiib Keenan ambibkin aombed Gosen yaa be winiwen.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ye aagoroka angkoyiib kuu Fero yaa korokbenoon. ");
INSERT INTO yon_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kwane, Ferombed ye aagoroka yaa kaamondoon “Yiib deme kuu komo awingkimaib?” andoone, man yedmiwen “Nub kuu eb deme karub. Nub kuu dingkan kab oonidan, nub awoya yi deme areb kwane awingkimaub. ");
INSERT INTO yon_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nub kuu owoddan, Keenan ambibkin aom kuu animaniibban keroon, angkon nub dingkan kab kangkon yi animaniibban keroonkob munuwen kowe, nub dowaken kuu okad Gosen aom araben dobaranuub. Kuu yimin dee?” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Andiiwe, Ferombed Yosef yaa yedmoon “Eb ambe yoom eb aagoroka yoom eb yaa miniwen kowe, ");
INSERT INTO yon_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Idyip okad amun amuniib yaa benwenebko ambib yenbe dobirime. Okad Gosen aom dobaraniib kuu yimin. Angkon yi yena kuu dingkan kab oonidan yi inamen anam yikaadkeriwen kuu ebbed be menebko, ne dingkan kab yaa domondako, oonimamime.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kwane, Yosefbed yambe nenwene Fero yaa korokbenoon. Yekobbed Fero yaa amun kerunoone, ");
INSERT INTO yon_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ferombed kaamonenoon “Eb kuu weeb komoyiib?” andoone, ");
INSERT INTO yon_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yekobbed inande yedmoon “Ne kuu okad ari dewenebaan ye weeb kuu 130yiib. Ne dobiri ye weeb kuu yobdood angkon doboobban. Angkon ne weeb kuu ne awoya yi weeb yi doboob arebban.” ande ");
INSERT INTO yon_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Fero yaa amun kerunekore, Fero ye yumbon aombed wonoon. ");
INSERT INTO yon_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kwane, Yosefbed yambe yoom ye aagoroka yoom be Idyip aom okad amun yeman Gosen yaa be wenekore, Gosen okad maa kondoone, ambib yenbe dobiriwen, Fero ye weng dakmoon kwamune areb keriwen. (Kibikee okad kee dobiriwen kuu Ramesis andimaib.) ");
INSERT INTO yon_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Kwaniiwa, Yosefbed ye aagoroka yi meed korem kimingkoon kowe, yi korem yaa animan yiminmo bangkandimaan. ");
INSERT INTO yon_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kuyaronbed ari kuu Idyip ambibkiniib Keenan ambibkiniib kuu animan idiibban kowe, animaniibban anam kerekore, mungi darewoob kere mungimbed aromkonoyiibban doberembiriwen. ");
INSERT INTO yon_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Nimakarub Yosef yaa wene yob animan (nati areb) berengkanabimaiwa yi od korem kuu Yosefbed bekore, king Fero yambib amun yeman aom nongkobimaan. ");
INSERT INTO yon_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kwanaane, Idyipdan yi odiib angkon Keenandan yi odiib kuu dowan keroon. Od dowan keroon kowe, Idyipdan korembed Yosef yaa wene yedmiwen “Nub yaa animan bangkande yaa! Yiminoo? Anaubban kuu eb arinambo arimbed bobnanuub kii! Nub od dowan kii!” ande kamiwen. ");
INSERT INTO yon_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kwane, Yosefbed inande yedmendoon “Yiib kuu odiibban kowe, yiib dingkan kab kuu bangkawibko animan bangkanda.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kwani kowe, yi hosiib yi sibiyiib yi naningkodiib yi buromakauyiib yi donkiyiib Yosef yaa bangkanaiwe, Yosefbed neman yi yaa animan bangkandaane kamiwen. Weeb kuyaom kuu Yosefbed awandimaan kowe duknindo. ");
INSERT INTO yon_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kwane kuye weeb burudande weeb ari kuu nimakarubbed Yosef yaa ika mene yedmiwen “Ebkaad aa! Nub kuu odiibban, angkon nub dingkan kab kuu ebmanmo. Nub idiib nub okadiib kuu nubman, kumbedmo. Mamayiibban. ");
INSERT INTO yon_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Anam kii! Anaubban kuu eb arinambo arimbed nub yoom nub okad yoom duknanuub kii! Nub yoom nub okad yoom berengkekoreb, animan nub yaa bangkande! Kwananeeb kuu king Fero ye dabderem yiri dobere no deme awinembiridan keranuub. Nub okad kwangkon Fero yeman keraneen. Yob bungki yeman nub yaa bangkande. Kwananeeb kuu wad dobaranuub, duknaubban. Angkon kwananeeb kuu nub okad kuu ingkudmo keraunban.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kwanekoriwa, Yosefbed Fero ye dowad okad korem kuu berengkoon, Idyip yimin yimin aom. Idyipdan korem yaambed berengkoon, amborom kuu mungi miin darewoob keroon kowe. Kwanikob, okad korem kuu king Fero yeman keroon. ");
INSERT INTO yon_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Angkon Idyipdan korem kuu king Fero ye deme kakmaniibban ye karub keriwen. ");
INSERT INTO yon_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Okad yena berengkindo kuu Idyipdan dore yi god dore wedyiri dobiri ye karub yi okad, amborom kuu king Ferombed yi deme ye kakman bangkandimaan kuu animan bangkandimaan. Kowe, yi okad berengkindo. ");
INSERT INTO yon_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kwane, Yosefbed nimakarub yaa yedmendoon “Kibikee, nembed Fero ye dowad yiib yoom yiib okad yoom berengkaan kowe, yob bungki yeman yiib yaa bangkanda. Kwane, yiib yongbon yaa bungkenabime. ");
INSERT INTO yon_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Id wi yaron kuu id andokbe wenore angkoyiib nongkobekorib anded mimo Fero yaa konimamime. Id angkara kuu yiib awene yiib ani yemaniib kab bungki yemaniib kui.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kwane, yimbed yedmeniwen “Eb kuu nub yaa awandewena, nub duknindo kii. Nub yaa amunmo kamewen kowe, nub king Fero ye dabderem yiri dobere no deme awinembiridan keruub kii.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kwane, Yosefbed amob ongme kowoon kuu okad yaambed korem andokbe wenore angkoyiib nongkobekorib anded mimo Fero yaa konimamime, ye man kowe ande kowoon. Amob kee doboroon mene kibikee. Okad Ferombed bindo kuu Idyipdan dore yi god dore wedyiri dobiri ye karub yi okad, kumbedmo. ");
INSERT INTO yon_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israeldan kuu Idyip ambibkin aom okad Gosen yaa doberembiriwen. Deme yemoon ambangkekorib, okad berengkanabiiwe yiribman yemoon beniiwe kamiwen. Angkon dana yewudmo wanabiwen. ");
INSERT INTO yon_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yekob kuu Idyip aom weeb 17iib doboroon kowe, ye weeb korem kuu 147iib. (Yaningko mamaa kuu Israel.) ");
INSERT INTO yon_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israel kuu yekaadkeroon aron doboobban ari kuu bobnaneen. Kwane kowe, ye dana Yosef kuu yedmoone monoon. Monoone, Yekobbed yedmoon “Eb mimyob dowaken ne yaa kowewen kowe, eb dingki kanmene ne yon muudkuk dabderem aom kowekoreb, ne yaa kwananiin ande amob ongme. Amob kuu ne yaa amunmo kame ne weng wengamberekoreb kwane. Ne id kuu Idyip aom mangkaab. ");
INSERT INTO yon_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Bobnaka, ne id kande Idyip domonde wene ne ambeya mangkanabiwen yaa kurimbed mangke.” andoone, Yosefbed inande yedmoon “Eyoka, eb weng kuu kwananiinaa.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kwanandoone, Yekobbed yedmoon “Ne yaa amob ongme.” andoone, Yosef kuu amob ongmoon. Amob ongmoone, Yekobbed yonamad ari yonekore, kurikuriyiib kubiyiib God yaa konoon. ");
INSERT INTO yon_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Amaan arimbed, Yosef yaa daanoon “Eb ambe kuu korereyiib kii.” andoone wengamberekore, ye karub dana ayoob Menase yoom Efraim yoom kuu yambe Yekowiib yaa benwonoon. ");
INSERT INTO yon_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kwane, Yekob yaa eb dana Yosef kuu monoon kii andiiwe wengamberekore, angkeen yirimbed mangdomon aromnene yaro diboroon. ");
INSERT INTO yon_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Kwanekore, Yekobbed Yosef yaa yedmoon “Aromkono Korem ye Godbed kambong Lus yaa Keenan ambibkin aom kuyaambed ne yaa amun keruwe ");
INSERT INTO yon_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","yedmewoon ‘Nembed eb yaa dana yemoon bangkabdaniine yewudmo kere wananeen, angkon nembed eb kuu ongmaniine ambibkin yemoon yi ambokab keraneeb angkon nembed Keenan ambibkin okad korem kuu eb yaa kabdaniine eb awoyambed okad kee aron korem korem yeman kandaniib.’ andoon. ");
INSERT INTO yon_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Godbed kwamune andoon kowe, eb karub dana ayoob Idyip aombed wanabeebkob, ne kuu yomanbed manaan kuu kimingke nekareb ne dana keraniin. Efraim yoom Menase yoom kuu Ruben yoom Simion yoom kwanaan areb kwamune neka keraniin. ");
INSERT INTO yon_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Dana yena ari wanabaneeb kuu ebmanmo kere eb dana ayoob kee kuye ambibkin aom okad yumbon kandaniib kuu yi ambanga yaningko yaambed. ");
INSERT INTO yon_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Eb ena Reksel bobneen kowe, yu dowad kwanaan kui. Ne kuu Aram ambibkin ye okad dabonmo yaambed ika meniine, Reksel kuu Keenan ambibkin wedyambed kambong Efrat dia bobnuune, ne mimyob darewoob kowekori, nembed Efrat kiwaan kebed yaa yu kuu mangkaan.” andoon. (Yekob yaningko mamaa kuu Israel.) ");
INSERT INTO yon_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Kwane Israel kuu Yosef ye karub dana wedmendekore, yembed kaamonoon “Kee kane awene?” andoone ");
INSERT INTO yon_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosefbed neman yedmoon “Yi kuu ne dana, Godbed ne yaa kiri kee bangkawoon kei.” andoon. Kwane Israelbed yedmoon “Ne yaa benmenebko nembed yi yaa amun kerunda.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel ye indob kuu wud dabunoon amborom kuu kiomnoon kowe, ye kuu korobe wedmindeban. Kowe, Yosefbed ye dana kuu be ye dia monoone yambembed mandamuk keendekore kangkudereboon. ");
INSERT INTO yon_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israelbed Yosef yaa yedmoon “Ne kuu angkon ika eb murubia kamune wedmainban ande meenaan, kumban Godbed yimin yedmoon kowe, eb dana kwangkon wedmaan kii!” andoon. ");
INSERT INTO yon_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Andoone, Yosefbed yambe ye yon dangbo ari dibiib kuu benangkanekore, bumangke ye murubia kuu okad yiri kankubunekore, ");
INSERT INTO yon_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Efraim kuu Yosef ye dingki wiwi angkambed awinenekore, nenwene Israel ye dingki an angka kowoon. Angkon, Menase kuu Yosef ye dingki an angkambed awinenekore, nenwene Israel ye dingki wiwi angka kowoon. ");
INSERT INTO yon_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kumban Israelbed ye dingki wiwi kuu an angka yirene ningki Efraim ye korok ari kowekore, ye dingki an kuu wiwi angka yirene ayi Menase ye korok ari kowoon. Menase kuu ayi kumban, ye awo ye dingki anbed ye korok ari kowoon. Efraim kuu ningki kumban, ye awo ye dingki wiwimbed ye korok ari kowoon. ");
INSERT INTO yon_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kwane, Yosef yaa amun kerune yedmoon “Ne God kuu nawo Abraham yoom nambe Aisek yoombed wengambiriwen yi God. Ye kuu ne yaa kuu sibi oonidan areb oonewembirimameen ari mene kibikee ye God. ");
INSERT INTO yon_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ye kuu Engyu areb arud ye barang korem yaambed ne yaa awawimaan ye God. Kewed ayoob keya amun kerundok. Godbed awandoko nawo Abrahamiib nambe Aisekiib neyiib nub aningko areb aningko darewoob kerime. Kwane yi awoya yemoon kerok.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Andoone, Yosef kuu wedmoone yambe ye dingki wiwi kuu Efraim ye korok ari kowoone wedmekore ye dowakenban keroon kowe, yembed awodki ye dingki wiwi Efraim ye korok ari kowoon kuu kanangkanene Menase ye korok ari kowande ");
INSERT INTO yon_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","yedmoon “Ambe, yii! Keke ayi kii. Kowe, eb dingki wiwi kuu kande ye korok ari kowe.” andoon ");
INSERT INTO yon_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","kumban, yambembed yiminban andekore yedmoon “Ne dana ee, nekaad. Ye kwangkon yaningko darewoob kerene awoya yemoon keraneen kumban, ye damanbed ye ayi yaa burudande yaningko miin darewoob keraneen. Ye awoya kuu ambibkin maa maa nimingke nimingke keraniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Andekore, kuyaron arimbed yi yaa amun kerunde yedmoon “Eb aningko yaambed Israel nembed amun kerundi, Godbed eb yaa Efraim areb Menase areb kerubdok.” andekore, Efraim yaningkodin Menase yaningko yoman yedme kowoon. ");
INSERT INTO yon_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kwanekore, Israelbed Yosef yaa yedmoon “Ne kuu bobnandamiin kumban, God kuu eb yaa dore awabdimamaneen kowe, yembed eb kuu eb ambeya yi okad kari ika nenwananeen. ");
INSERT INTO yon_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Eb kuu eb aagoroka yi korok kowe, Amorodan yaambed ne kerewangiib ne anangkawiib kumbed Sekem okad kandaan kuu kabda.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kwane, Yekobbed ye karub dana yaa baande yedmoon “Mene ne dia dibiribko, amaan ari yiib yaa komo keraneen ye weng kuu yedmenda. ");
INSERT INTO yon_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yekob ye karub dana, mimyamo kere dibirime. Yiib ambe Israel ye weng kuu wengambirime. ");
INSERT INTO yon_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, eb kuu ne wonob dana. Eb kuu ne aromkono ye karub, eb kuu nembed ambe keri yeman, eb kuu eb aromkonombed eb damana ari dobirimameeb, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Kumban, eb kuu urok arudiib areb kowe, eb damana yi korok ye yumbon domonaneeb, amborom kuu ne angkimbon ari daane ne dungkud wonong yoom dangiwen kowe, ne yaa ambarakmewen, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simion yoom Livai yoom kuu aagoroka, inamen mimo kedi, yi kerewang kuu nangmi yeman. ");
INSERT INTO yon_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ne kuu yimbed yemyeb weng dakmi yayiib wengboniib yaa kuu wene nedbe dakmainban, amborom kuu yi arudbed karub kuu yeene monmariwen, angkon buromakau yi mekmeed nari kuu yi iningkuk yeman kowe. ");
INSERT INTO yon_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Yi noriniib arudiib kuu miin arewa kowe, yi norin yaa butun kerok. Nembed yiib awoya been Israel ambibkin aom buyokbayok keraniina wenebaniib kii. ");
INSERT INTO yon_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, eb aagoroka kuu eb yaa kubebdaniib. Eb kuu eb bondan yi kongkono ari awingkaneeb. Eb aagoroka kuu eb yaa bumangkaniib, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, eb kuu laiyon areb (Laiyon kuu awon ambi kiib kambari aromkono darewoowiib areb, yimbed karub animamiib). Dingkan aye anekore, ye ami yaa winimaan areb. Bayiringke angkimbirimaan kuu karub maa kuyaa wene wangmimokban, unimaib kowe. Eb kuu laiyon kee areb kereeb kii. ");
INSERT INTO yon_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yuda yoom ye awoya yoom kuu Israeldan yi king keraniib. King yaromkono kuru awinekorib, king kere dobaraniiwe wene king anam kuu mananeen, kui. Ambibkin korem yi karub kuu ye yaa kube wengambaraniib. ");
INSERT INTO yon_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yuda kuu animan yemoon ye karub keraneen kowe, ye donki ingod kuu nong yob ye nong amun yeman yaambed yengbimamaneen. Angkon, yebkad kuu wain okbed ogimamaneen, amborom kuu wain ok yemoon ye karub keraneen kowe. ");
INSERT INTO yon_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ye indob kuu wain ok areb keraneen, animan amun yemooniib kowe. Ye ningkambo kangkon muk ambod areb kawanmo dangkorong keraneen, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulun kuu karamok kebed yaa dobaraneen. Yembed dobaraneen ye kebed yaa kuu motod yemoon menebe dobirimamaniib. Ye dobiri yimin kuu wene Saidon yimin, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isekar kuu donki aromkonoyiib areb, aromkonoyiib kumban dabab be wini kuu ye dowakenban kowe, ye dabab benkariyabe wini ye yowo ayoob be wanaanban wedyaa dibaraneen. ");
INSERT INTO yon_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kumban, ye yiidkimbon amuniib ye okad amuniib kuu wedmaneen kowe, yaro ye dabab kuu kandom ari nongkobekore, benwananeena yedmaniibkob, ye dabderem yiri dobere no deme ambangkaneen, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Den kuu ye amyenimbon yaa wengyundaneen, yi kuu Israel yi amyenimbon yena areb keraniib. ");
INSERT INTO yon_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Den kuu niin dok areb kerene kiwaan kebed yaa angkimbere hos yon daandum yaa domonaneene korongbere dandaneene, hos ari dibeen ye karub kuu angkurom anuk kombaraneen, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Oo Yariman God, ne kuu eb awawe ande meedmiin. ");
INSERT INTO yon_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ged kuu yid bidanbed ayenmo mananiib kumban, igakman yenmo wananeen, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser kuu animan yemoon keraneen, ye kuu king yi animan ambod amuniib nekwe bangkandi ye karub keraneen, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftalai kuu diiya yingki amuniibbed kabaanimaun kuu mana amuniib wanabimaun areb, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosef kuu id yemoon dibirimaan ye nong demok kebed yaambed deedere nondong kuu bot kuuk yaa yone daane burudandimaan areb. ");
INSERT INTO yon_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ye bondanbed arudiib ayenmo menenib, ye yaa anangkabbed ana baradmiwen, ");
INSERT INTO yon_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","kumban ye anangkab kuu korobe dedmene, ye dingki kuu korobe aromnoon, amborom kuu Yekob ye Aromkono Korem Ye God, aningko maa kuu Israeldan yi Ooni Ye God, aningko maa kuu Israeldan Yi Kombe Ye God kumbed ye aromkonombed awanembirimameen kowe. ");
INSERT INTO yon_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Eb ambe ye Aromkono Korem Ye Godbed eb yaa awabdene amun kerubdimaan. Ambid arimbed amiib, dem ok yi okiib, dingkan kab yemooniib dana yemooniib kwane bangkabdok. ");
INSERT INTO yon_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Godbed amun keruwoon kuu darewoob, aangko unyeman yi yiribman amun burudandoon. Amun keruwoon kowe, korem kuu Yosef yeman kerok. Ye aagoroka yaambed Godbed nenmonoon kowe, kui. ");
INSERT INTO yon_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin kuu dura anon arudiib mungiyiib areb. Amkimo kuu dingkan aye animameen, oobne yaa kuu yenmo wene yiribman be nekwe bangkandimaan areb, kui.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yi korem kuu Israel ye ambokab wad ayoowiib kowe, keke yi ambembed yi yaa yi kara areb amun kerundene kwane yedmoon. ");
INSERT INTO yon_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kwanekore, kwanime ande weng daandoon “Ne kuu bobnekori, ne karuwayiib yaa daboknendandamaan kowe, botdem aom Hitman Efron ye mongkobon yaambed ne ambeya mangkiwen yaambed ne yiib mangkime. ");
INSERT INTO yon_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Botdem kee Makpela okad aom Mamre dia Keenan ambibkin aom, Abrahambed botdemiib mongkoboniib Efron yaambed moonoon kuu bobmangkanabi yeman ye okad kui. ");
INSERT INTO yon_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abraham yoom ye wonong Sera yoom kuu kuyaa mangkiwen. Aisek yoom ye wonong Rebeka yoom kangkon kuu kuyaa mangkiwen. Angkon Lea kuu nembed kuyaa mangkaan. ");
INSERT INTO yon_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mongkoboniib botdemiib kuu Hitdan yaambed moonoon kuyaa kuu ne id kuu mangkime.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kwane, Yekob kuu ye karub danaya yaa kwanime ande weng ongkande dowan kerekore, ye yon kuu angkimbon ari ika nongkobekore, yiri angkimbere yeenbon inum narekore, bobnoon. ");
INSERT INTO yon_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yekob kuu bobnoone, Yosef kuu ameng kame kankankune mandamuk kerunoon. ");
INSERT INTO yon_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kwane, yembed ye dokta yaa yedmendoonkob, yimbed mangki ye dowad Yekob ye bob id yaa andowe nekwiwen. ");
INSERT INTO yon_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Baeb amuniib, bob id deendindeban ye muramurayiib nekwiiwe wene aron 40yiib dowan kereen. Kuye Idyipdan yi bob id nekwi yaron areb. Bobnoone, Idyipdan kwangkon ye yaa mimyob keeniwen. Yi kuu mimyob darewoowiib kowe, ameng kamiwen kuu wene aron 70yiib dowan kereen. ");
INSERT INTO yon_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Kwane, mimyob keeni yaron dowan keruune, Yosefbed wene king Fero ye korok korok yaa yedmoon “Yiib kuu ne yaa dowakeniib keribka, Fero yaa ne dowad yedmime ");
INSERT INTO yon_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Nambembed yedmoona, amob ongmaan kuu nambe bobnaneen kuu kanwene ye bobkonombon Keenan ambibkin aom nidkoon kwaom kumbed mangkaniin andaan. Amob kee kowaan kowe, ebbed ee yimin andebka, ne kuu kwari wene nambe ye id mangkekori igakman mananiin.’ andime.” ande Yosefbed yedmoon. ");
INSERT INTO yon_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kwane, yedmiiwe Ferombed man yedmoon “Eb ambembed yedmoonkob, amob ongmewen kowe, kwane kan kwari wene eb ambe kuu mangke.” andoon. ");
INSERT INTO yon_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kwanandoone, Yosefbed yambe mangkok wonoon kuu ye yoom Fero ye korok korokdan yoom ");
INSERT INTO yon_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yosef awene yoom yambe awene yoom yi korem kwamune winiwen, kumban Yekob aweene yi kewed koyuyiib danayiib kuu winindo. Yi kuu yi dingkan kab oone dobiriwen, okad Gosen aom. ");
INSERT INTO yon_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Yosef yoom winiwendan kuu karuwiib yi hosiib, hos yoman ari dobiriwed kirodmo yarebi yeman aningko seriot kuyiib yi karuwiib hosiib kowe, yemoon winiwen. ");
INSERT INTO yon_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Weneniiwa, ok Yorden dia wene Atad ye flawa ye yob kad bangkanabimbon yaa yinmonekoriwa, Yosefbed bob yuudi ameng kame diboroone, mimyowiib ameng darewoob kamiwen, aron ediib dowan kereen. ");
INSERT INTO yon_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kuyaron kuu Keenandan yi yaa wedmekorib yedmiwen “Idyipdan kuu bob yuudi ye dowad dibiib.” ande yedmekorib, keyaa kee aningko yeeb Abelmisraim ande kowiwen. ");
INSERT INTO yon_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Kwane Yekobbed ye karub dana yaa amob weng daande kowoon kuu kwaniwen. ");
INSERT INTO yon_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Yimbed ye bob kande Keenan ambibkin aom wene okad Makpela ye botdem aombed mangkiwen. Botdem kee Abrahambed Hitman Efron yaambed botdemiib mongkoboniib Mamre dia bob mangkimbon ye dowad berengkoon. ");
INSERT INTO yon_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Mangke dowan kerekorib, yi korem igakman Idyip yiri winiwen. ");
INSERT INTO yon_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kwane, Yosef ye aagoroka wedmeniwen kuu yi awodki bobnoon kowe, Yosef yaa ika unekorib yikareb yedmiwen “Nubbed Yosef yaa ambarakmuwen ye kakman awine inandaneen dee?” ande uniwen ");
INSERT INTO yon_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","kowe, Yosef yaa weng keeniwen kuu “Eb ambembed bobnindo aron anuk kuu yedmoon ");
INSERT INTO yon_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Yosef yaa yedmime. ‘Eb aagorokambed eb yaa ambarakmiwen ye kakman kuu are nonondande. Yi kuu eb ambe ye God ye deme karub kowe, angkon yimbed komo arewa eb yaa kamiwen ye dabab kuu are nonondande.’ andoon kii!” ande weng keeniwen. Yosef kuu wengambere mimyob keende inok woon. ");
INSERT INTO yon_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kwane ye aagorokambed ye yaa mene bumangke okad yiri kirobekorib yedmiwen “Nub kuu eb deme no kakmaniibban awinembiri ye karub keruub kii.” andiwen. ");
INSERT INTO yon_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kumban Yosefbed yi yaa weng amuniib yedmoon “Unaiwaa! Ne kuu God ye yumbon kandaan dee? Dowan oo! ");
INSERT INTO yon_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Yiib dowakenbed kuu ne yaa arewa kamiwen kumban, Godbed amonombe nub yaa amun kerundoon kowe, karub yemoon duknindo, wad doburuub kii! ");
INSERT INTO yon_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kwana kowe, yiib ne yaa unaib. Nembed yiib yoom yiib dana yoom yaa korobe oonaniin.” andoon. Kwanandoone, yi uni kuu dowan keroona dobiriwen. ");
INSERT INTO yon_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosef awene yoom ye aagoroka awene yoom yi kuu Idyip ambibkin aom dobiriwen. Yosef ye weeb korem kuu 110iib. Wat doreen yaron kuu ");
INSERT INTO yon_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ye dana Efraim ye awoya ari kuu wedmendoon. Angkon ye dana Menase ye dana Makir ye meed kwangkon wanabekorib, Yosef yaa kiriboon. ");
INSERT INTO yon_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kwane, Yosefbed ye aagoroka yedmendoon “Ne bobni aron dia meneen. Kumban, anam kuu Godbed yiib yaa awandene be okad kee koronde okad Abraham yoom Aisek yoom Yekob yoom yaa amob ongme kowoon kuyaa kuu be wananeen.” andekore, ");
INSERT INTO yon_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","yambe Israel ye karub dana yaa daandekore, ika amob weng yedmoon “Anam, Godbed yiib yaa awandaneen kowe, ne bob id kuu keyambed mangkaib, be winime.” ande amob weng ongme kowoone, wiim aangkiwen. ");
INSERT INTO yon_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kwane, Yosef kuu ye weeb 110iib dobere bobnoon. Kwane ye bob kuu baeb amuniib bob id muramurayiib nekwiiwe, Idyip ambibkin aombed babang aom kambiriwen, kuned mangkindo. ");
INSERT INTO yon_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Karub kane ye kuu arewadan yi inamen ye yoman yarokban o, ambarakmenabidan yi kiwaan ari dorokban o, damangkandimbon ari nenkowe diborokban kuu, Godbed amun kerunoon. ");
INSERT INTO yon_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Ye kubi dowaken kuu Yariman ye amob yaa kerene, aronkiyiib amkiyiib kuu kimingke andangke meenmembirimaan. ");
INSERT INTO yon_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Ye kuu at ok kebed yaa kibiniwen id iri aron yaa kuu irembirimaan areb, ye kuu biid nuubne nombirimokban areb. Komo ambangkaneen kuu yiminmo keraneen. ");
INSERT INTO yon_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Kumban arewa kamidan kuu kwamunemban. Yi kuu nuubbed yob aom aab wure kanwinimaan areb. ");
INSERT INTO yon_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Kwani kowe, arewa kamidan kuu wengyundi yaron ari kuu doraibban, kwane, ambarakmidan kuu yorokmodanbed nedbimbon ari kuu doraibban. ");
INSERT INTO yon_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Amborom kuu Yarimanbed yorokmodan yi dobiri kiwaan kuu oone wedme kerendobirimaan, kumban arewa kamidan kuu monmari ye kiwaan ari weniib. ");
INSERT INTO yon_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Ambibkin ambibkindan kuu komande wunekare wabkad keri dowad inamen nekwimaib? Kwane, komande yi kuu idiib kerindeban ye inamen nekwe nuubnaan kamiib? ");
INSERT INTO yon_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Okad yiri ye kingdan korem menebe ibonmo dabokne inamen nekwe manmo keriib, Yariman yoom yembed Kinoonman yoom yaa. ");
INSERT INTO yon_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Yimbed yedmimaib, “Nub yaa korok kere ooni ye amob domokbem, yimbed saenbed nub yerengkiwen kuu benkirare obon kerem.” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Ewen arimbed dibeen ye Yariman Godbed yi yaa ambon kamende damangkandimaan. ");
INSERT INTO yon_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Kwamekore ye norin arud yaambed yi yaa ongkandimaan. Kwane, ye arud darewoob yaambed yi yaa uniwon karakwon kerundimaan. ");
INSERT INTO yon_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Kuye weng dandimaan kuu, “Neka nembed ne King kuu, ne aangko karadkono Saiyon arimbed nenkonaane oone doreen.” andimaan. ");
INSERT INTO yon_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Kuye Kingbed yedmoon, “Nembed Yariman ye amoweng kee baande daandaniin kei. Yembed ne yaa yedmoon, ‘Eb kuu ne Dana, kibikee ne kuu Ewambe keraan kii. ");
INSERT INTO yon_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","‘Ne yaa kaamowaneeb kuu, ambibkin ambibkin korem kuu ebman ongmeni, okad yimin yimin kangkon kabdaniin. ");
INSERT INTO yon_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","‘Ebbed oonaneeb ye aromkono kuu kamkonomo, awuri areb, kowe okad nunungbed meneki domokbe barad baradmo keremoon areb, ebbed yi yeene monmaraneeb.’” andoon. ");
INSERT INTO yon_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Kwani kowe, kingdan, yiib kuu meeni kangdomiib meenime, okad kiri ooniibdan, yiib kuu ongkandi weng dakmaan kuu awinime. ");
INSERT INTO yon_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Uniyiibbed Yariman ye deme kuu awinime, une kiringmiyiibbed ye yaa kubime. ");
INSERT INTO yon_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Ye Dana Mingki yaa bumangke yaningko kankoonime, kwanaibban kuu arud wandene, yiib wadkeri kuu wedyambed nare monmaraneen. Amborom kuu ye arud kuu kudmeniibban yurendimaan kowe. b Kane kane kuu Dana Mingkimbed kukbimaanbon aombed dobaraniib kuu yi korem kuu amun kerundaneen kii. ");
INSERT INTO yon_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Dewid ye yook. Ye dana Absalom yaambed kombiri wonoon yaron aombed wongkoon. O Yariman, ne bondan kuu yemoon! Ne yaa manmo keriwendan kuu yemoon! ");
INSERT INTO yon_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Nimakarub yemoon kuu ne dowad kamune yedmimaib, ");
INSERT INTO yon_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","O Yariman, eb kuu kwamunemban, ebbed ne kombe areb kerimaab, ebbed ne yaa nambiri kaweneb arudkono kangdom kawimaab. ");
INSERT INTO yon_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Yariman yaa awawe ande baandaina, yembed ye aangko karadmo arimbed inanduwimaan. Selah ");
INSERT INTO yon_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Amnoon doboob kuu ne kuu yiri angkimbaraina waraana yaro dembimain, amborom kuu Yarimanbed awawaane yiminmo dobirimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Ne yaa bon kere kanawanewande kebeniwendan tausen yemooniib kuyaa kuu ne unainban. ");
INSERT INTO yon_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","O Yariman, ne God, yeedere mene ne nen burudanduwe! Ne bondan korem kuu yi mongodkono aangkeneb, arewadan ne yaa manmo keriwen kuu yi ningkambo domangke. ");
INSERT INTO yon_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Arudbon yaa burudande nenmini ye karub kuu Yariman, yembedmo. Kowe, eb karuwa nimaya yaa amun amun kerunde. Selah ");
INSERT INTO yon_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Yook ambo bi ye karub yeman. Nongbed wangki yemaniib. Dewid ye yook. O ne nen koromone dorondandi ye God, eb yaa baandaka inanduwe. Ne dabab aom wanaan kuu ebbed awawi kawewen. Kowe, ne yaa mimyob keeweneb ne kurikuri wengambere. ");
INSERT INTO yon_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","O karuwa nimaya, yiib kuu aron komoyiibbed naningko nambiriyiib yaa damangkawembaraniib? Yiib kuu aron komoyiibbed idiibban yeman yaa dowakeniib kerenib iranmi yeman yaa onmembaraniib? Selah ");
INSERT INTO yon_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Kumban kaadkerime! Yariman kuu ye kiwaan arimo doriibdan kuu ben yeka ye dowad angkara nongkoboon. Kowe, nembed Yariman yaa baandaniin kuu wengamberewaneen. ");
INSERT INTO yon_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Uniyiib kiringmime, ambarakmaib. Yiib angkimbon ari angkibka, yiib mimyob aom andangke darobe iwari kerime. Selah ");
INSERT INTO yon_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Yorokmo ye munob koni yeman konime, Yariman yaamo angkumone dobirime. ");
INSERT INTO yon_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Nimakarub yemoonbed yedmimaib, “Kanembed nub yaa amun kerundaneen? Dowan!” andimaib. O Yariman, eb murubia ye nambiri kuu nub yaa nambere yurok. ");
INSERT INTO yon_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Ne niindem aom kuu ebbed kubi darewoob onduknewewen. Kuu yimbed animan id yemoon ire wanabe wain ok yemoon ongmenib kubimaib kuu burudande arimbed kawewen. ");
INSERT INTO yon_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ne yiri angkimain kuu yewenubmo unuk angkimain, amborom kuu o Yariman, ebbedmo ne nen kangkurudmo kebene oonewimaab. ");
INSERT INTO yon_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Yook ambo bi ye karub yeman. Yurin yeman. Dewid ye yook. O Yariman, eb kuu ne weng ke dakmandamaan kee wengambere. Ne kirindobi wareki keyaa meene. ");
INSERT INTO yon_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ne King, ne God, ne awawi kawi dowad eb yaa ke baandaan kee wengamberewe, amborom kuu eb yaa kurikuri kerimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","O Yariman, amkimo kaimbed ne weng dakmaina wengambirimaab, amkimo kaimbed ne dowaken kaamobi kuu benmene eb arinambo ari nongkobekori, anam kwanuwaneeb andi ye meenimbed meedmimain kii. ");
INSERT INTO yon_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Eb kuu inamen arewa yaa dowakenban ye God, arewa kaimaibdan kuu eb arinambo ari dobirindeban. ");
INSERT INTO yon_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Kerengkan kamiibdan kuu eb indob ari dobirindeban, ambarakmidan kuyaa kuu arud wandeneb dowakenban anam kerewen. ");
INSERT INTO yon_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Dudi weng dakmenabidan kuu ebbed monmaraneeb. Kumka o kuman yenbandidaniib birandidaniib kuyaa kuu Yariman kuu komyeng baeb areb keroon. ");
INSERT INTO yon_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Kumban eb womoniyiibban ye mimyob dowaken yaambed ne kuu eb ambiwoom awudaraniin, eb kurikuri ambib karadmo yaa bumangkaniin, ewaningko kankooni dowad. ");
INSERT INTO yon_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","O Yariman, ne kuu bondaniib kowe, eb yorokmo dobiri yaambed ne nen kinban weneneb, yorokmo dobiri ye kiwaan ebbed ongmewen kuu korobe korokbewe. ");
INSERT INTO yon_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Ne bondan yi dakmi ye weng kuu anam ande awini yemanban, yi niindem aom kuu monmari ye inamen kumbedmo. Yi mongkodem kuu dabunindo ye bobkonombon areb, kwane yi ongbed birandimaib. ");
INSERT INTO yon_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","O God, yi yaa wengyunde dabab konde. Yi wunonwanon weng kumbed yika yi meren monmarime. Yi ambarakmi yemoon kumbed ben ambibkin bunangka kirarundeneb ika mini kuu amob ande, amborom kuu eb yaa wabkad keriwen kowe. ");
INSERT INTO yon_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Kumban kane kane yi kuu ebbed kukbimaabbon aombed dobirimaib kuu kubime, kwane yi kuu kubi yook wingkime. God, eb oonendi kumbed yi ari dabunende. Yi kuu eb yaa mimyob dowaken keebdiwen kowe, kwananeeb kuu eb yaa kubaniib kii. ");
INSERT INTO yon_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","O Yariman, anam kuu ebbed yorokmodan kuu amun kerundimaab, kwane eb womoniyiibban ye mimyob dowaken kumbed yi yaa kuu yirim areb kanawanewandundimaab. ");
INSERT INTO yon_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Yook ambo bi ye karub yeman. Nongbed wangki yemaniib. Seminit ye kiwaan wingki yeman. Dewid ye yook. O Yariman, eb norin wande ne yaa dedmone daawaab, eb arudbed ne arewa kami yaa didangkaab. ");
INSERT INTO yon_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","O Yariman, naromkono kuu dowan kowe, ne yaa mimyob keewe. O Yariman, ne kono aom kuu banabeen kowe, ongmewe. ");
INSERT INTO yon_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Kwane, ne kingkin kumundin kuu dabab keroon. O Yariman, komo aron arimbed eb awawi kuu ne yaa mananeen? ");
INSERT INTO yon_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","O Yariman, ika mene ne nen bobni yaa kuu burudande obon keruwe. Eb womoniyiibban ye mimyob dowaken kumbed burudande obon keruwe. ");
INSERT INTO yon_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Dukniwendan kuu eb yaa meendobimokban, dowan. Kane kanembed bobkonombon aom doriib kuu ewaningko kankoonimaib dee? Dowan! ");
INSERT INTO yon_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Ne kuu warekembiri kumbed wuudne aromkonoyiibban keraan. Amnoom doboob kuu ne angkimbon ari yuudaneni, ne ambongkoni yeman kuu inokbed deendimaan. ");
INSERT INTO yon_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Ne indob kuu inok wembiri kumbed yiminban keroon. Nindob kuu ne bondanbed kwamiib kumbed wuudne kirobeen. ");
INSERT INTO yon_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Yiib arewa ambangkidan korem, ne yaa angkanime, amborom kuu Yarimanbed ne yuudi kuu wengamboroon kii. ");
INSERT INTO yon_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Yariman yaa mimyob keewe awawe ande baandaan kuu wengamboroon. Ne kurikuri yaa kuu Yariman wengamberene ee yimin andoon. ");
INSERT INTO yon_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Ne bondan korem kuu karak bobnenib yi niindem aom kuu dabab kerundaneen, kwane yi kuu kudmeniibban wedyambed yidbobne koronde ika wananiib. ");
INSERT INTO yon_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Dewid ye sigaiyon ye yook, Yariman yaa wingkoon, Benjaminman Kus ye dowad. O Yariman ne God, ebbed kukbimaabbon aombed dobirimain kowe, ne nen kane kanembed nenmo yariibdan yi dingki ari kowaab, yi yaa kuu ne nen burudande obon keruwe. ");
INSERT INTO yon_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Ne nen burudande obon keruwaabban kuu, yi kuu ne yaa laiyonbed aye worobe kurubkurub keremoon areb kamaniib, kwane ne nen wananiib kuu karub maambed ne nen yi yaa burudande obon keruwaanban. ");
INSERT INTO yon_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","O Yariman ne God, ne kuu komo kamaan? Ne dingki aom kuu ambarakmiyiib dee? ");
INSERT INTO yon_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Ne angkodmi nende ye bondan yaa kondaan dee? Ne yaa manmo keroonman kuu idiibban kumbed anbande ye yiribman yid baan dee? Dowan! ");
INSERT INTO yon_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Kwane ambarakmako wedmebka, korondebko ne bondanbed nenmo menenib awinewe nendime, kwane korondebko ne wadkeri monmarenib ne id kan okad kuri keende winime. Selah ");
INSERT INTO yon_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","O Yariman, eb norin yaambed yaro dembe. Ne bondanbed norin wandiwen yaa kuu ebbed yaro dore kebene. Ne God, ebbed kwane ne dowad yaro dembe. Eb kuu wengyundi yaron kowewen. ");
INSERT INTO yon_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Kwane, ambibkindan korem nedbiwen kuu ewiib yaa menebe awanewandime. Ewen arimbed yi yaa oonende. ");
INSERT INTO yon_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Yarimanbed ambibkindan korem yaa wengyundok. O Yariman, ne yorokmo dobiriyiib aadidmiyiibbaniib kuyaambed ne yaa wengyundeneb ma ambarakmindo ande. ");
INSERT INTO yon_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","O God yorokmo, eb kuu nimakarub yi inamen aomiib niindem aomiib kuu andangke darobimaab kowe, arewadan yi kamenabi kuu ben mene dowan kere. Kwane, yorokmodan kuu ben komombed ma yaanban aom nongkobe. ");
INSERT INTO yon_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Ne dorondandi ye kombe kuu God, kaneya yi niindem aom kuu kangdommo kuu yembed ben burudande obonmo kerundimaan. ");
INSERT INTO yon_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","God kuu yorokmo wengyundi ye karub, ye kuu aron mimim korem arud wandimaan ye God. ");
INSERT INTO yon_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Arewadan kuu amonombaibban keraniib kuu, Godbed ye kerewang kande deedmene, ye anangkab kande nikbe yekbad uunaneen. ");
INSERT INTO yon_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Kwane, kabonman ye kumana anaya kuu nekwoon, kwane ye ana yumbuyiib kuu ben ware boknoon. ");
INSERT INTO yon_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Arewaman kuu inamen arewa meendobene, yena yaa dabab kondi ye inamen kowene birandimaan. ");
INSERT INTO yon_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Yembed dem ongme kwane nidke ben angka kiranmimaan kumban, yeka dem ongmoon kuyaom kombirimaan. ");
INSERT INTO yon_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Dabab kondi ye inamen kowimaan kuu ika ye ari menebimaan, kwane ye monmari ye inamen kowimaan kuu yeka yemeren monmarimaan. ");
INSERT INTO yon_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Yariman kuu yorokmo ambangkimaan kowe ye yaa eso andeni, Korem Burudandoon Arimbed Ye Yariman yaa aningko kankooni ye yook wingkaan. ");
INSERT INTO yon_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Yook ambo bi ye karub yeman. Gitit ye kiwaan wingki yeman. Dewid ye yook. O Yariman, nub Yariman, ewaningko kuu nambiri manimanandewiib, okad kiri ye kumkam korem burudande arimbed keroon kii! Eb nambiri kuu Ewen burudande arimbed kowewen. ");
INSERT INTO yon_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Ebbed nekwaawe dana monowiib dana danayiib ewaningko kankooni ye yook wingkimaib, amborom kuu eb kuu bondaniib kowe, eb bondaniib kakman konde yenbandidaniib kuu ebbed kebenendaneeb. ");
INSERT INTO yon_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Ambidiib Eweniib kuu ebman, eb dingkimbed ongmenabewen, kwane woodiib mindongiib kuu ebbed ongmenabe nongkobewen. Kuyaa wedme meendobimain kumbed ");
INSERT INTO yon_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","kwane kaamonimain, “Nimakarub kuu kaneyakob eb kuu yi yaa meenmo doreeb? Yi dana kuu kaneyakob eb kuu yi yaa oone doreeb?” andimain. ");
INSERT INTO yon_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Engyus yi dobiri yaromkono kuu ari, nimakarub yi dobiri yaromkono arebban kuned, nimakarub yiman kuu engyus yiman areb ebbed kowewen. Kwane, eb kuu nimakarub yaa nambiriyiib dobiri manimanandewiib bangkandewen. ");
INSERT INTO yon_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Yi kuu ebbed ben eb dingkimbed ongmenabewen ye kumkam oonidan ongmewen, kwane kumkam korem ben yi dabderem yiri nongkobewen, ");
INSERT INTO yon_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","sibi koremiib buromakau koremiib dingkan kiiwiib ");
INSERT INTO yon_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","ayari oniib ok yiri ooniib karamok yiri dingkan koremiib kui. ");
INSERT INTO yon_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","O Yariman, nub Yariman, ewaningko kuu nambiri manimanandewiib, okad kiri ye kumkam korem burudande arimbed keroon kii! ");
INSERT INTO yon_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Yook ambo bi ye karub yeman. “Dana Bobnoon” ye yook ye kiwaan yaambed wingki yeman. Dewid ye yook. O Yariman, ne niindem aom kumundin kumbed ewaningko kankoonaniin, kwane binangke eb kuu anam andi yeman korokbendewen kuu dakmaniin. ");
INSERT INTO yon_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Eb yaa dowakeniib kubiyiib kerubdaniin, Korem Burudandoon Arimbed Ye God, ne kwane ewaningko yaa kubebdeni wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Eb angkaderewen kowe, ne bondan kuu yiminban kere ika winiwen, kwane yi kuu kirobe dukne winiwen. ");
INSERT INTO yon_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Amborom kuu eb kuu kangdod yumbon ari kuu dibere yorokmombed wengyundimaab kowe, ne inamen kuu ebbed wengyunde ee yimin andewen. ");
INSERT INTO yon_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Ebbed ambibkin maa maadan yaa kamkono weng kondeneb, arewa kamiibdan kuu ben monmarewen, kwane yi aningko kuu arewen kumbed dowan keroon, aron korem ye dowad. ");
INSERT INTO yon_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Aron korem ye monmari kuu bondan yaa meneboon, kwane yi kambong kuu ebbed monmarewen, kedi, yi aningko kuu nonondande dowan keroon kii. ");
INSERT INTO yon_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Kumban Yariman kuu aron korem oonembaraneen, kwane ye dibere kangdod kondimbon kuu nekwoon. ");
INSERT INTO yon_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Ye kuu okad yiridan ben yorokmombed wengyundaneen, kwane ye kuu ambibkin mimimdan yaa konomdangmo wengyundaneen. ");
INSERT INTO yon_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Yariman kuu dabab wayiroondan yi ben kukbimbonman, kwane ye kuu yobdood meneboon yaa aromkonoyiib dobirimbonman. ");
INSERT INTO yon_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","O Yariman, eb yikaaddan kuu eb yaambed yonenib ebbed kwananeeb ande inamen kowaniib, amborom kuu eb ande miniwendan kuu eb kuu yi yaa angkurom korokbaabban kowe. ");
INSERT INTO yon_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Yariman kuu Sayion arimbed oone dobirimaan, ye yaa kubene wingkime, kwane yembed komo ambangkoon kuu ambibkin mimimdan aom yaa dakmime. ");
INSERT INTO yon_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Amborom kuu kumka o kuman kamiibdan yaa kakman inandi ye God kuu dabab meneboondan yaa meenimaan, yi kuu ye yaa kwane baandimaan kowe yi yaa akmen naknod kere nonondandimokban kui. ");
INSERT INTO yon_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","O Yariman, ne bondanbed durud yewed ke kawiwen kee wedmende. Mimyob keeweneb bobni ye ambongko yaa kee nenkone burudande. ");
INSERT INTO yon_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Kwanebko, Saiyon ye mungkan Yerusalem yu kuuk ambongkodem aombed ewaningko kankooni weng korem dakmeni, bobni yaa burudande bindi ye kiwaan ebbed ongmewen ye dowad kuba. ");
INSERT INTO yon_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Ambibkin mimim kuu yi bondan kirobime andi ye dem nidkiwen kuu yika kuri kirobiwen, kwane yi yon kuu yika yi kawaad nong kowe bikniwen kumbed awindoon. ");
INSERT INTO yon_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Yariman kuu ye wengyundi yorokmo kumbed ye inamen korokboon, kwane arewa kamidan kuu yika yi dingkimbed komo ambangkiwen kumbed kawaad nongbed awindemoon areb keriwen. ");
INSERT INTO yon_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Arewa kamidan kuu ika bobkonombon yiri wananiib, God yaa wunekare nonondandiwen ye ambibkin mimimdan korem kui. ");
INSERT INTO yon_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Kibikee kamboknondan kuu awandiyiibban kumban Godbed aron korem yi yaa nonondandaanban, Godbed kwananeen ande meeni ye inamen kuu kibikee yobdood meneboondan yaa kuu dowan, kumban aron ari kuu kuye inamen kuu ika awinaniib. ");
INSERT INTO yon_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","O Yariman, yaro dembe. Korondaawa kangdod aom kuu karubbed eb kan kubunaib. Ambibkin mimimdan kuu eb kerebiri arimbed kangdod kerunde. ");
INSERT INTO yon_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","O Yariman, yi kuu ongmendebko unime. Korokbendebko, ambibkin mimimdan kuu nimakarub dokmenmo kuu yikaadkerime. Selah ");
INSERT INTO yon_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","O Yariman, komoyiibkob eb kuu ambab angkambed kwane doreeb? Komoyiibkob dabab kandimaub yaron ari kuu biknekoreb wedmendimokban kerimaab? ");
INSERT INTO yon_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Arewa kamembiri ye karub kuu ye kerengkan kumbed kamboknondan yenbande yarimaan kowe, ye kuu yena yaa wunonwanon ye inamen meenimaan kumban ebbed ye nen kuye inamen ye dabab aom kowe. ");
INSERT INTO yon_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Arewa kamembiri ye karub kuu ye inamen dowaken arewa kuyaa kerengkan kaimaan, kwane yembed kirimdan yaa amun kerundekore Yariman yaa butun kaimaan. ");
INSERT INTO yon_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Arewa kamembiri ye karub kuu ye kerengkan kaimaan kumbed God ande onmimokban, kwane ye meeni inamen aom kuu God yaayiib ma meenimokban. ");
INSERT INTO yon_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Arewa kamembiri ye karub kuu yiribman bi ye kiwaan ongimaan kuu yiminmo kerimaan kuned, eb wengyundi ye inamen kuu arimo, ye kuu kuyaa wedme yekaadkerindeban, kwane ye bondan yaa kuu wooyo ande ambon baandimaan. ");
INSERT INTO yon_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Kwane, yeka yemeren yedmimaan, “Komombed ne kuu ma nen yiri kubunaanban, aron korem kubimo dobaraniin, ne yaa dabab ma manaanban.” andimaan. ");
INSERT INTO yon_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Ye mongkodkono aom kuu butun kamiyiib dudanabiyiib yenbandaniin andiyiib kumbedmo, kwane dabab kondiyiib arewa kamiyiib ye weng kuu kirod dakmaneenmo. ");
INSERT INTO yon_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Ye kuu kambong diambed kakubuk bikne meedmimaan, kwane biknimbon yaambed ambarakmiyiibbandan ogood kuyaa kumka yimaan, kwane yewed kondandameendan yaa kuu yemyeb bikne keendombirimaan. ");
INSERT INTO yon_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Ye kuu laiyon areb biknimbon yaambed kakubuk bikne meedmimaan, kwane ye kuu angkimbere meedmene kamboknondan awindande kaimaan, kwane awindekore ye oon bi ye men aom kamobe be irin wenemoon areb kamimaan. ");
INSERT INTO yon_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Kamboknondan kuu yembed ben yiri kiradme yob beengkemoon areb kamimaan, kwane yi kuu ye aromkonombed ben yiri kubunimaan. ");
INSERT INTO yon_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Arewa kamembiri ye karubbed yeka yedmimaan, “God kuu nonondandoon, ye murubia kuu kebenekore wedmewimokban.” andimaan. ");
INSERT INTO yon_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","O Yariman, yaro dembe! Eb dingki kankoone yire. O God, dabab kandiwendan yaa nonondandundaab. ");
INSERT INTO yon_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Arewa kamembiri ye karub kuu komande God yaa butun kaimaan? Komande yekareb yedmimaan, “Nembed komo kamiin yaa kuu ye kuu wengyundaanban.” andimaan? ");
INSERT INTO yon_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Kumban, o God, eb kuu dabab menebiyiib mimyob wandiyiib yaa kuu wedmimaab, kuyaa kuu ben awandi ye dowad meenimaab. Dabab kandoonman kuu yekareb eb dingki ari kowimaan, kwane anenabdan yaa kuu ebbed awandimaab. ");
INSERT INTO yon_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Arewa kamembiri ye karub ye aromkono kuu ebbed domangke nen angkadere. Ye arewa kamembiri kuu ebbed wengyunde dabab kone yemoon keraneeb kumbed ye inamen arewa kuu dowan keraneen. ");
INSERT INTO yon_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yariman kuu aron korem korem ye king keroon, kwane ye weng wengambaraibban ye ambibkindan kuu ye okad ambab angkambed duknaniib. ");
INSERT INTO yon_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","O Yariman, dabab kandiwendan yi meeni dowaken kuu ebbed wedmeneb, ebbed yi yaa kube ongkandeneb yimbed eb yaa baandi kuu ebbed wengamberendimaab. ");
INSERT INTO yon_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Anenabdaniib dabab wayiroondaniib kuu ebbed dorondarundimaab, okad yiridanbed uniwon karakwon kondi kuu dowan kerok anded. ");
INSERT INTO yon_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. Yarimanbed kukbimaanbon aombed dobirimain. Kowe, inamen arewaman, eb kuu kanekob ne yaa kuu ke yedmewewen kei, “Ayari on areb ewaangko ari wanwene. ");
INSERT INTO yon_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Kedi, wedme. Arewa kamembiridan kuu yi ana ben yekbad yaa dedmobenib, yi anangkab angkokbimaib. Yi kuu kumun aombed niindem aom yorokmo kere doriibdan yaa baradmande doriib. ");
INSERT INTO yon_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Kwane, ambokab yiri ye inamen monmarimaib kowe, yorokmodan kuu komo keraniib?” andewen, komarewa kii? ");
INSERT INTO yon_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Yariman kuu ye kurikuri ambib karadmo aom doreen, kwane Yariman kuu ye dibere oonimbon Ewen ari dibeen. Ye kuu nimakarub korem yaa ongme keendombirimaan, ye indob kuu nimakarub yi niindem aom andangkimaan. ");
INSERT INTO yon_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yariman kuu yorokmodan yi niindem aom andangkimaan, kumban arewa kamembiridaniib yenbandi yaa dowaken keriwendaniib yaa kuu ye kingkinbed arud wandembirimaan. ");
INSERT INTO yon_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Arewa kamembiridan yaa kuu amoyidkowiib bod sulfaa yumbuyiib kiradmaneene am areb yi ari kirobaneen. Kwane, nimin kaiyiib ye nuub kumbed yi yaa wurumembirimbon aom nongkobaneen. ");
INSERT INTO yon_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Amborom kuu Yariman kuu yorokmo, ye dowaken darewoob kuu yorokmo kamime anded, kwane kangdommo doriibdan kuu ye murubia wedmaniib. ");
INSERT INTO yon_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Yook ambo bi ye karub yeman. Seminit ye kiwaan wingki yeman. Dewid ye yook. Yariman, awawe. Eb kerekmen yaa doriibdan kuu dowan, anam anam yaa ma korondiyiibban awinimo doriibdan kuu nimakarub aombed wenebe dowan keriwen. ");
INSERT INTO yon_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Nimakarub korem kuu yi dia doriibdan yaa birandimaib, kwane kobkob weng kuu yi mongkodem aombed menebimaan birandi ye dowad. ");
INSERT INTO yon_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Kwane, kobkob weng dakmidan kuu Yarimanbed kebenendok. Kwane, kane kanembed kerengkan kame ");
INSERT INTO yon_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","“Nubkareb aromne dakmenabanuub kumbed yena yaa burudandande yi korok keranuub. Nub komo dakmandamuub kuu kumbedmo, karub maambed kebendaanban.” ande dakmimaib kuu Yarimanbed kebenendok. ");
INSERT INTO yon_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Yarimanbed yedmoon, “Kamboknondan kuu arewa kamidanbed ben dabab wayiroon kuyiib yenbandiwendan wareki kamiib kuyiib wedmaan kowe, kibireb kee yaro dobaraan. Yaro dobere yi dowaken yaambed dorondande awandaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Kwane, Yariman ye weng kuu karadmo, ma arewayiibban. Ye weng kuu bot silvaa kande nengkanabi yeman aom kamone yankoren anam keri dowad nengke ika ika kame ediib kerimaib kwane areb, karadmo kai. ");
INSERT INTO yon_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","O Yariman, ebbed nub ben ongme oonaneeb, kwane kuye arewa kamidan yaa kuu ebbed nub ben dorondandaneeb, aron korem. ");
INSERT INTO yon_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Inamen miin arewa kuu nimakarub inamen amun ande kamiib kumbed arewa kamidan kuu okad kuyaa nubkob ande kerengkan kame yarimaib. ");
INSERT INTO yon_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. O Yariman, eb kuu aron komoyiib ne yaa meenaabban? Aron korem nonondanduwaneewoo? Aron komoyiib ne yaa angkurom korokbewaneeb? ");
INSERT INTO yon_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Aronkiyiib amnoomiib mimyob wandimain kowe, aron komoyiib ne inamen aom dabab kandembaraniin? Aron komoyiib ne bonman kuu ne burudande doraneen? ");
INSERT INTO yon_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","O Yariman ne God, ne yaa wedmewe inanduwe. Ne id yaa aromkono konebko nindob yimin kerok. Kwanaabban kuu angke bobnaniine, ");
INSERT INTO yon_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","ne bonmanbed “Ye kuu nembed bidkonaan.” ande yedmaneene ne bondanbed ne kombaraan yaa kubaniib kii. ");
INSERT INTO yon_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Kumban ne kuu eb womoniyiibban ye mimyob dowaken yaa angkimbaraneen andimain, kwane ne niindem aom kuu bobni yaa burudande bindi ye kiwaan ebbed ongmewen ye dowad kubimain. ");
INSERT INTO yon_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Ne kuu Yariman yaa wingkaniin, amborom kuu ye kuu ne yaa amunmo kamoon kowe. ");
INSERT INTO yon_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. Inameniibbandan kuu yi niindem aom kuu “Godiibban, dowan.” ande yedmimaib. Yi kuu yorokmomban, unitab, yi ambangki kuu komyengiib, yi kuyaa mimo kanembed ma amun kamimokban. ");
INSERT INTO yon_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yariman kuu Ewen arimbed kiri nimakarub korem yaa kerendeen, ye kuu karub mim mim kanembed inamen kande God ye kiwaan yaa onme dobiridan kuu wedmanded. ");
INSERT INTO yon_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Kumban yi korem kuu amonombe yangmad kere kimyen wenebiwen, kwane yi kuu ibonmo yorokmoyiibban unitab keriwen. Yi mim kuyaa kuu kanembed ma amun kamimokban, korem dowan kai. ");
INSERT INTO yon_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Arewa kamidan kuu ma kaadkeraniib dee? Kedi, yi kuu om anemoon areb ne karuwa nimaya monmarimaib, kwane yi kuu Yariman yaa ma baandimokban. ");
INSERT INTO yon_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Kumban yi kuu unimbed de derendande onekandoon, amborom kuu God kuu yorokmodan yoom doreen kowe. ");
INSERT INTO yon_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Arewa kamidan, yiib kuu kamboknondan yi inamen kowiwen yaa kebenimaib, kumban yi kuu Yarimanbed kukbimaanbon aombed dobirimaib. ");
INSERT INTO yon_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","O, Israeldan yi bondan burudande obon kerundi ye karub kuu aangko Saion arimbed angkadere monok. Kuyaron kuu Yarimanbed ye nimaya karuwa ben obonmo kerunde yiminmo kerundaneen. Kwanoka Yekob ye meed Israeldan kuu dowaken kere kubime. ");
INSERT INTO yon_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Dewid ye yook. O Yariman, eb kurikuri ambib aom aomni kuu kane kuu yimin? Ewaangko karadmo ari dobiri kuu kane kuu yimin? ");
INSERT INTO yon_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Kuye karub kuu ambarakmoon ande kadwoniyiibban, kwane ye kuu yorokmo yaambed ambangkene, ye niindem aom kuu anammo kumbed anammo dakmimaan. ");
INSERT INTO yon_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Kwane ye kuu wengamborokbandimokban, ye kuu ye dia doriibdan yaa ma ambarakmendimokban, kwane ye angkodmi yaa kobkob daanubdaanab kamimokban. ");
INSERT INTO yon_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Kwane ye kuu arewa kamimaibdan yaa kuu odkeneb kerimaan, kumban kane kane Yariman yaa uniwendan kuu yi aningko kankoonimaan. Kwane ye amob ongmoon kuu no awinaneen, kuye amob awinaneen kumbed dabab menebaneen kuned. ");
INSERT INTO yon_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Ye kuu od bangkandekore ika ari iniyiib yedme kandaanban, kwane ye kuu arewa kamidan yi od yemyeb kandene ambarakmindoman yaa ambarakmoon ande yedmaanban. Kane ye kuu keamune kamaneen kuu kiringmaanban kangdommo keraneen. ");
INSERT INTO yon_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Dewid ye miktam ye yook. O God, ne nen dorondande, amborom kuu ebbed kukbimaabbon aombed dobirimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Nembed Yariman yaa yedmaan, “Eb kuu ne Yariman, kumkam amun ne yaa dangoon kuu eb yaambedmo.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Karadmodan okad kiri doriib kuu nambiri manimanandewiib, ne kubi dowaken korem kuu yi yaa angkeen. ");
INSERT INTO yon_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Kane kane god yena yaa winimaib yi mimyob wandi kuu maa ariyiib kan dabokne wananeen. Yi god yaa dingkan aye nengke baeb kone umkan onduknimaib kuu wene daboknainban, kwane yi god yi aningko kankoonainban. ");
INSERT INTO yon_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Yariman, ne dobiriyiib yumboniib kuu ebbed ongmewen. Ari ne komo keraniin kangkon ebbed ooneeb. ");
INSERT INTO yon_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Okad yimin yaa nariwen kuu ne dowaken yaambed ongmiwen. Anam kuu nokad kawewen kuu kubimo yeman. ");
INSERT INTO yon_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Ne kuu Yariman yaa kubaniin, yembed kedmengkawimaan kowe, kwane amnoom kangkon ne inamen meeni ye kiwaan kumbed inamen amun korokbewimaan. ");
INSERT INTO yon_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Ne kuu Yariman kuu barang darewoob ande meenimain. Ye kuu ne dingki wiwi angka doreen kowe, ne kuu kiringmaanban kangdommo keraniin. ");
INSERT INTO yon_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Kwane kowe, ne mimyob kuu kubeena ne ong kangkon kubeen. Ne id kangkon uniyiibban dobaraneen. ");
INSERT INTO yon_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Amborom kuu ebbed ne kuu bobkonombon yiri aron korem domowawe deendainban, kwane korondaawe eb Karadmoman kuu bobne deendaanban. ");
INSERT INTO yon_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Ebbed wadkeri ye kiwaan kuu korokbewewen. Kwane eb arinambo arimbed ne yaa kubi kawaneeb, aron korem ye kubiyiib eb dingki wiwi angkambed kui. ");
INSERT INTO yon_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Dewid ye kurikuri yook. O Yariman, wengyundi amun kawe ande kaamobdako wengambere. Ne baandi kee wengambere. Ne kurikuri kee wengambere, ne weng kee birandi ye inamen yaambed dembindo kowe. ");
INSERT INTO yon_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Ebbed ne dowad wengyunde ma ambarakmindo ande, ewindobbed yorokmo kiwaan wedme. ");
INSERT INTO yon_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Eb kuu ne niindem aom wedmene amnoombed andangkewe, kombon darobewimaab kumban ambarakmi maa ma wedmaabban. Ne inamen kowaan kuu ne wengbed ambarakmain andaan, ");
INSERT INTO yon_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","okad yiridan kwamunemban. Eweng awine kandaan kowe, yeremboromdan yi kiwaan yaa kangkadmimain. ");
INSERT INTO yon_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Ne kuu eb kiwaan yirimo dodkanmo weniin, ne yon kuu ma monkare kimyen angka ma dodkan winindo. ");
INSERT INTO yon_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","O God, ne kuu eb yaa baandimain, amborom kuu ebbed inanduwimaab kowe, kerendem kawe ne kurikuri wengambere. ");
INSERT INTO yon_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Kane kane yi bondan yaambed kirokmone ebbed kukbimaabbon aombed dobirimaib kuu, eb dingki wiwimbed ben burudande bindimaab kowe, eb womoniyiibban ye mimyob dowaken miin darewoob yi yaa korokbende, kukuu binangki yeman, miin darewoob anam kowe. ");
INSERT INTO yon_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Ewindobbed ebka dorondandemoon areb ne nen dorondande. On ayam yu mana kuu yu dongkon dem aom nen biknemoon areb ne nen bikne. ");
INSERT INTO yon_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Arewa kamidanbed nenbandande kamiib yaa kuu kwane dorondande, ne neene kowandamiibdan ne kanawanewandiwen yaa kui. ");
INSERT INTO yon_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Yi mimyob keendi kuu dowan kai, yi kuu kerengkan kami ye wengmo dakmimaib. ");
INSERT INTO yon_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Yi kuu ne kerewenmo miniwen kumbed kibikee ne kanawanewandiwen, kwane kereknenmo dorenib ne nen okad yiri korarande doriib. ");
INSERT INTO yon_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Yi kuu laiyonbed dingkan mungi bobnemoon areb doriib, laiyon darewoobbed biknimbon aombed kerekne diberemoon areb kui. ");
INSERT INTO yon_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","O Yariman, yaro dembe! Yi durunde yenbande ben yiri kubudere. Eb kerewangbed arewa kamidan yaa ne nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","O Yariman, eb dingkimbed karub kwamenabimaib yaa ne nen burudande angka kowe, okad kiridan okad yiri ye wadkeri ye kakmanmo kandi dowad kwanimaibdan yaa kui. Ebbed bobne komberewendan yaa kuu animan bangkandaawe ane mikmonaiwe yi mungi dowan kerimaan, kwane yi meed kangkon yiminmo dobirimaib, kwane kuye bangkandembiri yeman kuu yi awoya yaa kangkon angkeen. ");
INSERT INTO yon_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Kwane, ne kuu yorokmo dobiri yaambed eb murubia wedmaniin. Kwane ne kuu unuk yirimbed yaro dembaniin kuu eb kuru wedmeni kubaniin. ");
INSERT INTO yon_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Yook ambo bi ye karub yeman. Yariman ye dememan Dewidbed wongkoon. Yarimanbed Dewid ye bondan koremiib Sooliib yaambed ye nen burudande angka kowoon kumbed keye yook wingkoon, Yariman yaa. O Yariman, eb kuu ne aromkono, eb yaa mimyob dowaken keebdaan. ");
INSERT INTO yon_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yariman kuu ne aromkonombon, ye kuu ne aromne angkumonimbon, ye kuu arud barang yaambed ne nen burudande angka kowi ye karub. Ne God kuu ne aromkonombon, yembed kukbimaanbon aombed dobirimain. Ye kuu ne kombe, ye kuu bobni yaa ne nen burudande bindi yaromkono, ye kuu ne dorondarimbon. ");
INSERT INTO yon_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Yariman kuu amunmo kowe yaningko kankooni kuu yimin. Ne kuu ye yaa baandimain kowe, ne bondan yaa ne nen burudande angka kowimaan. ");
INSERT INTO yon_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Bobni ye kibin abakbed ne kuu yerengkoon, kwane monmari ye barang kuu urok yuknemoon areb ne burudandoon. ");
INSERT INTO yon_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Bobkonombon ye kibin abakbed ne yaa kanawanewawoon, kwane bobni ye warabbed ne kebenewoon. ");
INSERT INTO yon_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Ne mimyob wande miin yiminban keraan kumbed Yariman yaa baandaan, kwane ne God yaa awawok ande komkaan. Kwane, ye kurikuri ambib aombed ne weng kuu wengamboroon, ne baandi kuu wene ye kerendem aom aomnoon. ");
INSERT INTO yon_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Okad kuu binangkiyiib dowodkiyiib keruune, aangko angkumonimbon kuu ben kiringmeen. Yi binangkiwen kuu Godbed norin wandoon kowe. ");
INSERT INTO yon_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Amareng kuu ye kiringkono dembed dembenaboon, kwane dene dowan keri ye amoyiib amoyidkowiib kuu ye mongkodembed dembenaboon. ");
INSERT INTO yon_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Ye kuu ambid birinde kan yone yiri kamonoon, kwane ye yon dad dabderem yiri kuu wiib kumun miriknimbonmo. ");
INSERT INTO yon_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Ye kuu engyu burawiib arimbed dibere wanwonoon, kwane ye kuu nuub arimbed wanwonoon. ");
INSERT INTO yon_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Ye kuu kumun kande ye dabuni yeman kerundoon, ye dabuni yeman kuu ambid ye amokambid. ");
INSERT INTO yon_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Ye kerebiri ye nambirimbon kumaombed wiib yeeduruune am boyareb yurukmo kuyiib amoyidkowiib angkadereboon. ");
INSERT INTO yon_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Yariman kuu Ewen arimbed nambad areb baandoon, kwane Korem Burudandoon Arimbed ye God ye weng yuud kuu derendaroon. ");
INSERT INTO yon_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Ye ana barandoona bondan kuu kirokmone buyokbayok keriwen, kwane imak aande yenbandoona kirokmone dawariwen. ");
INSERT INTO yon_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","O Yariman, eweng kamkono ongkandewen, kwane eb kiringkono dem aombed inum nareewa yeedereboon kumbed karamok niindem yiri kankubunimbon kuu dokmenmo kereene, kwane okad yu angkumonimbon kwangkon dokmenmo kereen. ");
INSERT INTO yon_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Ye kuu ari kaimbed yiri yirene arudbon aombed ne nendoon, ne kuu ok niindem yirimbed nen wandune kowoon kui. ");
INSERT INTO yon_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Yembed ne bonman aromkono darewoowiib yaa nen burudande angka kowoon, ne bondan aromkonoyiib ne arebban kuyaa kui. ");
INSERT INTO yon_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Ne kuu dabab aom aomnaan kumbed yimbed nenbandande miniwen, kumban Yarimanbed yone awawoon. ");
INSERT INTO yon_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Arudbon aom kuu yembed ne awawe nen angka kowoon, ye kuu ne yaa dowaken keewoon kowe nen burudande kowoon. ");
INSERT INTO yon_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Yarimanbed ne yorokmo kaimain yaambed amun keruwoon, kwane ne kuu darobe wedmoonka koromiibban dobman kowe ne yaa kakman amun keewoon. ");
INSERT INTO yon_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Amborom kuu ne kuu Yariman ye kiwaan arimo winimain, ne kuu ne God yaa ma amonombe koronde winindo kowe arewa kamindo. ");
INSERT INTO yon_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Yembed dakmenaboon ye amob korem kuu ne wedmoni awine kandaan, kwane yembed wongkanaboon ye amob kuu ne ma wengamberedandindo. ");
INSERT INTO yon_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Ye yekaad ne kuu karub maambed ambarakmoon ande kadwonimokban, kwane ne kuu ambarakmi yaa kangkadmimain. ");
INSERT INTO yon_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Yarimanbed ne yorokmo kaimain yaambed kakman amun kawoon, ye indob arimbed ne ma ambarakmindo kuyaambed kui. ");
INSERT INTO yon_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","O God, kane kane yi kuu eb yaa ma korondiyiibban doriib kuu ebbed yi yaa ma korondiyiibban ye dobiri kiwaan kuu korokbendimaab, kwane kane kane kuu karub maambed ambarakmoon ande kadwonokban kuu eb karub maambed ambarakmoon ande kadwonaanban ye kiwaan kuu yi yaa korokbendimaab, ");
INSERT INTO yon_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","kwane kane kane kuu karadmo doriib kuu eb karadmo dobiri ye kiwaan yi yaa korokbendimaab, kumban unitabdan yaa kuu eb kuu inamen kan bikniwen yaa darobi ye karub korokbendimaab. ");
INSERT INTO yon_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Kane kane yika kan kubunimaib kuu ebbed ben burudande obon kerundimaab, kumban kane kane kerengkan kamimaib kuu ebbed ben yiri kubunimaab. ");
INSERT INTO yon_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Eb kuu ne kiwaan yurimaab, o Yariman ne God, eb kuu kumun aom doriin kuu kan amonombe nambiri kerimaab. ");
INSERT INTO yon_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Eb aromkonombed kawaneewa bondan yemoon kuu yeene burudandaniin kuu yimin, kwane ne Godbed neyiib yaa doreen kuu aromnewaneena yi aromne angkumonimbon korongberenande aomnaniin kuu yimin. ");
INSERT INTO yon_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Ma, God kee ye kiwaan kuu demkoronmo, Yariman ye weng kuu karadmo. Kane kane kuu ye kukbimaanbon aombed dobirimaib kuu, ye kuu yi kombe keroon. ");
INSERT INTO yon_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Kedi, kane kuu God? Yariman yembedmo! Kane kuu yone aromnimbon? Nub God yembedmo! ");
INSERT INTO yon_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Ne yaa aromkono kawi ye karub kuu God, kwane yembed ne dobiri ye kiwaan kuu demkoronmo ongmimaan. ");
INSERT INTO yon_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Ye kuu ne yon kuu diiya ye yon areb ongmimaan, kwane ye kuu ne ongmaane aangko arimbed yarebimain, kombirimokban. ");
INSERT INTO yon_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Yembed ana nangmi dowad kedmengkawimaan, kowe ne dingki kuu anangkab aromkono kuu nikbimain. ");
INSERT INTO yon_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Ebbed ne nen burudande angka kowi kuu kombe areb, ebbed ne nen dorondandimaab, kwane eb dingki wiwimbed ne awawaawe yiminmo dobirimain. Eb kuro yiri ambokibine awawewen kumbed aningko darewoowiib keraan. ");
INSERT INTO yon_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Kiwaan ari wanaan kuu ebbed yirimbonmo ongmimaab, kowe ne kuu kombirimokban. ");
INSERT INTO yon_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Ne bondan kuu nembed yondem kerenden wene burudande awingkandaan. Ne kuu yinmone korondindo, yi monmaraan kumbed ika manaan. ");
INSERT INTO yon_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Nembed yi yeene beengkaan kowe, yi kuu yaro dembindeban keriwen, kwane yi kuu ne yon dad dabderem aom kirobiwen. ");
INSERT INTO yon_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Ana nangmi dowad ebbed aromkono ne yaa kawewen, kwane ebbed ne bondan ben ne yon yiri nongkobeewe ne yaa bumangkiwen. ");
INSERT INTO yon_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Ebbed ne bondan ben amonombeewe kirokmoniiwe yeene monmaraan. ");
INSERT INTO yon_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Yi kuu awandi dowad baandiwen kumban karub maa kanembed yi kuu ma ben burudande awandindo, kwane Yariman yaa baandiwen kumban ye kuu yi yaa ma awandindo dowan. ");
INSERT INTO yon_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Nembed yi kuu dore yon dowood dararaana ingkud nuubbed wuruwemoon areb keriwen, kwane nembed yi kuu ben kubudaraane birin kiwaan ari dore boknemoon areb keriwen. ");
INSERT INTO yon_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Karubbed ne nande kamiwen kuu ebbed ne nen burudande angka kowewen. Ebbed ne kuu ambibkin maa maa yi korok nen kinewen, kwane nimakarub yi ne ma nekaadkerundindo kuu ne dabderem yiri doriib. ");
INSERT INTO yon_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Yi kuu ne yaa wengambirimaib kuu no awine kandimaib, kwane owoddan kuu ne yaa unewe ika anuk irinambenimaib. ");
INSERT INTO yon_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Yi arudkono kuu dowan kerimaib, kwane yi kuu yi aromne angkumonimbon yaambed neyiib yaa kiringmiyiib minimaib. ");
INSERT INTO yon_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Yariman kuu doreen kii! Ne yaa yone aromni ye God yaningko kankoonem! Ne nen bobni yaa burudande bindi ye God yaningko kankoonem! ");
INSERT INTO yon_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Ye kuu ne bondan yaa kakman kondimaan ye God, kwane ye kuu ambibkin maa maa ben ne dabderem yiri nongkobimaan ye God, ");
INSERT INTO yon_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","kwane ye kuu ne bondan yaambed ne nen burudande angka kowimaan ye God. Eb kuu ne bondan yaambed ne nen burudande aningko darewoob arimbed kawewen, kwane eb kuu yeremboromdan yaambed ne nen burudande angka kowewen. ");
INSERT INTO yon_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Kwamunewen kowe, o Yariman, ambibkin korem aom kuu eb yaa kubebdaniin, kwane ewaningko kankoone wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Godbed king kerunoon ye karub yaa burudande dori arimbed bangkanoon, kwane ye kuu yembed kinoonman yaa womoniyiibban ye mimyob dowaken keenimaan, Dewid yoom ye awoya ari yoom yaa aron korem keendimaan kui. ");
INSERT INTO yon_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. Ambidiib mindong yi dangimboniib kuu God ye nambiri dianmo korokbimaib, kwane yi kuu ye dingkimbed ongmenaboon yaa kuu korobe dakmimaib. ");
INSERT INTO yon_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Aronki mimim kuu kwane dakmembirimaib, amnoom mimim kangkon kaadkeri ye kerekmen ye weng kwane dakmembirimaib. ");
INSERT INTO yon_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Kukuu dakmiyiibban, kwane wengiibban, kwane yi weng yuud kuu maambed wengambirimokban. ");
INSERT INTO yon_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Kuned yi weng yuk kuu bid yimin yimin yaa angkane wenebimaan, yi weng kangkon bid yimin yimin yaa wenebimaan. Ambid aom kuu yembed aron ye yumbon ongme kowoon. ");
INSERT INTO yon_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Aron yeedirimaun kuu karub wonong mokaid awanande ye angkimbon aombed angkaderemoon areb kui. Yu kuu kabani yaa burudandunindeban ye karubbed kubene kabanimaan areb. ");
INSERT INTO yon_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Kwane yu kuu ambid dungkun angkarambed daadere dokbe angkara kubunimaun. Yu nambiri yaa kuu barang maa ma biknimokban. ");
INSERT INTO yon_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Yariman ye amob kuu demkoronmo, kingkin yaa aromkono yeeb konimaan. Yarimanbed komo kamoon ye weng kuu anam anammo, mengmengiibban iwari doriibdan ben meeni kangdomdan kerundimaan. ");
INSERT INTO yon_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Yariman ye kongamki yamob kuu yorokmo, niindem aom kubi kondimaan. Yarimanbed kwanime andi ye weng kuu karadmo, kiwaan amunmo korokbimaan. ");
INSERT INTO yon_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Yariman yaa une bumangki kuu amun, kuye inamen kuu aron korem angkimbaraneen. Yariman ye wengyundi kuu yiminmo, yi korem kuu yorokmo. ");
INSERT INTO yon_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Ye amob yaa kuu bobne kombiri yeman, bod gold arebban, bod gold yankorenmo yemoon yaa kangkon burudandiwen. Ye amob kuu ambod miin amuniib, in ok ambod arebban, in ok ambodmo yaa burudandiwen. ");
INSERT INTO yon_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Yi yaambed eb demedan kuu ongkandoon, kwane ye amob be amuknaniib kuu kakman amun darewoob kandaniib. ");
INSERT INTO yon_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Kanembed yeka ye ambarakmi kuu wedmenaneen? Dowan. Nekaadkerunindo ye ambarakmi kuu ebbed are nonondande. ");
INSERT INTO yon_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Eb deme karub nembed kwane inamen ongme ambarakmaniin andaka ebbed kebenewe. Korondaawe kuye ambarakmi kuu ne yaa oonewaan. Kwananeeb kuu karub maambed ne yaa ambarakmoon ande kadwoniyiibban keraniin, kwane ebbed wengyunde miin wabkad kerewen andaabban. ");
INSERT INTO yon_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Kwane, eb indob ari kuu ne mongkodkonombed weng dakmeni ne niindem aombed meenako eb kubi dowaken kerok, o Yariman, ne aromkonombon, kwane ne biddi ye karub. ");
INSERT INTO yon_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. Kwane dabab kandebka Yarimanbed inandubdok, kwane Yekob ye God yaningko yaambed dorondarubdok. ");
INSERT INTO yon_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Yembed kurikuri boyambiwoombed awabdok, kwane aangko Saiyon yaambed eb nen angkumonok. ");
INSERT INTO yon_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Ebbed God yaa bangkanimaab korem kuu yembed ika meenok, kwane ebbed dingkan aye nengke agedmo kere baeb koni yeman bangkanimaab kuu yembed ee yimin andok.Selah ");
INSERT INTO yon_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Eb niindem aombed komo yaa dowakeniib kerewen kuu yembed kabdok, kwane inamen ongmenabewen korem kuu yembed ongmoko anam kerok. ");
INSERT INTO yon_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Ebbed bondan nangme burudande doraneeb kuu kube komkenub, burudandewen kii andi ye ebkad barad kankoonenub nub God ewaningko yaambed kubanuub. Yiib kaamoni korem kuu Yarimanbed ee yimin ande awandok. ");
INSERT INTO yon_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Ne nekaad Yarimanbed kinoonman kuu ye bondan yaa nen burudande angka kowimaan, kwane Ewen karadmo arimbed ye kinoonman yaa inandimaan, ye dingki wiwi ye aromkono, nen burudande angka kowi ye aromkono kumbed kui. ");
INSERT INTO yon_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Yena kuu ana nangmidan seriot arimbed dobere nangmimaib kuu nub yaa awandaniib ande meedmimaib, yena kuu ana nangmidan hoos arimbed dibere nangmimaib kuu nub yaa awandaniib ande meedmimaib, kumban nub kuu Yariman nub God kumbed nub yaa awandaneen ande meedmimaub. ");
INSERT INTO yon_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Yi kuu ben kubunaneene kirobaniib, kumban nub kuu yaro dembenub kangdommo dobaranuub. ");
INSERT INTO yon_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","O Yariman, king kuu nen burudande angka kowe! Nub baandubka inande! ");
INSERT INTO yon_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. O Yariman, eb aromkono ye dowad king kuu kuboon. Ebbed awanenewen kowe kubi darewoob keroon! ");
INSERT INTO yon_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Ye niindem aombed komo yaa dowakeniib keroon kuu ebbed ee yimin ande konewen, kwane ye wengbed komo kaamobdoon kuu konewen, ma korondindo. Selah ");
INSERT INTO yon_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Ebbed ye yaa yewudmo amun kerune angkodmeneneb, ye korok ari kuu dereni yeman bod gold yankorenmombed ongmiwen kumbed kan derenenewen. ");
INSERT INTO yon_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Yembed wadkeri dowad kaamobdoone konewen, aron yemooniib, aron korem korem kui. ");
INSERT INTO yon_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Ebbed awanenewen yaambed ye nambiri kuu darewoob keroon, kwane ebbed ye ari dobiri manimanandewiib nambiriyiib bangkanewen. ");
INSERT INTO yon_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Ebbed aron korem ye amun keruni konewen, kwane yeyiib yaa doreeb kowe kubimo doreen. ");
INSERT INTO yon_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Amborom kuu king kuu Yariman yaambed inamen angkumone doreen, kwane Korem Burudandoon Arimbed Ye God ye womoniyiibban ye mimyob dowaken yaambed ye kuu ma kiringmaanban. ");
INSERT INTO yon_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Eb dingkimbed eb bondan korem awingkandaneeb, kwane kane kane eb yaa arud wandembiriwen kuu eb dingki wiwimbed yire awingkandaneeb. ");
INSERT INTO yon_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Eb mananeeb yaron ari kuu yi ben amot nimin darewoowiib denemoon areb kerundaneeb. Yarimanbed norin wandaneen kumbed yi ben yoobkaneene ye amotbed yi dene kubunaneen. ");
INSERT INTO yon_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ebbed yi awoya ben monmaraneewe okad arimbed dowan keraniib, kwane yi yumbon kuu nimakarub kumaom kuu dowan keraneen. ");
INSERT INTO yon_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Yi kuu eb yaa bon keri ye inameniib birandi ye inamen arewayiib ongmiib kumban, yi kuu ma kamindeban keraniib, ");
INSERT INTO yon_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","amborom kuu ebbed yi yaa eb ana baradmaneeb kumbed yi kuu angkurom korokbebde kirokmonaniib kii. ");
INSERT INTO yon_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","O Yariman, ewaromkono yaambed aningko ariyiib kerok. Nub kuu eb aromkono dowad yook wingkenub ewaningko kankoonanuub. ");
INSERT INTO yon_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Yook ambo bi ye karub yeman. “Amkimo Ye Diiya Yingki” ye yook ye kiwaan yaambed wingki yeman. Dewid ye yook. Ne God, ne God, eb kuu komande domowewen? Komande ambab kerewen kumbed dabab ne yaa monoon kuyaa kuu ne nen burudande angka kowaabban? Komande ambab kerewen kumbed wareki kaimain kuu wengambirimokban kerewen? ");
INSERT INTO yon_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","O ne God, aronkimbed eb yaa baandembaraan kumbed ebbed inanduwindo, amnoom kangkon eb yaa baandembaraan, ma iwari kerindo. ");
INSERT INTO yon_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Kuned eb kuu king ye dibirimbon arimbed dibere karadmoman kerewen, kwane ewaningko kuu Israeldanbed kankoonimaib. ");
INSERT INTO yon_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Nub awoya kuu eb yaamo angkumone dobiriwen, kwane angkumone dobiriwen kumbed arud ye barang yaa ben burudande angka nongkobewen. ");
INSERT INTO yon_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Eb yaa baandiwen kumbed arud ye barang yaa ben burudande angka nongkobewen, kwane eb yaamo angkumone dobiriwen kowe ebbed kwananeeb ande meedmiwen kuu anam id keroon. ");
INSERT INTO yon_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Kumban ne kuu karubban wodam, nimakarub korembed kan angka karenib arewa anduwimaib. ");
INSERT INTO yon_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Kane kane ne yaa wedmewimaib yi korem kuu ambonbaawimaib, kwane yi kuu damangkawe yi korok waaburukme yedmimaib, ");
INSERT INTO yon_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Ye kuu Yariman yaambed angkumone doreen kowe, korondubko Yarimanbed arud ye barang yaa nen burudande angka kowok. Ye kuu Yariman yaa kwane kubenoon kowe, korondubko Yarimanbed arud ye barang yaa nen burudande angka kowok.” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Kuned ebbed ne kuu ena yu kabeyob aombed nen angkaderewen, kwane ena yu muk aniin yaa kuu ebbed ne kuu eb yaambed angkumone dobiri yeman ongmewewen. ");
INSERT INTO yon_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Woonaan yirimbed ne kuu eb yaambed yone dobaraan, kwane ena yu kabeyob kumaombed eb kuu ne God kerewen. ");
INSERT INTO yon_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Ne yaa ambab keraab, amborom kuu dabab manandamoon kumban karub maambed ma awawaanban kowe. ");
INSERT INTO yon_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Ne bondan kuu ne yaa awanewandiwen, yi kuu Basan ye buromakau ambi arudiib areb ne yaa kanawanewandiwen. ");
INSERT INTO yon_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Yi kuu laiyonbed dingkan anande kabang angke yaremoon areb, ne yaa yi mongkodkono danduwimaib. ");
INSERT INTO yon_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Naromkono dowan, ok kan ondukne wenebe dowan keremoon areb keraan, kwane ne kono ingkanaboon kuu wadmenaboon. Ne mimyob kuu koronde in areb yawaak keroon, kwane koronde okmo keremoon areb keroon. ");
INSERT INTO yon_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Naromkono kuu dowan, yongkonbon areb keroon, kwane ne ong kuu mongkodkono yaa karangkoon. Ebbed ne kuu bobnok ande okad yiri kowewen. ");
INSERT INTO yon_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Ne bondanbed anon arewa areb ne yaa awanewandiwen, kwane yi kuu arewa kamidan yemoon, ne yaa kanawanewandiwen, kwane yimbed ne dingkia yona kuu kaare dem nabangkenabiwen. ");
INSERT INTO yon_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Ne kono korem kuu nembed kimingki kuu yimin, nimakarub kuu ne yaa nengmowenib ningkirud kamewimaib. ");
INSERT INTO yon_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Yimbed nebkad kande yikareb kuyaom nekwiwen, kwane bot yaa aningkoyiib kuu kirare ebkad mimo karub mimombed kandimo kandimo kamiwen. ");
INSERT INTO yon_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Kumban, o Yariman, eb kuu ne yaa ambab keraab, o ne Aromkonoman, kirod mene awawe. ");
INSERT INTO yon_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Kerewang ye arud yaa ne wadkeri kuu nen angka kowe. Ne wadkeri kuu dowakeniib keraan kowe, ne bondan anon arewa areb yi aromkono yaa kuu ne nen angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Laiyon yi mongkodkono aom kuu ne nen angka kowe. Kwane, oksen kiib yi durub yaa kuu ne nen angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Nembed ewaningko kuu ne ambibkindan yaa daandaniin, kwane ne kuu nedbimaibdan kumaombed ewaningko kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Yariman yaa unimaibdan, yiib kuu ye aningko kankoonime! Yekob yawoya korem, yiib kuu ye yaa nambiri konime! Israeldan korem, yiib kuu ye yaa bumangkime! ");
INSERT INTO yon_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Amborom kuu kane kane durud yewed kandiwen kuu yembed yi yaa ma arewa ande wunekarindo. Ye kuu yi yaa ye murubia kan yeknindo, ma nub yaa awande ande baandiwen ye weng kuu yembed wengamboroon. ");
INSERT INTO yon_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Ebbed ne niindem aom kubi kerunaneewe kadaareb nedbiwen aom ewaningko kankoonaniin. Eb yaa bumangkiwendan yi arinambo arimbed kwananiin ande amob ongmaan ye weng kuu anammo kwane keraniin. ");
INSERT INTO yon_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Kamboknondan kuu ane mikmonaniib. Kane kane Yariman ande onmimaib kuu ye aningko kankoonaniib. Kubi dowaken kuu yiib niindem aom aron korem angkimborok! ");
INSERT INTO yon_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Bid yimin yimin koremdan kuu Yariman yaa ika meene ye yaa amonombaniib. Ambibkin mimim koremdan kuu ye yaa bumangkaniib. ");
INSERT INTO yon_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Ooni yaromkono kuu Yariman yeman, kwane yembed ambibkindan oonendimaan. ");
INSERT INTO yon_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Okad kiri yiribman yemoondan kuu orok anenib ye yaa kurikuri kamaniib, duknaniibdan korem kuu ye yaa bumangkaniib, yika yi wadkeri ma amuknindebandan kui. ");
INSERT INTO yon_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Nimakarub amaan ari dobaraniibdan kuu ye yaambed awine dobaraniib, kwane amaan ari dobaraniibdan yaa kuu Yariman ye dowad dakmaniib. ");
INSERT INTO yon_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Yi kuu ye yorokmo kerekmen ye dowad mokaid woonindodan yaa dakmaniib, yembed kwanoon ye weng dakmaniib. ");
INSERT INTO yon_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Dewid ye yook. Yariman kuu ne nen dorondare oonimaan ye karub kowe, ne yaa komo dowan keroon kuu yembed nekwawimaan. ");
INSERT INTO yon_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Yembed ne nen animan yewudmombon aom kowaana yiidkimain, kwane yembed yewenub ye ok dewenebuun kebed yaa ne nen kinban winimaan. ");
INSERT INTO yon_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Yembed ne kingkin nen ikakman aromnimaan, kwane yorokmo ye kiwaan arimo ne nen kinban winimaan, ye aningko kankooni dowad. ");
INSERT INTO yon_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Kumun doromod bobnin aom wananiin kangkon, eb kuu ne yoom kowe, arewa yaa ma unainban. Eb kungkangiib arud ye barang yaambed dorondandi yemaniib kuu, awawimaib kowe kubimain. ");
INSERT INTO yon_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Eb kuu ne bondan yi kerebiri arimbed ne dowad orok ongmimaab. Ne nen kine ne korok ari kuu oiyo bunewen, kwane ne dobiri yaa kuu yiminmo bangkawimaab. ");
INSERT INTO yon_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Anam kuu eb amun amuniib womoniyiibban ye mimyob dowakeniib kuu ne wad dobiri aom kwane aron korem angkimbaraneen. b Kwane, ne kuu Yariman yambiwoom kwane doberembaraniin, aron korem. ");
INSERT INTO yon_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Dewid ye yook. Okad korem kuu Yariman yeman, okad ari kumkam korem kwangkon. Bid yimin yimin kuu yeman, kane kane okad ari doriib kwangkon. ");
INSERT INTO yon_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Amborom kuu yembed okad yu angkumonimbon kuu karamok niindem yirimbed ongme kowoon, kwane okad yu yumbon kuu ok wedyirimbed ongme kowoon. ");
INSERT INTO yon_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Kanembed Yariman ye aangko ari kawananeen kuu yimin? Kanembed Yariman ye karadkonombon ari dobaraneen kuu yimin? ");
INSERT INTO yon_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Kuye karub kuu ambarakmiyiibban ye dingkiyiib inamen karadmoyiib kumbed kui, kwane ye kuu dudi god yi kuruwak yaa bumangkindo, kwane ye kuu birande amob ongmindo. ");
INSERT INTO yon_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Ye kuu Yarimanbed amun kerunaneen, kwane ye kuu ye nen bobni yaa burudande bindi ye Godbed ongmaneene ambarakmoon ande kadwoniyiibban ye karub keraneen. ");
INSERT INTO yon_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Kwane areb kuu God ye kiwaan ari dobarandamiibdan kukui, o Yekob ye God, eb murubia ari dobarandamiibdan kukui. Selah ");
INSERT INTO yon_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","O kuuk ambongko, yiibka daadmime. O unyeman ye ambongko kui, yiib kuu daadmime. Kwanibko, nambiri ye King kuu mene kumaom aomdorok. ");
INSERT INTO yon_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Nambiri ye King kee kane? Ye kuu Yariman, kanangkodiib aromkonoyiib kui, ye kuu Yariman, ye ana nangmi kuu aromkonomo kui. ");
INSERT INTO yon_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","O kuuk ambongko, yiibka daadmime. O unyeman ye ambongko kui, yiib kuu daadmime. Kwanibko, nambiriyiib ye King kuu mene kumaom aomdorok. ");
INSERT INTO yon_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Nambiriyiib ye King kee, ye kuu kane? Ye kuu Ana Nangmidan Yemoon Ye Yariman, ye kuu nambiriyiib ye King. ");
INSERT INTO yon_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Dewid ye yook. O Yariman, eb yaa ne wadkeri kuu kan kabdaan. ");
INSERT INTO yon_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","O ne God, eb yaambed angkumone doriin. Korondaawa yenambed ne nen karak ari kowaib. Kwane, korondaawa ne bondanbed ne nen burudande doraib. ");
INSERT INTO yon_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Kane kane ebbed kwananeeb ande meedmimaib kuu karak ari ma ben nongkobaabban. Kumban kane kane idiibban kumbed birandimaib kuu karak ari ben nongkobaneeb. ");
INSERT INTO yon_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","O Yariman, eb kiwaan kuu ne korokbewe. Kwane, eb inamen kuu kedmengkawe. ");
INSERT INTO yon_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Eb anam anam yaambed ne nen kinban weneneb kedmengkawe. Amborom kuu eb kuu ne nen bobni yaa burudande bindi ye God kowe. Kwane, amkimombed wene amnoom kuu ebbed kwananeeb ande meedme dobirimain. ");
INSERT INTO yon_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","O Yariman, eb mimyob keende kakman are nonondandiyiib womoniyiibban ye mimyob dowakeniib kuu ika meene. Amborom kuu kuye inamen kuu unyeman anukbed ongmewen kowe. ");
INSERT INTO yon_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Ne kewed yaa komo komo ambarakmaan kuu ika meendobaab, nonondande. Ne wabkad kamaan kwangkon ika meendobaab, nonondande. O Yariman, eb womoniyiibban ye mimyob dowaken yaambed ne yaa ika meendobe. Amborom kuu eb kuu amun yeman kowe. ");
INSERT INTO yon_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yariman kuu amunmo, ye kuu kangdommo. Kwane kowe, yembed ambarakmidan kuu ye kiwaan korokbende kedmengkandimaan. ");
INSERT INTO yon_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Yembed yika kankubune yiri keriwendan yaa yorokmo kerekmen yaambed korokbendene, ye kiwaan kedmengkandimaan. ");
INSERT INTO yon_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Kane kane Yariman ye amowiib wengiib kuu awine kandimaibdan kuyaa kuu, ye kiwaan korem kuu womoniyiibban ye mimyob dowaken yeman, kwane yi kuu ma korondiyiibban no awandi yeman. ");
INSERT INTO yon_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Ne ambarakmi kuu miin darewoob kuned, o Yariman, ewaningko ye dowadbed, ne ambarakmi kuu are nonondande. ");
INSERT INTO yon_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Yariman yaa une bumangkimaibdan, yi kuu kane kane? Yi kuu kedmengkandaneene kiwaan kinoon arimo wananiib. ");
INSERT INTO yon_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Kwane, yi kuu ongmendaneene wad dobaraniib kuu yiminmo dobaraniib. Kwane, okad kinoon kuu yi awoya yiman keraneen. ");
INSERT INTO yon_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Kane kane Yariman yaa une bumangkimaib kuu yembed inamen kan biknoon kumbed yi yaa korokbendaneen, kwane amob weng ongmoon kuu yi yaa korokbendaneen. ");
INSERT INTO yon_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Yarimanbed awawok andi dowad ye yaa kereknembirimain, amborom kuu yembedmo arud yaa ne nen burudandimaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Ne kirimo obonmo angkon dabawiib keraan kowe, ne yaa murubia kaweneb ne yaa mimyob keewe kakman are nonondande. ");
INSERT INTO yon_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Dabab ne niindem aom kuu yemoon keroon, kowe ne meendobimo yiminban keraan kuu obon keruwe. ");
INSERT INTO yon_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Ne dabawiib yiminban keraan kuyiib kuu wedmewe awawe. Kwane, ne ambarakmi korem kuu are kankorare nonondande. ");
INSERT INTO yon_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Ne bondan kuu yemoon keroon kowe, yi yaa wedme. Kwane, yi kuu ne yaa arud miin darewoob wandembirimaib kuyaa wedme. ");
INSERT INTO yon_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Ne wadkeri kuu nen amukne ooneneb yi yaambed ne nen burudande angka kowe. Kwane, korondaawe yenambed ne nen karak ari kowaib, amborom kuu ne kuu ebbed kukbimaabbon aombed dobirimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Ne dobiriyiib inameniib kuu ibmo amunmoyiib angkon ne dobiri kangdommoyiib kumbed ne nen dorondandok, amborom kuu ebbed kwananeeb ande meedme doriin kowe. ");
INSERT INTO yon_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","O God, Israeldan kuu yi dabab kandiwen korem yaambed kuu ebbed ben burudande angka nongkobe. ");
INSERT INTO yon_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Dewid ye yook. O Yariman, ne dowad ebbed wengyundeneb ma ambarakmindo ande, amborom kuu ne kuu ambarakmoon kii ande kadwoniyiibban ye dobiri yaambed dobaraan kowe. Ne kuu kirokkarokiibban Yariman yaambed yone dobaraan. ");
INSERT INTO yon_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","O Yariman, ne inamen andangke. Kwane, ne nen komboon darobewe. Ne dowakeniib inameniib kuu wengyunde. ");
INSERT INTO yon_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Amborom kuu eb womoniyiibban ye mimyob dowaken kuu ne arinambo ari angkeen, kwane ne kuu eb anam anam yaambed yarembirimain. ");
INSERT INTO yon_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Ne kuu birandidan yoom dibirimokban, kwane aadidmidan yoom daboknenwimokban. ");
INSERT INTO yon_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Ne kuu arewa kamimaibdan yi nedbi yaa kuu kangkadmimain, kwane ne kuu arewa kamembirimaibdan yoom dibiri kuu wunekarundimain. ");
INSERT INTO yon_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","O Yariman, ne kuu ambarakmoon kii ande kadwoniyiibban kumbed dingki okeni, eb dowad bod wuube dingkan aye nengke baeb konimbon ye deme awinimain. ");
INSERT INTO yon_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Kwanimain kuu ewaningko kankooni ye weng baandimain, kwane ebbed komo komo kamenabi manimanandeb kuu daandimain. ");
INSERT INTO yon_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","O Yariman, ebbed doreeb yambib kuu dowakeniib kerimain, eb nambirimo derenkoroonbon kui. ");
INSERT INTO yon_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Ne kingkin kuu ambarakmidan yoom ben angkanaab, kwane ne wadkeri kangkon kuman yenbandimaibdan yoom ben angkanaab. ");
INSERT INTO yon_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Yi inamen aom kuu wunonwanon kami miin arewayiib, kwane yi dingki wiwi aom kuu od yemyeb kandene ambarakmindoman yaa ambarakmoon ande yedmi yeman yemooniib kii. ");
INSERT INTO yon_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Kumban ne kuu ambarakmoon kii ande kadwoniyiibban ye kerekmen yaambed doriin, kowe ne nen arud yaa burudande angka koweneb ne yaa mimyob keewe kakman are nonondande. ");
INSERT INTO yon_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Ne yon yiri kuu okad dabonmo arimbed doriin, kwane kadaareb nedbaniib aom kuu Yariman yaningko kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Dewid ye yook. Yariman kuu ne kiwaan ari weniin yaa nambirimaan ye karub, kwane ye kuu ne nen bobni yaa burudande nendi ye karub, kowe kane yaambed ne kuu unaniin? Dowan! Yariman kuu ne wadkeri ye aromne angkumonimbon, kowe kane yaambed ne kuu unaniin? Dowan! ");
INSERT INTO yon_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Arewa kamidanbed ne damburune monmari dowad ne nande kamaniib kuu yimbedmo boknandenib kirobaniib, ne bondaniib ne yaa manmo keriwendaniib kukui. ");
INSERT INTO yon_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Ana nangmidanbed ne kuu kanawanewande kebenaniib kuu ne niindem aom kuu unainban. Kwane, ne yaa ana wandaniib kuned ne kangkon kangdommo dobaraniin. ");
INSERT INTO yon_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Yariman yaa barang mimo kaamonimain, nembed kereknain kuu kei, Yariman yambiwoom kumaombed dibara, ne wad dobaraniin ye aron korem, kwane ne dowaken kuu Yariman ye manimani amun kai yaa wedma, kwane ne dowaken kuu ye kurikuri ambiwoombed ye kiwaan onma. ");
INSERT INTO yon_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Amborom kuu dabab kandi yaron kuu yembed ne nen yambiwoombed dorondandaneen, kwane yembed ye kurikuri ambiwoombed ne nen biknaneen, kwane yembed ne nen aromkonombon ari kowaneen. ");
INSERT INTO yon_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Kwananeen kuu ne korok kuu Godbed nenkoonene bondan kanawanewandiwen yaa kuu ne nen burudande ari kowaneen. Ye kurikuri ambib yaa kuu nembed kube baandeni dingkan aye nengke baeb konaniin, kwane Yariman yaa yook wingkeni yaningko kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","O Yariman, baandako wengambere. Ne yaa mimyob keewe kakman are nonondandeneb inanduwe. ");
INSERT INTO yon_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Ne niindem aom kuu eb dowad yedmoon, “Ye murubia ari dobiri kiwaan onme.” andoon, kowe, o Yariman, eb murubia ari dobiri kiwaan onmiin. ");
INSERT INTO yon_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Eb murubia kuu ne yaa biknewaab. Kwane, eb deme karub ne yaa arud wande korondaab. O God, ne nen bobni yaa burudande bindi ye karub, eb kuu ne awawi ye karub kowe, wunekaruwaab, ne yaa domowe wanaab. ");
INSERT INTO yon_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Nambe ena domowe wananiib kuu Yarimanbed angkodmewaneen. ");
INSERT INTO yon_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","O Yariman, eb kiwaan kedmengkawe. Ne kuu ne nen yiri kubunandamiibdaniib kowe, kiwaan yorokmo arimbed ne nen kinban wene. ");
INSERT INTO yon_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Korondaawa ne bondan yi dingki ari kombarain. Amborom kuu kwane wedmaan kii ande dudi weng dakmidan kuu ne yaa manmo kerenib, ne dowad naniib ande kamiib. ");
INSERT INTO yon_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Ne anam andaan kuu okad ari wad dobaraniin kumbed ne kuu Yariman ye amun amun wedmaniin. ");
INSERT INTO yon_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Yariman yaa meedme dobirime. Aromne arudnime, kwane Yariman yaa meedme dobirime. ");
INSERT INTO yon_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Dewid ye yook. O Yariman, eb yaa baandaan. Ne aromkonombon, eb kuu ne yaa wunekaraab, inanduwe. Amborom kuu inanduwaabban keraneeb kuu ne kuu bobkonodem yiri kubune dangiwendan areb keraniin kowe. ");
INSERT INTO yon_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Ne awawi dowad eb yaa baandaan kuu wengamberewe. Ne dingki kuu eb kurikuri ambiwoom ye Yumbon Miin Karadmo Anam yaa benkoobe baandaan kui. ");
INSERT INTO yon_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Ne kuu ambarakmidan yoom dabokne indore wanaab, arewa kamimaibdan yoom kui. Yi kuu angkodmendi weng yi dia doriibdan yaa dakmimaib kumban, angkara kuu yi niindem aom kuu arud wandembirimaib. ");
INSERT INTO yon_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Yimbed kwanimaib ye dowad man inende. Kwane, yimbed arewa kamimaib ye dowad man inende. Yi dingkimbed komo ambangkiwen kuu kwanemo man inende. Kwane, kakman anam yi yaa man inende. ");
INSERT INTO yon_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Amborom kuu Yarimanbed komo ambangkooniib ye dingkimbed komo ongmenabooniib kuu yi ma meendobindo, kowe yembed yi ben yiri kubunaneen, kwane yembed yi ben ikakman ma ari nongkobaabban. ");
INSERT INTO yon_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Yariman yaa amun kerunem! Amborom kuu ne awawi ye dowad baandaan kuu wengamberewoon kowe. ");
INSERT INTO yon_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Yariman kuu ne aromkono angkon ne kombe. Ne inamen kuu ye yaa yone kowaine yembed awawimaan. Kwane kowe ne niindem aom kuu kubimbed ware kandoon, kwane ne kuu eso andi yookbed wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yariman kuu ye karuwa nimaya yi aromkono, kwane ye kuu yembed kinoon ye karub ye dowad aromne dorondandi ye karub. ");
INSERT INTO yon_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Eb karuwa nimaya kuu ben burudande binde. Ebbed kingkewendan kuu amun kerunde. Yi ben dorondare oone. Yi ben amukne, aron korem. ");
INSERT INTO yon_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Dewid ye yook. Yariman yaningko kankoonime, o engyus yiib kui, Yariman yaningko kankoonime, ye kuu nambiriyiib aromkonoyiib kowe. ");
INSERT INTO yon_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Yariman yaningko kankoonime, ye kamenabi kuu nambiriyiib kowe. Yariman yaa kurikuri kamime, ye karadmo doreen kuu nambiriyiib kowe. ");
INSERT INTO yon_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yariman ye weng yuud kuu ok korem yi animarimbed dewenebimaan. Nambiri ye God kuu nambad kamimaan. Yarimanbed ok miin darewoob animari nambad kamimaan. ");
INSERT INTO yon_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yariman ye weng yuud kuu aromkonoyiib, Yariman ye weng yuud kuu manimanandeb. ");
INSERT INTO yon_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Yariman ye weng yuud kuu at sidaa baangkimaan, anamaa, Yarimanbed Lebanon ye at sidaa domabangkaana kurubkurub kerimaan. ");
INSERT INTO yon_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Yembed Lebanon ye aangko aangko kuu ongmaana buromakau mana areb korongberenandimaib, kwane aangko Heemon kwangkon ongmaana oksen kiib ingkod areb korongberenandimaan. ");
INSERT INTO yon_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yariman ye weng yuud kuu imakiib baandimaan. ");
INSERT INTO yon_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Yariman ye weng yuud kuu amboon kan kiringmimaan, kwane Yarimanbed amboon Kades kwangkon kan kiringmimaan. ");
INSERT INTO yon_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yariman ye weng yuud kuu at ook ben awumbe nidmingkene, dura kwangkon bongme obonmo kerimaan. Kwane, ye kurikuri ambiwoom kuu kumaom doriibdan korembed “Ye yaa nambiriyiib kerok” ande baandimaib. ");
INSERT INTO yon_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Yariman kuu niindem yiri ye ok korem yaa korok kere oonimaan. Yariman kuu king kere oonimaan, aron korem. ");
INSERT INTO yon_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Yarimanbed ye karuwa nimaya yaa aromkono kondimaan, kwane Yarimanbed yi kuu yewenuwiibbed amun amun kerundimaan. ");
INSERT INTO yon_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Dewid ye yook. Kurikuri boyambib darewoob ambongko nande God yaa konande wingki ye yook. O Yariman, ewaningko kankoonaniin, amborom kuu ne kuu niindem yiri kombaraana ebbed nen burudande ari kowewen kowe, ne bondan ne yaa ambon kamewindo. ");
INSERT INTO yon_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O Yariman ne God, nembed eb yaa awawe ande baandaana, ongmeweewe wad dobaraan. ");
INSERT INTO yon_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","O Yariman, ne kuu bobkonombon yirimbed ebbed nen kone dembewen, kwane ne kuu bobni ye dem yiri kombarandamaan kumban ebbed kebene nen kone awinewewen. ");
INSERT INTO yon_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Ye karadmodan, yiib kuu Yariman yaa aningko kankooni yook wingkime, kwane ye aningko karadmo kankoone eso andime. ");
INSERT INTO yon_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Amborom kuu ye arud kuu aron dukmen manambed dowan kerimaan, kwane ye dowaken kuu wooni yaronbed wene bobni kumbed angkimbaraneen. Amnoom kuu ne kuu ameng kamenabe wene amkimo kuned, amkimo kerimaan kuu kubi kanminimaan. ");
INSERT INTO yon_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Nembed yiminmo uniyiibban dobaraan kumbed yedmaan, “Ne kuu kumkam komombed ma kebewaanban.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","O Yariman, eb ne yaa dowaken keewe amun keruwewen kuu, ne kuu aangko areb ma kiringmi yemanban dobiri kangdommo keruwewen. Kumban eb kuu ne yaa koronde wenewen kuu, ne kuu domangke ok wanaan kii. ");
INSERT INTO yon_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","O Yariman, eb yaa baandaan, Yariman yaa ne awawi ye dowad baandaan. ");
INSERT INTO yon_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Ne kuu monmaraneen kuu karub maambed barang maa kandaneen? Dowan. Bobnaniin kangkonoo? Dukniwendanbed ewaningko kankoonaniiwoo? Dowan. Ebbed ma korondiyiibban eweng awine dobirimaab ye weng kuu yimbed dakmaniiwoo? Dowan. ");
INSERT INTO yon_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","O Yariman, wengamberewe mimyob keewe kakman are nonondande. O Yariman, ne awawi ye karub kere. ");
INSERT INTO yon_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Ne yuudi kamiin kee ebbed kande amonombe kube andenabi yeman kerewen, kwane ne yuudi yebkad boronaan kuu ebbed biande kubimbed inwaruwewen. ");
INSERT INTO yon_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Kwanewen kumbed iwari dobiri yaa korondeni ne niindem aombed kubiyiib kere ewaningko kankooni ye yook wingkimain. O Yariman ne God, ne kuu eb yaa eso kamaniin, aron korem. ");
INSERT INTO yon_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. O Yariman, ebbed kukbimaabbon aombed dobirimain, korondaawe ne yaa karak kawaib. Eb yorokmo kerekmen yaambed ne nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Ne yaa eb kerendem kowe wengamberewe. Kirod mene ne nen angka kowe. Ne nen bikneneb aromne angkumoni ye karub kere. Ne nen dorondandi ye karub kere. ");
INSERT INTO yon_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Eb kuu ne aromkonombon, eb kuu ne aromne angkumonimbon kowe, ewaningko kankooni dowad ne nen kinban weneneb eb kiwaan ari kowe. ");
INSERT INTO yon_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Dabab kawi yeman warab areb ongmiwen kuyaa ne nen angka kowe, amborom kuu eb kuu ne yone biknimbon. ");
INSERT INTO yon_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Eb dingki ari kuu ne kingkin kowaan. O Yariman, anam anam ye God, ne bidde. ");
INSERT INTO yon_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Dudi god kuu karub ma awandindeban, kwane yi kuruwak yaa bumangkimaibdan yaa kuu kongendimain, kwane Yariman yaa angkumone doriin. ");
INSERT INTO yon_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Eb womoniyiibban ye mimyob dowaken yaa kuu dowaken kereni kubaniin, amborom kuu durud yewed kandaan kuu wedmeneb, dabab kande miin kubiyiibban keraan kuu ebkaadkerewen kowe. ");
INSERT INTO yon_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Ebbed ne nende bondan yi dingki ari kowindo, ma, ebbed ne nende dewenebimbon aom kowewen. ");
INSERT INTO yon_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","O Yariman, ne niindem aom miin kubiyiibban keraan kowe, ne yaa mimyob keewe. Kedi, ne indob kuu mimyob kowi ye amengbed wuud keroon, kwane ne idiib kingkiniib kuu mimyob wandoon. ");
INSERT INTO yon_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Ne wad dobaraan kuu miin kubiyiibbaniib kumbedmo, kwane ne weeb korem kuu wareki kamembirimain. Dabab ne yaa meneboon kowe naromkono dowan keroon, kwane ne kono kuu wuud kere wonoon. ");
INSERT INTO yon_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Ne kuu bondan yemooniib kowe nimakarub kuu ne dowad miin arewa ande ambodiibban keruwiwen, ne dia doriibdan kuu kuye inamen burudande ne yaa odkeneb anam keriwen. Nangkodmia kuu uni darewoob keruwiwen, kwane kane kane kiwaan arimbed wedmewimaib kuu kirokmone winimaib. ");
INSERT INTO yon_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Ne kuu yimbed bobnoon ande nonondanduwimaib, kwane ne kuu nongdomatom areb keraan. ");
INSERT INTO yon_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Wengambaraan kuu ne dowad nimakarub yemoon koraaweng weng dakmimaib, “Ye kuu uniwon karakwon kumbed kanawanewandoon.” andimaib. Ne bondan kuu ne dowad wunonwanon kamiib, kwane yi kuu ne dowad nuubnaan kamiib kii. ");
INSERT INTO yon_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Kumban, o Yariman, ne kuu eb yaambed yone doriin, kwane “Eb kuu ne God.” ande yedmimain. ");
INSERT INTO yon_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Ne dobiri yaron kuu ebbed kinewen, kowe ebbed ne bondan yaambed ne nen burudande angka kowe, ne nenbandande kerewenmo yarimaibdan kui. ");
INSERT INTO yon_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Eb nambiri kuu eb deme karub ne yaa yure. Eb womoniyiibban ye mimyob dowaken yaambed ne nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","O Yariman, eb yaa baandimain kowe, korondaawe ne yaa karak kawaib. Kumban arewa kamimaibdan kuu karak kandime, kwane bobkonombon yiri iwarimo dangime. ");
INSERT INTO yon_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Yi dudanabi weng kuu kebende, amborom kuu yimbed kerengkan wengiib nubkob andi ye wengiib yorokmodan ben kubune manmo kere dakmimaib kowe. ");
INSERT INTO yon_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Eb amun amun kami kuu darewoob. Kuye inamen kuu kane kane eb yaa une bumangkimaib yi dowad kan kowimaab. Kuye inamen kuu ebbed nimakarub yi indob arimbed kane kane ebbed kukbimaabbon aombed doriibdan yi dowad kan kowimaab. ");
INSERT INTO yon_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Ebbed kukbimaabbon aombed doriibdan kuu nimakarub yi wunonwanon kamiib yaambed ben eb kerebiri ari nongkobe oonimaab. Ebbed kukbimaabbon aombed doriibdan kuu kadwoni weng yaambed ben eb oonimbon aom nongkobe oonimaab. ");
INSERT INTO yon_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Yariman yaningko kankoonem, amborom kuu ne kuu bondanbed kanawanewandiwen ye siti aom dobaraan kumbed yembed ye womoniyiibban ye mimyob dowaken korokbewoone kukuu yeka mamaa andaan. ");
INSERT INTO yon_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Ne unimbon aombed yedmaan, “Eb indob arimbed kuu ne kuu kan angka karewen kii.” andaan. Kuned eb yaa baandaan kuu wengamberewen, eb yaa awawe ande baandaan kui. ");
INSERT INTO yon_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Yembed yorokmo kerundoondan, yiib korem kuu Yariman yaa mimyob dowaken keenime! Korondiyiibban anam ande doriibdan kuu Yarimanbed dorondare awandimaan, kumban kerengkan kamiibdan kuu yembed kumundinmo ine dabab kondimaan. ");
INSERT INTO yon_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Kane kane Yariman ye dowad yembed kwananeen ande meedmiibdan, yiib korem kuu aromkono kerenib arudkono awinime. ");
INSERT INTO yon_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Dewid ye yook. Maskil ye yook. Kane kane yi wabkad kami yaa are nonondandoon kuu yi kuu amun kerundoon, kane kane yi ambarakmi kuu are nonondandoon kangkon. ");
INSERT INTO yon_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Kane kane yaa Yarimanbed arewadan ande yedmindo kuu amun kerundoon, kane kane yi niindem aom kuu dudanabiyiibban kui. ");
INSERT INTO yon_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Ne ambarakmi dakmokban keraan kuu amkimombed wene amnoom kuu wareki kamembirimain kumbed wuudne aromkonoyiibban keraan. ");
INSERT INTO yon_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Amborom kuu awingyawiib amnoomiib kuu eb dingkimbed ne arewa kami naawonmo didangkawembirimaab, kowe ne aromkono kuu dowan keroon, am kaine niminmo kere mongkobon nuubnemoon areb keroon kui.Selah ");
INSERT INTO yon_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Kwanoona ne kuu ne ambarakmi ben eb yaa dakmaan, ne arewa kami kuu eb yaa ben bikderebindo kui. Neka nemeren yedmaan, “Ne wabkad kami kuu Yariman yaa dakmaniin.” andaan. Kwane ebbed ne ambarakmi are nonondandeewe ne ambarakmi dowad ne meendobi arewa kuu dowan keroon.Selah ");
INSERT INTO yon_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Kwani kowe, kane kane eb kerekmen ye kiwaan ari doriib kuu aroniib keroka yi korem eb yaa kurikuri kerime. Anam kuu kwananiib kuu urok areb dabab yemoon menebaneen kuu kubunokban keraniib. ");
INSERT INTO yon_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Eb kuu ne biknimbon, dabab menebaneen kuu ebbed ne nen burudande angka koweneb, burudande bindi ye yook yemoon kai bangkawaneeb.Selah ");
INSERT INTO yon_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Yarimanbed yedmoon, “Nembed eb dobiri dowad kiwaan amun korokbebdeni kedmengkabdaniin, kwane nembed ongkabde oonebdaniin kii. ");
INSERT INTO yon_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Hoos o donki yi inamen areb keraib, yi kuu inameniibban kowe. Kwane yi kuu korok ari abakiib mongkod aom buniib nong kuyiib kuyaambed awine nenwini kumbed yimin, kwanaabban kuu ewiib yaa manaibban.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Arewa kamidan yaa kuu kubiyiibban yemoon menebimaan, kumban kane kane Yariman yaambed yone doriib kuu ye womoniyiibban ye mimyob dowaken kumbed yi yaa kanawanewandimaan. ");
INSERT INTO yon_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Yorokmodan, yiib kuu Yariman yaa dowaken kere kubime! Kwane, niindem aom kangdommo doriibdan, yiib kuu ye yaa kube baandime! ");
INSERT INTO yon_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Yorokmodan, Yariman yaa kubimbed wingkime, kangdommo doriibdanbed ye aningko kankooni kuu yimin kowe. ");
INSERT INTO yon_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Yariman yaa aab wangke ye aningko kankoonime, kwane ye yaa nong angko angkoyiib ye laiya wangke wingkime. ");
INSERT INTO yon_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Yook yewewiib ye yaa wingkime, mengmeng kaadkeriyiibbed wangkime, kwane kube baandime. ");
INSERT INTO yon_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Komoyiibkob, Yariman ye weng kuu yorokmo angkon anammo, kwane yembed komo komo kamandameen kuu korondiyiibban kwane kuyaamo awinaneen. ");
INSERT INTO yon_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Yariman kuu yorokmo dobiriyiib wengyundi anammoyiib yaa dowaken darewoob keroon, kwane ye womoniyiibban ye mimyob dowaken kuu okad yimin yimin yaa derendaroon. ");
INSERT INTO yon_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Yariman kuu wengmo no dakmoon kuyaambed Eweniib ambidiib kuu kwane keroon, kwane yembed inum naroona mindongiib wood awene kuyiib kuu dange wonoon. ");
INSERT INTO yon_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Yembed karamok be wenorimaan, kwane yembed karamok niindem yiri kuu be yi dangimbon aom nongkobimaan. ");
INSERT INTO yon_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Okad kumundin aom nimakarub korem kuu Yariman yaa unime, kwane okad yiridan korem kuu ye yaa bumangkime. ");
INSERT INTO yon_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Amborom kuu ye kuu wengmo yedmoona okad kuu andoween, kwane yembed kwanok ande yedmoona kangdommo kereen. ");
INSERT INTO yon_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Okaddan yi inamen nekwimaib kuu Yarimanbed kebenendimaan, kwane yi inamen nekwi kiwaan kuu yembed monmarimaan. ");
INSERT INTO yon_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Kumban Yariman ye inamen ongmoon kuu kamkonomo angkimbaraneen, aron korem. Ye dowaken yaambed inamen ongmoon kuu nimakarub yimin andowoon yiri dobiriwen yaronbed wene yimin wandi yaron kuu angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Ambibkindan kaneya yi God kuu Yariman keriwen kuu amun kerundoon, yi kuu yembed kinene yeka ye dowad yumbon ongmoon kui. ");
INSERT INTO yon_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Yariman kuu Ewen arimbed yiri keendombere, nimakarub korem wedmendimaan. ");
INSERT INTO yon_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Ye dibirimbon arimbed kerendombirimaan, okad yiri doriibdan korem yaa. ");
INSERT INTO yon_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Yi korem meendobi niindem aom ongmoonman, yembed yi kamenabi korem kuu darobe yekaadkerundimaan kui. ");
INSERT INTO yon_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","King kane kuu ye ana nangmidan yemoon kumbed bobni yaa ma nen burudande angka kowaibban, kwane kanangkod kere ana nangmimaan ye karub kuu ye aromkono darewoob kumbed bobni yaa burudande kombiri wanaanban. ");
INSERT INTO yon_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Hoos nandaneen kwangkon bobni yaa burudande kombiri wanaanban, kwane hoos kuu aromkono darewoowiib kumban kuye aromkono kumbed bobni yaa ma burudande kombiri wanaanban. ");
INSERT INTO yon_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Kumban kane kane yi kuu Yariman yaa une bumangkimaib kuu, yembed yi yaa oone kerendombirimaan, kwane kane kane God ye womoniyiibban ye mimyob dowakenbed awawaneen ande meedmimaib kuu yembed yi kuyaa oone kerendombirimaan. ");
INSERT INTO yon_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Kwanimaan kuu bobni yaa burudande binda anded, kwane am kainoona animaniibban keri yaa awanda anded kui. ");
INSERT INTO yon_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Nub kuu Yariman ye dowad yembed kwananeen ande meedmo doruub, ye kuu nub awandi ye karub, ye kuu kombe areb nub dorondandi ye karub kowe. ");
INSERT INTO yon_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Kedi, nub kuu ye yaambed kubi darewoob kerimaub, komoyiibkob, nub kuu ye aningko karadmo yaambed yone doruub kowe. ");
INSERT INTO yon_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","O Yariman, eb womoniyiibban ye mimyob dowaken kumbed nub yaa angkimborok, nub kuu ebbed kwananeeb ande meedmo doruub kuyaambed kwanok. ");
INSERT INTO yon_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Dewid ye yook. Abimelek ya arinambo ari warudki areb iraroona Abimelekbed nen kowoona wonoon kumbed wongkoon. Ne kuu aron korem Yariman yaa amun kerunimamaniin, kwane ye aningko kankooni weng kuu korondiyiibban dakmembaraniin. ");
INSERT INTO yon_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Ne kingkiniib kumbed Yarimanbed komo komo kamenaboon ye weng yaa kerengkan kamaniin, kwane kane kane yenambed ben kubuniwendan kuu wengamberekorib kubaniib. ");
INSERT INTO yon_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Yiib kuu minibko Yariman ye yirin darewoob dakmendem, kwane ye aningko kuu nub ibonmo kankoonem. ");
INSERT INTO yon_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Ne kuu Yariman yaa awawe ande kurikuri keraana inanduwoon, kwane nembed unimain korem yaa kuu ne nen obon keruwoon. ");
INSERT INTO yon_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Kane kane ye yaambed yone dobiriwen kuu kubembiriwen, kwane karak ye kubun kumbed yi murubia ma kebenaanban dowan. ");
INSERT INTO yon_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Ne durud yewed aombed Yariman yaa baandaana wengamberewoon, kwane dabab ne yaa meneboon korem yaa kuu yembed nen obon keruwoon. ");
INSERT INTO yon_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Yariman yaa une bumangkimaibdan kuu ye engyumbed dorondandimaan, kwane kuye engyumbed yi ben burudande angka nongkobimaan. ");
INSERT INTO yon_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Yariman ye inamen ye ambod kande wedme amun kai kii andime. Kane kane yembed kukbimaanbon aombed dobaraniib kuu amun kerundaneen. ");
INSERT INTO yon_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Yarimanbed karadmo kerundoondan, yiib kuu ye yaa une bumangkime, amborom kuu ye yaa une bumangkidan kuu yi yaa kuu ma dowan keraanban. ");
INSERT INTO yon_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Laiyon ingkod kuu animaniibban keraniib kuu mungimo wuud keraniib kumban, Yariman yaa awande ande kurikuri keridan kuu amunmo dobaraniib. ");
INSERT INTO yon_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Ne danaya, mene ne yaa wengambirime, kwanibko nembed Yariman yaa une bumangki ye kiwaan kedmengkanda. ");
INSERT INTO yon_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Yiib kane kane wad dobiri yaa dowakeniib kerenib aronki yemoon amunmo dobarandamibka, ");
INSERT INTO yon_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","yiib kuu weng arewa dakmi yaa kuu kangkadmenib dudanabi weng yiib mongkodem aombed dembi kuu kebenenib ");
INSERT INTO yon_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","kami arewa yaa amonombenib amun amun kamenabenib yena yoom yewenubmo dobiri kerekmen yaambed doberenib kuyaa meeni darewoob kerime. ");
INSERT INTO yon_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Yariman ye indob kuu yorokmo kame doriibdan yaa kerenombirimaan, yi awandi dowad, kwane ye kerendem kuu yi baandi yaa nandimaan. ");
INSERT INTO yon_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Arewa kamidan yaa kuu Yariman ye murubia kande yangmad kerimaan, kwane yi aningko araneene yenambed yi yaa ma meenaibban. ");
INSERT INTO yon_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Yorokmodan kuu baandaiwe Yarimanbed wengambirimaan, kwane yi yaa dabab menebaane yembed ben burudande obon kerundimaan. ");
INSERT INTO yon_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Mimyob wandi miin yiminban kerimaibdan kuu Yarimanbed yi dia mene dobirimaan, kwane kane kane yenambed ben kubune inamen korem monmarimaibdan kuu yembed ben burudande obon kerundimaan. ");
INSERT INTO yon_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Yorokmoman kuu dabab yemoon menebimaan, kumban Yarimanbed kuye dabab korem yaambed ye nen burudande obon kerunimaan. ");
INSERT INTO yon_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Ye kono korem kuu oonimaan, ma domokbaanban. ");
INSERT INTO yon_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Arewa kamidan kuu arewambed monmaraneene duknaniib, kwane yorokmodan yi bondan kuu wengyunde ukum kondaneen. ");
INSERT INTO yon_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Kumban Yariman kuu ye demedan biddimaan, kwane kane kane yembed kukbimaanbon aombed dobaraniib kuu yembed wengyunde ukum kondaanban. ");
INSERT INTO yon_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Dewid ye yook. O Yariman, kaneya yi kuu ne yaa manmo kerimaib kuyaa kuu ebbed yi yaa manmo kerunde. Kwane, kaneya ne yaa nangmiwen kuyaa kuu ebbed yi yaa nangmende. ");
INSERT INTO yon_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Eb kombeyiib kiyamiib be nekwe. Kwane nekwekoreb yaro dembeneb awawi dowad mene. ");
INSERT INTO yon_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Eb maradiib ana nangmi ye daayiib benkoobe, ne nenbandande kerewenmo yarimaibdan yaa. Yedmewebka niindem aom anam anda, “Ne kuu eb nen bobni yaa burudande bindi ye God” ande yedmewe. ");
INSERT INTO yon_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Ne nenbande kowande kamiibdan kuu yi aningko kankubunebko karak kandime. Ne yaa wunonwanon kamiibdan kuu ben angkurom kondebko karak ye kubun aom dobirime. ");
INSERT INTO yon_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Yi kuu norok kab areb nuubbed awune kanwinimaan areb kwane kerok, kukuu Yariman ye engyumbed wangmenmo wonok. ");
INSERT INTO yon_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Yi wini ye kiwaan kuu kumun kere kerebbonmo kerok, kukuu Yariman ye engyumbed yenbandande kerewenmo yarok. ");
INSERT INTO yon_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Ne kuu yi yaa ma abdon kamindo kumban yi kuu ne dowad kawaad nong kowiwen, kwane ne kuu yi yaa ma abdon kamindo kumban yi kuu ne dowad dem nidke awod kebengkiwen. ");
INSERT INTO yon_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Kudmeniibban ye monmarimbed yi yaa mene kebendok, kwane yika yi kawaad nong kowiwen kumbed awinde bedmendok, kwane yika dem ongmiwen kuri kirobime, yi monmari dowad. ");
INSERT INTO yon_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Kwananeen kuu ne kingkin aom Yariman yaa kubeni, yembed yi yaambed ne nen burudande angka kowaneen yaa dowakeniib keraniin. ");
INSERT INTO yon_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Ne inamen korem kumbed baandaniin, “O Yariman, kanembed eb yaa iibmo keroon? Dowan! Kamboknondan kuu aromkonodanbed yenbandimaib kuu ebbed yi ben burudande angka nongkobimaab, kwane kamboknondaniib awandime ande meeniibdaniib kuu yidbidan mene yi yiribman bimaib kuu ebbed yi ben burudande angka nongkobimaab. ");
INSERT INTO yon_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Mimyob keendiyiibban kangdod aom dudanabimaibdan menenib kumkam ne ma kaadkerindo ye dowad ne yaa kaamowimaib. ");
INSERT INTO yon_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Ne amun kamaan ye dowad kuu yimbed arewambed inanduwenib, ne nen kubunaiwe ne niindem aom yiminban kerimain. ");
INSERT INTO yon_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Kuned yi kuu anikad kandimaib kuu mimyob wandi ye ebkad boroneni, animan koronde neka kankubuneni, kurikuri kamimain kumban Godbed ma inandimokban. ");
INSERT INTO yon_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Ne angkodmi maa o ne daman maa anikadiib areb yi dowad yuudemoon areb kerimain, kwane awaan bobnaune yuudemoon areb yi dowad ne korok wan yiri kubune yuudi ameng kamimain. ");
INSERT INTO yon_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Kumban ne yaa dabab meneboon kuu yi kuu kube nedbiwen, kwane nenbandidan kuu ne koron kumbed nedbe ne yaa manmo keriwen. Yi kuu womoniyiibban ne yaa wengamborokbanabimaib. ");
INSERT INTO yon_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Yi kuu God ye kiwaan yikaadbandan areb arewa keruwe damangkawenib, ne yaa ningkambo kabang kamenib arud darewoob wandiwen. ");
INSERT INTO yon_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","O Yariman, aron komoyiib awawokban kere no keewombaraneeb? Yi monmari yaambed ne wadkeri nen burudande angka kowe. Laiyon areb keriwendan keyaambed ne nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Kee kwananeeb kuu kadaareb nedbiwen aombed eb yaa eso andaniin, kwane kadaareb yemoon aombed ewaningko kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Korondaawa ne yaa idiibban bon keriwendanbed ambon kamewaib. Kwane korondaawa ne yaa ogoodmo arud wandiwendanbed dabab ne yaa meneboon ye dowad kubaib. ");
INSERT INTO yon_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Yi kuu yewenub ye dowad ma dakmimokban, kwane yi kuu dudi ye kadwoni weng ongmimaib, kane kane nuwokad aombed iwarimo doberem ande doriib yaa. ");
INSERT INTO yon_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Ne bondan kembed ne yaa baande yedmimaib, “Ai, ai, kee kamune kamoon kuu nuwindobbed wedmenuwen kii!” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","O Yariman, korem kuyiib kuu wedmewen kowe iwari keraab. O Yariman, eb kuu kwamune ne yaa ambab keraab. ");
INSERT INTO yon_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Yaro dembe. ne angkumone kebeni dowad yaro mene! Ne God, ne Yariman, ne dowad koromoni weng nekwe! ");
INSERT INTO yon_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","O Yariman ne God, eb yorokmo kerekmen yaambed ne dowad wengyunde ambarakmindo ande. Kwane korondaawa ne bondanbed ambon kamewaib. ");
INSERT INTO yon_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Korondaawa yi kekamune meenaib, “Ai, nub dowaken keruwen kuu kanduwen kii!” andaib. Kwane korondaawa yi kekamune ne dowad yedmaib, “Nubbed ye monmaruwen dowan!” andaib. ");
INSERT INTO yon_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Kane kane ne dabab kandaan yaa kubaniib kuu yi korem ben karak kondoko kerebkarab kamime. Kwane, kane kanembed ne nen yiri kubune yika yi aningko kankoonaniib kuu yi dobiri aom kuu karakiib derendaroko kubuniibban ye aningko kandok. ");
INSERT INTO yon_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Kumban kane kane Godbed ne dowad wengyunde ambarakmindo andoon yaa kubaniib kuu dowakeniib kere kube baandime. Yi kuu kekamune yedmimamime, “Yariman yaningko arimbed kerok, yembed ye dememan amunmo dobirimaan kuyaa kubimaan kii.” andimamime. ");
INSERT INTO yon_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Eb inamen yorokmo kuu dakmendaniin, kwane amkimombed wene amnoom kuu ewaningko kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Yook ambo bi ye karub yeman. Yariman ye dememan Dewidbed wongkoon. God yaambed weng kuu ne niindem aom meneboon, arewa kamidan yi ambarakmenabi ye dowad, kedi yi inamen aom kuu God yaa unimokban. ");
INSERT INTO yon_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Amborom kuu ambarakmimbed “Eb kuu karub amun.” andaane yeka ye indob arimbed kerengkan kamimaan kowe, ye ambarakmi ma wedmindo, kuyaa kongenindo. ");
INSERT INTO yon_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Ye mongkodkonombed dakmimaan ye weng kuu yena yaa bon kerundi ye weng angkon dudanabi weng, kwane ye kuu inamen kangdomiib kami amuniib yaa korondoon dowan. ");
INSERT INTO yon_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Ye angkimbon arak ari angkimaan kwangkon yena yaa bon kerundi ye inamen kowimaan, kwane “Arewa kami ye kiwaan ari dobara.” ande kwanimaan, kwane ye kuu inamen arewa yaa kangkadmimokban. ");
INSERT INTO yon_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","O Yariman, eb womoniyiibban ye mimyob dowaken ye ambab kuu daane ewen ari nandoon, kwane eb ma korondiyiibban eweng awini ye ambab kuu daane ambid ari nandoon. ");
INSERT INTO yon_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Eb yorokmo kerekmen kuu aromkono darewoob ye aangko areb, kwane eb wengyundi kuu karamok ye niindem ambab yiri areb. O Yariman, nimakaruwiib dingkaniib oonendimaab. ");
INSERT INTO yon_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","O God, eb womoniyiibban ye mimyob dowaken kuu miin manimanandeb anam! Nimakarub kuu eb buraab ye kubun kurumbon areb ebbed kukbimaabbon aombed doriib. ");
INSERT INTO yon_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Yi kuu ewambiwoom animan yiminmo kumbed orok animaib, kwane ebbed yi yaa kubembirimaab ye ok awaan yaambed ok kondimaab. ");
INSERT INTO yon_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Amborom kuu eb yaambed wadkeri ye ambokab ye ok meneboon, kwane eb nambiri yuroon kumbed wad dobere wedmuub. ");
INSERT INTO yon_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Eb womoniyiibban ye mimyob dowaken kuu kane kane eb yaa yikaadkeriwendan kuyaa kwane kondembere. Kwane eb inamen yorokmo kuu kane kane niindem aom kangdommo doriibdan kuyaa bangkandembere. ");
INSERT INTO yon_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Kerengkandan kuu ne yaa mene bon keruwaib, kwane arewa kamidan kuu ne yaa nangmaiwe kombiri wanain. ");
INSERT INTO yon_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Wedmime, arewa kamidan kuu yiri kirobe dangiwen, yi kuu ben yiri kiraroone ika dembindeban keriwen. ");
INSERT INTO yon_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Dewid ye yook. Arewa kamidan yaa meendobembaraib, kwane ambarakmidan yi dobiri amun yaa wungkandaib. ");
INSERT INTO yon_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Amborom kuu yi kuu kereekbed aron doboobban nuubne koknemoon areb kerimaib, kwane yi kuu arub koknimaan areb aron doboobban ari duknaniib kowe. ");
INSERT INTO yon_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Yariman yaa angkumone doberenib amun amun kamenabime, kwane okad kirikee doberenib korondiyiibban ye weng awinime. ");
INSERT INTO yon_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Yiibkareb Yariman yaambed kubenime, kwananiib kuu yembed yiib niindem aom meenmiib yeman kuu kondaneen. ");
INSERT INTO yon_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Yiib wad dobiri kerekmen kumundin kuu Yariman yaa konime, kwane ye yaambed yone dobirime. Kwananiib kuu yiib yaa awandaneen. ");
INSERT INTO yon_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Yembed yiib yorokmo kerekmen kuu ben ongmaneene warewini ye namberemoon areb keraniib, kwane yiib kangdod weng anam kuu kan ongmaneene aronkob yaa yuremoon areb keraneen. ");
INSERT INTO yon_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Yariman yarinambo ari kuu iwari kerenib yembed kwananeen ande yodbirimban ema meedmime, kwane kane kane arewa kamaniib kuu yimin keraneen kuyaa meendobembaraib, yimbed inamen arewa ongmenib kwane ambangkaniib kuyaa kui. ");
INSERT INTO yon_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Norina aruda yaa kuu deerewandekorib amonombime, kwane meendobembaraib, meendobembaraniib kumbed arewa kamaniib kowe. ");
INSERT INTO yon_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Amborom kuu arewa kamidan kuu yi yumbon yaambed nadme ben kiradmaneen kumban, kane kane Yarimanbed ari kwananeen ande meedmaniib kuu okad kuyaom yumbon kandaniib. ");
INSERT INTO yon_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Aron dukmenmo arimbed arewa kamidan kuu ma dobaraibban dowan, kwane yiib kuu yi ande onmaniib kumban yi kuu ma wedmaibban. ");
INSERT INTO yon_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Kumban yika kankubuniwendan kuu okad kuyaom yumbon kandenib yewenubmo kube dobaraniib. ");
INSERT INTO yon_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Arewa kamidan kuu yorokmodan yaa wunonwanon kamenib, arud wande ningkambo kabang kamendimaib. ");
INSERT INTO yon_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Kumban Yarimanbed arewa kamidan yaa ambon kamendimaan, amborom kuu ye yekaad yi ben wengyundi yaron kuu menuun kowe. ");
INSERT INTO yon_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Arewa kamidan kuu yi kerewang ben biangkenib anangkab be angkokbimaib kuu, kamboknondaniib awandime ande meeniibdaniib yaa ben kubudiri dowad, kwane kangdommo doriibdan yenbandi dowad kui. ");
INSERT INTO yon_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Kumban yikareb yi kerewangbed yi mimyob yaa dem nabangkaniib, kwane yi anangkab kuu domabangkaniib. ");
INSERT INTO yon_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Yorokmodanbed amunmo dobere yiribman yemoonban bemoon areb yiribman yemoonban be dobaraneeb kuu amun, arewa kamidan yemoonbed birande yiribman yemoon bemoon areb yiribman yemoon kai be dobaraneeb arebban. ");
INSERT INTO yon_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Amborom kuu arewa kamidan yi aromkono kuu monmaraneen, kumban Yarimanbed yorokmodan yaa angkumone awandimaan. ");
INSERT INTO yon_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Yariman kuu ambarakmiwen kii ande kadwondiyiibbandan yi weeb kuu yekaadkeroon, kwane yi yumbon kandiwen kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Monmare arewa keri yaron ari keranuun kuu yi kuu karak kandaibban, yongkonbi kere animaniibban aron keranuun kuned yi kuu animan yemooniib keraniib. ");
INSERT INTO yon_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Kumban arewa kamidan kuu monmaraneene duknaniib, kwane Yariman ye bondan kuu at wuung nong wuung areb, erebnarimban dowan keraniib, amareng areb are wene kirodmo dowan keraniib. ");
INSERT INTO yon_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Arewa kamidan kuu araben kandimaib kuu angkon ika inendimokban, kumban yorokmodan kuu nindorokiibbed kondimaib. ");
INSERT INTO yon_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Kane kane Yarimanbed amun kerundaneen kuu okad kumaom yumbon kandaniib, kumban kane kane yembed butun kerundaneen kuu yumbon kuyaambed nadme ben kiradmaneen. ");
INSERT INTO yon_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Kwane Yarimanbed karub maa ye dobiri kerekmen yaa amun ande dowakeniib keraneen kuu, ye yon dodki kuu kangdommo kerunaneen. ");
INSERT INTO yon_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Kuye karub kuu boknandaneen kuu kombaraanban, amborom kuu Yarimanbed ye dingki yaa awinene ongmaneene kangdommo dobaraneen kowe. ");
INSERT INTO yon_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Anuk kuu ne kuu kewedman kere kibikee ne kuu kiomnaan, kuned ne kuu ma wedmaane yorokmodan kuu korem domondindo, kwane ma wedmaane yi danambed animaniibban keroona ma kaamobenmo yarindo. ");
INSERT INTO yon_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Yorokmodan kuu aron mimim nindorokiibbed munob bangkandenib araben kondimaib, kwane yi dana kuu amun kerundi yeman. ");
INSERT INTO yon_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Arewa yaa koronde amonombe amun kamime, kwananiib kumbed okad kuyaom kuu aron korem dobaraniib. ");
INSERT INTO yon_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Amborom kuu Yariman kuu wengyundi anam yaa dowakeniib kerunoon, kwane kane kane ye yaa korondiyiibban ye weng awine doriibdan kuu yembed ma domondaanban. Yi kuu aron korem dorondandaneen, kumban arewadan yi dana meed kuu yumbon kuyaambed nadme ben kiradmaneen. ");
INSERT INTO yon_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Yorokmodan kuu okad kuyaom yumbon kandenib kuyaom aron korem dobaraniib. ");
INSERT INTO yon_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Yorokmoman ye weng dakmimaan kuu inamen kangdommo, kwane ye weng kuu wengyundi anam yaambed dakmimaan. ");
INSERT INTO yon_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Ye God ye amob kuu ye niindem aom kowe, ye yon kuu kereeb beresare kombirimokban. ");
INSERT INTO yon_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Arewa kamidan kuu yorokmodan yi dowad biknimbon aombed yemyeb dibere meedmimaib, yi wadkeri monmari dowad. ");
INSERT INTO yon_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Kumban Yariman kuu yorokmodan domondaane bondan yi aromkono aom awunaibban, kwane ye kuu yorokmodan domondaane bondanbed kangdod aombed wengyunde ukum kondaibban. ");
INSERT INTO yon_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Yariman yaa meedmenib ye kiwaan yaambed winime. Yembed yiib aningko kankoonaneene okad kuyaom yumbon kandaniib, kwane arewa kamidan kuu yi yumbon yaambed nadme ben kiradmaneen kuu yiibka wedmaniib. ");
INSERT INTO yon_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Ne kuu wedmaane mimyob keendiyiibban kere arewa kamenabi ye karub kuu at yeeb kumbed ye okad anam yirimbed kirod kaine yiminmo amnemoon areb kamoon. ");
INSERT INTO yon_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Kumban aron doboobban arimbed bobnoon kuu korem dowan keroon. Ne kuu ye ande onmaan kumban ye kuu ma wedmenindo. ");
INSERT INTO yon_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Ambarakmiwen kii ande kadwondiyiibban yimo doriibdan yi dobiri yaa kuu ongme meene wedmendime, kwane kangdommo doriibdan yi dobiri yaa andangke meene wedmime. Amborom kuu kane kanembed yewenubmo dobiri ye kiwaan arimbed doriib kuu ari danayayiib awoyayiib keraniib. ");
INSERT INTO yon_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Kumban ambarakmidan korem kuu monmaraneen, kwane arewa kamidan yi danaya awoya kuu yi yumbon yaambed nadme ben kiradmaneen. ");
INSERT INTO yon_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Yorokmodan ben bobni yaa burudande bindi ye kiwaan kuu Yarimanbed ongmoon, yi yaa dabab minimaan kuu yembed awande dukmondimaan. ");
INSERT INTO yon_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Yarimanbed yorokmodan kuu awandene arud ye barang yaambed ben angka nongkobimaan, kwane yembed arewa kamidan yaambed dorondandene yi ben angka nongkobimaan, amborom kuu yi kuu yembed kukbimaanbon aombed dobirimaib kowe. ");
INSERT INTO yon_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Dewid ye yook. Kaamoni yeman. O Yariman, eb norin wande ongkawaab, kwane eb arud wande ne yaa didangkewaab. ");
INSERT INTO yon_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Amborom kuu eb ana kumbed ne yaa nabangkoon, kwane eb dingki kumbed ne nen kubunewen. ");
INSERT INTO yon_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Ebbed ne yaa norin wandewen kowe ne id kuu yiminban keroon, kwane ne niindem aom kuu korem amuniibban keroon, ne ambarakmaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Ne ambarakmimbed ne nen dabuknandoon, kukuu dabab darewoob kanyarindeban kwane areb keroon. ");
INSERT INTO yon_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Ne yaa kad yaa bobbob kuu yingkenabe miin arewa keroon, amborom kuu inameniibban kamaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Ne kuu nikbe kan kubune yiminban keraan, kwane amkimombed wene amnoom kuu yuudi ameng kame yarebimain. ");
INSERT INTO yon_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Ne id kuu yewed ye niminbed naawonmo denobembirimaan, kwane ne niindem aom kuu korem amuniibban keroon. ");
INSERT INTO yon_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Ne kuu meenindeban kereni yob beengkemoon areb keraan, kwane niindem aom miin yiminban kereni wareki kamimain. ");
INSERT INTO yon_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","O Yariman, nembed komo komo kamandamiin ye inamen korem kuu eb arinambo ari dianmo dangoon, kwane ne inum narimain kuu eb ebkaad, biknindo. ");
INSERT INTO yon_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Ne mimyob kuu kurungkurung deeroon, kwane naromkonoyiibban dowan keraan, kwane ne indob kuu wud dabuneen. ");
INSERT INTO yon_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Ne arewa keraan kumbed ne mimyob dowaken keendaandaniib nangkodmiayiib kuu bongwawimokban keriwen, kwane ne karubkim kangkon ambab angkambed dobirimaib. ");
INSERT INTO yon_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Kane kanembed ne yaa nenbande kowandamiib kuu ne dowad kawaad nong kowe bikniwen, kwane kane kanembed nenbandandamiib kuu ne dowad ye nen monmarem ande kamiib, amkimombed wene amnoom kuu wunonwanon kamimaib kui. ");
INSERT INTO yon_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Ne kuu kerendem warudki wengambirimokbanman areb, kwane ne kuu wengwaab dakmimokbanman areb. ");
INSERT INTO yon_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Anamaa, ne kuu karub maa wengambirimokbanman areb kereni, ye mongkod dande inandimokbanman areb keraan. ");
INSERT INTO yon_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","O Yariman, ne kuu eb ande meedmiin, o Yariman ne God, ebbed ne yaa inanduwaneeb. ");
INSERT INTO yon_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Amborom kuu nembed yedmaan, “Ne yon kereeb beresare kombaraniin kuu, yi kuu domondaawe ne yaa ambon kamewenib ne nen kubune yika kankoonaib.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Kedi, ne kuu kombarandamiin, kwane ne yaa yewed kuu ma womoniyiibban angkeen. ");
INSERT INTO yon_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Ne ambarakmi kuu God yaa dakmaan, kwane ne ambarakmi wedmeni meendobembere yiminban keraan. ");
INSERT INTO yon_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Kumban ne bondan kuu korereyiibban amunmo angkon aromkonoyiib, kwane idiibbanbed ne yaa arud wandiwendan kuu yemoon. ");
INSERT INTO yon_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Kane kane ne amun kami yaambed arewa kamewimaib kuu, amun kami ye kerekmen yaa wanaine ne yaa wengamborokbanabimaib. ");
INSERT INTO yon_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","O Yariman, ne yaa domowaab, o ne God, ne yaa ambab keruwaab. ");
INSERT INTO yon_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","O Yariman, ne nen burudande angka kowi ye karub, kirod mene awawe. ");
INSERT INTO yon_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Yook ambo bi ye karub yeman. Yedutun ye dowad wongkoon. Dewid ye yook. Nembed yedmaan, “Ne dobiri kerekmen kuu nekareb kangkadmaniin, kwane ne weng dakmi yaambed ambarakmain. Arewa kamidaniib ne arinambo ari keraniibbed kuu weng ma dakmainban.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Ne kuu ne mongkodkono kebene iwari kereni, weng maa ma dakmokban kerimain, weng amun kangkon. Kwanimain kumban ne mimyob wandi kuu darewoob arimbed keroon. ");
INSERT INTO yon_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Ne niindem aom kuu nimin denobimaan, kwane meendobaine amot areb denimaan. Kwanekori yedmaan, ");
INSERT INTO yon_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“O Yariman, ne aron yimin wandaneen kuu korokbewe. Kwane, weeb komoyiib ari dobaraniin kangkon korokbewe. Kwananeeb kuu ne wad dobiri kuu aron dukmenmo yeman ande nekaadkeraniin.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Kedi, ebbed ne weeb ongmewen kuu kumunkingkaniin kuu dingki mimo angkarambed wene angkara areb kumbedmo, kwane ne wooneenbed wene bobnaniin ye weeb kuu eb yaambed kuu barang anamban areb miin dukmen mana. Nimakarub mimim yi dobiri ye weeb kuu eb yaambed kuu inum koni mimo areb kumbedmo.Selah ");
INSERT INTO yon_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Anam kuu nimakarub dewenebimaib kuu kuruwakmo areb barang darewoobban. Anam kuu komo komo ambangkimaib kuu ma id kerimokban. Kwane, yi kuu yiribman yemoon bimaib kumban, ari duknaniiwe yi yiribman kanembed baniib kuu yikaadban. ");
INSERT INTO yon_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Kwane kowe, Yariman, kibikee komo dowad kereknaniin? Ne meeni amaan ari kwananeen ande meenaan kuu eb yaamo. ");
INSERT INTO yon_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Ne ambarakmi korem yaa kuu awaweneb nen angka kowe. Kwane domowaawe inameniibbandanbed damangkawaib. ");
INSERT INTO yon_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Ne kuu iwari keraan, ne mongkod dande weng dakmainban, amborom kuu ke dabab kandaan kee ebka ebbed kwamune ambangkewen kowe. ");
INSERT INTO yon_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Ebbed ne yaa ukum kawewen kuu kan angkane. Ne kuu eb dingkimbed woweewe korem yiminban keraan. ");
INSERT INTO yon_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Ebbed nimakarub yi ambarakmi dowad ongkandeneb didangkimaab, kwane ebbed yi yiribman kuu amberodbed ane dowan keremoon areb kerundewen. Nimakarub mimim yi kuu inum koni mimo areb barang miin embeng mana.Selah ");
INSERT INTO yon_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","O Yariman, ne kurikuri weng wengambere. Ne awawe ande baandaan kuu wengambere. Ne ameng kami yaa kuu kerendem warudki areb keruwaab. Amborom kuu ne yaa arud wandewen kumbed ne kuu eb yaa owodman areb keraan, nawoya yiri areb norodman keraan kui. ");
INSERT INTO yon_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Ne yaa ebbed arud wande indob korarewen kuu womone. Kwanebko ne angkon ika kuba. Kwanaabban kuu ne kuu kimyen wene bobnaniin. ");
INSERT INTO yon_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. Ne kuu yodbirimban emamo Yariman yaa meedmaan, kwane ye kuu amonombene ne baandi yaa wengamboroon. ");
INSERT INTO yon_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Yembed monmari ye dem yirimbed ne nen angka kowoon, birin yerekbon yirimbed kui. Yembed ne yon kuu dumnad ari ongmene kamkonombon ari dori yeman kawoon. ");
INSERT INTO yon_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Kwane, yembed ne niindem aom yook yeweb kowoon, nub God yaningko kankooni ye yook kui. Yemoon kuu wedmekorib unenib Yariman yaa angkumone dobaraniib. ");
INSERT INTO yon_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Kane kanembed Yariman yaambed yone dobiriwen kuu amun kerundoon, yi kuu kerengkandan yaambed yone dobirindo, God anam yaa koronde dudi god yaa winiwendan yaambed yone dobirindo kui. ");
INSERT INTO yon_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","O Yariman ne God, binangke eb kuu anam andi yeman korokbewen kuu yemoon. Ebbed nub dowad komo komo meene ongmenabewen kuu, karub maambed angkon ika eb yaa kimingkaanban. Kuye dowad nembed dakmenabaniin kuu, dakme dowan kerindeban, yi kuu yemoon kowe. ");
INSERT INTO yon_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Eb yaa dingkan aye nengke baeb koniyiib animan munob koniyiib kuu eb dowakenban, kwane eb kuu eb yaa dingkan kumundin nengke agedmo kere baeb koniyiib ambarakmi aari dowad dingkan aye agedmo kere baeb koniyiib kamime ande kowindo, kumban ne kerendem kuu nandewen. ");
INSERT INTO yon_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Kowe, nembed yedmaan, “Ne kuu kei, ke manaan kei. Buk bedmiwen kuu ne dowad wongkoon. ");
INSERT INTO yon_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","O ne God, eb dowaken yaambed ambangkande meenaan. Eb amob kuu ne niindem aom angkeen.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Ne kuu yorokmo keri ye kerekmen kadaareb nedbimaib aombed dakmimain, kwane ne mongkodkono karangkimokban, o Yariman, kuyaa kuu ebkaadkerewen kii. ");
INSERT INTO yon_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Eb yorokmo kerekmen kuu ne niindem aom kan biknimokban, ma, eb korondiyiibban eweng awinaneeb andiyiib ebbed bobni yaa burudande bindiyiib kuu dakmimain. Ne kuu kadaareb nedbimaib yaa kuu eb womoniyiibban ye mimyob dowakeniib anam anamiib kuu ben aadidmimokban. ");
INSERT INTO yon_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","O Yariman, eb mimyob keendi kuu kawe, ebka amuknaab. Kwane, eb mimyob dowakeniib anam anamiib kumbed ne nen dorondaruwok, aron korem. ");
INSERT INTO yon_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Kimingkindeban ye dabab yemoon kuu ne yaa awanewandoon, kwane ne ambarakmimbed ne yaa burudandoon kowe wedmindeban keraan. Ne ambarakmi kuu yemoon, ne korok ari awung kimingkindeban kwamune arebban, kwane ne niindem aom kuu korem yiminban keroon. ");
INSERT INTO yon_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","O Yariman, dowakeniib kerebka ne nen angka kowe. O Yariman, kirod mene awawe. ");
INSERT INTO yon_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Ne nenbande kowandamiibdan kuu yi korem kuu karak kondene kerebkarab kerundok. Ne nen monmarande kamiibdan kuu yi korem kuu ben angkurom kondene yi aningko kankubunok. ");
INSERT INTO yon_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Ne yaa damangkawe yedmimaib, “Aha! Aha!” andimaibdan kuu karak kandenib yika wedmenib binangkime. ");
INSERT INTO yon_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Kumban kane kane eb ande onmiib kuu, eb yaa dowakeniib kerenib kubebdime. Kwane kane kane ebbed bobni yaa burudande bindi yaa dowakeniib keriwen kuu, yedmimamime, “Yariman yaningko ye yirin darewoob kerok.” andimamime. ");
INSERT INTO yon_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Kuned ne kuu kamboknon kereni awawe ande doriin kowe, Yariman kuu ne yaa meenewok. Eb kuu ne awawi ye karub, angkon ne nen burudande angka kowi ye karub. O ne God, mokaid amaanbed andaab. ");
INSERT INTO yon_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. Kanembed kamboknondan yaa meendene amun kamendimaan kuu ye kuu Godbed amun kerunoon. Ye yaa dabab mananeen kuu Yarimanbed awanene nen angka kowaneen. ");
INSERT INTO yon_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Yarimanbed ye nen dorondarene ye wadkeri kande kukbaneen, kwane ye kuu okad yiri dobaraneen kuu Yarimanbed amun kerunaneen, kwane ye bondanbed yi dowaken yaambed ye yaa komo kamenandamiib kuyaa kuu Yarimanbed domonenaanban. ");
INSERT INTO yon_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Ye kuu anikad angkimbaraneen kuu Yarimanbed aromkono konaneen, kwane anikad angkeen yiri kuu ongmaneene wadkeraneen. ");
INSERT INTO yon_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Kuned nembed yedmaan, “O Yariman, eb yaa ambarakmaan kowe, ne yaa mimyob keewe ongmewebko wadkera.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Ne bondanbed ne yaa arud wandenib ne dowad dakmimaib, “Aron komo arimbed bobnaneenkob yaningko kuu dowan keraneenka?” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Yi kuyaom kuu mimo yembed neyiib yaa mene wedmewimaan kuu, dudi weng dakmene ne weng kande amonombe weng arewa ongmene bunangka wene kwane dakmen yarimaan. ");
INSERT INTO yon_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Ne bondan korem kuu nedbenib kongewe koraaweng dakmenabimaib, kwane yimbed ne dowad miin arewa kerok ande meenenib ");
INSERT INTO yon_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","yedmimaib, “Ye kuu karakiib ye bobobbed aye kowoon kowe, ye kuyaa yiri angkeen kuu ika ma dembaanban.” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Nangkodmi anam, ye yaambed yone dobaraan, ye kuu ne om animan animaan kuned, ye kangkon ne yaa manmo keroon. ");
INSERT INTO yon_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Kumban, o Yariman, eb kuu ne yaa mimyob keewe ne nen ongmebko wadkera. Kwanebko nembed ne bondan yaa ingka. ");
INSERT INTO yon_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Ne bondan kuu ne yaa nangme dorindeban keriwen kowe, nekaadkeraan eb kuu ne yaa dowakeniib keruwewen. ");
INSERT INTO yon_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Ne inameniib dobiriyiib dakmiyiib kuu ibmo kowe ebbed ne nenkooneneb, eb arinambo ari aron korem yeman kowewen. ");
INSERT INTO yon_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Yariman, Israeldan yi God kui, ye yaa amun kerunok, yimin andowoon yirimbed wene aron korem korem kui. Anam kwanok. Anam kwanok. ");
INSERT INTO yon_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Yook ambo bi ye karub yeman. Maskil ye yook Korah ye awoyambed wongkiwen. O God, diiyambed ok moom bobnekore okmanambon yaa anande wenemoon areb kwane ne kingkin kuu eb ande onmeen. ");
INSERT INTO yon_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Ne kingkin kuu God yaa ok moom areb keroon, wad doreen ye God yaa kui. Aron komo arimbed Godiib yaa wene durunenaniin? ");
INSERT INTO yon_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Yenambed amkimombed wene amnoom kuu ne yaa yedmimaib, “Eb God kuu kuna? Dowan!” andimaib kowe, ne kuu amnoomiib awingyawiib animan koronde inokmo wimain. ");
INSERT INTO yon_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Anuk kuu nembed kadaareb bindore God ye kurikuri ambib yaa kinban winimain, kukuu kube baandiyiib eso ande baandiyiib ne yoom kadaareb yoom God ye orokbon winimaub. Kuyaa kuu kibikee ika meenekori ne mimyob wandi kuu God yaa koneni ye yaa baandimain. ");
INSERT INTO yon_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","O ne kingkin, eb komande yerene no kubokban kerewen? Komande ne niindem aom monmareeb? Kedi, God yaningko kankoonaniin kowe, God yembed ari kwananeen ande meene. Ye kuu neyiib yaa doberene awawimaan ye karub, ye kuu ne God. ");
INSERT INTO yon_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Ne kingkin kuu miin kubiyiibban keroon. Kwane kowe, ne kuu okad Yooden yaambed eb yaa ika meenaniin, aangko Heeman yaambed, aangko Misaa yaambed kui. ");
INSERT INTO yon_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Ok niindem yirimbed okad niindem yiri yaa baandemoon areb, eb ok benbon ye kuweng kumbed kui, eb umbakiib oknondokiib korem kumbed ne ari beengkaiwe, korem yiminban kerimain. ");
INSERT INTO yon_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Aronki kuu Yarimanbed ye womoniyiibban ye mimyob dowaken keewok, amnoom kuu ye yook kuu ne yaa angkimborok, kukuu kurikuri yeman ne wadkeri ye God yaa kui. ");
INSERT INTO yon_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Ne kuu God ne aromkonombon yaa kaamonimain, “Eb komande ne nonondanduwewen? Komande ne bondanbed yobdood keruwaiwe ne kuu kwane yuudi ameng kamembirimain?” andimain. ");
INSERT INTO yon_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Ne bondanbed ne yaa damangkawimaib, amkimombed wene amnoom kwane yedmimaib, “Eb God kuu kuna? Dowan!” andimaib, kowe kono domabangki ye yewed areb kuyiib keraan. ");
INSERT INTO yon_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","O ne kingkin, eb komande yerene no kubokban kerewen? Komande ne niindem aom monmareeb? Kedi, God yaningko kankoonaniin kowe, yembed ari kwananeen ande meene. Ye kuu neyiib yaa doberene awawimaan ye karub, ye kuu ne God. ");
INSERT INTO yon_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","O God, ne dowad ebbed wengyundeneb ma ambarakmindo ande. Kwane ne kangdod weng koromoneneb God ye kiwaan yikaadbandan yaa kebende. Kwane birande arewa kamenabidan yaa kuu ne nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Eb kuu God ne dore angkumonimbon kowe, komande ne yaa wunekarewen? Komande ne bondanbed yobdood keruwaiwe ne kuu kwane yuudi ameng kamembirimain? ");
INSERT INTO yon_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Eb nambiriyiib anam anamiib kuu ben yure kowe. Korondebko yimbed ne nen kinban winime. Korondebko yimbed ne nen eb aangko karadmo ari winime, eb dobirimbon yaa kui. ");
INSERT INTO yon_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Kwananeen kuu ne kuu God ye bot wuubimbon yaa wananiin, Godiib yaa kui, ye kuu ne kubi ye ambokab kui. Ne kuu haap wangkeni ewaningko kankoonaniin, o God ne God. ");
INSERT INTO yon_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","O ne kingkin, eb komande yerene no kubokban kerewen? Komande ne niindem aom monmareeb? Kedi, God yaningko kankoonaniin kowe, yembed ari kwananeen ande meene. Ye kuu neyiib yaa doberene awawimaan ye karub, ye kuu ne God. ");
INSERT INTO yon_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Yook ambo bi ye karub yeman. Maskil ye yook Korah ye awoyambed wongkiwen. O God, nubka kub kerendembed wengamburuwen, kwane nub awoyambed unyeman yiri yi dobiriwen yaron yaambed ebbed komo kamewen kuu nub yaa daandiwen. ");
INSERT INTO yon_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Eb dingkimbed ambibkin maa maadan ben angkanekoreb, nub awoya ben kuri nongkobewen. Ebbed nimakarub kuyaa dobiriwen kuu dore boknekoreb nub awoya ongmendeewe amunmo dobiriwen. ");
INSERT INTO yon_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Kedi, nub awoya kuu yi kerewang yaromkono yaambed burudande okad kandindo, kwane yi dingkimbed nangbe burudandindo. Kukuu eb dingki wiwi yaromkonombed kwane burudande okad kandewen, kwane eb murubia ye nambirimbed nangbe burudandewen, amborom kuu ebbed yi yaa dowakeniib kerundewen kowe. ");
INSERT INTO yon_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Eb kuu ne God ne king, Yekob ye awoya ari yi dowad inamen ongmaawe yi bondan yaa nangbe burudandimaib. ");
INSERT INTO yon_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Eb yaambed dore nub bondan kuu ika yenbanden winimaub, kwane ewaningko yaambed nub manmo kerimaibdan kuu nubbed nangbe burudandimaub. ");
INSERT INTO yon_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Kedi, ne anangkab kuyaambed nangbe burudanda ande meenimokban, kwane nembed nangbe burudandimain kuu ne kerewangbedban. ");
INSERT INTO yon_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Anam kuu ebbed nub bondan yaa nangbe burudandi yaromkono kondimaab, kwane ebbed nub yaa manmo keriwendan yaa karak kondimaab. ");
INSERT INTO yon_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","God, eb dowad kerengkan kamimaub, amkimombed wene amnoom, kwane ewaningko aron korem kankoonimamanuub.Selah ");
INSERT INTO yon_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Kumban kibikee eb kuu nub yaa wunekareneb ben yiri kubunewen, kwane eb kuu nub ana nangmidan yoom ma wanaibban. ");
INSERT INTO yon_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Nub bondan miniiwe ebbed nub ongmendeewe ikakman kirokmonuwen, kwane nub yaa manmo keriwendan kuu nub yaa nangbe nub yiribman biwen. ");
INSERT INTO yon_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Ebbed nub ongmendeewe sibi yeen anemoon areb keriwen, kwane ebbed nub ben bokesawareewe ambibkin maa maa yaa wenebuwen. ");
INSERT INTO yon_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Eb nimakarub kuu od embeng mana yeman ben berengkewen, kwane yi ben berengkewen kuu ari ma idiib kerindo dowan. ");
INSERT INTO yon_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Ebbed nub ben ongmendeewe nub dia doriibdan yi indob arimbed dedmone dandi yeman keriwen, kwane yi kuu nub yaa damangkande ambon kamendimaib. ");
INSERT INTO yon_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Ebbed nub ben ongmendeewe ambibkin maa maadanbed nub dowad nongdomatomdan andimaib, yi kuu nub yaa mungkuwande korok waaburukmimaib. ");
INSERT INTO yon_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Ne karak kuu ne arinambo ari angkimbirimaan, amkimombed wene amnoom, kwane ne murubia kuu karakmo kerimaan, ");
INSERT INTO yon_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","amborom kuu ne yaa dedmone dawimaibdanbed damangkawimaib kowe, ne bondan kui, inande dabab kawimaibdan kui. ");
INSERT INTO yon_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Korem kee nub yaa kwane menebimaan kumban, nub kuu eb yaa nonondandimokban kere eb amob weng yaa korondimokban. ");
INSERT INTO yon_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Nub niindem aom kuu eb yaa ma koronde ika winindo, kwane nub kuu eb kiwaan ari koronde kimyen winindo. ");
INSERT INTO yon_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Kumban ebbed nub kuu dore beengkeneb nuwokad kan amonombe dura anon arewa yi okad areb kerundewen. Kwanekoreb, nub kuu kumun darewoob kumbed kebenendewen. ");
INSERT INTO yon_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Nub kuu nub God yaningko nonondandunekorub oworan yi god yaa bumangkuwen karen, ");
INSERT INTO yon_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","anam kuu God kuu kuyaa wedme yekaadkeroon karen, ye kuu biknoon ye inamen korem yekaadkeroon kowe. ");
INSERT INTO yon_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Kuned eb dowadbed amkimombed wene amnoom kuu bobni yaa wedmimaub, kwane nub kuu sibi areb ogoodmo yenbandi kuu yimin andimaib. ");
INSERT INTO yon_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","O Yariman, yaro dembe! Komande angkimaab? Ebkareb yaro dembe! Nub yaa aron korem wunekarundaab. ");
INSERT INTO yon_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Eb komande murubia kan yereknekoreb nub durud yewediib nub yaa yenbandiyiib ye dowad ma awandindo kerewen? ");
INSERT INTO yon_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Nub kuu bobni ye dungkun yaa doruwen, kwane nub id kuu okadbed yobdoodmo awineen. ");
INSERT INTO yon_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Dembe, nub awande. Eb womoniyiibban ye mimyob dowaken ye dowad nub bidde. ");
INSERT INTO yon_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Yook ambo bi ye karub yeman. “Bingko Wuung” ye yook ye kiwaan yaambed wingki yeman. Maskil ye yook Korah ye awoyambed wongkiwen. Wonong awani ye yook. Ne mimyob aom manimani inamenbed dembe yiminmo kereni king yaa komkum dakmaan. Ne ong kuu komkum kami niidiib dowad moo kai kerembirimaan. ");
INSERT INTO yon_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","O king, eb kuu miin kerengkabdimbon kai, yena korem arebban, kwane kabamoon kondoon ye mimyob dowaken keendi weng kuu eb mongkod aombed menebimaan, Godbed amun kerubdoon aron korem kowe. ");
INSERT INTO yon_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","O king kanangkod aromkonoyiib, eb kerewang kande inware. Kwane eb dobiri manimanandewiib nambiriyiib kuu korokbende. ");
INSERT INTO yon_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Eb dobiri manimanandeb kumbed hoos ari dibere wene burudande dore, anam anamiib ebka kankubune dobiriyiib yorokmo dobiriyiib korokbi ye dowad. Eb dingki wiwi ye aromkono kumbed warekandi ye kami kuu ongmenabe. ");
INSERT INTO yon_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Eb ana kuu yidkang arudiib, kwane yi kuu eb bondan yi niindem karewandimaan. Ambibkin maa maadan kuu ebbed nangme burudande eb yondad dabderem yiri nongkobimaab. ");
INSERT INTO yon_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","O God, eb dibere oonimbon kuu aron korem angkimbaraneen, kwane eb ooni ye inamen kuu wengyundi anammo. ");
INSERT INTO yon_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Eb kuu yorokmo kerekmen yaa dowaken darewoobmo kereneb arewa kami yaa miin dowakeniibban anam kerimaab kowe, God, eb God kumbed eb nen ari kowoone, eb angkodmia kuu yirimo keriwen. Yembed eb yaa kubimaan ye oiyo eb ari bunoon kumbed eb nen ari kowoon kui. ");
INSERT INTO yon_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Eb ebkad doboob korem kuu meer baewiib alo baewiib kasia baewiib, kwane king ye ambib aiforimbed yenbiwen kuyaambed nongiib ye wangki yemaniib wingkenib kubi kabdimaib. ");
INSERT INTO yon_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","King maa maa yi nimadana ebbed awadmewen kuu aningko darewoowiib, kwane eb dingki wiwi angka kuu king maa ye mungkan awanandameeb kumbed doruun, yu kuu Ofiaa ye bot goldbed inwareen. ");
INSERT INTO yon_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","O king maa ye mungkan, nembed komo ke yedmandamiin kee kande niindem aom kowe. Kub ambibkindaniib karubkimiib kuu nonondande. ");
INSERT INTO yon_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Kedi, nub king kuu kub manimani yaambedmo boknoon kii. Kedi, ye kuu kub yariman kowe, ye aningko kankoone. ");
INSERT INTO yon_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Taiya ye king ye mungkan kuu munob yeman bangkabdanuun, kwane yiribman yemoondan kuu kubende ande kub yaa amun amun kamebdaniib. ");
INSERT INTO yon_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","King maa ye mungkan kui, yu kuu manimani ye ebkad inware yu wadnarimbon aom doruun, kwane yu ebkad kuu bot goldiib angkabiwen kumbed inwareen. ");
INSERT INTO yon_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Yu kuu kwane angkabiwen ye ebkadiib inwareen kuyiib kumbed yu kuu nen kingiib yaa wananiib, o king, yu yoman kuu yu nima koyu amborongaadbed mananiiwe, ewiib yaa ben mananiib. ");
INSERT INTO yon_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Yi kuu kubiyiib dowakeniibbed ben kinban wananiib, kwane yi kuu king ye ambib aom aomnaniib. ");
INSERT INTO yon_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","O king, eb karub dana meed kuu eb awodkia areb king keraniib, kwane ebbed yi kuu ben okad maa maa yi korok ongmendaneeb. ");
INSERT INTO yon_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Nembed nimakarub yaro dobere dobere yaro wananiib korem aom eb yaa meeni yeman kuu ongmaniin. Kwani kowe, ambibkin korem kuu aron korem korem ewaningko kankoonaniib. ");
INSERT INTO yon_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Yook ambo bi ye karub yeman. Alamot ye kiwaan wingki yeman. Yook kuu Korah ye awoyambed wongkiwen. God kuu nub ben kukbimaanbon angkon nub aromkono, kwane dabab aron yaa kuu awandande nekwimbed doreenmo. ");
INSERT INTO yon_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Kwana kowe, dowodki mananeene okad amonombanuun yaa o aangko aangko dande karamok yiri kirobaniib yaa kuu nub kuu unaubban. ");
INSERT INTO yon_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Karamok umbakiib kuwengiib ok kamokiib kamanuun o kuye arud kumbed aangko aangko kiringmaniib kangkon unaubban.Selah ");
INSERT INTO yon_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","God ye siti aombed kubi kanminimaun ye ok awaan angkuun, kuye siti kuu karadmombon, Korem Burudandoon Arimbed Ye God kuyaa doreen kui. ");
INSERT INTO yon_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Kuyaom kuu Godbed doreen kii, kuye siti kuu komombed ma monmaraanban. Warewinimbed God kuu awande oonendaneen. ");
INSERT INTO yon_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Ambibkin maa maa kuu yirinde baandiiwe, angkon oonimbon maa maa kirobiiwe, God ye baandi kuweng daandeene okad kuu okmo kereen. ");
INSERT INTO yon_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Ana nangmidan yemoon ye Yariman kuu nuwiib doreen, Yekob ye God kuu nub dorondandi ye karub.Selah ");
INSERT INTO yon_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Yiib menenib Yariman ye ambangkanabi kee wedmime, okad ari ke monmarenaboon kee wedmime. ");
INSERT INTO yon_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Yembed okad yimin yimin yaa kuu ana nangmi kebenimaan, kwane yembed anangkab domabangkene marad ben monmarene kombe kuu amotbed denimaan. ");
INSERT INTO yon_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Yembed yedmimaan, “Ne kuu God kowe iwari kerenib wedme meendobe kaadkerime. Ne aningko kuu ambibkin korem ye nimakarubbed kankoonaniib, kwane ne aningko kuu okad korem yaambed kankoonaniib.” andimaan. ");
INSERT INTO yon_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Ana nangmidan yemoon ye Yariman kuu nuwiib yaa doreen, Yekob ye God kuu nub dorondandi ye karub.Selah ");
INSERT INTO yon_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Yook ambo bi ye karub yeman. Yook kuu Korah ye awoyambed wongkiwen. Ambibkin koremdan, yiib dingki wangkime, God yaa kubiyiibbed baandime. ");
INSERT INTO yon_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Amborom kuu Korem Burudandoon Arimbed Ye Yariman kuyaa kuu unime andi yeman, ye kuu King miin darewoob arimbed okad korem oonimaan kui. ");
INSERT INTO yon_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Yembed ambibkin maa maa ben nub ooni dabderem yiri keroon, yi kuu nub yon dabderem yiri ben nongkoboon. ");
INSERT INTO yon_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Yembed nub yumbon kuu nub dowad kine kowoon, kukuu nub okad kui, kuyaa kuu Godbed mimyob dowaken keenoonman Yekobbed kerengkan keroon.Selah ");
INSERT INTO yon_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","God kuu kube komkimaib ye kidangkambed daanoon, ku Yariman kui, ye kuu kibi komkimaib kumbed daanoon. ");
INSERT INTO yon_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","God yaa ye aningko kankooni yook wingkime, kuye yook wingkime, nub King yaa ye aningko kankooni yook wingkime, kuye yook wingkime. ");
INSERT INTO yon_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Kedi, God kuu okad kumundin ye king, ye yaa yook kangdommombed ye aningko kankoone wingkime. ");
INSERT INTO yon_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Godbed ambibkin korem kuu oonimaan, God kuu ye dibere oonimbon karadmo arimbed dibeen. ");
INSERT INTO yon_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Ambibkindan yi korok korok kuu Abraham ye God ye nimakarub yoom nedbimaib, amborom kuu okad yiridan yaa oonidan kuu God yeman kowe, ye yaa darewoobmo aningko kankooni yeman. ");
INSERT INTO yon_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Yook ambo bi ye karub yeman. Yook kuu Korah ye awoyambed wongkiwen. Yariman kuu aningko darewoowiib, ye kuu korem yena arebban, ye aningko kumbedmo kankooni yeman, nub God ye siti aombed, ye aangko karadmo arimbed kui. ");
INSERT INTO yon_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Aangko Saiyon ari kuu manimanandeb kii, kuyaa kuu okad kumundinbed kubimaun, kukuu karadmo anam kai, kukuu darewoob arimbed ye King ye siti kui. ");
INSERT INTO yon_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","God kuu yu dorondandimbon aom doreen, kwane yeka korokboon kuu ye kuu yu dowad aromne angkumonimbon keroon. ");
INSERT INTO yon_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Kedi, king maa maa mene nangmi dowad daboknenib ibonmo mene dia keriwen kuu ");
INSERT INTO yon_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","kuye siti wedmekorib binangkiwen, kwane uniwon karakwon kere kirokmoniwen. ");
INSERT INTO yon_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Kwane yi kuu unimo keriwen, yi kuu wonong dana woonande yewed kandimaun areb keriwen. ");
INSERT INTO yon_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","O God, ebbed yi ben monmarewen, yi kuu aron dembimaun angka ye nuubbed Taasisdan yi motod baangkenu kurubkurub keremoon areb keriwen. ");
INSERT INTO yon_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Godbed kwanoon kuu kwane wengamburuwen, kwane nubka wedmuwen. Ana nangmidan yemoon ye Yariman ye siti aom, nub God ye siti kui, yembed yu kuu ongmendaane komombed ma monmaraanban yeman kereen aron korem.Selah ");
INSERT INTO yon_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","O God, eb womoniyiibban ye mimyob dowaken yaa meendobembere kubimaub, eb kurikuri ambib aombed. ");
INSERT INTO yon_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","O God, eb yirin kuu okad yimin yimin yaa derendaroon kwamune areb kuu, ewaningko kankooni kangkon derendaroon. Kwane eb dingki wiwi kuu ambangki yorokmoyiib kumbedmo. ");
INSERT INTO yon_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Eb wengyundi kuu anammo kowe, aangko Saiyondan kuu kubimaib, ambibkin Yudadan kangkon kubimaib. ");
INSERT INTO yon_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Aangko Saiyon yu siti Yerusalem awanewande dewenebime, kukbiri ye ambib kongam kuu kimingkime, ");
INSERT INTO yon_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","siti kuuk yaa ongme andangkime, aromne angkumonimbon korem wedmenabime. Kwananiib kumbed yiibbed komo komo wedmiwen kuu yiib awoya ari yaa daandaniib. ");
INSERT INTO yon_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Kedi, God kee nub God aron korem korem, kwane ye kuu nub ben kinban winimamaneen aron korem. ");
INSERT INTO yon_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Yook ambo bi ye karub yeman. Yook kuu Korah ye awoyambed wongkiwen. Ambibkin koremdan, weng kee wengambirime, kane kane okad kiri doriib, yiib korem ke wengambirime, ");
INSERT INTO yon_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","aningkoyiibbandaniib aningko ariyiibdaniib, yiribman yemoondaniib kamboknondaniib, yiib korem kui. ");
INSERT INTO yon_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Ne mongkodkonombed meeni kangdom ye weng dakmaniin, kwane ne niindem aombed weng menebaneen kumbed kaadkeri kuu kondaniin. ");
INSERT INTO yon_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Ne kerendem kuu ongkandi weng yaa kowe wengambaraniin, kwane haawiibbed wangkeni weng yobdood ye id kuu kedmengkandaniin. ");
INSERT INTO yon_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Ne yaa aron arewa mananuun kuu komande unaniin? Dowan, unainban. Arewa kame birandimaibdanbed ne yaa kanawanewandaniib kuned unainban. ");
INSERT INTO yon_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Kane kane yi yiribman yemoon yaa yone nub kuu yiminmo ande kerengkan kamimaibdan kumbed manmo keruwaniib kangkon unainban. ");
INSERT INTO yon_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Karub kanembed karub maa ye wadkeri dowad ma biddindeban, kwane yembed karub maa ye dowad God yaa ma moonindeban. ");
INSERT INTO yon_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Wadkeri ye dowad biddi kuu yeka mamaa, odbed kowi kuu yiminban. ");
INSERT INTO yon_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Biddaneen kuu aron korem ari wad doberembaraneen, kwane biddaneen kuu ma deendaanban. ");
INSERT INTO yon_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Kedi, wedmuub kuu meeni kangdomdan kuu duknaniib, inameniibbandaniib awon korokdaniib kangkon duknaniib, kwane yi korem kuu duknenib yi yiribman kuu yena yaa kirarundaniib. ");
INSERT INTO yon_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Yi bobkonombon kuu yi dobirimbon keraneen aron korem, kuyaa dobaraniib yaron kuu yimin wandaanban, yi yirin kumbed yi okad kuu yika yi aningkoyiib ande kowaniib kuned. ");
INSERT INTO yon_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Kukei, karub kuu ye yiribman yemooniib kuned doberembaraanban, ye kuu dingkan areb, ye kangkon bobnaneen. ");
INSERT INTO yon_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Inameniibbandan yi dobiri kiwaan kukui, kwane yi yoman wene yi weng yaa amun andimaibdan kangkon kwamunemo dobirimaib.Selah ");
INSERT INTO yon_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Yi kuu sibi areb, yika oonaibban, bobni yaromkonombed dedmondaneene bobkonombon yiri wene dobaraniiwe, bobnimbed yi yaa oonaneen. Kwane aron dukmen arimbed yi kuu yorokmodanbed oonendaniib. Yi id kuu bobkonombon yirimbed deendaneen, kowe yi kingkin kuu ambiwiibban keraniib. ");
INSERT INTO yon_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Kumban Godbed ne wadkeri kuu bobkonombon yirimbed biddaneen, amanaa, ne kuu yekareb yeyiib yaa nenwananeen.Selah ");
INSERT INTO yon_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Kwane, karub maa kuu yiribman yemooniib keroko binangke unaib, ye ambiwoom korem amun amunmo yidware wonoka kuyaa meenaib. ");
INSERT INTO yon_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Amborom kuu ye bobnaneen kuu ye yiribman kuyiib yeka ma be wanaanban, ye ambiwoom korem amun amunmo yidwaroon kuyiib bobkonombon yiri ben kubunaanban. ");
INSERT INTO yon_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Ye kwane doreen kuu yekareb yemeren nekob yimin ande kubimaan. Ye kuu yiminmo keraneen kuu yenambed ye aningko kankoonaniib kuned, ");
INSERT INTO yon_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","ye kuu yambe yawoya awoya yaa daboknendaneen, yi kuu kumun aommo doberembaraniib kui. ");
INSERT INTO yon_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Yiribman yemoondan kuu kaadkeri inameniibban keraniib kuu dingkan areb, yi kangkon duknaniib. ");
INSERT INTO yon_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Asaf ye yook. Aromkonomo Ye God, Yariman kui, yembed dakmene okaddan yaa minime ande baandimaan, aron daminimaunbed wene aron kubunimaun korem yaa kui. ");
INSERT INTO yon_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Aangko Saiyon, yu manimanandeb kuu demkoronmo kui, yu yaambed God kuu yure kowimaan. ");
INSERT INTO yon_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Nub God kibireb meneen kii, ye kuu iwari dobaraanban, kwane ye meneen ye kiwaan ari kuu amotbed denobenmo meneen, kwane nuuwa amayiib bare kanmene ye kuu kanawanewandeen. ");
INSERT INTO yon_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Yembed Ewen ariyiib okad yiriyiib yaa mene wedmime ande baandoon, ye nimakarub ben wengyundi dowad. ");
INSERT INTO yon_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Kwane yedmoon, “Ne kiwaan ari doriibdan kuu ne yaa ben minime. Kane kanembed dingkan aye nengke ne yaa baeb konenib amob weng ongmiwendan kui.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Kwane Ewen kuu ye yorokmo kerekmen kan dakme baandimaun, amborom kuu God yekareb kangdod kerundi ye karub keroon kowe.Selah ");
INSERT INTO yon_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Kwane yedmoon, “O ne nimakarub, wengambiriiwa kekane dakma. O Israeldan, yiib kui, yiib yaa manmo kereni kangdod weng dakma. God ne kei, ne kuu yiib God kii. ");
INSERT INTO yon_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Yiibbed womoniyiibban dingkan aye nengke baeb konenib dingkan yena ben kumundin nengke denobe dowan kerimaib kuned, kuyaa kuu ne kuu ongkandi wengiib kerindo. ");
INSERT INTO yon_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Yiibbed yiib buromakau ambi kuuk aombed kawi kuyaa ma meenindo, yiminmo doriin kowe. Yiibbed yiib naningkod ambi kuuk aombed bangkawi kangkon kuyaa ma meenindo, ");
INSERT INTO yon_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","amborom kuu dura ye dingkan korem kuu nemanmo, buromakau yemoon kai koodbon tauseniib arimbed doriib kangkon neman. ");
INSERT INTO yon_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Aangko aangko ari ayari on korem kuu nekaad, kwane dabonmo ye okad ye dingkan kuu nemanmo. ");
INSERT INTO yon_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Ne kuu mungiyiib keraan karen, yiib yaa ma kaamonindo karen, amborom kuu okad kumundiniib kumkam korem dangooniib kuu nemanmo. ");
INSERT INTO yon_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Buromakau yom animainoo? Dowan. Naningkod yi umkan animainoo? Dowan kii! ");
INSERT INTO yon_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Ne yaa eso andi dowad munob bangkawi yeman bangkawime. Korem Burudandoon Arimbed Ye God, ne dowad yiibbed kwane kamanuub ande amob weng ongmiwen kuu kwane kamime. ");
INSERT INTO yon_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Dabab aron aom kuu ne yaa baandime. Kwananiib kuu nembed yiib ben burudande angka nongkobaniine ne aningko kankoonaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Kumban arewa kamidan yaa kuu Godbed kamune yedmoon, “Yiibbed ne amob ben yena yaa daandaniib kuu yimin dee? Dowan! Kwane ne amob weng kuu yiib mongkodkonombed dakmaniib kuu yimin dee? Dowan! ");
INSERT INTO yon_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Kedi, nembed inamen arewa didangkimain kuyaa kuu yiibbed arud wandembirimaib, kwane ne weng kuu yiibbed wunekare anuk korarimaib. ");
INSERT INTO yon_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Yiib kuu yid bidan wedmaniib kuu karub amun andimaib, kwane yiib kuu nenem kamidan yoom daboknimaib. ");
INSERT INTO yon_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Yiib mongkodkono aombed inamen arewa menebimaan, kwane yiibka yiib ong kuu birandi yeman kerundimaib. ");
INSERT INTO yon_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Yiib kuu yiib ambanga oniya damana yaa manmo keri ye weng dakmimaib, kwane eb ena anam yu dana meed yaa kuu wengamborokbanabimaib. ");
INSERT INTO yon_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Yiib kuu kwamimaib kuned ne kuu iwari keraan. Yiibbed meeniwen kuu God kuu nub areb ande meeniwen. Kumban nembed yiib yaa ongkandeni, yiib yoom kiring ine yiib dowad ambarakmiwen kii ande kangdod weng dakmaniin. ");
INSERT INTO yon_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“Kane kane ne yaa naknod keriwen, yiib kuu weng ke yaa meenime. Kwanaibban kuu nembed ben biringke kurubkurub kamaniin, karub maa yiib ben ma dorondandaanban. ");
INSERT INTO yon_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Kane kane ne yaa eso andi dowad munob bangkawimaan kuu ne aningko kankoonimaib, kwane kane kane yorokmo dobiri ye kiwaan ari doriib kuu nembed bobni yaa ben burudande bindaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. Yembed Batseba yoom nenem kamoone profesiman Natanbed mene ongkanoon kumbed wongkoon. O God, eb womoniyiibban ye mimyob dowaken yaambed mimyob keewe kakman are nonondande. Eb mimyob keendi darewoob kerekmen yaambed ne wabkad kami kuu are kankare. ");
INSERT INTO yon_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Ne arewa kami korem kuu oke dowan kere. Kwane nambarakmi are koroomiibban kai areb kere. ");
INSERT INTO yon_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Kedi, ne wabkad kami kuu wedme nekaadkeraan, kwane nambarakmi kuu ne kiringkono ari angkeen. ");
INSERT INTO yon_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Eb yaamo ambarakmaan, kwane eb indob arimbed miin arewa kamaan. Kowe ne dowad dakmimaab kuu anammo kerimaan, kwane nambarakmi wengyundimaab kuu weng anammo andimaab. ");
INSERT INTO yon_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Kedi, ne kuu woonaan yaambed ambarakmimain, kwane enambed ne nendeen yaron kuu ne kuu ambarakmi ye karub. ");
INSERT INTO yon_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Kedi, eb dowaken kuu nub niindem aom kuu anam anam kumbed yurok andimaab, kwane ebbed meeni kangdom ne niindem aom kedmengkawimaab. ");
INSERT INTO yon_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ambarakmi aari kiwaan ebbed ongmewen yaambed aruwebko niindem aom koroomiibban kera. Kwane ne niindem aom okewebko karadmo dangkorong kera. ");
INSERT INTO yon_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ongmewebko kubi dowakeniib kera. Kwane ne kono ebbed beengkewen kuu ongmebko kubok. ");
INSERT INTO yon_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ne ambarakmi yaa eb murubia kan biknekoreb, nembed arewa kamenabaan korem kuu are kankare. ");
INSERT INTO yon_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","O God, ne niindem aom yeweb karadmo ongme. Kwane ne inamen kuu kangdommo kerune. ");
INSERT INTO yon_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Eb arinambo yaa kuu ne kan angka karaab, kwane eb Kingkin Karadmo ne yaa kuu ebka kandaab. ");
INSERT INTO yon_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Ebbed ongmewebko ebbed nimakarub ben bobni yaa burudande bindi kerekmen yaa ika kuba. Kwane ebbed ne nen angkumoneneb ne yaa inamen nindorokiib kawe. ");
INSERT INTO yon_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Ne yaa kwamebko wabkaddan yaa eb kiwaan kedmengkanda. Kwananiin kuu ambarakmidan kuu amonombe eb yaa anam andaniib. ");
INSERT INTO yon_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","O God, eb kuu ne nen bobni yaa burudande bindi ye God, ne kuu karub ma aye kowaan ye kakman kuu are nonondande. Kwananeeb kuu ne mongkodkonombed eb yorokmo kerekmen dowad kube yook wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","O Yariman, ne mandakad dande. Kwanebko ne mongkodkonombed ewaningko kankooni weng dakma. ");
INSERT INTO yon_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Eb kuu dingkan aye nengke baeb kabdi yaa kuu kubokban, dingkan aye kumundin nengke dene baeb kabdi yaa kangkon eb kubokban, kuyaa kubimaab karen bangkabdimain karen. ");
INSERT INTO yon_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","God ye kubi dowaken keri yeman kuu yiibka kankubuni. O God, kane kane kuu yika kankubunenib God ebbedmo yimin andimaib kuu ebbed yi yaa wunekaraabban. ");
INSERT INTO yon_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Eb kubi dowaken yaambed Saiyon yaa amun kameneb awande. Kwane Yerusalem yu kuuk kuu angkon ika yenbe ongme. ");
INSERT INTO yon_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Kwananeeb kuu yorokmo kerekmen yaambed eb yaa dingkan aye nengke baeb kabdaniiwe kubaneeb, dingkan aye nengke baeb kabdiyiib dingkan aye kumundin nengke dene baeb kabdiyiib kui. Kwane buromakau kuu eb bot wuubimbon arimbed baeb kabdi dowad nengkimamaniib. ");
INSERT INTO yon_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Yook ambo bi ye karub yeman. Maskil ye yook Dewidbed wongkoon. Idomman Doegbed Sauliib yaa wenene yedmenoon, “Dewid kuu Ahimelek yambiwoom wonoon” andoon kumbed wongkoon. Aromkonoman, eb komande arewa kami yaa kerengkan kamimaab? God ye womoniyiibban ye mimyob dowaken kuu amgimombed wene amnoom kwane angkimbirimaan. ");
INSERT INTO yon_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Eb ong kuu monmari yeman nuubnaan kamimaan. Ye kuu yukud ye arud kwane. Eb kuu birandi kerekmen yaambed dakmimaab kui. ");
INSERT INTO yon_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Eb kuu arewa kami yaa dowaken kerimaab, amun kami yaa arebban, kwane eb kuu dudi weng dakmi yaa dowaken kerimaab, weng anam dakmi yaa arebban.Selah ");
INSERT INTO yon_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","O birandi ye karub, eb kuu yewed kondi weng yaamo dowaken kerimaab. ");
INSERT INTO yon_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Kwana kowe, eb kuu eb kombon ambiwoom aromkonomo awine karangkaneeb kumban, Godbed awinebde bingewande biringke biangkande irindore aron korem ye monmarimbon yiri kubunaneen. Eb kuu yembed nen wad doriibdan yi okad arimbed biande koraraneen kui.Selah ");
INSERT INTO yon_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Kwane, yorokmodan kuu wedme unenib ye yaa ambon kamene yedmaniib, ");
INSERT INTO yon_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Karub kee Godbed kukbimaanbon aombed dobirindo, ye kuu ne yiribman yaambed yonene yiminmo dobaraniin andene yena yaa monmari ye kiwaan aromkonomo wonoon.” andaniib. ");
INSERT INTO yon_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Kumban ne kuu God yambiwoom at olif biid awene amun amun kamemoon areb kwane kamiin. Ne kuu God ye womoniyiibban ye mimyob dowaken kuyaambed yone dobaraniin aron korem korem. ");
INSERT INTO yon_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","O God, ebbed komo komo kamenabewen kuyaa kuu aron korem eso andimamaniin, kwane eb kuu amun kowe eb ande meedmaniin, eb karadmodan yi arinambo arimbed. ");
INSERT INTO yon_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Yook ambo bi ye karub yeman. Mahalat ye kiwaan wingki yeman. Maskil ye yook Dewidbed wongkoon. Inameniibbandan kuu yi niindem aom yedmimaib, “Godiibban dowan.” andimaib. Yi inamen kuu nengkidme arewamo kerenib yi dobiri kiwaan kuu miin arewamo, kwane yi korem kuu ma amun kamimokban. ");
INSERT INTO yon_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","God kuu Ewen arimbed nimakarub yaa yiri wedmimaan, kuu karub maa kanembed id anam kaadkerekore God ande onmaneen manok anded. ");
INSERT INTO yon_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Kumban yi korem kuu God yaa angkurom korokbeniwen, kwane yi korem kuu yika yi inamen ben nengkidme arewamo meenimaib. Yi kumaom kuu kane maambed amun kamimokban, korem dowan anam. ");
INSERT INTO yon_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Yembed yedmoon, “Arewa kamidanbed ne nimakarub yeene nongkobiwen, kowe ne nimakarub kuu animan ane dowan keremoon areb keriwen. Arewa kamidan kee ne yaa ma baandindo. Yi kuu ma kaadkeraniiwoo? Dowan!” andoon. ");
INSERT INTO yon_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Yi dobiri yaa kuu uni yemaniibban kumban yi kuu uni miin darewoob keriwen, amborom kuu Godbed ye nimakarub yi bondan yeene nongkobene yi kono kuu ben bokesawaroon. Godbed yi yaa wunekaroon kowe Israeldanbed yi kuu yenbande karak kondiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","O, Israeldan ben yi bondan burudande obon kerundi ye karub kuu aangko Saion arimbed angkadere monok. Kuyaron kuu God ye nimakarub ben obonmo kerunde yiminmo kerundaneen. Kwanoko Yekob ye meed Israeldan dowaken kere kubime. ");
INSERT INTO yon_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Yook ambo bi ye karub yeman. Nongbed wangki yemaniib. Maskil ye yook Dewidbed wongkoon. Sifdanbed Sauliib yaa wene yedmiwen, “Dewid kuu nuwokad aom aomne biknoon.” andiwen kumbed wongkoon. O God, ewaningko yaromkono yaambed ne nen burudande angka kowe. Eb aromkonombed ne dowad ebbed wengyundeneb ma ambarakmindo ande. ");
INSERT INTO yon_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","O God, ne kurikuri weng kee wengambere. Ne mongkodkono aombed ne weng kee wengambere. ");
INSERT INTO yon_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Amborom kuu noroddanbed ne yaa nandamiib, kwane yeremboromdanbed ne nenbande kowi kiwaan onmiib, yi kuu God yaa meenimokban kui.Selah ");
INSERT INTO yon_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Kedi, God kuu ne awawi ye karub, Yariman kuu ne awawaane yiminmo dobirimain ye karub. ");
INSERT INTO yon_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Ne yaa yemyeb darobidanbed ne yaa arewa kamenabi kuu yembed amonombe yi yaa kerundok. God, eb korondiyiibban eweng awinimo dobiri ye kerekmen yaambed yi ben monmarunde. ");
INSERT INTO yon_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","O Yariman, eb yaa nindorokiibbed munob koni yeman kabdaniin. Kwane ewaningko kankoonaniin, amborom kuu eb kuu amunmo kowe. ");
INSERT INTO yon_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Kedi, dabab ne yaa meneboon korem kuu yembed ne nen burudande angka kowoon, kwane wedmaane yembed ne bondan ari boknoon. ");
INSERT INTO yon_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Yook ambo bi ye karub yeman. Nongbed wangki yemaniib. Maskil ye yook Dewidbed wongkoon. O God, ne kurikuri weng kee wengambere. Ne kaamoni keyaa wengamberedandaab. ");
INSERT INTO yon_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","3","Wengamberewekoreb inanduwe. Ne niindem aom dabab kawoon. Bondan yi weng wengambereni, arewa kamidan yi indob nengmoniwen kumbed kirokkarok kere miin yiminban keraan. Amborom kuu yimbed ne yaa durud yewed kawenib, arud wanduwe wungkawimaib kowe. ");
INSERT INTO yon_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Durud yewed kuu ne niindem aom angkeen, kwane bobnaniin ande uniwon karakwon keraan. ");
INSERT INTO yon_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Uniyiib kiringmiyiib kamembirimain, kwane une komyengiib warekandaan. ");
INSERT INTO yon_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Kowe nembed yedmaan, “O, ne kuu on arud areb burawiib karen kimyen wanweneni yiidkaan karen. ");
INSERT INTO yon_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Ne kuu ambab angka kombiri weneni amboon angka dobaraan karen kui.Selah ");
INSERT INTO yon_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Ne kuu kirodmo weneni ne nen kukbimaanbon aom aomnaan karen kui, nuuwa ama darewoob arewa kameen yaa ambab yaambed wanaan karen kui.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","O Yariman, Yerusalem aom wedmaan kuu yeremborom ye inameniib arud wandiyiib menebeen kowe, arewa kamidan kuu ben kerebkarab kerunde. Kwane yi weng dakmi kuu weng maa maa areb kerunde. ");
INSERT INTO yon_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Yi kuu aronkiyiib amkiyiib yenbandem ande kuuk angkara yaa dewinimaib, kwane kuuk aom kuu arud wandembiriyiib damangkandi inameniib angkeen. ");
INSERT INTO yon_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Siti aom kuu monmari ye inamenbed kwane ambangkimaan, kwane siti kiwaan ari kuu benkubune dabab kondi ye inameniib dudenabiyiib kumbed ma korondimokban, kwane dewenebimaib. ");
INSERT INTO yon_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Ne bonmanbed damangkawoon karen, ingkaniyiibban no kwane kandaan karen. Kwane arud wanduwoonman ne yaa manmo keroon karen, ye yaa biknaan karen. ");
INSERT INTO yon_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Nangkodmi amun, ne yoom dabokne yari ye karub kui, eb kuu ne areb kumban, anam kuu ebbed ne yaa manmo keruwewen kii! ");
INSERT INTO yon_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Anuk kuu eb yoom mene kube dabokne yonendimaub, kadaareb numun God ye kurikuri ambib yaa yarimaub yaron arimbed kui. ");
INSERT INTO yon_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Ne bondan kuu kawonwengiibban duknime, kwane wad kumbed bobkonombon yiri kubunime, amborom kuu inamen miin arewa kuu yi niindem aom angkeen kowe. ");
INSERT INTO yon_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Kumban ne kuu God yaa baandaine, Yarimanbed ne nen burudande angka kowimaan. ");
INSERT INTO yon_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Amkimo aronkob oobne kwane ne kuu warekiyiib baandaine, ne weng wengambirimaan. ");
INSERT INTO yon_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Ne yaa bon kere nangbimaib kuu yembed ne nen burudande angka kowimaan, yemoon kuu ne yaa manmo keruwiwen kuned. ");
INSERT INTO yon_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Andowoon yirimbed wene aron korem oonimaan ye God, yembed yi weng wengamberendekore durud yewed kondaneen.Selah Yi kuu yi arewa kami ye inamen yaa ma amonombindo, kwane yi kuu God yaa ma unindo. ");
INSERT INTO yon_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Nangkodmi amun kuu anukbed ye yoom yewenubmo dobiriwendan kuu kibikee yenbandimaan, kwane ye amob weng ongmoon kuu yekareb dookboon. ");
INSERT INTO yon_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Ye weng kuu dabere windane amun amun dakmimaan kumban, ye niindem aom kuu ana nangmi ye inameniib angkeen. Ye weng kuu dabere windane yewenub weng areb dakmimaan kuned, anam kuu ye weng kuu arud kere ana nangmi ye inamen kerundi ye weng kerimaan. ");
INSERT INTO yon_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Yiib dabab kuu Yariman yaa bangkanibko yembed yiib ben angkumone awandok. Yembed yorokmodan kuu domondaane kirobaibban. ");
INSERT INTO yon_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Kuned, o God, arewa kamidan kuu ebbed ben kubudere dem kongdem yiri nongkobe. Kuman yenbandidaniib birandidaniib kuu yi wad dobiri yaron kuu wedyambed naraneewa duknaniib. b Kumban ne kuu eb yaambed yone dobaraniin. ");
INSERT INTO yon_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Yook ambo bi ye karub yeman. “On Arud At Amaan Angka Dibeen” ye yook ye kiwaan yaambed wingki yeman. Miktam ye yook Dewidbed wongkoon. Filistiadanbed Gat angkambed awinenoon kumbed wongkoon. O God, karub yenambed ne nande kerewenmo yarimaib, kwane yimbed aronki doboob ne nenbandande kamimaib kowe, ne yaa mimyob keeweneb awawe. ");
INSERT INTO yon_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Ne bondan kuu aronki doboob ne nande kerewenmo yarimaib, kwane yemoon kuu kerengkanbed ne nenbandenmo yarebimaib. ");
INSERT INTO yon_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Ne unaniin kuu eb yaambed yone dobaraniin. ");
INSERT INTO yon_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","God yaa kui, ye weng yaambed kubimain. God yaambed yone dobirimain kowe, ma unainban. Duknaniib ye nimakarubbed ne yaa komo kamaniib kuyaa meenainban. ");
INSERT INTO yon_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Aronki doboob kuu ne weng kuu yimbed ben nengkidme weng arewa keruwimaib, kwane yi kuu ne yaa nuubnaan kamembirimaib. ");
INSERT INTO yon_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Yi kuu wunonwanon kamenib yemyeb darobenib ne yarebi korem yaa keewombirimaib, ne dowad nindorokiibbed ayem ande kaimaib. ");
INSERT INTO yon_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","O God, korondaawa yi kirokmone wanaib. Kwane noroddan, ne bondan kui, yi kuu eb norin aombed ben kubune. ");
INSERT INTO yon_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Ne kirokkarok kamimain kuu wongkewen. Kwane ne inok wanabi kuu eb awong aom kambungkewen. Korem kuu eb buk aom kowewenoo? Anamaa. ");
INSERT INTO yon_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Nembed awawe ande baandaniin kuu ne bondan kuu ika angkurom korokbe korondaniib. Kwane wedmeni nekaadkeraniin kuu God kuu ne dowad doreen kii. ");
INSERT INTO yon_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","God yaambed yone dobirimain kii, ye weng kuu amunmo andimain. Yariman yaa kui, ye weng kuu amunmo andimain. ");
INSERT INTO yon_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","God yaambed yone dobirimain kowe, ma unainban. Nimakarubbed ne yaa komo kamaniib kuyaa meenainban. ");
INSERT INTO yon_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","O God, ne kuu eb yaa amob weng ongmaan kumbed kwane ambangkaniin. Eso ande munob koni yeman kuu eb yaa bangkabdaniin. ");
INSERT INTO yon_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Amborom kuu ebbed ne nen bobni yaa burudande angka kowewen. Kwane ebbed ne yon kuu boknande kombaraan ande awawewen. Kwanewen kuu eb arinambo arimbed dodkanmo wonok andewed, wad doriibdan yaa yuroon ye nambiri aombed. ");
INSERT INTO yon_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Yook ambo bi ye karub yeman. “Monmaraib” andi ye yook ye kiwaan yaambed wingki yeman. Miktam ye yook Dewidbed wongkoon. Saul yaa kombiri wenene aangko dem aom biknoon kumbed wongkoon. Mimyob keewe. O God, mimyob keewe. Komoyiibkob, ebbed kukbimaabbon aombed dobirimain. On ayam yu dongkon dem areb ebbed kukbimaabbon aombed dobaraniine wene neene monmari yaron dowan keranuun. ");
INSERT INTO yon_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Korem Burudandoon Arimbed Ye God yaa baandimain, ne dowad dowakeniib kere ambangkaane idiib kerimaan ye God yaa kui. ");
INSERT INTO yon_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Yembed Ewen arimbed inanduwe ne nen burudande angka kowimaan, ne nande kerewenmo yarimaibdan yaa ongkandimaan.Selah Godbed ye womoniyiibban ye mimyob dowaken keewimaan kwane ye weng ne dowad yedme kowoon kuu korondimokban awinimaan. ");
INSERT INTO yon_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Ne kuu laiyon yi kidaom keraana kanawanewandiwen kii. Kwane ne kuu karub yeene komkad animaib ye dingkan yi numun angkaan. Kukuu ne bondan kui, yi ningkambo kuu maradiib anayiib yi arud areb, kwane yi ong kuu kerewang ye arud areb. ");
INSERT INTO yon_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","O God, Ewen burudande ewaningko ariyiib kerok, eb nambiri kuu okad korem yaa yurok. ");
INSERT INTO yon_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Ne bondan kuu ne yon dowad oon bi ye men kande kiwaan yaa kurune kebenimaib, kwane ne kuu miin kubiyiibban aromkonoyiibban keraan. Yimbed ne kiwaan yiri kuu dem nidkiwen kumban, yika yikareb yi dem nidkiwen yiri kirobiwen.Selah ");
INSERT INTO yon_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Ne niindem aom kuu kiringmiyiibban kangdommo, o God, ne niindem aom kuu kiringmiyiibban kangdommo kui. Ne kuu yook wingkeni kuwengiib ongmaniin. ");
INSERT INTO yon_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","O ne kingkin, yaro dembe! Haap yoom laiya yoom yaro dembime! Yiiwiib wangke wingkani aron kakmendaniine awawini nambere wananuun. ");
INSERT INTO yon_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","O Yariman, ne kuu ambibkin korem aombed ewaningko kankoonaniin, kwane ne kuu ambibkin maa maadan aombed eb dowad yook wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Amborom kuu eb womoniyiibban ye mimyob dowaken kuu miin darewoob kai, kukuu kawene Eweniib badmene durunoon, kwane eb anam anam kuu ambid ariyiib kawene badmene durunoon kii. ");
INSERT INTO yon_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","O God, Ewen burudande ewaningko ariyiib kerok, eb nambiri kuu okad korem yaa yurok. ");
INSERT INTO yon_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Yook ambo bi ye karub yeman. “Monmaraib” andi ye yook ye kiwaan yaambed wingki yeman. Miktam ye yook Dewidbed wongkoon. O aromkonomo oonidan, yiib kuu weng yorokmo dakmimaiwoo? Yiib kuu nimakarub yaa anammo wengyundimaiwoo? ");
INSERT INTO yon_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Dowan! Yiib niindem aom kuu yorokmomban unitab ye inamen ongmenabimaib, kwane yiib dingkimbed yeremborom ye inamen yaambed okad yiridan yaa ambangkimaib. ");
INSERT INTO yon_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Arewa kamidan kuu yi wooniwen yirimbed kwane abdon yaa winimaib, yi dana mana yaambed kwane wabkad kere dudanabimaib. ");
INSERT INTO yon_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Yi weng ambod kuu niin ye ambod arewa kwamune areb. Yi kuu weng amun yaa kened warudki areb kerenib niinbed domonande kaimaib areb kerimaib. ");
INSERT INTO yon_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Yi kuu yi korok korok yi weng yaa ma meenimokban, korok korok miin amun kuned. ");
INSERT INTO yon_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","O God, yi mongkodkono aom ningkambo kuu wowe domangke. O Yariman, yi kuu laiyon ye ningkambo yidkangiib areb kowe yi arud yeman domangke ben kiradme. ");
INSERT INTO yon_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Yi kuu domondebko, ok keekne dowan keremoon areb kerime. Kwane yi ana baradmibka, yi anamo dingkanabok. ");
INSERT INTO yon_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Yi kuu dudubkorokbed ema irin wanaane okmo keremoon areb kerime. Bob dana woonimaib kwane aron nambiri wedmokban kerime. ");
INSERT INTO yon_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Atok kokiib o okiib kumbed nengkaiwe dini yeman amot yumbu ari nowaiwe nimin kerindo mokaid areb, arewa kamidan kuu kirodmo are ben kiradmaneen. ");
INSERT INTO yon_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Yorokmodan yi dowad arewa kamidan keyaa kwane ingkandaneen kuu kubaniib, yorokmodan kuu arewa kamidan yi umkan aom yi yon okaniib kumbed kubaniib kui. ");
INSERT INTO yon_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Kwananeene nimakarubbed yedmaniib, “Anam kuu yorokmodan kuu kakman amun bangkandimaan, anam kuu okad yiridan wengyundi ye God kuu doreen kii!” andaniib. ");
INSERT INTO yon_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Yook ambo bi ye karub yeman. “Monmaraib” andi ye yook ye kiwaan yaambed wingki yeman. Miktam ye yook Dewidbed wongkoon. Saulbed Dewid aye kowime ande karub ben nongkoboona wene ye ambib yaa kerenombiriwen kumbed wongkoon. O God, ne bondan yaambed ne nen burudande angka kowe. Ne yaa manmo keriwendan kuu ebbed dorondaruwe. ");
INSERT INTO yon_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Arewa kamidan yaambed ne nen burudande angka kowe. Kwane kuman yenbandidan yaa kuu ebbed dorondaruwe. ");
INSERT INTO yon_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","O Yariman, kedi, yi kuu ne nande bikne dibo meedmiib kuu wedme! Naawonmo yenbandidan kuu ne dowad nuubnaan kamiib kii, ne yi yaa ma wabkad kerindo o ma ambarakmindo kuned. ");
INSERT INTO yon_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Ne kuu ma ambarakmindo kumban yi kuu ne nande nekwiwen. Kowe, awawi dowad yaro dembe. Dabab ne yaa kee menebeen kuu wedme. ");
INSERT INTO yon_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","O ana nangmidan yemoon ye Yariman God, Israeldan yi God kui, ebkareb yaro dembeneb ambibkin korem yaa dabab konde. Kwane ambodangidan arewa yaa mimyob keendaab.Selah ");
INSERT INTO yon_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Yi kuu oobne yaambed ika mene anon yi norin ningkiad kowemoon areb kerenib, siti aom yenbandande onmenmo dewenebimaib. ");
INSERT INTO yon_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Yi mongkodkono aombed wiin kami areb weng arewa menebe dakmimaib kuu wedme. Yi ong kuu kerewang areb, arud weng dakmimaib kui. Kwane yimbed yedmimaib, “God kuu nub weng wengambirimokban.” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Kumban, o Yariman, ebbed yi yaa ambon kamendimaab, kwane ambibkin koremdan kuyaa ambon baandimaab. ");
INSERT INTO yon_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","O God, ewaromkono kumbed eb yaa angkumone doriin, eb kuu ne dore aromnimbon. ");
INSERT INTO yon_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Ne God kuu ye womoniyiibban ye mimyob dowaken yaambed neyiib yaa mene durunewaneen. Kwane yembed ne bondan burudande doraneene wedmaniin. ");
INSERT INTO yon_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Kumban, o Yariman nub dorondandi ye karub, yi kuu bobmo yenbandaab. Yeene nongkobaneeb kuu ne nimakarub kuu eb bondan yaa ukum kondewen kuu nonondandaniib. Ewaromkonombed ben kubudere ongmendebko kirinwan yarime. ");
INSERT INTO yon_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Yi mongkodkono aombed menebimaan kuu ambarakmi yeman, yi weng dakmi kui, kuu kwamunemo kowe, yi kerengkan kami kuyaambed yi arewa kami kuu korokbende. Yi kuu budun kamiyiib dudanabiyiib dakmimaib kowe, ");
INSERT INTO yon_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","arud wande yenbandebko dowan kerime. Kwane yenbandebko korem dowan kerime. Kwananeeb kumbed okad yimin yimin yaa kuu yikaadkere Godbed Yekob ye awoya ari yaa kuu oonimaan andaniib.Selah ");
INSERT INTO yon_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Yi kuu oobne yaambed ika mene anon yi norin ningkiad kowemoon areb kerenib, siti aom yenbandande onmenmo dewenebimaib. ");
INSERT INTO yon_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Yi kuu animan anande kirinwe dewenebimaib, kwane mikmonindo kerimaan kuu anon keeng areb kabang angkimaib. ");
INSERT INTO yon_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Kumban ne kuu ewaromkono ye dowad yook wingkaniin, kwane amkimo kuu eb womoniyiibban ye mimyob dowaken ye dowad kube wingkaniin, amborom kuu eb kuu ne dore aromnimbon, kwane dabab ne yaa menebimaan kuu ebbed kukbimaabbon aombed dobirimain. ");
INSERT INTO yon_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","O ne aromkono kawi ye karub, ewaningko kankoonaniin. O God, eb kuu ne dore aromnimbon, eb kuu ne yaa womoniyiibban ye mimyob dowaken keewimaab ye God. ");
INSERT INTO yon_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Yook ambo bi ye karub yeman. “Amob Weng Ye Bingko Wuung” ye yook ye kiwaan yaambed wingki yeman. Miktam ye yook Dewidbed wongkoon. Kedmengkandi yeman. Yembed Aramdan Naharaimiib Sobayiib yaambed miniwen yaa nangboona Yoab ikakman menene Karam Dabon kan kubuneen yiri Idomdan 12 tauseniib yenbandoona dukniwen kumbed wongkoon. O God, eb kuu nub yaa wunekarundekoreb mene boketawarewen. Kwane eb kuu nub yaa arud wandewen kumban, kibireb kee nuwiib yaa ikakman mene amun kerunde. ");
INSERT INTO yon_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Ebbed okad kuu nan yobeewa domokbe nandeen. Okad kuu nandeen kowe, ebbed okad bunge bangkanaboon kuu ongmebko amun keruk. ");
INSERT INTO yon_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Eb nimakarub yaa kuu yobdood aron kondewen, kwane ebbed wain okbed awarak ayemoon areb komborok komborok dodkanmo wini ye dabab nub yaa kondewen. ");
INSERT INTO yon_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Kumban kane kane yi kuu eb yaa une bumangkimaib kuu “Neyiib yaa minime” andewen, bondan yi ana yaambed kirokmoni ye dowad.Selah ");
INSERT INTO yon_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Nub inandundeneb eb dingki wiwimbed nub ben burudande angka nongkobe. Kwananeeb kuu eb mimyob dowaken keendimaabdan nub kuu dabab yaa koronde yewenubmo dobaranuub. ");
INSERT INTO yon_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","God kuu ye karadmombon aombed yedmoon, “Nembed ne bondan burudande doreni, okad Sekem kuu ne nimakarub yaa numbere kondaniin, kwane Sukot dabon yiri kwangkon nekwane kumunkingkaniin, numbere kondi dowad. ");
INSERT INTO yon_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Gilead kuu neman, Manase kwangkon neman, Efraim kuu ne topi kamkono, Yuda kuu ne king yaromkono yobdoodmo ooni yeman. ");
INSERT INTO yon_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Moab kuu ne dingki oki yeman ye kobukmo yabad. Idom ari kuu ne yonkad koraraan. Filistia ari kuu nembed burudande doraan kumbed komkaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Kanembed ne nen siti bot kuukiib aom aomnaneen? Kanembed ne nen ambibkin Idom aom wananeen? ");
INSERT INTO yon_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","O God, ebbedmo yimin. Eb komande nub wunekarundewen? O God, eb komande nub ana nangmidan yoom wanaibban? ");
INSERT INTO yon_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Nub bondan yaa nangmi dowad nub awande, amborom kuu karub ye aromkono awandaniiwe nangmanuub kuu korem yiminban. ");
INSERT INTO yon_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Nub kuu Godiib kumbed burudande doranuub, kwane yembed nub bondan ari dorene ben kubunaneen. ");
INSERT INTO yon_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Yook ambo bi ye karub yeman. Nongbed wangki yemaniib. Dewid ye yook. O God, ne baandi kee wengambere. Ne kurikuri weng kee wengambere. ");
INSERT INTO yon_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Ne kuu okad yimin yimin yaambed eb yaa baandimain. Ne niindem aom bobne kombirikin keroon kumbed eb yaa baandimain. Ne nen kinbanmo dumnad ambab ne arebban ari nen wene. ");
INSERT INTO yon_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Kedi, eb kuu ne kukbimaabbon, eb kuu bondan yaa kukbiri ye boyambib kongam aromkonoyiib kui. ");
INSERT INTO yon_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Ne dowaken kuu eb kurikuri ambib kombon aombed aron korem dobara. Kwane eb buraab dabderem aombed ne kukbimaabbon kerande meenaan.Selah ");
INSERT INTO yon_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","O God, ne amob weng ongmenabaan kuu ebbed wengamberewen, kwane kane kane eb yaa une bumangkiwen yi yumbon ongmewen kuu ne yaa kangkon kawewen. ");
INSERT INTO yon_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","King ye wadkeri ye aron kuu irinari daane. Ye weeb kuu yawoya yemoon yeman kerok. ");
INSERT INTO yon_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Ye kuu God ye kerebiri arimbed aron korem oone diborok. Eb womoniyyibban ye mimyob dowakeniib anam anamiib kuu ye yaa dorondari yeman ongmene. ");
INSERT INTO yon_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Kwananeeb kuu nembed ewaningko kankoone wingkeni aron mimim kuu ne amob weng ongmenabaan yaamo kamembaraniin. ");
INSERT INTO yon_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Yook ambo bi ye karub yeman. Yedutun ye dowad. Dewid ye yook. Ne kingkin kirokkarok kami kuu God yaambedmo dowan kereni yewenub kerimain, ne nen burudande bindi kiwaan kuu yembed ongmoon. ");
INSERT INTO yon_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Yembedmo kuu ne aromkonombon kwane angkon ne nen burudande angka kowi ye karub, kwane ye kuu ne dore aromnimbon kowe, ne kuu yenambed ma nen kiringmaibban. ");
INSERT INTO yon_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Yiib kane? Aron komoyiib ne nenbandande kamimaib? Ne kuu kuuk dandemoon areb o ambib nandande kamemoon areb aromkonoyiibban kuned, yiib korem kuu ne nen yiri koraraniib dee? ");
INSERT INTO yon_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Yi inamen darewoob kuu nembed deme yumbon ari kai kandaan dowadbed ne nen yiri kubunandamiib. Yi dowaken darewoob kuu dudanabi, kwane amun kerundi weng dakmimaib kumban yi niindem aombed arewa kerundande meenimaib.Selah ");
INSERT INTO yon_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","O ne kingkin, eb kirokkarok kami kuu God yaambedmo dowan kereneb yewenubmo kere. Amborom kuu yembed kwananeen andi ye inamen kuu ye yaambed minimaankob kandimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Yembedmo kuu ne aromkonombon kwane angkon ne nen burudande angka kowi ye karub, kwane ye kuu ne dore aromnimbon kowe, ne kuu yenambed ma nen kiringmaibban. ");
INSERT INTO yon_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Ne nen burudande bindi kiwaan angkon kwane aningko amun arimbed kandaan kuu God ye yaambedmo, kwane ye kuu ne aromkono kaimbon kwane ne nen kukbimaanbon. ");
INSERT INTO yon_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","O nimakarub, aron korem ye yaambed yone doberembirime. Yiib niindem aom kuu komo komo dabawiib keriwen kuu ye yaa daanime, amborom kuu God kuu nub ben kukbimaanbon.Selah ");
INSERT INTO yon_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Kubuniibban kumbed wooniwendan kuu meeni yemanban, aningko darewoob ariyiib kumbed wooniwendan kwangkon id keri yemanban. Yi dabab kuu awine wedmanuub kuu God ye kerekmen yaambed kuu dowan kai, yi korem kuu inum nimaub kwane arebmo. ");
INSERT INTO yon_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Idiibbanbed dedmone od kawe andi ye inamen kuyaambed yone dobaraib, kwane yid bimaib ye yiribman kuyaa kerengkan kamaib. Yiib yiribman yemoon kuu ari kere winibko kuyaa meendobe kuyaamo kowaib. ");
INSERT INTO yon_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Godbed weng keyiib kee mimo dakmoon, kwane weng ayoob wengambaraan kuu kei, o God, eb kuu aromkonoyiib, ");
INSERT INTO yon_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","o Yariman, eb kuu womoniyiibban mimyob dowaken keendimaab. Anam kuu ebbed nimakarub mimim korem yaa komarewa ambangkaniib kuu kwamunemo kakman inande kakman bangkandaneeb. ");
INSERT INTO yon_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Dewid ye yook. Yuda amboon aom doboroon ye dowad wongkoon. O God, eb kuu ne God, nindorokiibbed eb ande kerekberenmo yarimain, kwane ne kingkin kuu ok moom bobnemoon areb kerimain, kwane ne id kuu eb ande awawe andimaan, koknenu wuudne yiminban ye okad aombed kui, okiibban ye okad aombed eb ande kerekberenmo yarimain kui. ");
INSERT INTO yon_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Eb kurikuri ambib aombed wedmebdeni, eb aromkonoyiib nambiriyiib wedmaan. ");
INSERT INTO yon_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Eb womoniyiibban ye mimyob dowaken kuu darewoob arimbed, kuyiibban kumbed nub kuu wad dobirindeban kowe, ne mongkodkonombed ewaningko kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Ne wad dobaraniin ye aron korem kuu eb yaa amun kerubdimamaniin, kwane ne dingki benkoobeni eb yaa kurikuri kamimamaniin. ");
INSERT INTO yon_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Ebbed animan ambod miin amun yeman bangkawaawe ane mikmonimain, kwane wingkanabiyiibbed ewaningko kankoonimain. ");
INSERT INTO yon_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Ne angki arakbon arimbed eb yaa meenimain, kwane miriknimaanbed wene aron dembe yurimaun kuu eb yaa kabakimain. ");
INSERT INTO yon_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Eb kuu ne awawimaab kowe, eb dingki kurumbon aombed kube wingkimain. ");
INSERT INTO yon_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Ne kuu eb yaa kine angkanaan, kwane eb dingki wiwimbed awawaawe yiminmo dobirimain. ");
INSERT INTO yon_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Kane kanembed ne neene kowi ye kiwaan onmiib kuu ben monmarundaneen, yi kuu ben bobkonombon yirimbed mangkaneen. ");
INSERT INTO yon_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Yi kuu kerewangbed yenbandaneene duknaniiwe, dura anon yi animan keraniib. ");
INSERT INTO yon_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Kumban king kuu God yaambed kubaneen, kwane kane kanembed God yaningko yaambed amob weng ongmaniib kuu yi korem kuu ye aningko kankoonaniib. Kumban dudanabidan yi mongkodkono kuu kebenendaneen. ");
INSERT INTO yon_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Yook ambo bi ye karub yeman. Dewid ye yook. O God, dabab kandaan ye weng dakmaan kee wengamberewe. Bondanbed ne yaa nande arewa kamiib yaa kee dorondaruwe. ");
INSERT INTO yon_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Arewa kamidanbed nenbandande nuubnaan kami yaa kuu ne nen kimyen yaa kowe, yi yirinde baandi yaa kui. ");
INSERT INTO yon_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Yi weng arud dakmi kuu kerewang areb, kwane yi weng kookiib kuu ana areb dedmone dakmimaib. ");
INSERT INTO yon_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Yi kuu yenbandi ye biknimbon yirimbed ma ambarakmindoman yaa monbenimaib, kwane yi kuu uniyiibban kenambun kwane monbenimaib. ");
INSERT INTO yon_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Yikareb wunonwanon kamem andi ye weng ongmimaib, yimbed kawaad nong nongkobe bikderebiwen ye dowad dakmimaib, “Kwane kanembed wedmendaneen? Dowan!” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Yi kuu wunonwanon kamenib yedmimaib, “Inamen ongmuwen kuu demkoronmo kii!” andimaib. Anam kuu nimakarub yi niindem aom meeni kuu karub maambed wedmindeban. ");
INSERT INTO yon_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Kumban Godbed yi yaa anambed amkandaneen, kudmeniibban yi kuu yeene ben yiri kiradmaneen. ");
INSERT INTO yon_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Yi weng arewa kuu yika ikakman mene arewa kerundene monmaraneen, kwane yi yaa wedmendaniibdan korem kuu korok waaburukme ambon kamendaniib. ");
INSERT INTO yon_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Kwananeene nimakarub korem kuu unaniib, kwane yi kuu Godbed kwane ambangkoon yaa dakmenabenib, kuyaa konomdangmo meenembaraniib. ");
INSERT INTO yon_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Yorokmodan kuu Yariman yaambed kubenib, yembed kukbimaanbon aombed dobaraniib. Kane kane yi niindem aom kangdommo doriib kuu ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Yook ambo bi ye karub yeman. God yaningko kankooni ye yook. Dewid ye yook. O God, Sayion aom kuu ewaningko kankooni deme angkeen, kwane eb yaa amob weng ongmenabuwen kuu kwane id keraneen. ");
INSERT INTO yon_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","O kurikuri kami yaa wengambirimaab ye karub, eb yaa nimakarub korem kuu menebaniib. ");
INSERT INTO yon_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Ambarakmenabuwen kumbed meendobi darewoob kere miin yiminban keruwen kuu ebbed nub ambarakmi are nonondandewen. ");
INSERT INTO yon_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Kane kane ebbed kingkeneb eb kurikuri ambib ye kuuk aom dobiri dowad dia ben menebewen kuu amun kerundoon kii! Eb kurikuri ambib ye amun amun kuu nub yaa miknemoon areb kerundoon, eb kurikuri ambib karadmo yaambed kui. ");
INSERT INTO yon_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","O God nub ben burudande bindi ye karub, ebbed yorokmo ye ambangki binangki yeman kumbed nub yaa inandundimaab. Eb kuu okad yimin yimin yaa doriibdan korem yi awandaneeb andi ye karub, karamok ari motodbed yarebimaibdan yi kangkon. ");
INSERT INTO yon_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Ebbed aangko ongmenabewen kuu ebka eb aromkonombed, ebka eb aromkono inwarewen kumbed kwanewen. ");
INSERT INTO yon_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Karamok beengkanabiib kuu ebbed ongmaawa kurune angkimbirimaun, kuu ok umbak beengkanabiib kui. Ambibkin maa maa korem kwangkon yi yirinde baande kuu ongmaawe kurune yemyeb kerimaib. ");
INSERT INTO yon_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Ambab angka doriibdan kuu eb kami yeka mamaa yaa binangkiwen. Ebbed komo ambangkewen kumbed aron dembimaun angka ye okaddaniib aron kubunimaun angka ye okaddaniib kuu eb dowad kube baandimaib. ");
INSERT INTO yon_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Ebbed okad oonendeneb ok kondimaab, kwane id iri yeman yemoon bangkandimaab. O God, eb ok awaan kuu yiminmo dembeen, nimakarub yi yongbon id yemoon bangkandi dowad, amborom kuu ebbed kwanok ande yedmewen kowe. ");
INSERT INTO yon_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Ebbed am bangkandimaab kowe, yi yongbon kidbon yiri bid benkubune wuneen yiri kuu okmanambon areb keraune, mongkobon aangko kuu ben kubunebaune, kab kibingkiwen yokad kuu yawinok keraune, idiib irimaun kuu ebbed amun kerundimaab. ");
INSERT INTO yon_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Weeb mimim aom kuu yongbon kuu ebbed ongmaawe animan yemoon kaimbed wandimaib, kwane kuna kuna wenebimaab kuu animan id yiminmo kerundimaab. ");
INSERT INTO yon_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Dura angka kuu animan id yiminmo, kwane koodbon koodbon yaa kuu kubimo. ");
INSERT INTO yon_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Dura ye kereekbon kuu dingkan kab yewuudmo anengkanan yarebiib, kwane dabon kankubuneen yiri kuu animan id keene wonoon, kwane yi kuu kube baandimaib, ee, kube wingkimaib. ");
INSERT INTO yon_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Yook ambo bi ye karub yeman. Yook, God yaningko kankooni yook kui. Okad yiridan korem, God yaa kubenib komkime! ");
INSERT INTO yon_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Yaningko ye nambiri ye dowad wingkime, yaningko kankoone nambiri konime! ");
INSERT INTO yon_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","God yaa yedmime, “Ebbed ambangkanabewen kuu yeka mamaa yoo! Eb aromkono kuu miin darewoob kowe, eb bondan kuu unebde ika anuk irinambenimaib. ");
INSERT INTO yon_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Okad yiridan korem kuu eb yaa bumangkenib, eb yaa kube wingkimaib, ewaningko kankoone wingkimaib kui.” andime. Selah ");
INSERT INTO yon_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Godbed komo kamoon kuu mene wedmime. Nimakarub yi dowad yembed ambangkoon kuu yeka mamaa yoo! ");
INSERT INTO yon_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Yembed karamok kuu yedmoone andokbe okad kamkonombon kereen, kwane yine anuk kere ari kere keruuna yi kuu wedyirimbed yonka winiwen. Kowe, yiib minibko ye yaa kubem. ");
INSERT INTO yon_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Ye aromkonombed aron korem oonimaan, kwane ye indob kuu ambibkin koremdan yaa keendombirimaan. Kowe, wabkaddan kuu ye yaa bon keraib.Selah ");
INSERT INTO yon_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","O ambibkin koremdan, nub God yaningko kankoonem, kwane yaningko kankooni ye kuweng derendaroko yemoon kuu wengambirime. ");
INSERT INTO yon_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Yembed nub oonendoone wad doburuwen, kwane yembed nub ongmendoone nub yon kuu kereeb beresare kombirindo. ");
INSERT INTO yon_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","O God, ebbed nub yaa komboon kaamobendewen, kwane bot silvaa nengke yankorenmo kerok andemoon areb ebbed nub kuu darobendewen. ");
INSERT INTO yon_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Ebbed nub kuu oon bi ye men aombed bemoon areb kerundewen, kwane ebbed nub angkurom angka dabab nongkobewen. ");
INSERT INTO yon_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Ebbed karub yedmeewa yi hoos arimbed nub korok ari dore beengkanmo dewiniwen, kwane nub kuu amoyiib urokiib aom awune dewunuwen, kumban ebbed nub kuu benmene yiminmo kerundewen. ");
INSERT INTO yon_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Ne kuu dingkan nengke agedmo kere baeb koni yemaniib eb kurikuri ambib yaa benmeneni, amob weng ongmaan kuu kwananiin. ");
INSERT INTO yon_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Kukuu anukbed ne yaa dabab monoone, ne mongkodkonombed dakme ongme kowaan yeman kui. ");
INSERT INTO yon_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Nembed dingkan kowiib yeene nengke baeb eb yaa bangkabdaniin, sibi ambiyiib buromakau ambiyiib naningkod ambiyiib munob bangkabdaniin.Selah ");
INSERT INTO yon_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Kane kane God yaa bumangke unimaibdan, yiib kuu mene wengambirime. Kwanibko yembed ne dowad komo kamoon kuu yiib yaa yedmenda. ");
INSERT INTO yon_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Ne mongkodkonombed ye yaa baandaan, kwane ne ongbed yaningko kankoonaan. ");
INSERT INTO yon_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Ne niindem aom ambarakmi inamen yaa kube amuknaan kuu anam keraneen kuu, Yariman kuu ne yaa wengamberewaanban. ");
INSERT INTO yon_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Kumban anam kuu God kuu ne wengamberewoon, kwane ne kurikuri ye yaa kuu wengamboroon. ");
INSERT INTO yon_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","God yaningko kankoonem, ne kurikuri weng wunekarindo, kwane ne yaa ye womoniyiibban ye mimyob dowaken keewoon kuu anwandindo kowe. ");
INSERT INTO yon_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Yook ambo bi ye karub yeman. Nongbed wangki yemaniib. Yook, God yaningko kankooni yook kui. God, eb nub yaa mimyob keende amun kerunde, eb murubia kuu nub yaa konde.Selah ");
INSERT INTO yon_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Kwananeebkob eb dowaken okad yiri ye ambibkin koremdan yaa kuu yikaadkeraniib, kwane ambibkin korem kuu bobni yaa burudande bindi ye kiwaan ebbed ongmewen kuu wedme yikaadkeraniib. ");
INSERT INTO yon_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","O God, ewaningko kuu ambibkin koremdan kankoonime, ambibkin koremdan kuu ewaningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Ambibkin koremdan kuu kubenib kubi yookiib wingkime, amborom kuu ebbed nimakarub korem yaa kuu kangdommo wengyundeneb, okad yiri ye ambibkin koremdan kuu ebbed ben kinban winimaab kowe.Selah ");
INSERT INTO yon_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","O God, ewaningko kuu ambibkin koremdan kankoonime, ambibkin koremdan kuu ewaningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Okad kuu animan kab ire amnoon, God, nub God, yembed nub yaa amun kerundoon kui. ");
INSERT INTO yon_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Godbed nub yaa amun kerundoon, kowe okad kunaya kunaya nimakarub korem kuu ye yaa bumangke unaniib. ");
INSERT INTO yon_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Yook ambo bi ye karub yeman. Dewidbed wongkoon. Yook, God yaningko kankooni yook kui. God yaro dorok. Ye bondan kuu buyokbayok kerime, kwane God yaa arud wandembiridan kuu ye yaa kirokmone wenebime. ");
INSERT INTO yon_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Amareng nuubbed awune kanwenemoon areb kuu, ebbed eb bondan ben wuurewarebko wenebime. In kuu amot ye niminbed dene okmo keremoon areb kuu, arewa kamenabidan kuu God ye arinambo ari ben monmaroko duknime. ");
INSERT INTO yon_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Kumban yorokmodan kuu dowakenmo kerenib, God ye murubia ari kubime, kwane yi kuu kube ningyak kowime. ");
INSERT INTO yon_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","God yaa yook wingkime, yaningko kankooni yook wingkime. Wiib arimbed seriot areb yarimaan ye God yaningko kankoonime. Ye aningko kuu Yariman, ye arinambo arimbed kubime. ");
INSERT INTO yon_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Ye kuu anenabdan yi ambe, kwane ye kuu iribdan yi dowad yorokmo wengyundi ye karub, kukuu God ye kowe yambib karadmo aom dibeen kui. ");
INSERT INTO yon_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Godbed karubkimiibban obon keriwendan be karubkimiib ongmimaan, yenambed yenbande ben wii aom kamobiwendan kuu yembed ben angka nongkobaane yookiib wingkenabe wenebimaib. Kumban wabkaddan kuu koknoon amiibban ye okad aom dobirimaib. ");
INSERT INTO yon_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","O God, ebbed eb nimakarub bin yeederekoreb, amiibban ye amboon angka dewenewen kuu,Selah ");
INSERT INTO yon_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","okad kuu kiringmeena, ambid arimbed amiib kubuderebeen, God, aangko Sainai ye God monoon kowe, God, Israeldan yi God kui. ");
INSERT INTO yon_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","O God, ebbed am yiminmo kondewen, kwane ebbed Israeldan yaa kondewen ye okad koknoon kuu yiminmo ongmewen. ");
INSERT INTO yon_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Kwaneewe eb nimakarubbed kwaom ambib yenbekorib dobiriwen. O God, eb yiminmo kerundi yaambed kwane kamboknondan yaa bangkandewen. ");
INSERT INTO yon_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Kwane, Yarimanbed weng yuk kowoona, nima yemoon kaimbed kan yare daandiwen kukei, ");
INSERT INTO yon_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","ana nangmidaniib yi kingdaniib kuu kirokmoniwen, kedi kirokmoniwen kii, kowe nima ambiwoom dibiib kuu king king yaa nangbe boon ye yiribman be wenorekorib numbere yi mimim biwen, kui. ");
INSERT INTO yon_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Yiib yena kuu sibi yaa oonimbon aombed no unuk dangiwen, kumban odamod maa kei, on arud kuruwak bot silvaambed yone ongmiwen, kwane yu buraab kuu od gold kawurimbonbed yone ongmiwen. ");
INSERT INTO yon_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Aromkonomo Ye Godbed kingdan kuu be buyokbayok kamoon kuyaron kuu, aangko Salmon arimbed wiiwam kubudoroon areb keriwen. ");
INSERT INTO yon_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Okad Basan yu aangko aangko kuu manimanandeb, kwane okad Basan yu aangko aangko kuu aangko kongam ingkiringangkarangbon. ");
INSERT INTO yon_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","O aangko kongam kongam, yiib komande wungkande nengmone doriib, Godbed kwarimbed ooni dowad kinoon ye aangko yaa? Kuyaa kuu Yariman yeka aron korem doberembaraneen kui. ");
INSERT INTO yon_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","God ye seriot kuu yewudmo, ye kuu seriot tausen yemooniib, kwane Yariman kuu Sainai arimbed menemoon areb karadmo mene wedaom doboroon. ");
INSERT INTO yon_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Ebbed ari daanewen kuu nangme awinendiwendan kuu ebbed kinban weneewe eb yomanmo winiiwe, munob bangkandi yeman kuu karub yenambed bangkabdiwen, wabkaddan yi kwangkon bangkabdiwen. O Yariman God, kwanewen kumbed eb kuu kwari dobara andewed. ");
INSERT INTO yon_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Yariman, nub ben bobni yaa burudande bindi ye God, ye yaa amun kerunem, ye kuu nub dabab kuu aron mimim kankarinimaan kowe.Selah ");
INSERT INTO yon_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Nub God kuu bobni yaa burudande bindi ye God, Yariman Ambengkan yaambed bobni yaa burudande obon kerundi ye kiwaan angkeen. ");
INSERT INTO yon_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Anam kuu Godbed ye bondan yi korok kuu baangkanabaneen, deerewandiyiibban arewa kamembiridan yi korok ambokibim awungiib arimbed kui. ");
INSERT INTO yon_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Yarimanbed yedmoon, “Nembed yiib bondan kuu Basan angkambed be mananiin, kwane nembed yi kuu karamok niindem yirimbed kangkon be mananiin, ");
INSERT INTO yon_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","yiib kuu yiib bondan yi umkan animari dore binburunaniiwe yiib anon kangkon kwane yi umkan ananiib.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","O God, eb dowad kowekadwe kamenmo wene kurikuri boyambib darewoob yaa weniibdan kuu wedmuwen kii, ne God ne King ye dowad kui. ");
INSERT INTO yon_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Yook wingkidan kuu ibduruk weniib, kuweng wangkanabidan kuu yoman anuk weniib, yi yoom weniibdan kuu nima koyu tambarin wangkanabiib kii. ");
INSERT INTO yon_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","“Kadaareb yemoon nedbiwendan, yiib kuu God yaningko kankoonime, Israeldan nedbiwen kui, yiib kuu Yariman yaningko kankoonime.” ande wingkaib. ");
INSERT INTO yon_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Kuro kuyaa kuu amyenimbon embeng Benjamindanbed nedbiwendan kuu ben kinban weniib, yaro kuyaa kuu Yudadan yi korok korok yemoon kai weniib, yaro kuyaa kuu Sebulundaniib Naftalaidaniib yi korok korok weniib kii. ");
INSERT INTO yon_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","O God, ebbbed nub dowad ambangkewen ye aromkono kuu, o God, ebka nub yaa korokbende. ");
INSERT INTO yon_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Yerusalem aombed eb kurikuri boyambib darewoob kuu doruun kowe, kingdan kuu munob bangkandi yeman eb yaa be bangkabdimaib. ");
INSERT INTO yon_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Dingkan kiib darewoob bingkodem aom doriib yaa weng kamkonomo daande. Yi kuu buromakau ambi yemoon arudiib nimingkemoon areb, ambibkin maa maadan kuu buromakau mana arebmo. Weng kamkonomo kondebko eb yaa bumangkenib od silvaa dareb dareb bangkabdime. Ambibkindan kane kane ana nangmi yaa dowakeniib keriwen kuu ebbed ben buyokbayok kameewo wenebime. ");
INSERT INTO yon_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Idyipdan yi korok darewoobbed ye korok yena benyuraneene mananiib, kwane Kusdan kuu yika benkubune God ye dabderem yiri dobaraniib. ");
INSERT INTO yon_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","O okad yiri yu ambibkin koremdan, God yaa yook wingkime, Yariman yaningko kankoone wingkime,Selah ");
INSERT INTO yon_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","unyemanbed ongmoon ye ambid arimbed deweneboon ye karub yaa kui. Kedi, yembed nambad areb aromkonomo baandimaan. ");
INSERT INTO yon_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","God kuu aromkonoyiib ande baandime. Ye dobiri manimanandewiib Israeldan yaa oonimaan, kwane ye aromkono kuu ambid arimbed. ");
INSERT INTO yon_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","O God, eb kurikuri boyambib darewoob aom doreeb kuu binangke ewaningko kankooni yeman. Israeldan yi God yekareb nimakarub yaa aromkonoyiib arudkonoyiib bangkandimaan. God yaningko kankoonem! ");
INSERT INTO yon_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Yook ambo bi ye karub yeman. “Bingko Wuung” ye yook ye kiwaan yaambed wingki yeman. Dewidbed wongkoon. O God, ne nen burudande angka kowe, amborom kuu ok kuu derebe yukne nandameen kowe. ");
INSERT INTO yon_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Ne kuu birinbon dareb yiri kubunaan, kuyaa kuu yon dore aromnikinban kii. Ne kuu ok kaba dareb yiri kubunaan, urokbed derebe yukne kanwanandamuun kui. ");
INSERT INTO yon_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Ne kuu awawime ande komkimain kumbed ne kiwadkok kuu kiwandoon. Ne kuu God ande onmoni nindob yidnoon. ");
INSERT INTO yon_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Kane kane ne yaa ogoodmo idiibbanbed arud wandembiriwendan kuu kimingke yemoon kai keroon, ne awung kimingki arebban. Kane kane ne yaa ogoodmo idiibbanbed bon keriwendan kuu aromkonoyiib, yi kuu ne neene monmarem ande kamiib kui. Nembed yid bindo kumbed ongmok ande dedmobimaib. ");
INSERT INTO yon_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","O God, ne inamen arewa kuu ebkaadkerewen, kwane ne ambarakmi kuu eb yaambed kuu ma bikniyiibban. ");
INSERT INTO yon_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","O ana nangmidan yemoon ye Yariman God, kane kane eb yaa amaan ari kwananeen ande meedmiibdan kuu neyiib kowe yenambed yi yaa karak kondaib. O Israeldan yi God, kane kane eb ande onmiibdan kuu neyiib kowe yenambed yi aningko ben kubunaib. ");
INSERT INTO yon_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Amborom kuu ne kuu eb dowadbed damangkawe irinyowaiwe, ne kuu karak bobnimain. ");
INSERT INTO yon_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Kowe, ne aaroka yaa kuu ne kuu norodman keraan, nena anam yu karub dana meed yaa kuu owodman keraan kui. ");
INSERT INTO yon_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Amborom kuu ewambiwoom ye nindorok kumbed aikmewembirimaan, kwane damangkandi weng yimbed eb yaa damangkabdiwen kuu ne yaa monoon kii. ");
INSERT INTO yon_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Ne kuu inok we animan koronde God yaa meenimain kuu ne yaa damangkawe irinyowimaib. ");
INSERT INTO yon_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Ne kuu yuudi dowad ebkad karong korobmo deebimain kuu nimakarubbed daawi yeman kerimaib. ");
INSERT INTO yon_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Kane kane siti kuuk ambongko yaa dibirimaib kuu damangkawimaib, kwane awarak yimaundanbed ne dowad damangkawi yook wingkimaib. ");
INSERT INTO yon_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Kumban, o Yariman, eb kubi dowaken keri yaron arimbed eb yaa kurikuri kamimain kowe, o God, eb womoniyiibban ye mimyob dowaken darewoob yaambed inanduweneb ma korondiyiibban ye inamenbed awine ne nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Domowaawe birinbon yiri kubunain, nen burudande angka kowe. Kane kane ne yaa arud wandembirimaib yaa ne nen burudande angka kowe, ok kaba dareb yiri areb kuyaa kui. ");
INSERT INTO yon_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Korondaawe ne kuu urokbed nen yuknaun, o ok kaba dareb yiri ne nen anukmunaun, o dem yiri kubunaine winderaun. ");
INSERT INTO yon_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","O Yariman, eb womoniyiibban ye mimyob dowaken kuu amunmo kowe kuyaambed inanduwe. Eb mimyob darewoob kawewen yaambed ne yaa wedmewe. ");
INSERT INTO yon_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Eb deme karub ne yaa murubia kan yeknaab, kwane ne kuu dabab kandaan kowe kirod inanduwe. ");
INSERT INTO yon_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Dia mene ne bidde, ne kuu bondaniib kowe. ");
INSERT INTO yon_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Eb kuu ebkaadkerewen ne bondanbed ne nen irinyowenib damangkawenib karak kawimaib, yi kuu wedmende doreeb kui. ");
INSERT INTO yon_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Damangkawiwen kumbed kubiyiibban kereni ne niindem aom miin yiminban keraan. Mimyob keewidan ande onmaan kumban ma wedmindo, kwane ne mimyob wandi kankubunidan ande onmaan kumban ma wedmindo. ");
INSERT INTO yon_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Ne bondanbed naniman ari mung kookiib dabokenib, ok moomiib keraan yaa kuu kookiib ye ok kawimaib. ");
INSERT INTO yon_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Kowe, yi orokbon arak kumbed kawaad areb kerundok, kwane yi yoom yone doriibdan yaa warab areb kerundok. ");
INSERT INTO yon_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Kwane, yi indob kuu wiiwiib yonoko wedmindeban kerime, kwane yi angkurom kuu aron korem nikmingkandok. ");
INSERT INTO yon_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Yi ari kuu eb norin arud onduknende. Kwane yi kuu eb arud amoyiib denobeen kumbed ben dabuknandok. ");
INSERT INTO yon_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Kwane, yi yumbon kuu korem obonmo kerok, kwane yi kombon ambiwoom kuu karub maa ma doborokban kerok. ");
INSERT INTO yon_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Amborom kuu kane kane ebbed ukum kondewendan kuu yimbed yenbandaiwe, kwane ebbed durud yewed kondewendan yi weng kuu yimbed kanyare daandimaib kowe. ");
INSERT INTO yon_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Yi ambarakmi kuu wuubenmo daanekoreb ukum darewoob konde. Kwane yorokmo dobiri ye kiwaan ebbed ongmewen kuu yi kuu kandaib. ");
INSERT INTO yon_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Kwane, yi aningko wadkeri buk aom kuu are daadme. Kwane, yi kuu yorokmodan yi aningko yaa wongke daboknaab. ");
INSERT INTO yon_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Ne kuu yewediib niindem aom miin yiminban keraan, o God, bobni yaa burudande bindi ye kiwaan ebbed ongmewen kumbed ne nen dorenare. ");
INSERT INTO yon_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Ne kuu God yaningko kankooni ye yook wingkaniin, kwane ye yaa eso ande nambiri konaniin. ");
INSERT INTO yon_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Kwananiin kuu Yarimanbed kubi darewoob keraneen, oksen aye nengke baeb koni arebban, buromakau ambi duruwiib biridiib kumundin nengke baeb koni arebban kui. ");
INSERT INTO yon_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Dabab meneboondan kuu kwane wedmenekorib kubaniib, yiib kane kane God ande onmiibdan, yiib niindem aom kuu kubimbed angkimborok! ");
INSERT INTO yon_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Kamboknondan yi weng kuu Yarimanbed wengambirimaan, ye nimakarub bondan yi dabderem yiri doriib kuu yangmadandimokban. ");
INSERT INTO yon_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Kwane, Eweniib okadiib kuu ye aningko kankoonime, karamokiib yu kumkam koremiib kwangkon ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Amborom kuu Godbed Saiyon kuu arud ye barang yaambed burudande nendene, Yudadan yi siti kuu ika yenbenabaneen kowe. Kwananeene ye nimakarub kuu kuyaombed nekwane dobere oonaniib, ");
INSERT INTO yon_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","ye demedan yi meed kuu kuye okad kuu yiman keranuun kui, ye yaa mimyob dowaken keenimaibdan kuu kuyaa dobaraniib kui. ");
INSERT INTO yon_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Yook ambo bi ye karub yeman. Dewidbed wongkoon. Kaamoni yeman. O God, ne kuu burudande nende. O Yariman, kirodmo mene awawe. ");
INSERT INTO yon_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Kane kanembed ne nande kamiibdan kuu karak kondeneb kerebkarab kerunde. Kane kanembed ne monmarandamiibdan korem kuu ben amonombesaroko ikakman winibko irinyonde aningkoyiibban kerundok. ");
INSERT INTO yon_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Kane kanembed ne kande iningkuk yeman keriwen kuu karak kondoko ikakman winime. ");
INSERT INTO yon_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Kumban kane kanembed eb ande onmiibdan kuu, eb yaa dowakeniib kere kubime, kwane kane kanembed bobni yaa burudande bindi ye kiwaan ebbed ongmewen kuyaa dowaken darewoob kowiwen kuu, kekane yedmimamime, “God yaningko darewoob arimbed kerok!” andimamime. ");
INSERT INTO yon_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Kumban ne yaa dabab meneboon, nangkon kamboknon keraan, o God, ne yaa kirod mene! Eb kuu ne awawi ye karub, eb kuu ne nen burudande angka kowi ye karub, o Yariman, erebnaraab, kibireb mene! ");
INSERT INTO yon_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","O Yariman, ebbed kukbimaabbon aombed dobirimain, korondaawe ne yaa ma karak kawaib. ");
INSERT INTO yon_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Eb yorokmo kerekmen yaambed ne nen burudande angka kowe. Ne yaa eb kerendem kowe wengamberewe mene ne nen angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Ne nen kukbimaabbon aombed aromne angkumoni ye karub kere. Ewiib yaa mini ye kiwaan kuu ma kebeniyiibban kerok. Eb kuu ne aromkonombon, eb kuu ne aromne angkumonimbon kowe, ne dowad ye nen burudande angka kowa andi ye weng dakme. ");
INSERT INTO yon_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","O ne God, arewa kamenabidan yi dingki dem aom kuu ne nen burudande angka kowe, yenbandi kuu yi iningkuk areb kerimaibdaniib yorokmombandaniib yaa kui. ");
INSERT INTO yon_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","O Yariman Ambengkan, ebbed kwananeeb ande meedme doriin, kwane ne kewed yaambed mene kibikee eb yaamo angkumone doberembirimain. ");
INSERT INTO yon_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Ne wooneen yaambed mene kibikee eb kuu ne yaa doreeb kowe yiminmo dobaraan, kwane ebbed nena yu kabeyob aombed ne nen angkaderewen. Ne kuu aron korem ewaningko kankoonimamaniin. ");
INSERT INTO yon_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Yemoon yi indob arimbed ne kuu dud korokbi yeman areb keraan, kumban eb kuu ne dowad kukbimbon aromkonoyiib kerewen. ");
INSERT INTO yon_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Ne meeni aom kuu ewaningko kankooni ye inamenmo, kwane aronki doboob kuu eb nambiri ye wengmo dakmembirimain. ");
INSERT INTO yon_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Kiomnaniin kuu ne nen kan angka koraraab. Aromkonoyiibban keraniin kuu domowaab. ");
INSERT INTO yon_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Amborom kuu ne bondan kuu ne yaa manmo kere dakmimaib, kwane ne dowad nuwaron keruko aye kowem andidan kuu nuubnaan kamiib. ");
INSERT INTO yon_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Yimbed ne dowad kekamune dakmimaib, “God kuu ye yaa domonenoon. Karub maambed ye nen burudande angka kowaanban kowe ye yoman kerenenmo yarenub awinenem.” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O God, ambabbed dobaraab, o ne God, awawi dowad kirod mene. ");
INSERT INTO yon_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Ne yaa manmo keriwendan kuu karak konde monmare. Ne yaa arewa keruwandamiibdan kuu damangkande irinyonde aningkoyiibban kerunde. ");
INSERT INTO yon_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Kumban ne kuu ebbed ari kwananeeb ande meedmembirimain, korondainban, kwane ewaningko kankoonimain kuye inamen kuu kaine darewoob kere weneen. ");
INSERT INTO yon_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Eb yorokmo kerekmen ye dowad daandembaraniin, bobni yaa burundande bindi ye kiwaan ebbed ongmewen kuu ne kuu kumunkingkindeban kumban, kuye dowad kuu aronki doboob daandembaraniin. ");
INSERT INTO yon_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","O Yariman Ambengkan, ebbed ewaromkonoyiib kwane ambangkanabewen kuu mene baande daandaniin, kwane eb yorokmo kerekmen ye dowad baande daandaniin, ebmanmo kui. ");
INSERT INTO yon_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","O God, ne kuu ne kewed yaambed mene kibikee ebbed kedmengkawimaab, kwane kuyaronbed mene kibikee binangke eb yaa anam andi yeman ongmenabewen kuu daandimain. ");
INSERT INTO yon_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","O God, kiomne wok bandaniin kuu domowaab, kwane eb aromkonomo dobiri ye wengiib eb kuu korem burundandewen arimbed ye God ye wengiib kuu ari ari ye nimakarub yaa daande dowan keraniin kumbed bobnaniin kuu yimin. ");
INSERT INTO yon_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","O God, eb yorokmo kerekmen kuu kwane kawene ambid aommo doroon, o God, eb kuu kami miin darewoob ambangkanabewen kowe, kane kuu eb areb keroon? Dowan! ");
INSERT INTO yon_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Ebbed dabawiib durud yewediib yemoon ben ne bangkawewen kumban, ongmewaneewe wadkeraniin, kwane dem kongdem yiri areb dobaraan kumban, ebbed ne ika nen kawene kowaneeb. ");
INSERT INTO yon_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Ne kuu aningkoyiib kuned ebbed angkon naningko kuu darewoob arimbed keruweneb, ne mimyob wandi kuu ika kankubunaneeb. ");
INSERT INTO yon_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","O ne God, eb korondiyiibban no awinembiri ye inamen awinimaab ye dowad, haabbed wangke ewaningko kankoonaniin. O Israeldan yi God Karadmo, laiyambed wangke ewaningko kankoone wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Ewaningko kankoone wingkaniin kuu komke kubaniin, biddewen ye karub nembed kui. ");
INSERT INTO yon_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Aronki doboob kuu eb yorokmo kamenabi kuu daandembaraniin, amborom kuu kaneyambed ne nenbandandamiibdan kuu karak kondene kerebkarab kerundoon kowe. ");
INSERT INTO yon_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Solomonbed wongkoon. O God, eb wengyundi ye kiwaan kuu king yaa kedmengkane. Ye kuu king ye mingki kowe ye yaa eb yorokmo kerekmen kuu kedmengkane. ");
INSERT INTO yon_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Kwaneewo ye kuu eb nimakarub yaa yorokmo kerekmen yaambed wengyundok, kwane eb nimakarub yaa dabab wayiroondan kuu anammo wengyundok. ");
INSERT INTO yon_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Kwane, aangko aangko angka kuu yewenubmo dobiri deedere wonok, kwane koodbon koodbon kuu yorokmo dobiri ye yob irok. ");
INSERT INTO yon_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","King kuu dabab wayiroondan yaa koromone dakmok, kwane ye kuu kamboknondan yi dana meed ben arud ye barang yaa dorondarok, kwane ye kuu dabab kondi ye karub kan yob beengkemoon areb kerunok. ");
INSERT INTO yon_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","O God, aron yurembirimaun yaron kuu nimakarub kuu eb yaa une bumangkime, wood angkimbirimaun yaron kui, awo awo andowoon anukbed mene aron yeenbon ari kui. ");
INSERT INTO yon_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","King kuu mongkobon angka am manauna kirod iremoon areb kerok, kwane ye kuu okad ari am manauna aya nonga kainemoon areb kerok. ");
INSERT INTO yon_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Ye dobaraneen yaron niindem aom kuu Godbed yorokmodan yaa yiminmo kerundok, kwane yewenubmo dobiri kuu yi yaa yiminmo kerok, kwane wene wood kuu dowan keranuun. ");
INSERT INTO yon_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Yembed oonaneen ye ambibkin kuu kwane karamok maambed wene maayiib nanduk, kwane ok awaan Yufretesbed wene bid yimin wandaneen yaa keruk. ");
INSERT INTO yon_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Amiibban ye amboon angka doriibdan kuu king yaa bumangkime, kwane ye bondan kuu ye yaa bumangke korok ben kibingkenib ye dabderem yiri dobirime. ");
INSERT INTO yon_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Taasisdan yi kingiib dudbi dudbi ku dangeendan yi kingdaniib kuu ooni ye kakman od kuu ye yaa bangkanime, kwane Sibadan yi kingiib Sebadan yi kingiib kangkon nub yaa kubende andi ye munob koni yeman bangkanime. ");
INSERT INTO yon_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Kingdan korem kuu ye yaa bumangkime, kwane ambibkin korem kuu ye demedan kerime. ");
INSERT INTO yon_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Kedi, awawe ande baandi ye karub kuu kingbed awanenaneen, dabab wayiroondan kane kane yi yaa awandi ye karuwiibban kuyaa kui. ");
INSERT INTO yon_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Kamboknondaniib yiminban kerenib awande andidaniib yaa kuu yembed mimyob keendaneen, kwane yiminban kerenib awande andidan kuu yembed bobni yaa burudande bindaneen. ");
INSERT INTO yon_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Yi kuu yembed yobdoodmo dabab bangkandidaniib yeremboromdaniib yaa dorenare bindaneen, amborom kuu yi wadkeri kuu miin yekareb amun yeman ande meenimaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Ye kuu weeb yemoon kwane doberemborok! Kwane Siba ambibkin ye bot gold kuu ye yaa bangkanok. Ye dowad nimakarub womoniyiibban aron korem kurikuri kamembirime. Kwane aronki doboob kuu ye yaa amun kerunime. ");
INSERT INTO yon_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Bidambib kumundin aom kuu wiit yob kuu yewudmo kerok. Aangko aangko dungkun ari kwangkon awuune angkara kere angkara kere kamok. Kuye wiid yob kuu Lebanon yu at yemoon areb yemoon kai kerok. Kwane nimakarub kuu yi kambong aom kuu yidwarok, kereekbon angka kuu kereek yemoon kwamune areb kerok. ");
INSERT INTO yon_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Ye aningko kuu aron korem yirin kame angkimborok, aron ku angkimbaranuun yaron ye doboob areb kuu kwane angkimborok. Ye yaambed ambibkin koremdan kuu amun kerundok, kwane yi kuu ye dowad ye kuu amun kerunoonman andime. ");
INSERT INTO yon_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Yariman God, Israeldan yi God kui, ye yaa amun kerunok. Yembedmo binangke ye yaa anam andi yeman ongmenabimaan. ");
INSERT INTO yon_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Ye aningko nambiriyiib yaa amun kerunemborok, aron korem korem. Kwane okad kumundin kiri kee ye nambiri kwane derendarok. Anam kwanok. Anam kwanok. ");
INSERT INTO yon_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Kwamune kumbed Yesi ye mingki Dewid ye kurikuri kame dowan keroon. ");
INSERT INTO yon_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Asaf ye yook. Anamaa, God kuu Israeldan yaa amun amun kamimaan, kane kane yi niindem aom kuu karadmo keroondan yaa kui. ");
INSERT INTO yon_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","3","Kumban miin arewa kamiibdan kuu yiminmo doriiwe wedmeni, kerengkandan kee amunmo doriib kumbed yi areb kera ande kamaan kowe, ne kuu kiwaan amun ari koronde kimyen kere beresarok andaan, kwane ne yon kuu dore at wande komborok andaan kii. ");
INSERT INTO yon_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Yi kuu dabawiibban amunmo doriib, yi id yaa kuu bobob aweneyiibban kirikmo. ");
INSERT INTO yon_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Nimakarub yena korem yaa kuu yobdood menebimaan kuned kerengkandan kee dowan. Nimakarub yena korem yaa kuu dabab menebimaan kuned kerengkandan kee dowan. ");
INSERT INTO yon_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Kwani kowe, yi kerengkan kami kuu kongkono yaa itoob derenemoon areb keroon. Yi kuu yeremborom ye inamen yaamo meenimaib. ");
INSERT INTO yon_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Inamen arewa kuu yi niindem aom kaine kob areb yingkoon. Inamen ongmenabimaib kuu miin arewa angkon yemoon kai. ");
INSERT INTO yon_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Yi kuu damangkandenib dabab kondi dowad dakmenabimaib, kwane yi kerengkan inamen yaambed kwane dakmimaib. ");
INSERT INTO yon_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Yi mongkodkonombed Ewen yaa weng arewa dakmimaib, kwane yi ongbed kerengkan weng dakmimaib kuu korokdan yi weng areb daande yarimaun. ");
INSERT INTO yon_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Kwani kowe, God ye nimakarub kuu keyaa ikakman manaiwa, dabab yemoon kuu miin arewa kamenabidanbed yi ari kuu kapus aom ok demboon areb onduknimaib kii. ");
INSERT INTO yon_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Yi kuu kwane yedmimaib, “God kuu komo kere yekaadkeraneen? Dowan! Korem Burudandoon Arimbed Ye God kuu inamen kaadkeriyiib dee? Dowan!” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Kedi, miin arewa kamenabidan yi kuu kwamunemo areb, yi kuu meendobembiriyiibban, kwane yi yiribman yemoon kuu ariyiib dabokne bimaib. ");
INSERT INTO yon_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Anamaa, yorokmo inamenmo awineni ambarakmi korem yaa kangkadmimain kuu idiibban ande meenaan, ");
INSERT INTO yon_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","amborom kuu aronki doboob kuu ne yaa dabab menebaane, amkimo korem kuu ne kuu ukum kawe didangkewimaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Nembed “Yi inamen arewa kande dakmaniin.” ande yedmaniin kuu, God ye nimakarub yaa ambarakmaniin. ");
INSERT INTO yon_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Kwane korem kee id kandande kamaan kuu, ne yaa yiminban keroone miin kubiyiibban keraan. ");
INSERT INTO yon_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Kuned ne kuu kwane wene God ye kurikuri boyambib aom aomneni miin arewa kamenabidan kee yi yaa yeenbon ari komo keraneen kuu nekaadkeraan. ");
INSERT INTO yon_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","O God, anam kuu ebbed yi kuu beneb okad kereewiib ari nongkobewen, anam kuu ebbed yi kuu nadme monmarimbon yiri ben kiradmaneeb. ");
INSERT INTO yon_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Yi kuu kudmeniibban monmaraneen kumbedmo, urokbed yukne yeemoon areb yi kuu kudmeniibban ye uni maa maambed dukne dowan keraniib. ");
INSERT INTO yon_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Kwane karub maa kiyuum we dembene aa kiyuummo, idiibban andemoon areb, o Yariman, eb kwane yaro dembaneeb kuu, ebbed yi kuu wurukbandan ande yi yaa angkurom korokbendaneeb. ");
INSERT INTO yon_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Ne niindem aom miin yiminban kereni ne mimyob yaa kuu maradbed kaaremoon areb keroon yaron kuu, ");
INSERT INTO yon_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","ne kuu nonoon kere meenindeban kereni eb arinambo arimbed ne kuu inameniibban ye dingkan areb keraan. ");
INSERT INTO yon_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Kuned ne kuu eb yoommo doberembirimain, kwane ebbed ne kuu ne dingki wiwi angkambed awinewe yarimaab. ");
INSERT INTO yon_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Kwane, eb kedmengkawi yaambed ongkawe nen kinban winimaab, kwanekoreb eb nambiri aom nenwananeeb. ");
INSERT INTO yon_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Ne kuu Ewen aom kuu karub maayiibban, ebbedmo. Kwane ne kuu okad kiri ye barang maa yaa meenimokban, ne dowaken kuu eb yaamo angkeen. ");
INSERT INTO yon_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Ne idiib mimyowiib kuu dowan keraneen kumban, God ebbedmo kuu ne niindem aom aromni ye karub, aron korem dobiri ye yumbon keruwi ye karub kuu ebbedmo. ");
INSERT INTO yon_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Kedi, kane kane eb yaa ambab keriwendan kuu korem duknaniib, kwane kane kane eb yaa korondaniib kuu ebbed monmaraneeb. ");
INSERT INTO yon_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Kumban nembed wedmaan kuu God ye dia dobiri kuu amun. Ne kuu Ambengkan Ye Yariman ye kukbimaanbon aombed doriin, kwane nembed ebbed komo komo kamenabewen korem kuu dakmaniin. ");
INSERT INTO yon_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Asaf ye Maskil ye yook. O God, komarewako kee nub kuu aron korem domondewen? Komande eb ooni ye sibi areb nub yaa kuu eb norinmo womoniyiibban keendembirimaab? ");
INSERT INTO yon_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Eb nimakarub unyemanbed amoddoon kuyaa ika meene, ambibkin mimodan ebbed kinewe biddoon kuyaa kui. Aangko Saiyon kurin anuk doberewen kuyaa ika meene. ");
INSERT INTO yon_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Bondan kuu eb kurikuri boyambib monmariwen kowe, aron doboobmo angkuun ye boyambib bob keyaa yaro dodkanmo mene. ");
INSERT INTO yon_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Eb yoom nedbimaubbon yaa kuu eb bondanbed wene baankone komkiwen, kwane yi flaekiib mane kan daaniwen. ");
INSERT INTO yon_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Yi kuu at dengkoridan areb, at nimingkaan aom dengke aremoon areb keriwen kowe, ");
INSERT INTO yon_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","eb kurikuri boyambiwoombed kowod yone winiwen yaa ayiib nongkobe kuruwakiib ongmenabiwen kuyaa kuu yi kapakiib hamayiibbed wowe monmariwen. ");
INSERT INTO yon_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Kwane yimbed eb kurikuri boyambib kuu amotbed kowiiwa dene kubuneen, kwane ewaningkoyiib angimboroon ye kurikurimbon kuu monmare yon dowod yeman kerundiwen. ");
INSERT INTO yon_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Nub dowad yikareb yedmiwen, “Nub kuu yi ben kumundin yob beengkemoon areb kerundem!” andiwen. Kwane, nuwambibkin aom God yaa kurikurimbon korem kuu amotbed nengkiiwe denobeen. ");
INSERT INTO yon_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Nub yaa kuu dud maa ma korokbindo, kwane nub kumaom kuu profesiman mim ma doborokban, kwane aron arewa kee aron komoyiib kwane awinaneen kuu nub keyaa karub kanembed ma yekaadkerindo. ");
INSERT INTO yon_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","O God, aron komoyiibbed kwane eb bondan kuu eb yaa damangkabdaniib? Yi kuu kwamune aron korem ewaningko monmaraniiwoo? ");
INSERT INTO yon_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Komoyiibkob eb dingki, dingki wiwi kui, yire ambangkokban kerewen? Eb dingki bedme warewen kuu ben yire yi monmare. ");
INSERT INTO yon_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Kumban, o God, unyeman yirimbed eb kuu ne king kerewen, kwane ebbed okad kirimbed arud ye barang yaa burudande bindimaab. ");
INSERT INTO yon_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Ewaromkonombed karamok kuu kan angkara angkara kere kowewen, kwane omyere dareb dareb yi korok kuu baangkanabewen. ");
INSERT INTO yon_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Ebbed omyere kambari maa yaningko Lewaiyatan ye korok korok kuu beengkanabekoreb, ye ida yoma kada kuu amiibban ye amboon ye dingkan yaa bangkandeewa aniwen. ");
INSERT INTO yon_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Ebbed ok kirubdemiib okmanamboniib kuu ongmenabewenkob menebuun, kwane ebbed menebimaun ye ok awaan kuu ben okiibban bidmo kere kokderebewen. ");
INSERT INTO yon_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Awingyab kuu ebman, amnoom kangkon ebman, kwane woodiib aroniib kuu ebbed ongmenabe nongkobewen. ");
INSERT INTO yon_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Ebbed okad kuu yu yiminmo andi yaambed ongmenabe nongkobewen, kwane ebbed yongkonbi yaroniib amaroniib ongmenabewen. ");
INSERT INTO yon_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","O Yariman, bondanbed damangkabdiwen kuyaa ika meene. Kedi, inameniibbandan ewaningko monmariwen kuyaa ika meene. ");
INSERT INTO yon_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Kwane, nub kuu on arud areb arudiibban aromkonoyiibban keruwen kuu arud dingkan areb keriwendan yi dingki ari nongkobaab, kwane dabab wayiroondan ebbed ooneeb kuyaa kuu aron korem nonondandaab. ");
INSERT INTO yon_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Eb amob weng nub dowad ongmewen kuyaa kuu meene ongme awine, amborom kuu okad keyaom kee bendom mirikni miriknimbon kuu yeremboromdaniib diiriwen kowe. ");
INSERT INTO yon_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Kwane korondaawe, dabab wayiroondan kuu ika mene karak kandaib, kwane kamboknondaniib yiminban kerenib awande andidaniib kuu ewaningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","O God, yaro dore. Ebka eb dowad koromone dakme. Inameniibbandan kuu aronki doboob damangkabdimaib kuyaa ika meene. ");
INSERT INTO yon_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Eb yaa manmo keriwendanbed yirinde baandimaib kuyaa nonondandaab, kwane eb bondanbed womoniyiibban baankone komkimaib kuyaa kangkon nonondandaab. ");
INSERT INTO yon_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Yook ambo bi ye karub yeman. “Monmaraib” andi ye yook ye kiwaan yaambed wingki yeman. Asaf ye yook. God yaningko kankooni ye yook. O God, nub kuu eb yaa eso anduub, amborom kuu eb kuu dia doreeb kowe. Binangke eb yaa anam andi yeman ambangkanabewen kuu nimakarub kuu dakmimaib. ");
INSERT INTO yon_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ebbed kwane dakmeeb, “Nembed aron kuu kine kowaan, yorokmo wengyundi ye karub kuu ne kei. ");
INSERT INTO yon_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Kwane, okadiib yu nimakarub koremiib kiringmaniib kuu nembed ambokab yiri kuu yobdoodmo awinaniin.Selah ");
INSERT INTO yon_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Nembed kerengkandan yaa yedmaan, ‘Kibikbed ari kuu ma kerengkan kamaib.’ andaan, kwane miin arewa kamenabidan yaa yedmaan, ‘Yiib aromkono yaa kerengkan kamaib. ");
INSERT INTO yon_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Yiib aromkono yaa miin kerengkan kamaib. Kwane yiib kuu wabkad kere kerengkan kamaib.’ andaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Karub maa kane aron dembimaun angkambed o aron kubunimaun angkambed o amiibban ye amboon angkambed karub maa yaningko kankoonaanban. ");
INSERT INTO yon_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Kumban kukuu wengyundimaan ye God, yembed maa kuu nen kubudere maamo yaningko kankoonimaan. ");
INSERT INTO yon_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Yariman ye arud kuu wain ok kamokiib areb, ambodmo kandene kook yeman yenayiib dabokne ongmene kabus aom bunoone daadere demboone, onduknoone miin arewa kamenabidan okad yimin yimin yaa doriib kuu yi korem kuu anenmo kawene kibin yirimo keriwen. ");
INSERT INTO yon_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Kumban ne kuu God ye dowad aron korem dakmembaraniin, kwane ne kuu Yekob ye God yaningko kankoone yook wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Yembed miin arewa kamenabidan yi aromkono kuu kan kubune dowan keraneen, kumban yorokmodan yi aromkono kuu darewoob arimbed kerundaneen. ");
INSERT INTO yon_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Yook ambo bi ye karub yeman. Nongbed wangki yemaniib. Asaf ye yook. God yaningko kankooni ye yook. Yuda aom kuu God yikaadkeriwen, kwane Israel aom kuu ye aningko kuu darewoob arimbed kii. ");
INSERT INTO yon_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Ye kombon ambib kuu Salem aom, kwane ye dobirimbon kuu aangko Saiyon ari. ");
INSERT INTO yon_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Kuyaambed bondan yi ana yumbuyiib kuu yembed domangkoon, yi kombeyiib kerewangiib ana nangmi ye kumaniib kangkon domangkoon.Selah ");
INSERT INTO yon_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","O God, eb nambiri kuu yeka mamaa kii, eb nambiri kuu darewoob arimbed, aangko ari nedbiwen ye bondan yemoon arebban. ");
INSERT INTO yon_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Yi kanangkoddan kuu no yenbande nongkobeneb yi yiribman ben wenorewen, kwane yi kuu yeenbon unuk dangemoon areb keriwen, ika wad yeedaraibban. Yi ana nangmidan kumaom kuu karub mim maa kwane ye dingki ma yiraanban. ");
INSERT INTO yon_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","O Yekob ye God, eb ongkandi kumbed, yi hoosiib seriotiib kuu yeenbon unuk dangemoon areb keriwen. ");
INSERT INTO yon_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Unebdi ye karub kuu ebbedmo. Eb norin wandaneeb kuu kanembed koromone eb kiringkono ari dobaraneen? Dowan! ");
INSERT INTO yon_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Ewen arimbed kangdod weng dakmewen kumbed, okad kiridan korem kuu eb konob une iwari keriwen. ");
INSERT INTO yon_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","O God, kukuu dabab wayiroondan arudbon yaa burudande bindi dowad ebbed yaro dore wengyundandewen yaron arimbed kwanoon.Selah ");
INSERT INTO yon_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Kedi, eb bondan yi norin eb yaa wandimaib kuu idiibban kerimaan kowe eb yirin kuu darewoob arimbed kerimaan. Kwane kuye norin dungkun kuu kan amonombe king ye korok ari dereni yeman areb ongmeneb derenimaab. ");
INSERT INTO yon_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Yiib Yariman God yaa wiim aangki weng ongmime, kwamunemo ambangkime. Ambibkin dia dia mimim koremdan kuu mim ye yaamo uni yemanman yaa munob koni yeman bangkanime. ");
INSERT INTO yon_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Yembed nimakarub yi korokdan kuu ben kubunimaan, kwane okad yiri ye kingdan kuu ye yaa unenimaib. ");
INSERT INTO yon_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Yook ambo bi ye karub yeman. Jedutun ye dowad Asafbed wongkoon. God yaningko kankooni ye yook. Ne kuu God yaa awawok ande baandeni, God wengamberewok ande baandaan. ");
INSERT INTO yon_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Dabab ne yaa meneboon kuu Yariman ande manaan, kwane amnoom doboob kuu dingki benkoobe ninabaan kuned, barang maa kuu ne mimyob wandi yaa kuu ma kankubunindo. ");
INSERT INTO yon_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","God yaa meenekori kwane warekaan, kwane ye kuyaamo meendobiine ne kingkin kuu miin aromkonoyiibban keroon.Selah ");
INSERT INTO yon_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Ne yaa kuu unuk angkaab ande kebenewen, kwane ne niindem kuu dabab waroon kumbed dakmindeban keraan. ");
INSERT INTO yon_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Anuk dobaraan yaamo meendobaan, weeb unyeman anuk yiri yaa kui. ");
INSERT INTO yon_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Anukbed amnoom yaa yook wingkaan kuu ika meenaan, kwane ne niindem aom meendobeni nekareb kaamobimain kuu kei. ");
INSERT INTO yon_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Yariman kuu aron korem wunekaraneen dee? Ye amun amun kamendi kuu angkon amaan ma korokbendaanban dee? ");
INSERT INTO yon_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Ye womoniyiibban ye mimyob dowaken keendi kuu korem dowan keroon dee? Ye weng kunduk kuu aron korem kwane idiibban keroon dee? ");
INSERT INTO yon_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","God ye mimyob keende kakman are nonondandi kuu dowan keroon dee? Yembed norin wandoon kumbed mimyob keendimokban keroon dee?” andaan.Selah ");
INSERT INTO yon_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Kwane nembed yedmaan, “Ne niindem aom miin yiminban keraan ye id kuu kei. Korem Burudandoon Arimbed Ye God ye dingki wiwimbed nub yaa awandimokban keroon.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Yarimanbed komo komo kamenaboon kuu nembed ika meenaniin, o God, anam kuu binangke ewaningko kankooni yeman ebkareb ongmenabewen kuu ika meenaniin. ");
INSERT INTO yon_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Komo komo ambangkanabewen korem kuu nembed ika ne niindem aom meendobeni, ewaromkonombed komo komo kamenabewen korem kuu kwane andangke meenaniin. ");
INSERT INTO yon_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","O God, eb dobiri ye kiwaan kuu karadmo. Kedi, god maa kuu nub God darewoob arimbed kwamune arewiib ma keroon dee? Dowan! ");
INSERT INTO yon_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Eb kuu binangke ewaningko kankooni yeman ongmenabimaab ye God, ewaromkono kuu ambibkin maa maa koremdan yaa korokbimaab. ");
INSERT INTO yon_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Eb dingki aromkonombed eb nimakarub biddewen, Yekob ye awoya ariyiib Yosef ye awoya ariyiib kui.Selah ");
INSERT INTO yon_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","O God, ok ariyiib ok yiriyiib kuu wedmebdiwen, eb wedmebdekorib une kiringmiwen, ok niindem yiri kangkon kwaneen. ");
INSERT INTO yon_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Wiib arimbed am menebuune, ambid ari kuu nambad kamoone, eb imak kuu ana baradmemoon areb anuk kere ari kere kamoon. ");
INSERT INTO yon_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Eb amkuni kuweng kuu kibin nuub aombed meneboone, eb imakbed okad kumundin kuu yuroone, okad kumundin kuu kiringmiyiibbed yobeen. ");
INSERT INTO yon_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Kiwaan ongmewen kuu karamok aombed dewuneen, karamok niindem yirimbed kiwaan ongmenabewen kui, kuned eb yon yumbon kuu karub maa ma wedmindo kii. ");
INSERT INTO yon_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Eb nimakarub kuu sibi oonidan areb ben kinban wenewen, Moses yoom Eeron yoom yaambed kui. ");
INSERT INTO yon_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Maskil ye yook Asafbed wongkoon. O ne karuwa nimaya, ne kedmengkandi kuu wengambirime. Ne mongkodkonombed dakmandamaan keyaa yiib kerendem kowe wengambirime. ");
INSERT INTO yon_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Ne mongkod doombereni kuruwak wengbed dakmaniin, unyemanbed biknoon ye inamen kuu kedmengkaniin. ");
INSERT INTO yon_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Wengambere nubkaadkeruwen ye weng, nuwambeyambed nub yaa daandiwen ye weng kui, ");
INSERT INTO yon_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","kuye weng kuu nub danaya yaa bikderebaubban, nub meed yaa kwane daandanuub kii, Yariman yaningko kankooni ye ambangkanabi ye wengiib ye aromkono ye wengiib binangke yaningko kankooni yeman ongmenaboon ye wengiib kui. ");
INSERT INTO yon_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Kedi, yembed kwanime andi ye wengiib amob wengiib Yekob ye awoya ari yaa bangkandoon, Israeldan yaa kui. Kuye weng kuu yembed nub awoya yiri yaa kuu “Yiib dana meed yaa kedmengkandime.” ande yedmoon. ");
INSERT INTO yon_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Kwamiwed kwane yi dana meed kuu kuye weng yikaadkeraniib, yi dana meed mogeed wanabindo kangkon yikaadkeraniib kii, kwane yi kuu yika yi dana meed yaa kedmengkanden wananiib. ");
INSERT INTO yon_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Kee kwane kamaniib kumbed God yaa angkumone doberenib, ye ambangki yaa nonondandaibban kerenib, yembed kwamime andi ye weng kuu awinaniib. ");
INSERT INTO yon_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Yi kuu yi awoya areb keraibban, amborom kuu yi awoya kuu bot korok kere wabkad keriwen kowe, yi awoya kuu God yaa korondenib god maa maa yi yoman winiwen. ");
INSERT INTO yon_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Efraimdan kuu anangkawiib nekwiwen kuned, ana nangmi aron muneen ari kuu kirokmone ikakman winiwen. ");
INSERT INTO yon_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Yi dowad Godbed amob weng ongmoon kuu korondenib ye amob yaa wunekare dobiriwen. ");
INSERT INTO yon_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Yi kuu yembed komo komo kamenaboon kuyaa nonondandiwen, God ye aromkono wedmi yeman yi yaa kedmengkoon kui. ");
INSERT INTO yon_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Yembed binangke ye aningko kankooni yeman yi awoya yi murubia arimbed kedmengkoon, Idyip ambibkin yiri bidambib Soon aombed. ");
INSERT INTO yon_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Yembed karamok kuu domokbe angkara angkara kerekore yi kuu wedyiri bid ari ben kinban yanoon, yembed ongmoona ok kuu wan yaro anuk yine ari yine kameen kui. ");
INSERT INTO yon_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Kwane, aronki kuu wiibbed kowe ben dore wenene, amnoom doboob kuu amot denenmo wene yure wanaana kuyaambed kerenenmo winimaib. ");
INSERT INTO yon_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Yembed amiibban ye ambon angkambed bot dumnad baangkenabe daadmekore, ok ongmoone karamok awaan areb darebmo menebuune yi yaa bangkandoon. ");
INSERT INTO yon_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Yembed okmanambon ongmoona bod dumnad aombed menebuun kui. Yembed ok ongmoone ok awaan areb wenebuun kui. ");
INSERT INTO yon_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Kumban yi kuu ambarakmi yaa deerewandindo, no kwane God yaa ambarakmembirimaib, kowe amiibban ye amboon angkambed Korem Burudandoon Arimbed Ye God yaa kuu wabkad keriwen. ");
INSERT INTO yon_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Kwane, yimbed mungi darewoob bobniwen ye animan nub yaa bangkandok ande kaamoniwen kumbed dowakeniib kere God yaa komboon kaamobiwen. ");
INSERT INTO yon_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Yi kuu God yaa dowakeniibban kerenib yedmiwen, “God kuu amboon angkambed animan kuu nub yaa bangkandi yaromkonoyiib dee? ");
INSERT INTO yon_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Kedi, yembed bot dumnad wowoone ok darebmo menebuune okmanambon ongmoona ok awaan areb wenebeen kuned, ye kuu nub yaa animan bangkandi yaromkonoyiib dee? Ye kuu ye nimakarub yaa dingkan yom bangkandi yaromkonoyiib dee?” andiwen. ");
INSERT INTO yon_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Kwanandiiwe Yariman kuu wengamberekore norin darewoob wandoon. Kowe Yekob ye awoya ari yaa kuu ye amot baandoone denemoon areb keroon, ye arud Israeldan yaa darewoob arimbed keroon kui. ");
INSERT INTO yon_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Amborom kuu yi kuu God yaa anam andindo, kwane yi kuu yembed nub awande oone bindaneen ande meenindo. ");
INSERT INTO yon_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Kumban ye kuu ambid ari yedme kowoona ambid ambongko nanaboona ");
INSERT INTO yon_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","yembed yi ani dowad om mena kuu am areb ben kubudoroon, Ewen ye animan kuu yi yaa bangkandoon kui. ");
INSERT INTO yon_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Kuye nimakarub kuu engyus yi animan aniwen, kwane yembed animan yiminmo bangkandoon kii. ");
INSERT INTO yon_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Yembed ambid ari kuu nuub ongmoone aron dembimaun angkambed monoone ye aromkonombed nuub ongmoone kurimbed monoon. ");
INSERT INTO yon_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Yembed yi yaa dingkan yom yewudmo kuu am areb ben kubudoroon, kukuu ayari on kuu karamok yu kubuk kimingkinban areb yemoon kai bangkandoona, ");
INSERT INTO yon_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","kuye ayari on kuu yi doriib wedangkambed kubudiriwen, yi ambib kombon dobere dobere kidangka kubudiriwen kui. ");
INSERT INTO yon_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Kowe, yi kuu ane mikmoniwen kumban animan dowan kerindo, kwane Godbed komo yi dowaken darewoob keriwen kuu kwane bangkandoon kii. ");
INSERT INTO yon_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Kumban yi kuu mogeed mikmonindo ane dibiib, animan kuu domonde aniib kui, ");
INSERT INTO yon_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","kumbed God ye norin kuu yi yaa darewoob arimbed keroone, yi aromkonoyiibdan kuu yeene nongkoboon, Israeldan yi kewed yenbandoone kubudiriwen kui. ");
INSERT INTO yon_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Kwamune keroon kumban yi kuu yi ambarakmi yaa deerewandindo, kwane yembed binangke ye aningko kankooni yeman ongmenaboon kuned ye yaa anam andindo. ");
INSERT INTO yon_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Kowe, yembed yi dobiri yaron kuu dukmenmo naroone yi inamen ongmiwen kuu idiibban kere dukniwen, yi dobiri ye weeb kuu dukmenmo naroone kudmeniibban uniwon karakwoniib kumbed yoworiwen. ");
INSERT INTO yon_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Aron kunayambed Godbed yi yenbandoon kuu yoworindodan kuu ye ande onmenib, nindorokiibbed ye yaa ika amonombenib ye kiwaan ari doberem ande kamiwen. ");
INSERT INTO yon_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Kwane, yimbed ika meeniwen kuu God kuu yi aromkonombon, kwane ika meeniwen kuu Korem Burudandoon Arimbed Ye God kuu yi biddi ye God. ");
INSERT INTO yon_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Kumban yi kuu ye yaa yi mongkodkonombed birane aadidmimaib, kwane yi ongbed dudi wengmo dakmenabimaib. ");
INSERT INTO yon_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Kedi, yi niindem aom kuu ye yaa kowindo, kwane ye amob weng yi dowad ongmoon kuu awinindo kimyen winiwen. ");
INSERT INTO yon_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Kuned God kuu yi yaa mimyob kowekore, yi ambarakmi kuu are nonondandoon, yi kuu yembed ben monmarindo. Aron yemoon kuu ye norin kuu yeka kan kubunoon, kwane ye norin kuu darewoob arimbed kowindo. ");
INSERT INTO yon_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Ye kwamune meenimaan, yi kuu okad yiridanmo andimaan, kwane yi kuu nuub embengmo menene burudande wene dowan keremoon areb keriwen. ");
INSERT INTO yon_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Aron yemoon kuu yi kuu amboon angkambed God yaa wabkad kerunimaib, kwane aron yemoon kuu yi kuu ye yaa abdon kerunaiwe miin kubiyiibban kerimaan kii. ");
INSERT INTO yon_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Ikakman ikakman God kuu kandunib komboon kaamobeni yeman kerembirimaib, kwamaiwe Israeldan yi God Karadmo kuu yewed kandimaan. ");
INSERT INTO yon_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Ye aromkono korokboon kuyaa nonondandiwen, yembed dabab bangkandimaibdan yaambed yi kuu biddoon yaroniib, ");
INSERT INTO yon_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","yembed Idyip yirimbed dud kedmengkoon yaroniib, yembed bidambib Soon aombed binangke ye aningko kankooni yeman ongmenaboon kuyaa kuu nonondandiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Yembed yi ok awaan kan amonombe umkanmo keroona, Idyipdan kuu yika yi okmanambon yaa anindeban keriwen. ");
INSERT INTO yon_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Yembed wadmung yemoon kai yedme kowoona Idyipdan yaa durud yewed kondiwen, kwane kot kangkon yedme kowoona yi kumkam monmariwen. ");
INSERT INTO yon_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Yembed kwane ed yedme kowoone yongbon kab biid kuu korem aniwen, kowe Idyipdan kuu deme awiniwen kuu idiibban keroon. ");
INSERT INTO yon_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Yembed kwane nong yowiib nongiib kuu am yurukmo bot areb keroon kumbed monmaroon, kwane yi yedob yob kuu wood nurok yurukmombed kirobe monmaroon. ");
INSERT INTO yon_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Yembed kwane yi buromakau kuu am yurukmo bot areb keroon kumbed yenbandoone dukniwen, kwane yi amongkob dingkan kuu imakbed yoon. ");
INSERT INTO yon_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Yembed kwane ye norin nimin darewoob yi ari kan onduknoon, ye arud darewoowiib ye kongendi darewoowiib ye yobdood darewoowiib kui, kukuu yiwed yowori ye engyus areb yi yaa menebiwen. ");
INSERT INTO yon_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Yembed ye norin kuu awine yinmonindo, kumundinmo yi yaa kan kowoon, kwane yi wadkeri kuu ma domondindo, no kwamune yenbande kiraroon bobmo. ");
INSERT INTO yon_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Kowe Idyipdan yi wonob dana korem kuu yeene nongkoboon, yob kowi yaromkono ibduruk korokbi dana kuu Idyipdan yi ambiwoom kuu dowan keroon kui. ");
INSERT INTO yon_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Kumban Godbed ye nimakarub kuu sibi nimingkemoon areb ben angkanoon, kwane yembed yi kuu sibi areb ben amboon angkarambed angkara kinban dewonoon. ");
INSERT INTO yon_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Yembed amunmo binwonoon, kowe yi kuu uniyiibban winiwen, kumban karamokbed yi bondan kuu yuknuune kubuniwen. ");
INSERT INTO yon_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Kwanikob yembed yi kuu ye ambibkin karadmo angkara be monoon, koodbon okad yembed nangme dore kandoon ari kui. ");
INSERT INTO yon_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Yembed ambibkin yenadan kuyaom doriib kuu yenbande dariroona kirokmone wenebiwen, kwane yi dowad bid nekwe bangkandoone okad kuu yiman kereen, Israeldan yi amyenimbon yi bidambib kerundoone kwari dobiriwen kui. ");
INSERT INTO yon_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Kumban yi kuu Korem Burudandoon Arimbed Ye God yaa komboon kaamone wedmenib, ye yaa wabkad kerenib ye amob awinokban keriwen. ");
INSERT INTO yon_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Yi kuu yi awodkiya areb God yaa angkurom korokbenib koronde kimyen winiwen, yi kuu ana unitabbed barandaiwe kimyen wenemoon areb keriwen kui. ");
INSERT INTO yon_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Amborom kuu yi kuu aangko aangko arimbed dudi god yi kurikurimbon ongmenabiwen kumbed ye yaa norin koniwen, kwane yi dingkimbed ongmenabiwen ye dudi god yi aningko benkoobimaib kumbed God kuu amban nenem kamauna ambimbed koren kamemoon areb keroon. ");
INSERT INTO yon_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","God kuu kwane wengamberekore norin darewoob wandene, Israeldan kuu kumundinmo wunekaroon. ");
INSERT INTO yon_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Kowe, ye kuu ye dobirimbon Sailo angka kuu koronde wonoon, nimakarub yoom dobiri ye ambib kombon yenboon kuyaa kui. ");
INSERT INTO yon_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Kwane, God ye amob weng ongmoon kumaom kowiwen ye boks karadmo kuu kanwinime andoone arewadanbed kanwiniwen, ye aromkonoyiib nambiriyiib kuu ye nimakarub yaa angkeen ande korokbi yeman kuu bondan yi dingki aom kowoon kui. ");
INSERT INTO yon_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Kwane, yembed yumbon ongmoone kandiwen ye nimakarub yaa norin darewoob wandoon kowe, kerewangbed yenbandimbon aom nongkoboon. ");
INSERT INTO yon_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Kwane, ye nimakarub yi kewed kuu amotbed dene kubunuune koyu kuu ma awadmindo. ");
INSERT INTO yon_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Kwane, God dore Yuudan dore wedyiri dobiridan kuu kerewangbed yeene yuriiwe, yi nima irib kuu binangke kingkin domoniwen kumbed ameng kirindiinban keriwen. ");
INSERT INTO yon_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Wene yimin arimbed Yariman kuu unuk angkimbon yirimbed dembemoon areb yaro demboon, ana nangmi karub wain ok ane warudki keremoon areb aromkonomo demboon kui. ");
INSERT INTO yon_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Kwane dembekore, ye bondan kuu yenburoona ika winiwen, yimin wandaanban ye karak darewoob keendoon kui. ");
INSERT INTO yon_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Kwane, Yosef ye amyenimbon kuu yembed akmendandundoon, Efraim ye amyenimbon kuu kingkindo kui. ");
INSERT INTO yon_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Kumban ye kuu Yuda ye amyenimbon kingkoon, yi bidambib kuu yembed mimyob dowaken keendimaan ye aangko Saiyoniib kowe. ");
INSERT INTO yon_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Ye kurikuri boyambib kuu Ewen areb kamkonomo yenboon, okad kumundin angkimbaraneen areb kwane aron korem angkimbaraneen ande kowoon. ");
INSERT INTO yon_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Ye kangkon ye deme karub Dewid kinekore, sibi oonimbon yaambed nendoon. ");
INSERT INTO yon_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Godbed Dewid kuu sibiyiib yi manayiib oonoon yaambed nen menene God ye nimakarub, Yekob ye awoya ari kui, yi yaa kuu ooni ye korok kerunoon, yembed yi dowad yumbon ongmoondan kui, Israeldan kui. ");
INSERT INTO yon_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Kowe, Dewidbed ma aadidmiyiibban kere ye inameniib dakmiyiib dobiriyiib ibmo keroon kumbed yi kuu oonoon, kwane ye inamen indengandeng mengmeng kumbed ben kinban winimaan kii. ");
INSERT INTO yon_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","God yaningko kankooni ye yook Asafbed wongkoon. O God, eb yaa yikaadban ye ambibkin maa maadan kuu ebbed nub yaa kondewen ye okad aom ana nangme awudiriwen, kwane yimbed eb kurikuri boyambib karadmo kuu monmare yon dowod yeman kerundiwen, kwane yimbed Yerusalem aom ambib monmare arewa keriwen kii. ");
INSERT INTO yon_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Yimbed eb demedan yi bob id kuu ayari on yi animan yeman bangkandiwen, kwane eb karadmodan yi bob id kuu okad yiri dingkan yiman keriwen. ");
INSERT INTO yon_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Yimbed Yerusalem aom kuu nimakarub yeenembiri ye umkanbed ok areb bune awanewandoon, kwane bob id mangkanabaneen ye karuwiibban keroon. ");
INSERT INTO yon_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Nub kuu nub dia doriibdanbed dandi yeman kerenib, nub yaa ambon baande damangkandimaib. ");
INSERT INTO yon_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","O Yariman, aron komoyiib nub yaa norin keendembaraneeb? Aron korem dee? Aron komoyiib koren areb kerewen kumbed norin niminiib wandaneeb? ");
INSERT INTO yon_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Eb yaa yikaadban ye ambibkin maa maadan yi ari kuu eb norin ondukne. Eb yaa baandimokban ye ambibkin maa maadan yi ari kangkon eb norin ondukne. ");
INSERT INTO yon_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Amborom kuu yimbed Yekob ye awoya ari nub korem yenbandenib nuwambibkin monmariwen kowe. ");
INSERT INTO yon_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Nub awoya yiri yi ambarakmi yaambed nub yaa bon kere dabab kondaab, kwane eb mimyob kowi kara kuu kirod nub yaa mene awandok, amborom kuu nub kuu ben kubune miin yirimo kerundiwen kowe. ");
INSERT INTO yon_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","O nub Bobni Yaa Burudande Bindi Ye God, nub yaa awande, ewaningko nambiriyiib keruni dowadbed. Nub kuu bondan yaa burudande bindeneb nuwambarakmi are nonondande, ewaningko ye dowadbed. ");
INSERT INTO yon_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Eb yaa yikaadban ye ambibkin maa maadan kee nub dowad “Yi God kuu kuna?” ande kamimaib kuu ebbed kebene. Yimbed eb demedan yenbande umkan kowiwen kuu ebbed kakman kowaneeb kuu, yi yaa korokbebko yikaadkerime, nub kerebiri arimbed. ");
INSERT INTO yon_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Yimbed nub yena awingke benwiniwendan yi wareki kuu yangmadandaab. Kane kane dukni yeman andiwendan kuu eb aromkono darewoobbed ben angka nongkobe. ");
INSERT INTO yon_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","O Yariman, nub dia doriibdan yi ari kuu yimbed eb yaa dabdi yeman kere dabab bangkabdiwen kuu neman inandunde ediib kerunde. ");
INSERT INTO yon_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Eb nimakarub nub kuu eb kereek amun ari ye sibi areb kowe, yi yaa neman inandunde ediib kerundaneeb kuu, ewaningko aron korem kankoonembaranuub, awoya yaro dobere dobere yaro wananiib korem kuu ewaningko kankooni ye weng dakmembaraniib kui. ");
INSERT INTO yon_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Yook ambo bi ye karub yeman. “Amob Weng Ongmoon ye Bingko Wuung” ye yook ye kiwaan yaambed wingki yeman. God yaningko kankooni ye yook Asafbed wongkoon. O Israeldan Oonimaabman, nub wengamberende. Yosef ye awoya ari kuu sibi oonemoon areb ben kinban winimaabman, engyus burawiib yi kidangkambed king ye dibere oonimbon ari diberewenman kui, eb kuu yure. ");
INSERT INTO yon_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Efraima Benjamina Manaseya yi arinambo ari kuu eb aromkono korokbe. Yaro dembe nub kuu arudbon yaa burudande binde! ");
INSERT INTO yon_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","O God, yumbon kanduwen kwarimbed komburuwen kuu ebbed nub ongmendebko ika kandem. Eb murubia kuu nub yaa konde. Kwananeeb kuu nub kuu arudbon yaa burudande bindaneeb. ");
INSERT INTO yon_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","O Ana Nangmidan Yemoon Ye Yariman God, aron komoyiib eb nimakarub yi kurikuri kebendeneb yi yaa norin wandundaneeb? ");
INSERT INTO yon_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Ebbed yi yaa kuu animan areb mimyob wandembiri yeman kondimaab, kwane yi mimyob wandembiri yeman kuu meneki wongdemaombed kumundinmo kondewen. ");
INSERT INTO yon_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Ebbed nub kuu ongmendeewa nub dia doriibdanbed nub yaa manmo kerundimaib, kwane nub bondanbed nub yaa damangkandimaib kii. ");
INSERT INTO yon_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","O Ana Nangmidan Yemoon Ye God, yumbon kanduwen kwarimbed komburuwen kuu ebbed nub ongmendebko ika kandem. Eb murubia kuu nub yaa konde. Kwananeeb kuu nub kuu arudbon yaa burudande bindaneeb. ");
INSERT INTO yon_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Eb kuu nong yob kab kuu Idyip aombed kanmeneneb, ambibkin yenadan yenburekoreb kwari kibinewen. ");
INSERT INTO yon_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Okad kwari kuu ebbed kab kaini dowad arewen, kwane kab kuu yumburum kubunebene dembe derendaroon. ");
INSERT INTO yon_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Kwane aangko aangko kuu ye kubunbed dabunoon, kwane ye nondong ye kubundem yirimbed at sidaa darewoob yemoon kuu doronoon. ");
INSERT INTO yon_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Ye nondong kuu karamok darewoob angka danganabe weneboon, kwane ye yumburum kuu ok Yufretes angka weneboon. ");
INSERT INTO yon_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Eb komande ye kuuk kuu bongmeebkob, kane kane dewenebiib kuu yi korem kuu nong yob kee wadmimaib? ");
INSERT INTO yon_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Dura awon kiib ambimbed monmare arewa kerunaiwe, kiib dingkanbed kuyaa anengkanabimaib. ");
INSERT INTO yon_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","O Ana Nangmidan Yemoon Ye God, nub yaa angkon ika mene! Ewen arimbed yiri kerekne wedmende! Nong keyaa kee keenombere oone, ");
INSERT INTO yon_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","kab eb dingki wiwi angkambed kibinewen kui, amnindo ye nong kuk ebbed ongmeewa aromne kainoon kui. ");
INSERT INTO yon_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Nong ebbed kibinewen kuu nare korariwen, kwane amotbed nengkiwen kii. Ebbed kamkono ongkandewen yaa kumbed yi kuu dukniwen. ");
INSERT INTO yon_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Eb dingki wiwi angkambed doreen ye karub kuu eb dingki kwari kowe, karub ye mingki kee ebka eb dowad aromnewen kui. ");
INSERT INTO yon_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Kwananeeb kuu nub kuu eb yaa koronde wanaubban. Nub kuu bobnemoon areb keruwen kowe ben aromkono konde. Kwananeeb kuu ewaningko yaa baandanuub. ");
INSERT INTO yon_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","O Ana Nangmidan Yemoon Ye Yariman God, yumbon kanduwen kwarimbed komburuwen kuu ebbed nub ongmendebko ika kandem. Eb murubia kuu nub yaa konde. Kwananeeb kuu nub kuu arudbon yaa burudande bindaneeb. ");
INSERT INTO yon_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Yook ambo bi ye karub yeman. Gitit ye kiwaan wingki yeman. Asaf ye yook. Nub aromkono kondi ye God yaa kubi yook wingkem, Yekob ye God yaa kubimbed baandime! ");
INSERT INTO yon_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Yook andowe wingkime, tambarin wangkime, kuweng amuniib ye laiyayiib haawiib wangkime. ");
INSERT INTO yon_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Kwane wood yeeb naruka sibi durubbed kibi kuu baandime, nub orokbon arimbed kumundin wood keruka kibi kangkon baandime, ");
INSERT INTO yon_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","amborom kuu Israeldan yaa kwanime ande yedme kowoon, kukuu Yekob ye Godbed ye amob weng ongmoon. ");
INSERT INTO yon_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Kuye amob ongmoon kuu Yosef ye awoya ari yaa ika meenime andi yeman, Idyipdan yaa bon keroon yaron arimbed ongmoon kui. Weng yuud ma nekaadban kumbed dawoon, ");
INSERT INTO yon_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“Nembed yiib kandom ari dabab kuu ben kiradmaan kii, kwane yiib dingki aom deme yobdood kuu nembed ben angka nongkobaan. ");
INSERT INTO yon_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Yiib durud yewed wandi yaa kuu ne yaa baandiiwe yiib kuu ben angka nongkobaan. Kwane nembed yiib yaa kuu amkuni ye wiib aombed inandaan, kwane yiib kuu ok Meriba yaambed komboon kaamondaan.Selah ");
INSERT INTO yon_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","O ne nimakarub, wengambiribko ongkandi weng danda. Kumban, o Israeldan, ne weng kuu wengambere awine kandaniib dee? ");
INSERT INTO yon_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Yiib kuu norod ye god maa ye yoman yaa ma wanaib, kwane oworan yi god maa yaa ma bumangkaib. ");
INSERT INTO yon_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Yariman ne kei, nembedmo kuu yiib God, yiib ben Idyip aombed angkadaraanman kuu ne kei. Yiib mongkod daandibko nembed yiminmo bangkanda. ");
INSERT INTO yon_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","“Kumban ne nimakarub kuu ne yaa wengamberedandiwen, Israeldan kuu ne weng awine kandindo kui. ");
INSERT INTO yon_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Kowe nembed yi kuu yi niindem kamkono ye kerekmen kuyaambed kwane winime ande domondaan, yi yaa kuu yiibka yiib inamenmo awinime ande domondaan kui. ");
INSERT INTO yon_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","“O, ne dowaken kuu ne nimakarub ne yaa wengambaraniib andid, Israeldan ne yoman mananiib kuu ne dowaken darewoob kui. ");
INSERT INTO yon_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Kwananiib kuu kirodmo yi bondan ben kubunaniin, yi yaa manmo keriwendan yaa kuu ne dingkimbed kebenaniin kui. ");
INSERT INTO yon_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Kane kane Yariman yaa arud wandembirimaib kuu ye yaa unene ika anuk irinambenaniib, kwane ukum kandaniib kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Kumban, Israeldan, yiib yaa wiit yob amun yeman kuu bangkandembaraniin, kwane dumnad yaa ye in ambodbed kondaniine yiib kuu ane mikmonaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","God yaningko kankooni ye yook Asafbed wongkoon. God kuu kadaareb nedbiwen aom kuu yembed korok kere doreen, yembed ambibkindan yena yi korok korok yaa wengyundimaan kui. ");
INSERT INTO yon_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Yiib kuu aron komoyiib inamen yorokmomban kumbed wengyundaniib? Aron komoyiib miin arewa kamidan yaa kubenib yi weng kande wengyundaniib?Selah ");
INSERT INTO yon_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Wuud keriwendaniib anenabdaniib yi inamen amun yaa kuu koromone daandime, kamboknondaniib dabab wayiroondaniib yaa kangkon kwanime. ");
INSERT INTO yon_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Wuud keriwendaniib awande ande kamiibdaniib kuu ben angka yeknime, arewa kamenabidan yi dingki dem aom kuu yi ben burudande angka nongkobime. ");
INSERT INTO yon_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Kuye korok korok kuu korem ma yikaadban, kwane yi kuu korem ma id kandimokban, kwane yi kuu kumun aom yarebemoon areb keriwen. Okad ambokab korem kuu kiringmeen kii. ");
INSERT INTO yon_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","“Nembed yedmaan, ‘Yiib kuu goddan kii, yiib korem kuu Korem Burudandoon Arimbed ye God ye meed.’ andaan. ");
INSERT INTO yon_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Kumban yiib kuu nimakarub areb duknaniib, yiib kuu okaddan yi korok korem areb no duknaniib kui.” ande yedmoon. ");
INSERT INTO yon_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","O God, yaro dembeneb okaddan kuu wengyunde, amborom kuu ambibkin koremdan kuu ebman kowe. ");
INSERT INTO yon_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","God yaningko kankooni ye yook Asafbed wongkoon. O God, komo keroon yaa kuu iwari keraab, o God, iwari keraab, kwane kuyaa kuu yangmadandaab. ");
INSERT INTO yon_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Kedi, eb bondan kuu yirinde baande kamiib, eb yaa arud wandembirimaibdan kuu wabkad keriwen kui. ");
INSERT INTO yon_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Yi kuu eb nimakarub yaa inamen bangbangbed nuubnaan kamiib, kane kane yaa ebbed bobne komberewendan yaa kuu yimbed wunonwanon kamiib kui. ");
INSERT INTO yon_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Yikareb yedmimaib, “Minibko nub kuu yi yeene monmarubko yi ambibkindan dowan kerok, kwane yi korem yenbandubko ambibkin Israel andi kuu okaddanbed korem nonondandundime.” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Yi kuu weng mimo kan kowe inamen ongmenib, eb yaa bon keri ye amob weng ongmiwen. ");
INSERT INTO yon_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Yi kuu Idomdaniib Ismaeldaniib Moabdaniib Hagaadaniib ");
INSERT INTO yon_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Gebaldaniib Amondaniib Amelekdaniib Filistiadaniib Taiyadaniib kui. ");
INSERT INTO yon_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Asiriadan kwangkon yi yaa dabokniwen, aromkono darewoob arimbed kerundi dowad Lot ye awoya ari yaa kui.Selah ");
INSERT INTO yon_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Midiandan arewa kerundewen kwamune areb yi yaa kerunde. Sisera yoom Jabin yoom yaa ok Kison yirimbed arewa kerundewen kwamune areb yi yaa kerunde. ");
INSERT INTO yon_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Yi ayoob kuu Endoo angkambed dukniwen, kumban mangkindo oyareb andiiwe okad kuri dange deendiwen. ");
INSERT INTO yon_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Eb bondan yi korok korok kuu ebbed Oreb yoom Seeb yoom yaa komarewa kamendewen kuu kwane arebmo kwane kamende. Yi kuu Seba yoom Salmuna yoom ebbed yeene nongkobewen areb kerime. ");
INSERT INTO yon_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Yi ayoob yedmiwen kuu, “God ye bidambib kumbed Israeldanbed yi sibi kabungke kainderebi yeman kuu be nubka oonem.” andiwen. ");
INSERT INTO yon_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","O ne God, yi kwane ben buyokbayok kamebko ingkudmanandeb areb o nati kurukab areb nuubbed awuune ben winimaan areb kerime. ");
INSERT INTO yon_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Amotbed dura nengke korem denuun areb o amot yumbumbed aangkombon denobenmo yaruun areb kuu ");
INSERT INTO yon_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","yi kuu amaa nuuwaa nambadaa areb eb arud wande yenbure wene. Kwane yi kuu uniwon karakwon kerunde. ");
INSERT INTO yon_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","O Yariman, yi murubia ari korem kuu karakbed kebendebko, eb ande onmime. ");
INSERT INTO yon_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Yi kwamune yimin wandaanban ye karak kandenib yi niindem aom miin yiminban kerime, kwane yi aningko yirimo kowebko duknime. ");
INSERT INTO yon_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Yi kwamune yikaadkerime, ewaningko kuu Yariman, ebbedmo kuu okad kumundin burudande arimbed ye God kui. ");
INSERT INTO yon_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Yook ambo bi ye karub yeman. Gitit ye kiwaan wingki yeman. Korah ye karub dana meed yi yook. God yaningko kankooni ye yook. O Ana Nangmidan Yemoon Ye Yariman, eb dobirimbon kuu yeka mamaa manimanandeb kii! ");
INSERT INTO yon_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Ne mimyob buruwandoone ne bobne kombaraan, Yariman ye kurikuri boyambib ye kuuk wirinimbon ye dowad. Ne niindem aomiib ne idiib kuu wad doreen ye God yaa kube wingkaan. ");
INSERT INTO yon_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","On yiwonkib kuu amunbon ari wedmenu yu ambib yenbeen, kwane on berekmad kangkon kuyaa yu ami ongmeen, yu wini kanuun ye dowad. Kukuu eb yaa dingkan aye nengke baeb kabdi yeman diambon kui, o Ana Nangmidan Yemoon Ye Yariman, ne King, ne God. ");
INSERT INTO yon_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Kane kane eb ambiwoom doriib kuu amun kerundewen. Yi kuu ewaningko kankoonembirimaib.Selah ");
INSERT INTO yon_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Kane kane yi aromkono eb yaambed kandimaib kuu amun kerundewen, kane kane yi niindem aom Godiib yaa wenem ande inamen ongmiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Yi kuu kiwaan wedya wene inok wi ye kankubunen yaa nandiwen, kumban kuyaa kuu kirubdem okbon ande meene kubimaib, yi kuu am kubudoroon kumbed amun kerundoon yokad ande meenimaib kui. ");
INSERT INTO yon_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Yi yaa komo komo meneboon kuu God yaromkonomo awine yarebiwen kowe, yi mimim korem kuu Saiyon aom God ye arinambo ari miniwen. ");
INSERT INTO yon_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","O Ana Nangmidan Yemoon Ye Yariman God, ne kurikuri weng kee wengambere. O Yekob ye God, ne yaa wengamberewe.Selah ");
INSERT INTO yon_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","O God, nub dorondari karub yaa wedmene. Ye ari oiyo bune kinewen ye karub yaa kubi dowaken keene. ");
INSERT INTO yon_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Eb kurikuri boyambib ye kuuk wirinimbon aom aronki mimo dobiri kuu miin amun yeman, aronki tauseniib bunangka dobiri arebban. Amun yeman ande meenaan ye deme embeng mimo kukei, ne God yambib ambongko aomnimbon yaa ooni, kukuu arewa kamenabidan yi kombon aombed deme darewoob awini arebban. ");
INSERT INTO yon_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Amborom kuu Yariman God kuu aron ye nambiri areb, ye kuu kombe areb, Yariman kuu kubi dowakeniib aningko kankooniyiib bangkandimaan. Komo komo amun kuu yeka kirim kere amuknindo, kane kane kangdommo doriib kuyaa kwane bangkandimaan. ");
INSERT INTO yon_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","O Ana Nangmidan Yemoon Ye Yariman, eb yaambed angkumone doreenman kuu amun kerunewen kii! ");
INSERT INTO yon_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Yook ambo bi ye karub yeman. Korah ye karub dana meed yi yook. God yaningko kankooni ye yook. O Yariman, eb bidambib yaa kubi dowaken darewoob keendewen, kwane Yekob ye awoya ari kuu awande ongmendeewa amun yiminmo keriwen. ");
INSERT INTO yon_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Eb nimakarub yi ambarakmi kuu are nonondandundewen, yi ambarakmi kuu korem dabunewen kui.Selah ");
INSERT INTO yon_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Yi yaa norin kowewen korem kuu deerewandewen, kwane arud denobewen kuu korondewen. ");
INSERT INTO yon_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","O nub Bobni Yaa Burudande Bindi Ye God, nub ikakman ongmendebko amunmo doberem, kwane nub yaa kongendewen kuu korondene. ");
INSERT INTO yon_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Eb kuu nub yaa aron korem arud kowembaraneewoo? Eb norin kuu nimakarub yaro dobere dobere yaro wananiib korem aom angkimbaraneenoo? ");
INSERT INTO yon_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Eb nimakarub eb yaa kubi dowad kuu, ebbed nub ikakman ongmendaneewe amunmo dobaranuuwoo? Anamaa. ");
INSERT INTO yon_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","O Yariman, eb womoniyiibban ye mimyob dowaken kuu nub yaa korokbende. Kwane, nub kuu bobni yaa burudande binde. ");
INSERT INTO yon_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Yariman Godbed komo yedmaneen kuu wengambaraniin, yembed yewenubmo dobaraniib andi ye weng kunduk yedme kowaneen, ye karuwa nimaya yaa, ye karadmo kerundoondan yaa kui. Kwane, yi yaa kuu inameniibban ye dobiri yaa ika wanaib ande kebenendaneen. ");
INSERT INTO yon_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Anam kuu kane kane ye yaa une bumangkimaib kuu yembed bobni yaa burudande bindi dowad yaro nekwoon. Kwananeen kuu ye nambiri kuu nub okad kwari angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Womoniyibban ye mimyob dowakeniib ma korondaanban awinaneen andiyiib kuu dabokniwen, yorokmo dobiriyiib yewenubmo dobiriyiib kangkon dabokniwen. ");
INSERT INTO yon_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Nimakarub yi ma korondiyiibban ye weng awinimaib ye kerekmen kuu okad yirimbed daanaane, God ye yorokmo dobiri kerekmen kuu Ewen arimbed kan kiri kowe kereknimaan. ");
INSERT INTO yon_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Anamaa, komo komo amun kuu Yarimanbed bangkandaneene, nub okad yiri kuu animan kab yeere id yemoon keraneene wandanuub. ");
INSERT INTO yon_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Yorokmo dobiri ye kerekmen kuu king meneen ande baandi ye karub areb God ye arinambo ari wenene, ye dodkanmo mini ye kiwaan nekwimaan. ");
INSERT INTO yon_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Dewid ye kurikuri weng. O Yariman, wengamberewe inanduwe, amborom kuu ne kuu dabab wayiroone awawime ande kamimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Ne wadkeri kuu oone, amborom kuu eb dowad yaamo doriin kowe. O ne God, eb deme karub ne kei, ne eb yaa angkomone doriin kowe ne nen dorondare. ");
INSERT INTO yon_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","O Yariman, ne yaa mimyob keewe, amborom kuu aronki doboob kuu eb yaa baandimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Eb deme karub ne yaa kuu kubi kanmene, amborom kuu, o Yariman, eb yaa kuu ne wadkeri kankoonimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","O Yariman, eb kuu amunmoman kuda, eb kuu ambarakmi are nonondandi ye karub, kwane kane kane eb yaa baandimaibdan kuu womoniyiibban ye mimyob dowaken yiminmo keendimaab. ");
INSERT INTO yon_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","O Yariman, ne kurikuri kee wengambere. Mimyob keewe ande baandaan yaa kuu wengambere inande. ");
INSERT INTO yon_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Ne dabab kandi yaron ari kuu eb yaa baandaniin, amborom kuu inanduwaneeb kowe. ");
INSERT INTO yon_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","O Yariman, goddan kuyaom kuu ma kanembed eb arewiibban, ebbedmo ari. Kwane, eb kamenabi yaa kuu kumun kinindeban. ");
INSERT INTO yon_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","O Yariman, ambibkin koremdan kuu ebbed ongmenabewen kowe, mene eb arinambo ari ewaningko kankoonaniib, kwane yi kuu ewaningko yaa nambiri kankowaniib. ");
INSERT INTO yon_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Amborom kuu eb kuu darewoob arimbed, ebbed miin amun yeka mamaa kamenabimaab kowe. Ebbedmo kuu God. ");
INSERT INTO yon_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","O Yariman, eb kara kedmengkawe. Kwananeeb kuu ne kuu eb anam anam yaambed dobaraniin. Ne niindem aom andokbiyiibban ye inamen kawe. Kwananeeb kuu ne kuu ewaningko yaa une bumangkaniin. ");
INSERT INTO yon_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","O ne Yariman God, ne niindem aom kumundin kumbed eb yaa kubaniin, kwane ewaningko yaa kuu aron korem nambiri kankowaniin. ");
INSERT INTO yon_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Amborom kuu eb womoniyiibban ye mimyob dowaken ne yaa minimaan kuu miin darewoob kii, kwane ebbed ne kuu bobkonombon kongdem yirimbed nen angka kowewen. ");
INSERT INTO yon_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","O God, nubbedmo yimin andidanbed nandamiib kii, yi kuu yeremboromdan kumbed ne neene kowande onmiib, yi kuu eb yaa meenimokbandan kui. ");
INSERT INTO yon_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Kumban, o Yariman, eb kuu mimyob keene kakman are nonondandi ye God, eb kuu kabamoon kondoon ye mimyob dowaken keendi ye God, eb kuu kirod arud wandi ye karubban, eb kuu womoniyiibban ye mimyob dowakeniib ma korondiyiibban no awinembiriyiib yiminmo ye karub kui. ");
INSERT INTO yon_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Ne yaa amonombeneb mimyob keewe kakman are nonondande. Eb deme karub ne yaa kuu eb aromkono kawe. Kwane, eb deme wonong yu karub dana ne kuu bobni yaa burudande nende. ");
INSERT INTO yon_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Ne yaa amun amun kamimaab ye dud kuu korokbewe. Kwanebko ne bondan kuu wedmekorib karak bobnime. O Yariman, ebbed awaweneb ne mimyob wandaan kuu kankubunewen kuda. ");
INSERT INTO yon_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Korah ye karub dana meedbed wongkiwen. Yook, God yaningko kankooni ye yook kui. Ye siti yenboon ye ambokab kuu aangko aangko karadmo arimbed kii. ");
INSERT INTO yon_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Yariman kuu Saiyon ye siti ye kuuk ambongkombon korem yaa mimyob dowaken kowimaan, Yekob ye awoya ari korem yi ambib yaa arebban. ");
INSERT INTO yon_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","O God ye siti, kub dowad weng amun manimanandewiib dakmimaib.Selah ");
INSERT INTO yon_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","“Idyipdan yoom Babilondan yoom kuu ne yaa anam andaniib kowe, ne karuwa nimaya andaniin. Filistiadaniib Taiyadaniib Kusdaniib kangkon ‘Yi kambong anam kuu Saiyon.’ ande yedmaniin.” ande yedmoon. ");
INSERT INTO yon_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Anamaa, Saiyon yu dowad kwamune yedmaniib, “Nimakarub keyiiwa yakuyiib kuu yu aombed wooniwen, kwane Korem Burudandoon Arimbed ye God kuu yekareb kumbed yu yaa yumbon kondaneene doberembaranuun.” andaniib. ");
INSERT INTO yon_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Yarimanbed kwane nimakarub korem yi aningko wongkaneen ye buk aom kuu, “Ye kee Saiyon aombed wooneen.” ande wongkaneen.Selah ");
INSERT INTO yon_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Yi kuu kube andenabe yook wingkane “Nub yaa amun kerundi korem kuu eb yaambed meneboon.” ande kamaniib. ");
INSERT INTO yon_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Yook, God yaningko kankooni yook Korah ye karub dana meed yiman kui. Yook ambo bi ye karub yeman. Mahalat leanot ye kiwaan wingki yeman. Maskil ye yook Esraman Hemanbed wongkoon. O Yariman, ne bobni yaa burudande nendi ye God, aronkiyiib amkiyiib kuu eb arinambo ari baandimain. ");
INSERT INTO yon_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Korondewo ne kurikuri kee eb arinambo ari monok, eb kerendem kan amonombe ne yaa koweneb ne baandi wengambere. ");
INSERT INTO yon_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Kedi, ne niindem aom kuu dabab yemoon demboon, kwane ne kuu bobniin dia keroon. ");
INSERT INTO yon_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Ne ande yoworandamiibdan kuyaom kuu ye kuu ma ande yedmimaib, Ne kuu aromkono korem wonoonman areb keraan. ");
INSERT INTO yon_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Ne kuu nenwene dukniwendaniib yaa kowiwen, ne kuu bobnoonman ye bobkonombon yiri angkimberemoon areb keraan kui. Ebbed ma meenewindo ye karub areb keraan, eb awawe oonewi kuu ne yaa menebokban kui. ");
INSERT INTO yon_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Ebbed ne kanduneb dem ambab yiri kaanewen, dem kumunmo kongdem yiri kui. ");
INSERT INTO yon_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Eb norin kuu dabawiib ne ari kereknewen, oknondok areb eb arud kuu ne ari dabunewen kui.Selah ");
INSERT INTO yon_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Ebbed ne angkodmia kuu ambengkandeneb ongmeweewa yi kuu ne yaa akmendanduwiwen. Ne kuu wii aom kaanemoon areb kereni bunangka angkadirinban keraan. ");
INSERT INTO yon_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Ne mimyob wandembaraan kumbed ne indob kuu aromkonoyiibban keroon. O Yariman, aronki korem eb yaa baandimain, kwane ne dingki kuu eb yaa benkoobe baandimain. ");
INSERT INTO yon_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Binangke eb kuu anam andi yeman kuu dukniwendan yi dowad ongmaneewoo? Dowan! Dukniwendan kuu yaro dembe ewaningko kankoonaniiwoo? Dowan!Selah ");
INSERT INTO yon_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Eb womoniyiibban ye mimyob dowaken ye weng kuu bobkonombon yiri daandaniiwoo? Dowan! Eb ma korondiyiibban no awinembiri ye kerekmen ye weng kuu monmarimbon yiri daandaniiwoo? Dowan! ");
INSERT INTO yon_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Binangke eb kuu anam andi yeman kuu kumunbon aom doriibdan kuu yikaadoo? Dowan! Eb yorokmo kamenabi kuu korem nonondandimbon aom doriibdan kuu yikaadoo? Dowan! ");
INSERT INTO yon_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Kumban, o Yariman, eb yaa awawe ande baandimain, amkimo kuu eb yaa kurikuri kamimain. ");
INSERT INTO yon_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","O Yariman, komandewed ne kuu akmendanduwewen? Komandewed ne yaa kuu wedme yangmad danduwewen? ");
INSERT INTO yon_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Ne kuu kewed yaambed mene kibikee ne ari dabawiibmo kereni mene bobni dia keroon, kwane uniwon karakwon yeman ongmenabewen kumbed durud yewed kandeni miin yiminban keraan. ");
INSERT INTO yon_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Arud denobewen kumbed neene kan yiri kowoon, kwane uniwon karakwon yeman ongmenabewen kumbed neene monmarewen. ");
INSERT INTO yon_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Kuyeman kuu aronki doboob ne yaa urok areb derebe kanawanewandoon, kwane ne nen yukne dowan keroon. ");
INSERT INTO yon_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Eb kuu yubudkawidaniib nangkodmiayiib kuu ben ambab angka nongkobewen, kwane kumun aommo nembirimo keraan. ");
INSERT INTO yon_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Maskil ye yook Esraman Itanbed wongkoon. Ne kuu Yariman ye womoniyiibban ye mimyob dowaken ye dowad aron korem yook wingkaniin, kwane eb ma korondiyiibban eweng awini ye kerekmen kuu nimakarub yaro dobere dobere yaro wananiib korem aom ne mongkodkonombed kedmengkandaniine yikaadkeraniib. ");
INSERT INTO yon_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Kedi, nembed yedmaan, “Eb womoniyiibban ye mimyob dowaken kuu darewoob ari kere weneen aron korem, kwane eb ma korondiyiibban eweng awini ye kerekmen kuu ebbed yumbon ongmewen kuu Ewen arimbed kii.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Ebbed yedmewen, “Nembed kinaanman yaa kuu amob weng ongmaan. nembed ne deme karub Dewid yaa yedme koweni yedmenaan kuu kei, ");
INSERT INTO yon_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Nembed eb yob dowad aron korem ye yumbon konaniin, kwane eb dibere ooni ye yumbon kuu nimakarub yaro dobere dobere yaro wananiib korem aom kwane angkimbaraneen.’ andaan.” andoon.Selah ");
INSERT INTO yon_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","O Yariman, binangke eb yaa anam andi yeman ongmenabewen kuyaa kuu Ewen aridanbed miin amun yeman andimaib, kwane eb ma korondiyiibban eweng awini ye kerekmen kuu karadmodan nedbenib miin amun yeman andimaib. ");
INSERT INTO yon_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Kedi, ambid ari karub kane kuu Yariman yaa ma ibnaneen? Dowan. Ewen ari karub kane kuu Yariman yaa ma ibnaneen? Dowan. ");
INSERT INTO yon_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Karadmodan nedbimaib kuu yi korem God yaa uni darewoob kerimaib, kwane yembedmo kuu unimbonman, kwane kane kane ye yaa awanewandiwendan korem kuu ye arebban. ");
INSERT INTO yon_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","O Ana Nangmidan Yemoon Ye Yariman God, eb areb kuu kane? Dowan. O Aromkonomo Ye Yariman, eb ma korondiyiibban eweng awini ye kerekmen kuu eb yaa kanawanewandoon. ");
INSERT INTO yon_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Eb kuu karamok oknondokiib yaa kuu oonimaab. Kwane oknondok kubune daane kaimaun kuu ebbed ben kubunebimaab. ");
INSERT INTO yon_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Ebbed Rehab kuu dore bunbeewe bobnoon, kwane eb dingki aromkonombed eb bondan kuu ben buyokbayok kerundewen. ");
INSERT INTO yon_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Eweniib ambidiib kuu ebman, okad kangkon ebman, kwane ebbed okadiib yu kumkam koremiib ongmenabewen. ");
INSERT INTO yon_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Kwane, ebbed kariyiib kiriyiib kuu ongmenabewen. Aangko Taboo yoom aangko Heemon yoom kuu ewaningko ye dowad kubi yook wingkimaib. ");
INSERT INTO yon_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Eb dingki kuu aromkono kaiyiib, eb dingki birid kangkon aromkonoyiib, eb dingki wiwi kuu nambiriyiib. ");
INSERT INTO yon_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Yorokmo dobiriyiib anammo wengyundiyiib kuu eb dibere oonimbon ye ambokab, kwane womoniyiibban ye mimyob dowakeniib anam anamiib kuyaambed kwane ambangkimaab. ");
INSERT INTO yon_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Kane kane eb yaa kube baandimaib kuu amun kerundimaab, o Yariman, yi kuu eb arinambo ari eb nambiri aom winimaib kui. ");
INSERT INTO yon_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Yi kuu aronki doboob ewaningko yaa kubimaib, kwane yi kuu eb yorokmo kerekmen yaambed benkoobimaab. ");
INSERT INTO yon_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Amborom kuu ebbedmo kuu yi aromkono ye nambiri, kwane eb kubi dowaken yaambed nub aromkono kuu arimbed kondewen. ");
INSERT INTO yon_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Kedi, nub dorondari ye karub kuu Yarimanbed oonoon, nub king kuu Israeldan yi God Karadmo ye karub kui. ");
INSERT INTO yon_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Anuk kuu ebbed eb karadmodan yaa wane angkadere daandewen, “Nembed ana nangmi yekaad ye karub yaa awanenaan, nembed nimakarub kuyaombed kinaanman kuu nen aningko arimbed konaan kui. ");
INSERT INTO yon_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Ne deme karub Dewid wedmenaan. Ne oiyo karadmombed ye ari bune kinaan. ");
INSERT INTO yon_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Ne dingkimbed awanenembaraniine kangdommo doberembaraneen, kwane ne dingkimbed aromkono konembaraniin. ");
INSERT INTO yon_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Bondan kuu ye yaa bironaibban, kwane miin arewa kamenabi ye karub kuu ye yaa dabab wayiraanban. ");
INSERT INTO yon_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Nembed ye arinambo arimbed ye bondan kuu dore bunbeni, ye yaa manmo keriwendan kuu yengkadmaniin. ");
INSERT INTO yon_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Ne ma korondiyiibban weng awini ye inameniib womoniyiibban ye mimyob dowakeniib kuu ye yaa angkimbaraneen, kwane naningko yaambed ye aromkono kuu arimbed konaniin. ");
INSERT INTO yon_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Nembed karamok kande ye oonimbon aom kowaniin, kwane ok awaan ari ben ye oonimbon aom nongkobaniin. ");
INSERT INTO yon_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Yembed ne yaa baande yedmaneen, ‘Eb kuu ne Ambe, ne God, ne Bobni Yaa Burudande Nendi Ye Karub, ne aromkonombon.’ andaneen. ");
INSERT INTO yon_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Nembed ye angkon ne wonob dana areb kine kowaniin, kwane ye kuu okaddan yi king korem burudande aningko arimbed konaniin. ");
INSERT INTO yon_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Aron korem ye yaa womoniyiibban ye mimyob dowaken keenembaraniin, kwane ye yaa amob weng ongmaan kuu dowan keraanban. ");
INSERT INTO yon_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Nembed ye awoya ari yaa kuu aron korem ye yumbon kondaniin, ye dibere ooni ye yumbon kuu Ewen areb aron korem angkimbaraneen kui. ");
INSERT INTO yon_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Kumban ye dana meed kuu ne amob yaa wunekaraniib o yi kuu wongkaan ye amob yaa awinaibban keraniib ");
INSERT INTO yon_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","o dakmaan ye amob yaa domokbaniib o kwanime andi ye amob yedme kowaan yaa korondaniib kuu, ");
INSERT INTO yon_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","nembed yi ambarakmi dowad atdebokbed ukum kondeni yi arewa kami dowad nong yikyikiibbed wangkaniin. ");
INSERT INTO yon_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Kumban ne mimyob dowaken Dewid yaa keenaan kuu angkon neka kandainban, kwane ne ma korondiyiibban weng awini ye kerekmen ye yaa angkeen kuu bongmainban. ");
INSERT INTO yon_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Amob weng ongmaan kuu domokbainban, kwane ne mongkodkonombed komo dakmaan kuu kan kimyen kerainban. ");
INSERT INTO yon_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Naningko karadmo yaambed mimo yedme kowaan, kukuu Dewid yaa biranainban andi yeman kui, ");
INSERT INTO yon_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Nembed ye awoya ari yaa kuu aron korem ye yumbon kondaniin, ye dibere ooni ye yumbon kuu aron diberembirimaun areb ne arinambo ari angkimbaraneen kui. ");
INSERT INTO yon_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Kukuu wood diberembirimaun areb aron korem angkimbaraneen, kwane wood ambid aom diberembirimaun kuu God ye weng yaa anam ande wedmi yeman.” andoon.Selah ");
INSERT INTO yon_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Kumban, o God, ebbed nub king kuu wunekare kan angka korarewen, ebbed ye ari oiyo bune kinewenman yaa arud darewoob wandewen kui. ");
INSERT INTO yon_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Eb deme karub yaa amob weng ongmewen kuu kibikbed ari kuu awinainban andewen, kwane king keroon ye kuru ye korok ari dereni yeman kuu monmare ingkud yiri korarewen. ");
INSERT INTO yon_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Ebbed ye siti kuuk kuu bongmeneb ye aromne angkumonimbon korem monmareewe ambib bob areb kereen. ");
INSERT INTO yon_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Ye aromkono dowan kowe korem kane kane kuyaa dewene burudandimaib kuu ye yiribman ogoodmo yid bimaib, kwane ye dia doriibdanbed damangkanimbon keruniwen. ");
INSERT INTO yon_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Ebbed ye bondan kuu awande aromkono kondewen, kwane ebbed ye yaa kwamewen kowe ye bondan korem kuu kubiwen. ");
INSERT INTO yon_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Ebbed ye kerewang arud kuu dingkekoreb, ana nangmi yaa kuu awanenindo kerewen. ");
INSERT INTO yon_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Ebbed ye nambiri kuu kan korarekoreb, ye dibere oonimbon kuu kan okad yiri korarewen. ");
INSERT INTO yon_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Ebbed ye kewed yaa yaromkono kuu monmare kiomnoon ye karub areb kerunekoreb, karakmo kerunewen.Selah ");
INSERT INTO yon_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","O Yariman, aron komoyiib? Eb kuu ne yaa aron korem kwane biknembaraneeb dee? Eb norin kuu aron komoyiib amot areb denembaraneen? ");
INSERT INTO yon_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Ne wadkeri kuu kirodmo dowan keraneen kuyaa ika meene. Kedi, nimakarub korem kuu idiib kerindeban ye dowad ongmenabewen kii! ");
INSERT INTO yon_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Karub kuu komo kere dobere bobni wedmokban kerene, bobni yaromkono yaa kuu burudandaneen? Dowan!Selah ");
INSERT INTO yon_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","O Yariman, anuk kuu ma korondiyiibban weng awini ye inamen Dewid yaa yedme kowewen kumbed eb mimyob dowaken darewoob keenewen kuu kuna? ");
INSERT INTO yon_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","O Yariman, eb demedan yaa damangkandiwen kuyaa ika meene. Ambibkin yemoondanbed ne yaa damangkawiwen kumbed ne niindem aom yiminban keraan kuyaa ika meene. ");
INSERT INTO yon_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","O Yariman, eb bondanbed damangkawiwen kuyaa ika meene. ebbed ye ari oiyo bune kinewenman komo komo kamenaboon yaa damangkaniwen kuyaa ika meene. ");
INSERT INTO yon_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Yariman yaa aron korem amun kerunemborok! Anam kwanok, kedi, anam kwanok. ");
INSERT INTO yon_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","God ye karub Moses ye kurikuri weng. O Yariman, andowoon yirimbed nimakarub yaro dobere dobere yaro wananiib korem aom kuu eb kuu nub dobirimbon kere doreeb. ");
INSERT INTO yon_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Aangko aangko ongmenabindo yaron o ebbed bidiib okad kumundiniib ongmenabindo yaron, aron korem anuk doberewenbed mene aron korem ambab ari dobaraneeb kui, eb kuu God. ");
INSERT INTO yon_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Ebbed kinewen yaron ari keraune nimakarub kuu angkon ika okad kerimaib, kwane “O karuwa nimaya, ikakman okad kerime.” ande yedmimaab. ");
INSERT INTO yon_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Kedi, ebbed meenimaab kuu weeb 1,000iib kuu kinon areb aronki mimo kibikee dowan keroon, kukuu amnoom kereknembiridanbed awas kaningiib kereknimaib ye aron ye doboob areb. ");
INSERT INTO yon_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Yi kuu urok areb oronde ben mangkan weneewe dukniwen. Yi kuu amkimo kereek biid yeeb yeedirimaan areb, ");
INSERT INTO yon_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","kereek kuu amkimo biid yeeb yeedirimaan kuned, oobnon angka kuu nuubne kombere koknimaan kui. ");
INSERT INTO yon_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Kedi, nub kuu eb norinbed yeene monmarimaab, kwane eb kongendaawe uniwon karakwon kerimaub. ");
INSERT INTO yon_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Nub ambarakmi kuu ben eb murubia ari yurewen, nub yemyeb ambarakmenabi kuu eb kerebiri ye nambiri ari ben nongkoboon kui. ");
INSERT INTO yon_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Kedi, eb norin kumbed nub wad dobiri yaron kuu dukmenmo narimaab, nub kuu wad dobiri yaron dowan kerimaub kuu warekiyiib kamimaub. ");
INSERT INTO yon_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Nub dobiri ye weeb kuu weeb 70yiib, o dobiri yaromkonoyiib keranuub kuu weeb 80yiib dobaranuub. Kumban nub weeb doburuwen aom kuu kuna kuu weeb amun ande meenimaub kangkon deme yobdoodiib dabab yemooniib, kedi, weeb kuu kirodmo dowan kere wanaune nub kuu domonde winimaub. ");
INSERT INTO yon_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Kane kuu eb norin yaromkono wedmoon? Eb norin wedmaneen kuu eb yaa unaneen, eb yaa uni kuu yimin kui. ");
INSERT INTO yon_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Nub yaa kedmengkandebko nub dobiri ye aronki kuu yemoonban meene kaadkerem, kwananuub kuu God ye kerebiri ari meeni kangdomiib keranuub. ");
INSERT INTO yon_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","O Yariman, ika mene! Aron komoyiib kwane manaabban keraneeb? Eb demedan nub yaa kuu mimyob keende. ");
INSERT INTO yon_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Amkimo korem eb womoniyiibban ye mimyob dowaken keendebko kubimo kerem, kwananeeb kuu kubi yook wingkane nub aronki korem kube doberembaranuub. ");
INSERT INTO yon_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Nub yaa dabab kondewen ye aronki kimingkeneb aronki ibmo kwamune areb kubi kondembere. Miin arewambed nub dabuknandoon ye weeb kimingkeneb aronki ibmo kwamune areb kangkon kubi kondembere. ");
INSERT INTO yon_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Eb ambangkenabi kuu eb demedan yaa korokbenande. Eb dobiri manimanandeb yiyiib yi danayayiib yaa korokbenande. ");
INSERT INTO yon_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Nub Yariman God ye kubi dowaken kuu nub yaa angkimborok. Komo ambangkimaub kuyaa kuu amun ande. Eyokee, komo ambangkimaub kuyaa kuu amun ande. ");
INSERT INTO yon_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Karub kane kuu Korem Burudandoonman ye dorondarimbon aom dobaraneen kuu Aromkono Koremman ye kubun aom kwane dobaraneen. ");
INSERT INTO yon_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Nembed Yariman yaa yedmaniin, “Ne kukbimaabbon, ne aromne angkumonimbon, ne God, eb yaambed angkumone doriin.” andaniin. ");
INSERT INTO yon_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Anam kuu yembed eb kuu arud ye barang ye kawaad nong yaa nen angka kowaneen, kwane dukni yeman ye bob anikad yaa kangkon eb kuu nen angka kowaneen. ");
INSERT INTO yon_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Ye buraab kumbed eb kuu kankowe dabunaneen, kwane ye buraabdem aombed eb kuu kukbaneen, ye ma korondiyiibban weng awini ye inamen kuu eb kombe areb eb aromne angkumonimbon areb kui. ");
INSERT INTO yon_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Amnoom ye arud barang yaa kuu eb unaabban, kwane awingyabbed barandi ye ana yaa kangkon unaabban. ");
INSERT INTO yon_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Dukni yeman amnoombed yareboon yaa unaabban, kwane monmari yeman aronkob angka yenbandimaan yaa kangkon unaabban. ");
INSERT INTO yon_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Karub 1,000iib kuu eb dia yowore kuburiwen keraneen o karub 10,000iib kuu eb wiwi angka yowore kuburiwen keraneen kuu arud barang maambed eb yaa ma dia keraanban. ");
INSERT INTO yon_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Eb kuu eb indobmo kerekne wedmaneewe, miin arewa kamenabidan yaa ukum kondaneen. ");
INSERT INTO yon_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Kedi, Yariman kuu eb kukbimaanman. Korem Burudandoon Arimbed Ye God ye kerekmen yaambed doreeb kowe, ");
INSERT INTO yon_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","arud ye barang kuu eb yaa ma mene aanban, monmari yeman kuu ewambib dia ma manaanban kui. ");
INSERT INTO yon_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Amborom kuu Godbed ye engyus eb dowad ben yuraneena eb kuna kuna wini ye dowad kerebdombere oonaniib kowe. ");
INSERT INTO yon_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Eb kuu yi dingkimbed awine kankoonaniib, eb yon kuu bot arimbed enbandaan andiwed. ");
INSERT INTO yon_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Ebbed laiyoniib niin arud niin kobrayiib kuu dore bunganeeb, laiyon arudiib niin arud niin kambariyiib kangkon dore bunganeewe duknaniib. ");
INSERT INTO yon_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Yarimanbed yedmoon, “Ye kuu ne yaa mimyob dowaken keewimaan kowe, arud ye barang yaa kuu ye nen angka kowaniin. Yariman kuu ne God ande yedmimaan kowe, ye nen dorondaraniin kii. ");
INSERT INTO yon_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Ye kuu ne yaa baandaneene nembed inandunaniin. Dabawiib keraneene ne kuu ye yaa dobere awanenaniin. Ye kuu bobni yaa burudande nendeni ye aningko kuu arimbed kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Aron doboob ye dobiri konaniine kubimo dobaraneen, kwane bobni yaa burudande bindi ye kiwaan nembed ongmaan kuu korokbenaniin kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Yook, God yaningko kankooni yook kui. Sabat aron ari wingki yeman. Yariman yaa eso andi kuu amun, o Korem Burudandoon Arimbed Ye God, ewaningko kankooni ye yook wingki kuu amun kii. ");
INSERT INTO yon_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Amkimo korem eb womoniyiibban ye mimyob dowaken daandi kuu amun, amnoom korem eb ma korondiyiibban weng awini ye kerekmen daandi kangkon amun kii. ");
INSERT INTO yon_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Ewaningko kankooni dowad nong angko angkoyiib ye laiya wangki kuu amun, ewaningko kankooni dowad kuweng amuniib ye haap wangkenabi kangkon amun kii. ");
INSERT INTO yon_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","O Yariman, eb ambangkenabi kumbed kubaan kuda. Eb dingkimbed komo komo kamenabewen kuye dowad kubi yook wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","O Yariman, eb kamenabi kuu miin darewoob arimbed! Eb meeni inamen kuu miin indengandengmo. ");
INSERT INTO yon_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Inameniibbandan kuu yikaadban, awon korokdan kangkon kaadkerindeban yeman kukei, ");
INSERT INTO yon_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","miin arewa kamenabidan kuu kereek areb yemoon yeedere kainimaib, kwane ambarakmidan kuu yiribman yemoon kerimaib kumban, yi kuu aron korem dowad ben monmare dowan keraneen. ");
INSERT INTO yon_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Kumban, o Yariman, eb kuu aningko darewoob arimbed kwane aron korem doberembaraneeb. ");
INSERT INTO yon_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","O Yariman, eb bondan kuu duknaniib kuda, yi korem kuu monmare dowan keraneen kii, kwane ambarakmidan korem kuu buyokbayok keraniib. ");
INSERT INTO yon_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Ebbed ne aromkono kuu oksen kiib areb darewoob arimbed kankonewen, kwane oiyo yeweb kuu ne ari bune kinewen. ");
INSERT INTO yon_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Ne indobbed wedmendaan ne bondan kuu Godbed nangme burudande doroon, kwane ne kerendembed wengambaraan miin arewadan ne yaa manmo keriwen kuu nangmoone ikakman kirokmone winiwen. ");
INSERT INTO yon_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Yorokmodan kuu orom at areb kirodmo kaine amne amunmo dobaraniib, yi kuu Lebanon ye at sidaa areb amunmo kaine amnaniib kui. ");
INSERT INTO yon_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Yi kuu at Yariman yambib yaa kibingkemoon areb keraniib, yi kuu nub God ye kurikuri boyambib yu kuuk wirinimbon aom amunmo dobaraniib kui. ");
INSERT INTO yon_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Yi kuu kiomnaniib kumban yowiib iremoon areb kere dobaraniib, yi kuu at nunungiib awoyeebmo areb aromkonoyiib dobaraniib kui. ");
INSERT INTO yon_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Yi kuu kwane yedmaniib, “Yariman kuu kangdommo, ye kuu nub aromkonombon, ye kuu ma arewayiibban.” andaniib. ");
INSERT INTO yon_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Yariman kuu oone doreen, ye kuu ebkad doboob inwaremoon areb dobiri manimanandewiibmo doreen. Yariman kuu aromkono kan ebkad doboob inware kobaiknong boronemoon areb awine doreen. Okad kuu kan ongme kowoone yumbon kamkonoyiib kereen, kowe kan dewenebinban. ");
INSERT INTO yon_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Eb dibere ooni yeman ye yumbon kuu kurin kurin anukbed ongmewen, eb kuu aron korem anukbed mene kibikee doreeb. ");
INSERT INTO yon_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","O Yariman, karamok korem kuu baandiwen, karamok korem kuu kan ari kowe baandiwen, karamok korem kuu yi oknondok darewoob ben ari nongkobiwen. ");
INSERT INTO yon_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Arimbed Doreen Ye God kuu aromkonoyiib, ok arud yemoon yi kuweng arebban, karamok yu oknondok kambari beengkimaun arebban kui. ");
INSERT INTO yon_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","O Yariman, eb kerekmen korokbi ye weng kuu amonombaanban kwane angkimbaraneen. Ewambib kuu karadmo doruun, aron korem korem kwamunemo. ");
INSERT INTO yon_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","O Yariman, eb kuu arewa kamenabi yaa kakman kondi ye God, o arewa kamenabi yaa kakman kondi ye God, eb angkadere. ");
INSERT INTO yon_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","O okaddan yaa Wengyundi Korok, yaro doreneb, kerengkandan komo kamenabiwen kuyaambed kakman ingkande. ");
INSERT INTO yon_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","O Yariman, miin arewa kamenabidan kee komarewa? Miin arewa kamenabidan kuu aron komoyiib kubembaraniib? ");
INSERT INTO yon_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Yi kuu nubbedmo yimin andi ye weng yemoon dakmenabimaib, miin arewa kamenabidan korem kuu kerengkan weng dakmimaib kumbedmo. ");
INSERT INTO yon_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","O Yariman, yi kuu eb nimakarub ben yob beengkemoon areb kerundimaib, yi kuu ebbed yumbon kondewendan yaa dabab wayirimaib. ");
INSERT INTO yon_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Yi kuu iribdaniib owoddaniib yeene nongkobimaib, kwane yi kuu anenabdan kuman yenbandaiwe duknimaib. ");
INSERT INTO yon_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Yimbed kwane yedmimaib, “Nubbed komo kamuub kuu Yariman ma wedmendokban, Yekob ye God kuu yangmadande doreen.” andimaib. ");
INSERT INTO yon_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Israeldan yi inameniibbandan, yiib kuu kaadkerime! Awon korokdan kui, yiib kuu komo aron arimbed kaadkeraniib? ");
INSERT INTO yon_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Kerendem ongmoon ye God kuu wengambirindebankowoo? Indob ongmoon ye God kuu wedmindebankowoo? ");
INSERT INTO yon_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Ambibkin maa maadan didangkimaan ye God kuu ongkandindebankowoo? Nimakarub kedmengkandimaan ye God kuu kaadkerindokowoo? ");
INSERT INTO yon_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Yariman kuu nimakarubbed komo komo meenimaib kuu yekaad, kwane yi kuu inumni mimo areb kangkon yekaad. ");
INSERT INTO yon_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","O Yariman, ebbed didangkewenman kuu amun kerunewen. Eb amob yaambed kedmengkanewenman kangkon amun kerunewen. ");
INSERT INTO yon_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Kuye karub kuu ye yaa dabab menebaneen kuu ebbed nen awanenaneeb, miin arewa kamenabidan yi dowad dem nidke dowan keraneeb kumbed. ");
INSERT INTO yon_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Amborom kuu Yariman kuu ye nimakarub yaa domondaanban, yembed yumbon kondoondan yaa domondaanban kui. ");
INSERT INTO yon_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Amaan ari kuu korok korokbed angkon ika yorokmo ye kerekmen yaambed wengyundaniib, kwane kangdommo doriibdan korem kuu kuye wengyundi yorokmo yaambed dukmonaniib. ");
INSERT INTO yon_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Kanembed ne dowad yaro miin arewadan yaa manmo keraneen? Kanembed ne dowad ambarakmidan yaa manmo keraneen? ");
INSERT INTO yon_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Yariman kuu ne yaa ma awawindo karen, ne kuu aron yemoonban ari iwarimo kere bobnaan karen. ");
INSERT INTO yon_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","“Ne kuu kombarandamiin.” ande yedmaniin kuu o Yariman, eb womoniyiibban ye mimyob dowaken kumbed angkumone nen kowaneeb. ");
INSERT INTO yon_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Ne kuu uniyiib meeni darewoob keraan yaron kuu ebbed ne yaa mimyob keewe ne meeni darewoob kankubuneewe kubiyiib keraan. ");
INSERT INTO yon_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Ooni ye inamen unitab arewa ye karub kuu eb yaa daboknaneenoo? Dowan. Manmo kerundi ye amob arewa ongmi ye karub kuu eb yaa daboknaneenoo? Dowan. ");
INSERT INTO yon_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Yi kuu nedbenib yorokmodan yaa manmo kerimaib, kwane yi kuu ambarakmindodan yaa dudanabe ambarakmiwen kowe dukni yeman ande wengyundimaib. ");
INSERT INTO yon_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Kumban Yariman kuu ne aromne angkumonimbon keroon, ne God kuu ne aromkonombon, yeyiib yaa wanaine kukbimaan. ");
INSERT INTO yon_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Yi ambarakmi ye dowad kakman kondene yi miin arewa kamenabi dowad monmaraneen, Yariman nub Godbed yi yeene monmaraneen kui. ");
INSERT INTO yon_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Minime, Yariman yaa kube wingkem. Nub bobni yaa burudande bindi ye Aromkonoman yaa kube baandem. ");
INSERT INTO yon_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Ye arinambo ari menenub eso andenub kube baandenub ye aningko kankooni yook wingkem. ");
INSERT INTO yon_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Kedi, Yariman kuu God darewoob arimbed, ye kuu god yena burudande King darewoob arimbed keroon. ");
INSERT INTO yon_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Okad yu ambokab yiri kuu ye dingki dem aom awine oonoon, kwane aangko dungkun dungkun mana angka kangkon yeman. ");
INSERT INTO yon_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Karamok kuu yeman, amborom kuu yembed ongmoon kowe. Kwane, ye dingkimbed okad kamkono ongmoon. ");
INSERT INTO yon_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Aomnime, ye yaa bumangkane korok kankibine ye aningko kankoonem, kwane nub ongmenaboonman Yariman yaa bumangkem. ");
INSERT INTO yon_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Amborom kuu ye kuu nub God, kwane nub kuu ebka bangkandimaabdan ye nimakarub, nub kuu sibi areb yembed dorondare oonimaan. Kibikee, ye weng wengambiribka ");
INSERT INTO yon_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Meriba yaambed kwaniwen areb kwane yiib niindem aom kamkono keraib, kwane Massa yaa amiibban ye amboon angka kangkon kwaniwen areb kwane keraib. ");
INSERT INTO yon_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Kuyaa kuu yiib awoya yiri kuu nembed komo kamaan kuu wedmiwen kuned, ne yaa komboon darobe kaamone wedmiwen. ");
INSERT INTO yon_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Weeb 40yiib kuu ne kuu yi yaa kongendembaraan, kwane nembed yedmaan, “Yi kuu niindem aom kimyen winimaibdan, kwane ne dobiri kerekmen kuu yangmadandimaib.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Kowe norin wandeni amob weng ongmeni yedmaan, “Yi kuu ne yiidkimbon aom awunaibban.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Yariman yaa yook yeeb wingkime. Okaddan korem, Yariman yaa yook wingkime. ");
INSERT INTO yon_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Yariman yaa wingkime, ye aningko kankoonime, aronki mimim kuu bobni yaa burudande bindi ye kiwaan ongmoon ye weng amun dakmembirime. ");
INSERT INTO yon_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Ye nambiri ye weng kuu ambibkin mimim korem yaa daandime, ye ambangkenabi yeka mamaa kuu nimakarub korem yaa daandime. ");
INSERT INTO yon_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Amborom kuu Yariman kuu darewoob arimbed, ye aningko kankooni kumbedmo yimin, kwane ye kuu unenimbon, god yena arebban. ");
INSERT INTO yon_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Ambibkin mimimdan yi god korem kuu kuruwak godmo, kumban Yarimanbed Eweniib ambidiib ongmenaboon. ");
INSERT INTO yon_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Nambiriyiib dobiri manimanandewiib kuu ye yaambed meneboon, kwane ye kuu ye kurikuri boyambiwoombed aromkonoyiib manimanandewiib doreen. ");
INSERT INTO yon_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","O ambibkin maa maa dabokniwendan korem, Yariman yaa ee andime, Yariman kuu nambiriyiib aromkonoyiib kuyaa kuu ee andime. ");
INSERT INTO yon_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Yariman yaningko kuu nambiri darewoowiib kowe kuyaa ee andime, munob koni yemaniib kanmene ye kurikuri boyambib yu kuuk wirinimbon aom awudirime. ");
INSERT INTO yon_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Yariman yaningko kankoonime, ye karadmo doreen kuu nambiriyiib kowe. okaddan korem, ye arinambo ari une kiringmime. ");
INSERT INTO yon_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Ambibkin mimimdan yaa yedmime, “Yariman kuu oone doreen. Okad kuu kan ongme kowoone yumbon kamkonoyiib kereen kowe kan dewenebinban. Kwane ye kuu ambibkin mimimdan yaa konomdangmo wengyundaneen.” andime. ");
INSERT INTO yon_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Ambid kuu kubuko okad kuu kubi dowakeniib keruko karamok baanduko karamok yu dingkan korem kangkon baandibko ");
INSERT INTO yon_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","mongkobon korem kubibko mongkobon yu kumkam kangkon kubibko at kuu baandi yaa wengamberenib kwane kube wingkime. ");
INSERT INTO yon_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Yi kuu Yariman ye arinambo ari kwananiib, amborom kuu mananeen kowe. Okad yu kumkam yaa wengyundok mananeen kii. Ye kuu okad yu kumkam yaa yorokmo ye kerekmen yaambed wengyundene, nimakarub korem yaa aadidmiyiibban anammo wengyundaneen. ");
INSERT INTO yon_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Yariman kuu oone doreen kowe, okaddan kuu kubime, kwane dudbi dudbi angka doriibdan kangkon kubime. ");
INSERT INTO yon_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Wiiwiib amnoom doromodiib kuu ye yaa awanewandiwen, kwane yorokmo ye kerekmeniib anammo wengyundiyiib kuu ye dibere oonimbon ye ambokab. ");
INSERT INTO yon_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Ye arinambo ari kuu amoyiib denimaan, kwane kuye amotbed ye bondan kunaya doriib kuu denendimaan. ");
INSERT INTO yon_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Ye imakbed okad kumundin kee nambirimaan, kwane okad kuu wedmekoru kiringmimaun. ");
INSERT INTO yon_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Yariman kuu aangko aangko dia keraane in yawaak kere okmo keremoon areb kerimaib, okad kumundin yu Yariman ye arinambo arimbed kui. ");
INSERT INTO yon_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Eweniib ambidiib kuu ye yorokmo kerekmen yaa dakmimaib, kwane ambibkin koremdan kuu ye nambiri wedmimaib. ");
INSERT INTO yon_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Kane kane kuruwak god yaa kurikuri kerimaib kuu yi korem yaa karak kondimaib, kuruwak god yaa kerengkan keriwendan yaa kui. Goddan korem, yi kuu ye yaa bumangke ye yaningko konkoonime. ");
INSERT INTO yon_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Saiyon kuu wengamberekoru kubeen, kwane Yudadan yi kambong kambong kuu kubiyiib keriwen, amborom kuu, o Yariman, ebbed wengyundewen kowe. ");
INSERT INTO yon_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","O Yariman, eb kuu okad yu kumkam korem yaa Burudande Darewoob Arimbed Keroonman, ebbedmo kuu aningko darewoob arimbed, god yena arebban. ");
INSERT INTO yon_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Yariman yaa mimyob dowaken keenimaibdan, arewa yaa kuu wangdandunime. Kedi, ye kerekmen yaambed doriibdan kuu yembed dorondarimaan, kwane yi kuu yembed miin arewadan yi aromkono aom ben angka nongkobimaan. ");
INSERT INTO yon_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Nambiri kuu yorokmodan ari yurene kubi kuu kangdommo doriibdan yaa kondimaan. ");
INSERT INTO yon_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Kane kane yorokmo doriibdan, yiib kuu Yariman yaa kubenib ye aningko karadmo kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","God yaningko kankooni ye yook. Yariman yaa yook yeeb wingkime, amborom kuu binangke ye yaa anam andi yeman ongmenaboon kowe. Kwane ye dingki wiwi karadmombed bondan korem nangme burudande doroon. ");
INSERT INTO yon_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Yarimanbed bobni yaa burudande bindi ye kiwaan ongmoon kuu korokbene, ambibkin mimimdan yaa kuu ye yorokmo kerekmen korokbendoon. ");
INSERT INTO yon_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Ye kuu Israeldan yi dowad ye womoniyiibban ye mimyob dowakeniib ye ma korondiyiibban weng awini ye inameniib ikakman meenoon. Bobni yaa buruande bindi ye kiwaan nub Godbed ongmoon kuu okad yimin yimin koremdan kuu wedmiwen. ");
INSERT INTO yon_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Okad kumundindan, Yariman yaa kube baandime, ye aningko kankooni dowad yook wingkenib kube komkime. ");
INSERT INTO yon_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Haapbed Yariman yaa wangkime, haapbed wangki kuwengiib wingkiyiib kamime. ");
INSERT INTO yon_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Kibiyiib sibi duruwiibbed baandenib nub King, Yariman kui, ye arinambo ari kube komkime. ");
INSERT INTO yon_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Karamok kuu baanduko karamok yu dingkan korem kangkon baandibko okad baanduko okad kwari doriibdan korem kangkon baandime. ");
INSERT INTO yon_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Ok awaan korem kuu dingki wowemoon areb kamime, kwane aangko aangko kuu ibmo kubi yook wingkime. ");
INSERT INTO yon_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Yi korem kuu Yariman ye arinambo ari wingkime, amborom kuu ye kuu okad yiri mene wengyundok meneen kowe. Yembed okad yu kumkam kuu yorokmo wengyundene ambibkin mimimdan yaa konomdangmo wengyundaneen. ");
INSERT INTO yon_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Yariman kuu oone doreen kowe, ambibkin mimimdan kuu une kiringmime. Ye kuu engyus burawiib yi kidangkambed king ye dibere oonimbon ari dibeen kowe, okad kuu kiringmuk. ");
INSERT INTO yon_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Saiyon aom kuu Yariman yaningko kuu darewoob arimbed, kwane ye kuu darewoob arimbed, ambibkin korem arebban. ");
INSERT INTO yon_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Yi kuu ye aningko darewoob arimbed manimanandewiib kankoonime, ye kuu karadmo kowe. ");
INSERT INTO yon_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","King kuu aromkonoman, ye kuu anammo wengyundi yaa dowaken darewoob kerunoon. O King, ebbed konomdangmo ye kerekmen ongmewen, Yekob ye awoya ari kuyaom kuu anammo wengyundeneb yorokmo kamenabewen. ");
INSERT INTO yon_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Yariman nub God ye aningko kankoonime, ye yon kiriboon yirimbed ye yaa bumangke yaningko kankoonime, ye kuu karadmo kowe. ");
INSERT INTO yon_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Moses yoom Eeron yoom kuu God dore Yuudan dore wedyiri dobiridan kuyaom kuu yiyiib. Samuel yangkon God yaa baandimaibdan kuyaom kuu yeyiib. Yi kuu Yariman yaa baandiiwe yi yaa inandundoon. ");
INSERT INTO yon_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Yembed wiib dodkono areb doreen aombed yi yaa daandoon, kwane yembed komo kamoon ye wengiib amob weng ongmooniib kuu kondoone awine ooniwen. ");
INSERT INTO yon_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","O Yariman nub God, ebbed yi yaa inandundewen. Eb kuu Israeldan yi arewa kamenabi yaa ukum kowimaab kuned, eb kuu yi ambarakmi are nonondandi ye God. ");
INSERT INTO yon_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Yariman nub God yaningko kankoonenib ye aangko karadmo arimbed ye yaa bumangke yaningko kankoonime, amborom kuu Yariman nub God kuu karadmo kowe. ");
INSERT INTO yon_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","God yaningko kankooni ye yook. Eso andi yeman. Okad kumundindan, Yariman yaa kube komkime. ");
INSERT INTO yon_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Kubi dowakeniibbed Yariman yaa bumangke yaningko kankoonime. Kubi yookiibbed ye arinambo ari minime. ");
INSERT INTO yon_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Yariman kuu God ande yiibkaadkerunime, nub ongmenaboonman kuu yembedmo, kwane nub kuu yeman. Nub kuu ye karuwa nimaya, nub kuu sibi areb ye bangkandimbon aom doruub. ");
INSERT INTO yon_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Eso andiyiibbed ye kurikuri boyambib yu kuuk wirinimbon ye ambongko aom awunem, kwane ye aningko kankooniyiibbed ye kurikuri boyambib yu kuuk wirinimbon aom awunem. Ye yaa eso andenub ye aningko kankoonem. ");
INSERT INTO yon_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Amborom kuu Yariman kuu amun, kwane ye womoniyiibban ye mimyob dowaken kuu dowan keraanban oonendembaraneen, kwane ye ma korondiyiibban weng awini ye inamen kuu nimakarub yaro dobere dobere yaro wananiib korem aom angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Dewid ye yook. God yaningko kankooni ye yook. Ne kuu eb womoniyiibban ye mimyob dowakeniib anammo wengyundiyiib ye dowad yook wingkaniin, o Yariman, ewaningko kankooni yook wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Ne kuu ongme kaadkereni ambarakmoon kii ande dedmoniyiibban ye kerekmen yaambed dobaraniin. Komo aron arimbed ne yaa mananeeb? Nambiwoom dobaraniin kuu ne niindem aom ma aadikmiyiibbanbed dobaraniin. ");
INSERT INTO yon_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Ne indob ari kuu karakiib arewa ye barang kuu ma dowakeniib kerainban. God yaa angkurom korokbeniwendan yi kamenabi yaa kuu kongendimain, yi kuu ne ma nen kimyen wanaibban kii. ");
INSERT INTO yon_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Inamen unitawiibdan kuu ne yaa kuu ambab angka keraniib, inamen arewa korem kuu kangkadmaniin kui. ");
INSERT INTO yon_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Kanembed ye dia doreenman yaa yemyeb wengamborokbanabaneen kuu nembed ye kuu kebenenaniin. Kanembed ye kuu nembedmo yimin ande kerengkan kamaneen kuu nembed ye kuu angkodmenainban. ");
INSERT INTO yon_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Ne kuu ne ambibkindan anam andiwen yaa karub amun ande kereknaniin, kwananiine ne yoom dobaranuub. Kane ye kuu ambarakmoon kii ande dedmoniyiibban ye kerekmen yaambed dobaraneen kuu ne yaa awawaneen. ");
INSERT INTO yon_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Karub kanembed ye kuu birandimaan kuu nambiwoom kuu yeyiib dobaraanban. Karub kanembed ye kuu dudanabimaan kuu ne arinambo ari dobaraanban. ");
INSERT INTO yon_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Ne ambibkin ye arewa kamenabidan kuu amkimo korem kebenendaniin. Nembed arewa kamenabidan korem kuu Yariman ye siti aombed ben bunangka kiradmaniin. ");
INSERT INTO yon_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Durud yewed kandoonman ye kurikuri weng. Ye kuu miin yiminban kerekore mimyob wandoon ye weng Yariman yaa dakmoon. O Yariman, ne kurikuri kee wengamberewe. Ne awawe ande baandi kuu eb yaa monok. ");
INSERT INTO yon_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Ne yiminban kere eb yaa baandaka eb murubia ne yaa kuu kan yeknaab. Eb kerendem kuu ne yaa kowe wengamberewe. Kwane eb yaa baandaka kirod inanduwe. ");
INSERT INTO yon_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Ne wad dobiri yaron kuu amareng anwenemoon areb, kwane ne kono kuu amoyidkob denemoon areb keroon. ");
INSERT INTO yon_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Ne niindem aom kuu kereek nuubne koknemoon areb keroon. Kedi, ne animan ani kuu nonondandimain. ");
INSERT INTO yon_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Ne wareki darewoob kamimain kumbed yomiibban konokonomo keraan. ");
INSERT INTO yon_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Ne kuu amboon angka on kanakana areb keraan, kwane ne kuu ambib bobbon aom on kamim areb nembirimo dobaraan. ");
INSERT INTO yon_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Amnoom kuu angkande kaimain kumban unuk angkindeban keraan, kwane ne kuu wid angka ye on areb nembirimo keraan. ");
INSERT INTO yon_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Aronki doboob kuu ne bondanbed ne yaa daawi yeman kerimaib, kwane kane kane ne yaa damangkawimaib kuu naningko kande butun yeman kerimaib. ");
INSERT INTO yon_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Kedi, ne kuu yikbod kumbed naniman areb kere aneni, ne anande kaimain ye ok aom kuu ne inokiib kubudaraana animain. ");
INSERT INTO yon_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Kwanimain kuu amborom kuu eb norin darewoob ne yaa wandewen kowe. Kedi, ebbed ne nendane kan angka korarewen. ");
INSERT INTO yon_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Ne wad dobiri yaron kuu oobneya ye kuruwak areb, kwane ne kuu kereek nuubnemoon areb kere winimain. ");
INSERT INTO yon_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Kumban, o Yariman, eb kuu eb dibere oonimbon arimbed aron korem diberembirimaab, kwane eb yirin kuu nimakarub yaro dobere dobere yaro wananiib korem aom kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Eb kuu dembeneb Saiyon yaa mimyob kowaneeb, amborom kuu ebbed yu yaa awandi yaron kuu muneen kowe, aron kinewen ari muneen kui. ");
INSERT INTO yon_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Kedi, yu ambib ye bot bondanbed ben angka kirariwen kuyaa kuu eb demedan kuu mimyob keendimaib, yu monmarundiwen ye ingkud kuyaa kuu korem mimyob kowimaib. ");
INSERT INTO yon_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Ambibkin mimimdan kuu Yariman yaningko yaa une bumangkaniib, kwane okad yiridan yi king korem kuu eb nambiri yaa une bumangkaniib. ");
INSERT INTO yon_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Amborom kuu Yariman kuu angkon ika Saiyon yengbekore ye nambiriyiib angkadaraneen. ");
INSERT INTO yon_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Ye kuu kamboknondan yi kurikuri yaa inandundaneen, yi kaamoni yaa kuu wunekaraanban. ");
INSERT INTO yon_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Awoya awoya amaan ari yi dowad wongkibko, yi kuu Yariman yaningko kankoonime andi ye weng kukei. ");
INSERT INTO yon_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","“Yariman kuu ambab ari ye dobirimbon karadmo arimbed yiri keendomboroon, Ewen arimbed okad yiri wedme daroboon kui. ");
INSERT INTO yon_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Kukuu wii aom kamobiwendan yi wareki wengamberekore, dukni yeman andiwendan yaa ben angka nongkobanded.” kwane wongkime. ");
INSERT INTO yon_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Kwananeen kuu Yariman yaningko kuu Saiyon aombed dakmenib Yerusalem aombed ye aningko kankoonaniib. ");
INSERT INTO yon_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","Ambibkin mimimdaniib oonimbon mimimdaniib kuu Yariman yaa kurikuri kamande nedbaniib kuu kwananiib kii. ");
INSERT INTO yon_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Ne kuu weeb yemoonban dobaraan kumbed ne aromkono kuu yembed dookboon, yembed ne wad dobiri yaron kuu nare dukmenmo keroon kui. ");
INSERT INTO yon_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Kowe nembed yedmaan, “O ne God, ne mokaid doriin keyaombed ne nen angkanaab. Eb weeb kuu nimakarub yaro dobere dobere yaro wananiib korem aom wenembirimaun. ");
INSERT INTO yon_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Yimin andowoon yiri kuu ebbed okad yu ambokab ongmenabewen, kwane ambidiib Eweniib kuu eb dingkimbed ongmenabewen. ");
INSERT INTO yon_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Yi kuu monmaraneen kuned eb kuu dobaraneeb, yi kuu ebkad korobob keremoon areb keraniib kui. Yi kuu ebkad areb ebbed biangke ben kiradmekoreb yeweb ben debendaneeb. ");
INSERT INTO yon_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Kumban eb kuu kwane doreebmo doberembaraneeb, kwane eb weeb kuu ma yimin wandaanban. ");
INSERT INTO yon_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Eb demedan yi meed kuu uniyiibban kumbed dobaraniib, kwane yi awoya kuu eb arinambo ari ye yumbon aom dobaraniib. ");
INSERT INTO yon_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Dewid ye yook. O ne kingkin, Yariman yaningko kankoona, ne niindem aom kumundiniib ye aningko karadmo kankoona. ");
INSERT INTO yon_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","O ne kingkin, Yariman yaningko kankoona, ne yaa awawi ye kerekmen yaa ma nonondandain. ");
INSERT INTO yon_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Ye kuu ne ambarakmi korem are nonondandene ne bob anikad maa maa korem kuu ongmewimaan. ");
INSERT INTO yon_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Kwane ye kuu ne bobneni bobkonombon aom angkimbarain andi ye dowad biddene, womoniyiibban ye mimyob dowakeniib mimyob keewe kakman are nonondandiyiib keewimaan. ");
INSERT INTO yon_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Kwane ye kuu ne inamen dowaken yaa yiminmo amunmo keruwimaan, kowe on diba yaromkono areb ne yaa kuu kewed yaromkono dobiri kerekmen ika kawaane kwane dobirimain. ");
INSERT INTO yon_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Yarimanbed yorokmo ambangkimaan, kwane yembed dabab wayiroondan yi dowad anammo wengyundimaan. ");
INSERT INTO yon_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Yembed ye dobiri kerekmen kuu Moses yaa korokbenoon, kwane ye kamenabi kuu Israeldan yaa korokbendoon. ");
INSERT INTO yon_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Yariman kuu mimyob kowi ye God, kabamoon kondoon ye mimyob dowaken keendi ye God, ye kuu kirodmo norin wandimokban, ye kuu mimyob dowaken darewoob keendi ye God. ");
INSERT INTO yon_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Ye kuu nub yaa manmo kerundembaraanban, kwane ye norin kuu kwane kowe awinembaraanban. ");
INSERT INTO yon_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Ye kuu nubbed komo ambarakmuwen ye dabab yaambed ukum kondindo, kwane ye kuu nubbed komo arewa kamenabuwen ye kakman yaambed inandindo. ");
INSERT INTO yon_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Amborom kuu okadbed ari daane Ewen nandi ye ambab kumunkingki kwamune areb kuu, ye womoniyiibban ye mimyob dowaken kuu miin darewoob, ye yaa unimaibdan yaa. ");
INSERT INTO yon_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Aron dembimaun angkambed wene aron kubunimaun angka keri ye ambab kwamune areb kuu, yembed nub ambarakmi kuu nub yaambed ben ambab angka kiradmoon. ");
INSERT INTO yon_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Awodkimbed dana meed yaa mimyob kowimaan kwamune areb kuu, Yarimanbed ye yaa unimaibdan yaa kangkon mimyob kowimaan. ");
INSERT INTO yon_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Amborom kuu nub kuu komombed ongmenaboon kuu yekaad, nub kuu okad yiridanmo kangkon yekaad kowe. ");
INSERT INTO yon_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Nimakarub kuu kekei, yi dobiri yaron kuu kereek areb aron dukmenmo. Yi kuu kainekorib kirodmo kiomne duknaniib, yi kuu dura angka ye nong wuung areb, ");
INSERT INTO yon_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","nuubbed mene wuure araane kokne dowan keremoon areb kii, kwane nong wuung demboon ye okad kuu nong wuung koknoon yaa ma meenimokban. ");
INSERT INTO yon_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Kumban aron korem anuk doboroonbed mene aron korem ambab ari dobaraneen kumaom kuu Yariman ye womoniyiibban ye mimyob dowaken kuu ye yaa unimaibdan yaa angkimbirimaan. Kwane ye yorokmo kerekmen kangkon yi awoya ari yaa angkimbirimaan, ");
INSERT INTO yon_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","kane kanembed amob weng yembed ongmoon kuu awinenib ye kongamki yamob kuyaa meene awinaniib kuu kuye mimyob dowaken kuu yi yaa kwane angkimbaraneen kui. ");
INSERT INTO yon_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Yarimanbed ye dibere oonimbon kuu Ewen arimbed nowoon, kwane ye oonimbon aom kuu kumkam koremiib. ");
INSERT INTO yon_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Yariman ye engyus, yiib kuu ye aningko kankoonime, aromkonodan kuu ye kwanime andi ye weng awine kwanimaib, ye weng awine kandimaibdan kui, yiib kuu ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Yariman ye ana nangmidan Ewen ari doriib korem, ye aningko kankoonime, ye demedan kuu ye dowaken yaambed kwane ambangkimaib kui, yiib kuu ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Yarimanbed komo komo ongmenaboon ye kumkam, yiib kuu ye aningko kankoonime, ye oonimbon aom doriibdan kui, ye aningko kankoonime. O ne kingkin, Yariman yaningko kankoona. ");
INSERT INTO yon_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","O ne kingkin, Yariman yaningko kankoona. O Yariman ne God, eb kuu darewoob arimbed, kwane eb kuu nambiriyiib dobiri manimanandewiib inwarewen. ");
INSERT INTO yon_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Ebka eb nambirimbed ebkad doboob areb kan dabunewen, kwane ebbed ambid kuu dabua areb kan batangne binge koweneb, ");
INSERT INTO yon_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","ambid ari ye ok arimbed eb dobirimbon kuu arumewen. Ebbed wiib ben eb seriot areb ongmeneb yarebimaab, kwane nuub kan ayari on areb ongmeneb kuye buraab arimbed wan yarebimaab. ");
INSERT INTO yon_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Ebbed nuub kuu ben eb weng benbidan kerundimaab, kwane amot yumbu kuu ben eb demedan kerundimaab. ");
INSERT INTO yon_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Ebbed okad yu ambokab ongmenabewen, kowe kan dewenebinban aron korem. ");
INSERT INTO yon_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Kwanekoreb karamok kuu dabua areb kan okad ari dabunendewen, kowe ok kuu aangko aangko kebeneen. ");
INSERT INTO yon_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Ok yaa ongkandewen kumbed kombiri wuneen, eb nambadbed baandewen kumbed ok kuu wan wenemoon areb wenebeen. ");
INSERT INTO yon_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Ok kuu aangkombon ari korondenu kankubunen yiri dewenenu ebbed ongmenabewen ye yumbon kurimbed wuneen. ");
INSERT INTO yon_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Ebbed karamok wene burudandindeban ye yumbon nongkobewen kowe, ok kuu ikakman okad kumundin dabunaunban. ");
INSERT INTO yon_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Ebbed kirubdem ongmenabaawe ok kuu kankubunen yiri wenenu aangko yara yara kere yiri wenebimaun. ");
INSERT INTO yon_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Ok wenebaune okad yu dingkan korem kuu animaib, donki kiib kangkon ok ane mikmonimaib. ");
INSERT INTO yon_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Ayari onbed ok kaat yaa amiyiib yenbenabenib, at kwari kuu yookiib wingkanabimaib. ");
INSERT INTO yon_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Eb dobirimbon arimbed am yedme kowaawe aangko aangko ari winimaun, kowe eb ambangkanabi yaambed yob iraane okad kubimaun. ");
INSERT INTO yon_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Kereek kuu buromakau yi ani dowad ongmaawe dembimaan, kwane yongbon yeman nimakarub yi ani dowad ongmaawe dembimaun. Okad yirimbed animan yemoon dembimaib, ");
INSERT INTO yon_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","nimakarub ane yi niindem aom kubi ye wain ok ye nong yob dembaune, nimakarub kube murubia kankooni ye olif ambodiib ye at kuu yowiib iraune, aromkono kondi ye flawa ye wiit kuu yowiib irimaan kui. ");
INSERT INTO yon_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Yariman ye at kuu ok ane mikmonimaib, ambibkin Lebanon yu at sidaa yembed arumenaboon kui. ");
INSERT INTO yon_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Kwari kuu onbed ami yenbenabimaib, kwane on dareb kawanmo kwangkon menebe at feer kwarimbed amiyiib yenbenabimaib. ");
INSERT INTO yon_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Naningkod kiib kuu aangkodem kiibdeb kwarimbed doriib, kwane ba haireks kuu aangko kebed angkambed doriib. ");
INSERT INTO yon_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Ebbed wood ku ongme kowewen kumbed amaroniib yongkonbi yaroniib kimingki yeman kereen, kwane aron yu kubuni kiwaan kuu yukaad. ");
INSERT INTO yon_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Ebbed amnoom ku ongmewen kumbed minimaan, kwane dingkan kiib kuu amnoombed yarebimaib. ");
INSERT INTO yon_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Laiyon kuu aye anem ande komkanabimaib, kwane yi animan onmimaib kuu Godbed bangkandimaan. ");
INSERT INTO yon_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Aron yaro minimaun kuu yi kuu wene bikderebimaib, yi kuu yi angkimbon dem aom ikakman wene dibere unuk dangimaib kui. ");
INSERT INTO yon_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Kwane nimakarub kuu wene yi demembon yaa deme awinaiwe kwane wene oobne miriknimaan. ");
INSERT INTO yon_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","O Yariman, eb ambangkenabi kuu yemoon kai. Eb kuu meeni kangdommombed korem ongmenabewen, kwane okad kwari kuu ongmenabewen ye kumkam kuu yemoonmo muubniwen. ");
INSERT INTO yon_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Karamok kuu yakui, yara yara kuu darewoob ambab, kwane kuri niindem yiri kuu okyiri dingkan yemoon kai, kimingkindeban, dingkan embengiib darewoowiib wad doriib kui. ");
INSERT INTO yon_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Kwane motod kuu kwarimbed dewenebimaib, kwane kumaombed omyere darewoob lewaiyatan kuu ebbed ongmekoreb kaaneewe kuri iningkuk kamimaan. ");
INSERT INTO yon_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Yi korem kuu ebbed animan maondaneewa ananuub manok ande dobirimaib, kwane ebbed aron anam arimbed bangkandimaab. ");
INSERT INTO yon_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Animan bangkandaawa bimaib, kwane dowakeniib keraawa yiminmo kerimaib. ");
INSERT INTO yon_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Eb murubia kan yeknaawa uniwon karakwon kerimaib, yi inum kuu ebka kandaawa yoworenib ikakman okad kerimaib. ");
INSERT INTO yon_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Kumban ebbed eb inum yi yaa kondaawa yi wadkeri kuu andowe dobirimaib, kwane ebbed okad kumundin ongmendaawe yeeb areb ikakman kerimaun. ");
INSERT INTO yon_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Yariman ye nambiri kuu aron korem kwane angkimborok, Yariman kuu yembed komo komo ambangkanaboon yaa kubok. ");
INSERT INTO yon_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Yembed okad kumundin wedmendaana yuka kiringmimaun. Yembed aangko aangko yaa angkorondaane amarengiib dembimaan. ");
INSERT INTO yon_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Ne wad dobaraniin yaron korem kuu Yariman yaa yook wingkimamaniin. Aron komoyiib kwane okad kiri dobaraniin yaron kuu ne God yaningko kankooni yook wingkimamaniin. ");
INSERT INTO yon_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Nembed Yariman yaa kubimain kuu, ne meeni inamen yaa kuu yembed amun ande kubok. ");
INSERT INTO yon_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Kumban ambarakmenabidan kuu monmare okad kiri kee dowan kerok. Kwane arewa kamenabidan kangkon dowan kerime. O ne kingkin, Yariman yaningko kankoona. Yariman yaningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Yariman yaa eso andime, ye aningko yaambed koromone dore baandime. Yembed komo komo kamenaboon kuu ambibkin mimimdan yaa daandime. ");
INSERT INTO yon_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Ye yaa yook wingkime, ye aningko kankooni yook wingkime. Binangke ye yaa anam andi yeman ongmenaboon korem kuu dakmime. ");
INSERT INTO yon_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Ye aningko karadmo yaa kubi darewoob kerime. Yariman ande onmiibdan, yiib niindem aom kuu kubime. ");
INSERT INTO yon_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Yariman ande onmenib ye aromkono nub yaa kondok andime. Ye yaa kurikuri kere ye aningko kankoonembirime. ");
INSERT INTO yon_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Binangke ye yaa anam andi yeman ongmenaboon kuyaa kuu ika meenime, kami yeka mamaayiib wengyundi wengiib kuyaa kangkon ika meenime. ");
INSERT INTO yon_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","O ye dememan Abraham ye awoya ari, o Yekob ye meed, Godbed kinoondan kui, ");
INSERT INTO yon_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","ye kuu Yariman nub God, ye wengyundi weng kuu okaddan korem yaa angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Yi dowad amob weng ongmoon kuyaa aron korem meenimaan, nonondandaanban, Yembed kwamime andi ye weng yedme kowoon kuyaa meenaneen, nimakarub yaro dobere dobere yaro wananiib 1,000iib yaron doboob kuu, ");
INSERT INTO yon_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Abraham yaa yedme kowoon ye amob weng kui, Aisek yaa kangkon yedme kowoon ye amob weng kui. ");
INSERT INTO yon_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Amaanbed kuye amob weng kuu Yekob yaa ee awinem ande yedmoon, Israel yaa amob weng kee aron korem yeman ande yedmoon kukei, ");
INSERT INTO yon_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","“Eb yaa Keenan ambibkin kee nembed kabdaniin, kowe eb ambibkin keranuun.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Kumban Yekob awene kuu yemoonban, yi kuu yemoonban anam, yi kuu ambibkin kumaom doriib kangkon noroddan. ");
INSERT INTO yon_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Yi kuu kwane ambibkin maa kere ambibkin maa kere awerenmo yariwen, oonimbon maa kere oonimbon maa kere yariwen kui. ");
INSERT INTO yon_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","God kuu yi yaa karub yenambed dabab wayiraib ande kebenoon, kwane yi dowad king yena ongkande yedmoon, ");
INSERT INTO yon_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","“Nembed yi ari oiyo bune kinaandan kee angkorondaib, ne profesidan keyaa ma arewa kamendaib.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Kwane yembed Keenan ambibkin kuyaa am yongkonbi kondoone yi kuu animaniibban keriwen. ");
INSERT INTO yon_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Kwane karub maa kankowoona yedin wonoon, kukuu Yosef, ye kuu ye ayiyambed kan mooniwen, dabderem yiri dobere dememo awinembiri ye karub keri dowad. ");
INSERT INTO yon_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Nenwiniwendanbed ye yon kuu seinbed borokiwen kumbed kubungkabawiib keroone, ye kongkono yaa kangkon seinbed borokiwen. ");
INSERT INTO yon_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Kwane doboroonkob wene yembed komarewa keraneen ande dakmoon kuu anam id keroon, Yarimanbed ye yaa daanoon ye weng kuu anam id keroon kui. ");
INSERT INTO yon_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Kwane wii aom doreen kuu Idyipdan yi kingbed nen bunangka kowoon, ambibkin maa maa oonoonmanbed nen bunangka kowoone obon keroon kui. ");
INSERT INTO yon_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Kwane kingbed ye kuu nen kowoona ambiwoom doriibdan korem yi korok keroon, kingbed ye kuu nen kowoona king ye yiribman korem oonoon kui. ");
INSERT INTO yon_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Kwane deme konoona ye dowaken yaambed king ye dana meed kedmengkandene, king ye korok korok yaa meeni kangdom kuu kedmengkandoon. ");
INSERT INTO yon_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Amaanbed Israel awene kuu Idyip aom awudiriwen, Yekob ye nimadana yoom kuu Hem okad yiri winiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Yarimanbed ye nimakarub kuu dana yemoon bangkandoona muubniwen, yi kuu ongmendoona yemoonmo keriwen, Idyipdanbed yi yaa bon keriwendan arebban. ");
INSERT INTO yon_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Bondan kuu yembed ongmendoona ye nimakarub yaa arud wandembirimaib, bondanbed ye demedan yaa wunonwanon kamiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Kwane yembed karub ayoob ben yuroon, ye dememan Moses yoom kinoonman Eeron yoom kui. ");
INSERT INTO yon_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Yi kuu binangke God yaa anam andi yeman ongmenabiwen Idyip aombed, kami yeka mamaa kuu Hem okad aom ongmenabiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Yembed Idyip ambibkin aom kuu kumunmo kerok ande yedme kowoona kumunmo keroon, kumban Idyipdan kuu ye weng yaa wabkad keriwen. ");
INSERT INTO yon_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Yembed yi ok kuu kan amonombe umkan keroone, okyiri oon korem kuu dukniwen. ");
INSERT INTO yon_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Idyipdan yi ambibkin aom kuu kod muubniiwe, yena kuu korok korok yi wadnari angkimbon aom awudiriwen. ");
INSERT INTO yon_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Yembed yedme kowoona wadmung nimingkiwen yemoon menebiiwe kimiring menebe ambibkin kumundin aom muubniwen. ");
INSERT INTO yon_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Yembed ongmoona ambibkin kumundin aom kuu am boyareb yurukmo kiroboone imakiib kamenaboon. ");
INSERT INTO yon_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Yembed Idyipdan yi nong yob yongboniib yedob ayiib monmarene yi ambibkin ye at korem kuu monmaroone kurubkurub keriwen. ");
INSERT INTO yon_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Yembed ed yedme kowoona menebiwen, yi kimingki kuu yiminban. ");
INSERT INTO yon_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Kwane yimbed nong biid at biidiib mongkobon kawiib korem kuu anenib dowan korodkabmo kere winiwen. ");
INSERT INTO yon_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Kwane yembed Idyipdan yi meed wonob dana korem kuu yenbande nongkoboon, kaine amni ye aromkono ibduruk korokbi yeman kuu dukniwen kui. ");
INSERT INTO yon_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Kwanekore Israeldan kuu bin yaro angkane wonoon, yi kuu bot silvaayiib bot goldiib yemoon ben winiwen, kwane yi amyenimbon korem aom kuu karub maa ma komborok andindo. ");
INSERT INTO yon_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Kwane Israeldan winiiwe Idyipdan kuu kubiwen, amborom kuu Israeldan yaa uniwen kowe. ");
INSERT INTO yon_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Godbed wiib kandune aron ye nimin kebeni yeman yi ari kowene amnoom kuu amot yumbuyiib yi ari kondimaan. ");
INSERT INTO yon_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Yimbed kaamoniiwe yembed on yaningko kweil benmonoon, kwane Ewen ari ye om animan bangkandoone ane mikmoniwen. ");
INSERT INTO yon_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Yembed bod dumnad yaambed ok nandaana menebimaun, kwane ok kuu ok awaan areb kere okad koknoon angka wenebimaun. ");
INSERT INTO yon_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Godbed kwamoon amborom kuu ye weng kunduk karadmo yaa ika meenoon kowe, ye dememan Abraham yaa konoon kui. ");
INSERT INTO yon_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Kwane, yembed ye nimakarub kuu amboon aombed ben kubiyiibbed angkadoroon, yembed kinoondan kuu kube baandiyiib ben angkadoroon kui. ");
INSERT INTO yon_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Kwane, yi yaa kuu ambibkin yenadan yi okad kondoon, kowe yi kuu yenambed deme yobdoodiib ambangkiwen ye kumkam ben ooniiwe yiman keroon. ");
INSERT INTO yon_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Kwanoon kuu yembed wongkoon yamob awine kandime andene ye amob ben kongamkime anded. Yariman yaningko kankoonime! ");
INSERT INTO yon_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Yariman yaningko kankoonime! Yariman kuu amunmo kowe, ye yaa eso andem, amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem angkimbaraneen kowe. ");
INSERT INTO yon_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Yariman ye kamenabi aromkonoyiib kuu kanembed dakme yimin keraneen? Ma, ye aningko kankooni ye weng korem kuu kanembed dakmaneen? ");
INSERT INTO yon_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Anammo wengyundimaibdan kuu amun kerundoon, yorokmo dobirimaibdan kangkon amun kerundoon kii. ");
INSERT INTO yon_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","O Yariman, eb nimakarub yaa kubi dowaken keendaneeb kuu ne yaa kangkon ika meene. Ebbed yi kuu arewa yaa burudande bindaneeb kuu ne yaa kangkon awawe. ");
INSERT INTO yon_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Kwananeeb kuu kinewendan yiminmo dobaraniib kuu neyiib keraniin, kwananeeb kuu eb ambibkindan kubaniib kuu neyiib keraniin kii, kwananeeb kuu yumbon kondewendan ewaningko kankoonaniib kuu neyiib keraniin kii. ");
INSERT INTO yon_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Nub kuu nub awoya yiri areb ambarakmuwen, kwane nub kuu wabkad kerenub miin arewa kamenabuwen. ");
INSERT INTO yon_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Nub awoya yiri kuu Idyip aom dobiriwen kuu binangke eb yaa anam andi yeman ongmenabewen kuyaa kuu ma meenindo. Eb amun amun kamenabi yemoon yi yaa kamewen kuu ika meenindo keriwen, kwane yi kuu karamok Dodmo yaambed wabkad keriwen. ");
INSERT INTO yon_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Kumban yembed yi kuu arewa yaa burudande bindoon, ye yirin kowi ye dowad. Ye aromkono darewoob korokbi dowad kwanoon. ");
INSERT INTO yon_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Yembed karamok Dodmo yaa ongkandoone keekne bid kamkono kereen, kwane karamok kuu domokbe angkara angkara keroon kowe yembed yi kuu wedyiri bid koknoon ari ben kinban yanoon. ");
INSERT INTO yon_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Kowe yembed yi yaa arud wandemboroonman yaa kuu burudande bindoon, kwane yembed yi bondan yi dingki dem aom kuu bidde ben angka nongkoboon. ");
INSERT INTO yon_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Kwane yi bondan kuu karamokbed yeene yukneen, karub mimo ma ok ambe bid dorindo. ");
INSERT INTO yon_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Kwanoon kumbed yi kuu ye weng kunduk yaa anam andenib ye aningko kankooni yook wingkiwen. ");
INSERT INTO yon_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Kumban yembed komo kamoon yaa kuu yi kuu kirodmo nonondandiwen, kwane ye dowaken kuu kuna ande kaamonindo, yika inamen ongmenib kwane ambangkiwen. ");
INSERT INTO yon_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Kwane, Idyip ye animan yaa moommo kerenib, amboon angka God yaa komboon kaamobiwen. ");
INSERT INTO yon_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Kowe yimbed komo kaamoniwen kuu kondoon kumban, kwane kuyoom kuu bob anikad arewayiib kan kondoon. ");
INSERT INTO yon_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Yi kuu ambib kombon yenbiwenbon aombed Mosesiib Yariman ye kurikuri dememo awini ye karub Eeroniib yaa wungkandiwen. ");
INSERT INTO yon_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Kowe okad kuu andokbe mongkod daadenu Detan kuu kan anukmuneen, kwane okadbed Abiram yoom ye yoman winiwendan yoom kuu ben mangkanabeen. ");
INSERT INTO yon_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Yi yoman winiwendan kuu amotbed denoboon, amot yumbumbed arewa kamidan kee dene kubunoon kui. ");
INSERT INTO yon_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Yimbed aangko Sainai angkambed buromakau mana ye kuruwak ongmiwen, kwane kuye dudi god ye kuruwak bot goldbed ongmiwen kuyaa kurikuri keriwen. ");
INSERT INTO yon_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Kowe yi kuu Nambiriyiib Ye God yaa korondenib, buromakau ambi ye kuruwak yaa kurikuri kame kubiwen, kukuu kereek animaan ye dingkanmo kuda. ");
INSERT INTO yon_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Godbed yi kuu arewa yaa burudande bindoon kuned, yi kuu ye yaa nonondandiwen. Ye kuu Idyip yirimbed ambangkanabi dareb dareb ongmenaboonman, ");
INSERT INTO yon_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","ye kuu Hem okad aombed kami yeka mama ongmenaboonman, ye kuu karamok Dodmo yaambed binangke ye yaa anam andi yeman ongmenaboonman kuned ye yaa nonondandiwen. ");
INSERT INTO yon_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Kowe Godbed yi kuu monmaraniin ande yedmoon kumban, yembed kinoonman Mosesbed yaro God dore yi dore wedyiri doberene God ye norinbed yi kuu monmaradamoon kuu kebenande kamoon. ");
INSERT INTO yon_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Amaanbed yi kuu okad amun kuyaa korondenib ye weng kunduk kuyaa anamban andiwen. ");
INSERT INTO yon_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Yi kuu yi ambib kombon aombed mungkubmangkab kamiwen, kwane Yariman ye weng kuu awine kandindo, korondiwen. ");
INSERT INTO yon_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Kowe yembed ye dingki kankoone weng kamkono yedme kowoon kuu yi kuu amboon angkambed duknaniib kumbedmo andoon. ");
INSERT INTO yon_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Weng ari yedme kowoon kuu yembed yi awoya ari ben buyokbayok kamaneena ambibkin yena angka dobaraniib, bidambib maa maa kuyaa boketawaraneene dobaraniib kui andoon. ");
INSERT INTO yon_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Yi kuu dudi god maa Baal Peor yaa daboknenib, wadkeriyiibban ye dudi god yaa munob koni ye animan aniwen. ");
INSERT INTO yon_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Yimbed kwane arewa kamenabiwen kumbed Yarimanbed yi yaa norin wandoone, bob anikad miin arewa kuu kan dembe yenbandoon. ");
INSERT INTO yon_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Kumban Finehasbed yaro dorene ambarakmoonman kuu kan wengyundene ukum kerunoona, kuyaambed bob anikad arewa kee Godbed kondoon kuu kebenoon. ");
INSERT INTO yon_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Kwane Godbed Finehas yaa karub yorokmo ande yedmoon, kwane kuye weng kuu nimakarub yaro dobere dobere yaro wananiib korem aom kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Aron maa Israeldanbed ok Meriba yaambed arewa kamiiwe Yarimanbed arud wandoon, kwane yi arewa kami kumbed dabab kuu Moses yaa monoon, ");
INSERT INTO yon_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","amborom kuu yi kuu God ye Kingkin yaa wabkad keriwen kowe, Mosesbed yi yaa kenambunmo dakmoon. ");
INSERT INTO yon_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Yarimanbed yi yaa yedme kowoon kuu Keenan ambibkin aom doriibdan korem yeene nongkobime andoon kumban, koremban yenamo yenbandiwen. ");
INSERT INTO yon_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Kwane, yi kuu Keenan ambibkin aom doriibdan yaa kan dabokenib, yi amowamob yaa awine kandenib, ");
INSERT INTO yon_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","yi kuruwak god yaa kurikuri kame yi aningko kankooniwen kowe, kuye kuruwak god kuu Israeldan yaa kawaad nong awinemoon areb kerundoon. ");
INSERT INTO yon_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Israeldanbed yi karub danayiib nima danayiib kuu yeene kuruwak god, awad arewa kui, yi dingki aom nongkobiwen. ");
INSERT INTO yon_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Yimbed ambarakmindodan ogood yenbandiiwe umkan kubudoroon, yi karub danayiib nima danayiib yi umkan kui. Yimbed yeene Keenandan yi kuruwak god yi dingki aom nongkobiwen kowe, ambibkin kuu umkan kubudoroon kumbed Godbed yi yaa angkurom korokbendi yeman keroon. ");
INSERT INTO yon_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Yimbed kwane kamiwen kumbed yi kangkon Godbed angkurom korokbendi yeman keriwen, yi arewa kamenabi yaambed yi kuu nenemdan areb keriwen. ");
INSERT INTO yon_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Kwana kowe, Yariman ye norin kuu ye nimakarub yaa denoboon, yumbon kondoondan yaa kuu komyeng areb kerundoon kui. ");
INSERT INTO yon_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Kowe yembed yi kuu ben ambibkin yenadan yi dingki ari nongkoboon kowe, yi yaa kuu arud wandembiridanbed ooniwen. ");
INSERT INTO yon_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Yi yaa kuu yi bondanbed dabab dabab yobdoodmo bangkandiwen, kwane yi kuu yi bondan yi dabderem yirimbed doriib. ");
INSERT INTO yon_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Yembed yi kuu aron yemoonmombed arewa yaa burudande bindimaan, kumban yi kuu wabkad kamembirimaib kowe, ambarakmi dem kongdem yiri kubunimaib. ");
INSERT INTO yon_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Kwanimaib kumban ye yaa baandiiwe wengamboroon kuu yembed yi miin yiminban keriwen kuyaa wedmendoon. ");
INSERT INTO yon_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Kwane amob weng ongmoon kuyaa kuu yi dowad ika meenekore, ye womoniyibban ye mimyob dowaken darewoob yaambed yi yaa ukum kondi kuu korondoon. ");
INSERT INTO yon_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Kwane yembed yi bondan kuu ongmendoona yi bondan kuu yi yaa mimyob kowimaib, kane kanembed Israeldan awingkiwendan kui. ");
INSERT INTO yon_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","O Yariman nub God, nub kuu arewa yaa burudande binde. Nub kuu ambibkin maa maa kumaom doruub kuu ben menebe. Kwananeeb kuu ewaningko karadmo yaa eso andenub, ewaningko kankoone kubi darewoob keranuub. ");
INSERT INTO yon_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Yariman, Israeldan yi God, ye aningko kankoonem, aron korem anuk doberewenbed mene aron korem ambab ari dobaraneeb kumaom kuu kwane kamem. Nimakarub korem kuu yedmime, “Anam kwanok.” andime. Yariman yaningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Yariman kuu amun kowe, ye yaa eso andem, amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem angkimbaraneen kowe. ");
INSERT INTO yon_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Ku yedmaan kuu Yarimanbed biddoondan kuu kwane yedmime, bondan yi dingki dem aombed biddoondan kui. ");
INSERT INTO yon_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Okad maa maa yaambed benmonoondan kui, kangkayiib kaomiib kariyiib kiriyiib yaambed benmonoondan kui. ");
INSERT INTO yon_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Yena kuu amiibban ye amboon angka awerenmo yariwen, kwane siti yaa wini ye kiwaan onmiwen kuned ma wedmindo. ");
INSERT INTO yon_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Yi kuu mungiyiib ok moomiib kumbed duknok andiwen. ");
INSERT INTO yon_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Kwane yi kuu dabab kandiwen ye dowad Yariman yaa baandiwen, kowe yembed yi miin yiminban keriwen yaa kuu awandoon. ");
INSERT INTO yon_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Ye kangkon yi kuu ben kiwaan yorokmo arimbed kinban wenene siti yaa nandoon. ");
INSERT INTO yon_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Yi kuu Yariman ye womoniyiibban ye mimyob dowaken ye dowad ye yaa eso andime, kwane binangke ye yaa anam andi yeman ongmenaboon ye dowad kangkon eso andime. ");
INSERT INTO yon_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Amborom kuu kane kane yi kuu moom bobniwen kuu bangkandoone ane mikmoniwen, kwane kane kane yi kuu mungi bobniwen kuu animan amun bangkandoone yiminmo keriwen kowe. ");
INSERT INTO yon_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Yena kuu kumun aombed dobiriwen, kumun doromod bobnin aom kui, yi kuu wiidan, seinbed yerengki ye durud yewediib dobiriwen kui. ");
INSERT INTO yon_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Amborom kuu yi kuu anukbed God ye weng yaa wabkad kerenib, Korem Burudandoon Arimbed ye God ye ongkandi yaa wunekariwen kowe. ");
INSERT INTO yon_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Kwana kowe, yembed yi kuu ben deme yobdoodmo yaa kiraroon, kwane yi kuu komborok andiwen kuu yi kuu awandi ye karuwiibban. ");
INSERT INTO yon_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Kwanekorib dabab kandiwen ye dowad Yariman yaa baandiwen, kowe yembed yi miin yiminban keriwen yaa kuu awandoon. ");
INSERT INTO yon_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Kwane yembed kumun doromod bobnin aom kuu yi ben angkaderene, yi yaa sein yerengkoon kuu buruwadmoon. ");
INSERT INTO yon_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Yi kuu Yariman ye womoniyiibban ye mimyob dowaken ye dowad ye yaa eso andime, kwane binangke ye yaa anam andi yeman ongmenaboon ye dowad kangkon eso andime. ");
INSERT INTO yon_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Amborom kuu yembed wii ambongko broonsbed ongmiwen kuu wowe monmarene, yerengki yeman awurimbed ongmiwen kuu nare kiradmoon kowe. ");
INSERT INTO yon_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Yena kuu yika wabkad keri ye inamen yaambed inameniibbandan kerenib, ambarakmenabiwen kumbed durud yewed kandiwen. ");
INSERT INTO yon_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Kwane yi kuu animan korem yaa komyeng areb kerundekorib, bobni ambongko yaa winiwen. ");
INSERT INTO yon_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Kwanekorib dabab kandiwen ye dowad Yariman yaa baandiwen, kowe yembed yi miin yiminban keriwen yaa kuu awandoon. ");
INSERT INTO yon_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Kwane yembed weng kowoon kumbed yi kuu ongmendoon, kwane yika monmari ye inamen yaa kuu burudande bindoon. ");
INSERT INTO yon_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Yi kuu Yariman ye womoniyiibban ye mimyob dowaken ye dowad ye yaa eso andime, kwane binangke ye yaa anam andi yeman ongmenaboon ye dowad kangkon eso andime. ");
INSERT INTO yon_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Yi kuu munob konemoon areb ye yaa eso andime, kwane ye ambangkanabi kuu dakme kubi yookbed wingkime. ");
INSERT INTO yon_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Yena kuu motod aombed karamok ari winiwen, yi kuu ok darewoob ari dewenenib berengke moonidan keriwen kui. ");
INSERT INTO yon_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Yi kuu Yariman ye ambangkanabi wedmiwen, binangke ye yaa anam andi yeman karamok niindem yiri ongmenaboon kui. ");
INSERT INTO yon_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Amborom kuu yembed yedmoone nuuwa ama arewa kamene oknondok darewoob ambab ari ben daanebeen kowe. ");
INSERT INTO yon_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Oknondokbed yi kuu kan ambid ari daanekoru kan niindem yiri kubunekoru kameen, kwane arud darewoob aom aomniwen kumbed aromkonoyiibban dubendebenmo keriwen. ");
INSERT INTO yon_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Kwane yi kuu awarak yimaundan areb kanwene kudore kudore kamenib, inamen amun kandindeban keriwen. ");
INSERT INTO yon_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Kwanekorib dabab kandiwen ye dowad Yariman yaa baandiwen, kowe yembed yi miin yiminban keriwen yaa kuu ben angka nongkoboon. ");
INSERT INTO yon_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Yembed nuuwa ama yaa yedmoone dowan keroon, kowe karamok yu oknondok kuu kan kubune yewenub kereen. ");
INSERT INTO yon_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Yewenub keruune yi kuu kubiwen, kwane yembed ben kinban wene yimbed wirinande meeniwen yaa be monoon. ");
INSERT INTO yon_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Yi kuu Yariman ye womoniyiibban ye mimyob dowaken ye dowad ye yaa eso andime, kwane binangke ye yaa anam andi yeman ongmenaboon ye dowad kangkon eso andime. ");
INSERT INTO yon_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Kwane yi kuu nimakarub nedbimaib aombed ye aningko kankoonenib, aamkono aamkono nedbimaib aombed ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Yembed ok awaan kuu amonomboone koknoonbon okad keruune, kirubdem menebenaun ye okad kuu kebenoone okad kamkonombonmo keruune, ");
INSERT INTO yon_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","yob irimaan ye okad kuu amonomboone kab kainindeban ye okad kereen, amborom kuu kuyaa doriibdan kuu miin arewa kamenabimaib kowe. ");
INSERT INTO yon_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Angkon amaan yembed amaan koknoonbon okad kuu amonomboone ok bumbon ye okad keruune, okad kamkonobonmo kuu amonomboone kirubdem menebenaun ye okad keruune, ");
INSERT INTO yon_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","mungi bobniwendan kuu kuyaa ben monoone, yimbed siti yenbekorib dobiriwen. ");
INSERT INTO yon_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Yi kuu mongkobon ongmekorib nong yob kab kibingkiiwe yob yemoonmo ire wonoone wandiwen. ");
INSERT INTO yon_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Yembed yi yaa amun kerundoone yemoon ariyiib yidwaroon, kwane yi dingkan amongkob kangkon ma domondoona nombere yiri kubunindo yemoon ariyiib keriwen. ");
INSERT INTO yon_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Amaanbed yi kuu nombere kamene yiri keroon, kwane dabab wayiriyiib miin yiminban keriyiib mimyob wandiyiib kumbed kan kubune yirimbed keriwen. ");
INSERT INTO yon_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Yembed yi korok korok yi dowad miin arewa ande ambodiibban kerundekore, kiwaaniibban ye amboon yaa ben nongkoboone awerenmo yariwen. ");
INSERT INTO yon_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Kumban yembed nub yaa awandok andidan kuu yi yaa dabab angkeen yaa benkoobekore, yi nimadana kuu ongmendoone sibi wad yemoon areb yemoon ariyiib keriwen. ");
INSERT INTO yon_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Kangdommo dobiridan kuu kuyaa wedmekorib kubiwen, kumban arewa kamenabidan kuu mungkod karangkiwen. ");
INSERT INTO yon_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Kanembed ye kuu meeni kangdomiib keroka weng anuk angkeen kuyaa kaadkerok. Kwane ye kuu Yariman ye womoniyiibban ye mimyob dowaken kerekmen yaa meenok. ");
INSERT INTO yon_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Yook, God yaningko kankooni ye yook Dewidbed wongkoon. O God, ne niindem aom kuu kiringmiyiibban kangdommo, ne kuu ne inamen koremiibbed wangke yook wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Haawiib laiyayiib, yiib kuu dembime! Yiiwiib wangke wingkeni aron kakmendaniine awawini nambere wananuun. ");
INSERT INTO yon_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","O Yariman, ne kuu ambibkin korem aombed eb yaa eso andaniin, kwane ne kuu ambibkin maa maadan aombed ewaningko kankooni ye yook wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Eb womoniyiibban ye mimyob dowaken kuu miin darewoob, kukuu okad yirimbed kawene Ewen aom nandi ye kwane ambab arebban. Eb ma korondiyiibban weng awini ye kerekmen kuu daane ambid aom nandoon. ");
INSERT INTO yon_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","O God, Ewen burudande ewaningko ariyiib kerok. Eb nambiri kuu okad kumundin ari kerok. ");
INSERT INTO yon_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Eb dingki wiwimbed nub kuu arewa yaa burudande binde awande. Kwananeeb kumbed mimyob dowaken keendewendan kuu ben angka nongkobaneeb. ");
INSERT INTO yon_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","God kuu ye karadmombon aombed yedmoon, “Nembed ne bondan burudande doreni okad Sekem kuu ne nimakarub yaa numbere kondaniin, kwane Sukot dabon yiri kwangkon nekwane kumunkingkaniin, numbere kondi dowad. ");
INSERT INTO yon_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Gilead kuu neman, Manase kwangkon neman, Efraim kuu ne topi kamkono, Yuda kuu ne king yaromkono yobdoodmo ooni yeman. ");
INSERT INTO yon_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Moab kuu ne dingki oki yeman ye kobukmo yabad. Idom ari kuu ne yonkad kiraraan. Filistia ari kuu nembed burudande doraan kumbed komkaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Kanembed ne nen siti bot kuukiib aom aomnaneen? Kanembed ne nen ambibkin Idom aom wananeen? ");
INSERT INTO yon_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","O God, ebbedmo yimin. Eb komande nub wunekarundewen? O God, eb komoyiibkob nub ana nangmidan yoom wanaibban? ");
INSERT INTO yon_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Nub bondan yaa nangmi dowad nub awande, amborom kuu karub ye aromkono awandaniiwe nangmanuub kuu korem yiminban kowe. ");
INSERT INTO yon_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Nub kuu Godiib kumbed burudande doranuub, kwane yembed nub bondan ari dorene ben kubunaneen. ");
INSERT INTO yon_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Yook ambo bi ye karub yeman. God yaningko kankooni ye yook Dewidbed wongkoon. O God, eb kuu nembed ewaningko kankoonimainman, iwari keraab, ");
INSERT INTO yon_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","amborom kuu arewa kamenabe birandimaibdan kuu ne yaa daawimaib, yimbed ne dowad dudi wengbed dakmiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Ne yaa arud wandembiri wengbed ne kanawanewandiwen, kwane ne kuu yi yaa ma arewa kamindo kumbed yimbed nimaib. ");
INSERT INTO yon_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Ne kuu yi yaa mimyob dowaken keendaan kumban yi kuu amonombe nembedmo arewa anduwiwen, kumban ne kuu kurikuri kamendi ye karub. ");
INSERT INTO yon_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Ne kuu yi yaa amun amun kamaine inanduwe arewa kamimaib, kwane mimyob dowaken keendaan ye dowad arud wandembiriwen. ");
INSERT INTO yon_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Arewaman maa kine nendebko ne bonman yaa manmo kerunok, kwane ambarakmoon kii ande dedmonde yedmendi ye karub nenmenebko ne bonman ye dingki wiwi angka doborok. ");
INSERT INTO yon_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Ne bonman kuu wengyunde wedmibko anam ambarakmoon kerok. Kwane ye kurikuri kami kumbed amonombe ambarakmi yeman kerok. ");
INSERT INTO yon_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Ye weeb kuu yemoonban kerok, kwane ye korok keri ye yumbon kandoon kuu karub maambed kandok. ");
INSERT INTO yon_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Ye dana meed kuu awodkiyiibban kerime, kwane ye wonong kuu irib keruk. ");
INSERT INTO yon_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Ye meed kuu kirinwanmo yare eekmenabidan kerime, kwane yi ambib arewa kereen kuyaom kuu koronde ben angka kirarime. ");
INSERT INTO yon_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Ye dungkumiib angkeen ye karubbed ye yiribman korem bok, kwane yembed ambangkoon ye yiribman kuu noroddanbed dorebunbe bime. ");
INSERT INTO yon_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Ye yaa mimyob dowaken keeni ye karuwiibban kerok, kwane ye meed ari awodkiyiibban keraniib kuyaa kuu mimyob keendi ye karuwiibban kerok. ");
INSERT INTO yon_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Ye awoya ari kuu nare dowan kerok, kwane yi aningko kuu are dowan kerok, amaan ari dobaraniibdan kuu yi yaa nonondandundime. ");
INSERT INTO yon_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Ye ambeya yi arewa kamenabi kuu Yariman yarinambo arimbed kwane angkimborok, kwane ye ena yu ambarakmi kuu are dankaraib. ");
INSERT INTO yon_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Kwane yi ambarakmi kuu aron korem Yariman ye murubia ari angkimborok, kwananeen kuu yembed okaddan yaambed yi meenmi yeman kuu nare dowan keraneen. ");
INSERT INTO yon_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Amborom kuu kuye karub kuu ma kubende amun kamande meenindo, kwane kamboknondaniib awandok andidaniib miin yiminban keriwendaniib kuu yembed yi yaa duknime ande yenbandimaan. ");
INSERT INTO yon_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Ye dowaken darewoob kuu butun wengmo dakmembiri kowe, kuye butun kuu ikakman ye yaa menebok. Amun kerundi kuu ye dowakenban kowe, amun keruni kuu ye yaa ambab kerok. ");
INSERT INTO yon_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Ye kuu aronki mimim korem ebkad derenimaan areb butun kamimaan, kwane aron yemoon ok animaan areb butun kamenabi kuu ye inamen aom aomderebimaan, kwane aron yemoon animan kowiib ane aromnimaan areb butun kami yaa meeni dowaken darewoowiib kerimaan. ");
INSERT INTO yon_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Kowe kuye butun kuu ebkad doboob ye ari dabunemoon areb kerok, kwane kuye butun kuu kobaiknong boronemoon areb keremborok. ");
INSERT INTO yon_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Ne yaa ambarakmoon kii ande dedmowe yedmewidan yaa kuu weng anuk angkeen kuu Yarimanbed kwane kamok, ne yaa weng arewa daawimaibdan yaa kui. ");
INSERT INTO yon_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Kumban, o Yariman Ambengkan, eb yirin kowi dowad ne yaa kuu amun amun kame. Eb womoniyiibban ye mimyob dowaken kuu amun kowe, ne kuu arewa yaa burudande nende. ");
INSERT INTO yon_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Amborom kuu ne kuu kamboknon kere awawe ande kamaan, kwane ne niindem aom kuu durud yewed kandaan. ");
INSERT INTO yon_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Ne kuu oobneya ye kuruwak wene biknemoon areb kubuniibban keraan, kwane ne kuu ed yaa nuubbed wuure kankaremoon areb keraan. ");
INSERT INTO yon_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Ne kuu animan koronde eb yaa kurikuri kerimain kumbed ne dangbo kuu wud kereni, ne id kuu kad kombere konokonomo keraan. ");
INSERT INTO yon_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Ne kuu ne yaa ambarakmoon kii ande dedmowe yedmewidan yi damangkawimbon keraan, kwane yi kuu wedmewimaib kuu yi korok wamburukme damangkawimaib. ");
INSERT INTO yon_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","O Yariman ne God, ne awawe. Ebka eb womoniyiibban ye mimyob dowaken kerekmen yaambed ne kuu arewa yaa burudande nende. ");
INSERT INTO yon_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Kwane, eb dingkimbed ne dowad kwane ambangkaneeb ye yoman kuu yi yaa korokbendebko yikaadkerime, kukuu, o Yariman, ebbed ne dowad kamaneeb kuu wedmaniib kui. ");
INSERT INTO yon_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Yi kuu butun kamaniib kumban ebbed amun keruwaneeb. Yimbed nenbandaniib kuu yi yaa karak kondaneeb kumban, eb dememan ne kuu kubaniin. ");
INSERT INTO yon_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Ne yaa ambarakmoon kii ande dedmowe yedmewidan kuu aningko arewayiib kerok, kwane yi yaa kuu karakbed ebkad doboob areb kan derene bedmok. ");
INSERT INTO yon_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Ne mongkodkonombed Yariman yaa eso darewoob andunaniin, kwane kadaareb yemoon kidangkambed ye aningko kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Amborom kuu ye kuu awawime andi ye karub ye dingki wiwi angka doberene awanenimaan, ye yaa wengyunde bobni yeman andimaibdan yi dingki aom kuu burudande nendi dowad. ");
INSERT INTO yon_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","God yaningko kankooni ye yook Dewidbed wongkoon. Yarimanbed ne Yariman yaa yedmoon, “Ne wiwi angkambed dibereewo, nembed eb bondan korem kuu ben eb yondad dabderem yiri kiriba.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Eb ooni yaromkono kuu Yarimanbed aangko Saiyon yaambed aromkono ariyiib daboknaneen, kwane yembed yedmaneen, “Ebbed eb bondan aom kuu ebbed oonaneeb.” andaneen. ");
INSERT INTO yon_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Eb aromkono kuu nambiri karadmoyiib korokbaneen yaron ari kuu eb nimakarub kuu nindorokiibbed eb yoman wananiib. Amkimo ye nirok areb eb kewed yemooniib ewiib yaa mananiib. ");
INSERT INTO yon_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Yarimanbed ye inamen ma amonombaanban ye weng yedme kowoon, “Eb kuu Melkisedekbed God dore nimakarub dore wedyiri dobiri ye karub keroon areb kwane God dore nimakarub dore wedyiri dobiri ye karub aron korem dowad kerewen kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Yariman kuu eb dingki wiwi angka doreen, kwane ye norin aron arimbed kingdan kuu beengke monmaraneen. ");
INSERT INTO yon_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Yembed ambibkin mimimdan kuu wengyundenekore yenbande nongkobe wenore mim arimo keraneen, kwane yembed okad yiri ye korok korem kuu beengke monmaraneen. ");
INSERT INTO yon_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Ye kuu kiwaan kebed angka ok manambed ananeen, kwana kowe, ye korok kuu ari kankoonaneen. ");
INSERT INTO yon_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Yarimanbed ye aningko kankoonime. Ne kuu ne niindem aom kumundin kumbed Yariman yaa eso andaniin, kangdommo doriibdan nedbimaib aombed. ");
INSERT INTO yon_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Yariman ye ambangkanabi kuu darewoob arimbed, ye ambangkanabi yaa dowakeniib keriwendan kuu kuyaa andangke meendobimaib. ");
INSERT INTO yon_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Ye kamenabi kuu nambiriyiib manimanandewiib, kwane ye yorokmo kerekmen kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Binangke ye yaa anam andi yeman ongmenaboon kuu nub yaa daandaane meenimaub, nonondandaubban. Yariman kuu kabamoon kondoon ye mimyob dowaken keendi ye God, ye kuu nub yaa dabab menebaane mimyob kowi ye God. ");
INSERT INTO yon_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Ye yaa unimaibdan yaa kuu yembed animan bangkandimaan, kwane yembed amob weng ongmoon kuyaa kuu aron korem meenembirimaan. ");
INSERT INTO yon_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Yembed ye nimakarub yaa ye ambangkanabi yaromkono kuu korokbendoon, ambibkin yenadan yi okad kuu kande yi yaa kondoon kowe. ");
INSERT INTO yon_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Ye dingkimbed ambangkanabi kuu anammo, yi kuu yorokmo, kwane ye kongamki yamob kuu angkumone dobiri yeman. ");
INSERT INTO yon_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Yi kuu aron korem kwane dangembaraneen, yi kuu anamiibbed awinimaib, yi kuu yorokmoyiibbed awinimaib. ");
INSERT INTO yon_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Yembed ye nimakarub biddi ye kiwaan ongmoon, kwane ye amob weng ongmoon kuu aron korem yeman yedme kowoon. Ye aningko kuu karadmo, ye aningko kuu binangke ye kuu darewoob arimbed andi yeman. ");
INSERT INTO yon_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Yariman yaa uneni kuu meeni kangdom ye ambokab, kwane kane kanembed ye kongamki yamob awinimaib kuu yi korem kuu inamen kaadkeri amun kandiwen. Ye yaningko kankooni kerekmen kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Yariman ye aningko kankoonime. Karub kanembed Yariman yaa unimaan kuu Yarimanbed amun kerunoon, kwane karub kane kuu Yarimanbed kwanime andi ye weng yaa dowaken darewoob keroon kuu Yarimanbed amun kerunoon. ");
INSERT INTO yon_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Kuye karub ye dana meed kuu okad yiri kuu aromkono darewoobdan keraniib, kwane ye ayowa ari kuu kangdommo dobaraniiwe amun kerundaneen. ");
INSERT INTO yon_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Odamoda yiribman yemoona kuu ye ambiwoom dangoon, kwane ye yorokmo kerekmen kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Kuye karub kuu kangdommo doriibdan yi dowad kumun aombed namberemoon areb keroon, kwane ye kuu kabamoon kondoon ye mimyob dowaken keendene yena yi dabab yaa mimyob keendene yorokmo dobirimaan ye karub. ");
INSERT INTO yon_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Karub kanembed kubiyiib od darewoob kondene nindorokiibbed od araben kondimaan kuu amunmo dobaraneen, yorokmo kerekmen yaambed deme awinimaan ye karub kui. ");
INSERT INTO yon_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Amborom kuu ye kuu ma kan kiringmaanban kowe. Yorokmo ye karub kuu Godbed aron korem meenenaneen nonondandunaanban. ");
INSERT INTO yon_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Ye kuu weng yuk arewa yaa kuu ma unaanban, kwane ye niindem aom kuu kiringmiyiibban kangdommo, Yariman yaamo angkumone doreen. ");
INSERT INTO yon_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Ye inamen kuu karub maambed ma nen kimyen wanaanban, ye kuu unaanban, yeenbon arimbed yembed ye bondan burudande doraneen. ");
INSERT INTO yon_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Yembed nindorokiibbed kamboknondan yaa munob bangkandimaan, kwane ye yorokmo kerekmen kuu aron korem kwane angkimbaraneen, kwane ye kuu aningko darewoob arimbed kankoonaniib. ");
INSERT INTO yon_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Kwane, arewa kamenabi ye karub kuu wedmenekore noriniib keraneen, kwane ye kuu ningkambo kabang kamene miin yiminban keraneen. Arewa kamenabidan yi meeni dowakeniib kuu idiibban keraneen dowan. ");
INSERT INTO yon_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Yariman ye aningko kankoonime. O Yariman ye demedan, ye aningko kankoonime. Yariman ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Yariman ye aningko kuu amun kerundok, kibikiib aron koremiib. ");
INSERT INTO yon_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Aron yaro minimaun angkambed wene aron kubunimaun kuye okad aombed Yariman ye aningko kuu kankooni yeman. ");
INSERT INTO yon_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Yariman kuu ambibkin koremdan yaa kuu yembedmo darewoob arimbed. Ye nambiri kuu Ewen burudande darewoob arimbed keroon. ");
INSERT INTO yon_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Kane kuu Yariman nub God areb? Dowan. Ye kuu miin ambab arimbed dibere oonoonman. ");
INSERT INTO yon_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Ye kuu dibere nikbe kan yiri kerene Eweniib okadiib yaa kerendombirimaan ye karub. ");
INSERT INTO yon_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Yembed kamboknondan okad ingkud yiri dangiwen kuu benkoobimaan, kwane yembed nub yaa awandok andidan kuu yi yaa dabab angkeen yaa benkoobimaan. ");
INSERT INTO yon_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Yi kuu ongmaane king ye karub dana meed yoom dibirimaib, yi ambibkin mimodan yi korok korok yoom dibirimaib kui. ");
INSERT INTO yon_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Yembed nima kurong kuu ongmaane danayiib kere kubenib yi ambiwoom dobirimaib. Yariman ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Israeldan Idyip aombed angkane winiwen yaron, Yekob ye awoya ari kuu yikaadban ye weng maa dakmimaibdan yaambed yaro winiwen yaron kui, ");
INSERT INTO yon_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","kuyaron kuu Yudadan kuu ye karadmodan keriiwe, Israeldan kuu ye nimakarub keriwen. ");
INSERT INTO yon_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Karamok kuu wedmekoru kombere wuneen, kwane ok Yooden kuu yinmone ika daaneen, ");
INSERT INTO yon_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","kwane aangko aangko kuu sibi ambi areb korongbere nadmiwen, kwane koodbon koodbon kuu sibi mana areb korongbere nadmiwen. ");
INSERT INTO yon_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","O karamok, komoyiibkob kombere weneeb? O Yooden, komoyiibkob yinmone ika daaneeb? ");
INSERT INTO yon_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","O aangko aangko, komoyiibkob sibi ambi areb korongbere nadmiib? O koodbon koodbon, komoyiibkob sibi mana areb korongbere nadmiib? ");
INSERT INTO yon_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","O okad kumundin, Yariman ye arinambo arimbed kiringme, Yekob ye God ye arinambo arimbed kui. ");
INSERT INTO yon_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Yembed dumnadbon kuu amonomboone ok bumbon kereen, kwane dumnad kamkonombon kuu amonomboone ok kirubdem yemoon ye okad kereen. ");
INSERT INTO yon_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","O Yariman, nub yaamban, ewaningko yaamo kuu nambiri kabdi yeman, amborom kuu eb womoniyiibban ye mimyob dowakeniib ma korondiyiibban weng awiniyiib bangkandimaab kowe. ");
INSERT INTO yon_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Ambibkin koremdan kuu komande nub dowad kwane kaamondimaib, “Yi God kuu kuna?” andimaib? ");
INSERT INTO yon_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Kumban nub God kuu Ewen arimbed dibeen, kwane ye dowaken kunaya angkeen kuu kwamunemo ambangkimaan. ");
INSERT INTO yon_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Kumban yi god kuu kuruwakmo, bot silvaayiib goldiib karub yi dingkimbed ongmenabiwenmo. ");
INSERT INTO yon_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Yi kuu mongkodkonoyiib kumban dakmindeban, kwane yi kuu indowiib kumban wedmindeban, ");
INSERT INTO yon_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","kwane yi kuu kerendemiib kumban wengambirindeban, kwane yi kuu kiringkonoyiib kumban kuwindeban, ");
INSERT INTO yon_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","kwane yi kuu dingkiyiib kumban badmene kaadkerindeban, kwane yi kuu yoniib kumban yarindeban, kwane yi kuu yi kiwadkok weng wandindeban. ");
INSERT INTO yon_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Kane kanembed kuruwak god ongmenabimaib kuu kuruwak god kuyareb keraniib, kane kanembed kuruwak god yaa angkumone dobirimaib kangkon kuruwak god kuyareb keraniib. ");
INSERT INTO yon_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","O Israeldan, Yariman yaambed angkumone dobirime, yembed yiib kuu awandene dorondarimaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","O Eeron ye awoya ari, Yariman yaambed angkumone dobirime, yembed yiib kuu awandene dorondarimaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Yariman yaa unimaibdan, Yariman yaambed angkumone dobirime, yembed yiib kuu awandene dorondarimaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Yariman kuu nub yaa meenendimaan, kwane nub yaa amun kerundaneen. Yembed Israeldan yaa amun kerundaneen. Yembed Eeron ye awoya ari yaa amun kerundaneen. ");
INSERT INTO yon_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Aningkoyiibbandaniib aningko darewoowiibdaniib, kaneyambed Yariman yaa unimaib kuu yembed yiib yaa amun kerundaneen. ");
INSERT INTO yon_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Yiib yaa kuu Yarimanbed danaya yemooniib awoya yemooniib bangkandok. ");
INSERT INTO yon_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Yiib kuu Yarimanbed amun kerundok, Eweniib okadiib ongmenaboonman, yembed kui. ");
INSERT INTO yon_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Ewen kuu Yariman yeman, kumban okad kumundin kuu nimakarub yaa kondoon. ");
INSERT INTO yon_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Dukniwendan kuu Yariman yaningko kankoonimokban, iwarimo kere dangiwendan kui. ");
INSERT INTO yon_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Kukuu nubbed Yariman yaningko kuu kankoonimaub, kibikiib aron koremiib. Yariman ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Nembed Yariman yaa mimyob dowaken keenaan, amborom kuu ne wengiib awawe ande baandiyiib kuu wengamboroon kowe. ");
INSERT INTO yon_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Yembed ye kerendem kuu ne yaa wengambarande kowimaan kowe, ne wad kee doriin yaron kuu ye yaa baandimamaniin. ");
INSERT INTO yon_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Bobni ye kibin abakbed ne kuu yerengkoon, kwane bobkonombon yiri kubuni ye uniwon karakwon kuu ne yaa meneboon, kowe ne kuu miin yiminban kereni mimyob darewoob wandaan. ");
INSERT INTO yon_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Kwamune kerekori, Yariman yaningko yaa kowe baandaan, “O Yariman, ne kuu kuyaa burudande nende!” andaan. ");
INSERT INTO yon_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Yariman kuu kabamoon kondoon ye mimyob dowaken keendi ye God, ye kuu yorokmo dobiri ye God, nub God kuu mimyob keendimaan. ");
INSERT INTO yon_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Yarimanbed mengmengiibban iwari doriibdan yaa kuu awande dorondarimaan, ne kuu dababbed kankubune yirimo keroon kuu yembed ne nen angka kowoon. ");
INSERT INTO yon_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","O ne kingkin, meeni darewoob keroon kuu koronde iwari kerok, amborom kuu Yarimanbed amun kamewoon kowe. ");
INSERT INTO yon_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","O Yariman, ebbed ne kuu bobni yaa burudande nendewen, kwane ne kuu ongmeewe ne inok wi kuu dowan keroon, kwane ne kuu awaweewe komborok andindo. ");
INSERT INTO yon_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Ne kuu wad dobiridan yi ambibkin aom doriin kuu Yariman ye arinambo ari amunmo dobiri ye kiwaan ari dodkanmo yarebaniin. ");
INSERT INTO yon_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Nembed anam ande yedmaan kuu “Ne kuu dabab darewoowiib kii.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Ne kuu binangke uniyiib keraan kumbed yedmaan, “Karub korem kuu dudanabidanmo kii.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Yarimanbed ne yaa amun amun kamembirimaan kuyaa kuu nembed komo inande konaniin? ");
INSERT INTO yon_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Ne kuu Yarimanbed arewa yaa burudande nendoon kuyaa eso andi dowad wain ok ye kabus nande ye yaa kankooneni, ye aningko kowe ye yaa baandaniin. ");
INSERT INTO yon_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Kwane, ne kuu Yariman ye dowad kwananiin andi ye weng yedme nongkobaan kuu awinaniin, ye nimakarub yi arinambo arimbed kwamunemo awinaniin kui. ");
INSERT INTO yon_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Yariman ye karadmodan ye indob arimbed kuu miin manimanandeb anam, kowe yi dukni kuu barang miin darewoob ande meenoon. ");
INSERT INTO yon_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","O Yariman, anam kuu ne kuu eb dememan. Ne kuu eb dememan, eb deme wonong yu mingki kui. Ne kuu yerengkiwen kuu ebbed dudbere nen obon keruwewen. ");
INSERT INTO yon_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Ne kuu eso andi dowad munob kabdi yeman kuu kabdeni ewaningko kowe eb yaa baandaniin. ");
INSERT INTO yon_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Kwane, ne kuu Yariman ye dowad kwananiin andi ye weng yedme nongkobaan kuu awinaniin, ye nimakarub yi arinambo arimbed kwamunemo awinaniin kui. ");
INSERT INTO yon_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Yariman ye kurikuri boyambib yu kuuk wirinimbon aombed kwananiin, o Yerusalem, kub kidangkambon aombed kui. Yariman ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Ambibkin koremdan, Yariman ye aningko kankoonime. Nimakarub korem, ye aningko kuu darewoob arimbed andime. ");
INSERT INTO yon_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Amborom kuu ye womoniyiibban ye mimyob dowaken nub yaa keendimaan kuu miin darewoob anam, kwane Yariman ye ma korondiyiibban weng awini ye kerekmen kuu aron korem angkimbaraneen. Yariman ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Yariman kuu amun kowe, ye yaa eso andem, amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem angkimbaraneen kowe. ");
INSERT INTO yon_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Israeldan kuu kwane yedmime, “Ye womoniyiibban ye mimyob dowaken kuu aron korem angkimbaraneen.” andime. ");
INSERT INTO yon_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Eeron ye awoya ari kuu kwane yedmime, “Ye womoniyiibban ye mimyob dowaken kuu aron korem angkimbaraneen.” andime. ");
INSERT INTO yon_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Kane kane kuu Yariman yaa unimaib kuu kwane yedmime, “Ye womoniyiibban ye mimyob dowaken kuu aron korem angkimbaraneen.” andime. ");
INSERT INTO yon_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Ne niindem aom kuu miin yiminban keroon kumbed Yariman yaa baandaana, ne yaa inanduwe ne nen burudande obon kere ongmewoon. ");
INSERT INTO yon_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Yariman kuu ne yaa doreen kowe ne kuu unainban. Kedi, karub kuu ne yaa kuu komo keruwaniib? Dowan. ");
INSERT INTO yon_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Yariman kuu ne yaa doreen, ye kuu awawi ye karub. Kwana kowe, ne bondan yaa kuu nangme burudande doraneene wedmaniin. ");
INSERT INTO yon_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Yariman ye kukbimaanbon aom dobiri kuu miin amun, karub yaa angkumone dobiri arebban. ");
INSERT INTO yon_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Yariman ye kukbimaanbon aom dobiri kuu miin amun, korok korok yaa angkumone dobiri arebban. ");
INSERT INTO yon_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Ambibkin koremdan kuu ne yaa bon kere kanawanewandiwen kumban, Yariman yaningko yaambed yi aromkono nare monmaraan. ");
INSERT INTO yon_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Yi kuu ne yaa kanawanewandiwen, eyokee, yi kuu ne kiwaan kebene kanawanewandiwen kumban, Yariman yaningko yaambed yi aromkono nare monmaraan. ");
INSERT INTO yon_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Yi kuu mong areb ne yaa kanawanewande nimingkiwen kumban, yi kuu yik deneene kirodmo kumunderemoon areb keriwen, Yariman yaningko yaambed yi aromkono nare monmaraan. ");
INSERT INTO yon_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Ne yaa kuu naawonmo ana nangmiiwe kombaraniin andaan, kumban Yarimanbed awawoon. ");
INSERT INTO yon_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Yariman kuu ne aromkono angkon ne yook, kwane ye kuu ne nen burudande angka kowi ye karub keroon. ");
INSERT INTO yon_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Kube komkiyiib burudande dori ye baandiyiib kuu yorokmodan yi ambib kombon aom kuweng ooneen kii. “Yariman ye dingki wiwi yaromkonombed kwanoon kii! ");
INSERT INTO yon_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Yariman ye dingki wiwi kuu kankoone ari kaimbed keroon kii! Yariman ye dingki wiwi yaromkonombed kwanoon kii!” ande kamiib. ");
INSERT INTO yon_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Ne kuu bobnainban wad dobereni, Yarimanbed komo komo ambangkanaboon kuu nembed ben dakmenabaniin. ");
INSERT INTO yon_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Yarimanbed ne yaa kuu naawonmo didangkawoon, kumban ne kuu nen bobni ari kowe korondoona bobnindo. ");
INSERT INTO yon_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Yorokmodan awudirimaib ye kuuk wirinimbon ye ambongko kuu ne yaa nande. Kwanebko ne kuu awudereni Yariman yaa eso anda. ");
INSERT INTO yon_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Ambongko keyiib kee Yariman yeman kii, kwane yorokmodan kuu ambongko kumbed aom awunimaib. ");
INSERT INTO yon_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Eb kuu ne baandi yaa inanduwewen kowe, eb yaa eso andaniin, kwane eb kuu ne nen burudande angka kowi ye karub kerewen. ");
INSERT INTO yon_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Bot kuu boyambib yenbidanbed kankorariwen kuu, ambib kumundin amun yenbi ye dongka bot keroon. ");
INSERT INTO yon_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Kukuu Yarimanbed kwane ongmoon kedi! Nub indob ari kee wedmuwen kowe, binangke kubi darewoob keruwen kii! ");
INSERT INTO yon_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Kibik aron kee Yarimanbed ongmoon, kowe nub kuu kuye dowad kubenub dowakeniib kamem. ");
INSERT INTO yon_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","O Yariman, nub kuu arewa yaa burudande binde. O Yariman, nub kuu ongmebko yiminmo doberem. ");
INSERT INTO yon_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Karub kane ye kuu Yariman yaningko yaambed mananeen kuu ye yaa amun kerunok. Kuye karub kuu Yariman yambib yaa doruub kumbed amun kerunduub kii. ");
INSERT INTO yon_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Yariman kuu God, kwane yembed nambiri ongmoona nub ari yurendoon. Yiib dingki aom kuu ambuudiib awingkenib, God yaa kubi dowad nedbe God yaa koni ye bot wuubimbon yaa daane weniibdan yoom dabokne winime. ");
INSERT INTO yon_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Eb kuu ne God, kwane eb yaa eso andaniin. Eb kuu ne God, kwane ewaningko kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Yariman kuu amun kowe, ye yaa eso andem. amborom kuu ye womoniiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Alef Kaneya yi kuu yi dobiri kerekmen kuu demkoronmo kuu amun kerundoon, Yariman ye amob awine kandi kerekmen yaambed doriibdan kui. ");
INSERT INTO yon_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Kaneya yi kuu ye kerekmen korokboon ye weng yaa awine kande doriib kuu amun kerundoon, yi meeni inamen kumundin kumbed ye ande onmiibdan kui. ");
INSERT INTO yon_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Yi kuu angkon unitab ye inamen yaa ma awinimokban kerenib ye kiwaan arimo weniib kui. ");
INSERT INTO yon_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Ebbed eb kongamki yamob dakme nongkobewen kuu, nubbed korem awine kande amukni dowad. ");
INSERT INTO yon_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Ne dowaken darewoob kuu ne inamen kuu kangdommo kerok, ebbed wongkewen yamob awine kandi dowad. ");
INSERT INTO yon_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Ebbed kwanime andi ye weng ongmewen kuu andangke meenaniin kuu ne kuu karak bobni yaa nen kowaibban. ");
INSERT INTO yon_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Ne kuu eb wengyundi yorokmo yaa kaadkeraniin kuu ne niindem aom kangdommo kereni eb yaa eso andaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Ne kuu ebbed wongkewen yamob awine kandaniin, ne kuu kumundin domowaab. Bet ");
INSERT INTO yon_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Kewedman kuu komarewa kere ye dobiri kerekmen kuu karadmo keraneen? Ye kuu eb weng yaambed dobaraneen kumbed kii. ");
INSERT INTO yon_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Ne kuu ne niindem aom kumundin kumbed eb ande onmiin, domowaawe ebbed kwanime andi ye weng kuu domonene kimyen wanain. ");
INSERT INTO yon_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Eb weng kuu kube ne niindem aom awine amuknaan, eb yaa ambarakmain andi dowad. ");
INSERT INTO yon_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","O Yariman, amun kerundi kuu eb yaa angkeen, ebbed wongkewen yamob kuu kedmengkawe. ");
INSERT INTO yon_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Eb mongkodkonombed dakmewen yamob korem kuu nembed dakmenabaan. ");
INSERT INTO yon_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Yiribman yemoon kai ye karubbed ye yiribman yaa kubemoon areb kuu eb kerekmen korokbewen ye weng awine kandi yaa kubaan. ");
INSERT INTO yon_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Ne kuu eb kongamki yamob kuu kube meendobeni, eb dobiri kerekmen yaa kuu andangke meendobaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Ne kuu ebbed wongkewen yamob yaa kubaniin, kwane eb weng kuu nonondandainban. Gimel ");
INSERT INTO yon_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Eb dememan ne yaa amun amun kamewe. Kwananeeb kuu wad dobereni eb weng awine kande dobaraniin. ");
INSERT INTO yon_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Ne indob nandebko manimanandeb ye weng eb amob aom kuu wedmenaba. ");
INSERT INTO yon_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Ne kuu okad kari kee norod karub kowe, ebbed kwanime andi ye weng kuu ne yaa biknewaab. ");
INSERT INTO yon_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Ne kuu ebbed dakmewen ye amob yaa moom dowakeniib kowembirimain kowe, ne niindem aom kuu yewed aneen. ");
INSERT INTO yon_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Kerengkandan kuu butun kamendewen, yi yaa kuu ongkandimaab, kwane yi kuu ebbed kwanime andi ye weng yaa koronde kimyen winimaib. ");
INSERT INTO yon_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Ne kuu eb kerekmen korokbewen ye weng yaa awinaan kowe, damangkawidaniib ne yaa daawidaniib ne yaa kuu ben kiradme. ");
INSERT INTO yon_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Korok korok kuu nedbe diberenib ne yaa wengamborokbanabimaib kuned, eb dememan ne kuu ebbed wongkewen yamob yaa kube meendobembirimain. ");
INSERT INTO yon_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Eb kerekmen korokbewen ye weng kuu dowaken darewoowiib keraan, kuye weng kuu ongkande inamen yaa awandidan areb. Dalet ");
INSERT INTO yon_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Ne kuu nen okad yiri kankubunoon kowe, eb weng yaambed ne nen ongmebko wadkera. ");
INSERT INTO yon_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Ne dobiri kerekmen dakmaana ebbed inanduwewen, ebbed wongkewen yamob kedmengkawe. ");
INSERT INTO yon_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Eb kongamki yamob ye kerekmen kedmengkawebko kaadkera, kwananeeb kuu binangke eb yaa anam andi yeman yaa kuu kube meendobaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Ne niindem aom kuu mimyob wandaan kumbed wuud kere wanaan, eb weng yaambed aromkono kawe. ");
INSERT INTO yon_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Birandi ye inamen ne meeni aom angkeen kuu kankorare. Ne yaa kuu amun kame eb amob kedmengkawe. ");
INSERT INTO yon_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Ne kuu inamen ongmeni ma korondiyiibban weng awini kerekmen yaambed doriin, ne kuu ebbed dakmewen ye amob awine kanda andaan. ");
INSERT INTO yon_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Eb kerekmen korokbewen ye weng kuu kamkonomo awinaan, o Yariman, ne kuu nen karak ari kowaab. ");
INSERT INTO yon_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Ebbed kwanime andi ye weng ye kiwaan arimbed dodkanmo weniin, amborom kuu ne yaa kuu inamen kaadkeri ariyiib kawewen kowe. He ");
INSERT INTO yon_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","O Yariman, ebbed wongkewen yamob awini ye kiwaan kedmengkawe. Kwananeeb kuu kuyamob kuu awine kande dobaraniine wene yimin wandaneen. ");
INSERT INTO yon_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Ne yaa inamen kaadkeri kankawebko eb amob wengambere awineni ne niindem aom kumundin kumbed awine kanda. ");
INSERT INTO yon_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Ne onmewebko ebbed kwanime andi ye weng kerekmen ye kiwaan arimbed dodkanmo wana, amborom kuu kuyaa kuu kubi dowakeniib kerimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Eb kerekmen korokbewen ye weng yaa kuu ne mimyob nenduneb amonombe ari kowe. Ne kuu ongmewebko kirim ye inamen kuu koronda. ");
INSERT INTO yon_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Kerengkan keri ye kumkam yaa kuu ne indob kuu kiwaan kimyen yaa nen kowe. Eb kerekmen yaa dobiri ye inamen ika kawebko awine aromna. ");
INSERT INTO yon_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Eb dememan ne yaa ebbed weng kunduk kowewen kuu kwane awine. Kwananeeb kuu une bumangki ye inamen kuu darewoob keraniin. ");
INSERT INTO yon_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Yi damangkawi weng yaa wengambere unaan kuu kankorare, amborom kuu ebbed dakmewen ye amob kuu amun kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Kedi, eb kongamki yamob yaa kuu moom dowakeniib kowembirimain kii, Eb yorokmo kerekmen yaambed ne kuu ongmewebko wadkera. Waw ");
INSERT INTO yon_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","O Yariman, eb womoniyiibban ye mimyob dowaken kuu ne yaa monok. Eb weng kunduk yaambed ne kuu arewa yaa burudande nende. ");
INSERT INTO yon_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Kwananeeb kuu damangkawi ye karub yaa inandunaniin, amborom kuu eb weng yaa angkumone doriin kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Ne kuu ebbed dakmewen ye amob yaambed kwananeen ande yedmaan kowe, eb amob ne mongkodkono ari angkeen kuu bingewande kanwanaab. ");
INSERT INTO yon_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Kowe ne kuu eb amob yaamo awine kamembaraniin, aron korem korem. ");
INSERT INTO yon_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Kwane ne kuu obonmo aombed wananiin, amborom kuu eb kongamki yamob awine dobiri kerekmen onmimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Ne kuu eb kerekmen korokbewen ye weng kangkon kingdan yaa dakmendaniin, kwananiin kuned karak kandainban. ");
INSERT INTO yon_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Kwane ne kuu ebbed kwanime andi ye weng yaa kubi dowakeniib kerimain, amborom kuu ne inamen mimyob korem kuu kuyaa kowaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Ebbed kwanime andi ye weng kuu barang darewoob ande kankoonimain, kuyamob kuyaa kuu ne inamen mimyob korem kowaan, kwane ne kuu ebbed wongkewen yamob kuu kube meendobembaraniin. Zayin ");
INSERT INTO yon_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Eb weng kunduk eb dememan ne yaa kawewen kuu ika meene, amborom kuu ebbed ne yaa kuu ari kwananeen andi ye inamen kawewen kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Ne dabab kandaan yaa mimyob wandi kankubuni yeman kukei, eb weng kunduk yaambed ongmeweewa wadkeraan. ");
INSERT INTO yon_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Kerengkandanbed ne yaa kuu naawonmo damangkawimaib, kumban ne kuu eb amob yaa koronde kimyen winimokban. ");
INSERT INTO yon_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","O Yariman, eb amob unyeman anukbed dakme nongkobewen kuu ika meenaan, kowe ne mimyob wandi kuu kankubunoon. ");
INSERT INTO yon_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Arewa kamenabidanbed eb amob yaa wunekariwen kuyaa kuu amot denemoon areb yi yaa naawonmo kongendaan. ");
INSERT INTO yon_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Ebbed wongkewen yamob kuu ne yook kii, okad kari kee norod doriin yaron aombed kui. ");
INSERT INTO yon_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","O Yariman, amnoom kuu ewaningko yaa ika meenimain, kwane eb amob awine dobaraniin. ");
INSERT INTO yon_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Ne kwane awine dobara andi ye weng kukei, eb kongamki yamob kuu awine kandimain. Het ");
INSERT INTO yon_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Yariman, ne dobiriyiib yumboniib kuu ebbed ongmewen. Ne weng kunduk ongmaan kuu eb weng awine kandembara andaan. ");
INSERT INTO yon_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Ne niindem aom kumundin kumbed eb kubi dowaken kuu ne yaa keewe. Eb weng kunduk yaambed kabamon kondewen ye mimyob dowaken keewe. ");
INSERT INTO yon_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Ne dobiri kerekmen yaa andangke meendobaan kowe, amonombeni eb kerekmen korokbewen ye weng ye yoman dodkanmo weniin. ");
INSERT INTO yon_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Ne kuu erebnarainban nindorokiibbed ebbed kwanime andi ye weng awine kandaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Arewa kamenabidanbed ne kuu nen nongbed yerengkaniib kuu ne kuu eb amob nonondandainban. ");
INSERT INTO yon_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Ebbed dakmewen ye amob kuu yorokmo kowe, amnomnom yaambed yeedereni eb yaa eso andaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Ne kuu eb yaa unimaibdan yaa angkodmendimain, eb kongamki yamob awinimaibdan kangkon angkodmendimain. ");
INSERT INTO yon_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","O Yariman, okad kari kee eb womoniyiibban ye mimyob dowaken kuu derendaroon. Ebbed wongkewen yamob kuu kedmengkawe. Tet ");
INSERT INTO yon_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Eb dememan ne yaa kuu amunmo kamenabewen, o Yariman, eb weng yaambed kwane kamewen kui. ");
INSERT INTO yon_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Ebbed kwanime andi ye weng yaa anam andaan kowe, andangki amuniib inamen kaadkeriyiib kedmengkawe. ");
INSERT INTO yon_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Dabab ne yaa minindo yaron anuk kuu ne kuu kimyen wanaan, kumban kibikee ne kuu eb weng awine kandimain. ");
INSERT INTO yon_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Eb kuu amun, angkon eb kuu amunmo kamenabimaab, kowe ebbed wongkewen yamob kuu kedmengkawe. ");
INSERT INTO yon_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Kerengkandanbed ne dowad dudanabi weng dakmiwen kuned, eb kongamki yamob kuu ne niindem aom kumundin kumbed awingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Yi niindem aom kuu kamkonomo, kumban ne kuu eb amob yaa kubi dowakeniib kowaan. ");
INSERT INTO yon_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Dabab ne yaa monoon kuu amun, amborom kuu kuyaambed ebbed wongkewen yamob kedmengkawoon kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Eb mongkodkonombed dakmewen yamob kuu miin manimanandeb andaan, od gold tausen yemooniib od silvaa tausen yemooniib arebban. Yod ");
INSERT INTO yon_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Ne kuu eb dingkimbed ongmewen, kwane ebbed ne id kuu wuub nimingkewen, kwane ebbed inamen kaweebkob ebbed kwanime andi ye weng kuu nekaadkeraan. ");
INSERT INTO yon_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Ne kuu eb weng yaambed anam kwananeen ande meedme doriin kowe, eb yaa unimaibdan kuu ne yaa wedmewenib kubime. ");
INSERT INTO yon_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","O Yariman, nekaad eb wengyundi weng kuu yorokmo kii, kwane eb ma korondiyiibban weng awini ye kerekmen yaambed eb kuu ne yaa didangke dabab kawewen. ");
INSERT INTO yon_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Eb dememan ne yaa weng kunduk kowewen yaambed kwane ambangkoko, eb womoniyiibban ye mimyob dowaken kumbed ne mimyob wandi kankubunok. ");
INSERT INTO yon_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Eb amob yaa kubi dowakeniib keendimain kowe, mimyob keewebko wad dobara. ");
INSERT INTO yon_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Kerengkandanbed ne dowad dudanabi weng dakmimaib kumbed ne yaa ambarakmimaib kowe, ebbed yi yaa karak konde. Kumban ne kuu eb kongamki yamob yaa kube meendobaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Eb yaa unimaibdan kuu neyiib yaa minime, eb kerekmen korokbewen ye weng yikaaddan kui. ");
INSERT INTO yon_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Ebbed wongkewen yamob yaa kuu ne niindem aom ambarakmiyiibban kerok, kwananeen kuu ne kuu nen karak ari kowaibban. Kaf ");
INSERT INTO yon_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Ebbed arewa yaa burudande nendi dowad ne niindem aom kuu moom dowakeniib koweni miin yiminban keraan, kumban eb weng yaa kwananeeb ande kowaan kii. ");
INSERT INTO yon_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Ne kuu eb weng kunduk yaa kwanok ande onmoni nindob yidnoon, kwane yedmimain, “Komo aron arimbed ne mimyob wandi kuu kankubunaneeb?” andimain. ");
INSERT INTO yon_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Ne kuu wain ok yeman ba kadbed ongmiwen amareng aom angkemoon areb keraan kumban, ne kuu ebbed wongkwewen yamob yaa nonondandainban. ");
INSERT INTO yon_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Eb dememan ne kuu aron komoyiib kwane meedmaniin? Komo aron arimbed ebbed ne nenbandimaibdan yaa kuu ukum kondaneeb? ");
INSERT INTO yon_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Kerengkandanbed ne kombiri dowad dem nidkanabiwen, kowe eb amob dookbiwen. ");
INSERT INTO yon_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Ebbed kwanime andi ye weng korem kuu angkumone dori yeman. Karub kuu dudanabe nenbandimaib kowe awawe. ");
INSERT INTO yon_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Yimbed okad kari kee ne kuu monmarok andiwen, kumban ne kuu eb kongamki yamob yaa ma wunekarindo. ");
INSERT INTO yon_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Eb womoniyiibban ye mimyob dowaken yaambed ongmewebko wadkera. Kwananeeb kuu eb kerekmen korokbewen ye weng ebbed dakmewen kuu awinaniin. Lamed ");
INSERT INTO yon_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","O Yariman, eb weng kuu aron korem kwane angkimbaraneen, eb weng kuu Ewen aombed kangdommo awine angkeen. ");
INSERT INTO yon_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Eb ma korondiyiibban weng awini kerekmen kuu nimakarub yaro dobere dobere yaro wananiib korem aom kwane angkimbaraneen. Ebbed okad kee ongmeneb yumbon koweewa, kwamunemo angkimbureen. ");
INSERT INTO yon_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Kumkam korem kuu ebbed dakmewen ye amob yaambed kwane dangoon, amborom kuu kumkam korem kuu eb deme yeman kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Ne kuu eb amob yaa kubi dowakeniib kerindo karen, dabab ne yaa monoon kumbed bobnaan karen. ");
INSERT INTO yon_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Eb kongamki yamob kuu ma nonondandainban, amborom kuu kuye amob yaambed ebbed ongmeweewa wadkeraan. ");
INSERT INTO yon_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Ne kuu ebman kowe, ne kuu arewa yaa burudande nende, amborom kuu eb kongamki yamob awine dobiri kerekmen onmimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Miin arewa kamenabidan kuu ne neene monmarem ande meedmiib, kumban ne kuu eb kerekmen korokbewen ye weng yaa andangke meendobaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Nembed kumkam korem wedmaan kuu ye yiminiibmo kii, kumban ebbed kwanime andi ye weng kuu ye yiminiibban kii. Mem ");
INSERT INTO yon_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","O, eb amob kuu mimyob dowaken darewoob kerimain kii! Aronki doboob kuu kuyaamo meenme andangkembirimain. ");
INSERT INTO yon_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Ebbed kwanime andi ye weng awinaan kumbed meeni kangdom keraan, ne bondan arebban, kedi, kuye weng kuu kwane awinembirimain kii. ");
INSERT INTO yon_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Eb kerekmen korokbewen ye weng yaa kube meendobimain kowe, inamen niindem aom andangke bi kerekmen arimbed kandaan, ne kedmengkawiibdan arebban. ");
INSERT INTO yon_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Eb kongamki yamob awine kandaan kowe, inamen kaadkeri arimbed kandaan, aamkono aamkono arebban. ");
INSERT INTO yon_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Ne kuu arewa kami ye kiwaan kuu ma wanain ande wunekaraan, eb weng awine kandi dowad. ");
INSERT INTO yon_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Ne kuu ebka kedmengkawewen kowe, ebbed dakmewen ye amob yaa kuu doombere angkanindo. ");
INSERT INTO yon_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Eb weng ambod ne kandaan kuu maa kai kii, ne mongkodkono aom kuu in ye ambod kuu burudande arimbed keroon! ");
INSERT INTO yon_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Eb kongamki yamob yaabed inamen kaadkeri kandimain, kwanekob ne kuu abdon kami kiwaan korem yaa kuu dowakenban odkenebmo kerimain. Nun ");
INSERT INTO yon_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Eb weng kuu lem areb ne yonbed amunmo dodkan wini yaa nambiri yeman, eb weng kuu ne kiwaan yaa nambiri yeman kui. ");
INSERT INTO yon_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Ebbed dakmewen ye amob yorokmo kuu awina ande kowaan, nangkon ee anam kwane awinaniin andaan. ");
INSERT INTO yon_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Ne kuu durud yewed yemoon kandaan, o Yariman, eb weng yaambed ongmewebko wadkera. ");
INSERT INTO yon_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","O Yariman, ewaningko kankooni weng nindorokiibbed dakmaan kuyaa kuu ee yimin ande. Kwane ebbed dakmewen ye amob kuu kedmengkawe. ");
INSERT INTO yon_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Ne kuu arudbon aom awunimain kuned, eb amob nonondandainban. ");
INSERT INTO yon_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Miin arewa kamenabidan kuu ne dowad yi kawaad nong kowiwen kuned, ne kuu eb kongamki yamob yaa domonde kimyen winindo. ");
INSERT INTO yon_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Eb kerekmen korokbewen ye weng wengambere aron korem awini ye yumbon kandaan, kuye weng kumbed ne niindem aom kubi darewoob kerunimaan. ");
INSERT INTO yon_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Ebbed wongkewen ye amob kuu awine kanda ande nekwaan, aron korem, kwane wene yimin wandi yimin yaamo keraniin. Samek ");
INSERT INTO yon_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Aadidmidan kuu naawonmo kongendimain, kumban eb amob yaa mimyob dowaken kowaan. ");
INSERT INTO yon_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Eb kuu ne biknimbon kere ne kombe kii, eb weng yaambed kwananeeb ande meedmiin. ");
INSERT INTO yon_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Miin arewa kamenabidan, ne yaa angkanime, kwananiib kuu ne Godbed kwanime andi ye weng kuu awinaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Eb weng kunduk yaambed angkumone awawebko ne kuu doberembara, kwanebko ne kwananeeb andi kuu kombere monmarain. ");
INSERT INTO yon_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Ne kuu ebbed wongkewen yamob yaa amun andi dowad angkumone awawe. Kwananeeb kuu arud ye barangbed ne kuu ma monmaraanban. ");
INSERT INTO yon_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Ebbed wongkewen yamob yaa domonde kimyen winimaibdan kuu ebbed wunekarundimaab, amborom kuu yi birandi kuu dawangmo kaimaib kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Okad kiri miin arewa kamenabidan kuu ebbed kemengkod aremoon areb kerewen, kwanekob ne kuu eb kerekmen korokbewen ye weng kuu mimyob dowaken kowimain. ");
INSERT INTO yon_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Eb yaa uneni ne id kumundin kiringmimain, kwane eb wengyundi yaa unimain. Ayin ");
INSERT INTO yon_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Ne kamenabaan kuu yorokmo anammo kerekmen yaambed kwamaan, kowe ne kuu ne bondan yaa nen kondaab. ");
INSERT INTO yon_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Eb dememan ne yaa kuu amun amun kamebdaniin ande kowe. Korondaawa kerengkandanbed ne yaa dabab wayiraib. ");
INSERT INTO yon_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Ebbed ne kuu arewa yaa burudande nende ande onmoni nindob yidnoon, kwane eb weng yorokmo yaa kangkon kwanimain. ");
INSERT INTO yon_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Eb dememan ne yaa kuu eb womoniyiibban ye mimyob dowaken yaambed kame. Kwane ebbed wongkewen yamob kuu kedmengkawe. ");
INSERT INTO yon_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Ne kuu eb dememan, inamen kaadkeri kankawe, eb kerekmen korokbewen ye weng nekaadkeri dowad. ");
INSERT INTO yon_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","O Yariman, kuned kuu ebbed ambangki yaron kii, amborom kuu eb amob domabangkaib kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Anamaa, ebbed kwanime andi ye weng kuu mimyob dowaken kowaan, bot gold arebban, bot gold yankorenmo arebban kui. ");
INSERT INTO yon_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Kwanekob, inamen korem yaa kuu eb kongamki yamob kuu yiminmo ande wedmaan, kowe dudanabi kiwaan korem yaa kuu naawonmo kongendimain. Pe ");
INSERT INTO yon_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Eb kerekmen korokbewen ye weng kuu manimanandeb amun kai, kowe ne kuu kwane awine kandimain. ");
INSERT INTO yon_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Eb wengbed ambobimaan kuu nambiri kondimaan, kwane eb weng kuu mengmengiibban iwari doriibdan yaa inamen kaadkeri kondimaan. ");
INSERT INTO yon_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Eb weng dowad ne mongkod daande moom kowembirimain, amborom kuu ebbed kwanime andi ye weng yaa moom dowakeniib kowembirimain kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Ne yaa murubia kaweneb ne yaa mimyob keewe kakman are nonondande. Eb yaa mimyob dowaken keebdimaibdan yaa komo kamimaab kuu ne yaa kwamunemo kame. ");
INSERT INTO yon_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Eb weng yaambed ne yon dodkanmo wini kerekmen yaa kangkadmewe. Korondaawa ambarakmimbed ne yaa ma oone dobaraan. ");
INSERT INTO yon_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Karubbed ne yaa dabab kawembiri yaa kuu ne nen bidde obon kowe. Kwananeeb kuu eb kongamki yamob awine kandaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Eb dememan ne yaa kuu kubi dowakeniib keewe amun keruwe. Kwane ebbed wongkewen yamob kuu kedmengkawe. ");
INSERT INTO yon_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Nimakarub kuu eb amob kuu awine kandokban kowe, ne indob inok kuu ok mana areb menebimaan. Tsadhe ");
INSERT INTO yon_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","O Yariman, eb kuu yorokmo, kwane eb wengyundi kuu kangdommo. ");
INSERT INTO yon_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Eb kerekmen korokbewen ye weng kowewen kuu yorokmo, kuye weng kuu angkumone dobiri yeman kumbedmo. ");
INSERT INTO yon_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Ne bondan kuu eb weng wunekare nonondandiwen kowe, anam ambarakmiwen kii ande ne niindem aom denobeen. ");
INSERT INTO yon_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Eb weng kuu karadmo, kowe eb dememan ne kuu kuyaa mimyob dowaken kowimain. ");
INSERT INTO yon_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Ne kuu yiri mana kere kwane akmendandiwen, kuned eb kongamki yamob kuu nonondandainban. ");
INSERT INTO yon_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Eb yorokmo kerekmen kuu aron korem korem yeman, kwane eb amob kuu anammo. ");
INSERT INTO yon_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Dabawiib durud yewediib ne ari meneboon, kumban ebbed kwanime andi ye weng yaa kuu kubi dowakeniib kowaan. ");
INSERT INTO yon_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Eb kerekmen korokbewen ye weng kuu aron korem yorokmo yeman, inamen kaadkeri kuu kawebko wad dobara. Kwof ");
INSERT INTO yon_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","O Yariman, ne niindem aom kumundin kumbed eb yaa baandaan kowe inanduwe. Ne kuu ebbed wongkewen yamob awine kandaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Ne kuu eb yaa baandaan kowe, ne kuu arewa yaa burudande nende. Ne kuu eb kerekmen korokbewen ye weng awine kandaniin. ");
INSERT INTO yon_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Ne kuu warindombed yaro dembeni eb yaa awawe ande baandimain, eb weng yaambed kwananeeb ande meedmiin. ");
INSERT INTO yon_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Eb weng meenme andangki dowad ne kuu amki unuk angkimokban. ");
INSERT INTO yon_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Eb womoniyiibban ye mimyob dowaken yaambed ne weng wengambere. O Yariman, ebbed dakmewen ye amob yaambed ongmewebko wadkera. ");
INSERT INTO yon_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Inamen arewa ongmenib ne nenbandande kamiibdan kuu ne dia keriwen kii, kumban yi kuu eb amob yaa ambab angka doriib. ");
INSERT INTO yon_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","O Yariman, eb kuu ne dia, kwane ebbed kwanime andi ye weng korem kuu anammo. ");
INSERT INTO yon_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Unyeman anukbed ne kuu eb kerekmen korokbewen yaambed nekaadkeraan kuu, ebbed kuye weng kuu aron korem kwane angkimbiri yeman ongmewen. Res ");
INSERT INTO yon_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Dabab ne yaa monoon kuyaa wedmeneb ne nen burudande angka kowe, amborom kuu eb amob kuu ne nonondandimokban kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Ne dowad koromoni weng nekweneb ne kuu bidde. Eb weng yaambed ongmewebko wadkera. ");
INSERT INTO yon_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Arewa kamenabidan kuu arewa yaa burudande bindi kerekmen yaa ambab angka doriib, amborom kuu ebbed wongkewen yamob awine dobiri kerekmen onmimokban kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","O Yariman, eb mimyob keende kakman are nonondandi kerekmen kuu miin darewoob arimbed, ebbed dakmewen ye amob yaambed ongmewebko wadkera. ");
INSERT INTO yon_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Ne yaa dabab kawidaniib ne bondaniib kuu yemoon, kuned ne kuu eb kerekmen korokbewen ye weng yaa kuu koronde kimyen winimokban. ");
INSERT INTO yon_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Koyabdan yaa kuu wedmendekori komyeng areb kerimain, amborom kuu yi kuu eb weng awinimokban kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Eb kongamki yamob yaa mimyob dowaken kowimain kuu wedme. O Yariman, eb womoniyiibban ye mimyob dowaken yaambed ongmewebko wadkera. ");
INSERT INTO yon_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Eb weng korem kuu anammo, kwane ebbed dakmewen ye amob yorokmo korem kuu aron korem kwane angkimbaraneen. Sin ");
INSERT INTO yon_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Korok korok kuu idiibbanbed ne yaa nenbandimaib, kumban ne kuu eb weng yaa binangke une kuu anammo kii andimain. ");
INSERT INTO yon_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Ne kuu eb weng yaa kubimain, odamod miin darewoob wedme kandoon ye karub areb kerimain. ");
INSERT INTO yon_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Ne kuu dudanabi yaa naawonmo kongendeni komyeng areb kerimain, kumban ne kuu eb amob yaa mimyob dowaken kowimain. ");
INSERT INTO yon_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Ne kuu aronki mimo aom kuu ewaningko kankoone ediib kerimain, ebbed dakmewen ye amob yorokmo ye dowad. ");
INSERT INTO yon_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Eb amob yaa mimyob dowaken kowimaibdan kuu yewenub darewoob kai kondimaab, kwane yi kuu komo yaambed ma boknande kombaraibban kii. ");
INSERT INTO yon_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","O Yariman, ebbed nende burudande angka kowi kuu ne yaa monok ande meedmiin, kwane ne kuu ebbed kwanime andi ye weng yaambed kwane ambangkimain. ");
INSERT INTO yon_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Eb kerekmen korokbewen ye weng kuu awine kandimain, kuyaa kuu mimyob dowaken miin darewoob kowimain. ");
INSERT INTO yon_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Ne kuu eb kongamki yamowiib eb kerekmen korokbewen ye wengiib awine kandimain, amborom kuu ne dobiri kerekmen kumundin kuu ebkaadmo kowe. Taw ");
INSERT INTO yon_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","O Yariman, ne baandi kuu wengambere. Eb weng yaambed inamen kaadkeri kuu kankawe. ");
INSERT INTO yon_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Ne kaamoni kuu wengambere. Eb weng yaambed ne kuu arewa yaa burudande nende. ");
INSERT INTO yon_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Ne mongkodkono kuu ewaningko kankooni wengbed diire darewoob kerok, amborom kuu ebbed wongkewen yamob kuu kedmengkawimaab kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Eb weng dowad yook wingka, amborom kuu ebbed kwanime andi ye weng korem kuu yorokmo kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Ne awawi dowad eb dingki kuyaa kowe, amborom kuu eb kongamki yamob kerekmen yaa kine kowaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","O Yariman, ne kuu ebbed ne nen arewa yaa burudandi yaa kuu moom dowakeniib kowimain, kwane eb amob yaa kuu kubi dowakeniib kowimain. ");
INSERT INTO yon_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Korondebko ewaningko kankooni dowad dobara, kwane ebbed dakmewen ye amob kuu ne yaa awawok. ");
INSERT INTO yon_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Ne kuu sibi biknemoon areb awerendobenmo yarebiin kowe, eb dememan ne dowad mene kerekne onme, amborom kuu ne kuu ebbed kwanime andi ye weng kuu ma nonondandimokban kowe. ");
INSERT INTO yon_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Daane kawini ye yook. Ne yaa dabab monoon kumbed Yariman yaa baandaane, yembed inanduwoon. ");
INSERT INTO yon_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","O Yariman, dudanabi mongkodkonoiib birandi ongiib yaa kuu ne nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","O birandi ye karub, eb yaa kuu Godbed komo kamebdaneen? Angkon eb yaa kuu ariyiib komo kamebdaneen? ");
INSERT INTO yon_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Yembed eb yaa kuu ana nangmi ye karub ye ana yidkangiibbed ukum kabdaneen, kwane nimin darewoowiib ye amoyidkowiibbed kangkon ukum kabdaneen kii. ");
INSERT INTO yon_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Ne kuu ambibkin Mesek aombed norod doriin kowe, mimyowiiwee! Kedi, ne kuu Kedaadan yi ambib kombon kidangka dobaraan, kuu mimyowiiwee! ");
INSERT INTO yon_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Yewenub keri kerekmen yaa odkeneb kamidan yoom kuu aronki yemoon kai dobaraan. ");
INSERT INTO yon_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Ne kuu iwari yewenub dobiri ye karub, kumban yewenubmo doberem andimain kuu yimbed ana nangmem andimaib. ");
INSERT INTO yon_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Daane kawini ye yook. Ne awawi kuu kuna yaambed mananeen ande kaamoneni, ne indob kankoone aangko aangko ari kereknain kii. ");
INSERT INTO yon_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Ne awawi kuu Yariman yaambed minimaan, Eweniib okadiib ongmenaboonman yaambed kui. ");
INSERT INTO yon_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Ye kuu eb domobdaana kereeb beredare kombaraabban, kwane eb yaa oonebdimaanman kuu unuk angkaanban. ");
INSERT INTO yon_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Kedi, Israeldan yaa oonendimaanman kuu unuk angkimokban no kwane kerekbere doberembirimaan. ");
INSERT INTO yon_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Yariman kuu eb yaa oonebdimaanman, kwane Yariman kuu eb nen dorondarimaanman. ");
INSERT INTO yon_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Aronki kuu aronbed ma aunban, kwane amki kuu woodbed kangkon ma aunban. ");
INSERT INTO yon_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Yarimanbed eb kuu nen amukmo biknaneen kowe kumkam maambed aanban, kwane eb wadkeri yaa kuu oone kerenombaraneen. ");
INSERT INTO yon_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Yarimanbed eb menebiyiib wenebiyiib kuu kibikbed wene aron korem kwane oone keebdombaraneen. ");
INSERT INTO yon_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Daane kawini ye yook Dewidbed wongkoon. “Yariman yambib yaa wenem.” anduwiwen kuu ne kuu kubi darewoob keraan. ");
INSERT INTO yon_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","O Yerusalem, kibireb kee nub kuu kub kuuk ambongko aom doruub. ");
INSERT INTO yon_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Yerusalem siti yenbiwen kuu kande kobkokmo kande daboknenib yenbiwen. ");
INSERT INTO yon_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Israeldan yi amyenimbon korem kuu kumaom daane winimaib, Yariman ye amyenimbon kui. Yi kuu Yariman yaa eso andande daane winimaib, Israeldan yi dowad amob weng ongmoon yaambed. ");
INSERT INTO yon_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Kedi, kwarimbed dibere wengyundimbon kuu dangoon, Dewid ye awoya arimbed dibere oonimbon kui. ");
INSERT INTO yon_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Yerusalem aom iwari yewenubmo keri dowad kurikuri kerime, kekane yedmime, “Kane kane kub yaa mimyob dowaken kowimaib yaa kuu yiminmo kerundok. ");
INSERT INTO yon_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Kub siti kuuk aom kuu iwari yewenuwiib kerok. Kub korok korok yi ambibbon aom kuu yiminmo dobiriyiib kerundok.” andime. ");
INSERT INTO yon_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Ne karubkimiib nangkodmiayiib yi dowadbed kwane dakmaniin, “Kub aom kuu iwari yewenubmo kerok.” andaniin. ");
INSERT INTO yon_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Yariman nub God ye ambib ye dowadbed ne kuu kub yiminmo dobere andi kiwaan onmaniin. ");
INSERT INTO yon_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Daane kawini ye yook. O Ewen arimbed dibere oonimaabman, eb yaa ne indob kankoonimain. ");
INSERT INTO yon_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Kedi, dabderem yiri dobere deme awinembiridan kuu nub yaa awande bangkandok andenib yi kangkoman yaa wedme meedmimaib areb, o dabderem yiri dobere deme awinimbiri ye wonong kuu ne yaa awawe kawe andenu yu kangko wonong yaa wedme meedmimaun areb kuu nub kangkon Yariman nub God yaa wedme meedmimaub, kee kwananuuwe yembed mimyob keende awandaneen kumbed. ");
INSERT INTO yon_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Nub yaa mimyob keende awande, o Yariman, nub yaa mimyob keende awande, amborom kuu nub yaa kuu yemoonbed daandi yeman kerundiwen kowe. ");
INSERT INTO yon_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Nub yaa kuu kerengkandanbed damangkandi weng yemoon kamendiwen, nubbedmo yimin andidanbed nub kuu daandi yeman kerundiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Daane kawini ye yook Dewidbed wongkoon. Israeldan kuu kekane yedmime, “Yariman kuu nub kerekmen yaamban karen.” andime. ");
INSERT INTO yon_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Kedi, kekane yedmime, “Karub kuu nub yaa bon keriwen kumbed Yariman kuu nub kerekmen yaamban karen, ");
INSERT INTO yon_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","yimbed nub kuu wad ben anukmungkemoon areb keriwen karen, yimbed nub yaa norin wandiwen kuyaron kui. ");
INSERT INTO yon_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Kukuu urokbed nub ben yukneen areb keroon, kukuu ok awaanbed nub ben dabune kebenendeen areb keroon kui. ");
INSERT INTO yon_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Kukuu ok arud darewoobbed nub ben are dabune kebenendeen areb keroon kii!” andime. ");
INSERT INTO yon_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Yariman ye aningko kankoonem, yembed nub kuu domondoone wene bondan yi arud ningkambo ari ma kowindo kowe. ");
INSERT INTO yon_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Nub kuu ayari on areb bad karub ye kawaad unoon yaambed kombiri wenemoon areb keruwen. Kawaad kuu domokboon kowe, nub kuu obon keruwen kii. ");
INSERT INTO yon_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Nub awandi ye karub kuu Yariman, Eweniib okadiib ongmenaboon ye God kui. ");
INSERT INTO yon_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Daane kawini ye yook. Kane kane yi kuu Yariman yaa angkumone doriib kuu, aangko Saiyon areb keriwen, kiringmindeban ye aangko kui, kwane aron korem angkimbaranuun. ");
INSERT INTO yon_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Aangko aangkombed Yerusalem kanawanewandiwen areb kwamune kuu, Yarimanbed ye nimakarub kuu ben awanewandundoon, kibikbed kwane wene aron korem korem yeman kii. ");
INSERT INTO yon_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Kedi, yorokmodan yaa kondoon ye okad kuu arewa kamenabidanbed oonimaib kuu ben kiradmaneen. Mok arewa kamenabidanbed kwane oonaniib kuu yorokmodan kuu yi yorokmo kerekmen yaa kuu koronde arewa kamaniib manok. ");
INSERT INTO yon_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","O Yariman, amun kamenabidan yaa kuu amun amun kamende. Kwane kangdommo doriibdan yaa kangkon amun amun kamende. ");
INSERT INTO yon_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Kumban kane kane yi kuu kimyen wene inamen unitab awinimaib kuu Yarimanbed kuye arewa kamenabidan kuu ben kiradmaneen. Israel aom kuu iwari yewenuwiib kerok. ");
INSERT INTO yon_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Daane kawini ye yook. Nub kuu bondanbed benwiniwen kumbed Yarimanbed ikakman Saiyon yaa benmonoon kuu, nub kuu kiyuum wanabemoon areb kamuwen. ");
INSERT INTO yon_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Kedi, nub mongkod aom kuu ambonbed diiroon, kwane nub ong ari kuu kubi yookmo wingkanabuwen. Kwane ambibkin yenadanbed dakmiwen, “Yarimanbed yi yaa kuu kamenabi miin dareb dareb ambangkanaboon kii.” andiwen. ");
INSERT INTO yon_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Ee, Yarimanbed nub yaa kuu kamenabi miin dareb dareb ambangkanaboon kowe, nub kuu kubimo keruwen kii. ");
INSERT INTO yon_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","O Yariman, nub karubkim bondanbed benwiniwendan yena kangkon benmene. Amiibban ye amboon kiri am menenu ok kirodmo wenebimaun areb yi kuu benmenebko kirodmo menebime. ");
INSERT INTO yon_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Kaneya yi kuu kab kibenib inok wandaniib kuu, yi kuu kube baandenib id wandaniib. ");
INSERT INTO yon_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Kane ye kuu kibingki dowad yob benwenene inok wandimaan kuu, ye kuu kube baandene id wande andedme ben minimaan keraneen. ");
INSERT INTO yon_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Daane kawini ye yook Solomonbed wongkoon. Yarimanbed ambib kuu yenbokban keraneen kuu, ambib yenbidanbed yi deme kuu idiibban dawangmo keraniib. Yarimanbed siti kuu oone kerekborokban keraneen kuu, oone kerekbiridan yi kerekbiri kuu idiibban dawangmo keraniib. ");
INSERT INTO yon_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Ebka eb aromkonombed amkimo kai kuu yaro dembeneb, wad dobiri kerekmen dowad deme yobdoodmo ambangkembirimaab, kwane wene amnoom kai kerimaun kuu idiibban dawangmo, amborom kuu Yarimanbed kane yaa mimyob dowaken keenimaanman yaa kuu bangkanimaan, ye unuk angkoon yaron kangkon kwane bangkanimaan. ");
INSERT INTO yon_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Dana kuu Yariman ye kubi koni yeman, yi kuu kakman amun yembed kondimaan yeman. ");
INSERT INTO yon_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Karub kewed yaambed dana wanabimaan kuu ana nangmi ye karubbed awingkoon ye ana areb. ");
INSERT INTO yon_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Kwamune ye ana yemooniib keriwendan kuu amun kerundoon. Yi kuu kangdod yaa wananiib kuu yi bondanbed yi yaa karak kondaibban. ");
INSERT INTO yon_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Daane kawini ye yook. Yariman yaa unimaibdan korem kuu amun kerundoon, ye kiwaan ari weniibdan kui. ");
INSERT INTO yon_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Yiib kuu deme awiniwen ye id kuu yiibka ananiib, kwane yiib kuu amun kerundaneene yiminmo dobaraniib. ");
INSERT INTO yon_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Eb wonong kuu wain nong areb id yemoon irimaun, eb ambiwoom kuu. Kwane eb dana meed kuu olif maad areb yemoonmo kainaniib, eb arakbon kebed yaa kuu. ");
INSERT INTO yon_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Kedi, Yariman yaa unimaan ye karub kuu kwamunemo amun kerunaneen. ");
INSERT INTO yon_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Yariman kuu Saiyon angkambed amun kerubdok. Eb wad dobaraneeb ye aronki korem kuu wedmebko Yerusalemdan yiminmo dobiriyiib kerok. ");
INSERT INTO yon_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Anamaa, eb dana meed yi dana meed wedmaneeb kuu anam id kerok. Israel aom kuu iwari yewenuwiib kerok. ");
INSERT INTO yon_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Daane kawini ye yook. Israeldan kuu kekane yedmime, “Ne kewed yaambed mene kibikee yimbed dabab yemoon bangkawiwen.” andime. ");
INSERT INTO yon_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Kedi, kekane yedmime, “Ne kewed yaambed mene kibikee yimbed dabab yemoon bangkawiwen, kumban yi kuu ne yaa ma nangme burudande dorindo. ");
INSERT INTO yon_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Yimbed ne angkurom yaa kuu nong yikyikiibbed wangkanabiwen kumbed koodem areb kuburu doboob yemooniib keraan. ");
INSERT INTO yon_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Kumban Yariman kuu yorokmo, kedi, yembed kuye arewa kamenabidanbed ne nen yerengkiwen ye nong kuu nare burudande obon kawoon.” andime. ");
INSERT INTO yon_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Kaneya yi kuu Saiyon yaa arud wandembirimaib kuu, yi korem yaa karak kondene yenbandoko ikakman winime. ");
INSERT INTO yon_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Kwane yi kuu kereek ambib animari dembekore kirodmo nuubnoon kainindo areb kerime. ");
INSERT INTO yon_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Yi kuu wande bi ye karubbed kuyaa yob ma wedmindo kuye kereek areb kerime, kwane yi kuu wiit yob andedmi ye karubbed kuyaambed ma andedmindo kuye kereek areb kerime. ");
INSERT INTO yon_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Yi yaa dewenebe burudandandamiibdan kuu kekane yedmaib, “Yariman ye amun kerundi kuu yiib ari kowok, kwane Yariman yaningko yaambed yiib yaa amun kerunduub kii.” andaib. ");
INSERT INTO yon_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Daane kawini ye yook. O Yariman, ne miin yiminban keraan ye niindem aombed eb yaa baandaan. ");
INSERT INTO yon_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","O Yariman, ne weng kee wengamberewe. Eb kerendem kuu ne yaa kowe ne yaa mimyob keewe ande baandaan kuyaa wengambere. ");
INSERT INTO yon_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","O Yariman, eb kuu kekamune ambarakmi ye yuun awinaneeb keraneen kuu, o Yariman, kanembed ma wad doraanban keraneen kii. ");
INSERT INTO yon_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Kumban eb kuu ambarakmi are nonondandi kerekmeniib kowe, eb yaa unanuub kumbedmo yimin. ");
INSERT INTO yon_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Ne kuu Yariman ye awawi dowad meedmiin, ne inamen kumundiniib kumbed meedmiin kii, kwane ye weng yaambed kwananeen ande kowaan. ");
INSERT INTO yon_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Ne inamen kumundiniib kumbed Yariman ye awawi dowad nindorokiibbed meedmiin, amnoom oone kerekbiridanbed awawini waruk ande meedmimaib arebban, anamaa, amnoom oone kerekbiridanbed awawini waruk ande meedmimaib arebban. ");
INSERT INTO yon_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","O Israeldan, Yarimanbed kwananeen ande meedmime, amborom kuu Yariman kuu womoniyiibban ye mimyob dowakeniib kowe, kwane ye kuu yiminmo biddi ye karub. ");
INSERT INTO yon_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Yekareb yembed Israeldan kuu yi ambarakmi yaambed bidde baneen. ");
INSERT INTO yon_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Daane kawini ye yook Dewidbed wongkoon. O Yariman, ne niindem aom kuu kerengkan kerindo, angkon ne korok kankoone nembedmo yimin andokban, kwane ne burudande arimbed keriwendan inamen ongmiwen kuyaa kuu ne kuu ma wingkanambengkan kamindo, kwane ne inamen burudande arimbed keroon ye inamen kuyaa kangkon ne kuu ma wingkanambengkan kamindo. ");
INSERT INTO yon_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Anamaa, ne kuu nangkem kere iwari keraan, dana awaan yu muk koronde yu yaa yone iwari keremoon areb keraan, kuye dana areb ne inamen kumundin kuu iwari keroon. ");
INSERT INTO yon_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","O Israeldan, Yarimanbed kwananeen ande meedmime, kibikbed wene aron korem. ");
INSERT INTO yon_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Daane kawini ye yook. O Yariman, Dewid kuu ika meene. Yobdood wedmenaboon korem kuu ika meene. ");
INSERT INTO yon_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Yembed Yariman yaa weng kunduk yedme kowoon, Yekob ye God Aromkonomo kuyaa wiim aangke yedmoon kui. ");
INSERT INTO yon_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Kekane yedmoon, “Nambiwoom awunainban, kwane ne angkimbon yaa wanainban, ");
INSERT INTO yon_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","kwane ne indob kuu konaina angkaanban, kwane ne indob ingkad kuu kande yaa dubunaanban, ");
INSERT INTO yon_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","wene Yariman ye ambib arumi yumbon baamonekorid yimin keraneen, Yekob ye God Aromkonomo ye dobirimbon kui. ");
INSERT INTO yon_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Kedi, God ye amob weng ongmoon ye boks ye weng kuu Efarata angkambed wengamburuwen, kwane wene Jearim ye mongkobon aombed wedmuwen. ");
INSERT INTO yon_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","God ye dobirimbon yaa wenem, ye dibere oonimbon yaa wenenub kurikuri kere ye aningko kankoonem. ");
INSERT INTO yon_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","O Yariman, yaro dembe eb yiidkimbon yaa mene, eb aromkono korokbeneb amob weng ongmewen ye boks kuyiib kanmene. ");
INSERT INTO yon_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Eb dore Yuudan dore wedyiri dobiridan kuu ongmendebko yorokmo kiwaanbed dobirime, kwane ebbed yorokmo kerundewendan kuu kubi ye yook wingkime. ");
INSERT INTO yon_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Eb dememan Dewid ye dowad ebbed ye ari oiyo bune kinewenman yaa kuu eb murubia kan yeknaab. ");
INSERT INTO yon_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Yarimanbed Dewid yaa amob weng ongmoon, kuye amob kuu ikakman kandaanban, anammo angkimbaraneen kui. Kekane yedmoon, “Nembed eb yob yaambed mimo kine nendaniine king keraneen. ");
INSERT INTO yon_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Eb karub dana meed kuu nembed ongmaan ye amob weng awine kandenib, ne kerekmen korokbaan ye weng yi yaa kedmengkandaniine awine kandaniib kuu, yi karub dana meed kuu eb dibere oonimbon arimbed aron korem dibaraniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Kedi, Yarimanbed Saiyon kuu kinoon, ne dobirimbon yeman ande dowakeniib keroon kui. ");
INSERT INTO yon_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Kekane yedmoon, “Kekee ne yiidkimbon aron korem korem yeman, kuyaa kuu dowakeniib keraan kowe, nembed kwane dibere oonembaraniin. ");
INSERT INTO yon_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Saiyon angka doriibdan kuu amun kerundaniine yiminmo dobaraniib, kwane yu kamboknondan kuu animan yiminmo bangkandaniin. ");
INSERT INTO yon_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Ne dore Yuudan dore wedyiri dobiridan kuu ongmendaniina arewa yaa burudande bindi kerekmen yikaadkeraniib, kwane yu karadmodan kuu kubi yook naawonmo wingkaniib. ");
INSERT INTO yon_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Kwarimbed Dewid ye aromkono kuu nembed kandune darewoob arimbed ongmaniin, kwane nembed ye ari oiyo bune kinaanman ye ooni yaromkono kuu ongmaniina aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Nembed ye bondan kuu karak kaimbed kan derenendaniin, kumban ye kuu ongmaniina nambiri kai ye king keraneen. ");
INSERT INTO yon_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Daane kawini ye yook Dewidbed wongkoon. Kedi, ayiyambed mene wengbiriyiibban weng mimo kere ibmo dobiri kuu amun angkon manimanandeb kii. ");
INSERT INTO yon_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Kukuu God ye amob yaambed korok ari buni ye oiyo nekwiwen areb, nub korok ari bunaiwe, Eeron kui, ye ari bunaiwe, menebe kawene bomi yaa kere ye ebkad kongkono dem yaa dorimaan areb kii. ");
INSERT INTO yon_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Kukuu aangko Heemon arimbed wood nurok aangko Saiyon ari menemoon areb. Amborom kuu Yariman kuu Saiyon arimbed amun kerundimaan kowe, wadkeri aron korem kui. ");
INSERT INTO yon_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Daane kawini ye yook. Yariman ye demedan, yiib kuu Yariman ye aningko kankoonime, kane kane Yariman ye kurikuri boyambib aom amnoombed ambangkimaib kui. ");
INSERT INTO yon_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Yiib dingki kuu ambib karadmo yaa benkoobenib, Yariman ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Yarimanbed yiib yaa kuu Saiyon arimbed amun kerundok, Eweniib okadiib ongmenaboonman yembed kui. ");
INSERT INTO yon_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Yariman ye aningko kankoonime! Yariman ye aningko kankoonime, Yariman ye demedan, ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","Kane kane kuu Yariman yambiwoom awunimaibdan, nub God yambib yu kuuk wirinimbon aom dobirimaibdan kui, ");
INSERT INTO yon_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","yiib kuu Yariman ye aningko kankoonime, amborom kuu ye kuu amun kowe. Ye aningko yaa kubi yook wingkime, kukuu manimanandeb yeman kowe. ");
INSERT INTO yon_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Kedi, Yarimanbed yeka ye dowad Yekob kuu kine baamonoon, Israel kuu ye yaa bobne komboroon ye karub ande nendoone Yariman yeman keroon kui. ");
INSERT INTO yon_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Nekaad, Yariman kuu miin darewoob arimbed. Nub Yariman kuu miin darewoob arimbed, god yena korem arebban. ");
INSERT INTO yon_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Yariman kuu komo komo ye dowaken kerimaan yaamo kwane ambangkimaan, ambid aomiib okad ariyiib karamok ariyiib karamok niindem yiriyiib korem yaa. ");
INSERT INTO yon_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Yembed wiib kuu ongmaane okad yimin yimin yaambed daanimaib, kwane yembed am kuu imakiib ongmimaan, kwane yembed nuub kuu ye angkimbirimbon aombed nenkowaana minimaan kii. ");
INSERT INTO yon_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Yembed Idyipdan yi wonob dana meed yenbandoone dukniwen, nimakarub yi wonob dana meediib dingkan yi wonob dana meediib kui. ");
INSERT INTO yon_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","O Idyipdan, yiib kingiib ye korok korokiib yaa kuu yembed manmo kerene dudiib binangke ye yaa anam andi yemaniib kuu yiib aom ongmenaboon. ");
INSERT INTO yon_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Yembed ambibkin yemoon yeene monmaroon, kingdan aromkonoyiib kangkon yeene nongkoboon, ");
INSERT INTO yon_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Amorodan yi king Sihoniib Basandan yi king Ogiib okad Keenan ye ambibkindan yi king koremiib kui. ");
INSERT INTO yon_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Kwane yembed okad kuu ye nimakarub yaa kondoone yiman keroon, Israeldan yaa kondoone yiman keroon kui. ");
INSERT INTO yon_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","O Yariman, ewaningko kuu aron korem kwane angkimbaraneen, o Yariman, eb yirin kangkon nimakarub yaro dobere dobere yaro wananiib korem aom kuu kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Amborom kuu Yarimanbed ye nimakarub yi dowad wengyundekore yi kuu ambarakmindo andaneen, kwane ye demedan yaa mimyob keende awandaneen. ");
INSERT INTO yon_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Ambibkin yena korem yi god kuu kuruwakmo, silvaayiib goldiib kumbed karub yi dingkimbed ongmenabiwen. ");
INSERT INTO yon_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Yi kuu mongkodkonoyiib kumban dakmindeban, kwane yi kuu indowiib kumban wedmindeban, ");
INSERT INTO yon_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","kwane yi kuu kerendemiib kumban wengambirindeban, kwane yi kuu inum ma nimokban. ");
INSERT INTO yon_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Kuruwak god ongmenabimaibdan kuu yika ongmenabiwen yeman kwamune areb keraniib, kwane kane kane kuruwak god yaa angkumone doriib kangkon yi areb keraniib. ");
INSERT INTO yon_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","O Israel ye awoya ari, Yariman yaningko kankoonime. O Eeron ye awoya ari, Yariman yaningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","O Livai ye awoya ari, Yariman yaningko kankoonime. Kane kane Yariman yaa une bumangkimaib kuu, Yariman yaningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Saiyon arimbed Yariman yaningko kankoonime, Yerusalem aom doreenman yaningko kankoonime. Yariman yaningko kankoonime! ");
INSERT INTO yon_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Yariman yaa eso andime, ye kuu amun kowe. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Goddan korem yi God yaa eso andime. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Yariman korem yi Yariman yaa eso andime. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Yembedmo binangke ye yaa anam andi yeman ongmenabimaanman, ye yaa eso andime. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Ye meeni kangdombed Ewen ongmoonman yaa kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Yembed okad yu yumbon kuu ok wedyirimbed ongme kowoonman yaa kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Yembed nambiri dareb dareb ongmenaboonman yaa kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Aronki oonimaun ye aron kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Amnoom oonimaib ye woodiib mindongiib kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Idyipdan yi wonob dana meed yeene monmaroonman yaa kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Yi numun aombed Israeldan ben angkadoroonman yaa kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Ye dingki aromkonoyiib yiroon kumbed kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Karamok Dodmo andokboonman yaa kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Karamok kuu andokbe angkara angkara kerekore Israeldan kuu wedyiri benyanoon kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Kumban yembed Feroyiib ye ana nangmidaniib karamok Dodmo yiri benkiradmoon kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Ye nimakarub amboon angka ben kinban dewonoonman yaa kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","King dareb dareb yeene monmaroonman yaa kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Kwane kingdan aromkonoyiib yeene nongkoboon kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Amorodan yi king Sihon kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Basandan yi king Og kangkon kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Yi okad kandene ye nimakarub yaa kondoone yiman keroon kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Ye demedan Israeldan yaa kondoone yiman keroon kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Nub kuu benkubune yiri kerundiwen kuyaa wedme meenoonman yaa kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Yembed nub kuu nub bondan yaambed ben obon kerundoon kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Yembed wad dobiri yeman korem yaa animan bangkandimaan kui. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Ewen ari doreen ye God yaa eso andime. Amborom kuu ye womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Babilon ye ok kebed yaambed nub kuu diberenub, Saiyon dowad ika meenmende inok wanabimamuwen. ");
INSERT INTO yon_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Kuyaambed at aningko wilo bokon bokon ari kuu nub haap ben kinamburuwen, ");
INSERT INTO yon_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","amborom kuu nub awingke biwendanbed yook wingkime ande yedmendiwen, nub yaa durud yewed kondiwendanbed kubi yook wingkime ande nangkande yedmiwen kui, “Saiyon yu yook mimo nub yaa wingke kondime.” ande yedmiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Kumban komarewa kere nub kuu ogood ambibkin angkambed doruub kumbed Yariman ye yook kuu wingkanabanuub? ");
INSERT INTO yon_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","O Yerusalem, kub nonondande korondaniin kuu ne dingki wiwimbed haap wangki kerekmen kuu nonondandoko, ");
INSERT INTO yon_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","ne ong kuu koraab yaa daboknok. Kub nonondande korondaniin kuu kwamunemo kerok. Yerusalem yaa kubi darewoob keraan, yena arebban, kumban kuye kubi kankubunaniin kuu kwamunemo kerok. ");
INSERT INTO yon_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","O Yariman, Yerusalem monmariwen yaron ari Idomdanbed komo kamiwen kuu ika meene. Yimbed baande yedmiwen, “Yerusalem monmarime. Kumundinmo monmaribko ambukirimo kerok!” andiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Babilondan, yiib kuu monmari dowad kinoon, yiibbed nub yaa arewa kamenabiwen kuyaa kuu karub kanembed ibmo inandundaneen kuu amun kerunaneen. ");
INSERT INTO yon_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Kanembed yiib dana monob ben bot ari wowe monmaraneen kuu ye yaa kuu amun kerunaneen. ");
INSERT INTO yon_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Dewid ye yook. O Yariman, ne niindem aom kumundiniib kumbed eb yaa eso andaniin, kwane god yena yi arinambo arimbed eb yaa wingkani ewaningko kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Ne kuu eb kurikuri boyambib karadmo yaa amonombe bumangkeni, eb womoniyiibban ye mimyob dowaken keewiyiib eb ma korondiyiibban weng awiniyiib ye dowad ewaningko yaa eso andaniin, amborom kuu ewaningkoyiib eb wengiib kuu arimbed kerundeewe miin darewoob keriwen, kumkam yena korem arebban kowe. ");
INSERT INTO yon_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Eb yaa baandaan kuu ebbed inanduwewen, ebbed ne ongmeweewa arudkonomo kangdommo keraan kui. ");
INSERT INTO yon_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","O Yariman, okad yiri ye king korem kuu eb weng dakmaneewe wengambaraniib kuu, eb yaa eso andaniib. ");
INSERT INTO yon_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Kwane yi kuu Yariman ye kerekmen dowad wingkaniib, amborom kuu Yariman ye nambiri kuu miin darewoob kowe. ");
INSERT INTO yon_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Yariman kuu darewoob arimbed, kumban yirimodan yaa kuu awandi dowad kereknimaan, kumban kerengkandan kuu yekaad kuned ma awandaanban, yi yaa kuu ambab angka doreen kowe. ");
INSERT INTO yon_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Ne kuu arewa dabab niindem aom yarebimain kumban, ebbed ne kuu ongmewaawa wadkerimain. Ne bondanbed ne yaa kuu arud wandimaib kuyaa kuu eb dingkimbed kebenimaab, kwane eb dingki wiwimbed ne kuu arewa yaa burudande nendimaab. ");
INSERT INTO yon_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Yarimanbed ne dowad ye weng kunduk kuu kwamune ambangkaneen. O Yariman, eb womoniyiibban ye mimyob dowaken kuu aron korem kwane angkimbaraneen. Eb dingkimbed deme andowewen kuu korondaab ambangke dowan kere. ");
INSERT INTO yon_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Yook ambo bi ye karub yeman. God yaningko kankooni yook Dewidbed wongkoon. O Yariman, ne kuu ebbed andangke darobeweneb kaadkeruwewen. ");
INSERT INTO yon_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Ne yiri dibirimainiib yaro dobirimainiib korem kuu ebkaadkerewen, eb kuu ambab angka doreeb kumban nembed inamen kowaan korem kwangkon ebkaadkerewen. ");
INSERT INTO yon_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ne dobiri kiwaaniib ne angki kerekmeniib korem kuu darobe ebkaadkerewen, ne kamenabi korem kuu ebkaadmo kerewen. ");
INSERT INTO yon_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","O Yariman, ne mongkodkono ari weng aningko mimo mogeed dakmindo kumbed komo yedmandamiin korem kuu ebkaadmo kerewen. ");
INSERT INTO yon_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Ne kebed angkara angkara korem kuu ebbed kanawanewande durunewen, kwane eb dingkimbed ne ari koweneb awawewen. ");
INSERT INTO yon_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Ne yaa ebkaadkeruwewen ye kerekmen kuu miin manimanandeb kii, ne kuu kwamune meenindeban ii, kuye inamen kaadkeri kuu miin arimbed, nembed meendobe kabaki kuu yirimo. ");
INSERT INTO yon_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Eb Kingkin yaambed wene kunaya biknaniin? Dowan. Eb kerebiri arimbed wene kunaya kombiri wananiin? Dowan. ");
INSERT INTO yon_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Ewen ari daananiin kuu eb kuu kwari doreeb, kwane dukniwendan yi doriib yirimbed kawene angkaniin kangkon eb kuu kuri doreeb. ");
INSERT INTO yon_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Ma, ne kuu wanwene aron yaro minimaun kuu burudande kwangkakoo kai wananiin, o karamok yara yane dobaraniin kuu, ");
INSERT INTO yon_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","kuyaa kwangkon eb dingkimbed ne nen kinban wananeeb, kwane eb dingki wiwimbed ne yaa angkumowaneene kangdommo dobaraniin. ");
INSERT INTO yon_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Kekamune yedmaniin, “Anam kuu kumunbed ne kebenewaneene biknaniin, kwane nambiri ne yaa yuroon kuu amnoom kumunmo keraneen.” andaniin kuu, ");
INSERT INTO yon_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","kumun aom kuu yiminmo wedmaneeb, kwane amnoom kuu awingyab areb yuraneen, amborom kuu kumuniib nambiriyiib kuyaa kuu eb ma meenimokban kowe. ");
INSERT INTO yon_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Kedi, ebbed ne id yaa kuu yeka yeka wuub nimingke nongkobewen, ebbed ne id kuu ne ena yu kabeyob aom wuub nimingkewen. ");
INSERT INTO yon_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Ne kuu binangke une eb yaa anam andi yeman ongmewewen kowe eb yaa eso andaan. Eb ambangkanabi kuu manimanandewiib, kukuu anammo nekaad. ");
INSERT INTO yon_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Ne kuu biknimbon aom ongmewewen, okad niindem yiri ongmewewen kui, kuyaa kuu ne kono kono kuu ebkaad, ne yaa komo keroon kuu eb yaa ma biknindo. ");
INSERT INTO yon_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Ne id kuu mogeed wuub nimingkindo yaron kuu wedmewewen. Ne wooni yaroniib bobni yaroniib wad doriin yaron koremiib kuu ne woonindo yaron anuk yirimbed ebbed kinekoreb eb buk aom wongkewen. ");
INSERT INTO yon_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","O God, eb meeni kuu miin manimanandewiib andaan kii. Yi korem kuu miin yemoon kai! ");
INSERT INTO yon_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Ne kuu kwane kimingkembaraniin kuu kubuk mimim kimingki arebban, kimingke dorindeban. Kwane angke awari yaro dembaniin kuu domobdainban ewiib dobaraniin. ");
INSERT INTO yon_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","O God, miin arewa kamenabidan kuu yeene nongkobe! Yeremboromdan, yiib kuu ne yaa angkanime! ");
INSERT INTO yon_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Kedi, yi kuu inamen arewa kumbed eb dowad dakmimaib, kwane eb bondan kuu ewaningko monmarimaib. ");
INSERT INTO yon_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","O Yariman, eb yaa arud wandembirimaibdan kuu nembed yi yaa arud wandembirimainoo? Anamaa. Kwane, eb yaa manmo kerimaibdan kuu nembed yi yaa wunekare komyeng areb kerundimainoo? Anamaa. ");
INSERT INTO yon_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Nembed yi yaa naawonmo arud wandembirimain kumbedmo, yi kuu ne bondan andimain. ");
INSERT INTO yon_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","O God, ne yaa kuu andangke darobeneb ne niindem aom kuu ebkaadkere. Kwane komboon kaamobeweneb ne inamen kabakanabi yi meendobi kuu ebkaadkere. ");
INSERT INTO yon_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Kwane ne yaa kuu inamen arewa maayiib keroka kankorokbe. Kwane wadkeri aron korem ye dobiri kiwaan ari kuu ne nen kinban wene. ");
INSERT INTO yon_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Yook ambo bi ye karub yeman. God yaningko kankooni ye yook Dewidbed wongkoon. O Yariman, ne kuu miin arewa kamenabidan yaambed nen burudande angka kowe. Ne kuu yeremboromdan yaambed nen dorondare. ");
INSERT INTO yon_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Yi kuu yi niindem aom inamen miin arewa ongmenabimaib, kwane yi kuu aronki korem kuu ana nangmi inamen bangkandimaib. ");
INSERT INTO yon_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Kwane yi ong kuu niin yi ong areb kerenib “ssss” andimaib, kwane yi weng mongkodkono mandakadbed dembimaan kuu niindok arud ambod areb.Selah ");
INSERT INTO yon_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","O Yariman, ne kuu miin arewa kamenabidan yi dingki dem aombed nen burudande angka kowe. Ne kuu yeremboromdan yaambed nen dorondare. Yimbed ne kombiri ye inamen ongmiwen kui. ");
INSERT INTO yon_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Kerengkandanbed kawaad nong ne kuu awinenok ande ongme daubiwen, kwane yimbed karub awingki ye men kuu kan batangne awinewande kamiwen, kwane yimbed ne kiwaan arimbed awinenok ande nongkobiwen.Selah ");
INSERT INTO yon_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","O Yariman, “Eb kuu ne God.” ande yedmimain. O Yariman, ne yaa mimyob keewe awawe ande baandaan kuu wengamberewe. ");
INSERT INTO yon_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","O Yariman Ambengkan, ne nen aromkonomo dorondarimaabman kui, ana nangmi yaron yaa kuu eb kuu ne korok yaa kombe areb kerimaab. ");
INSERT INTO yon_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","O Yariman, arewa kamenabidan yi inamen dowaken yaambed kamandamiib kuu ee kwanime andaab, kwane yi inamen ongmiwen kuu kebene. Yi inamen ongmiwen kuu id keraneen kuu kerengkan keraniib kii.Selah ");
INSERT INTO yon_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Ne kanawanewande bon keriwendan yi korok ari kuu, yi butun kamiwen kuu ben ikakman nongkobebko, ");
INSERT INTO yon_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","amoyidkob niminiib yi ari kiroboko, yi kuu amot aom ben kiraroko, ika kawinindeban ye dem kongdem yiri ben kirarok. ");
INSERT INTO yon_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Wengamborokbanabidan kuu nuwokad kuyaom kuu yumboniibban kerime, kwane yeremboromdan kuu arewa kaimbed kirodmo mene dabunde yenbande monmarok. ");
INSERT INTO yon_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Yariman kuu dabab wayiroondan yaa koromone angkumondene, kamboknondan yaa wengyundi anammo kondimaan kuu nekaad. ");
INSERT INTO yon_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Anam kuu yorokmodan kuu ewaningko yaa eso andaniiwe, kangdommo doriibdan kuu eb kerebiri arinambo arimbed dobaraniib kii. ");
INSERT INTO yon_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","God yaningko kankooni ye yook Dewidbed wongkoon. O Yariman, eb yaa baandaan kii, kirod mene awawe. Ne baandi eb yaa kuu wengamberewe. ");
INSERT INTO yon_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Ne kurikuri eb yaa ben kabdiin kuu baeb amun kabdi areb kerok. Ne dingki benkoobi kuu oobnon yaa ye dingkan aye nengke baeb kabdi areb kerok. ");
INSERT INTO yon_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","O Yariman, ne mongkodkono yaa kangkadmi kerekmeniib ongme. Kwane ne mandakad ambongko yaa kuu weng amunmo dakmi dowad oone kerendombiri kerekmeniib ongme. ");
INSERT INTO yon_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Korondaawa ne niindem aom kuu arewa kami aom kubunaan. Korondaawa ne kuu inamen arewa ambangkain. Kane kane kuu arewa kamenabimaib kuu, korondaawa yi orokbon yaa wene anain. ");
INSERT INTO yon_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Korondebko yorokmomanbed ye mimyob dowaken keendi kerekmen yaambed ongkawe ukum kawok. Kukuu ne korok ari bune amun keruwi ye oiyo areb. “Yii, ne korok ari bunaab.” andainban. Arewa kamenabidanbed arewa kamenabimaib kuu kebenok ande kurikuri kamembirimain. ");
INSERT INTO yon_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Yi wengyundi korok korok kuu aangko dungkun nare kubuneen yiri ben kiraraneen. Ne weng kuu amun kowe yi kuu wengambaraniib. ");
INSERT INTO yon_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Okad kuu nidke aangke ben kiradmemoon areb yi kono kono kuu bobkonombon ambongko yaa ben kiradmaniiwe amone dange wananeen. ");
INSERT INTO yon_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","O Yariman Ambengkan, ne indob kuu eb yaa nengmonaan. Ne kuu ebbed kukbimaabbon aom doriin kowe, ne kuu kan bobni ari kowaab. ");
INSERT INTO yon_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Ne kuu yi kawaad nong ne dowad ben nongkobiwen kuyaambed nen burudande angka kowe. Ne kuu arewa kamenabidanbed ne kiwaan arimbed awinenok ande nongkobiwen kuyaambed nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Yimbed karub awingki ye men kan batangne awinewande kamiwen kumbed yika awinendoko, ne kuu amunmo deburudanda. ");
INSERT INTO yon_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Maskil ye yook Dewidbed botdem aom bikne doboroon kumbed wongkoon. Kurikuri yook. Yariman yaa naawon baandaan, Yariman yaa mimyob keewe awawe ande kankone baandaan. ");
INSERT INTO yon_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Ne mungkubmangkab kuu kanmene ye yaa konaan, ne dabab kuu daanaan kui. ");
INSERT INTO yon_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Ne niindem aom kuu wuudne yiminban keraan kuu, ne kiwaan korem kuu ebkaadmo. Ne yarimain ye kiwaan ari kuu karub yenambed kawaad nong awinewande kowiwen. ");
INSERT INTO yon_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Ne wiwi angka wedme. Karub mim maa ne dowad ma meenewindo. Ne nen kukbimaan ye karub maayiibban dowan, ne wadkeri dowad kangkadmi ye karub maayiibban dowan. ");
INSERT INTO yon_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","O Yariman, eb yaa baandaan. “Eb kuu ne kukbimaabbon, wad doruubdan kiri kee eb kuu ne yaa bangkawimaab ye karub.” andaan. ");
INSERT INTO yon_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Ne kuu nen kubuniiwa yirimo keraan kowe, ne baandi yaa wengambere inanduwe. Ne nenbande kamiibdan kuu aromkono darewoowiib ne arebban kowe, yi yaambed ne nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Ne kuu wii aombed doberemoon areb keraan kuyaambed nen angka kowe. Kwanebko ewaningko yaa eso anda. Ebbed ne yaa amun amun kamaneeb kowe, yorokmodan kuu neyiib yaa menebe nedbaniib. ");
INSERT INTO yon_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","God yaningko kankooni ye yook Dewidbed wongkoon. O Yariman, ne kurikuri wengamberewe. Mimyob keewe awawe ande baandaan kuu wengamberewe. Eb ma korondiyiibban weng awini kerekmeniib yorokomo kerekmeniib kuyaambed ne yaa inanduwe. ");
INSERT INTO yon_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Eb dememan ne kuu wengyundi dowad nen wanaab, amborom kuu eb arinambo ari kuu karub maa ma yorokmo dobirindo kowe. ");
INSERT INTO yon_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Kedi, bonman kuu nenbandoon, kwane yembed neene kan okad yiri irewaroon, kwane ongmoona kumun aom dobaraan, unyeman anukbed dukniwendan kumun aom doriib areb keraan. ");
INSERT INTO yon_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Kowe ne niindem aom kuu wuudne miin yiminban keraan, kwane ne mimyob kuu unimbed yidne wonoon. ");
INSERT INTO yon_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Ne kuu kurin kurin anuk ye aronki kuu meendobaan, ebbed kurin anuk ambangkanabewen yaa kuu kube meendobeni eb dingkimbed komo komo kamenabewen yaa andangke meendobaan kui. ");
INSERT INTO yon_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Ne dingki kuu eb yaa benkoobe kurikuri keraan, kwane ne niindem aom kuu okad amiibbanbed ok moom kerimaun areb eb kerekmen yaa moommo keraan.Selah ");
INSERT INTO yon_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","O Yariman, ne kingkin kuu kombarandamoon kowe, kirodmo inanduwe. Ne yaa kuu eb murubia kan yekne biknaab. Kan yekne biknaneeb kuu bobkonombon yiri winiwen areb keraniin. ");
INSERT INTO yon_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Ne kuu eb yaambed angkumone doriin kowe, amkimo kuu korondebko eb womoniyiibban ye mimyob dowaken kuu ne yaa kanmonok. Ne kingkin kuu eb yaa kankoone kabdaan kowe, ne dowad kiwaan anam kuu korokbewe. ");
INSERT INTO yon_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","O Yariman, ne bondan yaambed ne nen burudande angka kowe. Ne kuu eb kukbimaabbon aom doriin. ");
INSERT INTO yon_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Eb kuu ne God kowe, ne kedmengkawebko eb dowaken kuu ambangka. Eb Kingkin amun kumbed ne kuu okad dabonmo arimbed nen kinban wonok. ");
INSERT INTO yon_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","O Yariman, ewaningko dowad ne ongmewebko wadkera. Eb yorokmo kerekmen yaambed ne dabab kandaan kuyaa ne nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Eb womoniyiibban ye mimyob dowaken yaambed ne bondan kuu kebene. Ne yaa dabab kawimaibdan korem kuu monmare, amborom kuu ne kuu eb dememan kowe. ");
INSERT INTO yon_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Dewid ye yook. Yariman ne aromkonombon yaningko kankoonem. Yembed ana nangmi dowad kedmengkawoon, ana nangmi kedmengki korem kui. ");
INSERT INTO yon_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Ye kuu mimyob dowaken keewi ye God angkon ne aromne angkumonimbon, ye kuu ne aromkonoyiib dobirimbon angkon ne nen arewa yaa burudande angka kowi ye karub, ye kuu ne dorondari ye karub angkon ye kukbimaanbon aom doriin, kwane yembed ambibkin yena kuu ne dabderem yiri kerundimaan kui. ");
INSERT INTO yon_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","O Yariman, nimakarub kuu kaneyakob eb kuu yi yaa oone doreeb? Yi dana kuu kaneyakob eb kuu yi yaa meenmo doreeb? ");
INSERT INTO yon_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Karub mimim yi dobiri ye weeb kuu eb yaambed inum koni mimo areb kumbedmo. Yi kuu ayari on kuruwak dewene burudandemoon areb barang darewoobban. ");
INSERT INTO yon_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","O Yariman, eb Eweniib ambidiib kuu biringke yiri kamene. Kwane aangko aangko kuu angkorondebko amarengiib dembok. ");
INSERT INTO yon_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Imak kuu ben nongkobeneb bondan kuu bokne daware buyokbayok kerunde. Eb ana ben barambereneb yi kuu yenbandebko kirokmone winime. ");
INSERT INTO yon_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Eb amaan ari kumbed eb dingki yireneb, ok darewoowiib noroddaniib yaambed ne kuu nen burudande angka kowe. ");
INSERT INTO yon_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Yi mongkodkono kuu dudanabimbed yukne diiroon, kwane yi dingki wiwi kuu aadidmi awaan. ");
INSERT INTO yon_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","O God, ne kuu eb yaa yook yeeb wingkaniin, eb yaa nong angko angkoyiib ye laiya wangke wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Yembed kingdan yaa kuu ana nangme burudande dori bangkandimaan, kwane yembed ye dememan Dewid kuu arewa kamenabidan yi kerewang yaambed nen burudande angka kowimaan. ");
INSERT INTO yon_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Ne kuu noroddan yaambed nen burudande angka kowe. Yi mongkodkono kuu dudanabimbed yukne diiroon, kwane yi dingki wiwi kuu aadidmi awaan. ");
INSERT INTO yon_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Nub karub dana meed kuu ongmendebko kab amunmo dembe kainimaan areb kewed kerime. Nub nima dana meed kuu ongmendebko king ye ambiwoom dodkono manimanandeb ongmiwen areb kwane koyu kerime. ");
INSERT INTO yon_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Nub animan nongkobimbon ambib ben ongmendebko animan mimim korem kuu diirok. Nub sibi kuu ongmendebko nub okad arimbed tausen tausen yemooniib kerime. ");
INSERT INTO yon_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Nub oksen kuu ongmendebko mana yemooniib kerenib mana bobniyiibban yiminmo kerime. Bondanbed nub awingke ben wini kuu kebene. Nub kambong aom kuu miin yiminban kere baande komkiyiibban kerok. ");
INSERT INTO yon_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Kwamune keriwendan kuu amun kerundoon, kaneya yi God kuu Yariman kuu amun kerundoon kii! ");
INSERT INTO yon_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","God yaningko kankooni ye yook Dewidbed wongkoon. Ne God ne King, eb kubebde eb kuu darewoob arimbed andaniin, kwane ewaningko kuu aron korem korem kankoonaniin. ");
INSERT INTO yon_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Aronki mimim korem ewaningko kankoonaniin, kwane eb kubebde eb kuu darewoob arimbed andaniin aron korem korem. ");
INSERT INTO yon_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Yariman kuu darewoob arimbed, ye aningko yaamo kankooni yeman. Ye inamen kuu darewoob arimbed kowe, karub mim kanembed kaadkerunindeban. ");
INSERT INTO yon_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Awodkiya awaana kumbed eb ambangkanabi yaa kube kankooni weng kuu yi dana meed yaa dakmenabaniib, kwane yimbed eb kamenabi aromkonomo ye weng kangkon dakmenabaniib. ");
INSERT INTO yon_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Yi kuu eb dobiri manimanandeb ye nambiri kwane dakmenabaniib kii. Eb ambangkanabi kumbed binangke eb yaa kubimaib ye weng kuu kube meendobaniin. ");
INSERT INTO yon_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Eb kamenabi binangki yeman kuye aromkono ye weng kuu nimakarubbed kwane dakmenabaniib. Kwane nembed eb kuu darewoob arimbed ye weng kuu dakmenabaniin. ");
INSERT INTO yon_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Eb amun amun yiminmo kamendimaab ye weng kuu nindorokiibbed dakme kubaniib, kwane eb yorokmo kerekmen ye dowad kubi yook wingkaniib. ");
INSERT INTO yon_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Yariman kuu kabamoon kondoon ye mimyob dowaken keendimaan angkon mimyob keende kakman are nonondandimaan, kwane ye norin arud kuu yodbirimban emambed angkon mimyob dowaken darebmoyiib. ");
INSERT INTO yon_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Yariman kuu nimakarub korem yaa amun amun kamendimaan, kwane ongmenaboon ye kumkam korem yi dabab kandimaib yaa kuu mimyob keende awandimaan. ");
INSERT INTO yon_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","O Yariman, ongmenabewen ye kumkam korem kuu eb yaa eso andaniib, kwane eb karadmodan kuu eb kubebde eb kuu darewoob arimbed andaniib. ");
INSERT INTO yon_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Yi kuu eb oonimbon ye nambiri ye wengiib, eb aromkono kai ye wengiib dakmenabaniib. ");
INSERT INTO yon_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Kwane dakmaniib kumbed nimakarub korem kuu eb kamenabi aromkono kuyiib eb oonimbon ye nambiri manimanandeb kuyiib kuu yikaadkeraniib. ");
INSERT INTO yon_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Eb oonimbon kuu dowan keraanban aron korem kwane angkimbaraneen, kwane ebbed korok kere ooni ye kerekmen kuu nimakarub yaro dobere dobere yaro wananiib korem aom kwane angkimbaraneen. Yariman kuu ye weng kunduk korem kuu kwane kuyaamo ambangkimaan, ma korondaanban, kwane ongmenaboon ye kumkam korem yaa kuu mimyob dowaken keendimaan. ");
INSERT INTO yon_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Kane kane kombiriwen kuu Yarimanbed awande benkoobimaan, kwane kane kane dabab aom kande doriib kuu yembed ben angka nongkobimaan. ");
INSERT INTO yon_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Wad doriib ye dingkaniib nimakaruwiib korem kuu eb kwananeeb ande kerebdombaraiwa, animan kuu aron anam arimbed yi yaa bangkandimaab. ");
INSERT INTO yon_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Eb dingki kan yire yiminmo bangkandaawe, wad doriib ye dingkaniib nimakaruwiib korem kuu ane mikmonimaib. ");
INSERT INTO yon_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Yariman kuu ye kerekmen korem yaambed kuu yorokmo, kwane ongmenaboon ye kumkam korem yaa kuu mimyob dowaken keendimaan. ");
INSERT INTO yon_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Kane kane yi kuu Yariman yaa baandimaib kuu ye kuu yi korem diamo keroon, anam anam yaambed ye yaa bandimaibdan kui. ");
INSERT INTO yon_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Kane kane yi kuu ye yaa une bumangkimaib kuu yembed yi dowaken yaa kuu id kerundi kondimaan, kwane yi baandi kuu wengamberende ben burudande angka nongkobimaan. ");
INSERT INTO yon_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Kane kane yi kuu Yariman yaa mimyob dowaken keenimaib kuu yembed yi yaa kerendombere oonendimaan, kumban arewa kamenabidan korem kuu yembed monmaraneen. ");
INSERT INTO yon_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Ne mongkodkonombed Yariman ye aningko kankooni weng dakmenabaniin, kwane wad doriib ye dingkaniib nimakaruwiib korem kuu ye aningko karadmo kankoonembaraniib aron korem korem. ");
INSERT INTO yon_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Yariman ye aningko kankoonime! O ne kingkin, Yariman yaningko kankoona! ");
INSERT INTO yon_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Ne wad dobaraniin yaron korem kuu Yariman yaningko kankoonaniin. Ne wad dobaraniin yaron korem kuu ne God yaningko kankooni ye yook wingkaniin. ");
INSERT INTO yon_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Korok korok yaambed angkumone dobaraib, duknaniib ye nimakarubbed yiib kuu bobni yaa burudande bindindeban kowe yi yaambed angkumone dobaraib. ");
INSERT INTO yon_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Yi kingkin doombere wananiib kuu yi id koronde okad keraneen, kwane kuye aronki kwari yi inamen ongmiwen kuu dawangmo keraneen. ");
INSERT INTO yon_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Kumban kane kane yi kuu Yekob ye Godbed awandimaan kuu amun kerundoon, Yariman yi God ye dowad yembed kwananeen andimaibdan kui. ");
INSERT INTO yon_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Yembed Eweniib okadiib ongmenaboon, karamokiib kumaom kumkam koremiib kangkon ongmenaboon. Yembed ma korondiyiibban weng awinembirimaan aron korem. ");
INSERT INTO yon_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Yembed dabab wayiroondan yi dowad anammo wengyundimaan. Yembed mungimo keriwendan yaa animan bangkandimaan. Yarimanbed wiidan kuu ben obon kerundimaan. ");
INSERT INTO yon_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Yarimanbed indob tutdan yi indob nandimaan. Yarimanbed dababbed ben kibinoondan kuu benkoobimaan. Yarimanbed yorokmodan yaa kuu mimyob dowaken keendimaan. ");
INSERT INTO yon_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Yarimanbed noroddan nub ambibkin aom doriib kuu kerendombere oonendimaan, kwane yembed awodkiyiibbandaniib iribdaniib kuu awandimaan, kumban arewa kamenabidan yi inamen ongmimaib kuu kebenimaan. ");
INSERT INTO yon_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Yariman kuu aron korem king kere oonembaraneen. O Saiyondan, ye kuu yiib God, nimakarub yaro dobere dobere yaro wananiib korem aom kwamunemo doberembaraneen. Yariman ye aningko kankoonime! ");
INSERT INTO yon_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Yariman ye aningko kankoonime! Nub God ye aningko kankooni ye yook wingki kuu amun kii. Ye aningko kankooni kuu kubi yeman angkon konomdangmo. ");
INSERT INTO yon_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Yarimanbed Yerusalem kuu ikakman yenbeen, kwane yembed Israeldan buyokbayok keriwen kuu ika ben nedbe doroon. ");
INSERT INTO yon_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Yembed yi mimyob wande miin yiminban keriwen kuu windandunde ongmimaan, kwane yi bob kuu yonende kebendimaan. ");
INSERT INTO yon_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Ye kuu mindong mimo mimo kuu kimingke korem yekaadkeroon, kwane korem kuu yi aningkombed mimo mimo yeengkanandoon. ");
INSERT INTO yon_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Nub Yariman kuu darewoob arimbed, kwane ye kuu aromkonomo. Ye meeni inamen kaadkeri kuu ye yimin yiminiibban kii. ");
INSERT INTO yon_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Kane kane yi kuu benkubune yirimo keriwen kuu Yarimanbed benkoobe awandimaan, kumban arewa kamenabidan kuu okad yiri ben kirarundimaan. ");
INSERT INTO yon_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Yariman yaa eso andiyiib yook wingkime. Nub God yaa haapbed wangke wingkime. ");
INSERT INTO yon_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Yembed ambid kuu wiibbed kebenimaan. Yembed okad ari am bangkandimaan. Yembed koodbon koodbon ari kereek ongmaana dembenabimaan. ");
INSERT INTO yon_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Yembed dingkan yaa kuu animan bangkandimaan, kwane on bungkun mana baandimaib kuu animan bangkandimaan. ");
INSERT INTO yon_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Hoos ye aromkono yaa kuu God kuu kubi dowaken kerimokban, kwane karub ye yon yaromkono yaa kangkon God kubimokban. ");
INSERT INTO yon_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Kumban kane kane yi kuu Yariman yaa une bumangkimaib yaa kuu kubi dowaken kerimaan, kane kane yi kuu ye womoniyiibban ye mimyob dowaken monok ande meedmimaib kuyaa kubimaan kui. ");
INSERT INTO yon_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","O Yerusalem, yiib kuu Yariman yaa kubenib ye kuu darewoob arimbed andime. O Saiyon, yiib kuu yiib God ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Amborom kuu Yerusalem yu kuuk ambongko kuu aromkono ariyiib ongmimaan, kwane kumaom doriibdan kuu amun kerundimaan kowe. ");
INSERT INTO yon_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Yiib okad yimin yimin yaa kuu yembed yewenubmo kerundimaan, kwane wiit yob miin amun kumbed yiminmo bangkandimaan. ");
INSERT INTO yon_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Yembed kwanime andi ye weng kuu okad yiri kowimaan, kwane komo dakmimaan ye weng kuu kirodmo kwamunemo kerimaan. ");
INSERT INTO yon_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Yembed wiiwam yurukmo kuu okad yaa dabunimaan, kwane wood nurok yurukmo kuu derendarimaan, ");
INSERT INTO yon_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","kwane am yurukmo boyareb kuu yiri kiradmimaan kowe, karub kanembed kuyaa kuu man dobaraneen? Dowan. ");
INSERT INTO yon_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Kwane yembed weng yedmaana bumone okmo kerimaan, kwane nuub kowaana ok yurukmo boyareb ku bumone okmo kere wenebimaun. ");
INSERT INTO yon_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Yembed ye weng kuu Yekob yaa ben korokboon, ye amowiib kongamki yamowiib kuu Israel yaa ben korokboon kui. ");
INSERT INTO yon_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Ambibkin yena yi dowad ye kuu kekamune ma kamindo, yi kuu ye amob ma yikaadkerindo. Yariman ye aningko kankoonime! ");
INSERT INTO yon_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Yariman ye aningko kankoonime! Ewen arimbed Yariman ye aningko kankoonime. Ambab ari kaimbed Yariman ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Ye engyus korem, Yariman ye aningko kankoonime. Ye ana nangmidan korem, Yariman ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Aron yoom wood yoom, Yariman ye aningko kankoonime. Yurimaib ye mindong, Yariman ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Ewen, Yariman ye aningko kankoone. Ok ambid animari, Yariman ye aningko kankoone. ");
INSERT INTO yon_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Yi korem kuu Yariman ye aningko kankoonime, amborom kuu yembed weng yedme kowoona doriwen kowe. ");
INSERT INTO yon_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Yembed yi yaa yumbon bangkandoona kangdommo kwane dobaraniib aron korem korem, yembed dowan kerindeban ye amob ongmoon kui. ");
INSERT INTO yon_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Okad arimbed Yariman ye aningko kankoonime, karamok ye omyereyiib karamok niindem yiri doriib ye dingkaniib ");
INSERT INTO yon_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","imakiib am yurukmo boyarewiib wiiwam yurukmoyiib wiiwiib ye weng yaambed kwamimaib ye nuub darewoowiib ");
INSERT INTO yon_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","aangko aangkoyiib koodbon koremiib yob irimaib ye ayiib at sidaa koremiib ");
INSERT INTO yon_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","kiib dingkaniib amongkob dingkaniib yiyiib ayari oniib ");
INSERT INTO yon_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","okad yiri ye kingdaniib ambibkin koremdaniib okad yiri ye korok korokiib okad yiri ye wengyundidaniib ");
INSERT INTO yon_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","kewediib koyuyiib aamkono aamkonoyiib danayayiib kui. ");
INSERT INTO yon_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Yi korem kuu Yariman ye aningko kankoonime, amborom kuu ye aningkomo kuu darewoob arimbed, kwane ye nambiri kuu okadiib Eweniib burudande arimbed. ");
INSERT INTO yon_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Ye nimakarub yi dowad aromkono kaiman ongmoon, kuyaa kuu ye karadmodan korem kuu kube yirin kamaniib, Israeldan kui, Yariman ye dia doriibdan kui. Yariman ye aningko kankoonime! ");
INSERT INTO yon_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Yariman ye aningko kankoonime! Yariman yaa yook yeeb wingkime, kwane yorokmodan kuu nedbe ye aningko kankooni dowad yook wingkime. ");
INSERT INTO yon_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Israeldan kuu yi Ongmoonman yaa kubenime, kwane Saiyondan kuu yi King yaa kubi dowaken kerime. ");
INSERT INTO yon_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Yi kuu andenib ye aningko kankoonime, kwane ye yaa kuu tamboriniib haawiib wangke wingkime. ");
INSERT INTO yon_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Amborom kuu Yariman kuu ye nimakarub yaa kubi dowaken keendimaan kowe. Kwane kane kane yi kuu dabab wayiroon kuu burudande dori kerekmen kondaneen. ");
INSERT INTO yon_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Yorokmodan kuu kwane kondaneen kuyaa kuu kubi darewoowiib kerime, kwane yi angkimbon arimbed kubi yook wingkime. ");
INSERT INTO yon_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Yi mongkodkonombed God yaningko kankoonembirime, kwane kerewang angkara arud angkara arud kuu yi dingki aom angkimborok. ");
INSERT INTO yon_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","Kukuu ambibkin yena yi arewa kamenabi yaa kakman kondi yeman, yi yaa ukum kondi yeman kui. ");
INSERT INTO yon_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Kukuu yi kingdan ben seinbed yerengki yeman, yi korok korok kangkon awurimbed ben yerengke wii aom kambiri yeman kui. ");
INSERT INTO yon_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Kukuu Godbed ukum kukui andoon kumbed yi yaa kwane kondi yeman. Ye yorokmodan kwananiib kuu aningko darewoob kandaniib. Yariman ye aningko kankoonime! ");
INSERT INTO yon_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Yariman ye aningko kankoonime! God kuu ye karadmo dobirimbon aombed doreen kuye aningko kankoonime. Ye kuu mindong yi dangimbon aromkonoyiib arimbed doreen kuye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Ye kamenabi aromkonoyiib ye dowad ye aningko kankoonime. Ye kuu korem burudande darewoob arimbed kowe ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Kibi baandenib ye aningko kankoonime. Haawiib laiyayiib wangkenib ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Tamborin wangke andenib ye aningko kankoonime. Nongbed wangki yeman wangkanabe yurin wurumenib ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Kuweng darewoob ye simbal wangkanabenib ye aningko kankoonime. Kuweng wenebi ye simbal wangkanabenib ye aningko kankoonime. ");
INSERT INTO yon_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Inum nimaib ye dingkaniib nimakaruwiib kuu Yariman ye aningko kankoonime. Yariman ye aningko kankoonime! ");
INSERT INTO yon_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Keresu ye awoya awoya yiri kei. Yesu Keresu kuu Dewid ye awo aman ari, King Dewid kuu Abraham ye awo aman ari. Aningko kei: ");
INSERT INTO yon_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham kuu Aisek yambe, Aisek kuu Yekob yambe, Yekob kuu Yudayiib ye aagoroka yenayiib yi ambe, ");
INSERT INTO yon_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda kuu Peres yoom Seera yoom yi ambe, yi ena kuu Tamar. Peres kuu Hesron yambe, Hesron kuu Rem yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rem kuu Aminadab yambe, Aminadab kuu Nason yambe, Nason kuu Salmon yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon kuu Boas yambe, Boas ye ena kuu Rehab, Boas kuu Obed yambe, Obed ye ena kuu Rut, Obed kuu Yesi yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi kuu King Dewid yambe, Dewid kuu Solomon yambe, Solomon ye ena kuu Yuraiya yamban. ");
INSERT INTO yon_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon kuu Rehoboam yambe, Rehoboam kuu Abidya yambe, Abidya kuu Asa yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kuu Yehosafat yambe, Yehosafat kuu Yehorem yambe, Yehorem kuu Usaiya yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaiya kuu Yotam yambe, Yotam kuu Ahas yambe, Ahas kuu Hesekaiya yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaiya kuu Menase yambe, Menase kuu Amon yambe, Amon kuu Yosaiya yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaiya kuu Yekonaiya yambe, Yekonaiya yoom ye aagoroka yoom kuu Babilondanbed mene ana nangbanekorib, Babilon ambibkin angka benwiniwen. ");
INSERT INTO yon_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Amaan, Babilon angka benwiniwen ari kuu: Yekonaiya kuu Siotio yambe, Siotio kuu Serubabel yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel kuu Abiud yambe, Abiud kuu Elaiyakim yambe, Elaiyakim kuu Aso yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso kuu Sadok yambe, Sadok kuu Akim yambe, Akim kuu Eliud yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud kuu Eliesa yambe, Eliesa kuu Mattan yambe, Mattan kuu Yekob yambe, ");
INSERT INTO yon_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yekob kuu Yosef yambe, Yosef yamban kuu Meri, yu yaambed Yesu wooneen kui. Ye yaa Keresu andimaib kii. ");
INSERT INTO yon_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kekee ibduruk ye awoya Abraham doboroonkob mene King Dewid kuu awoya awoya 14iib. Angkon King Dewidbed doboroonkob mene ari Babilondanbed yeene benwiniwen yaron kwangkon awoya awoya 14iib. Amaan angkon Babilon angka benwiniwenbed mene ari Yesuyiib wooneen kwangkon awoya awoya 14iib. ");
INSERT INTO yon_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kekee komo kere Yesu Keresu wooneen kuu kei. Ye awaan Meri kuu Yosef ye wonong ande boriwen, kumban yi ayoob awane dobirindo ye niindem aom kumbed, Kingkin Karadmombed yu yaa menekore ye aromkonombed yu niindem aom kuu dana ongmoon kowe, yu kuu oyoomiib keruune wedmiwen. ");
INSERT INTO yon_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yu karub Yosef kuu God ye yorokmo karub kowe, nimakarub wedangkambed yu yaa karak konde domondi kuu ye dowakenban. Kwani kowe, yembed meenoon kuu boruwen kuu iwari korondem ande kamoon. ");
INSERT INTO yon_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kwanande kamoon kowe, Yariman ye engyumbed Yosef yaa mene kiyuum angkambed daanoon, “Yosef, Dewid ye awo ari yee! Meri kuu awane eb ambiwoom nenwene. Eb unaab, amborom kuu yu oyoomiib kereen kuu Kingkin Karadmombed yaromkonombed ongmoon. ");
INSERT INTO yon_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yu kuu karub dana woonanuun kowe, eb kuu yaningko kone Yesu ande, amborom kuu yembed ye nimakarub yi ambarakmi ye kakman yaa kuu burudande bindaneen kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kwanoon amborom kuu unyeman anuk yaa weng kuu Yarimanbed yedmoone ye profesiman mene daande wongkoon kuu id anam kwamune dembe wonoon. ");
INSERT INTO yon_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Yembed daandoon kuu, “Wonong koyu karub maayiib angkindo kumbed oyoomiib kerenu karub dana woonanuuna yaningko Imanyuel andaniib.” andoon. Imanyuel ye weng id kuu “God nub yaa doreen” kui. ");
INSERT INTO yon_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Engyumbed kwanandoon kowe, Yosef demboon ye yondem kuu yaro komo Yarimanbed ye yaa daanoon kuu kwanoon, Meri awane yambiwoom nenwonoon, ye wonong keroon. ");
INSERT INTO yon_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kumban ye kuu Meri yoom ma dabokne angkindo, kwane dobere wene ari yu karub dana kuu wooneen. Ye aningko Yesu ande kowoon. ");
INSERT INTO yon_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Erod kuu Yuudan yi king kere doreen yaambed, Yesu kuu wooneen, Yudea ambibkin kambong Betlehem aombed. Yesu woonuuna, amaanbed mindong darobe andangkanabidan yena aron dembimaun angkambed Yerusalem aom miniwen. Menenib, taun kumaom doriibdan yaa dawuro kaamobiwen, ");
INSERT INTO yon_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Dana woonekore Yuudan yi king keraneen kuu kuna yaambed doreen? Ye wooneen ye mindong diburuuna, kangka doruub kumbed wedmuwen. Wedmuwen kowe, nub mene wedmene ye yaa bumangkane kube yaningko kankoonandamuub.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kwane, karub maambed King Erod yaa wene daanoone, wengamberekore kongendoon. Kongendoone, Yerusalemdan korem kuu uniwen. ");
INSERT INTO yon_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kwane, yembed yedmoona, God dore Yuudan dore wedyiri dobiridan yi korok korokiib, Yuudan yi amob kedmengkandidan yi korok korokiib korem nedbiiwe kaamobendoon, “Kuna yaambed Godbed kinaneena mananeenman Keresu kuu woonanuun?” andoon. ");
INSERT INTO yon_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Andoona, inande yedmiwen, “Ye kuu Yudea ambibkin kambong Betlehem aombed woonanuun. Profesimanbed unyeman wongkoon kuu kei, ");
INSERT INTO yon_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kambong Betlehem. Kub aombed Yudea ambibkin angka, kub kuu kambong embeng kumban, taun maa maa yaa Yudea kumaom kuu korok miin darewoob keraneeb, amborom kuu kub aombed King darewoob mananeen kowe, ye kuu ne nimakarub Israeldan oonaneen.’ ande wongkoon.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kwamunekoriwa, Yuudan yi korok korok kuu dakme dowan keriiwa, king Erod yedmoonkob karub maambed mindong darobe andangkanabidan yemyeb benmonoon. Benmonoona, king Erodiibmo nedbiiwa kaamobendoon, “Aron komo arimbed mindong kuu andowe wedmiwen?” andoone neman inandiwen. ");
INSERT INTO yon_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kwane yembed domonde birande yedmoon, “Yiib kambong Betlehem angka winime, wenenib korobe onmenmo yare dana kuu wedmibka, ika mene neyiib yedmewime. Mene yedmewibko, ne kangkon weneni ye yaa bumangkane kube yaningko kankoona.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","King Erod kwamune ye weng yi yaa daande domondoona winiwen. Kwane yaro dore winiiwa, mindong aron dembimaun angkambed wedmiwen kuu angkon ika yaro yureen. Mindong kuu yi arinambo arimbed yure wene mene wedwiri dana angkeen arimbed mimyirimo dibere yureen kowe, ");
INSERT INTO yon_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","kubi darewoob kamiwen. ");
INSERT INTO yon_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kwane ambiwoom awunenib, dana yoom yawaan Meri yoom wedmiwen. Kwane, yi korem bumangkanib korok ambokibenib dana yaa kube yaningko kankooniwen. Kwane, yi od yowoyiib bongmenabenib munob yiribman ye yaa bangkaniwen, od goldiib at nunung baeb amun yeman yaningko ferengkinsensiib muramura baeb amun yaningko meeryiib kwane bangkaniwen. ");
INSERT INTO yon_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Amnoom angkambed, Godbed menene kiyuum angkambed mindong darobe andangkanabidan yaa yedmendoon, “Amob, yiib kuu king Erod yaa ika wanaib.” andoon. Kwanandoona, kiwaan maambed yi ambibkin angka ika winiwen. ");
INSERT INTO yon_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kwamune mindong darobe andangkanabidan kuu winiiwa, Yariman ye engyu Yosef yaa menene kiyuum angkambed daanoon, “Yeedere yaro danayiib yawaaniib be Idyip ambibkin yiri kombiri wene kuri dobere. Kwamune dobereewo nekambed yedmebdaniin kui. Kuri dobere, amborom kuu King Erodbed ye ana nangmidan yedmandamoona onmene dana kuu aye kowandamiib kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kowe, kuye amnoom Yosef yeedere yaro dore danayiib awaaniib be kombiri Idyip yiri andowe wonoon. ");
INSERT INTO yon_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kwamune King Erod bobnindo yaron kuyaambed, yi korem kuri Idyip aom doriib. Kowe, kurinbed Godbed ye profesiman yaa daanoone dakmoon kuu “Neka ne dana baandaane Idyip ambibkin aombed monoon.” andoon kuu anam id keroon. ");
INSERT INTO yon_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yosef ye danaya awaana be Idyip yiri wonoon ye yondem kuu, King Erod wedmoonka mindong andangkanabidan kuu ye yaa aadidme kiwaan maambed awanewande winiwen. Kwamuniiwa, ye kuu norin miin darewoob wandoon kowe, ana nangmidan yedmoona kambong Betlehemiib kambong kambong dia diayiib wenenib, karub dana korem yi weeb ayoob keriwenbed kiri kuu korem yenbandiiwe dukniwen. Mindong darobe andangkanabidanbed mindong kuu weeb ayoob wedmuwen Erod yaa ande yedmiwen kowe, dana yi weeb kwamune yenbandime andoon. ");
INSERT INTO yon_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kwamune keroon kuu Godbed unyeman anuk yaa daanoonkob profesiman Yeremaiyambed wongkoon kuu anam id keroon kuu kei. ");
INSERT INTO yon_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Yuudi ameng weng darewoob kambong Rama aom wengambiriwen. Kukuu Rekselbed yuudi ameng weng darewoob kamuun, yu dana meed yi dowad. Yu dowakenban kereen, karub yenambed nangkande mimyob kankubune yu yaa awandi kuu yiminban kereen, amborom kuu yu dana kuu dowan kowe.” kwane wongkoon. ");
INSERT INTO yon_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kwamune Yosef awene Idyip aom doriib yaa, King Erod kuu bobnoon. Bobnoona, God ye engyumbed Yosef yaa menene kiyuum angka daanoon, ");
INSERT INTO yon_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Yeedere yaro dore, danayiib yawaaniib be ika Israel ambibkin ari be wene, amborom kuu karub kane kanembed dana ayande kamiibdan kuu yoworiwen kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kowe kwane, Yosef yeedere yaro dore, danayiib yawaaniib be ika Israel ambibkin ari wonoon. ");
INSERT INTO yon_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kumban Yosef mene wengamboroonka, Aakelius kuu awodki Erod ye yumbon kande Yudeadan yi korok kere doboroon kii andiwen. Ye wengamberekore, wene kuyaa dobiri kuu koronde unoon. Kwamune angkon kiyuum angkambed kuyaa dobaraab andoone wengamberekore, Yudea kuu awanewande Galeli ambibkin ari danayiib awaaniib be wene ");
INSERT INTO yon_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","kambong Nasaret aom dobiriwen kowe, anuk Godbed daandoonkob ye profesidanbed daandiwen kuu, ye kuu Nasaretman andaniib kii andoon kuu Yesu yaa anam id keroon. ");
INSERT INTO yon_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kwane, weeb yena dowan keruune, Yoon Baptaisman kuu wene Yudea ye amboon angka doberekore, baande daandimaan kuu, ");
INSERT INTO yon_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ambarakmi yaa koronde amonombime, amborom kuu Ewen Yarimanbed nimakarub yi korok kere ooni yaron dia menuun.” andimaan. ");
INSERT INTO yon_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Unyeman anuk yaambed profesiman yaningko Aisaiyambed weng maa yedmoon kuu Yoon yaa kuu kwane anam id keroon. Kwane yedmoon, “Karub maa kwane amboon angkambed baande daandaneen kii. ‘Yariman mananeen ye kiwaan nekwime, ye kiwaan yorokmo ongmime.’” andoon. ");
INSERT INTO yon_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Keye Yoon yebkad kuu kemo kimimbed ongmiwen kumbed derene, ye kobaiknong kuu dingkan kadbed boronimaan koborom yaa. Angkon kwamune ye animan kuu dura angka ye in okiib ediib kumbedmo animaan. ");
INSERT INTO yon_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kuye aron kuu Yerusalemdaniib Yudeadaniib ok Yooden yara yara doriibdaniib Yoon yaa wengamberem ande menebiwen. ");
INSERT INTO yon_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kuyaambed yi ambarakmi korem God yaa mimyob kowe dakmekoriwa, ok Yooden yirimbed baptais kerundoon. Kwane menebe wengambaraiwa baptais kerundaane winimo kamiwen. ");
INSERT INTO yon_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aron kwane kamiib aombed wedmoona, Yuudan yi Farisidaniib Sedyusidaniib kwane Yoon yaa miniwen. Miniiwe wedmekore, yedmendoon, “Yiib kuu nemengkandidan, arud niin areb kii! Kanembed daandeenkob, God ye norina dabawa yiib ari menebandameen yaa kuu kombere wanandiwed? Komarewa kee? ");
INSERT INTO yon_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ambarakmi yaa koronde amonombi ye kerekmen yaambed awine amunmo kamime. ");
INSERT INTO yon_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Nub kuu Abraham ye awoya kowe butun kandaubban ande meenaib, amborom kuu Adam ongmi areb Godbed bot be Abraham ye awoya ongmenabi kuu yimin kowe. Kedi, yiib anam andi kuu Abraham ye anam andi arebban kowe, Abraham yaa weng kunduk kowoon kuu koronde yiib yaa butun kerundaneen kwangkon yimin. ");
INSERT INTO yon_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Godbed wengyundanande meneen kuu at dengki ye karub menemoon areb. Kapakiib nande at ambokab yiri doreen. At kuu ayob id arewayiib keraneen kuu dengke be amot yiri kiradmaneen. ");
INSERT INTO yon_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ne kuu okbed nimakarub yaa baptais kerundaan kuu ambarakmi yaa koronde God yaa amonombi ye akmi yeman kui. Kumban karub maa ari mananeen kuu ye aningko kuu ambab ari, ne kuu yirimo. Kwane kowe, nembed yambiwoom awunimaana ye yonkad biangke bi ye deme awini kuu yiminban. Yembed Kingkin Karadmoyiib amoyiib baptais kerundaneen. ");
INSERT INTO yon_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yembed wiit yowiib awiib ari kirari yemaniib awine doreen kii, kwane kanwene wiit yob dabonmo ari beengkimbon arekore, beengkene be kirare yowiib awiib andokbe wenorekore, yob kuu yambiwoom be nongkobaneen kumban ab kuu amot kumbaanban yiri be kiraraneene denaniib, nimakarub amuniib nimakarub arewayiib andokbi ye dowad nekwoon kui.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kuye yoman, Yesu kuu Galeli ambibkin domonde ok Yooden yiri wene Yoonbed baptais keruwok anded. ");
INSERT INTO yon_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kumban Yoonbed kebenande kamoon, “Ebbed ne baptais keruwaneeb kumbed yiminaa. Komarewa ne yaa baptais keruwok ande menewen?” ande kamoon. ");
INSERT INTO yon_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kumban Yesumbed neman yedmoon, “Kibireb kwamunaneeb kumbed yimin, nub yaa. Kukuu yorokmo inamen Godbed ongmenaboon korem anam id keri yeman kowe, kwane kame.” andoone, Yoonbed eyoka kwana andoon. ");
INSERT INTO yon_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kwane, Yesu yaa baptais kerunoone yaro demboone ambid kuu bengkeroone, kuyaa wedmoonka God ye Kingkinbed on arud wan kamenemoon areb kamenene Yesu ari diboroon. ");
INSERT INTO yon_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kwane ambid arimbed weng monoon, mene yedmoon, “Kekee ne Dana kii. Ye yaa ne mimyob dowaken darewoob kowaan. Ye yaa ne anam kubimain.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kwane, Yesu kuu Kingkin Karadmombed amboon angka nenwonoon. Ye kuu awad arewa yi korokbed komboon kaamobi ye dowad nenwonoon. ");
INSERT INTO yon_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nenwonoone, Yesu kuu animan koronde aronki 40yiib amnoom 40yiib doboroon kowe, mungimo keroon. ");
INSERT INTO yon_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kuye yoman kwamune awad arewa yi korok mene komboon kaamobi ye dowad yedmoon, “Eb kuu God ye Mingki keroka, bot kee yedmebko om keroko ane.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kumban Yesumbed inande yedmoon, “Yii, God Ye Weng wongkiwen kuu, ‘Nimakarub kuu animaniibmo ane dobaraibban, wadkeri yeman anam kuu Godbed komo dakmeen kwangkon wengambere dobaraniib kumbed yimin.’ ande wongkiwen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kwanandoon kowe, awad arewa yi korok kuu Yesu nenwene God ye siti karadmo Yerusalem aom nande kurikuri boyambib darewoob aminim arimbed kowoona doboroon. ");
INSERT INTO yon_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kwane awad arewa yi korokbed yedmoon, “Eb kuu God ye Mingki keroka, ebka korongberenande kawene okad yiri kombere, amborom kuu God Ye Weng wongkiwen kuu, ‘Godbed ye engyus yedmaneena, yimbed eb yaa ongme oonebdaniib. Kwane yi dingkimbed eb awine kankoonaniiwa, eb yon kuu bot arimbed wowaanban.’ ande wongkiwen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kumban Yesumbed man yedmoon, “Kekamune angkon God Ye Weng wongkiwen kuu, ‘Yiib Yariman God yaa komboon kaamobaib.’ ande wongkiwen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kwanandoon kowe, awad arewa yi korokbed Yesu nenwenene aangko ambab ari daanene kowoona doboroona, ambibkin koremiib korok dareb dareb yi aromkonoyiib korokbenoon. ");
INSERT INTO yon_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Korokbenekore Yesu yaa yedmoon, “Eb kuu ne yaa okad yiri bumangke ne dabderem aom dobere naningko kankoonaneeb kuu, korem komo komo wedmeeb kuu kabdaniina yi korok keraneeb kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kumban Yesumbed neman yedmoon, “Seten, koronde wene! Amborom kuu God Ye Weng aombed wongkoon kuu, ‘Yiib Yariman God yaamo bumangkane yaningkomo kankoonenib, ye yaamo wengambere kwanembirime.’ ande wongkoon kui.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kwane, awad arewa yi korok kuu koronde wonoone, engyus menenib Yesu yaa awanene ooniwen. ");
INSERT INTO yon_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aron maa, Yesu wengamboroonka Yoon Baptaisman kuu awine kan wii aom kaaniwen kowe, Yesu kuu ika Galeli ambibkin ari wonoon. ");
INSERT INTO yon_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kambong Nasaret koronde wene Kapeenaum aom doboroon, amyenimbon Sebulun yoom amyenimbon Naftalai yoom yi bidambib aom, bowan Galeli kebed yaa. ");
INSERT INTO yon_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kwane, komo komo profesiman Aisaiyambed wongkoon kuu anam kwamune id keroon. Ande wongkoon kuu ");
INSERT INTO yon_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Galelidan, amyenimbon Sebuluniib amyenimbon Naftalaiyiib kui. Karamok wini ye kiwaan kuyiib, ok Yooden yara kuye okad kui. Yuudan yoom ambibkin maa maadan yoom kui. ");
INSERT INTO yon_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yi kuu bobniyiib ambarakmiyiib ye kumun aombed doriib kuu God ye nambiri darewoob kawure waroon kuu wedmiwen.” ande wongkoon. ");
INSERT INTO yon_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Galeli ari wonoon kuye aron kuyaambed Yesu andowe God Ye Weng kee daandenmo yaroon, “Yiib amonombime, amborom kuu Ewen Yarimanbed nimakarub yi korok kere ooni yaron kuu dia muneen kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kwane, Yesu kuu bowan ok Galeli kebed angka yare mene oon bi karub wedmendoon, ayi ningki. Yi kuu oon bi ye men kamberenib oon bandiwed. Yi aningko kuu Saimon yaningko maa Pita yoom Endru yoom. ");
INSERT INTO yon_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Wedmekore, yedmendoon, “Yiib kuu ne yoman minibko, oon bi areb Godiib yaa nimakarub bi ye kiwaan yiib yaa kedmengkanda.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Andoone, erebnariyiibban yimbed oon bi ye men nongkobiiwa, Yesu ye yoman kedmengkandok ande winiwen. ");
INSERT INTO yon_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kwane, kuyaambed wene ari angkon karub ayoob wedmendoon, ayi ningki, Yems yoom Yoon yoom. Yi kuu yi ambe Sebedi yoom oon bi motod aom oon bi ye men karangkane dibiib. Yi ayoob yaa kwangkon baande yedmendoona, ");
INSERT INTO yon_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","yi kwangkon erebnariyiibban yi ambeyiib oon bi ye meniib motodiib koronde Yesu ye yoman kedmengkandok ande winiwen. ");
INSERT INTO yon_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kwane, Yesu kuu Galeli ambibkin aom dewenebe, Yuudan yi kurikuri ambiwoombed kedmengkandene, Godbed yi korok kere ooni ye weng amun daandenmo yarebene, nimakarub bob anikadiib maa maa korem ongmenaboon. ");
INSERT INTO yon_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kwanoon ye weng kuu Siria ambibkin aom daande yareen. Weng kee daande yaraune, nimakarub bob anikad maa maa kandiwendaniib, niindem aom yewed darewoob kandiwendaniib, awad arewa ibnendiwendaniib, kot yimaundaniib, yona dingkia ida yidne wonoondaniib korem kwamune benmenebiiwe ongmenaboon. ");
INSERT INTO yon_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kwane, kadaareb yemoon kuu ye akmok winiwen, Galeli ambibkindaniib, Dekapolis ambibkindaniib, Yerusalemdaniib, Yudea ambibkindaniib, ok Yooden yara doriibdaniib kwane ye akmok winiwen. ");
INSERT INTO yon_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kwane, Yesumbed kadaareb menebiwen kuu wedmoonka, aangkombon ari ambabban kawenene dibeene, ye yoman winiwendan kuu yeyiib yaa wengamborok miniwen. ");
INSERT INTO yon_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Miniiwa, Yesu andowe kedmengkandene yedmoon, ");
INSERT INTO yon_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kane kane yi dobiri kankubune God ye dabderem aom dobirimaib kuu Godbed amun kerundoon, amborom kuu Godbed Ewen arimbed yi yaa korok kere oonimaan kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kane kane yuudi ameng kamiib kuu Godbed amun kerundoon, amborom kuu Godbed yi mimyob kankubunaneen kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kane kane ingmiyiibban nangkemmo kame dobiriib kuu Godbed amun kerundoon, amborom kuu okad korem yi yaa bangkandaneen kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kane kane yi dowaken darewoob kuu yorokmo dobiri kuu Godbed amun kerundoon, amborom kuu inamen yorokmo kee yi yaa bangkandaneena yiminmo keraniib kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kane kane yi yaa kuu karub maambed ambarakmoon yaa mimyob keene kakman kuu are nonondandaniib kuu Godbed amun kerundaneen, amborom kuu Godbed yi yaa mimyob keene yi ambarakmi are nonondandaneen kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kane kane niindem aom kuu karadmo kuu Godbed amun kerundoon, amborom kuu yi kuu God ye kerebiri wene wedmenaniib kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kane kane wedyiri dobere wengangkimaib kuu Godbed amun kerundoon, amborom kuu Godbed yiib kuu ne meed kii andaneen kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kane kane kuu God ye deme ambangkimaib kumbed karub yenambed yi kebeni ye dowad yewed konde yenbandiwen kuu Godbed amun kerundoon, amborom kuu Godbed yi yaa korok kere oonimaan kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Yiib kuu ne deme nimakarub kowe, ne dowad karub yenambed yiib yaa amkidbandenib yewed konde yenbandenib kwane dudi weng wiribenib kamaniib kuu Godbed amun kerundaneen. ");
INSERT INTO yon_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Meenmembaraib, kubime, amborom kuu Godbed yiib yaa kakman darewoob Ewen arimbed nongkobaneen kowe. Meenmembaraib, kubime, amborom kuu anuk kurin kwangkon profesidan kuu kwamune yewed konde yenbandiwen kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yiib kuu karam areb, okad karub korem yaa God ye weng amun ambod yeman. Kumban kwane karam ambod dowan keraneen kuu ikakman karam ambodiib kerok ande ongmaneen kuu yiminban. Kukuu korem amunban kowe, bunangka kankorarunde nimakarub kwari dore bungki yeman keraniib. ");
INSERT INTO yon_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yiib kuu nambiri areb, okaddan korem yaa ye nambiri kui. Kuu kwamune, siti aangko arimbed kuu biknindeban. ");
INSERT INTO yon_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kwane angkon nambiri nare kandune kabedbed nande ari dabunaanban. Dowan. Nambiri nare kandune wedangkambed nowaneenkob nimakarub korem ambiwoom doriib yaa nambaraneen. ");
INSERT INTO yon_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ibonmo kwamunene yiib amun kami kuu nambiri areb, kwangkon namborok nimakarub yaa. Yiib kwananiib kuu yi wedme yiib Ambe Ewen ari doreen yaa kubenib yaningko kankoonaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kwane, Yesu kadaareb yaa ika yedme daandoon, “Yiib ambarakme inamen arewa meenmaib. Ne kuu mene Mosesbed God ye amob wengambere wongkooniiwa profesidan yi wengiiwa bongme benkirarundande minindo. Ne kukuu amowiib wengiib dakme wongke kamiwen kuu kan anam id keri dowad manaan. ");
INSERT INTO yon_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yiib yaa ke anam yedmendaan kei. Weng embeng mana o weng wongki kuruwak mana kuu amob yaambed ma biknaanban, kwane danganeenkob wene kuye weng kundukiib profesi wengiib korem kuu anam id keraneen. ");
INSERT INTO yon_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Kane kanembed amob kembed embeng mimo korondoon kumbed yenamo kedmengkandaneen kuu, Godbed korok kere oonimbon kuyaombed kuu yi aningko kuu kan yiri nongkobaneen. Kumban, kane kanembed God ye amob korem kuu anam ande nimakarub yena yaa anam kedmengkandaniib kuu, Godbed korok kere oonimbon kuyaombed kuu yi aningko kuu kan ari nongkobaneen. ");
INSERT INTO yon_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kwane, yiib yaa ke yedmendaan kei, yiibka yiib yorokmo dobiri kuu yiibbed Farisidan yoom Yuudan yi amob kedmengkandidan yoom yi inamen burudande darewoob keraniib kumbedmo Godbed korok kere oonimbon aom awunaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Yiib wengambiriwen kuu unyeman anuk yaambed dakmoon kuu ‘Yiib kumkayiib o kumaniib yenbandaib. Kanembed kumkayiib o kumaniib yenbandaneen kuu wengyunde dabab darewoob konaneen.’ ande wongkoon. ");
INSERT INTO yon_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Kumban nembed yiib yaa ke yedmendaan kei, kanembed maa yaa norin wandaneen kuu, ye nenwananeene wengyundi ye korokbed dabab darewoob konaneen kuu yimin. Angkon kwane kanembed noriniib maa yaa eb kuu awon korok anamaa andaneen kuu, Suprim Kot yaa nenwananeene keye wengyundi ye korokbed dabab darewoob konaneen kuu yimin. Angkon kwane kanembed noriniib maa yaa eb kuu inameniibban anamaa andaneen kuu, kan kumbaanban yamotbon yiri koraraneen angkon yimin. ");
INSERT INTO yon_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kwane kowe, kanembed dingkan kanmenene aye nengkane agedmo kere baeb God yaa konande meneen kuyaambed meenoko maa yaambed eb dore ye dore dabawiib keroka, ");
INSERT INTO yon_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","dingkan kuu kurikuri keri yeman bot wuubiwen dia yaa kiribende wene dabokne weng mimo ongmekored menene kurikuri boyambib darewoob yaa dingkan aye bot ari kowe nengkane agedmo kere baeb God yaa koni. Kwananeeb kumbed yimin. ");
INSERT INTO yon_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kanembed eb nenwene kangdod weng dakmandameen kuu kudin kirodmo weng ongmekorewed, weng kuu kiwaan yaa ye yoom weniib yaa kumbed ongmenmo wene. Ma kwanaabban kuu eb kandune wengyundi ye karub konaneena kumbed kandune wii ye korok konaneena, yembed kandune eb kuu wii aom kaananeen. ");
INSERT INTO yon_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nembed eb yaa ke anam yedmebdaan kei, eb kirod yeedaraabban, kwane dobereneb od murubkob yeenbon kuu kowewed yimin. ");
INSERT INTO yon_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Yiib wengambiriwen kuu ‘Nenem kamaib.’ ande wongkoon, God Ye Weng aombed. ");
INSERT INTO yon_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","“Kumban nembed yiib yaa ke yedmendaan kei, karub kanembed wonong wedmende ye dowaken ambarakma ande meenaneen kuu dowan kii, ye inamen aombed wonong kuu nenem kamoon kii. ");
INSERT INTO yon_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Kwane kowe, eb wiwi yaa ye indobbed nemengkabdoko ambarakmebka, awine biangkan korare. Kwane, eb id dungkunmo kankoraraneeb kuu arewa kumban, eb id kumundin kande kumbaanban yamotbon yiri koraraneen kuu miin arewa anam. ");
INSERT INTO yon_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kwane, eb dingki wiwi yaambed nemengkabdoko ambarakmebka, nare kankorare. Kwane, eb id dungkunmo kankoraraneeb kuu arewa kumban, eb id kumundin kande kumbaanban yamotbon yiri koraraneen kuu miin arewa anam. ");
INSERT INTO yon_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kekamune God Ye Weng aombed yedmoon kuu, ‘Karub kanembed kwamune ye wonong dankoraroka ye kuu yu yaa dankorari ye kerekiib wane kankondaneen kumbed yimin.’ ande wongkoon. ");
INSERT INTO yon_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","“Kumban nembed yiib yaa ke yedmendaan kei, karub kanembed ye wonong ogood dankoraraneen kuu yiminban. Ma, yumbed nenem kameen kumbedmo dankorari kuu yimin, ogood dankorari kuu ye ambarakmi, yu kuu nenem wonong keranuun kowe. Kwamune angkon wonong kee karub maambed awananeen kuu ye nenem kami ye karub keraneen. ");
INSERT INTO yon_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Yiib wengambiriwen kuu nimakarub unyeman anuk yirimbed dobiriwen yaa God Ye Weng aombed dakmoon kuu, ‘Yiibbed wiim aangke amob ongmiwen kuu ika yiibkareb domokbaib’, kumban ‘Yariman ye dowad ongmiwen kuu kwamune oone awinime.’ ande wongkoon. ");
INSERT INTO yon_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","“Kumban nembed yiib yaa ke yedmendaan kei, wiim aangke amob ongmaib, no weng kunduk dakmime. Kowe kwamune Ewen yaningko kowe amob ongmaib, kukuu God ye oonimbon kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kwane, kan okad yiri yaningko yaambed amob ongmaib. Okad yiri kwangkon God yeman kowe. Angkon Yerusalem yaningko kowe amob ongmaib, kukuu King Darewoob Arimbed ye siti kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kwamune kande eb korok yaambed kowene amob ongmaib, amborom kuu ebkareb ma eb awung kuu ongmaawa kuukmo kere binmo kere kamindeban kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Kwana kowe, dowakeniib kuu no ee ande, o dowakeniibban kuu no yii ande kamime. Maa kee burudande dakmaneen kuu anam awad arewa yi korok yaambed inamen kande dakmaneen kii. ");
INSERT INTO yon_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Yiib wengambiriwen kuu, ‘Karub kanembed karub maa ye indob biangkandoka neman ye indob kwangkon biangkandi yeman, ma ningkambo domokboka neman kwangkon ye ningkambo domokbi yeman.’ andimaib. ");
INSERT INTO yon_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","“Kumban nembed yiib yaa ke yedmendaan kei, kanembed yiib yaa ambarakmoon kuu neman kakman inandaib. Kwane, kanembed eb angkatom yaa yakdaroka, angkarayiib kwane konebko wowok. ");
INSERT INTO yon_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kwane, kanembed eb awine kanwene kangdod kerubdene ebkad korok ari kuu nan kandandamoka, eb yuruk ebkad kuyiib konebko kwamune nandok. ");
INSERT INTO yon_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kwane, kanembed eb yaa dabawiib ye barang kee kanwene bid mimo domokbe angkarambed kowe ne yoom wenem andoka, kwane kanwene ye yoom yare bid ayoob domangke angkarambed kowe. ");
INSERT INTO yon_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","“Kanembed yiribman maawe ande kaamonoka, kone. Kwane, kanembed eb yaa yiribman maa dungkum kerandamaan kii andoka, koronde angkurom korokbenaab. ");
INSERT INTO yon_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Yiib wengambiriwen kuu, ‘Yiib dia doriibdan yaa mimyob keendime’, ma ‘Yiib bondan yaa kuu arud wandime.’ andimaib. ");
INSERT INTO yon_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","“Kumban nembed yiib yaa ke yedmendaan kei, yiib bondan yaa mimyob dowaken keendenib yiib yaa yewed konde yenbandiibdan yaa kwangkon kurikuriyiib kamime. ");
INSERT INTO yon_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yiib kwananiib kumbed yiib Ambe Ewen ari doreen ye dana meed keraniib. Yembed aron yedmoona yurenu amundaniib arewadaniib korem yaa yure kowimaun, am kwangkon kwane yedmaana yorokmodaniib arewadaniib yaa minimaun. ");
INSERT INTO yon_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Kwane, yiib yaa mimyob dowaken kerundiibdan yaamo mimyob dowaken kerundimaib kuu God ye kakmaniiwoo? Dowan! Arewadaniiwa tak od bimaibdaniiwa kwangkon kwamimaib kii! ");
INSERT INTO yon_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yiib kuu kwamune yiib angkodmia yaamo kubendi weng kamiib kuu arewadan yi inamen burudandiwenoo? Dowan! Kwane, God yaa anam andindodan kwangkon kwamimaib kii! ");
INSERT INTO yon_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Kwani kowe, yiib Ambe Ewen ari doreen ye God kuu demkoronmo, kwamune areb kuu yiib kuu demkoronmo dobirime.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kwane, Yesumbed nimakarub yemoon nedbiwendan yaa ika daandoon, “Yiibkaadkerime. Yiibbed kurikuriyiib amun kamiyiib kamboknondan yaa bangkandiyiib kamaniib kuu yimin, kumban nimakarub yi kiringkono arimbed yiibbed kwananiib yi wedmi ye dowad kamaib. Yiib kwamaniib kuu yiib Ambe Ewen ari doreen yaambed kuu ye kakman kandaibban. ");
INSERT INTO yon_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aadidmidan yenambed kurikuri ambiwoomiib kambong wedyayiib kuyaa wene nub aningko darewoob kerandiwed kuu kamboknondan yaa bangkandimaib, kibi kan komkanmo yarebe dakmenmo dewenebemoon areb. Yiib kuu kwamune kamaib. Kowe, nembed yiib yaa ke anam yedmendaan kei, yi kwamiib ye kakman kuu okad kirimbed korem kuu kandiwen kii, dowan. ");
INSERT INTO yon_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Kumban kamboknon karub yaa konande kameeb yaron kuu ebbed maa yaa kuye dowad dakmaab. ");
INSERT INTO yon_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kowe, eb kuu yeka yemyebbed bangkane. Kwane, eb Ambe Godbed komo yemyeb kamewen kuu wedmoon kowe, deme yemyeb awinewen kuye kakman kumbed kabdaneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kwane, Yesumbed ika dakmoon, “Aadidmidan yenambed yi dowaken darewoob kuu kurikuri ambiwoomiib kambong wedyayiib kuyaa wene dembe nub yaa wedmime andiwed kurikuri kamimaib. Yiib kuu kwamune kamaib. Nembed yiib yaa ke anam yedmendaan kei, yi kwamiib ye kakman kuu okad kirimbed korem kuu kandiwen kii, dowan. ");
INSERT INTO yon_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Kumban eb kurikuri kerebka, eb ambib wadnarimbon aom awune ambongko kebenekore, eb Ambe, wedmimokban ye God kui, ye yaamo kurikuri kere. Kwane, eb Ambe Godbed komo yemyeb kamewen kuu wedmoon kowe, komo deme yemyeb awinewen kuu ye kakman kumbed kabdaneen. ");
INSERT INTO yon_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“God yaa anam andindodan yi kurikuri dakmimaib kuu ogood weng yemoon idiibban kwamune ika ika dakmimaib. Yimbed meeni kuu weng yemoon God yaa daanuub kowe, anam amun wengaan andimaib. Kumban yiib kurikuri kuu kwamune kamaib. ");
INSERT INTO yon_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yiib kuu yi areb keraib, amborom kuu yiib Ambe God kuu yiib yaa komo dowan keroon kuu yedin ye wedme yekaadkeroon, komo weng ye yaa kaamonandameeb kuu. ");
INSERT INTO yon_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kowe, kekamuni ye kurikuri wengbed dakmime, ‘Nub Ambe Ewen ari dibeeb, ewaningko kuu karadmo ande kankoonuub. ");
INSERT INTO yon_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ebbed korok kere ooni yeman kuu munuk, eb dowakenmo yaambed korem kwanok, Ewen ari kwanimaib areb okad kiri kwamune kamimamok. ");
INSERT INTO yon_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kibikee nub dobiri ye animan kuu bangkandembere. ");
INSERT INTO yon_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kaneyambed nub yaa ambarakmiwen kuu are nonondanduwen areb kuu, kwamune ebbed nub ambarakmi yaa kuu are nonondandunde. ");
INSERT INTO yon_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kwane, ambarakmaniib dee andi ye kiwaan ari nub ben nongkobaab. No kwane awad arewambed nub yaa manaan ye dowad kuu nub benkoobe.’ kwane andime. ");
INSERT INTO yon_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kwane, yenambed eb yaa ambarakmiwen kuu are nonondandaneeb kuu eb Ambe God Ewen ari dibeen kwangkon eb ambarakmi kuu are nonondandaneen. ");
INSERT INTO yon_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma, kwamune yenambed eb yaa ambarakmiwen kuu are nonondandokban keraneeb kuu, eb Ambe God kwangkon eb ambarakmi yaa kuu are nonondandaanban. ");
INSERT INTO yon_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Aadidmidan yenambed animan koronde God yaa meenimo kamimaib yaron kuu yi kara karub yenambed wedmendi ye dowad kuu okambimokban angkon murubia kubiyiibban kamimaib kui. Yiib kuu kwamune kamaib. Nembed yiib yaa ke anam yedmendaan kei, yi kwamiib ye kakman kuu okad yirimbed korem kuu kandiwen kii, dowan. ");
INSERT INTO yon_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Kumban yiibbed animan koronde God yaa meenimo kami yaron kuu yiib murubia ari okambene yiib awung debime. ");
INSERT INTO yon_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kwaniwed karub yena kuu yiibbed animan koronde God yaa meenimo kamiib kuu kaadkerimban, kumban yiib Ambe, wedmindeban ye God kui, yembedmo yemyeb kami kuu wedmimaan. Kwamuniwed yiib Ambe Godbed yemyeb ye yaamo kwaniwen ye kakman kuu kondaneen. ");
INSERT INTO yon_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kwamunenib yiibkarebmo okad kiri keembed odamod benib amukmo amukmo kambaraib, amborom kuu bebeda kimkima kemengkoda dore wene anene monmaraniiwa yid bidanbed aande monmare dawuro baniiwa kamaniib kii. ");
INSERT INTO yon_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","“Kwane, Ewen arimbed yiib odamod kuu nongkobime, bebeda kemengkoda doraane monmarene yid bidanbed yid baibban. ");
INSERT INTO yon_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Eb odamoda yiribmana kunaya dibaraneen kuu ewiib kumoom kowaneen. ");
INSERT INTO yon_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Indob kuu eb id kumundin ye nambiri kii. Ma, eb indob amunmo keraneen kuu eb id kumundin aom nambirimo keraneen. ");
INSERT INTO yon_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma, kwamune eb indob arewa keraneen kuu eb id kumundin kumunmo keraneen. Kowe eb niindem aom angkeen kuu korem kumunmo keraneen kuu korem miin kumun darewoob kere wedmindeban keraneen kii. ");
INSERT INTO yon_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Karub mimo kumbed yariman maa ye deme kumundin awine yariman maa ye deme kumundin awine kamindeban. No ma koronde kongenekore, korondene maamo kube kone amun amunmo kamaneen. Yiib kuu God kuu yiib yariman kerene angkon od kuu yiib yariman kerene kamindeban. ");
INSERT INTO yon_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kuu kwamune kowe, yiib yaa ke yedmendaan kei, yiib wadkeri ye dowad komo oka animankambed ananiin kee ande meenmembaraib, nub id yaa kuu komombed derene borone kamanuub kee ande meenmembaraib. Wadkeri yaa ambangki ye deme kuu yemoon, animanmomban. Angkon id yaa ooni ye deme kuu ebkadmomban. ");
INSERT INTO yon_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Ayari on yaa meenime. Yi kuu yikareb animan kab arume wande ambiwoom amaan yeman amukmo nongkobe kamimokban, kumban yiib Ambe Ewen ari doreen kumbed bangkandembirimaan. Godbed meenimaan kuu yi kuu barang embeng, yiib kuu barang darewoob. ");
INSERT INTO yon_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Karub kanembed kwamune meenmembaraneen kumbed kwane aron awa mimo kande ye wadkeri yaa daboknaneenoo? Dowan! ");
INSERT INTO yon_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ma, komande yiib ebkad ye dowad meenmembirimaib? Kekamune nong wuung amuniib are weneen kuu meenime. Yi kuu yikareb ma deme awinimokban kerene yi ebkad ma ongmimokban. ");
INSERT INTO yon_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kumban nembed yiib yaa ke yedmendaan kei, King Solomon odamodiib yiribman yewud ye karub kuu nong wuung ye manimanandeb areb inwarindo. ");
INSERT INTO yon_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kereka nong wuunga kuu barang embengmo God yaa kowe, yi kuu kibikmo yeedere awari dene dowan kerimaan, kuned Godbed ongmaankob wuung kuu manimanandewiib kerimaan. Kumban yiib kuu barang korem miin amun yeman God yaa kowe, komandiwed yiib kuu ebkad yaa meenmimaib? Godbed yiib yaa bangkandimaan ee! Yiib anam andi kuu embengmo kii! ");
INSERT INTO yon_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kowe, meenmembaraib. Kwamune komo animanbed ananuub o komo okbed ananuub o ebkad kunambed be inwaranuub ande kamaib. ");
INSERT INTO yon_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwane, Godiibbandan kuu yiribman kee kwane nindorokiibbed kerekanmo yarembirimaib, kumban yiib meeni yiribman keyaa kuu yiib Ambe God yedin yekaadkeroon ");
INSERT INTO yon_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","kowe, ibduruk kuu Godbed yiib korok kere ooni ye inameniib ye yorokmo dobiri ye inameniib onme kamiwed. Kwamaniib kuu yiribman kee kuu kwamune Godbed yiib yaa bangkandaneen. ");
INSERT INTO yon_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kwane kowe, kibikbed awari komo keraneen ye dowad kuu meenmaib. Awari komo keraneen ye meenmi kuu yeka awari yeman. Awari ye dabawiib kibik ye dabawiib daboknaib. Yeka yeka kerok. ");
INSERT INTO yon_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Yena yaa wengyundaab, wengyundaneeb kuu eb kwangkon Godbed nen wengyundaneen, ");
INSERT INTO yon_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","amborom kuu yena yaa eb wengyundi areb kuu eb kwangkon Godbed nen wengyundaneen. Kwane, ebbed yena yaa kumunkingkimaab ye at kumbed kandene eb yaa kumunkinaneen. ");
INSERT INTO yon_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Komandewed angkodmi ye indob aom at mon embeng kuu wedme meene doreeb, kumban eb indob aom at kuruk darewoob kuu ebbed meenimokban? ");
INSERT INTO yon_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kedi, eb indob aom kuu at kuruk darewoob kwane angkeen kowe, komandewed eb angkodmi yaa yedmenaneeb, ‘Korondeewo nembed at mon eb indob aom kuu kankorara.’ andaneeb? ");
INSERT INTO yon_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Eb kuu aadidmi ye karub kii! Ibduruk kuu at kuruk eb indob aom kudin kankorarekoreb, wedmi yimin keraneen kumbed korobe wedmenewed eb angkodmi ye indob aom at mon kuu kankoraraneeb. ");
INSERT INTO yon_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kwane, komo kuu God ye karadmo yeman kuu kande wabkaddan yaa kondaab, kwananeeb kuu yi kuu wabkad anon areb kowe yimbed amonombesare ewiib kankowe ene bunganiib. Kwane, God ye odamod awinewen kuu kande wabkaddan yaa koraraab, kwamunaneeb kuu yi kuu wabkad awon areb kowe animari dore bunganiiwe kan yon dowood yeman keraneen. ");
INSERT INTO yon_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kawe ande kaamone. Kaamonaneeb kuu Godbed kankabdaneen. Onme. Onmaneeb kuu Godbed korokbebdaneene wedmaneeb. Ambongko yaa wangke. Wangkaneeb kuu Godbed eb yaa nandaneen. ");
INSERT INTO yon_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kedi, kanembed God yaa kawe ande kaamobaneen kuu ye yaa kondaneen. Kanembed onmaneen kuu Godbed korokbenaneene wedmaneen. Kanembed ambongko yaa wangkaneen kuu Godbed ye yaa nandaneen. ");
INSERT INTO yon_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Yiib aom kumbed kane ye danambed om ande kaamonaneen kuu koronde botbed kankonaneenoo? ");
INSERT INTO yon_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kane ye danambed okyiri oon ande kaamonaneen kuu koronde niindokbed kankonaneenoo? ");
INSERT INTO yon_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kwane, yiib kuu arewadan kumban, kwamune yiib dana yaa munob bangkandi amun benbangkandi kuu yiibkaad kowe, yiib Ambe Ewen ari doreen kuu yiib inamen burudandene, kane kanembed ye yaa kaamonaniib kuu munob bangkandi amun amun yeman bangkandaneen. ");
INSERT INTO yon_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Eb dowaken karub maambed eb yaa komo kami areb kuu ebbed ye yaa kwangkon kwane kame. Weng kee God ye amowiib profesidan yi wengiib korem yi inamen kui. ");
INSERT INTO yon_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ambongko embeng kumbed dawuro wene, amborom kuu kumbaanban yamotbon ye kiwaan kuu ambongko darewoowiib kowe. Kiwaan yirimbonmo kee nimakarub yemoon kuu wenebiib. ");
INSERT INTO yon_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kumban wadkeri ye kiwaan kuu ambongko embengiib. Kiwaan yobdood kee nimakarub yemoonbanmo wedmo wenebiib. ");
INSERT INTO yon_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kaadkerime. Kwamunene dudi god yi profesidan yaro menebaniib kii. Yi kuu sibi yi akmi areb kuu inamen amuniib areb yiib yaa mananiib kii. Kumban anam kuu, yi niindem aom kuu arud dura anon areb kii. ");
INSERT INTO yon_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","“Kumban, yi kami kuu at yob komarewa iraneen areb kumbed wedmende yiibkaadkeraniib. Ma, karub kuu nongyikdem aom kumbed ayob amun ani yeman bimaib dee, yedob kuu yiriwad arimbed bimaib dee? ");
INSERT INTO yon_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kekamune at amun korem kuu at yob amunmo iraneen, kumban at arewa kuu yob kwangkon arewamo iraneen. ");
INSERT INTO yon_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","At amun kuu yob arewa dibaraanban, at arewa kuu yob amun dibaraanban kii. ");
INSERT INTO yon_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","At korem kunambed yob amun diborokban kuu nanmaneena kuburaneena be amot yiri nengkaneen. ");
INSERT INTO yon_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kowe, at yob yaambed at amun dee arewa dee wedmendaneeb areb, kwangkon nimakarub yi kami yaambed inamen amun dee arewa dee wedmaneeb. ");
INSERT INTO yon_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nimakarub korem ne yaa ‘Yariman Yariman’ ande kamiib kuu Godbed oonimbon aom awunaibban, kwamune yeka Nambe Ewen ari doreen kuye dowaken deme anammo awinoonman kumbed kuyaom awunaneen. ");
INSERT INTO yon_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wengyundi yaron arimbed, nimakarub yemoon daawaniib, ‘Ne Yariman ee! Eb aromkono yaambed eb weng amun ben dakmenub awad arewa yedme yenburenub God yaromkono wedmi yeman yemoon kamuwen kii.’ andaniib, ");
INSERT INTO yon_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","kumban ne weng dianmoyiib yedmendaniin, ‘Yiib kuu ne nimakarubban, ne yaa koronde winime, yiib kuu ne amob domabangke ambarakmembirimaib kowe.’ andaniin. ");
INSERT INTO yon_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kwane kowe, kane kanembed ne weng kee wengamberekore kankowe awinaniib kuu, yi korem kuu inamen kangdom meenimaan ye karub yambib kuu okad kamkonombon bot areb arimbed yenboon areb. ");
INSERT INTO yon_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kwane, am darewoob meneboona ok derebuuna nuub kenambun mene ambib nan yoboon kumban, ambib kuu okad kamkono arimbed arumoon kowe, nan monmarindo dobureen. ");
INSERT INTO yon_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Kumban, kane kanembed ne weng kekee wengamberekoriwa kwamune kankowe awinokban keraniib kuu, yi korem kuu inameniibban karub yambib kubuk arimbed yenboon areb. ");
INSERT INTO yon_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kwane, am darewoob meneboona ok derebuuna nuub kenambun mene ambib nan yobene nan monmaroona kankawene kuweng darewoowiib korem monmareen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu weng kee dakme dowan keroona, nimakarub korem kuu ye kedmengkandi yaa binangkiwen, ");
INSERT INTO yon_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","amborom kuu ye kedmengkandi kuu arimbed God yaromkonoyiibbed kedmengkandemoon areb, Yuudan yi amob oone kedmengkandidan arebban. ");
INSERT INTO yon_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kwane, Yesu kuu aangko kaad angkambed kuburoona kadaareb yemoon ye yoman kerenenmo winiwen. ");
INSERT INTO yon_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kaningki bowiib ye karub kwangkon menene Yesu ye murubia ari dangbodin bumangke yedmoon, “Yariman, eb dowakeniib keroka ebbed ongmewebko amun kere ne karub yaa ika dabokna.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kwane, Yesumbed ye dingki yirene karub yaa angkoronene yedmoon, “Ee, ne dowaken keraan ee. Kwane amun kerok.” andoone kirodmo ye kaningki bob kuu amun keroon. ");
INSERT INTO yon_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kwane, Yesumbed karub yaa yedmenoon, “Wengaawoo? Eb wenenduneb karub yena yaa dakmenmo yaraab. Kumban ebka wene eb id kuu God dore Yuudan dore wedyiri ye karub yaamo wene korokbene. Kwane, kaningki bob aroon ye amob Mosesbed yedme kowoon kuu kwane dingkan nengkebko agedmo keroko God yaa baeb kone. Kwananeeb kuu eb yaa komarewa keroon kuu yi yaa anam kwanoon ye dowad kowe, kwane.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kwane, Yesu kuu taun Kapeenaum aom aomnoona, Romdan yi ana nangmi korok maa menene Yesu yaa yedmako awawok anded ");
INSERT INTO yon_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kwane yedmoon, “Yariman, ne deme karub kuu yona dingkia ida yidne wonoona durud yewed miin arewayiib ambiwoom angkeen kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Andoone, Yesumbed ye yaa yedmoon, “Ee, nembed wene ongmaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Rommanbed inande yedmoon, “Yariman, ewaningko kuu ari, ne kuu yirimo kowe, ne kuu yiminban, eb nende nambiwoom wini kuu. Kowe kwamune no wengmo yedmebko ne deme karub kuu amun kerok. ");
INSERT INTO yon_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ne kangkon ne korokbed deme kawiwen yi dabderem aombed doriin, kwane angkon ana nangmi karub yena kuu ne dabderem aom doriib. Nembed yedmeni kuu wene andaina kuu wene, kee mene andaina kee mene. Ne dabderem yiri dobere no deme awinembiri ye karub yaa kee awine andaina kuu awinimaan kamimaib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kwane, Yesumbed kuye weng kuu wengamberekore binangke ye yoman meniibdan yaa yedmendoon, “Nembed yiib yaa ke anam yedmendaan kei, karub kee areb Israel aom karub mamaa God yaa anam andi darewoob kwamune meeni karub ma wedmindo. ");
INSERT INTO yon_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kwane, yiib yaa ke yedmendaan kei, yemoon kuu okad yimin yimin yaambed menebaniib kii. Yi mene Abraham Aisek Yekob awene ibonmo korem Ewen aom orokbon ari dibaraniib, ");
INSERT INTO yon_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","kumban Yuudanbed nub kuu God ye karuwa nimaya andimaib kuned, yi anam andi kuu dowan kowe yi yemoon kuu Ewen aom awunaibban, be bunangka kiraraneene kumun yiri doberenib amengiib durud yewed ye ningkambo kabangiib kamaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kowe kwanandekore, Yesumbed ana nangmi korok yaa yedmoon, “Ebbed God yaa anam andewen kumbed kwananeen. Kowe, ika wene.” andoon. Kwamune kuyaambed ye deme karub kuu amun keroon. ");
INSERT INTO yon_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kwane, Yesu menene Pita yambiwoom awunene wedmoonka, Pita ye anodkan kuu anikad darewoob kande angkimbon ari angkuun. ");
INSERT INTO yon_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kwane, Yesumbed yu dingki yaa angkorondoona anikad yu yaa dowan keroon. Dowan keroona, yu yaro diberenu ye animan nekwe mengke bangkaneen. ");
INSERT INTO yon_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kwane, miriknoona awadbed ibnendiwendaniib bob anikad maa maadaniib yemoon be menebiiwe, Yesumbed God yaromkono yaambed dakme awad arewa kuu yenburene, bob anikaddan kuu ongmenabene kamoon. ");
INSERT INTO yon_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kekee kwamune kamoonkob, profesiman Aisaiya yaambed God Ye Weng kunduk kuu kwane anam id keroon. Kwane dakme wongkoon kuu, “Nub durud yewediib nub bob anikadiib kuu yembed mimyob darewoob keende kan karinoon.” ande wongkoon. ");
INSERT INTO yon_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kwane, Yesu kuu nimakarub yewudmo yi angkara kanawanewandiwena, wedmekore ye kedmengkandeendan yaa yedmoon, “Parai motod nekwime. Bowan yara yanem.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kwane, Yuudan yi amob kedmengkandi ye karub mamaa menene yedmoon, “Kedmengkandi korok ee, kuna yaa wananeeb kuu ne kuu eb yomanmo yarebaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kwane, Yesu neman inande yedmoon, “Ba oot kuu yi demiib, ayari on kuu yi amiyiib, kumban Karub Ye Mingki kuu ye yiidkimboniibban.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kwane, ye yoman winimaib ye karub mamaa menene yedmoon, “Yariman, ee andebko ibduruk kuu domoweewo wene nambe mangkekorid, eb yoman mana.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kumban Yesumbed yedmenoon, “Ne yoman mene. Korondebko dukniwendan kuu yikareb yi bob kuu yika mangkanabime.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kwane, Yesumbed parai motod aom awunoona ye kedmengkandeendan kuu yiyiib awune winiwen. ");
INSERT INTO yon_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wene wedya kuu kudmeniibban kumbed, nuub darewoob kanmonoona bowan ari oknondok darewoob kanyere motod kanyobe ok ambungkeen. Kumban Yesu kuu unuk angkoon. ");
INSERT INTO yon_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kwane, kedmengkandeendan wene angkoon yiri kaakmene dakmiwen, “Yariman ee! Eb deere nub awande, nub kuu ok kubunandamuub kii!” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ye deere yaro yedmendoon, “Yiib anam andi kuu embengmo kii, komande yiib kuu uni darewoob keriwen?” andekore, yaro dore nuuwiib oknondokiib kuu weng kone nandoon. Kwanandoona, kirodmo nuuwiib oknondokiib kuu dowan kereen. ");
INSERT INTO yon_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kwane, yi kuu binangkenib yikareb kaamobiwen, “Karub keyaamo komarewa kii! Nuuwa oknondoka kuu miin ye weng kuu wengambaraniibmo kowe yii!” ande kamiwen. ");
INSERT INTO yon_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kwane, ye kuu ok yara yaro wirinoon, Gadaren ambibkin yaa. Karub ayoob awad arewambed ibnendiwendan kuu arud darewoob wande yeremborom keriwen kowe, karub maa dangkoro yimbed doriib kuye okad kuyaa dore dewinindeban. Yi kuu botdem bobkonobon aom doriib kumbed, mene Yesu durune nandiwed. ");
INSERT INTO yon_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mene komkiwen, “God ye Mingki kii! Nub yaa komo kamendandewed? Eb kuu meneeb kuu nub yaa durud yewed bangkandandewedoo? Yewed kondi yaron Godbed kowoon kuu dia kerindo kii!” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bid angkara yimbed doriib dia kuu awon karakiib doro anengkanan yariib kowe, ");
INSERT INTO yon_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","awad arewambed Yesu yaa eekmiwen, “Kwane, nub kuu yenbure be angka kirarebka, yedmeewo wene awon yi niindem aom awunem.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kwanandiiwe, Yesumbed yedmendoon, “Winime!” andoone yi deere yaro dore wene awon niindem aom awuniiwa, awon korem aangko kaat angkambed kibiradare wene ok bowan yiri kubune ok konok anenande wenenib yoworiwen. ");
INSERT INTO yon_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kwane, karub doro awon ooniwendan kuu wedmekoriwa, yi kibiradare wene komo keroon ye weng kuu taun aom dakmiwen, karub ayoob awad arewa ibnendiwendan kwangkon yi yaa komo kerooniib korem. ");
INSERT INTO yon_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kwaniiwe, taundan korem wene Yesu wedmenande winiwen. Wene wedmenekoriwa, eekme daaniwen, “Eb kuu nub okad keyaom koronde ika wene.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kwane, Yesu kuu parai motod aom awunoona, ok bowan yara ika yanenib, ye taun dobirimaan aom miniwen. ");
INSERT INTO yon_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Karub yenambed karub id yidnoona keta ari angkeen kuu Yesu yaa kanminiwen. Kwane, Yesu kuu yi anam andi wedmendekore, id yidnoon karub yaa yedmoon, “Ne dana, eb niindem aom aromne. Eb ambarakmi kuu are nonondandoon.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Andoone, Yuudan yi amob kedmengkandidan yena kuu wengambiribka, yikamo dakmiwen, “Karub kee God ye yumbon kandandamoon kowe, God yaningko monmaroon kii!” ande kamiwen. ");
INSERT INTO yon_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kumban Yesu kuu yi inamen yekaadkeroon kowe yedmoon, “Komandiwed yiib kuu kwamune arewa ye inamen yiib niindem aom meenimaib? ");
INSERT INTO yon_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Komarewa kere yedmaniin kumbed yobdoodban keraneen, eb ambarakmi kuu are nonondandaan andi dee, no yedmeni yaro dore wene andi dee? ");
INSERT INTO yon_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kumban ne dowaken yiib kaadkerime andid, ne kuu Karub Ye Mingki okad yiri kuu aromkono Godbed kawoonkob, nembed nimakarub yi ambarakmi yaa are nonondandi kuu yimin kuu kei.” andekore, id yidnoon karub yaa yedmoon, “Eb yaro dore, eb keta kande ambiwoom wene.” andoona, ");
INSERT INTO yon_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","karub kuu kwane yaro dore ambiwoom wonoon. ");
INSERT INTO yon_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kwaniiwa, nimakarub korem wedmekoriwa, unimbed God yaningko kankooniwen, amborom kuu Godbed yaromkono darewoob kee karub keyaa konoon kowe. ");
INSERT INTO yon_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kwane, Yesu kuyaambed yaro dore wenene wedmoona, karub yaningko Matyu kuu tak od bi ye ambib mana aom dibeen. Kwane, Yesumbed yedmenoon, “Ne yoman mene.” andoone, Matyu yaro dore Yesu ye yoman wonoon. ");
INSERT INTO yon_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kwane, Yesu kuu Matyu yambiwoom awune dibere animan aneena, karub yemoon tak od bidaniib Yuudan yikanmo yi amowamob awinindodaniib menenib animan aniib ye yoom ye kedmengkandeendan yoom ibmo. ");
INSERT INTO yon_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kwane, Farisidan kuu wedmendekoriwa, ye kedmengkandeendan yaa kaamondiwen, “Komande yiib kedmengkandi korok kuu tak od bidan yoom ambarakmidan yena yoom animan ibmo aniib?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu kuu yi weng wengamberendekore yedmoon, “Kukuu kwamune, dokta kuu amunmo doriibdan yi dowadban, bob anikaddan yi dowad. ");
INSERT INTO yon_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kumban wenebenib God Ye Weng ye id komarewa dakmeen kuu meenime. Godbed yedmoon, ‘Ne dowaken kuu mimyob kowi awine, aye ningke agedmo kere konimban.’ andoon. Ne kuu kwamune mene yorokmodan amonombime andi dowad minindo, ambarakmidan yaa amonombime andi dowad manaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kwane, Yoon ye kedmengkandeendanbed mene Yesu yaa kaamoniwen, “Komarewakob, nuwiib Farisidaniib kuu animan koronde God yaa meenimo kamimaub, kumban ma eb kedmengkandeebdan kuu kwanimokban?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kwane, Yesumbed neman inandoon, “Wonong awanandameen ye karub yangkodmia ye yoom doriib kuu yuudi ameng kamimaiwoo? Dowan! Kumban aron mananuuna wonong awanandameen ye karub kuu nendaneenkob, yi domondaneen kumbed yi kuu animan koronde God yaa meenimo kamaniib. ");
INSERT INTO yon_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kuruweng kei. Karub maa kuu ebkad barad yeweb kuu kandune ebkad kurin biringkoon ye dem yaa kowe kaaroon karen, ogoone ebkad barad nedbeene ebkad kurin kumbed dem darewoowiib arewa keroon karen. Kwani kowe, korem kwamimokban. ");
INSERT INTO yon_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma, karub maa wain ok yeweb kandune wain ok yowo ba kadbed kurin ongmiwen aom bunoon karen, wain ok kabayingke kad biringke wain ok kuu onduknoone wain ok yowo korem arewa keroon karen. Kwani kowe, kwamimokban. Yi wain ok yeweb kuu wain ok yeman ba kadbed yeweb ongmiwen aombed bune nowaniibkob kwane okiib ok yemaniib kuu amunmo dangembaraneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu kuu kwane daandeena, Yuudan yi korok maa mene Yesu ye murubia arimbed dangbodin bumangkene yedmoon, “Ne mungkan kibirebmo bobneen. Kumban, no meneneb eb dingkimbed angkorondebko ika wadkeruk andid.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kwanandoone, Yesu yaro dore Yuudan yi korok yoom winiiwa, ye kedmengkandeendan kwangkon yiyiib dabokne winiwen. ");
INSERT INTO yon_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kuye niindem aombed wonong maa andemwuroon kuu weeb benme benmeyiib kereen kuu ye yoman yaro menenu Yesu yebkad dungkun yaa angkoroneneen, ");
INSERT INTO yon_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","amborom kuu yukareb yedmeen, “Yebkad yaa angkoronaniin kumbed wadkeraniin.” andeen. ");
INSERT INTO yon_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kwanuune, Yesu amonombene wonong kuu wedmende yedmendoon, “Dana, kub niindem aom aromne dobere. Kub anam andi kumbed ongmebdoona wadkereeb kii!” andoon. Kwanandoon kumbed kirodmo wonong kuu andemwuroon kuu dowan keroona wadkereen. ");
INSERT INTO yon_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kwane, Yesu kuu Yuudan yi korok yambiwoom awunene wedmoona, yurin wudmenabidan yuudi ye yook wudmiiwiib nimakarub yemoon kuweng darewoob kamiwen. ");
INSERT INTO yon_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wedmoonka, yedmoon, “Yiib korem wenebime. Wonong koyu kee bobnindo, no kwane unuk angkeen.” andoon. Kumban yimbed ye yaa ambon kameniwen. ");
INSERT INTO yon_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kwane yaro nimakarub yedmoona bunangka angkaniiwa, Yesu dawuro wenene yu dingki yaambed awine kankoonoone wadkere yeedureen. ");
INSERT INTO yon_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kuye weng kuu benwenebe darewoob kereen, okad kuu doriib aom korem kuu. ");
INSERT INTO yon_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kwane, Yesu kuyaambed yaro dore weneena, indob tut karub ayoob ye yoman menenib komkanmo miniwen, “Dewid ye Awo! Nub yaa mimyob keende!” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu kwane ambiwoom awunoona, indob tut karub ayoob ye yaa miniiwe, yembed kaamondoon, “Yiib meeniib kuu ne yimin ongmendaniin ande kwane meeniiwoo?” andoone, “Yariman, ee!” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kwane, Yesu kuu yi indob yaa angkorondene yedmoon, “Yiib anam andi kumbed amun kerundok.” andoone ");
INSERT INTO yon_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","yi indob amun keroon. Kwane, Yesumbed ye kaadkerime weng kee kamkonomo daandoon, “Karub yena yaa yiib dakmaiwa kaadkeraib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kumban yi kuu wenenib, karub korem kuna kuna dakmenmo yariiwa kuye ambibkin kumaom korem kaadkeriwen. ");
INSERT INTO yon_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yi ayoob kwamune angkane winiiwa, karub awad arewayiib ibnenoon korem wengwaab nenminiwen, Yesu yaa. ");
INSERT INTO yon_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kwane, Yesumbed awad arewa kuu anburoona karub wengwaab andowe weng dakmoon. Kadaareb kuu wedmekoriwa, binangke kenangkanib dakmiwen, “Ayii! Kwamune keroon kee ma kwamune Israel ambibkin aom ma kwanoona wedmindo ii!” ande kamiwen. ");
INSERT INTO yon_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kumban Farisidanbed yedmiwen, “Kukuu awad arewa yi korok darewoob yaromkono kandekore, awad arewa kuu yenbudmeenkob yaro wenebiib.” ande kamiwen. ");
INSERT INTO yon_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu dewenebene taun yemooniib kambong yemooniib yi kurikuri ambiwoombed God ye weng amun dakmene kedmengkandene bob anikad maa maa ongmenabenmo yareboon. ");
INSERT INTO yon_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kwane, Yesu kuu nimakarub yemoon menebiiwe wedmendekore, mimyob keendoon, amborom kuu aromkonoyiibbaniib dabawiib doriib, sibi areb yi ooni karuwiibban, dowan. ");
INSERT INTO yon_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kwane, Yesu ye kedmengkandeendan yaa daandoon, “Nimakarub kee, mongkobon animan yumune bi yeman karakiib areb, kumban yarebe bidan kuu yemoonban. ");
INSERT INTO yon_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kwanekob, yiib kuu yongbon benmo yarebi yeman ye Yariman kaamonenibko, yembed ye deme karub yaa yedmaneenkob mongkobon yumunoon angka bok wananiib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kwane, Yesumbed ye kedmengkandeendan wad ayoowiib yedmoona miniiwa yaromkono bangkandoon, awad arewa yenburi yemaniib, bob anikad ongmenandi yemaniib, kui. ");
INSERT INTO yon_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Apasodan wad ayoowiib yi aningko kuu kei. Saimon yaningko maa Pita yoom, ye daman Endru yoom, Yems Sebedi ye mingki yoom, ye daman Yoon yoom, ");
INSERT INTO yon_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip yoom Baatolomyu yoom Tomas yoom, Matyu tak od bi karub yoom, Yems Alfeyus ye mingki yoom, Tedeus yoom, ");
INSERT INTO yon_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon nubka oone doberem ande nangboonman yoom, Yudas Iskeriot Yesu yaa ambodangoon ye karub, kui. ");
INSERT INTO yon_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Karub wad ayoob kee Yesumbed kwamunime andi ye weng wenebe dakmi dowad yedmoon, “Kwane, Yuudan yi ambibkin bunangka wanaib, Samariadan yi taun aom kwangkon awunaib. ");
INSERT INTO yon_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yuudan yaamo winime. Yi kuu sibi bikderebiwen areb kii. ");
INSERT INTO yon_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yiib winibka weng kuu kekamune kedmengkandime, Godbed yi korok kere oonendaneen yaron dia doreen kii, ande dakmenmo yarebime. ");
INSERT INTO yon_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bob anikadiibdan kuu ongmenandime, bobnaneen kuu yedmibko wadkerok, kaningki bowiibdan kuu ongmiiwo amun kerundok, awad arewa ibnendiwendan kuu yenburiiwo angkanime. Yiib kuu munobmo kekamune biwen kowe, kwari kwangkon munobmo bangkandime. ");
INSERT INTO yon_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yiib kuu ma od goldiib od silvaayiib od kapayiib be yarebaib. ");
INSERT INTO yon_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kwane angki yeman ye men aweneyiib baib, ebkad maayiib baib, yonkad ayoob ayoob bimban, yonamad kandimban, amborom kuu kanembed weng amun deme awinoon kuu animan awene ye kakmaniib kowe. ");
INSERT INTO yon_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kwane, wene taun o kambong kuna aom dawunibka karub amun kuu kane ande kaamonime. Inandibka karub kuyaa wene kwane yambiwoom kumaombed dobirime. Doberenib kumbed wene wini yaron keraneen. ");
INSERT INTO yon_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ambib kumaom awunibka kumaom doriibdan yaa Godbed amun kerundok andime. ");
INSERT INTO yon_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kwane, yi kuu kubimbed yiib yoom doberenib keroka, yiib amun kerundi angkimborok. Yi kuu kwanaibban keroka, yiib amun kerundi yiibka ika bime. ");
INSERT INTO yon_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ma, kanembed kwane yiib yaa kubiyiibban kerene yiib weng wengamborokban keribka, yiibbed no yaro kumaom koronde yi inamen arewa korokbi dowad yonkadmo wangkibko ingkud kuu kuri kuburoko burudande winime. ");
INSERT INTO yon_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nembed yiib yaa ke anam yedmendaan kei, Godbed wengyundaneen yaron ari Sodomdaniib Gomoradaniib yi dabab kuu yirimbed, ma kambong o taundan yiib weng wengamberedandaniib kuu dabab miin darewoob kandaniib. ");
INSERT INTO yon_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kedi, nembed yiib ben yedmaana weniib, sibi bene kandune dura anoniib aom kiribemoon areb kerundaane weniib, kowe kaadkerime. Arewayiib amuniib ongme andangke amunmo dobirime. Kumban ambarakmiyiibban nangkemmo dobirime. ");
INSERT INTO yon_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yiibka kaadkerime, karub yenambed yiib benwene kangdod weng wengyundandaniiwe yi kurikuri ambiwoombed nong dungkun ari yikiib kumbed yenbandaniib. ");
INSERT INTO yon_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kwane, yiib kuu ne karub kowe, yiib kuu benmene Yuudaniib Yuudanbaniib korok korokiib kingiib yi murubia arimbed wengyundaniiwe, ne weng yiibbed dakmenabaniib, yi kaadkeri dowad. ");
INSERT INTO yon_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kumban yiib kuu kwane awingkane wii aom kaaribka, binangke unaib. Komo weng dakmanuub o komandanuub ande meenaib. Weng korem kuu Godbed yiib yaa weng konde inamen nandaneena dakmaniib. ");
INSERT INTO yon_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kukuu yiib aromkono yaambed kwane dakmaibban, yiib Ambe God ye Kingkin Karadmombed ibnendene dore yiib yaa daandaneena kwane yedmaniib. ");
INSERT INTO yon_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ambangambed ningkia ambodanganiiwa yeene nongkobaniib, ningkiambed ambanga yaa kangkon. Awodkia kangkon yi dana meed yaa ambodanganiiwa yeene nongkobaniib. Kwane, dana meed kuu arian yaa manmo kerekorib, yena yi dingki ari nongkobaniiwe yaniiwe duknaniib. ");
INSERT INTO yon_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nimakarub korem kuu yiib yaa arud darewoobmo wandembirimaib, amborom kuu yiib kuu ne karuwa nimaya kowe. Kumban, kanembed ne weng awinenmo dobaraneenkob wene yimin wandaneen kuu, Godbed burudande bindaneen. ");
INSERT INTO yon_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kwane, yiib kuu kambong maa aom dobiribko yenbandibka, kumaom kuu kirodmo koronde wene kambong maa aom winime. Nembed yiib yaa ke anam yedmendaan kei, yiib kuu Israeldan yi kambong korem kuu kwane yarebe daande dowan keraibban ye niindem aombed, Karub Ye Mingki, ne mananiin. ");
INSERT INTO yon_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kedmengkandeen ye karub siku aom doreen kuu ye korok bidkone daanaanban. Ma, deme karub mene ye korok burudande kawanaanban. ");
INSERT INTO yon_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kwane, kedmengkandeen ye karub kuu ye korok areb keraneen kuu yimin. Ma, deme karub kwangkon ye korok areb keraneen kuu yimin. Yimbed ne yaa eb kuu awad arewa korem yi korok darewoob ande yedmimaib kowe, ne karuwa nimaya yaa weng miin arewa kwangkon daandaniib kii. ");
INSERT INTO yon_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kwani kowe, yiib kuu yi yaa unaib, amborom kuu yimbed komo yemyeb kamiiwe wedmindo kerenib komo be bikniwen kuu Godbed dianmo nongkobaneen kowe. ");
INSERT INTO yon_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kwane kowe, komo kumun aombed dakmaan kuu kande aronkimbon dian angkambed kowe dakmime. Komo koraaweng kerendem angkamo wengambereeb kuu kanmene kambong wedangkambed dakmime. ");
INSERT INTO yon_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Kanembed yiib id yenbandaniiwe duknaniib kumban yiib kingkin yenbandindeban kuyaa unaib. Kumban God yaambedmo anam unime, amborom kuu yembedmo yiib idiib kingkiniib yeene monmare be kumbaanban yamotbon yiri kirari kuu yimin kowe. ");
INSERT INTO yon_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Yiibkaadoo? Ayari on berekmad ayoob kuu ani yeman berengkimaib kuu od murubkob mimombed, od darewoobban. Kumban, mimo kuu okad yiri ma kombaraanban, yiib Ambe God yekaadkerindombed kuu. ");
INSERT INTO yon_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kwane, awung yiib korok ari kuu korem Godbed kimingkaan ");
INSERT INTO yon_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","kowe, yiib unembaraib. Godbed yiib yaa mimyob dowaken darewoob kowoon, on berekmad yaa arebban. ");
INSERT INTO yon_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kwana kowe, kanembed nimakarub yi arinambo arimbed doberene, ne kuu Yesu yaa anam andaan andaneen kuu, nembed ne Ambe Ewen arimbed doreen ye arinambo arimbed ye kuu ne karub andaniin. ");
INSERT INTO yon_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kumban kanembed nimakarub yi arinambo arimbed dobere, ne kuu Yesu yaa wunekaraan andaneen kuu, nembed ne Ambe Ewen arimbed doreen ye arinambo arimbed ye kuu wunekaraan andaniin. ");
INSERT INTO yon_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ne kuu okad yiri nangmiyiibban amunmo dobiri dowad manaan kuu kwamune meenaib. Ne kuu nangmiyiibban nangkemmo dobiri dowad minindo, kumana anaya ye dowad manaan. ");
INSERT INTO yon_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ne kuu meneni ben amonombaane, ‘dana mingkimbed yaro dore awodki yaa nangmoko, mungkanbed yaro dorenu awaan yaa nangbuko, wonongbed yu anodkan yaa nangmuko kami ye dowad manaan. ");
INSERT INTO yon_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Karub ye bondan kuu yika yikareb yambib kumaommo.’ ");
INSERT INTO yon_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kanembed awodki o awaan yaa mimyob dowaken darewoob kerene ne yaa mimyob dowaken kowi burudandaneen keraneen kuu, ne karub andainban. Kanembed dana mingki o mungkan yaa mimyob dowaken kowi darewoob kerene ne yaa mimyob dowaken kowi burudandaneen keraneen kuu, ne karub andainban. ");
INSERT INTO yon_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kwangkon, kanembed ye at ming kankarine ne yoman monokban keraneen kuu, ne karub andainban. ");
INSERT INTO yon_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kanembed ye wadkeri amuknaneen kuu wadkeri aron korem korem kandaanban, ma ne dowad yaambed wadkeri ye meeni kankubunaneen o bobnaneen kuu wadkeri aron korem korem kandaneen. ");
INSERT INTO yon_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kanembed kubebdaneen kuu kwangkon ne yaa kubewaneen kii. Kwananeen kuu Godbed yedmoona manaan kowe ye kwangkon God yaa kubenaneen kii. ");
INSERT INTO yon_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kwane, kanembed profesiman kuu wedme ye deme yekaadkere kubene ambiwoom nenwene angkodmenaneen kuu profesiman ye kakman kandaneen kii. Kanembed God ye yorokmo karub yaa wedme ye inamen yekaadkere ambiwoom nenwene angkodmenaneen kuu God ye yorokmo karub ye kakman kandaneen. ");
INSERT INTO yon_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nembed yiib yaa ke anam yedmendaan kei, kanembed ne yoman mini ye karub aningkoyiibbanman wedme ye kuu ne karub yekaadkeraneen kowe yuruk ok yuunde kankonaneen kuu ye kakman kuu biknaanban kandaneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kwane, Yesumbed ye kedmengkandeendan wad ayoob yaa kedmengkandi kee daandene yimin wande, yaro dore ware kuyaambed kandune Galeli ambibkin aom dewenebe kambongdan yaa weng amun daande kedmengkandoon. ");
INSERT INTO yon_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kwane, komo deme Yesu Keresumbed awinoon kuu Yoon kuu wii aombed dobere wengamboroon kowe, yembed ye kedmengkandeendan yaa yedmoona miniwen. ");
INSERT INTO yon_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Menekorib kaamoniwen, “Godbed Kinoona Mananeenman kuu eb dee o karub maa yaa meedmanuub dee?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kwanandiiwe, Yesumbed neman inande yedmendoon, “Ika wene komo wedmenib wengambiriib kuye weng kuu Yoon yaa daanime. ");
INSERT INTO yon_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Indob tutdan kuu wedmiib, yon arewadan kuu dodkaib, kaningki bobdan kuu amun kere doriib, kerendem kebengkoondan kuu wengaib, dukniwendan kuu ika dembiwen, kwane God ye weng amun kuu kamboknondan yaa daandeen. ");
INSERT INTO yon_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kanembed ne komo kamaan kuu wedmekore koronde dowakeniibban kerindo kuu Godbed ye yaa amun kerunaneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kwane, Yoon ye weng kanminidan kuu winiiwa, Yesumbed amonombe Yoon ye weng kadaareb yaa daandoon, “Amboon angka kuu yiib kuu komo wedmande winiwen? Aroob wuung nuubbed kanwene mene kameen areb ye karub wedmok winiwenoo? Dowan! ");
INSERT INTO yon_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kwangka kuu komo wedmok winiwen? Karub ebkad amuniibbed inwaroonkob dee? Dowan! Karub ebkad amunmombed inware dobirimaib kuu kingbed dibeen yambiwoombedmo. ");
INSERT INTO yon_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kowe, komo wedmok winiwen? Profesiman dee? Ee, anam. Ne yiib yaa ke yedmendaan kei, Yoon kuu profesiman ye deme burudande aningko darewoob keroon. ");
INSERT INTO yon_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ye yaa Godbed kwane andoone wongkiwen kuu kei. ‘Nembed ne weng kanwini ye karub yedmaniina yedin wene eb wananeeb ye kiwaan kuu yembed ongmene nekwaneen.’ ande wongkiwen. ");
INSERT INTO yon_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nembed yiib yaa ke anam yedmendaan kei, Yoon Baptaisman kuu darewoob, ye areb kwana kuu karub maa ma woonindo. Kumban kane kane kuu Godbed yi korok kere oonimbon aom aningkoyiibban doriib kuu Yoon burudande aningko ari kandiwen. ");
INSERT INTO yon_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yoon Baptaisman doreen yaronbed mene kibikee, Godbed korok kere oonimbon yaa kuu yeremboromdanbed monmarenib korok kerenib kamandamiib kii. ");
INSERT INTO yon_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwane, profesidan yi wengiib Yuudan yi amowiib kuu, Godbed korok kere ooni ye weng ye dowad dakmenabimaib kii. ");
INSERT INTO yon_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kowe, yiib dowaken wengambere kandibka o korondibka, Yoon kuu Elaidya areb monoon ye karub, God Ye Weng kunduk kumaom ye dowad dakmoon. ");
INSERT INTO yon_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kanembed kerendemiib keroka kwane wengamborok. ");
INSERT INTO yon_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Kibikee doriibdan kuu komarewa kereni ne kande ibnaniin? Yi kuu dana mana mana areb, animan berengkanabimbon yaa doberemberenib dana amborongaad yena yaa komkanabemoon areb, ");
INSERT INTO yon_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nub kuu yiib dowad yurin wurumuwen kumban, yiib ma kube andenabindo, ma nub kuu mimyob wandi ye damakob wingkuwen kumban, yiib kuu ma ameng kamindo.’ andiwen. “Yiib kuu kwamune areb kii, ");
INSERT INTO yon_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","amborom kuu Yoon kuu menene animan amuniib ok amuniib animokban kerene kedmengkandimaan kumban, yiibbed no yedmenimaib, ‘Ye kuu awad arewayiib ibnenoon kii!’ andimaib. ");
INSERT INTO yon_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma, Karub Ye Mingki menene animan amuniib ok wainiib anene kedmengkandimaan kumban, yiibbed no yedmenimaib, ‘Kedi, ye kuu animan yaamo inamen kowemberene ok arewamo kenambun anemberene kamembirimaan ye karub, angkara ye kuu tak od bidan yoom ambarakmidan yoom yi angkodmi kii.’ andimaib. Kumban God ye meeni kangdomdan kuu yi amun amun kami kuu yena yaa korokboka yi kuu yorokmo andi yeman.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kwane, Yesu kuu taun kurin kumaom God yaromkono wedmi yeman yemoon ongmenaboon kumban yi kuu ambarakmi yaa koronde God yaa amonombe winindo kowe, butun yedme kowoon, ");
INSERT INTO yon_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korasindan, kaadkerime! Betsedadan kwangkon, kaadkerime! Yiib kuu Yuudan kumban yiib yaa kuu Godbed arewa kerundaneen. Yiib aombed God yaromkono wedmi yeman ongmenabaan kuu kwamune taun Taiyayiib Saidoniib aom kwane ongmenabaan karen kuu, yi kuu Yuudanban kumban unyemanbed yi ambarakmi yaa korondenib ebkad karong korob deebenib mimyob wandi dowad yikbod yi korok ari ben nongkobenib God yaa amonombiwen karen kii! ");
INSERT INTO yon_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kwane kowe, nembed yiib yaa ke yedmendaan kei, wengyundi aron arimbed Taiyadan yoom Saidondan yoom kuu dabab yirimbed kandaniib, yiib kuu dabab darewoob kandaniib. ");
INSERT INTO yon_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ma Kapeenaumdan kude! Kwane yiib kuu ben Ewen ari kawananeenoo? Dowan! Yiib kuu Yuudan kumban yiib kuu ben kumbaanban yamotbon yiri kiraraneen kii! Yiib aombed God yaromkono wedmi yeman ongmenabaan kuu Sodom taun aom kwane ongmenabaan karen kuu, yi ambarakmi yaa koronde God yaa amonombiiwe Godbed yi monmarindo, kibikee wad doriib karen. ");
INSERT INTO yon_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kumban, nembed yiib yaa ke yedmendaan kei, God ye wengyundi aron ari kuu Sodomdan yi dabab kuu yirimbed kondaneen, ma yiib yaa kuu dabab darewoob arimbed.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kuye aron Yesumbed God yaa yedmoon, “O Ambe, eb kuu Eweniib okadiib ye Yariman. Ne ewaningko kankoonaan, amborom kuu ebbed kekamune ye inamen kuu ebbed dana areb keriwendan yaamo korokbendewen, kumban kedmengkandi yemoon biwendaniib indengandengdaniib yaa kuu bikderebewen. ");
INSERT INTO yon_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Ambe, kwamune kamewen, amborom kuu eb kubi dowaken kerewen kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kwane, Yesumbed kadaareb yaa ika yedmoon, “Kaadkeri koremiib aromkono koremiib kuu Nambembed bangkawoon. Ne kuu ye Mingki, ne yaa kuu Nambemo yekaad, yena yikaadban ne yaa. Kwane, Nambe yaa kuu nembedmo nekaad, yena yikaadban kowe, kwamune kane nembed ne dowaken Nambe kaadkerok ande korokbenaan kuu kukui. ");
INSERT INTO yon_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kane kane dabab darewoob awiniwen kuu ne yaa minime. Nembed owongab yiidki kondaniin kii. ");
INSERT INTO yon_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ne yoman menenib ne kedmengkandi kuu kaadkerime, amborom kuu ne kuu nangkemmo nekareb kankubunaan kii. Kwananiib kuu yiib niindem aom kuu yiidke nangkemmo kerenib ika aromnaniib. ");
INSERT INTO yon_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwane kowe, ne yaambed ne kedmengkandi awinaniib kuu yobdoodban, ma nembed komo deme kwamune awinime andaniin kuu kwangkon yobdoodban.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabat aron keruune, Yesu yoom ye kedmengkandeendan yoom wene baali mongkobon kuu kiwaan kebed angkara angkara kowe wenonib, ye kedmengkandeendan kuu mungiyiib kowe, baali yob yena kuu biangke ab daadme anande kamiwen. ");
INSERT INTO yon_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kwane, Farisidan wedmekorib, Yesu yaa yedmiwen, “Wedmeewoo? Eb kedmengkandeebdan kuu Sabat aron arimbed deme awinaib ye amob domokbiwen.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kwane, Yesumbed yi yaa inande yedmoon, “Dewid yoom yangkodmia yoom mungi bobnekorib kwaniwen ye weng kuu yiib kimingkindokowoo? ");
INSERT INTO yon_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ye wene kurikuri ambiwoom God ye kerebiri arinambo ari nongkobimaib ye om boona aniwen, God dore Yuudan dore wedyiri dobiridanmo animaib ye om amob. ");
INSERT INTO yon_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Ma, amob weng Mosesbed wongkoon kuu yiib ma kimingkindokowoo? God dore Yuudan dore wedyiri dobiridan kuu Sabat aron ari kurikuri boyambib darewoob aom deme awinimaib kowe, Sabat aron ye amob domokbimaib. Kumban kukuu God yaa ambarakmimban, amborom kuu Godbed yi deme kei ande kowoon. ");
INSERT INTO yon_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Kumban nembed yiib yaa ke yedmendaan kei, barang maa kurikuri boyambib darewoob yaningko burudande miin darewoob anam yeman kuu ke monoon kei. ");
INSERT INTO yon_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Godbed dakmoone wongkoon kuu ‘Ne dowaken kuu yiibbed mimyob keendimamime, dingkan nengke agedmo keroka baeb koni kuu ne dowakenban.’ ande wongkoon. Weng id kee yiibbed kandiwen karen, aniwen kumban ambarakmindodan keyaa wengyunde butun kamindo karen. ");
INSERT INTO yon_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Karub Ye Mingki kuu Sabat aron ye Yariman kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kuyaambed yaro dore wenene yi kurikuri ambiwoom wonoon. ");
INSERT INTO yon_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Karub dingki biridiib dingki kongiib angkaknoon kuu kumaom dibeen. Karub yena yi meeni dowaken kuu Yesu nenwengyundi ye dowad Sabat aron ari anam ambarakmoon andi ye kiwaan onmiib kowe, yimbed Yesu yaa kaamoniwen, “Sabat aron arimbed karub ongmi kuu amob dee?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kwane, Yesumbed inande yedmendoon, “Kwane, yiib kanembed ye sibi wene Sabat aron arimbed dem yiri kombaraneen kuu komo kamaniib, kuro nen yaro kowaniib dee, korondaniibkob kuri dobaraneen dee? ");
INSERT INTO yon_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Meenime, God ye kiringkono arimbed kuu nimakarub kuu barang darewoob, ma sibi kuu barang embeng mana. Kwane kowe, Sabat aron arimbed karub maa yaa amun kami kuu yimin, amobban.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kwamunekore, karub kuyaa yedmenoon, “Eb dingki yire.” andoon. Andoone, yembed yiroona korem ibonmo dingki yara areb amunmo keroon. ");
INSERT INTO yon_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kumban Farisidan kuu kuro bunangka angkanenib Yesu aye kowi ye wengiib dakmiwen. ");
INSERT INTO yon_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu yekaadkeroonbed kowe, kumaom koronde yaro dore wonoon. Nimakarub yemoon kerenenmo yoman winiiwa bob anikadiibdan korem kuu ongmenaboon. ");
INSERT INTO yon_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ongmekore yi yaa weng yobdoodmo daandimaan, “Kwane, yiib wene ari karub yena yaa ye wengiib dakmenmo yaraib.” ande daandimaan. ");
INSERT INTO yon_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kekee kwamune profesiman Aisaiya kwane wongkoon kuu anam id keroon. Godbed yedmoone wongkoon kuu, ");
INSERT INTO yon_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kekee nembed kankowaan ye deme karub, ne mimyob dowakeniib ne kubi darewoowiib kowaan kuu kei. Ne Kingkin kuu kan ye niindem aom kowaniina, yembed ne wengyundi amun ye weng kankone nimakarub kumundin yaa kowene dakmaneen. ");
INSERT INTO yon_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ye kuu kwane wengberenmo yarene, weng baande dakmenmo yaraanban. Ye kuu kiwaan yidbon ari baandaneene wengambaraibban. ");
INSERT INTO yon_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aroob imkono nikboon kuu yembed domokbaanban, lem wik amoyidkob amareng deneen kuu kumbaanban, kwane wene God ye wengyundi amun ye weng kuu kankoonaneene korem yaa burudande dembaneen. ");
INSERT INTO yon_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yaningko yaambed ambibkin koremdanbed anam kwananeen ande meedmaniib.” kwane ande wongkoon. ");
INSERT INTO yon_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kwane, karub maa kuu awad arewambed ibnenoon kowe indob tut wengwaab keroon kumbed nenminiiwe, Yesumbed ongmenoona kwane amun kere weng dakme korobe wedme kamoon. ");
INSERT INTO yon_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kwane, nimakarub korem kuu binangkane dakmiwen, “Kekee Dewid ye Awo Godbed weng kunduk ande kowoonoo?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kumban Farisidan kuu wengamberekorib yedmiwen, “Yii! Kukuu no awad arewa yi korok yaningko yaambed awad arewa kuu yedmaankob angkanimaib kude!” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu kuu yimbed meenmiib kuu yekaadkeroon kowe, yi yaa yedmoon, “Ambibkin mimodan andokbe yeka yeka kere yikanmo nangmiwen karen, korem kuu monmariwen karen. Kambong mimodan o ambib mimodan kwangkon andokbe yeka yeka kere yikanmo nangmiwen karen, korem kuu dobaraibban, yowore dowan keriwen karen. ");
INSERT INTO yon_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Kwane, Seten awene kuu yaro yikareb dore yenburaniib kuu andokbe angkara angkara keri yeman. Kwananiib kuu yi ooni yaromkonoyiib dobaraniib dee? ");
INSERT INTO yon_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Kwane, yiibbed yedmiwen kuu ne kuu awad arewa yi korok Belsebul yaningko yaambed awad arewa yenburaan kowe, ma yiib karub kuu kane yaningko yaambed yenburiwen? Kwana kowe, yi kuu yiib weng wengyundaniib kii. ");
INSERT INTO yon_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kumban God ye Kingkin yaningko yaambed yedme anburimain anam id keraneen kuu Godbed korok kere ooni yeman yiib yaa monoon kii. ");
INSERT INTO yon_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Angkon kwamune, karub kanembed karub aromkonoman doreen yambiwoom dawuro yiribman kuu yid be wanaanban, no ambib yariman kuu nongbed yenbe kowekored. Kumbed yaro ambib aande yiribman yid be wananeen. ");
INSERT INTO yon_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Karub kanembed ne yaa ibmo kerindo kuu ne bonman kii, karub kanembed ne yoom ne wenori deme awinindo kuu boketawaroon kii. ");
INSERT INTO yon_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Kwani kowe, nembed yiib yaa ke yedmendaan kei, korem ambarakmiyiiwa God yaningko monmariyiiwa kuu are nonondandaneen kuu yimin. Kumban Kingkin Karadmo yaningko monmari kuu are nonondandaanban, angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“Karub kanembed Karub Ye Mingki yaa weng arewa dakmaneen kuu are nonondandaneen kuu yimin. Kumban kanembed Kingkin Karadmo yaa weng arewa dakmaneen kuu are nonondandaanban, okad kiri kee doruub yaroniiwa God mananeen yaron angkara kwangkon are nonondandaanban. ");
INSERT INTO yon_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“At amun kab arumaneeb kuu ayob amun iraneen, at arewa kab arumaneeb kuu ayob arewa iraneen, amborom kuu at kuu arewa dee amun dee ye wedmi yeman kuu ye ayob yaa. ");
INSERT INTO yon_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“Yiib kuu niindok yi meed, komarewa kere arewadan yiib kuu barang amun ma ande dakmaniib? Dowan! Meenime, karub ye niindem aombed ben bangkandimaankob ye mongkodkono yaambed dembimaan. ");
INSERT INTO yon_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Karub amun kuu ye niindem aom amun amun dangoon kumbed inamen amunmo benmenebimaan. Ma karub arewa kuye niindem aom arewa arewa dangoon kumbed inamen arewamo benmenebimaan. ");
INSERT INTO yon_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Kumban nembed yiib yaa ke yedmendaan kei, nimakarub ogood weng dakmiwen kuu, wengyundi yaron arimbed weng korem kuu komande kwanandewen ande ye weng id kuu God yaa dakmaniib. ");
INSERT INTO yon_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwane, yiibbed komo weng dakmiwen kumbed Godbed wedmene wengyundene dabab kondaneen o dabab kondaanban.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kwane, Farisidan yena yoom Yuudan yi amob kedmengkandidan yena yoombed Yesu yaa yedmiwen, “Kedmengkandi korok ee, nub dowaken kuu ebbed dud korokbi maa nub yaa korokbe.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kwane, Yesumbed inande yedmoon, “Kukuu no arewa kamenib God yaa angkurom korokbenib kamimaibdan kumbed ne yaa dud korokbe ande kaamowiib kii! Kumban ma dud korokbainban, no profesiman Yonambed dud korokboon kuu korokbaniin, kumbedmo. ");
INSERT INTO yon_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kedi, Yona kuu amnoom ayoobmim aronki ayoobmim okyiri oon kambari ye kabeyob aom doboroon kwamune areb kumbed, Karub Ye Mingki kwangkon amnoom ayoobmim aronki ayoobmim kwamune okad niindem yiri angkimbaraneen. ");
INSERT INTO yon_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Kwane, Godbed wengyundaneen yaron ari kuu Nineva taundanbed yaro menenib kibikee doriibdan kuu arewa anam kii andaniib, amborom kuu Ninevadan kuu Yona ye amonombi weng wengamberekorib, yi dobiri arewa yaa amonombiwen kowe. Kumban kibikee barang maa Yona yaningko burudande miin darewoob anam yeman kuu ke monoon kei. ");
INSERT INTO yon_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Ma, Godbed wengyundaneen yaron ari kuu kan kuri kaaron ye kuinbed yaro menenu kibikee doriibdan kuu arewa anam kii andanuun, amborom kuu okad yimin wandoon yaambed menenu Solomon ye weng kangdom wengambarande muneen kowe. Kumban kibikee barang maa Solomon yaningko burudande miin darewoob anam yeman kuu ke monoon kei. ");
INSERT INTO yon_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ma kei. Kwane awad arewa kuu karub yaambed anburaniiwa yaro wenene bidambibkin koknoon okiibban angka yiidkimbon onmenmo yarebenambaraneenka dobarande yiminban keraneen. ");
INSERT INTO yon_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kwane, awad arewa yekareb yedmaneen, ‘Ii ambib koronde manaan kumaom kuu ika wene wedma.’ andaneen. Kwamune mene wedmaneene, arenib yiribman kuu nekwane ongme yirimbonmo amun keriwen kumban ma doborokban kowe, ");
INSERT INTO yon_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ika wene awad miin arewa anam ediib ye arebban kuu benmananeena yi korem kwane kumaom dobaraniib. Kwananiiwa ari karub kuye dobiri kuu kurin arebban, miin arewa anam keraneen. Kuye kumun areb kuu no arewa kamenib kibikee doriibdan kee miin arewa anam keraniib kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kwane, Yesu kuu kadaareb yaa ambiwoombed weng daandeen ye niindem aom kuu ye ena yoom damana yoom kuu mene bunangka doriib. Yi dowaken kuu wengane weng daanem andiwed. ");
INSERT INTO yon_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kwane, karub maambed Yesu yaa yedmenoon, “Eb ena yoom damana yoom kuu bunangka doriib, eb wedmebde weng daabdandamiib kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kwane, Yesu inande yedmenoon, “Kane kuu ne ena? Kane kane kuu ne damana?” andekore, ");
INSERT INTO yon_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ye dingki yire ye kedmengkandeendan kuyaa dedmondene yedmoon, “Kekei ne ena yoom damana yoom kei, ");
INSERT INTO yon_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","amborom kuu kane kanembed Nambe Ewen ari doreen ye inamen dowaken yaambed kamimaib kuu ne enaya ne aagoroka ne yangkuraya kuu kui.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kuye aron ari, Yesu kuu ambiwoom koronde wene ok bowan kebed angka diboroon. ");
INSERT INTO yon_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kwane, nimakarub yemoon menebe ye kanawanewandiiwe, ye kuu koronde oon bi motod aom awune diboroon. Kwane, kadaareb kuu ok kaat yaa menebe dobiriwen. ");
INSERT INTO yon_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kwane, yembed kuruwak weng yemoon daandene ma yedmoon kuu kei, “Mongkobon yariman kuu yaro ayongmon yeeb angka yob kab kiradmande wonoon. ");
INSERT INTO yon_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kwane, kab kuu kiradmenmo yaroona, yena kuu kiwaan angka kiroboon kowe, ayari onbed wan menebe ben aniwen. ");
INSERT INTO yon_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yena kuu dumnad yiri okad embengmo ari kiroboon. Kwane, kab kuu kirodmo deedereboon, amborom kuu okad kuu ambab yirimban kowe. ");
INSERT INTO yon_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kumban, aron yaro mene yuruuna, kab korem nuubderebe kokdereboon, amborom kuu yumburum kuu ambab yiri kubunebindo kowe. ");
INSERT INTO yon_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yena kuu okad yik kawiib yiri kiroboon kowe, kab kuu yeere demboon kumban yik kabbed kan dabuknandoone idiib kerindo. ");
INSERT INTO yon_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yena kuu okad amun ari kiroboon. Kwani kowe, id diboroon kuu yemoon, yena id 100iib, yena id 60yiib, yena id 30yiib kwamune ire wonoon. ");
INSERT INTO yon_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Karub kanembed kerendemiib keroka, kwane wengamborok.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kwane, ye kedmengkandeendanbed mene kaamoneniwen, “Komandewed kuruwak wengbed yi yaa daandimaab?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kwane, Yesumbed inande yedmoon, “Godbed korok kere ooni yeman ye weng id angkara kuu yiib yaa korokbendadned yiibkaadkeri yeman, kumban yimanban. ");
INSERT INTO yon_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kane kuu Godbed korok kere ooni yeman yaa yekaadkeroon kuu, Godbed kedmengkandi yena ari konaneene yemoon keraneen. Kumban kane kuu yekaadkerindo kuu ye yiribman korem kuu Godbed yeka baneen. ");
INSERT INTO yon_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Kuruwak wengbed yi yaa daandimain ye id kuu kei. Kwane yi wedmimaib kumban korobe wedmimokban. Kwane yi wengambirimaib kumban ongme wengambirimokban. ");
INSERT INTO yon_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Kwani kowe, profesi weng Aisaiyambed yedme wongkoon kuu yi yaa anam id keroon. Wongkoon kuu Godbed yedmoon, ‘Yiib kuu wengamberembirimaib kumban, wengambere id kandimokban kerenib, yiib kuu wedmembirimaib kumban, id wedmimokban keraniib, ");
INSERT INTO yon_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","amborom kuu kwamune keyedan kee yi niindem aom kamkono kerenib, yi wengambiri korondenib, yi indob korem imbune winiwen kowe. Kwanaibban kuu yi indobbed wedmenib, yi kerendembed wengamberenib, yi niindem aombed weng id kandenib, amonombiiwa, nembed ongmendaniin.’ kwane wongkoon. ");
INSERT INTO yon_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kumban yiib indobbed wedmenib, yiib kerendembed wengambirimaib kowe, Godbed yiib yaa amun kerundoon. ");
INSERT INTO yon_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kedi, nembed yiib yaa ke anam yedmendaan kei, yiibbed wengambere wedme kamiib yaa kuu profesidaniib God ye inamen yorokmodaniib kurin dobiriwen kumbed yi dowaken darewoob kuu kwamune monoko wedmem ande meedmiwen, kumban yi wedmindo, kwamune wengamberem ande kamiwen kumban yi wengambirindo.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kwane Yesumbed ika yedmoon, “Kab kiradmoon ye kuruwak weng id kuu wengambirime. ");
INSERT INTO yon_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Nimakarub yena kuu okad kiwaan angka areb, kane kanembed Godbed korok kere ooni ye weng kuu wengamberekorib id kandindo keroone, awad arewa yi korokbed weng amun yi niindem aom angkeen kuu awine buruwandene kanwonoon. ");
INSERT INTO yon_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Kwane, nimakarub yena kuu dumnad yiri okad embengmo ari areb, kane kanembed God Ye Weng wengamberekorib kirodmo kubiyiib awiniwen. ");
INSERT INTO yon_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kumban God Ye Weng kuu yi niindem ambab yiri kubunebindo kowe, awinenib aron doboobban dobaraniib, amborom kuu God Ye Weng yaa arud barang o yenbandi mananeen kuu kwane kirodmo kombiri angkananiib kowe. ");
INSERT INTO yon_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Kwane, nimakarub yena kuu okad yik kawiib ari areb, kane kanembed God Ye Weng wengambiriwen kumban, okad yiri dobiri ye meeni darewoowiib yiribman yemoon baniin kuu nekareb yimin keraniin andi ye dobiriyiib kumbed God Ye Weng dabuknandoon kowe, God Ye Weng kuu idiibban keraneen. ");
INSERT INTO yon_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Kumban nimakarub yena kuu okad amun ari areb, kane kanembed God Ye Weng wengamberekorib, korobe meene awine dobiriwen. Yi kuu idiib dibaraniib, yena kuu id 100iib yena kuu id 60yiib yena kuu id 30yiib kwamune areb keraniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kwane, Yesumbed kuruwak weng maa daandoon, “Godbed korok kere ooni yeman kuu kekamune. Kwane karub maa wene wiit kab amunmo arumoon. ");
INSERT INTO yon_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kumban amnoombed mongkob yariman awene kuu unuk dangiwen kumaom kuu ye bonmanbed wene yob animokban ye kawiib ibmo kuri arumenmo yarekore wonoon. ");
INSERT INTO yon_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Amaan kuu wiit kab kuu yeere amne id ire wonoone, kab arewa kwangkon ibonmo wiit kab areb kwane dembe wonoon. ");
INSERT INTO yon_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Deme karub kuu mene yi korok yaa kaamoniwen, ‘Korok, eb kuu wiit kab amunmo mongkobon angka arumewenoo? Kunayambed kab arewa kuu menene dereboon kii?’ andiwen. ");
INSERT INTO yon_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yembed inande yedmoon, ‘Ei, kee bonman maambed kamoon kii.’ andoon. Kwanandoone, ye demedanbed kaamoniwen, ‘Kwanoka, awine biangke kiradmanuuwoo?’ andiwen. ");
INSERT INTO yon_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kwane, yi korokbed inande yedmoon, ‘Yii! Korondiiwaa! Amborom kuu kab arewa biangkaniib kumbed wiit yumburumiib kwane biangkaniib kowe. ");
INSERT INTO yon_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kwane, korondibka, ibmo kwane dembiiwa, wene id wandi yaron keraneen. Aron arimbed id wandidan yedmaniina, kereek arewa kudin nadme andedmenabe nongkobe amot nengkekoriwa, wiit kuu wande benwene ne animan nongkobimbon ambiwoom nongkobaniib.’” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kwane, Yesumbed angkon kuruwak weng maa daandoon, “Godbed korok kere ooni yeman kuu kekamune, at yaningko mastet ye yob kab karub maambed kande ye mongkobon angka kibinoon areb. ");
INSERT INTO yon_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kwane, mastet yob kab kuu embeng mana, kab yena arebban, kumban ma yeere kainaneen kuu at darewoob at yena mongkobon angka arumenaboon kuu korem yembed burudande wonoon. Kwane, daane darewoob keroon kowe, ayari on maa maa menebe at nondong ari kuu ami yenbenaben wananiib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kwane, angkon Yesumbed kuruwak weng maa daandoon, “Godbed korok kere ooni yeman kuu kekamune. Wonong maambed flawa aande oganu bred ongmandamuun kuu flawa kabayingke obo keri yeman ye aningko yiis embeng aande kabed ayoobmim ye flawa aom kowe ongmeenkob, yiisbed flawa aom kabayingke yimin yimin yaa keroon.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu kuu kuruwak wengbed karuwa nimaya yaa daandimaan, kumbedmo. ");
INSERT INTO yon_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kwanoon kowe, profesimanbed kwane dakmoon kuu anam id keroon. Kwane yedme wongkoon kuu, “Ne kuu kwamuneni kuruwak weng yaambed kande dakmaniin. Kedmengkandi yena okad ongmoon yaambed mene kibikee yemyeb bikderebeen kuu, nembed ben dian kere dakmaniin.” ande wongkoon. ");
INSERT INTO yon_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kwane, Yesumbed kadaareb domondekore ambiwoom awunoon. Kwane, ye kedmengkandeendan kuu yeyiib yaa mene kaamoniwen, “Mongkob angka kab arewa ye kuruwak weng dakmewen kuye id kuu, kedmengkandebko kaadkerem.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kwane, Yesumbed inande yedmoon, “Kei, karuwa kab amun arumoon kuu Karub Ye Mingki kii. ");
INSERT INTO yon_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mongkobon kuu okad kumundin kangkuun kei, kowe kab amun kuu God yaa anam andiiwe Godbed yi korok kere oonoondan kui. Ma, kab arewa kuu awad arewa Seten ye yoman winiwendan kui. ");
INSERT INTO yon_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kwani kowe, bonman kab arewa arumoon ye karub kuyaamo Seten kui. Kwane, kab wandi aron kuu keye aron yimin wandanuune, id wandidan kuu God ye engyus kui. ");
INSERT INTO yon_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Kwane areb, kab arewa dembe wonoon kuu biangke amot yiri nengkaneen areb kuu, keye aron yimin wandanuun yaambed kwamune keraneen kii. ");
INSERT INTO yon_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kwamune keraneen kuu Karub Ye Mingkimbed ye engyus yedmaneene yimbed wenebenib, okad yimin yimin wandaneen yaambed nimakarub arewa kamo doriiwiiwa ambarakmok ande kamiiwiiwa kuu korem be nedbekorib, ");
INSERT INTO yon_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","amot arewa yiri be kiraraniiwa, amengiib durud yewed ye ningkambo kabangiib kame dobaraniib. ");
INSERT INTO yon_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kwana kowe, God ye yorokmodan kuu yi Ambe Godbed korok kere oonimbon aombed aron areb yuraniib. “Kanembed kerendemiib keroka, kwane wengamborok.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kwane, Yesumbed ika yedmoon, “Godbed korok kere ooni yeman kuu, odamod okad yiri bikne angkimboroon areb. Kwane, karub maambed wedmekore, angkon ika kanbiknekore, kubi darewoob kumbed wene ari yembed komo awinoon ye yiribman korem kuu ben ari berengke od kandekore, mene odamod biknoon ye okad kuu moonoon. ");
INSERT INTO yon_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ma, Godbed korok kere ooni yeman kuu, berengki karub maa wene bot manimanandeb yaningko peel ande onmenmo yaroon areb. ");
INSERT INTO yon_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Peel od miin darewoob yeman wedmekore, wene ari ye yiribman korem ben ari berengke od kandekore, mene peel kuu moonoon.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kwane, Yesumbed ika yedmoon, “Godbed korok kere ooni yeman kuu kekamune, oon men nande ok bowan angka nane oon yemoon maa maa boon areb. ");
INSERT INTO yon_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kwane, oon yidwaroon kowe, oon men kuu wan yaro kubuk arimbed kowiwen. Kowenib, yi diberenib andangkane oon amun yaa kuu ben kabed aom kambungke arewa yaa kuu benkirarundiwen. ");
INSERT INTO yon_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kwamune areb, keye aron yimin wandanuuna Godbed ye engyus yaa yedmaneena God ye yorokmodaniib arewadaniib kuu andokbenib, ");
INSERT INTO yon_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","arewadan kuu amot arewa denaneen yiri benkiraraniiwa, amengiib durud yewed ye ningkambo kabangiib kame dobaraniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kwane, Yesumbed ye kedmengkandeendan yaa kaamondoon, “Yiib kuu kuruwak weng korem kee kuye weng id kandiwen dee?” andoone, “Ee” ande yedmiwen. ");
INSERT INTO yon_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kwani kowe, Yesumbed yi yaa yedmendoon, “Kwane kowe, Yuudan yi amob kedmengkandidan mimo mimo kuu anam ande Godbed korok kere ooni yeman ye kedmengkandi kandoon kuu kwamune, ambib yariman kurin ye yiribman amuniib kibik ye yiribman amuniib areb, yambiwoom komo yure oonoon kuu ben yaro mananeen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kwane, Yesu kuu kuruwak weng kee daande dowan kerekore, kuyaa koronde yaro wonoon. ");
INSERT INTO yon_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yaro dore wene ye kambong anam Nasaret aom awune yi kurikuri ambiwoom dawuro kedmengkandoona, yi binangke karekme yikareb yedmiwen, “Karub kee kuna yaambed meeni kangdomiib God yaromkono wedmi yeman ongmi yaromkonoyiib kuu boon kii? ");
INSERT INTO yon_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ye kuu no ambib yenbi ye karub ye mingki. Kedi, ye ena yu aningko Meri, kwane ye damana kuu Yems yoom Yosef yoom Saimon yoom Yudas yoom kui. ");
INSERT INTO yon_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ye yangkuraya kwangkon korem nub yoom ibmo ke doruub kei. Kowe, karub kee kunayambed kwamune aromkonoyiib inameniib kee boon kii?” andekorib, ");
INSERT INTO yon_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ye yaa kubenokban odkeneb keriwen. Kumban Yesumbed yedmendoon, “Profesiman kuu yemoonbed ye yaa karub amun andimaib kumban, ye kambongdan yoom ye ambanga damana aweneyiib yoom kumbedmo ye yaa karub amun andimokban.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kwane kuyaa kuu, ye kuu God yaromkono wedmi yeman yemoonban ambangkoon, amborom kuu yi kuu ye yaa anam andindo kowe. ");
INSERT INTO yon_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kuye aron aom Galeli ambibkindan yi korok darewoob Erod Antipas kuu Yesu komo kameen ye weng wengamberekore, ");
INSERT INTO yon_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ye korok korok yaa yedmoon, “Yesu kuu Yoon Baptaisman bobnoon yirimbed angkon ika demboon kii! Kwanakob God yaromkono wedmi yeman ongmenabimaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kwanandoon amborom kuu anuk yiri kumbed Erod kuu ye aagorok Filip ye wonongbed yu ambi dankare domonenuune Erodbed yu kuu awanoon kowe, Yoonbed Erod yaa daandimaan, “Ebbed yu awani kuu amob kii!” andimaan. Kwani kowe, Erodbed yedmoonkob ye dememan maambed Yoon awine kan wii aom kaanoona dibeen. ");
INSERT INTO yon_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erod kuu ayande meenoon kumban, ye kuu unoon, amborom kuu nimakarub yemoonbed Yoon kuu profesiman ande yedmimaib kowe. ");
INSERT INTO yon_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kwane, Erod ye wooneen ye orok yaron muneen kowe, Erodias yu mungkan koyu menenu menebiwendan yi murubia ari awuderenu ebkad wayirikne andeen kowe, Erod kuu kerengkandi darewoob keroon. ");
INSERT INTO yon_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kwani kowe, ye amob ongme yedmoon, “Kubbed komo meene yedmaneeb kuu kankabdaniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kwane, yu kuu awaan yu weng kandeen kowe, Erod yaa kwane yedmeen, “Yoon Baptaisman ye korok wande yabad ari kowe kanmene kawe.” andeen. ");
INSERT INTO yon_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Anduuna, King Erod kuu kubiyiibban keroon kumban, amob weng ongme yedmoone yi yoom ane doriibdan wengambiriwen kowe, wonong koyu yu kaamoni yaa ee andekore ye dememan maa yedmoone, ");
INSERT INTO yon_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yoon ye korok kuu wii aombed wandiwen. ");
INSERT INTO yon_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kwane, Yoon ye korok kuu yabad animarimbed kowe kanmene wonong koyu kuyaa kondiiwa, yumbed awaan yaa kanmene kondeen. ");
INSERT INTO yon_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kwamuniiwa, Yoon ye id kuu ye kedmengkandeendan menenib kanwene mangkiwen. Mangkekorib wene Yesu yedmeniwen. ");
INSERT INTO yon_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kwane, Yoon ayiwen ye weng kee Yesu kuu wengamberekore, ye kedmengkandeendan be kuyaa kuu koronde parai motodbed kimyen obonmo yaa wonoon. Kwanoone, nimakarub yemoonmo wengamberekorib, taun dia dia yaambed ye yoman yonka winiwen. ");
INSERT INTO yon_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kwane, Yesu kuu wirine kadaareb yemoon wedmendekore, mimyob keendoon. Keendekore bob anikadiibdan kuu ongmenaboon. ");
INSERT INTO yon_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kwane oobne aron kubune wenuun yaambed, ye kedmengkandeendanbed mene Yesu yaa daaniwen, “Keyaa kuu obonmo kambongiibban angkon miriknandameen kii. Amun kuu daandeewo wenebenib, kambong kambong yaa wene yika animan berengkanabe anime.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kwanandiiwe, Yesumbed inandoon, “Kwamunemban. Yiibbed animan bangkandibko anime.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kwane, yimbed inande yedmiwen, “Nub kuu om angkoyiib oon ayoob kembedmo awinuwen.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kwanandiiwe, Yesumbed yedmoon, “Ne yaa benminime.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kwane, nimakarub korem yaa yedmendoona kereek ari dibiriwen. Om angkoyiib oon ayoob kuu benkoobe, indob kan ambid ari wedmene eso andekore, om kuu domabangkoon. Kwane, yembed ye kedmengkandeendan yaa bangkandoona, yimbed be ari karuwa nimaya danaya yaa bangkandiwen. ");
INSERT INTO yon_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yi korem anenib mikmoniwen. Ari animan dungkun dungkun koronde winiwen kuu ye kedmengkandeendanbed kabed kumaom benkambungke deweniiwe kabed wad ayoowiib kuu yeederebenan wonoon. ");
INSERT INTO yon_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Karuwa nimaya danaya korem animan aniwen kuu karub 5,000iib areb. ");
INSERT INTO yon_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kwane kuyaambed, Yesumbed ye kedmengkandeendan yaa yedmendoona, yidin parai motod nande bowan yara yanande winiwen. Kwane, kadaareb yaa ika winime ande yedmekore domondoon. ");
INSERT INTO yon_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kwane domondekore, wene aangko kaat angka yembedmo kurikuri kerok daanoon. Kwane, aron kubunenu mirikne wenuuna, Yesu kuu yembirimo keroone, ");
INSERT INTO yon_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ye kedmengkandeendan kuu motodbed bid domonenib ambab ok wedangka winiwen, kumban yi weniib ye arinambo arimbed nuub kuu yi yaa meneene oknondok darewoob kamenu motod yaa beengkaun. ");
INSERT INTO yon_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kwane, amnoom awawini yaa Yesu yiyiib yaa ok arimbed dodkanmo wonoon. ");
INSERT INTO yon_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kwane ok arimbed dodkanmo wene yi dia keroone, ye kuu wedmenekorib uni miin darewoob kere “Awadii!” ande komkiwen. ");
INSERT INTO yon_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kumban Yesu kirodmo yi yaa baandoon, “Nembed kei. Yiib unaib, yiib niindem aom aromnime.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kwane, Pitambed baande yedmoon, “Yariman, anam ebbed meneeb keroka, ne yaayiib yedme kowebko, ok ari ewiib yaa mana.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kwanandoone, Yesumbed “Ee mene.” andoon. Kwane, Pita motod aom koronde kuro ok arimbed dodkanmo Yesuyiib yaa andowe wonoon. ");
INSERT INTO yon_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kumban Pita kwane nuuwa oknondoka wedmendekore, unene ok yiri andowe kubune wenene baandoon, “Yariman, ne nenkoone!” andoon. ");
INSERT INTO yon_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kwane baandoone, Yesu kirodmo dingki yirene awinene nenkoonekore yedmoon, “Eb anam andi kuu embengmo kii, komande karekmeeb?” andoon. ");
INSERT INTO yon_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kwane, yi kuu motod aom awuniiwa nuub kuu dowan keroon. ");
INSERT INTO yon_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kwani kowe, yi korem motod aom doriibdan kuu Yesu yaa bumangkane yaningko kankoone yedmiwen, “Anam kai! Eb kuu God ye Mingki kii!” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kwane, yi yane wene bowan yara bidambib Genesaret yaa wiriniwen. ");
INSERT INTO yon_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kwane, nimakarub kuyaa doriibdan kuu wedmibka, anam Yesu kii andekorib, weng ben nongkobiiwa wenebuuna, ambibkin dia dia kuu bob anikaddan korem kuu Yesu yaa benmenebiwen. ");
INSERT INTO yon_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kwane, yimbed no eekme yedmimaib, “Bob anikaddan kuu eb ebkad dungkun arimbed angkorokanime.” andimaiwe, kane kane korem Yesu yebkad dungkun yaa angkorokaniwen kuu wadkeriwen. ");
INSERT INTO yon_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kwane, Farisidaniib Yuudan yi amob kedmengkandidaniib Yerusalem aombed menenib Yesu yaa kaamoneniwen, ");
INSERT INTO yon_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Komandeniwed eb kedmengkandeebdan kuu nub aamkono yi amowamob kuu awinindo kere no domangkimaib? Kedi, yi dingki kuu ogindo kumbed animan kuu awingkonib aniib kii.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kwane, Yesumbed inandoon, “Ma komandiwed yiib kuu God ye amob kuu domabangkanib yiib amowamobmo oone awinimaib? ");
INSERT INTO yon_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kedi, Godbed yedmoon, ‘Yiib ambe ena yi weng wengambere awandime.’ andoon. Ma yedmoon kuu, ‘Kanembed ambe ena yaa amkidbaneen kuu ayiwed bobni yeman.’ andoon. ");
INSERT INTO yon_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Kumban yiibbed kedmengkandimaib kuu kanembed ambe o ena yaa yedmaneen, ‘Ne yiribman yaambed komo yiib yaa awandaniin kuu kan God yaa munob koni yeman kowe, yiib yaa kondindeban.’ andaneen kuu yimin, yiibbed kedmengkandimaib kuu. ");
INSERT INTO yon_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kumban kwanandaneen kuu ye kuu anam ambe ena yaa oone awandimban. Kwanekob, yiibka God ye amob kuu benkirarundekorib, yiib awoya yi amowamobmo awinimaib. ");
INSERT INTO yon_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yiib kuu aadidmidan kii! Aisaiyambed yiib dowad profesi weng yedmoon kuu korem weng id anammo keroon. God Ye Weng kwane dakmoon kuu, ");
INSERT INTO yon_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Keye nimakarub kee naningko wengbed kankoonimaib, kumban yi meeni inamen ne yaa kuu ambab anam. ");
INSERT INTO yon_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kowe, yimbed naningko kankooni kuu yiminban, amborom kuu yi kedmengkandi kuu karub yi inamenmo kedmengkandimaib kowe.’” kwane andoon. ");
INSERT INTO yon_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kwanandekore, Yesumbed kadaareb yaa baandoona ye yaa miniiwa yedmoon, “Wengambere kandime. ");
INSERT INTO yon_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Komo komo karub ye mongkodkono aom awunaneen kuu God yaa arewa keri yemanban, kumban komo karub ye mongkodkono aombed deedaraneen kuu God yaa arewa keri yeman.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kwane, ye kedmengkandeendan menenib Yesu yaa kaamoniwen, “Eb kuu ma kaadkerewenoo, Farisidanbed weng kee dakmeeb kumbed eb yaa kongebde odkeneb keriwen kii.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kwanandiiwe, yembed inandoon, “Kab korem Nambe Ewen ari doreen kumbed arumindo yaa kuu korem yumburum yirimbed biangkane kiraraneen. ");
INSERT INTO yon_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yi kuu domondime. Yi kuu indob tut korok korok kowe. Kudi, kwane indob tut korokbed wene indob tut karub maa nen kinban wananeen kuu yi ayoob kwane wene dem kombaraniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kwane, Pitambed yedmoon, “Kuruwak weng kuu dakmeeb ye id kuu korokbende.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kwanandoone, Yesumbed inande yedmoon, “Yiib kuu weng id kandindebankowoo? ");
INSERT INTO yon_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yiibkaad dee? Komo komo mongkodkono awune kawene kabeyob aom awunimaan kuu wene no ot kerimaan. ");
INSERT INTO yon_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kumban komo karub yi mongkodkono aombed deedirimaib kuu inamen aombed dembimaib. God yaa arewa keri yeman kuu kui, ");
INSERT INTO yon_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","amborom kuu inamen aombed dembimaan kuu, arewa ye meeniyiib kuman o kumka ayi ye inameniib nenem kami ye inameniib yid bi ye inameniib weng wiribi ye inameniib wengamborokbanabiyiib kuu kwamune nimakarub yi niindem aombed dembimaan. ");
INSERT INTO yon_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kwane kee dembimaan kumbed God yaa arewa keri yeman. Ma, animan karub dingki ogindombed awingke ananeen kuu God yaa arewa keri yemanban.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kwane, Yesu kuu kuyaa koronde yaro dore wene ambibkin Taiyayiib Saidoniib yaa wonoon. ");
INSERT INTO yon_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kuyaa Keenandan wonong ambibkin kuyaombed yaro menenu, Yesu yaa baande komkeen, “Yariman, Dewid ye Awo, ne mimyob keewe. Ne dana mungkan kuu awad arewambed ibnendoona miin yiminban arewa anam kereen kii.” andeen. ");
INSERT INTO yon_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kumban Yesu kuu ma inande daandindo kowe, ye kedmengkandeendanbed mene nangkane daaniwen, “Wonong kee yedmendebko, koronde wunuk, amborom kuu komkanmo menuun kowe.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kwani kowe, yembed yu yaa yedmoon, “Ne kuu no Israeldan sibi bikderebiwen areb keriwen yi dowad kan yedme kowoonkob manaan.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kwane, wonong kuu Yesu ye dia angkon menenu ye murubia ari bumangkanu yedmeen, “Yariman, awawe.” andeen. ");
INSERT INTO yon_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kwananduune, Yesumbed inande yedmoon, “Dana mana ye om kuu bene anon yaa kiradmi kuu arewa.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kwanandoone, wonongbed inande yedmeen, “Yariman, anam kumban, ma anon kuu kangkomanbed animan aneen ye arak dabderem yiri om ambong ambong kuburimaan kuu animaib.” andeen. ");
INSERT INTO yon_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kwane, Yesumbed inande yedmoon, “Kub kuu anam andi darewoob ye wonong kii! Kwani kowe, komo mene kaamowewen kuu kibireb kwanok.” andoon. Kwane kuyaambed, wonong yu mungkan kuu amun kereen. ");
INSERT INTO yon_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kwane, Yesu kuu kuyaa koronde ok bowan Galeli kebed yaa wonoon. Wenekore, wene kawene aangko arimbed diboroon. ");
INSERT INTO yon_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kuyaambed nimakarub yemoon kai yeyiib yaa menebiwen kuu yon wanadaniib, indob tutdaniib, yona dingkia angkaknoondaniib wengwaabdaniib bob anikad maa maadaniib yemoonmo benminiwen. Yi kwane benmenebenib Yesu ye murubiambon ari kiribiiwa, ongmenaboon. ");
INSERT INTO yon_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kwane, wengwaabdan kuu weng dakmiiwa, angkaknoondan kuu amunmo keriiwe, yon wanadan kuu yaro yarebiiwa, indob tutdan kuu nande wonoona kereknan winiiwa kamenan winiwen. Kwane, yi korem menebiwen kuu wedmekorib binangke Israeldan yi God kubenib yaningko kankooniwen. ");
INSERT INTO yon_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kwane, Yesumbed ye kedmengkandeendan yaa baandoona ye yaa winiiwa yedmoon, “Nimakarub kumundin keyaa mimyob keendaan, amborom kuu yi kuu neyiib yaa aronki ayoobmimiib doriiwe animaniibban keriwen kowe. Ika winime andi kuu ne dowakenban, amborom kuu yi kuu mungimo wananiib kuu wedya kirobaniib kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kwanandoon kowe, ye kedmengkandeendanbed kaamoniwen, “Nub kuu amboon keyaom kee kunayambed animan kuu benub kadaareb kamune kee bangkandanuubkob ane yimin keraniib?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kwane, Yesumbed kaamondoon, “Yiib kuu om kuu komoyiib awingkiwen?” andoon. Yimbed inandiwen, “Om ediib, okyiri oon embeng yemoonbaniib kumbedmo.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kwane, Yesumbed kadaareb yaa yedmendoona okad yiri dibere winiwen. ");
INSERT INTO yon_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yesumbed om ediib okyiri oon embengiib be God yaa eso andekore, domabangkane ye kedmengkandeendan yaa bangkandoona yimbed ari nimakarub yaa kwane bangkandiwen. ");
INSERT INTO yon_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yi korem anenib mikmoniwen. Kwane, ye kedmengkandeendanbed animan ane ari koronde winiwen kuu kabed aom benkambungkiiwa kabed ediib yeedere wonoon. ");
INSERT INTO yon_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Karuwa nimaya danaya yi korem animan aniwen kuu karub 4,000iib. ");
INSERT INTO yon_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yaro Yesumbed kadaareb kuu yedme kondoona wenebiiwa, ye kuu parai motod aom awunoone bowan Galeli yara yane wene bidambib Magadan dia winiwen. ");
INSERT INTO yon_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kwane, Farisidan yoom Sedyusidan yoom Yesu yaa mene ye komboon wedmi ye dowad kaamoniwen kuu God yaromkono yaambed dud korokbok andiwed. ");
INSERT INTO yon_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesumbed inande yedmoon, “Oobne aron kubunanuun kuu yirim kanabaneen kuu yimbed yedmimaib, ‘Oo kwana kowe awari kuu amiibban keraneen.’ andimaib. ");
INSERT INTO yon_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kwane, amkimo yaro kangka kuu amukambidiib ambid dodmoyiib wedme ‘Kibikee am aron kii.’ andimaib. Yiib yiibkaad ambid arimbed komarewa korokbimaane kuu wedme kaadkerimaib, kumban kibikee komo keroon kee wedme id bene kaadkerindo. ");
INSERT INTO yon_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kukuu no arewa kamenib God yaa angkurom korokbenib kamimaibdan kumbed dud korokbe ande onmimo kamiib kii! Kumban ma dud korokbainban, no Yonambed dud korokboon kuu korokbaniin kumbedmo kui.” andoon. Andekore, Yesu kuyaa koronde domonde yaro wonoon. ");
INSERT INTO yon_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kwane, Yesu awene kuu bowan yara yaniwen kumban ye kedmengkandeendan animaniib maan yanindo nonondandiwen. ");
INSERT INTO yon_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kwane Yesumbed yi yaa yedmoon, “Kaadkerime. Yobdoodmo yiibka oone dobirime, Farisidaniib Sedyusidaniib yi flawa kabayingke obo keri yeman yaa.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kwane, weng kee yikarebmo id kuu komarewa kii ande andangke yedmiwen, “Anam kuu animan maandindo keruwen kwande dakmeen dee kii?” ande dakmiwen. ");
INSERT INTO yon_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kwane, dakmiib ye weng id kuu Yesumbed wedmendoon kowe yi yaa kaamondoon, “Yiib komandiwed animan maandindo andi ye weng dakmiib? Yiib anam andi kuu embengmo. ");
INSERT INTO yon_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yiib kuu id meenindoyoo? Meenime, om angkoyiibmo kumbed nimakarub 5,000 ariyiib kuu bangkanduuwe aniwen. Aniiwe, yiib kuu kabed komoyiib animan dungkun dungkun benkambungkiwen? ");
INSERT INTO yon_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma, om ediibmo kumbed nimakarub 4,000 ariyiib kuu bangkanduuwe aniwen, kwangkon yiib kuu kabed komoyiib animan dungkun dungkun benkambungkiwen? ");
INSERT INTO yon_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Komarewakob yiib kuu meeninban keriwen? Ne kuu yiib ande animan ye dowad dakmokban. Kumban kaadkerime, yobdoodmo yiibka oone dobirime, Farisidaniib Sedyusidaniib yi flawa kabayingki yeman yaa.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kwane, ye kedmengkandeendan kuu meeni kandiwen, Yesu kuu anam flawa aom kowiwed kabayingki yeman yaa kaadkerime andindo, ye kuu Farisidaniib Sedyusidaniib yi kedmengkandi yaa kaadkerimbed dobirime anded dakmeen. ");
INSERT INTO yon_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kwane, Yesu wene taun maa Saesaria Filipai dia wenene, ye kedmengkandeendan yaa kaamondoon, “Nimakarub kuu Karub Ye Mingki kuu kane andimaib?” andoon. ");
INSERT INTO yon_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Andoona, yimbed inande yedmiwen, “Yenambed yedmimaib kuu eb kuu Yoon Baptaisman andimaib, yenambed eb kuu Elaidya andimaib, kumban karub yenambed eb kuu Yeremaiya o profesiman maa ande kamiib kii.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kwane, Yesu kaamondoon, “Ma yiibbed kuu ne kane andiib?” andoon. ");
INSERT INTO yon_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Andoona, Saimon Pitambed inande yedmoon, “Ee, eb kuu wad doreen ye God ye Mingki, eb kuu yembed kinoona menewenman Keresu kui.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kwanandoone, Yesumbed inande yedmoon, “Ee, Saimon, Yona ye mingki, eb yaa Godbed amun kerubdoon, amborom kuu kekee karub maambed eb yaa kwane yedmebdokban, Nambe Ewen ari doreen kumbed korokbebdoon kowe. ");
INSERT INTO yon_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kwane, nembed eb yaa yedmaan kuu eb kuu Pita, eb kuu dumnad. Keye dumnad kwarimbed ne anam andidan ambib areb kuu ambangke kanyenbaniin. Kwane, bobni yaromkonombed monmaraanban. ");
INSERT INTO yon_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nembed Ewen aom ooni yeman yaromkono kabdaniina, kwane ebbed okad kiri kee komo yaa yii andaneeb kuu Ewen aom kwangkon yiminban keraneen. Kwane, ebbed okad kiri kee komo yaa ee andaneeb kuu Ewen aom kwangkon yimin keraneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Andekore, ye kuu Godbed Kinoona Monoonman Keresu ande dakmaib ye weng yedme kowoon, ye kedmengkandeendan yaa. ");
INSERT INTO yon_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kuyaron yaambed yaro ari kuu Yesumbed ye kedmengkandeendan yaa andowe dianmo daandoon, ye kuu Yerusalem aom wananeen kumbed Yuudan yi korok korokiib God dore Yuudan dore wedyiri dobiridan yi korok korokiib Yuudan yi amob kedmengkandidaniib kumbed ye kuu awinenib durud yewed maa maa konekoriwa, ye kuu ayaniiwa bobnaneen kumban aron ayoobmim ari kuu nenkoonaneene ika dembaneen ande daandoon. ");
INSERT INTO yon_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kwanandoone, Pitambed Yesu nen angkaro ongkane daanoon, “Yariman, kwamune keraneen kuu Godbed kebenok ai! Kwamune kuu eb yaa ma kwanaanban kii!” andoon. ");
INSERT INTO yon_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Andoona, Yesumbed neman Pita yaa amonombe inande daanoon, “Eb kuu Seten areb kerewen kii! Ne yaa kuu angkane! Eb kuu ne yaa boknande kombiri yeman kereeb kii! Eb kuu God ye inameniibban, karub yi inamenmo awinewen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kwamunekore, Yesumbed ye kedmengkandeendan yaa daandoon, “Kwane, karub kanembed ne yoman manandamoka, yekareb ye dowaken ye inamen kankubune yaro ye at ming kankarinekore, ne yoman monok. ");
INSERT INTO yon_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Karub kanembed yekareb ye wadkeri awinaneen kuu korem bobnaneen, kumban karub kanembed ne dowad yaambed ye wadkeri domonaneen kuu wadkeri anam kandaneen. ");
INSERT INTO yon_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Karub kuu nimakarub korem yaa burudande dore okad kumundin kiri kee korem yeka oonaneen kumban amaan ye kingkin kuu kumbaanban yamotbon yiri kankoraraneen kuu amun dee? Ye kuu komombed God yaa konekore, ye kingkin kuu kumbaanban yamotbon yiri kankorarokban keraneen? Dowan! ");
INSERT INTO yon_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Kwane, Karub Ye Mingki kuu Yawodki ye nambiriyiibbed ye engyusiib mananeen kuu nimakarub mimo mimo komo kamiwen ye kakman yi yaa bangkandaneen. ");
INSERT INTO yon_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nembed yiib yaa ke anam yedmendaan kei, yiib yena kane kane keyaa doriibdan kuu bobnaibbanbed wedmaniib kuu Karub Ye Mingkimbed korok kere oonaneen kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aron benmeyiib dowan keruuna arimbed, Yesu yaro Pita yoom Yems yoom Yoon Yems ye daman yoom kwamune be aangko ambab ari daanoon, yimbirimo keriwen. ");
INSERT INTO yon_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kwane, yi doriiwa Yesu yaa God ye nambiri monoon, yeka mamaa keroon. Kwane, ye murubia kuu aron yuremoon areb nambiri darewoob keruune, yebkad kuu kawanmo kawurimbon anam keroon. ");
INSERT INTO yon_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kwane kuyaambed, Moses yoom Elaidya yoom kuu angkadere Yesu yoom dobiriiwe, Yesu yoom weng dakmenabiwen. ");
INSERT INTO yon_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dakmo doriiwa, Pitambed Yesu yaa yedmoon, “Yariman, kekee amun, nuwiib ke doburuub kei. Ewiib dowaken kerebka, nembed kombon ayoobmimiib banaba. Ma eb, ma Moses, ma Elaidya.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita weng mogeed dakmeen aombed wiib kawanmo kande bokne kebeneen. Ku kebeneen ye niindem aombed wengmo baande daandoon, “Kekee ne Dana, ne mimyob dowakeniib kubiyiib darewoob ye ari kowaan. Ye weng kuu wengambirime!” andoon. ");
INSERT INTO yon_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kwane, ye kedmengkandeendan kuu wengamberekoriwa, yi kuu uni darewoob kerenib, murubia ben okad yiri kiribe kirobiwen. ");
INSERT INTO yon_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kumban Yesumbed mene badmende daandoon, “Yeedirime, unaib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kwane, yi deedere korok kankoone ari wedmibka karub yenayiibban, Yesu yembedmo. ");
INSERT INTO yon_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kwane, kwari koronde aangko ika yiri kamenoniiwa Yesumbed wedya daandoon, “Komo wedmiwen kuu karub yena yaa wene ari ogoodmo kwamune dakmenmo yarebaib. Kwane bikniiwo wene ari ne bobnaniin yirimbed angkon ika dembaka.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kwane, ye kedmengkandeendan kumbed kaamoneniwen, “Komande kwane Yuudan yi amob kedmengkandidanbed Elaidya kuu yedin mananeenkob andimaib?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kwane, Yesumbed yi yaa inande yedmoon, “Kuu anam, Elaidya kuu yedin menene ongmi ye dowad korem nekwaneen. ");
INSERT INTO yon_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kumban nembed yiib yaa ke yedmendaan kei, Elaidya kuu monoona dowan keroon. Monoon kumban korobe wedmenib anam Elaidya kii ande kamindo, no kwane yi meeni dowaken korem kuu ye yaa kwaniwen. Kwamune areb kuu Karub Ye Mingki yaa kangkon durud yewed konaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kwane, ye kedmengkandeendan kuu meenenib inamen kandiwen kuu Yesu kuu Yoon Baptaisman ye dowad ande dakmeen. ");
INSERT INTO yon_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kwane, Yesu yoom ye kedmengkandeendan yoom ika kawene kadaareb doriib yaa miniiwa, karub maa mene Yesu ye murubia arimbed bumangke ");
INSERT INTO yon_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","yedmoon, “Yariman, eb ne dana yaa mimyob keene. Ye kuu kot awarak ayimaun arewa anam wedmimaan kowe, aron yemoon ayene kan ok yiri korare amot yiri korare kamimaun. ");
INSERT INTO yon_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nembed eb kedmengkandeebdan yaa nenmanaan, kumban yi ongmenindo yiminban keriwen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kwane, Yesumbed inande yedmoon, “O nimakarub korem, yiib kuu anam andindebandan wabkaddan kii! Aron komoyiib kwane yiib yoom dobaraniin? Aron komoyiib kwane yiib karekmi wedme dobaraniin? Dana kuu nenmene.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kwanandekore, Yesumbed awad arewa kuu yedme anburoona dana ye niindem aombed yeedoroon. Kwane kuyaambed amun keroon. ");
INSERT INTO yon_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kwane, amaan, ye kedmengkandeendan yoom Yesu yoom kwane karub yenayiibban yimbirimo keriiwe, Yesu yaa kaamoneniwen, “Komoyiibkob nubbed awad arewa kuu yedme anburinban keruwen?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Kwanandiiwe, Yesumbed inandoon, “Yiib kwanindo keriwen amborom kuu yiib anam andi kuu wuudmo. Kedi, nembed yiib yaa ke anam yedmendaan kei, yiib anam andi kuu aromne mastet yob embeng mana areb keraneen kuu aangko yaa baande yedmaniib, ‘Yakuri wene.’ andaniiwa kwananuun. God ye inameniib komo kamandameeb kuu yiminmo.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kuyaambed Yesu ye kedmengkandeendan korem Galeli angka ibmo nedbe doriiwa yembed yedmendoon, “Karub Ye Mingki kuu karub maambed ambodangene awine kan karub yena yi dingki ari kowaneen kii. ");
INSERT INTO yon_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kwamunenib ayaniiwe bobnaneen, kumban aron ayoobmim ari Godbed bobnoon yirimbed kankoonaneena dembaneen.” andoon. Kwanandoone, ye kedmengkandeendan wengamberekoriwa, miin kubiyiibban kere anam mimyob wandiwen. ");
INSERT INTO yon_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kwane, Yesu yoom ye kedmengkandeendan yoom Kapeenaum yaa wene dawuniiwe, kurikuri boyambib darewoob ye tak od bimaibdan yaro mene Pita yaa kaamoniwen, “Yiib kedmengkandi korok kuu kurikuri boyambib darewoob ye tak od kowimaanoo?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kwane, Pitambed yedmoon, “Eyoka, kowimaanaa.” andoon. Amaan, Pita kuu ambiwoom dawuro wonoone, Yesumbed yedin Pita yaa yedmoon, “Saimon, eb komarewa meeneeb, kingbed ye tak od kuu karub kane yaambed bimaan, ye mingki yaambed dee, yena yaambed dee?” andoon. ");
INSERT INTO yon_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kwane, Pitambed Yesu yaa inande yedmoon, “Yi kuu karub yena yaambed bimaib.” andoon. Kwanandoone, Yesumbed Pita yaa yedmoon, “Kwana kowe, king yi dana kuu tak od kowaibban. ");
INSERT INTO yon_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kumban nub yi yaa kowaubban kuu nub yaa kongendaniib kuu ne dowakenban kowe, wene pating kanwene ok bowan angka kamberene oon ibduruk kandaneeb kuu mongkodkono dankone wedmaneewa, od murubkob angkimbaranuun kuu kanduneb, wene ne tak odiib ewiib kwane kowe.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kuye aron kuu kedmengkandeendanbed Yesu yaa mene kaamoniwen, “Kanembed Ewen aom kuu aningko darewoob keraneen?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kwanandiiwe, Yesumbed dana embeng yaa baandoona monoona, yembed nende yi murubia ari kowoone doboroon. ");
INSERT INTO yon_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kwane, Yesumbed yedmoon, “Nembed yiib yaa ke anam yedmendaan kei, yiib korobe amonombe dana kamune areb keraniib kumbed Ewen aom awunaniib. Ma kwanokban keraniib kuu awunaibban. ");
INSERT INTO yon_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kwani kowe, karub kanembed yeka kankubune dana mana keyareb keraneen kumbed Ewen aom aningko darewoob keraneen. ");
INSERT INTO yon_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Karub kanembed naningko yaambed dana mana kee areb yaa kubenaneen kuu ne yaa kwane kubewaneen kii. ");
INSERT INTO yon_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Kumban kanembed dana kamune kere ne yaa anam andoonman keyaa dedmobaneenkob ambarakmaneen kuu, amun kuu ibduruk kuye karub kuu awine bot darewoob kande kongkono yaa borokne kan karamok yiri kaniwed niindem ambab yiri kankubuni kumbed yimin. ");
INSERT INTO yon_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Okad kiri doriibdan, kaadkerime! Dedmobenako ambarakmok andi yeman yemoon dangoon. Kwane arewa kuu dembimaan, kumban kanembed kwamune arewa kame andaankob kwane dembimaan ye karub kuu durud yewed arewa ye yaa mananeen. ");
INSERT INTO yon_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kwane, eb yon o dingkimbed dedmonoonkob ambarakmewen keroka, wankorarunde. Kwananeeb kumbed dingki mimomo o yon mimomo kuyiib aron korem korem ye wadkeri kandaneen kuu amun. Ma kwamune yon ayoob o dingki ayoob kuyiib dobaraneeb kuu eb nen kumbaanban yamotbon yiri koraraneen kuu arewa. ");
INSERT INTO yon_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kwane, eb indobbed dedmonoonkob ambarakmewen keroka, biangkande korarunde. Kwananeeb kumbed indob yaramo aron korem korem ye wadkeri kandaneeb kuu amun. Maa kwamune indob ayoowiib dobaraneeb kuu eb nen kumbaanban yamotbon yiri koraraneen kuu arewa. ");
INSERT INTO yon_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Yiib kaadkerime. Aningkoyiibban ne yaa anam andiwendan keyaa kankubunaib. Kedi, nembed yiib yaa ke yedmendaan kei, nimakarub keyi oonimaib yi engyus Ewen ari doriib kuu Nambe God ye kerebiri ari kwane doberembirimaib. ");
INSERT INTO yon_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Yiib kuu komarewa meenaniib? Kekamune karub maa sibi 100iib kumban mimo kuu wene biknaneen kuu, ye kwane 99iib kuu aangkombon ari domondekore, wene biknoon kuu kereknanmo yaraneen dee? Kwananeenaa! ");
INSERT INTO yon_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kwane, nembed yiib yaa ke anam yedmendaan kei, sibi wedmaneen kuu kubi darewoob keraneen, kwane sibi 99iib wene biknindo yaa kuu kubi embengmo. ");
INSERT INTO yon_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kwamune areb, yiib Ambe Ewen ari doreen kuu ye dowakenban anam andidan aningkoyiibban mimo ma bikni kuu yiminban. ");
INSERT INTO yon_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kwane, anam andi ye karub maambed eb yaa ambarakmoka, wene yiib ayoobmo keroka komo ambarakmoon kuu daane. Kwane, eb weng wengamboroka, amun eb awaneneb kowe ye o yu kuu eb daman kereeb kii. ");
INSERT INTO yon_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma, ye kuu eb weng kankoraroka, angkon ika karub mimo o ayoob ben eb yaa dabokne wene wengane. Weng korem ku dakmaneeb kuu yi ayoowiib indob indob wedmiib weng wengambere keraniib kowe, yi kuu eb weng ibmo kere dakme korokbi yeman. ");
INSERT INTO yon_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yi ayoowiib kwangkon kwane wengambirinban anam keroka weng kanwene kurikuri ye korok korok yaa daande. Kurikuri ye korok korok yi weng kwangkon kwane wunesadmi ye karub keraneen kuu anam andindodan o tak od bidan yaa komo kwanimaab areb ye yaa kwangkon kwame. ");
INSERT INTO yon_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nembed yiib yaa ke anam yedmendaan kei, yiibbed okad kiri kee komo yaa yii andaniib kuu Ewen aom kwangkon yiminban keraneen. Kwane, yiibbed okad kiri kee komo yaa ee andaniib kuu Ewen aom kwangkon yimin keraneen. ");
INSERT INTO yon_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Angkon nembed yiib yaa ke yedmaan kei, yiib aombed ayoob kuu komo yaambed weng kan mimo kerenib God yaa kaamonem andaniib kuu Nambe Ewen ari doreen kumbed yiib dowad kwananeen. ");
INSERT INTO yon_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwane, yiib ayoob o ayoobmim doberenib naningko yaambed kowenib weng kan mimo keraniib kuu, ne kangkon yi yaa dabokne dobaraniin.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kwane, Pitambed menene Yesu yaa kaamonoon, “Yariman, nangkodmimbed ne yaa ambarakmaneen kuu, ye yaa are nonondande komoyiib keraniin? Yewudmo kameni kimingke ediib keraniinoo?” andoon. ");
INSERT INTO yon_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kwane, Yesumbed inande yedmoon, “Eb yaa ke yedmaan kei, yemoonmo are nonondande ediibmomban, 77iib kii. ");
INSERT INTO yon_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwamunekob, Godbed korok kere ooni yeman kuu kwamune areb. King kuu mene ye deme karubbed ye yaa dungkum keriwen kuu inewime andi dowad baande kamoon. ");
INSERT INTO yon_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kwane, king kuu od andowe boon. Been ye niindem aombed karub mamaa nenminiwen kuu king yaa od gold darewoob yaningko talen 10,000iib kuyaa dungkum keroon. ");
INSERT INTO yon_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kumban ye korok yaa od koni kuu yiminban kowe, ye korokbed dungkum karuwiib ye wonongiib dana meediib ye yiribman koremiib ben ari berengkekore od kanda ye weng kowoon. ");
INSERT INTO yon_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kwanandoone, karub kuu kirod bumangkane okad yiri korok kankibinene eekme yedmoon, ‘Ne yaa yodbirimban iwari meedmeewo, eb dungkum ne yaa kuu korem ari inebda.’ andoon. ");
INSERT INTO yon_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kwanandoona, kingbed ye yaa mimyob keenekore yedmoon, ‘Ne dungkum eb yaa kuu korondaan kii. Kowe, eb koronde wene.’ andoona wonoon. ");
INSERT INTO yon_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kumban deme karub kuu wene ari yangkodmi deme karub mamaa wedmenoon. Yangkodmi kumbed od silvaa yaningko denari 100iib dungkum keroon kowe, karub kuu kongkono yaambed awine kanyobene yedmoon, ‘Ne dungkum kuu kankawe!’ andoon. ");
INSERT INTO yon_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kumban yangkodmi kuu kirod bumangkane eekme yedmoon, ‘Ne yaa yodbirimban iwari meedmeewo, eb dungkum ne yaa kuu ari inebda.’ andoon. ");
INSERT INTO yon_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kumban yangkodmi ye weng wengambere kankorarekore, yaro awine kanwene wii aom kaanoon, kwane wii aombed dobere dungkum kuu kowe wankarekore yeediri yeman. ");
INSERT INTO yon_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Kwane, king ye demedan yenambed komarewa keroon kuu wedmekoriwa, kubiyiibban miin darewoob kandekorib, wene king yaa weng korem daaniwen. ");
INSERT INTO yon_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kwane, kingbed ye deme karub kuu ika baandoona awunoona yedmenoon, ‘Eb kuu deme karub miin arewa anam. Ne dungkum korem eb yaa angkuun kuu kowaab koronde ande kebenaan, amborom kuu ebbed ne yaa mimyob keewe ande yedmeeb kowe kwanaan. ");
INSERT INTO yon_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kumban angkon komoyiibkob eb kuu kwane wene eb deme angkodmi yaa mimyob keenokban, nembed eb yaa mimyob kowaan areb kerindo kerewen?’ andoon. ");
INSERT INTO yon_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kowe, kwane king kuu arud wandekore yedmoone, karub kuu wii oonidanbed awine nenwene wii aombed yewed konembiriwed, wene ye dungkum korem kuu ingkane dowan keraneen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Andekore, Yesumbed ika yedmoon, “Yiib kuu yiib angkodmia yi ambarakmi yiib yaa kuu anam are nonondandaibban kuu, weng kee kwamune areb Nambe Ewen ari doreen kumbed yiib yaa kwananeen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kwane, Yesu weng ku dakmeen korem dowan kerekore, ye Galeli angka koronde Yudea angka yaro dore wene ok Yooden yara yanoon. ");
INSERT INTO yon_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kuyaa nimakarub yemoon kai menebe yoman kerenen winiiwe, bob anikaddan korem ongmenaboon. ");
INSERT INTO yon_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kwane, Farisidan yena kuyaa menenib, Yesu yaa komboon kaamoni ye dowad miniwen. Kwane, yimbed kaamoniwen, “Kekamune kee amob dee? Karub maa ye wonong kuu idiib o idiibbanbed domondaneen kuu yimin dee?” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kwane, Yesumbed inande yedmoon, “Weng kee yiib ma kimingkindokowoo? God Ye Weng aombed wongkoon kuu kwane andowoon yiri kuu Ambengkan Godbed ‘karuwiib wonongiib ayoob ongmenaboon’. ");
INSERT INTO yon_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kwane, Godbed yedmoon, ‘Kwamunekob, karub kuu yawodkia awaana domonde ye wonong yaa daboknaneen, daboknaneena yi ayoob kuu id mimo keraniib.’ andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kowe, yi kuu id ayoobban, mimo. Kwana kowe, komo Godbed kandaboknoon kuu karubbed bongme dankorari kuu yiminban.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kwanandoone, yimbed kaamoniwen, “Kwani kowe, komande Mosesbed amob kee yedme kowoon? Karub kuu ye wonong yaa domondi ye kerekiib wongke kondekore, domondod wini kuu yimin.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kwane, Yesumbed neman inandoon, “Mosesbed yiib yaa wonong domondi kuu yimin ande kowoon, amborom kuu yiib niindem aom kuu kamkono kowe. Kumban andowoon yirimbed kuu kiwaan maa, kwamuneyiibban dowan. ");
INSERT INTO yon_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nembed yiib yaa ke yedmendaan kei, karub kanembed ye wonong domondekore, wonong maa awananeen kuu nenem kamaneen. Kumban wonongbed nenem kamanuunkob domondaneen kuu yimin.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kwanandoone, kedmengkandeendanbed ye yaa yedmiwen, “Ambimban yi dobiri kuu kwamune dakmewen areb angkimboroka, amun kuu wonong awanimban korondi kuu yimin.” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesumbed yi yaa inande yedmoon, “Godbed kane kane yaa kuye weng kondoon kuu kwamune dobaraniib. Yena kuu awine dobaraibban. ");
INSERT INTO yon_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kedi, karub yena kuu yi enaya yi kabeyob aombed kubuyowiibban keroon kowe, wonong awanindeban. Yena kuu karub yenambed kubuyob biwen kowe, kwangkon wonong awanindeban. Yena kuu wonong awani kuu yi dowakenban keriwen, korondiwen amborom kuu yi dowaken darewoob kuu Godbed korok kere ooni yeman ye inamenmo awinandamiib kowe. Kane kane kuu wonong awanimban ye weng kee dowakeniib keraniib kuu awine dobirime.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kwane, dana bongbong kuu yi arianbed ben Yesu yaa miniwen, yembed dana yi ari dingki awingke amun kerunde kurikuri kamendok andiwed. Kumban kedmengkandeendanbed dana yi arian yaa be winime ande ongkande kebengkiwen. ");
INSERT INTO yon_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kwaniiwe, Yesumbed yedmoon, “Yiib korondiiwo, dana bongbong kuu ne yaa minime yiib kebengkaib. Godbed korok kere ooni yeman kuu dana bongbong kamune yi inamen areb keraniib kumbed awunaniib.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kwane, Yesumbed dana bongbong ari dingki kowe amun kerunde kurikuri kame dowan kerekore, yaro kuyaambed wonoon. ");
INSERT INTO yon_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kwane, karub kewedman maa Yesu yaa menene kaamonoon, “Kedmengkandi korok, komarewa kereni amun deme awineni, wadkeri aron korem korem kuu kandaniin?” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kwane, Yesumbed inande yedmoon, “Komandewed amun ye dowad ebbed ne yaa kaamoweeb? God yembedmo kuu amun. Eb dowaken wadkeri kanda andebka, amob weng wengambere kande.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kwane, kewedmanbed kaamonoon, “Amob kunambed awinaniin?” andoon. Kwane, Yesumbed inandoon, “Kumka o kuman ayaab, nenem kamaab, yid baab, kangdod aom dudi weng dakmaab, ");
INSERT INTO yon_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","eb ambeya enaya yaa meene wengambere, kwane ebka ebmeren mimyob dowaken kowimaab areb eb dia doriibdan yaa mimyob dowaken keende.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kwane, kewedman inande yedmoon, “Amob korem kee ibmo kwane oone awinaan. Kumban komo maa awinaniin?” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kwane, Yesumbed inandoon, “Eb dowaken eb inamen aom demkoronmo kerande kamebka, wene eb yiribman korem kuu ben ari berengke od bekorewa, od kuu kamboknondan yaa bangkandekoreb, eb kakman kuu Ewen aombed angkimbaraneen. Kwananeeb ye yoman ari kuu ne yoman mene.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kwane, kewedman kuu kuye weng wengamberekore, kubiyiibban kere koronde wonoon, amborom kuu yiribman yemooniib kowe. ");
INSERT INTO yon_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kwane, Yesumbed kedmengkandeendan yaa yedmoon, “Nembed yiib yaa ke anam yedmendaan kei, yiribman yemoon ye karub kuu yekareb kankubunekore Ewen arimbed doreen ye Godbed korok kere ooni yeman aom awuni kuu yobdood. ");
INSERT INTO yon_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Angkon ma nembed yiib yaa ke yedmaan kei, kemo kuu nidoro dem awunaneen kuu yobdood dee? Yiribman yemoon ye karub kuu yekareb kankubunaneen kumbed Godbed ye korok kere ooni kuu kekamune ye yobdood burudande yobdood aman ari kii.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kwane, kedmengkandeendan keye weng wengamberekorib, yi kuu binangki darewoob kerenib kaamoniwen, “Kwana kowe, kane kuu yimin kii? Godbed bobni yaa kuu ma burudande nendaanban kii!” andiwen. ");
INSERT INTO yon_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kwane, Yesumbed yi yaa wedmende yedmoon, “Karub yaromkono yaambed kuu kwanindeban, kumban God yaromkono yaambed kuu yimin. Godbed komo kamandameen kuu kwananeen.” andoon. ");
INSERT INTO yon_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kwane, Pitambed inande yedmoon, “Kedi, nub kuu yiribman korem kiraru