﻿USE sofia;
DROP TABLE IF EXISTS sofia.yom_vpl;
CREATE TABLE yom_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yom_vpl WRITE;
INSERT INTO yom_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Lusakumunu kuidi mutu wowo wunkambu landakananga zindongi zi batu bambimbi, wunkambu telamanga mu nzila yi minsumuki, ayi wunkambu vuandanga va kimosi ayi mimvuezi. ");
INSERT INTO yom_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Vayi wummonanga khini mu mina mi Yave ayi wunyindulanga miawu muini ayi builu. ");
INSERT INTO yom_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Mutu beni widi banga nti wukunu va muenda nlangu ; wowo wumbutanga makundi mu tsungi andi ayi meza mandi mayumanga ko ; weti mona mamboti mu mamo keti vanganga. ");
INSERT INTO yom_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Vayi buawu ko buididi kuidi batu bambimbi, badi banga biti bivevumunu kuidi phemo. ");
INSERT INTO yom_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Diawu, batu bambimbi balendi telama ko mu lumbu ki tsambusu, voti bankua masumu mu lukutukunu lu batu basonga. ");
INSERT INTO yom_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Bila Yave zebi nzila yi batu basonga, vayi nzila yi batu bambimbi yela biva. ");
INSERT INTO yom_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Bila mbi makanda mafuemini e ? Bila mbi batu balembo yindudila mambu makambulu fuana e ? ");
INSERT INTO yom_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Bila mbi mintinu mi ntoto mitelimini e ? Bila mbi minyadi mikutikinini va kimosi mu nuanisa Yave ayi mutu andi kavinda mafuta e ? ");
INSERT INTO yom_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Balembo tubi : “tuzenganu minsinga miawu ; tulozanu thama zisieni ziawu.” ");
INSERT INTO yom_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Mutu wowo wunkalanga ku Diyilu wulembo sevi. Pfumu wulembo basekinina. ");
INSERT INTO yom_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Bosi wulembo bayolukila mu nganzi andi, ayi wulembo kuba monisa tsisi mu miangu miandi mi ngolo. ");
INSERT INTO yom_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Ayi wutuba : “Minu ndibieka ntinu ama ku Sioni, mongo ama wunlongo.” ");
INSERT INTO yom_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Ndiela yamikisa lukanu lu Pfumu : Yave wukhamba : “Ngeyo widi muanꞌama. Minu ndibutidi mu lumbu kiaki.” ");
INSERT INTO yom_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Wundombi ayi mandivana makanda ; ma maba kiuka kiaku ayi mawu vua ntoto wumvimba nate mu sukisina ntoto beni. ");
INSERT INTO yom_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Wela kuba yadilanga mu nkawa wu sengo ; wela kuba bula banga bu mbudikilanga nzungu yi tuma. ");
INSERT INTO yom_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Diawu, beno mintinu, bika luba nduenga. Bosi beno mazuzi ma ntoto, bika lutambula ndongokolo ; ");
INSERT INTO yom_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","lusadila Yave mu lukinzu ayi lumona khini mu lukhuku. ");
INSERT INTO yom_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Lubumbakana muana mu diambu di kedi fuema ; ayi luedi bungana mu nzilꞌeno. Bila mu mbuetolo yi meso nganzi andi yilenda vika wulama. Lusakumunu kuidi batu boso bobo bantombanga suamunu mu niandi. ");
INSERT INTO yom_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Nkunga Davidi mu thangu katina muanꞌandi Abisaloni. A Yave, tala buevi badidi woka bobo bandendidi ; batu bawombo balembo ndiendila manenga. ");
INSERT INTO yom_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Bawombo balembo tubi mu diambu diama : “Nzambi kalendi kunkula ko.” ");
INSERT INTO yom_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Vayi ngeyo, widi nkaku ama, a Yave. Ngeyo nkemboꞌama, ngeyo wumvumbulanga ntu ama. ");
INSERT INTO yom_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Ndinyamikinanga kuidi Yave. Niandi wukuphutudilanga mvutu tona ku mongo andi wunlongo. ");
INSERT INTO yom_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Ndinlambadala, ndinleka tulu ayi ndinkotukanga ; bila Yave niandi wukukhebanga. ");
INSERT INTO yom_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Nditinanga ko tsisi yi makabu mawombo-wombo ma batu bobo banzungididi ndambu ayi ndambu. ");
INSERT INTO yom_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Yave telama ; ngeyo Nzambi ama, wukhudi. Bila ngeyo wubetidi bambeni baama baoso mu matama. Wukoludi meno ma batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Kuidi Yave kumbanga phulusu. Bika lusakumunu luaku luba kuidi batu baku ! ");
INSERT INTO yom_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Nkunga Davidi, kayimbidila mu bisiku bi zitsinga mu diambu di pfumu minyimbidi. Wuphutudila mvutu bu ndilembo kutedi, a Nzambi ama yisonga ayi wutsadisa bu ndidi mu phasi ; wumboni kiadi, wa lusambulu luama. ");
INSERT INTO yom_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Nate thangu mbi luela, tatamana fuisa nkembo ama tsoni e ? Nate thangu mbi luela tatamana zodilanga vanga mambu ma phamba ayi tombanga zinzambi zi luvunu e ? ");
INSERT INTO yom_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Luzaba mboti ti Yave wukisobudidi mutu wumosi wunkinzikanga mambu mandi. Yave wela wa mu thangu ndiela kuntela. ");
INSERT INTO yom_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Ku tsi nganzi eno, kadi vola masumu. Mu thangu luidi mu zimbuka zieno, lufiongunina mintima mieno bosi luba dio sui. ");
INSERT INTO yom_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Lutambika makaba ma busonga, ayi lutula diana dieno mu Yave. ");
INSERT INTO yom_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Bawombo balembo tubi : “Nani wulenda kutumonisa mamboti e ?” Bika kiezila ki zizi kiaku kitukienzula, a Yave ! ");
INSERT INTO yom_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Wuwesidi khini yiwombo mu ntimꞌama, viokila yoyi yiba yawu mu thangu baba ble yiwombo ayi vinu kiwombo ");
INSERT INTO yom_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ndiela lambadala ayi ndiela leka tulu mu ndembama bila ngeyo veka kaka, a Yave bila ngeyo veka kaka wukuphuandisanga mu luvovomo. ");
INSERT INTO yom_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Wuyimbidila wawu mu flute. A Yave, tamba dikutu mu mambu mama ayi tala vumina kuama. ");
INSERT INTO yom_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Dimba yamikina kuama bu ndilembo tombi lusadusu A ntinu ama ayi Nzambi ama bila ngeyo ndieti sambila. ");
INSERT INTO yom_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","A Yave, mu nsuka ngeyo weti wa mbembo ama. Mu nsuka ndieti tula zindombolo ziama va ntualꞌaku ayi ndieti vingila mvutu mu diana. ");
INSERT INTO yom_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Bila ngeyo wisiko Nzambi wummonanga khini mu mambu mambimbi ; mutu wumbimbi kalendi vuanda ko va kimosi ayi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Batu badi luniemo balendi telama ko va meso maku. Ngeyo weti lenda batu boso bobo bamvanganga mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Ngeyo wumbunganga batu bantubanga luvunu. Batu bobo bantengulanga menga ayi bobo bamvunanga, Yave weti kuba kakumukina. ");
INSERT INTO yom_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Vayi minu ndiela kota mu nzoꞌaku mu diambu di kiadi kiaku kinneni ndiela buongama mu lukinzu mu Nzoꞌaku Nzambi Yinlongo. ");
INSERT INTO yom_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Wuthuadisa, a Yave mu busonga buaku mu diambu di bambeni ziama. Ludika nzilꞌaku ku ntualꞌama. ");
INSERT INTO yom_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Bila kuisi ko mambu malenda siwulu diana mu miunu miawu ; mu mintima miawu muwedi mambu mambivisanga. Phovilakꞌawu yidi ziami kizibuka ayi mu ludimi luawu bantubilanga luvunu. ");
INSERT INTO yom_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Wuba monisa ti mu nzimbala badi, a Nzambi. Bika mayindu mambimbi mawu ma babuisa. Wuba kuki mu diambu di wombo di masumu mawu Bila ngeyo bafuemini. ");
INSERT INTO yom_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Vayi bika babo bantomba suamunu mu ngeyo bamona khini. Wuba bika bayimbila mu khini mu zithangu zioso ayi bika wuba keba. Muingi bobo beti zola dizina diaku, bamona khini mu ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Bila bukiedika ngeyo Yave wunsakumunanga mutu wusonga ; Wubazungidila mu mamboti maku banga nkaku. ");
INSERT INTO yom_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Nkunga Davidi kuidi pfumu minyimbidi, wuyimbidila wawu mu ngitala yi nana di zitsinga. A Yave, kadi kuthemina ku tsi nganzi aku ayi kadi kuphana thumbudulu bu widi ku tsi miangu miaku mi ngolo. ");
INSERT INTO yom_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Wumbona kiadi a Yave bila ndidi wulebakana, A Yave wumbelusa bila mimvesi miama mieka nduka fua. ");
INSERT INTO yom_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Muelꞌama wulembo yami, Nate thangu mbi, a Yave, nate thangu mbi e ? ");
INSERT INTO yom_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Vutikisa ntima, a Yave, wukhudi, wuphukisa mu diambu di luzolo luaku lu ngolo. ");
INSERT INTO yom_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Mutu kalendi kutebukila moyo ko niandi fua. Ayi nani wela kuzitisa ku tsi bafua e ? ");
INSERT INTO yom_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Mbemana vonga kuna ku kunga ; builu bu mvimba ndieti bodisa mbukꞌama mu bidilu, ndieti bodisa buangu ki ndieti leka mu matsuela. ");
INSERT INTO yom_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Meso mama mabividi mu diambu di kiadi, ayi manunini mu diambu di bobo beti kundenda. ");
INSERT INTO yom_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Botukanu va ntualꞌama beno boso lumvanganga mambu mambimbi. Bila Yave wuwilu bidilu biama. ");
INSERT INTO yom_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Yave wuwilu yamikina kuama mu diambu di kiadi Yave kikinini lusambulu luama. ");
INSERT INTO yom_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Bambeni ziama zioso baela fua tsoni ayi bela ba boma-boma. Bela vutikisa ku manima ayi bela fua tsoni mu nsualu. ");
INSERT INTO yom_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Nkunga wu maniongo wu Davidi kayimbidila Yave mu diambu di KUSI, muisi dikanda di Benzami. A Yave, Nzambi ama, kuidi ngeyo ndintombilanga suamunu kiama. Wuphukisa mu babo beti kundandakana ayi wukhula. ");
INSERT INTO yom_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Muingi babika ku khanzuna banga khosi ayi kunzenga mu bitini mu kambu mutu wulenda vukisa. ");
INSERT INTO yom_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","A Yave, Nzambi ama, enati ndivengi mawu ayi enati nzimbala yidi mu mioko miama ; ");
INSERT INTO yom_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","enati ndivutudi mambimbi kuidi mutu wubedi zinganga yama mu ndembama, voti ndiziona, mu kambu bila, bima bi mutu wundenda, ");
INSERT INTO yom_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","buna bika mbeni ama kandandakana ayi kambakidila ; bika kadiatidila luzingu luama va tsi, ayi kandekisa mu mbungi-mbungi. ");
INSERT INTO yom_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","A Yave, telama ku tsi nganzi aku, Nuanisa miangu mi ngolo mi bambeni ziama. A Nzambi ama, kotuka bika wundungisa. ");
INSERT INTO yom_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Bika lukutukunu lu batu bazungidila, bika wuba yadila bu widi ku diyilu ");
INSERT INTO yom_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Bika Yave wusambisa batu A Yave, wutsambisa boso buididi busonga buama ayi boso buididi fuanana kuama, a Nzambi yizangama ");
INSERT INTO yom_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","A Nzambi yi busonga, ngeyo wumfionguninanga mintima ayi mayindu ma batu, manisa makhemi ma mutu wumbimbi ayi tula mutu wusonga mu luvovomo. ");
INSERT INTO yom_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Nzambi yizangama niandi nkaku ama ; niandi wumvukisanga batu babo badi mintima milulama. ");
INSERT INTO yom_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Nzambi niandi zuzi disonga, Nzambi wummonisanga miangu miandi mu kadika lumbu. ");
INSERT INTO yom_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Enati kakadi balula mavanga, wela lengula sabala kiandi, wela leki mbasꞌandi ayi kuwukubika. ");
INSERT INTO yom_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Wukubika binduanina biandi bi lufua wulembo kitula madionga mandi madionga ma mbazu. ");
INSERT INTO yom_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Niandi widi mu buemba bu mambimbi ; widi mu kubika ziphasi ayi butidi mambu ma luvunu. ");
INSERT INTO yom_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Niandi wukaba dibulu ; wudikulula dimula ayi wubua mu dibulu di kakaba niandi veka. ");
INSERT INTO yom_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Ziphasi ziozi kakubika zimbuididi niandi veka ayi tsitꞌandi yibuidi va dikosi diandi. ");
INSERT INTO yom_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Ndiela vutudila Yave matondo mu diambu di busonga buandi. Ayi ndiela yimbidila nzitusu wu dizina di Yave wuzangama. ");
INSERT INTO yom_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Nkunga Davidi kuidi pfumu minyimbidi mu ngitala yi basi Ngati. Yave, Pfumu eto ! Tala buevi dizina diaku didi di nzitusu va ntoto wumvimba. Ngeyo wutula nkemboꞌaku viokila diyilu. ");
INSERT INTO yom_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Mu bididi bi bana balezi ayi bi bana batsombi, ngeyo wutuma mu totukila nzitusu mu diambu di bambeni ziaku ; mu diambu di kanga miunu mi bobo beti ku lenda, ayi mutu wowo wumvutulanga mambimbi mu mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Bu ndieti tala diyilu diaku, kisalu ki minlembo miaku, ngonda ayi zimbuetete ziozi wutula va buangu ; ");
INSERT INTO yom_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","buna mbi biobi mutu mu diambu wuntebukilanga moyo, ayi muana mutu mu diambu wumbelanga mayindu e ? ");
INSERT INTO yom_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Ngeyo wumvanga kaba fioti ku tsi bivangu bi diyilu ayi ngeyo wumvuika nkembo ayi nzitusu, ");
INSERT INTO yom_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Ngeyo wunkitula nyadi mu bisalu bi mioko miaku, ngeyo wutula bima bioso ku tsi malu mandi : ");
INSERT INTO yom_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","mamemi moso ayi zingombi zioso ; bibulu bioso binsitu, ");
INSERT INTO yom_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","zinuni zi yilu ayi zimbizi zi mbu, bibioso bindiatilanga mu minsolo mi mbu. ");
INSERT INTO yom_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","A Yave, Pfumu eto ! Tala buevi dizina diaku didi di nzitusu va ntoto wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Nkunga Davidi kuidi pfumu minyimbidi mu lufua lu muana. Ndiela kuzitisa, a Yave, mu ntimꞌama wumvimba. Ndiela yamikisa matsiminanga maku moso. ");
INSERT INTO yom_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Ndiela mona khini ayi ndiela sakadala mu ngeyo, Ndiela yimbidila nzitusu mu diambu di dizina diaku, ngeyo Nzambi wuzangama. ");
INSERT INTO yom_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Bambeni ziama balembo vutukisa ku manima, balembo bumina zithutu ayi balembo bungana va ntualꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Bila ngeyo wunzengidi nkanu mu busonga, wudedisidi mambu mama ; ngeyo wuvuendi va kundu kiaku ki kipfumu mu sambisa mu busonga. ");
INSERT INTO yom_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Ngeyo wutemina makanda, wubunga mutu wumbimbi, wukubula mvimba mazina mawu mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Mbivusu yikambulu tsukulu yibuididi bambeni ; wutiolumuna mavula mawu ayi malendi buela tebukulu moyo ko. ");
INSERT INTO yom_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Yave wunyalanga mu zithangu zioso ; wukubika kundu kiandi ki kipfumu mu diambu di sambisa. ");
INSERT INTO yom_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Wela sambisa nza mu busonga, wela yadila batu mu bufuana. ");
INSERT INTO yom_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Yave niandi suamunu ki mutu weti yamusu ; suamunu kingolo mu thangu yi ziphasi. ");
INSERT INTO yom_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Babo bazebi dizina diaku, bela tula diana diawu mu ngeyo. Bila ngeyo, Yave, wuyekulanga ko bobo bakutombanga. ");
INSERT INTO yom_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Luyimbidila Yave minzitusu mutu wowo wukala ku Sioni ; yamikisanu mambu mandi kavanga muidi makanda. ");
INSERT INTO yom_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Bila mutu wowo wumvutulanga landi mu diambu di menga matengolo wuntebukanga moyo ; kazimbakananga ko yamikina ku batu badi mu phasi. ");
INSERT INTO yom_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","A Yave, tala buevi bambeni ziama balembo ndiamisa wumboni kiadi ayi wundanguna mu mielo mi lufua. ");
INSERT INTO yom_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Muingi ndiyamikisa minzitusu miaku mu mielo mi muana ndumba wu Sioni, muingi ndimona khini mu phulusu aku. ");
INSERT INTO yom_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Makanda mabuidi mu dibulu dinneni diodi bakaba ; malu mawu mabakini mu dikondi diodi batamba. ");
INSERT INTO yom_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Yave wukimonikisidi, mu busonga buandi ; mutu wumbimbi wukangimini mu mavanga ma mioko miandi. ");
INSERT INTO yom_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Batu bambimbi balembo vutuki ku tsi bafua, makanda moso momo mazimbakana Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Vayi nsukami kalendi tumbu zimbukunu ko ayi diana di batu badi mu phasi dilendi tumbu lalakana ko. ");
INSERT INTO yom_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","A Yave, telama ! Bika mutu kabika nunga ! Bika makanda masambusu va meso maku. ");
INSERT INTO yom_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","A Yave, wubabuisila tsisi ! Bika makanda mazaba ti badi kaka batu. ");
INSERT INTO yom_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Bila mbi ngeyo Yave telimini thama e ? Bila mbi wididi wusuama mu thangu ziphasi e ? ");
INSERT INTO yom_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Mu lunangu luandi, mutu wumbimbi wulembo landakana mutu wulebakana ; bobo babuilamanga mu makani momo kakubikidi. ");
INSERT INTO yom_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Bila mutu wumbimbi wulembo kiniemisa mu nzinunu zi ntima andi ; ayi wulembo sakumuna nkua lukokoto, wulembo lenzi Yave. ");
INSERT INTO yom_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Mu luniemo luandi, mutu wumbimbi kantombanga ko. Mu mayindu mandi, Nzambi kasi kadi buangu ko. ");
INSERT INTO yom_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Mu zithangu zioso, zinzila ziandi zidi zimboti widi nkua lunangu ayi mina miaku midi mitatuka kuidi niandi ; wunsekininanga bambeni bandi zioso. ");
INSERT INTO yom_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Wuniungutanga mu ntimꞌandi : “Kuisi ko diambu dilenda ku ndikuna ; Ndidi mu khini mu zithangu zioso ayi ndilendi ba mu phasi ko.” ");
INSERT INTO yom_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Munu andi wuwedi tsingulu, luvunu ayi buivi. Ku tsi ludimi luandi kuidi ziphasi ayi mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Wumfielanga mu ndambu mala. Wumvondanga mutu kambulu zaba diambu mu bibuangu bisuama, meso mandi manfielanga mu kinsueki bobo katidi vanga mbimbi. ");
INSERT INTO yom_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Wumfielanga banga bumfiedilanga khosi bu kadi mu nsuku wumfielanga mu diambu di buila batu bakambulu lusadusu. ");
INSERT INTO yom_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Weti kuba kosikisa, bawu beti tumbu vonga ; beti bua ku tsi zingolo ziandi. ");
INSERT INTO yom_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Wuniungutanga mu ntimꞌandi : “Nzambi zimbikini, fukidi zizi kiandi ayi kalendi mona ko.” ");
INSERT INTO yom_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","A Yave Nzambi, telama, vumuna koko kuaku ; kadi zimbakana batu bakambulu lusadusu ! ");
INSERT INTO yom_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Bila mbi mutu wumbimbi keti lenzila Nzambi e ? Bila mbi kalembo niungutina mu ntimꞌandi : “Kalendi tomba ko ti ndimvumbudila kipholo” ");
INSERT INTO yom_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Muaki ngeyo Nzambi, wulembo moni ziphasi ayi mabienga ; Wulembo tadi mawu muingi wumatula va koko kuaku. Nkua mabienga wukukiyekulanga kuidi ngeyo ; ngeyo nsadisi wu muana sana. ");
INSERT INTO yom_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Kelula koko ku mutu wumbimbi ayi ku mutu weti vanga mambimbi, nkambi kavumbudila kipholo mu mambimbi mandi ; nate wela kambu buela ku mamona. ");
INSERT INTO yom_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yave niandi ntinu mu zithangu zioso ayi mu thangu yi kayimani Makanda mela bungana mu tsi andi. ");
INSERT INTO yom_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","A Yave, ngeyo weti wa zitsatu zi batu badi mu phasi. Weti kuba kindisa ; ayi dimba yamikina kuawu. ");
INSERT INTO yom_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Mu diambu di nuanisa muana sana ayi mutu weti yamusu muingi mutu widi va ntoto kabika monisa tsisi. ");
INSERT INTO yom_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Kuidi Yave ndintombilanga suamunu. Buevi lulenda ku khambila : “Tinina ku miongo miaku banga bu ntininanga nuni.” ");
INSERT INTO yom_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Bila tala, batu bambimbi balembo leki mimbasa ; ayi balembo ludika zitsoto va nsinga mi mimbasa muingi babasula, bu badi mu tombi, batu bobo badi mintima mi lulama. ");
INSERT INTO yom_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Enati zifundasio zitiolumunu, buna mutu wusonga, mbi kalenda vanga e ? ");
INSERT INTO yom_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Yave widi mu nzoꞌandi yinlongo ! Yave, kundu kiandi ki luyalu kidi ku diyilu, meso mandi malembo tadi ayi zindabu ziandi zimfionguninanga bana ba batu. ");
INSERT INTO yom_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yave wumfionguninanga mutu wusonga vayi muelꞌandi weti lenda mutu wumbimbi ayi mutu wowo wunzolanga matsita. ");
INSERT INTO yom_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Wunokisanga makala ayi sofolo yi mbazu. Kuidi batu bambimbi, Phemo yi mbazu yawu kopo yi ziphasi bela kabana. ");
INSERT INTO yom_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Bila Yave widi wusonga, wunzolanga masonga. Batu badi mintima mi lulama bela talanga zizi kiandi. ");
INSERT INTO yom_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Nkunga Davidi kayimbidila mu ngitala yi nana di zitsinga kuidipfumu minyimbidi. A Yave, yiza sadisa bila batu beti kinzika mambu ma Nzambi basiedi ko. Mikhuikizi mizimbidi va khatitsika yi bana ba batu. ");
INSERT INTO yom_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Kadika mutu wulembo vuni fikimini yandi. Mambu ma lueki madi mu bididi biawu vayi mintima miodi badi sumbu bantuba. ");
INSERT INTO yom_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Bika Yave kabunga bididi bioso bintubanga mambu ma lueki ayi ludimi luntubanga mambu mu luniemo. ");
INSERT INTO yom_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Batu bobo bantubanga : “Tuela nunga mu diambu di ludimi lueto, bididi bieto bidi bieto veka ; nani wulenda ba Pfumu eto ?” ");
INSERT INTO yom_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Bila mu diambu di yamusu ku batu balebakana, ayi kunga ku nsukami ; diawu Yave kakembi buabu : “Buabu ndieka ntelama, ndieka kuba kaka mu diambu di mutu balembo kuba yamisa.” ");
INSERT INTO yom_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Mambu ma Yave madi mavedila banga palata kioki bavedisidi mu mbazu, kivedosolo mu tsambuadi di zikhumbu. ");
INSERT INTO yom_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Yave ngeyo wela kutu keba mu luvovomo wela kutu kaka mu diambu di ntindu wu batu baba, mu thangu yi kayimani. ");
INSERT INTO yom_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Batu bambimbi beti vemanga muamo mu thangu bifu bi mbimbi bieti yayusu va khatitsika batu. ");
INSERT INTO yom_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Nkunga Davidi kuidi pfumu minyimbidi. A Yave, nate thangu mbi wela tatamana kunzimbakana mu zithangu zioso e ? Nate thangu mbi wela kutsuekilanga zizi kiaku e ? ");
INSERT INTO yom_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Nate thangu mbi ndiela kukinuanisanga mu mayingu mama e ? Nate thangu mbi ndiela bela maniongo mu ntimꞌama mu kadika lumbu e ? Nate thangu mbi mbeni ama kela ku ndunginanga e ? ");
INSERT INTO yom_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","A Yave, Nzambi ama, wuthadi ayi wuphana mvutu, kienzula meso mama mu diambu ndibika leka tulu tu lufua, ");
INSERT INTO yom_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","mu diambu mbeni ama kabika tuba : “Ndinnungini” ayi muingi batu beti kundenda babika mona khini minu bua. ");
INSERT INTO yom_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Vayi minu tsidi diana mu luzolo luaku lungolo. Ntimꞌama wulembo moni khini mu phulusu aku. Ndiela yimbidila Yave bila niandi wuphangidi mamboti. ");
INSERT INTO yom_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Nkua buvulu wuntubanga mu ntimꞌandi ti : Kuisiko Nzambi ! Baki bivisidi, mavanga mawu madi mambimbi ; kuisiko mutu wumvanganga mamboti. ");
INSERT INTO yom_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yave, ku yilu ku kadi, wulembo tadi bana ba batu mu tala kani wulenda mona wumosi wunsundika, kani wumosi wuntombanga Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Baboso bavengama ayi bamana kibivisa va kimosi ; kuisiko mutu wumvanganga mamboti, kadi mutu wumosi. ");
INSERT INTO yom_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Batu boso bamvanganga mambu mambimbi basi nzayilu ko e ? Bobo balembo dia batu bama, banga batu bandia dipha ayi bobo batelanga dizina di Yave ko. ");
INSERT INTO yom_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Buna kuna bela tita mu diambu di tsisi bila Nzambi widi va khatitsika dikabu di batu basonga. ");
INSERT INTO yom_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Beno mimvangi mi mambimbi, lulenda vunza zikhanu zi nsukami. Vayi Yave niandi suamunu kiandi. ");
INSERT INTO yom_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","A enati phulusu yi Iseli yitotukila ku Sioni ! Mu thangu Yave kela vutula kiuka ki batu bandi Bika Yakobi kamona khini ayi Iseli kayangadala. ");
INSERT INTO yom_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Nkunga Davidi. A Yave, nani wulenda vuanda mu nzo aku yi ngoto e ? Nani wulenda zinga ku mongo aku wunlongo e ? ");
INSERT INTO yom_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Woso mutu wundiatanga mu kambu tsembolo, wumvanganga mambu ma busonga ayi wuntubanga mambu ma kiedika mantotukanga mu ntimꞌandi. ");
INSERT INTO yom_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Katubidilanga ko batu mu ludimi luandi ; Kavangilanga ndiandi mambimbi ko ayi kabivisanga nzitusu wu ndiandi ko. ");
INSERT INTO yom_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Weti lenza mutu weti vanga mambimbi Vayi wunzitisanga bobo bankinzikanga Yave. Wunkebanga zindefi ziandi. Ka diambu ko yela kummonisa phasi. ");
INSERT INTO yom_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Katombanga ndandu ko va yilu zimbongo ziozi kadevisa. Ayi kakikininanga ko makaba mu diambu di bedisa mutu kambulu zaba diambu. Woso wumvanganga mambu momo kalendi nikunu ko. ");
INSERT INTO yom_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Nkunga Davidi. A Nzambi, wukheba mu luvovomo bila kuidi ngeyo nditombila suamunu. ");
INSERT INTO yom_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Kuidi Yave ndituba : “Ngeyo Pfumu ama, kuidi ngeyo kaka kueti banga mamboti mama.” ");
INSERT INTO yom_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Mu diambu di banlongo bobo badi mu tsi ; bawu batu banzitusu. Khini yiwombo baku mbonisanga. ");
INSERT INTO yom_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Bobo banlandakananga zinzambi zinkaka kiadi kiawu kiela buelama, voti ndilendi tambika makaba mawu ma menga ko, Ndilendi tanga mazina mawu mu bididi biama ko. ");
INSERT INTO yom_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Yave ngeyo wuphana ndambu yi kiuka kiama, ayi mbungu ama, ngeyo wunkebanga kuku kiama mu luvovomo. ");
INSERT INTO yom_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Zindili zikubuku mu diambu diama mu buangu bidi kitoko ; bukiedika, thambudi kiuka ki mboti. ");
INSERT INTO yom_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Ndiela zitisa Yave ; wukuphananga malongi ntimꞌama wukundonganga mu builu, ");
INSERT INTO yom_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Ndieti tula Yave ku ntualꞌama mu zithangu zioso bila widi ku koko kuama ku lubakala, ndilendi nikuka ko. ");
INSERT INTO yom_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Diawu ntimꞌama wididi mu khini ; ludimi luama lueti yangalala ayi nitu ama yela vunda mu luvovomo ; ");
INSERT INTO yom_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Bila ngeyo wulendi kundiekula ko ku tsi bafua, ayi wulendi tala ko mutu aku wunlongo kabola. ");
INSERT INTO yom_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Ngeyo wumbonisa nsolo wu luzingu ; zikhini ziwombo zidi va ntuala zizi kiaku. Wela kumbonisa khini va meso maku va kimosi ayi zikhini zika zisukanga ko zidi va koko kuaku ku lubakala. ");
INSERT INTO yom_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Lusambulu lu Davidi. Yave wa mambu ma busonga bu ndieti samba ; dimba yamikina kuama ; tamba kutu mu lusambulu luama lueti totukila mu bididi bikambulu luvunu. ");
INSERT INTO yom_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Bika ndungunu ama yitotukila kuidi ngeyo ayi bika meso maku mamona momo madi ma lulama. ");
INSERT INTO yom_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Ka diambu ko tidi fiongunina ntimꞌama, ayi kuthala va builu ka diambu ko wumbekini, mu mbazu wulendi mona kadi kiasa ko. Ndibaka lukanu ti munu ama wulendi sumuka ko. ");
INSERT INTO yom_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Mu diambu di mavanga ma batu ; mu nzila yi mambu ma bididi biaku, ndieti kukikeba mu nzila yi mutu widi matsita. ");
INSERT INTO yom_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Bitambi biama bidi kaka bikinda mu minsolo miaku, malu mama malendi sialumuka ko. ");
INSERT INTO yom_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","A Nzambi, ndikutela bila ngeyo wela kuphana mvutu. Yinika dikutu diaku ku ndidi ayi wa lusambulu luama. ");
INSERT INTO yom_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Monisa matsiminanga ma luzolo luaku lunneni, ngeyo wuphukisanga mu koko kuaku ku lubakala bobo bansuaminanga mu ngeyo, mu bobo bakubalendanga. ");
INSERT INTO yom_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Wukheba banga ngengele yi dieso diaku ; wutsueki ku tsi kitsusula ki mavavi maku, ");
INSERT INTO yom_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","mu diambu di batu bambimbi beti kundiamisa, mu diambu di bambeni ziama zieti kunzungidila ; ziosi zintomba lufua luama. ");
INSERT INTO yom_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Bakikangidi mintima miawu midi banga matadi ; Miunu miawu mintubanga mambu ma lunanga. ");
INSERT INTO yom_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Balembo ndandakana, banzungididi buabu ; balembo tadi mu diambu bambuisa va tsi. ");
INSERT INTO yom_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Badedikini banga khosi yidi nzala kanzuna, banga khosi yiyunduka yidi yilambididi va buangu kisuama. ");
INSERT INTO yom_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Telama, Yave, wuba nuanisa ayi bika wuba buisa, wukhula mu sabala kiaku ; mu mutu wumbimbi. ");
INSERT INTO yom_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","A Yave, bika wuphukisa mu koko kuaku mu batu ba phila yayi ; batu ba ntoto wawu ; bobo mfutu awu widi mu luzingu lualu. Weti lembika nzala yi bobo weti zola bana bawu babeki biwombo, ayi balundila bana bawu batsombi kimvuama. ");
INSERT INTO yom_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Vayi minu, ndiela mona zizi kiaku mu busonga. Bu ndiela kotuka ndiela yukuta mu talanga mfikulꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Nkunga Davidi, kisadi ki Yave, kuidi Pfumu minyimbidi. Wuyimbila nkunga wawu mu diambu di Yave mu thangu Yave kankula mu mioko mi bambeni bandi ayi mu mioko mi Sawuli. Yave, ndikuzolanga, ngeyo zingolo ziama. ");
INSERT INTO yom_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","A Yave, niandi ditadi diama, tinunu kiama ki ngolo, ayi ngeyo nkudi ama. Nzambi ama, niandi ditadi diama ; mu niandi ndintombila suamunu, niandi nkaku ama, ayi phoka yi phulusu ama, ayi tinunu kiama ki zangama. ");
INSERT INTO yom_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Ndiela tela Yave, niandi fueni mu zitusu ayi ndiela vuka mu bambeni ziama. ");
INSERT INTO yom_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Minsinga mi lufua mimfietikisa. Bosi khuka nlangu yimbunganga yimbuila mu kinzimbukila. ");
INSERT INTO yom_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Minsinga mi tsi bafua minzingalakana. Mintambu mi lufua mi lekama ku ntualꞌama. ");
INSERT INTO yom_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Mu ziphasi ziama, nditela Yave Ndiyamikina kuidi Nzambi ama mu tomba lusadusu wuwa mbemboꞌama tona kuna nzoꞌandi, ayi yamikina kuama kutula va ntualꞌandi, mu matu mandi. ");
INSERT INTO yom_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Buna ntoto wunikuka ayi wutita. Zifondasio zi miongo zinikunu ayi zinikuka, bila wuba wufuema ngolo. ");
INSERT INTO yom_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Muisi wutotuka mu mayilu mandi, ayi mbazu yi nlalikisanga yitotuka mu munuꞌandi ; muawu mu totukila makala ma mbazu. ");
INSERT INTO yom_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Wukulula diyilu ayi wukuluka, ayi matuti ma ndombe maba ku tsi malu mandi. ");
INSERT INTO yom_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Wukuma va yilu kheluba ayi wudumuka. Wuvevumuka va yilu mavavi ma phemo. ");
INSERT INTO yom_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Wukitula tombi buangu kiandi kisuamina ; kapu andi yiba kunzungidila, tombi kinokisa mvula yi matuti ma diyilu. ");
INSERT INTO yom_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Mu kiezila kiba va ntualꞌandi mutotukila matuti, mvula yi matadi ayi zitsiemo. ");
INSERT INTO yom_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Yave wuduma tona mu Diyilu ; mbembo yi Nzambi yizangama yiwakakana. ");
INSERT INTO yom_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Niandi wuloza madionga mandi ayi wusasikisa bambeni ; zitsiemo zinneni ayi wuba zimbikisa nzila. ");
INSERT INTO yom_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Tsi nlangu yi mbu yimonika, ayi zifondasio zi ntoto zimonika ngeyo Yave bu wutema mu phemo yitotukila mu mayilu maku. ");
INSERT INTO yom_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Wunonuna koko kuandi tona ku yilu ayi wutsimba, wuthotula mu minlangu minneni midi thipula. ");
INSERT INTO yom_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Niandi wukhula mu mbeni ama yingolo, ayi mu batu bobo bandenda bila bawu bandutila ngolo. ");
INSERT INTO yom_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Bawu banduanisa mu lumbu ki ndiba mu mabienga, vayi Yave niandi wuba singumunu kiama. ");
INSERT INTO yom_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Niandi wuthotula ayi wuthula va buangu kikambulu tsisi ; wukhula bila khini kaba monanga mu minu. ");
INSERT INTO yom_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Yave wuphangidi bobo boso buididi busonga buama ; wupheni mfutu boso buididi vedila ku mioko miama ");
INSERT INTO yom_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Bila ndikebidi zinzila zi Yave ayi ndisia tamba Nzambi ama mbusa ko mu diambu di vanga mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Mina miandi mioso midi va ntualꞌama ayi ndisia vengama ko mu zithumunu ziandi. ");
INSERT INTO yom_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Ndiba mutu wukambu tsembolo va ntualꞌandi Ndikikeba mu diambu di masumu. ");
INSERT INTO yom_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Yave wupheni mfutu boso buididi busonga buama, boso buididi vedila ku mioko miama va ntuala meso mandi. ");
INSERT INTO yom_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Kuidi mutu widi wukuikama, ngeyo wukukimonisanga wukuikama. Kuidi mutu wukambulu tsembolo ngeyo wukukimonisanga mutu wukambulu tsembolo. ");
INSERT INTO yom_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Kuidi mutu wuvedila, wukukimonisanga wuvedila. Kuidi mutu wumbimbi, wukukimonisanga wumbimbi. ");
INSERT INTO yom_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Ngeyo wumvukisanga batu beti kukikula ayi wunkululanga meso madi luyanu. ");
INSERT INTO yom_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Ngeyo a Yave, keba muindꞌama wuba wulema A Nzambiꞌama, kitula tombi kiama ; kikituka kiezila. ");
INSERT INTO yom_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Mu lusadusu luaku ndilenda nuanisa nkangu masodi, va kimosi ayi Nzambi ama, ndilenda dumuka baka kikunzama. ");
INSERT INTO yom_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Kuidi Nzambi, nzilꞌandi yidi yi fuana, mambu ma Yave madi ma kiedika. Niandi nkaku wu batu boso bobo bansuaminanga mu niandi. ");
INSERT INTO yom_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Bila nani Nzambi, enati ka Yave ko e ? Ayi nani ditadi di ngolo, enati ka Nzambi eto ko e ? ");
INSERT INTO yom_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Nzambi, niandi wukuphananga ngolo ayi wunkitulanga nzilꞌama yi fuana. ");
INSERT INTO yom_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Wunkitulanga malu mama banga malu ma tsesi, ayi wukuthelimisanga va bibuangu biama bizangama. ");
INSERT INTO yom_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Wunlongisanga mioko miama mu nuana mvita, mioko miama milenda leka mbasa wusengo. ");
INSERT INTO yom_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Wuphana nkaku aku wu ndungunu, ayi koko kuaku ku lubakala kukhindisa ayi wukuluka mu diambu di kukhitula mutu wunneni. ");
INSERT INTO yom_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ngeyo wukubikidi nsolo wuyalumuka ku tsi bitambi biama, muingi bikodi biama bibika visuka. ");
INSERT INTO yom_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Ndikuka bambeni ziama ayi ndizibakidila. Ndisia vutuka manima ko enati ndisia mana kuzivonda. ");
INSERT INTO yom_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Ndiba kosikisa ayi basia buela baka bu telimina ko ; babua ku tsi malu mama. ");
INSERT INTO yom_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Ngeyo wuphana zingolo zi nuanina mvita ; Ngeyo weti komvika batu beti kundenda ku tsi malu mama. ");
INSERT INTO yom_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Ngeyo wuntinisanga bambeni ziama va ntualꞌama ayi ndibunga bobo bakundendanga. ");
INSERT INTO yom_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Bayamikina mu tomba lusadusu, vayi kadi mutu mu kuba vukisa. Bayamikina kuidi Yave vayi kasia ku bavutudila mvutu ko. ");
INSERT INTO yom_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Ndiba kosikisa banga mbungi-mbungi yeti vevumunu kuidi phemo. Ndiba loza thama banga nyamba wu zinzila. ");
INSERT INTO yom_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Wukhula mu minzonza mi batu, ayi wukhitula ntu wu makanda ; batu bobo ndisia zaba ko, bawu ndiela yadila. ");
INSERT INTO yom_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Bu batumbu kungua bathumukina ; banzenza zikikulula va ntualꞌama. ");
INSERT INTO yom_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Zinzenza zilembo vongi, balembo titi sumbu bantotuka mu bibuangu biawu bisuama ngolo. ");
INSERT INTO yom_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Yave wulembo zingi Nzitusu wuba kuidi ditadi diama yayusu kuba kuidi Nzambi Mvulusi ama. ");
INSERT INTO yom_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Niandi Nzambi wukuphutudilanga landi ; ayi wutula makanda ku tsi luyalu luama. ");
INSERT INTO yom_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Wuphukisa mi bambeni ziama, Ngeyo wundiayisa va yilu batu bobo bandenda. Ngeyo wukhula mu batu ba matsita. ");
INSERT INTO yom_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Diawu ngeyo Yave, ndiela ku zitisa va khatitsika makanda. Ndiela yimbila minzitusu mu diambu di dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Niandi wuvana ndungunu yinneni kuidi ntinu andi ayi wummonisanga mamboti mandi ma ngolo kuidi mutu andi kavinda mafuta, kuidi Davidi ayi nkuna andi mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Diyilu dieti samuna nkembo wu Nzambi ayi matuti meti yamikisa kisalu ki mioko miandi. ");
INSERT INTO yom_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Kadika Lumbu kinyamikisa mambu beni kuidi lumbu kinkaka ; ayi builu bumosi bueti ma zabikisa kuidi builu bunkaka. ");
INSERT INTO yom_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Kuisi ko mambu mayoluka voti mambu masadila ; Kunkambu wakana zimbembo ziawu. ");
INSERT INTO yom_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Zimbembo ziawu zieti wakana va ntoto wumvimba. Mambu mawu beti yoluka meti tula nate ku sukisina nza. Ku diyilu katungila nzo yi ngoto mu diambu di thangu : ");
INSERT INTO yom_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Yawu yidi banga dibakala dikuela dintotuka va ntuala vinga kiandi, banga dikesa, dieti mona khini mu zawula thinu ; ");
INSERT INTO yom_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Yintotukilanga ku tsongi yi Diyilu, bosi ku tsongi yinkaka kuawu kamanisinanga nzietolo andi. Kuisiko kima kinsuamanga va ntuala diamu diandi. ");
INSERT INTO yom_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Mina mi Yave midi mifuana, mieti vananga diaka muela luzingu Zinzengolo zi Yave zidi zi kiedika Zinkitulanga mutu wu phamba mutu wu nduenga. ");
INSERT INTO yom_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Minsiku mi Yave midi mi songa, minyangidikanga ntima. Zithumunu zi Yave zidi zivedila, zinkienzulanga meso. ");
INSERT INTO yom_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Kinzika Yave didi diambu di vedila, dieti zingila mu zithangu zioso. Zitsikudukusu zi Yave zilenda siwulu diana, zizioso zidi zisonga va kimosi ; ");
INSERT INTO yom_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Zilutidi thalu ayi nolo ; ayi viokila zinolo ziwombo zivedila zilutidi niosi mu lueki ; zilutidi yoyi yinkumba mu bisila. ");
INSERT INTO yom_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Mu ziawu mueti lubukila kisadi kiaku ; mfutu wunneni widi mu kuzikebanga. ");
INSERT INTO yom_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Nani wulenda sudika zinzimbala ziandi e ? Lemvukila zinzimbala ziama zisuama. ");
INSERT INTO yom_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Keba kisadi kiaku mu masumu mamvangimina mu luzolo ; mabika ku ndiadila ; buna ndiela ba wukambu tsembolo ; wukambu zaba diambu mu masumu manneni. ");
INSERT INTO yom_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Bika mambu ma munuꞌama ayi mayindu ma ntimꞌama maba ma khini va ntualꞌaku A Yave, ditadi diama ayi nkudi ama. ");
INSERT INTO yom_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Bika Yave kavana mvutu bu widi mu ziphasi, bika dizina di Nzambi yi Yakobi dikeba. ");
INSERT INTO yom_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Bika kafidisa lusadusu bu kadi ku buangu kinlongo Bika kakindisa bu kadi ku Sioni. ");
INSERT INTO yom_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Bika katebukila makaba maku moso moyo. Ayi kakikinina makaba maku maviku. ");
INSERT INTO yom_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Bika kavana bitidi ntimꞌaku. Ayi bika kanungisa zikhubukulu ziaku zioso. ");
INSERT INTO yom_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Tuela yamikina mu khini bu wela tambula ndungunu. Tuela vumbula bidalapo bieto ku Yilu mu dizina di Nzambi eto. Bika Yave kadukisa zindombolo ziaku zioso. ");
INSERT INTO yom_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Buabu nzebi ti Yave wumvukisanga mutu andi wuka vinda mafuta, weti kumvana mvutu bu kadi ku Diyilu, diandi dinlongo mu lusadusu luandi lungolo, lu koko kuandi ku lubakala. ");
INSERT INTO yom_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Bankaka bantulanga diana mu matoma ma mvita, bankaka mu ziphunda. Vayi beto tuntulanga diana mu dizina di Yave, Nzambi eto. ");
INSERT INTO yom_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Bawu beti fukama mu makuma mawu ayi beti bua ; Vayi beto tueti telama ayi tuidi kaka bakinda. ");
INSERT INTO yom_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Yave vukisa ntinu Bika wutuvana mvutu mu thangu tueti tela. ");
INSERT INTO yom_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Nkunga Davidi kuidi pfumu minyimbidi. A Yave, ntinu weti yangalala mu zingolo ziaku ayi tala phila khini andi yididi yinene mu ndungunu yoyi weti vana. ");
INSERT INTO yom_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Ngeyo wumvana bima bioso bitomba ntimꞌandi. Ayi wusia kunyimina ko zindombolo ziozi kalomba mu bididi biandi. ");
INSERT INTO yom_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Ngeyo wuntambula va kimosi ayi lusakumunu lu luvalu lu ngolo. Ngeyo wutula budu ki nolo yi vedila va mbata ntuꞌandi. ");
INSERT INTO yom_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Niandi wulomba luzingu kuidi ngeyo ayi wumvana luawu, luzingu lu mula mu zithangu zioso ayi lu kalumani. ");
INSERT INTO yom_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Nkemboꞌandi widi wunneni mu diambu di ndungunu weti vana. Ngeyo wumvuika kiezila ayi nzitusu. ");
INSERT INTO yom_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Bukiedika, ngeyo wumvana lusakumunu lu kalumani ; wunkitula mutu wu yangadala mu diambu di khini yidi va meso maku ");
INSERT INTO yom_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Bila Ntinu wuntulanga diana diandi mu Yave ; Ayi mu diambu di luzolo lu ngolo Nzambi yizangama, kalendi bulangana ko. ");
INSERT INTO yom_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Koko kuaku kuela buila bambeni ziaku zioso. Koko kuaku ku lubakala kuela buila bobo beti ku lenda. ");
INSERT INTO yom_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Wela kuba kitula banga mfulu makala ma mbazu, mu thangu yoyi wela kukimonikisa. Yave wela kuba sikisa mu nganzi andi. Ayi mbazu yela kuba zinisa. ");
INSERT INTO yom_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Wela bunga nkunꞌawu va ntoto ayi bana bawu va khatitsika yi bana ba batu. ");
INSERT INTO yom_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Ka diambu ko balenda kubika mambimbi mu diambu diaku ayi yindula zikhanu zimbimbi, balendi nunga ko. ");
INSERT INTO yom_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Bila ngeyo wela kuba tinisa bu wela kuba basula mu mbasꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","A Yave, yayusu kuaku mu zingolo ziaku. Tuela yimbidila ayi zitisa lulendo luaku. ");
INSERT INTO yom_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Nkunga Davidi kuidi pfumu minyimbidi, wuyimbidila wawu mu nningu wu beti tedilanga “Nsuma wu nsuka”. Nzambi ama, Nzambi ama, bila mbi wundiekuididi e ? Ayi bila mbi wididi thama mu kambu ku phukisa e ? Ayi bila mbi wididi thama mu kambu wa maniongo mama e ? ");
INSERT INTO yom_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Nzambi ama, ndinyamikina va muini, vayi wukadi vutula mvutu. Va builu, ndivuandanga ko dio sui. ");
INSERT INTO yom_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Vayi ngeyo wubieko banga wunlongo. Ngeyo nzitusu wu Iseli. ");
INSERT INTO yom_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Mu ngeyo bakulu beto batula diana diawu. Batula diana diawu mu ngeyo ayi wuba kula. ");
INSERT INTO yom_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Kuidi ngeyo bayamikina ayi ngeyo wuba vukisa. Mu ngeyo batula diana diawu ayi basia fuisu tsoni ko. ");
INSERT INTO yom_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Vayi minu, ndidi kiela vayi bika mutu. Babakala balembo mvuezi, batu balembo ndenzi. ");
INSERT INTO yom_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Babo bobo beti kumbona beti ku tsekinina. Beti finga. Beti nikuna mintu : ");
INSERT INTO yom_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Kuidi Yave keti tula diana diandi buna bika kamvukisa, bika kankula bila khini keti mona mu niandi.” ");
INSERT INTO yom_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Vayi, ngeyo wuthotula mu vumu ; wuvanga ti nditula diana diama mu ngeyo banga va thulu yi ngudi ama. ");
INSERT INTO yom_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Tona ndibutuka ndiyekulu kuidi ngeyo tona mu vumu ki ngudi ama. Tona mu vumu ki ngudi ama, ngeyo wuba Nzambi ama. ");
INSERT INTO yom_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Kadi kuthatukila bila ziphasi zifikimini, bila kuisi ko mutu wulenda sadisa. ");
INSERT INTO yom_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Zingombi ziwombo zimbakala zinzungididi, zingombi zi Basani zinzungididi. ");
INSERT INTO yom_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Mu kunga ku khosi yeti kanzuna bulu miunu miawu midi mizibuka ngolo mu diambu diama ");
INSERT INTO yom_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Mbeni dukuka banga nlangu ayi mimvesi miama mioso mivasukidi. Ntimꞌama widi banga mafuta beti vindanga mu mabaya. Wulembo siuti mu khati yi nitu ama. ");
INSERT INTO yom_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Zingolo ziama zilembo yumi banga tini ki nzungu tuma ayi ludimi luama lunemi mu munu ama. Ngeyo wuthula mu mbungi-mbungi yi lufua. ");
INSERT INTO yom_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Zimbwa zinzungididi, Nkangu wu batu bambimbi banzungididi. Batobudi mioko miama ayi malu mama. ");
INSERT INTO yom_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Ndilenda tanga mimvesi miama mioso. Batu beti kutsungimina ayi balembo thadi. ");
INSERT INTO yom_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Balembo kabana bawu na bawu minlele miama ayi balembo budila yunga kiama tsombo. ");
INSERT INTO yom_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Vayi ngeyo Yave, kadi ba thama. Ngeyo zingolo ziama ayi yiza nsualu mu kutsadisa. ");
INSERT INTO yom_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Kula luzingu luama mu sabala ; luzingu luama lu thalu mu luyalu lu zimbua. ");
INSERT INTO yom_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Wukhudi mu munu wu khosi wuphukisa mu ziphoka zi ziphaka. ");
INSERT INTO yom_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ndiela yolukila dizina diaku kuidi bakhomba baama ; ndiela ku zitisa va khatitsika lukutukunu. ");
INSERT INTO yom_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Beno lunkinzikanga Yave, bika lunzitisa ! Beno babo luidi mu nkuna Yakobi, bika lunkinzika ! Beno babo luidi mu nkuna wu Iseli, bika lunzitisa. ");
INSERT INTO yom_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Bila kasia lenza ko ayi kasia kakumukina ko ziphasi zi mutu widi mu phasi ; kasia kunsuekila zizi kiandi ko vayi weti wa yamikina kuandi bu keti tomba lusadusu. ");
INSERT INTO yom_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Kuidi ngeyo kueti totukila minzitusu miama mu lukutukunu lunneni va ntuala bobo beti ku kinzika, ndiela dukisa zitsila ziama. ");
INSERT INTO yom_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Minsukami miela dia ayi miela yukuta. Bobo beti tomba Yave bela kumvana nzitusu. Bika mintima mieno mizinga mu zithangu zioso ! ");
INSERT INTO yom_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Zitsuka zioso zi ntoto ziela tebuka moyo ; Ziela baluka kuidi Yave. Batu ba makanda moso bela buongama va ntualꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Bila Kipfumu kidi kuidi Yave ; niandi wunyadilanga makanda. ");
INSERT INTO yom_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Batu boso badi kimvuama ba ntoto bela dia ayi mamvawu bela buongama. Babo bankulukanga mu mbungi-mbungi bela komvama va ntualꞌandi ; bobo bankambu baka bu zingisila luzingu luandi bawu veka. ");
INSERT INTO yom_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Nkuna wela ku nsadila. Batu bela samuna mambu matedi Yave kuidi tsungi yinkuiza. ");
INSERT INTO yom_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Bela yolukila busonga buandi kuidi batu bobo babutukidi ko. Bila niandi wuvanga mambu mama. ");
INSERT INTO yom_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Nkunga Davidi. Yave niandi nsungi ama, ndilendi kambu kadi kima ko. ");
INSERT INTO yom_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Niandi wukuphundisanga muidi biti binlangu, Wukundatanga kuidi minlangu milembama. ");
INSERT INTO yom_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Niandi wunkindisanga muelꞌama. Niandi wukundiatisanga mu minsolo misonga mu diambu di dizina diandi. ");
INSERT INTO yom_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Ka diambu ko ndilenda diata mu ndimba tombi ki lufua, buna ndilendi mona mbimbi tsisi ko bila ngeyo widi yama. Nkawa aku ayi nti aku, biawu bi kumbombanga. ");
INSERT INTO yom_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ngeyo wukubika meza va ntualꞌama va meso ma bambeni ziama. Ngeyo wuvinda ntuꞌama mafuta mbungu ama yilembo sapika. ");
INSERT INTO yom_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Bukiedika, mamboti maku ayi luzolo biela kundandakana mu bilumbu bioso bi luzingu luama. Ayi ndiela vuanda mu nzo Yave mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Nkunga Davidi. Ntoto widi wu Yave ayi bibioso bidi mu wawu ; nza ayi babo banzinganga muawu. ");
INSERT INTO yom_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Bila niandi wutunga ntoto va mbata mimbu ayi wukindisa wawu va mbata minlangu. ");
INSERT INTO yom_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Nani wulenda kuma ku mongo wu Yave ? Nani wulenda telama va buangu kiandi kinlongo e ? ");
INSERT INTO yom_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Woso mutu widi mioko misukulu ayi ntima wuvedila ; woso mutu wunkambu vumuna muelꞌandi kuidi bitumba, Voti wunkambu levanga ndefi mu mambu ma luvunu. ");
INSERT INTO yom_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Wela tambula lusakumunu luela ba kuidi Yave, ayi ndungunu Nzambi yi Mvulusi andi. ");
INSERT INTO yom_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Buawu bobo buididi tsungi yi batu bakuntombanga, yi bawu bantombanga zizi kiaku, a Nzambi yi Yakobi. ");
INSERT INTO yom_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Luvumbula mintu mieno, beno mielo ! Luvumbuka beno mielo mikhulu ! Muingi ntinu wu nkembo kakota. ");
INSERT INTO yom_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Nani ntinu wu nkembo e ? Keti Yave, nkua ngolo ayi nkua lulendo ! Keti Yave, nkua lulendo mu zimvita ! ");
INSERT INTO yom_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Luvumbula mintu mieno, beno mielo ! Luvumbuka beno mielo mikhulu ! Muingi ntinu wu nkembo kakota. ");
INSERT INTO yom_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Nani wowo ntinu beni wu nkembo e ? Keti Yave, pfumu yi minkangu mi masodi. Niandi ntinu wu nkembo. ");
INSERT INTO yom_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Kuidi ngeyo Yave ndintambika muelꞌama. ");
INSERT INTO yom_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Mu ngeyo ndintulanga diana diama, a Nzambi ama. Kadi tala ti ndifuisu tsoni. Bika bambeni ziama zibika ku ndunga. ");
INSERT INTO yom_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Kadi mutu wumosi kalendi fua tsoni ko. Vayi bela fuisu tsoni, bobo bamvakulanga badiawu mu kambu phengomokono, ");
INSERT INTO yom_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Bika wumbonisa zinzila ziaku, a Yave bika wundonga minsolo miaku, ");
INSERT INTO yom_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","wundiatisa mu kiedika kiaku ayi wundongi. Bika ngeyo Nzambi Mvulusi ama. Ayi diana diama didi mu ngeyo mu lumbu kimvimba. ");
INSERT INTO yom_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","A Yave, tebukila kiadi kiaku kingolo moyo ayi luzolo luaku lu ngolo, bila bidi mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Kadi tebukila moyo masumu mama ma kimuana ; ayi kadi tebukila moyo zinzila ziama zi matingu. Mu diambu di luzolo luaku, bika wuthebukila moyo ; bila ngeyo widi wumboti, a Yave. ");
INSERT INTO yom_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yave, widi wumboti ayi wusonga ; diawu kanlongisilanga bankua masumu mu zinzila ziandi. ");
INSERT INTO yom_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Niandi wudiatisanga batu bakukikululanga mu mambu masonga ; ayi wunlonganga nzilꞌandi kuidi bakukikululanga. ");
INSERT INTO yom_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Zinzila zioso zi Yave zidi zi luzolo ayi zikuikama, kuidi bawu beti keba zindombolo zi nguizani andi. ");
INSERT INTO yom_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Mu diambu di dizina diaku, a Yave bika wundemvukila mu mambimbi mama bila madi mawombo. ");
INSERT INTO yom_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Buna nani mutu wunkinzikanga Yave ? Yave wela kunlonga nzila yoyi basobula mu diambu diandi. ");
INSERT INTO yom_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Wela viokisa bilumbu biandi mu mamboti ; ayi nkunꞌandi wela tambula tsi. ");
INSERT INTO yom_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Yave weti monikisa mansueki mandi kuidi bobo bakunkinzikanga, ayi weti kuba zabikisa nguizani andi. ");
INSERT INTO yom_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Thalu ama yidi kuidi Yave mu zithangu zioso. Bila niandi wela totula malu mama mu dikondi. ");
INSERT INTO yom_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Baluka kuidi minu ayi bika nlemvo aku wuba va minu bila ndidi minu veka ayi ndidi mu phasi. ");
INSERT INTO yom_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Ziphasi zi ntimꞌama zilembo buelama ; bika wuthotula mu ziphasi ziama. ");
INSERT INTO yom_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Tala ziphasi ziama ayi kiadi kiama ayi botula masumu mama moso. ");
INSERT INTO yom_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Tala phila bambeni ziama zilembo buelimina ayi bandendidi mu kikhenene kimosi kingolo. ");
INSERT INTO yom_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Keba luzingu luama ayi khudi ! Kadi tala ti ndifua tsoni bila mu ngeyo ndisuamina. ");
INSERT INTO yom_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Bika fuanana ayi lulama bikheba, bila mu ngeyo ntudidi diana diama. ");
INSERT INTO yom_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","O Nzambi, kula Iseli mu ziphasi ziandi zioso. ");
INSERT INTO yom_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Nkunga Davidi. Wundungisa, a Yave, bila ndidiatila mu luzingu lukambulu tsembolo. Nditula diana diama mu Yave mu kambu memata. ");
INSERT INTO yom_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","A Yave wumfiongunina, wumbeki, fiongunina mayindu ma ntimꞌama ayi ntimꞌama. ");
INSERT INTO yom_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Bila luzolo luaku luidi mu zithangu zioso ku ntualꞌama ayi ndindiatanga mu zithangu zioso mu kiedika kiaku. ");
INSERT INTO yom_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Ndivuandanga ko va kimosi ayi batu ba luvunu. Ndifubakananga ko va kimosi ayi bankua mayuya. ");
INSERT INTO yom_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Ndieti kakumukina lukutukunu lu batu bamvanganga mambimbi. Ndivuandanga ko va kimosi ayi batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Tsukudi mioko miama mu monisa ti ndisi zaba diambu ko, ayi ndiela zungidila ntalꞌaku, a Yave ! ");
INSERT INTO yom_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Mu yamikina minzitusu miaku mu mbembo yingolo ayi mu diambu di yolukila mangitukulu maku moso. ");
INSERT INTO yom_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Ndinzolanga nzo yoyi weti zingila ; a Yave buangu kimvuandanga nkemboꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Kadi botula muelꞌama va kimosi ayi bankua masumu ayi luzingu luama va kimosi ayi bantengulanga menga ma batu, ");
INSERT INTO yom_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","mu bobo badi mioko miyuku kubika zikhanu zimbimbi, bobo mioko mi lubakala miwedi makaba ma kinsueki. ");
INSERT INTO yom_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Vayi minu, ndieti diatila mu luzingu lukambu tsembolo ; bika wukhula ayi wumbona kiadi. ");
INSERT INTO yom_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Malu mama madi va ntoto wuyalumuka mu lukhutukunu lunneni, ndiela zitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Nkunga Davidi. Yave niandi kiezila kiama ayi phulusu ama. Nani ndilenda mona tsisi e ? Yave niandi suamunu kingolo mu luzingu luama. Nani ndilenda mona boma e ? ");
INSERT INTO yom_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Mu thangu batu bambimbi, bela kuiza ku ntualꞌama mu diambu di dia nsuni ama ; mu thangu bambeni ziama ayi bobo bandendi bela kuiza kunduanisa, bela bumina thutu ayi bela bua. ");
INSERT INTO yom_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Ka diambu ko nkangu wu masodi wunzungididi, ntimꞌama wulendi mona tsisi ko ; Ka diambu ko mvita yibuidi mu diambu diama, ndilendi zimbisa diana ko. ");
INSERT INTO yom_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Kima kimosi ndilomba kuidi Yave, kiawu ndintomba : Thidi vuanda mu bilumbu bioso bi luzingu luama mu nzo Yave, mu diambu nditalanga kitoko ki Yave ayi mu diambu ndintombannga mu nzo andi. ");
INSERT INTO yom_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Bila mu lumbu ki ziphasi wela ku kheba mu luvovomo mu buangu kiandi kamvuandanga ; wela kutsueka ku tsi Nzoꞌandi yi ngoto ; wela kuthedimisa va ditadi di ngolo. ");
INSERT INTO yom_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Buna ntu ama wulenda vumuka va yilu bambeni ziama zinzungididi. Mu nzoꞌandi yi ngoto, ndiela tambika makaba mu khini. Ndiela yimbila ayi bula miziki mu diambu di Yave. ");
INSERT INTO yom_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Wa mbemboꞌama bu ndilembo tedi, a Yave ; wumboni kiadi ayi wuphana mvutu. ");
INSERT INTO yom_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Ntimꞌama wutubidi mu diambu diaku : “Tomba zizi kiandi.” Zizi kiaku, a Yave, kiawu ndiela tomba. ");
INSERT INTO yom_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Kadi kutsueka zizi kiaku. Bika kuka kisadi kiaku mu nganzi. Ngeyo wuba nsadisi ama kadi kumbika, kadi kundiekula. A Nzambi yi Mvulusi ama. ");
INSERT INTO yom_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Ka diambu ko dise diama ayi ngudi ama bandiekudi ; Yave wela kundiakula. ");
INSERT INTO yom_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Wundonga nzilꞌaku, a Yave ayi wundiatisa mu nsolo wu songa mu diambu di batu bobo beti kundiamisa. ");
INSERT INTO yom_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Kadi kundiekula mu luzolo lu batu bobo beti kundenda, bila bambangi ba luvunu zitelimini mu diambu diama, ayi zieti yindula matsita. ");
INSERT INTO yom_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Ndisia diana mu diambu diadi : Ndiela mona mamboti ma Yave va ntoto wu batu badi moyo. ");
INSERT INTO yom_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Tadidila Yave ! Wukikindisa ayi bika ntimꞌaku wukinda ; ayi tadidila Yave. ");
INSERT INTO yom_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Nkunga Davidi. Ngeyo ndintela ; A Yave, ditadi diama di ngolo, kadi kunzibikila dikutu diaku Bila ngeyo ba dio sui ; buna ndiela dedakana bobo bankulukanga mu dibulu dimula. ");
INSERT INTO yom_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Wa yamikina kuami mu diambu di kiadi banga bu ndikutela mu tomba lusadusu banga bu ndieti vumuna mioko miama ku ndambu buangu kiaku kilutidi kinlongo. ");
INSERT INTO yom_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Kadi kuphitumuna va kimosi ayi batu bambimbi ayi batu beti vanga mambimbi ; bobo banyolukilanga mambu ma ndembama va kimosi ayi badiawu vayi banyindulanga mambimbi mu mintima miawu. ");
INSERT INTO yom_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Wuba vutudila boso buididi mavanga mawu, ayi boso buididi mavanga mawu mambimbi. Wuba vutudila boso buididi mavanga ma mioko miawu, wuba vutudila boso buididi mambu momo bavanga. ");
INSERT INTO yom_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Sumbu batalanga ko mavanga ma Yave, ayi mavanga ma mioko miandi, wela ku babunga ayi kalendi ku batunga diaka ko. ");
INSERT INTO yom_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Nzitusu wuba kuidi Yave ! Bila wuwilu yamikina kuama mu diambu di kiadi. ");
INSERT INTO yom_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Yave niandi zingolo ziama ayi nkakuꞌama. Ntimꞌama wuntulanga diana mu niandi ayi ndisadusu. Ntimꞌama weti mona khini yi ngolo ayi ndiela kumvutudila matondo mu nkungꞌama. ");
INSERT INTO yom_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yave niandi ngolo mu diambu di batu bandi. Niandi buangu kingolo ki khudulu yi mutu andi wowo kadukudila mafuta. ");
INSERT INTO yom_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Vukisa batu baku ayi sakumuna kiuka kiaku. Bika wuba nsungi awu ayi wuba nata mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Nkunga Davidi. Luvana kuidi Yave, beno batu badi ngolo ; Luvana nkembo kuidi Yave ayi zingolo. ");
INSERT INTO yom_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Luvana nkembo kuidi Yave wufuanikini mu dizina diandi. Lubuongimina Yave mu kiezila ki kinlongo kiandi. ");
INSERT INTO yom_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Mbembo Yave yidi va mbata minlangu. Nzambi yi nkembo wulembo dumi. Yave wulembo dumi va mbata minlangu minneni. ");
INSERT INTO yom_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Mbembo Yave yidi yi lulendo, mbembo Yave yidi yi nzitusu. ");
INSERT INTO yom_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Mbembo Yave yinkelulanga minti mi sedeli ; Yave wunkelulanga minti mi sedeli midi mu Libani mu bitini. ");
INSERT INTO yom_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Wunzamisanga Libani banga muana wungombi ; Silioni banga muana wu phakasa. ");
INSERT INTO yom_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Mbembo Yave yilembo totula minlaki mi mbazu. ");
INSERT INTO yom_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Mbembo Yave yintitisanga dikanga. Yave wuntitisanga dikanga di Kadesi. ");
INSERT INTO yom_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Mbembo Yave yimbutisanga minsuma ; yeti vambisa minsitu. Mu Nzoꞌandi, bima bioso bilembo yamikina : “nkembo”. ");
INSERT INTO yom_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Yave wumvuandanga va kundu ki kipfumu va mbata khuka minlangu ; Yave weti vuanda banga ntinu mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Yave weti vana batu bandi zingolo ; Yave weti sakumuna batu bandi mu ndembama. ");
INSERT INTO yom_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Nkunga Davidi kayimbidila mu mbiekolo nzo Nzambi. Ndiela kuyayisa, a Yave bila ngeyo wuthotula mu dibulu didi thipula Wusia tia ko ti bambeni ziama zimona khini mu diambu diama. ");
INSERT INTO yom_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","A Yave, Nzambi ama, ngeyo nditela mu diambu di lusadusu ayi ngeyo wumbelusa. ");
INSERT INTO yom_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Yave, ngeyo wuthotula mu tsi bafua, ngeyo wuthanina muingi ndibika tibuka mu dibulu. ");
INSERT INTO yom_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Luyimbidila Yave beno banlongo bandi ; Zitisanu dizina diandi di nlongo. ");
INSERT INTO yom_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Bila nganzi andi yizingilanga mu ndambu thangu kaka. Vayi nlemvo andi wunzinganga mu zithangu zioso ; bidilu bilenda kuiza va builu ; vayi khini yinkuizanga va nsuka. ");
INSERT INTO yom_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Bu ndiba mu luvovomo, ndituba : “Ndilendi nikunu ko” ");
INSERT INTO yom_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","A Yave, mu nlemvo aku, ngeyo wukindisa mongoꞌama… vayi bu wusueka zizi kiaku buna minu ndimona boma. ");
INSERT INTO yom_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Kuidi ngeyo, a Yave, nditela mbila. Kuidi Yave ndiyamikina mu diambu di lusadusu ");
INSERT INTO yom_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“Ndandu mbi yidi mu mbivusu ama, minu kuluka mu dibulu e ? Mbungi-mbungi yilenda kuzitisa e ? Voti yilenda yamikina kikhuikizi kiaku e ? ");
INSERT INTO yom_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","A Yave wa, wumboni kiadi, A yave, bika wuba lusadusu luama.” ");
INSERT INTO yom_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Ngeyo wuviakisa bidilu biama makinu, wunianguna tsaku ama ayi wuphuika khini. ");
INSERT INTO yom_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Muingi ntimꞌama wuyimbidila minkunga ayi wubika ba dio sui. A Yave, Nzambi ama, ndiela ku vutudilanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Kuidi ngeyo, Yave ndintombila suamunu ; kadi khumbu yimosi ndifua tsoni ; wukhula mu busonga buaku. ");
INSERT INTO yom_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Yinika dikutu diaku kuidi minu, Yiza nsualu, mu kukhula ! Kuidi minu, bika wuba ditadi diama dingolo disuamina, suamunu kingolo, mu diambu di kuphukisa. ");
INSERT INTO yom_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Sumbu didi ti ngeyo ditadi diama dingolo ayi suamunu kiama kingolo. Mu diambu di dizina diaku bika wuthuadisa ayi wundiatisa. ");
INSERT INTO yom_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Bika wuthotula mu ntambu wu bathambila, bila ngeyo suamunu kiama. ");
INSERT INTO yom_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Mu mioko miaku ndintambika pheve ama ; Wukhula, a Yave, ngeyo Nzambi yi kiedika. ");
INSERT INTO yom_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Ndieti lenda bobo bansingiminanga mu bitumba biphamba. Vayi minu diana diama didi mu Yave. ");
INSERT INTO yom_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Ndiela mona khini ayi ndiela yangalala mu diambu di luzolo luaku ; bila wumona ziphasi ziama ; wuzaba kiadi ki muelꞌama. ");
INSERT INTO yom_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Ayi wusia ku ndiekula ko mu mioko mi mbeni. Vayi ngeyo malu mama va buangu ki yalumuka. ");
INSERT INTO yom_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Bika wumbona kiadi, a Yave, bila mu ziphasi ndidi. Meso mama ; mabividi mu diambu di maniongo muelꞌama ayi nitu ama bibividi mu diambu di phasi ");
INSERT INTO yom_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Luzingu luama lulembo suki mu kiadi ayi mimvu miama milembo suki mu diambu di kunga. Zingolo ziama zilembo suki mu diambu di ziphasi ziama, ayi mimvesi miama milembo lebakana ngolo. ");
INSERT INTO yom_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Mu diambu di bambeni ziama zioso, ndiyikidi bila ki nlenzo kuidi bobo bafikimini yami ayi bila ki tsisi yiwombo mu diambu di batu bobo bazabini yama. Bobo bakumbona mu nzila balembo tini va ndidi. ");
INSERT INTO yom_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Banzimbikini banga ti ndifua Ndidi banga nzungu tuma yibudika. ");
INSERT INTO yom_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Bila ndilembo wi balembo thubidila buwombo ku ndambu ayi tsisi yingolo mu zindambu zioso balembo kutakananga va kimosi mu diambu banduanisa ; balembo yendila luzingu luama manenga. ");
INSERT INTO yom_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Vayi minu, mu ngeyo ndintula diana diama, a Yave, Ndieti tuba : “Ngeyo Nzambi ama.” ");
INSERT INTO yom_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Bilumbu biama bioso bidi mu mioko miaku ; wukhula mu mioko mi bambeni ziama ayi mu mioko mi bobo balembo ndandakana. ");
INSERT INTO yom_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Bika zizi kiaku kikienzukila kisadi kiaku ; wuphukisa mu diambu di luzolo luaku lungolo. ");
INSERT INTO yom_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Kadi tala ti ndifua tsoni, a Yave, bila kuidi ngeyo ndiyamikina. Vayi bika batu bambimbi bafua tsoni ! Bika baba dio sui ku tsi bafua ! ");
INSERT INTO yom_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Bika bididi bintotulanga luvunu biba dio sui ; mu luniemo ayi mu mvuezolo beti yolukila mu luyanu kuidi mutu wusonga. ");
INSERT INTO yom_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","A phila, mamboti maku madidi manneni ; momo wulundila bobo beti kukinzika ; momo wuvangila bobo beti tomba suamunu kuidi ngeyo va ntuala batu. ");
INSERT INTO yom_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Va ntuala meso maku, ngeyo weti kuba suekanga mu diambu di mambimbi mayindulanga batu ku buangu kioki wumvuandanga, ngeyo weti kuba keba mu luvovomo mu ludimi lueti funda. ");
INSERT INTO yom_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Nzitusu wuba kuidi Yave Bila niandi wumbonisini luzolo luandi lungolo mu thangu ndiba mu divula dizungulu kuidi masodi. ");
INSERT INTO yom_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Mu boma buama minu ndituba : “Minu ndivengumunu thama va ntualꞌaku.” Muaki ngeyo wuwa yamikina kuama mu diambu di kiadi mu thangu nditela mu diambu di lusadusu. ");
INSERT INTO yom_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Bika luzola Yave beno banlongo bandi boso. Yave wunkebanga minkhuikizi Vayi wumvutudilanga mu bufuana bobo badi luniemo. ");
INSERT INTO yom_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Lukikindisa ayi bika luba bukhafi mu mintima mieno ; beno boso bobo luntulanga diana dieno mu Yave. ");
INSERT INTO yom_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Nkunga Davidi. Lusakumunu kuidi mutu wowo wulemvokolo nzimbalꞌandi ; masumu mandi mafukulu. ");
INSERT INTO yom_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Lusakumunu kuidi mutu wowo Yave kankambu ntangila disumu diandi, ayi kambulu bukhita mu pheve andi. ");
INSERT INTO yom_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Bu ndiba dio sui, mimvesi miama milebakana mu kunga ku ndiba nkunga mu lumbu kimvimba. ");
INSERT INTO yom_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Bila muini ayi builu koko kuaku ziku kuba va minu. Zingolo ziama zisukidi banga mu thangu yi muini wu ngolo. ");
INSERT INTO yom_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Buna ndizabikisa disumu diama, ndisia fuka mambimbi mama ko. Ndituba : “Ndiela lomba nlemvo mu zinzimbala ziama kuidi Yave.” Buna ngeyo wulemvukila mambimbi ma disumu diama. ");
INSERT INTO yom_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Buna diawu bika woso mutu wunkinzikanga mambu maku, wela kusambila mu thangu yoyi kalenda kubakula. Bukiedika mu thangu yi khuka nlangu yingolo milendi kunlalumuna ko. ");
INSERT INTO yom_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ngeyo buangu kiama kieti kutsueka ; ngeyo weti kukheba mu ziphasi. Ngeyo wukunzungidilanga mu minkunga mi khudulu. ");
INSERT INTO yom_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","“Ndiela kumonisa ayi kulonga nzila yoyi fueti diatila, ndiela kuvana ndongi ayi thaluꞌama yela ba vadi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Kadi ba banga phunda voti banga bulu kioki bantedilanga ‘mule’ ; bibulu bikondolo diela, vayi biobi binkangungu nsinga ayi sengo mu munu bila nganu bilenda fikama va widi.” ");
INSERT INTO yom_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Mabienga mawombo madi mu diambu di mutu wumbimbi ; vayi luzolo lu ngolo lu ma Yave lunzungidilanga mutu wowo wuntulanga diana diandi mu niandi. ");
INSERT INTO yom_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Monanu khini ayi luyangadala mu Yave beno basonga. Luyimbila, beno boso luidi balulama mu mintima. ");
INSERT INTO yom_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Luyimbila Yave mu khini beno basonga Bufueni ti mutu widi ntima lulama kanzitisa. ");
INSERT INTO yom_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Luzitisa Yave mu ngitala, Lusika miziki mu diambu diandi mu siku kidi dikumi di zitsinga. ");
INSERT INTO yom_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Lunyimbidila nkunga wumona ; Lusika bumboti ayi luyamikina mu diambu di khini. ");
INSERT INTO yom_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Bila mambu ma Yave madi masonga ayi makiedika. Niandi widi kikhuikizi mu mamoso keti vanga. ");
INSERT INTO yom_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Yave wunzolanga bululama ayi busonga Ntoto widi wuwala luzolo luandi lungolo. ");
INSERT INTO yom_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Diyilu divangimina mu mambu ma Yave. Nkangu andi woso wu bima, bivangimina mu phemo yi munu andi. ");
INSERT INTO yom_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Wunkupikisanga minlangu mi mbu mu khati mvungu, ayi wuntulanga biza mu bilundulu. ");
INSERT INTO yom_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Bika ntoto wumvimba wukinzika Yave. Bika batu boso ba ntoto bantitila. ");
INSERT INTO yom_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Bila bu katuba, buna diawu divangama, bu katuma, buna diawu ditelama dio ngui. ");
INSERT INTO yom_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Yave wumvunzanga zikhanu zi makanda wumvondanga mayindu ma batu. ");
INSERT INTO yom_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Vayi zikhanu zi Yave zinzingilanga mu zithangu zioso mayindu ma ntimꞌandi manzingilanga mu tsungi ka tsungi. ");
INSERT INTO yom_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Lusakumunu luidi kuidi dikanda di batu diodi Nzambi kadidi Yave, batu bobo kasobula mu diambu di kiuka kiandi. ");
INSERT INTO yom_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Tona ku diyilu, Yave wulembo tadi ; wulembo moni bana boso ba batu. ");
INSERT INTO yom_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Tona ku buangu kioki keti vuanda, Yave wulembo tadi batu banzingilanga va ntoto. ");
INSERT INTO yom_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Niandi wunkubikanga mintima mi batu boso, Niandi wuntalanga mavanga mawu moso beti vanga. ");
INSERT INTO yom_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Kuisi kadi ntinu wumosi ko wulenda vuka mu diambu di nkangu andi wunneni wu masodi ; kuisi kadi mutu wu lulendo ko wulenda tina mu diambu di zingolo ziandi ziwombo ; ");
INSERT INTO yom_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Phunda yidi diana di phamba mu diambu di khudulu ; Ka diambu ko zingolo ziandi zinneni, yilendi vukisa ko. ");
INSERT INTO yom_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Vayi meso ma Yave madi kuidi bawu beti kunkinzika ; kuidi bawu bantulanga diana mu luzolo luandi lungolo, ");
INSERT INTO yom_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","mu diambu di kuba kula mu lufua ayi mu diambu di kuba keba bamoyo mu thangu yi kanda. ");
INSERT INTO yom_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Tulembo vingila mu diana kuidi Yave. Niandi nsadisi eto ayi nkaku eto. ");
INSERT INTO yom_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Mu niandi mintima mieto mieti mona khini bila tutula diana dieto mu dizina diandi di nlongo, ");
INSERT INTO yom_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Bika luzolo luaku lu ngolo luba va beto boso, a Yave bu tueti tula diana dieto mu ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Nkunga Davidi mu thangu kavuna lawuka va meso ma Abimeleki bu kankuka ayi Davidi wuyenda. Ndiela yayisa Yave mu zithangu zioso ; Nzitusu andi wela ba mu bididi biama mu kadika thangu. ");
INSERT INTO yom_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Muelꞌama wela kiniemisa mu Yave. Bika badi mu phasi bawa ayi bamona khini. ");
INSERT INTO yom_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Kembisanu Yave va kimosi ayi minu, bika tuyayisanu dizina diandi va kimosi, ");
INSERT INTO yom_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Nditomba Yave, niandi wuphana mvutu ayi niandi wukhula mu zitsisi ziama zioso. ");
INSERT INTO yom_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Batu bobo batala kuidi niandi bakienzulu ayi bizizi biawu bilendi mona tsoni nkutu ko. ");
INSERT INTO yom_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Nsukami wawu wutela ; ayi Yave wunwa ayi wuphukisa mu ziphasi ziandi zioso. ");
INSERT INTO yom_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Mbasi Yave yinzungidilanga bobo bankinzikanga Yave ayi wukubakulanga. ");
INSERT INTO yom_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Lubimba ayi lutala ti Yave widi wumboti ; Lusakumunu luidi kuidi mutu wowo wuntombanga suamunu mu niandi. ");
INSERT INTO yom_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Lukinzika Yave beno banlongo bandi. Bila bobo beti kunkinzika, balendi kambu kima ko. ");
INSERT INTO yom_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Zikhosi zimvonganga ayi zimfuanga nzala vayi bobo bantombanga Yave balendi kambu kima ko. ");
INSERT INTO yom_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Yizanu bana bama, lungua. Ndiela ku lulonga buevi bu kinzikilanga Yave. ");
INSERT INTO yom_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Nani mutu mu beno wunzolanga luzingu, ayi tidi mona bilumbu biwombo bi mboti ");
INSERT INTO yom_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Vengumuna ludimi luaku mu mambu mambimbi, ayi bididi biaku mu tuba mambu ma luvunu. ");
INSERT INTO yom_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Botuka mu mambimbi vayi vanga mamboti. Tomba ndembama ayi landakana yawu. ");
INSERT INTO yom_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Meso ma Yave mantalanga basonga ayi makutu mandi madi mazibuka bu beti yamikina. ");
INSERT INTO yom_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Yave wunsuekanga zizi kiandi kuidi batu bamvanganga mambimbi mu diambu babika buela tebukulu moyo va ntoto. ");
INSERT INTO yom_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Batu basonga banyamikinanga ayi Yave weti kuba wanga ayi wukubakulanga mu ziphasi ziawu zioso. ");
INSERT INTO yom_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Yave widi wufikama vadi batu bobo badi mintima mi kofakana. Ayi wumvukisanga bobo badi pheve yidi mu kiadi kingolo. ");
INSERT INTO yom_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Mutu wusonga wumbuilungu ziphasi ziwombo vayi Yave wunkukulanga mu zizioso. ");
INSERT INTO yom_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Niandi wunkebanga mimvesi miandi mioso kadi wumosi wulendi keluka ko. ");
INSERT INTO yom_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Mambu mambimbi mela vonda mutu wumbimbi ; bobo beti lenda nkua busonga bela bedoso. ");
INSERT INTO yom_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Yave wunkulanga bisadi biandi, ayi kadi wumosi mu babo bobo bansuaminanga mu niandi kalendi bedoso ko. ");
INSERT INTO yom_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Nkunga Davidi. Zonzisa, a Yave, bobo balembo nzonzisa. Nuanisa bobo balembo nduanisa, ");
INSERT INTO yom_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","simba nkaku wu fioti ayi wunneni telama ayi yiza wutsadisa. ");
INSERT INTO yom_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Bonga dionga difioti ayi dinneni ayi kaka nzila yi bobo balembo ndandakana kamba muelꞌama : “Minu ndidi phulusu aku.” ");
INSERT INTO yom_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Bika batu babo bantombanga luzingu luama baba dio kombolo ayi bafua tsoni. Bika bobo bantombanga mabienga mama bavutuka ku mbusa ayi baba mu divuda ; ");
INSERT INTO yom_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","bika baba banga mavevolo mamvevomono kuidi phemo va kimosi ayi mbasi yi Yave yi bakuka. ");
INSERT INTO yom_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Bika nsolo awu wuba tombi ayi ndelo. Va kimosi ayi mbasi Yave yi balandakana. ");
INSERT INTO yom_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Bila bathambididi dikondi diawu mu kambu bila ; mu kambu kadi bila bakabidi dibulu dinneni mu diambu diama. ");
INSERT INTO yom_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Bika mbivusulu yi babuila mu kinzimbukila ayi bika dikondi diodi batamba bawu veka dibabuila ; bika babua mu dibulu, mu diambu di mbivusulu awu. ");
INSERT INTO yom_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Buna muelꞌama wela mona khini mu Yave ayi wela yangalala mu phulusu andi. ");
INSERT INTO yom_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Buna nitu ama yimvimba yela yamikina : “nani widi banga ngeyo Yave ? Ngeyo weti kula nsukami mu mioko mi mutu wunlutidi zingolo ; nsukami ayi nkua mabienga mu mioko mi mutu wowo wulembo bayibi.” ");
INSERT INTO yom_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Bambangi bakondolo kiadi zilembo telama ; zilembo ndiuvula buivu mu mambu ma khambulu kuama zaba. ");
INSERT INTO yom_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Bamvutudidi mambimbi mu mamboti. Bayekudi muelꞌama wawu veka. ");
INSERT INTO yom_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Vayi bu baba mu kimbevo ; minu ndivuata tsaku. Ndikikulula mu kukifuisa nzala mu diambu di lusambulu Thangu zitsambulu ziama zivutuka kuidi minu mu kambu mvutu. ");
INSERT INTO yom_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Ndibedi diatanga ku tsi kiadi banga mu diambu di nkundi ama voti khomba ama. Ndibedi komvikanga ntu ku tsi mu diambu di kiadi banga minu ndindila ngudi ama. ");
INSERT INTO yom_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Minu bu ndibumina thutu, bakutakana va kimosi mu khini. Batu bakutakana mu diambu di kunduanisa minu mu kambu zaba diambu. Bawu bamfinga mu kambu vonga. ");
INSERT INTO yom_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Banga batu bobo bankinzikanga ko mambu ma Nzambi, balembo tsekinina mu bu mbimbi balembo khuetila meso. ");
INSERT INTO yom_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","A Yave, nate thangu mbi wela kumatadidilanga e ? Kula luzingu luama mu mbivusu awu ; kula luzingu luama luthalu mu zikhosi zioso. ");
INSERT INTO yom_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Ndiela kuvutudila matondo mu lukutukunu lunneni ; va khatitsika batu bawombo ndiela kuzitisa. ");
INSERT INTO yom_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Kadi tala ti bamona khini mu diambu diama, bobo badi bambeni ziama mu kambu bila ; Kadi tala ti bobo bakundenganga mu kambu bila, bandiengudila meso mu bumbimbi. ");
INSERT INTO yom_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Bayolukilanga ndembama ko ; vayi banyindulanga mambu ma luvunu mu diambu di vunina bobo banzingilanga mu ndembama mu tsi. ");
INSERT INTO yom_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Balembo nzibudila miunu ayi balembo tubi : “A, a… mu meso meto veka tumueni mawu.” ");
INSERT INTO yom_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","A Yave, ngeyo wumona mambu momo bika ba dio sui, kadi kuthatukila, a Yave, ");
INSERT INTO yom_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","kotuka ayi telama mu zonzika, Nzambi ama ayi Yave ama. ");
INSERT INTO yom_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Wundungisa boso buididi busonga buaku, a Yave, Nzambi ama ; ayi kadi tala ti bamona khini mu diambu diama. ");
INSERT INTO yom_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Kadi kuba bika bayindula : “A, a … buawu bobo tutididi.” Voti babika tuba : “beto tumminini.” ");
INSERT INTO yom_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Bika babo bammonanga khini mu ziphasi ziama, bafua tsoni ayi baba dio kombolo Bika bobo balembo kukiniemisanga bawu veka mu diambu diama bafua tsoni ayi baba dio kombolo. ");
INSERT INTO yom_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Bika bobo bamonanga khini mu ndungunu ama bamonanga khini ayi bayangadala bika batuba mu zithangu zioso : “Bika Yave kayayusu, niandi wummonanga khini mu mamboti ma kisadi kiandi.” ");
INSERT INTO yom_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Buna ludimi luama luela yolukila busonga buaku ; ayi minzitusu miaku mu lumbu kimvimba. ");
INSERT INTO yom_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Nkunga Davidi, kisadi ki Yave, kuidi pfumu minyimbidi. Mambu ma Nzambi madi mu ntimꞌama Mu mambu matedi disumu di mutu wumbimbi : kuisi ko mambu ma kinzikila Nzambi va meso mandi. ");
INSERT INTO yom_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Bila va meso mandi veka, weti kukiniemisa buwombo mu bakula voti lenda masumu mandi. ");
INSERT INTO yom_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Mambu ma munuꞌandi madi mambimbi ayi ma luvunu. Wulembo kuandi buela ba nkua nduenga ayi bueba vanga mamboti. ");
INSERT INTO yom_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Bu kadi va mbukꞌandi, wunyindulanga mambu mambimbi. Weti kukiyekula niandi veka mu nzila yi masumu kalozanga ko mambu mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Luzolo luaku, a Yave, lueti tula nate ku diyilu kikhuikizi kiaku nate mu matuti ");
INSERT INTO yom_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Busonga buaku buidi banga miongo minda ; zinzengolo ziaku zidi banga dibulu dinneni. O Yave, ngeyo wunkebanga mutu ayi bulu. ");
INSERT INTO yom_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Tala phila luzolo luaku lu ngolo lukambu thalu ! Luidi luzangulu ayi lukululu va khatitsika batu bobo bansuaminanga ku tsi phozi yi mavevi maku. ");
INSERT INTO yom_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Beti tula minyengo mu wombo di bima bi nzo aku ayi ngeyo wukubanuikinanga mu nlangu wu makhini maku. ");
INSERT INTO yom_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Bila kuidi ngeyo kuidi tho yi luzingu. Mu kiezila kiaku, tulembo moni kiezila. ");
INSERT INTO yom_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Landakana vanga luzolo luaku kuidi bawu bazebi ayi busonga buaku kuidi bawu badi mintima mi lulama. ");
INSERT INTO yom_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Bika kulu ku nkua luniemo kubika kumbakidila ; voti bika koko ku mutu wumbimbi kubika kuthinisa thama. ");
INSERT INTO yom_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Tala phila yilembo buila bisadi bi mambu mambimbi ; balumbulu va tsi ayi balendi buela telama ko. ");
INSERT INTO yom_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Nkunga Davidi. Kadi fuemina batu bamvanganga mambimbi. Kadi monanga kikhenene bobo bamvanganga mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Bila banga biti, bela yuma mu nsualu ; banga biti bi nlangu bela lebuka mu nsualu. ");
INSERT INTO yom_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Tula diana diaku mu Yave ayi vanga mamboti ; buna wela vuanda mu tsi ayi wela zingila mu ndembama. ");
INSERT INTO yom_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Mona khini mu Yave buna wela kuvana mambu mantomba ntimꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Yekula nzilꞌaku kuidi Yave, Tula diana diaku mu niandi, buna wela vanga diambu diadi : ");
INSERT INTO yom_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Wela kienzula busonga buaku banga kiezila ki khiesa buisi nzengolo yi diambu diaku banga thangu va midi. ");
INSERT INTO yom_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Ba dio sui va ntuala Yave, ayi wuntadidila mu mvibudulu kadi fuemina batu bu balembo moni mamboti mu nzilꞌandi ; ayi kadi fuemina batu balembo sadila makani mawu mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Bika buela fuema ayi zimbakana nganzi ; kadi fuema bila dieti nata kaka ku mambu mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Bila bobo bamvanganga mambimbi bela lalukusu ; vayi bobo bantulanga diana diawu mu Yave bela tambula tsi banga kiuka. ");
INSERT INTO yom_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Fioti kuandi fisiedi, buna batu bambimbi balendi buela monika ko ; buna wela tala buangu kibabedi vayi bela va ba ko. ");
INSERT INTO yom_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Vayi minlembami miela tambula tsi banga kiuka ayi miela monanga khini mu ndembama yiwombo. ");
INSERT INTO yom_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Batu bambimbi bamfielanga batu basonga ayi beti kuba kuetila meno. ");
INSERT INTO yom_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Yave wunsevanga mutu wumbimbi ; bila zebi ti lumbu kiandi kalembo yizi. ");
INSERT INTO yom_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Batu bambimbi bavola bisabala ayi baleka mimbasa mu diambu di vonda nkua kiadi ayi mutu wusukama ; mu diambu di zenga bobo bandiatanga mu nzila yi lulama. ");
INSERT INTO yom_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Bisabala biawu biela kota mu mintima miawu veka ; ayi mimbasa miawu miela kelulu. ");
INSERT INTO yom_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Baka ku fioti ku mutu wusonga kulutidi ayi baka kuphuedi ku wombo di batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Bila lulendo lu batu bambimbi luela kelulu, vayi Yave wunsimbanga batu basonga. ");
INSERT INTO yom_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Bilumbu bi batu bakambulu tsembolo bizabikini kuidi Yave ayi kiuka kiawu kizingilanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Mu thangu yi ziphasi, balendi yuma ko mu lumbu ki nzala, bawu bela mona khini yiwombo. ");
INSERT INTO yom_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Vayi batu bambimbi bela bungana. Bambeni zi Yave, badi banga kitoko ki zitsola, ziela lalakana ; ziela lalakana banga muisi. ");
INSERT INTO yom_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Mutu wumbimbi wundevanga vayi kavutulanga ko ; Vayi mutu wusonga weti kabula mu luzolo lu ntima. ");
INSERT INTO yom_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Bobo Yave kasakumuna bela tambula tsi banga kiuka, vayi bobo kasinga bela lalukusu. ");
INSERT INTO yom_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Enati Yave mueni khini mu nzila yi mutu buna wunkindisanga zithambi zi mutu beni. ");
INSERT INTO yom_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Ka diambu ko bumini thutu ; kalendi bua ko ; bila Yave wukunsimbidilanga mu koko kuandi. ");
INSERT INTO yom_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Ndiba ditoko, buabu ndieka nunu ; vayi ndisia mona ko mutu wusonga wuyekolo voti ndisia mona ko bana bandi balomba dipha. ");
INSERT INTO yom_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Mu zithangu zioso, beti kabula ayi vananga mu luzolo Bana bawu bela sakumunu. ");
INSERT INTO yom_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Tina mambimbi ; vanga mamboti buna wela vuanda mu tsi mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Bila Yave wunzolanga mambu masonga ayi kalendi zimbakana ko mikhuikizi miandi. Bela kebungu mu zithangu zioso vayi nkuna wu batu bambimbi wela lalukusu. ");
INSERT INTO yom_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Batu basonga bela tambula tsi banga kiuka ayi bela mukalanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Munu wu mutu wusonga wuntotulanga mambu ma nduenga ayi ludimi luandi luntubanga mambu ma lulama. ");
INSERT INTO yom_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Mina mi Nzambi andi midi mu ntimꞌandi ; Malu mandi malendi sialumuka ko. ");
INSERT INTO yom_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Mutu wumbimbi wumfielanga mutu wusonga ayi wuntombanga kumvondisa. ");
INSERT INTO yom_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Yave kalendi yekula ko basonga mu lulendo lu batu bambimbi voti kuba bika babedoso bu balembo sambusu. ");
INSERT INTO yom_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Tadidila Yave, ayi keba nzilꞌandi. Buna wela kuyayisa mu diambu wutambula tsi banga kiuka ; thangu batu bambimbi bela lalukusu, ngeyo wela bumona. ");
INSERT INTO yom_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Ndimona mutu wumbimbi, ayi mutu kondolo kiadi, wuyunduka bumboti banga nti wu nlangu mu ntoto wowo kabutukila. ");
INSERT INTO yom_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Niandi wuvioka, nsualu ayi kasiedi ko. Ndintombidi ngolo vayi kasia monika ko. ");
INSERT INTO yom_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Fiongunina mutu kambulu tsembolo ayi tala tala mutu wu lulama buna wela mona ti tsukulu yi mutu wowo yidi tsukulu yi ndembama. ");
INSERT INTO yom_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Vayi bankua masumu boso bela vondo va kimosi tsukulu yi batu bambimbi yela ba lalukusu. ");
INSERT INTO yom_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Phulusu yi batu basonga kuidi Yave yeti ba. Niandi zingolo ziawu mu thangu yi ziphasi. ");
INSERT INTO yom_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Yave wukubasadisanga ayi wukubakulanga ; wukubakulanga mu batu bambimbi ayi wukubavukisanga bila mu niandi beti suamina. ");
INSERT INTO yom_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Nkunga Davidi mu diambu di thebokolo moyo. A Yave, kadi kuthemima ku tsi nganzi aku voti kadi kuphana thumbudulu ku tsi nganzi aku yi kikhesa. ");
INSERT INTO yom_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Bila madionga maku mathobudi ayi koko kuaku kumbetidi. ");
INSERT INTO yom_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Mu diambu di nganzi aku yi kikhesa, buvini buisi ko mu nitu ama. Mimvesi miama misiedi ko buvini mu diambu di masumu mama. ");
INSERT INTO yom_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Zinzimbala ziama zimfietikisidi ngolo banga mfuna widi zitu kiwombo ; madidi ngolo zitu mu diambu diama banga mfuna wu ngolo. ");
INSERT INTO yom_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Ziphuta ziama zilembo bodi ngolo yiwombo ayi zilembo yizi tsudi yiwombo mu diambu di buvulu buama bu masumu. ");
INSERT INTO yom_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Ndidi wukomvama ngolo ayi khulukidi nate va tsi ; Lumbu ki mvimba mu kiadi ndieti diatila. ");
INSERT INTO yom_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Bila ziphasi zingolo zidi mu luketo luama, buvini buisi ko mu nitu ama. ");
INSERT INTO yom_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Ndidi wuvonga ngolo ayi ndidi wukosakana mvimba. Ndilembo kungi mu diambu di ziphasi zi ntima. ");
INSERT INTO yom_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Zitsatu ziama zioso zidi dio yambi va ntualꞌaku, a Yave, ayi vumina kuama kuisi ko kusuama kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Ntimꞌama wulembo sadi ngolo ayi zingolo ziama zimeni ; kiezila kibotukidi mu meso mama. ");
INSERT INTO yom_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Bakundi bama ayi bobo bankibanga yama bathinini mu diambu di ziphuta ziama ; bobo bafikasana yama thama batelimini. ");
INSERT INTO yom_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Bobo bantomba luzingu luama balembo mintambu miawu bobo bantomba kuphanga mbimbi balembo yolukila mbivusu ama ; Mu lumbu kimvimba balembo kubika mambu ma luvunu. ");
INSERT INTO yom_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Minu, ndieka banga mutu wufua matu, wunkambu wa ; banga dibaba dikambu zibula munu andi. ");
INSERT INTO yom_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Ndieka banga mutu wowo wu nkambu wa mutu wowo munu wunkambu baka bu vutudila mvutu. ");
INSERT INTO yom_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Ngeyo ndieti tadidila, a Yave, wela vutula mvutu, a Yave Nzambi ama. ");
INSERT INTO yom_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Bila ndituba : “kadi tala ti bamona khini voti bakiyayisa bawu veka mu diambu diama. Kulu kuama bu kusialumukini.” ");
INSERT INTO yom_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Bila nduka bua ndieka ayi ziphasi ziama zidi kaka mu minu. ");
INSERT INTO yom_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Ndimfunda mbimbi ama. Ndilembo niongi mu diambu di disumu diama. ");
INSERT INTO yom_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Bawombo badi bambeni ziama ; ziozi zibeki zingolo. Bobo bakundendanga mu kambu bila badi bawombo. ");
INSERT INTO yom_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Bobo bakuphutudilanga mambimbi mu mamboti mama balembo thubidila ku ndambu mu thangu ndinlandakana vanga mamboti. ");
INSERT INTO yom_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","A Yave, kadi kundiekula ; kadi kuthatukila Nzambi ama. ");
INSERT INTO yom_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Yiza nsualu mu kutsadisa, A Yave, Mvulusi ama. ");
INSERT INTO yom_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Nkunga Davidi kuidi Yedutuni, pfumu minyimbidi. Minu ndituba : “ndiela sunga zinzila ziama ayi ndiela keba ludimi luama mu masumu. Ndiela tula luvambu mu munuꞌama mu zithangu zioso batu bambimbi bela banga ku ntuala meso mama.” ");
INSERT INTO yom_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Bu ndiba dio sui ayi ndidingalala ayi bu ndisia tuba kadi diambu ko. Vayi ziphasi ziama buelama na buelama zilembo zibuelama. ");
INSERT INTO yom_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Ntimꞌama wulema mu khati nitu ama ; ayi bu ndiyindula, buna mbazu yilema. Diawu nditumbu tubila mu ludimi luama : ");
INSERT INTO yom_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Wumbonisa, a Yave tsukulu yi luzingu luama ; ayi thalu yi bilumbu biama bika wunzabikisa ti luzingu luama vioka lu mvioka ! ");
INSERT INTO yom_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Ngeyo wuvanga bilumbu biama siadila banga dikanda diama Tezo ki mimvu miama kisi ko kadi mfunu va ntanlꞌaku. Kadika luzingu lu mutu luidi kaka phemo. ");
INSERT INTO yom_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Mutu widi khatika kimbindi bu keti kuenda ayi vutuka weti banga mayindu, vayi mu phamba kuandi ; weti kupika bima vayi kakadi zaba nani wela bitota. ");
INSERT INTO yom_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Vayi buabu, Yave, mbi mfueti vingila e ? Diana diama didi mu ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Wuphukisa mu zinzimbala ziama zioso ; kadi kundiekula ndikituka sekonono ki bivulu. ");
INSERT INTO yom_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Ndiba dio sui ; ndisia zibula munu ama ko bila ngeyo wuvanga buawu. ");
INSERT INTO yom_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Wuphengumunina nsongo aku. Ndieka suka mu diambu di bikoti bi mioko miaku. ");
INSERT INTO yom_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Ngeyo weti tubidila ayi weti vana batu thumbudulu mu diambu di masumu mawu. Ngeyo weti zinisa kimvuama kiawu banga kiphepele kadika mutu widi phemo. ");
INSERT INTO yom_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Wa lusambulu luama ; a Yave ! Dimba yamikina kuama mu diambu di lusadusu. Kadi lasakana mu bidilu biama ; bila ndieti kalanga yaku va kimosi banga nzenza, banga nkibi, banga bakulu bama boso. ");
INSERT INTO yom_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Wuphengumunina thaluꞌaku muingi ndimona diaka khini tuamina ndunda ayi ndibika buela monika.” ");
INSERT INTO yom_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Ndieti tadidila Yave mu mvibudulu. Niandi wubaluka kuidi minu ayi wuwa yamikina kuama. ");
INSERT INTO yom_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Niandi wuthampula mu dibulu di tsisi, mu khati nyamba wu ngolo. Wutula malu mama va ditadi, wuphana buangu kikinda kioki ndilenda telama. ");
INSERT INTO yom_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Niandi wutula nkunga wumona va munu ama ; nkunga wu zitisila Nzambi eto, Batu bawombo bela mona ayi bela mona tsisi ; ayi bela tula diana diawu mu Yave. ");
INSERT INTO yom_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Lusakumunu kuidi mutu wunkitulanga Yave diana diandi ; ayi wunkambu talanga bankua luniemo kuidi bobo beti baluka kuidi zinzambi zi luvunu. ");
INSERT INTO yom_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","A Yave, Nzambi ama, ngeyo wuvanga matsiminanga mawombo ; ayi bima biobi wukubika mu diambu dieto. Kuisiko mutu wulenda kutangila biawu. Enati thidi ku mayolukila ayi ku matubila ; mawu mawokidi ngolo muingi ndimasamuna. ");
INSERT INTO yom_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Makaba ma vonda ayi makaba matambuku ; ngeyo wumanga mawu ; Ngeyo wutobula matu mama. Makaba mayoko ayi makaba mu diambu di masumu, ngeyo wusia malomba ko. ");
INSERT INTO yom_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Buna ndituba : “ndilembo yizi ; didi disonama mu diambu diama mu buku ti : ");
INSERT INTO yom_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Minu thidi vanga luzolo luaku ; a Nzambi ama, Mina miaku midi mu ntimꞌama.” ");
INSERT INTO yom_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Ndinyamikisa busonga buaku mu lukutukunu lunneni. Ndisia zibika bididi biama ko. Banga kuandi buzebi, a Yave. ");
INSERT INTO yom_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Ndisi sueka ko busonga buaku mu ntimꞌama. Ndiyolukila kikhuikizi kiaku ayi phulusu aku. Ndisia sueka ko luzolo luaku ayi kiedika kiaku mu lukutukunu lunneni. ");
INSERT INTO yom_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Kadi zimbakana kumbonanga kiadi, a Yave. Bika Luzolo luaku ayi kiedika kiaku bikhebanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Bila ziphasi ziwombo zikambu zabakana thalu zinzungididi. Masumu mama mambakidila, ayi ndikadi mona. Maviokidi zitsuki ziama zi ntu mu thalu. Ayi ntimꞌama wulembo vongi mu minu. ");
INSERT INTO yom_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Yangalala, a Yave, mu kuphukisa A Yave, yiza nsualu mu kutsadisa. ");
INSERT INTO yom_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Bika babo bobo bantomba baka luzingu luama ; bafua tsoni ayi baba dio kombolo bika babo bammonanga khini mu mbivusu ama baba dio kombolo. ");
INSERT INTO yom_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Bika babo bobo bantubanga kuidi minu : “A, a…” bamona tsisi mu diambu di zitsoni ziawu veka ");
INSERT INTO yom_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Vayi bika babo bobo bakutombanga bayangalala, ayi bamona khini mu ngeyo. Bika babo banzolanga phulusu aku batuba mu zithangu zioso : “Bika Yave kayayusu.” ");
INSERT INTO yom_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Vayi minu, ndidi mu kiadi ayi nsukami, bika Yave kambanzila. Ngeyo nsadisi ama ayi nkudi ama. Nzambi ama, kadi zingila. ");
INSERT INTO yom_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Lusakumunu kuidi mutu wowo thaluꞌandi yidi kuidi mutu wulebakana, Yave weti ku nkula mu thangu yi ziphasi. ");
INSERT INTO yom_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Yave wela kunkeba ayi wela tanina luzingu luandi ; wela kunsakumuna va ntoto ayi kalendi kunyekula ko mu luzolo lu bobo beti kunlenda ; ");
INSERT INTO yom_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Yave wela kunkindisa va mfulu andi yi kimbevo. Ngeyo wela kumbelusa va mfulu andi yi kimbevo. ");
INSERT INTO yom_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Ndituba : “A Yave, wumboni kiadi. Wumbelusa bila kuidi ngeyo ndivodidi masumu.” ");
INSERT INTO yom_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Bambeni ziama zilembo tubi mambu mu diela dimbimbi mu diambu diama : “Thangu mbi kela fua ayi dizina diandi diela lalakana e ?” ");
INSERT INTO yom_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","yoso thangu mutu kizidi mu kuthala ; mutu wowo wuntubanga luvunu. Ntimꞌandi wufulukidi mambu ma mvuezolo ; buna wuntotukanga ku nganda ayi wunyolukilanga mawu. ");
INSERT INTO yom_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Bambeni ziama zioso zilembo niunguta va kimosi mu diambu diama. Balembo yindula mambimbi mu diambu diama, balembo tubi : ");
INSERT INTO yom_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","“Nsongo wumbimbi wumbuididi. Kalendi buela vumbuka ko va buangu kioki kalambididi.” ");
INSERT INTO yom_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Ka diambu ko nkundi ama wu luzolo, wowo ndibedi silanga diana, wubedi kabulanga dipha diama, wumbalumukini. ");
INSERT INTO yom_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Vayi ngeyo Yave, wumboni kiadi wuthedimisa. Muingi ndiba vutudila landi. ");
INSERT INTO yom_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Nzebi ti ngeyo wunyangalalanga mu minu ; mu diambu di mbeni ama kabika kundunga. ");
INSERT INTO yom_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Mu bufuana kuama, ngeyo wutsimba ; wuthedimisa mu zithangu zioso va tuala meso maku. ");
INSERT INTO yom_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Nzitusu wuba kuidi Yave, Nzambi yi Iseli, mu thangu yi kayimani. ");
INSERT INTO yom_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Nkunga bana ba babakala ba Kole kuidi pfumu minyimbidi. Boso bummoninanga disofi phuila yi nlangu, buawu bobo muelꞌama wididi phuila yi ngeyo ; Nzambi ama. ");
INSERT INTO yom_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Muelꞌama wulembo moni phuila yi Nzambi, Phuila yi Nzambi yi moyo. Thangu mbi ndiela nkuenda ayi ndiela dengana Nzambi e ? ");
INSERT INTO yom_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Matsuela mama mawu maba bidia biama mu builu ayi muini bu babedi ku khambanga mu lumbu kimvimba : “Kuevi kuidi Nzambi aku e ?” ");
INSERT INTO yom_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Mambu momo ndieti tebukila moyo banga minu ndintiamuna muelꞌama : buevi ndibedi kuendilanga va kimosi ayi nkangu wu batu, mu kuba diatisa mu ntanda nate ku nzo Nzambi mu biyoko bi khini ayi mu phutudulu yi matondo va khatitsika batu bawombo badi mu nyengo. ");
INSERT INTO yom_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Bila mbi vongidi bobo, a muelꞌama e ? Bila mbi muelꞌama wulembo niongina mu khati ama e ? Tula diana diaku mu Nzambi bila ndiela kunzitisa diaka ; Mvulusi ama ayi Nzambi ama. ");
INSERT INTO yom_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Muelꞌama widi wuvonga mu khati nitu ama Diawu ndiela kutebukilanga moyo tona ku tsi yi Yolidani, ku zitsongi zi miongi mi Elimoni ayi tona ku mongo wu Mizali. ");
INSERT INTO yom_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Kiza kieta tela kiza kinkaka mu khumbulu yi minlangu mu zithadi ziaku. Mayo maku mamo mafioti ayi manneni ma mbukimini. ");
INSERT INTO yom_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Mu muini, Yave wumfidisanga luzolo luandi Mu builu nkungꞌandi widi va minu lusambulu kuidi Nzambi yi luzingu luama. ");
INSERT INTO yom_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Ndintuba kuidi Nzambi, ditadi diama di ngolo : “Bila mbi wunzimbikini e ? Bila mbi mfueti diatilanga mu phasi, yamusungu kuidi mbeni e ?” ");
INSERT INTO yom_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Mimvesi miama milmbo moni phasi yi lufua ; batu bobo bandendi bu balembo mfingi bu beti ku khambanga mu lumbu kimvimba ti : “Kuevi kuidi Nzambi aku e ?” ");
INSERT INTO yom_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Bila mbi vongidi bobo, a muelꞌama e ? Bila mbi wulembo niongina mu khati ama e ? Tula diana diaku mu Nzambi bila ndiela kunzitisa diaka ; niandi Mvulusi ama ayi Nzambi ama. ");
INSERT INTO yom_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Wundungisa, a Nzambi, ayi wunzonzila mu mambu mama kuidi dikanda di batu dinkambu kinzikanga mambu maku. Wukhula mu batu ba luvunu ayi batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Ngeyo Nzambi, ngeyo zingolo ziama. Bila mbi wundozidi e ? Bila mbi mfueti diatilanga mu phasi, yamusungu kuidi mbeni e ? ");
INSERT INTO yom_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Fidisa kiezila ayi Kiedika kiaku ; bila bindiatisa, bika bindata ku mongo aku wunlongo ayi nate ku buangu kioki weti vuanda. ");
INSERT INTO yom_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Buna ndiela kuenda ku ntala wu Nzambi ; kuidi Nzambi khini ama ayi yangalala kuama. Buna ndiela kunzitisa mu ngitala, A Nzambi, Nzambi ama. ");
INSERT INTO yom_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Bila mbi vongidi bobo, a muelꞌala e ? Bila mbi wulembo niongina mu khati ama e ? Tula diana diaku mu Nzambi bila ndiela kunzitisa diaka, Mvulusi ama ayi Nzambi ama. ");
INSERT INTO yom_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Nkunga bana ba babakala ba Kole kuidi pfumu minyimbidi. Beto tuwilu mu matu meto, a Nzambi madise meto batukamba mambu momo wuvanga mu bilumbu biawu ; mu bilumbu bivioka ");
INSERT INTO yom_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Mu koko kuaku, ngeyo wukuka makanda ; ayi ngeyo wuvingisa madise meto ; ngeyo wukosikisa batu ayi ngeyo wufunisa mase meto. ");
INSERT INTO yom_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Kadi sia ti mu diambu di sabala kiawu bazionina tsi ; Voti kadi sia ti koko kuawu kuawu kuba natina ndungunu ; koko kuaku ku lubakala, koko kuaku ayi kiezila ki zizi kiaku bila ngeyo wuba zola. ");
INSERT INTO yom_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Ngeyo ntinu ama ayi Nzambi ama ; ngeyo wuzenga ndungunu mu diambu di Yakobi. ");
INSERT INTO yom_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Mu diambu diaku, tuela vutula bambeni zieto ku mbusa. Mu diambu di dizina diaku, tuela diatikisa bobo beti kutulenda. ");
INSERT INTO yom_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Nditulanga ko diana diama mu mbasꞌama ayi sabala kiama kilendi ku ndatina ndungunu ko. ");
INSERT INTO yom_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Vayi ngeyo weti kutuvana ndungunu mu bambeni zieto ; ngeyo wumfuisanga tsoni bobo bakutulendanga. ");
INSERT INTO yom_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Mu Nzambi beto tueti kukiniemisanga mu lumbu kimvimba ayi tuela zitisa dizina diaku mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Vayi buabu ngeyo wutuloza ayi wutukuludi ; ngeyo wutotukanga diaka ko ayi nkangu eto wu masodi. ");
INSERT INTO yom_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Ngeyo wutuvutula ku mbusa va ntuala bambeni zieto ; ayi bobo beti kutulenda bazionini bima bieto. ");
INSERT INTO yom_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Ngeyo wutuyekula batudia banga mamemi. Wutusasikisa va khatitsika makanda. ");
INSERT INTO yom_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Ngeyo wusumbisa batu baku mu thalu yi phamba, wukadi kuba bakila ndandu bu wuba sumbisa. ");
INSERT INTO yom_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Ngeyo wutukitula kima ki tsoni kuidi bafikimini yeto, kisekununu ayi kitsevolo kuidi bawu batuzungididi. ");
INSERT INTO yom_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Ngeyo wutukitula zinongo va khatitsika makanda ; batu balembo kutunikunina mintu miawu. ");
INSERT INTO yom_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Mvuezolo ama widi ku ntualꞌama mu lumbu kimvimba ; ayi tsoni yilembo monika va zizi kiama ; ");
INSERT INTO yom_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","mu diambu di bifingu bi bobo balembo ndenzi ayi balembo mvuezi, mu diambu di mbeni, mutu wumvutulanga landi. ");
INSERT INTO yom_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Mamoso momo matubuila vayi beto tusia kuzimbakana ; Voti tusia ba luvunu mu Nguizani aku ko. ");
INSERT INTO yom_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Mintima mieto misia baluka ko ; Malu meto masia vengama ko mu nsolo aku, ");
INSERT INTO yom_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","vayi wutukosikisa ayi wutukitula suamunu ki memvo ; ayi wutufuka ku tsi dibulu di tombi. ");
INSERT INTO yom_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Enati beto tuzimbakana dizina di Nzambi eto, voti tunonuna mioko mieto kuidi nzambi yi nzenza, ");
INSERT INTO yom_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","buna Nzambi kalendi bakula ko e ? Bila niandi zebi mansueki ma ntima. ");
INSERT INTO yom_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Vayi mu diambu diaku tueti dengana lufua mu lumbu kimvimba, ayi balembo tumoni banga mamemi mafueti kuenda ku vondo. ");
INSERT INTO yom_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Kotuka, a Yave ! Bila mbi wulembo lekila e ? Kotuka kuaku kadi tumbu ku tuyekula mvimba ! ");
INSERT INTO yom_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Bila mbi wulembo suekila zizi kiaku e ? Ayi bila mbi wulembo zimbikinina ziphasi zieto ayi yamusu kueto e ? ");
INSERT INTO yom_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Tunatu ku mbungi-mbungi zinitu zieto zinama mu ntoto. ");
INSERT INTO yom_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Telama, wutusadisa wutukula mu diambu di luzolo luaku lu ngolo. ");
INSERT INTO yom_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Nkunga bana ba babakala ba Kole kuidi pfumu minyimbidi. Nkunga wu luzolo bayimbidila mu “LISI”. Ntimꞌama wulembo fundumuka mu mambu ma kitoko. Ndiela samuna mambu mama mu diambu di ntinu. Ludimi luama luidi lapi yi nsoniki wukiedika. ");
INSERT INTO yom_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Ngeyo viokidi batu mu kitoko ; bididi biaku bidukudulu mafuta ma nlemvo ; diawu Nzambi kasakumunina mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Kanga sabala kiaku mu luketo luaku, ngeyo kinuani ki ngolo, vuata ngeyo veka kiezila ayi nzitusu. ");
INSERT INTO yom_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Mu nzitusu aku, telama va ntuala mu ndungunu mu diambu di kakidila kiedika, kukikulula ayi busonga. Bika koko kuaku ku lubakala kumonisa mavanga ma tsisi. ");
INSERT INTO yom_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Bika zitsoto ziaku zidi meno, zitobula mintima mi bambeni zi ntinu ; bika makanda mabua ku tsi tambi biaku. ");
INSERT INTO yom_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Kundu kiaku ki kitinu, a Nzambi kiela zingila mu zithangu zioso Nkawꞌaku wu busonga wela ba nkawa wu Kitinu kiaku. ");
INSERT INTO yom_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Ngeyo wunzolanga busonga ayi wunlendanga mambimbi. Diawu Nzambi, Nzambi aku, wutula va mbata batu bandiatanga yaku bu kavinda mafuta ma khini. ");
INSERT INTO yom_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Zilobi ziaku zioso zidi tsudi malasi ma mile, ayi alowesi ayi kase ; mu nzo yoyi yitungulu mu meno ma nzawu miziki mi zitsinga mikumonisa khini. ");
INSERT INTO yom_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Bana ba baketo ba ntinu badi va khati baketo baku ba luvalu. Va koko kuaku ku lubakala, vadi Ntinu wu nketo mu nolo yi Ofili. ");
INSERT INTO yom_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Wa, o muana ndumba, tala ayi tamba dikutu : zimbakana batu baku ayi nzo dise diaku. ");
INSERT INTO yom_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Ntinu wulembo moni khini mu kitoko kiaku kinzika bila niandi Pfumu aku ; ");
INSERT INTO yom_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Muana ndumba wu Tile, wela nata dikaba ; batu balutidi kimvuama bela tomba mona mamboti maku. ");
INSERT INTO yom_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Nkembo woso widi kuidi muana ntinu wu nketo mu khati vinga kiandi lobi andi yitungulu mu nolo. ");
INSERT INTO yom_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Mu minlele midi malenda ma kitoko ; bela kunnata kuidi ntinu. Zindumba ziozi zizebi ko zinitu zi babakala ziozi zindiatanga yandi zilembo kunlandakana. Ayi bela natu kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Bela natu mu khini ayi mu mayangani. Bela kota mu nzo ntinu. ");
INSERT INTO yom_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Bana baku ba babakala bela bonga buangu ki madise maku ; ngeyo wela ku babieka bilandi bi ntinu mu tsi yi mvimba. ");
INSERT INTO yom_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Minu ndiela sia ti batebukilanga moyo mu zitsungi zioso. Diawu makanda mela kuzitisa mu zithangu zioso ayi mu mvu ka mvu. ");
INSERT INTO yom_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Nkunga bana ba babakala ba Kole kuidi pfumu minyimbidi ; bayimbidila mu mbembo yi fioti yi bana babaketo. Nzambi niandi suamunu kieto ayi zingolo zieto ; niandi nsadisi wu zithangu zioso mu ziphasi. ");
INSERT INTO yom_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Diawu tulendi mona tsisi ko ka diambu ko ntoto wulenda buka ayi miongo milenda bulumuka ku tsi mbu, ");
INSERT INTO yom_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","ka diambu ko, minlangu beni milembo dumi, milembo fundumuka ayi miongo miela nikuka mu diambu di makhesi mawu. ");
INSERT INTO yom_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Vayi vadi nlangu wumosi wunneni wubeki mimvuila mieti monisa divula di Nzambi khini ; buangu kiviatukidi nlongo vovo veti vuanda Nzambi yizangama. ");
INSERT INTO yom_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Nzambi widi va khatitsikꞌandi ; kalendi bua ko. Nzambi wela kusadisa tona mu khiesa yi nsuka. ");
INSERT INTO yom_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Makanda malembo tudi divunzi, bipfumu bilembo bua. Wuwakikisa mbembo andi ; ntoto wusiuta. ");
INSERT INTO yom_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yave nkua ngolo yoso widi yeto ; Nzambi yi Yakobi niandi suamunu kieto ki ngolo. ");
INSERT INTO yom_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Yizanu ayi lutala mavanga ma Yave, maniongo momo kanata va ntoto. ");
INSERT INTO yom_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Niandi wumanisa zimvita nate ku sukisina ntoto wukelula mimbasa ayi wubukuna madionga ; wuyoka ku mbazu minkaku. ");
INSERT INTO yom_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Luba dio sui ayi luzaba ti minu Nzambi. Ndiela yayusu muidi makanda, ndiela yayisa va ntoto. ");
INSERT INTO yom_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yave nkua ngolo yoso widi yeto. Nzambi yi Yakobi niandi suamunu kieto ki ngolo. ");
INSERT INTO yom_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Nkunga bana ba babakala ba Kole kuidi pfumu minyimbidi. Lusika zitsiaki, beno makanda moso. Luyamikina kuidi Nzambi mu khini, ");
INSERT INTO yom_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Tala phila Yave yizangama kadidi tsisi ! Niandi ntinu wunneni va mbata ntoto wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Wutula makanda ku tsi buvika bueto, batu ku tsi malu meto. ");
INSERT INTO yom_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Wutusobudila kiuka ; luniemo lu Yakobi ; mutu wu kazola. ");
INSERT INTO yom_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Nzambi wukuma va khatitsika yamikina ku khini Yave wukuma va khatitsika biyoko bi tulumbeta. ");
INSERT INTO yom_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Luyimbila minzitusu kuidi Nzambi Luyimbila minzitusu ; Luyimbila minzitusu kuidi Nzambi eto, luyimbila minzitusu. ");
INSERT INTO yom_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Bila Nzambi niandi ntinu wu ntoto wumvimba ; Lunyimbidila nkunga wu nzitusu. ");
INSERT INTO yom_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Nzambi weti yadila makanda moso. Nzambi vuendi va kundu kiandi kinlongo. ");
INSERT INTO yom_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Batu banneni ba makanda bakutikini banga batu ba Nzambi yi Abalahami bila Nzambi niandi vuidi mintinu mi ntoto. Niandi wuyayusu ngolo. ");
INSERT INTO yom_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Nkunga bana ba babakala ba Kole. Yave widi wunneni. Ayi lutidi fuana mu tambula minzitusu mu divula di Nzambi eto, mongo andi wunlongo. ");
INSERT INTO yom_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Widi wu kitoko mu nangama kuandi, khini yi ntoto wumvimba. Mongo wu Sioni widi banga zitsongi zilutisi nangama zi Zafoni, divula di ntinu wunneni. ");
INSERT INTO yom_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Nzambi widi mu zinzo zi divula beni wukimonisa niandi veka mu ba suamunu kiandi ki ngolo. ");
INSERT INTO yom_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Mu thangu mintinu mifubikisa zingolo, mu thangu midiatila va kimosi. ");
INSERT INTO yom_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Mimona ayi misimina ; mitina mu tsisi. ");
INSERT INTO yom_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Lukhuku luba buila vana ziphasi ziba mona zidedikini banga mianga mieti mona nketo weka buta. ");
INSERT INTO yom_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Ngeyo wuba bunga banga masuwa ma Talisi mabungu mu phemo yeti totukila ku Esite. ");
INSERT INTO yom_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Banga bu tuwila, buawu bobo tumuenini mu divula di Yave, nkua ngolo yoso ; mu divula di Nzambi eto : Nzambi wela kuvana luvovomo mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Mu khati nzo aku, a Nzambi, tueti yindula mu diambu di luzolo luaku lu ngolo. ");
INSERT INTO yom_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Banga dizina diaku, a Nzambi ! Nzitusu aku widi nate mu sukisina ntoto. Koko kuaku ku lubakala kuwedi busonga. ");
INSERT INTO yom_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Mongo wu Sioni wulembo moni khini ; mala ma Yuda malembo yangalala mu diambu di zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Ludiata muyenda Sioni ayi lunzungidila, ayi lutanga zinzo ziandi zizangama. ");
INSERT INTO yom_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Lutala bumboti ziphangu ziandi ; Lufiongunina zinzo ziandi muingi luba samunina kuidi tsungi yinkuiza. ");
INSERT INTO yom_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Bila Nzambi yayi niandi Nzambi eto mu thangu yi kayimani ayi mu zithangu zioso. Niandi wela ba ntuadisi eto nate ku tsuka. ");
INSERT INTO yom_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Nkunga bana ba babakala ba Kole kuidi pfumu minyimbidi. Luwa diambu diadi beno batu boso : Ludimba beno batu boso lunzinganga va nza yayi, ");
INSERT INTO yom_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","batu baphamba ayi batu banneni, zimvuama ayi minsukami. ");
INSERT INTO yom_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Munuꞌama wela tuba mambu ma nduenga, mamo mantotukila mu ntimꞌama mela vana tsudukulu. ");
INSERT INTO yom_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Ndiela balula dikutu diama mu diambu di wa zingana, mu ngitala, ndiela sudikisila nongoꞌama. ");
INSERT INTO yom_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Bila mbi mfueti monina tsisi bilumbu bi mbimbi bu bizidi, mu thangu mambimbi ma bobo beti vuna batu manzungididi e ? ");
INSERT INTO yom_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Bantulanga diana diawu mu bima biawu ayi beti kukiniemisa mu kimvuama kiawu kiwombo. ");
INSERT INTO yom_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Mutu kalendi baka bu kuidila ko, luzingu lu mutu wunkaka, voti futa thalu yi khudulu andi kuidi Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Thalu yi khudulu yi luzingu yibeki luvalu lunneni, kuisi ko kadi mfutu wulenda dedakana, ");
INSERT INTO yom_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","mu diambu kazinga mu zithangu zioso ayi kabika bola. ");
INSERT INTO yom_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Bila babo beti mona ti bankua nduenga balembo fua ; bivungisi ayi bivulu balembo fua mamvawu, ayi balembo biki bima biawu kuidi batu bankaka. ");
INSERT INTO yom_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Biziami biawu biela banga zinzo ziawu mu zithangu zioso ; bibuangu biawu biobi beta vuanda mu tsungi ka tsungi. Beti vana mazina mawu mu mintoto miawu bu bafuidi. ");
INSERT INTO yom_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Vayi mutu, ka diambu ko beki kimvuama kazinganga buwombo ko. Dedikini banga bibulu bieti fua. ");
INSERT INTO yom_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Mawu mama mambu meti buila batu bobo beti tula diana mu bawu veka ayi bobo beti kuba landakana, bobo beti kikina mambu beti tuba. ");
INSERT INTO yom_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Banga nkangu wu mamemi, bakubuku mu diambu di tsi bafua ; lufua luela kuba dia. Mutu widi ntima wululama wela kuba yadila va nsuka buphila buawu buela bola ku tsi bafua, thama ayi zinzo ziawu zi kipfumu. ");
INSERT INTO yom_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Vayi Nzambi wela kula luzingu luama mu lulendo lu tsi bafua, bukiedika wela kuthambula mu diambu diandi veka. ");
INSERT INTO yom_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Kadi mona tsisi mutu bu kalembo baki kimvuama kiezila ki nzo andi bu kilembo buelama. ");
INSERT INTO yom_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Bila kalendi nata kadi kima ko mu thangu kela fua. Kiezila kiandi kilendi kuluka yandi ko. ");
INSERT INTO yom_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Bu kabedi moyo wukimona mutu wu lusakumunu ayi batu beti kuzitisa bu weti mona lusakumunu bu kabedi monanga mamboti. ");
INSERT INTO yom_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Wela kuenda bata tsungi yi madise mandi ; bobo balendi buela mona kiezila ko ki luzingu. ");
INSERT INTO yom_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Mutu widi kimvuama ayi kambulu diela widi banga bulu kieti fua. ");
INSERT INTO yom_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Nkunga Asafi. Nkua lulendo ; Nzambi, Yave tubidi ayi kutikisidi ntoto tonina ku ntotukilanga thangu nate buangu keti diamina. ");
INSERT INTO yom_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Tona ku Sioni, wufuana mu kitoko ; Nzambi weti kienzuka. ");
INSERT INTO yom_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Nzambi eto wulembo yizi, ayi kalendi ba dio sui ko ; mbazu yilembo zinisa ku ntualꞌandi ayi vuka kingolo kinzungididi. ");
INSERT INTO yom_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Niandi wunkutikisanga diyilu ku yilu ayi ntoto mu diambu kasambisa batu bandi : ");
INSERT INTO yom_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Lukhutikisila batu bama bobo ndibieka, bobo bavanga yama Nguizani mu nzila yi makaba. ");
INSERT INTO yom_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Ayi diyilu dilembo yamikisa busonga buandi, bila Nzambi niandi veka zuzi. ");
INSERT INTO yom_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Luwa, beno batu bama ; Ndiela tuba : A Iseli, ayi ndieka ntelama kimbangi mu diambu diaku : Minu ndidi Nzambi ; Nzambi aku. ");
INSERT INTO yom_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ndilendi kutemina ko mu diambu di makaba maku voti makaba maku mayoko ; momo madi thangu ka thangu va ntualꞌama, ");
INSERT INTO yom_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Ndisi mfunu wu ngombi yi mbakala yi luphangu luaku ko, voti zikhombo zi ziphaka ziaku ko. ");
INSERT INTO yom_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Bila minu phuidi bibulu bioso bi nsitu ayi bibulu bioso binkalanga mu miongo. ");
INSERT INTO yom_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Nzebi zinuni zioso zi miongo, ayi minu phuidi bivangu bidi mu zitsola, ");
INSERT INTO yom_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Enati nzala ndimona, buna ndilendi kukamba buawu ko bila minu phuidi nza ayi bibioso bidi muawu. ");
INSERT INTO yom_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Minu minsuni mi zingombi zimbakala ndiela dia voti ndieka nua menga ma zikhombo e ? ");
INSERT INTO yom_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Tambika makaba ma phutudulu matondo kuidi Nzambi ayi dukisanga zitsila ziaku kuidi Nzambi yizangama. ");
INSERT INTO yom_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ayi wuthela mu lumbu ki ziphasi, ndiela ku kula ayi ngeyo wela kunzitisa. ");
INSERT INTO yom_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Vayi Nzambi wulembo kambi mutu wumbimbi : “Mu minsua mbi wulembo tangilanga mina miama e ? Voti bila mbi weti natina Nguizani yama mu bididi biaku e ? ");
INSERT INTO yom_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Ngeyo wunlendanga zindongi ziama ayi wuloza mambu mama ku manima maku. ");
INSERT INTO yom_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Ngeyo bu mueni muivi, buna weti bundana yandi. Bosi ngeyo wumvuandanga va kimosi ayi mitsuza. ");
INSERT INTO yom_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Wunsadilanga munuꞌaku mu diambu di mambimbi, ayi wunsadilanga ludimi luaku mu diambu di luvunu. ");
INSERT INTO yom_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Ngeyo wuntubidilanga khombꞌaku ku ndambu mu zithangu zioso ; Ngeyo wuvuezanga muana bakala wubuta ngudi aku. ");
INSERT INTO yom_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Mambu mana mawu wuvanga vayi ndiba dio sui. Ngeyo wubanzila ti minu ndedikini banga ngeyo Vayi minu ndiela kutubidila ayi kufunda va zizi kiaku ku ntuala meso maku. ");
INSERT INTO yom_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Luyindula diambu diadi : beno lunzimbakananga Nzambi ; nganu ndilenda kulukanzuna mu bitini, ayi mutu wulenda kula kalendi monika ko. ");
INSERT INTO yom_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Woso wuntambikanga makaba ma phutudulu matondo buna wukunzitisa, ayi weti kubika nzila muingi ndimmonisa phulusu yi Nzambi.” ");
INSERT INTO yom_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Nkunga Davidi kuidi pfumu minyimbidi ; mu thangu mbikuidi Natani kayiza kuidi Davidi mu kitsuza kiandi ayi Betaseba. A Nzambi, wumboni kiadi boso buididi luzolo luaku lu ngolo ; boso buididi kiadi kiaku kinneni, kubula zinzimbala ziama. ");
INSERT INTO yom_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Sukula mambimbi mama moso. Ayi wuphedisa mu disumu diama. ");
INSERT INTO yom_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Bila nzebi zinzimbala ziama ayi disumu diama didi ku ntualꞌama mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Kuidi ngeyo, veka kaka ndivodidi masumu ; ayi ndivengi mambimbi va meso maku ; muingi wumonika wusonga mu thangu wutuba ayi wukambulu zimbala mu thangu wunsambisa ");
INSERT INTO yom_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Bukiedika, minu ndidi nkua masumu tona mu mbutukulu ; nkua masumu tona thangu ngudi ama kabaka buemba buama. ");
INSERT INTO yom_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Bukiedika ngeyo tidi ti kiedika kiba mu khati ku nitu. Wundonga nduenga mu khati yi ntimꞌama ");
INSERT INTO yom_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Wuphedisa mu isopi buna ma ndivedila ; wutsukula buna ndiela ba wuphembi viokila mvula yi matadi ma phembi ; ");
INSERT INTO yom_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Bika ndimona khini ayi ndiyangalala Bika mimvesi miomi wukosikisa mi yangalala. ");
INSERT INTO yom_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Sueka zizi kiaku va ntuala masumu mama ayi kubula mbimbi ama yoso. ");
INSERT INTO yom_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Vanga mu minu ntima wuvedila, a Nzambi ayi buela kitula mu minu pheve yimona ayi yikinda. ");
INSERT INTO yom_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Kadi kukhuka va ntuala zizi kiaku ; kadi botula pheve aku yinlongo mu minu. ");
INSERT INTO yom_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Wuphutudila khini yi phulusu aku ayi bika wuphana Pheve yi luzolo lu mboti muingi yikhindisa. ");
INSERT INTO yom_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Buna ndiela longa zinzila ziaku kuidi bobo beti vanga zinzimbala, ayi bankua masumu bela vutuka kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Wuphukisa mu nzimbala yi menga, a Nzambi Nzambi yoyi yeti kuphukisa, ayi ludimi luama luela yimbidila busonga buaku. ");
INSERT INTO yom_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","A Yave zibula bididi biama, ayi munuꞌama wela yamikisa nzitusu aku. ");
INSERT INTO yom_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Ngeyo wuzolanga ko makaba, bila enati buawu ; nganu ndinatina mawu ; ayi wumonanga khini ko mu makaba mayoko. ");
INSERT INTO yom_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Makaba ma Nzambi madi pheve yi kosakana ntima wukosakana ayi wu kiadi a Nzambi, wulendi ku milenza ko. ");
INSERT INTO yom_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Mu diambu di mamboti maku, bika wuvangila Sioni mamboti, tunga diaka bibaka bi Yelusalemi. ");
INSERT INTO yom_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Kuna kuela ba makaba ma busonga, makaba mayoko mamvimba meti kumonisa khini. Buna zingombi zimbakala ziela tambuku va ntalꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Nkunga Davidi kuidi pfumu minyimbidi mu thangu Dowengi muisi Edomi, kayiza vumbudila Sawuli kipholo ti Davidi wuyenda ku nzo Ahimeleki. Bila mbi wulembo kukiniemisina mu diambu di mambimbi, ngeyo nkua ngolo e ? Bila mbi wulembo kukiniemisina mu lumbu kimvimba ngeyo kambulu nzitusu va meso ma Nzambi e ? ");
INSERT INTO yom_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Ludimi luaku lunyindulanga mambu ma mbivusu ; ludedikini banga lezuale yidi meno ma ngolo. Ngeyo wunsadilanga luvunu. ");
INSERT INTO yom_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ngeyo lutidi zola mambu mambimbi viokila mamboti ; luvunu viokila mambu ma kiedika. ");
INSERT INTO yom_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Ngeyo lutidi zola mambu moso momo mambivisanga, ngeyo ludimi lu luvunu. ");
INSERT INTO yom_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Bukiedika Nzambi wela kubuisa mu mbivusu yika yilendi suka ko. Wela kubuila ayi wela kukanzuna mu nzoꞌaku yi ngoto. Wela kuvuza va ntoto wu batu badi moyo. ");
INSERT INTO yom_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Batu basonga bela mona ayi bela mona tsisi bela kunseva bu bela tuba : ");
INSERT INTO yom_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Vava vadi mutu wukambulu kitula Nzambi zingolo ziandi Vayi wubedi tulanga diana diandi mu kimvuama kiandi kiwombo ayi wukitukidi mutu wu ngolo mu bunganga bankaka.” ");
INSERT INTO yom_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Vayi minu ndidi banga nti wu olive, wuwedi meza ma nlangu mu nzo yi Nzambi. Ndintulanga diana diama mu luzolo mu ngolo lu Nzambi mu zithangu zioso ayi mu mimvu mioso. ");
INSERT INTO yom_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Ndiela kuzitisa mu zithangu zioso mu diambu di momo wuvanga ; mu dizina diaku ndiela tula diana bila didi dimboti, ndiela kuzitisa va meso ma banlongo. ");
INSERT INTO yom_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Nkunga Davidi kuidi pfumu minyimbidi ; kayimbidila mu flute. Nkua buvulu wuntubanga mu ntimꞌandi : “kuisiko Nzambi.” Bakibivisidi, zinzila ziawu zidi zimbimbi ; kuisiko mutu wumvanganga mamboti. ");
INSERT INTO yom_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Nzambi, wulembo tadi tona ku Diyilu bana ba batu mu diambu di tala kani valenda ba batu balenda sudika ; bobo bantomba Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Batu boso bamana zimbala, bamana kibivisa va kimosi. Kuisiko kadi wumosi wumvanganga mamboti, kadi kuandi wumosi. ");
INSERT INTO yom_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Bobo bamvanganga mambimbi, basudikanga ko e ? Bawu balembo dia batu bama banga bu beti dila dipha ; ayi batelanga Nzambi ko. ");
INSERT INTO yom_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Kuna batitila mu diambu di tsisi va buangu ki kondolo bila kimonina tsisi ; Nzambi wukosikisa mimvesi mi batu bobo banuanisa ; ngeyo wuba fuisa tsoni bila Nzambi wuba lenza. ");
INSERT INTO yom_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","A, enati phulusu yi Iseli yitotukila ku Sioni ! Mu thangu Nzambi kela vutula kiuka ki batu bandi ; bika Yakobi kamona khini ayi Iseli kayangalala. ");
INSERT INTO yom_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Nkunga Davidi kuidi pfumu minyimbidi kayimbidila mu mu thangu basi Zifi bayiza kamba Sawuli ti : “Davidi kuidi beto” kasuamini. Wuphukisa, Nzambi ama, mu dizina diaku ; wundungisa mu lulendo luaku. ");
INSERT INTO yom_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Wa lusambulu luama, a Nzambi. Dimba mambu ma munuꞌama. ");
INSERT INTO yom_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Zinzenza zilembo nduanisa ayi batu ba tsita balembo tombi luzingu luama. Batu bankambu kinzikanga Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Bukiedika, Nzambi niandi nsadisi ama. Yave niandi wukukhindisanga. ");
INSERT INTO yom_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Bika mambimbi mabuila bobo beti kuphueza ; Mu kikhuikizi kiaku, wuba bunga. ");
INSERT INTO yom_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Ndiela kutambikanga makaba mu ntima wu luzolo ; ndiela zitisa dizina diaku, a Yave. Bila didi dimboti. ");
INSERT INTO yom_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Bila niandi wukhula mu ziphasi ziama zioso ayi meso mama mamona mbedoso yi bobo beti kundenda. ");
INSERT INTO yom_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Nkunga Davidi kuidi pfumu minyimbidi, kayimbidila. Dimba lusambulu luama, a Nzambi ; ayi kadi zimbakana mambu mama. ");
INSERT INTO yom_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Wunguila ayi wuphani mvutu ; mayindu mama malembo mbonisa phasi ayi ndilembo sambi ; ");
INSERT INTO yom_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","mu diambu di mbembo yi mbeni ; mu diambu di yamusu ku mutu wumbimbi bila minu beti yekikilanga ziphasi bila balembo mfingi mu nganzi awu. ");
INSERT INTO yom_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Ntimꞌama widi mu maniongo mu minu ; ayi boma bu lufua lu mbuididi. ");
INSERT INTO yom_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Tsisi ayi lukhuku bieka mu minu ayi boma bu ngolo bumbuididi. ");
INSERT INTO yom_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Buna ndituba : “Enati ndiba ayi mavavi ma dibembi nganu ndieka tumbu dumuka ayi ba mu luvundulu. ");
INSERT INTO yom_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Nganu, ndiela tinina ku thama, ayi vuanda ku dikanga. ");
INSERT INTO yom_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Ndiela tina nsualu mu tomba suamunu ku buangu kikambulu phemo yingolo ayi vuka kingolo.” ");
INSERT INTO yom_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Kotisa batu bambimbi mu divuda, A Yawe ayi vunzikisa mambu mawu bantuba. Bila ndilembo moni makhemi ayi ziphaka mu divula. ");
INSERT INTO yom_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Muini ayi builu, makhemi ayi ziphaka bizungidila bibaka bi divula ; diela dimbimbi ayi kambu dukisa zitsila bieka mu khati divula. ");
INSERT INTO yom_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Mbivusu kiawu kisalu kieka mu khati divula ; khuamusu ayi luvunu bikadi botuka mu zinzila zi divula. ");
INSERT INTO yom_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Enati mbeni wumfingidi nganu ndikimba moyo ; enati mutu wukundendanga niandi weti kukiniemisa va ntualꞌama nganu ndisuama kuama va ntualꞌama. ");
INSERT INTO yom_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Vayi ngeyo, mutu banga minu wundiatanga yama va kimosi ; nkundi ama wu kuikama ; ");
INSERT INTO yom_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","mutu wowo wubedi kalanga yama mu khini ; wubedi kibanga va kimosi ayi nkangu wu batu ku Nzo Nzambi ! ");
INSERT INTO yom_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Bika lufua lu bibuila bambeni ziama mu kinzimbukila ayi bika bakuluka bamoyo ku tsi bafua ! Bila mambimbi mabakudi buangu va khatitsikꞌawa, ");
INSERT INTO yom_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Mbadi minu, ndintela Nzambi, ayi Yave wuphukisidi. ");
INSERT INTO yom_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Yiba nsuka, midi ayi masika, Ndieti yamikina mu ziphasi ; ayi weti wa mbembo ama. ");
INSERT INTO yom_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Wukukhulanga wumbimba, mu kambu sumbula mu mvita yi banduanisa ka diambu ko bawombo banduanisa. ");
INSERT INTO yom_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Nzambi wunyadila va kundu kiandi ki luyalu mu zithangu zioso wela kuba wa ayi wela kuba monisa phasi ; batu bobo balendi balula zinzila ziawu ko ayi bakinzikanga Nzambi ko. ");
INSERT INTO yom_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Mutu wundiatanga yama wulembo nuanisa bakundi bandi wubundula Nguizani andi. ");
INSERT INTO yom_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Mambu mandi ndelo madi banga dibela muaki mvita yidi mu ntimꞌandi ; Mambu mandi madi malebila viokila mafuta muaki madi banga bisabala bikubimini mu vonda. ");
INSERT INTO yom_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Yekula bizitu biaku kuidi Yave, niandi wela kukindisa ; kalendi tala ko ti mutu wusonga kabua. ");
INSERT INTO yom_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Vayi ngeyo Nzambi, wela buisa batu bambimbi ; mintengudi mi menga ayi bankua livunu bela dukisa ko ndambu yi bilumbu biawu ; vayi minu diana diama didi mu ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Nkunga Davidi kuidi pfumu minyimbidi ; kayimbidila mu “Dibembi di minti midi ku zitsi zi thama” mu thangu basi Filisti bankanga mu tsi Ngati. Wumboni kiadi, A Nzambi bila batu balembo ndandakana mu kingolo ; mu lumbu kimvimba ; balembo luti buela kunduanisa ");
INSERT INTO yom_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Mimvuezi miama milembo ndandakani mu lumbu kimvimba Bawombo balembo nduanisa mu luniemo luawu. ");
INSERT INTO yom_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Mu thangu ndimmona tsisi ; ndiela tula diana diama mu ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Mu Nzambi, mutu vuidi mambu ndieti zitisa Mu Nzambi ndieti tula diana ; ndilendi mona tsisi ko, Mutu wowo wumfuanga, mbi kalenda kuphanga e ? ");
INSERT INTO yom_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Mu lumbu kimvimba, beti balula mambu mama ; balembo yindula mu zithangu zioso mu kumbonisa phasi. ");
INSERT INTO yom_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Balembo kutakana ; balembo suami balembo fiongunina zithambi ziama, mu nsualu-nsualu batidi bonga luzingu luama. ");
INSERT INTO yom_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Balendi vukila kani mu kipholo kiawu kimosi ko e ? Mu nganzi aku, a Nzambi, bedisa makanda ");
INSERT INTO yom_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Sonika maniongo mama Lunda matsuela mama mu khutu aku. Masi ko mu lutangu luaku e ? ");
INSERT INTO yom_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Buna bambeni ziela vutikisa ku mbusa mu thangu ndiela tela mu tomba lusadusu. Mu diadi diela zabila ti Nzambi widi ku ndambuꞌama. ");
INSERT INTO yom_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Mu Nzambi mutu vuidi mambu ndieti zitisa Mu Yave, mutu vuidi mambu ndieti zitisa. ");
INSERT INTO yom_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Mu Nzambi nditula diana diama, ndilendi mona tsisi ko ; mutu mbi kalenda ku phanga e ? ");
INSERT INTO yom_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Ndidi ku tsi zindefi ziaku, a Nzambi. Ndiela tambika makaba ma phutudulu matondo kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Bila ngeyo wukhula mu lufua, ayi malu mama mu diambu mabika bumina thutu muingi ndidiatilanga va ntuala Nzambi, mu kiezila ki luzingu. ");
INSERT INTO yom_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Nkunga Davidi kuidi pfumu minyimbidi “kadi vonda.” Mu thangu kasuamina mu nluka matadi Sawuli bu kaba kunkuka. Wumboni kiadi, a Nzambi, wumboni kiadi ! Bila muelꞌama wunsuaminanga mu ngeyo ndiela suamina ku kitsusula ki mavavi maku, nate mabienga mela mana vioka. ");
INSERT INTO yom_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Ndiela yamikina kuidi Nzambi yizangama ; kuidi Nzambi weti dukisa zikhanu ziandi kuidi minu. ");
INSERT INTO yom_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Weti fidisa tona ku diyilu ayi weti kuphukisa ; mu temina bobo beti kundandakana mu kingolo ; Nzambi weti fidisa luzolo luandi ayi kikhuikizi kiandi. ");
INSERT INTO yom_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Ndidi va khatitsika zikhosi ; ndidi wulambalala va khatitsika bibulu bindianga minsuni ; batu bobo meno mawu madi banga madionga mafioti ayi maneni ludimi luawu luidi sabala yisekoso ngolo. ");
INSERT INTO yom_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Yayusu kuaku, a Nzambi, ku yilu diyilu Bika nkembo aku wuba va ntoto wumvimba ! ");
INSERT INTO yom_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Batambila malu mama dikondi. Ndiba wukomvama mu ziphasi ; Bakaba dibulu dinnene mu nsolo ama : vayi bawu veka ba buidi muawu. ");
INSERT INTO yom_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Ntimꞌama widi wukinda a Nzambi ; ntimꞌama widi wukinda. Ndiela yimbila, ndiela bula miziki. ");
INSERT INTO yom_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Kotuka, muelꞌama ! Kotukanu, ngeyo Luti ayi ngitala ndiela kotula khiesa ki lumbu. ");
INSERT INTO yom_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Ndiela kuzitisa, a Yave, va khatitsika makanda. Ndiela kuyimbidila va khatitsika batu. ");
INSERT INTO yom_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Bila luzolo luaku luidi lunneni, luntulanga nate kuna diyilu, kikhuikizi kiaku kintulanga nate ku matuti. ");
INSERT INTO yom_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Yayusu kuaku, a Nzambi, ku yilu Diyilu. Bika nkemboꞌaku wuba va ntoto wumvimba ! ");
INSERT INTO yom_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Nkunga Davidi kuidi pfumu minyimbidi “kadi vonda”. A buevi, beno bapfumu, mu busonga lueti yolukilanga e ? Mu bufuana lueti sambisilanga batu e ? ");
INSERT INTO yom_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Nana ! Mu mintima mieno, lueti yindula makambulu masonga ayi mioko mieno milembo muangisa makhemi va ntoto. ");
INSERT INTO yom_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Tona mu mbutukulu, batu bambimbi beti zimbala ; tona mu vumu, ntu ngolo badi ayi bantubanga luvunu. ");
INSERT INTO yom_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Mitsa miawu midi banga mitsa mi nioka, banga kusa kizibikidi matu mandi ");
INSERT INTO yom_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","kinkambu wa mbembo yi batu bansakisanga zinioka ; mbembo yi ndoki yiyenda tsangu. ");
INSERT INTO yom_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Kola meno mu miunu miawu, a Nzambi ; vuza, a Yave, meno ma zikhosi. ");
INSERT INTO yom_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Bika balalakana banga maza ma nkumba ! Mu thangu bambansula mimbasa miawu, bika madionga mawu maba makambu tsongi ");
INSERT INTO yom_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","banga khodi yinsiuta bu yilembo diati ; banga muana wusuluka bika kabika mona thangu. ");
INSERT INTO yom_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Tuamina zinzungu zieno zimona diamu di zitsendi ziba zinlangu voti ziyuma, batu bambimbi bela kombulu. ");
INSERT INTO yom_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Basonga bela mona khini bu bela mona landi kioki bela kuba vutudila ; bela sukula malu mawu mu menga ma batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Batu bela tuba : “Bukiedika ; basonga bantambulanga mfutu mu kadika thangu. Bukiedika vadi Nzambi weti sambisa va ntoto.” ");
INSERT INTO yom_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Nkunga Davidi kuidi pfumu minyimbidi “Kadi vonda” mu thangu Sawuli kafidisa batu bazungidila nzo Davidi mu diambu bamvonda. Wukhula mu bambeni ziama, a Nzambi ; wukhebi mu diambu bobo bamfuemini ! ");
INSERT INTO yom_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Wukhudi mu mimvangi mi mambimbi ayi wuphukisa mu mintengudi mi menga. ");
INSERT INTO yom_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Tala phila balambididi mu kuphingila. Batu badi ngolo bandiendidi manenga bika sia ti mu diambu di nzimbala yama voti mu diambu di disumu diama, a Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Kadi mbimbi ndisia vanga ko vayi bakubimini mu kunduanisa kotuka mu kutsadisa tala phila ndikila. ");
INSERT INTO yom_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","A Yave, Nzambi nkua ngolo yoso, Nzambi yi Iseli, kotuka mu tumbudila makanda moso ; kadi mona kadi kiadi kuidi bobo beti vanga mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Bamvutukanga va masika, beti lola banga zimbua ; ayi beti zungidila divula. ");
INSERT INTO yom_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Tala, momo balembo luki mu miunu miawu. Bisabala bidi mu bididi biawu. Ayi balembo tubi : “Nani wulenda kutu wa e ?” ");
INSERT INTO yom_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Vayi ngeyo, a Yave, wulenda basevi ; wulembo sekinina makanda moso momo. ");
INSERT INTO yom_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","E ngolo ziama, kuidi ngeyo ndintala, ngeyo, e Nzambi, widi tinunu kiama ki ngolo. ");
INSERT INTO yom_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Nzambi ama, wukuphangilanga mamboti Nzambi ama yi luzolo wela kundengana ; Nzambi wela diata va ntuala ama ayi wela kumbonisa khini vadi bobo bakuthubidilanga. ");
INSERT INTO yom_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Vayi kadi kuba vonda, a Yave, nkaku eto, bila muna batu bama bela zimbakana. Mu lulendo luaku, baba mindiengidi ayi wuba buisi. ");
INSERT INTO yom_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Mu diambu di masumu ma muinu miawu, mu diambu di mambu ma bididi biawu, bika babuilama mu luniemo luawu. Mu diambu di zitsingulu ayi luvunu beti totula, ");
INSERT INTO yom_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Wuba lalikisa mu nganzi aku yi kikhesa ; wuba lalikisa muingi babika buela monika buna diela zabakana mu zitsuka zi ntoto ti Nzambi wunyadila Yakobi. ");
INSERT INTO yom_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Bamvutukanga va masika, beti lola banga zimbua, ayi beti zungidila divula. ");
INSERT INTO yom_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Bandiengilanga mu diambu di bidia, ayi enati bakadi yukuta, buna banyamikinanga. ");
INSERT INTO yom_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Vayi minu, ndiela yimbidila zingolo ziaku ; muna nsuka, ndiela yimbidila luzolo luaku bila ngeyo tinunu kiama kingolo ayi suamunu mu zithangu zi ziphasi. ");
INSERT INTO yom_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","A ngeyo zingolo ziama, ndinyimbila nzitusu mu diambu diaku ; ngeyo Nzambi, ngeyo tinunu kiama kingolo ; Nzambi ama yi luzolo. ");
INSERT INTO yom_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Nkunga Davidi kuidi pfumu minyimbidi, kayimbidila mu “Lisi” mu diambu di longisa mu thangu kanuana mvita ayi basi Sili ba Mesopotami ayi basi Sili ba Tsoba, ayi mu thangu Yowabi kavutuka ayi kabedisa kumi mafunda muadi ma basi Edomi mu ndimba Mungu. Ngeyo wutulozidi, a Nzambi ayi wutusasikisidi ; wufuema vayi bika buabu wutufuanisa ! ");
INSERT INTO yom_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Ngeyo wunikuni ntoto ayi ngeyo wuvasudi wawu ; londa miamvu miandi bila wulembo nikuka. ");
INSERT INTO yom_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Ngeyo wumonisini batu baku zithangu ziozi zikambulu diana wutuvana vinu kindiengisanga ntu. ");
INSERT INTO yom_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Vayi kuidi bobo beti kukinzika ngeyo wutelimisi dalapo mu diambu di batina va ntuala mimbasa. ");
INSERT INTO yom_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Wutuvukisa ayi wutusadisa mu koko kuaku ku lubakala muingi bobo weti zola bakulu. ");
INSERT INTO yom_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Nzambi wuyoluka tona ku buangu kiandi kinlongo : “mu ndungunu, ndiela vasa Sikemi, ndiela teza ndimba wu Sikoti ; ");
INSERT INTO yom_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Minu phuidi Ngaladi, ayi minu phuidi Manase ; Efalayimi yawu nkaku wu ntu ama, ayi Yuda nkawꞌama wu kipfumu ; ");
INSERT INTO yom_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Mowabi diawu dibola diodi ndieti yobidila ; va yilu Edoni ndiloza zisandales ziama ndiela yamikina mu diambu di ndungunu ama mu basi Filisti !” ");
INSERT INTO yom_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Nani wela kundata ku divula di ngolo e ? Nani wela kuthuadisa ku Edoni e ? ");
INSERT INTO yom_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Keti ngeyo, e Nzambi, ngeyo wutuloza e ? Ngeyo wutuloza ayi wunkambu buela totukanga ayi minkangu mi masodi meto. ");
INSERT INTO yom_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Wutuvana lusadusu va ntuala mbeni bila lusadusu lu mutu luidi luphamba. ");
INSERT INTO yom_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","A Nzambi, tuela nunga ayi wela kosikisa bambeni zieto. ");
INSERT INTO yom_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Nkunga Davidi kuidi pfumu minyimbidi ; kayimbidila mu lusinga. Wa yamikina kuama, e Nzambi tamba dikutu mulusambulu luama ");
INSERT INTO yom_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Tona kusukinina ntoto, ngeyo ndintela ; nditela bu ntimꞌama wumevonga ngolo ; wundati va mbata dibanga diodi dindutidi mu nangama. ");
INSERT INTO yom_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Bila ngeyo wuba suamunu kiama ; ngeyo wuba nzo yizangama ayi yingolo va ntuala mutu weti kundenda. ");
INSERT INTO yom_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Ndiela zingila mu nzo aku yi ngoto ; mu zithangu zioso ayi ndiela suamina ku tsi mavavi maku. ");
INSERT INTO yom_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Bila ngeyo, wuwa zikhanu ziama, e Nzambi ; ngeyo wuphana kiuka ki batu bobo beti kinzika dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Buela bilumbu bi luzingu lu ntinu, mimvu miandi mu diambu di zitsungu ziwombo. ");
INSERT INTO yom_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Bika kavuanda va kundu ki kipfumu va meso ma Nzambi mu zithangu zioso ; tula luzolo luaku ayi kikhuikizi kiaku mu kunkeba. ");
INSERT INTO yom_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Buna ndiela yimbidila nzitusu mu diambu di dizina diaku mu zithangu zioso ayi ndiela dedikisa zikhanu ziama lumbu ka lumbu. ");
INSERT INTO yom_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Nkunga Davidi kuidi Yedutuni, pfumu minyimbidi. Muelꞌama umbakanga luvovomo mu Nzambi kaka. Phulusu ama kuidi niandi yimbanga. ");
INSERT INTO yom_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Niandi kaka ditadi diama ayi phulusu ama ; niandi suamunu kiama kingolo ; Ndilendi bulangana ko. ");
INSERT INTO yom_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Nate zithangu zikua lufueti nuanisina mutu e ? Lutombidi beno boso bu kumbuisila e ? Banga baka kioki kitengama banga luphangu lolo lueka bua e ? ");
INSERT INTO yom_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Balembo nyendila manenga muingi bankundumuna va buangu kiandi ki zangama ; khini beti mona mu mambu ma luvunu. Mu muinu miawu, balembo sakumuna, vayi mu khati ntima miawu, balembo singi. ");
INSERT INTO yom_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Ba mu ndembama, a muelꞌama, mu Nzambi kaka ! Diana diama kuidi niandi dimbanga. ");
INSERT INTO yom_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Niandi kaka ditadi diama ayi phulusu ama ; niandi suamunu kiama ki ngolo ; Ndilengi bua ko. ");
INSERT INTO yom_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Phulusu ama ayi nzitusu ama kuidi Nzambi bidi ; niandi ditadi diama dingolo, suamunu kiama. ");
INSERT INTO yom_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Tulanganu diana dieno mu niandi mu thangu zioso, a batu. Luyalumuna mintima mieno kuidi niandi bila Nzambi niandi suamunu kieto. ");
INSERT INTO yom_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Batu baphamba badi kaka phemo, batu banneni badi kaka luvunu ; enati babasidi va basikilu, basi kadi kiasa. Kubafuba va kimosi, badi kaka phemo. ");
INSERT INTO yom_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Kadi tulanu diana mu vinza bima bingana ; voti tula luniemo mu bima bibuivi. Ka diambu ko kimvuama kiaku kilembo yilama, kadi tula ntimꞌaku mu biawu. ");
INSERT INTO yom_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Khumbu mosi Nzambi utuba, zikhumbu zizole ndiwila : ti ngeyo, a Nzambi, ngolo widi, ");
INSERT INTO yom_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","ayi ti ngeyo, a Yave, widi kiluzolo. Bukiedika, wetafuta kadika mutu boso bukasadidi. ");
INSERT INTO yom_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Nkunga Davidi mu thangu kaba mu dikanga di Yuda. A Nzambi ! Ngeyo widi Nzambiꞌama, mu kiedika ngeyo ndintomba ; muelꞌama wulembo moni phuila yi ngeyo ; nitu ama tsatu yidi mu kumona mu tsi yi yuma ; yibiva ; yikondolo nlangu ; ");
INSERT INTO yom_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ndimmona mu buangu kinlongo ndimona lulendo luaku ayi nkembo aku. ");
INSERT INTO yom_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Bila luzolo luaku luviatukidi luzingu ; bididi biama biela kukembisa. ");
INSERT INTO yom_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Ndiela kuzitisa thangu yoso ndidi moyo. Mu diambu di dizina diaku, ndiela vumuna mioko miama ku yilu. ");
INSERT INTO yom_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Muelꞌama wela yukuta banga kimvuama kiwombo ki bidia mu minkunga bididi bi munu ama biela kuzitisa. ");
INSERT INTO yom_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Va mbukꞌama ndikutebukilanga moyo ndieti kuyindula builu bu mvimba. ");
INSERT INTO yom_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Bila ngeyo lusadusu luama, ayi ndilembo yimbila ku tsi kitsusula ki mavavi maku. ");
INSERT INTO yom_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Muelꞌama widi wukangama mu ngeyo ; ayi koko kuaku kulubakala kueti kukhindisa. ");
INSERT INTO yom_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Bobo beti tomba luzingu luama bela bungana ; bela kota kuna tsi ntoto. ");
INSERT INTO yom_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Bela kuba yekula mu lulendo lu sabala ; bela kituka bidia bi zimbua zi nsitu. ");
INSERT INTO yom_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Vayi Ntinu wela mona khini mu Nzambi ; baboso bobo banleva ndefi mu dizina di Nzambi bela kunzitisa. Bila miunu mi bankua luvunu miela kangama. ");
INSERT INTO yom_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Wungwa, a Nzambi, bu ndilembo wakikisa maniongo mama keba luzingu luama va ntuala mbeni yoyi ndieti mona tsisi ! ");
INSERT INTO yom_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Wutsueka mu zikhanu zintotukilanga mu lukutukunu lu nsueki lu batu bambimbi ayi mu lukutukunu lu nkangu wu batu bamvanganga mambimbi ; bobo badi bulawu. ");
INSERT INTO yom_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Balembo bengula ludimi luawu banga sabala ; bantotulanga mambu mawu banga madionga meti vonda. ");
INSERT INTO yom_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Beti lozila bu badi mu bibuangu bisuama mutu kambulu zaba diambu Beti kunlozila mu kinzimbukila, mu kambu mona tsisi. ");
INSERT INTO yom_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Beti kukikindisa mu zikhanu zimbimbi ; beti tubana mu diambu di batamba mintambu miawu, Beti kamba : “A nani wela mimona e ?” ");
INSERT INTO yom_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Beti yindula mambu makambulu masonga ayi beti tuba : “Tukubikidi lukanu lu fuana.” Bukiedika, mayindu ma tsi ntima ayi ntima wu mutu thipula bidi. ");
INSERT INTO yom_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Vayi Nzambi wela kuba lozila madionga mandi mu kinzimbukila bela. ");
INSERT INTO yom_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Wela balula ludimi luawu veka mu diambu diawu ayi kuba nata ku mbivusu babo bela kuba mona bela nikuna ntu. ");
INSERT INTO yom_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Batu boso bela mona tsisi, bela yamikisa mavanga ma Nzambi ; ayi bela sudika momo kavanga. ");
INSERT INTO yom_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Bika mutu wusonga kamona khini mu Yave ayi katombila suamunu mu niandi ayi babo badi mintima mi lulama banzitisa. ");
INSERT INTO yom_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Nkunga Davidi kuidi pfumu minyimbidi. A Nzambi, nzitusu wulembo ku vingidila mu Sioni kuidi ngeyo tuela dukisa zindefi zieto. ");
INSERT INTO yom_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Ngeyo weti wa lusambulu ; batu boso bela kuiza kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Mu thangu tufietukusu kuidi masumu ; ngeyo wutulemvukila mu zinzimbala zieto. ");
INSERT INTO yom_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Lusakumunu kuidi bobo wusobula ayi bobo wunata mu ba va widi muingi bazingila mu luphangu luaku. Tuidi bayukuta mu bima bimboti bi nzo aku, bi nzo aku yinlongo. ");
INSERT INTO yom_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Ngeyo wutuveni mvutu ayi ndambu tsisi mu mavanga ma busonga. A Nzambi, Mvulusi eto, ngeyo diana di zitsukusunu zioso zi ntoto ayi di mimbu milutidi tatuka. ");
INSERT INTO yom_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Ngeyo wuvanga miongo mu lulendo luaku ; ngeyo veka wukivuika zingolo. ");
INSERT INTO yom_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Wunlembikanga biyoko bi mimbu, biyoko bi mayo mandi ayi khindu yi makanda. ");
INSERT INTO yom_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Batu bobo banzingilanga ku thama bela mona tsisi matsiminanga maku, kuna kueti totukila thangu ayi ku keti diamina, ngeyo wutela kuawu minkunga mi khini. ");
INSERT INTO yom_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Ngeyo wuyiza tala ntoto ayi wuwuvana nlangu ; wuvana wawu bima buwombo. Mila mi Nzambi midi miwala nlangu. Ngeyo weti kubikila batu makundi bila ngeyo wutumina buawu. ");
INSERT INTO yom_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Weti lembila minkala miandi ayi wulembo ladikisa makumutu mandi ma ntoto ayi wulembo lebisa wawu mu masala ; wulembo sakumuna bikunusu biandi. ");
INSERT INTO yom_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Ngeyo weti manisina mvu mu mamboti maku ; bima biwombo bilembo sapika mu zisaleti ziaku ");
INSERT INTO yom_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Bibuangu bieti mena biti mi dikanga bilembo sapika zikhundubula zilembo vuati khini. ");
INSERT INTO yom_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Mamemi mafulukidi mu bibuangu bieti mena biti ; mindimba mifulukidi mu makundi ; milembo yamikina mu khini ayi yimbila. ");
INSERT INTO yom_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Nkunga kuidi pfumu minyimbidi. Ntoto wumvimba, yamikinanu mu khini kuidi Nzambi, ");
INSERT INTO yom_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Yimbilanu nkembo wu dizina diandi. Kitulanu nzitusu andi nzitusu wu nkembo ! ");
INSERT INTO yom_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Kambanu Nzambi : mavanga maku tsisi madi ! Lulendo luaku luidi lunneni diawu bambeni ziaku zilembo kukikulula. ");
INSERT INTO yom_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Ntoto wumvimba weti komvama va ntualꞌaku ayi bela yimbila minzitusu kuidi ngeyo ; bela yimbila minzitusu kuidi dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Yizanu, lutala momo Nzambi kavanga. Mavanga madi tsisi madi kuidi batu. ");
INSERT INTO yom_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Wukitula mbu ntoto wuyuma ; basabukila nlangu wunneni mu malu : Yizanu tumona khini mu niandi. ");
INSERT INTO yom_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Wunyadilanga mu lulendo luandi mu zithangu zioso ; Meso mandi mantalanga makanda ; bika bankua matingu babika kumfuemina. ");
INSERT INTO yom_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Zitisanu Nzambi eto, a batu bika biyoko bi nzitusu andi biwakana ngolo. ");
INSERT INTO yom_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Niandi wutanini luzingu lueto ayi wukeba malu meto mabika sialumuka. ");
INSERT INTO yom_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Bila ngeyo, a Nzambi, wutumeka ngeyo wutuvedisa banga palata. ");
INSERT INTO yom_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Wutukotisa mu nloko, ngeyo wutula mimfuna mu luketo lueto. ");
INSERT INTO yom_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Ngeyo wutala ti batu batudiatidila mu mintu mieto ; beto tukota ku mbazu ayi mu nlangu, vayi wutunata ku buangu kidi bima biwombo. ");
INSERT INTO yom_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Ndiela kuiza mu nzo aku ayi makaba mayoko ; ayi dukisa zindefi ziama kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Zindefi ziozi bididi biama bivanina tsila ayi ziosi ziyolukila munu ama mu thangu ndiba mu phasi. ");
INSERT INTO yom_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Ndiela tambika bibulu bi mafuta kuidi ngeyo ayi makaba ma mamemi ma mbakala ; ndiela tambika zingombi ayi zikhombo zimbakala. ");
INSERT INTO yom_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Yizanu, ayi ludimba beno boso lueti kinzika Nzambi bika ndilukamba momo kavengi mu diambu diama. ");
INSERT INTO yom_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Ndiyamikina kuidi niandi mu munu ama, nzitusu andi wuba mu ludimi luama. ");
INSERT INTO yom_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Enati ndiyayisa masumu mu ntimꞌama, nganu Yave kasia diamba ko. ");
INSERT INTO yom_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Vayi bukiedika Nzambi wudimba ayi wuwa mbembo ama mu lusambulu. ");
INSERT INTO yom_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Nzitusu wuba kuidi Nzambi, niandi kasia loza ko lusambulu luama ; voti kasia botula ko luzolo luandi mu minu. ");
INSERT INTO yom_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Nkunga kuidi pfumu minyimbidi, kayimbidila mu ngitala. Bika Nzambi katusila nlemvo ayi katusakumuna ; ayi zizi kiandi kitukienzula ; ");
INSERT INTO yom_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","muingi zinzila ziaku zizabakana va ntoto, phulusu aku yizabakana muidi makanda moso ! ");
INSERT INTO yom_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Bika batu bazitisa, a Nzambi ; bika batu boso bazitisa. ");
INSERT INTO yom_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Bika makanda mayangalala ayi mayimbila mu diambu di khini bila ngeyo weti yadila batu mu busonga ; ngeyo wela diatisa makanda ma ntoto. ");
INSERT INTO yom_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Bika batu bazitisa, a Nzambi ; bika batu boso bazitisa. ");
INSERT INTO yom_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Buna ntoto wuela buta mimbutu miandi ; Nzambi, Nzambi eto, wela kutusakumuna. ");
INSERT INTO yom_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Nzambi wela kutusakumuna ayi zitsuka zioso zi ntoto ziela kunkinzika. ");
INSERT INTO yom_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Bika Nzambi katelama ; bika bambeni bandi zisasukusu ayi bobo beti kunlenda bantina va ntualꞌandi. ");
INSERT INTO yom_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Banga bueti lalikinina muisi mu phemo, bika wuba lalikisa ; banga bueta siutila sile ku mbazu bika batu bambimbi babungana va meso ma Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Vayi bika batu basonga bamona khini ; ayi bayangalala va ntuala Nzambi, bika bamona mayangi ayi khini yingolo. ");
INSERT INTO yom_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Yimbidilanu Nzambi ; yimbidilanu minzitusu mu diambu di dizina diandi ; yayisanu mutu wowo wundiatila va phunda mu matuti Dizina diandi Yave ; ayi lumona khini va ntualꞌandi. ");
INSERT INTO yom_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Nzambi niandi widi dise di bisana ayi niandi weti nuanina mafuola. Mu buangu kiandi kinlongo kioki keti vuanda. ");
INSERT INTO yom_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Nzambi wumvananga dikanda kuidi bobo badi bawu veka ; niandi weti tuadisa basi nloko mu ngimbudulu vayi bankua matingu bawu banzingilanga mu ntoto wu yuma. ");
INSERT INTO yom_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Mu thangu wutuaminina batu baku ku ntuala, a Nzambi, mu thangu mu dikanga, ");
INSERT INTO yom_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","ntoto wunikuka, diyilu dinokisa mvula va ntualꞌaku. Va ntuala Nzambi, mutu wu Sinayi va ntuala Nzambi, Nzambi yi Iseli. ");
INSERT INTO yom_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Ngeyo wunokisa masala mawombo, a Nzambi ; ngeyo wukindisa kiuka kiaku mu thangu kivonga. ");
INSERT INTO yom_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Batu baku bavuanda muawu A Nzambi, mu mamboti maku, ngeyo wukubika bima mu diambu di nsukami. ");
INSERT INTO yom_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Yave wutuba diambu dimosi : batu bawombo bamonika mu yamikisa mawu. ");
INSERT INTO yom_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Mintinu ayi minkangu mi masodi milembo tini mu thinu nsualu, mu bika bi batu, batu bakabula biobi baziona mu mvita. ");
INSERT INTO yom_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Lukidi kueno leki va khatitsika bidikulu bi bibulu mavavi ma dibembi diama mavindu palata, zitsala ziandi zivindu nolo yilembo lezama. ");
INSERT INTO yom_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Thangu Nzambi nkua ngolo yoso kasasikisa mintinu va ntoto, yiba banga yi matadi ma phembi. ");
INSERT INTO yom_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Miongo mi Basani midi miongo mi nzitusu ; miongo mi Basani midi miongo midi zitsongi ziwombo. ");
INSERT INTO yom_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","A bila mbi luntadila mu kikhenene, e beno miongo midi zitsongi ziwombo ; mongo wowo kasobula mu yadila, kuna niandi veka Yave kela vuandanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Matoma ma mvita ma Yave madi dikumi di zimili ayi zimili yi zimili ; Yave wutotukila ku Sinayi mu buangu kiandi kinlongo. ");
INSERT INTO yom_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Thangu wukuma ku yilu, wunata mu ntandꞌaku batu bakangama. Wutambula makaba kuidi batu ayi kuidi bankua matingu muingi ngeyo, a Yave Nzambi wuvuanda kuna. ");
INSERT INTO yom_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Nzitusu kuidi Yave, kuidi Nzambi mvulusi eto. Niandi weti kutunatina bizitu bieto lumbu ka lumbu. Niandi Nzambi wukutuvananga phulusu. ");
INSERT INTO yom_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Nzambi eto widi Nzambi weti vukisa. Yave, mutu wumvanganga momo kazodidi, wumvukisanga mu lufua. ");
INSERT INTO yom_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Bukiedika, Nzambi wela kosikisa mintu mi bambeni bandi ; wela kosikisa mintu mi batu bobo badi zitsuki ziwombo, bobo bandiatilanga mu masumu mawu. ");
INSERT INTO yom_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Pfumu tubidi : “Ndiela kuba totula mu Basani, ndiela kuba totula ku tsina yi mbu, ");
INSERT INTO yom_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Muingi wubuika malu maku mu menga ma bobo beti kulenda ayi ludimi lu zimbua ziaku lubaka kuku kiawu.” ");
INSERT INTO yom_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Ndiatulu aku yimonika, a Nzambi. Ndiatulu yi Nzambi ama, ayi yi ntinu ama mu buangu kinlongo. ");
INSERT INTO yom_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Minyimbidi miba ku ntuala ; bosi minsiki mi miziki miba landakana, miba va kimosi bana ba baketo bansika zindungu. ");
INSERT INTO yom_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Bika luzitisa Nzambi mu lukutukunu lunneni, Luzitisa Yave mu dikabu di Iseli ! ");
INSERT INTO yom_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Kuna kuidi dikanda di fioti di Benzami, wuba tuadisa, kuna kuba batu bawombo banneni ba Yuda ayi batu banneni ba Zabuloni ayi ba Nefitali. ");
INSERT INTO yom_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Tumina lulendo luaku, a Nzambi. Wutumonisa zingolo ziaku, a Nzambi banga bobo wutuama vangila. ");
INSERT INTO yom_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Mu diambu di nzo aku ku Yelusalemi ; mintinu miela kunatina makaba. ");
INSERT INTO yom_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Tubidila bulu va khatitsika masoso nkangu zingombi zi mbakala va khatitsika bana zingombi zi makanda. Bu kakululu, wulenda nata bitini bi palata. Sasikisa makanda mona khini mu nuana mvita ! ");
INSERT INTO yom_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Batu bafidusu bela totukila mu Ezipite ; Kusi wela kukiyekula niandi veka ku tsi minsua mi Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Yimbidilanu Nzambi beno bipfumu bi ntoto ; yimbilanu minzitusu kuidi Yave ; ");
INSERT INTO yom_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Kuidi mutu wowo wundiatila banga va mbata phunda mu diyilu, mu diyilu di khulu. Mutu wowo wulembo dumu mu mbembo yi lulendo. ");
INSERT INTO yom_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Luyamikisa lulendo lu Nzambi nzitusu andi widi va mbata Iseli lulendo luandi luidi mu matuti. ");
INSERT INTO yom_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Tsisi widi, a Nzambi, mu buangu kiaku kinlongo. Nzambi yi Iseli niandi weti vana lulendo ayi zingolo kuidi batu bandi. Nzitusu wuba kuidi Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Nkunga Davidi kuidi pfumu minyimbidi kayimbidila mu “LISI”. Wuphukisa, a Nzambi, bila minlangu mitudidi nate mu dinga diama. ");
INSERT INTO yom_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Ndilembo diami mu nyamba wungolo ; kuna kukambulu buangu ki singikila kulu ; khotidi nate ku tsi nlangu widi thipula mayo mambinini. ");
INSERT INTO yom_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Mbeni vonga mu diambu di telanga lusadusu dinga diama dieka yuma, meso mama malembo vongi mu talanga Nzambi ama. ");
INSERT INTO yom_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Bobo bakundendanga mu kambu bila badi bawombo viokila zitsuki zi ntuꞌama ; bawombo badi bambeni ziama mu kambu bila bobo bantomba kumbunga. Ndilembo kuiku mu vutula biobi ndisia yiba ko. ");
INSERT INTO yom_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Ngeyo zebi buvungisi buama, a Nzambi zinzimbala ziama zisiko zisuama kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Bika batu bobo bantulanga diana mu ngeyo babika fua tsoni mu diambu diama ! A Yave, Yave nkua ngolo yoso bika bobo bakutombanga babika ba dio kombolo mu diambu diama, a Nzambi yi Iseli. ");
INSERT INTO yom_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Bila mu diambu diaku ndinkininina lenzo ayi tsoni yifukidi zizi kiama ; ");
INSERT INTO yom_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Ndieka nzenza kuidi bakhomba ziama ; ayi nkibi kuidi bana ba ngudi ama. ");
INSERT INTO yom_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Bila luzolo mu diambu di nzo aku lulembo nzinisa. Ayi bifingu bi batu bobo bakufinganga bibuidi va minu. ");
INSERT INTO yom_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Bu ndieti dila ayi ndieti kifuisa nzala mu diambu di lusambulu. Buna mfueti kikinina lenzo ");
INSERT INTO yom_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Bu ndieti vuata tsaku, batu beti kukhitula savu. ");
INSERT INTO yom_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Bobo bavuendi va muelo, minu bansekinina ayi ndieti nkunga wu bakolo-mbungu. ");
INSERT INTO yom_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Vayi, kuidi ngeyo, ndieti sambila, a Yave ; mu thangu yi nlemvo aku, mu luzolo luaku lunneni, a Nzambi bika wuphana mvutu mu phulusu aku yi kiedika ! ");
INSERT INTO yom_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Wuthotula mu nyamba, kadi tala ti ndidiama. Bika wukhula mu batu bobo beti kundenda mu minlangu midi thipula ! ");
INSERT INTO yom_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Kadi tala ti khuka yi nlangu yimbina voti tsi yi minlangu yi ndalumuna voti dibulu ndinzibila munu andi. ");
INSERT INTO yom_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Bika wuphana mvutu Yave boso buididi mamboti ma luzolo luaku ; mu kiadi kiaku kinneni ; bika wubaluka kuidi minu. ");
INSERT INTO yom_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Kadi suekila kisadi kiaku zizi kiaku ; wuphani mvutu mu nsualu nsualu bila mu phasi ndidi. ");
INSERT INTO yom_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Fikama ayi wukhudi ; Khudi mu diambu di bobo beti kundenda ! ");
INSERT INTO yom_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Ngeyo zebi buevi ndidi wulenzo, ndidi dio kombolo ayi ndidi mu tsoni Bambeni ziama zioso zidi va ntualꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Nlenzo wukosikisidi ntimꞌama ayi wumbika kadi lusadusu nditomba bambona kiadi, vayi kusia monika kadi mutu ko ; mu diambu di mimbombi, vayi ndisia bakula kadi mutu ko. ");
INSERT INTO yom_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Batudidi biyimbu mu bidia biama, ayi banduikisa vini ki ngami mu phuila yiba yama. ");
INSERT INTO yom_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Bika meza batula va ntualꞌawu yikituka dikondi yikituka mfutu ayi ntambu. ");
INSERT INTO yom_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Bika meso mawu maba mu tombi ayi mabika buela mona ; ayi manima mawu maba ma komvama mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Wuba dukuidila miangu miaku mi ngolo ayi bika nganzi aku yi ngolo yiba buila. ");
INSERT INTO yom_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Bika buangu kiawu kikitunga dikanga kubika buela monika mutu wumvuanda mu zinzo ziawu zi ngoto. ");
INSERT INTO yom_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Bila balembo yamisa batu bobo wulueka ; beti yolukila ziphasi zi batu bobo wumonisa phasi ");
INSERT INTO yom_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Wuba yekudila mambimbi va yilu mambimbi kadi tala ti babaka kuku mu phulusu aku. ");
INSERT INTO yom_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Bika bakubulu mu buku yi luzingu, ayi babika tangu va kimosi ayi batu basonga ! ");
INSERT INTO yom_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Ndidi mu phasi ayi mu mabienga bika phulusu aku, a Nzambi yikheba ");
INSERT INTO yom_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Ndiela zitisanga dizina di Nzambi mu nkunga, ayi ndiela kunkembisa mu phutudulu matondo. ");
INSERT INTO yom_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Buna diodi diela luta monisa Yave khini viokila ngombi yimbakala, viokila ngombi yidi ziphoka ayi bikodi bivasuka. ");
INSERT INTO yom_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Nsukami wela mona ayi wela yangalala ; beno lueti tomba Nzambi, bika mintima mieno mizinga. ");
INSERT INTO yom_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Yave weti wila nsukami ayi kalenzanga ko batu bandi bakangama. ");
INSERT INTO yom_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Bika Diyilu ayi ntoto binzitisa, mimbu ayi bibioso bieti diatanga muawu. ");
INSERT INTO yom_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Bila Nzambi wela vukisa Sioni, ayi wela buela tunga mavula ma Yuda, buna batu bela kala muawu ayi kuma vua ");
INSERT INTO yom_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Mela ba kiuka ki bana ba bisadi biandi, ayi bobo beti zolanga dizina diandi bela vuandanga mawu. ");
INSERT INTO yom_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Nkunga Davidi kuidi pfumu minyimbidi mu diambu di thebokolo moyo. Yiza nsualu, a Nzambi, mu kukhula ! Yave, yiza nsualu mu kutsadisa ! ");
INSERT INTO yom_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Bika bobo bantomba luzingu luama bafua tsoni ayi baba dio kombolo ! Bika bobo bantomba mbivusu ama bavutuka ku mbusa ayi bafua tsoni. ");
INSERT INTO yom_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Bika bobo beti tuba kuidi minu : “A… A…” bavutuka ku mbusa mu diambu di zitsoni ziawu. ");
INSERT INTO yom_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Babo bakutombanga bamona khini ayi bayangalala mu ngeyo ; bika bobo banzolanga phulusu aku batubanga mu zithangu zioso : “Bika Nzambi kayayusu.” ");
INSERT INTO yom_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Vayi minu ndidi nsukami ayi nkua kiadi yiza nsualu kuidi minu, a Nzambi ! Ngeyo nsadisi ama ayi nkudi ama ; A Yave kadi zingila ! ");
INSERT INTO yom_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Mu ngeyo, a Yave, ndisuamina kadi tala ti ndifua tsoni kadi khumbu yimosi ! ");
INSERT INTO yom_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Wukhudi ayi wuphukisa mu busonga buaku balula dikutu diaku kuidi minu ayi phukisa. ");
INSERT INTO yom_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Ba ditadi diama diodi di kutsuekanga ; momo ndilenda kuenda mu zithangu zioso vana lutumunu mu kuphukisa bila widi ditadi diama ayi tinunu kiama ki ngolo. ");
INSERT INTO yom_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Wukhudi Nzambi ama mu mioko mi batu bambimbi ; mu mioko mi batu bamvanganga mambimbi ayi mu batu badi tsita. ");
INSERT INTO yom_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Bila ngeyo wuba diana diama, a Yave, ngeyo wumvanganga moso wuzodidi. Diana diama tona mu bumuana buama. ");
INSERT INTO yom_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Tona ndibutuka, mu ngeyo ndieti singimina ; ngeyo wuthotula tona mu vumu ki ngudi ama ; Ngeyo ndiela zitisanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Ndieka banga diambu di siminina kuidi bawombo, vayi ngeyo suamunu kiama kingolo. ");
INSERT INTO yom_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Munu ama widi wuwala mu nzitusu aku wunyamikisa kiezila kiaku mu lumbu kimvimba. ");
INSERT INTO yom_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Kadi kundoza mu thangu ndieka nunu ; kadi kundiekula mu thangu zingolo ziama zilembu suki ! ");
INSERT INTO yom_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Bila bambeni ziama zilembo thubidila bobo balembo tombi kuphonda, balembo wizana va kimosi, ");
INSERT INTO yom_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","balembo tubi : “Nzambi wunyekudi, nlandakananu, bila kuisi ko mutu wufueti ku nkula.” ");
INSERT INTO yom_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Kadi ba thama ayi minu, a Nzambi, yiza nsualu Nzambi ama mu kutsadisa ! ");
INSERT INTO yom_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Bika mimfundi miama mibungana mu tsoni ; bika bobo bantomba kuphanga phasi baba ba lenzo ayi dio kombolo. ");
INSERT INTO yom_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Vayi kuidi minu, ndiela tulanga kaka diana mu zithangu zioso buela kuzitisanga ngolo. ");
INSERT INTO yom_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Munu ama wela yolukila busonga buaku ayi phulusu aku mu lumbu kimvimba, bila ndikadi zaba tezo biawu. ");
INSERT INTO yom_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Ndiela kuiza ayi yamikisa mavanga maku ma lulendo ; a Yave, mutu wumvanganga makazodidi ndiela yamikisa busonga buaku ; busonga buaku kaka. ");
INSERT INTO yom_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Tona mu bumuana buama, a Nzambi, ngeyo wundonga ayi ye lumbu kiaki yayi ndinyamikisanga matsiminanga maku. ");
INSERT INTO yom_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Bobuawu, bu ndiela nuna ayi zitsuki ziphembi kadi ku ndiekula, a Nzambi. Muingi nditubila lulendo luaku kuidi tsungi yinkuiza, zingolo ziaku kuidi babo bela kuiza. ");
INSERT INTO yom_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Busonga buaku buntula nate ku diyilu, a Nzambi. Ngeyo wuvanga mambu manneni ; nani a Nzambi widi banga ngeyo e ? ");
INSERT INTO yom_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Ngeyo wumbonisa ziphasi ziwombo ayi zindudi ; wela buela kuphutudila luzingu ; tona ku tsi ntoto, ngeyo wela buela kuthotula. ");
INSERT INTO yom_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Wela buela wokisa nzitusu ama, ayi buela ku khindisa diaka. ");
INSERT INTO yom_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Ndiela kuzitisa mu ngitala mu diambu di kikhuikizi kiaku, a Nzambi ama ; ndiela kuyimbidila minzitusu mu Lila. Ngeyo nlongo wu Iseli. ");
INSERT INTO yom_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Bididi biama biela yimbila mu diambu di khini mu thangu ndiela kuyimbidila minzitusu, minu mutu wowo wukula. ");
INSERT INTO yom_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Ludimi luama luela yolukila mavanga maku masonga mu lumbu kimvimba, Bila bobo bantomba kumbonisa phasi bela fua tsoni ayi bela ba dio kombolo. ");
INSERT INTO yom_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Nkunga Salomo. Vuika ntinu fuanana kuaku, a Nzambi kuidi muana ntinu busonga buaku ! ");
INSERT INTO yom_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Niandi wela sambisa batu baku mu busonga ayi batu baku badi mu phasi mu bufuana. ");
INSERT INTO yom_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Miongo miela natina batu mamboti ; ayi zikhundubula ziela nata mimbutu mi busonga. ");
INSERT INTO yom_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Wela vavila batu mu phasi va khatitsika batu ayi wela vukisa bana bansukami wela kosikisa mutu wunyamisanga batu. ");
INSERT INTO yom_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Bela kanga ntima thangu bu yikidi ngondi bu yikidi mu zitsungi zioso. ");
INSERT INTO yom_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Niangi wela ba banga mvula yinnokina mu tsola yisolo, banga mabeti ma disala mambua mu ntoto. ");
INSERT INTO yom_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Mu bilumbu biandi, mutu wusonga wela mona mamboti, mamboti mela yilama nate ngondi yela zimbala. ");
INSERT INTO yom_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Wela yadilanga tona ku mbu nate ku mbu wunkaka ; ayi tona ku nlangu wunneni nate kuna zitsuka zi ntoto. ");
INSERT INTO yom_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Makanda ma dikanga mela buongama va ntualꞌandi ayi bambeni bandi ziela venda fundu-fundu. ");
INSERT INTO yom_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Mintinu mi Talisi ayi mi bisanga bidi thama miela kunnatina phaku Mintinu mi Saba ayi mi Seba miela kumvana makaba. ");
INSERT INTO yom_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Mintinu mioso miela buongama va ntualꞌandi ayi makanda moso mela kunsadilanga. ");
INSERT INTO yom_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Bila wela kula nsukami wulembo yamikina ; mutu widi mu phasi kambulu mutu wulenda sadisa. ");
INSERT INTO yom_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Wela mona mutu wulebakana ayi nsukami kiadi ayi wela vukisa minsukami mu lufua. ");
INSERT INTO yom_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Wela kula kuba kula mu khuamusu ayi mu makhemi ayi menga mawu thalu madi va meso mandi. ");
INSERT INTO yom_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Bika kazinga ! Bika baba kumvana nolo yela ba ku Saba ; Bika batu bansambila mu zithangu zioso, ayi bela kunsakumuna mu lumbu kimvimba. ");
INSERT INTO yom_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Bika makundi maba mawombo mu tsi nate va mbata miongo ayi bika mimbutu miandi mibuta banga Lebanoni bika miba mimboti banga biti bi tsola. ");
INSERT INTO yom_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Bika dizina diandi dizingila mu zithangu zioso ; bika dizina diandi dizinga thangu bu yikidi lezama. Makanda moso mela sakumunu mu niandi ayi bela kuntedila mutu wu lusakumunu. ");
INSERT INTO yom_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Nzitusu wuba kuidi Yave Nzambi Nzambi yi Iseli, Bila niandi veka kaka wumvanganga matsiminanga. ");
INSERT INTO yom_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Nzitusu wuba kuidi dizina diandi di nkembo mu zithangu zioso Bika ntoto wumvimba wuwala nkembo andi ! ");
INSERT INTO yom_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Vava vasukila zitsambulu zi Davidi, muana Yese. ");
INSERT INTO yom_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Nkunga Asafi. Bukiedika ; Nzambi widi wumboti kuidi Iseli ; kuidi bobo badi mintima mi vedila. ");
INSERT INTO yom_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Vayi kuidi minu, fioti fisiala nganu malu mama masialumuka fioti fisiala nganu ndizimbisa singumnu ki kulu kuama. ");
INSERT INTO yom_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Bila ndizinina batu ba luniemo bu ndimona mamboti ma batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Kadi mabienga bamonanga ko ayi zinitu ziawu zidi mu bivini ayi zibeki ngolo. ");
INSERT INTO yom_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Bamonanga ko ziphasi ziozi batu boso beti mona ; bayamusungu ko mu bimbevo bi mbuanga batu boso. ");
INSERT INTO yom_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Diawu luniemo luidi sieni mu madinga mawu baki vuikidi makhemi. ");
INSERT INTO yom_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Mu mintima miawu mi matadi, muntotukila mambimbi zikhanu zimbimbi zi mayindu mawu zisi zaba zindilu ko. ");
INSERT INTO yom_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Bamvueza ; banyolukilanga mu bumbimbi ; mu lunangu luawu, balembo kubika khuamusu. ");
INSERT INTO yom_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Miunu miawu milembo nuanina diyilu ludimi luawu lueti vua ntoto. ");
INSERT INTO yom_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Diawu batu bawu beti baluka kuidi bawu ; beti nuanga nlangu mu buwombo. ");
INSERT INTO yom_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Beti tubanga : “Buevi Nzambi kela zabila e ? Nzambi yizangama beki nzayilu e ?” ");
INSERT INTO yom_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Tala buawu bobo buididi batu bambimbi : mu kambu bela kadi diambu dimosi mayindu ko ; beti yidikanga kimvuama. ");
INSERT INTO yom_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Bukiedika, mu phamba kuandi ndikebidi ntimꞌama wuvedila mu phamba kuandi ndisukudidi mioko miama mu monisa kambu kuama ku bila. ");
INSERT INTO yom_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Mu lumbu kimvimba minu nditutu khuba ; nditambula thumbudulu kadika nsuka. ");
INSERT INTO yom_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Enati ndituba : “Ndiela tuba banga bawu”, Nganu ndivakula bana baku. ");
INSERT INTO yom_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Bu nditomba bu sukudila mambu moso mama buna diba khuamusu kuidi minu. ");
INSERT INTO yom_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Nate ndikota mu khati buangu kinlongo ki Nzambi, buna bosi ndisudika tsukulu awu. ");
INSERT INTO yom_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Bukiedika, ngeyo wukuba tulanga mu ntoto widi ndelo ; ngeyo weti kuba loza ku mbivusu. ");
INSERT INTO yom_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Babungini mu kinzimbukila batumbulu lalakana mu diambu di tsisi yingolo. ");
INSERT INTO yom_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Banga ndozi, mutu bu kakotukidi ; buawu bobo bu wela kotuka, a Yave, wela kuba lenza banga bima bi phamba. ");
INSERT INTO yom_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Mu thangu ntimꞌama wubedi kiaki ayi pheve ama yibedi mu kingongo, ");
INSERT INTO yom_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Minu ndiba vungisi ; ndisia ba nzayilu ko ; Ndiba bulu kinsitu va ntualꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Muaki ndidi kaka va kimosi ayi ngeyo mu zithangu zioso ; wutsimbidila mu koko kuama ku lubakala ; ");
INSERT INTO yom_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Ngeyo weti kundiatisa mu zindongi ziaku, ayi bosi ngeyo wela kuthambula mu nkembo. ");
INSERT INTO yom_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Nani wunkaka widi yama mu Diyilu enati ngeyo ko e ? Ntoto kasi kadi kima ko kioki ndieti mona phuila enati ngeyo ko e ? ");
INSERT INTO yom_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Nsuni ama ayi ntimꞌama bibeki bu vongila vayi Nzambi niandi zingolo zi ntimꞌama ayi kuku kiama mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Bobo badi thama ayi ngeyo bela biva ngeyo wela bunga batu boso bobo bakambulu bakuikama kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Vayi kuidi minu, didi diambu di mboti mu fikama Nzambi. Ndikitula Yave, mutu wumvanganga makazodidi suamunu kiama. Ndiela yolukila mavanga maku moso. ");
INSERT INTO yom_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Nkunga Asafi. Bila mbi wutulozidi mu zithangu zioso, a Nzambi e ? Bila mbi wufuemini minkangu miaku mi mamemi miomi weti dikila e ? ");
INSERT INTO yom_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Tebukila batu baku moyo ; bobo wukibakila thama ; dikanda di kiuka kiaku, diodi wukula. Mongo wu Sioni, koko wuvuanda. ");
INSERT INTO yom_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Balula zithambi ziaku ku ndambu bibuangu bitiolumunu mu mvu ka mvu. Zimbivusu zioso ziozi mbeni kavanga mu buangu kinlongo. ");
INSERT INTO yom_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Batu balendidi balembo vomi va buangu kioki wutudenginina ; batula bidalapo biawu banga dimbu ki ndungunu. ");
INSERT INTO yom_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Badi banga batu bannanguna soka mu zenga minti ku nsitu widi khoba. ");
INSERT INTO yom_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Bakosikisa mabaya moso momo bamana fikula mu bisoka biawu ayi zi malito ziawu. ");
INSERT INTO yom_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Bazinisa buangu kiaku kinlongo mu mbazu ; basumuna buangu kieti vuandanga dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Babedi tubanga mu mintima miawu : “Tuela kuba kosikisa mvimba” Bazinisa mu mbazu bibuangu bioso biobi beti buongimina Nzambi mu tsi. ");
INSERT INTO yom_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Bakadi kutumonisa kadi kumu kimosi kusiedi mimbikudi ko. Kadi mutu wumosi mu beto zebi keni nate thangu mbi mama mela tatamana bela e ? ");
INSERT INTO yom_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Nate thangu mbi mbeni kela kusekinina, a Nzambi e ? Nate thangu mbi mutu wundendidi kela lenzilanga dizina diaku mu zithangu zioso e ? ");
INSERT INTO yom_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Bila mbi kangidi koko kuaku, koko kuaku ku lubakala e ? Bonga kuawu mu mimfutu mi kukhutu kiaku ayi wuba bungi. ");
INSERT INTO yom_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Vayi ngeyo Nzambi, ngeyo ntinu ama tona muna tona ; ngeyo weti nata phulusu va ntoto. ");
INSERT INTO yom_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Keti ngeyo wuvasa mbu mu lulendo luaku ; wukosikisa mintu mi bisimbi bi minlangu ; ");
INSERT INTO yom_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","keti ngeyo wukosikisa mintu mi Leviatani, wumvana banga bidia kuidi bibulu bi dikanga ");
INSERT INTO yom_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Keti ngeyo wuzibula zitho zi minlangu ayi mimvuila mi minlangu Ngeyo wusikisa minlangu minneni miomi mieti kumba mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Ngeyo vuidi muini, ayi ngeyo vuidi builu ; ngeyo wuvanga ngondi ayi thangu. ");
INSERT INTO yom_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Keti ngeyo wumana vanga zindilu zioso zi ntoto, ngeyo wuvanga tsungi yi muini wu ngolo ayi yi kiozi kingolo. ");
INSERT INTO yom_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Tebuka moyo buevi mbeni kalembo sekinina, a Yave, buevi bivungisi balenzila dizina diaku ! ");
INSERT INTO yom_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Kadi yekula luzingu lu dibembi diaku kuidi bibulu bi nganzi ayi kadi thumbu zimbakana luzingu lu batu baku badi mu phasi. ");
INSERT INTO yom_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Bengudila Nguizani aku thalu ; bila bisuamunu biyindulungu makhemi bifulukidi mu bibuangu bitombi bi ntoto. ");
INSERT INTO yom_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Kadi tala ti mutu wuyamusu kavutuka mu tsoni Bika nkua kiadi ayi nsukami bazitisa dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Telama a Nzambi ! Wukinungisa ! Tebukila moyo buevi bivungisi bilembo sekinina mu bilumbu bioso. ");
INSERT INTO yom_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Kadi zimbakana biyoko bi bambeni ziaku divunzi di bambeni ziaku, diodi dilembo buelamanga thangu ka thangu. ");
INSERT INTO yom_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Nkunga Asafi kuidi pfumu minyimbidi “Kadi vonda”. Tueti kuvutudila matondo, a Nzambi. Tueli vutula matondo bila dizina diaku didi difikama batu balembo yolukila matsiminanga maku. ");
INSERT INTO yom_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ngeyo tubidi : “tsobudi thangu yifuana Keti minu ndieti sambisa mu bufuana. ");
INSERT INTO yom_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Ntoto bu wulembo nikuka va kimosi ayi batu bandi boso Keti minu ndisimbidila makunzi mandi. ");
INSERT INTO yom_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Kuidi nkua luniemo, ndintuba : ‘Kadi kukiniemisanga ngolo’ Kuidi batu bambimbi : ‘lubika vumbula ziphoka zieno.’ ");
INSERT INTO yom_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Lubika vumuna ziphoka zieno mu diambu di diyilu ; bikanu tubila mu nonumuna madinga !” ");
INSERT INTO yom_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Kadi mutu wumosi tona ku Esite voti ku Wesite voti tona ku dikanga wulenda yayisa mutu. ");
INSERT INTO yom_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Vayi Nzambi niandi weti sambisa ; niandi weti kulula wunkaka, niandi weti yayisa wunkaka. ");
INSERT INTO yom_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Mu koko ku Yave muidi mbungu yiwala vinu kingolo ayi yisobokoso. Wulembo dukula kiawu ayi batu boso bambimbi badi va ntoto bela nua kiawu nate kuna dibomvi. ");
INSERT INTO yom_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Vayi minu, ndiela samunanga mawu mu thangu zioso. Ndiela yimbidila nzitusu kuidi Nzambi yi Yakobi. ");
INSERT INTO yom_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Ndiela zenga ziphoka zi batu boso bambimbi, vayi ziphoka zi batu basonga luela nanguku. ");
INSERT INTO yom_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Nkunga Asafi kuidi pfumu minyimbidi kayimbidila mu ngitala. Mu Yuda, Nzambi zabikini Dizina diandi didi dinneni mu Iseli. ");
INSERT INTO yom_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Nzo andi yi ngoto yidi ku Salemi, buangu kiandi kidi ku Sioni. ");
INSERT INTO yom_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Kuna kakeludila madionga malembo lemi, nkaku ayi sabala, mbedi ayi binuanunu bi mvita. ");
INSERT INTO yom_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Ngeyo lembo lezama mu kiezila, lutidi kinzuku viokila miongo miwedi bibulu. ");
INSERT INTO yom_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Makhesa mamana ku baziona bima, balembo leki tulu tuawu tutsuka, kadi wumosi mu binuani lenda tombula mioko miandi. ");
INSERT INTO yom_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Mu themunuꞌaku, a Nzambi yi Yakobi, ziphunda ayi matoma ma mvita bibibiodi biledi tulu tuvindu. Bileka tulu tuvindu. ");
INSERT INTO yom_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Ngeyo veka, lembo monisa tsisi ! Nani wulenda telama va meso maku ngeyo fuema e ? ");
INSERT INTO yom_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Tona kuna Diyilu wuwakikisa nzengolo ; ntoto wumona tsisi ayi wutumbu dingalala ; ");
INSERT INTO yom_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Thangu ngeyo, a Nzambi, wutelama mu diambu di sambisa ayi mu diambu di vukisa bankwa ziphasi va ntoto. ");
INSERT INTO yom_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Bukiedika nganzi aku kuidi batu yinnatini nzitusu ; ayi bobo bavukidi mu nganzi aku, badi basimbudulu. ");
INSERT INTO yom_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Tambikanu zikhanu kuidi Yave Nzambi eno ayi dedikisanu ziawu ! Bika baboso badi mu nzunga ki mintoto, banata bakaba kuidi mutu wowo widi tsisi. ");
INSERT INTO yom_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Niandi weti bula phevi minyadi, niandi tsisi beta kummona kuidi mintinu mi ntoto. ");
INSERT INTO yom_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Nkunga Asafi kuidi Yedutuni, pfumu wu minyimbidi. Ndiyamikina kuidi Nzambi mu diambu di lusadusu ndiyamikina kuidi Nzambi mu kunguila. ");
INSERT INTO yom_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Thangu ndiba mu ziphasi, nditomba Yave ; va builu ndinonuna mioko miama mu kambu vonga ; ayi muelꞌama wumanga bombo. ");
INSERT INTO yom_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Ndietebukila moyo, a Nzambi, ayi ndikunga ; ndiyindula mu tsi ntima ayi pheve ama yivonga ngolo. ");
INSERT INTO yom_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Wekeba meso mama ma bika zibama, ndiba diaka mu phasi mu tuba. ");
INSERT INTO yom_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Ndiyindula bilumbu bivioka, mimvu mi thama. ");
INSERT INTO yom_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Ndieti tebukila minkunga miama moyo va builu, Ntima ama uyindula ku tsi ntima ayi pheve ama yikiyuvula : ");
INSERT INTO yom_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Pfumu wela tumbu loza kuandi mvimba e ? Kalendi buela monisa nlemvo andi ko e ? ");
INSERT INTO yom_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Luzolo luandi lungolo lusukidi kuandi mvimba e ? Zitsila ziandi mu zithangu zioso zikitukidi zi phamba e ? ");
INSERT INTO yom_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Nzambi wuzimbikini kuandi buela monisa nlemvo e ? Wuyimini kiadi kiandi mu diambu di nganzi e ? ");
INSERT INTO yom_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Buna ndiyindula “mu diambu diadi ndiela singimina : mimvu mi koko ku lubakala ku Nzambi yizangama.” ");
INSERT INTO yom_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Ndiela tebukila moyo mavanga ma Yave, bukiedika ndiela tebukila moyo bikumu biaku bi thama. ");
INSERT INTO yom_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Ndiela yindulanga mu tsi ntima bisalu biaku bioso ; ayi ndiela banzilanga mavanga maku moso ma lulendo. ");
INSERT INTO yom_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Zinzila ziaku, a Nzambi, zidi zinlongo ; nzambi mbi widi wunneni banga Nzambi eto e ? ");
INSERT INTO yom_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Ngeyo widi Nzambi yimvanganga bikumu ; Ngeyo weti monisa lulendo luaku muidi batu. ");
INSERT INTO yom_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Mu koko kuaku ku lulendo wukuidila batu baku, nkuna wu Yakobi ayi wu Zozefi. ");
INSERT INTO yom_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Minlangu mimmona, ngeyo a Nzambi ! Minlangu mimona ngeyo, ayi mikotadala zitsina zi minlangu zi nikuka. ");
INSERT INTO yom_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Matuti madukula minlangu ; diyilu diduma mu nzazi madionga maku matotuka ku ntuala ayi ku mbusa. ");
INSERT INTO yom_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Zinzazi ziaku ziwakana mu kimbongila ; zitsiemo zikienzula ntoto ; ntoto wunikuka ayi wutita. ");
INSERT INTO yom_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Nsolo aku wuviokila va khatitsika mbu, nzilꞌaku mu minlangu midi nguma, muna zithambi ziaku zisia monika ko. ");
INSERT INTO yom_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Wudiatisa batu baku banga nkangu wu mamemi, mu koko ku Moyize ayi Aloni. ");
INSERT INTO yom_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Nkunga Asafi. A batu bama, wanu malongi mama ! Dimbanu mambu ma munu ama. ");
INSERT INTO yom_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Ndiela zibula munu ama mu tuba zingana ayi ndiela samuna mambu ma suama, mambu makhulu ; ");
INSERT INTO yom_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","momo tuwa ayi momo tuzaba ayi momo bakulu beto batukamba ; ");
INSERT INTO yom_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Tulendi masuekila ko bana bawu ; tuela samuna kuidi tsungi yinkuiza mavanga ma Yave mafueti zitusu, lulendo luandi ayi matsiminanga momo kavanga. ");
INSERT INTO yom_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Wuvana zithumunu mu diambu di Yakobi. Wukubika Mina mu Iseli, ayi wutumina bakulu beto muingi bamilonga kuidi bana bawu ; ");
INSERT INTO yom_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","buna tsungi yinkuiza, yela zaba mawu buela bana bobo babutuki ko ayi bawu mamvawu mu thangu awu bela yolukila bana bawu ; ");
INSERT INTO yom_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","buna bela tula diana diawu mu Nzambi, ayi balendi zimbakana mavanga mandi ko, vayi bela keba zithumunu ziandi ; ");
INSERT INTO yom_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Balendi ba banga bakulu bawu ko ; tsungi yikambulu bulemvo, ayi tsungi yi matingu ; bobo mintima misia ba mifuana ko kuidi Nzambi bobo pheve yisia yikuikama kuidi Nzambi ko. ");
INSERT INTO yom_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Batu ba Efalayimi bobo baba ayi mimbasa, bavutuka ku mbusa mu lumbu ki mvita. ");
INSERT INTO yom_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Basi keba ko Nguizani yi Nzambi, ayi bamanga zingila boso buididi Mina miandi. ");
INSERT INTO yom_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Bazimbakana momo kavanga ; matsiminanga momo kabamonisa. ");
INSERT INTO yom_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Wuvanga bikumu va ntuala bakulu bawu mu tsi yi Ezipite ; mu zunga ki Tsowani. ");
INSERT INTO yom_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Wuvasa mbu ayi wuba viokila muawu ; wutelimisa nlangu dio ngui banga baka. ");
INSERT INTO yom_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Wuba diatisa mu dituti va muini, ayi mu kiezila ki mbazu va builu bu mvimba. ");
INSERT INTO yom_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Wubasa matadi mu dikanga, ayi wuba vana nlangu wuwombo banga mbu ; ");
INSERT INTO yom_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Wutotula mimvuila minlangu mu ditadi ayi wukumbisa minlangu banga minlangu minneni. ");
INSERT INTO yom_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Vayi babuela tatamana sumuka diaka va ntualꞌandi ; batinguna Nzambi Yizangama mu dikanga. ");
INSERT INTO yom_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Batota Nzambi mu luzolo lungolo, mu lombanga mu kingolo bidia biobi batomba. ");
INSERT INTO yom_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Batubidila Nzambi batuba : “Nzambi beki kuandi bu kubikila meza mu dikanga e ? ");
INSERT INTO yom_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Bu kabula ditadi dingolo, mbadi nlangu wutotuka ayi mimvuila mikumba mu buwombo vayi buna wulendi kuandi kutuvana bidia e ? Wulendi kuandi kubika zimbizi mu diambu di batu bandi e ?” ");
INSERT INTO yom_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Yave bu kaba wa, wufuema ngolo, mbazu andi yilema mu diambu di Yakobi ayi miangu miandi mibuila Iseli. ");
INSERT INTO yom_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Bila basia wilukila Nzambi ko, voti basia tula diana diawu mu khudulu andi ko. ");
INSERT INTO yom_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Muaki wuvana lutumunu kuidi matuti ma yilu ayi wuzibula mielo mi diyilu ; ");
INSERT INTO yom_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Wunokisa mana mu diambu di batu muingi badia ; wuba vana zitheti zi diyilu. ");
INSERT INTO yom_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Batu badia dipha di zimbasi ; wuba fidisila bidia bioso biobi balenda dia. ");
INSERT INTO yom_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Wuvevumuna phemo yi Esite mu diyilu. Wudiata ku ntuala phemo yi Sude mu lulendo luandi. ");
INSERT INTO yom_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Wuba nokisila zimbizi banga mbungi-mbungi ; zinuni zieti dumuka banga nzielo yi mbu. ");
INSERT INTO yom_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Wuba buisila biawu va khatitsika ka kiawu ; muyenda zinzo ziawu zioso zingoto. ");
INSERT INTO yom_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Badia nate bayukuta kuwombo ; ayi wuba vana biobi baleba mu kingolo. ");
INSERT INTO yom_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Tuamina batamba bidia biobi baleba mu kingolo mbusa, buela bikidi mu miunu miawu. ");
INSERT INTO yom_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Nganzi yi Nzambi yi babuila ; wuvonda bobo baluta ba zinitu zingolo mu bawu ; wuvonda bana ba matoko ma Iseli. ");
INSERT INTO yom_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Ka diambu ko mambu moso momo, batatamana vola masumu ka diambu ko matsiminanga mandi, basia wilukila ko. ");
INSERT INTO yom_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Buna wumanisa bilumbu biawu mu phamba ayi mimvu miawu mu tsisi. ");
INSERT INTO yom_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Kadika khumbu kaba kuba vondanga, tombanga baba kuntombanga, balukanga nsualu-nsualu diaka kuidi niandi. ");
INSERT INTO yom_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Batebuka moyo ti Nzambi niandi wuba dibanga diawu ayi Nzambi Yizangama niandi nkudi awu. ");
INSERT INTO yom_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Vayi buna bankamba mambu ma lueki mu miunu miawu bamvuna mu ludimi luawu. ");
INSERT INTO yom_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Mintima miawu misia ba mifuana kuidi niandi ko basia ba bakuikama ko mu Nguizani andi. ");
INSERT INTO yom_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Vayi niandi wuba nkua kiadi wuba lemvukila mambimbi mawu kasia babunga ko thangu ka thangu wudekula nganzi andi ayi kasia totula ko miangu miandi mioso. ");
INSERT INTO yom_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Wutebuka moyo ti baba minsuni kaka ; phemo yeti vioka yoyi yilendi vutuka ko. Ayi wulendi buela vutuka ko. ");
INSERT INTO yom_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Zikhumbu ziwombo bantingunina mu dikanga, ayi bansoka mu bibuangu bikambulu batu. ");
INSERT INTO yom_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Khumbu ka khumbu baba vutukilanga diaka tota Nzambi ; bafuemisa mutu wunlongo wu Iseli kiadi. ");
INSERT INTO yom_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Basia tebukila ko moyo lulendo luandi mu lumbu kioki kaba kula mu mioko mi mutu wuba yamisa ; ");
INSERT INTO yom_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","mu lumbu kamonisa bidimbu bi bikumu biandi mu Ezipite, mambu mandi matsiminanga mu ndambu tsi yi Tsowani ");
INSERT INTO yom_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","wukitula minlangu miawu menga ; basia buela baka bumina mu mimvuila mi minlangu miawu. ");
INSERT INTO yom_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Wufidisa nkangu zinzinzi ziozi zibadia ayi zinguanga ziozi zi babunga. ");
INSERT INTO yom_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Wavana mimbutu miawu mu zitsola kuidi binzienzi biobi basala kuidi makhoko. ");
INSERT INTO yom_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Wumana bunga zindima ziawu zi vinu mu mvula yi matadi ayi minti miawu mi sikomole mu kiozi ki ngolo, ");
INSERT INTO yom_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","wuyekula bibulu biawu kuidi mvula yi matadi ayi minkangu mi mamemi mawu kuidi lusiemo. ");
INSERT INTO yom_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Wuba fidisila nganzi andi yi mbazu, miangu miandi mi ngolo khakumusu, kimbeni weti bunga ");
INSERT INTO yom_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Wukubika nsolo mu diambu di nganzi andi kasia kuba tanina ko mu lufua ; vayi wuba yekula mu minsongo ; ");
INSERT INTO yom_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Wuvonda bana boso batheti bababakala ba Ezipiti mimbutu mitheti mi zingolo mu zinzo zi ngoto zi Hami. ");
INSERT INTO yom_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Vayi wutotula batu bandi banga mamemi ; wuba tuadisa banga nkangu wu bibulu mu dikanga. ");
INSERT INTO yom_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Wuba diatisila mu luvovomo ; diawu basia mona tsisi ko ayi mbu wumina bambeni ziawu. ");
INSERT INTO yom_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Buna wuba kotisa mu yenda tsi andi yinlongo ; ku tsi yi mongo wowo koko kuandi ku lubakala kukibakila. ");
INSERT INTO yom_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Wukuka makanda ku ntualꞌawu ; ayi wuba kabudila mintoto miawu banga kiuka wuvuandisa makanda ma Iseli mu zinzo ziawu. ");
INSERT INTO yom_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Vayi batota Nzambi ayi batinguna Nzambi Yizangama ; basia keba zinzengolo ziandi ko. ");
INSERT INTO yom_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Banga madisa mawu basia ba bafuana ko ayi basia ba minu ko balendi tudulu diana ko banga wuvenga. ");
INSERT INTO yom_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Bamfuemisa mu bibuangu biawu bizangama balemisa kiphala kiandi mu bitumba biawu ");
INSERT INTO yom_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Nzambi bu kawa, buna wufuema ngolo wutumbu loza mvimba Iseli. ");
INSERT INTO yom_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Wuyekula, nzo ngoto mbuabununu yi Silo ; nzo yoyo mu kakivuandisa ; ");
INSERT INTO yom_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Wufidisa kesi yi lulendo luandi mu buvika, ayi kiezila kiandi mu mioko mi mbeni. ");
INSERT INTO yom_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Wuyekula batu bandi mu sabala, wufuemina ngolo kiuka kiandi. ");
INSERT INTO yom_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Mbazu yi zinisa bamatoko mawu, ayi bandumba ziawu ziozi zisia zaba babakala ko zisia baka ko minkunga mi makuela ko. ");
INSERT INTO yom_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Zinganga ziawu zinzambi zimana fuila mu sabala ayi mafuola mawu masia baka bu didila ko. ");
INSERT INTO yom_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Buna Yave wukotuka banga mutu wuba wuleka, banga mutu kotukidi mu diambu di vinu kakololo. ");
INSERT INTO yom_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Wuvutula bambeni bandi ku manima ; wuzifuisa zitsoni ka zisukanga ko. ");
INSERT INTO yom_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Buna wuloza zinzo zi ngoto zi Zozefi, kasia sobula ko dikanda di Efalayimi ; ");
INSERT INTO yom_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Vayi wusobula dikanda di Yuda, mongo wu Sioni, wowo kazola. ");
INSERT INTO yom_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Wutunga buangu kiandi kinlongo banga bibuangu bizangama, banga ntoto wowo kakubika mu zithangu zioso zi kazimani. ");
INSERT INTO yom_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Wusobula Davidi kisadi kiandi ayi wumbonga mu ziphangu zi mamemi, ");
INSERT INTO yom_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Wumbongila vana vaba mamemi momo kaba sunga mu diambu di kaba nsungi wu batu bandi Yakobi, wu Iseli kiuka kiandi. ");
INSERT INTO yom_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Buna Davidi wuba nsungi awu mu ntima wufuana ayi wuba diatisila mu koko ku diela. ");
INSERT INTO yom_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Nkunga Asafi. A Nzambi ! Makanda mabulumukini kuika kiaku, Masumuna nzoꞌaku yinlongo, makitula Yelusalemi kunza ki matadi. ");
INSERT INTO yom_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Bavana zinitu zifua zi bisadi biaku banga bidia kuidi zinuni zi diyilu minsuni mi banlongo baku kuidi bibulu bi ntoto ; ");
INSERT INTO yom_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Batengudi menga banga nlangu mu yendila Yelusalemi ayi kusia monika ko mutu mu zika. ");
INSERT INTO yom_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Tuyikidi bila ki lusembo kuidi bafikimini yeto ; mvuezolo ayi kisekonono kuidi bobo batuzungididi. ");
INSERT INTO yom_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Nate thangu mbi, a Yave ? Wela fueminanga mu zithangu zioso e ? Nate thangu mbi kiphala kiaku kiela leminanga banga mbazu e ? ");
INSERT INTO yom_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Dukula miangu miaku kuidi makanda momo masia kuzaba ko, kuidi bipfumu biobi kabi telanga ko dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Bila bameni dia Yakobi, ayi bamana tiolumuna tsi andi yikabutukila. ");
INSERT INTO yom_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Kadi kututangila masumu ma bakulu ! Bika kiadi kiaku kiza nsualu kuidi beto bila tueka mu mabienga makambulu diana. ");
INSERT INTO yom_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Wutusadila, a Nzambi Mvulusi eto mu diambu di nkembo wu dizina diaku ! Wutukuidi ayi wutulemvukila masumu meto mu diambu di dizina diaku ! ");
INSERT INTO yom_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Bila mbi makanda meti tubila : “Kuevi kuidi Nzambi e ?” va ntuala meso meto, zabikisa va khatitsika makanda ti ngeyo weti vutula landi mu menga matenguka ma bisadi biaku, ");
INSERT INTO yom_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Bika kunga ku batu badi mu nloko kutula va ntualꞌaku. Mu zingolo zi koko kuaku, tanina bobo bazengolo nkanu wu lufua. ");
INSERT INTO yom_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Vutudila mu zikhumbu tsambuadi bifingu bi bobo batufikimini ; tsembolo yoyi bawobudila ngeyo Yave. ");
INSERT INTO yom_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Buna beto batu baku, nkangu aku wu mamemi weti dikila ; tuela kuzitisa mu zithangu zioso ; mu tsungi ka tsungi, tuela yolukila minzitusu miaku. ");
INSERT INTO yom_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Nkunga Asafi kuidi pfumu minyimbidi ; kayimbidila mu “Lisi”. Bika wutuwila, a Nsungi Iseli, ngeyo wundiatisanga Zozefi banga nkangu wu mamemi ; Ngeyo wumvuandanga va khatitsika ba Bakeluba, kienzula kuaku. ");
INSERT INTO yom_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Va ntuala Efalayimi, Benzami ayi Manase ! Telimisa zingolo ziaku yiza ayi wutuvukisa. ");
INSERT INTO yom_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Wutuvutula banga bututuama bela, a Nzambi bika zizi kiaku kitukienzula muingi tuvuka. ");
INSERT INTO yom_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Yave, Nzambi nkua ngolo yoso, nate thangu mbi nganzi aku yela leminanga ? Mu diambu di zitsambulu zi batu baku e ? ");
INSERT INTO yom_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Ngeyo wuba dikila mu dipha di matsuela ayi ngeyo wuba nuikina matsuela mu mbungu yiwala. ");
INSERT INTO yom_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Wutukitula tho yi minzonza kuidi bobo bafikimini yeto ayi bambeni zieto zilembo kutusekinina. ");
INSERT INTO yom_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Wutuvutula banga bututuama bela, a Nzambi nkua ngolo yoso Bika zizi kiaku kitukienzula muingi tuvuka. ");
INSERT INTO yom_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Ngeyo wutumuna nti wu vinu ku Ezipite, wukuka makanda ma Bapakanu bosi wukuna wawu. ");
INSERT INTO yom_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Ngeyo wukubikila wawu ntoto ayi wawu wumenisa mianzi ayi wudukila tsi. ");
INSERT INTO yom_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Miongo mifuku kuidi phonzi andi, sedeli mi lulendo kuidi matafi mandi. ");
INSERT INTO yom_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Wufidisa mawu nate ku mbu ayi mintuidila miandi nate ku minlangu minneni. ");
INSERT INTO yom_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Bila mbi wutiolumunini bibaka biandi e ? Muingi batu boso bamviokila vana bavela makundi mandi. ");
INSERT INTO yom_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Ngulu yi nsitu yeti kuyikesikisa ; ayi bivangu bi zitsola bilembo dia biawu. ");
INSERT INTO yom_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Wutuvutukila, a Nzambi nkua ngolo yoso ayi ku tsi tona ku diyilu ayi mona keba nti wawu wu vinu ; ");
INSERT INTO yom_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Muanzi wowo koko kuaku ku lubakala ku kuna, Muana wu bakala wowo wuyundula mu diambu diaku veka. ");
INSERT INTO yom_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Nti aku wu vinu wuzengulu, wuyokolo ku mbazu mu tsembolo aku, batu baku balembo bivi. ");
INSERT INTO yom_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Bika koko kuaku kuba vadi mutu wowo widi koko kuaku ku lubakala muana wubakala wu mutu wowo wuyundula mu diambu diaku veka. ");
INSERT INTO yom_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Buna tulendi buela kutatukila ko. Wutuzingisa diaka buna tuela tela dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Wutuvutula banga bu tutuama bela, a Yave Nzambi. Bika zizi kiaku kitukienzula muingi tuvuka. ");
INSERT INTO yom_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Nkunga Asafi kuidi pfumu minyimbidi ; kayimbidila mu ngitala yi basi Ngati. Yimbidilanu Nzambi mu khini ; niandi zingolo zieto ! Yamikinanu kuidi Nzambi yi Yakobi ! ");
INSERT INTO yom_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Tonanu miziki, sikanu zindungu ; Bulanu minningu mu Ngitala ayi lu Lila. ");
INSERT INTO yom_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Sikanu phoka yi dimemi va ntotukila ngondi yi mona ; ayi Ngondi bu yidi yiduka ayi mu lumbu ki nyengo eto ! ");
INSERT INTO yom_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Yayi yidi nzengolo mu diambu di Iseli, ayi tsikudukusu yi Nzambi yi Yakobi, ");
INSERT INTO yom_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Wukindisa yawu banga nsiku mu diambu di Zozefi mu thangu kanuanisa tsi yi Ezipite… Kuna tuwa mbembo yoyi tusia sudika ko. ");
INSERT INTO yom_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Tubidi : “Ndibotudi mfuna wubedi va mavangiti mawu. Ayi babotudi pani kibedi mu mioko miandi. ");
INSERT INTO yom_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Mu ziphasi ziaku, ngeyo wutela ayi ndikula ndivana mvutu ku tsi dumu ki matuti nditota ku minlangu mi Meliba. ");
INSERT INTO yom_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Wanu beno batu bama, ayi ndiela kululubula : enati beno luzola ku ndimba, a Iseli. ");
INSERT INTO yom_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Kulendi ba kadi nzambi yi nzenza ko va khatitsikꞌaku. Kulendi buongimina nzambi yi nzenza ko ! ");
INSERT INTO yom_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Minu ndidi Yave, Nzambi, yoyi yilutotula mu tsi Ezipite ; zibula bumboti munu aku ayi ndiela ku wuwesa. ");
INSERT INTO yom_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Vayi batu bama basia zola ku ndimba ko ; Iseli kasia kuthumukina ko. ");
INSERT INTO yom_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Buna ndiba yekula mu mintima miawu mingolo ; mu landakana zikhanu ziawu veka. ");
INSERT INTO yom_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Enati batu bama bandima kuama, enati Iseli wuzola landakana zinzila ziama ! ");
INSERT INTO yom_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Nganu mu nsualu ndieka tumbu kuba yekudila bambeni ziawu ayi balula koko kuama kuidi bobo beti kuba lenda. ");
INSERT INTO yom_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Bobo beti lenda Yave balenda kukikulula va ntualꞌandi ayi nganu thumbudulu awu yela zingilanga mu zithangu zioso ; ");
INSERT INTO yom_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Vayi nganu ngeyo wudikulu mu ble yilutidi kitoko, mu niosi yintotukila mu ditadi, ndiela kuyukutisila.” ");
INSERT INTO yom_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Nkunga Asafi. Nzambi telimini va lukutukunu lunneni. Wulembo vani nzengolo va khatitsika “zinzambi”. ");
INSERT INTO yom_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Nate thangu mbi luela nuaninanga mutu kambulu wusonga ayi luela monisinanga thalu yi zizi kuidi batu bambimbi e ? ");
INSERT INTO yom_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Nuanina mutu wulebakana ayi muana wusana. Luvanga malulama kuidi nsukami ayi kuidi mutu weti yamusu. ");
INSERT INTO yom_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Kulanu mutu wulebakana ayi nsukami ; bika luba vukisa mu mioko mi batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Basi zaba kadi diambu ko ayi basudikanga kadi diambu ko ; Mu tombi beti diatila ; zifundasio zioso zi ntoto zilembo nikuka. ");
INSERT INTO yom_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Minu ndituba : “luidi zinzambi ayi beno boso luidi bana ba Nzambi yizangama.” ");
INSERT INTO yom_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Vayi luela fua banga batu boso, luela bua banga woso kuandi nyadi. ");
INSERT INTO yom_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Telama, a Nzambi, sambisa ntoto ! Bila makanda moso madi kiuka kiaku. ");
INSERT INTO yom_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Nkunga Asafi. A Nzambi, kadi ba dio sui ! Kadi kanga munu, a Nzambi ayi kadi dingalala ! ");
INSERT INTO yom_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Tala, phila bambeni ziaku zilembo tudila divunzi ; bobo beti kulenda balembo vumuna mintu miawu. ");
INSERT INTO yom_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Mu diela dimbimbi, balembo yendila batu baku manenga ; balembo fiedi batu baku bobo weti belanga mayindu. ");
INSERT INTO yom_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Batuba : “yizanu, bika tuba bunga banga dikanda, mu diambu di dizina di Iseli dibika buela tebukulungu moyo”. ");
INSERT INTO yom_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Mu mabanza mamosi, bakutakana mu fiela, bavangi nguizani mu diambu di kunuanisa ; ");
INSERT INTO yom_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Zinzo zi ngoto zi Edoni ayi zi basi Isimayeli, zi Mowabi ayi zi basi Hangali, ");
INSERT INTO yom_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Nguebali ; Amoni, Amaleki basi Filisitini va kimosi ayi basi Tila ; ");
INSERT INTO yom_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","ka diambu ko Asili mamvawu bafubakana yawu, mu buela zingolo kuidi nkuna wu Loti. ");
INSERT INTO yom_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Wuba vangila banga bu wuvangila Madiani, banga bu wuvangila Sisela, ayi Yabini ku nlangu wu Kisoni ; ");
INSERT INTO yom_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","bobo babiva ku Andoli ; bobo bakituka banga mbozi va ntoto. ");
INSERT INTO yom_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Kituka batu bawu banneni banga Olebi ayi Zeyebi, bana bawu boso ba mintinu banga Zeba ayi Tsalumuna, ");
INSERT INTO yom_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Bobo batuba : “bika tuziona mintoto mi Nzambi mindikulungu bibulu !” ");
INSERT INTO yom_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Wuba kitula banga kinzungidila ; A Nzambi ama, banga biti va ntuala phemo ; ");
INSERT INTO yom_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","banga mbazu yinzinisanga nsitu ; banga nlaki wu mbazu wunyoka miongo ! ");
INSERT INTO yom_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Buna wuba kukila mu vuka kiaku ki phemo ; wuba monisa tsisi mu vuka kiaku ki ngolo. ");
INSERT INTO yom_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Fuka bizizi biawu mu tsoni. Muingi batu batomba dizina diaku, a Yave ! ");
INSERT INTO yom_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Bika bafua tsoni ayi bamona tsisi mu zithangu zioso ; bika babiva mu kambu nzitusu. ");
INSERT INTO yom_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Bika wuba zabikisa ti ngeyo vuidi dizina di Yave ; ti ngeyo kaka Nzambi yizangama va ntoto wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Nkunga wu bana ba Kole kuidi pfumu minyimbidi ; bayimbidila mu ngitale yi basi Ngati. A phila lueki luidi mu buangu kiaku kioki weti vuanda ! A Nzambi, nkua ngolo yoso. ");
INSERT INTO yom_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Muelꞌama phuila widi ayi wulembo suki-suki mu diambu di luphangu lu Yave. Ntimꞌama ayi nsuni ama bilembo yamikina mu diambu di Nzambi yi moyo. ");
INSERT INTO yom_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Ka diambu ko dikuanga beki nzoꞌandi, ayi tsiodila mamvandi beki dianza diandi koko keti lundila bana bandi… buangu kifikimini ntalꞌaku A Yave nkua ngolo yoso, Ntinu ama ayi Nzambi ama ! ");
INSERT INTO yom_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Lusakumunu kuidi bobo beti vuanda mu Nzo aku ! Beti kuzitisa mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Lusakumunu kuidi batu bobo zingolo ziawu zidi mu ngeyo ; bobo bakubika mintima miawu mu kuenda sambila ku Yelusalemi. ");
INSERT INTO yom_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Bu bamviokanga mu ndimba wu Baka, buna beti kuwukitula buangu ki zitho zi minlangu ; mvula mamvandi wufukidila wawu mu bibuindi. ");
INSERT INTO yom_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Zingolo ziawu zieti buelama nate kadika mutu kammonika va ntuala Nzambi yi sioni. ");
INSERT INTO yom_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Wa lusambulu luama, a Yave, Nzambi nkua ngolo yoso, wundimba Nzambi yi Yakobi. ");
INSERT INTO yom_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Tala nkaku eto, a Nzambi Tadila mu nlemvo mutu aku wuvinda mafuta. ");
INSERT INTO yom_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Lumbu kimosi mu luphangu luaku kiviokidi mili di bilumbu kunkaka. Thidi kuama ba nsungi wu muelo mu nzo yi Nzambi ama ayi mu vuandanga mu zinzo zi ngoto zi batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Bila Yave Nzambi niandi thangu ayi nkaku, Yave wela vana nlemvo ayi nzitusu, kadi kima kimosi kimboti kalendi yimina ko bobo bandiatilanga mu kambu tsembolo. ");
INSERT INTO yom_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","A Yave nkua ngolo yoso ! Lusakumunu kuidi mutu wowo weti tula diana diandi mu ngeyo ! ");
INSERT INTO yom_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Nkunga bana ba Kole kuidi pfumu minyimbidi. Wumonisa nlemvo kuidi ntoto aku ; a Yave, wuvutula kiuka ki Yakobi. ");
INSERT INTO yom_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Wulemvukila mambimbi ma batu baku ; ayi wufuka masumu mawu moso. ");
INSERT INTO yom_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Wutula miangu miaku mioso va ndambu ayi wuvutikisa ntima mu nganzi aku. ");
INSERT INTO yom_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Wutuvutula banga bo tutuama bela, a Nzambi Mvulusi eto, wutumoni diaka khini. ");
INSERT INTO yom_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Mawuba mu nganzi kuidi beto mu zithangu zioso e ? Mawulambisa nganzi aku tsungi ka tsungi e ? ");
INSERT INTO yom_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Wukadi buela tuvutudila luzingu muingi batu baku bamona khini mu ngeyo e ? ");
INSERT INTO yom_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Wutumonisa luzolo luaku lu ngolo, a Yave, ayi wutuvani phulusu aku. ");
INSERT INTO yom_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Ndiela wa momo, Nzambi Yave kela tuba ; veni zitsila zi ndembama kuidi batu bandi, kuidi banlongo bandi vayi buna babika vutukila kilawu. ");
INSERT INTO yom_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Kiedika, phulusu andi yifikimini babo beti kunkinzikanga mu diambu di nkembo andi wuzingila mu ntoto eto. ");
INSERT INTO yom_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Luzolo ayi kikhuikizi bidengini ; busonga ayi ndembama bibumbisini. ");
INSERT INTO yom_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Kikhuikizi kitotukidi va ntoto ayi busonga buntala ku tsi tona ku diyilu. ");
INSERT INTO yom_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Buna Yave mamvandi wela vana biobio bidi bimboti ayi ntoto eto wela buta mimbutu miandi. ");
INSERT INTO yom_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Busonga buela kuntuaminina ku ntuala ayi buela kubika nzila mu diambu di bitambi biandi. ");
INSERT INTO yom_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Lusambulu lu Davidi. Wa, a Yave, ayi wuphani mvutu bila ndidi nkua kiadi ayi ndidi nsukami. ");
INSERT INTO yom_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Keba luzingu luama bila ndikiyekula kuidi ngeyo. Ngeyo Nzambi ama, vukisa kisadi kiaku kikusilanga diana. ");
INSERT INTO yom_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Bika wumbona kiadi, a Yave, Bila ngeyo ndieti tela mu lumbu kimvimba. ");
INSERT INTO yom_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Nata khini kuidi kisadi kiaku. Bila kuidi ngeyo, a Yave ndieti vumuna muelꞌama. ");
INSERT INTO yom_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Ngeyo widi wumboti ayi weti lemvukilanga ; ayi widi wufuluka mu mamboti kuidi bobo beti kutela. ");
INSERT INTO yom_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Wa lusambulu luama, a Yave ; wa bumboti yamikina kuama mu diambu di kiadi. ");
INSERT INTO yom_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Mu lumbu ki ziphasi ziama ngeyo ndiela tela, bila ngeyo wela kuphana mvutu. ");
INSERT INTO yom_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","A Va khatitsika zinzambi, kuisi ko yoyi yidedikini banga ngeyo, a Yave ayi kuisi ko mavanga madedakani banga maku. ");
INSERT INTO yom_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Makanda moso momo wuvanga mela kuiza ayi mela buongama va ntualꞌaku, a Yave, ayi mela nata nkembo kuidi dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Bila ngeyo widi wunneni ayi ngeyo wumvanganga mavanga matsiminanga ; ngeyo kaka Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Wundongi nzilꞌaku, a Yave ayi ndiela diatila mu bukiedika buaku ; bika wuphana ntima wukambu vasuka muingi ndikinzikanga dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Ndiela kuzitisa, a Yave Nzambi ama, mu ntimꞌama wumvimba ayi ndiela kembisanga dizina diaku mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Bila luzolo luaku luidi lunneni kuidi minu ngeyo wukhula mu zithipula zi tsi bafua. ");
INSERT INTO yom_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Batu baluniemo balembo nduanisa, a Nzambi ; ayi nkangu wu batu ba makhemi balembo tombi luzingu luama ; batu bakambulu thalu mu ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Vayi ngeyo, a Yave, weti mona kiadi ; yimonisanga nlemvo, wuvika fuemanga ko ; fulukidi mu luzolo ayi mu kikhuikizi. ");
INSERT INTO yom_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Baluka kuidi minu ayi wumboni kiadi ; vana zingolo ziaku kuidi kisadi kiaku ayi vukisa muana kisadi kiaku ki nketo. ");
INSERT INTO yom_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Bika wuphana dimbu ki mamboti maku muingi bambeni ziama zimona kiawu ayi bafua tsoni bila ngeyo Yave wutsadisidi ayi wumbombidi. ");
INSERT INTO yom_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Nkunga bana ba Kole. Wutula fondasio andi ku mongo wunlongo. ");
INSERT INTO yom_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Yave weti zola mielo mi Sioni viokila bibuangu bioso bimvuandanga Yakobi. ");
INSERT INTO yom_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Mambu ma nkembo matubu mu diambu diaku ; a divula di Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","“Ndiela yolukila Lahabi ayi Babiloni muidi bobo banzebi ; tsi yi Filisiti ayi Tila va kimosi ayi Kutsi : ayi tuba : mutu wawu ku Sioni kabutukila”. ");
INSERT INTO yom_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Buna mu diambu di Sioni ; bela tuba : “Mutu wawu ayi mutu wuna, mu niandi babutukila” ayi Nzambi yizangama, niandi wela kumbieka. ");
INSERT INTO yom_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Yave wela sonika batu mu buku : “mutu wawu ku Sioni kabutukila.” ");
INSERT INTO yom_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Bu balembo budi miziki, bela yimbila : “zitho ziama zioso zidi mu ngeyo.” ");
INSERT INTO yom_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Nkunga bana ba Kole kuidi pfumu minyimbidi ; bayimbidila mu flute. Nkunga Hemani muisi Ezilakite. A Yave, Nzambi yoyi yeti kuphukisa, muini ayi builu ndieti yamikina va ntualꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Bika lusambulu luama lutula va ntualꞌaku ; balula dikutu diaku bu ndilembo yamikina. ");
INSERT INTO yom_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Bila muelꞌama wufulukidi mu ziphasi ayi luzingu luama lufikimini tsi yi bafua. ");
INSERT INTO yom_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Ndidi mu ntanda wu batu bobo bankuenda ku diyilu ndieka banga mutu kambulu zingolo. ");
INSERT INTO yom_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Ndidi wuvuanda va ndambu lufua, banga batu bavondo ; bobo badi baleka mu ku tsi bafua ; bobo wunkambu buela tebukilanga moyo, bobo wusia buela bela mayindu ko. ");
INSERT INTO yom_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Ngeyo wuthula mu dibulu dinneni, mu tombi kinkobo. ");
INSERT INTO yom_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Miangu miaku mimbuila ayi zitu midi Minu ndidiamusu kuidi ngeyo mu mayo maku moso. ");
INSERT INTO yom_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Ngeyo wuphambisa mu bakundi bama bakiluzolo ngeyo wukhitula kima ki khemi kuidi bawu. Ndidi wukangama ayi ndilendi baka bu tinina ko. ");
INSERT INTO yom_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Meso mama meka mbumbuluka mu diambu di ziphasi ; ngeyo ndintela ; a Yave, kadika lumbu kuidi ngeyo ndinonuna mioko miama. ");
INSERT INTO yom_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Wulenda kuaku monisa matsiminanga maku kuidi mutu wufua e ? Bafua balenda fuluka ayi kuzitisa e ? ");
INSERT INTO yom_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Balenda yolukila luzolo luaku mu tsi bafua ayi kikhuikizi kiaku mu mbivusu e ? ");
INSERT INTO yom_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Matsiminanga maku malenda zabakanga mu bibuangu bidi tombi voti mavanga maku masonga mu ntoto wowo batu bazimbakana mambu moso e ? ");
INSERT INTO yom_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Vayi minu kuidi ngeyo ndinyamikina mu tomba lusadusu, mu nsuka lusambulu luama lunkuiza va ntualꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Bila mbi ngeyo Yave wundozidi e ? Ayi bila mbi wulembo tsuekila zizi kiaku e ? ");
INSERT INTO yom_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Tona mu bumuana buama minu ndidi mu phasi ndidi wukangama mu lufua Ndimona ziphasi mu tsisi aku ayi ndieka wukambu diana. ");
INSERT INTO yom_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Miangu miaku mingolo mimbuididi tsisi aku yimbunga. ");
INSERT INTO yom_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Mu lumbu kimvimba yawu yinzungidila banga khuka nlangu yawu yitungu kumbina mvimba. ");
INSERT INTO yom_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Ngeyo mu bandiatanga yama ayi mu bakiluzolo bama tombi kiawu nkundi ama wukuikama. ");
INSERT INTO yom_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Nkunga Etani muisi Ezilakite. Ndiela yimbidila mamboti manneni ma Yave mu zithangu zioso. Mu munu ama ndiela zabikisila kikuikizi kiaku muidi zitsungi zioso. ");
INSERT INTO yom_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Ndiela samuna ti luzolo luaku luidi lutelama dio ngui mu zithangu zioso. Ti ngeyo wutula kikhuikizi kiaku mu diyilu. ");
INSERT INTO yom_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Ngeyo wutuba : “nditula Nguizani ama ayi mutu ama wowo ndivinda mafuta ; Ndidia ndefi kuidi Davidi, kisadi kiama : ");
INSERT INTO yom_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Ndiela bieka nkunꞌaku mu zithangu zioso ; ayi ndiela kitula kundu kiaku ki kipfumu kikinda mu zitsungi zioso.” ");
INSERT INTO yom_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Diyilu dinzitisa matsiminanga maku, a Yave kikhuikizi kiaku mu lukutukunu lu banlongo. ");
INSERT INTO yom_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Bila nani mu matuti wulenda dedokoso banga Yave ? Widi banga Yave mu bivangu bi diyilu e ? ");
INSERT INTO yom_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Mu lukutukunu lu banlongo, Nzambi wulembo kinzuku ngolo tsisi kadi yiviokidi batu bobo banzungididi. ");
INSERT INTO yom_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","A Yave, Nzambi nkua ngolo yoso, nani widi banga ngeyo e ? Widi nkua ngolo, a Yave, ayi kikhuikizi kiaku kizungididi. ");
INSERT INTO yom_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Ngeyo weti yadila mbu wufuemini, Mayo mandi mawu telama ngeyo weti lembika mawu. ");
INSERT INTO yom_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Ngeyo wukosikisa Lahabi banga mutu wuvondo mu koko kuawu ku lulendo ngeyo wusasikisa bambeni ziaku. ");
INSERT INTO yom_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Ngeyo vuidi diyilu ayi ntoto diaka ngeyo vuidi wawu. Ngeyo wuvanga nza ayi bibio bidi muawu. ");
INSERT INTO yom_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Ngeyo wuvanga Nodi ayi Sude ; Taboli ayi Helimoni bieti yimbila mu khini mu diambu di dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Koko kuaku kufulukidi mu lulendo ; koko kuaku ngolo kuidi koko kuaku ku lubakala kuyayusu ngolo. ");
INSERT INTO yom_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Busonga ayi bufuana biawu fundasio yi kundu kiaku ki kipfumu. Luzolo ayi kikhuikizi bindiata ku ntuala. ");
INSERT INTO yom_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Lusakumunu kuidi batu bobo banlonguka kubudila zitsiaki ; bobo bandiatilanga mu kiezila ki meso maku, a Yave. ");
INSERT INTO yom_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Beti mona khini mu dizina diaku mu lumbu kimvimba beti yangalala mu busonga buaku. ");
INSERT INTO yom_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Bila ngeyo nkembo awu ayi zingolo ziawu ayi mu nlemvo aku, ngeyo wuyayisa phokꞌeto. ");
INSERT INTO yom_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Bukiedika, nkaku eto wuviulu kuidi Yave ntinu eto kuidi mutu wunlongo wu Iseli. ");
INSERT INTO yom_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Khumbu yimosi ngeyo wuyolukila mu tsongolo kuidi batu baku bakuikama ngeyo wutuba : “Ndivana zingolo kuidi mutu wu ngolo. Ndiyayisa muana ditoko va khatitsika batu. ");
INSERT INTO yom_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Ndibakula Davidi kisadi kiama, mu mafuta mama manlongo, minu ndimvindila. ");
INSERT INTO yom_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Koko kuama kuela kunsimba ; bukiedika koko kuama kuela kumvana zingolo. ");
INSERT INTO yom_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Kadi mbeni yimosi yilendi kutula ku tsi minsua miandi ko. Mu diambu di futa phaku. Kadi mutu wumosi wumbimbi kalendi kunyamisa ko. ");
INSERT INTO yom_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Ndiela kosikisa va meso mandi batu bobo beti kunlenda ayi ndiela buisa bobo beti kunlenda. ");
INSERT INTO yom_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Luzolo luama lukuikama luela ba yandi mpe mu dizina diama phoka ziandi ziela tombolo. ");
INSERT INTO yom_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Ndiela tula koko kuandi va mbata mbu ayi koko kuandi ku lubakala va mbata minlangu. ");
INSERT INTO yom_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Niandi wela kuthela : ‘Ngeyo widi dise diama, Nzambi ama ditadi dingolo Mvulusi ama.’ ");
INSERT INTO yom_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Ndiela kunsobula diaka muanꞌama wutheti wowo lutidi zangama mu mintinu mioso midi va ntoto. ");
INSERT INTO yom_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Ndiela simbidila luzolo luama va niandi mu zithangu ziozo ayi Nguizani ama va niandi yilendi ba babeba ko. ");
INSERT INTO yom_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Ndiela telimisa dio ngui nkunꞌandi mu zithangu zioso kundu kiandi ki kipfumu kiela zingila banga bilumbu bi diyilu. ");
INSERT INTO yom_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Enati bana bandi balozidi Mina miama ayi enati bakadi landakana zinzengolo ziama ; ");
INSERT INTO yom_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","enati babundudi zinzengolo ziama enati bakadi keba zithumunu ziama, ");
INSERT INTO yom_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","ndiela tumbudila masumu mawu mu lusuadi, mambimbi mawu mu bikoti ; ");
INSERT INTO yom_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","vayi ndilendi ba botula ko luzolo luama mu niandi ayi ndilendi tunuka kikhuikizi kiama ko. ");
INSERT INTO yom_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Ndilendi ba bundula Nguizani ama ko voti ndilendi balula ko mambu momo bididi biama matotula. ");
INSERT INTO yom_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Mu khumbu yimosi, ndidia ndefi mu bunlongo buama ayi ndilendi ba vuna Davidi ko. ");
INSERT INTO yom_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Buna nkunꞌandi wela zingilanga mu zithangu zioso ayi kundu kiandi ki kipfumu kiela zingila va ntualꞌama banga thangu. ");
INSERT INTO yom_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Kiela ba kitelama dio ngui mu zithangu zioso banga ngondi, mbangi yikuikama mu matuti.” ");
INSERT INTO yom_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Vayi ngeyo wunloza, wunlenza ; wuba wufuema beni kuidi mutu aku wudukudila mafuta. ");
INSERT INTO yom_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Ngeyo wuvonda Nguizani ayi kisadi kiaku ; ayi ngeyo wubundula budu ki kipfumu kiandi nate wuloza kiawu va difundu-fundu. ");
INSERT INTO yom_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Ngeyo wumana tiolumuna bibaka biandi bioso ayi wutula bisuamunu biandi bingolo mu mbivusu. ");
INSERT INTO yom_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Babo baviokila vana, banziona bima ; wuyika diambu di mvuezolo kuidi bafikimini yandi. ");
INSERT INTO yom_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Ngeyo wuzangula koko ku lubakala ku bobo bakunlendanga, wumonisa bambeni bandi zioso khini. ");
INSERT INTO yom_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Ngeyo wuvengumuna meno ma sabala kiandi ayi wusia kunsadisa ko mu mvita. ");
INSERT INTO yom_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Ngeyo wumanisa kiezila kiandi ayi wuloza kundu kiandi ki kipfumu va tsi. ");
INSERT INTO yom_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Ngeyo wukufisa bilumbu bi bumuana buandi ; wumfuka yunga ki tsoni. ");
INSERT INTO yom_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Nate thangu mbi a Yave wela suamina e ? Nate thangu mbi miangu miaku miela lemina banga mbazu e ? ");
INSERT INTO yom_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Tebuka moyo boso luzingu luama luididi lukhufi. A buevi, buna mu phamba kuandi wuvangila batu boso e ? ");
INSERT INTO yom_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Mutu mbi wowo lenda zinga ayi wela kambu mona lufua e ? Voti kukivukisa mu lulendo lu tsi yi bafua e ? ");
INSERT INTO yom_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","A Yave, kuevi kuidi luzolo luaku lunene lukhulu, mu lolo wuzengila ndefi mu kikhuikizi kiaku mu diambu di Davidi e ? ");
INSERT INTO yom_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Tebukila moyo a Pfumu, buevi kisadi kiaku bakisekinina ; buevi ndilembo natina mu ntimꞌama bifingu bi makanda moso. ");
INSERT INTO yom_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Bifingu biobi bambeni ziaku basekinina, biobi basekinina kadika thama yi mutu aku wowo wudukudila mafuta. ");
INSERT INTO yom_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Nzitusu kuidi Yave mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Lusambulu lu Moyize, mutu Nzambi. Yave, ngeyo wuba buangu kieto kivuanda mu tsungi ka tsungi. ");
INSERT INTO yom_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Tuamina miongo mibutuka voti tuamina wuvanga ntoto ayi nza ; tona mu thangu ka thangu, ngeyo widi Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Ngeyo wumvutulanga batu mu fundu-fundu bu weti tuba : “Vutuka mu fundu-fundu, e e bana ba batu.” ");
INSERT INTO yom_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Bila va meso maku mili di mimvu midedikini banga lumbu kimosi kiviokidi zono ; voti banga thangu yimosi va builu, ");
INSERT INTO yom_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","ngeyo weti botula batu mu tulu tu lufua, badi banga biti bimona va nsuka. ");
INSERT INTO yom_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Va nsuka bimenini bimona, va masika bilebukidi ayi biyumini. ");
INSERT INTO yom_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Tulembo lalakana mu diambu di nganzi aku ayi tsisi tulembo moni mu diambu di miangu miaku. ");
INSERT INTO yom_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Ngeyo wutudidi mambimbi meto va ntualꞌaku, masumu meto masuama va ntuala kiezila ki zizi kiaku. ");
INSERT INTO yom_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Bilumbu bieto bioso bilembo mani ku tsi nganzi aku ; tulembo manisa mimvu mieto ayi luniongo. ");
INSERT INTO yom_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Tezo ki bilumbu bieto kidi ki lusambudi lumimvu voti lunana enati ngolo zidi yeto. Sina kiawu kidi kaki kiphasi ayi kimianga. Bila luzingu lueti lulembo vioki nsualu ayi tulembo yendi. ");
INSERT INTO yom_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Nani zebi lulendo lu nganzi aku e ? Muingi miangu miaku miba tola banga lukinzu lolo fueni tambula. ");
INSERT INTO yom_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Wutulongisa tanga bilumbu bieto mu bufuana muingi tubaka ntima wu duenga. ");
INSERT INTO yom_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Bika buela fuema, a Yave. Nate thangu mbi mela bela e ? Bika wumona bisadi biaku kiadi. ");
INSERT INTO yom_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Mu nsuka, bika wutuyukutisa mu luzolo luaku lu ngolo ; buna tuela yimbilanga mu khini ayi buna tuela yangalala mu bilumbu bioso. ");
INSERT INTO yom_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Wutuyangidikanga boso buididi bilumbu biobi wutumonisina phasi boso buididi mimvu miomi tuyamusunu. ");
INSERT INTO yom_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Bika mavanga maku mamonoso kuidi bisadi biaku ; kiezila kiaku kuidi bana bawu. ");
INSERT INTO yom_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Bika nlemvo wu Yave, Nzambi eto wubanga va beto, bika mu diambu dieto, wukindisa kisalu ki mioko mieto. Nyinga, kindisa kisalu ki mioko mieto. ");
INSERT INTO yom_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Mutu wowo wumvuandanga ku tsi suamunu ki Nzambi yizangama, wela vundila ku tsi kitsusula ki Nzambi ngolo yoso. ");
INSERT INTO yom_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Ndiela tuba mu diambu di Yave : Niandi suamunu kiama ayi suamunu kiami kingolo. Nzambi ama, mu niandi ndintula diana. ");
INSERT INTO yom_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Bukiedika niandi wela ku vukisa mu ntambu ntambi wu zinuni, ayi mu nsongo weti vonda. ");
INSERT INTO yom_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Wela ku fukidila mu zitsala ziandi ayi ku tsi mavavi mandi, wela bakula suamunu. Kikhuikizi kiandi kiela ba nkaku aku ayi baka kiaku kizangama. ");
INSERT INTO yom_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Wulendi ko mona tsisi mu builu voti dionga dieti dumuka va muini ; ");
INSERT INTO yom_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","voti nsongo weti vonda, wumviokila mu tombi, voti vunga kieti bunga va muini ngembele. ");
INSERT INTO yom_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Mili yimosi yilenda bua va ndambu aku voti dikumi di mili va koko kuaku ku lubakala, vayi kadi diambu dimosi dilendi fikama ko va widi. ");
INSERT INTO yom_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Wela tala kaka mu meso maku ayi wela mona thumbudulu yi batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Enati kitudi Nzambi yizangama buangu kiaku weti vuanda bosi Yave, suamunu kiama. ");
INSERT INTO yom_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Buna kadi mbimbi yimosi yilendi kubuila ko ayi kadi vuku kimosi kilendi fikama va nzoꞌaku yi ngoto ko. ");
INSERT INTO yom_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Bila, mu diambu diaku, wela tumina zimbasi ziandi muingi zikeba mu zinzila ziaku zioso. ");
INSERT INTO yom_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Ziawu ziela kuvumuna mu mioko miawu mu diambu di kulu kuaku kuedi bumina thutu mu ditadi. ");
INSERT INTO yom_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Ngeyo wela diatidila khosi ayi kusa ; wela kosikisa khosi yiyunduka ayi nioka, ");
INSERT INTO yom_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Yave kembi : “sumbu keta kunzola ndiela ku nkula, ayi ndiela ku nkeba bila zebi dizina diama. ");
INSERT INTO yom_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Wela kuthela ayi ndiela kumvana mvutu. Ndiela banga yandi mu ziphasi ndiela ku nkula ayi ku nkinzika. ");
INSERT INTO yom_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Ndiela kunyukutisa mu luzingu lu mula ayi ndiela kummonisa phulusu ama.” ");
INSERT INTO yom_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Nkunga wu lumbu ki saba. Didi diambu dimboti mu zitisa Yave ayi bula miziki mu diambu di dizina diaku, a Nzambi yizangama, ");
INSERT INTO yom_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","mu yamikisa luzolo luaku mu nsuka ayi kikhuikizi kiaku va builu, ");
INSERT INTO yom_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","mu miziki dikumi di minsinga, di siku beti tedila Lila ayi mu nningu wu ngitala. ");
INSERT INTO yom_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Bila ngeyo wumbonisa khini mu mavanga maku, a Yave. Ndiela yimbila mu khini mu diambu di mavanga ma mioko miaku. ");
INSERT INTO yom_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","A phila tola mavanga maku madi, a Yave, a phila thipula mabanza maku madi ! ");
INSERT INTO yom_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Wukambulu diela kasi zaba ko vungisi kalendi sudika ko, ");
INSERT INTO yom_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","muingi ka diambu ko batu bambimbi banyunduka banga biti, ayi batu boso bamvanganga mambimbi bammonanga mamboti ; bela bungu mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Vayi ngeyo Yave widi wuyayusu mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Bukiedika bambeni ziaku, a Yave, bukiedika bambeni ziaku ziela biva bisadi bioso bieti vanga mambimbi biela sasukusu. ");
INSERT INTO yom_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Vayi ngeyo wela yayisa phokꞌama banga phoka phakasa. Mafuta mamosi ma kitoko mandukudulu. ");
INSERT INTO yom_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Buna meso mama mamona mbedosolo yi batu bobo beti kundenda ; makutu mama mawa biyoko bi batu bambimbi bantina, bobo beti kundenda. ");
INSERT INTO yom_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Batu basonga bela mona mamboti banga diba, bela yunduka banga sedeli wu Libani ; ");
INSERT INTO yom_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","bakunu mu nzo Yave, bela mona mamboti mu ziphangu zi Nzambi eto ; ");
INSERT INTO yom_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","bela buta mimbutu banza mu bununu buawu bu ngolo ; badi kaka banlangu ayi meza ma nlangu madi yawu. ");
INSERT INTO yom_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Mu yamikisanga Yave widi wululama Niandi ditadi diama ayi mambimbi masi ko mu niandi. ");
INSERT INTO yom_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Yave weti yala, vueti nzitusu, Yave vueti nzitusu ayi wukivuatisidi zingolo. Nza yidi yikindusu dio ngui ; yilendi nikuka ko. ");
INSERT INTO yom_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Kundu kiaku ki Kipfumu kikibiekolo tona thama ; ngeyo widi tona mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Mimbu mifuemini, a Yave ; mimbu miwakisidi zimbembo ziawu, mimbu miwakikisidi mayo mawu mankumba. ");
INSERT INTO yom_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Lulendo viokila dumu ki minlangu minneni lulendo viokila bobo beti basa mimbi Yave lulendo kadi mu diyilu. ");
INSERT INTO yom_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Zinzengolo ziaku zidi zitelama dio ngui. Bunlongo bueti monisanga kitoko mu nzo aku, a Yave, mu bilumbu bikambulu tsukulu, a Yave. ");
INSERT INTO yom_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","A Yave, Nzambi wumvutulanga landi. A Nzambi, wumvutulanga landi ; bika wukimonisa ! ");
INSERT INTO yom_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Telama kuaku ngeyo zuzi di ntoto ; bika wuvutudila batu badi luniemo momo bafueni tambula. ");
INSERT INTO yom_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Nate thangu mbi batu bambimbi, a Yave ? Nate thangu mbi batu bambimbi bela monanga khini e ? ");
INSERT INTO yom_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Bawu balembo muangisa mambu ma luniemo. Batu boso bobo beti vanga mambimbi bafulukidi mu luyanu. ");
INSERT INTO yom_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Bawu balembo diatidila batu baku, a Yave, balembo yamisa kiuka kiaku. ");
INSERT INTO yom_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Balembo vondi difuola ayi nkebi ; balembo vondi bana ba sana. ");
INSERT INTO yom_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Balembo tubi : “Yave kakadi mona ayi Nzambi yi Yakobi kakadi matala.” ");
INSERT INTO yom_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Lukeba beno bakambulu diela luidi va khatitsika batu ! Bosi beno bivungisi thangu mbi luela bela nzayilu e ? ");
INSERT INTO yom_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Niandi wutula dikutu kalendi wa ko e ? Niandi wukubika dieso kalendo mona ko e ? ");
INSERT INTO yom_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Niandi weti vana makanda thumbudulu makanda kalendi vana thumbudulu ko e ? Niandi ko weti longa mutu kambulu nzayilu e ? ");
INSERT INTO yom_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Yave zebi mayindu ma mutu ; zebi ti mawu madi kaka maphamba. ");
INSERT INTO yom_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Lusakumunu kuidi mutu wowo weti vana thumbudulu, a Yave, mutu wowo weti longila mu Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Weti kumvana lusadusu mu bilumbu bi phasi nate dibulu dinneni diela mana kabu mu diambu di batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Bila Yave kalendi yekula batu bandi ko kalendi loza kiuka kiandi ko. ");
INSERT INTO yom_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Tsambusu yela buela ba diaka yisonga ayi baboso bobo badi mintima milulama bela landakana yawu. ");
INSERT INTO yom_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Nani wela kuthelumina va ntuala batu bambimbi e ? Nani wela telama mu diambu diama mu nuanisa bobo bamvanganga mambimbi e ? ");
INSERT INTO yom_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Enati Yave kasia kuphana lusadusu ko nganu mu thinu nsualu ndivuandila dio sui mu lufua. ");
INSERT INTO yom_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Mu thangu ndituba ; “kulu kuama kueka sialumuka” ; luzolo luaku, a Yave, lutsimba. ");
INSERT INTO yom_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Mu thangu mayindu maba mawombo mu minu ; mbombolo aku yinata khini mu muelꞌama. ");
INSERT INTO yom_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Kundu ki luyalu ki batu bamvanganga mambimbi kilenda ba kithuadi ayi ngeyo ko e ? Kioki kinatanga khuamusu mu zinzengolo ziandi e ? ");
INSERT INTO yom_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Bankutakananga mu nuanisa batu basonga ayi zengila mutu kambu bila nkanu wu lufua. ");
INSERT INTO yom_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Vayi Yave wuyika suamunu kiama kingolo ; ayi Nzambi ama niandi ditadi dingolo diodi ndieti suamina. ");
INSERT INTO yom_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Wela kuba vutudila mu diambu di masumu mawu, ayi wela kuba bunga mu diambu di mambimbi mawu. Yave, Nzambi eto, wela kuba bunga. ");
INSERT INTO yom_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Yizanu, bika tuyimbidila Yave mu khini. Bika tuyamikina kuidi ditadi di phulusu eto. ");
INSERT INTO yom_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Bika tuizanu ku ntualꞌandi mu vana matondo tunyayisa mu miziki ayi mu minkunga. ");
INSERT INTO yom_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Bila Yave widi Nzambi yinneni, ntinu wunneni va yilu zinzambi zioso. ");
INSERT INTO yom_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Va koko kuandi muidi vadi phinda zi ntoto zitsongi zi miongo zivuiwulu kuidi niandi. ");
INSERT INTO yom_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Mbu wandi bila niandi veka wuvanga wawu ayi mioko miandi mivanga ntoto wu yuma. ");
INSERT INTO yom_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Yizanu bika tukikulula mu buongama, bika tufukamanu va ntuala Yave mvangi eto. ");
INSERT INTO yom_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Bila niandi Nzambi eto ayi beto tuidi batu bandi keta dikila, nkangu mamemi mu ku tsi lukebolo luandi. Enati lumbu kiaku luwilu mbembo andi, ");
INSERT INTO yom_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","lubika kitula mintima mieno ngolo banga bu luvangila Meliba, banga bu luvangila mu lumbu ki Masa mu dikanga ; ");
INSERT INTO yom_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Kuna madise beno bathotila ayi batsokila ; ka diambu ko bamona momo ndivanga. ");
INSERT INTO yom_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Mu makumaya ma mimvu, ndiba mu nganzi kuidi tsungi yina ; ndituba : “badi batu badi mintima mizimbila ayi basia zaba zinzila ziama ko.” ");
INSERT INTO yom_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Diawu ndizengila ndefi ku tsi nganzi ama : “balendi kota ko mu luvundulu luama.” ");
INSERT INTO yom_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Luyimbidila Yave nkunga wumona. Luyimbidila Yave, ntoto wumbimba. ");
INSERT INTO yom_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Luyimbidila Yave, zitisanu dizina diandi ; yamikisanu phulusu andi lumbu ka lumbu. ");
INSERT INTO yom_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Yolukilanu nkembo andi muidi makanda mambu mandi matsiminanga muidi batu boso. ");
INSERT INTO yom_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Bila Yave widi wunneni ayi lutidi mu zitusu ; tsisi kadi va yilu zinzambi zioso. ");
INSERT INTO yom_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Bila zinzambi zi makanda zidi bitumba ; vayi Yave niandi wuvanga diyilu. ");
INSERT INTO yom_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Kiezila ayi nzitusu bidi va ntualꞌandi zingolo ayi nkembo bidi mu buangu kiandi ki nlongo. ");
INSERT INTO yom_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Luvana kuidi Yave, e mabuta ma makanda ; luvana kuidi Yave nkembo ayi ngolo. ");
INSERT INTO yom_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Luvana nkembo kuidi Yave wufueni mu dizina diandi. Lunata dikaba ayi lukota mu ziphangu ziandi. ");
INSERT INTO yom_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Lubuongimina Yave mu kiezila ki bunlongo buandi. Tita va ntualꞌandi, ntoto wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Tuba muidi makanda : “Yave weti yala.” Nza yidi yikinda dio ngui ; yilendi nikuka ko bila Yave wela sambisa batu mu bufuana. ");
INSERT INTO yom_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Bika diyilu dimona khini, bika ntoto wuyangalala. Bika mbu wutula biyoko ayi bibio bidi muna. ");
INSERT INTO yom_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Bika zitsola zimona khini ayi bibio bidi muna ; buna minti mioso mi nsitu miyimbila mu diambu di khini. ");
INSERT INTO yom_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Miela yimbila va ntuala Yave, bila wulembo yizi, wulembo yizi mu sambisa ntoto. Wela sambisa nza mu busonga ayi batu mu Kedika kiandi. ");
INSERT INTO yom_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Yave weti yala, bika ntoto wuyangalala. Bika bisanga biobi bidi thama bimona nkini. ");
INSERT INTO yom_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Matuti ayi tombi kinkobo binzungididi. Busonga ayi bufuana biawu fundasio yi kundu kiandi ki kipfumu. ");
INSERT INTO yom_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Mbazu yeti kuenda ku ntualꞌandi ayi yeti zinisa batu bobo beti kunlenda ku kadika ndambu ");
INSERT INTO yom_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Zitsiemo ziandi zieti kienzula nza, ntoto weti mona ayi weti tita. ");
INSERT INTO yom_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Miongo misiuta banga mafuta momo beti vinda mu bikundu va ntuala Yave, va ntuala Yave wu ntoto wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Diyilu dieti yamikina busonga buandi ayi batu boso beti mona nkembo andi. ");
INSERT INTO yom_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Babo bobo bambuongiminanga zimfikula beti fua tsoni ; bobo beti kukiniemisa mu diambu di bitumba. Lumbuongimina, beno zinzambi zioso. ");
INSERT INTO yom_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Sioni weti wa ayi weti mona khini ayi bana ba baketo ba Yuda beti yangalala mu diambu di zinzengolo ziaku, a Yave. ");
INSERT INTO yom_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Bila ngeyo Yave, widi Nzambi yizangama va ntoto wumvimba. Ngeyo widi wuyayusu ngolo va yilu zinzambi zioso. ");
INSERT INTO yom_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Bika babo beti zola Yave, balenda mambimbi. Bila weti keba luzingu lu banlongo bandi. Niandi wukubakulanga mu mioko mi batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Kiezila kieti totuka mu diambu di batu basonga ayi khini mu diambu di bobo badi lulama mu mintima. ");
INSERT INTO yom_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Bika lumona khini mu Yave, beno luidi basonga ayi luzitisa dizina diandi di nlongo. ");
INSERT INTO yom_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Nkunga. Yimbidilanu Yave nkunga wumona bila wuvengi mambu ma kitoko. Koko kuandi ku lubakala ayi koko kuandi kunlongo mivengi phulusu mu diambu diandi. ");
INSERT INTO yom_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Yave wuzabikisa phulusu andi ; ayi wumonisa busonga buandi kuidi makanda. ");
INSERT INTO yom_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Wutebukila luzolo luandi moyo ayi kikhuikizi kiandi kuidi nzo yi Iseli. Zitsukusunu zioso zi ntoto zimona phulusu yi Nzambi eto. ");
INSERT INTO yom_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Yamikina mu khini kuidi Yave, ntoto wumvimba ; ludila mu nkunga mi mayangi va kimosi ayi miziki. ");
INSERT INTO yom_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Lubula miziki kuidi Yave mu ngitala, mu ngitala ayi mu biyoko bi nyimbidi ; ");
INSERT INTO yom_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","mu zitulumbeta ayi mu biyoko bi phoka yi dimemi, yamikinanu mu khini va ntuala Yave, ntinu. ");
INSERT INTO yom_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Bika mbu wuwakikisa biyoko va kimosi ayi kadika kima kidi muna ; bika nza ayi babo bobo banzingilanga muawu bayamikina. ");
INSERT INTO yom_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Bika minlangu minneni mibula mioko miawu. Bika miongo miyimbila va kimosi mu khini ; ");
INSERT INTO yom_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","bika bayimbila va ntuala Yave bila wulembo yizi mu diambu di sambisa ntoto. Niandi wela sambisa nza mu busonga ayi batu mu bufuana. ");
INSERT INTO yom_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Yave weti yala, bika makanda matita vuandisidi kundu kiandi ki kipfumu va khatitsika Bakeluba. Bika ntoto wunikuka. ");
INSERT INTO yom_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Yave widi wunneni mu Sioni widi wuyayusu va yilu makanda moso. ");
INSERT INTO yom_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Bika bazitisa dizina diaku dinneni ayi ditsisi. Niandi widi wunlongo. ");
INSERT INTO yom_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Ntinu widi wu lulendo wunzolanga busonga. Ngeyo wukindisa mambu mafuana Mu Yakobi, wuvanga momo madi masonga ayi malulama. ");
INSERT INTO yom_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Luyayisa Yave, Nzambi eto. Lubuongama va ntuala buangu kioki keti tetikanga malu mandi. Niandi widi wunlongo. ");
INSERT INTO yom_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Moyize ayi Aloni baba va khatitsika zinganga ziandi zi Nzambi ; Samueli wuba va khatitsika bobo bantelanga dizina diandi, batela Yave ayi niandi wuba vana mvutu. ");
INSERT INTO yom_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Niandi wuba yolukila mu dikunzi di dituti. Bawu bakeba zinzengolo ziandi ayi zithumunu ziosi kaba vana. ");
INSERT INTO yom_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","A Yave, Nzambi eto, ngeyo wuba vana mvutu. Ngeyo wuba kuidi Iseli, ngeyo wuba Nzambi yoyi yiba kuba lemvukilanga ; ka diambu ko ngeyo wuba kuba vananga thumbudulu mu mavanga mawu mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Yayisanu Yave, Nzambi eto. Lubuongama va ntuala mongo andi wunlongo bila Yave, Nzambi eto, widi wunlongo. ");
INSERT INTO yom_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Nkunga wu phutudulu matondo. Yamikinanu mu khini kuidi Yave, ntoto wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Lubuongimina Yave mu khini ; yizanu va ntualꞌandi mu minkunga mi khini. ");
INSERT INTO yom_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Luzaba ti Yave niandi Nzambi. Niandi wutuvanga ayi niandi wutuvuidi. Tuidi batu bandi ; nkangu andi, wu mamemi wowo kedi dikila. ");
INSERT INTO yom_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Kotanu mu mielo miandi mu phutudulu matondo ayi mu ziphangu ziandi va kimosi ayi minzitusu. Lumvutudila matondo ayi luzitisa dizina diandi. ");
INSERT INTO yom_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Bila Yave widi wumboti ayi luzolo luandi lunzingila mu zithangu zioso. Ayi kikhuikizi kiandi kidi mu zitsungi zioso. ");
INSERT INTO yom_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Nkunga Davidi. Ndiela yimbidila luzolo luaku ayi busonga ; Kuidi ngeyo ndiela yimbidila minzitusu. ");
INSERT INTO yom_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Ndiela lubaka mu diatila mu luzingu lukambulu tsembolo. Thangu mbi wela kuiza kuidi minu e ? Ndiela diatila mu nzo ama mu ntima wukambulu tsembolo. ");
INSERT INTO yom_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Ndilendi tula ko va ntuala meso mama kadi kima kimosi ko kimbimbi. Ndieti lenda mavanga ma bobo bakambulu bakuikama malendi kundama ko. ");
INSERT INTO yom_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Batu badi mintima mi mbimbi thama bela kuthatukila ndilendi vanga kadi diambu dimosi va kimosi ayi mambimbi ");
INSERT INTO yom_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Woso wuntubidila mutu fikimini yandi mu kinsueki, ndiela ku ntula dio sui. Woso widi meso ma lunangu ayi widi ntima wu luniemo ; ndilendi ku nzingisa kuwombo ko. ");
INSERT INTO yom_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Meso mama mela ba va mikhuikizi mi tsi muingi bakalanga yama ; woso wundiatila mu kambu tsembolo, wela kutsadila. ");
INSERT INTO yom_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Kadi mutu wunsadilanga bukhita lenda vuanda mu nzo ama. Kadi mutu wuntubanga luvunu lenda telama va meso mama. ");
INSERT INTO yom_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Kadika nsuka, ndiela tula dio sui batu boso bambimbi badi va ntoto ; ndiela lalikisa kisadi kioso ki mbimbi mu divula di Yave. ");
INSERT INTO yom_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Lusambulu lu nkua mabienga weka vonga ayi wulembo kambi ziphasi ziandi kuidi Yave. Wa lusambulu luama, a Yave, bika yamikina kuama mu diambu di lusadusu kutula kuidi ngeyo ");
INSERT INTO yom_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Kadi kutsuekila zizi kiaku thangu ndidi mu phasi, tamba dikutu diaku kuidi minu ; thangu ndikutela, sia nsualu ; wuphana mvutu ! ");
INSERT INTO yom_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Bila bilumbu biama bilembo lalakana banga muisi, mimvesi miama milembo yokana banga makaba ma ku mbazu. ");
INSERT INTO yom_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Ntimꞌama wukosikini ayi wuyumini banga biti ; ndizimbikini dia bidia biama. ");
INSERT INTO yom_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Mu diambu di kunga kuama nkanda nitu kaka ayi mimvesi misiala. ");
INSERT INTO yom_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Ndidi banga kimfutu kidi mu dikanga ; banga kimfutu va khatitsika bibuangu bikambulu batu ; ");
INSERT INTO yom_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Ndilembo leki nkielo, ndieka banga nuni yidi yawu veka ku yilu nzo. ");
INSERT INTO yom_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Mu lumbu kimvimba, bambeni ziama zilembo mfingi ; bobo bamekumfuemina, balembo sadila dizina diama banga tsingulu. ");
INSERT INTO yom_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Bila ndilembo dia dibombi banga bidia ayi ndisobikisidi ndiunu ama ayi matsuela ");
INSERT INTO yom_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","mu diambu di miangu miaku minneni bila ngeyo wunzangula ngolo ayi wundozidi va lutengo. ");
INSERT INTO yom_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Bilumbu biama bidi banga kitsusula ki masika ndime yuma banga biti. ");
INSERT INTO yom_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Vayi ngeyo, a Yave, wuvuanda va kundu ki kitinu mu zithangu zioso ; tsangu aku yilembo zingila mu tsungi ka tsungi. ");
INSERT INTO yom_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Ngeyo wela telama, wela monina Sioni kiadi. Bila yawu yoyi thangu yimonisa nlemvo kuidi niandi ; thangu yoyi wukubika yfueni. ");
INSERT INTO yom_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Bila bisadi biaku binzolanga matadi mandi, ayi bieti mona kiadi mbungi-mbungi andi yela kubanata mu tezo kimona kiadi. ");
INSERT INTO yom_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Makanda mela kinzika dizina di Yave ; mintinu mioso mi ntoto miela kinzika nkembo aku. ");
INSERT INTO yom_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Bila Yave wela buela tunga diaka Sioni ayi wela monika mu nkembo andi. ");
INSERT INTO yom_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Wela vana mvutu mu lusambulu lu batu basukama, kalendi lenza maniongo mawu ko. ");
INSERT INTO yom_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Bika mambu mama masonama mu diambu di tsungi yinkuiza muingi batu bobo kabavangimini ko babaka buzitisila Yave. ");
INSERT INTO yom_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Yave wutala ku tsi tona ku buangu kiandi kinlongo kidi ku yilu tona ku diyilu niandi wuntala ntoto, ");
INSERT INTO yom_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","mu diambu di wa kunga ku batu badi mu nloko ; ayi mu diambu di kula bobo bazengolo nkanu wu lufua ; ");
INSERT INTO yom_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","buna dizina di Yave diela yolukulu mu Sioni ayi minzitusu miandi mu Yelusalemi ");
INSERT INTO yom_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","mu thangu batu bela kutangana va kimosi ayi bipfumu mu diambu di buongimina Yave. ");
INSERT INTO yom_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Mu luzingu luama, wumanisa zingolo ziama ; wukufika bilumbu biama. ");
INSERT INTO yom_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Buna ndituba : “kadi kumbotula, a Nzambi ama, va khatitsika yi bilumbu biama ; mimvu miaku miela zingilanga mu tsungi ka tsungi. ");
INSERT INTO yom_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Va thonono, ngeyo wutula zifondasio zi ntoto ayi diyilu didi kisalu ki mioko miaku. ");
INSERT INTO yom_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Biela biva vayi ngeyo wela zinganga, bibioso biela mana vembudila banga nledi, ngeyo wela bibalula banga kikhutu ayi biawu biela vengumunu. ");
INSERT INTO yom_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Vayi ngeyo wubalukanga ko, ayi mimvu miaku milendi suka ko. ");
INSERT INTO yom_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Bana ba bisadi biaku bela zingilanga va meso maku minkuna miawu miela ba mitelama dio ngui va ntualꞌaku.” ");
INSERT INTO yom_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Nkunga Davidi. Zitisa Yave, a muelꞌama ; bibioso bidi mu minu bizitisa dizina diandi dinlongo. ");
INSERT INTO yom_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Zitisa Yave, a muelꞌama, ayi kadi zimbakana mamboti mandi moso kavanga. ");
INSERT INTO yom_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Niandi weti lemvukila masumu maku moso ayi weti belusa minsongo miaku bioso. ");
INSERT INTO yom_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Niandi weti kula luzingu luaku mu dibulu ; ayi niandi weti kuvuika luzolo ayi kiadi. ");
INSERT INTO yom_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Niandi weti yukutisa zitsatu ziaku mu bima bimboti muingi bumuana buaku bukituka diaka bumona banga buididi bu mbemba. ");
INSERT INTO yom_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Yave wumvanganga busonga ayi bufuana mu diambu di batu boso beti yamusu. ");
INSERT INTO yom_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Wuzabikisa zinzila ziandi kuidi Moyize mavanga mandi kuidi batu ba Iseli. ");
INSERT INTO yom_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Yave widi nkua kiadi ayi nkua nlemvo ; kavika fuemanga ko, fulukidi mu luzolo. ");
INSERT INTO yom_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Niandi kafundanga ko mu zithangu zioso ayi kalundanga ko nganzi andi mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Katu vangilanga ko boso buididi masumu meto, katuvananga ko thumbudulu boso buididi mambimbi meto. ");
INSERT INTO yom_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Bila boso diyilu didi dizangama va yilu ntoto ; buawu bobo luzolo luandi luidi lunneni kuidi bobo beti kunkinzikanga. ");
INSERT INTO yom_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Boso esite katatukididi ayi wesite, buawu bobo katutatudila zinzimbala zieto. ");
INSERT INTO yom_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Banga dise bu kamoninga bana bandi kiadi, buawu bobo Yave kamoninga kiadi bobo beti kunkinzika. ");
INSERT INTO yom_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Bila zebi buevi tuvangulu weti tebuka moyo ti tuidi mbungi-mbungi. ");
INSERT INTO yom_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Bila kuidi mutu, bilumbu biandi bidi banga biti ; weti mona mamboti banga biteka bi tsola. ");
INSERT INTO yom_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Phemo yawu viokila va bidi, buna bisiedi ko ayi buangu kibibedi kikadi buela kubitebukila moyo. ");
INSERT INTO yom_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Vayi mu kadika thangu ayi mu zithangu zioso luzolo lu Yave luidi kuidi bobo beti kunkinzika ayi busonga buandi kuidi bana ba bana bawu ; ");
INSERT INTO yom_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","kuidi bobo beti keba Nguizani andi ayi kuidi bobo bantebukilanga tumukina minsiku miandi. ");
INSERT INTO yom_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Yave wutula kundu kiandi ki kipfumu ku diyilu ayi kipfumu kiandi kinyadila bima bioso. ");
INSERT INTO yom_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Luzitisa Yave beno zimbasi ziandi ; beno makesa lueti vanga zithumunu ziandi, lueti tumukina mambu mandi. ");
INSERT INTO yom_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Luzitisa Yave beno minkangu mi masodi mandi ma diyilu ; beno bisadi biandi lueti vanganga luzolo luandi. ");
INSERT INTO yom_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Luzitisa Yave beno mavanga mandi moso, mu bibuangu bioso biobi keti yadila. Zitisa Yave, a muelꞌama. ");
INSERT INTO yom_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Zitisa Yave, a muelꞌama. A Yave, Nzambi ama, ngeyo widi wunneni ngolo. Ngeyo vueti kiezila ayi nzitusu. ");
INSERT INTO yom_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Niandi wukifukidi muinda banga nledi ; weti yalumuna diyilu banga nzo yi ngoto, ");
INSERT INTO yom_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","ayi wutunga makunzi ma bivinga biandi bizangama va minlangu miawu. Niandi weti kitula matuti ditoma diandi di sengo ayi weti diatila mu mavavi ma phemo. ");
INSERT INTO yom_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Wunkitulanga phemo bamvuala bandi, minlaki mi mbazu bisadi biandi. ");
INSERT INTO yom_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Wuvuandisa ntoto va zifondasio ziandi ; wulendi nikuka ko kadi fifioti. ");
INSERT INTO yom_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Ngeyo wufukidila wawu mu thipula banga ngeyo wumfukididi nledi, Minlangu mitelama nate ku mbata miongo. ");
INSERT INTO yom_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Vayi bu wutema, minlangu mitina, mu biyoko bi dumu kiaku, miawu mitina. ");
INSERT INTO yom_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Mikumbila va mbata miongo, mibua nate mu mindimba ku buangu kioki wukubikila miawu. ");
INSERT INTO yom_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Ngeyo wumitudila zindilu ziozi ka milendi sabuka ko ; milendi buela diamisa ntoto ko. ");
INSERT INTO yom_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Niandi wukubika zitho zi minlangu mu zikhola zinkumbanga va khatitsika miongo. ");
INSERT INTO yom_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Zilembo vani nlangu kuidi bibulu bioso bi tsola, ziphunda zi nsitu zimanisinanga phuilꞌawu. ");
INSERT INTO yom_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Zinuni zi yilu zintunganga dianla mu yenda minlangu, zieti yimbila va khatitsika matafi. ");
INSERT INTO yom_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Wulembo lembila miongo tona ku bivinga biandi bizangama ; ntoto wuyukutidi mu mbutu wu kisalu kiandi. ");
INSERT INTO yom_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Niandi weti menisa biti mu diambu di bibulu, ayi bikunusu mu diambu di batu bakuna, ayi totulanga bidia mu ntoto : ");
INSERT INTO yom_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","vinu kieti yangidika ntima wu mutu, mafuta meta kienzula zizi kiandi ayi dipha dieti kindisa ntimꞌandi. ");
INSERT INTO yom_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Minti mi Yave midi milembolo bumboti ; minti mi sedeli mi tsi Libani miomi kakuna. ");
INSERT INTO yom_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Muawu zinuni zieti tungila zindiala ziawu ; nuni beti tedila ngongo yitungila nzo andi mu minti mimbutanga zimbala zi phutu. ");
INSERT INTO yom_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Miongo mi nangama mivuiwulu kuidi zikhombo zi nsitu ; zithadi zidi suamunu mu diambu di bibulu bieti tedolo damani. ");
INSERT INTO yom_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Ngondi yeti vasa zitsungi, ayi thangu zebi thangu mbi kafueti diamina. ");
INSERT INTO yom_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Ngeyo weti nata tombi, buisi bueti yila ayi buna bibulu bioso bi nsitu bilembo diengila-diengila. ");
INSERT INTO yom_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Zikhosi zillembo kungi mu diambu di biobi zifueti buila ayi zieti tomba bidia biawu kuidi Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Thangu yawu totuka, buna zivengumukini ; zivutukidi ayi zilekidi mu minsuku miawu. ");
INSERT INTO yom_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Buna mutu weti kuenda ku kisalu kiandi, ku kisalu kiandi nate buisi bu nyila. ");
INSERT INTO yom_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Phila bisalu biaku bididi woka, a Yave ; mu nduenga wuvangila bibioso ntoto wufulukidi mu bivangu biaku. ");
INSERT INTO yom_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Vadi mbu wumosi, wunneni ayi wuyalumuka ; muwedi bivangu ka bilendi baka bu tangulu ko ; bima bimoyo bifioti ayi binneni. ");
INSERT INTO yom_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Muawu mu nkuendilanga ayi vutukilanga masuwa ; ayi Leviatani, bulu kioki wuvanga, muawu kieti sakinina. ");
INSERT INTO yom_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Bibioso bikutalanga muingi wuba vananga bidia biawu mu thangu yifuana. ");
INSERT INTO yom_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Thangu weti kubivana bidia, bieti bonga biawu ; ngeyo zibula koko kuaku, bieti yukuta mu bima bimboti. ");
INSERT INTO yom_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Ngeyo sueka zizi kiaku, buna bieka mona tsisi. Ngeyo biziona vumunu kiawu, buna bieti fua ayi bieti vutuka mu mbungi-mbungi. ");
INSERT INTO yom_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Ngeyo fidisa vumunu kiaku, buna bivangimini ayi ngeyo weti kitula diaka zizi ki ntoto kimona. ");
INSERT INTO yom_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Bika Nkembo wu Nzambi wuzingila mu zithangu zioso ; bika Yave kayangalala mu bisalu biandi ! ");
INSERT INTO yom_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Niandi wuntalanga ku ntoto, ayi ntoto wulembo titi. Niandi wulembo simba miongo ayi milembo totula muisi. ");
INSERT INTO yom_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Ndiela yimbidilanga Yave mu luzingu luama loso. Ndiela yimbidilanga Nzambi ama minzitusu thangu yoso yi luzingu luama. ");
INSERT INTO yom_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Bika mambu mama ndinyindula mammonisa khini banga phila ndilembo muena khini mu Yave. ");
INSERT INTO yom_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Vayi bika bankua masumu balalukusu va ntoto, ayi bika batu bambimbi babika buela monika ! Zitisa Yave, a muelꞌama ! Bika Yave kazitusu ! ");
INSERT INTO yom_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Luvutudila Yave matondo, lutela dizina diandi ! Luzabikisa momo kavanga muidi makanda. ");
INSERT INTO yom_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Lunyimbidila ; lunyimbidila minzitusu. Luyolukila mavanga mandi moso matsiminanga. ");
INSERT INTO yom_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Nkembo kuidi dizina diandi dinlongo ; Bika mintima mi bobo bantombanga Yave mimona khini. ");
INSERT INTO yom_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Talanu kuidi Yave ayi kuidi zingolo ziandi ; Tombanganu mu zithangu zioso zizi kiandi. ");
INSERT INTO yom_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Lutebukilanga moyo matsiminanga momo kavanga ; bikumu biandi ayi zinzengolo ziozi kayamikisa ; ");
INSERT INTO yom_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","beno nkuna Abalahami, kisadi kiandi, beno bana ba Yakobi, batu bandi kasobula ! ");
INSERT INTO yom_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Yave niandi Nzambi eto ; zinzengolo ziandi zidi va ntoto wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Wuntebukilanga moyo nguizani andi mu zithangu zioso, mambu momo katumina mu mili di zitsungi. ");
INSERT INTO yom_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Nguizani yoyi yi kawizana ayi Abalahami ; ndefi yoyi kadila Izaki. ");
INSERT INTO yom_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Wukindisa yawu kuidi Yakobi banga nzengolo ; kuidi Iseli banga nguizani mu zithangu zioso ; ");
INSERT INTO yom_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","“Kuidi ngeyo ndiela vana ntoto wu Kana banga kuku ki kiuka kioki wela tambula.” ");
INSERT INTO yom_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Buna bakidi thalu yi fioti kaka, bafioti kuandi, banzenza mu tsi beni ; ");
INSERT INTO yom_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","vayi baba kuenda diengilanga mu makanda-makanda tona mu kipfumu kimosi nate ku kipfumu kinkaka. ");
INSERT INTO yom_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Kasia vana ko minsua kuidi kadi mutu wumosi mu kuba yamisa mu diambu diawu wutemina mintinu. ");
INSERT INTO yom_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","“Kadi simba batu bama bobo ndivinda mafuta ; kadi vangila mimbikuidi miama mambu mambimbi.” ");
INSERT INTO yom_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Wutumisa kanda kingolo va ntoto ayi wubunga bidia biawu bioso balunda. ");
INSERT INTO yom_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Buna wufidisa mutu wumosi ku ntualꞌawu : Zozefi wutekoso banga mvika. ");
INSERT INTO yom_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Bakanga malu mandi mu zisieni ; batula dinga diandi mu bisengo ");
INSERT INTO yom_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","nate mambu makatuba mavioka ; nate mambu ma Yave mamonisa ti makiedika katuba. ");
INSERT INTO yom_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Ntinu wufidisa ayi bannianguna ; nyadi wu batu wunyekula mu kiphuanza. ");
INSERT INTO yom_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Wumbieka pfumu mu nzo andi nyadi wu bima bioso biobi kavua, ");
INSERT INTO yom_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","mu longa bana ba mintinu boso bu kazodidi ayi vana nduenga kuidi bakulutu bandi. ");
INSERT INTO yom_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Buna Iseli wukota ku Ezipite ; Yakobi wuzingila banga nzenza mu tsi yi Hami. ");
INSERT INTO yom_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Yave wuvanga ti batu bandi babutuka kuwombo ayi wuba kitula batu bawombo viokila bobo baba lenda ; ");
INSERT INTO yom_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","bobo kabalula mintima mu lenda batu bandi, mu kuendila bisadi biandi manenga. ");
INSERT INTO yom_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Wufidisa Moyize, kisadi kiandi, ayi Aloni mutu wowo kasobula. ");
INSERT INTO yom_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Bavanga bidimbu biandi va khatitsikꞌawu, matsiminanga mandi mu tsi Hami. ");
INSERT INTO yom_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Wufidisa tombi ayi wutula tombi mu ntoto bila basia tinguna ko mambu mandi e ? ");
INSERT INTO yom_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Wukitula minlangu miawu menga ; wumana sikisa vonda zimbizi ziawu. ");
INSERT INTO yom_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Mintoto miawu miwala bisioto ; biobi bikota nate mu bivinga bi minyadi miawu. ");
INSERT INTO yom_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Wutuba ayi kuyiza zinzinzi ziba mitsa ayi zingungu mu tsi awu yoso. ");
INSERT INTO yom_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Niandi wubalula mvula mu mvula yi matadi nzazi mu ntoto wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Wumana buisa minti miawu mi vinu ayi minti miawu mi figi, ayi kelula minti mi tsi awu. ");
INSERT INTO yom_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Wutuba ayi makhoko mayiza ; binzienzi bikambulu thalu. ");
INSERT INTO yom_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Bidia kadika kunusu kinlangu mu tsi awu ; bidia mimbutu mi ntoto awu. ");
INSERT INTO yom_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Buna wumana vonda bana boso batheti mu tsi awu, mimbutu mioso mitheti mi zingolo ziawu. ");
INSERT INTO yom_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Wutotula Iseli va kimosi ayi mfuna wu palata ayi nolo ; ayi kusia monika ko mutu wumemata mu zimvila ziawu. ");
INSERT INTO yom_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Ezipite yimona khini bubayenda bila tsisi yi Iseli yiba buila. ");
INSERT INTO yom_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Wuyalumuna matuti mu diambu di kuba fuka ayi mbazu mu kuba kienzula va builu. ");
INSERT INTO yom_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Balomba ayi wuba fidisila zinuni ayi wuba yukutisa mu mapha ma diyilu. ");
INSERT INTO yom_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Wuzibula ditadi ayi nlangu wutotuka ; banga nlangu wunneni wukumba mu dikanga. ");
INSERT INTO yom_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Bila wutebukila moyo tsilꞌandi yinlongo yoyi kavana kuidi Abalahami, kisadi kiandi. ");
INSERT INTO yom_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Wutotudila batu bandi mu khini batu bandi bobo kasobula mu biyoko bi mayangi. ");
INSERT INTO yom_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Wuba vana mintoto mi makanda, ayi batambula kiuka kisala batu bankaka. ");
INSERT INTO yom_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Muingi balunda minsiku miandi ayi bakinzika Mina miandi. Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Luzitisa Yave, luvutudila Yave matondo bila widi wumboti, luzolo luandi lunzingila mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Nani wulenda yamikisa mavanga ma lulendo ma Yave ? Voti samuna nzitusu andi woso e ? ");
INSERT INTO yom_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Lusakumunu kuidi bobo basimbididi busonga ; bobo beti vanga mambu ma lulama mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Wuthebukila moyo, a Yave, mu thangu wumvangila batu baku mamboti wiza wutsadisa mu thangu wela kubavukisa, ");
INSERT INTO yom_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","muingi ndibaka bu muena khini mu mamboti ma batu baku bobo wusobula ; muingi ndibaka bukabudila khini ayi batu baku ; ayi muingi ndifubakana va kimosi ayi kiuka kiaku mu kuvananga nzitusu. ");
INSERT INTO yom_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Tuvola masumu banga buvodila madise meto ; beto tuvanga mambimbi ayi mavanga mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Thangu madise meto baba ku Ezipite, basia ba ko kadi mayindu mu bikumu biaku ; basia tebukila ko moyo woka ku mamboti maku vayi baba bankua matingu va ndambu mbu, va ndambu mbu wu mbuaki. ");
INSERT INTO yom_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Vayi wuba vukisa mu diambu di nkembo wu dizina diandi mu monisa lulendo luandi. ");
INSERT INTO yom_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Wutemina mbu wu mbuaki, buna wawu wuyuma ; wuba diatisa mu dibulu dinneni banga mu dikanga. ");
INSERT INTO yom_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Wuba vukisa mu koko ku mutu wowo wu balenda ; wuba kula mu koko ku bambeni. ");
INSERT INTO yom_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Minlangu midiamisa bambeni ziawu ; kadi wumosi kasia siala wumoyo ko. ");
INSERT INTO yom_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Buna bawilukila zitsila ziandi ayi bayimbila minzitusu miandi. ");
INSERT INTO yom_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Vayi mu nsualu bavika zimbakana momo kavanga, ayi basia tadidila zindongi ziandi ko. ");
INSERT INTO yom_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Mu dikanga, bakiyekula mu zinzinunu ziawu ; va buangu kikambulu batu, batota Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Buna wuba vana biobi balomba ; ayi wubafidisila ziphasi. ");
INSERT INTO yom_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Bavangila Moyize kiphala ayi Aloni ku ka, mutu wowo Yave kabieka nlongo. ");
INSERT INTO yom_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Ntoto wuzibuka ayi wumina Datani ; ayi wufuka dikabu di batu ba Abilami ");
INSERT INTO yom_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Mbazu yilema va khatitsika batu baba kubakuka, nlaki wu mbazu wuzinisa batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Ku Holebi, bavanga muana ngombi ; ayi babuongimina tumba kivangulu mu suitisa sengo. ");
INSERT INTO yom_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Baviakisa nkembo awu mu mfikula yi ngombi yeti dia biti ");
INSERT INTO yom_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Bazimbakana Nzambi, mutu wubavukisa, mutu wuvanga mambu manneni mu Ezipite, ");
INSERT INTO yom_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","bikumu mu tsi Hami ayi mambu ma tsisi va ndambu mbu wu mbuaki. ");
INSERT INTO yom_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Buna wutuba ti wukana ku babunga ; enati kambu Moyize, mutu andi wukasobula, wutelama mu diambu di kuba sambildila va ntualꞌandi mu diambu di kakidila miangu miandi mi ngolo muingi kabika ku babunga. ");
INSERT INTO yom_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Buna balenza tsi yi makhini, basia wilukila ko tsilꞌandi. ");
INSERT INTO yom_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Baniunguta mu zinzo ziawu zi ngoto ; ayi basia tumukina ko Yave. ");
INSERT INTO yom_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Buna wuvumuna koko kuandi mu leva ndefi mu diambu diawu ti wela kuba buisa mu dikanga ; ");
INSERT INTO yom_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","ti wela buisa nkunꞌawu va khatitsika makanda ; ayi wela kuba sasikisa mu yenda ntoto. ");
INSERT INTO yom_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Bakiyekula bawu veka kuidi Bali-Pewoli ayi badia makaba matambuku kuidi zinzambi zikambulu moyo. ");
INSERT INTO yom_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Basoka Yave muingi kafuema mu diambu di mavanga mawu mambimbi, ayi nsongo wutotuka va khatitsikꞌawu. ");
INSERT INTO yom_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Buna Pineyasi wutelama ayi wuvuata nsamu ; buna nsongo wutumbu manisa. ");
INSERT INTO yom_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Buna bantangila diawu banga busonga mu zitsungi zinkuiza zikambulu tsukulu. ");
INSERT INTO yom_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Ku minlangu mi Meliba, bafuemisa Yave ; buna ziphasi zibuila Moyize mu diambu diawu. ");
INSERT INTO yom_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Bila batinguna Pheve yi Nzambi ayi mambu makambulu fuana matotukila mu bididi bi Moyize. ");
INSERT INTO yom_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Basi bunga ko batu boso bubela lutumunu lu Yave. ");
INSERT INTO yom_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Vayi bafubakana ayi makanda mankaka ayi balonguka kikhulu ki makanda beni. ");
INSERT INTO yom_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Babuongimina bitumba biawu, biawu bikituka ntambu kuidi bawu. ");
INSERT INTO yom_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Batambika bana bawu bababakala ayi babaketo kuidi ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Batengula menga ma batu bakambulu zaba diambu ; menga ma bana bawu bababakala ayi babaketo mawu batambika kuidi bitumba bi Kana. Buna ntoto wusumuka mu diambu di menga mawu. ");
INSERT INTO yom_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Bakisumuna bawu veka mu momo bavanga, mu mavanga mawu, ba ta kitsuza bawu veka. ");
INSERT INTO yom_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Muaki Yave wufuemina batu bandi ayi wukakumukina kiuka kiandi. ");
INSERT INTO yom_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Wuba yekula kuidi makanda ayi bobo baba lenda babayadila. ");
INSERT INTO yom_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Bambeni bawu ziba yamisa ayi batulu ku tsi lulendo luawu. ");
INSERT INTO yom_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Zikhumbu ziwombo kaba kudila vayi baba kaka bankua matingu ayi bakibivisa mu masumu mawu. ");
INSERT INTO yom_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Vayi wubela ziphasi ziawu mayindu thangu kawa yamikina kuawu. ");
INSERT INTO yom_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Mu bila kiawu, wutebukila nguizani andi moyo ; ayi mu luzolo luandi lunneni wubalula lukanu. ");
INSERT INTO yom_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Niandi wuvanga ti bamueno kiadi kuidi bobo baba nata mu kivika. ");
INSERT INTO yom_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Wutuvukisa, a Yave, Nzambi eto ; ayi wutukutikisa tona ku makanda muingi tubaka buvutudila dizina diaku dinlongo matondo ayi nkembo mu nzitusu aku. ");
INSERT INTO yom_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Yave kazitusu, Nzambi yi Iseli ! Mu zithangu zioso ayi mu mvu ka mvu. Bika batu boso batuba : “Amen.” Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Luvutudila Yave matondo bila niandi widi wumboti ; Luzolo luandi lunzingila mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Bika bobo bakulu kuidi Yave batuba buawu ; bobo kakula mu koko ku batu bobo babalenda, ");
INSERT INTO yom_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","bobo kakutikisa tona ku mintoto, tona ku esite ayi ku wesite ; tona ku node ayi ku sude. ");
INSERT INTO yom_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Bankaka baba diengilanga mu dikanga, buangu bikambulu batu ; basia baka ko nzila yikotila mu divula diodi balenda vuandila. ");
INSERT INTO yom_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Bamona nzala ayi phuila ; ayi luzingu luawu luba nduka mu suka. ");
INSERT INTO yom_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Buna bayamikina kuidi Yave mu ziphasi ziawu ayi niandi wuba kula mu kiadi kiawu. ");
INSERT INTO yom_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Niandi wuba diatisa mu nzila yisonga mu diambu di kuenda ku divula diodi balenda baka bu vuandila. ");
INSERT INTO yom_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Bika bavutudila Yave matondo mu diambu di luzolo luandi lu ngolo ayi mu diambu di mavanga mandi matsiminanga momo kavangila batu. ");
INSERT INTO yom_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Bila wumanisa phuila ayi wuyukutisa mutu wuba nzala mu bima bi mboti. ");
INSERT INTO yom_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Bankaka baba vuandanga mu tombi ayi ku tsi tombi ki nkobo ; baba bakangama mu ziphasi zisieni zi sengo. ");
INSERT INTO yom_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Bila batinguna mambu ma Nzambi, ayi balenza zindongi zi Nzambi Yizangama. ");
INSERT INTO yom_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Diawu kaba yekudila ku tsi kisalu ki ngolo ; babumina thutu ayi kuisi ba ko kadi mutu mu ku basadisa. ");
INSERT INTO yom_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Buna bayamikina kuidi Yave mu ziphasi ziawu ayi niandi wuba vukisa mu kiadi kiawu. ");
INSERT INTO yom_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Wuba totula mu tombi ayi ku tsi tombi ki nkobo ayi wukelula zisieni ziawu. ");
INSERT INTO yom_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Bika bavutudila Yave matondo mu diambu di luzolo luandi lu ngolo ayi mu diambu di mavanga mandi matsiminanga momo kavangila batu ");
INSERT INTO yom_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Bila wutiolumuna mielo mi palata ayi wukesumuna bisengo binzibukulungu mielo. ");
INSERT INTO yom_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Bankaka bakituka bivungisi mu zinzila ziawu zi matingu ayi ziphasi mu diambu di mambimbi mawu. ");
INSERT INTO yom_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Bakakumukina bidia bioso ayi bafikama mielo mi lufua. ");
INSERT INTO yom_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Buna bayamikina kuidi Yave mu ziphasi ziawu ayi niandi wuba vukisa mu kiadi kiawu. ");
INSERT INTO yom_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Wufidisa mambu mandi ayi wuba belusa, wuba kula mu tsi bafua. ");
INSERT INTO yom_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Bika bavutudila Yave matondo mu diambu di luzolo luandi lu ngolo ayi mu diambu di mavanga mandi matsiminanga momo kavangila batu. ");
INSERT INTO yom_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Bika batambika makaba ma phutudulu matondo ayi bayolukila bisalu biandi mu minkunga mi khini. ");
INSERT INTO yom_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Bankaka bayendila va mbu mu masuwa, baba minkiti mu minlangu minneni, ");
INSERT INTO yom_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","bamona bisalu bi Yave, mavanga mandi matsiminanga va ngingi nlangu. ");
INSERT INTO yom_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Bila wuyoluka ayi wutotula vuka kingolo, kioki kivumuna mayo. ");
INSERT INTO yom_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Bakuma ku yilu ayi bakuluka ti kuna tsi ; mu mabienga mawu, bukhafi buawu buzimbala. ");
INSERT INTO yom_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Balembo balumuka ayi bulangana mu diata banga batu bakololo malavu diela diawu dimanisa. ");
INSERT INTO yom_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Buna bayamikina kuidi Yave mu ziphasi ziawu ayi niandi wuba vukisa mu kiadi kiawu. ");
INSERT INTO yom_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Wudigimisa vuka kingolo mu manuinguta, mayo ma mbu madingalala. ");
INSERT INTO yom_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Bamona khini thangu ndembama yivutuka ayi Yave wuba nata ku disimu dibazola kuenda. ");
INSERT INTO yom_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Bika bavutudila Yave matondo mu diambu di luzolo luandi lu ngolo ayi mu diambu di mavanga mandi matsiminanga momo kavangila batu. ");
INSERT INTO yom_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Bika banyayisa mu lukutukunu lu batu ayi bika banzitisa mu dikabu di bakulutu. ");
INSERT INTO yom_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Wukitula minlangu minneni makanga ayi zitho zinkumba mintoto mi yuma ; ");
INSERT INTO yom_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","ayi ntoto widi mbozi mu ntoto widi tsalu mu diambu di mambimbi ma bobo bazingila muna. ");
INSERT INTO yom_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Wukitula dikanga mu bibuindi bi nlangu ayi ntoto wuyuma mu zitho zinkumba ; ");
INSERT INTO yom_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Kuna kanata nzala muingi yizingila ayi batunga divula diodi balenda vuanda ; ");
INSERT INTO yom_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Bakuna zitsola ayi zindima zi vinu ziozi zieti buta mimbutu mimbozi. ");
INSERT INTO yom_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Wuba sakumuna ayi thalu awu yiwombo yi buelama ayi kasia tala ko ti bibulu biawu bidekuka. ");
INSERT INTO yom_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Buna thalu awu yidekuka ayi bafua tsoni mu diambu di khuamusu, mabienga ayi maniongo. ");
INSERT INTO yom_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Niandi wulembo lenzi batu banneni, wulembo badiengisa mu dikanga mu kambulu nzila. ");
INSERT INTO yom_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Vayi weti totula nsukami mu ziphasi ziandi ayi weti wokisa makanda mawu banga minkangu mi mamemi. ");
INSERT INTO yom_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Batu balulama mu mintima balembo moni ayi balembo yangalala vayi batu boso bambimbi bazibikidi miunu miawu. ");
INSERT INTO yom_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Woso mutu widi nduenga bika kakeba mambu mama ayi kasudika luzolo lunneni lu Yave. ");
INSERT INTO yom_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Nkunga Davidi. Ntimꞌama widi wukinda, a Nzambi. Ndiela yimbila ayi ndiela bula miziki mu muelꞌama woso. ");
INSERT INTO yom_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Kotukanu beno ngitala ayi Lila ; ndiela kotula khiesa buisa. ");
INSERT INTO yom_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Ndiela kuzitisa, a Yave, va khatitsika makanda, ndiela kuyimbidila va khatitsika batu ");
INSERT INTO yom_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Bila luzolo luaku luidi lunneni, luidi luzangama viokila diyilu kikhuikizi kiaku kieti tula nate ku matuti. ");
INSERT INTO yom_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Yayusu kuaku, a Nzambi, ku yilu diyilu ayi bika nkembo aku wuba va ntoto wumvimba ; ");
INSERT INTO yom_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Wutuvukisa ayi wutusadisa mu koko kuaku ku lubakala muingi bobo weti zola bakulu. ");
INSERT INTO yom_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Nzambi wutuba tona ku buangu kiandi kinlongo : “mu ndungunu, ndiela vasa Sikemi ayi ndiela teza ndimba wu Sikoti. ");
INSERT INTO yom_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Minu phuidi Galadi, minu phuidi Manase ; Efalayimi wawu nkaku wu ntu ama Yuda nkawꞌama wu kipfumu. ");
INSERT INTO yom_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Mowabi diawu dibola diodi ndieti yobidila. Va yilu Edomi ndiloza zisandale ziama, ndiela yamikina mu diambu di ndungunu ama mu basi Filisiti.” ");
INSERT INTO yom_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Nani wela kundata ku divula dikindusu ngolo e ? Nani wela kuthuadisa ku Edomi e ? ");
INSERT INTO yom_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Keti ngeyo, a Nzambi, ngeyo wutuloza, ngeyo wunkambu buela totukanga ayi minkangu mi masodi meto e ? ");
INSERT INTO yom_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Wutuvana lusadusu va ntuala mbeni bila lusadusu lu mutu luidi lu phamba. ");
INSERT INTO yom_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Va kimosi ayi Nzambi, tuela tunga ayi wela kosikisa bambeni zieto. ");
INSERT INTO yom_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Nkunga Davidi kuidi pfumu minyimbidi. A Nzambi, mutu wowo ndieti zitisa bika dingalala. ");
INSERT INTO yom_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Bila batu bambimbi ayi batu bansadilanga bukhita bazibudi miunu miawu mu diambu diama. Balembo tubi mu diambu diama mu ludimi lu luvunu. ");
INSERT INTO yom_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Mu mambu ma kikhenene, banzungididi ayi balembo nduanisa mu kambu bila. ");
INSERT INTO yom_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Mu kikundi kiama, balembo mfundi vayi minu ndidi mutu wu lusambulu. ");
INSERT INTO yom_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Baphutudidi mambimbi mu mamboti ayi bandendidi mu diambu di kikundi kiama. ");
INSERT INTO yom_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Sobula mutu wumbimbi mu diambu kakba mbeni andi ; bika mfundi katelama va koko kuandi ku lubakala. ");
INSERT INTO yom_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Mu thangu kela samba, bika kaba monika mu nzimbala ayi bika lusambulu luandi lumbedisa. ");
INSERT INTO yom_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Bika bilumbu biandi bikituka bifioti. Bika mutu wunkaka kabonga buangu kiandi ki kintuadisi. ");
INSERT INTO yom_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Bika bana bandi baba bana basana ; ayi nketo andi difuola. ");
INSERT INTO yom_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Bika bana bandi baba mindiengidi mikuenda lombingi ; bika baba kuka mu zinzo ziawu zitiolumuka. ");
INSERT INTO yom_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Bika mutu wowo weti devisa kabonga bima bioso biobi kavuidi ; bika banzenza baziona mu kingolo mimbutu mi kisalu kiandi. ");
INSERT INTO yom_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Bika kubika ba mutu wulenda kumvangila mamboti voti monina bana bandi basana kiadi. ");
INSERT INTO yom_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Bika nkunꞌandi wulalakana ; mazina mawu makubulu mu tsungi yinkuiza. ");
INSERT INTO yom_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Bika mambimbi ma bakulu bandi matebukulungu moyo va ntuala Yave, bika disumu di ngudi andi dibika kubulu. ");
INSERT INTO yom_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Bika masumu mawu mazingila mu zithangu zioso va ntuala Yave muingi kalalikisa thebukulu awu moyo va ntoto. ");
INSERT INTO yom_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Bila kalendi yindula mu vanga mamboti ko, vayi wuyamisa nsukami nate ku lufua ; ayi nkua kiadi ayi mutu wuba ntima wukosakana. ");
INSERT INTO yom_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Niandi wuzola singa ; bika yimbuila, kamonanga khini ko mu lusakumunu bika luawu luba thama ayi niandi ");
INSERT INTO yom_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Wuvuata tsingulu banga nledi andi ; yawu yikota mu khati nitu andi banga nlangu, mu mimvesi miandi banga mafuta. ");
INSERT INTO yom_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Bika yawu yikituka banga yunga kioki kakukifukila ; banga nsinga luketo wowo keti vuata mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Bika buawu bobo bubela mfutu wu Yave kuidi mimfundi miama ; kuidi bobo bantubanga mambu mambimbi mu diambu diama. ");
INSERT INTO yom_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Vayi ngeyo Yave, mutu wumvanganga mawu zodidi, wuphangila mamboti mu diambu di dizina diaku ; ka diambu ko mamboti ma luzolo luaku madi, bika wukhula. ");
INSERT INTO yom_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Ndidi nkua kiadi ayi nsukami ayi ntimꞌama widi wuluala mu minu. ");
INSERT INTO yom_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Ndieka lalakana banga kitsusula va masika ; bakhukidi banga makhoko. ");
INSERT INTO yom_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Makuma mama malembo bulangama mu kukifuisanga nzala mu diambu di lusambulu ; nitu ama yidi yifioti ayi yikonda. ");
INSERT INTO yom_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Minu ndieka diambu di mvuezolo kuidi mimfundi miama ; bawu kumbona, balembo nikuna mintu miawu. ");
INSERT INTO yom_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Wutsadisa, a Yave, Nzambi ama ; wuphukisa boso buididi luzolo luaku. ");
INSERT INTO yom_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Bika bazaba ti koko kuaku ; ti ngeyo Yave wuvanga buawu. ");
INSERT INTO yom_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Bawu balembo singi vayi ngeyo wela sakumuna. Bu batelimini mu diambu di nuanisa, bela fua tsoni vayi kisadi kiaku kiela mona khini. ");
INSERT INTO yom_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Mimfundi miama milendi vuata nzitusu ko ayi miela fukudulu tsoni banga yunga. ");
INSERT INTO yom_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Mu munu ama, ndiela yayisa ngolo Yave ; Mu nkangu wunneni wu batu, ndiela kunzitisa. ");
INSERT INTO yom_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Bila niandi wuntelamanga va koko ku lubakala lu nsukami mu diambu di vukisa luzingu luandi mu mioko mi bobo bakunzengilanga nkanu. ");
INSERT INTO yom_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Nkunga Davidi. Yave wutuba kuidi Pfumu ama : “Vuanda va koko kuama ku lubakala nate ndikitula bambeni ziaku kima kioki beti tetika malu mu diambu di malu maku.” ");
INSERT INTO yom_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Yave wela nonuna nkawa aku wu lulendo wu kipfumu tona ku Sioni ; wela yadila va khatitsika bambeni ziaku. ");
INSERT INTO yom_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Minkangu miaku mi masodi miela ba luzolo lumboti ; mu lumbu kiaku ki mvita bavuata nzitusu wunlongo tona mu khiesa buisi wela tambula bimi bi bumuana buaku. ");
INSERT INTO yom_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Yave wuzenga ndefi, kalendi viakisa mayindu mandi ko : “ngeyo widi nganga Nzambi mu zithangu zioso mu ntanda wu Meleshisedeki.” ");
INSERT INTO yom_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Yave widi va koko kuaku ku lubakala ; wela kosikisa mintinu mu lumbu ki miangu miandi mi ngolo. ");
INSERT INTO yom_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Wela sambisa makanda, kupikisa bafua Niandi wela kosikisa minyadi va ntoto wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Niandi wela nua nlangu wu mvuila mu ndambu nzila, diawu kela vumbudila ngolo ntu andi. ");
INSERT INTO yom_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Luzitisa Yave ! Ndiela yayisa Yave mu ntimꞌama wumvimba, mu dikabu di batu balulama ayi mu lukutukunu lu batu. ");
INSERT INTO yom_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Mavanga ma Yave madi manneni, meti yindulu kuidi bobo beti kumazola. ");
INSERT INTO yom_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Mavanga mandi madi ma nkembo ayi ma nzitusu ayi busonga buandi bunzingilanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Niandi wuvanga ti matsiminanga mandi matebukulukungu moyo. Yave widi nkua nlemvo ayi nkua kiadi. ");
INSERT INTO yom_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Niandi weti vana bidia kuidi bobo beti kunkinzika ; wuntebukilanga moyo Nguizani andi mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Wumonisa batu bandi lulendo lu bisalu biandi ; bu kaba vana mintoto mi makanda mankaka. ");
INSERT INTO yom_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Bisalu bi mioko miandi bidi kikhuikizi ayi busonga ; minsiku miandi mioso mifueni mu tudulu diana, ");
INSERT INTO yom_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","mikindusu mu zithangu zioso ayi mu kadika mvu ; mivangulu mu kikhuikizi ayi mu bufuana. ");
INSERT INTO yom_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Niandi wuvana khudulu kuidi batu bandi ; niandi wutumina nguizani andi mu zithangu zioso. Dizina diandi didi dinlongo ayi tsisi didi. ");
INSERT INTO yom_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Kinzika Yave yawu thonono yi nduenga, Babo bobo beti landakana minsiku miandi babeki diela dimboti. Niandi vuidi nzitusu mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Luzitisa Yave ! Lusakumunu kuidi mutu wowo weti kinzika Yave ; wowo weti mona khini mu zithumunu ziandi. ");
INSERT INTO yom_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Bana bandi bela ba lulendo va ntoto ; Tsungi yi batu balulama yela sakumunu. ");
INSERT INTO yom_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Bima biwombo ayi kimvuama bidi mu nzo andi ayi busonga buandi bunzingilanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Ka diambu ko mu tombi, kiezila kieti kienzuka mu diambu di batu balulama mu mintima ; mu diambu di nkua nlemvo ayi nkua kiadi ayi mutu wusonga. ");
INSERT INTO yom_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Mamboti mela kuiza kuidi mutu wowo wunkabulanga mu luzolo ayi wundevisanga mu kambu kuiku ; ayi wundiatisanga bisalu biandi mu busonga. ");
INSERT INTO yom_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Bukiedika kalendi nikuka ko ; mutu wusonga wela tebukulungu moyo mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Kalendi mona zitsangu zimbimbi tsisi ko. Ntimꞌandi widi wukinda, wuntulanga diana mu Yave. ");
INSERT INTO yom_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Ntimꞌandi widi mu luvovomo, kalendi mona tsisi ko ku tsuka wela nunga mu tala batu bobo beti kunlenda. ");
INSERT INTO yom_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Wunkabulanga mu zindambu zioso makaba mu diambu di nsukami ; busonga buandi bunzingilanga mu zithangu zioso ; phokꞌandi yela vumbulu ngolo mu nzitusu. ");
INSERT INTO yom_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Mutu wumbimbi wela bumona ayi wela fuema ; wela kueta meno ayi wela lalakana. Zikhanu zi mutu wumbimbi ziela kituka ziphamba. ");
INSERT INTO yom_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Nkembo kuidi Yave ! Luzitisa Yave luzitisa beno bisadi bi Yave ; luzitisa dizina di Yave. ");
INSERT INTO yom_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Bika dizina di Yave dizitusu tona buabu nate mu zithangu zioso ; ");
INSERT INTO yom_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Bika dizina di Yave dizitusu tona kuntotukilanga thangu nate ku buangu yeti diamina. ");
INSERT INTO yom_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Yave widi wuyayusu ku yilu makanda moso, nkembo andi ku mbata diyilu. ");
INSERT INTO yom_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Nani dedikini banga Yave, Nzambi, eto niandi wutula kundu kiandi ki kipfumu ku yilu ");
INSERT INTO yom_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","mutu wowo weti yinama mu tala diyilu ayi ntoto e ? ");
INSERT INTO yom_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Weti totula nsukami mu mbungi-mbungi ; ayi niandi weti vumbula nkua kiadi mu dikuka di dibombi. ");
INSERT INTO yom_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Weti kuba vuandisa va kimosi ayi bana ba mintinu va kimosi ayi bana ba mintinu mi batu bawu. ");
INSERT INTO yom_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Niandi wuvuandisa sita ki nketo mu nzo ; banga ngudi yi bana yilembo moni khini Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Mu thangu Iseli katotuka mu Ezipite, nzo yi Yakobi mu batu beti tuba mbembo yi nzenza ; ");
INSERT INTO yom_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Yuda dikituka buangu kinlongo ki Nzambi, Iseli tsi andi. ");
INSERT INTO yom_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Mbu wumona ayi wutina ; Yolidani yivutuka ku manima. ");
INSERT INTO yom_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Miongo midumuka banga mamemi mambakala ; miongo mifioti banga bana ba mamemi. ");
INSERT INTO yom_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","A mbi bivangama, ngeyo mbu, muingi wutina ngeyo Yolidani, muingi wuvutuka ku manina e ? ");
INSERT INTO yom_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Ngeyo miongo, muingi wudumuka banga mamemi ma mbakala, miongo mifioti banga bana ba mememi e ? ");
INSERT INTO yom_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Tita, a ntoto, va meso ma Yave va meso ma Nzambi yi Yakobi. ");
INSERT INTO yom_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Niandi wunkitulanga ditadi buindi ki nlangu, ditadi dingolo zitho zi nlangu. ");
INSERT INTO yom_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Bika kuidi beto, a Yave, bika kuidi beto ; vayi kuidi dizina diaku kuba nkembo, mu diambu di luzolo luaku ayi kikhuikizi kiaku. ");
INSERT INTO yom_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Bila mbi makanda malembo tubila ti : “Kuevi kuidi Nzambi awu e ?” ");
INSERT INTO yom_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Nzambi eto widi ku Diyilu, niandi weti vanga moso katidi. ");
INSERT INTO yom_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Vayi bitumba biawu bidi palata ayi nolo ; bivangulu mu mioko mi batu. ");
INSERT INTO yom_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Bibeki miunu vayi bilendi yoluka ko ; meso vayi bilendi mona ko. ");
INSERT INTO yom_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Bibeki matu vayi bilendi wa ko ; mayilu vayi bilendi wa tsudi ko. ");
INSERT INTO yom_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Bibeki mioko vayi bilendi simba ko, malu vayi bilendi diata ko. Voti bilendi totula ko biyoko mu phovi-yi-dilaka diawu. ");
INSERT INTO yom_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Batu bobo bavanga biawu bela ba banga biawu, ayi buawu bobo buela bela batu boso bobo bantulanga diana mu biawu. ");
INSERT INTO yom_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","A nzo yi Iseli, tula diana mu Yave. Niandi nsadisi awu ayi nkaku awu. ");
INSERT INTO yom_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","A Nzo yi Aloni, tula diana mu Yave. Niandi nsadisi awu ayi nkaku awu. ");
INSERT INTO yom_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Beno lueti kunkinzika, lutula diana mu Yave. Niandi nsadisi awu ayi nkaku awu. ");
INSERT INTO yom_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Yave weti kututebukila moyo ayi wela kutusakumuna. Wela sakumuna nzo yi Iseli, wela sakumuna nzo yi Aloni. ");
INSERT INTO yom_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Wela sakumuna bobo beti kinzika Yave, batu baphamba va kimosi ayi batu banneni. ");
INSERT INTO yom_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Bika Yave kaluwokisa, beno ayi bana beno va kimosi. ");
INSERT INTO yom_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Bika Yave kalusakuna, mvangi wu diyilu ayi ntoto. ");
INSERT INTO yom_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Yave niandi vuidi Diyilu dizangama vayi ntoto wuvanu kuidi mutu. ");
INSERT INTO yom_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Kadi sia ti bafua bawu beti zitisa Yave ; bobo bankuendanga ku tsi yidi dio sui. ");
INSERT INTO yom_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Vayi beto tueti yayisa Yave tona buabu nate mu zithangu zioso. Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Ndieti zola Yave bila niandi weti wa mbemboꞌama weti wa yamikina kuama mu diambu di kiadi. ");
INSERT INTO yom_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Bila niandi wutamba dikutu diandi kuidi minu, ndiela kuntela sumbu ndilembo zingi. ");
INSERT INTO yom_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Minsinga mi lufua mimfietikisa ; tsisi yi tsi yi bafua yibua va minu ; ndibedoso kuidi ziphasi ayi maniongo. ");
INSERT INTO yom_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Buna nditedila dizina di Yave ; “A Yave, wuphukisa !” ");
INSERT INTO yom_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Yave widi nkua nlemvo ayi widi wusonga ; Nzambi eto widi nkua kiadi. ");
INSERT INTO yom_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Yave wunkebanga batu badi bakuluka mu mintima ; bu ndiba mu nkinza wu ngolo niandi wuphukisa. ");
INSERT INTO yom_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Ba mu luvundulu mu zithangu ziwombo, a muelꞌama bila Yave wuba wumboti kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Bila ngeyo, a Yave, wukula muelꞌama mu lufua ; meso mama mu matsuela, malu mama mu bumina thutu ");
INSERT INTO yom_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","muingi ndibaka bu diatila va ntuala Yave, va mbata ntoto wu batu badi moyo. ");
INSERT INTO yom_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Ndiwilukila, diawu nditubila : “mu ziphasi zingolo ndidi.” ");
INSERT INTO yom_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Ku tsi maniongo mama ndituba : “batu boso badi bankua luvunu.” ");
INSERT INTO yom_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Buevi ndilendi futila Yave mu mamboti mandi moso kuidi minu e ? ");
INSERT INTO yom_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Ndiela vumuna mbungu yi phulusu ayi ndiela tela dizina di Yave. ");
INSERT INTO yom_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Ndiela dukisa zindefi ziama zioso kuidi Yave ; va meso ma batu bandi boso. ");
INSERT INTO yom_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Lufua lu banlongo ba Yave thalu luidi va meso mandi. ");
INSERT INTO yom_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","A Yave, bukiedika ndidi kisadi kiaku ; ndidi kisadi kiaku, muana wu kisadi kiaku ki nketo. Ngeyo wukhula mu zisieni ziama. ");
INSERT INTO yom_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Ndiela kutambika makaba ma phutudulu matondo ayi ndiela tela dizina di Yave. ");
INSERT INTO yom_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Ndiela dukisa zindefi ziama zioso kuidi Yave ; va meso ma batu bandi boso, ");
INSERT INTO yom_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","mu zimpangu zi Nzo Yave, va khatitsikꞌaku ngeyo Yelusalemi. Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Luzitisa Yave, beno makanda moso. Lunyayisa beno batu boso. ");
INSERT INTO yom_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Bila luzolo luandi luidi lunneni kuidi beto, ayi kikhuikizi kiandi kinzingilanga mu zithangu zioso. Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Luvutudila Yave matondo bila niandi widi wumboti ; luzolo luandi lunzingilanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Bika Iseli katuba : luzolo luandi lunzingilanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Bika nzo yi Aloni yituba : luzolo luandi lunzingilanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Bika bobo beti kinzika Yave batuba ; luzolo luandi lunzingilanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Ku tsi ziphasi ziama, ndiyamikina kuidi Yave, ayi wuphana mvutu bu kaphuandisa mu kiphuanza. ");
INSERT INTO yom_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Yave widi ku ndambuꞌama, ndilendi mona tsisi ko. Buna mutu mbi kalenda ku phanga e ? ");
INSERT INTO yom_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Yave widi ku ndambuꞌama, niandi nsadisi ama ; buna ndiela nunga mu tala bambeni ziama. ");
INSERT INTO yom_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Bulutidi mboti mu suaminanga mu Yave viokila mu tula diana mu mutu. ");
INSERT INTO yom_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Bulutidi mboti mu suaminanga mu Yave viokila mu tula diana mu bana ba mintinu. ");
INSERT INTO yom_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Makanda moso manzungidila vayi mu dizina di Yave, ndilembo babungi. ");
INSERT INTO yom_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Mawu manzungidila, ku ndambu ka ndambu vayi mu dizina di Yave, ndilembo babungi. ");
INSERT INTO yom_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Mawu manzungidila banga ziniosi, vayi zifuidi mu nsualu banga zitsendi zinlema mbazu ; mu dizina di Yave, ndilembo babungi ");
INSERT INTO yom_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Bandunguna ku mbusa muingi ndibua vayi Yave wutsadisa. ");
INSERT INTO yom_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Yave niandi zingolo ziama ayi nkungꞌama ; niandi wuyika phulusu ama. ");
INSERT INTO yom_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Yamikina ku khini ayi ku ndungunu kulembo wakana mu zinzo zi ngoto zi batu basonga : koko ku lubakala ku Yave kuvanga mambu ma lulendo. ");
INSERT INTO yom_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Koko ku lubakala ku Yave kuidi ku zangama ngolo ; koko ku lubakala ku Yave kuvanga mambu ma lulendo. ");
INSERT INTO yom_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Ndilendi fua ko vayi ndiela zinga ayi ndiela yamikisa momo Yave kavanga. ");
INSERT INTO yom_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Yave wuphana thumbudulu mu kingolo ; vayi kasia kundiekula ko mu lufua. ");
INSERT INTO yom_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Nzibudila mielo mi busonga, ndiela kota ayi ndiela vutudila Yave matondo. ");
INSERT INTO yom_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Wawu, wawu muelo wu Yave, vawu basonga bafueti kotila. ");
INSERT INTO yom_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Ndiela kuvutudila matondo bila ngeyo wuphana mvutu wuyika phulusu ama. ");
INSERT INTO yom_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Ditadi diloza mintungi diyika ditadi dilutidi mfunu va fuma ki nzo. ");
INSERT INTO yom_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Yave wuvanga diambu diodi ayi didi diambu ditsiminanga va meso meto. ");
INSERT INTO yom_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Kiaki kiawu lumbu kivanga Yave, bika tumona khini ayi tuyangalala mu lumbu beni. ");
INSERT INTO yom_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","A Yave, wutuvukisa ! A Yave, wutusadisa tuluta kuenda ku ntuala. ");
INSERT INTO yom_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Bika kasakumunu mutu wowo wunkuizila mu dizina di Yave ; tona ku nzo Yave, tulembo kulusakumuna. ");
INSERT INTO yom_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Yave niandi Nzambi ayi niandi wutukienzula ; ayi mangiemvo mu mioko, lukota mu ntanda ; nate ku ziphoka zi diziku dimvikulungu makabu. ");
INSERT INTO yom_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Ngeyo Nzambi ama ayi ndiela kuvutudila matondo. Ngeyo Nzambi ama ayi ndiela kuyayisa. ");
INSERT INTO yom_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Luvutudila Yave matondo bila niandi widi wumboti, bila luzolo luandi lunzingilanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Lusakumunu kuidi bobo bandiatilanga mu zinzila ziawu zikambulu tsembolo, bobo bandiatilanga boso buididi mina mi Yave. ");
INSERT INTO yom_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Lusakumunu kuidi bobo bankebanga zinzengolo ziandi ; ayi bakutombanga mu mintima miawu mimvimb ; ");
INSERT INTO yom_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","bavanganga ko kadi diambu di mbimbi, bandiatilanga mu zinzila ziandi. ");
INSERT INTO yom_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Ngeyo wuvana minsiku mu diambu mikinzuku bumboti. ");
INSERT INTO yom_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","A bika zinzila ziama ziba zitelama dio ngui mu diambu ndikizika zinzengolo ziaku ; ");
INSERT INTO yom_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Buna ndilendi fua tsoni ko bu ndiela keba zithumunu ziaku zioso. ");
INSERT INTO yom_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Ndiela kuzitisa mu ntima wululama ; banga minu ndilonguka mina miaku misonga. ");
INSERT INTO yom_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Ndiela kinzika zinzengolo ziaku, kadi tumbu ku ndiekula. ");
INSERT INTO yom_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Buevi ditoko kalenda kebila nzilꞌandi yi vedila e ? Mu zinganga boso buidi mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Ndikutomba mu ntimꞌama wumvimba, kadi tala ti ndivengama mu zithumunu ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Ndisimbidila mambu maku mu ntimꞌama mu diambu ndibika vola masumu kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Nzitusu kuidi ngeyo, a Yave wundonga zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Mu bididi biama, ndilembo tangi mina mioso mintotukanga mu munu aku. ");
INSERT INTO yom_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Ndieti mona khini mu landakana zinzengolo ziaku banga mutu wowo wumona khini mu kimvuama kiwombo. ");
INSERT INTO yom_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Ndieti yindula minsiku miaku ayi ndieti kinzika zinzila ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Ndieti mona khini mu zinzengolo ziaku, ndilendi lenza ko mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Vangila kisadi kiaku mamboti ayi mu ndiela zinga ; ndiela tumukina mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Zibula meso mama mu diambu mona mambu matsiminanga mu mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Ndidi nzenza vava mbata ntoto ; kadi kutsuekila zithumunu ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Muelꞌama widi dilemina di ngolo ; mu diambu di mina miaku mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Ngeyo wunteminanga batu badi luniemo, bobo basingu ayi bobo bavengama mu zithumunu ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Thatudila tsoni ayi dienzi bila ndieti keba zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Ka diambu ko minyandi mivuendi va kimosi ayi mikuthubidila ; kisadi kiaku kiela yindula zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Zinzengolo ziaku zinkumbonisanga khini, zikuphananga zindongi. ");
INSERT INTO yom_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Ndivuanda mu mbungi-mbungi ; keba luzingu luama boso buididi mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Nditangila zinzila ziama ayi ngeyo wuphana mvutu ; wundonga zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Bika ndisudika malongi ma minsiku miaku ; buna ndiela yindula matsiminanga maku. ");
INSERT INTO yom_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Muelꞌama widi wuvonga mu kiadi, wukhindisa boso buididi mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Bika wuphengumuna mu zinzila zi luvunu ; wumbonisa nlemvo mu mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Ndisobula nzila yi Kiedika ; nditula ntimꞌama mu mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Ndidi wukangama mu zinzengolo ziaku, a Yave ; kadi kumbika ndifua tsoni. ");
INSERT INTO yom_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Ndilembo zawula mu nsolo wu zithumunu ziaku bila ngeyo wuvuandisa ntimꞌama mu kiphuanza. ");
INSERT INTO yom_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Wundongisa, a Yave, mu landakana zinzengolo ziaku buna ndiela kuzikeba nate ku tsukulu. ");
INSERT INTO yom_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Wuphana diela ayi ndiela keba mina miaku ayi ndiela ku mikinzika mu ntimꞌama wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Wuthuadisa mu nsolo wu zithumunu ziaku bila muawu ndieti moninanga khini. ");
INSERT INTO yom_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Balula ntimꞌama kuidi zinzengolo ziaku ; vayi bika kuidi ndandu yi luvunu. ");
INSERT INTO yom_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Botula meso mama mu bima biphamba ; keba luzingu luama boso buididi mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Dukisila kisadi kiaku tsilꞌaku, muingi babaka bukukinzikila. ");
INSERT INTO yom_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Vengumuna mvuezolo wowo ndilemou moni tsisi bila mina miaku midi mimboti. ");
INSERT INTO yom_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Phila phuila ndidi yi minsiku miaku ; keba luzingu luama mu busonga buaku. ");
INSERT INTO yom_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Bika luzolo luaku lungolo lutula kuidi minu, a Yave, phulusu aku boso buididi tsilꞌaku, ");
INSERT INTO yom_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","buna ndiela baka bu vanina mvutu kuidi mutu wowo wulembo kumfingi bila nditula diana diama mu mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Kadi tumbu botula mvimba mambu ma kiedika mu munuꞌama bila ndintulanga diana diama mu mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Ndiela tumukinanga Mina miaku kadika thangu mu zithangu zioso ayi mu kadika mvu. ");
INSERT INTO yom_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Ndiela diatilanga mu kiphuanza bila nditomba minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Ndiela yolukila zinzengolo ziaku va ntuala mintinu ayi ndilendi fua tsoni ko. ");
INSERT INTO yom_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Bila khini ndieti mona mu zithumunu ziaku, bila ndieti ku zizola. ");
INSERT INTO yom_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Ndimvumuna mioko miama kuidi zithumunu ziaku, ziozi ndieti zola ayi ndiela yindulanga zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Tebukila moyo mambu maku kuidi kisadi kiaku ; bila ngeyo wuphana diana. ");
INSERT INTO yom_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Mbombolo ama mu ziphasi ziama yawu yayi : tsilꞌaku yeti kitula luzingu luama lumona. ");
INSERT INTO yom_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Batu ba luniemo batsekinina ngolo boso buididi luzolo luawu vayi ndisia vengama ko mu Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Nditebukila moyo mina miaku mikhulu, a Yave ayi ndintambula mbombolo mu miawu. ");
INSERT INTO yom_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Kiadi kimbuila mu diambu di batu bambimbi ; bobo beti loza Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Zinzengolo ziaku ziawu zingudi zi mambu ma minkunga miama ku kadika buangu kioki ndieti leka. ");
INSERT INTO yom_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Nditebukilanga moyo dizina diaku va builu, a Yave, ayi ndiela keba Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Diadi diba diambu ndisadila : ndintumukina minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Ngeyo kuku kiama, a Yave. Ndivana tsila ti ndiela tumukina mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Nditomba zizi kiaku mu ntimꞌama wumvimba, wutsila nlemvo boso buididi tsilꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Ndiyindula zinzila ziama ayi nditadisa malu mama kuidi zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Ndiela tula nsualu ayi ndilendi zingila ko ; mu diambu di keba zithumunu ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Ka diambu ko batu bambimbi bakhengi mu minsinga vayi ndisia zimbakana ko Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Ndieti kotuka va midi miphipa mu kuvutudila matondo mu diambu di Mina miaku misonga. ");
INSERT INTO yom_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Ndidi nkundi wu batu boso bobo beti kukinzika ayi wu bobo beti landakana minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Ntoto wufulukidi mu luzolo luaku, a Yave ; bika wundonga zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Vangila kisadi kiaku mamboti boso buididi mambu maku, a Yave. ");
INSERT INTO yom_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Bika wundongisa nzayilu ayi tsudukulu yimboti bila ndiwilukila zithumunu ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Tuamina ndiba mu phasi, minu ndiba ndiengidi vayi buabu ndieti tumimina mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Ngeyo widi wumboti ayi momo weti vanga madi mamboti ; bika wundongisa zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Ka diambu ko batu ba luniemo balembo bivisa nzitusu ama mu mambu ma luvunu mu diambu diama minu ndiela kebanga minsiku miaku mu ntimꞌama wumvimba. ");
INSERT INTO yom_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Mintima miawu midi mi matadi ayi miwanga ko vayi minu khini ndieti mona mu mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Didi diambu di mboti kuidi minu mu monoso phasi muingi ndilonguka zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Mina mitotukila mu munu aku milutidi mfunu kuidi minu viokila zimili zimili zi bivanzi bi nolo ayi bi palata. ");
INSERT INTO yom_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Mioko miaku miawu mikhubika ayi miphanga. Bika wuphana tsudukulu yi longukila zithumunu ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Bika bobo beti ku kinzika bamona khini bu beti kumbona, bila nditula diana diama mu mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Nzebi, a Yave, ti mina miaku midi misonga mu kikhuikizi ngeyo wumbonisa phasi. ");
INSERT INTO yom_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Bika luzolo luaku lu ngolo luba mbombolo ama boso buididi tsila yoyi wusila kisadi kiaku. ");
INSERT INTO yom_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Bika kiadi kiaku kiba va minu mu diambu ndizinga bila khini ndieti mona Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Bika batu ba luniemo bafua tsoni, mu mambimbi beti kuphangila mu kambu bila vayi minu ndiela yindulanga minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Bika bobo beti ku kinzikanga babaluka kuidi minu ; bobo beti sudika zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Bika ntimꞌama wuba wukambu tsembolo va ntuala zinzengolo ziaku mu diambu ndibika fuisu tsoni. ");
INSERT INTO yom_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Muelꞌama wuvongidi mu diambu di phuila yi phulusu aku ; vayi ndintula diana diama mu mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Meso mama mavongidi ; malembo tadidila tsilꞌaku ; ndituba : “thangu mbi wela kuiza ku mbomba e ?” ");
INSERT INTO yom_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Ka diambu ko ndidi banga kamununu ki vinu kitudulu va muisi ; vayi ndisia zimbakana ko zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Nate thangu mbi kisadi kiaku kafueti vingidila e ? Thangu mbi wela vanina thumbudulu kuidi batu bobo beti ku ndiamisa e ? ");
INSERT INTO yom_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Batu ba luniemo bakebi mabulu ma mintambu mu diambu diama ; buawu ko bobo buididi Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Zithumunu ziaku zioso zifueni mu tudulu diana ; bika wutsadisa bila batu balembo ndiamisa mu kambu bila. ");
INSERT INTO yom_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Keti fioti kuandi fisiala nganu bambotudi va ntoto ; vayi minu ndisia loza ko minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Keba luzingu luama boso buididi luzolo luaku ayi ndiela tumukina zinzengolo zi munu aku. ");
INSERT INTO yom_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Mambu maku, a Yave, manzingilanga mu zithangu zioso ; madi matelama dio ngui mu diyilu. ");
INSERT INTO yom_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Kikhuikizi kiaku kinzingilanga mu zitsungi zioso. Ngeyo wukindisa ntoto ayi wawu wulembo zingila. ");
INSERT INTO yom_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Mina miaku minzingilanga nate lumbu kiaku : bila bima bioso bieti kusadila. ");
INSERT INTO yom_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Enati Mina miaku misia kumbonisa khini ko nganu ndibiva mu ziphasi ziama. ");
INSERT INTO yom_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Ndilendi zimbakana ko minsiku miaku bila mu miawu weti kebila luzingu luama. ");
INSERT INTO yom_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Wuphukisa bila ndidi waku ; nditomba minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Batu bambimbi balembo mfiedi mu diambu bambunga ; vayi ndiela yindula zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Mu kadika diambu di fuana, ndilembo moni ndilu ; vayi zithumunu ziaku zisiko kadi ndilu. ");
INSERT INTO yom_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","A phila ndieti zodila mina miaku ! Miawu ndieti yindula mu lumbu kimvimba. ");
INSERT INTO yom_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Zithumunu ziaku zikhitula mutu wu nduenga viokila bambeni ziama bila ziawu zidi kaka yama mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Minu ndieti luta sudika viokila minyiyisi miama mioso bila ndinyindulanga zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Minu ndieti luta sudika viokila bakulutu bila ndinkebanga minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Ndikeba malu mama mu diatila mu woso-woso nsolo wu mbimbi mu diambu dikeba mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Ndisia vengama ko mu mina miaku bila ngeyo veka wundonga. ");
INSERT INTO yom_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","A phila lueki mambu maku madi mu munu ama viokila niosi mu munu ama. ");
INSERT INTO yom_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Mbeki diela mu diambu di minsiku miaku ; diawu ndinlendilanga woso-woso nsolo wu mbimbi. ");
INSERT INTO yom_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Mambu maku madi muinda mu malu mama ayi kiezila mu nsoloꞌama. ");
INSERT INTO yom_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Ndinzenga ndefi ayi ndiyikindisa : ti ndiela landakana mina miaku mi busonga. ");
INSERT INTO yom_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Ndimona ziphasi ziwombo ; keba luzingu luama, a Yave, boso buididi mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Kikinina, a Yave, minsitusu mi luzolo mi munu ama ayi wundongisa mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Ka diambu ko kadika thangu ndieti nata luzingu luama mu mioko miama, ndikadi zimbakana Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Batu bambimbi balekidi ntambu mu diambu diama, vayi ndisia vengama ko mu minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Zinzengolo ziaku zidi kiuka kiama mu zithangu zioso ; ziawu zidi khini yi ntimꞌama. ");
INSERT INTO yom_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Ntimꞌama wuvuendi mu kebanga zinzengolo ziaku nate kuna tsuka. ");
INSERT INTO yom_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Ndieti lenda batu badi mintima miodi, vayi ndieti zola Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Ngeyo suamunu kiama ayi nkakuꞌama ; nditula diana diama mu mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Bika luthatukila beno batu lueti vanga mambu mambimbi ; muingi ndikeba zithumunu zi Nzambi ama. ");
INSERT INTO yom_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Bika wukhindisa boso buididi tsilꞌaku buna ndiela zinga ; kadi tala ti diana diama dilalukusu. ");
INSERT INTO yom_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Bika ngeyo wuba singumunu kiama ayi ndiela kulu ; buna ndiela talanga zinzengolo ziaku mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Ngeyo wuloza batu boso bobo beti zimbala mu zinzengolo ziaku bila luvunu luawu luidi lu phamba. ");
INSERT INTO yom_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Batu boso bambimbi ba ntoto, ngeyo weti kuba vengumuna banga tsobo diawu minu ndieti zodila zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Nsuni ama wulembo titi mu diambu di tsisi aku ; thelimini mu boma bu mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Ndivanga mambu masonga ayi mafuana kadi kundiekula kuidi minyamisi miama. ");
INSERT INTO yom_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Kubikila kisadi kiaku mamboti ; kadi tala ti batu ba luniemo bandiamisa. ");
INSERT INTO yom_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Meso mama mavongidi, malembo tadidila phulusu aku, malembo tadidila tsilꞌaku yisonga. ");
INSERT INTO yom_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Vangila kisadi kiaku mamboti boso buididi luzolo luaku ayi wundonga zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Ndidi kisadi kiaku ; wuphana diela, muingi ndisudika zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Thangu yifueni kuidi ngeyo mu sala, a Yave ; mina miaku mibundukidi. ");
INSERT INTO yom_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Bila ndieti zola zithumunu ziaku viokila nolo, viokila kutu nolo yithalu ; ");
INSERT INTO yom_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","ayi bila ndilembo kinzika minsiku miaku mioso milulama Ndinlendanga woso-woso nsolo wu mbimbi. ");
INSERT INTO yom_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Zinzengolo ziaku zidi zi matsiminanga diawu ndieti kuzitumukina. ");
INSERT INTO yom_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Zaba ti mambu maku meti vana kiezila ; meti vana diela kuidi batu baphamba. ");
INSERT INTO yom_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Ndinzibula munu ama ayi ndivumuna mu phuila yi ngolo yi zithumunu ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Baluka kuidi minu ayi wumbona kiadi, banga bobo weti vangila mu zithangu zioso kuidi bobo banzolanga dizina diaku. ");
INSERT INTO yom_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Tuadisa zithambi zi malu mama boso buididi mambu maku, kadi tala kadi disumu di ndiadila. ");
INSERT INTO yom_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Wukhula mu kuamusu wu batu mu diambu ndibaka bu tumukina minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Kienzudila kisadi kiaku zizi ayi wundongisa zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Matsuela mawombo malembo kumbi mu meso mama banga mila mi nlangu mu diambu Mina miaku mikadi kinzuku. ");
INSERT INTO yom_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Ngeyo widi wusonga, a Yave ayi mina miaku midi milulama. ");
INSERT INTO yom_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Zinzengolo wutula zidi zisonga, zidi zifuana mboti mu siwulu diana. ");
INSERT INTO yom_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Bufula buama mu kusadila bulembo tsukisa ntima, bila bambeni ziama zisi zaba ko mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Zitsila ziaku zimonika ti zidi zikiedika, ayi kisadi kiaku wukuzizolanga. ");
INSERT INTO yom_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Ka diambu ko ndidi mutu wuvumbama ayi wulenzu, ndikadi zimbakana minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Busonga buaku buidi mu zithangu zioso ayi mina miaku midi mikiedika. ");
INSERT INTO yom_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Ziphasi ayi maniongo bimbuididi, vayi zithumunu ziaku zikumbonisanga khini. ");
INSERT INTO yom_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Zinzengolo ziaku zidi zilulama mu zithangu zioso ; wuphana diela muingi ndizinga. ");
INSERT INTO yom_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Nditela mu ntimꞌama wumvimba ; wuphana mvutu, a Yave ayi ndiela kinzika zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Ndikutela, wuphukisa ayi ndiela keba zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Ndieti kotuka tuamina nkielo buisi wuba ayi ndinyamikinanga muingi wutsadisa ; minu nditula diana diama mu mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Meso mama meti ba mazibuka tuamina khiesa yi builu, mu diambu ndiyindula zitsila ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Wa mbemboꞌama boso buididi luzolo luaku keba luzingu luama, a Yave, boso buididi mina miaku ");
INSERT INTO yom_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Bobo beti kubika zikhanu zimbimbi bafikimini, vayi thama badi ayi Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Muaki, ngeyo widi wufikama, a Yave ayi zithumunu ziaku zioso zidi zikiedika. ");
INSERT INTO yom_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Tona thama ndizaba, ndilongukala zinzengolo ziaku ti ngeyo wumana zibieka mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Bika wutala ziphasi ziama ayi bika wukhula bila ndisia zimbakana ko Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Bika wunduanina ayi bika wukhula, keba luzingu luama boso buididi zitsila ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Phulusu thama yidi mu diambu di batu bambimbi bila batombanga ko zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Kiadi kiaku kidi kinneni, a Yave ; keba luzingu luama boso buididi mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Batu bobo beti kundenda badi bawombo ayi beti kundiamisa ; vayi ndikadi vengama mu zinzengolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Ndieti kakumukina batu bobo bakambulu minu bila batumukinanga ko mambu maku ");
INSERT INTO yom_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Tala phila ndieti zodila minsiku miaku, keba luzingu luama, a Yave, boso buididi luzolo luaku. ");
INSERT INTO yom_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Mambu maku moso madi makiedika ; Mina miaku mioso misonga midi mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Minyadi mindiamisini mu kambu bila vayi ntimꞌama wulembo titi va ntuala mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Khini ndieti mona mu tsilꞌaku banga mutu beki kiuka kinneni mu mvita. ");
INSERT INTO yom_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Ndieti lenda ayi ndieti kakumukina luvunu vayi ndieti zola Mina miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Ndieti kuzitisa mu tsambuadi di zikhumbu mu lumbu mu diambu di Mina miaku misonga. ");
INSERT INTO yom_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Ndembama yiwombo yidi kuidi bobo banzolanga Mina miaku ; kuisi ko diambu dimosi diba lenda buminina thutu ");
INSERT INTO yom_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Ndilembo vingila phulusu aku, a Yave ayi ndieti landakana zithumunu ziaku. ");
INSERT INTO yom_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Ndieti tumimina zinzengolo ziaku bila ndieti kuzizola ngolo ");
INSERT INTO yom_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Ndieti tumimina minsiku miaku ayi zinzengolo ziaku bila ngeyo zebi zinzila ziama zioso. ");
INSERT INTO yom_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Bika yamikina kuama kutula va ntualꞌaku, a Yave wuphana diela boso buididi mambu maku. ");
INSERT INTO yom_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Bika ndombolo ama yitula va ntualꞌaku ; wukhula boso buididi tsilꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Bika bididi biama bisapika mu nzitusu aku bila weti kundonga zinzengolo ziaku ");
INSERT INTO yom_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Bika ludimi luama luyimbila mambu maku bila zithumunu ziaku zioso zidi zisonga. ");
INSERT INTO yom_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Bika koko kuaku kuba kukubama mu kutsadisa bila ndisobula minsiku miaku. ");
INSERT INTO yom_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Phuila yingolo ndiba mu mona phulusu aku, a Yave ayi Mina miaku mikumbonisanga khini. ");
INSERT INTO yom_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Bika ndizinga muingi ndizitisa ayi bika mina miaku mitsimba ");
INSERT INTO yom_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Ndidiengila banga nkangu wu mamemi mazimbala, tomba kisadi kiaku, bila ndisia zimbakana ko zithumunu ziaku. ");
INSERT INTO yom_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Nkunga wuyimbudulu mu nzila yikuendila ku nzo Yave. Nditela Yave mu ziphasi ziama ayi niandi wupheni mvutu. ");
INSERT INTO yom_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Wuphukisa, a Yave, mu bididi bi luvunu ayi mu ludimi luidi mayuya. ");
INSERT INTO yom_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Mbi kalenda kuvangila ayi mbi kalenda buela, ludimi luidi mayuya e ? ");
INSERT INTO yom_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Wela kuvana thumbudulu mu madionga ma kinuani malengulu bumboti ; mu makala ma mbazu, ma nungu-tsendi, ");
INSERT INTO yom_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","mabienga kuidi minu bu ndilembo vuandi ku Metsiseki ; bu ndieti zingila mu zinzo zi ngoto zi Kedali. ");
INSERT INTO yom_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Mu bilumbu biwombo ndizingila va khatitsika batu bobo banlendanga ndembama. ");
INSERT INTO yom_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Minu ndidi mutu wu ndembama ; vayi minu yoluka, buna bawu beka yindula mvita. ");
INSERT INTO yom_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Nkunga wuyimbudulu mu nzila yikuendila ku nzo Yave. Ndimvumbulanga meso mama ku miongo, kuevi kuela totukila lusadusu luama e ? ");
INSERT INTO yom_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Lusadusu luama luntotukila kuidi Yave ; mvangi wu diyilu ayi ntoto. ");
INSERT INTO yom_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Kalendi bika ko kulu kuaku kusialumuka ; mutu wowo weti kukebanga kalendi niungina ko. ");
INSERT INTO yom_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Bukiedika, mutu wowo weti sunga Iseli, kalendi niungina ko voti leka tulu ko ");
INSERT INTO yom_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Yave niandi wukusunganga, niandi kitsusula kiaku va koko kuaku ku lubakala. ");
INSERT INTO yom_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Thangu yilendi ku vanga ko mbimbi va muini voti ngondi va builu. ");
INSERT INTO yom_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Yave wela kukebanga mu mambimbi moso, niandi wela sunganga luzingu luaku. ");
INSERT INTO yom_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Yave wela kusunga mu kuiza kuaku ayi mu kuenda kuaku tona buabu nate mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Nkunga Davidi wuyimbudulu mu nzila yikuendila ku nzo Yave. Khini ndimona bu bakhamba ti : “Bika tuendanu ku nzo Yave”. ");
INSERT INTO yom_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Malu meto matelimini mu mielo miaku, a Yelusalemi. ");
INSERT INTO yom_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Yelusalemi ditungu banga divula. Diodi dikangama ngolo va kimosi ");
INSERT INTO yom_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Kuna kueti kuiza zimvila, zimvila Yave mu diambu di zitisa dizina di Yave boso buididi zinzengolo zivanu kuidi Iseli. ");
INSERT INTO yom_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Bila kuna kutelimini bikundu bi kipfumu bi tsambusulu ; bikundu bi kipfumu bi nzo yi Davidi. ");
INSERT INTO yom_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Lusambila mu diambu di ndembama yi Yelusalemi. Bika bobo beti kuzola bamona luvovomo. ");
INSERT INTO yom_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Bika ndembama yiba mu bibaka biaku ayi luvovomo mu zinzo ziaku zinneni. ");
INSERT INTO yom_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Mu diambu di bakhomba ziama ayi bakundi bama ndiela tuba “bika ndembama yiba yaku”. ");
INSERT INTO yom_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Mu diambu di nzo Yave, Nzambi eto, ndiela tomba mamboti maku. ");
INSERT INTO yom_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Nkunga wunyimbudulu mu nzila yikuendila ku nzo Yave. Ndimvumbula meso mama kuidi ngeyo Yave ngeyo beki kundu kiaku ki Kipfumu mu diyilu. ");
INSERT INTO yom_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Banga meso ma bavika meti tala mioko mi bapfumu bawu ; banga meso ma kisadi kinketo mantalanga mioko mi pfumu andi wu nketo ; buawu bobo meso meto mantadilanga kuidi Yave, Nzambi eto, nate kela kutumona kiadi. ");
INSERT INTO yom_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Wutumoni kiadi, a Yave, wutumoni kiadi bila nlenzo wuwombo tutambudi. ");
INSERT INTO yom_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Mvuezolo wuwombo tutambula kuidi bankua luniemo ; nlenzo wuwombo kuidi bankua lunangu. ");
INSERT INTO yom_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Nkunga Davidi wunyimbudulu mu nzila yikuendila ku nzo Yave. Bika Iseli katuba : Enati Yave kasia ba ku ndambuꞌeto ko ; ");
INSERT INTO yom_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Enati Yave kasia ba ku ndambu eto ko mu thangu batu batelama mu kutunuanisa ; ");
INSERT INTO yom_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","mu thangu nganzi awu yitubuila, keti nganu mina batumina bamoyo ; ");
INSERT INTO yom_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","khuka nlangu yitumbu kutuvitumuna ayi nguma yi nlangu yitudiamisa, ");
INSERT INTO yom_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","minlangu mi nguma mitulalumuna. ");
INSERT INTO yom_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Nzitusu wuba kuidi Yave mutu wowo wukambu kutuyekula batukanzuna mu meno ma miunu miawu. ");
INSERT INTO yom_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Tutina banga nuni bu keti tinina mu dikondi di ntambi wu zinuni. Dikondi dikanzuka ayi beto tutina. ");
INSERT INTO yom_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Lusadusu lueto luidi mu dizina di Yave, mvangi wu diyilu ayi ntoto. ");
INSERT INTO yom_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Nkunga wunyimbudulu mu nzila yikuendila ku nzo Yave. Bobo bantulanga diana diawu mu Yave badi banga mongo wu Sioni, wowo wulendi nikuka ko vayi wunzingilanga mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Banga miongo bu mizungididi Yelusalemi, buawu bobo Yave kazungididi batu bandi tona buabu nate mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Nkawa wu kipfumu wu batu bambimbi wulendi vuandanga ko va mbata ntoto wukubukulu batu basonga ; bila nganu batu basonga bela sadila mioko miawu mu vanga mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Vanga mamboti, a Yave, kuidi batu bamboti, kuidi bobo badi balulama mu mintima. ");
INSERT INTO yom_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Vayi bobo beti vengama mu diatila mu zinzila zivenga, Yave wela kuba lalikisa va kimosi ayi bobo bamvanganga mambimbi. Ndembama yibanga vadi Iseli. ");
INSERT INTO yom_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Nkunga wunyimbudulu mu nzila yi kuendila ku nzo Yave. Mu thangu Yave kavutula batu bakangama ku Sioni, tuba banga batu banlota zindozi. ");
INSERT INTO yom_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Miunu mieto miba miwala masevo ; ludimi lueto minkunga mi khini. Buna batuba muidi makanda ti : “Yave wuba vangidi mambu manneni.” ");
INSERT INTO yom_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Yave wutuvangidi mambu manneni ; ayi khini yitufulukidi. ");
INSERT INTO yom_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Vutula diaka kimvuama kieto, a Yave ; banga bina bimila bi minlangu ku Nengevi. ");
INSERT INTO yom_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Bobo beti kuna ayi matsuela mu meso, bela vedila mu minkunga mi khini. ");
INSERT INTO yom_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Wuntotukanga ku nganda ayi matsuela mu meso ; wunatanga mbongo mu kuna ; weti vutuka ayi minkunga mi khini mu natanga mimvumba mi biti. ");
INSERT INTO yom_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Nkunga Salomo wunyimbudulu mu nzila yikuendila ku nzo Yave. Enati Yave kakadi tunga nzo, buna batu bobo balembo tungi mu phamba kuandi balembu sadila. Enati Yave kakadi sunga divula buna batu bobo balembo disungi mu phamba kuandi balembo disungila. ");
INSERT INTO yom_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Mu phamba kuandi lueti kotukila nsuka-nsuka ayi lueti kambu vika lekilanga, lueti sadilanga ngolo mu diambu di bidia bi dia ; bila bobuawu keti vanina kuidi bobo keti zola bu badi ku tulu. ");
INSERT INTO yom_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Bana badi kiuka kimbanga kuidi Yave, bosi mbutu wu bana widi mfutu wumbanga kuidi niandi. ");
INSERT INTO yom_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Banga madionga mu mioko mi kinuani ki lulendo, buawu bobo buididi bana mutu kabutidi mu kimuana kiandi. ");
INSERT INTO yom_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Lusakumunu kuidi mutu wowo wuwesa bawu mu khutu andi. Balendi fua tsoni ko mu thangu bela tubana ayi bambeni ziawu ku muelo. ");
INSERT INTO yom_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Nkunga wunyimbudulu mu nzila yikuendila ku nzo Yave. Lusakumunu kuidi batu boso bobo bobo beti kinzika Yave, bandiatilanga mu zinzila ziandi. ");
INSERT INTO yom_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Ngeyo wela dia mbutu wu kisalu kiaku. Lusakumunu ayi mamboti biela ba biaku. ");
INSERT INTO yom_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Nketo aku wela ba banga vinu yidi mbozi yiwombo mu khati nzo aku ; bana baku banga mintiudila mi olive muyendila mezꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Buawu bobo buididi mutu wusakumunu, wowo weti kinzika Yave. ");
INSERT INTO yom_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Bika Yave kalusakumuna, tona ku Sioni mu bilumbu bioso bi luzingu lueno ; bika lumona mamboti ma Yelusalemi ");
INSERT INTO yom_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","ayi bika lumona bana ba bana beno. Bika ndembama yiba vadi Iseli. ");
INSERT INTO yom_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Nkunga wunyimbudulu mu nzila yikuendila ku nzo Yave. Bandiamisa ngolo tona mu bumuana buama, bika Iseli katuba. ");
INSERT INTO yom_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Bandiamisa ngolo tona mu bumuana buama vayi basia ku ndunga ko. ");
INSERT INTO yom_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Minkuni midima manima mama ; batula muawu minkala miawu mimula. ");
INSERT INTO yom_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Vayi Yave widi wusonga ; niandi wuzenga minsinga mi batu bambimbi muingi ndiba mu kiphuanza. ");
INSERT INTO yom_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Bika babo beti lenda Sioni bavutuka fua tsoni. ");
INSERT INTO yom_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Bika baba banga biti bi mbata muanzu, biobi bieti yuma tuamina biyunduka ; ");
INSERT INTO yom_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","biobi mvedi kalendi wesa mu mioko miandi ko ; voti mutu wowo wunkanga mvumba kalendi wesi mu mioko miandi ko. ");
INSERT INTO yom_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Bika bobo bamviokila vana babika tuba : “lusakumunu lu Yave lubanga yeno ! Tueti kulusakumuna mu dizina di Yave !” ");
INSERT INTO yom_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Nkunga wunyimbudulu mu nzila yinkuendila ku nzo Yave. Bu nditotuka mu mabulu madi thipula, ndiyamikina kuidi ngeyo, a Yave. ");
INSERT INTO yom_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","A Yave, wa mbemboꞌama ; bika wutamba matu maku mu yamikina kuama mu diambu di lusadusu. ");
INSERT INTO yom_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Enati ngeyo, a Yave, weti tangisa masumu A Yave buna nani wulenda telama e ? ");
INSERT INTO yom_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Vayi kuidi ngeyo kuidi ndemvukulu yi masumu ; diawu fueni kinzuku. ");
INSERT INTO yom_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Ndimvingila Yave, muelꞌama wulembo vingila ; ayi mu mambu mandi, ndintula diana diama. ");
INSERT INTO yom_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Muelꞌama wumvingila Yave viokila minsungi mimvingila nsuka. Nyinga viokila minsungi mimvingila nsuka. ");
INSERT INTO yom_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","A Iseli, tula diana diaku mu Yave Bila mu niandi muidi luzolo lu ngolo ayi mu niandi muidi khudulu yiduka. ");
INSERT INTO yom_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Niandi veka wela kula Iseli mu masumu mawu moso. ");
INSERT INTO yom_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Nkunga Davidi wunyimbudulu mu nzila yikuendila ku nzo Yave. Ntimꞌama wisi luniemo ko, a Yave, meso mama masi lunangu ko. Ndiyindulanga ko mambu malutidi manneni voti momo madi matsiminanga kuidi minu. ");
INSERT INTO yom_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Vayi ndivumbika muelꞌama ayi ndidingimisa wawu ; banga muana wutsombi wulemboso mabeni widi va kimosi ayi ngudi andi ; banga muana wutsombi wulemboso mabeni buawu buididi muelꞌama mu minu. ");
INSERT INTO yom_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","A Iseli, tula diana diaku mu Yave tona buabu nate mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Nkunga wunyimbudulu mu nzila yikuendila ku nzo Yave. A Yave, tebukila Davidi moyo ayi ziphasi ziandi zioso kamona ; ");
INSERT INTO yom_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","wuzenga ndefi kuidi Yave ayi wuvanga lukanu kuidi nkua lulendo wu Yakobi : ");
INSERT INTO yom_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“Ndilendi kota ko mu nzo ama ; voti kuenda va mbukꞌama. ");
INSERT INTO yom_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","Ndilendi vana ko meso mama minsua mu bua ku tulu ; zindabu ziama mu laba, ");
INSERT INTO yom_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","nate ndimbakula buangu mu diambu di Yave, buangu kivuanda mu diambu di nkua lulendo wu Yakobi.” ");
INSERT INTO yom_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Tuwa tsangu beni ku Efalata, tuwila yawu mu zitsola zi Yali. ");
INSERT INTO yom_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Bika tuenda ku buangu kiandi kioki keti vuanda ; bika tubuongama va ntuala kima kioki keti tetika malu mandi. ");
INSERT INTO yom_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Telama, a Yave, ayi kota ku buangu kiaku kivundila ngeyo va kimosi ayi kesi yi zingolo ziaku. ");
INSERT INTO yom_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Bika zinganga ziaku zi Nzambi zivuata busonga ; bika banlongo baku bayimbila mu khini. ");
INSERT INTO yom_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Mu diambu di Davidi kisadi kiaku, kadi loza mutu aku wowo wuvinda mafuta. ");
INSERT INTO yom_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Yave wuzenga ndefi kuidi Davidi ; ndefi yikiedika yoyi kalendi viakisa ko : “wumosi mu nkunꞌaku ndiela tula va kundu kiaku ki Kipfumu. ");
INSERT INTO yom_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Enati bana baku bakebidi Nguizani ama ayi zinzengolo ziozi ndiela ku balonga, buna bana bawu bela vuanda va kundu kiaku ki kipfumu.” ");
INSERT INTO yom_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Bila Yave wusobula Sioni ; wuzola Sioni ngolo mu ba buangu kiandi kika fueti vuandanga : ");
INSERT INTO yom_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","“Vava vadi buangu kiama kivundila mu zithangu zioso. Vava ndiela tula kundu kiama ki kipfumu bila ndizola vawu. ");
INSERT INTO yom_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Ndiela kunsakumuna mu bima biwombo ; minsukami miandi, ndiela kuba yukutisa mu bidia. ");
INSERT INTO yom_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Ndiela vuika zinganga ziandi phulusu ayi kadika thangu banlongo bandi bela yimbilanga mu khini. ");
INSERT INTO yom_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Vava ndiela vanga phoka yi yunduka mu diambu Davidi ayi kubika muinda mu diambu di mutu ama ndivinda mafuta. ");
INSERT INTO yom_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Ndiela vuika bambeni ziandi tsoni vayi budu ki kipfumu kiela lezamanga. Va mbata ntu andi.” ");
INSERT INTO yom_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Nkunga Davidi wunyimbudulu mu nzila yikuendila ku nzo Yave. Phila mboti ayi kitoko kuidi bakhomba mu thangu zinzingilanga va kimosi mu kithuadi. ");
INSERT INTO yom_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Diambu beni didi banga mafuta ma thalu madukulu ku ntu, mankumba nate mu mayedo, mankumba nate mu mayedo ma Aloni, mankumba nate mu zitsongi zi zilobi ziandi. ");
INSERT INTO yom_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Didi banga bimi bi Helimoni bieti kumba mu miongo mi Sioni, bila kuna Yave keti vanina lusakumunu luandi, luzingu mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Nkunga wunyimbudulu mu nzila yikuendila ku nzo Yave. Luzitisa Yave beno bisadi bioso bi Yave ; beno lunsalanga mu builu mu nzo Yave. ");
INSERT INTO yom_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Vumbulanu mioko mieno mu buangu kinlongo ayi luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Bika Yave mvangi wu diyilu ayi ntoto ; kalusakumuna tona ku Sioni. ");
INSERT INTO yom_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Luzitisa Yave, luzitisa dizina di Yave, lunzitisa beno bisadi bi Yave ; ");
INSERT INTO yom_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","beno lunsalanga mu Nzo Yave, mu ziphangu zi Nzo yi Nzambi eto. ");
INSERT INTO yom_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Luzitisa Yave bila Yave widi wumboti ; luyimbila minzitusu mu diambu di dizina diandi, bila didi diambu di kitoko. ");
INSERT INTO yom_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Bila Yave wukisobudila Yakobi mu ba wandi veka, Iseli, mu diambu kaba kiuka kioki kavuidi niandi veka. ");
INSERT INTO yom_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Nzebi ti Yave widi wunneni, ti Yave eto widi wunneni viokila zinzambi zioso. ");
INSERT INTO yom_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Muaki Yave weti vanga moso kazodidi, mu diyilu ayi vava ntoto, mu mimbu ayi mu mabulu mawu moso madi thipula. ");
INSERT INTO yom_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Niandi wuntotulanga matuti mu zitsongi zi ntoto ; niandi wumfidisanga zitsiemo va kimosi ayi mvula ayi wuntotulanga phemo mu bibuangu biandi biobi kalundila wawu. ");
INSERT INTO yom_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Niandi wuvonda bana batheti mu Ezipite, bana batheti ba batu ayi ba bibulu. ");
INSERT INTO yom_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Wufidisa bidimbu biandi ayi matsiminanga va khatitsikꞌaku, a Ezipite mu diambu di nuanisa Falawo ayi bisadi biandi bioso. ");
INSERT INTO yom_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Niandi wuvonda makanda mawombo ayi wuvonda mintinu mi lulendo. ");
INSERT INTO yom_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Sihoni ntinu basi Amoli ; Ongi ntinu basi Basani ayi mintinu mioso mi Kana. ");
INSERT INTO yom_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Ayi wuvana zitsi ziawu banga kiuka ; kiuka kuidi Iseli, batu bandi. ");
INSERT INTO yom_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Dizina diaku, a Yave, dinzingilanga mu zithangu zioso, zitsangu ziaku, a Yave, mu zitsungi zioso. ");
INSERT INTO yom_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Bila Yave wela nungisa batu bandi ayi wela mona bisadi biandi kiadi. ");
INSERT INTO yom_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Bitumba bi makanda bidi bi palata ayi bi nolo ; bivangulu mu mioko mi batu ; ");
INSERT INTO yom_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","bibeki miunu vayi bilendi tuba ko ; meso vayi bilendi mona ko ; ");
INSERT INTO yom_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Bibeki matu vayi bilendi wa ko bisi kadi phemo ko mu miunu miawu. ");
INSERT INTO yom_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Batu bobo beti vanga biawu bela ba banga biawu ayi buawu bobo buela bela bobo bantulanga diana mu biawu. ");
INSERT INTO yom_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","A nzo yi Iseli, luzitisa Yave. A nzo yi Aloni, luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","A nzo yi Levi, luzitisa Yave. Beno lueti kunkinzika, luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Bika nzitusu wuba kuidi Yave tona mu Sioni kuidi niandi weti vuanda ku Yelusalemi. Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Luvutudila Yave matondo bila niandi widi wumboti, ");
INSERT INTO yom_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Luvutudila Nzambi yi zinzambi matondo, ");
INSERT INTO yom_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Luvutudila Pfumu yi bapfumu matondo, ");
INSERT INTO yom_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","niandi kaka, wumvanganga matsiminanga, ");
INSERT INTO yom_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","niandi wuvanga diyilu mu diela diandi ");
INSERT INTO yom_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Niandi wuyalumuna ntoto va mbata minlangu ; ");
INSERT INTO yom_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Niandi wuvanga kiezila kingolo ");
INSERT INTO yom_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","thangu mu diambu di yadila muini, ");
INSERT INTO yom_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","ngondi ayi zimbuetete mu diambu di yadila builu, ");
INSERT INTO yom_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","kuidi niandi bila niandi wuvvonda bana batheti mu Ezipite, ");
INSERT INTO yom_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","ayi wutotula bana ba Iseli va khatitsika basi Ezipite ");
INSERT INTO yom_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","mu koko ku ngolo ayi ku yalumuka, ");
INSERT INTO yom_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Kuidi niandi bila niandi wuvasa mbu wu mbuaki mu zindambu zizole, ");
INSERT INTO yom_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","ayi wuviokisila Iseli va khatitsika mbu wu mbuaki, ");
INSERT INTO yom_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","vayi wulalumusa Falawo ayi masodi mandi mu mbu wu mbuaki, ");
INSERT INTO yom_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","kuidi niandi bila niandi wudiatisa batu bandi mu dikanga ; ");
INSERT INTO yom_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Niandi wuvonda mintinu minneni, ");
INSERT INTO yom_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","ayi wuvonda mintinu mi lulendo, ");
INSERT INTO yom_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Sihoni, ntinu basi Amoli, ");
INSERT INTO yom_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","ayi Ongi, ntinu basi Basani, ");
INSERT INTO yom_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","ayi wuvana zitsi ziawu banga kiuka, ");
INSERT INTO yom_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","kiuka kuidi kisadi kiandi, Iseli, ");
INSERT INTO yom_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","kuidi niandi, mutu wowo wututebukila moyo mu kambu kueto ku luvalu, ");
INSERT INTO yom_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","ayi wutuvana kiphuanza mu bambeni zieto, ");
INSERT INTO yom_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","ayi niandi wumvananga bidia kuidi kioso-kioso vangu, ");
INSERT INTO yom_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Luvutudila Nzambi yi diyilu matondo ");
INSERT INTO yom_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Va muenda minlangu minneni mi Babiloni ; tuvuanda ayi tudila bu tutebukila Sioni moyo. ");
INSERT INTO yom_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Kuna tudengidika zingitala zieto mu minti. ");
INSERT INTO yom_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Bila kuna, batu bobo batukanga mu kivika batulomba tuyimbila minkunga ; minyamisi mieto mituyuvula minkunga mi khini ; batuba : “lutuyimbidila nkunga wumosi mu minkunga mi Sioni.” ");
INSERT INTO yom_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","A buevi tulenda yimbidila minkunga mi Yave mu ntoto wu kinzenza e ? ");
INSERT INTO yom_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Enati ndizimbikini, a Yelusalemi ; bika koko kuama ku lubakala kuzimbakana zitsembo ziandi. ");
INSERT INTO yom_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Bika ludimi luama lunama mu mianzi mi munu ama enati ndikadi kutebukila moyo, enati ndikadi ba mayindu mu Yelusalemi, khini ama yoyo yilutidi zangama. ");
INSERT INTO yom_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Tebuka moyo, a Yave, momo basi Edomi bavanga mu lumbu kibua Yelusalemi, Bayamikina : “lutiolumuna, lutiolumuna nate muna zifundasio ziandi.” ");
INSERT INTO yom_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","A muana ndumba wu Babiloni, ngeyo wukubuku mu bungu ; khini kuidi mutu wowo wukuvutudila mambu momo wutuvangila. ");
INSERT INTO yom_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Khini kuidi mutu wumbuila bana baku batsombi ayi wela kuba banda va matadi. ");
INSERT INTO yom_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Nkunga Davidi. Ndiela kuzitisa, a Yave, mu ntimꞌama wumvimba ; ndiela yimbila minzitusu miaku va ntuala zinzambi. ");
INSERT INTO yom_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Ndiela buongama ku ndambu nzo aku yinlongo ; ayi ndiela zitisa dizina diaku mu diambu di luzolu luaku ayi mu diambu di kikhuikizi kiaku bila ngeyo wuyayisidi dizina diaku ayi mambu maku va yilu bima bioso. ");
INSERT INTO yom_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Thangu nditela, ngeyo wuphana mvutu. Wukhitula nkua ngangu ayi nkua bukhafi bu ngolo. ");
INSERT INTO yom_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Bika mintinu mioso mintoto mizitisa, a Yave bu miwilu mambu ma munu aku. ");
INSERT INTO yom_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Bika miyimbila zinzila zi Yave bila nkembo wu Yave widi wunneni. ");
INSERT INTO yom_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Ka diambu ko Yave widi wuzangama, niandi weti tala bobo beti kukikulula ayi zebi bumboti batu badi luniemo bu badi ku thama. ");
INSERT INTO yom_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Ka diambu ko ndilembo diatila va khatitsika ziphasi, ngeyo weti tanina luzingu luama ; ngeyo weti nonuna koko kuaku mu kakidila zinganzi zi bobo beti kundenda ; mu koko kuaku ku lubakala weti kuphukisila. ");
INSERT INTO yom_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Yave wela dukisa mambu momo keti tomba mu minu. Luzolo luaku, a Yave, lunzingilanga mu zithangu zioso. Kadi yekula bisalu bi mioko miaku. ");
INSERT INTO yom_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Nkunga Davidi kuidi Pfumu minyimbidi. A Yave ngeyo wuthomba ayi ngeyo wunzebi. ");
INSERT INTO yom_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Ngeyo zebi thangu ndidi wuvuanda ayi thangu ndidi wutelama ; ngeyo weti bakula bumboti mayindu mama bu makidi thama. ");
INSERT INTO yom_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ngeyo zebi thangu ndieti totuka ayi thangu ndieti lambalala ; Ngeyo zebi bumboti zinzila ziama zioso. ");
INSERT INTO yom_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Tuamina mambu maba va ludimi luama, ngeyo zebi mawu moso, a Yave. ");
INSERT INTO yom_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Ngeyo wunzungididi ku manima ayi ku ntuala Ngeyo wutetika koko kuaku va minu. ");
INSERT INTO yom_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Nzayilu yi phila yoyi, yididi ngolo yitsiminanga kuidi minu ; yididi ngolo yinangama muingi ndiyibakidila. ");
INSERT INTO yom_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Kuevi ndilenda kuenda suamina phevi aku e ? A kuevi ndilenda kuenda tinina meso maku e ? ");
INSERT INTO yom_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Enati khumini ku Diyilu, ngeyo widi kuna ; enati minu thudidi mbukꞌama ku tsina ntoto, ngeyo widi kuna. ");
INSERT INTO yom_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Enati khumini mu mavavi ma nkielo buisi ; enati phuendi ku lubakala lu mbu, ");
INSERT INTO yom_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","buna kuna diaka, koko kuaku kuela kundiatisa ; koko kuaku ku lubakala kuela kutsimbidila ngolo. ");
INSERT INTO yom_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Enati khembi : “Bukiedika tombi kiela kutsueka” vayi buna kiezila kikitukidi tombi va ndidi. ");
INSERT INTO yom_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Muaki tombi kilendi ba tombi kuidi ngeyo ko ; builu buela kienzuka banga muini bila tombi kidi banga kiezila kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Ngeyo wuvanga binama biama bi khati nitu ; ngeyo wuthunga va kimosi mu vumu ki ngudi ama. ");
INSERT INTO yom_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Ndikuzitisa bila ndidi vangu ki tsisi ayi kitsiminanga ; mavanga maku madi matsiminanga ayi nzebi buawu bumboti. ");
INSERT INTO yom_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Khubukulu ama yi mimvesi yisia suama va ntualꞌaku ko mu thangu ndikubuku mu buangu kisuama ; mu thangu ndivangu va kimosi ku tsina ntoto. ");
INSERT INTO yom_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Meso maku mamona nitu ama yikambu kubuku. Bilumbu bioso biobi wukhubikila biba bisonama mu bukuꞌaku, tuamina lumbu kimosi mu biawu kiba. ");
INSERT INTO yom_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","A phila thalu mayindu maku kuidi minu, a Nzambi ! A phila woka madi ! ");
INSERT INTO yom_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Enati thidi ku matanga ; buna maviokidi nzielo mu thalu ; Bu khotukidi, minu ndidi kaka yaku. ");
INSERT INTO yom_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Enati ngeyo wuzola kaka vonda mutu wumbimbi, a Nzambi ! Bika luthatukila beno luntengulanga menga ! ");
INSERT INTO yom_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Beti kuyolukila mu zikhanu zimbimbi ; bobo beti kulenda beti sadila dizina diaku mu kambu fuana. ");
INSERT INTO yom_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Buevi, ndilendi lenda ko bobo beti kulenda, a Yave ? A buevi, ndilendi kakumukina ko bobo beti kufuemi e ? ");
INSERT INTO yom_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Ndisi kadi diambu ko vayi kikhenene kaka ndidi kuidi bawu ; ndieti ba tanga bambeni ziama. ");
INSERT INTO yom_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Wumfiongunina, a Nzambi, ayi zaba ndimꞌama ; wuthota ayi zaba mayindu mama. ");
INSERT INTO yom_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Tala kani nzila yimbimbi yidi mu minu ayi wundiatisa mu nzila yi mvu ka mvu. ");
INSERT INTO yom_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Nkunga Davidi kuidi pfumu minyimbidi. Wukhudi, a Yave, mu mutu wumbimbi ; wukheba mu mutu wu makhemi ; ");
INSERT INTO yom_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","bobo banyindulanga zikhanu zimbimbi mu mintima miawu ayi bantombanga lumbu ka lumbu nuana mvita. ");
INSERT INTO yom_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Beti kitula ludimi luawu meno banga lu nioka ; mitsa mi bikusa midi mu bididi biawu. ");
INSERT INTO yom_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Wukheba, a Yave, mu mutu wumbimbi. Wuthanina mu batu badi makhemi ; bobo beti kubika zikhanu mu buisa malu mama. ");
INSERT INTO yom_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Batu ba luniemo bathambila makondi ; bayalumuna minsinga mi makondi mawu ayi bathambila mintambu muyenda nsolo ama. ");
INSERT INTO yom_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","A Yave, ndituba kuidi ngeyo : “ngeyo Nzambi ama.” Wa, a Yave, yamikina kuama bu ndintomba monono kiadi. ");
INSERT INTO yom_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","A Yave, mutu wumvanganga makazodidi ngeyo nkudi ama wu ngolo ngeyo weti kaka ntuꞌama mu lumbu ki mvita. ");
INSERT INTO yom_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Kadi tala zitsatu zi batu bambimbi zivangama, a Yave. Kadi tala ti zikhanu ziawu zinunga nganu bela ba luniemo. ");
INSERT INTO yom_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Bika mintu mi bobo banzungididi mifuku kuidi ziphasi ziozi bididi biawu bitotula. ");
INSERT INTO yom_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Bika makala ma mbazu mabua va bawu. Bika balozo ku mbazu, ku tsi mabulu madi nyamba ; babika buela telama. ");
INSERT INTO yom_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Bika mimvuezi mibika zingila mu tsi ; bika mabienga malandakana mu kambu vonga batu badi makhemi. ");
INSERT INTO yom_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Nzebi ti Yave weti vana luvovomo lusonga kuidi nsukami ayi wela nuanina minsukami. ");
INSERT INTO yom_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Bukiedika, basonga bela zitisa dizina diaku ayi batu badi mintima milulama bela zingila va ntualꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Nkunga Davidi. A Yave, ngeyo nditela ; yiza nsualu kuidi minu. Wa mbemboꞌama mu thangu ndilembo kutedi. ");
INSERT INTO yom_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Bika lusambulu luama luba va ntualꞌaku banga ansa bika mvumbudulu yi mioko miama yiba banga dikaba di masika. ");
INSERT INTO yom_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Tula nsungi va munu ama, a Yave ; keba bumboti muelo wu bididi biama. ");
INSERT INTO yom_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Kadi yinika ntimꞌama ku mambimbi, mu baka kuku mu mavanga mambimbi va kimosi ayi bamvanganga mambimbi ; kadi tala ti ndidia bidia biawu bidi lueki. ");
INSERT INTO yom_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Bika mutu wusonga kambeta, diodi didi dimboti ; bika kathemina, diodi didi mafuta va ntuꞌama ; ayi ntuꞌama wulendi manga mawu ko. Muaki lusambulu luama luela nuanisanga mu zithangu zioso mavanga ma batu bamvanganga mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Minyadi miawu miela lozo ku tsi tona ku yilu ngumbu ayi batu bambimbi bela longuka ti mambu mama ndituba, matubu bumboti. ");
INSERT INTO yom_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Bela tuba : “mutu bu keti kabila ntoto ayi vasila ntoto buawu bobo mimvesi mieto mididi misasakana va muelo tsi bafua”. ");
INSERT INTO yom_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Vayi meso mama madi kaka kuidi ngeyo Yave, mutu wumvanganga makazodidi Kuidi ngeyo ndintombila suamunu, kadi kundiekula mu lufua. ");
INSERT INTO yom_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Wukheba mu makondi bathambila ayi mu mintambu mitula batu bamvanganga mambimbi. ");
INSERT INTO yom_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Bika batu bambimbi, babua mu makondi mawu veka vayi minu ndiviokila vawu mu luvovomo. ");
INSERT INTO yom_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Nkunga Davidi kayimbidila banga lusambulu mu thangu kaba mu nsuku. Ndinyamikina ngolo kuidi Yave Ndimvumbula mbembo ama kuidi Yave mu diambu di kiadi. ");
INSERT INTO yom_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Ndilembo dukula luniongo luama va ntualꞌandi ; va ntualꞌandi, ndinyolukila ziphasi ziama. ");
INSERT INTO yom_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Mu thangu phevi ama yilembo suki-suki mu khati ama, keti ngeyo wuzaba nzilꞌama. Mu nsolo wowo ndidiatila, muawu batu bathambila ntambu. ");
INSERT INTO yom_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Tala ku lubakala luama ayi tala, kadi mutu widi mayindu mu minu. Ndisi kadi suamunu ko kuisi ko mutu wumbanzila luzingu luama. ");
INSERT INTO yom_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Kuidi ngeyo ndinyamikina, a Yave. Ndilembo tubi : “ngeyo suamunu kiama ; Ngeyo kuku kiama va ntoto wu batu badi moyo.” ");
INSERT INTO yom_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Dimba yamikina kuama bila ndidi nsukami wu ngolo, wukambulu diana ; wukhula mu bobo balembo ndandakana bila bawu bandutidi ngolo. ");
INSERT INTO yom_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Bika wuthotula nloko ama muingi ndizitisa dizina diaku ; buna basonga bela kuiza kutakana va ndidi mu diambu di mamboti maku kuidi minu. ");
INSERT INTO yom_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Nkunga Davidi. A Yave, wa lusambulu luama, dimba yamikina kuama mu diambu di kiadi mu kikhuikizi kiaku ayi mu busonga buaku, yiza wutsadisa. ");
INSERT INTO yom_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Kadi nata kisadi kiaku ku tsambusu ; bila kadi mutu wumosi widi moyo widi wusonga va ntualꞌaku. ");
INSERT INTO yom_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Bila mbeni wulembo ndandakana, wulembo ndiatidila va tsi ; niandi wukuphuandisanga mu bibuangu bidi tombi banga batu bobo bafua thama. ");
INSERT INTO yom_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Buna pheve ama yeka suka-suka mu khati ama ; ntimꞌama weka mona tsisi mu khati ama. ");
INSERT INTO yom_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Ndilembo tebukila moyo bilumbu bivioka. Ndinyindulanga mavanga maku moso ayi fiongunina mavanga ma mioko miaku. ");
INSERT INTO yom_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Ndinonuna mioko miama kuidi ngeyo. Muelꞌama widi phuila mu kumona banga ntoto wu yuma, bu wididi phuila nlangu. ");
INSERT INTO yom_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Wuphani mvutu mu nsualu, a Yave pheve ama yilembo yami. Kadi kutsuekila zizi kiaku bila ndieka dedakana banga bobo bankuendanga ku dibulu. ");
INSERT INTO yom_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Bika nsuka wundatina mambu ma luzolo luaku lu ngolo ; bila nditula diana diama mu ngeyo. Wumbonisa nzila yoyi mfueti kuendila bila kuidi ngeyo ndimvumbula muelꞌama. ");
INSERT INTO yom_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Wukhula mu bambeni ziama, a Yave ; bila ndikukisuekanga mu ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Wundonga mu vanga luzolo luaku bila ngeyo Nzambi ama. Bika pheve aku yimboti yindiatisa mu ntoto wulendumuka. ");
INSERT INTO yom_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Mu diambu di dizina diaku, a Yave, tamina luzingu luama ; mu busonga buaku, bika wuthotula mu ziphasi. ");
INSERT INTO yom_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Mu luzolo luaku lu ngolo, kanga bambeni ziama ; bunga babo bobo beti kundenda, bila ndidi kisadi kiaku. ");
INSERT INTO yom_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Nkunga Davidi. Bika, nzitusu wuba kuidi Yave, ditadi diama ; weti longa mioko miama mu nuana mvita ayi minlembo miama mu nuana khindu. ");
INSERT INTO yom_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Niandi Nzambi ama yi luzolo ayi tinunu kiama niandi suamunu kiama kingolo ayi niandi nkuidi ama, niandi nkaku ama ; mu niandi ndieti suamina ayi niandi wuntulanga batu ku tsi luyalu luama. ");
INSERT INTO yom_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","A Yave, buna mutu niandi nani muingi wumbelanga mayindu ; muana mutu muingi wunyindulanga e ? ");
INSERT INTO yom_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Mutu dedakani banga phemo ; bilumbu biandi bidi banga kitsusula kimvioka. ");
INSERT INTO yom_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Vasa diyilu diaku, a Yave, ayi kuluka ; simba miongo muingi mitotula muisi. ");
INSERT INTO yom_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Fidisa zitsiemo ku ntuala ayi sasikisa bambeni ziama. Loza madionga maku ayi wuba zimbikisa. ");
INSERT INTO yom_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Yalumuna koko kuaku bu widi ku yilu ; wuphukisa ayi wukhula mu minlangu mi nguma ayi mu mioko mi banzenza, ");
INSERT INTO yom_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","bobo miunu miwedi luvunu ; bobo mioko mi lubakala mibeki mayuya. ");
INSERT INTO yom_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Ndiela kuyimbidila nkunga wumona, a Nzambi. Mu siku ki kumi di minsinga, kioki beti tedila Lila, ndiela bula miziki, ");
INSERT INTO yom_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Kuidi mutu wowo wumvananga kuidi mintinu ndungunu, mutu wowo wunkulanga kisadi kiaku Davidi mu sabala kimvondanga. ");
INSERT INTO yom_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Wuphukisa ayi wukhula mu mioko mi banzenza ; bobo miunu miwedi luvunu bobo mioko mi lubakala mibeki mayuya. ");
INSERT INTO yom_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Buna bana beto babakala, mu bumuana buawu bela ba banga bikunusu binyundukanga bumboti. Bana beto babaketo bela ba banga makunzi mafikulu ; mammonisanga kitoko ki buangu. ");
INSERT INTO yom_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Bilundulu bieto biela ba biwala mu kadika ntindu wu bidia ; minkangu mieto mi mamemi miela buelama ayi buelama mu zimili zi zimili mu makumi ma zimili mu zitsola zieto. ");
INSERT INTO yom_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Zingombi zieto zikheto ziela nata mfuna wungolo, mavudu malendi ba ko mu bibaka bieto kadi buela kuenda mu kivika, yamikina ku ziphasi kulendi ba diaka ko mu zinzila zieto. ");
INSERT INTO yom_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Lusakumunu kuidi batu bobo mambu mama meti vangama. Lusakumunu kuidi batu bobo Yave kadidi Nzambi. ");
INSERT INTO yom_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Nkunga wu nzitusu wu Davidi. Ndiela kuyayisa Ntinu, Nzambi ama. Ndiela zitisa dizina diaku mu zithangu zioso ayi mu mvu ka mvu. ");
INSERT INTO yom_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Ndiela kuzitisa mu kadika lumbu ayi ndiela yayisa dizina diaku mu zithangu zioso ayi mu mvu ka mvu. ");
INSERT INTO yom_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Yave widi wunneni ayi niandi lutidi fuana mu zitusu ayi bunneni buandi bulendi fiongonono ko kuidi mutu. ");
INSERT INTO yom_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Tsungi yimosi yela niemisa bisalu biaku kuidi tsungi yinkaka ayi bela yolukila mavanga maku ma lulendo. ");
INSERT INTO yom_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Bela tubila kiezila ki nkembo wu nzitusu aku ; ayi minu ndiela yindulanga bisalu biaku bitsiminanga. ");
INSERT INTO yom_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Bela yolukila lulendo lu bisalu biaku bi tsisi ; ayi ndiela yamikisa mavanga maku manneni. ");
INSERT INTO yom_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Bela sanisina mamboti maku mawombo-wombo ayi bela yimbidila busonga buaku mu khini. ");
INSERT INTO yom_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Yave widi nkua nlemvo ayi wumonanga kiadi ; kavika fuemanga ko ayi fulukidi mu luzolo. ");
INSERT INTO yom_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Yave widi wumboti kuidi batu boso ; kiadi kiandi kidi kuidi batu boso kavanga. ");
INSERT INTO yom_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Bibioso bi wuvanga biela kuzitisa, a Yave ; banlongo baku bela kuyayisa. ");
INSERT INTO yom_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Bela yolukila nkembo wu kipfumu kiaku ayi bela tubila lulendo luaku, ");
INSERT INTO yom_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","mu diambu di batu boso bazaba mavanga maku ma lulendo ; kiezila ki nkembo ki kipfumu kiaku. ");
INSERT INTO yom_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Kipfumu kiaku kidi kipfumu mu thangu yi kayimani ayi luyalu luaku lunzingilanga mu zitsungi zioso. Yave widi wukuikama mu zitsila ziandi zioso ayi nkua luzolo kuidi batu boso kavanga. ");
INSERT INTO yom_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Yave wunsimbanga babo bobo beti bua ayi weti vumbula bobo badi bakomvama. ");
INSERT INTO yom_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Meso ma babo makutalanga ayi ngeyo weti bavana bidia mu thangu yifuana. ");
INSERT INTO yom_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Ngeyo wunzibulanga koko kuaku ayi wunyukutisanga zitsatu zi kadika kima kidi moyo. ");
INSERT INTO yom_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Yave widi wusonga mu zinzila ziandi zioso ayi widi nkua luzolo kuidi batu boso kavanga. ");
INSERT INTO yom_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Yave widi wufikama kuidi babo bobo bankutelanga, kuidi babo bobo bankutelanga mu kiedika. ");
INSERT INTO yom_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Niandi weti dedikisa zitsatu zi bobo beti ku kinzika ; weti wa yamikina kuawu ayi weti ku bavukisa. ");
INSERT INTO yom_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Yave weti sunga babo bobo beti kunzola vayi wela bunga batu boso bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Munuꞌama wela yolukila nzitusu wu Yave, bika kadika vangu kizitisa dizina diandi dinlongo mu zithangu zioso ayi nate mu mvu ka mvu. ");
INSERT INTO yom_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Luzitisa Yave ; Zitisa Yave, a muelꞌama. ");
INSERT INTO yom_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Ndiela zitisanga Yave mu luzingu luama loso ; ndiela yimbidilanga Nzambi ama minzitusu thangu yoso ndizingila. ");
INSERT INTO yom_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Kadi tula diana dieno mu bana ba mintinu, mu batu bobo beti fua, bobo balendi vukisa ko. ");
INSERT INTO yom_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Pheve awu yawu kuenda buna beti vutuka mu ntoto ; zikhanu ziawu zilalikini. ");
INSERT INTO yom_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Lusakumunu kuidi mutu wowo widi ti Nzambi yi Yakobi niandi nsadisi andi ; wuntulanga diana diandi mu Yave, Nzambi andi, ");
INSERT INTO yom_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","mvangi wu diyilu, ntoto, mbu ayi bibio bidi muna ; widi wukuikama mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Niandi weti vavila mambu ma bobo beti yamusu, ayi wumvananga bidia kuidi bobo badi nzala ; Yave niandi weti totula batu bobo badi mu nloko. ");
INSERT INTO yom_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Yave weti vana kiezila kuidi phofo, Yave weti vumbula bobo badi bakomvama. Yave weti zola batu basonga. ");
INSERT INTO yom_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Yave weti sunga nzenza, niandi wunkindisanga muana sana ayi difuola vayi weti kakumukina zinzila zi batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Yave wunyalanga mu zithangu zioso. Nzambi aku, a Sioni, mu zitsungi zioso. Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Luzitisa Yave ! A phila mboti yidi mu yimbila minzitusu kuidi Nzambi eto. A phila khini ayi fuana kuidi mu kunzitisa. ");
INSERT INTO yom_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Yave weti tunga Yelusalemi, weti kutikisa bana ba Iseli bayenda mu kivika. ");
INSERT INTO yom_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Niandi weti belusa mintima mi kosakana ayi wunkanganga ziphasima mu ziphuta ziawu. ");
INSERT INTO yom_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Niandi weti zenga thalu yi zimbuetete ayi weti kuzitedila kadika mbuetete mu dizina diandi. ");
INSERT INTO yom_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Pfumu eto widi wunneni ayi lulendo luandi luidi lunneni ; diela diandi disi kadi ndilu ko. ");
INSERT INTO yom_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Yave weti kindisa woso mutu weti kukikululanga ayi weti lumba batu bambimbi va tsi. ");
INSERT INTO yom_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Luyimbidila Yave mu kumvutudilanga matondo ; Lusikila Nzambi eto miziki mu ngitala. ");
INSERT INTO yom_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Niandi wufukidilanga diyilu mu matuti ; wunkubikanga mvula mu diambu di ntoto ayi niandi wummenisanga biti va mbata miongo mi fioti. ");
INSERT INTO yom_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Niandi wumvananga bidia kuidi bibulu bi fioti ayi kuidi bana ba ngonyi-ngonyi bu beti tela. ");
INSERT INTO yom_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Khini andi yisi ko mu zingolo zi phunda ayi yangalala kuandi kuisi ko mu malu ma mutu. ");
INSERT INTO yom_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Yave weti yangalala mu batu bobo beti kunkinzika, bobo bantulanga diana diawu mu luzolo luandi lungolo. ");
INSERT INTO yom_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Yayisa Yave, a Yelusalemi ; zitisa Nzambi aku, a Sioni ; ");
INSERT INTO yom_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","bila niandi wunkindisanga zitunga zi mielo miaku ; ayi weti sakumuna batu baku badi mu ngeyo. ");
INSERT INTO yom_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Niandi wuntulanga ndembama mu zindilu ziaku ayi wukuyukutisanga mu ble yilutidi kitoko. ");
INSERT INTO yom_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Niandi wumfidisanga zithumunu ziandi ku ntoto ; mambu mandi meti tembakana mu thinu nsualu. ");
INSERT INTO yom_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Niandi wumvananga mvula yi matadi banga mika mi dimemi ; ayi wuntembikisanga disala banga dibombi. ");
INSERT INTO yom_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Niandi wunlonzanga mvulꞌandi yi matadi banga matadi ma fioti Nani wulenda telama va ntuala phemo andi yi kiozi e ? ");
INSERT INTO yom_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Weti fidisa mambu mandi ayi weti kumasiutisa ; weti vemuna phemo yi ngolo andi ayi minlangu mieti kumba. ");
INSERT INTO yom_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Niandi wuzabikisa mambu mandi kuidi Yakobi ; mina miandi ayi zinzengolo ziandi kuidi Iseli. ");
INSERT INTO yom_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Kasia bu vangila kadi kuidi dikanda dinkaka ko basia zaba ko mina miandi. Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Luzitisa Yave ; luzitisa Yave tona mu diyilu. Lunzitisa mu bibuangu bizangama ngolo. ");
INSERT INTO yom_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Lunzitisa, beno zimbasi ziandi zioso ; lunzitisa beno minkangu miandi mioso mi masodi ma diyilu. ");
INSERT INTO yom_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Lunzitisa beno thangu ayi ngondi, lunzitisa beno zimbuetete zioso zidi kiezila. ");
INSERT INTO yom_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Lunzitisa ngeyo diyilu dizangama ngolo ayi beno minlangu midi ku mbata diyilu, ");
INSERT INTO yom_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","bika bizitisa dizina di Yave ; bila niandi wuvana lutumunu ayi biawu bivangama. ");
INSERT INTO yom_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Wubivuandisa va buangu mu zithangu zioso ayi mu thangu yi kayimani. Niandi wuvana nzengolo yayi, yikayilendi vioka ko. ");
INSERT INTO yom_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Luzitisa Yave tona va ntoto, beno bivangu binneni bi mbu ayi beno zithipula zioso zi mbu ; ");
INSERT INTO yom_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","mbazu ayi mvula yi matadi, mvula yi phembi ayi matuti ; vuka ki phemo kieti sadila zithumunu ziandi. ");
INSERT INTO yom_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Beno miongo ayi miongo mioso mi fioti ; minti mimbutanga makundi ayi minti mioso mi Sedeli ; ");
INSERT INTO yom_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","bibulu bi nsitu ayi bibulu bibioso bi fioti, bivangu bi fioti ayi zinuni zieti dumuka ; ");
INSERT INTO yom_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","mintinu mi ntoto ayi makanda moso ; beno bana ba mintinu ayi minyadi mioso mi ntoto ; ");
INSERT INTO yom_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","bamatoko ayi bandumba, binunu ayi bana balezi ");
INSERT INTO yom_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","bika bazitisa dizina di Yave bila dizina diandi diawu kaka difueni mu yayusu ; kiezila kiandi kidi va yilu ntoto ayi ku yilu diyilu. ");
INSERT INTO yom_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Niandi wutotudila batu bandi phoka, nzitusu wu banlongo bandi boso ; wu Iseli, batu bobo badi bakangama mu ntimꞌandi. Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Luzitisa Yave ; luyimbidila Yave nkunga wumona ; nzitusu andi mu lukutukunu lu banlongo. ");
INSERT INTO yom_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Bika Iseli kamona khini mu diambu di mvangi awu Bika batu ba Sioni bayangalala mu diambu di ntinu awu. ");
INSERT INTO yom_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Bika bazitisa dizina diandi mu makinu ; ayi bansikila miziki mu ndungu ayi mu ngitala, ");
INSERT INTO yom_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","bila Yave weti yangalala mu batu bandi, weti vuatisa phulusu kuidi batu beti kukikula. ");
INSERT INTO yom_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Bika banlongo bamoma khan mu diambu di nzitusu wawu ; ayi bayimbila mu khan mu zimbuka ziawu. ");
INSERT INTO yom_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Bika minzitusu mi Nzambi miba mu miunu miawu ayi sabala kidi meno mu zindambu zioso mu mioko miawu ; ");
INSERT INTO yom_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","mu diambu di vutula landi kuidi makanda ayi mu vana batu thumbudulu ; ");
INSERT INTO yom_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","mu diambu di kanga mintinu miawu mu zisieni ayi batu bawu banneni mu bisengo ; ");
INSERT INTO yom_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","mu diambu di dukisa nzengolo yoyi yisonama mu diambu diawu ; wawu wawu nkembo wu banlongo bandi boso. Luzitisa Yave. ");
INSERT INTO yom_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Luzitisa Yave, Luzitisa Nzambi mu buangu kiandi kinlongo. Lunzitisa mu diyilu diandi di lulendo. ");
INSERT INTO yom_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Lunzitisa mu diambu di mavanga mandi ma lulendo ; lunzitisa mu diambu di bunneni buandi bu kambulu ndilu. ");
INSERT INTO yom_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Lunzitisa mu biyoko bi ntotukila mu tulumbeta, Lunzitisa mu ngitala ayi mu Lila. ");
INSERT INTO yom_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Lunzitisa mu ndungu ayi mu makinu ; Lunzitisa mu bisiku bi minsinga ayi mu flute ; ");
INSERT INTO yom_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Lunzitisa mu bisiku bidi banga zitapa ; biobi bieti totula mbembo yingolo ; Lunzitisa mu bisiku bidi banga zitapa, biobi bilembo ningi. ");
INSERT INTO yom_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Bika bibioso bilembo vumuna bizitisa Yave. Luzitisa Yave.");
INSERT INTO yom_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tala buididi kikhulu ki Yesu Klisto, muana wu Davidi, muana wu Abalahami : ");
INSERT INTO yom_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalahami wubuta Isaki, Isaki wubuta Yakobi, Yakobi wubuta Yuda ayi bakhomba bandi. ");
INSERT INTO yom_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ayi nketo andi Tamali babuta Falesi ayi Zala ; Falesi wubuta Heseloni, Heseloni wubuta Alami. ");
INSERT INTO yom_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alami wubuta Aminadabi ; Aminadabi wubuta Nasoni ; Nasoni wubuta Salimoni. ");
INSERT INTO yom_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni ayi nketo andi Lahabi babuta Bowazi ; Bowazi ayi nketo andi Luti babuta Obedi ; ");
INSERT INTO yom_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Obedi wubuta Isayi ; Izayi wubuta ntinu Davidi ; ntinu Davidi wubuta Salomo mu nketo wuba wu Uli. ");
INSERT INTO yom_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomo wubuta Lobowami ; Lobohami wubuta Abia ; Abia wubuta Asa. ");
INSERT INTO yom_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa wubuta Zozafati ; Zozafati wubuta Zolami bosi Zolami wubuta Oziasi ; ");
INSERT INTO yom_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziasi wubuta Yotami ; Yotami wubuta Akazi ; bosi Akazi wubuta Ezekiasi. ");
INSERT INTO yom_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiasi wubuta Manase ; Manase wubuta Amoni bosi Amoni wubuta Zoziasi. ");
INSERT INTO yom_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zoziasi wubuta Yekonia ayi bakhomba bandi ; bawu babutuka bu banata bana ba Iseli mu buvika ku tsi Babiloni. ");
INSERT INTO yom_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Buvika bu bumana ku Babiloni, Yekonia wubuta Salatieli ; Salatieli wubuta Zolobabeli. ");
INSERT INTO yom_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zolobabeli wubuta Abuidi ; Abuidi wubuta Eliakimi ; Eliakimi wubuta Azoli. ");
INSERT INTO yom_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli wubuta Sadoki ; Sadoki wubuta Akimi ; Akimi wubuta Eliudi. ");
INSERT INTO yom_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi wubuta Eleyazali ; Eleyazali wubuta Matani ; Matani wubuta Yakobi. ");
INSERT INTO yom_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Bosi Yakobi wubuta Zozefi wuba bakala di Maliya, ngudi yi Yesu wuba tedila Klisto. ");
INSERT INTO yom_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Diawu zitsungi zioso tona Abalahami nate Davidi zidi kumi zitsungi ziya. Tona Davidi nate thangu bana ba Iseli bayenda mu buvika ku Babiloni ; vaba kumi zitsungi ziya ; bosi tona thangu buvika nate Klisto vaba kumi zitsungi ziya. ");
INSERT INTO yom_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tala phila yibutukila Yesu Klisto : Maliya ngudi andi ; niandi wuba nketo wuzolo kuelo kuidi Zozefi. Buna katudidi ko va nzo dikuela Maliya wubaka buemba vayi mu Pheve Yinlongo kabakila buemba beni. ");
INSERT INTO yom_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zozefi, bakala diodi dizola kuela Maliya, wuba mutu wusonga, wumanga kuandi kumfuisa tsoni va meso ma batu ; wubaka lukanu lu kumbotula mu kitsueki. ");
INSERT INTO yom_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bu kaba ku tsi mayindu mu diambu di mambu beni ; buna mbasi yi Pfumu yimmonikina mu ndozi, yinkamba : —A Zozefi, muana Davidi ! Bika mona boma mu kuela nketo aku Maliya bila buemba buidi yandi mu Pheve Yinlongo kabakidi buawu. ");
INSERT INTO yom_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wela buta muana wubakala, dizina wela kumbieka Yesu : bila niandi wela kula batu bandi mu masumu mawu. ");
INSERT INTO yom_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mambu moso mama mavangama mu diambu di dedikisa mambu makamba Pfumu kuidi mbikudi ti : ");
INSERT INTO yom_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Luwa, ndumba yikambu zaba bakala yela ba mu buemba, yela buta muana wubakala, dizina bela kuntedilanga Emanueli, bu dinsundula : “Nzambi widi yeto !” ");
INSERT INTO yom_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zozefi bu kakotuka, wuvanga mambu moso mbasi yi Pfumu kantuma ayi wubonga Maliya mu ba nketo andi. ");
INSERT INTO yom_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Vayi Zozefi kasia zaba nitu yi nketo andi Maliya ko nate kabuta muana wubakala, ayi wumvana dizina Yesu. ");
INSERT INTO yom_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu ku Betelemi kabutukila, divula didi mu tsi yi Yuda, mu thangu ntinu Elode. Yesu bu kabutuka, banduenga, batu beti longuka zimbuetete batotukila ku ndambu Esite, bayiza totuka ku Yeluzalemi, bayuvula : ");
INSERT INTO yom_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","—A kuevi kuidi Ntinu Bayuda, wowo butukidi e ? Bila tumueni mbueteteꞌandi thama ku ndambu Esite, diawu tuizidi muingi tumbuongimina. ");
INSERT INTO yom_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ntinu Elode bu kawa mambu momo, mayindu mandi mayama mu diambu di kiuvu kioki bayuvula, niandi ayi basi Yeluzalemi baba ku tsi mayindu. ");
INSERT INTO yom_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Elode wutumisa bapfumu boso ba banganga zi Nzambi ayi minlongi mi Mina, wuba yuvula kani kuevi Mesiya kela butukila. ");
INSERT INTO yom_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bamvutudila : —Wela butukila ku Betelemi didi mu tsi yi Yuda bila mbikudi wusonika : ");
INSERT INTO yom_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","A ngeyo Betelemi, divula didi mu tsi Yuda, Kadi sia ti ngeyo lutidi keva mu minyadi mioso mi Yuda, bila mu ngeyo muela totukila Pfumu ; niandi wela ba nsungi wu batu bama, Iseli. ");
INSERT INTO yom_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Buna Elode wutumisa mu kitsueki banduenga ayi wuba yuvula thangu mbi yitotuka mbuetete. ");
INSERT INTO yom_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bosi wuba tuma ku Betelemi, ayi wuba kamba : —Yendanu kuna ayi lutomba buzabila bumboti mambu madi mu muana beni. Beno kummona buna luiza khambi muingi mamvama ndienda mbuongimina. ");
INSERT INTO yom_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Buna bamana wa ntinu, bayenda kuawu. Buela zimbukila mbuetete yoyi batuama mona ku Esite yi buela bamonikina, yawu yiba tuaminina ku ntuala mu nzila nate yiyenda telama va yilu buangu kiba muana. ");
INSERT INTO yom_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Khini yiwombo yiba yawu buna bamona mbuetete. ");
INSERT INTO yom_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bakota muna nzo, bamona muana ayi ngudi andi Maliya, batumbu fukama vaba muana, beka ku mbuongimina. Bosi banianguna zitsaku zi banata, muba makaba ma bavana muana : nolo, ansa Ayi mile. ");
INSERT INTO yom_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nzambi bu kaba lubula mu ndozi ti babika vutukila kuidi Elode, mu nzila yinkaka bavutukila ku tsi awu. ");
INSERT INTO yom_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Buna bayenda, mbasi yimosi yi Pfumu yimonikina Zozefi mu ndozi, yinkamba : —Telama wubonga muana ayi ngudi andi, tinina ku Ezipiti. Vuanda kuna nate ndiela kukamba ti thangu yivutukila yifueni, bila Ntinu Elode wela tomba vonda muana ! ");
INSERT INTO yom_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Muna builu beni Zozefi wutelama, wubonga muana ayi ngudi andi, wuyenda tinina ku Ezipiti. ");
INSERT INTO yom_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wukala kuna nate Ntinu Elode kafua mu diambu di dedikisa mambu mayoluka Pfumu mu munu wu mbikudi, bu kabikula ti : Nditela muanꞌama katotuka ku Ezipiti ! ");
INSERT INTO yom_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Elode bu kazaba banduenga bamvuna, wufuema ngolo. Diawu katumina bavonda, ku Betelemi ayi mu mala mafikamini, bana boso bababakala badi mimvu miodi nate kuna tsi, landila thangu yiba nkamba kuidi batu beti longuka zimbuetete. ");
INSERT INTO yom_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mu nzila yoyo mambu mabikula mbikudi Yelemi madedakana : ");
INSERT INTO yom_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Mbembo yiwakana ku Lama bidilu ayi maniongo mawombo ; Lakheli wulembo didi bana bandi ; kakadi zola bombo bila bana beni basiedi ko. ");
INSERT INTO yom_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Elode bu kafua, mbasi yi Pfumu yimonikina Zozefi mu ndozi ku Ezipiti, ");
INSERT INTO yom_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ayi yinkamba : —Telama wubonga muana ayi ngudi andi, vutuka yawu ku Iseli, bila batu bobo babedi tombanga mu vonda muana bafuidi. ");
INSERT INTO yom_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Zozefi wutelama, wubonga muana ayi ngudi andi, wuvutuka ku Iseli. ");
INSERT INTO yom_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Vayi Zozefi, bu kawa ti Alikelawusi muana Elode, wuyadila Yuda va buangu ki dise diandi Elode, wumona tsisi mu buela vutuka kuna. Bosi mu ndozi yinkaka Nzambi wunlubula ti kenda mu zunga ki Ngalili. ");
INSERT INTO yom_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Buna wuvuanda mu divula diba tedolongo Nazaleti muingi mambu ma mimbikudi madedakana : bela kuntedilanga muisi Nazaleti. ");
INSERT INTO yom_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mu bilumbu bina, Yowani Mbotiki wuyiza ayi wutona longa mu dikanga didi mu tsi Yuda. ");
INSERT INTO yom_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wuba longanga : —Lubalula mavanga ! Bila kipfumu ki Diyilu kinefikimini. ");
INSERT INTO yom_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yowani, niandi bayolukila kuidi mbikudi Ezayi : Mbembo yi mutu wulembo yamikina mu dikanga : Lukubika nzila mu diambu di Pfumu ! Luludika minsolo miandi ! ");
INSERT INTO yom_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yowani wuba vuatanga minledi mivangulu mu mika mi kamela, bosi nsinga kaba kanganga mu luketo wuvangulu mu nkanda wu bulu ; bidia kaba ndianga makhoko ayi niosi. ");
INSERT INTO yom_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Batu batotukila ku Yelusalemi, mu Yuda dioso ayi mu yenda nlangu Yolidani baba nkuizanga kuidi Yowani. ");
INSERT INTO yom_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Atu beni bu baba tambudilanga masumu mawu, Yowani wuba kuba botikanga mu nlangu Yolidani. ");
INSERT INTO yom_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Vayi bu kamona Bafalisi ayi Basaduki bawombo baba nkuizanga ku botama, buna wuba kamba : —A bana ba bikusa ; a nani wululubudi mu tina nganzi yoyi yeka kuiza ? ");
INSERT INTO yom_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Monisanu mavanga mamboti mammonisa ti bukiedika lubaludi mavanga. ");
INSERT INTO yom_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Lubika banza bu lulembo yindula mu mintima mieno : “Beto tuidi mu nkuna wu Abalahami !” Bila bukiedika ndikulukamba ti Nzambi lenda totula bana ba Abalahami mu matadi mama. ");
INSERT INTO yom_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Lukeba : soka kikubimini mu kuanga mianzi mi minti. Woso nti wunkambu buta mimbutu mamboti, wela kuangu ayi wela viku ku mbazu. ");
INSERT INTO yom_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","—Minu mu nlangu ndilembo lubotikila mu diambu di monisa ti lulembo balula mavanga ; vayi mutu wowo wulembo yizi wundutidi mu lulendo ; ndisi fuana ko mu nata zisapatu ziandi. Niandi wela lubotikila mu Pheve Yinlongo ayi mu mbazu. ");
INSERT INTO yom_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ayi simbidi vevolo mu mioko miandi, niandi wela kombula buangu kioki kela vevila ; wela lunda ble ku yilu banga vayi wela yoka biti ku mbazu yi kayilendi zima ko. ");
INSERT INTO yom_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesu wubotuka ku Ngalili, mu kuenda ku ndambu nzadi Yolidani muingi bambotika kuidi Yowani. ");
INSERT INTO yom_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Vayi Yowani wuzola kunkakidila ayi wunkamba : —Minu mfueni botoko kuidi ngeyo vayi ngeyo kuidi minu wizidi ! ");
INSERT INTO yom_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu wumvutudila : —Buabu, bika bu bela bobo ! Bila bobo bufueti dedokosolo busonga boso. Mbadi Yowani wumbotika. ");
INSERT INTO yom_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu bu katumbu botoko, wutotuka mu nlangu. Mbadi Diyilu dizibuka mu diambu diandi ayi wumona Pheve yi Nzambi yikuluka va niandi banga dibembi. ");
INSERT INTO yom_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bosi mbembo yiba ku Diyilu yiwakana : —Niandi niawu muanꞌama wu luzolo, khini yiwombo kakumbonisanga ! ");
INSERT INTO yom_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ku nzimunina, Pheve Yinlongo yinata Yesu ku dikanga muingi Satana kantota. ");
INSERT INTO yom_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Bu kafua nzala, mu diambu di lusambulu mu tezo ki makumaya ma bilumbu, muini ayi builu ; buna wumona nzala. ");
INSERT INTO yom_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mbadi mvukumuni wuyiza va kaba ayi wunkamba : —Enati widi Muana Nzambi buna kamba matadi mama makituka mapha. ");
INSERT INTO yom_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Vayi Yesu wumvutudila : —Disonama ti : mutu kalendi zingilanga kaka mu dipha ko vayi mu mambu moso mantotukanga mu munu wu Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Buna Satana wunnata ku divula dinlongo, wuntula ku mbata muanzu wu Nzo Nzambi ; ");
INSERT INTO yom_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ayi wunkamba : “Enati bukiedika widi Muana Nzambi wukilozi ku ntoto, bila disonama : Nzambi wela fidisa zimbasi ziandi mu diambu diaku ayi ziela kunata mu mioko miawu mu diambu kulu kuaku kuedi bumina thutu mu ditadi !” ");
INSERT INTO yom_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu wumvutudila : —Disonama diaka ti : “Wulendi vukumuna Pfumu Nzambi aku ko !” ");
INSERT INTO yom_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satana wunnata diaka va mbata mongo wunda, kuna kammonisina bipfumu bioso bidi va nza ayi minkembo miawu. ");
INSERT INTO yom_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bosi wunkamba : —Tala, ngeyo kumfukimina kuandi ayi kumbuongimina ; ndieka kuvana bima bioso biabi ! ");
INSERT INTO yom_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu wunkamba : —Botuka, Satana ! Bila disonama ti : “Pfumu Nzambi aku niandi fueti buongimina ayi niandi kaka fueti sadila !” ");
INSERT INTO yom_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Buna satana wumbika. Bosi zimbasi ziyiza va kaba ayi zinsadila. ");
INSERT INTO yom_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu bu kawa ti bakotisa Yowani mu nloko ; buna wuvutuka ku Ngalili. ");
INSERT INTO yom_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wubotuka ku Ngalili. Wuyenda vuanda ku Kafalinawumi, divula didi mu ndambu mbu ; mu tsi yi Zabuloni ayi Nefatali ");
INSERT INTO yom_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","muingi mambu ma mbikudi Ezayi madedakana : ");
INSERT INTO yom_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Tsi yi Zabuloni ayi yi Nefatali, tsi yidi mu ndambu mbu ku disimu di Yolidani ayi ku Ngalili tsi yi makanda ma Bapakanu. ");
INSERT INTO yom_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Batu baba nzingilanga mu tombi bamona kiezila kingolo ; kiezila kitotukila batu bobo baba nkalanga mu tsi yiba diengidilanga kitsuisula ki lufua. ");
INSERT INTO yom_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tona thangu yina, Yesu wutona longa bu katuba : —Lubalula mavanga bila Kipfumu ki diyilu kifikimini ! ");
INSERT INTO yom_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu bu kaba kuenda yendanga muna muyenda mbu wu Ngalili, wumona bakhomba buadi ; Simoni diodi baba ntedilanga Piela ayi khombꞌandi Andela balembo lozi dikondi mu mbu bila baba banlobi mbizi. ");
INSERT INTO yom_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Buna wuba kamba : —Ndandakananu ayi ndiela kulukitula minlobi mi batu. ");
INSERT INTO yom_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Muna thangu beni kaka, basia bika makondi mawu ayi banlandakana. ");
INSERT INTO yom_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Buela kuesa fioti, wumona diaka bakhomba buadi : Zaki muana Zebede ayi khombꞌandi Yowani, balembo londi makondi mawu mu khati nlungu va kimosi ayi dise diawu Zebede. Mamvawu wuba tela. ");
INSERT INTO yom_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Muna yawu thangu mamvawu babika nlungu awu ayi dise diawu, banlandakana. ");
INSERT INTO yom_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu wudiata mu Ngalili dioso ayi wuba longanga mu zinzo ziawu zi lukutukunu, wuba longanga Nsamu Wumboti wu Kipfumu. Wubelusa ziphila zioso zi bimbevo ayi ziphasi zioso zi phila mu phila mu batu. ");
INSERT INTO yom_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Zitsangu ziandi zimana tembakana mu tsi yoso yi Sili ayi bannatina batu boso baba bimbevo ; bobo bamona ziphasi zi phila mu phila ; ayi yamusu ku phila mu phila, bobo baba ziphevi zimbimbi, bobo baba kimbevo kisisuka ayi bobo baba kimbevo kivonga mianzi. Yesu wumana babelusa. ");
INSERT INTO yom_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nkangu wu batu bawombo baba kuenda nlandakananga : baba mu Ngalili, baba mu Dekapoli, baba mu Yelusalemi, baba mu Yuda dioso ayi baba ku disimu di Yolidani. ");
INSERT INTO yom_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu bu kamona nkangu wu batu wukuma va mbata mongo, wuvuanda. Minlonguki miandi mikutakana va kaba. ");
INSERT INTO yom_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Bosi wutona kuba longa. Wutuba : ");
INSERT INTO yom_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Khini kuidi minsukami mu Pheve, bila bawu bavuidi Kipfumu ki Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Khini kuidi bawu bandila bila bela bombo. ");
INSERT INTO yom_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Khini kuidi bawu badi mintima milembama, bila bawu bela vinginina ntoto. ");
INSERT INTO yom_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Khini kuidi bawu beta monanga tsatu ayi phuila yi mambu masonga, bila bela yukutusu. ");
INSERT INTO yom_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Khini kuidi bawu badi mintima mi kiadi, bila bela kuba mona kiadi. ");
INSERT INTO yom_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Khini kuidi bawu badi mintima mivedila, bila bela mona Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Khini kuidi bawu beti tula ndembama, bila bela tedolo bana ba Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Khini kuidi bawu beta yamusu mu diambu di busonga, bila bawu bavuidi Kipfumu ki Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Khini kuidi beno enati bakulufinganga, enati bakulu yamisanga ayi enati bakuluvuninanga mambu mambimbi ma phila mu phila mu diambu diama. ");
INSERT INTO yom_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lumona kueno khini, lusakadala bila mfutu wunneni wukuluvingila ku Diyilu. Luzaba mboti ti mimbikudi mi lutuamina mamvawu bobo bayamusulu. ");
INSERT INTO yom_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Beno luidi tsalu yi ntoto. Enati tsalu yizimbisidi lueki luandi, mu mbi balenda diaka vutudila lueki beni ? Kadi mfunu yisiedi ko, bafueti kuyiloza ku nganda ayi batu bafueti yidiata. ");
INSERT INTO yom_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Beno luidi muinda wu nza, divula diodi didi va yilu mongo, dilendi suama ko. ");
INSERT INTO yom_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Enati balemisini muinda, bawu tulanga ku tsi katini ko, vayi va yilu meza muingi wumonisa kiezila kuidi batu boso badi mu nzo. ");
INSERT INTO yom_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Diawu bika kiezila kieno kilezimina bobo vadi batu muingi bamona mavanga meno mamboti ayi muingi bakembisa Dise dieno didi ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—Lubika yindula ti ndiyiza mu diambu di vonda Mina voti mu diambu di vonda malongi ma mimbikudi. Ndisia kuiza ku vonda ko vayi ndiyiza mu diambu di dukisa miawu. ");
INSERT INTO yom_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Bila bukiedika ndikulukamba : sumbu Diyilu ayi ntoto bikidi zingi buna kadi kima kimosi kilendi botolo ko mu Mina ; ka diambu ko sono kimosi kifioti. Vayi nate mamoso mela vangama. ");
INSERT INTO yom_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Diawu woso mutu weta bundula muina wawu wumosi wufioti ayi wela longa batu bavanga buawu, wela monika mutu wukhioki mu Kipfumu ki Diyilu. Vayi woso mutu wunlonganga Mina mi Nzambi ayi weta misadila, wela monika mutu wunneni mu Kipfumu ki Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bila ndikulukamba enati busonga bueno bukadi viatuka bobo bu Bafalisi ayi bu Minsoniki mi Mina, buna lulendi kota ko mu Kipfumu ki Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Luwa ti bakamba kuidi bakulu beto ti : kadi vonda mutu bila woso wela vonda mutu wela samba va ntuala mazuzi. ");
INSERT INTO yom_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Vayi minu ndikulukamba : woso mutu wumfuemina ndiandi wela samba va ntuala mazuzi. Woso mutu wumfinga ndiandi ti : “vungisi”, wela samba na ntuala lukutukunu lu bapfumu banganga Nzambi, ayi woso mutu wunfinga ndiandi ti widi “dilawu” mboti mu kunloza ku mbazu yi bulungi. ");
INSERT INTO yom_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Enati telimini ku kuma mu vana makaba, ayi tebukidi moyo ti diambu khombꞌaku kabeki, ");
INSERT INTO yom_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bika makaba maku vana ntuala, kuma, yenda teka dedikisa ayi khombꞌaku bosi yiza vani makaba maku kuidi Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Enati mutu wubeki mambu vika wizana ayi niandi bu lukidi mu nzila bila niandi kufunda kuidi zuzi, zuzi maka tuma masodi muingi matula mu nloko. ");
INSERT INTO yom_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Bukiedika ndikukamba ti mawu kala kaka muna nloko nate wumana futa zimbongo zioso. ");
INSERT INTO yom_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Luwa ti ditubu : kadi vanga kitsuza. ");
INSERT INTO yom_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Vayi minu ndikulukamba ti woso wuntala nketo mu kunzinina, buna vengi yandi kitsuza mu ntimꞌandi. ");
INSERT INTO yom_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Diawu enati dieso diaku, di lubakala Dilembo kuvodisa masumu, mboti mu kudidovula ayi ku diloza thama. Bila bulutidi mboti kuidi ngeyo mu kambu nama kimosi ki nituꞌaku ayi mu tala nitu aku yimvimba yilozama ku bulungi. ");
INSERT INTO yom_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bosi enati koko kuaku, ku lubakala, kulembo kuvodisa masumu, mboti wukuzenga ayi wukuloza thama, bila bulutidi mboti kuidi ngeyo mu kambu nama kimosi ki nituꞌaku ayi mu tala nitu aku yimvimba yilozama ku bulungi. ");
INSERT INTO yom_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Bakamba diaka : “Woso mutu botudi nketo andi buna bufueni kamvana nkanda wu kimbangi wumonisa ti vondidi dikuela.” ");
INSERT INTO yom_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Vayi minu ndikulukamba : woso bakala wumvambana ayi nketo andi, bika sia ti mu diambu di kitsuza, buna niandi wunyekudi mu vanga kitsuza. Ayi woso wunkuela nketo wowo mamvandi vengi kitsuza. ");
INSERT INTO yom_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Luwa diaka ti bakamba kuidi bakulu beto : “kadi vonda ndefi wuleva, vayi dukisa ndefi wuvana Pfumu.” ");
INSERT INTO yom_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Minu ndikulukamba lubika kueno levanga ndefi. Kadi levilanga ndefi mu “dizina di Diyilu” bila Diyilu diawu kundu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Lubika levilanga ndefi mu dizina di ntoto bila va ntoto vawu Nzambi keti tetika malu mandi. Lubika levilanga ndefi mu dizina di Yelusalemi bila diawu divula di Ntinu wunneni. ");
INSERT INTO yom_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kadi levilanga ndefi va “ntuꞌaku” bila kulendi kitula lusuki lumosi phembi ko voti ndombi ko. ");
INSERT INTO yom_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bika lutubanga kaka “Nyinga” bu lufueti tuba nyinga ayi “nana” bu lufueti tuba nana. Bila mambu moso meti buelama va yilu kuidi Satana meti ba. ");
INSERT INTO yom_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—Luwa bu bakamba : “Enati mutu tobudi dieso di ndiandi, niandi mamvandi bafueti tobula dieso diandi ; enati mutu kodidi dieno di ndiandi, niandi mamvandi bafueti kola diano diandi.” ");
INSERT INTO yom_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Vayi minu ndikulukamba : —Lubika kakidila mutu tidi kuvangila mambimbi ! Enati bazubidi mbata mu luvenga lumosi, wuntambika diaka luvenga lunkaka. ");
INSERT INTO yom_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Enati mutu tidi kufunda ayi ziona kikhutu kiaku, buna wunyekudila ayi yunga kiaku. ");
INSERT INTO yom_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Enati mutu wukuikidi wudiata yandi mu tezo ki kilometele kimosi, ngeyo buela diati yandi mu tezo ki bikilometele biodi. ");
INSERT INTO yom_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Vana kuidi mutu wowo wukulomba ayi kadi yimina mutu wowo wunzola deva kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Luwa ti bakamba : “zolanga ndiaku ayi lendanga mbeni aku” ");
INSERT INTO yom_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Vayi minu ndikulukamba : Luzola bambeni beno ! Lusambidila bobo bakuluyamisanga ! ");
INSERT INTO yom_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Buawu bobo luela bela bana bakiedika ba Dise dieno didi ku Diyilu. Bila niandi weta kienzudila thangu andi kuidi batu bambimbi ayi batu bamboti ; weta nokisa mvula kuidi batu basonga ayi kuidi bobo bakambulu basonga. ");
INSERT INTO yom_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Enati lueta zola bobawu beta kuluzola, buna mbi mfutu lumbaka ? Bila mimfutisi mi ziphaku mamvawu beta bu vanga. ");
INSERT INTO yom_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Enati lueta vana kaka mboti kuidi bakhomba zieno, buna diambu mbi diviatukidi lumvanga e ? Keti Bapakanu mamvawu beti bu vanga. ");
INSERT INTO yom_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Vayi beno bufueni luba batu bafuana banga buididi Dise dieno widi ku Diyilu widi wufuana. ");
INSERT INTO yom_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Lukeba, lubika vangilanga mavanga meno masonga va meso ma batu muingi balumona. Tala luedi kambu nsendo wu Dise dieno widi ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Thangu wumvana lusadusu kuidi mutu wusukama, kadi sika tulumbeta ku ntualꞌaku banga bueta vangila batu badi mayuya, mu zinzo zi zikhutukunu ayi mu zinzila muingi batu baba niemisa. Bukiedika ndikulukamba ti bakitambudidi nsendo awu. ");
INSERT INTO yom_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Vayi ngeyo bu wumvana lusadusu kuidi mutu wusukama, bika koko kuaku ku lumoso kubika zaba mavengi koko kuaku ku lubakala, ");
INSERT INTO yom_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","muingi dikaba diaku divanunu mu kitsueki ayi muingi Dise diaku dieti mona mamo mamvangiminanga mu kitsueki wela kufuta. ");
INSERT INTO yom_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mu thangu lunsambila lubika ba banga batu bobo badi mayuya, beti sambidila kimathelama, mu ziphambu zi zinzila ayi mu zinzo zi zikhutukunu muingi batu babamona. Bukiedika, ndikulukamba bakitambudidi mfutu awu. ");
INSERT INTO yom_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Vayi ngeyo bu tidi sambila, kota mu vinga kiaku ; zibika muelo, sambila Dise diaku dimvuandanga mu kitsueki. Buna Dise diaku dieti mona mamo mamvangiminanga mu kitsueki wela kufuta. ");
INSERT INTO yom_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mu thangu lunsambila, lubika vutukilanga mambu banga bueta vanga Bapakanu, bila bawu beti muena ti zitsambulu zieti tambudulu bu beti nonumunanga mambu. ");
INSERT INTO yom_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Lubika basokudila. Bila Dise dieno zebi mbi luvuidi mfunu, beno mu kambu teka kunlomba. ");
INSERT INTO yom_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tala phila lufueti sambidilanga : Tatꞌeto widi ku Diyilu, bika dizina diaku diba dinlongo ");
INSERT INTO yom_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bika Kipfumu kiaku kiza. Bika luzolo luaku luvangama va ntoto, banga bu lueti vangimina ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Wutuvana buabu bidia bieto bi kadika lumbu. ");
INSERT INTO yom_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wutulemvukila mambimbi meto ; banga beto bu tunlemvukilanga batu bobo batuvangila mambimbi. ");
INSERT INTO yom_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kadi kutu bika tubua mu phukumunu, vayi wutukula mu mvukumuni, Bila ngeyo vuidi kipfumu, lulendo ayi nkembo mu mimvu mi kamimani. ");
INSERT INTO yom_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Enati lulemvukila batu mu mambimbi mawu buna Dise dieno didi ku Diyilu wela kululemvukila. ");
INSERT INTO yom_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Vayi enati lumengi lemvukila batu buna Dise dieno kalendi kululemvukila ko. ");
INSERT INTO yom_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Mu thangu lukukifuisa nzala mu diambu di lusambulu, lubika monika kiadi-kiadi banga bueti vangila batu badi mayuya. Beti kitula bizizi kiadi-kiadi muingi batu boso bazaba ti bawu balembo kifuisi nzala mu diambu di lusambulu. Bukiedika ndilulukamba bakitambudidi mfutu awu. ");
INSERT INTO yom_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Vayi bu wulembo kukifuisi nzala mu diambu di lusambulu bika wusukula bumboti zizi kiaku ayi dukula mafuta ku ntu aku, ");
INSERT INTO yom_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","muingi mutu kabika zaba ti wulembo wukifuisi nzala mu diambu di lusambulu vayi Dise diaku kaka dimvuandanga mu kitsueki niandi kaka fueti zaba. Buna Dise diaku dieti mona mambu mamvangimina mu kitsueki wela kufuta. ");
INSERT INTO yom_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Lubika yidika kimvuama va ntoto bila zitselele ayi khazu-khazu bilenda kibivisa ayi mivi milenda tobula zinzo ayi yiba. ");
INSERT INTO yom_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Vayi yidikanu kimvuama beni ku Diyilu, kuna kukambulu zitselele ayi khazu-khazu yilendi bivisa ko ayi mivi milendi tobula ayi yiba ko. ");
INSERT INTO yom_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bila koso kuidi kimvuama kiaku, kuna kuela ba ntimꞌaku. ");
INSERT INTO yom_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Dieso didi muinda wu nitu, enati dieso diaku didi dimboti, buna nituꞌaku yoso yidi yikienzuka. ");
INSERT INTO yom_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Vayi enati dieso diaku didi dimbimbi buna nituꞌaku yoso mayiba mu tombi. Enati kiezila kidi mu ngeyo kidi tombi, buna tombi beni kiela ba kinkobo ! ");
INSERT INTO yom_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Kuisi ko mutu wulenda sadila bapfumu buadi mu khumbu yimosi bila wela lenda wumosi ayi zola wunkaka ; voti wela singimina mu wumosi ayi wela lenda wunkaka. Lulendi sadila ko Nzambi ayi zimbongo. ");
INSERT INTO yom_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Diawu ndikulukambila ti lubika bela luzingu lueno mayindu mu diambu di zaba mbi luela dia ayi mbi luela nua. Mbi luela vuata. Luzingu luisi vioka bidia mu mfunu ko e ? Ayi nitu yisi vioka minledi mu pfumu ko e ? ");
INSERT INTO yom_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Talanu zinuni zi diyilu, zikunanga ko ; zivelanga mimbutu ko ayi zilundanga bidia mu bilundulu ko. Ayi Dise dieno widi ku Diyilu weti zidikila. Beno lusi zivioka ko mfunu e ? ");
INSERT INTO yom_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nani buna luidi lenda yika luzingu luandi, ka diambu ko mu thangu yimosi, kuna ku mayindu e ? ");
INSERT INTO yom_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","A buna bila mbi lueti belanga mayindu mu diambu di minledi e ? Bika lutala buevi bueti kudila biteka mu zitsola. Bisalanga ko ayi bitunganga ko. ");
INSERT INTO yom_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Vayi ndikulukamba, banza nkutu ntinu Salomo mu nkembo andi woso kasia vuatila ko banga buvuatila kiteka kimosi mu biteka bina. ");
INSERT INTO yom_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Buna enati Nzambi weti vuatisa bobo biti biobi bidi buabu mu zitsola vayi biela lozo mbazi ku mbazu, buna kalendi kuluvuatisa vioka biti beni ko e ? Batu ba minu kikhioki ! ");
INSERT INTO yom_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Diawu lubika banga mayindu, mu tubanga : “kani mbi matudia”, voti “mbi matuvuata”. ");
INSERT INTO yom_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bila bapakanu bawu bantombanga bima bioso biobi. Vayi Dise dieno di Diyilu zebi ti mfunu luvuidi biawu. ");
INSERT INTO yom_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Vayi lutomba theti Kipfumu ki Nzambi ayi busonga buandi, buna bela kulubuedila bima bioso biobi. ");
INSERT INTO yom_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Lubika ba mayindu mu diambu di mbazi, bila mbazi wela ba mayindu mu diambu diandi veka ayi kadika lumbu kidi ayi ziphasi ziandi. ");
INSERT INTO yom_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Lubika sambisa, tala mamveno luedi sambusu. ");
INSERT INTO yom_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bila bela kulusambisa banga phila lunsambisila ayi bela ku lutezila luelo luela dedakana banga lolo lutezila bankaka. ");
INSERT INTO yom_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Vayi bila mbi wumonina kiti kidi mu dieso di khombꞌaku, vayi ngeyo veka wukadi mona tunga yidi mu dieso diaku e ? ");
INSERT INTO yom_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Voti buevi wulenda kambila khombꞌaku : “Bika ndibotula kiti kidi mu dieso diaku ! Vayi tunga yidi mu dieso diaku.” ");
INSERT INTO yom_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mutu wu mayuya ! Botula theti tunga yoyi yidi mu dieso diaku buna bosi mawumona mboti mu botula kiti kidi mu dieso di khombꞌaku. ");
INSERT INTO yom_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Lubika vana bima binlongo kuidi zimbua. Lubika loza bilunga bieno bithalu vadi zingulu, bila mazi bidiatila ayi mazi lubalukila muingi ziluvanga phasi. ");
INSERT INTO yom_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Lulomba ayi bela kuluvana. Lutomba ayi luela mona ; lukokuta ayi luela zibudulu. ");
INSERT INTO yom_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bila woso wunlombanga niandi wuntambulanga. Woso wuntombanga niandi wumonanga woso wunkokutanga niandi wunzibudulungu. ");
INSERT INTO yom_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nani mu beno lenda vana ditadi kuidi muanꞌandi bu kanlombidi dipha ? ");
INSERT INTO yom_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Voti bu kanlombidi mbizi buna nioka maka mvana e ? ");
INSERT INTO yom_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Enati beno batu bambimbi, luzebi vana bima bimboti kuidi bana beno, buna Dise dieno di Diyilu diela luta vana bima bimboti kuidi bobo bakunlombanga. ");
INSERT INTO yom_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Mambu moso momo lutidi ti batu baluvangila mawu mamveno lufueti kuba vangila. Bila mawu mama malongi ma Mina ayi ma mimbikudi. ");
INSERT INTO yom_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Lukotila va muelo wufuetama bila muelo widi wuyalumuka ayi nzila yinatanga ku nzimbala yidi yinneni, ayi, batu bawombo beti kotilanga muawu. ");
INSERT INTO yom_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Vayi muelo widi wufietama, nzila yi luzingu yidi yifioti ayi batu bafioti kuandi beti kuyibakulanga. ");
INSERT INTO yom_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Lulubukila mimbikudi mi luvunu miomi minkuizanga kuidi beno banga mamemi vayi mu kiedika badi memvu ma nganzi. ");
INSERT INTO yom_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Luela kuba zabila mu mimbutu miawu. A buevi balenda vela makundi ma vinu mu nti widi zitsendi voti makundi ma figi mu nti wu zitsolokoto e ? ");
INSERT INTO yom_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Diawu woso nti wumboti wumbutanga mimbutu mimboti vayi nti wumbimbi wumbutanga mimbutu mimbimbi. ");
INSERT INTO yom_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nti wumboti wulendi buta ko mimbutu mambimbi ayi nti wumbimbi, wulendi buka ko mimbutu mamboti. ");
INSERT INTO yom_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Woso nti wunkambu buta mimbutu mimboti wufueti vuzu ayi lozo ku mbazu. ");
INSERT INTO yom_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mu mimbutu miawu kaka luela kuba zabila. ");
INSERT INTO yom_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Bika sia ti batu bobo beta kukhamba : “Pfumu ! Pfumu !” ti bawu bela kota mu kipfumu ki Diyilu, vayi bobo bamvanganga luzolo lu Dise diama didi ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mu lumbu kina batu bawombo bela kukhamba : “A Pfumu ! A Pfumu ! A keti mu dizina diaku tubikudila ! A keti mu dizina diaku tukukila ziphevi zimbimbi. A keti mu dizina diaku tuvangila bikumu biwombo !” ");
INSERT INTO yom_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Buna minu ndiela kuba vutudila : “ndisi ku luzaba ko. Botukanu vava beno lumvanganga mambu mambimbi !” ");
INSERT INTO yom_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Diawu woso wulembo wa mambu ma ndilembo tubi ayi wunsadila mawu widi banga mutu wu diela wutunga nzoꞌandi va yilu ditadi. ");
INSERT INTO yom_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mvula yingolo yinoka, minlangu miwala ayi bivuka biyiza lumbama mu nzo beni vayi nzo beni yisia bua ko bila yitungulu va yilu ditadi. ");
INSERT INTO yom_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Vayi woso mutu wulembo wa mambu mama vayi kakadi ku masadila widi banga mutu wu buvungisi wutunga nzoꞌandi va mbata nzielo. ");
INSERT INTO yom_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mvula yingolo yinoka, minlangu miwala ayi bivuka biyiza lumbama mu nzo beni. Nzo beni yitumbu bua ayi yitumbu tiolumuka. ");
INSERT INTO yom_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu bu kamana tuba, nkangu wu batu wusimina mu diambu di malongi mandi. ");
INSERT INTO yom_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bila kaba kuba longilanga ko banga minsoniki miawu, vayi niandi wuba longila mu lulendo loso. ");
INSERT INTO yom_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu bu kakulumuka mongo ; nkangu wunneni wunlandakana. ");
INSERT INTO yom_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Buna mutu wumosi wuba kimbevo kibuazi wuyiza kuidi Yesu, wufukama va ntualꞌandi ayi wutuba : —A Pfumu, enati tidi, wulenda kuaku kumbelusa ! ");
INSERT INTO yom_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu wunonuna koko kuandi, wunsimba ayi wunkamba : —Nyinga thidi, beluka kuaku. Mu yina thangu wubeluka mu buazi buandi. ");
INSERT INTO yom_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bosi Yesu wunkamba : —Vayi keba, kadi kamba kadi kuidi mutu wumosi mambu mama vayi yenda kimonisa kuidi nganga Nzambi ayi nata dikaba dilomba Moyize mu diambu diba kimbangi kuidi bawu. ");
INSERT INTO yom_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu bu katula ku Kafalinawumi, pfumu yimosi yi masodi wuyiza kuidi niandi. Wunleba ayi wutuba : ");
INSERT INTO yom_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Pfumu, kisadi kiama kilekidi ku nzo, kimbevo ki binama kidi yandi ayi ziphasi ziwombo kalembo moni. ");
INSERT INTO yom_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu wumvutudila : —Nyinga, ndiela kuiza ayi ndiela kumbelusa. ");
INSERT INTO yom_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Vayi Pfumu yi masodi wutuba : —A Pfumu ! Minu ndisi wufuana ko muingi ngeyo wukota mu nzo ama vayi tuba kaka diambu dimosi buna kisadi kiama kiela beluka. ");
INSERT INTO yom_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bila nzebi diawu, minu mamvama ndidi ku tsi luyalu lu bapfumu ayi ndieti tumina bankaka. Minu kamba kuidi wumosi : “Yenda” makenda ayi minu kamba wunkaka : “yiza” makiza ayi kuidi kisadi kiama : “vanga buabu”, maka vanga buawu. ");
INSERT INTO yom_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu wusimina buwombo bu kawa mambu mandi. Wukamba batu bobo baba kunlandakananga : —Bukiedika ndikulukamba ndimueni ko minu kinneni mu Iseli dioso. ");
INSERT INTO yom_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ndikulukamba ti batu bawombo bela ba ku Esite ayi ku Wesite bela vuanda mu kipfumu ki diyilu mu kipfumu ki diyilu va kimosi ayi Abalahami, Isaki ayi Yakobi. ");
INSERT INTO yom_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Vayi bobo bakubukulu kipfumu bela lozo ku nganda kuidi tombi, kuna kuela ba bidilu ayi nkuetoso wu meno. ");
INSERT INTO yom_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bosi Yesu wukamba kuidi pfumu yi masodi : —Vutuka kuaku bika buvangimina boso bu wilukidingi ! Buna kisadi kiandi kibeluka kuandi muna thangu yina. ");
INSERT INTO yom_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Thangu Yesu katula ku nzo Piela, wuyenda bata nzitu Piela wuba wuleka va mbuka bila zinzangala zingolo ziba yandi. ");
INSERT INTO yom_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu bu kansimba mu koko, zinzangala zimana. Bosi wutelama mu kunkubikila bidia. ");
INSERT INTO yom_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mu masika mana, banatina Yesu batu bawombo bobo baba ayi ziphevi zimbimbi. Mu mambu mandi katuba muawu kakukila ziphevi beni zimbimbi. Ayi wubelusa batu boso bobo baba bimbevo. ");
INSERT INTO yom_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Buawu bobo mambu mambikudi Ezayi madedikinina : Wubonga ziphasi zieto ayi wunata bimbevo bieto. ");
INSERT INTO yom_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu bu kamona nkangu wu batu wunzungidila, wutuma minlonguki miandi mu sabuka ku disimu dinkaka di mbu. ");
INSERT INTO yom_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nlongi wumosi wu Mina wufikama ayi wunkamba : —A nlongi, thidi kulandakana koso ku wunkuenda. ");
INSERT INTO yom_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Vayi Yesu wumvutudila : —Mimbaku midi ayi minsuku miawu miomi mieti leka, zinuni zidi ayi zindiala ziawu, vayi Muana Mutu kasi ko buangu kikalenda vundisila ntu. ");
INSERT INTO yom_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wumosi mu minlonguki miandi wunkanba : —A Pfumu ! Wundemvukila, vingila theti ndienda ziki dise diama. ");
INSERT INTO yom_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Vayi Yesu wumvutudila : —Wundandakana ; bika bafua bazika batu bawu bafua ! ");
INSERT INTO yom_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Buna wukuma mu nlungu ayi minlonguki miandi minlandakana. ");
INSERT INTO yom_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Zimbukila vuka kimosi kingolo kitona mu mbu, mayo mavioka nlungu mu ntela vayi Yesu wuba wuleka. ");
INSERT INTO yom_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Minlonguki mifikama va kaba, minkotula mu yamikina : —Pfumu ! Wutuvukisa, tueka mfua ! ");
INSERT INTO yom_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu wuba vutudila : —Bila mbi lulembo monina boma e ? Batu ba minu kikhioki ! Yesu wutelama, wutemina vuka ayi mbu ; buna ndembama yivutuka. ");
INSERT INTO yom_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Batu basimina ayi batuba : —A buna nani niawu muingi bivuka ayi mbu bintumukina e ? ");
INSERT INTO yom_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mu thangu batula ku disimu di mbu, mu zunga ki basi Ngelasa, batu buadi baba ziphevi zimbimbi batotuka mu biziami bayiza kundengana. Zinganzi ziwombo ziba yawu ; diawu kadi mutu wumosi kasia nunga ko mu viokila vana. ");
INSERT INTO yom_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bayamikina : —Diambu mbi tidi kutuvanga ngeyo Muana Nzambi e ? Wizidi mu kutuyamisa tuamina thanguꞌeto yifuana e ? ");
INSERT INTO yom_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Va ndambu beni vaba nkangu wu zingulu ziba ndia. ");
INSERT INTO yom_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Buna ziphevi beni zimbimbi zileba Yesu : —Enati weka tukuka, buna wututuma tukota kueto mu zingulu ziozi ! ");
INSERT INTO yom_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu wuba kamba : —Yendanu ! Zitotuka mu batu buadi beni zikota mu zingulu. Buna zingulu beni zioso zibotuka nsualu ku mongo ayi zidiama mu mbu, zimana fua. ");
INSERT INTO yom_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Batu bobo basunga zingulu batina ; bayenda nsualu ku divula ayi basamuna mamo maviokidi ayi mavangimini mu batu bobo baba ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Batu boso ba divula dina bayiza dengana Yesu ayi bu bammona buna banleba kabotuka mu zunga kiawu. ");
INSERT INTO yom_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu wukuma mu nlungu ayi wusabuka mbu ; ayi wuyenda ku divula diandi. ");
INSERT INTO yom_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bannatina mu kiphoyi dikoka dimosi. Yesu bu kamona minu kiawu, wukamba dikoka : —Ba ayi bukhafi muanꞌama, masumu maku malemvukulu. ");
INSERT INTO yom_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Buna minlongi minkaka mi Mina mieka niunguta : “Mutu wawu wulembo vuezi Nzambi !” ");
INSERT INTO yom_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu wuzaba mayindu mawu ayi wuba yuvula : —Bila mbi luididi mayindu mambimbi mu mintima mieno ? ");
INSERT INTO yom_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mbi bilutidi kambu phasi mu kamba : “Masumu maku malemvukulu” voti : “Telama kuaku ayi diata” ? ");
INSERT INTO yom_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Vayi muingi luzaba mboti ti Muana Mutu beki lulendo vava ntoto mu lemvukila masumu. Buna wutala dikoka ayi wunkamba : —Telama, bonga kiphoyi kiaku, vutuka ku nzoꞌaku. ");
INSERT INTO yom_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dikoka beni ditelama ayi diyenda ku nzoꞌandi. ");
INSERT INTO yom_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nkangu wu batu bu wumona bobo, bamona boma ayi bakembisa Nzambi wuvana lulendo luphila yoyi kuidi batu. ");
INSERT INTO yom_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu wuyenda. Bu kaba vioka, wumona mutu wumosi, dizina diandi Matayi, wuvuanda mu bilu kimfutusulungu ziphaku. Wunkamba : —Wundandakana ! Matayi wutelama ayi wunlandakana. ");
INSERT INTO yom_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Bu kaba ndia va meza mu nzo Matayi, buna mimfutisi miwombo mi ziphaku ayi bankua masumu bayiza dia va meza va kimosi ayi Yesu ayi minlonguki miandi. ");
INSERT INTO yom_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bafalisi bu bamona bobo bayuvula minlonguki miandi : —Bila mbi Nlongiꞌeno kalembo dila va kimosi ayi mimfutisi mi ziphaku ayi bankua masumu e ? ");
INSERT INTO yom_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu bu kawa bobo, buna wuvutula : —Batu badi nitu yi mvini batombanga munganga ko vayi batu badi bimbevo bawu bantombanga munganga. ");
INSERT INTO yom_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Luenda lulonguka tsundu yi mambu mama : thidi luba batu badi mintima mi kiadi vayi mbengi luthambikanga kaka makaba. Bila ndisia kuiza tela ko batu basonga vayi ndiyiza tela bankua masumu. ");
INSERT INTO yom_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Buna minlonguki mi Yowani miyiza kuidi Yesu mu kunyuvula ti : —Bila mbi beto ayi bafalisi tueti kifuisa nzala mu diambu di lusambulu vayi minlonguki miaku mikifuisanga nzala ko mu diambu di lusambulu e ? ");
INSERT INTO yom_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu wuba vutudila : —Lumbanza ti batu bobo batumusu kuidi ditoko diodo dikuedidi balenda ba mu kiadi ditoko bu kakidi yawu va kimosi e ? Vayi vadi thangu bu bela ku bakatula ditoko va khatitsikꞌawu, buna bosi bela kukifuisa nzala mu diambu di lusambulu. ");
INSERT INTO yom_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kuisi ko mutu wela bonga tendi kinledi kimona muingi kalondila nledi wukhulu bila tende kioki kimona maki kakuna nledi wukhulu, ayi divudu ma diba dinneni. ");
INSERT INTO yom_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bobuawu balendi tula ko vinu kimona mu zitsaku zikhulu bila buna zitsaku zikanzukidi ayi buna vinu kidukukidi ayi zitsaku zifuidi. Vayi beti lundila vinu kimona mu zitsaku zimona. Mu phila yoyi zitsaku ayi vinu mabilundama bumboti ! ");
INSERT INTO yom_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mu thangu Yesu kaba kamba mambu mama, pfumu yimosi wuyiza fukama va ntualꞌandi ayi wutuba : —Muanꞌama wunketo fuidi vayi bufueni wiza ntetika koko kuaku ayi ma kazinga diaka ! ");
INSERT INTO yom_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu wutelama ayi wunlandakana va kimosi ayi minlonguki miandi. ");
INSERT INTO yom_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mu thangu yina nketo wumosi wuba kimbevo kiviokanga menga ; kimbevo beni kizingila kumi mvu miodi, wufikama ku manima ayi wusimba tsongi nlediꞌandi. ");
INSERT INTO yom_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Bila wuyindula mu ntimꞌandi ti : “minu simba kuandi nledi andi, mfueti kaka beluka !” ");
INSERT INTO yom_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu wutala ku manima ayi bu kammona, wutuba : —Muanꞌama wunketo, ba bukhafi, bila minu kiaku kibelusidi ! Buna nketo beni wubeluka muna yina thangu. ");
INSERT INTO yom_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu bu katula ku nzo pfumu, wumona minsiki mi minsioni ayi nkangu wu batu wuba ntela-ntela. ");
INSERT INTO yom_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Buna wutuba : —Totukeno, bila muana wunketo kasi fua ko, vayi tulu tuandi kalekidi. ");
INSERT INTO yom_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nkangu bu wumana totuka ku nganda, Yesu wukota ayi wusimba muana beni mu koko, bosi muana ndumba beni wutelama. ");
INSERT INTO yom_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tsangu beni yitembakana mu zunga kioso. ");
INSERT INTO yom_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu bu katotuka vana, baphofo buadi zinlandakana vayi sumbu ziba kuenda nlandakana zilembo yamikina : —A Muana Davidi e, wutumoni kiadi e ! ");
INSERT INTO yom_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bu kakota ku nzo, baphofo zifikama va kaba. Niandi wuba yuvula : —Luwilukidi ti ndenda vanga diawu e ? Bawu bavutula : —Nyinga Pfumu. ");
INSERT INTO yom_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Bosi wusimba meso mawu ayi wukamba : —Bika buvangimina boso buididi minu kieno ! ");
INSERT INTO yom_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Vana vawu meso mawu mazibukidi. Yesu wuba kandika ti : —kadi mutu kazaba mambu mama. ");
INSERT INTO yom_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Vayi bawu bu bayenda, bamana tembikisa tsangu andi mu zunga kioso. ");
INSERT INTO yom_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mu thangu batotuka, bannatina dibaba, wuba yamusungu kuidi pheve yimbimbi. ");
INSERT INTO yom_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu wukuka pheve beni. Muna thangu beni kaka mutu weka nyoluka. Batu basimina ayi bakamba : —Tumueni ko mambu ma phila yayi mu Iseli ! ");
INSERT INTO yom_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Vayi Bafalisi bakamba : —A keti mu lulendo lu Pfumu yi ziphevi zimbimbi kalembo kukila ziphevi zimbimbi ! ");
INSERT INTO yom_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu wuba diengilanga mu mavula moso ayi mu mala moso. Wuba longanga mu zinzo zi zikhutukunu zi Bayuda ayi wuba longanga Nsamu wumboti wu Kipfumu, wuba belusanga bimbevo biphila mu phila ayi ziphasi zi phila mu phila. ");
INSERT INTO yom_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bu kamona nkangu wu batu, kiadi kimbuila mu diambu diawu, bila batu beni ku tsi mayindu baba ayi baba bavonga banga mamemi makondolo nsungi. ");
INSERT INTO yom_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Buna wukamba minlonguki miandi : —Lutala, mimbutu miyela mieka miwombo mu tsola vayi bisadi bidi bifioti. ");
INSERT INTO yom_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Diawu lulomba kuidi Pfumu yi tsola muingi kafidisa bisadi mu diambu di vela mimbutu. ");
INSERT INTO yom_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu wutela minlonguki miandi kumi mi miodi ayi wuba vana lulendo lukukila ziphevi zimbimbi ayi lu belusila bimbevo bioso ayi ziphasi zioso. ");
INSERT INTO yom_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mazina ma kumi bamvuala buadi mawu mama : wutheti Simoni baba ntedilanga Piela bosi khombꞌandi Andele. Zaki muana Zebede ayi khombꞌandi Yowani. ");
INSERT INTO yom_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi ayi Balitelemi ; Toma ayi Matayi mfutisi wu phaku Zaki muana Alafayi ayi Tade. ");
INSERT INTO yom_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni wuba mu dingumba di bazeloti ayi Yuda Isikalioti mutu wusumbisa Yesu. ");
INSERT INTO yom_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Baba kumi batu buadi bawu Yesu katuma bu kamana ku bavana zithumunu ziazi : —Lubika kuenda mu zitsi zi bapakanu ayi lubika kota kadi mu divula dimosi di basi Samali. ");
INSERT INTO yom_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Vayi yendanu kuidi mamemi ma zimbala ma Iseli. ");
INSERT INTO yom_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Koso buangu lunkuenda lulonga ti Kipfumu ki Diyilu kifikimini. ");
INSERT INTO yom_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lubelusa batu bambela, lufulukisa bafua, luvedisa bankua buazi, lukuka ziphevi zimbimbi. Luvana mu phamba bila mu phamba mamveno lubakidi. ");
INSERT INTO yom_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Lubika nata nolo, palata ayi zimbongo, mu ziphosi zieno. ");
INSERT INTO yom_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Lubika nata sakosi yi nzietolo, kadi nata kikhutu kiviakisa kadi sapatu, kadi nti, bila “kisadi kafueti baka bidia biandi.” ");
INSERT INTO yom_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Thangu lunkota mu divula voti mu buala bumosi, lutomba mutu widi wufuana mu kuluyakula ayi luvuanda kuidi niandi nate luela botuka muna. ");
INSERT INTO yom_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Thangu lukotidi mu nzo, luvana basi nzo beni mboti. ");
INSERT INTO yom_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Enati nzo beni yidi yifuana, buna bika ndembama yeno yiba mu bawu. Vayi enati yisi yifuana ko, buna bika ndembama yeno yivutuka kuidi beno. ");
INSERT INTO yom_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Enati mutu mengi kulutambula ayi mengi wa mambu meno, bu luntotuka mu nzo beni voti mu divula beni buna lukukumuna mbungi-mbungi yi malu meno. ");
INSERT INTO yom_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Bukiedika ndikulukamba ti mu lumbu kitsambusu, mavula ma Sodoma ayi Ngomola mela baka thumbudulu yidekuka viokila yi divula dina. ");
INSERT INTO yom_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Tala ndilufidisidi banga mamemi va khatitsika memvo. Diawu luba diela banga zinioka ayi luba batu balembama banga mabembi. ");
INSERT INTO yom_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Vayi lukikeba va khatitsika batu bila bela kulufunda mu ntilibinadu yi Bayuda ayi bela kulubeta bikoti mu zinzo ziawu zi zikhutukunu. ");
INSERT INTO yom_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bela ku lunata ku ntuala minyadi mi leta ayi mintinu mu diambu diama. Bobo luela bakila diluaku mu kuthelimina kimbangi kuidi bawu ayi kuidi Bapakanu. ");
INSERT INTO yom_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mu thangu bela kulukanga, luba bika ba mayindu mu mambu luela tuba voti mu phila luela yolukila mawu bila mambu luela tuba luela ma tambula kaka mu thangu yina. ");
INSERT INTO yom_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bila kadi sia ti beno luela yoluka vayi Pheve yi Dise dieno yela yoluka mu beno. ");
INSERT INTO yom_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Khomba wela yekula khombꞌandi mu kumvondisa. Dise diela yekula muanꞌandi. Bana bela fuemina bambuta ziawu ayi bela kuba vondisa. ");
INSERT INTO yom_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Batu boso bela kululenda mu diambu diama. Vayi mutu wowo wela kanga ntima nate kuna tsuka, wela vuka. ");
INSERT INTO yom_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Enati baluyamisini mu divula dimosi, lutinina ku diodi kinkaka. Bila bukiedika ndikulukamba ti muana mutu wela vutuka tuamina beno lumanisa tinina mu mavula moso ma Iseli. ");
INSERT INTO yom_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Muana nzo nkanda kasi viatuka ko nyinyisiꞌandi ; muisi kisalu kasi viatuka ko pfumuꞌandi. ");
INSERT INTO yom_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bufueni muana nzo nkanda kaba banga nyinyisi andi ayi muisi kisalu kaba banga pfumuꞌandi. Enati babieka pfumu yi nzo Belezebuli ; buna buevi bela tubila kuidi bobo bamvuandanga mu nzo andi ? ");
INSERT INTO yom_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Diawu lubika kuba mona tsisi. Bila kuisi ko diambu disuama diela kambu monika ayi kuisi ko diambu di kitsueki diela kambu zabakana. ");
INSERT INTO yom_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mambu moso ndikulukamba mu tombi, luyolukila mawu va muini. Mambu moso baku luniungutila va dikutu lutubila mawu ku yilu muanzu wu nzo. ");
INSERT INTO yom_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","—Lubika mona tsisi batu bobo balenda vonda nitu, ayi balendi vonda muela ko. Vayi bika lutina mutu wowo wulenda bunga nitu ayi muela ku bulungi. ");
INSERT INTO yom_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","A buevi, basumbisanga ko zitsiodila zizole mu thalu yimosi yi fioti e ? Vayi kuisi ko yimosi yela bua va ntoto mu kambu luzolo lu dise dieno. ");
INSERT INTO yom_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Vayi mu diambu dieno, luzebi ti zitsuki zieno zioso zidi zitangu. ");
INSERT INTO yom_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Diawu lubika mona boma ! Bila lulutidi nkangu wu zitsiodila mu luvalu. ");
INSERT INTO yom_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Diawu woso wela kukhikinina va meso ma batu mamvana ndiela kunkikinina va meso ma dise diama didi ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Vayi woso wukuthunuka va meso ma batu, mamvama ndiela kuntunuka va meso ma dise diama didi ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Lubika banza ti ndembama ndinata va ntoto. Ndisia nata ndembama ko vayi sabala nzidilunatini. ");
INSERT INTO yom_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ndiyiza mu vambisa muana bakala ayi dise diandi, muana nketo ayi ngudi andi, bosi nketo wu dikuela ayi nzituꞌandi wunketo. ");
INSERT INTO yom_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Basi nzo andi bawu bela ba bambeni bandi. ");
INSERT INTO yom_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Woso mutu wunluta zola dise diandi voti ngudi andi viokila minu kasi fuana kuidi minu ko. Ayi woso mutu wunluta zola muanꞌandi wu bakala voti muanꞌandi wunketo viokila minu kasi fuana kuidi minu ko. ");
INSERT INTO yom_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Woso wunkambu nata dikulusi diandi ayi wunkambu kundandakana buna kasi fuana kuidi minu ko. ");
INSERT INTO yom_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Woso wela tomba vukisa luzingu luandi wela luzimbisa vayi woso wela zimbisa luzingu luandi mu diambu diama, wela lutambula. ");
INSERT INTO yom_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Woso wela kulutambula, buna minu katambudi ; ayi bu kathambudi, buna tambudi mutu wowo wuthuma. ");
INSERT INTO yom_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Woso wela tambula mbikudi bila kadi mbikudi, buna wela baka mfutu wumosi banga wu mbikudi. Woso wela tambula mutu wusonga, bila kadi wusonga wela tambula mfutu wumosi banga mutu wusonga. ");
INSERT INTO yom_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Woso wela vana, ka diambu ko, kopo yimosi kuandi, yinlangu wu kiozi kuidi wumosi mu bana bafioti bobo bila kadi nlonguki ama bukiedika ndikulukamba ti wela baka mfutu andi. ");
INSERT INTO yom_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu bu kamanisa vana zithumunu ziozi kuidi kumi minlonguki miandi miodi, wuyenda longi ayi samuna mu mavula mawu. ");
INSERT INTO yom_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yowani Mbotiki mu thangu kaba mu nloko, wuwa tsangu yi mavanga momo Klisto kaba vanganga, buna wufidisa minlonguki miandi muingi banyuvula : ");
INSERT INTO yom_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—Bukiedika kuandi ti ngeyo mutu wowo wufueti kuiza voti tuvingila wunkaka e ? ");
INSERT INTO yom_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu wuba vutudila : —Luvutuka kuidi Yowani ayi lunkamba mambu momo lulembo wa ayi lulembo moni : ");
INSERT INTO yom_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","batu bafua meso balembo moni ; makoka malembo diati ; batu babuazi balembo vedusu ; batu bafua matu balembo wi ayi bafua balembo fuluka ayi Nsamu Wumboti wulembo longu kuidi batu basukama. ");
INSERT INTO yom_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Khini kuidi mutu wela kambu zimbisa minu kiandi mu diambu diama. ");
INSERT INTO yom_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mu thangu minlonguki mivutuka, Yesu wubaka diluaku di yolukila mambu ma Yowani Mbotiki kuidi nkangu wu batu : —Mbi biobi luyenda tala ku dikanga e ? Nti wufioti wulembo vevomono kuidi phemo e ? ");
INSERT INTO yom_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Vayi buna nani luyenda tala e ? Mutu wuvuata minledi mi kitoko e ? Nana. Bila batu bobo bamvuatanga minledi mi kitoko mu zinzo zi mintinu bankalanga. ");
INSERT INTO yom_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Vayi buna mbi luyenda tala ? Mbikudi luyenda tala e ? Nyinga, buawu kuandi vayi ndikulukamba ti niandi viokidi mbikudi. ");
INSERT INTO yom_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bila niandi mutu wowo minkanda milembo tubila ti : tala, mfidisidi mvualꞌama ku ntualꞌaku, niandi wela kukubikila nzila ! ");
INSERT INTO yom_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Bukiedika ndikulukamba : mu batu boso bobo babutu kuidi baketo, kuisi ko mutu wowo viokidi Yowani Mbotiki. Vayi mutu wowo wulutidi kefa mu kipfumu ki Diyilu, wunlutidi. ");
INSERT INTO yom_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tona mu bilumbu bi Yowani Mbotiki nate buabu Kipfumu ki Diyilu kilembo bakulu mu kingolo ayi batu ba ngolo bawu kaka banzionanga kiawu. ");
INSERT INTO yom_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bila Mina ayi mimbikudi mioso mibikula nate mu thangu Yowani. ");
INSERT INTO yom_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Enati lutidi ku diwilukila buna luzaba ti niandi Eli mutu wowo wufueti kuiza. ");
INSERT INTO yom_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Woso widi matu ma wilu buna bika kawa. ");
INSERT INTO yom_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—Banga mbi ndenda dedikisa tsungi yayi e ? Yidedikini banga bana bafioti bavuendi va zandu ayi balembo tedi bakundi bawu : ");
INSERT INTO yom_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Beto tulusikidi nsioni lusia kina ko ; tuyimbila minkunga mi mafua vayi lusia nionga ko. ");
INSERT INTO yom_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bila Yowani wuyiza, kasa nua ko ayi kasa dia ko vayi bakamba : “pheve yimbimbi yidi yandi !” ");
INSERT INTO yom_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Vayi Muana Mutu, wuyiza, wundia ayi wunua ayi bakamba : “Niandi nzuna kadi ayi kolo mbungu, nkundi mimfutisi mi ziphaku ayi wu bankua masumu.” Vayi nduenga yimonikanga bumboti mu mavanga mandi. ");
INSERT INTO yom_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bosi wutubidila ngolo mavula momo mu kavangila bikumu biandi biwombo, bila batu bobo basia balula mavanga mawu ko. ");
INSERT INTO yom_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Mabienga kuidi ngeyo Kolazini ayi ngeyo Betezayida bila enati ndivanga mu mavula ma Tile ayi Sidoni bikumu biobi ndivanga va beno, nganu thama batu ba mavula beni bavuata zitsaku ayi bakivinda dibombi mu monisa ti babaludi mintima. ");
INSERT INTO yom_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bukiedika ndikulukamba mu lumbu kitsambusu, Tile ayi Sidoni bela baka thumbudulu yifioti vayi yeno yela luta ngolo ! ");
INSERT INTO yom_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bosi ngeyo Kafalinawumi, wumuena ti ngeyo wela tombulu ku yilu e ? Nana ! Wela kululu nate ku tsi bafua ! Bila enati ndivanga mu Sodomo bikumu banga biobi ndivanga kuidi ngeyo, nganu divula beni dilembo zingi nate buabu. ");
INSERT INTO yom_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bukiedika ndikulukamba mu lumbu kitsambusu, thumbudulu yi Sodomo yela ba yideduka, yaku yela viatuka ngolo ! ");
INSERT INTO yom_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mu thangu yina, Yesu wukamba : —A Tata, Pfumu yi Diyilu ayi yi ntoto, ndikukembisa bu wusueka mambu mama kuidi batu badi nzayilu ayi kuidi batu badi diela vayi wumonisa mawu kuidi bana bafioti. ");
INSERT INTO yom_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nyinga Tata, buawu bobo bubela luzolo luaku. ");
INSERT INTO yom_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dise diama niandi wuphana bima bioso. Kuisi ko mutu zebi Muana vayi Tata kaka wunzebi. Kuisi ko mutu zebi Tata vayi Muana wunzebi ayi mutu wowo Muana kazodidi kummonikisa niandi. ");
INSERT INTO yom_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yizanu kuidi minu beno boso bobo luvongidi ayi luneti mimfuna, minu mandi luvundisa. ");
INSERT INTO yom_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bika lubonga vangu kiama, lulonguka kuidi minu bila minu ndidi mutu wu ntima wulembami ayi wukuluka ayi ma lubaka luvundulu mu miela mieno. ");
INSERT INTO yom_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bukiedika vangu kiama kisi phasi mu nata ko ayi mfunꞌama wisi zitu ko. ");
INSERT INTO yom_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mu bilumbu bina, Yesu wuviokila mu tsola ble mu lumbu ki saba. Minlonguki miandi nzala miba mona diawu mikodila ble muingi midia. ");
INSERT INTO yom_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Thangu Bafalisi bamona bobo, buna bakamba Yesu : —Tala minlonguki miaku milembo vangi mambu makandama mu lumbu ki saba ! ");
INSERT INTO yom_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Vayi Yesu wuba vutudila : —Lutengi ko mambu Davidi kavanga mu thangu niandi ayi bakundi bandi baba nzala ? ");
INSERT INTO yom_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wukota mu Nzo Nzambi ; niandi ayi bakundi bandi badia mapha momo matambuku kuidi Nzambi, ka diambu ko niandi ayi bakundi bandi basia ba ko minsua mu dia mapha beni vayi botula kaka banganga Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Voti lutengi ko mu Mina ti mu lumbu ki saba zinganga Nzambi zieti sumuna lumbu ki saba bu zieti sala mu nzo Nzambi. Buna basi vanga nzimbala ko e ? ");
INSERT INTO yom_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Muaki bukiedika ndikulukamba mutu wumosi widi vava viokidi Nzo Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Vayi enati luzebi tsundu yi mambu mama : thidi luba batu badi mintima mi kiadi vayi mbengi luthambikanga kaka makaba. Nganu lusia bedisa ko batu bobo basia vanga bila ko. ");
INSERT INTO yom_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bila Muana Mutu, niandi pfumu yi lumbu ki saba. ");
INSERT INTO yom_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bu kabotuka kuna, wuyenda ku nzo awu yi lukutukunu. ");
INSERT INTO yom_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kuna kuba mutu wumosi wuba koko kusioka. Buna banyuvula : —Minsua midi mu belusa mutu mu lumbu ki saba e ? Banyuvula bobo mu diambu babaka diluaku di kumfundila. ");
INSERT INTO yom_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu wuba vutudila : —Zimbukila mutu wumosi mu beno widi dimemi dimosi kaka vayi ditibukidi mu dibulu dinda mu lumbu ki saba. Buna kalendi tibuka ko ayi ku ditotula ko e ? ");
INSERT INTO yom_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Keti mutu lutidi dimemi mu mfunu ! Bukiedika ndikulu kamba minsua midi mu vanga mamboti mu lumbu ki saba. ");
INSERT INTO yom_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bosi wukamba kuidi mutu beni : —Nonuna koko kuaku ! Mutu beni wunonuna kuawu, ayi, koko kuandi kuba kusioka kufuana banga koko kunkaka. ");
INSERT INTO yom_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ku nzimunina Bafalisi batotuka, bakutakana muingi batomba diluaku di balenda vondisila Yesu. ");
INSERT INTO yom_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Vayi Yesu bu kazaba diawu buna wukatuka vana. Nkangu wunneni wunlandakana ayi, wubelusa batu boso. ");
INSERT INTO yom_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Vayi wuba kandika babika tuba ti niandi nani. ");
INSERT INTO yom_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Buawu bobo budedikinina mambu mama ma mbikudi Ezayi : ");
INSERT INTO yom_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nzambi wutuba ti tala kisadi kiama kioki ndisobula ndikunzolanga buwombo, niandi wukumbonisanga khini. Ndiela tula pheve ama va niandi ayi wela yamikisa busonga kuidi makanda moso. ");
INSERT INTO yom_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kalendi zonza ko ayi kalendi yamikina ko. Mbembo andi yilendi wakakana ko mu zinzila ");
INSERT INTO yom_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kalendi kelula ko nti wu fioti wutufuka ayi kalendi zima ko nsifu wu muinda wukidi totula muisi nate kela nungisa busonga ");
INSERT INTO yom_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Makanda moso mela tula diana diawu mu dizina niandi. ");
INSERT INTO yom_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bannatina mutu wumosi wuba ziphevi zimbimbi, wuba phofo ayi kaba yolukanga ko. Yesu wumbelusa. Buna mutu beni wutona yoluka ayi mona. ");
INSERT INTO yom_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nkangu woso wusimina ayi wutuba : —Niandi ko Muana Davidi e ? ");
INSERT INTO yom_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Vayi Bafalisi bu bawa bobo, bakamba : —A Keti mu lulendo lu Belezebuli, pfumu yi ziphevi zimbimbi kalembo totudila ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu wuzaba mayindu mawu, wuba kamba : —Kipfumu kioso kivasukidi kiawu veka kifueti muangana ayi dioso divula voti yoso nzo yidi yikabana mu yawu veka yilendi zingila ko. ");
INSERT INTO yom_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Enati satana kukidi satana, keti buna weka wuvasuka mu niandi veka. Buna buevi kipfumu kiandi kilenda zingila e ? ");
INSERT INTO yom_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Enati ndilembo kukila ziphevi zimbimbi mu lulendo lu Belezebuli buna mu lulendo lu nani batu beno bansadilanga mu kuzi kuka e ? Diawu, bawu veka bela ba mazuzi meno. ");
INSERT INTO yom_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Vayi enati mu lulendo lu Pheve yi Nzambi ndilembo kukilanga ziphevi zimbimbi, buna Kipfumu ki Nzambi kitudidi nate kuidi beno. ");
INSERT INTO yom_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Voti buevi mutu kalenda kotila mu nzo yi mutu widi ngolo muingi kayiba bima biandi enati kasi tuama kanga ko mutu beni widi ngolo e ? Buna bosi kalenda baka buyibila mu nzo andi. ");
INSERT INTO yom_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Woso mutu kambulu yama kithuadi buna mbeni ama. Woso mutu wunkambu kupika yama va kimosi buna niandi wulembo sasikisa. ");
INSERT INTO yom_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Diawu ndikulukambila : masumu moso ayi mvuezolo woso wulenda lemvokolo vayi botula kaka mvuezolo yintambula Pheve Yinlongo. ");
INSERT INTO yom_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Woso wela yoluka mambu mambimbi mu diambu di Muana Mutu wela lemvokolo, vayi woso wela yoluka mambu mambimbi mu diambu di Pheve Yinlongo kalendi lemvokolo ko mu thangu yayi voti mu thangu yinkuiza. ");
INSERT INTO yom_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tala enati nti widi wumboti buna wela buta mimbutu mimboti voti enati nti widi wumbimbi buna wela buta mimbutu mimbimbi bila banzabilanga nti mu mimbutu miandi. ");
INSERT INTO yom_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Beno luidi mu dikabu di bikusa ! Buna buevi bu lenda bela ti beno batu bambimbi lulenda tuba mambu mamboti ? Bila mu mambu momo mafulukidi mu ntima muawu mueti ba mambu meti tuba mutu. ");
INSERT INTO yom_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mutu wumboti weta tuba mambu mamboti momo madi mu kiuka kiandi kimboti. Vayi mutu wumbimbi weti tuba mambu mambimbi momo madi mu kiuka kiandi kimbimbi. ");
INSERT INTO yom_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ndikulukamba ti mu lumbu kitsambusu, batu bela sambusu mu diambu di mambu moso maphamba momo batuba. ");
INSERT INTO yom_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bila mu mambu maku wela kitudulu wusonga ayi wela bedosolo. ");
INSERT INTO yom_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Buna ndambu minsoniki mi Mina minkaka ayi Bafalisi bayiza tambula minsua mu yoluka. Bawu bankamba : —Nlongi, tutidi wuvanga kumu kimosi ! ");
INSERT INTO yom_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu wuba vutudila : —Nkuna wu batu bambimbi ayi bakambulu bakuikama bawu bantomba kumu ! Balendi kumvana kinkaka ko. Vayi botula kaka kioki kivangama mu mbikudi Zonasi ! ");
INSERT INTO yom_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bila bobuawu Zonasi kakadila mu vumu ki mbizi yinneni bilumbu bitatu ayi mabuilu matatu, buawu bobo Muana Mutu, kela kadila ku tsi ntoto bilumbu bitatu ayi mabuilu matatu. ");
INSERT INTO yom_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mu lumbu kitsambusu, basi Ninive bela telama va kimosi ayi batu ba thangu yayi ayi bela kuba zengila nkanu bila bawu babalula mintima thangu Zonasi kaba longa. Vayi tala vava vadi ayi mutu wumosi wulutidi Zonasi. ");
INSERT INTO yom_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mu lumbu kitsambusu ntinu wunketo wu sude wela telama va kimosi ayi batu ba thangu yayi ayi wela kuba zengila nkanu bila niandi wuba ku buala buidi thama muingi kiza wa mambu ma diela ma Solomo. Vayi tala vava vadi ayi mutu wumosi wulutidi Solomo. ");
INSERT INTO yom_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—Mu thangu pheve yimbimbi yitotukidi mu mutu, buna yindiengilanga mu bibuangu bi yuma mu tomba buangu kivundila. Vayi enati kakadi baka buangu, ");
INSERT INTO yom_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","buna yintubanga : “Bika ndivutuka mu nzoꞌama yoyi ndibika.” Mu thangu yela vutuka ayi yela bata nzo beni yikambulu mutu, yikombolo ayi yimana kubuku. ");
INSERT INTO yom_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Buna pheve beni yoyi yimbimbi yela tomba tsambuadi di ziphevi zinkaka ziozi zimviokidi nganzi ; bu ziela kota ayi ziela vuanda muna. Diawu, khadulu yi mutu wowo yela ba yimbimbi viokila yoyi yitheti. Bobo buela bela mu diambu di tsungi yayi yimbimbi. ");
INSERT INTO yom_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mu thangu Yesu kaba tuba kuidi nkangu wu batu, tala, ngudi andi ayi bakhomba bandi batelama ku nganda, bazola solula yandi. ");
INSERT INTO yom_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mutu wumosi wuyiza kunkamba : —Tala ngudi aku ayi bakhomba ziaku batelimini ku nganda, batidi solula yaku ! ");
INSERT INTO yom_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu wumvutudila : —Nani ngudi ama ? Banani bakhomba ziama ? ");
INSERT INTO yom_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mbadi wusonga minlonguki miandi nlembo ayi wukamba : Tala, ngudi ama ayi bakhomba ziama bawu baba. ");
INSERT INTO yom_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bila woso mutu wumvanganga luzolo lu Dise diama didi ku Diyilu, niandi khombꞌama yi bakala, khombꞌama yi nketo ayi ngudi ama. ");
INSERT INTO yom_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mu lumbu beni, Yesu wutotuka mu nzo ayi wuyenda vuanda mu muenda mbu. ");
INSERT INTO yom_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nkangu wuwombo wu batu bayiza va kaba. Diawu kakumina mu nlungu ayi wuvuanda muawu. Nkangu woso wu batu wuba va disimu. ");
INSERT INTO yom_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Wuba longa mambu mawombo mu zinongo. Buna wuba kamba : —Nkuni wumosi wuyenda ku muanga mbongo. ");
INSERT INTO yom_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bu kaba muanga mbongo; ndambu yibua mu ndambu nzila, zinuni ziyiza mana kuyidoda. ");
INSERT INTO yom_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ndambu yinkaka yibua va matadi ; vuma beni vasia ba ntoto wuwombo ko ; zitheti zivika mena bila ntoto wusia ba phiba ko. ");
INSERT INTO yom_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Vayi muini wungolo bu wutotuka, mintuidila beni miyokana ayi miyuma bila mianzi miawu misia kota ko mboti mu tsi ntoto. ");
INSERT INTO yom_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Zitheti zinkaka zibua va zitsendi. Zitsendi beni zimena ayi zifietikisa mintuidila beni. ");
INSERT INTO yom_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Vayi zinkaka zibua mu ntoto wumboti ayi zibuta mimbutu miwombo : lumosi khama yimosi ; lunkaka makumasambunu ayi lukaka makumatatu. ");
INSERT INTO yom_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Woso widi matu ma wila buna bika kawa. ");
INSERT INTO yom_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Minlonguki mifikama ayi minyuvula : —Bila mbi wulembo sadila zinongo mu kuba yolukila e ? ");
INSERT INTO yom_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Buna niandi wuba vutudila : —Beno lutambula diluaku di zabila mansueki ma Kipfumu ki Diyilu, vayi bawu basia kuma tambula ko. ");
INSERT INTO yom_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bila mutu wowo widi bima, bela kumvana ayi wela baka biwombo biviatukidi tezo. Vayi mutu wowo kambulu bima, wela ziono fiofi fidi yandi. ");
INSERT INTO yom_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Diawu ndikubakambilanga mu zinongo bila balembo tadi vayi bakadi mona, ka diambu ko batembi makutu vayi bakadi wa ayi bakadi sudika. ");
INSERT INTO yom_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mavangimini bobo mu diambu di dedikisa mambu mbikudi Ezayi kabikula mu diambu diawu : Wa, luela wa kueno vayi lulendi sudika ko. Tala, luela tala kueno vayi lulendi mona ko. ");
INSERT INTO yom_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bila mintima mi batu baba miyikidi ngolo banga matadi. Bamengi kuawu wa. Bazibikidi meso mawu ; bila nganu meso mawu malenda mona, makutu mawu malenda wa, mintima miawu milenda sudika, bila nganu balenda balula mavanga ayi nganu ndenda kuba belusa ! ");
INSERT INTO yom_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Vayi khini kuidi beno bila meso meno malembo moni ayi makutu meno malembo wi. ");
INSERT INTO yom_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Bukiedika ndikulukamba ti mimbikudi miwombo ayi batu bawombo basonga baba tsatu mu mona mambu momo lulembo moni vayi basia mamona ko ; ayi baba tsatu mu wa mambu ma lulembo wi vayi basia mawa ko. ");
INSERT INTO yom_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Luwa tsundu yi nongo yoyi ndilukembi, nongo yi nkuni : ");
INSERT INTO yom_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yoso-yoso thangu mutu kawilu mambu ma kipfumu ayi kakadi kuma sukida, buna pheve yimbimbi yikuiza vuzanga mambu momo makunu mu ntimꞌandi. Yawu yoyi mbongo yibua va ndambu nzila. ");
INSERT INTO yom_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbongo yoyi yibua va matadi yawu mutu wuwa mambu ma Nzambi ayi wutumbu vika ku matambula mu khini. ");
INSERT INTO yom_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sumbu yisia ba mianzi ko buna yisia zingila ko. Ziphasi voti yamusu bu bizidi mu diambu di mambu ma kipfumu, buna wuvika buanga nsualu. ");
INSERT INTO yom_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbongo yoyi yibua va zitsendi yawu mutu wuwa mambu ma Nzambi vayi mayindu mu diambu di luzingu lualu ayi mu diambu di kimvuama ki luvunu mamfietikisanga mambu ma Nzambi ayi malendi vana diluaku ko muingi mbongo beni yibuta. ");
INSERT INTO yom_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Vayi mbongo yoyi yibua va ntoto wumboti yawu mutu wuwa mambu ma Nzambi ayi wusudika mawu ; wumbutanga mimbutu khama yimosi, makumasambanu, makumatatu. ");
INSERT INTO yom_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu wuba kamba nongo yinkaka : —Kipfumu ki Diyilu kidedakani banga mutu wowo wukuna mabongo yimboti mu tsolꞌandi. ");
INSERT INTO yom_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Vayi batu bu baba baleka mbeniꞌandi wuyiza kuna kiti ki mbimbi va khatitsika ble bosi wuyenda kuandi. ");
INSERT INTO yom_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ble bu kimena ayi kitotula zitsangu buna kiti ki mbimbi diaka kimena. ");
INSERT INTO yom_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Buna bisadi bi pfumu yi tsola biyiza ku nyuvula : —Pfumu, keti mbongo yimboti wukunini mu tsolꞌaku e ? Buna kuevi kubedi kiti kiaki kimbimbi e ? ");
INSERT INTO yom_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Niandi wuba vutudila : —Mbeni niandi wuvengi buawu. Buna bisadi binyuvula : —Tidi tuenda vuzi kiti kioki kimbimbi e ? ");
INSERT INTO yom_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pfumu wuvutula : —Nana ! Bila beno vuza kiti kioki buna lulenda vuza ayi ble. ");
INSERT INTO yom_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bikanu biabi biodi biyedila va kimosi nate mu thangu yela velo mimbutu. Buna mu thangu yina, ndiela kamba batu ba kisalu : “vuzanu theti kiti kioki kimbimbi bosi lukanga kiawu mu minko mu diambu luyoka kiawu. Bosi luela vela ble ayi luela ku yitula ku yilu banga kiama.” ");
INSERT INTO yom_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu wuba kamba nongo yinkaka : —Kipfumu ki Diyilu kidedakani banga luteti lu mutalide. Mutu wumosi wubonga luawu ayi wukuna luawu mu tsolꞌandi. ");
INSERT INTO yom_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Luteti beni luviokidi zitheti zioso mu keva vayi enati lumenini buna lumviokanga bikunusu bioso mu kula ayi lunkitukanga nti. Muawu zinuni zieti kuiza ayi vanga zindiala ziawu mu matafi mandi. ");
INSERT INTO yom_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wuba kamba nongo yinkaka : —Kipfumu ki Diyilu kidedakani banga luvi lolo nketo kabongidi ayi sobikisidi luawu mu bitezo bitatu bi falina nate yimvimbisa falina yoso. ");
INSERT INTO yom_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu mu zinongo katubila mambu moso momo kuidi nkangu wu batu ayi kadi khumbu yimosi kela tuba mambu mu kambu sadila nongo. ");
INSERT INTO yom_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Buawu bobo bu dedikinina mambu matuba mbikudi : Ndiela kuba yolukila mu zinongo, Ndiela kuba zabakisa mansueki momo masuama tona nza yivangulu. ");
INSERT INTO yom_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu bu kasindika nkangu, bosi wukota mu nzo. Minlonguki miandi mifikama va kaba ayi minyuvula : —Wutusudikisa nongo yi kiti ki mbimbi kiba mu tsola. ");
INSERT INTO yom_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu wuvutula : —Muana Mutu niandi mutu kunini mbongo yi mboti. ");
INSERT INTO yom_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tsola yidi nza, mbongo yi mboti yidi bana ba Kipfumu ; kiti ki mbimbi kidi bana ba satana. ");
INSERT INTO yom_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Satana, niandi mbeni yoyi yikuna kiti ki mbimbi. Thangu yi vela mimbutu yawu tsukulu yi nza, zimbasi ziawu bisadi bi tsola. ");
INSERT INTO yom_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Boso bumvuzulungu kiti ki mbimbi ayi kimvikulungu ku mbazu ; buawu bobo buela bela mu tsukulu yi nza. ");
INSERT INTO yom_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Muana Mutu wela fidisa zimbasi ziandi ayi ziela botula, mu kipfumu kiandi, bima bioso biobi bintotulanga masumu ayi bobo beti vanganga mambimbi. ");
INSERT INTO yom_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Zimbasi ziela loza batu beni ku mfulu yi mbazu. Kuna kuidi bidilu ayi nkuetosolo wu meno. ");
INSERT INTO yom_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Buna batu basonga, bela lezama banga thangu mu Kipfumu ki Dise diawu. Woso widi matu ma wilu buna bika kawa ! ");
INSERT INTO yom_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Kipfumu ki Diyilu kidedakani banga kima kithalu, kisueko mu tsola. Mutu niandi kuenda kibakula, maka sueka diaka kiawu. Bosi mu khini yina, buna wela kuenda sumbisa bima biandi bioso ayi sumba tsola beni yina. ");
INSERT INTO yom_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kipfumu ki Diyilu kidedakani diaka banga mukhita wowo wuntombanga bilunga bi kitoko. ");
INSERT INTO yom_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Enati bakudi lunga kimosi kithalu yiwombo, buna wela kuenda sumbisa bima biandi bioso ayi sumba lunga beni. ");
INSERT INTO yom_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kipfumu ki diyilu kidedakani diaka banga dikondi diodi balozidi mu mbu ayi dibuididi zimbisi ziphila mu phila. ");
INSERT INTO yom_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Diawu wala, banlobi mbizi ba dituta ku disimu. Bosi bavuanda ayi batula mboti mu bipani ayi miloza ziozi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Buawu bobo buela bela mu tsukulu yi ntoto : Zimbasi ziela kuiza mu vambisa batu bambimbi va khatitsika batu basonga. ");
INSERT INTO yom_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Buna ziela loza batu bambimbi ku mfulu yi mbazu kuna kuidi bidilu ayi nkuetosolo yi meno. ");
INSERT INTO yom_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","—Lusudikidi mambu moso mama e ? Bavutula : —Nyinga. ");
INSERT INTO yom_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Buna mu manisa Yesu wuba kamba : —Diawu kadika nsoniki wu Mina wulonguka mambu ma Diyilu, dedikini banga pfumu yi nzo yimbonga bima bimona bithalu ayi bikhulu mu kiuka kiandi. ");
INSERT INTO yom_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Thangu Yesu kamanisa tuba zinongo ziozi wukatuka kuna, ");
INSERT INTO yom_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","wuvutuka ku divula diandi. Wutona longa mu nzo yi lukutukunu. Buna basimina ayi batuba : —Buna kuevi kabakidi nzayilu yoyi ayi lulendo lolo luvangila bikumu biobi e ? ");
INSERT INTO yom_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Keti niandi muana salaphati ? Maliya diawu ko dizina di ngudi andi ? Bosi Zaki, Zozefi, Simoni ayi Yuda basi ko bakhomba bandi zi babakala ? ");
INSERT INTO yom_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bosi bakhomba bandi zi baketo, keti zinkalanga yeto vava ? Vayi niandi kuevi kabakidi mambu moso momo ? ");
INSERT INTO yom_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Niandi wuba kandika babika kunwilukila. Vayi Yesu wuba kamba : —Mbikudi katambulanga minsua mu tsi andi ko ayi mu dikanda diandi ko. ");
INSERT INTO yom_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Diawu kasi vanga kuna bikumu biwombo ko mu diambu di kambu kuawu ku minu. ");
INSERT INTO yom_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mu thangu yina nyadi Elode, wuwa tsangu yi Yesu. ");
INSERT INTO yom_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wukamba bisadi biandi : —Mutu wowo niandi Yowani Mbotiki, wufulukidi mu bafua, diawu kadidi lulendo lu vangila bikumu. ");
INSERT INTO yom_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Bila Elode wukangisa Yowani ayi wunkangisa mu zisieni bosi wunkotisa mu nloko mu diambu di Elodiasi nketo wu khombꞌandi Filipi. ");
INSERT INTO yom_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Bila Yowani wuba tubidilanga Elode ti : —Wisi ko minsua mu kunkuela. ");
INSERT INTO yom_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Elode wuba tombanga kumvondisa, vayi nkangu wu batu kaba ntinanga bila batu baba monanga ti Yowani widi mbikudi. ");
INSERT INTO yom_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Vayi mu lumbu ki nyengo wu mbutukulu wu Elode, muana wu nketo wu Elodiasi wukina va meso ma batu bobo batumusu ayi wumonisa Elode khini. ");
INSERT INTO yom_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Diawu kamvanina tsila mu leva ndefi ti mankamvana kima kioso kioki kanlomba. ");
INSERT INTO yom_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mu diambu di zindongi zi ngudi andi, diawu kankambila : —Phani vava mu dilonga ntu wu Yowani Mbotiki. ");
INSERT INTO yom_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ntinu wumona kiadi kiwombo. Vayi mu diambu di ndefi yi kaleva ayi mu diambu di batu bobo bavuanda yandi va meza, buna wuvana lutumu ti bamvana wawu. ");
INSERT INTO yom_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Buna wutuma mutu ku nloko muingi kenda zengi ntu wu Yowani. ");
INSERT INTO yom_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Banata ntu andi mu dilonga ayi bavana wawu kuidi muana ndumba. Niandi wuyenda kuwuvana kuidi ngudi andi. ");
INSERT INTO yom_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Minlonguki mi Yowani miyiza bonga nituꞌandi ayi mizika yawu, bosi miyenda vumbudila Yesu kipholo. ");
INSERT INTO yom_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu bu kawa nsamu beni, wukatuka kuna mu nlungu ayi wuyenda niandi veka ku buangu kikondolo batu. Vayi thangu nkangu wu batu bu wuwa wawu ; batotuka mu mavula mawu ayi banlandakana mu malu. ");
INSERT INTO yom_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu bu kakuluka mu nlungu, wumona nkangu wu batu bawombo. Wuba mona kiadi kiwombo ayi wubelusa bimbevo biawu. ");
INSERT INTO yom_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mu thangu masika, minlonguki miyiza va kaba ayi minkamba : —Va buangu kikambulu batu tuidi bosi buisi bueka yila, diawu vutula batu baba mu mala muingi benda sumbi bidia ! ");
INSERT INTO yom_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Vayi Yesu wuba kamba : —Basi mfunu mu kuenda ko, luba vananu beno veka bidia ! ");
INSERT INTO yom_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Buna bawu bamvutudila : —Tala, mapha matanu ayi zimbizi zizole zi nlangu kaka zidi yeto vava. ");
INSERT INTO yom_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu wuba kamba : —Lundatina biawu vava. ");
INSERT INTO yom_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Bosi wutuma nkangu wu batu wuvuanda va biti, wubonga mapha matanu beni ayi zimbizi zizole, wuvumbula meso ku yilu ayi wuvutula matondo. Wubukuna mapha beni ayi wuvana mawu kuidi minlonguki ayi miawu mikabudila nkangu wu batu. ");
INSERT INTO yom_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bawu boso badia ayi bayukuta. Batota bitini bisiadidila ayi biwesa kumi bipani biodi. ");
INSERT INTO yom_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Baboso badia baba nduka-nduka mili tanu yi babakala. Kadi tanga baketo ayi bana. ");
INSERT INTO yom_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ku nzimunina Yesu wutuma minlonguki miandi mu kuma mu nlungu ayi mintuaminina ku disimu dinkaka. Niandi wusiala mu sindika nkangu wu batu. ");
INSERT INTO yom_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Thangu kamana sindika nkangu wu batu, wukuma ku mongo muingi kenda sambila va buangu ki niandi veka. Nate buisi buyila buna wukidi kuna niandi veka kaka. ");
INSERT INTO yom_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mu thangu yina nlungu wutula va khatitsika mbu, wunikunu kuidi mayo bila muphepi wudengana nlungu. ");
INSERT INTO yom_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mu thangu yi nya yi builu, Yesu wuyenda ku baba vayi wudiatila va mbata mbu. ");
INSERT INTO yom_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Minlonguki bu mimmona wulembo diatila va mbata mbu, mimona boma ayi mituba : —Tala nkuyu e ! Ayi mitona yamikina mu diambu di boma. ");
INSERT INTO yom_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bosi Yesu wuba kamba : —Bika lukinda, bila minu kuandi ; bikanu mona boma. ");
INSERT INTO yom_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Buna Piela wunkamba : —A Pfumu e ! Enati bukiedika ngeyo kuandi, buna wukhamba ndiza kuidi ngeyo va mbata nlangu. ");
INSERT INTO yom_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu wunkamba : —Yiza ! Piela wutotuka mu nlungu, ayi wutona diata va mbata nlangu muingi kenda kuidi Yesu. ");
INSERT INTO yom_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Vayi bu kamona ti muphepi widi wu ngolo buna wumona boma. Bu katona diama, wuyamikina : —A ! Pfumu ! Wumvukisa e… ! ");
INSERT INTO yom_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bosi Yesu wunonuna koko, wunsimba ayi wunkamba : —Mutu wu minu kifioti, bila mbi memitini e ? ");
INSERT INTO yom_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bakuma bawu buadi mu nlungu ayi vuka kimanisa. ");
INSERT INTO yom_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bobo baba mu nlungu bafukama va ntualꞌandi ayi batuba : —Bukiedika widi Muana Nzambi ! ");
INSERT INTO yom_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Buna bamana sabuka mbu ; batula mu tsi Ngenezaleti. ");
INSERT INTO yom_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Batu ba tsi yina, batembikisa tsangu mu zunga kina. Bosi batu bannatina bambevo ziawu zioso. ");
INSERT INTO yom_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Banleba ti kabika basimba kaka tsongi yi yunga kiandi. Babo bobo bansimba babeluka. ");
INSERT INTO yom_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bafalisi ayi minlongi mi mina baba ku Yelusalemi bayiza kuidi Yesu, banyuvula : ");
INSERT INTO yom_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Bila mbi minlonguki miaku mikinzikilanga ko mambu ma bakulu e ? Bila misukulanga ko mioko miawu tuamina midia. ");
INSERT INTO yom_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Wuba wutudila : —A bosi beno, bila mbi kalu kinzikilanga ko Mina mi Nzambi mu diambu di kinzika mambu ma bakulu beno ? ");
INSERT INTO yom_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bila Nzambi wukamba : Kinzika dise diaku ayi ngudi aku ayi woso wunsinga dise diandi voti ngudi andi kafueti baka thumbudulu yi lufua. ");
INSERT INTO yom_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Vayi beno tala phila lueti tuba : Woso wukamba dise diandi voti ngudi andi ti : “Bima biabi biawu ndiedi kaveni vayi ndieka bitambika makaba kuidi Nzambi.” ");
INSERT INTO yom_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mutu vengi diambu diodi kasi kadi diambu dimosi ko kuidi dise diandi voti kuidi ngudi andi mu biobi kedi kamveni. Buna lueti vunzikisa mambu ma Nzambi ayi lueti balula mawu mu kikhulu kieno. ");
INSERT INTO yom_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Batu ba mayuya ! Ezayi wubikula bumboti mu diambu dieno bu katuba : ");
INSERT INTO yom_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Batu baba mu tsongi zi bididi kaka beta kunzitisila, vayi mintima miawu thama midi ayi minu. ");
INSERT INTO yom_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mu phamba kuandi balembo kutsambidila bila malongi balembo longi madi zithumunu zikubuku kuidi batu. ");
INSERT INTO yom_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu wutumisa nkangu wu batu ayi wuba kamba : —Luwa ayi lusudika : ");
INSERT INTO yom_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Biobi binkotanga mu munu wu mutu bisumunanga mutu ko vayi biobi bintotukanga mu munu wu mutu biawu bieta sumuna mutu. ");
INSERT INTO yom_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bosi minlonguki mifikama va ndambu va kaba ayi minkamba : —Wukadi zaba ti mintima mi Bafalisi miluedi mu diambu di mambu maku ? ");
INSERT INTO yom_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu wuba vutudila : —Kioso kunusu, kikambu kuna Dise diama di Diyilu, kiela vuzu. ");
INSERT INTO yom_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Lubabika ! Badi baphofo zilembo nati baphofo bankaka. Enati phofo wulembo monisa phofo yandi nzila, bawu buadi bafueti tibuka mu dibulu ! ");
INSERT INTO yom_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piela wubaka mbembo ayi wunkamba : —Wutu sudikisa nongo yoyo. ");
INSERT INTO yom_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Bosi Yesu wuvutula : —Beno mamveno lukadi sudika e ? ");
INSERT INTO yom_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Lukadi zaba ti bibioso binkotanga mu munu binkuendanga mu vumu bosi bintotukanga ku nganda e ? ");
INSERT INTO yom_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Vayi mantotukanga mu munu wu mutu mu ntima meti ba ayi mawu meti sumuna mutu. ");
INSERT INTO yom_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bila mu ntima muntotukilanga mayindu mambimbi vonda, kitsuza, kindumba, yiba, telimina batu kimbangi ki luvunu, finga. ");
INSERT INTO yom_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mawu momo mambu mansumunanga mutu. Vayi enati mutu kakadi sukula mioko tuamina kadia, diodi dilendi kunsumuna ko. ");
INSERT INTO yom_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu bu kabotuka vana ; wuyenda mu bizunga bi Tile ayi bi Sidoni. ");
INSERT INTO yom_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Zimbukila nketo wumosi, muisi Kana, wuba vuandanga muna bizunga beni wuyiza ku kaba ayi wuyamikina : —A Pfumu ! Muana Davidi, wumboni kiadi ! Pheve yimbimbi yilembo yamisa ngolo muanꞌama wu nketo. ");
INSERT INTO yom_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Vayi Yesu kasi kumvutudila kadi diambu ko. Minlonguki mifikama va ndambu vaba Yesu ayi minleba : —Wunkuka, bila wulembo yamikina ngolo ku manima meto. ");
INSERT INTO yom_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Vayi niandi wuvutula : —Minu nditumu kaka kuidi mamemi ma Iseli momo mazimbala ! ");
INSERT INTO yom_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Vayi nketo beni wuyiza fukama va ntualꞌandi ayi wunkamba : —Pfumu, wutsadisa ! ");
INSERT INTO yom_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Buna wumvutudila : —Disi fuana ko mu bonga dipha di bana ayi lozila diawu zimbua. ");
INSERT INTO yom_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nketo wunkamba : —Nyinga Pfumu ! Vayi zimbua zieti dia bitsiedi-tsiedi biobi bieta bua ku tsi meza yi bapfumu bawu. ");
INSERT INTO yom_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Buna Yesu wumvutudila : —E e nketo, minu kiaku kidi kinneni ! Diawu bika buvangama boso butididi. Muna thangu yina kaka muanꞌandi wunketo wubeluka. ");
INSERT INTO yom_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu wubotuka vana ayi wuyenda ku muenda mbu wu Ngalili, wukuma ku mongo ayi wuvuanda kuna. ");
INSERT INTO yom_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nkangu wu batu bawombo bayiza ku kaba, banata batu bobo baba ntiudikanga, baphofo, mababa, batu babela malu ayi mioko ayi bambevo bankaka. Babatula va malu ma Yesu ayi wuba belusa. ");
INSERT INTO yom_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nkangu woso wu batu wusimina bu wumona ti mababa matona yoluka, batu babela malu ayi mioko babeluka, batu bobo baba ntiudika batona diata bu mboti, baphofo zitona mona. Buna baboso bakembisa Nzambi yi Iseli. ");
INSERT INTO yom_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu wutumisa minlonguki miandi ayi wuba kamba : —Kiadi ndilembo moni nkangu wu batu baba, bila bilumbu bitatu bame vuandila yama ayi basiedi ko bidia. Ndikadi zola kuba vutula ayi nzalꞌawu bila balenda bua dibutu mu nzila. ");
INSERT INTO yom_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Minlonguki mimvutudila : —Va buangu kikambulu batu tuidi, buna kuevi tulenda bakila mapha mafueni mu dikila nkangu wu batu wawu e ? ");
INSERT INTO yom_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu wuba yuvula : —Mapha makua madi yeno ? Bawu bavutula : —Tsambuadi yi mapha madi yeto ayi bina bi zimbizi zi nlangu ! ");
INSERT INTO yom_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Buna wutumina batu boso bavuanda va tsi. ");
INSERT INTO yom_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bosi wubonga tsambuadi yi mapha beni ayi zimbizi, wuvutula matondo, wubukuna mawu ayi wuvana mawu minlonguki miandi ayi miawu mikabudila nkangu wu batu. ");
INSERT INTO yom_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Baboso badia ayi bayukuta. Batota bitini biobi bisiala, biwesa tsambudi di bipani. ");
INSERT INTO yom_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Batu boso badia baba mili ya yi babakala, kadi tanga baketo ayi bana. ");
INSERT INTO yom_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu bu kavutula nkangu wu batu, wukuma mu nlungu ayi wuyenda mu zunga ki Mangadani. ");
INSERT INTO yom_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bafalisi ayi Basaduki bayiza kuidi Yesu mu diambu bantambila ntambu. Banlomba kavanga dimbu kioki kintotukila ku diyilu. ");
INSERT INTO yom_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Niandi wuba vutudila : —Mu masika, beno lueti tuba : “mbazi kuela ba kumboti bila diyilu didi di mbuaki.” ");
INSERT INTO yom_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ayi mu nsuka lueti tuba ti : “Buabu mvula yingolo mayinoka bila diyilu didi di mbuaki ayi dinomba.” Luzebi sudika bidimbu bi diyilu vayi lulendi ko zaba sudikisa bidimbu biobi bimmonisa zithangu e ? ");
INSERT INTO yom_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Batu ba tsungi yimbimbi ayi bakambulu bakuikama bantomba dimbu e ? Balendi mona kadi dimbu kimosi ko vayi botula kaka kioki ki Zonasi. Vana vawu niandi wusia babika ayi wuyenda kuandi. ");
INSERT INTO yom_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mu thangu minlonguki misabuka ku disimu dinkaka di mbu, mizimbakana nata mapha. ");
INSERT INTO yom_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu wuba kamba : —Lukeba ayi luzibula meso mu luvi lu Bafalisi ayi lu Basaduki. ");
INSERT INTO yom_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Minlonguki miyuvusana miawu na miawu ayi mituba : —Mu diambu tukambulu nata mapha. ");
INSERT INTO yom_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Vayi bu kazaba mayindu mawu, Yesu wuba kamba : —Bila mbi lulembo kiyuvasana beno yi beno mu diambu luisi nata ko mapha ? Batu ba minu kifioti ! ");
INSERT INTO yom_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Lusudikidi ko e ? Luzimbikini mapha matanu, momo madikila mili tanu yi babakala e ? Bipani bikua luwesa mu bitsiadisila biobi bisiala ? ");
INSERT INTO yom_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bosi diaka tsambuadi di mapha momo makabudulu mili ziya zi babakala e ? Bipani bikua luwesa mu bitsiadisila biobi bisiala ? ");
INSERT INTO yom_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Buevi lunkambu sudikila ti ndisi tubilanga mu diambu di mapha ko ? Vayi lukeba mu diambu di luvi lu Bafalisi ayi lu Basaduki. ");
INSERT INTO yom_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Buna bosi basudika ti kasia bakambila mu diambu balubukila luvi lu mapha ko vayi balubuka mu diambu di malongi ma Bafalisi ayi Basaduki. ");
INSERT INTO yom_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu bu katula ku zunga ki Sezali mu Filipi, wuyuvula minlonguki miandi : —Buevi batu beti tubanga, Muana Mutu widi nani ? ");
INSERT INTO yom_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Minlonguki mimvutudila : —Bankaka beta tuba niandi Yowani Mbotiki ; bankaka Eli ayi bankaka beta tuba widi Zelemi voti wumosi mu mimbikudi. ");
INSERT INTO yom_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Buna wuba yuvula : —Vayi beno veka, lueta tuba ti Minu ndidi nani ? ");
INSERT INTO yom_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Piela wumvutudila : —Ngeyo widi Klisto, Muana wu Nzambi yi moyo ! ");
INSERT INTO yom_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Buna Yesu wunkamba : —Khini yiwombo kuidi ngeyo Simoni muana Zonasi, bila kadi sia ti mutu wuzabikisidi mambu mama vayi niandi veka dise diama didi ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Vayi minu ndikukamba : widi Piela ayi va yilu ditadi diadi ndiela tungila dibundu diama ayi mielo mi bulungi milendi ku dinunga ko. ");
INSERT INTO yom_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ndiela kuvana zitsabi zi Kipfumu ki Diyilu : dioso diambu diodi wela kanga vava ntoto, diela kangama ku Diyilu ayi dioso diambu diodi wela nianguna vava ntoto, diela niangunu mu Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Bosi Yesu wukandika minlonguki miandi mibika kamba kadi mutu wumosi ti niandi Klisto. ");
INSERT INTO yom_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tona thangu yina, Yesu wutona sudikisa minlonguki miandi ti kafueti kuenda ku Yelusalemi ayi kuna bakulutu ba Bayuda, bapfumu banganga Nzambi, minsoniki mi Mina bela kumbonisa ziphasi zingolo. Bela kumvonda vayi mu lumbu kintatu niandi wela fuluka. ");
INSERT INTO yom_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Buna Piela wunnata va ndambu ayi wutona kuntubidila : —Pfumu, bika Nzambi kakeba mu diambu di mambu beni mabika kukuizila ! ");
INSERT INTO yom_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu wubaluka kuidi Piela ayi wunkamba : —Satana ! Botuka va ndidi ! Wulembo tombi wumbuisa, bila mayindu maku masi ko ma Nzambi vayi ma kimutu ! ");
INSERT INTO yom_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bosi Yesu wukamba minlonguki miandi : —Enati mutu tidi kundandakana, buna kafueti kukizimbakana niandi veka ayi kabonga dikulusi diandi ayi kandandakana. ");
INSERT INTO yom_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bila woso tidi vukisa luzingu luandi wela luzimbisa, vayi woso wela luzimbisa mu diambu diama, buna wela lubakula. ");
INSERT INTO yom_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Enati mutu beki nza yimvimba vayi zimbisidi muelꞌandi, buna ndandu mbi kela baka e ? Voti mu kima mbi mutu kalenda viakikisa muelꞌandi e ? ");
INSERT INTO yom_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bila Muana Mutu, wela kuiza mu nkembo wu Dise diandi va kimosi ayi zimbasi ziandi, buna bosi kela vana kadika mutu mfutuꞌandi wowo wufueni mu kisalu kiandi. ");
INSERT INTO yom_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Bukiedika ndikulukamba ti batu bankaka, badi vava, balendi fua ko nate bela mona Muana Mutu wunkuizila mu Kipfumu kiandi ! ");
INSERT INTO yom_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bilumbu bisambanu bu bivioka, Yesu wubonga Piela, Zaki ayi Yowani khomba Zaki ayi wuba nata ku yilu mongo wumosi wunda. Kuna bakala bawu veka. ");
INSERT INTO yom_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Buna wukituka va ntualꞌawu ; zizi kiandi kieka nlezima banga thangu ayi minledi miandi mieka miphembi banga kiezila. ");
INSERT INTO yom_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tumbu zimbukila Moyize ayi Eli bamonikina minlonguki ; bansolula ayi Yesu. ");
INSERT INTO yom_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Buna Piela wukamba Yesu : —Pfumu, bulutidi mboti tukala kueto vava ! Enati tidi, ndieka tunga zinzo zitatu zi ngoto : yimosi mu diambu diaku, yimosi mu diambu di Moyize ayi yimosi mu diambu di Eli. ");
INSERT INTO yom_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Buna wukidi tubi, dituti dimosi dinlezama diyiza kubafuka ayi mbembo yitotuka mu dituti beni yiwakana : —Niandi niawu Muanꞌama wu luzolo, khini yiwombo kakumbonisanga ; bika lunwila ! ");
INSERT INTO yom_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mu thangu minlonguki miwa mbembo beni, mibubika bizizi biawu va ntoto bila boma bubabuila. ");
INSERT INTO yom_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Buna Yesu wufikama ; wuba simba ayi wuba kamba : —Lutelama ! Lubika mona boma ! ");
INSERT INTO yom_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mu thangu mivumbula meso, niandi veka, Yesu kaka mimona. ");
INSERT INTO yom_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bu baba nengumuka mongo, Yesu wuba vana thumunu yayi : —Lubika kamba mambu mama lumueni kuidi mutu nate lumbu Muana Mutu kela fuluka mu bafua. ");
INSERT INTO yom_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ku nzimunina minlonguki minyuvula : —A bila mbi minlongi mi Mina mieta tubila ti Eli kafueti tuama kuiza theti e ? ");
INSERT INTO yom_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu wuvutula : —Bukiedika. Eli wela kuiza ayi wela kubika mambu moso. ");
INSERT INTO yom_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Vayi minu ndikulukamba ti Eli wuyiza vayi basi kunzaba ko ayi bamvangila mambu boso bubela luzolo luawu. Buawu bobo bela monisina Muana Mutu phasi. ");
INSERT INTO yom_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Buna minlonguki misudika ti wuyolukila mu diambu di Yowani Mbotiki. ");
INSERT INTO yom_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Buna batula vaba nkangu wu batu bawombo, mutu wumosi wufikama ; wufukama va ntuala Yesu ayi wunleba : ");
INSERT INTO yom_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Pfumu, mona muanꞌama wu bakala kiadi ! Kimbevo kisisuka kidi yandi ayi wulembo moni ziphasi ziwombo. Zikhumbu ziwombo keta buila ku mbazu voti mu nlangu. ");
INSERT INTO yom_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ndinnetingi kuidi minlonguki miaku vayi mikadi nunga mu ku mbelusa ! ");
INSERT INTO yom_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu wuvutula : —A beno batu ba tsungi yikambulu minu ayi yimbimbi ! Zithangu zikua ndiela kadilanga yeno diaka va kimosi e ? Zithangu zikua ndiela buela kangilanga ntima mu bila kieno e ? Lundatina niandi vava ! ");
INSERT INTO yom_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu wutemina pheve yimbimbi beni ayi yawu yitotuka mu muana. Muna yawu thangu muana wubeluka. ");
INSERT INTO yom_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bosi minlonguki miyiza kuidi Yesu, va bawu veka, minyuvula : —Bila mbi beto tusi nunga ko mu kuka pheve yoyi e ? ");
INSERT INTO yom_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu wuba vutudila : —Bila minu kifioti kidi yeno. Bila bukiedika ndikulukamba ti enati minu kieno kidi banga luteti lolo bantedilanga mutalide, nganu lulenda kamba kuidi mongo wowo : “Botuka vava, yenda kuna !” Ayi wawu wela botuka. Kuisi ko diambu luela lembakana. ");
INSERT INTO yom_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Vayi pheve yimbimbi yiphila yayi yeti totukila kaka mu lusambulu ayi mu kukifuisa nzala mu lusambulu. ");
INSERT INTO yom_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bu bayiza va kimosi ku Ngalili, Yesu wuba kamba : —Muana Mutu wela yekolo mu mioko mi batu ");
INSERT INTO yom_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ayi bela kumvonda ; vayi mu lumbu kintatu niandi wela fuluka mu bafua. Buna minlonguki mitona mona kiadi kiwombo. ");
INSERT INTO yom_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mu thangu batula ku Kafalinawumi, batu bobo baba futisanga phaku yi Nzo Nzambi bafikama vaba Piela ayi banyuvula : —A buevi, Nlongiꞌeno kafutanga ko phaku yi Nzo Nzambi e ? ");
INSERT INTO yom_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piela wuvutula : —Nyinga, weta futa. Piela bu kakota mu nzo ; Yesu wuntuaminina : —Buevi wumbanza Simoni e ? Banani beti futa ziphaku kuidi mintinu mi ntoto e ? Bana bawu voti banzenza e ? ");
INSERT INTO yom_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piela wuvutula ti : —Zinzenza. Bosi Yesu wunkamba : —Diawu bana balendi futa phaku ko ; ");
INSERT INTO yom_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","vayi mu diambu tubika kotisa divuda mu batu baba. Yenda ku mbu, loza nziolo mu nlangu ; benda mbizi yitheti yimbakana, zibula munuꞌandi, buna ma wumona vanzi. Bonga kiawu ayi wuba vana mu diambu di futa ziphaku zi beto buadi. ");
INSERT INTO yom_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Muna thangu yina, minlonguki miyiza kuidi Yesu ayi minyuvula : —Buna nani lutidi munneni mu Kipfumu ki Diyilu e ? ");
INSERT INTO yom_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu wutumisa muana lezi, wuntelimisa va khatitsikꞌawu ");
INSERT INTO yom_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ayi vutuba : —Bukiedika ndikulukamba enati lukadi balula mavanga ayi enati lukadi kituka banga bana balezi, lulendi kota ko mu Kipfumu ki Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Diawu woso mutu wowo wukukikulula banga muana wawu, buna niandi lutidi munneni mu Kipfumu ki Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ayi woso mutu wowo wunyakulu muana lezi wuphila yayi mu dizina diama, minu kuandi kayakudi. ");
INSERT INTO yom_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Woso mutu wumbuisa mu masumu wumosi mu bana balezi bobo bakunguilukilanga, bulutidi mboti bankanga ditadi dinneni diodi beti nikina zitheti mu tsingu bosi bandiamisa ku tsi mbu. ");
INSERT INTO yom_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","A nga mabienga va nza mu diambu di ziphila-phila zi mambu momo meti buisa batu mu masumu ! Mambu beni mafueti kaka kuiza vayi mabienga kuidi mutu wowo wuntonisanga mawu. ");
INSERT INTO yom_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Enati koko kuaku voti kulu kuaku kulembo buisi mu masumu buna mboti mu zenga kuawu ayi loza kuawu thama. Bila mboti wukota ku luzingu ayi koko kuzengo voti kulu kuzengo ayi mu lozo ku mbazu yika yizimanga ko ayi mioko miodi miduka voti malu muadi maduka. ");
INSERT INTO yom_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Enati dieso diaku dieta kubuisa mu masumu, dovula diawu ayi loza diawu ku thama ! Bila bulutidi mboti mu kota ku luzingu mu kambu dieso ayi lozo ku mbazu yi bulungi ayi meso muadi maduka. ");
INSERT INTO yom_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Lukeba Lubika lenza kani muana wumosi mu bana balezi baba bila ndikulukamba zimbasi ziawu ku Diyilu zintelamanga mu zi thangu zioso va ntuala zizi ki Dise diama diodi widi ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bila Muana Mutu wuyiza mu vukisa batu bobo bazimbala. ");
INSERT INTO yom_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Buevi lumbanza e ? Enati mutu beki khama yi mamemi vayi dimosi dizimbidi, buna kalendi bika ko luvua ayi divua di mamemi mankaka va mbata mongo mu kuenda tombi diodi dizimbidi e ? ");
INSERT INTO yom_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Enati mueni diawu, bukiedika ndikulukamba, makamona khini mu diambu di dimemi dina viokila khini yoyi kadi mu luvua ayi vua lu mamemi momo makambu zimbala. ");
INSERT INTO yom_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Phila yimosi ayi Dise dieno didi ku Diyilu, kakadi zola ti muana wumosi mu bana balezi baba kazimbala. ");
INSERT INTO yom_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Enati khombꞌaku vengi mbimbi, yenda wuntala ngeyo veka ayi nkambi mbimbi yi kavengi va beno veka buadi. Enati wuwilukidi, buna vutudi khombꞌaku mu nzila yimboti. ");
INSERT INTO yom_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Vayi enati kakadi wilukila, buna bonga mutu wumosi voti batu buadi mu diambu mamo mantubu makindusu mu kimbangi ki batu buadi voti ki batu batatu. ");
INSERT INTO yom_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Enati, kakadi wila batu beni, buna kamba mambu beni kuidi dibundu. Enati mengi kuandi wila dibundu, buna wuntalanga ; banga Pakanu ayi mfutisi wu phaku. ");
INSERT INTO yom_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Bukiedika ndikulukamba ti mamo luela kanga vava ntoto, mela kangama ku Diyilu ayi mamo luela nianguna va ntoto mela niangunu ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ndikulukamba diaka enati batu buadi mu beno vava ntoto bawizini mu lomba dioso kuandi diambu, buna Dise diama diodi widi ku Diyilu wela kuba vana diawu. ");
INSERT INTO yom_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bila vana vakutikini batu buadi voti batu batatu mu dizina diama, minu ndidi va khatitsikꞌawu. ");
INSERT INTO yom_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Piela wufikama vaba Yesu, wunyuvula : —A Pfumu ! Zikhumbu zikua mbeki bu lemvukila khombꞌama wukuphangilanga mambu mambimbi e ? Tsambuadi di zikhumbu kaka e ? ");
INSERT INTO yom_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu wumvutudila : —Nana, ndikadi kukamba ti tsambuadi di zikhumbu kaka vayi nate lusambudi lu zikhumbu bunda tsambuadi. ");
INSERT INTO yom_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Diawu Kipfumu ki Diyilu kidedikini banga ntinu wuzola tanga bima biandi ayi bisadi biandi. ");
INSERT INTO yom_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Buna katona tanga bima biandi, bannatina kisadi kimosi kiba pholo andi yi kumi di mili di bitalanta. ");
INSERT INTO yom_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Vayi bu kasia nunga ko futa ; diawu pfumuꞌandi katumina ti bansumbisa niandi veka ayi nketoꞌandi ayi bana bandi ayi bima biandi bioso muingi pholo andi yifutama. ");
INSERT INTO yom_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Vayi kisadi beni kifukama va malu mandi ayi kinleba : “Bika wumvibidila ! Mandifuta pholoꞌaku yoso !” ");
INSERT INTO yom_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pfumu wu kisadi kioki wummona kiadi, wunyekula ayi wunlemvukila pholoꞌandi yoso. ");
INSERT INTO yom_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kisadi beni bu katotuka, wudengana nkundi andi, muisi kisalu yandi ; wundeva khama yimosi yi zidenali. Niandi wumbuila ayi wumfieta va dinga ayi wunkamba : “futa pholoꞌama”. ");
INSERT INTO yom_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nkundi andi wu kisalu wufukama ayi wunleba : “Bika wumvibidila ! Mandifuta pholoꞌku.” ");
INSERT INTO yom_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Vayi wumanga vibidila, wuyenda kunkangisa nate kamanisa futa pholo yoso. ");
INSERT INTO yom_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bakundi ba kisalu bankaka bamona kiadi kiwombo bu bamona bu viokila mambu moso. Diawu bayenda kambila pfumu kisalu mambu moso bu mabela. ");
INSERT INTO yom_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Buna Pfumu beni wutumisa kisadi beni, wunkamba : “Widi kisadi kimbimbi ! Minu ndilemvukila pholo yoso bila wundeba ngolo. ");
INSERT INTO yom_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","A bila mbi wusi monina ko khombꞌaku kiadi, banga bobo minu ndimueniningi kiadi e ?” ");
INSERT INTO yom_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pfumu wufuema buwombo ayi wunyekula mu mioko mi batu bobo banyamisanga batu nate kela manisa futa pholoꞌandi yoso. ");
INSERT INTO yom_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Buawu bobo buela kuluvangila Dise diama didi ku Diyilu enati kadika mutu mu beno mengi lemvukila khombꞌandi mu ntima wukiedika. ");
INSERT INTO yom_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu bu kamanisa tuba mambu momo, wubotuka ku Ngalili, wuyenda mu bizunga bi Yuda ku disimu dinkaka di Yolidani. ");
INSERT INTO yom_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nkangu wu batu bawombo banlandakana ayi kuna kabelusila bambevo. ");
INSERT INTO yom_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bafalisi bayiza kuidi Yesu mu kumvukumuna ayi banyuvula : —Minsua midi kuidi bakala mu katula nketo andi va dikuela mu kioso-kioso bila e ? ");
INSERT INTO yom_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Wuba vutudila : —Lutengi ko ti vana thonono mvangi wuvanga bakala ayi nketo ");
INSERT INTO yom_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ayi wutuba : Diawu bakala kela bikila Dise diandi ayi ngudi andi mu bundana ayi nketoꞌandi ; buna bawu buadi bela kituka mutu wumosi e ? ");
INSERT INTO yom_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Buawu bobo basiedi diaka batu buadi ko vayi beka mutu wumosi. Diawu mutu kabika vambisa kibundisa Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bafalisi bankamba : —Vayi buna bila mbi Moyize kavanina minsua kuidi bakala mu vana nkanda luvambunu kuidi nketo ayi kunkuka va dikuela e ? ");
INSERT INTO yom_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu wuba vutudila : —Moyize wuluvana minsua mu vonda dikuela mu diambu di mintima mieno midi banga matadi. Vayi buawu ko bubela vana thonono. ");
INSERT INTO yom_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Vayi ndikulukamba : Woso mutu wumvambana ayi nketo andi, enati kasi vola kiphinga ko ayi kuedidi nketo wunkaka, buna luzaba ti bafueti kuntangila nkua kitsuza. ");
INSERT INTO yom_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Buna minlonguki minkamba : —Enati bobo bufueti kadila bakala va ntuala nketo, buna kadi kuandi mfunu mu kuela. ");
INSERT INTO yom_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu wuba vutudila : —Batu boso balendi kikinina mambu momo ko vayi kuidi bobo kaka bavanu diawu. ");
INSERT INTO yom_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bukiedika bankaka balendi kuela ko bila badi bavokolo tona mbutukulu awu ; bankaka bavokolo kuidi batu mu diambu babika kuela ayi bankaka bakivokolo bawu veka mu diambu di kipfumu ki Diyilu. Woso mutu wulenda kikinina mambu mama, bika kakikinina mawu. ");
INSERT INTO yom_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Banatina Yesu bana balezi muingi kaba tetika mioko ayi kaba sambidila. Vayi minlonguki mitemina batu bobo banata bana beni. ");
INSERT INTO yom_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Vayi Yesu wuba kamba : —Lubika bana balezi biza kuidi minu ; kadi kuba kandika bila kipfumu ki Diyilu kidi ki bobo baba dedikini. ");
INSERT INTO yom_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wuba tetika mioko ayi wuyenda kuandi. ");
INSERT INTO yom_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Buna mutu wumosi wufikama vaba Yesu ayi wunyuvula : —A Nlongi, diambu mbi dimboti phanga muingi ndibaka luzingu lu mvu ka mvu e ? ");
INSERT INTO yom_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu wumvutudila : —Bila mbi wukunguivudila mu diambu dimboti e ? Zaba ti wumosi kaka widi wumboti. Vayi enati tidi kota mu luzingu buna wufueti keba Mina. ");
INSERT INTO yom_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mutu beni wunyuvula : —A Mina mbi miomi e ? Yesu wuvutula : —Kadi vonda, kadi vanga kitsuza, kadi yiba, kadi telama kimbangi ki luvunu. ");
INSERT INTO yom_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kinzika dise diaku ayi ngudi aku ayi zola ndiaku banga bobo weta kukizodila ngeyo veka. ");
INSERT INTO yom_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ditoko beni dituba : —Ndieta keba Mina mioso miomi vayi mbi bikambulu diaka va minu e ? ");
INSERT INTO yom_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu wumvutudila : —Enati tidi ba mutu wufuana ; yenda mana sumbisa bima biobi bidi yaku bosi vana kuidi minsukami, buna ma wubaka kimvuama ku Diyilu, bosi yiza wundandakana ! ");
INSERT INTO yom_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ditoko buna kawa mambu mama, wuyenda mu kiadi, bila kimvuama kiwombo kiba yandi. ");
INSERT INTO yom_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bosi Yesu wukamba minlonguki miandi : —Bukiedika ndikulukamba ti didi diambu diphasi kuidi mutu widi kimvuama mu kota mu kipfumu ki Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ndikulukamba diaka ti kadi kuandi phasi kuidi kamela mu viokila va divudu di tsoma vayi bika kuidi mutu widi kimvuama mu kota mu kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Minlonguki misimina buwombo mu diambu di mambu momo, miyuvula : —A buna nani lenda vuka e ? ");
INSERT INTO yom_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu wuba sungimina bosi wutuba : —Kuidi batu malendi baka bu vangimina ko vayi kuidi Nzambi mamo malenda vangama. ");
INSERT INTO yom_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bosi Piela wunyuvula : —A beto tumana bika bima bioso mu diambu di kulandakananga, buevi buela bela mu diambu dieto e ? ");
INSERT INTO yom_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu wuba vutudila : —Bukiedika ndikulukamba ti thangu mambu moso mela kituka mamona ayi bu Muana Mutu kela vuanda va Kundu kiandi ki Kipfumu mu nkembo, beno lundandakana, luela vuanda va kumi bikundu biodi mu diambu di sambisa kumi makanda muadi ma Iseli. ");
INSERT INTO yom_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bosi woso mutu bikidi kani zinzo ziandi, kani bakhomba bandi zi babakala, bakhomba bandi zi baketo, kani Dise diandi, ngudi andi, bana bandi voti zitsola ziandi mu diambu diama wela baka bima biandi mu zikhama di zikhumbu ayi wela tambula luzingu lu kalumani. ");
INSERT INTO yom_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Vayi batu bawombo mu bobo badi buabu batheti bela ba batsuka ayi bobo badi buabu batsuka, bela ba batheti. ");
INSERT INTO yom_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kipfumu ki Diyilu kidedikini banga : —Pfumu yi ndima yitotuka mu nsuka-nsuka mu sonika bisadi bilenda sala mu ndimꞌandi yi vinu. ");
INSERT INTO yom_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wuwizana yawu mu denali kimosi mu lumbu kimosi ayi wuba fidisa ku ndimꞌandi yi vinu. ");
INSERT INTO yom_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wutotuka diaka mu thangu yi vua yi nsuka ; wumona batu bankaka, bakambulu mu kisalu, buna batelimini va zandu. ");
INSERT INTO yom_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wuba kamba : “Beno mamveno, yendanu lusala mu ndimꞌama yi vinu ayi mandi lufuta mfutu wufuana. Bawu mamvawu bayenda.” ");
INSERT INTO yom_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wutotuka diaka va midi bosi mu thangu yintatu yi masika. Bo buawu kavanga. ");
INSERT INTO yom_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mu thangu yintanu, mu masika, wutotuka ayi wumona diaka bankaka buna batelimini vana ayi wuba yuvula : “Bila mbi lutelimini vava lumbu kimvimba mu kambu sala kadi kima ?” ");
INSERT INTO yom_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bavutula : “Bila kadi mutu kasi tusonika ko mu kisalu !” Wubakamba : “Beno mamveno, yendanu sadi ku ndimꞌama.” ");
INSERT INTO yom_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Va masika pfumu yi ndima wukamba kapita kiandi : “Tela bisadi ayi wuba futa vayi tonina kuidi bobo baba batsuka mu sonama bosi wumanisina kuidi bobo baba batheti.” ");
INSERT INTO yom_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Batu bobo basonama thangu yi ntanu yi masika batambula denali kimosi-kimosi mu kadika mutu. ");
INSERT INTO yom_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bosi batu bobo baba batheti mu sonama bu bayiza, babanzila ti bawu banluta vayi denali kimosi-kimosi kadika mutu kafutu, ");
INSERT INTO yom_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Buna batambula kiawu, bafuemina pfumu yi ndima ");
INSERT INTO yom_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ayi bankamba : “Batu bobo sonikiningi kunzimunina, thangu yimosi kaka basadidi. Vayi wuba futidi phila yimosi ayi beto tusedi kisalu kingolo ayi ku tsi muini wungolo mu lumbu kimvimba.” ");
INSERT INTO yom_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pfumu yi ndima wuvutula kuidi kisadi kimosi mu bawu : “A nkundi ama, ndisi kuvangila mbimbi ko ! Tuisi wizananga yaku mu denali kimosi ko e ? ");
INSERT INTO yom_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bonga mfutu aku ayi yenda kuaku. Minu thidi vana kuidi mutu wowo wutsuka phila yimosi banga ngeyo. ");
INSERT INTO yom_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","A buevi ndisi ko minsua mu vanga dioso thidi mu zimbongo ziama e ? Voti kikhenene weka mona bu ndidi mutu wumboti.” ");
INSERT INTO yom_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Buawu bobo buela bela batu batsuka batu batheti ayi batu batheti batu batsuka. ");
INSERT INTO yom_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu bu kaba nkuenda ku Yelusalemi ; wubonga mu nzila kumi minlonguki miandi miodi va lutengo, wuba kamba : ");
INSERT INTO yom_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Lutala, tulembo yendi ku Yelusalemi, vayi kuna Muana Mutu kela yekodolo mu mioko mi bapfumu banganga Nzambi ayi kuidi Minlongi mi Mina. Bela kunzengila nkanu wu lufua ");
INSERT INTO yom_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ayi bela kunyekula mu mioko mi bapakanu muingi bansekinina, bambeta bikoti ayi bambanda va dikulusi. Bosi mu lumbu kintatu niandi wela fuluka. ");
INSERT INTO yom_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Buna ngudi yi bana ba Zebede wuyiza kuidi Yesu va kimosi ayi bana bandi ; wumfukimina ayi wunlomba diambu dimosi. ");
INSERT INTO yom_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu wuyuvula : —A mbi tidi e ? Niandi wuvutula : —Bika bana bama baba babuadi bababakala bavuanda wumosi ku lubakala luaku ayi wumosi ku lumoso luaku mu Kipfumu kiaku. ");
INSERT INTO yom_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu wuba kamba : —Beno lusi zaba ko momo lunlomba. Buna beno lulenda nua mbungu yoyi ndiela nua ? Bamvutudila : —Nyinga, tulenda kueto bu vanga ! ");
INSERT INTO yom_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu wuba kamba : —Bukiedika luela nua mbungu ama vayi mu diambu di vuanda va lubakala luama voti ku lumoso luama, diodi disi ko mu minsua miama bila bibuangu beni bidi mu diambu di batu bobo Dise diama kakubikila biawu. ");
INSERT INTO yom_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Thangu kumi di minlonguki minkaka miwa bobo, mifuemina bakhomba zina buadi. ");
INSERT INTO yom_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu wuba tumisa bawu boso, wuba kamba : —Luzebi ti bapfumu ba Bapakanu zieti kuba yadila mu kingolo ayi batu bawu banneni beti kuba monisanga lulendo luawu. ");
INSERT INTO yom_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Vayi buawu ko bulenda bela kuidi beno. Vayi woso mutu tidi ba wunneni mu beno bika kaba kisadi kieno. ");
INSERT INTO yom_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Woso tidi ba wutheti buna bika kaba mvika weno. ");
INSERT INTO yom_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bila Muana Mutu kasia kuiza ko muingi bansadila vayi wuyiza mu diambu di sadila batu ayi mu diambu di vana luzingu luandi mu diambu di kula batu bawombo. ");
INSERT INTO yom_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bu babika Yeliko, nkangu wu batu bawombo balandakana Yesu. ");
INSERT INTO yom_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Baphofo buadi bavuanda mu yenda nzila, bu ziwa ti Yesu wulembo vioki buna zieka nyamikina : —Pfumu ! Muana Davidi, wutumoni kiadi e ! ");
INSERT INTO yom_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nkangu wu batu wuba temina muingi zibika biyoko vayi ziluta buela yamikina ngolo : —Pfumu ! Muana Davidi, wutumona kiadi e ! ");
INSERT INTO yom_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu wutelama ; wuba tela ayi wuba yuvula : —A mbi lutidi ndiluvangila e ? ");
INSERT INTO yom_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Zimvutudila : —Pfumu ! Tutidi meso meto mazibuka ! ");
INSERT INTO yom_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu wuba mona kiadi, wusimba meso mawu. Muna ntangu beni yina kaka zitona mona ayi zinlandakana. ");
INSERT INTO yom_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mu thangu bafikama ku Yelusalemi, batula ku Betefange, buala buidi ku mongo minti mi olive, Yesu wutuma minlonguki miodi ayi ");
INSERT INTO yom_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","wuba kamba : —Yendanu ku buala bobo buidi ku ntualꞌeno. Buna ma lumona phunda yi nketo yikangama ayi muanꞌandi wu mbakala va ndambu ; luzinianguna ayi lundatina ziawu. ");
INSERT INTO yom_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Enati mutu wuluyuvudi, buna luvutula : “Pfumu wuzivuidi mfunu”. Buna wela kuzifidisa mu nsualu. ");
INSERT INTO yom_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mambu momo mavangama mu diambu di dedikisa mambu matuba mbikudi : ");
INSERT INTO yom_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Lukamba kuidi ndumba yi Sioni Tala Ntinuꞌaku wizidi kuidi ngeyo widi wulembama ; widi va yilu phunda yi nketo vuendi va mbata muana phunda, muana wu phunda yi nketo. ");
INSERT INTO yom_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Minlonguki miyenda, mivanga boso Yesu kaba kambila. ");
INSERT INTO yom_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Minata phunda yinketo ayi muana phunda, miyala minledi miawu va mbata ziphunda beni bosi Yesu wuvuanda vana. ");
INSERT INTO yom_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nkangu wu batu bawombo bayala minledi miawu mu nzila. Bankaka bazenga matafi ma minti ayi bayala mawu mu nzila. ");
INSERT INTO yom_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nkangu wu batu bobo baba ku ntuala ayi bobo baba ku mbusa, baba yamikinanga : Ozana kuidi Muana wu Davidi ! Bika kasakumunu mutu wowo wunkuizila mu dizina di Pfumu Ozana mu bibuangu bizangama ! ");
INSERT INTO yom_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bu kakota mu Yelusalemi, divula dioso dinikuka. Bayuvula : —Nani mutu wowo e ? ");
INSERT INTO yom_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nkangu wu batu wuvutula : —Yesu, mbikudi wu Nazaleti mu zunga ki Ngalili ! ");
INSERT INTO yom_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu wukota mu luphangu lu Nzo Nzambi, wukuka batu boso baba sumba bima. Wusengubula zimeza zi bobo baba sienzanga zimbongo ayi bikundu bi bobo baba nsumbisa mabembi. ");
INSERT INTO yom_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ayi wuba kamba : —Disonama ti Nzo ama yela tedolo Nzo yi lusambulu vayi beno lukitudi yawu suamunu ki mivi. ");
INSERT INTO yom_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Baphofo ayi bantiudikanga bayiza kuidi niandi muna luphangu lu Nzo Nzambi ayi wubabelusa. ");
INSERT INTO yom_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bapfumu zi banganga Nzambi ayi minlongi mi Mina mifuema ngolo bu bamona bikumu biobi bivanga Yesu ayi bu bamona bana baba yamikina mu khati luphangu lu nzo Nzambi ti : “Ozana, kuidi muana Davidi !” ");
INSERT INTO yom_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Diawu banyuvudila : —Wulembo wi kuaku mambu momo bana bobo balembo tubi e ? Yesu wuba vutudila : —Nyinga ! Vayi lutengi ko : Ngeyo wutambula Nzitusu aku mu miunu mi bana balezi ayi nate mu miunu mi bana batsombi ? ");
INSERT INTO yom_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bosi wubabika, wutotuka mu divula, wuyenda ku Betani kuawu kaleka. ");
INSERT INTO yom_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mu nsuka-nsuka bu kaba mvutuka ku divula, wumona nzala. ");
INSERT INTO yom_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bu kamona nti wumosi wu figi va ndambu nzila, wufikama vaba nti beni vayi meza na meza kaka kamona. Buna wukamba nti beni : —Wulendi buela butanga kadi dikundi dimosi ko ! Muna thangu beni nti wu figi wutumbu yuma. ");
INSERT INTO yom_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Minlonguki bu mimona bobo, misimina ayi miyuvula : —A buevi nti wowo wuvikidi yumina ? ");
INSERT INTO yom_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu wuba vutudila : —Bukiedika ndikulukamba enati minu kidi yeno ayi enati lulendi memata ko, bika sia ti lubeki kaka buvangila mambu maphengi mu nti wu figi wawu vayi lubeki bukambila kuidi mongo wowo : “Katuka vava, wukiloza mu mbu !” ayi mela vangama. ");
INSERT INTO yom_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mambu mamo malunlomba mu lusambulu, luela matambula enati luwilukidi. ");
INSERT INTO yom_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu wukota mu Nzo Nzambi. Mu thangu kaba nlonga, bapfumu banganga Nzambi ayi bakulutu ba batu bayiza fikama va kaba ayi banyuvula : —Mu lulendo mbi wulembo vangila mambu momo ? Ayi nani wuvana lulendo beni ? ");
INSERT INTO yom_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu wuba vutudila : —Thidi kuluyuvula mamvana kiuvu kimosi. Enati lupheni mvutu, buna bosi minu mamvama ndieka kulukamba mu lulendo mbi ndilembo vangila mambu mama. ");
INSERT INTO yom_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nani wuvana Yowani minsua mu botika, Nzambi voti batu ? Batona findana bawu na bawu ziphaka ayi batuba : —Beto kuiza kambi ti “Nzambi” buna maka tukamba ti “bila mbi lumanga kunwilukila ?” ");
INSERT INTO yom_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bosi beto kamba ti “Batu” boma tummona mu diambu di nkangu wu batu bila baboso bazebi ti Yowani widi mbikudi. ");
INSERT INTO yom_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Buna bavutudila Yesu : —Tusi zaba ko ! Niandi mamvandi wuba kamba : —Minu mamvama ndilendi kulukamba ko kani mu lulendo mbi ndilembo vangilanga mambu momo. ");
INSERT INTO yom_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Buevi lumbanza mu diambu diadi ? Mutu wumosi wuba ayi bana bandi buadi bababakala. Wuyiza kuidi wutheti ayi wunkamba : “A muanꞌama yenda sadi buabu ku ndima yi vinu !” ");
INSERT INTO yom_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Muana beni wumvutudila : “Mbengi kuama” Bosi kunzimunina, wubalula mayindu ayi wuyenda. ");
INSERT INTO yom_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dise diyenda kuidi muana wummuadi ayi mo mawu mambu kankamba. Niandi wuvutula “Nyinga Tata, ndinkuenda.” Vayi kasi kuenda ko. ");
INSERT INTO yom_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nani wuvanga luzolo lu Dise mu bana babuadi ? Bamvutudila : —Muana wutheti. Buna Yesu wuba kamba : —Bukiedika ndikulukamba mimfutisi mi ziphaku ayi bandumba leta bela kulutuaminina mu kota mu Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bila Yowani wuyiza mu kulumonisa nzila yi busonga vayi lumanga kunwilukila. Muaki mimfutisi mi ziphaku ayi bandumba leta banwilukila. Ka diambu ko lumona momo vayi lusia balula mavanga ko muingi ku nzimunina lunwilukila. ");
INSERT INTO yom_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Wanu nongo yinkaka : Mutu wumosi wuba ndimꞌandi yi vinu, wutungila yawu luphangu, wukaba dibulu dimosi mu kamuninanga mimbutu ma vinu. Wutunga nzo yi banga mu diambu di sunganga ndimꞌandi. Wuyekula ndima beni mu mioko mi bisadi bi ndima muingi bayifutilanga ; bosi wuyenda mu nzietolo. ");
INSERT INTO yom_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Thangu yi mvelongo mimbutu bu yifuana, wutuma bisadi biandi kuidi bisadi biobi kadefisa ndima beni muingi belandi ndambuꞌandi mimbutu. ");
INSERT INTO yom_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Vayi minkuni mi ndima yi vinu beni mibuila bisadi biandi : mibeta wumosi, mivonda wunkaka bosi milozila wuntatu matadi. ");
INSERT INTO yom_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pfumu yi ndima vinu beni wutuma bisadi binkaka ; lelo bawombo katuma viokila bobo katuama tuma va theti vayi mambu mo mawu bavangulu kuidi bobo kasia bikila ndima. ");
INSERT INTO yom_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bosi wuba fidisila muanꞌandi bu katuba ti : bela kinzika muanꞌama. ");
INSERT INTO yom_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Vayi minkuni buna mimona muana beni wulembo yizi, mikambasana ti : “Taleno mutu wowo wela vinginina kiuka, yizanu tumvonda muingi kiuka kikituka kieto.” ");
INSERT INTO yom_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mimbuila, minkoka ku nganda yi ndima ayi mimvonda. ");
INSERT INTO yom_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Buevi lumbanza, thangu pfumu yi ndima yi vinu bu kela vutuka, buevi kela vangila minkuni miomio ? ");
INSERT INTO yom_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bamvutudila : —Wela vonda, mu kambu kiadi batu bobo bambimbi. Bosi wela defisa ndima yi vinu beni kuidi minkuni minkaka miomi miela kumvananga mimbutu mu kadika thangu yeti velo mimbutu ! ");
INSERT INTO yom_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Bosi Yesu wuba kamba : —Kadi khumbu lutengi ko mu masonoko : Ditadi diodi diloza mintungi dikituka ditadi di mfunu, di fuma ki nzo. Pfumu niandi wuvanga buawu. Ayi didi diambu di tsiminanga mu meso meto ! ");
INSERT INTO yom_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Diawu ndikulukambila ti bela kuluziona Kipfumu ki Nzambi ayi bela vana kiawu kuidi batu bobo bela kibutila mimbutu. ");
INSERT INTO yom_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Vayi woso mutu wela bua va ditadi beni wela keluka mu bitini, vayi woso wela builu ditadi beni wela mana kosumuka. ");
INSERT INTO yom_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Buna bamana wa zinongo ziozi, bapfumu banganga Nzambi ayi Bafalisi babakula ti Yesu bawu kalembo yolukila. ");
INSERT INTO yom_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Batomba nzila yi kunkangila vayi nkangu wu batu baba mona boma bila batu bammona ti niandi widi mbikudi. ");
INSERT INTO yom_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu wuba yolukila diaka mu zinongo. Wuba kamba : ");
INSERT INTO yom_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Kipfumu ki Diyilu kidedikini banga ntinu wumosi wusadisa nyengo mu diambu di dikuela di muanꞌandi wubakala. ");
INSERT INTO yom_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wutuma bisadi biandi mu kuenda tedi batu bobo batumusu ku nyengo ; vayi batu beni bamanga kuawa kuiza. ");
INSERT INTO yom_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wubuela tuma diaka bisadi binkaka ayi wuba kamba : “Lukamba kuidi batu bobo batumusu ku nyengo ti mbeni kubika bidia ; phondisidi zingombi ziama ayi bibulu biama bi mafuta ; bima bioso bikubimini. Yizanu ku nyengo dikuela !” ");
INSERT INTO yom_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Vayi batu bobo batumusu bamona mambu beni maphamba, bosi kadika mutu wuyenda kuandi : Wumosi ku tsolꞌandi, wunkaka ku kita kayenda. ");
INSERT INTO yom_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bobo basiala ; bakanga bisadi biandi ; babayamisa ayi babavonda. ");
INSERT INTO yom_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Buna ntinu wufuema ngolo ayi wufidisa masodi mandi mu vonda mimvondi beni ayi muvika divula diawu. ");
INSERT INTO yom_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bosi wukamba bisadi biandi : “bidia bi nyengo wu dikuela bikubimini. Vayi batu batumusu basi bafuana ko. ");
INSERT INTO yom_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Diawu yendanu mu ziphambu zi zinzila, tumisanu batu boso lummona muingi biza ku nyengo wu dikuela.” ");
INSERT INTO yom_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bisadi biyenda mu zinzila ayi bakutikisa batu boso bobo bamona ; batu bamboti ayi bambimbi ayi nzo yi nyengo wu dikuela yiwala. ");
INSERT INTO yom_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ntinu bu kakota mu tala batu bobo baba mu nzo yi nyengo, wumona mutu wumosi wukambu vuata minledi mi nyengo wu dikuela. ");
INSERT INTO yom_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Buna wunyuvula : “A nkundi ama ! A buevi kotidi vava ngeyo kambulu vuata minledi mi nyengo wu dikuela ?” Vayi mutu beni kasia baka divutula ko. ");
INSERT INTO yom_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Buna ntinu wukamba bisadi biandi : “Lunkanga malu ayi mioko ; lunloza ku nganda kuidi tombi, kuna kuidi bidilu ayi nkuetosolo wu menu.” ");
INSERT INTO yom_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bila batumusu badi bawombo vayi bobo basobulu badi bafioti. ");
INSERT INTO yom_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Buna Bafalisi bayenda ayi bafindana ziphaka bawu na bawu mu tomba diluaku di buidila Yesu mu mambu momo kalenda tuba niandi veka. ");
INSERT INTO yom_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bamfidisila minlonguki miawu ayi batu ba dikabu di Elode. Batuba : —A Nlongi, tuzebi mboti ti ngeyo widi mutu wuntubanga kiedika, weta longa nzila yi Nzambi mu kiedika ayi wumonanga mutu boma ko bila wutalanga bizizi bi batu ko. ");
INSERT INTO yom_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wutukambi buabu kani buevi wumbanza mu diambu diadi : minsua midi mu futa phaku kuidi Sezali voti nana ? ");
INSERT INTO yom_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Vayi Yesu wuzaba mayindu mawu mambimbi ayi wutuba : —A bankua mayuya, bila mbi lukumfiedila e ? ");
INSERT INTO yom_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mbonisanu zimbongo ziozi lumfutilanga phaku ! Buna bannatina denali kimosi. ");
INSERT INTO yom_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bosi wuba yuvula : —Zizi kiaki kinani ayi bisono biabi bi nani e ? ");
INSERT INTO yom_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bavutula ti : —Bi Sezali. Buna Yesu wuba kamba : —Diawu luvana bi Sezali kuidi Sezali ayi bi Nzambi kuidi Nzambi ! ");
INSERT INTO yom_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Babo basimina buwombo bu bawa bobo ; bambika ayi bayenda kuawu. ");
INSERT INTO yom_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Muna lumbu beni kuandi, Basaduki, bobo beti tuba ti batu bafua balendi fuluka ko, bayiza kuidi Yesu ayi banyuvula : ");
INSERT INTO yom_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—A Nlongi, Moyize wukamba ti bakala dikuela bu kafuidi, enati kasi buta bana ko buna khombꞌandi kafueti vinginina nketo wowo kabikidi muingi kabutila khombꞌandi wufua bana. ");
INSERT INTO yom_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Vayi tuba ayi tsambuadi di bakhomba zi babakala. Muana wutheti wukuela nketo, wufua ayi kasia buta bana ko. Wubika nketoꞌandi kuidi khombꞌandi. ");
INSERT INTO yom_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Buawu bobo buvangimina kuidi khomba yoyo yimmuadi ayi yintatu nate kuidi yoyi yi tsambuadi. ");
INSERT INTO yom_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ku nzimunina nketo beni mamvandi wufua. ");
INSERT INTO yom_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","A buna mu lumbu ki mfulukulu nketo beni wela ba wunani mu bawu tsambuadi bila bawu boso bankuela e ? ");
INSERT INTO yom_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu wuba vutudila : —Lulembo kukivuni bila lusi zaba Masonoko ko ayi lusi zaba ko lulendo lu Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ku nzimunina yi mfulukulu. Batu balendi buela kuelana ko ayi kuedusu ko vayi bela ba banga zimbasi mu Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Vayi mu diambu di mfulukulu yi bafua, lutengi ko mambu ma lukamba Nzambi : ");
INSERT INTO yom_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Minu ndidi Nzambi yi Abalahami, yi Isaki ayi yi Yakobi e ? Nzambi kasi Nzambi yi batu bafua ko vayi Nzambi yi batu badi moyo. ");
INSERT INTO yom_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nkangu wu batu bu wuwa bobo basimina ngolo mu malongi mandi. ");
INSERT INTO yom_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bafalisi, bu bawa ti Yesu kangisidi miunu mi Basaduki, bakutakana va kimosi. ");
INSERT INTO yom_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Buna wumosi mu bawu wuba nlongi wu mina, wuyiza kumfiela. Buna wunyuvula : ");
INSERT INTO yom_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—A Nlongi ! A Muina mbi wulutidi mu Mina mioso e ? ");
INSERT INTO yom_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu wumvutudila : —Zola Pfumu Nzambi aku mu ntimꞌaku woso, mu muelꞌaku woso ayi mu mayindu maku mamo. ");
INSERT INTO yom_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wowo muina wulutidi ayi wawu wutheti. ");
INSERT INTO yom_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wummuadi wudedikini banga wowo wutheti wawu wawu : Zola ndiaku banga bu weta kukizodila ngeyo veka. ");
INSERT INTO yom_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mina mioso ayi malongi ma mimbikudi madi mu Mina miami miodi. ");
INSERT INTO yom_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bafalisi bu bakutakana va kimosi, buna Yesu wuba yuvula : ");
INSERT INTO yom_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Buevi lumbanzila mu diambu di Klisto ? Widi Muana nani e ? Bamvutudila : —Widi Muana wu Davidi ! ");
INSERT INTO yom_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Buna wuba kamba : —Buna buevi Davidi, mu lutumu lu Pheve, kantedila Pfumu e ? Bila niandi wutuba : ");
INSERT INTO yom_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Pfumu wukamba kuidi Pfumuꞌama : Vuanda va koko kuama ku lubakala nate mbeni tula bambeni ziaku ku tsi bitambi biaku. ");
INSERT INTO yom_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Diawu, enati Davidi wuntedila “Pfumu” buna buevi kafueti bela muanꞌandi e ? ");
INSERT INTO yom_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kadi mutu wumosi kasia nunga ko kumvutudila mvutu. Ayi tona lumbu beni, kadi mutu wumosi kasia buela nunga ko mu kunyuvula diaka biuvu. ");
INSERT INTO yom_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Buna Yesu wukamba nkangu wu batu ayi minlonguki miandi : ");
INSERT INTO yom_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Minlongi mi Mina ayi Bafalisi kisalu kiawu sudikisa batu Mina mi Moyize. ");
INSERT INTO yom_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Lutumukina ayi lukeba mambu moso bakulukamba. Vayi lubika landakana mavanga mawu bila mambu momo beti longa mawu ko beti sadila. ");
INSERT INTO yom_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bazebi kanga mimfuna midi zitu ayi beti tula miawu va mavangiti ma batu vayi bawu veka bamengi nikunina miawu mu tsongi nlembo. ");
INSERT INTO yom_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mambu moso bamvanga batidi ti batu baba mona. Diawu zikesi zi fioti-fioti ziozi beti vuata mu thangu lusambulu zilutidi ziozi zibankaka mu kula ayi zitsongi zi mazuela mawu zidi zi mula. ");
INSERT INTO yom_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Beti zola kaka vuandila mu bibuangu bi lukinzu mu minyengo ayi mu bikundu bitheti mu nzo zi zikhutukunu. ");
INSERT INTO yom_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Beti zola baba vaninanga mboti vama vadi batu bawombo ayi babatedilanga “Nlongi”. ");
INSERT INTO yom_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Vayi beno babika kulutedilanga “Nlongi” bila beno babo lubeki Nlongi wumosi kaka ayi beno boso luidi bakhomba. ");
INSERT INTO yom_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kadi mutu wumosi vava ntoto lulendi tedila ko : “Tata” bila Tata dimosi kaka didi yeno, diodi didi ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Lubika talanga batu balutedila : “Pfumu” bila Pfumu yimosi kaka yidi yeno : Klisto. ");
INSERT INTO yom_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mutu wowo lutidi munneni va khatitsikꞌeno wela ba kisadi kieno. ");
INSERT INTO yom_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Woso mutu wukukinangika wela kululu ayi woso mutu wukukikulula wela nanguku. ");
INSERT INTO yom_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","—A mabienga kuidi beno minlongi mi Mina ayi Bafalisi ! Luidi batu ba mayuya ! Bila lueti kandika batu ba kota mu Kipfumu ki Diyilu ayi beno veka lukotanga ko ! Ayi luvananga ko diluaku kuidi batu batidi kota bakota kuawu ! ");
INSERT INTO yom_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","O mabienga kuidi beno minlongi mi Mina ayi Bafalisi ! Luidi batu ba mayuya ! Bila lueti zionanga bima bi mafuola ayi lueti sambilanga zitsambulu zimula muingi lumonika. Diawu luela bakila thumbudulu yilutidi tola. ");
INSERT INTO yom_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","A mabienga kuidi beno minlongi mi Mina ayi Bafalisi ! Luidi batu ba mayuya. Lueti diengilanga mu mbu ayi mu ntoto mu diambu di tombanga kani lulenda baka, ka diambu ko nzenza wumosi wulenda kota mu dibundu dieno. Ayi enati lumbeki, lunkukitulanga muana wu bulungi mu zikhumbu zizole viokila beno veka. ");
INSERT INTO yom_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","A mabienga kuidi beno mintuadisi mifua meso. Beno lueti tuba ti enati mutu levidi ndefi mu “Nzo Nzambi”, diodi disi kuandi diambu ko. Vayi enati mutu levidi ndefi mu “nolo yidi mu Nzo Nzambi” buna kafueti dukisa ndefi andi. ");
INSERT INTO yom_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Luidi bivungisi ayi Baphofo ! A mbi bilutidi mfunu ? Nolo voti nzo Nzambi yoyi yinkitulanga nolo yinlongo ? ");
INSERT INTO yom_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Lueti tuba diaka : enati mutu levidi ndefi va “diziku dimyokolongo bibulu bitambuku kuidi Nzambi”, diodi disi kuandi diambu ko ; vayi enati levidi ndefi mu “dikaba diodi didi va diziku” buna kafueti dukisa ndefi andi. ");
INSERT INTO yom_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Baphofo ! Diambu mbi dilutidi mfunu, makaba voti diziku dinkitulanga dikaba dinlongo ? ");
INSERT INTO yom_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mutu wowo levidi ndefi mu “diziku”, buna levidi yawu mu diziku ayi mu bima bioso bidi vana. ");
INSERT INTO yom_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mutu wowo levidi ndefi “mu nzo Nzambi”, buna levidi yawu mu dizina di nzo Nzambi ayi mu mutu wowo wunkalanga muna. ");
INSERT INTO yom_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ayi mutu wowo levidi ndefi mu Diyilu, buna levidi yawu mu kundu ki Nzambi ayi mu mutu wowo wuvuandanga va kundu beni. ");
INSERT INTO yom_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","O mabienga kuidi beno minlongi mi Mina ayi Bafalisi ! Beno luidi batu ba mayuya. Bila ! Lueti vana Nzambi kuku kikumi mu bima biobi lueti kuna mu zitsola zieno banza mu bima biobi bifioti-fioti biobi lueti kuna. Vayi lusadilanga ko mambu malutidi pfumu mu Mina banga : vanganga masonga, monanga batu kiadi ayi vanganga makuikama. Nganu mawu momo mambu luvanga mu kambu lenza mamo mankaka. ");
INSERT INTO yom_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mintuadisi mifua meso ! Lueti sosanga biobi lueti nua muingi zinzinzi zifioti-fioti zibika vioka vayi lumminanga bulu kinneni kioki beti tedila kamela. ");
INSERT INTO yom_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","O mabienga kuidi beno minlongi mi Mina ayi beno Bafalisi ! Luidi batu ba mayuya ! Lunsukulanga va mbata kopo ayi va mbata dilonga vayi mu khati mu wala bima biobi lueti yiba ayi zitsatu zieno zimbimbi. ");
INSERT INTO yom_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bafalisi bafua meso ! Lutuama theti sukula mu khati kopo ayi mu khati dilonga, bosi buna mu mbata mamusukuka. ");
INSERT INTO yom_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","O mabienga kuidi beno minlongi mi Mina ayi Bafalisi ! Beno luidi batu ba mayuya ! Bila luidi banga biziami biobi bivindu nlangi yi phembi ayi ku nganda bimmonikanga kitoko vayi mu khati mu wala mimvesi mi batu bafua, mvindu ayi kheni yi phila mu phila. ");
INSERT INTO yom_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Beno mamveno, ku nganda lummonikanga basonga va meso ma batu vayi mu khati muwala mayuya ayi mambu mambimbi ma phila mu phila. ");
INSERT INTO yom_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","O mabienga kuidi beno minlongi mi Mina ayi Bafalisi ! Beno luidi batu mayuya ! Luntunganga biziami bi mimbikudi ayi lumfuanisanga bumboti biziami bi batu basonga, ");
INSERT INTO yom_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ayi lueti tubanga : “Enati beto tuzinga mu thangu bakulu beto nganu tusia bundana yawu ko mu vonda mimbikudi.” ");
INSERT INTO yom_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bu luntuba bobo lulembo telama beno veka kimbangi ti luidi bana ba batu bobo bavonda mimbikudi. ");
INSERT INTO yom_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Diawu manisanu kisalu kioki kitona bakulu beno. ");
INSERT INTO yom_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","A beno zinioka ! Bana ba bikusa ! A buevi lulenda tinina nkanu wu bulungi e ? ");
INSERT INTO yom_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ndiela lufidisila mimbikudi, batu badi nduenga ayi minlongi mi Mina. Luela vonda bankaka, luela bandisa bankaka va dikulusi vayi bankaka luela babeta bikoti mu zinzo zieno zi zikhutukunu, bosi luela kuba yamisa mu divula dimosi-dimosi ");
INSERT INTO yom_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","muingi menga, ma batu boso basonga, momo matenguka tona mu Abeli mutu wusonga nate mu Zakali muana Balaki ; mutu wowo luvonda va khatitsika Nzo Nzambi ayi diziku diodi banyokilanga Nzambi makaba, matangulu mu mintu mieno. ");
INSERT INTO yom_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Bukiedika ndikulukamba mambu moso mama mela buila batu ba tsungi yayi. ");
INSERT INTO yom_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","—A Yelusalemi ! A Yelusalemi e ! Ngeyo wumvondanga mimbikudi ayi wunlozilanga matadi batu bobo Nzambi kakufidisilanga. Zikhumbu zikua ndizola kutikisa bana baku banga tsusu bu kankutikisilanga bana bandi ku tsi mavavi mandi. Vayi wumanga kuaku. ");
INSERT INTO yom_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tala, nzoꞌaku yikuiza ba dio wuya, yikambu bima. ");
INSERT INTO yom_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Diawu, ndikulukambila : tona buabu lulendi buela kumbona ko nate thangu luela tuba : Bika kasakumunu mutu wowo wunkuizila mu dizina di Pfumu. ");
INSERT INTO yom_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu bu katotuka mu Nzo Nzambi, minlonguki miandi mifikama va kaba muingi mimmonisa phila yitungulu Nzo Nzambi beni. ");
INSERT INTO yom_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Buna wuba kamba : —Lummona mamoso mama e ? Bukiedika ndikulukamba ti kadi ditadi dimosi dilendi siala ko va mbata ditadi dinkaka, mamo mela tiolomono. ");
INSERT INTO yom_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Bu kavuanda va mongo minti mi Olive, minlonguki miandi miyiza miawu veka ayi minyuvula : —Wutukamba thangu mbi mambu beni mela vangimina ayi dimbu mbi kiela monisa phutukulu aku ayi tsukulu yi nza e ? ");
INSERT INTO yom_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu wuba vutudila : —Lukeba luedi vunu kuidi mutu ! ");
INSERT INTO yom_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bila bawombo bela kuizila mu dizina diama ayi bela tuba : “Minu ndidi Klisto !” ayi bela vuna bawombo. ");
INSERT INTO yom_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Luela wa zitsangu zi zimvita ayi biyoko bi zimvita vayi lubika ba boma-boma. Mambu beni mafueti vangama vayi yawu ko yela ba tsukulu yi nza. ");
INSERT INTO yom_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bila tsi yimosi yela nuanisa tsi yinkaka ayi batu ba kipfumu kimosi bela nuanisa batu ba kipfumu kinkaka. Nzala yela ba yiwombo, ntoto wela nikuka mu bibuangu biwombo. ");
INSERT INTO yom_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Vayi mambu moso mama mela ba thonono yi minsongo banga mi nketo weka buta. ");
INSERT INTO yom_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Buna bela kuluyekula mu diambu luyamusu ayi bela kuluvonda. Batu ba makanda moso bela kululenda mu diambu di dizina diama. ");
INSERT INTO yom_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mu thangu yina batu bawombo bela loza minu kiawu, bela kuki vakusa ayi bela lendasana bawu yi bawu. ");
INSERT INTO yom_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mimbikudi miwombo mi luvunu miela totuka ayi miela vuna batu bawombo. ");
INSERT INTO yom_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bila mambu mambimbi mela buelama, luzolo lu batu bawombo luela dekuka. ");
INSERT INTO yom_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Vayi woso wela kanga ntima nate kuna tsukulu wela vuka. ");
INSERT INTO yom_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Buna Nsamu wawu wumboti wu Kipfumu wela longo va nza yimvimba mu diambu di wuba kimbangi kuidi batu ba makanda ma zitsi zioso. Buna bosi tsukulu yi nza yela ba. ");
INSERT INTO yom_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—Diawu thangu luela mona mbungi wowo wuyolukila mbikudi Danieli, telimini va buangu kinlongo, mutu wowo wulembo tangi bika kasudika ");
INSERT INTO yom_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","buna boso batu bela batakana mu tsi Yuda batinina ku miongo. ");
INSERT INTO yom_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Woso mutu widi ku mbata muanzu, kabika kuluka mu diambu kabonga bima bidi mu nzoꞌandi. ");
INSERT INTO yom_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Woso mutu wela batakana mu tsola kabika buela vutuka ku manima mu bonga yunga kiandi. ");
INSERT INTO yom_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mabienga mela ba mu bilumbu bina kuidi baketo bela ba mu buemba ayi kuidi bobo bela yemika. ");
INSERT INTO yom_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lusambila muingi lumbu beni kioki luela tina kibika ba mu thangu kiozi kingolo voti mu lumbu ki saba. ");
INSERT INTO yom_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bila ziphasi beni ziela ba zingolo, nkutu ziphasi zina zibedi ko tona thonono nza nate buabu ayi ziphasi zi phila yina zilendi buela ba ko. ");
INSERT INTO yom_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Enati Pfumu kasia baka ko lukanu lu kufisa bilumbu beni, nganu kadi mutu wumosi kalendi vuka ko. Vayi wela kufisa biawu mu diambu di batu bobo kasobula. ");
INSERT INTO yom_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Enati mutu wulukembi : “Lutala ! Klisto widi vava”, voti “widi kuna”, lubika kunwilukila. ");
INSERT INTO yom_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bila Baklisto ba luvunu ayi mimbikudi mi luvunu miwombo miela totuka ayi bela vanga bidimbu binneni ayi bikumu bi tsisi muingi babaka bu vunina enati baka bubela, batu bobo Nzambi kasobula. ");
INSERT INTO yom_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tala, ndilulubudi. ");
INSERT INTO yom_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Enati mutu wulukembi ti : “Tala widi ku dikanga” lubika kuenda kuna. Voti : “Tala ! Widi mu bibuangu bisuama”, lubika wilukila ! ");
INSERT INTO yom_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bila ndizulu yi Muana Mutu yela ba banga bunkuizilanga lusiemo lueti tonina ku Esite nate ku Wesite. ");
INSERT INTO yom_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bila koso kuidi mvumbi kuawu ku nkutakananga bibala. ");
INSERT INTO yom_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ziphasi zi bilumbu beni bu ziela tumbu manisa, buna thangu yela tumbu nomba ngondi yela zimbisa miezi miandi, zimbuetete ziela doduka tona mu diyilu ayi lulendo lu diyilu luela nikuka. ");
INSERT INTO yom_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Buna dimbu ki Muana Mutu kiela monika mu Diyilu ayi batu ba makanda moso ma ntoto bela nionga ayi bela mona Muana Mutu wunkuizila mu matuti ma diyilu, mu lulendo ayi mu nkembo wunneni. ");
INSERT INTO yom_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Thangu tulumbeta yinneni yela siku, niandi wela tuma zimbasi ziandi. Ziawu ziela kutikisa batu bandi boso bobo kasobula mu zitsongi ziya zi nza, tona ku tonina nza nate ku sukisina nza. ");
INSERT INTO yom_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Bika lulonguka dilongi di nti wu figi : Enati matafi mandi meka malebila ayi enati matonini totula meza, buna luzebi ti thangu mvula yifikimini. ");
INSERT INTO yom_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Beno mamveno bobuawu, buna luela mona mambu moso momo buna luzaba ti Muana Mutu weka nduka kuiza, banga ti niandi weka va muelo. ");
INSERT INTO yom_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Bukiedika ndikulukamba ti tsungi yayi yilendi kiviokila ko tuamina mambu mama mavangama. ");
INSERT INTO yom_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Diyilu ayi ntoto biela vioka vayi mambu mama malendi vioka ko ! ");
INSERT INTO yom_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Vayi mu diambu di thangu voti lumbu kiela vangama mambu beni, kadi mutu wumosi kasi zaba ko ayi zimbasi zisi zaba ko, ka diambu ko Muana kasi zaba ko. Vayi Tata kaka zebi. ");
INSERT INTO yom_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mambu momo mavangama mu thangu Nowa mela buela vangama mu thangu Muana Mutu kela kuiza. ");
INSERT INTO yom_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bila tuamina khuka yi nlangu, batu badia ayi banua, bakuelana, bakuedisa nate mu lumbu kikota Nowa mu masuwa. ");
INSERT INTO yom_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Vayi basia zaba diambu dikubabuila ko nate khuka yi nlangu yiyiza ayi yimana vitumuna bawu boso. Bobo buela bela thangu Muana Mutu kela kuiza. ");
INSERT INTO yom_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Diawu babakala buadi bela ba mu tsola, wumosi wela bongo wunkaka wela siala. ");
INSERT INTO yom_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Baketo buadi bela nika zithete va ditadi, wumosi wela bongo wunkaka wela siala. ");
INSERT INTO yom_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Diawu diodi luzibula meso, bila lusia zaba ko lumbu kiela kuiza Pfumu eno. ");
INSERT INTO yom_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Luzebi mboti ti enati Pfumu yi nzo zebi thangu muivi kalenda kuizila va builu, nganu kalendi baka bu lekila ko muingi muivi kabika kota mu nzoꞌandi. ");
INSERT INTO yom_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Diawu beno mamveno, lukubama bila Muana Mutu wela kuiza mu thangu yi lukambulu bela mayindu. ");
INSERT INTO yom_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nani kisadi kikuikama ayi kidiela kioki Pfumu andi kabiekidi mu sunganga bisadi binkaka muingi kaba vananga bidia mu thangu yi fuana ? ");
INSERT INTO yom_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Khini yiwombo yela ba kuidi kisalu kioki enati Pfumu andi wiza kumbata wulembo sadi bumboti kisalu kioki bambiekila. ");
INSERT INTO yom_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Bukiedika ndikulukamba Pfumu andi wela kunyekudila katalanga bima biandi bioso. ");
INSERT INTO yom_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Vayi enati kidi kisadi kimbimbi, maka niunguta ti : “Pfumu ama kakadi vika kuiza !” ");
INSERT INTO yom_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ayi wukiyekudi mu yamisanga bisadi binkaka ayi mu dianga ayi nuanga va kimosi ayi bikolo-mbungu. ");
INSERT INTO yom_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bosi ti pfumu andi wizidi mu lumbu kioki kakambulu mayindu ; mu thangu yika kambulu zaba ");
INSERT INTO yom_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","buna Pfumu wela kunzenga mu bitini ayi wela kuntula mu ntanda wu batu ba mayuya. Kuna kuidi bidilu ayi nkuetoso wu meno. ");
INSERT INTO yom_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mu lumbu kina, Kipfumu ki Diyilu kiela dedakana banga kumi di bandumba bobo zisi zaba nitu yi babakala ko babonga minda miawu mu kuenda dengana ditoko di makuela. ");
INSERT INTO yom_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mu bawu mu ba bandumba zitanu ziba bivulu, zitanu ziba nduenga. ");
INSERT INTO yom_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bivulu bibonga minda miawu vayi basi nata mafuta ko. ");
INSERT INTO yom_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Vayi bobo baba nduenga babonga mintutu miawu mi mafuta ayi minda miawu. ");
INSERT INTO yom_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sumbu bakala di makuela kazingila mu kuiza, buna bawu boso baniungina ayi baleka tulu. ");
INSERT INTO yom_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Va midi mi phipa, mbembo yiyamikina : “Tala, ditoko di makuela wizidi ! Yenda lundengana.” ");
INSERT INTO yom_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Buna bandumba zioso zikotuka ayi zitona kubika minda miawu. ");
INSERT INTO yom_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Buna bandumba ziosi zi bivulu zikamba kuidi ziozi ziba nduenga : “Lutuvananu ndambu yi mafuta meno, bila minda mieto mieka nzima !” ");
INSERT INTO yom_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Vayi ziozi ziba nduenga ziba vutudila : “Yilendi fuana kuidi beto ayi beno ko. Mboti luenda sumbi mafuta meno veka kuidi bobo beti sumbisa mafuta.” ");
INSERT INTO yom_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Vayi bu bayenda ku sumba, ditoko di makuela diyiza. Bobo baba bakubama bakota yandi mu nzo yi nyengo ayi muelo wuzibama. ");
INSERT INTO yom_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ku nzimunina, bandumba bankaka bayiza, zituba : “Pfumu, Pfumu, wutuzibudila.” ");
INSERT INTO yom_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mfunu wuba vutudila : “Bukiedika ndikulukamba, ndisi ku luzaba ko.” ");
INSERT INTO yom_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Diawu luzibula meso bila lusi zaba ko lumbu ayi thangu. ");
INSERT INTO yom_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kiela dedakana banga mutu wumosi wukubama mu vanga nzietolo. Wutela bisadi biandi ayi wuba vana bima biandi. ");
INSERT INTO yom_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wuvana kuidi mutu wutheti bitalanta bitanu ; kuidi wunkaka bibiodi. Bosi kuidi wuntatu talanta kimosi. Wuvanina buawu kuidi kadika mutu boso bu kalenda sadila mu diela diandi. Buna mutu beni wuyenda kuandi. ");
INSERT INTO yom_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mutu wowo wutambula bitalanta bitanu wuyenda tumbu sadila biawu mukhita ayi wuyiza baka bitanu diaka va yilu. ");
INSERT INTO yom_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mutu wowo wutambula bitalanta biodi mamvandi wuvanga buawu ; bosi wuyiza baka bitalanta biodi diaka va yilu. ");
INSERT INTO yom_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Vayi mutu wowo wutambula talanta kimosi, wuyenda kaba dibulu mu tsi ntoto ayi wusueka zimbongo zi pfumuꞌandi. ");
INSERT INTO yom_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bilumbu biwombo bu bivioka, pfumu yi bisadi beni wuvutuka mu nzietolo andi ayi wuyuvula kadika mutu kamvumbudila kipholo mu phila yi kasadidi. ");
INSERT INTO yom_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mutu wowo wutambula bitalanta bitanu wuyiza ayi wumvana bitalanta bitanu binkaka. Wukamba pfumuꞌandi : “Pfumuꞌama ngeyo wuphana bitalanta bitanu, tala bitanu diaka ndibeki va yilu.” ");
INSERT INTO yom_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Pfumuꞌandi wuvutula : “widi kisadi kimboti ayi kikuikama. Ngeyo wubedi wukuikama mu bima bifioti. Diawu ndieka kuvana minsua mu bima biwombo. Yiza moni khini va kimosi ayi Pfumu aku.” ");
INSERT INTO yom_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mutu wowo wutambula bitalanta biodi wuyiza ayi wutuba : “Pfumu ngeyo wuphana bitalanta biodi, tala, bi biodi diaka ndibeki va mbata.” ");
INSERT INTO yom_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Pfumuꞌandi wunkamba : “widi kisadi kimboti ayi kikuikama. Ngeyo wubedi wukuikama mu bima bifioti. Diawu ndieka kuvana minsua mu bima biwombo. Yiza moni khini va kimosi ayi Pfumu aku.” ");
INSERT INTO yom_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Bosi mutu wowo wutambula talanta kimosi wuyiza ayi wutuba : “Pfumu, ndizaba ti ngeyo widi mutu wumosi wu phasi bila weti vela mimbutu mu biobi wusia kuna ko ayi wuntotanga bima biobi ka wusia kuna ko. ");
INSERT INTO yom_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ndimueni boma, diawu ndiyenda suekila talanta kiaku ku tsi ntoto. Tala, tambula talanta kiaku.” ");
INSERT INTO yom_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pfumuꞌandi wumvutudila : “widi kisadi kimbimbi ayi kibolo ! Zebi ti ndimvelanga mimbutu mu biobi ndisia kuna ko ayi ndintotanga bima biobi ndisia kuna. ");
INSERT INTO yom_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Vayi nganu wutula zimbongo ziama ku banki mu diambu mu lumbu ndiela vutuka ; nditambula zimbongo ziama ayi ndandu va yilu. ");
INSERT INTO yom_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Lunziona talanta kioki ayi luvana kiawu kuidi mutu wowo widi kumi di bitalanta.” ");
INSERT INTO yom_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bila bela buela vana kuidi woso mutu widi bima ayi wela baka biwombo. Vayi kuidi woso mutu kambulu bela kunziona ka diambu ko biobi bidi yandi. ");
INSERT INTO yom_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Luloza kisadi kikondolo mfunu ku nganda kuidi tombi, kuna kuidi bidilu ayi nkuetoso wu meno. ");
INSERT INTO yom_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","—Mu thangu Muana Mutu kela kuiza mu nkembo andi va kimosi ayi zimbasi zioso, wela vuanda va Kundu kiandi ki nkembo. ");
INSERT INTO yom_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Batu boso badi va ntoto bela kutakana va ntualꞌandi. Wela vasa batu banga bumvasilanga nsungi mamemi ayi zikhombo. ");
INSERT INTO yom_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wela tula mamemi ku koko kuandi ku lubakala bosi zikhombo ku koko kuandi ku lumoso. ");
INSERT INTO yom_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Buna Ntinu wela kamba kuidi bobo bela ba ku koko kuandi ku lubakala : “Beno lusakumunu kuidi Dise diama, yizanu ; tambulanu kiuka, Kipfumu kioki balukubikila tona vana va vangulu nza. ");
INSERT INTO yom_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bila bu ndiba nzala, luphana bidia ; bu ndiba phuila beno lunduikina, bu ndiba nzenza, luthambula, ");
INSERT INTO yom_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","bu ndikambu minledi mivuata, luphuika ; bu ndiba kimbevo, luyiza kuthala ; bu ndiba mu nloko, luyiza kuthala !” ");
INSERT INTO yom_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Vayi batu basonga bela kumvutudila : “A Pfumu ! Thangu mbi tumona wumfua nzala vayi tuvana bidia e ? Thangu mbi tumuena wuba phuila vayi tunuikina e ? ");
INSERT INTO yom_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","A thangu mbi wubela nzenza vayi beto tutambula e ? Voti thangu wukambulu minledi ayi beto tuvuika e ? ");
INSERT INTO yom_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","A thangu mbi wubela kimbevo voti mu nloko buna beto tuyiza kutala e ?” ");
INSERT INTO yom_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Vayi ntinu wela kuba vutudila : “Bukiedika ndikulukamba : yoso khumbu luvanga bobo, kuidi bakhomba ziama ziazi zikambulu mfunu, buna kuidi minu kuandi luvangidi buawu.” ");
INSERT INTO yom_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Bosi wela tuba kuidi bobo bela ba ku koko kuandi ku lumoso, “Botukanu va meso mama, luidi batu basingu ; yendanu ku mbazu yoyo ka yizimanga ko, yoyo yikubuku mu diambu di Satana ayi zimbasi ziandi. ");
INSERT INTO yom_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bila bu ndiba nzala, lusia kuphana bidia ko ; bu ndiba phuila lusia kunduikina ko ; ");
INSERT INTO yom_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","bu ndiba nzenza, lusia kuthambula ko ; bu ndikambu minledi lusia kuphuika ko ; bu ndiba kimbevo ayi ndiba mu nloko lusia kuiza kuthala ko !” ");
INSERT INTO yom_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Buna bawu bela kumvutudila : “A Pfumu ! A thangu mbi tumona ti wumfua nzala voti phuila, voti wuba nzenza, wukambu minledi, wuba kimbevo voti mu nloko vayi tumanga kusadisa ?” ");
INSERT INTO yom_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Vayi niandi wela kuba vutudila : “Yoso khumbu lusia buvanga ko kuidi batu baba bakambulu mfunu buna kuidi minu kuandi luvangila buawu.” ");
INSERT INTO yom_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Buna bela kuenda ku thumbudulu yoyi kayilendi suka ko vayi batu basonga ku luzingu lukalumani. ");
INSERT INTO yom_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu bu kamana tuba mambu mama, wukamba minlonguki miandi : ");
INSERT INTO yom_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Luzebi ti bilumbu biodi bisiedi muingi nyengo Pasika wutona ; buna bosi Muana Mutu wela yekolo mu vondo va dikulusi ! ");
INSERT INTO yom_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Buna bapfumu banganga Nzambi ayi bakulutu ba batu bakutakana ku nzo Kayife, pfumu yi banganga Nzambi ; ");
INSERT INTO yom_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","bawizana buevi bafueti kangila Yesu mu luvunu muingi bamvonda. ");
INSERT INTO yom_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Vayi batuba : —Tubika vanga buawu mu thangu yi nyengo muingi khindu yibika bua mu batu. ");
INSERT INTO yom_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu bu kaba ku Betani ku nzo Simoni, mutu wowo wuba kimbevo ki buazi, ");
INSERT INTO yom_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nketo wumosi wuyiza ayi bungu ki malasi ma thalu, wudukula mawu ku ntu wu Yesu mu thangu kaba va meza. ");
INSERT INTO yom_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Vayi minlonguki mifuema bu mimona bobo ayi mituba : —Bila mbi mbebosolo yi phila yoyo e ? ");
INSERT INTO yom_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nganu mboti mu sumbisa malasi beni mu thalu yiwombo ayi vana zimbongo beni kuidi minsukami. ");
INSERT INTO yom_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu bu kazaba mayindu mawu, wuba kamba : —A mbi lulembo monisina nketo wawu phasi e ? Diambu kaphangidi didi diambu dimboti. ");
INSERT INTO yom_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Minsukami mikala kuandi yeno mu zithangu zioso, vayi minu ndisi kuiza kalanga yeno ko. ");
INSERT INTO yom_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Enati nketo wawu wundukudidi malasi mama mu nituꞌama, didi mu diambu di kubika nzikuluꞌama. ");
INSERT INTO yom_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Bukiedika ndikulukamba ti muamo muela longo Nsamu Wumboti wawu va nza yimvimba, diambu divengi nketo wawu diela yolokolongo mu kuntebukilanga moyo. ");
INSERT INTO yom_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bosi wumosi mu kumi mimvuala miandi miodi, dizina diandi Yuda Isikalioti, wuyenda kuidi bapfumu zi zinganga Nzambi, ");
INSERT INTO yom_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","wuba yuvula : —Mbi lulenda kuphana enati ndilusumbisidi Yesu e ? Buna bantangila makumatatu ma bivanzi. ");
INSERT INTO yom_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tona muna thangu beni Yuda wutomba diluaku di kuba yekudila Yesu. ");
INSERT INTO yom_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mu lumbu kitheti ki nyengo wu mapha makambu tulu luvi minlonguki miyiza kuidi Yesu ayi minyuvula : —A kuevi tidi tuenda kubikila ndiwulu yi Pasika e ? ");
INSERT INTO yom_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wuba vutudila : —Yendanu ku divula kuidi kingandi, buna lunkamba : “Nlongi kakembi : thanguꞌama yifikimini, ku nzoꞌaku ndindila Pasika ayi minlonguki miama.” ");
INSERT INTO yom_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Minlonguki mivanga phila yi kambila Yesu. Mikubika Pasika. ");
INSERT INTO yom_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mu thangu masika, Yesu wuvuanda va meza ayi kumi mimvuala miandi miodi. ");
INSERT INTO yom_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mu thangu baba ndia, Yesu wuba kamba : —Bukiedika ndikulukamba : buna luididi vava mutu wumosi mu beno maka phakusa ! ");
INSERT INTO yom_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Baboso beka mona kiadi, wumosi-wumosi weka kunyuvula : —Pfumu, buna minu e ? ");
INSERT INTO yom_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu wuba vutudila : —Mutu wowo wumbuika koko kuandi va kimosi ayi minu mu dilonga buna niandi wukuphakusa. ");
INSERT INTO yom_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Bila Muana Mutu wulembo yendi banga busonimina mu Masonoko mu diambu diandi. Vayi nga mabienga kuidi mutu wowo wumvakusa ! Nganu bufueni kuidi mutu beni mu kambu kuandi butuka ! ");
INSERT INTO yom_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, mutu wowo wukumvakusa, wuyuvula : —A Nlongi ! Bati minu e ! Bosi Yesu wumvutudila : —Nyinga, ngeyo tubidi buawu. ");
INSERT INTO yom_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Thangu baba ndia, Yesu wubonga dipha, wuvutula matondo, wudibukuna bosi wuvana minlonguki miandi, wuba kamba : —Bonganu ludia, bila yayi yawu nituꞌama ! ");
INSERT INTO yom_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bosi wubonga mbungu, wuvutula matondo, wuba vana ayi wutuba : —Bika lunuanu beno boso ");
INSERT INTO yom_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","bila mama mawu menga mama ma Nguizani madukulu mu diambu di ndemvokolo yi masumu ma batu bawombo. ");
INSERT INTO yom_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Vayi ndikulukamba, kadi khumbu ndiela buela nua vinu tona buabu nate lumbu kioki ndiela nua vinu kimona va kimosi ayi beno mu Kipfumu ki Dise diama. ");
INSERT INTO yom_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Buna bayimbila nkunga. Bosi bayenda ku mongo minti mi olive. ");
INSERT INTO yom_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Buna Yesu wuba kamba ti : —Va builu buabu beno boso ma lumana zimbisa minu mu diambu diama. Bila disonama : Ndiela vonda nsungi mamemi, mamemi ma nkangu mela mana tiakana. ");
INSERT INTO yom_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Vayi bu ndiela fuluka, ndiela kulutuamina ku Ngalili ! ");
INSERT INTO yom_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piela wunkamba : —A Pfumu ! Ka diambu ko baboso bela zimbisa minu mu diambu diaku, vayi minu ndilendi ko ! ");
INSERT INTO yom_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu wuvutula : —Tala, bukiedika ndikukamba : buabu kuandi va builu, simbu tsusu yikokula, buna zikhumbu zitatu si wuthunukina. ");
INSERT INTO yom_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piela wunkamba : —Ka diambu ko fua ndifua yaku vayi ndilendi kutunuka ko ! Minlonguki mioso phila yimosi mitubila. ");
INSERT INTO yom_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu wuyenda ayi minlonguki miandi ku buangu bantedilanga Ngetesemani. Wuba kamba : —Lukala vava, minu bu ndiedi ku sambila kuna ! ");
INSERT INTO yom_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wunata Piela ayi bana buadi ba Zebede. Wutona mona kiadi ayi ntima phasi. ");
INSERT INTO yom_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Bosi wuba kamba : —Muelꞌama weka kiaki nate nduka mu fua. Lusiala vava vayi luleka nkielo va kimosi ayi minu. ");
INSERT INTO yom_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Niandi wuyenda thama fioti, wufukama ayi wusambila. —A Dise diama ! Enati baka bubela, bika kopo yayi yithatukila. Vayi bika bobo nzodidi vayi bobo ngeyo zodidi. ");
INSERT INTO yom_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Bu kavutuka vaba minlonguki, wuyiza babata balembo leki tulu. Buna wukamba Piela : —Buna lulendi nunga mu sambila yama va kimosi banza mu thangu yimosi ko e ? ");
INSERT INTO yom_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Luleka nkielo ayi lusambila muingi luedi bua mu phukumunu. Bila pheve yidi ayi luzolo lu mboti vayi nitu yidi yilebakana. ");
INSERT INTO yom_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wuyenda diaka mu khumbu yinzole ayi wusambila : —A Dise diama ! Enati kadi baka bubela ti kopo yayi yithatukila, vayi enati mfueti kuyinua buna bika luzolo luaku luvangama ! ");
INSERT INTO yom_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Bu kavutuka diaka ; wuyiza buela bata buna balekidi, bila meso matulu maba yawu. ");
INSERT INTO yom_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Buna wusia babika ayi wuyenda sambila mu khumbu yintatu, ayi mambu mo mawu katuba. ");
INSERT INTO yom_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bu kavutuka vaba minlonguki ; buna wuba kamba : —Lukidi leki ayi lulembo vundi e ? Thangu yifikimini ayi Muana Mutu yekolo mu mioko mi bankua masumu. ");
INSERT INTO yom_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Telamanu, tuendanu Tala mutu wowo wukuphakula fikimini. ");
INSERT INTO yom_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Buna kamanisini ko yoluka, tala Yuda, wumosi mu kumi mimvuala miodi, wuyiza va kimosi ayi nkangu wu batu banata bisabala ayi zimbondo zi minti, batumu kuidi bapfumu zinganga Nzambi ayi kuidi bakulutu ba Bayuda. ");
INSERT INTO yom_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mutu wowo wuvakula Yesu, wuba vana dimbu kiaki : —Woso mutu ndikuiza fifi besi, buna niandi lufueti kanga. ");
INSERT INTO yom_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Buna niandi wufikama vaba Yesu ayi wutuba : —Mboti nlongi. Bosi wumfifa besi. ");
INSERT INTO yom_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu wunkamba : —A nkundi ama ! Vanga diwizidi ! Bosi bankaka bafikama, babuila Yesu ayi bankanga. ");
INSERT INTO yom_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Vayi mutu wumosi mu bobo baba ayi Yesu wunonuna koko kuandi, wutotula sabala kiandi, wuzuba kisadi ki Pfumu yi banganga Nzambi ayi wunzenga dikutu. ");
INSERT INTO yom_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Vayi Yesu wunkamba : —Vutula sabala kiaku va buangu kiandi bila batu bantotulanga sabala, mu sabala bela vondolo. ");
INSERT INTO yom_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ngeyo wumbanza ti ndilendi lomba kuidi Dise diama ayi vana vawu niandi kalendi ko kumfidisila zimbasi viokila kumi ayi lengio biodi ko e ? ");
INSERT INTO yom_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Vayi buna buevi bulenda dedikinina mambu masonama mu Minkanda meti tuba ti buawu bobo mambu beni mafueti vangimina e ? ");
INSERT INTO yom_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Muna thangu yina Yesu wutuba kuidi nkangu wu batu : —Ndieka dovula muingi luiza khangi ayi zimbedi ayi zimbondo zi minti mu mioko ? Keti bilumbu bioso ndibedi longanga mu Nzo Nzambi vayi lusi kukhanga ko. ");
INSERT INTO yom_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Vayi mambu moso mama mavangimini mu diambu di dedikisa masonoko ma mimbikudi. ");
INSERT INTO yom_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Batu bobo bakanga Yesu, bannata kuidi Kayife, pfumu banganga Nzambi. Kuna ku kutakana minlongi mi Mina ayi bakulutu ba batu. ");
INSERT INTO yom_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Vayi Piela wunlandakana kuna manina nate ku luphangu lu pfumu banganga Nzambi, wukota ku khati luphangu ayi wuvuanda va kimosi ayi minsungi mu diambu kamona kani buevi bukuiza manisina mambu beni. ");
INSERT INTO yom_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bapfumu banganga Nzambi ayi batu boso ba lukutukunu lu minyadi batomba kimbangi ki luvunu mu diambu di Yesu muingi babaka bila ki kumvondisila. ");
INSERT INTO yom_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ka diambu ko bambangi ba luvunu bawombo bayiza, vayi zisia kumbaka bila ko. Ku nzimunina kuyiza batu buadi, ");
INSERT INTO yom_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bakamba : —Mutu wawu niandi wukamba ti : “Minu ndenda tiolumuna Nzo Nzambi ayi kuyitungila mu bilumbu bitatu !” ");
INSERT INTO yom_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Buna Pfumu yi banganga Nzambi wutelama, wuyuvula Yesu : —Kadi diambu wukadi vutula e ? Kimbangi mbi kioki batu baba balembo kutelimina e ? ");
INSERT INTO yom_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesu kasia vutula kadi diambu ko. Pfumu banganga Nzambi wunkamba : —Ndikulomba mu dizina di Nzambi yi moyo, wutukambi ti ngeyo klisto, Muana Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu wumvutudila : —Nyinga ! Banga kuandi butubidi. Buela diaka ndikulukamba : tona buabu luela mona Muana Mutu vuendi va koko ku lubakala lu mutu wowo lutidi lulendo ayi wunkuizila va matuti ma diyilu. ");
INSERT INTO yom_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Buna Pfumu banganga Nzambi wukanzuna minledi ayi wukamba : —vuezidi Nzambi ! Bila mbi tufueti buela tombila diaka bambangi ? Luwilu beno veka phila kavuezidi Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Beno buevi lumbanzila e ? Bavutula : —Fueni kuandi mu vondo ! ");
INSERT INTO yom_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mbadi banlobudila madita ku busu ayi banzuba zikhomi. Bankaka banzuba zimbata ayi bankamba : ");
INSERT INTO yom_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—A Klisto, wutubikudila ayi wutukambi nani wubetidi e ? ");
INSERT INTO yom_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piela wuba wuvuanda ku nganda, mu khati luphangu, kisadi kimosi ki nketo kiyiza ayi kinkamba : —Mamvaku bedingi ayi Yesu, muisi Ngalili ! ");
INSERT INTO yom_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Vayi Piela wutunuka kuandi va meso ma batu boso : —Ndisi zaba ko mambu momo wuntuba ! ");
INSERT INTO yom_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bu kaba kuenda ku ndambu muelo wu luphangu, kuna nketo wunkaka wummona ayi wukamba batu bobo baba vana : —E e beno, lutala mutu wowo bedingi ayi Yesu muisi Nazaleti ! ");
INSERT INTO yom_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piela wubuela tunuka diaka ayi wuleva ndefi ti : —Bukiedika ndisi zaba ko mutu wowo ! ");
INSERT INTO yom_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Buela kala fioti batu bobo baba vana bayiza vaba Piela ayi bankamba : —Bukiedika ti ngeyo widi wumosi mu batu bobo bila thubulu aku yilembo fundi. ");
INSERT INTO yom_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piela wutona leva ndefi ayi wu kitombila tsingulu : —Ndisi zaba ko mutu wowo ! Muna thangu beni tsusu yikokudi. ");
INSERT INTO yom_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Buna Piela wutebukila mambu momo Yesu kakamba ti : “Simbu tsusu yinkokula, buna ngeyo si wuthunukina mu zikhumbu zitatu.” Buna wutotuka ku nganda ayi wudila buwombo. ");
INSERT INTO yom_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Buna buisi bukia, bapfumu zioso zi banganga Nzambi ayi bakulutu ba Bayuda bakutakana ayi bawizana mu tomba diluaku di bamvondila Yesu. ");
INSERT INTO yom_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bankanga minsinga, bannata ayi banyekula mu mioko mi nyadi Pilatu. ");
INSERT INTO yom_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuda, mutu wuyekula Yesu bu kamona ti bazengila Yesu nkanu wu lufua, wumona phasi mu ntima ; diawu wuyenda vutula makumatatu ma zimbongo zi bisengo kuidi bapfumu banganga Nzambi ayi kuidi bakulutu ba Bayuda. ");
INSERT INTO yom_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mbadi wuba kamba : —Mbeni vola masumu bila ndiekudi mutu wukambu vanga kadi kiasa. Bawu bamvutudila : —Momo masi tutala ko ! Matedi kuaku ! ");
INSERT INTO yom_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Buna wusia loza zimbongo beni vana tsi, muna Nzo Nzambi, wubotuka ayi wuyenda kidengidika. ");
INSERT INTO yom_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bapfumu banganga Nzambi zitota zimbongo beni ayi zituba ti : —Tuisi ko minsua mu tula zimbongo ziphila yayi mu kesi yi makaba ma Nzo Nzambi bila ziawu zidi zimbongo zi menga. ");
INSERT INTO yom_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Buna bamana wizana, basumba tsola mu zimbongo beni muingi bazikilanga banzenza. Tsola beni yiba yi mutu wumosi wuba bumbanga zinzungu zituma. ");
INSERT INTO yom_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Diawu nate buabu tsola beni yintedolongo : “Tsola yi menga”. ");
INSERT INTO yom_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Buawu bobo budedikinina mambu mabikula mbikudi Yelemi ti : Babonga makumatatu ma zimbongo zi bisengo, yawu thalu yizenga bana ba Iseli mu diambu diandi ");
INSERT INTO yom_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ayi ziawu basumbila tsola yi mutu wumbumbanga zinzungu zituma banga bobo Pfumu kathumina. ");
INSERT INTO yom_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Buna Yesu wutelama va ntuala nyadi, ayi niandi wunyuvula : —Ngeyo widi ntinu Bayuda e ? Yesu wumvutudila : —Nyinga ! Yidi banga bu tubidi. ");
INSERT INTO yom_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Vayi thangu bapfumu banganga Nzambi ayi bakulutu ba Bayuda bu bayiza kumfunda, niandi kasia vutula kadi diambu ko. ");
INSERT INTO yom_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatu wunyuvula : —Wulembo wi kuaku mambu momo balembo kufundila e ? ");
INSERT INTO yom_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Vayi Yesu kadi diambu dimosi kasia vutula ko. Diawu nyadi kasiminina buwombo. ");
INSERT INTO yom_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kifu kiba yawu, mu thangu nyengo, nyadi, wuba totulanga mutu wumosi wunloko, wowo wuba nlombongo kuidi batu. ");
INSERT INTO yom_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Vayi mu thangu yina, mutu wumosi wuyenda tsangu, wuba mu nloko dizina diandi Balabasi. ");
INSERT INTO yom_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nkangu bu wukutakana, Pilatu wuba yuvula : —A nani lutidi ndiluyekudila, Balabasi voti Yesu wuba ntedilanga Klisto e ? ");
INSERT INTO yom_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bila wuzaba kuandi ti mu diambu di kikhenene banyekudila Yesu. ");
INSERT INTO yom_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mu thangu Pilatu kavuanda va kundu ki kizuzi ku tilibinadu, nketoꞌandi wumfidisila thumu yayi : —Kadi kota mambu ma mutu wowo wu busonga bila mu builu buabu phasi mbueni, mu ndozi, mu diambu diandi ! ");
INSERT INTO yom_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Vayi bapfumu banganga Nzambi ayi bakulutu ba Bayuda beka sindisila nkangu wu batu muingi batuba ti bayekula Balabasi vayi bavonda Yesu. ");
INSERT INTO yom_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Buna nyadi wuba yuvula diaka : —A nani lutidi ndiluyekudila muna badi bawu buadi e ? Batuba : —Balabasi ! ");
INSERT INTO yom_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatu wuba yuvula : —A vayi mbi phangila Yesu, wubeti tedilanga Klisto e ? Bawu boso bavutula : —Wumbanda va dikulusi ! ");
INSERT INTO yom_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatu wuyuvula : —Diambu mbi dimbimbi kavengi e ? Vayi baluta yamikina ngolu : —Wumbanda va dikulusi ! ");
INSERT INTO yom_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatu bu kamona ti kalendi buela vanga kadi diambu dimosi ko ayi divunzi ditona, wubonga nlangu ; wusukula mioko va ntuala batu boso ayi wukamba : —Ndisi ko bila mu menga ma mutu wawu. Vayi beno veka matedi ! ");
INSERT INTO yom_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Batu boso bavutula : —Bika menga mandi mabua va beto ayi va bana beto ! ");
INSERT INTO yom_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilatu wubayekudila Balabasi. Bu kamana betisa Yesu bikoti, wunyekula mu mioko miawu muingi bambanda va dikulusi. ");
INSERT INTO yom_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Masodi ma nyadi makotisa Yesu ku khati nzo ayi makutikisa dikabu di masodi mu kunzungidila. ");
INSERT INTO yom_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bamvula minledi miandi ayi bamvuika yunga ki mbuaki. ");
INSERT INTO yom_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bavanga budu ki kipfumu ki zitsendi, bamvuika kiawu ku ntu ; bansimbisa nti va koko kuandi ku lubakala, bamfukimina, bansekinina ayi batuba : —Mboti e, Ntinu wu Bayuda ! ");
INSERT INTO yom_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Banlobudila madita bosi babonga nti, wawu baba kunzubanga ku ntu. ");
INSERT INTO yom_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Buna bamanisa kunsekinina, bamvula yunga beni ; bamvuika minledi miandi bosi bannata muingi bambanda va dikulusi. ");
INSERT INTO yom_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bu baba totuka, badengana mutu wumosi mu nzila, dizina diandi Simoni wuba muisi Silene, bankuika kanata dikulusi. ");
INSERT INTO yom_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Batula ku buangu kimosi baba ntedilanga ngolongota. Tsundu Ngolongota : “Buangu ki mvesi wu ntu”, ");
INSERT INTO yom_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","kuna bamvanina vinu kisobakana ayi kiti ki ndudi muingi kanua. Buna kabimba, wumanga ku kinua. ");
INSERT INTO yom_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Buna bamana ku mbanda va dikulusi, babula tsombo mu diambu di kabana minledi miandi. ");
INSERT INTO yom_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mbadi bavuanda kuna mu kunsunga. ");
INSERT INTO yom_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Batula muna dikulusi tini ki dibaya vana mbata ntuꞌandi, musonama bila kioki banzengila nkanu : “Niandi niawu Yesu, ntinu wu Bayuda”. ");
INSERT INTO yom_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bidovula biodi bibandu va dikulusi va kimosi ayi Yesu, wumosi ku koko ku lubakala, wunkaka ku koko ku lumoso. ");
INSERT INTO yom_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Batu bobo baba mviokila vana, baba kumfinga, baba nikunanga mintu ");
INSERT INTO yom_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ayi baba nyoluka : —E ! Ngeyo mutu wuntiolumunanga Nzo Nzambi ayi kuyitungila diaka mu bilumbu bitatu ; wukivukisa ngeyo veka. Enati widi Muana Nzambi, kuluka va Dikulusi ! ");
INSERT INTO yom_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bapfumu banganga Nzambi, minlongi mi Mina ayi bakulutu ba Bayuda mamvawu bansekinina ayi bakamba : ");
INSERT INTO yom_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—A ! Niandi wuvukisidi batu bankaka vayi niandi veka kalendi kukivukisa ko e ! Enati niandi widi ntinu Iseli, kakulumuka va dikulusi muingi tunkikinina. ");
INSERT INTO yom_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Niandi diana diandi didi mu Nzambi, bika kamvukisa buabu enati weta kunzola ; bila niandi wuba ntubanga : “Ndidi Muana Nzambi.” ");
INSERT INTO yom_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bidovula biobi bibandu yandi va kimosi va dikulusi mamvawu bobo baba kumfingila. ");
INSERT INTO yom_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tona thangu midi nate thangu yintatu mu masika, ntoto wumvimba wuba mu tombi kinkobo. ");
INSERT INTO yom_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nduka-nduka mu thangu yintatu Yesu wuyamikina mu ndinga yingolo : —Eli, Eli, Lama sabakatani e ? Bu dinsundula : Nzambi ama ! Nzambi ama ! Bila mbi wundiekudidi e ? ");
INSERT INTO yom_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Batu bankaka, bobo batelama vana bu bawa bobo, batuba : —Eli kantela. ");
INSERT INTO yom_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wumosi mu bawu, wuzawula, wuyenda bonga eponzi, wukifulusa mu vnu kidi ngami ; wukisomika va tsongi nti bosi wumvana muingi kanua. ");
INSERT INTO yom_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Vayi bankaka bakamba : —Bika tutala kani Eli weka kuiza mvukisa. ");
INSERT INTO yom_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu wubuela yamikina diaka mu ndinga yingolo ; buna wuzenga vumunu. ");
INSERT INTO yom_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Muna thangu beni kaka lido yi Nzo Nzambi yikanzuka mu ndambu zizole tona kuna yilu nate ku tsi. Ntoto wunikuka, matadi mabasuka, ");
INSERT INTO yom_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","biziami bizibuka, batu banlongo bawombo bafua bafuluka. ");
INSERT INTO yom_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Batotuka mu biziami. Yesu bu kafuluka buna bakota mu divula dinlongo. Batu bawombo baba mona kuna. ");
INSERT INTO yom_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pfumu yi masodi ma Loma ayi momo maba yandi mu sunga Yesu bu bamona phila ntoto wunikukina ayi mambu moso momo phila mavangimina, bamona boma yiwombo ayi batuba : —Bukiedika kuandi ti mutu wowo bedi Muana Nzambi ! ");
INSERT INTO yom_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Baketo bawombo baba vana, thama baba ntadila. Bawu baba nlandakananga Yesu tona ku Ngalili mu diambu bansadila. ");
INSERT INTO yom_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mu bawu muba : Maliya muisi Mangadala, Maliya ngudi yi Zaki ayi Zozefi ayi ngudi yi bana ba Zebede. ");
INSERT INTO yom_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Va thangu masika, mutu wumosi wu kimvuama, muisi Alimate, dizina diandi Zozefi, wuba nlonguki wu Yesu, ");
INSERT INTO yom_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","wuyenda lomba nitu yi Yesu kuidi Pilatu. Buna Pilatu wuvana minsua muingi bamvana yawu. ");
INSERT INTO yom_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Zozefi wubonga nitu, wuyizinga mu dilasola di lino yi vedila. ");
INSERT INTO yom_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Wuyitula mu dibumbi diandi dimona, disokolo mu ditadi. Wunengumuna ditadi dimosi dinneni va muelo wu dibumbi. Bosi wuyenda kuandi. ");
INSERT INTO yom_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya muisi Mangadala ayi Maliya mankaka baba bavuanda ku ndambu yinkaka yitalini ayi dibumbi. ");
INSERT INTO yom_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lumbu ki khubumunu bu kivioka, mu lumbu kilanda, bapfumu banganga Nzambi ayi Bafalisi bayenda kuidi Pilatu. ");
INSERT INTO yom_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bankamba : —A pfumu ! Tulembo tebuka moyo ti mutu wowo wu luvunu bu kabedi moyo wubedi tubanga ti : “Ndiela fuluka bilumbu bitatu bu biela vioka :” ");
INSERT INTO yom_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Diawu bulutidi mboti wuvana minsua basunga dibumbi nate bilumbu bitatu bivioka muingi minlonguki miandi mibika kuenda yibi nitu andi bila nganu miela kamba batu ti wufulukidi mu bafua. Buna luvunu beni luela viatuka tezo ayi viokila lolo lutheti mu mbimbi. ");
INSERT INTO yom_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatu wuba vutudila : —Bonganu masodi, yendanu, lusunga ziami boso bu luzodidi. ");
INSERT INTO yom_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bayenda, bazibika bumboti dibumbi mu tula dimbu mu ditadi, ayi babika masodi. ");
INSERT INTO yom_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lumbu ki saba bu kivioka ; mu nsuka lumbu kitheti ki sabala ; Maliya muisi Mangadala ayi Maliya mankaka bayenda mu tala ziami. ");
INSERT INTO yom_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ayi tala ntoto wunikuka ngolo bila mbasi yi Pfumu yiba ku Diyilu yiyiza ayi yinengumuna ditadi ayi yivuanda va mbata ditadi beni. ");
INSERT INTO yom_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Philꞌandi yiba banga kiezila ki lusiemo ayi minledi miandi mimonika phembi yi ngolo viokila mvula yi matadi mu phembi. ");
INSERT INTO yom_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Masodi ma mona tsisi ; matona tita ayi makituka banga batu bafua. ");
INSERT INTO yom_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Vayi mbasi yikamba kuidi baketo : —Vayi kuidi beno, bikanu mona boma ! Nzebi ti Yesu diodi babendi va dikulusi niandi luntomba, ");
INSERT INTO yom_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","vayi kasiedi vava ko ! Fulukidingi banga bobo kakambila. Yiza lutala vovo kabedi. ");
INSERT INTO yom_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yendanu nsualu ayi kambanu minlonguki miandi ti fulukidingi mu bafua, ayi wulutuamimini buabu ku Ngalili, kuna ma lummona. Tala, ndilukembi. ");
INSERT INTO yom_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Babika nsualu ziami, ku tsi boma ayi khini yinneni. Mu thinu nsualu bayenda kamba tsangu beni kuidi minlonguki miandi. ");
INSERT INTO yom_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ayi tala, Yesu wuba dengana, wutuba : —Mboti eno. Bawu bafikama va kaba, basimba malu mandi ayi bansambila. ");
INSERT INTO yom_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Bosi Yesu wuba kamba : —Bikanu mona boma ! Yenda kambianu bakhomba ziama bayenda ku Ngalili, kuawu ziela ku mbonina ! ");
INSERT INTO yom_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mu thangu baba mu nzila, ndambu masodi masunga ziami mayenda ku divula ayi makamba mambu moso mabua kuidi bapfumu zinganga Nzambi. ");
INSERT INTO yom_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bu bakutakana va kimosi ayi bakulutu ba Bayuda, buna bawizana ayi bavana masodi zimbongo ziwombo, ");
INSERT INTO yom_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ayi baba kamba : —Buna lutuba ti minlonguki miandi miza yibanga nitu andi va builu mu thangu tubedingi ku tulu. ");
INSERT INTO yom_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Enati nyadi wilu nsamu wawu buna tuela kulula ntimꞌandi ayi beno lulendi ba ku tsi mayindu ko. ");
INSERT INTO yom_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Masodi mabonga zimbongo ayi mavanga boso bu babakambila. Buna diambu diodi ditembakana mu Bayuda nate mu lumbu kiaki. ");
INSERT INTO yom_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kumi minlonguki wumosi miyenda ku Ngalili, ku mongo wowo Yesu kaba sudikila. ");
INSERT INTO yom_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mu thangu bammona, bansambila vayi bankaka, bamemata. ");
INSERT INTO yom_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu wufikama va baba ayi wuba kamba : —Minu baveni lulendo loso tona ku Diyilu nate vava ntoto. ");
INSERT INTO yom_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Diawu yendanu, lukitula batu ba zitsi zioso minlonguki miama ; Lubabotika mu dizina di Tata, di Muana ayi di Pheve Yinlongo. ");
INSERT INTO yom_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ayi luba longa batumimina mambu moso momo ndilutumina. Luzaba mboti ti bilumbu bioso minu ndidi yeno nate vana tsukusulu yi nza.");
INSERT INTO yom_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Thonono Nsamu wu mboti wu Yesu Klisto, Muana Nzambi, ");
INSERT INTO yom_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","banga busonimina mu nkanda mbikudi Ezayi : Tala ! Ndiela fidisa mvualꞌama ku ntualꞌaku, niandi wela kubika nzilꞌaku. ");
INSERT INTO yom_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yawu mbembo yi mutu wunyamikina mu dikanga : Lukubika nzila yi Pfumu, Luludika minsolo miandi. ");
INSERT INTO yom_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yowani wuyiza, wuba botikanga mu dikanga ayi wuba tubanga ti : “Bika lubotama mu diambu di monisa ti lubaludi mavanga ; buna Nzambi wela kululemvukila mu masumu meno.” ");
INSERT INTO yom_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Batu boso baba mu zunga ki Yuda ayi batubobo baba kalanga ku Yelusalemibaba kuendanga kuidi niandi. Wuba botikanga mu nlangu Yolidani bu baba tambudilanga masumu mawu. ");
INSERT INTO yom_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yowani wuba vuatanga minledi mivangulu mu mika mi kamela. Bosi nsinga kaba nkanganga mu luketo wuvangulu mu nkanda wu bulu. Bidiakaba ndianga : makhoko ayi niosi. ");
INSERT INTO yom_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Malongi kaba longanga mawu mama : —Fioti fisiedi malumona mutu wumosi wunkuiza ku manima mama, niandi wudutidi mu lulendo ; ndisi fuana nkutu ko mu yinama mu diambu di nianguna minsinga mi zisapatu ziandi. ");
INSERT INTO yom_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Minu mu nlangu ndilembo kulubotikila vayi niandi mu pheve Yinlongokela kulubotikila. ");
INSERT INTO yom_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mu thangu yina Yesu wuba ku Nazaleti, buala buidi mu Ngalili, wuyiza kuidi Yowani ayi niandi wumbotika mu nlangu Yolidani. ");
INSERT INTO yom_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mu thangu kaba totuka mu nlangu, kazimbukulu Diyilu dizibukidi, Pheve Yinlongo yikuluka va niandi banga dibembi. ");
INSERT INTO yom_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mbembo yitotuka ku Diyilu, yiwakana : —Ngeyo widi mwanꞌama wu luzolo ; khini yiwombo wukumbonisanga. ");
INSERT INTO yom_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Vana vawu Pheve yituma Yesu mu kuenda ku dikanga. ");
INSERT INTO yom_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Makumaya ma bilumbu kavuandila kuna ayi kuna Satana kantotila. Wuba mvuandanga ayi bibulu bi nsitu bosi zimbasi ziba kunsadilanga. ");
INSERT INTO yom_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bu bakanga Yowani, Yesu wuyiza ku Ngalili mu longa Nsamu wumboti wu Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wuba tubanga ti : —Thangu yifueni ! Kipfumu ki Nzambi kifikimini. Bika lubalula mavanga ayi luwilukila Nsamu wumboti. ");
INSERT INTO yom_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Lumbu kimosi Yesu bu kaba kuenda yendanga mu mbembele mbu wu Ngalili, wumona Simoni ayi khombꞌandi Andele banloza dikondi mu mbu, bila baba banlobi mbizi. ");
INSERT INTO yom_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu wuba kamba : —Ndandakananu ayi ndiela kulukitula minlobi mi batu. ");
INSERT INTO yom_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Muna thangu beni, basia bika makondi mawu ayi banlandakana. ");
INSERT INTO yom_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Buela kuesa fioti ; wumona zaki muana Zebede ayi khombꞌandi Yowani ; balembo londi makondi mu khati nlungu. ");
INSERT INTO yom_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Vana vawu wuba tela. Basia bika dise diawu Zebede ayi bisadi biandi muna nlungu ; banlandakana. ");
INSERT INTO yom_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bayenda ku Kafalinawumi. Lumbu ki saba bu kifuana, Yesu wukota mu nzo lukutukunu ayi wutona longa. ");
INSERT INTO yom_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Basimina mu diambu di malongi mandi. Bila wuba longila mu lulendo vayi bika banga minlongi mi mina. ");
INSERT INTO yom_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Muna nzo lukutukunu muba mutu wumosi wuba pheve yimbimbi, wutona yamikina : ");
INSERT INTO yom_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—A ! Yesu muisi Nazaleti, mbi mambu tuidi beto yaku e ? Wizidi mu kutubunga e ? Minu ndizebi, ngeyo widi nani : widi mutu wunlongo wu Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu wutemina pheve yimbimbi ayi wuntumina : —Bika biyoko, totuka mu mutu wawu ! ");
INSERT INTO yom_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pheve yimbimbi yitukumuna mutu beni, yiyamikina mu mbembo yingolobosi yitotuka. ");
INSERT INTO yom_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Babo basimina ayi baba kukiyuvula bawu na bawu : —A ! Diambu mbi diadi e ? Talanu ndongolo yimona yinlongolo mu lulendo. Niandi wuntumina ziphevi zimbimbi ayi ziphevi beni zikuntumukina. ");
INSERT INTO yom_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Buna tsanguꞌandi yitembakana mu zunga kioso ki Ngalili. ");
INSERT INTO yom_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Muna thangu yina kaka, buna batumbu totuka mu nzo lukutukunu. Yesu, Zaki ayi Yowani bayenda ku nzo Simoni ayi Andele. ");
INSERT INTO yom_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nzitu wu Simoni wu nketo wuba wuleka va mbuka bila zinzangala ziba yandi. Yesu buna katumbu kota ; bankamba tsangu mu diambu diandi. ");
INSERT INTO yom_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bu kafikama, wunsimba mu koko, wuntelimisa. Zinzangala zimana, bosi weka kuba sadila. ");
INSERT INTO yom_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mu masika, thangu bu yidiama, bannatina bambevo zioso ayi batu bobo baba ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Batu boso ba divula bakutakana va muelo nzo. Simoni ayi Andele. ");
INSERT INTO yom_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wubelusa batu bawombo baba bimbevo bi phila mu phila ayi wukukaziphevi ziwombo zimbimbi ayi wuzikandika zibika yoluka bila zizaba Yesu niandi nani. ");
INSERT INTO yom_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mu nsuka buna kukidi tombo fioti, Yesu wukotuka ayi wutotuka ku nganda, wuyenda ku buangu kisuama mu diambu di sambila. ");
INSERT INTO yom_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni ayi batu bobo baba yandi bantomba. ");
INSERT INTO yom_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Buna bambakula, bankamba : —Batu boso ngeyo bantomba ! ");
INSERT INTO yom_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Vayi wuba vutudila : —Tuendanu kueto ku buangu kinkaka, mu mala momo mafikimini. Mfueti longa mu mala beni, bila diawu ndiyizila ! ");
INSERT INTO yom_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Buna wulonga mu zinzo ziawu zi zikhutukunu mu Ngalili dioso ayi wukuka ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mutu wumosi wuba buazi wuyiza fukimina Yesu ayi wunkamba : —Enati tidi, beki kuaku bu kumbelusa. ");
INSERT INTO yom_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu wummona kiadi, wunonuna koko, wunsimba ayi wunkamba : —Nyinga thidi, beluka kuaku ! ");
INSERT INTO yom_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Vana vawu buazi bubotukidi, mu mutu beni, wutumbu beluka. ");
INSERT INTO yom_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu wumvutula ku nzo andi bu kanlubula ti : ");
INSERT INTO yom_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Keba, kadi kamba kadi mutu wumosi mambu mama vayi yenda kimonisa kuidi nganga Nzambi ayi yenda tambika makaba momo Moyize kavanina lutumunumu diambu di kiba kimbangi kuidi bawu ti ngeyo belukidi. ");
INSERT INTO yom_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Vayi buna katumbu totuka ; wutona yamikisa kuidi batu bosomambu moso mavangama mu niandi ayi wutembikisa tsangu beni mumo. Mu bila kioki yesu kakadila mu bibuangu bisuama. Vayi batu baba mu zindambu zioso baba kuizanga kuidi niandi. ");
INSERT INTO yom_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ndambu bilumbu bu bivioka, Yesu wubuela kuenda ku Kafalinawumi. Bawa tsangu ti widi kuna nzo. ");
INSERT INTO yom_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nkangu wu batu wukutakana muna. Batu bawokila ngolo, diawu nkutu bibuangu bisia buela monika ko ka diambu ko va muelo. Vayi Yesu wuba longa mambu ma Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Batu baya bayiza kuidi niandi, ayi, banata dikoka. ");
INSERT INTO yom_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Vayi bu basia nunga ko mu kuntudisa vaba Yesu bila nkangu wu batu wuwokila ngolo ; diawu batobudila divudu mu muanzu vana vawu vabela Yesu. Bosi bakulula kiphoyi bila wuba wuleka va kiphoyi beni. ");
INSERT INTO yom_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu bu kamona minu kiawu ; buna wukamba kuidi dikoka ti : —A muanꞌama, masumu maku malemvokolo ! ");
INSERT INTO yom_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Minlongi minkaka mi Mina miba vana mitona niunguta mu mintima miawu : ");
INSERT INTO yom_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—A bila mbi mutu wawu kanyolukila bobo e ? Keti lembo vuezi Nzambi ! Nani wunlemvukilanga masumu e ? A keti Nzambi kaka wunlemvukilanga masumu ! ");
INSERT INTO yom_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Vana vawu Yesu, mu pheve andi, bu kazaba mayindu mawu, wuba kamba : —Bila mbi lunyindudila mayindu ma phila yoyi e ? ");
INSERT INTO yom_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Diambu mbi diodi dikambulu phasi mu kamba kuidi dikoka : “Masumu makumalemvokolo” voti “Telama, nanguna kiphoyi kiaku ayi diata”. ");
INSERT INTO yom_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vayi muingi luzaba ti Muana Mutu beki lulendo lu lemvukila masumu va ntoto… ");
INSERT INTO yom_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Buna wukamba dikoka ti : —Ndikutumina : Telama, bonga kiphoyi kiaku, vutuka ku nzoꞌaku ! ");
INSERT INTO yom_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Vana vawu mutu beni wutelama, wubonga kiphoyi kiandi, wutotuka va meso ma batu boso. Baboso basimina ayi bakembisa Nzambi bu batuba : —Tumueni ko mambu ma phila yayi ! ");
INSERT INTO yom_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu wuyenda diaka ayi wudiata mu mbembele mbu, nkangu wu batu wuyiza ku kaba ayi wuba longa. ");
INSERT INTO yom_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bu kaba vioka, wumona Levi, muana Alafayi, vuendi mu bilu kiba mfutisilanga ziphaku ayi wunkamba : —Wundandakana. Niandi wutelama ayi wunlandakana. ");
INSERT INTO yom_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu bu kaba dia ku nzo Levi ; mimfutisi mi ziphaku miwombo ayi bankua masumu bawombo badia yandi va kimosi ayi minlonguki miandi ; bila batu bawombo banlandakana. ");
INSERT INTO yom_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Minlongi mi mina mi Bafalisi bu mimona ti Yesu wulembo dia va kimosi ayi mimfutisi mi zipaku ayi bankua masumu, mieka nyuvula minlonguki mi Yesu : —Bila mbi Nlongi eno kalembo dila va kimosi ayi mimfutisi mi ziphaku ayi bankua masumu e ? ");
INSERT INTO yom_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu bu kawa bobo, buna wuba vutudila : —Batu badi buvini basi mfunu wu munganga ko, vayi badi kimbevo bawu bantombanga munganga ! Ndisia kuiza ko mu tela basonga vayi ndiyiza mu tela bankua masumu. ");
INSERT INTO yom_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Minlonguki mi Yowani ayi Bafalisi baba kukifuisanga nzala mudiambu di lusambulu. Buna bayiza yuvula Yesu : —Bila mbi minlonguki mi Yowani ayi mi Bafalisi beti kukifuisila nzala mu diambu di lusambulu vayi minlonguki miaku mikifuisanga nzala ko mu diambu di lusambulu e ? ");
INSERT INTO yom_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu wuba vutudila : —Buevi ; batu batumusu ku nyengo makuela balenda kukifuisa nzala mu diambu di lusambulu bu bakidi va kimosi ayi mutu wowo kuedidi e ? Mutu wowo sadisidi nyengo bu kadi yawu va kimosi, balendi kifuisa nzala mu diambu di lusambulu ko. ");
INSERT INTO yom_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Vayi vela ba lumbu, bu bela ku babotula mutu wowo kuedidi bunabosi bela kifuisa nzala mu diambu di lusambulu. ");
INSERT INTO yom_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mutu kalendi bonga tendi kimona ko muingi kalondila nledi wukhulu. Niandi vanga bobo buna kimona kieka buela kakuna nledi wukhulu ayi buna divudu diela ba dinneni. ");
INSERT INTO yom_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bobuawu mutu kalendi tula ko vinu kimona mu zitsaku zikhulu bila vinu kimona kibeki bu kanzunina zitsaku zioso. Buna vinu kibungani ayi zitsaku zifuidi. Vayi beti lundila vinu kimona mu zitsaku zimona. ");
INSERT INTO yom_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bu kaba viokila mu tsola yi ble mu lumbu ki saba ; minlonguki miandi bu miba vioka, mivela ble. ");
INSERT INTO yom_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Buna Bafalisi bankamba : —Tala ! Bila mbi minlonguki miaku mimvangila mambu momo makanduku mu lumbu ki saba e ? ");
INSERT INTO yom_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Niandi wuba vutudila : —Lutengi ko mambu Davidi kavanga mu thangu niandi ayi bakundi bandi baba nzala ayi bakambu bidia e ? ");
INSERT INTO yom_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wukota muna Nzo Nzambi, niandi ayi bakundi bandi badia maphamomo matambuku kuidi Nzambi. Mu thangu beni Abiatali niandi wuba pfumu yi zinganga. Muaki zinganga ziawu kaka ziba minsua mu dia mapha beni ; vayi Davidi wudia mawu ayi wuvana batu bandi. ");
INSERT INTO yom_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu wubuela bakamba : —Lumbu ki saba kivangu mu diambu di mutu, bika sia ti mutu niandiwuvangu mu diambu di lumbu ki saba. ");
INSERT INTO yom_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Diawu Muana Mutu niandi Pfumu lumbu ki saba. ");
INSERT INTO yom_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu wubuela kota diaka mu nzo lukutukunu, kuna kuba mutu wumosi wuba koko kusioka. ");
INSERT INTO yom_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yesu baba tala keni lenda kumbelusa mu lumbu ki saba muingi babaka bu kumfundila. ");
INSERT INTO yom_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu wukamba mutu wowo wuba koko kusioka : —Telama vana, va ntuala batu boso. ");
INSERT INTO yom_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bosi wuba yuvula : —Minsua midi mu vanga mamboti voti mambimbi mu lumbu ki saba e ? Minsuamidi mu vukisa luzingu lu mutu voti mu vonda e ? ");
INSERT INTO yom_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Vayi kadi mutu kasia vutula kadi diambu ko. Yesu wuba tala mu nganzi ayi weka mona kiadi mu diambu di mintima miawu miba banga matadi. Bosi wukamba kuidi mutu wuba koko kusioka : —Nonuna koko kuaku ! Wunonuna kuawu ayi koko kuandi kufuana. ");
INSERT INTO yom_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Vana vawu, Bafalisi batumbu totuka mu nzo lukutukunu, bayenda kaza ayibatu ba dingumba di Elode muingi batomba diluaku di vondila Yesu. ");
INSERT INTO yom_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ayi minlonguki miandi babotuka vana, bayenda ku ndambu mbu. Vayi nkangu wuwombo wu batu wuba landakana : baba ku Ngalili, ");
INSERT INTO yom_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ku Yuda, ku Yelusalemi, ku tsi Idume, ku disimu dinkaka di Yolidani. Batu bobo bazungidila bizunga bi Tile ayi Sidoni bayiza bawombo kuidi niandi bu bawa mambu momo kavanga. ");
INSERT INTO yom_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Wukamba minlonguki miandi minkubikila nlungu muingi nkangu wu batu wubika kumfietikisa. ");
INSERT INTO yom_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Muaki sumbu kabelusa batu bawombo, diawu bobo baba minsongo balundumuka kuiza kuidi niandi muingi bansimba. ");
INSERT INTO yom_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bosi thangu batu baba ziphevi zimbimbi bammona, babua va ntualꞌandiayi bayamikina : —Ngeyo widi Muana Nzambi ! ");
INSERT INTO yom_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Vayi wuba kandika babika zabikisa ti niandi nani. ");
INSERT INTO yom_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu wukuma va mbata mongo ; wutela batu bobo kazola ayi batu beni bayiza kuidi niandi. ");
INSERT INTO yom_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kumi batu buadi kasobula bobo kabieka bamvuala muingi babanga yandi va kimosi ; ");
INSERT INTO yom_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ayi muingi kaba fidisa mu kuenda longi ayi mu diambu baba lulendo lu totudila ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tala mazina makumi batu buadi bobo kasobula : ");
INSERT INTO yom_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","—Simoni mutu kabieka Piela ; Zaki, muana Zebede ayi khombꞌandi Yowani. Wuba vana dizina di Bowanelingesi bu dinsundula “bana ba nzazi” ");
INSERT INTO yom_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andele, Filipi, Balitelemi, Matayi, Toma, Zaki muana Alafayi, Tade, Simoni wuba mu dingumba di Bazeloti ");
INSERT INTO yom_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ayi Yuda Isikalioti, mutu wuvakusa Yesu. ");
INSERT INTO yom_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bu kakota mu nzo, nkangu wu batu wuyiza kutakana diaka muna. Yesu ayi minlonguki miandi basia buela baka ko bu dila. ");
INSERT INTO yom_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bibutu biandi bu biwa nsamu beni, biyiza kunlanda mu kingolo bila baba tuba : “Weka dilawu”. ");
INSERT INTO yom_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Minlongi mi mina miba ku Yelusalemi mituba : —Ku tsi minsua mi Belezebuli kadi. Mu lulendo lu pfumu yi ziphevi zimbimbi kalembo kukila ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Buna Yesu wuba tumisa ayi wuba sudikisila mu zinongo : —Buevi Satana kalenda kukila Satana e ? ");
INSERT INTO yom_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Enati kipfumu kivasukidi kiawu veka, buna kipfumu beni kilendi zingila ko. ");
INSERT INTO yom_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Enati nzo yivasukidi yawu veka, buna nzo beni yilendi zingila ko. ");
INSERT INTO yom_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Enati Satana weka kinuanisa niandi veka, ayi enati widi wuvasuka, buna, kalendi zingila ko. Tsukulu andi yimonikini. ");
INSERT INTO yom_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kuisi ko mutu beki bukotila mu nzo yi mutu widi ngolo ayi yiba bima biandi enati kasi tuama kanga ko mutu beni. Buna bosi kalenda baka bu yibila bima bioso bidi mu nzo andi. ");
INSERT INTO yom_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Bukiedika ndikulukamba ti masumu moso ayi bifingu biosobilenda fingu Nzambi biela lemvukulu ");
INSERT INTO yom_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","vayi woso kuandi wela finga Pheve yinlongo, kalendi lemvukulu ko ; wela natanga nkanu wu masumu momo mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu wubayolukila buawu mu diambu di batu baba tubanga ti : “ku tsi minsua mu pheve yimbimbi kadi”. ");
INSERT INTO yom_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ngudi yi Yesu ayi bakhomba bandi bayiza. Batelama ku nganda ayi batuma mutu mu kuntela. ");
INSERT INTO yom_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Batu bawombo bavuanda ayi banzungidila Yesu. Buna bayiza ku nkamba : —Tala ngudi aku ayi bakhomba ziaku badi ku nganda ayi ngeyo bantomba. ");
INSERT INTO yom_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu wuba vutudila : —A nani ngudi ama ayi banani bakhomba ziama e ? ");
INSERT INTO yom_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bu tala batu bobo bantula va lukongolo, buna wuba kamba : —Tala ngudi ama ayi bakhomba ziama bawu baba. ");
INSERT INTO yom_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Woso mutu wumvanga luzolo lu Nzambi, niandi khombꞌama yi bakala ayi khombꞌama yi nketo ayi ngudi ama. ");
INSERT INTO yom_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu wubuela tona diaka longa va disimu di mbu. Nkangu wu batu wukutakana va kaba wuba wuwombo. Diawu kakumina mu nlungu, wuvuanda muna. Nkangu wu batu wuba va disimu va ndambu mbu. ");
INSERT INTO yom_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wuba longila mambu mawombo mu zinongo. Tala mambu kaba nlonga : ");
INSERT INTO yom_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Wanu mboti : Nkuni wumosi wuyenda ku kuna. ");
INSERT INTO yom_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bu kaba muanga mbongo, ndambu yibua mu yenda nzila ; zinuni ziyiza mana kuyidoda. ");
INSERT INTO yom_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ndambu yinkaka yibua va matadi ; vuma beni vasia ba ntoto wuwombo ko. Zitheti zivika mena kuandi bila ntoto wusia ba phiba ko. ");
INSERT INTO yom_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Vayi muini wungolo bu wutotuka, mintuidila beni milebuka ayi miyuma bila misia ba mianzi ko. ");
INSERT INTO yom_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yinkaka yibua va zitsendi. Zitsendi beni zimena ayi zifietikisamintuidila beni. Diawu mintuidila beni misia buta mimbutu ko. ");
INSERT INTO yom_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Vayi yinkaka yibua mu ntoto wumboti, yitotula mintuidila, mikula ayi mibuta mimbutu : yimosi makumatatu ; yinkaka makumasambanu, yinkaka khama. ");
INSERT INTO yom_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Buna wubuela bakamba : woso widi matu ma wila buna bika kawa. ");
INSERT INTO yom_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bu kaba va niandi veka, batu bobo banzungidila va kimosi ayi kumi mimvuala miandi miodi banyuvula tsundu yi zinongo. ");
INSERT INTO yom_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wuba vutudila : —Beno lutambula diluaku di zabila mansueki ma kipfumu ki Nzambi. Vayi kuidi batu bankaka bobo badi ku nganda, mamo mu zinongo kaka manyolokolo ");
INSERT INTO yom_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","muingi : Mu thangu bantala, batedi kuawu vayi bakadi mona. Mu thangu banwa, bawilu kuawu vayi bakadi sudika muingi babika baluka kuidi Nzambi ayi masumu mawu mabika lemvokolo. ");
INSERT INTO yom_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bosi wubuela bakamba : —Lukadi sudika nongo yayi e ? Buna buevi lulenda sudikila zinongo zioso e ? ");
INSERT INTO yom_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—Nkuni niandi wunkunanga mambu ma Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Batu bankaka badi mbongo yidi muyenda nzila, mu kunu mambu ma Nzambi. Bu bawilu mawu, buna satana wunkuizanga nsualu mu ziona mambu ma Nzambi makunu mu bawu. ");
INSERT INTO yom_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bosi bankaka badi banga mbongo yikunu va ntoto widi matadi. Bawu wa mambu ma Nzambi, bantumbu vika kumatambulanga mu khini. ");
INSERT INTO yom_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Vayi bu bakambulu mianzi, bazingilanga ko. Bila enati ziphasi voti zithotolo zitonini mu diambu di mambu ma Nzambi, buna beti vika bua. ");
INSERT INTO yom_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bankaka badi banga mbongo yikunu va zitsendi. Bawu beti wa mambu ma Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Vayi mambu beni makadi buta mimbutu mu diambu mayindu ma nza yayi, luvunu lu kimvuama ki nza ayi zitsatu zi mambu mankaka bu makotidi mu bawu buna mamfietikisanga Mambu ma Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bosi bankaka bawu bantambulanga mbongo mu ntoto wumboti. Bawu bobo beti wanga mambu ma Nzambi ayi bawu beti buta mimbutu miwombo : yinkaka makumatatu, yinkaka makumasambanu bosi yinkaka khama. ");
INSERT INTO yom_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wuba kamba diaka : —A bwevi, beti nata muinda mu diambu di kuwutula ku tsi katini voti ku tsi mbuka e ? A keti beti kuwunata mu diambu di kuwutula va yilu meza. ");
INSERT INTO yom_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mamo masuama mafueti ba va kiezila ayi mamo masueko mafueti totuka va nganda. ");
INSERT INTO yom_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Enati mutu widi matu mawila buna bika kawa. ");
INSERT INTO yom_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Buna wubuela diaka : lulubuka mbote mu mamo momo lulembo wa bila bela kulutezila mu tezo kioki lusadila ayi bela buela mawombo. ");
INSERT INTO yom_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bila kuidi woso mutu beki, bela buela kumvana vayi kuidi mutu wowokambulu, bela kunziona biobi kutu bidi yandi. ");
INSERT INTO yom_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wubuela tuba diaka : —Tala Kipfumu ki Nzambi kidedikini banga mutu wumosi wukuna mbongo mu ntoto. ");
INSERT INTO yom_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kaleka voti kakotuka va builu voti va muini, mbongo yimena ayi yiyonzuka yawu veka niandi mukambu zaba. ");
INSERT INTO yom_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ntoto wawu veka, wubuta mimbutu ; va thete wumenisa ntuidila, bosiwutotula tsangu bosi mimbutu miyela. ");
INSERT INTO yom_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Thangu mimbutu mayedidi ; nkuni wubonga kikhondolo kimvedolongo mimbutu muingi kavedila mimbutu bila thangu yivedila yifuana. ");
INSERT INTO yom_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wubuela kamba diaka : —Mu mbi tulenda dedikisa kipfumu ki Nzambi ? Mu nongo mbi tulendakulukambila yawu e ? ");
INSERT INTO yom_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kipfumu ki Nzambi kidedikini banga luteti lu mutalide. Bu lukununumu ntoto, luawu lututidi keva mu zitheti zioso va nza. ");
INSERT INTO yom_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Vayi luawu kunu mu ntoto lueti menanga ayi lumviokanga bikunusubioso mu kula ayi lueti totula matafi manneni ; kuna zinuni zilenda tungilazindiala ziawu ku tsi phozi andi. ");
INSERT INTO yom_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Buna wuba longa mambu ma Nzambi mu zinongo ziwombo ziphilayayi, boso bubela diluaku di balenda kunsudikila. ");
INSERT INTO yom_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kalendi kuba yolukila ko mu kambu sadila nongo. Vayi ti weka va niandi veka ayi minlonguki miandi, buna wuba kuba sudikisanga mambu moso. ");
INSERT INTO yom_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Va thangu masika muna lumbu kina, Yesu wukamba minlonguki miandi : —Tusabukanu ku disimu dinkaka. ");
INSERT INTO yom_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Basia bika nkangu wu batu ; bawu bannata mu nlungu boso bu kabela. Minlungu minkaka miba yandi vana. ");
INSERT INTO yom_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Buela zimbukila vuka kingolo kieka. Mayo ma ngolo mabua mu nlungu. Bosi nlungu wutona wala nlangu. ");
INSERT INTO yom_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Niandi wuba wuleka kuna tsongi nlungu. Wuniekika ntu andi va mbatakusa. Minlonguki minkotula ayi minkamba : —A Nlongi ! Tueka mfua vayi Ngeyo wummona diawu diambu di phamba e ? ");
INSERT INTO yom_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wukotuka, wutemina vuka ayi wuvana lutumu kuidi mbu : —Bika biyoko ! Ba dio sui ! Vuka kimanisa ayi ndembama yivutuka. ");
INSERT INTO yom_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bosi wuyuvula minlonguki miandi : —A bila mbi luididi boma-boma ? A buevi lukambulu minu e ? ");
INSERT INTO yom_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Beka mona boma buwombo ayi beka niunguta bawu veka : —A buna nani mutu wawu muingi vuka ayi mbu bintumunika e ? ");
INSERT INTO yom_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bu batula ku disimu dinkaka di mbu mu zunga ki basi Ngelasa. ");
INSERT INTO yom_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu bu katotuka mu nlungu ; mutu wumosi wuba ziphevi zimbimbi wutotuka mu mabumbi, wuyiza kundengana. ");
INSERT INTO yom_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mutu beni wuba vuandanga mu mabumbi ayi kadi mutu kalendikunkanga ko, ka diambu ko mu zisieni. ");
INSERT INTO yom_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bila zikhumbu ziwombo baba ku nkanganga bisengo ayi zisieni mu malu vayi wuba tabulanga zisieni beni ayi wuba bukunanga bisengo mu bitini. Ayi kadi mutu kasia ku nyodika ko. ");
INSERT INTO yom_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Zithangu zioso, builu ayi muini, niandi wuba vuandanga mu biziamiayi ku miongo, wuba kuenda yamikinanga ayi ku kiluekanga mu matadi. ");
INSERT INTO yom_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bu kamona ti Yesu wukidi thama ; wuzawula ayi wuyiza fukama va ntualꞌandi, ");
INSERT INTO yom_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ayi wuyamikina mu mbembo yi ngolo : —A yesu, Muana Nzambi yi zangama, mambu mbi tidi kuidi minu e ? Mu dizina di Nzambi ndikuleba : kadi kundiamisa. ");
INSERT INTO yom_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bila wuba kambanga pheve yimbimbi : —Pheve yi mbimbi totuka mu mutu wawu ! ");
INSERT INTO yom_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Bosi Yesu wunyuvula : —A dizina diaku nani ! Niandi wumvutudila : —Dizina diama “Lengio” bu dinsundula tuidi bawombo. ");
INSERT INTO yom_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pheve yimbimbi yileba Yesu muingi kabika kuba kuka mu zunga ki tsi beni. ");
INSERT INTO yom_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nkangu wu zingulu wunneni wuba dia kuna, kuna ndambu mongo. ");
INSERT INTO yom_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Zipheve zimbimbi zileba Yesu : —Wututuma tukota kueto mu zingulu ziazi ! ");
INSERT INTO yom_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu wuba vana minsua. Buna ziphevi zimbimbi zitotuka mu mutu beni ayi ziyenda kota mu zingulu. Zingulu beni ziba tezo ki zimilizizole ; zinengumuka nsualu mu mongo ayi ziyenda bua mu mbu, ayi, zimana diama. ");
INSERT INTO yom_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Minsungi mi zingulu beni mitina ayi minata tsangu mu mavula ayi mu ziphangu zi bibulu zitsola. Batu bayiza tala mambu momo mavioka. ");
INSERT INTO yom_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bu batula vaba Yesu, bamona mutu beni wowo wuba ziphevi zimbimbi, mutuwowo wuba lengio, buna kavuendi ; vueti minledi ayi diela diandi diosodiduka. Buna bamona boma. ");
INSERT INTO yom_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ayi baba kamba mambu mavioka kuidi batu bobo bamona boso mavangiminamu mutu wuba ziphevi zimbimbi ayi mu zingulu. ");
INSERT INTO yom_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Buna batu beni baleba Yesu kabotuka mu zunga kiawu. ");
INSERT INTO yom_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mu thangu Yesu kaba nkota mu nlungu, mutu wowo wuba ziphevi zimbimbiwuyuvula Yesu enati lenda kunlandakana. ");
INSERT INTO yom_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Vayi Yesu kasia kumvana ko minsua mu kunlandakana ayi wunkamba : —Vutuka ku nzoꞌaku, kuidi bakhomba ziaku ayi wuba kambi mambu Pfumu kavangidi ayi buevi kamuenini kiadi. ");
INSERT INTO yom_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Buna wuyenda ayi wutona samuna mu “kumi di mavula” mambu moso mamvangila Yesu. Baboso basimina buwombo. ");
INSERT INTO yom_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu bu kabuela sabuka, mu nlungu, ku disimu dinkaka di mbu ; nkangu wu batu bawombo bayiza kunzungidila vana disimu di mbu. Niandi va ndambu mbu kaba. ");
INSERT INTO yom_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Buna mutu wumosi dizina diandi Yayilusi, wuba wumosi mu bapfumu zi nzo lukutukunu wuyiza vana. Bu kamona Yesu, wufukama va ntualꞌandi. ");
INSERT INTO yom_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Wunleba ngolo ayi wunkamba : —Muanꞌama wunketo widi mu ziphasi zi lufua. Wundemvukila ; yizawuntetika mioko muingi kabeluka ayi kazinga ! ");
INSERT INTO yom_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu wuyenda yandi va kimosi ayi nkangu wu batu wunlandakana ayi wumfietikisa mu zindambu zioso. ");
INSERT INTO yom_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nketo wumosi wuba muna nkangu beni wuba kimbevo ki viokanga menga, kumi mimvu miodi kabedila kimbevo beni. ");
INSERT INTO yom_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wumona ziphasi ziwombo kuidi minganga miwombo ayi bima biandi bioso bimana mu diambu di kimbevo beni, kasia beluka ko vayi ziphasi ziluta buelama. ");
INSERT INTO yom_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Bu kawa zitsangu zi Yesu, buna wuyiza, muna nkangu wu kaba, ku manima ayi wusimba nledi wu Yesu. ");
INSERT INTO yom_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Bila wuyindula ti : —Minu simba kuandi minledi miandi mandi beluka kuama ! ");
INSERT INTO yom_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Muna thangu yina kaka, menga malembolo buela vioka ayi wumona mu nituꞌandi ti belukidi mu nsongo wowo. ");
INSERT INTO yom_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Muna thangu yina, Yesu wubakula ti lulendo luandi lutotuka, wubaluka kuidi nkangu wu batu ayi wuba yuvula ti : —A nani simbidi minledi miama e ? ");
INSERT INTO yom_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Minlonguki miandi minkamba : —Wummona kuaku buevi nkangu wu batu balembo fietikisila mu zindambu zioso ayi weka buela yuvula : “Nani wutsimbidi e ?” ");
INSERT INTO yom_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Vayi niandi thalu andi yiba kaka kuidi nkangu muingi kazaba mutu vengi diawu. ");
INSERT INTO yom_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nketo wumona boma ayi weka tita. Bu kazaba diambu divangama mu nitu andi buna wufikama, wufukama va ntuala Yesu ayi wunkamba kiedika kioso. ");
INSERT INTO yom_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Buna Yesu wunkamba : —A muanꞌama wunketo, minu kiaku kibelusidi ! Yenda mu ndembama ayi beluka kuaku mu ziphasi ziaku. ");
INSERT INTO yom_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Buna wukidi yoluka, ndambu yi batu baba ku nzo pfumu yi nzolukutukunu bayiza kunkamba : —Muanꞌaku wunketo fuidi. Bila mbi mu buela tatisa nlongi e ? ");
INSERT INTO yom_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Vayi Yesu bu kawa mambu batuba, wukamba pfumu yi nzo lukutukunu, ti : —Kadi mona boma. Wilukila kaka ! ");
INSERT INTO yom_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bosi Yesu kasia vana ko minsua, kadi kuidi mutu wumosi, mu kunlandakana botula kaka Piela, zaki ayi khombꞌandi Yowani. ");
INSERT INTO yom_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Buna batula ku nzo Pfumu lukutukunu, Yesu wumona divuda diba kuna : batu badila ayi bayamikina. ");
INSERT INTO yom_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Buna wukota mu nzo ayi wutuba : —A bila mbi divuda diodi e ? Ayi bila mbi lulembo didila e ? Muana kasi fua ko vayi leka kuandi kalekidi ! ");
INSERT INTO yom_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Vayi bansekinina. Buna Yesu wutotula batu boso ku nganda. Wubonga dise ayi ngudi yi muana ayi minlonguki miomi miba yandi. Bawu bakota yandi muna khati vinga muba muana beni. ");
INSERT INTO yom_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wusimba koko ku muana ayi wunkamba : —Talita kumi ! Bu dinsundula : Muana ndumba ndikutumina kotuka ! ");
INSERT INTO yom_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Vana vawu muana ndumba wutelama ayi wudiata bila nduka-nduka kumi mimvu miodi miba yandi. Babo basimina ngolo. ");
INSERT INTO yom_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Vayi Yesu wuba kandika babika kamba mambu beni kadi kuidi mutu wumosi ayi wuba kamba bamvana bidia. ");
INSERT INTO yom_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Buna Yesu wubotuka kuna ; wuvutuka ku tsi andi yika butukila ayi minlonguki miandi minlandakana. ");
INSERT INTO yom_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mu lumbu ki saba, Yesu wutona longa mu nzo lukutukunu. Buna bawombomu batu bobo banwa basimina ayi batuba : —A kuevi kabakidi mambu momo e ? A phila nduenga mbi yoyibamveni e ? A buevi kalembo vangila bikumu biobi e ? ");
INSERT INTO yom_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Niandi ko salaphati ; muana Maliya ; khomba yi Zaki, Yose, Yuda ayi Simoni e ? Bakhomba bandi zi baketo keti zikala yeto vava ? Niandi wuba nkaku kuidi bawu muingi babika wilukila. ");
INSERT INTO yom_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Buna Yesu wuba kamba : —Mbikudi kantambulanga minzitusu ko mu tsi andi, kuidi bibutu biandi koayi mu dikanda diandi ko. ");
INSERT INTO yom_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Diawu kadi kumu kasia vanga kuna ko. Vayi botuka kaka ndambu bambevokatetika mioko ayi kabelusa. ");
INSERT INTO yom_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wusimina buwombo mu kambu kuawu ku minu. Yesu wudiengila mu mala ma zunga kina mu diambu di longa. ");
INSERT INTO yom_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wutumisa kumi mimvuala miandi miodi ayi wuba fidisa buadi-buadi. Wuba vana lulendo lu yadila ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Wuba kamba babika nata kadi kima kimosi mu nzila botula kaka nti wutula va koko. Buna wuba kamba : —Bu lunkuenda, lubika nata kadi khuta ; kadi nata khutu ; kadi nata zimbongo mu photimoni. ");
INSERT INTO yom_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Luvuata zisapatu mu malu vayi kadi nata kikhutu ki viakisa. ");
INSERT INTO yom_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yoso nzo bela ku luyakula, buna lukala muna nate luela kuenda. ");
INSERT INTO yom_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kioso buangu bela manga ku luyakula voti kuluwa ; buna muthangu luela botuka vana luba kukumuna mbungi-mbungi yi malu meno. Diodi diela ba kimbangi kuidi bawu. ");
INSERT INTO yom_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Buna bayenda ayi balonga batu ti babalula mavanga. ");
INSERT INTO yom_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bakuka ziphevi ziwombo zimbimbi ayi badukudila bambevo ziwombomafuta ayi baba belusa. ");
INSERT INTO yom_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ntinu Elode wuwa zitsangu zi Yesu, bila dizina diandi ditembakanamu zindambu zioso. Baba tubanga : —Yowani Mbotiki niandi wufulukidi mu bafua ! Diawu kadidi lulendo luvangilabikumu. ");
INSERT INTO yom_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vayi bankaka baba tubanga : —Niandi Eli. Bankaka diaka ti : —Widi mbikudi banga wumosi mu mimbikudi. ");
INSERT INTO yom_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Vayi Elode bu kawa mambu momo, buna wutuba : —Yowani mutu ndizengisa ntu, niandi wufulukidi ! ");
INSERT INTO yom_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Muaki niandi veka Elode wuvana lutumunu mu buila yowani ayi wunkangisa mu zisieni mu nloko mu diambu Elode kakuela Elodiasi nketo nkhombꞌandi Filipi. ");
INSERT INTO yom_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bila Yowani wuba kambanga ntinu Elode : —Wusi ko minsua mu kuela nketo khombꞌaku ! ");
INSERT INTO yom_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Elodiasi wumfuemina ayi wuntombila diluaku di kumvondila. Vayi kasia nunga ko. ");
INSERT INTO yom_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Bila Elode tsisi kaba monanga Yowani bila wuzaba ti Yowani wuba mutu wusonga ayi wunlongo. Diawu kaba ku nkebilanga bumbote. Bu kaba kunwanga buna wuba yindulanga buwombo ayi khini kaba monanga mu kunwa. ");
INSERT INTO yom_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Vayi lumbu kimosi diluaku dimonika mu thangu Elode, mu lumbu ki nyengo wu mbutukulu andi ; kakubika nyengo wunneni wu ndiwulu, wutumisa bapfumu zioso zi leta, bapfumu zioso zi masodi ayi bapfumu zioso zi malamu zunga ki Ngalili muingi biza dia ku nzoꞌandi. ");
INSERT INTO yom_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mu thangu yi nyengo, muana ndumba wu Elodiasi wukota muna nzo, wukina. Wumonisa Elode khini va kimosi ayi batu boso Elode katumisa ku nyengo. Diawu ntinu kakambila muana ndumba beni : —Wundomba kioso tidi, ndieka kuvana kiawu. ");
INSERT INTO yom_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wumvana tsila bu kaleva ndefi ti kioso kuandi wunlomba, yiba kuandi ti ndambu yi kipfumu kiama, ndieka kuvana kiawu ! ");
INSERT INTO yom_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Muana ndumba beni wuyenda yuvula ngudi andi : —A mbi ndomba e ? Ngudi andi wunkamba : —Ntu wu Yowani Mbotiki ! ");
INSERT INTO yom_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Buna muana ndumba wuvika vutuka nsualu kuidi ntinu ayi wunkamba : —Thidi mu nsualu wuphana buabu ntu wu Yowani Mbotiki mu dilonga. ");
INSERT INTO yom_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ntinu wumona kiadi, vayi mu diambu di zindefi zi kaleva ayi batu bobo batumusu ; buna kasia zola kunyimina wawu ko. ");
INSERT INTO yom_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Buna ntinu wufidisa disodi dimosi mu masadi momo maba kunsungangaayi wuntuma kanata ntu wu Yowani. Disodi beni diyenda kuna nloko ayi dizenga ntu wu Yowani. ");
INSERT INTO yom_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Dinata ntu beni mu dilonga ; divana wawu kuidi muana ndumba bosimuana wuyenda wuvana kuidi ngudi andi. ");
INSERT INTO yom_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Minlonguki mi Yowani bu miwa nsamu, miyiza bonga nitu andi, mizika yawu. ");
INSERT INTO yom_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mimvuala mikutakana vaba Yesu ayi mimvumbudila kipholo kimamo bavanga ayi balonga. ");
INSERT INTO yom_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Buna wuba kamba : —Yizanu va lutengo, va buangu kikambulu batu ayi luvunda fioti. Muaki batu bawombo baba kuendanga ayi kuizanga. Diawu basia bakila ko thangu yi dila bidia. ");
INSERT INTO yom_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Diawu bakumina mu nlungu mu kuenda ku lutengo ; va buangu kikambulu batu. ");
INSERT INTO yom_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Batu bawombo baba mona bu bayenda ayi baba bakula. Diawu batu bawombo baba mu mavula bazawula kuna ayi baba tuamina va buangu kioki baba kuenda. ");
INSERT INTO yom_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu bu kakuluka mu nlungu ; wumona nkangu wu batu ; wuba mona kiadi bila baba banga mameme makambulu nsungi. Wutona kuba longa mambu mawombo. ");
INSERT INTO yom_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Buisi buna bueka nduka yila, minlonguki miyiza kunkamba : —Va buangu kikambulu batu tuidi bosi buisi bueka yila. ");
INSERT INTO yom_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Diawu vutula batu baba muingi benda mu ziphagu zi bibulu zitsola ayi mu mala mafikimini mu diambu benda sumbi bidia. ");
INSERT INTO yom_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Vayi Yesu wuba vutudila : —Luba vananu beno veka bidia ! Vayi bawu banyuvula : —Tidi tuenda sumbi mapha ma zikhama zizole zi denali muingi tuba vana badia. ");
INSERT INTO yom_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu wuba yuvula : —Mapha ma kua madi yeno e ? Yendanu lutala. Bu bazaba, buna bankamba : Mapha matanu ayi zimbizi zizole. ");
INSERT INTO yom_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Buna wuvana lutumunu mu vuandisa nkangu wu batu mu makabu, va biti binlangu. ");
INSERT INTO yom_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Batu bavuanda mu makabu ; mankaka khama yi batu, mankaka makumatanu ma batu. ");
INSERT INTO yom_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bosi wubonga mapha beni matanu ayi zimbizi beni zizole, wuvumbulameso ku Yilu, wuvutula matondo ; wubukuna mapha, wuvana minlonguki muingimikabudila nkangu wu batu. Wubuela kabudila zimbizi zizole beni kuidi batu boso. ");
INSERT INTO yom_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Batu boso badia ayi bayukuta. ");
INSERT INTO yom_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Batota kumi bipani biodi biwala mu bitini bi mapha ayi mu zimbizi ziozi zisiadidila. ");
INSERT INTO yom_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Thalu yoso yi batu badia mapha yiba mili tanu yi babakala. ");
INSERT INTO yom_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ku nzimunina Yesu wutuma minlonguki miandi mikuma mu nlungu muingi mintuaminina ku disimu dinkaka di mbu ku ndambu Betisayida ; niandi veka bu kaba vutula nkangu wu batu. ");
INSERT INTO yom_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Buna kamana vutula nkangu buna wuyenda ku mongo mu kuenda sambila. ");
INSERT INTO yom_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Buisi buna bueka yila, nlungu weka va ngingi mbu ; Vayi buna Yesu wukidi niandi veka ku disimu. ");
INSERT INTO yom_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wumona ti minlonguki miandi milembo moni ziphasi ziwombo mu vuila mu diambu di phemo yiba kuba vutula ku manima. Yiba nduka-ndukathangu yinya yi builu. Yesu wuyenda ku baba vayi va mbata mbukaba diatila. Ayi wuzola kuba viokakana. ");
INSERT INTO yom_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Vayi bu bammona wundiatila va mbata mbu, babanzila ti nkuyuayi diawu bayamikinina. ");
INSERT INTO yom_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bila baboso bammona ayi bamona boma. Vayi vana vawu wuba kamba : —Bika luba bukhafi bila minu kuandi ; lubika mona boma. ");
INSERT INTO yom_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bosi wukuma mu nlungu mu baba ayi phemo yilembama. Minlonguki misimina ngolo, ");
INSERT INTO yom_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","bila misia sudika ko tsundu yi kumu ki mapha mu diambu di mintimamiawu miba mi matadi. ");
INSERT INTO yom_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Buna bamana sabuka mbu, batula ku zunga ki Ngenezaleti ; bakanga nlungu va dibongo. ");
INSERT INTO yom_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bu batumbu kuluka mu nlungu, batu babakula Yesu. ");
INSERT INTO yom_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Buna batu beni bayenda nsualu mu zunga kioso. Bannatina bambevo mu biphoyi koso buangu bawa ti kuna kadi. ");
INSERT INTO yom_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mu bibuangu bioso kaviokila yiba mu mala, mu mavula voti mu zitsola batu batula bambevo mu mazandu, ayi, baba nlebanga Yesu muingi kaba vana kaka minsua mu simba kaka tsongi yi nledi andi. Babo bobo basimba wawu babeluka. ");
INSERT INTO yom_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bafalisi ayi ndambu yi minlongi mi mina baba ku Yelusalemi, bayiza kutakana vaba Yesu. ");
INSERT INTO yom_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bamona ti minlonguki miandi minkaka miba dia dipha ayi miokomi mvindu bu dinsundula mioko mikambu sukulu. ");
INSERT INTO yom_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bila Bafalisi ayi Bayuda boso balendi dia ko mu kambu tuama sukulabumbote mioko miawu ; buawu bobo baba kinzikilanga kikhulu ki bakulu bawu. ");
INSERT INTO yom_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ayi enati ku zandu babedi, balendi dia ko enati basi yobila ko. Bifu binkaka biwombo baba bikila kuidi bakulu bawu banga mu phila yisukudila zikopo, mimvungu ayi zinzungu zi bisengo. ");
INSERT INTO yom_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Diawu Bafalisi ayi minlongi mi mina bayuvudila Yesu ti : —A bila mbi minlonguki miaku mikinzikanga ko kikhulu ki bakulubeto e ? Bila mbi beti dila ayi mioko mikambu sukulu e ? ");
INSERT INTO yom_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu wuba vutudila : —Beno luidi bankua mayuya ! Ezayi wubikula bumboti mu diambu dieno. Banga bu disonimina mu minkanda : Batu baba mu tsongi zi bididi kaka beta kunzitisila vayi mintima miawu thama midi ayi minu. ");
INSERT INTO yom_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mu phamba kuandi balembo tsambidila bila malongi balembo longi madi zithumunu zikubuku kuidi batu. ");
INSERT INTO yom_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bila lueti loza Mina mi Nzambi ayi lueti kinzika kikhulu ki batu. ");
INSERT INTO yom_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wubuela ku bakamba diaka : —Beno lueti vunzikisa Mina mi Nzambi muingi lukinzika kikhulu kieno. ");
INSERT INTO yom_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bila Moyize wutuba ti : Kinzika Dise diaku ayi ngudi aku, ayi woso wunsinga dise diandi votingudi andi kafueti baka thumbudulu yi lufua. ");
INSERT INTO yom_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Vayi tala phila lueti tubila : woso wunkamba kuidi dise diandi voti kuidingudi andi ti : “Bima biabi ndiedi kaveni mu kusadisa bidi kolibani, budinsundula dikaba ditambuku kuidi Nzambi”, ");
INSERT INTO yom_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ayi lueti vana minsua kuidi mutu wowo mu kambu sadisa dise diandi ayi ngudi andi. ");
INSERT INTO yom_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Buawu bobo beno lueti vunzikisila Mambu ma Nzambi bu lueti kinzikakikhulu kieno kioki lueti kukilonga ayi lueti vanga mambu mawombo ma phila yoyi. ");
INSERT INTO yom_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu wutumisa diaka nkangu wu batu ayi wuba kamba : —Lungua beno boso ayi lusudika : ");
INSERT INTO yom_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kuisi ko kima kidi ku nganda yi mutu kilenda sumuna mutu bu kikotidi mu khati mutu vayi biobi bieti totuka mu niandi biawu bieti kunsumuna. ");
INSERT INTO yom_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Enati mutu beki matu ma wila buna bika kawa. ");
INSERT INTO yom_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Buna kabotuka vaba nkangu wu batu, Yesu wukota ku nzo ; bunaminlonguki miandi minyuvula muingi kaba kamba tsundu nongo yoyi katuba. ");
INSERT INTO yom_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Buna wuba kamba : —Beno mamveno luisi ko diela e ? Lukadi zaba ti bibioso bidi ku nganda yi mutu bilendi kunsumuna ko bu bikotidi mu niandi. ");
INSERT INTO yom_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bila bikotanga ko mu ntimꞌandi vayi mu vumu binkuendanga bosibintotukanga ku nganda. Mu mambu momo buna Yesu wuvedisa bidia bioso. ");
INSERT INTO yom_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wubuela ku bakamba diaka : —Vayi mantotukanga mu mutu, mawu meti sumuna mutu. ");
INSERT INTO yom_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bila mu khati, mu ntima wu mutu, muawu mueti totukila mayindumambimbi meti nata mutu mu vanga mambu matsoni, mu yiba, mu vonda, ");
INSERT INTO yom_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mu kitsuza, mu nzinunu, mu mambu mambimbi, mu luvunu, mu divunzi, mu kikhenene, ku bifingu, ku luniemo ayi ku mambu ma buvungisi ayi mambimbi. ");
INSERT INTO yom_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mambu moso mama mambimbi mu khati ntima meti ba ayi mawu meti sumuna mutu. ");
INSERT INTO yom_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu bu kabotuka vana, wuyenda mu zunga ki divula di Tile. Buna wukota mu nzo yimosi ayi kasia zola ko ti mutu kazaba. Vayi kasia baka busuamina ko. ");
INSERT INTO yom_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bila nketo wumosi, wuwa zitsangu ziandi ayi wuba ayi muanꞌandiwunketo wuyamusu kuidi pheve yimbimbi, wuyiza ayi wufukama va malu mandi. ");
INSERT INTO yom_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nketo beni wuba muisi Ngelese, wubutukila ku Fenisi didi mu tsi Sili. Wuleba Yesu muingi katotula pheve yimbimbi yiba mu muanꞌandi wunketo. ");
INSERT INTO yom_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Vayi Yesu wumvutudila : —Bika theti bana batuama yukuta ; bila busi fuana ko mu bonga dipha di bana ayi lozila diawu zimbua. ");
INSERT INTO yom_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nketo beni wunkamba : —Nyinga Pfumu, zimbua zidi ku tsi meza zieti dia bitsiedi-tsiedi biobi bana beti dodula. ");
INSERT INTO yom_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Buna Yesu wumvutudila : —Mu diambu di mvutu wowo, yenda kuaku ! Pheve yimbimbi yitotukidi mumuanꞌaku wunketo. ");
INSERT INTO yom_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Bu kavutuka ku nzoꞌandi ; wuyenda bata muanꞌandi buna kalekidi va mbuka, pheve yimbimbi yitotukidingi kuandi. ");
INSERT INTO yom_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu bu kabotuka mu zunga ki Tila, wuviokila mu Sidoni ayi mu Dekapoli bu kayenda ku mbu wu Ngalili. ");
INSERT INTO yom_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bannatina mutu wumosi wufua matu ayi wuba yolukilanga mu phasi. Banleba muingi kantetika mioko. ");
INSERT INTO yom_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu wubotula mutu beni va khatitsika nkangu, wunnata va lutengo, wutula minlembo miandi mu matu ; wulobula madita bosi wusimba ludimilu mutu beni. ");
INSERT INTO yom_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Buna wuvumbula meso ku yilu, wuvumisa ayi wutuba : —Efata ! Bu dinsundula zibuka kuaku. ");
INSERT INTO yom_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Vana vawu matu ma mutu beni mazibuka ; ludimi luandilunianguka ayi wutona tuba bumboti. ");
INSERT INTO yom_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu wuba kandika babika kamba nsamu beni kadi kuidi mutu wumosi. Bu kaluta kuba kandika buna baluta tembikisa wawu. ");
INSERT INTO yom_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nkangu wu batu basimina ngolo ayi batuba : —Mambu moso keti vanga madi mamboti ; weti zibula matu ma batu bafua matuayi weti yolukisa mababa ! ");
INSERT INTO yom_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Muna bilumbu beni, nkangu wu batu bawombo bakutakana. Sumbu basia ba kadi kidia ko, buna Yesu wutela minlonguki miandi ayi wuba kamba : ");
INSERT INTO yom_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Kiadi ndimmona nkangu wu batu baba. Bila bilumbu bitatu bavuandidi yama vava ayi basi kadi kidia ko. ");
INSERT INTO yom_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Enati ndibavutudi ayi nzala mu zinzo ziawu buna maba bua dibutumu nzila bila bankaka thama babedi. ");
INSERT INTO yom_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Minlonguki miandi mimvutudila : —Va buangu kikambulu batu tuidi, buna kuevi tulenda bakila maphamafueni mu dikila nkangu wu batu wawu e ? ");
INSERT INTO yom_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu wuba yuvula : —A mapha makua madi yeno e ? ");
INSERT INTO yom_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Buna Yesu wutumina batu boso bavuanda va tsi ; wubonga tsambuadi di mapha beni, wuvutula matondo, wubukuna mawu ayi wuvana mawu minlongukimiandi ayi miawu mikabudila nkangu wu batu. Buawu bobo mivanga. ");
INSERT INTO yom_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Baba ayi ndambu bina bi zimbizi zifioti zi nlangu. Bu basakumuna biawu wuvana minlonguki miandi muingi mikabudila batu. ");
INSERT INTO yom_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Badia ayi bayukuta. Botota tsambudi di bipani mu bitini biobi bisiadidila. ");
INSERT INTO yom_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Batu babo baba, nduka-nduka mili ya yi babakala. Bosi Yesu wuba vutula. ");
INSERT INTO yom_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Muna thangu beni, Yesu wukota mu nlungu ayi minlonguki miandi, bayenda ku Dalimanuta. ");
INSERT INTO yom_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bafalisi bayiza ayi batona kumfindisa ziphaka. Banlomba dimbu kimosikiba ku Diyilu mu diambu di kuntambila ntambu. ");
INSERT INTO yom_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu wuvumina ayi wutuba : —Bila mbi batu ba tsungi yayi bantombila dimbu e ? Bukiedika ndikulukamba tikadi dimbu kimosi balendi mona ko. ");
INSERT INTO yom_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wu babika, wukuma mu nlungu ayi wuyenda ku disimu dinkaka. ");
INSERT INTO yom_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Minlonguki mizimbakana nata mapha ; dipha dimosi kuandi kaka diba yawu muna nlungu. ");
INSERT INTO yom_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Vayi wuba lubula : —Lukeba ayi luzibula meso mu luvi lu Bafalisi ayi lu Elode ! ");
INSERT INTO yom_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Minlonguki miyuvusana miawu na miawu : —Mu diambu tukambulu mapha diawu kantubila bobo ! ");
INSERT INTO yom_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu wuzaba mayindu mawu ayi wuba yuvula : —Bila mbi lulembo kukiyuvula beno na beno mu diambu lukambulu mapha e ? A beno, lusudikidi ko e ? Ayi lubakudi ko e ? Mintima mieno mikidi banga matadi e ? ");
INSERT INTO yom_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Meso madi yeno vayi lukadi mona e ? Makutu madi yeno vayi lukadi wa e ? Lukadi buela tebuka moyo e ? ");
INSERT INTO yom_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bu ndibukuna mapha matanu mu diambu di mili tanu yi batu, bipani bikua lutota biobi biba biwala mu bitsadisila e ? Bamvutudila : —Kumi bibiodi. ");
INSERT INTO yom_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Bu ndikabula tsambuadi di mapha mu diambu di mili ziya zi batu. A bipani bikua lutota biobi biba biwala mu bitsiadisila e ? Bamvutudila : —Tsambuadi. ");
INSERT INTO yom_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Buna wubuela diaka : —Vayi nate buabu lusudikidi ko e ? ");
INSERT INTO yom_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bu batula ku Betesayida banata phofo kuidi Yesu, banleba muingi kansimba. ");
INSERT INTO yom_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu wusimba phofo beni mu koko, wunnata ku fula di buala, wulobula madita mu meso ma phofo beni ; wuntetika mioko ayi wunyuvula : —Lembo moni kima e ? ");
INSERT INTO yom_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Phofo wutala ayi wuvutula : —Ndimmona batu, banga minti mindiata. ");
INSERT INTO yom_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu wubuela tetika mioko miandi mu meso ma phofo beni. Bosi Phofo weka mona ; wubeluka ayi wumona bumboti bima bioso. ");
INSERT INTO yom_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu wumvutula ku nzoꞌandi. Vayi wunkamba ti : —Kadi kota ku buala. ");
INSERT INTO yom_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ayi minlonguki miandi miyenda mu mala ma Sezale mu Filipi. Mu nzila, wuyuvula minlonguki miandi : —Batu beti tuba ti minu ndidi nani e ? ");
INSERT INTO yom_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bamvutudila : —Bankaka widi Yowani Mbotiki ; bankaka widi Eli, ayi bankaka widiwumosi mu mimbikudi. ");
INSERT INTO yom_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Buna wuba yuvula : —Vayi beno veka lueta tuba ti minu ndidi nani e ? Piela wumvutudila : —Ngeyo widi Klisto. ");
INSERT INTO yom_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Vayi wuba kandika babika yolukila diawu kadi kuidi mutu wumosi. ");
INSERT INTO yom_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bosi wutona kuba longa ti Muana mutu kafueti mona ziphasi ziwombo, bila bakulutu, bapfumu zi zinganga Nzambi, minlongi mi mina, baboso bobobela kunloza ; bela kumvonda vayi bilumbu bitatu bu biela vioka, niandi wela fuluka. ");
INSERT INTO yom_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wuba kamba mambu moso mama mu kambu sueka kadi diambu. Buna Piela wunnata va ndambu ayi wutona kuntubidila. ");
INSERT INTO yom_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Vayi Yesu wubaluka ayi wutala minlonguki miandi, weka ntubidila Piela mu kingolo ti : —Satana ! Botuka va ndidi ! Bila mayindu maku masi ko ma Nzambi vayi ma kimutu. ");
INSERT INTO yom_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu wutumisa nkangu wu batu ayi minlonguki miandi, wuba kamba : —Enati mutu tidi kundandakana buna kafueti kukizimbakana niandi veka vayi kabonga dikulusi diandi ayi kandandakana. ");
INSERT INTO yom_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bila woso tidi keba luzingu luandi wela luzimbisa, vayi woso wela luzimbisa mu diambu diama ayi mu diambu di Nsamu wumboti, wela luvukisa. ");
INSERT INTO yom_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Enati mutu beki nza yimvimba vayi zimbisidi muelꞌandi, buna ndandu mbi kela baka e ? ");
INSERT INTO yom_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Voti mu kima mbi mutu kalenda sombikisa muelꞌandi e ? ");
INSERT INTO yom_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bila woso mutu wukumfuila tsoni ayi wumfuila mambu mama tsoniva khatitsika tsungi yayi yi bankua kitsuza ayi yi bankua masumu, buna muana mutu mamvandi wela kumfuila tsoni mu thangu kela kuiza mu nkembo wu dise diandi va kimosi ayi zimbasi ziandi zinlongo. ");
INSERT INTO yom_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ayi wubuela diaka : —Bukiedika ndikulukamba : batu bankaka badi vava balendi ba fuako nate bela mona Kipfumu ki Nzambi kinkuizila mu lulendo. ");
INSERT INTO yom_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bilumbu bisambanu bu bivioka, Yesu wubonga Piela, Zaki ayi Yowani, wuba nata va bawu veka, va lutengo, va mbata mongo wumosi wunda. Wukituka va ntualꞌawu ; ");
INSERT INTO yom_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","minledi miandi mitona lezama ayi mieka miphembi dio ve. Kuisi ko mutu va ntoto wumvimba beki buvedisila minledi muingi miba phembi yi phila yina ");
INSERT INTO yom_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tumbu zimbukila Eli ayi Moyize baba monikina ; bansolula ayi Yesu. ");
INSERT INTO yom_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Buna Piela wukamba Yesu : —A Nlongi ! Bulutidi mbote tukala kueto vava ! Bika tutunga zinzozitatu zikapu : yimosi mu diambu diaku, yimosi mu diambu di Moyize, yimosi mu diambu di Eli. ");
INSERT INTO yom_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Bukiedika kasia zaba ko diambu dituba bila bawu boso boma baba mona. ");
INSERT INTO yom_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Buna dituti dimosi dimonika ayi diba fuka. Mbembo yimosi yitotuka mu dituti beni, yiwakana : —Niandi, niawu muanꞌama wu luzolo, lunwila ! ");
INSERT INTO yom_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Muna yina thangu, minlonguki bu mitala ku ndambu ayi ndambu misia buela mona Moyize ayi Eli ko vayi Yesu kaka wusiala yawu. ");
INSERT INTO yom_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bu baba nengumuka mongo, Yesu wuba vana lutumunu ti babikakamba mambu mama bamueni kadi kuidi mutu wumosi nate Muana Mutu kelafuluka mu bafua. ");
INSERT INTO yom_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Balunda mambu beni vayi bayuvasana bawu yi bawu tsundu yi “fuluka mu bafua”. ");
INSERT INTO yom_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Buna banyuvula : —A bila mbi minlongi mi Mina mieta tubila ti Eli kafueti tuama kuiza theti e ? ");
INSERT INTO yom_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu wuba vutudila : —Bukiedika Eli kafueti tuama kuiza ayi wela kubika mambu moso. Vayi bila mbi disonimina mu minkanda ti Muana Mutu wela mona ziphasi ziwombo ayi wela sekonono e ? ");
INSERT INTO yom_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Vayi minu ndikulukamba ti Eli wuyiza vayi bamvangila mambu bosobubela luzolo luawu banga bu disonimina mu diambu diandi. ");
INSERT INTO yom_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Buna batula kuba minlonguki ; bamona nkangu wu batu wuba zungidila ayi milembo findana ziphaka ayi minlongi mi Mina. ");
INSERT INTO yom_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Vana vawu nkangu wu batu buna wumona Yesu, wusimina ngolo. Buna batu boso bazawula mu diambu bamvana mbote. ");
INSERT INTO yom_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Buna wuba yuvula : —A diambu mbi lulembo findinina yawu ziphaka e ? ");
INSERT INTO yom_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mutu wumosi wuba muna nkangu wumvutudila : —A Nlongi, ndinatiningi muanꞌama wu bakala widi pheve yi dibaba. ");
INSERT INTO yom_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mu kioso kuandi buangu Pheve yimbimba yawu kumbuila, yeti kuntutumuna ngolo ayi weti totula difulu mu munu ; weti kueta meno, bosi nitu yifueti mana kangama. Khembi minlonguki miaku muingi mikuka pheve beni vayi misi nunga ko. ");
INSERT INTO yom_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu wuba vutudila : —Tsungi yikambulu minu ! Zithangu zikua ndiela kadila yeno va kimosi e ? Zithangu zikua ndiela buela kangila ntima mu bila kieno e ? Lundatina niandi. ");
INSERT INTO yom_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bantuadila muana beni. Pheve yimbimbi bu yitumbu mona Yesu, yitutumuna muana beni ; muana wulumbama va tsi ; muana wumvindumuka va tsi. Difulu dieka ntotuka va munu. ");
INSERT INTO yom_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu wuyuvula dise diandi : —Tona thangu mbi katonina mona ziphasi ziazi e ? Dise diandi divutula : —Tona mu bumuana buandi. ");
INSERT INTO yom_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Zikhumbu ziwombo Pheve beni yimbimbi yeti kunlumba ku mbazu voti mu nlangu muingi yimvonda. Enati wulenda vanga diambu, bunabika wutumona kiadi, wutusadisa ! ");
INSERT INTO yom_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu wumvutudila : —Enati wulenda ! Mambu moso malenda vangama kuidi woso mutu wilukidi ! ");
INSERT INTO yom_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Vana vawu dise di muana diyamikina : —Nguilukidi, wutsadisa mu kambu kuama ku minu. ");
INSERT INTO yom_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu bu kamona ti nkangu wu batu wulundumuka, buna wutemina pheveyimbimbi ayi wutuba : —A Pheve yimbimbi yeti kanga mbembo ayi matu ma muana, minu ndikutumina : Totuka mu muana wawu ayi muisi ko thangu mu buela vutuka mu niandi. ");
INSERT INTO yom_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pheve yimbimbi yiyamikina, yitutumuna muana beni, bosi yitotuka. Muana beni weka banga wufua. Diawu batu boso baba vana batubila : “Yimeni, fuidi.” ");
INSERT INTO yom_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Vayi yesu wunsimba mu koko, wuntedimisa, bosi muana beni wutelama. ");
INSERT INTO yom_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu bu kakota mu nzo, minlonguki miandi mieka kunyuvula va bawu veka : —A bila mbi beto tusi nunganga ko mu kuka pheve yoyo e ? ");
INSERT INTO yom_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu wuba vutudila : —Pheve yi phila yayi yeti totukila kaka mu lusambulu. ");
INSERT INTO yom_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Babotuka muna zunga beni, baviokila ku Ngalili. Yesu kasia zola ko ti mutu ka buzaba ");
INSERT INTO yom_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","bila minlonguki miandi kaba longo ; wuba kamba : —Muana Mutu wela yekolo mu mioko mi batu. Bela kumvonda. Vayi bilumbu bitatu bu biela vioka, wela fuluka mu bafua. ");
INSERT INTO yom_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Vayi minlonguki misia sudika ko tsundu malongi beni, bosi boma miba mona mu kunyuvula biuvu. ");
INSERT INTO yom_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Batula ku Kafalinawumi. Yesu bu kaba muna nzo, buna wuba yuvula : —A mambu mbi lulembo findininanga ziphaka mu nzila e ? ");
INSERT INTO yom_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Baboso baba dio sui ! Bila bu baba mu nzila, bafindasana bawu nabawu ziphaka mu diambu di zaba nani muna badi lutidi munneni. ");
INSERT INTO yom_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu wuvuanda, wutumisa Kumi mimvuala miodi ayi vuba kamba : —Enati mutu tidi ba wutheti, buna kaba wutsuka mu batu boso ayikaba kisadi ki batu boso. ");
INSERT INTO yom_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bosi wubonga muana lezi, wuntelimisa va khatitsikꞌawu. Buna kambonga mu mioko miandi bosi wuba kamba : ");
INSERT INTO yom_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Woso wunyakula muana lezi wuphila yayi mu dizina diama, minu kuandi kayakudi. Ayi woso mutu wundiakudi buna bika sia ti minu kaka kayakudi vayi yakudi diaka mutu wowo wuthuma. ");
INSERT INTO yom_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Bosi Yowani wunkamba : —Nlongi, tumueningi mutu wumosi wuntotula ziphevi zimbimbi mu dizinadiaku vayi tunkandikidingi bila katulandakananga ko. ");
INSERT INTO yom_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu wumvutudila : —Lubika kunkandika, bila kuisi ko mutu weti vanga kumu mu dizinadiama ayi zimbukulu weka kuthubidila mambu mambimbi. ");
INSERT INTO yom_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bila woso wukambu bumbeni kuidi beto buna ku ndambu eto kadi. ");
INSERT INTO yom_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tala, bukiedika ndikulukamba : woso kuandi mutu wukuluvana banza ti kopoyi nlangu mu dizina diama bila luidi batu ba Klisto, kalendi zimbisa ko mfutu andi. ");
INSERT INTO yom_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ayi wubuela tuba ti : —Woso mutu wumbuisa mu masumu wumosi mu bana balezi baba betikunguilukila, bulutidi mboti bankanga, mu tsingu, ditadi dinneni diodi beti nikina zitheti bosi banloza mu mbu. ");
INSERT INTO yom_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Enati koko kuaku kulembo buisi mu masumu buna zenga kuawu bila mboti wukota mu luzingu ayi koko kumosi ayi kuenda ku bulungi, kuidi mbazuyizimanga ko ayi mioko miodi miduka.  ");
INSERT INTO yom_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kuna zimvidi ziawu zilendi fua ko ayi mbazu yilendi zima ko. ");
INSERT INTO yom_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Enati kulu kuaku kulembo buisi mu masumu, buna zenga kuawu bilamboti wukota mu luzingu ayi kulu kumosi ayi mu lozo ku bulungi ayi malu muadi maduka.  ");
INSERT INTO yom_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kuna zimvidi ziawu zilendi fua ko ayi mbazu yilendi zima ko. ");
INSERT INTO yom_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Enati dieso diaku dieti kubuisa mu masumu, buna dovula diawu bila mboti wukota mu Kipfumu ki Nzambi ayi dieso dimosi ayi mu lozo ku bulungi ayi meso muadi maduka ; ");
INSERT INTO yom_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kuna zimvidi ziawu zilendi fua ko ayi mbazu yilendi zima ko. ");
INSERT INTO yom_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Bila kadika mutu wela kitulu lueki mu mbazu banga tsalu bu yinkitudilanga bidia lueki. ");
INSERT INTO yom_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tsalu kima kimboti vayi ti yisiedi ko lueki, buna buevi lulenda vutudila diakalueki luandi e ? Diawu bika luba tsalu mu beno veka ayi zingilanganu mu ndembama beno na beno. ");
INSERT INTO yom_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu wubotuka kuna mu kuenda mu zunga ki Yuda ayi ku ndambu yinkakayi Yolidani. Nkangu wu batu wubuela kutakana va kaba ayi wutona kuba longabanga boso bu kayuku. ");
INSERT INTO yom_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bafalisi bayiza kuidi niandi mu diambu bamfiela, bana banyuvula : —Minsua midi kuidi bakala mu botula nketo andi va makuela e ? ");
INSERT INTO yom_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Niandi wuba vutudila : —Moyize mbi kalutumina e ? ");
INSERT INTO yom_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bankamba ti : Moyize wuvana minsua mu sonika nkanda luvambanu mu vonda dikuela ayi mu kuka nketo andi. ");
INSERT INTO yom_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu wuba vutudila : —Moyize wulusonikina lutumunu lolo mu diambu di mintima mieno midi banga matadi ");
INSERT INTO yom_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","vayi vana thonono Nzambi wubavanga bakala ayi nketo. ");
INSERT INTO yom_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Diawu bakala kela bikila dise diandi ayi ngudi andi mu bundana ayi nketo andi, ");
INSERT INTO yom_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","buna bawu buadi bela kituka nsuni wumosi. Buna basiedi diaka batu buadi ko vayi beka nsuni wumosi kaka. ");
INSERT INTO yom_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Diawu mutu kabika vambisa kibundisa Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bu baba diaka mu nzo, minlonguki minyuvula diaka mu diambu di mambu beni. ");
INSERT INTO yom_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wuba kamba : —Mutu niandi botula nketo andi va makuela ayi kuedidi nketo wunkaka, vengi kitsuza kuidi nketo wutheti. ");
INSERT INTO yom_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bosi enati nketo botukidi va makuela, ayi kuedidi bakala dinkaka, buna vengi kitsuza. ");
INSERT INTO yom_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Banatina Yesu bana balezi muingi kaba tetika nioko vayi minlonguki mitemina batu bobo babanata. ");
INSERT INTO yom_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Vayi bu kamona bobo ; wufuema ayi wuba kamba : —Lubika bana bafioti biza kuidi minu ayi kadi kuba kandika ; bila kipfumu ki Nzambi kivuiwilu kuidi bobo baba dedikini. ");
INSERT INTO yom_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bukiedika ndikulukamba, woso mutu wummanga tambula Kipfumu ki Nzambibanga muana lezi, kalendi baka ko bu kotila mu Kipfumu beni. ");
INSERT INTO yom_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Vana vawu wubonga bana ba lezi, wuba tetika mioko ayi wuba sakumuna. ");
INSERT INTO yom_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bu kaba kuenda, mutu wumosi wuyiza fukama mu nsualu ku ntualꞌandi ayi wunyuvula : —Nlongi wumboti, diambu mbi phanga muingi ndibaka luzingu lukalumani e ? ");
INSERT INTO yom_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu wumvutudila : —Bila mbi wukuthedila wumboti e ? Kuisi ko mutu widi wumboti. Nzambi kaka widi wumboti. ");
INSERT INTO yom_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Vayi ngeyo zebi zithumunu : kadi vonda, kadi vanga kitsuza, kadi yiba, kadi tuba kimbangi ki luvunu, kadi vangila mutu mbimbi, kinzika dise diaku ayi ngudi aku. ");
INSERT INTO yom_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mutu beni wunkembi : Nlongi, ndieti sadila mambu momo tona mu bumuana buama ! ");
INSERT INTO yom_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu wuntala, wunzola ayi wunkamba : —Diambu dimosi kaka dikambulu yaku : yenda, sumbisa bima bioso bidi yaku ayi vana kuidi minsukama. Buna ma wubaka kiuka mu Diyilu, bosi yiza ayi wundandakana. ");
INSERT INTO yom_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bu kamana wa mambu momo, mutu beni wutumbu vonga, wuyenda ayi kiadi mu ntima bila kimvuama kiwombo kiba yandi. ");
INSERT INTO yom_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Buna Yesu wuzungisa thalu mu zindambu zioso ayi wukamba minlonguki miandi : —Didi diambu di phasi kuidi batu bobo badi kimvuama mu kota mu kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Minlonguki misimina buwombo mu diambu di mambu mandi. Vayi Yesu wubuela bakamba : —Bana, ziphasi ziwombo zidi mu kota mu Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bukiedika kadi kuandi phasi kuidi kamela mu viokila va divudu di tsoma vayi bika kuidi mutu widi kimvuama mu kota mu Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Minlonguki misimina ngolo ayi bayuvasana bawu na bawu : —A buna nani wulenda vuka e ? ");
INSERT INTO yom_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu wuba tala ayi wuba kamba : —Kuidi batu malendi baka bu vangiminina ko vayi bika kuidi Nzambi bila kuidi Nzambi mamo malenda vangama. ");
INSERT INTO yom_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Diawu Piela kanyuvudila : —Tala, beto tumana bika bima bioso ayi tulandakana ! ");
INSERT INTO yom_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu wumvutudila : —Bukiedika ndikulukamba, kadi mutu wumosi wubikidi nzo, bakhomba bandi zi babakala, bakhomba bandi zi baketo, ngudi andi ; dise diandi, bana bandi voti zitsola ziandi mu diambu diama ayi mu diambudi Nsamu Wumboti, ");
INSERT INTO yom_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Wela kambu baka mu thangu yayi yi tuidi : zinzo, bakhomba zi babakala ayi zi baketo, zingudi, bana ayi zitsola va kimosi ayi yamusu vioka zikhama zi zikhumbu. Bosi mu thangu yela kuiza, wela baka luzingu lukalumani. ");
INSERT INTO yom_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Vayi batu bawombo mu bobo badi batheti bela ba batsuka, bosi, bobo badi batsuka bela ba batheti. ");
INSERT INTO yom_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bu baba mu nzila mu kuenda ku Yelusalemi, Yesu ku ntuala kaba. Minlonguki misimina, batu bobo baba landakana bamona boma. Buna Yesu wubonga diaka kumi mimvuala miandi miodi ayi wutona kuba kamba mambu momo mafueti kumbuila. ");
INSERT INTO yom_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wuba kamba : —Lutala, tulembo yendi ku Yelusalemi, vayi kuna Muana Mutu kela yekodolo mu mioko mi bapfumu zinganga ayi kuidi minlongi mi Mina. Bela ku nzengila nkanu wu lufua ayi bela ku nyekula mu mioko mi Bapakanu. ");
INSERT INTO yom_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bela kunsekinina, bela kunlobudila madita, bela ku mbeta bikoti ayi bela kumvonda. Vayi bilumbu bitatu bu biela vioka, wela fuluka mu bafua. ");
INSERT INTO yom_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Buna Zaki ayi Yowani, bana ba Zebede, bayiza fikama vaba Yesu, bankamba : —A Nlongi ! Tutidi wutuvangila mambu momo tueka ku lomba. ");
INSERT INTO yom_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wuba yuvula : —A diambu mbi lutidi ndiluvangila e ? ");
INSERT INTO yom_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bamvutudila : —Mu thangu wela ba mu nkemboꞌaku, bika wumosi kaba vuanda va lubakala luaku, wumosi va lumoso luaku. ");
INSERT INTO yom_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Vayi Yesu wuba kamba : —Beno lusi zaba ko mambu momo lunlomba ! Buna beno lulenda nua mbunguyoyi ndiela nua e ? Voti buna lubotimini mbotama yoyi mfueti botama e ? ");
INSERT INTO yom_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bamvutudila : —Tulenda kueto ! Yesu wuba kamba : —Luela nua kueno mbungu yoyi ndikuiza nua ayi luela botama mbotama yoyi ndikuiza botimina ! ");
INSERT INTO yom_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Vayi mu diambu di vuanda va lubakala luama voti va lumoso luama, diodi disi kuthala ko. Bila bibuangu beni bidi mu diambu di batu bobo bakubukulu biawu. ");
INSERT INTO yom_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Thangu kumi di mimvuala minkaka miwa mambu momo, mifuemina Zaki ayi Yowani. ");
INSERT INTO yom_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Bosi Yesu wuba tumisa bawu boso, wuba kamba : —Luzebi ti bobo bammonikanga ti bapfumu zi Bapakanu zieta kuba tuminanga mu kingolo ayi batu bawu baluvalu beti kuba yadila. ");
INSERT INTO yom_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Vayi kuidi beno, buawu ko bufueti bela. Bila woso tidi ba wunneni vakhatitsikꞌeno buna bika kaba kisadi kieno. ");
INSERT INTO yom_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ayi woso tidi ba wutheti buna luidi, bika kaba mvika wu batu boso. ");
INSERT INTO yom_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bila Muana Mutu kasia kuiza ko muingi bansadila vayi wuyiza mu diambudi sadila ayi vana luzingu luandi mu diambu di kula bawombo. ");
INSERT INTO yom_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bosi batula ku Yeliko. Mu thangu Yesu, va kimosi ayi minlonguki miandi ayi nkangu, bu batotuka mu Yeliko buna Balitime, muana bakala wu Time, wuba phofo ayi wuba wuvuanda mu myenda nzila ayi zimbongo kaba lombanga. ");
INSERT INTO yom_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Buna kawa ti niandi nina Yesu muisi Nazaleti, wutona yamikina : —A Yesu ! Muana Davidi, wumbona kiadi ! ");
INSERT INTO yom_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bawombo bantemina muingi kabika biyoko. Vayi niandi wulutabuela yamikina ngolo : —A Muana Davidi ! Wumbona kiadi ! ");
INSERT INTO yom_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu wutelama ayi wutuba : —Luntela ! Batela phofo ayi bakamba : —Ba bukhafi ! Telama ! Ngeyo kantela. ");
INSERT INTO yom_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wuloza yunga kiandi, wutumbu telama, wuyenda nsualu kuidi Yesu. ");
INSERT INTO yom_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu wunyuvula : —Diambu mbi tidi ndivangila e ? Phofo wumvutudila : —A Nlongi, thidi mona ! ");
INSERT INTO yom_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Buna Yesu wunkamba : —Yenda, minu kiaku kibelusidi ! Vana vawu Balitime wumona ayi wulandakana Yesu mu nzila. ");
INSERT INTO yom_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mu thangu bafikama ku Yelusalemi, buna beka nduka tula ku Betifange ayi ku Betani ku ndambu mongo minti mi Olive ; Yesu wutuma minlonguki miandi miodi ayi ");
INSERT INTO yom_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","wuba kamba : —Yendanu ku buala bobo buidi ku ntualꞌeno, beno tula, buna ma lumona muana phunda wukangama, kadi mutu kawudiatidi ko. Lunianguna wawu ayi lutuala wawu. ");
INSERT INTO yom_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Vayi enati mutu wuluyuvudi : “Bila mbi lumvangila bobo e ?”, buna lunkamba : “Pfumu mfunu kawuvuidi”. Buna wela kuwufila nsualu vava. ");
INSERT INTO yom_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bayenda, bamona muana phunda beni buna wukangimini va ndambu muelo, ku nganda, mu yenda nzila. Bawu nianguna. ");
INSERT INTO yom_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Batu bankaka baba vana bayuvula : —A mbi biobi lumvana e ? A mu diambu di mbi luniangunina muana phunda wowo e ? ");
INSERT INTO yom_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bavutula banga boso Yesu kabatumina. Batu beni bababika benda kuawu. ");
INSERT INTO yom_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Banata muana phunda beni kuidi Yesu ; bayala minledi miawu vambata muana phunda beni, ayi, Yesu wuvuanda va mbata muana phunda beni. ");
INSERT INTO yom_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Batu bawombo bayala minledi miawu mu nzila, bankaka bayala matafi maminti momo bazenga mu zitsola. ");
INSERT INTO yom_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Batu bobo baba ku ntuala ayi bobo baba ku mbusa baba yamikinanga : Ozana ! Bika kasakumunu mutu wowo wunkuizila mu dizina di Pfumu ! ");
INSERT INTO yom_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bika kisakumunu Kipfumu kioki kinkuiza, kipfumu ki nkuluꞌeto Davidi Ozana mu bibuangu binzangama. ");
INSERT INTO yom_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu bu kakota ku Yelusalemi, wuyenda mu Nzo Nzambi. Bu kazungisa thalu andi mu bima bioso, wuyenda ku Betani va kimosi ayi kumi minlonguki miandi miodi mu diambu di thangu yeka kielo. ");
INSERT INTO yom_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mu lumbu kilanda, bu batotuka mu Betani, Yesu wumona nzala. ");
INSERT INTO yom_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Buna wukidi thama, wumona nti wumosi wu figi wuba meza mamboti. Wufikama mu tala kani lenda mona muna makundi. Vayi bu kafikama vaba nti, meza na meza kaka kamona, bila yisia ba tsungi yi makundi ma figi ko. ");
INSERT INTO yom_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Buna Yesu wukamba nti wu figi : —Kadi mutu kalendi buela dia dikundi di nti aku ko. Minlonguki miandi miwa bu katuba mambu momo. ");
INSERT INTO yom_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Buna bayetula ku Yelusalemi, Yesu wukota ku luphangu lu Nzo Nzambi, ayi wukuka batu bobo baba sumbisa bima ayi bobo baba sumba bimamuna luphangu lu Nzo Nzambi. Wusengubula zimeza zi batu bobo baba sienzanga zimbongo ayi bikundu bi bobo baba sumbisanga mabembi. ");
INSERT INTO yom_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ayi wukandika ti kadi mutu wumosi kabika buela viokisila mimfuna mu Nzo Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Buna wutona longa ti : —Tala Disia sonama ko ti bela tedilanga nzo ama Nzo yi lusambulu mu diambu di batu boso e ? Vayi beno lukitudi yawu nsuku wu mivi. ");
INSERT INTO yom_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bapfumu zi zinganga Nzambi ayi minlongi mi Mina bu bawamambu momo kavanga, batomba nzila yi kumvondila. Bila boma baba kummonamu diambu di nkangu wu batu boso simina wuba simina mu diambu di malongi mandi. ");
INSERT INTO yom_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bu batula va masika, Yesu ayi minlonguki miandi batotuka mu divula. ");
INSERT INTO yom_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mu nsuka wu lumbu kilanda bu baba viokila vana, bamona nti wufigi wumeni yuma nate muna mianzi. ");
INSERT INTO yom_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piela wutebuka moyo mu mambu mavioka, wukamba Yesu : —A Nlongi ! Tala nti wu figi wowo wusingidi wuyumini ! ");
INSERT INTO yom_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu wuvutula : —Bika minu kieno kiba mu Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Bukiedika ndikulukamba, enati mutu kembi kuidi mongo wawu : “botuka vava, wukilozi mu mbu” ayi enati kakadi memeta mu ntimꞌandivayi wilukidi ti mambu momo kakembi mafueti kaka vangama, buna diambu beni difueti kaka vangama. ");
INSERT INTO yom_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Diawu ndikulukambila ti dioso kuandi diambu di lunlomba mu lusambulu, luwilukila ti lutambudi diawu, ayi, luela mona ti divangimini. ");
INSERT INTO yom_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Vayi mu thangu lutidi sambila enati mutu beki ndiandi diambu, bikakanlemvukila muingi dise dieno didi ku Diyilu niandi mamvandi kalulemvukila mu zinzimbala zieno.  ");
INSERT INTO yom_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Vayi enati lumengi lemvukila, buna dise dieno didi ku Diyilu kalendi kululemvukila ko mu zinzimbala zieno. ");
INSERT INTO yom_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bosi batula diaka ku Yelusalemi. Yesu bu kaba ndiengila mu luphangu lu nzo Nzambi, bapfumu zi zinganga Nzambi, minsoniki ayi bakulutu ba batu bayiza kuidi niandi. ");
INSERT INTO yom_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Banyuvula : —Mu lulendo mbi wulembo vangila mambu momo e ? Ayi nani wuveni lulendo beni e ? ");
INSERT INTO yom_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu wuba vutudila : —Thidi ku luyuvula kiuvu kimosi ; enati lupheni mvutu, buna bosi minu mamvama ndieka kulukamba mu lulendo lu nani ndilembo vangilanga mambu momo. ");
INSERT INTO yom_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nani wuvana Yowani minsua mu botika, Nzambi voti batu e ? Luphana mvutu. ");
INSERT INTO yom_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bayindula, bawu na bawu ayi bakamba : —Enati tukembi ti “Nzambi” buna maka tuyuvula : “Vayi buna bila mbi lukambu kunwilukila e ?” ");
INSERT INTO yom_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Vayi enati tuvutudi ti “Batu”… Batu baba mona boma bilabatu boso bawilukila ti Yowani wuba mbikudi wukiedika. ");
INSERT INTO yom_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Buna bavutudila Yesu ti : —Tuisi zaba ko. Yesu mamvandi wuba vutudila : —Minu mamvama ndilendi kulukamba ko kani mu lulendo lu nani ndilembo vangila mambu mama. ");
INSERT INTO yom_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Buna wutona kuba tubila mu zinongo : —Mutu wumosi wukuna ndima yi vinu ayi wutungila yawu luphangu. Wukaba dibulu dimosi mu kamuninanga makundi ma vinu ayi wutunga nzo yimosi yi banga mu diambu di sunganga ndimꞌandi. Bosi mutu beni wuyekula ndima beni mu mioko mi minkuni muingi miyifutilanga. Bosi wuyenda mu nzietolo. ");
INSERT INTO yom_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Thangu yi mvedolongo mimbutu bu yifuana, buna wutuma kisadi kiandi kimosi kenda landi ndambu makundi mandi ma vinu kuidi bisadi bi ndima. ");
INSERT INTO yom_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Vayi bisadi bi ndima bikanga mutu beni ayi bintuta khuba bosi bimvutula mioko na mioko. ");
INSERT INTO yom_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pfumu yi ndima wubuela tuma kisadi kinkaka. Banlueka ku ntu bosi bamfinga. ");
INSERT INTO yom_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pfumu yi ndima wubuela tuma kisadi kintatu, bamvonda. Bosi wubuela tuma bisadi binkaka biwombo, binkaka bitutu khuba ayi binkaka bivondo. ");
INSERT INTO yom_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pfumu yi ndima wusiala ayi mutu wumosi. Mutu beni muanꞌandi wowoketi luta zola. Ku nzimunina niandi wuba wutsuka mu fidisu bu katuba : “Bela kinzika Muanꞌama”. ");
INSERT INTO yom_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Vayi minkuni mi ndima mikambasana bawu na bawu : “Taleno mutu wowo wela vinginina kiuka, yizanu tumvonda muingi kiuka kikituka kieto.” ");
INSERT INTO yom_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Buna mimbuila, mimvonda ayi minloza ku nganda ndima vinu. ");
INSERT INTO yom_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Buna Pfumu ndima mbi kela vanga e ? Niandi veka wela kuiza, wela vonda minkuni miomi ayi wela defisa ndima beni kuidi minkuni minkaka. ");
INSERT INTO yom_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Lusia tanga ko masonuku mama : Ditadi diodi diloza mintungi, dikituka ditadi di mfunu di fuma ki nzo ");
INSERT INTO yom_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Pfumu niandi wuvanga buawu ayi didi diambu ditsiminanga mu meso meto ! ");
INSERT INTO yom_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Buna batomba diluaku di kangisila Yesu. Bila bazaba kuawu ti bawu Yesu kavekula vayi boma baba mona nkangu wu batu. Diawu basia kumbikila ayi bayenda kuawu. ");
INSERT INTO yom_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Batuma ndambu yi Bafalisi ayi batu ba dikabu di Elode biza kuidi Yesu mu diambu di tomba diluaku di kumbuidila mu mambu momo kalenda tuba niandi veka. ");
INSERT INTO yom_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bayiza kunyuvula : —A Nlongi, tuzebi ti ngeyo kiedika, wumonanga mutu boma ko bila wutalanga bizizi bi batu ko ; weti longa nzila yi Nzambi mu kiedika. Diawu wutukambi, minsua midi mu futa phaku kuidi Sezali voti nana e ? Tufuta voti tubika futa e ? ");
INSERT INTO yom_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Vayi Yesu wuzaba mayuya mawu ayi wuba kamba : —Bila mbi lunkumfiedila e ? Luthuadila denali kimosi muingi ndikitala. ");
INSERT INTO yom_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bannantina kiawu ayi wuba yuvula : —A zizi kinani kiaki ayi bisono biabi bi nani e ? Bamvutudila : —Bi Sezali ! ");
INSERT INTO yom_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Buna Yesu wuba kamba : —Diawu luvana bi Sezali kuidi Sezali ; bi Nzambi kuidi Nzambi. Babo bansimina ngolo. ");
INSERT INTO yom_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bosi Basaduki, batu bobo beti tuba ti bafua balendi fuluka ko, bayiza kuidi Yesu ayi banyuvula : ");
INSERT INTO yom_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Nlongi, Moyize wutusonikina ti Bakala dikuela bu kafuidi, enati kasia buta bana ko, buna khombꞌandi kafueti vinginina nketo wowo kabikidi muingi kabuta bana mu diambu di khombꞌandi wufua. ");
INSERT INTO yom_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Vaba tsambuadi di bakhomba zi babakala, Muana wutheti wukuela nketo, wufua vayi kasia buta bana ko. ");
INSERT INTO yom_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wumuadi wuvinginina nketo beni. Niandi mamvandi wufua, kasia butabana ko. Buawu bobo buvangimina kuidi khomba yintatu, ");
INSERT INTO yom_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","nate tsambuadi yoso bakuela nketo beni, vayi basia buta kadi muanako. Kunzimunina, nketo beni mamvandi wufua. ");
INSERT INTO yom_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Buna mu lumbu kimfulukulu, nketo beni wela ba wunani e ? Bila tsambuadi yoso yinkuela. ");
INSERT INTO yom_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu wuba vutudila : —Lulembo kukivuni. Bila lusi zaba masonoko ko ayi lusi zaba ko lulendo lu Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bila batu bafua bu bela fuluka, batu balendi buela kuelana ko ayi kuedisa ko, vayi bela ba banga zimbasi mu Diyilu. ");
INSERT INTO yom_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Vayi mu diambu di mfulukulu yi bafua, lutengi ko mu buku yi Moyize mu diambu di nti wu zitsendi phila Nzambi kanyolukila ti : Minu ndidi Nzambi yi Abalahami ; Nzambi yi Isaki ayi Nzambi yi Yakobi. ");
INSERT INTO yom_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nzambi kasi Nzambi yi batu bafua ko, vayi Nzambi yi batu badi moyo. Diawu mu nzimbala yinneni luidi ! ");
INSERT INTO yom_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nlongi wumosi wu Mina wuba wa mu thangu baba findasana ziphaka. Bu kamona ti Yesu wuvutudila bumboti Basaduki, wuyiza fikama va kaba, bosi wunyuvula : —Mu Mina mioso, Muina mbi wulutidi mfunu e ? ");
INSERT INTO yom_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu wumvutudila : —Muina wulutidi mfunu wawu wawu : Wa Iseli, Pfumu niandi Nzambi eto, niandi kaka Nzambi ; ");
INSERT INTO yom_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","diawu zola Pfumu Nzambi aku mu ntimꞌaku wumvimba, mu muelꞌakuwumvimba, mu mayindu maku moso ayi mu zingolo ziaku zioso. ");
INSERT INTO yom_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tala Muina wummuadi wudedikini banga wutheti : zola ndiakubanga bu weti kukizodila ngeyo veka. Kuisi ko Muina wunkaka wuviokidi Mina miami. ");
INSERT INTO yom_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nlongi beni wu Mina wumvutudila : —Nlongi, mambu kembi madi makiedika bila Pfumu Nzambi widi wumosi kaka, kuisi ko wunkaka ; ");
INSERT INTO yom_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","zola Nzambi mu ntimꞌaku wumvimba, zola Nzambi mu diela diaku dioso ayi mu zingolo ziaku zioso ayi zola nkundi aku banga bu wukukizodilanga, diviokidi yokila Nzambi dikaba ayi kumvana mintindu mioso mi makaba ma mfunu. ");
INSERT INTO yom_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu wumona ti mu diela kavutudila, diawu kankambila : —Wisi thama ko ayi kipfumu ki Nzambi ! Momo bu mavioka, kadi mutu kasia buela kunyuvula biuvu ko. ");
INSERT INTO yom_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu bu kalonga muna luphangu lu Nzo Nzambi, wuba yuvula : —A buevi minlongi mi Mina mintubilanga ti Klisto Muana Davidi e ? ");
INSERT INTO yom_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Bila niandi veka Davidi bu katuadusu kuidi pheve Yinlongo, wutuba : Pfumu wukamba kuidi Pfumuꞌama vuanda va koko kuama ku lubakala. Nate mbeni tula bambeni ziaku ku tsi bitambi biaku. ");
INSERT INTO yom_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Diawu, enati niandi veka Davidi wuntedila Klisto “Pfumu”, buna buevi kafueti buela bela muanꞌandi e ? Nkangu wu batu wuwila Yesu mu khini. ");
INSERT INTO yom_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wutuba mu malongi mandi : —Lulubukila minlongi mi Mina. Bila bawu khini beti monamu diatilanga mu mazuela manda ayi beti zola baba vaninanga mbotimu bibuangu bidi batu bawombo. ");
INSERT INTO yom_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bayuku vuandilanga mu bibuangu bidi ku ntuala muna zinzozi lukutukunu, ayi mu bibuangu bi nzitusu mu minyengo. ");
INSERT INTO yom_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Vayi beti yiba zinzo zi mafuola ayi beti sambila zitsambulu zinda muingi bamonika kuidi batu. Bela tambula thumbudulu yilutidi ngolo. ");
INSERT INTO yom_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Bosi Yesu wuyenda vuanda va ndambu ; va talana ayi pani ki makaba kiba muna nzo Nzambi. Ayi wuba talanga phila yoyi batu baba tudilanga zimbongo mu pani. Zimvuama ziwombo zitula zimbongo ziwombo. ");
INSERT INTO yom_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ku nzimunina kuyiza nsukami wumosi wu nketo, wuba difuola, wuyiza mamvandi mu vana makaba, wutula kaka bivangi biodi bifioti-fioti. ");
INSERT INTO yom_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Buna Yesu wutela minlonguki miandi ayi wuba kamba : —Bukiedika ndikulukamba, nsukami wawu wu nketo, difuola diadi, niandi lutidi vana zimbongo mu pani viokila batu boso ");
INSERT INTO yom_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","bila batu boso baveni zimbongo, ziosi zibakambulu vua mfunuvayi niandi mu sukama kuandi veni zizioso zibedi yandi ziozi, kafueti zingila. ");
INSERT INTO yom_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu bu katotuka mu Nzo Nzambi, nlonguki andi wumosi wunkamba : —A Nlongi ! Tala matadi mama ma kitoko ayi zinzo zikitoko ! ");
INSERT INTO yom_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu wumvutudila : —Nyinga, tala bumboti zithungulu ziazi ; kadi ditadi dimosi dilendi ba siala ko va mbata ditadi dinkaka, mamoso mela tiolomono. ");
INSERT INTO yom_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bu kavuanda va mbata mongo minti mi Olive, mongo wowo wuntalananga ayi Nzo Nzambi buna Piela, Zaki, Yowani ayi Andele banyuvula va bawu veka : ");
INSERT INTO yom_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Wutukambi thangu mbi mambu beni mela vangimina e ? Bosi dimbu mbi kiela monisa ti thangu yifueti vangimina mambu beni yifueni e ? ");
INSERT INTO yom_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu wutona kuba kamba : —Lukeba luedi vunu kuidi mutu ! ");
INSERT INTO yom_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bila bawombo bela kuizila mu dizina diama buna bela tuba ti : “Minu kuama” ayi bela vuna bawombo. ");
INSERT INTO yom_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mu thangu luela wa zitsangu zi zimvita ayi biyoko bi zimvita bunalubika ba tita ; bila mambu beni mafueti kaka vangama. Vayi yawu ko yela ba tsukulu yi nza. ");
INSERT INTO yom_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bila tsi yimosi yela nuanisa tsi yinkaka, batu ba Kipfumu kimosi belanuanisa batu ba Kipfumu kinkaka ayi ntoto wela nikuka mu bibuangu biwombo. Nzala yela ba yiwombo. Vayi yoyi yela ba kaka thonono yi minsongo. ");
INSERT INTO yom_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Diawu lulubuka mu diambu di beno veka ! Bila bela ku lufunda ku mu ntilubinadu wu Bayuda ayi bela kulu beta bikoti mu nzo zi zikhutukunu, luela samba va ntuala minyadi ayi va ntualamintinu mu diambu diama. Yoyi yela ba nzila mu kuba natina kimbangi. ");
INSERT INTO yom_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Vayi tuamina mamo, Nsamu Wumboti wufueti teka mana longo kuidibatu ba makanda moso. ");
INSERT INTO yom_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Vayi mu thangu luela natu va ntuala bapfumu muingi lusambusu, lubika ba ba mayindu mu diambu di mambu momo luela tuba. Vayi lutuba kaka moso mambu mela lukuizila bila bika sia ti beno luela yoluka, vayi pheve Yinlongo yela yoluka. ");
INSERT INTO yom_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Khomba yela yekula khombꞌandi mu diambu bamvonda ayi dise diela yekula muanꞌandi ; bosi bana bela fuemina bambuta ziawu ayi bela kuba vondisa. ");
INSERT INTO yom_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bosi batu boso bela lulenda mu diambu diama. Vayi woso mutu wela kanga ntima nate kuna tsukulu wela vuka. ");
INSERT INTO yom_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Bu luela mona mbungi telimini va buangu kioki kikalendi telama ko, bika mutu wowo wulembo tangi kasudika, buna boso batu bela batakana mu tsi Yuda, batinina ku miongo. ");
INSERT INTO yom_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Woso mutu widi ku mbata muanzu, kabika kuluka mu nzo ayi kabikamu kota mu diambu di totula ka diambu ko kima kimosi. ");
INSERT INTO yom_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Woso mutu wela batakana mu tsola, kabika buela vutuka ku nzo mu bonga yunga kiandi. ");
INSERT INTO yom_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mabienga mela ba mu bilumbu bina kuidi baketo bela ba mu buemba ayi kuidi bobo bela yemika. ");
INSERT INTO yom_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lusambila muingi mambu beni mabika bela mu tsungi yi kiozi kingolo. ");
INSERT INTO yom_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bila mu bilumbu, bina ziphasi zingolo ziela ba, nkutu ziphasizina zibedi ko tona thonono yi nza ayi ziphasi zi phila yina zilendi buela ba ko. ");
INSERT INTO yom_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Enati Pfumu kasia baka ko lukanu lukufisa bilumbu beni, nganu kadi mutu wumosi kalendi vuka ko. Vayi wukufika biawu mu diambu di batu bobo kasobula. ");
INSERT INTO yom_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Enati mutu wulukembi : “Lutala Klisto widi vava” voti “widi kuna !” Lubika kunwilukila. ");
INSERT INTO yom_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bila ba Klisto baluvunu ayi mimbikudi mi luvunu miwombo mielatotuka ayi bela vanga bidimbu binneni ayi bikumu bitsisi muingi babakabu vunina enati baka bubela batu bobo Nzambi kasobula. ");
INSERT INTO yom_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tala, ndilulubudi. ");
INSERT INTO yom_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ziphasi zi bilumbu beni bu ziela manisa, buna thangu yela tumbu nomba ; ngondi yela zimbisa miezi miandi ");
INSERT INTO yom_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","zimbuetete ziela doduka tona mu diyilu nate va ntoto ayi lulendo lu diyilu luela nikuka. ");
INSERT INTO yom_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Buna bosi bela mona Muana Mutu wela kuizila mu matuti mu lulendo loso ayi mu nkembo wunneni. ");
INSERT INTO yom_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wela tuma zimbasi ziandi mu zitsongi zioso ziya zi ntoto mu kutikisa batu boso bobo Nzambi kasobula va nza yimvimba, tona ku tonina nza nate ku sukinina nza. ");
INSERT INTO yom_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Bika buabu lulonguka dilongi di nti wu figi. Enati matafi mandi mekamalebila ayi matonini totula meza, buna luzebi ti thangu mvula yifikimini. ");
INSERT INTO yom_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Beno mamveno bobuawu, buna luela mona mambu moso momo buna luzaba ti Muana Mutu weka nduka kuiza, banga ti niandi weka va muelo. ");
INSERT INTO yom_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Bukiedika ndikulukamba ti tsungi yayi yilendi kiviokila ko tuamina mambu moso mama mavangama. ");
INSERT INTO yom_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Diyilu ayi ntoto biela vioka vayi Mambu mama malendi vioka ko. ");
INSERT INTO yom_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Vayi mu diambu di thangu voti lumbu kiela vangama mambu beni, kadi mutu wumosi kasi zaba ko ayi zimbasi zisi zaba ko. Ka diambu ko Muana Mutu kasi zaba ko. Niandi veka Tata zebi. ");
INSERT INTO yom_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lulubuka, luleka nkielo ayi lusambila bila lusi zaba ko thanguyela vangimina mambu momo. ");
INSERT INTO yom_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mambu beni mela vangimina banga mutu wubika nzoꞌandi mu kuendamu nzietolo ayi wusia vana minsua kuidi bisadi biandi ; kadika kisadiayi kisalu kiandi. Wusia kamba satinela kasunganga bumboti. ");
INSERT INTO yom_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Diawu beno mamveno, luleka nkielo. Bila lusi zaba ko thangumbi yela vutukila pfumu nzo : kani va masika, kani va midi miphipa votiva thangu yinkokulanga tsusu, voti, va nsuka. ");
INSERT INTO yom_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bila buisi fuana ko kiza lubati buna luledi tulu enati niandi wizidi mu kinzimbukila. ");
INSERT INTO yom_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mambu mama ndilukembi, khembi mawu kuidi batu boso. Luleka nkielo. ");
INSERT INTO yom_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Buna bilumbu biodi bisiala muingi nyengo wu Pasika wuba ayi nyengo wowo Bayuda baba dianga mapha makambu siwu luvi. Bapfumu banganga Nzambi ayi minsoniki baba tombanga buevi balenda kangila Yesu mu luvunu muingi bamvonda. ");
INSERT INTO yom_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bila batuba : —Tubika bu vanga mu thangu yi nyengo, muingi khindu yibika bua mu batu. ");
INSERT INTO yom_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu bu kaba ku Betani, ku nzo Simoni mutu wowo wuba kimbevo ki buazi ; mu thangu kaba va meza, nketo wumosi wuyiza ayi bungu kimosikivangulu mu ditadi di alabatele kiwala malasi ma nale makambu sobukusu, maba malasi mathalu. Wubula ntu wu bungu beni ayi wudukula malasiku ntu Yesu. ");
INSERT INTO yom_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Batu bankaka baba vana basia mona ko khini diawu baniungutila bawu na bawu : —Bila mbi bunga malasi momo e ? ");
INSERT INTO yom_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nganu mboti mu sumbisa mawu viokila zikhama zitatu zidenali, bosi vana zimbongo beni kuidi minsukami. Diawu batubidila buwombo nketo beni. ");
INSERT INTO yom_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Vayi Yesu wuba kembi : —Lumbikanu ! Bila mbi lulembo kummonisina phasi e ? Diambu kaphangidi didi diambu di mboti. ");
INSERT INTO yom_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bila minsukami mikala kuandi yeno mu zithangu zioso ayi lulenda kueno kuba vangila mamboti mu zithangu zioso zilutidi, vayi minu ndilendi kuiza kalanga ko yeno mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nketo wawu vengi diambu kalenda vanga ; wukivindidi nituꞌama malasi mu diambu di kubika nzikuluꞌama. ");
INSERT INTO yom_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Bukiedika ndikulukamba ti muamo muela longo Nsamu Wumboti va nza yimvimba, diambu divengi nketo wawu diela yolokolongo ayi diela tebokolongo moyo mu diambu diandi. ");
INSERT INTO yom_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Buna, wumosi mu kumi mimvuala miodi, dizina diandi Yuda Isikalioti, wuyenda kuidi bapfumu zi zinganga Nzambi muingi kasumbisa Yesu. ");
INSERT INTO yom_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bu bawa bila kikayizila, bamona khini ayi bamvana tsila yi kumvana zimbongo. Diawu kaba tombilanga diluaku difuana di kuba yekudila Yesu. ");
INSERT INTO yom_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mu lumbu kitheti ki nyengo wu mapha makambu tulu luvi, lumbu kioki beti vonda muana dimemi mu dia mu Pasika, minlonguki minyuvula : —Kuevi tidi tuenda kubikila ndiwulu yi Pasika e ? ");
INSERT INTO yom_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Buna wufidisa minlonguki miandi miodi ayi wuba kamba : —Yendanu ku divula, maludengana mutu wumosi neti mvungu wunlangu, buna lunlandakana. ");
INSERT INTO yom_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yoso nzo yika nkota buna lukamba kuidi pfumu yi nzo beni ti : “Nlongi wututumini muingi tuyuvula : Kuevi kuidi vinga kiama kiokimfueti dila Pasika ayi minlonguki miama e ?” ");
INSERT INTO yom_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Buna ma kalumonisa vinga kidi ku yilu banga ; vinga beni kikubuku ayi kidi kinneni. Kuawu ma luvangila khubukulu mu diambu dieto. ");
INSERT INTO yom_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Minlonguki miandi miyenda. Mitula ku divula ayi miyenda bata mamo banga bu kambila Yesu. Bosi mikubika bidia bi Pasika. ");
INSERT INTO yom_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mu thangu masika, Yesu wuyiza ayi kumi mimvuala miodi. ");
INSERT INTO yom_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mu thangu baba dia va meza, Yesu wuba kamba : —Bukiedika ndikulukamba ti buna luidi vava mutu wumosi mu beno, mutu wowo wundia yama va kimosi, weka kunduekula. ");
INSERT INTO yom_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Baboso beka mona kiadi, wumosi-mosi weka kunyuvula : —Buna minu e ? ");
INSERT INTO yom_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu wuba vutudila : —Wumosi mu kumi mimvuala miodio ; mutu wowo wumbuika tini kiandi va kimosi mu dilonga ayi minu. ");
INSERT INTO yom_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bila Muana mutu wulembo yendi banga busonimina mu masonuku mu diambu diandi vayi mabienga kuidi mutu wowo wunkumvakula ! Nganu bufueni kuidi mutu beni mu kambu kuandi butuka. ");
INSERT INTO yom_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mu thangu baba dia, Yesu wubonga dipha wudisakumuna, wudibukuna mu bitini ayi wuvana minlonguki miandi ayi wuba kamba : —Bonganu, yayi yawu nituꞌama. ");
INSERT INTO yom_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bosi wubonga mbungu, wuvutudila Nzambi matondo, wuba vana yawu. Bawu boso banua. ");
INSERT INTO yom_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Buna wuba kamba : —Mama mawu menga mama, menga ma Nguizani, madukulu mu diambu di batu bawombo. ");
INSERT INTO yom_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Bukiedika ndikulukamba ti ndilendi buela ko nua vinu nate mu lumbu kioki ndiela nua vinu mu phila yinkaka mu Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bu bamanisa yimbila nkunga. Batotuka mu kuenda ku mongo minti mi olive. ");
INSERT INTO yom_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu wuba kamba : —Beno boso luela nikunu mu minu bila disonama ti : Ndiela beta nsungi mamemi ayi mamemi moso mela mana tiakana. ");
INSERT INTO yom_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Vayi bu ndiela fuluka, ndiela ku lutuaminina ku Ngalili. ");
INSERT INTO yom_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piela wunkamba : —Ka diambu ko baboso bela nikunu mu minu vayi minu ndilendi ko. ");
INSERT INTO yom_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu wumvutudila : —Bukiedika ndikukamba, buabu kuandi va builu, sumbu tsusu yinkuiza kokula mu zikhumbu zizole, ngeyo mawu thunukina mu zikhumbu zitatu ! ");
INSERT INTO yom_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Vayi Piela wuvutula mu ngolo : —Ka diambu ko ; fua, ndifua yaku vayi ndilendi kutunuka ko. Baboso phila yimosi batubila. ");
INSERT INTO yom_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bosi batula ku buangu beti tedila Ngetesemane. Yesu wukamba minlonguki miandi : —Lukala vava minu, ndiedi ku sambila. ");
INSERT INTO yom_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wunata Piela, Yowani ayi Zaki. Wutona mona kiadi ayi maniongo. ");
INSERT INTO yom_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Bosi wuba kamba : —Muelꞌama weka kiadi nate nduka mu fua. Lusiala vava ; luleka nkielo. ");
INSERT INTO yom_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wuyenda thama fioti, wufukama ayi wuyinika zizi mu tsi, wusambila Nzambi ti baka bubela muingi thangu yoyi yintatukila. ");
INSERT INTO yom_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Buna wutuba : Aba ! Tata ! Kuidi ngeyo mambu moso malenda vangama. Thatudila mbungu yayi. Muaki bika sia ti boso bunzodidi vayi boso bu zodidi ! ");
INSERT INTO yom_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wuvutuka vaba minlonguki miandi. Wuyenda babata balembo lekitulu. Buna wukamba Piela : —A Simoni, wulembo leki e ? Wusi nunga ko mu leka nkielo mu thangu yimosi ko e ? ");
INSERT INTO yom_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Luleka nkielo ayi lusambila muingi luedi bua mu phukumunu. Bila pheve yidi ayi luzolo lu mboti vayi nitu yidi yilebakana. ");
INSERT INTO yom_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wuyenda diaka ayi wubuela sambila lusambulu banga lolo katuama sambila. ");
INSERT INTO yom_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bu kavutuka diaka, wuyiza buela babata buna balekidi bila mesomatulu maba yawu. Basia baka diambu di nkumvutudila ko. ");
INSERT INTO yom_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bu kavutuka mu khumbu yintatu, wuba kamba ti : —Lukidi leka ayi lulembo vundi e ? Bufueni. Thangu yifueni. Muana Mutu yekolo mu mioko mi bankua masumu. ");
INSERT INTO yom_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Telamanu ! Tuendianu ! Bila mutu wowo wukundiekula fikimini. ");
INSERT INTO yom_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Buna kamanisini ko yoluka, tala Yuda, wumosi mu kumi mimvuala miodiwuyiza va kimosi ayi nkangu wu batu banata zimbedi ayi zimbondo, batumu kuidi bapfumu banganga Nzambi, minsoniki ayi kuidi bakulutu ba Bayuda. ");
INSERT INTO yom_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda, mutu wuyekula Yesu, wuba vana dimbu kiaki : —Woso mutu ndikuiza fifi besi buna niandi ; lufueti kanga ayi lunnata bumboti. ");
INSERT INTO yom_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda bu katula, wufikama vaba Yesu bosi wuntela : “A mueni Nlongi !” Bosi wumfifa besi. ");
INSERT INTO yom_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Buna bosi bambuila ayi bankanga. ");
INSERT INTO yom_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Vayi mutu wumosi mu bawu baba vana, wutotula mbedi andi, wuzuba kisadi kimosi ki pfumu yi zinganga Nzambi ayi wunzenga dikutu. ");
INSERT INTO yom_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu wuba yuvula : —Ndieka dovula muingi luiza khangi ayi zimbedi ayi zimbondo zi minti mu mioko e ? ");
INSERT INTO yom_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Keti bilumbu bioso ndibedi kalanga yeno va kimosi, ndibedi longangamu Nzo Nzambi ayi lusia kukhanga ko. Vayi mambu moso mama mavangimini mu diambu di dedikisa masonuku. ");
INSERT INTO yom_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mu thangu beni, baboso basia kumbika ayi batina. ");
INSERT INTO yom_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ditoko dimosi divuata kaka diphiya di nledi, niandiwunlandakana. Bu bankanga, ");
INSERT INTO yom_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wuyekula diphiya beni ayi pheni nkua katina. ");
INSERT INTO yom_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Banata Yesu kuidi pfumu yi banganga Nzambi, kuna ku kutakana bapfumuzioso zi banganga Nzambi, bakulutu ba dibundu ayi minsoniki. ");
INSERT INTO yom_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piela wunlandakana kuna manima, nate ku luphangu lu pfumu yi banganga Nzambi. Wuvuanda va kimosi ayi minsungi va muenda mbazu yi bayota. ");
INSERT INTO yom_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bapfumu banganga Nzambi ayi batu boso ba lukutukunu lunneni batomba kimbangi mu diambu di Yesu muingi babaka bila ki kumvondisila vayi basi baka ko. ");
INSERT INTO yom_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bila bawombo batuba bimbangi bi luvunu mu diambu diandi, vayibimbangi beni bisia dedakana ko. ");
INSERT INTO yom_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Buna ndambu yi batu bankaka batelama mu telama kimbangi ki luvunu, bawu bakamba : ");
INSERT INTO yom_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Tunwa bu katuba ti : “Ndiela tiolumona Nzo Nzambi yayi yitungulu mu mioko mi batu vayi mu bilumbu bitatu, ndiela tungayinkaka yoyo yela kambu tungulu mu mioko mi batu.” ");
INSERT INTO yom_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Vayi ka diambu ko batuba bobo, bimbangi biawu bisia dedakana ko. ");
INSERT INTO yom_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Buna pfumu yi banganga Nzambi wutelama va khatitsika batu boso ; wuyuvula Yesu : —Kadi diambu wukadi vutula e ? Kimbangi mbi kioki batu baba balembo kutelimina e ? ");
INSERT INTO yom_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Vayi Yesu kasia vutula kadi diambu ko. Pfumu yi banganga Nzambi wunyuvula diaka : —Ngeyo widi Klisto, Muana wu mutu wowo wusakumunu e ? ");
INSERT INTO yom_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu wumvutudila : —Nyinga, ndidi Klisto ! Ayi luela mona Muana Mutu vuendi va koko ku lubakala lu Nzambi, nkua lulendo boso ayi luela mona phila kela kuizila mu nkembo mu matuti. ");
INSERT INTO yom_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Buna Pfumu yi banganga Nzambi, wukanzuna minledi miandi ayi wukamba : —Bila mbi tufueti buela tombila bambangi bankaka e ? ");
INSERT INTO yom_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Beno veka luwilu phila kavuezidi Nzambi. Beno buevi lumbanzila e ? Babo banzengila nkanu wu lufua. ");
INSERT INTO yom_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Buna bankaka banlobudila madita, bamfukidila busu bosi banzuba zikhomi ayi bankamba : —A ngeyo, bikula e ! Bosi minsungi minnata ayi mimbeta. ");
INSERT INTO yom_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mu thangu Piela kaba ku ndimba, ku khati luphangu, kisadi kimosi ki nketo kiba nsalanga kuidi pfumu yi banganga Nzambi kiyiza. ");
INSERT INTO yom_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bu kamona Piela wunyota mbazu, wunsungamana mboti ayi wukamba : —Ngeyo Mamvaku bedingi va kimosi ayi Yesu muisi Nazaleti ! ");
INSERT INTO yom_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Vayi Piela wutunuka kuandi ayi wukamba : —Ndisi zaba ko ayi ndikadi sudika mambu momo wuntuba. Bosi wutotuka ku nganda, wuyenda telama ku ndambu muelo wu luphangu. Muna thangu beni tsusu yikokula. ");
INSERT INTO yom_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kisadi beni ki nketo bu kamona diaka Piela, weka kamba batu bobo baba vana : —A beno ! Mutu wowo widi wumosi mu batu bana ! ");
INSERT INTO yom_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Vayi Piela wubuela tunuka diaka. Buela kala fioti, batu bobo baba vana, bakamba Piela : —Bukiedika ti ngeyo widi wumosi mu batu bobo bila widi muisi Ngalili. ");
INSERT INTO yom_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Buna wutona kukitombila tsingulu ayi wuleva ndefi ti : —Ndisi zaba ko mutu wowo lulembo yolukila. ");
INSERT INTO yom_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Muna thangu beni, tsusu yikokula mu khumbu yimmuadi. Bosi Piela keka ntebukila moyo mambu makamba Yesu ti : “Sumbu tsusuyinkuiza kokula mu zikhumbu zizole, ngeyo mawu thunukina mu zikhumbu zitatu.” Bu kayindula bobo buna wudila ngolo. ");
INSERT INTO yom_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Muna nsuka bapfumu banganga Nzambi, bakulutu ba dibundu, minlongi mi Mina ayi batu babo ba lukutukunu lunneni bakutakana. Bakanga yesu, bannata ayi banyekula mu mioko mi Pilatu. ");
INSERT INTO yom_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatu wunyuvula : —Ngeyo widi Ntinu wu Bayuda ? Yesu wumvutudila : —Ngeyo veka tubidi buawu ! ");
INSERT INTO yom_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bosi bapfumu banganga Nzambi zimvubudila mambu mawombo. ");
INSERT INTO yom_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatu wunyuvula diaka : —Wulendi vutula kadi diambu ko ? Wulembo wi mambu momo balembo kumfundila ? ");
INSERT INTO yom_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Vayi Yesu kasia vutula diaka kadi diambu dimosi ko. Buna Pilatu wusimina ngolo. ");
INSERT INTO yom_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kifu kiba yawu mu thangu nyengo, Pilatu wuba totulanga mutu wumosi mu nloko, woso mutu wuba nlombongo kuidi batu. ");
INSERT INTO yom_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Vayi mutu wumosi wuba mu nloko, dizina diandi Balabasi, wukangu va kimosi ayi bakundi bandi bu batotula khindu. Muna khindu beni bavondila mutu. ");
INSERT INTO yom_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nkangu wu batu wuyamikina, wunlomba kavanga banga bobo keta ku bavangilanga. ");
INSERT INTO yom_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatu wuba yuvula : —Lutidi ndilutotudila Ntinu wu Bayuda e ? ");
INSERT INTO yom_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bila wuzaba mboti ti bapfumu banganga Nzambi zinyekudila Yesumu diambu di kikhenene. ");
INSERT INTO yom_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Vayi bapfumu banganga Nzambi zikambisila nkangu wu batu ti wulomba katotula Balabasi. ");
INSERT INTO yom_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatu wuba yuvula e ? —A vayi mbi lutidi phangila mutu wowo luntedilanga ntinu wu Bayuda ? ");
INSERT INTO yom_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Babo babuela yamikina : —Wumbanda va dikulusi ! ");
INSERT INTO yom_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatu wuba yuvula : —Diambu mbi di mbimbi kavengi e ? Vayi baluta yamikina ngolo : —Wumbanda va dikulusi ! ");
INSERT INTO yom_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatu wuzola monisa nkangu wu batu khini, diawu kabatotudila Balabasi. Bu kamana zubisa Yesu bikoti ayi wuba yekudila niandi muingi bambanda va dikulusi. ");
INSERT INTO yom_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Masodi manata Yesu ku luphangu, buangu kioki beti sambisila batu, bakutikisa masodi moso. ");
INSERT INTO yom_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bamvuika yunga kimbuaki. Buna bamana vanga phu ki kipfumu ki zitsendi ; bamvuika kiawu ku ntu. ");
INSERT INTO yom_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Buna bamvana mboti : —Mbote, ntinu wu Bayuda ! ");
INSERT INTO yom_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Baba kunzubanga nti ku ntu, banlobudila madita ayi bamfukiminaayi baba kumvananga minzitusu. ");
INSERT INTO yom_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Buna bamana kunsekinina, bamvula yunga beni kimbuaki ayibamvuika minledi miandi ; bosi bannata ku nganda muingi bambanda va dikulusi. ");
INSERT INTO yom_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mutu wumosi muisi Silene, dizina diandi Simoni, dise di Alekizandele ayi Lufusi, wuba ku nsitu. Vioka kuandi kaba mviokila mu nzila beni. Vayi masodi buna mammona, mankuika kanata dikulusi di Yesu. ");
INSERT INTO yom_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Banata Yesu va buangu kintedulungu “Ngolongota”. Tsundu Ngolongota “buangu ki mvesi wu ntu.” ");
INSERT INTO yom_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kuna bamvanina vinu kisobokoso ayi mila muingi kanua, vayi kasia kinua ko. ");
INSERT INTO yom_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bu bambanda va dikulusi, bakabana minledi miandi, babudila miawutsombo mu diambu di zaba miomi kadika mutu kafueti tambula. ");
INSERT INTO yom_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yiba nduka-nduka thangu yi vua yi nsuka mu thangu bambanda va dikulusi. ");
INSERT INTO yom_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tini ki dibaya kisonama bila kioki bamfundila, kisonama mambu mama : “Ntinu wu Bayuda”. ");
INSERT INTO yom_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bidovula biodi bibandu mu makulusu va kimosi ayi Yesu ; wumosi ku koko ku lubakala, wunkaka ku koko ku lumoso.  ");
INSERT INTO yom_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Buawu bobo budedikinina mambu momo masonama mu Minkanda : “Bantula mu nkangu wu batu bambimbi.” ");
INSERT INTO yom_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Batu bobo baviokila vana, bamfinga, banikuna mintu ayi bakamba : —E e ngeyo ! Ngeyo wuntiolumunanga Nzo Nzambi ayi wukuyitungilanga mu bilumbu bitatu ! ");
INSERT INTO yom_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Wukivukisa ngeyo veka ; bosi kuluka va dikulusi ! ");
INSERT INTO yom_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bapfumu banganga Nzambi ayi minlongi mi mina mamvawubansekinina. Bakambasana bawu na bawu : —Wuvukisidi batu bankaka vayi niandi veka kalendi kukivukisa ko ! ");
INSERT INTO yom_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Bika Klisto ntinu wu Iseli kakuluka buabu va dikulusi muingi tumona ayi tuwilukila ! Bobo babandu yandi va dikulusi, mamvawu bamfinga. ");
INSERT INTO yom_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mu thangu midi, tombi kibua mu tsi yimvimba, kizingila natemu thangu yi ntatu yi masika. ");
INSERT INTO yom_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","—Mu thangu yintatu, Yesu wuyamikina mu ndinga yingolo : —Eloyi, Eloyi, lama sabakatani ! Bu dinsundula : Nzambi ama ! Nzambi ama ! Bila mbi wundiekudi ! ");
INSERT INTO yom_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Batu bankaka baba vana bu bawa bobo batuba : —Tala Eli kantela. ");
INSERT INTO yom_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wumosi wuzawula ayi wuyenda buika tini ki eponzi mu vinu ki ngami, wukisomika va tsongi nti ayi wutambika Yesu muingi kanua ; bu katuba : —Bika, tutala kani Eli makiza nkulula. ");
INSERT INTO yom_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Vayi Yesu wuyamikina ngolo ayi wuzenga vumunu. ");
INSERT INTO yom_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Muna thangu beni lido yi Nzo Nzambi yikanzuka mu zindambuzizole ; tona ku yilu nate ku tsi. ");
INSERT INTO yom_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nkulutu wu masodi, wutalana ayi Yesu, bu kamona ti wutabukavumunu mu yamikina bobo, buna wutuba : —Bukiedika, mutu wawu bedi Muana Nzambi ! ");
INSERT INTO yom_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Vaba diaka ayi ndambu yi baketo baba ntadilanga ku thama. Mu bawu muba : Maliya muisi Mangadala, Maliya ngudi yi Zaki di nleki wu Yose ayi ngudi yi Salome. ");
INSERT INTO yom_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bawu baba kunlandakananga, baba kunsadisanga mu thangu kaba ku Ngalili. Baketo bankaka bawombo bayiza yandi va kimosi ku Yelusalemi baba vana. ");
INSERT INTO yom_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mu thangu masika, mu lumbu ki khubumunu, buna lumbu kimosi kisiedimuingi lumbu ki saba kiba. ");
INSERT INTO yom_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Zozefi muisi Alimate wuyiza. Wuba mutu wunneni mu lukutukunu lunneni lu Bayuda. Niandi mamvandi wuba vingilanga ndizulu yi Kipfumu ki Nzambi ; wuyenda mu bukhafi boso kuidi Pilatu mu kunlomba nitu yi Yesu. ");
INSERT INTO yom_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatu wusimina bu kawa ti Yesu fuidingi. Buna wutumisa pfumu yi masodi ayi wunyuvula keni thama kafuidingi. ");
INSERT INTO yom_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bu kawa buawu kuidi pfumu yi masodi, buna wuvana Zozefi minsua mu bonga nitu yi Yesu. ");
INSERT INTO yom_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zozefi bu kasumba dikendi diphembi di thalu, wubotula mvumbi yi Yesu va dikulusi, wuyizinga va dikendi beni bosi wuyizika mu ziami kisokolomu ditadi ; wunengumuna ditadi vana muelo ziami. ");
INSERT INTO yom_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya muisi Mangadala ayi Maliya ngudi yi Yose bamona buangu kioki bantula. ");
INSERT INTO yom_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lumbu ki saba bu kivioka, Maliya muisi Mangadala, Maliya ngudi yi Zaki ayi Salome, basumba malasi ma vinda mu nitu Yesu ; ");
INSERT INTO yom_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bayenda ku biziami mu lumbu kitheti ki sabala buna buisi bukiedi ko bumboti. Bayenda buna thangu yeka ntotuka. ");
INSERT INTO yom_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bayuvasana bawu na bawu mu nzila : —Nani wukuiza tunengumunina ditadi didi va muelo wu ziami e ? ");
INSERT INTO yom_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Vayi bu bamvumbula meso, bamona ti ditadi diodi diba dinneni dinengumunu va ndambu. ");
INSERT INTO yom_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bakota muna ziami beni, bamona ditoko dimosi divuata minledi miphembi buna kavuendi va ndambu koko ku lubakala. Baketo beka mona boma. ");
INSERT INTO yom_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Vayi ditoko beni diba kamba : —Bikanu mona boma ! Yesu muisi Nazaleti wubendu va dikulusi luntomba e ? Kasiedi vava ko ! Fulukidi ! Talanu buangu kioki bantula. ");
INSERT INTO yom_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vayi tumbu yendanu, lukamba minlonguki miandi ayi Piela, ti niandi wulutuaminini ku Ngalili. Kuna luela kummona, banga kuandi bobo kalukambila. ");
INSERT INTO yom_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Batotuka nsualu mu ziami ayi bazawula. Boma ayi lukhuku bibabuila. Kadi diambu dimosi basia kamba ko kadi mutu bila boma baba mona. ");
INSERT INTO yom_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu bu kafuluka mu nsuka wu lumbu kitheti ki sabala, wutuamamonikina theti Maliya muisi Mangadala, nketo wowo kakuta ziphevi tsambuadi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Niandi wuyenda kamba nsamu beni kuidi bobo baba landakananga Yesu, bobo baba mu kaniki ayi baba dila. ");
INSERT INTO yom_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Vayi bawu bu bawa ti Yesu widi moyo ayi monikini Maliya, basia kunwilukila ko. ");
INSERT INTO yom_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Momo bu mavioka, wumonikina minlonguki miodi mu lunitu lunkaka bu baba diengila mu tsi. ");
INSERT INTO yom_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bavutuka ayi bakamba mambu beni kuidi batu bankaka vayi basia ku bawilukila ko. ");
INSERT INTO yom_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bosi, wubuela monikina diaka kumi mimvuala wumosi mu thangu baba va meza. Wuba tubidila mu diambu di kambu kuawu ku minu ayi mu diambu baba mintima miba banga matadi, bila basia wilukila ko batu bobobammona ti fulukidi mu bafua. ");
INSERT INTO yom_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Buna wuba kamba : —Yendanu mu nza yimvimba, longanu Nsamu wumboti kuidi batu boso. ");
INSERT INTO yom_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Woso mutu wela wilukila ayi wela botama, wela vuka. Vayi woso wela kambu wilukila, wela zengolo nkanu. ");
INSERT INTO yom_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tala bidimbu biobi biela landakana batu bobo bela wilukila ; mu dizina diama : bela kuka ziphevi zimbimbi, bela yoluka zimbembo banzenza ; ");
INSERT INTO yom_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bela simba zinioka ayi enati banuini yimbu kadi buma kiela ba vavanga ko. Bela tetikila bambevo mioko ayi ziela beluka. ");
INSERT INTO yom_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesu bu kamana bakamba mambu momo, wutombolo ku Diyilu, wuyenda vuanda va koko ku lubakala lu Nzambi. ");
INSERT INTO yom_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bosi minlonguki miyenda, balonga Nsamu wumboti va nza yimvimba. Pfumu wusala yawu va kimosi mu kisalu beni ayi wukindisa malongi mawu mu bikumu biobi biba landakananga malongi mawu.");
INSERT INTO yom_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Sumbu batu batona sonika mambu momo mavioka va khatitsikꞌeto ; ");
INSERT INTO yom_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","banga bubatukambila mawu kuidi batu bobo baba bambangi bamona mesotona vana thonono ayi baba bisadi bi mambu ma Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","A mueni Tewofile, ndimona ti didi dimbote, sumbu ndifiongunina bumbotemambu moso tona vana thonono mu kusonikina mawu boso bu malandikinini ");
INSERT INTO yom_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","muingi wuzaba kiedika ki mambu momo wulongu. ");
INSERT INTO yom_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mu thangu Elode kaba ntinu mu Yuda, muba ayi nganga Nzambi yimosi, dizina diandi Zakali. Niandi wuba mu dikabu di Abia ayi nketo andi Elizabeti wuba mu nkuna Aloni. ");
INSERT INTO yom_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bawu buadi baba batu basonga va meso ma Nzambi ayi baba kinzikangazithumunu zioso ayi mina mioso mi Pfumu mu kambu tsembolo. ");
INSERT INTO yom_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Basia buta bana ko bila Elizabeti wuba sita ayi bawu buadi baba banuna ngolo. ");
INSERT INTO yom_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lumbu kimosi Zakali kaba sala kisalu kiandi ki kinganga Nzambi va ntuala Nzambi bila yiba thangu yi dikabu diandi ; ");
INSERT INTO yom_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","landila bu bela kifu ki zinganga Nzambi, niandi wubuilu tsombo mu kota mu vinga ki nlongo ki Pfumu mu diambu di yoka ansa. ");
INSERT INTO yom_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mu thangu yinyokongo ansa, nkangu woso wu batu widi mu lusambulu ku nganda. ");
INSERT INTO yom_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tumbu zimbukila mbasi yi Pfumu yintotukila, buna yitelimini va koko ku lubakala lu diziku di banyokilanga ansa. ");
INSERT INTO yom_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakali bu kammona, weka ntita ayi weka mona tsisi. ");
INSERT INTO yom_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Vayi mbasi yinkamba : —A Zakali, bika mona tsisi bila Nzambi wuwilu lusambulu luaku, diawu nketoꞌaku Elizabeti wela kubutila muana wu bakala ayi wela kuntedilanga Yowani. ");
INSERT INTO yom_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wala ba tho yi khini ayi di tsaya kuidi ngeyo ayi batu bawombo bela mona khini mu mbutukulu andi. ");
INSERT INTO yom_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wela ba wunneni va ntuala Pfumu, kalendi nua kadi vinu ko, kadi malavu mankolosongo ko. Wela ba wufuluka mu Pheve Yinlongo tona mu vumu ki nguandi. ");
INSERT INTO yom_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wela vutula bana ba Iseli bawombo kuidi Nzambi awu. ");
INSERT INTO yom_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wela tuamina Pfumu ku ntuala mu mpeve ayi mu lulendo lu Eli mu diambu di vutula nguizani va khatitsika madisa ayi bana bawu, mu diambu di batu bobo badi matingu batula mu tezo ki yindula bangabatu basonga ayi mu kubika batu bakubama mu diambu di Pfumu. ");
INSERT INTO yom_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Buna Zakali wuyuvula mbasi : —A buevi ndiela bu zabila e ? Bila minu veka ndieka nunu ki ngolo ayi nketo ama mimvu miwombo keka. ");
INSERT INTO yom_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mbasi yimvutudila : —Minu ndidi Ngabi, minu nditelamanga va ntuala Nzambi, thumunu mu kuyolukila ayi ku kamba minsamu miami mimbote. ");
INSERT INTO yom_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Vayi weka kituka dibaba ayi wulendi baka bu buela yolukilanga ko nate lumbu kioki mambu mama mela vangama. Bobo buela bela bila wusi wilukila ko mambu mama, momo mela vangama mu thangu yifuana. ");
INSERT INTO yom_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Vayi mu thangu beni, nkangu wu batu wuba vingila Zakali. Batu basimina bu bamona ti wulembu zingila muna vinga ki nlongo. ");
INSERT INTO yom_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bu katotuka, kasi baka bu yolukila ko batu bobo bakutakana. Buna basudika ti tsongolo kamueni muna vinga nlongo. Niandi mu bidimbu kaba kuba yolukila ayi wusiala dibaba. ");
INSERT INTO yom_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bu kamanisa bilumbu biandi bi kisalu, buna wuvutuka ku nzoꞌandi. ");
INSERT INTO yom_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bilumbu bina bu bivioka, nketo andi Elizabeti weka mu buemba. Vayi zingondi zitanu kasuamina bila wukamba ti : ");
INSERT INTO yom_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Tala maphangidi Pfumu ! Niandi wumbengudidi thalu yimbote ayi botudi zitsoni ziama va meso ma batu boso. ");
INSERT INTO yom_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mu ngondi yi nsambanu, Nzambi wufidisa mbasi Ngabi ku divula dimosi didi mu Ngalili. Dizina di divula beni Nazaleti, ");
INSERT INTO yom_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kuidi muana ndumba wumosi wuwizana makuela ayi bakala dimosi, diba mu nkuna Davidi. Dizina di bakala beni Zefu ayi dizina di muana ndumba Maliya. ");
INSERT INTO yom_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","—Mboti aku e ! Ngeyo wumonokono nlemvo kuidi Nzambi ! Pfumu widi yaku ! ");
INSERT INTO yom_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliya weka mona boma bu kawa mambu momo. Wuba ku kiyuvula tsundu yi mbote yoyo. ");
INSERT INTO yom_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Buna mbasi yinkamba : —Bika mona tsisi Maliya bila Nzambi wumueni kiadi. ");
INSERT INTO yom_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tala : wela ba mu buemba ayi wela buta muana wu bakala ; wela kuntedilanga Yesu. ");
INSERT INTO yom_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wela ba wunneni. Wela tedudulungu “Nzambi yizangama” ayi Pfumu Nzambi wela kumvana kundu ki kipfumu ki nkulu andi Davidi. ");
INSERT INTO yom_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Wela biadilanga, mu zithangu zioso, batu batotukila mu Yakobi ayilubialu luandi lulendi suka ko. ");
INSERT INTO yom_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliya wukamba Mbasi : —A buevi mela vangimina bila ndisi zaba nitu yi bakala ko ? ");
INSERT INTO yom_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mbasi yimvutudila : —Pheve Yinlongo yela kuluka mu ngeyo ayi kitsusula ki lulendo lu Nzambi wuzangama kiela kufukidila. Diawu wunlongo wela butuka, wela tedudulungu Muana wu Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tala khombꞌaku Elizabeti, mamvandi widi mu buemba bu muana wu bakala mu bununu buandi. Niandi baba tedilanga sita weka mu ngondi andi yi nsambanu. ");
INSERT INTO yom_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bila kuisi ko diambu diela lembakana vanga Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Buna Maliya wuvutula : —Minu ndidi kisadi ki Pfumu. Bika mavangimina kuidi minu boso buididi mambu maku. Buna mbasi yimbika. ");
INSERT INTO yom_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mu bilumbu bina, Maliya wuyenda nsualu-nsualu ku divula didiku miongo, mu zunga ki Yuda. ");
INSERT INTO yom_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wukota mu nzo Zakali ayi wuvana Elizabeti mboti. ");
INSERT INTO yom_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Thangu Elizabeti kawa mbote yi Maliya muanꞌandi wunikuka mu vumu kiandi. Buna wuwala mu Pheve Yinlongo. ");
INSERT INTO yom_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ayi wuyamikina mu mbembo yingolo : —Ngeyo widi wusakumunu va miudi baketo ayi muana widi mu vumu kiaku widi wusakumunu. ");
INSERT INTO yom_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Buna kuevi kubedi diambu diadi ti ngudi yi Pfumu ama kiza kuidi minu e ? ");
INSERT INTO yom_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bila mu thangu nguilu mbotiꞌaku mu matu mama buna muana wunikukini mu vumu kiama mu diambu di khini. ");
INSERT INTO yom_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Khini kuidi nketo wowo wuwilukila bila mambu momo makamba Pfumu mu diambu diandi mela vangama. ");
INSERT INTO yom_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Buna Maliya wukamba : Muelꞌama wunkembisanga nzitusu wu Pfumu ");
INSERT INTO yom_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ayi mpeve yama yilembo mona khini mu diambu di Nzambi, Mvulusi ama. ");
INSERT INTO yom_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bila wubengudi thaluꞌandi va kisadi kiandi kikambulu mfunu, diawu zitsungi zioso ziela kuthedilanga nketo wu zikhini. ");
INSERT INTO yom_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bila Nzambi yi zingolo zioso wuphangidi mambu manneni Dizina diandi didi dinlongo. ");
INSERT INTO yom_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ayi mamboti mandi mela zingilanga mu tsungi ka tsungi, kuidi bobo ba kunkizikanga. ");
INSERT INTO yom_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wumonikisidi zingolo ziandi mu koko kuandi, wusasikisidi batu badi luniemo mu mintima miawu ");
INSERT INTO yom_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wukuludi batu ba lulendo mu bikundu biawu bi kipfumu ayi wunangikidi batu bobo badi balembama ");
INSERT INTO yom_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wuyukutisidi batu bobo baba nzala mu bima bimbote. Wusindika bamvuama mioko yi mioko ");
INSERT INTO yom_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Wusadisidi kisadi kiandi Iseli mu thebukulu yi moyo mu mambote mandi. ");
INSERT INTO yom_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Banga buididi tsila yi kavana bakulu beto kuidi Abalahami ayi kuidi nkunꞌandi mu zithangu zioso. ");
INSERT INTO yom_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tezo ki zingondi zitatu Mliya kavuandila kuidi Elizabeti, bosi wuvutuka ku nzoꞌandi. ");
INSERT INTO yom_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lumbu ki Elizabeti ki buta bu kifuana, wubuta muana wu bakala. ");
INSERT INTO yom_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bakundi bandi ayi bibutu biandi bu bawa phila Pfumu kamonisina mambote mandi, bamona khini va kimosi ayi niandi. ");
INSERT INTO yom_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Muana bu kadukisa dinana di bilumbu, bayiza mu diambu di nzengulu yi nitu yi kibakala. Bawu boso bazola kuntedila Zakali banga dizina di siandi, ");
INSERT INTO yom_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","vayi nguandi wukamba ti : —Nana, dizina diandi Yowani. ");
INSERT INTO yom_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Vayi bawu bankamba : —Kadi mutu wumosi mu dikanda diaku kasi ko dizina diodi. ");
INSERT INTO yom_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Buna bayuvula dise, mu bidimbu, mu zaba dizina mbi katidi vana muana. ");
INSERT INTO yom_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Wulomba tini ki dibaya ; muna kasonika ti : —Dizina diandi Yowani. Buna batu boso basimina. ");
INSERT INTO yom_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Muna thangu yina, munu andi wuzibudidi ayi ludimi luandi luniangukidi. Wuyolukidi ayi wukembisidi Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Batu babo bafikasana yawu bamona tsisi, ayi, bayolukilamambu beni mu tsi yoso yi miongo mi Yuda. ");
INSERT INTO yom_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Babo bawa nsamu beni balunda wawu mu mintima miawu ayi batuba : “A buna muana beni buevi kela bela e ?” Bila Pfumu wuba yandi. ");
INSERT INTO yom_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dise diandi Zakali wufuluka mu Pheve Yinlongo, diawu kabikudila ti : ");
INSERT INTO yom_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Nkembo kuidi Pfumu, Nzambi yi Iseli Bila wuyiza tala batu bandi ayi wuba kudidi ");
INSERT INTO yom_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wututotudidi nkudi wu lulendo mu nkuna Davidi, kisadi kiandi. ");
INSERT INTO yom_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Banga bu kayolukila tona vana thonono mu miunu mi mimbikudi miandi minlongo : ");
INSERT INTO yom_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ti wela ku tukula mu mioko mi bambeni zieto ; mu mioko mi batu bobo ba kutulendanga. ");
INSERT INTO yom_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mu diambu di dukisa mambote kuidi bakulu beto ayi mu diambu di tebukila nguizani andi yinlongo moyo ; ");
INSERT INTO yom_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ayi tebukila moyo ndefi yoyo kalevila nkulu eto Abalahami ");
INSERT INTO yom_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","mu kutuvana diluaku di kunsadila mu kambu tsisi bu kameni kutukula mu mioko mi bambeni zieto ");
INSERT INTO yom_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mu bunlongo ayi mu busonga, mu bilumbu bieto bi luzingu, va ntualꞌandi. ");
INSERT INTO yom_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ngeyo muana, wela tedudulungu Mbikudi wu Nzambi yizangama bila ngeyo wela tuaminina Pfumu ku ntualꞌandi mu diambu di kubika nzilꞌandi ; ");
INSERT INTO yom_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","mu diambu di zabikisa kuidi batu bandi ti Nzambi wumveni phulusu ayi wunlemvukidi masumu andi. ");
INSERT INTO yom_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bila Nzambi eto fulukidi mu diadi ayi mu mambote Diawu mbuetete yi nsuka yela totukila ku yilu mu diambu dieto ");
INSERT INTO yom_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","mu diambu di kienzula bobo badi mu tombi ayi bobo badi mu kini ki lufua, ayi mu diambu di diaisa zithambi zieto mu nzila yi ndembama. ");
INSERT INTO yom_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Muana wuyunduka ayi wukinda mu mpeve. Bosi wuzingila mu bibuangu bisuama nate mu lumbu kioki kakimonisa va meso ma batu ba Iseli. ");
INSERT INTO yom_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mu bilumbu bina, ntinu Sezari Ogisite wuvana lutumu lu tangabatu boso disasama va ntoto wumvimba. ");
INSERT INTO yom_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Disasama beni diawu diba dithete divangama mu thangu Kiliniusi kaba nyadi wu Sili. ");
INSERT INTO yom_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kadika mutu wuyenda kisonikisa ku divula diandi. ");
INSERT INTO yom_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sumbu Zefu kaba mu nkuna wu Davidi, diawu kabotukila ku divula di Nazaleti, mu tsi yi Ngalili mu kuenda mu tsi yi Yuda ku divula di Betelemi, divula di Davidi. ");
INSERT INTO yom_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wuyenda va kimosi ayi Maliya, nketo wukazola kuela, wuba mu buemba. ");
INSERT INTO yom_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Buna badi ku Betelemi, Maliya wutula mu thanguꞌandi yibutila. ");
INSERT INTO yom_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Buna wubuta muana wubakala : muanꞌandi wuthete. Wunzinga mu minledi ayi wuntula mu dikulu ki bibulu bila bibuangu bisia bakana ko mu diambu diawu mu zinzo zinlekanga banzenza. ");
INSERT INTO yom_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Minsungi mi mamemi miba mu zitsola zizungidila zunga beni mibansunga mu nkielo buisi minkangu miawu mimamemi. ");
INSERT INTO yom_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kuna mbasi yi Pfumu yiba monikina ayi nkembo wu Pfumu wubazungidila. Buna tsisi yingolo yiba buila. ");
INSERT INTO yom_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Vayi mbasi yiba kamba : —Bikanu mona boma. Tsangu yimboti ndilunatini. Yikuiza monisabatu boso khini. ");
INSERT INTO yom_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bila buabu balubutidi Mvulusi mu divula di Davidi. Niandi Mesiya, Pfumu. ");
INSERT INTO yom_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Luela mona muana wu tsombi zingulu mu minledi ayi tululu mu dikulu ki bibulu. Kiawu kioki dimbu luela kunzabila. ");
INSERT INTO yom_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Buela zimbukila nkangu wu zimbasi ziba mu dikabu di masodi ma diyilu wumonika va ndambu mbasi beni. Nkangu beni wuyimbila minzitusu mi Nzambi : ");
INSERT INTO yom_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Nkembo kuidi Nzambi yizangama Ndembama va ntoto kuidi batu baketa zola. ");
INSERT INTO yom_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Zimbasi bu zibika minsungi, zivutuka ku diyilu, buna minsungi mi mameme mikambasana miawu na miawu ti : —Bika tuendanu ku Betelemi mu kuenda tadi mambu momo mavangimini kuna ; momo Pfumu katusamunini. ");
INSERT INTO yom_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bayenda nsualu ayi bayenda bata Maliya ayi Zefu va kimosi ayi muana wu tsombi wulekusu mu dikulu ki bibulu. ");
INSERT INTO yom_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Buna baba mona, basamuna mambu moso momo baba kamba mu diambu di muana. ");
INSERT INTO yom_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Babo bobo bawu wawu, basimina buwombo mu diambu di mambu momominsungi mi mameme miba kamba. ");
INSERT INTO yom_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Vayi Maliya wulunda mambu moso ayi wuba ku mayindulanga mu ntimꞌandi. ");
INSERT INTO yom_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bosi minsungi mivutuka, minkembisa ayi minsanisina Nzambi mu diambu di mamo ma bamona ayi ma bawa. Mawu maba banga kuandi bu babakambila mawu. ");
INSERT INTO yom_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dinana di bilumbu bu biduka, thangu yi zengisa lunitu lu kibakala lu muana bu yifuana, buna bamvana dizina Yesu. Diawu dizina divana mbasi tuamina nguandi kaba mu buemba buandi. ");
INSERT INTO yom_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Bilumbu bizengu mu Mina mi Moyize mu diambu di tsukudulu awu bu bifuana, bambuta ba Yesu zinnata ku Yelusalemi mu diambu dikummonisa kuidi Pfumu. ");
INSERT INTO yom_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Boso buidi busonama mu Mina mi Pfumu ti : Woso muana wuthete wu bakala wumbutuka, wela tambuku kuidi Pfumu. ");
INSERT INTO yom_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bayiza diaka mu diambu di tambika dikaba boso buididi mu Minami Pfumu : biduka biodi voti bana buadi ba mabembi. ");
INSERT INTO yom_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mutu wumosi wuba ku Yelusalemi, dizina diandi Simewoni. Wubamutu wufuana ayi wusonga. Wuba vingila mbombolo yi Iseli ayi Pheve Yinlongoyiba va niandi. ");
INSERT INTO yom_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bila Pheve Yinlongo yinkamba ti kalendi vika fua ko enati kamuenieti ko Klisto yi Pfumu. ");
INSERT INTO yom_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Niandi wuyiza ku nzo Nzambi mu lutumunu lu Mpeve Yinlongo. Mu thangu bambuta ba Yesu zinata muana mu diambu di dukisa mambu madi mu Mina, ");
INSERT INTO yom_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","buna Simewoni wunsimba mu mioko ayi wusanisina Nzambi bu katuba : ");
INSERT INTO yom_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","A Pfumu, yekula buabu kisadi kiaku kienda mu ndembama boso buididi tsilꞌaku ");
INSERT INTO yom_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","bila meso mama manueni phulusu aku ");
INSERT INTO yom_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yoyi wukubika mu diambu di batu boso ");
INSERT INTO yom_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","yawu yidi muinda mu diambu di kienzula makanda ; ayi nkembo wu Iseli, batu baku. ");
INSERT INTO yom_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dise ayi ngudi basimina buwombo mu wa mambu katuba mu diambu diandi. ");
INSERT INTO yom_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simewoni wuba sakumuna ayi wukamba Maliya, nguandi Yesu ti : —Tala muana wawu wu kubukulu mu diambu di buisa ayi mu telimisa batu bawombo mu Iseli. Wela ba dimbu kiela bangusanga bawombo ; ");
INSERT INTO yom_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","muingi mayindu ma mintima mi batu bawombo matotuka. Vayi kuidi ngeyo veka, wela ba banga mbedi yela tobul mpeve aku. ");
INSERT INTO yom_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mbikudi wumosi wu nketo wuba diaka muna. Dizina diandi Anna, muana Fenueli, wuba mu dikanda di Aseli. Wuba wununa ngolo. Tsambudi di mimvu kaka kavuandila va makuela mu bumuana buandi. ");
INSERT INTO yom_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bosi wukituka difuola ayi wuzingila mu kidifuola nate mu tezo ki lunana lu mimvu ayi mimvu minya. Kadi lumbu kimosi kasia bika ko nzo Nzambi bila muna kaba nsadilanga Nzambi builu ayi muini mu lusambulu ayi mu kukifuisa nzala mu diambu di lusambulu. ");
INSERT INTO yom_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Niandi mamvandi bu kayiza muna thangu yina, wusanisina Nzambi ayi wuyolukila mambu ma muana kuidi batu bobo baba mvingilanga khudulu yi Yelusalemi. ");
INSERT INTO yom_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bu bamana dukisa mambu momo masonama mu Mina mi Pfumu, Maliyaayi Zefu bafutuka ku buala buawu, Nazaleti, didi mu Ngalili. ");
INSERT INTO yom_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Muana wuyunduka ayi wukinda. Diela diwombo diba yandi ayi nlemvo wu Nzambi wuba mu niandi. ");
INSERT INTO yom_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kadika mvu bambuta ba Yesu ziba kuendanga ku Yelusalemi mu nyengo Pasika. ");
INSERT INTO yom_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu bu kadukisa kumi mimvu miodi buna bayenda ku Yelusalemi, mu diambu di nyengo, boso bubela kifu kiawu. ");
INSERT INTO yom_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nyengo bu wumanisa, bavutuka kuawu. Vayi muanꞌawu Yesu wusiala ku Yelusalemi ayi bambuta bandi zisia bu zaba ko. ");
INSERT INTO yom_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bawu babanzila ti widi muidi bakundi bawu bayenda yawu va kimosi. Bu badiata lumbu kimvimba, buna batona kuntomba muba bibutu biawu ayi bazabana yawu. ");
INSERT INTO yom_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Vayi sumbu basia kummona ko ; diawu bavutukila ku Yelusalemi mu kuenda ntombi. ");
INSERT INTO yom_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bilumbu bitatu bu bivioka, bambakula muna nzo Nzambi, buna kavuendi va khatitsika minlongi mi mina. Wuba wa ayi wuba yuvula biuvu. ");
INSERT INTO yom_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Babo bobo banwa, basimina mu diambu di diela diandi ayi mu diambu di mimvutuziandi. ");
INSERT INTO yom_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Zimbuta bandi zisimina buwombo bu zimmona vana. Buna nguandi wunkamba : —Muanꞌama, bila mbi wutuvangidi bobo e ? Zebi kuaku ti siaku ayiminu tsisi yiwombo tumueni ayi tutombidi ngolo. ");
INSERT INTO yom_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Buna Yesu wuba vutudila : —Bila mbi lufueti kuthombila e ? Lusi zaba ko ti mfueti ba mu nzo yi dise diama ? ");
INSERT INTO yom_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Vayi basia sudika ko mambu momo ka bakamba. ");
INSERT INTO yom_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Buna wuyenda yawu ayi wuvutuka ku Nazaleti. Wuba tumukina. Vayi nguandi wulunda bumboti mambu moso momo mavioka. ");
INSERT INTO yom_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu wuyunduka mu nduenga ayi mu ntela. Khini yiwombo kamonisa Nzambi ayi batu. ");
INSERT INTO yom_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mu mvu wu kumi wu ntnu wu lubialu lu ntinu Tibeli Sezari, Ponse Pilatu niandi wuba nyadi mu Yuda, Elode Tetalake wubiadila mu Ngalili, khombꞌandi Filipi mu Itule ayi mu Talakonite, Lisaniasi wubiadila mu Abileni. ");
INSERT INTO yom_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ana ayi Kayife baba bapfumu zi zinganga Nzambi. Mu mvu beni mambu ma Nzambi mayiza kuidi Yowani muana Zakali, bu kaba mu dikanga. ");
INSERT INTO yom_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yowani wudiengila tsi yoso yiba mu yenda Yolidani ayi wuba kuenda longingi : “Bila lubotama mu monisa ti lubaludi mavanga, buna Nzambi wela lemvukila masumu meno.” ");
INSERT INTO yom_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Banga bu busonimina mu nkanda wu mbikudi Ezayi : Mbembo yi mutu wulembu yamikina mu dikanga : Lukubika nzila yi Pfumu Luludika minsolo miandi ");
INSERT INTO yom_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mindimba mioso miela sesolo, Miongo mioso ayi zimbata zioso zimiongo ziela lendumunu zinzila zi zikhondo ziela lulama minsolo mi mabadi miela fuanusu. ");
INSERT INTO yom_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ayi batu boso bela mona phulusu yi Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yowani wuba kambanga batu bobo baba kuizanga mu botama kuidi niandi ti : —Bana ba bikusa ! Nani wululubudi mu tina nganzi yoyi yeka kuiza ? ");
INSERT INTO yom_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Monisanu mavanga mamboti momo mafueni kuidi batu bobo babalula mavanga. Lubika banza bu lulembu yindulanga mu mintima mieno ti : “Beto dise dieto Abalahami !” Bila bukiedika ndikulukamba ti Nzambi wulenda totula bana ba Abalahami mu mataid mama. ");
INSERT INTO yom_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Lukeba : soka kikubimini mu zenga mianzi mi minti. Woso nti wunkambu buta mu zenga mianzi mi minti. Woso nti wunkambu buta makundimamboti wela kuangu ayi wela viku ku mbazu. ");
INSERT INTO yom_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Buna nkangu wu batu wunyuvula : —Buna mbi tufueti vanga e ? ");
INSERT INTO yom_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wuba vutudila : —Woso mutu widi bikhutu biodi, bika kavana kimosi kuidi mutu wowo kambulu. Woso mutu widi bidia bika kavanga bobuawu. ");
INSERT INTO yom_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ayi mimfutisi mi ziphaku miyiza botama kuidi Yowani, minyuvula : —Nlongi, mbi tuvanga e ? ");
INSERT INTO yom_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Buna wuba vutudila : —Lubika buelanga thalu va mbata thalu yoyo yizengo. ");
INSERT INTO yom_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Masodi mamvawu manyuvula : —Buna beto, mbi tuvanga e ? Buna niandi wuba vutudila : —Lubika zionanga bima bingana ; lubika fundanga batu mu mambu ma luvunu. Lutadidilanga kaka mfutu eno. ");
INSERT INTO yom_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Batu boso bata diana di ngolo bila babanzila ti Yowani niandi Klisto. ");
INSERT INTO yom_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yowani wuba vutudila bawu boso ti : —Minu mu nlangu ndilembu lubotikila. Vayi mutu wowo wulembu yizi wundutidi mu lulendo ; ndisi fuana ko u zibula minsinga mi zisapatu ziandi. Niandi wela kulubotikila mu Pheve Yinlongo ayi mu mbazu. ");
INSERT INTO yom_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ayi simbidi mbangu mu mioko miansi ; niandi wela kombula buangu kioki kela vevila. Wela lunda ble ku yilu banga vayi wela yoka biti ku mbazu yi kayilendi zima ko. ");
INSERT INTO yom_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yowani bu kaba vananga zithumunu ziwombo kuidi batu, buna wuba kubalonganga Nsamu Wumbote. ");
INSERT INTO yom_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Vayi Yowani wuba tubidilanga buwombo nyadi Elode mu diambu di kakuela Elodiasi, nketo wu khombꞌandi ayi mu diambu di kavanga mavanga mawombo mankakamambimbi. ");
INSERT INTO yom_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Elode wubuela diaka yika bila kiaki va yilu mambimbi mandi moso : wukotisa Yowani mu nloko. ");
INSERT INTO yom_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Batu boso bu bamana botama, Yesu mamvandi wubotama. Bu kaba sambila, diyilu dizibuka ");
INSERT INTO yom_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ayi Pheve Yinlongo yi nkitila banga dibembi. Kuna kuwakana mbembo yimosi yitotukila ku diyilu, yikamba ti : —Ngeyo widi Muanꞌama wu luzolo ; khini yiwombo wukumbonisanga. ");
INSERT INTO yom_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu buna weka nduka-nduka makumatatu ma mimvu bu katona kisalu kiandi. Batu babanzila ti niandi muana Zefu wu Heli : ");
INSERT INTO yom_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","wu Mata, wu Levi, wu Maliki, wu Yanayi, wu Zefu ");
INSERT INTO yom_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","wu Matatiasi, wu Amosi, wu Nahumi, wu Esili, wu Nangayi. ");
INSERT INTO yom_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Wu Mati, wu Matatiasi, wu Simeyini, wu Yose, wu Yoda. ");
INSERT INTO yom_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Wu Yowanani, wu Leza, wu Zolobabeli, wu Salatieli, wu Neli ");
INSERT INTO yom_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","wu Meleki, wu Adi, wu Kosami, wu Elimadami, wu El. ");
INSERT INTO yom_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Wu Yesu, wu Eliezeli, wu Yolimi, wu Mata, wu Levi ");
INSERT INTO yom_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","wu Simewoni, wu Yuda, wu Zozefi, wu Yonami, wu Eliakimi. ");
INSERT INTO yom_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Wu Meleya, wu Mena, wu Matata, wu Natani, Wu Davidi. ");
INSERT INTO yom_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Wu Isayi, wu Obedi, wu Vowazi, wu Salimoni, wu Nasoni ");
INSERT INTO yom_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","wu Aminadabi, wu Adimini, wu Alini, wu Esiloni, wu Pelesi, wu Yuda, ");
INSERT INTO yom_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","wu Yakobi, wu Isaki, wu Abalahami, wu tela, wu Nawoli. ");
INSERT INTO yom_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Wu Selungi, wu Lewu, wu Faleki, wu Hebeli, wu Sala ");
INSERT INTO yom_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","wu Kayinani, wu Alifazadi, wu Semi, wu Nowa, Wu Lemeki. ");
INSERT INTO yom_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Wu Matusalemi, wu Enoki, wu Yeledi, wu Maleleli, wu Kenami, ");
INSERT INTO yom_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","wu Enosi, wu Seti, wu Adami, niandi veka wuba muana wu Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu wuba wuwala mu Pheve Yinlongo, wubotuka ku Yolidani. Mpeve yinnata ku dikanga. ");
INSERT INTO yom_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kuna satana kamvukumunina mu tezo ki makumaya ma bilumbu. Kadi kiasa kasia dia ko mu bilumbu beni. Bu biduka, buna wumonanzala. ");
INSERT INTO yom_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Buna satana wunkamba : —Kamba ditadi diadi dikituka dipha enati widi muana Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu wumvutudila : —Disonama ti : mutu kalendi zingilanga kaka mu dipha ko. ");
INSERT INTO yom_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Buna satana wunnata va kingiela ayi wummonisa mu khumbu yimosibipfumu bioso bi ntoto ");
INSERT INTO yom_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ayi wunkamba : —Ndiela kuvana lulendo loso lualu, ayi nkembo wu bimbumu biabi. Bila minu veka ndivanu wawu ayi ndenda kuwuvana kuidi woso mutu nsodidi. ");
INSERT INTO yom_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ngeyo kumbuongimina kuandi buna bibioso biobi bieka ba biaku. ");
INSERT INTO yom_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu wumvutudila : —Disonama : Pfumu Nzambi aku niandi kaka fueti buongimina ayi niandi kaka fueti sadila. ");
INSERT INTO yom_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Buna bosi satana wunnata ku Yelusalemi, wuntula ku buangu kilutidizangama kimbata muanzu wu nzo Nzambi ayi wunkamba : —Enati bukiedika ti widi Muana Nzambi, wukilozi ku ntoto bila disonama : ");
INSERT INTO yom_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nzambi wela fidisa zimbasi ziandi mu diambu diaku muingi zikeba ");
INSERT INTO yom_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ayi ziela kunata mu mioko miawu mu diambu di kulu kuaku kuedibumina thutu mu ditadi. ");
INSERT INTO yom_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu wumvutudila : —Bakamba : Wulendi vukumuna Pfumu Nzambi aku ko ! ");
INSERT INTO yom_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satana bu kamana kumvukumuna mu zithotolo zi phila mu philabuna wuntatukila nate mu thangu yizengo. ");
INSERT INTO yom_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Buna Yesu wuvutuka ku Ngalili ; lulendo lu Pheve luba mu niandi. Tsangu andi yimana tembakana mu zunga kioso. ");
INSERT INTO yom_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wuba longanga mu zinzo ziawu zi zikhutukunu ayi batu boso baba kuniemisanga. ");
INSERT INTO yom_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wuyenda ku Nazaleti ku Kayundukila ayi wukota mu nzo yi lukutukunu mu lumbu ki saba bila bobo bu bela kifu kiandi. Wutelama mu diambu di tanga masonoko. ");
INSERT INTO yom_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Buna bamvana nkanda wu mbikudi Ezayi. Bu kazibula nkanda beni, wubua va tini kisonama mambu mama : ");
INSERT INTO yom_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Pheve yi Pfumu yidi va minu bila wutsodula mu longa Nsambu Wumbote kuidi minsukami, wumfidisa mu yamikisa khudulu yi batu bakangama, mu zibula meso ma baphofo, mu nata phulusu kuidi batu banyamusu ");
INSERT INTO yom_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ayi yamikisa mvu wu nlemvo wu Pfumu. ");
INSERT INTO yom_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Wuzibika nkanda beni ayi wuvutula wawu kuidi kisadi ki nzo yi lukutukunu bosi wuvuanda. Meso ma batu boso baba mu nzo yi lukutukunu maba kuntala. ");
INSERT INTO yom_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Buna wuba kamba : —Buabu, masonuku mama ma luwilu masundukidi. ");
INSERT INTO yom_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Batu boso bantelimina kimbangi. Basimina mu diambu di mambu ma nlemvo matotukila mu munu andi. Buna batuba : —Niandi ko muana Zefu e ? ");
INSERT INTO yom_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Buna wuba kamba : —Bukiedika ti ma lukhamba kingana kiaki : “Munganga, wukibelusa ngeyo veka !” ayi maluthela : “Tuwilu mambu mavangimini ku Kafalinawumi. Vanga buawu kuaku, mu divula diaku !” ");
INSERT INTO yom_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Buna wubuela ku bakamba ti : Bukiedika ndikulukamba ti kuisi ko mbikudi wela yakulu bumboti mu tsi andi ! ");
INSERT INTO yom_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bukiedika ndikulukamba ti mafuola maba mawombo mu Iseli mu thangu Eli. Zimvula zisia noka ko mu tezo ki mimvu mintatu ayi ndambu ; ayi kanda kingolo kiba mu tsi yoso. ");
INSERT INTO yom_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Vayi Eli kasia fidusu kuidi mfuola moso ko. Vayi kuidi difuoladimosi diba zingilanga ku Salapeta, mu tsi yi Sidoni. ");
INSERT INTO yom_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Batu babela buazi baba bawombo mu Ieli mu thangu mbikudi Elisa vayi kadi wumosi mu bawu kasia vedusu ko ; botula kaka Namani muisi Sili. ");
INSERT INTO yom_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Batu boso baba muna nzo yi lukutuku bafuema ngolo bu awa mambu mama. ");
INSERT INTO yom_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Batelama, banata Yesu ku nganda yi divula ; nate ku tsongi wu mongo, kutungulu divula beni. Bannata kuna muingi bannunguna ku tsi. ");
INSERT INTO yom_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Vayi wufielumuka va khatitsikꞌawu ayi wuyenda kuandi. ");
INSERT INTO yom_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wuyenda ku Kafalinawumi, divula di Ngalili. Kuawu kaba longila mu lumbu bi saba. ");
INSERT INTO yom_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Basimina buwombo mu wa malongi mandi bila wulongila mu lulendo. ");
INSERT INTO yom_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Muna nzo lukutukunu muba mutu wumosi wuba mpeve yimbimbi, wuyamikina mu ndinga yingolo : ");
INSERT INTO yom_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—A Yesu muisi Nazaleti, mambu mbi tuidi betu yaku e ? Wizidi mu kutubunga e ? Minu nzebi ti ngeyo widi nani : Widi mutu wunlongo wu Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu wutemina pheve yimbimbi ayi wuntumina : —Bika biyoko ; totuka mu mutu wawu ! Mpeve beni yimbimbi yilumba mutu beni va tsi, va meso ma batu boso babavana. Buna yitotuka mu kambu kumvanga mpasi. ");
INSERT INTO yom_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Batu boso basimina ayi bayuvasana bawu na bawu : —A mambu mbi mama e ? Bila niandi wumvana zithumunu kuidi ziphevi zimbimbi mu kibakala ayi mu lulendo ayi ziawu zilembu totuka. ");
INSERT INTO yom_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tsangu yi Yesu yimuangana mu mala moso ma zunga kina. ");
INSERT INTO yom_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Bu katotuka mu nzo yi lukutukunu, wuyenda ku nzo yi Simoni. Nzitu wu Simoni wuba zinzangala zingolo ayi baleba Yesu muingi kambelusa. ");
INSERT INTO yom_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wuyinama va kaba, wutemina zinzangala ayi ziawu zitumbu kumbika. Buna nzitu wu Simoni wutelama mu nsualu ayi wuba kubikila bidia. ");
INSERT INTO yom_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Thangu buna yeka diama, baboso baba bedisa bambevo banata bambevo ziawu, ziba bimbevo bi mpila mu mpila, kuidi Yesu. Wutetika mioko kuidi kadika mutu ayi wuba belusa. ");
INSERT INTO yom_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ziphevi zimbimbi zitotuka mu batu bawombo. Sumbu zintotuka zi kuenda yamikina : —Ngeyo widi Muana Nzambi. Vayi Yesu wutemina ziphevi beni zimbimbi ayi kasia zivana ko minsua mu yoluka bila zizaba ti niandi Klisto. ");
INSERT INTO yom_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Buisi buna bukia, Yesu wutotuka ayi wuyenda ku buangu kisuma. Nkangu wu batu wuntomba ayi bu wutula va kaba ; batu bazola kunsimbidila mu diambu kabika kuenda. ");
INSERT INTO yom_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Vayi wuba kamba : —Mfueti samuna diaka Nsamu Wumbote wu Kipfumu ki Nzambi mu mavula mankaka bila diawu ndifidusulu. ");
INSERT INTO yom_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Buna wulonga mu zinzo zi zikhutukunu zi Yuda. ");
INSERT INTO yom_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lumbu kimosi yesu kaba muyenda disimu di mbu wu Ngenezaleti ayi sumbu nkangu wu batu wunzungidila mu diambu di wa mambu ma Nzambi, ");
INSERT INTO yom_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","buna wumona minlungu miodi muyenda mbu. Minlobi mi zimbizi bakuluka kuawu mu minlungu miawu bila makondi mawu baba sukula. ");
INSERT INTO yom_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nlungu wumosi wuba wu Simoni. Yesu wukuma muawu ayi wunkambakatatukila fioti disimu. Buna wuvuanda muna nlungu ayi wutona longa nkangu. ");
INSERT INTO yom_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Buna kamanisa yoluka, wukamba Simoni : —Kuesa nlungu kungingi nlangu, kuna kuidi thimpula bosi ngeyo ayi bakundi baku lozanu makondi meno mu diambu di luloba. ");
INSERT INTO yom_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Vayi Simoni wumvutudila : —A nlongi, builu bumvimba tusedi vayi kadi kiasa tusia baka ko. Vayi sumbu wuthumini, ndieka loza makondi. ");
INSERT INTO yom_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Baloza makondi ayi babaka zimbizi ziwombo ; ayi makondi mawu tsatu makanzuka. ");
INSERT INTO yom_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Buna batumisa bakundi bawu bobo baba mu nlungu wunkaka muingi biza basadisa. Bayiza ayi minlungu mioso mimiodi miwala zimbizi, ayi tsatu midiama. ");
INSERT INTO yom_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Bu kamona bobo, Simoni-Piela wufukama va malu ma Yesu ayi wunkamba : —Pfumu, bika wuthatukila bila ndidi nkua masumu. ");
INSERT INTO yom_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Muaki lukhuku lumbuila va kimosi ayi bakundi bandi mu mona phila zimbizi baloba. ");
INSERT INTO yom_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zaki ayi Yowani, bana ba Zebede, bakundi ba Simoni, mamvawu lukhuku lu babuila. Buna Yesu wukamba Simoni : —Bika mona tsisi bila tona buabu wela ba nlobi wu batu. ");
INSERT INTO yom_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bu bavutula minlungu miawu ku disimu, basia bika bibioso ayi balandakana Yesu. ");
INSERT INTO yom_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Lumbu kimosi Yesu bu kaba mu divula dimosi, kuna kutotukila mutu wumosi wuba ayi buazi. Bu kamona Yesu, mutu beni wufukamava ntualꞌandi vayi wuyinika zizi kiandi mu tsi ayi wunleba : —A Pfumu, enati tidi buna wulenda kuaku kumvedisa ! ");
INSERT INTO yom_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu wunonuna koko kuandi, wunsimba ayi wunkamba : —Nyinga, thidi, vedila kuaku ! Mu yina thangu, wuvedila mu buazi buandi. ");
INSERT INTO yom_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Vayi wunkandika kabika kamba kadi kuidi mutu wumosi mambu mavangimini mu niandi. Vayi wunkamba : —Yenda kimonisa kuidi nganga yi Nzambi ayi nata dikaba dilomba Moyizemu diambu diba kimbangi kuidi bawu. ");
INSERT INTO yom_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tsangu yi Yesu yiluta muangana. Diawu minkangu miwombo mi batu bayiza muingi banwa ayi muingi babelusu mu bimbevo biawu. ");
INSERT INTO yom_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Vayi niandi wuyenda tinina mu bibuangu bisuama mu diambu kasambila. ");
INSERT INTO yom_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lumbu kimosi bu kaba longa, Bafalisi ayi minlongi mi mina bobobatotukila mu mala moso ma Ngalili, ma Yuda ayi ma Yelusalemi bayizavuanda vana ayi lulendo lu Pfumu lumonika mu bambevo baba balusanga Yesu. ");
INSERT INTO yom_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Zimbukila babakala batotuka, banata dikoka mu kimpoyi. Batomba diluaku di kunkotisila mu nzo muingi bantula va ntuala Yesu. ");
INSERT INTO yom_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Vayi basia baka ko diluaku di kunkotisila mu diambu di nkangu wu batu. Diawu bakumina ku mbata muanzu ayi batobudila divudumu muanzu, bosi, bakulula dikoka beni mu kiphoyi va khatitsika batu, va ntuala Yesu. ");
INSERT INTO yom_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu bu kamona minu ki batu bobo, wukamba : —Nkundi ama, masumu maku malemvokolo. ");
INSERT INTO yom_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Minlongi mi Mina ayi Bafalisi batona niunguta ayi bakambasana : —Buna nani mutu wawu wuntuba mamu ma mvuezolo e ? Nani beki minsuamu lemvukil masumu ? A keti Nzambi kaka e ? ");
INSERT INTO yom_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Vayi Yesu wuzaba mayindu mawu, ayi wuba kamba : —Bila mbi lunyindudila bobo mu mintima mieno e ? ");
INSERT INTO yom_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mbi bilutidi kambu phasi mu kamba : “Masumu maku malemvokolo” voti “telama kuaku ayi diata ?” ");
INSERT INTO yom_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Vayi muingi luzaba ti muana mutu beki lulendo va ntoto lu lemvukila masumu… Buna wukamba dikoka : —Minu ndikutumina : “Telema, bonga kiphoyi kiaku ayi vutuka ku nzoꞌaku !” ");
INSERT INTO yom_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vana vawu dikoka ditelama, va meso ma batu boso, dibongakiphoyi kiandi ayi divutuka ku nzoꞌandi. Sumbu kavutuka wulembu kembisa Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Batu boso basimina, bakembisa Nzambi kutsi boma baba vayi batuba : —Matsiminanga tumueni buabu. ");
INSERT INTO yom_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mambu momo bu mavioka, Yesu wuyenda kuandi. Vayi wumona mfutisi wumosi wu ziphaku mu nzila, buna kavuendi mu bilu kimfutusulungu ziphaku, dizina diandi Levi. Buna wuntela ayi wunkamba : —Wundandakana. ");
INSERT INTO yom_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mutu beni wutelama, wubika bima bioso ayi wulandakana Yesu. ");
INSERT INTO yom_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Buna Levi wukubikila Yesu ndikulu dinneni, ku nzoꞌandi. Batu bawombo baba yawu va meza. Mu bawu muba mimfutisi mi ziphaku. ");
INSERT INTO yom_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bafalisi ayi minlongi mi mina miomi miba mu dingumba diawu mifuema ayi bayuvula minlonguki mi Yesu ti : —Bila mbi lulembo dila ayi nuina va kimosi ayi mimfutisi mi ziphaku miomi, bankua masumu e ? ");
INSERT INTO yom_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu wuba vutudila : —Batu bobo badi nitu yi buvini batombanga munganga ko. Vayi batu badi bimbevo bawu bantombanga munganga. ");
INSERT INTO yom_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ndisia kuiza tela batu basonga ko vayi ndiyiza mu diambu di tela bankua masumu. ");
INSERT INTO yom_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Buna bankaka banyuvula : —Bila mbi minlonguki mi Yowani ayi mi Bafalisi mikukifuisanganzala mu diambu di lusambulu vayi miaku mindia ayi minua e ? ");
INSERT INTO yom_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu wuba vutudila : —A beno lumbanza ti batu bobo batumusu, kuidi ditoko diodi dikuedidi, balenda kukifuisa nzala mu diambu di lusambulu ditoko dikuedidi bu dikidi yawu va kimosi e ? ");
INSERT INTO yom_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Vayi vadi thangu bu bela ku babotula ditoko, buna bosi mu bilumbu binabela kukifuisa nzala mu diambu di lusambulu. ");
INSERT INTO yom_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Buna wuba kamba nongo yimosi : —Mutu kalendi ko kanzuna tendi kinledi wumona muingi kalondila nledi wunkhulu. Bila buna maka kanzuna nledi wumona ayi tendi kioki kabongidi mu nledi wumona kilendi fuanakana ko ayi tendi kikhulu. ");
INSERT INTO yom_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bobuawu, mutu kalendi tula ko vinu kimona mu zitsaku zikhulu bilanganu vinu kimona kilenda kanzuna zitsaku zikhulu. Buna vinu kidukukidi ayi zitsaku zifuidi. ");
INSERT INTO yom_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Vayi bufueni mu tula vinu kimona mu zitsaku zimona. ");
INSERT INTO yom_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kuisi ko mutu wunua vinu kikhulu wubuela tomba diaka nua vinu kimona bila kafueti tuba : vinu kikhulu kilutidi lueki ! ");
INSERT INTO yom_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kiba lumbu ki saba, Yesu wuviokila mu tsola yi ble. Minlonguki miandi mivela makundi ayi midia mawu. ");
INSERT INTO yom_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bafalisi bankaka bayuvula : —Bila mbi lulembo vangila mambu makanduku mu lumbu ki saba e ? ");
INSERT INTO yom_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu wubavutudila : —Lutengi ko mambu Davidi kavanga mu thangu niandi ayi bakundi bandibaba mu nzala e ? ");
INSERT INTO yom_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Niandi wukota mu nzo Nzambi, wubonga mapha matambuku kuidi Nzambi ayi wudia mawu ; wukabudila batu bobo baba yandi, ka diambu ko, kasia ba ko minsua bila banganga Nzambi kaka ziba minsua mu dia mawu. ");
INSERT INTO yom_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Buna wubuela tuba diaka : —Muana mutu niandi Pfumu yi lumbu ki saba. ");
INSERT INTO yom_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mu lumbu kinkaka ki saba, Yesu wukota mu nzo yi lukutukunu ayi wutona longa. Muna muba mutu wumosi wuba koko ku lubakala kusioka. ");
INSERT INTO yom_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Minlongi mi mina ayi Bafalisi basunga Yesu mu tala kani wulendakumbelusa mu lumbu ki saba mu diambu babaka bila kioki balenda kumfundila. ");
INSERT INTO yom_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Vayi Yesu bu kazaba mayindu mawu, buna wukamba mutu wuba koko kusioka : —Telama, yiza va ntuala batu boso ! Mutu beni wutelama. Wuyiza vana. ");
INSERT INTO yom_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Buna Yesu wuba kamba : —Kiuvu kidi yama ki kuluyuvula : minsua midi mu vanga mambotevoti mambimbi mu lumbu ki saba e ? Minsua midi mu vukisa luzingu voti mu kuluvonda e ? ");
INSERT INTO yom_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Buna wuzungisa thalu andi kuidi batu boso baba vana bosi wukamba mutu beni : —Nonuna koko kuaku. Mutu beni wunonuna koko ayi koko kuandi kubeluka. ");
INSERT INTO yom_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Minlongi mi mina ayi Bafalisi bafuema ngolo ayi bayuvasana bawu na bawu mu zaba diambu mbi balenda vangila Yesu. ");
INSERT INTO yom_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Muna bilumbu beni, Yesu wuyenda ku mbata mongo mu diambu di sambila. Builu bumvimba kasambidila. ");
INSERT INTO yom_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Buisi buna bu kia, buna wutela minlonguki miandi ayi wusobula va khatitsikꞌawu kumi mi miodi. Wuba vana dizina di bamvuala. ");
INSERT INTO yom_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mazina mawu mawu mama : Simoni wuka bieka Piela ayi khombꞌandi Andele ; Zaki, Yowani, Filipi, Balitelemi ");
INSERT INTO yom_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayi, Toma, Zaki muana Alife, Zimoni wuba mu dingumba di ba Zeloti, ");
INSERT INTO yom_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda muana zaki ayi Yuda Isikalioti, mutu wumvakula. ");
INSERT INTO yom_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bu kaba kuluka mongo va kimosi ayi bawu Yesu wutelama va ndimba. Minlonguki miandi miwombo miba vana va kimosi ayi nkangu wuwombo wu batu baba mu zunga kioso ki Yuda, ki Yelusalemi, mu mala ma Tile ayi Sidoni momo madi mu yenda nzadi. ");
INSERT INTO yom_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Baboso bayiza mu diambu di banwa ayi babelusu mu bimbevo biawu. Bobo bayamusu kuidi ziphevi zimbimbi babeluka. ");
INSERT INTO yom_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Baboso batomba kunsimba bila lulendo lutotukila mu niandi luba lubelusa batu boso. ");
INSERT INTO yom_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Buna Yesu wutala minlonguki miandi ayi wuba kamba : —Khini kuidi beno minsukama bila beno luvuidi Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Khini kuidi beno luidi buabu mu nzala bila luela yukutusu. Khini kuidi beno lulembu didi buabu bila luela seva. ");
INSERT INTO yom_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Khini kuidi beno mu thangu bela ku lulenda, bu bela ku luloza, bu bela ku lufinga, bu bela ku lukuka, bu bela manga mazinga meno banga mazina mambimbi mu diambu di Muana Mutu. ");
INSERT INTO yom_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mu lumbu kina buna luela mona khini ayi luela dumuka mu diambu di khini bila mfutu eno widi wunneni mu diyilu. Bila buawu bobo kuandi bakulu bawu bayamisila mimbikudi. ");
INSERT INTO yom_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Vayi mabienga kuidi beno zimvuama bila lukitambudidi yeno mbombolo. ");
INSERT INTO yom_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mabienga kuidi beno luidi bayukuta buabu bila luela mona nzala. Mabienga kuidi beno lulembu sevi buabu bila luela ba mu kaniki ayi luela dila. ");
INSERT INTO yom_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mabienga kuidi beno batu boso bu bela kuluniemisa bila buawu bobobakulu bawu bavangila mimbikudi mi luvunu. ");
INSERT INTO yom_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Vayi kuidi beno lunwa, ndikulukamba : luzola bambeni zienu ; luvangila mambote bobo bakululendanga ; ");
INSERT INTO yom_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Lusakumuna bobo bakulusinganga ; lusambidila bobo bakuluvangilanga mambu mambimbi. ");
INSERT INTO yom_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Enati mutu wuzubidi mbata mu luvenga lumosi, buela ntambika luvenga lunkaka. Enati mutu wuzionini yunga kiaku, buna kadi ku nkandika kaziona kikhutu kiaku. ");
INSERT INTO yom_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Vana kuidi woso mutu wukulomba. Enati mutu wuzionini bima biaku, buna kadi kunlomba diaka biawu. ");
INSERT INTO yom_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mambu momo lutidi baluvangila, mawu mamveno lufueti vangila bankaka. ");
INSERT INTO yom_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Enati lunzolanga kaka bobo bakuluzolanga buna mbi lumbaka e ? Bila bankua masumu, mamvawu, beta zola bobo baku bazolanga. ");
INSERT INTO yom_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Enati lumvangila mamboti kuidi bobo bakuluvangilanga kaka mambote, buna mbi lumbaka ? Bila bankua masumu mamvawu beta bu vanga. ");
INSERT INTO yom_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Enati lueta devisa kaka bobo balenda kuluvutudila, buna mbi lumbaka e ? Bila bankua masumu mamvawu beta devisa bankua masumu yawu muingi baba vutudila. ");
INSERT INTO yom_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Vayi beno bika luzola bambeni zienu, luba vangila mambote ayi ludevisa mu kambu ba mayindu keni bela kuluvutudila. Buna mfutu eno welaba wunneni, luela ba bana ba Nzambi yizangama bila niandi veka widi wumbote kuidi bobo bazabanga ko vutula matondo ayi kuidi batu bambimbi. ");
INSERT INTO yom_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bika luba batu bambote banga dise dieno widi wumbote. ");
INSERT INTO yom_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Lubika sambisa tala mamveno luedi sambusu. Lubika zengila batu nkanu tala mamveno luedi zengulu nkanu. Lulemvukila badienu muingi mamveno balulemvukila. ");
INSERT INTO yom_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Luvananga buna mamveno bela kuluvana. Bela kuluvana kuku kifuana, kuku kikomana, kinikunu ayi kinsapuka bila bela kulutezila luelo luela dedakana banga lolo lutezila. ");
INSERT INTO yom_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu wubuela bakamba diaka nongo yayi : —A buevi, phofo wulenda nata phofo yandi e ? Buna bawu buadi balenda bua mu dibulu e ? ");
INSERT INTO yom_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nlonguki kasi viatuka ko nyiyisi andi vayi bu kameni kubuku bu mbote, buna boso kalenda dedakana banga nyiyisi andi. ");
INSERT INTO yom_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Bila mbi wuntadila kiti kidi mu diesu di khombꞌaku vayi ngeyo vekawukadi mona tunga yidi mu diesu diaku e ? ");
INSERT INTO yom_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Voti, buevi wulenda kambila khombꞌaku ti : “A khomba bika ndibotula kiti kidi mu diesu diaku !” vayi ngeyo veka wukadi mona tunga yidi mu diesu diaku e ? Mutu wu mayuya ! Botula nteti tunga yidi mu diesu diaku buna bosi mawumona bumboti mu botula kidi kidi mu diesu di khombꞌaku. ");
INSERT INTO yom_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Bila kuisi ko nti wumbote wela buta makundi mambimbi ayi nti wumbimbi wulendi buta makundi mambote ko. ");
INSERT INTO yom_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bila banzabilanga nti mu makundi mandi. Bila balendi vela ko makundima figi mu nti wu zitsendi ayi balendi vela ko makundi ma vinu mu nti wu zitsolokoto. ");
INSERT INTO yom_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mutu wumbote wuntotulanga mambote momo mambanga mu kiuka kimboteki ntimꞌandi. Mutu wumbimbi wuntotulanga mambimbi mambanga mu kiuka kimbimbi ki ntimꞌandi bila mutu wuntubanga mambu momo mafulukidi mu ntimꞌandi. ");
INSERT INTO yom_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—Bila mbi lukuthedilanga “Pfumu, Pfumu” vayi lukadi vanga mambu momo ndilembu lukambi e ? ");
INSERT INTO yom_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ndieka kulumonisa buevi budedikinini woso mutu wowo wunkuiza kuidiminu, wulembu wi mambu ndilembu tubi ayi wulembu kumasadila. ");
INSERT INTO yom_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Niandi dedikini banga mutu wowo wutunga nzo. Wutimuna fondasio yimula ayi wutungila yawu va yilu matadi. Khuka yi nlangu bu yiyiza, yiyiza lumbama muna nzo beni ayi yisia yinikuna ko bila yitungu va yilu matadi. ");
INSERT INTO yom_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Vayi woso wulembu wi mambu mama ayi wunkambu sadila mambu beni dedikini banga mutu wutunga nzoꞌandi va mbata ntoto mu kambu fondasio. Khuka yi nlangu bu yiyiza lumbama mu nzo beni, yawu yitumbu bua, mfuilu yi nzo beni yiba yinneni. ");
INSERT INTO yom_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bu kamana kamba batu mambu maba yandi, Yesu wuyenda ku Kafalinawumi. ");
INSERT INTO yom_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pfumu yimosi yi masodi wuba ayi mvikꞌandi wuba mu kimbevo, wuba nduka mu fua. Pfumu beni wuba zolanga ngolo mvika beni. ");
INSERT INTO yom_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bu kawa tsangu yi Yesu, buna pfumu beni yi masodi wumfidisila bakulutu ba Bayuda muingi banleba kiza belusa mvikꞌandi. ");
INSERT INTO yom_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bu batula vaba Yesu mbadi banleba : —Niandi fueni wumvangila buawu. ");
INSERT INTO yom_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bila wunzolanga tsi etu ayi niandi veka wututungila nzo yi lukutukunu. ");
INSERT INTO yom_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu wuyenda yawu. Buna weka nduka tula ku nzo, pfumu yi masodiwumfidisila bakundi bandi mu kunkamba : —A pfumu, bika kuaku kiyamisa bila ndisi wufuana ko muingi ngeyo wukota mu nzoꞌama. ");
INSERT INTO yom_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Diawu ndisi kuiza kudenginina ko minu veka vayi tuba kaka diambu dimosi buna kisadi kiama ma kibeluka. ");
INSERT INTO yom_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bila minu veka ndidi ku tsi luyalu lu bapfumu ayi mbeki masodi ma ndieta tumina. Minu kamba kuidi wumosi : “Yenda” makenda. Minu kamba kuidi wunkaka : “Yiza” makiea. Minu kamba kuidi mvikꞌama : “vanga diadi !”, balavanga diawu. ");
INSERT INTO yom_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu wusimina buwombo bu kawa mamu ma pfumu yi masodi. Buna wubaluka kuidi nkangu wuba kunlandakana ayi wutuba : —Bukiedika ndikulukamba ndimueni ko, ka diambu ko mu Iseli, minu kinneni banga kiaki. ");
INSERT INTO yom_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bamvuala mi pfumu masodi zivutuka kuawu kuna nzo, kuna yiyenda bata mvika beni mu buvini. ");
INSERT INTO yom_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mu lumbu kilanda, Yesu wuyenda ku divula dimosi diba bantedilanga Nayini. Minlonguki miandi minlandakana va kimosi ayi nkangu wuwombo. ");
INSERT INTO yom_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bu katula va difula di divula, wudengana batu banata mvumbi ku nganda yidivula. Wuba muana wumosi kaka wu difuola. Nkangu wu wombo wu divula wuba yandi va kimosi. ");
INSERT INTO yom_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pfumu bu kamona difuola beni buna wummona kiadi ayi wunkamba : —Bika dila. ");
INSERT INTO yom_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bosi wufikama vaba kesi yi mvumbi ayi wutetika koko kuandi va mbata kesi beni. Bobo banata kesi batelama. Buna wukamba : —Ndikutumina, muana ditoko, telama kuaku ! ");
INSERT INTO yom_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Zimbukila mutu wuba wufua wuvumbuka, wuvuanda ayi wutona yoluka. Yesu wumvana kuidi ngudi andi. ");
INSERT INTO yom_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Babo bamona tsisi, bakembisa Nzambi ayi batuba : —Mbikudi wunneni wututotukidi ayi Nzambi wizidi mu sadisa batu bandi. ");
INSERT INTO yom_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tsangu yi nsamu wawu yitembakana mu Yuda dioso ayi mu bizunga bizungidila. ");
INSERT INTO yom_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Minlonguki mi Yowani mimana kamba Yowani mambu moso momo mavioka. Buna wutumisa minlonguki miandi miodi ");
INSERT INTO yom_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ayi wuba fidisa kuidi Pfumu mu diambu banyuvula : —Bukiedika kuandi ti ngeyo mutu wowo wufueti kuiza voti tufueti vingila wunkaka e ? ");
INSERT INTO yom_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Batu beni bayenda kuidi Yesu ayi bankamba : —Yowani Mbotidi wututumini. Katu kembi tuyuvula : “ngeyo mutu wowo wufueti kuiza voti tufueti vingila wunkaka e ?” ");
INSERT INTO yom_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Muna thangu yina, Yesu wubelusa batu bawombo baba mu bimbevo ayi mu minsongo. Wubelusa batu bayamusu kuidi ziphevi zimbimbi ayi wuzibula meso ma baphofo bawombo. ");
INSERT INTO yom_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Buna wukamba kuidi bobo bafidudu : —Luvutuka kudi Yowani ayi lunkamba mambu momo lumueni ayi luwilu ; baphofo zilembu moni ; makoka malembu diati ; batu ba buazi balembu vedusu, batu bafua matu balembu wi, bafua balembu fuluka ; nsamu wumboti wulembu longu kuidi batu basukama. ");
INSERT INTO yom_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Khini kuidi mutu wela manga zimbisa minu kiandi mu diambu diama. ");
INSERT INTO yom_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bamvuala zi Yowani bu zivutuka, Yesu wubaka diluaku di yolukila mambuma Yowani kudi nkangu wu batu : —Mbi biobi luyenda tala ku dikanga e ? Nti wufioti wulembu vevumunu kuidi phemo e ? ");
INSERT INTO yom_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Vayi buna nani luyenda tale e ? Mutu wuvuata minledi mi kitoko e ? Tala batu bobo bamvuatanga minledi mi kitoko ayi banzingilanga mu zikhini mu zinzo zi mintinu bankalanga. ");
INSERT INTO yom_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Vayi buna mbi luyenda tala e ? Mbikudi luyenda tala e ? Nyinga buawu kuandi vayi ndikulukamba ti niandi viokidi mbikudi. ");
INSERT INTO yom_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bila niandi wuyolukulu mu minkanda ti : Tala mfidisidi mvualꞌala ku ntualꞌaku, niandi wela kubika nzilꞌaku ku ntualꞌaku. ");
INSERT INTO yom_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Bukiedika ndikulukamba : mu batu boso bobo babutu kuidi baketo, kuidiko mutu wowo viokidi Yowani. Vayi wulutidi kefa mu kipfumu ki Diyilu wunlutidi. ");
INSERT INTO yom_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","—Batu boso bawa mambu momo ayi mimfutisi mi ziphaku, bazababusonga bu Nzambi bu babotoko kuidi Yowani. ");
INSERT INTO yom_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Vayi Bafalisi ayi minlongi mi mina, bobo bamanga botoko kuidi niandi, va meso mawu baloza luzolo lu Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Banga banani ndenda dedikisa tsungi yayi e ? Yidedikini banga babani e ? ");
INSERT INTO yom_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yidedikini banga bana bafioti bavuedi va zandu ayi balembu kambasana bawu na bawu : Beto tulusikidi nsioni vayi lusia kina ko. Tuyimbila minkunga mi mafua vayi lusia dila ko. ");
INSERT INTO yom_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bila Yowani wuyiza, kasia dia mampa ko ayi kasia nua vinu ko. Vayi lukamba : “Pheve yibmimbi yidi yandi.” ");
INSERT INTO yom_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Muana mutu wuyiza ; wundia, wunua ayi luntuba : “Niandi nzuna kadi ayi kolu mbungu ; nkundi mimfutisi mi ziphaku ayi bankua masumu.” ");
INSERT INTO yom_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Vayi nduenga yimmonikanga yisonga mu nzila yi bana bandi. ");
INSERT INTO yom_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisi wumosi wuleba Yesu mu dia yandi va meza. Yesu wuyenda ku nzoꞌandi ayi wuvuanda va meza. ");
INSERT INTO yom_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Zimbukila va totuka nketo wumosi wu divula, wuba nsumuki. Wuzaba ti Yesu vuendi va meza ku nzo yi Mfalisi buna wunata bungu ki wala malasi, bungu beni kivangulu mu ditadi di alabatele. ");
INSERT INTO yom_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wutelama ku mbusa malu mandi. Wuba dila ayi matsuela mandi mabua mu malu ma Yesu. Buna wufiona mawu mu zitsuki ziandi. Wufifa malu mandi besi ayi wufukudila mawu malasi. ");
INSERT INTO yom_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bu kamona bobo, Mfalisi wowo wutumisa Yesu wuniunguta : enati bukiedika mutu wawu mbikudi nginu bakudingi nani nketowowo wulembu nsimbi nani ayi buevi kadidi ; bila nkento nkua masumu. ");
INSERT INTO yom_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu wunkamba mu mbembo yingolo : —A Simoni, diambu didi yama di kukamba. Buna Mfalisi wumvutudila ti : —A nlongi, tuba kuaku ! ");
INSERT INTO yom_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Buna Yesu wunkamba ti : —Vaba mutu wumosi wudevisa zimbongo kuidi batu buadi. Wutheti wudeva zikhama zitanu zi denali bosi wummuandi wudeva makumatanu. ");
INSERT INTO yom_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sumbu bawu buadi basia ba ko zimbongo zikumvutudila, buna wubalemvukila. Mu mpila yaku, mu bawu buadi ; nani wela luta kunzola e ? ");
INSERT INTO yom_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni wuvutula : —Minu mbueni Mutu wowo wuba pholo yinneni. Buna Yesu wunkamba : —Bukiedika kuaku tubidi. ");
INSERT INTO yom_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bosi wubaluka kuidi nketo ayi wukamba kuidi Simoni : —Mueni nketo wawu e ? Mu thangu khotidingi mu nzoꞌaku, wusia kundatinanga ko nlangu mu diambu ndisukula malu. Vayi niandi bodisidingi malu mama mu matsuela mandi ayi fioniningi mawu mu zitsuki ziandi. ");
INSERT INTO yom_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wusia ku mfifanga besi ko vayi tona buna khotidingi, niandi kakadi vonga mu lembu kafifanga malu mama bibesi. ");
INSERT INTO yom_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wusia dukulanga ko mafuta ku ntu ama vayi niandi dukudingimalasi mu malu mama. ");
INSERT INTO yom_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Diawu ndikukambila ti masumu mawombo momo mabedi yandi malemvokolobila wumonisina luzolo luwombo. Vayi mutu wowo beta lemvukila fioti, niandi mamvandi fioti kaka keti zodila. ");
INSERT INTO yom_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bosi wukamba nketo : —Masumu maku malemvukulu. ");
INSERT INTO yom_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Batu bobo baba yandi va meza bakambasana bawu na bawu ti : “Buna nani mutu wawu wulemvukila masumu ?” ");
INSERT INTO yom_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Vayi Yesu wukamba nketo : —Minu kiaku kivukisidi ; yenda mu ndembama ! ");
INSERT INTO yom_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bosi Yesu wuyenda mu mavula ayi mu mala mu yamikisa ayi mu samuna Nsamu Wumboti wu Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kumi bamvuala buadi banlandakana va kimosi ayi ndambu baketo bobokabelusa bu bayamusu kuidi ziphevi zimbimbi ayi bobo kabelusa mu zimpasi. Baketo beni bawu baba : Maliya baba ntedilanga Maliya muisi Mangadala. Mu niandi katotula ziphevi tsambudi zimbimbi, ");
INSERT INTO yom_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zana nketo Suza mutu wuba lundanga bima bi Elode, Suzani ayi bawombo bankaka baba kunsadisanga mu bima biawu. ");
INSERT INTO yom_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nkangu wuwombo wu batu wuyiza kutakana. Batu beni batotukila mu mavula mavombo. Buna Yesu wuba samunia nongo yayi : ");
INSERT INTO yom_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Nkuni wumosi wuyenda ku muanga mbongo andi. Mu thangu kaba muanga mbongo andi, ndambu yi zitheti yibua mu ndambu yi nzila. Batu badiatila ziawu ayi zinuni zidoda ziawu. ");
INSERT INTO yom_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ndambu yinkaka yi zitheti yibua va matadi. Bu zimena, zivika yuma bilavasia ba mbozi ko. ");
INSERT INTO yom_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Zinkaka zibua va zitsendi. Zitsendi ziyunduka va kimosi ayi mintuidilavayi zitsendi zifietikisa miawu. ");
INSERT INTO yom_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Vayi zinkaka zibua va ntoto wumboti. Zimena ayi zibuta makundi. Kadika luteti lubuta khama yinkaka yi zitheti. Buna katuba mambu momo, wuyamikina : —Woso widi matu ma wila buna bika kawa. ");
INSERT INTO yom_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Minlonguki miandi minyuvula tsundu yi nongo yoyi. ");
INSERT INTO yom_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Buna wuba kamba : —Beno lutambula diluaku di zabila matsueki ma Kipfumu ki Nzambi vayi kuidi bankaka mambu mama mafueti yolokolo mu zinongo muingi ka diambu kobalembu tadi vayi bakadi mona ; ka diambu ko balembu wa vayi balendi sudika ko. ");
INSERT INTO yom_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—Luwa tsundu yi nongo yayi : mbongo yawu mambu ma Nzambi ");
INSERT INTO yom_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mu ndambu nzila yidi batu beti wanga mambu ma Nzambi vayi satana wunkuizanga ayi wunzionanga mawu mu mintima miawu mu diambu di kuba kandika babika wilukila muingi bedi vuka. ");
INSERT INTO yom_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Mbongo yibua va matadi” yidi batu beti wanga mambu ma Nzambiayi beti tambulanga mawu mu khini vayi basiko mianzi. Minu kiawu kizingilanga ko. Mu thangu yi thotolo bavika kukitabilanga. ");
INSERT INTO yom_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Mbongo yibua va zitsendi” yidi batu bobo bawa mambu ma Nzambi ayi bayenda kuawu. Vayi bafietukusu mu diambu di mayindu, bamvuama ayi makhini ma luzingu. Babutanga ko mimbutu milenda yela. ");
INSERT INTO yom_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bosi “mbongo yibua va ntoto wumbote” yidi batu bobo bawa mambuma Nzambi, balunda mawu mu ntima wukambulu mayuya ayi wumbote. Bawu bambutanga mimbutu bu bavibididi. ");
INSERT INTO yom_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Mutu bu kalemisini muinda, kalendi kuwufukidila nzungu kovoti kuwutula ku tsi mbuka ; vayi va yilu meza kafueti wutula mu diambu di bobo bankota bamona kiezila. ");
INSERT INTO yom_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bila mamo masuama mafueti ba va kiesila ; mamo masueku mafueti zabakana ayi totuka va nganda. ");
INSERT INTO yom_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Diawu lulubuka mu mpila lulembu wila bila bela buela vana kuidi mutu wowo beki vayi kudi mutu wowo kambulu bela kunziona, ka diambu ko, biobi kambanza ti bidi yandi. ");
INSERT INTO yom_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngudi yi Yesu ayi bakhomba bandi bayiza kuidi niandi vayi basianunga ko fikama va kaba mu diambu di nkangu wu batu. ");
INSERT INTO yom_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Buna bankamba : —Ngudi aku ayi bakhomba ziaku badi ku nganda ayi batidi kumona. ");
INSERT INTO yom_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu wuba vutudila : —Bobo beti wanga mambu ma Nzambi ayi bansadilanga mawu bawu ngudiama ayi bakhomba ziama. ");
INSERT INTO yom_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lumbu kimosi Yesu wukuma mu nlungu va kimosi ayi minlongukimiandi, buna wuba kamba : —Bika tusabukanu ku disimu dinkaka di mbu. Buna batula ku ngingi nlangu. ");
INSERT INTO yom_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bu baba vuila, Yesu wuleka tulu. Zimbukila vuka kimosi kingolo kitonamu mbu, nlangu wutona wala mu nlungu ayi mu ziphasi miba. ");
INSERT INTO yom_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Minlonguki mifikama vaba Yesu, minkotula mu yamikina : —A nlongi, A nlongi tueka fua ! Wukotuka ayi wutemina vuka ayi mayo ma mbu. Buna biawu bilembama ayi ndembama yivutuka. ");
INSERT INTO yom_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Buna wukamba minlonguki miandi : —A kuevi kuidi minu kieno e ? Vayi bawu bamona tsisi ayi basimina. Ayi bayuvasana bawu na bawu ti : —Buna nani niawu wuntumina vuka ayi nlangu, ayi biawu binkutumukina e ? ");
INSERT INTO yom_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Batula mu zunga ki basi Ngalasa, kitalani ayi ngalili ");
INSERT INTO yom_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu bu kakuluka va disimu buna mutu wumosi muisi divula beniwuba ayi ziphevi zimbimbi tona thama wuyiza kundengana. Pheni nkua kaba kibanga ; kaba vuandanga ko mu nzo vayi ku biziami kaba vuandanga. ");
INSERT INTO yom_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bu kamona Yesu, wubua va ntualꞌandi ayi wutuba mu mbembo yi ngolo : —A diambu mbi tuidi betu yaku, ngeyo muana Nzambi yizangama e ? Wundemvukila, kadi kundiamisa. ");
INSERT INTO yom_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Wutuba bobo mu diambu Yesu wutumina mpeve yimbimbi yitotuka mu mutu wowo. Bila tona thama, mpeve beni yimbila. Buna mutu beni baba kunkanganga ayi kunkebilanga mu zisieni ayi bisengo mu malu vayi wuba kubi tabunanga ayi mpeve yimbimbi yiba kunnatanga mu bibuangu bisuama. ");
INSERT INTO yom_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu wunyuvula : —Dizina diaku nani e ? Niandi wuvutula : —Lengio. Bila ziphevi ziwombo zimbimbi zikota mu mutu beni. ");
INSERT INTO yom_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ziphevi zimbimbi beni zileba Yesu muingi kabika kuba tuma benda ku diyenga. ");
INSERT INTO yom_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nkangu wu zingulu wuba dia vana mbata mongo. Ziphevi zimbimbizileba Yesu muingi zikota mu zingulu beni. Buna wuba vana minsua. ");
INSERT INTO yom_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ziphevi zimbimbi zitotuka mu mutu ayi zikota mu zingulu. Muna yina thangu nkangu wu zingulu wunengumuka mu mongo nate ziyiza bua mu mbu. Buna zidiama. ");
INSERT INTO yom_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mu thangu minsungi mi zingulu mimona mambu momo mavioka, mitina ayi miyenda kamba mambu beni ku divula ayi mu zitsola. ");
INSERT INTO yom_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Batu bayiza tala mambu momo mavioka. Bayiza vaba Yesu ayi bamona mutuwowo wutotulu ziphevi zimbimbi buna kavuendi va malu ma Yesu. Wuvuata minledi ayi diela diandi diduka. Buna bamona boma. ");
INSERT INTO yom_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Batu bobo bamona mambu beni baba kamba buevi bu vukila mutu wowo wuyamusu kuidi ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Vana vawu batu ba zunga ki Ngelasa bu bamona boma bu ngolobuna baleba Yesu kabotuka mu zunga kiawu. Niandi wukuma mu nlungu ayi wuvutuka. ");
INSERT INTO yom_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mutu wowo wukulu mu ziphevi zimbimbi wuleba Yesu muingi kanlandakanavayi Yesu wumvutula ayi wunkamba : ");
INSERT INTO yom_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Vutuka ku nzoꞌaku ayi samuna mambu moso Nzambi kavangidi. Buna mutu beni wuyenda, wuyemikisa, mu divula dioso, mambu Yesu kamvangila. ");
INSERT INTO yom_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bu kavutuka, nkangu wu batu wuyakula Yesu bila batu boso baba kumvingila. ");
INSERT INTO yom_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tala mutu wumosi dizina diandi Yayilusi. Niandi wuba pfumu yi nzo yi lukutukunu, wuyiza ayi wubua va malu ma Yesu, wunleba mu diambu kiza ku nzo andi ");
INSERT INTO yom_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","bila muanꞌandi wumosi kaka wunketo, wuba nduka-nduka kumi mimvu miodi wuba nduka mu fua. Bu kaba kuenda vayi nkangu wu batu wumfietikisa. ");
INSERT INTO yom_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nketo wumosi wuba kimbevo kiviokanga menga ; kumi mimvu miodi kabedila kimbevo beni ayi wumana fukisa bima biandi bioso kuidi minganga. Vayi kadi munganga wumosi kasia nunga ko mu kumbelusa. ");
INSERT INTO yom_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wufikama ku manima ma Yesu ayi wusimba tsongi nledi andi. Vana vawu menga makangama. ");
INSERT INTO yom_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Buna Yesu wuyuvula : —Nani wutsimbidi. Baboso bamanga kuawu kikinina. Diawu Piela kankambila va kimosi ayi bobo baba yandi : A Nlongi, nkangu wu batu wuzungididi ayi wufietikisidi ku zindambu zioso. ");
INSERT INTO yom_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Vayi niandi wuvutula : —Mutu wumosi wutsimbidi bila nzebi ti lulendo lutotukidi mu munu. ");
INSERT INTO yom_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nketo beni bu kamona ti kalendi suama ko, buna, wuyiza ayi lunkuku, wufukama va malu ma Yesu. Wusudikisa va ntuala wu batu boso bila kiokikansimbila ayi buevi kabelukididi. ");
INSERT INTO yom_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu wunkamba : —A muanꞌama wunketo, minu kiaku kivukisidi, yenda mu ndembama. ");
INSERT INTO yom_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Buna kamanisini ko tuba, mutu wuba kuidi pfumu nzo yilukutukunu wuyiza ayi wunkamba : —Muanꞌaku wunketo fuidi, bika buela yamisa nlongi. ");
INSERT INTO yom_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu bu kawa bobo, wukamba Yayilusi ti : —Bika mona boma vayi wilukila kaka bila muanꞌaku wunketo wela beluka. ");
INSERT INTO yom_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bu katula ku nzo, wukandika batu boso babika kota mu nzobotula kaka Piela, Yowani, Zaki ayi dise ayi ngudi yi muana ndumba. ");
INSERT INTO yom_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Batu boso badila ayi banionga mu diambu diandi ayi wuba kamba : —Bikanu dila bila kadi fua ko, tulu tuandi kalekidi. ");
INSERT INTO yom_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Batu baba kunsekinina bila bazabati fuidi. ");
INSERT INTO yom_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Buna Yesu wusimba koko ku muana ndumba ayi wutuba mu mbembo yingolo : —Muanꞌama, telama kuaku. ");
INSERT INTO yom_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Buna wufuluka ayi wutelama ; Yesu wuvana minsua mu diambu bamvana bidia. ");
INSERT INTO yom_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Zimbuta zi muana ndumba zisimina. Yesu wuba kandika babika kambakadi kuidi mutu wumosi mambu maviokidi. ");
INSERT INTO yom_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu wukutikisa kumi mimvuala miodi ayi wuba vana lulendo ayi luyalu lu totudila ziphevi zioso zimbimbi ayi lubelusila bambevo. ");
INSERT INTO yom_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bosi wuba tuma benda yamikisa luyalu lu Nzambi ayi wuba tuma babelusa bambevo. ");
INSERT INTO yom_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wuba vana zithumunu ziazi : —Kadi nata kadi kiasa mu nzila : kadi nata nkawa, kadi tsaku, kadi khuta, kadi zimbongo. Kadi mutu kanata kikhutu kiviakisa. ");
INSERT INTO yom_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yoso nzo luela kota buna luvuanda muna nate luela botuka va divula beni. ");
INSERT INTO yom_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Enati bamengi kulutambula buna mu thangu luela totuka mu divula beni, buna luba kukumuna mbungi-mbungi yi malu meno muingi kiba kimbangi kuidi bawu. ");
INSERT INTO yom_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Buna miyenda. Midiengila mu mala moso. Milonga nsamu Wumbote ayi mibelusa bambevo mu bibuangu bioso. ");
INSERT INTO yom_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nyadi Elode wawu zitsangu zi mambu mamo mavioka, wukiyamisangolo. Bila bankaka batuba : “Yowani niandi wufulukidi mu bafua !” ");
INSERT INTO yom_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Vayi bankaka : “Eli niandi wumonikini.” Vayi bankaka “Niandi widi mbikudi wumosi mu mimbikudi mikhulu, niandi fulukidi.” ");
INSERT INTO yom_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Vayi Elode wuba tuba : —Keti minu veka ndizengisa Yowani ntu ! Vayi buna nani mutuwowo, ndilembu wilanga mambu momo ? Buna wutomba nzila mu kummona. ");
INSERT INTO yom_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mimvuala mivutuka ayi mivumbudila Yesu kipholo ki mamo mivanga ; wuba nata va lutengo ku ndambu divula dibeti tedila Betisayida. ");
INSERT INTO yom_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Vayi nkangu wu batu bu bazaba nsamu beni, buna banlandakana. Yesu wuba yakula, wuba yolukila nsamu wu kipfumu ki Nzambi ayi wu belusa batu baba tsatu yi belusu. ");
INSERT INTO yom_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Buisi buna bueka yila, kumi mimvuala miodi va kaba ayi minkamba : —Vutula nkangu wu batu muingi benda mu mala ayi mu zitsola zifikimini mu diambu babaka bidia ayi minleku bila va buangu kikambulu batu tuidi. ");
INSERT INTO yom_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Vayi Yesu wuba kamba : —Luba vananu beno veka bidia. Vayi bawu bavutula : —Mampa matanu kaka madi yeto ayi zimbizi zizole zi nlangu. Mananga tidi beto veka tuenda sumbi bidia mu diambu di batu boso baba e ? ");
INSERT INTO yom_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bila nduka-nduka mili tanu yi babakala yiba vana. Yesu wukamba minlonguki miandi : —Luba vuandisa mu makabu ma makumatanu ma batu. ");
INSERT INTO yom_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Buawu mivanga ayi mivuandisa batu boso. ");
INSERT INTO yom_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Buna Yesu wubonga mampa beni matanu ayi zimbizi beni zizole zi nlangu. Wumvumbula meso ku Yilu, wusakumuna mawu bosi wubukuna mawuayi wuvana mawu minlonguki miandi mu diambu bakabudila nkangu wu batu. ");
INSERT INTO yom_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bawu boso badia ayi bayukuta. Mu bitini bisiadidila, batota kumi bipani biodi. ");
INSERT INTO yom_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lumbu kimosi Yesu kaba sambila va lutengu, minlonguki miandi miba yandi va kimosi. Buna wuba yuvula : —Buevi batu beti tubanga ; minu ndidi nani e ? ");
INSERT INTO yom_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Minlonguki mimvutudila : —Bankaka beta tuba widi Yowani Mbotikii ; bankaka Eli ; bankakabeta tuba widi wumosi mu mimbikudi mi tsi khulu wufulukidi. ");
INSERT INTO yom_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Buna wuba yuvula : —Vayi benu veka, lueta tuba ti minu ndidi nani e ? Buna Piela wumvutudila : —Ngeyo widi Klisto, wu Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Buna Yesu wuba kamba : —Lubika kamba mambu mama kadi kuidi mutu wumosi. ");
INSERT INTO yom_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Buna wubuela diaka : —Muana Mutu kafueti mona ziphasi ziwombo ayi bakulutu ba batu, bapfumu zi zinganga ayi minlongi mi mina miela kunloza. Wela vondu vayi wela fuluka mu lumbu kintatu. ");
INSERT INTO yom_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Buna wukamba batu boso ti : —Enati mutu tidi kundandakana buna kafueti kukizimbakana niandi veka vayi kabonga dikulusi diandi kadika lumbu ayi kandandakana. ");
INSERT INTO yom_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bila woso tidi keba luzingu luandi wela luzimbisa vayi wosowela luzimbisa mu diambu diama, buna wela luvukisa. ");
INSERT INTO yom_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Enati mutu beki ntoto wumvimba vayi wukizimbisidi voti wukibivisidiniandi veka, buna ndandu mbi kambaka e ? ");
INSERT INTO yom_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Enati mutu wumfuididi tsoni voti fuidi tsoni mu diambu di mambu mama, buna Muana mutu wela kumfuila tsoni bu kela kuizila mu nkembuꞌandi, mu nkembo wu Tata ayi wu zimbasi zinlongo. ");
INSERT INTO yom_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bukiedika ndikulukamba ti batu bankaka badi vava balendi ba fuako nate bela mona kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Dinana di bilumbu bu bivioka, landila mambu momo, Yesu wubonga Piela, Yowani ayi Zaki ayi wuyenda ku mbata mongo mu kuenda sambila. ");
INSERT INTO yom_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mu thangu kaba sambila, zizi kiandi kikituka, minledi miandimieka miphembi dio lio, milezama banga lusiemo. ");
INSERT INTO yom_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Batu buadi baba solula yandi : Moyize ayi Eli. ");
INSERT INTO yom_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mu bawu mu monika nkembo. Bayolukila lufua lolo kela dukisa ku Yelusalemi. ");
INSERT INTO yom_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piela ayi bakundi bandi buadi baba baleka. Mu thandu bakotuka, bamona nkembo wu Yesu ayi bamona batu beni baba buadi baba yandi. ");
INSERT INTO yom_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mu thangu batu beni baba nduka vambana ayi Yesu, Piela wunkamba : —Pfumu, bulutidi mboti tukala kuetu vava. Tueka tunga zinzozitatu zikapu : yimosi mu diambu diaku, yimosi mu diambu di Moyize, yimosi mu diambu di Eli. Vayi kasia zaba ko mambu momo katuba. ");
INSERT INTO yom_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Buna wukidi tubi, dituti dimosi diyiza ayi diba fukidila. Buna minlonguki mimona tsisi mu thangu mikota mu dituti. ");
INSERT INTO yom_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Buna mbembo yitotuka mu dituti beni yiwakana : —Niandu niandi Muanꞌama wundisobula, lunwila ! ");
INSERT INTO yom_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mbembo yoyo bu yiwakana, Yesu niandi veka wusiala. Vayi bawu baba dio sui ; Mu bilumbu bina basia yolukila ko kadi kuidi mutu wumosi mambu momo bamona. ");
INSERT INTO yom_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mu lumbu kilanda bu baba kuluka mongo, nkangu wu batu wuyiza dengana Yesu. ");
INSERT INTO yom_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Muna nkangu beni mutotukila mutu wumosi wuyamikina : —A Nlongi, ndikuleba, tala muanꞌama wubakala. Wawu kaka muana widi yama. ");
INSERT INTO yom_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mpeve yawu kumbuila, buna muana wunyamikinanga. Mpeve beni yinkuntutumunanga, yikuntotulanga difulu ayi bu yimeni kumvongisa bunabosi yinkumbikanga. ");
INSERT INTO yom_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ndebidingi minlonguki miaku muingi miyitotula vayi misi nunganga ko. ");
INSERT INTO yom_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Buna Yesu wuvutula : —Tsungi yikambulu minu ayi yimbimbi ! Zithangu zikua ndielakadilanga yeno diaka va kimosi ? Zithangu zikua ndiela buela kangilanga ntima mu bila kieno e ? Buna wukamba mutu beni ti : —Tuala muanꞌaku vava ! ");
INSERT INTO yom_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mu thangu muana kaba fikama, mpeve yimbimbi yinlumba va ntotoayi yitona kuntutumuna ngolo. Buna Yesu wutemina mu kingolo mpeveyimbimbi. Buna wubelusa muana wubakala ayi wutambika wawu kuidi Siandi. ");
INSERT INTO yom_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Babo basimina mu diambu di bunneni bu Nzambi. Buna babo bakidi simina mu diambu di mambu moso momo Yesu kaba vanganga, buna wukamba minlonguki miandi : ");
INSERT INTO yom_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Lulunda bumbote mama luwilu bila Muana Mutu weka yekulu mu mioko mi batu. ");
INSERT INTO yom_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Vayi minlonguki misia sudika ko mambu momo. Baba suekila tsundu yi mambu beni mu diambu mibika sudika. Ayi mimona tsisi mu yuvula tsunduyi mambu momo. ");
INSERT INTO yom_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ziphaka zitotuka mu bawu na bawu mu diambu di zaba nani lutidi munneni. ");
INSERT INTO yom_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu bu kazaba mayindu mawu ma mintima miawu, wubonga muanalezi, wuntedimisa va ndambu andi ");
INSERT INTO yom_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ayi wuba kamba : —Woso mutu wunyakula muana wawu mu dizina diama buna minu kuandi kayakudi. Ayi woso wundiakudi buna yakudi diaka mutu wowo wuntuma. Bila woso lutidi keva mu beno, buna niandi lutidi munneni. ");
INSERT INTO yom_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Buna Yowani wunkamba : —A nlongi, tumueningi mutu wumosi wulembu totulanga ziphevizimbimbi mu dizina diaku. Vayi tunkandikidingi bila kadiatanga yetu va kimosi ko. ");
INSERT INTO yom_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Vayi Yesu wumvutudila ti : —Lubika kunkandika bila woso kambulu bumbeni kudi beno buna ku ndambu eno kadi. ");
INSERT INTO yom_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Thangu yoyi Yesu kafueti kuendila ku diyilu bu yifuana, bunawubaka lukanu lu kuenda ku Yelusalemi. ");
INSERT INTO yom_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wufidisa mimvuala ku ntualꞌandi. Buna miyenda mikota mu buala bumosi bu Samali mu diambu minkubikila nleko. ");
INSERT INTO yom_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Vayi basi Samali bamanga ku ntambula bila ku Yelusalemi kaba kuenda. ");
INSERT INTO yom_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Minlonguki miandi, Zaki ayi Yowani, bu mimona bobo, mituba : —Pfumu, tidi tutumina mbazu, yintotukila ku diyilu, yibuila batu baba muingi yiba yoka ? ");
INSERT INTO yom_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Vayi Yesu wubaluka ayi wuba temina. ");
INSERT INTO yom_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Buna bayenda ku buala bunkaka. ");
INSERT INTO yom_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Buna bakidi mu nzila mutu wumosi wuyiza kamba Yesu : —Nlongi thidi kulandakana koso ku wunkuenda. ");
INSERT INTO yom_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu wumvutudila : —Mimbaku midi ayi minsuku miawu momo mieta leka ayi zinuni zidiayi zindiala ziawu vayi muana mutu kasi ko buangu kivundisila ntu andi. ");
INSERT INTO yom_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu wukamba kuidi wunkaka : —Ngeyo ndandakana. Vayi mutu beni wumvutudila : —A Pfumu, phani minsua ndienda tuami ziki siama. ");
INSERT INTO yom_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Buna Yesu wunkamba : —Bika bazika batu bawu bafua vayi ngeyo yenda samuna Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wunkaka diaka wunkamba : —A Pfumu, ndiela kulandakana vayi bika theti ndienda vanimboti zitsuka kuidi dikanda diama. ");
INSERT INTO yom_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Vayi Yesu wumvutudila : —Mutu wowo simbidi tsengu mu sala mu tsola vayi tedi ku manima, kasi fuana ko mu diambu di Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Momo bu mavioka, Pfumu wusobula diaka lusambudi lu makumi ayi minlonguki miodi ; wuba tuma buadi-buadi muingi bantuaminina ku ntuala mu mavula moso ayi mu bibuangu bioso biobi niandi veka kafueti viokila. ");
INSERT INTO yom_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wuba kamba : —Makundi meka mawombo mu ndima vayi bisadi bidi bifioti. Diawu luleba Pfumu yi ndima muingi kafidisa bisadi mu ndimꞌandi. ");
INSERT INTO yom_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tala minu ndiludidisidi banga mameme va khatitsika memvu. ");
INSERT INTO yom_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lubika nata kadi photimoni, kadi sakosi, kadi zisapatu ayi lubika vana kadi mutu mbote mu nzila. ");
INSERT INTO yom_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bu luela kota mu nzo yimosi, lutuba theti : “Bika ndembama yiba mu nzo yayi”. ");
INSERT INTO yom_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Enati mutu wundembama wudi mu nzo beni buna ndembama yeno yela ba mu niandi vayi enati buawu ko buna ndembama beni yela luvutukila. ");
INSERT INTO yom_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Buna luvuanda mu nzo beni, ludia bidia bela kuluvana ayi lunuanduinu bena kuluvana bila “kisadi kifueni mu tambula mfutu andi.” Lubika ba ti lueka nzo yayi, luedi mu nzo yina. ");
INSERT INTO yom_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mu dioso divula di lunkota ayi enati baluyakudi buna ludia bioso bela kuluvana, ");
INSERT INTO yom_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","lubelusa bambevo ziela ba muna ayi luba kamba : “Kipfumu ki Nzambiki lufikimini.” ");
INSERT INTO yom_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Vayi mu dioso divula di lunkota ayi enatibamengi kuluyakula buna lutotuka mu zinzila zi divula beni ayi lutuba : ");
INSERT INTO yom_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ka diambu ko mbungi-mbungi yi divula dieno yinemi mu malumeto, tueka yikukumuna ; vayi luzaba diadi ti Kipfumu ki Nzambi ki fikimini.” ");
INSERT INTO yom_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ndikulukamba ti mu lumbu kina, thumbudulu yi divula dina yelaviatuka thumbudulu ui Sodoma. ");
INSERT INTO yom_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mabienga kuidi ngeyo Kolazini ! Mabienga kuidi ngeyo Betesayida ! Bila enati bikumu bivangulu va khatitsikꞌeno biawu bivangulu ku Tile ayi ku Sidoni, nganu thama batu ba mavula beni babalula mavanga mawu ayi mu monisa buawu mu vuata zitsaku ayi mu kivinda dibombi. ");
INSERT INTO yom_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Vayi mu lumbu ki tsambusu, thumbudulu yeno yela viatuka yi Tile ayi yi Sidoni. ");
INSERT INTO yom_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A ngeyo Kafalinawumi, ngeyo wummuena ti wela tombulu nateku diyilu e ? Wela kululu nate ku tsi yi bafua ! ");
INSERT INTO yom_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Buna wubuela diaka : —Woso mutu wukuluwila buna minu kuandi kawilu ; ayi woso mutu wululozidi buna minu kuandi kalozidi vayi woso mutu wundozidi buna lozidi mutu wowo wuthuma. ");
INSERT INTO yom_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Lusambudi ayi minlonguki miodi mivutuka, khini ayi mituba : —A Pfumu, ka diambu ko ziphevi zimbimbi zitutumimini beto kuzivana zithumunu mu dizina diaku. ");
INSERT INTO yom_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Niandi wuba vutudila : —Ndimueni satana wubuidi va tsi banga lusiemo. ");
INSERT INTO yom_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tala ; ndiluveni lulendo lu diatila zinioka, zikhutu ayi kipfumu va lulendo loso lu mbeni ayi kadi kima kimosi kilendi kuluvanga mbimbi ko. ");
INSERT INTO yom_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Muaki lubika mona khini mu diambu ziphevi zilutumimini vayi lumona khini mazina meso bu madi masonama ku Diyilu. ");
INSERT INTO yom_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Muna thangu beni, Yesu wumona khini mu Mpeve ayi wutuba : —A Tata, Pfumu yi Diyilu ayi yi ntoto, ndikukembisa bila wusuekamambu mama kuidi batu banduenga ayi badiela vayi wumonisini mawu kuidi bana balezi. Nyinga, tata, mu luzolo luaku buawu bobo wumuenina. ");
INSERT INTO yom_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dise diama dindiekudila mambu moso kuisi ko mutu zebi muana botula kaka Dise. Kuisi ko mutu zebi Dise botula kaka Muana ayi woso-woso mutu wowo Muana katidi monikisa Dese. ");
INSERT INTO yom_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bu kabaluka kuidi minlonguki miandi, buna wuba kamba va bawu veka : —Khini kuidi batu balembu moni mambu momo lulembo moni ! ");
INSERT INTO yom_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bila bukiedika ndikulukamba mimbikudi miwombo ayi mintinumiwombo mizola mona mambu momo lulembo moni vayi misia mamona ko ; mizola wa mambu momo lulembo wi vayi misia mawa ko. ");
INSERT INTO yom_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nlongi wumosi wu Mina wutelama ayi wuyuvula Yesu kiuvu mu kumfiela ayi wunkamba : —A nlongi, diambu mbi mfueti vanga muingi ndibaka luzingu lukalimani e ? ");
INSERT INTO yom_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu wumvutudila : —A mambu mbi masonama mu mina ? Mambu mbi wuntanganga muna e ? ");
INSERT INTO yom_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Niandi wumvutudila : —Fueti zola Pfumu Nzambi aku mu ntimꞌaku wumvimba, mu muelꞌakuwumvimba, mu zingolo ziaku zioso, mu mayindu maku moso ayi fueti zolandiaku banga bobo weta kukizodila ngeyo veka. ");
INSERT INTO yom_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu wumvutudila : —Ngeyo vutudi bumboti, vanga buawu buna wela zinga. ");
INSERT INTO yom_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Vayi nlongi wu mina beni wuzola kukinungisa, wubuela yuvula Yesu : —A buna nani ndiama e ? ");
INSERT INTO yom_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Buna Yesu wumvutudila : —Kuba mutu wumosi wuba ku Yelusalemi wuba kuenda ku Yeliko ; wudengana mivi. Minziona bima biandi bioso ; minlueka miyenda kuawu ayi mimbika weka nduka fua. ");
INSERT INTO yom_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Vayi nganga Nzambi yimosi yiviokila mu nzila beni, wumona mutu beni vayi wuzengisa ku ndambu yinkaka ayi wuyenda kuandi. ");
INSERT INTO yom_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bobuawu, wumosi mu dikanda di Levi wutula vana buangu beni, wumona mutu beni, wuzengisa ku ndambu yinkaka ayi wuyenda kuandi. ");
INSERT INTO yom_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Vayi muisi Samali wumosi wuba viokila vana, wutula va ndambu vaba mutu beni. Bu kamona mutu, wummona kiadi. ");
INSERT INTO yom_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wufikama va kaba, wutula mafuta ayi vinu mu zimputa ziandi ayi wuzizinga ziphasima. Bosi wuntula va yilu mpundꞌandi, wunnata ku nzo yi banzenza ayi kuna kansadisa bumboti. ");
INSERT INTO yom_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mu lumbu kilanda, wubonga denali biodi, wuvana biawu kuidi pfumu yi nzo yi banzenza ayi wunkamba : “Sadisa bumbote mutu wawu. Zimbongo zioso wela fukisa va yilu, minu veka ndiela kuvutudila ziawumu thangu ndiela vutuka.” ");
INSERT INTO yom_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Buna Yesu wubuela diaka : —Kuidi ngeyo, mu bawu batatu nani wumonikini ndiandi kuidi mutu wowo wuvangu phasi kuidi mivi e ? ");
INSERT INTO yom_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Buna nlongi wu mina beni wuvutula : —Mutu wowo wummona kiadi. Buna Yesu wunkamba : —Yenda ayi vanga banga mutu wuna. ");
INSERT INTO yom_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Buna bakidi mu nzila, Yesu wukota mu buala bumosi. Kunakuba nketo wumosi, dizina diandi Malite, wunyakula ku nzoꞌandi. ");
INSERT INTO yom_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wuba ayi khombꞌandi yinketo, dizina diandi Maliya. Niandi wuyiza vuanda va malu ma Yesu ayi wuba lembu kawanga mambu matuba Yesu. ");
INSERT INTO yom_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Vayi Malite wukiyekula mu bisalu biwombo. Buna wufikama vaba Yesu ayi wunkamba : —A nlongi, disi kuvanga phasi ko mu mona ti khombꞌama wundiekudidi bisalu bioso e ? Nkambi kiza tsadisa. ");
INSERT INTO yom_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Vayi Yesu wumvutudila : —Malite, Malite, ngeyo weka mayindu ayi wulembo kukiyamisamu diambu di mambu mawombo ! ");
INSERT INTO yom_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Vayi diambu dimosi kaka dilutidi mfunu. Maliya niandi sobudi kukukimbote ayi balendi kunziona kiawu ko. ");
INSERT INTO yom_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bu kaba sambila va buangu kimso ; bu kamanisa, nlonguki andi wumosi wuyiza ayi wunyuvula : —A Pfumu, wutulongisa sambila banga Yowani bu kalongisila minlonguki miandi. ");
INSERT INTO yom_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Buna wuba vutudila : —Mu thangu lunsambila, lutubanga : Tata, Bika dizina diaku diba dinlongo Bika Kipfumu kiaku kiza ");
INSERT INTO yom_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wutuvana, kadika lumbu, bidia bioni bifueni ");
INSERT INTO yom_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Wutulemvukila masumu meto bila beto mamveto tueti lemvukila bobo bakutu vangilanga mambimbi ayi kadi kutubika tubua mu phukumunu. ");
INSERT INTO yom_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Buna wubuela diaka : —Zimbukila mutu wumosi mu beno widi ayi nkundi andi, ayi wedi va khatitsika builu mu kunkamba : “A nkundi ama, ndevisa mapha matatu ");
INSERT INTO yom_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","bila nkundi ama wumosi meba mu nzietolo weka yama kuna nzo vayi ndisi ko kadi kima ki kunyakudila.” ");
INSERT INTO yom_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Vayi mutu wowo widi mu khati nzo maka mvutudila : “Bila kundiamisa, muelo wukangiminingi ayi bana bama ayi minu veka tukilekidingi ; diawu ndilendi kotuka ko mu diambu ndivana mawu.” ");
INSERT INTO yom_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bukiedika ndikulukamba, kadiambu ko kalendi kotuka ko mu diambu di kumvana mawu bila kadi nkundi andi vayi wela kotuka bila mutu wunawulembu nyamisa, buna wela kumvana bibioso, boso buididi mfunu andi. ");
INSERT INTO yom_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—Diawu ndikulukambila ti : lulomba ayi luela tambula ; lutomba ayi luela bakula ; lukokuta ayi luela zibudulu. ");
INSERT INTO yom_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bila woso wunlombanga niandi wuntambulanga ; woso wuntombanga niandi wumbakulanga ayi woso wunkokutanga niandi wunzibudulungu. ");
INSERT INTO yom_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nani mu beno, madise, lenda vana muanꞌandi nioka bu kanlombidi mbizi yi nlangu e ? ");
INSERT INTO yom_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Voti kumvana khutu niandi bu kanlombidi diki e ? ");
INSERT INTO yom_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Buna enati beno batu bambimbi luzebi vana bana beno bima bimbotebuna dise dieno didi ku diyilu wela luta vana Mpeve yinlongo kuidi bobobakunlombanga yawu. ");
INSERT INTO yom_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Buna wutotula mpeve yimbimbi yi dibaba. Mpeve yimbimbi bu yitotuka, dibaba dieka yoluka ayi nkangu wu batu wusimina. ");
INSERT INTO yom_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Vayi ndambu yi batu mu bawu batuba : —Keti mu lulendo lu Belezebuli, pfumu yi ziphevi zimbimbi, kalembo totudila ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bankaka mu kumfiela banlomba dimbu kintotukila ku diyilu. ");
INSERT INTO yom_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Vayi kazaba mayindu mawu, buna wuba kamba : —Kipfumu kioso kivasukidi kiawu veka kifueti muangana ayi nzo yivasukidi yawu veka yifueti bua. ");
INSERT INTO yom_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Enati satana vasukidi niandi veka, buna buevi kipfumu kiandikilenda zingila e ? Bila beno lulembo tubi ti mu lulendo lu Belezebuli ndilembo totudila ziphevi zimbimbi. ");
INSERT INTO yom_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Enati bukiedika ti mu lulendo lu Belezebuli ndilembo totudila ziphevi zimbimbi, buna nani wuvana bana beno lulendo lutotudila ziawu e ? Diawu bela ba mazuzi meno. ");
INSERT INTO yom_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Vayi enati mu lulendo lu Nzambi ndilembu totudila ziphevi zimbimbibuna luzaba ti kipfumu ki Nzambi kieka vadi beno. ");
INSERT INTO yom_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mutu widi ngolu ayi widi binduanina bifuana bu kalembu sungi nzoꞌandi buna bima biandi bidi mu ndembama. ");
INSERT INTO yom_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Vayi enati vatotukidi mutu wunlutidi ngolu ayi wunnungini buna ma kanziona binduanina biandi bioso bi kabedi tudilanga diana, ma kanziona bima biandi bioso ayi ma kakabula biawu. ");
INSERT INTO yom_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Woso kambulu ku ndambu ama buna mbeni ama, ayi woso wunkamba kupika yama buna niandi lembu sasikisa. ");
INSERT INTO yom_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—Mu thangu mpeve yimbimbi yitotukidi mu mutu, buna yindiengilangamu bibuangu biyuma mu tomba luvundulu vayi enati yikadi baka buangu, buna yintubanga : “Bika ndivutuka mu nzoꞌama yoyi nditotukila.” ");
INSERT INTO yom_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bu yivutukidi buna yimbabanga nzoꞌandi yinkombulu ayi yikubulu bumboti. ");
INSERT INTO yom_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Bosi yimvutukanga ayi yimbonganga tsambudi di ziphevi zinkaka, zimviatukidi nganzi. Bu zikotidi buna zinkalanga muna. Buna khadulu yi zimunina yi mutu wowo yilutidi biva ayi yina yithete. ");
INSERT INTO yom_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Muthangu kaba tuba bobo, nketo wumosi wuba muna nkangu wuyamikina : —Khini kuidi nketo wubuta ayi wuyemika. ");
INSERT INTO yom_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Vayi Yesu wumvutudila : —Khini kuidi bobo beti wanga ayi beti tumukinanga mambu ma Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nkangu wu batu bu wukutakana, buna wutuba : —Tsungi yayi yidi tsungi yimbimbi yilembo tombi dimbu. Dimbu … Yilendi tambula dimbu dinkaka ko boyula kaka ko botula kakakioki ki Zonasi. ");
INSERT INTO yom_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bila banga bubela Zonasi dimbu kuidi basi Ninive, buawu bobo Muana Mutu kela bela dimbu kuidi batu ba tsungi yayi. ");
INSERT INTO yom_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mu lumbu ki tsambusu, ntinu wu nketo wu Sude wela telama va kimosiayi batu ba tsungi yayi ayi wela bazengila nkanu. Bila niandi wubaku tsongi ntoto mu diambu di kuiza wa malongi ma diela ma Salomo. Muaki tala mutu widi vava viatukidi Salomo. ");
INSERT INTO yom_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mu lumbu ki tsambusu basi Ninive bela telama va kimosi ayi batu ba tsungi yayi ayi bela bazingila nkanu bila bawu babalula mavanga mawu bu bawa malongi ma Zonasi. Muaki vava vadi mutu wuviatukidi Zonasi. ");
INSERT INTO yom_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kuisi ko mutu bu kameni lemisa muinda, wuntulanga wawu va buangu kisuama voti ku tsi katini. Vayi wuntulanga wawu va yilu meza mu diambu babo bankota mu nzo bamona kiezila kiandi. ");
INSERT INTO yom_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","—Meso maku mawu muinda mu nitu aku. Mu thangu meso maku madi mamboti buna nitu aku yimvimba yidi mu kiezila. Vayi enati madi mambimbibuna nitu aku yimvimba yidi mu tombi. ");
INSERT INTO yom_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Diawu lubuka mu diambu di kiezila kidi mu ngeyo kibika kituka tombi. ");
INSERT INTO yom_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Diawu enati nitu aku yimvimba yidi mu kiezila, mu kambu ndambu yi nitu mu tombi buna yela ba yikienzuka ngolo banga mu thangu muinda wukukienzulanga mu nlaki andi. ");
INSERT INTO yom_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bu kaba yoluka, Mfalisi wumosi wuntumisa mu dia ku nzoꞌandi. Bu kakota wuvuanda va meza. ");
INSERT INTO yom_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mfalisi bu kamona bobo, wusimina bila Yesu kasi kisukula ko tuamina kadia. ");
INSERT INTO yom_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Buna Pfumu wunkamba : —Bena Bafalisi lunsukulanga bumboti va mbata yi kopo ayi yi dilonga vayi mu khati lufulukidi ayi mayindu ma buivi ayi mambimbi. ");
INSERT INTO yom_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Beno luidi bivulu ! Mutu wowo wuvanga va mbata kasia vanga ko mu khati e ? ");
INSERT INTO yom_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Luvana bima biobi bidi yeno kuidi minsukami buna bosi bima bioso biela ba bivedila. ");
INSERT INTO yom_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Vayi mabienga kuidi beno Bafalisi bila lumvananga kuku ki kumi ki mintindu mioso mi biti ayi ki “meti ayi li” vayi lunlenzanabusongaayi luzolo lu Nzambi. Nganu mawu mama mambu lufueti vanganga ayi kadi zimbaka mana. ");
INSERT INTO yom_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mabienga kuidi beno Bafalisi bila lunzolanga vuanda mu bibuangubinzitusu mu zinzo zi zikhutukunu ; lunzolanga baluvaninanga mbotimu bibuangu bi batu bawombo. ");
INSERT INTO yom_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mabienga kuidi beno ! Ludedikini banga mabumbi mankumbu monika ; batu balembu madiatidila mu kambu zaba. ");
INSERT INTO yom_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Vana vawu nlongi wumosi wu mina wuyuvula Yesu ti : —Nlongi, bu wulembu tubi mambu momo buna beto kuandi wulembo fingi. ");
INSERT INTO yom_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Buna Yesu wumvutudila ti : —Mabienga ayi kuidi beno minlongi mi mina bila lueta kuika batu bizitu bidi zitu mu nata vayi beno veka kadi nlembo eno wumosi wusimbanga ko bizitu beni. ");
INSERT INTO yom_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mabienga kuidi beno bila lueta tunga mabumbi ma mimbikudi ayi bakulu beno baba vonda. ");
INSERT INTO yom_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lueta telimina mavanga ma bakulu beno kimbangi ayi lueti monangakhini. Bila bawu baba vonda vayi beno luntunganga mabumbi mawu. ");
INSERT INTO yom_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Diawu nzayilu yi Nzambi yitubila ti : “Ndiela kuba fidisila mimbikudi ayi bamvuala, bela vondabankaka ayi bela yamisa bankaka.” ");
INSERT INTO yom_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Muingi menga ma mimbikudi mioso matengulu tona va vangimina ntoto mela tombulu va tsungi yayi ");
INSERT INTO yom_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tona mu menga ma Abeli nate mu menga ma Zakali, mutu wowo bavondila va khatitsika diziku dinyokulungu makaba ayi nzo Nzambi. Bukiedika ndikulukamba mambu moso momo mela builu batu ba tsungi yayi. ");
INSERT INTO yom_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mabienga kuidi beno minlongi mi Mina, beno luziona tsabi yinzayilu. Kadi sia ti beno veka lu kotanga ko vayi lunkandikanga bobo bazola kota. ");
INSERT INTO yom_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bu kabotuka vana, minsoniki ayi Bafalisi batona kumfietikisaayi banzonzisa mu mambu mawombo ; ");
INSERT INTO yom_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","banlekila mintambu ; batomba diambu dilenda totukila mu munuꞌandi muingibabaka bila ki kumfundila. ");
INSERT INTO yom_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Muna thangu yina, nkangu wu batu wuwombo-wombo wukutakana, babandiatasana bawu na bawu mu malu. Buna Yesu wutona kamba theti minlonguki miandi : —Lulubukila luvi lu Bafalisi. Mayuya mawu luawu luvi beni. ");
INSERT INTO yom_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bila kuisi ko diambu disuama diela kambu zabukusu voti kuisi ko matsueki mela kambu zabakana. ");
INSERT INTO yom_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Diawu mambu moso luyolukila mu tombi mela wakakana ku kiezila ayi momo luyolukila va dikutu, mu bivinga, mela yamukusu ku mbata muangu. ");
INSERT INTO yom_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ndikulukamba, beno bakundi bama, lubika mona tsisi bobo balenda vonda nitu bila bawu vonga bobo balendi buela vanga diambu dinkaka ko. ");
INSERT INTO yom_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Vayi ndieka kulumonisa bobo lufueti mona tsisi : Lutina mutu wowo beki lulendo lu lozila ku bulungi bu kameni vonda. Bukiedikandikulukamba, niandi mutu lufueti mona tsisi. ");
INSERT INTO yom_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Basumbisanga ko zitsiodila zitanu mu zimbongo zizole zi bisengo e ? Vayi Nzambi kasi zimbakana ko kadi yimosi mu zizioso. ");
INSERT INTO yom_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ayi zitsuki zi mintu mieno zidi zitangu. Lubika mona tsisibila lulutidi nkangu wu zitsiodila mu luvalu. ");
INSERT INTO yom_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Bukiedika ndikulukamba ti woso mutu wela kuntelimina kimbangi vameso ma batu, muana mutu mamvandi wela kuntelimina kimbangi va meso ma zimbasi zi Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Vayi woso mutu wela kuthunuka va meso ma batu, mamvama ndielakuntunuka va meso ma zimbasi zi Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Woso mutu wela yolukila mambimbi mu diambu di Muana mutu wela lemvukulu vayi woso mutu wela finga Mpeve yinlongo kalendi lemvukulu ko. ");
INSERT INTO yom_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mu thangu bela kulunata va ntuala zinzo zi lukutukunu, va ntualamazuzi ayi va ntuala bapfumu, lubika ba mayindu mu zaba buevi luelakukitabila ayi diambu mbi luela vutula ayi buevi lueta yolukila. ");
INSERT INTO yom_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bila Mpeve yinlongo wela kuluvana mambu momo luela tuba mu thangu yina kaka. ");
INSERT INTO yom_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mutu wumosi wuba muna nkangu, wukamba Yesu : —A nlongi, khambila khombꞌama tukabana yandi kiuka. ");
INSERT INTO yom_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Vayi Yesu wumvutudila : —A Nkundi ama, nani wumbiekidi zuzi dieno voti nkabudi wu kiuka kieno e ? ");
INSERT INTO yom_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bosi wuba kamba : —Lulubuka luedi ba tsuina yi phila yina bila luzingu lu mutu luisi ko mu tezo ki bima biandi. ");
INSERT INTO yom_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Buna wuba kamba nongo yayi : —Zitsola zi mutu wumosi wu busina zibutu ngolo. ");
INSERT INTO yom_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Buna mutu beni wuyindula mu ntimꞌandi ti : “Mbi mfueti vanga ? Bila ndisi ko bibuangu biobi mfueti lundila mbongo ama ! ");
INSERT INTO yom_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Buna wukamba, tala diambu diodi ndieka vanga : Ndieka tiolumuna bilundulu biama ayi ndieka tunga bilutidi tola. Muawu ndiela lundila mbongoꞌama yoso ayi bima biama. ");
INSERT INTO yom_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Buna ndiela kamba muelꞌama : A muelꞌama : bima biwombo bieka yaku mutezo ki mimvu miwombo. Vunda kuaku, dia, nua ayi mona khini.” ");
INSERT INTO yom_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Vayi Nzambi wunkamba : “vungisi ! Builu buabu kuandi maba lomba muelꞌaku ! Buna bima bioso biobi wukubikidi biela ba bi nani e ?” ");
INSERT INTO yom_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Buawu bobo buididi mutu wunyidikanga busina mu diambu di niandiveka ; vayi kasi sina ko mu mambu ma Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu wukamba minlonguki miandi : —Diawu ndikulukambila ; lubika bela luzingu mayindu mu diambu di biobi luela dia ; lubika bela nitu mayindu mu diambu di biobi luela vuata. ");
INSERT INTO yom_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Luzingu luviatukidi bidia ayi nitu yi vuatukidi minledi. ");
INSERT INTO yom_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lutala zinuni ziozi beti tedilanga “minganga”, zikunanga ko ayi zitotanga bidia ko ; zisi ko kadi nzo voti lundulu vayi Nzambi wukuzidikila. Keti beno luvalu luidi viokila zinuni. ");
INSERT INTO yom_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nani mu beno, mu diambu di mayindu mandi, lenda buela yika luzingu luandi ntela e ? ");
INSERT INTO yom_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Enati luisi ko kadi lulendo mu mambu mama mafioti, buna bila mbi luididi mayindu mu diambu di momo mankaka e ? ");
INSERT INTO yom_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lutala biteka ; buevi bieti kudilanga, bisalanga ko, bitungangako vayi ndikulukamba, banza Salomo munkembo andi woso kasia vuata banga kiteka kimosi ko mu biteka biobi. ");
INSERT INTO yom_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Enati Nzambi wuvuatisa kunusu kidi buabu ku tsola vayi mbazi ki lozolo ku mbazu. Buna buevi kela luta kuluvuatisila beno batu ba minu kifioti e ? ");
INSERT INTO yom_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Lubika banga mayindu mu diambu di tomba biobi luela dia ayi luela nua e ? Lubika kukiyamisa mu mambu momo. ");
INSERT INTO yom_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bila Bapakanu ba ntoto bawu bantombanga mambu moso momo. Vayi Dise dieno zebi ti mfunu luvuidi bima biobi. ");
INSERT INTO yom_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vayi lutomba kipfumu kiandi buna bima bioso biobi bela kulubuedila biawu. ");
INSERT INTO yom_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Bika mona tsisi, ngeyo nkangu wu mameme ! Bila Dise dieno dimuenikhini mu kuluvana kipfumu. ");
INSERT INTO yom_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","—Sumbisanu bima biobi bidi yenu ayi lukabudila minsukami. Bika lukikubikila ziphotomoni ziozi kazi fuanganga ko ayi lukikubikila kiuka, mu diyilu, kioki kakilendi suka ko, bila kuna muivi kalendi kukiyiba ko ayi zitselele zilendi bunga ko. ");
INSERT INTO yom_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bila koso kiudi kiuka kiaku kuna kuidi ntimꞌaku. ");
INSERT INTO yom_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Luba bakubama mu kisalu ayi bika minda mienu milema. ");
INSERT INTO yom_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Banu banga bisadi bimvingila pfumu awu mu yoso thangu bu kayendaku nyengo wu makuela, mu diambu bu kela vutuka ayi kela kokuta, bisadi biandi biela kunzibudila. ");
INSERT INTO yom_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Khini kuidi bisadi biobi Pfumu awu bu kela vutuka, wela kuiza bata badi bakubama. Bukiedika ndikulukamba, niandi wela vuata minledi mi kisaluayi wela vuandisa bisadi biandi va meza wela fikama ayi wela kuba tudila bidia. ");
INSERT INTO yom_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kiza va midi mi phipa voti va nkielo wu buisi, wukuiza babati buna badi bakubama, buna khini kuidi bisadi bina. ");
INSERT INTO yom_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Vayi luzaba kueno ti enati pfumu yi nzo zebi thangu mbi muivikankuizila, nganu wuleka nkielo ayi kasia tala ko bayiba nzo andi. ");
INSERT INTO yom_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Beno mamveno, banganu bakubama bila mu thangu yoyi lunkambubela mayindu yawu yinkuizila muana mutu. ");
INSERT INTO yom_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piela wunyuvula : —A Pfumu, tubidi nongo yoyo mu diambu di beto kaka voti mu diambu di batu boso e ? ");
INSERT INTO yom_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pfumu wuvutula : —Buna nani kisadi kikuikama ayi ki diela kioki Pfumu kavana minsua mu yadila bisadi binkaka bi nzo andi mu kuba vananga kuku kiawuki ble mu thangu yifuana e ? ");
INSERT INTO yom_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Khini kuidi kisadi kioki, pfumu andi bu kela vutuka, wela buanu wunsala, boso bu kantumina. ");
INSERT INTO yom_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Bukiedika ndikulukamba pfumu andi wela kumvana minsua mu yadilabima biandi bioso. ");
INSERT INTO yom_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Vayi enati kisadi beni yindudi mu ntimꞌandi ti : “Pfumu amakakadi vika vutuka” ayi tonini yamisa bisadi bi babakala ayi bi bakieto, tonini dia, nua ayi kolu, ");
INSERT INTO yom_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","pfumu yi kisadi kina wela kuiza, mu lumbu kioki kela kambu bela mayindu ayi mu thangu yoyi kakambulu zaba. Buna pfumu andi wela kunloza ayi wela kumvana thumbudulu yi ngolo va kimosi ayi bakambulu bakuikama. ");
INSERT INTO yom_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kisadi kioki kizaba luzolo lu Pfumu andi vayi kasia kubama ko ayi kasia vanga ko boso buididi luzolo lu pfumu andi, wela zububikoti biwombo. ");
INSERT INTO yom_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Vayi kisadi kioki kikambu zaba luzolo lu Pfumu andi ayi vengi mambu makalenda zubulu bikoti, wela zubu bikoti bifioti. Bila bela tomba biwombo kuidi mutu wowo bavana biwombo, ayi kuidimutu wowo bayekudila biwombo bela tombulu biwombo. ");
INSERT INTO yom_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Mbazu ndiyizidi loza va ntoto ayi diambu mbi nzodidi enatimbazu beni yikikuikulu ? ");
INSERT INTO yom_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Vayi vadi mbotokolo yimfueti botama ayi ndikidi ku tsi mayindu nate yela vangama. ");
INSERT INTO yom_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","—Beno lumbanzila ti minu ndembama ndineti vava ntoto e ? Nana vayi khabunu. ");
INSERT INTO yom_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bila tona buabi, enati batu batanu badi mu nzo, bela ba bavasana : batatu bela ba ku ndambu yimosi bosi babuadi bela ba ku ndambu yinkaka. ");
INSERT INTO yom_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dise diela fuemina muana wubakala ayi muana wubakala welafuemina Dise. Ngudi wela fuemina muana wunketo ayi muana wunketo wela fuemina ngudi. Nzitu wunketo wela fuemina nketo wu muanꞌandi ayinketo wu muana wela fuemina nzitu andi wunketo. ");
INSERT INTO yom_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Bosi Yesu wubuela kamba nkangu wu batu : —Bu lueti monanga dituti ku ndambu wesite, buna lueti tuba : “mvula ma yinoka”, buna bobo bueta bela. ");
INSERT INTO yom_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bu lueti monanga phemo wu sude weka vevumuka, buna luetituba : “muini mawu ba wu ngolo” ; buna bobo bueta bela. ");
INSERT INTO yom_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bankua mayuya ! Luzebi bakula bidimbu bi ntoto ayi bi diyilubuna buevi lunkambu bakudilanga thangu yayi e ? ");
INSERT INTO yom_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—Bila mbi lunkambu sudikilanga, mu beno veka, mambu masonga e ? ");
INSERT INTO yom_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Diawu bu lulembu yendi ku tilibinadu ayi mutu wowo wufundidibuna nuana mu dedikisa mambu beni bu lukidi mu nzila. Bila nganu wela ku funda kuidi zuzi ayi niandi wela kuyekula mu mioko mi masodi ayi mawu mela kukotisa mu nloko. ");
INSERT INTO yom_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Muaki bukiedika ndikukamba wulendi totuka muna ko nate wela futazimbongo zioso zi tsuka. ");
INSERT INTO yom_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mu thangu yina ndambu yi batu bankaka baba vana, bankamba mambu momo mavioka momo matedi basi Ngalili bobo Pilatu kavondusu bu kasobikisamenga mawu ayi makaba mawu. ");
INSERT INTO yom_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu wuba vutudila : —Benu lumbanza ti basi Ngalili bobo bamueni ziphasi ziphila yoyo mu diambu babedi bankua masumu viokila basi Ngalili bankaka e ? ");
INSERT INTO yom_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Buawu ko ndikulu kamba, vayi enati beno lukadi balula khadulubuna beno mamveno phila yimosi luela fuila. ");
INSERT INTO yom_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Voti kumi dinana di batu bobo babuilu banga ki Silowe, bu kibavonda, beno lumbanza ti bawu baluta ba batu bambimbi viokilabatu bobo bamvuandanga ku Yelusalemi ? ");
INSERT INTO yom_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nana ndikilukamba, vayi enati lukadi balula khadulu buna beno mamveno phila yimosi luela fuila. ");
INSERT INTO yom_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Buna, wuba kamba nongo yayi : —Mutu wumosi wuba ayi nti andi wu figi wukunu mu ndimꞌandiyi vinu. Wuyiza tomba muawu makundi vayi kasia baka ko. ");
INSERT INTO yom_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Buna wukamba kisadi kiba nsalanga mu ndima beni : “Tala, wawu mvu wuntatu ndimeni tombila makundi ma figi mu nti wawu vayi kadidikundi ndibakanga ko. Kuanga kuandi wawu, bila mbi wulembu bungila kuandi buangu ki ntoto mu phamba e ?” ");
INSERT INTO yom_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Vayi kisadi beni kimvutudila : “A pfumu, bika wutadidila diaka wawu mvu wawu nate ndiela mana balula ntoto muyenda nti ayi ndiela mutula mbozi. ");
INSERT INTO yom_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mananga wela buta makundi mu mvu wunkuiza. Enati buawu ko buna wela kuanga wawu.” ");
INSERT INTO yom_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu bu kaba longa, mu lumbu ki saba, mu nzo yimosi yi lukutukunu, ");
INSERT INTO yom_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","tala, nketo wumosi wuba muna wuba ayi yimbimbi yi kimbevo mu tezo ki kumi dinana di mimvu. Nketo beni wuba wukomvama ; kadi baka bu luliminina. ");
INSERT INTO yom_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu bu kammona, buna wuntela ayi wunkamba : —A nketo, kululu mu kimvevo kiaku ! ");
INSERT INTO yom_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Buna wuntetika mioko ayi vana vawu wululama ayi wukembisa Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Vayi pfumu yi nzo yi lukutukunu wufuema mu diambu di Yesukabelusa nketo beni mu lumbu ki saba ; buna wubaluka kuidi nkangu ayi wutuba : —Bilumbu bi kisalu bidi bisambanu ; luizanga mu belusu mu bilumbu bina vayi bika mu lumbu ki saba. ");
INSERT INTO yom_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Vayi Pfumu wumvutudila : —Luidi bankua mayuya ! Kadika mutu mu beno kaniangunanga ko ngombi andi voti mpundꞌandi, mu dikulu mu lumbu ki saba ayi kuzinatangamu kuzi nuikina e ? ");
INSERT INTO yom_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ayi nketo wawu widi muana wu nketo wu Abalahami. Tala kumi dinana di mimvu dimeni vioka tona Satana kankangila, buna disi fuana ko mu ku nnianguna mu lumbu ki saba e ? ");
INSERT INTO yom_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bu kaba tuba mambu momo buna bambeni bandi zioso zifua tsonivayi nkangu woso wumona khini mu diambu di mambu momo ma nkembo momo mavangimina mu niandi. ");
INSERT INTO yom_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Buna Yesu wukamba : —Mu mbi mu dedikini kipfumu ki Nzambi ayi mu mbi ndenda ku kidedikisila e ? ");
INSERT INTO yom_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kidedikini banga dikundi di mutalide di loza mutu mu tsolꞌandi. Dikundi beni diyunduka, dikituka nti. Zinuni ziyiza tungila madianza mawu mu bitafi biandi. ");
INSERT INTO yom_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Buna wubuela diaka : —Mu mbi ndenda dedikisila Kipfumu ki Nzambi e ? ");
INSERT INTO yom_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kidedikini banga luvi lubonga nketo, wusobikisa luawu mu bitezo bitatu bi falina nate yimana funa. ");
INSERT INTO yom_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu wuviokila mu mavula ayi mu mala ; wulonga muawu bu kalandakana nzilꞌandi mu kuenda ku Yelusalemi. ");
INSERT INTO yom_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Buna mutu wumosiwunyuvula : —A pfumu, bati buna batu bafioti kuandi bela vuka e ? ");
INSERT INTO yom_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Buna wuba vutudila : —Bika lunuana mu kotila mu luelo wufioti bila ndikulukambabawombo bela tomba mu kota vayi bela nunga ko. ");
INSERT INTO yom_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","—Pfumu yi nzo bu kela telama ayi bu kela zibika muelo, enati ku nganda luela batakana, luela kokuta ayi luela leba : “A Pfumu, wutuzibudila”. Buna niandi wela ku luvutudila : “Ndisi zaba ko kuevi lubedi e ?” ");
INSERT INTO yom_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","—Buna luela tuba : “Keti beto tudia ayi tunua yaku va kimosi. Keti ngeyo wulonga mu zinzila zietu…” ");
INSERT INTO yom_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Buna wela vutula : “Bukiedika ndikulukamba ndisi zaba ko kuevi lubedi. Luthatukila beno boso bisadi bi mambimbi.” ");
INSERT INTO yom_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kuna kuela ba bidilu ayi nkuetosolo wu meno mu thangu luela mona Abalahami, Isaki ayi Yakobi ayi mimbikudi mioso mu Kipfumu ki Nzambi, vayi, benu luela lozo ku nganda. ");
INSERT INTO yom_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Batu bela ba ku Esite ayi ku Wesite, ku Node ayi ku Sude bela vuanda mu Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Buna tala vadi batsuka bela ba batheti ayi batheti bela ba batsuka. ");
INSERT INTO yom_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mu lumbu kina, Bafalisi bayiza ayi bankamba : —Katuka vava ayi yenda kuaku bila Elode tidi kuvonda. ");
INSERT INTO yom_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Vayi Yesu wuba vutudila : —Yendanu lukamba mbaku wuna ti : “Tala ndilembo totula ziphevi zimbimbi ayi buabu ndilembu belusa bambevo. Vayi mbazi ayi lumbu kintatu mbanisini kuama. ");
INSERT INTO yom_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Vayi mfueti diata buabu mbazi ayi lumbu kina bila buisi fuana kombikudi kafuila ku nganda yi Yelusalemi.” ");
INSERT INTO yom_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—A Yelusalemi ! A Yelusalemi, divula dimvondanga mimbikudi ayi minlozilanga matadi bobo bakufidisilanga. Zikhumbu zikua ndizola kutikisilabana baku banga tsusu bu kankutikisilanga bana bandi ku tsi mavavi mandi vayi lumanga kuenu ! ");
INSERT INTO yom_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vayi tala beka kuluyekudila nzo eno. Ndikulukamba ti lulendi buela kumbona ko nate luela tuba : Bika kasakumunu mutu wowo wunkuizila mu dizina di Pfumu. ");
INSERT INTO yom_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lumbu kimosi ki saba, Yesu bu kakota mu dia ku nzo yi pfumuyimosi yi Bafalisi, buna bobo baba muna baba kuntala bumboti. ");
INSERT INTO yom_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tala mutu wumosi wuba kimbevo kimvimbu wuba va ntualꞌandi. ");
INSERT INTO yom_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Buna Yesu wuyuvula minlongi mi Mina ayi Bafalisi ti : —Minsua midi mu belusa mutu mu lumbu ki saba e ? ");
INSERT INTO yom_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Baba kuawu dio sui. Buna Yesu wusimba mutu beni, wumbelusa ayi wumvutula. ");
INSERT INTO yom_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bosi wukamba batu baba vana : —Nani mu beno wuidi muanꞌandi voti ngombiꞌandi vayi zimbukila yidodukidi mu dibulu, wunkambu vika ku yitapula mu lumbu ki saba e ? ");
INSERT INTO yom_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Basia vutula kadi diambu ko mu mambu momo. ");
INSERT INTO yom_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Muaki wukamba nongo yimosi mu diambu di bobo batumusubu kamona buevi baba sobudilanga bibuangu binzitusu ; ayi wuba kamba : ");
INSERT INTO yom_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Mu thangu bela kutumisa ku nyengo wu makuela buna bika kuenda vuanda va meza va buangu ki nzitusu, ayi zimbukila mutu wumosiwulutidi minsua wutumusu kuidi mutu wowo wutumisa ");
INSERT INTO yom_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","bila buna mutu wowo wulutumisa ngeyo ayi niandi wela kuiza ayi kukamba : “vana buangu kiaku kuidi mutu wawu”. Buna wela monazitsoni kuenda vuanda ku buangu kitsuka. ");
INSERT INTO yom_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Vayi bu bela kutumisa yenda ayi vuanda ku buangu kitsuka mu diambu mutu wowo wulutumisini bu kela kuiza wela ku kamba : “A nkundi ama, yiza vuandi vava”. Buna wela zitisu va ntuala batu bosobela ba yaku va meza. ");
INSERT INTO yom_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bila woso wukukinangikanga wela kululu ayi woso wukukikululanga wela nanguku. ");
INSERT INTO yom_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Buna wukamba mutu wowo wuntumisa : —Ngeyo tumisa batu mu dia va muini voti va masika kadi tumisa bakundi baku, bakhomba ziaku, bambuta ziaku voti bamvuama bafikimini yakutala mamvawu babika kutumisa muingi bavutudila mambu momo wuba vangila. ");
INSERT INTO yom_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Vayi mu thangu wumvangisa nyengo, bufueni wutumisa minsukami, babela binama, bantiudikanga, baphofo. ");
INSERT INTO yom_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ngeyo wela ba mu khini bila batu bobo basi ko kadi kiasa mu diambu bavutudila mambu momo wuba vangila. Buna Nzambi wela kumfuta mu lumbu kioki basonga bela fuluka. ");
INSERT INTO yom_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Buna mutu wumosi mu bobo baba va meza, bu kawa mambu momowukamba Yesu ti : —Khini kuidi mutu wowo wela dia mu Kipfumu ki Nzambi ! ");
INSERT INTO yom_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu wumvutudila : —Mutu wumosi wuvangisa nyengo wunneni, wutumisa batu bawombo. ");
INSERT INTO yom_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Thangu yi dia bu yifuana, wufidisa kisadi kiandi mu diambu kakamba batu batumusu ti “yizanu bila mamo makubinini.” ");
INSERT INTO yom_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Vayi babo balomba nlemvo. Wutheti wunkamba : “Tsola ndisumbidi ayi mfueti kaka kuenda kuyitala, diawu ndemvukila.” ");
INSERT INTO yom_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wunkaka wukamba : “Dikundi di zingombi ndisumbidi, ziawu ndieka kuenda makisa, diawu wundemvukila.” ");
INSERT INTO yom_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wunkaka wukamba : “Bosi kuandi ndikuedidi, diawu ndilendi baka bu kuizila ko.” ");
INSERT INTO yom_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kisadi beni bu kivutuka, kiyiza kamba Pfumu andi mambu moso mama. Buna pfumu yi nzo beni wufuema ayi wukamba kisadi kiandi : “Yenda nsualu mu zinzila ayi mu bina bi zinzila zi divula ayi tuala vava : minsukami, babela binama, baphofo ayi bantiudikanga…” ");
INSERT INTO yom_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Buna kisadi beni kiyiza kunkamba : “A pfumu matuminingi mavangimini vayi bibuangu bikidi.” ");
INSERT INTO yom_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Buna pfumu andi wumvutudila : “Yenda mu zinzila, mu yenda ziphangu kuika batu biza koti mu diambu di nzoꞌama yifuluka. ");
INSERT INTO yom_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bila bukiedika ndikulukamba kadi mutu wumosi mu bobo batumusu kalendi dia ko.” ");
INSERT INTO yom_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nkangu wu batu wuba wuwombo wuba kuenda nlandakananga. Buna Yesu wubaluka kuidi nkangu ayi wuba kamba : ");
INSERT INTO yom_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Enati mutu wizidi kuidi minu ayi enati kakadi lenda siandi, nguandi, nketuꞌandi, bana bandi, bakhomba bandi zi babakala ayi bakhomba bandi zi baketo, nkutu ayi luzingu luandi veka buna kkalendi banlonguki ama ko. ");
INSERT INTO yom_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Woso wunkambu nata dikulusi diandi ayi wunkambu kundandakana, kalendi ba nlonguki ama ko. ");
INSERT INTO yom_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bila nani buna luidi bu katidi tungisa nzo yi banga wunkambu tuama vuandanga mu yindula thalu yela fua mu nzo beni mu diambu di zaba kani lenda manisa kisalu beni. ");
INSERT INTO yom_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bila enati kakadi nunga mu manisa thungulu andi bu kamanisini tula zifundasio buna batu boso bobo bela kummona, bela kunsekinina ");
INSERT INTO yom_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bu bela tuba : “mutu wawu wutona tungisa nzo vayi kasia nunga ko manisa yawu”. ");
INSERT INTO yom_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Voti ntinu mbi wowo tidi nuanisa ntinu wunkanka mvita wunkambu tuama vuandanga mu yindula kani mu dikumi mili di masodi buna lenda nungamu nuanisa mutu wowo wunkuiza kuidi niandi ayi makumuadi ma mili e ? ");
INSERT INTO yom_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Enati buawu ko buna bu kakidi thama buna makafidisa mvualakuidi ntinu wunkaka ayi kunyuvula mambu mafueni mu kotisa ndembama. ");
INSERT INTO yom_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Diawu woso kuandi buna luidi wunkambu yekula bima bioso bidi yandi buna kalendi ba nlonguki ama ko. ");
INSERT INTO yom_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Tsalu kidi kima kimboti vayi enati yizimbisidi lueki luandi bunabuevi balenda vutudila lueki beni e ? ");
INSERT INTO yom_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yisiedi kadi mfunu ko kani mu ntoto voti mu mbozi, yifueti kaka lozu ku nganda. Woso widi matu mawila buna bika kawa. ");
INSERT INTO yom_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mimfutisi mi ziphaku ayi bankua masumu bayiza kutakana vaba Yesu, muingi banwa. ");
INSERT INTO yom_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bafalisi ayi minlongi mi mina baniunguta ayi batuba : —Mutu wawu wunyakula bankua masumu ayi wundia yawu va kimosi ! ");
INSERT INTO yom_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Buna Yesu wuba kamba nongo yayi : ");
INSERT INTO yom_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Nani mutu mu beno buna luidi vuidi khama yimosi yi mameme vayi zimbukila zimbisidi dimeme dimosi, wunkambu sia yekula luvua ayi vua lu mameme mankaka muingi kenda tombi diodi dizimbala, nate kela dimona e ? ");
INSERT INTO yom_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bu kadi bakudi, buna mu khini kela kuditudila va mavangiti mandi. ");
INSERT INTO yom_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Niandi tula ku nzoꞌandi, buna wela tumisa bakundi bandi ayi bobo bafikimini yandi ayi wuba bakamba : “bila lumona yama khini va kimosi bila ndimueni dimeme diama dizimbala.” ");
INSERT INTO yom_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ndikulukamba ti khini yela ba mu Diyilu mu diambu di nkua masumuwumosi bu kabaludi mavanga mandi yela viokakana ayi yoyi yidi mu tala luvua ayi vua lu basonga bakambulu kuawu mfunu wu balula mavanga mawu. ");
INSERT INTO yom_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—Voti nketo mbi wowo vuidi dikumi di zimbongo zi bisengo vayi zimbisidi sengo kimosi, wunkambu lemisanga muinda ayi wunkambu kombulanga nzo ayi wunkambu tombanga bumboti sengo kiandi nate kammonakiawu e ? ");
INSERT INTO yom_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bu kamueni kiawu, buna wela kutikisa bakundi bandi ayi bobo bafikimini yandi ayi wela bakamba : “bika lumona yama khini va kimosibila ndimueni sengo kiama ki zimbongo kioki kizimbala.” ");
INSERT INTO yom_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bobuawu ndikulukamba ti khini yiwombo yidi kuidi zimbasi zi Nzambi nkua masumu wumosi bu kabaludi mavanga mandi. ");
INSERT INTO yom_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Buna wubuela tuba diaka : —Vaba mutu wumosi wuba ayi bana buadi bababakala. ");
INSERT INTO yom_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nleki wunkamba dise diandi : “a tata, bika wuphana ndambu ki kiuka kiama !” Buna dise diba kabudila kiuka kiandi. ");
INSERT INTO yom_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ndambu yi bilumbu bu bivioka, nleki wutota bima biandi ayi wuyenda mu tsi yi thama. Kuna kamana fukisila bima biandi bioso mu luzingu lu divunzi. ");
INSERT INTO yom_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bu kamana fukisa bibio, buna kanda kingolo ki nzala ki yiza bua mu tsi beni ayi wutona mona nzala. ");
INSERT INTO yom_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Buna wuyenda sonama mu kisalu kuidi pfumu yimosi yi tsiyina. Buna pfumu beni wumfidisa ku zitsola ziandi mu diambu kenda sunganga zingulu. ");
INSERT INTO yom_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Buna wuzola kuandi wesa dikutu diandi mu dianga bidia bi zingulu vayi kadi mutu kasia kumvana biawu ko. ");
INSERT INTO yom_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Buna wutona yindula mu tsi andi ntima : “bisadi bioso bi dise diama bindianga boso buididi luzolo luawu vayi minu kuaku ndilembu fua nzala ! ");
INSERT INTO yom_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ndieka telama, ndieka kuenda kuidi dise diama ayi ndielakunkamba : Tatꞌama, ndivodidi masumu kuidi Nzambi ayi kuidi ngeyo. ");
INSERT INTO yom_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ndisi fuana diaka ko bathedila muanꞌaku vayi bika wuthangila banga kisadi kiaku.” ");
INSERT INTO yom_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Buna wutelama ayi wuyenda kuidi siandi. Buna wukidi thamasiandi wummona ayi kiadi kingolo kimbuila. Buna wuyenda dengana nsualumuanꞌandi, wumbumbakana ayi wumfifa bibesi. ");
INSERT INTO yom_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Buna muana wunkamba : “Tata ndivodidi masumu kuidi diyilu ayi kuidi ngeyo, ndisi fuanadiaka ko bathedila muanꞌaku.” ");
INSERT INTO yom_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Vayi dise dikamba bisadi biandi : “Lusia nsualu, lutuala kikhutu kilutidi kitoko ayi lumvuatisakiawu ; lumvuatisa pheti mu nlembo ayi lumvuatisa zisapatu. ");
INSERT INTO yom_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bika lutuala muana wungombi wu mafuta ayi luvonda wawu. Tudianu ayi tuvangisa nyengo ; ");
INSERT INTO yom_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","bila muanꞌama wawu wubedi wufua vayi wufulukidi ; wubedi wuzimbala ayiwumonikini.” Buna batona nyengo mu khini. ");
INSERT INTO yom_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mu thangu yina, muanꞌandi wu nkulutu wuba sala ku tsola. Bu kaba vutuka ayi bu kafikama ayi nzo wuwa miziki ayi makinu. ");
INSERT INTO yom_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Buna wutumisa kisadi kimosi ayi wunyuvula keni mambu mbi malembu vioki kuna. ");
INSERT INTO yom_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kisadi beni kimvutudila : “Keti khimbꞌaku niandi vutukidi. Dise diaku divondisidi muana ngombi wu mafuta bila wummueni wumvimba ayi wukambu kimbevo.” ");
INSERT INTO yom_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Buna nkulutu wufuema ayi wumanga kota. Siandi wutotuka ayi wunleba. ");
INSERT INTO yom_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Vayi niandi wumvutudila : “Tala, mimvu miwombo ndimeni kusadila vayi kadi khumbu yimosi ndisia tinguna ko zithumunu ziaku, ayi kadi khumbu yimosi wusia kuphana ko muana khombo muingi ndimona khini va kimosi ayi bakundi bama. ");
INSERT INTO yom_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Vayi muanꞌaku, mutu wowo wumana sikisa kiuka kiaku va kimosi ayi bandumba zi leta bu kizidi, buna vondisidi muana ngombi wu mafuta mu diambu diandi.” ");
INSERT INTO yom_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Siandi wumvutudila : “A muanꞌama, ngeyo zithangu zioso widi yama va kimosi mu ayi bima biosobiobi phuidi ngeyo vuidi biawu. ");
INSERT INTO yom_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Vayi mboti mu vangisa nyengo ayi mona khini bila khombꞌaku yayiwubedi wufua ayi wufulukidi, wubedi wuzimbala ayi monikini.” ");
INSERT INTO yom_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu wukamba minlonguki miandi : —Mutu wumosi wuba busina buwombo, wuba ayi dikalaka diandi, vayi batu bayiza funda dikalaka diandi ti niandi wufukisidi busina buandi. ");
INSERT INTO yom_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Buna pfumu andi bu kantumisa buna wunyuvula : “mambu mbi momondilembu wanga mu diambu diaku e ? Vumbula kipholo mu zaba bueviwukebidi kisalu kiaku bila wulendi buela ba nkebi wu bima biama ko.” ");
INSERT INTO yom_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Buna nkebi wu bima wuyindula mu ntimꞌandi : “diambu mbi ndiekavanga e ? Bila buabu pfumu ama weka kumbotula, ndilendi buela kebangabima biandi ko. Ndilendi salanga ntoto ko bila ndisi ko ngolo ; tsoni mu kuenda lombanga. ");
INSERT INTO yom_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Buabu mbakudi diambu mbi ndieka vanga muingi batu baba kundiakulanga mu zinzo ziawu bu bela kumbotula mu kisalu.” ");
INSERT INTO yom_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Vana vawu wutumisa batu boso baba zipholo kuidi pfumu andi. Wuyuvula wutheti : “Kikua fueti futa pfumu ama e ?” ");
INSERT INTO yom_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mutu beni wumvutudila ti : “Makumuandi ma mangungulu ma mafuta.” Nkebi beni wunkamba : “tamla nkanda wowo wusonika, wawu vuanda vovo, tula nsuala ayi sonikati dikumi di mangungulu.” ");
INSERT INTO yom_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bosi wukamba wunkaka : “Ngeyo kikua fueti futa e ?” Niandi wumfutudila ti : “Zikhama zitanu zi zitsaku zi ble.” Buna nkebi beni wunkamba mutu beni ti : “bonga nkanda wowo wusonika ayi sonika zikhama ziya.” ");
INSERT INTO yom_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Buna pfumu beni wuniemisa nkebi wowo wukambu kiedika mu philadiela diandi di kasadila. Bila, mu mambu mawu veka, batu ba thanguyayi balutidi bana ba kiezila mu diela. ");
INSERT INTO yom_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ayi minu ndikulukamba ti mboti lusadila kimvuama ki ntoto muingi lubaka bakundi mu diambu dieno veka muingi mu thangu kiela manababa kuluyakula mu zinzo zi mvu ka mvu. ");
INSERT INTO yom_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Woso mutu widi wukuikama mu bima bifioti buna widi diaka wukuikama mu bima biwombo. Ayi woso kambulu wukuikama mu bima bifioti kalendi ba wukuikama ko mu bima binneni. ");
INSERT INTO yom_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Enati lusi ko bakuikama mu kimvuama kikambulu kisonga buna nani wela kuluyekudila kimvuama kikiedika e ? ");
INSERT INTO yom_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Enati luisi ko bakuikama mu bima bingana buna nani wela kuluvana bima bieno veka e ? ");
INSERT INTO yom_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Kuisi ko kisadi kilenda sadila bapfumu buadi. Bila bukiedika wela lenda pfumu yimosi ayi wela zola pfumu yinkaka. Voti wela kiyekulakuidi pfumu yitheti ayi wela lenza pfumu yinkaka. Lulendi sadila Nzambi ayi zimbongo va kimosi ko. ");
INSERT INTO yom_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Buna bamana wa mambu momo, Bafalisi babazolanga zimbongo basekinina Yesu. ");
INSERT INTO yom_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Vayi niandi wuba kamba : —Benu luidi batu beta zola kukimonikisa basonga va meso ma batu vayi Nzambi zebi mintima mieno. Bila mambu momo mammonika ma mfunuva meso ma batu madi mambu maphamba va meso ma Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Tsungi yi Mina ayi yi mimbikudi yiba nate mu thangu yi Yowani. Tona thangu yina Nsamu Wumbote wu Kipfumu ki Nzambi wulembu samunu ayi kadika mutu wulembo sadilanga zingolo ziandi mu kota muawu. ");
INSERT INTO yom_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Muaki kadi kuandi phasi diyilu ayi ntoto mu vioka vayi kadi sonu kimosi ki Mina kilendi botulu ko. ");
INSERT INTO yom_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Woso wumbotula nketo andi ayi kuedidi nketo wunkaka vengi kitsuza ayi woso wunkuela nketo wubotalo kuidi bakala diandi vengi kitsuza. ");
INSERT INTO yom_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Kuba mutu wumosi wu kimvuama, wuba vuatanga minledi mintalu ayi mimboti. Kadika lumbu, luzingu luandi luba lu minyengo. ");
INSERT INTO yom_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nsukami wumosi, dizina diandi Lazale wuba lekanga vana muelonzo yi nkua kimvuama. Nitu andi yoso yiba ziphuta-ziphuta. ");
INSERT INTO yom_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wuba mayindu ma yukutanga mu bitsiadisila biobi biba dodukanga mu thangu mutu wu busina kaba dianga va meza. Vayi zimbua ziba kuiza vendanga ziphuta ziandi. ");
INSERT INTO yom_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Vayi nsukami wuyiza fua ayi zimbasi zinnata nate vana ndambu Abalahami. Mutu wu kimvuama, mamvandi, wufua ayi wuziku. ");
INSERT INTO yom_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kuna tsi yi bafua, wumona ziphasi ziwombo, wuvumbula meso ayi wumona kuna thama Lazale buna kadi va ndambu yi Abalahami. ");
INSERT INTO yom_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Buna wuyamikina : “A tata Abalahami, bika wumbona kiadi ! Tuma Lazale kabuika tsongi yi nlembo andi mu nlangu muingi kandakisila dibeti mu ludimi luama bila phasi ndilembu moni mu diambu di minlaki mi mbazu.” ");
INSERT INTO yom_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Vayi Abalahami wumvutudila : “A muanꞌama, bika wutebuka moyo ti ngeyo wutambula bima biaku mu thangu yi luzingu luaku vayi Lazale wutambula mabienga. Vayi buabu niandi wulembo bombo kuaku vayi ngeyo wulembo yamusu. ");
INSERT INTO yom_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ayi botula mambu momo, diyenga dinneni didi va khatitsika beto ayi beno mu diambu di bobo badi kuaku batidi kuiza kuidi beno babika bakadiluaku dikuizila koko luidi ayi mu diambu di bobo badi koko luidi batidi kuiza kuaku babika baka diluaku dikuizila kuaku tuidi.” ");
INSERT INTO yom_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Buna mutu wu busina wubuela tuba diaka : —A tata, lemvuka ! Tuma Lazale ku nzo yi siama ");
INSERT INTO yom_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","bila zikhombo zitanu zidi yama mu diambu di kabalubula muingi mamvawu babika kuiza ku buangu kiaki ki kiphasi. ");
INSERT INTO yom_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Vayi Abalahami wumvutudila : “Moyize ayi mimbikudi badi yawu bika baba wilukila”. ");
INSERT INTO yom_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Buna nkua busina wubuela tuba : “Nana, buawu ko bobo Tata Abalahami. Bila enati mutu fulukidi mu tsi yi bafua ayi wedi kuidi bawu buna bela balula mavanga mawu.” ");
INSERT INTO yom_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Vayi Abalahami wubuela vutula ti : “Enati bakadi wila Moyize ayi mimbikudi buna balendi wila ko mutuwufua ka diambu ko wufuluka.” ");
INSERT INTO yom_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu wukamba minlonguki miandi : —Ziphukumunu zilendi kambu ko vayi mabienga kuidi woso wuntotukidilanga ziawu. ");
INSERT INTO yom_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bulutidi mboti bankanga ditadi diodi bannikinanga makundi mu tsingu, ku nloza mu mbu ayi mu diambu kabika vodisa, wumosi mu banababa, masumu. ");
INSERT INTO yom_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Diawu lulubuka ! —Enati khombꞌaku vodidi masumu, buna bika wuntubidila. Ayi enati baludimavanga buna bika wunlemvukila. ");
INSERT INTO yom_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ayi buba kuandi ti tsambudi di zikhumbu kavodidi masumu kuidi ngeyo mu lumbu kimosi, ayi tsambudi di zikhumbu kiza tubila ti : “mbaludi khadulu”. Buna bika wunlemvukila. ");
INSERT INTO yom_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mimvuala mikamba Pfumu Yesu : —Wutubuela minu. ");
INSERT INTO yom_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Buna Pfumu Yesu wuba vutudila : —Bukiedika ti minu kieno, ka diambu ko kidi banga buididi dikundi di mutalide, nganu lulenda tumina nti wuna ti : “Vuzuka ayi yenda kikuni mu mbu” buna muna yina thangu wufueti kulutumukina. ");
INSERT INTO yom_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—Nani buna luidi widi ayi kisadi kiandi kinkunanga voti kinsunganga bibulu, kikunkambanga bu kabedi ku zitsola ti : “yiza nsualu ayi vuanda nsualu va meza ?” ");
INSERT INTO yom_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Keti kafueti kunkamba theti ti : “ndambila bidia, vuata minledi mi kisalu ayi thudila bidia va meza nate ndimanisa dia ayi nua ; bosi ngeyo mamvaku wudia ayi wunua ?” ");
INSERT INTO yom_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","A Buevi pfumu kavueti vutudila kisadi kiandi matondo mu diambu kavengi bumboti momo katumunu e ? Nana ! ");
INSERT INTO yom_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Buawu bobo kuidi beno mamveno. Bu luela mana vanga momo lutumunu buna bika luba tuba : “tuidi kaka bisadi bikambulu mfunu, tuvengi kaka momo tutumunu.” ");
INSERT INTO yom_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Buna wulembo yendi ku Yelusalemi, Yesu wuviokila ku Samali ayi Ngalili. ");
INSERT INTO yom_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Buna weka va difula di buala bumosi, kuna dikumi di batu babelabuazi bandengana. Thama batelimina ");
INSERT INTO yom_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ayi bayamikina mu mbembo yingolo ayi batuba : —A Pfumu Yesu, bika wutumona kiadi ! ");
INSERT INTO yom_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu bu kaba mona, buna wuba kamba : —Yendanu lukimonikisa kuidi banganga Nzambi. Mu thangu baba kuenda mu nzila, bazimbukila batumbulu vedila. ");
INSERT INTO yom_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wumosi mu bawu bu kamona ti belukidi, wuvutuka, wukembisa Nzambi mu ndinga yingolo. ");
INSERT INTO yom_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wufukama va malu ma Yesu, wuyinika zizi kiandi va tsi ayi wumvutudila matondo. Vayi mutu beni wuba muisi Samali. ");
INSERT INTO yom_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Buna Yesu wunyuvula : —Keti dikumi divedusulungu e ? A kuevi kuidi divua dinkaka ? ");
INSERT INTO yom_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Buna kadi mutu kasi yindula ko mu vutuka ayi vutudila Nzambi matondo botula kaka nzenza yayi e ? ");
INSERT INTO yom_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Buna Yesu wunkamba : —Telama ayi yenda kuaku ; minu kiaku kibelusidi. ");
INSERT INTO yom_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bafalisi bayuvula Yesu mu diambu di zaba kani lumbu mbi kiela kuiza Kipfumu ki Nzambi. Niandi wuba vutudila : —Kipfumu ki Nzambi bu kiela kuiza kilendi monu mu meso ko. ");
INSERT INTO yom_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ayi balendi tuba ko : “Tala, kidi kuaku” voti “tala kidi kuna” bila luzaba mboti ti Kipfumu ki Nzambi kidi va khatitsikꞌeno. ");
INSERT INTO yom_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bosi wukamba minlonguki : —Bilumbu biela kuiza biobi luela bela tsatu yi mona, banza lumbu kimosi ki muana mutu vayi lulendi kimona ko. ");
INSERT INTO yom_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","—Buna bela kulukamba : “Tala Klisto widi kuaku” voti “tala widikuna”. Buna kadi ba kuenda ayi kadi ku balandakana. ");
INSERT INTO yom_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bila banga lusiemo lueta totukila mu diyilu ayi lueta kienzudila tona tsongi yimosi nate tsongi yinkaka yi diyilu, buna buawu bobo buela bela muana mutu mu lumbu kiandi. ");
INSERT INTO yom_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Vayi kafueti tuama mona ziphasi ziwombo ayi kafueti tuama lozu kuidi batu ba tsungi yayi. ");
INSERT INTO yom_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","—Mambu momo maba mu thangu yi Nowa mawu mela buela ba mu bilumbu bi Muana Mutu. ");
INSERT INTO yom_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bila batu badia, banua, bakuelana, bakuedisa nate mu lumbu kioki Nowa kakota mu masuwa. Buna bosi nkuka yi nlangu yiyiza, ayi yimana ku babunga. ");
INSERT INTO yom_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Banga kuandi bubela mu bilumbu bi Loti : batu badia, banua, basumba, basumbisa, bakuna batungisa. ");
INSERT INTO yom_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Vayi mvula yi mbazu ayi yi sufele yinoka ayi yimana ku babungamu lumbu kioki Loti katotuka mu Sodoma. ");
INSERT INTO yom_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Buawu bobo buela bela mu lumbu kioki Muana mutu kela monika. ");
INSERT INTO yom_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mu lumbu kina, enati mutu widi ku yilu muanzu vayi widi ayi bima biandi mu nzo buna kabika kuluka muingi kenda bongi biawu ; bobuawu woso wela batakana ku zitsola kabika buela vutuka ku nzo andi. ");
INSERT INTO yom_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bika lutebukila nketo wu Loti moyo. ");
INSERT INTO yom_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Woso wela tomba vukisa luzingu luandi, wela luzimbisa vayi wosowela luzimbisa wela luvukisa. ");
INSERT INTO yom_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Bukiedika ndikulukamba, muna builu buna, batu buadi bela lekamfulu yimosi, wumosi mu bawu wela botulu vayi wunkaka wela siala. ");
INSERT INTO yom_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Baketo buadi bela tuta mfufu va kimosi, wumosi mu bawu wela botulu vayi wunkaka wela siala.  ");
INSERT INTO yom_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Babakala buadi bela ba ku zitsola, wumosi mu bawu wela botuluvayi wunkaka wela siala. ");
INSERT INTO yom_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Buna minlonguki minyuvula : —A Pfumu, kuevi kuela viokila mambu momo e ? Niandi wuba vutudila : —Koso kuidi mvumbi, kuawu kuidi bibala. ");
INSERT INTO yom_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu wukamba minlonguki miandi nongo yayi mu diambu di kuba sudikisa ti bafueti sambilanga mu zithangu zioso mu kambu vonga. ");
INSERT INTO yom_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Kuba zuzi dimosi diba mu divula dimosi, zuzi beni kaba monanga Nzambi tsisi ko ayi kaba kinzikanga ko kadi mutu wumosi. ");
INSERT INTO yom_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mu divula beni muba diaka difuola dimosi. Difuola beni diba kuizanga kuidi niandi ayi diba kunkambanga : “Bika wundungisa va ntuala mbeni ama”. ");
INSERT INTO yom_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Thangu yiwombo zuzi beni kasia zola ko. Vayi niandi wukamba mu ntimꞌandi ti : “ka diambu ko ndimonanga Nzambi tsisi ayi ndikinzikanga batu ko, ");
INSERT INTO yom_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","vayi difuola diandi dilembu thatisa buna ndieka kunnungisa muingi kabika buela kuiza ku thatisanga.” ");
INSERT INTO yom_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Buna Pfumu wela tuba diaka : —Lunwa bumboti mambu matuba zuzi diodi di mbimbi. ");
INSERT INTO yom_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Buna lumbanza ti Nzambi kalendi nungisa ko batu bandi bobo kasobula ayi bobo baku nsambilanga builu ayi muini ? Beno lumbanzila ti niandi wela zingila mu kuba sadisa e ? ");
INSERT INTO yom_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Bukiedika ndikulukamba, mu nsualu kela kuba nungisa. Vayi muana mutubu kela kuiza, buna wela kuiza bata kuandi batu badi minu va ntoto e ? ");
INSERT INTO yom_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wubuela tuba diaka nongo yayi mu diambu di batu bobobakukimonanga ti badi batu basonga vayi banlenzanga bankaka. ");
INSERT INTO yom_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Babakala buadi bayenda ku nzo Nzambi mu diambu di sambila. Mfalisi wumosi ayi mfutisi wu ziphaku wumosi. ");
INSERT INTO yom_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mfalisi wutelama va lutengo ayi wusambila lusambulu lualu : “A Nzambi, ndikuvutudila matondo bu khambulu dedakana bangabatu bankaka, bobo banzionanga bima bingana, bobo bakambulu basonga, bobo bavanganga kitsuza voti bobo badi kuandi banga mfutisi wu ziphaku wowo. ");
INSERT INTO yom_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Minu mu kadika sabala bilumbu biodi ndieta kukifuisila nzala mu diambu di lusambulu ayi ndieta vana kuku ki kumi mu bima bioso biobi bidi yama.” ");
INSERT INTO yom_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mfutisi wu ziphaku thama kayenda telimina ayi kasia zolavumbula meso mandi ku diyilu ko. Vayi thulu andi yawu kaba bundanga bu katuba : “A Nzambi, bika wumbona kiadi bila ndidi nkua masumu !” ");
INSERT INTO yom_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Bukiedika ndikulukamba, mfutisi wu ziphaku wowo sumbu kavutuka ku nzo andi, wumonika wusonga va meso ma Nzambi vayi bika mutu wowo wunkaka bila woso wukukikululanga wela nanguku ayi woso wukukinangikanga wela kululu. ");
INSERT INTO yom_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bannatisa bana bafioti muingi kaba simba vayi minlonguki bu mimonabobo mitubidila batu bobo babanata. ");
INSERT INTO yom_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesu wuba tumisa ayi wuba kamba : —Bika bana bafioti biza kuidi minu ayi kadi kuba kandika bila kipfumu ki Nzambi kivuiwulu kuidi batu badi banga bobo. ");
INSERT INTO yom_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bukiedika ndikulukamba ti woso wunkambu tambula Kipfumu ki Nzambi banga muana wu fioti kalendi mu kota ko. ");
INSERT INTO yom_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Buna pfumu yimosi yinyuvula : —A nlongi wumboti, diambu mbi mvanga muingi ndibaka luzingu lukalumani e ? ");
INSERT INTO yom_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Buna Yesu wumvutudila : —Bila mbi wukuthedila wumboti ? Kuisi ko mutu wumboti botula kaka, Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Keti zebi zithumunu : Kadi vanga kitsuza, kadi vonda, kadi yiba, kadi telama kimbangi ki luvunu, kinzika siaku ayi ngudi aku. ");
INSERT INTO yom_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Buna niandi wuvutula : —Ndinkebanga mambu moso momo tona bumuana buama. ");
INSERT INTO yom_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu bu kawa bobo, buna wunkamba : —Diambu dimosi dinkamba kuidi ngeyo : Yenda sumbisa bima bioso biobi bidi yaku ayi kabudila minsukami bioso wumbaka buna wela bakakiuka ku diyilu. Buna bosi wiza ayi wundandakana. ");
INSERT INTO yom_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bu kawa bobo, kiadi kingolo kimbuila bila kimvuama kiwombo kiba yandi. ");
INSERT INTO yom_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu bu kamona ti mutu beni weka kiadi-kiadi buna wutuba : —Didi diambu di phasi kuidi batu badi kimvuama mu kota mu kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bila kadi kuandi phasi kuidi kamela mu viokila va divudu di tsoma vayi phasi kuidi nkua kimvuama mu kota mu kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Buna batu bobo bawa bobo, batuba : —Buna nani wulenda vuka e ? ");
INSERT INTO yom_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu wuba vutudila : —Mambu momo batu beti lembakana, Nzambi lenda ku mavanga. ");
INSERT INTO yom_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Buna Piela wunyuvula : —Tata, tumana yekula bibioso ayi tulandakana. ");
INSERT INTO yom_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu wuba vutudila : —Bukiedika ndikulukamba, kuisi ko mutu wusia bika mu diambu di Kipfumu ki Nzambi, nzo andi, bambuta bandi bakhomba bandi, nketo andi voti bana bandi, ");
INSERT INTO yom_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wela kambu tambula mu thangu yayi, biwombo viokila biobi kabika ayiwela kambu tambula, mu thangu yinkuiza, luzingu lukalumani. ");
INSERT INTO yom_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu wunata kumi ayi mimvuala miodi ayi wuba kamba : —Tala, tueka kuenda ku Yelusalemi ayi mambu moso masonika mimbikudi mu diambu di Muana Mutu meka sunduka. ");
INSERT INTO yom_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bila bela kunyekula mu mioko mi bapakanu, bela kunsekinina, bela kumfinga, bela kunlobudila madita ; ");
INSERT INTO yom_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ayi bela kunzuba bikoti, bela kumvonda. Bosi wela fuluka mu lumbu kintatu. ");
INSERT INTO yom_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Minlonguki misia sudika kadi diambu dimosi ko mu mambu moso mana bila tsundu yi mambu momo yiba yisuama kuidi bawu ; ayi misia bakula ko mambu mbi Yesu kaba yolukilanga. ");
INSERT INTO yom_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu bu kafikama ayi Yeliko, phofo yimosi yivuanda mu yenda nzila, wuba lombanga zimbongo. ");
INSERT INTO yom_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bu kawa biyoko bi nkangu wu batu wuba vioka, buna wuyuvula kani mbi biobi. ");
INSERT INTO yom_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Buna bamvutudila ti Yesu muisi Nazaleti wulembu vioki. ");
INSERT INTO yom_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Buna wuyamikina mu ndinga yingolo ti : —Yesu, Muana Davidi, wumboni kiadi ! ");
INSERT INTO yom_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Btu bobo baba ku ntuala nkangu bantemina muingi kabika biyoko vayiniandiwuluta buela yamikina : —A muana Davidi, wumboni kiadi ! ");
INSERT INTO yom_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu bu katelama, buna wuvana lutumu ti bannatina niandi. Bu kafikama, Yesu wunyuvula : ");
INSERT INTO yom_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—A diambu mbi tidi ndivangila e ? Wumvutudila : —A pfumu, ntidi buela mona. ");
INSERT INTO yom_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Buna Yesu wunkamba : —Mona kuaku bila minu kiaku kibelusidi. ");
INSERT INTO yom_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Vana vawu niandi wumona ayi wunlandakana. Wunkembisa Nzambi. Batu boso bu bamona bobo bakembisa Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Wukota mu divula di Yeliko ayi wudisabuka. ");
INSERT INTO yom_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tala mutu wumosi, dizina diandi Zakayi, wuba pfumu yi mimfutisi mi ziphaku ayi wuba nkua busina. ");
INSERT INTO yom_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wuzola mona Yesu mu diambu kazaba buevi kadidi vayi kadia nunga ko mu diambu di nkangu wu batu bila ntela wu khufi wuba yandi. ");
INSERT INTO yom_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Buna wuzawula kuna ntuala ayi wumota mu nti wu sikomole mu diambu kamona Yesu bila vana kafueti viokila. ");
INSERT INTO yom_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mu thangu Yesu katula vana buangu beni, wumbula meso, wummona ayi wunkamba : —Zakayi, kuluka nsualu bila buabu mu nzo aku mfueti vuanda. ");
INSERT INTO yom_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayi wukuluka mu nsualu ayi wutambula Yesu mu khini. ");
INSERT INTO yom_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bu bamona bobo, batu boso baniunguta ayi batuba : —Tala, wedi leki ku nzo nkua masumu wowo ! ");
INSERT INTO yom_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Vayi Zalayi wutelama wukamba Pfumu : —Tala, ndieka vana minsukami khatitsika yi bima biama ayi enati mutu ndivangila mbimbi mu kumvuna buna ndieka kumvutudila mu zikhumbu ziya. ");
INSERT INTO yom_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Buna Yesu wunkamba : —Pulusu yikotidi mu lumbu kiaki mu nzo yayi bila mutu wawu, mamvandi, widi muana wu Abalahami. ");
INSERT INTO yom_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bila muana mutu wuyiza mu tomba ayi mu vukisa bobo baba bazimbala. ");
INSERT INTO yom_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nkangu bu wuba wa mambu mama, Yesu wubuela bakamba nongo yimosibila buna Yelusalemi difikimini ayi batu babanzila ti kipfumu ki Nzambi kieka kuiza nsualu. ");
INSERT INTO yom_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Buna wuba kamba : —Mutu wumosi wu dikanda di luzitu wuyenda ku tsi yi thama muingi kenda bieku ntinu. Niandi mana bieku buna bosi kela vutuka ku tsi andi. ");
INSERT INTO yom_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Buna wutumisa dikumi di bisadi biandi ayi wuvana kuidi kadikamutu sengo kimosi ki nolo. Bosi wuba kamba : “Bika lubutisa zimbongo ziazi nate ndiela vutuka.” ");
INSERT INTO yom_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Vayi basi tsi andi banlenda. Diawu ku manima mandi bamfidisilamimvuala mu diambu mituba ti : “Tumengi ti mutu wawu katu yadila.” ");
INSERT INTO yom_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Bu kamana bieku ntinu, wuvutuka ku tsi andi ayi wutumisa bisadibiobi kasia bikila zimbongo. Wuzola zabathalu yibutisa kadika mutu mu zimbongo zikatambula. ");
INSERT INTO yom_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wutheti wuyiza ayi wutuba : “A Pfumu, sengo kiaku ki nolo kibutidi dikumi di bisengo bi nolo.” ");
INSERT INTO yom_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Buna Pfumu beni wunkamba : “Sedi bumbote ! Widi kisadi kimboti. Sumbu wubedi wukuikama mu mambu mafioti, diawu ndiveni minsua mu yadila dikumi di mavula.” ");
INSERT INTO yom_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mutu wummuadi wuyiza ayi wutuba : “A Pfumu, sengo kiaku ki nolo kibutidi bisengo bitanu binkaka bi nolo.” ");
INSERT INTO yom_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Buna Pfumu wukamba kuidi kisadi kimmuadi : “Ngeyo ndiveni minsua mu yadila mavula matanu.” ");
INSERT INTO yom_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wunkaka wuyiza ayi wutuba : “A Nlongi, tala sengo kiaku kinolo, ndiki sueka bumboti va dikolo di nledi. ");
INSERT INTO yom_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bila minu tsisi ndimueni bila widi mutu wumosi mu thewa ; ngeyo wunzionanga biobi wukambu sala, ngeyo wuntotanga bidia biobi wusia kuna ko.” ");
INSERT INTO yom_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Buna pfumu wunkamba : “Ndieka kusambisa mu mambu momo tubidi ngeyo veka widi kisadi kimbimbi ! Zebi kuaku ki ndidi mutu wu thewa. Ndinzionanga biobindikambu sala ayi ndintotanga bidia biobi ndisia kuna ko. ");
INSERT INTO yom_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Vayi bila mbi wukambu tudila zimbongo ziama ku banki muingi ndibakila ziawu ndandu mu thangu ndivutukidi e ?” ");
INSERT INTO yom_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Buna wukamba batu bobo baba vana ti : “Lunzionanu sengo kinolo ayi vananu kiawu mutu widi dikumi di bisengo bi nolo.” ");
INSERT INTO yom_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Vayi batu beni bankamba : “A Pfumu, keti dikumi didi yandi e !” ");
INSERT INTO yom_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Buna niandi wuba vutudila : “Bukiedika ndikulukamba ti kuidi mutu wowo beki bela kumvanaayi kuidi mutu wowo kambulu, bela kunziona banza biobi bidi yandi. ");
INSERT INTO yom_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bosi lundatina vava bambeni ziama ziozi zimanga ti ndibika ku bayadila ayi luba vondila va meso mama.” ");
INSERT INTO yom_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bu kamana tuba mambu momo, Yesu wuba tuaminina ku ntuala mu kuenda ku Yelusalemi. ");
INSERT INTO yom_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Buna beka nduka tula ku Betefange ayi ku Betani, ku ndambu mongo wu beta tedila “mongo minti mi Olive”, buna wutuma minlonguki miandi miodi ");
INSERT INTO yom_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","wuba kamba : —Yendanu ku buala bobo butalini yeno. Beno kota muawu, buna malu monamuana phunda wukangama. Kadi mutu wumosi kavuandidiabu wawu ko. Luniangunawawu ayi lutuala wawu. ");
INSERT INTO yom_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Enati mutu wuluyuvudi : “bila mbi lulembo niangunina wawu e ?” Buna lumvutudila ti : “Pfumu mfunu kavuidi wawu.” ");
INSERT INTO yom_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bobo batumbu bu bayenda, bamona mambu moso boso kabakambila. ");
INSERT INTO yom_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bu baba nianguna muana phunda, buna batu bobo bavua wawu baba yuvula : —A bila mi luniangunina muana phunda wowo e ? ");
INSERT INTO yom_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bawu bamvutula : —Pfumu mfunu kavuidi wawu. ");
INSERT INTO yom_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Buna bawu nata kuidi Yesu. Bu bamana yala minledi miawu va mbata phunda bakumisa vawu Yesu. ");
INSERT INTO yom_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bu kaba vioka, mu nzila batu bayala minledi miawu mu nzila. ");
INSERT INTO yom_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Buna beka nduka tula, bu baba nengumuka mongo wu minti mi olive, nkangu woso wu minlonguki wumona khini, wukembisa Nzambi, mu ndinga yingolo, mu diambu di bikumu biobi mimona. ");
INSERT INTO yom_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bawu batuba ti : —Bika kasakumunu ntinu wowo wunkuizila mu dizina di Pfumu. Bika ndembama yiba ku diyilu ayi nkembo mu bibuangu bizangama ! ");
INSERT INTO yom_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Buna Bafalisi bankaka baba muna nkangu bakamba Yesu ti : —A nlongi, temina minlonguki miaku. ");
INSERT INTO yom_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu wuba vutudila : —Bukiedika ndikulukamba, enati balembulu biyoko buna matadi mamayamikina. ");
INSERT INTO yom_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mu thangu kafikama ayi divula, wumona divula ayi wudila mu diambudi divula beni. ");
INSERT INTO yom_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Bosi wutuba : —Enati ngeyo mamvaku wedi zaba, kani ka lumbu kiaku kiaki mambu momo malenda kunatina ndembama ! Vayi buabu masuekulu va meso maku. ");
INSERT INTO yom_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bila bilumbu biela ku kuizila, biobi bambeni ziaku ziela kaba mimbuingi, ziela kuzungidila, ziela kufietikisa mu zindambu zioso. ");
INSERT INTO yom_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ziela kuvindubula va ntoto va kimosi ayi bana baku badi yaku ayi kadi ditadi dimosi, mu ngeyo, dilendi siala va yilu ditadi dinkaka ko. Bila wusia zaba ko thangu yoyo Nzambi kayiza ku buminina. ");
INSERT INTO yom_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu wukota mu nzo Nzambi ayi wutona kuka batu bobo baba sumbisa bima, wuba kamba : ");
INSERT INTO yom_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Didi disonama : nzo ama yela ba nzo yi lusambulu vayi beni lukitudi yawu suamunu ki mivi ! ");
INSERT INTO yom_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bilumbu bioso Yesu wulonga mu nzo Nzambi. Zimbumu zi banganga Nzambi, minlongi mi mina ayi bakulutu ba batu batomba diluaku di kumvondisila. ");
INSERT INTO yom_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Vayi basia zaba ko busila bila batu boso banlandakana mu wa mambu mandi. ");
INSERT INTO yom_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lumbu kimosi Yesu bu kaba longa batu mu nzo Nzambi, wuba kuba samunina Nsamu Wumbote ; zimbukila bapfumu banganga Nzambi, minlongi mi mina ayi bakulutu ba batu bayiza, ");
INSERT INTO yom_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","banyuvula : —Wutukamba mu lulendo mbi wulembu vangila mambu momo ? Voti nani wuvana lulendo beni e ? ");
INSERT INTO yom_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu mamvandi wuba kamba : —Minu mamvama kiuvu kimosi kidi yama mu kuluyuvula. ");
INSERT INTO yom_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Bika lukhamba : mbotokolo yi Yowani, ku diyilu yiba voti kuidi batu e ? ");
INSERT INTO yom_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Buna beka lembu kayindulanga mu bawu veka. Buna baniunguta : enati tutubidi ti : “Ku diyilu” buna maka tuyuvula “vayi bila mbi lusia kunwilukila ko e ?” ");
INSERT INTO yom_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Vayi enati tutubidi ti “kuidi batu” buna batu boso maba tuvondila mu matadi bila batu boso bazebi ti Yowani wuba mbikudi. ");
INSERT INTO yom_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Buna bavutula ti basi zaba ko kuevi kaba. ");
INSERT INTO yom_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Buna Yesu wuba vutudila : —Minu mamvama, ndilendi kulukamba ko kani mu lulendo lu nani ndilembu vangila mambu mama. ");
INSERT INTO yom_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Bosi wukamba batu nongi yayi : —Mutu wumosi wukuna ndima yi vinu ; wuyekudila yawu minkuni muingi mimvananga ndambu yi mimbutu mu kadika mvu ayi wuyenda mu nzietolo mu mimvu miwombo. ");
INSERT INTO yom_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mu thangu yimvelungu makundi ma vinu, wutuma kisadi kiandikimosi kuidi minkuni bi ndima muingi mimvana ndambu yi mimbutu mi vinu vayi minkuni mi ndima mintuta khuba ayi mimvutula mioko yi mioko. ");
INSERT INTO yom_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wubuela fidisa diaka kisadi kinkaka. Mamvandi wututu khuba, wufingu ayi mimvutula mioko yi mioko. ");
INSERT INTO yom_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pfumu yi ndima wubuela fidisa diaka kisadi kintatu vayi minkuni mi ndima minlueka ayi minloza ku nganda yi ndima. ");
INSERT INTO yom_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Buna pfumu yi ndima wutuba : A mbi ndieka vanga e ? Ndieka fidisamuanꞌama wu luzolo ; mananga bela kummona lukinzu bu bela kummona. ");
INSERT INTO yom_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Vayi minkuni mi ndima bu mimmona, mitubana bawu na bawu : “Tala mutu wela vinginina ndima, bika tumvonda muingi ndima beniyikituka yeto veka !” ");
INSERT INTO yom_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Buna minkoka ku nganda yi ndima ayi mimvonda ! Buna pfumu yi ndima mbi kela vangila minkuni mi ndima e ? ");
INSERT INTO yom_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Buna wela kuiz, wela vondisa minkuni mi ndima ayi wela yekudila ndima beni kuidi minkuni minkaka. Batu bobo bawa, bamvutudila : —Bulendi baka bu bela ko. ");
INSERT INTO yom_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Vayi niandi wuba tala ayi wuba kamba : —Buna masonuku mama mbi mansundula : Ditadi diloza mintungi dikituka ditadi di mfunu diodi didi va fuma ki nzo ");
INSERT INTO yom_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","woso wela bua va yilu ditadi beni wela keluka tsingu ayi woso mutu ditadi beni diela builu wela kosakana. ");
INSERT INTO yom_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bapfumu zi zinganga Nzambi ayi minlongi mi mina batomba mu thangu yina kaka, mu kunkanga vayi bamona batu tsisi bila basudika kuawu ti bawukavekula bu katuba nongo yoyi. ");
INSERT INTO yom_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Buna batona kumfiela ; diawu bamfidisila batu mu diambu bamfiela. Batu beni baba kukimonikisanga batu basonga mu diambu bambuidila mu moso kuandi mambu kakuiza tubi muingi banyekula mu mioko mi zuzi ayi mu luyalu lu nyadi. ");
INSERT INTO yom_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Buna batubeni banyuvula : —A Nlongi, tuzebi ti ngeyo weta tubila mu busonga ayi weta longila mu busonga. Ngeyo wutalanga bizizi bi batu ko vayi weta longila mu bukiedika nzila yi Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","A buevi, minsua midi yetu mu futa phaku kuidi Sezali voti tuisi ko minsua e ? ");
INSERT INTO yom_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bu kabakula mayuya mawu, buna wuba kamba : ");
INSERT INTO yom_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Mbonisanu sengo kimosi ki denali ! Mfikula yayi yi nani ayi bisono biabi binani e ? Bamvutudila ti bi Sezali. ");
INSERT INTO yom_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Buna wuba kamba ti : —Bika luvana bi Sezali kuidi Sezali bosi bi Nzambi kuidi Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Basia nunga ko kumbuidila mu mambu makatuba va meso ma batu. Basimina bu bawa mvutu andi ayi basia baka diaka diambu di tuba ko. ");
INSERT INTO yom_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ndambu Basaduki, batu bobo kaba kikininanga ko ti batu beti fuluka, bafikama ayi banyuvula kiuvu : ");
INSERT INTO yom_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—A nlongi, Moyize wutusonikina ti : enati mutu fuidi vayi kasia bika muana ko, buna khombꞌandi yi bakala kafueti vinginina nketo wowo kabikidi muingi kabutila khombꞌandi bana. ");
INSERT INTO yom_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Vayi vaba tsambudidi bakhomba zi babakala. Wutheti wukuela, wufuamu kambu bika muana, ");
INSERT INTO yom_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","wummuadi, ayi wowo wuntatu bankuela. Buawu bobo buvangimina mu bawu boso, ");
INSERT INTO yom_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","bawu tsambudi bafua mu kambu bika bana. ");
INSERT INTO yom_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ku nzimunina bawu boso nketo beni mamvandi wufua. ");
INSERT INTO yom_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mu thangu yi mfulukulu, wela ba nketo wu nani bila wuba nketo wu tsambudi di bakhomba ziozo e ? ");
INSERT INTO yom_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu wuba vutudila : —Bana ba ntoto wawu balembo kuedi ayi balembo kuedisa ");
INSERT INTO yom_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","vayi bobo bela monika ti bafueni mu tula mu thangu yinkuiza ayi mu fuluka mu bafua balendi buela kuela ko ayi balendi buela kuedusu ko. ");
INSERT INTO yom_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bila balendi buela fua ko bila beka banga zimbasi ayi beka banaba Nzambi, bana ba mfulukulu. ");
INSERT INTO yom_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moyize wutelama kimbangi ti bafua bela fuluka mu nzila yi finti fiba lema. Bila kuna katedila Pfumu ti : Nzambi yi Abalahami, Nzambi yi Izaki, Nzambi yi Yakobi. ");
INSERT INTO yom_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Vayi niandi kasi Nzambi yi bafua ko vayi Nzambi yi batu banzinga. Bila kuidi niandi, bawu boso balembu zingi. ");
INSERT INTO yom_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Buna ndambu minlongi mi mina mitaba : —A nlongi, vutudi bumbote. ");
INSERT INTO yom_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Basia buela kunyuvula kadi diambu dimosi ko. ");
INSERT INTO yom_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Buna Yesu wuba yuvula : —A buevi beta tubila ti Klisto widi muana wu Davidi e ? ");
INSERT INTO yom_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Bila niandi veka Davidi wutuba mu minkunga : Pfumu wukamba kuidi Pfumu ama : Vuanda va koko kuama ku lubakala ");
INSERT INTO yom_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nate ndimanisa tula bambeni ziaku banga tetuku kiaku ki malu maku. ");
INSERT INTO yom_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidi wunkuntedila Pfumu, buna buevi kalenda buela bela muanꞌandi e ? ");
INSERT INTO yom_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sumbu batu boso bawa, buna wukamba minlonguki miandi : ");
INSERT INTO yom_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Lulubukila minlongi mi mina mimmonanga khini mu diatilanga mu mazuela ma mula ayi minzolanga baba vaninanga zimbote mu mazandu, minzolanga vuandanga mu bibuangu binzitusu mu zinzo zi zikhutukunu ayi mu minyengo. ");
INSERT INTO yom_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Minlongi beni mi mina minyibanga mu zinzo zi mafuola ayi mieta vunikisa sambila zitsambulu zi mula. Bawu bela baka thumbudulu yi lutidi ngolo. ");
INSERT INTO yom_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bu katala, buna wumona bamvuama batula makaba mawu mu bipani. ");
INSERT INTO yom_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Buna wumona diaka nsukami wu difuola wuyiza tibula bisengo biodi bi zimbongo. ");
INSERT INTO yom_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Buna wutuba : —Bukiedika ndikulukamba nsukami wu difuola diadi niandi lutidi vana viokila batu boso bankaka. ");
INSERT INTO yom_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bila batu boso baba batambikidi bitsiadisila. Vayi difuola diadi diveni zizioso zibedi yandi mu zingila. ");
INSERT INTO yom_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sumbu bankaka bayolukila nzo Nzambi bu batuba ti yawu yitungulu mu matadi ma kitoko ayi mu bima bitambuku banga makaba ");
INSERT INTO yom_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","buna Yesu wuba kamba : —Mu diambu di bima biobi lulembo tadi, bilumbu biela kuiza, biobi biela ba ti ; kadi ditadi dimosi diela siala va mbata ditadidinkaka ko dinkambutiolumuka. ");
INSERT INTO yom_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Buna bawu banyuvula : —A nlongi, thangu mbi mambu beni mela vangiminina ayi mu bidimbu mbi bela zabila ti mambu momo mafueti vangama e ? ");
INSERT INTO yom_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu wuba vutudila : —Lulubuka tala luedi vukumunu bila bawombo bela kuizila mu dizinadiama, bela tuba ti : “Minu kuandi” ayi “thangu yifikimini”. Buna kadi ku balandakana ! ");
INSERT INTO yom_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mu thangu luela wa zimvita ayi zikhindu buna lubika ba mona tsisibila mambu moso momo mafueti tuama ba. Vayi kadi sia ti buna tsukusunuyi ntoto yeka nduka. ");
INSERT INTO yom_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Buna wubuela diaka : —Luela mona tsi yela nuanisa tsi yinkaka ; kipfumu kiela nuanisa kipfumu kinaka. ");
INSERT INTO yom_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kuela ba zindikunu zinneni zi ntoto mu bibuangu biwombo ; kuela ba bikanda ayi minsongo ; kuela ba mambu ma tsisi ayi bidimbu bitsisi bi diyilu. ");
INSERT INTO yom_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—Vayi tuamina mambu moso momo, bela tuama ku lubuila bela kuluyamisa, bela ku lunata mu zinzo zi zikhutukunu ; bela ku lukotisa mu nloko. Bela ku lunata va ntuala mintinu ayi minyadi mu diambudi dizina diama. ");
INSERT INTO yom_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mambu momo mela lukuizila mu diambu ma luvana diluakudi kuthelimina kimbangi. ");
INSERT INTO yom_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bika lusudika mu mintima mieno ti : lubika ba mayindu mu diambu mambu luela vutula mu kukikakila. ");
INSERT INTO yom_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bila minu ndiela luvana munu wutubila ayi diela ayi bambeni beno zilendi baka bu nuanisina ko ayi bu sudikila ko. ");
INSERT INTO yom_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Zimbuta beno, bakhomba zieno, bibutu bieno ayi bakundi beno bela ku luyekula ayi bela vondisa bankaka mu beno. ");
INSERT INTO yom_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Batu boso bela ku lulenda mu diambu di dizina diama. ");
INSERT INTO yom_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Vayi kadi lusuki lumosi lu mintu mieno lulendi zimbala ko. ");
INSERT INTO yom_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lukindama buna luela tambula luvulusu. ");
INSERT INTO yom_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Bu luela mona masodi mazungididi Yelusalemi buna luzaba ti dieka nduka bungu. ");
INSERT INTO yom_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Buna bika batu bobo badi mu Yuda batinina ku miongo. Bika bobo badi mu Yelusalemi baba tomba butinina. Bika bobo badi mu zitsola babika buela kota ku divula ! ");
INSERT INTO yom_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bukiedika bilumbu bina biela ba bilumbu bi vutudila landi muingi mambu moso masonama madedakana. ");
INSERT INTO yom_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Vayi mabienga kuidi baketo bobo badi mu buemba ayi kuidi bobo bela yemika mu bilumbu bina. Bila ziphasi zingolo ziela ba mu tsi ayi nganzi yingolo yela fuemunu batu baba. ");
INSERT INTO yom_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Batu beni bela vondulu mu mbedi voti bela natu mu kivika mu zitsizioso ayi bapakanu bela diatila Yelusalemi nate thangu yi fuana. ");
INSERT INTO yom_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","—Bidimbu bi tsisi biela monika mu thangu, mu ngonda ayi mu zimbuetete. Va ntoto, batu bela mona tsisi yingolo mu diambu di biyoko bi mbuayi bi mayo mandi. ");
INSERT INTO yom_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Batu bela fuila mu tsisi mudiambu di boma bu mambu mela bua va ntotowumvimba bila lulendo lu diyilu luela nikunu. ");
INSERT INTO yom_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Buna bela mona Muana Mutu wela kuizila mu matuti mu lulendo ayi mu nkembo wunneni. ");
INSERT INTO yom_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mambu mama bu mela tona buna luvumbuka ayi luba vumbula mintu mienobila buna khudulu eno yifikimini. ");
INSERT INTO yom_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Wubuela tuba diaka nongo yayi : —Lutala nti wu figi ayi minti mioso. ");
INSERT INTO yom_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Muthangu mieti tona mena buna beno veka, mu ku mitala, luzebi ti thangu yi luanga yifikimini. ");
INSERT INTO yom_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bobuawu, beno mamveno buna luela mona ti mambu momo mavangiminibuna luzaba ti kipfumu ki Nzambi kifikimini. ");
INSERT INTO yom_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Bukiedika ndikulukamba ti tsungi yayi yilendi vioka ko tuaminamambu moso mama mavangama. ");
INSERT INTO yom_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Diyilu ayi ntoto biela vioka vayi mambu mama malendi vioka ko. ");
INSERT INTO yom_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Lukikeba beno veka mu diambu di mintima mieno mibika ba zitumu diambudi phulu yi dia ayi yi kolo malavu ; ayi mu diambu di mayinduma luzingu lualu muingi lumbu kina kibika lukuizila mu kinzimbukila. ");
INSERT INTO yom_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bila kiela kuizila banga dikondi dibuididi batu boso bamvuandanga va ntoto. ");
INSERT INTO yom_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Luzibula meso ayi lusambila mu zithangu zioso mu diambu luba monikabatubafuana mu tina mambu moso mama mafueti kuiza ayi mu diambu lubakabu telumina va ntuala Muana Mutu. ");
INSERT INTO yom_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mu muini Yesu wuba longanga mu nzo Nzambi. Wuba totukanga kadika builu ayi wuba vuandanga ku mongo wu minti mi olive. ");
INSERT INTO yom_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Muna nsuka-nsuka batu boso baba kuizanga ku nzo Nzambi mu diambu banwa. ");
INSERT INTO yom_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Buna Pasika yeka nduka, “nyengo wu mapha makambu tulu luvi”, ");
INSERT INTO yom_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","bapfumu banganga Nzambi ayi minlongi mi mina batomba diluaku divondisila Yesu bila batu baba mona tsisi. ");
INSERT INTO yom_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Buna satana wukota mu Yuda wubaba ntedilanga Isikalioti, wubawumosi mu kumi ayi minlonguki miodi. ");
INSERT INTO yom_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Niandi wuyenda wuwizana ayi bapfumu banganga Nzambi ayi bapfumu zi bobo bansunganga nzo Nzambi mu zaba buevi kafueti kuba yekudila niandi. ");
INSERT INTO yom_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bawu bamona khini ayi bawizana mu kumvana zimbongo. ");
INSERT INTO yom_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda wukikinina ayi wutona tomba diluaku dimboti di kuba yekudila niandi nkanguwu batu mu kambu zaba. ");
INSERT INTO yom_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lumbu kinyengo wu mapha makambu tulu luvi kifuana ; kiawu lumbu baba tambikanga muana dimemi wu Pasika. ");
INSERT INTO yom_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu wutuma Piela ayi Yowani wuba kamba : —Yendanu lutukubikila bidia bi Pasika muingi tudia. ");
INSERT INTO yom_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bawu banyuvula : —A kuevi tidi tuenda kubikila yawu e ? ");
INSERT INTO yom_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Niandi wuba vutudila : —Tala, muthangu lukuiza koti mu divula buna ma dengana bakala dimosi dineti mvungu. Buna lunlundakana nate mu nzo kankota. ");
INSERT INTO yom_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Bosi lutuba kuidi pfumu yi nzo ti : “nlongi wuyuvuditi : kuevi kuidi buangu kioki kafueti dila Pasika va kimosi ayi minlonguki miama e ?” ");
INSERT INTO yom_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Niandi ma kalumonisa ku yilu banga vinga kimosi kinneni kikubuku. Kuna lufueti kubikila bidia bi Pasika. ");
INSERT INTO yom_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bawu bayenda ayi babata mambu moso boso kaba kambila ayi bawubakubika bidia bi Pasika. ");
INSERT INTO yom_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Thangu bu yifuana, Yesu wuvuanda va meza va kimosi ayi mimvuala miandi. ");
INSERT INTO yom_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Buna wuba kamba : —Phuila yiwombo yiba yama mu diambudi dia Pasika yayi va kimosi ayi beno tuamina ndimona ziphasi. ");
INSERT INTO yom_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bila ndikulukamba ndilendi buela yi dia ko nate yela mana fuana mu Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bu kabonga mbungu, wuvutula matondo ayi wutuba : —Bonganu mbungu yayi ayi lukabana yawu beno na beno ");
INSERT INTO yom_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","bila ndikulukamba ti ndilendi buela nua vinu ko nate kipfumu ki Nzambi kiela kuiza. ");
INSERT INTO yom_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wubonga dipha, wuvutula matondo. Wubukuna diawu ayi wuba vana diawu. Bosi wutuba : —Yayi yawu nitu ama yitambuku mudiambu dieno. Luvanganga bobo mu kumbanzanga. ");
INSERT INTO yom_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Buna bamanisa dia, wuba vana mbungu ayi wutuba : —Mbungu yayi yidi Nguizani yimona mu menga mama matengulu mu diambu dieno. ");
INSERT INTO yom_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","—Vayi tala mutu wowo wukunyekula widi vava, wundia yama va meza. ");
INSERT INTO yom_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ayi Muana mutu wedi bumbote boso butezulu vayi mabienga kuidimutu wowo wunyekudi. ");
INSERT INTO yom_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Buna batona kukiyuvula bawu na bawu kani nani mu bawu wukuiza vangi diambu diodi. ");
INSERT INTO yom_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Minlonguki mifindana ziphaka ziwombo mu diambu di zaba nani mu bawu lutidi munneni. ");
INSERT INTO yom_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Buna Yesu wuba kamba : —Mintinu mi Bapakanu minyadilanga batu bawuayi bobo beti yadila mubawubeti tedulu : “mimvangi mi mambote”. ");
INSERT INTO yom_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Vayi bwawu ko bufueti bela kuidi beno. Woso widi wunneni mu benobuna bika kakituka banga muana lezi. Ayi woso weti yala kaba banga kisadi. ");
INSERT INTO yom_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Bila nani lutidi munneni : mutu vuendi va meza voti mutu wowo wulembu sadi e ? Keti mutu wowo vuendi va meza lutidi munneni e ? Vayi minu ndidi va khatitsikꞌenu banga kisadi. ");
INSERT INTO yom_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Vayi beno, luidi batu bobo babedi bakuikama yama mu zithotolo ziama. ");
INSERT INTO yom_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sumbu didi ti Tata wuphana Kipfumu, mamvana ndiluveni Kipfumu beni ");
INSERT INTO yom_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","muingi lubaka budila ayi bu nuina va meza yama mu Kipfumu kiama ayimuingi lubaka bu vuandila mu bikundu bi Kipfumu mudiambu di sambisa kumi makanda muadi ma Iseli. ");
INSERT INTO yom_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu wukamba Simoni ti : —A Simoni, A Simoni, satana wululombidi mudiambu kaluyungula banga bu beti yungudila ble. ");
INSERT INTO yom_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Vayi minu tsambidingi mu diambu diaku muingi minu kiaku kibika lebakana. Diawu buna ngeyo wela vutuka, buna wuba kindisa bakhomba zikau. ");
INSERT INTO yom_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simoni wunkamba : —A Pfumu, ndidi wukubama mu kuenda yaku mu nloko ayi ku lufua. ");
INSERT INTO yom_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Vayi Yesu wumvutudila : —A Piela, bukiedika ndikukamba ti mu buabu kuandi tuamina tsusu yikokula ngeyo zikhumbu zitatu mawu thunukina ti wusi kunzaba ko. ");
INSERT INTO yom_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Buna wuba kamba : —Mu thangu ndilutuma mu kambu nata photomoni, mu kambu sakosi, mu kambu nata zisapatu ; a kima mbi lukambu e ? Bawu bamvutudila ti : —Kadi kima tusia kambu ko. ");
INSERT INTO yom_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Vayi Yesu wuba kamba : —Vayi buabu woso widi photomoni buna bika kayibonga ; bobuawu woso widi ayi sakosi bika kayibonga ayi woso kambulu mbedi bika kasumbisa nledi andi mu diambu kasumba mbedi ");
INSERT INTO yom_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","bila ndikulukamba ti mama masonama madedakana mu diambudiama : bantula mu ntanda wu batu bambimbi. Bila mambu momo masonama mu diambu diama madi ayi tsukulu. ");
INSERT INTO yom_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bawu batuba : —A Pfumu, tala zimbedi zizole zidi vava ! Niandi wuba vutudila ti : —Bufueni. ");
INSERT INTO yom_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Buna wutotuka boso bubela kifu kiandi, wuyenda ku mongo mingi mi olive. Minlonguki miandi minlandakana. ");
INSERT INTO yom_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bu katula, ku buangu beni, buna wuba kamba : —Lusambila tala luedibua mu phukumunu. ");
INSERT INTO yom_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Buna niandi veka wuba tatukila fiote mu tezo kilenda tudila ditadi bu diozulu. Buna wufukama ayi wusambila : ");
INSERT INTO yom_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—A Tata, enati zodidi, khatudila mbungu yayi. Muaki bika luzolo luaku luvangama vayi bika luama.  ");
INSERT INTO yom_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Buna mbasi yitotukila ku Diyilu yiyiza kunkindisa. ");
INSERT INTO yom_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Bu kaba mu tsisi yi khindu ; wuluta buela sambila diaka ngolo ayi diunga ditotuka mu nitu andi diba banga mabeti ma menga maba bua va ntoto. ");
INSERT INTO yom_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bu kamanisa sambila, wutelama ayi wuyiza vaba minlonguki miandi. Wuba buana baleka mu diambu di kiadi. ");
INSERT INTO yom_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Buna wuba kamba : —Bila mbi lulembo lekila tulue ? Kotukanu ! Lusambila tala luedi bua mu phukumunu. ");
INSERT INTO yom_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Buna kamanisini ko tuba, tala nkangu wu batu wutotuka. Yuda, wumosi mu kumi mimvuala miandi miodi, wuba vana ntuala ; wufikama vaba Yesu mu diambu kamfifa besi. ");
INSERT INTO yom_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Vayi Yesu wunkamba : —A Yuda, mu besi weka yekudila Muana mutu e ? ");
INSERT INTO yom_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bobo banzungidila bu bamona mambu momo meka bua bankamba : —A nlongi, tubonga zimbedi muingi tunuana e ? ");
INSERT INTO yom_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wumosi mu bawu wuzuba kisadi ki pfumu yi banganga Nzambi ayi wunzenza dikutu diandi di lubakala. ");
INSERT INTO yom_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Vayi Yesu wuba vutudila : —Bikanu mabela bobo nate buabu ! Bu kasimba dikutu buna wumbelusa. ");
INSERT INTO yom_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bosi yesuwukamba bapfumu banganga Nzambi, bapfumu zi minsungi mi nzo Nzambi ayi bakulutu ba batubobo banata nkangu wubatu mudiambubiza nkangi : —Lutotukidi ayi zimbedi ayi zimbindi mudiambu di lunuanisa dovula e ? ");
INSERT INTO yom_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bilumbu bioso bu ndibedi yeno mu nzo Nzambi ayi kadi mutu kadiaku khanga ko vayi buabu yawu thangu eno ayi thangu yi luyalu lu tombi. ");
INSERT INTO yom_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Buna bambuila, bannata ayi bankotisa mu nzo yi pfumu yi zingangazi Nzambi. Piela kuna manima kaba nlandikinina. ");
INSERT INTO yom_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mu thangu balunga mbazu va khatitsika nganda ayi bu bavuanda va kimosi. Piela mamvandi wuvuanda yawu. ");
INSERT INTO yom_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kisadi kimosi ki nketo wummona buna kavuendi va ndambu mbazu, wunsungimina kuntala mu kiezila wu nlaki wu mbazu, ayi wunkamba : —Mutu wawu bedingi yandi ! ");
INSERT INTO yom_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Vayi Piela wutunuka kuandi bu katuba : —A nketo, ndisi kunzaba ko ! ");
INSERT INTO yom_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Buela vuanda fioti, mutu wunkaka wumona Piela ayi wunkamba : —Ngeyo widi mu dikabu di batu bobo ! Vayi Piela wuvutula ti : —A bakala, minu ndisi ko mu dikabu diawu. ");
INSERT INTO yom_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nduka-nduka thangu yimvimba yivioka, mutu wunkaka wuyiza buelasindisila diaka ti : —Bukiedika mutu wawu bedingi yandi bila mamvandi widi muisi Ngalili. ");
INSERT INTO yom_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Vayi Piela wuvutula ti : —A bakala, ndisi zaba ko diambumbi wunyolukila ! Muna thangu buna wukidi tubi tsusu yikokula. ");
INSERT INTO yom_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pfumu wubaluka, wutala Piela. Buna Piela wutebukila moyo mambumankamba Yesu ti “tuamina tsusu yikokula, ngeyo mu zikhumbu zitatu mawuthumukina”. ");
INSERT INTO yom_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Buna Piela wutotuka ku nganda ayi wudila ngolo. ");
INSERT INTO yom_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Batu bobo basunga Yesu bansekinina ayi bambeta. ");
INSERT INTO yom_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bamfukidila zizi ayi banyuvula : —A ngeyo, bikula ko e ! Nani wubetidi e ? ");
INSERT INTO yom_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Buna batuba mambu mawombo mankaka mu diambu di kumfinga. ");
INSERT INTO yom_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Buisi buna bukia, bakulutu ba batu, bapfumu banganga Nzambi va kimosi ayi minlongi mi mina bakutakana. Banata Yesu va ntualalukutukuu luawu lunneni ; ");
INSERT INTO yom_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bawu banyuvula : —Enati ngeyo widi Klisto, buna bika wutukamba. Buna wuba vutudila : —Enati ndilukembi, buna lulendi wilukila ko. ");
INSERT INTO yom_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ayi enati ndiluyuvudi biuvu, lulendi kuphana ko mvutu. ");
INSERT INTO yom_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Vayi tona buabu Muana mutu wela vuanda va koko ku lubakala lu lulendo lu Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Buna bawu bobo batuba : —Buna ngeyo widi muana Nzambi e ? Yesu wuba vutudila : —Beno veka lutubidi ti minu buawu bobo ndididi. ");
INSERT INTO yom_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Vana vawu bayamikina : —Mbi kimbangi kinkaka tufueti buela tomba e ? Bila beto veka tunwilumu mambu mandi katubidi. ");
INSERT INTO yom_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Batu boso batelama va kimosi ayi bannata kuidi Pilatu. ");
INSERT INTO yom_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kuna bamfundila bu batuba ti : —Mutu wawu tummueni wulembo votikisa batu ba tsi eto. Niandi wubedi kuba kandikanga babika futa phaku kuidi Sezali ayiwubedi tubanga ti niandi Klisto (bu dinsundula ti ntinu). ");
INSERT INTO yom_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Buna Pilatu wunyuvula : —Ngeyo widi ntinu wu Bayuda e ? Yesu wumvutudila : —Ngeyo weka tubidi buawu. ");
INSERT INTO yom_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Buna Pilatu wukamba bapfumu banganga Nzambi ayi nkangu wu batu ti : —Ndisi mona kadi diambu di mbimbi ko mu mutu wawu. ");
INSERT INTO yom_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bawu baluta buela sindisila ti : —Niandi wutonisanga zikhindu mu malongi mandi momo kalonga mu Yuda dioso ; bu katonina ku Ngalili nate kuaku. ");
INSERT INTO yom_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatu bu kawa ti bayolukila Ngalili, buna wuyuvula kani mutu wowo wuba muisi Ngalili. ");
INSERT INTO yom_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bu kawa ti wuba muisi zunga kiyadila Elode ; buna wumfidisa kuidi Elode bila mu bilumbu bina, Elode buna widi ku Yelusalemi. ");
INSERT INTO yom_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Elode wumona khini bu kamona Yesu bila tona thama wuba tombanga diluaku di kummonina mu diambu di mambu mawombo kawa mu niandi ; ayi wutula diana ti maka mona kumu kioki maka vanga. ");
INSERT INTO yom_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Buivu biwombo kanyuvula vayi Yesu kasia vutula kadi diambu dimosi ko. ");
INSERT INTO yom_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Vayi bapfumu banganga Nzambi ayi minlongi mi mina batelama vana ayi baba kumfunda ngolo. ");
INSERT INTO yom_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Elode va kimosi ayi masodi mandi banlenza bansekinina bamvuikanledi wu kitoko ; wumvutula kuidi Pilatu. ");
INSERT INTO yom_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilatu ayi Elode bakituka bakundi tona mu lumbu kina bila batuama ba bambeni. ");
INSERT INTO yom_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatu wukutikisa bapfumu banganga Nzambi, bakulutu ba batu va kimosi ayi batu. Wuba kamba : ");
INSERT INTO yom_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—Beno lundatiningi mutu wawu bu lumfundidingi ti niandi wulembu vukumuna batu. Vayi tala minu veka mbeni kunsambisa va meso meno ayi ndisi mona kadi diambu di mbimbi ko mu mutu wawu mu mambu momo lulembu mfundila. ");
INSERT INTO yom_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Elode mamvandi kasi mona diambu di mbimbi ko bila wutuvutudidi niandi. Mutu wawu kasi vanga ko bila kioki kafueti vondulu. ");
INSERT INTO yom_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Diawu ndieka kunzubisa bikoti bosi ma ndiyekula.  ");
INSERT INTO yom_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatu wuba kifu ki kuba totudilanga mutu wumosi wu nloko mu kadikanyengo. ");
INSERT INTO yom_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Vayi nkangu woso wuyamikina : —Vondisa mutu wowo ; totula Balabasi ! ");
INSERT INTO yom_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasi beni wukotusu mu nloko mu diambu di khindu yimosi yiba mu divula, ayi mu diambu di vonda batu. ");
INSERT INTO yom_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Vayi Pialatu wuzola totula Yesu, wubuela yuvula nkangu vayi wawu wuyamikina diaka : ");
INSERT INTO yom_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","—Mbanda va dikulusi ! Mbanda va dikulusi ! ");
INSERT INTO yom_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Buna wuyuvula diaka mu khumbu yintatu ti : —Vayi mbimbi mbi kavengi e ? Ndisi mona kadi diambu di mbimbi kodiodi kafueti zengulu nkanu wu lufua. Ndieka kunzubisa bikoti bosi ma ndinyekula. ");
INSERT INTO yom_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Vayi babuela sindisila mu ngolo ayi baluta buela yamikina ti kabandu va dikulusi. Buna yamikina kuawu ayi koko ku bapfumu zi zinganga Nzambi kununga. ");
INSERT INTO yom_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatu wubaka lunaku luvanga luzolo luawu. ");
INSERT INTO yom_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wuba totukila mutu wowo balomba, wowo wuba mu nloko mu diambu di khindu ayi mu diambu di vonda batu. Wuba yekudila Yesu muingi bamvangila boso bubela luzolo luawu. ");
INSERT INTO yom_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bu baba kunnata, babuila mutu wumosi dizina diandi Simoni muisi Silene ku nsitu kuandi kaba. Bankuika kanata dikulusi, ku manima ma Yesu. ");
INSERT INTO yom_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nkangu wu batu wunlandakana va kimosi ayi baketo banionga mu diambudiandi, badila mu diambu diandi. ");
INSERT INTO yom_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bu kabaluka kuidi baketo beni ; wuba kamba : —A beno baketo ba Yelusalemi, lubika dila mu diambu diama ! Vayi ludila mu diambu dieno veka ayi mu diambu di bana beno. ");
INSERT INTO yom_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bila tala bilumbu bilembu yizi ku ntuala biobi batu bela tuba ti : “Khini kuidi bisita ayi kuidi bivumu bikambu buta ayi khini kuidi mabenimakambu yemika !” ");
INSERT INTO yom_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Buna bela kamba miongo : “Bika lutubuila !” ayi zikhundubula : “bika lutufuka !” ");
INSERT INTO yom_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bila enati bamvangila mambu mama kuidi nti wu nlandu bunabuevi bela vangila nti wu yuma e ? ");
INSERT INTO yom_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Batu buadi bankaka, mimvangi mi mambu mambimbi, banatu yandi mu vondu va kimosi. ");
INSERT INTO yom_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bu batula va buangu kintedulungu “Mvesi wu ntu” vana bambandilava dikulusi va kimso ayi mimvangi miodi mi mambu mambimbi. Wumosiku koko kuandi ku lubakala ayi wunkaka ku koko kuandi ku lumoso. ");
INSERT INTO yom_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Buna Yesu wutuba : —A tata, bika wuba lemvukila bila basi zaba ko mambu balembu vangi. Babula zeki mu diambu di kabana minledi miandi. ");
INSERT INTO yom_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nkangu wu batu wutelama vana, wutala. Ayi minyadi mamvawu minsekinina bu mituba : —Niandi wuvukisidi batu bankaka, bika kakivukisa niandi veka enati niandi Klisto, mutu wusobulu kuidi Nzambi ! ");
INSERT INTO yom_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Masodi mamvawu mansekinina ; mafikama va kaba ayi mantambika vinu ki ngami ");
INSERT INTO yom_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ayi batuba : —Enati ngeyo widi ntinu wu Bayuda, bika wukivukisa ngeyo veka ! ");
INSERT INTO yom_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Va mbata ntu andi vaba tini ki dibaya kisonama mambu mama : “Niandi niawu ntinu wu Bayuda.” ");
INSERT INTO yom_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wumosi mu mimvangi mi mambu mambimbi wubandu va mdikulusiwumfinga bu katuba : —Ngeyo ko Klisto e ? Buna wukivukisa ngeyo veka bosi wutuvukisa beto mamveto ! ");
INSERT INTO yom_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Vayi wunkaka wuntebidila bu kankamba : —Ngeyo kadi tsisi wukadi mona Nzambi ! Bila ngeyo widi ku thumbudulu yimosi ? ");
INSERT INTO yom_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Beto tubeki thumbudulu yifueni ayi yisonga bila tutambudi mfutu wufueni mu mambu matuvengi vayi niandi kasi vanga kadi diambu dimosi dimbimbi ko. ");
INSERT INTO yom_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Buna wukamba Yesu : —A Pfumu bika wuba kuthebukila moyo mu thangu wela kuiza mu kipfumu kiaku ! ");
INSERT INTO yom_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Buna Yesu wumvutudila : —Bukiedika ndikukamba, mu lumbu kiaki ngeyo ma wuba yama va kimosi ku Paladisu. ");
INSERT INTO yom_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yiba nduka-ndkuka midi, tsi yoso yiba mu tombi ayi kiawukinzingila nate mu thangu yi ntatu ku manima midi. ");
INSERT INTO yom_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Thangu yinomba bosi lido yinneni yi nzo Nzambi yikanzuka va khatitsika. ");
INSERT INTO yom_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Buna Yesu wuyamikina mu ndinga yingolo : —A tata, mu mioko miaku ndintambika mpeve yama ! Bu katuba mambu momo, wufua. ");
INSERT INTO yom_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pfumu yi masodi bu kamona mambu mavioka, wukembisa Nzambi bu katuba : —Bukiedika kuandi ti mutu wawu wubedi wusonga ! ");
INSERT INTO yom_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nkangu woso wu batu bakutakana mu tala mambu mavangama, bu bamona mambu mavioka, bavutuka kuawu, ayi baba nionga. ");
INSERT INTO yom_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ayi batu bobo bazabana yandi ayi baketo bobo banlandakana tona ku Ngalili thama batelimina mu tala mambu momo. ");
INSERT INTO yom_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tala, mutu wumosi dizina diandi Zefu wuba wumosi mu batu baba kotanga mu lukutukunu lunneni lu Bayuda. Wuba mutu wumboti ayi wusonga. ");
INSERT INTO yom_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Niandi kasia bundana mu nzengolo yawu ko ayi mu mavanga mawu ko. Niandi wuba muisi divula di Alimate, divula di bayuda ayi niandi mamvandi wuba vingilanga Kipfumu ki Nzambi. ");
INSERT INTO yom_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wuyenda kuidi Pilatu, wunlomba nitu yi Yesu. ");
INSERT INTO yom_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bu kayi kulula va dikulusi, buna wuyizinga mu dilasola di lino ayi wutula yawu mu dibumbi disokulu mu ditadi dinneni. Kadi mutu kazikulu ko mu dibumbi beni. ");
INSERT INTO yom_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kiba lumbu ki khubumunu, tuamina lumbu ki saba. ");
INSERT INTO yom_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Baketo bobo balandakana Yesu tona ku Ngalili balandakana Zefu, bamona bibumbi ayi buevi batudila nitu yi Yesu. ");
INSERT INTO yom_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bosi bavutuka kuawu ayi bakubika mafuta ma tsudi yi kotoko ayi malasi. Bavunda kuawu mu lumbu ki saba boso bubela mina. ");
INSERT INTO yom_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mu nsuka-nsuka wu lumbu kitheti ki sabala, baketo bayenda kudibumbi. Banata mafuta ma tsudi yi kitoko momo bakubika. ");
INSERT INTO yom_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bamona ditadi difuka mualo wu dibumbi divindumunu va ndambu muelo. ");
INSERT INTO yom_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bakota vayi basia mona ko nitu yi Pfumu Yesu. ");
INSERT INTO yom_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Buna bakidi yindula tsundu yi diambu diodi, bazimbukila batu buadibavuata minledi miba lezama batelama va ndambu. ");
INSERT INTO yom_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sumbu bamona tsisi ayi bayinika bizizi biawu mu tsi, buna batu beni baba yuvula : —Bila mbi luntombila mutu widi moyo va khatitsika yi batu bafua e ? ");
INSERT INTO yom_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kasiedi vava ko vayi fulukidingi. Lutebuka moyo buevi kaluyolukilabuna wukidi ku Ngalili bu kalukamba ti : ");
INSERT INTO yom_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Muana Mutu kafueti yekulu mu mioko mi bankua masumu, wela bandu va dikulusi ayi wela fuluka mu lumbu kintatu. ");
INSERT INTO yom_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Buna batebukila mambu mandi momo moyo. ");
INSERT INTO yom_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Basia bika dibumbi, bavutuka kuawu ayi bavumbudila kipholo ki mambu moso mama kuidi kumi mimvuala wumosi ayi kuidi batu boso bankaka. ");
INSERT INTO yom_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mu bawu muba Maliya muisi Mangadala, Zana, Maliya ngudi yi Zaki va kimosi ayi maketo bankaka basamuna mambu mama kuidi mimvuala. ");
INSERT INTO yom_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Vayi mimvuala mimanga wilukila mambu mawu bila mimonina mambu mawu banga mambu makambulu tsundu. ");
INSERT INTO yom_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Vayi Piela wutelama, wuzawula ku dibumbi. Bu kayinama, buna miomiminledi mikazikulu kaka kamona. Wuvutuka kuandi ku nzo andi wusiminamu diambu di mambu momo mavioka. ");
INSERT INTO yom_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mu kina kiawu lumbu, minlonguki miodi miyenda ku buala bumosibaba ntedilanga Emawusi. Buala beni butatukila Yelusalemi nduka-ndukamu tezo ki kumi kilometele biodi. ");
INSERT INTO yom_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Miyolukila mambu moso momo mavioka. ");
INSERT INTO yom_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bu miba solula ayi miba findana zimpaka, mizimbukila niandi veka Yesu wuba fikama ayi wuyenda yawu va kimosi. ");
INSERT INTO yom_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Vayi meso mawu maba mafuku mu diambu babika kumbakula. ");
INSERT INTO yom_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Buna wuba yuvula : —A mambu mbi momo lulembu yolukila bu lueti kuenda yendingi e ? Mitelama ayi bizizi bi kiadi-kiadi. ");
INSERT INTO yom_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wumosi mu bawu, dizina diandi Klewopasi wumvutudila : —Vayi buna ngeyo kaka mu batu bobo bamvuandanga ku Yelusalemikambulu zaba mambu maviokidi muawu mu bilumbu biabi e ? ");
INSERT INTO yom_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Niandi wuba yuvula : —A mambu mbi momo e ? Bawu bamvutudila : —Mambu mabuilulu Yesu muisi Nazaleti wubedi mbikudi wu lulendomu mavanga mandi ayi mu thubulu andi va ntuala Nzambi ayi va ntuala batu boso. ");
INSERT INTO yom_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bapfumu zieto zi banganga Nzambi ayi bapfumu zieto zinyekudi mu diambu di banzengila nkanu wu lufua ayi mu diambu di bambanda va dikulusi. ");
INSERT INTO yom_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Diana tubedi tulanga ti niandi wukuiza kudi Iseli. Vayi talabuabu kiawu kiaki lumbu kintatu tona mambu beni makibelanga. ");
INSERT INTO yom_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bukiedika kuandi ti baketo bankaka mu beto batuyindusidingi ngolo bu babedingi ku dibumbi va nsuka-nsuka. ");
INSERT INTO yom_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Sumbu basi monanga ko nitu andi, buna biza samunanga ti tsongolobamueningi ; bamueningi zimbasi zibakembingiti bukiedika widi moyo. ");
INSERT INTO yom_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Buna bankaka mu bobo badi yeto bedingi ku dibumbi. Benda buanangamambu boso busamuniningi baketo ; vayi, niandi, basi kummonanga ko. ");
INSERT INTO yom_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Buna Yesu wuba kamba : A batu bakambu diela ayi fuana phasi lummona mu mintima mu wilukila mambu moso mimbikudi mibikula. ");
INSERT INTO yom_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A keti Klisto kafueti tuama mona phasi mu diambu di mambu momosimbu kakota mu nkembo andi e ? ");
INSERT INTO yom_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bosi Yesu wutona kuba sudikisa mambu moso masonama mu diambu dianditonina mu Moyize nate mu mimbikudi mioso. ");
INSERT INTO yom_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Vayi buna bafikama buala bobo baba kuenda ; niandi wuvunikisa kuenda thama ");
INSERT INTO yom_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","vayi bansimbidila bu banleba : —Vuanda yeto, tala buisi bueka yila ayi masika mazidi. Buna wukota yawu mu nzo ayi wuvuanda yawu. ");
INSERT INTO yom_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wuvuanda yawu va meza, wubonga dipha ayi wudisakumuna, wudibukuna bosi wuba kabudila diawu. ");
INSERT INTO yom_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Buna meso mawu mazibuka ayi bambakula vayi kasia buela monikako, wutumbu zimbala va meso mawu. ");
INSERT INTO yom_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Buna bakambasana bawu na bawu : —Keti mintima mieto misi banga mu khini ko mu thangu kalembukutuyolukilanga mu nzila, bu katuzingu budidi masonuku e ? ");
INSERT INTO yom_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Muna yina thangu, bavutuka ku Yelusalemi. Bayiza bata kumi mimvuala wumosi buna bakutikini va kimosi ayi bobo baba yawu, ");
INSERT INTO yom_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","balembu tubi ti : —Bukiedika ti Pfumu fulukidingi ; wukimonikisidingi kuidi Simoni. ");
INSERT INTO yom_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Buna minlonguki miodi beni mamvawu misamuna mambu momo mimonamu nzila ayi buevi miyiza bakudila Yesu mu thangu kabukuna dipha. ");
INSERT INTO yom_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Buna bakidi solula mu diambu di mambu beni, Yesu wutelamava khatitsikꞌawu ayi wuba kamba : —Ndembama yibanga yeno. ");
INSERT INTO yom_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Vayi baboso batita, bamona tsisi bila babanzila ti nkuyu bamueni. ");
INSERT INTO yom_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Buna wuba kamba : —A bila mbi luekila tsisi-tsisi ? Bila mbi mayindu mu mintima mieno ? ");
INSERT INTO yom_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Talanu mioko miama ayi malu mama. Keti minu kuandi e ! Bika lutsimba ayi lutala ! Keti nkuyu kasi ko minsuni ayi mimvesi vayi lulembu moni kueno ti minu minsuni ayi mimvesi midi yama. ");
INSERT INTO yom_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bu katuba bobo, wuba monisa mioko miandi ayi malu mandi. ");
INSERT INTO yom_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bu bakambu vika wilukila mu diambu di khini ayi mu diambu di simina, buna wuba yuvula : —Kima kidia kidi yeno vava e ? ");
INSERT INTO yom_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Buna bamvana tini ki mbizi ki lambu. ");
INSERT INTO yom_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wukibonga ayi wukidia va meso mawu. ");
INSERT INTO yom_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bosi wuba kamba : —Tala mawu mama mambu ndilukamba buna ndikidi yeno va kimosimambu mamo masonama mu diambu diama mu Mina mi Moyize, mu minkanda mi mimbikudi ayi mu minkunga mafueti kaka dedakana !” ");
INSERT INTO yom_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Buna wuzibula diela diawu muingi babaka bu sudikila masonuku. ");
INSERT INTO yom_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wuba kamba ti : —Disonama ti Klisto kafueti mona phasi ayi wela fuluka mu lumbu kintatu ");
INSERT INTO yom_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ayi bela samuna kuidi batu ba makanda moso tonina mu Yelusalemi ti mu dizina diandi, batu babalula mavanga ayi batambula nlemvo mu masumu mawu. ");
INSERT INTO yom_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Beno luidi bambangi ba mambu momo. ");
INSERT INTO yom_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tala minu ndieka nduka kulufidisila biobi Dise diama kaluvaninatsila. Diawu beno luvuanda kaka mu divula nate luela vuiku lulendo lu diyilu. ");
INSERT INTO yom_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bosi wuba nata ku nganda yi divula nate ku ndambu yi Betani. Kuna kamvumbudila mioko miandi ayi wuba sakumuna. ");
INSERT INTO yom_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mu thangu kaba kubasakumuna, wuvambana yawu ayi wutombulu mu diyilu. ");
INSERT INTO yom_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bawu buna bamana kunsambila, mu khini bavutukila ku Yelusalemi. ");
INSERT INTO yom_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Thangu ka thangu bavuanda kuawu mu nzo Nzambi mu diambu di zitisanga ayi kembisanga Nzambi.");
INSERT INTO yom_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Va thonono, Diambu dikibela, Diambu diba va kimosi ayi Nzambi ayi Diambu diawu Nzambi. ");
INSERT INTO yom_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Diambu diba va thonono va kimosi ayi Nzambi. ");
INSERT INTO yom_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Bima bioso bivangimina mu diawu, kuisi ko kima kikambu vangu mu kambu diawu mu bibioso bikivangulu. ");
INSERT INTO yom_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mu diawu muba Luzingu. Luzingu beni luba kiezila ki batu. ");
INSERT INTO yom_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kiezila kilembo kienzuka mu tombi vayi tombi kisia kisudika ko. ");
INSERT INTO yom_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Vaba Mutu wumosi wutumu kuidi Nzambi, dizina diandi Yowani. ");
INSERT INTO yom_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wuyiza mu telama kimbangi ; mu telama kimbangi mu diambu di kiezila muingi batu boso bawilukila mu niandi. ");
INSERT INTO yom_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Niandi veka kasia ba kiezila ko, vayi, niandi wuyiza kaka mu telama kimbangi mu diambu di kiezila. ");
INSERT INTO yom_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kiezila ki kiedika kiawu kioki kiyiza va ntoto, kioki kieti kienzulanga batu boso. ");
INSERT INTO yom_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Niandi diambu diyiza va ntoto ayi ntoto wuvangu mu niandi vayi ntoto wusia kunzaba ko. ");
INSERT INTO yom_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Niandi wuyiza ku tsiꞌandi vayi basi tsiꞌandi basia kuntambula ko. ");
INSERT INTO yom_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Vayi kuidi batu boso bantambula, niandi wuba vana lulendo lukitukila bana ba Nzambi ; bobo bawilukila mu dizina diandi. ");
INSERT INTO yom_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bika sia ti bana beni mu menga voti mu luzolo lu nsuni babutukila, voti mu luzolo lu mutu vayi babutu mu luzolo lu Nzambi. ");
INSERT INTO yom_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Diambu dikituka nsuni ayi diyiza zinga va khatitsikꞌeto. Beto tumona nkembo andi ; banga nkembo wu Muana wumosi kaka wowo wuba kuidi Tata. Nkembo beni wuba wuwala mu nlemvo ayi mu kiedika. ");
INSERT INTO yom_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yowani wuntelimina kimbangi bu katuba mu yamikina : —Talanu mutu wawu, niandi ndiyolukila mu thangu ndilukamba : mutu wowo wunkuiza ku manima mama wundutidi munneni, bila niandi wutuama kukibela ayi minu. ");
INSERT INTO yom_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mu diambu di fuluka ku nlemvo andi, beto boso tutambula lusakumunu va mbata lusakumunu. ");
INSERT INTO yom_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bila Moyize niandi wuvana Mina vayi Yesu Klisto niandi wunata nlemvo ayi kiedika. ");
INSERT INTO yom_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kadi mutu kamuenieti Nzambi ko vayi Muanꞌandi wumosi kaka widi va ndambu yi Tata, niandi wunzabikisidi. ");
INSERT INTO yom_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Vava vadi kimbangi ki Yowani mu thangu Bayuda baba ku Yelusalemi bafidisa zinganga Nzambi ayi Balevi muingi banyuvula : “ngeyo widi nani e ?” ");
INSERT INTO yom_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Buna wuba kamba kiedika mu kambu memata : —Minu ndisi ama Klisto ko. ");
INSERT INTO yom_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Babuela kunyuvula : —Vayi buna widi nani e ? Widi Eli ? Wuba vutudila : —Ndisi ama Eli ko ! Bawu babuela kunyuvula : —Widi mbikudi e ? Wuba vutudila : —Nana. ");
INSERT INTO yom_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bu