﻿USE sofia;
DROP TABLE IF EXISTS sofia.yns_vpl;
CREATE TABLE yns_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yns_vpl WRITE;
INSERT INTO yns_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Un'kaan a un'lwaaŋ a Yɛsu Klistɔ, itoo a David, itoo a Abàlam. ");
INSERT INTO yns_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abàlam kàbör Isak, Isak kàbör Yakɔb, Yakɔb kàbör Yudà anà atɔŋ ande, ");
INSERT INTO yns_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudà kàbör Falesi anà Zalà, ikɔb a ngwän aba Tamar, Falesi kàbör Isilɔn, Isilɔn kàbör Alam, ");
INSERT INTO yns_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alam kàbör Aminadab, Aminadab kàbör Naasɔn, Naasɔn kàbör Salmɔn, ");
INSERT INTO yns_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔn kàbör Bɔɔzi, Rayab kàkäl ngwän ande, Bɔɔzi kàbör Yɔbɛd, Luti kàkäl ngwän ande, Yɔbɛd kàbör Yɛsɛ, ");
INSERT INTO yns_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yɛsɛ kàbör mfum David. David kàbör Salàmun, ngwän ande kàkäl un'kyay a Uli. ");
INSERT INTO yns_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salɔmun kàbör Rɔbɔwam, Rɔbɔwam kàbör Abya, Abya kàbör Asa, ");
INSERT INTO yns_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kàbör Yɔsafat, Yɔsafat kàbör Yɔlam, Yɔlam kàbör Ɔsya, ");
INSERT INTO yns_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ɔsya kàbör Yɔwatam, Yɔwatam kàbör Akazi, Akazi kàbör Isikyä, ");
INSERT INTO yns_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Isikyä kàbör Mànasi, Mànasi kàbör Amɔn, Amɔn kàbör Yɔsyä, ");
INSERT INTO yns_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yɔsyä kàbör Yɛkɔnya anà atɔŋ ande, u paŋà bàsɔ̈ɔ̈l baan a Isàlɛl nsi u Babilɔn. ");
INSERT INTO yns_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ungö a nsɔ̈ɔ̈l a nsi, Yɛkɔnya kàbör Salàtyɛl, Salàtyɛl kàbör Zɔrɔbabɛl, ");
INSERT INTO yns_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zɔrɔbabɛl kàbör Abyudi, Abyudi kàbör Ɛlyakim, Ɛlyakim kàbör Azɔr, ");
INSERT INTO yns_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔr kàbör Sadɔki, Sadɔki kàbör Akim, Akim kàbör Ɛlyudi, ");
INSERT INTO yns_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɛlyudi kàbör Ɛlyazar, Ɛlyazar kàbör Matan, Matan kàbör Yakɔb, ");
INSERT INTO yns_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakɔb kàbör Yɔsɛfi, un'dim a Màlye awà kàbör Yɛsu awà bàfàbel naa Klistɔ. ");
INSERT INTO yns_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abun, yanswà yàkäl ngyääl kwem aŋinà fà Abàlam mukàman David, yàfàlyaŋ sye ngyääl kwem aŋinà fà David tii u paŋà alà bàsɔ̈ɔ̈l baan a Isàlɛl nsi u Babilɔn, ngyääl kwem aŋinà sye yàfàlyaŋ fà nsɔ̈ɔ̈l a nsi u Babilɔn tii u paŋà alà bàbör Klistɔ. ");
INSERT INTO yns_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Le, mböör a Yɛsu Klistɔ yàkäl abà: Ngwän ande Màlye kàkäl un'kaar kàtɛ Yɔsefi ntüüm, wɛɛ kusà ba mutàtüüb ndür, nde kàmɛnà anà yöm unsà ngwal a Dweelà In'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Wɛɛ un'dim ande Yɔsɛfi, ntɔn kàkäl nde mbuur a balàbal, nde kàkwen anki mukun'mɛɛy nswɛn u mii a baar, lalan kàwɛl nde an'kyän u mpem ande mukun'wɛy kà unku. ");
INSERT INTO yns_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","U taaŋ kàyweerà nde abà, un'kyeey a Mwol mwɛy kàyàmɛnà akà nde u ndwɛy, waa kàtɛn a nde naa: « Yɔsefi, mwan a David, twon an'man bɔɔmà muwal un'kyay angye Màlye, ntɔn yöm alà kan'bäl ande lan'fà akà Dweelà In'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Undiir awun, nde ayàbɔr mwan baal, ngye ayun'pà ikɔb a Yɛsu, ntɔn nde asàtswà mɔ̈ɔ̈ a un'sɛŋ ande unsà man'be a wa. » ");
INSERT INTO yns_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ndaa ayi yanswà yà ntɔn undiir kàtɛn Mwol u mun a ŋangɔɔm ande ukwe: ");
INSERT INTO yns_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","« Le, mwan un'kaar unkɔr asàkal yöm, nde asàbɔr mwan baal, bàsun'beelà Mànwel », iswaŋà naa « Nzam wà uboo a bi ». ");
INSERT INTO yns_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mpal kàwiyà nde u twaal, Yɔsefi kàkyer ndaa kun'swɛŋ un'kyeey a Mwol, waa nde kàsi un'kyay ande u ndwà. ");
INSERT INTO yns_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wɛɛ nde kàtüüb anki ndür anà nde tii mpal kàbör nde mwan baal awà kàpɛ nde ikɔb a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yɛsu bun'bör u Bɛtelɛm a Yuday, umpal kàkäl Ɛlɔdi mfum. Ungö a mböör ande, baar bàfàleŋ muyöb nku a mbwaar bàfü mper làfàsɛnà taaŋ, ba bàyi u Yɛlusàlɛm, ");
INSERT INTO yns_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","waa bàfuul naa: « Wà ken Mfum a Ayudà ban'bɔr benàben awà? Bi kàmɛn mbwaar ande mper làfàsɛnà taaŋ, lalan kan'yà bi mukun'kömà. » ");
INSERT INTO yns_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mpal kàwem mfum Ɛlɔdi làsaŋ alà, nde kàkyer atɛɛr, anà Yɛlusàlɛm lanswà mbwo mwɛy anà nde. ");
INSERT INTO yns_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nde kàtüüb andwer angaŋ anà alɔɔŋ a Un'kɔɔn, ntɔn mukafuul naa Klistɔ bàlun'bɔr ken. ");
INSERT INTO yns_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ba bun'fuur naa: « U Bɛtelɛm a Yuday. Ntɔn ŋangɔɔm kàsön abà: ");
INSERT INTO yns_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","« Le, ngye Bɛtelɛm, u nsi a Yuday, ngye kà awà bul làkɔ̈ɔ̈n ndöŋ anki u Yuday, ntɔn mfum asàdii un'sɛŋ amɛ Isàlɛl, asàtoo uboo a ngye. » ");
INSERT INTO yns_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Apan, Ɛlɔdi kàbel aŋan'yeerà kà unku, ntɔn ba bun'kyään ubwaŋàbwaŋ taaŋ nà mbwaar kàmɛnà. ");
INSERT INTO yns_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Apan, nde katöm Bɛtelɛm, waa kàtɛn naa: « Làkyen, kàlafuul ubwaŋàbwaŋ ntɔn mwan awà, bɛ làsun'man, yàlan'kyään, ntɔn mɛ sye in'kyen mukun'kömà. » ");
INSERT INTO yns_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ungö bàwem ba ndaa kàtɛn mfum Ɛlɔdi, ba waa bàkyen, waa bàfàman mbwaar awà bàtàman ba umper làfàsɛnà taaŋ: mbwaar wa kàyikyeenà kusà a ba tii kàkàmbar wa udu a ikal kàkäl mwan. ");
INSERT INTO yns_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Umpal bun'tääl ba, ba bàmɛn un'sak mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mpal bàbilà ba u ndwà, ba bàmɛn mwan anà ngwän ande Màlye, waa bun'kömà. Apan, ba bàduub an'bɔ̈ɔ̈n aba, waa bun'pɛ an'kab mà: wɔl, tswà anà may a usɔŋ. ");
INSERT INTO yns_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ungö apan, Nzam kakyään u ndwɛy naa ba bàkɔɔn afurà akà Ɛlɔdi, ba waa bàfurà nsi aba u mbwo asin. ");
INSERT INTO yns_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ungö a nkyeen aba, un'kyeey a Mwol mwɛy kàyàmɛnà akà Yɔsefi u ndwɛy, waa kun'kyään naa: « Mbarà, un'sɛn mwan anà ngwän, katiin u Ngipiti. Kal kwo tii umpal in'saswaŋ mɛ mufurà. Ntɔn Ɛlɔdi ayàleŋ mudwa mwan. » ");
INSERT INTO yns_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Undiir awun, Yɔsefi kàmbarà nde u mpib, kàsɛn nde mwan anà ngwän ande, waa kàkàyee u Ngipiti. ");
INSERT INTO yns_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nde kàbwaay kwo tii u nkweel a Ɛlɔdi, ntɔn undiir kàtɛn Mwol wà u mbwo a ŋangɔɔm ukwe: « Mɛ kàbel mwan amɛ mutoo u Ngipiti. » ");
INSERT INTO yns_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mpal kàyöb Ɛlɔdi naa baar bàfàleŋ muyöb nku a mbwaar bàkyer un'kur, nde kàwem nkyɛl mbɔɔn, waa kàswɛŋ naa bàdwä baan abaal a mbul yweel tii u ngyɛl u Bɛtelɛm anà u nsi ande yanswà, mulab paŋà bun'kyään aŋan'yeerà. ");
INSERT INTO yns_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Abun, undiir kàtɛn ŋangɔɔm Yɛlɛmya wà kàkyer akwo: ");
INSERT INTO yns_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","« Bàwem ndaa mwɛy u Lamà, ilel anà in'tär mbɔɔn. Wawɛy Lakɛl wàmulel baan ande, nde ukwen anki naa mbuur kun'syääm, ntɔn ba bàfàkal anki. » ");
INSERT INTO yns_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ungö a nkweel a Ɛlɔdi, un'kyeey a Mwol mwɛy kàkàmɛnà u ndwɛy akà Yɔsefi u Ngipiti, ");
INSERT INTO yns_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","waa kàtɛn a nde naa: « Mbarà, un'sɛn mwan anà ngwän, furà u mɛɛn a Isàlɛl, ntɔn baar akwà bàkwen mudwa mwan ban'kwà. » ");
INSERT INTO yns_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Undiir awun, Yɔsefi kàmbarà nde, kàwɛl nde mwan anà ngwän, waa kàfurà u mɛɛn a Isàlɛl. ");
INSERT INTO yns_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wɛɛ utaaŋ kàwem nde naa Alakɛlawüs kàsàkiir taarànde Ɛlɔdi u kir a imfum u Yuday, nde kàwem bɔɔmà mufurà kwo. Nzam kun'weey u ndwɛy, laa kàkàyee nde u mɛɛn a Ngalilɛ. ");
INSERT INTO yns_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nde kàkàtɔŋ u bul làmwɛy bàfàbel naa Nasàlɛr, ntɔn ndaa bàtɛn aŋangɔɔm ibü balàbal: « Nde bàsun'beelà un'nazɔrya. » ");
INSERT INTO yns_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Utaaŋ alan, Ywan Un'düümà kàyàmɛnà u nsye a ipɔl a Yuday mulɔŋ naa: ");
INSERT INTO yns_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","« Làbuul mpem abɛ, ntɔn Imwol a du kye tsütsü! » ");
INSERT INTO yns_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ywan awà wà mbuur kàsam ŋangɔɔm Yɛsay utaaŋ kàtɛɛnà nde naa: « Ndaa mwɛy yàmusaa in'kwɛŋ u nsye a ipɔl: Làlɔ̈ɔ̈n mbwo a Mwol, làsuub myay ande! » ");
INSERT INTO yns_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ywan kàbwäärà ipfɛy a in'kà a Kamɛl anà un'kab a ibaan a ntsür u lɔŋ ande. Nde kàdyee mpay anà bwey a ndwaŋ. ");
INSERT INTO yns_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abun Yɛlusàlɛm, Yuday lanswà, anà un'tà a Yɔrdan bàkyeenà akà nde. ");
INSERT INTO yns_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ba bàkyeyà man'be aba u mii a baar anà Ywan kadümà u Yɔrdan. ");
INSERT INTO yns_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mpal kàmɛn nde naa Amfarisi anà Asadusi mbɔɔn bàyee akà nde ntɔn muwal ndüümà, nde kàtɛn a ba naa: « Mbil a iyäy! Nà kàlalɔŋ mutiin nkyɛl a Nzam ayà iyà? ");
INSERT INTO yns_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Làswɛŋ unsà nsyääl abɛ naa bɛ lan'buul mpem, ");
INSERT INTO yns_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","anà twon lan'tɛn u mpem abɛ naa: \"Abàlam wà nkaa abi!\" Ntɔn mɛ alakyään naa Nzam kan'kwo mutwey ikyee a Abàlam u nkɔŋ yi! ");
INSERT INTO yns_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Fà itaan nkwar yà tsütsü mutsul in'te kun'swɛy: un'te wanswà mpa afàbɔr imbɛŋ aŋàbwaŋ, bàkyer asun'tsul, waa bàsun'tɔɔm u mbaa. ");
INSERT INTO yns_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","« Mɛ, mɛ in'kàladümà kan'dà ntɔn mbuul a mpem. Wɛɛ mbuur awà ayà ungö a mɛ kàman'lyaŋ u ngwal: mɛ in'kwe anki musɔɔl idyäär ande. Nde, nde asàladümà u Dweelà In'kyɛɛl anà u mbaa. ");
INSERT INTO yns_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nde we anà impye u kɔɔ ande ntɔn mukɔɔm blɛ. Nde asàsà imbɛŋ uboo a ikɔr, wɛɛ un'lɛŋ nde asàtɔɔm u mbaa mpa isàdim akà ikikye. » ");
INSERT INTO yns_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Abun, Yɛsu kàfü Ngalilɛ, waa kàyàkɔlà u Yɔrdan akà Ywan Un'düümà u ngyäl a Yɔrdan, ntɔn nde kun'dümà. ");
INSERT INTO yns_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wɛɛ Ywan kàmɛn ube, waa kàtɛn a nde naa: « Mɛ, mɛ in'làkwo muyà akà ngye, ntɔn ngye an'pɛ ndüümà, wɛɛ ngye, ngye afàyà akà mɛ! » ");
INSERT INTO yns_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wɛɛ Yɛsu kun'fuur naa: « Wɛy ya ikäl abà apanà, ntɔn yà ubwaŋ naa bi ikwey balàbal lanswà. » Abun, Ywan waa kàkyey. ");
INSERT INTO yns_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pa kàwɛl nde ndüümà, Yɛsu laa kàtoo nde kan'dà. Taaŋ nsil la du waa làyaanà, nde kàmɛn Dweelà a Nzam wàmuyàtyà akà nde asànaa nkokà. ");
INSERT INTO yns_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Le, ndaa mwɛy yàfü du, waa yàtɛn naa: « Wawà wà Mwan amɛ wà nkween. Mpem amɛ yanswà ye amu nde. » ");
INSERT INTO yns_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ungö apan, Dweelà a Nzam kàsyen Yɛsu u nsye a ipɔl ntɔn ileŋ kyun'lwɛb. ");
INSERT INTO yns_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ungö mukin udyà myäänà an'kwem an'nà anà mpib an'kwem an'nà, ngyal waa yun'käär. ");
INSERT INTO yns_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Un'lwɛɛb kàyàsin tsütsü, waa kàtɛn a nde naa: « Kya ngye asàkal Mwan a Nzam, swaŋ nkɔŋ yi ibulà mampà. » ");
INSERT INTO yns_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wɛɛ Yɛsu kàfuur naa: « Bàsön naa: \"Kà nà mampà mpɛl anki màfàpà mbuur mɔ̈ɔ̈, wɛɛ ndaa yanswà ifàtoo u mun a Nzam\". » ");
INSERT INTO yns_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Apan, ileŋ kyun'syen u bul in'kyɛɛl, laa kun'si nde udu a ndwà a Nzam, ");
INSERT INTO yns_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","waa kàtɛn a nde naa: « Kya isàkal naa ngye awà Mwan a Nzam, tɔɔmà unsi, ntɔn bàsön naa: \"Nde asàswaŋ akyeey ande ntɔn ngye, waa ba bàsawal kan'kɔɔ aba ntɔn làkɔl angye làkɔɔn aböl u nkɔŋ mwɛy\". » ");
INSERT INTO yns_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yɛsu kàtɛn a nde naa: « Bàsön sye naa: \"Ngye asun'lwab anki Mwol, Nzam angye\". » ");
INSERT INTO yns_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ileŋ kàfun'syen udu a mɔŋ a bwɛlàbwɛl, waa kun'mɛɛy imfum a mɛɛn byanswà anà làkoo abya, ");
INSERT INTO yns_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","waa kàtɛn a nde naa: « Mɛ in'sapà indiir bi byanswà, isàkal naa ngye aman'kömà anà aman'sà làkoo. » ");
INSERT INTO yns_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Abun Yɛsu waa kàtɛn a nde naa: « Satanà, kyà kunà! Ntɔn bàsön naa: \"Ngye asàkömà Mwol Nzam angye anà ngye asàsyääl nde mpɛl\". » ");
INSERT INTO yns_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Abun, ileŋ waa kàsun'wɛy. Apan sye, akyeey bàyàsin tsütsü apà Yɛsu, waa bun'syäälà. ");
INSERT INTO yns_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mpal kàwem nde naa Ywan Un'düümà kan'bilà bɔlokà, Yɛsu kàkyen Ngalilɛ. ");
INSERT INTO yns_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ungö kàlwomà nde u Nasàlɛr, nde kàkyen Kapɛrnawum kun'kɔɔl a ɛwà, kà itiir a nsi a Zabulɔn anà Nɛftali, ");
INSERT INTO yns_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ntɔn ndaa kàkyään ŋangɔɔm Yɛsay yi ikwe: ");
INSERT INTO yns_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","« Mɛɛn a Zabulɔn, mɛɛn a Nɛftali, mbwo a ngyäl a kölàköl, nsi ayà u sim a Yɔrdan lumwɛy, u Ngalilɛ a baar mpa abà Ayudà! ");
INSERT INTO yns_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Un'sɛŋ kàkäl uboo a làpib kàkyàman pɛɛlà a kölàköl! Baar abà bàkäl u nsi a làpib a ukwà, pɛɛlà làmwɛy làkölàköl làkyàmɛnà! » ");
INSERT INTO yns_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Fà umpal ayin, Yɛsu laa kàsɛmà nde mukyään naa: « Làbuul mpem abɛ: Imwol a du kyan'yàsin tsütsü! » ");
INSERT INTO yns_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mpal kàkäl nde muyikyà kun'kɔɔl a ɛwà a Ngalilɛ, nde kàmɛn atɔŋ abɔ̈ɔ̈l, Simɔn bàfàbel Petɔlà anà un'tɔŋ ande Andrɛ, bàmuyitɔɔm an'tɛy u ngyäl, ntɔn ba bàkäl alɔ̈ɔ̈b a nsö. ");
INSERT INTO yns_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yɛsu kàtɛn a ba naa: « Yà lan'läb, waa mɛ in'yàlabuul alɔ̈ɔ̈b a baar. » ");
INSERT INTO yns_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Apan sye, ba bàsàwɛy an'tɛy, waa bun'läb. ");
INSERT INTO yns_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mpal kàfàsin nde kusà, nde kàmɛn atɔŋ abɔ̈ɔ̈l asin, Zyak anà Ywan, baan a Zɛbeday. Ba bàkäl uboo a bwaar aba anà taaràba Zɛbeday bàmulɔɔnà an'tɛy aba. Yɛsu waa kabel. ");
INSERT INTO yns_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Apan sye, ba bàsàwɛy bwaar anà taaràba, waa bun'läb. ");
INSERT INTO yns_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ungö apan, nde kàyilyaŋà u Ngalilɛ wanswà, waa kàyilɔɔŋà uboo a ndwà a nköŋ aba, muyikyään Làsaŋ Aŋàbwaŋ là Imwol anà muyikɔɔr ukyäl banswà anà too lanswà uboo a un'sɛŋ. ");
INSERT INTO yns_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Làsaŋ ande làpää u Siri lanswà, waa bun'twäälà abɛy bàkäl anà an'kyal mà ifà ifà: an'dweelà an'be, akweel a nkaaŋ anà ikar, waa kakɔɔr ba banswà. ");
INSERT INTO yns_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iköŋ a baar mbɔɔn bàfü Ngalilɛ, anà itiir a An'bul Kwem, anà Yɛlusàlɛm, Yuday anà sim a Yɔrdan waa bàyun'labà. ");
INSERT INTO yns_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mpal kàmɛn Yɛsu iköŋ a baar, nde kàbeenà udu a mɔŋ, waa kàbwaay. Alɔŋki ande bàsin apà nde, ");
INSERT INTO yns_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nde waa kàsɛmà mukalɔŋ abà: ");
INSERT INTO yns_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","« Un'sak akà baar abye anà mpem a làbɔ̈ɔ̈n, ntɔn Imwol a du kye anà ba! ");
INSERT INTO yns_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Un'sak akà baar bàlelà, ntɔn bàkyer asalɛɛl! ");
INSERT INTO yns_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Un'sak akà baar a làbɔ̈ɔ̈n, ntɔn mɛɛn mà isàkal kwal aba! ");
INSERT INTO yns_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Un'sak akà baar abye anà ngyal anà mfwää a balàbal, ntɔn ba bàkyer asàyuur! ");
INSERT INTO yns_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Un'sak akà aŋangyɛb, ntɔn bàkyer asasyääm! ");
INSERT INTO yns_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Un'sak akà baar abye anà mpem a pɛɛl, ntɔn ba bàsàman Nzam! ");
INSERT INTO yns_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Un'sak akà baar bàfàsà duu, ntɔn bàsabel baan a Nzam! ");
INSERT INTO yns_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Un'sak akà baar bàŋàmɛɛy nkwaaŋ ntɔn balàbal, ntɔn imwol a du isàkal kyà ba! ");
INSERT INTO yns_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Un'sak we anà bɛ isàkal naa bàmàlato, bàmàlamɛɛy nkwaaŋ anà bàmàlaküür ndaa ntɔn mɛ. ");
INSERT INTO yns_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Làsäŋ, làkäl kun'sak, ntɔn bweel a kölàköl làmukàladilà u du. Abun sye bàmɛɛy ba nkwaaŋ akà aŋangɔɔm bàkäl kusà abɛ. » ");
INSERT INTO yns_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nde kàfàtɛn naa: « Bɛ, bɛ làbà muŋ a mɛɛn. Isàkal naa ntsà a muŋ yan'wà, ya bàsàfuur a nkye? Ndöŋ a wa yan'wà, wa bàpiy u nsà, baar waa bàndyäär wa. » ");
INSERT INTO yns_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","« Bɛ, bɛ làbà pɛɛlà uboo a baar. Bul bàtöŋ u du a mɔŋ làfàkal anki làŋàyee. ");
INSERT INTO yns_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bàfàkyä anki mwinà ntɔn musà u ngyɛl a kantin. Wɛɛ wa bàfàsà udu a ikɔlà bàfàtɔl mwinà ntɔn wa upɛ kyɛɛy akà baar banswà abà uboo a ndwà. ");
INSERT INTO yns_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Abun sye, wɛy pɛɛlà abɛ làŋyɛŋ u mii a baar, mpal bàman ba nsyääl abɛ yàŋàbwaŋ, ba bàsà Taaràbɛ awà u du làkoo. » ");
INSERT INTO yns_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","« Twon lan'si naa mɛ kàyi ntɔn mulwom Un'kɔɔn itàkal Aŋangɔɔm. Mɛ kàyii anki muyàlwom mya, wɛɛ ntɔn mukwey wa. ");
INSERT INTO yns_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mɛ, mɛ amàlakyään ndandaa naa, kusà du anà mɛɛn mulyaŋ, akà i mwɛy, akà un'tswe a i mwɛy usàlwomà anki unsà Un'kɔɔn tii mpal isàkwo indiir abi byanswà. ");
INSERT INTO yns_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Undiir awun, mbuur asàbɛy, itàkal kinswɛɛŋ mwɛy uboo a in'kɔɔn ami myanswà anà asàlɔŋ baar mukyer abà, nde asàkal kimbuur uboo a Imwol a du. Wɛɛ mbuur asàsyääl mya anà asàlɔŋ mya akà baar bumwɛy, nde asàkal mbuur a kölàköl uboo a Imwol a du. ");
INSERT INTO yns_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mɛ, mɛ alakyään naa: isàkal naa balàbal abɛ làlyaŋ anki balàbal a alɔɔŋ a in'kɔɔn anà Amfarisi, bɛ, bɛ taaŋ asàbilà uboo a Imwol a du latɛy. » ");
INSERT INTO yns_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","« Bɛ làkyàwem, bàtɛn a bànkaa naa: \"Ngye mbuur asàdwa anki. Mbuur asàdwa mbuur, bàsun'sà u làbay a nsaŋ.\" ");
INSERT INTO yns_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Waa mɛ, mɛ alakyään naa: mbuur wanswà awà kan'wem un'tɔŋ ande nkyɛl, bun'sà u làbay a nsaŋ. Mbuur usàtɛn a un'tɔŋ ande naa: \"Ntsür a mbuur!\", nde bun'sà u Làbay a nsaŋ a kölàköl. Mbuur usàtɛn a nde naa: \"Insil\", nde bun'tɔɔm u yaaŋ a mbaa. ");
INSERT INTO yns_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Abun, isàkal naa ngye an'kàpà ibɔɔn u mɛsà a ibɔɔn, wɛɛ apan ngye asàyɔbà naa un'tɔŋ angye we anà nkyɛl anà ngye, ");
INSERT INTO yns_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sàwɛy ibɔɔn angye paa kusà a mɛsà a ibɔɔn, kyen katàkàlɔ̈ɔ̈n anà un'tɔŋ angye, ungö apan, yafurà mupà ibɔɔn angye. ");
INSERT INTO yns_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Lɔɔn agyä anà ŋankir angye, u taaŋ awà ngye u mbwo anà nde, naa tɛy, ŋankir angye awà kapà kan'kɔɔ a ntɛɛn, ntɛɛn kan'kɔɔ a pulusi anà nde katɔɔm u bɔlokà. ");
INSERT INTO yns_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mɛ, mɛ akyään ndandaa naa: ngye asàtoo anki kwo isàkal naa ngye ŋàtàfur anki tii u làdiim làntsüü. » ");
INSERT INTO yns_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","« Bɛ, bɛ làkyàwem bàtɛn naa: \"Ngye asàtà anki inswem.\" ");
INSERT INTO yns_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mɛ, mɛ alàkyään naa: mbuur wanswà kan'ler un'kaar anà an'kyän an'be, nde kan'furàtà inswem anà nde u mpem ande. ");
INSERT INTO yns_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Isàkal naa dii angye libaal làkwen mukabwiy, kwol la, piy la ukwɛl: ntɔn yà ubwaŋ akà ngye naa itiir a ndür angye mwɛy ikɔ̈ɔ̈n, akwà naa bàtɔɔm ndür angye yanswà u mbaa a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Wɛɛ isàkal naa kɔɔ angye libaal làkwen mukabwiy, tsul la, piy la ukwɛl: ntɔn yà ubwaŋ naa ngye akɔ̈ɔ̈n itiir a ndür angye, akwà naa ndür angye yanswà ikyen u mbaa a mbul a in'tye. » ");
INSERT INTO yns_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","« Bàtɛn sye naa: \"Isàkal naa mbuur kan'böŋ un'kyay ande, wɛy nde kun'pɛ un'kaan a ndwääl a bɔr\". ");
INSERT INTO yns_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Waa mɛ, mɛ alakyään naa: Yan'kwo bàböŋ un'kaar kan'tà inswem mpɛl. Mbuur wanswà kan'böŋ un'kyay ande mpa kàtɛ nde inswem, nde kàmusiinà mutà inswem. Mbuur usàbääl un'kaar ban'böŋ u bɔr, nde kan'tà inswem. » ");
INSERT INTO yns_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","« Bɛ làkyàwem sye naa bàtɛn a bànkaa abi naa: \"Twon an'sàbɛy kyän angye, wɛɛ ngye asàkwey kyän angye kusà a Mwol.\" ");
INSERT INTO yns_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Waa mɛ, mɛ alàkyään naa twon lan'dyà kyän akà ikikye: itàkal naa u du, ntɔn du là kir a imwol a Nzam, ");
INSERT INTO yns_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","itàkal naa u mɛɛn, ntɔn mɛɛn mà ikal ufàtɔl nde in'kɔl ande, itàkal naa u Yɛlusàlɛm, ntɔn la là bul a Mfum a kölàköl. ");
INSERT INTO yns_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Twon an'dyà sye kyän kun'tswe angye, ntɔn ngye akwe anki mubuul làtswe a un'tswe angye làpɛɛl, itàkal làpiil. ");
INSERT INTO yns_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wɛy naa ɛ angye làkäl \"ɛ\", itàkal naa ŋaa angye ukäl \"ŋaa\": ayà bàfàkwɛy udu pa ifàfà akà Un'be. » ");
INSERT INTO yns_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","« Bɛ làkyàwem ayà bàtɛn naa: \"Dii ntɔn dii, anà din ntɔn din.\" ");
INSERT INTO yns_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Waa mɛ, mɛ alàkyään naa twon lan'sà impeenà akà mbuur un'be. Isàkal naa mbuur kàmakam mbar u twam a ibaal, fun'lɛɛ sye lumwɛy. ");
INSERT INTO yns_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Akà mbuur akwen mukasyen u làbay a nsaŋ ntɔn mugyɔɔr inkur angye, un'wɛy alà sye kàzak angye. ");
INSERT INTO yns_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Isàkal naa mbuur amasiinà a ngwal mukyer kilɔmɛtre imwɛy, kyer an'kilɔmɛtre mɔ̈ɔ̈l mbwo mwɛy anà nde. ");
INSERT INTO yns_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pà akà mbuur kàmalɔ̈ɔ̈m. Twon an'pà ngö akà mbuur akwen musɔɔm akà ngye. » ");
INSERT INTO yns_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","« Bɛ làkyàwem ayà bàtɛn naa: \"Ngye asàkwen un'tɔŋ angye anà ngye asàtɔn ŋankir angye.\" ");
INSERT INTO yns_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wɛɛ mɛ, mɛ in'tɛn a bɛ naa: Lakwen aŋankir abɛ, làsaak baar bàfàlaküül, làkyer ubwaŋ akà baar bàfàlayiiŋ, anà làyamà ntɔn baar bàfàlatà an'kaal anà bàfàlamɛɛy nkwaaŋ. ");
INSERT INTO yns_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Abun bɛ làsàbulà baan a Taaràbɛ awà u du. Ntɔn nde afàbaal mwäänà ande udu a baar abe anà udu a baar aŋàbwaŋ, anà afàtɔ̈ɔ̈l mbul udu baar a balàbal anà udu a baar mpa abà balàbal. ");
INSERT INTO yns_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kya isàkal naa bɛ, bɛ làfàkwen nà baar bàfàlakwen, bweel nà bɛ làsàwal? Nkye afüür a itɛr ba ŋakwo kà bàfàkyer anki abà? ");
INSERT INTO yns_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kya isàkal naa bɛ, bɛ mbɔr làfàpà nà atɔŋ abɛ mpɛl, undiir nà wà nsöön làfàkyer bɛ? Nkye baar mpa abà Ayudà sye bàfàkyer anki abun? ");
INSERT INTO yns_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Undiir awun, làkäl bàlää asànaa Taaràbɛ awà u du awà nde wàlää. » ");
INSERT INTO yns_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","« Twon lan'kyer balàbal abɛ u mii a baar, ntɔn ba bàlamɛn. Naa tɛy, bɛ bweel làsàwal anki akà Taaràbɛ awà u du. ");
INSERT INTO yns_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Twon an'bɛɛr mfuŋ u mii a baar isàkal naa ngye akwen mupà undiir akà ŋàlàmbwà, asànaa bàfàkyer baar a mpem yweel uboo a ndwà a nköŋ a Ayudà anà uboo a an'balàbal ntɔn baar basyäŋà. Ndandaa mɛ alakyään, ba bàkyàwal bweel aba itaan. ");
INSERT INTO yns_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wɛɛ akà ngye, mpal apà ngye undiir akà ŋàlàmbwà, wɛy kɔɔ angye likaar làkɔɔn ayöb ndaa làkyerà kɔɔ angye libaal. ");
INSERT INTO yns_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Abun, wɛy kab angye làkäl aŋàyee, waa Taaràŋà awà afàman u nku, usafuur la. » ");
INSERT INTO yns_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","« Mpal làyamà bɛ, twon lan'kal asànaa baar a mpem yweel: ba bàfàkwen muyamà umbäär uboo a ndwà a nköŋ a Ayudà anà kan'kuun a mbwo ntɔn baar banswà bamɛn. Mɛ alàkyään ndandaa: ba bàkyàwal bweel aba itaan. ");
INSERT INTO yns_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wɛɛ akà ngye, isàkal naa ngye akwen muyamà, bilà u suk angye alà ukwɛl, dübà ibeenà anà sà un'kaŋ a boo, yamà Taaràŋà awà kwo kà ikal a ngyee. Waa Taaràŋà awà afàman u nku, usafuur ya. » ");
INSERT INTO yns_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","« Mpal làyamà bɛ, twon lan'tɛn itetɛɛn, asànaa baar mpa abà Ayudà: ba bàfàsi naa ba bàsàtɛn mbɔɔn ba bàsàwal nsaak. ");
INSERT INTO yns_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Abun, twon làmalab, ntɔn Taaràbɛ akyàyöb naa undiir nà bɛ làbye awà ngyal kusà bɛ mukun'lɔ̈ɔ̈m. ");
INSERT INTO yns_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Le bɛ, bɛ làyamà abà: \"Taaràbi awà u du, wɛy ikɔb angye ikäl kyà in'kyɛɛl, ");
INSERT INTO yns_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","wɛy Imwol angye iyi, wɛy ukwen angye bàmɛnà u mɛɛn asànaa abà ba u du. ");
INSERT INTO yns_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ipɛ ŋàbawà isaa byan'kwo akà bi. ");
INSERT INTO yns_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Idwääl un'pi a nkul a man'be abi, asànaa bi ŋakwo sye ifàdwääl bi un'pi a nkul a baar bà ikyer ube. ");
INSERT INTO yns_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Twon an'pà mbwo naa bà ilwɛb, anà ilwom kan'kɔɔ a Ŋandɛb.  Ntɔn imwol, ngwal anà làkoo bye anà ngye. Yà abwɛy\"  » ");
INSERT INTO yns_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","« Undiir awun, bɛ làsàdwääl baar bumwɛy nkul a ibii aba, Taaràbɛ awà u du asàladwääl nkul abɛ sye. ");
INSERT INTO yns_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wɛɛ isàkal naa bɛ làdwääl anki baar bumwɛy nkul a ibii, Taaràbɛ sye usàladwääl anki nkul a ibii abɛ. » ");
INSERT INTO yns_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","« Mpal làkin bɛ isaa, twon lan'kal ngyɛb ngyɛb asànaa bàfàkyer baar a mpem yweel: ba bàfàsɔɔm ntabwey aba ntɔn baar bamɛn naa ba ban'kin isaa. Wɛɛ mɛ, mɛ alàkyään ndandaa naa ba bàkyàwal bweel aba itaan. ");
INSERT INTO yns_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wɛɛ akà ngye, mpal akin ngye, sir may a usɔŋ kun'tswe angye, ywɛy ntabwey angye ");
INSERT INTO yns_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ntɔn baar bàkɔɔn ayöb naa ngye an'kin udyà, wɛɛ Taaràŋà mpɛl awà u nku. Waa Taaràŋà awà afàyöb ndaa afàkyer ngye u nku, usafuur ya. » ");
INSERT INTO yns_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","« Twon lan'köŋà in'naaŋ abɛ u mɛɛn pà, ikal a in'swab anà an'tär myàfàdwa mya myanswà, ikal bàfàbilà mbüüb ntɔn muyib. ");
INSERT INTO yns_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wɛɛ akà bɛ, làköŋà in'naaŋ u du, ntɔn kwo itàkal nsɛɛl itàkal in'swab myàfàkwo anki mutay mya, ikal mpa bàfàbilà mbüüb anà mpa bàfàyib ba. ");
INSERT INTO yns_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ntɔn ikal awà un'naaŋ angye, mpem angye sye isàkal kwo. » ");
INSERT INTO yns_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","« Dii là mwinà a ndür: isàkal naa dii angye là ubwaŋ, ndür angye yanswà isàkal aŋàpɛɛlà. ");
INSERT INTO yns_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Wɛɛ isàkal naa dii angye lye anà ukyal, ndür angye yanswà isàkal uboo a mpib. Abun, isàkal naa pɛɛlà alà uboo a ngye là mpib, ya yà mpib a nkye ifà! » ");
INSERT INTO yns_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","« Mbuur mwɛy ukwe anki musyääl amfum abɔ̈ɔ̈l: taaŋ lumwɛy nde asàyiiŋ umwɛy anà asàkwen wumwɛy, taaŋ lumwɛy nde asàkàbääb a umwɛy anà asàbɛy wumwɛy. Bɛ, bɛ làkwe anki musyääl Nzam anà ngim taaŋ nsil la. » ");
INSERT INTO yns_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","« Undiir awun waa mɛ alakyään naa twon lan'man mpay ntɔn udii ndür abɛ, itàkal naa bɛ ya làsàbwää aben. Nkye mɔ̈ɔ̈ kà kan'söön isaa anki anà ndür kà yan'söön ipfɛy anki u ndöŋ? ");
INSERT INTO yns_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Làler nɛn a du: ya ifàkɔn anki, ifàbwo anki anà ifàsà anki isaa uboo a ikɔr. Wɛɛ Taaràbɛ awà u du afàkyer adii! Nkye bɛ kà lan'söön ya anki u ndöŋ? ");
INSERT INTO yns_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nà uboo a bɛ kan'kwo mukwɛy ilä udu a mɔ̈ɔ̈ ande ntɔn nkyän ufàsà nde? » ");
INSERT INTO yns_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","« Waa ntɔn nkye làfàsà bɛ nkyän ntɔn ipfɛy? Làler iful a nsye ifàyɛl bya: bya ifàsal anki, bya ipfɛy byàfàtsum anki. ");
INSERT INTO yns_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Wɛɛ mɛ alàkyään naa itàkal Salɔmun unsà làkoo ande lanswà, nde kàsàbwaar anki asànaa bya. ");
INSERT INTO yns_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Isàkal naa Nzam afàbwää abà iteerà a ywaŋ akye anà möö ŋàbawà anà bàyàtɔɔm u mbaa nkàswo, nkye nde usàkyer anki yàŋàsöön akà bɛ, bɛ aŋàlàkwikilà ikikye? ");
INSERT INTO yns_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Twon lan'sà nkyän anà mutɛn naa: \"Ininà bi iyàdyà? ininà bi iyànwà? ininà bi iyàbwaar?\" ");
INSERT INTO yns_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Indiir abi byanswà baar mpa abà Ayudà bàfàleŋ bya taaŋ lanswà. Wɛɛ Taaràbɛ awà u du akyàyöb naa bɛ làbye anà ngyal a bya. ");
INSERT INTO yns_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wɛɛ akà bɛ, bɛ tàlaleŋà imwol anà balàbal a Nzam, waa nde usàlakwɛy indiir abi byanswà. ");
INSERT INTO yns_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Undiir awun, twon lan'sà nkyän ntɔn nkàswo, ntɔn nkàswo akyer asàlɔ̈ɔ̈n nde ŋakwo. Ilä a ilä kye anà ndaa a kya. » ");
INSERT INTO yns_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","« Twon an'tsul nsaŋ, waa ngye sye mpa batsüül nsaŋ. ");
INSERT INTO yns_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ntɔn ngye sye bàsatsüül asànaa afàtsüül ngye baar bumwɛy, ngye sye bàsasi unsà isii afàsi ngye baar bumwɛy. ");
INSERT INTO yns_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ntɔn nkye amanà ngye nà un'lɛŋ awà u dii a un'tɔŋ angye, wɛɛ umpaaŋ a làbää wà u dii angye, ngye wa amanà anki? ");
INSERT INTO yns_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aben, ngye akwen mutɛn a un'tɔŋ angye naa: \"Wɛy mɛ alwom un'lɛŋ u dii a ngye\", wɛɛ le, ngye awe anà umpaaŋ a làbää u dii angye? ");
INSERT INTO yns_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ngye mbuur a mpem yweel, tàlwom umpaaŋ a làbää wà u dii angye, waa ngye ayàtääl ubwaŋàbwaŋ ntɔn mulwom un'lɛŋ u dii a un'tɔŋ angye. » ");
INSERT INTO yns_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","« Twon an'pà undiir a in'kyɛɛl akà mbwà. Twon lan'piy an'yak abɛ màntal kusà a ngul, manà ya iyàndyàndyäär ma anà ya iyàbulà mper akà bɛ ntɔn mukàlakyer ube. » ");
INSERT INTO yns_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","« Làlɔ̈m waa bàsàlapà, làleŋ waa bɛ làsàman, làbɛɛrà waa bàsàladuub. ");
INSERT INTO yns_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ntɔn mbuur awalɔm akyer awal, mbuur aleŋà akyer aman, akà mbuur awà abɛɛrà bàkyer asun'duub. ");
INSERT INTO yns_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nà uboo abɛ kan'kwo mupà nkɔŋ akà mwan ande, isàkal naa nde kan'lɔm mampà? ");
INSERT INTO yns_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naa sye nde kun'pɛ idyà an'kwar isàkal naa nde kan'lɔm nsö? ");
INSERT INTO yns_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bɛ, abe a baar làbà bɛ, isàkal naa bɛ làyöb mupà indiir aŋàbwaŋ akà baan abɛ, nkye ikɔɔn akà Taaràbɛ awà u du mupà indiir aŋàbwaŋ akà baar bun'lɔ̈ɔ̈m bya! » ");
INSERT INTO yns_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","« Abun, ndaa yanswà làkwen bɛ naa baar bàlakyeer, bɛ ŋakwo làkyer ya ntɔn ba: wawà un'kɔɔn anà aŋangɔɔm. » ");
INSERT INTO yns_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","« Làbilà u munàmbwo ikikye! Munàmbwo a kölàköl anà mbwo aŋàyaam ifàbiil baar kukwà, baar mbɔɔn bàfàbilà kwo. ");
INSERT INTO yns_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wɛɛ munàmbwo a ikikye anà mbwo a inküünà ifàsyen baar u mɔ̈ɔ̈, baar mbɔɔn ya bàfàman anki. » ");
INSERT INTO yns_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","« Wɛy bɛ làkäl kà igyɛɛŋ ntɔn aŋangɔɔm a loor. Ba bàfàbulà asànaa in'kɔk mpal bàfàyà ba akà bɛ, wɛɛ uboo a mpem aba, ba bà an'kyɛŋbɔl a mpɔr. ");
INSERT INTO yns_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bɛ, bɛ ba làsayöb unsà nkääl aba. Nkye ban'kwo bàbwe rɛzɛ unsà bite a nsyeenà, itàkal an'figɛ unsà ikwarngyal? ");
INSERT INTO yns_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kyakin, un'te aŋàbwaŋ afàbɔr mbɛŋ aŋàbwaŋ, wɛɛ un'te un'be afàbɔr mbɛŋ ambe. ");
INSERT INTO yns_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Un'te aŋàbwaŋ ukwe anki mubɔr mbɛŋ ambe, itàkal isɔ̈ɔ̈là a un'te mubɔr mbɛŋ aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Un'te wanswà mpa afàbɔr mbɛŋ aŋàbwaŋ bàkyer afàtsul wa, waa bàfàtɔɔm u mbaa. ");
INSERT INTO yns_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Abun, bɛ aŋangɔɔm a loor làsayöb u mbɛŋ aba. » ");
INSERT INTO yns_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","« Kyakin, kà baar banswà anki bàfàtɛn a mɛ naa \"Mwol, Mwol\", bàsàbilà uboo a Imwol a du, wɛɛ ba mpɛl bàfàkyer ukwen a Taaràmɛ awà u du. ");
INSERT INTO yns_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kà ilä kya, baar mbɔɔn bàsàtɛn a mɛ naa: \"Mwol, Mwol, nkye ngye ayöb anki naa bi kàtɛɛ ngɔɔm kà ikɔb angye, bi kàböŋ insɔŋà kà ikɔb angye, bi sye kàkyer impà mbɔɔn kà ikɔb angye?\" ");
INSERT INTO yns_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Abun mɛ in'safuur naa: \"Mɛ alàyöb anki akà ikikye, làkyà kunà, bɛ baar làfàkyer ube!\" » ");
INSERT INTO yns_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","« Undiir awun, mbuur wanswà kan'wem ndaa an'tɛn mɛ yi anà ukasyäälà ya, asàkal asànaa ŋun'yɛnà mwɛy kàtöŋ ndwà ande udu a nkɔŋ. ");
INSERT INTO yns_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mpal kànɔ̈ mbul, ngyäl yàsi an'swɛb, ikül a mbul kyàsiinà ndwà ayi, wɛɛ ya yàbü anki ntɔn in'bään aya myàkäl udu a nkɔŋ. ");
INSERT INTO yns_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wɛɛ mbuur wanswà kan'wem ndaa an'tɛn mɛ yi anà ukɔɔn asyäälà ya, asàkal asànaa insil mwɛy kàtöŋ ndwà ande udu a ansɛŋ. ");
INSERT INTO yns_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mpal kànɔ̈ mbul, ngyäl yàsi an'swɛb, ikül a mbul kyàsiinà kya ndwà ayi, laa yàbü ya: mbwabà aya yàkäl yàngwal. » ");
INSERT INTO yns_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Apan, mpal kàmay Yɛsu nswɛɛŋ ayi, baar banswà bàkäl mubem ntɔn an'lɔɔŋ ande, ");
INSERT INTO yns_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ntɔn nde ba kalɔɔŋà a ikɔ̈b kyanswà, wɛɛ kà asànaa alɔɔŋ a in'kɔɔn aba anki. ");
INSERT INTO yns_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mpal kàyàtyà Yɛsu u mɔŋ, iköŋ a baar waa kyun'läb. ");
INSERT INTO yns_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Le, ŋukyal a bay mwɛy kàyàsin tsütsü kusà a nde, kàbü an'köm, waa kàtɛn a nde naa: « Un'lɔɔŋ, kya ngye asàkwen, mpööŋ. » ");
INSERT INTO yns_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yɛsu kàsilà kɔɔ, kun'bä, waa kàtɛn naa: « Mɛɛ an'kwen, pɔŋà! » Taaŋ nsil alan, laa kàpɔŋà nde u bay ande. ");
INSERT INTO yns_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ungö apan, Yɛsu kun'swɛŋ naa: « Twon an'sam ndaa ayi itàkal akà mbuur mwɛy. Wɛɛ, kyen akà ngaŋ anà kapɛ ibɔɔn kàswɛŋ Mɔsɛ, ntɔn kya ikäl imbäl ntɔn ba. » ");
INSERT INTO yns_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Umpal kàbilà Yɛsu u Kapɛrnawum, kaptɛn a aŋità mwɛy kàsin tsütsü apà nde, waa kun'bɔ̈ɔ̈n, ");
INSERT INTO yns_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","waa kàtɛn a nde naa: « Mwol, un'syääl amɛ wàŋàbɔ̈ɔ̈n u ndwà, ndür ande ikanii anki, nde wàmuweemà usaay mbɔɔn. » ");
INSERT INTO yns_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yɛsu kun'fuur naa: « Mɛ, mɛ in'kyer akun'kɔɔr. » ");
INSERT INTO yns_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wɛɛ kaptɛn awun kàfuur naa: « Mwol, mɛ in'kwe anki naa ngye abilà u ndwà amɛ. Wɛɛ ngye, tɛn ndaa mwɛy mpɛl, un'syääl amɛ ukɔɔrà. ");
INSERT INTO yns_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ntɔn mɛ in'we anà amfum bàfan'ler anà mɛ sye in'we anà aŋità in'fàler mɛ. Kya mɛ insàtɛn a aŋità mwɛy naa: \"Kyen!\", nde laa ukyà nde, kya mɛ insàtɛn a wumwɛy naa: \"Yà!\", nde sye laa uyà nde, kya mɛ sye insàtɛn a un'syääl amɛ naa: \"Kyer abà!\", nde sye laa ukyer nde. » ");
INSERT INTO yns_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mpal kàwem Yɛsu ndaa ayin, laa kàbem nde, waa kàtɛn a baar bàyun'labà naa: « Mɛ alakyään ndandaa naa mɛ ŋàtàman anki làkwikilà atub alà akà mbuur mwɛy uboo a Isàlɛl. ");
INSERT INTO yns_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mɛ in'fàlakyään naa baar mbɔɔn bàsàfà mper làfàsɛnà anà làfàkàminà taaŋ, ba bàsàdyà mɛsà mwɛy anà Abàlam, Isak anà Yakɔb uboo a Imwol a du, ");
INSERT INTO yns_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","wɛɛ, aŋan'kwal a imwol bàsatɔɔm u nsà uboo a làpib: kwo isàkal ilel anà nkwoor a an'din. » ");
INSERT INTO yns_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Apan Yɛsu kàtɛn a kaptɛn naa: « Furà ndwà angye, wɛy ya ikäl asànaa lan'lɔɔm làkwikilà angye! » Taaŋ nsil alan un'syääl a kaptɛn waa kàkɔɔrà. ");
INSERT INTO yns_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ungö apan, Yɛsu kàkyen ndwà a Petɔlà. Kwo nde kàmɛn ukwà a Petɔlà wun'kaar wàŋàbɔ̈ɔ̈n ntɔn nde kàkäl anà làbwey a mpye. ");
INSERT INTO yns_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nde kun'bä u kɔɔ, làbwey a mpye waa làtoo. Apan nde waa kàmbarà, waa kàsɛmà mukun'syääl. ");
INSERT INTO yns_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","U sisye, baar bun'twäälà baar bàkäl anà an'dweelà an'be mbɔɔn. Umbwo a ndaa ande, nde kàböŋà an'dweelà amà, waa kàkɔɔrà sye abɛy banswà. ");
INSERT INTO yns_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kàkyer nde abà ntɔn ndaa kàtɛn ŋangɔɔm Yɛsay ikwe: « Nde kàwɛl an'too anà an'kyal abi. » ");
INSERT INTO yns_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mpal kàmɛn Yɛsu iköŋ a baar kyàmun'diŋà, nde kàswɛŋ alɔŋki ande musabà sim a ɛwà lumwɛy. ");
INSERT INTO yns_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Un'lɔɔŋ a Un'kɔɔn mwɛy kàsin, waa kàtɛn a nde naa: « Un'lɔɔŋ, mɛ in'kyer ayalab mper yanswà ayàkyà ngye. » ");
INSERT INTO yns_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yɛsu kun'fuur naa: « In'kyɛŋ mye anà an'fu, nɛn sye ye anà an'yaab, wɛɛ Mwan a mbuur ikal atälà un'tswe kyatɛy. » ");
INSERT INTO yns_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Umwɛy uboo a alɔŋki ande kàtɛn a nde naa: « Mwol, mpɛ mbwo mɛ in'tàkàdyee taaràmɛ. » ");
INSERT INTO yns_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wɛɛ Yɛsu kun'fuur naa: « Yan'läb, wɛy akü bàdyee akü aba. » ");
INSERT INTO yns_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ungö apan, Yɛsu kàbilà u bwaar anà alɔŋki ande. ");
INSERT INTO yns_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kimbürà, un'pöb a ngwal kàyi udu a ɛwà, ibɔ a an'dà byàbilà u bwaar. Apan nde kàkäl aŋàbɔ̈ɔ̈n. ");
INSERT INTO yns_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Alɔŋki bàsin apà nde, waa bun'wiy anà mutɛn naa: « Mwol, itsü mɔ̈ɔ̈! Bi abà ikwà! » ");
INSERT INTO yns_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nde kafuur naa: « Ntɔn nkye làbà bɛ u bɔɔmà? Bɛ baar a làkwikilà ikikye! » Apan, nde waa kàmbarà, kàŋän un'pöb anà ɛwà. Duu a mbɔɔn waa làbilà. ");
INSERT INTO yns_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ba banswà bàkäl mubem, waa bàtɛɛnà naa: « Mbuur awà wà nà, waa itàkal in'pöb anà ɛwà byàmukun'weemà? » ");
INSERT INTO yns_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mpal kàkɔlà Yɛsu u sim lumwɛy, u nsi a baar a Gadarà, baar a an'dweelà an'be bɔ̈ɔ̈l bayàtoo kan'dii, waa bàyàbwey anà nde. Ba bàkäl anà umpɔr mbɔɔn, lalan akà mbuur mwɛy kàkwe anki mulyaŋ u mbwo ayin. ");
INSERT INTO yns_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Waa le, ba bàsɛmà musà in'kwɛŋ: « Mwan a Nzam, ndaa nà ngye awe ayà anà bi? Ngye an'yà pà ntɔn mukà itwääl lingyoomà kusà a taaŋ mukwo? » ");
INSERT INTO yns_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","U kikwɛl, làkäl anà làböl a kölàköl là ngul làkäl muyidyà. ");
INSERT INTO yns_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","An'dweelà an'be màlɔ̈ɔ̈m akà Yɛsu naa: « Kya ngye asàkwen mukiböŋ, itöm u làböl a ngul lanà. » ");
INSERT INTO yns_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nde kàtɛn a ma naa: « Làkyen. » Ma waa màtoo, waa màkàbilà u ngul. Apan sye, làböl a ngul làkaamà fà iköl a mɔŋ, waa làkàbwà kà ɛwà, waa làminà kan'dà. ");
INSERT INTO yns_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aseey a ngul waa bàtiin, bàkàbila u bul, waa bàkyään yinà yanswà yàlyaŋ anà indiir byàbweel baar bàkäl anà an'dweelà an'be. ");
INSERT INTO yns_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Apan bul lanswà waa làtoo mukàman Yɛsu. Utaaŋ bun'mɛn ba, ba bun'bɔ̈ɔ̈n naa nde ulwomà u nsi aba. ");
INSERT INTO yns_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yɛsu kàbilà u bwaar, waa kàfàsabà ɛwà ntɔn mukyà bul ande. ");
INSERT INTO yns_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Apan bun'twääl mbuur mwɛy wàŋàkwɛkà wàŋàbɔ̈ɔ̈n udu a ipɔy. Umpal kàmɛn Yɛsu làkwikilà aba, nde kàtɛn a mbuur aŋàkwɛkà naa: « Mwan amɛ, sà un'kanà! Bàmadwääl nkul a man'be angye! » ");
INSERT INTO yns_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wɛɛ alɔɔŋ a in'kɔɔn bàtɛɛnà ba a ba naa: « Mbuur wà an'bɛy Nzam! » ");
INSERT INTO yns_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yɛsu kàkyer ayöb an'kyän aba, waa kàtɛn naa: « Ntɔn nkye làwe bɛ anà an'kyän an'be u mpem abɛ? ");
INSERT INTO yns_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nkye byan'söön ubwaŋ, mutɛn naa: \"Ube angye ban'wà\", lɛɛ mutɛn naa: \"Mbarà, kyen\"? ");
INSERT INTO yns_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yà ubwaŋ naa bɛ, bɛ làyöb naa Mwan a mbuur we anà ikɔ̈b adwääl baar nkul u mɛɛn pà. » Apan, nde kàtɛn a mbuur aŋàkwɛkà naa: « Mɛ amaswaŋ: Mbarà, sɛn ipɔy angye, furà ndwà angye! » ");
INSERT INTO yns_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mbuur awun waa kàmbarà, waa kàkyen ndwà ande. ");
INSERT INTO yns_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mpal kyàmɛn iköŋ a baar ndaa ayi, kya kyàkäl u bɔɔmà, waa kyàkömà Nzam ntɔn kàpɛ nde ikɔ̈b atub aki akà baar. ");
INSERT INTO yns_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ungö apan, Yɛsu waa kàkyen. Mpal kàkäl nde mulyaŋ, nde kàmɛn mbuur mwɛy kàkyàbwaay kà ikal bàfàfur itɛr, ikɔb ande Màtay. Nde kàtɛn a nde naa: « Yan'läb! » Mbuur awà waa kàmbarà, waa kun'läb. ");
INSERT INTO yns_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yɛsu kàkäl mudyà u ndwà. Afüür a itɛr mbɔɔn anà baar abe bàyàdyà mɛsà mwɛy anà Yɛsu anà alɔŋki ande. ");
INSERT INTO yns_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mpal bàmɛn Amfarisi abun, ba bàfuul alɔŋki ande naa: « Ntɔn nkye Un'lɔɔŋ abɛ udyaa nde ikal imwɛy anà afüür a itɛr anà baar abe? » ");
INSERT INTO yns_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wɛɛ Yɛsu, mpal kàwem nde abwɛy, nde kàtɛn naa: « Mfun a ungaŋ yatɛy akà baar mpa abye anà ukyal, wɛɛ akà abɛy. ");
INSERT INTO yns_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Abun, làkyen kàlalɔŋkà mbuul a ndaa yi: \"Mɛ, mɛ in'kwen nsyääm, wɛɛ kà ibɔɔn anki.\" Ntɔn mɛ, mɛ kàyi anki mubel baar a balàbal, wɛɛ baar abe. » ");
INSERT INTO yns_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Apan, alɔŋki a Ywan bàyi apà Yɛsu, waa bun'fuul naa: « Ntɔn nkye bi anà Amfarisi, bi ifàkin udyà, wɛɛ alɔŋki angye bàfàkin anki udyà? » ");
INSERT INTO yns_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yɛsu kafuur naa: « Nkye asam a mbuur kan'tà bɔr ban'kwo bàkäl u ngyɛb umpal awà nde apà ba? Wɛɛ ilä ikyer asàyà bàsun'lwom ba uboboo a ba, apan ba bàsàkin udyà. » ");
INSERT INTO yns_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","« Akà mbuur mwɛy ukwe anki mubaay ipfɛy aŋànün anà ikaam a ipfɛy akün, ntɔn kya iyàkaam ipfɛy aŋànün, abun tuun a ipfɛy làyàbulà làkölàköl. ");
INSERT INTO yns_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Vin akün bàfàsà anki u mbeen aŋànün manà mbeen iyàbölà, manà man iyàpää anà mbeen iyàkyà bwà. Wɛɛ vin akün bàfàsà u mbeen akün, waa vin anà mbeen byàsàkal aŋàtii ubwaŋ. » ");
INSERT INTO yns_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Umpal kàtɛɛnà Yɛsu a ba abà, un'byääl mwɛy kàyàbwà an'köm kusà a nde, waa kàtɛn a nde naa: « Mwan amɛ wà un'kaar kan'kwà itaan a mbɔɔn tɛy. Wɛɛ yun'si an'kɔɔ, waa nde ufàyàkal anà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Apan, Yɛsu waa kàmbarà, waa kun'läb anà alɔŋki ande. ");
INSERT INTO yns_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Taaŋ nsil alan, un'kaar mwɛy awàkàyitoo an'kil mbul kwem aŋiyweel, kàyàsin tsütsü ungö a Yɛsu, waa kàtɛ làpaan a ipfɛy ande mpi. ");
INSERT INTO yns_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ntɔn nde kàtɛɛnà naa: « Isàkal naa mɛ an'tà làpaan a ipfɛy ande mpi, mɛ in'kyer akɔɔrà. » ");
INSERT INTO yns_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mpal kàbulà Yɛsu anà kun'mɛn nde, nde kàtɛn a nde naa: « Mwan amɛ, sà un'kanà! Làkwikilà angye làmakɔɔr. » Taaŋ nsil alan, un'kaar awà waa kàkɔɔrà. ");
INSERT INTO yns_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Umpal kàkɔlà Yɛsu u ndwà a un'byääl awà anà kàmɛn nde abɛɛrà a mfuŋ anà mini a iköŋ a baar, ");
INSERT INTO yns_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","nde kàtɛn a ba naa: « Làlwomà, ntɔn mwan un'kaar ŋàkwà tɛy, nde wàmubɔ̈ɔ̈n. » Wɛɛ ba waa bun'sɛɛ. ");
INSERT INTO yns_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ungö bàtwey ba iköŋ a baar, nde waa kàbilà, kàtɛ kɔɔ a mwan un'kaar awun mpi, mwan un'kaar waa kàwiyà. ");
INSERT INTO yns_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Làsaŋ a ndaa ayi làkyer apää kun'tà awun. ");
INSERT INTO yns_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Umpal kàkyen Yɛsu, ikwàmii abɔ̈ɔ̈l waa bàyun'labà bàmuyisà in'kwɛŋ: « Mwan a David, iweem ngyɛb! » ");
INSERT INTO yns_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Umpal kàbilà nde u ndwà, ikwàmii bàyàsin tsütsü apà nde, waa Yɛsu kàtɛn a ba naa: « Nkye bɛ lan'sà làkwikilà naa mɛ an'kwo in'kyer ya? » Ba bun'fuur naa: « Inye, Mwol. » ");
INSERT INTO yns_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Apan, Yɛsu waa kàbä mii aba, waa kàtɛn naa: « Wɛy ya ikäl asànaa alà làkwikilà abɛ! » ");
INSERT INTO yns_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Waa mii aba myàyaanà. Yɛsu kaswɛŋ a ngwal naa: « Làkäl kà igyɛɛŋ, wɛy akà mbuur mwɛy ukɔɔn ayöb! » ");
INSERT INTO yns_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wɛɛ ba, pa làtoo, laa bàpay ba làsaŋ ande u nsi yanswà. ");
INSERT INTO yns_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Umpal bàkäl ba mukyà, baar bun'twääl nkiin mwɛy kàkäl anà unsɔŋà. ");
INSERT INTO yns_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pa kàböŋ Yɛsu unsɔŋà awun, nkiin waa kàsɛmà musà ndaa. In'kàbɔ a baar bàmɛn ndaa yubem, waa bàtɛɛnà naa: « Ndaa atub ayi ŋàtàbwà anki kà Isàlɛl. » ");
INSERT INTO yns_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wɛɛ Amfarisi bàtɛn naa: « Nde an'dweelà an'be ayiböŋ unsà ikɔ̈b a mfum a an'dweelà an'be. » ");
INSERT INTO yns_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yɛsu kàyilyaŋà kà an'bul a kölàköl anà mà ikikye. Nde kàyilɔɔŋà u ndwà a nköŋ a Ayudà aba, mukyään Làsaŋ Aŋàbwaŋ là Imwol a du anà mukɔɔr ukyal banswà anà too lanswà. ");
INSERT INTO yns_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Umpal kàmɛn nde iköŋ a baar, laa kàkyɛɛr nde, ntɔn baar abà bàkäl aŋàyɔn anà ndür aŋàkwamà, asànaa in'kɔk ikɔ̈ɔ̈n un'seey. ");
INSERT INTO yns_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Apan nde kàtɛn a alɔŋki ande naa: « Mbɛŋ aŋàsöŋ yà mbɔɔn, wɛɛ baar a isal abwo ya bà ikikye. ");
INSERT INTO yns_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Làlɔ̈ɔ̈m akà ŋaywaŋ mutɔm baar a isal mbɔɔn u ywaŋ ande. » ");
INSERT INTO yns_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yɛsu kàbel alɔŋki ande bàkwem aŋiyweel, waa kapɛ ikɔ̈b muböŋ an'dweelà an'be anà mukɔɔr an'kyal manswà anà an'too manswà. ");
INSERT INTO yns_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Le ikɔb a antööm bàkwem aŋiyweel abi: wàtàtwɛb Simɔn, awà bàfàbel naa Petɔlà, anà un'tɔŋ ande Andre, Zyak anà Ywan, baan a Zebàday, ");
INSERT INTO yns_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo anà Bàtɛlàmay, Tuma anà Màtay un'füür a itɛr, Zyak mwan a Alfɛ anà Tàday, ");
INSERT INTO yns_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔn ŋambämà anà Yudasi Isikalyɔt, mbuur kun'yälà. ");
INSERT INTO yns_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yɛsu kàtöm alɔŋki abà bàkwem aŋiyweel mukàsal isal anà musyääl nswɛŋ yi: « Twon lan'kyà akà baar mpa abà Ayudà anà twon lan'bilà kan'bul a Samàlya. ");
INSERT INTO yns_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Wɛɛ bɛ, làkyen akà in'kɔk a un'sɛŋ a Isàlɛl amyà myàdiimà. ");
INSERT INTO yns_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","U mbwo làkyà bɛ, làlɔŋ naa Imwol a du kyà tsütsü. ");
INSERT INTO yns_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Làkɔɔr abɛy, làwiy akü, làpöŋ aŋukyal a bay, làböŋ an'dweelà an'be. Bɛ, bɛ làwɛl byàngway, làpɛ sye byàngway. ");
INSERT INTO yns_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Twon lan'syen itàkal wɔl, itàkal ngim, itàkal itɛr a ishabà ntɔn bɛ làsi kà in'di abɛ, ");
INSERT INTO yns_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","itàkal bɔ̈n ntɔn nkyeen, itàkal an'kàzak an'mɔ̈ɔ̈l, itàkal idyäär, itàkal unsɔk, ntɔn un'syääl afàdyà unsà isal ande. » ");
INSERT INTO yns_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","« U bul a kölàköl itàkal là ikikye làbilà bɛ, làleŋ naa nà kan'kwo mukàlawal, làbwaay apà nde tii mpal làsàkyà bɛ. ");
INSERT INTO yns_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Umpal làbilà bɛ u ndwà, làpɛ ya mbɔr, ");
INSERT INTO yns_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","isàkal naa ndwà ayin yàmàlawal, wɛy duu abɛ làkäl udu a ya, wɛɛ isàkal naa ya yàlawɛl anki, wɛy duu abɛ làfurà akà bɛ. ");
INSERT INTO yns_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Isàkal naa bàlawɛl anki anà bàlawem anki, làtoo u ndwà ayin itàkal u bul alan anà làkɔɔb un'twà a in'kɔl abɛ. ");
INSERT INTO yns_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ndandaa mɛ alàkyään: ilä a nsaŋ, nsi a Sɔdɔm anà Gɔmɔr bàsawem kingyɛb akɔ̈ɔ̈n naa bul alan. » ");
INSERT INTO yns_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","« Mɛ, mɛ amàlatɔm asànaa in'kɔk uboboo a an'kyɛŋbɔl. Làkäl unsà igyɛɛŋ asànaa ntäy anà aŋàlàbɔ̈ɔ̈n asànaa nkokà. ");
INSERT INTO yns_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Làkäl unsà igyɛɛŋ akà baar, ntɔn baar bàsàlasyen u làbay a nsaŋ a kölàköl anà bàsàlakam an'füm uboo a ndwà a nköŋ aba, ");
INSERT INTO yns_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ba bàsàlafüün akà an'kuvɛrnɔ̈ɔ̈r anà akà amfum a nsi ntɔn mɛ, ntɔn bɛ làtɛ imbäl akà ba anà akà baar mpa abà Ayudà. ");
INSERT INTO yns_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Wɛɛ mpal bàsàlafüün ba, twon lan'man mpay muyöb naa bɛ làtɛn aben itàkal naa ininà bɛ làtɛn. Ndaa yanswà làsàtɛn bɛ, ya bàsàlapà taaŋ nsil la. ");
INSERT INTO yns_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ntɔn ya isàfà anki akà bɛ, wɛɛ Dweelà In'kyɛɛl a Taaràbɛ asàtɛn uboo a bɛ. ");
INSERT INTO yns_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Un'tɔŋ asàyälà un'tɔŋ ande ntɔn bun'dwä, taa asàyälà mwan ande, baan bàsàsà un'tswe ngwal akà aböör aba anà bàsàkwen naa badwä. ");
INSERT INTO yns_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Baar banswà bàsàkyer alayiiŋ ntɔn ikɔb amɛ. Wɛɛ mbuur asàtsim tii u ntsüü asàwà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mpal bàsàlamɛɛy nkwaaŋ u bul làmwɛy, kàlayee u bul asin. Mɛ ndandaa alàkyään, bɛ làsàkal aŋàtàmay anki muyilyaŋ kà an'bul a Isàlɛl manswà mpal usàyà Mwan a mbuur. » ");
INSERT INTO yns_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","« Un'lɔŋki ufàlyaŋ anki un'lɔɔŋ ande, itàkal un'syääl ufàlyaŋ anki nkum ande. ");
INSERT INTO yns_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yan'kwo naa un'lɔŋki ukäl asànaa un'lɔɔŋ ande anà un'syääl asànaa nkum ande. Ntɔn ba ŋandwà bun'beelà Bɛlzàbul, nkye byan'kɔɔn ba mubel baar a ndwà ande abwɛy! » ");
INSERT INTO yns_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","« Twon làmatiin bɔɔmà. Ntɔn undiir aŋàyee wanswà akyer asàmɛnà u leŋ, anà ndaa yanswà yà unku bàkyer asàyöb. ");
INSERT INTO yns_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ndaa amàlakyään mɛ u làpib, wɛy bɛ làtɛn ya u mwäänanswà, ndaa bàmàlalwɛɛŋ u tsü, làlɔŋ ya udu a isaŋ. ");
INSERT INTO yns_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Twon lan'tiin bɔɔmà baar akwà bàfàdwa nà ndür mpɛl, wɛɛ bɛ, bɛ bɔɔmà làtiin mbuur akwà afàdwa ndür anà mɔ̈ɔ̈ uboo a yaaŋ a mbaa. ");
INSERT INTO yns_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nkye bàfàyälà anki insɔɔr ibyeel u falà làmwɛy? Mpalàbà, akà imwɛy uboo a bya ifàbwà tɛy u mɛɛn naa Taaràbɛ ukɔɔn ayöb. ");
INSERT INTO yns_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wɛɛ akà bɛ, itàkal ntswe abɛ yanswà yaŋàtaŋ. ");
INSERT INTO yns_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Twon lan'man bɔɔmà: bɛ, bɛ lan'söön insɔɔr mbɔɔn. » ");
INSERT INTO yns_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","« Mbuur wanswà asàkyey u mii a baar naa nde wà un'lɔŋki amɛ, mɛ sye in'sun'kyey u mii a Taaràmɛ awà u du. ");
INSERT INTO yns_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wɛɛ isàkal naa mbuur aman'tɔn u mii a baar banswà, mɛ sye in'sun'tɔn u mii a Taaràmɛ awà u du. » ");
INSERT INTO yns_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","« Twon lan'si naa mɛ kàyàtwaal duu u mɛɛn: mɛ, mɛ kà duu kàyàtwaal anki, wɛɛ kɔm. ");
INSERT INTO yns_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mɛ kayi ntɔn muyàkaab mbuur anà taarànde, mwan un'kaar anà ngwän, mwan un'kaar àna ukwà ande wà un'kaar. ");
INSERT INTO yns_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Aŋankir a mbuur bàfàfà uboo a ywar ande ŋakwo. ");
INSERT INTO yns_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mbuur akwen taarànde itàkal ngwän aŋàsöön mɛ, nde ukwe anki mukal wàmɛ, mbuur akwen mwan ande wàbaal itàkal wà un'kaar aŋàsöön mɛ, nde ukwe anki mukal wàmɛ. ");
INSERT INTO yns_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mbuur mpa usɛn kulunsi ande anà ukɔɔn ayan'lab, nde ukwe anki mukal wàmɛ. ");
INSERT INTO yns_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mbuur asàyee mɔ̈ɔ̈ ande, wa asàkyà bwà. Wɛɛ mbuur asàpiy mɔ̈ɔ̈ ande ntɔn mɛ, nde akyer afàsàman wa. » ");
INSERT INTO yns_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","« Mbuur usàlawal, nde mɛ kan'wal, mbuur usan'wal, nde kan'wal mbuur kan'töm. ");
INSERT INTO yns_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mbuur kan'wal ŋangɔɔm ntɔn nde wà ŋangɔɔm, nde asàwal bweel a ŋangɔɔm. Mbuur kan'wal mbuur a balàbal ntɔn nde wà wàbalàbal, nde asàwal bweel a mbuur a balàbal. ");
INSERT INTO yns_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mbuur wanswà asàpà indiir anwà, itàkal naa kɔɔb a an'dà a mpye làmwɛy akà umwɛy uboo a baan ambɛy bà ntɔn nde wà un'lɔŋki amɛ, bweel ande bwà làsàkyà anki. » ");
INSERT INTO yns_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mpal kàmay Yɛsu mupà nswɛɛŋ akà alɔŋki ande bàkwem aŋiyweel, nde kàlwomà apan, waa kàkyen ntɔn mukàlɔŋ anà mukàkyään Làsaŋ Aŋàbwaŋ kà an'bul aba. ");
INSERT INTO yns_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kyekà Ywan, u bɔlokà ande, kàwem baar bàmukanà isal a Klistɔ. Nde kun'tööm alɔŋki ande ntɔn mukun'fuul naa: ");
INSERT INTO yns_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","« Nkye ngye awà Mbuur akwà akyer ayà, lɛɛ bi idil wàsin? » ");
INSERT INTO yns_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yɛsu kafuur naa: « Làkyen kàlun'sam Ywan ayà lan'wem bɛ anà lan'man bɛ yi: ");
INSERT INTO yns_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ikwàmii ban'man, ikar ban'mbarà, aŋabay ban'pɔŋà, ikwan'tsü ban'wem, akü ban'wiyà, Làsaŋ Aŋàbwaŋ ban'kyään akà aŋàlàmbwà. ");
INSERT INTO yns_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Un'sak akà mbuur mpa asàpiy làkwikilà ande ntɔn mɛ! » ");
INSERT INTO yns_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ungö a nkyeen a alɔŋki a Ywan, Yɛsu kàsɛmà muyäm ntɔn Ywan: « Ininà bɛ làkàler u nsye a ipɔl? Wɛŋwɛŋ kànini un'pöb? ");
INSERT INTO yns_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wɛɛ bɛ, ininà bɛ làkàler? Mbuur mwɛy wàŋàbwaar ipfɛy a ntal? Wɛɛ naa baar bàfàbwaar ipfɛy a ntal bàfàkal u ndwà a amfum. ");
INSERT INTO yns_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Wɛɛ bɛ, ininà bɛ làkàler? ŋangɔɔm mwɛy? Inye, waa mɛ alàkyään naa mbuur mwɛy wàŋàsöön ŋangɔɔm. ");
INSERT INTO yns_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ntɔn nde wà mbuur akwà bàsön ntɔn nde naa: \"Le, mɛ an'tɔm mbuur mwɛy kusà angye, ntɔn mulɔn mbwo angye.\" ");
INSERT INTO yns_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ndandaa mɛ alàkyään: uboo a baar banswà kàbör un'kaar, akà mbuur mwɛy kan'söön Ywan Un'düümà watɛy. Wɛɛ mbuur ikikye uboo a Imwol a du kàmusöön. ");
INSERT INTO yns_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sɛmà paŋà a Ywan Un'düümà tii ŋàbawà, Imwol a du kyà uboo a unkaak a ngwal. Aŋunkaak a ngwal bàfàgyɔɔr kya. ");
INSERT INTO yns_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ntɔn aŋangɔɔm banswà anà Un'kɔɔn a Mɔsɛ bàtɛ ngɔɔm tii u paŋà a Ywan. ");
INSERT INTO yns_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Isàkal naa bɛ làkwen muyöb ubwaŋàbwaŋ, nde wà Ɛli akwà kàkyer alàyà. ");
INSERT INTO yns_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wɛy mbuur awe anà an'tsü, uwem! » ");
INSERT INTO yns_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","« Nkööl ayi mɛ ya in'sii anà nà? Ya yà asànaa baan akwà bàfàmbàmbar u balàbal anà bàfàyɔɔb bumwɛy naa: ");
INSERT INTO yns_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","\"Bi kàlabɛɛrà mfuŋ, wɛɛ bɛ làkyen anki! Bi kàlasyeel ingɔŋ a ilel, wɛɛ bɛ làlel anki!\" ");
INSERT INTO yns_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Abun, Ywan kàyi nde, afàdyà anki, afànwà anki, ba bàfàtɛn naa: \"Nde we anà un'sɔŋà!\" ");
INSERT INTO yns_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwan a mbuur kan'yà, wàmudyà, wàmunwà, wɛɛ bàfàtɛn naa: \"Le, nde wà ndyeel anà un'nweel a man, un'sam a afüür a itɛr anà baar abe!\" Wɛɛ an'yeerà màfàmɛnà u nkyeer a ma. » ");
INSERT INTO yns_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mpalàbà Yɛsu kàsɛmà muŋän an'bul akwà amàkàkyer nde impà mbɔɔn, ntɔn an'bul amà màbuul anki mpem aba. Nde kàtɛn naa: ");
INSERT INTO yns_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","« Ngyɛb akà ngye Kɔrazin! Ngyɛb akà ngye Bɛtesayidà! Ntɔn, ilàkal naa impà bàkyer akà bɛ bàkyer u Tir anà u Sidɔn, abà itaan baar aba bàkyàbuul mpem, bàkyàbwaar ngɔɔr anà bàkyàkübà un'twà. ");
INSERT INTO yns_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Undiir awun, waa mɛ in'tɛn a bɛ naa: ilä a nsaŋ, Tir anà Sidɔn mpay a mbɔɔn bàsamɛɛy anki asànaa bàsàmɛɛy ba bɛ. ");
INSERT INTO yns_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Anà ngye Kapɛrnawum, nkye ngye asàlar tii u du? Ngye asàtyà an'lɔŋ! Ntɔn, yàlàkal naa impà bàkyer akà ngye bàkyer u Sɔdɔm, bul alà làlàkal tii ŋàbawà. ");
INSERT INTO yns_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Undiir awun, waa mɛ in'tɛn a bɛ naa ilä a nsaŋ, Sɔdɔm bàsun'weel ngyɛb akwànaa ngye. » ");
INSERT INTO yns_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Utaaŋ alan, Yɛsu kàsɛmà mutɛn naa: « Taa, Mwol a du anà mɛɛn, mɛ amasyäŋà ntɔn kàyee ngye ndaa ayi akà aŋan'yeerà anà akà aŋuyɛnà anà kàswɛŋ ngye ya akà baan ambɛy. ");
INSERT INTO yns_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɛɛ, Taa, mɛ amasyäŋà ntɔn kàkwen ngye naa ya ikäl abà. » ");
INSERT INTO yns_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","« Taaràmɛ kàkyan'pà indiir byanswà, wɛɛ akà mbuur mwɛy tɛy uyöb Mwan, isàkal naa kà Taa anki anà mbuur tɛy uyöb Taa isàkal naa kà Mwan anki anà mbuur kan'kwen Mwan mukyään ndaa ayi. » ");
INSERT INTO yns_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","« Làyi akà mɛ, bɛ banswà lan'yɔn muyisyen buur a kölàköl, waa mɛ in'sàlapà ngyöör. ");
INSERT INTO yns_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Làwɛl ntaaŋàmbar amɛ anà làkyey naa mɛ alàlɔŋ, ntɔn mɛ in'wà mbuur a mpem a duu anà wàlàbɔ̈ɔ̈n, waa mɔ̈ɔ̈ abɛ usàyöör. ");
INSERT INTO yns_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ɛɛ, ntaaŋàmbar amɛ mpay yatɛy musyen, buur amɛ là ikaay. » ");
INSERT INTO yns_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ungö apan, Yɛsu kàkäl mulyaŋ uboo a an'ywaŋ a blɛ ilä a saba. Alɔŋki ande bàkäl anà ngyal, waa bàbwe imfà a blɛ ntɔn mudyà. ");
INSERT INTO yns_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mpal bàmɛn Amfarisi abun, ba bàtɛn a nde naa: « Ler, alɔŋki angye bàmukyer ndaa mpa bàfàkyer kilä a saba! » ");
INSERT INTO yns_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yɛsu waa kafuur naa: « Nkye bɛ làtäŋ anki ndaa kàkyer David mpal kàwem nde ngyal anà baar bàkäl anà nde? ");
INSERT INTO yns_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nde kàbilà u ndwà a Nzam, kàwɛl mampà bàfàpà ibɔɔn akà Nzam waa kàdi ma, mumwɛy nde kàpɛ baar bàkäl anà nde, itàkal naa ma angaŋ mpɛl bàfàdyà. ");
INSERT INTO yns_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Itàkal naa nkye bɛ, bɛ làtäŋ anki uboo a Un'kɔɔn naa ilä a saba, u ndwà a Nzam, angaŋ bàfàbɛy saba, mukɔɔn akal unsà ube? ");
INSERT INTO yns_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Wɛɛ mɛ, mɛ alàkyään naa apà ye anà ndaa yàŋàsöön ndwà a Nzam! ");
INSERT INTO yns_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kya bɛ làlàyöb ubwaŋàbwaŋ mbuul a ndaa ayi: \"Mɛ in'kwen ngyɛb wɛɛ kà ibɔɔn anki\", bɛ baar bàkɔ̈ɔ̈n ube làlatsüül anki mbar. ");
INSERT INTO yns_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ntɔn Mwan a mbuur wà nkum a saba. » ");
INSERT INTO yns_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yɛsu kàlwomà nde paa, nde kàkyen ndwà a nköŋ aba, waa kàbilà kwo. ");
INSERT INTO yns_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Akun kàkäl anà mbuur mwɛy kàkäl anà kɔɔ aŋàkwɛkà. Amfarisi bàkwen mufüün Yɛsu: ba bun'fuul naa: « Nkye un'kɔɔn abi akyàpà mbwo mukɔɔr mbuur kilä a saba? » ");
INSERT INTO yns_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Wɛɛ nde kafuur naa: « Nà uboo abɛ, isàkal naa nde we awà un'kɔk mwɛy anà wa ubü uboo a fu kilä a saba, waa nde mpa ukàsaab wa? ");
INSERT INTO yns_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wɛɛ mbuur kan'söön un'kɔk! Kyakin, mbwo yà mwo mukyer ubwaŋ kilä a saba. » ");
INSERT INTO yns_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Apan nde kàtɛn a mbuur awun naa: « Sen kɔɔ angye. » Nde waa kàsen la, la sye waa làbwɛŋ asànaa lumwɛy. ");
INSERT INTO yns_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Amfarisi bàtoo ba, ba bàkàsà nköŋ ntɔn mutsul mbar naa ba bàyun'dwa aben. ");
INSERT INTO yns_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mpal kàyöb Yɛsu ndaa ayin, nde kàlwomà kà ikal akin, baar mbɔɔn bàkyer un'lab, waa kàkɔɔr ba banswà, ");
INSERT INTO yns_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","wɛɛ nde katsüŋ a ngwal naa ba bàkɔɔn akyään naa nde wà nà. ");
INSERT INTO yns_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kàkyer nde abà ntɔn ndaa akwà kàtɛn ŋangɔɔm Yɛsay ikwe: ");
INSERT INTO yns_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","« Le un'syääl amɛ kàsɔ̈ɔ̈l mɛ, Nkwen Aŋàbwaŋ amɛ kàkwen mɛ musɔɔl, mɛ in'sàsà Dweelà amɛ udu a nde, waa nde usàkyään balàbal akà in'sɛŋ. Mɛ in'sàsà Dweelà amɛ udu a nde, nde asàkyään un'kɔɔn awà an'pà mɛ akà in'sɛŋ. ");
INSERT INTO yns_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nde usàtwal anki an'sye, nde usàsà anki in'kwɛŋ, akà mbuur mwɛy usàwem anki ndaa ande kà an'balàbal. ");
INSERT INTO yns_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nde usàbɔɔl anki kite a iful aŋàbɔɔl, nde usàdim anki mwinà akalɛɛmà unsinsi. Nde asàkyer abà tii mpal làsàwal balàbal iböŋ. ");
INSERT INTO yns_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Waa in'sɛŋ myàsàsà làkyän a mya kà ikɔb ande. » ");
INSERT INTO yns_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Apan ba bun'twääl ŋukɔŋ mwɛy wà ikwàmii anà wànkiin. Yɛsu laa kun'kɔɔr nde, waa kàsɛmà musà ndaa anà muman. ");
INSERT INTO yns_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","In'sɛŋ a baar myanswà myàkäl mubem anà mutɛn naa: « Nkye wà kà mwan a David anki? » ");
INSERT INTO yns_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mpal bàwem Amfarisi abwɛy, ba bàtɛn naa: « Mbuur wunà insɔŋà ayiböŋ u mbwo a Bɛlzàbul, mfum a insɔŋà. » ");
INSERT INTO yns_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yɛsu kàyöb an'kyän aba, waa kàtɛn naa: « Imwol kyanswà akyà ifàkaabà kya ŋakwo, ikyer afàpää. Bul làmwɛy, itàkal ywar làmwɛy làŋàkaabà la ŋakwo, la làfàtsim anki. ");
INSERT INTO yns_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Isàkal naa Satanà kan'twey Satanà, nde wàŋakaabà anà nde ŋakwo: apan imwol ande isàtsim aben? ");
INSERT INTO yns_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Isàkal naa mɛ, mɛ insɔŋà in'kaböŋà kà ikɔ̈b a Bɛlzàbul, baan abɛ insɔŋà bàfàböŋ kà ikɔ̈b a nà? Lalan ba ŋakwo bàsàkal atsüül a nsaŋ abɛ! ");
INSERT INTO yns_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wɛɛ isàkal naa mɛ insɔŋà in'fàböŋ a Dweelà a Nzam, ikaswaŋà naa Imwol a Nzam kyàkyàyà akà bɛ. » ");
INSERT INTO yns_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","« Itàkal sye naa nkye mbuur mwɛy kan'kwo ubilà u ndwà a ŋangwal anà ugyɔɔr indiir ande, isàkal naa nde mbuur a ngwal awà ŋàtun'bäm anki in'siŋ? Ungö akun'bäm in'siŋ, nde kan'kwo ugyɔɔr indiir byanswà u ndwà ande. ");
INSERT INTO yns_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mbuur mpa awà anà mɛ, nde kan'kwen anki, mbuur mpa akaböbà anà mɛ, nde wàmupay. ");
INSERT INTO yns_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Undiir awun, mɛ alàkyään naa bàsàdwääl baar nkul a man'be manswà anà mbɛɛy yanswà, wɛɛ bàsàdwääl anki nkul a mbɛɛy a Dweelà In'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mbuur asàtɛn ndaa a insoonà a Mwan a mbuur, nde bàsun'dwääl nkul. Wɛɛ mbuur asàtɛn ndaa a insoonà a Dweelà In'kyɛɛl, bàsun'dwääl anki nkul u mɛɛn mà itàkal u mɛɛn amà isàyà. » ");
INSERT INTO yns_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","« Isàkal naa un'te wà ubwaŋ, mbɛŋ awa ikal ubwaŋ, isàkal naa un'te wà un'be, mbɛŋ awa ikal yàmbe. Ntɔn un'te bàfàyöb u mbɛŋ awa. ");
INSERT INTO yns_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mbil a iyäy! Nkye baar abe asànaa bɛ, bɛ lan'kwo mutɛn ndaa aŋàbwaŋ? Ntɔn ayà ifàtoo u mun a mbuur, ifàfà u mpem ande. ");
INSERT INTO yns_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mbuur aŋàbwaŋ afàwal indiir aŋàbwaŋ unsà un'naaŋ ande wàŋàbwaŋ, wɛɛ mbuur un'be afàwal indiir ibe unsà un'naaŋ ande wube. ");
INSERT INTO yns_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Waa mɛ, mɛ alàkyään naa: kà ilä a nsaŋ, baar bàsàsà in'lɔɔn a ndaa a bunàbun yanswà bàsatɛɛnà ba. ");
INSERT INTO yns_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ntɔn ntɛɛn angye ŋakwo isatsüül mbar. » ");
INSERT INTO yns_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Apan alɔɔŋ a in'kɔɔn amwɛy anà Amfarisi amwɛy bàtɛn a Yɛsu naa: « Un'lɔɔŋ, bi ikwen naa ngye iswɛŋ impà mwɛy. » ");
INSERT INTO yns_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nde kafuur naa: « Nkööl a baar abe anà yà inswem yàmulɔm impà, wɛɛ ba impà asin bàman anki, impà nsil kyà ŋangɔɔm Yɔnas. ");
INSERT INTO yns_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Undiir awun, asànaa Yɔnas kàkyer nde myäänà in'tär anà mpib tär uboo a dum a nsö a kölàköl, abun sye Mwan a mbuur asàkyer myäänà in'tär anà mpib tär ungyɛl a mɛɛn. ");
INSERT INTO yns_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ilä a nsaŋ, baar a Ninivɛ bàsàmbarà kusà a baar a nkööl ayi waa bàsafüün, ntɔn baar a Ninivɛ bàbuul mpem aba mpal bàwem ba an'lɔɔŋ a Yɔnas. Wɛɛ apà, we anà mbuur kan'söön Yɔnas! ");
INSERT INTO yns_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ilä a nsaŋ, mfum un'kaar a Ngyɛl asàmbarà kusà a baar a ŋàbà, ntɔn nde kàfü kwɛl muyàwem an'yeerà a Salɔmun. Waa apà, we anà mbuur kan'söön Salɔmun! » ");
INSERT INTO yns_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","« Uman naa dweelà a làbe lan'too uboo a mbuur, la làfàkyà nsye a ipɔl muleŋ ikal akàyöör, la làsàkɔɔn aman, ");
INSERT INTO yns_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","laa làtɛn la naa: \"Mɛ in'kyer afurà ndwà amɛ kàtoo mɛ.\" Mpal làtol la, làman la ya yà ipɔl, yàŋàkɔɔm anà yàŋàlɔ̈ɔ̈n, ");
INSERT INTO yns_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","apan laa làkyà la mukàwal an'dweelà asin nsambwaar man'söön la unsà ube, laa màbilà ma, màbwaay ma. Mɔ̈ɔ̈ a mbuur awà laa utay wa wàŋàsöönà mɔ̈ɔ̈ kàkäl nde awà kusà. Ya sye isàkal abà akà nkööl a mbe yi. » ");
INSERT INTO yns_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mpal kàkäl Yɛsu muyäm a iköŋ a baar, le ngwän anà atɔŋ ande bàkäl u nsà, ba bàleŋà muyäm anà nde. ");
INSERT INTO yns_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mbuur mwɛy waa kàtɛn a nde naa: « Le, ngwa anà atɔŋ angye bà u nsà anà bàmuleŋà muyäm anà ngye. » ");
INSERT INTO yns_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yɛsu kun'fuur naa: « Maa nà, anà atɔŋ amɛ bànà? » ");
INSERT INTO yns_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Apan, nde kàsilà kɔɔ udu a alɔŋki ande, waa kàtɛn naa: « Le maa anà atɔŋ amɛ. ");
INSERT INTO yns_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ntɔn mbuur wanswà afàlab ukwen a Taaràmɛ awà u du, nde wà un'tɔŋ amɛ wàbaal anà wun'kaar, nde wà maa. » ");
INSERT INTO yns_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ilä akin, Yɛsu kàtoo u ndwà, waa kàkàbwaay ukɔl a ɛwà. ");
INSERT INTO yns_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iköŋ a baar kyàyàkwo tsütsü apà nde, nde kàbilà u bwaar, waa kàbwaay. Un'sɛŋ a baar wanswà kàkäl u nkankyel. ");
INSERT INTO yns_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nde kàyääm anà ba indiir mbɔɔn u nsim, waa kàtɛn a ba naa: « Ilä mwɛy, un'köön mwɛy kàkyer atoo mukàkɔn mbɛŋ u ywaŋ ande. ");
INSERT INTO yns_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Umpal kàmwɛŋ nde ya, yar làmwɛy làbü ukɔl a mbwo: nɛn a du laa yàyi ya, waa yàdi ya. ");
INSERT INTO yns_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yar lumwɛy làbü udu a in'kul mpa myàkäl anà mɛɛn mbɔɔn. Mbɛŋ yàmɛn agyägyä, ntɔn mɛɛn màkäl itääŋ. ");
INSERT INTO yns_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wɛɛ umpal kàbalà mwäänà, bite waa byàkuŋà, byàyöm, ntɔn bya byàkäl anki anà in'swɛy. ");
INSERT INTO yns_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yar lumwɛy làbü uboo a nsyeenà: nsyeenà yàyɛl ya, laa yàküünà ya bite aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Wɛɛ mbɛŋ yumwɛy yàbü udu a mɛɛn aŋàbwaŋ, waa byàbör imfà: imwɛy nkam, kyumwɛy an'kwem an'syaam, kyumwɛy an'kwem an'tär. ");
INSERT INTO yns_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wɛy mbuur awe anà an'tsü awem uwem! » ");
INSERT INTO yns_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Apan, alɔŋki bàyàsin apà nde, waa bun'fuul naa: « Ntɔn nkye ayiyääm ngye anà ba u nsim? » ");
INSERT INTO yns_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nde kafuur naa: « Bɛ, bɛ làkyàwal an'yeerà a inkuu a imfum a du, wɛɛ ba, ba ma bàwɛl anki. ");
INSERT INTO yns_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mbuur awe anà undiir, nde bàkyer asun'pà, waa nde usàkal abyà mbɔɔn, wɛɛ akà mbuur mpa awe anà wa, bàsàlwom itàkal undiir awe nde awà. ");
INSERT INTO yns_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Undiir awun in'fàyääm mɛ anà ba unsà nsim: Ntɔn, ba bàmulerà ukɔɔn aman, anà bàmulɛɛ tsü ukɔɔn awem anà ukɔɔn ayöb. ");
INSERT INTO yns_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Abun, ngɔɔm kàtɛ Yɛsay wà kan'kwo ntɔn ba: \"Bɛ làsàwem ubwaŋàbwaŋ, wɛɛ bɛ, bɛ làsàyöb anki, bɛ làsàler ubwaŋàbwaŋ, wɛɛ bɛ, bɛ làsàman anki. ");
INSERT INTO yns_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ntɔn mpem a un'sɛŋ awà yàkyàbwà ikwabà, ba bàkyàdübà an'tsü aba, ba bàkyàdübà mii aba ntɔn mii aba myàkɔ̈ɔ̈n aman, an'tsü aba màkɔ̈ɔ̈n awem, mpem aba ikɔ̈ɔ̈n ayöb, abun ba bàkɔ̈ɔ̈n abuul mpem, anà mɛ in'kɔ̈ɔ̈n akɔɔr.\" » ");
INSERT INTO yns_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","« Wɛɛ akà bɛ, bɛ làbà unsà un'sak, ntɔn mii abɛ myà mutäälà anà an'tsü abɛ mà muweemà! ");
INSERT INTO yns_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ndandaa mɛ alàkyään, aŋangɔɔm anà baar a balàbal mbɔɔn bàlàkwen muman ndaa ayà làmanà bɛ yi, wɛɛ ba ya bàsàman anki, muwem ndaa làweemà bɛ yi, wɛɛ ba ya bàsàwem anki. » ");
INSERT INTO yns_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","« Mpalabà, làwem mbuul a itim a un'köön. ");
INSERT INTO yns_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Isàkal naa mbuur kan'wem ndaa a Imwol, wɛɛ nde ya uyöbà anki, imɛnà naa mbuur un'be kan'yà anà kan'lwom ndaa bàkön u mpem ande. Nde wà asànaa mbɛŋ yàbü ukɔl a mbwo. ");
INSERT INTO yns_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Baar bumwɛy bà asànaa yar a mbɛŋ alà làbü u mɛɛn a in'kul, wà mbuur kan'wal Ndaa agyägyä unsà un'sak. ");
INSERT INTO yns_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wɛɛ uboo ande in'swɛy myatɛy, nde wà mbuur a ansɔŋà: isàkal naa lingyoomà lan'yà itàkal nkwaaŋ ntɔn Ndaa, laa ubwà nde. ");
INSERT INTO yns_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbɛŋ ayà bàkön uboo a nsyeenà, yà asànaa mbuur kan'wem Ndaa, wɛɛ nkyän a indiir a mɛɛn mà anà ndɛb a in'naaŋ laa iküünà bya Ndaa, waa ya mpa ibɔr imbɛŋ. ");
INSERT INTO yns_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yar bàkön u mɛɛn aŋàbwaŋ, là baar bàfàwem Ndaa anà bàfàyöb ya. Apan ba bàfàbɔr mbɛŋ: amwɛy nkam, bumwɛy an'kwem an'syaam, bumwɛy an'kwem an'tär. » ");
INSERT INTO yns_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yɛsu kàfatɛɛl nsim asin: « Imwol a du kyà asànaa mbuur mwɛy kàkön imbɛŋ aŋàbwaŋ u ywaŋ ande. ");
INSERT INTO yns_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wɛɛ utaaŋ bàkäl baar mubɔ̈ɔ̈n, un'yiiŋ ande waa kàyi, waa kàkön iteerà uboo a blɛ, laa kàkyen nde. ");
INSERT INTO yns_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mpal làyɛl blɛ anà imfà byàsɛmà bya mutoo, iteerà sye waa byàyàsɛnà mbwo mwɛy anà bya. ");
INSERT INTO yns_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Asyääl a ŋaywaŋ bayi mukun'fuul naa: \"Nkum, nkye kà imbɛŋ aŋàbwaŋ anki ngye kàkön u ywaŋ angye? Wɛɛ iteerà binà byan'fà ken?\" ");
INSERT INTO yns_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nde kafuur naa: \"Un'yiiŋ mwɛy kàkyer abun.\" Asyääl waa bun'fuul naa: \"Nkye ngye akyàkwen naa bi ikàlwom bya?\" ");
INSERT INTO yns_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nde kàtɛn a ba naa: \"Aay, manà bɛ làyàkàtsuum blɛ mbwo mwɛy anà iteerà. ");
INSERT INTO yns_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Làwɛy bya byàbyeel byàyɛl mbwo mwɛy tii u paŋà abwo bya. Mpal ayin mɛ in'sàtɛn a abweel naa: Tàlalwoomà iteerà, làbäm bya ibiŋ ntɔn musà bya mbaa. Ungö, làbwe imfà, làsi blɛ unsà ikɔr amɛ.\" » ");
INSERT INTO yns_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yɛsu kàfatɛɛl nsim asin naa: « Imwol a du kyà asànaa mbuur mwɛy kan'wal imbɛŋ ikikye anà kan'kɔn kya u ywaŋ ande. ");
INSERT INTO yns_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Imbɛŋ aki kyà imbɛŋ mwɛy kyan'söön ukye uboo a mbɛŋ yanswà. Wɛɛ kya isàyɛl, kya ifàbulà un'te mwɛy wà kölàköl. Apan, nɛn a du iyàtɔŋ an'yaab aya kan'kɔkà a wa. » ");
INSERT INTO yns_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yɛsu kàfatɛɛl nsim asin naa: « Imwol a du kyà asànaa ful kàwɛl un'kaar mwɛy anà kàbünà nde anà an'kɔɔb an'tär mà mfufu a mampà. Ungö apan mfar yanswà waa yàfül. » ");
INSERT INTO yns_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ndaa ayin yanswà Yɛsu ba ya kakyäänà u nsim, akà ndaa mwɛy yatɛy kàtɛɛnà nde anà ba ukɔɔn nsim, ");
INSERT INTO yns_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ntɔn ndaa ayà kàtɛn ŋangɔɔm ikwe: « Mɛ in'sàduub mun amɛ mutà nsim, mɛ in'sakyään indiir aŋàyee sɛmà bàkyer mɛɛn. » ");
INSERT INTO yns_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Apan Yɛsu kàsàwɛy iköŋ a baar, waa kàkyen ndwà. Alɔŋki ande bàsin apà nde, waa bàtɛn a nde naa: « Ibuul nsim a iteerà uboo a ywaŋ. » ");
INSERT INTO yns_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nde kafuur abà: « Mbuur afàkɔn imbɛŋ aŋàbwaŋ, Mwan a mbuur, ");
INSERT INTO yns_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ywaŋ là mɛɛn mà, imbɛŋ aŋàbwaŋ bà baan abà uboo a Imwol, iteerà ikaswaŋà baan a Mbuur un'be. ");
INSERT INTO yns_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ŋankir kàkön iteerà wà ileŋ, mbweel a imbɛŋ yà ntsüü a mɛɛn mà, wɛɛ abweel bà akyeey. ");
INSERT INTO yns_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Abun, asànaa bàfàtsuum iteerà ntɔn musà bya mbaa, ya sye isàkal abwɛy u ntsüü a mɛɛn: ");
INSERT INTO yns_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwan a mbuur asàtɔm akyeey ande mulwom uboo a Imwol ande, ndaa yanswà ifàsiinà baar mukyer ube anà baar bàfàyweer ndaa a mbe, ");
INSERT INTO yns_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","waa bàsatɔɔm u yaaŋ a mbaa. Akun ntsü isàkal ilel anà nkwoor a an'din. ");
INSERT INTO yns_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Apan, baar a balàbal bàsàtà in'nyäŋ uboo a Imwol a Taaràba asànaa taaŋ. Wɛy mbuur awe anà an'tsü awem uwem! » ");
INSERT INTO yns_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","« Imwol a du kyà asànaa undiir a ntal wàŋàyee u mɛɛn uboo a ywaŋ làmwɛy, waa mbuur mwɛy kàmɛn wa: nde kan'fàyee wa. Unsà un'sak, nde waa ukyà, uyälà indiir ande byanswà ntɔn musom ywaŋ alà. » ");
INSERT INTO yns_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","« Le, Imwol a du kyan'kwo ifàkal asànaa un'tɛɛl a an'yà ayileŋ mpɛr aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Utaaŋ kàmɛn nde làpɛr làmwɛy làntal a kölàköl, nde kàkàyälà indiir ande byanswà ntɔn musom làpɛr alà. » ");
INSERT INTO yns_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","« Imwol adu kyan'kwo bàfàsi anà an'tɛy mwɛy ban'tɔɔm kà ɛwà anà man'siim nsö a ifà ifà. ");
INSERT INTO yns_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ma isàyɔl, alɔ̈ɔ̈b waa bànaan ma u nkankyel, waa bàbwaay, bàsà nsö aŋàbwaŋ uboo a un'lwaŋ, waa bàpiy indiir ikɔ̈ɔ̈n ndöŋ. ");
INSERT INTO yns_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ya sye isàkal abun u ntsüü a mɛɛn: akyeey bàsàyà ntɔn mukaab baar abe anà baar a balàbal, ");
INSERT INTO yns_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","waa bàsàtɔɔm baar abe u yaaŋ a mbaa. Akun ntsü isàkal ilel anà nkwoor a an'din. » ");
INSERT INTO yns_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Abun, Yɛsu kafuul naa: « Nkye bɛ, bɛ làkiyöbà indiir abi byanswà? » Ba bàfuur naa: « Ɛɛ » ");
INSERT INTO yns_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nde kakyään naa: « Lalan, un'lɔɔŋ a un'kɔɔn wanswà kan'wal an'yeerà unsà Imwol a du, asàkal asànaa ŋandwà mwɛy afàwal indiir akün anà byà itaan uboo a un'naaŋ ande. » ");
INSERT INTO yns_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mpal kàmay Yɛsu mutɛn unsà nsim, nde kàlwomà kà ikal akin. ");
INSERT INTO yns_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Apan nde kàkyen nsi ande, waa kàlɔɔŋà u ndwà a nköŋ a Ayudà aba. Baar bàkäl pa bàkyer abem, waa bàtɛɛnà naa: « An'yeerà ande amà anà impà abi byan'fà ken? ");
INSERT INTO yns_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nkye nde kà mwan a sharpantye anki? Nkye ngwän ande kà Màlye anki? Nkye Zyak, Yɔsɛfi, Simɔn anà Yude kà atɔŋ ande anki? ");
INSERT INTO yns_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nkye ampääŋ ande banswà kà bà uboo a bi anki? Ikɔ̈b aki kyanswà, nde kya kyan'fà ken? » ");
INSERT INTO yns_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Lalan mpa bàsi ba làkwikilà amu nde. Yɛsu waa kàtɛn a ba naa: « Ŋangɔɔm wanswà bàfun'bɛy u nsi ande anà u ywar ande. » ");
INSERT INTO yns_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Apan, Yɛsu kàsàkyer anki impà mbɔɔn u bul alan, ntɔn nkɔ̈ɔ̈n a làkwikilà aba. ");
INSERT INTO yns_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Utaaŋ alan, Ɛlɔdi, kuvɛrnɔ̈ɔ̈r a Ngalilɛ, kàwem nde làkoo a Yɛsu, ");
INSERT INTO yns_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nde kàtɛn a asyääl ande naa: « Wawɛy Ywan Un'düümà kan'wiyà uboo a akü! Undiir awun awà nde anà ikɔ̈b mukyer impà! » ");
INSERT INTO yns_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yàmɛnà naa Ɛlɔdi kàswɛŋ baar mukɔr Ywan, mukun'bäm dwaaŋ anà mukun'biil u bɔlokà. Ntɔn kàwɛl nde Ilɔdyas, un'kyay a un'tɔŋ ande Filipo. ");
INSERT INTO yns_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ntɔn Ywan kàtɛɛnà a nde naa: « Ikwe anki naa ngye un'wɛl un'kyay! » ");
INSERT INTO yns_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Itàkal naa Ɛlɔdi kàkwen mudwa Ywan, nde kàtiinà un'sɛŋ a baar bɔɔmà ntɔn ba Ywan bàfun'walà asànaa ŋangɔɔm. ");
INSERT INTO yns_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Apan, kilä a un'kyɔm a mböör a Ɛlɔdi, mwan a Ɛlɔdyadi wà un'kaar kàyàkyen kusà a baar kàbel nde, un'sak laa kàwɛl wa Ɛlɔdi. ");
INSERT INTO yns_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Undiir awun, kàdi nde kyän mukun'pà undiir wanswà kàlun'lɔ̈ɔ̈m nde. ");
INSERT INTO yns_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Apan, u nswɛɛŋ a ngwän, nde kàtɛn a Ɛlɔdi naa: « Mpɛ un'tswe a Ywan Udüümà, apà, udu a làlɔŋà! » ");
INSERT INTO yns_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mfum kàwɛm ngyɛb ntɔn ya. Wɛɛ ntɔn kyän ande anà baar kàbel nde, nde kàswɛŋ naa bun'pɛ wa. ");
INSERT INTO yns_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nde kàtöm baar mukàtsul Ywan un'tswe u bɔlokà. ");
INSERT INTO yns_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ba bàtwääl un'tswe a Ywan udu a làlɔŋà, waa bàpɛ wa akà mwan un'kaar, nde waa kàsyen wa akà ngwän. ");
INSERT INTO yns_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Alɔŋki a Ywan laa bàyi ba muwal ndom ande, waa bàkàdyee ya. Ungö ba bàkàkyään Yɛsu ndaa ayi. ");
INSERT INTO yns_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mpal kàwem Yɛsu làsaŋ alà, nde kàlwomà kà ikal akin, kàbilà u bwaar, waa kàkyen ikal a mpey. In'sɛŋ a an'bul myàyöb mya, fà an'bul aba, ba bun'läb kà in'kɔl. ");
INSERT INTO yns_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mpal kàtoo Yɛsu u bwaar, nde kàmɛn iköŋ a baar, laa kamɛɛn nde ngyɛb a kölàköl, waa kàkɔɔr an'too aba. ");
INSERT INTO yns_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mpal làbü sisye, alɔŋki bàsin tsütsü apà nde, waa bàtɛn a nde naa: « Ikal ki kyà ipɔl, taaŋ sye lan'kyà itaan. Apay baar bàkyen ba ŋakwo bàkàsom isa adyà kan'bul. » ");
INSERT INTO yns_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yɛsu kafuur naa: « Ba mfun akyà yatɛy, lapɛ isa adyà bɛ ŋakwo! » ");
INSERT INTO yns_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wɛɛ ba bàtɛn a nde naa: « Apà bi ibye anà mampà an'tyeen anà nsö yweel mpɛl. » ");
INSERT INTO yns_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nde kàtɛn naa: « Lan'twääl abyà kà. » ");
INSERT INTO yns_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Apan, ungö muswaŋ iköŋ a baar mubwaay udu a in'lɛŋ, nde kàwɛl mampà aman man'tyeen anà nsö yàyweel, kàler u du, waa kàsaak bya. Ungö, nde kàtsütsül mampà, waa kàpɛ ma akà alɔŋki, ba waa bàkàkäb ma akà iköŋ a baar. ");
INSERT INTO yns_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Baar banswà waa bàdi, waa bàyüür. Ba bàsyen in'lwaŋ kwem aŋiyweel myàŋàyɔl a itiir byàsäl. ");
INSERT INTO yns_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Baar bàdi bàkäl isii a abaal nsaab tyeen, ukɔɔn ataŋ akaar anà baan. ");
INSERT INTO yns_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Apan sye, Yɛsu kàswɛŋ alɔŋki mubilà u bwaar ntɔn ba bàfwel u sim, mpal usàpay nde in'sɛŋ. ");
INSERT INTO yns_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ungö kàpay nde iköŋ a baar, nde kàbeenà udu a mɔŋ ntɔn mukàyamà u mpey. Nde kàkäl kwo aŋàyen tii u sisye. ");
INSERT INTO yns_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bwaar làkäl lan'tol kwɛl a mɛɛn, ibɔ a an'dà byàkäl muyisiinà la ntɔn un'pöb kàyee lisà. ");
INSERT INTO yns_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tsütsü a taaŋtyà, Yɛsu kàkyen udu a an'dà mper akà ba. ");
INSERT INTO yns_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Umpal bun'mɛn ba wàmuyikyà udu a an'dà, alɔŋki bàkyer atɛɛr, waa bàtɛɛnà naa: « Wà un'sɔŋà! » Unsà bɔɔmà lanswà, ba bàsi in'kwɛŋ. ");
INSERT INTO yns_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Wɛɛ apan, Yɛsu kàtɛn a ba naa: « Làsi un'kanà. Wà mɛ, twon lan'man bɔɔmà! » ");
INSERT INTO yns_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petɔlà kàtɛn a nde naa: « Mwol, kya isàkal ndandaa naa wà ngye, nswɛŋ mɛ in'yi akà ngye udu a an'dà. » ");
INSERT INTO yns_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yɛsu kun'fuur naa: « Yà! » Petɔlà waa kàtoo u bwaar, waa kàkyen udu a an'dà mper kàkäl Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wɛɛ umpal kàmɛn nde un'pöb a ngwal, bɔɔmà làkyer un'kaar. Nde kàsɛmà muminà uboo a an'dà, waa kàsi in'kwɛŋ naa: « Mwol, an'tsü mɔ̈ɔ̈! » ");
INSERT INTO yns_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Apan, Yɛsu kàsilà kɔɔ, kun'tɛ mpi, waa kàtɛn a nde naa: « Mbuur a làkwikilà a ikikye! Ntɔn nkye asi ngye nkyɛɛr? » ");
INSERT INTO yns_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Umpal bàbilà ba u bwaar, un'pöb waa kànye. ");
INSERT INTO yns_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Abun, baar bàkäl uboo a bwaar bàbü an'köm kusà a Yɛsu, waa bàtɛn a nde naa: « Ndandaa, ngye awà Mwan a Nzam! » ");
INSERT INTO yns_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ungö bàsabà ba ɛwà, ba bàtöl u Ngɛnɛsàlɛr. ");
INSERT INTO yns_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Baar a mper ayin bun'yöb ba, ba bàpay làsaŋ mper yanswà, waa bun'twäälà abɛy banswà. ");
INSERT INTO yns_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ba bun'bɔ̈ɔ̈nà naa nde kapɛ mbwo ba bàbä itàkal làpan a ipfɛy ande mpɛl. Abun, baar bàtɛɛ kya mpi bàkyer akɔɔrà. ");
INSERT INTO yns_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Apan, Amfarisi anà alɔɔŋ a in'kɔɔn bàfü Yɛlusàlɛm, bàyi akà Yɛsu, waa bun'fuul naa: ");
INSERT INTO yns_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","« Ntɔn nkye alɔŋki angye bàfàbɛy ba nkääl abi? Ntɔn ba bàfàywɛy anki an'kɔɔ mpal bàfàdyà ba. » ");
INSERT INTO yns_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nde kafuur naa: « Atöl bɛ, ntɔn nkye làfàbɛy bɛ nswɛɛŋ a Nzam ntɔn nkääl abɛ? ");
INSERT INTO yns_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ntɔn Nzam kàtɛn naa: \"Sà làkoo akà taaràŋà anà akà ngwa\", anà: \"Mbuur asàküül taarànde anà ngwän, bàkyer asun'dwa.\" ");
INSERT INTO yns_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wɛɛ bɛ, bɛ làfàtɛn naa: \"Mbuur wanswà afàtɛn a taarànde itàkal a ngwän naa: Undiir in'lapà mɛ, mɛ wa in'kyàpà akà Nzam\", ");
INSERT INTO yns_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mbuur awun, nde kun'kömà anki taarànde.\" Abun, bɛ làkyàpiy Ndaa a Nzam, ntɔn nkääl abɛ. ");
INSERT INTO yns_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Baar a mpem yweel! Yɛsay we anà iböŋ kàtɛ nde ngɔɔm ntɔn bɛ, mpal kàtɛn nde naa: ");
INSERT INTO yns_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","\"Un'sɛŋ wà afan'pà làkoo a mun, wɛɛ mpem awa yà ukwɛl anà mɛ. ");
INSERT INTO yns_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ngyamàkà bàfan'sà ba yà bunàbun, ntɔn ndaa bàfàlɔŋ ba, yà ndaa a imbuur mpɛl.\" » ");
INSERT INTO yns_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Apan,Yɛsu kàbel iköŋ a baar, waa kàtɛn a ba naa: « Làwem anà làyöb! ");
INSERT INTO yns_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kà indiir byàfàbilà u mun a mbuur byàfun'buul ŋingyäy anki, wɛɛ indiir byàfàtoo u mun byàfun'buul ŋingyäy. » ");
INSERT INTO yns_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Apan, alɔŋki bàyi akà Yɛsu, waa bàtɛn a nde naa: « Nkye ngye akyàyöb naa Amfarisi bàwem ba ndaa ayi, ya yapɛ mpay? » ");
INSERT INTO yns_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nde waa kàfuur naa: « Kite kyanswà mpa kàkön Taaràmɛ awà u du, bàkyer asàtsuum kya. ");
INSERT INTO yns_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Lawɛy: ba bà ikwàmii bàyisyen ikwàmii bumwɛy! Isàkal naa ikwàmii wàmuyisyen ikwàmii wumwɛy, ba bàbɔ̈ɔ̈l bàkàbwà u fu. » ");
INSERT INTO yns_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petɔlà kàwɛl ndaa, waa kàtɛn a nde naa: « Ibuul nsim ayi. » ");
INSERT INTO yns_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yɛsu kàtɛn naa: « Nkye anà bɛ, bɛ sye un'yɛnà watɛy? ");
INSERT INTO yns_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nkye bɛ làyöb anki naa undiir wanswà afàbilà u mun, afàlyaŋ uboo a an'bäl, ungö waa bàkàpiy u kàbenà? ");
INSERT INTO yns_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wɛɛ ndaa ifàtoo u mun ifàfà u mpem, ya ifàbuul mbuur ŋingyäy. ");
INSERT INTO yns_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ntɔn an'kyän an'be, ndwää a baar, inswem, ipasàsɛ, küb, imbäl ibe, ntwee byàfàfà u mpem. ");
INSERT INTO yns_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Le, byabi byà indiir byàfàbuul mbuur ŋingyäy! Wɛɛ mudyà ukɔɔn aywab mpin ifàbuul anki mbuur ŋingyäy. » ");
INSERT INTO yns_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ungö apan, Yɛsu kàlwomà paa, waa kàkyen itiir a nsi a Tir anà kyà Sidɔn. ");
INSERT INTO yns_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Waa le, un'kaar mwɛy un'nsi Kanana kàfü ntsü ayin, waa kàsi in'kwɛŋ: « Mwol, Mwan a David, nsyääm! Mwan amɛ wà un'kaar we anà unsɔŋà mwɛy afun'sà lingyoomà mbɔɔn. » ");
INSERT INTO yns_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wɛɛ Yɛsu kun'fuur anki akà ndaa mwɛy. Alɔŋki ande laa bàsin ba, waa bun'lɔ̈ɔ̈m naa: « Un'böŋ, ntɔn nde wàmuyilab bi anà in'kwɛŋ ande. » ");
INSERT INTO yns_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yɛsu kàfuur naa: « Mɛ, mɛ ban'töm akà in'kɔk a Isàlɛl myàŋàdiimà mbwo mpɛl. » ");
INSERT INTO yns_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wɛɛ un'kaar awà kàyàbwà an'köm kusà a nde, waa kàtɛn naa: « Mwol, yambay! » ");
INSERT INTO yns_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yɛsu kàfuur naa: « Ubwaŋ batɛy muwal mampà a baan anà mutɔɔm ma akà bibaan a mbwà. » ");
INSERT INTO yns_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Un'kaar awà kàfuur naa: « Inye, ndandaa Mwol, wɛɛ mbwà sye ifàdyà mfür ifàbwà u ngyɛl a mɛsà a nkum aba. » ");
INSERT INTO yns_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Apan, Yɛsu kun'fuur naa: « Ɔɔ un'kaar! Làkwikilà angye là làkölàköl! Wɛy ya ikäl asànaa ikwen mpem angye. » Taaŋ nsil alan, mwan ande waa kàkɔɔrà. ");
INSERT INTO yns_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Fà apan, Yɛsu kàyikyenà kà un'kɔɔl a ɛwà a Ngalilɛ. Nde kàlär udu a mɔŋ, waa kàbwaay. ");
INSERT INTO yns_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Baar mbɔɔn bàyàköŋ apà nde, waa bàtwäälà ikar, ikwàmii, aŋatoo, nkiin, anà abɛy asin bàmbɔɔn. Ba batɔ̈ɔ̈là kà in'kɔl a Yɛsu, nde waa kakɔɔrà. ");
INSERT INTO yns_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Baar bàkyer abem mpal bàmɛn ba naa nkiin ban'sà ndaa, aŋatoo ban'kɔɔrà, akyeen a ibweel ban'dyäär, ikwàmii ban'man. Waa bàsɛmà mukömà Nzam a Isàlɛl. ");
INSERT INTO yns_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yɛsu kàbel alɔŋki ande, waa kàtɛn a ba naa: « Mpem amɛ yan'kyɛɛr ntɔn baar bà, ntɔn ŋàbà byan'kwo ilä itär abà ba anà mɛ apà. Wɛɛ ba, ba undiir adyà watɛy. Mɛ in'kwen anki mukapay anà ngyal, manà ngwal aba ikàwà u mbwo. » ");
INSERT INTO yns_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Alɔŋki bun'fuul naa: « U nsye a ipɔl yi bi mampà ifà ken mudii un'kàbɔ a baar a tub awà? » ");
INSERT INTO yns_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yɛsu kafuul naa: « Bɛ làbye amà mampà an'kwe? » Ba bàfuur naa: « Nsambwaar anà binsö imwɛy. » ");
INSERT INTO yns_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Apan, nde kàswɛŋ iköŋ a baar mubwaay u mɛɛn. ");
INSERT INTO yns_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nde kàwɛl mampà aman mà nsambwaar anà nsö, kàkömà Nzam, kàtsül ma, waa kàpɛ alɔŋki mukab akà baar banswà. ");
INSERT INTO yns_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ba banswà waa bàdi, waa bàyüür. Ba bàsyen in'lwaŋ nsambwaar myàŋàyɔl a itsü byàsäl. ");
INSERT INTO yns_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Baar banswà bàdi bàkäl isii a nsaab nà, ukɔɔn ataŋ akaar anà baan. ");
INSERT INTO yns_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ungö kàpay nde iköŋ a baar, Yɛsu kàbilà u bwaar, waa kàkyen itiir a nsi a Makadan. ");
INSERT INTO yns_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amfarisi anà Asadusi bàyi akà Yɛsu ntɔn mukun'lɛɛ untaam. Ba bun'lɔ̈ɔ̈m idiim mwɛy kyan'fà du. ");
INSERT INTO yns_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nde kafuur naa: « Umpal làfàkàminà taaŋ, bɛ làfàtɛn naa: \"Du làyàkal ubwaŋ ntɔn la là làtsöö.\" ");
INSERT INTO yns_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ututu naa: \"Mbul akyer anɔ ŋàbà, ntɔn du lan'yeen.\" Bɛ, bɛ làyöb nà musyeebà mpɛl naa du lye aben, wɛɛ idiim a an'taaŋ bɛ làkwo anki muyöb bya! ");
INSERT INTO yns_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nkööl a baar abe anà yà inswem yàmulɔm idiim. Wɛɛ akà idiim asin bàsun'pà anki, idiim nsil kyà Yɔnas. » Nde laa kàsawɛy nde, waa kàkyen. ");
INSERT INTO yns_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mpal bàsabà alɔŋki u sim lumwɛy, ba bàkyärà mpiim muwal mampà. ");
INSERT INTO yns_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yɛsu kàtɛn a ba naa: « Làkäl kà igyɛɛŋ ntɔn ful a Amfarisi anà Asadusi! » ");
INSERT INTO yns_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Alɔŋki bàyweerà abà: « Ntɔn bi mampà iwɛl anki. » ");
INSERT INTO yns_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Wɛɛ Yɛsu kàmɛn nde an'kyän aba, nde kàtɛn a ba naa: « Baar a làkwikilà a ikikye, ntɔn nkye làkayweerà bɛ ntɔn làkɔ̈ɔ̈n bɛ mampà? ");
INSERT INTO yns_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bɛ ŋàtàyöb anki? Bɛ làfàkayɔbà anki mampà an'tyeen ntɔn nsaab tyeen, anà in'lwaŋ in'kwe bɛ làsyen? ");
INSERT INTO yns_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Itàkal mampà nsambwaar ntɔn nsaab nà, anà in'lwaŋ in'kwe bɛ làsyen? ");
INSERT INTO yns_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bɛ làkɔɔn akayöbà aben naa kà ntɔn mampà anki in'tɛɛnà mɛ a bɛ naa: Làkäl kà igyɛɛŋ ntɔn ful a Amfarisi anà Asadusi! » ");
INSERT INTO yns_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Apan, ba bàyöb naa nde kàtɛɛnà anki a ba mukal kà igyɛɛŋ ntɔn ful a mampà, wɛɛ ntɔn an'lɔɔŋ a Amfarisi anà Asadusi. ");
INSERT INTO yns_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Umpal kàkɔlà nde kà itiir a nsi a Sɛzarɛ u Filipe, Yɛsu kàfuul alɔŋki ande naa: « Baar bàfàtɛn naa Mwan a mbuur wa nà? » ");
INSERT INTO yns_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ba bàtɛn naa: « Ntɔn bumwɛy, Ywan Un'düümà, bumwɛy naa Ԑli, bumwɛy naa Yɛlɛmya, taaŋ lumwɛy naa umwɛy uboo a aŋangɔɔm. » ");
INSERT INTO yns_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nde waa kàtɛn a ba naa: « Atöl bɛ, bɛ làfàtɛn naa mɛ in'wà nà? » ");
INSERT INTO yns_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simɔn Petɔlà kàfuur naa: « Ngye, Ngye awà Klistɔ, Mwan a Nzam a mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Apan, Yɛsu waa kun'kyään naa: « Un'sak akà ngye Simɔn, mwan a Yɔnas, ntɔn kà ngye ŋakwo anki an'yöb ya, wɛɛ Taaràmɛ awà u du kàmayɔɔb. ");
INSERT INTO yns_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Waa mɛ, mɛ akyään naa ngye awà nkɔŋ, udu a nkɔŋ ayi mɛ in'sàtɔŋ Ikööŋ amɛ, ngwal a ukwà isàkal anki anà ikɔ̈b udu a kya. ");
INSERT INTO yns_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mɛ in'sapà nsab a Imwol a du: Undiir wanswà asàbäm ngye u mɛɛn, wa sye asàkal wàŋàbäm u du, undiir wanswà asàtsuuŋ ngye u mɛɛn, wa asàkal wàŋàtsuuŋ u du. » ");
INSERT INTO yns_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Apan, Yɛsu kàswɛŋ alɔŋki ande a ngwal naa ba bàkɔɔn akyään baar naa nde wà Klistɔ. ");
INSERT INTO yns_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Fà taaŋ alan, Yɛsu kàsɛmà muswaŋ alɔŋki ande naa yan'kwo naa nde ubeenà Yɛlusàlɛm, ukàman mpay mbɔɔn kà an'kɔɔ a andweer, a amfum a angaŋ anà mà alɔɔŋ a Un'kɔɔn. Ba bàkyer akun'dwa, wɛɛ kà ilä kyàtär nde akyer asàwiyà. ");
INSERT INTO yns_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petɔlà kun'bel ukɔl, waa kàsɛmà mukun'ŋän anà mutɛn naa: « Mwol, Nzam akyer ayabay, ndaa ayi iyabweel anki! » ");
INSERT INTO yns_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Wɛɛ nde, kàbulà nde, waa kàtɛn a Petɔlà: « Kyà kunà, Satanà! Lwomà apà mɛ pà! Ngye awà kyà u mbwo amɛ, ntɔn an'kyän angye kà mà an'kyän a Nzam anki, wɛɛ mà baar. » ");
INSERT INTO yns_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Apan, Yɛsu kàtɛn a alɔŋki ande naa: « Isàkal naa mbuur akwen mukan'lab, wɛy nde ukɔɔb mɔ̈ɔ̈ ande ŋakwo, uwɛl kulunsi ande, wɛy nde kan'läb. ");
INSERT INTO yns_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ntɔn mbuur usàkwen mutswà möö ande, wa asàkyà bwà. Wɛɛ mbuur usàpiy möö ande ntɔn mɛ, nde asàtswà wa. ");
INSERT INTO yns_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bweel nà mbuur usàkal abà, itàkal naa nde kan'wal mɛɛn aŋukiinà, wɛɛ mɔ̈ɔ̈ ande ukyà bwà? Itàkal naa undiir nà wà ndöŋ mbuur kan'kwo mupà ntɔn musom mɔ̈ɔ̈ ande? ");
INSERT INTO yns_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ntɔn Mwan a mbuur asàyà unsà làkoo a Taarànde anà akyeey ande, apan nde asàfuur akà mbuur mbuur asànaa yàkäl nsyääl ande. ");
INSERT INTO yns_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mɛ, mɛ alàkyään ndandaa naa amwɛy uboo a baar bà pà bàsàkal aŋàkwà anki kusà muman Mwan a mbuur wàmuyà unsà imwol ande. » ");
INSERT INTO yns_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ungö a ilä isyaam, Yɛsu kàwɛl Petɔlà, Zyak anà un'tɔŋ ande Ywan, nde kasyen u mpey udu a mɔŋ mwɛy wàbwɛlàbwɛl. ");
INSERT INTO yns_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nde kàsɔɔmà ifà u mii aba: ntabwey ande yàkäl muŋyäŋ asànaa taaŋ, ipfɛy ande byàbulà byà tsɛk tsɛk asànaa pɛɛlà. ");
INSERT INTO yns_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kà imbürà, alɔŋki batär bàmɛn Mɔsɛ anà Ɛli bàmuyäämà anà nde. ");
INSERT INTO yns_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petɔlà kàtɛn a Yɛsu naa: « Mwol, yan'söön ubwaŋ bi mukal apà. Kya ngye asàkwen, mɛ in'töŋ ntɛn, ntɛn tär: mwɛy ntɔn ngye, mwɛy ntɔn Mɔsɛ, mwɛy ntɔn Ɛli. » ");
INSERT INTO yns_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mpal kàkäl nde mutɛɛnà, tööb a uŋyäŋ laa lafwee la. Ndaa yàtoo uboo a tööb alan, waa yàtɛn naa: « Wawà, Mwan amɛ, nkwen amɛ, mpem amɛ yanswà ye amu nde. Lun'wem! » ");
INSERT INTO yns_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mpal bàwem alɔŋki ndaa ayi, ba bàmɛn bɔɔmà mbɔɔn, waa bàbü bàŋàtsüüm. ");
INSERT INTO yns_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yɛsu kàsin tsütsü apà ba, kabä, waa kàtɛn naa: « Làmbarà, twon lan'man bɔɔmà. » ");
INSERT INTO yns_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Apan, ba bàsuub un'tswe, ba bàfàman anki mbuur asin, nà Yɛsu ŋakwo mpɛl. ");
INSERT INTO yns_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mpal bàkäl ba muyàtyà u mɔŋ, Yɛsu kaswɛŋ naa: « Iman mii ki, twon lan'kyään kya mbuur asin tii umpal usàwiyà Mwan a mbuur kà ukwà. » ");
INSERT INTO yns_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ungö apan, alɔŋki bàfuul Yɛsu naa: « Ntɔn nkye alɔɔŋ a in'kɔɔn bàtɛn ba naa Ɛli atwab atàyà? » ");
INSERT INTO yns_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nde kafuur naa: « Yà abun naa Ɛli atwab atàyà ntɔn mulɔn ndaa yanswà. ");
INSERT INTO yns_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Wɛɛ mɛ, mɛ alàkyään naa Ɛli wa kàkyàyà itaan, wɛɛ baar bun'kyey anki, ba bun'kyer ndaa yanswà ayà bàkwen ba. Ba Mwan a mbuur sye bàsun'tà an'kaal. » ");
INSERT INTO yns_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Abun, alɔŋki bàsii naa nde akatɛɛnà ntɔn Ywan Un'düümà. ");
INSERT INTO yns_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Utaaŋ bàyàkɔlà ba kà ikal kàkäl un'sɛŋ a baar, mbuur mwɛy kàyàbwà an'köm kà in'kɔl a Yɛsu, ");
INSERT INTO yns_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","waa kun'bɔ̈ɔ̈n naa: « Mwol, un'wem ngyɛb mwan amɛ, nde afikwà nkaaŋ anà afiman mpay mbɔɔn. Mbalà mbɔɔn nde afàbwà u mbaa itàkal kan'dà. ");
INSERT INTO yns_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mɛ amun'pà akà alɔŋki angye, wɛɛ ba bàsàkwo anki mukun'kɔɔr. » ");
INSERT INTO yns_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mufuur, Yɛsu kàtɛn naa: « Làfuun a làbe anà làkɔ̈ɔ̈n làkwikilà! Tii mpal nà in'sàkalà mɛ anà bɛ? An'taaŋ an'kwe in'sakaŋà mɛ mpem ntɔn bɛ? Lan'twääl awà pà mwan awun. » ");
INSERT INTO yns_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Apan Yɛsu kàswɛŋ unsɔŋà mutoo, wa waa kàtoo u mwan awun. Taaŋ nsil sye alan mwan awun laa kàkɔɔrà nde. ");
INSERT INTO yns_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Apan, alɔŋki bàyàsin tsütsü apà Yɛsu, waa bun'fuul naa: « Ntɔn nkye mpa ikwe bi muböŋ unsɔŋà awunà? » ");
INSERT INTO yns_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nde kàtɛn a ba naa: « Ntɔn làkwikilà abɛ là ikikye. Kyakin mɛ, mɛ alàkyään ndandaa: isàkal naa bɛ làbye anà làkwikilà asànaa imbɛŋ a ndɔŋ, bɛ lan'kwo làtɛn a mɔŋ wà naa: \"Lwomà pà, kyen kàbü kunà\", wa sye akyer akyà. Akà undiir mwɛy watɛy asàkal mpay akà bɛ. ");
INSERT INTO yns_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21"," Unsɔŋà a tub awà kan'kwo mutoo unsà ngyamàkà anà nkin a isa. »  ");
INSERT INTO yns_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mpal bàkäl ba mufurà Ngalilɛ, Yɛsu kàtɛn a ba naa: « Mwan a mbuur bàkyer ayun'yälà kà an'kɔɔ a baar, ");
INSERT INTO yns_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","laa bàsun'dwa ba, wɛ kà ilä kyàtär, nde akyer asàwiyà. » Alɔŋki bàwem ngyɛb mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mpal bàyàkɔlà ba Kapɛrnawum, afüür a itɛr a ndwà a Nzam bàyi akà Petɔlà, waa bun'fuul naa: « Ntɔn nkye Un'lɔɔŋ abɛ mpa ufàfur nde itɛr a ndwà a Nzam? » ");
INSERT INTO yns_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petɔlà kàfuur naa: « Ɛɛ, nde akyer afàfur. » Mpal kàbilà Petɔlà u ndwà, Yɛsu kàdi nsweel, waa kun'fuul naa: « Simɔn, an'kyän angye mye aben? Amfum a mɛɛn un'laam itàkal itɛr bàfàwal akà nà? Akà baan aba lɛɛ akà angyey? » ");
INSERT INTO yns_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petɔlà kàfuur naa: « Akà angyey. » Yɛsu naa: « Abun, baan a ndwà mwo batɛy. ");
INSERT INTO yns_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Itàkal abwɛy, mukɔɔn adwa làkwikilà aba, kyen kà ɛwà, tɔɔm ndɔb angye. Nsö atàtwɛb asiim ngye, duub mun awa, ngye ayàman itɛr a ngim, wal kya, apɛ ntɔn bi bàbɔ̈ɔ̈l. » ");
INSERT INTO yns_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Utaaŋ alan, alɔŋki bàsin tsütsü apà Ysɛu, waa bàtɛn a nde naa: « Abun, nà awà kölàköl uboo a Imwol a du? » ");
INSERT INTO yns_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yɛsu kàbel mwan mwɛy, kun'si uboboo a ba, ");
INSERT INTO yns_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","waa kàtɛn naa: « Ndandaa mɛ alàkyään, isàkal naa bɛ làsɔɔmà anki anà làkɔɔn abulà asànaa baan, bɛ làsàbilà anki kà Imwol a du. ");
INSERT INTO yns_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Lalan, mbuur wanswà asàkal anà làbɔ̈ɔ̈n, nde asàkal wàkölàköl kà Imwol a du. ");
INSERT INTO yns_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mbuur awal mwan mwɛy asànaa wunà kà ikɔb amɛ, nde kan'wal mɛ ŋakwo. » ");
INSERT INTO yns_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","« Wɛɛ mbuur wanswà asiinà umwɛy uboo a bibaan ban'sà làkwikilà bà amu mɛ mubwà kà ube, yan'söön ubwaŋ akà nde naa bun'bäm nkɔŋ a kölàköl u bway, waa bun'tɔɔm kà indübà a an'dà. ");
INSERT INTO yns_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ngyɛb akà mɛɛn ntɔn ndaa yanswà ifàsyen baar mukyer ube! Ya ifàkɔɔn anki, wɛɛ ngyɛb akà mbuur awà mbwo ayà ifàyà ndɛb! ");
INSERT INTO yns_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Isàkal naa kɔɔ angye itàkal làkɔl angye làfasyen nkuur unsà ube, tsul la anà piy la ukwɛl. Ntɔn yan'söön ubwaŋ naa ngye abilà du a Nzam làkɔl làmwɛy itàkal kɔɔ làmwɛy, akwànaa ngye mukal amà an'kɔɔ an'mɔ̈ɔ̈l itàkal in'kɔl myeel, waa batɔɔm u mbaa a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Isàkal sye naa dii angye làfasyen nkuur unsà ube, kwool la, tɔɔm la ukwɛl. Ntɔn yan'söön ubwaŋ naa ngye abilà du a Nzam dii làmwɛy akwànaa ngye mukal amyà mii myeel, wɛɛ batɔɔm u mbaa a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","« Twon lan'bɛy akà umwɛy uboo a bibaan bi, ntɔn mɛ, mɛ in'tɛn a bɛ naa u du akyeey aba bàŋàmbar taaŋ lanswà kusà a Taaràmɛ awà u du. ");
INSERT INTO yns_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11"," Ntɔn Mwan a mbuur kàyi muyàtswà mɔ̈ɔ̈ a baar bàdiimà mbwo. »  ");
INSERT INTO yns_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","« An'kyän abɛ mye aben? Isàkal naa mbuur mwɛy we amyà in'kɔk nkam, wɛɛ umwɛy udiimà, nkye nde usàwɛy anki in'kɔk an'kwem wà aŋiwà myumwɛy u mɔŋ ntɔn mukàleŋ un'kɔk mwɛy kàdiimà wà? ");
INSERT INTO yns_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ndandaa mɛ alàkyään, isàkal naa nde kan'man wa, nde ayàkal unsà un'sak aŋàsöönà ntɔn wa, akwànaa ntɔn an'kwem wà aŋiwà mpa myàdiimà. ");
INSERT INTO yns_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Abun sye, Taaràbɛ awà u du akwen naa umwɛy uboo a bibaan bi ukɔɔn adiimà. ");
INSERT INTO yns_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","« Isàkal naa un'tɔŋ angye kàmakyer ube, kyen kun'mɛn, kun'mɛɛy ube kan'kyer nde. Isàkal naa nde kan'kyey, ngye an'fuur itɔŋ abɛ. ");
INSERT INTO yns_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wɛɛ isàkal naa nde kawem anki, syen mbuur mwɛy itàkal baar bɔ̈ɔ̈l, ntɔn ndaa yanswà ikäl aŋàlɔ̈ɔ̈n u mun a ambäl abɔ̈ɔ̈l itàkal atär. ");
INSERT INTO yns_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Isàkal naa nde ba kawem anki, kasaam ya kà Ikööŋ. Isàkal naa nde kan'tɔn muwem Ikööŋ, wɛy nde ukäl akà ngye asànaa mbuur mpa awà un'yudà itàkal un'füür a itɛr. ");
INSERT INTO yns_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","« Ndandaa mɛ alàkyään: undiir wanswà làsàbäm bɛ u mɛɛn, wa asàkal wàŋàbäm u du. Undiir wanswà làsàtsuuŋ bɛ u mɛɛn, wa asàkal wàŋàtsuuŋ u du. ");
INSERT INTO yns_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","« Mɛ, mɛ in'fàlakyään naa isàkal naa baar abɔ̈ɔ̈l uboo abɛ ban'lwɛŋ u mɛɛn pà ntɔn mulɔm undiir, Taaràmɛ awà u du akyer asapà wa. ");
INSERT INTO yns_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ntɔn baar abɔ̈ɔ̈l itàkal atär bàsàtüüb kà ikɔb amɛ, mɛ in'wà uboo a ba.» ");
INSERT INTO yns_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Apan, Petɔlà kàsin tsütsü apà Yɛsu, waa kun'fuul naa: « Mwol, mbalà kwe mɛ an'kwo mudwääl un'tɔŋ amɛ nkul isàkal naa nde kàman'kyer ube? Nkye mbalà nsambwaar? » ");
INSERT INTO yns_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yɛsu naa: « Mɛ in'tɛn anki a ngye naa tii mbalà nsambwaar, wɛ, tii u mbalà an'kwem nsambwaar mbalà nsambwaar. ");
INSERT INTO yns_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Abun, Imwol a du kyà asànaa mfum mwɛy kàkwen mulɔn ndaa a ngim ande anà asyääl ande. ");
INSERT INTO yns_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","U nsɛmà, ba bun'twääl umwɛy kàlun'fuur itɛr nsaab kwem. ");
INSERT INTO yns_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wɛɛ nde ngim afuur kàkäl ayà anki. Apan, nkum ande kàswɛŋ naa bayälà asànaa asɔ, nde anà un'kyay ande anà baan ande, anà indiir ande byanswà ntɔn mufur nkul ayin. ");
INSERT INTO yns_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Apan, un'syääl awà kàbü an'köm kusà a nkum ande, waa kàtɛn naa: \"Nkum, kaŋ mpem ntɔn mɛ, mɛ in'kyer ayàfur nkul angye yanswà.\" ");
INSERT INTO yns_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nkum ande kun'wem ngyɛb, waa kun'wɛy ungö akun'dwääl nkul ande. ");
INSERT INTO yns_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Un'syääl awà kàtoo nde, nde kàbwey a umwɛy uboo a baar bàfàsal anà nde, awà kàlun'pà itɛr a ngim nkam mwɛy. Nde kun'si mpi a mpà anà mutɛn naa: \"Fur nkul amɛ!\" ");
INSERT INTO yns_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Abun, mbuur awun kàbü an'köm, waa kun'bɔ̈ɔ̈n naa: \"Kaŋ mpem ntɔn mɛ, mɛ in'kyer ayafur!\" ");
INSERT INTO yns_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wɛɛ un'syääl awun waa kàtön, kàkun'sà u bɔlokà tii mpal kàlàfur nde nkul ayin. ");
INSERT INTO yns_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mpal bàmɛn asyääl bumwɛy ndaa ayi, laa bàkyɛɛr ba, waa bàkàkyään nkum aba ndaa yanswà yàlyaŋ. ");
INSERT INTO yns_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Apan, nkum kàbel un'syääl awun, waa kàtɛn a nde naa: \"Un'syääl un'be! Nkul angye yanswà mɛ kàkyer apiy bwà, ntɔn ngye kàkyer an'bɔɔn. ");
INSERT INTO yns_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nkye ngye sye un'tɔŋ angye alun'wem anki ngyɛb asànaa kawem mɛ ngyɛb?\" ");
INSERT INTO yns_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nkum ande kàwem nkyɛl, waa kun'pɛ akà aŋangwal tii mpal kàlàfur nde nkul ande yanswà. ");
INSERT INTO yns_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","« Taaràmɛ awà u du asàlakyer sye abun isàkal naa umwɛy umwɛy uboo a bɛ udwääl anki un'tɔŋ ande nkul a ibii ande unsà mpem ande wanswà. » ");
INSERT INTO yns_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mpal kàmay Yɛsu nswɛɛŋ ayin, nde kàlwomà u Ngalilɛ, waa kàkyen itiir a nsi a Yuday, u sim a Yɔrdan lumwɛy. ");
INSERT INTO yns_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Un'sɛŋ a baar mbɔɔn laa kàyun'labà wa, nde waa kakɔɔr kwo. ");
INSERT INTO yns_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Amfarisi bàsin apà nde ntɔn mukun'lɛɛ untaam : « Nkye baal kan'kwo uböŋ un'kyay ande ntɔn ndaa kànà? » ");
INSERT INTO yns_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nde kafuur naa: « Nkye bɛ làtäŋ anki naa u nsɛmà Nkyer kàyilà baal anà un'kaar, ");
INSERT INTO yns_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","waa kàtɛn naa: \"Lalan, baal asàwɛy taarànde anà ngwän, nde usàkàbääb anà un'kyay ande. Waa ba bàbɔ̈ɔ̈l bàsàbulà ndür mwɛy. ");
INSERT INTO yns_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Abun, ba bàfàkal anki abɔ̈ɔ̈l, wɛɛ ndür mwɛy mpɛl. Apan, wɛy mbuur ukɔɔn akaab ayà kàtüüb Nzam.\" » ");
INSERT INTO yns_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ba bàtɛn naa: « Ntɔn nkye Mɔsɛ kàpɛ nde mbwo akà baal mupà un'kaan a nkaabà akà un'kyay ande mpal kun'böŋ nde? » ");
INSERT INTO yns_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nde kàtɛn a ba naa: « Ntɔn mpem a ngwal abɛ waa Mɔsɛ kàpɛ mbwo muböŋ akyay abɛ. Wɛɛ u nsɛmà, ya yàkäl anki abwɛy. ");
INSERT INTO yns_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wɛɛ mɛ, mɛ alàkyään naa: Yan'kwo bàwɛy un'kaar kan'tà inswem mpɛl. Wɛɛ mbuur usàwɛy un'kyay ande mpa kàtɛ nde inswem, anà kan'bääl un'kaar asin, nde kan'tà inswem. » ");
INSERT INTO yns_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Alɔŋki ande bàtɛn a nde naa: « Isàkal naa ndaa a baal anà un'kyay ande yà abwɛy, apɛy ndöŋ abääl yatɛy. » ");
INSERT INTO yns_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nde kafuur naa: « Baar banswà bàfàyöb anki ndaa ayi, wɛɛ baar akwà bàwɛl kab alan mpɛl. ");
INSERT INTO yns_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Abun, bye anà ampfwe fà an'bäl a angwän aba, bye anà ampfwe ntɔn baar asin bawɛl mfɛɛl, bye anà ampfwe ntɔn ba ŋakwo bàkwen mukal ampfwe ntɔn Imwol a du. Wɛy mbuur kan'kwo muyöb uyöb! » ");
INSERT INTO yns_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Apan, baar bun'twääl baan ambɛy ntɔn nde kasi an'kɔɔ anà ngyamàkà. Wɛɛ alɔŋki laa baŋyäŋà ba. ");
INSERT INTO yns_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yɛsu kàtɛn naa: « Lawɛy baan ambɛy bàyi akà mɛ, twɔn làmatsuŋ ntɔn Imwol a du kye akà baar abà asànaa ba. » ");
INSERT INTO yns_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ungö kasi nde an'kɔɔ, nde kàlwomà apan. ");
INSERT INTO yns_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ungö apan, mbuur mwɛy kàsin apà nde, waa kàtɛn a nde naa: « Un'lɔɔŋ, ininà aŋàbwaŋ an'kwo mɛ mukyer ntɔn muwal mɔ̈ɔ̈ a mbul a in'tye? » ");
INSERT INTO yns_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yɛsu kàtɛn a nde naa: « Ntɔn nkye aman'fuul ngye ntɔn yàŋàbwaŋ? Umwɛy mpɛl awà ŋàbwaŋ. Isàkal naa ngye akwen mubilà u mɔ̈ɔ̈, lab nswɛɛŋ. » ");
INSERT INTO yns_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mbuur awà kun'fuul naa: « Nswɛɛŋ yɛn? » Nde kàtɛn a nde naa: « Twɔn an'dwa, twon an'tà inswem, twɔn an'yib, twɔn an'tà imbäl a loor, ");
INSERT INTO yns_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kömà taaràŋà anà ngwa, kwen un'tɔŋ angye asànaa ngye ŋakwo. » ");
INSERT INTO yns_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Un'tö awà kàtɛn a nde naa: « Mɛ akyàkwey indiir abi byanswà, undiir nà amàfan'kɔ̈ɔ̈n? » ");
INSERT INTO yns_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yɛsu kàtɛn ande naa: « Isàkal naa ngye akwen mukal wàŋàkwo, kyen, kayälà indiir angye, wal ngim an'yälà ngye bya pà ya akà aŋàlàmbwà , waa ngye asàwal un'naaŋ u du. Ungö apan, yan'läb. » ");
INSERT INTO yns_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ungö muwem ndaa ayi, un'tö awà kàkyen unsà ngyɛb yanswà, ntɔn nde kàkäl anà indiir mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Waa Yɛsu kàtɛn a alɔŋki ande naa: « Mɛ, mɛ alàkyään ndandaa naa yà mpay akà ŋun'naaŋ mubilà kà Imwol a du. ");
INSERT INTO yns_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mɛ, mɛ in'fàlakyään naa: mpay yatɛy akà mpoonà mubilà u mun a nsway, akwànaa akà ŋun'naaŋ mubilà uboo a Imwol a Nzam. » ");
INSERT INTO yns_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mpal bàwem alɔŋki abwɛy, ba bàbem mbɔɔn, waa bàtɛn naa: « Abun, nà kan'kwo muwà mɔ̈ɔ̈? » ");
INSERT INTO yns_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yɛsu laa kaler nde, waa kàtɛn a ba naa: « Ya ikwe anki akà baar, wɛɛ akà Nzam yanswà ikyer afàkwo. » ");
INSERT INTO yns_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Apan, Petɔlà kàwɛl ndaa, waa kàtɛn a nde naa: « Le, bi, bi kàkyàsàwɛy ya yanswà ntɔn mulab ngye. Ininà bi isàwal? » ");
INSERT INTO yns_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yɛsu kàtɛn a ba naa: « Mɛ, mɛ alàkyään ndandaa: utaaŋ byàsàfurà indiir byanswà byàkün, mpal usàbwaay Mwan a mbuur u kir a làkoo ande, bɛ, bɛ sye làsàbwaay kà an'kir kwem aŋiyweel mà imwol, ntɔn mutsul nsaŋ a in'sɛŋ a Isàlɛl myà kwem aŋiyweel. ");
INSERT INTO yns_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Waa mbuur wanswà kàsàwɛy ndwà, atɔŋ abaal anà bakaar, taarànde, ngwän, baan, itàkal an'ywaŋ ntɔn mɛ, asàwal yàŋàsöön mbalà nkam, bweel ande bàsàkal mɔ̈ɔ̈ a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bàmbɔɔn bàtàtwɛb bàsàkal bàngöngö, bàmbɔɔn bàngöngö bàsàkal bàtàtwɛb. » ");
INSERT INTO yns_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","« Abun, Imwol a du kyà asànaa nkum a ndwà mwɛy kàtoo ututu tutu muwal baar ntɔn mukàsal u ywaŋ a vin ande. ");
INSERT INTO yns_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nde kàlwɛɛŋ anà ba naa nde ayafur itɛr a ngim mwɛy kà ilä imwɛy kyà isal. Ungö nde katöm mukàsal u ywaŋ ande. ");
INSERT INTO yns_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ntsü a taaŋ làwà làtutu, nde kàtoo, waa kàmɛn baar bumwɛy u balàbal bàkyàkal mpɛɛl, ");
INSERT INTO yns_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","nde kàtɛn a ba naa: \"Bɛ sye, làkyen ywaŋ amɛ, mɛ in'yàlapà làfur aŋàkwo.\" ");
INSERT INTO yns_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ba waa bàkyen. Ntsü a midi anà utaaŋ làtär ungö a midi, nde kàfàtoo, waa kàkyer asànaa kusà. ");
INSERT INTO yns_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mumay, nde kàfàtoo u taaŋ làtyen là sisye, waa kàmɛn baar asin bàkyàmbar paa. Nde kafuul naa: \"Ntɔn nkye làbwaayà bɛ apà ilä aŋun'kiinà ukɔɔn isal?\" ");
INSERT INTO yns_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ba bàfuur naa: \"Ntɔn akà mbuur mwɛy kà iwɛl anki musal.\" Nde waa kàtɛn a ba naa: \"Bɛ sye, làkyen ywaŋ amɛ!\" » ");
INSERT INTO yns_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","« Mpal làkwe sisye, ŋaywaŋ kàswɛŋ mbuur afàler isal ande naa: \"Abel baar a isal, pà akà mbuur wanswà làfur ande. Ngye ayàsɛmà akà baar a ngöngö, waa ayàmay akà baar atàtwɛb.\" ");
INSERT INTO yns_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Baar akwà bàsɛmà isal u taaŋ làtyɛn là sisye waa bàyi, bàwɛl mbuur mbuur itɛr a ngim mwɛy. ");
INSERT INTO yns_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wɛɛ mpal bàyi baar atàtwɛb, an'kyän aba màkäl naa ba bàyàwal làfur aŋàsöön, wɛɛ ba sye bàwɛl mbuur mbuur itɛr a ngim mwɛy. ");
INSERT INTO yns_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Utaaŋ ban'wal ba kya, ba bàŋüŋün a nkum a ndwà, ");
INSERT INTO yns_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","waa bàtɛn a nde naa: \"Baar bàbilà isal ungöngö bàkyer taaŋ làmwɛy mpɛl, wɛɛ ngye amafur làsii làmwɛy anà bi baar kan'sɛn yɔ̈ɔ̈n a ilä anà igyɛy a mwäänà!\" ");
INSERT INTO yns_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wɛɛ ŋaywaŋ kàfuur akà umwɛy uboo a ba naa: \"Un'sam amɛ, akà ube mwɛy amakyer mɛ batɛy. Nkye ngye alwɛɛŋ anki anà mɛ ntɔn itɛr a ngim mwɛy? ");
INSERT INTO yns_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wal kab angye, kyen kà ngye. Mɛ an'kwen mupà akà mbuur angöngö asànaa akà ngye. ");
INSERT INTO yns_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nkye mɛ in'kwe anki mukyer anà indiir amɛ asànaa in'kwen mɛ? Ngye an'man ube ntɔn in'wà mɛ mbuur aŋàbwaŋ?\" ");
INSERT INTO yns_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Abun, bàngöngö bàsàkal bàtàtwɛb, bàtàtwɛb bàsàkal bàngöngö. » ");
INSERT INTO yns_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Umpal kàkäl Yɛsu mubeenà Yɛlusàlɛm, nde kàbel Bàkwem Aŋiyweel ukɔl, waa kàtɛn a ba u mbwo naa: ");
INSERT INTO yns_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","« Le, bi ibàmubeenà Yɛlusàlɛm, mper bàyàkàyälà Mwan a mbuur akà amfum a angaŋ anà akà alɔɔŋ a in'kɔɔn. Ba bàkyer akun'tsüül mbar a ukwà, ");
INSERT INTO yns_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","anà bàkun'pà kà an'kɔɔ a baar mpa abà Ayudà ntɔn mukun'sɛ, mukun'kam an'füm anà mukun'bɛɛrà u kulunsi. Wɛɛ kà ilä kyàtär, nde akyer asàwiyà. » ");
INSERT INTO yns_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Apan, un'kyay a Zebeday kàyàsin tsütsü apà Yɛsu anà baan ande babaal , waa kabü an'köm ntɔn mukun'lɔ̈ɔ̈m. ");
INSERT INTO yns_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yɛsu kàtɛn ande naa: « Ininà ngye akwen? » Nde kun'fuur naa: « Pà mbwo uboo a Imwol angye naa baan abaal amɛ bà bàbɔ̈ɔ̈l bàsàbwaay umwɛy u kɔɔ angye libaal, wumwɛy u kɔɔ angye là ikaar. » ");
INSERT INTO yns_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yɛsu kàfuur naa: « Le baar bà: bɛ làyöb anki naa bɛ ininà làkalɔɔmà. Nkye bɛ lan'kwo munwà kɔɔb alà in'yànwà mɛ? » Ba bun'fuur naa: « Inye, bi kan'kwo. » ");
INSERT INTO yns_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nde waa kàtɛn a ba naa: « Bɛ làkyer asànwà kɔɔb amɛ. Wɛɛ mubwaay u kɔɔ ibaal anà là ikaar, kà mɛ anki an'kwo mupà mbwo: Kya kyà ntɔn baar kàlɔ̈ɔ̈n Taa. » ");
INSERT INTO yns_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mpal bàwem alɔŋki kwem bumwɛy ndaa ayin, ba bàwem atɔŋ aba abà bàbɔ̈ɔ̈l nkyɛl. ");
INSERT INTO yns_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Wɛɛ Yɛsu waa kabel, waa kàtɛn a ba naa: « Bɛ, bɛ làkyàyöb naa amfum a in'sɛŋ bàfàsà ba ungyɛl a in'kɔl aba, anà baar an'köl an'köl bàfàswaŋ ba ikɔ̈b aba. ");
INSERT INTO yns_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ya ikwe anki mukal abwɛy uboo a bɛ. Wɛɛ isàkal naa mbuur akwen mukal wàkölàköl uboo a bɛ, wɛy nde ukäl un'syääl abɛ, ");
INSERT INTO yns_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","waa mbuur wanswà akwen mukal wàtàtwɛb uboo a bɛ, wɛy nde ukäl un'syääl abɛ. ");
INSERT INTO yns_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Lalan Mwan a mbuur kàyi anki ntɔn bun'syääl, wɛɛ ntɔn musyääl anà mupà mɔ̈ɔ̈ ande nkwiy ntɔn un'kàbɔ a baar. » ");
INSERT INTO yns_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Umpal bàtoo ba u Yɛlikɔ, un'sɛŋ a baar mbɔɔn kàläb Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kyekà ikwàmii abɔ̈ɔ̈l bàkäl bàŋàbwaay ukɔl a mbwo. Mpal bàwem ba naa Yɛsu wàmulyaŋ tsütsü, ba bàsɛmà mukuub in'kwɛŋ: « Mwol, Mwan a David, isyääm! » ");
INSERT INTO yns_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Un'sɛŋ a baar katsüŋà musà in'kwɛŋ, wɛɛ ba bàsöönà mulaal: « Mwol, Mwan a David, isyääm! » ");
INSERT INTO yns_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yɛsu waa kàmbär, waa kabel, waa kafuul naa: « Ininà bɛ làkwen naa mɛ in'kyer ntɔn bɛ? » ");
INSERT INTO yns_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ba bun'fuur naa: « Mwol, kyer naa mii abi idubà. » ");
INSERT INTO yns_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yɛsu waa kasyääm, kabä u mii. Apan sye, mii aba waa myàdubà, waa bun'läb. ");
INSERT INTO yns_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Umpal bàsin ba tsütsü a Yɛlusàlɛm, anà bàtöl ba tsütsü a Bɛtefazɛ, udu a mɔŋ a In'te a olive, apan Yɛsu kàtöm abɔ̈ɔ̈l uboo a alɔŋki ande, ");
INSERT INTO yns_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","waa kàtɛn a ba naa: « Làkyen u bul lanà kusà a bɛ, pa làkàkɔlà bɛ, bɛ làkàman ntsür bàfàbel anɛs wàŋàbäm un'siŋ anà mwan awa ukɔl. Làtsuuŋ wa, lan'twääl ayà pà. ");
INSERT INTO yns_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Isàkal naa mbuur kan'tɛn undiir anà bɛ, lun'fuur naa: \"Mwol we anà mfun aya\". Làgyägyä, ba bàyàwɛy ya ntɔn mukyà. » ");
INSERT INTO yns_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yàkäl ya abà, ntɔn ndaa kàtɛn ŋangɔɔm yi ikwe: ");
INSERT INTO yns_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","« Tɛn a un'sɛŋ a Siyɔnà naa: Le, mfum angye wàmuyà akà ngye, wàŋàyɔl a làbɔ̈ɔ̈n anà wàŋàlaar udu a ntsür bàfàbel an, anà udu anɔ, mwan a ntsür afàsyen buur. » ");
INSERT INTO yns_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Alɔŋki bàkyen ba, ba bàkyer asànaa kaswɛŋ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba bàtwääl ntsür bàfàbel an anà mwan awa, waa bàyɛɛl ipfɛy aba udu a ya. Yɛsu kàbwaay udu a ya. ");
INSERT INTO yns_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Un'sɛŋ a baar kàyɛɛl ipfɛy awa u mbwo, bumwɛy bàtsüülà an'kɔkà a in'te waa bàyɛɛlà ma u mbwo. ");
INSERT INTO yns_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","In'sɛŋ a baar myàyikyeenà kusà a Yɛsu anà myàyun'labà myàkäl muyisà in'kwɛŋ naa: « Ɔsana akà Mwan a David! Wɛy mbuur awà ayà kà ikɔb a Mwol ukäl wàŋàsaak! Ɔsana kà ikal a dudu! » ");
INSERT INTO yns_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mpal kàbilà nde u Yɛlusàlɛm, bul lanswà làkyer ani anà làkäl mufuulà naa: « Nà wawà? » ");
INSERT INTO yns_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","In'sɛŋ waa myàfuurà naa: « Ŋangɔɔm Yɛsu, un'nsi Nasàlɛr u Ngalilɛ. » ");
INSERT INTO yns_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yɛsu kàbilà u làpaŋ a ndwà a Nzam, nde kàböŋ atɛɛl a an'yà banswà bàkäl kwo, kàbuum mɛsà a agyɛɛŋ a ngim anà an'kir a ayääl a an'yem. ");
INSERT INTO yns_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nde kàtɛn a ba naa: « Bàsön naa: \"Ndwà amɛ bàsabeelà naa ndwà a ngyamàkà\", wɛɛ bɛ, bɛ ya làkyàbuul mboo a mbüüb! » ");
INSERT INTO yns_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ikwàmii anà ikar bàyàsin tsütsü apà nde uboo a ndwà a Nzam, nde waa kakɔɔr. ");
INSERT INTO yns_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wɛɛ mpal bàmɛn andweer a angaŋ anà alɔɔŋ a Un'kɔɔn ndaa impà kàkyer Yɛsu anà in'kwɛŋ bàsyee baan uboo a ndwà a Nzam: « Ɔsana akà Mwan a David! », ba bàwem nkyɛl, ");
INSERT INTO yns_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","waa bàtɛn a nde naa: « Nkye ngye akiweemà ndaa bàtɛɛnà ba? » Yɛsu kafuur naa: « Inye. Nkye bɛ, bɛ làtäŋ anki akà ikikye ndaa bàsön yi: \"Nkye ngye kàyöŋà nsyäŋà u mun a ambɛy anà yà baan abà kà an'bɛɛl?\" » ");
INSERT INTO yns_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Apan laa kàsawɛy nde, waa kàkyen Bɛtani, ntsü kàkàbɔ̈ɔ̈n nde. ");
INSERT INTO yns_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Taaŋtyà ututu, mpal kàkäl nde u mbwo mufurà bul a kölàköl, Yɛsu kàwem ngyal. ");
INSERT INTO yns_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nde kàmɛn un'te a an'fige ukɔl a mbwo, nde kàsin tsütsü apà wa, wɛɛ nde undiir kàmɛn anki, nà nkay mpɛl. Apan nde kàtɛn a un'te naa: « Ngye afàsàbɔr anki imbɛŋ! » Taaŋ nsil alan, un'te laa kàyöm wa. ");
INSERT INTO yns_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mpal bàmɛn alɔŋki abun, ba bàkyer abem, waa bàtɛn naa: « Un'te a an'fige kan'yɔm aben u mbalà mwɛy? » ");
INSERT INTO yns_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yɛsu kafuur naa: « Mɛ, mɛ ndandaa alàkyään: isàkal naa bɛ làbye anà làkwikilà, ukɔɔn nkyɛɛr, bɛ lan'kwo mukyer kànà ndaa an'kyer mɛ yi akà un'te wà anki, wɛ bɛ lan'kwo mutɛn itàkal a mɔŋ wà naa: \"Lwomà pà, kyen kabü u ngyäl\", ya sye ikal abun. ");
INSERT INTO yns_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Undiir wanswà làlɔm bɛ unsà làkwikilà u ngyamàkà, bɛ làkyer asàwal wa. » ");
INSERT INTO yns_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mpal kàbilà Yɛsu u ndwà a Nzam, amfum a angaŋ anà andweer a un'sɛŋ bàyàsin anà bun'fuul umpal kàkäl nde mulɔŋ: « Unsà ikɔ̈b nà ayikyer ngye indiir abi? Nà kapɛ ikɔ̈b aki? » ");
INSERT INTO yns_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yɛsu kafuur naa: « Mɛ sye in'we anà mfuul mwɛy ntɔn bɛ. Isàkal naa bɛ làman'pà mfuur, mɛ sye waa alakyään naa unsà ikɔ̈b nà mɛ in'kyerà bya. ");
INSERT INTO yns_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ndüümà a Ywan yàfü ken? U du lɛɛ akà baar? » Wɛɛ ba bàsyeelà mbaaŋ ba a ba naa: « Kya bi isàtɛn naa: \"U du\", nde ayifuul naa: \"Ntɔn nkye mpa lun'si bɛ làkwikilà?\" ");
INSERT INTO yns_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wɛɛ bi isàfuur naa: \"Baar\", bi itiin un'sɛŋ a baar bɔɔmà, ntɔn ba banswà bàkyàyöb naa Ywan wà ŋangɔɔm. » ");
INSERT INTO yns_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Apan, ba bàfuur akà Yɛsu naa: « Bi iyöb anki. » Waa nde sye kafuur naa: « Mɛ sye alàkyään anki unsà ikɔ̈b nà in'fàkyer mɛ indiir abi. » ");
INSERT INTO yns_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","« An'kyän abɛ mye aben? Mbuur mwɛy kàkäl anà baan abaal bɔ̈ɔ̈l. Nde kàsin apà wàtàtwɛb, waa kàtɛn a nde naa: \"Mwan amɛ, kyen kasäl ŋàbà u ywaŋ a vin.\" ");
INSERT INTO yns_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mwan awà kàfuur naa: \"Aay, mɛ in'kwen anki.\" Ungö a taaŋ, nde kàsɔɔm ankyän, waa kàkyen. ");
INSERT INTO yns_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kàsin nde apà mwan wàyweel, nde kàtɛn ndaa nsil ya. Mwan awà kàfuur naa: \"Inye, taa\". Wɛɛ nde kàkyen anki. ");
INSERT INTO yns_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nà uboo a ba bàbɔ̈ɔ̈l kàkyer ukwen a taarànde? » Ba naa: « Wàtàtwɛb. » Yɛsu kàtɛn a ba naa: « Ndandaa mɛ alàkyään: afüür a itɛr anà akaar a pasàsɛ bàsàfwel kusà a bɛ uboo a Imwol a Nzam. ");
INSERT INTO yns_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ntɔn Ywan kàyi akà bɛ u mbwo a balàbal, wɛɛ bɛ, bɛ làkwikilà lun'si anki. Wɛɛ afüür a itɛr anà akaar a pasàsɛ bun'si làkwikilà. Itàkal naa bɛ làkyàman ya abwɛy, wɛɛ bɛ, bɛ làbuul anki mpem ntɔn mukun'sà làkwikilà. ");
INSERT INTO yns_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","« Làwem nsim yumwɛy: Nkum mwɛy kàkön vin u ywaŋ. Nde kàdiŋà la a làpaŋ, nde kàtöŋ ikal mukaam mbɛŋ anà ndwà a ikyɛɛŋ. Ungö apan nde kàpɛ la akà atɛɛr a man, waa kàkyen mukàyilyaŋ. ");
INSERT INTO yns_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mpal làkwe taaŋ abwo mbɛŋ, nde kàtöm asyääl ande akà atɛɛr a man ntɔn muwal mbɛŋ a vin. ");
INSERT INTO yns_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Atɛɛr a man bàkör asyääl aban, umwɛy bun'düb, umwɛy bun'dwä, umwɛy bun'käm in'kul. ");
INSERT INTO yns_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nde kàfàtɔm asyääl asin mbɔɔn bàŋàlyaŋ bàtàtwɛb, wɛɛ atɛɛr a man bakyer ifà imwɛy kya. ");
INSERT INTO yns_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mumay, nde kàtöm mwan ande, waa kàtɛn naa: \"Ba bàyàkàkömà mwan amɛ.\" ");
INSERT INTO yns_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wɛɛ mpal bàmɛn atɛɛr a man mwan awà, ba bàtɛn ba a ba naa: \"Le ikyee ande. Làyi bi kun'dwä, waa bi iwal ywaŋ ande!\" ");
INSERT INTO yns_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Apan, ba bun'tɛ mpi, bun'tɔɔm u nsà a ywaŋ a vin, waa bun'dwä. » ");
INSERT INTO yns_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Abun, Yɛsu kafuul naa: « Ŋàbawà, ŋaywaŋ asàkyer aben ntɔn atɛɛr a man abà? » ");
INSERT INTO yns_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ba bun'fuur naa: « Nde baar abe abà akyer asadwa ukɔɔn aman ngyɛb, nde asàwal ywaŋ a vin, waa usàpà la akà atɛɛr a man asin ban'kwo mukun'pà mbɛŋ u taaŋ a taaŋ. » ");
INSERT INTO yns_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yɛsu kàtɛn a ba naa: « Nkye bɛ làtäŋ anki akà ikikye uboo a Ndaa Aŋàsɔn: \"Nkɔŋ bàpiy atööŋ, ya yàbulà nkɔŋ a twɛrà a ndwà. Kyaki kyà isal a Mwol, ndaa mwɛy yubem u mii abi!\" » ");
INSERT INTO yns_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","« Mɛ, mɛ in'fàlakyään naa: Imwol a Nzam bàkyer asàladuum, waa bàsàpà akà un'sɛŋ awà asàbɔr mbɛŋ. ");
INSERT INTO yns_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44"," Mbuur asàbwà udu a nkɔŋ ayi akyer asàpàpää, anà ya isàbweel mbuur, mbuur awun akyer asàbwàbwamà. »  ");
INSERT INTO yns_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mpal bàwem andweer a angaŋ anà Amfarisi nsim ande ayi, ba bàkyer ayöb naa nde kàtɛɛnà a ba. ");
INSERT INTO yns_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Undiir awun, bàleŋà ba ipöl mukun'kɔr, wɛɛ ba bàmɛn bɔɔmà a iköŋ a baar byàwɛlà Yɛsu asànaa ŋangɔɔm. ");
INSERT INTO yns_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yɛsu kàfàtɛn a ba unsà nsim naa: ");
INSERT INTO yns_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","« Imwol a du kyà asànaa mfum mwɛy kàyöŋà un'kyɔm atà bɔr ntɔn mwan baal ande. ");
INSERT INTO yns_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nde kàtöm asyääl ande mukàbel baar ntɔn un'kyɔm awà, wɛɛ ba bàkwen anki muyà. ");
INSERT INTO yns_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nde kàfàtɔm asyääl asin ntɔn mukàtɛn a baar bàbel naa: \"Le, mɛ an'lɔn isa byanswà: mɛ an'dwa in'dim a ngɔɔmà anà ntsür a may amɛ, indiir byanswà byan'kwo. Làyi kà un'kyɔm atà bɔr!\" ");
INSERT INTO yns_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Wɛɛ ba bàwɛl ya asànaa an'yääm a ngway, ba bàkyen isal aba: umwɛy u ywaŋ ande, wumwɛy u yà ande. ");
INSERT INTO yns_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bumwɛy bàkör asyääl, waa bamɛɛy an'kyeey, waa badwä. ");
INSERT INTO yns_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mfum kàwem nkyɛl, waa kàtöm aŋità ande mudwa adwää baar aban, waa bàwuul bul aba mbaa. ");
INSERT INTO yns_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Apan, nde kàtɛn a asyääl ande naa: \"Un'kyɔm atà bɔr kan'kwo, wɛɛ baar bàbel ndöŋ batɛy. ");
INSERT INTO yns_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Abun, làkyen kà an'kuun a mbwo, làtwääl kà un'kyɔm atà bɔr baar banswà làkàman bɛ.\" ");
INSERT INTO yns_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Asyääl abà laa bàkyen ba u mbwo, bàköŋà ba baar banswà bàmɛn ba, baar abe anà abwɛŋ. Ndwà a un'kyɔm atà bɔr waa yàyöl a baar bàbel. ");
INSERT INTO yns_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mfum kàbilà ntɔn muler baar bàbel, waa kàmɛn mbuur mwɛy mpa kàbwäär ipfɛy a un'kyɔm. ");
INSERT INTO yns_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nde waa kun'fuul: \"Un'sam amɛ, ngye apà ayàbilà aben ukɔɔn ipfɛy a un'kyɔm?\" Mbuur awà ndaa kàsi anki. ");
INSERT INTO yns_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Apan, mfum waa kàtɛn a asyääl naa: \"Lun'bäm in'siŋ kà in'kɔl anà kà an'kɔɔ, lun'piy u làpib a nsà. Kwo iyàkal ilel anà nkwoor a an'din.\" ");
INSERT INTO yns_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Abun, bàfàbel baar mbɔɔn, wɛɛ bàfàwal ikikye mpɛl. » ");
INSERT INTO yns_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Apan, Amfarisi bàkàköŋ ntɔn muleŋ naa ba ndaa bun'lwab aben u ntɛɛn ande ŋakwo. ");
INSERT INTO yns_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ungö apan, ba bun'tööm alɔŋki aba anà baar a Ɛlɔdi ntɔn mutɛn a nde naa: « Un'lɔɔŋ, bi ikyàyöb naa ngye loor afàtà anki: ngye afàlɔŋ mbwo a Nzam unsà ndandaa yanswà ukɔɔn alab an'kyän a mbuur asin, ntɔn ngye afàler anki imbuur a baar. ");
INSERT INTO yns_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Abun, ikyään, ngye akasii aben: mbwo yàmwo lɛɛ yatɛy mufur itɛr akà Sɛzar? » ");
INSERT INTO yns_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wɛɛ Yɛsu kàkyer ayöb an'kyän an'be aba, waa kafuur naa: « Baar a mpem yweel, ntɔn nkye lan'lwab bɛ ndaa? ");
INSERT INTO yns_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Lan'swɛŋ ngim bàfàfur ayà itɛr. » Ba waa bun'mɛɛy itɛr a ngim mwɛy. ");
INSERT INTO yns_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Waa Yɛsu kafuul naa: « Idiim anà ikɔb bi byà nà? » ");
INSERT INTO yns_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ba bun'fuur naa: « Byà Sɛzar. » Apan nde kàtɛn a ba naa: « Abun, làpɛ indiir a Sɛzar akà Sɛzar, indiir a Nzam, akà Nzam. » ");
INSERT INTO yns_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mpal bàwem ba mfuur ayi, ba bàkyer abem, laa bàsun'wɛy ba, waa bàkyen. ");
INSERT INTO yns_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ilä nsil akin, Asadusi bàsin tsütsü apà Yɛsu. Ba bà baar bàfàtɛn naa ngwiiyà kà ukwà yatɛy. Ba bun'fuul naa: ");
INSERT INTO yns_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","« Un'lɔɔŋ, Mɔsɛ kàtɛn naa: \"Isàkal naa mbuur kan'kwà ukɔɔn baan, un'tɔŋ ande asàbääl un'kweel a un'dim, ntɔn nde uböör un'tɔŋ ande baan.\" ");
INSERT INTO yns_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Akà bi bàkäl anà atɔŋ nsambwaar. Wàtàtwɛb kàkäl wàŋàbääl. Nde kàkü ukɔɔn abɔr, waa kàsàwɛy un'kyay ande akà un'tɔŋ ande. ");
INSERT INTO yns_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ya yàkäl abà akà wàyweel, wàtär, tii akà wànsambwaar. ");
INSERT INTO yns_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ungö a ba banswà, un'kaar awun waa kàkü. ");
INSERT INTO yns_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mpal bàsàwiyà baar kukwà, uboo a ba bànsambwaar, un'kaar awà asàkal un'kyay anà? Ntɔn ba banswà bàkäl adim ande! » ");
INSERT INTO yns_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yɛsu kafuur naa: « Bɛ, bɛ làbaŋàdiimà mbwo, ntɔn bɛ làyöb anki itàkal Ndaa Aŋàsɔn, itàkal ngwal a Nzam. ");
INSERT INTO yns_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ntɔn, mpal bàsàwiyà baar, abaal anà akaar bàfàsàtà anki bɔr, wɛɛ ba bàsàkal asànaa akyeey u du. ");
INSERT INTO yns_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Unsà ndaa iler ngwiiyà a baar kà ukwà, nkye bɛ làtäŋ anki ndaa kàtɛn Nzam a bɛ naa: ");
INSERT INTO yns_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"Mɛ, mɛ in'wà Nzam a Abàlam, Nzam a Isak anà Nzam a Yakɔb?\" Nde kà wà Nzam a akü anki, wɛɛ wà baar a mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","In'sɛŋ a baar bàwem an'lɔɔŋ ande, ma màkyer atwà. ");
INSERT INTO yns_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mpal bàwem Amfarisi naa Yɛsu an'dübà Asadusi mun, laa bàköŋ ba, ");
INSERT INTO yns_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","umwɛy uboo a ba, un'lɔɔŋ a un'kɔɔn, waa kun'fuul ntɔn mukun'lwab ndaa: ");
INSERT INTO yns_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","« Un'lɔɔŋ, nswɛɛŋ nà ayà kölàköl uboo a Un'kɔɔn? » ");
INSERT INTO yns_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yɛsu kun'fuur naa: « \"Ngye asàkwen Mwol, Nzam angye, u mpem angye wanswà, u mɔ̈ɔ̈ angye wanswà, anà kan'kyän angye manswà.\" ");
INSERT INTO yns_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ayi nswɛɛŋ a kölàköl anà yàtàtwɛb. ");
INSERT INTO yns_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yàyweel yà mfun sye àyi: \"Ngye asàkwen un'tɔŋ angye asànaa ngye ŋakwo.\" ");
INSERT INTO yns_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Un'kɔɔn wanswà anà aŋangɔɔm bàtoo u nswɛɛŋ ayi yàyweel. » ");
INSERT INTO yns_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Amfarisi bàkäl aŋàköŋ, waa Yɛsu kafuul naa: ");
INSERT INTO yns_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","« An'kyän abɛ myà aben ntɔn Klistɔ? Nde wà mwan anà? » Ba bun'fuur naa: « Wà David. » ");
INSERT INTO yns_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nde kàtɛn a ba naa: « Abun, aben David, u mbwo a Dweelà, kun'beelà nde Mwol mpal kàtɛn nde naa: ");
INSERT INTO yns_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","\"Mwol kàtɛn a mwol amɛ naa: Bwaay u kɔɔ amɛ libaal, tii mpal in'sàsà mɛ aŋankir angye ungyɛl a in'kɔl angye.\" » ");
INSERT INTO yns_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","« Isàkal abun naa David afun'bel \"Mwol\", aben nde kan'kwo mufàkal mwan a David? » ");
INSERT INTO yns_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Akà mbuur mwɛy kàsàkwo anki mukun'fuur akà ndaa mwɛy. Sɛmà ilä akin, akà mbuur mwɛy kàfàsi anki mukun'fuul ndaa. ");
INSERT INTO yns_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Apan, Yɛsu kàtɛn a un'sɛŋ a baar anà alɔŋki ande naa: ");
INSERT INTO yns_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","« Alɔɔŋ a Un'kɔɔn anà Amfarisi bàkyàbwaay u kir a Mɔsɛ. ");
INSERT INTO yns_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Undiir awun, làler yinà yanswà ban'kwo mutɛn ba a bɛ. Wɛɛ twon lan'lab nkyeer aba, ntɔn ba bàfàkyer anki ayà bàfàtɛn ba. ");
INSERT INTO yns_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ba bàfàbäm indiir a buur anà bàfàtälà bya udu a ipaay a baar. Wɛɛ ba ŋakwo bàfàkwen anki mukaal bya a làpin. ");
INSERT INTO yns_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nsyääl aba yanswà yà ntɔn baar bamɛn. Ba bàfàbwaar inkwà abye anà ndaa a Nzam, in'lɛl a ipfɛy aba myà bwɛlàbwɛl. ");
INSERT INTO yns_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ba bàfàkwen mubwaay kà ikal atàtwɛb kà in'kyɔm, anà kà an'kir atàtwɛb u ndwà a nköŋ a Ayudà, ");
INSERT INTO yns_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ba bàfàkwen naa baar bapɛ mbɔr a làkoo kà ikal a un'sɛŋ anà baar babel naa \"Un'lɔɔŋ\". ");
INSERT INTO yns_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Wɛɛ bɛ, bɛ twon bàmàlabel \"Un'lɔɔŋ\", ntɔn bɛ làbye awà Un'lɔɔŋ mwɛy mpɛl, bɛ banswà làbà atɔŋ. ");
INSERT INTO yns_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Twon lan'bel mbuur u mɛɛn \"Taa\", ntɔn bɛ làbye awà umwɛy mpɛl, Taa awà u du. ");
INSERT INTO yns_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Twon bàmàlabel sye \"un'lɔɔŋ\", ntɔn bɛ un'lɔɔŋ asin watɛy, Klistɔ mpɛl. ");
INSERT INTO yns_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mbuur a kölàköl uboo a bɛ asàkal un'syääl abɛ. ");
INSERT INTO yns_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mbuur wanswà asàsɛn an'pɛy bàkyer asun'tyeey, wɛɛ mbuur a làbɔ̈ɔ̈n bàkyer asun'sɛɛn. » ");
INSERT INTO yns_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","« Ngyɛb akà bɛ, bɛ alɔɔŋ a un'kɔɔn anà Amfarisi a mpem yweel! Bɛ làfàbäm mbwo a Imwol a du akà baar. Bɛ ŋàkwo làfàbilà anki kwo, wɛɛ bɛ làfàtsuŋ baar akwà bàfàkwen mubilà. » ");
INSERT INTO yns_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14"," « Ngyɛb akà bɛ alɔɔŋ a Un'kɔɔn anà Amfarisi, baar a mpem yweel! Bɛ làfàgyɔɔr kà an'kɔɔ a akweel adim indiir aba byanswà, wɛɛ taaŋ nsil la, bɛ làbàmusà ngyamàkà a bwɛlàbwɛl ntɔn baar bàlamɛn. Undiir awun, ntaaŋàmbar abɛ isàkal yàŋàdiir an'din! »  ");
INSERT INTO yns_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","« Ngyɛb akà bɛ alɔɔŋ a Un'kɔɔn anà Amfarisi a mpem yweel! Bɛ, bɛ làwàmuyikyà ntsü yanswà u mɛɛn anà udu a ngyäl ntɔn mubuul mpem a mbuur mwɛy, wɛɛ nde usàlakyey, apan bɛ làmun'biil u yaaŋ a mbaa mbalà yweel yàŋàsöön bɛ. » ");
INSERT INTO yns_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","« Ngyɛb akà bɛ, asyeen a ikwàmii! Bɛ làfàtɛn naa: \"Undiir watɛy isàkal naa mbuur kan'dyà kyän kà idwà. Wɛɛ isàkal naa nde kan'dyà la u wɔl a ndwà a Nzam, apan nde kan'kyey ipepey.\" ");
INSERT INTO yns_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Insil, ikwàmii! Undiir nà kan'söön uteer: wɔl, lɛɛ idwà akwà kyan'buul wɔl undiir a in'kyɛɛl? ");
INSERT INTO yns_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Bɛ làfàtɛn sye naa: \"Undiir watɛy isàkal naa mbuur mwɛy kan'dyà kyän udu a mɛsà afub ibɔɔn. Wɛɛ isàkal naa nde kan'dyà kyän unsà kab alà udu a mɛsà afub ibɔɔn, apan nde kan'kyey ipepey.\" ");
INSERT INTO yns_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ikwàmii! Undiir nà kan'söön mfun, ibɔɔn akyà udu a mɛsà a ibɔɔn, lɛɛ mɛsà a ibɔɔn akwà myan'buul ibɔɔn aki undiir a in'kyɛɛl? ");
INSERT INTO yns_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Lalan, mbuur wanswà afàdyà kyän udu a mɛsà a ibɔɔn, nde sye afàdyà udu a mɛsà a ibɔɔn anà indiir byanswà abyà udu pa, ");
INSERT INTO yns_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","mbuur afàdyà kyän kà idwà, afàdyà kyän kà idwà anà akà mbuur afàkal uboo kwo, ");
INSERT INTO yns_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","mbuur afàdyà kyän u mbwo a du afàdyà kyän u mbwo a kir a Imwol a Nzam anà akà mbuur afàbwaay kwo. » ");
INSERT INTO yns_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","« Ngyɛb akà bɛ, bɛ alɔɔŋ a Un'kɔɔn anà Amfarisi, baar a mpem yweel! Bɛ làfàpà akà Nzam un'te mwɛy uboo a in'te kwem, in'te asànaa mɛntɛ, fɛnwil anà kümin. Wɛɛ bɛ, bɛ làfàpiy indiir byan'söön mfun uboo a Un'kɔɔn asànaa balàbal, nsyääm anà lää: abi indiir lan'kwo bɛ mukyer ukɔɔn apiy byumwɛy. ");
INSERT INTO yns_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Asyeen aŋàkwàmii! Bɛ làfàkɔr imwe kun'lɛɛ, wɛɛ bɛ làfàmin mpoonà! » ");
INSERT INTO yns_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","« Ngyɛb akà bɛ, alɔɔŋ a Un'kɔɔn anà Amfarisi a mpem yweel! Bɛ làfàsɔŋ nsà a kɔɔb anà yà làlɔŋà, wɛɛ boo a ma làŋàyɔl a indiir a küb anà làmpfɛɛl abɛ. ");
INSERT INTO yns_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Umfarisi aŋàkwàmii! Tàsɔŋ boo a kɔɔb, ntɔn nsà sye ipɔŋà. ");
INSERT INTO yns_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","« Ngyɛb akà bɛ, alɔɔŋ a Un'kɔɔn anà Amfarisi, baar a mpem yweel! Bɛ làbà asànaa an'dii aŋàkiir un'swɛn a pɛɛl: u nsà ma mye anà ntwɛn, wɛɛ ubɔɔ ma màŋàyɔl a in'kwo a baar aŋàkwà anà ipɔɔn byà ifà ifà. ");
INSERT INTO yns_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Abun bɛ sye, u nsà bɛ làkamɛnà asànaa baar a balàbal umii a un'sɛŋ, wɛɛ ubɔɔ, bɛ làbà aŋàyɔl a mpem yweel anà an'kyän an'be. » ");
INSERT INTO yns_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","« Ngyɛb akà bɛ, alɔɔŋ a Un'kɔɔn anà Amfarisi a mpem yweel! Bɛ làfàtööŋ aŋangɔɔm abɛ an'dii, anà bɛ làfàsà ntwɛn kà an'dii a baar a balàbal, ");
INSERT INTO yns_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","waa bɛ làfàtɛn naa: \"Yàlàkal naa bi ikäl utaaŋ a bànkaa abi, bi kàlàbwà anki mbwo mwɛy anà ba ntɔn mutyaŋ an'kil a aŋangɔɔm.\" ");
INSERT INTO yns_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Abun, bɛ lan'tà imbäl bɛ ŋakwo naa bɛ làbà baan a baar bàdwä aŋangɔɔm. ");
INSERT INTO yns_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Apanà, làkölà isal bàsɛmà bàtaaràbɛ! ");
INSERT INTO yns_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ntäy, a iyäy! Nkye bɛ làkyàkwo mutiin ntaaŋàmbar a yaaŋ a mbaa? ");
INSERT INTO yns_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Undiir awun, làwem: mɛ, mɛ amàlatööm aŋangɔɔm, aŋan'yeerà anà alɔɔŋ a Un'kɔɔn. Bɛ làsàdwa amwɛy anà làsabɛɛrà u kulunsi, làsàkam bumwɛy an'füm u ndwà a nköŋ abɛ anà làsamɛɛy nkwaaŋ u bul a bul, ");
INSERT INTO yns_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ntɔn an'kil a baar a balàbal màpää u mɛɛn isàbwà udu a bɛ, sɛmà an'kil a Abɛl mbuur a balàbal tii akà an'kil a Zakàlye, mwan a Balaki, awà làdwä bɛ uboboo a idwà anà mɛsà a ibɔɔn. ");
INSERT INTO yns_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Undiir awun, waa mɛ amàlakyään ndandaa naa: mpay a ube abà banswà isàbwà u du a un'tswe a nkööl a ŋàbà! » ");
INSERT INTO yns_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","« Yɛlusàlɛm, Yɛlusàlɛm, ngye, ngye mbuur afàdwa aŋangɔɔm anà afàtà bumwɛy katööm Nzam in'kul. Mbalà kwe kàkwen mɛ muböbà baan angye ikal imwɛy apà mɛ asànaa ngwän a nkɔɔ ufàböbà wa baan awa u ngyɛl a an'paab ande, wɛɛ ngye, ngye kàsàkwen anki! ");
INSERT INTO yns_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Undiir awun, ndwà angye bàsawɛy yà ipɔl. ");
INSERT INTO yns_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kyakin, waa mɛ amakyään ndandaa naa: Sɛmà ŋàbawà, bɛ mɛ làfàsaman anki tii làsàtɛn bɛ naa: \"Wɛy nsaak ikäl akà mbuur awà ayà kà ikɔb a Mwol!\" » ");
INSERT INTO yns_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yàmɛnà naa Yɛsu kàtoo nde u ndwà a Nzam anà kàkäl nde mukyà, alɔŋki ande bàyàsin apà nde ntɔn mukun'swaŋ ntööŋ a ndwà a Nzam. ");
INSERT INTO yns_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nde waa kàfuur naa: « Nkye bɛ làkimanà indiir abi byanswà? Ndandaa mɛ alàkyään, akà nkɔŋ mwɛy ifàsàsal anki udu a nkɔŋ yumwɛy. Ya yanswà ikyer asàpää. » ");
INSERT INTO yns_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yɛsu kàkäl wàŋàbwaay udu a mɔŋ a in'te a ɔlive, alɔŋki bàsin apà nde, waa bàtɛn a nde naa: « Ikyään taaŋ isàyà ndaa ayi, idiim nà isàswaŋ ngyeel angye anà ntsüü a mɛɛn. » ");
INSERT INTO yns_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yɛsu kafuur naa: « Làkäl kà igyɛɛŋ, wɛy mbuur ukɔɔn alakur. ");
INSERT INTO yns_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ntɔn baar mbɔɔn bàsàyà kà ikɔb amɛ, waa bàsàtɛn naa: \"Mɛ in'wà Klistɔ!\" Ba bàsàkur baar mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bɛ làsàwem naa bye anà ità anà in'bää a ità. Twon lan'tɛɛr: indiir abi ikyer ayà, wɛɛ bya kà ntsüü anki. ");
INSERT INTO yns_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Un'sɛŋ mwɛy asànwaan anà un'sɛŋ wumwɛy, imwol mwɛy anà imwol kyumwɛy, kà itiir a nsi imwɛy imwɛy, ngyal ikyer asàkal anà mɛɛn ikyer asàtɛɛr. ");
INSERT INTO yns_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wɛɛ indiir abi byanswà byàsàkal nsɛmà a usaay. ");
INSERT INTO yns_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Apan, bàsàlasà u ngyɛb aŋàdiir, waa bàsàladwa. In'sɛŋ myanswà ikyer asàlayiiŋ ntɔn ikɔb amɛ. ");
INSERT INTO yns_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Apan, bàmbɔɔn bàsàpiy làkwikilà aba, ba bàsàmɛɛn nku ba a ba, anà bàsàyiiŋ ba a ba. ");
INSERT INTO yns_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aŋangɔɔm a loor mbɔɔn bàkyer asàmbarà, waa bàsàbwiy baar mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ukwen a baar mbɔɔn bàsàbwà mpye, ntɔn ube bàkyer asàsöönà. ");
INSERT INTO yns_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wɛɛ mbuur asàsà muküünà tii u ntsüü, asàwà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Làsaŋ Aŋàbwaŋ là Imwol alà bàkyer asàkyään la u mɛɛn manswà. Kya isàkal imbäl ntɔn in'sɛŋ myanswà. Apan waa ntsüü isàyà. » ");
INSERT INTO yns_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","« Lalan, mpal làsàman bɛ lingyoomà mbɔɔn alà kàtɛn ŋangɔɔm Danyel lan'bilà kà ikal a in'kyɛɛl, - wɛy mbuur akataŋà uyöb! - ");
INSERT INTO yns_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Apan, wɛy baar bàsàkal u Yuday, bàtiin uboo a myɔŋ, ");
INSERT INTO yns_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","wɛy mbuur asàkal udu a nsyä a ndwà, ukɔɔn ayàtɔlà ntɔn muwal indiir abyà uboo a ndwà ande, ");
INSERT INTO yns_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","wɛy mbuur awà u ywaŋ ande, ukɔɔn afurà ndwà ntɔn mukàwal ipfɛy ande. ");
INSERT INTO yns_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ngyɛb akà akaar aŋayöm anà akaar bàsàkal munüü baan kà ilä abin! ");
INSERT INTO yns_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Làyamà ntɔn bɛ làkɔɔn asàtiin u paŋà a làbe, itàkal kà ilä a saba! ");
INSERT INTO yns_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ntɔn, umpal ayin, isàkal anà ngyɛb aŋàdiir mpa aŋàtàkal fà nsɛmà a mɛɛn tii ŋàbà, anà ya sye ifàsàkal anki akà ikikye. ");
INSERT INTO yns_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yàlàkal naa Nzam ukɔ̈ɔ̈n atyey ilä abin, akà mbuur mwɛy kàlàwà anki mɔ̈ɔ̈. Wɛɛ, ntɔn baar kàsɔ̈ɔ̈l nde, ilä abin isàkal byàŋàtyeey. ");
INSERT INTO yns_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Apan, isàkal naa mbuur mwɛy kan'tɛn a bɛ naa: \"Làler, Klistɔ awà kà!\" Itàkal naa: \"Nde awunà kunà!\", twon lun'kyey. ");
INSERT INTO yns_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ntɔn aklistɔ a loor anà aŋangɔɔm a loor bàkyer asàmbarà, bàsàkyer idiim a kölàköl anà impà ntɔn mukur baar, kya ipöl isàkal, itàkal baar bàŋàsɔɔl. ");
INSERT INTO yns_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Làler, mɛ ya amàlaweey kusà. » ");
INSERT INTO yns_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","« Abun, isàkal naa bàmàlakyään naa: \"Làler, nde wà u nsye a ipɔl!\", twon lan'kyà. \"Nde wà kà ikal a mpey\", twon lan'kyey. ");
INSERT INTO yns_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ntɔn, ngyeel a Mwan a mbuur isàkal asànaa muŋyä ufàpàrà wa fà mper làfàsɛnà taaŋ tii mper làfàkàminà la. ");
INSERT INTO yns_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ntsü yanswà iwà ndom, nɛn ayifàdyà in'twaŋ ifàkàköŋ kwo. » ");
INSERT INTO yns_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","« Taaŋ a mbɔɔn tɛy ungö a mpay a kölàköl yà ilä abin, taaŋ làsàbwà làpib, nsöŋ ifàsàpà anki kyɛɛy a wa, mbwaar ikyer asàbwà fà du, ngwal a du ikyer asàni. ");
INSERT INTO yns_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Apan, idiim a Mwan a mbuur isàmɛnà u du, apan in'sɛŋ myanswà amyà u mɛɛn ikyer asàlaal, mya isàman Mwan a mbuur wàmuyà uboo a itööm a du anà unkaak a ngwal anà làkoo. ");
INSERT INTO yns_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nde asàtɔm akyeey ande anà mfuŋ a kölàköl, waa ba bàsàtüüb baar kàsɔ̈ɔ̈l nde u mper yànà, fà nswɛŋ a du tii nswɛŋ yumwɛy. » ");
INSERT INTO yns_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","« Làyöb an'lɔɔŋ man'fà unsà un'te a fige: isàkal naa an'kɔkà ande man'bulà an'dà an'dà anà nkay sye yan'too, làyöb apan naa paŋà aŋàbwaŋ là tsütsü. ");
INSERT INTO yns_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Abun, akà bɛ sye, mpal làsàman bɛ indiir abi byanswà, làyöb naa Mwan a Mbuur wà tsütsü a minambwo a ndwà abɛ. ");
INSERT INTO yns_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ndandaa mɛ alàkyään, nkööl ayi isàkal aŋàlyaŋ anki kusà a ndaa ayi muyà. ");
INSERT INTO yns_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Du anà mɛɛn màkyer asàlyaŋ, wɛɛ ndaa amɛ isàlyaŋ anki akà ikikye. » ");
INSERT INTO yns_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","« Wɛɛ akà mbuur mwɛy uyöb anki ilä kya anà taaŋ la, itàkal akyeey, itàkal Mwan, nà Taa mpɛl. ");
INSERT INTO yns_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Asànaa ndaa yàlyaŋ utaaŋ a Nɔwà, ngyeel a Mwan a mbuur isàkal abun sye. ");
INSERT INTO yns_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ntɔn, u paŋà alan, kusà ikül a mbul muyööl mɛɛn, baar bàkäl mudyà, munwà, mutà an'bɔr anà mupà baan aba an'bɔr tii ilä kàbilà Nɔwà kà an'swà. ");
INSERT INTO yns_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba bàmɛnà anki akà ube mwɛy tii ilä màyöl an'dà anà masyen ma ba banswà. Ya isàkal sye abun umpal usàyà Mwan a mbuur. ");
INSERT INTO yns_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Apan, abaal bɔ̈ɔ̈l bàsàkal kan'ywaŋ: umwɛy bàkyer asun'syen, wumwɛy bàkyer asun'wɛy. ");
INSERT INTO yns_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akaar bɔ̈ɔ̈l bàsàkal muyir: umwɛy bàkyer asun'syɛn, wumwɛy bàkyer asun'wɛy. ");
INSERT INTO yns_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Abun, làkäl kà igyɛɛŋ, ntɔn bɛ làyöb anki ilä usàyà Mwol abɛ. ");
INSERT INTO yns_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bɛ làkyàyöb: yàlàkal naa ŋandwà akiyöbà naa taaŋ nà mbüüb usàyà u mpib, nde kàlikalà kà igyɛɛŋ anà nde kàlun'wɛyà anki mubilà u ndwà ande. ");
INSERT INTO yns_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Undiir awun, bɛ sye làkäl aŋàlɔ̈ɔ̈n, ntɔn Mwan a mbuur asàyà u taaŋ mpa làsàyöb bɛ. » ");
INSERT INTO yns_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","« Abun, nà awà un'syääl a lää anà wàŋàlɔ̈ɔ̈n awà kàpɛ nkum buur a asyääl a ndwà ande ntɔn mukapà isa u taaŋ a taaŋ? ");
INSERT INTO yns_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Un'sak akà un'syääl awà usyetaan nkum ande, taaŋ usàyà nde, wàmukyer abà! ");
INSERT INTO yns_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ndandaa mɛ alàkyään, nde asun'pà buur a indiir ande byanswà. ");
INSERT INTO yns_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Wɛɛ, isàkal naa nde wà un'syääl un'be, nde asàyweer naa: \"Nkum amɛ usyefurà anki agyägyä\", ");
INSERT INTO yns_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","anà nde ubulà mudüb atɔŋ ande bà isal, mudyà anà munwà ikal imwɛy a in'yöör a man, ");
INSERT INTO yns_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nkum a un'syääl awà asàyà kà ilä anà u taaŋ mpa uyöb nde. ");
INSERT INTO yns_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nde akyer asun'böŋ anà asun'pà ntaaŋàmbar ikwe a baar a mpem yweel: kwo isàkal ilel anà nkwoor a an'din. » ");
INSERT INTO yns_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","« Apan, Imwol a du isàkal asànaa baan asye ankɔr bàwɛl minà aba ntɔn mukàbwey a un'dim aba. ");
INSERT INTO yns_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Atyeen uboo a ba bàkäl insil, atyeen bàkäl aŋan'yeerà. ");
INSERT INTO yns_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Insil bàwɛl ba minà, ba bàsyen anki may. ");
INSERT INTO yns_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Asye aŋan'yeerà, bàwɛl ba minà, ba bàwɛl anà may unsà in'laŋ. ");
INSERT INTO yns_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kyekà baal atà bɔr kàkyer itaan muyà, undiir awun ba banswà bàbɔ̈ɔ̈n ba. ");
INSERT INTO yns_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Uboboo a mpib, ba bàwem làso làmwɛy: \"Le baal atà bɔr! Làkyen kàlabwey anà nde!\" ");
INSERT INTO yns_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Apan, asye ankɔr banswà bàwiyà ba, ba bàsɛmà mulɔn minà aba. ");
INSERT INTO yns_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Asye insil bàtɛn a asye aŋan'yeerà naa: \"Lipɛ bi ndam a may, ntɔn minà abi myàmudim.\" ");
INSERT INTO yns_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aŋan'yeerà bàfuur naa: \"Aay, may ikwo anki ntɔn bɛ anà bi. Làkyen kàlasöm akà baar bàfàyälà ma.\" ");
INSERT INTO yns_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mpal bàkyen ba mukàsom ma, baal atà bɔr laa kàyàkɔlà nde. Asye akwà bàkäl aŋàlɔ̈ɔ̈n bàbilà mbwo mwɛy anà nde u ndwà atà bɔr, waa bàdübà ibeenà. ");
INSERT INTO yns_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ungöngö, asye ankɔr bumwɛy bàyi ba, ba bàtɛn naa: \"nkum, nkum, iduub!\" ");
INSERT INTO yns_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Wɛɛ nde kafuur naa: \"Mɛ alàkyään ndandaa naa mɛ alàyöb anki.\" ");
INSERT INTO yns_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Undiir awun, làkäl aŋàlɔ̈ɔ̈n taaŋ lanswà. Ntɔn bɛ làyöb anki itàkal ilä, itàkal taaŋ. » ");
INSERT INTO yns_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","« Ya isàkal asànaa mbuur mwɛy kàkyà nkyeen, nde kàbel asyääl ande, waa kapɛ indiir ande. ");
INSERT INTO yns_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nde mbuur mwɛy kun'pɛ itɛr ityeen, akà wumwɛy ibyeel, akà wumwɛy sye imwɛy mpɛl, mbuur mbuur asànaa awà un'kanà ande. Apan nde waa kàkyen. ");
INSERT INTO yns_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mbuur awà kàwɛl itɛr ityeen, kàkyen musal anà byà, waa kàwɛl bweel a itɛr ityeen asin. ");
INSERT INTO yns_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ifà imwɛy sye anà mbuur awà kàwɛl itɛr ibyeel, nde kàwɛl bweel a ibyeel asin. ");
INSERT INTO yns_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wɛɛ mbuur awà kàwɛl imwɛy mpɛl, nde kàtim fu, waa kàyee ngim a nkum ande. » ");
INSERT INTO yns_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","« Ungö a ilä mbɔɔn, nkum a asyääl abà waa kàyàfurà, waa kàlɔ̈m naa ba bun'swɛŋ nsyääl a ngim ande. ");
INSERT INTO yns_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mbuur awà kàwɛl itɛr ityeen, kàsin nde, waa kàswɛŋ ityeen asin, waa kàtɛn naa: \"Nkum amɛ, ngye kampɛ itɛr ityeen, le ityeen asin kàtwey mɛ.\" ");
INSERT INTO yns_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nkum ande kàtɛn a nde naa: \"Yubwaŋ, ngye awà un'syääl aŋàbwaŋ anà wàlää. Ngye kàkäl wàlää unsà indiir ikikye, mɛ in'sasà udu a byàmbɔɔn. Yà, saŋ anà nkum angye. ");
INSERT INTO yns_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mbuur kàwɛl itɛr ibyeel kàsin nde sye, waa kàtɛn naa: \"Nkum amɛ, ngye kampɛ itɛr ibyeel, le ibyeel asin kàtwey mɛ abi.\" ");
INSERT INTO yns_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nkum ande kàtɛn a nde naa: \"Yubwaŋ, ngye awà un'syääl aŋàbwaŋ anà wàlää. Ngye kàkäl wàlää unsà indiir ikikye, mɛ in'sasà udu a byàmbɔɔn. Yà, saŋ anà nkum angye.\" ");
INSERT INTO yns_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mbuur kàwɛl itɛr imwɛy mpɛl, kàsin nde sye, waa kàtɛn naa: \"Nkum amɛ, mɛ in'kyàyöb naa­ ngye awà mbuur a ndaa a ngwal: Ngye afàbwo kà ikal mpa kàkön ngye, ngye afàköŋà kà ikal mpa kàmwɛŋ ngye. ");
INSERT INTO yns_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mɛ kàmɛn bɔɔmà, lalan kàkàdye mɛ itɛr angye u mɛɛn, le undiir angye awà.\" ");
INSERT INTO yns_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Wɛɛ nkum ande kun'fuur naa: \"Un'syääl un'be, un'bwal! Ngye kàkiyöbà naa mɛ in'fàbwo kà ikal mpa kàkön mɛ anà mɛ in'fàköŋà kà ikal mpa kàmwɛŋ mɛ. ");
INSERT INTO yns_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Abun yàlàbwaŋ naa ngye atɔ̈l ngim amɛ u bank: u mfurà amɛ, mɛ in'làkàtwey undiir amɛ anà bweel udu. ");
INSERT INTO yns_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Abun, lun'lwom itɛr akin, làpɛ kya akà mbuur awe abyà itɛr kwem. ");
INSERT INTO yns_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ntɔn, bàsàpà akà mbuur awe anà indiir mbɔɔn, waa nde usàkal abyà byàŋàsöön mbɔɔn, wɛɛ bàsàlwom akà mbuur akwà mpa awe anà undiir, bàsàlwom itàkal undiir kàkäl nde awà. ");
INSERT INTO yns_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Akà un'syääl akɔ̈ɔ̈n ndöŋ wà, lun'tɔɔm u làpib u nsà: kwo isàkal ilel anà nkwoor a an'din.\" » ");
INSERT INTO yns_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","« Mpal usàyà Mwan a mbuur unsà làkoo ande anà akyeey banswà, apan nde asàbwaay udu a kir a làkoo ande. ");
INSERT INTO yns_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","In'sɛŋ myanswà myàsàköŋ kusà ande. Nde asàkaab baar amwɛy anà bumwɛy, asànaa un'seey ufàkaab nde in'kɔk anà ntab. ");
INSERT INTO yns_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nde in'kɔk asasà u kɔɔ ande libaal, ntab u kɔɔ ande likaar. ");
INSERT INTO yns_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Apan, mfum asàtɛn a baar bàsàkal u kɔɔ ande libaal naa: \"Làyi, bɛ baar kàsaak Taaràmɛ. Làbilà ubɔɔ a imwol akyà bàlɔ̈ɔ̈n ntɔn bɛ sɛmà bàkyer mɛɛn. ");
INSERT INTO yns_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ntɔn mɛ, mɛ kàkäl anà ngyal, bɛ lan'pɛ isaa adyà. Mɛ kàkäl anà mfwää, bɛ lan'pɛ undiir anwà. Mɛ kàkäl ungyey, bɛ waa lan'wɛl, ");
INSERT INTO yns_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mɛ kàkäl wànsàpɔl, bɛ waa lan'bwää. Mɛ kàkäl anà ukyal, bɛ waa làyan'ler. Mɛ kàkäl u bɔlokà, bɛ waa làyan'ler.\" ");
INSERT INTO yns_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Apan, baar a balàbal bàsun'fuur naa: \"Mwol, mpal nà kamɛn bi anà ngyal, waa bi kapɛ isaa adyà, itàkal anà mfwää, waa bi kapɛ undiir anwà? ");
INSERT INTO yns_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mpal nà kamɛn bi ungyey, waa bi kawɛl, itàkal wànsàpɔl waa bi kabwää? ");
INSERT INTO yns_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mpal nà kamɛn bi anà ukyal itàkal u bɔlokà, waa bi kàyaler?\" ");
INSERT INTO yns_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mfum usafuur naa: \"Mɛ, mɛ alakyään ndandaa: mbalà yanswà ayà làkyer bɛ indiir abi akà umwɛy ubɔɔ a bibaan akye bà, abà atɔŋ amɛ, bɛ bya làkyer akà mɛ.\" » ");
INSERT INTO yns_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","« Abun, nde asàtɛn a baar bàsàkal u kɔɔ ande likaar naa: \"Baar aŋàküül! Làkyà kunà! Làkyen u mbaa a mbul a in'tye ayà bàyöŋà ntɔn ileŋ anà akyeey ande! ");
INSERT INTO yns_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ntɔn mɛ kàkäl anà ngyal, wɛɛ bɛ udyà lan'pɛ anki. Mɛ kàkäl anà mfwää, wɛɛ bɛ undiir anwà lan'pɛ anki. ");
INSERT INTO yns_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mɛ kàkäl ungyey, wɛɛ bɛ lan'wɛl anki, wànsàpɔl, wɛɛ bɛ lan'bwää anki. Mɛ kàkäl anà ukyal anà u bɔlokà, wɛɛ bɛ làyan'ler anki.\" ");
INSERT INTO yns_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Apan ba bàsun'fuur naa: \"Mwol, mpal nà kamɛn bi anà ngyal itàkal anà mpfwää, itàkal un'ngyey, itàkal wànsàpɔl, itàkal anà ukyal, itàkal u bɔlokà, waa bi mpa kabay?\" ");
INSERT INTO yns_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mfum waa usafuur naa: \"Mɛ, mɛ alàkyään ndandaa: mbalà yanswà mpa làkyer bɛ indiir abi byanswà akà umwɛy ubɔɔ a bibaan abi, bɛ bya sye làkyer anki akà mɛ.\" ");
INSERT INTO yns_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Baar abà bàsàkyà u ntaaŋàmbar a mbul a in'tye, wɛɛ baar a balàbal u mɔ̈ɔ̈ a mbul a in'tye. » ");
INSERT INTO yns_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mpal kàmay Yɛsu nswɛɛŋ ayi yanswà, nde kàtɛn a alɔŋki ande naa: ");
INSERT INTO yns_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","« Bɛ làkyàyöb naa un'kyɔm a Pak ayàkal ungö a ilä byeel: Mwan a mbuur bàkyer ayun'yälà, ntɔn bun'bɛɛrà u kulunsi. » ");
INSERT INTO yns_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Apan, andweer a angaŋ anà andweer a un'sɛŋ a Ayudà bakyer aköŋ u ndwà a Undweer a angaŋ Kayifa. ");
INSERT INTO yns_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ba bàtsül mukɔr Yɛsu u mbwo a loor anà mukun'dwa. ");
INSERT INTO yns_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wɛɛ, ba bàtɛɛnà naa: « Wɛy ya ikɔɔn akal umpal bàkyɔɔmà ba, manà lingyoomà làyàbwà uboo a un'sɛŋ. » ");
INSERT INTO yns_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yɛsu kàkäl u Bɛtani u ndwà a Simɔn ŋabay. ");
INSERT INTO yns_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Un'kaar mwɛy kàyàsin apà nde anà un'laŋ wàŋàyɔl a may a usɔŋ bàfàbel naa albatre. Ma mà ntal mbɔɔn. Nde kàtyaŋ ma udu a un'tswe a Yɛsu mpal kàkäl nde mudyà. ");
INSERT INTO yns_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mpal bàmɛn alɔŋki abun, ba bàmɛn ube mbɔɔn, waa bàtɛn naa: « Ntɔn nkye ubii a tub abà? ");
INSERT INTO yns_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yàlàbwaŋ muyälà may a usɔŋ amà u ntal a mbɔɔn, waa ngim ayin bàlàpà aŋàlàmbwà! » ");
INSERT INTO yns_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mpal kàyöb Yɛsu an'kyän aba, nde kàtɛn a ba naa: « Ntɔn nkye làpà bɛ un'kaar wà mpay? Nde kan'kyer ndaa aŋàbwaŋ ntɔn mɛ. ");
INSERT INTO yns_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ntɔn aŋàlàmbwà bà anà bɛ ilä byanswà, wɛɛ mɛ, mɛ in'wà anki anà bɛ ilä byanswà. ");
INSERT INTO yns_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kan'tyaŋ nde may a usɔŋ mà udu a ndür amɛ, nde kan'lɔɔn ndyee amɛ. ");
INSERT INTO yns_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ndandaa mɛ alakyään: mper yanswà bàsàkàkyään Làsaŋ Aŋàbwaŋ, u mɛɛn manswà, bàsakyäänà sye ndaa kan'kyer un'kaar wà, ntɔn mukun'yɔbà. » ");
INSERT INTO yns_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Apan, Yudasi Isikalyɔt, umwɛy uboo a alɔŋki kwem aŋiyweel bà Yɛsu, kàkàman andweer a angaŋ, ");
INSERT INTO yns_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","waa kàtɛn a ba naa: « Ininà bɛ lan'pà, waa mɛ alàpà awà? » Ba bun'pɛ itɛr a ngim an'kwem an'tär. ");
INSERT INTO yns_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sɛmà apan, Yudasi kàyileŋà ipöl aŋàbwaŋ ntɔn mukapɛɛl awà. ");
INSERT INTO yns_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ilä a tàtwɛb kyà un'kyɔm a mampà màkɔ̈ɔ̈n ful, alɔŋki bàyi akà Yɛsu mukun'fuul naa: « Ngye akwen naa bi ikàlɔn ken ikal adyà ngye Pak? » ");
INSERT INTO yns_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yɛsu kàtɛn a ba naa: « Làkyen u bul a kölàköl, akà mbuur mwɛy, lun'kyään naa: \"Un'lɔɔŋ an'tɛn naa: Taaŋ amɛ là tsütsü, mɛ anà alɔŋki amɛ in'yàdyà Pak u ndwà angye.\" » ");
INSERT INTO yns_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Alɔŋki bàlɔ̈ɔ̈n Pak asànaa kaswɛŋ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mpal a sisye, Yɛsu kàkäl u mɛsà anà Bàkwem Aŋiyweel. ");
INSERT INTO yns_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mpal bàkäl ba mudyà, Yɛsu kàtɛn naa: « Ndandaa mɛ alàkyään: umwɛy uboo a bɛ ayan'mɛɛn nku. » ");
INSERT INTO yns_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ba bàmɛn ngyɛb mbɔɔn, waa bàsɛmà mukun'fuul umwɛy umwɛy naa: « Mwol, nkye mɛ? » ");
INSERT INTO yns_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yɛsu kafuur naa: « Mbuur awà kan'biil kɔɔ mbwo mwɛy anà mɛ uboo a làlɔŋà a isaa, mbuur nsil awà ayan'mɛɛn nku. ");
INSERT INTO yns_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwan a mbuur wàmukyà asànaa Ndaa Aŋàsɔn ikyäänà ya ntɔn nde. Wɛɛ ngyɛb akà mbuur amɛɛn Mwan a mbuur nku! Yàlàkal ubwaŋ naa mbuur awà bàkɔɔn a un'bɔr! » ");
INSERT INTO yns_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudasi, mbuur ayun'yälà, kun'fuul naa: « Mwol, nkye mɛ? » Yɛsu kun'fuur naa: « Ngye ŋakwo an'tɛn. » ");
INSERT INTO yns_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Umpal bàkäl ba mudyà, Yɛsu kàwɛl mampà, ungö kàsaak nde ma, nde kàtsül ma, kàpɛ alɔŋki ande, waa kàtɛn naa: « Mää, làdi, ayi yà ndür amɛ. » ");
INSERT INTO yns_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ungö, nde kàwɛl kɔɔb a vin, ungö mufuur an'tɔɔn, nde kàpɛ ba, waa kàtɛn naa: « Lànü la bɛ banswà, ");
INSERT INTO yns_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ntɔn mamà an'kil amɛ, an'kil a un'tüüb, màpää ntɔn un'kàbɔ a baar, ntɔn ndwääl a nkul a man'be aba. ");
INSERT INTO yns_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mɛ, mɛ alàkyään naa: sɛmà apanà, mɛ in'fàsànwà anki vin tii ilä in'sànwà mɛ vin akün mbwo mwɛy anà bɛ uboo a Imwol a Taaràmɛ. » ");
INSERT INTO yns_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ungö mutɔl an'diim a un'kyɔm, ba bàtoo ntɔn mukyà mɔŋ a In'te a ɔlive. ");
INSERT INTO yns_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Apan, Yɛsu kàtɛn a alɔŋki ande naa: « U mpib a ŋàbà, bɛ banswà làkyer abwà ntɔn mɛ. Ntɔn bàsön naa: \"Mɛ, mɛ in'sàdwa un'kyɛɛŋ a in'kɔk, waa in'kɔk a làböl myàsàtà upay.\" ");
INSERT INTO yns_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wɛɛ, mpal in'sàwiyà mɛ, mɛ in'sàlafweel u Ngalilɛ. » ");
INSERT INTO yns_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petɔlà kàwɛl ndaa, waa kàtɛn naa: « Itàkal naa ba banswà ban'bwà ntɔn ngye, wɛɛ mɛ, mɛ in'sàbwà anki akà ikikye. » ");
INSERT INTO yns_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yɛsu kàtɛn a nde naa: « Mɛ, ndandaa mɛ akyään: u mpib nsil ayi, kusà a nkɔɔ mutàbeel, ngye ayan'tɔn mbalà tär. » ");
INSERT INTO yns_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petɔlà kàtɛn a nde naa: « Itàkal naa mɛ in'kyer akwà anà ngye, aay, mɛ in'satɔn anki. » Waa alɔŋki banswà bàtɛn sye mun mwɛy wa. ");
INSERT INTO yns_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yɛsu kàyàkɔlà anà alɔŋki ande kà ikal mwɛy bàfàbel Ngɛtɛsɛmani, waa kàtɛn a ba naa: « Sàlàbwaayà pà, mpal in'kàyamà mɛ kunà. » ");
INSERT INTO yns_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ungö apan nde kàsyen Petɔlà anà baan a Zebeday babaal bàbɔ̈ɔ̈l, waa kàsɛmà muman ngyɛb anà bɔɔmà aŋàdiir. ");
INSERT INTO yns_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Apan nde kàtɛn a ba naa: « Mpem amɛ yàŋàyɔl a ngyɛb mbɔɔn tsütsü a ukwà. Sàlakälà pà anà làgyɛɛŋ anà mɛ. » ");
INSERT INTO yns_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nde kàkyen u kikwɛl, waa kàbü, ntabwey u mɛɛn, waa kàyamà abà: « Taa, kya mbwo isàkal, wɛy kɔɔb là làlyaŋ ukwɛl apà mɛ! Itàkal naa abwɛy, kyer ukwen angye, wɛɛ kà bàmɛ anki. » ");
INSERT INTO yns_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nde kan'yà ntsü bàkäl alɔŋki ande batär, waa kàmaman bàŋàbɔ̈ɔ̈n. Nde kan'tɛn a Petɔlà naa: « Abà, nkye bɛ làkal anki anà ngwal mukyɛɛŋ itàkal taaŋ làmwɛy anà mɛ! ");
INSERT INTO yns_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Làkyɛɛŋ anà làyamà, ntɔn bɛ làkɔ̈ɔ̈n abwà u ndɛb. Dweelà làŋàyɔl a ngwal, wɛɛ ndür ye anà ukwarà. » ");
INSERT INTO yns_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","U mbalà yàyweel, nde kàkyà ukwel, waa kàyamà abà: « Taaràmɛ, isàkal naa ikwe anki naa kɔɔb làlyaŋ, naa mɛ in'kɔ̈ɔ̈n anwà la, wɛy ukwen angye bàkäl! » ");
INSERT INTO yns_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","U mbalà asin kàfàyà nde apà alɔŋki ande, nde kàfaman bàŋàbɔ̈ɔ̈n, ntɔn mii aba myàkäl myàŋàbwà buur. ");
INSERT INTO yns_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yɛsu waa kàsawɛy, waa kàkyen ukwɛl, waa kàyamà mbalà yàtär, wàmufuur ndaa nsil ya. ");
INSERT INTO yns_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Apan, kàyi nde apà alɔŋki, nde kàtɛn a ba naa: « Fàlabɔ̈ɔ̈nà, fàlàyöörà! Kyekà taaŋ bàyälà ba Mwan a mbuur kà an'kɔɔ a baar abe lye tsütsü. ");
INSERT INTO yns_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Làmbarà! Tsweenà! Le mbuur kàman'yälà wà tsütsü! » ");
INSERT INTO yns_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Umpal kàkäl nde muyäämà, Yudasi, umwɛy uboo a Bàkwem Aŋiyweel kàyàkɔlà anà iköŋ a baar mbɔɔn bàtöm andweer a angaŋ anà andweer a un'sɛŋ. Ba bàkäl anà an'kɔm anà nköl. ");
INSERT INTO yns_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mbuur kun'yälà, kapɛ idiim ki: « Mbuur wanswà in'kàböbà mɛ, mbuur wa nde awun. Lun'kör. » ");
INSERT INTO yns_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Taaŋ nsil alan, Yudasi kàsin apà Yɛsu, waa kàtɛn a nde naa: « Un'lɔɔŋ, mbɔr angye! » Waa kun'böbà. ");
INSERT INTO yns_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yɛsu kàtɛn a nde naa: « Un'sam, kyer undiir ayeel ngye. » Apan, laa bàsin ba, bun'tɛ ba mpi, waa bun'kör. ");
INSERT INTO yns_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Umwɛy uboo a baar bàkäl a Yɛsu, kàsilà kɔɔ, waa kàtwey kɔm ande, laa kàkäm nde un'syääl a undweer a angaŋ, waa kun'tsül tsü. ");
INSERT INTO yns_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Apan, Yɛsu waa kàtɛn a nde naa: « Fuur kɔm angye kà ikal a la, ntɔn baar banswà bàfàsyääl kɔm, bàsàkwà a kɔm. ");
INSERT INTO yns_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nkye ngye ayöb anki naa mɛ an'kwo in'lɔ̈ɔ̈m akà Taaràmɛ, nde sye kan'tööm in'lwaaŋ kwem aŋiyweel myà akyeey làgyägyä? ");
INSERT INTO yns_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ndaa Aŋàsön ayà itɛɛnà naa ya ikal abà, yàlàkwo aben? » ");
INSERT INTO yns_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Utaaŋ alan, Yɛsu kàtɛn a iköŋ a baar naa: « Bɛ, bɛ lan'yà anà an'kɔm anà nköl ntɔn muyan'kɔr asànaa mɛ iwà un'dwää baar! Ilä byanswà mɛ kàkäl aŋàbwaay u ndwà a Nzam mulɔŋ, wɛɛ bɛ lan'nkör anki. ");
INSERT INTO yns_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wɛɛ ayi yanswà yan'yà ntɔn Ndaa Aŋàsɔn a aŋangɔɔm ikwe. » Apan, alɔŋki banswà bàkyer asun'kɔɔb, waa bàtiin. ");
INSERT INTO yns_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Baar abà bàkör Yɛsu bun'syen akà undweer a angaŋ Kayifa, ikal bàköŋ alɔɔŋ a Un'kɔɔn anà andweer. ");
INSERT INTO yns_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petɔlà kàyun'labà ukwɛl tii u làpaŋ a undweer a angaŋ. Nde kàbilà u làpaŋ, waa kàbwaay ikal imwɛy anà aseey ntɔn muler naa ya ikàtsü aben. ");
INSERT INTO yns_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Amfum a angaŋ anà Làbay a nsaŋ a kölàköl lanswà bàleŋà imbäl a loor ntɔn Yɛsu ntɔn bun'tsüül mbar a ukwà. ");
INSERT INTO yns_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Itàkal naa ambäl a loor mbɔɔn bàkyer ayàmɛnà, wɛɛ ba bàmɛn anki akà imbäl mwɛy. Ungöngö, abɔ̈ɔ̈l waa bàyàmɛnà, ");
INSERT INTO yns_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","waa bàtɛn naa: « Mbuur wà kàtɛn naa: \"Mɛ an'kwo in'bwaab ndwà a Nzam, waa in'fàtɔŋ ya ungö a ilä itär.\" » ");
INSERT INTO yns_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Undweer a angaŋ laa kàmbarà nde, waa kàtɛn a Yɛsu naa: « Nkye ngye undiir afuur anki unsà ya yanswà bafüünà baar bà? » ");
INSERT INTO yns_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wɛɛ Yɛsu kàkälà a duu. Waa undweer a angaŋ kàtɛn a nde naa: « Mɛ amaswaŋ kà ikɔb a Nzam a mɔ̈ɔ̈, tɛn a bi, isàkal naa ngye, ngye awà Klistɔ, Mwan a Nzam. » ");
INSERT INTO yns_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yɛsu kun'fuur naa: « Ngye an'tɛn ya. Wɛɛ mɛ, mɛ alàkyään naa semà apanà, bɛ làsàman Mwan a mbuur akyàbwaay u kɔɔ a ibaal a Ngwal anà wàmuyà udu a an'töb a du. » ");
INSERT INTO yns_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Apan, undweer a angaŋ kàkaam ipfɛy ande, waa kàtɛn naa: « Nde wàmubɛy! Bi ambäl nkye ifàkyer abà! Apanà bɛ lan'wem mbɛɛy ande! ");
INSERT INTO yns_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","An'kyän abɛ mà aben? » Ba bàfuur naa: « Nde akyà ukwà. » ");
INSERT INTO yns_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Apan ba bun'tsül an'te u ntabwey, bun'düb iki, bumwɛy bun'käm an'füm. ");
INSERT INTO yns_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ba bàtɛn a nde naa: « Ɛɛ, Klistɔ, bulà ŋangɔɔm ntɔn bi! Ikyään, nà kàmakam mbar? » ");
INSERT INTO yns_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kyekà Petɔlà kàkäl aŋàbwaay u nsà, uboo a làpaŋ. Un'syääl mwɛy wun'kaar kàsin apà nde, waa kàtɛn a nde naa: « Ngye sye, ngye kàkäl anà Yɛsu, un'nsi Ngalilɛ. » ");
INSERT INTO yns_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wɛɛ nde kàtön u mii a baar banswà, waa kàtɛn naa: « Mɛ, mɛ in'yöb anki naa ngye ininà atɛɛnà. » ");
INSERT INTO yns_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nde kàkäl mukyà mper akà munàmbwo a làpaŋ, mpal kun'mɛn un'syääl asin wun'kaar anà kàtɛn nde a baar bàkäl paa: « Mbuur wà kàkäl a Yɛsu un'nazɔrya. » ");
INSERT INTO yns_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nde kàfàtɔn mbalà asin, waa kàdi kyän naa: « Mɛ, mɛ mbuur awà un'yöb anki. » ");
INSERT INTO yns_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ungö ikye, baar bàkäl paa bàsin apà Petɔlà, waa bàtɛn a nde naa: « Ndandaa, ngye sye awà umwɛy uboo a baar banà, ntɔn ntɛɛn angye ikaswaŋà ubwaŋàbwaŋ. » ");
INSERT INTO yns_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Apan, nde kàsɛmà mudyà kyän anà muŋan naa: « Mɛ, mɛ un'yöb anki mbuur awà! » Apan sye nkɔɔ mwɛy waa kàbel. ");
INSERT INTO yns_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petɔlà kàyɔbà ndaa kàtɛn Yɛsu naa: « Kusà nkɔɔ mutàbel, ngye ayan'tɔn mbalà tär. » Laa kàtoo nde, waa kàlel a un'kwoon wanswà. ");
INSERT INTO yns_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ututu tutu, andweer a angaŋ anà andweer a un'sɛŋ bàköŋ ntɔn mutsüül Yɛsu mbar a ukwà. ");
INSERT INTO yns_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba bun'bäm in'siŋ, bun'twääl, waa bun'pɛ akà kuvɛrnɔ̈ɔ̈r Pilatu. ");
INSERT INTO yns_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Apan, Yudasi mbuur kun'yälà, umpal kàwem nde naa Yɛsu bàmutsüül mbar a ukwà, nde kàfuur an'kyän, waa kàyàfuur itɛr a ngim an'kwem an'tär akà andweer a angaŋ anà andweer a un'sɛŋ. ");
INSERT INTO yns_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Waa kàtɛn naa: « Mɛ, mɛ kàkyer ube muyälà an'kil ikɔ̈ɔ̈n ube! » Wɛɛ ba bun'fuur naa: « Kwo akà bi nkye? Nsaŋ angye ŋakwo! » ");
INSERT INTO yns_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudasi kàwɔm itɛr a ngim bya uboo a ndwà a Nzam, laa kàtoo nde, waa kàkàbäm un'siŋ. ");
INSERT INTO yns_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Andweer a angaŋ bàwɛl ngim ayi, waa bàtɛn naa: « Ikwe tɛy musà ngim ayi uboo a un'naaŋ a ndwà a Nzam, ntɔn ya yà ngim a an'kil. » ");
INSERT INTO yns_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ungö bàköŋ ba, ba bàsöm ywaŋ akà un'boom a mpfwee ntɔn mudye angyey. ");
INSERT INTO yns_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Undiir awun, bàfàbel ba ywaŋ alà naa \"ywaŋ a an'kil\" tii ŋàbawà. ");
INSERT INTO yns_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Apan, ndaa kàtɛn ŋangɔɔm Yɛlɛmya waa yàkwe: « Ba bàwɛl itɛr an'kwem an'tär byà ngim, ntal bàtsül baan a Isàlɛl mukun'som, ");
INSERT INTO yns_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","waa ba bàpɛ ya ntɔn ywaŋ a un'boom a mpfwee asànaa kàswɛŋ Mwol abun. » ");
INSERT INTO yns_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yɛsu kàkäl kusà a kuvɛrnɔ̈ɔ̈r. Kuvɛrnɔ̈ɔ̈r kun'fuul naa: « Nkye ngye awà mfum a Ayuda? » Yɛsu kun'fuur naa: « Ngye ŋakwo an'tɛn. » ");
INSERT INTO yns_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wɛɛ utaaŋ bun'füünà andweer a angaŋ anà andweer a un'sɛŋ, nde akà ndaa mwɛy kàfuur anki. ");
INSERT INTO yns_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Apan Pilatu kàtɛn a nde naa: « Nkye ngye aweemà anki ndaa yanswà bafüünà ba yi? » ");
INSERT INTO yns_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nde kun'fuur anki akà undiir mwɛy. Abà, kuvɛrnɔ̈ɔ̈r kàbem mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yàmɛnà naa kà un'kyɔm wanswà, kuvɛrnɔ̈ɔ̈r kàkäl anà nkääl mutsuuŋ mbuur a bɔlokà mwɛy ntɔn un'sɛŋ, mbuur kàkwenà un'sɛŋ ŋakwo. ");
INSERT INTO yns_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Apan kàkäl anà mbuur a bɔlokà mwɛy wàŋàtoo làpaan ikɔb ande Yɛsu Barabas. ");
INSERT INTO yns_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Abun, Pilatu kàfuul iköŋ a baar bàkwe pa naa: « Nà bɛ làkwen naa mɛ alàwɛɛy awà, Yɛsu Barabas, lɛɛ Yɛsu bàfàbel Klistɔ? » ");
INSERT INTO yns_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ntɔn nde kàkyer ayöbà naa ba Yɛsu bun'pɛɛl awà ntɔn un'köl aba. ");
INSERT INTO yns_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Umpal kàkäl Pilatu mutɛɛnà ndaa u làbay a nsaŋ, un'kyay ande kun'tööm ndaa naa: « Twon an'bilà u ndaa a mbuur a balàbal wun, ntɔn ŋàbawà mɛ an'man mpay mbɔɔn u ndwɛy ntɔn nde. » ");
INSERT INTO yns_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Andweer a angaŋ anà andweer a un'sɛŋ bàsiinà iköŋ a baar a ngwal naa ba bàlɔ̈m Barabas anà bàdwä Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kuvɛrnɔ̈ɔ̈r kàfafuul naa: « Nà mɛ in'wɛy uboo a ba bàbɔ̈ɔ̈l? » – Ba naa: « Barabas! » ");
INSERT INTO yns_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatu kafuul naa: « Abun, ininà mɛ in'yàkyer anà Yɛsu bàfàbel Klistɔ? » Ba banswà bàfuur naa: « Wɛy bun'bɛɛrà u kulunsi! » ");
INSERT INTO yns_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatu kafuul naa: « Abun, ube nà nde kàkyer? » Wɛɛ ba bàsöönà musà in'kwɛŋ: « Wɛy bun'bɛɛrà u kulunsi! » ");
INSERT INTO yns_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Umpal kàmɛn Pilatu naa nde undiir asin afàkyer watɛy, wɛɛ lingyoomà làmusöönà, nde kàwɛl an'dà, kàywɛb mpin u mii a un'sɛŋ, waa kàtɛn naa: « Mɛ, mɛ un'baranki watɛy unsà an'kil a mbuur wà. Ayin nsaŋ abɛ ŋakwo! » ");
INSERT INTO yns_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wɛɛ un'sɛŋ wanswà kàfuur naa: « Wɛy an'kil ande màbü udu abi anà udu a baan abi! » ");
INSERT INTO yns_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Apan, Pilatu katsuuŋ awà Barabas. Wɛɛ akà Yɛsu, ungö akun'kam an'füm, nde kapɛ awà ntɔn bun'bɛɛrà u kulunsi. ");
INSERT INTO yns_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aŋità a kuvɛrnɔ̈ɔ̈r bàsyen Yɛsu u làpaŋ a Pilatu, un'lwaaŋ a aŋità wanswà waa kun'diŋà. ");
INSERT INTO yns_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ba bun'sɔɔl ipfɛy, waa bun'bwää kàzak a tsöö. ");
INSERT INTO yns_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ungö apan ba bun'tööŋ mpà a ibyääl yà nsyeenà, waa bun'bwää kà un'tswe, anà bun'si ibwiy u kɔɔ ande libaal. Ungö, ba bàbü an'köm, waa bun'sɛɛ naa: « Mfum a Ayudà, mbɔr angye! » ");
INSERT INTO yns_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba bun'tsüülà an'tɛ, bàwɛlà ibwiy, waa bun'kämà kya kun'tswe. ");
INSERT INTO yns_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ungö amukun'sɛɛ, ba bun'sɔɔl kàzak, waa bàfun'bwää ipfɛy ande, waa bun'syen ntɔn bàkun'bɛɛrà u kulunsi. ");
INSERT INTO yns_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Umpal bàkäl ba mutoo u bul, ba bàbweey anà un'nsi Sirɛn mwɛy ikɔb ande Simɔn. Aŋità bun'siinà a ngwal musyen kulunsi a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mpal bàtöl ba kà ikal mwɛy bàfàbel naa Ngɔlɔngɔta, iswaŋà naa « Ikal a Bɔl a Un'tswe. » ");
INSERT INTO yns_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Akun, ba bun'nüü vin aŋàtüüb a undiir a nyän. Mpal kàkyee nde la, laa kàtön nde munwà la. ");
INSERT INTO yns_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mpal bàmay ba mukun'bɛɛrà u kulunsi, ba bàtɔɔm löb ntɔn mukab ipfɛy ande. ");
INSERT INTO yns_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ungö, ba bàkäl aŋàbwaay paa mukun'lerà. ");
INSERT INTO yns_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Udu a un'tswe ande, ba bàsön isin a ndaa a nkweel ande: « Mbuur wà wà Yɛsu, mfum a Ayudà. » ");
INSERT INTO yns_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Apan, baar abe bɔ̈ɔ̈l babɛɛrà sye u kulunsi mbwo mwɛy anà nde, umwɛy u kɔɔ a ibaal, wumwɛy u kɔɔ a ikaar. ");
INSERT INTO yns_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Alyaaŋ a mbwo bàkyer un'bɛyà, bàmunii un'tswe, ");
INSERT INTO yns_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","waa bàtɛɛnà naa: « Ngye mbuur afàbwiy ndwà a Nzam anà afàtɔŋ ya unsà ilä itär, tswà mɔ̈ɔ̈ angye, ngye ŋakwo, isàkal naa ngye awà Mwan a Nzam, tɔlà u kulunsi! » ");
INSERT INTO yns_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mbwo mwɛy sye, amfum a angaŋ anà alɔɔŋ a Un'kɔɔn anà andweer bàkyer un'sɛɛ, waa bàtɛɛnà naa: ");
INSERT INTO yns_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","« Nde kàtsü baar bumwɛy mɔ̈ɔ̈, wɛɛ nde ukwe anki mutswà mɔ̈ɔ̈ ande ŋakwo! Nde wà Mfum a Isàlɛl, wɛy nde utɔlà apanà u kulunsi, waa bi iyàsà làkwikilà amu nde. ");
INSERT INTO yns_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nde kàsi làkwikilà akà Nzam, wɛy Nzam kun'tsuuŋ apanà, isàkal naa nde akyun'kwen. Ntɔn nde kàtɛn naa: \"Mɛ in'wà Mwan a Nzam.\" » ");
INSERT INTO yns_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Itàkal baar abe akwà bàbɛɛrà u kulunsi mbwo mwɛy anà nde, bàkyer un'too sye. ");
INSERT INTO yns_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sɛmà midi, làpib làkyer abwà u mɛɛn manswà tii u taaŋ làtär ungö a midi. ");
INSERT INTO yns_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ntsü a taaŋ làtär ungö a midi, Yɛsu kàsi in'kwɛŋ a ngwal: « Ɛli, Ɛli, lema sabaktani » iswaŋà naa « Nzam amɛ, Nzam amɛ, ntɔn nkye aman'piy ngye? » ");
INSERT INTO yns_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Amwɛy uboo a baar bàkäl pa, mpal bun'wem ba, ba bàtɛɛnà naa: « Le, nde kan'bel Ɛli! » ");
INSERT INTO yns_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Umwɛy uboo a ba kàkaamà ntiin, kàkàwal für làmwɛy, kànwɛmà la uboo a man a nyän, laa kàsi nde la u kite, waa kun'pɛ ntɔn munwà. ");
INSERT INTO yns_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bumwɛy bàtɛn naa: « Tàmbar bi itàler nkye Ɛli akyàyà mukun'tswà mɔ̈ɔ̈! » ");
INSERT INTO yns_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Apan Yɛsu kàfàkuub un'kwɛŋ a ngwal, waa kàkü. ");
INSERT INTO yns_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Taaŋ nsil alan, u ndwà a Nzam, rido a idwà làkyer akaamà uboboo fà du tii ngyɛl. Mɛɛn màkyer atɛɛr, nkɔŋ yàkyer abàbaarà, ");
INSERT INTO yns_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","an'dii màkyer adubà, ndür a baar inkyɛɛl mbɔɔn bàkü yàkyer awiyà: ");
INSERT INTO yns_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","bàtoo ba kan'dii, ungö a uwiyà, waa bàbilà uboo a bul in'kyɛɛl, waa bàmɛnà akà baar mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mpal bàmɛn ba ntɛɛr a mɛɛn anà ndaa yàbü, kaptɛn anà aŋità bàkäl anà nde museyà Yɛsu, bàmɛn bɔɔmà a kölàköl, waa bàtɛn naa: « Ndandaa, mbuur awà kàkäl Mwan a Nzam! » ");
INSERT INTO yns_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Paa bàkäl anà akaar mbɔɔn bàleerà ukwɛl. Ba bàyilabà Yɛsu sɛmà Ngalilɛ ntɔn muyun'syääl. ");
INSERT INTO yns_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Uboo a ba, bàkäl Màlye un'si Magàdala, Màlye ngwän a Zyak anà Yɔsɛfi, anà un'kyay a Zebeday. ");
INSERT INTO yns_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mpal làbü sisye, aŋun'naaŋ mwɛy un'nsi Arimatɛ, ikɔb ande Yɔsefi, awà kàbulà sye un'lɔŋki a Yɛsu, waa kàyàkɔlà. ");
INSERT INTO yns_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mbuur awà kàkàman Pilatu, waa kàlɔ̈ɔ̈m ndom a Yɛsu. Apan Pilatu kàswɛŋ naa bun'pɛ ayà. ");
INSERT INTO yns_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yɔsɛfi kàwɛl ya, kàläl ya ipfɛy a pɛɛl kyàkün, ");
INSERT INTO yns_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","waa kàkàtɔl ya uboo a an'dii akün amà bun'fuun u nkɔŋ. Ungö, nde kàbuum nkɔŋ ntɔn mudübà munàmbwo a an'dii. Waa kàkyen. ");
INSERT INTO yns_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Màlye un'nsi Magàdalà anà Màlye wumwɛy bàkäl paa, bàŋàbwaay u sim a an'dii. ");
INSERT INTO yns_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Taaŋtyà, ilä kyàlääb ngyööŋ a un'kyɔm a saba, amfum a angaŋ anà Amfarisi bàkyen mbwo mwɛy akà Pilatu, ");
INSERT INTO yns_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","waa bàtɛn a nde naa: « Nkum, bi kan'yɔbà naa ŋaloor wà, mpal kàkäl nde anà mɔ̈ɔ̈, kàtɛɛnà naa: \"Ungö a ilä itär, mɛ in'sàkyer awiyà.\" ");
INSERT INTO yns_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Abun, swaŋ baar musey an'dii ande tii kà ilä kyàtär, uman naa alɔŋki ande bàyàyib ndür ande anà bàyàtɛn a un'sɛŋ naa: \"Nde kàkyàwiyà uboo a akü.\" Apan loor ande làsàsöön làtàtwɛb. » ");
INSERT INTO yns_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatu kàtɛn a ba naa: « Làwɛl aŋità abà. Làkyen kàlasey an'dii asànaa làkwen bɛ. » ");
INSERT INTO yns_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Abun, bàkyen ba, ba bàbäm nkɔŋ yàkäl u munàmbwo a deŋdeŋ, waa bàsàsà aseey. ");
INSERT INTO yns_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ungö a saba, u nsɛmà a ilä atàtwɛb kyà mpɔsà, Màlye un'nsi Magàdalà anà Màlye wumwɛy, bàkyen mukàler an'dii. ");
INSERT INTO yns_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kà imbürà, mɛɛn laa màtɛɛr ma ngwal: un'kyeey a Mwol kàfü du, waa kàbuum nkɔŋ anà kàbwaay udu aya. ");
INSERT INTO yns_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nde kàkäl asànaa munyä, ipfɛy ande byàkäl byàpɛɛl asànaa für. ");
INSERT INTO yns_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aseey bàwem bɔɔmà mbɔɔn, waa bàbulà asànaa baar aŋàkwà. ");
INSERT INTO yns_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wɛɛ un'kyeey kàtɛn a akaar aban naa: « Bɛ, bɛ twon lan'man bɔɔmà. Mɛ, mɛ in'kyàyöb naa bɛ làwàmuleŋ Yɛsu awà bàbɛɛrà u kulunsi. ");
INSERT INTO yns_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nde apà watɛy, nde kan'wiyà kukwà asànaa kàtɛn nde. Yää, làmɛn ikal kàkäl nde aŋàbɔ̈ɔ̈n. ");
INSERT INTO yns_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Làkyen agyä, kàlakyään alɔŋki ande naa: \"Nde kàkyàwiyà uboo a akü, nde kan'fwel u Ngalilɛ, bɛ làyàkuman kwo.\" Le, mɛ amàlakyään. » ");
INSERT INTO yns_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Làgyägyä, ba bàlwomà kan'dii u ntiin bàŋàyɔl a bɔɔmà anà un'sak mbɔɔn, waa bàkàkyään alɔŋki ande. ");
INSERT INTO yns_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Umbalà mwɛy, Yɛsu kàyàbwey anà ba, waa kàtɛn naa: « Mbɔr abɛ! » Ba bàsin tsütsü apà nde, bun'tɛ mpi kà in'kɔl, waa bun'kömà. ");
INSERT INTO yns_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Apan, Yɛsu kàtɛn a ba naa: « Twon lan'man bɔɔmà. Kàlakyään atɔŋ amɛ bàkyen Ngalilɛ: ba bàyan'man kwo. » ");
INSERT INTO yns_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mpal bàkäl akaar u mbwo, amwɛy uboo aseey a an'dii bayi u bul, waa bàkyään amfum a angaŋ ndaa yanswà yàlyaŋ. ");
INSERT INTO yns_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Amfum a angaŋ bàköŋ anà andweer, waa bàpɛ ngim mbɔɔn akà aŋità, ");
INSERT INTO yns_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","waa baswɛŋ naa: « Bɛ làyàtɛn naa: \"Bi kàkäl bàŋàbɔ̈ɔ̈n u mpib, alɔŋki ande waa bàyun'yib.\" ");
INSERT INTO yns_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kya isàkal naa kuvɛrnɔ̈ɔ̈r kan'yöb ya, bi ikyer ayun'kwaam mpem ntɔn bɛ làkɔ̈ɔ̈n abwà u ndaa. » ");
INSERT INTO yns_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ba bàwɛl ngim ayin, waa bàläb ndaa yanswà baswɛŋ amfum a angaŋ anà andweer. Làsaŋ a ndaa ayi làkyàpää akà Ayudà tii ŋàbawà. ");
INSERT INTO yns_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Alɔŋki bàkwem aŋimwɛy bàkyen Ngalilɛ, udu a mɔŋ kaswɛŋ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mpal bun'mɛn ba, laa bun'kömà ba. Wɛɛ bumwɛy uboo aba bàkyey anki naa awà nde. ");
INSERT INTO yns_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yɛsu kàsin tsütsü apà ba, waa kàtɛn naa: « Ikɔ̈b kyanswà bàkyan'pà u du anà u mɛɛn. ");
INSERT INTO yns_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Làkyen akà in'sɛŋ myanswà, labuul alɔŋki, ladümà kà ikɔb a Taa, anà kyà Mwan, anà kyà Dweelà In'kyɛɛl, ");
INSERT INTO yns_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","anà lalɔŋ mukyer ndaa yanswà kàlaswɛŋ mɛ. Wɛɛ akà mɛ, mɛ in'wà anà bɛ ilä byanswà tii u ntsüü a mɛɛn. »");
INSERT INTO yns_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nsɛmà a Làsaŋ Aŋàbwaŋ là Yɛsu Klistɔ, Mwan a Nzam: ");
INSERT INTO yns_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Uboo a un'kaan a ŋangɔɔm Yɛsay bàsön naa: « Le, mɛ an'tɔm un'kyeey amɛ kusà a ngye ntɔn mulɔn mbwo angye. ");
INSERT INTO yns_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ndaa mwɛy yàmusà in'kwɛŋ u nsye a ipɔl: Làlɔ̈n mbwo a Mwol, làsuub myäy ande. » ");
INSERT INTO yns_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Apan Ywan Un'düümà kàkàmɛnà u nsye a ipɔl, muyilɔŋ baar mubuul mpem anà muwal ndüümà, ntɔn badwääl nkul a man'be. ");
INSERT INTO yns_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","-Itiir a Yuday kyanswà anà baar a Yɛlusàlɛm banswà bàkyeenà akà nde, bàkyeyà man'be aba, waa nde kàfadümà u Yɔrdan. ");
INSERT INTO yns_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ywan kàkäl aŋàbwaar ipfɛy a in'kà a ntsür bàfàbel naa shamo anà un'kab a iban a ntsür kyàŋàkwam u lɔŋ ande. Nde kàdyee mpay anà bwey a nsye. ");
INSERT INTO yns_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nde kàkyäänà naa: « Mbuur kàman'söön u ngwal wàmuyà ungö a mɛ. Mɛ in'kwo anki munye ntɔn mutsuuŋ in'siŋ a idyaar ande. ");
INSERT INTO yns_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mɛ, mɛ kàladümà kan'dà, wɛɛ nde, nde ayàladümà u Dweelà Inkyɛɛl. » ");
INSERT INTO yns_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yàmɛnà naa kà ilä abin Yɛsu kàfü Nasàlɛr u Ngalilɛ. Ywan kun'dümà u Yɔrdan. ");
INSERT INTO yns_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pa kàtoo nde kan'dà, nde kàmɛn du làmudubà. Dweelà kàyàtyà udu a nde asànaa nkokà. ");
INSERT INTO yns_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ndaa yàfü du, yàtɛn naa: « Ngye awà Mwan amɛ wà nkween. Mpem amɛ yanswà ye amu ngye. » ");
INSERT INTO yns_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kà imbürà, Dweelà kun'siinà u nsye a ipɔl. ");
INSERT INTO yns_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kwo, Satanà kun'lwɛb ilä an'kwem an'nà. Nde kàkälà anà ntsür a ndwaŋ, akyeey bun'syäälà. ");
INSERT INTO yns_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ungö bàyälà ba Ywan, Yɛsu kàkyen Ngalilɛ. Kwo nde kàkyäänà Làsaŋ Aŋàbwaŋ là Nzam anà mutɛn naa: ");
INSERT INTO yns_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","« Taaŋ lan'kwo, Imwol a Nzam kyan'tol tsütsü. Làbuul mpem abɛ! Làsi làkwikilà amu Làsaŋ Aŋàbwaŋ! » ");
INSERT INTO yns_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Umpal kàkäl nde mulyäŋ kà un'kɔɔl a ɛwà a Ngalilɛ, nde kàmɛn Simɔn anà Andrɛ, un'tɔŋ a Simɔn, bàmutɔɔm an'kwen aba kà ɛwà: ba bàkäl alɔ̈ɔ̈b a nsö. ");
INSERT INTO yns_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yɛsu kàtɛn a ba naa: « Yàlan'läb, waa mɛ in'yàlabuul alɔ̈ɔ̈b a baar. » ");
INSERT INTO yns_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Apan sye, ba bàsàwɛy an'kwen aba, waa bun'läb. ");
INSERT INTO yns_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kàsin nde ikye, nde kàmɛn Zyak mwan a Zebeday anà un'tɔŋ ande Ywan. Ba bàkäl uboo a bwaar aba mulɔn an'kwen. ");
INSERT INTO yns_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Apan sye, nde waa kabel. Ba bàsàwɛy taaràba Zebeday uboo a bwaar anà baar a isal, waa bun'läb. ");
INSERT INTO yns_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yɛsu anà alɔŋki ande ban'bilà u Kapɛrnawum. Apan sye, ilä a saba, nde kàbilà u ndwà a nköŋ a Ayudà, waa kàlɔɔŋà. ");
INSERT INTO yns_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Baar bàkäl mubem an'lɔɔŋ ande, ntɔn nde kàlɔɔŋà asànaa mbuur awe anà ikɔ̈b, wɛɛ kà asànaa alɔɔŋ a in'kɔɔn anki. ");
INSERT INTO yns_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kyekà uboo a ndwà a nköŋ a Ayudà akun, mbuur mwey kàkäl anà dweelà a làbe, nde kàsi in'kwɛŋ: ");
INSERT INTO yns_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","« Yɛsu, un'nsi Nasàlɛr, ininà ngye akwen akà bi? Nkye ngye ayi ntɔn muböŋ bi? Mɛ in'kyàyöb naa ngye awà nà: ngye awà Ŋun'kyeel a Nzam! » ");
INSERT INTO yns_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yɛsu kun'swɛŋ a ngwal naa: « Kal a duu! Too uboo a mbuur wà! » ");
INSERT INTO yns_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dweelà a làbe waa làtoo, lun'nini, làmuyisà un'kwɛŋ a kölàköl. ");
INSERT INTO yns_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Baar banswà bàkäl mubem, waa bàsyeelà mbaaŋ ba a ba naa: « Ndaa nà ayi? An'lɔɔŋ akün màŋàyɔl a ikɔ̈b! Nde wàmuswaŋ an'dweelà an'be a ngwal, ma sye màmukun'wem! » ");
INSERT INTO yns_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Làsaŋ a nde làpää agyägyä kà itiir a nsi a Ngalilɛ kyanswà. ");
INSERT INTO yns_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pa bàtoo ba u ndwà a nköŋ a Ayudà, ba bàkyen anà Zyak anà Ywan u ndwà a Simɔn anà Andrɛ. ");
INSERT INTO yns_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kyekà ukwà a Simɔn wun'kaar kàkäl aŋàbɔ̈ɔ̈n ntɔn nde kàkäl anà làbwey a mpye. Apan sye, ba bàsam Yɛsu ntɔn nde. ");
INSERT INTO yns_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nde kàsin tsütsü, kun'käär u kɔɔ, waa kun'mbaar. Làbwey a mpye waa làtoo, nde waa kàsɛmà mukasyääl. ");
INSERT INTO yns_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Làsisye, ungö a miinà a taaŋ, ba bun'twäälà baar an'kyal banswà anà baar bàkäl anà an'dweelà an'be. ");
INSERT INTO yns_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bul lanswà làyàköŋ u munàmbwo. ");
INSERT INTO yns_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yɛsu kàkɔɔr baar mbɔɔn bàkäl anà an'kyal a ifà ifà. Nde kàtwey sye insɔŋà mbɔɔn. Nde kàwɛy anki mbwo akà insɔŋà musà ndaa. Ntɔn mya, mya myàkyun'yöbà. ");
INSERT INTO yns_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ututu tutu, Yɛsu kàsubà nde, kàtoo u ndwà, waa kàkyen u mpey. Akun nde kàkäl muyamà. ");
INSERT INTO yns_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔn anà baar bamwey bàkäl anà nde bàkyer akun'leŋ. ");
INSERT INTO yns_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Utaaŋ bun'mɛn ba, ba bàtɛn a nde naa: « Baar banswà bàmuyaleŋ. » ");
INSERT INTO yns_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yɛsu kafuur naa: « Tsweenà ikal asin, kan'bul a tsütsü, ntɔn mɛ in'kàkyään sye Làsaŋ Aŋàbwaŋ kwo. Mɛ, mɛ kàtoo ntɔn la. » ");
INSERT INTO yns_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nde waa kàyilyaaŋà u Ngalilɛ wanswà mulɔŋ uboo a ndwà a nköŋ a Ayudà anà muböŋ insɔŋà. ");
INSERT INTO yns_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yàmɛnà naa ŋukyal a bay mwɛy kàsin apà nde, kàbü an'köm, waa kàtɛn naa: « Kya ngye akyàkwen, ngye an'kwo an'pöŋ. » ");
INSERT INTO yns_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yɛsu kun'wɛm ngyɛb mbɔɔn, kàsɛn kɔɔ, kun'bä, waa kàtɛn naa: « Mɛ an'kwen, pɔŋà! » ");
INSERT INTO yns_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Umbalà mwɛy bay waa làlwomà, nde waa kàpɔŋà. ");
INSERT INTO yns_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Apan, Yɛsu kun'fuur ndwà ande, ");
INSERT INTO yns_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ungö mukun'pà nswɛɛŋ yi: « Twon an'sam ndaa ayi akà mbuur mwɛy. Wɛɛ ngye, kyɛn kamɛnà akà ngaŋ, waa akàpà an'kab a mpööŋ asànaa kàlɔ̈m Mɔsɛ, ntɔn mukaswaŋ naa ngye an'kɔrà. » ");
INSERT INTO yns_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pa kàkyen nde, nde kàsɛmà mukyään u ndaa a ngwal anà mupay làsaŋ a ndaa ayi. Kyakin Yɛsu kàmɛn anki mbwo mukàmɛnà u mii a baar banswà kan'bul an'köl an'köl, wɛɛ nde kàkälà u nsà, u mpey. Waa baar bàfwee mper anà mper, bàyee akà nde. ");
INSERT INTO yns_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ungö a ilä, Yɛsu kàfurà Kapernawum. Làsaŋ làpää naa nde kàkäl u ndwà. ");
INSERT INTO yns_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Baar mbɔɔn bàyàköŋ paa. Akà ikal kyàkäl anki, itàkal tsütsü a munàmbwo a ndwà. Ikal kyàfàkal anki, itàkal u nsà. Nde kakyäänà Ndaa. ");
INSERT INTO yns_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Apan, baar bun'twääl mbuur aŋàkwɛkà. ");
INSERT INTO yns_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wɛɛ ba bàkwe anki mukun'twaal kà ikal kàkäl nde ntɔn baar bàkäl mbɔɔn, ba bàmɛn nsyä udu a ikal kàkäl nde, waa bàpfuul mun ntɔn mutyeey ipɔy kàkäl mbuur aŋàkwɛkà. ");
INSERT INTO yns_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mpal kàmɛn Yɛsu làkwikilà aba, nde kàtɛn a mbuur aŋàkwɛkà naa: « Mwan amɛ, mɛ amadwääl nkul a man'be angye. » ");
INSERT INTO yns_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Alɔɔŋ a in'kɔɔn amwɛy bàkäl aŋàbwaay paa, bàmuyweerà u mpem aba naa: ");
INSERT INTO yns_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","« Ntɔn nkye mbuur wà kan'tɛn nde abwɛy? Nde wàmubɛy Nzam. Nà kan'kwo mudwa nkul a man'be isàkal naa kà Nzam mpɛl anki? » ");
INSERT INTO yns_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Abà kàyöb nde unsà dweelà ande ndaa bayweerà ba uboo a ba ŋakwo, Yɛsu kàtɛn a ba naa: « Ntɔn nkye làbà bɛ anà an'kyän atub amà u mpem abɛ? ");
INSERT INTO yns_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Undiir nà akɔ̈ɔ̈n mpay mutɛn akà mbuur aŋàkwɛkà: \"Bàmadwääl nkul a man'be angye\", lɛɛ mutɛn naa: \"Mbarà, sɛn ipɔy angye, kyen\"? ");
INSERT INTO yns_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Abun, ntɔn bɛ làyöb naa Mwan a mbuur wɛ anà ikɔ̈b mudwääl baar nkul a man'be u mɛɛn pà. » Apan, nde kàtɛn a mbuur aŋàkwɛkà naa: ");
INSERT INTO yns_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","« Mɛ amaswaŋ, mbarà, sɛn ipɔy angye, kyen ndwà angye! » ");
INSERT INTO yns_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Baal awà waa kàmbarà, apan sye nde kàsɛn ipɔy ande, waa kàtoo u mii a baar banswà. Apan ba banswà bàmɛn ndaa yubem, waa bàsyäŋà Nzam, bàtɛɛnà naa: « Bi ŋàtàman anki abà akà ikikye! » ");
INSERT INTO yns_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yɛsu kàfàkyà kà un'kɔɔl a ɛwà. Un'sɛŋ a baar wanswà kàkyeenà akà nde, waa nde kalɔɔŋà. ");
INSERT INTO yns_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Umpal kàkäl nde mulyaŋ, nde kàmɛn Lɛvi, mwan a Alfɛ, kan'bwaay kà ikàl bàfàfur itɛr, waa kàtɛn a nde naa: « Yan'läb! » Nde waa kàmbarà, waa kun'läb. ");
INSERT INTO yns_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ungö apan Yɛsu kàkàdyà u ndwà a Lɛvi. Afüür a itɛr mbɔɔn anà baar abe bàdyee mɛsà mwɛy anà nde, anà alɔŋki ande sye. Ntɔn baar abe bàkäl mbɔɔn muyun'lab. ");
INSERT INTO yns_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Uboo a alɔɔŋ a in'kɔɔn bàkäl anà Amfarisi. Mpal bàmɛn ba naa Yɛsu akadyaa ikal imwɛy anà baar abà banswà, ba bàtɛn a alɔŋki ande naa: « Abà aben? Ntɔn nkye udyaa nde anà afüür a itɛr anà baar abe? » ");
INSERT INTO yns_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yɛsu kàwem nde abwey, nde kàtɛn a ba naa: « Kà baar abye anà ngwal u ndür anki abye anà mfun a un'ngaŋ, wɛɛ aŋakyal. Mɛ kàyi anki mubel baar a balàbal, wɛɛ baar abe. » ");
INSERT INTO yns_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ilä mwɛy alɔŋki a Ywan anà Amfarisi bàkäl mukin mbɔr. Ba bàyàtɛn a Yɛsu naa: « Ntɔn nkye bi alɔŋki a Ywan anà alɔŋki a Amfarisi ifàkin mbɔr, wɛɛ alɔŋki angye mbɔr bàfàkin anki? » ");
INSERT INTO yns_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yɛsu kafuur naa: « Nkye baar ban'bel kà un'kyɔm atà bɔr ban'kwo mukin mbɔr umpal awà un'tɛɛl a bɔr paa? Umpal awà un'tɛɛl a bɔr anà ba, ba bàkwo anki mukin mbɔr. ");
INSERT INTO yns_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wɛɛ ilä ikyer asàyà, umpal bàsàlwom ba un'tɛɛl a bɔr uboo a ba, ba bàsàkin mbɔr ilä akin. ");
INSERT INTO yns_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","« Akà mbuur mwɛy ukwe anki mubaay ikaam a ipfɛy akün udu a ipfɛy aŋànün, naa tɛy, ikaam akün ban'kwɛy iyànaan yar a ipfɛy aŋanün, tuun waa làyàyàmà. ");
INSERT INTO yns_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Akà mbuur mwɛy ukwe anki musà man akün u mbeen aŋanün, naa tɛy, man akün laa ipfuul ma mbeen aŋanün, laa ipää ma: man anà mbeen sye waa ikyà bwà. Aay, akà man akün, mbeen sye yàkün! » ");
INSERT INTO yns_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yàmɛnà naa ilä a saba mwɛy, Yɛsu kàkäl mulyaaŋ uboo a an'ywaŋ a blɛ. Alɔŋki ande bàsɛmà mubwo imfà u mbwo bayikyeenà ba. ");
INSERT INTO yns_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Amfarisi bàtɛɛnà a nde naa: « Ler ndaa bàkyerà ba ilä a saba! Yà ikin. » ");
INSERT INTO yns_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Waa nde kafuur naa: « Nkye bɛ làtäŋ anki akà ikikye ndaa kàkyer David umpal kàkäl nde u làkɔɔŋ anà kàwem nde ngyal, nde anà baar bàkäl anà nde? ");
INSERT INTO yns_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aben, umpal kàkäl Abyatar undweer a angaŋ, kàbilà nde u ndwà a Nzam, kàwɛl nde mampà bàfàpà ibɔɔn, kàdi nde ma anà kàpɛ nde baar bàkäl anà nde, itàkal naa ma angaŋ mpɛl bàfàdyà? » ");
INSERT INTO yns_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Apan, Yɛsu kàtɛɛnà a ba naa: « Saba bàkyer ntɔn mbuur, wɛɛ kà mbuur anki ntɔn saba. ");
INSERT INTO yns_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kyakin, Mwan a mbuur wà nkum itàkal sye wà saba. » ");
INSERT INTO yns_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ungö, Yɛsu kàfàbilà u ndwà a nköŋ a Ayudà. Uboo kwo kàkäl anà baal mwɛy wàŋàkwɛkà kɔɔ. ");
INSERT INTO yns_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Baar bàkäl musey Yɛsu ntɔn muyöb naa nkye nde akyer un'kɔɔr ilä a saba, ntɔn ba bun'füün. ");
INSERT INTO yns_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nde waa kàtɛn a baal aŋàkwɛkà kɔɔ naa: « Mbarà! yà uboboo pà. » ");
INSERT INTO yns_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Apan nde kàtɛn a ba naa: « Nkye bàkyàpà mbwo ilä a saba mukyer yàŋàbwaŋ lɛɛ yà ube, mutswà mɔ̈ɔ̈ lɛɛ mudwa? » Wɛɛ ba bàkäl a kul. ");
INSERT INTO yns_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kyakin Yɛsu kaler nde intwɛn, kawem nde ngyɛb sye ntɔn mpem ambe aba, waa kàtɛn a baal awun naa: « Sɛn kɔɔ a ngye. » Nde waa kàsɛn la, la waa làkɔɔrà. ");
INSERT INTO yns_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pa bàtoo Amfarisi, laa bàkàköŋ ba anà baar a Ɛlɔdi ntɔn ba bàleŋ mbwo mudwa Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yɛsu kàkyen u mpey anà alɔŋki ande kà un'kɔɔl a ɛwà. Un'kàbɔ a baar bàfü Yɛlusàlɛm anà itiir a nsi a Ngalilɛ, Yuday, ");
INSERT INTO yns_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Idumɛ, u sim a ngyäl a Yɔrdan, Tir anà Sidɔn, bàyi akà Yɛsu ntɔn bàwem ba làsaŋ a indiir byanswà kàkyerà nde. ");
INSERT INTO yns_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nde kàswɛŋ alɔŋki ande naa ba bun'lɔ̈ɔ̈n bwaar làmwɛy ntɔn baar bàkɔɔn akun'sà un'süküün. ");
INSERT INTO yns_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ntɔn kàkɔɔrà nde baar mbɔɔn, baar banswà bàkäl anà mpay u ndür bun'bweelà ntɔn mukun'ba. ");
INSERT INTO yns_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Apan sye an'dweelà an'be, mpal mun'mɛnà ma, ma mun'bweelà kà in'kɔl, waa bun'syee in'kwɛŋ naa: « Ngye awà Mwan a Nzam! » ");
INSERT INTO yns_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wɛɛ nde katsüŋ a ngwal naa ba bàkɔ̈ɔ̈n un'mɛɛy. ");
INSERT INTO yns_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ungö, Yɛsu kàbeenà udu a mɔŋ, kàbel baar kàkwen nde. Ba bàyi apà nde. ");
INSERT INTO yns_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nde kàkyer itsuŋ a baar kwem aŋiyweel ntɔn muyikal anà nde anà mukatɔm mukàlɔŋ ");
INSERT INTO yns_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","anà ikɔ̈b muböŋ insɔŋà. ");
INSERT INTO yns_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Le, Bàkwem Aŋiyweel ba abà: Simɔn, Yɛsu kun'pɛ ikɔb a Petɔlà, ");
INSERT INTO yns_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zyak, mwan a Zebeday anà un'tɔŋ ande Ywan. Nde ba kapɛ ikɔb a Bwanɛrgɛsi, iswaŋà naa « baar abà asànaa idum », ");
INSERT INTO yns_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrɛ, Filipo, Bàtɛlàmay, Màtay, Tuma, Zyak mwan a Alfɛ, Tadɛ, Simɔn mbuur a mankay, ");
INSERT INTO yns_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","anà Yudas Iskalyɔt, nde awun sye mbuur kun'yälà. ");
INSERT INTO yns_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ungö apan Yɛsu kàyi u ndwà mwɛy. Un'sɛŋ a baar kàfàkàköŋ kwo, lalan ba bàsàkwo anki itàkal mudyà. ");
INSERT INTO yns_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mpal bàwem baar a ywar ande abwɛy, ba bàyi mukun'lwom, ntɔn ba bàtɛɛnà naa: « Nde kan'yiŋ! » ");
INSERT INTO yns_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Alɔɔŋ a in'kɔɔn bàyàtyà fà Yɛlusàlɛm bàtɛɛnà naa: « Bɛlzebul wà uboo ande! » Anà sye naa: « Nde insɔŋà ayibɔ̈ŋ u mbwo a mfum a insɔŋà! » ");
INSERT INTO yns_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Apan Yɛsu waa kabel, waa kàtɛn a ba unsà nsim naa: « Nkye Satanà kan'kwo uböŋ Satanà? ");
INSERT INTO yns_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Isàkal naa imwol mwɛy kyàŋàkaabà anà kya ŋakwo, imwol akin ifàtsim anki. ");
INSERT INTO yns_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Isàkal naa ywar mwɛy làŋàkaabà anà la ŋakwo, ywar alan làfàtsim anki. ");
INSERT INTO yns_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kya Satanà usànwan anà nde ŋakwo, nde wàŋàkaabà, nde utsim anki, yànde yan'wà. ");
INSERT INTO yns_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","« Akà mbuur mwey ukwe anki mubilà u ndwà a ŋangwal anà ugyɔɔr indiir ande, isàkal naa nde ŋàtun'bäm anki ŋangwal awun in'siŋ. Manà nde kàmubäm in'siŋ, apan laa ugyɔɔr nde indiir byanswà abyà uboo a ndwà ande. ");
INSERT INTO yns_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ndandaa mɛ alàkyään, baan a baar bàkyer asadwääl nkul a ndaa aba yanswà: man'be anà mbɛɛy mbɔɔn isàtoo u mun aba. ");
INSERT INTO yns_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wɛɛ mbuur asàbɛy Dweelà In'kyɛɛl, nde bàsun'dwääl anki nkul akà ikikye. Ntɔn ube ande bà bàmbul a in'tye. » ");
INSERT INTO yns_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yɛsu kàtɛɛnà nde abwɛy ntɔn ba bàtɛɛnà naa: « Nde we anà dweelà a làbe. » ");
INSERT INTO yns_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ngwän anà atɔŋ a Yɛsu bàyi anà bàmbär u nsà, waa bàtöm mbuur mukun'bel. ");
INSERT INTO yns_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Un'sɛŋ a baar kàkäl aŋàbwaay apà ande. Waa bàtɛn a nde naa: « Le, ngwa anà atɔŋ angye babaal anà bakaar bàmukaleŋà u nsà. » ");
INSERT INTO yns_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nde kafuur naa: « Maa anà atɔŋ amɛ bànà? » ");
INSERT INTO yns_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Apan, nde kàler baar bàkäl aŋàbwaay apà nde, waa kàtɛn naa: « Làler maa anà atɔŋ amɛ! ");
INSERT INTO yns_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mbuur wanswà afàsyääl ukwen a Nzam, nde wà un'tɔŋ amɛ wàbaal, un'tɔŋ amɛ wà un'kaar anà maa. » ");
INSERT INTO yns_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yɛsu kàfàsɛmà mulɔŋ kà un'kɔɔl a ɛwà. Un'sɛŋ a baar mbɔɔn kàköŋ tsütsü apà nde, lalan kàbilà nde u bwaar, la làkäl udu a an'dà, waa kàbwaay. Baar banswà bàkäl u mɛɛn, usà ntsü akà an'dà. ");
INSERT INTO yns_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nde ba kalɔɔŋà indiir mbɔɔn unsà nsim. Nde kàtɛɛnà a ba unsà an'lɔɔŋ ande naa: ");
INSERT INTO yns_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","« Làwem. Le, un'köön kàtoo mukɔn. ");
INSERT INTO yns_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Umpal kàyimwaŋà nde, yar a mbɛŋ làmwɛy làbü u mbwo: nɛn waa yàyi, waa yàdi ya. ");
INSERT INTO yns_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yar lumwɛy làbü kà ikal kyàkäl anà in'kul, mɛɛn a mbɔɔn màkäl anki. La làtoo agyàgyà ntɔn mɛɛn màkäl anki mbɔɔn u ngyɛl. ");
INSERT INTO yns_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mpal kàbalà mwäänà, laa làkuŋà la, waa làyöm ntɔn ukɔɔn in'swɛy. ");
INSERT INTO yns_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Lumwɛy làbü uboo a nsyeenà. Nsyeenà yàyɛl ya, ya waa yun'fwee, la waa mpa làtwey mbɛŋ. ");
INSERT INTO yns_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mbɛŋ yumwɛy yàbü uboo a mɛɛn aŋàbwaŋ, waa yàmɛn, yàyɛl, yàbör mbɛŋ mbɔɔn: imwɛy an'kwem an'tär, imwɛy an'kwem an'syaam, imwɛy nkam. » ");
INSERT INTO yns_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nde kàtɛɛnà naa: « Wɛy mbuur awe anà an'tsü awem, uwem! » ");
INSERT INTO yns_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mpal kàkäl Yɛsu u mpey, baar bàyun'labà anà Bàkwem Aŋiyweel, bun'fuulà ntɔn nsim. ");
INSERT INTO yns_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nde kàtɛɛnà a ba naa: « Akà bɛ, ngyee a Imwol a Nzam bàkyàlapà. Wɛɛ akà baar abà u nsà, indiir byanswà byàfàlyaŋ unsà nsim, ");
INSERT INTO yns_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ntɔn abun, \"itàkal naa ba bàkyer aleerà, ba bàkɔɔn aman, itàkal naa ba bàkyer aweemà, ba bàkɔɔn ayöb, manà ba bàyàbuul mpem anà bàyadwääl un'pi a nkul!\" » ");
INSERT INTO yns_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nde kàfàtɛn a ba naa: « Bɛ, bɛ làyöb anki nsim ayi! Abun bɛ làyàyöb aben nsim yanswà? ");
INSERT INTO yns_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","\"Un'köön\" kan'kɔn Ndaa. ");
INSERT INTO yns_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Le, baar abà u mbwo, kà ikal bàkön Ndaa: mpal bàwem ba, Satanà abwà ayà, waa ulwom Ndaa bàkön uboo aba. ");
INSERT INTO yns_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bumwɛy bakön udu a nkɔŋ: bà baar, mpal bàfàwem ba Ndaa, ba bàbwà awal ya unsà un'sak. ");
INSERT INTO yns_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wɛɛ uboo a ba in'swɛy myatɛy, ba bà baar a ansɔŋà: isàkal naa lingyoomà lan'yà itàkal nkwaaŋ ntɔn Ndaa, laa bàbwà ba. ");
INSERT INTO yns_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bumwɛy bakön uboo a nsyeenà: bà baar bàwem Ndaa, ");
INSERT INTO yns_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wɛɛ nkyän a mɛɛn, untaam a in'naaŋ anà ngyal a indiir asin asin byàbilà bya, laa iküünà bya Ndaa, ya waa mpa ibɔr mbɛŋ. ");
INSERT INTO yns_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bumwɛy bakön u mɛɛn aŋàbwaŋ. Ba bà baar bàfàwem Ndaa, bàfàwal ya, waa bàfàbɔr mbɛŋ: imwɛy an'kwem an'tär, imwɛy an'kwem an'syaam, imwɛy nkam. » ");
INSERT INTO yns_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yɛsu kàtɛn a ba naa: « Nkye mwinà afàyà ntɔn musà ungyɛl a kantin itàkal ungyɛl a itäb? Nkye kà ntɔn mutɔl udu a ikɔlà a un'te a wa anki? ");
INSERT INTO yns_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ntɔn undiir mwɛy wàŋàyee watɛy mpa usàmɛnà u mii, ndaa mwɛy yànkuu yatɛy mpa isàmɛnà u mwäänà. ");
INSERT INTO yns_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wɛy mbuur awe anà an'tsü awem, uwem! » ");
INSERT INTO yns_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nde waa kàfàtɛn a ba naa: « Làkäl kà igyɛɛŋ ntɔn ndaa làkaweemà bɛ. Làsii làsyäälà bɛ musi, làsii nsil alan bàsàsyääl akà bɛ, la làsàkal aŋàkwɛy ntɔn bɛ. ");
INSERT INTO yns_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ntɔn bàsàpà akà mbuur awɛ anà undiir, wɛɛ akà mbuur mpa awe anà undiir, bàsàlwom itàkal undiir ufàsi nde mukal anà wa. » ");
INSERT INTO yns_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nde kàfàtɛn a ba naa: « Imwol a Nzam kyà asànaa mbuur mwɛy kan'mwaŋ nkɔɔn u mɛɛn. ");
INSERT INTO yns_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nde utàkal aŋàbɔ̈ɔ̈n, utàkal wàŋàwiyà, mpib anà mwäänà, nkɔɔn yan'mɛn anà yan'yɛl, nde uyöb anki naa yà aben. ");
INSERT INTO yns_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mɛɛn ma ŋakwo màfàtàtwey bite, ungö imfà, ungö apan mbɛŋ aŋàkɔlà yan'yööl imfà. ");
INSERT INTO yns_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pa isöŋ mbɛŋ, ba bàsà impye, ntɔn la paŋà abwo. » ");
INSERT INTO yns_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yɛsu kàfàtɛn naa: « Ininà bi kan'kwo musi a Imwol a Nzam, itàkal naa nsim nà bi kan'kwo mutà ntɔn muswaŋ kya? ");
INSERT INTO yns_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kya kyà asànaa imbɛŋ ikikye bàkön u mɛɛn. Kya kyan'söön ukye uboo a mbɛŋ yanswà ayà u mɛɛn. ");
INSERT INTO yns_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wɛɛ isàkal naa ban'kɔn kya, kya kyan'laar, kyan'bulà aŋàsöön ndon yanswà uboo a làpaŋ, waa isà an'kɔkà. Apan, nɛn a du waa iyàtɔŋ an'yaab. » ");
INSERT INTO yns_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yà u mbwo a nsim mbɔɔn a tub ayi nde kàkyäänà Ndaa, ntɔn baar bàkäl kà isii ban'kwo ba mukun'wem. ");
INSERT INTO yns_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nde kàyäämà anki anà ba ukɔɔn asyääl nsim, wɛɛ nde kàbuulà ya yanswà akà alɔŋki ande u mpey. ");
INSERT INTO yns_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ilä nsil kya, làsisye, Yɛsu kàtɛn a alɔŋki ande naa: « Tsweenà bi isabà. » ");
INSERT INTO yns_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ba bàsàwɛy un'sɛŋ a baar, waa bun'syen uboo a bwaar kàkäl nde, an'bwaar asin màkäl tsütsü apà nde. ");
INSERT INTO yns_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ikül laa kyàyi kya. Ibɔ a an'dà byàbilà uboo a bwaar, waa byàyöölà la. ");
INSERT INTO yns_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wɛɛ akà nde, nde kàkäl aŋàbɔ̈ɔ̈n kà ita a bwaar, un'tswe udu a ibɔm. Alɔŋki ande bun'wiy, waa bàsi in'kwɛŋ: « Un'lɔɔŋ, nkye ngye ube amanà anki naa bi ikü? » ");
INSERT INTO yns_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yɛsu waa kàsubà, kàŋän ikül, waa kàtɛn a ɛwà naa: « Kal akul! Bäm mun! » Ikül laa kyàkwamà kya, duu a kölàköl waa làbilà. ");
INSERT INTO yns_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Apan nde kàtɛn a ba naa: « Ntɔn nkye làbà bɛ mutɛɛr? Nkye bɛ ŋàtàsà anki làkwikilà? » ");
INSERT INTO yns_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Matɛɛr mawɛl ma, ba waa bàtɛɛnà ba a ba naa: « Abà nde wà nà, waa itàkal ikül anà ɛwà byàmukun'weemà? » ");
INSERT INTO yns_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ungö apan ba bàkɔlà u sim lumwɛy là ɛwà, u nsi a Bàngɛlàsà. ");
INSERT INTO yns_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pa kàtoo Yɛsu u bwaar, baal mwɛy wàŋàyɔl a an'dweelà an'be kàyàtoo kà an'dii, waa kàyàbwey anà nde. ");
INSERT INTO yns_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nde kàfabwaayà kà an'dii. Akà mbuur mwɛy kàfàkwo anki mukun'bäm itàkal dwaaŋ. ");
INSERT INTO yns_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ntɔn mbalà mbɔɔn ba bàfun'bäämà iswɛɛy anà dwaaŋ, wɛɛ nde kàtsüülà mya. Akà mbuur mwɛy kàkwe anki mukun'kyäämà. ");
INSERT INTO yns_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Taaŋ lanswà, mpib anà mwäänà, nde kàkäl muyità nsay uboo a an'dii anà u myɔŋ, wàmuyikuub in'kwɛŋ anà muyikàkaam ndür a in'kul. ");
INSERT INTO yns_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Umpal kàmɛn nde Yɛsu ukwɛl, nde kàkyen ntiin, waa kàbü an'köm kusà a nde, ");
INSERT INTO yns_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","waa kàkuub in'kwɛŋ anà mutɛn naa: « Ininà akà mɛ anà ngye, Yɛsu, Mwan a Nzam a Dudu? Mɛ amabɔɔn kà ikɔb a Nzam, twon aman'pà mpay! » ");
INSERT INTO yns_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ntɔn Yɛsu kàtɛɛnà a nde naa: « Dweelà a làbe, too unsà mbuur wà! » ");
INSERT INTO yns_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nde kun'fuul naa: « Ikɔb angye nà? » Nde kun'fuur naa: « Ikɔb a mɛ \"Un'kàbɔ\", ntɔn bi ibà mbɔɔn. » ");
INSERT INTO yns_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nde waa kun'bɔ̈ɔ̈nà mbɔɔn, ntɔn nde ukɔɔn akaböŋ u nsi ayin. ");
INSERT INTO yns_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kyekà, mper akà mɔŋ, làkäl anà làböl a kölàköl là ngul làkäl muyidyà. ");
INSERT INTO yns_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","An'dweelà an'be màbɔ̈ɔ̈n Yɛsu naa: « Itöm uboo a ngul ntɔn bi ibilà amu ya! » ");
INSERT INTO yns_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yɛsu kapɛ mbwo. Apan laa màtoo ma, màbilà ma uboo a ngul, làböl, fà iköl a mɔŋ, làkàbwà kà ɛwà. Ya yàkäl isii a nsaab yweel, waa làminà. ");
INSERT INTO yns_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aseey a ngul batiin ba, ba bàkàpay làsaŋ uboo a bul anà kà itsuŋ a ndwà. Apan baar waa bàyi muman ndaa yàlyaaŋ. ");
INSERT INTO yns_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mpal bàyàtol ba tsütsü apà Yɛsu anà bàmɛn ba aŋadweelà an'be akyàbwaay, akyàbwaar anà akyàkal a duu, nde mbuur kàkäl anà Un'kàbɔ, ba bàmɛn bɔɔmà. ");
INSERT INTO yns_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Baar bàmɛn ya yanswà yàlyaŋ, ba bakyäänà ndaa yàbweel mbuur aŋadweelà an'be anà ngul. ");
INSERT INTO yns_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Apan ba bàsɛmà mukun'bɔɔn naa nde ulwomà kà itiir a nsi aba. ");
INSERT INTO yns_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Umpal kàkäl Yɛsu mubilà u bwaar, mbuur awà kàkäl anà an'dweelà an'be kun'lɔ̈ɔ̈m naa ");
INSERT INTO yns_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yɛsu kun'pɛ anki mbwo, wɛɛ nde kàtɛn a nde naa: « Furà ndwà a ngye, ntsü akà atoŋ angye, waa akakyään ndaa yanswà kàmakyer Mwol unsà ngyɛb ande. » ");
INSERT INTO yns_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Apan, baal awà kàkyen nde, nde kàsɛmà mukyään indiir a kölàköl byanswà kàkyer Yɛsu akà nde u Dɛkapɔl. Baar banswà bakyer abemà. ");
INSERT INTO yns_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mpal kàfurà Yɛsu sim lumwɛy u bwaar, un'sɛŋ a baar mbɔɔn kàyàkɔ̈ŋ apà nde. Nde kàkäl kà un'kɔɔl a ɛwà. ");
INSERT INTO yns_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Apan umwɛy uboo a amfum a ndwà a nköŋ a Ayudà, ikɔb ande Zayirɔs, umpal kàmɛn nde Yɛsu, nde kàbü kà in'kɔl ande, ");
INSERT INTO yns_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","waa kun'bɔ̈ɔ̈n mbɔɔn, mutɛn naa: « Mwan un'kye amɛ wà un'kaar wà tsütsü mukwà, yun'si an'kɔɔ ntɔn nde ukɔɔrà, uwü mɔ̈ɔ̈! » ");
INSERT INTO yns_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yɛsu kàkyen mbwo mwɛy anà nde. Un'sɛŋ a baar mbɔɔn kàyun'labà, waa kàyun'bàbääbà. ");
INSERT INTO yns_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kyekà kàkäl anà un'kaar mwɛy kàyitoo an'kil mbul kwem aŋiyweel. ");
INSERT INTO yns_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nde kàmɛn mpay mbɔɔn muyikyà akà ingaŋ mbɔɔn, kàmay indiir ande byanswà, ukɔɔn aman ubwaŋ. Wɛɛ ukyal ande bàkyer afàsöönà mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Umpal kàwem un'kaar awà ndaa bàtɛɛnà baar ntɔn Yɛsu, nde kàkül ungö, uboo a un'sɛŋ a baar, waa kàbä ipfɛy ande. ");
INSERT INTO yns_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ntɔn nde kàtɛɛnà nde ŋàkwo naa: « Isàkal naa mɛ in'tàba akà ipfɛy ande mpɛl, mɛ in'kyɛr awà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Taaŋ nsil alan sye an'kil ande waa màtsü mutoo, nde kàyöb u ndür ande naa nde kan'kɔɔrà unsà ukyal ande. ");
INSERT INTO yns_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Apan sye, Yɛsu waa kàyöb naa ngwal mwɛy yan'too u ndür ande, nde kàbulà uboboo a un'sɛŋ a baar, waa kàfuulà naa: « Nà kan'ba ipfɛy amɛ? » ");
INSERT INTO yns_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Alɔŋki ande bàtɛɛnà a nde naa: « Ngye akimanà naa un'sɛŋ a baar wàmukabàbääbà, wɛɛ ngye afuulà naa: \"Nà kàman'ba?\" » ");
INSERT INTO yns_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wɛɛ nde kàleerà umbil ande ntɔn muyöb naa un'kaar nà kan'kyer abà. ");
INSERT INTO yns_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Apan, abà kàyöb un'kaar awun ndaa yun'yeel, unsà bɔɔmà anà matɛɛr, nde kàyàbwà kà in'kɔl a Yɛsu, waa kàtɛn a nde ndandaa yanswà. ");
INSERT INTO yns_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yɛsu kàtɛn a nde naa: « Mangwa, làkwikilà angye làmatswà mɔ̈ɔ̈. Kyen a duu, wɛy naa ngye akɔɔrà unsà ukyal angye. » ");
INSERT INTO yns_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nde kàkäl aŋàtàmay anki muyääm, umpal bàyi baar bàfü ndwà a mfum a ndwà a nköŋ a Ayudà, waa bàtɛn naa: « Mwan angye wà un'kaar kan'kwà. Ntɔn nkye mufàtwääl Un'lɔɔŋ nkwom? » ");
INSERT INTO yns_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Wɛɛ Yɛsu kàsàlab anki ndaa ayi, waa kàtɛn a mfum a ndwà a nköŋ a Ayudà naa: « Twon an'man bɔɔmà, sà làkwikilà mpɛl. » ");
INSERT INTO yns_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Abun, nde kàpɛ anki mbwo akà mbuur mukun'swà, nà Petɔlà, Zyak, anà un'tɔŋ ande Ywan mpɛl. ");
INSERT INTO yns_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ba ban'kɔlà u ndwà a mfum a ndwà a nköŋ a Ayudà. Yɛsu kan'man baar ban'kal udu udu, bàmulel, bàmusà in'kwɛŋ mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nde kan'bilà, waa kan'tɛn a ba naa: « Ntɔn nkye minii ami anà ilel abi? Mwan kà wàŋàkwà anki, nde wàŋàbɔ̈ɔ̈n. » ");
INSERT INTO yns_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ba bàkyer un'sɛɛ. Wɛɛ nde kàtwey baar banswà, waa kàwɛl nà taarande anà ngwän a mwan anà baar bàyun'swà. Apan nde kan'bilà u suk kàkäl mwan. ");
INSERT INTO yns_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nde kan'tà kɔɔ a mwan mpi, waa kan'tɛn a nde naa: « Mwan un'kaar, mɛ amaswaŋ, wiyà! » ");
INSERT INTO yns_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Apan sye, mwan un'kaar waa kàmbarà, waa kàsemà mukyà, - nde kàkäl ayà mbul kwem aŋiyweel. Apan, ba bàkäl unsà ubem mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yɛsu kaswɛŋ a ngwal naa akà mbuur mwɛy ukɔɔn ayöb, waa kàtɛn naa ba bun'pɛ isaa adyà. ");
INSERT INTO yns_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yɛsu kàlwomà kà ikal akin, waa kan'yà bul ande, alɔŋki ande bàkäl mukun'lab. ");
INSERT INTO yns_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ilä a saba, nde kàsɛmà mulɔŋ u ndwà a nköŋ a Ayudà. Baar mbɔɔn bàweemà nde bàkäl mubem, waa bàtɛɛnà naa: « Nde indiir abi byan'fà ken? Amà an'yeerà a nkye ifà bun'pɛ, waa an'kɔɔ ande ikakyerà isal a ngwal a ngwal a tub abi? ");
INSERT INTO yns_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nkye nde kà sharpantye anki, mwan a Màlye, un'tɔŋ a Zyak, anà Yɔsɛ, anà Yude, anà Simɔn? Nkye atɔŋ ande bakaar kà bà anki uboo a bi apà? » Kyakin bàbööl ba kyà ntɔn làkwikilà aba. ");
INSERT INTO yns_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Apan Yɛsu kàtɛɛnà a ba naa: « Ŋangɔɔm bàfun'bɛy nà u bul ande, u mbil ande anà u ndwà ande mpɛl. » ");
INSERT INTO yns_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nde kàsàkwo anki mukyer akà impà mwɛy kwo, wɛɛ nde kàsi nà an'kɔɔ udu a ndam a aŋatoo, waa kakɔɔr. ");
INSERT INTO yns_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nde kàbemà ntɔn mpa bàkäl ba anà làkwikilà. Ungö apan nde kàyilyaaŋà kan'bul a tsütsü muyilɔŋ. ");
INSERT INTO yns_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nde kàbel Bàkwem Aŋiyweel, kàsɛmà mukatɔm abɔ̈ɔ̈l abɔ̈ɔ̈l, kapɛ ikɔ̈b udu a an'dweelà an'be, ");
INSERT INTO yns_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","waa kaswɛŋ naa: « Twon lan'wal akà undiir mwɛy ntɔn mbwo, nà unsɔk mpɛl. Twon lan'wal isaa adyà, itàkal ngɔɔr, itàkal ngim uboo a un'di, ");
INSERT INTO yns_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","wɛɛ làbwäär idyaar, twon lan'bwaar an'kàzak an'mɔ̈ɔ̈l. » ");
INSERT INTO yns_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nde kàfàtɛn a ba naa: « Isàkal naa kà ikal imwɛy, bɛ lan'bilà u ndwà mwɛy, làbwaay paa tii umpal làsàlwomà bɛ kà ikal akin. ");
INSERT INTO yns_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Isàkal naa kà ikal imwɛy bàlawɛl anki, bàlawem anki, làlwomà apan, làkɔɔb un'twà a in'kɔl abɛ. Kya isàkal imbäl ntɔn ba. » ");
INSERT INTO yns_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Alɔŋki bàkyen ba, ba bàkyäänà naa baar bàkyer abuul mpem. ");
INSERT INTO yns_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba bàyiböŋà insɔŋà mbɔɔn, bàkiirà aŋatoo mbɔɔn may, waa bakɔɔrà. ");
INSERT INTO yns_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mfum Ɛlɔdi kàwem naa bàtaa Yɛsu din, ntɔn ikɔb ande kyàtoo làpaan. Baar bàtɛɛnà naa: « Ywan Un'düümà kan'wiyà kukwà! Undiir awun awà nde anà ikɔ̈b mukyer indiir a ngwal a ngwal. » ");
INSERT INTO yns_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bumwɛy bàtɛɛnà naa: « Nde wà Ɛli. » Bamwey sye naa: « Nde wà ŋangɔɔm asànaa umwɛy uboo a aŋangɔɔm. » ");
INSERT INTO yns_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mpal kàwem Ɛlɔdi ndaa ayi, nde kàtɛɛnà naa: « Ywan akwà kàtsül mɛ un'tswe, kan'wiyà! » ");
INSERT INTO yns_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Abun, Ɛlɔdi kàswɛŋ mukɔr Ywan anà bun'si u bɔlokà, ntɔn kàbääl nde Ɛlɔdyas awà kàkäl un'kyay a un'tɔŋ ande Filipo. ");
INSERT INTO yns_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ntɔn Ywan kàtɛɛnà a Ɛlɔdi naa: « Mbwo yatɛy ngye muwal un'kyay a un'tɔŋ angye! » ");
INSERT INTO yns_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Undiir awun Ɛlɔdyas kàyiiŋ nde Ywan, waa kàkweenà mukun'dwa. Wɛɛ nde kàsàkwo anki, ");
INSERT INTO yns_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ntɔn Ɛlɔdi kàtiinà Ywan bɔɔmà, abà kàyöb nde naa nde wà mbuur a balàbal anà wà in'kyɛɛl, laa kun'tii nde. Mpal kun'wɛɛmà nde, ya yun'pää mpay mbɔɔn. Wɛɛ nde kàkweenà mukun'wɛm. ");
INSERT INTO yns_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kyekà, Ɛlɔdyas ipöl aŋàbwaŋ kàmɛn ilä a un'kyɔm a mböör a Ɛlɔdi. Nde awà kàpɛ udyà akà ayɔl ande anà amfum a aŋità ande, anà akà abyääl a Ngalilɛ. ");
INSERT INTO yns_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwan a Ɛlɔdyas wà un'kaar waa kàyàkyen. Ɛlɔdi anà baar kàbel nde bàmɛn un'sak mbɔɔn. Mfum kàtɛn a mwan un'kaar naa: « Lɔm undiir wanswà akwen ngye, mɛ in'kyer ayapà wa. » ");
INSERT INTO yns_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nde kun'dyeel kyän naa: « Undiir wanswà ayàlɔm ngye, mɛ in'kyɛr ayapà, itàkal naa yar a mɛɛn a imfum amɛ. ");
INSERT INTO yns_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mwan un'kaar kàtoo u ndwà, waa kàtɛn a ngwän naa: « Ininà mɛ in'lɔm? » Nde waa kàfuur naa: « Un'tswe a Ywan Un'düümà. » ");
INSERT INTO yns_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nde kàfurà agyägyä akà mfum, waa kun'lɔ̈ɔ̈m: « Mɛ in'kwen naa ngye an'pɛ agyägyä udu a làlɔŋà, un'tswe a Ywan Un'düümà! » ");
INSERT INTO yns_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mfum kàwem ngyɛb. Wɛɛ, ntɔn kyän ande anà baar kàbel nde, nde kàkwen anki utön mukun'pà. ");
INSERT INTO yns_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Apan sye, mfum kàtöm un'seey mwɛy anà nswɛɛŋ mutwal un'tswe a Ywan Un'düümà. Un'seey kàkyen u bɔlokà, waa kàtsül un'tswe a Ywan, ");
INSERT INTO yns_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kàtwääl wa udu a làlɔŋà, waa kàpɛ wa akà mwan un'kaar. Waa mwan un'kaar kàpɛ wa akà ngwän. ");
INSERT INTO yns_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mpal bàwem alɔŋki a Ywan làsaŋ alan, ba bàyàwal ndom ande, waa bàsi ya kan'dii mwɛy. ");
INSERT INTO yns_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yàmɛnà naa mpal bàyàfurà antööm, ba bàkɔ̈ŋ apà Yɛsu, ba bun'sam ndaa yanswà bàkyer ba anà bàlɔɔŋà ba. ");
INSERT INTO yns_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nde kàtɛn a ba naa: « Bɛ bumwɛy, làyi u mpey, làyöör ikye u nsye a ipɔl. » Ntɔn baar mbɔɔn bàkälà muyaa anà mukyeenà, waa ba bàkäl anki itàkal anà taaŋ mudyà. ");
INSERT INTO yns_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Lalan bàkyen ba, ba mpɛl, uboo a bwaar u mpey, u nsye a ipɔl. ");
INSERT INTO yns_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Baar batääl mukyà, bàmbɔɔn laa bayöb ba. Apan, fà an'bul manswà, ba bàkyen ntiin ntiin kà in'kɔl, waa bàfweel kà ikal bàkwen ba mukyà. ");
INSERT INTO yns_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Umpal katoo Yɛsu u bwaar, nde kàmɛn un'sɛŋ a baar mbɔɔn, ngyɛb waa yun'wɛl ntɔn ba, ntɔn ba bàkäl asànaa in'kɔk myakɔɔn aleer, waa kàsɛmà mukalɔŋ indiir mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Taaŋ làkyen mbɔɔn, alɔŋki bàsin apà Yɛsu, waa bàtɛn a nde naa: « Ikal ki kyà ipɔl, taaŋ sye lan'kyà mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Afuur baar bà, ba bàkyà u bitsuŋ a ndwà anà an'bul a tsütsü mukàsom isaa adyà. » ");
INSERT INTO yns_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wɛɛ nde kafuur naa: « Lapɛ udyà bɛ ŋakwo! » Ba bàtɛn a nde naa: « Nkye bi ikàsom mampà a itɛr a ngim nkam yweel ntɔn bi ipɛ ba udyà? » ");
INSERT INTO yns_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nde waa utɛn a ba naa: « Mampà an'kwe bɛ làwe amà? Kàlaler! » Ungö muler, ba ban'tɛn naa: « An'tyeen, anà nsö yweel. » ");
INSERT INTO yns_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Apan, nde kaswɛŋ naa ba bàsi baar banswà unsà an'kab bàŋàbwaay udu a un'lɛŋ un'bu. ");
INSERT INTO yns_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Baar bàbwaay unsà in'lwaaŋ a nkam anà myà an'kwem an'tyeen. ");
INSERT INTO yns_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yɛsu kàwɛl mampà man'tyeen anà nsö yàyweel, nde kàler u du, kàsaak ma, kàtsül ma, waa kàpɛ akalɔŋki ntɔn mukääb baar banswà. ");
INSERT INTO yns_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ba banswà bàdi, waa bàyüür. ");
INSERT INTO yns_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ba bàsyen in'lwaŋ kwem aŋiyweel myàŋàyɔl a itiir a mampà anà byà nsö byàsäl. ");
INSERT INTO yns_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Baar bàdi mampà bàkäl abaal nsaab tyeen. ");
INSERT INTO yns_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Apan sye, Yɛsu kàswɛŋ alɔŋki ande mubilà u bwaar anà mufweel kusà a nde, u sim a ɛwà lumwɛy, u ntsü a Bɛtesayidà, umpal nde ŋakwo usàpay nde un'sɛŋ a baar. ");
INSERT INTO yns_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ungö mupay ba, nde kàbeenà u mɔŋ mukàyamà. ");
INSERT INTO yns_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Làsisye, bwaar làkäl lan'tol uboboo a ɛwà, nde kàsàkal nde mpɛl u mɛɛn. ");
INSERT INTO yns_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Muman naa alɔŋki ande bàmunwan a ngwal muluk nkay ntɔn un'pöb kàyee lisà, tsütsü a taaŋtyà, nde kan'yà mper akà ba wàmuyikyà udu a ɛwà, waa kàlasoonà. ");
INSERT INTO yns_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mpal bun'mɛn ba wàmuyikyà udu a ɛwà, ba bàsi naa bwo kàkäl, waa bàsi in'kwɛŋ. ");
INSERT INTO yns_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ntɔn ba banswà bàkyer un'man, lingyoomà waa lawɛl. Wɛɛ apan, nde kàyäm anà ba, waa kàtɛn a ba naa: « Làwɛl ibaal! Wà mɛ, twon lan'man bɔɔmà! » ");
INSERT INTO yns_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Apan, nde kàbilà u bwaar apà ba, un'pöb waa kànye. Uboo a ba ŋakwo, ba bàbemà mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kutɛn aŋàbwaŋ, ba bàsàyöb anki mbuul a impà a mampà, ntɔn mpem aba yàkäl bwoor. ");
INSERT INTO yns_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ungö a nsaabà, ba bàtɔlà u mɛɛn a Ngɛnɛsàlɛr, waa bàbäm bwaar aba. ");
INSERT INTO yns_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pa bàtoo ba u bwaar, baar waa bàyöb Yɛsu, ");
INSERT INTO yns_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","waa bàkyen ntiin kà itiir a nsi akin kyanswà, waa bàsɛmà mukun'twääl aŋukyal udu a ipɔy kà ikal kyanswà bàweemà ba naa Yɛsu wà kwo. ");
INSERT INTO yns_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ntsü yanswà kàbilà nde: uboo an'bul itàkal an'bul a kölàköl, itàkal kà itsuŋ a ndwà, baar bàtɔ̈ɔ̈là aŋukyal u làbay, waa bun'bɔ̈ɔ̈nà naa nde kawɛy ba bàbä itàkal làpan a ipfɛy ande mpɛl. Abun baar abà bàtɛɛ kya mpi bàkyer akɔɔrà. ");
INSERT INTO yns_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Amfarisi anà alɔɔŋ a un'kɔɔn amwɛy bàfü Yɛlusàlɛm ban'köŋ apà Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ba ban'man naa alɔŋki ande amwɛy bàmudyà anà an'kɔɔ a ŋingyäy, iswaŋà naa ukɔɔn aywɛy ma. ");
INSERT INTO yns_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ntɔn Amfarisi, itàkal Ayudà banswà, bàfàdyà anki ukɔɔn aywɛy an'kɔɔ ubwaŋàbwaŋ, mulab nkääl a andweer. ");
INSERT INTO yns_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ba bàsàfà mukàlyaaŋ, ba bàfàdyà anki kusà mutàpöŋ. Ye anà nsyääl asin mbɔɔn yindweer bàfàlab ba: mpööŋ a an'kɔɔb, yà an'buuŋ anà yan'lɔŋà. ");
INSERT INTO yns_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Amfarisi anà alɔɔŋ a in'kɔɔn ban'fuul Yɛsu naa: « Ntɔn nkye alɔŋki angye mpa bàfàlab ba in'kɔɔn a andweer, wɛɛ ba bàfàdyà anà an'kɔɔ a ŋingyäy? » ");
INSERT INTO yns_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nde waa kàtɛn a ba naa: « Yɛsay kàtɛ ngɔɔm aŋàbwaŋ ntɔn bɛ baar a mpem yweel, ntɔn bàsön naa: \"Un'sɛŋ wà mɛ làkoo afan'sà udu a ndem mpɛl, wɛɛ mpem aba yukwɛl anà mɛ.\" ");
INSERT INTO yns_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ngyamàkà bàfan'sà ba yà bunàbun, ntɔn nsyääl bàfàlɔŋ ba yan'kyän a baar.\" ");
INSERT INTO yns_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bɛ nswɛɛŋ a Nzam làfàsà ukɔl, wɛɛ bɛ làfàndäär anà nsyääl a baar. » ");
INSERT INTO yns_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nde kàfàtɛn a ba naa: « Bɛ làfàtɔn ubwaŋàbwaŋ nswɛɛŋ a Nzam ntɔn mukaar nkääl abɛ! ");
INSERT INTO yns_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ntɔn Mɔsɛ kàtɛn naa: \"Sà làkoo akà taaràŋà anà ngwa\", sye naa: \"Wɛy mbuur ato taarànde anà ngwän, ukyen ukwà.\" ");
INSERT INTO yns_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wɛɛ bɛ, bɛ làfàtɛn naa: mbuur usàtɛn a taarànde itàkal a ngwän naa: \"Undiir alàwal ngye akà mɛ wà Kɔrban\", ikaswaŋà naa \"kab in'kyɛɛl\", ");
INSERT INTO yns_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bɛ làmun'pà mbwo naa nde ukɔɔn akyer akundiir mwɛy ntɔn taarànde itàkal ntɔn ngwän.\" ");
INSERT INTO yns_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lalan, bɛ làfàdwa Ndaa a Nzam ntɔn nkääl a andweer abɛ làfàlɔŋ bɛ. Bɛ làfàkyer sye indiir asin mbɔɔn byà ifà aki. » ");
INSERT INTO yns_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ungö apan, Yɛsu kàfàbel un'sɛŋ a baar, waa kàtɛn a ba naa: « Lan'wem bɛ banswà, làyöb naa: ");
INSERT INTO yns_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Akundiir mwɛy tɛy afàfà nsà awafàbilà uboo a mbuur afun'buul wàŋingyäy. Wɛɛ indiir ifàtoo u mbuur ifun'buul wàŋingyäy. » ");
INSERT INTO yns_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16"," Kya mbuur mwɛy usàkal anà an'tsü awem, wɛy nde uwem!  ");
INSERT INTO yns_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Umpal kàbilà Yɛsu u ndwà, ukwɛl a un'sɛŋ a baar, alɔŋki ande bun'fuulà ntɔn itim aki. ");
INSERT INTO yns_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nde kàtɛn a ba naa: « Nkye anà bɛ sye, abun bɛ un'yɛnà watɛy? Nkye bɛ làyöb anki naa undiir mwɛy tɛy afafà nsà anà afàbilà uboo a mbuur ukwe anki mukun'buul wàŋingyäy, ");
INSERT INTO yns_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ntɔn wa ufàbilà anki u mpem ande, wɛɛ kan'bäl ande, ungö wa akyà u nkuràndwà? » Abun nde kàkyäänà naa isaa byanswà byàŋàpɔŋà. ");
INSERT INTO yns_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nde waa kàtɛn naa: « Ndaa ifafà uboo a mbuur, ya ifun'buul wàŋingyäy. ");
INSERT INTO yns_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ntɔn an'kyän an'be ifàtoo fà boo, fà mpem a baar: ipasàsɛ, küb, ndwääl a baar, ");
INSERT INTO yns_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","intswem, ngyal a in'naaŋ, an'kyän an'be, loor, mɔ̈ɔ̈ a isak isak, intwɛn, mbɛɛy, nsɛɛn a an'pɛy, unsil. ");
INSERT INTO yns_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Indiir ibe abi byanswà byàfàtoo uboo, waa byàfàbuul mbuur wàŋingyäy. » ");
INSERT INTO yns_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yɛsu kàlwomà nde apan, nde kàkyen itiir a Tir. Nde kàbilà u ndwà mwɛy, nde kàkwen anki naa akà mbuur mwɛy uyɔ̈b. Wɛɛ yàkwe anki naa nde ukäl aŋàyee. ");
INSERT INTO yns_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yàmɛnà naa un'kaar mwɛy, mwan ande wun'kaar kàkäl anà dweelà a làbe. Pa kàwem nde làsaŋ a Yɛsu, laa kàyi nde, waa kàbü kà in'kɔl ande. ");
INSERT INTO yns_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Un'kaar awà kàkäl ungɛlɛki, un'nsi Fɛnisi u Siri. Nde kàlɔ̈ɔ̈mà akà Yɛsu naa nde uböŋ unsɔŋà unsà mwan ande wun'kaar. ");
INSERT INTO yns_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yɛsu kàtɛɛnà a nde naa: « Wɛy baan bàtàyuur, kàyubwaŋ anki muwal isaa a baan ntɔn mutɔɔm bya akà bimbwà. » ");
INSERT INTO yns_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nde wà kun'fuur naa: « Ndandaa, Mwol, itàkal bimbwà, ungyɛl a mɛsà, byàfàdyà mfür a isaa a baan. » ");
INSERT INTO yns_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Apan Yɛsu kàtɛn a nde naa: « Ntɔn ndaa ayi, kyen: unsɔŋà kan'too u mwan angye wun'kaar. » ");
INSERT INTO yns_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nde kàfura ndwà ande, waa kàmɛn mwan ande wàŋàsilà udu a itäb: unsɔŋà akyàtoo amu nde. ");
INSERT INTO yns_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yɛsu kàlwomà nde itiir a Tir, nde kàfurà ntsü a ɛwà a Ngalilɛ u mbwo a Sidɔn, waa kàlyaŋ itiir a Dɛkapɔl. ");
INSERT INTO yns_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Baar bun'twääl nkiin mwɛy kàyäämà a mpay, ba bun'bɔ̈ɔ̈n naa nde kun'si kɔɔ. ");
INSERT INTO yns_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Apan, Yɛsu kun'syen ukɔl, ukwel a un'sɛŋ a baar, kun'biil mpin kan'tsü, kàtsül an'te, waa kun'bä u làlem. ");
INSERT INTO yns_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ungö nde kàsɛn mii u du, kànyääm ikye, waa kàtɛn a nde naa: « Efàfàta! » Ikaswaŋà naa: « Dubà! » ");
INSERT INTO yns_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kà imbürà, an'tsü ande waa màdubà, làlem ande waa làtsuŋà, waa kàyäämà ubwaŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yɛsu kaswɛŋ naa ba bàkɔɔn asam akà mbuur mwɛy. Wɛɛ kàsin aswaŋà nde, ba bàsin apayà làsaŋ. ");
INSERT INTO yns_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ba bàkäl mubem mbɔɔn, waa bàtɛɛnà naa: « Indiir byanswà nde kan'kyer ubwaŋ! Nde wàmukyer naa ikwan'tsü bàwem, nkiin bàsi ndaa! » ");
INSERT INTO yns_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kà ilä abin un'sɛŋ a baar mbɔɔn kàkyer afàköŋ. Wa kàkäl anki anà indiir adyà, Yɛsu kàbel alɔŋki ande, waa kàtɛn a ba naa: ");
INSERT INTO yns_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","« Mɛ aman ngyɛb mbɔɔn ntɔn un'sɛŋ a baar wà, ntɔn, le, ŋàbà ilä itär abà ba anà mɛ, wɛɛ ba undiir adyà watɛy. ");
INSERT INTO yns_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wɛɛ, kya mɛ in'safuur an'bul aba anà ngyal, ba bakyer akàyɔn u mbwo. Bàmbɔɔn uboo aba bàfü kwɛl. » ");
INSERT INTO yns_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Alɔŋki ande bun'fuur naa: « U nsi ipɔl ayi, ntsü nà ban'kwo bi muman undiir adii ba, waa ba bàyuur? » ");
INSERT INTO yns_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nde kafuul naa: « Bɛ làwe amà mampà an'kwe? » Ba bàtɛn naa: « Nsambwaar ». ");
INSERT INTO yns_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Apan nde kàswɛŋ un'sɛŋ a baar mubwaay u mɛɛn. Ungɔ̈ apan nde kàwɛl mampà nsambwaar, kàfuur an'tɔɔn, kàtsül ma, waa kàpɛ ma akalɔŋki ntɔn ba bàkäb. Ba bàkäb ma akun'sɛŋ a baar wanswà. ");
INSERT INTO yns_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ba bàkäl sye anà binsö imwɛy. Ungɔ̈ musaak bya, nde kàtɛn naa ba bàkäb bya sye. ");
INSERT INTO yns_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Baar waa bàdi, waa bàyüür. Ba bàsyen in'lwaŋ, in'lwaŋ nsambwaar myà itsü byàsäl. ");
INSERT INTO yns_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kyekà baar bàkäl isii a nsaab nà. Ungö apan nde wakapay, ");
INSERT INTO yns_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","apan sye nde kàbilà u bwaar anà alɔŋki ande, waa bàkyen itiir a Dalmanutà. ");
INSERT INTO yns_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Amfarisi bàyi ba, waa bàsɛmà musà mbaaŋ anà Yɛsu ntɔn mukun'lwab ndaa. Ba bun'lɔ̈ɔ̈m impà kyan'fà du. ");
INSERT INTO yns_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nde kàŋyäm mbɔɔn unsà an'kyän ande, waa kàtɛn naa: « Ntɔn nkye baar a nkööl ayi bàlɔɔmà ba impà? Ndandaa mɛ alàkyään, baar a nkööl ayi akidiim a impà mwɛy bàsapà anki. » ");
INSERT INTO yns_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ungö apan kàsawɛy nde, nde kàfàbilà u bwaar, waa kàkyen sim a ɛwà lumwɛy. ");
INSERT INTO yns_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Alɔŋki bàkyärà mpiim muwal mampà, waa bàkäl alà làmwɛy mpel u bwaar. ");
INSERT INTO yns_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yɛsu kaswɛŋ naa: « Le, làkäl kigyɛɛŋ ntɔn ful a Amfarisi anà là Ɛlɔdi. » ");
INSERT INTO yns_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ba bàsyeelà mbaaŋ ba a ba ntɔn ba bàkäl anki anà mampà. ");
INSERT INTO yns_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yɛsu kàmɛn nde abun, waa kàtɛn a ba naa: « Ntɔn nkye làsyeelà bɛ mbaaŋ ntɔn lan'kɔɔn bɛ mampà? Nkye bɛ ŋàtàwal anki un'yɛnà, waa bɛ mpa làyöbà? Nkye mpem abɛ yàŋàbwà bwoor? ");
INSERT INTO yns_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bɛ làwe anà mii, nkye bɛ làkamanà anki? Bɛ làwe anà an'tsü, nkye bɛ làkawɛɛmà anki? Nkye bɛ làfàkayöbà anki: ");
INSERT INTO yns_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","mpal kàtsül mɛ mampà an'tyeen ntɔn abaal nsaab tyeen, in'lwaŋ aŋàyɔl a itsü in'kwe bɛ làsyen? » Ba bàtɛn a nde naa: « Kwɛm aŋiyweel. » ");
INSERT INTO yns_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","« Wɛɛ mpal kàtsül mɛ mampà nsambwaar ntɔn abaal nsaab nà, in'lwaŋ in'kwe myàŋàyɔl a itsü bɛ làsyen? » Ba waa bàtɛn naa: « Nsambwaar. » ");
INSERT INTO yns_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nde waa kàtɛn a ba naa: « Nkye bɛ ŋàtàyöb anki? » ");
INSERT INTO yns_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ba ban'tol Bɛtesayidà. Waa bun'twääl ikwàmii mwɛy, bun'bɔ̈ɔ̈n naa nde kun'bä. ");
INSERT INTO yns_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nde kàtɛ ikwàmii mpi u kɔɔ, waa kun'twey u nsà a bul. Nde kun'fül an'te u mii, kun'si an'kɔɔ, waa kun'fuulà naa: « Nkye ngye akimanà undiir? » ");
INSERT INTO yns_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nde kun'duub mii, waa kàtɛɛnà naa: « Mɛ in'täälà baar, mɛ ba amanà asànaa in'te, wɛɛ ba bàmuyikyà. » ");
INSERT INTO yns_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Apan Yɛsu kàfun'sà an'kɔɔ udu a mii. Baal awà waa kàmɛn ubwaŋàbwaŋ. Nde kàkyer akɔrà, waa kamɛnà indiir byanswà umwɛy umwɛy. ");
INSERT INTO yns_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Lalan Yɛsu kun'fuur nde ndwà ande, waa kun'kyään naa: « Twon an'bilà akikikye uboo a bul. » ");
INSERT INTO yns_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yɛsu kàkyen anà alɔŋki ande u ntsü an'bul a tsütsü anà Sɛzarɛ a Filipo. U mbwo, nde kàfuul alɔŋki ande naa: « Baar bàfàtɛn naa mɛ in'wà nà? » ");
INSERT INTO yns_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ba waa bun'fuur naa: « Ywan Un'düümà, bumwɛy, Ɛli, bumwɛy naa umwɛy uboo a aŋangɔɔm. » ");
INSERT INTO yns_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nde waa ufàfuul: « Wɛɛ bɛ ŋakwo làtɛn naa mɛ in'wà nà? » Petɔlà waa ufuur: « Ngye awà Klistɔ. » ");
INSERT INTO yns_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yɛsu kaswɛŋ a ngwal naa ba bàkɔɔn ayäm akà mbuur mwɛy ntɔn nde. ");
INSERT INTO yns_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Apan, nde kàsɛmà mukalɔŋ naa: « Mwan a mbuur akyer aman mpay mbɔɔn. Andwer, amfum a angaŋ anà alɔɔŋ a in'kɔɔn bàkyer un'tɔn, bàkyer un'dwa, waa ungö ilä itär nde akyer awiyà. » ");
INSERT INTO yns_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ndaa ayi nde kàtɛɛnà kimii imii. Apan Petɔlà kun'naan ukɔl, waa kàsɛmà mukun'ŋän. ");
INSERT INTO yns_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wɛɛ nde waa kàbulà, kàler alɔŋki ande, kàŋän Petɔlà, waa kàtɛn naa: « Satanà, kyen ungö a mɛ! Ntɔn ngye akayweerà anki indiir a Nzam, wɛɛ indiir a baar. » ");
INSERT INTO yns_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ungö nde kàbel un'sɛŋ a baar anà alɔŋki ande, waa kàtɛn a ba naa: « Isàkal naa mbuur akwen mukan'lab, wɛy nde ukɔɔb ndür ande, usɛɛn kulunsi ande, waa kan'lab. ");
INSERT INTO yns_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ntɔn mbuur usàkwen mutii mɔ̈ɔ̈ ande, wa asàkyà bwà, wɛɛ mbuur usàpiy mɔ̈ɔ̈ ande ntɔn mɛ anà làsaŋ aŋàbwaŋ, nde asàtswà wa. ");
INSERT INTO yns_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bweel nà mbuur kan'kwo muwal uman naa nde kan'wal mɛɛn manswà, wɛɛ mɔ̈ɔ̈ ande ukyà bwà? ");
INSERT INTO yns_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Abun, ininà mbuur kan'kwo mupà ntɔn musɔɔm mɔ̈ɔ̈ ande? ");
INSERT INTO yns_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ntɔn mbuur usàwem mɛ nswɛn anà ndaa amɛ uboo a nkööl ayi yinswem anà yube, Mwan a mbuur sye asun'wem nswɛn mpal usàyà nde unsà làkoo a Taarànde, anà akyeey in'kyɛɛl. » ");
INSERT INTO yns_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yɛsu kàfàtɛn a ba naa: « Ndandaa mɛ alàkyään, amwɛy uboo a baar bà pà, bàsàkwà anki kusà muman Imwol a Nzam kyàmuyiyà anà ngwal. » ");
INSERT INTO yns_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ungö ilä isyaam, Yɛsu kàwɛl Petɔlà, Zyak anà Ywan, waa kasyen u mpey udu a mɔŋ a bwɛlàbwɛl. Nde kàyoolà ifà u mii a ba, ");
INSERT INTO yns_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ipfɛy ande byàbulà byà tsɛk tsɛk, anà pɛɛl làmwɛy mpa kan'kwo akà un'yiir mwɛy mutwey. ");
INSERT INTO yns_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ɛli kàyàmɛnà anà Mɔsɛ akà ba. Ba bàkayäämà a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petɔlà kàtɛn a Yɛsu naa: « Un'lɔɔŋ, yubwaŋ naa bi ikäl apà. Wɛy bi imbaar ntɛn, ntɛn tär: mwɛy ntɔn ngye, mwɛy ntɔn Mɔsɛ, mwɛy ntɔn Ɛli. » ");
INSERT INTO yns_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nde kàyöb anki naa nde nkye utɛɛnà, ntɔn matɛɛr màkyer awal. ");
INSERT INTO yns_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Un'böŋ mwey kàyafwee wa, ndaa mwɛy yàtoo uboo un'böŋ awà naa: « Awà wà Mwan amɛ wà nkween. Lun'wem! » ");
INSERT INTO yns_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ungö apan, bàler ba umbil aba, ba bàsàman anki akà mbuur mwɛy, Yɛsu mpɛl anà ba. ");
INSERT INTO yns_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Umpal bàyàtyà ba u mɔŋ, nde katsüŋ mukyään itàkal akà mbuur mwɛy ndaa bàmɛn ba, tii mpal usàwiyà Mwan a mbuur uboo a akü. ");
INSERT INTO yns_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ba bàkyer akaar nswɛɛŋ ayi, wɛɛ ba bàfuulà ba a ba naa: « Ikaswaŋà aben \"ngwiiyà uboo a akü\"? » ");
INSERT INTO yns_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Apan ba bun'fuul naa: « Ntɔn nkye alɔɔŋ a in'kɔɔn bàfàtɛn ba naa: \"Ɛli akyer atwab atàyà\"? » ");
INSERT INTO yns_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nde kàtɛn a ba naa: « Yabwɛy naa Ɛli atàyà muyàfuur indiir byanswà u mbwo. Wɛɛ ntɔn nkye bàsön ba ntɔn Mwan a mbuur naa nde akyɛr aman mpay mbɔɔn, bun'wal asànaa undiir a bunàbun? ");
INSERT INTO yns_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Wɛɛ mɛ alàkyään naa Ɛli kàkyàyà, baar bun'kyer ndaa yanswà bàkwen ba, asànaa bàsön ya ntɔn nde. » ");
INSERT INTO yns_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mpal bàyafurà ba akà alɔŋki, ba bàmɛn un'sɛŋ a baar mbɔɔn apà ba anà alɔɔŋ a in'kɔɔn bàmusyeelà mbaaŋ anà ba. ");
INSERT INTO yns_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pa kàmɛn wa Yɛsu, un'sɛŋ a baar wanswà laa kàbamà wa, waa kàkyeenà ntiin mukun'pà mbɔr. ");
INSERT INTO yns_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nde waa kafuul naa: « Ininà bɛ làsyeelà mbaaŋ anà ba? » ");
INSERT INTO yns_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Baal mwɛy uboo a un'sɛŋ a baar kun'fuur naa: « Un'lɔɔŋ, mɛ amatwääl mwan amɛ wàbaal: nde we anà dweelà a nkiin. ");
INSERT INTO yns_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ikal kyanswà lun'kaar la, la lun'bwiy u mɛɛn, mwan ugyɔrà an'te, laa ukwoor nde an'din ande, waa ubwà un'sey. Mɛ an'tɛn a alɔŋki angye naa ba bàböŋ la, wɛɛ ba bàsàkal anki anà ngwal. » ");
INSERT INTO yns_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nde waa utɛn a ba naa: « Nkööl ikɔ̈ɔ̈n làkwikilà, tii nkye taaŋ mɛ insàkal anà bɛ? Tii mpal nà mɛ in'sàkaŋ mpem ntɔn bɛ? Lan'twääl awà. » ");
INSERT INTO yns_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ba waa bun'twääl. Umpal làmɛn dweelà a làbe Yɛsu, la làni mwan a ngwal, mwan kàbü u mɛɛn, waa kàyisilà wàmuyigyɔrà an'te. ");
INSERT INTO yns_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yɛsu kàfuul taarànde naa: « Sɛmà taaŋ nà ya ifun'yeel? » Nde waa kàten naa: « Sɛmà imbɛy ande. ");
INSERT INTO yns_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mbalà mbɔɔn la làfun'tɔɔm u mbaa anà kan'dà ntɔn mukun'dwa. Wɛɛ, isàkal naa ngye an'kwo mukyer undiir, yà ibay, ntɔn ngyɛb angye akà bi! » ");
INSERT INTO yns_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yɛsu waa kàtɛn a nde naa: « Isàkal naa ngye an'kwo! ... Indiir byanswà byàŋàkwo akà mbuur awe anà làkwikilà. » ");
INSERT INTO yns_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Apan sye, taar a mwan kàsi un'kwɛŋ naa: « Mɛ an'sà làkwikilà! Mbay ntɔn an'kɔɔn mɛ làkwikilà! » ");
INSERT INTO yns_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yɛsu, abà kàmɛn nde un'sɛŋ a baar wàmuyàkɔ̈ŋ, nde kàswɛŋ dweelà a làbe, waa kàtɛn naa: « Dweelà a nkiin anà ikwan'tsü, mɛ amaswaŋ, too ubɔɔ a mwan wà, twon an'fyefurà! » ");
INSERT INTO yns_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dweelà làsi in'kwɛŋ, waa lun'ni a ngwal. Mwan kàbulà asànaa wàŋàkwà, lalan bàmbɔɔn bàteenà ba naa: « Nde kan'kwà. » ");
INSERT INTO yns_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wɛɛ Yɛsu kun'tɛ mpi u kɔɔ, kun'mbaar, nde waa kàmbarà. ");
INSERT INTO yns_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mpal kàfurà Yɛsu ndwà, alɔŋki ande bun'fuul ukɔl naa: « Wɛɛ bi, ntɔn nkye mpa ikwe bi muböŋ dweelà a làbe alanà? » ");
INSERT INTO yns_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nde kàtɛn a ba naa: « Dweelà a tub alà làfàtoo u ngyamàkà mpɛl. » ");
INSERT INTO yns_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ba bàlwomà apan, waa bàsoonà Ngalilɛ. Yɛsu kàkwen anki naa baar bàyɔ̈b. ");
INSERT INTO yns_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ntɔn nde kàlɔɔŋà alɔŋki ande, waa kàtɛɛnà a ba naa: « Mwan a mbuur bàkyer ayun'yälà kàn'kɔɔ a baar, ba bàkyer ayun'dwà, waa ilä itär ungö a ndwääl ande, nde akyer ayàwiyà. » ");
INSERT INTO yns_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ba bàyöbà anki ndaa ayin, wɛɛ ba bàweemà bɔɔmà mukun'fuul. ");
INSERT INTO yns_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ba bàkyen Kapɛrnawum. Umpal kàkäl nde u ndwà, Yɛsu kàfuul alɔŋki ande naa: « Ininà bɛ làyisyeelà mbaaŋ u mbwo? » ");
INSERT INTO yns_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wɛɛ ba bàkäl akul, ntɔn u mbwo, ba bàyisyeelà mbaaŋ ba a ba ntɔn muyöb naa nà awà mbuur a kölàköl. ");
INSERT INTO yns_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yɛsu kàkyer abwaay, waa kàbel Bàkwen Aŋiyweel, waa kàtɛn a ba naa: « Isàkal naa mbuur akwen mukäl wàtàtwɛb, wɛy nde ukäl wàngöngö anà un'syääl a baar banswà. » ");
INSERT INTO yns_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Apan nde kàwɛl mwan mwɛy, waa kun'si uboboo a ba. Ungö akun'böbà mpi, nde kàtɛn a ba naa: ");
INSERT INTO yns_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","« Mbuur awal mwan asànaa wà kikɔb amɛ, nde kan'wal mɛ ŋakwo: mbuur kàman'wal, kà mɛ anki nde kan'wal, wɛ Mbuur kan'töm. » ");
INSERT INTO yns_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ywan waa kàtɛn a Yɛsu naa: « Un'lɔɔŋ, bi kàmɛn mbuur mwɛy wàmuböŋ an'dweelà an'be kikɔb angye, wɛɛ bi kàleŋ mukun'tsuŋ mukyer abun ntɔn nde bi kàfilabà anki. » ");
INSERT INTO yns_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Wɛɛ Yɛsu kàtɛn naa: « Twon làmutsuŋ, ntɔn kà we anà mbuur anki kan'kwo mukyer impà kà ikɔb amɛ, waa ungö apan nde ufàtɛn ube ntɔn mɛ. ");
INSERT INTO yns_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Abun, mbuur mpa afàtɔn bi wà anà bi. ");
INSERT INTO yns_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mbuur wanswà asàlapà kɔɔb a an'dà anwà, ntɔn bɛ làbà baar a Klistɔ, mɛ alàkyään ndandaa, bweel ande làsàkyà anki bwà. ");
INSERT INTO yns_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","« Wɛɛ mbuur wanswà asiinà umwɛy uboo a bibaan ban'sà làkwikilà bà akà mɛ mubwà unsà ube, yan'söön ubwaŋ akà nde naa bun'bäm nkà a kölàköl u bway, waa bun'tɔɔm kà ɛwà. ");
INSERT INTO yns_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Isàkal naa kɔɔ angye làfasyen nkuur unsà ube, tsul la. Ntɔn yan'söön ubwaŋ naa ngye abilà u mɔ̈ɔ̈ kɔɔ làmwɛy, akwànaa ngye mukal amà an'kɔɔ an'mɔ̈ɔ̈l, waa akyà yaaŋ a mbaa mpa làfàdim.  ");
INSERT INTO yns_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kwo, \"in'swab myàfàkwà anki, mbaa ifàdim anki akà ikikye.\"  ");
INSERT INTO yns_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Isàkal naa làkɔl angye làfasyen nkuur unsà ube, tsul la. Ntɔn yan'söön ubwaŋ naa ngye abilà u mɔ̈ɔ̈ anà too, akwànaa ngye mukal amyà in'kɔl myeel, waa akyà yaaŋ a mbaa.  ");
INSERT INTO yns_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kwo, \"in'swab myàfàkwà anki, mbaa ifàdim anki akà ikikye.\"  ");
INSERT INTO yns_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Isàkal naa dii angye làfasyen nkuur unsà ube, kwol la. Ntɔn yan'söön ubwaŋ naa ngye abilà imwol a Nzam anà dii làmwɛy, akwànaa ngye mukal amyà mii myeel, waa batɔɔm u yaaŋ a mbaa. ");
INSERT INTO yns_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kwo, in'swab myàfàkwà anki, mbaa ifàdim anki akà ikikye. ");
INSERT INTO yns_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","« Abun, mbuur wanswà asàlyaŋ u mbaa, asàwal muŋ ntɔn mupɔŋà. ");
INSERT INTO yns_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","« Muŋ wà undiir aŋàbwaŋ, wɛɛ ntsà awa isàwà, bɛ ya làfuur aben? Làkäl anà muŋ uboo abɛ ŋakwo, làkäl unsà duu uboo amwɛy anà bumwɛy. » ");
INSERT INTO yns_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yɛsu kàlwomà nde apan, nde kàkyen itiir a nsi a Yuday, u sim a Yɔrdan lumwɛy. In'sɛŋ a baar myàfàköŋ apà nde, nde kàfalɔɔŋà asànaa nkääl ande. ");
INSERT INTO yns_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Amfarisi bàsin tsütsü apà nde ntɔn mukun'fuul naa : « Nkye mbwo yàmwo baal muböŋ un'kyay ande. » ");
INSERT INTO yns_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yɛsu kafuur naa: « Ininà Mɔsɛ kàlaswɛŋ? » ");
INSERT INTO yns_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ba bàtɛn naa: « Mɔsɛ kàpɛ mbwo musɔn ukaan a nkaabà anà muböŋ un'kaar. » ");
INSERT INTO yns_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yɛsu waa kàtɛn a ba naa: « Yà ntɔn bwoor a mpem abɛ waa nde kàlapɛ nswɛɛŋ ayi. ");
INSERT INTO yns_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wɛɛ u nsɛmà a nkyeer, Nzam \"kakyer baal anà un'kaar\". ");
INSERT INTO yns_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"Lalan baal asàwɛy taarànde anà ngwän, waa usàbääb a un'kyay ande, ");
INSERT INTO yns_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","waa ba bàbɔ̈ɔ̈l bàsabulà ndür mwɛy. Apan, ba bàfàkal anki abɔ̈ɔ̈l, wɛɛ ndür mwɛy. ");
INSERT INTO yns_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Abun, wɛy mbuur ukɔɔn akaab ayi kàtüüb Nzam.\" » ");
INSERT INTO yns_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mpal bàkäl ba u ndwà, alɔŋki bàfun'fuul ntɔn ndaa ayi. ");
INSERT INTO yns_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nde kàtɛn a ba naa: « Baal usàwɛy un'kyay ande, usàbääl un'kyay asin, nde kan'tà inswem akà wàtàtwɛb. ");
INSERT INTO yns_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Isàkal naa un'kaar kan'wɛy un'dim ande, usàwal wàsin, nde wà un'kaar inswem. » ");
INSERT INTO yns_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Baar bàtwäälà baan ntɔn nde kabä, wɛɛ alɔŋki bàŋän ba. ");
INSERT INTO yns_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mpal kàmɛn nde abun, Yɛsu kàmɛn ube, waa kàtɛn a ba naa: « Làwɛy baan bàyi akà mɛ! Twon làmatsuŋ, ntɔn Imwol a Nzam kye a baar abà asànaa ba. ");
INSERT INTO yns_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ndandaa mɛ alàkyään, mbuur mpà awal Imwol a Nzam asànaa mwan, nde kya usàbilà anki. » ");
INSERT INTO yns_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ungö, nde kàbööbà baan, waa kasi an'kɔɔ ntɔn mukasaak. ");
INSERT INTO yns_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mpal kàkäl Yɛsu mukyà, mbuur mwɛy kàyi u ntiin, waa kàbü an'köm kusà ande, waa kun'fuul naa: « Un'lɔɔŋ aŋàbwaŋ, mɛ in'kyer aben muwal bweel a mɔ̈ɔ̈ a mbul a in'tye? » ");
INSERT INTO yns_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yɛsu kàtɛn a nde naa: « Ntɔn nkye aman'bel ngye aŋàbwaŋ? Akà mbuur mwɛy wàŋàbwaŋ watɛy isàkal naa kà Nzam mpɛl anki. ");
INSERT INTO yns_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ngye akiyöb in'kɔɔn: \"Twon an'dwà, twon an'tà inswem, twon an'yib, twon an'tà imbäl a loor, twon an'kyer mbuur ube, sà làkoo akà taaràŋà anà ngwa.\" » ");
INSERT INTO yns_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mbuur waa kun'fuur naa: « Un'lɔɔŋ, ayin yanswà mɛ in'kyer afàlab sɛmà imbɛy amɛ. » ");
INSERT INTO yns_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yɛsu kun'ler nde, waa kun'kwen, waa kàtɛn a nde naa: « Undiir mwɛy mpɛl kàmakɔ̈ɔ̈n: kyen, yälà indiir angye byanswà, pà ngim ya akà aŋàlàmbwà, waa ngye asàwal un'naaŋ u du. Ungö apan, yan'läb. » ");
INSERT INTO yns_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wɛɛ u ndaa ayi, nde kàbü mpye, waa kàkyen u ngyɛb mbɔɔn. Ntɔn nde kàkäl anà indiir mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yɛsu kàler umbil ande, waa kàtɛn a alɔŋki ande naa: « Yà mpay mbɔɔn akà aŋin'naaŋ mubilà kà Imwol a Nzam! » ");
INSERT INTO yns_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Alɔŋki bàmɛn mpay ntɔn ndaa ande. Wɛɛ Yɛsu kàfàtɛn a ba naa: « Baan amɛ, yà mpay mbɔɔn mubilà kà Imwol a Nzam! ");
INSERT INTO yns_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mpay yatɛy mbɔɔn akà mpoonà mubilà u mun a nsway akwànaa ŋun'naaŋ mubilà kà Imwol a Nzam. » ");
INSERT INTO yns_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ba bakyer abem mbɔɔn, waa bàtɛɛnà ba a ba naa: « Abun, nà kan'kwo muwà mɔ̈ɔ̈? » ");
INSERT INTO yns_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yɛsu kaler, waa kàtɛn naa: « Ya ikwe anki akà baar, wɛɛ akà Nzam yanswà ikyer afàkwo. » ");
INSERT INTO yns_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petɔlà kàsɛmà mutɛn a nde naa: « Le bi, bi kàkyàwɛy indiir byanswà ntɔn mulab ngye. » ");
INSERT INTO yns_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yɛsu waa kàtɛn a nde naa: « Ndandaa mɛ alàkyään, isàkal naa mbuur an'sàwɛy ndwà, atɔŋ abaal, atɔŋ akaar, ngwän, taarànde, baan, an'ywaŋ ntɔn mɛ anà ntɔn Làsaŋ Aŋàbwaŋ, ");
INSERT INTO yns_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nde asàwal mbalà nkam aŋàsöönà u paŋà alà, ndwà, atɔŋ abaal, atɔŋ akaar, ngwän, baan, an'ywaŋ, - anà nkwaaŋ - anà u paŋà làyà, mɔ̈ɔ̈ a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lalan, bàtàtwɛb mbɔɔn bàsàkal bàngöngö, bàngöngö bàsàkal bàtàtwɛb. » ");
INSERT INTO yns_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ba bàkäl u mbwo mubeenà Yɛlusàlɛm. Yɛsu kàyikyeenà kusà a ba. Ba bàkäl mutɛɛr, baar bàyun'labà bàkal u bɔɔmà. Apan nde kàfàwal Bàkwem Aŋiyweel anà nde, waa kàsɛmà mukakyään ndaa ayà ikun'bweel: ");
INSERT INTO yns_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","« Le, bi iwàmubeenà Yɛlusàlɛm, akun Mwan a mbuur bàkyer akun'yälà akà amfum angaŋ anà akà alɔɔŋ a in'kɔɔn. Ba bàkun'tsüül mbar a ukwà, waa bàkun'yälà kan'kɔɔ a baar mpa abà Ayudà, ");
INSERT INTO yns_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","bàkyer akun'sɛ, bàkyer akun'tsul an'te, bàkyer akun'kam an'füm anà bàkyer akun'dwa, wɛɛ ungö a ilä itär, nde akyer asàwiyà. » ");
INSERT INTO yns_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Apan, Zyak anà Ywan, baan a Zebeday, bàkyen tsütsü apà Yɛsu, waa bàtɛn a nde naa: « Un'lɔɔŋ, bi ikwen naa ngye akyer ntɔn bi undiir kalɔ̈ɔ̈m bi. » ");
INSERT INTO yns_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nde waa kàtɛn a ba naa: « Ininà bɛ làkwen naa mɛ in'kyer ntɔn bɛ? » ");
INSERT INTO yns_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ba bun'fuur naa: « Ipɛ mbwo bi mubwaay u làkoo angye, umwɛy u kɔɔ angye là ibaal, wumwɛy u kɔɔ angye là ikaar. » ");
INSERT INTO yns_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yɛsu kàtɛn a ba naa: « Bɛ làyöbà anki undiir làlɔɔmà bɛ. Nkye bɛ làn'kwo munwà kɔɔb a mpay in'yànwà mɛ, itàkal naa muwal ndüümà ayin'yàwal mɛ? » ");
INSERT INTO yns_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ba bàtɛn a nde naa: « Bi kan'kwo. » Yɛsu waa kàtɛn a ba naa: « Kɔɔb in'yànwà mɛ, bɛ làkyer ayànwà la, ndüümà in'wal mɛ, bɛ làkyer ayàwal ya. ");
INSERT INTO yns_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wɛɛ mubwaay u kɔɔ amɛ là ibaal itàkal là ikaar, kà mɛ anki an'kwo mupà: ikal abi byà ntɔn baar kàlɔ̈ɔ̈n Nzam bya. » ");
INSERT INTO yns_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bàkwen bumwɛy bàwem ba ndaa ayin, ba bàmɛn Zyak anà Ywan ube. ");
INSERT INTO yns_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Apan Yɛsu kabel, waa kàtɛn a ba naa: « Bɛ, bɛ làkyàyöb naa baar bàfàmɛnà asànaa amfum a in'sɛŋ bàfasà ungyɛl a in'kɔl aba, baar an'köl an'köl bàfàswaŋ ba ikɔ̈b aba. ");
INSERT INTO yns_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ya ikwe anki mukal abwɛy uboo abɛ. Wɛɛ isàkal naa mbuur akwen mukal wàkölàköl uboo abɛ, wɛy nde ukäl un'syääl abɛ, ");
INSERT INTO yns_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","mbuur wanswà akwen mukal wàtàtwɛb uboo abɛ, nde akal un'sɔ a baar banswà. ");
INSERT INTO yns_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Lalan Mwan a mbuur kàyi anki ntɔn bun'syääl, wɛɛ nde kàyi ntɔn musyääl anà mupà mɔ̈ɔ̈ ande asànaa nkwiy ntɔn baar mbɔɔn. » ");
INSERT INTO yns_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ba bàtöl Yɛlikɔ. Umpal kàkäl Yɛsu mutoo u bul alan anà alɔŋki ande anà un'sɛŋ a baar mbɔɔn, ikwàmii Bartimɛ, mwan baal a Timɛ, kàkäl aŋàbwaay ukɔl a mbwo mulɔɔmà. ");
INSERT INTO yns_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mpal kàwem nde naa awɛy Yɛsu un'nsi Nasàlɛr kàkäl, nde kàsɛmà mukuub in'kwɛŋ: « Mwan a David, Yɛsu, nsyääm! » ");
INSERT INTO yns_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bàmbɔɔn bun'swɛŋà naa nde ukäl akul, wɛɛ nde kàsöönà mulaal: « Mwan a David, nsyääm! » ");
INSERT INTO yns_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yɛsu waa kàmbär, waa kàtɛn naa: « Lun'bel! » Ba bàbel ikwàmii, waa bàtɛn a nde naa: « Wal ibaal, mbarà, nde kàmabel. » ");
INSERT INTO yns_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Apàn, nde kàpiy kàzak ande, waa kàmbarà, kàparà ntiin mukyà akà Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yɛsu kun'fuul naa: « Ininà ngye akwen mɛ mukyer ntɔn ngye? » Ikwàmii kun'fuur naa: « Un'lɔɔŋ, wɛy mɛ in'fàman! » ");
INSERT INTO yns_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yɛsu kàtɛn a nde naa: « Kyen, làkwikilà angye làmatswà mɔ̈ɔ̈. » Apan sye nde waa kàfàman, waa kàyilabà Yɛsu u mbwo. ");
INSERT INTO yns_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mpal bàtɔ̈l ba tsütsü a Yɛlusàlɛm, tsütsü a Bɛtfagɛ anà Bɛtani, mper a mɔŋ a In'te a Ɔlive, Yɛsu kàtöm abööl uboo alɔŋki ande, ");
INSERT INTO yns_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","waa kàtɛn a ba naa: « Làkyen u bul lanà kusà a bɛ: Pa làkàbilà bɛ uboo a la, bɛ làkàman mwan a ntsür bàfàbel naa anɛs, udu awa mbuur ŋàtàlaar anki. Làtsuuŋ wa, lan'twääl awà. ");
INSERT INTO yns_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Isàkal naa mbuur kan'tɛn a bɛ naa: \"Ntɔn nkye làkyerà bɛ abun?\" Lun'fuur naa: \"Mwol we anà mfun a wa, waa làgyägyä nde ayàfuur wa apà.\" » ");
INSERT INTO yns_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Apan, ba waa bàkyen, waa bàmɛn mwan anɛ wàŋàbäm u nsà tsütsü a munàmbwo, u balàbal. Ba bàtsuuŋ wa. ");
INSERT INTO yns_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Baar amwɛy bàkäl paa bafuul naa: « Ntɔn nkye làtsuuŋà bɛ mwan anɛ? » ");
INSERT INTO yns_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ba bafuur asànaa kàtɛn Yɛsu, ba waa bawɛy musyen wa. ");
INSERT INTO yns_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba bàsyen mwan anɛ akà Yɛsu, waa bàyeel ipfɛy aba udu a wa, Yɛsu waa kàbwaay udu a wa. ");
INSERT INTO yns_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Baar mbɔɔn bàyeel ipfɛy aba u mbwo, bumwɛy ibwiy a nkay bàtsüülà ba kan'ywaŋ. ");
INSERT INTO yns_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Baar bàyikyeenà kusà anà baar bàyilabà bàkäl muyisà in'kwɛŋ naa: « Ɔsana! Nsaak ikäl akà mbuur ayà kikɔb a Mwol! ");
INSERT INTO yns_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nsaak ikal kà imwol kyan'yà, imwol a taaràbi David! Ɔsana kà ikal a dudu! » ");
INSERT INTO yns_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yɛsu kàkyen Yɛlusàlɛm, waa kàbilà u ndwà a Nzam. Ungö muler indiir byanswà byàkäl apà nde, taaŋ sye làkäl làŋàkyà, waa kàtoo, kàkyen Bɛtani anà Bàkwem Aŋiyweel. ");
INSERT INTO yns_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Taaŋtyà, umpal bàtoo ba u Bɛtani, Yɛsu kàwen ngyal. ");
INSERT INTO yns_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Apan waa kàtääl un'te a an'fige kàkäl anà nkay, nde kàkàler wa naa nkye nde akyàman undiir mwɛy. Wɛɛ mpal kàsin nde tsütsü, nde kàmɛn nkay mpɛl, ntɔn la làkäl anki paŋà a an'fige. ");
INSERT INTO yns_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Lalan kàtɛn nde a wa naa: « Wɛy mbuur mwɛy ukɔɔn asàdyà imbɛŋ angye akà ikikye! » Alɔŋki ande waa bàwem. ");
INSERT INTO yns_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ba bàtöl Yɛlusàlɛm. Yɛsu kàbilà u ndwà a Nzam, waa kàsɛmà muböŋ baar bàyäälà anà bàsöömà u ndwà a Nzam: nde kàbuum mɛsà a agyɛɛŋ a ngim anà an'kir a ayääl a nkokà, ");
INSERT INTO yns_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","nde kàwɛy anki akà mbuur mwɛy mulyaaŋ anà undiir u ndwà a Nzam. ");
INSERT INTO yns_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nde kàlɔɔŋà, waa kàtɛɛnà a ba naa: « Nkye bàsön anki naa: \"Ndwà amɛ bàsabeelà ndwà a ngyamàkà ntɔn in'sɛŋ myanswà\"? Wɛɛ bɛ, bɛ ya làkyàbuul mboo a mbüüb! » ");
INSERT INTO yns_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Amfum a angaŋ anà alɔɔŋ a in'kɔɔn bàwem ba ndaa ayin, ba bàleŋà mbwo mukun'dwa. Ntɔn ba bun'weemà bɔɔmà, ntɔn an'lɔɔŋ ande màtü un'sɛŋ a baar. ");
INSERT INTO yns_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mpal làbü sisye, Yɛsu anà alɔŋki ande waa bàtoo u bul a kölàköl. ");
INSERT INTO yns_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mpal bàkal ba mulyaaŋ u tutu, ba bàmɛn un'te a an'fige wàŋàyɔm tii kà in'swɛy awa. ");
INSERT INTO yns_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petɔlà kàyɔbà nde, laa kàtɛn nde naa: « Un'lɔɔŋ, ler, un'te a an'fige akwà kàküül ngye kan'yɔm wanswà. » ");
INSERT INTO yns_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yɛsu kafuur naa: « Làkäl anà làkwikilà akà Nzam. ");
INSERT INTO yns_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ndandaa mɛ alàkyään, isàkal naa mbuur kan'tɛn a mɔŋ wà naa: \"Lwomà apan, kyen kàbü u ngyäl\", ukɔɔn asà nkyɛɛr u mpem ande, wɛɛ nde usi làkwikilà naa ndaa kan'tɛn nde ikyer akwo, ya sye laa isàkwo ya ntɔn nde. ");
INSERT INTO yns_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lalan mɛ alàkyään naa: indiir byanswà làlɔm bɛ unsà ngyamàkà, làkäl anà làkwikilà naa bɛ bya lan'wal, bya byàbɛ. ");
INSERT INTO yns_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Umpal làwà bɛ umbäär u ngyamàkà, isàkal naa bɛ làwe anà nkir a mbuur, lun'dwääl nkul, waa Taaràbɛ awà u du uyàladwääl sye nkul a ibii abɛ.  ");
INSERT INTO yns_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wɛɛ bɛ làsàkɔɔn adwääl nkul a ibii, Taaràbɛ awà u du uyàladwääl anki sye nkul a ibii abɛ.  » ");
INSERT INTO yns_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ba ban'yàfurà Yɛlusàlɛm. Umpal kàkäl Yɛsu muyiyoolà uboo a ndwà a Nzam, amfum a angaŋ, alɔɔŋ a in'kɔɔn anà andweer bàyàsin apà nde, ");
INSERT INTO yns_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","waa bàtɛn a nde naa: « Unsà ikɔ̈b nà akyerà ngye indiir abi? Itàkal naa nà kapɛ ikɔ̈b mukyer bya? » ");
INSERT INTO yns_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yɛsu kàtɛn a ba naa: « Mɛ alàsà mfuul mwɛy mpɛl, lan'fuur, waa mɛ in'yàtɛn a bɛ naa unsà ikɔ̈b nà mɛ in'kyerà indiir abi. ");
INSERT INTO yns_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nkye ndüümà a Ywan yàfü du lɛɛ akà baar? Lan'fuur! » ");
INSERT INTO yns_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ba bàyweerà ba a ba naa: « Kya bi isàtɛn naa: \"U du\", nde ayifuul naa: \"Ntɔn nkye mpa lun'si bɛ làkwikilà?\" ");
INSERT INTO yns_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wɛɛ, nkye bi itɛn naa: \"Akà baar\"...? - Ba bàtiinà un'sɛŋ a baar bɔɔmà, ntɔn ba banswà bàsii naa Ywan kàkäl ŋangɔɔm ndandaa. » ");
INSERT INTO yns_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Lalan bàfuur ba akà Yɛsu naa: « Bi iyöb anki. » Apan Yɛsu waa kàtɛn a ba naa: « Mɛ sye alàkyään anki unsà ikɔ̈b nà mɛ in'kyerà indiir abi. » ");
INSERT INTO yns_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Apan Yɛsu kàsɛmà muyääm a ba unsà nsim naa: « Mbuur mwɛy kàkön ywaŋ a vin. Nde kàdiŋà la a làpaŋ. Nde kàtöŋ ikal mukaam mbɛŋ anà ndwà a ikyɛɛŋ. Ungö apan nde kàpɛ la akà baar musyääl a la, waa kàkyen. ");
INSERT INTO yns_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Utaaŋ mubwo, nde kàtöm un'syääl ande mwɛy akà baar bàfàkyer vin ntɔn muwal akà ba kab a isaa lànde. ");
INSERT INTO yns_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Baar abà bàtɛ un'syääl awà mpi, bun'düb, waa bun'fuur an'kɔɔ ipɔl. ");
INSERT INTO yns_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nde kàfatööm un'syääl asin. Awà sye, ba bun'düb kun'tswe, waa bun'tö. ");
INSERT INTO yns_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nde kàtöm wàsin, wawun sye ba bàkyer un'dwà, anà bàsin sye mbɔɔn: bumwɛy bàkyer adüb, bumwɛy bàkyer adwa. ");
INSERT INTO yns_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nde kàsàsal awà nà mwan ande mwɛy mpɛl wà nkween. Nde kun'töm ungöngö, waa kàtɛn naa: \"Ba bàyàkàkömà mwan amɛ.\" ");
INSERT INTO yns_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wɛɛ baar bàfàkyer vin bàtɛn ba a ba naa: \"Le ikyee ande. Làyi bi kun'dwä, waa ywaŋ làyàkal làbi!\" ");
INSERT INTO yns_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Apan, ba bun'tɛ mpi, bun'dwä, waa bun'tɔɔm unsà a ywaŋ a vin. » ");
INSERT INTO yns_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","« Apan ŋàywaŋ asàkyer aben? Nde akyer asàyà, akyɛr asàswaŋ baar mukadwa, waa usàpà ywaŋ akà baar asin. ");
INSERT INTO yns_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nkye bɛ làtäŋ anki itiir a ndaa ki uboo a Ndaa Aŋàsɔn: \"Nkɔŋ bàpiy atööŋ, yàkyàbulà nkɔŋ a twɛrà. ");
INSERT INTO yns_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ayi ndaa yàfü akà Mwol: ya yà ndaa ubem u mii a bi!\" » ");
INSERT INTO yns_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ba bàleŋà ipöl mukun'kɔr, wɛɛ ba bàtiinà un'seŋ bɔɔmà. Ba bàkyer ayɔ̈b naa nde nsim ayi kàtɛ ntɔn ba. Apan ba bàsun'wɛy, waa bàkyen. ");
INSERT INTO yns_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ungö apan, ba bun'tööm Amfarisi amwɛy anà baar a Ɛlɔdi ntɔn ba bun'lwɛb ndaa u mbwo a ntɛɛn ande ŋakwo. ");
INSERT INTO yns_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ba bàyàtɛn a nde naa: « Un'lɔɔŋ, bi ikyàyöb naa ngye awà swalaa anà ngye afàlab anki ukwen a mbuur mwɛy: ngye afàler anki ntabwey a baar, wɛɛ ngye afàlɔŋ mbwo a Nzam unsà ndandaa. Nkye bàkyàpà mbwo, lɛɛ tɛy, mufur itɛr akà Sɛzar? Nkye bi ikyer afur lɛɛ ifur anki? » ");
INSERT INTO yns_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wɛɛ nde, abà kàyöb nde mpem yweel aba, nde kàtɛn a ba naa: « Ntɔn nkye làman'lwab bɛ? Lan'twääl itɛr a ngim, mɛ in'kwen muman kya. » ");
INSERT INTO yns_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ba bun'twääl imwɛy. Yɛsu waa kafuul naa: « Ntabwey anà ikɔb ki udu akya byà nà? » Ba bàfuur naa: « Byà Sɛzar. » ");
INSERT INTO yns_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yɛsu waa kàtɛn a ba naa: « Làpɛ indiir a Sɛzar akà Sɛzar, indiir a Nzam akà Nzam. » Ba bàkyer abemà ntɔn nde. ");
INSERT INTO yns_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Asadusu amwɛy ban'yà akà Yɛsu. Baar abà bàfàtɛn naa akü bàfàwiyà anki. Ba bun'fuulà abà: ");
INSERT INTO yns_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","« Un'lɔɔŋ, Mɔsɛ kàsɔn abà ntɔn bi: \"Isàkal naa baal mwɛy un'tɔŋ ande kan'kwà, kan'sàwɛy un'kaar, ukɔɔn awɛy baan, wɛy nde ubääl un'kweel un'dim awà ntɔn mupà un'tɔŋ ande mbɛŋ.\" ");
INSERT INTO yns_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bàkäl anà atɔŋ nsambwaar. Wàtàtwɛb kàkyer abääl, waa kàkü ukɔɔn asàwɛy mwan. ");
INSERT INTO yns_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wàyweel kàbääl un'kaar awun, waa kàkü ukɔɔn asàwɛy mwan. Wàtär sye abun, ");
INSERT INTO yns_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ba bànsambwaar bàsàwɛy anki akà mwan mwɛy. Ungö a ba bànswà, un'kaar sye waa kàkü. ");
INSERT INTO yns_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","U ngwiiyà, mpal bàsàwiyà akü, nde asàkal un'kyay a nà uboo a ba? Ntɔn ba bànsambwaar bàkyer un'bääl! » ");
INSERT INTO yns_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yɛsu kakyään naa: « Ntɔn bɛ làyöb anki Ndaa Aŋàsɔn, itàkal ngwal a Nzam, waa bɛ lan'diimà mbwo, kabwɛy anki? ");
INSERT INTO yns_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Abun, mpal bàsàwiyà baar uboo a akü, ba bàsàbääl anki akyay, itàkal adim, wɛɛ ba bàsàkal asànaa akyeey u du. ");
INSERT INTO yns_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ntɔn ngwiiyà a akü, nkye bɛ làtäŋ anki, uboo a un'kaan a Mɔsɛ, unsà nsim a ibwiy a mbaa, ndaa kàtɛn Nzam a nde naa: \"Mɛ in'wà Nzam a Abàlam, Nzam a Izak anà Nzam a Yakɔb.\" ");
INSERT INTO yns_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nde kà wà Nzam a akü anki, wɛɛ wà baar a mɔ̈ɔ̈. Bɛ làkadiimà mbwo mbɔɔn. » ");
INSERT INTO yns_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Un'lɔɔŋ a in'kɔɔn mwɛy awà kàwem nsyeel a mbaaŋ aba, kàkyer ayöb naa Yɛsu kafuur ubwaŋ, laa kàsin nde, waa kun'fuul naa: « Un'kɔɔn nà wàtàtwɛb unsà in'kɔɔn myanswà? » ");
INSERT INTO yns_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yɛsu kàfuur naa: « Wàtàtwɛb awà: \"Isàlɛl, wem, Mwol Nzam abi, Mwol wà mwɛy, ");
INSERT INTO yns_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ngye ayàkwen Mwol Nzam angye unsà mpem angye yanswà, unsà mɔ̈ɔ̈ angye wanswà, unsà an'kyän angye manswà anà unsà ngwal angye yanswà.\" ");
INSERT INTO yns_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wàyweel awà: \"Ngye ayàkwen un'tɔŋ angye asànaa ngye ŋakwo.\" In'kɔɔn asin myatɛy myasöön ami. » ");
INSERT INTO yns_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Un'lɔɔŋ a in'kɔɔn kàfàtɛn naa: « Un'lɔɔŋ, ngye an'tɛn ndandaa: Nde wà nde mpɛl, wàsin watɛy, ");
INSERT INTO yns_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","waa, mukun'kwen u mpem ande yanswà, kun'yɛnà ande wanswà, u ngwal ande yanswà, anà mukwen un'tɔŋ ande asànaa nde ŋakwo, yan'söön ibɔɔn byanswà anà an'kab. » ");
INSERT INTO yns_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yɛsu kàmɛn nde naa nde kan'fuur a un'yɛnà, waa kàtɛn a nde naa: « Ngye kwel watɛy anà Imwol a Nzam. » Ungö apan, akà mbuur mwɛy kàfun'sà anki mfuul. ");
INSERT INTO yns_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Apan, Yɛsu kàlɔɔŋà u ndwà a Nzam, waa kàtɛɛnà naa: « Ya ye aben naa alɔɔŋ a in'kɔɔn ban'kwo mutɛn naa Klistɔ wà mwan a David? ");
INSERT INTO yns_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David ŋakwo kàtɛn u ngwal a Dwɛɛl In'kyɛɛl naa: \"Mwol kàtɛn a mwol amɛ naa: Bwaay u kɔɔ amɛ là ibaal, tii mpal in'sàsà mɛ ayiiŋ angye u ngyɛl in'kɔl angye.\" ");
INSERT INTO yns_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David ŋakwo kun'bel Mwol, apan nde mwan ande wà aben? » Un'sɛŋ a baar mbɔɔn kun'weemà unsà un'sak. ");
INSERT INTO yns_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Unsà an'lɔɔŋ ande, nde kàtɛɛnà naa: « Làkäl kà igyɛɛŋ ntɔn alɔɔŋ a in'kɔɔn: ba bàfàkwen muyilyaaŋ anà mvwɛl, naa bapɛ mbɔr kà ikal a nköŋ, ");
INSERT INTO yns_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","bàfàsɔɔl an'kir amà kusà uboo a ndwà a nköŋ a Ayudà anà ikal atàtwɛb kà in'kyɔm. ");
INSERT INTO yns_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ba bàfàduum indiir a akweel adim, taaŋ nsil alan ba bàfasà ngyamàkà a bwɛlàbwɛl. Nsaŋ aba isàkal yà kölàköl! » ");
INSERT INTO yns_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Apan Yɛsu kàbwaay kusà a insak a an'kab, waa kàlerà naa baar bàkàsaa aben ngim uboo a kya. Aŋin'naaŋ bàmbɔɔn bàsye mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Un'kweel a un'dim wàŋàlàmbwà waa kàyi, waa kàsi bitɛr a ngim ibyeel, byàsànten. ");
INSERT INTO yns_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yɛsu kàbel alɔŋki ande, waa kàtɛn a ba naa: « Ndandaa mɛ alàkyään, un'kweel a un'dim wàŋàlàmbwà wà kàn'sà yàŋàsöön baar banswà bàsaa uboo a insak. ");
INSERT INTO yns_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ntɔn baar banswà ban'pà ngim ikɔ̈ɔ̈n ndöŋ akà ba. Wɛɛ nde, nde kan'wal unsà làmbwà ande ntɔn mupà yinà yanswà kàkäl nde ayà ntɔn mɔ̈ɔ̈ ande. » ");
INSERT INTO yns_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Umpal kàkäl Yɛsu mutoo u ndwà a Nzam, umwɛy uboo a alɔŋki ande kàtɛn a nde naa: « Un'lɔɔŋ, le! In'kul nà myàkölàköl, ndwà nà yàkölàköl! » ");
INSERT INTO yns_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yɛsu waa kàtɛn a nde naa: « Ngye akimanà ndwà a kölàköl yi! Akà nkɔŋ mwɛy ifàsàsal anki udu a nkɔŋ yumwɛy. Ya yanswà ikyer asàbwabà. » ");
INSERT INTO yns_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yɛsu kàkäl aŋàbwaay u mɔŋ a in'te a ɔlive, kusà a ndwà a Nzam. Petɔlà, Zyak, Ywan anà Andrɛ bun'fuulà ukɔl naa: ");
INSERT INTO yns_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","« Isam, mpal nà ndaa ayi isàyà, idiim nà isàswaŋ naa indiir abi byanswà ikyer asàkwo. » ");
INSERT INTO yns_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Apan, Yɛsu kàsɛmà mutɛn a ba naa: « Làkäl kà igyɛɛŋ, mbuur twon amàlakur. ");
INSERT INTO yns_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ntɔn baar mbɔɔn bàsàyà kà ikɔb amɛ, waa bàsàtɛn naa: \"Wà mɛ\", waa ba bàsàkur baar mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mpal làsàwem bɛ làsaŋ a ità anà in'bää a ità, twon lan'man bɔɔmà: yubwaŋ naa bya itàyà, wɛɛ bya kà isàkal ntsüü anki. ");
INSERT INTO yns_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ntɔn un'sɛŋ mwɛy asànwaan a un'sɛŋ wumwɛy, imwol mwɛy a imwol kyumwɛy, kà ikal imwɛy imwɛy, mɛɛn ikyer asàtɛɛr, ngyal ikyer asàkal. Indiir abi byanswà byà nsɛmà a in'swaŋ. ");
INSERT INTO yns_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Làkäl kà igyɛɛŋ. Bàkyer asàlayälà u mbay a nsaŋ anà u ndwà a nköŋ a Ayudà, basàlakam iki, bɛ làsàkàsà in'lɔn kusà a amfum a itiir a mɛɛn anà kusà a amfum a nsi ntɔn mɛ: kya isàkal imbäl ntɔn ba. ");
INSERT INTO yns_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ntɔn Làsaŋ Aŋàbwaŋ bàkyer atàkyään la akà in'sɛŋ myanswà. ");
INSERT INTO yns_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mpal bàsàlasyen ntɔn mukàlayälà, twon lan'kyɛɛr kusà naa bɛ nkye làyàkàtɛn, wɛɛ ya bàsàlapà utaaŋ alan, làtɛn ya. Ntɔn kà bɛ anki làsàtwey mun, wɛɛ Dweelà Inkyɛɛl. ");
INSERT INTO yns_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Un'tɔŋ asàyälà un'tɔŋ ande ntɔn bun'dwä, taa asàyälà mwan ande, baan bàsàbɛy aböör aba, waa bàsatsüül ukwà. ");
INSERT INTO yns_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Baar banswà bàkyer asàlayiiŋ ntɔn ikɔb amɛ. Wɛɛ mbuur asàkaŋ mpem tii u ntsüü, asàwà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","« Mpal làsàman bɛ lingyoomà aŋàdiir lan'bwaay kà ikal mpa lan'kwo la mukal, - wɛy mbuur akataŋà uyöb! Apan, wɛy baar bàsàkal u Yuday, bàtiin uboo a myɔŋ, ");
INSERT INTO yns_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","wɛy mbuur asàkal udu a mpaan a ndwà, ukɔɔn asàtɔlà ntɔn muwal undiir u ndwà ande, ");
INSERT INTO yns_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","wɛy mbuur asàkal u ywaŋ, ukɔɔn afurà ndwà ntɔn mukàwal ipfɛy ande. ");
INSERT INTO yns_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ngyɛb akà akaar bàsàkal anà an'yöm anà akakaar bàsànüü ilä abin! ");
INSERT INTO yns_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Làyamà naa ndaa ayi ikɔ̈ɔ̈n asàyà u paŋà a làbe! ");
INSERT INTO yns_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ntɔn, ilä abin isàkal ilä a mpay aŋàdiir mpa aŋàtàman fà nsɛmà a mɛɛn kàkyer Nzam tii papanà, anà ya ifàsàkal anki akà ikikye. ");
INSERT INTO yns_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yàlàkal naa Mwol ukɔɔn atyey ilä abi, akà mbuur mwɛy mɔ̈ɔ̈ kàlàwà anki. Wɛɛ, ntɔn baar kàsɔ̈ɔ̈l nde, nde kàtyey ilà abi. ");
INSERT INTO yns_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Abun, isàkal naa mbuur kan'tɛn a bɛ naa: \"Le, Klistɔ awà kà!\" Itàkal naa: \"Le, awunà kunà!\", twon làmukyey. ");
INSERT INTO yns_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ntɔn Aklistɔ a loor anà aŋangɔɔm a loor bàkyer asàtoo, waa bàsàkyer idiim anà impà ntɔn mukur, itàkal sye baar aŋàsɔɔl, kya mbwo isàkal. ");
INSERT INTO yns_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Abun bɛ, bɛ làkäl kà igyɛɛŋ! Indiir abi byanswà mɛ kàkyàlaweey kusà. ");
INSERT INTO yns_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","« Wɛɛ kà ilä abin, ungö a mpay aŋàdiir ayin, taaŋ làsàbwà làpib, nsöŋ ufàsàpà anki kyɛɛy awa, ");
INSERT INTO yns_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mbwaar isàfà du waa isàbwà, ngwal a du ikyer asàni. ");
INSERT INTO yns_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Apan ba bàsàman Mwan a mbuur wàmuyà uboo a un'böŋ unsà ngwal mbɔɔn anà làkoo. ");
INSERT INTO yns_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Apan nde asàtɔm akyeey anà asàböbà baar kàsɔ̈ɔ̈l nde kà an'twɛrà man'nà, fà nswɛŋ a mɛɛn tii u nswɛŋ a du. ");
INSERT INTO yns_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","« Làyöb lwɛŋ lan'fà uboo a nsim a un'te a fige: an'kɔkà màsàbulà bɔɔlàbɔɔl, nkay isàfulà, bɛ lan'yöb naa un'tye wà tsütsü. ");
INSERT INTO yns_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Asànaa bɛ sye, mpal làsàman bɛ indiir abi byan'yà, làyöb naa Mwan a mbuur wà tsütsü u munàmbwo. ");
INSERT INTO yns_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ndandaa mɛ alàkyään: nkööl ayi isàlyaŋ anki kusà ndaa ayi yanswà mukwo. ");
INSERT INTO yns_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Du anà mɛɛn màkyer asàlyaaŋ, wɛɛ ndaa amɛ isàlyaaŋ anki akà ikikye. ");
INSERT INTO yns_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","« Wɛɛ ilä kya itàkal taaŋ la, akà mbuur mwɛy uyöb anki bya, itàkal akyeey a du, itàkal Mwan, akà mbuur mwɛy, nà Taa mpɛl. ");
INSERT INTO yns_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Làkäl kà igyɛɛŋ, làduub mii abɛ, ntɔn bɛ làyöb anki mpal nà ya isàkwo. ");
INSERT INTO yns_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ya isàkal asànaa mbuur mwɛy kan'kàlyaaŋ: nde an'sàwɛy ndwà ande, an'sàpà ikɔ̈b akà asyääl ande, mbuur mbuur anà isal ande, waa uswaŋ un'kyɛɛŋ a munàmbwo muduub mii. ");
INSERT INTO yns_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Lalan, làduub mii, ntɔn bɛ làyöb anki mpal usàyà nkum a ndwà, làsisye lɛɛ u mpöŋàmpöŋ, u mbeel a nkɔ lɛɛ u tutu, ");
INSERT INTO yns_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","manà nde uyà kà imbürà, waa kàlaman bàŋàbɔ̈ɔ̈n. ");
INSERT INTO yns_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ndaa in'tɛɛnà mɛ yi a bɛ, mɛ in'tɛɛnà a baar banswà: Làduub mii! » ");
INSERT INTO yns_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Byàsäl ilä ibyeel Pak anà un'kyɔm a mampà ikɔ̈ɔ̈n ful mukwo, amfum a angaŋ anà alɔɔŋ a in'kɔɔn bàleŋà impeenà mukɔr Yɛsu, waa bun'dwa. ");
INSERT INTO yns_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ntɔn ba bàtɛɛnà naa: « Kà uboo a un'kyɔm anki, manà lingyoomà layàbilà uboo a un'sɛŋ. » ");
INSERT INTO yns_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yɛsu kàkäl u Bɛtani u ndwà a Simɔn ŋabay, mpal kàkäl nde u mɛsà mudyà, un'kaar mwɛy kàyi anà làbuuŋ aŋàyɔl a may a usɔŋ a ndandaa màntal mbɔɔn. Nde kàduub la, waa kun'tsüül udu a un'tswe. ");
INSERT INTO yns_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Baar bumwɛy bàkäl paa bàmɛn ube, waa bàtɛɛnà ba a ba naa: « Ntɔn nkye mubi may a usɔŋ amà abà? ");
INSERT INTO yns_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yàlàbwaŋ naa bàyälà ma màŋàsɔ̈ɔ̈nà nkam tär yà itɛr a ngim, waa bàlàpà aŋàlàmbwà! » Ba bàpɛlà un'kaar awà. ");
INSERT INTO yns_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wɛɛ Yɛsu kàtɛn naa: « Lun'si a duu. Ntɔn nkye lun'paa bɛ mpay? Nde kan'kyer undiir aŋàbwaŋ akà mɛ. ");
INSERT INTO yns_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ntɔn aŋàlàmbwà bɛ làbà anà ba taaŋ lanswà, bɛ lan'kwo mukakyer ubwaŋ mpal làkwen bɛ, wɛɛ mɛ, mɛ anà bɛ watɛy taaŋ lanswà. ");
INSERT INTO yns_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Undiir kàkwen nde mukyer, nde kan'kyer wa: kusà nde kan'tsuul ndür amɛ may a usɔŋ ntɔn ndyee aya. ");
INSERT INTO yns_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ndandaa mɛ alàkyään, ntsü yanswà bàsàpay Làsaŋ Aŋàbwaŋ, u mɛɛn manswà, bàsataa ndaa kan'kyer un'kaar wà ntɔn muyɔbà mɔ̈ɔ̈ ande. » ");
INSERT INTO yns_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yudas Iskaryɔt, umwɛy uboo a alɔŋki Kwem Aŋiyweel, kàkyen akà amfum a angaŋ ntɔn mukàyàlà Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ba bàkäl kà un'sak ntɔn làsaŋ alan. Ba bàdirà mukun'pà ngim. Apan nde kàleŋà ipöl aŋàbwaŋ mukun'yälà. ");
INSERT INTO yns_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ilä atàtwɛb kyà mampà ikɔ̈ɔ̈n ful, ilä bàfàdwa in'tö a in'kɔk ntɔn isaa a Pak, alɔŋki a Yɛsu ban'tɛn a nde naa: « Ikal nà ngye akwen bi ikàyilà ntɔn ngye akàdyà Pak? » ");
INSERT INTO yns_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Apan Yɛsu kàtöm alɔŋki ande bɔ̈ɔ̈l, waa kàtɛn a ba naa: « Làkyen u bul a kölàköl, bɛ làkàman baal mwɛy we anà làbuuŋ a an'dà ayàmɛɛn anà bɛ, lun'läb. ");
INSERT INTO yns_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ikal kyanswà ukàbilà nde, làtɛn akà ŋàndwà naa: \"Un'lɔɔŋ kan'tɛn naa: Làken suk in'dyà mɛ Pak anà alɔŋki amɛ?\" ");
INSERT INTO yns_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nde akàlaswaŋ suk a du làkölàköl làŋakwo anà indiir byanswà. Ngiil ntɔn bi, bɛ làkàkyer kwo. » ");
INSERT INTO yns_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Alɔŋki bàkyen ba, bàtɔ̈l ba u bul a kölàköl, ba bàmɛn asànaa kàtɛn nde a ba, waa bàyöŋà Pak. ");
INSERT INTO yns_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mpal làbü sisye, Yɛsu kàyi anà Bàkwem Aŋiyweel. ");
INSERT INTO yns_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Umpal bàkäl ba u mɛsà bàmudyà, nde kàtɛn naa: « Ndandaa mɛ alàkyään, umwɛy uboo a bɛ awàmudyà anà mɛ, akyer ayan'yälà. » ");
INSERT INTO yns_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Alɔŋki bàmɛn ngyɛb mbɔɔn, waa bàsɛmà mukun'fuul umwɛy umwɛy: « Nkye an'kwo ikäl mɛ? » ");
INSERT INTO yns_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nde kàtɛn a ba naa: « Umwɛy uboo a Bàkwem Aŋiyweel, kan'dümà kɔɔ ande mbwo mwɛy anà mɛ uboo làlɔŋà. ");
INSERT INTO yns_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ntɔn Mwan a mbuur akyer akyà asànaa bàsön ya ntɔn nde, wɛɛ ngyɛb akà mbuur ban'yälà Mwan a mbuur u mbwo a nde! Yàlàkal ubwaŋ mbɔɔn akà nde naa bàkɔɔn un'bɔr! » ");
INSERT INTO yns_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Utaaŋ adyà, Yɛsu kàwɛl mampà, ungö musaak ma, nde kàtsül ma, waa kapɛ, waa kàtɛn naa: « Làwɛl, ayi yà ndür amɛ. » ");
INSERT INTO yns_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Waa kàwɛl kɔɔb, ungö mufuur an'tɔɔn, nde kapɛ la, waa ba banswà bànü unsà la. ");
INSERT INTO yns_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yɛsu kàtɛn a ba naa: « Amà an'kil amɛ, an'kil a nkwà màtyaŋà ntɔn bàmbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ndandaa mɛ alàkyään: mɛ in'fàsànwà anki akà ikikye vin tii ilä in'sànwà mɛ vin akün kà imwol a Nzam. » ");
INSERT INTO yns_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ungö mutɔɔl an'diim, ba bàtoo ntɔn mukyà mɔŋ a in'te a Ɔlive. ");
INSERT INTO yns_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yɛsu kàtɛn a ba naa: « Bɛ, bɛ banswà làkyer asan'kɔɔb, ntɔn bàsön naa: \"Mɛ in'sàdwa un'kyɛɛŋ, waa in'kɔk isàtà upay.\" ");
INSERT INTO yns_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wɛɛ mɛ, ungö a ngwiiyà, mɛ in'sàfweel kusà a bɛ u Ngalilɛ. » ");
INSERT INTO yns_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petɔlà kàtɛn a nde naa: « Itàkal naa baar banswà bàmakɔɔb, wɛɛ mɛ, mɛ in'sakɔɔb anki. » ");
INSERT INTO yns_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yɛsu waa utɛn a nde naa: « Ndandaa mɛ akyään: ŋàbawà, mpib nsil ayi, kusà nkɔɔ mubel mbalà yweel, ngye, ngye ayan'tɔn mbalà tär. » ");
INSERT INTO yns_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wɛɛ nde, nde kàfàfuur a ngwal: « Mɛ, itàkal naa mɛ in'kyer akwà anà ngye, aay, mɛ ngye in'satɔn tɛy. » Ba banswà bàkäl mun mwɛy wa. ");
INSERT INTO yns_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Apan ba bàyàkɔlà kà ikal mwɛy bàfàbel naa Ngɛtɛsɛmani, Yɛsu waa kàtɛn a alɔŋki ande naa: « Sàlàbwaay pà, umpal in'kàyamà mɛ. » ");
INSERT INTO yns_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ungö nde kàsyen Petɔlà, Yakɔb anà Ywan. Apan nde kàsɛmà muwem matɛɛr anà ngyɛb mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nde kàtɛn a ba naa: « Mɔ̈ɔ̈ amɛ wàŋàyɔl a ngyɛb yan'kwo mudwa. Sàlasäl pà, làkyɛŋ. » ");
INSERT INTO yns_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nde kàkyen u kikwɛl, waa kàbü an'köm, kàyamà naa kya mbwo isàkal, taaŋ alà làlyaaŋ ukwɛl apà nde. ");
INSERT INTO yns_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nde kàtɛɛnà naa: « Taa, indiir byanswà akà ngye ikyer afàkwo, lwom kɔɔb a mpay aŋàkir là apà mɛ. Itàkal abwɛy, kà ndaa in'kwen mɛ anki, wɛɛ ayan'kwen ngye. » ");
INSERT INTO yns_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ungö apan nde kan'yà, kan'man ba bàŋàbɔ̈ɔ̈n, waa kan'tɛn a Petɔlà: « Simɔn, ngye an'bɔ̈ɔ̈n? Nkye ngye asàkal anki anà ngwal mukyɛŋ itàkal akà taaŋ làmwɛy? ");
INSERT INTO yns_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Làkyɛŋ, làyamà, ntɔn bɛ làkɔ̈ɔ̈n abwà u ndɛb. Dweelà làŋàyɔl a ngwal, wɛɛ ndür ye anà gyɔ̈ɔ̈là. » ");
INSERT INTO yns_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nde kàfàkyà u kikwɛl, waa kàyamà wàmufuur ndaa nsil ya. ");
INSERT INTO yns_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Apan, nde kàyi mbalà asin, waa kàfaman bàmubɔ̈ɔ̈n, ntɔn mii aba myàkäl myàŋàbwà buur. Ba waa mpa bàyöb naa bun'fuur aben. ");
INSERT INTO yns_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","U mbalà yàtär kan'yà nde, nde kan'tɛn a ba naa: « Làläb mubɔ̈ɔ̈n, làyöör. Yan'wà! Taaŋ lan'kwo: le, Mwan a mbuur bàmuyälà kà an'kɔɔ a baar abe. ");
INSERT INTO yns_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Làmbarà, tsweenà! Làler, mbuur kàman'yälà wà tsütsü. » ");
INSERT INTO yns_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Umpal kàkäl nde muyäämà, Yudasi, umwɛy uboo a Bàkwem Aŋiyweel, kàyàkɔlà anà iköŋ a baar mbɔɔn bàtöm andweer a angaŋ anà andweer a un'sɛŋ. Ba bàkäl anà an'kɔm anà nköl. ");
INSERT INTO yns_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mbuur kun'yälà, kapɛ idiim ki: « Mbuur wanswà in'kàböbà mɛ, mbuur wa nde awun. Lun'kör, lun'syen unsà ikyɛɛŋ. » ");
INSERT INTO yns_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pa kàyàkɔlà nde, nde kàsin apà Yɛsu, waa kàtɛn a nde naa: « Un'lɔɔŋ! » Waa kun'böbà. ");
INSERT INTO yns_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Apan bumwɛy bun'tɛ mpi, waa bun'kör. ");
INSERT INTO yns_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Umwɛy uboo a baar bàkäl paa, kàtwey kɔm, waa kàkäm un'syääl a Mfum a angaŋ, waa kun'tsül tsü. ");
INSERT INTO yns_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yɛsu kàtɛn a ba naa: « Nkye mɛ in'wà un'dwää baar waa bɛ làyi anà an'kɔm anà nköl ntɔn mukan'kɔr? ");
INSERT INTO yns_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mɛ kàkäl anà bɛ u ndwà a Nzam ilä byanswà mulɔŋ, bɛ làsan'kɔr anki. Wɛɛ ayi yan'yà ntɔn Ndaa Aŋàsɔn ikwe. » ");
INSERT INTO yns_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Apan ba banswà bàsun'wɛy, waa bàtiin. ");
INSERT INTO yns_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mwan baal mwɛy wàŋàbwaar làpye làmwɛy mpɛl waa kàyun'labà. Waa bun'kör, ");
INSERT INTO yns_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wɛɛ nde kàsàpiy làpye alan, waa kàtiin wànsàpɔl. ");
INSERT INTO yns_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ba bàsyen Yɛsu akà mfum a angaŋ, ikal bàköŋ amfum a angaŋ bànswà, andweer anà alɔɔŋ a in'kɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petɔlà kàyilabà Yɛsu ukwel tii uboo a làpaŋ, u làbay a ndwà a mfum a angaŋ. Nde kàbwaay anà aŋità muywar mbaa. ");
INSERT INTO yns_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kyekà andweer a angaŋ anà Làbay a nsaŋ a kölàköl bàkäl muleŋ imbäl a loor ntɔn Yɛsu ntɔn bun'dwä, wɛɛ ba kya bàmɛnà anki. ");
INSERT INTO yns_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ntɔn bàmbɔɔn bàtɛɛ imbäl a loor ntɔn nde, wɛɛ bya byàkyeena anki balàbal. ");
INSERT INTO yns_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Baar amwɛy waa bàyàmbarà, waa bàyataa loor ntɔn nde naa: ");
INSERT INTO yns_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","« Bi kàwem nde wàmutɛn naa: \"Mɛ in'yàbwaab ndwà a Nzam bàtöŋ yi kàn'kɔɔ a baar, wɛɛ ungö a ilä itär mɛ in'yàtɔŋ yàsin mpa bàkyer kan'kɔɔ a baar.\" » ");
INSERT INTO yns_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wɛɛ, itàkal abà, imbäl aba kyàkwe anki balàbal. ");
INSERT INTO yns_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Apan Mfum a angaŋ kàmbarà nde uboo a nköŋ, nde kàfuul Yɛsu naa: « Nkye ngye afuur anki akà undiir mwɛy unsà imbäl bàtaa baar bà ntɔn ngye? » ");
INSERT INTO yns_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wɛɛ Yɛsu kàkäl akul, waa mpa kàfuur akà ikikye. Mfum a angaŋ kun'fuul mbalà asin: « Nkye ngye awà Klistɔ, Mwan a Nzam aŋàsaak? » ");
INSERT INTO yns_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yɛsu waa kàfuur naa: « Mɛ in'wà nde, bɛ làsàman Mwan a mbuur waŋàbwaay u kɔɔ ibaal a Ŋangwal, wàmuyà uboo in'böŋ a du. » ");
INSERT INTO yns_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Apan, Mfum a angaŋ kàkaam ipfɛy ande, waa kàtɛn naa: « Bi ambäl nkye ifàkyer abà! ");
INSERT INTO yns_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bɛ lan'wem mbɛɛy. Bɛ lan'tɛn aben? » Ba banswà bun'tsüül mbar a ukwà. ");
INSERT INTO yns_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bamwɛy uboo a ba bun'tsüülà an'te, bun'fwee ntabwey, bun'kämà iki, waa bàtɛɛnà a nde naa: « Tà ngɔɔm! » Aseey waa bun'yab a mbar. ");
INSERT INTO yns_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petɔlà kàkäl u ngyɛl uboo a làpaŋ umpal kàyi un'syääl mwɛy wun'kaar wà mfum a angaŋ, ");
INSERT INTO yns_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","nde kàmɛn Petɔlà wàmuywar mbaa, nde kun'syebà, waa kàtɛn a nde naa: « Ngye sye, ngye kàkäl anà Yɛsu un'nsi Nasàlɛr. » ");
INSERT INTO yns_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wɛɛ nde kàkyer atɔn, waa kàtɛn naa: « Mɛ in'yöb anki. Mɛ in'yöb anki naa ngye nkye akwen mutɛn. » Ungö, waa kàtoo u nsà mukyà ikal bàfabilà.  Apan nkɔɔ waa kàbel.  ");
INSERT INTO yns_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Un'syääl wun'kaar kun'mɛn nde, waa kàfàtɛn a baar bàkäl paa naa: « Mbuur wà, wà umwɛy uboo a ba! » ");
INSERT INTO yns_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wɛɛ nde waa kàfàtɔn. Ungö apan, baar bàkäl paa bàfàtɛn a Petɔlà naa: « Ndandaa, ngye awà umwɛy uboo a ba, ntɔn ngye, ngye awà un'nsi Ngalilɛ. » ");
INSERT INTO yns_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wɛɛ nde kàsɛmà mudyà kyän anà musà in'küül: « Mɛ un'yöb anki mbuur lan'saamà bɛ. » ");
INSERT INTO yns_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Utaaŋ nsil alan, nkɔɔ mwɛy waa kàbel u mbalà yàyweel, apan Petɔlà kàyɔbà ndaa kun'kyään Yɛsu: « Kusà nkɔɔ mutàbel mbalà yweel, ngye ayan'tɔn mbalà tär. » Apan, nde kàtoo u ntiin, waa kàlel. ");
INSERT INTO yns_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","U tutu tutu, amfum a angaŋ bàköŋ anà andweer, anà alɔɔŋ a in'kɔɔn anà Làbay a nsaŋ làkölàköl lanswà. Ba bàbäm Yɛsu in'siŋ, bun'syen anà bun'pɛ akà Pilatu. ");
INSERT INTO yns_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatu waa kun'fuul naa: « Nkye ngye awà mfum a Ayudà? » Yɛsu waa kun'fuur naa: « Ngye ŋàkwo an'tɛn. » ");
INSERT INTO yns_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Amfum a angaŋ bun'füünà indiir mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatu kàfun'fuulà naa: « Nkye ngye ndaa afuur anki akà ikikye? Ngye akiweemà indiir mbɔɔn bàfüünà ba ngye! » ");
INSERT INTO yns_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wɛɛ Yɛsu kàsàfuur anki akà ndaa mwɛy, abun Pilatu waa kàbem. ");
INSERT INTO yns_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kà un'kyɔm wanswà, Pilatu kàkäl anà nkääl mutsuuŋ mbuur a bɔlokà mwɛy, mbuur kàlɔ̈ɔ̈mà un'sɛŋ. ");
INSERT INTO yns_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kyekà mbuur mwɛy ikɔb ande Barabas kàkäl u bɔlokà anà aŋàlingyoomà abà bàdwä mbuur umpal làbü lingyoomà. ");
INSERT INTO yns_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Un'sɛŋ a baar kàbeenà, waa kàsɛmà mukun'lɔ̈ɔ̈m naa nde kapɛ asànaa nkääl ande. ");
INSERT INTO yns_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatu kàfuul naa: « Nkye bɛ làkyàkwen mɛ alàwɛɛy mfum a Ayudà? » ");
INSERT INTO yns_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ntɔn nde kàkyer ayöb naa ba Yɛsu bun'yälà ntɔn un'köl aba. ");
INSERT INTO yns_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wɛɛ amfum a angaŋ bàsiinà un'sɛŋ ntɔn Pilatu katsuuŋ awà Barabas. ");
INSERT INTO yns_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatu kàfàtɛn a ba naa: « Abun bɛ làkwen naa mɛ nkye in'kyer anà mbuur làfàbel bɛ mfum a Ayudà? » ");
INSERT INTO yns_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ba bàfàsà in'kwɛŋ: « Un'bɛɛrà u kulunsi! » ");
INSERT INTO yns_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatu kàtɛɛnà a ba naa: « Ube nà nde kàkyer bà? » Wɛɛ ba bàsöönà musà in'kwɛŋ: « Un'bɛɛrà u kulunsi! » ");
INSERT INTO yns_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatu kàkwen mupà un'sɛŋ un'sak, waa katsuuŋ Barabas. Apan nde kàswɛŋ naa bàkäm Yɛsu an'füm, waa kun'yälà ntɔn bun'bɛɛrà u kulunsi. ");
INSERT INTO yns_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aŋità bàsyen Yɛsu uboo a làpaŋ a kuvɛrnɔ̈ɔ̈r u pɛlàtwal, waa bàbel làböl lanswà. ");
INSERT INTO yns_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ba bun'bwää kàzak a tsöö, waa bun'tɔ̈ɔ̈l mpà a nsyeenà bàtöŋ ba kun'tswe. ");
INSERT INTO yns_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ba bàsɛmà mukun'pà mbɔr naa: « Mbɔr, mfum a Ayudà! » ");
INSERT INTO yns_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ba bun'kämà un'bii kun'tswe, bun'tsüülà an'te, anà bàbwee an'köm kusà ande ntɔn mukömà. ");
INSERT INTO yns_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ungö amukun'sɛɛ, ba bun'lwom kàzak a tsöö, waa bun'fuur ipfɛy ande. Apan ba bun'twey u nsà a bul ntɔn bàkun'bɛɛrà u kulunsi. ");
INSERT INTO yns_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mbuur mwɛy, ikɔb ande Simɔn, un'nsi Sirɛn, taar a Alɛksandre anà Rufus, kàfü ndwaŋ, anà kàkäl mulyaaŋ. Aŋità bun'siinà a ngwal musyen kulunsi. ");
INSERT INTO yns_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ba bàsyen Yɛsu kà ikäl mwɛy ikɔb a kya Ngɔlàngɔta, ikaswaŋà naa: « Ikal a köl a un'tswe. » ");
INSERT INTO yns_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ba bun'pɛɛ vin aŋàtüüb a dyam, wɛɛ Yɛsu kàtön munwà la. ");
INSERT INTO yns_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ungö bun'bɛɛrà ba u kulunsi, ba bàkäbà ipfɛy ande, waa bàtɛɛ löb ntɔn muyöb naa mbuur mbuur ininà uwal. ");
INSERT INTO yns_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ba bun'bɛɛrà u kulunsi u taaŋ làwà làtutu. ");
INSERT INTO yns_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Isin a ndaa bàsön muswaŋ ntsüül a ukwà ande yàkäl abà: « Mfum a Ayudà. » ");
INSERT INTO yns_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ba bàbɛɛrà sye baar abe abɔ̈ɔ̈l u bikulunsi ukɔl a Yɛsu, mwɛy u kɔɔ ande là ibaal, umwɛy u kɔɔ ande là ikaar.  ");
INSERT INTO yns_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Apan itiir a Ndaa Aŋàsɔn yi laa kyàkwe kya: « Nde bun'täŋ unsà ulwaŋ a baar abe. »  ");
INSERT INTO yns_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Baar bàlyaaŋà u mbwo bun'töö, bànii in'tswe, waa bàtɛɛnà naa: « Imbye itàkal ngye atàman! Ngye awee naa abwiy ndwà a Nzam, waa afàtɔŋ ya kà ilä itär, ");
INSERT INTO yns_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","tswà mɔ̈ɔ̈ angye, ngye ŋankwo, tɔlà u kulunsi! » ");
INSERT INTO yns_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Amfum a angaŋ anà alɔɔŋ a in'kɔɔn bàsɛɛ, ba a ba, waa bàtɛɛnà naa: « Nde kàtsü baar asin mɔ̈ɔ̈, wɛɛ nde ukwe anki mutswà mɔ̈ɔ̈ nde ŋakwo! ");
INSERT INTO yns_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wɛy Klistɔ, mfum a Isàlɛl utɔlà apanà u kulunsi, waa bi iman, waa bi isà làkwikilà! » Baar bàbɛɛrà u kulunsi mbwo mwɛy anà nde, bun'töö sye. ");
INSERT INTO yns_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","U midi làpib làkyer abwà u mɛɛn manswà tii u taaŋ làtär ungö a midi. ");
INSERT INTO yns_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Apan, u taaŋ làtär, Yɛsu kàsi un'kwɛŋ a ngwal: « Ɛlɔyi, Ɛlɔyi, lɛma sabaktani? » Ikaswaŋà naa: « Nzam a mɛ, Nzam a mɛ, ntɔn nkye aman'wɛy ngye? » - ");
INSERT INTO yns_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bamwɛy uboo a baar bàkäl paa bun'weemà ba, waa bàtɛɛnà naa: « Làwem, nde kan'bel Ɛli! » ");
INSERT INTO yns_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mbuur mwɛy kàkaamà ntiin, kànwɛmà ikaam a ipfɛy unsà vin a nkyään, nde kàbäm kya u nswɛŋ a un'bii, waa kàsilà kya akà Yɛsu ntɔn nde unü, wàmutɛn naa: « Làdil, bi iler naa nkye Ɛli akyun'tɔɔl u kulunsi! » ");
INSERT INTO yns_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wɛɛ Yɛsu kàsi un'kwɛŋ a ngwal, waa un'swey kàtoo. ");
INSERT INTO yns_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Rido a idwà làkaamà itiir byeel fà du tii u ngyɛl. ");
INSERT INTO yns_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kaptɛn kàkäl paa kusà a nde, mpal kàmɛn nde naa nde kàkü aben, waa kàtɛn naa: « Ndandaa mbuur wà kàkäl Mwan a Nzam! » ");
INSERT INTO yns_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bàkäl anà akaar amwɛy sye bàleerà ukwɛl. Uboo a ba, bàkäl Màlye un'nsi Magàdala, Màlye ngwän a Zyak Un'kye, anà Yɔsɛ, anà Salɔmɛ. ");
INSERT INTO yns_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ba bàkäl akaar bàyun'labà anà bàyun'syäälà mpal kàkäl nde u Ngalilɛ, anà akaar asin mbɔɔn bàbeenà Yɛlusàlɛm anà nde. ");
INSERT INTO yns_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sisye làkäl aŋàbwà, kya kyàkal ilä ayöŋà, iswaŋà naa ilä kyàfweel saba, ");
INSERT INTO yns_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","un'byääl mwɛy wà làbay a nsaŋ, Yɔsɛfi un'nsi Alimatɛ, kàyàkɔlà paa. Nde sye kàfadilà Imwol a Nzam. Nde kàwɛl ibaal mukyà akà Pilatu ntɔn mulɔm ndom a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatu kàbem muwem naa nde abwà akwà. Nde kàbel kaptɛn, waa kun'fuul naa nkye nde kàkü itaan. ");
INSERT INTO yns_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ungö kàyöb nde u mbwo a kaptɛn, nde kàpɛ mbwo akà Yɔsefi muwal ndom. ");
INSERT INTO yns_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ungö musom làpye a pɛɛl, nde kàtɔɔl ndom u kulunsi, kàläl ya uboo a làpye, kàsi ya kà an'dii bàfuun uboo a nkɔŋ, waa kàbuum nkɔŋ a kölàköl ntɔn mudübà an'dii. ");
INSERT INTO yns_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Màlye un'nsi Magàdalà anà Màlye ngwän a Yɔsɛ bàleerà ikal basi ndom. ");
INSERT INTO yns_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ungö ilä a saba, Màlye un'nsi Magàdalà, anà Sàlomɛ anà Màlye ngwän a Zyak, bàsöm may a usɔŋ ntɔn mumwaŋ u ndür a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ilä atàtwɛb kyà mpɔsà, ba bàkyen an'dii u tutu, mpal làsɛnà taaŋ. ");
INSERT INTO yns_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ba bàtɛɛnà ba a ba naa: « Nà akà ibuum nkɔŋ yinà u mun a an'dii? » ");
INSERT INTO yns_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wɛɛ umpal bàler ba, ba bàmɛn naa nkɔŋ yàkäl aŋàbuum ukɔl. ");
INSERT INTO yns_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ba bàbilà uboo a an'dii, bàmɛn un'tö mwɛy wàŋàbwaay u kɔɔ ibaal, akyàbwaar mvwɛl a pɛɛl. Matɛɛr waa mawɛl. ");
INSERT INTO yns_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wɛɛ nde kàtɛn a ba naa: « Twon lan'man bɔɔmà, bɛ làwàmuleŋ Yɛsu un'nsi Nasàlɛr awà bàbɛɛrà u kulunsi. Nde akyàwiyà, nde ufàkal anki apà. Làler ikal bun'tɔ̈ɔ̈l. ");
INSERT INTO yns_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wɛɛ làkyen kàlakyään alɔŋki ande, anà Petɔlà sye, naa: \"Nde amàkaladil u Ngalilɛ. Bɛ làyàkun'man kwo, asànaa kàlakyään nde.\" » ");
INSERT INTO yns_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Apan, ba bàtoo, waa bàtiin ukwɛl a an'dii, ntɔn matɛɛr anà lingyoomà màkyer awal. Ba bàkyään anki itàkal undiir mwɛy akà mbuur umwɛy, ntɔn ba bàkäl u bɔɔmà. ");
INSERT INTO yns_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ungö a ngwiiyà ande kà ilä atàtwɛb kyà mpɔsà u tutu, Yɛsu kàtwab akàmɛnà akà Màlye un'nsi Magàdalà awà kàböŋ nde an'dwelà an'be, an'dweelà nsambwaar. ");
INSERT INTO yns_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nde kàkàkyään ndaa ayi akà baar bàkälà anà nde. Ba bàkälà u ngyɛb anà mulelà. ");
INSERT INTO yns_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wɛɛ mpal bàwem ba nde wàmutɛɛnà naa: « Yɛsu wà anà mɔ̈ɔ̈, mɛ in'kyun'man! », ba bun'si anki làkwikilà. ");
INSERT INTO yns_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ungö apan, Yɛsu kàkàmɛnà ifà asin akalɔŋki abɔ̈ɔ̈l bàkäl u mbwo mukyà ndwaŋ. ");
INSERT INTO yns_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ba bàyàfurà, waa bàkyään ya akà bumwɛy. Wɛɛ ba, ba sye basi anki làkwikilà. ");
INSERT INTO yns_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ungö apan, Yɛsu kàkàmɛnà akà Bàkwem Aŋimwɛy umpal bàkäl ba mudyà, waa kapɛl ntɔn bàkɔ̈ɔ̈n ba làkwikilà anà ntɔn bwoor a mpem aba bàtön ba mukyey baar bun'mɛn wàŋàwiyà. ");
INSERT INTO yns_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nde waa kàtɛn a ba naa: « Làkyen u mɛɛn manswà mukyään Làsaŋ Aŋàbwaŋ akà nkyeer yanswà. ");
INSERT INTO yns_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mbuur asàsà làkwikilà anà asàwal ndüümà, nde asàwà mɔ̈ɔ̈, wɛɛ mbuur mpa asàsà làkwikilà, nde bàsun'tsüül mbar. ");
INSERT INTO yns_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Làler idiim isaswaŋà naa baar bà bàkyàsà làkwikilà: Kà ikɔb amɛ ba bàsàböŋ insɔŋà, ba bàsàtɛn ndaa a kün, ");
INSERT INTO yns_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ba bàsàtà ntäy mpi kà an'kɔɔ, bàsànwà ipöm, wɛɛ kyà ube isakyer anki, ba bàsàsà abɛy an'kɔɔ, waa ba bàsàkɔɔrà. » ");
INSERT INTO yns_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Abun, ungö muyäm anà ba, Mwol Yɛsu bun'syen du, waa kàbwaay u kɔɔ a Nzam là ibaal. ");
INSERT INTO yns_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wɛɛ akà ba, ba bàkyen mukàkyään Làsaŋ Aŋàbwaŋ u mɛɛn manswà. Mwol kàsälà anà ba, waa kàtää imbäl u mbwo a idiim a impà kàkyerà nde muswaŋ naa an'lɔɔŋ aba mà ndandaa.");
INSERT INTO yns_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Un'sam Tyɔfil. Baar mbɔɔn bàbön musɔn ndaa yàlyaaŋ uboo a bi. ");
INSERT INTO yns_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ba ya bàsön asànaa bàkyään baar bàmɛn ya u mii fà nsɛmà anà bàbulà asyääl a ndaa a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Lalan mɛ sye kàläb mɛ ndaa ayi pànsi pànsi fà nsɛmà aya. Un'byääl Tyɔfil, yubwaŋ naa mɛ asöön ndaa ayi. ");
INSERT INTO yns_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","In'kyer mɛ abà ntɔn ngye ayöb naa an'lɔɔŋ kàwɛl ngye mà ndandaa. ");
INSERT INTO yns_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mpal kàkäl Ɛlɔdi mfum a Yuday, kàkäl anà ngaŋ mwɛy wà itsuŋ a angaŋ a Abya ikɔb ande Zakàlye. Un'kyay ande, mbuur a mbil a Alɔn, ikɔb ande Làsàbɛr. ");
INSERT INTO yns_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ba bàbɔ̈ɔ̈l bàkäl baar a balàbal u mii a Nzam. Ba bàfalabà ubwaŋàbwaŋ in'kɔɔn myanswà anà nswɛɛŋ yanswà yà Mwol. ");
INSERT INTO yns_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wɛɛ ba bàkäl anki anà baan ntɔn Làsàbɛr kàbör anki, ba bàbɔ̈ɔ̈l bàkäl aŋànün. ");
INSERT INTO yns_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ilä mwɛy, Zakàlye kàkäl musal ingaŋ ande kusa a Nzam, ntɔn la làkäl taaŋ a itsuŋ aba musal. ");
INSERT INTO yns_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mulab nsyääl a angaŋ, löb làbü akà nde ntɔn mubilà uboo a idwà a Mwol ntɔn musà tswà mbaa kwo. ");
INSERT INTO yns_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Umpal musà tswà mbaa, un'sɛŋ a baar wanswà kàkäl u nsà muyamà. ");
INSERT INTO yns_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kà imbürà, un'kyeey a Mwol mwɛy kàyàmɛnà akà Zakàlye: nde kàmbär u kɔɔ a ibaal a mɛsà a tswà. ");
INSERT INTO yns_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mpal kàmɛn Zakàlye un'kyeey awà, lileŋ làkyer un'wal, bɔɔmà làkyer un'kaar. ");
INSERT INTO yns_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wɛɛ un'kyeey kàtɛn a nde naa: « Zakàlye, twon an'man bɔɔmà, ntɔn Nzam akyàwem ngyamàkà angye: un'kyay angye Làsàbɛr ayaböör mwan baal. Ngye ayun'pà ikɔb a Ywan. ");
INSERT INTO yns_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nde asàkal ntwà a un'sak mbɔɔn ntɔn ngye. Baar mbɔɔn sye bàsàman un'sak ntɔn mböör ande. ");
INSERT INTO yns_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ntɔn nde asàkal mbuur a kölàköl u mii a Mwol. Nde usanwaa anki vin, itàkal man manswà bàfàyɔr. Nde asàkal aŋàyɔl a Dweelà In'kyɛɛl sɛmà dum a ngwän. ");
INSERT INTO yns_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nde asàfuur baan a Isàlɛl mbɔɔn akà Mwol awà Nzam aba. ");
INSERT INTO yns_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nde isal ande asàkyer u dweelà anà u ngwal asànaa ŋangɔɔm Ɛlya, ntɔn mutüüb bàtaa anà baan aba, mufuur baar a un'tswe ngwal muyweer asànaa baar a balàbal. Nde asàboom un'sɛŋ aŋàlɔ̈ɔ̈n ntɔn Mwol. » ");
INSERT INTO yns_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakàlye kàtɛn a un'kyeey naa: « Mɛ ya in'yàyöb aben? Ntɔn mɛ in'wà un'nün anà umpal ayi un'kyay amɛ sye wàŋànün. » ");
INSERT INTO yns_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Un'kyeey kun'fuur naa: « Mɛ, mɛ in'wà Ngàbàlye. Mɛ in'fàkal tsütsü apà Nzam, nde kan'töm muyäm anà ngye anà mukakyään ndaa aŋàbwaŋ ayi. ");
INSERT INTO yns_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Le, ngye ayàbulà nkiin, ngye ayàkwo anki musà ndaa tii mpal isàkwo ndaa ayi, ntɔn ngye ndaa amɛ akyey anki. Ndaa ayi isàmɛnà umpal ya paa. » ");
INSERT INTO yns_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Umpal ayin, baar banswà bàkäl mudilà Zakàlye u nsà, bàmukabemà naa nde kan'kàkyer itaan uboo a idwà. ");
INSERT INTO yns_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wɛɛ mpal kàyàtoo nde, nde kàkwe anki muyäm anà ba, apan ba waa bàyöb naa nde kan'man impà kà idwà. Muyäm a ba, nde kàyaswaŋà mpin, mun kàkälà wàŋàdübà. ");
INSERT INTO yns_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Umpal kàmay nde ilä a isal ande u ndwà a Nzam, nde kàfurà ndwà ande. ");
INSERT INTO yns_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ungö a ilä, un'kyay ande Làsàbɛr kàkäl yöm. Apan nde kàkàyee ngɔn tyeen. Nde kàtɛɛnà naa: ");
INSERT INTO yns_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","« Abà ubwaŋ a Mwol kan'kyer nde akà mɛ: ŋàbawà nde kan'tɔɔm ileer ande udu a mɛ ntɔn mulwom nswɛn amɛ u mii a baar banswà. » ");
INSERT INTO yns_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","U ngɔn wàsyaam, Nzam kàtöm un'kyeey Ngàbàlye u bul mwɛy là Ngalilɛ ikɔb a la Nasàlɛr, ");
INSERT INTO yns_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","akà mwan un'kaar unkɔr awà kàtɛ Yɔsefi mbuur a mbil a David ntüüm, ikɔb ande Màlye. ");
INSERT INTO yns_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Un'kyeey kàbilà u ndwà ande waa kàtɛn naa: « Mbɔr angye, Mwol kan'swaŋ ubwaŋ ande mbɔɔn akà ngye, nde wà anà ngye. » ");
INSERT INTO yns_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Màlye kàmɛn ndaa yubem, waa kàyayweerà naa mbɔr ayi ikaswaŋà aben. ");
INSERT INTO yns_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Apan, Un'kyeey kàtɛn a nde naa: « Màlye, twon an'man bɔɔmà, ntɔn Nzam kàmaswaŋ ukwen ande banswà. ");
INSERT INTO yns_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Le, ngye ayàkal yöm, ngye ayàbɔr mwan baal, ngye ayun'pà ikɔb a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nde asàkal mbuur a kölàköl, bàsun'beelà Mwan a Nzam a Dudu. Mwol Nzam asun'sà u kir a imfum a nkaa ande David. ");
INSERT INTO yns_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nde asàyaal ipepey u ndwà a Yakɔb, imwol ande sye isàtsü anki. » ");
INSERT INTO yns_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Màlye waa kàtɛn a un'kyeey naa: « Ya abwɛy iyàkal aben ntɔn mɛ ŋàtàkal anki anà baal? » ");
INSERT INTO yns_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Un'kyeey kun'fuur naa: « Dweelà In'kyɛɛl ayàkal udu angye, ngwal a Nzam a Dudu ikyer ayafwee asànaa kilàpib. Lalan mwan in'kyɛɛl ayàbɔr ngye bàsun'beelà Mwan a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Le, un'tɔŋ angye Làsàbɛr sye we anà yöm a mwan baal unsà inün ande. Bàfatɛɛnà naa nde wà ikɔb, wɛɛ ŋàbawà yöm ande là u ngɔn wàsyaam. ");
INSERT INTO yns_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ntɔn undiir kan'kwo mukɔ̈ɔ̈n Nzam watɛy. » ");
INSERT INTO yns_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Apan Màlye kàfuur naa: « Mɛ in'wà un'tsüüŋ a Mwol. Wɛy ndaa yanswà an'tɛn ngye ikäl abwɛy. » Un'kyeey waa kàsun'wɛy. ");
INSERT INTO yns_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ungö apan, Màlye kàkyen agyägyä u bul mwɛy udu a mɔŋ u mɛɛn a Yuday. ");
INSERT INTO yns_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nde kàbilà u ndwà a Zakàlye, waa kàpɛ Làsàbɛr mbɔr. ");
INSERT INTO yns_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kyekà, umpal kàwem Làsàbɛr mbɔr a Màlye, mwan kànini uboo a an'bäl ande. Làsàbɛr kàyöl a Dweelà In'kyɛɛl, ");
INSERT INTO yns_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","waa kàsi in'kwɛŋ: « Nzam kàkyapà làpɛɛm aŋàsöönà akaar banswà, mwan ayàbɔr ngye we anà làpɛɛm a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Làkoo alà lan'fà ken naa ngwän a Mwol amɛ uyi akà mɛ? ");
INSERT INTO yns_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ler, umpal kan'wem mɛ mbɔr angye, mwan awà kan'bäl amɛ kan'nini ntɔn un'sak mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ngye awà un'kaar aŋun'sak, ngye kàsi làkyän naa Mwol ayàkyer ndaa kakyään nde. » ");
INSERT INTO yns_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Waa Màlye kàtɛn naa: « U mɔ̈ɔ̈ amɛ wanswà mɛ in'kwen usyäŋà Mwol, ");
INSERT INTO yns_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mpem amɛ yan'yɔl a un'sak ntɔn Nzam, Un'tswää a mɔ̈ɔ̈ amɛ, ");
INSERT INTO yns_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ntɔn nde kàtɔɔm ileer ande udu a làbɔ̈ɔ̈n a un'tsüüŋ ande. Lalan, sɛmà apanà ngyääl yanswà isatɛɛnà a mɛ naa un'kaar aŋun'sak, ");
INSERT INTO yns_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ntɔn Ŋangwal kàkyer indiir a kölàköl ntɔn mɛ. Ikɔb ande kyà in'kyɛɛl, ");
INSERT INTO yns_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","U mbul a intye nde wàŋàyɔl a ngyɛb ntɔn baar bàfun'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nde kàswɛŋ ikɔ̈b ande musyääl ngwal a kɔɔ ande: nde kàpay baar aŋàyɔl a uyɔl u mpem aba, ");
INSERT INTO yns_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","nde kàtyeey amfum kà an'kir aba mà imfum anà kàsɛɛn baar a làbɔ̈ɔ̈n. ");
INSERT INTO yns_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nde kàyööl aŋangyal a indiir mbɔɔn, wɛɛ nde aŋin'naaŋ kafuur an'kɔɔ a ipɔl. ");
INSERT INTO yns_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nde kàbay un'tsüüŋ ande Isàlɛl: nde kàyɔbà ngyɛb ande asànaa kàswɛŋ nde bànkaa abi, ");
INSERT INTO yns_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","akà Abàlam anà ikyee ande kyà mbul a in'tye. » ");
INSERT INTO yns_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Màlye kàkäl isii a ngɔɔn tär akà Làsàbɛr, apan waa kàfurà ndwà ande. ");
INSERT INTO yns_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Taaŋ a Làsàbɛr mubɔr làkwe la, nde kàbör mwan baal. ");
INSERT INTO yns_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Baar a tsütsü anà baar a mbil ande bàwem ba naa Mwol kan'swaŋ ngyɛb ande mbɔɔn akà nde, ba bàsäŋà anà nde. ");
INSERT INTO yns_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ilä kyànaan ungö a mböör ande, ba bàyi mutsul mwan. Ba bàkweenà mukun'pà ikɔb a taarànde Zakàlye. ");
INSERT INTO yns_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Wɛɛ ngwän kàtɛn naa: « Aay, bàyun'beelà Ywan! » ");
INSERT INTO yns_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ba bàtɛn a nde naa: « Aa, u ndwà abɛ mbuur awe anà ikɔb akyɛy watɛy! » ");
INSERT INTO yns_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Abun, ba waa bàfuul taarànde muswaŋà mpin ntɔn muyöb naa ikɔb nà nde ukwen mupà mwan ande. ");
INSERT INTO yns_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakàlye kàlɔ̈m kilàbää, waa kàsɔ̈n abà: « Ndandaa ikɔb ande Ywan. » Baar banswà bàkyer abem. ");
INSERT INTO yns_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Apan sye, ndaa a Zakàlye waa yàsabà, waa kàsɛmà musà Nzam làkoo. ");
INSERT INTO yns_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Abun, baar a tsütsü bàmɛn bɔɔmà. Ndaa ayi baar bàsaamà ya u myɔŋ a Yuday myanswà. ");
INSERT INTO yns_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Baar banswà bàweemà ya bàkäl muyweerà anà mutɛn naa: « Kimwan aki ayàkal aben? » Ndandaa kɔɔ a Mwol làkäl anà nde. ");
INSERT INTO yns_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Taarànde Zakàlye kàkäl aŋàyɔl a Dweelà In'kyɛɛl, waa kàbulà mutà ngɔɔm anà mutɛn naa: ");
INSERT INTO yns_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","« Wɛy Mwol uwɛl nsaak, Nzam a un'sɛŋ a Isàlɛl, ntɔn nde kàyàler anà kàtsuuŋ wa kà isɔ. ");
INSERT INTO yns_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nde kàtwey Un'tswää a mɔ̈ɔ̈ a ngwal ntɔn bi uboo a ndwà a un'tsüüŋ ande mfum David. ");
INSERT INTO yns_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ayi ndaa kàkyään nde itaan u mun a aŋangɔɔm ande bà in'kyɛɛl: ");
INSERT INTO yns_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ntsuuŋ abi kà an'kɔɔ a aŋankir abi anà kà an'kɔɔ a baar bàfàkyer bi ube. ");
INSERT INTO yns_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nde kàswɛŋ ubwaŋ ande akà bànkaa abi. Nde sye kàdiimà anki kyän ande là in'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ndandaa, Nzam kàdi kyän akà nkaa abi Abàlam, ");
INSERT INTO yns_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","mukà itsuuŋ kà ikɔ̈b a aŋankir abi anà mukà ipà mbwo mukun'syääl ukɔɔn bɔɔmà, ");
INSERT INTO yns_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ntɔn bi ikälà baar a in'kyɛɛl anà bàbalàbal kusà ande kà ilä a mɔ̈ɔ̈ abi byanswà. ");
INSERT INTO yns_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wɛɛ ngye mwan amɛ, bàsabeelà ŋangɔɔm a Nzam a dudu, ntɔn ngye asàfwel kusà a Mwol ntɔn muyilà mbwo ande ");
INSERT INTO yns_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","anà mulɔŋ un'sɛŋ ande naa nde akyer ayà mutswà nde mɔ̈ɔ̈ ntɔn nde ayun'dwääl nkul a man'be ande. ");
INSERT INTO yns_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nzam abi wàŋàyɔl a ngyɛb, lalan kà itööm nde pɛɛlà làfü du asànaa taaŋ làfàsɛnà la, ");
INSERT INTO yns_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ntɔn mupɛɛlà baar abà uboo a làpib anà u mbwo a ukwà, ntɔn musyen bi u mbwo a duu. » ");
INSERT INTO yns_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwan wa kàkäl muyɛl u ndür anà u dweelà. Nde kàkälà u nsye a ipɔl tii mpal kàyàmɛnà nde u mii a un'sɛŋ a Isàlɛl. ");
INSERT INTO yns_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mpal ayin, Sɛzar Angus kàtöm un'kaan ntɔn mutaŋ baar banswà u mɛɛn a Lɔmà. ");
INSERT INTO yns_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ntääŋ a baar atàtwɛb ayi yàkäl mpal kàkäl Kirinüs mfum a Siri. ");
INSERT INTO yns_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Baar banswà bàkyeenà mukàsɔn ikɔb aba mbuur mbuur u bul kàfü nde. ");
INSERT INTO yns_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yɔsefi sye kàmbarà u Nasàlɛr bul a Ngalilɛ ntɔn mukyà Bɛtɛlɛm bul a Yuday ntɔn nde kàkäl mbuur a ywar anà mbil a David, ");
INSERT INTO yns_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ntɔn mukàsɔn ikɔb ande anà kyà un'kyay ande Màlye awà kàkäl anà yöm. ");
INSERT INTO yns_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mpal bàkäl ba u Yɛlusàlɛm, taaŋ a Màlye mubɔr làkyer akwo, ");
INSERT INTO yns_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","nde kàbör mwan baal ande wàtàtwɛb. Nde kun'läl ipfɛy, waa kun'byee uboo a unkwak ntɔn ba bàmɛn anki ikal u ndwà a angyey. ");
INSERT INTO yns_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","U ntsü ayin sye aseey bàfabɔ̈ɔ̈nà u nsà uboo a an'ywaŋ muyiler in'kɔk aba u mpib. ");
INSERT INTO yns_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wɛɛ, le, un'kyeey a Mwol mwɛy kàyàmɛnà akà ba, làkoo a Mwol sye làswɛŋ pɛɛlà a la. Ba bàwɛn bɔɔmà mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Wɛɛ un'kyeey kàtɛn a ba naa: « Twon lan'wem bɔɔmà, ntɔn mɛ amàlatwääl làsaŋ aŋàbwaŋ làyàpà un'sak akà baar banswà: ");
INSERT INTO yns_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","U mpib aŋàbà, u bul a David, bàmàlaböör Un'tswää a mɔ̈ɔ̈ mwɛy, nde wà Klistɔ, wà Mwol. ");
INSERT INTO yns_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","« Bɛ làyun'man unsà idiim ki: mwan aŋàlal ipfɛy, wàŋàbyee uboo a unkwak. » ");
INSERT INTO yns_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kà imbürà, akyeey a du mbɔɔn waa bàyun'taan, bàmusà Nzam làkoo, bàmutɛn naa: ");
INSERT INTO yns_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","« Làkoo akà Nzam kà ikal a dudu, duu u mɛɛn uboo a baar bàfun'kwen! » ");
INSERT INTO yns_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mpal bàsawɛy akyeey ntɔn mufurà du, aseey bàtɛn ba a ba naa: « Tsweenà Bɛtelɛm bà, bi ikàman ndaa yan'bwà kwo, ndaa kàmisam Mwol. » ");
INSERT INTO yns_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ba bàkyen agyägyä, waa bàmɛn Màlye anà Yɔsefi, anà mwan akɔɔ wàŋàbyee uboo a unkwak. ");
INSERT INTO yns_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mpal bun'mɛn ba, ba bàsam ndaa kakyään un'kyeey ntɔn mwan akɔɔ awun. ");
INSERT INTO yns_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Baar banswà bàweemà indiir bàtɛɛnà aseey, bàmɛn ndaa yubem. ");
INSERT INTO yns_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ndaa ayi yanswà Màlye ya kàkäärà u mpem, waa kàfayɔbà ya taaŋ lanswà. ");
INSERT INTO yns_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aseey waa bàfurà, bàmuyisà làkoo anà muyisyäŋà Nzam, ntɔn indiir byanswà bàwem ba anà bàmɛn ba, byàbü balàbal asànaa kakyään un'kyeey. ");
INSERT INTO yns_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ilä kyànaan ungö a mböör, taaŋ mutsul mwan làkwe la, ba bun'pɛ ikɔb a Yɛsu, ikɔb kakyään un'kyeey kusà ngwän mukal yöm. ");
INSERT INTO yns_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Apan, taaŋ mupöŋ ndür làkwe la ntɔn Yɔsefi anà Màlye asànaa kàswɛŋà un'kɔɔn a Mɔsɛ, ba bàsyen mwan u ndwà a Nzam a Yɛlusàlɛm ntɔn mukun'swaŋ akà Mwol, ");
INSERT INTO yns_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ntɔn bàsön uboo a un'kɔɔn a Mwol abà: « Mwan baal a nswɛm wanswà bun'sà ukɔl ntɔn Mwol. » ");
INSERT INTO yns_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yàlɔ̈m sye naa ba bàpɛ ibɔɔn asànaa ukalɔɔmà un'kɔɔn nsil awà, « nkokà un'kyay anà un'dim, itàkal in'tö a an'yem myeel. » ");
INSERT INTO yns_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","U Yɛlusàlɛm kàkäl anà mbuur mwɛy ikɔb ande Simɛyɔ. Mbuur awà kàkäl wàbalàbal anà inzaam, nde kàfadilà mbuur ayàlwom ngyɛb a Isàlɛl. Dweelà In'kyɛɛl kàkäl anà nde, ");
INSERT INTO yns_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","waa kun'kyään naa nde usàkwà anki kusà muman Klistɔ a Mwol. ");
INSERT INTO yns_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dweelà kun'syen u ndwà a Nzam. Umpal bàyàtwaal aböör a Yɛsu mwan aba ntɔn mukyer ndaa kàlɔ̈ɔ̈mà un'kɔɔn, ");
INSERT INTO yns_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simɛyɔ kun'wɛl kà an'kɔɔ ande, waa kàsyäŋà Nzam, waa kàtɛn naa: ");
INSERT INTO yns_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","« Mwol, mpalàbà ngye an'kwey ilää angye: ngye an'kwo awɛy un'tsüüŋ angye ukü a duu. ");
INSERT INTO yns_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ntɔn mɛ an'man Un'tswää a mɔ̈ɔ̈ amɛ u mii, ");
INSERT INTO yns_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Un'tswää a mɔ̈ɔ̈ kàlɔ̈ɔ̈n ngye ntɔn in'sɛŋ myanswà, ");
INSERT INTO yns_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nde wà pɛɛlà ntɔn mupà kyɛɛy akà in'sɛŋ a mɛɛn anà nde asàkal làkoo ntɔn un'sɛŋ angye Isàlɛl. » ");
INSERT INTO yns_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Taarànde anà ngwän bàkäl mubem indiir kàtɛɛnà Simɛyɔ ntɔn Yɛsu. ");
INSERT INTO yns_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simɛyɔ kun'si kɔɔ, waa kàtɛn a Màlye ngwän a Yɛsu naa: « Le! Mwan wà ayàkal mbuur ayàtyeey, taaŋ lumwɛy ayàmbaar baar mbɔɔn kà Isàlɛl. Nde ayàkal isi a Nzam iyàtwaal nkaabà, ");
INSERT INTO yns_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","abun an'kyän aŋàyee u mpem a baar mbɔɔn màsàmɛnà u leŋ. Wɛɛ akà ngye ŋakwo Màlye, usaay bàsapfuul mpem asànaa kɔm. » ");
INSERT INTO yns_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kàkäl sye anà ŋangɔɔm un'kaar ikɔb ande Anà, mwan a Fanwel, mbuur a un'sɛŋ a Asɛr. Nde kàkäl un'nün. Nde kàkäl mbul nsambwaar anà un'dim kàbääl nde kà isyee ande, ");
INSERT INTO yns_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ungö, nde kàbulà un'kweel un'dim. Nde kàkäl ayà mbul an'kwem naan aŋinà. U mɔ̈ɔ̈ ande wanswà nde kàbwaayà u ndwà a Nzam musyäälà Nzam mpib anà mwäänà: nde kàkälà mukin mbɔr anà muyamà. ");
INSERT INTO yns_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nde kàyàkɔlà sye taaŋ nsil alan, wàmuyisyäŋà Nzam. Nde kàkäl mukyään ndaa a Yɛsu akà baar banswà bàkälà mudilà naa Nzam ukɔɔr Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mpal bàmay ba mukyer ndaa yanswà kàlɔ̈ɔ̈mà un'kɔɔn a Mwol, Yɔsefi anà Màlye bàfurà bul aba Nasàlɛr u Ngalilɛ. ");
INSERT INTO yns_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwan kàkäl muyɛl anà mubulà ngwal. Nde kàkäl aŋàyɔl a an'yeerà, kɔɔ a Nzam làkäl anà nde. ");
INSERT INTO yns_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aböör a Yɛsu bàfakyeenà Yɛlusàlɛm mbul wanswà mukàdyà Pak. ");
INSERT INTO yns_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mpal kàkäl Yɛsu mbul kwen aŋiyweel, ba bun'syen Yɛlusàlɛm asànaa ikääl aba. ");
INSERT INTO yns_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mpal yàwü nköŋ, ba waa bàfurà, wɛɛ mwan Yɛsu kàsàsal u Yɛlusàlɛm, aböör ande bàyöb anki. ");
INSERT INTO yns_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba bàsii naa nde wa anà atɔŋ aba bàtüüb ba mbwo, ba bàkyer mwäänà mwɛy muyikyà, waa bàsɛmà muyun'leŋ uboo a atɔŋ aba anà uboo a asam aba. ");
INSERT INTO yns_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wɛɛ ba bun'mɛn anki. Apan ba bàfurà Yɛlusàlɛm mukun'leŋ. ");
INSERT INTO yns_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ungö ilä itär ba bun'mɛn u ndwà a Nzam kàkyàbwaay uboboo a alɔɔŋ a un'kɔɔn. Nde kàkäl muweemà ba anà musà ba mfuul. ");
INSERT INTO yns_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Baar banswà bàweemà ndaa ande bàkäl mubem ntɔn un'yɛnà ande anà mfuur a ndaa ande. ");
INSERT INTO yns_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mpal bun'mɛn aböör ande, ba bàkyer abem, lalan ngwän kàtɛn nde a nde naa: « Mwan amɛ, ntɔn nkye amà ikyer ngye abà? Ler, taaràŋà anà mɛ, bi kan'kyɛɛr mbɔɔn muyaleŋ. » ");
INSERT INTO yns_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nde waa kafuur naa: « Ntɔn nkye làyan'leŋ bɛ? Bɛ làyöb anki naa mɛ in'kyer akyer isal a taaràmɛ? » ");
INSERT INTO yns_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wɛɛ ba bàsàyöb anki ndaa kàtɛɛnà nde. ");
INSERT INTO yns_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Apan Yɛsu kàfurà Nasàlɛr anà ba. Nde kàkyer afalabà ndaa aba. Ndaa ayi yanswà ngwän ya kàkäärà u mpem ande. ");
INSERT INTO yns_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yɛsu kàkäl muyɛl unsà ndür anà unsà an'yeerà. Nde sye kàpɛɛ un'sak akà Nzam anà akà baar. ");
INSERT INTO yns_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mbul wàkwem aŋityeen wà imfum a Mfum Tibɛr Sɛzar, umpal kàkäl Pɔnsɔ Pilatu kuvɛrnɔ̈ɔ̈r u Yuday, Ɛlɔdi u Ngalilɛ, un'tɔŋ ande Filipo u Itürɛ anà u Trakɔnit, Lizanyas u Abilɛn, ");
INSERT INTO yns_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","anà umpal a andwer a angaŋ Anà anà Kayifa, ndaa a Nzam yàyi akà Ywan mwan a Zakàlye, u nsye a ipɔl. ");
INSERT INTO yns_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nde kàyilyaaŋà u nsi yanswà yà tsütsü a ngyäl a Yɔrdan muyilɔŋ baar mubuul mpem anà mukadümà ntɔn badwääl nkul a man'be aba ");
INSERT INTO yns_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","asànaa bàsön ya uboo a un'kaan a ndaa a ŋangɔɔm Yɛsay naa: « Yi ndaa a mbuur akasaa in'kwɛŋ u nsye a ipɔl: \"Làlɔ̈ɔ̈n mbwo a Mwol, làsuub myäy ande. ");
INSERT INTO yns_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Un'baan wanswà akyer ayàyɔl, mɔŋ wanswà anà iköl kyanswà ikyer ayàtye, mbwo aŋàkwàkwarà ikyer ayàsubà, mbwo aŋàkwà bàkyer ayàlɔn.\" ");
INSERT INTO yns_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mbuur wanswà ayàman mɔ̈ɔ̈ kàpɛ Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","In'sɛŋ a baar myàyee akà Ywan ntɔn nde kadümà. Nde kàtɛɛnà a ba naa: « Mbil a iyäy, nà kàlaswɛŋ mutiin nkyɛl iyà ungö? ");
INSERT INTO yns_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Làswɛŋ u nsyääl abɛ naa bɛ lan'buul mpem, wɛɛ twon lan'tɛn u mpem abɛ naa: \"Abàlam wà nkaa abi.\" Ntɔn mɛ alàkyään naa Nzam kan'kwo utwey ikyee a Abàlam unsà nkɔŋ yi. ");
INSERT INTO yns_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Làler, fà itaan nkwar ya tsütsü mutsul in'te kà in'swɛy a mya: un'te wanswà mpa afàbɔr mbɛŋ aŋàbwaŋ bàkyer ayun'tsul, waa bàyun'tɔɔm u mbaa. » ");
INSERT INTO yns_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Baar bun'fuulà naa: « Apɛy bi waa ikyer aben? » ");
INSERT INTO yns_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nde waa kàfuur naa: « Wɛy mbuur awe abyà inkur byeel upɛ imwɛy akà mbuur akɔ̈ɔ̈n a kya, wɛɛ mbuur awe anà isaa adyà ukyer sye abà. » ");
INSERT INTO yns_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Afüür a itɛr sye bàyi ntɔn badümà, waa bàtɛn a nde naa: « Un'lɔɔŋ, bi ikyer aben? » ");
INSERT INTO yns_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nde waa kafuur naa: « Twon lan'kwɛy undiir udu a indiir bàlaswɛŋ mukyer. » ");
INSERT INTO yns_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aŋità sye bàfuul naa: « Atöl bi ikyer aben? » Nde waa kafuur naa: « Twon lan'gyɔɔr undiir a mbuur, twon lan'yib, làkyey làfur abɛ mpɛl. » ");
INSERT INTO yns_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Baar bàkäl anà ngyal muyöb naa nkye Ywan wà Klistɔ bàdilà ba. ");
INSERT INTO yns_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nde kàtɛn a baar banswà naa: « Mɛ, mɛ in'kàladümà kà an'dà, wɛɛ mbuur ayàyà ungö amɛ kàman'söön u ngwal, mɛ in'kwe anki musɔɔl in'siŋ a sàbar ande. Nde bɛ ayàladümà u Dweelà In'kyɛɛl anà u mbaa. ");
INSERT INTO yns_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nde we anà impye ande u kɔɔ ntɔn mukaab mbɛŋ anà un'lɛŋ. Nde mbɛŋ ayàsà uboo a ikɔr ande, wɛɛ nde un'lɛŋ ayàtɔɔm u mbaa mpa ifàdim. » ");
INSERT INTO yns_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Abun Ywan kàswɛŋà ndaa asin mbɔɔn akà un'sɛŋ mukyer anà kun'kyäänà Làsaŋ Aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Apan sye Ywan kàtɛɛnà a Ɛlodi, mbuur kàfayaalà u Ngalilɛ, ntɔn kàbääl nde Ɛlɔdyas, un'kyay a un'tɔŋ ande, anà ntɔn nde kàkyer ube asin bà ifà ifà, ");
INSERT INTO yns_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","nde kàfàkwɛy ube asin musà Ywan u bɔlokà. ");
INSERT INTO yns_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yàmɛnà naa baar banswà bàkyeenà mukàwal ndüümà. Yɛsu sye kàkàwal ndüümà. Mpal kàkäl nde muyamà, du waa làdubà, ");
INSERT INTO yns_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Dweelà In'kyɛɛl kàyi udu ande kà imbuur imbuur asànaa yem. Ndaa yan'fà du yan'tɛn naa: « Ngye, ngye awà Mwan in'kwen mɛ, mɔ̈ɔ̈ amɛ wanswà we amu ngye. » ");
INSERT INTO yns_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yɛsu kàkäl ayà tsütsü mbul an'kwem an'tär taaŋ kàsɛmà nde isal ande asànaa bàsii baar naa nde wà mwan a Yɔsɛfi, mwan a Ɛli, ");
INSERT INTO yns_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mwan a Matat, mwan a Lɛvi, mwan a Mɛlshi, mwan a Zanayi, mwan a Yɔsɛfi, ");
INSERT INTO yns_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mwan a Matatyas, mwan a Amɔs, mwan a Nawum, mwan a Ɛsli, mwan a Nangay, ");
INSERT INTO yns_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwan a Maat, mwan a Matatyas, mwan a Sɛmɛy, mwan a Yɔsɛk, mwan a Yɔda, ");
INSERT INTO yns_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mwan a Ywanan, mwan a Yɛsa, mwan a Zɔrɔbabɛl, mwan a Salatyɛl, mwan a Nɛri ");
INSERT INTO yns_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwan a Mɛlki, mwan a Adi, mwan a Kɔsam, mwan a Ɛlmadam, mwan a Ɛr, ");
INSERT INTO yns_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwan a Yɛsu, mwan a Ɛlyɛzɛr, mwan a Yɔrim, mwan a Matat, mwan a Lɛvi, ");
INSERT INTO yns_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mwan a Simɛyɔ, mwan a Yudà, mwan a Yɔsɛfi, mwan a Yɔnam, mwan a Ɛlyakim, ");
INSERT INTO yns_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwan a Mɛlɛya, mwan a Mɛna, mwan a Matatar, mwan a Natan, mwan a David, ");
INSERT INTO yns_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwan a Isayi, mwan a Yɔbɛd, mwan a Booz, mwan a Salà, mwan a Nasɔn, ");
INSERT INTO yns_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mwan a Aminadab, mwan a Admin mwan a Arni, mwan a Ɛsrɔm, mwan a Farɛs, mwan a Yudà, ");
INSERT INTO yns_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwan a Yakɔb, mwan a Isak, mwan a Abàlam, mwan a Tara, mwan a Nashɔr, ");
INSERT INTO yns_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwan a Sɛrush, mwan a Ragɔ, mwan a Falɛk, mwan a Ɛbɛr, mwan a Salà, ");
INSERT INTO yns_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mwan a Kaynam, mwan a Alàpakàsad, mwan a Sɛm, mwan a Nɔwà, mwan a Lamɛk, ");
INSERT INTO yns_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwan a Matusala, mwan a Ɛnɔk, mwan a Yɛred, mwan a Màlalɛyɛl, mwan a Kɛnan, ");
INSERT INTO yns_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwan a Ɛnɔs, mwan a Sɛt, mwan a Adam, mwan a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yɛsu kàkäl aŋàyɔl a Dweelà In'kyɛɛl mpal kàfü nde Yɔrdan, Dweelà kun'syen u nsye a ipɔl, ");
INSERT INTO yns_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ikal kun'lɛb Satanà ilä an'kwem an'nà. Ilä abin byanswà nde akundiir kàdi anki. Mpal byàwü ilä abi, nde kàwem ngyal. ");
INSERT INTO yns_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satanà kàtɛn a nde naa: « Isàkal naa ngye awà Mwan a Nzam, swaŋ nkɔŋ yi ibulà nsɔ. » ");
INSERT INTO yns_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yɛsu kun'fuur naa: « Bàsön naa: \"Mbuur usàkal anki anà mɔ̈ɔ̈ ntɔn nsɔ mpɛl.\" » ");
INSERT INTO yns_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satanà kun'syen ududu, kun'swɛŋ imfum a mɛɛn byanswà, ");
INSERT INTO yns_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","waa kàtɛn a nde naa: « Mɛ in'yapà ikɔ̈b ki kyanswà, un'naaŋ anà làkoo a imfum bi byanswà, ntɔn bya mɛ bàpɛ, mɛ sye in'fàpà akà mbuur wanswà in'kwen mɛ. ");
INSERT INTO yns_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Isàkal naa ngye an'bwà an'köm kusà a mɛ, ayi yanswà iyàkal yà ngye. » ");
INSERT INTO yns_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yɛsu kun'fuur naa: « Bàsön naa: \"Ngye asàbwà an'köm kusà a Mwol, Nzam angye, ngye sye ayàsyääl nde mpɛl.\" » ");
INSERT INTO yns_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Satanà kàfun'syen u Yɛlusàlɛm, kun'si udu a ndwà a Nzam, waa kàtɛn a nde naa: « Isàkal naa ngye awà Mwan a Nzam, tɔɔmà sɛmà pà tii u nsi, ntɔn bàsön naa: ");
INSERT INTO yns_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","\"Nde ayàswaŋ in'kyeey ande ntɔn ngye, ntɔn ba batii, ");
INSERT INTO yns_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","anà ba sye bàsawal kan'kɔɔ aba ntɔn làkɔl angye làkɔ̈ɔ̈n abööl u nkɔŋ.\" » ");
INSERT INTO yns_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yɛsu kun'fuur naa: « Bàsön naa: \"Ngye asun'kur anki Mwol, Nzam angye\". » ");
INSERT INTO yns_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pa kàmay nde ndɛb yanswà, Satanà waa kàlwomà tsütsü apà Yɛsu tii utaaŋ asin. ");
INSERT INTO yns_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yɛsu kàkäl aŋàyɔl a ngwal a Dweelà mpal kàfurà nde Ngalilɛ. Làsaŋ ande làpää kà itiir a nsi aki kyanswà. ");
INSERT INTO yns_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nde kàyilɔŋà uboo a ndwà a nköŋ a Ayudà. Baar banswà bàkyer un'sà làkoo. ");
INSERT INTO yns_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Apan, Yɛsu kàkyen Nasàlɛr ikal kàyɛl nde. Asànaa ifà ande, nde kàbilà u ndwà a nköŋ a Ayudà ilä a saba. Nde kàmbarà ntɔn mutaŋ, ");
INSERT INTO yns_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ba bun'pɛ un'kaan a ŋangɔɔm Yɛsay. Nde kàduub wa, waa kàmɛn ikal bàsön naa: ");
INSERT INTO yns_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","« Dweelà a Mwol là udu amɛ, ntɔn nde kan'si an'kɔɔ ntɔn mukyään Làsaŋ Aŋàbwaŋ akà aŋàlàmbwà, nde kan'töm mukyään ntsuuŋà akà baar aŋàkwɛlà, anà akà ikwàmii muman, mutsuuŋ baar bàŋàmɛɛy nkwaaŋ, ");
INSERT INTO yns_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","mukyään mbul usàswaŋ Mwol kab angway ande. » ");
INSERT INTO yns_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ungö apan nde kàdübà un'kaan awun, kàpɛ wa akà un'syääl, waa kàbwaay. Uboo a ndwà a nköŋ a Ayudà, mii myanswà myàkäl muler nde. ");
INSERT INTO yns_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Apan nde kàsɛmà mutɛn a ba naa: « Itiir a Ndaa a Nzam an'taŋ mɛ yi, akà bɛ baar làweemà ya, ya yan'kwo ŋàbawà. » ");
INSERT INTO yns_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Baar banswà bun'tɛɛlà imbäl: ba bàkäl mubem ntɔn ndaa aŋàbwaŋ iyatoo u mun ande, wɛɛ ba bàtɛɛnà naa: « Wà mà mwan a Yɔsɛfi! » ");
INSERT INTO yns_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Apan Yɛsu waa kàtɛn a ba naa: « Mɛ inkyàyöb naa bɛ làyan'tɛɛl itim ki: \"Ungaŋ, kɔɔr ngye ŋakwo, bɛ làyàtɛn naa kyer u bul angye asànaa kàkyer ngye u Kapɛrnawum.\" ");
INSERT INTO yns_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wɛɛ mɛ, mɛ alàkyään ndandaa naa akà ŋangɔɔm mwɛy ufun'wal u nsi ande watɛy. ");
INSERT INTO yns_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mɛ alàkyään ndandaa, akweel adim bàkäl mbɔɔn u taaŋ a Ɛli kà Isàlɛl mpal mbul mpa kànɔ̈ wa mbul tär a ngɔn syaam. Ngyal yàkyer abilà u mɛɛn manswà, ");
INSERT INTO yns_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","wɛɛ Ɛli bun'töm anki akà umwɛy uboo a ba, bun'töm akà un'kweel un'dim mwɛy u Sarɛpta, u mɛɛn a Sidɔn. ");
INSERT INTO yns_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Baar a ukyal a bay sye bàkäl mbɔɔn kà Isàlɛl utaaŋ a ŋangɔɔm Ɛlisya, ba banswà bàkɔɔrà anki, Naaman un'nsi Siri mpɛl. » ");
INSERT INTO yns_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Baar banswà uboo a ndwà a nköŋ a Ayudà bàwem nkyɛl mbɔɔn mpal bàwem ba indiir abi byanswà. ");
INSERT INTO yns_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Waa bàmbarà, bun'böŋ u bul aba, bun'syen udu a mɔŋ bàtöŋ bul aba ntɔn mukun'siinà waa nde ukàbwà u ngyɛl. ");
INSERT INTO yns_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wɛɛ Yɛsu kàlyaaŋ uboo aba, waa kàkyen. ");
INSERT INTO yns_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Apan Yɛsu kàtyà Kapɛrnawum, bul a Ngalilɛ. Nde kàlɔɔŋà ilä a saba. ");
INSERT INTO yns_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Baar bàmɛn ndaa yubem ntɔn nde kàlɔɔŋà a ikɔ̈b. ");
INSERT INTO yns_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","U ndwà a nköŋ a Ayudà kàkäl anà mbuur mwɛy kàkäl anà dweelà a làbe. Mpal kàmɛn nde Yɛsu, nde kàsi in'kwɛŋ: ");
INSERT INTO yns_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","« Aa! Yɛsu un'nsi Nasàlɛr, ngye ininà akwen ntɔn bi? Ngye ayi ntɔn muböŋ bi? Mɛ in'kyàyöb naa ngye awà nà, ngye awà Ŋun'kyɛɛl a Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yɛsu waa kun'ŋän, waa kàtɛn naa: « Kal a duu, too uboo a mbuur wà. » Dweelà a làbe lun'bwiy u nsi, waa làtoo ukɔɔn akun'kyer ube. ");
INSERT INTO yns_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Baar banswà bàkäl u bɔɔmà, waa bàtɛɛnà ba a ba naa: « Ndaa nà ayi? Nde wà mutɛɛnà a ngwal anà ikɔ̈b a an'dweelà an'be, ma sye màmutoo! » ");
INSERT INTO yns_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Làsaŋ ande làpää kà itiir a nsi akin. ");
INSERT INTO yns_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yɛsu kàtoo u ndwà a nköŋ a Ayudà, waa kàkyen ndwà a Simɔn. Ukwà a Simɔn kàkäl anà làbwey a mpye mbɔɔn. Ba bun'bɔ̈ɔ̈n mukun'kɔɔr. ");
INSERT INTO yns_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yɛsu waa kànyee udu ande, waa kàböŋ ukyal aban. Umpal bàtoo ba u ndür ande, nde waa kàsubà, waa kàsɛmà mukasyääl. ");
INSERT INTO yns_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","U làbwàmpib, baar bàkäl anà baar a an'kyal mà ifà ifà batwäl akà Yɛsu. Nde kasi an'kɔɔ, ba waa bàkɔɔrà. ");
INSERT INTO yns_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","An'dweelà an'be sye màtoo anà in'kwɛŋ anà màtɛn naa: « Ngye awà Mwan a Nzam. » Wɛɛ Yɛsu katsüŋ a ngwal ntɔn ba bàkɔ̈ɔ̈n afàtɛn, ntɔn ba bàkyer ayöbà naa nde kàkäl Klistɔ. ");
INSERT INTO yns_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Taaŋtyà ututu, Yɛsu kàkyer atoo, waa kàkyen kikal a mpey. Baar mbɔɔn bàkyer ayun'leŋà. Mpal bun'mɛn ba, ba bàkwen mukun'tà mpi ntɔn nde ukɔɔn asawɛy. ");
INSERT INTO yns_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wɛɛ nde kàtɛn a ba naa: « Mɛ in'kyer akàpay Làsaŋ Aŋàbwaŋ là imwol a Nzam kà an'bul mumwɛy, ntɔn ndaa kan'töm Nzam yayi. » ");
INSERT INTO yns_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nde kàlɔɔŋà u ndwà a nköŋ a Ayudà u Yuday. ");
INSERT INTO yns_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yàmɛnà naa ilä mwɛy Yɛsu kàkäl tsütsü a ɛwà a Ngɛnàsàlɛr, baar mbɔɔn bàkyer un'diŋà ntɔn muwem ndaa a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nde kàmɛn an'bwaar an'mɔ̈ɔ̈l mà ipɔl kà un'kɔɔl a an'dà ntɔn aŋama bàkäl musɔŋ an'kwen aba. ");
INSERT INTO yns_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nde kàlär uboo a bwaar làmwɛy, la làkäl là Simɔn, waa kun'lɔ̈ɔ̈m naa nde usiinà la ikyee uboo a an'dà. Nde waa kàbwaay, kàlɔɔŋà baar uboo a bwaar. ");
INSERT INTO yns_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mpal kàmay nde mulɔŋ, nde kàtɛn a Simɔn naa: « Làkyen uboboo a an'dà, làtɔɔm an'kwen abɛ kan'dà ntɔn mulwab nsö. » ");
INSERT INTO yns_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simɔn kun'fuur naa: « Un'lɔɔŋ, bi kan'kyer mpib aŋun'kiinà, wɛɛ bi akà undiir imɛn anki. Ntɔn ngye aman'swaŋ, mɛ in'kyer atɔɔm an'kwen. » ");
INSERT INTO yns_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ungö mutɔɔm ma, ba bàsiim nsö mbɔɔn, an'kwen màkäl tsütsü mukaamà. ");
INSERT INTO yns_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ba bàbel atɔŋ aba bàkäl uboo a bwaar lumwɛy ntɔn ba babay. Ba waa bàyi, bàyööl an'bwaar màmɔ̈ɔ̈l: ma màkäl tsütsü muminà ntɔn buur a nsö. ");
INSERT INTO yns_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mpal kàmɛn Simɔn abun, nde kàbü kà in'kɔl a Yɛsu, waa kàtɛn naa: « Mwol, lwomà tsütsü apà mɛ, ntɔn mɛ in'wà mbuur a man'be. » ");
INSERT INTO yns_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ntɔn nde anà atɔŋ ande matɛɛr màkyer awal ntɔn bàsiim ba nsö mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Atɔŋ ande Zyak anà Ywan, baan a Zebàday, bàkäl sye asànaa nde. Apan, Yɛsu waa kàtɛn a Simɔn naa: « Twon an'man bɔɔmà, sɛmà apanà ngye an'bulà un'lɔ̈ɔ̈b a baar. » ");
INSERT INTO yns_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ungö bàmay ba mutwey an'bwaar u nkankyel, ba bàsàwɛy ma, waa bàläb Yɛsu. ");
INSERT INTO yns_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yàmɛnà naa Yɛsu kàkäl u bul mwɛy, ŋun'kyal a bay kun'mɛn nde, nde kàbü kusà ande, waa kun'bɔ̈ɔ̈n naa: « Mwol, kya ngye asàkwen, mpööŋ. » ");
INSERT INTO yns_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yɛsu kàsilà kɔɔ ande, waa kun'bä, waa kàtɛn a nde naa: « Mɛ an'kwen, pɔŋà! » Taaŋ nsil alan bay waa làlwomà. ");
INSERT INTO yns_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ungö apan nde kun'tsüŋ naa: « Twon an'kyään mbuur asin ndaa ayi. Wɛɛ, kyen akà ngaŋ ntɔn nde kaler, ungö waa ngye apà an'kab kàswɛŋ Mɔsɛ ntɔn mpööŋà angye, waa kya ikal imbäl ntɔn ba. » ");
INSERT INTO yns_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Apan, làkoo ande làkyer apää ntsü yanswà, baar mbɔɔn bàyee ntɔn muwem ndaa ande anà muleŋ nkɔɔr unsà an'kyal aba. ");
INSERT INTO yns_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wɛɛ nde kàkyeenà kà ikal a mpey ntɔn mukàyamà Nzam. ");
INSERT INTO yns_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yàmɛnà naa ilä mwɛy Yɛsu kàkäl mulɔŋ. Amfarisi anà alɔɔŋ a in'kɔɔn bàkäl paa sye ban'bwaay. Ba bàfü an'bul manswà mà Ngalilɛ, mà Yuday anà Yɛlusàlɛm. Ngwal a Mwol yàkäl a Yɛsu ntɔn mukɔɔr abɛy. ");
INSERT INTO yns_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Apan sye, baar amwɛy bàtwäl mbuur mwɛy aŋàkwɛkà udu a ipɔy. Ba bàleŋà mukun'biil uboo a ndwà anà bun'tɔɔl kusà a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Abà bàmɛn ba naa mbwo abilà yatɛy ntɔn baar bàkäl mbɔɔn, ba bàpfuul mun u mpaan a ndwà, waa bun'tɔɔl kusà a Yɛsu u mii a baar banswà. ");
INSERT INTO yns_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mpal kàmɛn nde làkwikilà aba, Yɛsu kàtɛn naa: « Mbuur wà, mɛ amadwääl nkul a man'be angye. » ");
INSERT INTO yns_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Amfarisi anà alɔɔŋ a Un'kɔɔn waa bàyweerà u mpem aba naa: « Nà mbuur awà? Nde wàmubɛy Nzam. Nà kan'kwo mudwa nkul a man'be isàkal naa kà Nzam anki? » ");
INSERT INTO yns_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Wɛɛ Yɛsu kàyöb nde ankyän aba, waa kàtɛn a ba naa: « An'kyän nà bɛ làwe amà u mpem abɛ? ");
INSERT INTO yns_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Undiir nà akɔ̈ɔ̈n mpay mutɛn: Bàmadwääl nkul angye, lɛɛ mutɛn naa: Mbarà, kyen? ");
INSERT INTO yns_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Apanà, yubwaŋ bɛ làyöb naa Mwan a mbuur we anà ikɔ̈b mudwääl baar nkul a man'be aba u mɛɛn pà. » Nde kàswɛŋ mbuur aŋàkwɛkà naa: « Mɛ amaswaŋ, mbarà, sɛn ipɔy angye, furà ndwà angye. » ");
INSERT INTO yns_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Taaŋ nsil alan, u mii a baar banswà, laa kàmbarà nde, kàsɛn nde ipɔy ande, waa kàfurà ndwà ande wàmuyisà Nzam làkoo. ");
INSERT INTO yns_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Baar banswà bàkäl mubem, waa bàsyäŋà Nzam. Unsà bɔɔmà ba bàtɛɛnà naa: « Bi kan'man indiir ibaŋ ŋàbawà. » ");
INSERT INTO yns_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ungö apan Yɛsu kàtoo nde, nde kàmɛn un'füür a itɛr mwɛy ikɔb ande Lɛvi kan'bwaay kà ikal a isal ande. Nde kàtɛn a nde naa: « Yan'läb. » ");
INSERT INTO yns_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nde sye laa kàsàwɛy nde indiir byanswà, waa kun'läb. ");
INSERT INTO yns_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lɛvi kàwɛl Yɛsu unsà ubwaŋ banswà u ndwà ande. Afüür a itɛr mbɔɔn anà baar asin bàkäl mudyà anà nde u mɛsà. ");
INSERT INTO yns_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Amfarisi anà alɔɔŋ a Un'kɔɔn bàkyer aŋüŋün, waa bàtɛn a alɔŋki a Yɛsu naa: « Ntɔn nkye làkadyaa bɛ ikal imwɛy anà afüür a itɛr anà baar a man'be? » ");
INSERT INTO yns_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yɛsu kafuur naa: « Kà baar abye anà ngwal u ndür anki bye anà mfun a un'ngaŋ, wɛɛ aŋukyal. ");
INSERT INTO yns_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mɛ kàyi anki muleŋ mbuul a mpem a baar a balàbal, wɛɛ mbuul a mpem a baar a man'be. » ");
INSERT INTO yns_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Amfarisi bàtɛn ande naa: « Alɔŋki a Ywan anà alɔŋki abi bàfàkin mbɔr mbalà mbɔɔn anà muyamà Nzam, wɛ alɔŋki angye isal aba udyà anà unwà. » ");
INSERT INTO yns_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nde kafuur naa: « Nkye asam a mbuur kan'tà bɔr ban'kwo bàkin mbɔr isàkal naa nde wà paa anà ba? ");
INSERT INTO yns_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ilä kyà paa bàsàlwom ba un'tɛɛl a bɔr, apan ba waa bàsàkin mbɔr. » ");
INSERT INTO yns_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nde kàfatɛɛl nsim yi: « Akà mbuur mwɛy ukwe anki muwal itɛɛnà a ipfɛy akün ntɔn mubaay ipfɛy aŋànün. Ntɔn itɛɛnà akin iyàpà anki ubwaŋ unsà ipfɛy aŋànün. ");
INSERT INTO yns_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Akà mbuur mwɛy sye ukwe anki musà man akün uboo a mbeen itaan: naa tɛy, man akün iyàpfuul mbeen itaan, waa ipää, mbeen sye waa ikyà bwà. ");
INSERT INTO yns_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yubwaŋ musà man akün u mbeen akün. ");
INSERT INTO yns_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Akà mbuur mwɛy ukwe anki mukwen man akün isàkal naa nde akyàfuràtànwà man itaan, ntɔn nde ayàtɛn naa: \"Man a itaan mà ntsà.\" » ");
INSERT INTO yns_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yàmɛnà naa ilä a saba mwey, Yɛsu kàkäl mulyaaŋ uboo a an'ywaŋ a blɛ. Alɔŋki ande bàbwee imfà, ungö mupfipfiy bya kà an'kɔɔ aba, waa bàdyee mbɛŋ a bya. ");
INSERT INTO yns_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Amfarisi amwɛy bàkäl paa bàtɛn a ba naa: « Ntɔn nkye làkyerà bɛ ndaa mpa bàfàkyer kà ilä a saba? » ");
INSERT INTO yns_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yɛsu kafuur naa: « Nkye bɛ làtäŋ anki ndaa kàkyer David mpal kàwem nde ngyal anà baar bàkäl anà nde? ");
INSERT INTO yns_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nde kàbilà u ndwà a Nzam, kàwɛl mampà ufàpà ibɔɔn akà Nzam laa kàdi nde, mumwɛy nde kàpɛ akà baar bàkäl anà nde, itàkal naa ma angaŋ mpɛl bàfàdyà. » ");
INSERT INTO yns_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nde waa kàfàkwɛy abà: « Mwan a mbuur wà mfum a saba. » ");
INSERT INTO yns_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yàmɛnà sye naa ilä a saba kyumwɛy Yɛsu kàbilà u ndwà a nköŋ a Ayudà, waa kàlɔɔŋà. Uboo kwo kàkäl anà mbuur kàkäl anà kɔɔ ibaal làŋàkwɛkà. ");
INSERT INTO yns_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Alɔɔŋ a in'kɔɔn anà Amfarisi bàkäl musyebà Yɛsu a duu ntɔn muyöb naa nkye nde akyer akɔɔr mbuur ilä a saba, ntɔn ba bun'bämà ndaa. ");
INSERT INTO yns_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wɛɛ nde kàkyer ayöb an'kyän aba, waa kàbel mbuur kàkäl anà kɔɔ aŋàkwɛkà: « Mbarà, mbar uboboo pà. » Mbuur awà waa kàmbarà, waa kàmbär uboboo a baar. ");
INSERT INTO yns_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yɛsu waa kafuul naa: « Mɛ in'kwen muyöb: Nkye yubwaŋ mukyer ubwaŋ lɛɛ mukyer ube ilä a saba? Mutswà mɔ̈ɔ̈ a mbuur lɛɛ mukɔɔn atswà wa ilä a saba? » ");
INSERT INTO yns_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ungö apan, Yɛsu kàler ba banswà, waa kàtɛn a mbuur awun naa: « Sen kɔɔ angye. » Nde sye waa kàsen la, laa làkɔɔrà la. ");
INSERT INTO yns_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Alɔɔŋ a Un'kɔɔn anà Amfarisi bàwem nkyɛl, waa bàsɛmà mutɛn ba a ba naa ba ininà bàkyer akà Yɛsu. ");
INSERT INTO yns_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mpal ayin Yɛsu kàlär udu a mɔŋ ntɔn mukàyamà. Nde kwo kàkyer mpib aŋun'kiinà muyamà Nzam. ");
INSERT INTO yns_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Taaŋtyà, nde kàbel alɔŋki ande, waa kàsɔ̈ɔ̈l kwem aŋiyweel uboo a ba, nde kapɛ ikɔb naa antööm: ");
INSERT INTO yns_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simɔn, nde kun'pɛ ikɔb a Petɔlà, un'tɔŋ ande Andrɛ, Zyak, Ywan, Filipo, Bàtelàmay, ");
INSERT INTO yns_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Màtay, Tuma, Zyak mwan a Alfɛ, Simɔn mbuur a mankay, ");
INSERT INTO yns_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudà mwan a Zyak, anà Yudas Iskaryɔt, mbuur ayun'yälà. ");
INSERT INTO yns_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ungö apan nde kàyàtyà anà ba, waa bàmbär kà ikal mwɛy kyà ibär, ikal bàkäl alɔŋki ande mbɔɔn anà un'kàbɔ a baar: baar a Yuday lanswà, bà Yɛlusàlɛm, anà baar bàfü un'kɔɔl a an'dà, a Tir anà Sidɔn. ");
INSERT INTO yns_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ba bàyi ntɔn mukun'wem anà ba bàkɔɔrà unsà an'kyal aba. Baar bàkäl anà an'dweelà an'be, bàkyer akɔɔrà. ");
INSERT INTO yns_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Baar banswà bàleŋà muba nde u ndür, ntɔn ngwal mbɔɔn yàkatoo u ndür ande, ya yàkɔɔrà ba banswà. ");
INSERT INTO yns_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Apan Yɛsu kàler alɔŋki ande, waa kàtɛn naa: « Un'sak akà bɛ aŋàlàmbwà, ntɔn imwol a Nzam kye anà bɛ! ");
INSERT INTO yns_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Un'sak akà bɛ baar làwe anà ngyal mpalàbà, ntɔn bɛ làkyer asàyuur! Un'sak akà bɛ baar làlelà ŋàbawà, ntɔn bɛ làkyer asàsɛ! ");
INSERT INTO yns_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","« Un'sak asàkal akà bɛ isàkal naa ba bàmàlàyiiŋ, bàmàlàböŋ, bàmàlato, bàmàlapiy asànaa undiir a ŋingyäy ntɔn Mwan a mbuur! ");
INSERT INTO yns_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Làkäl unsà un'sak mpal isàkwo ndaa ayin ntɔn bweel abɛ làsàkal mbɔɔn u du, ntɔn bànkaa aba bàkyerà abà akà aŋangɔɔm. » ");
INSERT INTO yns_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","« Wɛɛ ngyɛb akà bɛ, aŋun'naaŋ, ntɔn bɛ ndɛɛl abɛ lan'wal nsil apà. ");
INSERT INTO yns_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ngyɛb akà bɛ baar lan'yuur mpalàbà, ntɔn bɛ làsàwem ngyal. Ngyɛb akà bɛ baar làsɛɛ mpalàyi, ntɔn bɛ làsàkal kun'saabà anà uboo a ilel. ");
INSERT INTO yns_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ngyɛb, isàkal naa baar bàfàtɛn ndaa aŋàbwaŋ mpɛl akà bɛ, ntɔn bànkaa aba bàkyerà abà akà aŋangɔɔm a loor. ");
INSERT INTO yns_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","« Wɛɛ bɛ baar banswà làweemà mɛ, mɛɛ alàkyään abà: Lakwen ayiiŋ abɛ, làkyer ubwaŋ akà baar bàfàlakyer ube, ");
INSERT INTO yns_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","làfuum làpɛɛm akà baar bàfàlaküül anà làyamà ntɔn baar bàfàlatwee. ");
INSERT INTO yns_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Isàkal naa mbuur kàmapà mbar u twam, fàlɛɛ twam lumwɛy. Isàkal naa mbuur kan'gyɔɔr inkur angye, twon amun'tsuŋ muwal kàzak angye. ");
INSERT INTO yns_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pà akà mbuur wanswà kan'lɔm, wɛɛ twon an'lɔm undiir angye akà mbuur kan'gyɔɔr wa. ");
INSERT INTO yns_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Undiir wanswà akwen ngye naa baar bàkyer akà ngye, kyer abun sye akà baar bumwɛy. ");
INSERT INTO yns_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Isàkal naa ngye afàkwen baar bàfakwen, ngye bweel nà an'wal uboo kwo? Baar abɛ sye bàfàkwen baar bàfakwen. ");
INSERT INTO yns_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Isàkal naa ngye ubwaŋ afàkyer akà baar bàfakyer ubwaŋ, ngye bweel nà an'wal uboo kwo? Baar abɛ sye bàfàkyer abun. ");
INSERT INTO yns_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Isàkal naa ngye afàsɔɔm baar an'sà ngye làkyän naa ba bàkyer asafuur, bweel nà ngye an'wal? Ntɔn baar abɛ sye bàfàpà akà baar abɛ ntɔn ba sye bàfàwal asànaa ban'pà ba. ");
INSERT INTO yns_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Làkwen ayiiŋ abɛ, làkyer ubwaŋ, làpɛ ukɔɔn adil bweel. Waa bweel abɛ làsàkal làkölàköl, bɛ sye làsàkal baan a Mwol a du, ntɔn nde afàswaŋ ubwaŋ ande akà baar bàfàfuur ube kà ikal a ubwaŋ anà akà baar abɛ. ");
INSERT INTO yns_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Làkäl baar aŋàyɔl a ukwen ntɔn Taaràbɛ wàŋàyɔl a ukwen. » ");
INSERT INTO yns_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","« Twon lan'tsüül baar nsaŋ, waa bɛ sye mpa bàsàlatsüül nsaŋ. Twon lan'pà baar ikwàndwà, waa bɛ sye mpa bàsàlapà ikwàndwà. Làdwääl nkul, waa bɛ sye bàsàladwääl nkul. ");
INSERT INTO yns_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Làpɛ, waa bɛ bàsàlapà: bàsàyööl mpàkɔr a kölàköl a ipfɛy abɛ a mbäl aŋàbwaŋ, yàŋàkinà, yàŋàndyeer, yàŋàpää. Ntɔn Nzam an'kab ande akà bɛ nde asàsi unsà isii làfàsyääl bɛ ntɔn baar bumwɛy. » ");
INSERT INTO yns_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yɛsu kàfàtɛn a ba u itim naa: « Nkye ikwàmii kan'kwo musyen ikwàmii wumwɛy? Nkye ba bàbɔ̈ɔ̈l bàkàbwà anki u fu? ");
INSERT INTO yns_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Un'lɔŋki ukwe anki mulyaaŋ un'lɔɔŋ ande. Wɛɛ un'lɔŋki afàsyääl ndaa a un'lɔɔŋ ande afàbulà asànaa un'lɔɔŋ ande. ");
INSERT INTO yns_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ntɔn nkye amanà ngye isɛrà a un'lɛŋ akyà u dii a un'tɔŋ angye, wɛ ngye amanà anki kyɔɔl là u dii angye? ");
INSERT INTO yns_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ngye an'kwo aben mutɛn a un'tɔŋ angye naa: \"Un'tɔŋ, yà mɛ alwom isɛrà a un'lɛŋ ki u dii angye\", ngye mbuur mpa akamanà kyɔɔl alà u dii angye? Mbuur a mpem yweel, twab atàlwom kyɔɔl là u dii angye, ungö apan ngye waa ayàman ubwaŋàbwaŋ ntɔn ngye alwom isɛrà a un'lɛŋ ki u dii a un'tɔŋ angye. » ");
INSERT INTO yns_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yɛsu kàfàtɛn naa: « Un'te aŋàbwaŋ ufàbɔr anki mbɛŋ ambe, un'te un'be sye ufàbɔr anki mbɛŋ aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ntɔn un'te wanswà bàfàyöb unsà mbɛŋ a wa. Fige bàfàkwol anki unsà ibwiy a nsyeenà, rɛzɛ sye bàfàbwo anki u mikyɛl. ");
INSERT INTO yns_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mbuur aŋàbwaŋ afàwal ndaa aŋàbwaŋ unsà an'kyän aŋàbwaŋ màfàtoo u mpem ande, wɛɛ mbuur un'be afàwal ndaa a mbe unsà an'kyän ande mube. Ntɔn ndaa yanswà ufàtɛn mbuur ifàfà u mpem ande. » ");
INSERT INTO yns_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","« Wɛɛ Ntɔn nkye lan'beelà bɛ naa Mwol, Mwol, wɛɛ bɛ ndaa amɛ làfàlab anki? ");
INSERT INTO yns_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mɛ in'kyer ayàlàswaŋ naa mbuur afàwem ndaa amɛ anà afàsyääl ya, nde wà nà: ");
INSERT INTO yns_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nde wà asànaa mbuur kàkwen mutoŋ ndwà ande, kàkyer atim, ufàtim, waa kàmɛn nkɔŋ ntɔn musà un'bään a ntööŋ udu a nkɔŋ ayi. Mbul a ngwal kànɔ̈ wa, un'pöb a ngwal kàni wa ndwà ayin, wɛɛ ndwà ayin yàbü anki ntɔn ya bàtɔ̈ŋ udu a nkɔŋ. ");
INSERT INTO yns_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wɛɛ mbuur afàwem ndaa amɛ wɛɛ nde ya ufàsyääl anki, wà asànaa mbuur kàtɔ̈ŋ ndwà ande udu a ansɛŋ ukɔɔn un'bään, ibɔɔ a an'dà laa byà ni bya ndwà ayin, laa yàbwabà ya. » ");
INSERT INTO yns_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ungö mutɛn a baar ndaa yanswà kàkwen nde mutɛn, Yɛsu kàkyen Kapɛrnawum. ");
INSERT INTO yns_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Un'tsüüŋ a kaptɛn mwɛy aŋità a Lɔmà kàfakweenà nde mbɔɔn kàkäl anà ukyal, tsütsü mukwà. ");
INSERT INTO yns_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mpal kàwem nde làsaŋ a Yɛsu, nde kàtöm abyääl a Ayudà ntɔn ba bàkun'bɔɔn naa nde uyàkɔɔr un'tsüüŋ ande. ");
INSERT INTO yns_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ba waa bàyi akà Yɛsu, bun'bɔ̈ɔ̈n, waa bàtɛn naa: « Mbuur wà kan'kwo muwal bweel aŋàkwo, ");
INSERT INTO yns_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ntɔn nde afàkwen nsi abi, nde sye kàtöŋ ndwà a nköŋ abi a ngim ande ŋakwo. » ");
INSERT INTO yns_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yɛsu kàkyen anà ba. Mpal kàkäl nde tsütsü a ndwà a mbuur awun, mbuur wa kàtɔ̈m asam ande ntɔn mutɛn naa: « Mwol, twon an'pà ndür ngye mpay. Mɛ in'wà mbuur a man'be, mɛ in'kwe anki muwal ngye u ndwà amɛ. ");
INSERT INTO yns_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Lalan mpa in'yi mɛ, mɛ ŋakwo. Tɛn ngɔk mwɛy ntɔn un'tsüüŋ amɛ ukɔɔrà. ");
INSERT INTO yns_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ntɔn mɛ ŋakwo in'wà mfum u ngyɛl, wɛɛ mɛ in'we anà aŋità in'fàler mɛ, mɛ in'sàtɛn a umwɛy naa: \"Kyen\", laa ukyà nde. Mɛ in'sàtɛn a wàsin naa: \"Yà\", laa uyà nde. Mɛ in'sàtɛn a un'tsüüŋ amɛ naa: \"Kyer abà\", laa ukyer nde. » ");
INSERT INTO yns_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mpal kàwem Yɛsu ndaa ayi, nde kàkyey kaptɛn awà, waa ubulà, uler baar banswà bàyun'labà, waa kàtɛn naa: « Mɛ, mɛ alàkyään, itàkal kà Isàlɛl mɛ ŋàtàman anki làkwikilà a mbɔɔn abà. » ");
INSERT INTO yns_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Baar kàtöm kaptɛn, bàfurà ba ndwà ande, ba bàmɛn un'tsüüŋ ande wàŋàkɔɔrà. ");
INSERT INTO yns_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yàkäl naa ilä kyàlääb pa, Yɛsu kàkyen bul mwey ikɔb a la Nayin. Alɔŋki ande anà un'sɛŋ a baar bàkäl mukyà anà nde. ");
INSERT INTO yns_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mpal kàkäl nde tsütsü a bul alan, iköŋ a baar kyàkäl mukàdyee ndom, mwan baal mwɛy mpɛl wà un'kweel a un'dim mwɛy. Baar a bul alan mbɔɔn bàkäl anà nde. ");
INSERT INTO yns_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mpal kun'mɛn Mwol, ngyɛb yàkyer un'käär, waa kun'kyään naa: « Twon an'lel! » ");
INSERT INTO yns_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nde kàsin tsütsü a un'böl, waa kàbä wa. Baar bàyisyeenà wa laa bàmbär ba. Nde waa kàtɛn naa: « Mwan baal, mɛ amaswaŋ, wiyà! » ");
INSERT INTO yns_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ndom waa ubwaay, waa usɛmà muyäm. Yɛsu waa kun'fuur akà ngwän. ");
INSERT INTO yns_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Baar banswà bàkäl u bɔɔmà anà musyäŋà Nzam, waa bàtɛɛnà naa: « Ŋangɔɔm a kölàköl kan'too uboo a bi, Nzam kan'yàbay baar ande. » ");
INSERT INTO yns_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Làsaŋ a Yɛsu alà làkyer apää u Yuday lanswà anà kà an'bul a tsütsü manswà. ");
INSERT INTO yns_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Alɔŋki a Ywan bàkyer un'kyäänà ndaa ayi. ");
INSERT INTO yns_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nde kàbel abɔ̈ɔ̈l uboo a ba, waa katöm akà Mwol ntɔn ba bun'fuul naa: « Nkye ngye awà Klistɔ awà ayàyà, lɛɛ bi ikyer adil wàsin? » ");
INSERT INTO yns_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mpal bàkɔlà ba apà Yɛsu, ba bàtɛn a nde naa: « Ywan Un'düümà kàmitɔm akà ngye ntɔn muyöb naa nkye ngye awà mbuur awayàyà, lɛɛ bi ikyer adil wàsin? » ");
INSERT INTO yns_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Taaŋ nsil alan, Yɛsu waa ukɔɔr baar a an'kyal mbɔɔn, baar bàkäl anà an'too anà baar bàkäl anà an'dweelà an'be, waa uduub mii a ikwàmii mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nde kafuur abà: « Kàlun'kyään Ywan ndaa yanswà lan'man anà lan'wem bɛ: Ikwàmii bàmuman, ikar bàmumbarà, baar a ukyal a bay bàmupɔŋà, ikwan'tsü bàmuwem, ndom yàmuwiyà, ndaa a Nzam bàmulɔŋ akà aŋàlàmbwà. ");
INSERT INTO yns_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Un'sak akà mbuur mpa asàpiy làkwikilà ande amu mɛ. » ");
INSERT INTO yns_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ungö a nkyeen a alɔŋki a Ywan, Yɛsu kàsɛmà mutà imbäl a Ywan: « Bɛ ininà làkàler u nsye a ipɔl? Kite a iful kànini un'pöb? ");
INSERT INTO yns_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Wɛɛ bɛ ininà làkàler? Mbuur kàbwäärà a ntwɛn? Làler, baar bàfàbwaar ipfɛy a ntal anà bàfàkal unsà un'naaŋ, bàfàkal uboo a ndwà a amfum. ");
INSERT INTO yns_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bɛ ininà làkàler? Ŋangɔɔm mwɛy? Ndandaa mɛ alàkyään, nde kan'söön ŋangɔɔm. ");
INSERT INTO yns_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nde wà mbuur awà bàsön naa: \"Le, mɛ an'tɔm un'kyeey amɛ kusà angye, ntɔn muyilà mbwo angye kusà a ngye.\" ");
INSERT INTO yns_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","« Mɛ alàkyään naa uboo a baar banswà kàbör un'kaar, akà umwɛy kàmusöön watɛy. Wɛɛ kimbuur ikikye uboo a Imwol a Nzam kàmun'söön. » ");
INSERT INTO yns_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Baar banswà bàweemà ndaa ande, itàkal afüür a itɛr, bàkyer akyey naa Nzam wà balàbal, lalan bàkyeenà ba mukàwal ndüümà a Ywan. ");
INSERT INTO yns_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wɛɛ amfarisi anà alɔɔŋ a Un'kɔɔn bàtön ndaa kàkwen Nzam ntɔn ba anà ndüümà a Ywan. ");
INSERT INTO yns_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yɛsu kàfàtɛn naa: « Mɛ baar a taaŋ alà an'kwo mukasi anà nà? Ba bà asànaa bànà? ");
INSERT INTO yns_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ba bà asànaa baan bàfàmbàmbar u balàbal anà bàfàtɛn ba a ba naa: Bi kàlabɛɛrà mfuŋ, wɛɛ bɛ làkyen anki, bi kàlàtɔ̈ɔ̈l an'diim a ilel, wɛɛ bɛ làlel anki. ");
INSERT INTO yns_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ntɔn Ywan Un'düümà kàkyer ayà, kàdyee anki nsɔ, kànwee anki man, wɛɛ bɛ làtɛɛnà naa: Nde we anà dweelà a làbe. ");
INSERT INTO yns_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwan a mbuur kan'yà, akyer adyà, akyer anwà, wɛɛ bɛ làtɛn naa: \"Awà wà ndyeel anà un'nweel a man, un'sam a afüür a itɛr anà baar a man'be.\" ");
INSERT INTO yns_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wɛɛ an'yeerà a Nzam, baar bàfàman naa ma màbalàbal bà baar bàfàkyey ma. » ");
INSERT INTO yns_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yàmɛnà naa umfarisi mwɛy kàbel Yɛsu mukàdyà u ndwà ande. Yɛsu kàbilà nde u ndwà a mbuur awun, waa kàsɛmà mudyà u mɛsà. ");
INSERT INTO yns_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","U bul alan kàkäl anà un'kaar a pasàsɛ mwɛy. Mpal kàwem nde naa Yɛsu wàmudyà u ndwà a mbuur awun, nde kàyàbilà anà làbuuŋ a pɛɛl làŋàyɔl a may a usɔŋ, ");
INSERT INTO yns_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","nde kàbü ungö a Yɛsu kà in'kɔl ande. Nde kàkäl mulel, nsaaŋ ande yàbwee kà in'kɔl a Yɛsu, waa kàkɔɔmà ya a ntswe ande, kàndüürà mya, waa kàkiirà mya may a usɔŋ. ");
INSERT INTO yns_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Un'mfarisi awà kàbel Yɛsu u ndwà ande kàmɛn nde abun, laa kàyweerà nde u mpem naa: « Mbuur wà ulàkal ŋangɔɔm a ndandaa, nde akyer alàyöb naa un'kaar awà wà nà, nde akyer alàyöb naa nde wà un'kaar a pasàsɛ. » ");
INSERT INTO yns_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yɛsu kun'fuur u ndaa a dudu naa: « Simɔn, mɛ in'we anà kindaa muyäm anà ngye. » Nde kàfuur naa: « Un'lɔɔŋ, yäm. » ");
INSERT INTO yns_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yɛsu naa: « Ilä mwɛy un'pɛɛl a nkul mwɛy kàkäl anà asɔ̈ɔ̈m abɔ̈ɔ̈l. Wàtàtwɛb kàlun'fuur an'falà nkam tyeen, wàyweel an'falà an'kwem an'tyeen. ");
INSERT INTO yns_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Baar abà bàbɔ̈ɔ̈l bàkäl anki anà ngim mukun'fuur. Nde waa kadwääl nkul. Uboo a baar abà bàbɔ̈ɔ̈l, nà ayun'kwen aŋàsöön? » ");
INSERT INTO yns_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔn kun'fuur naa: « Mɛ in'kasii naa mbuur awà kàdwääl nde nkul a mbɔɔn. » Yɛsu naa: « An'man, ngye an'yweer ubwaŋ. » ");
INSERT INTO yns_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ungö apan, Yɛsu waa uler un'kaar awun, waa utɛn a Simɔn naa: « Ngye akyun'manà un'kaar wà? In'bilà mɛ u ndwà angye, ngye an'dà an'pɛ anki muywɛy in'kɔl, wɛɛ nde, nde mya kan'ywɛy a nsaaŋ ande anà kan'kɔɔm mya a ntswe ande. ");
INSERT INTO yns_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ngye mɛ andüür anki, wɛɛ nde, sɛmà in'bilà mɛ nde uyɔ̈n anki mundüür in'kɔl amɛ. ");
INSERT INTO yns_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ngye mɛ may a usɔŋ an'tsüül anki kun'tswe, wɛɛ nde, nde kan'tsuul may a usɔŋ kà in'kɔl amɛ. ");
INSERT INTO yns_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Lalan mɛ akyään naa bàkyun'dwääl nkul a man'be ande manswà, ntɔn nde kan'kwen mbɔɔn. Wɛɛ mbuur akwà bàmun'dwääl nkul a man'be ikikye, nde akwen sye ikikye. » ");
INSERT INTO yns_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Waa nde kàtɛn a un'kaar awun naa: « Mɛ amadwääl nkul a man'be angye. » ");
INSERT INTO yns_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Baar bumwɛy bàkäl anà nde bàtɛɛnà u mpem naa: « Mbuur awà wà nà, nde mudwääl baar nkul a man'be aba? » ");
INSERT INTO yns_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Waa Yɛsu kàtɛn a un'kaar awun naa: « Làkwikilà angye làmatswà mɔ̈ɔ̈, kyen unsà duu. » ");
INSERT INTO yns_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yàkäl naa ungö a an'taaŋ, Yɛsu kàkyen uboo a an'bul a kölàköl anà an'bul ikikye ntɔn mulɔŋ anà mupay làsaŋ a Ndaa Aŋàbwaŋ yà Imwol a Nzam, alɔŋki bàkwem aŋiyweel bàkäl anà nde ");
INSERT INTO yns_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","anà akaar amwɛy kàkɔɔr nde unsà an'dweelà an'be anà an'kyal mà ifà ifà: Màlye bàfabeelà un'nsi Magàdala, uboo ande insɔŋà nsambwaar myàtoo, ");
INSERT INTO yns_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zyan, un'kyay a Shuzà mbuur a isal a Ɛlɔdi, Suzan, anà akaar asin bàyibayà Yɛsu anà alɔŋki ande unsà indiir aba. ");
INSERT INTO yns_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Baar mbɔɔn bàfü an'bul a kölàköl bàyàköŋ apà Yɛsu. Nde katɛɛl nsim yi: ");
INSERT INTO yns_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","« Un'köön mwɛy kàtoo mukàkɔn mbɛŋ ande. Umpal kàmwɛŋ nde ya, yar làmwɛy làbü u mbwo: baar bàndyaar ya, nɛn a du waa yàdi ya. ");
INSERT INTO yns_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yar lumwɛy làbü udu a nkɔŋ: mpal yàmɛn ya, bite laa byàyöm bya, ntɔn mɛɛn màkäl màŋàyɔm. ");
INSERT INTO yns_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yar lumwɛy làbü uboo a nsyeenà: nsyeenà yàyɛl mbwo mwɛy anà in'te, waa yàfwee mya. ");
INSERT INTO yns_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yar lumwɛy làbü u mɛn aŋàbwaŋ: mpal làyɛl la, la làbör mbɛŋ mbɔɔn: imbɛŋ mwɛy kyàbör mbɛŋ nkam anà nkam. » Yɛsu waa kàkwɛy abà: « Wɛy mbuur awe anà an'tsü awem uwem. » ");
INSERT INTO yns_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Alɔŋki ande bun'fuul naa nsim ayi iswaŋà aben. ");
INSERT INTO yns_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nde kafuur naa: « Bweel a bɛ là naa bɛ làkyàyöb ngyee a imwol a Nzam, wɛ akà baar bumwɛy, ndaa ayi bàfakyään unsà nsim. Ntɔn, \"itàkal naa ba bàkyer aleerà, ba bàkɔ̈ɔ̈n aman, \"itàkal naa ba bàkyer aweemà, ba bàkɔ̈ɔ̈n ayöb.\" » ");
INSERT INTO yns_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","« Mpalàbà làwem mbuul a nsim ayi: Mbɛŋ yà ndaa a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kɔl a mbwo, là baar bàfàwem ndaa a Nzam, wɛɛ Satanà waa uyàlwom ya u mpem aba ntɔn ba bàkɔ̈ɔ̈n asà làkwikilà anà bàkɔ̈ɔ̈n awà möö. ");
INSERT INTO yns_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Udu a nkɔŋ yà baar bàfàwem ndaa a Nzam anà bàfàwal ya unsà un'sak, wɛɛ ba ya bàfàkaar anki u mpem aba, làkwikilà aba bwɛl latɛy. La in'swɛy myatɛy, isàkal naa mpay yan'yà, ba ban'piy làkwikilà aba. ");
INSERT INTO yns_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbɛŋ yàbü u nsyeenà yà baar bàfàwem ndaa a Nzam, wɛɛ ba ya bàfàküünà a mpay anà ngyal a indiir a mɛɛn. Abun ya ifàbɔr anki mbɛŋ. ");
INSERT INTO yns_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbɛŋ yàbü u mɛn aŋàbwaŋ yà baar bàfàwem ndaa a Nzam anà bàfàwal ya unsà un'sak, bàfàkaar ya u mpem aba anà bàfàsyääl ya. Ya ifàbɔr mbɛŋ. » ");
INSERT INTO yns_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yɛsu kàläb abà: « Akà mbuur mwey ukwe anki mukyä mwinà waa ukümà wa kantin, itàkal usi wa ungyɛl a itäb. Wɛɛ nde wa asà udu a ikɔlà a un'te ntɔn baar bàbilà u ndwà bàmɛn pɛɛlà. ");
INSERT INTO yns_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Undiir wanswà wàŋàyee ŋàbawà, akyer asàmɛnà u pɛɛlà. Undiir wanswà wà unku, baar bàkyer asàyöb wa, wa sye asàmɛnà u leŋ. ");
INSERT INTO yns_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Làlɛɛ an'tsü abɛ ntɔn muwem ubwaŋàbwaŋ, ntɔn bàsàkwɛy akà mbuur awe anà undiir, wɛ akà mbuur mpa awe anà undiir bàsàlwom undiir ufàsi nde naa nde we anà wa. » ");
INSERT INTO yns_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yàmɛnà naa ngwän anà atɔŋ a Yɛsu bàyi muyàbwey anà nde, wɛɛ yàkäl mpay ba mukun'man ntɔn baar bàkäl mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Baar bun'kyään naa: « Ngwa anà atɔŋ angye bà unsà, ba bàkwen mukaman. » ");
INSERT INTO yns_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nde kafuur naa: « Maa anà atɔŋ amɛ bà baar bàfàwem ndaa a Nzam anà bàfàsyääl ya. » ");
INSERT INTO yns_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yàlɔ̈m naa ilä mwɛy, Yɛsu kàbilà u bwaar a kölàköl anà alɔŋki ande, waa kàtɛn a ba naa: « Tsweenà bi isabà sim a ɛwà. » Ba waa bàkyen. ");
INSERT INTO yns_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mpal bàkäl ba mubweel, Yɛsu waa kàbɔ̈ɔ̈n. Kà imbürà, un'pöb a ngwal kàyi udu a ɛwà. An'dà waa màsɛmà mubilà u bwaar, ba bàkäl u mpay a ukwà. ");
INSERT INTO yns_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Alɔŋki bàsin tsütsü apà Yɛsu, waa bun'wiy anà in'kwɛŋ u mun: « Un'lɔɔŋ, Un'lɔɔŋ, bi abà ikwà! » Nde waa usubà, waa uŋän un'pöb anà ibɔ a kölàköl byà an'dà: bya waa byàkwamà, duu waa làbilà. ");
INSERT INTO yns_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Apan, Yɛsu kàtɛn a alɔŋki ande naa: « Làkwikilà abɛ làken? » Wɛɛ ba bàkäl u bɔɔmà anà unsà ubem, ba bàtɛɛnà ba a ba naa: « Baal awà wà nà? Nde wàmuŋän un'pöb anà ibɔ a an'dà, bya sye byàmukun'weemà. » ");
INSERT INTO yns_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ba bàkɔlà u mɛɛn a Ngɛlàsà u sim a Ngalilɛ. ");
INSERT INTO yns_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pa kàtɔ̈l Yɛsu làkɔl u mɛɛn, mbuur mwɛy wà bul alan kàkäl anà insɔŋà mbɔɔn, nde kàyi akà Yɛsu. Sɛmà itaan nde kàkälà nsàpɔl. Nde kàkweenà anki mukal u ndwà, nde kàfabwaayà uboboo a an'dii. ");
INSERT INTO yns_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mpal kàmɛn nde Yɛsu, nde kabü kà in'kɔl ande, waa kàlal in'kwɛŋ mutɛn u ndaa a ngwal naa: « Yɛsu, Mwan a Nzam a Dudu, mɛ anà ngye un'tüüb nà? Mɛ amabɔɔn, twon aman'pà mpay. » ");
INSERT INTO yns_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yɛsu waa kàböŋ insɔŋà myàkäl uboo a mbuur awà. Ntɔn mya myun'bilà itaan. Ba bàfun'bäämà an'dwaaŋ anà impaaŋ a in'te kà an'kɔɔ anà kà in'kɔl ntɔn nde ukɔ̈ɔ̈n atiin. Wɛɛ nde kàkyer afatsuulà mya myanswà, insɔŋà myun'syeenà u nsye a ipɔl. ");
INSERT INTO yns_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yɛsu waa kun'fuul naa: « Ikɔb angye nà? » Nde kàfuur naa: « Un'kàbɔ. » Ntɔn insɔŋà mbɔɔn myàbilà amu ande. ");
INSERT INTO yns_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Insɔŋà amin myàbɔ̈ɔ̈n Yɛsu naa nde ukɔ̈ɔ̈n akatɔm uboo a un'baan. ");
INSERT INTO yns_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wɛɛ tsütsü apan làkäl anà làböl a ngul làmuyidyà udu a mɔŋ, lalan myàlɔ̈m mya akà Yɛsu naa mya myàbilà uboo a ngul. Nde waa kapɛ mbwo. ");
INSERT INTO yns_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Apan, insɔŋà myàtoo mya unsà mbuur awun, mya myàbilà u ngul ayin, làböl a ngul waa làparà ntiin fà iköl a mɔŋ, laa làkàbwà la kà an'dà, waa làminà. ");
INSERT INTO yns_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aseey bàmɛn ba abun, laa bàtiin ba, bàkyen ba mukàpay làsaŋ kà an'bul anà kà itsuŋ a ndwà. ");
INSERT INTO yns_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Baar bàyi ntɔn muyöb naa ya yàlyaaŋ aben. Mpal bàyàtol ba tsütsü apà Yɛsu, bàmɛn ba ŋukɔŋ akyàbwaay kà in'kɔl a Yɛsu, akyàbwaar, akyàkal a duu, ba bàmɛn bɔɔmà. ");
INSERT INTO yns_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Baar bàkäl paa mpal kàkɔɔr nde ŋukɔŋ, bàkyäänà baar naa nde kun'kɔɔr aben. ");
INSERT INTO yns_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kyakin baar a Ngɛlàsa banswà bàkäl ba u bɔɔmà, waa bàlɔ̈m akà Yɛsu mulwomà apà ba. Nde kàbilà u bwaar ntɔn mufurà. ");
INSERT INTO yns_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mbuur awà kàkɔɔrà unsà an'dweelà an'be kàlɔ̈m akà Yɛsu naa nde uyilyaaŋ anà nde, wɛɛ Yɛsu kun'fuur naa: ");
INSERT INTO yns_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","« Furà ndwà angye, kyen kakyään ndaa yanswà kan'kyer Nzam akà ngye. » Lalan mbuur awà kàkàpay nde làsaŋ a ndaa yanswà kàkyer Yɛsu akà nde u bul lanswà. ");
INSERT INTO yns_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mpal kàfurà Yɛsu Ngalilɛ, baar banswà bun'wɛl unsà ubwaŋ banswà, ntɔn ba bàkäl mukun'dilà. ");
INSERT INTO yns_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Apan mbuur mwɛy ikɔb ande Zayirɔs laa kàyi nde. Nde kàkäl mfum a ndwà a nköŋ a Ayudà. Nde kàbü kà in'kɔl a Yɛsu, waa kun'bɔ̈ɔ̈n naa nde ukyen ndwà ande: ");
INSERT INTO yns_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","mwan ande mwɛy mpɛl wà un'kaar wà tsütsü mbul kwem aŋiyweel kàkäl musyäämà mɔ̈ɔ̈. Yɛsu waa kàkyen ndwà a mbuur awun. Apan, baar mbɔɔn bàyibääbà u mbil a ndür ande. ");
INSERT INTO yns_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Uboo a baar aban kàkäl anà un'kaar mwɛy kàyimanà an'kil mbul kwem aŋiyweel. Nde kàdwä ngim mbɔɔn akà angaŋ, wɛɛ nde kàkɔɔra anki. ");
INSERT INTO yns_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nde kàsin tsütsü ungö a Yɛsu, waa kun'bä u làpan a ipfɛy ande. Taaŋ nsil alan an'kil laa màtsü ma mutoo. ");
INSERT INTO yns_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yɛsu waa kàfuul naa: « Nà kàman'ba? » Wɛɛ akà mbuur mwɛy kàkyey anki. Petɔlà waa kàtɛn a nde naa: « Ambà Un'lɔɔŋ, baar bàmasà uboboo, bà mbɔɔn bà imbäm'dir anà ngye. » ");
INSERT INTO yns_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nde waa kàtɛn naa: « Mbuur akyer an'ba: mɛ in'kyer awem naa dweelà a ngwal mwɛy lan'too u ndür amɛ. » ");
INSERT INTO yns_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Un'kaar awun kàmɛn nde naa undiir kàkyer nde kan'mɛnà u mii a baar, laa kàsin nde tsütsü apà Yɛsu, kàbü nde kà inkɔl ande, waa kàtɛn u mii a baar ntɔn nkye kun'bä nde anà muswaŋ naa taaŋ nsil alan nde waa kàkɔɔrà. ");
INSERT INTO yns_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yɛsu kàtɛn a nde naa: « Mangwa, làkwikilà angye làmatswà mɔ̈ɔ̈, kyen unsà duu. » ");
INSERT INTO yns_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nde kàkäl anki aŋàtàmay mutɛn mpal kàyi mbuur kàfü ndwà a mfum a ndwà a nköŋ a Ayudà. Waa kun'kyään naa: « Mwan angye wà unkaar kan'kwà, twon afun'twääl Un'lɔɔŋ nkwom. » ");
INSERT INTO yns_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mpal kàwem Yɛsu abwɛy, nde kàtɛn a Zayirɔs naa: « Twon an'man bɔɔmà, sà làkwikilà mpɛl, mwan angye akyer akɔɔrà. » ");
INSERT INTO yns_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mpal kàkɔlà nde, Yɛsu kàkwen anki naa baar asin bàbilà u ndwà, wɛ Petɔlà, Ywan, Zyak, taar anà ngwän a mwan mpɛl. ");
INSERT INTO yns_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ntsü yanswà baar bàkäl mulel. Yɛsu waa kàtɛn naa: « Twon lan'lel, nde ukü anki, nde kan'bɔ̈ɔ̈n twaal. » ");
INSERT INTO yns_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wɛɛ ba bàkyer un'sɛɛ, ntɔn ba bàkyer ayöbà naa nde kàkäl aŋàkwà. ");
INSERT INTO yns_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Apan, Yɛsu kàtɛ kɔɔ a kimwan un'kaar awun mpi, waa kàtɛn a nde u ndaa a ngwal naa: « Mwan amɛ, wiyà! » ");
INSERT INTO yns_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Laa kàwiyà nde, waa kàmbarà. Yɛsu kàswɛŋ naa ba bun'pɛ udyà. ");
INSERT INTO yns_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aböör a mwan un'kaar awun matɛɛr màkyer awal. Wɛɛ Yɛsu katsüŋ mukyään mbuur asin ndaa ayin. ");
INSERT INTO yns_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yɛsu kàtüüb antööm bàkwem aŋiyweel, waa kapɛ ngwal anà ikɔ̈b muböŋ insɔŋà myanswà anà mukɔɔr an'kyal. ");
INSERT INTO yns_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ungö apan, waa katöm mukàpay làsaŋ a Imwol a Nzam anà mukɔɔr an'kyal. ");
INSERT INTO yns_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nde kàtɛn a ba naa: « Twon lan'wal undiir ntɔn mbwo: itàkal unsɔk, itàkal ngɔɔr, itàkal isaa, itàkal ngim. Twon lan'syen inkur byeel. ");
INSERT INTO yns_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Isàkal naa bàmàlawal u ndwà mwɛy, làbwaay apan tii taaŋ làsàlwomà bɛ kà ikal akin. ");
INSERT INTO yns_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Isàkal naa mbuur kàlawɛl anki, làlwomà u bul alan, sàlàkɔɔb un'twà a in'kɔl abɛ: kya isàkal imbäl ibe ntɔn ba. » ");
INSERT INTO yns_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Apan, alɔŋki bàkyen ba, ba bàyilyaaŋà bul a bul muyikyään Làsaŋ Aŋàbwaŋ anà muyikɔɔr abɛy. ");
INSERT INTO yns_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mfum Ɛlɔdi kàwem nde ndaa ayi yanswà, nde kàyweerà naa nde akyer aben. Ntɔn baar mbɔɔn bàtɛɛnà naa Ywan kan'wiyà, ");
INSERT INTO yns_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","bumwɛy naa Ԑlya kan'fàmɛnà, wɛɛ bumwɛy naa umwɛy uboo a aŋangɔɔm bà itaan kan'wiyà. ");
INSERT INTO yns_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Wɛɛ Ɛlɔdi kàtɛɛnà naa: « Mɛ Ywan kàkyun'tsul un'tswe: nà mbuur wa in'fiweemà mɛ làsaŋ a tub lalɛy? » Nde kàleŋà mukun'man. ");
INSERT INTO yns_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mpal bàyàfurà antööm, ba bàkyäänà Yɛsu indiir byanswà bàkyer ba. Nde kawɛl, waa kasyen ukɔl, u bul mwɛy ikɔb a la Bɛtesayidà. ");
INSERT INTO yns_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Baar mbɔɔn bàyöb ba naa Yɛsu anà alɔŋki ande bà u bul alan, laa baläb ba. Yɛsu kawɛl nde, laa kakyäänà nde ndaa a imwol a Nzam. Nde kàkɔɔr sye baar bàkäl anà ngyal akɔɔrà. ");
INSERT INTO yns_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mpal bàmɛn antööm bàkwem aŋiyweel naa taaŋ lan'sɛmà muminà, ba bàsin tsütsü apà Yɛsu, waa bun'kyään naa: « Apay baar, ba bàkyen kà an'bul anà u bitsuŋ a ndwà byà tsütsü ntɔn ba bàkàleŋ ikal abɔ̈ɔ̈n anà isaa adyà ntɔn bi apà ibà u nsye a ipɔl. » ");
INSERT INTO yns_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yɛsu waa kafuur naa: « La pɛ udyà bɛ ŋakwo. » Ba waa bun'fuur naa: « Bi iwe amà mampà tyeen anà nsö yweel, tɛn naa bi ŋakwo ikàsom isaa ntɔn mbul a baar wà. » ");
INSERT INTO yns_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Abaal bàkäl isii a nsaab tyeen. Yɛsu naa: « Làswɛŋ baar bàbwaay an'kwem an'tyeen, an'kwem an'tyeen. » ");
INSERT INTO yns_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ba bàkyer abun, bàpɛ baar banswà ikal abwaay. ");
INSERT INTO yns_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yɛsu kàwɛl mampà mà an'tyeen anà nsö yàyweel, waa kàler u du, kàfuur an'tɔɔn akà Nzam. Ungö apan waa kàtsül mampà anà nsö, waa kàpɛ alɔŋki ande ntɔn mupà akà baar banswà. ");
INSERT INTO yns_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Baar banswà waa bàdi, bàyüür. Itiir a mampà byàsäl mbɔↄn, bya byàyööl in'lwaŋ kwem aŋiyweel. ");
INSERT INTO yns_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ilä mwɛy Yɛsu kàkäl muyamà u mpey anà alɔŋki ande, waa kafuul naa: « Baar bàfàtɛn naa mɛ in'wà nà? » ");
INSERT INTO yns_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ba bàfuur naa: « Ywan Un'düümà, bumwɛy, Ԑlya, bumwɛy, umwɛy uboo a aŋangɔɔm kan'wiyà. » ");
INSERT INTO yns_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nde waa kafuul naa: « Wɛɛ bɛ ŋakwo làtɛn naa mɛ in'wà nà? » Petɔlà waa kàfuur naa: « Ngye awà Klistɔ a Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yɛsu katsüŋ mukyään mbuur akà ikikye. ");
INSERT INTO yns_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nde waa kàfàkwɛy naa: « Mwan a mbuur akyer aman mpay mbɔɔn. Andweer, amfum a angaŋ anà alɔɔŋ a in'kɔɔn bàkyer un'tɔn, bàkyer un'dwa, waa ilä kyàtär nde akyer awiyà. » ");
INSERT INTO yns_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ungö, nde waa kàtɛn akà baar banswà: « Isàkal naa mbuur akwen mukan'lab, wɛy nde ukɔɔb ndür ande, usɛn buur ande ilä byanswà, wɛy nde kan'läb. ");
INSERT INTO yns_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ntɔn mbuur usàkwen muyee möö ande, wa asàkyà bwà. Wɛɛ mbuur usàpiy möö ande ntɔn mɛ, nde asàtswà wa. ");
INSERT INTO yns_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bweel nà mbuur kan'kwo muwal isàkal naa nde kan'wal mɛɛn manswà, wɛɛ mɔ̈ɔ̈ ande ukyà bwà? ");
INSERT INTO yns_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mbuur usàwem mɛ nswɛn anà ndaa amɛ, Mwan a mbuur sye asun'wem nswɛn mpal usàyà nde unsà làkoo ande anà là Taa anà là akyeey in'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ndandaa mɛ alàkyään, bàmbɔɔn uboo abɛ bàyàkal aŋàtàkwà anki kusà muman Imwol a Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kà isii a ilä naan ungö a ndaa ayi, Yɛsu kàwɛl Petɔlà, Ywan anà Zyak, nde kàlär udu a mɔŋ ntɔn mukàyamà. ");
INSERT INTO yns_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mpal kàkäl nde muyamà, ntabwey ande waa yàsɔɔmà, ipfɛy ande kyàbulà kyà in'ŋyäŋ a pɛɛl. ");
INSERT INTO yns_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Apan, baar bɔ̈ɔ̈l bàkäl muyääm anà nde, ba bàkäl Mɔsɛ anà Ԑlya, ");
INSERT INTO yns_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ban'yàmɛnà uboo a làkoo, bàmuyäämà ndaa ukàmay Yɛsu isal ande u Yɛlusàlɛm u mbwo a nkweel ande. ");
INSERT INTO yns_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petɔlà anà bumwɛy bàkäl anà nde bàbɔ̈ɔ̈n twaal aŋàkir. Umpal bàsubà ba, ba bàmɛn làkoo a Yɛsu anà baar bööl bàkäl anà nde. ");
INSERT INTO yns_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Umpal bàkaabà baar aban anà Yɛsu, Petɔlà kàtɛn a nde naa: « Un'lɔɔŋ, yà ubwaŋ naa bi ikäl apà, bi imbaar ntɛn, ntɛn tär: mwɛy ntɔn ngye, mwɛy ntɔn Mɔsɛ anà mwɛy ntɔn Ԑlya. » Kutɛn aŋàbwaŋ nde kàyöb anki undiir kàtɛɛnà nde. ");
INSERT INTO yns_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Umpal kàkäl nde mutɛn, un'böŋ mwɛy waa kafwee. Alɔŋki bàkäl u bɔɔmà mpal bàmɛn ba naa ba ban'bilà uboo a un'böŋ. ");
INSERT INTO yns_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Uboo a un'böŋ ndaa waa itoo, waa itɛn naa: « Awà mwan amɛ, mwan kàsɔ̈ɔ̈l mɛ. Lun'wem! » ");
INSERT INTO yns_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ungö a ndaa ayi, ba bàsàman Yɛsu aŋàyen mpɛl. Wɛɛ mpal ayin, ndaa ayi yanswà ba bàkäärà u mpem, ba akà mbuur mwɛy bàkyään anki. ");
INSERT INTO yns_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Taaŋtyà, ba bàkäl muyàtyà u mɔŋ, baar mbɔɔn bàyi mubwey a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Waa le, uboo a baar abà, mbuur mwɛy kàlal in'kwɛŋ: « Un'lɔɔŋ, mɛ amabɔɔn, un'ler mwan baal amɛ! Mwan baal mwɛy awà mpɛl. ");
INSERT INTO yns_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dweelà a làbe làsun'bilà, kà imbürà nde asà in'kwɛŋ, laa lun'bwiy la, waa ugyɔrà an'te. La làfun'wɛy anki agyä, nde afàkwà lɛy. ");
INSERT INTO yns_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mɛ an'bɔɔn alɔŋki angye naa ba bun'böŋ, wɛɛ ba bàsàkwo anki. » ");
INSERT INTO yns_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yɛsu waa kaŋän: « Bɛ làbà baar làkɔ̈ɔ̈n làkwikilà, baar abe! mɛ anà bɛ ilä ikwɛ in'yàfàkal anà mukàlakaar? » Waa ubulà akà mbuur awun: « Un'twääl mwan angye! » ");
INSERT INTO yns_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Umpal kàkäl mwan musin tsütsü apà Yɛsu, dweelà a làbe lun'bwiy u mɛɛn, lun'ni a ngwal. Wɛɛ Yɛsu kàŋän dweelà a làbe, waa kàkɔɔr mwan awun, kun'fuur akà taarànde. ");
INSERT INTO yns_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Baar banswà bàkäl unsà ubem muman ibaŋ a Nzam. Mbuur wanswà kàkäl mubem ndaa kàkyerà Yɛsu, nde kàtɛn a alɔŋki ande naa: ");
INSERT INTO yns_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","« Làkäär ndaa alàkyään mɛ yi apanà: Mwan a mbuur bàkyer ayun'yälà kà an'kɔɔ a baar. » ");
INSERT INTO yns_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wɛ alɔŋki ande bàyöb anki ndaa ayi. Mbuul a ya bàkyer ayee ntɔn ba bàkɔ̈ɔ̈n ayöb. Ba bàmɛn bɔɔmà mufuul Yɛsu mbuul a ya. ");
INSERT INTO yns_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Isür kyàkyer abilà uboo a antööm: ba bàkwen muyöb naa nà kan'söön uboo a ba. ");
INSERT INTO yns_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yɛsu kàyöb nde an'kyän aba, nde kàtɛ mwan umbɛy mpi u kɔɔ, kun'si tsütsü apà nde, ");
INSERT INTO yns_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","waa kàtɛn a ba naa: « Mbuur awal mwan wà kà ikɔb amɛ, nde kan'wal mɛ ŋakwo, waa mbuur kàman'wal, nde kan'wal mbuur kan'töm. Ntɔn mbuur awà ikikye uboo abɛ, nde awun awà mbuur a kölàköl. » ");
INSERT INTO yns_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ywan waa kàsɛmà mutɛn naa: « Un'lɔɔŋ, bi kàmɛn mbuur mwɛy wàmuböŋ an'dweelà an'be kà ikɔb angye, wɛɛ bi kun'tsüŋ mukyer abun ntɔn nde ngye ufalab anki anà bi. » ");
INSERT INTO yns_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yɛsu waa kàfuur naa: « Twon làmutsuŋ, ntɔn mbuur mpa afàtɔn bɛ, nde wà anà bɛ. » ");
INSERT INTO yns_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Taaŋ a Yɛsu mulwomà u mɛɛn làkäl tsütsü mukwo, nde kàsi ukwen mbɔɔn mukyà Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nde kàtöm akyeey kusà ande. Mpal bàkäl ba u mbwo, ba bàbilà u bul mwɛy là Samalya ntɔn mukun'yiil ikal. ");
INSERT INTO yns_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wɛɛ baar a Samalya bàtön mukun'wal ntɔn nde kàkäl mukyà Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mpal bàmɛn ba abun, alɔŋki ande Zyak anà Ywan bun'lɔ̈ɔ̈m naa: « Mwol, ipɛ mbwo bi iswɛŋ ipar a mbaa ifi du, kyabweel, waa ba bàkuŋà. » ");
INSERT INTO yns_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wɛɛ Yɛsu kàbulà nde ntsü bàkäl ba, waa kaŋän. ");
INSERT INTO yns_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Waa ba bàkyen bul asin. ");
INSERT INTO yns_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mpal bàkäl ba u mbwo, mbuur mwɛy kàyi nde, kàtɛn a Yɛsu naa: « Mɛ in'kyer ayalab ntsü yanswà ayàkyà ngye. » ");
INSERT INTO yns_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yɛsu waa kun'fuur naa: « In'kyɛŋ mye anà an'fu, nɛn a du ye anà an'yaab, wɛ Mwan a mbuur ikal musà un'tswe kyatɛy. » ");
INSERT INTO yns_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yɛsu waa kàtɛn a mbuur mwɛy naa: « Yan'läb! » Mbuur awà waa kàtɛn a nde naa: « Mwol, an'pɛ mbwo mɛ in'tàkàdyee taa. » ");
INSERT INTO yns_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yɛsu waa kun'fuur naa: « Wɛy akü bàdyee akü aba. Wɛɛ ngye, kyen kapay làsaŋ a Imwol a Nzam! » ");
INSERT INTO yns_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mbuur asin waa kàtɛn a nde naa: « Mɛ in'kyer ayalab, wɛɛ ngye tan'pà mbwo mɛ in'kàpà atɔŋ amɛ mbɔr a ntsüü. » ");
INSERT INTO yns_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yɛsu waa kun'fuur naa: « Mbuur kan'sà kɔɔ ande mulem ywaŋ ande anà kan'wɛy la ntɔn mukyer undiir asin, nde ukwe anki uboo a Imwol a Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ungö apan, Yɛsu kàfàsɔɔl alɔŋki bumwɛy an'kwem nsambwaar aŋiyweel, waa katöm abɔ̈ɔ̈l abɔ̈ɔ̈l, ntɔn ba bàkyen kusà ande uboo a an'bul anà ntsü yanswà kàkwe nde mubilà. ");
INSERT INTO yns_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nde waa kàtɛn a ba naa: « Isaa uboo a ywaŋ byà mbɔɔn, wɛɛ baar abwo bya bà ikikye. Làlɔ̈m akà Mwol ŋaywaŋ mutɔm baar a isal mbɔɔn ntɔn ba bàbwe bya. ");
INSERT INTO yns_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Làkyen: mɛ amàlatɔm asànaa baan a in'kɔk uboo a nkwee. ");
INSERT INTO yns_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Twon lan'syen ngim, itàkal ngɔɔr, itàkal an'sàbar, wɛɛ twon lan'mbar u mbwo ntɔn muyipà baar mbɔr. ");
INSERT INTO yns_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","U ndwà yanswà làbilà bɛ, tàlatɛɛnà naa: \"Wɛy duu làkäl udu a ndwà yi.\" ");
INSERT INTO yns_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Isàkal naa we anà mbuur a duu u ndwà ayin, duu abɛ làyàbwaay udu ande, naa tɛy, duu làyàfurà akà bɛ. ");
INSERT INTO yns_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Làkäl u ndwà ayin, làdi, lànü undiir wanswà bàlapà ba, ntɔn mbuur a isal afàwal làfur ande. Twon lan'kyà ndwà a ndwà. ");
INSERT INTO yns_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","U bul lanswà làbilà bɛ isàkal naa bàmàlawal, làdi undiir wanswà bàlapà ba, ");
INSERT INTO yns_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","làkɔɔr abɛy, lakyään naa: \"Imwol a Nzam kyan'sin tsütsü apà bɛ.\" ");
INSERT INTO yns_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wɛɛ u bul lanswà làbilà bɛ, isàkal naa bàlawɛl anki, làkyen unsà an'balàbal ala, làtɛn naa: ");
INSERT INTO yns_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","\"Bi kan'kɔɔb un'twà a bul abɛ kan'dyaar bi kà in'kɔl, wɛɛ làyöb naa Imwol a Nzam kyà tsütsü.\" ");
INSERT INTO yns_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mɛ alàkyään naa ilä a nsaŋ, Sɔdɔm bàsun'pa anki mpay aŋàsöönà mpay a baar a bul alan. » ");
INSERT INTO yns_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","« Ngyɛb akà ngye Kɔrazin! Ngyɛb akà ngye Bɛtesayidà! Ntɔn, ilàkal naa impà bàkyer akà bɛ, bàkyer u Tir anà u Sidɔn, abà itaan baar aba bàkyàbuul mpem, bàkyàbwaar ngɔɔr anà bàkyàkübà un'twà. ");
INSERT INTO yns_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lalan ilä a nsaŋ, Tir anà Sidɔn mpay a mbɔɔn bàsapà anki asànaa bàsàpà ba bɛ. ");
INSERT INTO yns_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Waa ngye, ngye Kapɛrnawum, ngye akasii naa ngye asàlaar du? Ngye asàtyà an'lɔŋ! ");
INSERT INTO yns_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mbuur usàwem bɛ, nde mɛ kan'wem, mbuur usàlapiy, nde mɛ kan'piy. Wɛɛ mbuur apiy mɛ, nde kan'piy mbuur kan'töm. » ");
INSERT INTO yns_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Alɔŋki an'kwem nsambwaar aŋiyweel bàyàfurà unsà un'sak, waa bàtɛn naa: « Mwol, kà ikɔb angye itàkal insɔŋà bàkyer akà iweemà. » ");
INSERT INTO yns_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yɛsu waa kafuur naa: « Mɛ kàkimanà Satanà kàbwee nde fà du asànaa munyä. ");
INSERT INTO yns_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Le, Mɛ akyàlapà ikɔ̈b mundyaar udu a ntäy anà nye, anà udu a imfum a Satanà, wɛɛ akà undiir mwɛy ukwe anki mukyer bɛ ube. ");
INSERT INTO yns_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wɛɛ bɛ twon lan'man un'sak naa insɔŋà myàkyer alàwem, wɛɛ bɛ làmɛn un'sak naa ikɔb abɛ ban'sɔn u du. » ");
INSERT INTO yns_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Taaŋ nsil alan, u mbwo a Dweelà In'kyɛɛl, Yɛsu kàyöl a un'sak, waa kàtɛn naa: « Taa, Mwol a du anà mɛɛn, mɛ amasyäŋà, ntɔn kàyee ngye indiir abi akà aŋayeerà anà akà aŋuyɛnà, wɛɛ ngye bya kàswɛŋ akà baan ambɛy. Ɛɛ, Taa, ngye kàkwen naa ya ikäl abà. » ");
INSERT INTO yns_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","« Taaràmɛ kàkyan'pà indiir byanswà, wɛɛ akà mbuur mwɛy tɛy uyöb Mwan, isàkal naa kà Taa anki, anà mbuur mwɛy tɛy uyöb Taa, isàkal naa kà Mwan anki anà mbuur kan'kwen Mwan mukyään ndaa ayi. » ");
INSERT INTO yns_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ungö apan, waa kàbulà ntsü bàkäl alɔŋki ande, waa kàtɛn a ba mpɛl naa: « Un'sak mbɔɔn akà mii ikamanà ndaa làmanà bɛ yi! ");
INSERT INTO yns_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ntɔn mɛ alàkyään naa aŋangɔɔm anà amfum mbɔɔn bàkwen muman ndaa làmanà bɛ yi, wɛɛ ba ya bàsàman anki, muwem ndaa làweemà bɛ yi, wɛɛ ba ya bàsàwem anki. » ");
INSERT INTO yns_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Un'lɔɔŋ a un'kɔɔn mwɛy kàmbarà ntɔn mulwab Yɛsu ndaa, waa kàtɛn naa: « Un'lɔɔŋ, ininà mɛ in'kyer ntɔn muwal möö a mbul a in'tye? » ");
INSERT INTO yns_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yɛsu kun'fuur naa: « Uboo a un'kɔɔn ininà bàsön? Ngye akataŋà aben? » ");
INSERT INTO yns_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nde kàfuur naa: « Ngye ayàkwen Mwol, Nzam angye, unsà mpem angye yanswà, unsà mɔ̈ɔ̈ angye wanswà, unsà ngwal angye yanswà, unsà an'kyän angye manswà, anà un'tɔŋ angye asànaa ngye ŋakwo. » ");
INSERT INTO yns_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yɛsu waa kàtɛn a nde naa: « Ngye an'fuur ubwaŋ. Kyer abun, waa ngye ayàkal anà möö. » ");
INSERT INTO yns_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wɛɛ nde kàkwen muwal iböŋ anà mufuul Yɛsu naa: « Un'tɔŋ amɛ nà? » ");
INSERT INTO yns_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yɛsu waa kàfuur naa: « Mbuur mwɛy kàfü Yɛlusàlɛm mutyà Yɛlikɔ. Baar abɛ laa bun'käär ba, bàgyɔɔr ba indiir ande byanswà, bun'düb ba, bàkyen ba anà bàsun'wɛy ba tsütsü a ukwà. ");
INSERT INTO yns_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ngaŋ mwɛy kàkäl mutyà u mbwo ayin. Mpal kàmɛn nde mbuur awun, nde kàlyaaŋ ukɔl. ");
INSERT INTO yns_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Un'lɛvi mwɛy sye kàkɔlà kà ikal akin, kun'mɛn nde, waa kàköl. ");
INSERT INTO yns_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Wɛɛ un'samàlya mwɛy kàkäl u mbwo ande mulyaaŋ. Mpal kàmɛn nde mbuur awà, ngyɛb laa yun'käär yà. ");
INSERT INTO yns_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nde kàsin tsütsü, kun'bäm ipfɛy kà iwà ande, kun'tyaŋ may anà man, waa kun'si udu a mpoonà ande, kun'syen u ndwà a angyey, waa kun'bay. ");
INSERT INTO yns_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Taaŋtyà nde kàwɛl ndiim yweel, laa kàpɛ nde ya akà ŋandwà a angyey, waa kàtɛn a nde naa: \"Sun'bay mbuur wà, isàkal naa ngye an'sàtwey ngim mbɔɔn yan'söön yi, mɛ in'yafuur umpal in'yàfurà mɛ.\" ");
INSERT INTO yns_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","« Uboo a baar abà batär, nà awà un'tɔŋ a mbuur kàbü wà kà an'kɔɔ a baar abe? » ");
INSERT INTO yns_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Un'lɔɔŋ a un'kɔɔn waa kun'fuur naa: « Mbuur akwà kun'wem ngyɛb. » Yɛsu naa: « Kyen, ngye sye kakyer abun. » ");
INSERT INTO yns_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Umpal kàkäl Yɛsu u mbwo anà alɔŋki ande, nde kàbilà u bul mwɛy, un'kaar mwɛy ikɔb ande Màtà kawɛl u ndwà ande. ");
INSERT INTO yns_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nde kàkäl anà un'tɔŋ ande wà un'kaar ikɔb ande Màlye. Mwan un'kaar awà kàbwaay kà in'kɔl a Mwol ntɔn muweemà ndaa ande. ");
INSERT INTO yns_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","An'kyän a Màtà manswà màkäl mukyer isal a ifà ifà, laa kàyàmɛnà nde kà ikal kàkäl Yɛsu, waa kàtɛn a nde naa: « Mwol, ngye ube akamanà anki naa un'tɔŋ amɛ kàman'sööl isal byanswà aŋayen? Un'swɛŋ nde uyan'bay. » ");
INSERT INTO yns_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mwol waa kun'fuur naa: « Màtà, Màtà, ngye akamanà mpay anà akayoolàyoolà ntɔn indiir mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wɛɛ, undiir mwɛy awà ndöŋ. Kyakin Màlye kan'sɔɔl kab aŋàbwaŋ mpa bàsun'lwom. » ");
INSERT INTO yns_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yàmɛnà naa ilä mwɛy Yɛsu kàkäl muyamà kà ikal mwɛy. Umpal kàmay nde, un'lɔŋki ande mwɛy kàtɛn a nde naa: « Mwol, ilɔŋ muyamà asànaa Ywan kàlɔŋ nde alɔŋki ande. » ");
INSERT INTO yns_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nde waa kàtɛn a ba naa: « Mpal làyamà bɛ, làtɛn abà: \"Taa! Wɛy ikɔb angye ikäl kyà in'kyɛɛl, wɛy imwol angye iyi. ");
INSERT INTO yns_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ipɛ ŋàbà isaa abi byà ilä a ilä. ");
INSERT INTO yns_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Idwääl nkul asànaa ifàdwääl bi nkul akà baar bàfikyer ube. Twon an'pà mbwo naa bi ibilà u ndɛb.\" » ");
INSERT INTO yns_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nde waa kàfàtɛn a ba naa: « Isàkal naa umwɛy uboo a bɛ we anà un'sam, waa nde ukyen akà nde uboboo a mpib ntɔn mulɔm akà nde naa. \"Un'sam, nsɔɔm nsɔ tär, ");
INSERT INTO yns_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ntɔn un'sam amɛ mwɛy kan'fà kwɛl, kan'yàkɔlà apanà u ndwà amɛ, wɛɛ mɛ undiir un'pà watɛy.\" ");
INSERT INTO yns_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wɛɛ, isàkal naa uboo a ndwà ande un'sam ande awun kan'fuur naa: \"Twon aman'sà lingyoomà, ibeenà kyàŋàbäm, baan amɛ anà mɛ ŋakwo ibaŋàbɔ̈ɔ̈n, mɛ in'fàsubà anki ntɔn mupà ngye nsɔ.\" ");
INSERT INTO yns_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ndandaa mɛ alàkyään, isàkal naa nde usubà anki mukun'pà ya ntɔn nde wà un'sam ande, nde akyer ayàsubà mukun'pà undiir wanswà awe nde awà mfun ntɔn un'sam ande wàmusà muküünà. ");
INSERT INTO yns_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Wɛɛ mɛ, mɛ alàkyään naa: Làlɔ̈m, waa bàlapà. Làleŋ, waa bɛ làyàman. Làbɛɛrà, waa bàyàladuub. ");
INSERT INTO yns_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ntɔn mbuur wanswà afàlɔm akyer afàwal, mbuur afàleŋ akyer afàman, anà bàfàduub akà mbuur afàbɛɛrà. ");
INSERT INTO yns_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Isàkal naa umwɛy uboo a bɛ wà taa, nkye nde kan'kwo mupà mwan ande ntäy isàkal naa nde kàmulɔ̈ɔ̈m nsö? ");
INSERT INTO yns_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Itàkal naa nde kan'lɔm kyà, waa nde kun'pà lànye? ");
INSERT INTO yns_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Isàkal naa bɛ baar abe làkyàyöb mupà baan abɛ indiir aŋàbwaŋ, wɛɛ Taa u du waa mpa upà Dweelà In'kyɛɛl akà baar bàmulɔ̈ɔ̈m? » ");
INSERT INTO yns_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yàlɔ̈m naa ilä mwɛy Yɛsu kàböŋ unsɔŋà mwɛy kàbuulà mbuur mwɛy nkiin. Ungö a ntoo a unsɔŋà awun, nkiin waa kàsɛmà musà ndaa, baar banswà bàkäl unsà ubem. ");
INSERT INTO yns_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wɛɛ baar bumwɛy uboo a ba bàtɛɛnà naa: « Nde ayisyääl ikɔ̈b a Bɛlzebul, mfum a insɔŋà, ntɔn muböŋ insɔŋà. » ");
INSERT INTO yns_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Baar bumwɛy waa bàlɔ̈m naa nde ukyer impà kyan'fà du ntɔn mukun'si. ");
INSERT INTO yns_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yɛsu abà kàyöb nde an'kyän aba, waa kàtɛn a ba naa: « Imwol kyanswà kye anà nkaabà uboo a kya, kya ikyer afàpää: Ndwà ibwà udu a ndwà yumwɛy. ");
INSERT INTO yns_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Isàkal naa Satanà wà un'yiiŋ ande ŋakwo, imwol ande iyàtsim aben? Ntɔn bɛ làtɛɛnà naa mɛ in'kaböŋà insɔŋà kà ikɔ̈b a Bɛlzebul. ");
INSERT INTO yns_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Isàkal naa mɛ insɔŋà in'kaböŋà kikɔ̈b a Bɛlzebul, baan abɛ insɔŋà bàfàböŋ kà ikɔ̈b a nà? Lalan ba ŋakwo bàsàkal atsüül a nsaŋ abɛ. ");
INSERT INTO yns_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wɛɛ, isàkal naa mɛ insɔŋà in'yiböŋ a làpin a Nzam, iswaŋà naa imwol a Nzam kyàkyàtol akà bɛ. ");
INSERT INTO yns_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Uman naa mbuur a ngwal awe anà an'tà màŋàkwo wàmuler ndwà ande, indiir ande mbuur uyàba anki. ");
INSERT INTO yns_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wɛɛ, isàkal naa mbuur asin kàmun'söön u ngwal kan'yà, kan'wal iböŋ udu ande, nde kun'gyɔɔr an'tà ande manswà kàsyee nde làkyän, waa ukab indiir byanswà kàmun'gyɔɔr nde. ");
INSERT INTO yns_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","« Mbuur mpa awà anà mɛ nde wà un'yiiŋ amɛ, wɛɛ mbuur mpa ayàtüüb anà mɛ ntɔn muböbà, nde wàmupay. ");
INSERT INTO yns_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","« Isàkal naa dweelà a làbe lan'too uboo a mbuur, la làfàkyà nsye a ipɔl muleŋ ikal akàyöör. La usàkɔɔn aman ikal ayöör laa làtɛn la naa: \"Mɛ in'furà ndwà amɛ kàfü mɛ.\" ");
INSERT INTO yns_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mpal làyàfurà la, la làsàman ya yàŋàkɔɔm, indiir byanswà byàŋayöŋà ubwaŋàbwaŋ, ");
INSERT INTO yns_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","laa ukyà nde, ukàwal nde an'dweelà nsambwaar mà mun'söön u nkyɛl, ma màbilà u ndwà, waa màbwaay. Apan mpay a mbuur awà laa isöönà ya mpay yàtàtwɛb. » ");
INSERT INTO yns_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yàmɛnà naa mpal kàkäl Yɛsu mutɛɛnà abwɛy, un'kaar mwɛy kàmbarà uboo a baar, waa kàtɛn u ndaa a ngwal naa: « Un'sak akà un'kaar kakäär kà an'bäl ande anà kanüü an'bɛɛl ande! » ");
INSERT INTO yns_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nde waa kàfuur naa: « Aay, un'sak aŋasöönà akà baar bàweemà ndaa a Nzam anà bàsyäälà ya. » ");
INSERT INTO yns_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Umpal ban'yàköŋ baar apà Yɛsu, nde kàsɛmà mutɛn naa: « Baar a mpalàbà bà baar abe: ba bàlɔɔmà idiim, wɛɛ ba idiim asin bàman anki, idiim nsil kyà Yɔnas. ");
INSERT INTO yns_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Lalan, asànaa Yɔnas kàkäl nde idiim ntɔn baar a Ninive, abun sye Mwan a mbuur uyàkal nde idiim ntɔn baar a mpalàbà. ");
INSERT INTO yns_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kà ilä a nsaŋ, mfum a ngyɛl wà un'kaar akyer asàmbarà kusà a baar a mpalàbà ntɔn mukapà ikwàndwà, ntɔn nde kàfü ntsü a kwɛl muyàwem an'yeerà a Salɔmun. Wɛɛ apà we anà mbuur kan'söön Salɔmun. ");
INSERT INTO yns_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kà ilä a nsaŋ, baar a Ninive bàkyer asàmbarà kusà a baar a mpalàbà ntɔn mukapà ikwàndwà, ntɔn baar a Ninive bàbuul mpem umpal bàwem ba an'lɔɔŋ a Yɔnas. Wɛɛ apà we anà mbuur kan'söön Yɔnas! ");
INSERT INTO yns_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","« Akà mbuur mwɛy ukwe anki mukyä mwinà waa nde uyee wa, itàkal naa nde usi wa u ngyɛl a kantin. Wɛɛ nde wa asà udu a un'te bàfàsà mwinà ntɔn baar bàbilà u ndwà bàmɛn pɛɛlà. ");
INSERT INTO yns_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mii angye myà mwinà a ndür angye: isàkal naa mii angye myà ubwaŋ, ndür angye yanswà ikal uboo a pɛɛlà, wɛɛ mii angye isàkal anà ukyal, ndür angye yanswà ikal uboo a làpib. ");
INSERT INTO yns_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Duub mii angye ubwaŋàbwaŋ, wɛy pɛɛlà a ndür angye làkɔ̈ɔ̈n abwà làpib. ");
INSERT INTO yns_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Abun, isàkal naa ndür angye yanswà yà uboo a pɛɛlà, akà ikal mwɛy kyatɛy uboo a làpib, ya yanswà iyàkal uboo a pɛɛlà, asànaa mwinà ufàpà wa ngye ŋakwo pɛɛlà a in'ŋyäŋ ande. » ");
INSERT INTO yns_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yàmɛnà naa mpal kàmay Yɛsu mutɛn, umfarisi mwɛy kun'bel ntɔn mukàdyà u ndwà ande. Yɛsu kàbilà nde, waa kàbwaay u mɛsà. ");
INSERT INTO yns_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Umfarisi awun kàkyer abem muman naa Yɛsu kàtàywab anki kusà mudyà. ");
INSERT INTO yns_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wɛɛ Mwol waa kàtɛn a nde naa: « Le ndaa abɛ Amfarisi: Bɛ làfàsɔŋ nsà a an'kɔɔb anà an'lɔŋà, wɛɛ uboo bɛ làbà aŋàyɔl a làmfɛɛl anà nkyɛl mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Angwöy Mbuur akwà kàkyer nsà, nde boo kàkyer anki? ");
INSERT INTO yns_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Làpɛ akà aŋàlàmbwà indiir abyà uboo a an'kɔɔb anà uboo a an'lɔŋà abɛ, waa indiir byanswà byàyàkal byà in'kyɛɛl ntɔn bɛ. ");
INSERT INTO yns_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","« Wɛɛ ngyɛb akà bɛ Amfarisi! Bɛ làfàpà mwɛy uboo a kwem wà nkay ifàsà indiir ntsà asànaa un'dül anà köb anà nkay adyà asin yà ifà ifà, wɛɛ bɛ làfàkyer anki ndaa a balàbal anà ukwen a Nzam: undiir làlàkyer bɛ ukɔɔn adiimà indiir byumwɛy. ");
INSERT INTO yns_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ngyɛb akà bɛ Amfarisi, ntɔn bɛ làfàkwen an'kir a làkoo u ndwà a nköŋ. Bɛ làfàkwen naa baar bàlapɛ mbɔr kà ikal a nköŋ. ");
INSERT INTO yns_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ngyɛb akà bɛ! Bɛ làbà asànaa an'dii mpa bàfàman baar anà bàfàndyaar ba ukɔɔn ayöb. » ");
INSERT INTO yns_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Umwɛy uboo a alɔɔŋ a Un'kɔɔn, kàtɛn a nde naa: « Un'lɔɔŋ, akatɛɛnà ngye abwɛy, ngye bi akatoo sye! » ");
INSERT INTO yns_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yɛsu waa kàfuur naa: « Ngyɛb akà bɛ sye, alɔɔŋ a in'kɔɔn! Ntɔn bɛ làfàtɔɔl buur a mpay musɛn akà baar, wɛɛ bɛ la làfàba anki akà u làpin làmwɛy. ");
INSERT INTO yns_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ngyɛb akà bɛ, ntɔn bɛ làfàtɔŋ an'dii a aŋangɔɔm bàdwä bàtaaràbɛ! ");
INSERT INTO yns_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Abun iswaŋà ubwaŋàbwaŋ naa bɛ lan'kyey ndaa bàkyer bàtaaràbɛ: ba bàdwä aŋangɔɔm, wɛɛ bɛ, bɛ làtɔŋà an'dii aba! ");
INSERT INTO yns_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Lalan Nzam kàtɛn nde unsà an'yweerà ande naa: \"mɛ ba in'satööm aŋangɔɔm anà antööm, ba bàsàdwa bumwɛy anà bàsàmɛɛy bumwɛy nkwaaŋ.\" ");
INSERT INTO yns_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Lalan an'kil a aŋangɔɔm màpää fà nsɛmà a mɛɛn bàsàtälà udu a un'tswe a baar a mpalàyi, ");
INSERT INTO yns_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","sɛmà an'kil a Abɛl tii an'kil a Zakàlye awà bàdwä uboboo a mɛsà a ibɔɔn anà idwà. Ndandaa mɛ alàkyään, buur a an'kil a baar abà banswà bàsàtälà udu a un'tswe a baar a mpalàyi! ");
INSERT INTO yns_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","« Ngyɛb akà bɛ alɔɔŋ a Un'kɔɔn, bɛ làkyàduum nsab ufàduub ndaa a un'yɛnà. Bɛ ŋakwo làfàbilà anki, bɛ sye làfàtsuŋ baar bumwɛy bàfàkwen mubilà kwo. » ");
INSERT INTO yns_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yàmɛnà naa umpal kàtoo Yɛsu u ndwà, alɔɔŋ a in'kɔɔn anà Amfarisi bàkun'nüün ntɔn mukun'fuul ndaa yà ifà ifà: ");
INSERT INTO yns_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ba bàkäl mukun'lwab ndaa, ntɔn ba bàwɛl ndaa ayifà u mun ande ntɔn ba bun'füün. ");
INSERT INTO yns_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yàmɛnà naa utaaŋ nsil alan, baar nsaab bàkyer ayàköŋ, ba bàndyàndyaar ba a ba kà in'kɔl. Yɛsu kàtàsɛmà mutɛn a alɔŋki ande naa: « Làduub mii abɛ ntɔn ful a Amfarisi, iswaŋà naa ukwen a loor. ");
INSERT INTO yns_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ndaa yanswà yàŋàyee ikyer asàmɛnà u mii, ndaa a unku ikyer asàtoo. ");
INSERT INTO yns_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Lalan ndaa yanswà làsàtɛn bɛ u làpib, bàkyer asàwem u mwäänà answà, wɛɛ ndaa yanswà làsàŋüŋün bɛ u mun a tsü uboo a suk aŋàdübà, isàbulà ndaa a kuub in'kwɛŋ udu a nsyä a ndwà. ");
INSERT INTO yns_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","« Asam amɛ, mɛ alàkyään naa: twon lan'man bɔɔmà a baar bàfàlɔ ndür mpɛl, wɛɛ mpa bàkwe mufàkyer undiir asin. ");
INSERT INTO yns_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mɛ in'kyer alàswaŋ nà bɛ lan'kwo mutiin bɔɔmà: làtiin mbuur awe anà ikɔ̈b mukàlàtɔɔm u yaaŋ a mbaa ungö a nkweel. Ndandaa mɛ alàkyään, bɛ bɔɔmà làtiin nde! » ");
INSERT INTO yns_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","« nkye Insɔɔr ityeen bàfàyälà anki ndiim yweel? Wɛɛ Nzam ufàdiimà anki akà umwɛy uboo a bya. ");
INSERT INTO yns_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yumwɛy ayi: Itàkal ntswee abɛ yanswà yàŋàtaŋ. Twon lan'man bɔɔmà, ntɔn bɛ lan'söön insɔɔr mbɔɔn u ntal. ");
INSERT INTO yns_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","« Wɛɛ mɛ alàkyään naa mbuur wanswà asàtà imbäl amɛ u mii a baar, Mwan a mbuur sye asun'tɛɛl imbäl u mii a akyeey a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wɛɛ mbuur wanswà asàswaŋ ngaal u mii a baar naa nde mɛ kan'yöb anki, nde sye bàsun'yöb anki u mii a akyeey a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Isàkal naa mbuur kan'twe Mwan a mbuur, nde bàsun'dwääl nkul, wɛ mbuur asàto Dweelà In'kyɛɛl, usàwal anki ndwääl a nkul. ");
INSERT INTO yns_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","« Mpal bàsàlasyen ba u ndwà a nköŋ a Ayudà ntɔn mukàlatsüül nsaŋ, itàkal kusà a amfum, itàkal kusà a an'yɔl, twon lan'man mpay naa bɛ un'lɔn làkàsà aben, bɛ ndaa nà làkàtɛn. ");
INSERT INTO yns_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ntɔn Dweelà In'kyɛɛl akyer asàlalɔŋ taaŋ nsil alan ndaa lan'kwo bɛ mutɛn. » ");
INSERT INTO yns_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yàmɛnà naa uboo a un'sɛŋ a baar mbuur mwɛy kàtɛn a Yɛsu naa: « Un'lɔɔŋ, un'swɛŋ un'tɔŋ amɛ mukab anà m un'naaŋ abi. » ");
INSERT INTO yns_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yɛsu waa kun'fuur naa: « Un'sam amɛ, nà kan'si ntɛɛn abɛ, itàkal nkalsà mukab un'naaŋ abɛ? » ");
INSERT INTO yns_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nde waa kàtɛn a ba naa: « Làwem ubwaŋàbwaŋ: twon lan'kal anà ngyal mukal anà indiir mbɔɔn, ntɔn mɔ̈ɔ̈ a mbuur kà wà uboo a indiir ande anki, itàkal naa nde wà ŋun'naaŋ. » ");
INSERT INTO yns_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Apan nde katɛɛl nsim yi: « An'ywaŋ a ŋun'naaŋ mwɛy màtwey isaa mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nde kàsɛmà muyweer: \"Mɛ in'kyer aben? Ntɔn mɛ ikal musà isaa amɛ abi byanswà kyatɛy.\" ");
INSERT INTO yns_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Apan nde kàtɛn naa: \"Mɛ in'yàkyer abà: Mɛ in'kyer ayàpay ikɔr amɛ byanswà ntɔn mutɔŋ byàkölàköl, waa in'yàsà mbɛŋ amɛ yanswà anà isaa amɛ byumwɛy. ");
INSERT INTO yns_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ungö apan mɛ in'yàtɛn a mɛ ŋakwo naa: Mɔ̈ɔ̈ amɛ, ngye awe anà isaa mbɔɔn ntɔn mbul mbɔɔn. Yweer, dyà, nwà, man un'sak.\" ");
INSERT INTO yns_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wɛɛ Nzam waa kàtɛn a nde naa: \"Insil! U mpib a ŋàbà nsil awà ngye akyer akwà. Ayi yanswà an'lɔn ngye ntɔn ngye, nà asàman ubwaŋ a ya?\" » ");
INSERT INTO yns_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yɛsu kàkwɛy naa: « Abun, ya yabwɛy sye ntɔn mbuur afàköŋà un'naaŋ mbɔɔn ntɔn nde ŋakwo, wɛɛ nde ukɔ̈ɔ̈n akal ŋun'naaŋ ntɔn Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Apan Yɛsu kàfàtɛn a alɔŋki ande naa: « Lalan m alàkyään naa: Twon lan'man mpay ntɔn mɔ̈ɔ̈ abɛ anà mutɛɛn naa bɛ ininà làyàdyà, itàkal naa ntɔn ndür abɛ naa bɛ ininà làyàbwaar. ");
INSERT INTO yns_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ntɔn mɔ̈ɔ̈ kan'söön isaa anà ndür yan'söön ipfɛy. ");
INSERT INTO yns_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Làler inkaak, bya ifàkɔn anki, ifàbwo anki, bya ikɔr byatɛy, wɛɛ Nzam akyer afadii. Bɛ lan'söön nɛn! ");
INSERT INTO yns_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nà uboo a bɛ, ntɔn ngyɛb ande, kan'kwo mukwɛy akà ilä mwɛy u mɔ̈ɔ̈ ande? ");
INSERT INTO yns_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Isàkal naa bɛ làkwe anki mukyer undiir ikikye, ntɔn nkye làmanà bɛ mpay ntɔn indiir byumwɛy? ");
INSERT INTO yns_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Làler iful a an'ywaŋ ifàyɛl bya: bya byàfàsal anki, byàfàtɔŋ anki, wɛɛ mɛ alàkyään naa itàkal Salɔmun unsà un'naaŋ ande wanswà kàsàbwaar anki asànaa bya. ");
INSERT INTO yns_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Isàkal naa Nzam afàbwää iteerà abyà u ywaŋ ŋàbà wɛɛ nkàswo bya bàyàtɔɔm u mbaa, waa Nzam mpa uyàlabwää, bɛ aŋàlàkwikilà ikikye. ");
INSERT INTO yns_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Wɛɛ bɛ, twon lan'man mpay ntɔn udyà anà unwà abɛ, twon lan'kal u ngyɛb. ");
INSERT INTO yns_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ntɔn indiir abi byanswà baar mpa bàyöb Nzam u mɛɛn mà bàfàleŋ bya taaŋ lanswà. Wɛɛ bɛ, Taaràbɛ akyàyöb naa bɛ làbye anà mfun a bya. ");
INSERT INTO yns_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wɛɛ bɛ, tàlaleŋà imwol a Nzam, waa bàsàlakwɛy indiir abi byanswà. » ");
INSERT INTO yns_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","« Twon an'man bɔɔmà, ngye làböl ikikye! Ntɔn Taaràbɛ kàkwen mukàlapà imwol. ");
INSERT INTO yns_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Làyälà indiir abɛ, làpɛ ngim akà aŋàlàmbwà. Làkyer in'di a ngim mpa ifàbwà an'tär. Làyee in'naaŋ abɛ u du, waa mya mpa myàtäy. Mbüüb bàyàkwo anki muwal mya, anà nsɛɛl sye idyà anki mya. ");
INSERT INTO yns_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ntɔn ikal awà in'naaŋ abɛ, ikal sye iwà mpem abɛ. ");
INSERT INTO yns_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Làkäl kà igyɛɛŋ musal anà indiir a isal abɛ u kɔɔ. Làwɛy minà abɛ myàkäl myàŋàlɛɛmà. ");
INSERT INTO yns_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Làkäl asànaa asyääl bàkadilà nkum aba kàkyen mukàbäl un'kyay, ntɔn ba bun'duub ndwà isàkal naa nde kan'yàfura anà kan'bɛɛrà. Mpal uyàfurà nde, ubɛɛrà nde, waa ba bun'duub ndwà. ");
INSERT INTO yns_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Un'sak akà asyääl usyetaan nde bàmuleerà mpal uyàfurà nde! Mɛ ndandaa alàkyään, nde ŋakwo asàbwaar ipfɛy a isal, asàpà ba ikal abwaay anà isaa. ");
INSERT INTO yns_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Isàkal naa nde kan'yà uboboo a mpib, itàkal naa u nkɔɔ atàtwɛb, un'sak akà asyääl akwà usàtaan nde bàŋàleer! » ");
INSERT INTO yns_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","« Làyöb ubwaŋàbwaŋ naa isàkal naa ŋandwà akyàyöb taaŋ uyà mbüüb, nde uyun'wɛy anki mubilà u ndwà ande. ");
INSERT INTO yns_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Bɛ sye, làduub mii abɛ, ntɔn bɛ làyöb anki taaŋ usàyà Mwan a mbuur. » ");
INSERT INTO yns_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Apan Petɔlà waa kun'fuul naa: « Mwol, nsim ayi yà ntɔn bi mpɛl lɛɛ ntɔn baar banswà? » ");
INSERT INTO yns_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mwol waa ufuur naa: « Nà un'syääl a balàbal anà ŋun'yɛnà awà kan'kwo nkum ande mupà buur muler asyääl anà mupà umwɛy umwɛy isaa ande u taaŋ a taaŋ? ");
INSERT INTO yns_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Un'sak akà un'syääl awà, isàkal naa nkum ande amàyun'taan mukyer isal akin! ");
INSERT INTO yns_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mɛ alàkyään ndandaa, nde asun'sà mfum udu a un'naaŋ ande wanswà. ");
INSERT INTO yns_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wɛɛ, isàkal naa un'syääl kan'yweer u mpem ande naa: \"Nkum amɛ kan'kyer itaan muyàfurà.\" Nde usɛmà mudüb baar a isal abaal anà bakaar, isal ande udyà, unwà anà uyɔr man, ");
INSERT INTO yns_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","apan nkum ande asyefurà ilä mpa kun'dilà nde anà u taaŋ mpa uyöb nde. Apan nkum ande asun'pà ntaaŋàmbar aŋàsöönà, nde asun'sà uboo a un'lwaaŋ a atsüüŋ mpa bàfàlab nswɛɛŋ. ");
INSERT INTO yns_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Un'syääl akwà awà ayöb naa nkum ande ininà ufàkwen, wɛɛ nde ufàkwen anki mukyer ya anà mulɔ̈ɔ̈n ya kusà, nde asàwal an'füm mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wɛɛ un'syääl akwà mpa uyöb naa nkum ande inina ukwen ntɔn nde, isàkal naa nde an'kyer ube, ntaaŋàmbar ande isàkal ikikye. Isàkal naa mbuur kàwɛl mbɔɔn, bàsun'lɔ̈ɔ̈m sye mbɔɔn. Isàkal naa bàmapà mbɔɔn, bàsalɔ̈ɔ̈m sye mbɔɔn. » ");
INSERT INTO yns_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","« Mɛ kàyi muyàtɔɔm mbaa u mɛɛn. Wɛɛ mɛ in'kwen naa ya ikäl yàŋàlɛɛmà. ");
INSERT INTO yns_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ye anà ndüümà mwɛy mɛ in'wal, mɛ waa in'wà u ngyɛb mbɔɔn tii umpal isàkwo ya! ");
INSERT INTO yns_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nkye bɛ làsii naa mɛ kàyi ntɔn mutwaal duu u mɛɛn? Ŋaa, mɛ alàkyään naa nkaabà. ");
INSERT INTO yns_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yan'mɛnà naa sɛmà ŋàbawà, u ywar a baar atyeen nkaabà yan'bilà, atär bàkwen anki abɔ̈ɔ̈l, aböɔ̈l bàkwen anki atär, ");
INSERT INTO yns_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","taa ukwen anki mwan ande wà baal, mwan baal ukwen anki taarànde, maa ukwen anki mwan ande wà un'kaar, mwan un'kaar ukwen anki ngwän, maa ukwen anki un'kyay a mwan ande, un'kyay a mwan ukwen anki ukwà ande wà un'kaar. » ");
INSERT INTO yns_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ungö apan, Yɛsu waa kàtɛn sye a baar banswà naa: « Umpal làfàman bɛ itööm ntsü làfàmina taaŋ, bɛ làfàtɛn naa: \"Mbul akyer anɔ\", wa sye afàkyer anɔ. ");
INSERT INTO yns_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Isàkal naa un'pöb an'fà ngyɛl, bɛ làfàtɛn naa: \"Ŋàbà mwäänà akal mbɔɔn\", wa sye afàkal mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Baar a mpem yweel! Bɛ làkyàyöb ndaa yan'kwo mulyaaŋ u mɛɛn anà u du, wɛɛ ntɔn nkye mpa làyöb bɛ ndaa a mpalàyi? » ");
INSERT INTO yns_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","« Ntɔn nkye bɛ ŋakwo mpa làyöb bɛ musɔɔl ndaa a ndandaa? ");
INSERT INTO yns_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Isàkal naa we anà mbur kàmafüün, wɛɛ bɛ làwàmukyà làbay a nsaŋ, leŋ ipöl muyöŋà anà nde mpal làbà bɛ u mbwo. Abun nde ngye uyàfasyen anki akà ntɛɛn, ntɛɛn ayàfapà anki akà un'kyɛɛŋ, un'kyɛɛŋ uyàfabiil anki u bɔlokà. ");
INSERT INTO yns_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kya naa tɛy, mɛ akyään ndandaa, ngye kwo asàtoo anki isàkal naa ngye ngim ande yanswà ŋàtàfur anki. » ");
INSERT INTO yns_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Umpal ayin, baar amwɛy bàyi mukyään Yɛsu naa Pilatu kàdwä aben Angalilɛ taaŋ bàkäl ba mupà ibɔɔn akà Nzam. ");
INSERT INTO yns_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yɛsu kafuur naa: « Bɛ làsii naa Angalilɛ abà bàsöön Angalilɛ bumwɛy unsà man'be, lalan bàmɛn ba mpay a tub ayi? ");
INSERT INTO yns_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mɛ in'tɛn a bɛ naa ŋaa. Wɛɛ bɛ làsàkɔɔn asɔɔmà, bɛ banswà sye làsàkwà asànaa ba. ");
INSERT INTO yns_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Itàkal baar kwem aŋinaan bàkü mpal yabweel ndwà a bwɛlàbwɛl a Silɔwɛ, bɛ làsii naa ba bàkäl anà man'be màŋasöönà baar a Yɛlusàlɛm banswà? ");
INSERT INTO yns_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mɛ in'tɛn a bɛ naa ŋaa. Isàkal naa bɛ mpem làbuul anki, bɛ banswà làkyer asàkwà. » ");
INSERT INTO yns_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Apan nde katɛɛl nsim yi: « Mbuur mwɛy kàkäl anà un'te adyà wàŋàkɔn uboo a làpaŋ ande. Ilä mwɛy nde kàkwen mubwo mbɛŋ, wɛɛ nde kàmɛn anki akà mwɛy. ");
INSERT INTO yns_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Abun nde kàtɛn a mbuur kàfalerà làpaŋ a in'te adyà ande naa: \"Le, abà mbul tär in'yaa mɛ muyàbwo mbɛŋ kà un'te awà, wɛɛ mɛ akà imwɛy in'manà anki. Tsul wa: mɛ in'manà anki isin usaa nde làpib a bunàbun uboo a làpaŋ amɛ.\" ");
INSERT INTO yns_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mbuur awun naa: \"Un'lɔɔŋ, tàfun'wɛy mbul awà! Mɛ in'yàbuun mɛɛn u mbil a wa, mɛ in'yàsà nkay: ");
INSERT INTO yns_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","taaŋ lumwɛy ilä iyà ungö wa akyer ayàbɔr. Kya naa tɛy, ngye waa asun'tsul.\" » ");
INSERT INTO yns_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yàmenà naa ilä a saba mwɛy Yɛsu kàkäl mulɔŋ u ndwà a nköŋ a Ayudà. ");
INSERT INTO yns_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wɛɛ le, uboo kwo kàkäl anà un'kaar mwɛy dweelà a làbe lun'buulà aŋàkwɛkà abà mbul kwem aŋinaan: nde kàkäl aŋàtöör, kàkwee anki mumbar aŋàsubà alää. ");
INSERT INTO yns_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mpal kun'mɛn Yɛsu, nde waa kun'bel, kàtɛn a nde naa: « Un'kaar, ngye an'kɔɔrà unsà nkwɛkà angye! » ");
INSERT INTO yns_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nde kàsi an'kɔɔ ande udu a un'kaar awà, taaŋ nsil alan un'kaar waa kàsubà, laa kàsɛmà nde musyäŋà Nzam. ");
INSERT INTO yns_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Wɛɛ mfum a ndwà a nköŋ a Ayudà kàwem nkyɛl ntɔn Yɛsu kàkɔɔr nde mbuur ilä a saba. Apan nde kàtɛn a baar banswà naa: « Ilä mukyer isal byà isyaam, làyi kà ilä abin ntɔn bàlakɔɔr, wɛɛ kà ilä a saba anki! » ");
INSERT INTO yns_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mwol waa kun'fuur naa: « Bɛ làbà baar a loor! Mbuur wanswà uboo abɛ afàbäm ngɔɔmà ande itàkal ntab ande kà ikal ufàdyà wa anà mukun'nüü ilä a saba. Kabwɛy anki? ");
INSERT INTO yns_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wɛɛ un'kaar wà, mwan a Abàlam kàkör Satanà wà mbul kwem aŋinaan, bàlun'kɔɔr anki in'siŋ ande ntɔn ŋàbà ilä a saba? » ");
INSERT INTO yns_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mfuur a Yɛsu ayi yàpɛ nswɛn akà ayiiŋ ande, wɛɛ baar banswà bàmɛn un'sak ntɔn ndaa aŋàbwaŋ kàkyerà nde. ");
INSERT INTO yns_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yɛsu kàfàtɛn naa: « Imwol a Nzam kyà asànaa ininà? ");
INSERT INTO yns_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kya kyà asànaa imbɛŋ ikikye kan'wal mbuur mwɛy anà kan'tɔɔm nde uboo a làpaŋ ande: kya waa imɛn, iyɛl, ibulà un'te, nɛn a du waa itöŋ an'yaab kà an'kɔkà a wa. » ");
INSERT INTO yns_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nde kàkwɛy naa: « Mɛ imwol a Nzam in'sii anà ininà? ");
INSERT INTO yns_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kya kyà asànaa ful kàwɛl un'kaar mwɛy waa kàtüüb la anà an'kɔɔb an'tär mà mfufu a mampà. Ungö apan mfar yanswà laa yàfül ya. » ");
INSERT INTO yns_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yɛsu kàyilyaaŋà uboo a an'bul a kölàköl anà mà ikikye muyilɔŋ anà muyisin tsütsü a Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mbuur mwɛy kun'fuul naa: « Mwol, nkye baar ikikye mpɛl bàsàwà mɔ̈ɔ̈? » Nde waa kàfuur naa: ");
INSERT INTO yns_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","« Làkyer ngwal mubilà u kimunàmbwo, ntɔn mɛ alàkyään naa baar mbɔɔn bàsàleŋ mubilà wɛɛ ba bàsàkwo anki. » ");
INSERT INTO yns_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","« Mpal usàsubà ŋandwà anà usàbäm nde ndwà, isàkal naa bɛ lan'sàsal u nsà, bɛ làtàbɛɛrà ibeenà unsà làbɔ̈ɔ̈n lanswà: \"Mwol, iduub!\" Nde bɛ asàlafuur naa: \"Bɛ làbà baar a ken?\" ");
INSERT INTO yns_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Apan, bɛ làsàtɛn a nde naa: \"Wɛɛ bi laa kàdi anà kànü u mii angye, ngye kàlɔɔŋà kà an'balàbal anà bi.\" ");
INSERT INTO yns_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nde afàsàlafuur naa: \"Bɛ làbà baar a ken. Làlwomà apà mɛ, bɛ baar làfàkyer man'be.\" ");
INSERT INTO yns_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Akun isàkal ilel anà nkwoor a an'din mpal làsàman bɛ Abàlam, Isak anà Yakɔb anà aŋangɔɔm banswà uboo a Imwol a Nzam, wɛɛ bɛ ŋakwo bàkyàlapiy unsà. ");
INSERT INTO yns_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Apan, baar bàsàfà ntsü làfàsɛnà taaŋ, ntsü làfàminà la, ntaal anà ngyɛl, ba bàsàwal ikal u mɛsà kà Imwol a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Lalan baar a ngöngö bàsàbulà baar atàtwɛb, wɛɛ baar atàtwɛb bàsàbulà baar a ngöngö. » ");
INSERT INTO yns_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Umpal ayin, Amfarisi amwɛy bàyi ba, ba bàtɛn a Yɛsu naa: « Lwomà pabà, kyen ntsü asin, ntɔn Ɛlɔdi akwen mukadwa. » ");
INSERT INTO yns_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yɛsu waa kafuur naa: « Làkyen kàlun'kyään un'kyɛŋ awun: ŋàbà anà nkàswo mɛ in'wà muböŋ insɔŋà anà mukɔɔr aŋakyal, nkàswo wunà isal amɛ iyàkal aŋàwà. ");
INSERT INTO yns_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wɛɛ mɛ in'kyer alab mbwo amɛ ŋàbà, nkàswo anà nkàswo wunà, ntɔn ŋangɔɔm ukwe anki mukwà kà ikal asin mpa akyà Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aa, Yɛlusàlɛm! Yɛlusàlɛm! Ngye an'may aŋangɔɔm, ngye an'dwa baar ufàtɔm Nzam a in'kul. Mbalà kwe mɛ kàkwen muböbà baan angye tsütsü apà mɛ asànaa nkɔɔ ufàfwee wa an'tsül u ngyɛl a an'paab ande. Wɛɛ bɛ ya làsàkwen anki! ");
INSERT INTO yns_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Isàkal abun ndwà abɛ bàkyer apiy bwà. Ɛɛ, sɛmà ŋàbawà bɛ mɛ làfàsan'man anki tii mpal làsàtɛn bɛ naa: \"Wɛy un'sak ukäl akà mbuur kan'yà kà ikɔb a Mwol.\" » ");
INSERT INTO yns_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yàmɛnà naa ilä a saba mwɛy mfum a Amfarisi mwɛy kàbel Yɛsu mukàdyà u ndwà ande. Baar bàkäl paa bàkäl musey nde ubwaŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wɛɛ le, mbuur aŋàyàyam u ndür kàkäl aŋàmbar kusà a nde. ");
INSERT INTO yns_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yɛsu kàsi ndaa, waa kàtɛn a alɔɔŋ a in'kɔɔn anà Amfarisi naa: « Nkye bàkyàpà mbwo lɛɛ tɛy mukɔɔr mbuur ilä a saba? » ");
INSERT INTO yns_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wɛɛ ba ndaa bàsi anki. Apan Yɛsu laa kàbä nde mbuur awun, waa kun'kɔɔr, kun'sweŋ mufurà ndwà ande. ");
INSERT INTO yns_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ungö apan, nde waa kàtɛn a ba naa: « Nà uboo abɛ, isàkal naa mwan ande itàkal ngɔɔmà ande kan'bwà uboo a fu, mpa kun'twey nde a agyägyä, ilä a saba? » ");
INSERT INTO yns_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wɛɛ ba sye bàsàkwo anki mufuur. ");
INSERT INTO yns_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mpal kàmɛn nde naa baar bàbel bàkäl musɔɔl ikal atàtwɛb, nde kàtɛ nsim yi: ");
INSERT INTO yns_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","« Isàkal naa mbuur kàmabel mukàdyà ilä atà bör ande, twon an'kàbwaay kà ikal a imfum. Taaŋ lumwɛy uboo abɛ we anà mbuur kan'söön ngye unsà imfum ");
INSERT INTO yns_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","anà mbuur kàlabel, ngye anà nde, uyàtɛn a ngye naa: \"Sun'wɛy ikal ki.\" Uboo a nswɛn, ngye akàbwaay kà ikal a ngöngö. ");
INSERT INTO yns_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wɛɛ, manà bàmabel, kyen kabwaay kà ikal a ngöngö. Abun, mpal uyàbilà mbuur kabel, nde waa kakyään naa: \"Un'sam amɛ, kye anà ikal aŋasöön ubwaŋ ntɔn ngye, yabwaay udu kà\". Abun ngye ayàkal aŋasyäŋà u mii a baar bàkäl anà ngye u mɛsà. ");
INSERT INTO yns_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lalan, mbuur afàsɛɛn an'pɛy bàkyer afun'tyeey, mbuur afàtyà bàkyer afun'sɛn. » ");
INSERT INTO yns_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ungö Yɛsu waa kàtɛn a mbuur kun'bel naa: « Isàkal naa ngye apà baar udyà, twon an'bel asam angye, atɔŋ angye, baar a mbil angye, itàkal aŋun'naaŋ bàfàkal tsütsü apà ngye, ntɔn ba sye bàfàsabel mufuur ayi yanswà an'kyer ngye. ");
INSERT INTO yns_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wɛɛ, isàkal naa ngye apà isaa akà baar, bel aŋàlàmbwà, baar aŋàyɔm in'kɔl, ikar, ikwàmii. ");
INSERT INTO yns_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Waa ngye ayàkal kà un'sak ntɔn baar aban ndöŋ yatɛy musafuur asànaa an'kyer ngye. Waa Nzam usakwɛy mpal bàsàwiyà baar a balàbal kà ukwà. » ");
INSERT INTO yns_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yàmɛnà naa ungö apan, umwɛy uboo a baar bàbel waa kàtɛn a Yɛsu naa: « Un'sak akà mbuur asàwal ikal mpal bàsàdii baar uboo a Imwol a Nzam! » ");
INSERT INTO yns_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Waa Yɛsu kun'fuur naa: « Ilä mwɛy, mbuur mwɛy kàwɛl baar u ndwà ande ntɔn udyà a kölàköl. Waa nde kàbel baar mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Taaŋ a udyà làkwe la, nde kàtöm un'syääl ande mukàswaŋ baar kàbel nde naa: \"Làyi apanà, ntɔn ndaa yanswà yan'kwo.\" ");
INSERT INTO yns_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wɛ ba banswà bàkal mun umwɛy wa, waa bàlɔ̈m ndwääl a nkul. Wàtàtwɛb kun'kyään naa: \"Mɛ an'som ywanŋ làmwɛy, mɛ in'kyer akyà mukàler la. Mɛ amabɔɔn, ndwääl nkul.\" ");
INSERT INTO yns_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wumwɛy naa: \"Mɛ an'som adim atyeen anà akyay atyeen bà ngɔɔmà. Mɛ in'kyer akàsi ya. Mɛ amabɔɔn, ndwääl nkul.\" ");
INSERT INTO yns_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wumwɛy sye naa: \"Mɛ an'bääl làbenàben alà, mɛ in'kwe anki muyà.\" ");
INSERT INTO yns_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Taaŋ kàyàfurà un'syääl awun, nde kàkyään nkum ande ndaa ayi yanswà bàtɛn ba. Lalan ŋandwà kàwem nde nkyɛl, kàswɛŋ nde un'syääl ande naa: \"Kyen agyägyä! Kyen u mbay anà kan'balàbal a bul, twaal pabà aŋàlàmbwà, baar aŋàkwɛkà, ikwàmii, ikar.\" ");
INSERT INTO yns_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ungö a taaŋ, un'syääl waa kàyàkyään nkum ande naa: \"Mwol, mɛ an'kyer asànaa an'swɛŋ ngye, wɛɛ ikal a ipɔl byà paa.\" ");
INSERT INTO yns_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nkum ande naa: \"Kyen u mbwo yanswà, u mbil a mpaŋ, siinà baar bàbilà, ntɔn ndwà amɛ iyöl abar. ");
INSERT INTO yns_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Wɛɛ mɛ, mɛ alàkyään ndandaa naa akà mbuur mwɛy uboo a baar kàbel mɛ ulɛr anki isaa amɛ!\" » ");
INSERT INTO yns_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yàmɛnà naa mbul a baar kàyikyeenà a Yɛsu, nde waa kàbulà, waa kàtɛn a ba naa: ");
INSERT INTO yns_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","« Isàkal naa mbuur an'yà akà mɛ, wɛɛ nde udiimà anki taarànde, ngwän, un'kyay ande, baan ande, atɔŋ ande babaal anà bakaar, itàkal ndür ande ŋakwo, nde ukwe anki mukal un'lɔŋki amɛ. ");
INSERT INTO yns_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mbuur mpa usɛn buur ande anà mpa ulab mɛ, nde ukwe anki mukal un'lɔŋki amɛ. ");
INSERT INTO yns_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Abà, nà uboo abɛ akwen mutɔŋ ndwà a bwɛlàbwɛl, nde uwal anki taaŋ muyweer ntɔn muyöb naa nde kwe uyàtwey, nkye nde ayàkwo mumay ndwà ande? ");
INSERT INTO yns_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Naa tɛy, nde uyàmay anki mutɔŋ ungö musà un'bään, baar banswà bàsamanà ya bàkyer asun'sɛ. ");
INSERT INTO yns_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ba bàsàtɛn naa: \"Làler mbuur kàsɛmà mutɔŋ, wɛ nde kàkwe anki mumay.\" ");
INSERT INTO yns_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Itàkal naa mfum mwɛy wà tsütsü muleŋ ngwiy a mfum asin. Nde uwal anki taaŋ mubwaay anà muyweer naa nkye nde akyàkwo muwal iböŋ kusà a mbuur awe abà baar nsaab an'kwem mööl isàkal naa nde ŋakwo we abà baar nsaab kwem? ");
INSERT INTO yns_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nde usàman naa nde ukwo anki, nde atɔm in'kyeey mpal awà un'yiiŋ ande u kwɛlàkwɛl ntɔn muyöŋà duu. ");
INSERT INTO yns_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ya ye abun sye ntɔn bɛ: uboo abɛ, mbuur mpa ukwen mukɔɔb ubwaŋ ande banswà ukwe anki mukal un'lɔŋki amɛ. » ");
INSERT INTO yns_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","« Muŋ wà undiir aŋàbwaŋ, wɛɛ ntsà awa isàwà, ya bàyun'fuur a nkye? ");
INSERT INTO yns_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wa bàfàsàsyääl anki itàkal ntɔn mɛɛn, itàkal ntɔn mudii ndon. Undiir kan'saal: upiy wa bwà u nsà. Wɛy mbuur awe anà an'tsü awem uwem. » ");
INSERT INTO yns_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yàmɛnà naa afüür a itɛr anà baar asin babe, ba banswà bàsin tsütsü apà Yɛsu ntɔn mukun'wem. ");
INSERT INTO yns_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Amfarisi anà alɔɔŋ a in'kɔɔn bàŋüŋün anà bàtɛn naa: « Mbuur wà ayiwal baar abɛ anà ayidyà ikal imwɛy anà ba. » ");
INSERT INTO yns_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wɛɛ Yɛsu katɛɛl nsim yi: ");
INSERT INTO yns_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","« Nà uboo abɛ we amyà in'kɔk nkam, wɛ umwɛy udiimà, nkye nde usàwɛy anki in'kɔk an'kwem wà aŋiwà u nsye ntɔn mukàleŋ umwɛy kan'diimà wà tii mpal usàman nde wa? ");
INSERT INTO yns_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mpal usàman nde wa, unsà un'sak nde, nde wa asàsà kà an'pɛy. ");
INSERT INTO yns_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mpal uyàfurà nde ndwà ande, nde abel asam ande anà baar a tsütsü, waa utɛn naa: \"Làsäŋ anà mɛ, ntɔn un'kɔk amɛ kàdiimà kan'mɛnà.\" ");
INSERT INTO yns_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Abun sye, mɛ ndandaa alàkyään, un'sak mbɔɔn asàkal u du isàkal naa mbuur un'be mwɛy kan'buul mpem, wɛɛ kà ntɔn an'kwen wà aŋiwà mpa bàwe anà mfun a mbuul a mpem. » ");
INSERT INTO yns_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","« Itàkal naa, nà un'kaar mwɛy we abyà itɛr a ngim kwem, wɛɛ imwɛy kyan'diimà. Nkye nde ukyää anki mwinà, ukɔ̈ɔ̈m ndwà anà uyaal ntsü yanswà tii mpal uyàfàman nde kya? ");
INSERT INTO yns_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wɛɛ umpal uman nde kya, nde abel asam ande anà baar a tsütsü anà mutɛn naa: \"Làsäŋ anà mɛ, ntɔn itɛr a ngim amɛ kyàdiimà kyan'mɛnà.\" ");
INSERT INTO yns_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Abun sye, mɛ alàkyään naa un'sak mbɔɔn afàkal akà akyeey a Nzam isàkal naa mbuur un'be mwɛy kan'buul mpem. » ");
INSERT INTO yns_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yɛsu waa kàfàtɛn naa: « Mbuur mwɛy kàkäl abà baan abaal bɔ̈ɔ̈l. ");
INSERT INTO yns_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mwan wà umbɛy kàtɛn a taarànde naa: \"Taa, mpɛ kab a indiir làmɛ.\" Taaràba kakääb indiir ande. ");
INSERT INTO yns_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ungö a ilä, mwan umbɛy awun kàwɛl indiir ande byanswà, laa kàyälà nde bya, waa kàkyen nsi a kwɛl. Wɛɛ akun nde kàtay un'naaŋ ande uboo a lingyoomà. ");
INSERT INTO yns_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mpal kàmay nde indiir ande byanswà, ngyal a ngwal yàbilà u nsi ayin, laa kàsɛmà nde muleŋ udyà. ");
INSERT INTO yns_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Apan, nde kàkàleŋ isal akà mbuur mwɛy wà nsi ayin. Mbuur awà kun'töm u nsye mukàdii ngul ande. ");
INSERT INTO yns_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wɛɛ an'kyän ande màkäl naa nde udi itàkal isaa a ngul, wɛɛ mbuur un'pà bya kàkäl anki. ");
INSERT INTO yns_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Apan, nde kàfuur an'kyän, waa kàtɛn naa: \"Asyääl a taa akwe bàfàdyà asànaa bàkwen ba, wɛɛ mɛ kà in'wà mukwà a ngyal. ");
INSERT INTO yns_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mɛ in'kyer ambarà, in'kyer akyà akà taa, waa in'kàtɛn a nde naa: Taa, mɛ an'kyer man'be akà Nzam anà akà ngye. ");
INSERT INTO yns_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mɛ in'kwe anki mufàkal mwan angye. Ngwɛl asànaa umwɛy uboo a asyääl angye.\" ");
INSERT INTO yns_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Apan laa kambarà nde, kàfurà nde akà taarànde. Nde kàkäl anki ŋàtàtol, mpal kun'mɛn taarànde ukwɛl, laa kun'wem nde ngyɛb mbɔɔn, kàkyen nde ntiin, kun'bwirà nde, waa kundüür. ");
INSERT INTO yns_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwan laa kàtɛn nde a taarànde naa: \"Taa, mɛ kàkyer man'be akà Nzam anà akà ngye, mɛ in'kwe anki mufàkal mwan angye …\" ");
INSERT INTO yns_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wɛɛ taarànde kàswɛŋ asyääl ande: \"Làkyen agyägyä, kàlaleŋ ipfɛy kyan'söön ntwɛn, lun'bwää, lun'si làpɛr u làpin, lun'bwää an'sàbar aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Wɛɛ làtwääl un'tö a ngɔɔmà a may, làdwä wa. Bi ikyer adyà, bi ikyer ataam ");
INSERT INTO yns_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ntɔn mwan amɛ kàkäl awàŋàkwà, nde kan'wiyà, nde kàkyer adiimà, wɛɛ mɛ amun'man.\" Laa bàsɛmà ba mutaam. ");
INSERT INTO yns_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Taaŋ nsil alan, mwan wà nswɛm kàkäl kà an'ywaŋ. Mpal kàkäl nde u mbwo muyàfurà, kàkɔlà nde tsütsü a ndwà, laa kàwem nde an'diim anà an'kyen. ");
INSERT INTO yns_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nde kàbel umwɛy uboo a asyääl, waa kun'fuul naa ndaa nà ikalyaaŋà. ");
INSERT INTO yns_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Un'syääl kun'fuur abà: \"Un'kɔm angye an'yàfurà. Taaràŋà kan'dwa un'tö a ngɔɔmà a may ntɔn nde an'yàfurà anà mɔ̈ɔ̈.\" ");
INSERT INTO yns_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Lalan, mwan wà nswɛm kàwen nde nkyɛl, waa kàtön mubilà u ndwà. Taarànde laa kàyàtoo nde, waa kun'lɔ̈ɔ̈m mubilà. ");
INSERT INTO yns_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wɛɛ nde kàtɛn a taarànde naa: \"Le, mɛ an'kyer mbul anà mbul musyääl ngye: mɛ ndaa angye mwɛy akà ikikye in'fàbɛy anki. Wɛɛ, akà mbalà mwɛy ngye un'tö a ntab kan'pɛ anki ntɔn mutaam anà asam amɛ. ");
INSERT INTO yns_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wɛɛ mwan angye, mbuur kan'kàtay indiir angye byanswà anà akaar a pasàsɛ kan'yàfurà, ntɔn nde, ngye an'dwa un'tö a ngɔɔmà a may!\" ");
INSERT INTO yns_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Taarànde naa: \"Mwan amɛ, ngye awà anà mɛ taaŋ lanswà, indiir amɛ byanswà byà byàngye. ");
INSERT INTO yns_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wɛɛ, yubwaŋ naa bi ikäl kà un'sak, ntɔn un'tɔŋ angye wà asànaa mbuur kàkü waa kan'wiyà, ntɔn nde kàkyer adiimà, waa kan'mɛnà.\" » ");
INSERT INTO yns_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yàmɛnà naa Yɛsu kàtɛn a alɔŋki ande naa: « Ŋun'naaŋ mwɛy kàkäl anà mfum a isal ande. Baar laa bàyun'füün ba naa nde afàtaam anà indiir ande. ");
INSERT INTO yns_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ŋun'naaŋ waa kun'bel, waa kàtɛn a nde naa: \"Ndaa nà mɛ in'weemà ntɔn ngye? Nswɛŋ nsyääl angye, ntɔn ngye ayàfàlab anki musyääl indiir amɛ.\" ");
INSERT INTO yns_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mfum a isal kàsɛmà muyweer: \"Mɛ in'kyer aben, ntɔn nkum amɛ kàman'lwom muler isal ande? In'bulà mulem an'ywaŋ? Mɛ ngwal yatɛy. In'sɛmà muyilɔm akà baar? Yà ndaa a nswɛn. ");
INSERT INTO yns_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa, mɛ an'man naa mɛ ininà in'kyer ntɔn baar ban'wɛl u ndwà aba mpal bàyan'lwom kà isal amɛ.\" ");
INSERT INTO yns_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ungö apan, nde kàbeelà umwɛy umwɛy aŋankul a nkum ande. Nde kàtɛn a mbuur wàtàtwɛb naa: \"Ngye kwɛ apà akà nkum amɛ?\" ");
INSERT INTO yns_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nde kun'fuur naa: \"Ngungulà nkam yà may.\" Nde waa kàtɛn naa: \"Le un'kaan a nkul angye, bwaay pabà, kyer agyägyä, sɔn an'kwem an'tyeen.\" ");
INSERT INTO yns_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ungö nde waa kàtɛn a wumwɛy naa: \"Atöl ngye kwe?\" Nde naa: \"Ngɔɔr nkam mwɛy yà mbɛŋ a imbab.\" Mfum a isal naa: \"Mà un'kaan a nkul angye, sɔn an'kwem naan.\" ");
INSERT INTO yns_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Abun, nkum kàkyer un'syäŋà un'be un'syääl awà ntɔn mankay ande. Iswaŋà naa baan a nsi yi ban'söön mankay kusà a atɔŋ aba akwà abà baan a pɛɛlà. ");
INSERT INTO yns_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Wɛɛ mɛ alàkyään naa: Làtɛ isaam a in'naaŋ a loor myà mɛɛn mà. Abun, umpal myàsàkɔɔn mya, waa mya isàlawal kà ikal a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Isàkal naa mbuur wà balàbal unsà indiir ikikye, nde asàkal sye wàbalàbal unsà indiir mbɔɔn. Wɛɛ isàkal naa mbuur wà ŋaloor unsà indiir ikikye, nde asàkal sye ŋaloor unsà indiir mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Lalan, isàkal naa bɛ balàbal batɛy musyääl un'naaŋ a loor a mɛɛn mà, nà kan'kwo mukàlapà un'naaŋ a ndandaa? ");
INSERT INTO yns_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Isàkal naa bɛ balàbal batɛy unsà indiir a baar asin, nà ayàlapà indiir abɛ ŋakwo? ");
INSERT INTO yns_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Akà un'syääl mwɛy tɛy kan'kwo musyääl ankum bɔ̈ɔ̈l. Ya iyàmɛnà naa nde ayàkyey umwɛy, nde ayàtɔn wumwɛy, itàkal naa nde ayàpà mɔ̈ɔ̈ ande akà umwɛy, nde ayàyiiŋ wumwɛy. Bɛ làkwe anki musyääl Nzam anà ngim u taaŋ làmwɛy la. » ");
INSERT INTO yns_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yàmɛnà naa Amfarisi bàwem ba ndaa ayi yanswà, ba bàsɛɛ Yɛsu, ntɔn ba bàkweenà ngim. ");
INSERT INTO yns_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wɛɛ nde kàtɛn a ba naa: « Bɛ làbà baar làfàswaŋ u mii a baar naa bɛ làbà balàbal, wɛɛ Nzam akiyöb boo a mpem abɛ. Undiir bàfàman baar naa wa wà làkoo, Nzam wa afàman wà ŋingyäy. ");
INSERT INTO yns_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","« Taaŋ a Un'kɔɔn anà là in'kaan a aŋangɔɔm làtsü apà Ywan. Sɛmà taaŋ alan, Làsaŋ Aŋàbwaŋ là Imwol a Nzam ban'kyään, anà mbuur mbuur wà mukyer ngwal ntɔn mubilà kwo. ");
INSERT INTO yns_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Du anà mɛɛn man'kwo isàdiimà, wɛɛ akà isɛrà mwɛy kyà Un'kɔɔn isàdiimà anki. ");
INSERT INTO yns_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","« Baal wanswà kàkaabà anà un'kyay ande, usàkàwal un'kyay asin, nde kan'tà inswem, wɛɛ baal wanswà asàwal un'kaar kàkaabà anà un'dim ande, nde kan'tà inswem. ");
INSERT INTO yns_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","« Taaŋ mwɛy kàkäl anà ŋun'naaŋ mwɛy kàfàbwaarà ubwaŋàbwaŋ ipfɛy a ntal. Ilä byanswà isal ande udyà anà utaam. ");
INSERT INTO yns_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ŋàlàmbwà mwɛy ikɔb ande Lazar kàfabɔ̈ɔ̈nà u mun a làpaŋ a ŋun'naaŋ awà, nde kàkäl anà inkyar u ndür ande. ");
INSERT INTO yns_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nde kàlàkwen mudyà mfür a mampà yàbwee u mɛsà a ŋun'naaŋ. Apan sye mbwà yàyee mulɛɛr inkyar ande. ");
INSERT INTO yns_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yàmɛnà naa ŋàlàmbwà waa ukü, akyeey a Nzam laa bun'syen ba akà Abàlam. Ŋun'naaŋ sye waa ukü, waa bun'dyee. ");
INSERT INTO yns_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kà an'lɔŋ, ŋun'naaŋ kàkäl uboo a mpay yà mbɔɔn. Mpal kàler nde u du laa kàmɛn nde ukwɛl Lazar tsütsü apà Abàlam. ");
INSERT INTO yns_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Apan nde kàlaal in'kwɛŋ: \"Taaràmɛ Abàlam, ngwem ngyɛb! Tɔm Lazar, nde udüma nswɛŋ a làpin ande kà an'dà, nde kan'nɔ̈ lànyaŋ a an'dà u làlem amɛ, ntɔn mɛ in'wà u mpay mbɔɔn uboo a mbaa yi.\" ");
INSERT INTO yns_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Wɛɛ Abàlam kun'fuur naa: \"Mwan amɛ, yɔbà ubwaŋ banswà kàmɛn ngye u mɔ̈ɔ̈ angye taaŋ kàkäl ngye u mɛɛn, wɛɛ Lazar kàkäl u mpay taaŋ lanswà. Mpalabà, apà, Lazar wà kà un'sak, wɛɛ ngye awà u mpay aŋasöönà. ");
INSERT INTO yns_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yumwɛy ayi: Uboo a bi anà bɛ we anà un'baan a kölàköl. Ilàtàkal naa ukwen bàkäl, bi ikwe anki musoonà wa, itàkal naa mufà akà bi muyà akà bɛ, itàkal naa mufà akà bɛ muyà akà bi.\" ");
INSERT INTO yns_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ŋun'naaŋ waa kàtɛn naa: \"Isàkal abwɛy, mɛ amabɔɔn, taa, tɔm Lazar u ndwà a taaràmɛ, ");
INSERT INTO yns_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ntɔn mɛ in'we abà atɔŋ abaal atyeen, nde ukakyään, manà ba sye bàyàlab mbwo a mpay ayi.\" ");
INSERT INTO yns_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abàlam naa: \"Atɔŋ angye bye anà Mɔsɛ anà aŋangɔɔm, wɛy ba bawem.\" ");
INSERT INTO yns_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nde naa: \"Ŋaa, taa Abàlam, manà mbuur kan'fà an'lɔŋ, kan'kyà akà ba, ba bàkyer ayàbuul mpem.\" ");
INSERT INTO yns_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abàlam waa kun'fuur naa: \"Isàkal naa ba bàkwe anki muwem Mɔsɛ anà aŋangɔɔm, ba sye bàyàkwo anki muwem akà ikikye mbuur kan'fà an'lɔŋ.\" » ");
INSERT INTO yns_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ungö apan, Yɛsu kàtɛn a alɔŋki ande naa: « Yà ndandaa naa taaŋ lanswà baar ban'kwo bàbü u man'be, wɛɛ ngyɛb akà mbuur awà mbwo ntɔn mbweel a un'tɔŋ ande. ");
INSERT INTO yns_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yubwaŋ akà nde naa bun'bäm nkɔŋ a kölàköl u bway anà bun'tɔɔm u ngyäl, akwà naa nde mubwiy umwɛy uboo a baan ambɛy bà. ");
INSERT INTO yns_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Làkäl kà igyɛɛŋ ntɔn bɛ ŋakwo! Isàkal naa un'tɔŋ angye kan'kyer man'be, un'pɛ an'lwɛŋ. Nde usàsɔɔmà, un'dwääl nkul. ");
INSERT INTO yns_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Itàkal naa nde kàmakyer ube mbalà nsambwaar kà ilä mwɛy wɛɛ nde akayaa akà ngye taaŋ lanswà naa nde akyer asɔɔmà, un'dwääl nkul. » ");
INSERT INTO yns_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yàmɛnà naa ilä mwɛy antööm bàtɛn a Mwol naa: « Kwɛy làkwikilà abi. » ");
INSERT INTO yns_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mwol waa kàfuur naa: « Isàkal naa ndandaa bɛ làbye anà làkwikilà làtàkal ikikye asànaa imbɛŋ a làpɔ̈ɔ̈là, bɛ lan'kwo muswaŋ un'te a kölàköl naa: \"Tsumà pà, kyen kambär uboo a ngyäl!\" Wa akyer alàwem. » ");
INSERT INTO yns_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yɛsu kàkwɛy naa: « Bi itàwal naa umwɛy uboo abɛ ukäl anà un'tsüüŋ ande isal ande mulem, taaŋ lumwɛy mudii ntsür. Uman nde kan'fà an'ywaŋ kan'yàfurà, nkye nde ayàtɛn a nde naa: \"Yà agyägyä, bwaay u mɛsà\"? ");
INSERT INTO yns_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aay, nde ayàtɛn a nde naa: \"Ndääm isaa, bwaar ubwaŋ, yà yan'pɛ udyà, manà mɛ an'may mudyà anà munwà, ungö ngye sye waa ayàdyà anà ayànwà.\" ");
INSERT INTO yns_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nkye nkum kan'kwo mupà ndä akà un'tsüüŋ ande ntɔn nde kan'kyer isal kyanswà kun'swɛŋ nde? ");
INSERT INTO yns_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ya sye ye abwɛy ntɔn bɛ. Isàkal naa bɛ lan'kyer isal kyanswà bàlaswɛŋ, làtɛn naa: \"Bi ibà atsüüŋ ikɔ̈ɔ̈n ndöŋ: bi kan'kyer isal kan'kwo bi mukyer.\" » ");
INSERT INTO yns_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yàmɛnà naa Yɛsu kàkäl mukyà Yɛlusàlɛm, nde kàsoonà ndel a Samalya anà Ngalilɛ. ");
INSERT INTO yns_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mpal kàkäl nde tsütsü mubilà u bul mwɛy, aŋakyal a bay kwem bàyi akà nde, ba bàmbär u kwɛl ");
INSERT INTO yns_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","waa bàsɛn ndaa: « Yɛsu, Un'lɔɔŋ, iwem ngyɛb! » ");
INSERT INTO yns_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mpal kamɛn Yɛsu, nde kàtɛn a ba naa: « Làkyen kàlamɛnà akà angaŋ. » Mpal bàkäl ba u mbwo, laa bàkɔɔrà ba. ");
INSERT INTO yns_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Umwɛy uboo aba kàmɛn nde naa nde kan'kɔɔrà, waa kàyàfurà, wàmuyisyäŋà Nzam u ndaa a dudu. ");
INSERT INTO yns_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Apan, waa kàbü, ntabwey u mɛɛn, kà in'kɔl a Yɛsu, waa kun'kömà. Mbuur awà kàkäl un'nsi Samalya. ");
INSERT INTO yns_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Waa Yɛsu kàtɛn naa: « Ba bàkwem bàkyer akɔɔrà, wɛɛ bàken baar wà bumwɛy? ");
INSERT INTO yns_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Akà mbuur mwɛy ukäl anki anà an'kyän muyàfurà ntɔn mukömà Nzam, ilàkɔɔn akal ungyey abarankye wà? » ");
INSERT INTO yns_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Apan Yɛsu kàtɛn a nde naa: « Mbarà, kyen, làkwikilà angye làmatswà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ilä mwɛy Amfarisi bàfuul Yɛsu naa imwol a Nzam isàyà mpal yɛn. Yɛsu kafuur naa: « Imwol a Nzam iyà anki asànaa undiir a ubem. ");
INSERT INTO yns_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bàsàtɛn anki naa: \"Làler, kya aki kà.\" Taaŋ lumwɛy naa: \"Kya kyà kunà.\" Ntɔn, làyöb naa Imwol a Nzam kyà uboo a bɛ. » ");
INSERT INTO yns_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Apan nde waa kàtɛn a alɔŋki ande naa: « Taaŋ là paa làsàkwen bɛ muman Mwan a mbuur itàkal ilä mwɛy mpɛl, wɛɛ bɛ làsun'man anki. ");
INSERT INTO yns_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ba bàsàlakyäänà naa: \"Làler kunà!\", taaŋ lumwɛy naa: \"Làler kà!\" Wɛɛ twon lan'kyà, twon lan'kaamà ntiin. ");
INSERT INTO yns_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ilä a Mwan a mbuur isàkal asànaa muŋyä ufàparà wa udu, anà ufàpà wa kyɛɛy awa ntsü anà ntsü. ");
INSERT INTO yns_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wɛɛ kusà nde akyer atàman mpay mbɔɔn anà baar a mpalàbà bàkyer un'tɔn. ");
INSERT INTO yns_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Lalan ndaa yàlyaaŋ utaaŋ a Nɔwa, isàkal sye kà ilä a Mwan a mbuur. ");
INSERT INTO yns_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Baar bàkyer afadyaa, bàkyer afanwaa, bàkyer afataa an'bɔr, bàkyer afapaa baan aba an'bɔr, tii ilä kàbilà Nɔwà kà an'swà. An'dà màyööl ma mɛɛn, laa bàkü ba banswà. ");
INSERT INTO yns_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Isàkal sye asànaa utaaŋ a Lɔti: baar bàkyer afadyaa, bàkyer afanwaa, bàkyer afasoomà, bàkyer afayälà, bàkyer afakɔnà, bàkyer afatɔŋà. ");
INSERT INTO yns_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wɛɛ ilä kàtoo Lɔti u Sɔdɔm, mbul a in'kul a mbaa laa kàfü wa du, kàdwä wa ba banswà. ");
INSERT INTO yns_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ya isàkal abà sye kà ilä a Mwan a mbuur usàmɛnà nde. ");
INSERT INTO yns_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ilä akin, mbuur asàkal udu a nsyä a ndwà ande, ufàsàbilà anki u ndwà ntɔn mukàwal indiir ande, ifà imwɛy sye akà mbuur asàkal kan'ywaŋ usàkwo anki mufurà ndwà ande. ");
INSERT INTO yns_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Làyɔbà un'kyay a Lɔti! ");
INSERT INTO yns_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mbuur asàkwen muyee mɔ̈ɔ̈ ande, wa asàkyà bwà, wɛɛ mbuur asàkɔɔb mɔ̈ɔ̈ ande, akyer asàwal wa. ");
INSERT INTO yns_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mɛ alàkyään naa: u mpib ayin, baar bɔ̈ɔ̈l bàsàkal ibɔ̈ɔ̈n imwɛy: umwɛy bàkyer asun'syen, umwɛy bàkyer asun'wɛy. ");
INSERT INTO yns_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Akaar bɔ̈ɔ̈l bàsàkal mutswà ikal imwɛy: un'mwɛy bàkyer asun'syen, un'mwɛy bàkyer asun'wɛy. ");
INSERT INTO yns_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Abaal bɔ̈ɔ̈l bàsàkal kà ibɔr: umwɛy bàkyer asun'syen, un'mwɛy bàkyer asun'wɛy. » ");
INSERT INTO yns_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Alɔŋki ande bun'fuul naa: « Mwol, ndaa ayi isàkal ken? » Waa nde kafuur naa: « Ntsü isàkal ndom, akun sye inkaak isàköŋ bya. » ");
INSERT INTO yns_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ilä mwɛy Yɛsu katɛɛl nsim yi ntɔn muswaŋ ba naa ba bàkyer ayamà taaŋ lanswà, bàkɔ̈ɔ̈n ayɔɔn: ");
INSERT INTO yns_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","« U bul mwɛy, kàkäl anà ntɛɛn mwɛy. Nde Nzam kàfun'weemà anki, nde mbuur wanswà kàfun'manà naa wa undiir a bunàbun. ");
INSERT INTO yns_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","U bul nsil alan kàkäl sye anà un'kweel a un'dim mwɛy kàfayaa taaŋ lanswà akà nde ntɔn nde ulɔ̈ɔ̈n ndaa ande, nde kàtɛɛnà naa: \"Mpɛ iböŋ udu a un'yiiŋ amɛ!\" ");
INSERT INTO yns_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Taaŋ mbɔɔn ntɛɛn awà kàkyer atɔnà, wɛɛ mpal mwɛy nde kàtɛn u mpem ande naa: \"Yà ndandaa naa mɛ Nzam bɔɔmà in'fun'man anki, mɛ sye akà mbuur mwɛy làkoo in'fun'sà anki, ");
INSERT INTO yns_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","wɛɛ asànaa un'kweel a un'dim wà kàman'sà pfwopfwo, mɛ in'kyer un'lɔ̈ɔ̈n ndaa ande, naa tɛy, usinayaa nde abà, nde ayan'twääl lingyoomà.\" » ");
INSERT INTO yns_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Apan Mwol waa ufàkwɛy naa: « Làwem ndaa kan'tɛn ntɛɛn un'be wà! ");
INSERT INTO yns_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wɛ bɛ làsii naa Nzam uyàpà anki iböŋ agyägyä akà baar ande kàsɔ̈ɔ̈l nde, bàfun'bel mpib anà mwäänà? Nde ayàbwiy mpib mukyer abà? ");
INSERT INTO yns_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mɛ, mɛ alàkyään naa nde ba iböŋ ayapà agyägyä. Wɛɛ, nkye mpal usàyà Mwan a mbuur, nde akyer asàtaan làkwikilà u mɛɛn? » ");
INSERT INTO yns_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ungö apan Yɛsu kàfàtà nsim ntɔn baar bàfàkyey uyɔl naa ba bà baar a balàbal anà bàfàbɛy baar bumwɛy. ");
INSERT INTO yns_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Nde kàtɛn abà: « Baar bööl bàkaanà u ndwà a Nzam mukàyamà: umwɛy kàkäl Umfarisi, wumwɛy un'füür a itɛr. ");
INSERT INTO yns_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Umfarisi kàkäl umbär anà muyamà u mpem ande naa: \"Ɔɔ Nzam, mɛ amafuur an'tɔɔn ntɔn mukɔɔn akal asànaa baar bumwɛy, aŋunkaam, baar mpa abà balàbal, baar a inswem, itàkal asànaa un'füür a itɛr wà. ");
INSERT INTO yns_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mɛ in'fàkin mbɔr ilä byeel u mpɔsà mwɛy, in'fàpà kwen unsà indiir nkam amɛ byanswà.\" ");
INSERT INTO yns_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Un'füür a itɛr kàkäl ukɔl, nde kàkwen anki musuub ntabwey ande. Wɛɛ nde kàyabɛɛrà itɔl ande, waa kàtɛɛnà naa: \"Ɔɔ Nzam, ngwem ngyɛb ntɔn mɛ in'wà mbuur a man'be!\" ");
INSERT INTO yns_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ndandaa mɛ alàkyään, un'füür a itɛr Nzam kun'twey mbuur a balàbal mpal kàfurà nde ndwà ande, wɛɛ kà Umfarisi anki. Ntɔn mbuur wanswà afàsɛnà bàkyer afun'tyeey, wɛɛ mbuur afàtyà bàkyer afun'sɛɛn. » ");
INSERT INTO yns_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Umpal ayin yàmɛnà naa baar bàyàtwaal baan ambɛy akà Yɛsu ntɔn nde kasi an'kɔɔ. Alɔŋki bàmɛn ba abun, waa baŋän. ");
INSERT INTO yns_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yɛsu waa kabel, waa kàtɛn naa: « Lawɛy baan bàyi apà mɛ! Twon làmatsuŋ, ntɔn imwol a Nzam kye a baar abà asànaa ba. ");
INSERT INTO yns_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mɛ ndandaa alàkyään, mbuur mpa awal imwol a Nzam asànaa mwan, nde kya usàbilà anki. » ");
INSERT INTO yns_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mfum mwɛy kàfuul Yɛsu naa: « Un'lɔɔŋ aŋàbwaŋ, mɛ in'kyer aben muwal möö a mbul a in'tye? » ");
INSERT INTO yns_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yɛsu kàtɛn a nde naa: « Ntɔn nkye aman'bel ngye aŋàbwaŋ? Akà mbuur mwɛy wàŋàbwaŋ watɛy, usàkɔɔn akal Nzam mpɛl. ");
INSERT INTO yns_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ngye akiyöb in'kɔɔn: \"Twon an'tà inswem, twon an'lɔ, twon an'yib, twon an'tà imbäl a loor, sà làkoo akà taaràŋà anà ngwa.\" » ");
INSERT INTO yns_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wɛɛ nde kun'fuur naa: « Ayin yanswà mɛ in'kyer afàlab sɛmà imbɛy. » ");
INSERT INTO yns_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ungö kàwem nde abwɛy, Yɛsu kun'fuur naa: « Undiir mwɛy mpɛl kàmasääl: Yälà indiir angye byanswà, waa akääb ngim ayin aŋàlàmbwà, waa ngye asàwal un'naaŋ u du. Ungö, yan'läb! » ");
INSERT INTO yns_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Umpal kàwem mbuur awà abwɛy, nde kàmɛn mpay mbɔɔn u mpem ande, ntɔn nde kàkäl ŋunaaŋ a kölàköl. ");
INSERT INTO yns_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yɛsu kàmɛn nde naa ŋun'naaŋ kan'kwamà ndür, nde kàtɛn naa: « Yà mpay akà aŋin'naaŋ mubilà uboo a Imwol a Nzam! ");
INSERT INTO yns_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Lalan mpay yatɛy akà mpoonà mubilà u mun a nsway akwà naa ŋun'naaŋ mubilà uboo a Imwol a Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Baar bun'weemà bàtɛn naa: « Woo, abwɛy nà kan'kwo muwà mɔ̈ɔ̈? » ");
INSERT INTO yns_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yɛsu kafuur naa: « Indiir mpa bàfàkwo baar, akà Nzam bya mpay byatɛy. » ");
INSERT INTO yns_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Apan Petɔlà waa kàtɛn naa: « Atöl bi, bi kàsàwɛy indiir abi ŋakwo ntɔn mulab ngye. » ");
INSERT INTO yns_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yɛsu kàtɛn a ba naa: « Ndandaa mɛ alàkyään, isàkal naa ntɔn imwol a Nzam, mbuur an'sàwɛy ndwà ande, un'kyay ande, atɔŋ ande, aböör ande itàkal baan ande, ");
INSERT INTO yns_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nde asàwal mbɔɔn u mpalàyi, wɛɛ umpal isàyà nde asàwal mɔ̈ɔ̈ a mbul a in'tye. » ");
INSERT INTO yns_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yàmɛnà naa Yɛsu kàwɛl Bàkwen Aŋiyweel tsütsü apà nde, waa kàtɛn a ba naa: « Làler, bi ibeenà Yɛlusàlɛm, ndaa yanswà bàsön aŋangɔɔm ntɔn Mwan a mbuur ikyer akàkwo. ");
INSERT INTO yns_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lalan ba bàyun'pà kà an'kɔɔ a baar mpa bàyöb Nzam, ba bàkyer ayun'sɛ, bàkyer ayun'to, bàkyer ayun'tsul an'te. ");
INSERT INTO yns_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ungö apan ba bàkyer ayun'kam an'füm, waa bàyun'dwa. Wɛɛ kà ilä kyàtär nde akyer ayàwiyà. » ");
INSERT INTO yns_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wɛɛ alɔŋki ande bàyöbà anki akà undiir unsà ndaa ayin, mbuul aya bàkyer ayee, ba bàyöb anki naa Yɛsu nkye kàkwen mutɛn. ");
INSERT INTO yns_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mpal kàkäl Yɛsu tsütsü a Yɛlikɔ, ikwàmii mwɛy kàkäl aŋàbwaay ukɔl a mbwo wàmulɔɔmà akà baar. ");
INSERT INTO yns_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mpal kàwem nde làso a baar bàkäl mulyaaŋ, nde kàfuul naa nkye ikalyaaŋà. ");
INSERT INTO yns_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ba bun'kyään naa Yɛsu un'nsi Nazàlɛr wàmulyaaŋ. ");
INSERT INTO yns_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nde kàkuub in'lalà: « Yɛsu, Mwan a David, ngwem ngyɛb! » ");
INSERT INTO yns_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Baar bàyikyeenà kusà bun'tsüŋà musà làso, wɛɛ nde kàsöönà mukuub in'lalà: « Mwan a David, ngwem ngyɛb! » ");
INSERT INTO yns_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yɛsu laa kàmbär nde, waa kàswɛŋ naa bun'twääl awà. Mpal kàtöl ikwàmii tsütsü apà nde, Yɛsu kun'fuul naa: ");
INSERT INTO yns_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","« Ngye ininà akwen mɛ mukyer ntɔn ngye? » Ikwàmii kun'fuur naa: « Mwol, wɛy mɛ in'fàman. » ");
INSERT INTO yns_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Wɛɛ Yɛsu waa kàtɛn a nde naa: « Fàman! Làkwikilà angye làmakɔɔr. » ");
INSERT INTO yns_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Apan sye laa kàfàman nde, kàläb nde Yɛsu, wàmuyisyäŋà Nzam. Baar banswà bàmɛn ba abun laa bàsyäŋà ba Nzam. ");
INSERT INTO yns_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ilä mwɛy Yɛsu kàbilà u Yɛlikɔ, nde kàlyaaŋ uboo a la. ");
INSERT INTO yns_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wɛɛ le, kwo kàkäl anà mbuur ikɔb ande Zakay. Nde kàkäl mfum a afüür a itɛr, nde kàkäl ŋun'naaŋ. ");
INSERT INTO yns_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nde kàkweenà muman naa Yɛsu kàkäl nà, wɛɛ nde kàkwe anki ntɔn baar bàkäl mbɔɔn, ntɔn nde kàkäl ikökö. ");
INSERT INTO yns_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nde kàkaamà ntiin kusà, waa kàlär udu a un'te ntɔn nde umɛn Yɛsu ntɔn nde ayàlyaaŋ paa. ");
INSERT INTO yns_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mpal kàkɔlà Yɛsu kà ikal akin, nde kàler u du, waa kàtɛn a nde naa: « Zakay, yatɔlà agyägyä, mɛ ŋàbà in'kàbɔ̈ɔ̈n u ndwà angye. » ");
INSERT INTO yns_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakay kàtɔlà agyägyä, waa kàwɛl Yɛsu unsà un'sak. ");
INSERT INTO yns_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mpal bàmɛn baar abun, ba banswà bàkyer aŋüŋün, waa bàtɛn naa: « Làler, nde akyer akàbɔ̈ɔ̈n u ndwà a mbuur a man'be wà! » ");
INSERT INTO yns_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wɛɛ Zakay laa kàmbär nde, waa kàtɛn a nde naa: « Mwol, wem, mɛ in'pà boboo a indiir amɛ akà aŋàlàmbwà, isàkal naa mɛ kàgyɔɔr undiir a mbuur, mɛ un'fuur mbalà nà udu a wa. » ");
INSERT INTO yns_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Apan Yɛsu kàtɛn ntɔn nde naa: « Ŋabawà mɔ̈ɔ̈ kan'bilà u ndwà ayi, ntɔn nde sye wà mwan a Abàlam. ");
INSERT INTO yns_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ntɔn Mwan a mbuur kàyi muleŋ anà mutswà mɔ̈ɔ̈ a baar bàdiimà mbwo. » ");
INSERT INTO yns_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Umpal bàkäl ba muweemà ndaa ayi, Yɛsu kàläb mutà nsim mwɛy. Ntɔn nde kàkäl tsütsü a Yɛlusàlɛm, wɛɛ ba bàsii naa Imwol a Nzam ikyer amɛnà apanà. ");
INSERT INTO yns_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Làwem ndaa kàtɛn nde: « Mbuur mwɛy wà ywar a imwol kàkäl tsütsü mukyà nsi a kwɛl ntɔn bun'si mfum. Ungö nde waa kàyàfurà nsi ande. ");
INSERT INTO yns_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nde kàbel baar kwem uboo a asyääl ande, waa kàpɛ akà umwɛy umwɛy itɛr a wɔl. Ungö apan nde kaswɛŋ mutà yà a ngim ayin ntɔn ya ibör yàsin tii mpal usyefurà nde. ");
INSERT INTO yns_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wɛɛ mbuur awà, baar a nsi ande bàfun'kwenà anki. Lalan bàtöm ba akyeey ungö ande ntɔn mutɛn naa: \"Bi ikwen anki naa mbuur awun uyaal u nsi abi!\" ");
INSERT INTO yns_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ungö bun'si ba mfum, nde kàfurà nsi ande. Nde kàbel asyääl akwà kàpɛ nde ngim ntɔn muyöb naa ya ininà yàbör. ");
INSERT INTO yns_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wàtàtwɛb kàyi nde, kàtɛn naa: \"Un'lɔɔŋ, itɛr a wɔl angye kyan'bɔr itɛr kwem.\" ");
INSERT INTO yns_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Apan, Nkum ande naa: \"Yubwaŋ mbɔɔn, ngye awà un'syääl aŋàbwaŋ! Ngye an'syääl balàbal unsà undiir ikikye, mɛ amasà mfum a an'bul a kölàköl kwem.\" ");
INSERT INTO yns_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wàyweel waa kàyàsin, waa kàtɛn naa: \"Un'lɔɔŋ, itɛr a wɔl a ngye kyan'bɔr ityeen asin.\" ");
INSERT INTO yns_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nkum waa kàtɛn ande sye naa: \"Yubwaŋ, mɛ amasà mfum a an'bul a kölàköl an'tyeen.\" ");
INSERT INTO yns_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ungöngö, umwɛy waa kàyi, waa kàtɛn naa: \"Mwol, itɛr a wɔl angye kyaki: mɛ kya kàyee uboo a itɛɛnà a ipfɛy. ");
INSERT INTO yns_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Lalan mɛ kàmɛn bɔɔmà angye, ntɔn ngye awà mbuur a ndaa a ngwal, ngye afàwal ngim kà ikal mpa kàsi ngye, ngye afàbwo ywaŋ mpa kàkön ngye.\" ");
INSERT INTO yns_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nde waa kàtɛn a nde naa: \"Un'syääl un'be! Mbar angye mɛ in'tsul unsà ndaa angye ŋakwo! Ngye kàkyer ayöb naa mɛ in'wà mbuur a ndaa a ngwal, in'fàwal ngim kà ikal mpa kàsi mɛ, in'fàbwo ywaŋ mpa kàkön mɛ. ");
INSERT INTO yns_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wɛɛ ntɔn nkye mpa kàsi ngye ngim amɛ u bank? U mfurà amɛ, mɛ in'làwal bweel!\" ");
INSERT INTO yns_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Apan nde kàswɛŋ akà baar bàkäl paa: \"Làduum itɛr a wɔl kin akà nde, làpɛ kya akà mbuur awe abyà kwem!\" ");
INSERT INTO yns_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ba waa bàtɛn a nde naa: \"Un'lɔɔŋ, nde we abyà kwem!\" ");
INSERT INTO yns_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mɛ alàkyään naa: \"mbuur awe anà bya bàkyer asun'kwɛy, wɛɛ mbuur mpa awe undiir bàkyer asun'lwom itàkal kindam awe nde akyà! ");
INSERT INTO yns_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wɛɛ ayiiŋ amɛ akwà mpa bàkwen naa mɛ in'käl mfum, latwääl pà, ladwä u mii amɛ!\" » ");
INSERT INTO yns_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ungö mutɛn abà, Yɛsu kàkyen kusà a un'sɛŋ a baar kàkäl mubeenà Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mpal kàsin nde tsütsü apà Bɛtfagɛ anà Bɛtani, tsütsü apà mɔŋ bàfàbel naa mɔŋ a in'te a ɔlivɛ, nde kàtöm alɔŋki bööl kusà, ");
INSERT INTO yns_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","waa kàtɛn naa: « Làkyen u bul lanà u sim. Bɛ làsàkɔlà, bɛ làkàman mwan a anɛ wàŋabäm, udu awa mbuur ŋàtàlaar anki. Lun'tsuuŋ, lun'twääl pà. ");
INSERT INTO yns_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wɛɛ isàkal naa mbuur amàlafuul naa: \"Ntɔn nkye làtsuuŋà bɛ wa?\" Lun'fuur naa: \"Mwol we anà mfun a wa.\" » ");
INSERT INTO yns_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Umpal bàkyen antööm, ba bàmɛn asànaa kàtɛn Yɛsu. ");
INSERT INTO yns_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Utaaŋ bàkäl ba mutsuuŋ mwan a anɛ wa, aŋawa bafuul naa: « Ntɔn nkye làtsuuŋà bɛ wa? » ");
INSERT INTO yns_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ba bàfuur naa: « Mwol we anà mfun a wa. » ");
INSERT INTO yns_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Apan ba bàsyen mwan a anɛ akà Yɛsu. Ba bàyeel ipfɛy aba udu a ntsür, waa bàbay Yɛsu mulaar udu awa. ");
INSERT INTO yns_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mpal kàkäl nde muyikyà, baar bàyiyeelà ipfɛy aba u mbwo. ");
INSERT INTO yns_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Utaaŋ kàkäl nde tsütsü a Yɛlusàlɛm, u mbumà a mɔŋ a in'te a ɔlive, un'kàbɔ a alɔŋki wanswà kàkäl mukömà Nzam unsà un'sak, u ndaa a ngwal, ntɔn impà byanswà bàmɛnà ba. ");
INSERT INTO yns_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ba bàtɛɛnà naa: « Wɛy Nzam usaak mfum kan'yà kà ikɔb a Mwol! Duu u dudu anà làkoo akà Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Uboo a un'kàbɔ awà bàkäl anà Amfarisi amwɛy, ba bàtɛn a Yɛsu naa: « Un'lɔɔŋ, aswɛŋ alɔŋki angye bàwɛy musà làso. » ");
INSERT INTO yns_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yɛsu waa kafuur naa: « Mɛ alàkyään naa ba bàsàkal a duu, in'kul ikyer a kuub in'kwɛŋ. » ");
INSERT INTO yns_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mpal kàkäl Yɛsu tsütsü a bul a kölàköl anà kàmɛn nde la, nde kàkyer alel ntɔn la, ");
INSERT INTO yns_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","anà kàtɛn nde naa: « Ngye sye alàyöb ŋàbà naa ngye akyer aben muman duu! Wɛɛ apanà ndaa ayi yàŋayee u mii angye! ");
INSERT INTO yns_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ntɔn ngye, ilä abyà iyà ungö ayiiŋ angye bàkyer asasà uboboo a ibä, bàkyer asadiŋà anà bàsaküünà ntsü yanswà. ");
INSERT INTO yns_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ba bàkyer asapay ipepey, ngye anà baar angye. Ba bàsàwɛy anki un'kul udu a un'kul wumwɛy, ntɔn ngye kàyöb anki taaŋ kàyi Nzam muyaler! » ");
INSERT INTO yns_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ungö apan Yɛsu kàbilà u ndwà a Nzam, waa kàsɛmà muböŋ ayääl, ");
INSERT INTO yns_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","waa kàtɛn a ba naa: « Bàsön naa: \"Ndwà amɛ isàkal ndwà a ngyamàkà.\" Wɛɛ bɛ ya lan'buul mboo a mbüüb! » ");
INSERT INTO yns_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yɛsu kàlɔɔŋà ilä byanswà u ndwà a Nzam. Amfum a angaŋ, alɔɔŋ a in'kɔɔn anà abyääl a baar banswà bàleŋà mukun'dwa. ");
INSERT INTO yns_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wɛɛ ba bàyöbà anki naa ba bàkyer aben mukɔr nde, ntɔn baar banswà bàkäl muweemà nde ubwaŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yàmɛnà naa ilä mwɛy, Yɛsu kàkäl mulɔŋ baar u ndwà a Nzam anà mupay Làsaŋ Aŋàbwaŋ. Amfum a angaŋ, alɔɔŋ a in'kɔɔn anà andweer bàyi ");
INSERT INTO yns_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mukun'fuul naa: « Ikyään, unsà ikɔ̈b nà akakyerà ngye indiir abi, nà kapɛ ikɔ̈b udu a bya? » ");
INSERT INTO yns_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yɛsu kafuur naa: « Mɛ sye in'kwen mukàlafuul undiir mwɛy. Lan'kyään: ");
INSERT INTO yns_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ywan nà kun'töm mudümà baar? Du lɛɛ baar? » ");
INSERT INTO yns_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wɛɛ ba bàbulà muyweer ba a ba naa: « Bi isàfuur naa: \"Du kun'töm\", nde ayifuul naa: \"Ntɔn nkye mpa lun'kyey bɛ?\" ");
INSERT INTO yns_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wɛɛ bi isàtɛn naa: \"Baar bun'töm\", baar banswà bàyilom in'kul, ntɔn ba bàkyàyöb naa Ywan kàkäl ŋangɔɔm. » ");
INSERT INTO yns_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Apan ba bun'fuur naa: « Bi iyöb anki naa nde kàfü ken. » ");
INSERT INTO yns_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yɛsu waa kàtɛn a ba naa: « Aay, mɛ sye alàkyään anki naa nà kan'pɛ mbwo mukyer indiir abi. » ");
INSERT INTO yns_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Apan nde kàfàtɛɛl un'sɛŋ nsim yi: « Mbuur mwɛy kàkön ywaŋ a vin. Nde kàsɔ̈ɔ̈m la akà baar bàfàkyer vin ntɔn ba bàkyer isal aba uboo kwo. Ungö nde kàkyen nsi a kwɛl. Nde kwo kàkyer taaŋ mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Taaŋ abwo mbɛŋ làkwe la, nde kàtöm un'syääl ande mwɛy akà baar aban ntɔn ba bun'pɛ kab lànde. Wɛɛ akyeer a man laa bàdüb ba un'syääl awun, waa kàfurà an'kɔɔ ipɔl. ");
INSERT INTO yns_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ŋaywaŋ kàtöm un'syääl asin. Nde awà sye bàkyer un'düb, bàkyer un'to, waa bun'fuur an'kɔɔ ipɔl. ");
INSERT INTO yns_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nde kàfàtɔm un'syääl wàtär. Awun sye bun'yɔ̈ɔ̈l, waa bun'böŋ. ");
INSERT INTO yns_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ŋaywaŋ kàyweer naa: \"Mɛ in'kyer aben? Mɛ in'tɔm mwan baal amɛ in'fàkwen mɛ, mɛ in'sii naa ba bàkyer akun'sà làkoo.\" ");
INSERT INTO yns_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wɛɛ mpal bun'mɛn akyeer a vin, ba bàyweerà ba a ba naa: \"Làler ikyee! Yää bi kun'dwä waa ywaŋ a vin làyàbulà làbi.\" ");
INSERT INTO yns_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Laa bun'böŋ ba, waa bun'dwä. « Apan ŋaywaŋ asàkyer aben ntɔn ba? ");
INSERT INTO yns_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nde ŋakwo akyer asàyà, nde asàdwa akyeer a man abà banswà, waa usàsɔɔm ywaŋ akà baar asin. » Mpal bàwem baar ndaa ayi yanswà, ba bàtɛn naa: « Ndaa a tub ayi isàbwà anki! » ");
INSERT INTO yns_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wɛɛ Yɛsu kaler nde, waa kàtɛn naa: « Ndaa bàsön yi iswaŋà aben: \"Nkɔŋ bàpiy atööŋ a ndwà, \"yàbulà nkɔŋ a twɛrà.\" ");
INSERT INTO yns_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","« Mbuur wanswà asàbwà udu a nkɔŋ ayin akyer asàbɔɔ. Wɛɛ isàkal naa nkɔŋ ayi yan'bweel mbuur, nde akyer asàpää nwamnwam. » ");
INSERT INTO yns_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Taaŋ nsil alan, alɔɔŋ a in'kɔɔn anà amfum a angaŋ bàkwen mukɔr Yɛsu, ntɔn ba bàkyer ayöb naa nde nsim yi ba kàtɛɛl, wɛɛ ba bàtiinà un'seŋ bɔɔmà. ");
INSERT INTO yns_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Apan ba bàsɛmà musey Yɛsu. Lalan bun'tööm ba baar bàfakurà naa ba bà baar aŋàbwaŋ. Baar abà bàlàlwab Yɛsu ndaa unsà mfuul mwɛy ntɔn ba bàwɛl iböŋ mukun'yälà akà abyääl anà akà mfum a nsi. ");
INSERT INTO yns_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Baar aban bàtɛn a nde naa: « Un'lɔɔŋ, bi ikyàyöb naa ndaa afàtɛn ngye anà afàlɔŋ ngye yà ndandaa. Ngye afàler anki ntabwey a mbuur mupà nde ikwàndwà, wɛɛ ngye afàlɔŋ ndandaa mbwo a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wɛɛ bi ikwen muyöb naa nkye un'kɔɔn abi kà ipaa mbwo bi mufur itɛr akà Sɛzar lɛɛ tɛy? » ");
INSERT INTO yns_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Wɛɛ Yɛsu kàyöb nkwɛɛr a ba, waa kàtɛn a ba naa: ");
INSERT INTO yns_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","« Lan'swɛŋ itɛr a ngim. Ntabwey anà ikɔb ki udu a kya byà nà? » Ba bàfuur naa: « Byà Sɛzar. » ");
INSERT INTO yns_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Apan Yɛsu kàtɛn a ba naa: « Abun, làpɛ yà Sɛzar akà Sɛzar, yà Nzam akà Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Lalan ba bàsàman anki ube unsà yinà yanswà kàtɛɛnà nde u mii a baar. Ba bàkäl mubem mfuur ande, ba ndaa bàfàsà anki. ");
INSERT INTO yns_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yàmɛnà naa Asadusu amwɛy bàyi akà Yɛsu. Ba baar bàfàtɛn naa akü bàfàwiyà anki. Ba bun'fuul, ");
INSERT INTO yns_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","waa bàtɛn a nde naa: « Un'lɔɔŋ, Mɔsɛ kà ipɛ un'kɔɔn aŋàsɔn: \"Isàkal naa mbuur aŋàkwɛl kan'kwà ukɔɔn asàwɛy baan, un'tɔŋ ande asàwal un'kyay kàkäl wànde ntɔn mupà ikyee akà un'kü.\" ");
INSERT INTO yns_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kyekà, bàkäl anà atɔŋ nsambwaar. Wàtàtwɛb kàkyer abääl, ungö waa kàkü ukɔɔn abɔr. ");
INSERT INTO yns_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wàyweel waa kàbääl un'kaar kàsàwɛy bweel ande, ");
INSERT INTO yns_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","wàtär sye abun. Ya yàkäl abun ntɔn ba bànsambwaar: ba bàkü ukɔɔn abɔr. ");
INSERT INTO yns_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ungö apan un'kaar sye waa kàkü. ");
INSERT INTO yns_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Abun, ilä bàsàwiyà akü, un'kaar awà asàkal un'kyay a nà? Ntɔn ba bànsambwaar bàkyer un'bääl. » ");
INSERT INTO yns_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Wɛɛ Yɛsu kafuur naa: « Abaal anà akaar a nsi yi bàkyer afàbääl, ");
INSERT INTO yns_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","wɛɛ abaal anà akaar bàsɔ̈ɔ̈l muwiyà kà ukwà anà mukal anà mɔ̈ɔ̈ taaŋ làsàyà, bàsàbääl anki. ");
INSERT INTO yns_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ba bàfàsàkwà anki, ba bà asànaa akyeey a du. Ba bà baan a Nzam, ntɔn ba baan a ngwiiyà. ");
INSERT INTO yns_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mɔsɛ ŋakwo kàtɛn ubwaŋàbwaŋ naa akü bàkyer asàwiyà. Uboo a nsim a ibwiy a mbaa, nde Mwol Nzam kun'bel Nzam a Abàlam, Nzam a Isak, Nzam a Yakɔb. » ");
INSERT INTO yns_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yɛsu kàfàkwɛy naa: « Mwol wà Nzam a baar a möö, nde kà wà Nzam a akü anki, ntɔn akà nde baar banswà bye anà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Alɔɔŋ a in'kɔɔn amwɛy bàtɛn a nde naa: « Un'lɔɔŋ, ngye an'tɛn ubwaŋ. » ");
INSERT INTO yns_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Abun ba nde ndaa bàfun'fuul anki. ");
INSERT INTO yns_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yɛsu kàtɛn a ba naa: « Ban'kwo mutɛn aben naa Klistɔ wà mwan a David? ");
INSERT INTO yns_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ntɔn David atɛɛnà nde ŋakwo uboo a un'kaan a an'diim naa: \"Mwol kàtɛn akà Mwol amɛ: \"Bwaay u kɔɔ amɛ là ibaal, ");
INSERT INTO yns_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mɛ in'kwen mubwiy ayiiŋ angye ntɔn ba bàbulà ikal angye mutɔɔl in'kɔl.\" ");
INSERT INTO yns_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David kun'bel Mwol: Klistɔ kan'kwo mufàkal mwan a David? » ");
INSERT INTO yns_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ilä mwɛy, mpal kàkäl un'sɛŋ wanswà mulab an'lɔɔŋ ande, Yɛsu kàtɛn a alɔŋki ande naa: ");
INSERT INTO yns_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","« Làkäl kà igyɛɛŋ ntɔn alɔɔŋ a in'kɔɔn: isal aba uyilyaaŋ anà mvwɛl anà bàfàkwɛn naa bàyapà mbɔr u balàbal. Ba bàfàsɔɔl an'kir amà kusà uboo a ndwà a nköŋ a Ayudà anà ikal a làkoo u mɛsà adyà a kölàköl. ");
INSERT INTO yns_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ba bàfàduum indiir a akweel a adim byanswà, taaŋ nsil alan ba bàfàsà ngyamàkà a bwɛlàbwɛl ntɔn baar bamɛn: nsaŋ aba isàkal yà kölàköl. » ");
INSERT INTO yns_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yàmɛnà naa ilä mwɛy, mpal kàkäl Yɛsu muler, nde kàmɛn aŋin'naaŋ bàmusà an'kab aba uboo a insak a an'kab. ");
INSERT INTO yns_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nde kàmɛn sye un'kweel un'dim mwyɛ wàŋàlàmbwà wàmusà an'falà mɔ̈ɔ̈l. ");
INSERT INTO yns_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nde kàtɛn naa: « Ndandaa mɛ alàkyään: un'kweel un'dim wàŋàlàmbwà wà kan'pà yàŋàsöön baar banswà. ");
INSERT INTO yns_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ntɔn baar bumwɛy banswà ban'pà ngim ikɔ̈ɔ̈n ndöŋ akà ba, wɛɛ nde, unsà làmbwà ande, nde kan'pà yinà yanswà ikäl ntɔn mɔ̈ɔ̈ ande. » ");
INSERT INTO yns_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ilä mwɛy, baar amwɛy bàkäl mukan in'kul anà indiir byàpɛɛ ntwɛn a ndwà a Nzam, wɛɛ Yɛsu kàtɛn naa: ");
INSERT INTO yns_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","« Ilä byà paa mpa usàsaal akà un'kul mwɛy udu a un'kul wumwɛy uboo a bya làmanà bɛ bi: bya byanswà byàsàkyer apää. » ");
INSERT INTO yns_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Apan ba waa bun'fuul naa: « Un'lɔɔŋ, ndaa ayi isàlyaaŋ mpal nà? Undiir nà asàswaŋ ngyeel a ndaa ayi? » ");
INSERT INTO yns_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yɛsu kàfuur naa: « Làkäl kà igyɛɛŋ, mbuur twon amàlakur. Ntɔn baar mbɔɔn bàsàyà kà ikɔb amɛ, waa bàsàtɛn naa: \"Mɛ in'wà Klistɔ!\" Anà: \"Taaŋ lan'kwo!\" Wɛɛ twon làmalab. ");
INSERT INTO yns_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mpal làsàwem bɛ naa ità anà lingyoomà byan'yà, twon lan'man bɔɔmà: yubwaŋ naa bya itàyà abun kusà, wɛɛ bya kà ntsüü anki. » ");
INSERT INTO yns_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Apan nde waa kàtɛn a ba naa: « Isàmɛnà naa nsi mwɛy yàmunwan anà nsi yumwɛy, imwol mwɛy anà imwol kyumwɛy. ");
INSERT INTO yns_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mɛɛn ikyer asàtɛɛr ngwal. Kà ikal mbɔɔn ngyal mbɔɔn anà an'fway màkyer asàbilà, ndaa a bɔɔmà yà ifà ifà ikyer asàtoo, idiim a kölàköl byàkyer asàmɛnà u du. ");
INSERT INTO yns_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wɛɛ kusà a ndaa ayi yanswà, bàkyer asàlakɔr, bàkyer asàlamɛɛy nkwaaŋ, bàkyer asàlasyen u làbay a nsaŋ a amfum a ndwà a nköŋ a Ayudà, waa bàsàlatɔɔm u bɔlokà. Ntɔn ikɔb amɛ, bàkyer asàlasyen akà amfum a nsi anà akà amfum a itiir a nsi. ");
INSERT INTO yns_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Indiir abi byanswà isàlayeel ntɔn bɛ làkäl anà mbwo mutà imbäl. ");
INSERT INTO yns_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Twon lan'yweer kusà naa bɛ làkyer aben musàsà un'lɔɔn abɛ. ");
INSERT INTO yns_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mɛ ŋakwo in'kyer asàlapà ndaa anà an'yeerà mpa bàsàtɔn ayiiŋ abɛ itàkal musà mbaaŋ. ");
INSERT INTO yns_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Baar bàsàlayälà bà aböör anà atɔŋ abɛ, baar a tsütsü a bɛ anà asam abɛ, ba bàsàdwa baar mbɔɔn uboo a bɛ. ");
INSERT INTO yns_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Baar banswà bàkyer asàlayiiŋ ntɔn mɛ. ");
INSERT INTO yns_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wɛɛ akà làtswe abɛ làmwɛy làsàdiimà anki. ");
INSERT INTO yns_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Abun, ntɔn nkääŋ a mpem abɛ, bɛ làsàwà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","« Wɛɛ mpal làsàman bɛ naa aŋità ban'diŋà Yɛlusàlɛm, apan làyöb naa mpää a la yà tsütsü. ");
INSERT INTO yns_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Apan, wɛy baar a Yuday bàtiin udu a myɔŋ. Wɛy baar abà u Yɛlusàlɛm bàtoo agyägyä. Wɛy baar abà u bitsuŋ a ndwà bàkɔ̈ɔ̈n abilà u bul a kölàköl! ");
INSERT INTO yns_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ntɔn ilä abin isàkal ilä a bweel, ntɔn Ndaa Aŋàsɔn yanswà ikwe. ");
INSERT INTO yns_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ngyɛb akà akaar bàsàkal anà an'yöm anà akaar bàsàkal munüü baan ilä abin! Ntɔn ntaan isàkal uboo a nsi yi, anà nkyɛl ntɔn un'sɛŋ wà. ");
INSERT INTO yns_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Baar a nsi yi bàsadwa a kɔm, bumwɛy bàsasyen asɔ u nsi a ingyey, wɛ Yɛlusàlɛm làsàbulà là baar mpa bàyöb Nzam tii mpal isàwà isɔ. ");
INSERT INTO yns_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","« Idiim ikyer asàkal uboo a taaŋ, uboo a nsöŋ anà unsà mbwaar. U mɛɛn baar banswà bàsàkal mutɛɛr a bɔɔmà ntɔn làso anà ibɔ a an'dà a ngyäl. ");
INSERT INTO yns_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lalan baar mbɔɔn bàsàkwà a bɔɔmà muyweer ndaa isàbwà u mɛɛn manswà, ntɔn ngwal a du yanswà ikyer asàni. ");
INSERT INTO yns_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Apan, baar bàsàman Mwan a mbuur wàmuyà uboo a itööm unsà ngwal anà làkoo mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Taaŋ isàlyaŋ ndaa ayi yanswà, làsuub un'tswe anà làsi un'kanà, ntɔn ntsuuŋ abɛ isàkal tsütsü. » ");
INSERT INTO yns_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Apan Yɛsu katɛɛl nsim yi: « Làler un'te a maŋ anà in'te myanswà: ");
INSERT INTO yns_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bɛ làsàman naa mya myan'fulà, bɛ lan'yöb bɛ ŋakwo naa paŋà a mbul là tsütsü. ");
INSERT INTO yns_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ya sye yabun mpal làsàman bɛ naa ndaa ayi yan'yà, làyöb naa Imwol a Nzam kyà tsütsü. ");
INSERT INTO yns_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mɛ ndandaa alàkyään, nkööl ayi isàlyaŋ anki kusà a ndaa ayi yanswà mukwo. ");
INSERT INTO yns_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Du anà mɛɛn màkyer asàlyaaŋ, wɛɛ ndaa amɛ isàlyaaŋ anki akà ikikye. ");
INSERT INTO yns_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","« Làkäl kà ikyɛɛŋ bɛ ŋakwo ntɔn an'kyän abɛ màkɔ̈ɔ̈n abwà mpye ntɔn udyà mbɔɔn, unwà mbɔɔn anà ngyɛb ntɔn indiir a mɛɛn mà, naa tɛy, ilä aki isàyàlataan kà imbwirà imbwirà. ");
INSERT INTO yns_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ntɔn kya isàbwà asànaa an'tɛy udu a baar a mɛɛn banswà. ");
INSERT INTO yns_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Làkäl kà ikyɛɛŋ, làyamà taaŋ lanswà, ntɔn bɛ làkäl anà ngwal mutiin ndaa iyà yi yanswà anà musàkal umbär kusà a Mwan a mbuur. » ");
INSERT INTO yns_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","U mwäänà Yɛsu kàlɔɔŋà u ndwà a Nzam, wɛ sisye nde kàkyeenà mukàtyeey taaŋ u mɔŋ bàfàbel naa mɔŋ a in'te a ɔlive. ");
INSERT INTO yns_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ututu tutu, un'sɛŋ wanswà kàkyeenà akà nde u ndwà a Nzam ntɔn mukun'wem. ");
INSERT INTO yns_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Un'kyɔm a mampà màkɔ̈ɔ̈n ful bàfàbel Pak làsin tsütsü. ");
INSERT INTO yns_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Amfum a angaŋ anà alɔɔŋ a in'kɔɔn bàleŋà mudwa Yɛsu, wɛɛ ba bàweemà bɔɔmà a un'sɛŋ. ");
INSERT INTO yns_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Apan, Satanà kàbilà u mpem a Yudas Iskaryɔt, umwɛy uboo a Bàkwem Aŋiyweel. ");
INSERT INTO yns_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudas kàkyen akà amfum a angaŋ anà amfum a aleer a ndwà a Nzam ntɔn nde ukàyäm anà ba muyöb naa nde Yɛsu ayun'yälà aben. ");
INSERT INTO yns_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ba bàkäl kà un'sak, waa bàyilà naa ba bàyun'pà ngim. ");
INSERT INTO yns_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nde waa kàkyey. Sɛmà apan, nde kàleŋà ipöl aŋàbwaŋ muyälà Yɛsu kà unku, ntɔn baar banswà bàkɔ̈ɔ̈n ayöb. ");
INSERT INTO yns_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yàmɛnà naa ilä a mampà màkɔ̈ɔ̈n ful, ilä bàfàdwa in'tö a in'kɔk ntɔn Pak kyàkwe kya, ");
INSERT INTO yns_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yɛsu kàtöm Petɔlà anà Ywan, waa kaswɛŋ naa: « Làkyen kàlayilà ndyeel a Pak. » ");
INSERT INTO yns_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ba bun'fuul naa: « Ngye akwen naa bi la ikàyilà ken? » ");
INSERT INTO yns_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yɛsu kafuur naa: « Le, mpal làkàbilà bɛ u bul a kölàköl, bɛ làkàman mbuur mwɛy anà làbuuŋ a an'dà. Lun'läb tii u ndwà ukàbilà nde. ");
INSERT INTO yns_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Bɛ làkàtɛn a ŋandwà abà: \"Un'lɔɔŋ kan'tɛn a ngye naa: Làken suk in'dyà mɛ Pak anà alɔŋki amɛ?\" ");
INSERT INTO yns_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Waa nde ukàlaswaŋ, u ndwà adu, suk a kölàköl làŋalɔɔn ubwaŋàbwaŋ, ikal làkàyilà bɛ Pak kyakin. » ");
INSERT INTO yns_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ba waa bàkyen, bàmɛn ndaa yanswà asànaa kàtɛn Yɛsu, waa bàyilà isaa a Pak. ");
INSERT INTO yns_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Taaŋ làkwe la, Yɛsu kàkäl u mɛsà anà antööm. ");
INSERT INTO yns_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nde kàtɛn a ba naa: « Mɛ, mɛ kàkwen mbɔɔn mudyà Pak alà anà bɛ kusà muman mpay. ");
INSERT INTO yns_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Lalan, mɛ ndandaa alàkyään naa mɛ in'fàsàdyà anki la tii ilä isàmɛnà mbuul a la uboo a Imwol a Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Apan, nde kàwɛl kɔɔb, kàfuur an'tɔɔn, waa kàtɛn naa: « Làwɛl kɔɔb là, làkäb la bɛ a bɛ, ");
INSERT INTO yns_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ntɔn mɛ alàkyään naa sɛmà apanà mɛ in'fàsànwà anki vin tii mpal isàyà Imwol a Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ungö apan, nde kàwɛl mampà, waa kàfuur an'tɔɔn akà Nzam, kàtsül ma, kapɛ, waa kàtɛn naa: « Ayi ndür amɛ bàpɛ ntɔn bɛ. Làkyer abà ntɔn mukan'yɔbà. » ");
INSERT INTO yns_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ungö a udyà, nde kàwɛl kɔɔb, waa kàtɛn naa: « Lalà kɔɔb a un'tüüb akün kan'kyer bi unsà an'kil amɛ amiyàpää ntɔn bɛ. ");
INSERT INTO yns_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wɛɛ le, mbuur ayàyälà mɛ wà papà u mɛsà anà mɛɛ. ");
INSERT INTO yns_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ntɔn Mwan a mbuur wàmukyà asànaa bàtsül ya, wɛɛ ngyɛb akà mbuur kàmun'yälà! » ");
INSERT INTO yns_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Apan, ba bàbulà mufufuul ba a ba naa uboo a ba nà ayàkyer undiir a tub awà. ");
INSERT INTO yns_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yàmɛnà naa ilä mwɛy alɔŋki bàsyeelà mbaaŋ ba a ba: ba bàkwen muyöb naa uboo a ba nà awà mbuur a kölàköl. ");
INSERT INTO yns_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yɛsu kàtɛn a ba naa: « Amfum a in'sɛŋ bàkyer afandyaar, baar abye anà ikɔ̈b udu a ba bàfàleŋ naa babel baar aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kà yubwaŋ anki bɛ mukyer abà, yubwaŋ naa mbuur a kölàköl uboo a bɛ ukäl umbɛy, wɛɛ mbuur akayaalà ukäl asànaa un'syääl. ");
INSERT INTO yns_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Uboo a an'kyän abɛ, nà awà kölàköl? Mbuur kan'bwaay u mɛsà lɛɛ mbuur akapaa isaa? Kà mbuur kan'bwaay u mɛsà anki? Wɛɛ mɛ, mɛ uboo a bɛ in'wà asànaa un'syääl. ");
INSERT INTO yns_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Bɛ lan'ndäär u ndür amɛ taaŋ lanswà an'man mɛ mpay. ");
INSERT INTO yns_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Lalan, asànaa kan'pɛ Taaràmɛ Imwol, mɛ sye amàlapà kya: ");
INSERT INTO yns_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Bɛ làsàdyà anà làsànwà u mɛsà anà mɛ, uboo a imwol amɛ, bɛ làsàbwaay udu a kir a imfum ntɔn mutsul nsaŋ a in'sɛŋ a Isàlɛl myàkwem aŋiyweel. » ");
INSERT INTO yns_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yàmɛnà naa Yɛsu kàtɛn a Simɔn Petɔlà naa: « Simɔn, Simɔn! Le, Satanà kàkyer alɔm naa nde kàlasɛk asànaa bàfàsɛk mbɛŋ mukaab ya anà isɛrà. ");
INSERT INTO yns_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wɛɛ mɛ kàyamà ntɔn ngye, ntɔn làkwikilà angye làkɔ̈ɔ̈n abwà. Wɛɛ ngye, ilä asyefurà ngye akà mɛ, pà atɔŋ angye ngwal. » ");
INSERT INTO yns_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simɔn kàtɛn a nde naa: « Mwol, mɛ an'kyey mukyà anà ngye, itàkal u bɔlokà, itàkal kà ukwà. » ");
INSERT INTO yns_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yɛsu waa kun'fuur naa: « Simɔn, mɛ ndandaa akyään, ŋabawà, kusà nkɔɔ mubel, ngye akyer an'tɔn mukan'yöb mbalà tär. » ");
INSERT INTO yns_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ungö apan, nde kàtɛn a ba naa: « Taaŋ kàlatöm mɛ ukɔɔn ngim, ngɔɔr anà an'sàbar, nkye we anà undiir kàlakɔ̈ɔ̈n? » Ba waa bàfuur naa: « Akà undiir. » ");
INSERT INTO yns_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Apan, nde kàtɛn a ba naa: « Wɛɛ papanà, isàkal naa mbuur we anà ngim, uwɛl ya, isàkal sye naa mbuur we anà ngɔɔr, uwɛl wa, isàkal naa mbuur kɔm latɛy, uyälà inkur ande, usöm làmwɛy. ");
INSERT INTO yns_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ntɔn mɛ alàkyään naa yubwaŋ naa undiir aŋàsɔn wà ukwe amu mɛ: \"Nde bun'täŋ uboo a adwää baar.\" » ");
INSERT INTO yns_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Waa ba bàtɛn naa: « Mwol, le an'kɔm mɔ̈ɔ̈l amà. » Yɛsu kafuur naa: « Man'kwo! » ");
INSERT INTO yns_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yàmɛnà naa Yɛsu kàkyer atoo, waa kàkyen u mbwo a mɔŋ a in'te a ɔlive asànaa ifà ande. Alɔŋki waa bun'läb. ");
INSERT INTO yns_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mpal kàtöl nde kà ikal akin, nde kaswɛŋ naa: « Làyamà, ntɔn bɛ làkɔ̈ɔ̈n abwà u ndɛb. » ");
INSERT INTO yns_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wɛɛ nde, nde kàkyen ukɔl a ba kà isii a bwɛl ufàkàbwà un'kul awà ban'lom, kàbü an'köm, waa kàyamà ");
INSERT INTO yns_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","abà: « Ɔɔ Taa, kya ngye asàkwen, lwom kɔɔb là tsütsü apà mɛ! Wɛɛ taaŋ lanswà, wɛy bàkäl ukwen angye, kà bàmɛ anki. »  ");
INSERT INTO yns_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Apan, un'kyeey mwɛy waa kàyamɛnà akà nde ntɔn mukun'pà ngwal. ");
INSERT INTO yns_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yàmɛnà naa nkyän yàkyer un'kaar, nde kàfàyamà nswɛy nswɛy, kyaŋ a ndür ande waa làbulà asànaa bin'kul a an'kil byàbwee u mɛɛn.  ");
INSERT INTO yns_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ungö a ngyamàkà ayi, nde waa kàmbarà, kàsin tsütsü apà alɔŋki ande, nde kamɛn bàkyàbɔ̈ɔ̈n a ngyɛb. ");
INSERT INTO yns_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Apan, nde kàtɛn a ba naa: « Ntɔn nkye lan'bɔ̈ɔ̈n bɛ? Làmbarà! Làyamà ntɔn bɛ làkɔ̈ɔ̈n abwà u ndɛb. » ");
INSERT INTO yns_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nde kàkäl mutɛn, mpal kàkɔlà un'kàbɔ a baar. Mbuur bàfabeelà Yudas, umwɛy uboo a Bàkwem Aŋiyweel, kàkäl kusà a ba. Nde kàsin tsütsü apà Yɛsu ntɔn mukundüür. ");
INSERT INTO yns_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Waa Yɛsu kàtɛn a nde naa: « Yudas, ngye Mwan a mbuur un'yälà a ndüür? » ");
INSERT INTO yns_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mpal bàmɛn baar bàkäl a Yɛsu naa ndaa yan'täy, ba bun'fuul naa: « Un'lɔɔŋ, nkye bi isyääl an'kɔm abi ntɔn munwan? » ");
INSERT INTO yns_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Utaaŋ nsil alan, umwɛy uboo a ba kàkäm un'syääl a undweer a angaŋ mwɛy kɔm, waa kun'ywaŋ tsü a ibaal. ");
INSERT INTO yns_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wɛɛ Yɛsu kàtɛn naa: « Làwɛy, yan'kwo! » Apan, nde kàbä tsü a mbuur awun, waa kun'kɔɔr. ");
INSERT INTO yns_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Apan, Yɛsu kàtɛn a amfum a angaŋ, a an'kaptɛn a ndwà a Nzam anà andwer a baar bàyi ntɔn mukun'kɔr: « Nkye mɛ in'wà un'dwää a baar waa bɛ làyi anà an'kɔm anà nköl? ");
INSERT INTO yns_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mɛ kàkälà anà bɛ ilä byanswà u ndwà a Nzam, wɛ akà mbuur kan'bä anki. Apanà là taaŋ abɛ anà ngwal a mpib. » ");
INSERT INTO yns_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Apan ba bun'te mpi, waa bun'syen u ndwà a amfum a angaŋ. Petɔlà kàyilabà ukwɛl. ");
INSERT INTO yns_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Baar bàyöbà mbaa uboo a làpaŋ. Petɔlà kàbwaayà uboo a baar bàkäl ukɔl a ya. ");
INSERT INTO yns_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Un'syääl mwɛy wà un'kaar kun'mɛn tsütsü a ba, laa kun'syebà u kyɛɛy a mbaa, waa kàtɛn naa: « Le, mbuur wà sye kàkäl anà nde. » ");
INSERT INTO yns_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wɛɛ nde kàkyer un'tɔn, waa kàtɛn naa: « Un'kaar wà, mɛ nde un'yöb anki. » ");
INSERT INTO yns_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ungö a taaŋ ikikye, mbuur asin kàmɛn nde Petɔlà, kàtɛn a nde naa: « Ngye sye awà umwɛy uboo a baar bà! » Petɔlà naa: « Mbuur wà, mɛ mwo watɛy! » ");
INSERT INTO yns_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tsütsü ungö a taaŋ làmwɛy, mbuur asin waa ufàtɛn a ngwal yanswà: « Ndandaa, mbuur wunà kàkäl anà nde ntɔn nde wà un'nsi Ngalilɛ. » ");
INSERT INTO yns_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petɔlà kàfuur naa: « Mbuur wà, mɛ in'yöb anki naa ngye nkye akwen mutɛn. » Taaŋ nsil alan, nde kàkäl anki aŋàtàmay mutɛn, nkɔɔ waa kàbel. ");
INSERT INTO yns_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mwol kàbulà nde, waa kàler Petɔlà. Apan Petɔlà kàyɔbà ndaa kun'kyään Mwol: « Kusà nkɔɔ mutàbel ŋàbawà, ngye ayan'tɔn mbalà tär! » ");
INSERT INTO yns_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Apan laa kàtoo nde, waa kàlel ubwaŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Baar bàkäl muler Yɛsu bàkyer akun'sɛɛ anà kun'dübà. ");
INSERT INTO yns_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ba bun'bäämà ipfɛy u mii, waa bun'fuulà naa: « Le! Tà ngɔɔm! Ikyään nà kàmadwa! » ");
INSERT INTO yns_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Laa bun'töö ba in'tswe asin myà ifà ifà. ");
INSERT INTO yns_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mpal làsɛnà taaŋ, nkööŋ a andweer a un'sɛŋ, amfum a angaŋ anà alɔɔŋ a in'kɔɔn bàkyer aköŋ, waa bun'syɛn u làbay a nsaŋ a kölàköl, ");
INSERT INTO yns_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","waa bàtɛn naa: « Isàkal naa ngye, ngye awà Klistɔ, ikyään. » Yɛsu kàtɛn a ba naa: « Mɛ in'sàlakyään, bɛ làyàkyey anki, ");
INSERT INTO yns_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","mɛ in'sàlafuul, bɛ làyan'fuur anki. ");
INSERT INTO yns_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wɛɛ, sɛmà apanà, Mwan a mbuur ayàkal wàŋàbwaay u kɔɔ a ibaal a ngwal a Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Apan ba banswà bàtɛn naa: « Iswaŋà naa ngye awà Mwan a Nzam! » Yɛsu kàtɛn naa: « Bɛ ŋakwo lan'tɛn naa mɛ in'wà nde. » ");
INSERT INTO yns_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Apan, ba bàtɛn naa: « Bi mfun a imbäl ifàkal anki. Bi ŋakwo kan'wem u mun ande. » ");
INSERT INTO yns_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yàmɛnà naa un'kàbɔ a baar wanswà kàkyer ambarà, waa kàsyen Yɛsu kusà a Pilatu. ");
INSERT INTO yns_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Akun, ba bàsɛmà mukun'füün abà: « Bi kan'man mbuur wà wàmutwaal lingyoomà uboo a un'sɛŋ abi: Nde akatsuŋà baar mufur itɛr akà Sɛzar, nde kan'tɛn sye naa nde wà Klistɔ, mfum! » ");
INSERT INTO yns_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Apan Pilatu kun'fuul naa: « Nkye ngye awà mfum a Ayudà? » Yɛsu waa kun'fuur naa: « Ngye ŋakwo an'tɛn. » ");
INSERT INTO yns_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatu kàtɛn a amfum a angaŋ anà un'kàbɔ a baar naa: « Mɛ in'manà anki undiir kan'kwo mɛ mupà mbuur wà ikwàndwà. » ");
INSERT INTO yns_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wɛɛ ba bàsi unkiiŋ mutɛn naa: « Nde ayimbaar baar mukyer ube unsà an'lɔɔŋ ande u Yuday lanswà sɛmà u Ngalilɛ tii apà. » ");
INSERT INTO yns_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mpal kàwem Pilatu ndaa ayi, nde kafuul naa nkye mbuur awà wà un'nsi Ngalilɛ. ");
INSERT INTO yns_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Umpal kàyöb nde naa nde wà mbuur a ikal ufàyaal Ɛlɔdi, nde kun'töm akà Ɛlɔdi. Taaŋ nsil alan Ɛlɔdi kàkäl u Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ɛlɔdi kàkäl unsà un'sak mbɔɔn muman Yɛsu, ntɔn sɛmà itaan nde kàkwen mukun'man, ntɔn yinà kàweemà nde, nde kàleŋà naa nde utàman akà impà mwɛy. ");
INSERT INTO yns_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nde kun'si mfuul mbɔɔn, wɛɛ Yɛsu kàsàfuur anki akà ikikye. ");
INSERT INTO yns_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Taaŋ nsil alan, amfum a angaŋ anà alɔɔŋ a in'kɔɔn bàmbärà paa, bàmukun'füünà a nkyɛl. ");
INSERT INTO yns_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Apan, Ɛlɔdi anà aŋità ande bun'mɛn asànaa undiir a bunàbun, waa bun'sɛɛ, bun'bwää inkur aŋàbwaŋ. Ɛlɔdi kun'fuur akà Pilatu. ");
INSERT INTO yns_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ɛlɔdi anà Pilatu bàkäl ayiiŋ, wɛɛ sɛmà ilä akin ba bàbulà asam. ");
INSERT INTO yns_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Abun, Pilatu kàbel amfum a angaŋ, abyääl anà un'sɛŋ, ");
INSERT INTO yns_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","waa kàtɛn a ba naa: « Bɛ lan'twääl mbuur wà naa nde wàmubuul an'kyän a un'sɛŋ. Wɛ mɛ, mɛ amun'fuul u mii abɛ, mɛ in'sàman anki undiir kan'kyer nde uboo a indiir byanswà lun'füünà bɛ. ");
INSERT INTO yns_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ɛlɔdi sye usàman anki ube ande, lalan kàman'fuur nde awà. Abun, mbuur wà undiir ukyer nde watɛy awà ban'kwo mukun'dwa. ");
INSERT INTO yns_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mɛ in'swaŋ baar amɛ bun'käm an'füm, waa mɛ un'wɛy. » ");
INSERT INTO yns_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kà un'kyɔm a Pak wanswà Pilatu kàkäl anà nkääl mukatsuuŋ mbuur a bɔlokà mwɛy. ");
INSERT INTO yns_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wɛɛ un'sɛŋ wanswà kàsɛmà musà in'kwɛŋ: « Idwääl mbuur wà! Un'tsuuŋ Barabas! » ");
INSERT INTO yns_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas awà bun'si ba u bɔlokà ntɔn lingyoomà làbü uboo a bul anà nde sye kàdwä mbuur. ");
INSERT INTO yns_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Wɛ Pilatu kàkwen muwɛy Yɛsu, waa kàfàtɛn mbalà asin a ba, ");
INSERT INTO yns_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","wɛɛ ba bàkuub in'kwɛŋ, waa bàtɛn naa: « Un'bɛɛrà u kulunsi! Un'bɛɛrà u kulunsi! » ");
INSERT INTO yns_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wɛɛ nde kàfafuul mbalà yàtär: « Ube nà nde kan'kyer? Mɛ in'sàman anki akà ube mwɛy ntɔn nde ukwe mukwà. Abun, mɛ in'pà mbwo naa bun'pɛ an'füm waa mɛ un'wɛy. » ");
INSERT INTO yns_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wɛɛ ba bàsi unkiiŋ u ndaa a ngwal naa bun'bɛɛrà u kulunsi. In'kwɛŋ aba myàwɛl iböŋ. ");
INSERT INTO yns_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Lalan Pilatu kàyer akyey nde ndɔ̈ɔ̈m aba. ");
INSERT INTO yns_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nde kàtsuuŋ mbuur kàbilà bɔlokà ntɔn lingyoomà anà nkweel a mbuur mwɛy, waa kapɛ Yɛsu ntɔn ba bun'kyer undiir bàkweenà ba. ");
INSERT INTO yns_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wɛɛ mpal bàkäl ba mukun'syen, ba bàbweey anà mbuur mwɛy kàkäl u mbwo kàfü nde itsuŋ a ndwà, ikɔb ande Simɔn un'nsi Sirɛn, ba bun'siinà a ngwal mubay Yɛsu musyen kulunsi ungö. ");
INSERT INTO yns_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Un'kàbɔ a baar kàkäl muyilab. Akaar sye bàkäl mbɔɔn muyilel anà muman ntaan ntɔn nde. ");
INSERT INTO yns_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yɛsu kàbulà ntsü akà ba, waa kàtɛn a ba naa: « Akaar a Yɛlusàlɛm, twon lan'lel ntɔn mɛ! Làlel ntɔn bɛ ŋakwo anà baan abɛ, ");
INSERT INTO yns_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ntɔn le, làyöb naa ilä iyàyà bàyàtɛn naa: \"Un'sak akà akaar ikɔb anà akaar mpa bàbör anà mpa bànüü baan.\" ");
INSERT INTO yns_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Apan baar bàsàbulà mutɛn a myɔŋ a bwɛlàbwɛl naa: \"Làbü udu a bi!\" A myɔŋ a ikökö: \"Lifwee!\" ");
INSERT INTO yns_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ntɔn isàkal naa un'te a un'bu bàmukyer abà, ya isàkal aben ntɔn un'te aŋàyɔm? » ");
INSERT INTO yns_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yàmɛnà sye naa ba bàsyen, mbwo mwɛy anà Yɛsu, baar bɔ̈ɔ̈l bàfakyerà baar ube, ntɔn bàkadwa sye. ");
INSERT INTO yns_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mpal bàtöl ba kà ikal mwɛy ikɔb akya « Bɔl a un'tswe », ba bàbɛɛrà Yɛsu u kulunsi anà baar bööl abà, umwɛy u kɔɔ ande là ibaal, wumwɛy u kɔɔ ande là ikaar. ");
INSERT INTO yns_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Waa Yɛsu kàtɛn naa: « Taa, adwääl nkul, ntɔn ba bàyöb anki ndaa bàkyerà ba. » Ba bàkäb ipfɛy ande mutà löb. ");
INSERT INTO yns_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Un'sɛŋ kàkäl paa muleerà. Wɛɛ abyääl bàkäl musɛɛ nde, waa bàtɛɛnà naa: « Nde kàtsü baar asin mɔ̈ɔ̈, wɛy nde utsü mɔ̈ɔ̈ nde ŋakwo isàkal naa nde wà Klistɔ, mbuur kàsɔ̈ɔ̈l Nzam. » ");
INSERT INTO yns_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aŋità sye bàkäl mukun'sɛɛ. Ba bàsin tsütsü apà nde, waa bun'pɛɛ man a nkyään, ");
INSERT INTO yns_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","waa bàtɛɛnà naa: « Isàkal naa ngye awà mfum a Ayudà, tswà mɔ̈ɔ̈ ngye ŋakwo. » ");
INSERT INTO yns_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Udu a nde yàkäl anà ndaa aŋàsɔn abà: « Mbuur wà, wà mfum a Ayudà. » ");
INSERT INTO yns_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Umwɛy uboo a baar abe bàkäl u kulunsi waa kun'töö, waa kàtɛn a nde naa: « Nkye ngye kà Klistɔ anki? Tswà mɔ̈ɔ̈ ngye ŋakwo anà bi mwo sye. » ");
INSERT INTO yns_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wɛɛ wumwɛy waa kun'pɛl, kàtɛn a nde naa: « Ngye Nzam bɔɔmà un'tiin anki, ngye mbuur an'wal ntaaŋàmbar nsil ya? ");
INSERT INTO yns_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Akà bi, bi ube abi kan'fur, wɛ nde undiir ube ukyer nde watɛy. » ");
INSERT INTO yns_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Waa kàkwɛy naa: « Yɛsu, ngyɔbà mpal asàyà ngye kà imwol angye. » ");
INSERT INTO yns_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yɛsu waa kun'fuur naa: « Mɛ ndandaa akyään, ŋabawà ngye akal u du anà mɛ. » ");
INSERT INTO yns_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sɛmà tsütsü a taaŋ a midi tii taaŋ làtär ungö a midi làpib làkyer abwà u nsi yanswà. ");
INSERT INTO yns_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Taaŋ làkäl lan'minà, rido a kölàköl làkäl uboo a ndwà a Nzam làkyer akaamà u boboo. ");
INSERT INTO yns_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Apan Yɛsu kàsi in'kwɛŋ waa kàtɛn naa: « Taa, mɛ mɔ̈ɔ̈ amɛ an'fuur akà ngye. » Ungö mutɛn ndaa ayi, laa kàkü nde. ");
INSERT INTO yns_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Muman ndaa yàlyaaŋ yi, kaptɛn a Lɔmà kàsi Nzam làkoo anà kàtɛn naa: « Ndandaa mbuur wà kàkäl mbuur a balàbal. » ");
INSERT INTO yns_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ungö apan, in'kàbɔ a baar myanswà myàyi muyàler ibaŋ a ndaa aki, bàfurà bàmuyibɛɛrà kà itɔl. ");
INSERT INTO yns_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Asam a Yɛsu banswà anà akaar bàyilabà nde sɛmà Ngalilɛ, bàmbärà ukwɛl mulerà ndaa yàlyaaŋà. ");
INSERT INTO yns_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Yàmɛnà naa kàkäl anà mbuur mwɛy ikɔb ande Yɔsɛfi, nde kàkäl mbuur a làbay a nsaŋ a kölàköl, mbuur aŋàbwaŋ anà wàbalàbal. ");
INSERT INTO yns_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nde kàkäl anki un'sak anà atɔŋ ande baar a Làbay a Nsaŋ a kölàköl ntɔn ayà bàtsül ba anà bàkyer ba. Nde kàkäl mbuur a bul a Yuday ikɔb la Arimatay, waa kàdilà ngyeel a Imwol a Nzam. ");
INSERT INTO yns_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nde kàkàlɔm ndür a Yɛsu akà Pilatu. ");
INSERT INTO yns_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ungö mutɔl ya u kulunsi, nde kàläl ya uboo a làpye a ntal, waa kàsi ya kà an'dii akün bàfuun uboo a nkɔŋ anà mpa aŋàtàsà mbuur. ");
INSERT INTO yns_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kya kyàkäl ilä muyöŋà ntɔn saba làkäl tsütsü musɛmà. ");
INSERT INTO yns_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Akaar bàläbà Yɛsu sɛmà Ngalilɛ bàläb Yɔsɛfi. Ba bàleerà an'dii anà muyöb naa ba ndür a Yɛsu bàtɔl aben. ");
INSERT INTO yns_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ungö, bàfurà ba ndwà aba, ba bàyilà may a usɔŋ anà an'nanàsi. Apan waa bàkyɛɛl saba asànaa Un'kɔɔn utɛɛnà wa. ");
INSERT INTO yns_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ilä a làmiŋ ututu tutu, akaar bàkyen kà an'dii, bàsyen may a usɔŋ bàläm ba. ");
INSERT INTO yns_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba bàmɛn naa nkɔŋ yàkäl u mun a an'dii bàkyàbuum ukɔl. ");
INSERT INTO yns_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Waa bàbilà, wɛɛ ba bàmɛn anki ndür a Mwol Yɛsu. ");
INSERT INTO yns_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kyekà mpal bàkäl ba mubem ndaa ayi, wɛɛ le, baar bɔ̈ɔ̈l bàŋàbwaar ipfɛy a in'ŋyäŋ bàyàmɛnà tsütsü apà ba. ");
INSERT INTO yns_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bɔɔmà lawɛl la, laa bàtsüüm ba u mɛɛn, waa bàtɛn a ba naa: « Ntɔn nkye làleŋà bɛ mbuur a mɔ̈ɔ̈ uboo a akü? ");
INSERT INTO yns_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nde papà watɛy, nde akyàwiyà. Làyɔbà ndaa kàlakyään nde mpal kàkäl nde u Ngalilɛ ");
INSERT INTO yns_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","anà kàtɛn nde naa: \"Yubwaŋ naa Mwan a mbuur bun'yälà akà baar abe, bun'bɛɛrà u kulunsi, waa nde uwiyà kà ilä kyàtär.\" » ");
INSERT INTO yns_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Apan ba bàyɔbà ndaa a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ba bàlwomà kà an'dii, waa bàkàkyään ndaa ayi yanswà akà Bàkwem Aŋimwɛy anà akà alɔŋki bumwɛy banswà. ");
INSERT INTO yns_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Akaar aban bàkäl Màlye a Magàdalà, Zwan anà Màlye ngwän a Zyak. Akaar bumwɛy bàkäl anà ba bàkàkyään ndaa nsil ayi akà antööm. ");
INSERT INTO yns_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wɛɛ ba làkwikilà bàsi anki ntɔn ya yàkäl asànaa ndwɛy a mwäänà. ");
INSERT INTO yns_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Itàkal abwɛy, Petɔlà waa kàmbarà, kàpaarà ntiin mukyà an'dii, laa kànyee nde, kàmɛn nde in'siŋ a ipfɛy mpɛl, waa kàfurà ndwà ande wàmuyibem ndaa yàlyaaŋ. ");
INSERT INTO yns_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yàmɛnà naa ilä nsil akin, alɔŋki bööl bàkäl mukyà bul mwɛy ikɔb a la Ԑmayüs, la làkäl isii an'taaŋ mɔ̈ɔ̈l mà dwaan a Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba bàkäl muyiyääm ndaa yanswà yàlyaaŋ. ");
INSERT INTO yns_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mpal bàkäl ba muyiyääm, Yɛsu ŋakwo kàsin tsütsü apà ba, waa uyikyà mbwo mwɛy anà ba. ");
INSERT INTO yns_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ba bàkyer un'manà, wɛɛ mii a ba myapɛɛ anki mbwo muyöb naa awà nde. ");
INSERT INTO yns_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yɛsu kàtɛn a ba naa: « Bɛ ininà làyiyääm u mbwo làyikyà bɛ? » Ba waa bàmbär, anà ngyɛb yanswà. ");
INSERT INTO yns_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Umwɛy uboo a ba ikɔb ande Klɔpas waa kun'fuul: « Ngye, ngye awà un'nsi Yɛlusàlɛm umwɛy mpɛl mpa uyöb indiir ikalyaaŋà ilä abi? » ");
INSERT INTO yns_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nde waa kafuul naa: « Ininà bà? » Ba waa bun'fuur naa: « Ndaa yàbweel Yɛsu un'nsi Nasàlɛr! Nde kàkäl ŋangɔɔm a ngwal. Nde ya kàswɛŋ unsà nsyääl ande anà ndaa ande kusà a Nzam anà kusà a un'sɛŋ wanswà. ");
INSERT INTO yns_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wɛɛ amfum a angaŋ abi anà abyääl abi bàkyer aben mukun'yälà ntɔn bun'tsüül mbar a ukwà, waa bun'bɛɛrà u kulunsi. ");
INSERT INTO yns_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wɛɛ bi, bi kàsi làkyän naa nde mbuur ayàkɔɔr Isàlɛl. Udu a ayi yanswà, wɛɛ le, ŋàbawà ilä kyàtär sɛmà yan'lyaaŋ ndaa ayi yanswà. ");
INSERT INTO yns_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Yà ndandaa naa akaar amwɛy uboo a un'tüüb abi bàyikyään ndaa a ubem: ba bàkyen ututu tutu kà an'dii, ");
INSERT INTO yns_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wɛɛ ba bàmɛn anki ndür ande. Waa ba bàyikyään sye naa akyeey a du bàyàmɛnà akà ba ntɔn mukakyään naa nde we anà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bumwɛy uboo abi waa bàkyen kà an'dii, ba bàmɛn asànaa bàtɛn akaar, wɛɛ ba nde bun'mɛn anki. » ");
INSERT INTO yns_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Apan Yɛsu waa kàtɛn a ba naa: « Ɔɔ bɛ baar làkɔ̈ɔ̈n un'yɛnà, u mpem mpa ifàyöb agyägyä ndaa yanswà bàtɛn aŋangɔɔm! ");
INSERT INTO yns_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Yàlɔ̈m anki naa Klistɔ umɛn mpay ayi yanswà, waa ubilà u làkoo ande? » ");
INSERT INTO yns_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ungö, nde kakyään indiir byanswà bàsön ntɔn nde sɛmà Mɔsɛ tii aŋangɔɔm banswà. ");
INSERT INTO yns_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mpal nsil ayin, ba bàtöl tsütsü a bul bàkäl ba mukyà. Yàmɛnà asànaa Yɛsu alab mbwo ande. ");
INSERT INTO yns_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wɛɛ ba bun'si muküünà, waa bàtɛn naa: « Kal anà bi, ngye akimanà naa taaŋ làmuminà, mpib yàmubwà. » Nde kàbilà u ndwà ntɔn mukal anà ba. ");
INSERT INTO yns_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nde kàbwaay u mɛsà anà ba, waa kàwɛl mampà, ungö mufuur antɔɔn, nde kàtsül ma, waa kapɛ. ");
INSERT INTO yns_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Apan, mii aba waa myàdubà, bun'yöb ba, wɛɛ taaŋ nsil alan, laa kàyaalà nde kusà aba. ");
INSERT INTO yns_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ba waa bàsàbulà mutɛn un'tɔŋ a un'tɔŋ naa: « Mpem abi yàböl anki mpal uyitɛɛn nde u mbwo anà uyibuul nde Ndaa Aŋàsɔn? » ");
INSERT INTO yns_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Taaŋ nsil alan waa bàmbarà, waa bàfurà Yɛlusàlɛm. Akun ba bàmɛn Bàkwem Aŋimwɛy ban'köŋ anà baar bàkäl anà ba. ");
INSERT INTO yns_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ba banswà bawɛl ubwaŋ. Apan ba bàtɛn a ba naa: « Ndandaa Mwol akyàwiyà, nde amɛnà akà Simɔn. » ");
INSERT INTO yns_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Apan alɔŋki bɔ̈ɔ̈l abà bakyään indiir byanswà byàlyaaŋ u mbwo anà ba Yɛsu bun'yöb aben mpal kàtsül nde mampà. ");
INSERT INTO yns_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mpal bàkäl ba muyäämà abà, Yɛsu ŋakwo kàyàmɛnà uboo a ba, waa kàtɛn naa: « Duu làkäl anà bɛ. » ");
INSERT INTO yns_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wɛɛ ba bàkäl unsà ubem anà u bɔɔmà ntɔn ba bàsii naa ba ban'man buulà. ");
INSERT INTO yns_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nde waa kàtɛn a ba naa: « Ntɔn nkye lan'bulà bɛ udu udu? Ntɔn nkye nkyɛɛr yan'bilà ya u mpem abɛ? ");
INSERT INTO yns_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Làler an'kɔɔ amɛ anà in'kɔl amɛ: awà mɛ. Lan'tɛ mpi anà làler! Ntɔn buulà ufàkal anki anà in'twaŋ anà in'kwo. Wɛɛ bɛ làkimanà naa mɛ in'we anà mya. » ");
INSERT INTO yns_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mpal kàtɛɛnà nde abwɛy, nde kàkälà muswaŋ an'kɔɔ ande anà in'kɔl ande. ");
INSERT INTO yns_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Abun, unsà un'sak, ba bàkwe anki musà làkwikilà, ba bàkäl mubem. Apan nde waa kafuul naa: « Nkye bɛ làwe anà undiir adyà apà? » ");
INSERT INTO yns_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ba bun'pɛ itsu a nsö aŋàyaŋ. ");
INSERT INTO yns_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nde kàwɛl kya, waa kàdi kya u mii aba. ");
INSERT INTO yns_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ungö, nde kàtɛn a ba naa: « Bɛ lan'man ndaa kàtɛn mɛ a bɛ mpal kàkäl mɛ anà bɛ: \"Yubwaŋ naa ndaa yanswà bàsön ntɔn mɛ uboo a Un'kɔɔn a Mɔsɛ, Aŋangɔɔm anà An'diim yan'mɛnà u mii.\" » ");
INSERT INTO yns_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Apan nde kaduub un'yɛnà ntɔn ba bàyöb Ndaa Aŋàsɔn. ");
INSERT INTO yns_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wɛɛ nde kàtɛn a ba naa: « Bàsön naa: \"Klistɔ ayàman ntaan, nde akyer ayàwiyà kà ilä kyàtär, ");
INSERT INTO yns_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","waa bàyàlɔŋ kà ikɔb ande akà baar a in'sɛŋ myanswà, sɛmà Yɛlusàlɛm, naa ba bàkyer asɔɔmà, waa bàwal ndwääl a nkul a man'be aba. ");
INSERT INTO yns_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Bɛ làbà ambäl a indiir abi byanswà. ");
INSERT INTO yns_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Waa mɛ, mɛ in'yàlatööm undiir kàlapɛ Taa ilää. Wɛɛ akà bɛ, làkäl apà uboo a bul a kölàköl tii mpal làsàyɔl bɛ anà ngwal isàfà du. » ");
INSERT INTO yns_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ungö, nde kasyen u nsà a bul a tsütsü a Bɛtani, nde kàsɛn an'kɔɔ ande, waa kasaak. ");
INSERT INTO yns_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mpal kàkäl nde mukasaak, nde kàkaabà anà ba, waa bun'syen u du. ");
INSERT INTO yns_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wɛɛ akà ba, ungö mukun'sà làkoo, ba bàfurà Yɛlusàlɛm unsà un'sak mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wɛɛ ba bàkälà taaŋ lanswà u ndwà a Nzam musyaŋà Nzam.");
INSERT INTO yns_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","U nsɛmà kàkäl Ndaa, Ndaa kàkäl anà Nzam, Ndaa kàkäl Nzam. ");
INSERT INTO yns_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nde kàkäl u nsɛmà anà Nzam. ");
INSERT INTO yns_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Indiir byanswà bàkyer u mbwo a nde, kà we anà undiir anki bàkɔ̈ɔ̈n akyer u mbwo a nde. ");
INSERT INTO yns_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mɔ̈ɔ̈ kàkäl amu nde, mɔ̈ɔ̈ wa kàkäl pɛɛlà a baar. ");
INSERT INTO yns_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pɛɛlà wàmunyɛŋ uboo a mpib, wɛɛ mpib bun'yöb anki. ");
INSERT INTO yns_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kàkäl anà mbuur mwɛy, ntööm a Nzam, ikɔb ande Ywan. ");
INSERT INTO yns_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nde kàyi asànaa mbäl, ntɔn mutɛɛl pɛɛlà imbäl, ntɔn baar banswà bàsi làkwikilà u mbwo a nde. ");
INSERT INTO yns_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nde kàkäl anki pɛɛlà, wɛɛ nde kàkäl ntɔn mutɛɛl pɛɛlà imbäl. ");
INSERT INTO yns_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ndaa kàkäl pɛɛlà a ndandaa. Kàyi nde u mɛɛn, nde àfàpà kyɛɛy akà mbuur wanswà. ");
INSERT INTO yns_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nde kàkäl u mɛɛn, mɛɛn màyàmɛnà u mbwo ande, wɛɛ mɛɛn mun'yöb anki. ");
INSERT INTO yns_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nde kàyi ntsü akà bànde ŋakwo, wɛɛ ba bun'wɛl anki. ");
INSERT INTO yns_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wɛɛ akà baar bun'wɛl, akà baar bàfàsà làkwikilà kà ikɔb ande, nde kapɛ ikɔ̈b mubulà baan a Nzam. ");
INSERT INTO yns_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Baar abanà babör anki unsà an'kil, itàkal unsà ukwen a ndür, itàkal unsà ukwen a mbuur, wɛɛ unsà ukwen a Nzam. ");
INSERT INTO yns_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ndaa kàbwäär ndür, nde kàkäl uboo a bi, wàŋàyɔl a kab a ngway anà ndandaa. Bi kàkyàman làkoo ande, làkoo a Mwan baal mwɛy mpɛl kàfü akà Taa. ");
INSERT INTO yns_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ywan amun'tɛɛl imbäl, waa kan'kyään naa: « Le mbuur akwà kàtɛn mɛ naa: \"Mbuur awayà ungö a mɛ kàfweel kusà a mɛ, ntɔn nde kàkäl kusà a mɛ.\" » ");
INSERT INTO yns_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Abun, unsà ukwà ande, bi banswà kàwɛl kab a ngway udu a kab a ngway. ");
INSERT INTO yns_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Isàkal naa un'kɔɔn bàpɛ u mbwo a Mɔsɛ, kab a ngway anà ndandaa byàyi u mbwo a Yɛsu Klistɔ. ");
INSERT INTO yns_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Akà mbuur mwɛy kàmɛn anki Nzam akà ikikye, Mwan baal mwɛy mpɛl awà Nzam, awà uboo a Taa kà imɛɛy awà. ");
INSERT INTO yns_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Le imbäl kàtɛ Ywan mpal amfum a Ayudà a Yɛlusàlɛm bun'tööm ba angaŋ anà alɛwi ntɔn mukun'fuul naa: « Ngye, ngye awà nà? » ");
INSERT INTO yns_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nde kàkyer kyey mufuur, waa kàtɛn naa: « Mɛ, mɛ kà in'wà Klistɔ anki. » ");
INSERT INTO yns_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Waa ba bun'fuul naa: « Waa ngye awà nà bà? Nkye ngye awà Ɛli? » Nde kàfuur naa: « Aay, mɛ kà in'wà nde anki. » - « Nkye ngye awà Ŋangɔɔm? » Nde kàfuur naa: « Aay. » ");
INSERT INTO yns_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Abun, ba bàtɛn a nde naa: « Ngye awà nà bà? Ntɔn bi ikàpà mfuur akà baar bitöm. Ngye atɛn aben ntɔn ngye ŋakwo? » ");
INSERT INTO yns_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nde kàtɛn naa: « Mɛ, mɛ in'wà \"ndaa a mbuur ifàsà in'kwɛŋ u nsye a ipɔl: Làlɔ̈ɔ̈n alää mbwo a Mwol!\" » asànaa kàtɛn ŋangɔɔm Yɛsay. ");
INSERT INTO yns_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kyekà baar abà bàtöm bàkäl Amfarisi. ");
INSERT INTO yns_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ba bàläb mufun'fuul, waa bàtɛn naa: « Isàkal naa ngye kà Klistɔ anki, itàkal Ɛli, itàkal Ŋangɔɔm, ntɔn nkye akadümà ngye? » ");
INSERT INTO yns_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ywan kàfuur naa: « Mɛ, mɛ in'kadümà kà an'dà. Uboo a bɛ we anà mbuur mwɛy mpa làyöb bɛ, ");
INSERT INTO yns_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","nde wàmuyà ungö a mɛ. Mɛ in'kwe anki musɔɔl in'siŋ a idyäär ande. » ");
INSERT INTO yns_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Indiir abi byanswà byàlyaaŋà u Bɛtani, u sim a Yɔrdan, mper kàfadümà Ywan. ");
INSERT INTO yns_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Taaŋtyà, nde kan'man Yɛsu wàmuyà ntsü akà nde, waa kàtɛn naa: « Le Mwan a un'kɔk a Nzam awalwom man'be a mɛɛn. ");
INSERT INTO yns_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Awà mbuur akwà kàtɛn mɛ naa: \"Ungö a mɛ, we anà mbuur ayà, nde kàfweel itaan, ntɔn nde kàkyàtàkal.\" ");
INSERT INTO yns_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mɛ ŋakwo sye kun'yöbà anki. Wɛɛ ntɔn nde muyàmɛnà akà un'sɛŋ a Isàlɛl, waa mɛ kàyi mudümà kà an'dà. » ");
INSERT INTO yns_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ywan kàtɛ imbäl ande naa: « Mɛ, mɛ kàmɛn Dweelà kan'fà du, kan'yàtyà asànaa yem, waa kàn'yàbwaay udu a nde. ");
INSERT INTO yns_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mɛ, mɛ kun'yöbà anki, wɛɛ mbuur akwà kan'töm mudümà kà an'dà, kan'kyään naa: \"Mbuur ayàman ngye naa Dweelà kan'yàtyà anà kan'yàbwaay udu a nde, nde awun ayàdümà u Dweelà In'kyɛɛl.\" ");
INSERT INTO yns_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mɛ, mɛ kàkyàman anà kàkyàtà imbäl naa nde, nde wà Mwan a Nzam. » ");
INSERT INTO yns_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Taaŋtyà, Ywan kàfàkal ikal nsil kya anà alɔŋki abɔ̈ɔ̈l uboo alɔŋki ande. ");
INSERT INTO yns_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mpal kàsyebà nde Yɛsu wàmulyaaŋ, nde kàtɛn naa: « Le Mwan a un'kɔk a Nzam! » ");
INSERT INTO yns_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Alɔŋki abà bàbɔ̈ɔ̈l bàwem ndaa kàtɛn Ywan, ba bàläb Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yɛsu kàbulà ungö, waa kàmɛn ba bàmuyun'lab, nde kafuul naa: « Ininà bɛ làleŋà? » Ba bàfuur naa: « Rabi - iswaŋà naa Un'lɔɔŋ - ngye afàkal ken? » ");
INSERT INTO yns_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nde kàtɛn a ba naa: « Làyi, waa bɛ làkàman. » Apan sye laa bun'läb ba, bàmɛn ba ikal kàfakalà nde, waa bàkäl apà nde ilä akin, la làkäl taaŋ lànà ungö a midi. ");
INSERT INTO yns_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrɛ, un'tɔŋ a Simɔn Petɔlà, kàkäl umwɛy uboo a abɔ̈ɔ̈l bàwem Ywan anà bàläb Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kusà a nde mukàman mbuur asin, nde kàtàkàman un'tɔŋ ande ŋakwo Simɔn, waa kàtɛn a nde naa: « Bi kan'swaal Mɛsya! » Ikaswaŋà naa « Klistɔ ». – ");
INSERT INTO yns_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nde kun'syen akà Yɛsu. Yɛsu kun'ler a lää, waa kàtɛn a nde naa: « Ngye, ngye awà Simɔn, mwan a Ywan, ngye, ngye bàyabeelà Sɛfas. » Ikɔb aki ikaswaŋà naa Petɔlà. ");
INSERT INTO yns_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","U taaŋtyà, Yɛsu kàwɛl an'kyän mukyà Ngalilɛ. Nde kàbwey a Filipo, waa kàtɛn a nde naa: « Yan'läb! » ");
INSERT INTO yns_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Kyekà Filipo kàkäl un'nsi Bɛtesayidà, bul làmwɛy anà Andrɛ anà Petɔlà. ");
INSERT INTO yns_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nde kàkàman Natanayɛl, waa kun'kyään naa: « Bi, bi ban'swaal mbuur akwà bàsön unsà Un'kɔɔn a Mɔsɛ anà unsà aŋangɔɔm. Mbuur wa Yɛsu, mwan a Yɔsɛfi, un'nsi Nasàlɛr. » ");
INSERT INTO yns_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayɛl waa kàtɛn a nde naa: « Nkye undiir aŋàbwaŋ sye kan'kwo utoo u Nasàlɛr? » Filipo naa: « Yà, man. » ");
INSERT INTO yns_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Umpal kàmɛn Yɛsu Natanayɛl wàmuyàsin tsütsü apà nde, nde kàtɛn ntɔn nde naa: « Le un'nsi Isàlɛl umwɛy wà ndandaa, awà akɔ̈ɔ̈n loor uboo a nde. » ");
INSERT INTO yns_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayɛl kun'fuul naa: « Ngye mɛ an'yöb aben? » Yɛsu naa: « Kusà Filipo mutabel, mɛ amɛn itaan umpal akäl ngye u ngyɛl a un'te a fige. » ");
INSERT INTO yns_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Apan Natanayɛl kàfàfuur naa: « Rabi, ngye, ngye awà Mwan a Nzam, ngye, ngye awà mfum a Isàlɛl! » ");
INSERT INTO yns_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yɛsu kun'fuur naa: « Nkye ntɔn amakyään mɛ naa: mɛ amɛn u ngyɛl a un'te a fige, waa ngye an'sà làkwikilà? Ngye, ngye ayàman indiir mbɔɔn byan'söön bi. » ");
INSERT INTO yns_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nde kàfàkwɛy naa: « Ndandaa, ndandaa mɛ alàkyään, bɛ làsàman du lan'dubà, akyeey a Nzam bàmubeenà anà bàmutyà udu a Mwan a mbuur! » ");
INSERT INTO yns_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kyekà, ilä kyàtär, kàkäl anà un'kyɔm a bɔr mwɛy u Kana, u Ngalilɛ. Ngwän a Yɛsu kàkäl kwo. ");
INSERT INTO yns_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yɛsu sye bàkyer un'bel anà alɔŋki ande kà un'kyɔm awà. ");
INSERT INTO yns_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yàmɛnà naa man màkyer awà. Ngwän a Yɛsu kàtɛn a nde naa: « Ba vin latɛy. » ");
INSERT INTO yns_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Wɛɛ Yɛsu kun'fuur naa: « Un'kaar wà, ngye anà mɛ inina? Taaŋ amɛ ŋàtàkwo anki. » ");
INSERT INTO yns_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngwän waa kàtɛn a asyääl naa: « Làkyer yinà yanswà utɛn nde a bɛ. » ");
INSERT INTO yns_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Paa màkäl anà an'buuŋ, an'buuŋ an'syaam mà nkɔŋ, amà bàfasyäälà Ayudà ntɔn mupöŋ ndür. U làbuuŋ làmwɛy man'kwo ibilà isii a an'litre an'kwem an'tär aŋitär. ");
INSERT INTO yns_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yɛsu kàswɛŋ asyääl naa: « Làyööl an'dà uboo a an'buuŋ mà. » Ba sye waa bàyööl ma tii u mɔɔl. ");
INSERT INTO yns_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yɛsu kàtɛn a ba naa: « Apanà, làtɛɛ an'dà anà làsyen ma akà mfum a un'kyɔm. » Ba waa bun'syeen ma. ");
INSERT INTO yns_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kàkyee nde, an'dà màkäl man'bulà vin. Nde kàyöb anki naa vin alà lan'fà ken. Wɛɛ asyääl bàtɛɛ an'dà bàkyer ayöb. Apan sye nde kàbel ŋabɔr, ");
INSERT INTO yns_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","waa kàtɛn a nde naa: « Baar banswà bàfàtapà vin aŋàbwaŋ. Ungö, isàkal naa baar ban'yɔr, waa bapà vin làkɔ̈ɔ̈n ntsà. Wɛɛ ngye, ngye vin a ntsà akyer asàlɔɔn tii apanà! » ");
INSERT INTO yns_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ayi nsɛmà a idiim a Yɛsu yàlyaaŋ u Kana a Ngalilɛ. Nde kàmɛɛy làkoo ande, alɔŋki ande waa bun'si làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ungö apan, Yɛsu kàtyà Kapɛrnawum anà ngwän, anà atɔŋ ande anà alɔŋki ande. Ba kwo bàkyer anki ilä mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pak a Ayudà làkäl tsütsü mukwo, Yɛsu waa kàbeenà Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nde kàmɛn ayääl a ngɔɔmà, in'kɔk, an'yem anà agyɛɛŋ a ngim sye bàkyàbwaay uboo a ndwà a Nzam. ");
INSERT INTO yns_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Abun, nde kàkyer füm a in'siŋ, waa kàböŋ ba banswà u ndwà a Nzam, anà ngɔɔmà, anà in'kɔk aba. Nde kàpay ngim a agyɛɛŋ anà kàbuum mɛsà aba. ");
INSERT INTO yns_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nde kàtɛn a ayääl a an'yem naa: « Làlwom indiir abi byanswà pà! Twon lan'buul ndwà a Taaràmɛ ndwà atà yà! » ");
INSERT INTO yns_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Alɔŋki ande bàyɔbà naa bàsön abà: « Ukwen a ndwà angye bàkyer asan'kwiiy. » ");
INSERT INTO yns_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Apan, amfum a Ayudà bun'fuul naa: « Idiim nà an'kwo ngye mukyer, ntɔn muswaŋ naa ngye awe anà ikɔ̈b mukyer abà? » ");
INSERT INTO yns_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yɛsu kafuur naa: « Làbwaab ndwà a Nzam yi, ungö a ilä itär mɛ in'yàmbaar ya. » – ");
INSERT INTO yns_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Apan, Ayudà abà bàtɛn a nde naa: « Yàlɔ̈m mbul an'kwem an'nà aŋisyaam mutɔŋ ndwà ayi, wɛɛ ngye, ngye ya ayàmbaar ungö a ilä itär? » ");
INSERT INTO yns_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wɛɛ, kyekà, ndwà a Nzam kàtɛɛnà nde yàkäl ndür ande ŋakwo. ");
INSERT INTO yns_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ungöngö, umpal kàwiyà Yɛsu uboo a akü, alɔŋki ande waa bàyɔbà naa nde kàkyàtɛn abà. Kyakin bàsi ba làkwikilà amu Ndaa Aŋàsɔn anà amu ndaa kàtɛn nde. ");
INSERT INTO yns_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Utaaŋ kàkäl Yɛsu u Yɛlusàlɛm, umpal a un'kyɔm a Pak, bàmbɔɔn bàsi làkwikilà kà ikɔb ande ntɔn idiim kàfakyerà nde. ");
INSERT INTO yns_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wɛɛ Yɛsu, nde ba làkwikilà kasyeelà anki, ntɔn nde kàkyayöb ba banswà ubwaŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nde kàkäl anki anà mfun naa bun'tɛɛl imbäl ntɔn mbuur, ntɔn nde ŋakwo kàkyer ayöbà naa ininà abyu mpem a mbuur. ");
INSERT INTO yns_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kàkäl anà mbuur mwɛy kiböl a Amfarisi ikɔb ande Nàkàdim. Nde kàkäl umwɛy uboo a amfum a Ayudà. ");
INSERT INTO yns_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nde kàyi u mpib akà Yɛsu, waa kàtɛn a nde naa: « Rabi, bi ikyàyöb naa ngye awà un'lɔɔŋ an'fà akà Nzam, ntɔn akà mbuur mwɛy ukwe anki mukyer idiim asànaa afàkyer ngye, isàkal naa uboo ande Nzam watɛy. » ");
INSERT INTO yns_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yɛsu kun'fuur naa: « Ndandaa, ndandaa, mɛ akyään: Isàkal naa mbuur bun'bör anki wàkün, nde ukwe anki muman Imwol a Nzam. » ");
INSERT INTO yns_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nàkàdim kun'fuul naa: « Nkye mbuur aŋànün kan'kwo bàfun'bɔr mbalà asin? Nkye nde kan'kwo ufàbilà mbalà yàyweel kà an'bäl a ngwän waa bàfun'bɔr? » ");
INSERT INTO yns_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yɛsu kun'fuur naa: « Ndandaa, ndandaa, mɛ akyään: akà mbuur mwɛy ukwe anki mubilà kà Imwol a Nzam, isàkal naa nde bun'bör anki kà an'dà anà u Dweelà. ");
INSERT INTO yns_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ayà ban'bɔr unsà un'sön yà un'sön, ayà ban'bɔr unsà Dweelà, yà dweelà. ");
INSERT INTO yns_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Twon an'bem isàkal naa mɛ an'tɛn a ngye naa: \"Yan'kwo naa bàfabɔr mböör a du.\" ");
INSERT INTO yns_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Un'pöb afàful mper ayà ukwen wa. Ngye awem làso awa, wɛɛ ngye ayöb anki naa wa kan'fà ken, itàkal naa wa sye akyà ken. Ayi yà ndaa ifàlyaaŋ uboo a mbuur wanswà awà ban'bɔr u Dweelà. » ");
INSERT INTO yns_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Apan Nàkàdim kun'fuul naa: « Ndaa ayi yan'kwo mukal aben? » ");
INSERT INTO yns_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yɛsu kun'fuur naa: « Ngye, ngye awà un'lɔɔŋ atoo làpan kà Isàlɛl, waa ngye indiir abi ayöb anki! ");
INSERT INTO yns_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ndandaa, ndandaa, mɛ akyään: bi ifàtɛn ya iyöb bi, bi ifàtà imbäl a yakwà kàmɛn bi. Wɛɛ bɛ, bɛ làkwen anki làkyey imbäl abi. ");
INSERT INTO yns_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Isàkal naa bɛ làkakyeyà anki mpal alàkyäänà mɛ indiir a mɛɛn, bɛ làyàkyey aben isàkal naa mɛ amàlakyään indiir a du? ");
INSERT INTO yns_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ntɔn, akà mbuur ŋàtàbeenà anki du, nà Mwan a mbuur mpɛl awà kàfü du. ");
INSERT INTO yns_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Asànaa Mɔsɛ kàmbaar nde ntäy u nsye a ipɔl, abun sye bàsàmbaar Mwan a mbuur, ");
INSERT INTO yns_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ntɔn mbuur wanswà asà làkwikilà amu nde, ukäl anà mɔ̈ɔ̈ a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Abun Nzam kàkwen mɛɛn mbɔɔn, lalan kàpɛ nde Mwan baal ande mwɛy mpɛl, ntɔn mbuur wanswà asà làkwikilà amu nde ukɔ̈ɔ̈n akyà bwà, wɛɛ nde ukäl anà mɔ̈ɔ̈ a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ntɔn Nzam kàtöm anki Mwan baal ande u mɛɛn ntɔn mudwa mbuur ndwà, wɛɛ ntɔn mɛɛn iwü mɔ̈ɔ̈ u mbwo a nde. ");
INSERT INTO yns_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mbuur afàsà nde làkwikilà bun'tsüül anki nsaŋ. Mbuur mpa afàsà làkwikilà, bàkyun'tsüül mbar itaan, ntɔn nde kàsi anki làkwikilà amu ikɔb a Mwan baal mwɛy mpɛl a Nzam. ");
INSERT INTO yns_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nsaŋ ya yi: pɛɛlà làyi u mɛɛn, wɛɛ baar bàkwen làpib kà ikal a pɛɛlà, ntɔn nsyääl aba yàkäl yàmbe. ");
INSERT INTO yns_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Abun, mbuur wanswà afàkyer ube, nde kan'tɔn pɛɛlà anà nde sye kan'kaabà anà la, manà nsyääl ambe ande iyàmɛnà u leŋ. ");
INSERT INTO yns_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mbuur wanswà afàkyer ndandaa, nde afàyà ntsü awà pɛɛlà, ntɔn nsyääl ande amu Nzam imɛnà u leŋ. » ");
INSERT INTO yns_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ungö apan, Yɛsu kàkyen Yuday anà alɔŋki ande. Nde kàbwaay kwo anà ba anà kàpɛɛ ndüümà. ");
INSERT INTO yns_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ywan sye kàpɛɛ ndümà u Ɛnɔ tsütsü a Salim, ntɔn an'dà màkäl mbɔɔn kwo. Baar bàyee akà nde, waa bàwɛlà ndüümà. ");
INSERT INTO yns_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ntɔn Ywan kàkäl anki aŋàtàbilà bɔlokà. ");
INSERT INTO yns_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kyekà, nsyeel a mbaaŋ yàkyer abwà uboo a alɔŋki a Ywan anà Un'yudà mwɛy unsà ndaa iler mpɔɔŋà a ndür. ");
INSERT INTO yns_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ba bàyàman Ywan, waa bun'fuul naa: « Rabi, mbuur akwà kàkälà anà ngye u sim a Yɔrdan lumwɛy, nde akwà kàtɛɛlà ngye imbäl, le nde sye wàmupaa ndüümà anà baar banswà bàkyeenà akà nde! » ");
INSERT INTO yns_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ywan kafuur naa: « Akà mbuur mwɛy ukwe anki muwal undiir asin udu a undiir bun'pɛ fà du. ");
INSERT INTO yns_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bɛ, bɛ ŋakwo làbà ambäl amɛ mpal kàtɛn mɛ naa: \"Mɛ, mɛ kà in'wà Klistɔ anki, wɛɛ mɛ in'wà mbuur bàtöm kusà a nde.\" ");
INSERT INTO yns_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mbuur awe anà un'kyay, nde wà un'dim. Wɛɛ akà un'sam ande afàkal ukɔl, wàmukun'wemà, ndaa a un'dim yàmukun'paa un'sak. Awà un'sak amɛ, wa wàŋàkwo. ");
INSERT INTO yns_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yubwaŋ naa nde uyɛl, wɛɛ mɛ, mɛ in'tyà. ");
INSERT INTO yns_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","« Mbuur kan'fà du, wà udu a baar banswà. Mbuur awà u mɛɛn, wà mbuur a mɛɛn, ndaa ande yà ndaa a mɛɛn. Mbuur kan'fà du wà udu a baar banswà, ");
INSERT INTO yns_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","nde afàtà imbäl a indiir kàmɛn nde anà kàwem nde, wɛɛ akà mbuur mwɛy afàkyey imbäl ande watɛy. ");
INSERT INTO yns_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mbuur afàwal imbäl ande, kan'bɛɛrà inyɛm naa Nzam wà ndandaa. ");
INSERT INTO yns_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ntɔn mbuur kàtöm Nzam afàtɛn ndaa a Nzam, ntɔn nde afun'pà Dweelà aŋàkwo. ");
INSERT INTO yns_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taa akwen Mwan, waa kàpɛ indiir byanswà kà an'kɔɔ ande. ");
INSERT INTO yns_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mbuur afàsà làkwikilà ande amu Mwan, we anà mɔ̈ɔ̈ a mbul a in'tye. Mbuur mpa afàsà làkwikilà amu Mwan usàman anki mɔ̈ɔ̈, wɛɛ nkyɛl a Nzam isàkal udu a nde. » ");
INSERT INTO yns_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mpal kàyöb Yɛsu naa Amfarisi bàwem naa nde kàfakyerà anà kàfadümà alɔŋki aŋàsöön Ywan, ");
INSERT INTO yns_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","- Kutɛn aŋàbwaŋ, Yɛsu kàfadümà anki nde ŋakwo, wɛɛ alɔŋki ande. - Mpal kàwem Yɛsu indiir bàtɛɛnà baar, ");
INSERT INTO yns_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","nde kàlwomà u Yuday, waa kàfurà Ngalilɛ. ");
INSERT INTO yns_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mukyà kwo, yàlɔ̈m naa nde atsul uboo a Samalya. ");
INSERT INTO yns_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Apan, nde kàtöl bul a Samalya mwɛy ikɔb a la Sikar, tsütsü a ywaŋ kàpɛ Yakɔb mwan ande Yɔsɛfi ");
INSERT INTO yns_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ntsü làkäl fu a an'dà a Yakɔb. Ntɔn yɔ̈ɔ̈n a mbwo, Yɛsu kàkäl wàŋàbwaay kà un'beel a fu. La làkäl isii a taaŋ a midi. ");
INSERT INTO yns_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Un'kaar un'nsi Samalya mwɛy kàyi mutɛɛ an'dà. Yɛsu kàtɛn a nde naa: « Mpɛ an'dà anwà. » ");
INSERT INTO yns_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ntɔn alɔŋki ande bàkäl aŋàkyà bul mukàsom isaa adyà. ");
INSERT INTO yns_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wɛɛ un'kaar awà, un'nsi Samalya awà, kàtɛn a nde naa: « Aben? Ngye Un'yudà, ngye awe anà yɔr mulɔm an'dà anwà, akà mɛ, un'kaar mwɛy, un'nsi Samalya mwɛy? » - Kutɛn aŋàbwaŋ, Ayudà un'tüüb watɛy anà Asamalya. - ");
INSERT INTO yns_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yɛsu kun'fuur naa: « Ilàkal naa ngye ayöb kab a Nzam anà mbuur wa kan'tɛn wà a ngye naa: \"Mpɛ an'dà\", ngye mbuur alun'lɔ̈ɔ̈m an'dà, waa nde ulapà an'dà a mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Un'kaar waa kàtɛn a nde naa: « Mwol, ngye akà kantin latɛy, fu a an'dà la sye làŋàtyà mbɔɔn. Ngye an'dà a mɔ̈ɔ̈ ma màfàken? ");
INSERT INTO yns_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nkye ngye an'söön taaràbi Yakɔb, mbuur kà ipɛ fu alà anà kànü an'dà mwo nde ŋakwo, anà baan ande anà itɔŋà ande? » ");
INSERT INTO yns_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yɛsu kun'fuur naa: « Mbuur wanswà anwà an'dà mà, afàsàwem mfwää a an'dà, ");
INSERT INTO yns_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","wɛɛ mbuur asànwà an'dà insun'pà mɛ, nde ufàsàwem anki mfwää a an'dà akà ikikye, wɛɛ an'dà insun'pà mɛ isàbulà amu nde ntwà isàfuunà ntɔn mɔ̈ɔ̈ a mbul a in'tye. » ");
INSERT INTO yns_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Apan, un'kaar kàtɛn a nde naa: « Mwol, mpɛ an'dà ma, ntɔn mɛ in'kɔ̈ɔ̈n afàsàwem mfwää a an'dà, waa mɛ mpa in'fàsàyà mutɛɛ an'dà apà. » ");
INSERT INTO yns_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yɛsu kàtɛn a nde naa: « Kyen, un'bel un'dim angye, waa ayàfurà pà. » ");
INSERT INTO yns_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Un'kaar kun'fuur naa: « Mɛ un'dim watɛy. » Yɛsu naa: « Ngye awe anà iböŋ mutɛn naa: \"Mɛ un'dim watɛy.\" ");
INSERT INTO yns_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ngye kàkäl abà adim atyeen, baal awà ngye awà apanà, kà wà un'dim angye anki. Abun, ngye an'tɛn ndandaa. » ");
INSERT INTO yns_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Apan, un'kaar kàtɛn a nde naa: « Mwol, mɛ in'manà naa ngye awà ŋangɔɔm. ");
INSERT INTO yns_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bàtaaràbi, bàfakömà udu a mɔŋ wà, wɛɛ bɛ, bɛ làtɛn naa ikal kyan'kwo mukömà kyà u Yɛlusàlɛm. » ");
INSERT INTO yns_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yɛsu waa kàtɛn a nde naa: « Un'kaar, nkyey, taaŋ làmuyà alà mpa làsàkömà bɛ Taa itàkal udu a mɔŋ awà, itàkal u Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Bɛ, Asamàlya, bɛ làfàkömà Nzam mpa làyöb bɛ. Bi, Ayudà, bi ifàkömà Nzam iyöb bi, ntɔn mɔ̈ɔ̈ afàyà u mbwo a Ayudà. ");
INSERT INTO yns_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wɛɛ taaŋ làmuyà, la sye lan'yà, mpal aŋankömà a ndandaa bàsakömà ba Taa u Dweelà anà u ndandaa, ba bà aŋankömà ufàleŋ Taa. ");
INSERT INTO yns_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nzam wà Dweelà, kyakin baar bàfun'kömà bun'kömà unsà dweelà anà unsà ndandaa. » ");
INSERT INTO yns_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Un'kaar waa kàtɛn a nde naa: « Mɛ, mɛ in'kyàyöb naa Mɛsya, iswaŋà naa Klistɔ, asàkyer ayà. Mpal usàyà nde, nde asikyään indiir byanswà. » ");
INSERT INTO yns_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yɛsu kun'fuur naa: « Mɛ, mɛ in'wà nde, mɛ mbuur in'yäämà wà anà ngye. » ");
INSERT INTO yns_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Umpal bàyàfurà alɔŋki, ba bàmɛn ndaa mwɛy yubem ntɔn nde kàkäl muyäämà anà un'kaar. Wɛɛ akà mbuur mwɛy uboo aba kàkwe anki mukun'fuul naa: « Ngye nkye akwen akà nde? » Sye naa: « Ininà ngye akayäämà anà nde? » ");
INSERT INTO yns_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Apan, un'kaar kàsàwɔm làbuuŋ ande paa, waa kàkyen bul, waa kàtɛn a baar naa: ");
INSERT INTO yns_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","« Yàlamɛn mbuur mwɛy kan'tɛn a mɛ indiir byanswà kàkyer mɛ. Nkye nde kà wà Klistɔ anki? » ");
INSERT INTO yns_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kyakin bàtoo ba u bul, bàyi ba mper akà nde. ");
INSERT INTO yns_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Apan sye, alɔŋki bun'siinà naa: « Rabi, dyà! » ");
INSERT INTO yns_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wɛɛ nde kàtɛn a ba naa: « Mɛ, mɛ in'we anà isaa adyà, isaa mpa làyöb bɛ. » ");
INSERT INTO yns_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kyakin alɔŋki bàtɛɛnà ba, ba a ba naa: « Nkye ikyàkal naa mbuur mwɛy kun'twääl isaa adyà? » ");
INSERT INTO yns_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yɛsu kàtɛn a ba naa: « Isaa adyà amɛ, byà ntɔn mukyer ukwen a mbuur kan'töm anà mukwey isal ande. ");
INSERT INTO yns_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Bɛ, nkye bɛ làfàtɛn anki bɛ ŋakwo naa: \"Yan'sal nsöŋ nà mubwo isaa.\" Wɛɛ mɛ, mɛ alàkyään naa làduub mii abɛ, anà làler an'ywaŋ: mbɛŋ yan'söŋ anà yan'kwo mubwo! ");
INSERT INTO yns_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Un'bweel kan'wal làfur ande itaan anà kan'böbà mbɛŋ ntɔn mɔ̈ɔ̈ a mbul a in'tye, ntɔn mbuur kan'kɔn anà mbuur kan'bwo, bàmɛn un'sak ba bàbɔ̈ɔ̈l. ");
INSERT INTO yns_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Abà, un'sim afàtɛn ndandaa naa: \"Umwɛy afàkɔn, umwɛy afàbwo.\" ");
INSERT INTO yns_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mɛ, mɛ kàlatöm mukàbwo mbɛŋ làkɔ̈ɔ̈n aman bɛ mpay, baar asin bàsöön mwäänà. Wɛɛ bɛ, bɛ lan'bilà unsà bweel a isal aba. » ");
INSERT INTO yns_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Asamalya mbɔɔn bàsi làkwikilà amu Yɛsu ntɔn imbäl kàtɛ un'kaar naa: « Nde kan'tɛn amɛ indiir byanswà kàkyer mɛ. » ");
INSERT INTO yns_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Undiir awun, mpal bàyàkɔlà ba tsütsü apà nde, ba bun'bɔ̈ɔ̈n mukal anà ba. Yɛsu kàbwaay paa ilä byeel. ");
INSERT INTO yns_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Abun sye, un'kàbɔ a baar kàsi làkwikilà ntɔn ndaa kàtɛɛnà nde ŋakwo. ");
INSERT INTO yns_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Waa ba bàtɛɛnà a un'kaar naa: « Bi kan'sà anki làkwikilà ntɔn ndaa kà ikyään ngye, wɛɛ ntɔn bi ŋakwo kàmuwem, waa bi kan'yöb naa ndandaa nde wà Un'tswää a mɔ̈ɔ̈ a mɛɛn. » ");
INSERT INTO yns_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ungö a ilä byeel, Yɛsu kàlwomà apan, waa kàkyen Ngalilɛ. ");
INSERT INTO yns_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nde kàkyään nde ŋakwo naa: « Ŋangɔɔm bàfun'pà anki làkoo u nsi ande ŋakwo. » ");
INSERT INTO yns_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Umpal kàtöl nde u Ngalilɛ, baar a itiir a nsi akin bun'wɛl ubwaŋ, ntɔn ba bàkyer aman indiir byanswà kàkyer nde kà un'kyɔm, ntɔn ba sye bàkyen un'kyɔm. ");
INSERT INTO yns_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Apan Yɛsu kàfurà Kana u Ngalilɛ, ntsü kàbuul nde an'dà vin. Kàkäl anà undweer a mfum a aŋità mwɛy , mwan ande wàbaal kàkäl anà ukyal u Kapɛrnawum. ");
INSERT INTO yns_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mpal kàwem nde naa Yɛsu kan'yà u Yuday a Ngalilɛ, waa kàkun'man anà kun'bɔ̈ɔ̈n naa nde utyà anà ukɔɔr mwan baal ande awà kàkäl tsütsü mukwà. ");
INSERT INTO yns_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yɛsu kàtɛn a nde naa: « Isàkal naa bɛ làmɛn anki idiim anà impà, bɛ làsà anki làkwikilà akà ikikye! » ");
INSERT INTO yns_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mfum aŋità awà kun'fuur naa: « Mwol, tyà kusà a mwan amɛ mukwà. » ");
INSERT INTO yns_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yɛsu waa kàtɛn a nde naa: « Kyen, mwan angye we anà mɔ̈ɔ̈. » Mbuur awà kàsi làkwikilà u ndaa kàtɛn Yɛsu a nde, waa kàkyen. ");
INSERT INTO yns_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Umpal kàkäl nde mutyà, baar a isal ande bàkàbwey ande, waa bun'kyään naa: « Mwan angye kan'wà mɔ̈ɔ̈! » ");
INSERT INTO yns_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Apan, nde kàfuul ba naa taaŋ nà mwan ande ukayà, ba bun'fuur naa: « Làbwɛy a mpye làlwomà ywenà, utaaŋ atàtwɛb, ungö a midi. » ");
INSERT INTO yns_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Taarànde kàyɔbà naa làkäl taaŋ nsil lalɛy alà kun'kyään Yɛsu naa: « Mwan angye we anà mɔ̈ɔ̈ ». Apan, nde anà ndwà ande yanswà bàsi làkwikilà amu Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kyaki kyà idiim a impà kyàyweel kàkyer Yɛsu u mfuurà ande u Ngalilɛ fà Yuday. ");
INSERT INTO yns_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ungö a indiir abi byanswà, kàkäl anà un'kyɔm a Ayudà, waa Yɛsu kàbeenà Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kyekà, u Yɛlusàlɛm, tsütsü a munàmbwo a In'kɔk, kyàkäl anà itɛy a an'dà bàfàbel un'sà Ɛbɛlyɔ naa Bɛtesdà. Kya kyàkäl anà myäy, myäy in'tyeen. ");
INSERT INTO yns_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ungyɛl a myäy ami un'kàbɔ abɛy bàkäl musil: ikwàmii, aŋibweel anà ikar bàkäl mudil naa an'dà inini, ");
INSERT INTO yns_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ntɔn utaaŋ làmwɛy un'kyeey a Mwol mwɛy kàfatɔlà uboo a itɛy, waa kàfanii an'dà. Un'bɛy atàtwɛb kàfatɔlà kan'dà aŋàni, kàkyer afakɔɔrà itàkal naa ukyal ande abɛy bàkaben. ");
INSERT INTO yns_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kwo kàkäl anà ikar mwɛy kàkäl anà ukyal mbul an'kwem an'tär aŋinaan. ");
INSERT INTO yns_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Utaaŋ kun'mɛn Yɛsu wàŋàbɔ̈ɔ̈n anà kàyöb nde naa nde kàbɛl itaan, nde kun'fuul naa: « Nkye ngye akyàkwen akɔɔrà? » ");
INSERT INTO yns_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ikar kun'fuur naa: « Mwol, mɛ in'we anki anà mbuur akan'tɔɔm uboo a itɛy umpal ifàsɛmà an'dà munini. Umpal in'kyà mɛ, mbuur asin kan'tɔɔmà kusà a mɛ. » ");
INSERT INTO yns_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yɛsu kàtɛn a nde naa: « Mbarà, sɛn ipɔy angye, kyen. » ");
INSERT INTO yns_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Apan sye, baal awà waa kàkɔɔrà, kàsɛn ipɔy ande, waa kàsɛmà mukyà. Kyekà, ilä akin kyàkäl ilä a saba. ");
INSERT INTO yns_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Apan, amfum a Ayudà bàfuul baal awà kàkɔɔrà naa: « Ŋàbà ilä a saba, ngye mbwo musyen ipɔy angye yatɛy. » ");
INSERT INTO yns_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wɛɛ nde kafuur naa: « Mbuur awà kan'kɔɔr, atɛn a mɛ naa: \"Wal ipɔy angye, kyen.\" » ");
INSERT INTO yns_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ba bun'fuul naa: « Nà mbuur awà atɛn a ngye naa: \"Wal ipɔy angye, kyen\"? » ");
INSERT INTO yns_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wɛɛ mbuur awà kàkɔɔrà, kàyöbà anki naa nà kun'kɔɔr, ntɔn Yɛsu kàbilà uboo a iköŋ a baar bàkäl kà ikal akin. ");
INSERT INTO yns_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ungöngö, Yɛsu kàfun'man uboo a ndwà a Nzam, waa kàtɛn a nde naa: « Le, apanà ngye awà ŋàkɔɔrà. Twon an'fàkyer man'be, ntɔn undiir aŋàsöön ube ukɔɔn afayeel. » ");
INSERT INTO yns_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Baal awà kàkàkyään amfum a Ayudà naa Yɛsu kun'kɔɔr. ");
INSERT INTO yns_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Lalan Ayudà bàmɛɛyà ba Yɛsu nkwaaŋ, ntɔn nde indiir abi kàkyerà ilä a saba. ");
INSERT INTO yns_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Wɛɛ Yɛsu kafuur naa: « Tii lalà Taa wàmusal, mɛ sye in'wàmusal. » ");
INSERT INTO yns_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ntɔn ndaa ayi, amfum a Ayudà bàyileŋà ipöl mbɔɔn mukun'dwa, kànà ntɔn kàbɛyà nde saba anki, wɛɛ ntɔn kàtɛɛnà nde naa Nzam wà Taarànde ŋakwo, abà nde mumɛnà làsii làmwɛy anà Nzam. ");
INSERT INTO yns_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Apan Yɛsu kàfàwal ndaa, waa kàtɛn a ba naa: « Ndandaa, ndandaa mɛ alàkyään, Mwan ukwe anki mukyer akà undiir mwɛy nde ŋakwo, wɛɛ nà wa akwà ufàman nde mukyer akà Taa. Ntɔn indiir byanswà ufàkyer Taa, Mwan sye afàkyer bya. ");
INSERT INTO yns_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ntɔn Taa akwen Mwan, anà nde sye afun'swaŋ indiir byanswà ufàkyer nde ŋakwo. Nde afàsun'swaŋ indiir mwɛy byàkölàköl byan'söön abi ntɔn bɛ làsàkal unsà ubem. ");
INSERT INTO yns_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ntɔn, asànaa Taa ufàwiy nde akü anà ufapà nde mɔ̈ɔ̈, abun sye Mwan afàpà mɔ̈ɔ̈ akà mbuur awukwen nde. ");
INSERT INTO yns_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Taa ufàtsüül anki mbuur nsaŋ, wɛɛ nde ikɔ̈b atsul nsaŋ kyanswà kàpɛ akà Mwan, ");
INSERT INTO yns_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ntɔn baar banswà bàsi Mwan làkoo asànaa bàfàsà ba Taa làkoo. Mbuur mpa afàsà Mwan làkoo, nde sye Taa awà kun'töm ufun'sà anki làkoo. » ");
INSERT INTO yns_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nde kàkwɛy naa: « Ndandaa, ndandaa mɛ alàkyään, mbuur wanswà afàwem ndaa amɛ anà afàsà làkwikilà amu mbuur kan'töm, nde we anà mɔ̈ɔ̈ a mbul a in'tye, nde uyà anki u nsaŋ, wɛɛ nde kàkyàtoo itaan unsà ukwà, nde kàkyàwal mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ndandaa, ndandaa mɛ alakyään, taaŋ làmuyà - la sye lan'kwo - alà bàsàwem akü ndaa a Mwan a Nzam. Baar bàsàwem ya, bàsàkal anà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ntɔn, asànaa Taa awà nde anà mɔ̈ɔ̈ amu nde ŋakwo, nde kàpɛ mbwo akà Mwan mukal anà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nde kun'pɛ ikɔ̈b mutsul nsaŋ, ntɔn nde wà Mwan a mbuur. ");
INSERT INTO yns_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Twon lan'man ndaa yubem unsà ya, ntɔn taaŋ làmuyà alà bàsàwem baar banswà abà uboo a an'dii ndaa ande. ");
INSERT INTO yns_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Baar bàkyer indiir aŋàbwaŋ bàsàwiyà ntɔn muwal mɔ̈ɔ̈, wɛɛ baar bàkyer indiir ibe, ba bàsàwiyà ntɔn nsaŋ. ");
INSERT INTO yns_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mɛ, mɛ in'kwe anki mukyer akà undiir mwɛy mɛ ŋakwo: mɛ in'fàtsul nsaŋ a ndaa in'fàwem mɛ, lalan mbar in'fàtsul mɛ yà balàbal, ntɔn mɛ in'fàleŋ anki ukwen amɛ ŋakwo, wɛɛ mɛ in'fàleŋ ukwen a mbuur kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","« Ilàkal naa mɛ kàtɛɛ imbäl ntɔn mɛ ŋakwo, kya kyàlàkal anki kyà ndandaa. ");
INSERT INTO yns_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wɛɛ mbuur asin afan'tɛɛl imbäl anà mɛ sye in'kyàyöb naa imbäl ufan'tɛɛl nde kyà ndandaa. ");
INSERT INTO yns_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bɛ, bɛ làtöm akyeey akà Ywan, nde waa kàtɛɛl ndandaa imbäl. ");
INSERT INTO yns_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Akà mɛ, mɛ mfun a imbäl a mbuur kyatɛy, wɛɛ an'tɛn mɛ abà, ntɔn bɛ làwü mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ywan kàkäl asànaa mwinà aŋàkyää wàmupà pɛɛlà: u taaŋ làmwɛy bɛ làkwen muman un'sak a pɛɛlà ande. ");
INSERT INTO yns_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Wɛɛ mɛ, mɛ in'we anà imbäl aŋàsöön kyà Ywan, ntɔn isal abyà kan'pɛ Taa mukyer, isal nsil bya in'fàkyer mɛ bi anà bya ifan'tɛɛl imbäl ntɔn muswaŋ naa Taa kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Taa awà kan'töm nde ŋakwo kàtɛ imbäl ntɔn mɛ. Wɛɛ bɛ, bɛ làwem anki akà ikikye ndaa ande, bɛ làmɛn anki akà ikikye ntabwey ande. ");
INSERT INTO yns_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ndaa ande yatɛy amu bɛ, ntɔn bɛ mbuur kun'töm làfun'sà anki làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Bɛ, bɛ làfàlab pànsi pànsi Ndaa Aŋàsɔn, ntɔn bɛ làfàsi naa bɛ làwal mɔ̈ɔ̈ a mbul a intye uboo aya: kyekà ya ŋakwo ifàtà imbäl ntɔn mɛ! ");
INSERT INTO yns_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wɛɛ bɛ, bɛ làkwen anki muyà akà mɛ ntɔn muwal mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","« Mɛ in'fàwal anki làkoo làfàfà akà baar. ");
INSERT INTO yns_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wɛɛ mɛ in'kyàyöb naa amu bɛ ukwen batɛy akà Nzam. ");
INSERT INTO yns_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mɛ, mɛ kàyi kà ikɔb a Taa, wɛɛ bɛ, bɛ làtön mukan'wal. Isàkal naa mbuur asin kan'yà kà ikɔb ande ŋakwo, bɛ làkyer asun'wal! ");
INSERT INTO yns_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Aben, nkye bɛ lan'kwo mukal anà làkwikilà, bɛ baar làkoo abɛ làfàfà akà bɛ a bɛ, anà mpa làfàleŋ làkoo làfàfà akà Nzam mpɛl? ");
INSERT INTO yns_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bɛ twon lan'si naa mɛ in'sàkyer alafüün kusà a Taa. Mbuur afüünà bɛ Mɔsɛ awà làsi bɛ làkyän abɛ. ");
INSERT INTO yns_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kyakin, yàlàkal naa bɛ làsi làkwikilà amu Mɔsɛ, bɛ làlàsà làkwikilà akà mɛ sye, ntɔn nde kàsön ntɔn mɛ. ");
INSERT INTO yns_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Wɛɛ isàkal naa bɛ làsi anki làkwikilà u ndaa kàsön nde, bɛ lan'kwo aben musà làkwikilà u ndaa amɛ? » ");
INSERT INTO yns_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ungö a indiir abi, Yɛsu kàsabà sim a ɛwà a Ngalilɛ lumwɛy, akyà bàfàbel sye naa Tibɛryade. ");
INSERT INTO yns_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Iköŋ a baar mbɔɔn kyàkäl muyun'lab, ntɔn bàmɛn ba idiim kàkyerà nde udu a abɛy. ");
INSERT INTO yns_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kyakin Yɛsu kàbeenà nde udu a mɔŋ, kàbwaay nde paa anà alɔŋki ande. ");
INSERT INTO yns_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pak, un'kyɔm a Ayudà, làkäl tsütsü mukwo. ");
INSERT INTO yns_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kyekà, kàsɛn nde mii, nde kàmɛn iköŋ a baar mbɔɔn kyan'yà akà nde, nde kàfuul Filipo naa: « Bi kan'kwo musom ken mampà ntɔn baar bà bàdi? » ");
INSERT INTO yns_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","- Kàtɛn nde abà ntɔn mubilà Filipo u mpem, ntɔn akà nde, nde kàkyer ayöbà naa nde ininà uyàkyer. - ");
INSERT INTO yns_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo kun'fuur naa: « Itàkal làfur a mbul mwɛy lun'syääl a an'ywaŋ làkwo anki musom mampà isàkal naa mbuur mbuur awal itàkal kitsu. » ");
INSERT INTO yns_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Umwɛy uboo a alɔŋki ande, ikɔb ande Andrɛ, un'tɔŋ a Simɔn Petɔlà, kàtɛn a nde naa: ");
INSERT INTO yns_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","« Mwan baal mwɛy awà apà, nde we anà mampà an'tyeen mà ɔrze anà bibaan a nsö byeel. Wɛɛ indiir abi nkye byan'kwo mukyer akà un'kàbɔ a baar? » ");
INSERT INTO yns_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yɛsu kàtɛn naa: « Laswɛŋ baar bàbwaay. » Ikal akin kyàkäl anà in'lɛŋ mbɔɔn. Baar waa bàbwaay, ba bàkäl abaal isii a nsaab tyeen. ");
INSERT INTO yns_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Apan, Yɛsu kàwɛl mampà, kàfuur an'tɔɔn, waa kàkäb akà baar bàkäl paa. Nde kàkyer abun sye ntɔn nsö: nde kapɛɛ yinà yanswà bàkweenà ba muwal. ");
INSERT INTO yns_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Umpal bàyüür ba, Yɛsu kàtɛn a alɔŋki ande naa: « Làköŋà itiir byan'sal, ntɔn akà undiir ukɔ̈ɔ̈n akyà bwà. » ");
INSERT INTO yns_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ba bàköŋà bya, waa bàyööl in'lwaŋ, in'lwaŋ kwem aŋiyweel a itiir a mampà an'tyeen mà ɔrzɛ byàsääl akà baar bàdi. ");
INSERT INTO yns_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mpal bàmɛn baar impà kàkyer nde, ba bàtɛn naa: « Ndandaa mbuur awà, wà Ŋangɔɔm awayà u mɛɛn! » ");
INSERT INTO yns_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Wɛɛ Yɛsu, abà kàyöb nde naa ba bàkyer ayun'wal a ngwal ntɔn mukun'sà mfum, nde kàfàkyà u mpey aŋàyen udu a mɔŋ. ");
INSERT INTO yns_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mpal làbü sisye, alɔŋki ande bàyàtyà kà un'kɔɔl a ɛwà, ");
INSERT INTO yns_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ba bàbilà u bwaar làmwɛy, waa bàsɛmà mubweel ɛwà ntɔn mukyà Kapɛrnawum. Làpib làkäl lan'bwà itaan, Yɛsu kàkäl anki aŋàtataan. ");
INSERT INTO yns_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Un'pöb angwal kàkäl muful, ɛwà kyàkäl munini. ");
INSERT INTO yns_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ba bàkäl ban'kyer an'kilɔmɛtre an'tyeen, itàkal an'syaam, ba bàmɛn Yɛsu wàmuyikyà udu a an'dà, wàmuyàsin tsütsü a bwaar. Apan bɔɔmà làkyer akaar. ");
INSERT INTO yns_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Wɛɛ Yɛsu kàtɛn a ba naa: « Wà mɛ, twon lan'man bɔɔmà! » ");
INSERT INTO yns_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ba bàkwen mukun'wal u bwaar, wɛɛ la làkäl lan'tol u mɛɛn kà ikal akyà bàkyen ba. ");
INSERT INTO yns_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","U taaŋtye, iköŋ a baar bàsàsal u sim lumwɛy, bàmɛn ba naa bwaar làkäl làmwɛy mpɛl paa, naa Yɛsu sye kàkyen anki mbwo mwɛy anà alɔŋki ande uboo a bwaar aba, wɛɛ ba, bàkyen ba mpɛl aŋàyen. ");
INSERT INTO yns_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Apan sye, an'bwaar asin màfü Tibɛryade, màyàkɔlà tsütsü kà ikal bàdi ba mampà, ungö kàfuur Mwol an'tɔɔn. ");
INSERT INTO yns_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wɛɛ utaaŋ kàmɛn iköŋ a baar naa itàkal Yɛsu, itàkal alɔŋki ande bàkäl anki paa, baar bàbilà kà an'bwaar, waa bàkyen Kapɛrnawum mukàleŋ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Utaaŋ bun'mɛn ba u sim a ɛwà lumwɛy, ba bàtɛn a nde naa: « Rabi, ngye apà an'yàkɔlà taaŋ nà? » ");
INSERT INTO yns_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yɛsu kafuur naa: « Ndandaa, ndandaa mɛ alàkyään, kà ntɔn impà làmɛn bɛ anki waa bɛ, bɛ làyan'leŋ, wɛɛ ntɔn làdi bɛ mampà anà làyüür bɛ. ");
INSERT INTO yns_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Twon lan'sal ntɔn isaa abyà ifàtay, wɛɛ ntɔn isaa ifàlam ntɔn mɔ̈ɔ̈ a mbul a in'tye, bya akwà usàlapà Mwan a mbuur, ntɔn nde wà mbuur kàsi Taa Nzam inyɛm ande. » ");
INSERT INTO yns_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Apan, ba bun'fuul naa: « Ininà bi kan'kwo mukyer ntɔn musal isal a Nzam? » ");
INSERT INTO yns_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yɛsu kafuur naa: « Isal udilà Nzam akà bɛ kyà musà làkwikilà amu mbuur kàtöm nde. » ");
INSERT INTO yns_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Apan ba bun'fuur naa: « Wɛɛ ngye, idiim nà ngye akyer ntɔn bi imɛn anà bi kasi làkwikilà? Ininà ngye afàsal? ");
INSERT INTO yns_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bànkaa abi bàdi mane u nsye a ipɔl, asànaa bàsön ya naa: \"Isaa kapɛ nde mudyà byà làmpà làfü du.\" » ");
INSERT INTO yns_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Apan Yɛsu kàtɛn a ba naa: « Ndandaa, ndandaa mɛ alàkyään, kà Mɔsɛ tɛy kàlapɛ làmpà a du, wɛɛ Taa amɛ afàlapà làmpà a du là ndandaa. ");
INSERT INTO yns_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ntɔn làmpà a Nzam là mbuur kan'fà du anà kan'pà mɔ̈ɔ̈ u mɛɛn. » ");
INSERT INTO yns_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Apan, ba bàtɛn a nde naa: « Mwol, ipɛ taaŋ lanswà làmpà alà. » ");
INSERT INTO yns_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yɛsu kàtɛn a ba naa: « Mɛ, mɛ in'wà làmpà a mɔ̈ɔ̈. Mbuur awayà akà mɛ usàwem anki ngyal akà ikikye, mbuur awà asà làkwikilà amu mɛ, usàwem anki mfwää akà ikikye. ");
INSERT INTO yns_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Wɛɛ, mɛ ya kàkyàtɛn a bɛ naa: bɛ làkyàman, wɛɛ bɛ làsaa anki làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Baar banswà kan'pà Taa bàsàyà akà mɛ, anà mbuur ayà akà mɛ, mɛ in'sun'piy anki, ");
INSERT INTO yns_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ntɔn kàyàtɔlà mɛ fà du, kà mukyer ukwen amɛ ŋakwo anki, wɛɛ mukyer ukwen a mbuur awà kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Le, ukwen a mbuur awà kan'töm abà: naa mbuur wanswà kan'pɛ nde ukɔ̈ɔ̈n akyà bwà, wɛɛ mɛ un'wiiy kà ilä a ntsüü. ");
INSERT INTO yns_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Abun, ukwen a Taaràmɛ abà: mbuur wanswà aman Mwan anà asà làkwikilà amu nde, ukäl anà mɔ̈ɔ̈ a mbul a in'tye, waa mɛ, mɛ in'sun'wiiy kà ilä a ntsüü. » ");
INSERT INTO yns_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sɛmà apan, Ayudà bàbulà muŋüŋün ntɔn kàtɛn nde naa: « Mɛ, mɛ in'wà làmpà làfü du. » – ");
INSERT INTO yns_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ba waa bàfatɛɛnà naa: « Nkye nde kà Yɛsu, mwan a Yɔsɛfi anki? Nkye bi taarànde anà ngwän kayöb anki? Aben nde kan'kwo mukyey uyɔl apanà naa: \"Mɛ an'yàtɔlà fà du\"? » ");
INSERT INTO yns_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Wɛɛ Yɛsu kafuur naa: « Twon lan'ŋüŋün bɛ a bɛ. ");
INSERT INTO yns_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Akà mbuur mwɛy ukwe anki muyà akà mɛ isàkal naa Taa awà kan'töm kun'naan anki, waa mɛ, mɛ insun'wiiy kà ilä a ntsüü. ");
INSERT INTO yns_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Aŋangɔɔm bàsön abà: \"Nzam asàlɔŋ ba banswà.\" Mbuur wanswà kàwem Taa anà kàkyey an'lɔɔŋ ande, ayà akà mɛ. ");
INSERT INTO yns_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ikaswaŋà naa akà umwɛy kàmɛn anki Taa akà ikikye, nà mbuur mwɛy awà kàfü akà Nzam, nde awà kàmɛn Taa. ");
INSERT INTO yns_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ndandaa, ndandaa, mɛ alàkyään: mbuur asà làkwikilà we anà mɔ̈ɔ̈ a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mɛ, mɛ in'wà làmpà a mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bànkaa abɛ bàdi manɛ u nsye a ipɔl, wɛɛ ba bàkyàkwà. ");
INSERT INTO yns_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wɛɛ làmpà làyàtɔlà fà du, là naa mbuur adyà la ukɔɔn akwà. ");
INSERT INTO yns_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mɛ, mɛ in'wà làmpà alye anà mɔ̈ɔ̈ làfü du. Isàkal naa mbuur kan'dyà unsà làmpà alà, nde asàkal anà mɔ̈ɔ̈ a mbul a in'tye. Làmpà alà in'sàpà mɛ, lun'sön a ndür amɛ an'pà mɛ ntɔn mɛɛn ikäl anà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Apan, Ayudà bàsyeelà mbaaŋ a ngwalàngwal ba a ba: « Aben mbuur wà kan'kwo mupà bi un'sön a ndür ande naa bàdi wa? » ");
INSERT INTO yns_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Abun, Yɛsu kakyään naa: « Ndandaa, ndandaa mɛ alàkyään: isàkal naa bɛ làdi anki un'sön a ndür a Mwan a mbuur anà bɛ lànü anki an'kil ande, bɛ mɔ̈ɔ̈ làsàkal awà anki. ");
INSERT INTO yns_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mbuur awadyà un'sön a ndür amɛ anà anwà an'kil amɛ, nde we anà mɔ̈ɔ̈ a mbul a in'tye, waa mɛ, mɛ insun'wiiy kà ilä a ntsüü. ");
INSERT INTO yns_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ntɔn un'sön a ndür amɛ wà isaa a ndandaa byàdyà anà an'kil amɛ mà man a ndandaa. ");
INSERT INTO yns_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mbuur awadyà un'sön a ndür amɛ anà anwà an'kil amɛ, nde wà amu mɛ anà mɛ in'wà amu nde. ");
INSERT INTO yns_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Asànaa Taa awà kan'töm awà nde anà mɔ̈ɔ̈, mɛ sye in'wà anà mɔ̈ɔ̈ u mbwo ande. Abun, mbuur asan'dyà, nde asàkal anà mɔ̈ɔ̈ u mbwo amɛ: ");
INSERT INTO yns_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Alà là làmpà làyàtɔlà fà du. La kà latɛy asànaa la akwà bàdi bànkaa abɛ. Ba, ba bàkyàkwà. Wɛɛ mbuur asàdyà làmpà là, nde asàkal anà mɔ̈ɔ̈ a mbul a in'tye. » ");
INSERT INTO yns_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Indiir abi nde kàlɔɔŋà u ndwà a nköŋ a Ayudà u Kapɛrnawum. ");
INSERT INTO yns_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ungö bàwem ba Yɛsu, bàmbɔɔn uboo a alɔŋki ande bàtɛn naa: « Ndaa ayi yà bwoor! Nà kan'kwo muwem ya? » ");
INSERT INTO yns_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Wɛɛ nde kayöb nde ŋakwo naa alɔŋki ande bàkäl mukun'twe ntɔn ndaa ayi, waa kàtɛn a ba naa: « Nkye ndaa ayi yàmàladii ukyal? ");
INSERT INTO yns_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Akya isàkal naa bɛ lan'man Mwan a mbuur wàmubɛɛnà mper kàkäl nde kusà? ");
INSERT INTO yns_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dweelà làfàpà mɔ̈ɔ̈, wɛɛ un'sön a ndür wà undiir mwɛy ndöŋ watɛy. Ndaa an'tɛn mɛ a bɛ yà dweelà anà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Wɛɛ bamwɛy uboo abɛ bàfàsà anki làkwikilà. » Abun, Yɛsu kàkyer ayöbà fà nsɛmà naa bànà mpa bàsye làkwikilà anà nà kàlun'yälà. ");
INSERT INTO yns_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nde kàkwɛy naa: « Kyakin kàlakyään mɛ naa: \"akà mbuur mwɛy ukwe tɛy muyà akà mɛ, isàkal naa ya Taa kun'pɛ anki.\" » ");
INSERT INTO yns_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Fà apan, alɔŋki ande mbɔɔn bàkyer alwomà, waa bàwɛy muyikyà anà nde. ");
INSERT INTO yns_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Apan, Yɛsu kàtɛn a Bàkwem Aŋiyweel naa: « Atöl bɛ, nkye bɛ làkwen anki mukyà? » ");
INSERT INTO yns_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simɔn Petɔlà kun'fuur naa: « Mwol, bi ikyà akà nà? Ngye awe anà ndaa a mɔ̈ɔ̈ a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Bi, bi kàkyàsà làkwikilà anà kàkyàyöb naa ngye, ngye awà Ŋun'kyɛɛl a Nzam. » ");
INSERT INTO yns_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yɛsu kafuur naa: « Nkye kà mɛ anki kàlasɔ̈ɔ̈l, bɛ Bàkwem Aŋiyweel? Kyekà umwɛy uboo abɛ wà ileŋ! » ");
INSERT INTO yns_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Abun, nde kàtɛɛnà ntɔn Yudasi, Mwan a Simɔn Isikalyɔt. Ntɔn nde wumwɛy uboo a Bàkwem Aŋiyweel awà kàlun'yälà. ");
INSERT INTO yns_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ungö apan, Yɛsu kàyilyaaŋà u Ngalilɛ. Nde kàkwen anki muyilyaaŋ u Yuday, ntɔn amfum a Ayudà bàleŋà mukun'dwa. ");
INSERT INTO yns_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kyekà, un'kyɔm a ndwà a ntɛn a Ayudà kàkäl tsütsü. ");
INSERT INTO yns_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Apan, atɔŋ a Yɛsu bàtɛn a nde naa: « Lwomà apà, kyen Yuday, ntɔn alɔŋki angye sye bàmɛn isal akyerà ngye bi. ");
INSERT INTO yns_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Akà mbuur mwɛy ufàkyer anki undiir u nku isàkal naa nde akwen umɛnà. Ntɔn akakyerà ngye indiir abi, wɛy ngye ŋakwo sye amɛnà u mii a baar. » ");
INSERT INTO yns_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Abun, atɔŋ ande ŋakwo bun'si anki làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Apan Yɛsu kàtɛn a ba naa: « Taaŋ amɛ ŋàtàkwo anki. Wɛɛ akà bɛ, taaŋ lanswà là ubwaŋ. ");
INSERT INTO yns_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mɛɛn ikwe tɛy mukàlayiiŋ, wɛɛ mɛ, nde akyer afan'yiiŋ, ntɔn mɛ in'fàtà imbäl naa isal ande byà ibe. ");
INSERT INTO yns_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kyakin, bɛ, bɛ làbeenà un'kyɔm. Akà mɛ, mɛ in'beenà tɛy un'kyɔm, ntɔn taaŋ amɛ ŋàtàkwo anki. » ");
INSERT INTO yns_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ungö mutɛn abà, nde kàsàbwaay u Ngalilɛ. ");
INSERT INTO yns_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wɛɛ mpal bàkyen atɔŋ ande un'kyɔm, apan, nde sye kàbeenà aŋàyen, kà u mii a baar anki, wɛɛ asànaa u nku. ");
INSERT INTO yns_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Umpal a un'kyɔm, amfum a Ayudà bàyun'leŋà ba, waa bàtɛɛnà naa: « Wàken nde bà? » ");
INSERT INTO yns_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Baar bàsyeelà mbaaŋ mbɔɔn ntɔn nde uboo a nköŋ. Amwɛy naa: « Nde wà mbuur aŋàbwaŋ ». Wɛɛ bumwɛy naa: « Ŋaa, nde wà muyibwiy baar ndwaŋ. » ");
INSERT INTO yns_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Itàkal abun, akà mbuur mwɛy kàtɛɛnà anki u mii a baar, ntɔn ba bàtiinà amfum a Ayudà bɔɔmà. ");
INSERT INTO yns_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Un'kyɔm kàkäl kan'tol uboboo, Yɛsu kàbeenà ndwà a Nzam, waa kàlɔɔŋà. ");
INSERT INTO yns_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Amfum a Ayudà bàmɛn ndaa yubem, waa bàtɛɛnà naa: « Aben nde uyöbà, nde mbuur mpa kàtäŋ? » ");
INSERT INTO yns_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yɛsu kafuur naa: « An'lɔɔŋ amɛ kà man'fà akà mɛ anki, wɛɛ màmbuur kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Isàkal naa mbuur akwen mukyer ukwen a Nzam, nde asàyöb naa nkye an'lɔɔŋ amà man'fà akà Nzam, lɛɛ mɛ in'wà mutɛn kà ikɔb amɛ ŋakwo. ");
INSERT INTO yns_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mbuur afàtɛn ntɔn nde ŋakwo, afàleŋ làkoo ande ŋakwo. Wɛɛ mbuur afàleŋ làkoo a mbuur kun'töm, nde wà mbuur a ndandaa, usɔɔr akà nde batɛy. ");
INSERT INTO yns_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nkye kà Mɔsɛ anki kàlapɛ Un'kɔɔn? Wɛɛ akà umwɛy uboo abɛ ufàsyääl anki wa. Ntɔn nkye làkwen bɛ mukan'dwa? » ");
INSERT INTO yns_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Iköŋ a baar kyun'fuur naa: « Ngye awe anà un'sɔŋà! Nà akwen akadwa? » ");
INSERT INTO yns_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yɛsu kafuur naa: « Mɛ, mɛ an'kyer isal imwɛy, wɛɛ bɛ banswà, bɛ lan'bem! ");
INSERT INTO yns_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ntɔn Mɔsɛ kàlaswɛŋ mukyɛy baan abaal - ya sye yàfü anki akà Mɔsɛ, wɛɛ yàfü akà bànkaa - waa bɛ làfàkyɛy baal mwɛy ilä a saba. ");
INSERT INTO yns_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Isàkal naa bɛ lan'kwo mukyɛy baal mwɛy ilä a saba ukɔɔn abɛy Un'kɔɔn a Mɔsɛ, ntɔn nkye làman'wem bɛ nkyɛl ntɔn an'kɔɔr mɛ baal aŋun'kiinà ilä a saba? ");
INSERT INTO yns_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Twon lan'tsul mbar ntɔn ubwaŋ a nsà, wɛɛ làtsül mbar a balàbal. » ");
INSERT INTO yns_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ndam a baar uboo a baar a Yɛlusàlɛm bàtɛɛnà naa: « Nkye wà kà mbuur bàyileŋ ba mudwa anki? ");
INSERT INTO yns_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Le, nde wàmutɛn u mii a baar, wɛɛ akà mbuur a un'sà nso watɛy! Nkye amfum abi ban'kyey naa ndandaa nde wà Klistɔ? ");
INSERT INTO yns_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mpal usàyà Klistɔ, akà mbuur mwɛy usàyöb anki ntsü kan'fà nde. Wɛɛ baal wà, bi ikyàyöb ntsü kan'fà nde. » ");
INSERT INTO yns_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Apan, umpal kàlɔɔŋà Yɛsu u ndwà a Nzam, nde kàsi un'kwɛŋ: « Bɛ, bɛ làkyan'yöb! Bɛ làkyàyöb ntsü an'fà mɛ! Wɛɛ mɛ, mɛ kàyi anki mɛ ŋakwo, mbuur awà kan'töm wà ndandaa. Bɛ, bɛ lun'yöb anki. ");
INSERT INTO yns_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mɛ, mɛ in'kyun'yöb, ntɔn mɛ kàfü akà nde, nde sye kan'töm. » ");
INSERT INTO yns_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Apan, ba bàleŋ mukun'kɔr, wɛɛ akà mbuur kun'bä anki, ntɔn taaŋ ande làkäl aŋàkwo anki. ");
INSERT INTO yns_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Uboo a iköŋ, baar mbɔɔn bàsi làkwikilà amu nde. Ba bàtɛɛnà naa: « Nkye mpal usàyà Klistɔ, nde asàkyer impà aŋàsöön abyà ukyerà mbuur wà? » ");
INSERT INTO yns_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","In'ŋün myàkäl uboo a iköŋ a baar ntɔn Yɛsu, myàyàböl kà an'tsü a Amfarisi. Apan, andwer a angaŋ anà Amfarisi waa bàtöm aseey ntɔn mukun'kɔr. ");
INSERT INTO yns_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yɛsu kàtɛn naa: « Mɛ, mɛ in'wà anà bɛ taaŋ ikikye, ungö mɛ in'kyà ntsü akà mbuur kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bɛ làkyer asan'leŋ, wɛɛ bɛ làsan'man tɛy, ntɔn bɛ làkwe anki muyà kà ikal in'sàkal mɛ. » ");
INSERT INTO yns_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Fà apan, amfum a Ayudà bàsɛmà mufuul ba a ba naa: « Nde apɛy ayàkyà ken ntɔn bi ifàkɔɔn un'man? Nkye nde apɛy ayàkàtaan Ayudà akwà bàpää uboo a Angɛlɛki? Nkye nde apɛy Angɛlɛki usàkàlɔŋ? ");
INSERT INTO yns_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ikaswaŋà aben ndaa utɛn nde ayɛy naa: \"Bɛ, bɛ làkyer asan'leŋ, wɛɛ bɛ làsan'man tɛy, naa sye bɛ làkwe tɛy muyà kà ikal in'sàkal mɛ\"? » ");
INSERT INTO yns_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ilä a ntsüü a un'kyɔm kyàkäl ilä mwɛy kyà kölàköl. Yɛsu kàkäl umbär wàmukyäänà naa: « Isàkal naa mbuur we anà mfwää, wɛy nde uyi akà mɛ, waa unwà. ");
INSERT INTO yns_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mbuur awe anà làkwikilà amu mɛ, \"ngyäl a an'dà a mɔ̈ɔ̈ isàtoo u mpem ande\", asànaa itɛɛnà Ndaa Aŋàsɔn. » ");
INSERT INTO yns_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kàtɛɛnà nde abunà, yà ntɔn Dweelà bàlàwal baar bàlàsà làkwikilà aba amu nde. Umpal ayin, Dweelà kàkäl aŋàtàpà anki, ntɔn Yɛsu kàkäl anki aŋàtàwal làkoo. ");
INSERT INTO yns_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Amwɛy uboo iköŋ bàwem ndaa ayi, ba bàtɛɛnà naa: « Ndandaa mbuur awà, wà Ŋangɔɔm! » ");
INSERT INTO yns_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bumwɛy bàtɛɛnà naa: « Nde wà Klistɔ! » – Wɛɛ bumwɛy bàfuur naa: « Nkye Klistɔ sye an'kwo utoo u Ngalilɛ? ");
INSERT INTO yns_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nkye Ndaa Aŋàsɔn itɛɛnà anki naa nde asàkal mbuur a ywar a David, nde asàfà Bɛtelɛm, bul kàkälà David? » ");
INSERT INTO yns_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Apan, iköŋ kyàkaabà ntɔn nde. ");
INSERT INTO yns_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Amwɛy uboo a ba bàkweenà naa bun'kör, wɛɛ akà mbuur mwɛy kàkwe anki mukun'ba. ");
INSERT INTO yns_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Aseey bàyàfurà ba akà andweer a angaŋ anà Amfarisi, ba bafuul naa: « Ntɔn nkye mpa làtwääl bɛ Yɛsu? » ");
INSERT INTO yns_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aseey bàfuur naa: « Akà mbuur mwɛy ŋàtàtɛn anki akà ikikye asànaa nde! » – ");
INSERT INTO yns_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Apan, Amfarisi bafuul naa: « Nkye anà bɛ sye, nde akyàlabwiy ndwaŋ? ");
INSERT INTO yns_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nkye we anà umwɛy uboo a amfum itàkal uboo a Amfarisi, kàsi làwikilà amu nde? ");
INSERT INTO yns_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wɛɛ baar abà, baar mpa bàyöb Un'kɔɔn akà ikikye, ba bàŋàküül! » ");
INSERT INTO yns_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Wɛɛ umwɛy uboo a Amfarisi, Nàkàdim akwà kàkàman Yɛsu itaan, kàtɛn a ba naa: ");
INSERT INTO yns_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","« Nkye Un'kɔɔn abi afàtsüül mbuur mbar ukɔɔn atun'wem anà muyöb naa nde nkye kan'kyer? » ");
INSERT INTO yns_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ba bun'fuur naa: « Nkye ngye sye awà un'nsi Ngalilɛ? Leŋ, ngye ayàman naa akà ŋangɔɔm mwɛy ufàtoo anki u Ngalilɛ akà ikikye. » ");
INSERT INTO yns_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ungö apan, mbuur mbuur kàfurà ndwà ande. ");
INSERT INTO yns_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yɛsu kàkyen mɔŋ a In'te a olive. ");
INSERT INTO yns_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ututu tutu, nde kàyàfurà u ndwà a Nzam. Un'sɛŋ a baar wanswà kàyi akà nde, nde waa kàbwaay, waa kàsɛmà mulɔŋ. ");
INSERT INTO yns_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Apan, alɔɔŋ a Un'kɔɔn anà Amfarisi bun'twääl un'kaar mwɛy bàkör ba wàmutà inswem, waa bun'tɔɔl uboboo a baar banswà, ");
INSERT INTO yns_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","waa bàtɛn a Yɛsu naa: « Un'lɔɔŋ, un'kaar wà bàmun'kɔr wàmutà inswem. ");
INSERT INTO yns_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Unsà un'kɔɔn, Mɔsɛ kà iswɛŋ mutà akaar a tub abà in'kul. Waa ngye, ngye an'tɛn aben bà? » ");
INSERT INTO yns_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bàtɛɛnà ba abà ntɔn ba bun'lwɛb ndaa, anà ba bàkäl anà undiir ban'kwo ba mukun'füün. Wɛɛ Yɛsu waa kàtsüüm, kàsɛmà mubaar in'dyärà a làpin u mɛɛn. ");
INSERT INTO yns_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ntɔn bàsi ba muküünà mukun'fuul, Yɛsu kàsuub un'tswe, waa kàtɛn a ba naa: « Isàkal naa apà we anà mbuur mwɛy uboo a bɛ mpa aŋàtàkyer man'be akà ikikye, wɛy nde kun'käm un'kul atàtwɛb. » ");
INSERT INTO yns_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ungö, kàfàtsüüm nde, nde kàsön u mɛɛn. ");
INSERT INTO yns_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ungö bàwem ba ndaa ayi, ba bàsɛmà mutà upay umwɛy umwɛy, semà akà andweer. Wɛɛ Yɛsu kàsàsal aŋàyen, un'kaar kàkyàmbar kusà a nde. ");
INSERT INTO yns_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Apan, Yɛsu kàsuub nde un'tswe, waa kun'fuul naa: « Un'kaar, bàken ba? Nkye akà mbuur akyapà ikwàndwà? » – ");
INSERT INTO yns_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nde kàfuur naa: « Ŋaa, Mwol, akà mbuur. » Waa Yɛsu kàtɛn a nde naa: « Mɛ sye, mɛ apà anki ikwàndwà. Kyen, twon an'fàkyer man'be. » ");
INSERT INTO yns_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yɛsu kàfàtɛn a ba naa: « Mɛ, mɛ in'wà pɛɛlà a mɛɛn. Mbuur ayan'lab, nde usàkyà anki u mpib akà ikikye, nde asàwal pɛɛlà làfàpà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Apan, Amfarisi bàtɛn a nde naa: « Ngye, ngye awàmutà imbäl angye ŋakwo. Imbäl angye kà kyà ndandaa anki. » ");
INSERT INTO yns_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yɛsu kafuur naa: « Yà ndandaa naa mɛ, mɛ in'wàmutà imbäl amɛ ŋakwo. Imbäl amɛ kyà ndandaa, ntɔn mɛ in'kyàyöb naa mɛ an'fà ken anà mɛ sye in'kyà ken. Wɛɛ bɛ, bɛ làyöb anki naa mɛ an'fà ken anà mɛ sye in'kyà ken. ");
INSERT INTO yns_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Bɛ, bɛ nsaŋ làfàtsul unsà imbuur. Wɛɛ mɛ, mɛ in'fàtsüül anki mbuur nsaŋ. ");
INSERT INTO yns_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mpalabà, isàkal naa mɛ in'kyer atsul nsaŋ, ntsüül a nsaŋ amɛ yà balàbal, ntɔn mɛ kà in'wà aŋàyen anki, wɛɛ mɛ in'wà anà Taa, mbuur awà kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bàsön unsà Un'kɔɔn abɛ ŋakwo naa bàfàtɔn anki imbäl a baar bɔ̈ɔ̈l. ");
INSERT INTO yns_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mɛ, mɛ in'fàtà imbäl amɛ ŋakwo, Taa awà kan'töm afan'tɛɛl sye imbäl. » ");
INSERT INTO yns_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Apan ba bàtɛɛnà a nde naa: « Wàken Taaràŋà wa? » Yɛsu naa: « Bɛ, bɛ mɛ lan'yöb anki, itàkal Taaràmɛ, bɛ lun'yöb anki. Ilàkal naa bɛ lan'yöb, bɛ sye Taaràmɛ làkyer alun'yöb. » ");
INSERT INTO yns_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ndaa ayi, Yɛsu ya kàtɛɛnà umpal kàlɔɔŋà nde u ndwà a Nzam, kà ikal a insak a an'kab. Akà mbuur mwɛy kàkwe anki mukun'kɔr, ntɔn taaŋ ande làkäl aŋàkwo anki. ");
INSERT INTO yns_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yɛsu kàfàtɛn a ba naa: « Mɛ, mɛ in'kyer ayàkyà, bɛ làkyer ayan'leŋ, wɛ bɛ, bɛ làsàkwà unsà ube abɛ. Bɛ làkwe anki mukyà mper in'kyà mɛ. » ");
INSERT INTO yns_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Apan amfum a Ayudà bàtɛɛnà naa: « Nkye nde we anà an'kyän mudwa nde ŋakwo, ntɔn nde wàmutɛn naa: \"Bɛ làkwe anki mukyà mper in'kyà mɛ\"? » ");
INSERT INTO yns_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yɛsu kafuur naa: « Bɛ, bɛ làbà baar a indiir a mɛɛn mà. Wɛɛ mɛ, mɛ in'wà mbuur a indiir a dudu. Bɛ, bɛ làbà baar a mɛɛn mà, wɛɛ mɛ, mɛ kà in'wà mbuur a mɛɛn mà anki. ");
INSERT INTO yns_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Undiir awun in'tɛn mɛ a bɛ naa bɛ làsàkwà unsà man'be abɛ. Abun, isàkal naa bɛ làkyey anki naa \"Mɛ In'wà\", bɛ làsàkwà unsà man'be abɛ. » – ");
INSERT INTO yns_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ba bun'fuul naa: « Ngye, ngye awà nà? » Yɛsu kafuur naa: « Mbuur akwà kàlakyään mɛ fà nsɛmà. ");
INSERT INTO yns_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mɛ, mɛ in'we anà indiir mbɔɔn mutɛn anà mutsul nsaŋ ntɔn bɛ. Wɛɛ mɛ in'fàkyään u mɛɛn nà ya akwà kàwem mɛ akà mbuur kan'töm, nde afàtɛn ndandaa. » ");
INSERT INTO yns_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wɛɛ ba bàyöbà anki naa nde ba kasaamà ntɔn Taa. ");
INSERT INTO yns_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Apan, Yɛsu kàtɛn naa: « Utaaŋ làsàsɛɛn bɛ Mwan a mbuur, bɛ laa làsàyöb bɛ naa \"Mɛ In'wà\", anà mɛ in'fàkyer anki undiir kà ukwen amɛ ŋakwo: mɛ in'fàtɛn ya akwà kan'lɔŋ Taa. ");
INSERT INTO yns_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mbuur kan'töm wà anà mɛ: nde kan'wɛy anki aŋàyen, ntɔn mɛ, taaŋ lanswà mɛ in'fàkyer indiir ufàkwen nde. » ");
INSERT INTO yns_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Umpal kàkäl nde mutɛɛnà abà, baar mbɔɔn bàsi làkwikilà amu nde. ");
INSERT INTO yns_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Abun Yɛsu kàtɛn a Ayudà abà bàsi làkwikilà amu nde naa: « Isàkal naa bɛ, bɛ lan'lam u ndaa amɛ, ndandaa bɛ làbà alɔŋki amɛ. ");
INSERT INTO yns_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Abun, bɛ làsàyöb ndandaa, waa ndandaa isàlabuul baar a nsaay. » ");
INSERT INTO yns_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ba bun'fuur naa: « Bi, bi ibà itoo a Abàlam, bi kàsàkal anki asɔ a mbuur mwɛy akà ikikye. Aben ngye, ngye atɛɛnà naa: \"Bɛ làsàbulà baar a nsaay\"? » ");
INSERT INTO yns_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yɛsu kafuur naa: « Ndandaa, ndandaa mɛ alàkyään: mbuur wanswà afàkyer man'be, nde wà un'sɔ a man'be. ");
INSERT INTO yns_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Un'sɔ ufàbwaay anki ipepey u ndwà, wɛɛ mwan afàbwaay ipepey kwo. ");
INSERT INTO yns_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Abun, isàkal naa Mwan kàmàlakɔɔr, bɛ làsàkal baar a nsaay bàndandaa. ");
INSERT INTO yns_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mɛ in'kyàyöb naa bɛ làbà itoo a Abàlam, wɛɛ bɛ làfàleŋ mukan'dwa, ntɔn ndaa amɛ ifàlatwà anki u mpem. ");
INSERT INTO yns_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mɛ, mɛ in'fàtɛn indiir kàmɛn mɛ akà Taa. Wɛɛ bɛ, bɛ làfàkyer indiir làwem bɛ akà taaràbɛ. » ");
INSERT INTO yns_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ba bun'fuur naa: « Abàlam wà taaràbi. » Yɛsu naa: « Kya bɛ làlàkal baan a Abàlam, bɛ làlikyerà isal a Abàlam. ");
INSERT INTO yns_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Wɛɛ apanà, bɛ, bɛ làleŋà mukan'dwa, mɛ mbuur kàlakyään ndandaa ayà kàwem mɛ akà Nzam. Abàlam kàkyer anki abà! ");
INSERT INTO yns_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Wɛɛ bɛ, bɛ làfàkyer isal a taaràbɛ. » Ba bun'fuur naa: « Bi kà ibà baan a inswem anki. Bi ibye awà Taa mwɛy mpɛl, Nzam. » ");
INSERT INTO yns_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yɛsu kafuur naa: « Yàlàkal naa Nzam wà Taaràbɛ, bɛ làlàkyer an'kwen. Ntɔn mɛ, mɛ an'too amu Nzam anà mɛ sye an'fà kwo. Mɛ, mɛ kàyi anki a ukwen amɛ ŋakwo, wɛɛ Nde kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ntɔn nkye mpa làkayöbà bɛ ntɛɛn amɛ? Ntɔn bɛ, bɛ làkwe anki muwem ndaa amɛ. ");
INSERT INTO yns_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bɛ, taaràbɛ ileŋ, bɛ làfàkwen mukyer ngyal a taaràbɛ. Nde wun'dwää fà nsɛmà, nde kàsàtsim anki uboo a ndandaa, ntɔn ndandaa amu nde yatɛy. Umpal ufàtà nde loor, nde la afàwal uboo a indiir ande ŋakwo, ntɔn nde wà ŋaloor anà taar a loor. ");
INSERT INTO yns_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wɛɛ, mɛ in'fàtɛn ndandaa, undiir awun mpa làfan'sà bɛ làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nà uboo abɛ kan'kwo mukan'swaŋ naa mɛ an'kyer man'be? Ntɔn nkye lan'kɔɔn bɛ mukan'sà làkwikilà isàkal naa mɛ an'tɛn ndandaa? ");
INSERT INTO yns_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mbuur awà mbuur a Nzam, afàwem ndaa a Nzam. Wɛɛ bɛ, bɛ làfàwem anki, ntɔn bɛ kàlàbà baar a Nzam anki. » ");
INSERT INTO yns_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayudà bun'fuur naa: « Nkye bi iböŋ kyatɛy mutɛn naa ngye awà un'nsi Samalya, anà ngye sye awe anà unsɔŋà? » – ");
INSERT INTO yns_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yɛsu kàfuur naa: « Mɛ, mɛ unsɔŋà watɛy. Wɛɛ mɛ, mɛ in'wàmusyäŋà Taaràmɛ. Wɛɛ bɛ, bɛ làkun'syäŋà anki. ");
INSERT INTO yns_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mɛ, mɛ in'fàleŋ anki làkoo amɛ ŋakwo. We anà mbuur afàpà la anà afàtsul mbar. ");
INSERT INTO yns_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ndandaa, ndandaa, mɛ alàkyään: isàkal naa mbuur kan'kaar ndaa amɛ, nde usàkwà anki akà ikikye. » ");
INSERT INTO yns_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Apan, Ayudà nsil abà bàtɛn a nde naa: « Apanà, bi kan'yöb naa ngye awe anà unsɔŋà! Abàlam kàkyàkwà anà aŋangɔɔm sye, wɛ ngye atɛn naa: \"Isàkal naa mbuur an'kaar ndaa amɛ, nde usàkwà anki akà ikikye.\" ");
INSERT INTO yns_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nkye ngye, ngye an'söön taaràbi Abàlam awà kàkü itaan? Aŋangɔɔm sye bàkyàkwà! Ngye, ngye akasii naa ngye awà nà? » ");
INSERT INTO yns_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yɛsu kafuur naa: « Isàkal naa mɛ, mɛ in'fàsà làkoo akà mɛ ŋakwo, la ndöŋ latɛy. Mɛ, mɛ in'fàsà làkoo a Taaràmɛ, nde akwà làfàtɛn bɛ naa: \"Nde wà Nzam abi\". ");
INSERT INTO yns_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Bɛ nde lun'yöb anki, wɛɛ akà mɛ, mɛ in'kyun'yöb. Kya mɛ in'sàtɛn naa mɛ un'yöb anki, mɛ in'sàkal mbuur a loor asànaa bɛ. Mɛ in'kyun'yöb anà mɛ sye in'fàkaar ndaa ande. ");
INSERT INTO yns_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Taaràbɛ Abàlam kàkäl kà un'sak unsà an'kyän muman ilä amɛ: nde kàkyàman kya, waa kàkü unsà un'sak. » ");
INSERT INTO yns_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayudà waa bàtɛn a nde naa: « Nkye ngye akà mbul an'kwem an'tyeen awe ayà, waa ngye kàmɛn Abàlam! » ");
INSERT INTO yns_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yɛsu naa: « Ndandaa, ndandaa, mɛ alàkyään: kusà a mböör a Abàlam, \"Mɛ In'wà\". » ");
INSERT INTO yns_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Apan, ba b 1 bür in'kul ntɔn mukun'kam. Wɛɛ Yɛsu laa kàkàyee nde, waa kàtoo u ndwà a Nzam. ");
INSERT INTO yns_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","U mbwo, Yɛsu kàmɛn baal mwɛy wàŋàkwàmii fà mböör ande. ");
INSERT INTO yns_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Alɔŋki ande bun'fuul naa: « Rabi, nà kàkyer man'be ntɔn nde bun'bör wàŋàkwàmii, nkye nde lɛɛ aböör ande? » ");
INSERT INTO yns_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yɛsu kàfuur naa: « Kà nde anki, itàkal aböör ande, wɛɛ ntɔn isal a Nzam imɛnà amu nde. ");
INSERT INTO yns_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ibà bi pà u mwäänà, bi ikyer isal a mbuur kan'töm. Làpib làmubwà, taaŋ mpa usal mbuur. ");
INSERT INTO yns_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Umpal in'wà mɛ pà u mɛɛn, mɛ in'wà pɛɛlà a mɛɛn. » ");
INSERT INTO yns_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ungö mutɛn indiir abi, nde kàtsül an'te u mɛɛn, kàkyer twar, waa kàkiir la u mii a ikwamii, ");
INSERT INTO yns_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","waa kàtɛn a nde naa: « Kyen, kaywɛb kà itɛy a Silɔwɛ. » Ikɔb aki ikaswaŋà naa « Ntööm ». Ikwàmii kàkyen kwo, kàywɛy ntabwey, waa kàyimanà mpal kàyàfurà nde. ");
INSERT INTO yns_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Baar a tsütsü anà nde anà baar bàfun'manà kusà wàmulɔlɔm, bàfuulà naa: « Nkye wà kà mbuur akwà kàkälà wà aŋàbwaay anà kàfalɔ̈lɔ̈mà anki? » ");
INSERT INTO yns_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Amwɛy bàtɛɛnà naa: « Awà nde. » Bumwɛy naa: « Awà kà nde anki, mbuur asin kàmufwän. » Wɛɛ ikwàmii kàkyey naa: « Ndandaa, wà mɛ. » ");
INSERT INTO yns_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Abun, ba bun'fuulà naa: « Mii angye myan'dubà aben? » ");
INSERT INTO yns_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nde kàfuur naa: « Mbuur awà bàfàbel Yɛsu kàkyer twar, kan'kiir la u mii, waa kàtɛn a mɛ naa: \"Kyen Silɔwɛ, kaywɛb\". Apan sye in'kyen mɛ, in'ywɛb mɛ, waa in'bulà muman! » ");
INSERT INTO yns_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ba bun'fuul naa: « Nde wàken, mbuur wa? » Nde kàfuur naa: « Mɛ in'yöb anki. » ");
INSERT INTO yns_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Apan, ba bàtwääl mbuur kàkäl ikwàmii akà Amfarisi. ");
INSERT INTO yns_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kyekà, ilä akin kyàkäl ilä a saba akyà kàkyer Yɛsu twar, anà kun'duub nde mii. ");
INSERT INTO yns_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Apan sye, Amfarisi bun'fuul sye naa mii angye myàdubà aben. Nde kafuur naa: « Nde kan'kiir twar u mii, in'ywɛb mɛ, waa mɛ an'man. » ");
INSERT INTO yns_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Apan, uboo a Amfarisi amwɛy bàtɛɛnà naa: « Mbuur awà kà kan'fà akà Nzam anki, ntɔn nde saba ufàkyɛɛl anki. » Wɛɛ bumwɛy bàtɛɛnà naa: « Nkye mbuur a man'be kan'kwo ukäl anà ikɔ̈b akyer idiim a tub abi? » Nkaabà yàkyer abilà uboo a ba. ");
INSERT INTO yns_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Apan, ba bàfàfuul ikwamii naa: « Waa ngye, ngye an'tɛn aben ntɔn mbuur kaduub mii? » Nde kàfuur naa: « Nde wà ŋangɔɔm. » ");
INSERT INTO yns_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wɛɛ amfum a Ayudà bàkyer atɔn musà làkwikilà naa nde kàkäl ikwàmii, waa nde kàbulà muman. Undiir awun, bàbel ba aböör ande ");
INSERT INTO yns_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ntɔn mukafuul naa: « Nkye wà mwan abɛ akwà làwe bɛ naa nde bun'bör wàŋàkwàmii? Abun, nde kan'man aben apanà? » ");
INSERT INTO yns_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aböör ande bàfuur naa: « Bi, bi ikyàyöb ndandaa naa wà mwan baal abi, nde sye bun'bör wàŋàkwàmii. ");
INSERT INTO yns_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Apanà nde kan'man aben, bi iyöb anki. Nà kun'duub mii? Bi iyöb anki. Lun'fuul, nde wàŋàyɛl, nde kan'kwo musam ntɔn nde ŋakwo! » ");
INSERT INTO yns_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aböör ande bàtɛɛnà ba abà, ntɔn ba bàtiinà Ayudà bɔɔmà. Ntɔn amfum a Ayudà bàdirà kusà muböŋ u ndwà a nköŋ a Ayudà mbuur wanswà asàkyey naa Yɛsu wà Klistɔ. ");
INSERT INTO yns_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Undiir awun aböör ande bàtɛn ba naa: « Nde wàŋàyɛl, lun'fuul! » ");
INSERT INTO yns_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Amfarisi bàbel mbuur akwà kàkäl aŋàkwàmii mbalà yàyweel, waa bàtɛn a nde naa: « Pà làkoo akà Nzam! Bi, bi ikyàyöb naa baal wà wà mbuur a man'be. » ");
INSERT INTO yns_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nde kafuur naa: « Isàkal naa nde wà mbuur a man'be, mɛ in'yöb anki. Mɛ in'yöb undiir mwɛy mpɛl awà: mɛ kàkäl ikwàmii, apanà mɛ an'man. » ");
INSERT INTO yns_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ba waa bun'fuul naa: « Ininà nde kakyer? Nde ngye mii kaduub aben? » ");
INSERT INTO yns_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nde kafuur naa: « Mɛ ya akyàlakyään itaan, wɛɛ bɛ, bɛ làwem anki. Ntɔn nkye làkwen bɛ mufàwem mbalà asin? Nkye bɛ sye, bɛ làkwen mubulà alɔŋki ande? » ");
INSERT INTO yns_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Apan, ba waa bàsɛmà mukun'to, mutɛn naa: « Ngye mbuur awà un'lɔŋki ande! Bi, bi ibà alɔŋki a Mɔsɛ. ");
INSERT INTO yns_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bi, bi ikyàyöb naa Nzam kàyääm a Mɔsɛ, wɛɛ mbuur wà, bi iyöb anki naa nde an'fà ken! » ");
INSERT INTO yns_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Baal kafuur naa: « Le, ayi ndaa yubem: bɛ làyöb anki naa nde kan'fà ken, apan sye nde kàman'duub mii! ");
INSERT INTO yns_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bi ikyàyöb naa Nzam ufàwem anki baar a man'be. Wɛɛ isàkal naa mbuur afàkömà Nzam anà afàkyer ukwen ande, Nzam afàkyer un'wem. ");
INSERT INTO yns_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Baar ŋàtàwem anki akà ikikye mutɛn naa mbuur mwɛy waa kàkɔɔr ikwàmii fà mböör ande. ");
INSERT INTO yns_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ilàkal naa mbuur awà kàfü anki akà Nzam, nde kàlàkwo anki mukyer akà undiir. » ");
INSERT INTO yns_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ba bun'fuur naa: « Ngye wanswà awà uboo a man'be fà mböör angye, waa ngye ilɔŋ! » Apan ba waa bun'tɔɔm u nsà. ");
INSERT INTO yns_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yɛsu kàwem naa ba nde bàkyer un'böŋ. Mpal kàbwey nde anà nde, nde kun'fuul naa: « Nkye ngye, ngye an'sà làkwikilà amu mwan a mbuur? » – ");
INSERT INTO yns_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nde kun'fuur naa: « Mwol, nde wà nà, waa mɛ in'sà làkwikilà amu nde? » ");
INSERT INTO yns_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yɛsu waa kàtɛn a nde naa: « Ngye amun'man, wa atɛɛnà awà apanà anà ngye, nde awà. » ");
INSERT INTO yns_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Baal waa kàtɛn naa: « Mwol, mɛ, mɛ an'sà làkwikilà. » Apan, nde kàbü an'köm kusà a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Waa Yɛsu kàtɛn naa: « Mɛ, mɛ kàyi u mɛɛn pà ntɔn ntsüül a nsaŋ mwɛy ikäl: ntɔn ikwàmii bàmɛn, baar bàfàman bàbulà ikwàmii. » ");
INSERT INTO yns_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Amfarisi bàkäl tsütsü apà nde, bàwem ba indiir abi, waa bun'fuul naa: « Nkye bi sye, bi ibà ikwàmii? » ");
INSERT INTO yns_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yɛsu kafuur naa: « Yàlàkal naa bɛ làbà ikwàmii, bɛ làlàkal anki baar a man'be. Wɛɛ ntɔn bɛ làtɛn naa: \"Bi ifàman\", abun, man'be abɛ mà kapaa. » ");
INSERT INTO yns_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yɛsu kàtɛn naa: « Ndandaa, ndandaa, mɛ alàkyään: isàkal naa mbuur ubilà anki u munàmbwo a làböl a in'kɔk, wɛɛ naa nde kan'lar udu a ibä a làböl, u ntsü yumwɛy, nde wà mbüüb anà un'dwää. ");
INSERT INTO yns_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wɛɛ mbuur afàbilà u munàmbwo, nde wun'kyɛɛŋ a in'kɔk. ");
INSERT INTO yns_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Un'leer kun'duub munàmbwo, in'kɔk myàwem ndaa ande. Nde afàbel in'kɔk ande umwɛy umwɛy kà ikɔb awa, waa utwey mya u nsà. ");
INSERT INTO yns_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Utaaŋ utwey nde mya myanswà, uyikyà nde kusà a mya, mya myun'lab ungö, ntɔn mya myàkyàyöb ndaa ande. ");
INSERT INTO yns_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ikwe anki akà ikikye naa mya myàsàlab ungyey, mya ikyer asun'tiin, ntɔn mya myàyöb anki ndaa a angyey. » ");
INSERT INTO yns_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yɛsu katɛɛl nsim ayi, wɛɛ ba bàyöb anki naa indiir nà nde kàtɛɛnà. ");
INSERT INTO yns_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yɛsu kàfàtɛn naa: « Ndandaa, ndandaa mɛ alàkyään, mɛ in'wà munàmbwo a làböl a in'kɔk. ");
INSERT INTO yns_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Baar banswà bàfwel kusà a mɛ bà mbüüb anà adwää, wɛɛ in'kɔk myawem anki. ");
INSERT INTO yns_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mɛ, mɛ in'wà munàmbwo. Isàkal naa mbuur kan'bilà u mbwo amɛ, nde asàwà mɔ̈ɔ̈, nde akyer asàbilà, akyer asàtoo, nde asàman byàdyà. ");
INSERT INTO yns_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mbüüb afàyà nà muyib, mudwa anà mupay. Wɛɛ mɛ, mɛ kàyi ntɔn baar bàwɛl mɔ̈ɔ̈ anà bàwɛl wa mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mɛ, mɛ in'wà un'kyɛɛŋ aŋàbwaŋ. Un'kyɛɛŋ aŋàbwaŋ afàpà mɔ̈ɔ̈ ande ntɔn in'kɔk ande. ");
INSERT INTO yns_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mbuur afàsal ntɔn ngim mpɛl, nde kà wà un'kyɛɛŋ a ndandaa anki, in'kɔk kà myànde anki. Kya nde usàman kyɛŋbɔl làmuyà, nde la usàkɔɔb nde in'kɔk, waa uwurà ntiin. Apan, kyɛŋbɔl la làsàbürà la mya, waa làsàtà làböl upay. ");
INSERT INTO yns_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Le, nde wà un'syääl a ngim, nde undiir ukyɛr anki ntɔn in'kɔk. ");
INSERT INTO yns_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mɛ, mɛ in'wà un'kyɛɛŋ aŋàbwaŋ. Mɛ in'kyàyöb in'kɔk amɛ, mya sye myàkyan'yöb, ");
INSERT INTO yns_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Taaràmɛ akyan'yöb, mɛ sye in'kyun'yöb. Mɛ in'fàpà mɔ̈ɔ̈ amɛ ntɔn in'kɔk amɛ. ");
INSERT INTO yns_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mɛ, mɛ in'we anà in'kɔk myumwɛy mpa amyà uboo a làböl alà. Mya sye mɛ in'kyer atwaal. Mya isàwem ndaa amɛ, làböl làsàkal làmwɛy, un'kyɛɛŋ mwɛy sye. ");
INSERT INTO yns_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Taa akyan'kwen, ntɔn mɛ in'fàpà mɔ̈ɔ̈ amɛ, ungö waa in'fàwal wa. ");
INSERT INTO yns_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Akà mbuur mwɛy tɛy afan'duum mɔ̈ɔ̈, wɛɛ mɛ, mɛ wa in'fàpà a ukwen amɛ. Mɛ in'we anà ikɔ̈b apà wa, anà ikɔ̈b afàwal wa. Ayi nswɛɛŋ kan'pɛ Taaràmɛ. » ");
INSERT INTO yns_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","U ndaa ayi, nkaabà yàkyer abilà uboo a amfum a Ayudà. ");
INSERT INTO yns_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bàmbɔɔn uboo a ba bàtɛɛnà naa: « Nde we anà unsɔŋà! Nde wà ŋukɔŋ! Ntɔn nkye lun'weemà bɛ? » ");
INSERT INTO yns_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wɛɛ bumwɛy bàtɛɛnà naa: « Mbuur awe anà unsɔŋà ufàtɛn anki abà. Nkye unsɔŋà kan'kwo muduub mii a ikwàmii? » ");
INSERT INTO yns_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","La làkäl paŋà làfakalà mpye mbɔɔn, baar bàkäl mukyɔm mpööŋ a ndwà a Nzam u Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yɛsu kàkäl mulàlyaaŋ u ndwà a Nzam, u myäy bàfàbel naa myäy a Salɔmun. ");
INSERT INTO yns_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Apan, Amfum a Ayudà bàkyer un'diŋà, waa bun'fuul naa: « Tii mpal nà asikaar ngye unsà pfürà? Ikyään ubwaŋàbwaŋ isàkal naa ngye awà Klistɔ. » ");
INSERT INTO yns_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yɛsu kafuur naa: « Mɛ ya akyàlakyään itaan, wɛɛ bɛ, bɛ lan'si anki làkwikilà. Isal in'fàkyer mɛ kà ikɔb a Taaràmɛ, byàmutà imbäl ntɔn mɛ. ");
INSERT INTO yns_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Wɛɛ bɛ lan'si anki làkwikilà, ntɔn bɛ kàlàbà in'kɔk amɛ anki. ");
INSERT INTO yns_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","In'kɔk amɛ myàfàwem ndaa amɛ. Mɛ in'kyayöb, mya sye myàkyer afan'lab. ");
INSERT INTO yns_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mɛ in'fapà mɔ̈ɔ̈ a mbul a in'tye, mya myàsàkyà anki bwà akà ikikye, akà mbuur mwɛy ukwe anki mugyɔɔr mya u kɔɔ amɛ. ");
INSERT INTO yns_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taaràmɛ, mbuur kan'pɛ mya, kan'söön baar banswà. Akà mbuur mwɛy ukwe anki mugyɔɔr mya u kɔɔ a Taa. ");
INSERT INTO yns_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taa anà mɛ, bi ibà mwɛy. » ");
INSERT INTO yns_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayudà bàfàbürà in'kul ntɔn mukun'tà. ");
INSERT INTO yns_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Apan, Yɛsu kàtɛn a ba naa: « Mɛ kàlamɛɛy isal a ntwɛn mbɔɔn byàfü akà Taa. Isal nà uboo a bya làkwen bɛ mukan'tà in'kul? » ");
INSERT INTO yns_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayudà bun'fuur naa: « Kà ntɔn isal a ntwɛn anki waa bi katà in'kul, wɛɛ ntɔn mbɛɛy: ngye awà mbuur, wɛɛ ngye, ngye awàmukyey naa ngye awà Nzam! » ");
INSERT INTO yns_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yɛsu kafuur naa: « Nkye bàsön anki uboo a un'kɔɔn abɛ naa: \"Mɛ, mɛ kàtɛn naa bɛ làbà bànzam.\"? ");
INSERT INTO yns_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bi ikyàyöb naa ikwe anki bàlwom indiir abyà uboo a Ndaa Aŋàsɔn. Kyekà, Nzam kàbel nde baar naa bànzam, ntɔn ndaa ande bàtöm akà ba. ");
INSERT INTO yns_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Bɛ, bɛ làtɛn a baal kàsi Nzam an'kɔɔ anà kàtöm nde u mɛɛn naa: \"Ngye awàmubɛy!\", ntɔn an'tɛn mɛ naa mɛ in'wà Mwan a Nzam! ");
INSERT INTO yns_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Isàkal naa mɛ in'fàkyer anki isal a Taaràmɛ, twon làman'sà làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wɛɛ isàkal naa mɛ in'fàkyer bya, itàkal naa bɛ lan'sà anki làkwikilà, làsi làkwikilà unsà isal abi. Ntɔn bɛ làyöb anà làkyey naa Taa wà amu mɛ, mɛ in'wà amu Taa. » ");
INSERT INTO yns_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Apan, ba bàfàleŋ mukun'kɔr, wɛɛ nde kàkwiyà kà an'kɔɔ aba. ");
INSERT INTO yns_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yɛsu kàfàfurà sim a Yɔrdan lumwɛy, kà ikal kàfadümà Ywan utàtwɛb, waa kàbwaay kwo. ");
INSERT INTO yns_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Baar mbɔɔn bàyee akà nde, waa bàtɛɛnà naa: « Ywan kàkyer anki akà idiim mwɛy, wɛɛ ndaa yanswà kàtɛn nde ntɔn mbuur awà yàkäl ndandaa. » ");
INSERT INTO yns_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Abun, baar mbɔɔn bàsi làkwikilà amu nde. ");
INSERT INTO yns_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kàkäl anà ŋukyal mwɛy ikɔb ande Lazar, un'si Bɛtanya, bul a Màlatà anà mpääŋ ande Màlye. ");
INSERT INTO yns_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","- Wawà Màlye akwà kàtsüül Mwol may a usɔŋ anà kun'kɔɔm in'kɔl a ntswe ande. Baal ande Lazar kàkäl anà ukyal. - ");
INSERT INTO yns_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Abun, ampääŋ abà bàbɔ̈ɔ̈l bàtöm mbuur mwɛy mukàkyään Yɛsu naa: « Mwol, mbuur akwà afàkwen ngye we anà ukyal. » ");
INSERT INTO yns_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Umpal kàwem Yɛsu làsaŋ alà, nde kàtɛn naa: « Abà kà ukyal akun'syen kà ukwà anki, wɛɛ ba bà ntɔn mupà làkoo akà Nzam: u mbwo a ba, Mwan a Nzam ayàwal làkoo. » ");
INSERT INTO yns_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kyekà, Yɛsu kàfakwenà Màlatà, anà mpääŋ ande, anà Lazar. ");
INSERT INTO yns_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Umpal kàwem nde naa Lazar we anà ukyal, nde kàfàkyer ilä byeel kà ikal kàkäl nde. ");
INSERT INTO yns_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ungö apan nde kàtɛn a alɔŋki naa: « Tsweenà ifurà Yuday. » ");
INSERT INTO yns_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Alɔŋki bun'fuur naa: « Un'lɔɔŋ, itaan a mbɔɔn tɛy, amfum a Ayudà bàleŋà mukatà in'kul, waa ngye akwen mufàfurà kwo? » ");
INSERT INTO yns_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yɛsu kàfuur naa: « Nkye an'taaŋ kwem aŋiyweel matɛy u mwäänà? Isàkal naa mbuur wàmuyikyà u mwäänà, nde uböl anki kyà, ntɔn lye anà pɛɛlà. ");
INSERT INTO yns_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wɛɛ isàkal naa mbuur wàmuyikyà u làpib, nde atɛbà kyà, ntɔn pɛɛlà latɛy. » ");
INSERT INTO yns_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ungö kàtɛn nde ndaa ayi, nde kàkwɛy naa: « Un'sam abi Lazar kàn'bɔ̈ɔ̈n, wɛɛ mɛ in'kyer akyà mukun'wiiy. » ");
INSERT INTO yns_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Apan, alɔŋki bàtɛn a nde naa: « Mwol, isàkal naa nde wàŋàbɔ̈ɔ̈n, nde akyer ayàwà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kutɛn aŋàbwaŋ, Yɛsu kàsam ukwà a Lazar, wɛɛ ba bàsii naa twaal a twaal. ");
INSERT INTO yns_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Apan, Yɛsu kàtɛn a ba ubwaŋàbwaŋ naa: « Lazar kan'kwà. ");
INSERT INTO yns_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mɛ in'wà unsà un'sak ntɔn bɛ in'kɔ̈ɔ̈n akal mɛ kwo, ntɔn bɛ lan'si làkwikilà. Wɛɛ tsweenà akà nde. » ");
INSERT INTO yns_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Apan, Tuma awà bàfàbel naa Didimɔ, kàtɛn a alɔŋki bumwɛy naa: « Tsweenà, kya ikäl naa ukwà, bi sye ikàkwà mbwo mwɛy anà nde! » ");
INSERT INTO yns_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mpal kàyàkɔlà Yɛsu, nde kàwem naa Lazar kàkyàkyer ilä inà kà an'dii. ");
INSERT INTO yns_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kyekà, Bɛtanya làkäl tsütsü a Yɛlusàlɛm, kà isii a an'kilɔmɛtre an'tär. ");
INSERT INTO yns_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ayudà bàyi mbɔɔn muyàlɛɛl Màlye anà Màlatà ntɔn nkweel a baal aba Lazar. ");
INSERT INTO yns_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Umpal kàwem Màlatà naa Yɛsu wàmuyà, nde kàkàbwey anà nde, wɛɛ Màlye kàsàsal u ndwà wàŋàbwaay. ");
INSERT INTO yns_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Màlatà kàtɛn a Yɛsu naa: « Mwol, ilàkal naa ngye akäl apà, baal amɛ kàlàkwà anki! ");
INSERT INTO yns_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wɛɛ mɛ, mɛ in'kyàyöb, itàkal apanà, naa undiir wanswà ayàlɔm ngye akà Nzam, Nzam akyer ayapà. » ");
INSERT INTO yns_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yɛsu kàtɛn a nde naa: « Baal angye akyer ayàwiyà. » ");
INSERT INTO yns_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Màlatà kàfuur naa: « Mɛ in'kyàyöb naa nde asàkyer awiyà mbwo mwɛy a akü, kà ilä a ntsüü. » ");
INSERT INTO yns_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yɛsu kàtɛn a nde naa: « Mɛ, mɛ in'wà ngwiiyà anà mɔ̈ɔ̈. Mbuur wanswà an'sà làkwikilà amu mɛ asàkal anà mɔ̈ɔ̈, itàkal naa nde kan'kwà. ");
INSERT INTO yns_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mbuur wanswà awe anà mɔ̈ɔ̈ anà an'sà làkwikilà amu mɛ, nde usàkwà anki akà ikikye. Nkye ngye an'sà làkwikilà? » - ");
INSERT INTO yns_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nde kàfuur naa: « Inye, Mwol, mɛ an'sà làkwikilà naa ngye awà Klistɔ, Mwan a Nzam awasàyà pà u mɛɛn. » ");
INSERT INTO yns_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Apan, Màlatà kàkàbel mpääŋ ande Màlye, waa kun'kyään unsinsi naa: « Un'lɔɔŋ kan'yà, nde sye wàmukabeelà. » ");
INSERT INTO yns_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pa kàwem Màlye abà, laa kàmbarà nde, kàkyen u ntiin akà Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kyekà, Yɛsu kàkäl anki aŋàtàbilà uboo a bul, wɛɛ nde kàtàfàkal kà ikal kàkun'taan Màlatà. ");
INSERT INTO yns_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ayudà bàkäl anà Màlye u ndwà ntɔn mukun'lɛɛl, mpal bun'mɛn ba kan'barà anà kan'too u ntiin, laa bun'läb ba. Ntɔn ba bàsii naa nde wàmukyà an'dii mukàlel. ");
INSERT INTO yns_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Umpal kàkɔlà Màlye kà ikal kàkäl Yɛsu, pa kun'mɛn nde, nde kàbü kà in'kɔl ande, waa kàtɛn a nde naa: « Mwol, ilàkal naa ngye akäl apà, baal amɛ kàlàkwà anki. » ");
INSERT INTO yns_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Utaaŋ kàmɛn Yɛsu Màlatà anà Ayudà bàkäl anà nde bàmulel, mpem ande yàkyer atɛɛr, lingyoomà làkyer un'wal. ");
INSERT INTO yns_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nde waa kafuul naa: « Wa bɛ lun'tɔ̈ɔ̈l ken? » Ba bun'fuur naa: « Mwol, yamɛn. » ");
INSERT INTO yns_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yɛsu waa kàlel. ");
INSERT INTO yns_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Abun, Ayudà bàtɛɛnà naa: « Làler naa nde kàfun'kwenà aben! » ");
INSERT INTO yns_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wɛɛ amwɛy uboo a ba bàtɛn naa: « Nde mbuur kàkɔɔr ikwàmii, nkye nde kàlàkyer anki sye naa Lazar ukɔ̈ɔ̈n akwà? » ");
INSERT INTO yns_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Apan, Yɛsu kàfàtɛɛr u mpem ande, waa kàkyen an'dii, ma màkäl mɔɔ aŋàdübà a nkɔŋ. ");
INSERT INTO yns_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Apan, Yɛsu kàtɛn naa: « Làlwom nkɔŋ yi. » Màlatà, mpääŋ a un'kü, kàtɛn a nde naa: « Mwol, apanà nde ayàkal aŋàfuurà nsɔŋ, ntɔn ŋàbà ilä inà awà nde apà. » ");
INSERT INTO yns_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Wɛɛ Yɛsu kun'fuur naa: « Nkye mɛ in'tɛn anki a ngye naa isàkal naa ngye awe anà làkwikilà, ngye ayàman làkoo a Nzam? » ");
INSERT INTO yns_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Abun, ba waa bàlwom nkɔŋ. Apan, Yɛsu kàler u du, waa kàtɛn naa: « Taa, mɛ amafuur an'tɔɔn ntɔn aman'wem ngye. ");
INSERT INTO yns_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ndandaa, mɛ in'kyàyöb naa ngye afàkyer an'wem taaŋ lanswà. Wɛɛ an'tɛn mɛ abà, ntɔn baar bàman'diŋà bà bàyöb naa ngye kan'töm. » ");
INSERT INTO yns_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ungö mutɛn abà, nde kàbel u ndaa a ngwal naa: « Lazar, yatoo! » ");
INSERT INTO yns_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Un'kü sye waa kàyàtoo, in'kɔl anà an'kɔɔ myàŋàlàlal a ikaam a ipfɛy anà ntabwey yàŋàfwe a ipfɛy. Yɛsu kàtɛn a baar naa: « Lun'tsuuŋ, lun'wɛy ukyen. » ");
INSERT INTO yns_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Apan, bàmbɔɔn uboo a Ayudà bàyi akà Màlye anà bàmɛn indiir kàkyer Yɛsu, ba bun'si làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wɛɛ bumwɛy bàkàman Amfarisi, waa bakyään indiir kàkyer Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Apan, amfum a angaŋ anà Amfarisi bàköŋà làbay a nsaŋ a kölàköl, waa bàtɛn naa: « Ininà bi kan'kwo mukyer? Ntɔn baal wà wàmukyer idiim mbɔɔn! ");
INSERT INTO yns_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Isàkal naa bi kàmuwɛy musin akyer abà, baar banswà bàyun'sà làkwikilà. Apan, Bàlɔmà bàyàyà mupay ndwà a Nzam abi anà nsi abi! » ");
INSERT INTO yns_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Umwɛy uboo aba, ikɔb ande Kayifa, kàkäl undweer a angaŋ u mbul awun, nde kàtɛn a ba naa: « Bɛ, bɛ akà undiir mwɛy làkayöbà anki! ");
INSERT INTO yns_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nkye bɛ làmanà anki naa yubwaŋ naa mbuur mwɛy ukü ntɔn un'sɛŋ, waa nsi yanswà mpa ikyà bwà? » ");
INSERT INTO yns_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kyekà, nde kàtɛɛnà anki abà unsà ukwen ande ŋakwo, wɛɛ ntɔn kàkäl nde undweer a ngaŋ u mbul awun, nde kàtɛɛ ngɔɔm naa Yɛsu akyer asàkwà ntɔn un'sɛŋ ande, ");
INSERT INTO yns_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kànà ntɔn un'sɛŋ mpɛl anki, wɛɛ sye ntɔn mutüüb baan a Nzam abà bàtɛ upay. ");
INSERT INTO yns_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Fà ilä akin, amfum a Ayudà bàtsül mbar naa bàdwa Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Undiir awun, Yɛsu mpa kàfàfilyaaŋà nde kà imɛɛy u mii a amfum a Ayudà: nde kàkyen u mpey, kà itiir a nsi mwɛy tsütsü a nsye a ipɔl, u bul mwɛy ikɔb a la Ɛfalayimi, waa kàbwaay kwo anà alɔŋki ande. ");
INSERT INTO yns_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Un'kyɔm a Pak a Ayudà kàkäl tsütsü. Baar mbɔɔn bàfwee kà itiir a nsi aki bàbeenà Yɛlusàlɛm kusà a un'kyɔm mukwo, ntɔn mukàpöŋ ndür. ");
INSERT INTO yns_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ba bàkäl muleŋà Yɛsu, wɛɛ umpal bàkäl ba u Ndwà a Nzam, ba bàtɛɛnà ba a ba naa: « Bɛ làsii aben? Nkye nde uyà anki un'kyɔm? » ");
INSERT INTO yns_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kyekà, andweer a angaŋ anà Amfarisi bàpɛ nswɛɛŋ naa: isàkal naa mbuur kan'yöb ikal awà nde, nde kakyään ntɔn ba bun'kör. ");
INSERT INTO yns_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ilä isyaam kusà a Pak mukwo, Yɛsu kàkyen Bɛtanya, kà ikal kàfakalà Lazar akwà kàwiiy nde uboo a akü. ");
INSERT INTO yns_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Akun, Màlatà kun'pɛ isaa bun'lääm ba. Lazar kàkäl umwɛy uboo a baar bàkäl mbwo mwɛy anà Yɛsu mudyà u mɛsà. ");
INSERT INTO yns_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Màlye kàwɛl boboo a litre mwɛy là may a usɔŋ màndandaa, màntal a mbɔɔn, nde kàsir ma kà in'kɔl a Yɛsu. Ungö waa kàkɔɔmà ma a ntswe ande. Apan, ndwà yanswà yàtiimà a usɔŋ a may. ");
INSERT INTO yns_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ungö apan, Yudasi Isikalyɔt - umwɛy uboo a alɔŋki ande, nde mbuur awayun'yälà, - kàtɛn naa: ");
INSERT INTO yns_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","« Ntɔn nkye mpa bàyälà ba may a usɔŋ amà unsà nkam tär yà itɛr a ngim, waa bàlàpà ya akà aŋàlàmbwà? » ");
INSERT INTO yns_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kàtɛɛnà nde abà, kà ntɔn nde kàkäl anà ngyɛb a aŋàlàmbwà anki, wɛɛ ntɔn nde kàkäl mbüüb: nde kàfakaarà bɔ̈ɔ̈n a ngim, waa kàfalwabà ngim bàsyee uboo mwo. ");
INSERT INTO yns_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Apan, Yɛsu kàtɛn naa: « Un'si a duu! Kan'kyer nde abà, nde kan'tsweel kusà ntɔn ilä bàsan'dye. ");
INSERT INTO yns_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bɛ làwe anà aŋàlàmbwà ilä byanswà, wɛɛ mɛ, bɛ làbye anki anà mɛ ilä byanswà. » ");
INSERT INTO yns_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Apan, un'sɛŋ a Ayudà mbɔɔn kàwem wa naa Yɛsu kàkäl u Bɛtanya, wa kàkyeenà kwo, kà nà ntɔn Yɛsu mpɛl anki, wɛɛ sye ntɔn mukàman Lazar akwà kàwiiy nde uboo a akü. ");
INSERT INTO yns_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Apan, andweer a angaŋ bàdirà mudwa Lazar sye, ");
INSERT INTO yns_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ntɔn Ayudà mbɔɔn bàtiinà Ikööŋ aba, waa bàsyee làkwikilà akà Yɛsu isin nà Lazar. ");
INSERT INTO yns_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","U taaŋtye, iköŋ a baar mbɔɔn akwà bàyi un'kyɔm a Pak, kyàwem naa Yɛsu wàmuyàbeenà Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ba bàwɛl an'laaŋ a an'bà, bàkyen mukàbwey anà nde, bàmuyisà in'kwɛŋ naa: « Ɔsana! Wɛy ukäl aŋàsaak mbuur awà ayà kà ikɔb a Mwol, Mfum a Isàlɛl. » ");
INSERT INTO yns_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yɛsu kàmɛn mwan a anɛ, waa kàbwaay udu a wa, asànaa ikyäänà Ndaa Aŋàsɔn naa: ");
INSERT INTO yns_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","« Bul a Siyɔn, twon an'man bɔɔmà! Le, Mfum angye wàmuyà, akyàbwaay udu a mwan a anɛ. » ");
INSERT INTO yns_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","U nsɛmà, alɔŋki ande bàkayöbà anki indiir abi. Wɛɛ umpal kàwɛl Yɛsu làkoo, apan ba bàyɔbà naa indiir abi bàsön ntɔn nde anà ba bya sye bàkyer ntɔn nde. ");
INSERT INTO yns_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Baar banswà bàkäl anà Yɛsu mpal kàbel nde Lazar muyàtoo kà an'dii anà kun'wiiy nde uboo a akü, bun'tɛɛlà imbäl. ");
INSERT INTO yns_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kyakin, iköŋ a baar kyàkàbwey kya anà nde, ntɔn kya kyàwem naa nde kàkyer impà akin. ");
INSERT INTO yns_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Apan, Amfarisi bàtɛn ba a ba naa: « Bɛ lan'man naa bɛ akà undiir làyàwal anki: le, baar banswà bàmun'lab! » ");
INSERT INTO yns_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yàmɛnà naa uboo a baar bàbeenà Yɛlusàlɛm mukömà umpal a un'kyɔm, bàkäl anà Angɛlɛki amwɛy. ");
INSERT INTO yns_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ba bàsin apà Filipo, un'nsi Bɛtesayidà a Ngalilɛ, waa bun'lɔ̈ɔ̈m naa: « Un'lɔɔŋ, bi ikwen muman Yɛsu. » ");
INSERT INTO yns_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo kàkàsam Andrɛ, ungö, ba bàbɔ̈ɔ̈l waa bàkàsam Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yɛsu kafuur naa: « Mpalabà taaŋ lan'kwo alà uwal Mwan a mbuur làkoo. ");
INSERT INTO yns_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ndandaa, ndandaa, mɛ alàkyään, isàkal naa imbɛŋ a blɛ kyan'bwà u mɛɛn ikü anki, kya ikal kya mpɛl aŋàyen. Wɛɛ, isàkal naa kya kyan'kwà, kya ibɔr mbɛŋ mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mbuur akwen mɔ̈ɔ̈ ande aŋàsɔ̈ɔ̈n Nzam, wa akyà bwà, wɛɛ mbuur asàkɔɔb mɔ̈ɔ̈ ande u mɛɛn pà, nde asàkaar wa mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Isàkal naa mbuur kan'kwen mukan'syääl, wɛy nde kan'läb. Ikal in'wà mɛ, un'syääl amɛ asàkal kwo sye. Isàkal naa mbuur kàman'syääl, Taa asun'pà làkoo. ");
INSERT INTO yns_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","« Papanà mpem amɛ yan'too! Waa ininà mɛ in'tɛn? Taa, ntsü mɔ̈ɔ̈ utaaŋ alà? Wɛɛ kiin amɛ, mɛ kàyi ntɔn taaŋ a mpay a tub alà! ");
INSERT INTO yns_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taa, pà ikɔb angye làkoo! » Apan, ndaa yàfü du, yàtɛn naa: « Mɛ kàkyàpà kya làkoo, mɛ in'kyer ayàfàpà kya làkoo. » ");
INSERT INTO yns_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Iköŋ a baar kyàkäl pa anà kyàwem ndaa, kyàtɛɛnà naa: « Ipar kyan'bwà! » Bumwɛy naa: « Un'kyeey mwɛy kàmusam! » ");
INSERT INTO yns_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yɛsu kakyään naa: « Ndaa ayi kà ban'tɛn a mɛ anki, wɛɛ ban'tɛn a bɛ. ");
INSERT INTO yns_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Papanà là taaŋ mutsul nsaŋ a mɛɛn mà, papanà mfum a mɛɛn mà bàyun'tɔɔm u nsà. ");
INSERT INTO yns_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wɛɛ akà mɛ, mpal bàsan'sɛɛn u mɛɛn pà, mɛ in'sànaan baar banswà akà mɛ. » ");
INSERT INTO yns_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kàtɛɛnà nde abà, nde kàswɛŋà naa nkweel ande isàkal aben. ");
INSERT INTO yns_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Iköŋ a baar kyun'fuur naa: « Bi, bi kàlɔŋàkà unsà Un'kɔɔn naa Klistɔ asàkal anà mɔ̈ɔ̈ ipepey. Aben ngye an'kwo mutɛn naa Mwan a mbuur bàkyer asun'sɛɛn? Nà Mwan a mbuur awà? » ");
INSERT INTO yns_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yɛsu kàtɛn a ba naa: « Pɛɛlà làfàkal anki anà taaŋ mbɔɔn uboo a bɛ. Làlyaaŋ umpal làbà bɛ anà pɛɛlà, ntɔn mpib ikɔ̈ɔ̈n alabweel. Ntɔn mbuur afilyaaŋ u mpib, nde uyöb anki naa nde akyà ken. ");
INSERT INTO yns_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kyakin, mpal làbà bɛ anà pɛɛlà, làsi làkwikilà amu pɛɛlà, ntɔn bɛ làbulà baan a pɛɛlà. » Ungö kàsam nde ba abà, Yɛsu kàlwomà paa, waa kàkàyee ukwɛl apà ba. ");
INSERT INTO yns_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Itàkal naa nde kàkyerà idiim mbɔɔn u mii a ba, ba bàsun'sà anki làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Abun yàkwe ndaa kàtɛn ŋangɔɔm Yɛsay: « Mwol, nà kàsi làkwikilà akà an'lɔɔŋ abi? Mwol ngwal ande kàswɛŋ akà nà? » ");
INSERT INTO yns_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yɛsay awà kàswɛŋ sye isin a ndaa mpa bàkwe ba musà làkwikilà: ");
INSERT INTO yns_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","« Nzam kàdwä mii aba, nde kàbuul mpem aba bwoor, ntɔn mii aba ikɔ̈ɔ̈n atääl, naa mpem aba ikɔ̈ɔ̈n ayöb, ntɔn ba bàkɔ̈ɔ̈n asàfyefurà akà mɛ ntɔn mɛ akɔɔr. » ");
INSERT INTO yns_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yɛsay kàtɛn nde indiir abi, ntɔn kàmɛn nde làkoo a Yɛsu, waa kàsam ntɔn nde. ");
INSERT INTO yns_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Apanà sye, bàmbɔɔn uboo a amfum a Ayudà ŋakwo bàsi làkwikilà amu nde. Wɛɛ, ntɔn Amfarisi, ba bàkyey anki u mii a baar manà bàyatwey u ndwà a nköŋ a Ayudà. ");
INSERT INTO yns_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ntɔn ba bàkwen làkoo lan'fà akà baar, akwànaa lan'fà akà Nzam. ");
INSERT INTO yns_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yɛsu kàsi un'kwɛŋ: « Mbuur asà làkwikilà amu mɛ, kà amu mɛ mpɛl anki nde kan'sà làkwikilà, wɛɛ amu mbuur kan'töm sye. ");
INSERT INTO yns_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mbuur aman'man, nde kan'man sye mbuur kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mɛ pɛɛlà, mɛ kàyi u mɛɛn, ntɔn mbuur wanswà asà làkwikilà amu mɛ, ukɔ̈ɔ̈n akal uboo a mpib. ");
INSERT INTO yns_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Isàkal naa mbuur kan'wem ndaa amɛ, wɛ nde ya ufàsyääl anki, kà mɛ anki in'sàtsul nsaŋ ande, ntɔn mɛ kàyi anki mutsul nsaŋ a mɛɛn, wɛɛ ntɔn mukun'tswà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mbuur atɔn mɛ anà akɔ̈ɔ̈n akyey ndaa amɛ, nde we anà un'tsüül a nsaŋ ande: an'lɔɔŋ kàpɛɛ mɛ isun'tsüül mbar kà ilä a ntsüü. ");
INSERT INTO yns_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ntɔn mɛ kàtɛn anki unsà ukwen amɛ ŋakwo, wɛɛ Taa, mbuur kan'töm, kan'swɛŋ nde ŋakwo naa ininà mɛ in'tɛn, ininà mɛ in'kyään. ");
INSERT INTO yns_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Waa mɛ in'kyàyöb naa nswɛɛŋ ande ifàpà mɔ̈ɔ̈ a mbul a in'tye. Kyakin indiir an'tɛn mɛ, mɛ bya an'tɛn asànaa kan'swɛŋ Taa. » ");
INSERT INTO yns_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yàmɛnà naa kusà a un'kyɔm a Pak, Yɛsu kàkyer ayöb naa taaŋ ande lan'kwo, taaŋ ntɔn mulwomà u mɛɛn pà anà mukyà akà Taa. Nde kàkwen bànde abà u mɛɛn pà, nde kakwen aŋàsöönà. ");
INSERT INTO yns_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kyekà, umpal bàkäl ba mudyà làsisye, ileŋ kàkyàbiil itaan an'kyän u mpem a Yudasi, mwan a Simɔn Isikalyɔt, ntɔn mukun'yälà. ");
INSERT INTO yns_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yɛsu kàyöbà naa indiir byanswà Taa kàpɛ kà an'kɔɔ ande, naa nde kàtoo amu Nzam, nde wàmufurà akà Nzam. ");
INSERT INTO yns_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yɛsu kàmbarà u mɛsà, kàlwom ipfey adu ande, waa kàwɛl làpye, kàbäm la u lɔŋ. ");
INSERT INTO yns_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ungö, nde kàsi an'dà u làlɔŋà, waa kàsɛmà muywɛy in'kɔl a alɔŋki ande, waa kàkɔɔmà mya a làpye kàbäm nde u lɔŋ. ");
INSERT INTO yns_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Apan, kan'yàtol nde akà Simɔn Petɔlà, nde waa utɛn a nde naa: « Mwol, ngye, an'ywɛy in'kɔl! » ");
INSERT INTO yns_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yɛsu waa kun'fuur naa: « Undiir in'kyer mɛ wà, ngye wa ayöb anki apanà, wɛɛ ngye wa asàyöb ungö. » ");
INSERT INTO yns_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petɔlà kàtɛn a nde naa: « Aay, ngye mɛ in'kɔl an'ywɛy anki akà ikikye! » Yɛsu kun'fuur naa: « Isàkal naa mɛ mya aywɛy anki, ngye un'tüüb anà mɛ watɛy. » ");
INSERT INTO yns_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simɔn Petɔlà kàtɛn a nde naa: « Mwol, isàkal abwɛy, twon aman'ywɛy nà in'kɔl mpɛl, wɛɛ anà an'kɔɔ anà un'tswe sye! » ");
INSERT INTO yns_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yɛsu kàtɛn a nde naa: « Mbuur aŋàywab, nde mfun afàywab yatɛy, ntɔn ndür ande yanswà yàŋàpɔŋà. Bɛ, bɛ làbà aŋàpɔŋà, wɛɛ kà bɛ banswà anki. » ");
INSERT INTO yns_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nde kàkyer ayöb ubwaŋàbwaŋ naa nà kàlun'yälà, undiir awun kàtɛn nde naa: « Kà bɛ banswà anki làbà aŋàpɔŋà. » ");
INSERT INTO yns_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ungö kaywɛy nde in'kɔl, Yɛsu kàfàbwaar ipfɛy adu ande, nde kàfurà u mɛsà, waa kàtɛn a ba naa: « Nkye bɛ lan'yöb undiir amàlakyer mɛ? ");
INSERT INTO yns_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bɛ, bɛ làfan'bel \"Un'lɔɔŋ\" anà \"Mwol\", bɛ làbye anà iböŋ, ntɔn mɛ in'wà nde. ");
INSERT INTO yns_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Abun, isàkal naa mɛ Mwol anà Un'lɔɔŋ, mɛ amàlaywɛy in'kɔl, wɛy bɛ, bɛ sye làywɛy in'kɔl bɛ a bɛ. ");
INSERT INTO yns_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mɛ amàlapà mbaan, ntɔn bɛ sye làkyer asànaa amàlakyer mɛ là. ");
INSERT INTO yns_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ndandaa, ndandaa, mɛ alàkyään: un'syääl ukwe anki ulyaaŋ nkum ande, itàkal naa ntööm ulyaaŋ mbuur kun'töm. ");
INSERT INTO yns_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Isàkal naa bɛ lan'yöb indiir abi, bɛ làbà aŋun'sak isàkal naa bɛ lan'syääl bya. ");
INSERT INTO yns_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mɛ, mɛ in'tɛn anki ntɔn bɛ banswà, ntɔn mɛ in'kyàyöb baar kàsɔ̈ɔ̈l mɛ. Wɛɛ, wɛy Ndaa Aŋàsɔn ikwe: \"Mbuur kàdyee làmpà anà mɛ, kàman'diŋà làkɔl mbaar.\" ");
INSERT INTO yns_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Apanà, mɛ amàlakyään kusà a ndaa ayi muyà, ntɔn, umpal iyàyà ya, waa bɛ làyàsà làkwikilà naa \"Mɛ In'wà\". ");
INSERT INTO yns_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ndandaa, ndandaa mɛ alàsam: mbuur wanswà awal mbuur an'tɔm mɛ, nde kàman'wal sye. Mbuur kàman'wal, nde kan'wal sye mbuur kan'töm. » ");
INSERT INTO yns_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ungö mutɛn indiir abi, mpem a Yɛsu kàkyer ayɔɔ, waa kàtɛ imbäl ki: « Ndandaa, ndandaa mɛ alàkyään, umwɛy uboo abɛ akyer ayan'yälà. » ");
INSERT INTO yns_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Apan, alɔŋki bàleerà ba a ba u mii, ukɔɔn ayöb naa nde atɛɛnà ntɔn nà. ");
INSERT INTO yns_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Umwɛy uboo a alɔŋki, awà kàfakweenà Yɛsu, kàkäl ukɔl a nde. ");
INSERT INTO yns_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Apan, Simɔn Petɔlà kun'bɛl imbweer: « Un'fuul, nde atɛɛnà ntɔn nà. » ");
INSERT INTO yns_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ungö, un'lɔŋki awà kàkàyiir kà itɔl a Yɛsu, waa kun'fuul naa: « Mwol, nà wa? » ");
INSERT INTO yns_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yɛsu kàfuur naa: « Mbuur awà in'yàpà mɛ itiir a làmpà in'yàdümà mɛ. » Apan sye, Yɛsu kàwɛl itiir a làmpà, kàdümà kya, waa kàpɛ kya akà Yudasi, mwan a Simɔn Isikalyɔt. ");
INSERT INTO yns_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pa kàyä Yudasi itiir a mampà kya, Satanà laa kun'bilà nde. Yɛsu kàtɛn a nde naa: « Yudasi, undiir awà ngye awà mukyer, kyer wa agyägyä! » ");
INSERT INTO yns_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Baar bàkäl u mɛsà bàyöb anki, akà mbuur mwɛy, naa ntɔn nkye Yɛsu kun'kyään nde abwɛy. ");
INSERT INTO yns_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bàmbɔɔn bàsii naa ntɔn bɔ̈ɔ̈n a ngim làkälà a Yudasi, undiir awun Yɛsu kun'swɛŋ nde naa nde ukyen mukàsom indiir byàkäl mfun ntɔn un'kyɔm, itàkal naa mupà an'kab akà aŋàlàmbwà. ");
INSERT INTO yns_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pa kàwɛl Yudasi itiir a làmpà, nde kàtoo agyägyä. Làpib làkäl aŋàbwà. ");
INSERT INTO yns_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Apan, ungö a ntoo a Yudasi, Yɛsu kàtɛn naa: « Apanà, làkoo a Mwan a mbuur lan'mɛnà, làkoo a Nzam sye lan'mɛnà amu nde. ");
INSERT INTO yns_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32"," Isàkal naa làkoo a Nzam lan'mɛnà amu nde,  itaan a mbɔɔn tɛy, Nzam sye asàmɛɛy làkoo a Mwan amu nde ŋakwo. ");
INSERT INTO yns_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Baan amɛ, mɛ in'fàsaal anki anà taaŋ mbɔɔn mukal anà bɛ. Bɛ, bɛ làkyer asan'leŋ, asànaa kàtɛn mɛ a amfum a Ayudà: \"bɛ, bɛ làkwo anki muyà u mper ayà in'kyà mɛ\", mɛ in'tɛn a bɛ sye apanà. ");
INSERT INTO yns_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mɛ amàlapà nswɛɛŋ akün: làkäl anà ukwen bɛ a bɛ. Asànaa kàlakwen mɛ, wɛy bɛ sye làkäl anà ukwen bɛ a bɛ. ");
INSERT INTO yns_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Isàkal naa bɛ lan'kwen bɛ a bɛ, apan, baar banswà bàsàyöb naa bɛ làbà alɔŋki amɛ. » ");
INSERT INTO yns_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simɔn Petɔlà kàfuul Yɛsu naa: « Mwol, ngye ken akyà? » Yɛsu kun'fuur naa: « Apanà, ngye akwo anki muyà mper in'kyà mɛ, wɛɛ ngye asan'lab ungöngö. » ");
INSERT INTO yns_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petɔlà naa: « Mwol, ntɔn nkye mpa in'kwo mɛ muyalab apanà? Mɛ, mɛ an'kyey mupà mɔ̈ɔ̈ amɛ ntɔn ngye! » ");
INSERT INTO yns_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yɛsu naa: « Akɔɔb mɔ̈ɔ̈ angye ntɔn mɛ! Ndandaa, ndandaa, mɛ akyään, nkɔɔ mwɛy uyàtàkal aŋàbel anki, ayan'tɔn ngye mbalà tär. » ");
INSERT INTO yns_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yɛsu kan'tɛn naa: « Wɛy mpem abɛ ikɔ̈ɔ̈n akyɛɛr. Làsi làkwikilà amu Nzam, làsi làkwinkilà sye amu mɛ. ");
INSERT INTO yns_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","U ndwà a Taaràmɛ ikal byà mbɔɔn. Kya ilàkɔɔn akal abwɛy, mɛ in'làlakyään anki: Mɛ amàkàlalɔ̈ɔ̈n ikal. ");
INSERT INTO yns_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Umpal in'sàkyà mɛ mukàlalɔ̈ɔ̈n ikal, mɛ insàfyefurà muyàlawal, ntɔn ikal in'wà mɛ, bɛ sye làkäl paa. ");
INSERT INTO yns_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mɛ, ntsü in'kyà mɛ, bɛ làkyàyöb mbwo. » ");
INSERT INTO yns_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tuma kàtɛn a nde naa: « Mwol, bi iyöb anki mper akyà ngye. Bi ban'kwo muyöb aben mbwo a ya? » ");
INSERT INTO yns_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yɛsu kun'fuur naa: « Mɛ, mɛ in'wà mbwo, ndandaa anà mɔ̈ɔ̈. Mbuur ukwo anki mukyà akà Taa ukɔɔn alyaaŋ u mbwo amɛ. ");
INSERT INTO yns_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ilàkal naa bɛ lan'yöb, bɛ làlàyöb sye Taaràmɛ. Fà apanà, bɛ làmun'yöb, bɛ làmun'man. » ");
INSERT INTO yns_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo kàtɛn a nde naa: « Mwol, iswɛŋ Taa, waa ya ikwo akà bi. » ");
INSERT INTO yns_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yɛsu kun'fuur naa: « Filipo, mɛ an'kal anà bɛ taaŋ mbɔɔn, wɛɛ ngye ŋàtan'yöb anki? Mbuur kàman'man, kan'man Taa. Ntɔn nkye an'tɛn ngye naa: \"Iswɛŋ Taa\"? ");
INSERT INTO yns_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Làsi làkwikilà naa mɛ in'wà amu Taa, naa nde wà amu mɛ. Ndaa in'fàtɛn mɛ a bɛ banswà, kà mɛ ŋakwo in'fàbɔn anki, Taa awà amu mɛ afàkyer isal ande ŋakwo. ");
INSERT INTO yns_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Làsi làkwikilà naa mɛ in'wà amu Taa, naa Taa wà amu mɛ. Naa tɛy, làsi làkwikilà ntɔn isal abi. ");
INSERT INTO yns_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ndandaa, ndandaa, mɛ alàkyään: mbuur awe anà làkwikilà amu mɛ, nde sye, nde asàkyer isal in'fàkyer mɛ. Nde asàkyer byàŋàsöön, ntɔn mɛ in'wàmukyà akà Taa. ");
INSERT INTO yns_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Undiir wanswà làsàlɔm bɛ kà ikɔb amɛ, mɛ in'kyer asàkyer wa, ntɔn Taa uwɛl làkoo amu Mwan. ");
INSERT INTO yns_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Isàkal naa bɛ lan'lɔm undiir mwɛy kà ikɔb amɛ, mɛ, mɛ in'kyer asàkyer wa. ");
INSERT INTO yns_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","« Isàkal naa bɛ làman'kwen, bɛ làsàsyääl nswɛɛŋ amɛ. ");
INSERT INTO yns_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Waa mɛ, mɛ in'sàbɔɔn Taa, waa nde usàlatööm un'lɛɛl asin ntɔn nde ukäl anà bɛ ilä byanswà: ");
INSERT INTO yns_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Dweelà a ndandaa mpa ban'kwo baar a mɛɛn muwal, ntɔn ba bun'manà anki, ba bun'yöb anki. Wɛɛ bɛ, bɛ làkyun'yöb, ntɔn nde wà apà bɛ, anà nde asakalà amu bɛ mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mɛ in'sàlawɛy anki asànaa itii, mɛ in'kyer asàfyefurà akà bɛ. ");
INSERT INTO yns_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yan'saal ikikye, baar a mɛɛn bàsan'man anki, wɛɛ bɛ, bɛ làkyer asan'man ntɔn mɛ in'wà wàmɔ̈ɔ̈ anà bɛ, bɛ làsàkal bàmɔ̈ɔ̈ sye. ");
INSERT INTO yns_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kà ilä akin, bɛ làsàyöb naa mɛ in'wà amu Taaràmɛ, naa bɛ làbà amu mɛ anà mɛ in'wà amu bɛ. ");
INSERT INTO yns_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","« Mbuur awe anà nswɛɛŋ amɛ anà afàsyääl ya, wawun mbuur afan'kwen. Kyeka mbuur afan'kwen, Taa asàkyer un'kwen, mɛ sye in'kyer asun'kwen, waa mɛ ŋakwo in'sàmɛnà akà nde. » ");
INSERT INTO yns_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudasi - kà Yudas mwan a Isikalyɔt anki - kun'fuul naa: « Mwol, ya yà aben naa ngye akyer asyemɛɛy akà bi, wɛɛ kà akà baar a mɛɛn mà anki? » ");
INSERT INTO yns_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yɛsu kun'fuur naa: « Isàkal naa mbuur mwɛy kàman'kwen, nde asàkaar ndaa amɛ, Taaràmɛ akyer asun'kwen. Bi isàyà akà nde, waa isàbwaay amu nde. ");
INSERT INTO yns_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mbuur mpa kan'kwen, ufàkyey anki ndaa amɛ. Ndaa lan'wem bɛ yi, kàyan'fà akà mɛ anki, wɛɛ yà Taa mbuur kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Indiir abi, mɛ bya amàlakyään utaaŋ in'wà mɛ anà bɛ. ");
INSERT INTO yns_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dweelà In'kyɛɛl, un'lɛɛl, usàtɔm Taa kà ikɔb amɛ, nde asàlalɔŋ indiir byanswà, waa usàlayɔɔb ndaa yanswà kàtɛn mɛ a bɛ. ");
INSERT INTO yns_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","« Mɛ amàsàlawɛy duu, mɛ amàlapà duu amɛ. Mɛ la alapà anki asànaa bàfàpà baar a mɛɛn. Wɛy mpem a bɛ ikɔ̈ɔ̈n akyɛɛr, ikɔ̈ɔ̈n atɛɛr. ");
INSERT INTO yns_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bɛ làkyàwem, mɛ kàtɛn a bɛ naa: \"Mɛ an'kyà anà mɛ in'kyer asàfyefurà akà bɛ\". Yàlàkal naa bɛ làfàkyer an'kwen, bɛ làlàkal unsà un'sak ntɔn in'kyà mɛ akà Taa, ntɔn Taa kàman'söön. ");
INSERT INTO yns_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mɛ amàlawey indiir abi apanà, kusà a bya muyà, ntɔn umpal isàyà bya, waa bɛ làsàsà làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mɛ in'sàfàyääm anki mbɔɔn anà bɛ, ntɔn mfum a mɛɛn mà wàmuyà. Itàkal abun, nde ikɔ̈b mwɛy kyatɛy udu a mɛ, ");
INSERT INTO yns_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","wɛɛ, ntɔn naa mɛɛn màyöb naa mɛ in'kwen Taa, anà mɛ in'fàkyer nswɛɛŋ kan'pɛ Taa. Làmbarà, tsweenà! ");
INSERT INTO yns_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","« Mɛ, mɛ in'wà un'te a vin a ndandaa, Taaràmɛ wà ŋawa. ");
INSERT INTO yns_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nde afàtsul kɔkà lanswà alà amu mɛ anà mpa làfàtwà, wɛɛ nde afàsaal la akwà làfàtwà, ntɔn la làbör mbɛŋ asin mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Bɛ, bɛ làbà aŋàpɔŋà itaan ntɔn ndaa kàlakyään mɛ. ");
INSERT INTO yns_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Làkäl amu mɛ, asànaa in'wà mɛ amu bɛ. Akà kɔkà làmwɛy làkwe anki mubɔr mbɛŋ la ŋakwo isàkal naa la kà là aŋànääm anki a mbiim a un'te, itàkal bɛ sye, bɛ làkwo anki mubɔr mbɛŋ, isàkal naa bɛ, bɛ làbà anki amu mɛ. ");
INSERT INTO yns_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mɛ, mɛ in'wà mbiim a un'te a vin, bɛ, bɛ làbà an'kɔkà. Mbuur awà amu mɛ, anà mɛ amu nde, nde afàbɔr mbɛŋ mbɔɔn. Ntɔn bɛ, bɛ làkwe anki mukyer akà undiir mwɛy ukɔɔn mɛ. ");
INSERT INTO yns_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mbuur mpa awà amu mɛ, nde wàŋàpiy u nsà, asànaa kɔkà, laa uyɔm nde. An'kɔkà aŋàyɔm bàkyer afàköŋà, bàtɔɔm u mbaa, waa ma ikuŋà. ");
INSERT INTO yns_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Isàkal naa bɛ, bɛ làbà amu mɛ, ndaa amɛ sye yà amu bɛ, bɛ làsàlɔm undiir wanswà làsàkwen bɛ, bɛ làsàwal wa. ");
INSERT INTO yns_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ndaa ifàpà Taaràmɛ làkoo yà naa bɛ làbɔ̈r mbɛŋ mbɔɔn, waa bɛ làsàkal alɔŋki amɛ. ");
INSERT INTO yns_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Abun, asànaa kan'kwen Taa, mɛ sye amàlakwen. Làkäl uboo a ukwen amɛ. ");
INSERT INTO yns_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Isàkal naa bɛ làfàsyääl nswɛɛŋ amɛ, bɛ làbà uboo a ukwen amɛ, asànaa kàkwey mɛ nswɛɛŋ a Taaràmɛ, mɛ in'wà uboo a ukwen ande. » ");
INSERT INTO yns_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","« An'tɛn mɛ a bɛ abà, ntɔn un'sak amɛ ukäl uboo abɛ, anà wa sye ukäl wàŋàkwo. ");
INSERT INTO yns_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Le nswɛɛŋ amɛ ayi: làkwen bɛ a bɛ asànaa in'fàlakwen mɛ. ");
INSERT INTO yns_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kà we anà mbuur mwɛy anki awe anà ukwen a kölàköl isàkɔɔn akal asànaa mukɔɔb mɔ̈ɔ̈ ande ntɔn asam ande. ");
INSERT INTO yns_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bɛ làbasam amɛ isàkal naa bɛ làfàkyer indiir in'fàlàswaŋ mɛ. ");
INSERT INTO yns_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mɛ alàbel anki asyääl, ntɔn un'syääl uyöb anki ayufàkyer nkum ande. Wɛɛ mɛ, mɛ alabel asam, ntɔn ndaa yanswà kàwem mɛ akà Taaràmɛ, mɛ ya akyàlaswaŋ. ");
INSERT INTO yns_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kà bɛ anki lan'sɔ̈ɔ̈l, mɛ kàlasɔ̈ɔ̈l, mɛ kàlasi ntɔn bɛ làkyen, làbör mbɛŋ, waa mbɛŋ abɛ ilam. Abun, undiir wanswà làsàlɔm bɛ akà Taa kikɔb amɛ, nde akyer asàlapà wa. ");
INSERT INTO yns_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Undiir alàswaŋ mɛ awà: làkwen bɛ a bɛ. » ");
INSERT INTO yns_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","« Isàkal naa mɛɛn mà màmàlayiiŋ, làyöb naa mɛ in'wà mbuur atàtwɛb kàyiiŋ ma. ");
INSERT INTO yns_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ilàkal naa bɛ làkäl baar a mɛɛn, mɛɛn ikyer alàlakwen ntɔn bɛ làbà baar ama. Wɛɛ bɛ kà làbà baar ande anki: ntɔn kàlasi mɛ ukɔl, undiir awun mɛɛn màlayiiŋ ma. ");
INSERT INTO yns_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Làyɔbà ndaa kàlakyään mɛ: \"Un'lɔŋki ukwe anki ulyaŋ un'lɔɔŋ ande.\" Isàkal naa ba mɛ ban'mɛɛy nkwaaŋ, ba bɛ sye bàsàlamɛɛy nkwaaŋ. Isàkal naa ba bàkäär ndaa amɛ, ba bàsàkaar sye yàbɛ. ");
INSERT INTO yns_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Wɛɛ indiir abi byanswà ba bàsàlakyer ntɔn ikɔb amɛ, ntɔn ba bàyöb anki mbuur kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ilàkal naa mɛ in'kɔ̈ɔ̈n ayà anà in'kɔ̈ɔ̈n akakyään, ba bàlàkal anki anà man'be. Wɛɛ apanà, ba undiir afàkur watɛy ntɔn man'be aba. ");
INSERT INTO yns_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mbuur kàman'yiiŋ, nde kan'yiiŋ sye Taaràmɛ. ");
INSERT INTO yns_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ilàkal naa mɛ in'kɔ̈ɔ̈n akàkyer isal abi uboboo a ba, isal mpa kàkwe mbuur asin mukyer, ba bàlàkal anki anà man'be. Apanà ba bàkyàman bya, wɛɛ ba bàmufiyiiŋ, mɛ anà Taaràmɛ. ");
INSERT INTO yns_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wɛɛ ya yà ntɔn ndaa bàsön uboo un'kɔɔn aba ikwe: \"Ba ban'yiiŋ abunàbun.\" » ");
INSERT INTO yns_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","« Mpal usàyà un'lɛɛl in'sàlatööm mɛ kà ikɔb a Taa, Dweelà a ndandaa lan'fà akà Taa, nde asan'tɛɛl imbäl. ");
INSERT INTO yns_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Anà bɛ sye, bɛ làsan'tɛɛl imbäl, ntɔn bɛ làbà anà mɛ fà nsɛmà. » ");
INSERT INTO yns_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","« Kàlakyään mɛ indiir abi, ntɔn bɛ làkɔ̈ɔ̈n abwiy làkwikilà abɛ. ");
INSERT INTO yns_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bàkyer asàlaböŋ u ndwà a nköŋ a Ayudà. Yumwɛy ayi: taaŋ làmuyà, mbuur asàladwa asàsi naa nde wàmupà ibɔɔn akà Nzam. ");
INSERT INTO yns_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bàsàkyer ba abà, ntɔn ba bàyöb anki itàkal Taa, itàkal mɛ. ");
INSERT INTO yns_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Wɛɛ kàlayäm mɛ indiir abi, ntɔn umpal làsàkwo taaŋ, bɛ, bɛ làsàyɔbà naa mɛ, mɛ kàkyàlayäm ya. « Mɛɛ ya kàlasam anki fà nsɛmà, ntɔn mɛ kàkälà anà bɛ. ");
INSERT INTO yns_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Apanà, mɛ in'wàmukyà akà mbuur kan'töm, wɛɛ akà mwɛy uboo a bɛ kan'fuul anki naa: \"Ngye ken akyà?\" ");
INSERT INTO yns_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wɛɛ, ntɔn amàlasam mɛ abà, undiir awun mpem abɛ yan'yɔl ya a ngyɛb. ");
INSERT INTO yns_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mpalabà, mɛ amàlasam ubwaŋàbwaŋ: yan'söön mfun akà bɛ naa mɛ, mɛ in'kyen. Wɛɛ kya mɛ impàkyà anki, un'lɛɛl akwà alàyà mukàlabay, uyàfàyà anki akà bɛ. Wɛɛ isàkal naa mɛ an'kyà, mɛ in'kyer asàlatööm awà. ");
INSERT INTO yns_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Waa mpal usàyà nde, nde asàswaŋ ubwaŋàbwaŋ muyöb man'be aba, balàbal anà nsaŋ a Nzam. ");
INSERT INTO yns_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","U ndaa iler man'be, ntɔn ba bàfàsà anki làkwikilà amu mɛ, ");
INSERT INTO yns_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","u ndaa iler balàbal, ntɔn mɛ in'kyà akà Taa anà bɛ làfàsan'man anki, ");
INSERT INTO yns_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","u ndaa iler nsaŋ, mfum afàyaal mɛɛn bàyun'tsüül nsaŋ. » ");
INSERT INTO yns_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","« Mɛ, mɛ in'we anà indiir mbɔɔn mukàlasam, wɛɛ papanà bɛ làkwo anki mukaar bya u mpem abɛ. ");
INSERT INTO yns_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Utaaŋ usàyà Dweelà a ndandaa, nde asàlatwaal unsà ndandaa yanswà. Ntɔn nde usàtɛn anki kà ukwen ande ŋakwo, nde asàtɛn ndaa yanswà usàwem nde anà asàkyään ndaa yanswà isàyà. ");
INSERT INTO yns_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nde asan'sà làkoo, ntɔn nde asàwal ndaa amɛ, waa usàlakyään ya. ");
INSERT INTO yns_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Indiir byanswà abyà byàtaa, bya sye byà byàmɛ. Undiir awun in'tɛn mɛ naa Dweelà asàwal unsà byàmɛ, waa usàlakyään bya. ");
INSERT INTO yns_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","« Itaan a mbɔɔn tɛy, bɛ làsàfan'man anki, apan sye, ungö a taaŋ ikikye, bɛ làkyer asàfan'man. » ");
INSERT INTO yns_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Apan, amwɛy uboo a alɔŋki ande bàtɛɛnà ba a ba naa: « Ininà nde ukwen mutɛn a bi naa: \"Itaan a mbɔɔn tɛy, bɛ làfàsan'man anki, apan sye, ungö a taaŋ ikikye, làkyer afàsan'man\", anà sye: \"Ntɔn mɛ in'kyà akà Taa\"? ");
INSERT INTO yns_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","\"Taaŋ ikikye\" utɛɛnà nde ikaswaŋà aben? Bi ikayöbà anki naa ininà nde utɛɛnà! » ");
INSERT INTO yns_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yɛsu kàyöb nde naa ba bàkwen mukun'fuul, waa kàtɛn a ba naa: « Bɛ làbàmuleŋ uboo a bɛ muyöb naa mɛ ininà in'kwen mutɛn: \"Itaan a mbɔɔn tɛy, bɛ làfàsan'man anki, apan sye, ungö a taaŋ ikikye, bɛ làkyer afàsan'man.\" ");
INSERT INTO yns_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ndandaa, ndandaa, mɛ alàkyään, bɛ, bɛ làkyer asàlel anà làsàsà un'saabà, mpal isàkal mɛɛn musaŋ. Bɛ làsàkal u ngyɛb, wɛɛ ngyɛb abɛ isàbulà un'sak. ");
INSERT INTO yns_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Umpal ufàkal un'kaar anà in'swaŋ, mpem ande ifàkal udu udu ntɔn taaŋ ande lan'kwo. Wɛɛ isàkal naa nde kan'bɔr, nde afàdiimà usaay abà banswà, waa usaŋ ntɔn kan'bɔr nde mwan. ");
INSERT INTO yns_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lalan ŋàbawà bɛ làbà u ngyɛb mbɔɔn. Wɛɛ mɛ, mɛ in'kyer afàsàlaman, mpem abɛ isàkal unsà un'sak, mbuur asàladuum wa watɛy. ");
INSERT INTO yns_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","« Abun, ilä akin, akà undiir mwɛy bɛ làfàsan'fuul anki. Ndandaa, ndandaa, mɛ alàkyään, undiir wanswà làsàlɔm bɛ akà Taa, nde akyer asàlapà wa kà ikɔb amɛ. ");
INSERT INTO yns_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tii apanà, akà undiir mwɛy bɛ ŋàtàlɔm anki kà ikɔb amɛ. Làlɔ̈m, waa bɛ làsàwal, ntɔn un'sak abɛ ukàl wàŋàkwo. » ");
INSERT INTO yns_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","« Indiir abi mɛ kàtɛn a bɛ unsà nsim. Taaŋ làmuyà, alà mpa in'fàsàlasam mɛ abà, wɛɛ alà in'sàlakyään mɛ kà imɛɛy ndaa iler Taa. ");
INSERT INTO yns_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ilä akin, bɛ làsàlɔm akà Taa kà ikɔb amɛ, mɛ in'tɛn anki naa mɛ in'sàlalɔ̈ɔ̈m akà Taa, ");
INSERT INTO yns_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ntɔn Taa akyàlakwen nde ŋakwo, ntɔn lan'kwen bɛ anà làsi bɛ làkwikilà naa mɛ kàfü akà Nzam. ");
INSERT INTO yns_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mɛ, mɛ kàtoo amu Taa, waa mɛ kàyi u mɛɛn. Apanà, mɛ in'wàmulwomà u mɛɛn anà mufurà akà Taa. » ");
INSERT INTO yns_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Alɔŋki bàtɛn a nde naa: « Le, apanà ngye an'tɛn kà imɛɛy, ukɔɔn asyääl nsim. ");
INSERT INTO yns_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Apanà bi kan'yöb naa ngye ayöb indiir byanswà, anà ngye mfun yatɛy naa mbuur kafuul ndaa. Undiir awun waa bi kan'sà làkwikilà naa ngye an'fà akà Nzam. » ");
INSERT INTO yns_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yɛsu kafuur naa: « Nkye apanà bɛ lan'sà làkwikilà? ");
INSERT INTO yns_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Le, taaŋ làmuyà, apanà la lan'kwo, alà làsàtà bɛ upay, mbuur mbuur a mbwo ande, làsan'wɛy bɛ aŋàyen. Wɛɛ mɛ kà in'wà aŋàyen anki, ntɔn Taa wà anà mɛ. ");
INSERT INTO yns_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Amàlakyään mɛ indiir abi ntɔn bɛ làkäl anà duu amu mɛ. Bɛ làbà uboo a lingyoomà u mɛɛn mà. Wɛɛ làkäl anà un'kanà, mɛ, mɛ mɛɛn akyun'wal iböŋ! » ");
INSERT INTO yns_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ungö kàtɛn nde abà, Yɛsu kàler u du, waa kàtɛn naa: « Taa, taaŋ lan'kwo, mɛɛy làkoo a Mwan angye, ntɔn nde sye umɛɛy làkoo angye. ");
INSERT INTO yns_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ngye kun'pɛ ikɔ̈b udu a baar banswà, ntɔn nde upɛ mɔ̈ɔ̈ a mbul a in'tye akà baar kun'pɛ ngye. ");
INSERT INTO yns_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Wɛɛ mɔ̈ɔ̈ a mbul a in'tye wà naa ba bàyöb ngye mpɛl, Nzam a ndandaa, anà bàyöb Yɛsu Klistɔ, awà kàtöm ngye. ");
INSERT INTO yns_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mɛ, mɛ kàkyapà làkoo u mɛɛn. Mɛ akyàmay isal akyan'pɛ ngye mukyer. ");
INSERT INTO yns_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Apanà, ngye, Taa, mpɛ làkoo akwà kàkäl mɛ alà akà ngye, kusà mɛɛn mukal. ");
INSERT INTO yns_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mɛ, mɛ ngye akyamɛɛy akà baar akwà kàtwey ngye u mɛɛn ntɔn mukan'pà. Ba bàkäl bàngye, waa ngye kan'mpɛ abà, waa ba bàkäär ndaa angye. ");
INSERT INTO yns_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Apanà, ba ban'yöb naa indiir byanswà kan'mpɛ ngye, byan'fà akà ngye. ");
INSERT INTO yns_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ntɔn mɛ ba kapɛ ndaa kan'mpɛ ngye. Ba ya bàkyàwal. Ba bàkyàyöb ndandaa naa mɛ kàtoo amu ngye, waa ba bàsi làkwikilà naa ngye kan'töm. » ");
INSERT INTO yns_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","« Ngyamàkà amɛ yà ntɔn ba. Mɛ in'yamà anki ntɔn mɛɛn, wɛɛ ntɔn baar kan'pɛ ngye, ntɔn ba bà bàngye. ");
INSERT INTO yns_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Indiir byanswà in'wà mɛ abyà, byà byàngye. Indiir awà ngye abyà, byà byàmɛ. Mɛ kàwɛl làkoo amu ba. ");
INSERT INTO yns_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mɛ in'fàkal anki u mɛɛn, wɛɛ ba, ba bà u mɛɛn. Mɛ in'wàmukyà akà ngye. Taa In'kyɛɛl, aler unsà ikɔ̈b a ikɔb angye, ikɔ̈b akwà kan'pɛ ngye, ntɔn ba bàkäl mwɛy asànaa ibà bi mwɛy. ");
INSERT INTO yns_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Umpal kàkäl mɛ anà ba, mɛ, mɛ ba kàfalerà kà ikɔ̈b a ikɔb angye kan'pɛ ngye. Mɛ ba afàkyer atii, lalan, akà umwɛy kàdiimà anki, nà mwan aŋàdiimà mbwo, ntɔn Ndaa Aŋàsɔn ikwe. ");
INSERT INTO yns_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Apanà, mɛ in'kyà akà ngye. Indiir abi mɛ an'tɛn umpal in'wà mɛ u mɛɛn, ntɔn ba bàkäl anà un'sak amɛ u mpem aba, un'sak wàŋàkwo. ");
INSERT INTO yns_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mɛ, mɛ kapɛ ndaa angye, baar a mɛɛn bàkyer ayiiŋ, ntɔn ba kà bà baar a mɛɛn anki, asànaa mɛ mpa in'wà mɛ wàmɛɛn. ");
INSERT INTO yns_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mɛ, mɛ in'löm anki naa ngye alwom u mɛɛn, wɛɛ mukatii ntɔn Ŋube. ");
INSERT INTO yns_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ba kà baar a mɛɛn anki, asànaa mpa in'wà mɛ mbuur a mɛɛn. ");
INSERT INTO yns_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Asi ukɔl ntɔn ngye u mbwo a ndandaa: ndaa angye yà ndandaa. ");
INSERT INTO yns_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Asànaa kan'töm ngye u mɛɛn, mɛ sye ba amatɔm u mɛɛn. ");
INSERT INTO yns_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mɛ an'sà ndür amɛ ŋakwo akà ngye ntɔn ba, ntɔn ba sye bàkäl bàngye ndandaa. » ");
INSERT INTO yns_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","« Mɛ in'yamà anki ntɔn ba mpɛl, wɛɛ sye ntɔn baar abà bàsàsà làkwikilà aba amu mɛ u mbwo a an'lɔɔŋ aba. ");
INSERT INTO yns_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Wɛy ba banswà bàkäl mwɛy, asànaa ngye, Taa, ngye awà amu mɛ anà mɛ in'wà amu ngye, wɛy ba sye bàkäl mwɛy amu bi, ntɔn mɛɛn màyöb naa ngye kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mɛ, mɛ ba akyapà làkoo kan'pɛ ngye, ntɔn ba bàkäl mwɛy, asànaa naa bi ibà bi mwɛy: ");
INSERT INTO yns_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","mɛ amu ba, ngye amu mɛ, ntɔn ba bàkäl bàŋakwo mwɛy, waa mɛɛn màyöb naa ngye kan'töm, naa ngye ba akyakwen asànaa kan'kwen ngye. ");
INSERT INTO yns_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Taa, mɛ in'kwen naa ikal in'wà mɛ, ba sye bàkäl paa, anà ba bàmɛn làkoo kan'pɛ ngye kusà a nkyeer a mɛɛn. ");
INSERT INTO yns_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taa a balàbal, mpal mpa mayöb mɛɛn, wɛɛ mɛ, mɛ kàkyayöb, ba abà bàkyàyöb naa ngye kan'töm. ");
INSERT INTO yns_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mɛ kàkyer naa ba bàyöb ikɔb angye, mɛ in'yàfàkyer naa ba bàyöb kya, ntɔn ukwen kan'kwen ngye bàkäl amu ba, anà mɛ in'käl amu ba. » ");
INSERT INTO yns_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ungö mutɛn abà, Yɛsu kàkyen anà alɔŋki ande u sim a un'lwɛy bàfàbel Sɛdrɔn. Akun làkäl anà làpaŋ làmwɛy, waa kàkàbilà kwo anà alɔŋki ande. ");
INSERT INTO yns_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kyekà Yudasi, mbuur kun'yälà, kàkyàyöb ikal aki, ntɔn Yɛsu kàfakyeenà kwo mbalà mbɔɔn anà alɔŋki ande. ");
INSERT INTO yns_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nde kàkäl kusà a un'lwaŋ a aŋità bun'pɛ andweer a angaŋ anà Amfarisi, waa kàbilà u làpaŋ anà isüü a mbaa, anà mwinà anà an'tà. ");
INSERT INTO yns_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Apan, Yɛsu kàyöb indiir byanswà byun'yeel, nde kàkyen mper akà ba, anà kafuul naa: « Nà bɛ làyileŋ? » ");
INSERT INTO yns_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ba bun'fuur naa: « Yɛsu, un'nsi Nasàlɛr. » Yɛsu kàtɛn a ba naa: « Mɛ awà. » Kyekà, uboo a ba, Yudasi, mbuur kun'yälà, kàkäl mwo. ");
INSERT INTO yns_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Umpal kàtɛn Yɛsu a ba naa: « Mɛ awà », ba bàfurà lingö, waa bàbü u mɛɛn. ");
INSERT INTO yns_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yɛsu kàfafuul naa: « Nà bɛ làyileŋ? » Ba naa: « Yɛsu, un'nsi Nasàlɛr. » ");
INSERT INTO yns_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yɛsu kafuur naa: « Mɛ in'kyàtɛn a bɛ, mɛ awà. Isàkal naa bɛ mɛ làyileŋ, abun lawɛy baar bumwɛy bà bàkyen kàba. » ");
INSERT INTO yns_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Abun yàlàkwo ndaa kàtɛn Yɛsu naa: « Uboo a baar kan'pɛ ngye, mɛ akà umwɛy kàpiy anki. » ");
INSERT INTO yns_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Apan, Simɔn Petɔlà kàkäl anà kɔm, nde kàswam la kà inkwà, kàkäm la un'tsüüŋ a undweer a angaŋ, waa la lun'ywaaŋ tsü là ibaal. Un'tsüüŋ awà ikɔb ande kyàkäl Malkusu. ");
INSERT INTO yns_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Wɛɛ Yɛsu waa kàtɛn a Petɔlà naa: « Fuur kɔm angye uboo a inkwà a la. Nkye mɛ in'sànwà anki kɔɔb kan'pɛ Taa munwà? » ");
INSERT INTO yns_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Apan, iköŋ a aŋità anà mfum aba, anà aleer a amfum a Ayudà, bàkör Yɛsu, waa bun'läl in'siŋ. ");
INSERT INTO yns_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ba bàtun'syen akà An. Nde kàkäl ukwà a Kayifa, undweer a angaŋ u mbul awun. ");
INSERT INTO yns_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kyekà Kayifa awà, wà mbuur kàpɛ amfum a Ayudà lwɛŋ naa: « Yà mfun naa mbuur mwɛy ukü ntɔn un'sɛŋ a baar. » ");
INSERT INTO yns_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔn Petɔlà anà un'lɔŋki wumwɛy bàyilabà Yɛsu. Undweer a Angaŋ kàkyun'yöb un'lɔŋki awà. Nde kàbilà mbwo mwɛy anà Yɛsu u làpaŋ a undweer a angaŋ. ");
INSERT INTO yns_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Simɔn Petɔlà kàkäl u nsà, tsütsü a munàmbwo. Abun, un'lɔŋki awà kàyöb Undweer a Angaŋ, kàyàtoo nde, kàyäm a un'kaar kàkäl un'leer a munàmbwo, waa nde kàbiil Petɔlà. ");
INSERT INTO yns_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Apan, un'syääl a un'kaar, un'leer a munàmbwo, kàtɛn a Petɔlà naa: « Nkye ngye, ngye sye kawumwɛy anki uboo a alɔŋki a mbuur awunà? » Petɔlà kun'fuur naa: « Aay, kà mɛ anki. » ");
INSERT INTO yns_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Asyääl anà aleer bàyöbà böl a mbaa a an'kal, waa bàyörà ya, ntɔn mpye yàkyer akal. Petɔlà sye kàkäl paa muywar mbaa anà ba. ");
INSERT INTO yns_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Apan, un'dweer a angaŋ kàfuul Yɛsu unsà ndaa iler alɔŋki anà an'lɔɔŋ ande. ");
INSERT INTO yns_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yɛsu kun'fuur naa: « Mɛ, mɛ kàtɛɛnà kimɛɛy akà baar. Taaŋ lanswà, mɛ kàyilɔɔŋà u ndwà a nköŋ a Ayudà anà u ndwà a Nzam, ikal bàfàköŋ Ayudà banswà. Akundiir mwɛy wàŋàyee kàtɛn mɛ watɛy. ");
INSERT INTO yns_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ntɔn nkye an'fuulà ngye? Fuul baar bàwem ndaa kàtɛn mɛ, ba bàkyàyöb ubwaŋàbwaŋ ndaa kàtɛn mɛ! » ");
INSERT INTO yns_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Umwɛy uboo a aleer bàkäl paa, umpal kàwem nde mfuur a Yɛsu ayi, waa kun'käm mbar, anà mutɛn naa: « Nkye ngye undweer a angaŋ un'fuur abwɛy? » ");
INSERT INTO yns_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yɛsu kun'fuur naa: « Isàkal naa mɛ an'tɛn ube, swaŋ ba. Isàkal naa mɛ an'tɛn ubwaŋ, ntɔn nkye aman'kam ngye mbar? » ");
INSERT INTO yns_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Apan, An kun'töm wàŋàbäm in'siŋ akun'dweer a angaŋ Kayifa. ");
INSERT INTO yns_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Utaaŋ nsil alan, Simɔn Petɔlà kàkälà paa, wàmuywar mbaa. Ba bun'fuul naa: « Nkye ngye sye awumwɛy uboo a alɔŋki ande? » Petɔlà waa kàtön: « Ŋaa, kà mɛ anki. » ");
INSERT INTO yns_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Umwɛy uboo a asyääl a undweer a angaŋ, un'tɔŋ a mbuur awà kàywaaŋ Petɔlà tsü ande, kàtɛn naa: « Nkye mɛ kamɛn anki anà nde uboo a làpaŋ? » ");
INSERT INTO yns_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Wɛɛ Petɔlà waa kàfun'tɔn. Utaaŋ nsil alan, nkɔɔ mwɛy waa kàbel. ");
INSERT INTO yns_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Apan, ba bàsyen Yɛsu u ndwà a kuvɛrnɔ̈ɔ̈r fà ndwà a Kayifa. Yàkäl ututu. Baar bun'twäl bàkyer atɔn mubilà u ndwà a kuvɛrnɔ̈ɔ̈r, ntɔn mukɔɔn asà ndür aba làbiin anà ba bàdi Pak. ");
INSERT INTO yns_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Abun, kuvɛrnɔ̈ɔ̈r Pilatu kàyaman u nsà, waa kafuul naa: « Undiir nà lan'füün bɛ mbuur wà? » ");
INSERT INTO yns_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ba bun'fuur naa: « Ilàkal naa mbuur awà ukɔ̈ɔ̈n akyer ube, bi ilatwääl awà anki. » ");
INSERT INTO yns_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Abun, Pilatu kàtɛn a ba naa: « Lun'wɛl, lun'tsüül nsaŋ bɛ ŋakwo unsà un'kɔɔn abɛ. » Ba bun'fuur naa: « Bi ikɔ̈b mutsüül mbuur mbar a ukwà kyatɛy. » ");
INSERT INTO yns_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kyakin, yàkwe ndaa kàtɛn Yɛsu muswaŋ naa nde kàlàkwà aben. ");
INSERT INTO yns_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Apan, Pilatu kàfurà u ndwà, waa kàswɛŋ naa bun'twääl Yɛsu. Nde kun'fuul naa: « Nkye ngye, ngye awà mfum a Ayudà? » ");
INSERT INTO yns_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yɛsu kàfuur naa: « Nkye ngye an'tɛn unsà an'kyän angye ŋakwo lɛɛ baar asin bàmakyään ntɔn mɛ? » ");
INSERT INTO yns_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatu kàfuur naa: « Nkye mɛ, mɛ in'wà Un'yudà? Baar a nsi angye anà amfum a angaŋ bàmayälà akà mɛ! Ininà ngye an'kyer? » ");
INSERT INTO yns_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yɛsu kàfuur naa: « Imwol amɛ kà kyà mɛɛn mà tɛy. Ilàkal naa kya ikäl kyà mɛɛn mà, asyääl amɛ bàlàkyer an'nwään naa bàkɔɔn an'yälà akamfum a Ayudà. Ŋaa, imwol amɛ kà kyà mɛɛn mà anki. » ");
INSERT INTO yns_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Apan, Pilatu kàtɛn a nde naa: « Iswaŋà naa ngye awà mfum? » Yɛsu kun'fuur naa: « Ngye an'tɛn ngye ŋakwo naa mɛ in'wà mfum. Mɛ, bàkyer an'bɔr, waa mɛ kàyi u mɛɛn ntɔn mutà imbäl akà ndandaa. Mbuur wanswà awunsà ndandaa afàwem ndaa amɛ. » – ");
INSERT INTO yns_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatu kun'fuul naa: « Ndandaa ininà? » Ungö a ngɔk ayi, Pilatu kàfàkàman amfum a Ayudà u nsà, waa kàtɛn a ba naa: « Mɛ akà undiir in'mɛn anki kan'kwo mutsüül mbuur wà mbar a ukwà. ");
INSERT INTO yns_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Wɛɛ asànaa akyà kya ifà abɛ naa mɛ alàwɛɛy mbuur mwɛy kun'kyɔm a Pak, nkye bɛ làkyàkwen naa mɛ in'wɛy mfum a Ayudà? » ");
INSERT INTO yns_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Apan ba banswà bàfàsà in'kwɛŋ: « Ŋaa, kà nde tɛy, wɛɛ Banabasi! » Kyekà, Banabasi awà kàkäl un'dwää baar. ");
INSERT INTO yns_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Apan, Pilatu kàswɛŋ mutwal Yɛsu anà mukun'kam an'füm. ");
INSERT INTO yns_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aŋità bàtöŋ nkar a nsyeenà, waa bun'bwä ya kun'tswe. Ba bun'bwä sye kàzak a tsöö. ");
INSERT INTO yns_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ba bàsinà tsütsü apà nde, waa bàtɛɛnà naa: « Mfum a Ayudà, mbɔr angye! » Ba bun'kämà mbar. ");
INSERT INTO yns_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatu kàkyer afàtoo, waa kàtɛn a amfum a Ayudà naa: « Làler, mɛ in'kyer alatwääl awà u nsà: bɛ làkyer ayöb naa mɛ in'mɛn anki ube kan'kyer nde. » ");
INSERT INTO yns_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Abun, Yɛsu kàyàtoo wàŋàbwaar nkar a nsyeenà anà kàzak a tsöö. Pilatu kàtɛn a ba naa: « Le baal! » ");
INSERT INTO yns_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pa bun'mɛn andweer a angaŋ anà aleer, ba bàsi in'kwɛŋ: « Un'bɛɛrà u kulunsi! Un'bɛɛrà u kulunsi! » Pilatu kàtɛn a ba naa: « Lun'wɛl anà lun'bɛɛrà bɛ ŋakwo u kulunsi, wɛɛ akà mɛ, mɛ in'mɛn anki undiir kan'kwo mukun'tsüül mbar a ukwà. » ");
INSERT INTO yns_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Amfum a Ayudà bun'fuur naa: « Bi iwe anà un'kɔɔn, mulab un'kɔɔn awà, nde akyer akwà, ntɔn nde kàkyeyà uyɔl naa nde wà Mwan a Nzam. » ");
INSERT INTO yns_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Mpal kàwem Pilatu ndaa ayi, nde kàfàman bɔɔmà mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nde kàfurà u ndwà, waa kàfuul Yɛsu naa: « Ngye, ngye awà un'nsi nà? » Wɛɛ Yɛsu kun'fuur anki akundiir. ");
INSERT INTO yns_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Apan, Pilatu kàtɛn a nde naa: « Ngye an'tɔn mukan'pà mfuur? Nkye ngye ayöb anki naa mɛ, mɛ in'we anà ikɔ̈b mukawɛy itàkal mukabɛɛrà u kulunsi? » ");
INSERT INTO yns_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Wɛɛ Yɛsu kun'fuur naa: « Ngye ikɔ̈b alàkal akyà anki, ilàkal naa Nzam ukɔ̈ɔ̈n akapà kya. Undiir awun, mbuur awà kàman'yälà akà ngye, we anà man'be màŋàsöönà. » ");
INSERT INTO yns_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Fà apan, Pilatu kàleŋà mukun'wɛy. Wɛɛ amfum a Ayudà bàsi in'kwɛŋ: « Isàkal naa ngye amun'wɛy, ngye kawà un'sam a Sɛzar anki! Mbuur wanswà afàkyey uyɔl naa nde wà mfum, nde kan'kyey naa nde wà ŋankir a Sɛzar! » ");
INSERT INTO yns_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Mpal kàwem Pilatu ndaa ayi, nde kàsyen Yɛsu u nsà, kàbwaay u làbay a nsaŋ, kikal bàfàbel naa « Plase pavɛ » - unsà ɛbɛlyɔ naa « Ngabàtà ». ");
INSERT INTO yns_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kya kyàkäl ilä mulɔ̈ɔ̈n un'kyɔm a Pak u midi. Pilatu kàtɛn a Ayudà naa: « Le mfum abɛ! » ");
INSERT INTO yns_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wɛɛ ba bàsɛmà musà in'kwɛŋ: « Ukü! Ukü! Un'bɛɛrà u kulunsi! » Pilatu kàfàtɛn a ba naa: « Nkye mɛ in'bɛɛrà mfum abɛ u kulunsi? » Andweer a angaŋ bàfuur naa: « Bi mfum asin watɛy, Sɛzar mpɛl. » ");
INSERT INTO yns_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Apan Pilatu wa kapɛ awà ntɔn bun'bɛɛrà u kulunsi. Apan ba bàsyen Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yɛsu kàyisyeenà kulunsi ande, nde ŋakwo, nde kàtoo u nsà a bul ntɔn mukyà ikal akyà bàfàbel naa « Bɔl a un'tswe », unsà ɛbɛlyɔ bàfàbel « Ngɔlɔngɔta ». ");
INSERT INTO yns_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Akun ba bun'bɛɛrà u kulunsi anà baar, baar bɔ̈ɔ̈l: mwɛy u kɔɔ a ibaal, mwey u kɔɔ a ikaar, Yɛsu uboboo. ");
INSERT INTO yns_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatu kàsön isɔn udu a kilàbää, waa kàbɛɛrà kya udu a kulunsi. Kya kyàkäl aŋàsön naa: « Yɛsu un'nsi Nasàlɛr, mfum a Ayudà. » ");
INSERT INTO yns_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ayudà mbɔɔn bàtäŋà isɔn abi, ntɔn ikal bàbɛɛrà Yɛsu u kulunsi kyàkäl tsütsü a bul, anà isɔn bya sye bàsön unsà ibɛlyɔ, unsà ilatɛ anà unsà ingɛlɛki. ");
INSERT INTO yns_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Abun, andweer a angaŋ a Ayudà bàtɛn a Pilatu naa: « Twon an'sɔn naa \"mfum a Ayudà\", wɛɛ sɔn naa: \"mbuur wà kàkyey uyɔl naa nde kàkäl mfum a Ayudà.\" » ");
INSERT INTO yns_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatu kàfuur naa: « Ayan'sɔn mɛ, mɛ an'sɔn ya. » ");
INSERT INTO yns_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mpal ban'may aŋità mun'bɛɛrà Yɛsu u kulunsi, ba bàwɛl ipfɛy ande, bàsi bya an'kab an'nà, mbuur mbuur kàwɛl kab làmwɛy. Làsàsal nà kàzak ande. La làkäl anki làŋàtsum: ipfɛy mwɛy fà du tii u ngyɛl. ");
INSERT INTO yns_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aŋità bàtɛɛnà ba a ba naa: « Wɛy bi ikɔ̈ɔ̈n akaam kya, wɛɛ bi itɔɔm löb, ntɔn muyöb naa nà awal kya. » Ntɔn naa Ndaa Aŋàsɔn ikwe: « Ba bàsi ipfɛy amɛ an'kab anà ba bàtɔɔm löb ntɔn kàzak amɛ. » Byabi indiir bàkyer aŋità. ");
INSERT INTO yns_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Baar bàkäl tsütsü a kulunsi anà Yɛsu babà: ngwän, mpääŋ a ngwän, Màlye un'kyay a Kɔlɔpasi, anà Màlye un'nsi Makdalà. ");
INSERT INTO yns_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yɛsu kàmɛn nde ngwän anà un'lɔŋki kàfakweenà nde ukɔl a nde, nde kàtɛn a ngwän naa: « Un'kaar, le mwan angye wàbaal. » ");
INSERT INTO yns_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ungö waa kàtɛn a un'lɔŋki naa: « Le ngwa. » Fà apan, un'lɔŋki kun'wɛl u ndwà ande. ");
INSERT INTO yns_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ungö a ndaa ayi, nde kàyöb naa indiir byanswà byakyàkwo itaan, ntɔn Ndaa Aŋàsɔn ikwe, Yɛsu kàtɛn naa: « Mfwää yàman'kaar. » ");
INSERT INTO yns_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Paa làkäl anà làbuuŋ aŋàyɔl a vin a nyän, ba bàbäm ikaam a ipfɛy aŋànwɛmà unsà vin a nyän alan u nswɛŋ a kɔkà a kite bàfàbel naa isɔp, waa bun'bämà kya u mun. ");
INSERT INTO yns_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pa kànü nde vin a nyän alà, nde kàtɛn naa: « Yanswà yan'kwo! » Abun, nde kàtsülà un'tswe, waa kàfuur mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kya kyàkäl ilä ayöŋà un'kyɔm a saba. Ntɔn mukɔɔn awɛy ndom isinakalà u kulunsi ilä a saba, ntɔn kya kyàkäl ilä a kölàköl, amfum a Ayudà bàkàlɔm mbwo akà Pilatu ntɔn bàbɔ̈ɔ̈l ya in'kɔl anà bàlwom ya. ");
INSERT INTO yns_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Apan, aŋità bàbɔ̈ɔ̈l in'kɔl a mbuur atàtwɛb anà myà mbuur wàyweel bàbɛɛrà u kulunsi mbwo mwɛy a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mpal bàkɔlà ba apà Yɛsu, ba bun'mɛn wàŋàkwà, waa mpa bun'bɔ̈ɔ̈l in'kɔl. ");
INSERT INTO yns_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Wɛɛ umwɛy uboo a aŋità, kun'kül kwaŋ u bɛl a nsyäärà, apan sye an'kil anà an'dà waa màyàtoo. ");
INSERT INTO yns_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mbuur kàmɛn ya, kàtɛ imbäl. Imbäl ande kyà ndandaa. Nde, nde akyàyöb naa nde kan'tɛn ndandaa ntɔn bɛ sye làsi làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Abun, indiir abi byàyi ntɔn Ndaa Aŋàsɔn ikwe: « Bàsun'bɔɔl anki akun'kwo ande mwɛy. » ");
INSERT INTO yns_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ntsü yumwɛy, Ndaa Aŋàsɔn itɛn naa: « Ileer aba isàkal akà mbuur bàkül ba kwaŋ. » ");
INSERT INTO yns_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ungö a indiir abi, un'lɔŋki a Yɛsu mwɛy ikɔb ande Yɔsɛfi, un'nsi Alimatɛ, kàkyen akà Pilatu u nku, ntɔn bɔɔmà a Ayudà, mulɔm mbwo mulwom ndom a Yɛsu. Pilatu waa kàkyey. Abun, Yɔsɛfi kàkàlwom ya. ");
INSERT INTO yns_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nàkàdim sye, mbuur akwà kàkyen mukàman Yɛsu u mpib, kàtwäl isii an'kilɔ an'kwem an'tär mà may a usɔŋ mà mir àŋàtüüb anà alɔwɛ. ");
INSERT INTO yns_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ba bàbɔ̈ɔ̈l bàwɛl ndom a Yɛsu, bàläl ya ikaam a ipfɛy a linɔ, bàtyaŋ ya may a usɔŋ, asànaa awà ifà a Ayudà bàfàdyee ba akü aba. ");
INSERT INTO yns_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kikal bàbɛɛrà Yɛsu u kulunsi làkäl anà làpaŋ. Uboo a la màkäl anà an'dii akün, mpa amàŋàtàsà mbuur akikikye. ");
INSERT INTO yns_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Abun, ba Yɛsu bun'tɔ̈l kwo, ntɔn ngyööŋ a Ayudà anà an'dii sye màkäl tsütsü. ");
INSERT INTO yns_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ututu a ilä atàtwɛb kyà mpɔsà, u kilàpib, Màlye un'nsi Makdalà kàkyen an'dii, waa kàmɛn nkɔŋ yàŋàlwomà. ");
INSERT INTO yns_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Apan, nde kàwurà ntiin, kàkàman Simɔn Petɔlà anà un'lɔŋki kàfakweenà Yɛsu, waa kàtɛn a ba naa: « Mwol bàkyun'lwom kan'dii, bi iyöb anki naa bàmusà ken. » ");
INSERT INTO yns_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petɔlà anà un'lɔŋki wumwɛy waa bàkyen an'dii. ");
INSERT INTO yns_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ba bàbɔ̈ɔ̈l bàwurà ntiin, wɛɛ un'lɔŋki wumwɛy kàyiwurà aŋàlyaŋ Petɔlà, waa kàkàkɔlà mbuur atàtwɛb kan'dii. ");
INSERT INTO yns_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nde kànyee ntɔn muler, waa kàmɛn ikaam a ipfɛy a linɔ byàŋàtɔɔl u mɛɛn. Wɛɛ nde kàbilà anki uboo a an'dii. ");
INSERT INTO yns_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔn Petɔlà kàyun'labà nde, waa kàyàkɔlà sye. Nde kàbilà uboo a an'dii, waa kàmɛn ikaam a ipfɛy byàŋàtɔɔl u mɛɛn, ");
INSERT INTO yns_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","anà ipfɛy bàfwe un'tswe a Yɛsu. Kya kyàkäl anki ikal imwɛy anà ikaam a ipfɛy a linɔ, wɛɛ kya kyàkäl kyàŋàbwɛlà, kyàŋàtɔɔl ikal asin. ");
INSERT INTO yns_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Apan, un'lɔŋki akwà kàkàkɔlà kusà kan'dii waa kabilà sye. Nde waa kàmɛn, waa kàsi làkwikilà. ");
INSERT INTO yns_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ntɔn ba bàkäl aŋàtàyöb anki Ndaa Aŋàsɔn ayà itɛɛnà naa Yɛsu kàkyer alàwiyà uboo a akü. ");
INSERT INTO yns_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ungö apan, alɔŋki bàfurà ndwà aba. ");
INSERT INTO yns_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Màlye kàkäl u nsà, tsütsü a an'dii, wàmulelà. Umpal kàlelà nde, nde kànye ntɔn muler uboo a an'dii, ");
INSERT INTO yns_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","nde kàmɛn akyeey abɔ̈ɔ̈l bàkyàbwaar ipfɛy a pɛɛl, bàŋàbwaay kikal bàtɔ̈l ndom a Yɛsu, mwɛy ntsü a un'tswe, mwɛy ntsü a in'kɔl. ");
INSERT INTO yns_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Akyeey bun'fuul naa: « Un'kaar, ntɔn nkye alelà ngye? » Nde kafuur naa: « Mwol amɛ bàmun'lwom, mɛ in'yöb anki naa bun'si ken. » ");
INSERT INTO yns_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ungö mutɛn abà, nde kàler ungö, waa kàmɛn Yɛsu kàkyàmbar paa, wɛɛ nde kàyöb anki naa awunà nde. ");
INSERT INTO yns_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yɛsu kàtɛn a nde naa: « Un'kaar, ntɔn nkye alelà ngye? Nà ngye aleŋà? » Wɛɛ nde kàsii naa un'syääl a làpaŋ kàkäl, waa kàtɛn a nde naa: « Mwol, isàkal naa ngye kun'lwom, nkyään, ngye kun'si ken, waa mɛɛ in'kun'wal. » ");
INSERT INTO yns_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yɛsu kàtɛn a nde naa: « Màlye! » Nde waa kàbulà, kun'fuur unsà Ibɛlyɔ naa: « Rabuni! », iswaŋà naa « Un'lɔɔŋ ». ");
INSERT INTO yns_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yɛsu kàtɛn a nde naa: « Twon aman'ba, ntɔn mɛ ŋàtàbeenà anki akà Taaràmɛ. Wɛɛ kyen kakyään atɔŋ amɛ naa mɛ an'beenà akà Taaràmɛ awà Taaràbɛ sye, akà Nzam amɛ awà Nzam abɛ sye. » ");
INSERT INTO yns_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Abun, Màlye un'si Makdalà kàkyen akalɔŋki, waa kasam naa: « Mɛ, mɛ an'man Mwol, le ndaa kan'kyään nde. » ");
INSERT INTO yns_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Làsisye a ilä nsil aki, ilä atàtwɛb kyà mpɔsà, alɔŋki bàkàköŋ u ndwà, ibeenà byàkäl byàŋàdübà a in'kaŋàboo, ntɔn ba bàtiinà bɔɔmà a amfum a Ayudà. Yɛsu waa kàyi, kàmbär uboboo a ba, waa kàtɛn a ba naa: « Duu làkäl anà bɛ! » ");
INSERT INTO yns_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ungö mutɛn abà, nde kamɛɛy an'kɔɔ anà bɛl a nsyäärà ande. Alɔŋki banswà bàkäl unsà un'sak muman Mwol. ");
INSERT INTO yns_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yɛsu kàfàtɛn a ba naa: « Duu làkäl anà bɛ! Asànaa kan'töm Taa, mɛ, mɛ sye amàlatɔm. » ");
INSERT INTO yns_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ungö a ndaa ayi, nde kafül un'swey, waa kàtɛn a ba naa: « Làwɛl Dweelà In'kyɛɛl! ");
INSERT INTO yns_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Akà baar abà làsàdwääl bɛ nkul a man'be aba, ba bàsàwal ndwääl a nkul. Wɛɛ akà baar mpa làsàdwääl bɛ nkul, ba ya sye bàsàwal anki. » ");
INSERT INTO yns_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kyekà Tuma awà bàfàbel Didimɔ, umwɛy uboo a Bàkwem Aŋiyweel kàkäl anki anà ba umpal kàyi Yɛsu. ");
INSERT INTO yns_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Abun, alɔŋki bumwɛy bun'kyään naa: « Bi kan'man Mwol. » Wɛɛ nde kafuur naa: « Isàkal naa mɛ in'mɛn anki idiim a in'sàmar kan'kɔɔ ande, isàkal naa mɛ in'külà anki làpin amɛ kikal a in'sàmar anà kɔɔ amɛ u bɛl a nsyäärà ande, mɛ in'sà anki làkwikilà. » ");
INSERT INTO yns_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wɛɛ ungö a ilä naan, alɔŋki bàfàköŋ u ndwà, Tuma kàkäl anà ba. Ibeenà byanswà byàkäl byàŋàsà in'kaŋàboo. Yɛsu kàyi nde, kàmbär uboboo a ba, waa kàtɛn a ba naa: « Duu làkäl anà bɛ! » ");
INSERT INTO yns_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ungö waa kàtɛn a Tuma naa: « Sin làpin angye pà, ler an'kɔɔ amɛ. Sin sye kɔɔ angye, fwaar la u bɛl a nsyäärà amɛ. Wɛy mukal un'syeel a mbaaŋ, wɛɛ bulà aŋàlàkwikila! » ");
INSERT INTO yns_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tuma kun'fuur naa: « Mwol amɛ, Nzam amɛ! » ");
INSERT INTO yns_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yɛsu kàtɛn a nde naa: « Nkye ntɔn aman'man ngye, waa ngye an'sà làkwikilà? Un'sak mbɔɔn akà baar mpa bàmɛn, waa bàsi làkwikilà! » ");
INSERT INTO yns_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yɛsu kàkyer idiim asin mbɔɔn u mii a alɔŋki ande abyà mpa bàsön uboo a un'kaan awà. ");
INSERT INTO yns_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Indiir abi bàsön ntɔn bɛ làsi làkwikilà naa Yɛsu wà Klistɔ, Mwan a Nzam, naa sye u mbwo a làkwikilà alà, bɛ làkäl anà mɔ̈ɔ̈ kikɔb ande. ");
INSERT INTO yns_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ungö a indiir abi, Yɛsu kàfàmɛnà akalɔŋki ande kun'kɔɔl a ɛwà a Tibɛryade. Le, nde kàyàmɛnà aben akà ba: ");
INSERT INTO yns_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔn Petɔlà, Tuma - bàfàbel naa Didimɔ, Natanayɛl un'nsi Kana u Ngalilɛ, baan a Zebeday anà alɔŋki bɔ̈ɔ̈l bumwɛy bàkäl ikal imwɛy. ");
INSERT INTO yns_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simɔn Petɔlà kàtɛn a ba naa: « Mɛ, mɛ awin'kyà in'kàlwab nsö. » Ba bàtɛn a nde naa: « Bi ikyà anà ngye! » Laa bàtoo ba, bàbilà ba u bwaar, wɛɛ u mpib ayin, ba akundiir bàsiim anki. ");
INSERT INTO yns_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Taaŋ làkäl lan'tyà, Yɛsu kàkäl aŋàmbar paa kun'kɔɔl a an'dà. Wɛɛ alɔŋki bàyöbà anki naa awun Yɛsu kàkäl. ");
INSERT INTO yns_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Apan, Yɛsu kàtɛn a ba naa: « Baan amɛ, nkye bɛ làwe anà undiir adyà? » Ba bun'fuur naa: « Ŋaa. » ");
INSERT INTO yns_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nde kàtɛn a ba naa: « Làtɔɔm an'tɛy u kɔɔ a ibaal a bwaar, waa bɛ làyàman. » Abun, waa ba bàtɔɔm ma, wɛɛ ba bàkwe anki munaan ma, ntɔn nsö yàkäl mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Apan, un'lɔŋki kàfakweenà Yɛsu kàtɛn a Petɔlà naa: « Awà Mwol! » Pa kàwem Petɔlà naa Mwol kàkäl, nde kàbwäär ipfɛy, ntɔn nde kàkäl nsàpɔl, waa kàbü kan'dà. ");
INSERT INTO yns_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Alɔŋki bumwɛy bàyi anà bwaar, ntɔn munaan an'tɛy màkäl aŋàyɔl a nsö: ba bàkäl anki kwɛl a nkankyel, isii a mɛtre nkam mwɛy. ");
INSERT INTO yns_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Utaaŋ bàtɔlà ba u nkankyel, ba bàmɛn böl a an'kal a mbaa anà nsö udu, anà mampà. ");
INSERT INTO yns_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yɛsu kàtɛn a ba naa: « Làtwääl nsö yumwɛy uboo a nsö lan'siim bɛ. » ");
INSERT INTO yns_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simɔn Petɔlà kàbilà u bwaar, kànaan an'tɛy u mɛɛn, ma màkäl aŋàyɔl a nsö an'köl an'köl: nkam mwɛy a an'kwem an'tyeen aŋitär. Itàkal naa ya yàkäl un'kàbɔ, an'tɛy màkaamà anki. ");
INSERT INTO yns_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yɛsu waa kabel: « Yää, làdi. » Akà un'lɔŋki mwɛy kàkwe anki mukun'fuul naa: « Ngye, ngye nà? » Ntɔn ba bàkiyöbà naa awà Mwol kàkäl. ");
INSERT INTO yns_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Abun Yɛsu kàsin nde, nde kàwɛl mampà anà nsö, waa kakääb. ");
INSERT INTO yns_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ayi yàkäl mbalà yàtär ayà kàmɛnà Yɛsu akalɔŋki ande, fà kàwiyà nde uboo a akü. ");
INSERT INTO yns_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ungö a udyà, Yɛsu kàfuul Simɔn Petɔlà naa: « Simɔn, mwan a Ywan, nkye ngye akyan'kwen aŋàsöön baar bà? » – Nde kàfuur naa: « Inye, Mwol, ngye akyàyöb ngye ŋakwo naa mɛ in'kyakwen. » Apan Yɛsu kàtɛn a nde naa: « Sey baan a in'kɔk amɛ. » ");
INSERT INTO yns_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","U mbalà yàyweel, Yɛsu kun'fuul naa: « Simɔn, mwan a Ywan, nkye ngye akyan'kwen? » Nde kàfuur naa: « Inye, Mwol, ngye akyàyöb naa mɛ in'kyakwen. » Yɛsu kàtɛn naa: « Kal nkyɛɛŋ a in'kɔk amɛ. » ");
INSERT INTO yns_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","U mbalà yàtär, nde kàtɛn a nde naa: « Simɔn, mwan a Ywan, nkye ngye akyan'kwen? » Petɔlà kàmɛn ngyɛb ntɔn kun'fuul Yɛsu mbalà yàtär naa: « Nkye ngye akyan'kwen? » Nde kun'fuur naa: « Mwol, ngye mbuur ayöb ndaa yanswà, ngye akyàyöb naa mɛ, mɛ in'kyakwen! » Yɛsu waa kàtɛn a nde naa: « Sey in'kɔk amɛ. ");
INSERT INTO yns_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ndandaa, ndandaa, mɛ akyään: mpal kàkäl ngye un'tö, ngye ŋakwo kàfabäämà un'kab, ngye kàkyeenà ntsü yanswà kàkweenà ngye. Wɛɛ mpal asàbulà ngye un'nün, ngye asayaamà an'kɔɔ angye, waa mbuur asin usabäämà un'kab, nde sye usasyeenà ntsü mpa akwen ngye. » ");
INSERT INTO yns_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kàtɛn nde abà, Yɛsu kàkwen muswaŋ naa nkweel a Petɔlà isàkal aben ntɔn mupà Nzam làkoo. Ungö mutɛn abà, nde kàtɛn a nde naa: « Yan'läb! » ");
INSERT INTO yns_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petɔlà kàler ungö, kàmɛn nde un'lɔŋki kàfakweenà Yɛsu - nde akwà kàkàyiir kitɔl ande umpal bàkäl ba mudyà anà kun'fuul naa: « Mwol, nà asayälà? » ");
INSERT INTO yns_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mpal kun'mɛn Petɔlà, nde kàfuul Yɛsu naa: « Mwol, atöl nde, ininà isàkal? » ");
INSERT INTO yns_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yɛsu kun'fuur naa: « Isàkal naa mɛ in'kwen naa nde ukäl anà mɔ̈ɔ̈ tii mpal in'sàyà mɛ, a akà ngye mwo nkye? Ngye, yan'läb! » ");
INSERT INTO yns_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Fà apan, làsaŋ làpää akatɔŋ naa un'lɔŋki awà usàkwà anki. Kyekà, Yɛsu kàtɛn anki naa un'lɔŋki awà usàkwà anki, wɛɛ nde kàtɛn naa: « Isàkal naa mɛ in'sàkwen naa nde ukäl tii mpal in'sàyà mɛ, a akà ngye mwo nkye? » ");
INSERT INTO yns_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Un'lɔŋki nsil awà, wàmutà imbäl a indiir abi anà kàsön bya, bi ban'yöb naa imbäl ande kyà ndandaa. ");
INSERT INTO yns_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yɛsu kàkyer indiir asin mbɔɔn. Yàlàkal naa bàsön bya imwɛy imwɛy, mɛ in'sii ikal kyàlàkal anki musà in'kaan myanswà bàlàsɔn.");
INSERT INTO yns_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Un'sam Tyɔfil, Uboo a un'kaan amɛ wàtàtwɛb, mɛ kasam indiir byanswà kàsɛmà Yɛsu mukyer anà mulɔŋ ");
INSERT INTO yns_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tii ilä bun'sɛɛn ba ungö mupà nswɛɛŋ u mbwo a Dweelà In'kyɛɛl akà Antööm kàsɔ̈ɔ̈l nde. ");
INSERT INTO yns_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yàlɔ̈m naa ungö a nkweel ande, nde kàyamɛnà nde ŋakwo akà ba ntɔn mukaswaŋ unsà mbwo yà ifà ifà naa ndandaa nde wà anà mɔ̈ɔ̈. Nde kàyàmɛnà akà ba ilä an'kwem an'nà mukakyään indiir a Imwol a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ilä mwɛy nde kàkäl mudyà anà ba, nde kaswɛŋ ndaa yi: « Twon lan'lwomà u Yɛlusàlɛm, wɛɛ làdil ilää kàpɛ Taa, kab a ngway kàlakyään mɛ. ");
INSERT INTO yns_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ntɔn Ywan kàyadümà kà an'dà, wɛɛ bɛ, bɛ bàyàladümà unsà Dweelà In'kyɛɛl ungö a ilä ikikye. » ");
INSERT INTO yns_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Apan, baar bàyàköŋ apà nde bun'fuul naa: « Mwol, nkye taaŋ nsil alà ayàfuur ngye imwol akà Isàlɛl? » ");
INSERT INTO yns_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yɛsu kafuur naa: « Kà bɛ anki lan'kwo muyöb taaŋ anà ilä kàsi Nzam unsà ikɔ̈b ande. ");
INSERT INTO yns_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wɛɛ bɛ làsàwal ngwal taaŋ usyetyà Dweelà In'kyɛɛl udu a bɛ. Bɛ làsàkal ambäl amɛ u Yɛlusàlɛm, uboo a Yuday lanswà, u Samalya tii u ntsüü a mɛɛn. » ");
INSERT INTO yns_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Utaaŋ kàmay nde mutɛn abwɛy, laa bun'sɛɛn ba, Antööm bàkäl mukun'lerà. Itööm mwɛy kyun'fwee u mii aba. ");
INSERT INTO yns_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Umpal bàkäl ba mulerà u du ntsü kàkyen Yɛsu, kà imbürà, ba bàmɛn abaal bɔ̈ɔ̈l bàŋambwaar ipfɛy a pɛɛl bàŋàmbar apà ba, ");
INSERT INTO yns_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","waa bàtɛn a ba naa: « Baar a Ngalilɛ, ntɔn nkye lan'mbar bɛ apà mulerà u du? Yɛsu wa bàmàlalwom wà mubeenà du, afàsyefurà asànaa lun'mɛn bɛ mubeenà. » ");
INSERT INTO yns_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Antööm bàlwomà u mɔŋ bàfàbel naa mɔŋ a in'te a olive, ba bàfurà Yɛlusàlɛm. Mɔŋ awà wà tsütsü a Yɛlusàlɛm kà isii a kilɔmɛtre mwɛy. ");
INSERT INTO yns_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mpal bàkɔlà ba, ba bàläär u suk adu, ikal bàfakööŋà ba. Ba bàkäl Petɔlà, Ywan, Zyak anà Andrɛ, Filipo anà Tuma, Bàtɛlàmay anà Màtay, Zyak mwan a Alefɛ, Simɔn Ŋinaŋ, anà Yudà mwan a Zyak. ");
INSERT INTO yns_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ba banswà bàkyer afabweyà mbɔɔn ntɔn muyamà, anà akaar, anà Màlye ngwän a Yɛsu anà atɔŋ ande. ");
INSERT INTO yns_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kà ilä abin, alɔŋki bàköŋ bàkal kà isii a nkam a an'kwem mɔ̈ɔ̈l. Petɔlà kàmbarà uboo a ba, waa kàtɛn a ba naa: ");
INSERT INTO yns_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","« Atɔŋ, yubwaŋ naa ndaa kàtɛn Dweelà In'kyɛɛl uboo Un'kaan ikwe: u mun a David, nde kàtɛn kusà ntɔn Yudasi mbuur kàtwääl baar ntɔn mukɔr Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ntɔn nde kàkäl umwɛy uboo a bi, nde sye kàkyer awal kab uboo a isal bipɛ. ");
INSERT INTO yns_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nde kàsöm mɛɛn a ngim kàyälà nde Yɛsu. Nde kàbü kwo un'tswe lingyɛl, ndür ande yàbarà uboboo, in'swà ande myanswà waa myàpää. ");
INSERT INTO yns_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Baar a Yɛlusàlɛm banswà bàkyer ayöb ndaa ayin: lalan bàbeelà ba mɛɛn aman u ndaa aba naa \"akɛldamà\", iswaŋà naa \"mɛɛn a an'kil\". ");
INSERT INTO yns_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wɛɛ, làwem ndaa bàsön uboo a un'kaan a an'diim: \"Wɛy ndwà ande ikäl ipɔl, mbuur ukɔɔn abilà kwo.\" Waa bàfàkwɛy naa: \"Wɛy mbuur asin uwɛl buur ande.\" ");
INSERT INTO yns_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Abun, bye anà baar bàyikyeenà anà bi taaŋ lanswà kàyilyaaŋà Mwol abi Yɛsu kusà a bi ");
INSERT INTO yns_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","sɛmà ilä kun'dümà Ywan tii ilä kàlwomà nde uboo a bi. Lalan mbuur awun ayàkal mbäl ntɔn ngwiiyà a Yɛsu. » ");
INSERT INTO yns_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ba bàswɛŋ baar bɔ̈ɔ̈l: Yɔsefi bàfabeelà naa Barsàbas, bun'pɛ sye ikɔb naa Mbuur a balàbal, anà Màtyas. ");
INSERT INTO yns_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Apan ba bàsi ngyamàkà yi: « Ngye, Mwol, ngye akyàyöb mpem a baar banswà. Iswɛŋ uboo a atɔŋ bà bàbɔ̈ɔ̈l ngye nà an'sɔɔl ");
INSERT INTO yns_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ntɔn muwal uboo a isal a Antööm ikal kàsàwɛy Yudasi ki ntɔn mukyà ikal kàsɔ̈ɔ̈l nde. » ");
INSERT INTO yns_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ungö apan ba bàtɔ̈ɔ̈m löb, löb waa làbü udu a Màtyas. Nde mbuur kàtüüb anà Antööm bàkwem aŋimwɛy. ");
INSERT INTO yns_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ungö apan, mpal kyàkwe ilä a Pantɛkɔt, alɔŋki banswà bàkàköŋ ikal imwɛy. ");
INSERT INTO yns_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yàmɛnà naa kà imbürà, làso làfü du: la làkäl asànaa un'pöb a ngwal akayaa anà akayöölà ndwà yanswà bàkälà ba. ");
INSERT INTO yns_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Taaŋ nsil alan, yàmɛnà anà ndem mwɛy asànaa ndem a mbaa. Ya yakyer akaabà, waa yàbwee udu a umwɛy umwɛy uboo a ba. ");
INSERT INTO yns_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Apan sye Dweelà In'kyɛɛl kàwɛl ba banswà, ba waa bàsɛmà mutɛn unsà ndaa asin yà ifà ifà, mbuur mbuur asànaa Dweelà kàswɛŋà nde ba mutɛn. ");
INSERT INTO yns_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kyekà taaŋ nsil alan, Ayudà a mpem aŋàbwaŋ bàfü in'sɛŋ myanswà amyu mɛɛn, bàkäl u Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mpal bàwem ba làso alan, un'sɛŋ wanswà kàyi u ntiin. Ba bàkäl mubem, ntɔn mbuur mbuur kàweemà u ndaa ande ŋakwo bàtɛɛnà ba. ");
INSERT INTO yns_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ba bàkäl unsà lingyoomà anà ubem, waa bàtɛɛnà naa: « Làler, baar bàyäämà bà banswà, nkye ba kà baar a Ngalilɛ anki? ");
INSERT INTO yns_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Iswaŋà aben naa bi ikaweemà umwɛy umwɛy u ndaa a bul ande ŋakwo? ");
INSERT INTO yns_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Uboo abi, bi ibà anà bà Partɛs, bà Mɛdɛs, bà Ɛlamit, bi ifàkal u Mɛzɔpɔtami, u Yuday, u Kapadɔs, u Pɔn anà kà itiir a nsi a Azi, ");
INSERT INTO yns_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","u Frizi bàfàbel sye Pamfili, u Ngipiti, u Libi tsütsü a Sirɛn, u Lɔmà, ");
INSERT INTO yns_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","u Krɛt anà Arabi. Bi ibà Ayudà unsà mböör abi anà Ayudà unsà inzaam, wɛɛ mbuur mbuur uboo a bi wàmuweemà u ndaa ande ŋakwo indiir a kölàköl kan'kyer Nzam. » ");
INSERT INTO yns_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ba banswà bàkäl unsà lingyoomà anà isak isak. Ba bàtɛɛnà ba a ba naa: « Abà iswaŋà aben? » ");
INSERT INTO yns_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wɛɛ bumwɛy bàsɛɛ aŋàlàkwikilà, waa bàtɛn naa: « Ba bàŋàyɔr ubwaŋàbwaŋ! » ");
INSERT INTO yns_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Apan, Petɔlà waa kàmbarà anà Bàkwen Aŋimwɛy, nde kàtɛn u ndaa a ngwal a baar mbɔɔn naa: « Abaal a Yuday anà bɛ banswà làfàkal u Yɛlusàlɛm, làwem ubwaŋàbwaŋ ndaa amɛ! ");
INSERT INTO yns_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aay, baar bà kàbàŋàyɔr anki asànaa làkasii bɛ, ntɔn bi ibà u taaŋ làwà làtutu. ");
INSERT INTO yns_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wɛɛ papà, ndaa kàkyään ŋangɔɔm Ywel yan'kwo: ");
INSERT INTO yns_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","\"Làler ndaa isàlyaaŋ kà ilä a ntsüü, mɛ in'sàtsuul Dweelà amɛ udu a mbuur wanswà, baan abɛ babaal anà bakaar bàsàtà ngɔɔm, mɛ in'sàtɛn kà imanmii akà baan ambɛy abɛ anà u ndwɛy akà anün abɛ. ");
INSERT INTO yns_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ɛɛ, mɛ in'sàtsuul Dweelà amɛ itàkal udu a asyääl amɛ babaal anà bakaar kà ilä abin, mɛ in'sàtsuul Dweelà amɛ, ba bàsàtà ngɔɔm. ");
INSERT INTO yns_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mɛ in'sàmɛɛy indiir a ubem untaal u du anà idiim ungyɛl udu a mɛɛn: an'kil, mbaa anà un'swey a un'diŋ a mbaa, ");
INSERT INTO yns_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","taaŋ làsàbulà mpib, nsöŋ asàbulà wàtsöö asànaa an'kil kusà a ilä a Mwol muyà, ilä a kölàköl anà kyàlàkoo. ");
INSERT INTO yns_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Abun, mbuur wanswà asàbel ikɔb a Mwol asàwà mɔ̈ɔ̈.\" ");
INSERT INTO yns_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Baar a Isàlɛl, làwem ndaa yi: Yɛsu un'nsi Nasàlɛr wà mbuur kàtöm Nzam ntɔn bɛ. Nde kàkyer isal a ngwal, indiir a ubem anà idiim uboo a bɛ asànaa làyöb bɛ ŋakwo, ");
INSERT INTO yns_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","mbuur awà bàkyer un'yälà kà an'kɔɔ a baar abɛ asànaa kàbön Nzam itaan unsà an'kyän ande. Wɛɛ bɛ, bɛ làkyer un'dwa, lun'bɛɛrà u kulunsi u kɔɔ a baar abɛ. ");
INSERT INTO yns_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wɛɛ Nzam kun'fuur u mɔ̈ɔ̈, kun'tsuuŋ unsà usaay a nkweel, ntɔn yàlàkwo anki naa an'lɔŋ mun'käär uboo a ikɔ̈b a ma. ");
INSERT INTO yns_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Lalan David kàtɛn nde ntɔn nde naa: \"Mɛ kàmɛnà Mwol taaŋ lanswà kusà a mɛ, ntɔn nde wà u kɔɔ amɛ là ibaal ntɔn mɛ in'kɔ̈ɔ̈n abwà. ");
INSERT INTO yns_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ntɔn ndaa ayi, mpem amɛ yà unsà un'sak anà mun amɛ wàmutwey ndaa a ntsà. Abun, ndür amɛ sye isàbɔ̈ɔ̈n unsà làkyän. ");
INSERT INTO yns_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ntɔn ngye, ngye mɛ asan'wɛy anki kà an'lɔŋ. Ngye asun'wɛy anki mbuur angye wàŋin'kyɛɛl upɔ̈ɔ̈n. ");
INSERT INTO yns_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ntɔn ngye mɛ kan'swɛŋ mbwo a mɔ̈ɔ̈ anà ngye asan'yööl a un'sak u mii a ngye.\" ");
INSERT INTO yns_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Atɔŋ, wɛy mɛ alàkyään alää naa undweer David kàkyàkwà ndandaa, bàkyun'dyee. An'dii ande mà tsütsü apà bi tii ŋàbawà. ");
INSERT INTO yns_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wɛɛ nde kàkäl ŋangɔɔm anà kàkyer ayöbà naa Nzam kàdi kyän naa: \"Mɛ in'sàsà ikyee angye u kir a imwol angye\". ");
INSERT INTO yns_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David kàyöb kusà ndaa iyàyà ntɔn ngwiiyà a Klistɔ, nde kàtɛɛnà naa Nzam asun'wɛy anki kà an'lɔŋ, nde sye usàwɛy anki ndür ande ipɔ̈ɔ̈n. ");
INSERT INTO yns_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yɛsu awà, Nzam kàkyun'wiiy, bi banswà ibà ambäl. ");
INSERT INTO yns_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Abun, Nzam kun'sɛɛn, waa kun'si u kɔɔ ande là ibaal, nde kan'wal akà Taa Dweelà Inkyɛɛl kàbön nde, waa kàmun'tyaaŋ. Ayin ya làmanà anà làweemà bɛ yi. ");
INSERT INTO yns_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kutɛn aŋàbwaŋ, David kàbeenà anki du nde ŋakwo, wɛɛ nde kàtɛn naa: \"Mwol kàtɛn a Mwol amɛ naa: Yabwaay u kɔɔ amɛ là ibaal, ");
INSERT INTO yns_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tii mpal in'sàsà mɛ aŋankir angye u ngyɛl a in'kɔl angye.\" ");
INSERT INTO yns_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Wɛy un'sɛŋ a Isàlɛl wanswà uyöb ndandaa naa Yɛsu akwà bɛ, lun'bɛɛrà bɛ u kulunsi, Nzam kàkyun'sà Mwol anà Klistɔ. » ");
INSERT INTO yns_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ndaa ayi yàpɛ mpay mbɔɔm akà baar bàwem ya. Ba bàfuul Petɔlà anà antööm bumwɛy naa: « Atɔŋ abaal, ininà bi kan'kwo mukyer? » ");
INSERT INTO yns_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petɔlà waa kafuur abà: « Làbuul mpem abɛ, wɛy mbuur mbuur uwɛl ndüümà kà ikɔb a Yɛsu Klistɔ, ntɔn bàladwääl nkul a man'be abɛ. Apan bɛ làsàwal kab a Dweelà In'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ntɔn ilää kyà bɛ, ntɔn ikyee abɛ anà ntɔn in'sɛŋ a nsi a kwɛlàkwɛl usàbel Mwol Nzam abi tsütsü apà nde. » ");
INSERT INTO yns_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Wɛɛ unsà ndaa yà ifà ifà, nde kàkweenà naa ba bàkyey ndaa kàtɛɛnà nde anà kalɔɔŋà nde naa: « Làkaabà a nkööl a lingyoomà yi. » ");
INSERT INTO yns_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Abun baar bàkyey ndaa a Petɔlà bàwɛl ndüümà. Ilä akin baar bàbilà uboo a un'tüüb a aŋàlàkwikilà bàkäl kà isii a nsaab tär. ");
INSERT INTO yns_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wɛɛ ba bàsi muküünà mulab an'lɔɔŋ a Antööm, mukal un'tüüb ba banswà: ba bàkäbà, bàdyee anà bàyayamà ikal imwɛy. ");
INSERT INTO yns_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mbuur wanswà kàkäl u bɔɔmà, ntɔn Antööm bàkyerà impà anà idiim mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Aŋàlàkwikilà banswà bàkälà ikal imwɛy, indiir aba byàkäl byà ba banswà. ");
INSERT INTO yns_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ba bàyälà mɛɛn anà indiir aba anà mukab bweel ba banswà mbuur mbuur u ngyal ande. ");
INSERT INTO yns_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Unsà ukwen aba, ilä byanswà ba bàfabweyà u ndwà a Nzam. Unsà un'sak wanswà anà ukɔɔn nkyɛɛr u mpem, ba bàfadyaa ibööl u ndwà aba. ");
INSERT INTO yns_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ba bàfasyaŋà Nzam, baar banswà bakyer akweenà. Ilä byanswà Mwol kàkwɛyà kà Ikööŋ aba baar kàtswää nde mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yàmɛnà naa ilä mwɛy Petɔlà anà Ywan bàkäl mubeenà ntɔn mukàyamà u ndwà a Nzam u taaŋ làtär ungö a midi. ");
INSERT INTO yns_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kyekà ilä byanswà ba bàfatwaalà ŋatoo mwɛy sɛmà mböör ande, waa bàfun'tɔɔlà u munàmbwo a ndwà a Nzam tsütsü a ibeenà bàfàbel naa « La Bɛɛl Pɔrte » ntɔn nde ulɔ̈ɔ̈mà ngim akà baar bàfabilà u ndwà a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Umpal kàmɛn nde Petɔlà anà Ywan bàmubilà u ndwà a Nzam, nde kalɔ̈ɔ̈m ngim. ");
INSERT INTO yns_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petɔlà anà Ywan waa bun'syebà. Petɔlà kàtɛn a nde naa: « Iler. » ");
INSERT INTO yns_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mbuur awà kaler ubwaŋàbwaŋ. Nde kàsii naa nde awal undiir mwɛy akà ba. ");
INSERT INTO yns_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petɔlà waa kàtɛn a nde naa: « Mɛ ngim yatɛy, itàkal wɔl, wɛɛ undiir in'wà mɛ awà mɛ in'kyer apà wa: Kà ikɔb a Yɛsu Klistɔ un'nsi Nasàlɛr, mbarà, kyen. » ");
INSERT INTO yns_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Apan nde kun'te mpi u kɔɔ ande là ibaal, waa kumbaar. Papan sye in'kɔl anà nkɔn a in'kɔl ande waa myàtsim, ");
INSERT INTO yns_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","nde waa kàfumà, kàmbarà, kàsɛmà mukyà dwaan. Nde kàbilà anà ba u ndwà a Nzam, wàmukyà, mufumà anà musyäŋà Nzam. ");
INSERT INTO yns_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Baar banswà bun'mɛn mukyà dwaan anà musyäŋà Nzam. ");
INSERT INTO yns_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ba bàkyer ayöbà naa wà mbuur afàkal aŋàbwaay tsütsü a « La Bɛɛl Pɔrte » mulɔɔmà ngim. Muman ndaa yun'yeel, baar bàkäl mutɛɛr anà muman bɔɔmà aŋàkir. ");
INSERT INTO yns_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wɛɛ nde, nde kàsàwɛy anki Petɔlà anà Ywan. Un'sɛŋ wanswà kàyi wa, kàköŋ tsütsü apà ba u làpaŋ a ndwà a Nzam, ungyɛl a ta a ndwà a Salɔmun wàmutɛɛr a bɔɔmà. ");
INSERT INTO yns_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mpal kàmɛn Petɔlà abun, nde kàtɛn a un'sɛŋ naa: « Abaal a Isàlɛl, ntɔn nkye làkabemà bɛ ntɔn ndaa yan'lyaaŋ yi? Ntɔn nkye lileerà bɛ apɔŋaa asànaa u ngwal abi itàkal unsà inzaam abi waa bi kambaar mbuur wà? ");
INSERT INTO yns_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aay, wà Nzam a Abàlam, wà Izak anà Zakɔb, Nzam a bànkaa abi, kan'sà un'syääl ande Yɛsu làkoo, Yɛsu akwà bɛ, làyälà bɛ anà làtön bɛ u mii a Pilatu umpal kàkwen nde mukun'tsuuŋ. ");
INSERT INTO yns_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ɛɛ, bɛ, bɛ làkyer atɔn Ŋun'kyɛɛl anà wàbalàbal, wɛɛ bɛ, bɛ làsɔ̈ɔ̈l un'dwää baar mukun'tswà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Abun bɛ làdwä aŋamɔ̈ɔ̈. Wɛɛ Nzam kun'twey kà ukwà, bi ibà ambäl a ndaa ayi. ");
INSERT INTO yns_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ntɔn làkwikilà amu ikɔb a Yɛsu, ngwal a ikɔb aki yan'fuur ngwal ambarà akà mbuur làmanà bɛ anà làyöb bɛ wà. Làkwikilà amu Yɛsu lan'kɔɔr ubwaŋàbwaŋ mbuur wà kusà a bɛ banswà. ");
INSERT INTO yns_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wɛɛ apanà, atɔŋ, mɛ inkyàyöb naa ntɔn ukɔɔn ayöb waa bɛ anà amfum abɛ sye làkyer abà akà Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Wɛɛ Nzam kan'kwey ndaa kàtɛn nde itaan u mun a aŋangɔɔm ande naa Klistɔ ande akyer asàman mpay. ");
INSERT INTO yns_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Abun, làbuul mpem abɛ, làsɔɔm nkääl abɛ, ntɔn mubiiŋ man'be abɛ. ");
INSERT INTO yns_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Apan, Mwol asàtwaal paŋà a duu, waa usàtɔm mbuur kàsɔ̈ɔ̈l nde kusà ntɔn bɛ: Klistɔ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wɛɛ apanà, Yɛsu atàkal u du tii mpal isàsɔɔmà ndaa yanswà asànaa kàkyään Nzam u mun a aŋangɔɔm inkyɛɛl ande itaan. ");
INSERT INTO yns_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Lalan, unsà ndaa ayi Mɔsɛ kàtɛn naa: \"Mwol, Nzam abɛ asàlatweey ŋangɔɔm asànaa mɛ, nde asàkal umwɛy uboo a un'sɛŋ abɛ. Bɛ làkyer asàkyey ndaa yanswà usàlakyään nde. ");
INSERT INTO yns_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mbuur wanswà asàkɔɔn awem ndaa a ŋangɔɔm awà bàkyer asun'böŋ kà un'sɛŋ a Nzam.\" ");
INSERT INTO yns_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wɛɛ aŋangɔɔm bàtɛn sɛmà Sàmwel, ba banswà umwɛy umwɛy, bàkyer akyäänà ilä abi. ");
INSERT INTO yns_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ilää kàsi Nzam u mbwo a aŋangɔɔm kyà ntɔn bɛ, bɛ sye làbye anà kab uboo a nkwà kàdi Nzam anà andweer abɛ mpal kàtɛn nde a Abàlam naa: \"Mɛ in'sàsaak an'bɔr manswà u mɛɛn u mbwo a ikyee angye.\" ");
INSERT INTO yns_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Abun, Nzam kàtwey un'syääl ande utàtwɛb ntɔn bɛ, nde kun'töm ntɔn nde kàlasaak anà kàlalwom unsà an'kyän abɛ man'be. » ");
INSERT INTO yns_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Umpal bàkäl Petɔlà anà Ywan mukyäänà un'sɛŋ a baar, angaŋ, mfum a aleer a ndwà a Nzam anà Asadusi waa bàyi. ");
INSERT INTO yns_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ba bàkäl anki un'sak unsà an'lɔɔŋ aba akà un'sɛŋ anà mukun'kyään naa Yɛsu akyàwiyà kà an'lɔŋ ntɔn muswaŋ naa akü bàkyer asàwiyà. ");
INSERT INTO yns_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ba waa bakör, basi u bɔlokà tii taaŋtyà, ntɔn sisye làkäl aŋàkwo itaan. ");
INSERT INTO yns_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Apan, bàmbɔɔn uboo a baar bàwem ndaa a Antööm bàkyer akyey ya. Abun abaal aŋàlàkwikilà bàkɔlà kà isii a nsaab tyeen. ");
INSERT INTO yns_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yàmɛnà naa taaŋtyà, amfum a un'sɛŋ, andweer anà alɔɔŋ a in'kɔɔn bàköŋ u Yɛlusàlɛm, ");
INSERT INTO yns_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","anà An, undweer a angaŋ, anà Kayifà anà Ywan anà Aleksandre anà baar banswà bàkäl u ywar a undweer a angaŋ. ");
INSERT INTO yns_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ba bàsi Antööm uboboo, waa bafuul naa: « Unsà ikɔ̈b nà itàkal kikɔb anà bɛ, bɛ làkyerà ndaa ayi? » ");
INSERT INTO yns_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Apan Petɔlà kàkäl aŋàyɔl a Dweelà In'kyɛɛl, waa kàtɛn a ba naa: « Amfum a un'sɛŋ anà andweer, ");
INSERT INTO yns_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","isàkal naa ŋàbawà bàkifuulà ntɔn ubwaŋ kan'kyer bi ntɔn un'bɛy anà muyöb naa nde kan'kɔrà aben, ");
INSERT INTO yns_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","yubwaŋ naa bɛ anà un'sɛŋ a Isàlɛl wanswà làyöb naa unsà ikɔb a Yɛsu Klistɔ, un'nsi Nasàlɛr, mbuur akwà bɛ, bɛ lun'bɛɛrà u kulunsi anà kàtwey Nzam kà ukwà, waa mbuur wà kambar anà ngwal kusà a bɛ. ");
INSERT INTO yns_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mbuur awà wà nkɔŋ akwà làtön bɛ atööŋ anà kàbulà un'tswe a twɛrà a ndwà. ");
INSERT INTO yns_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Lalan, ngweel a mɔ̈ɔ̈ yatɛy unsà mbuur asin, ntɔn uboo a baar u mɛɛn pà ikɔb a mbuur asin kyatɛy u mbwo a kya ban'kwo bi muwà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Baar a làbay a nsaŋ bàkäl mubem ntɔn bàmɛn ba uyɔl a Petɔlà anà Ywan anà muyöb naa ba bàkäl baar asànaa baar banswà, baar mpa bàtäŋ. Ba bàyöb naa ba bàyikalà ana Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wɛɛ ba bàmɛnà sye mbuur kàkɔɔrà wà akyàmbar kusà a ba, ba undiir atɛn kàkäl anki. ");
INSERT INTO yns_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Apan ba baswɛŋ mutoo u làbay a nsaŋ, waa bàbulà muyääm ba a ba, waa ");
INSERT INTO yns_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","bàtɛn naa: « Ininà bi kan'kwo mukyer anà baar bà? Ntɔn baar a Yɛlusàlɛm banswà bàkyàyöb ubwaŋàbwaŋ naa idiim aŋàmɛnà ba bàkyer. Bi ikwo anki mutɔn kya. ");
INSERT INTO yns_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wɛɛ ndaa ayi mukɔɔn apää uboo a un'sɛŋ wanswà, bi ikyer atsuŋ a ngwal ba mutɛn akà mbuur mwɛy kà ikɔb a akyɛy. » ");
INSERT INTO yns_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ba waa bàfabel, batsüŋ a ngwal mutɛn anà mulɔŋ kà ikɔb a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wɛɛ Petɔlà anà Ywan bafuur naa: « Làtsül bɛ ŋakwo, nkye yà balàbal u mii a Nzam, bi mulab ndaa abɛ anà mubɛy ndaa a Nzam? ");
INSERT INTO yns_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wɛɛ bi, bi iwɛy anki mukyään indiir kàmɛn bi anà kàwem bi. » ");
INSERT INTO yns_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Baar a Làbay a nsaŋ bàläb mukasiinà a ngwal, waa bawɛy. Ba bàsàman anki mbwo mupà ba ntaaŋàmbar, ntɔn un'sɛŋ wanswà kàkäl musyäŋà Nzam ntɔn ndaa yàlyaaŋ. ");
INSERT INTO yns_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Abun, mbuur awà kàkɔɔrà nkɔɔr impà kàkäl ayà mbul aŋàlyaŋ an'kwen an'nà. ");
INSERT INTO yns_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ungö batsuuŋ ba, ba bàkyen akà atɔŋ aba bumwɛy, waa bakyään indiir byanswà bàtɛn amfum a angaŋ anà andweer aba. ");
INSERT INTO yns_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ungö muwem ndaa ayi, ba bàlaal unsà un'tüüb akà Nzam, waa bàtɛn naa: « Mwol, ngye, ngye kàkyer du, mɛɛn, ngyäl anà indiir byanswà abyà uboo mwo, ");
INSERT INTO yns_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","u mbwo a Dweelà In'kyɛɛl, ngye kàten u mun a nkaa abi David, un'syääl angye naa: \"Ntɔn nkye nsi yàbilà ya uboo a lingyoomà anà in'sɛŋ myàkyer mya indiir ikɔ̈ɔ̈n ndöŋ? ");
INSERT INTO yns_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Amfum a mɛɛn bàkyer ayööŋ munwan, baar abye anà ikɔ̈b bàkyer aköŋ ntɔn munwan a Mwol anà Klistɔ ande. ");
INSERT INTO yns_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ntɔn, yà ndandaa naa Ɛlɔdi anà Pɔns Pilatu bàköŋ u bul alà anà angyey anà in'sɛŋ a Isàlɛl ntɔn mutɔn un'syääl angye wà in'kyɛɛl, Yɛsu kàsi ngye an'kɔɔ, ");
INSERT INTO yns_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ntɔn mukyer indiir byanswà kàbön ngye anà kàkwen ngye kusà. ");
INSERT INTO yns_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wɛɛ apanà, Mwol, kyɛɛŋ ubwaŋàbwaŋ ndaa aba yàmbe, apɛ atsüüŋ angye mbwo mukyään ndaa angye unsà uyɔl. ");
INSERT INTO yns_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Abun, swaŋ ngwal angye ntɔn nkɔɔr, impà anà idiim byàmɛnà kà ikɔb a un'syääl inkyɛɛl angye Yɛsu. » ");
INSERT INTO yns_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Umpal bàmay ba muyamà, ikal bàkäl ba muköŋ kyàkyer atɛɛr, ba banswà bàyöl a Dweelà In'kyɛɛl, waa bàkyään ndaa a Nzam anà uyɔl. ");
INSERT INTO yns_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Apan, un'sɛŋ a baar bàsi làkwikilà bàkäl mpem anà mɔ̈ɔ̈ mwɛy, akà umwɛy kàkyey anki naa indiir ande ikäl byànde mpɛl, wɛɛ indiir byanswà byàkäl byà un'sɛŋ. ");
INSERT INTO yns_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Abun, unsà ngwal mbɔɔn, Antööm bàtɛɛ imbäl a ngwiiyà a Mwol Yɛsu, kab a ngway a kölàköl làkäl udu a ba. ");
INSERT INTO yns_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kyakin, akà mbuur umwɛy uboo a ba kàkɔ̈ɔ̈n anki undiir. Ntɔn baar bàkäl anà an'ywaŋ itàkal ndwà, bàkyer ayälà, bweel bàyälà ba indiir abin bàkyer atwaalà, ");
INSERT INTO yns_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","anà bàpɛɛ akà Antööm, ungö waa bàkäbà mbuur mbuur u ngyal ande. ");
INSERT INTO yns_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Apan, Yɔsefi, Antööm bun'pɛ ikɔb a Barnabas, iswaŋà naa « Mbuur afàpà un'kanà. » Nde kàkäl un'lɛvi, un'nsi Sipriyɔt, ");
INSERT INTO yns_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","nde kayälà ywaŋ ande, waa kàpɛ ngim ayin akà Antööm. ");
INSERT INTO yns_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wɛɛ yàmɛnà naa mbuur mwɛy ikɔb ande Ananyas, ikɔb a un'kyay ande Safirà, ba bàyälà ywaŋ làmwɛy. ");
INSERT INTO yns_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ungö pa, un'tüüb mwɛy a un'kyay ande, nde kàyee yar a ngim làmwɛy, lumwɛy waa kàsyen, kàkàtɔl kà in'kɔl a Antööm. ");
INSERT INTO yns_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Apan Petɔlà kàtɛn a nde naa: « Ananyas, ntɔn nkye Satanà uyööl nde mpem angye ntɔn ngye akür Dweelà Inkyɛɛl, waa ayee yar a ngim yan'fà u ngyäälà a ywaŋ? ");
INSERT INTO yns_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kusà ngye muyälà la, la kà làkäl làngye anki? Ungö ngye muyälà la, ngim ayin kà yàkäl kan'kɔɔ angye anki? Ntɔn nkye awel ngye an'kyän mukyer ndaa ayin? Ngye kà baar an'kur anki, wɛɛ ngye an'kur Nzam. » ");
INSERT INTO yns_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pa kàwɛm Ananyas ndaa ayi laa kàbü nde, waa kàkü. Baar banswà bàwem ndaa ayi, bɔɔmà làkyer akaar. ");
INSERT INTO yns_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Apan atö laa bàmbarà ba, bun'läl ba ipfey, bun'syen ba u nsà, waa bun'dyee. ");
INSERT INTO yns_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Yàmɛnà naa ungö a isii a an'taaŋ an'tär, un'kyay ande waa kàyàbilà, nde kàyöb anki ndaa yàlyaaŋ. ");
INSERT INTO yns_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petɔlà kun'fuul naa: « Nkyään, ngim làyälà bɛ ywaŋ abɛ, ayi? » Nde kàfuur naa: « Ɛɛ, ayi. » ");
INSERT INTO yns_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Apan Petɔlà waa kàtɛn a nde naa: « Bɛ làtüüb aben an'kyän musi Dweelà a Mwol? Leer ntääm a baar bàkàdyee un'dim angye u munàmbwo, ba sye bàkyer asyen u nsà. » ");
INSERT INTO yns_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nde kàbü sye kusà a in'kɔl ande, waa kàkü. Atö bàyàbilà ba, bun'mɛn ba wàŋàkwà, waa bun'syen, bàkun'dyee tsütsü apà un'dim ande. ");
INSERT INTO yns_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Apan, baar a ndwà a Nzam banswà bàmɛn bɔɔmà mbɔɔn anà baar bàwɛm ndaa ayi. ");
INSERT INTO yns_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apan, u mbwo a an'kɔɔ a Antööm, idiim anà impà mbɔɔn byàkyer amɛnà uboo a un'sɛŋ a baar. Ba banswà sye bàkälà un'tüüb mwɛy uboo a un'lwaaŋ a an'ta a Salɔmun. ");
INSERT INTO yns_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Wɛɛ akà mbuur asin wà nsà kàkwe anki mutüüb anà ba, wɛɛ un'sɛŋ kàkyer akanà mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Lalan un'sɛŋ abaal anà akaar mbɔɔn bàsye làkwikilà amu Mwol, bàtüübà anà ba. ");
INSERT INTO yns_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ba sye bàtweyà baar an'kyal u mbwo, basyee udu a bitäb, taaŋ lumwɛy udu a bipɔy, ntɔn utaaŋ uyàlyaaŋ Petɔlà, munii ande ufwee itàkal umwɛy uboo a ba. ");
INSERT INTO yns_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Un'sɛŋ a baar mbɔɔn bàfwee an'bul a tsütsü a Yɛlusàlɛm, bàtwäälà baar an'kyal anà baar bàkäl anà dweelà a làbe, ba banswà bàkyer akɔɔrà. ");
INSERT INTO yns_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Apan, undweer a angaŋ anà baar banswà bàkäl anà nde, baar a un'tüüb a Asadusi, bàyöm mpem ntɔn Antööm, ");
INSERT INTO yns_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","waa bakör, basi u bɔlokà a baar banswà. ");
INSERT INTO yns_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wɛɛ uboboo a mpib, un'kyeey a Mwol kàduub ibeenà a bɔlokà, waa katwey anà mukàtɛn a ba naa: ");
INSERT INTO yns_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","« Làkyen, làmbär uboo a ndwà a Nzam, waa làkyään akà un'sɛŋ ndaa a mɔ̈ɔ̈ ayi yanswà. » ");
INSERT INTO yns_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ba bàkyer un'wem: ba bàkyen ututu tutu u ndwà a Nzam, waa bàsɛmà mulɔŋ. Undweer a angaŋ anà baar bàkäl anà nde bàbel baar a làbay a nsaŋ a kölàköl anà un'syääl a andweer a baan a Isàlɛl, waa bàtöm baar muwal Antööm u bɔlokà. ");
INSERT INTO yns_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wɛɛ utaaŋ ban'yà ba u bɔlokà, ba bamɛn anki. Ban'furà ba, ba bakyään ");
INSERT INTO yns_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","anà bàtɛn naa: « Bi bɔlokà ikàman làŋàdübà a kwab kwab, aseey bàkäl kà ikal aba kusà a munàmbwo. Wɛɛ umpal kan'duub bi, bi mbuur imɛn anki uboo. » ");
INSERT INTO yns_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mpal bàwɛm ba ndaa ayin, mfum a aleer a ndwà a Nzam anà amfum a angaŋ bàkäl kà ubem anà muyweer naa ndaa nà yàyeel antööm. ");
INSERT INTO yns_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wɛɛ mbuur mwɛy kayi mukasam naa: « Làler baar làbiil bɛ u bɔlokà, ba abanà uboo a ndwà a Nzam mukalɔɔŋà un'sɛŋ ndaa aba. » ");
INSERT INTO yns_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Apan, mfum a aseey anà asyääl bàkàwal antööm a duu ntɔn ba bàmɛnà bɔɔmà naa manà baar balom in'kul. ");
INSERT INTO yns_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ungö batwääl ba, ba batɔ̈l u làbay a nsaŋ a kölàköl. Mfum a angaŋ kafuul naa: ");
INSERT INTO yns_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","« Nkye bi kàlatsüŋ anki mulɔŋ kà ikɔb aki? Wɛɛ bɛ, bɛ lan'yööl Yɛlusàlɛm anà an'lɔɔŋ abɛ, bɛ làkwen muwɔm an'kil a mbuur awà udu a bi! » ");
INSERT INTO yns_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petɔlà anà Antööm bumwɛy bafuur naa: « Yubwaŋ mulab Nzam wɛɛ kà baar anki. ");
INSERT INTO yns_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nzam a andweer abi kàwiiy Yɛsu akwà làdwä bɛ mpal lun'bɛɛrà bɛ u kulunsi. ");
INSERT INTO yns_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mbuur akwà kàsɛɛn Nzam u kɔɔ ande là ibaal asànaa nkum anà Un'tswää a mɔ̈ɔ̈ ntɔn mupà mbwo akà baar a Isàlɛl musɔɔmà anà muwal ndwääl a nkul a man'be aba. ");
INSERT INTO yns_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wɛɛ bi, bi ibà ambäl a ndaa ayi, bi anà Dweelà In'kyɛɛl kàpɛ Nzam akà baar bàfun'lab. » ");
INSERT INTO yns_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mpal bàwem ba ndaa ayin, un'fur a nkyɛl kàkyer awal, waa bàkwen mukadwa. ");
INSERT INTO yns_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wɛɛ kàkäl anà Umfarisi umwɛy uboo a ba, ikɔb ande Ngàmàlyɛl, un'lɔɔŋ a un'kɔɔn kàfakwenà un'sɛŋ wanswà, kàkyer ambarà, waa kàswɛŋ naa batwey ikikye antööm, ");
INSERT INTO yns_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","waa kàtɛn a ba naa: « Abaal a Isàlɛl, làkäl kà igyɛɛŋ ntɔn bɛ ŋakwo unsà undiir làkwen bɛ mukyer akà baar bà. ");
INSERT INTO yns_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Lalan, itaan a mbɔɔn tɛy, mbuur mwɛy ikɔb ande Tɛwudas kàkyer ayàmɛnà, waa kàkyey uyɔl naa nde wà un'byääl. Isii a abaal nkam nà bàkyer un'lab. Wɛɛ nde bàkyer un'dwa, baar banswà bàkyer apay. Akà undiir kàfàkal anki. ");
INSERT INTO yns_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ungö a nde, utaaŋ musɔn ikɔb, mbuur mwɛy un'nsi Ngalilɛ kàkyer ayàmɛnà, ikɔb ande Yudas. Nde kàsyen un'sɛŋ a baar u mpey. Nde sye bàkyer un'dwa, baar bàkäl anà nde banswà bàkyer apay. ");
INSERT INTO yns_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Wɛɛ apanà, mɛ in'tɛn a bɛ naa twon laläb, lawɛy ba bàkyen. Isàkal naa an'kyän anà isal aba byan'fà akà baar, bya ikyer ayàdiimà. ");
INSERT INTO yns_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wɛɛ, isàkal naa bya byan'fà akà Nzam, bɛ làkwe anki mudwa bya, naa tɛy, bɛ làyànwan sye a Nzam! » Ba bàsyääl an'kyän ande. ");
INSERT INTO yns_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Abun, ba bàbel Antööm, bakäm an'füm, batsüŋ mutà ikɔb a Yɛsu din, waa bawɛy. ");
INSERT INTO yns_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apan sye, ba bàlwomà u làbay a nsaŋ a kölàköl unsà un'sak wanswà muman naa bàmatwey an'yɔl muman ntaan ntɔn ikɔb a Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Abun, ilä byanswà uboo a ndwà a Nzam anà uboo a ndwà a baar, ba bàwɛy anki mulɔŋ anà mupay Làsaŋ Aŋàbwaŋ là Klistɔ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kà ilä abin, ntal a alɔŋki yàkyer alaar, yàmɛnà naa bà Elɛnit bàkäl anki un'sak anà bà Ɛbɛlyɔ ntɔn akweel adim aba bayɔbà anki taaŋ lanswà unsà nkääb a indiir a ilä a ilä. ");
INSERT INTO yns_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Lalan Bàkwem Aŋiyweel bàtüüb ba un'kàbɔ a alɔŋki, waa bàtɛn a ba naa: « Kà yubwaŋ anki naa bi iwɛy ndaa a Nzam ntɔn mukab isaa adyà. ");
INSERT INTO yns_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Abun, làsɔ̈ɔ̈l uboo a bɛ baar nsambwaar abye anà imbäl aŋàbwaŋ bàŋàyɔl a Dweelà anà an'yeerà, waa bi iyapà isal aki. ");
INSERT INTO yns_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ntɔn bi, bi iyàlab mupà taaŋ abi u ngyamàkà anà mulɔŋ Ndaa. » ");
INSERT INTO yns_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nköŋ yanswà yàkyey an'kyän amà: Ba bàsɔ̈ɔ̈l Ityen, mbuur aŋàyɔl a làkwikilà anà Dweelà In'kyɛɛl, anà Filipo, Pɔlɔkɔr, Nikanɔr, Timɔnà, Palàmɛnas anà Nikɔlà un'nsi Antyɔsha kàbulà un'yudà unsà inzaam. ");
INSERT INTO yns_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ba baswɛŋ akà Antööm, Antööm bàyamà ntɔn ba, waa basi an'kɔɔ. ");
INSERT INTO yns_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Apan, ndaa a Nzam yàpää aŋàsöönà. Ntal a alɔŋki yàbulà ya mbɔɔn a mbɔɔn u Yɛlusàlɛm, un'sɛŋ a angaŋ mbɔɔn kàläb làkwikilà. ");
INSERT INTO yns_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Abun, Ityen kàkäl aŋàyɔl a kab a ngway anà ngwal, nde kàkyerà impà anà idiim a kölàköl uboo a un'sɛŋ. ");
INSERT INTO yns_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wɛɛ baar amwɛy uboo a baar a ndwà a nköŋ a Ayudà bàfabeelà naa asɔ aŋàtsuŋà, anà baar a Sirɛn anà Alɛksandri anà Silisi anà Azi, ba bàsɛmà musyeel mbaaŋ anà Ityen. ");
INSERT INTO yns_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Wɛɛ ba bàkwe anki mutɔn an'yeerà anà Dweelà kàsyäälà nde mutɛn. ");
INSERT INTO yns_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ba bàpɛɛ baar nsɛm ntɔn ba bàtɛn naa: « Bi kan'wem, nde wàmubɛy Mɔsɛ anà Nzam. » ");
INSERT INTO yns_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Apan, ba bàsiinà un'sɛŋ anà andweer anà alɔɔŋ a in'kɔɔn, waa bàyi, bàkör Ityen kà imbürà, waa bun'syen u làbay a nsaŋ a kölàköl. ");
INSERT INTO yns_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Akun, ba bun'twääl ambäl a loor bàtɛn naa: « Mbuur wà usàwɛy anki mutɛn ndaa a mbe akà ikal abi kyà in'kyɛɛl anà akà Un'kɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bi kàwem u mun ande naa Yɛsu, un'nazɔrya wà, ayàbwaab Ikal ki anà ayàsɔɔm nkääl abi kàsiwɛɛy Mɔsɛ. » ");
INSERT INTO yns_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Apan baar banswà bàkäl mutsul nsaŋ u làbay a nsaŋ a kölàköl, ileer aba byàkäl akà Ityɛn, ba bàmɛn ntabwey ande asànaa ntabwey a un'kyeey. ");
INSERT INTO yns_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mfum a angaŋ kun'fuul naa: « Nkye ndaa ya bàkatɛɛnà yi a ngye yà ndandaa? » ");
INSERT INTO yns_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Wɛɛ Ityen kàfuur naa: « Atɔŋ anà bàtaa, lan'wem. Nzam a làkoo kàyàmɛnà akà taaràbi Abàlam umpal kàkäl nde u Mɛsɔpɔtami, kusà nde mukàkal u Aran. ");
INSERT INTO yns_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Waa nde kun'sam naa: \"Lwomà u bul angye anà ywar angye, kyen bul alà in'yaswaŋ mɛ.\" ");
INSERT INTO yns_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abun, Abàlam kàlwomà u bul aba Syaldɛyɛn mukàkal u Aran. Akun, ungö a nkweel a taarànde, Nzam kàyun'tɔl u nsi làbà bɛ yi ŋàbà. ");
INSERT INTO yns_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Abun, nde kun'pɛ anki akà ywaŋ mwɛy, itàkal itiir a mɛɛn, wɛɛ nde kun'pɛ ilää mukun'pà mɛɛn ande anà baan ande ungö a nkweel ande. Wɛɛ Abàlam kàkäl anki anà mwan. ");
INSERT INTO yns_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kyakin Nzam kun'kyään naa: \"Ikyee ande bàsàkal u nsi a baar asin, ba bàsàbulà asɔ anà bàsatà an'kaal mbul nkam nà. ");
INSERT INTO yns_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Wɛɛ mɛ in'sàtsul nsaŋ a nsi ayisàbuul ba asɔ. Ungö a indiir abi, ba bàkyer asàtoo anà bàsan'syaŋà kà ikal aki.\" ");
INSERT INTO yns_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ungö apan Nzam kàdi nkwà anà nde, idiim a wa kyàkäl nkyɛɛy. Kyakin Abàlam kàkyɛy nde mwan ande Izak kà ilä kyà naan ungö a mböör ande. Izak sye kàkyer abun akà Yakɔb, Yakɔb waa kàkyer akà ankum bà kwem aŋiyweel. ");
INSERT INTO yns_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ankum bàyöm mpem ntɔn Yɔsɛfi, ba bàkyer un'yälà ntɔn bun'syen Ngipiti. Wɛɛ Nzam kàkäl anà nde. ");
INSERT INTO yns_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Abun, nde kun'lwom uboo a ngyɛb, waa kun'pɛ kab anà an'yeerà kusà a Falawɔ, mfum a Ngipiti, nde kun'si mfum ikikye u Ngipiti anà udu a ndwà ande yanswà. ");
INSERT INTO yns_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Wɛɛ umpal ayin, ngyal mbɔɔn yàbilà u Ngipiti wanswà anà u Kanana. Ngyɛb yàkäl mbɔɔn, bàtaaràbi bàmɛnà anki isaa adyà. ");
INSERT INTO yns_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mpal kàyöb Yakɔb naa isaa byàkäl u Ngipiti, nde kàtöm bàtaaràbi u mbalà atàtwɛb. ");
INSERT INTO yns_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","U mbalà yàyweel, nde kàkyer naa atɔŋ ande bun'yöb, apan Falawɔ waa kàyöb ntsü kàfü Yɔsɛfi. ");
INSERT INTO yns_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ungö apan Yɔsɛfi katöm mukàbel taarànde Yakɔb anà ywar ande lanswà, ba bàkäl baar an'kwem nsambwaar aŋityeen. ");
INSERT INTO yns_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Apan, Yakɔb kàtyà Ngipiti, waa kàkàkwà kwo anà bàtaaràbi, ");
INSERT INTO yns_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","waa basyen u Sishɛm, batɔ̈ɔ̈l uboo a an'lom kàsöm Abàlam a ngim akà baan a Amɔr, taar a Sishɛm. ");
INSERT INTO yns_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ungö apan, taaŋ kàsi Nzam ntɔn ilää kàpɛ nde akà Abàlam kyàkäl tsütsü mukwo, un'sɛŋ kàkyer ayɛl, baar bàbulà mbɔɔn u Ngipiti ");
INSERT INTO yns_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","tii umpal kàwɛl mfum asin imfum u Ngipiti. Nde Yɔsɛfi kàsun'yöb anki. ");
INSERT INTO yns_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mfum awà kàkür un'sɛŋ abi anà kàpɛ bànkaa abi mpay muswaŋ ba a ngwal mupiy baan a kɔɔ aba ntɔn ba bàkü. ");
INSERT INTO yns_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Umpal ayin bàbör ba Mɔsɛ awà kàkäl ntwɛn mbɔɔn u mii a Nzam. Nde bun'bɔɔŋ ngɔn tär u ndwà a taarànde. ");
INSERT INTO yns_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mpal bàkun'tɔɔl ba, mwan a Falawɔ wun'kaar laa kun'wɛl nde, waa kun'ywaaŋ nkà. ");
INSERT INTO yns_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mɔsɛ bun'lɔŋ unsà an'yeerà a baar a Ngipiti manswà. Nde kàkäl un'te baal unsà ntɛɛn anà unsà nsyääl ande. ");
INSERT INTO yns_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mpal kàkölà nde mbul an'kwem an'nà, ankyän màyi u mpem ande mukàler atɔŋ ande baan a Isàlɛl. ");
INSERT INTO yns_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Akun nde kàmɛn mbuur mwɛy wàmukyerà mwan a Isàlɛl mwɛy ube, nde kàwɛɛl mbuur bàkyeer ube wà, waa kàdwä Un'ngipiti wa. ");
INSERT INTO yns_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Abun nde kàsii muswaŋ atɔŋ ande naa u mbwo ande Nzam kàlatswà mɔ̈ɔ̈, wɛɛ ba bàsàyöb anki. ");
INSERT INTO yns_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wɛɛ ilä kyàlääb paa, nde an'kàmɛnà akà ba mpal bàkäl ba munwan ba a ba, nde waa katsuuŋ, waa kàtɛn a ba naa: \"Abaal, bɛ làbà atɔŋ, ntɔn nkye làkyerà bɛ ube bɛ a bɛ?\" ");
INSERT INTO yns_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wɛɛ mbuur akwà kàkyerà un'tɔŋ ande ube kàtön Mɔsɛ, waa kàtɛn a nde naa: \"Nà kasi mfum anà ntɛɛn udu a bi? ");
INSERT INTO yns_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nkye ngye akwen mukan'dwa asànaa kàdwä ngye un'ngipiti ywenà?\" ");
INSERT INTO yns_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ntɔn ndaa ayi, Mɔsɛ laa kàtiin nde, waa kàkàbwaay u nsi a Madyani, mper kàbör nde baan abaal bɔ̈ɔ̈l. ");
INSERT INTO yns_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ungö a mbul an'kwem an'nà, un'kyeey mwey kàkàmɛnà akà nde u nsye a ipɔl yà mɔŋ a Sinayi uboo a làlɛm a mbaa a ibwiy. ");
INSERT INTO yns_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mpal kàmɛn Mɔsɛ abun, nde kàbem mbɔɔn ntɔn iman mii akin. Wɛɛ mpal kàsin nde tsütsü muler naa nkye ikalyaaŋà, nde kàwɛm ndaa a Mwol yàmutɛn naa: ");
INSERT INTO yns_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","\"Mɛ in'wà Nzam a bàtaaràŋà, Nzam a Abàlam, a Izak anà wà Yakɔb.\" Mɔsɛ kàkyer atɛɛr a bɔɔmà, kàfàkwo anki muler. ");
INSERT INTO yns_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Apan, Mwol waa kun'sam naa: \"Lwoom idyaar abyà kà in'kɔl angye, ntɔn ikal awà ngye kin mà mɛɛn in'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mɛ kàkyàman mpay a un'sɛŋ amɛ u Ngipiti anà in'tär aba. Lalan mɛ an'yàtyà ntɔn mukatsuuŋ. Kyen apanà, mɛ inkwen mukatɔm u Ngipiti.\" ");
INSERT INTO yns_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mɔsɛ awà, ba bàkyer un'tɔn, waa bàtɛn a nde naa: \"Nà kasi mfum anà ntɛɛn?\" Nzam kàkyer un'tɔm asànaa mfum anà ntɛɛn, u mbwo a un'kyeey akwà kàyamɛnà akà nde uboo a ibwiy. ");
INSERT INTO yns_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nde mbuur awà kàtwey baan a Isàlɛl, mukyer impà anà idiim u Ngipiti, u ngyäl a tsöö anà u nsye a ipɔl mbul an'kwem an'nà. ");
INSERT INTO yns_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mɔsɛ nsil awà kàtɛn a baan a Isàlɛl naa: \"Nzam ayàtwey ŋangɔɔm mwɛy asànaa mɛ uboo a atɔŋ abɛ.\" ");
INSERT INTO yns_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mbuur nsil awà, utaaŋ a nköŋ u nsye a ipɔl, nde kàkäl nkalsà a bànkaa abi anà un'kyeey akwà kàtɛɛnà a nde udu a mɔŋ a Sinayi, nde mbuur kàwɛlà ndaa a mɔ̈ɔ̈ ntɔn mupà akà bi. ");
INSERT INTO yns_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Wɛɛ bànkaa abi bàkwen anki mukun'wem, ba bàkyer un'tɔn, an'kyän aba màfurà Ngipiti. ");
INSERT INTO yns_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Abun, ba bàtɛn a Alɔn naa: \"Ikyeer bànzam bàyàkal kusà abi, ntɔn bi iyöb anki naa Mɔsɛ akwà kà itwey u Ngipiti nkye kan'bulà.\" ");
INSERT INTO yns_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Apan, ba bàkyer un'tö a ngɔɔmà, waa bàpɛɛ ibɔɔn akà wa, bàyakyerà un'kyɔm a indiir bàkyerà ba a an'kɔɔ aba. ");
INSERT INTO yns_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wɛɛ Nzam kapɛ ngö, waa kawɛy musyäŋà indiir a du, asànaa bàsön uboo a un'kaan a aŋangɔɔm naa: \"In'sɛŋ a Isàlɛl, nkye kà akà mɛ anki bɛ làpɛɛ ntsür anà ibɔɔn asin mbul an'kwem an'nà u nsye a ipɔl? ");
INSERT INTO yns_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Wɛɛ bɛ làbwäär ntɛn a Mɔlɔk anà mbwaar a nzam abɛ Rɛfan, abi itɛk làkyer bɛ ntɔn bɛ làsyeel bya làkoo. Kyakin, mɛ in'sàkàlasà asɔ lyaaŋ Babilɔn.\" ");
INSERT INTO yns_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","U nsye a ipɔl bànkaa abi bàkäl anà ntɛn a imbäl. Mbuur kàyäämà a Mɔsɛ kun'swɛŋ naa nde ukyer wa asànaa idiim kàmɛn nde. ");
INSERT INTO yns_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Umpal bàwɛl bàtaa abi ya, ba anà Yɔswa bàbiil ya u mɛɛn a in'sɛŋ kàböŋ Nzam kusà aba. Ya yàkäl kwo tii upaŋà a David. ");
INSERT INTO yns_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David kàwɛl kab angway akà Nzam, waa kàlɔ̈m akà nde ikal mutɔŋ ndwà in'kyɛɛl ntɔn ywar a Yakɔb. ");
INSERT INTO yns_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wɛɛ mbuur kun'tööŋ ndwà Salɔmun. ");
INSERT INTO yns_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Wɛɛ Nzam a dudu afàbɔ̈ɔ̈n anki u ndwà bàtöŋ baar kà an'kɔɔ aba, asànaa kàtɛn nde u mun a ŋangɔɔm naa: ");
INSERT INTO yns_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","\"Du là kir a imfum amɛ, mɛɛn mà ikal in'fàsà mɛ in'kɔl amɛ. Ndwà nà bɛ lan'kwo mutööŋ mɛ? Itàkal naa ikal nà mɛ an'kwo muyöör? ");
INSERT INTO yns_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nkye kà an'kɔɔ amɛ anki màkyer indiir abi byanswà?\" ");
INSERT INTO yns_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Bɛ, baar a ibway aŋàbwà un'sey, mpa bàkyɛy mpem anà an'tsü, bɛ làfàmbäär Dweelà In'kyɛɛl taaŋ lanswà! Bɛ, bɛ làbà asànaa bànkaa abɛ. ");
INSERT INTO yns_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Uboo a aŋangɔɔm banswà, nà bànkaa abɛ mpa bàmɛɛy nkwaaŋ? Ba bàdwä baar abà bàkyäänà kusà a ngyeel a mbuur a balàbal mwɛy mpɛl. Wɛɛ ŋàbawà bɛ, bɛ làmun'yälà anà làmun'dwa. ");
INSERT INTO yns_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Bɛ baar làwɛl un'kɔɔn u mbwo a akyeey, wɛɛ bɛ, bɛ wa làfàlab anki! » ");
INSERT INTO yns_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mpal bàwem ba indiir abi, un'fur a nkyɛl kàwɛl mpem aba, waa bàkwoorà an'din. ");
INSERT INTO yns_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wɛɛ nde, nde kàkäl aŋàyɔl a Dweelà In'kyɛɛl, waa kàsyebà du, kàmɛn làkoo a Nzam anà Yɛsu kàkyàbwaay u kɔɔ a Nzam là ibaal. ");
INSERT INTO yns_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Waa kàtɛn naa: « Làler, mɛ in'wàmumanà an'du màŋàduub, Mwan a mbuur wàŋàbwaay u kɔɔ a Nzam là ibaal. » ");
INSERT INTO yns_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Apan, ba bàsi in'kwɛŋ, waa bàdübà an'tsü. Ba banswà waa bun'bürà, ");
INSERT INTO yns_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bun'syen u nsà a bul, waa bun'kämà in'kul. Ambäl ipfɛy aba bàtɔ̈ɔ̈là kà in'kɔl a mwan baal mwɛy ikɔb ande Sɔl. ");
INSERT INTO yns_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mpal bàkäl ba mukun'lomà in'kul, Ityen kàyamà naa: « Mwol Yɛsu, wal dweelà amɛ! » ");
INSERT INTO yns_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Apan, nde kàbü an'köm, waa kàlaal: « Mwol, twon an'tälà buur a ube bà udu a ba! » Ungö mutɛn abà, nde waa kàkü. ");
INSERT INTO yns_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Wɛɛ Sɔl kàkyer akyey nkweel a Ityen. Ilä nsil akin nkwaaŋ a ngwal yàsɛmà ntɔn Ikööŋ a Yɛlusàlɛm. Baar bàkyey ndaa a Nzam banswà bàtɛ upay u Yuday anà u Samàlya. Antööm mpɛl bàsàsal. ");
INSERT INTO yns_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Apan, baar a mpem aŋàbwaŋ bàdyee Ityen, waa bun'lel mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wɛɛ Sɔl kàkyer ngwal mudwa Ikööŋ, nde kàyibilà u ndwà mukɔr abaal anà akaar anà mukabiil u bɔlokà. ");
INSERT INTO yns_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Baar abà bàpää bàyilyaaŋà ntsü anà ntsü mupay Làsaŋ Aŋàbwaŋ là Ndaa. ");
INSERT INTO yns_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Lalan Filipo kàkyen nde bul mwɛy là Samalya mukyään ba làsaŋ a Klistɔ. ");
INSERT INTO yns_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Apan, unsà un'tüüb, in'sɛŋ a baar myàkäl maàŋàbääb u ndaa kàtɛɛnà Filipo ntɔn ba bàweemà anà bàmɛnà impà kàkyerà nde. ");
INSERT INTO yns_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Abun, an'dweelà an'be màkyer atɔɔ akà baar bàkäl anà ma u ndaa a ngwal. Baar aŋàkwɛkà anà ikar bàkyer akɔɔrà. ");
INSERT INTO yns_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Lalan, un'sak kàkäl wàmbɔɔn u bul alan. ");
INSERT INTO yns_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wɛɛ u bul alan kàfwel anà mbuur mwɛy ikɔb ande Simɔn. Nde kàfakyerà inwɛŋ anà kàbemà ngwal un'sɛŋ a Samàlya. Nde kakyeyà uyɔl naa nde mpɛl awà mbuur a kölàköl. ");
INSERT INTO yns_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Apan, baar banswà, sɛmà baan akye tii akà andweer, bun'wemà unsà igyɛɛŋ kyanswà mutɛɛnà naa: « Mbuur awà wà ngwal a Nzam ayà bàfàbel naa: \"Ngwal a kölàköl.\" » ");
INSERT INTO yns_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ba bun'weemà kà igyɛɛŋ, ntɔn ba bàbemà inwɛŋ ande taaŋ mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wɛɛ umpal bàkyey ba Làsaŋ Aŋàbwaŋ là imfum a Nzam anà ikɔb a Yɛsu Klistɔ kàlɔɔŋà Filipo, abaal anà akaar bàwɛl ndüümà. ");
INSERT INTO yns_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔn ŋakwo sye kàsi làkwikilà, waa kàwɛl ndüümà, wɛɛ nde Filipo kun'wɛy anki, ntɔn nde kàkyer abemà muman idiim anà ndaa a ngwal yàlyaaŋà. ");
INSERT INTO yns_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mpal ban'wem Antööm bàkäl u Yɛlusàlɛm naa baar a Samàlya ban'kyey Ndaa a Nzam, ba batööm Petɔlà anà Ywan. ");
INSERT INTO yns_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mpal bàyàkɔlà ba u Samàlya, ba bàyamà ntɔn ba naa ba bàwɛl Dweelà In'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ntɔn Dweelà In'kyɛɛl kàkäl aŋàtàyàtyà anki akà udu a umwɛy uboo a ba: ba badümà mpɛl kà ikɔb a Mwol Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Abun, Petɔlà anà Ywan bàsi an'kɔɔ, ba waa bàwɛl Dweelà In'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Abà kàmɛn Simɔn naa baar bàwɛlà Dweelà mpal basi Antööm an'kɔɔ, nde kàpɛ Petɔlà anà Ywan in'naaŋ, ");
INSERT INTO yns_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","waa kàtɛn naa: « Lan'pɛ mɛ sye ikɔ̈b, ntɔn taaŋ in'yasaa mɛ baar an'kɔɔ ba sye bàwɛl Dweelà In'kyɛɛl. » ");
INSERT INTO yns_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Wɛɛ Petɔlà kun'fuur naa: « Wɛy ngim angye ikü anà ngye ŋakwo ntɔn ngye akasii naa kab a Nzam bàfàsom a in'naaŋ! ");
INSERT INTO yns_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Uboo a ndaa ayi, ngye akà kitiir, akà yar latɛy, ntɔn mpem angye kà yàbalàbal anki kusà a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Buul mpem angye, yamà Mwol ntɔn u taaŋ lumwɛy, nde akyer awem ngyɛb unsà an'kyän awà ngye amà. ");
INSERT INTO yns_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mɛ an'man naa ndandaa ngye awɛ anà ube bàŋàsöön anà ngye awà un'sɔ a ube. » ");
INSERT INTO yns_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Waa Simɔn kàtɛn naa: « Bɛ ŋakwo làyamà Mwol ntɔn mɛ, ntɔn undiir mwɛy ukɔ̈ɔ̈n ayà unsà ya yanswà lan'tɛn bɛ yi. » ");
INSERT INTO yns_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ungö mutà imbäl anà mulɔŋ ndaa a Mwol, ba bàfurà Yɛlusàlɛm. U mbwo ba bàyipayà Làsaŋ Aŋàbwaŋ uboo an'bul mbɔɔn mà Samàlya. ");
INSERT INTO yns_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yàmɛnà naa un'kyeey a Mwol mwɛy kàyääm anà Filipo, waa kàtɛn naa: « Mbarà, kyen ntsü a ngyɛl, u mbwo ifàtyà sɛmà Yɛlusàlɛm tii u Gaza. Mbwo ayi yà ipɔl. » ");
INSERT INTO yns_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Apan Filipo waa kàmbarà, kàkyen agyägyä. Kyekà yɔl mwɛy wà Ɛtyɔpi, mbuur a isal a kölàköl, isal ande musyäl un'naaŋ a Kandase, mfum un'kaar a Ɛtyɔpi, nde kàfü Yɛlusàlɛm ntɔn mukàkömà Nzam. ");
INSERT INTO yns_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mpal kàfurà nde, nde kàkäl aŋàbwaay udu a shar wàmutaŋ un'kaan a ŋangɔɔm Yɛsay. ");
INSERT INTO yns_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dweelà waa kàtɛn a Filipo naa: « Sin, kabweey a shar lanà. » ");
INSERT INTO yns_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Apan, Filipo kàkyà ntiin, waa kàwem mbuur a Ɛtyɔpi wàmutaŋ u ndaa a ngwal un'kaan a ŋangɔɔm Yɛsay. Filipo waa kun'fuul naa: « Nkye ngye akiyöbà ndaa akataŋà ngye yi? » ");
INSERT INTO yns_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nde kàfuur naa: « Mɛ an'kwo muyöb aben, isàkal naa mbuur kan'buul anki? » Nde kàlɔ̈ɔ̈m Filipo mulaar anà mubwaay ukɔl a nde. ");
INSERT INTO yns_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Itiir a ndaa kàtäŋà nde kyaki: « Nde kàkäl asànaa un'kɔk bàfàsyen kà idwääl, asànaa mwan a un'kɔk mpa afàsà ndaa kusà a mbuur awà kun'kɔɔlà in'kà. Lalan nde mun ufàduub anki. ");
INSERT INTO yns_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Uboo a làbɔ̈ɔ̈n ande, nde kàwɛl anki iböŋ. Nà kan'kwo mutɛn ntɔn ikyee ande? Ntɔn mɔ̈ɔ̈ ande bàkyer alwom u mɛɛn. » ");
INSERT INTO yns_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wɛɛ yɔl a Ɛtyɔpi kàfuul Filipo naa: « Mɛ amabɔɔn, nkyään, ntɔn nà ŋangɔɔm ukatɛɛnà nde abà? Ntɔn nde ŋakwo lɛɛ ntɔn mbuur asin? » ");
INSERT INTO yns_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo kàduub mun, waa kàsɛmà kà itiir a ndaa aŋàsɔn aki, mukun'kyään Làsaŋ Aŋàbwaŋ là Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ba bàkäl mulab mbwo aba, waa bàkɔlà kà ikal mwɛy kyàkäl anà an'dà. Yɔl awà kàtɛn naa: « Le an'dà, undiir nà kan'kɔɔn mukan'dümà? » ");
INSERT INTO yns_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Apan, Filipo waa kàtɛn a nde naa: « Isàkal naa ngye an'kyey u mpem angye yanswà, ngye an'kwo awɛl ndüümà. » Mbuur awà waa kàfuur naa: « Mɛ an'kyey naa Yɛsu Klistɔ wà Mwan a Nzam. » ");
INSERT INTO yns_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Apan nde kàswɛŋ mubäm shar ande. Ba bàbɔ̈ɔ̈l, Filipo anà yɔl, bàtɔlà kan'dà, waa Filipo kun'dümà. ");
INSERT INTO yns_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Umpal bàtoo ba kà an'dà, Dweelà a Mwol kàsyen Filipo, yɔl kàfun'man anki. Wɛɛ nde kàläb mbwo ande unsà un'sak. ");
INSERT INTO yns_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Apan, Filipo kàkàmɛnà u Azɔt, nde kàyipayà Làsaŋ Aŋàbwaŋ kà an'bul manswà kàlyaaŋà nde tii u Sɛzarɛ. ");
INSERT INTO yns_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Yàmɛnà naa utaaŋ alan, Sɔl kàkwen anki uwɛy mupà alɔŋki a Mwol mpay a ukwà. Nde kàkàman undweer a angaŋ, ");
INSERT INTO yns_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ntɔn mulɔm in'kaan mubilà u ndwà a nköŋ a Ayudà u Damas, isàkal naa nde kan'man baar, itàkal abaal itàkal akaar abà bàläbà Mbwo, nde waa kakɔr anà katwääl u Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wɛɛ mpal kàkäl nde u mbwo tsütsü a Damas, kà imbürà, un'ŋyäŋ a pɛɛlà kàfü du, waa kun'diŋà. ");
INSERT INTO yns_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nde kàbü u mɛɛn, waa kàwem ndaa yàmutɛɛnà a nde naa: « Sɔl, Sɔl, ntɔn nkye an'mɛɛyà ngye nkwaaŋ? » ");
INSERT INTO yns_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nde kàfuul naa: « Ngye awà nà, Mwol? » Ndaa waa itɛn naa: « Ɛɛ, mɛ in'wà Yɛsu akwà ngye, afàmɛɛy ngye nkwaaŋ. ");
INSERT INTO yns_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Wɛɛ mbarà, bilà uboo a bul, bàkyer akakyään undiir ayàkyer ngye kwo. » ");
INSERT INTO yns_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Abaal kàyilyaaŋà nde abà, bàkyer atsum mun, ba bàweemà ndaa, wɛɛ ba mbuur bàmɛn anki. ");
INSERT INTO yns_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔl kàsubà u mɛɛn, itàkal naa mii ande myàkäl myàŋàduub, nde undiir kàmɛnà anki. Ba bun'te mpi u kɔɔ ntɔn mukun'syen Damas. ");
INSERT INTO yns_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nde kàkäl ilä itär ukɔɔn aman, ukɔɔn adyà anà ukɔɔn anwà. ");
INSERT INTO yns_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kyekà kàkäl anà un'lɔŋki mwɛy u Damas ikɔb ande Ananyas. Mwol kàkàmɛnà akà nde unsà imanmii, waa kàtɛn a nde naa: « Ananyas! » Nde kàfuur naa: « Mɛ awà, Mwol. » ");
INSERT INTO yns_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mwol kàtɛn a nde naa: « Kyen uboo a balàbal bàfàbel balàbal a lää, u ndwà a Yudasi, fuul mbuur mwɛy wà Tarsɛ ikɔb ande Sɔl. Nde wàmukayamà taaŋ nsil alà, ");
INSERT INTO yns_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","wɛɛ uboo a imanmii, nde kan'man mbuur mwɛy ikɔb ande Ananyas wàmubilà anà kàmusà an'kɔɔ ntɔn nde ufàman. » ");
INSERT INTO yns_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananyas waa ufuur naa: « Mwol, mɛ an'wem akà baar mbɔɔn ube banswà kàkyer mbuur awà akà aŋin'kyɛɛl angye u Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kyakin, apà nde kan'yà anà ikɔ̈b bun'pɛ amfum a angaŋ mukɔr baar banswà bàkayamà ikɔb angye. » ");
INSERT INTO yns_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wɛɛ Mwol kàtɛn a nde naa: « Kyen, ntɔn mbuur awà mɛ amun'sɔɔl asànaa un'syääl amɛ musyen ikɔb amɛ kusà a baar mpa abà Ayudà, kusà a amfum anà kusà a baan a Isàlɛl. ");
INSERT INTO yns_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mɛ ŋakwo in'yun'swaŋ indiir byanswà usàman nde mpay ntɔn mɛ. » ");
INSERT INTO yns_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananyas waa kàkyen. Nde kàbilà u ndwà, kun'si an'kɔɔ, waa kàtɛn a nde naa: « Sɔl, un'tɔŋ amɛ, Mwol kàman'tɔm, Yɛsu akwà kàyàmɛnà akà ngye u mbwo kàfü ngye, ntɔn ngye afàman anà akäl aŋàyɔl a Dweelà In'kyɛɛl. » ");
INSERT INTO yns_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Utaaŋ nsil alan, indiir imwɛy asànaa ibal byàbwee fà mii a Sɔl, laa kàfàman nde. Nde waa kambarà, waa bun'dümà. ");
INSERT INTO yns_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ungö apan nde kàkyer adyà, waa kàwɛl ngwal. Sɔl kàkäl ndam a ilä anà alɔŋki bàkäl u Damas. ");
INSERT INTO yns_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Itaan a mbɔɔn anki, nde kàsɛmà mukyään uboo a ndwà a nköŋ a Ayudà naa Yɛsu wà Mwan a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Apan, baar banswà bàweemà nde bàkäl unsà ubem, waa bàtɛɛnà naa: « Nkye wunà kà mbuur akwà anki kàmɛɛyà baar bàfàbel ikɔb aki kwaaŋ u Yɛlusàlɛm? Nkye apà nde kàyi anki ntɔn mukɔr anà musyen ba akamfum a angaŋ? » ");
INSERT INTO yns_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Wɛɛ Sɔl kàkäl ngwal mbɔɔn muswaŋ akà Ayudà bàkäl u Damas naa Yɛsu wà Klistɔ. ");
INSERT INTO yns_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ungö a ilä mbɔɔn, Ayudà banswà bàdirà mukun'dwa. ");
INSERT INTO yns_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Wɛɛ Sɔl kàyöb ndaa ayin. Mpib anà mwäänà, ba bàkaseyà ibeenà a bul alà, ntɔn mukun'dwa. ");
INSERT INTO yns_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Abun, alɔŋki a Sɔl bun'syen u mpib ntɔn mukun'sweey u ntsü yumwɛy yà ibää a bul. Ba bun'twey uboo a un'tɛr. ");
INSERT INTO yns_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Mpal kan'kɔlà nde u Yɛlusàlɛm, Sɔl kàsi mutüüb anà alɔŋki. Wɛɛ ba banswà bàkäl u bɔɔmà, ntɔn ba bàkyey anki naa nde akyàbulà un'lɔŋki ndandaa. ");
INSERT INTO yns_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Abun, Banàbasi waa kun'wɛl, kun'syen akà Antööm, waa kasam ndaa kàmɛn Sɔl Mwol u mbwo anà kàyääm nde anà nde. Nde kasam sye naa Sɔl kàlɔŋ anà uyɔl kà ikɔb a Yɛsu u Damas. ");
INSERT INTO yns_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sɛmà apan, Sɔl kàkälà anà ba u Yɛlusàlɛm anà mulɔŋà anà nuyɔl kà ikɔb a Mwol. ");
INSERT INTO yns_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nde sye kayakyäänà Ayudà bàfatɛɛnà Ingɛlɛki anà kàfasaa mbaaŋ anà ba. Wɛɛ ba bàlɛŋà mukun'dwa. ");
INSERT INTO yns_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mpal ban'wem atɔŋ ndaa ayi, ba bun'syen Sɛzarɛ, akun ba bun'töm Tarse. ");
INSERT INTO yns_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","U Yuday lanswà, sɛmà Ngalilɛ anà Samàlya, Ikööŋ kyanswà kyàkäl unsà duu, kyàwɛlà ngwal, kyàwemà Mwol bɔɔmà, anà kyàyɛlà u ngwal a Dweelà In'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Yàmɛnà naa Petɔlà kàfilyaŋà ntsü yanswà, waa kàtyà sye akà baar in'kyɛɛl bàkäl u Lidà. ");
INSERT INTO yns_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nde kàmɛn mbuur mwɛy kwo ikɔb ande Ɛnɛ, wàŋàbɔ̈ɔ̈n udu a ntäŋ, fà mbul naan nde kàkäl aŋàkwɛkà. ");
INSERT INTO yns_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petɔlà kàtɛn a nde naa: « Ɛnɛ, Yɛsu Klistɔ kàmakɔɔr! Mbarà, bwɛlà ntäŋ angye, ngye ŋakwo. » Apan sye, Ɛnɛ waa kambarà. ");
INSERT INTO yns_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mpal bun'mɛn baar a Lidà anà baar a Sarɔn banswà, ba bàbuul mpem aba amu Mwol. ");
INSERT INTO yns_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","U Yɔpɛ kàkäl anà un'lɔŋki mwɛy wà un'kaar ikɔb ande Tabità, ikaswaŋà naa Dɔkasi u ndaa aba, waa ifiswaŋà naa Nsey. Taaŋ lanswà nde kàfakyerà ndaa aŋàbwaŋ anà kàfabayà aŋàlàmbwà. ");
INSERT INTO yns_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Umpal ayin, nde kàkyer abɛɛl, waa kàkü. Ungö mukun'ywɛy, ba bun'si u suk adu. ");
INSERT INTO yns_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mpal bàwem alɔŋki a Yɔpɛ naa Petɔlà wà u Lidà, bul a tsütsü anà ba, ba bàtöm abaal abɔ̈ɔ̈l ntɔn mukun'bel anà mutɛn naa: « Bi kàmabɔɔn, yà akà bi làgyägyä. » ");
INSERT INTO yns_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Apan, Petɔlà waa kàmbarà, waa kàkyen anà ba. Umpal kàkɔlà nde, ba bun'syen u suk adu. Akweel adim bàyi kusà a nde, bàmulel anà muswaŋ ba inkur anà ipfɛy a mpye kàfakyerà Dɔkasi mpal bàkäl ba banswà. ");
INSERT INTO yns_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Apan, Petɔlà kàtwey baar banswà, nde kàbü an'köm, kàyamà, waa kàbulà ntsü yàkäl ndom anà mutɛn naa: « Tabità, mbarà! » Nde kàduub mii, mpal kàmɛn nde Petɔlà, waa kàbwaay. ");
INSERT INTO yns_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Abun, Petɔlà kàsilà kɔɔ ande, waa kun'mbaar. Nde kàbel baar in'kyɛɛl anà akweel adim, waa kun'mɛɛy, wà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Baar a Yɔpɛ banswà bàwem ba ndaa ayi, bàmbɔɔn bàsi làkwikilà akà Mwol. ");
INSERT INTO yns_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petɔlà kàkäl ilä mbɔɔn u Yɔpɛ akà un'kwaam a ibaan, ikɔb ande Simɔn. ");
INSERT INTO yns_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","U Sԑzarԑ kàkäl anà mbuur mwԑy ikↄb ande Kↄlↄnԑlyↄ. Nde kàkäl kaptԑn a iköŋ a aŋità a Lↄmà bàfàbel naa « iköŋ a Itali. » ");
INSERT INTO yns_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nde kàkäl anà inzaam, nde anà ywar ande lanswà bàweemà Nzam bɔɔmà. Nde kàfabayà baar mbɔɔn anà kàfayamà Nzam taaŋ lanswà. ");
INSERT INTO yns_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ilä mwԑy, u ntsü a taaŋ làtär ungö a midi, nde kàmԑn ubwaŋàbwaŋ unsà imanmii un'kyeey a Nzam mwԑy kan'yàbilà u ndwà ande, waa kan'tɛn a nde naa: « Kↄlↄnԑlyↄ! » ");
INSERT INTO yns_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔlɔnɛlyɔ kun'ler a lää, kun'wem bↄↄmà, waa kun'fuul naa: « Mwol, ininà abi? » Un'kyeey waa kun'fuur naa: « Ngyamàkà angye anà nkääb angye yàkyàbeenà u mii a Nzam, nde waa kan'yɔbà ya. ");
INSERT INTO yns_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wɛɛ apanà, tↄm baar u Yↄpԑ mukàbel mbuur mwɛy ikɔb ande Simↄn, bàfun'bel Petↄlà. ");
INSERT INTO yns_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nde afàbɔ̈ɔ̈n u ndwà a mbuur mwԑy ikɔb ande Simↄn, nde wà un'kwaam a ibaan a ntsür. Ndwà ande yà kà un'kɔɔl a ngyäl a kölàköl. » ");
INSERT INTO yns_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ungö a nkyeen a un'kyeey kàyun'kyään ndaa ayi, Kↄlↄnԑlyↄ kàbel asyääl ande abɔ̈ɔ̈l anà ŋità mwԑy kàkäl anà inzaam anà kàkäl wàŋàbääb anà nde taaŋ mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ungö mukakyään indiir byanswà byalyaaŋ, nde katöm Yↄpԑ. ");
INSERT INTO yns_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","U taaŋtyà, ba bàkäl u mbwo, tsütsü a Yↄpԑ, Petɔlà kàlär kà ikal bàfàyöör mper a midi ntↄn muyamà. ");
INSERT INTO yns_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nde kàwem ngyal, waa kàkwen mudyà. Mpal bàkäl ba mukun'läämà isaa, nde kàmԑn imanmii. ");
INSERT INTO yns_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nde kàmԑn du lan'dubà, undiir mwԑy asànaa yar a ipfԑy a kölàköl làŋàbääm in'siŋ kà an'twɛrà man'nà, lan'yàtyà anà lan'yàtↄlà u mԑԑn. ");
INSERT INTO yns_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Uboo a la yàkäl anà ntsür a ifà ifà: ntsür a in'kɔl in'nà, ntsür ifilaan u mԑԑn anà nԑn a du. ");
INSERT INTO yns_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ndaa mwԑy yàtɛn a nde naa: « Petↄlà, mbarà, dwa anà dyà! » ");
INSERT INTO yns_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Wԑԑ Petɔlà kàfuur naa: « Mwol, ikwo anki akà ikikye, ntɔn mԑ ŋàtàdyà anki undiir wanswà wàlàbiin anà wàŋingyäy. » ");
INSERT INTO yns_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Wɛɛ nde an'fàwem ndaa mbalà yàyweel: « Ngye, twon an'bel ŋingyäy indiir kan'pööŋ Nzam. » ");
INSERT INTO yns_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ya yàkɔlà mbalà tär, ungö apan, undiir awun bàfuur u du. ");
INSERT INTO yns_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petↄlà kàkäl unsà lingyoomà anà muyweerà nde ŋakwo naa imanmii kàmԑn nde ki ikaswaŋà aben. Kyekà taaŋ nsil alan, baar kàtöm Kↄlↄnԑlyↄ bàkäl u munàmbwo bàmufuulà ndwà a Simↄn. ");
INSERT INTO yns_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ba bàbel u ndaa a ngwal, waa bàfuul naa: « Nkye Simↄn awà bàfàbel naa Petↄlà afàbɔ̈ɔ̈n apà? » ");
INSERT INTO yns_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Apan Petↄlà kàkäl mukayweerà u mpem ande ntↄn imanmii akyà kàmԑn nde ki, Dweelà kàtɛn a nde naa: « Le, baar atär bàmukaleŋà. ");
INSERT INTO yns_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mbarà, tyà, kyen mbwo mwԑy anà ba ukɔɔn nkyɛɛr, ntↄn ba mԑ, mɛ amatↄm. » ");
INSERT INTO yns_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Undiir awun, Petↄlà kàtɔlà nde, waa kàtɛn a baar aban naa: « Le, mԑ in'wà mbuur làleŋà bԑ. Ntɔn nkye làyi bɛ? » ");
INSERT INTO yns_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ba bàtɛn naa: « Kaptɛn Kↄlↄnԑlyↄ kàmitↄm. Nde wà mbuur mwԑy wà balàbal anà afàtiin Nzam bɔɔmà. Nde sye we anà imbäl aŋàbwaŋ akà un'sԑŋ a Ayudà wanswà. Un'kyeey in'kyɛɛl mwԑy kun'swԑŋ naa nde akyer ayabel u ndwà ande, ntↄn ngye awem ndaa awà nde ayà mukakyään. » ");
INSERT INTO yns_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Apan, Petɔlà waa kabiil anà kapɛ ikal abɔ̈ɔ̈n. Taaŋtyà nde kàkyen anà ba mbwo mwɛy anà atɔŋ amwɛy bà Yɔpɛ. ");
INSERT INTO yns_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kà ilä kyàlääb, nde kàkɔlà Sɛzarɛ. Kɔlɔnɛlyɔ awà kàkäl mudilà ba, kàbel ywar ande anà asam ande bànkwen. ");
INSERT INTO yns_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Umpal kàkɔlà Petɔlà, Kɔlɔnɛlyɔ kàyàbwey anà nde, waa kàbü kà in'kↄl ande ntɔn mukun'sà làkoo. ");
INSERT INTO yns_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petɔlà waa kumbaar, kàtɛn a nde naa: « Mbarà, ntↄn mԑ, mɛ sye in'wà kàmɛ mbuur. » ");
INSERT INTO yns_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Apan, Petↄlà kàkäl muyiyääm a Kↄlↄnԑlyↄ umpal kàbilà nde u ndwà, waa kàmԑn baar mbɔɔn bàkyàköŋ. ");
INSERT INTO yns_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nde kàtɛn a ba naa: « Bԑ, bԑ làkyàyöb naa wà ikin naa un'yudà mwԑy utüüb itàkal usin tsütsü apà ungyey. Wԑԑ mԑ, Nzam kan'mɛɛy naa twon an'tɛn a mbuur naa nde wà làbiin itàkal naa ŋingyäy. ");
INSERT INTO yns_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Undiir awun, mԑ an'yà mԑ ukɔↄn asà impeen u làbeel angye. Wɛɛ apanà, mԑ in'kwen muyöb ntɔn atöm ngye baar muyan'bel. » ");
INSERT INTO yns_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Apan Kↄlↄnԑlyↄ kàtɛn a nde naa: « Ŋàbà ilä kyànà, mԑ kàkäl u ngyamàkà u ndwà amԑ, u taaŋ làtär ungö a midi, wɛɛ le, mbuur mwԑy kàkyàbwaar ipfԑy a iŋyäŋ akyàmbar kusà a mԑ, ");
INSERT INTO yns_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","nde kan'kyään naa: \"Kↄlↄnԑlyↄ, Nzam akyàwem ngyamàkà angye, anà akyàyɔbà nkääb angye. ");
INSERT INTO yns_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tↄm baar u Yↄpԑ mukàbel Simↄn awà bàfàbeel Petↄlà. Nde wà u ndwà a Simↄn un'kwaam a ibaan a ntsür. Ndwà ande yà kà un'kↄↄl a ngyäl.\" ");
INSERT INTO yns_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Làgyägyä, mԑ waa atööm baar muyabel. Ngye, ngye waa akyey muyà. Apanà bi, bi banswà ibà kusà a Nzam ntↄn muwem indiir byanswà kaswɛŋ Mwol. » ");
INSERT INTO yns_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Abun, Petↄlà kàduub mun mutԑn naa: « Mԑ in'kyàyöb ndandaa naa Nzam un'kↄl aŋàyↄŋ afàkyer anki, ");
INSERT INTO yns_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","wԑԑ unsà un'sɛŋ wanswà, mbuur afun'man bɔɔmà anà afàkyer ndaa a balàbal, nde akyer afun'kyey. ");
INSERT INTO yns_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nde kàtöm ndaa ande akà un'sԑŋ a Isàlԑl, mukyään Làsaŋ Aŋàbwaŋ là duu u mbwo a Yԑsu Klistↄ awà Mwol a baar banswà. ");
INSERT INTO yns_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Bԑ, bԑ làkyàyöb ndaa yàsԑmà u Ngalilԑ anà yàpää u Yuday lanswà ungö a ndüümà kàlↄɔŋà Ywan. ");
INSERT INTO yns_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Bԑ, bɛ làkyàyöb naa Nzam kàtsüül Dweelà In'kyɛɛl anà kàpɛ ngwal udu a Yɛsu un'nsi Nasàlɛr awà kàyilyaaŋà mukyer ubwaŋ anà mukɔɔr baar bàkäl uboo a ikɔ̈b a Satanà, ntɔn Nzam kàkäl anà nde. ");
INSERT INTO yns_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Anà bi sye, bi ibà ambäl a indiir byanswà kàkyer nde u mɛɛn a Ayudà anà u Yɛlusàlɛm. Nde sye wà mbuur bàdwä ba anà bàbɛɛrà ba u kulunsi, ");
INSERT INTO yns_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","wɛɛ Nzam kun'wiiy kilä kyàtär, waa kun'pɛ mbwo muyàmɛnà, ");
INSERT INTO yns_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kakun'sԑŋ wanswà anki, wԑԑ akà bi, bi baar abà kàsɔ̈ɔ̈l Nzam kusà asànaa ambäl, bi baar kàdi anà kànü anà nde ungö a ngwiiyà ande uboo a akü. ");
INSERT INTO yns_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Apan Yɛsu kà iswԑŋ mukyään un'sԑŋ anà mutà imbäl naa Nzam nde kàsɔ̈ɔ̈l mukal nkalsà a baar a mɔ̈ɔ̈ anà akü. ");
INSERT INTO yns_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Aŋangↄↄm banswà bun'tɛɛl imbäl, mutɛn naa mbuur wanswà asun'wal anà asàsà làkwikilà amu nde, bàsun'dwääl nkul a man'be ande u mbwo a ikɔ̈b a Ikↄb ande. » ");
INSERT INTO yns_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Umpal kàkäl Petↄlà mutɛɛnà ndaa ayi, Dweelà In'kyɛԑl kàbü udu a baar banswà bàweemà ndaa kàlↄɔŋà nde. ");
INSERT INTO yns_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wԑԑ aŋàlàkwikilà bàŋàkyɛy abà bàyi mbwo mwԑy anà Petↄlà bàkäl unsà ubem muman naa Dweelà In'kyɛԑl kàpää sye udu a baar mpa abà Ayudà. ");
INSERT INTO yns_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Abun, ba bàweemà naa ba bàmutԑɛnà u ndaa a ingyey anà bàmusyäŋà Nzam. Apan, Petↄlà kàtԑn naa: ");
INSERT INTO yns_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","« Taaŋ alà, nkye we anà mbuur kan'kwo mutsuŋ an'dà a ndüümà akà baar ban'wal Dweelà In'kyɛԑl bà asànaa bi? » ");
INSERT INTO yns_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Apan, nde kàswԑŋ naa badümà kà ikↄb a Yԑsu Klistↄ. Ba bun'lɔ̈ɔ̈m naa nde ubwaay ndam a ilä apà ba. ");
INSERT INTO yns_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Antööm anà atↄŋ bàkäl u Yuday bàwem naa baar mpa abà Ayudà sye ban'wal Ndaa a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Wԑԑ mpal kàbeenà Petↄlà Yԑlusàlԑm, baar bàŋàkyԑy bàkäl musà mbaaŋ anà nde. ");
INSERT INTO yns_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ba bàtԑn a nde naa: « Ngye an'kàbilà u ndwà a baar bàkɔ̈ɔ̈n aŋàkyԑy anà an'kàdyà ikal imwԑy anà ba. » ");
INSERT INTO yns_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Apan, Petɔlà kàsԑmà mukakyään ndaa yanswà pànsi pànsi asànaa yàlyaaŋ ya. Waa kàtɛn a ba naa: ");
INSERT INTO yns_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","« Mԑ, mɛ kàkäl uboo a Yↄpԑ muyamà, laa kàkabà mɛ, waa kàmԑn imanmii: undiir mwԑy kan'fà du wàŋàbäm in'siŋ a bwԑlàbwԑl kà an'twԑrà man'nà asànaa yar a ipfԑy. ");
INSERT INTO yns_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mpal kàsyeebà mɛ boo awa ubwaŋàbwaŋ, mɛ kàmԑn ntsür a in'kↄl in'nà, ntsür a ndwaŋ, ntsür ifilaan u mɛɛn anà nԑn a du. ");
INSERT INTO yns_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Apan, mɛ kàwem ndaa mwԑy yàmukan'kyäänà naa: \"Petↄlà, kyen, dwa, dyà.\" ");
INSERT INTO yns_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Wԑԑ mԑ kàtԑn naa: \"Aay, Mwol, akà undiir mwԑy wà ikin itàkal wàŋingyäy ŋatàbilà anki u mun amԑ.\" ");
INSERT INTO yns_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ndaa yan'fàfà du mbalà yàyweel, yan'fuur naa: \"Indiir kàpɔŋà Nzam, twon an'bel bya mbiin.\" ");
INSERT INTO yns_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ndaa ayi yàkyer abà mbalà tär. Ungö, indiir byanswà byàfurà du. ");
INSERT INTO yns_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kyekà taaŋ nsil alan, abaal atär bàyàkↄlà u ndwà kàkäl bi. Ba ban'tööm abà u Sɛzarɛ. ");
INSERT INTO yns_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Apan, Dweelà kan'kyään naa mԑ in'kyen mbwo mwԑy anà ba ukɔɔn nkyɛɛr. Atɔŋ bà basyaam bàyan'swà. Bi banswà kàkàbilà u ndwà a mbuur awun. ");
INSERT INTO yns_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nde kà ikyään naa un'kyeey kàyàmԑnà aben u ndwà ande anà kun'kyään naa: \"Tↄm mbuur mwey u Yↄpԑ mukàbel Simↄn awà bàfàbel naa Petↄlà. ");
INSERT INTO yns_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nde ayakyään ndaa yanswà iyàtswà ngye mɔ̈ɔ̈ anà ndwà angye yanswà.\" ");
INSERT INTO yns_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pa kàsɛmà mɛ mutԑn, Dweelà kàyàtyà udu a ba asànaa kàyàtyà nde udu a bi u nsɛmà. ");
INSERT INTO yns_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Apan, mɛ kàyↄbà ndaa kàtԑn Mwol naa: \"Ywan kàfadümà kà an'dà. Wԑԑ bԑ, bԑ bàsàladümà u Dweelà In'kyԑɛl.\" ");
INSERT INTO yns_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Abun, Nzam kapԑ kab nsil la asànaa kàpԑ nde bi umpal kàsi bi làkwikillà amu Yԑsu Klistↄ, mԑ, mɛ kàkäl nà mutsuŋ Nzam? » ");
INSERT INTO yns_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ungö bàwem ba ndaa ayi, ba bàkäl a duu, bàsi Nzam làkoo, waa bàtԑn naa: « Abà Nzam kan'pà mbwo sye akà baar mpa abà Ayudà musↄↄmà nkääl aba anà muwal mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Yàmԑnà naa aŋàlàkwikilà bàkyer atà upay mper yanswà ntɔn nkwaaŋ bamɛɛy mpal bàdwä Ityen. Ba bàkàkɔlà anà u Fԑnisi, u Shipԑlɛ anà Antyↄsha. Wԑԑ ba Ndaa a Nzam bàyilↄɔŋà Ayudà mpԑl. ");
INSERT INTO yns_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wԑԑ bumwԑy bàkäl baar a Shipԑlɛ anà Sirԑn. Umpal bàtöl ba Antyↄsha, ba bàkyäänà Làsaŋ Aŋàbwaŋ là Mwol Yɛsu akà Angԑlԑki sye. ");
INSERT INTO yns_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kↄↄ a Mwol làkäl anà ba, undiir awun baar mbↄↄn bàsi ba làkwikilà anà bàbuul ba mpem akà Mwol. ");
INSERT INTO yns_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mpal kyàwem Ikööŋ a Yԑlusàlԑm ndaa ayi, ba bàtöm Banabasi u Antyↄsha. ");
INSERT INTO yns_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Umpal kàtöl nde anà kàmԑn nde kab a ngway a Nzam, nde kàmԑn un'sak, nde kàlɔ̈ɔ̈m ba banswà mukal uboo a un'tüüb a Mwol u mpem aba yanswà. ");
INSERT INTO yns_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ntɔn nde kàkäl mbuur mwԑy wàŋàbwaŋ, wàŋàyↄl a Dweelà In'kyɛԑl anà làkwikilà. Apan, un'kàbɔ a baar kàyàtüüb anà Mwol. ");
INSERT INTO yns_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ungö apan, Banabasi kàkyen Tarsis mukàleŋ Sↄl. ");
INSERT INTO yns_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Umpal kun'mԑn nde, nde kun'twääl u Antyↄsha. Ba bàkyer mbul mwԑy aŋun'kiinà musal mbwo mwԑy anà mulↄŋ iköŋ a baar uboo a Ikööŋ. Ya yàkäl mbalà atàtwԑb u Antyↄsha bàbel ba alↄŋki naa aklistↄ. ");
INSERT INTO yns_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kà ilä abin, aŋangↄↄm bàfü Yԑlusàlԑm bàyàtyà Antyↄsha. ");
INSERT INTO yns_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Wԑԑ umwԑy uboo aba, ikↄb ande Agabüs, kàkyer ambarà, waa kàkyään u mbwo a Dweelà naa ngyal mbɔɔn ikyer ayàbilà u mԑԑn manswà. Ya sye yàkäl abun u paŋà a Kɔlↄde. ");
INSERT INTO yns_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Abun, alↄŋki bàtsül mbar naa mbuur mbuur upԑ kab kan'kwo nde mupà ntɔn mutööm atↄŋ abà u Yuday. ");
INSERT INTO yns_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ba bàkyer abun sye, waa bàtöm an'kab aman akà andweer u mbwo a Banabasi anà Sↄl. ");
INSERT INTO yns_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Yàmԑnà naa utaaŋ alan, mfum Ɛlↄdi kàsԑmà mumԑɛy baar a Ikööŋ bàmwɛy nkwaaŋ. ");
INSERT INTO yns_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nde kàdwä Zyak, un'tↄŋ a Ywan wàbaal, a kↄm. ");
INSERT INTO yns_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Mpal kàmԑn nde naa ya yan'pà Ayudà un'sak, nde kàfàkɔr Petↄlà ilä a mampà ikɔ̈ɔ̈n ful. ");
INSERT INTO yns_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ungö mukun'kɔr, nde kun'tↄↄm u bɔlokà, kun'pԑ kan'kↄↄ a itsuŋ inà bye abyà aŋità anà uboo a imwɛy ntɔn mukun'kaar. Nde kàkwen mukun'sà u làbay a nsaŋ u mii a un'sɛŋ ungö mukyɛɛl Pak. ");
INSERT INTO yns_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petↄlà bun'käär u bↄlokà. Wԑԑ Ikööŋ kyàyɔ̈n anki musà ngyamàkà akà Nzam ntↄn nde. ");
INSERT INTO yns_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Wԑԑ u mpib, kusà a ilä kàbön Ɛlↄdi mutsul nsaŋ ande u mii a un'sɛŋ, Petↄlà kàkäl wàŋàbɔ̈ɔ̈n uboboo a aŋità abɔ̈ɔ̈l, wàŋàbääm an'dwaaŋ mɔ̈ɔ̈l. Aseey a bↄlokà bàkäl u munàmbwo. ");
INSERT INTO yns_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Wԑԑ kà imbürà, un'kyeey a Mwol mwԑy waa kàyàmԑnà, bↄlokà waa làpԑԑlà. Un'kyeey kàni Petɔlà u làbɛm, kun'wiiy, waa kàtɛn a nde naa: « Mbarà agyägyä! » Apan, an'dwaaŋ màkäl kà an'kↄↄ ande waa màbü. ");
INSERT INTO yns_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Un'kyeey kàtɛn a nde naa: « Bäm un'kab angye, bwaar idyäär angye. » Nde waa kàkyer abun. Nde kàfàtɛn a nde naa: « Bwaar ipfɛy angye, yan'läb. » ");
INSERT INTO yns_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nde kàkyer atoo, waa kun'läb. Wԑԑ nde kàyöb anki naa ndaa kàkyerà un'kyeey yàkäl ndandaa. Nde kàsii naa kya kyà imanmii. ");
INSERT INTO yns_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Apan ba bàlyaaŋ ikal a nseey kyàtàtwԑb, bàfàlyaaŋ kyàyweel, waa bàtöl u munàmbwo awe anà ibeenà a in'naan ifàler mper a bul. Ibeenà aki kyàdubà kya ŋakwo kusà a ba. Ba waa bàtoo, bàyikyeenà u balàbal làmwey. Apan, un'kyeey kàsun'wɛy kà imbürà. ");
INSERT INTO yns_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mpal màfurà an'kyän a Petↄlà, nde kàtԑn naa: « Apanà mԑ an'yöb naa ndandaa Mwol kàtöm un'kyeey ande, nde kàman'tsuuŋ kà an'kↄↄ a Ɛlↄdi anà akà yinà yanswà kàdiilà un'sԑŋ a Ayudà. » ");
INSERT INTO yns_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ungö kàyöb nde abun, nde kàkyen ndwà a Màlye, ngwän a Ywan awà bàfàbel Malakↄ. Akun, baar mbɔɔn bàkyer aköŋ anà bàkäl muyamà. ");
INSERT INTO yns_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mpal kàbԑԑrà nde kà ibeenà a munàmbwo, un'syääl mwɛy wà un'kaar ikↄb ande Lↄdԑ waa kàsin muwem. ");
INSERT INTO yns_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nde kàyöb ndaa a Petↄlà. Wԑԑ unsà un'sak ande, nde kàduub anki ndwà, nde kàkyen u ntiin ntↄn mukàkyään naa Petↄlà wàŋàmbar u nsà. ");
INSERT INTO yns_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wԑԑ ba bàtԑn a nde naa: « Ngye awe anà nukↄŋ. » Wԑԑ nde kàsi muküünà mutɛn naa yà ndandaa. Apan, ba bàtɛn naa: « Un'kyeey ande ayàkal. » ");
INSERT INTO yns_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Wԑԑ Petↄlà kàsi muküünà mubԑԑrà. Ba bàduub ndwà, waa bàbem mpal bun'mɛn ba. ");
INSERT INTO yns_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wɛɛ akà nde, nde kadübà mun a kↄↄ ntɔn mukaswaŋ naa ba bàkäl a duu, nde kakyään naa Mwol kàkyer aben mukun'twey u nsà a bↄlokà. Nde kàtԑn sye naa: « Kyen kàlakyään Zyak anà atↄŋ bumwԑy indiir abi. » Apan, nde waa kàtoo, kàkyen mper asin. ");
INSERT INTO yns_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wԑԑ mpal làtyà taaŋ, lingyoomà làbü uboo a aŋità, ba bàtԑn ba a ba naa Petↄlà nkye byàmubweel? ");
INSERT INTO yns_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ɛlↄdi kàkäl muyun'leŋ, wԑԑ nde kun'mɛn anki. Nde kàfuul aleer, waa kàswɛŋ naa basyen anà badwä. Ungö nde kàlwomà u Yuday, waa kàtyà Sԑzarԑ. Nde kàkäl ndam a ilä kwo. ");
INSERT INTO yns_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ɛlↄdi kàkäl nkyԑl mbↄↄn akà baar a Tir anà Sidↄn. Wԑԑ ba bàkäl un'tüüb mwԑy ntↄn mukun'man. An'yääm a ba anà Balàstüs, mbuur kàfaleerà suk a mfum, màkyer abwaŋ. Ungö ba bàkàlɔm mfum Ɛlↄdi musà duu uboo a ba, ntↄn udyà aba bàfafaa nsi a mfum Ɛlↄdi. ");
INSERT INTO yns_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mpal kyàkwe ilä bàsi ba, Ɛlↄdi kàbwäär ipfԑy a imfum, laa kàbwaay de kà un'syäl, waa kàtɛɛnà a ba u mii a un'sԑŋ. ");
INSERT INTO yns_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Apan, un'sԑŋ kàtԑn u ndaa a ngwal naa: « Ayi ntɛɛn a nzam mwɛy, wԑԑ kà yà mbuur anki. » ");
INSERT INTO yns_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wԑԑ utaaŋ nsil alan, un'kyeey a Mwol waa kun'düb, ntↄn nde Nzam làkoo kun'pԑ anki. In'swab myàkyer un'dyà, laa kàkü nde. ");
INSERT INTO yns_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Apan, Ndaa a Nzam waa yàyԑl, waa yàpää. ");
INSERT INTO yns_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Wԑԑ akà Banabasi anà Sↄl, mpal bàmay ba isal aba u Yԑlusàlԑm, ba bàkyer akyà, waa bàsyen anà Ywan awà bàfàbel Malakↄ. ");
INSERT INTO yns_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kà Ikööŋ a Antyↄsha bàkäl anà aŋangↄↄm anà alɔɔŋ asànaa Banabasi, Simԑyↄ awà bàfàbel Nizyԑr anà Lusyus un'nsi Sirԑn, Manayԑn un'sam a Ɛlↄdi fà imbԑy, anà Sↄl. ");
INSERT INTO yns_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mpal bàkäl ba musyäŋà Mwol anà mukin mbɔr, Dweelà In'kyԑԑl kàtԑn naa: « Lasi Banabasi anà Sↄl ukↄl, ntↄn mukyer isal kabel mԑ. » ");
INSERT INTO yns_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Abun, ungö ukin mbɔr anà uyamà, ba basi an'kↄↄ, waa bapɛ mbwo mukyà. ");
INSERT INTO yns_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Wɛɛ akà Banabasi anà Sɔl, Dweelà In'kyɛɛl katöm nde, ba bàtyà Sԑlusi, akun ba bàwԑl an'swà mukyà isaŋ a Shipԑlɛ. ");
INSERT INTO yns_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mpal bàtöl ba u Salamin, ba bàkyäänà ndaa a Nzam uboo a ndwà a nköŋ a Ayudà. Ywan kàkäl anà ba sye ntɔn mukabay. ");
INSERT INTO yns_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ungö mulyaaŋ uboo a isaŋ kyanswà tii u Pafↄsi, ba bàbweey anà un'kyeer a inwɛŋ mwԑy, ŋangↄↄm a loor wà un'yudà, ikↄb ande Bar Yԑsu, ");
INSERT INTO yns_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","nde kàkälà tsütsü a Pawulus Sԑrzyus, mfum a Isaŋ a Shipԑle. Nde kàbel Banabasi anà Sↄl ntↄn mukakyään naa nde we anà ngyal muwem Ndaa a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Wԑԑ un'kyeer a inwɛŋ Ԑlimasi, ayi mbuul a ikɔb ande, laa kàtön nde, ntↄn nde ndaa aba kakyeyà anki, nde kàleŋà naa mfum ukɔɔn akal anà làkwikilà. ");
INSERT INTO yns_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Apan, Sↄl awà bàfàbel sye Pↄl, awà kàkäl aŋàyↄl a Dweelà In'kyɛԑl, kun'paam mii, ");
INSERT INTO yns_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","waa kàtɛn naa: « Ngye awàŋàyↄl a an'yeerà anà an'kyän an'be, mwan a ileŋ, un'yiiŋ a ndaa a balàbal yanswà, taaŋ nà ngye asàwԑy mubääm an'kyän a balàbal mà Mwol? ");
INSERT INTO yns_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Wԑԑ papanà, wem: Mwol akyer akam un'swaŋ, ngye abulà ikwàmii, u ndam a an'taaŋ, ngye mwäänà aman anki. » Utaaŋ nsil alan, un'böŋ anà làpib myun'bweel u mii, nde kàbulà muyoyoolà, wàmuyileŋ naa mbuur kun'twääl u kↄↄ. ");
INSERT INTO yns_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Undiir awun, mpal kàmԑn mfum ndaa yàlyaaŋ yi, nde kàsi làkwikilà, ntↄn an'lɔɔŋ a Mwol màkyer un'bilà ubwaŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pↄl anà baar bàyikyeenà anà nde, bàwԑl an'swà u Pafɔs ntɔn mukyà Pɛrzɛ u Pamfili. Ywan kàkaabà anà ba, waa kàfurà Yԑlusàlԑm. ");
INSERT INTO yns_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wԑԑ ba, ba bàläb mbwo aba: bàlwomà ba u Pԑrzɛ, ba bàkyen Antyↄsha u Pisidi. Ilä a saba, ba bàbilà u ndwà a nköŋ a Ayudà, waa bàbwaay. ");
INSERT INTO yns_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ungö mutaŋ un'kɔɔn anà aŋangↄↄm, amfum a ndwà a nköŋ a Ayudà balɔ̈ɔ̈m naa: « Atↄŋ, kya isàkal naa bԑ làbye anà undiir atԑn akà baar ntↄn mukalɛɛl, làtԑn! » ");
INSERT INTO yns_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Apan, Pↄl waa kàmbarà, kàswɛŋ isii a kɔɔ, waa kàtԑn naa: « Bԑ baar a Isàlԑl anà bԑ bumwԑy làfàtiin Nzam bↄↄmà, làwem! ");
INSERT INTO yns_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nzam a un'sԑŋ a Isàlԑl wà, kàsɔ̈ɔ̈l bàtaa abi. Nde kàbuul wa wàkölàköl mpal kàkäl wa u mɛɛn a Ngipiti. Wԑԑ u ngwal a kↄↄ ande, nde kun'twey kwo. ");
INSERT INTO yns_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Wԑԑ nde ba kasyen kà isii a mbul an'kwem an'nà mpal bàkäl ba u nsye a ipↄl. ");
INSERT INTO yns_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ungö, kàmay nde in'sԑŋ nsambwaar u mɛɛn a Kanana, nde kakääb mԑԑn mukal un'naaŋ aba ");
INSERT INTO yns_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","kà isii a mbul nkam nà a an'kwem an'tyeen. « Ungö apan, nde kapԑ ntɛɛn tii utaaŋ a ŋangↄↄm Sàmwel. ");
INSERT INTO yns_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Wɛɛ semà apan, ba bàlöm mfum, kyakin Nzam kapԑ nde Sawul, mwan a Kisi, umwԑy uboo a mbil a Bԑnsàmԑn. Nde kàyaal mbul an'kwem an'nà. ");
INSERT INTO yns_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Wԑԑ ungö, Nzam waa kun'tön, waa kàtwey David mukal mfum aba. Ntɔn nde, nde kàtɛ imbäl ki: \"Mԑ aman David, mwan a Yɛsɛ, mbuur kan'kwen mpem amԑ, nde ayakyerà ndaa yanswà in'kwen mԑ.\" ");
INSERT INTO yns_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Unsà ikyee ande, Nzam kàtwey Yԑsu, Un'tswää a mɔ̈ɔ̈ a Isàlԑl, asànaa kàpɛ nde ilää. ");
INSERT INTO yns_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kusà a ngyeel ande, Ywan kàlɔŋ un'sԑŋ a Isàlԑl wanswà ndüümà a mbuul a mpem. ");
INSERT INTO yns_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Wԑԑ mpal kàkäl Ywan mumay isal ande, nde kàtɛɛnà naa: \"Bԑԑ làsii naa mԑ in'wà nà? Mԑ kà in'wà mbuur làdilà bԑ anki! Wԑԑ làwem: we anà mbuur ayàyà ungö amԑ, mԑ in'kwe anki musɔↄl idyäär kà in'kɔl ande.\" » ");
INSERT INTO yns_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","« Atↄŋ abaal, baan a ywar a Abàlam, anà bԑ bumwԑy làfàtiin Nzam bↄↄmà, Ndaa a mɔ̈ɔ̈ ayi bàtöm akà bi. ");
INSERT INTO yns_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Wɛɛ abun, baar a Yԑlusàlԑm anà amfum aba, bun'kyey anki Yԑsu. Wɛɛ mpal bun'tsüül ba mbar, ba bàkwey ndaa a aŋangↄↄm bàfàtaŋ saba lanswà. ");
INSERT INTO yns_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wɛɛ, itàkal ba bàmɛn anki undiir ban'kwo mukun'dwa, ba bàlɔ̈m akà Pilatu mulwom mɔ̈ɔ̈ ande. ");
INSERT INTO yns_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ungö bàmay ba mukyer ndaa yanswà bàsön ntↄn nde, ba bun'tↄɔl u kulunsi, waa bun'tɔ̈ɔ̈l uboo a an'dii mwɛy. ");
INSERT INTO yns_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wԑԑ Nzam kun'twey uboo a akü, ");
INSERT INTO yns_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","nde kàyàmԑnà ilä mbɔɔn akà baar abà bàbeenà anà nde, sԑmà Ngalilԑ tii Yԑlusàlԑm. Ŋàbawà ba bà ambäl ande kusà a un'sԑŋ a Isàlɛl! ");
INSERT INTO yns_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Wɛɛ bi, bi ikàlakyäänà Ndaa Aŋàbwaŋ yi: ilää kàpԑ Nzam akà bàtaaràbi, ");
INSERT INTO yns_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nde kya kan'kölà ubwaŋàbwaŋ apanà ntↄn bi baan aba, muwiy Yԑsu, asànaa bàsön uboo a diim làyweel naa: \"Ngye, ngye awà Mwan amԑ, Ŋàbawà, mԑ amabɔr.\" ");
INSERT INTO yns_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nzam kun'wiiy uboo a akü, ntɔn nde ukɔↄn afàfurà unsà upɔɔn. Abun nde kàtԑn naa: \"Mԑ in'sàlapà indiir in'kyɛԑl anà byàndandaa kàbön mɛ mupà David.\" ");
INSERT INTO yns_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Undiir awun kàfàtԑn nde kà itiir a ndaa asin: \"Ngye asàpà anki mbwo naa mbuur angye wà in'kyɛԑl upɔ̈ɔ̈n.\" ");
INSERT INTO yns_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Wɛɛ, David, utaaŋ ande, nde kàsyääl ukwen a Nzam. Ungö, waa kàkü, ba bun'dye kà an'dii a bàtaarànde, nde kàkyer apↄↄn. ");
INSERT INTO yns_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Wԑԑ mbuur kàwiiy Nzam, nde kàpɔ̈ɔ̈n anki. ");
INSERT INTO yns_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Undiir awun, atↄŋ, làyöb naa u mbwo ande bàkyàlakyään ndwääl a nkul. ");
INSERT INTO yns_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","U mbwo ande, mbuur wanswà awà wasà làkwikilà atoo wàbalàbal unsà indiir byanswà mpa kàkwe un'kↄↄn a Mↄsԑ mukyer. ");
INSERT INTO yns_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kyakin, làkäl kà igyɛԑŋ manà ndaa bàtԑn aŋangɔɔm iyàlabweel: ");
INSERT INTO yns_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","\"Làler, bԑ baar aŋàyↄl a un'köl, làkäl unsà ubem anà làyaalà, ntɔn mԑ in'kyer undiir mpal làwà bɛ anà mɔ̈ɔ̈, undiir mpa lan'kwo bԑ mukyey isàkal naa mbuur mwԑy kàmàlakyään wa!\" » ");
INSERT INTO yns_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mpal bàtoo Pↄl anà Banabasi, ba balɔ̈ɔ̈m muyàlɔŋ ndaa nsil ayin u saba làlääb. ");
INSERT INTO yns_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ungö a nköŋ, Ayudà mbↄↄn anà baar bàkyey inzaam a Ayudà, ba bàläb Pↄl anà Banabasi. Ba bàyäämà ba a ba, waa bapɛɛ un'kaay mubääb anà kab angway a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ilä a saba kyàlääb, bul lanswà làkàköŋ ntↄn muwem Ndaa a Mwol. ");
INSERT INTO yns_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Wԑԑ mpal bàmԑn Ayudà in'sԑŋ ami, ba bàwem un'köl, bàtön ndaa a Pↄl, waa bun'bɛyà. ");
INSERT INTO yns_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Wԑԑ Pↄl anà Banàbasi bàtɛn a uyɔl naa: « Ya yàlɔ̈m naa ndaa a Nzam bàtàkyään bԑ. Wԑԑ, ntɔn lan'tↄn bɛ ya, bԑ ŋakwo lan'swaŋ naa bԑ làkwe anki muwal mɔ̈ɔ̈ a mbul a in'tye. Apanà bi ntabwey abi ibuul akà baar mpa abà Ayudà. ");
INSERT INTO yns_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Abun, Mwol kà iswԑŋ abà: \"Mԑ ngye kasi pԑԑlà ntɔn baar mpa abà Ayudà, ntↄn ngye asyen mɔ̈ɔ̈, tii mper màkàtsü mɛɛn.\" » ");
INSERT INTO yns_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wԑԑ mpal bàwem baar mpa abà Ayudà ndaa ayi, ba bàmɛn un'sak, ba bàsɛmà musà ndaa a Mwol làkoo. Baar banswà basɔ̈ɔ̈l muwal mɔ̈ɔ̈ a mbul a in'tye, ba bàsi làkwikilà. ");
INSERT INTO yns_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Abun, ndaa a Mwol yàpää kà itiir a nsi akin kyanswà. ");
INSERT INTO yns_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Wԑԑ Ayudà bàkàkul usey akà akaar aŋun'naaŋ bàfasyäŋà Nzam anà akà abyääl a bul, ba bàsiinà baar mupà Pↄl anà Banabasi nkwaaŋ, ba baböŋ kà itiir a nsi aba. ");
INSERT INTO yns_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Apan, ba bàkyen Ikɔn bàmusakɔɔb un'twà a in'kɔl aba. ");
INSERT INTO yns_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wԑԑ akà alↄŋki, ba bàkäl aŋàyↄl a un'sak anà Dweelà In'kyɛԑl. ");
INSERT INTO yns_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","U Ikↄnyum Pↄl anà Banabasi bàbilà sye u ndwà a nköŋ a Ayudà, waa bàlↄɔŋà. Abun, un'kàbɔ a Ayudà anà Angԑlԑki basi làkwikilà. ");
INSERT INTO yns_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Wԑԑ Ayudà bàtön an'lↄↄŋ, waa bàsiinà baar mpa abà Ayudà mutɔŋ mpem ambe akà atɔŋ. ");
INSERT INTO yns_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Itàkal abun, ba kwo bàkäl ilä mbↄↄn bàmulɔŋ a uyɔl ntɔn làkwikilà aba akà Mwol. Nde kapԑ ikɔ̈b mukyer impà anà idiim anà mutà imbäl u ndaa a kab angway ande. ");
INSERT INTO yns_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Wԑԑ un'sԑŋ a bul waa kàkaabà: amwԑy bàbü a Ayudà, bumwԑy bàbü a Antööm. ");
INSERT INTO yns_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Baar mpa abà Ayudà anà Ayudà anà amfum aba, ba bàbön mumԑɛy ba nkwaaŋ anà mukam ba in'kul. ");
INSERT INTO yns_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pa bàyöb ba ndaa ayi, ba bàkyer akàyee, waa bàkyen ntsü a Likayɔni, Listre, Dԑrbԑ anà Likↄnya anà an'bul a tsütsü. ");
INSERT INTO yns_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Akun sye, ba bàkäl mukyään Làsaŋ Aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","U Listre kàkäl anà ŋàkwɛkà mwԑy, nde kàkäl ikar, sԑmà mböör ande, nde kàsàkyà anki dwaan. ");
INSERT INTO yns_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ilä mwɛy nde kàkäl mulab ndaa kàlɔɔŋà Pↄl. Pↄl kun'paam mii, waa kàmԑn naa mbuur awà kàkäl anà làkwikilà ntɔn nde ukɔↄrà. ");
INSERT INTO yns_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Apan, nde kàtɛn a nde u ndaa a ngwal naa: « Mbarà, kal aŋàtsim unsà in'kↄl angye! » Mbuur awà waa kàfumà, waa kàkyen. ");
INSERT INTO yns_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mpal bàmԑn in'sԑŋ ndaa kàkyer Pↄl, ba bàsi in'kwԑŋ kà Ilikↄnya, waa bàtɛn naa: « Bànzam ban'bulà baar, waa ban'yàtyà mper akà bi. » ");
INSERT INTO yns_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ba bàpԑ Banabasi ikↄb a « Zösi » Pↄl bun'pԑ ikↄb a « Ɛrmԑsi » ntↄn ndaa yanswà yàkäl anà nde. ");
INSERT INTO yns_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ndwà a nzam a ngaŋ a Zösi yàkäl u nswɛŋ a bul. Nde kàtwääl in'dim a ngɔɔmà anà in'siŋ a iful u minàmbwo a ndwà ayi ntɔn nde kàkwen naa nde anà un'sɛŋ, ba bàpɛ ibɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wԑԑ mpal bàwem Antööm ndaa ayi, ba bàkaam ipfԑy aba, waa bàkyen u ntiin ntsü kàkäl un'sԑŋ a baar, bàmusà in'kwɛŋ ");
INSERT INTO yns_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","anà mutɛn naa: « Abaal, ntↄn nkye lan'kyer bԑ indiir a tub abi? Làyöb naa bi sye, bi ibà baar asànaa bԑ. Ndaa Aŋàbwaŋ ikàlakyään bi yà naa bԑ làwԑy itԑk, wԑԑ bԑ làyi akà Nzam a mɔ̈ɔ̈ awà kàkyer du, mԑԑn, ngyäl a kölàköl anà indiir byanswà abyà uboo. ");
INSERT INTO yns_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","U nkööl yàlyaaŋ, nde kàwԑy in'sԑŋ myanswà mulab ndaa aba ŋakwo. ");
INSERT INTO yns_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Itàkal abà, nde kàkɔ̈ɔ̈n anki mutà imbäl a ubwaŋ ande, mukàlapà fà du, mbul anà mbɛŋ kà an'paŋà a bya, mukàlapà isaa anà muyööl mpem abԑ a un'sak. » ");
INSERT INTO yns_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Wԑԑ itàkal bàtԑn ba ndaa ayi, yàkäl mpay antööm mutsuŋ un'sԑŋ a baar mukɔɔn akapà ibↄↄn. ");
INSERT INTO yns_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Apan, Ayudà bàfü Antyↄsha anà Ikↄn, ba bàsi muküünà akà un'sɛŋ a baar. Un'sɛŋ a baar awà kàkyey an'kyän aba, waa bàtԑ Pↄl in'kul ntↄn mukun'dwa. Ungö ba bàkun'wɔm u nsà a bul. Ba bàsii naa nde kan'kwà. ");
INSERT INTO yns_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Wԑԑ mpal bàkàköŋ alɔŋki umbil a Pↄl, laa kàmbarà nde, kàbilà nde uboo a bul. Taaŋtyà, ba bàkyen Dԑrbԑ anà Banabasi. ");
INSERT INTO yns_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ungö bàlↄŋ ba baar Làsaŋ Aŋàbwaŋ u bul alà anà baar mbↄↄn bàbulà ba alↄŋki, ba bàfurà Listre, Ikↄn anà Antyↄsha. ");
INSERT INTO yns_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ba bàpԑɛ alɔŋki ngwal anà bàlɔ̈ɔ̈mà naa ba bàsi muküünà u làkwikilà anà mutɛn naa: « Ilↄↄmà naa bi itwab atàman mpay mbↄↄn mubilà kà imwol a Nzam. » ");
INSERT INTO yns_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ba bàsɔ̈ɔ̈l andweer kà Ikööŋ imwԑy imwɛy. Ungö muyamà anà mukin, ba bapԑ kà an'kↄↄ a Mwol awà bàsi ba làkwikilà. ");
INSERT INTO yns_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ungö apan, ba bàsoonà Pisidi mukyà Pamfili. ");
INSERT INTO yns_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ungö mulɔŋ Ndaa u Pԑrzԑ, ba bàtyà Atalya. ");
INSERT INTO yns_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Akun, ba bàwԑl an'swà, waa bàkyen Antyↄsha, ikal akyà basi u kab a ngway a Nzam ntɔn isal bàkyer ba. ");
INSERT INTO yns_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Mpal bàtöl ba, ba bàbel Ikööŋ, bàkyään ndaa yanswà kàkyer Nzam akà ba, anà kaduub nde sye mbwo a làkwikilà akà baar mpa abà Ayudà. ");
INSERT INTO yns_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Abun, ba bàkäl ilä mbↄↄn anà alɔŋki. ");
INSERT INTO yns_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ndam abaal bàfü Yuday, bàlɔɔŋà atɔŋ naa: « Isàkal naa bɛ bàlakyɛy anki asànaa ukaswaŋà un'kɔɔn a Mɔsɛ, bɛ làkwe anki muwà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Yàmɛnà naa an'sye anà mbaaŋ a kölàköl yàkyer abwà uboo a Pɔl anà Banabasi asye anà ba. Ba bàtsül mbar naa Pɔl anà Banabasi anà ndam a baar bumwɛy, bàbeenà Yɛlusàlɛm akà Antööm anà andweer, ntɔn mutsul ndaa ayin. ");
INSERT INTO yns_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Wɛɛ akà ba, Ikööŋ kyapɛ indiir byàkäl mfun ntɔn nkyeen aba, ba bàsoonà Fɛnɛsi anà Samàlya, bàmuyisam mbuul a mpem a baar mpa abà Ayudà. Ndaa ayi yàpɛɛ un'sak mbɔɔn akà atɔŋ banswà. ");
INSERT INTO yns_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mpal bàtöl ba Yɛlusàlɛm, Ikööŋ anà Antööm anà andweer bawɛl ba, ba bàsam ndaa yanswà kàkyer Nzam u mbwo anà ba. ");
INSERT INTO yns_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Wɛɛ, ndam a Amfarisi amwɛy abà bàbula aklistɔ bàmbarà ntɔn mutɛn naa baar mpa abà Ayudà bàkyer akyɛy anà bàkyer aswaŋ mulab un'kɔɔn a Mɔsɛ. ");
INSERT INTO yns_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Antööm anà andweer bàköŋ ntɔn muler ndaa ayi. ");
INSERT INTO yns_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ungö a mbaaŋ a bwɛlàbwɛl, Petɔlà laa kàmbarà nde, waa kàtɛn naa: « Atɔŋ abaal, bɛ, bɛ làkyàyöb naa sɛmà itaan Nzam kàsɔ̈ɔ̈l uboo abɛ naa u mun amɛ, baar mpa abà Ayudà bàwem Ndaa a Làsaŋ Aŋàbwaŋ anà bàsi làkwikilà. ");
INSERT INTO yns_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Waa Nzam awà ayöb mpem a baar, katɛɛl imbäl mukapà Dweelà In'kyɛɛl asànaa akà bi. ");
INSERT INTO yns_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nde sye nsöön kàsi anki uboo a bi anà ba: nde kàpöŋ mpem aba ntɔn làkwikilà aba. ");
INSERT INTO yns_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Apanà, ntɔn nkye lan'lwab bɛ Nzam, lan'sà bɛ buur u bway a alɔŋki, buur mpa bàkwe bànkaa abi itàkal bi ŋakwo musɛn? ");
INSERT INTO yns_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Wɛɛ, ntɔn ngyɛb a Mwol Yɛsu awà ifàsà bi làkwikilà, bi kàwü mɔ̈ɔ̈ sye asànaa ba. » ");
INSERT INTO yns_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Abun, un'sɛŋ wanswà kàkäl a kul, ba bàkäl muwem Banabasi anà Pɔl bàkäl mukyäänà ba idiim anà impà byanswà kàkyɛr Nzam akà baar mpa abà Ayudà u mbwo a Antööm. ");
INSERT INTO yns_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mpal bàmay ba mutɛn, Zyak kàwɛl ndaa, waa kàtɛn naa: « Atɔŋ abaal, lan'wem! ");
INSERT INTO yns_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɔn kàmiyɔɔb naa u nsɛmà Nzam kàkyer aben musɔɔl un'sɛŋ umwɛy uboo a in'sɛŋ myanswà mpa amyà Ayudà ntɔn muwal ikɔb ande. ");
INSERT INTO yns_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ya yan'bwà balàbal asànaa ndaa bàsön aŋangɔɔm naa: ");
INSERT INTO yns_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","\"Mwol kan'tɛn naa: Ungö apan, mɛ in'sàkyer asàyàfurà ntɔn musuub ndwà a David ayà yàbü. Mɛ in'sàlɔɔn indiir aya byàtäy, mɛ in'sàmbaar ya. ");
INSERT INTO yns_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Abun, ndam abaal ayisàsal waa isàleŋ Mwol, anà baar a in'sɛŋ myanswà myàfàtà ikɔb amɛ din. Ayi ntɛɛn a Mwol afàkyer indiir abi ");
INSERT INTO yns_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","abyà bàyöb sɛmà itaan.\" ");
INSERT INTO yns_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Kyakin mɛ, mɛ in'kasii naa kà ubwaŋ anki mupà mpay akà baar mpa abà Ayudà ban'buul mpem aba akà Nzam, ");
INSERT INTO yns_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","wɛɛ basöön un'kaan naa ba bàkɔɔn asin tsütsü apà ŋingyäy a itɛk, anà inswem, anà ntsür mpa aŋàtsul kil anà an'kil. ");
INSERT INTO yns_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ntɔn, sɛmà nkööl yàlyaŋ itaan, bye anà baar bàfalɔŋ un'kɔɔn a Mɔsɛ u bul lanswà, ntɔn bàfàtaŋ wa ilä a saba kyanswà u ndwà a nköŋ a Ayudà. » ");
INSERT INTO yns_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Abun yan'söön ubwaŋ naa Antööm anà andweer anà Ikööŋ kyanswà bàsɔ̈ɔ̈l baar uboo aba anà batöm Antyɔsha mbwo mwɛy anà Pɔl anà Banabasi. Ba bàsɔ̈ɔ̈l Yudɛ awà bàfàbel naa Balàsàbasi anà Silasi, baar bàkäl anà ikɔ̈b uboo a atɔŋ. ");
INSERT INTO yns_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ba bapɛ un'kaan mwɛy awà bàsön ba abà: « Akà bɛ atɔŋ mpa abà Ayudà làfàkal kà Antyↄsha u Siri anà Silisi, Antööm, andweer anà atɔŋ bàmàlapà mbɔr! ");
INSERT INTO yns_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bi kan'wem naa baar amwɛy bàfü uboo a bi, waa bàyàtwaal lingyooma akà bɛ unsà ntɛɛn aba anà bàpɛ mpem abɛ mpay, wɛɛ bi ba katöm anki. ");
INSERT INTO yns_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Lalan kàmɛn bi anà kàkyey bi banswà naa yubwaŋ bi isɔ̈ɔ̈l abaal anà bi katöm akà bɛ. Ba bàyà mbwo mwɛy anà nkween abi Banabasi anà Pɔl. ");
INSERT INTO yns_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Baar abà bàbɔ̈ɔ̈l, bàkyàyälà mɔ̈ɔ̈ aba ntɔn ikɔb a Mwol abi Yɛsu Klistɔ. ");
INSERT INTO yns_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Abun, bi kàmàlatööm Yude anà Silasi, ba bàyàlakyään u mun aba ndaa nsil ayi. ");
INSERT INTO yns_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Yàmɛnà naa yubwaŋ naa Dwelà In'kyɛɛl anà bi ŋakwo, bi kàtsül mukɔɔn akàlatälà buur asin udu a indiir a mfun bi: ");
INSERT INTO yns_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","utɔn in'twaŋ a ntsür bàfàpà ibɔɔn akà itɛk, anà an'kil, anà ntsür mpa yàŋàtsul kil, anà ipasàsɛ. Bɛ làsàlab ndaa ayi, bɛ lan'kyer ubwaŋ. Làkäl ubwaŋ! » ");
INSERT INTO yns_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Apan ba bàkaabà anà Ikööŋ, waa bàtyà Antyɔsha. Akun ba bàtüüb un'sɛŋ a aŋàlàkwikilà, waa bapɛ un'kaan. ");
INSERT INTO yns_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ungö ban'taŋ ba wa, atɔŋ bàmɛn un'sak, ntɔn wa kapɛ ngwal. ");
INSERT INTO yns_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yude anà Silasi, ba ŋakwo sye bàkäl aŋangɔɔm, ba bapɛɛ an'lwɛŋ mbɔɔn ntɔn ba bàwɛl un'kanà anà ngwal. ");
INSERT INTO yns_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ba bàkäl ndam a taaŋ paa, atɔŋ waa bafuur unsà duu akà baar batöm. ");
INSERT INTO yns_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Wɛɛ Silasi kàsàsal paa. ");
INSERT INTO yns_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Wɛɛ akà Pɔl anà Banabasi, ba bàsàsal u Antyɔsha anà baar asin mbɔɔn mulɔɔŋà anà mukyäänà Làsaŋ Aŋàbwaŋ là Ndaa a Mwol. ");
INSERT INTO yns_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ungö a an'taaŋ, Pɔl kàtɛn a Banabasi naa: « Tsweenà bi ifurà mukàler atɔŋ kà an'bul manswà kàyilɔɔŋà bi Ndaa a Mwol, ntɔn muyöb naa ba kwo bà aben. » ");
INSERT INTO yns_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasi kàkwen musyen sye anà ba Ywan, awà bàfabeelà sye Malakɔ. ");
INSERT INTO yns_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Wɛɛ Pɔl kàmɛn naa kà ubwaŋ anki ba mukyà anà mbuur awà kàsawɛy sɛmà Pamfili anà mpa kàsabay unsà isal aba. ");
INSERT INTO yns_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Apan, an'sye màkäl màngwal uboo a ba bàbɔ̈ɔ̈l, undiir awun bàkaabà ba. Banabasi kàwɛl Malakɔ, waa bàbilà anà nde kà an'swà ntɔn mukyà isaŋ a Shipɛlɛ. ");
INSERT INTO yns_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Wɛɛ akà Pɔl, nde kàsɔ̈ɔ̈l Silasi, waa kàkyen anà nde, ungö bun'si atɔŋ u kab angway a Mwol. ");
INSERT INTO yns_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nde kàyilyaaŋà u Siri anà Silisi ntɔn muyipà Ikööŋ ngwal. ");
INSERT INTO yns_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔl kàkɔlà Dɛrbɛ anà Listre. Akun, kàkäl anà un'lɔŋki mwɛy ikɔb ande Tumàtɛ, mwan a un'kaar un'yudà kàbulà un'klistɔ, taarànde kàkäl un'ngɛlɛki. ");
INSERT INTO yns_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Atɔŋ abà u Listre anà u Ikɔn bun'tɛɛl imbäl aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔl kàkwen mukun'syen. Ungö akun'wal, nde kàkyer un'kyɛy, ntɔn Ayudà bàkäl kwo bàkyer ayöbà naa taarànde kàkäl un'ngɛlɛki. ");
INSERT INTO yns_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kà an'bul bàyilyaaŋà ba, ba bàyiswaŋà atɔŋ mulab ndaa bàtsül Antööm anà andweer u Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Abun, Ikööŋ byàbulà ngwal unsà làkwikilà anà byàkwɛyà ntal a aklistɔ ilä a ilä. ");
INSERT INTO yns_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Dwelà In'kyɛɛl kàkyer atsuŋ mukyään Ndaa u mɛɛn a Azi, abun ba bàsoonà nsi a Filizi anà Ngalàtyà. ");
INSERT INTO yns_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mpal bàtöl ba tsütsü a Misi, ba bàsii mubilà u Bitini, wɛɛ Dweelà a Yɛsu mbwo kapɛ anki. ");
INSERT INTO yns_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Lalan bàsoonà ba Misi, waa bàtyà Tɔlɔwasi. ");
INSERT INTO yns_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","U mpib mwɛy, Pɔl kàmɛn imanmii: un'nsi Masɛdwan mwɛy kàkäl aŋàmbar, waa kun'bɔ̈ɔ̈n, waa kàtɛn naa: « Lyaaŋ u Masɛdwan, yibay! » ");
INSERT INTO yns_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ungö a imanmii aki, kà imbürà, nde kàleŋ bi mukyà Masɛdwan, ntɔn bi kàyöb naa Mwol kàmibel mukàkyään Làsaŋ Aŋàbwaŋ akà baar a mper ayin. ");
INSERT INTO yns_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","U Tɔlɔwasi, bi kàbilà kà an'swà mukyà ipey isaŋ a Samɔtalasi. Taaŋtyà bi kàtoo kà an'swà u Nɛyapɔlisi. ");
INSERT INTO yns_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Fà apan, bi kàkyà Filipe, bul a kölàköl là itiir a nsi Masɛdwan, la làkäl nsal a Lɔmà. Bi kàkäl ndam a taaŋ u bul alà. ");
INSERT INTO yns_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ilä a saba, bi kàtoo u nsà a bul ntɔn mukyà kà un'kɔɔl a an'dà, ntɔn bi kàsii naa bi ikàman ikal a ngyamàkà. Bi kàbwaay paa, anà kàyamà anà akaar bàköŋ paa. ");
INSERT INTO yns_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Umwɛy uboo a akaar abà, ikɔb ande Lidi, bul ande Tyatir, nde kàkäl un'yääl a ipfɛy a tsöö, nde kàfasyäŋà Nzam. Nde kàkyer iweemà, waa Mwol kun'duub mpem ntɔn nde uwem ubwaŋàbwaŋ indiir kàtɛɛnà Pɔl. ");
INSERT INTO yns_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Umpal kàwɛl nde ndüümà, nde anà ndwà ande, nde kà ibɔ̈ɔ̈n, waa kàtɛn naa: « Kya bɛ làsàman naa mɛ in'wà ŋàlakwikilà a Mwol, wɛy bɛ làbilà anà làkäl u ndwà amɛ. » Nde kàsi muküünà naa bi ikyey. ");
INSERT INTO yns_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ilä mwɛy bi kàkäl mukyà ikal a ngyamàkà, un'syääl mwɛy wà un'kaar kàkäl anà bwoo a nkwee, nde kàyi akà bi. Nde kàfakɔlà myee anà kàfakyäänà baar ndaa iyàyà kusà. Isal ande aki kyàpɛɛ bweel mbɔɔn akà ankum ande. ");
INSERT INTO yns_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nde kàsɛmà muyilab Pɔl anà bi. Nde kàyikuubà in'kwɛŋ, waa kàtɛɛnà naa: « Baar làman bɛ bà, ba bà asyääl a Nzam a Dudu! Ba bàmuyàlakyään mbwo a mɔ̈ɔ̈! » ");
INSERT INTO yns_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nde kàfakyerà abà ilä mbɔɔn. Ya yàpɛ Pɔl làkyämun, lalan kàbulà nde, waa kàswɛŋ dweelà alan naa: « Kà ikɔb a Yɛsu Klistɔ, mɛ amaswaŋ, too uboo a un'kaar wà. » La waa làtoo taaŋ nsil alan. ");
INSERT INTO yns_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mpal bàmɛn ankum ande naa undiir kàfapaa ba ubwaŋ kan'too, ba bàkör Pɔl anà Silasi, waa basyen kà un'syäl kusà a antɛɛn. ");
INSERT INTO yns_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ba baswɛŋ akà amfum a antɛɛn, waa bàtɛn naa: « Baar bà, bàmuyitwaal lingyoomà uboo a bul abi. Ba Bayudà, ");
INSERT INTO yns_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ba bàyikyään nkääl a ingyey mpa ban'kwo bi mulab ntɔn bi ibà baar a Lɔmà. » ");
INSERT INTO yns_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Un'sɛŋ a baar kàmbarà u nkyɛl ntɔn mutɔn ba, antɛɛn batöm mukasɔl ipfɛy, waa baswɛŋ naa bapɛ an'füm. ");
INSERT INTO yns_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ungö mukadüb iki mbɔɔn, ba batɔɔm u bɔlokà, waa bàswɛŋ un'leer a bɔlokà mukasey ubwaŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Pa kàwɛl nde nswɛɛŋ ayi, nde kasi u bɔlokà làboboo, waa kabäm ibiŋ a in'te kà in'kɔl aba. ");
INSERT INTO yns_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tsütsü a boboo a mpib, Pɔl anà Silasi bàkäl muyamà anà mutɔl an'diim musyäŋà Nzam. Baar a bɔlokà bumwɛy bàkäl muweemà ba. ");
INSERT INTO yns_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kà imbürà, mɛɛn màni a ngwal, an'sin an'ta a bɔlokà màkyer atɛɛr, apan ibeenà byanswà waa byàdubà, in'siŋ a baar a bɔlokà banswà waa myàtsuŋà. ");
INSERT INTO yns_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Umpal kàwiyà un'leer a bɔlokà u twaal anà kàmɛn nde naa ibeenà a bɔlokà byàŋàdubà, nde kàtwey kɔm ande ntɔn mudwa mɔ̈ɔ̈ ande, ntɔn nde kàsii naa baar a bɔlokà ban'tiin. ");
INSERT INTO yns_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Wɛɛ Pɔl kàtɛn u ndaa a ngwal naa: « Twɔn an'dwa mɔ̈ɔ̈ angye, bi banswà ibà paa! » ");
INSERT INTO yns_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Un'leer a bɔlokà kàlɔ̈m mwinà, kàbilà uboo a ndwà u ntiin, waa kàbü a matɛɛr kà in'kɔl a Pɔl anà Silasi. ");
INSERT INTO yns_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Apan, nde katwey u nsà, waa kàtɛn naa: « Amwol, ininà mɛ in'kyer muwal mɔ̈ɔ̈? » ");
INSERT INTO yns_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ba bun'fuur naa: « Sà làkwikilà akà Mwol Yɛsu, waa ngye ayàwà mɔ̈ɔ̈, ngye anà ndwà angye yanswà. » ");
INSERT INTO yns_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Abun, ba bun'kyään ndaa a Mwol, anà baar banswà bàkäl u ndwà ande. ");
INSERT INTO yns_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Taaŋ nsil alan u mpib, nde kasyen mukàsɔŋ iwà aba. Ungö apan nde kàwɛl ndüümà, nde anà baar ande banswà. ");
INSERT INTO yns_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nde kasyen u ndwà ande, kàyöŋà mɛsà, waa kàsäŋà anà ndwà ande yanswà ntɔn kàsi nde làkwikilà amu Nzam. ");
INSERT INTO yns_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mpal làyaanà taaŋ, antɛɛn bàtöm asyääl ntɔn mutɛn a un'leer a bɔlokà naa: « Awɛy baar ban. » ");
INSERT INTO yns_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Un'leer a bɔlokà kàkyään Pɔl ndaa ayi, waa kàtɛn naa: « Amfum antɛɛn ban'tɔm ndaa naa bàlatwey u bɔlokà. Apanà, làtoo anà làkyen unsà duu. » ");
INSERT INTO yns_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Wɛɛ Pɔl kàtɛn naa: « Ungö mukikam an'füm u mii a baar ukɔɔn akifuul un'lɔɔn, bi Alɔmà, ba bitɔɔm u bɔlokà. Apanà waa ba bitɔɔm u nsà u nku! Ya ikal anki abwɛy! Wɛy ba ŋakwo bàyitwey! » ");
INSERT INTO yns_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Asyääl bàkàkyään ndaa ayi akà amfum a antɛɛn. Mpal bàwem ba naa ba bàkäl Alɔmà, bɔɔmà waa lawɛl. ");
INSERT INTO yns_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ba waa bàyi, babɔ̈ɔ̈n, batwey anà balɔ̈ɔ̈m mutoo u bul. ");
INSERT INTO yns_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Mpal bàtoo ba u bɔlokà, ba bàkàbilà u ndwà a Lidi. Ungö mubwey anà atɔŋ, ba bapɛ ngwal, waa bàkyen. ");
INSERT INTO yns_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔl anà Silasi bàlyaaŋ kà Amfipolisi anà Apɔlɔni, ba bàkɔlà Tɛsalɔnikà. Akun Ayudà bàkäl anà ndwà a nköŋ aba. ");
INSERT INTO yns_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔl kàbilà kwo asànaa nkääl ande. An'saba an'tär màlääb, nde kàkäl muyäämà anà ba ntɔn Ndaa Aŋàsɔn, ");
INSERT INTO yns_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","wàmubuul anà muswaŋ naa Klistɔ kàkyer alàman mpay anà kàkyer alàwiyà uboo a akü. Klistɔ wà Yɛsu wa alàkyäänà mɛ wà. ");
INSERT INTO yns_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ndam a baar uboo a ba bàkyey ba, ba bàtüüb anà Pɔl anà Silasi, anà un'kàbɔ a Angɛlɛki bàfasyäŋà Nzam, anà akaar a nkaay mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Wɛɛ Ayudà bàwem un'köl, ba bàwɛl baar a bunàbun bàmbàmbärà kà an'balàbal ntɔn musà binköŋ mbɔɔn uboo a un'sɛŋ anà lingyoomà uboo a bul. Ba bàkàyɔl u ndwà a Yasɔn, ntɔn muleŋ Pɔl anà Silasi anà mukasyen akà un'sɛŋ a baar. ");
INSERT INTO yns_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ba bamɛn anki, apan ba bàwɛl Yasɔn anà ndam a atɔŋ bàkäl anà nde, ba batwääl akà abyääl a bul, bàmusà in'kwɛŋ anà mutɛn naa: « Baar bà ban'twaal lingyoomà u mɛɛn manswà, wɛɛ ŋàbawà ba ban'yàkɔlà apà! ");
INSERT INTO yns_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasɔn kawɛl u ndwà ande. Ba banswà bàkwen anki mulab in'kɔɔn a Sɛzar, ba bàmutɛɛnà naa we anà mfum asin ikɔb ande Yɛsu. » ");
INSERT INTO yns_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ndaa ayi yàtwääl lingyoomà akà un'sɛŋ a baar anà akà abyääl a bul. ");
INSERT INTO yns_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ungö muwal nkwiy kà an'kɔɔ a Yasɔn anà mà baar bumwɛy, ba waa bawɛy. ");
INSERT INTO yns_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","U mpib, atɔŋ bàtöm Pɔl anà Silasi u Bɛrɛ. Umpal bàtöl ba, ba bàbilà u ndwà a nköŋ a Ayudà. ");
INSERT INTO yns_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ayudà a Bɛrɛ bàkäl anà mpem aŋàbwaŋ akwànaa Ayudà a Tɛsalɔnikà. Ba bàwɛl Ndaa unsà mansyäär, ba sye bàfasyeebà Ndaa Aŋàsɔn ilä byanswà ntɔn muyöb naa nkye indiir bakyäänà byàkäl ndandaa. ");
INSERT INTO yns_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Baar mbɔɔn uboo a ba bàsi làkwikilà, anà akaar angɛlɛki a nkaay, anà abaal mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Wɛɛ mpal bàyöb Ayudà a Tɛsalɔnikà naa Pɔl wàmukyäänà ndaa a Nzam sye u Bɛrɛ, ba bàyi ntɔn musà lingyoomà uboo a baar banswà. ");
INSERT INTO yns_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Apan, làgyägyä, atɔŋ bàkàswà Pɔl u ntsü a ngyäl a kölàköl, wɛɛ akà Silasi anà Tumàtɛ, ba bàsàsal paa. ");
INSERT INTO yns_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Baar bàsyen Pɔl, bàkàtsü kà Atɛn. Ungö bàyàfurà ba, ba bàkyään Silasi anà Tumàtɛ nswɛɛŋ katööm Pɔl: nde kalɔ̈m naa ba bun'läb agyägyä. ");
INSERT INTO yns_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Umpal kàkäl Pɔl mudilà ba kà Atɛn, mpem ande yàlalà mbaa muman naa bul la làkäl aŋàyɔl a itɛk. ");
INSERT INTO yns_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nde kàyäämà anà Ayudà anà baar mpa abà Ayudà abà bàfasyäŋà Nzam uboo a ndwà a nköŋ a Ayudà, anà baar banswà kàbweeyà nde abà kà un'syäl ilä byanswà. ");
INSERT INTO yns_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ndam a baar a an'yeerà, baar a Epikür anà baar a Stɔyi bàyäämà anà nde. Amwɛy bàtɛɛnà naa: « Ŋamun awà ininà ukwen mutɛn? » Bumwɛy naa: « Nde ayàkal un'lɔɔŋ a bànzam a ingyey » ntɔn nde kàkyäänà Làsaŋ Aŋàbwaŋ là Yɛsu anà ngwiiyà a akü. ");
INSERT INTO yns_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Apan waa bun'kör, bun'syen kà un'syäl a Arɔpazɛ, waa bàtɛn a nde naa: « Nkye bi ikyàkwo muyöb, an'lɔɔŋ nà màkün ayikyään ngye mà? ");
INSERT INTO yns_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ntɔn ngye awà mukyäänà bi indiir a ingyey. Bi ikwen muyöb naa bya iswaŋà aben. » ");
INSERT INTO yns_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Abun, baar a Atɛn banswà anà angyey bàfàkal kà Atɛn, taaŋ aba mbɔɔn làlyaaŋà mutɛn itàkal muwem indiir akün. ");
INSERT INTO yns_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pɔl kàkäl umbär uboboo a Arɔpazɛ, waa kàtɛn naa: « Abaal a Atɛn, mɛ an'man naa mɔ̈ɔ̈ abɛ wanswà wà unsà inzaam. ");
INSERT INTO yns_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ntɔn an'yilyaaŋ mɛ uboo a bul abɛ anà an'syebà mɛ indiir a in'kyɛɛl abɛ, mɛ an'man idwà imwɛy bàkyàsɔn naa: \"Akà nzam mpa bàyöb baar!\" Wɛɛ nde wa làfàsyänà bɛ wà anà làkɔ̈ɔ̈n ayöb bɛ, mɛ amàyàlakyään wa. ");
INSERT INTO yns_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nzam awà kàkyer du anà mɛɛn anà indiir byanswà abyà uboo, nde wà Mwol a du anà mɛɛn, nde ufàkal anki uboo a ndwà a nzam ayà bàkyer kà an'kɔɔ a baar, ");
INSERT INTO yns_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","nde baar bàfun'bay anki, asànaa nde kà we anà mfun a undiir aben undiir. Ntɔn nde wà mbuur afàpà mɔ̈ɔ̈ anà un'swey akà baar banswà anà indiir byumwɛy. ");
INSERT INTO yns_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Fà mbuur mwɛy nde kàkyer in'sɛŋ a baar ntɔn ba bàkäl udu a mɛɛn manswà, nde kàtsül an'mpaŋà anà ndel a nsi bàtöŋ ba. ");
INSERT INTO yns_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nde kàkwen naa baar bàleŋ Nzam, taaŋ lumwɛy naa ba bun'mɛn unsà ileleŋ aba. Kutɛn aŋàbwaŋ nde kwɛl watɛy anà umwɛy umwɛy uboo a bi, ");
INSERT INTO yns_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ntɔn: \"U mbwo ande, bi ibye anà mɔ̈ɔ̈, ibàmubar anà mukal.\" Ya yà asànaa bàtɛn asöön abɛ amwɛy naa: \"Bi sye ibà itoo ande.\" ");
INSERT INTO yns_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Undiir awun, ntɔn ibà bi itoo a Nzam, bi ikwe anki muyweer naa nde ukäl asànaa itɛk a wɔl, kyà arza anà kyà un'kul kàkyer mbuur unsà an'kyän ande. ");
INSERT INTO yns_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Wɛɛ Nzam, ukɔɔn alab taaŋ a ingyöy, apanà nde wàmubel baar banswà u ntsü yanswà mubuul mpem, ");
INSERT INTO yns_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ntɔn nde kàkyàtsul ilä mwɛy akyà usàtsüül nde mɛɛn manswà nsaŋ unsà balàbal u mbwo a mbuur kàsɔ̈ɔ̈l nde, awà kaswɛŋ nde idiim mukun'wiiy kà ukwà. » ");
INSERT INTO yns_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Mpal bàwem ba « ngwiiyà a akü », baar amwey waa bun'sɛɛ, wɛɛ bumwɛy bàtɛɛnà naa: « Bi iyàfawem mutɛn ndaa ayi u mbalà asin. » ");
INSERT INTO yns_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Apan, Pɔl waa kàsawɛy. ");
INSERT INTO yns_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wɛɛ ndam a baar bumwɛy bàbääb anà nde, ba bàsi làkwikilà: uboo a ba, Dɛnis mbuur a Arɔbazɛ, anà un'kaar mwɛy ikɔb ande Damalis, anà baar asin sye. ");
INSERT INTO yns_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ungö apan, Pɔl kàlwomà kà Atɛn, waa kàkyen Kɔlintɔ. ");
INSERT INTO yns_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nde kwo kàbwey anà Un'yudà mwɛy ikɔb ande Akilasi, un'nsi Pɔnt, kàfü Itali itaan a mbɔɔn tɛy anà un'kyay ande Pilàsilà, ntɔn Kɔlɔdɛ kàswɛŋ naa Ayudà banswà bàkyer atoo u Lɔmà, nde kàbääb anà ba, ");
INSERT INTO yns_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ntɔn nde kàkäl akyà isal mwɛy anà ba, nde kàkäl apà ba ntɔn mukyer isal: ba bàkäl akyeer a ntɛn. ");
INSERT INTO yns_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pɔl kàyäämà kà ilä a saba kyanswà u ndwà a nköŋ a Ayudà. Nde kàkyer ngwal naa Ayudà anà Angɛlɛki bàkyey. ");
INSERT INTO yns_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Wɛɛ utaaŋ bàfü Silasi anà Tumàtɛ Masɛdwan anà bàyàkɔlà ba, Pɔl kàpɛ mɔ̈ɔ̈ ande wanswà mulɔŋ Ndaa anà mutà imbäl akà Ayudà naa Yɛsu wà Klistɔ. ");
INSERT INTO yns_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ayudà bàsyee mbaaŋ, waa bun'töö. Pɔl kàkɔɔb ipfɛy ande, waa kàtɛn a ba naa: « Wɛy an'kil abɛ màbü udu a un'tswe abɛ ŋakwo! Mɛ un'bar ankye akwɛy watɛy. Sɛmà apanà mɛ in'kyà akà baar mpa abà Ayudà. » ");
INSERT INTO yns_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Apan, nde kàtoo akun, waa kàbilà u ndwà a mbuur mwɛy ikɔb ande Tityüs Züstüs, nde kàfasyäŋà Nzam, ndwà ande yàkäl yàŋàbääb a ndwà a nköŋ a Ayudà. ");
INSERT INTO yns_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Apan, Krispüs, un'leer a ndwà a nköŋ a Ayudà, kàsi làkwikilà amu Mwol anà ndwà ande yanswà. Bàkɔlintɔ mbɔɔn bàweemà Pɔl, bàsi làkwikilà anà bàwɛlà ndüümà. ");
INSERT INTO yns_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","U mpib mwɛy, Mwol kàkyään Pɔl unsà imanmii naa: « Twɔn an'man bɔɔmà, lab mukyään, twɔn an'kal a duu. ");
INSERT INTO yns_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ntɔn mɛ, mɛ in'wà anà ngye, akà mbuur mwɛy ukwe anki mukakyer ube, ntɔn un'sɛŋ amɛ wà mbɔɔn u bul alà. » ");
INSERT INTO yns_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nde kàkyer mbul mwɛy a ngɔɔn syaam mulɔŋ ndaa a Nzam uboo a ba. ");
INSERT INTO yns_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Wɛɛ umpal kàkäl Galyɔn mfum u Akayi, unsà un'tüüb mwɛy, Ayudà bàtwääl lingyoomà ntɔn mutɔn Pɔl. Apan, ba bun'syen u làbay a nsaŋ, ");
INSERT INTO yns_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","waa bàtɛn naa: « Mbuur wà wàmuyisyen baar musyäŋà Nzam ukɔɔn alab un'kɔɔn. » ");
INSERT INTO yns_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Umpal kàlàduub Pɔl mun, Galyɔn kàtɛn a Ayudà naa: « Kya ilàkal ndwääl itàkal ube a kölàköl, mɛ in'kyer alawem, oo Ayudà. ");
INSERT INTO yns_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Wɛɛ isàkal naa mbaaŋ yà ntɔn ndaa anà ikɔb anà un'kɔɔn abɛ ŋakwo, ayin iler bɛ ŋakwo. Mɛ, mɛ in'kwen anki mukal ntɛɛn a indiir abi! » ");
INSERT INTO yns_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Apan, nde waa kafuur. ");
INSERT INTO yns_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Lalan bàkör ba Sɔstɛn, mfum a ndwà a nköŋ a Ayudà, waa bun'düb kusà a làbay a nsaŋ. Wɛɛ Galyɔn indiir abi kàsi anki u mpem. ");
INSERT INTO yns_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔl kàfàkal ilä mbɔɔn u Kɔlintɔ. Ungö, nde kàsàwɛy atɔŋ, waa kàwɛl an'swà ntɔn mukyà Siri anà Pilàsilà anà Akilasi, ungö mukɔɔl ntswe ande u Sanshres ntɔn nde kàdi kyän. ");
INSERT INTO yns_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ba bàtöl Ԑfɛsɔ, Pɔl kàsàwɛy atɔŋ bàkäl anà nde paa. Nde kàbilà nde ŋakwo u ndwà a nköŋ a Ayudà, waa kàyäm anà Ayudà. ");
INSERT INTO yns_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ba bun'lɔ̈ɔ̈m naa nde ukäl ilä mbɔɔn apà ba, wɛɛ Pɔl kàkyey anki, ");
INSERT INTO yns_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","wɛɛ nde kàsawɛy nde, waa kàtɛn naa: « Nzam usàkwen, mɛ in'kyer afàsyefurà apà bɛ. » Nde kàbilà kà an'swà mukyà Ԑfɛsɔ. ");
INSERT INTO yns_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nde kàtoo kà an'swà u Sɛzarɛ. Nde kàtàbeenà mupà Ikööŋ mbɔr, waa kàtyà Antyɔsha. ");
INSERT INTO yns_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ungö kàkyer nde ndam a an'taaŋ paa, nde kàkyen anà kàsoonà Ngalàtyà anà Frizi muyipà alɔŋki banswà ngwal. ");
INSERT INTO yns_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Un'yudà mwɛy ikɔb ande Apɔlɔsi, un'nsi Alɛksandri, kàyàkɔlà kà Ɛfɛsɔ. Nde kàkäl aŋun'yɛnà, kàyöb utwɛɛy ubwaŋàbwaŋ anà kàkäl ngwal u Ndaa Aŋàsɔn. ");
INSERT INTO yns_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nde kàwɛl un'yɛnà u mbwo a Mwol, anà mbämà unsà dwelà, nde kàyikyäänà anà kàyilɔɔŋà anà nwɛŋ indiir iler Yɛsu, itàkal naa nde kàyöb nà ndüümà a Ywan mpɛl. ");
INSERT INTO yns_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nde kàyääma unsà uyɔl uboo a ndwà a nköŋ a Ayudà. Wɛɛ Pilàsilà anà Akilasi bun'wem ba, ba bun'wɛl ukɔl, ntɔn ba bun'swɛŋ ubwaŋàbwaŋ Mbwo a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nde kàkwen mulyaaŋ kà Akayi, atɔŋ bun'pɛ ngwal mukyer abun, ba bàsön un'kaan akà alɔŋki ntɔn ba bun'wɛl. Mpal kàtöl nde, unsà kab a ngway, nde kàmɛnà mbuur a ndöŋ akà baar bàbulà aŋàlàkwikilà ");
INSERT INTO yns_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ntɔn nde kàtön Ayudà ipepey a ngwal yanswà u mii a baar: nde kàswɛŋà u mbwo a Ndaa Aŋàsɔn naa Yɛsu wà Klistɔ. ");
INSERT INTO yns_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Yàmɛnà naa mpal kàkäl Apɔlɔsi u Kɔlintɔ, Pɔl, ungö kàsoonà nde itiir a nsi a myɔŋ, nde kàtyà Ԑfɛsɔ. Nde kwo kàbwey a ndam a alɔŋki, nde kafuul naa: ");
INSERT INTO yns_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","« Nkye bɛ làkyàwal Dwelà In'kyɛɛl umpal làbulà bɛ aŋàlàkwikilà? » Ba bun'fuur naa: « Bi kàwem anki akà làsaŋ làmwɛy naa we anà Dweelà In'kyɛɛl. » ");
INSERT INTO yns_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Apan nde kafuul naa: « Ndüümà nà bɛ làwɛl? » Ba naa: « Ndüümà a Ywan. » ");
INSERT INTO yns_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Waa Pɔl kàtɛn naa: « Ndüümà a Ywan yà ndüümà a mbuul a mpem, nde kàkyäänà un'sɛŋ naa ba bàsi làkwikilà akà mbuur awà ayàyà ungö a nde, iswaŋà naa Yɛsu. » ");
INSERT INTO yns_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ungö bàwem ba ndaa ayi, ba bàwɛl ndüümà kà ikɔb a Mwol Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ungö kasi Pɔl an'kɔɔ, Dweelà In'kyɛɛl kàyi udu a ba, waa ba bàsɛmà mutɛn unsà ndaa yà ifà ifà anà mutà ngɔɔm. ");
INSERT INTO yns_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ba banswà bàkäl isii a baar kwem aŋiyweel. ");
INSERT INTO yns_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ungö apan, Pɔl kàbilà u ndwà a nköŋ a Ayudà, nde kàtɛɛnà anà uyɔl ngɔɔn tär, wàmuyämà anà musiinà baar bàweemà nde naa ba bàkyey ndaa a Imwol a Nzam kàlɔɔŋà nde. ");
INSERT INTO yns_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Wɛɛ bumwɛy uboo a ba bàkäl baar a un'tswe bwoor, ba bàtön musà làkwikilà anà bàsɛɛ Mbwo u mii a nköŋ a baar. Apan Pɔl kàkaabà anà ba, waa kàwɛl alɔŋki ukɔl ntɔn muyäämà anà ba ilä a ilä u ndwà a nkaan a Tiranüs. ");
INSERT INTO yns_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ya abà yàkölà mbul yweel, abun baar banswà bàkäl kà Azi, Ayudà anà a Angɛlɛki, bàkyer awem Ndaa a Mwol. ");
INSERT INTO yns_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nzam kàkyerà impà a ifà asin u mbwo a an'kɔɔ a Pɔl. ");
INSERT INTO yns_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Undiir awun, bàsyee ba ipfey itàkal itɛɛnà a ipfɛy byàböölà ndür ande udu a abɛy: an'kyal aba waa màwüü, an'dweelà an'be waa màtoo. ");
INSERT INTO yns_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ndam a Ayudà bàyilyaaŋà ntsü yanswà ntɔn muböŋ an'dweelà an'be uboo a baar, bàbulà sye mutà ikɔb a Mwol Yɛsu din anà mutɛn naa: « Mɛ amaswaŋ, too kà ikɔb a Yɛsu awà ufàkyään Pɔl wà! » ");
INSERT INTO yns_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Baar bàkyerà abun bà baan a Tsɛva babaal bànsambwaar. Tsɛva kàkäl Un'yudà, kàkäl sye undweer a angaŋ. ");
INSERT INTO yns_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Wɛɛ dweelà a làbe kafuur naa: « Mɛ Yɛsu in'kyun'yöb, mɛ in'kyàyöb naa Pɔl wà nà. Wɛɛ bɛ, bɛ làbà bànà? » ");
INSERT INTO yns_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Apan, mbuur kàkäl anà dweelà a làbe kabweel u ndür, kàsöön ba banswà u ngwal. Unkiiŋ kàkü bɛy, lalan bàtiin ba ndwà ande bànsàpɔl anà iwà u ndür. ");
INSERT INTO yns_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Baar banswà bàkäl kà Ɛfɛsɔ, Ayudà anà Angɛlɛki, bàkyer ayöb ndaa ayi, bɔɔmà waa lawɛl, ikɔb a Mwol Yɛsu kyàkäl kyàŋàsyäŋà. ");
INSERT INTO yns_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Baar mbɔɔn uboo a baar bàbulà aŋàlàkwikilà, bàyee mukyey anà mukyään nsyääl aba. ");
INSERT INTO yns_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Baar mbɔɔn uboo a baar bàfasyäälà inwɛŋ, bàtwääl in'kaan aba, waa bàsyee mya mbaa kusà a baar banswà. Mpal bàyilà ba ntal a mya, ya yàbü nsaab an'kwem an'tyeen myà itɛr a ngim. ");
INSERT INTO yns_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Undiir awun, unsà ngwal a Mwol, Ndaa yàkyer ayɛl anà yàkäl ngwal. ");
INSERT INTO yns_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ungö byàlyaaŋ indiir abi, Pɔl kàwɛl an'kyän unsà dweelà musoonà Masɛdwan anà Akayi ntɔn mukyà Yɛlusàlɛm, waa kàtɛn naa: « Mɛ insàfur atol paa, mɛ in'kyer aman Lɔmà sye. » ");
INSERT INTO yns_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ungö mutɔm Masɛdwan abɔ̈ɔ̈l uboo a baar basälà anà nde, Tumàtɛ anà Ԑlastɛ, nde ŋakwo kàsàkyer ndam a ilä kà Azi. ");
INSERT INTO yns_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Umpal ayin, lingyoomà a ngwal làkyer atoo ntɔn Mbwo. ");
INSERT INTO yns_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kàkäl anà un'kyeer a in'tak mwɛy ikɔb ande Dɛmɛtrüs, kàfakyerà bikwom a idwà a Artɛmisi anà arza. Abun asyääl ande bàwɛlà bweel mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nde kàtüüb ba anà baar asin bàfakyerà isal imwey anà ba, waa kàtɛn naa: « Abaal, bɛ làkyàyöb naa ubwaŋ abi bàfàfà unsà isal ki. ");
INSERT INTO yns_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Wɛɛ bɛ ŋakwo làkimanà anà làkiweemà: kànà kà Ԑfɛsɔ mpɛl anki, wɛɛ kà isii a Azi kyanswà, Pɔl awà wàmuni an'kyän a un'sɛŋ mbɔɔn anà musiinà ba, asànaa ukatɛɛnà nde, naa bànzam akwà bàfàfà kà an'kɔɔ abi kàbà bànzam anki. ");
INSERT INTO yns_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kà nà isal abi mpɛl anki iyàtäy, wɛɛ sye ndwà a nzam abi wàkölàköl wà un'kaar Artɛmisi ikɔ̈ɔ̈n afàyàkal anà làkoo a nzam wa bàfàsyäŋà wà kà Azi anà u mɛɛn manswà! » ");
INSERT INTO yns_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ndaa ayi yàpɛ nkyɛl mbɔɔn akà baar bàwem ya, ba bàsi in'kwɛŋ, waa bàtɛn naa: « Artɛmisi wà nzam un'kaar wàkölàköl wà baar a Ԑfɛsɔ! » ");
INSERT INTO yns_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Bul lanswà làbilà uboo a lingyoomà. Baar mbɔɔn bàkyen u ndwà a itaŋà, bàkör Gayüsi anà Aristarkà, baar a Masɛdwan abɔ̈ɔ̈l bàyilyaaŋà anà Pɔl. ");
INSERT INTO yns_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔl kàkwen mukàmɛnà kusà a un'sɛŋ, wɛɛ alɔŋki waa bun'tsüŋ. ");
INSERT INTO yns_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Andweer a isal amwɛy bàkäl asam ande, ba bàtöm baar mukun'lɔm naa nde ukɔɔn akàpà ndür ande u ndwà a itaŋà. ");
INSERT INTO yns_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Baar baar bàkäl mutɛn a ngwal unsà làkyamun, lingyoomà làkyer abilà uboo a nköŋ, bàmbɔɔn bàyöb anki isin a ndaa bàköŋ ba. ");
INSERT INTO yns_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Apan, baar uboo a un'sɛŋ bàkyään ndaa ayin akà mbuur mwɛy ikɔb ande Alɛksandre awà bàsi Ayudà nkalsà. Alɛksandre kàsɛn kɔɔ udu ntɔn muwɛɛl ba kusà a nköŋ. ");
INSERT INTO yns_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Wɛɛ mpal bàwem ba naa nde kàkäl un'yudà, ba banswà, u mun mwɛy, bàsi in'kwɛŋ tsütsü a an'taaŋ mɔ̈ɔ̈l: « Artɛmisi a Ɛfɛsɔ wàkölàköl! » ");
INSERT INTO yns_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Apan, ungö mukyäämà un'sɛŋ, nde kàtɛn naa: « Abaal a Ԑfɛsɔ, nà mpa ayöb naa Ԑfɛsɔ là bul làfàler ndwà a nzam a Artɛmisi a kölàköl anà itɛk ande kyàfü du anà kyàyàbwà u mɛɛn? ");
INSERT INTO yns_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ntɔn ndaa ayi, akà mbuur asà ya mbaaŋ watɛy, làkäl a duu, twɔn lan'kyer agyägyä. ");
INSERT INTO yns_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Wɛɛ baar bà, bɛ làmatwaal apà, baar mpa bàkyer ube akà nzam abi wà un'kaar, anà mpa bun'bɛy. ");
INSERT INTO yns_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Isàkal naa Dɛmɛtrüs anà baar kàsälà nde abà bàkwen mufüün mbuur mwɛy, ye anà mbay a nsaŋ anà ntɛɛn: wɛy baar baar bakàfüün kwo. ");
INSERT INTO yns_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kya isàkal naa bɛ làwe anà undiir asin mulɔm, wɛy un'syäl a balàbal ulɔ̈n wa. ");
INSERT INTO yns_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Naa tɛy, baar bàyiwal asànaa baar a lingyoomà ntɔn nköŋ abi yàŋàbà, ntɔn akà undiir mwɛy kan'kwo mupà bi iböŋ ntɔn nköŋ ayi watɛy. » ");
INSERT INTO yns_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ungö apan, nde kàpay baar bàköŋ. ");
INSERT INTO yns_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Mpal làwü làso lanswà, Pɔl kàtüüb alɔŋki. Ungö mukapà ngwal, laa kàsawɛy nde, waa kàkyen Masɛdwan. ");
INSERT INTO yns_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nde kàlyaaŋ kà in'tà amin mupà alɔŋki ngwal unsà an'yääm mbɔɔn. Ungö nde kàkyen Ngɛlɛsi ");
INSERT INTO yns_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","mper kàkyer nde ngɔɔn tär. Nde kàbön muwal an'swà ntɔn mukyà Siri, wɛɛ Ayudà bàdirà mukun'kyer ube. Undiiràwun kàsɔɔm nde an'kyän mufàsoonà u Masɛdwan. ");
INSERT INTO yns_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Baar bàkyen muyisal anà nde tii kà Azi babà: Sɔpatrɔs, mwan baal a Pirüs un'nsi Bɛrɛ, Aristark anà Sɛgɔn ansi Tɛsalɔnikà, Gayüs un'nsi Dɛrbɛ, Tumàtɛ anà Tishik anà Trɔfim baar a un'tà a Azi. ");
INSERT INTO yns_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ba banswà bàkyen kusà a bi, ba bàkidil u Tɔlɔwasi. ");
INSERT INTO yns_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Wɛɛ bi, bi Filipe kàlwomà ungö a ilä a mampà iköön ful, bi kàbilà kà an'swà mukàtaan ba ungö a ilä ityeen u Tɔlowasi, ikal kàkyer bi ilä nsambwaar. ");
INSERT INTO yns_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ilä atàtwɛb ungö a saba, bi kàkäl ikal imwɛy ntɔn mutsul mampà, Pɔl kàkäl muyäämà anà ba. Ntɔn ya yàlɔ̈m naa nde akyà taaŋtyà, nde kàläb an'yääm ndaay tii uboboo a mpib. ");
INSERT INTO yns_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Minà myàkäl mbɔɔn u suk adu kàköŋ bi. ");
INSERT INTO yns_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kyekà, un'tö mwɛy ikɔb ande Ötik, kàkäl wàŋàbwaay u mun a nɛl. Umpal kàkäl Pɔl mulab an'yääm ndaay, nde kàkuur a twaal. Twaal alà lun'syen nkuur, waa kàbü fà ndwà yàtär udu. Mpal bun'suub ba, nde kàkäl wàŋàkwà. ");
INSERT INTO yns_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔl laa kàtɔlà nde, waa kàkyà ntiin mper kàkäl un'tö awà. Nde kun'wɛl kà an'kɔɔ, waa kàtɛn naa: « Twɔn lan'tɛɛr, mɔ̈ɔ̈ ande wà mwo! » ");
INSERT INTO yns_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ungö mubeenà, Pɔl, kàtsül làmpà, waa kàdi. Apan, waa kàfàlab an'yääm tii làtyà taaŋ. Apan, laa kàkyen nde. ");
INSERT INTO yns_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wɛɛ akà un'tö awà, ba bun'syen anà mɔ̈ɔ̈. Ya yàpɛ ngwal mbɔɔn akà baar banswà. ");
INSERT INTO yns_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Wɛɛ bi, bi kàwɛl an'swà kusà mukyà Asɔsi, bul kàkàwal bi Pɔl, ntɔn nde kàkwen mukyà u mbwo a mɛɛn. ");
INSERT INTO yns_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Mpal kàyitaan nde u Asɔsi, bi kun'wɛl kà an'swà ntɔn mukyà Mitilɛn. ");
INSERT INTO yns_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Fà apan, bi kàläb mbwo a an'dà taaŋtyà, bi kàkàtol tsütsü a Kyɔ. Ilä kyàlääb pa, bi kàsoonà u Samɔsi. Ungö a ilä mwɛy, bi kàtöl Milɛ ungö mukɔm u Trɔzilyɔn. ");
INSERT INTO yns_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ntɔn, Pɔl kàkwen mulyaaŋ ifaŋ kà Ԑfɛsɔ, ntɔn mukɔɔn adwa taaŋ kà Azi: nde kàdüül mukal u Yɛlusàlɛm ilä a Pantɛkɔt, kya mbwo yàlàkal. ");
INSERT INTO yns_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mpalàbà, u Milɛ, Pɔl kàtöm baar mukàbel andweer a Ikööŋ a Ԑfɛsɔ. ");
INSERT INTO yns_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Utaaŋ bàyàkɔlà ba apà nde, nde kàtɛn a ba naa: « Bɛ, bɛ làkyàyöb naa mɛ anà bɛ in'fàkal aben sɛmà ilä atàtwɛb kàtɔ̈l mɛ Azi. ");
INSERT INTO yns_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mɛ kàsyääl Mwol unsà làbɔ̈ɔ̈n lanswà uboo a nsaaŋ anà uboo a in'taam myàfü u ndiirà a Ayudà. ");
INSERT INTO yns_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mɛ kàyee anki akà undiir mwɛy kan'kwo mukal wàndöŋ ntɔn bɛ. Wɛɛ mɛ kàkyer alakyään anà kàkyer alalɔŋ u mii a baar anà uboo a ndwà, ");
INSERT INTO yns_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","mukyään Ayudà anà Angɛlɛki mbuul a mpem akà Nzam anà musà làkwikilà amu Mwol abi Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Wɛɛ apanà, mɛ, mɛ in'wà aŋàbämà anà Dweelà, lalan in'kyà mɛ Yɛlusàlɛm, ukɔɔn ayöb naa ndaa nà ikan'bweel kwo. ");
INSERT INTO yns_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Wɛɛ undiir mwɛy mpɛl Dweelà In'kyɛɛl ukan'swaŋà: u bul lanswà in'siŋ anà mpay aŋàkir yàmukan'diilà. ");
INSERT INTO yns_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Wɛɛ akà mɛ, mɛ ndöŋ mbɔɔn in'paa anki akà mɔ̈ɔ̈ amɛ, undiir mwɛy awà kan'söön ubwaŋ wà mulab mbwo amɛ anà mumay isal kan'pɛ Mwol Yɛsu: utà imbäl a Làsaŋ Aŋàbwaŋ là kab a ngway a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Sɛmà apanà, mɛ, mɛ in'kyàyöb naa bɛ ntabwey amɛ làyàfàman anki, bɛ banswà baar abà kàlyaaŋà mɛ uboo a bɛ muyikyään Imwol a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Lalan, mɛ, mɛ an'kwo in'tɛ imbäl ŋàbawà kusà a bɛ naa umwɛy uboo abɛ usadiimà mbwo, nsaŋ ande ŋakwo. ");
INSERT INTO yns_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ntɔn mɛ akà undiir mwɛy kàyee anki, wɛɛ mɛ, mɛ kàlakyään an'kyän a Nzam manswà. ");
INSERT INTO yns_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Làkäl kà igyɛɛŋ ntɔn bɛ ŋakwo anà ntɔn làböl kàlapɛ Dweelà In'kyɛɛl muler, làkäl aseey a Ikööŋ a Nzam kàwɛl nde u mbwo a an'kil ande ŋakwo. ");
INSERT INTO yns_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mɛ, mɛ inkyàyöb naa ungö a nkyeen amɛ, in'kyɛŋ a nkyɛl mpa myàsàwem ngyɛb a làböl myàkyer asàbilà uboo a bɛ, ");
INSERT INTO yns_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","itàkal uboo a itsuŋ abɛ ŋakwo baar bàkyer asàmbarà mutɛn ndaa a loor ntɔn alɔŋki baläb. ");
INSERT INTO yns_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Lalan, làtsim, làyöb naa u mbul tär, mpib anà mwäänà, isal amɛ kyàkäl mutɛn a bɛ anà nsaaŋ u mii. ");
INSERT INTO yns_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","« Waa apanà, mɛ amàlapà kà an'kɔɔ a Nzam anà akà ndaa a kab a ngway ande alye anà ngwal atɔŋ anà mupà kwal akà baar aŋàkyɛɛl banswà. ");
INSERT INTO yns_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mɛ kàsàwem anki un'köl ntɔn ngim itàkal wɔl itàkal ipfey a mbuur. ");
INSERT INTO yns_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Bɛ, bɛ ŋakwo làkyàyöb naa an'kɔɔ mà, ma màsäl ntɔn indiir kàkäl bi abyà ndöŋ, mɛ anà baar bàkäl anà mɛ. ");
INSERT INTO yns_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mɛ kàlaswɛŋ taaŋ lanswà naa yubwaŋ musal abun ntɔn mubay baar abà u ngyal, muyɔbà ndaa kàtɛn Mwol Yɛsu ŋakwo naa: \"Un'sak afàkal mbɔɔn mupà akwànaa muwal!\" » ");
INSERT INTO yns_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ungö mutɛn abwɛy, nde kàbü an'köm mbwo mwɛy anà ba banswà, waa kàyamà. ");
INSERT INTO yns_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Apan ba banswà waa bàlel, bun'bweel u bway ntɔn mukundüür. ");
INSERT INTO yns_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ngyɛb aba yàmbɔɔn yàfü unsà ndaa kàtɛn nde naa ba ntabwey ande bàfàsàman anki. Apan ba bàkun'swà tii kà an'swà. ");
INSERT INTO yns_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Yàmɛnà naa ungö mukaabà anà ba a mpay anà muwal an'swà, bi kàkyen ipey tii u Kɔs, taaŋtyà bi kàkɔlà Rɔdɛ, apan bi kàkyà Patara. ");
INSERT INTO yns_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Paa, bi kàmɛn an'swà màmukyà Fɛnɛsi, laa kàbilà bi, kàkyen bi. ");
INSERT INTO yns_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Mpal kàtääl bi isaŋ a Shipɛlɛ, bi kàsàwɛy kya u kɔɔ a ikaar, waa kàwɛl mbwo mukyà mper a Siri, bi kàtɔlà u Tir, ikal màtwey an'swà buur ama. ");
INSERT INTO yns_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Akun bi kàmɛn alɔŋki, bi kàbwaay paa mpɔsà mwɛy. U mbwo a Dweelà ba bàtɛn a Pɔl naa nde ukɔɔn abeenà Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Wɛɛ mpal byàkwe ilä abi, bi kàfàwal mbwo mukyà. Ba banswà anà akyay aba anà baan aba bàkiswà tii u nsà a bul. Mpal kàtöl bi kà un'kɔɔl a an'dà, bi kàbü an'köm, waa kàyamà. ");
INSERT INTO yns_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ungö mupɛɛl mbɔr a ntsüü anà atɔŋ, bi kàbilà kà an'swà, wɛɛ ba bàfurà ndwà aba. ");
INSERT INTO yns_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Wɛɛ akà bi, bi kàmay mbwo abi yanswà sɛmà Tir tii Petɔlɛmayis, bi kàpɛ atɔŋ mbɔr, waa kàbwaay apà ba ilä mwɛy. ");
INSERT INTO yns_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Taaŋtyà, kàtoo bi, bi kàkyen Sɛzarɛ. Akun, bi kàbilà u ndwà a Filipo un'paylàsaŋ a Làsaŋ Aŋàbwaŋ, umwɛy uboo a Nsambwaar, waa bi kàbwaay paa. ");
INSERT INTO yns_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nde kàkäl abà baan akaar ankɔr anà. Ba bàfataa ngɔɔm. ");
INSERT INTO yns_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bi kàkäl paa ilä mbɔɔn, umpal kàyi ŋangɔɔm mwɛy kàfü Yuday ikɔb ande Agabüs. ");
INSERT INTO yns_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nde kayi akà bi anà kàwɛl un'di a lɔŋ a Pɔl, nde kàbäm wa kà in'kɔl anà kà an'kɔɔ ande ŋakwo, waa kàtɛn naa: « Làwem, Dweelà In'kyɛɛl an'tɛn naa mbuur aŋun'di wà, Ayudà bàsàkyer un'bäm u Yɛlusàlɛm asànaa an'bäm mɛ là, waa bàsun'yälà kà an'kɔɔ a angyey. » ");
INSERT INTO yns_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Mpal bàwem bi indiir abi, bi ŋakwo anà atɔŋ a bul alan, bi bàbɔ̈ɔ̈n Pɔl mukɔɔn abeenà Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Apan, Pɔl kàfuur naa: « Undiir nà làlelà bɛ anà làkaamà bɛ mpem amɛ? Wɛɛ akà mɛ, mɛ an'kyey, kà nà mukan'bäm in'siŋ mpɛl anki, wɛɛ anà mukwà u Yɛlusàlɛm ntɔn ikɔb a Mwol Yɛsu. » ");
INSERT INTO yns_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bi bàsàkwo anki musɔɔm an'kyän ande, bi bàkäl akul, waa bàtɛn naa: « Wɛy ukwen a Mwol bàkäl. » ");
INSERT INTO yns_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ungö a ndam a ilä, bi bàlɔ̈ɔ̈n indiir abi, waa kàbeenà Yɛlusàlɛm. ");
INSERT INTO yns_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ndam a alɔŋki uboo alɔŋki a Sɛzarɛ bàkiswà anà bisyeen mukàbɔ̈ɔ̈n u ndwà a un'nsi Shipɛle mwɛy ikɔb ande Mnasɔn. Nde kàkäl un'lɔŋki fà itaan. ");
INSERT INTO yns_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","U ntööl abi u Yɛlusàlɛm, atɔŋ biwɛl unsà un'sak wanswà. ");
INSERT INTO yns_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Taaŋtyà, Pɔl kàkyen anà bi u ndwà a Zyak, ikal bàköŋ andweer banswà. ");
INSERT INTO yns_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ungö kapɛ nde mbɔr, nde kakyään pànsi pànsi indiir byanswà kàkyer Nzam akà baar mpa abà Ayudà u mbwo a isal ande. ");
INSERT INTO yns_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ungö mukun'wem, ba bàsi Nzam làkoo, waa bàfuur akà Pɔl naa: « Un'tɔŋ, ngye akimanà, Ayudà nsaab kwe ban'sà làkwikilà, ba banswà ban'pà mɔ̈ɔ̈ aba unsà un'kɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Wɛɛ ntɔn ngye, ba bàwem in'ŋün naa ngye ayilɔŋ ndaa a nkɔɔl, naa Ayudà bàfàkal uboo a baar mpa abà Ayudà bàtön Mɔsɛ, anà mukakyään naa ba bàkɔɔn akyɛy baan aba anà bàkɔɔn alab nkääl a Ayudà. ");
INSERT INTO yns_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bi waa ikyer aben? Itàkal kaben, ba bàkyer ayàyöb naa ngye an'yà. ");
INSERT INTO yns_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Undiiràwun, ngye akyer asànaa kaswaŋ bi: bi ibye abà abaal anà bàkyàdyà kyän. ");
INSERT INTO yns_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Asyen, kadi nkwà anà ba. Fur sye ngim aba ntɔn ba bàkɔɔl ntswe aba. Abun baar banswà bàyàyöb ba naa ndaa yanswà bàwem ba ntɔn ngye kàyà ndandaa anki, wɛɛ ngye, ngye ŋakwo sye afàlab Un'kɔɔn. ");
INSERT INTO yns_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Akà baar mpa abà Ayudà bàbulà aŋàlàkwikilà, bi, bi kàkyasöön mbar kàtsül bi: ukɔɔn adyà in'twaŋ ifàfà unsà ibɔɔn bàfàpà akà itɛk, anà an'kil, anà in'twaŋ mpa bàtsül kil, anà ukɔɔn akyer ipasasɛ. » ");
INSERT INTO yns_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Apan, Pɔl kàsyen baar abà, waa kàdi nkwà anà ba taaŋtyà. Nde kàbilà u ndwà a Nzam ntɔn mukyään ilä isàwà nkwà anà bàsàpà ibɔɔn ntɔn umwɛy umwɛy uboo a ba. ");
INSERT INTO yns_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Wɛɛ ilä nsambwaar byàkäl tsütsü mukwo mpal bun'mɛn Ayudà a Azi u ndwà a Nzam. Apan ba bàsi lingyoomà uboo a un'sɛŋ a baar wanswà, waa bun'kör, ");
INSERT INTO yns_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","bàkuub in'kwɛŋ, waa bàtɛn naa: « Baar a Isàlɛl, kàlayää libay! Le mbuur akwà ayinwan anà un'sɛŋ anà un'kɔɔn abi, anà ikal ki unsà ndaa uyilɔŋ nde mper yanswà anà akà baar banswà! Nde sye kàkyàbiil Angɛlɛki uboo a ndwà a Nzam ntɔn mubɛy ikal in'kyɛɛl ki! » ");
INSERT INTO yns_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ntɔn ba bàtwab atàman Trɔfimɛ un'nsi Ԑfɛsɔ anà nde uboo a bul, lalan bàsii ba naa Pɔl kun'biil u ndwà a Nzam. ");
INSERT INTO yns_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Bul lanswà waa làni, un'sɛŋ waa kàyàköŋ. Baar bàkör Pɔl, waa bun'twey u ndwà a Nzam, apan ba bàdübà ibeenà agyägyä. ");
INSERT INTO yns_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ba bàleŋà mbwo mukun'dwa, mpal làkàtöl làsaŋ akà mfum a aŋità nsaab a Lɔmà naa Yɛlusàlɛm lanswà lan'bilà u lingyoomà. ");
INSERT INTO yns_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Taaŋ nsil alan, nde kàwɛl aŋità anà an'kaptɛn, waa kàkyà ntiin mupay un'sɛŋ u mper bàkäl ba. Mpal bàmɛn ba mfum a aŋità nsaab anà aŋità, ba bàwɛy mudüb Pɔl. ");
INSERT INTO yns_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Apan mfum a aŋità kàsin tsütsü apà nde, waa kun'kör, kàswɛŋ mukun'bäm an'dwaaŋ. Ungö apan, nde kàkwen muyöb naa nde wà nà anà nde sye ininà kan'kyer. ");
INSERT INTO yns_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wɛɛ, uboo a un'sɛŋ a baar, baar baar bàkäl mukuub in'kwɛŋ. Unsà isak isak aki, mfum a aŋità kàsàyöb anki akà undiir mwɛy. Undiir awun, kàswɛŋ nde naa Pɔl bun'syen u Fɔrtɛrɛs a aŋità a Lɔmà. ");
INSERT INTO yns_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Mpal kàkɔlà nde udu a ikaar, aŋità bàkyer un'syɛn ntɔn nkyɛl a un'sɛŋ a baar yàkäl mbɔɔn, ");
INSERT INTO yns_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ntɔn un'kàbɔ a baar kàkäl muyun'lab anà musà in'kwɛŋ naa: « Ukü! » ");
INSERT INTO yns_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","U taaŋ bàlun'biil ba u Fɔrtɛrɛs, Pɔl kàtɛn a mfum a nsaab naa: « Nkye mbwo ikyàkal mɛ mutɛn undiir mwɛy a ngye? » Mfum a aŋità kun'fuul naa: « Nkye ngye akyàyöb Ingɛlɛki? ");
INSERT INTO yns_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nkye ngye, kà ngye anki awà un'ngipiti awà kàtwääl ipaay mfwen anà kàsyen adwää baar nsaab nà u nsye a ipɔl? » ");
INSERT INTO yns_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔl kàtɛn naa: « Mɛ? Mɛ in'wà un'yudà, bul a mɛ Tarsisi u Silisi, bul làmwɛy là làkoo. Mɛ amabɔɔn, mpɛ mbwo muyääm a un'sɛŋ. » ");
INSERT INTO yns_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mfum a nsaab waa kun'pɛ mbwo. Pɔl kàkäl umbäär udu a ikaar, kàkyer isii a kɔɔ, un'sɛŋ a baar wanswà waa kàkäl a duu. Apan nde kàkyään ba unsà Ɛbɛlyɔ, waa kàtɛn naa: ");
INSERT INTO yns_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","« Atɔŋ abaal anà bàtaa, làwem un'lɔn in'kwen mɛ musà kusà a bɛ apanà. » ");
INSERT INTO yns_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Mpal bàwem ba Pɔl wàmutɛn u ndaa a Bɛbɛlyɔ, Ba bàkäl akul. Apan Pɔl waa kàtɛn naa: ");
INSERT INTO yns_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","« Mɛ, mɛ in'wà un'yudà, mɛ ban'bör u Tarsis a Silisi, wɛɛ mɛ ban'bɔŋ u bul alà, ban'lɔŋ kà in'kɔl a Ngamalyɛl asànaa awà un'kɔɔn a andweer, mɛ kàkäl anà un'kanà mbɔɔn ntɔn Nzam asànaa naa làbà bɛ banswà ŋàbawà. ");
INSERT INTO yns_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mɛ awà, mɛ kàyiiŋ Mbwo ayi ngwal tii u nkweel, mɛ kàbäm abaal anà akaar in'siŋ anà katɔɔm u bɔlokà. ");
INSERT INTO yns_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Undweer a angaŋ anà itsuŋ a andweer bà ambäl amɛ: mɛ kàwɛl anà in'kaan akà ba ntɔn mukyà Damas mukɔr atɔŋ bàkäl kwo anà mukasyen Yɛlusàlɛm ntɔn bapɛ ntaaŋàmbar. ");
INSERT INTO yns_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","« Yàmɛnà naa kàkäl mɛ u mbwo anà kàtöl mɛ tsütsü a Damas, kà imbürà, mper a midi, un'ŋyäŋ a pɛɛlà mwɛy kàfü du, waa kan'diŋà. ");
INSERT INTO yns_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mɛ kàbü u mɛɛn, umpal kàwem mɛ ndaa mwɛy itɛɛnà a mɛ naa: \"Sɔl, Sɔl, ntɔn nkye ayan'mɛɛy ngye nkwaaŋ?\" ");
INSERT INTO yns_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mɛ kàfuur naa: \"Mwol, ngye nà?\" Nde kàtɛn naa: \"Mɛ, mɛ in'wà Yɛsu Nazorye akwà afàmɛɛy ngye nkwaaŋ.\" ");
INSERT INTO yns_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Baar bàkäl anà mɛ bàkyàman un'ŋyäŋ a pɛɛlà, wɛɛ ba bàwem anki ndaa a mbuur kàyäämà anà mɛ. ");
INSERT INTO yns_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mɛ kàtɛn naa: \"Mwol, ininà mɛ an'kwo mukyer?\" Mwol kàtɛn a mɛ naa: \"Mbarà, kyen Damas, bàkyer akasam yinà yanswà kàmaswaŋ Nzam mukyer.\" ");
INSERT INTO yns_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Wɛɛ un'ŋyäŋ a pɛɛlà awun kan'dwä mii, baar bàkäl anà mɛ ban'ntɛ mpi u kɔɔ tii kàtöl mɛ Damas. ");
INSERT INTO yns_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","« U Damas, kàkäl anà mbuur mwɛy ikɔb ande Ananyas, nde kàkäl anà inzaam anà kàläbà un'kɔɔn ubwaŋàbwaŋ. Ayudà banswà bàkälà paa bun'tɛɛlà imbäl. ");
INSERT INTO yns_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nde kàkyer ayan'man, waa kàtɛn a mɛ naa: \"Un'tɔŋ amɛ Sɔl, fàman. Taaŋ nsil alan mɛ waa kàfàman, waa kun'mɛn. ");
INSERT INTO yns_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nde kàtɛn naa: \"Nzam a bàtaaràbi kasɔ̈ɔ̈l kaa usà ntɔn muyöb ukwen ande, muman Ŋabalàbal anà muwem ndaa itoo u mun ande, ");
INSERT INTO yns_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ntɔn ngye asàkal mbäl ande u mii a baar banswà unsà indiir kàmɛn ngye anà kàwem ngye. ");
INSERT INTO yns_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Wɛɛ apanà, ininà ngye afidilà? Mbarà, wal ndüümà anà mpɔɔŋà a man'be angye mutà ikɔb ande din. ");
INSERT INTO yns_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","« Yàmɛnà naa kàfurà mɛ Yɛlusàlɛm, ilä mwɛy, mɛ kàkäl muyamà u ndwà a Nzam, waa kàmɛn imanmii. ");
INSERT INTO yns_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mɛ kàmɛn Mwol, nde kàtɛn a mɛ naa: \"Kyer agyägyä, too apanà u Yɛlusàlɛm, ntɔn ba imbäl angye ntɔn mɛ bàyàkyey anki.\" ");
INSERT INTO yns_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Wɛɛ mɛ kàtɛn naa: \"Mwol, ba ŋakwo bàkyàyöb naa mɛ, mɛ kàyisaa baar u bɔlokà anà kàyikamà baar bàkäl anà làkwikilà akà ngye an'füm uboo a ndwà a nköŋ a Ayudà yanswà. ");
INSERT INTO yns_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Mpal bàdwä mbäl angye Ityen, mɛ ŋakwo kàkäl paa, mukyey baar bun'dwä anà mukaar ipfɛy aba. ");
INSERT INTO yns_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Wɛɛ nde kàtɛn a mɛ naa: \"Kyen, mɛ, mɛ ŋakwo in'yatɔm ukwɛl mper akà baar mpa abà Ayudà.\" » ");
INSERT INTO yns_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ba bàkäl mukun'weemà tii mpal kàtɛn nde ndaa ayi, ba bàkuub in'kwɛŋ, waa bàtɛn naa: « Lun'lwom u mɛɛn mbuur atub awà, nde ukwe anki mukal anà mɔ̈ɔ̈! » ");
INSERT INTO yns_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ba bàkuubà in'kwɛŋ, bàkaamà ipfɛy aba anà bàfuumà un'twà u du. ");
INSERT INTO yns_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mfum a nsaab kàswɛŋ naa bun'biil u fɔrtɛrɛs anà bun'fuul in'lɔɔn a an'füm ntɔn nde uyöb ndaa kàkyer nde ntɔn ba bàsi in'kwɛŋ ntɔn nde. ");
INSERT INTO yns_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Wɛɛ mpal bun'bäm ba in'siŋ ntɔn bun'käm an'füm, Pɔl kàtɛn a kaptɛn kàkäl paa naa: « Nkye bɛ làbye anà mbwo mukam un'lɔmà an'füm ukɔɔn un'fuul un'lɔɔn? » ");
INSERT INTO yns_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kaptɛn kàwem nde abwɛy, waa kàkàkyään mfum a nsaab: « Ngye pà akyer aben? Mbuur awà wà un'lɔmà. » ");
INSERT INTO yns_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Apan, mfum a nsaab kàyàsin apà Pɔl, waa kun'fuul: « Nkyän, nkye ndandaa ngye awà un'lɔmà? » Nde naa: « Ɛɛ. » ");
INSERT INTO yns_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mfun a nsaab waa kàtɛn naa: « Mɛ, mɛ kàfür ngim mbɔɔn ntɔn mubulà un'lɔmà. » Pɔl waa kàtɛn naa: « Mɛ, mɛ un'bar anki, ilɔmà amɛ bàkyer an'bɔr anà kya. » ");
INSERT INTO yns_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Kà imbürà, baar bàlun'kam an'füm ntɔn nde usi ndaa, waa bàtɛ upay. Wɛɛ mfum a nsaab kàwem bɔɔmà naa kyekà mbuur kàbäm nde in'siŋ wà, wà un'lɔmà. ");
INSERT INTO yns_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Lalan taaŋtyà kàkwen nde muyöb ubwaŋàbwaŋ undiir bun'füün Ayudà, nde kun'sɔɔl isiŋ ntɔn nde usi un'lɔɔn kusà a ba. ");
INSERT INTO yns_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔl kàler làbay a nsaŋ a kölàköl a tɔŋtɔŋ, waa kàtɛn naa: « Atɔŋ abaal, yà unsà an'kyän a duu mɛ kàsyääl Nzam tii ŋàbawà. » ");
INSERT INTO yns_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Wɛɛ Undweer a ngaŋ Ananyas kàswɛŋ baar bàkäl tsütsü apà nde mukun'kam mbar u mun ande. ");
INSERT INTO yns_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pɔl kàtɛn a nde naa: « Ubwaŋ a nsà, Nzam ayapà mbar! Ngye an'bwaay mukan'tsüül nsaŋ unsà un'kɔɔn, wɛɛ ngye, ngye awàmubɛy un'kɔɔn, ngye aswaŋ baar ban'käm mbar! » ");
INSERT INTO yns_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Baar bàkäl tsütsü apà nde bàtɛn a nde naa: « Ngye awàmuto undweer a angaŋ a Nzam! » ");
INSERT INTO yns_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔl kàtɛn naa: « Atɔŋ, mɛ in'yayöb anki naa nde wà undweer a angaŋ, ntɔn bàsön naa: \"Ngye asun'to anki mfum a un'sɛŋ angye!\" » ");
INSERT INTO yns_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔl kàkyer ayöb naa Làbay a Nsaŋ a kölàköl làkäl an'kab mɔ̈ɔ̈l: ndam yà Asadusi, ndam yà Amfarisi. Lalan kàkuub nde in'kwɛŋ kusà a ba: « Atɔŋ abaal, mɛ, mɛ in'wà un'mfarisi, mwan a amfarisi. Ntɔn làkyän unsà ngwiiyà a akü, ba bàman'sà u làbay a nsaŋ. » ");
INSERT INTO yns_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pa kàmay nde mutɛn, mbaaŋ yàbü uboo a Amfarisi anà Asadusi, lalan nköŋ yàkaabà ya. ");
INSERT INTO yns_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ntɔn Asadusi bàfàtɛn naa itàkal ngwiiyà kà ukwà, itàkal un'kyeey, itàkal dweelà batɛy, wɛɛ Amfarisi bàfàkyey naa ba bà mwo. ");
INSERT INTO yns_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","In'kwɛŋ myàkyer asöönà mbɔɔn, alɔɔŋ a in'kɔɔn amwɛy uboo a Amfarisi waa bàmbarà, bàtɛn a ngwal naa: « Bi akà ndaa mwɛy yà ube imanà anki unsà mbuur wà. Taaŋ lumwɛy dweelà làmwɛy akɔ̈ɔ̈n sye un'kyeey mwɛy kun'kyään ndaa! » ");
INSERT INTO yns_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Mbaaŋ yàbulà yà ngwal. Ntɔn bɔɔmà muman naa ba ban'kwo musay Pɔl, mfum a nsaab kàswɛŋ aŋità ande mutyà anà mukun'lwom uboo a ba anà mukun'syen u fɔrtɛrɛs. ");
INSERT INTO yns_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","U mpib yàlääb paa, Mwol kàyàmɛnà akà Pɔl, waa kàtɛn a nde naa: « Tsim! Ngye an'tà imbäl amɛ apà u Yɛlusàlɛm, ngye akyer afàkàtà sye u Lɔmà. » ");
INSERT INTO yns_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Taaŋtyà, Ayudà bàkyer adirà, waa bàdi kyän naa ba bàdyà anki anà bànwà anki tii mpal bàsàdwa ba Pɔl. ");
INSERT INTO yns_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Baar bàdirà ndaa ayi bàkäl aŋàsöön ankweem an'nà. ");
INSERT INTO yns_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Apan, ba bàkàman amfum a angaŋ anà andweer, waa bàtɛn naa: « Bi kan'bɔl un'kaan anà kan'dyà kyän naa bi undiir idyà anki kusà mudwa Pɔl. ");
INSERT INTO yns_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Wɛɛ akà bɛ apanà, mbwo mwɛy anà Làbay a Nsaŋ a Kölàköl, làkyen kàlalɔ̈m mfum a aŋità naa nde kàlatwääl awà asànaa bɛ làkwen mulab ndaa ande pànsi pànsi. Wɛɛ bi, bi indiir byanswà ikyàlɔn ntɔn mukun'dwa kusà nde muyàkɔlà apà. » ");
INSERT INTO yns_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Wɛɛ mwanàmpääŋ a Pɔl wàbaal kàwem ndiirà ayi, nde kàkyen fɔrtɛrɛs, waa kàbilà ntɔn mukyään Pɔl naa nde ukäl kà igyɛɛŋ. ");
INSERT INTO yns_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pɔl kàbel umwɛy uboo a aŋità, waa kàtɛn a nde naa: « Lun'syen mwan baal wà akà mfum a aŋità ntɔn nde we anà ndaa mukun'kyään. » ");
INSERT INTO yns_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kaptɛn awà kàsyen mwan baal awun akà mfum a nsaab, waa kàtɛn naa: « Mbuur a bɔlokà Pɔl akyer an'bel, waa kan'lɔ̈ɔ̈m mukatwääl mwan baal wà awe anà undiir akakyään. » ");
INSERT INTO yns_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mfum a nsaab kàtɛ mwan baal awun mpi u kɔɔ, kun'syen u mpey, waa kun'fuul naa: « Ininà ngye awe awà mukan'kyään? » ");
INSERT INTO yns_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nde kun'fuur naa: « Ayudà ban'lwɛɛŋ naa ba bàyàlɔm akà ngye naa ngye asyen Pɔl nkàswo u Làbay a Nsaŋ a Kölàköl asànaa ba bàkwen ulab ndaa ande pànsi pànsi. ");
INSERT INTO yns_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Wɛɛ ngye, ngye twɔn amakyey, ntɔn aŋàsöön baar an'kwem an'nà uboo a ba bàkun'diil ndɔɔŋ u mbwo. Ba bàdi kyän naa ba bàdyà anki anà bànwà anki tii mpal bàyun'dwa ba. Ba ndaa yanswà ban'yöŋà, yan'sal nkyeey angye mpɛl. » ");
INSERT INTO yns_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Apan mfum a nsaab kàfuur mwan baal awun ungö akun'swaŋ naa: « Twɔn an'kyään akà mbuur mwɛy naa mɛ an'yöb ndaa ayi. » ");
INSERT INTO yns_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ungö apan, mfum a nsaab kàbel baar bɔ̈ɔ̈l uboo a an'kaptɛn, waa kàtɛn a ba naa: « Làsɔ̈ɔ̈l aŋità nkam yweel, asyeen a mpoonà an'kwem nsambwaar anà aŋanwɛŋ nkam yweel, ntɔn u taaŋ làwà là mpib ba bàkyà Sɛzarɛ. ");
INSERT INTO yns_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Làlɔ̈ɔ̈n sye mpoonà ntɔn musyen Pɔl ntɔn nde ukàtol unsà ubwaŋ banswà akà kuvɛrnɔ̈ɔ̈r Filikisi. » ");
INSERT INTO yns_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Apan, nde kàsön un'kaan abà: ");
INSERT INTO yns_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","« Kɔlɔdɛ Lizyasi akà mwol Filikisi, làköm angye! ");
INSERT INTO yns_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mbuur wà, Ayudà bakyer un'kɔr anà bàkyer alun'dwa. Mpal kàwem mɛ naa nde wà un'lɔmà, mɛ kàkyen anà aŋità ntɔn mukun'lwom kan'kɔɔ aba. ");
INSERT INTO yns_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mɛ kàkwen muyöb isin a ndaa bun'füün ba, lalan kun'syen mɛ kusà a Làbay a Nsaŋ a Kölàköl. ");
INSERT INTO yns_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mɛ, mɛ kàmɛn naa ba bun'füün ntɔn ndaa a un'kɔɔn aba, wɛɛ akà ube mwɛy kàkyer nde batɛy ntɔn bun'dwä itàkal bun'bäm in'siŋ. ");
INSERT INTO yns_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kan'wem mɛ sye naa Ayudà bàmulɛɛ untaam, lalà amatööm mɛ awà anà an'swaŋ mɛ baar bun'füün naa ba ŋakwo bun'füün akà ngye. » ");
INSERT INTO yns_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Aŋità bàläb ndaa baswɛŋ, waa bàwɛl Pɔl, bun'syen u mpib u Antipatris. ");
INSERT INTO yns_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Taaŋtyà, ba bàwɛy asyeen a mpoonà mulab mbwo anà Pɔl, waa bàfurà fɔrtɛrɛs. ");
INSERT INTO yns_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Mpal bàtöl ba Sɛzarɛ, asyeen a mpoonà bàpɛ mfum un'kaan, waa bun'swɛŋ Pɔl sye. ");
INSERT INTO yns_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ungö kàtäŋ nde un'kaan, nde kàfuul naa Pɔl wà mbuur a itiir a nsi nà. Mpal kàwem nde naa nde wà mbuur a Silisi, ");
INSERT INTO yns_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","nde kàtɛn naa: « Mɛ in'yawem mpal bàyàyà sye baar bafüün. » Apan, nde kàswɛŋ naa bun'si u làpaŋ a Ɛlɔdi. ");
INSERT INTO yns_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ungö a ilä ityeen, mfum a angaŋ Ananyas anà andweer anà nkalsà mwɛy ikɔb ande Tɛrtülüs, bàtyà ntɔn mufüün Pɔl akà kuvernɔ̈ɔ̈r. ");
INSERT INTO yns_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Apan, ba bàbel Pɔl. Tɛrtülüs kàsɛmà mukun'füün abà: « Mwol Filikisi, mbɔr angye. Ntɔn ngye anà ndaa akün an'kyer ngye ntɔn musyen nsi unsà ubwaŋ banswà, lalan ibà bi uboo a duu aŋàkwo. ");
INSERT INTO yns_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Taaŋ lanswà anà ntsü yanswà, bi ibàmukömà ubwaŋ angye. ");
INSERT INTO yns_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Wɛɛ mukɔɔn akà adwääl taaŋ mbɔɔn, mɛ in'tɛn ikikye, lalan mɛ amalɔm mukan'wem unsà igyɛɛŋ kyanswà asànaa kayöb bi. ");
INSERT INTO yns_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Bi kan'man naa mbuur wà, wà fway, nde wàmuyisà lingyoomà uboo a Ayudà banswà u mɛɛn manswà ntɔn nde wà mfum a Bànazɔrye. ");
INSERT INTO yns_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nde sye alàkwen mubɛy un'kyɛɛl a ndwà a Nzam, undiir awun bun'kör bi. Bi bàkwen mutsul nsaŋ ande asànaa ukalɔɔmà un'kɔɔn abi, ");
INSERT INTO yns_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","wɛɛ mfum a nsaab waa kàyun'duum a ngwal yanswà kà an'kɔɔ abi. ");
INSERT INTO yns_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Abun, ngye, ngye ŋakwo asun'fuul un'lɔɔn, ngye akyer akyey naa ndaa kàmun'füün bi yà ndandaa. » ");
INSERT INTO yns_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayudà banswà bàkyey naa ndaa yanswà kàtɛn Tɛrtülüs yà abwɛy. ");
INSERT INTO yns_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Apan kuvɛrnɔ̈ɔ̈r kun'swɛŋ musà ndaa, Pɔl waa kàfuur abà: « Mɛ in'kyàyöb naa sɛmà mbul mbɔɔn ngye afàswaŋ balàbal akà un'sɛŋ abi: undiirawà, waa mɛ an'sà làkyän akà ngye, mɛ in'sà un'lɔɔn amɛ kusà angye. ");
INSERT INTO yns_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ngye an'kwo ayim ubwaŋàbwaŋ: ilyaaŋ anki ilä kwem aŋiyweel kàbeenà mɛ Yɛlusàlɛm ntɔn mukàsyäŋà. ");
INSERT INTO yns_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Itàkal u ndwà a Nzam, itàkal u ndwà a nköŋ a Ayudà, itàkal uboo a bul, akà mbuur mwɛy kan'mɛn anki musà mbaaŋ anà mbuur itàkal musiinà un'sɛŋ a baar mukyer lingyoomà. ");
INSERT INTO yns_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ba bàkwo anki mukaswaŋ apanà indiir bàkan'füünà ba. ");
INSERT INTO yns_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Wɛɛ mɛ, ndaa in'yöb mɛ kusà angye ayi: mɛ in'fàsyääl Mbwo ayà bàmanà ba naa yà loor. Mɛ in'fàsyääl Nzam a andweer abi. Làkwikilà amɛ là unsà ndaa yanswà bàsön uboo a Un'kɔɔn anà uboo a Aŋangɔɔm. ");
INSERT INTO yns_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Làkyän amɛ là akà Nzam, ba ŋakwo sye bàkyer afàkyey la, naa baar mpa abà balàbal anà baar a balàbal bàkyer asàwiyà. ");
INSERT INTO yns_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Lalan mɛ sye in'fàsà mɛ ngwal taaŋ lanswà mukal anà an'kyän mpa ban'kwo mubɛy kusà a Nzam anà kusà a baar. ");
INSERT INTO yns_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Ungö a mbul mbɔɔn, mɛ kàyàfurà u Yɛlusàlɛm ntɔn mubay un'sɛŋ amɛ anà mupà an'kab. ");
INSERT INTO yns_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Apan ba bàyan'man u ndwà a Nzam ungö a mpɔ̈ɔ̈ŋ amɛ: akà nköŋ mwɛy itàkal làso làmwɛy làkäl anki. ");
INSERT INTO yns_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Wɛɛ Ayudà amwɛy bà Azi bàkäl paa, ba baar bàlàkwo muyàmɛnà kusà a ngye mukan'füün ilàkal naa ba bàkäl anà undiir atɛn a mɛ. ");
INSERT INTO yns_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Itàkal ba abà, ba ŋakwo bàtɛn ndaa a ube bàmɛn ba mpal kasi mɛ un'lɔɔn u Làbay a Nsaŋ a Kölàköl. ");
INSERT INTO yns_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Taaŋ lumwɛy ndaa mwɛy mpɛl kàsi mɛ umbäär kusà a ba naa: \"Yà ntɔn ngwiiyà a akü lalan bàman'füün ba ŋàbawà kusà a bɛ!\" » ");
INSERT INTO yns_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filikisi kàkyer ayöb ubwaŋàbwaŋ ndaa a Mbwo, waa kàsin mutsul ungö anà mutɛn naa: « Mɛ ndaa abɛ in'yàtsul mpal uyàtyà mfum a nsaab. » ");
INSERT INTO yns_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Apan nde kàswɛŋ kaptɛn mwɛy mukaar Pɔl u bɔlokà anà mukun'pà mbwo naa atɔŋ ban'kwo mukun'bay. ");
INSERT INTO yns_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ungö a ndam a ilä, Filikisi kàkäl anà un'kyay ande Dulàsiye, un'kaar un'yudà, nde kàtöm baar mukàbel Pɔl. Nde kàkwen mukun'wem ntɔn ndaa a làkwikilà unsà Klistɔ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Wɛɛ mpal kàsɛmà Pɔl mutɛn ndaa mukal anà mɔ̈ɔ̈ a balàbal anà nkääŋ a mpem anà nsaŋ isàyà kusà, Filikisi kàwem bɔɔmà, waa kàtɛn naa: « Apanà ngye an'kwo afurà. Taaŋ làsàkal mɛ in'kyer afasàbel. » ");
INSERT INTO yns_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nde kàsii naa Pɔl ayun'pà ngim, undiir awun kàfatɔmà nde baar mbalà mbɔɔn mukun'bel u bɔlokà ntɔn muyäm anà nde. ");
INSERT INTO yns_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ungö a mbul yweel, Filikisi bun'kiir akà Pɔrsyus Fɛstüs. Wɛɛ, ntɔn muswaŋ ubwaŋ ande akà Ayudà, nde kàsàwɛy Pɔl u bɔlokà. ");
INSERT INTO yns_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ungö a ilä itär a ngyeel ande kà itiir a nsi akin, Fɛstüs kàbeenà Yɛlusàlɛm fà Sɛzarɛ. ");
INSERT INTO yns_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Amfum a angaŋ anà andweer a Ayudà bayi mufüün Pɔl akà nde. ");
INSERT INTO yns_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ba bàsi muküünà mulɔm naa nde kakyeer ndam a ubwaŋ mubel Pɔl u Yɛlusàlɛm. Kutɛn aŋàbwaŋ ba bàdirà mukun'dwa u mbwo. ");
INSERT INTO yns_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Wɛɛ Fɛstüs kàfuur naa bɔlokà a Pɔl là u Sɛzarɛ, anà nde ŋakwo kàkäl u mbwo mufurà. ");
INSERT INTO yns_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nde kàkwɛy naa: « Wɛy baar a an'yeerà uboo a bɛ bàtüüb anà mɛ, ntɔn bi ityà Sɛzarɛ. Kya isàkal naa we anà undiir un'be mbuur awà kàkyer, waa ba bun'füün. » ");
INSERT INTO yns_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛstüs kàkäl aŋàsöön ilä naan akɔ̈ɔ̈n kwem apà ba, ungö waa kàtyà Sɛzarɛ. Taaŋtyà, nde kàbwaay u làbay a nsaŋ, waa kàswɛŋ naa bun'twääl Pɔl. ");
INSERT INTO yns_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Mpal kàyàkɔlà nde, Ayudà bàfü Yɛlusàlɛm bàkyer un'diŋà, waa bun'füün ndaa a ngwalàngwal mbɔɔn, wɛɛ ba bàsàswaŋ anki naa ya yà ndandaa. ");
INSERT INTO yns_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Wɛɛ Pɔl kàsi un'lɔɔn ande, waa kàtɛn naa: « Mɛ akà undiir mwɛy wà ube in'kyer anki, itàkal unsà Un'kɔɔn a Ayudà, itàkal u ndwà a Nzam, itàkal akà Sɛzar. » ");
INSERT INTO yns_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ntɔn mumɛnà mbuur aŋàbwaŋ kusà a Ayudà, Fɛstüs kàfuul Pɔl naa: « Nkye ngye akyàkwen mubeenà Yɛlusàlɛm ntɔn bàtsül ndaa angye u mii amɛ? » ");
INSERT INTO yns_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Wɛɛ Pɔl kàfuur naa: « Mɛ in'wà u làbay a nsaŋ a Sɛzar, nsaŋ amɛ bàkàtɛn kwo. Akundiir mwɛy wà ube an'kyer mɛ Ayudà watɛy asànaa ngye ŋakwo ayöb ngye ubwaŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Isàkal naa ndandaa mɛ kàkyer ube mwɛy ban'kwo mutwaal ukwà, mɛ ukwa in'tɔn anki. Wɛɛ, isàkal naa ndaa ban'füünà baar ndɔ̈ŋ aya yatɛy, akà mbuur mwɛy ukwe anki mukan'pà kà an'kɔɔ aba. Mɛ an'lɔm naa Sɛzar utsül ndaa amɛ. » ");
INSERT INTO yns_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Apan, ungö mulwɛɛŋ anà ntɛɛn ande, Fɛstüs kàfuur naa: « Ngye an'lɔm muman Sɛzar, ngye akyer akyà kusà a Sɛzar. » ");
INSERT INTO yns_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ungö a ilä, mfum Angilàpà anà Bɛrnis bàyi u Sɛzarɛ ntɔn mupà Fɛstüs mbɔr. ");
INSERT INTO yns_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ba paa bàkyer ilä mbɔɔn, lalan Fɛstüs kàkyään nde mfum ndaa a Pɔl mutɛn naa: « We anà baal mwɛy Filikisi kàsàwɛy u bɔlokà. ");
INSERT INTO yns_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Umpal kàbeenà mɛ Yɛlusàlɛm, amfum a angaŋ anà andweer a Ayudà bàkyer ayà mukun'füün, ba bàkwen naa bun'dwä ndwà. ");
INSERT INTO yns_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mɛ ba kafuur naa: \"Kya kà ifà a baar a Lɔmà anki mupà mbuur kà an'kɔɔ a baar, isàkal naa kusà ande baar bun'füün batɛy, isàkal sye naa nde un'lɔɔn ŋàtàsà anki.\" ");
INSERT INTO yns_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ba bàyi apà anà mɛ. Mukɔɔn afàsà ilä, taaŋtyà mɛ kàbwaay u làbay a nsaŋ, mɛ kàlɔ̈m naa bun'twääl mbuur awun. ");
INSERT INTO yns_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ayiiŋ ande bàyi ba, ba bàsàmɛɛy anki akà undiir mwɛy wà ngwal uboo indiir ibe kàyweerà mɛ. ");
INSERT INTO yns_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Undiir mwɛy bàkäl ba awà anà nde yà mbaaŋ ntɔn inzaam aba ŋakwo, sin sin ntɔn mbuur mwɛy ikɔb ande Yɛsu, nde kàkyer akwà, wɛɛ Pɔl akakyeyà uyɔl naa nde we anà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ya yàkäl mpay akà mɛ mutsul ndaa a tub ayi, lalan kàpɛ mɛ Pɔl lwɛŋ mubeenà Yɛlusàlɛm ntɔn bàkàtsul nsaŋ ande kwo. ");
INSERT INTO yns_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Wɛɛ Pɔl kàlɔ̈m naa ndaa ande bàkàtsul kusà a Sɛzar. Lalan kàswɛŋ mɛ naa bun'käär u bɔlokà tii mpal in'sun'tɔm mɛ akà Sɛzar. » ");
INSERT INTO yns_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Waa Angilipà kàtɛn a Fɛstüs naa: « Mɛ ŋakwo sye in'kwen muwem mbuur awà. » Fɛstüs kun'fuur naa: « Ngye ayun'wem nkàswo. » ");
INSERT INTO yns_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Taaŋtyà, Angilipà anà Bɛrnis bàyi unsà làso lanswà, waa bàbilà u làbay a nsaŋ mbwo mwɛy anà amfum a nsaab anà abyääl a bul. Fɛstüs kàswɛŋ naa bun'twääl Pɔl. ");
INSERT INTO yns_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fɛstüs kàtɛn naa: « Mfum Angilipà, anà bɛ banswà làbà pà anà bi, bɛ làkyun'manà mbuur wà. Un'kàbɔ a Ayudà kàyun'füün akà mɛ, itàkal u Yɛlusàlɛm, itàkal apà, bàmusà in'kwɛŋ naa nde ufàkwo anki mukal anà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Wɛɛ akà mɛ, mɛ in'sàman anki undiir un'be kàkyer nde ntɔn nde ukyà an'lɔŋ. Wɛɛ nde ŋakwo kàlɔ̈m naa nde ukyà akà Sɛzar, mɛ kàtsül naa mɛ in'kyer un'tööm awà. ");
INSERT INTO yns_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Itàkal abwɛy, mɛ in'manà anki undiir in'söön mɛ Sɛzar, lalan, an'kwen mɛ naa nde usi un'lɔɔn u mii a bɛ, sin sin u mii a ngye Mfum Angilipà, ntɔn mɛ in'wɛl undiir asɔn ungö a nköŋ ayi. ");
INSERT INTO yns_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ntɔn akà mɛ, ya ikamɛnà naa kà yubwaŋ anki naa mɛ in'töm mbuur a bɔlokà ukɔɔn aswaŋ ubwaŋàbwaŋ ube kàkyer nde. » ");
INSERT INTO yns_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Angilipà kàtɛn a Pɔl naa: « Bàmapà mbwo musà un'lɔɔn angye. » Apan nde kàsen kɔɔ ntɔn musà un'lɔɔn ande: ");
INSERT INTO yns_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","« Mfum Angilipà, mɛ an'man un'sak mbɔɔn musà un'lɔɔn kusà a ngye ŋàbawà ntɔn indiir byanswà bàman'füün Ayudà, ");
INSERT INTO yns_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","sin sin ngye akyàyöb ubwaŋàbwaŋ nkääl a Ayudà anà nsyeel a mbaaŋ aba. Kyakin mɛ amalɔm mukan'wem anà igyɛɛŋ unsà nkääŋ a mpem yanswà. ");
INSERT INTO yns_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","« Ntɔn mɔ̈ɔ̈ amɛ, sɛmà imbɛy, Ayudà banswà bàkyàyöb wa, ntɔn mɛ kàkäl u Yɛlusàlɛm uboo a un'sɛŋ amɛ. ");
INSERT INTO yns_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ba ŋakwo bàkyàyöb fà itaan, ba ban'kwo bàtɛ imbäl, kya ba bàsàkwen, naa mɛ in'wà umwɛy uboo a Ikööŋ a Amfarisi ifàlab inzaam abi pànsi pànsi. ");
INSERT INTO yns_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Apanà, mɛ bàman'füün ntɔn làkyän amɛ unsà ilää kàpɛ Nzam akà andweer abi. ");
INSERT INTO yns_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","In'sɛŋ abi myanswà myàkwem aŋiyweel myàfàsyääl Nzam uboo a muküünà mpib anà mwäänà ntɔn muman nkölà a ilää aki. Ɔɔ Mfum, ntɔn làkyän alà, Ayudà waa bàman'füün! ");
INSERT INTO yns_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ntɔn nkye mpa làkyeyà bɛ naa Nzam afàwiy akü? ");
INSERT INTO yns_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mɛ ŋakwo, mɛ kàyweerà naa yubwaŋ munwan a ngwal yanswà anà ikɔb a Yɛsu Nazɔrye. ");
INSERT INTO yns_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Undiir nsil awà mɛ kàkyer u Yɛlusàlɛm. Mɛ kàbiil baar in'kyɛɛl mbɔɔn u bɔlokà mpal kàwɛl mɛ ikɔ̈b akà andweer a angaŋ, mɛ sye kàkyer akyeyà naa badwä. ");
INSERT INTO yns_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mɛ kàyibilà mbalà mbɔɔn u ndwà a nköŋ a Ayudà yanswà ntɔn mukapà ntaaŋàmbar anà mukasiinà a ngwal yanswà ba mubɛy làkwikilà aba. Uboo a nkyɛl amɛ yanswà, akà ba, mɛ ba kàyalabà tii kà an'bul a ingyey. » ");
INSERT INTO yns_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","« Lalan ilä mwɛy mɛ kàkyà Damas anà ikɔ̈b aŋàkwo anà isal ban'pɛ amfum a angaŋ. ");
INSERT INTO yns_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ɔɔ Mfum, ilä mwɛy ntsü a midi, mɛ kàkäl u mbwo, mɛ anà atɔŋ bàkäl anà mɛ, mpal kàmɛn mɛ un'ŋyäŋ a pɛɛlà wàŋàsöönà taaŋ kan'fà du, waa kan'diŋà. ");
INSERT INTO yns_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Bi banswà kàbü u mɛɛn, waa mɛ kàwem ndaa mwɛy ikan'kyäänà unsà Ibɛlyɔ naa: \"Sɔl, Sɔl, ntɔn nkye ayan'mɛɛy ngye nkwaaŋ? Yà mpay akà ngye mutɔn un'swaaŋ!\" ");
INSERT INTO yns_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mɛ kàfuur naa: \"Mwol, ngye awà nà?\" Mwol waa kan'fuur naa: \"Mɛ, mɛ in'wà Yɛsu akwà ayimɛɛy ngye nkwaaŋ. ");
INSERT INTO yns_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Wɛɛ mbarà, tsim kà in'kɔl angye. An'yàmɛnà mɛ akà ngye ntɔn mɛ kàkyasɔɔl kusà mukal un'syääl anà mbäl unsà indiir kàmɛn ngye anà unsà indiir in'yàfamɛɛy mɛ. ");
INSERT INTO yns_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mɛ ngye akyasɔɔl uboo a un'sɛŋ wà anà uboo a baar mpa abà Ayudà mper amatɔm mɛ. ");
INSERT INTO yns_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mɛ ngye amatɔm ntɔn ngye aduub ba mii, alwom ba u mpib anà atwääl u pɛɛlà anà akà Nzam fà ikɔ̈b a Satanà, ntɔn ba bàwɛl ndwääl a man'be aba anà kwal uboo a aŋin'kyɛɛl u mbwo a làkwikilà amu mɛ.\" » ");
INSERT INTO yns_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","« Unsà ayi yanswà, mfum Angilipà, mɛ kàtön anki imanmii kyàfü du ki. ");
INSERT INTO yns_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Wɛɛ mɛ kàtàlɔŋ baar a Damas, u Yɛlusàlɛm, kà itiir a Yuday kyanswà, anà akà in'sɛŋ mpa abà Ayudà, ntɔn ba bàbuul mpem anà bàpɛ mɔ̈ɔ̈ aba akà Nzam anà muswaŋ nsɔɔmà ayi u nsyääl aba. ");
INSERT INTO yns_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Undiir awun Ayudà ban'kör ba mpal kàkäl mɛ u ndwà a Nzam, laa bàleŋ ba mukan'dwa. ");
INSERT INTO yns_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Wɛɛ Nzam laa kan'tii nde, lalan mɛ in'wa mɛ anà mɔ̈ɔ̈ tii ŋàbawà, mɛ in'wàmuyità imbäl kusà a ambɛy anà andweer ndaa bàtɛn aŋangɔɔm anà Mɔsɛ naa ya isàkyer ayà, ");
INSERT INTO yns_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","muyöb naa Klistɔ kàkyer alàman mpay, naa nde, nde alàkal mbuur atàtwɛb mutoo uboo a akü, naa nde akyään pɛɛlà akà un'sɛŋ anà akà baar mpa abà Ayudà. » ");
INSERT INTO yns_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔl kàkäl musà un'lɔɔn ande mpal kàsi Fɛstüs in'kwɛŋ naa: « Pɔl, ngye awà ŋun'kɔŋ! Un'yɛnà angye wà mbɔɔn kàmatwääl ukɔŋ! » ");
INSERT INTO yns_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Wɛɛ Pɔl kun'fuur naa: « Un'byääl Fɛstüs, mɛ kà in'wà ŋukɔŋ anki. Ndaa in'kyäänà mɛ yi yà ndandaa anà yan'kyän aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ntɔn Mfum awà in'kakyäänà mɛ unsà uyɔl banswà, akyàyöb indiir abi ubwaŋàbwaŋ. Mɛ in'we anà iböŋ muyweer naa undiir mwɛy udiimà nde watɛy, ntɔn ndaa ayi yàlyaaŋ anki kunku, kà ikal aŋàyee. ");
INSERT INTO yns_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mfum Angilipà, nkye ngye afàsà làkwikilà akà aŋangɔɔm? Mɛ in'kyàyöb naa ngye awe anà làkwikilà. » ");
INSERT INTO yns_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Angilipà waa kàtɛn a Pɔl naa: « Le, ngye akwen mukan'buul un'klistɔ! » ");
INSERT INTO yns_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Nde kàfuur naa: « Mɛ in'kwenà naa itàkal naa taaŋ ikikye, naa taaŋ mbɔɔn, wɛy Nzam ukyer naa kà nà ngye mpɛl anki, wɛɛ sye anà baar banswà bàweemà mɛ ŋàbawà, bɛ làbulà asànaa mɛ ukɔɔn in'siŋ mii. » ");
INSERT INTO yns_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mfum waa kàmbarà, anà kuvɛrnɔ̈ɔ̈r, Bɛrnis anà baar banswà bàtɛɛnà nsaŋ. ");
INSERT INTO yns_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ba bàkyen nku, waa bàtɛn ba a ba naa: « Mbuur wà undiir mwɛy kan'kyer nde watɛy ntɔn nde uwɛl ukwà itàkal in'siŋ. » ");
INSERT INTO yns_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Apan, Angilipà kàsam Fɛstüs naa: « Mbuur wà bàkyer alun'wɛy ilàkal naa nde ukɔ̈ɔ̈n alom muman Sɛzar. » ");
INSERT INTO yns_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Mpal bàtsül mbar naa bi iwal an'swà mukyà Itali, ba bàpɛ Pɔl anà baar a bɔlokà amwɛy akà kaptɛn mwɛy ikɔb ande Zülyüs, umwɛy uboo a itsuŋ a Lɔmà bàfàbel naa Itsuŋ a Sɛzar. ");
INSERT INTO yns_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Bi kàbilà kà an'swà a Adalamit màyilyaaŋà à kun'kɔɔl a Azi, waa kàkyen. Un'nsi Masɛdwan a Tɛsalɔnikà mwɛy ikɔb ande Aristark kàkäl anà bi. ");
INSERT INTO yns_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Taaŋtyà, bi kàmbär u Sidɔn. Zülyüs kàwɛlà Pɔl unsà ubwaŋ banswà, nde kun'pɛɛ mbwo mukàler asam ande ban'kwo mukun'bay. ");
INSERT INTO yns_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kan'lwomà bi apan, bi kàläb kà an'dà, kàlyaaŋ kà un'kɔɔl a Shipɛlɛ ntɔn un'pöb kiyeelà lisà. ");
INSERT INTO yns_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Apan bi kàbwel ngyäl a kölàköl tsütsü a Silisi anà Pamfili, waa kàtɔlà u Mira a Lisi. ");
INSERT INTO yns_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Akun, kaptɛn kàmɛn an'swà a Alɛksandri màmukyà Itali, laa kibiil nde. ");
INSERT INTO yns_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Bi kàkyer ilä mbɔɔn ntɔn an'swà màyikyeenà ikye ikye, a mpay yanswà bi, kàkàtöl bi tsütsü a Snide. Ntɔn un'pöb kàyee wa lisà, bi kàlyaaŋ u ngyɛl a isaŋ a Krɛte, tsütsü a Salmɔnɛ. ");
INSERT INTO yns_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Bi kya kàlyaaŋ a mpay yanswà tii kàkàtol bi kà ikal mwɛy bàfàbel Bo Pɔr, tsütsü a bul làmwɛy ikɔb a la Lasàyà. ");
INSERT INTO yns_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Taaŋ làmwɛy làbwɛlàbwɛl làlyaaŋ, nkyeen udu a an'dà yàbulà yà bɔɔmà, ntɔn ilä a ukin udyà a Ayudà kyàkäl aŋàlyaaŋ itaan, Pɔl waa kakyään, ");
INSERT INTO yns_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","kàtɛn naa: « Asam amɛ, mɛ in'manà naa nkyeen udu a an'dà itwaal ube mbɔɔn, indiir mbɔɔn ikyà bwà, kànà isaa anà an'swà mpɛl anki, wɛɛ anà mɔ̈ɔ̈ a baar abi sye. » ");
INSERT INTO yns_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Wɛɛ mfum a nsaab a Lɔmà mpem ande kàpɛ akà kaptɛn a an'swà anà akà ŋan'swà, akwànaa akà ndaa a Pɔl. ");
INSERT INTO yns_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Yumwɛy ayi: làbuŋ alà làkwe anki naa baar bàkäl paa u paŋà a mpye. Lalan baar mbɔɔn bàkäl ba an'kyän mwɛy naa ba bàläb mbwo aba anà muleŋ mukɔlà Fɛniksi, làbuŋ làmwɛy là Krɛt bàduub mper làfàminà taaŋ ntɔn isà ilyaaŋ kwo. ");
INSERT INTO yns_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kipöb kyàfü ngyɛl, waa kyàlyaaŋà, apan ba bàsii naa ma màkäl an'kyän aŋàbwaŋ, ba bàtsuuŋ an'swà, bàsɛmà muyikyà ukɔl a isaŋ a Krɛt. ");
INSERT INTO yns_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Wɛɛ ungö a kitaaŋ, un'pöb a ngwal awà bàfàbel naa Örakilɔ­n, kàfü isaŋ akin, waa kàyabweel, ");
INSERT INTO yns_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","kàsyen an'swà, ma màkwe anki munwaan a un'pöb, laa kàwɛy bi naa wa kisyen. ");
INSERT INTO yns_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Bi kàlyaaŋ u ngyɛl a kisaŋ bàfàbel Kɔda, bi kàböŋ a mpay muwal itiir a un'sɛŋ. ");
INSERT INTO yns_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ungö mufuur kya uboo, unsà bɔɔmà mukàböl kà anseŋ a Sirt, ba bàbäm an'swà in'siŋ asànaa nkwɛl, waa bàtɔɔm löŋ. Ba bàläb muyiwɔŋ abun. ");
INSERT INTO yns_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Un'pöb a ngwal kàkäl mukàyisiinà a ngwal, lalan taaŋtyà bàtɔɔm ba indiir kan'dà. ");
INSERT INTO yns_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kà ilä kyàtär, ba bàtɔɔmà anà an'kɔɔ aba ŋakwo indiir a isal a an'swà. ");
INSERT INTO yns_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ilä mbɔɔn, itàkal taaŋ, itàkal mbwaar myàmɛnà anki, un'pöb a ngwal kàkäl mbɔɔn, lalan mpa kàkäl bi anà làkyän muwà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","An'taaŋ mbɔɔn baar badi anki. Apan, Pɔl kàmbarà uboboo a ba, waa kàtɛn naa: « Ɔɔ asam amɛ, yàlàkal ubwaŋ naa bɛ làwem lwɛŋ amɛ mukɔɔn ambarà u Krɛt, ntɔn mukɔɔn ayàman nkweel ayi anà bwà alà. ");
INSERT INTO yns_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Wɛɛ apanà, mɛ amàlalɔm musà un'kanà, ntɔn akà mbuur mwɛy uboo a bɛ ukwà anki, wɛɛ an'swà mpɛl ikyà bwà. ");
INSERT INTO yns_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","U mpib aŋàbà, un'kyeey mwɛy wà Nzam in'wà mɛ uboo ande anà in'fàsyääl mɛ ayàmɛnà akà mɛ, ");
INSERT INTO yns_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","waa kan'kyään naa: \"Pɔl, twon an'man bɔɔmà! Yubwaŋ naa ngye akàsà un'lɔɔn u mii a Sɛzar, waa Nzam kàmapà sye mɔ̈ɔ̈ a atɔŋ angye abà musabà anà ngye.\" ");
INSERT INTO yns_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Lalan, asam amɛ, làkäl ngwal, ntɔn mɛ in'we anà làkwikilà amu Nzam naa ya iyàkal balàbal asànaa kan'kyään nde. ");
INSERT INTO yns_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Wɛɛ bi ikàtsüüŋ kà un'kɔɔl a isaŋ mwɛy. » ");
INSERT INTO yns_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","U mpib yà kwem aŋinà, un'pöb kisyen u Adriyatik. Uboboo a mpib, baar a isal a an'swà bàmɛn asànaa bi kàkäl tsütsü a nkankyel. ");
INSERT INTO yns_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Apan ba bàsii indübà a an'dà a lwaŋ, ba bàmɛn mɛtre an'kwem an'tär aŋinsambwaar. U kikwɛl, ba bàfàtɔɔm lwaŋ, waa bàmɛn mɛtre an'kwem mɔ̈ɔ̈l aŋinaan. ");
INSERT INTO yns_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ba bàmɛn bɔɔmà naa bi ikyer akàböl udu a in'kul, lalan bàtɔɔm ba an'löŋ an'nà kà an'dà ungö anà bàkäl musyäär naa taaŋ làyaanà. ");
INSERT INTO yns_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Wɛɛ, baar a isal a an'swà bàleŋà mbwo yanswà mutiin an'swà, ba bàtɔ̈ɔ̈l itiir un'sɛŋ kà an'dà anà bàkür naa ba bàkàbäm an'löŋ kusà a an'swà. ");
INSERT INTO yns_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pɔl kàtɛn a kaptɛn anà aŋità naa: « Isàkal naa baar bà bàkal anki uboo a an'swà, bɛ, bɛ làwà anki mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Lalan aŋità bàtsül ba in'siŋ a itiir a un'sɛŋ, waa bàtyeey kya. ");
INSERT INTO yns_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kusà a mwäänà mubalà, Pɔl kàlɔ̈m akà baar banswà mudyà isaa anà mutɛn naa: « Ŋàbà ilä kyàkwem aŋinà làdilà bɛ, ukɔɔn adyà anà mpa làkwen bɛ musà akà undiir mwɛy u mun. ");
INSERT INTO yns_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Lalan mɛ amàlalɔm mudyà ndam a isaa ntɔn bya byà ndöŋ ntɔn bɛ làwü mɔ̈ɔ̈. Akà làtswe a un'tswe a umwɛy uboo a bɛ làyàkyà anki bwà. » ");
INSERT INTO yns_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ungö mutɛn abwɛy, nde kàwɛl làmpà, kàkömà Nzam u mii a baar banswà, kàtsül la, waa kàsɛmà mudyà. ");
INSERT INTO yns_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Apan, ba banswà bàwɛl ngwal, waa bàdi sye. ");
INSERT INTO yns_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Bi banswà uboo a an'swà kàkäl baar nkam yweel a an'kwem nsambwaar aŋisyaam. ");
INSERT INTO yns_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ungö muyuur a isaa, ba bàtyeey buur a an'swà mutɔɔm blɛ kà an'dà. ");
INSERT INTO yns_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Mpal làyaanà taaŋ, baar a isal a an'swà bàmɛn anki nkankyel, wɛɛ ma màkäl ansɛŋ a an'dà anà un'soo, ba bàbön musiinà an'swà kwo, kya mbwo yàlàkal. ");
INSERT INTO yns_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Apan ba bàtsuuŋ an'löŋ, bàwɛy ma uboo a an'dà, ba bàtsuuŋ sye in'siŋ myàfàkwaar an'swà. Ungö ba bàmbaar ipfɛy kusà a an'swà ntɔn un'pöb kasyen kà un'kɔɔl a an'dà, kya mbwo yàlàkal. ");
INSERT INTO yns_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Wɛɛ ba bàkàböl kà ansɛŋ màkäl uboboo a indek myeel, ba bàsiinà an'swà u nkankyel, usà bàteen kà ansɛŋ anà bàsàkwo anki mubar, wɛɛ akà ngö a an'swà, ibɔ a an'dà byàkäl mupay ya a ngwal. ");
INSERT INTO yns_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Apan, aŋità bàwɛl an'kyän mudwa baar a bɔlokà ntɔn uman naa umwɛy uboo a ba utääb anà utiin. ");
INSERT INTO yns_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Wɛɛ kaptɛn kàkwen mutswà Pɔl mɔ̈ɔ̈, waa katsüŋ musyääl an'kyän aba. Nde kàswɛŋ baar bàyöb utääb mukal baar atàtwɛb mutɔɔmà kà an'dà anà musabà u nkankyel. ");
INSERT INTO yns_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Bumwɛy bàlàsabà udu a an'bää anà udu a ikaam a an'swà. Undiiràwun, ba banswà bàtöl nkankyel anà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ungö kàwü bi mɔ̈ɔ̈, bi kàyöb naa isaŋ aki ikɔb a kya Malte. ");
INSERT INTO yns_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Aŋabul biswɛŋ ukwen a ifà asin: ntɔn mbul kàsɛmà munɔ anà mpye yàkäl mbɔɔn, ba bàyöbà böl a mbaa a kölàköl, waa bàwɛl bi banswà ukɔl a la. ");
INSERT INTO yns_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔl kàkàbɔɔl ibiŋ a nkön, waa kàtɔɔm kya u mbaa. Ntɔn un'swey a mbaa, iyäy mwɛy laa kyàyàtoo kya, waa kyundäär u kɔɔ. ");
INSERT INTO yns_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Mpal bàmɛn aŋabul ntäy wàmunyɔŋ u kɔɔ ande, ba bàtɛn ba a ba naa: « Ndandaa mbuur wà, wà un'dwää a baar. Nde kan'too anà mɔ̈ɔ̈ u ngyäl a kölàköl, wɛɛ Balàbal kàmupà anki mbwo mukal anà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pɔl waa kàfwaŋ ntäy awun u mbaa ukɔɔn awem akà kisaay. ");
INSERT INTO yns_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Baar bàdilà naa nde uyäm, itàkal naa nde ukü kà imbürà. Wɛɛ ungö mudil an'taaŋ mbɔɔn, ba bàmɛn naa akà undiir mwɛy wà un'be kun'yeel anki. Apan ba bàsɔɔm an'kyän, waa bàtɛɛnà naa nde wà nzam. ");
INSERT INTO yns_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Tsütsü paa, yàkäl anà ndwaŋ a mfum a isaŋ akin, ikɔb ande Pübiliyüs. Nde kiwɛl anà kipɛ ikal abɔ̈ɔ̈n u ndwà ande ilä itär unsà isam kyanswà. ");
INSERT INTO yns_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Wɛɛ yàmɛnà naa taar a Pübiliyüs kàkäl aŋàbɔ̈ɔ̈n, ntɔn nde kàkäl anà limpye anà pfulà a pfulà a an'kil. Pɔl waa kàkun'ler. U mbwo a ngyamàkà anà nsyeel a an'kɔɔ, nde waa kun'kɔɔr. ");
INSERT INTO yns_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ungö apan, aŋan'kyäl bumwɛy banswà bàkäl uboo a isaŋ aki bàyi sye akà nde, waa bàkɔɔrà. ");
INSERT INTO yns_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ba bipɛ làkoo mbɔɔn. Mpal kàbilà bi kà an'swà, ba bipɛ indiir aŋàkwo ntɔn mbwo abi. ");
INSERT INTO yns_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ungö a ngɔɔn tär, bi kàbilà kà an'swà a Alɛksandri màkyer isà uboo a isaŋ, u mbil a ma bàsi isii a Dyɔskür. ");
INSERT INTO yns_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Bi kàtoo u Siraküse, waa kàkäl paa ilä itär. ");
INSERT INTO yns_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Fà apan, bi kàyilabà un'kɔɔl a an'dà tii kàkàtol bi Rɛgyɔ. Taaŋtyà, un'pöb a mper angyɛl laa kàyi wa, ungö a ilä byeel bi kàtöl Pusɔlɛs. ");
INSERT INTO yns_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Akun, bi kàbwey anà atɔŋ, bà bilɔ̈ɔ̈m mukal ilä nsambwaar apà ba. Le, bi Lɔmà kàkyen abà. ");
INSERT INTO yns_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Mpal bàwem atɔŋ a Lɔmà làsaŋ a ngyeel abi, ba bàyiwool u Yà a Apiyüs anà u Trwa Tavɛrn. Mpal kàmɛn nde ba, Pɔl kàkömà Nzam, waa kàfàwal ngwal. ");
INSERT INTO yns_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Mpal kàtöl bi Lɔmà, ba bàpɛ Pɔl mbwo mukal anà ndwà ande aŋàyen anà ŋità mwɛy mukun'kyɛŋ. ");
INSERT INTO yns_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Yàmɛnà naa ungö a ilä itär, Pɔl kàbel abyääl a Ayudà. Mpal bàköŋ ba banswà, nde kàtɛn a ba naa: « Atɔŋ abaal, mɛ mbuur mpa kàkyer akà undiir mwɛy wà ube akà un'sɛŋ abi, itàkal akà ikin byàfü akà andweer abi, mɛ ban'kör u Yɛlusàlɛm anà ban'pɛ kà an'kɔɔ a Alɔmà. ");
INSERT INTO yns_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Baar abà, ungö akan'fuul un'lɔɔn, bàkyer alan'wɛy ntɔn ba bàmɛn anki akà ube mwɛy ban'kwo mukan'twääl ukwà. ");
INSERT INTO yns_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Wɛɛ Ayudà bàkyer atɔn, lalan kàlɔ̈m mɛ musà un'lɔɔn kusà a Sɛzar, ukɔɔn akal anà an'kyän mufüün un'sɛŋ amɛ. ");
INSERT INTO yns_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Lalà in'lɔ̈m mɛ mubwey anà muyääm anà bɛ. Kutɛn aŋàbwaŋ, yà ntɔn làkyän a Isàlɛl waa mɛ in'wà aŋàlal un'siŋ wà. » ");
INSERT INTO yns_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ba bun'fuur naa: « Bi, bi kàwɛl anki akà un'kaan mwɛy awà kàfü Yuday ntɔn ngye, akà un'tɔŋ mwɛy kàfü anki kwo wa kàyikyään ndaa itàkal mutɛn ube angye akà bi. ");
INSERT INTO yns_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Wɛɛ bi imanà naa yubwaŋ bi iwem u mun angye ŋakwo ndaa akayweerà ngye, ntɔn bi ikyàyöb naa mper yanswà ikööŋ awà ngye ki bàkyer ayitɔn kya. » ");
INSERT INTO yns_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ba bàpɛɛl ilä mwɛy mubwey anà nde, ba bàyi baar mbɔɔn muyun'man u ndwà ande. Unsà an'yääm ande, nde kàkäl mutà imbäl a Imwol a Nzam. Fà tutu tii sisye, nde kàleŋà naa ba bàkyey ndaa kàtɛɛnà nde ntɔn Yɛsu, sɛmà un'kɔɔn a Mɔsɛ anà Aŋangɔɔm. ");
INSERT INTO yns_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Baar amwɛy bàkyey ndaa kàtɛɛnà nde, wɛɛ bumwɛy bàkyer atɔn musà làkwikilà. ");
INSERT INTO yns_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Apan ba bàkaabà unsà isak isak. Abun, Pɔl kàkwɛy ndaa mwɛy mpɛl: « Dweelà In'kyɛɛl kàkäl anà iböŋ kàkyään nde andweer abɛ u mbwo a ŋangɔɔm Yɛsay ");
INSERT INTO yns_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","naa: \"Kyen kamɛn un'sɛŋ wà, un'kyään naa: Bɛ làkyer asàwem ubwaŋàbwaŋ, wɛɛ bɛ làsàyöb anki. Bɛ làsàler ubwaŋàbwaŋ, wɛɛ bɛ làsàman anki. ");
INSERT INTO yns_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ntɔn mpem a un'sɛŋ kàkyàbwà bwoor, ba bàkyàkiin an'tsü aba ikà, ba bàkyàdübà mii aba, ntɔn mutsuŋ mii aba muman, an'tsü aba muwem, mpem aba muyöb anà ba bàkɔɔn abulà mper in'wà mɛ ntɔn mɛ in'kɔ̈ɔ̈n akɔɔr ba.\" ");
INSERT INTO yns_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Abwɛy, làyöb naa ngweel a mɔ̈ɔ̈ a Nzam ayi bàtöm akà baar mpa abà Ayudà: ba, ba bàkyer asàwem! » ");
INSERT INTO yns_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ungö bàwem ba ndaa ayi yanswà, Ayudà waa bàkyen, bàmuyisyeel mbaaŋ a ngwal ba a ba. ");
INSERT INTO yns_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Abun, Pɔl kàkyer yanswà mbul yweel u ndwà kàfafurà nde. Nde kàfawalà baar banswà bàyee mukun'ler. ");
INSERT INTO yns_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Nde kàkyäänà ndaa a Imwol a Nzam anà kàlɔɔŋà indiir iler Mwol Yɛsu Klistɔ, unsà uyɔl banswà anà u duu.");
INSERT INTO yns_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Pɔl, un'syääl a Klistɔ Yɛsu, bun'bel mukal ntööm anà bun'si ukɔl ntɔn mukyään Làsaŋ a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Làsaŋ alà, nde kàtɛn itaan uboo a in'kaan in'kyɛɛl u mbwo a ŋangɔɔm ande. ");
INSERT INTO yns_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Abun, ya yà ntɔn Mwan ande, bun'bör unsà ndür kà itoo a David, ");
INSERT INTO yns_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","bun'si Mwan a Nzam anà ngwal, u mbwo a Dweelà In'kyɛɛl, ntɔn ngwiiyà ande uboo a akü, Yɛsu Klistɔ, Mwol abi. ");
INSERT INTO yns_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","U mbwo a nde, bi kàwɛl kab a ngway mukal ntööm ntɔn musyen, kà ikɔb ande, in'sɛŋ myanswà mpa amyà Ayudà mukun'kyey u mbwo a làkwikilà, ");
INSERT INTO yns_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","in'sɛŋ làbà bɛ sye uboo mwo, bɛ baar làwɛl làbeel a Yɛsu Klistɔ, ");
INSERT INTO yns_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","- akà atɔŋ banswà abà nkween a Nzam, u Lɔmà, abà bàwɛl làbeel a Nzam mukal bà in'kyɛɛl, wɛy bɛ làwɛl kab a ngway anà duu byan'fà akà Nzam awà Taaràbi anà akà Mwol Yɛsu Klistɔ. ");
INSERT INTO yns_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Mɛ in'tàkwen mufuur an'tɔɔn akà Nzam amɛ u mbwo a Yɛsu Klistɔ ntɔn bɛ banswà, ntɔn u mɛɛn manswà bàmutà imbäl a làkwikilà abɛ. ");
INSERT INTO yns_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nzam awà in'fàsyääl mɛ unsà dweelà amɛ, u mbwo a Làsaŋ Aŋàbwaŋ a Mwan ande, nde wà mbäl amɛ naa mɛ in'fàlatà din taaŋ lanswà. ");
INSERT INTO yns_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Taaŋ lanswà, unsà ngyamàkà amɛ, mɛ in'fàlɔm naa unsà ukwen a Nzam, mɛ in'mɛn ipɔ̈l aŋàbwaŋ muyà akà bɛ. ");
INSERT INTO yns_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Unsà ya yanswà, mɛ iwe anà ngyal mukàlaman ntɔn mukàlapà kab a Dweelà ntɔn bɛ làkäl bàŋàtsim. ");
INSERT INTO yns_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Itàkal naa u mbwo abɛ, bi banswà iwɛl ngwal, amwɛy anà bumwɛy, u mbwo a làkwikilà abi banswà, làbɛ asànaa làmɛ. ");
INSERT INTO yns_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Atɔŋ, mɛ in'kwen anki mukalawɛy ukɔɔn ayöb naa mɛ in'fàkal anà an'kyän muyà akà bɛ, ntɔn muwal imbɛŋ imwɛy akà bɛ, asànaa akà in'sɛŋ myumwɛy mpa imyà Ayudà, wɛɛ tii apanà mɛ ipöl ŋàtàman anki. ");
INSERT INTO yns_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Mɛ, mɛ in'we anà nkul a Angɛlɛki asànaa yà baar mpa abà Angɛlɛki, yà aŋan'yeerà asànaa yà insil. ");
INSERT INTO yns_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Kyakin, mɛ in'we anà ngyal mukyään Làsaŋ Aŋàbwaŋ akà bɛ sye baar làbà u Lɔmà. ");
INSERT INTO yns_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ntɔn mɛ in'we anki anà nswɛn a Làsaŋ Aŋàbwaŋ, ntɔn la là ngwal a Nzam ntɔn mɔ̈ɔ̈ a mbuur awe anà làkwikilà, utàtwɛb akà Un'yudà, ungö akà Ungɛlɛki. ");
INSERT INTO yns_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ntɔn balàbal a Nzam làfàmɛnà u mbwo a la, unsà làkwikilà anà ntɔn làkwikilà, asànaa bàsön ya naa: « Mbuur awà balàbal unsà làkwikilà akyer asàwà mɔ̈ɔ̈. » ");
INSERT INTO yns_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Apan sye, nkyɛl a Nzam ifàmɛnà fà du ntɔn mutɔn ukɔɔn inzaam anà nsaŋ a nkɔɔl a baar bàfàkaar ndandaa uboo a ntsüül a nsaŋ a nkɔɔl. ");
INSERT INTO yns_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ntɔn undiir ban'kwo muyöb akà Nzam, wa afàmɛnà ntɔn ba: Nzam kàkyamɛɛy wa. ");
INSERT INTO yns_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Abun, fà kàkyer Nzam mɛɛn, nsyääl ande yàŋàsöön ubwaŋ yàŋàyee, ngwal a mbul a in'tye anà inzaam ande, byàkyer afàmɛnà ubwaŋàbwaŋ unsà un'yɛnà u mbwo a isal ande. Abun, baar un'lɔɔn bawɛɛl anki. ");
INSERT INTO yns_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ntɔn, itàkal naa ba bàyöb Nzam, ba nde làkoo bun'si anki asànaa Nzam, an'tɔɔn sye bun'fuur anki. Wɛɛ an'kyän aba màbulà màbunàbun, mpem aba yà unsil yàbilà uboo a làpib. ");
INSERT INTO yns_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ba bàkyeyà uyɔl naa ba bà aŋayeerà, kyekà ba bàbulà aŋukɔŋ: ");
INSERT INTO yns_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ba bàsɔɔm làkoo a Nzam mpa afàsɔɔmà anà itɛk a mbuur afàsɔɔmà, anà itɛk a nɛn, anà ntsür a in'kɔl in'nà, anà ntsür yàfilaan. ");
INSERT INTO yns_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Kyakin Nzam kawɛy nde naa mpem aba ikyer ukwen aba unsà mbiin, ntɔn ya ilwom làkoo a ndür aba ŋakwo. ");
INSERT INTO yns_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ba bàsɔɔm ndandaa a Nzam asye a loor, ba bàpɛ làkoo anà bàsyäälà undiir bàkyer kà ikal a Nkyer awàŋàsaak, mbul a in'tye. Wöwö! ");
INSERT INTO yns_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Lalan, Nzam kasölà nde akà ilään a nswɛn: Akyay aba bàwɛy mukal anà abaal, ba bàbulà mukal ba a ba. ");
INSERT INTO yns_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Abaal sye u mper yàba, bàpiy nkääl aŋàbwaŋ anà un'kaar, ba bàbilà unsà ilään a amwɛy anà bumwɛy, mukyer ndaa a nswɛn a baal anà baal, anà muwal unsà ndür aba, bweel a balàbal ntɔn ndiimà aba. ");
INSERT INTO yns_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Asànaa mpa bàmɛn ba naa ndöŋ yatɛy muyöb Nzam, Nzam kasölà akà un'yɛnà aba akɔ̈ɔ̈n an'kyän aŋàbwaŋ: kyakin bàkyerà ba indiir mpa ban'kwo ba mukyer. ");
INSERT INTO yns_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ba bàŋàyɔl a un'kɔɔl aŋàyɔŋ wà ifà ifà, wà làmfɛɛl, wà ngyal a ngim, wà nkyɛl, wà un'köl, wà ndwää a baar, wà an'sye, wà impeenà, wà indiir a nswɛn, aŋambämà, ");
INSERT INTO yns_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","aŋatwee, ayiiŋ a Nzam, aŋunkɔ̈ɔ̈n, aŋuyɔl, aswesweey, aŋun'yɛnà abɛ, aŋambɛɛy a aböör aba, ");
INSERT INTO yns_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","bàkɔ̈ɔ̈n un'yɛnà, bàkɔ̈ɔ̈n in'kɔɔn, bàkɔ̈ɔ̈n mpem a ukwen, bàkɔ̈ɔ̈n ngyɛb. ");
INSERT INTO yns_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Itàkal naa ba bàkyàyɔ̈b ubwaŋàbwaŋ ntsüül a nsaŋ a Nzam ayitɛɛnà naa baar bàfàkyer indiir abi bàkyà ukwà, ba kà nà bàfàkyer bya mpɛl anki, ba bàfàkyey sye baar bàfàkyer bya. ");
INSERT INTO yns_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Abun, ngye, ngye un'lɔɔn bàsawɛɛl anki, ngye, itàkal naa ngye awà nà, ngye mbuur afàtsul mbar. Ntɔn, afàtsul ngye mbar a mbuur asin, ngye awàŋàkwɛlà ngye ŋakwo, ntɔn ngye afàkyer abun, ngye mbuur afàtsul mbar. ");
INSERT INTO yns_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Kyekà, bi ikyàyöb naa ntsüül a nsaŋ a Nzam ifàkal unsà ndandaa ifàpà ngö akà baar bàfàkyer indiir abin. ");
INSERT INTO yns_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nkye ngye akasii, ngye mbuur afàtsul nsaŋ a baar ban'kyer anà afàkyer asànaa ba, naa ngye ayàkwɛlà anki u ntsüül a nsaŋ a Nzam? ");
INSERT INTO yns_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Taaŋ lumwɛy ngye awàmudyà un'siinà un'naaŋ a ubwaŋ ande, nkääŋ a mpem anà un'kaay ande. Nkye ngye ayöb anki naa ubwaŋ abà bàmusiinà ngye u mbuul a mpem? ");
INSERT INTO yns_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Unsà mpem bwoor angye, unsà mpem angye mpa ikwen musɔɔmà, ngye awàmubel nkyɛl a kölàköl akà ngye ŋakwo, ntɔn ilä a nkyɛl a Nzam, ilä usàmɛɛy nde ntsüül a nsaŋ ande yà balàbal, ");
INSERT INTO yns_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","nde asàfuur mbuur mbuur asànaa akyà isal ande: ");
INSERT INTO yns_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","mɔ̈ɔ̈ a mbul a in'tye akà baar akwà, u mbwo a muküünà aba mukyer ubwaŋ anà muleŋ làkoo, ibyääl anà mɔ̈ɔ̈ mpa afàtay, ");
INSERT INTO yns_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","wɛɛ nkyɛl anà mfuunà a mpem akà ba akwà, ntɔn mutɔn uwem, bàfàlwomà u mbwo a ndandaa anà bàfàlab mbwo ikɔ̈ɔ̈n balàbal. ");
INSERT INTO yns_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ngyɛb mbɔɔn anà bɔɔmà mbɔɔn byàsàkal ntɔn mbuur afàkyer ube, utàtwɛb akà Un'yudà, ungö akà Ungɛlɛki. ");
INSERT INTO yns_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Wɛɛ làkoo, ibyääl anà duu byàsàkal akà mbuur wanswà afàkyer ubwaŋ, utàtwɛb akà Un'yudà, ungö akà Ungɛlɛki, ");
INSERT INTO yns_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ntɔn akà Nzam un'kɔɔl aŋàyɔŋ watɛy. ");
INSERT INTO yns_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Baar banswà bàkyer man'be ukɔɔn un'kɔɔn, bàsàkwà sye ukɔɔn un'kɔɔn. Baar banswà bàkyer man'be uboo a un'kɔɔn bàsatsüül nsaŋ u mbwo a un'kɔɔn. ");
INSERT INTO yns_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","La itàkal naa baar bàfàwem un'kɔɔn abà bàbalàbal kusà a Nzam, wɛɛ baar bàfàsyääl un'kɔɔn. ");
INSERT INTO yns_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Isàkal naa baar mpa abà Ayudà, mpa bàyöb un'kɔɔn, abà bàfàkyer balàbal ndaa ufaswaŋ un'kɔɔn, un'kɔɔn awà amu ba ŋakwo, ba baar bàkɔ̈ɔ̈n un'kɔɔn. ");
INSERT INTO yns_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ba ban'swaŋ naa isal ukweenà un'kɔɔn kyàŋàsɔn u mpem aba, an'kyän aba màmutà imbäl sye, ntsüül a nsaŋ u mpem aba taaŋ làmwɛy ikyer afapɛl, taaŋ lumwɛy ikyer afawɛɛl. ");
INSERT INTO yns_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ndaa ayin yanwsà isàmɛnà u mii a mii, umpal usàtsul Nzam nkääl a baar yàŋàyee u mbwo a Yɛsu Klistɔ, asànaa awà ya unsà Làsaŋ Aŋàbwaŋ in'fàlɔŋ mɛ. ");
INSERT INTO yns_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Wɛɛ, ngye mbuur bàfabel Un'yudà, afàsà mpem angye unsà un'kɔɔn anà afàswaŋ ngaal ntɔn Nzam angye, ");
INSERT INTO yns_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ngye akyàyöb ukwen ande, un'kɔɔn ande kàkyàlɔŋ naa ufàsɔɔl aben ndaa a mfun, ntɔn wa bàkyalɔŋ, ");
INSERT INTO yns_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ngye mbuur an'sà kam naa ngye afàsyen ikwàmii, ngye awà pɛɛlà a baar abà uboo a làpib, ");
INSERT INTO yns_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","un'lɔɔŋ insil anà wà baar mpa abye anà ngyööb, ntɔn ngye ngyööb anà ndandaa an'wal uboo a un'kɔɔn ... ");
INSERT INTO yns_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Inye, ngye awɛy bää awà un'lɔɔŋ a baar asin, ntɔn nkye mpa alɔɔŋà ngye, ngye ŋakwo? Ngye afàlɔŋ naa bàkɔɔn ayib, ntɔn nkye ngye ŋakwo afàyib ngye? ");
INSERT INTO yns_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ngye afàtsuŋ baar mutà inswem, ntɔn nkye ngye ŋakwo afàtà ngye inswem? Ngye mbuur afàman itɛk ŋingyääy, wɛɛ ngye afàwal indiir a ngwal u ndwà a nzam aba! ");
INSERT INTO yns_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ngye afàswaŋ ngaal angye ntɔn un'kɔɔn, wɛɛ ngye afàbɛy Nzam utaaŋ afàdwa ngye un'kɔɔn! ");
INSERT INTO yns_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Abun, ya yàŋàsɔn naa: « Ntɔn bɛ, ikɔb a Nzam kyàŋàbɛy akà in'sɛŋ asin. » ");
INSERT INTO yns_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ndandaa naa nkyɛɛy yà mfun isàkal naa ngye afàsyääl un'kɔɔn, wɛɛ, isàkal naa ngye afàbɛy un'kɔɔn anà nkyɛɛy, ngye, ngye awà asànaa mbuur mpa awàŋàkyɛy. ");
INSERT INTO yns_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Isàkal naa mbuur mpa awàŋàkyɛy afàlab in'kɔɔn, nkye Nzam ayun'kyey anki asànaa nde wàŋàkyɛy, itàkal naa nde kà wàŋàkyɛy anki? ");
INSERT INTO yns_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Abun, mbuur mpa awàŋàkyɛy u ndür ande usilabà un'kɔɔn, nde asatsüül nsaŋ, ngye mbuur awe anà un'kaan a un'kɔɔn anà nkyɛɛy, wɛɛ ngye afàbɛy un'kɔɔn. ");
INSERT INTO yns_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ntɔn, kà ndaa ifàmɛnà u mii anki ifàkyer Un'yudà, itàkal idiim ifàmɛnà u ndür kyan'kyer nkyɛɛy, ");
INSERT INTO yns_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","wɛɛ ndaa aŋàyee ifàkyer Un'yudà, anà nkyɛɛy yà yà uboo a mpem, nkyɛɛy ifàfà amu Dweelà, kà kà un'kaan anki. Un'yudà a ndandaa awà, làkɔɔ ande afàwal anki akà baar, wɛɛ akà Nzam. ");
INSERT INTO yns_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Abun, bweel nà Ayudà bye alà? Mfun a nkyɛɛy nkye? ");
INSERT INTO yns_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Mfun yà unsà indiir mbɔɔn! Ntɔn Ndaa a Nzam bàtwab atàpa akà ba. - ");
INSERT INTO yns_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ininà? Isàkal naa bàmbɔɔn uboo a ba bàkäl anki bàlää, nkye ukɔɔn lää aba alà làyàlwom lää a Nzam? ");
INSERT INTO yns_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kabwɛy anki! Wɛy Nzam bun'yöb naa nde wà ndandaa, mbuur wanswà wà mbuur a loor, asànaa bàsön ya naa: « Yubwaŋ bayöb naa ngye awà balàbal unsà ndaa angye, naa ngye afàwal iböŋ isàkal naa bàmatsüül nsaŋ. » ");
INSERT INTO yns_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Wɛɛ bi itɛn aben, isàkal naa un'kɔɔl aŋàyɔŋ abi afàsà balàbal a Nzam ukɔl? Nkye Nzam kà we anà un'kɔɔl aŋàyɔŋ anki kidwa nde unsà nkyɛl ande? Mɛ in'wàmutɛn unsà an'kyän a imbuur. ");
INSERT INTO yns_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kabwɛy anki! Ntɔn abun, Nzam mɛɛn nsaŋ asun'tsüül aben? ");
INSERT INTO yns_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Wɛɛ, isàkal naa u mbwo a loor amɛ, ndandaa a Nzam ifàpää mbɔɔn ntɔn làkoo ande, ntɔn nkye, mɛ, tii lalà ban'tsüülà ba nsaŋ asànaa mbuur un'be? ");
INSERT INTO yns_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Abun, ntɔn nkye mpa ban'kwo mutɛn naa: « Wɛy bi ikyer ube ntɔn ubwaŋ bàtoo mwo »? Ntɔn baar amwɛy bàfibämà naa bi bàfàlɔŋ abwɛy. Baar aban ban'kwo muwal ntaaŋàmbar! ");
INSERT INTO yns_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Wɛɛ ininà? Bi Ayudà, bweel nà bi ifàkal alà? Akà ikikye! Ntɔn bi bàkyàtsul mbar naa baar banswà, Ayudà asànaa Angɛlɛki, bà ungyɛl a ikɔ̈b a man'be. ");
INSERT INTO yns_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Asànaa bàsön ya naa: « Mbuur a balàbal watɛy, itàkal akà mwɛy, ");
INSERT INTO yns_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","akà mbuur a an'yeerà watɛy, mbuur aleŋà Nzam watɛy. ");
INSERT INTO yns_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ba banswà bàkyàbwà ndwaŋ, bàkyàyöö. Akà mwɛy afàkyer ubwaŋ watɛy, itàkal akà mwɛy mpɛl. ");
INSERT INTO yns_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Un'kwaal aba wà asànaa an'dii aŋàduub, làlem aba làfàkɔn loor, an'te a ntäy mà ungyɛl a itɔ̈ɔ̈m aba. ");
INSERT INTO yns_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Mun aba wàŋàyɔl a in'küül anà buul. ");
INSERT INTO yns_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","In'kɔl aba myà nswɛy mupay an'kil, ");
INSERT INTO yns_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ntɛɛl a upay anà ngyɛb yà u mbwo a ba, ");
INSERT INTO yns_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","anà mbwo a duu ba bàyöb anki. ");
INSERT INTO yns_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Bɔɔmà a Nzam akà ikikye u mii a ba latɛy. » ");
INSERT INTO yns_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Kyekà, bi bàkyàyöb naa ndaa yanswà kan'tɛn un'kɔɔn, wa kan'tɛn akà baar abà u ngyɛl a un'kɔɔn, ntɔn mun wanswà ukäl wàŋàbäm anà mɛɛn manswà màŋàkwàndwà u mii a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Wɛɛ, akà mbuur mwɛy usàmɛnà anki wàbalàbal kusà a nde u mbwo a isal a un'kɔɔn, ntɔn un'kɔɔn aswaŋà nà man'be mpɛl. ");
INSERT INTO yns_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Wɛɛ apanà, u nsaay a un'kɔɔn, balàbal a Nzam làkyer amɛnà, un'kɔɔn anà aŋangɔɔm bun'tɛɛlà imbäl. ");
INSERT INTO yns_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","La là balàbal a Nzam u mbwo a làkwikilà amu Yɛsu Klistɔ ntɔn baar banswà bàfun'kyey, ntɔn nsöön yatɛy: ");
INSERT INTO yns_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ba banswà bàkyer man'be, anà batsüŋ làkoo a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Wɛɛ ba batwey bàngway balàbal u mbwo a kab a ngway ande ntɔn ntsuuŋà amu Yɛsu Klistɔ. ");
INSERT INTO yns_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Nzam nde kàpɛ asànaa ibɔɔn musɔŋ man'be a baar u mbwo a làkwikilà. Ibɔɔn aki iswaŋà balàbal a Nzam, mpa kàpɛ nde ntaaŋàmbar akà man'be bàkyer itaan, ");
INSERT INTO yns_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","utaaŋ a nkääŋ a mpem ande, ntɔn muswaŋ balàbal ande u taaŋ alà ntɔn nde ukäl wàbalàbal anà mutwey balàbal a mbuur kan'sà làkwikilà amu Klistɔ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nkye apanà we anà undiir afàkyey uyɔl? Akà mwɛy watɛy! Ntɔn nkye? Unsà un'kɔɔn nà? Nkye wà isal? Ŋaa, wɛɛ kà un'kɔɔn a làkwikilà. ");
INSERT INTO yns_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Bi bàkyàyöb naa mbuur afàtoo wàbalàbal u mbwo a làkwikilà, wɛɛ kà u mbwo a isal a un'kɔɔn anki. ");
INSERT INTO yns_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Isàkal abwɛy, nkye Nzam wà Nzam a Ayudà mpɛl? Nkye Nde kà wà Nzam a in'sɛŋ myumwɛy anki? Ya yà ndandaa naa nde sye wà Nzam a in'sɛŋ myumwɛy, ");
INSERT INTO yns_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ntɔn Nzam wà mwɛy: Nde asàtwey balàbal baar aŋàkyɛy u mbwo a làkwikilà, anà baar mpa abàŋàkyɛy u mbwo a làkwikilà. ");
INSERT INTO yns_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Nkye apanà, ikaswaŋà naa u mbwo a làkwikilà bi kan'lwom un'kɔɔn? Ŋaa, bi kan'pà wa ngwal. ");
INSERT INTO yns_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Abun, bi itɛn aben ntɔn nkaa abi Abàlam? Ininà nde kàwɛl unsà imbuur? ");
INSERT INTO yns_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Isàkal naa Abàlam bun'twey balàbal u mbwo a isal ande, nde kàlàkal anà ngyal musɛn an'pɛy, wɛɛ kà kusà a Nzam anki. ");
INSERT INTO yns_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Apan, Ndaa Aŋàsɔn itɛɛnà aben? Abàlam kàsi làkwikilà amu Nzam, kyakin Nzam kun'twey nde wàbalàbal. ");
INSERT INTO yns_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kyekà, mbuur afàkyer isal mwɛy, làfur làŋàtɔɔl a lää, kà sànaa kab a ngway anki, wɛɛ asànaa nkul. ");
INSERT INTO yns_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Isàkal naa mbuur ufàkyer anki isal, wɛɛ nde afàsà làkwikilà akà Mbuur afàtwey baar a man'be balàbal, làkwikilà ande làŋàsà un'tal unsà balàbal. ");
INSERT INTO yns_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Kyakin David utɛɛnà nde ntɔn un'sak a mbuur kan'twey Nzam wàbalàbal mukɔɔn alab isal: ");
INSERT INTO yns_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","un'sak akà baar bàmadwääl nkul a an'kyän an'be aba, anà bàkyàfwe man'be aba! ");
INSERT INTO yns_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Un'sak akà mbuur mpa ufàsyeel Mwol un'tal a man'be ande! ");
INSERT INTO yns_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Nkye un'sak a kölàköl awà wà ntɔn bàŋàkyɛy mpɛl, lɛɛ wà sye ntɔn baar mpa abàŋàkyɛy? Kyakin, waa bi itɛn naa: làkwikilà a Abàlam bun'syel asànaa balàbal. ");
INSERT INTO yns_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","La bun'syeel taaŋ nà? Kusà lɛɛ ungö a nkyɛɛy ande? Ŋaa, kà ungö anki, wɛɛ kusà. ");
INSERT INTO yns_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ungö amukun'pà, ba bun'si isii a nkyɛɛy asànaa inyɛm a balàbal kàwɛl nde u mbwo a làkwikilà, utaaŋ kàkäl nde ŋàtun'kyɛy anki. Kyakin awà nde taa a baar banswà mpa abàŋàkyɛy, ntɔn ba sye bàbulà baar a balàbal, ");
INSERT INTO yns_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","anà taa a bàŋàkyɛy, a baar abà uboo a un'sɛŋ a bàŋàkyɛy mpɛl anki, wɛɛ baar ban'lab sye ntääm a làkwikilà a taaràbi Abàlam, kusà mukun'kyɛy. ");
INSERT INTO yns_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kà ntɔn u mbwo a un'kɔɔn anki, wɛɛ u mbwo a balàbal a làkwikilà naa ilää awal kwal a mɛɛn bàpɛ Abàlam, itàkal itoo ande. ");
INSERT INTO yns_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Isàkal naa kwal alà baar bàfàlab un'kɔɔn bàwal la, làkwikilà mfun làfàkal anki, ilää ifàkal anki. ");
INSERT INTO yns_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Ntɔn un'kɔɔn afàtwaal nkyɛl. Kyekà, kà ikal ikɔ̈ɔ̈n un'kɔɔn, mbɛɛy a un'kɔɔn sye yatɛy. ");
INSERT INTO yns_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Kyakin, ikyee bàfàbulà u mbwo a làkwikilà, ntɔn ya ikäl u mbwo a kab a ngway, ntɔn ilää ikäl ntɔn itoo a Abàlam kyanswà, kà ntɔn baar bàfàlab un'kɔɔn mpɛl anki, wɛɛ sye baar bàfàlab làkwikilà a Abàlam, awà taaràbi banswà, ");
INSERT INTO yns_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","asànaa bàsön ya naa: « Mɛ kabuul taa a in'sɛŋ mbɔɔn. » Nde wà taaràbi kusà a mbuur kàsi nde làkwikilà, Nzam, afàpà akü mɔ̈ɔ̈ anà afàbel indiir mpa byàkäl akà ikikye asànaa bya byàkyàkal. ");
INSERT INTO yns_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ukɔɔn asà an'kyän ande ukwɛl a làkyän lanswà, nde kàsi làkwikilà, waa kàbulà « taar a in'sɛŋ mbɔɔn » asànaa bàtɛn ya a nde naa: « Itoo angye isàkal mbɔɔn. » ");
INSERT INTO yns_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Nde kàkäl tsütsü mukɔlà mbul nkam, wɛɛ làkwikilà ande làkäl ka paa, itàkal naa ndür ande yàkäl yàŋàyɔɔn anà un'kyay ande Saal kàkäl ikɔb. ");
INSERT INTO yns_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ukɔɔn asà mpem bwoor akà ilää, nde kàsi ngwal unsà làkwikilà, waa kasi Nzam làkoo. ");
INSERT INTO yns_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ntɔn nde kàkyer ayöb ubwaŋàbwaŋ naa Nzam usàpà ilää, nde akyer afàkölà kya sye, nde we anà ngwal mukwey kya. ");
INSERT INTO yns_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Kyakin bun'twey ba wàbalàbal. ");
INSERT INTO yns_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Kyekà, bàsön anki ntɔn nde mpɛl naa: « Nde bun'twey wàbalàbal. » ");
INSERT INTO yns_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Wɛɛ ntɔn bi sye, bàsitwey bàbalàbal, bi baar ifàsà làkwikilà amu Nde awà kàwiiy Mwol abi Yɛsu uboo a akü. ");
INSERT INTO yns_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Nde bàkyer un'kab ntɔn ibii abi, waa kàwiyà ntɔn mutwey bi bàbalàbal. ");
INSERT INTO yns_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Abà, bitwey ba bàbalàbal u mbwo a làkwikilà, bi ibà a duu anà Nzam u mbwo a Mwol abi Yɛsu Klistɔ. ");
INSERT INTO yns_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Amu nde, bi kan'wal mbwo u làkwikilà, unsà kab a ngway alà ifàkal bi aŋàtsim uboo a la anà ifàswaŋ bi ngaal unsà làkyän a làkoo a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Yumwɛy, bi ifàswaŋ ngaal itàkal uboo a ngyɛb aŋàdiir, bi ikyàyöb naa ngyɛb aŋàdiir ifàbɔr muküünà, ");
INSERT INTO yns_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","muküünà afàpà ntsim uboo a nsii, ntsim uboo a nsii ifàbɔr làkyän. ");
INSERT INTO yns_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Kyekà, làkyän làfàkur anki, ntɔn ukwen a Nzam bàŋàyɔl u mpem abi u mbwo a Dweelà In'kyɛɛl awà bipɛ. ");
INSERT INTO yns_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ntɔn, utaaŋ bàkɔ̈ɔ̈n bi ngwal, Klistɔ kàkü ntɔn baar a man'be, utaaŋ làkwe la. ");
INSERT INTO yns_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Yà mpay naa mbuur ukü ntɔn mbuur a balàbal, taaŋ lumwɛy, yan'kwo ikäl naa mbuur mwɛy ukäl anà un'kanà mukyey ukwà ntɔn mbuur aŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Wɛɛ Nzam afàswaŋ ukwen ande akà bi: Ntɔn, u taaŋ bàkäl bi baar a man'be, Klistɔ kàkü ntɔn bi. ");
INSERT INTO yns_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ntɔn apanà, bi bàkyitwey balàbal u mbwo a an'kil nde, abun, bi sye isàwà mɔ̈ɔ̈ u nkyɛl. ");
INSERT INTO yns_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kyakin, isàkal naa bi bàkäl ayiiŋ a Nzam, bi bàkyàbulà un'tüüb anà nde u mbwo a nkweel a Mwan ande, awà bi unsà un'tüüb, bi ikyer asàwà mɔ̈ɔ̈ u mbwo a mɔ̈ɔ̈ ande. ");
INSERT INTO yns_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Kà nà abwɛy mpɛl anki, bi bàfàswaŋ ngaal amu Nzam u mbwo a Mwol abi Yɛsu Klistɔ, u mbwo ande apanà, bi bàwɛl lɔ̈ɔ̈n. ");
INSERT INTO yns_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Kyakin, asànaa u mbwo a mbuur mwɛy man'be màbilà u mɛɛn manswà, waa ube bàtwääl ukwà, waa ukwà bàbilà mbuur wanswà ntɔn baar banswà bàkyer man'be. ");
INSERT INTO yns_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ntɔn, fà nsɛmà tii un'kɔɔn, man'be màkäl u mɛɛn. Wɛɛ, ntaaŋàmbar yàkäl anki ntɔn man'be, un'kɔɔn kàkäl anki. ");
INSERT INTO yns_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kyekà, fà Adam tii akà Mɔsɛ, ukwà bàkyer akal, itàkal akà baar mpa bàkyer man'be, akɔ̈ɔ̈n ngweem asànaa mà Adam, ifà a mbuur awà ayàyà. ");
INSERT INTO yns_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Wɛɛ, ye anà nsöön uboo a kab a ngway anà ibii. Ntɔn, isàkal naa u mbwo a man'be a mbuur mwɛy, bàmbɔɔn bàkyen ukwà, lalan sye, u mbwo a kab a ngway a Nzam, kab a ngway lan'fà akà mbuur mwɛy, Yɛsu Klistɔ, lan'söön ntɔn baar mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Yumwɛy, kab a Nzam lan'lyaaŋ man'be a mbuur mwɛy u mfun: abà, u mbwo a man'be a mbuur mwɛy, ntsüül a nsaŋ yan'pà ntaaŋàmbar, kyekà, kab a ngway bàpɛ ungö a ibii mbɔɔn, lan'lwom ntaaŋàmbar. ");
INSERT INTO yns_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ntɔn, isàkal naa u mbwo a ibii a mbuur mwɛy, ukwà bàkyer ayaal, abun sye, u mbwo a Yɛsu Klistɔ mpɛl, baar bàfàwal kab a ngway mbɔɔn anà kab a balàbal, bàsàyaal u mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Abun, ntɔn ibii a mbuur mwɛy, mbuur wanswà kàwɛl ntaaŋàmbar, abun sye, isal a balàbal a mbuur mwɛy, kyà ntɔn baar banswà bàwɛl balàbal làfàpà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Abun sye, unsà ukɔɔn ngweem a mbuur mwɛy, baar mbɔɔn bàbulà baar a man'be, ifà imwɛy sye, unsà unkyeey a mbuur mwɛy, un'kàbɔ bàbulà bàbalàbal. ");
INSERT INTO yns_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Kyeka, un'kɔɔn kan'yà ntɔn ibii ibɛy, wɛɛ, kà ikal man'bilà man'be mbɔɔn, kab a ngway lan'sɔ̈ɔ̈nà. ");
INSERT INTO yns_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Kyakin, asànaa man'be man'yaal ntɔn ukwà, apan u mbwo a balàbal, kab a ngway làyaal ntɔn mɔ̈ɔ̈ a mbul a in'tye u mbwo a Yɛsu Klistɔ, Mwol abi. ");
INSERT INTO yns_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Apanà, ininà bi itɛn? Nkye bi ikal tii kunà uboo a man'be ntɔn kab a ngway làsöönà? ");
INSERT INTO yns_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ŋaa! Bi kàkyàfuràkwà ntɔn man'be, bi iyàfàkal aben uboo a man'be? ");
INSERT INTO yns_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Aben, bɛ lan'diimà naa bi banswà kàwɛl ndüümà amu Klistɔ Yɛsu, nkye unsà nkweel ande ayi, waa bi kàwɛl ndüümà? ");
INSERT INTO yns_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Unsà ndüümà, bi bidyee u mbwo a nkweel ande mbwo mwɛy anà nde, ntɔn yà asànaa Klistɔ kàwiyà nde uboo a akü u mbwo a làkoo a Taa, bi sye iwal mɔ̈ɔ̈ akün. ");
INSERT INTO yns_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ntɔn, isàkal naa bi bàkäl un'tüüb unsà ukwà ande, bi sye isàkal anà wa u ngwiiyà ande. ");
INSERT INTO yns_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Wɛy bi iyöb naa: imbuur itaan kàkäl bi akyà, bàkyàbɛɛrà u kulunsi anà Nde ntɔn mudwa ndür a man'be yi anà bi ikɔ̈ɔ̈n akal asɔ a man'be. ");
INSERT INTO yns_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ntɔn mbuur awà kan'kwà, nde bàmutwey balàbal unsà man'be. ");
INSERT INTO yns_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kyekà, ntɔn bi ban'kwà anà Klistɔ, bi ban'kyey naa bi isàkal sye u mɔ̈ɔ̈ anà Nde. ");
INSERT INTO yns_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ntɔn bi ikyàyöb naa Klistɔ awà kàwiyà uboo a akü, ufàsàkwà anki: ukwà bàfàkal anki anà ikɔ̈b udu a Nde. ");
INSERT INTO yns_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Nde kàkü ntɔn man'be, mbalà mwɛy ipepey. Wɛɛ apanà, nde we anà mɔ̈ɔ̈, mɔ̈ɔ̈ ande wà ntɔn Nzam. ");
INSERT INTO yns_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Abà sye bɛ, bɛ làmɛnà asànaa bɛ làkyàkwà unsà man'be, bɛ làwe anà mɔ̈ɔ̈ ntɔn Nzam amu Klistɔ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Lalan, wɛy man'be màkɔ̈ɔ̈n akal anà ikɔ̈b udu a ndür abɛ yà ukwà ntɔn mufàkyey ilään a ya. ");
INSERT INTO yns_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Twon lan'pà itiir a ndür abɛ akà man'be asànaa an'tà a indiir ikɔ̈ɔ̈n balàbal. Wɛɛ, làpɛ mɔ̈ɔ̈ abɛ akà Nzam asànaa baar bàwiyà uboo a akü, waa abye anà mɔ̈ɔ̈. Lun'pɛ itiir a ndür abɛ asànaa an'tà a indiir a balàbal. Labilà unsà isal a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ntɔn man'be màfàsàkal anki anà ikɔ̈b udu abɛ, ntɔn bɛ làfàkal anki ungyɛl a un'kɔɔn, wɛɛ ungyɛl a kab a ngway. ");
INSERT INTO yns_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ininà abun? Nkye bi ikyer man'be naa ntɔn bi bàfàkal anki ungyɛl a un'kɔɔn, wɛɛ ungyɛl a kab a ngway? Kà abwɛy anki! ");
INSERT INTO yns_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Nkye bɛ làyöb anki naa kya bɛ làsàkal uboo a isal a mbuur asànaa asɔ ntɔn mukun'kyey, bɛ làbà asɔ a mbuur wa làkakyeyà bɛ wà? Itàkal isɔ a man'be ifàsyen kà ukwà, itàkal isɔ a nkyeey ifàsyen u balàbal? ");
INSERT INTO yns_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Wɛɛ bi bàfuur an'tɔɔn akà Nzam: kusà bɛ làkäl asɔ a man'be, wɛɛ apanà, bɛ làkyàkyey u mpem abɛ wanswà an'lɔɔŋ a kiin amà bàlapɛ. ");
INSERT INTO yns_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Abun, bɛ làkyàlwomà ungyɛl a man'be, waa lan'bulà asɔ a balàbal. ");
INSERT INTO yns_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Mɛ in'tɛɛnà unsà imbuur, ntɔn bɛ sye làbà baar. Ntɔn, asànaa làpɛ bɛ itiir a ndür asànaa asɔ unsà isal a mbiin anà kyàlingyoomà abyà ifàsyɛn mutɔn Nzam, abun sye, làpɛ bya apanà ntɔn bya ibulà ungyɛl a isɔ a balàbal alà làfàsyen kà un'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Umpal làkäl bɛ asɔ a man'be, bɛ làkäl nsaay kusà a balàbal. ");
INSERT INTO yns_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Bɛ bweel nà làwɛl? Ŋàbawà bɛ làbà u nswɛn, ntɔn ntsüü a ma ukwà. ");
INSERT INTO yns_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Wɛɛ apan bɛ làkyàlwomà ungyɛl a isɔ a man'be anà làkyàbulà asɔ a Nzam, bɛ lan'wal bweel làfasyɛn kà un'kyɛɛl, waa ntsüü a ya, yà mɔ̈ɔ̈ a mbul a in'tye. ");
INSERT INTO yns_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ntɔn làfur a man'be là ukwà, wɛɛ kab a ngway a Nzam là mɔ̈ɔ̈ a mbul a in'tye amu Mwol abi Klistɔ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Atɔŋ, ikamɛnà naa bɛ lan'diimà - mɛ in'tɛɛnà a baar bàyöb un'kɔɔn - naa nkye bɛ làyöb anki naa un'kɔɔn afàkal anà ikɔ̈b udu a mbuur nà utaaŋ awà nde anà mɔ̈ɔ̈? ");
INSERT INTO yns_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Abun, un'kaar aŋàbääl wà un'tüüb, unsà un'kɔɔn, anà mbääl ande utaaŋ awà nde anà mɔ̈ɔ̈. Wɛɛ nde usàkwà, nde ufàfàkal anki ungyɛl a un'kɔɔn a bɔr. ");
INSERT INTO yns_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Abà, isàkal naa nde kan'wal un'dim asin utaaŋ awà mbuur awà anà mɔ̈ɔ̈, nde kan'tà inswem. Wɛɛ, isàkal naa un'dim kan'kwà, nde kan'bulà nsaay kusà a un'kɔɔn, apan nde uyàkal anki ŋinswem mubulà un'kyay a mbuur asin. ");
INSERT INTO yns_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Abun sye ntɔn bɛ, atɔŋ amɛ, bɛ bàkyàlasà kà ukwà kusà a un'kɔɔn, u mbwo a ndür a Klistɔ, ntɔn mubulà baar a mbuur asin, Mbuur awà kàwiyà uboo a akü, ntɔn bi itwey mbɛŋ ntɔn Nzam. ");
INSERT INTO yns_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Kyakin, utaaŋ kàkäl bi unsà in'twaŋ, ilään a man'be màfü unsà un'kɔɔn, màsyäälà itiir a ndür abi, ntɔn bi itwey mbɛŋ ntɔn ukwà. ");
INSERT INTO yns_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Wɛɛ apanà, kàkü bi unsà ikɔ̈b kyàkäärà bi kà isɔ, bi kàkyàtoo nsaay kusà a un'kɔɔn. Ntɔn bi isäl ungyɛl a ikɔ̈b akün kyà Dweelà, wɛɛ kà ungyɛl a ikɔ̈b itaan kyà un'kɔɔn aŋàsɔn anki. ");
INSERT INTO yns_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Abun, ininà bi itɛn? Nkye un'kɔɔn wà man'be? Kà abwɛy anki! Wɛɛ, yàlàkal naa un'kɔɔn watɛy, mɛ man'be kàlàyöb anki. Abun, mɛ kàlàyöb anki ngyööm a mpem, yàlàkal naa un'kɔɔn kàtɛɛn anki naa: \"Twon an'yɔm mpem.\" ");
INSERT INTO yns_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Mulab ndaa ayi, man'be màbör amu mɛ ngyööm a mpem yà ifà ifà u mbwo a nswɛɛŋ. Ntɔn, yàlàkal naa un'kɔɔn ukɔ̈ɔ̈n, man'be màlàkal undiir aŋàkwà. ");
INSERT INTO yns_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Itaan, mpal kàkɔ̈ɔ̈n un'kɔɔn, mɛ kàkäl anà mɔ̈ɔ̈. Wɛɛ mpal yàyi nswɛɛŋ, man'be màfàwal mɔ̈ɔ̈, ");
INSERT INTO yns_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","mɛ waa kàkü: nswɛɛŋ yàlàsyeen u mɔ̈ɔ̈, yan'syeen kà ukwà. ");
INSERT INTO yns_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ntɔn man'be, u mbwo nsil ayin, laa man'kür ma, u mbwo a nswɛɛŋ, anà u mbwo a wa, waa kan'pɛ ukwà. ");
INSERT INTO yns_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Abun, un'kɔɔn wà in'kyɛɛl, nswɛɛŋ yà in'kyɛɛl, balàbal anà ubwaŋ. ");
INSERT INTO yns_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Apan, nkye undiir aŋàbwaŋ kàkyàtwaal ukwà ntɔn mɛ? Kà ndandaa anki! Wɛɛ mà man'be: ma màsyääl undiir aŋàbwaŋ mukan'pà ukwà, ntɔn wa kàmɛnà asànaa man'be anà muswaŋ nkyɛl a man'be, u mbwo a nswɛɛŋ. ");
INSERT INTO yns_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ndandaa, bi bàkyàyöb naa un'kɔɔn wà wàdweelà. Wɛɛ mɛ, mɛ in'wà mbuur a un'sön a ndür, bàkyän'yälà u man'be asànaa un'sɔ. ");
INSERT INTO yns_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ntɔn, mɛ in'fàyöb anki ayà in'fàkyer mɛ: mɛ in'fàkyer anki ayà in'fàkwen mɛ, wɛɛ mɛ in'fàkyer ndaa in'fàtɔn mɛ. ");
INSERT INTO yns_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Abun, isàkal naa ayà mpa in'fàkwen mɛ, mɛ in'fàkyer ya, mɛ an'kyey naa un'kɔɔn wà ubwaŋ. ");
INSERT INTO yns_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Kà mɛ anki in'kyer abun, wɛɛ man'be amà amu mɛ. ");
INSERT INTO yns_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ntɔn mɛ in'kyàyöb naa amu mɛ, - mɛ in'kwen mutɛn uboo a ndür amɛ - ubwaŋ batɛy: ukwen akyer ubwaŋ bàmwo, wɛɛ mɛ in'kakwo anki mukyer ba. ");
INSERT INTO yns_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Kyakin ubwaŋ in'kwen mɛ mukyer, mɛ in'kyerà anki, wɛɛ ube mpa in'kwen mɛ, mɛ in'wàmukyer ba. ");
INSERT INTO yns_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Kyekà, isàkal naa mɛ an'kyer ayà mpa in'kwen mɛ, kà mɛ anki an'kyer, wɛɛ man'be amà amu mɛ. ");
INSERT INTO yns_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Apan, mɛ an'man un'kɔɔn wà: mpal in'kwen mɛ mukyer ubwaŋ, ube bàmanääm. ");
INSERT INTO yns_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","U mpem amɛ, mɛ in'fàman un'sak ntɔn un'kɔɔn a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Wɛɛ, uboo a itiir a ndür amɛ, mɛ an'fàman un'kɔɔn asin wàmunwan a un'kɔɔn a un'yɛnà amɛ, wa kàman'buul un'sɔ a un'kɔɔn a man'be amà uboo a itiir a ndür amɛ. ");
INSERT INTO yns_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ngyɛb akà mɛ! Nà asan'tsuuŋ u ndür a ukwà yi? ");
INSERT INTO yns_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","An'tɔɔn akà Nzam u mbwo a Yɛsu Klistɔ, Mwol abi! Mutsülà, mɛ ŋakwo in'wà un'sɔ a un'kɔɔn a Nzam unsà un'yɛnà, un'sɔ a un'kɔɔn a man'be unsà ndür. ");
INSERT INTO yns_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Lalan, apanà, ikwàndwà ifàkal anki ntɔn baar abà amu Klistɔ Yɛsu. ");
INSERT INTO yns_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ntɔn un'kɔɔn a Dweelà awafàpà mɔ̈ɔ̈ amu Klistɔ Yɛsu, kàman'tsuuŋ unsà un'kɔɔn a man'be anà ukwà. ");
INSERT INTO yns_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Ntɔn undiir kàkäl mpay mukyer unsà un'kɔɔn, ntɔn un'sön kun'kwaamà ngwal, Nzam kàkyer akyer wa: ntɔn man'be, Nde kàtöm Mwan ande ŋakwo u ndür ayà asànaa ndür a man'be, nde kàpɛ ikwàndwà akà man'be unsà un'sön. ");
INSERT INTO yns_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Kàkyer nde abà ntɔn balàbal alà kàlɔ̈ɔ̈mà un'kɔɔn làkwey amu bi, bi baar mpa ifàyikyà ungyɛl a ikɔ̈b a un'sön, wɛɛ unsà Dweelà. ");
INSERT INTO yns_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Abun sye, ungyɛl a ikɔ̈b a un'sön, an'kyän aba màfàsyääl imbuur, wɛɛ baar abà ungyɛl a Dweelà, an'kyän aba màfàsyääl yin'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Ntɔn un'sön afàsyen kà ukwà, wɛɛ Dweelà afàsyen u mɔ̈ɔ̈ anà u duu. ");
INSERT INTO yns_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ntɔn an'kyän a un'sön màfàmbäär Nzam, ma màfàkal anki ungyɛl a un'kɔɔn a Nzam, ma màkwo anki akà ikikye. ");
INSERT INTO yns_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Kyekà, baar bàfàkal ungyɛl a ikɔ̈b a un'sön, ba bàkwe anki mupà Nzam un'sak. ");
INSERT INTO yns_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Wɛɛ akà bɛ, bɛ làbà anki unsà un'sön, wɛɛ unsà Dweelà, isàkal naa ndandaa Dweelà a Nzam wà anà bɛ. Isàkal naa mbuur watɛy anà Dweelà a Klistɔ, nde kà wà mbuur ande anki. ");
INSERT INTO yns_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Abun, isàkal naa Klistɔ wà amu bɛ, ndür abɛ, ndandaa, yà ndür aŋàkwà ntɔn man'be, wɛɛ Dweelà wà mɔ̈ɔ̈ abɛ ntɔn balàbal. ");
INSERT INTO yns_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Isàkal naa Dweelà a Nzam awà kàwiiy Yɛsu uboo a akü wà uboo a bɛ, mbuur awà kàwiiy Yɛsu Klistɔ uboo a akü asàpà sye mɔ̈ɔ̈ u ndür abɛ yà ukwà yi, u mbwo a Dweelà ande alà uboo a bɛ. ");
INSERT INTO yns_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Abun, atɔŋ amɛ, bi ibye anà nkul, wɛɛ kà yà un'sön anki ntɔn mukal anà mɔ̈ɔ̈ a imbuur. ");
INSERT INTO yns_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ntɔn, isàkal naa bɛ làbà anà mɔ̈ɔ̈ unsà imbuur, bɛ làkyer asàkwà, wɛɛ isàkal naa unsà Dweelà, bɛ lan'dwa nkääl abɛ yà imbuur, apan bɛ làsàkal anà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kyakin, baar abà bàfasyeen unsà Dweelà a Nzam, ba bà baan a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ntɔn bɛ làwɛl anki dweelà làmwɛy lan'kwo mubuul bɛ asɔ anà mukàlapà bɔɔmà, wɛɛ Dweelà mwɛy afàlabuul bàŋàywaaŋ nkà, waa anà bi ikuub in'kwɛŋ: « Wɔɔ Taa! » ");
INSERT INTO yns_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Dweelà nde ŋakwo afàtà imbäl akà dweelà abi naa bi ibà baan a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Abun, ntɔn bi ibà baan, bi sye ibà akyee a kwal: akyee a Nzam anà akyee a kwal mbwo mwɛy anà Klistɔ, ntɔn bi ban'wal yar unsà mpay ande, bi sye isàwal yar unsà làkoo ande. ");
INSERT INTO yns_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mɛ in'yweerà naa mpay a taaŋ alà ikwo anki anà làkoo alà làyàmɛnà amu bi. ");
INSERT INTO yns_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ntɔn, nkyeer yanswà yàmudilà anà nkääŋ a mpem mɛɛy a baan a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ntɔn, nkyeer yanswà yàŋàbilà ungyɛl a ikɔ̈b a bunàbun, kà unsà ukwen aya anki, wɛɛ unsà ukwen a mbuur kàsi ya, wɛɛ làkyän làmwo: ");
INSERT INTO yns_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ntɔn ya sye iyàfàkal anki kà isɔ a küüb ntɔn muwal yar a nsaay anà làkoo a baan a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Abun, bi ikyàyöb naa nkyeer yanswà tii lalà yà unsà mpay asànaa usaay a bɔr. ");
INSERT INTO yns_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Kà ntɔn ya mpɛl anki: bi sye, bi baar ibye anà mbɛŋ atàtwɛb yà Dweelà, bi ibàmulaal u mpem abi, mudilà ngywaaŋ a nkà, ntsüüŋ a ndür abi. ");
INSERT INTO yns_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ntɔn bi kàkyàwà mɔ̈ɔ̈, wɛɛ ngweel a mɔ̈ɔ̈ ya yà unsà làkyän mpɛl. Abun, làkyän imanà bi là la kà làkyän anki. Kyekà, uman undiir bàsyeelà làkyän ifàkal nsyeel a làkyän anki: làkyän bàfàsà aben unsà undiir akamɛnà? ");
INSERT INTO yns_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Wɛɛ usà làkyän unsà undiir mpa ikamanà bi, yà mudil wa unsà muküünà. ");
INSERT INTO yns_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ifà imwɛy sye, Dweelà làfàyà mukibay unsà gyɔ̈ɔ̈là abi, ntɔn bi iyöb anki muyamà ubwaŋàbwaŋ, wɛɛ Dweelà ŋakwo afàyamà ntɔn bi mulaal unsà ngɔk mpa ukwo mbuur mutwey. ");
INSERT INTO yns_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Waa mbuur awà afàleŋ muyöb mpem akyàyöb an'kyän a Dweelà, ntɔn Dweelà afàyamà ntɔn baar in'kyɛɛl asànaa ukwen Nzam. ");
INSERT INTO yns_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Bi ikyàyöb sye naa indiir byanswà byàfàlyaaŋ ntɔn ubwaŋ a baar bàkwen Nzam, anà baar kàbel nde ntɔn nswaal ande. ");
INSERT INTO yns_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Ntɔn, baar abà kàyöb nde kusà, nde ba sye katsüül mukal bàbalàbal kà isii a Mwan ande, ntɔn naa nde awà ukäl nswɛm uboo a atɔŋ mbɔɔn. ");
INSERT INTO yns_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Baar abà kàlɔ̈ɔ̈n nde fà itaan, nde kàkyer abel sye, baar kàbel nde, nde ba kabuul bàbalàbal sye, anà ba akwà kàbuul nde bàbalàbal, nde kàkyer asyäŋà sye. ");
INSERT INTO yns_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Abun, ininà bi ifàtɛn ntɔn indiir abi? Isàkal naa Nzam wà anà bi, nà asimbäär? ");
INSERT INTO yns_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Abun, nde mbuur mpa kàtii Mwan ande ŋakwo, wɛɛ nde kun'käb ntɔn bi banswà, ntɔn nkye mpa kipà nde, mbwo mwɛy anà Mwan ande, indiir byanswà? ");
INSERT INTO yns_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Nà kan'kwo mufüün baar abà kàsɔ̈ɔ̈l Nzam? Nzam afàtwey baar balàbal! ");
INSERT INTO yns_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Nà asatsüül mbar? Klistɔ Yɛsu kàkyàkwà, waa kàfàwiyà, nde wà u kɔɔ a ibaal a Nzam, wàmubɔɔn ntɔn bi! ");
INSERT INTO yns_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Nà asàkaab bi anà ukwen a Klistɔ? Lingyoomà, ngyɛb, nkwaaŋ, ngyal, làmbwà, kɔm itàkal igɔnsà? ");
INSERT INTO yns_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Asànaa bàsön naa: « Ntɔn ngye, bi bàkidwa ilä aŋukiinà, ba bàfiwal asànaa ntsür bàfàsyen kà idwääl. » ");
INSERT INTO yns_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Wɛɛ unsà ayi yanswà, bi ibà aŋàböŋ aŋàsöönà u mbwo a mbuur awà kikwen. ");
INSERT INTO yns_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Ɛɛ, ndandaa mɛ an'sà kam naa itàkal ukwà, itàkal mɔ̈ɔ̈, itàkal akyeey, itàkal amfum, itàkal papanà, itàkal taaŋ làsàyà, itàkal ngwal, ");
INSERT INTO yns_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","itàkal ngwal a du, itàkal ngwal a ngyɛl a mɛɛn, itàkal nkyeer asin, undiir mwɛy tɛy akaab bi anà ukwen a Nzam bàyàmɛnà amu Klistɔ Yɛsu awà Mwol abi. ");
INSERT INTO yns_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Amu Klistɔ mɛ in'tɛn ndandaa, mɛ in'kur anki, u mbwo a Dweelà In'kyɛɛl, an'kyän amɛ man'tɛɛlà imbäl: ");
INSERT INTO yns_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","u mpem amɛ, mɛ in'we anà ngyɛb mbɔɔn anà usaay mpa bàfàtsü. ");
INSERT INTO yns_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ɛɛ, mɛ in'yàkwen naa ban'si in'küül, mɛ ŋakwo in'kaabà anà Klistɔ ntɔn atɔŋ amɛ, itoo amɛ u ndür. ");
INSERT INTO yns_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Ba bà baar a Isàlɛl, abà unsà ngywaaŋ a nkà, làkoo, nkwà, nkɔ̈ɔ̈n, ngyamàkà, ilää ");
INSERT INTO yns_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","anà bàtaa, amu ba, unsà ndür, kàtoo Klistɔ awà udu a ya yanswà, Nzam aŋàsaak ipepey. Yà abwɛy! ");
INSERT INTO yns_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ya ikaswaŋà anki naa Ndaa a Nzam iböŋ anki. Ntɔn, baar banswà abà akyee a Isàlɛl kà Bà Isàlɛl anki, ");
INSERT INTO yns_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","anà, kà akyee a Abàlam banswà anki abà baan ande, ntɔn Nzam kàtɛn a Abàlam naa: « Ngye akyee asàwal u mbwo a Isak. » ");
INSERT INTO yns_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ikaswaŋà naa: kà baan a ndür anki unsà imbuur abà baan a Nzam. Baan a Nzam bà baan abà kàbɔ̈r nde uboo ilää kun'pɛ nde. ");
INSERT INTO yns_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ntɔn, ndaa ayi yàkäl ilää: « Mɛ in'kyer asàyàfurà u paŋà atub alà, Saal asàkal anà mwan baal. » ");
INSERT INTO yns_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Kà yàtsü apan anki, Lɛbɛk sye kàbör baan a mbuur mwɛy mpɛl, Isak, taaràbi. ");
INSERT INTO yns_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Apan, baan bàkäl anki bàŋàtàbɔr anà bàŋàtàkyer anki itàkal ubwaŋ, itàkal ube, ntɔn nswaal a Nzam ikwe, ndaa yàkäl kusà a nsɔ̈ɔ̈l kàkyer nde ");
INSERT INTO yns_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","mukɔɔn alab isal a baar, wɛɛ ukwen a mbuur kabel, waa kàtɛn a Lɛbɛk naa: \"Bwel asàsyääl un'kɔm\", ");
INSERT INTO yns_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","asànaa bàsön naa: \"Mɛ kàkwen Yakɔb, anà kàyiiŋ Isawu.\" ");
INSERT INTO yns_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Ininà bi itɛn? Nkye balàbal latɛy amu Nzam? Kà ndandaa anki! » ");
INSERT INTO yns_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ntɔn nde kàtɛn a Mɔsɛ naa: \"Mɛ in'sàsyääm mbuur an'kwen mɛ musyääm anà in'sàpà kab a ngway akà mbuur an'kwen mɛ mupà kab a ngway. ");
INSERT INTO yns_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Abun, ndaa ayi ifàkal anki ntɔn ukwen itàkal ngwal a mbuur, wɛɛ u nsyääm a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Kyakin Ndaa Aŋàsɔn yàtɛn ya a Falawɔ naa: « Le, mɛ kasi mɛ mfum ntɔn muswaŋ amu ngye ngwal amɛ, ntɔn naa ikɔb amɛ bàkyään kya u mɛɛn manswà. » ");
INSERT INTO yns_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Abun, nde afàsyääm mbuur ukwen nde, afàsà mpem bwoor akà mbuur ukwen nde. ");
INSERT INTO yns_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Wɛɛ abun, ngye ayàtɛn a mɛ naa: « Ntɔn nkye ufiŋään nde, ntɔn, akà mbuur mwɛy ukwe anki mumbäär ukwen ande? » ");
INSERT INTO yns_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Wɛɛ ngye awà nà, mbuur, ntɔn musà Nzam mbaaŋ? Nkye làbuuŋ lan'kwo làtɛn a un'boom ande naa: « Ntɔn nkye kan'kyer ngye abà? » ");
INSERT INTO yns_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Un'boom, kà wà mfum a tɔm ande anki mukyer a twar nsil alan, làbuuŋ a ibyääl, itàkal làbuuŋ a isal a bunàbun? ");
INSERT INTO yns_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Ngye ininà atɛn, isàkal naa Nzam akwen mutwey nkyɛl ande anà muswaŋ ngwal ande, nde kàkyer asɛn buur anà nkääŋ a mpem mbɔɔn an'buuŋ a nkyɛl balɔ̈ɔ̈n ntɔn ukwà, ");
INSERT INTO yns_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ayi yà ntɔn nde mumɛɛy un'naaŋ a làkoo ande akà an'buuŋ a un'naaŋ ande kusà a an'buuŋ a nsyääm kàlɔ̈ɔ̈n nde kusà ntɔn làkoo. ");
INSERT INTO yns_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Bi ibà baar kàbel nde, kà nà uboo Ayudà mpɛl anki, wɛɛ sye uboo a baar mpa abà Ayudà. ");
INSERT INTO yns_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Asànaa, un'kaan a Ɔzɛ utɛɛnà wa naa: Awà mpa kàkäl un'sɛŋ amɛ, mɛ in'sun'beelà un'sɛŋ amɛ, awà mpa kàkäl nkween amɛ, mɛ in'sun'beelà nkwen amɛ. ");
INSERT INTO yns_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ikal akyä bàtɛɛnà a ba naa: « Bɛ kà làbà un'sɛŋ amɛ anki », ba bàsabeelà baan a Nzam a mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Yɛsay, u mper yànde, kàsi un'kwɛŋ ntɔn Isàlɛl: « Itàkal naa baan a Isàlɛl bàkäl asànaa ansɛŋ a ngyäl a kölàköl, baar ikikye bàsàwà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ntɔn Mwol asàkwey Ndaa ande yanswà làgyägyä u mɛɛn. » ");
INSERT INTO yns_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Yɛsay awà kàtàtà ngɔɔm kusà naa: « Isàkal naa Mwol a aŋità kàsiwɛy anki ikyee, abà bi kàkyàbulà asànaa Sɔdɔm, bi kàlàkal balàbal asànaa Gɔmɔr. » ");
INSERT INTO yns_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Apanà, ininà bi ifàtɛn? Ayi: baar mpa abà Ayudà, mpa bàleŋà mubulà bàbalàbal, bàkyàwal balàbal lan'fà u làkwikilà, ");
INSERT INTO yns_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","kyekà Isàlɛl awà kàleŋà un'kɔɔn ntɔn mubulà balàbal, kàsàman anki la. ");
INSERT INTO yns_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ntɔn nkye? Ntɔn balàbal alà ba la bàyadilà anki unsà làkwikilà, wɛɛ ba bàsii naa ba la bàsawal unsà isal. Ba bàyàböl akà « un'kul awà afàbwiy », ");
INSERT INTO yns_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","abun, bàsön naa: « Le, mɛ kan'tɔɔl u Siyɔnà un'kul afàbwiy, nkɔŋ ifàbwiy. Wɛɛ mbuur afàsà làkwikilà amu Nde usàman anki nswɛn. » ");
INSERT INTO yns_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Atɔŋ, un'lään awà u mpem amɛ anà ngyamàkà amɛ akà Nzam ntɔn ba, yà naa ba bàwü mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ntɔn, mɛ in'wà mbäl, ba bye anà uyɔl akà Nzam, wɛɛ kà uyɔl abàkapaa pɛɛlà anki u ngyööb. ");
INSERT INTO yns_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Mudiimà balàbal làfàfà akà Nzam anà muleŋ musà là ba ŋakwo, ba bàfàkal anki ungyɛl a balàbal a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ntɔn ntsüü a un'kɔɔn yà Klistɔ, ntɔn bàpɛ balàbal akà mbuur wanswà awe anà làkwikilà. ");
INSERT INTO yns_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Nde ŋakwo Mɔsɛ kàsön ntɔn balàbal lan'fà akà un'kɔɔn naa: « Mbuur asàkwey nswɛɛŋ ayi, asàkal anà mɔ̈ɔ̈ u mbwo a ya. » ");
INSERT INTO yns_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Wɛɛ, balàbal làfàfà unsà làkwikilà làtɛn abà: « Twon an'tɛn u mpem angye naa: \"Nà asàbeenà du?\" » Apɛy yà mutyeey Klistɔ. ");
INSERT INTO yns_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Itàkal naa: « Nà asàtyà kà un'baan? Nkye apɛy yà mumbaar Klistɔ uboo a akü? » ");
INSERT INTO yns_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Wɛɛ wa atɛɛnà aben? « Tsütsü apà ngye, yà ndaa, u mun anà u mpem angye. » Ndaa ayi, yà ndaa a làkwikilà alà ipay bi làsaŋ. ");
INSERT INTO yns_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Isàkal naa u mun angye, ngye afàtà imbäl naa Yɛsu wà Mwol, isàkal naa u mpem angye, ngye awe anà làkwikilà naa Nzam kun'wiiy kà ukwà, ngye asàwà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kyakin, làkwikilà làfàbuul baar balàbal làfàfà u mpem, anà imbäl aki ifàwiiy baar mɔ̈ɔ̈ ifàtoo u mun. ");
INSERT INTO yns_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Ntɔn, Ndaa Aŋàsɔn itɛɛnà naa: « Mbuur usàsà làkwikilà amu Nde, bàsun'mɛɛy anki nswɛn. » ");
INSERT INTO yns_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Abun, nsöön yatɛy uboo Ayudà anà Angɛlɛki: ba banswà bà Mwol mwɛy, awà afàpà indiir ande akà baar banswà bàfun'bel. ");
INSERT INTO yns_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Abun, mbuur asàbel ikɔb a Mwol akyer asàwà mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Wɛɛ, ba bàyun'bel aben isàkal naa làkwikilà amu nde latɛy? Ba làkwikilà bàyàsà aben amu nde, isàkal naa ba bàŋàtun'wem anki? Ba bàyun'wem aben isàkal naa mbuur ŋàtalɔŋ anki? ");
INSERT INTO yns_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Wɛɛ ba bàyàlɔŋ aben, isàkal naa ba batöm anki? Yumwɛy bàsön ayi: « Myà ubwaŋ in'kɔl a baar abà bàfàpay Làsaŋ Aŋàbwaŋ! » ");
INSERT INTO yns_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Wɛɛ ba banswà bàkyey anki Làsaŋ Aŋàbwaŋ alà. ");
INSERT INTO yns_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Abun, làkwikilà làfàyà unsà ndaa bàfàwem, ngweem ifàfà u mbwo a Ndaa a Klistɔ. ");
INSERT INTO yns_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Apan, mɛ in'fuul naa: Nkye ba bàwem anki? Ɛɛ, bàkyàwem! Ntɔn, bàsön naa: « Làböl aba làpää u mɛɛn manswà, ndaa aba yàtöl tii u ntsüü a mɛɛn. » ");
INSERT INTO yns_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Abun, mɛ in'fuul naa: Aben, baar a Isàlɛl bàyöb anki? Utàtwɛb Mɔsɛ kàtɛn naa: « Mɛ in'yàsɛɛn un'kɔ̈l abɛ akà undiir mpa awà un'sɛŋ, mɛ in'yàmbaar nkyɛl abɛ akà un'sɛŋ akɔ̈ɔ̈n un'yɛnà. » ");
INSERT INTO yns_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Yɛsay kan'kyà kwɛl mutɛn naa: « Mɛ bàmàkan'man akà baar mpa bàyan'leŋà, mɛ kàkàmɛɛy akà baar mpa ban'lɔ̈ɔ̈mà akà undiir mwɛy. » ");
INSERT INTO yns_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Wɛɛ ntɔn Isàlɛl, Nde kàtɛn naa: « Ilä aŋukiinà mɛ an'lɛɛ an'kɔɔ akà un'sɛŋ aŋunkwem anà wàŋun'tswe ngwal. » ");
INSERT INTO yns_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Abun, mɛ in'fuul naa: Nkye Nzam kàpiy un'sɛŋ ande? Akà ikikye! Ntɔn mɛ ŋàkwo iwà un'nsi Isàlɛl, itoo a Abàlam, uboo a ywar a Bɛnsàmɛn. ");
INSERT INTO yns_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Nzam kàpiy anki baar ande kàsɔ̈ɔ̈l nde itaan. Imɛnà naa bɛ làkayöbà anki naa Ndaa Aŋàsɔn nkye itɛɛnà, u mbwo aya kàsi Elya tär ntɔn Isàlɛl a Nzam: ");
INSERT INTO yns_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","« Mwol, ba bàkyer adwa aŋangɔɔm angye, bàpay mɛsà a ibɔɔn angye, mɛ kàsàsal mɛ mpɛl, anà ba bàkwen mukan'dwa sye! » ");
INSERT INTO yns_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Wɛɛ, Nzam kàmun'fuur aben? « Mɛ kàyee ntɔn mɛ baar nsaab nsàmbwar yà abaal, baar mpa bàsàbwà kà an'bwaŋ kusà a Baal. » ");
INSERT INTO yns_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Yà balàbal utaaŋ alà, ban'saal baar ikikye kan'sɔɔl Nzam unsà kab a ngway ande. ");
INSERT INTO yns_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Wɛɛ, isàkal naa unsà kab a ngway, kà unsà isal anki, iswaŋà naa kab a ngway kà là kab a ngway anki. ");
INSERT INTO yns_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Apanà, bi ifàtɛn aben? Undiir ulɛŋà Isàlɛl, nde wa ŋàtàkaar anki, wɛɛ baar bàsɔ̈ɔ̈l bàkyer akaar wa, wɛɛ akà bumwɛy, mpem aba yàbulà bwoor, ");
INSERT INTO yns_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","asànaa bàsön ya naa: « Nzam kàpɛ dweelà a bɔɔmà, mii ntɔn ukɔɔn aman, an'tsü ntɔn ukɔɔn awem, tii ŋàbà. » ");
INSERT INTO yns_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","David waa kàtɛn sye naa: « Wɛy mɛsà aba ibulà untaam anà an'tɛy ntɔn ba, ntɔn mbwaeel anà ntaaŋàmbar ntɔn ba! ");
INSERT INTO yns_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Wɛy mii aba ibü mpib, tii mpal bàyàfàman ba. Abɔ̈ɔ̈là müm ipepey. » ");
INSERT INTO yns_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Waa mɛ in'fuulà naa: nkye ntɔn mbweel ipepey, waa ba bàsɛlà? Kà ndandaa anki! Wɛɛ ntɔn ibii aba, waa Nzam kàpɛ mɔ̈ɔ̈ akà baar mpa abà Ayudà, ntɔn musɛn un'köl a Isàlɛl. ");
INSERT INTO yns_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Kyekà, isàkal naa ibii aba byàpɛ un'naaŋ u mɛɛn, anà ntyeey aba un'naaŋ a baar mpa abà Ayudà, abun nsuub aba yàŋàkwo iyàtwaal un'naaŋ a nkye ifà? ");
INSERT INTO yns_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Mɛ amàlakyään, ntɔn bɛ baar mpa làbà Ayudà: in'wà mɛ paa, mɛ, ntööm a baar mpa abà Ayudà, mɛ in'fàpà làkoo kà isal amɛ ");
INSERT INTO yns_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","unsà làkyän musɛn un'köl. Mɛ in'sii naa mɛ in'yàsɛɛn un'köl a atɔŋ amɛ unsà ndür ntɔn mutswà mɔ̈ɔ̈ a ndam a baar uboo a ba. ");
INSERT INTO yns_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ntɔn, isàkal naa nsyeel a ba ukɔl yàfuur un'tüüb a Nzam anà mɛɛn, mfurà aba iyàkal aben? Ya isàkal asànaa mfurà a baar fà ukwà tii u mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Kyekà, isàkal naa kab atàtwɛb là in'kyɛɛl, mfwar yanswà iyàkal in'kyɛɛl, isàkal naa un'swɛy wà in'kyɛɛl, an'kɔkà màyàkal mà in'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Wɛɛ isàkal naa an'kɔkà mamwɛy bàkyàtsuul, wɛɛ ngye, un'te a ɔlive a ndwaŋ, ngye bakön uboo a an'kɔkà màsàsal kà un'te a ɔlivɛ ntɔn badii anà ma u mbwo a un'swɛy mwɛy anà u mbwo a inɔ̈ mwɛy kya, ");
INSERT INTO yns_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","twon an'swaŋ ngaal kusà a an'kɔkà amàŋàtsul. Ngye an'kwo aswɛŋ ngaal, wɛɛ kà ngye anki asɛɛnà un'swɛy, wɛɛ un'swɛy akasɛɛnà. ");
INSERT INTO yns_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Apan, ngye ayàtɛn naa: « An'kɔkà bàtsül ma ntɔn mɛ ban'kön. » ");
INSERT INTO yns_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ye abwɛy. Bàtsül ba ma ntɔn bwoor a mpem a ba. Wɛɛ ngye, unsà làkwikilà waa ngye awà paa. Twon an'sɛn an'pɛy, wɛɛ kal kà igyɛɛŋ. ");
INSERT INTO yns_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ntɔn, isàkal naa Nzam kàtii anki an'kɔkà màfàtoo ma ŋakwo, kal kà igyɛɛŋ, manà nde ukɔ̈ɔ̈n asatii, akà ikikye! ");
INSERT INTO yns_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ler ubwaŋ anà nsyeel a mii a Nzam: nsyeel a mii akà baar abà bàbü, ubwaŋ akà ngye, isàkal naa ngye awà mulalà uboo a ubwaŋ ba, naa tɛy, ngye sye bàkyer asalwom. ");
INSERT INTO yns_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Wɛɛ akà ba, isàkal naa ba ban'wɛy bwoor a mpem aba, ba bàkyer asakɔn, ba sye, ntɔn Nzam we anà ikɔ̈b mukakɔn mbalà asin. ");
INSERT INTO yns_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Abun, isàkal naa ngye, ngye kàlwomà unsà un'te a olivɛ a ndwaŋ awà katwey wa ŋakwo, waa bakön unsà un'te a ɔlive a boo a bul, itàkal naa kà wa anki katwey, ntɔn nkye mpa bàfuur kà un'te a ɔlive a boo a bul an'kɔkà amà kàtwey nde ŋakwo? ");
INSERT INTO yns_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ntɔn mɛ inkwen anki, atɔŋ, naa bɛ làkɔ̈ɔ̈n ayöb ngyee ayi, manà bɛ làyamɛnà naa bɛ làbà aŋan'yeerà: ndam a baar a Isàlɛl, mpem aba isàkal yàŋàbwà bwoor mbɔɔn tii mpal bàsàbilà baar mpa abà Ayudà banswà uboo a un'sɛŋ a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Apan, Isàlɛl kyanswà isàwà mɔ̈ɔ̈, asànaa bàsön ya naa: « Un'tswää a mɔ̈ɔ̈ asàtoo u Siyɔnà, nde asàlwom ube a Yakɔb. ");
INSERT INTO yns_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Ya isàkal nkwà amɛ anà ba, mpal in'sàlwom mɛ man'be aba. » ");
INSERT INTO yns_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ntɔn Làsaŋ Aŋàbwaŋ, ba bà ayiiŋ a Nzam, ntɔn ubwaŋ abɛ, wɛɛ, ntɔn nsɔ̈ɔ̈l a Nzam, ba bànkween ntɔn bànkaa aba. ");
INSERT INTO yns_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ntɔn, Nzam ufàduum anki kab a ngway ufàpà nde, nde ufàsɔɔm anki mbeel ande. ");
INSERT INTO yns_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Abun sye, itaan, bɛ Nzam lun'kyeyà anki, apanà, ntɔn unkwem aba, bɛ bàkyàlasyääm, ");
INSERT INTO yns_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","abun, ukɔɔn unkyeey aba apanà kan'kyer naa Nzam kisyääm, anà nde usyääm sye ba banswà. ");
INSERT INTO yns_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ntɔn, Nzam kàbäm baar banswà uboo a unkwem ntɔn musyääm ba banswà. ");
INSERT INTO yns_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ɔɔ, indübà a un'naaŋ, a an'yeerà anà a un'yɛnà a Nzam! Ntsüül a mbar ande ufàgyool anki, mbwo ande ufàkul anki! ");
INSERT INTO yns_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Asànaa itɛɛnà Ndaa Aŋàsɔn: « Nà kàyöb an'kyän a Mwol? Itàkal naa nà kan'kwo mukal un'pɛɛl a an'lwɛŋ ande? ");
INSERT INTO yns_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Itàkal naa nà kàtun'pà undiir waa nde kàfun'lɔ̈ɔ̈m mfüür awa? » ");
INSERT INTO yns_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ntɔn undiir wanswà afü akà nde, u mbwo a nde, ntɔn nde. Akà nde làkoo a mbul a in'tye! Yà abwɛy. ");
INSERT INTO yns_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Atɔŋ, mɛ amàlalɔɔm, kikɔb a nsyääm a Nzam, làkäb ndür abɛ asànaa ibɔɔn a mɔ̈ɔ̈, kyà in'kyɛɛl anà kyàmupà Nzam un'sak: kya isàkal ngyamàkà a ndandaa ntɔn bɛ. ");
INSERT INTO yns_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Twon lan'lab nsyääl a mɛɛn a mpal ayi, wɛɛ làkäl bàŋàbulà u nsɔɔmà a un'yɛnà ntɔn musà nsɔ̈ɔ̈l unsà ukwen a Nzam: undiir aŋàbwaŋ afàpà nde un'sak anà wàŋàkwo. ");
INSERT INTO yns_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","U mbwo a kab a ngway alà ban'pɛ, mɛ in'tɛn akà umwɛy umwɛy uboo a bɛ: twon lan'kal anà uyɔl aŋàsöönà anà uyɔl tii unsà undiir ayɔbà, làyɔbà mbɔɔn ntɔn mutɔn uyɔl, umwɛy ntɔn isii a làkwikilà alà kun'pɛ Nzam. ");
INSERT INTO yns_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Asànaa bi ibà itiir mbɔɔn unsà ndür mwɛy, wɛɛ itiir abi byanswà kà byà isal imwɛy anki. ");
INSERT INTO yns_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Kyakin, itàkal naa bi ibà mbɔɔn, bi ibà ndür mwɛy unsà Klistɔ, ntɔn bi ibàŋàtüüb amwɛy anà bumwɛy, asànaa itiir a ndür mwɛy. ");
INSERT INTO yns_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Bi ibye anà an'kab mànsöön, mulab kab a ngway alà bipɛ, nkye la là kab a ngɔɔm? Wɛy bàsyääl la unsà un'tüüb anà làkwikilà. ");
INSERT INTO yns_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Nà awe anà kab a isal? Wɛy nde upɛ mɔ̈ɔ̈ ande unsà isal. Umwɛy usàkal anà kab alɔŋ, wɛy nde ulɔŋ. ");
INSERT INTO yns_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Nkye wumwɛy we alà làlɛɛl? Wɛy nde ulɛɛl. Wɛy mbuur afàpà, upɛ ukɔɔn asà un'tal, mbuur asyen, ukyer anà un'kanà, mbuur afàsyääm, ukyer unsà un'sak. ");
INSERT INTO yns_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Wɛy ukwen abɛ bàkɔ̈ɔ̈n akal bà mpem ywel. Làsi làyiiŋ akà ube, làbääb anà ubwaŋ: ");
INSERT INTO yns_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","- ntɔn ukwen a itɔŋ, làkäl anà ukwen mbɔɔn bɛ a bɛ, - ntɔn ibyääl, làkäl bàtàtwɛb musyäŋà baar asin, ");
INSERT INTO yns_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","- ntɔn isal a Mwol, làkäl ngwal unsà Dweelà, lun'syääl asànaa asɔ, ");
INSERT INTO yns_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","- ntɔn làkyän, làkäl unsà un'sak, - ntɔn mpay, làkäl anà nkääŋ a mpem, làsi muküünà u ngyamàkà ");
INSERT INTO yns_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","- ntɔn ngyal a aŋin'kyɛɛl, labay, làkäl anà un'kaay. ");
INSERT INTO yns_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Làsaak baar abà bàfàlamɛɛy nkwaaŋ: lasaak, twon lasi in'küül. ");
INSERT INTO yns_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Làsäŋ anà baar abà unsà un'sak, làlel anà baar bàlelà. ");
INSERT INTO yns_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Làkäl anà un'tüüb a ngwal bɛ a bɛ: twon lan'kal anà ngyal a indiir an'köl an'köl, wɛɛ, wɛy bàlasyeen akà indiir a làbɔ̈ɔ̈n. Twon lan'kyey uyɔl naa bɛ làbà aŋan'yeerà. ");
INSERT INTO yns_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Akà mbuur mwɛy, twon lan'fuur ube kà ikal a ube. Taaŋ lanswà, làleŋ mukyer ubwaŋ kusà a baar banswà. ");
INSERT INTO yns_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Kya ipöl isàkal, naa ba ukwen abɛ, làkäl a duu anà baar banswà. ");
INSERT INTO yns_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Nkween amɛ, twon lan'fuur bɛ ŋakwo ube akà ube, wɛɛ làwɛy nkyɛl a Nzam isäl, ntɔn bàsön naa: « Mwol kàtɛn naa: \"Mfuur a ube yà yàmɛ, mɛ kan'kwo mufur nsyääl a umwɛy umwɛy. ");
INSERT INTO yns_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Wɛɛ isàkal naa un'yiiŋ a ngye we anà ngyal, un'pɛ udyà, isàkal naa nde we anà mfyää, un'pɛ unwà. Ntɔn ngye asàkyer abun, ya yà asànaa an'kal a mbaa ngye akasaa udu a un'tswe ande.\" » ");
INSERT INTO yns_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Abun, twon an'wɛy naa ube bàwɛl iböŋ udu a ngye, wɛɛ kal wàŋàböŋ kusà a ube mukyer ubwaŋ. ");
INSERT INTO yns_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Wɛy mbuur wanswà ukäl anà unkyeey akà amfum abye anà ikɔ̈b, ntɔn, kà kye anà ikɔ̈b anki ikɔ̈ɔ̈n afà akà Nzam anà kàkɔ̈ɔ̈n asà Nde. ");
INSERT INTO yns_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Abun, mbuur afàmbäär ikɔ̈b, nde afàmbäär nswɛɛŋ kàkwen Nzam. Baar bàfàmbäär ya, bàsànaan ntaaŋàmbar udu a ba ŋakwo. ");
INSERT INTO yns_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Apan, antɛɛn kà baar awem bɔɔmà anki akà baar bàfàkyer ubwaŋ, wɛɛ akà baar bàfàkyer ube. Nkye ngye akwen mukɔɔn awem ntɛɛn bɔɔmà? Kyer ubwaŋ, waa nde kasyäŋà. ");
INSERT INTO yns_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ntɔn, nde wà un'syääl a Nzam ntɔn mukasiinà mukyer ubwaŋ. Wɛɛ, isàkal naa ngye afàkyer ube, apan, man bɔɔmà! Ntɔn, kà bunàbun anki awà nde anà kɔm mupà ntaaŋàmbar: nde wà un'syääl a Nzam ntɔn muswaŋ nkyɛl ande akà mbuur un'be. ");
INSERT INTO yns_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Kyakin, yubwaŋ mukal anà unkyeey, kà nà ntɔn bɔɔmà a nkyɛl mpɛl anki, wɛɛ sye, ntɔn an'kyän. ");
INSERT INTO yns_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Kyakin sye làfàfur bɛ iter, ntɔn baar bàfàwal bya, ba bà uboo a isal a Nzam ntɔn mukwey kya ubwaŋàbwaŋ. ");
INSERT INTO yns_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Làpɛ akà mbuur mbuur undiir awà ilɔɔmà mukun'pà: itɛr, akà mbuur awal itɛr, ibaa, akà mbuur awal ibaa, bɔɔmà, akà mbuur awal bɔɔmà, làbɔ̈ɔ̈n, akà mbuur awal làbɔ̈ɔ̈n, ibyääl, akà mbuur awal ibyääl. ");
INSERT INTO yns_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Twon lan'kal anà nkul a mbuur, naa tɛy, nkul abɛ, yà mukwen amwɛy anà bumwɛy. Ntɔn mbuur afàkwen mbuur wumwɛy, nde kan'kwey un'kɔɔn. ");
INSERT INTO yns_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Apan, nswɛɛŋ asànaa: « Twon an'tà inswem, twon an'dwa, twon an'yib, twon an'yɔm mpem », anà yumwɛy yanswà, yan'bilà unsà ndaa yi: « Ngye asàkwen un'tɔŋ angye asànaa ngye ŋakwo. » ");
INSERT INTO yns_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ukwen bàfàkyer anki akà ube mwɛy akà un'tɔŋ. Ukwen, yà mukwey un'kɔɔn wanswà. ");
INSERT INTO yns_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Làkäl kà igyɛɛŋ muyöb naa bi ibà mpal nà: làwiyà u twaal abɛ. Ntɔn ŋàbawà, ngweel a mɔ̈ɔ̈ yà tsütsü apà bi, akwànaa utaaŋ kàsɛmà bi musà làkwikilà. ");
INSERT INTO yns_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Mpib yàbü itaan, mwäänà wà tsütsü. Lalan, bi ipiy isal a làpib, bi ibwaar an'tà a pɛɛlà. ");
INSERT INTO yns_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Wɛy bi iyikyà a swalaa, asànaa u mwäänà answà, ukɔɔn in'kyɔm aŋàsöönà anà ngyöör a man, ukɔɔn ndaa a nswɛn anà ipasàsɛ, ukɔɔn an'sye anà un'köl. ");
INSERT INTO yns_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Wɛɛ làbwäär Mwol Yɛsu Klistɔ, twon lan'pà mɔ̈ɔ̈ abɛ unsà ndür ntɔn mupà un'sak akà ilään aya. ");
INSERT INTO yns_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Lun'wɛl mbuur awe anà gyɔ̈ɔ̈là unsà làkwikilà, twon lan'ler an'kyän ande pànsi pànsi. ");
INSERT INTO yns_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Làkwikilà a mbuur mwɛy lun'paa mbwo mudyà undiir wanswà, wɛɛ wumwɛy, u mbwo a gyɔ̈ɔ̈là, afàdyà ndon mpɛl. ");
INSERT INTO yns_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Wɛy mbuur afàdyà, ukɔɔn adyà un'siinà mbuur mpa afàdyà anà mbuur mpa afàdyà ukɔɔn atsüül mbuur afàdyà nsaŋ, ntɔn Nzam kàkyun'wal. ");
INSERT INTO yns_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Ngye, ngye awà nà mutsüül un'syääl abar nsaŋ? Itàkal naa nde wàŋàtsim, itàkal naa nde wàŋàbwà, ntɔn Mwol we anà ikɔ̈b mukun'mbaar. ");
INSERT INTO yns_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Akà mbuur umwɛy, ye anà nsöön uboo a ilä. Akà wumwɛy, bya byanswà byà mfun. Wɛy mbuur mbuur, amu an'kyän ande ŋakwo, ukäl aŋàsà kam. ");
INSERT INTO yns_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Mbuur afàsà ilä un'tal, nde afàkyer ntɔn Mwol. Mbuur afàdyà indiir byanswà, nde afàkyer ntɔn Mwol, nde afàfuur an'tɔɔn akà Nzam. Mbuur mpa afàdyà bya byanswà afàfuur an'tɔɔn sye akà Nzam. ");
INSERT INTO yns_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Kyakin, kà we anà umwey anki uboo a bi afàkal anà mɔ̈ɔ̈ ntɔn nde mpɛl, kà umwey anki sye afàkwà ntɔn nde ŋakwo. ");
INSERT INTO yns_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ntɔn, isàkal naa bi ibye anà mɔ̈ɔ̈, bi ibà ntɔn Mwol. Isàkal naa bi kan'kwà, bi kan'kwà ntɔn Mwol. Lalan, itàkal naa bi ibye anà mɔ̈ɔ̈, itàkal naa bi kan'kwà, bi ibà ntɔn Mwol. ");
INSERT INTO yns_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Lalan, ntɔn mukal Mwol a akü anà wà baar a mɔ̈ɔ̈ waa Klistɔ kàkü anà kàfyefurà u mɔ̈ɔ̈. ");
INSERT INTO yns_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Wɛɛ ngye, ntɔn nkye atsüülà ngye un'tɔŋ angye nsaŋ? Abun, bi banswà isàkal kusà a làbay a nsaŋ a Nzam. ");
INSERT INTO yns_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Asànaa kàtɛn Mwol: « Mɛ, Mwol in'wà anà mɔ̈ɔ̈, an'kyey naa: baar banswà bàsyebwà an'köm kusà amɛ, ba banswà bàsàsyäŋà Nzam. » ");
INSERT INTO yns_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Abun, mbuur mbuur uboo a bi asàkyer asà un'lɔɔn akà Nzam ntɔn nde ŋakwo. ");
INSERT INTO yns_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Bi ikyer awɛy mutsuul nsaŋ bamwɛy anà bumwey, wɛɛ làkyer naa bɛ làkɔ̈ɔ̈n akal isin a mbweel a un'tɔŋ. ");
INSERT INTO yns_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Akà mɛ, mɛ in'kyàyöb, mɛ an'sà kam unsà Mwol Yɛsu naa: undiir a ŋingyäy watɛy. Wɛɛ undiir a ŋingyäy wà akà mbuur awà kan'kyey naa wa wà abun. ");
INSERT INTO yns_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Isàkal naa un'tɔŋ angye kan'man ngyɛb ntɔn isaa an'dyà ngye, ngye afàkal anki uboo a ukwen. U mbwo a isaa angye, twon an'bwiy mbuur awà kàkweel Yɛsu. ");
INSERT INTO yns_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Wɛy undiir aŋàbwaŋ ntɔn bɛ ukɔ̈ɔ̈n akal ntɔn mutwee bɛ. ");
INSERT INTO yns_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Ntɔn, Imwol a Nzam kà kyà udyà anà unwà anki, wɛɛ balàbal, duu anà un'sak amu Dweelà In'kyɛɛl. ");
INSERT INTO yns_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Mbuur ufàsyääl Klistɔ abà, asànaa un'sɔ, Nzam akyer afun'kyey, baar bàkyer afun'kwen. ");
INSERT INTO yns_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Lalan, bi ilab indiir byàfàpà duu anà indiir byàfàtɔŋ itɔŋ. ");
INSERT INTO yns_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Twon an'dwa isal a Nzam ntɔn isaa. Ndandaa, indiir byanswà byàŋàpɔŋà, wɛɛ yà ube mudyà undiir kan'kwo mukal kyà ntɔn un'tɔŋ. ");
INSERT INTO yns_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Yubwaŋ mukɔɔn adyà in'twaŋ, itàkal unwà man bàfàyɔr, itàkal undiir asin kan'kwo mubwiy un'tɔŋ angye. ");
INSERT INTO yns_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Kaar ntɔn ngye, kusà a Nzam, làkwikilà awà ngye alà. Un'sak akà mbuur mpa afàtsüül nsaŋ nde ŋakwo ntɔn nsɔ̈ɔ̈l ande ufàsyääl nde. ");
INSERT INTO yns_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Wɛɛ mbuur akadyaa anà nkyɛɛr, nde wàŋàkwà ndwà, ntɔn nkääl ande kà yan'fà anki u nsyeel a kam ande unsà làkwikilà. Kyekà, undiir wanswà mpa afàfà u nsyeel a kam unsà làkwikilà wà man'be. ");
INSERT INTO yns_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Bi baar ibà ngwal, bi ikyer asɛɛn gyɔ̈ɔ̈là a baar mpa abà ngwal anà mukɔɔn aleŋ ubwaŋ abi ŋakwo. ");
INSERT INTO yns_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Wɛy mbuur mbuur uboo a bi uleŋ mupà un'sak akà un'tɔŋ ande ntɔn mukun'bay muyɛl unsà làkwikilà. ");
INSERT INTO yns_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Lalan, Klistɔ kàleŋ anki indiir byàpɛɛ nde un'sak, wɛɛ, a