﻿USE sofia;
DROP TABLE IF EXISTS sofia.ymp_vpl;
CREATE TABLE ymp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ymp_vpl WRITE;
INSERT INTO ymp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Diti me Yisu Kilisi limi. Yêni me Ablaham lo Devit ining lim lêkmuk. ");
INSERT INTO ymp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaham hîmbî Aisak vê. Me Aisak hîmbî Jekop vê. Me Jekop hîmbî Juda lêk viyaŋi vê. ");
INSERT INTO ymp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Me Juda hîmbî Peles lo Sela vê. Me thêi ning katik me Tama. Me Peles hîmbî Heslon vê. Me Heslon hîmbî Lam vê. ");
INSERT INTO ymp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Me Lam hîmbî Aminadap vê. Me Aminadap hîmbî Nason vê. Me Nason hîmbî Salmon vê. ");
INSERT INTO ymp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Me Salmon hîmbî Boas vê. Me Boas talêmbô me Lahap. Me Boas hîmbî Obet vê. Me Obet talêmbô me Lut. Me Obet hîmbî Jesi vê. ");
INSERT INTO ymp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Me Jesi hîmbî King Devit vê. Me Devit hîmbî Solomon vê. Me Solomon talêmbô me Ulia yanavî be Devit hiwa. ");
INSERT INTO ymp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Me Solomon hîmbî Lehoboam vê. Me Lehoboam hîmbî Abiya vê. Me Abiya hîmbî Asa vê. ");
INSERT INTO ymp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Me Asa hîmbî Jehosapat vê. Me Jehosapat hîmbî Jeholam vê. Me Jeholam me Usaia ya bumalô. ");
INSERT INTO ymp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Me Usaia hîmbî Jotam vê. Me Jotam hîmbî Ahas vê. Me Ahas hîmbî Hesekaia vê. ");
INSERT INTO ymp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Me Hesekaia hîmbî Manasa vê. Me Manasa hîmbî Amon vê. Me Amon hîmbî Josaia vê. ");
INSERT INTO ymp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Me Josaia me Jekonaia lêk viyaŋi ning bumalô. Jekonaia lêk viyaŋi ivutak hêndêng waklavông Islael ining ŋakyo evalong loho be iwa be ê êndô hîmô Babilon. ");
INSERT INTO ymp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Avîlanô Islael îmô Babilon denang, me Jekonaia hîmbî Sialtiel vê. Me Sialtiel me Selubabel ya bumalô. ");
INSERT INTO ymp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Me Selubabel hîmbî Abiut vê. Me Abiut hîmbî Elaiakim vê. Me Elaiakim hîmbî Aso vê. ");
INSERT INTO ymp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Me Aso hîmbî Sadok vê. Me Sadok hîmbî Akim vê. Me Akim hîmbî Eliut vê. ");
INSERT INTO ymp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Me Eliut hîmbî Eleasal vê. Me Eleasal hîmbî Matan vê. Me Matan hîmbî Jekop vê. ");
INSERT INTO ymp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Me Jekop hîmbî Josep vê. Me Josep ditu Malia yamalô. Me Malia êng ditu hevathu Yisu atu be elam nena Mesaya. ");
INSERT INTO ymp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Me avîlanô takatu be ivutak êndêng Ablaham ya wakma heveng hele be hêyô Devit, loho me hîtôm ondong lauming be lahavôva. Me avîlanô takatu be ivutak êndêng Devit ya wakma hele be hêyô avîlanô Islael ê Babilon, loho me hîtôm ondong lauming be lahavôva bêng yom. Me avîlanô takatu be ivutak hêndêng wakma atu be avîlanô Islael îmô Babilon hele be hêyô Mesaya ya wakma me hîtôm ondong lauming be lahavôva bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Diti me Yisu Kilisi ya kôkôthing hivutak pîk iti. Malia ya avîlanô bôk epesang ambô yôv vo endom yêni ethak Josep. Thêi mî bôk êk iving i amî denang me êyê nena Malia lêk hethambeng. Lovak Matheng da hevong be sêik êng hivutak. ");
INSERT INTO ymp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Metom Josep ôpatu be tem nimbua Malia me hîthông nena sêik atu be heva Malia la me hivutak bisête. Josep me anô thêthôp, be ditu hêndô nembong Malia moma îndôk avîlanô maleŋing. Êng me hethalo auk eveng vo netak yêni menang oyang bini. ");
INSERT INTO ymp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hethalo auk eveng denang me hêyê navîng te nena Anômbêng ya aŋêla te hêyô be henang nena, “Josep, Devit lim lêkmuk, sêik iti me hêlêm nang Lovak Matheng. Be ditu dô nôkô andô me numbua Malia bunu yong melak îtôm vônîm. ");
INSERT INTO ymp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Me tem nembathu wakna te be nondam ya athêng nena Yisu, vômbê nena tem nimbua ya avîlanô vê injêk ining kambom.” ");
INSERT INTO ymp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Me nômkama takiti hivutak vo Anômbêng ya ambô niŋgik anông nang bôk hêv ambô ti hêndêng plopet Aisaia be henang nena, ");
INSERT INTO ymp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ondaŋô! Avî te mî hêk hiving anô amî denang me tem nethambeng be nembathu wakna te. Be tem endam ya athêng nena Imanuel.” Athêng êng ya ondong nena, “Wapômbêng hîmô hiving aô.” ");
INSERT INTO ymp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Me Josep hêyê navîng êng yôv me hesong hiviyô. Me hê hevong bêng hîtôm datu be Anômbêng ya aŋêla henang me hiwa Malia be hê ya melak hîtôm yanavî. ");
INSERT INTO ymp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Metom mî hêk hiving yanavî amî hele be hevathu wakna êng yôv. Me hêv athêng Yisu hêndêng wakna êng. ");
INSERT INTO ymp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Malia bôk hevathu Yisu yôv hêk Betlehem nang Judia. Waklavông êng me Helot hîmô hîtôm king. Hêndêng wakma êng me ŋa lêkauk ethak môtôp nang long wak ethak êlêm Jelusalem ");
INSERT INTO ymp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","me enang ik ling nena, “Sêik lêkmuk atu be hivutak hîtôm ŋa Juda ning king, talêmbô hevathu hêk êsê? Yoô yê ya môtôp hivutak long wak ethak be yoô lêm vo aŋgêv yeng ethak yêni.” ");
INSERT INTO ymp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Me king Helot lêk avîlanô Jelusalem sapêng elaŋô ambô êng be leŋing malêing. ");
INSERT INTO ymp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tomêng me Helot helam ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung sapêng ethak tom. Me henang ik loho ling nena, “Mesaya atu tem embathu injêk êsê?” ");
INSERT INTO ymp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Me loho nang viyang nena, “Tem embathu injêk Betlehem nang Judia hîtôm Wapômbêng bôk henang be plopet te bôk hekavu nena, ");
INSERT INTO ymp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Ong Betlehem atu be hômô Juda ning pîk, anômbêng te tem nimbutak nang ong be neyaŋging yînîng avîlanô Islael îtôm boksipsip ining alang, be ditu ong mî melak lông oyang te hîmô Juda ning pîk lîvông amî. Mî anông!’ ” ");
INSERT INTO ymp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yôv me Helot helam ŋa lêkauk takatu menang oyang êlêm vo nendaŋô nena aŋgête ditu môtôp êng hivutak. ");
INSERT INTO ymp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Helaŋô yôv me hêv loho be ê Betlehem me henang nena, “Môlô nu me othalo sêik kasek êng katôyang. Be môlô tung yêni me ondelêm onang ethak ya vo yanaŋgêv yeng ethak inda imbing.” ");
INSERT INTO ymp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Loholaŋô king ya ambô yôv me loho ê. Me êyê môtôp atu be hivutak long wak ethak me himung be hê hele be hêyô heva long atu be sêik kasek êng hêk ya viling. ");
INSERT INTO ymp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wakma loho yê môtôp atu me loho leŋing mavî bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Be ditu loho vutak êyô melak kapô be ê me êyê sêik kasek atu lo talêmbô Malia. Êng me eya veŋiŋbudum thîvô me ikum be êv yeng ethak yêni. Me ik ining alepa kê be êv nômkama mavî mavî îtôm ining leŋing mavî hêndêng yêni. Êv gol lêk paola be sanda. ");
INSERT INTO ymp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Me êyê navîng te nena Wapômbêng henang ethak loho vo dô endeni êyô vo Helot ethak loŋbô andô. Êng me elom loŋdaŋlê yang be ê ning long hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ŋa lêkauk etak melak be loho ê yôv me Josep hêyê navîng nena Anômbêng ya aŋêla te hêyô be henang nena, “Helot tem nethalo wakna kasek vo niŋgik vônô. Be ditu numbiyô me numbua wakna kasek lo talêmbô be nôsôv be nu ketheng oyang Ijip me nômô endebe yaŋgêv ambô êndêng ong êm.” ");
INSERT INTO ymp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Êng me Josep hiviyô be hiwa wakna kasek lo talêmbô hêndêng bîlîvông be loho ê Ijip ");
INSERT INTO ymp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","me îmô hele be Helot hema. Nôm takêng hivutak vo Anômbêng ya ambô hik anông. Hîtôm bôk hêv ambô hêndêng plopet be henang nena, “Ya halam yînîng wakna hêk Ijip be hêlêm.” ");
INSERT INTO ymp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ŋa lêkauk ethak môtôp mî îvôê vo King Helot ethak loŋbô amî, be ditu la hêv loho ning ambô takatu be bôk enang ethak môtôp ya waklavông. Êng me heyala nena evatek yêni be la maning kambom anông. Be ditu hêv ŋa vovak vo iŋgik sêiknena takatu be ining sondakbêng hîtôm lokwaŋyi be hele hê sapêng vônô embeng Betlehem lêk ya long yaônena sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Be ditu ambô êng hik anông hîtôm bôk plopet Jelemaia henang nena, ");
INSERT INTO ymp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ŋalakŋalak bêng hêk Lama, athêng malêng lêk athêng bêng. Lesel nali lêk ema be mî. Êng me heleng be hêndô êŋgêv yêni thîvô, vômbê nena nali lêk mî.” ");
INSERT INTO ymp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Josep hîmô Ijip denang me Helot hema. Yôv me hêyê navîng nena Anômbêng ya aŋêla te hêyô ");
INSERT INTO ymp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","be henang nena, “Ŋa takatu be evong vo iŋgik wakna vônô bôk ema yôv, be ditu numbiyô me numbua wakna lo talêmbô be numbunnu Islael ining pîk ethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Êng me Josep hiviyô me hiwa wakna lo talêmbô be loho vôê Islael ining pîk. ");
INSERT INTO ymp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Me helaŋô nena Akelaus hiwa lambô Helot ya long be hîmô hîtôm plovins Judia ning king, be ditu hêkô ni long êng. Yôv me hêyê navîng yang ethak loŋbô nena dô loho ni Judia andô, bêng be ditu loho ê plovins Galili. ");
INSERT INTO ymp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Loho ê îmô melak lông te be ya athêng nena Nasalet. Nôm êng hivutak vo plopet ining ambô niŋgik anông hîtôm bôk enang nena, “Avîlanô tem endam yêni nena anô Nasalet te.” ");
INSERT INTO ymp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hêndêng waklavông takêng me Yisu hîmô Nasalet denang me Jon Anô Hithik Avîlanô hê hîmô long thiliv nang Judia be henang mêtê hêndêng avîlanô nena, ");
INSERT INTO ymp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Onde kapôlômim lîlîng vômbê nena melak leng ya lêkliŋyak bêng lêk hêlêm bidong oyang.” ");
INSERT INTO ymp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon me ôpatu be plopet Aisaia bôk henang yôv nena, “Kaêk te hêlêm nang long thiliv nena, ‘Ôpôpêk loŋdaŋlê vo Anômbêng êlêm, me opesang be nimbutak thêthôp vo yêni.’” ");
INSERT INTO ymp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon thak hik kwêv atu be epesang hethak bok kamel vuluk me hevak bokgôp hêyô hêk landong. Me thak heyang kômsopek lêk hinum damondam thôk. ");
INSERT INTO ymp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Me avîlanô êlêm nang Jelusalem lêk Judia sapêng lêk long takatu be hîmô bidong ŋanam Yelodan ê hêndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Me loho nang ining kambom bêng me Jon hithik loho hîlôk ŋanam Yelodan. ");
INSERT INTO ymp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Me hêyê Palisi lêk Sadyusi bêng anông êlêm vo nithik loho, metom henang ethak loho nena, “Môlô me bôyîv kambom nali! Osong nena tem ya thik môlô vo ôsôv injêk Wapômbêng ya la maning e? Mî anông! ");
INSERT INTO ymp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Be ditu môlô ning kombom iŋgik thô imbing nena lêk ole kapôlômim lîlîng yôv. ");
INSERT INTO ymp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Me dô lemim êŋgêv auk te be onang ethak amda nena, ‘Ablaham me yoô ning bumalô, be ditu yoô me avîlanô thêthôp.’ Mî. Ya hanang ethak môlô nena Wapômbêng hîtôm nimbua valu takiti be nepesang Ablaham limi ethak. ");
INSERT INTO ymp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Iyam lêk hêk alokwang ondong yôv vo alokwang takatu be mî hik anông mavî amî me tem ende li be îmbôk ethak amela. ");
INSERT INTO ymp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ya hathik môlô hethak ŋanam vo niŋgik thô nena lêk môlô ole kapôlômim lîlîng yôv. Metom ôpatu be tem nembeng ya yam ya lêklokwang me bêng anông vo yînîng, be ditu tem nithik môlô ethak Lovak Matheng lêk amela. Me ya me anô oyang be mî hîtôm yambua ya vakapô bokgôp îtôm anô ku oyang te amî. Mî anông. ");
INSERT INTO ymp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Me hevalong ya sala vo nethong ini wit be nîtîtînîng vo kôpik lêk limbalôm sapêng eŋgololong endebe nitup êm. Mîng nimbua ya anông be ni tak îmô melak kapô, metom ya kôpik me tem nîmbôk ethak amela atu be tem mî nema amî.” ");
INSERT INTO ymp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yisu hetak Galili be hê hêndêng Jon vo nithik inda îndôk ŋanam Yelodan. ");
INSERT INTO ymp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Metom Jon hevong vo nemba inda thing be henang nena, “Mavî vo nuthik ya, metom hevong bisê be hôlêm êndêng ya vo ya thik ong?” ");
INSERT INTO ymp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Metom Yisu henang viyang nena, “Dô. Lêk iti me nuthik ya vo ai sopa loŋdaŋlê thêthôp hîtôm Wapômbêng la hiving.” Êng me Jon hîlôk ethak Yisu ya ambô be hithik inda. ");
INSERT INTO ymp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bôlôtom oyang me Yisu hiviyô hêk ŋanam kapô be hêlêm yêing. Me leng hikê be hêyê Wapômbêng ya Lovak Matheng hîlôk be hêlêm hîtôm menak bôbô be hêyô hîmô yêni. ");
INSERT INTO ymp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Me ambô te hêlêm nang melak leng be henang nena, “Ôpiti me yînîng Wakna atu be ya leng hiving bêng anông. Me ya leng mavî anông ethak yêni.” ");
INSERT INTO ymp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yôv me Lovak Matheng helom Yisu be hê long thiliv vo Sakdang eyek inda. ");
INSERT INTO ymp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Me hitip ethak nôm îtôm wak buŋdaluk yi me bîlîvông buŋdaluk yi mîng hema ve la. ");
INSERT INTO ymp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Êng me anô atu be thak heyek avîlanô hê hêyô be henang ethak inda nena, “Betha avanông ong me Wapômbêng Nakandung, êng me nonang vo valu takiti imbutak îtôm polom.” ");
INSERT INTO ymp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Metom Yisu henang viyang nena, “Bôk ekavu yôv hêk kapua matheng nena, ‘Anô mî hîtôm nîmô lêkmala ethak polom yom amî. Yêni tem nîmô lêkmala ethak ambô takatu be Wapômbêng thak henang sapêng.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yôv me Sakdang hiwa yêni be hê melak lông matheng Jelusalem me hetak yêni heva melak matheng ya vôv anông. ");
INSERT INTO ymp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Me henang ethak inda nena, “Betha avanông ong me Wapômbêng Nakandung, êng me nôsôv kisi be nu tamu pîk vômbê nena bôk ekavu yôv nena, “ ‘Yêni tem nenang be ya aŋêla embalong ong be eyaŋging ong mavî vo valu te dô nîmbî vemkapô andô.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Metom Yisu henang hêndêng inda nena, “Bôk ekavu ambô yang hiving nena, ‘Dô noyek Wapômbêng yong Anômbêng andô.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yôv me Sakdang helom yêni hethak loŋbô be hê dum dêim te. Me hik pîk bêŋiti sapêng ya melak lông lêklokwang bêŋbêng lêk ining nômkama kêkêlô sapêng thô hêndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Me henang ethak inda nena, “Tem yaŋgêv nôm takiti sapêng êndêng ong. Metom noya vem budum thîvô be nôŋgêv yeng ethak ya êm.” ");
INSERT INTO ymp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Me Yisu henang nena, “Sakdang, ong vê injêk ya! Hîtôm bôk ekavu yôv nena, ‘Nôŋgêv yeng êndêng Wapômbêng yong Anômbêng me nombong yêni yom ya ku.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Êng me Sakdang hetak yêni be hê me aŋêla êyô be êv inda livung. ");
INSERT INTO ymp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Me Yisu helaŋô nena bôk evalong Jon be êndô hîmô kalaondong. Êng me hîvô hê Galili ");
INSERT INTO ymp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","me hê be hîmô Nasalet yôvêm me hetak be hê hîmô Kapenaom. Kapenaom hîmô kasîk bomang Galili ya dang hîmô Sebulun lo Naptali ining pîk. ");
INSERT INTO ymp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nôm êng hivutak vo plopet Aisaia ya ambô hik anông hîtôm bôk henang nena, ");
INSERT INTO ymp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulun lo Naptali ining pîk atu be hîmô loŋdaŋlê bêng atu be hê kasîk bomang be hêk ŋanam Yelodan ya dang vi be hîmô Galili long atu be ŋa long bôyang îmô. ");
INSERT INTO ymp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Avîlanô takatu be îmô long êng me îmô momaŋaning bêng kapô, metom lêk loho yê danda bêng te thô. Loho îmô ŋama ya dôhô kapô, metom lêk danda hivutak be hîmbî hêyô hêk loho.” ");
INSERT INTO ymp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hêndêng wakma atu be Yisu hêyô Kapenaom me henang mêtê be henang nena, “Onde kapôlômim lîlîng vômbê nena melak leng ya lêkliŋyak bêng lêk hêlêm bidong oyang.” ");
INSERT INTO ymp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yisu hivup ethak kasîk bomang nang Galili ya liŋdang me hêyê anô loyang yi, Saimon atu be ya athêng yang nena Pita loyang molok Endulu. Thêi me ŋa ik alim ŋanam be ditu ekaliv lek heveng kasîk bomang. ");
INSERT INTO ymp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Me henang ethak thêi nena, “Mamu lêm osopa ya! Tem yandông mamu vo ômbôv avîlanô îtôm ôvôv alim hîlôk lek.” ");
INSERT INTO ymp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bôlôtom oyang me thêi êndô ning lek îmô me esopa inda. ");
INSERT INTO ymp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yisu hivup ethak vauyaŋna me hêyê anô loyang yi ethak loŋbô, Jems lo Jon. Thêi me Sebedi namalô luvi. Loho eŋgabuling ining lek îmô yeng. Êng me helam thêi. ");
INSERT INTO ymp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Me bôlôtom oyang me etak ining kamik lêk yeng hîmô me esopa Yisu. ");
INSERT INTO ymp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisu hê be heveng Galili ning long sapêng be thak hivutak êyô loho ning melak yeng kapô be hîndông loho. Me henang Ambô Mavî hethak melak leng ya lêkliŋyak bêng hêndêng loho. Me hevong loho ning malêing leŋving kôpik lêk kômbôk lomaloma be ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Me avîlanô nang plovins Silia sapêng elaŋô kôkôthing hethak Yisu ya ku. Be ditu iwa ning ŋa lêk kômbôk lo vovang lomaloma sapêng be ê hêndêng yêni. Iwa ŋa gôk kambom hîmô hiving loho me ŋa iwa kômbôk elowaling be emayak lêk ŋa imuving sapêng ê be yêni hevong loho ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Avîlanô bêng anông nang Galili me Jelusalem lêk Judia me Dekapolis lêk long takatu be hîmô ŋanam Yelodan vi, loho sapêng êlêm esopa yêni. ");
INSERT INTO ymp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yisu hêyê avîlanô nômbêng atu êlêm me hethak dum te. Me hîlôk hîmô me ya ŋa hîndông êlêm êyô vo yêni. ");
INSERT INTO ymp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Me heya ambôlêk kê be hîndông loho be henang nena, ");
INSERT INTO ymp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ŋa takatu be êv yak hethak nômkama dôhôlôŋing. Êng me loho leŋing mavî, vômbê nena melak leng ya lêkliŋyak bêng me loho ning. ");
INSERT INTO ymp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Me ŋa takatu be leŋing malêing be eleng. Êng me loho leŋing mavî vômbê nena Wapômbêng tem nêŋgêv loho thîvô. ");
INSERT INTO ymp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Me ŋa takatu be îmô mayaô me loho leŋing mavî, vômbê nena tem imbua pîk sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Me ŋa takatu be ema ve leŋing lêk muning vo imbutak îtôm ŋa thêthôp. Loho leŋing mavî, vômbê nena loho tem leŋviŋyak. ");
INSERT INTO ymp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Me ŋa takatu be êv kapôlôŋing vo anô yang. Loho leŋing mavî, vômbê nena Wapômbêng tem nêŋgêv kapô vo loho bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Me ŋa takatu be kapôlôŋing mambung. Loho leŋing mavî vômbê nena tem injê Wapômbêng. ");
INSERT INTO ymp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Me ŋa takatu be epesang avîlanô ning malêing. Loho leŋing mavî, vômbê nena tem endam loho nena Wapômbêng nali. ");
INSERT INTO ymp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Me ŋa takatu be iwa vovang ethak kombom thêthôp. Loho leŋing mavî, vômbê nena melak leng ya lêkliŋyak bêng me loho ning. ");
INSERT INTO ymp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Me môlô ŋa takatu be avîlanô enang ambôma lomaloma hethak môlô lêk êv vovang hêndêng môlô be enang ambô kambom lomaloma hethak môlô lêk enang ambô yôhîng hethak môlô, me lemim mavî vômbê nena osopa ya. ");
INSERT INTO ymp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","“Avîlanô bôk evong bêng yom hêndêng plopet taksêmbôk be imung vo môlô. Be ditu lemim mavî anông be ômbô am, vômbê nena Wapômbêng tem nêŋgêv vuli mavî bêng te êndêng môlô îmô melak leng!” ");
INSERT INTO ymp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Me Yisu henang nena, “Môlô me hîtôm mamik pîk iti. Metom wakma mamik thilimbung be ya vathing hêv yak, êng me mî hîtôm vathing ethak loŋbô amî. Ya ku lêk mî be ditu ekaliv ini vo avîlanô êyômba pesa. ");
INSERT INTO ymp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Môlô me danda pîk iti. Me melak lông atu be hethak hîmô dum me mî hîtôm nekopak amî ");
INSERT INTO ymp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Me avîlanô mî thak êtôm lam be îsîk thing ethak wîng amî. Loho thak epesang lam be etak îmô yêing vo hîmbî danda hêyô hêk avîlanô takatu be îmô melak kapô êng sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","“Me bêng yom be môlô ning danda nîmbî êyônjêk avîlanô sapêng vo injê môlô ning ku mavî takatu be ovong vo êŋgêv môlô ning Kamik atu be hîmô melak leng ya athêng ling. ");
INSERT INTO ymp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Dô môlô song nena ya halêm vo yambuling ambô balambung lêk plopet ining ambô andô. Mî. Ya halêm vo yambatho ambô takêng long vo niŋgik anông me mî ya halêm vo yaŋgêv vê amî. ");
INSERT INTO ymp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya hanang avanông hethak môlô nena pîk lo leng tem yandang, metom ambô balambung ya alêlê te mena alêlê bônate tem mî nêŋgêv yak amî endebe nômkama sapêng imbutak yôv. ");
INSERT INTO ymp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bêng be anô te hêyê ambô balambung yaôna te hîtôm nôm oyang be hîndông avîlanô vi vo embong bêng, êng me tem ôpêng ya athêng yaôna injêk melak leng ya lêkliŋyak bêng kapô. Metom ôpatu be hesopa ambô balambung be hîndông avîlanô vi vo esopa me tem nimbutak anô lêk athêng bêng injêk melak leng ya lêkliŋyak bêng kapô. ");
INSERT INTO ymp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ya hanang avanông ethak môlô nena môlô ning kombom thêthôp mî hîvô hethak vo Palisi lêk kîdôŋga ambô balambung ining amî, êng me tem mî hîtôm ôyô melak leng ya lêkliŋyak bêng kapô amî. ");
INSERT INTO ymp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bôk môlô laŋô ambô takatu be enang ethak bumalô loho nena, ‘Dô uŋgik anô vônô andô. Me ôpatu be hik anô vônô paling me jas tem nendaŋô ya ambô be nêŋgêv malêing êndêng inda.’ ");
INSERT INTO ymp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Metom ya hanang ethak môlô nena anô te la maning ethak anô yang me jas tem nendaŋô ya ambô be nêŋgêv malêing êndêng yêni. Me anô te henang ambôma hethak anô yang, êng me tem nemba ŋa Juda ning avaka maleŋing. Me anô te henang ethak anô yang nena, ‘Ong anô molo,’ ôpêng ya kambom êng me hîtôm nêŋgêv yêni da ni long amela lêkmala hethang hîmô. ");
INSERT INTO ymp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Bêng be wakma hôyô bidong alakdala vo nôŋgêv yong da metom lem hêv nena yong ambô te hêk hiving aviyam, ");
INSERT INTO ymp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","êng me notak yong da îmô alakdala me nu êndêng yêni. Be nopesang ambô imbing inda yôv kîmîng nondelêm ôŋgêv yong da. ");
INSERT INTO ymp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Me waklavông anô te hevong embong ambô vo ong be mamu veng loŋdaŋlê hê denang vo mamu yô melak embong ambô, êng me nopesang ambô imbing yêni ketheng. Endekeme tem netak ong îndôk jas bang me jas êng tem netak ong îndôk kwak bidong baheŋing vo êndô ong îmô kalaondong. ");
INSERT INTO ymp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya hanang avanông ethak ong nena tem nômô kalaondong endebe nôŋgêv yong vuli atu be etak sapêng êm. ");
INSERT INTO ymp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Bôk môlô laŋô ambô takatu be enang yôv nena, ‘Dô ombong sek imbing anô yang yanavî andô.’ ");
INSERT INTO ymp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Metom ya hanang êndêng môlô nena anô te ma daŋtang hethak avî te be hevong vo ninjêk imbing avî êng, êng me lêk hêk hiving yêni yôv. ");
INSERT INTO ymp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Bêng be malem viyôhôk hevong be hovong kambom, êng me nosapu vê be nômbî ni vo dô nombong kambom ethak loŋbô andô. Lemvim kôpik bôte hêv yak me mavî, metom kambom vo ekaliv lemvim kôpik sapêng îndôk long amela hethang wak nômbêng iti hîmô. ");
INSERT INTO ymp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Me bahem viyôhôk hevong be hovong kambom, êng me nondambêng kisi be nômbî ni! Lemvim kôpik bôte hêv yak me mavî, metom kambom vo ekaliv lemvim kôpik sapêng îndôk long amela hethang wak nômbêng iti hîmô. ");
INSERT INTO ymp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bôk môlô laŋô yôv nena, ‘Anô te hevong vo nêndô yanavî me nekavu ambô îndôk kapua te be nêŋgêv êndêng yanavî vo nêŋgêv yêni vê.’ ");
INSERT INTO ymp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Metom ya hanang ethak môlô nena avî te mî hevong sek amî metom yamalô hêv yêni vê oyang be hiwa anô lêkmuk, êng me ôpêng da hevong be avî êng hevong sek. Me anô lêkmuk atu be hiwa avî atu be yamalô bôk hêv inda vê me hevong sek bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Bôk môlô laŋô ambô takatu be enang ethak bumalô loho nena, ‘Hovak ambô manjeng hethak Wapômbêng ya athêng hethak nômate, êng me nombong nôm êng anông me dô nombatek andô.’ ");
INSERT INTO ymp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Metom ya hanang ethak môlô nena dô môlômbak ambô manjeng te ethak nômate andô. Lêk dô môlômbak ambô manjeng ethak melak leng andô, vômbê nena melak leng me Wapômbêng ya balê king hêyô hîmô. ");
INSERT INTO ymp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Me dô môlômbak ambô manjeng ethak pîk andô, vômbê nena pîk iti me Wapômbêng ya long thak hetak vakapô hêyô heva. Me dô môlômbak ambô manjeng ethak Jelusalem andô, vômbê nena Jelusalem me King Bêng atu ya melak lông. ");
INSERT INTO ymp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Lêk dô môlômbak ambô manjeng ethak lumim kwandôk andô, vômbê nena môlô mî hîtôm onang be lumim kwandôk ŋaung te nimbutak thapuk mena loŋgavu ma amî. ");
INSERT INTO ymp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bêng be ditu môlô nang ambô avanông lêk mî yom. Me dô môlô nang ambô oyang doho imbing vo nembatho ambô mî lêk avanông long andô, vômbê nena ambô takêng me hêlêm nang Sakdang. ");
INSERT INTO ymp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Bôk môlô laŋô ambô takatu be enang yôv nena, ‘Anô te hîmbî anô yang mandaluk thing, êng me môlômbî ôpêng mandaluk thing bêng yom. Me anô te hik anô yang ambôlêk kalalang te li, êng me uŋgik ôpêng ambôlêk kalalang te li bêng yom imbing.’ ");
INSERT INTO ymp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Metom ya hanang ethak môlô nena dô uŋgik anô yang ya kambom lîlîng andô. Wakma anô te hepetav malem dang vi, êng me nuŋgik vi lîlîng vo nepetav imbing. ");
INSERT INTO ymp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Me anô te hevong ambô vo nimbua yong kwêv dêim atu be huik, êng me nôŋgêv yong kwêv thilimbung imbing. ");
INSERT INTO ymp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Me anô vovak te henang nena numbua ya nômkama be nu îtôm kilomita te, êng me nu îtôm kilomita yi. ");
INSERT INTO ymp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Me anô te henang ik ong ling vo nôŋgêv nômate êndêng yêni, êng me nôŋgêv êndêng inda. Me anô te la hiving nimbua nômate injêk ong yôv ketem nêŋgêv viyang, êng me dô nombasing andô. ");
INSERT INTO ymp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Bôk môlô laŋô ambô takatu be enang yôv nena, ‘Lem imbing yong avîlanô me nôpôlîk ethak yong ŋakyo.’ ");
INSERT INTO ymp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Metom ya hanang ethak môlô nena lemim imbing môlô ning ŋakyo me oteng mek vo Wapômbêng embong mavî êndêng ŋa takatu be evong kambom êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Môlôvong bêng me tem niŋgik thô nena lêk uvutak îtôm môlô ning Kamik atu be hîmô melak leng nali. Vômbê nena yêni da thak hêv wak hêndêng ŋa kombom mavî lêk ŋa kombom kambom me hêv ôthîng hêndêng ŋa thêthôp lêk ŋa mî thêthôp amî hiving. ");
INSERT INTO ymp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Me môlô thak lemim iving ŋa takatu be leŋing iving môlô yom, êng me osong nena tem môlômbua vuli mavî te e? Mî anông. Ŋa iwa takis thak evong bêng hiving! ");
INSERT INTO ymp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Me môlô thak onang waklîvông hêndêng môlô ning avîlanô yom, êng me osong nena môlôvong kombom mavî hîvô hethak vo avîlanô vi ining kombom thak evong e? Mî anông. Ŋa daluk thak evong bêng yom! ");
INSERT INTO ymp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bêng be ditu ômô mambung anông îtôm môlô ning Kamik atu be hîmô melak leng thak hîmô mambung anông.” ");
INSERT INTO ymp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Me Yisu henang hethak loŋbô nena, “Môlô yaŋging am vo dô ombong môlô ning kombom thêthôp mavî mavî vo avîlanô injê be embam môlô andô! Môlôvong bêng me môlô ning Kamik atu be hîmô melak leng tem mî nêŋgêv vuli mavî te êndêng môlô amî. ");
INSERT INTO ymp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Be ditu wakma môlôvong vo ôŋgêv avîlanô siv livung me dô ôŋgêv anô te vo niyuv lavuak imung îtôm ŋa evatek avîlanô thak evong hîlôk loŋdaŋlê lêk melak yeng andô. Loho evong bêng yôv me loho êv nômate hêndêng avîlanô siv vo avîlanô êyê be embam loho. Ya hanang avanông ethak môlô nena ŋa takêng lêk iwa ning vuli mavî sapêng yôv be heveng yam me Wapômbêng mî hîtôm nêŋgêv vuli mavî te êndêng loho amî. ");
INSERT INTO ymp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Metom wakma môlôvong vo ôŋgêv nômkama êndêng avîlanô siv me dô bahem vikeng eyala nôm atu be bahem viyôhôk hevong andô ");
INSERT INTO ymp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","vo ku êng injêk long kapô yom. Me môlô ning Kamik atu be hêyê ku takatu be ovong hêk long kapô me tem nêŋgêv vuli mavî te êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Wakma môlôvong oteng mek me dô môlômbong îtôm ŋa takatu be thak evatek avîlanô andô. Loho leŋing iving eteng mek emba melak lîvông lêk melak yeng vo avîlanô injê loho. Ya hanang avanông ethak môlô nena ŋa takêng lêk iwa ning vuli mavî sapêng yôv be heveng yam me Wapômbêng mî hîtôm nêŋgêv vuli mavî te êndêng loho amî. ");
INSERT INTO ymp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Metom wakma môlôvong oteng mek, êng me môlô nu ning melak kapô be uŋgik melak ambôlêk thing. Me oteng mek êndêng môlô ning Kamik atu be hîmô long kapô. Me tem ninjê ku takatu be môlôvong hêk long kapô me tem nêŋgêv vuli mavî êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Wakma môlôvong oteng mek me dô onang ambô oyang îtôm ŋa daluk thak evong andô. Loho thak eteng mek dêim vo esong nena ining wapômbêng tem endaŋô lohoma. ");
INSERT INTO ymp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Metom dô osopa loho ning bôk le long andô vômbê nena wakma ovong vo oteng mek me môlô ning Kamik lêk heyala môlô ning lemim iving yôv. ");
INSERT INTO ymp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Be ditu oteng mek bêŋiti, “ ‘Yoô ning Kamik hômô melak leng, nombong yong athêng injêk matheng. ");
INSERT INTO ymp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Me yong lêkliŋyak bêng êlêm. Me yoô sopa yong lem hiving injêk pîk hîtôm esopa hêk melak leng. ");
INSERT INTO ymp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Me nôŋgêv nôm wak iti êndêng yoô. ");
INSERT INTO ymp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Me notak yoô ning kambom hîtôm thak yoôtak avîlanô vi ning kambom takatu be evong ethak yoô. ");
INSERT INTO ymp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Me dô notak yoôndôk nôm takatu be tem neyek yoô andô. Me nôŋgêv yoô vê injêk anô kambom bang.’ ");
INSERT INTO ymp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ondaŋô. Môlô tak avîlanô takatu be evong kambom ethak môlô ning kambom, êng me môlô ning Kamik atu be hîmô melak leng tem netak môlô ning kambom bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Metom mî môlô tak avîlanô vi ning kambom amî, êng me môlô ning Kamik atu tem mî netak môlô ning kambom amî bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Wakma utip ethak nôm vo lemim êv Wapômbêng me dô malemim volong hîtôm ŋa evatek avîlanô thak evong andô. Loho mî ithik i be epesang i katô amî vo avîlanô injê be eyala nena loho lêk itip ethak nôm. Ya hanang avanông ethak môlô nena ŋa takêng lêk iwa ning vuli mavî sapêng yôv be heveng yam me Wapômbêng mî hîtôm nêŋgêv vuli mavî te êndêng loho amî. ");
INSERT INTO ymp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Metom wakma utip ethak nôm vo lemim êŋgêv Wapômbêng me uthik malemim be otak thing ethak lumim kwandôk ");
INSERT INTO ymp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","vo avîlanô dô eyala nena lêk utip ethak nôm andô. Me môlô ning Kamik atu be hîmô long kapô yom tem ninjê môlô ning ku long kapô sapêng me tem nêŋgêv vuli mavî êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ondaŋô. Dô uthining nômkama mavî mavî îmô pîk iti andô, vômbê nena pîk iti me sêpbindi lêk hethaŋda thak ivuling nômkama me ŋa vanî thak ele melak kê be iwa nômkama. ");
INSERT INTO ymp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Metom môlô thining nômkama mavî mavî melak leng, vômbê nena melak leng me sêpbindi lêk hethaŋda mî thak ivuling nômkama amî lêk ŋa vanî mî thak ele melak kê be iwa nômkama amî. ");
INSERT INTO ymp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ondaŋô. Long alê atu be môlô ning nômkama mavî mavî hîmô, ditu tem môlô ning lemim iving îmô long êng yom imbing. ");
INSERT INTO ymp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Malemdaluk me hîtôm lam be hêv danda hêndêng lemvim kôpik sapêng. Be ditu malemdaluk mavî, êng me tem danda îmô lemvim kôpik sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Metom malemdaluk kambom me momaŋaning bêng tem nîmô lemvim kôpik sapêng. Endekeme osong nena danda hîmô môlô kapô ma, metom momaŋaning bêng hîmô môlô kapô, be ditu momaŋaning êng me bêng anông! ");
INSERT INTO ymp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Anô te mî hîtôm nembong anômbêng yi ning ku amî. Tem laŋgêv imbing anô yang sê me kapô êndô anô yang sê. Me tem nesopa anô yang sê me nende dôm lîlîng êndêng anô yang sê. Bêng be ditu mî hîtôm môlô sopa Wapômbêng lêk valuseleng imbing amî. ");
INSERT INTO ymp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Bêng be ya hanang ethak môlô nena dô lemim iŋgik am ethak nômkama pîk lomaloma hîtôm kwêv mena nôm lêk ŋanam andô. Lêkmala me bêng vo nôm oang. Leŋving kôpik me bêng vo kwêv lêk thôp. ");
INSERT INTO ymp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ôŋgô menak. Loho thak mî evatho nôm be iwa ya anông amî. Lêk loho ning melak etak nôm îmô mî. Metom môlô ning Kamik atu be hîmô melak leng thak hevakông loho. Bêng be môlô me Wapômbêng la hiving bêng anông hîvô hethak vo menak takêng. ");
INSERT INTO ymp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Be ditu lemim ik am ethak nômate me lemim ik am êng mî hîtôm netak wakma te oyang êyômô môlô ning lêkmala long imbing amî. Mî anông! ");
INSERT INTO ymp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bisête be thak môlô lemim ik am hethak thôp? Môlôŋgô thiling vuak takatu be hîmô mayaliv. Loho ivutak bisê? Loho thak mî evong ku lêk epesang ining thôp amî. ");
INSERT INTO ymp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Metom ya hanang ethak môlô nena thiling vuak mavî takêng ining wamba leleyang me hîvô hethak vo King Solomon ya wamba leleyang lomaloma sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bêng be Wapômbêng hêv wamba mavî mavî hêndêng kamung lomaloma takatu be lêk aô yê, metom yamông me tem îmbôk ethak amela. Me môlô me bêng îvô hethak vo kamung takêng, be ditu Wapômbêng tem neyaŋging môlô bêng yom. Alitaknena, môlô ning ôêv iving mî bêng amî. ");
INSERT INTO ymp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Be ditu dô môlô lemim iŋgik am be môlô nang nena, ‘Tem yoôŋgang ômbête be yoô num ômbête lêk yoôŋgik ômbête andô.’ ");
INSERT INTO ymp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ŋa daluk thak leŋing ik i hethak nôm takêng. Metom môlô ning Kamik atu be hîmô melak leng me heyala môlô ning malêing. ");
INSERT INTO ymp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Be ditu ku himung me othalo Wapômbêng ya lêkliŋyak bêng lêk osopa ya kombom thêthôp me tem nêŋgêv nôm takêng sapêng êndêng môlô imbing. ");
INSERT INTO ymp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bêng be dô môlô lemim iŋgik am vo yamông ya nômkama andô. Yamông ya malêing me yamông da ya. Bêng be wak te ya malêing me wak êng da ya. ");
INSERT INTO ymp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Dô môlô tîtînîng avîlanô be onang loho ning kambom bêng be onang nena loho ŋa evong kombom kambom andô. Endekeme Wapômbêng tem nembong bêng yom ethak môlô! ");
INSERT INTO ymp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Me ambô alêla takatu be onang ethak avîlanô me Wapômbêng tem nenang bêng yom ethak môlô. Me kombom alê atu be môlô thô avîlanô vi lelalîlîng me tem nembong bêng yom ethak môlô. ");
INSERT INTO ymp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bisête be hôyê siŋusik hîmô aviyam mandaluk me mî hôyê aseleng bêng atu be hepalaŋganing hêk malemdaluk thing amî? ");
INSERT INTO ymp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Me bisête be honang hêndêng aviyam nena, ‘Aiyang, ya leng hiving yaŋgêv siŋusik itu be hîmô malemdaluk vê’? Metom ong da mî hôyê aseleng atu be hepalaŋganing hêk malemdaluk thing be nôŋgêv vê amî. ");
INSERT INTO ymp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ong anô ambô yôhîng! Nôŋgêv aseleng atu be hêk malemdaluk thing vê be nôŋgô tak katô êm, yôv kîmîng nôŋgêv siŋusik atu be hêk mamuyam mandaluk vê. ");
INSERT INTO ymp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Me dô umbua nôm matheng be ôŋgêv êndêng avung andô. Vômbê nena tem iŋgik lîlîng be ethang môlô mayaliv. Me dô môlômbî môlô ning kômkôm mavî ni vo bok andô. Endekeme embak pesa ethak veŋiŋkapô. ");
INSERT INTO ymp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Môlô nang iŋgik Wapômbêng ling me tem nêŋgêv êndêng môlô. Me othalo nômate me tem ôpôm nôm êng. Me upindinding melak ambôlêk me tem niŋgik kê vo môlô. ");
INSERT INTO ymp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Vômbê nena ŋa takatu be enang ik Wapômbêng ling me tem imbua. Me ethalo nômate me tem êpôm. Me ipindinding melak ambôlêk me tem niŋgik kê vo loho. ");
INSERT INTO ymp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Me nalum malô henang ik ong ling vo nôŋgêv polom êndêng yêni me tem nôŋgêv valu te êndêng inda mesa? ");
INSERT INTO ymp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Me henang ik ong ling vo nôŋgêv alim ŋanam te êndêng yêni me tem nôŋgêv bôyîv kambom te êndêng inda mesa? ");
INSERT INTO ymp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Môlô avîlanô kombom kambom, metom thak môlôyala ôŋgêv nômkama mavî mavî êndêng nalumi. Metom môlô ning Kamik atu be hîmô melak leng eyala katôyang îvô ethak vo môlô ning katik lo kamik, be ditu tem nêŋgêv nômkama mavî êndêng ŋa takatu be enang ik yêni ling. ");
INSERT INTO ymp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Me kombom atu be lem hiving avîlanô embong êndêng ong, êng me nombong bêng yom êndêng avîlanô vi, vômbê nena Moses ya balambung lêk plopet ining kapua ning ondong anông. ");
INSERT INTO ymp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Môlômbutak ôyô bandêng ambôlêk yaôna, vômbê nena loŋdaŋlê bêng me hê long ŋama. Me loŋdaŋlê êng ya bandêng ambôlêk me lêkwaê anông be avîlanô bêng anông thak ivutak êyô. ");
INSERT INTO ymp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Metom loŋdaŋlê hê long lêkmala me yaônalêk. Be ya bandêng ambôlêk me yaônalêk be avîlanô tomtom yom thak êpôm be ivutak êyô. ");
INSERT INTO ymp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Môlô yaŋging am ethak plopet ambô yôhîng. Loho ivuliv i thing ethak boksipsip ining kôpik be êthôk êndêng môlô, metom kapôlôŋing me hîtôm avung yatap. ");
INSERT INTO ymp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Be ditu loho da ning bôk le long tem niŋgik loho da thô. Me betha avîlanô hîtôm imbua alokwang pik lêk yak waing anông emba yak lêklilu mesa? Mî anông. ");
INSERT INTO ymp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Be ditu alokwang mavî nômbêng iti thak ik anông mavî me alokwang kambom nômbêng iti thak ik anông kambom. ");
INSERT INTO ymp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bêng yom me alokwang mavî mî hîtôm niŋgik anông kambom amî me alokwang kambom mî hîtôm niŋgik anông mavî amî. ");
INSERT INTO ymp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bêng be alokwang takatu be mî thak hik anông mavî amî, me tem ende li be îmbôk ethak amela. ");
INSERT INTO ymp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bêng be ditu plopet ambô yôhîng ining kombom da tem niŋgik loho da thô ethak môlô. ");
INSERT INTO ymp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Avîlanô bêng anông thak elam ya nena, ‘Anômbêng, Anômbêng,’ metom doho mî hîtôm êyô melak leng ya lêkliŋyak bêng kapô bini amî. Me ôpatu be hesopa Wakamik atu be hîmô melak leng ya la hiving yom, ditu tem nimbutak êyô kapô bini. ");
INSERT INTO ymp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hêndêng wakma evong ambô me avîlanô bêng anông tem enang ethak ya nena, ‘Anômbêng, Anômbêng, hethak yong athêng me bôk yoô nang Wapômbêng ya ambô bêng lêk yoô êv gôk kambom vê hêk avîlanô me avong nôm thamtham bêng anông mesa mî?’ ");
INSERT INTO ymp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Êng me tem ya nang ethak loho nena, ‘Ombeng dang! Môlô ŋa ovong kombom kambom be ya hathông môlô paling.’” ");
INSERT INTO ymp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Me Yisu henang nena, “Ôpatu be helaŋô yînîng ambô nômbêng iti be hesopa, yêni me hîtôm anô lêkauk mavî te atu be helav ya melak landîng hivup hêyô heva valu. ");
INSERT INTO ymp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yôv me ôthîng lêk lovak be ŋanambô bêng hêyô be hekalông melak êng. Metom pîk lêk valu hevalong melak landîng êng long manjeng be mî hipu amî. ");
INSERT INTO ymp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Me opalê atu be helaŋô yînîng ambô metom mî hesopa amî, me hîtôm anô auk mî te atu be helav ya melak hêyô hîmô thathe oyang yom. ");
INSERT INTO ymp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yôv me ôthîng lêk lovak lêk ŋanambô bêng hêyô be hekalông melak êng be hîŋgôlî be hivuling melak êng sapêng.” ");
INSERT INTO ymp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yisu henang ambô takêng yôv me avîlanô nômbêng atu be elaŋô esong kambom ethak ya ambô atu be hîndông loho ");
INSERT INTO ymp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","vômbê nena yêni hîndông loho hîtôm anô lêk athêng bêng me mî hîtôm loho ning kîdôŋga ambô balambung amî. ");
INSERT INTO ymp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisu hetak dum me hîlôk be hê me avîlanô bêng anông esopa yêni. ");
INSERT INTO ymp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Me anô kômbôk lepla te hêlêm êndêng Yisu me heya vabudum thîvô be henang nena, “Anômbêng, ong da yong lem hiving me hîtôm nombong be yambutak mavî.” ");
INSERT INTO ymp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Me Yisu henang nena, “Ya leng hiving.” Be hêthôm ôpêng me henang nena, “Numbutak mambung!” Me ketheng oyang me ya kômbôk hêv yak me ôpêng hivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yôv me Yisu henang ethak yêni nena, “Dô nonang bêng ethak anô te andô. Metom nu me nuŋgik ong thô ethak anô hîmbôk da me nôŋgêv da êndêng Wapômbêng vo niŋgik thô nena lêk huvutak mambung hîtôm Moses bôk henang yôv. Hovong bêng me tem avîlanô sapêng injê be eyala nena lêk huvutak mambung.” ");
INSERT INTO ymp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yisu hêyô Kapenaom me anô vovak lêik te nang Lom hêlêm hêndêng yêni me hepetenak inda nena, ");
INSERT INTO ymp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Anômbêng, yînîng anô ku te hêpôm kômbôk va lo bang himuving be hiwa vovang bêng be hêk melak yom.” ");
INSERT INTO ymp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Me Yisu henang ethak inda nena, “Tem ya thôk vo yambong ôpêng mavî.” ");
INSERT INTO ymp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Metom anô vovak lêik êng henang nena, “Anômbêng, ya mî anô mavî hiving vo nôlêm yînîng melak amî. Be ditu ya hayala nena nonang yom me yînîng anô ku tem nimbutak mavî ethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Vômbê nena ya da me ya hamô anômbêng te vimbing hiving me yînîng ŋa vovak îmô ya vimbing. Me thak ya hanang ethak yînîng anô vovak te nena, ‘Nu,’ êng me thak hê. Mena ya hanang ethak yang nena, ‘Nôlêm,’ êng me thak hêlêm. Me ya hanang ethak yînîng anô ku nena, ‘Nombong ku tiêng’ êng me thak hevong yom.” ");
INSERT INTO ymp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yisu helaŋô ambô êng be hesong kambom me henang ethak avîlanô takatu be esopa yêni nena, “Ya hanang avanông ethak môlô. Bôk mî ya hatung anô hêv iving lêklokwang te bêŋiti hîmô Islael ining long sapêng amî. ");
INSERT INTO ymp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ya hanang ethak môlô nena avîlanô long bôyang bêng anông tem etak ining pîk nômbêng iti sapêng be ini vo injang nôm bêng imbing Ablaham lo Aisak be Jekop îmô melak leng ya lêkliŋyak bêng kapô. ");
INSERT INTO ymp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Metom avîlanô takatu be Wapômbêng bôk hîtôk loho yôv vo êyô ya lêkliŋyak bêng kapô bini me tem nêŋgêv loho vê bini long momaŋaning. Long êng me tem loho endeng athêng malêng be ethang vieŋing ondong long.” ");
INSERT INTO ymp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yôv me Yisu henang ethak anô vovak lêik êng nena, “Nu! Me nôm atu be lêk hôêv iving nena tem nimbutak me tem nimbutak bêng hîtôm hôêv iving.” Me hêndêng wakma êng yom me ya anô ku atu hivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yôv me Yisu hêyô Pita ya melak kapô me hêyê Pita yaŋavî hêpôm kômbôk vovang be hêk yom. ");
INSERT INTO ymp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Me Yisu hevalong avî êng bang me kômbôk êng hetak yêni me hiviyô be hepesang be hêv hêndêng loho. ");
INSERT INTO ymp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hêndêng yathiŋdang me avîlanô iwa ŋa gôk kambom ivuling loho bêng anông êlêm êyô vo Yisu. Me henang yom be gôk takêng etak ŋa takêng be ê. Me hevong avîlanô lêk kômbôk sapêng ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Be ditu plopet Aisaia ya ambô hik anông hîtôm bôk henang nena, “Yêni da hepesang aô ning kômbôk mavî lêk hêv aô ning vovang vê.” ");
INSERT INTO ymp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wakma Yisu hêyê avîlanô bêng anông elawê inda me henang ethak ya ŋa hîndông nena, “Aô na kasîk bomang viyang vulu.” ");
INSERT INTO ymp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Êng me kîdôŋga ambô balambung te hêlêm êyô vo Yisu me henang nena, “Kîdôŋga, long nômbêng atu be hô me tem ya sopa ong.” ");
INSERT INTO ymp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Me Yisu henang nena, “Avung yatap ining pîk ambuang hîmô me menak ining unak hîmô, metom Anô Ya Nakandung ya long ninjêk mî.” ");
INSERT INTO ymp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yôv me Yisu ya ŋa hîndông te henang ethak inda nena, “Anômbêng, notak ya vo ya nandav wakamik yôvêm.” ");
INSERT INTO ymp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Metom Yisu henang ethak inda nena, “Notak ŋa dôhôlôŋing bôk ema yôv vo loho da endav ining ŋama me nôlêm nosopa ya.” ");
INSERT INTO ymp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yôv me Yisu hethak yeng me ya ŋa hîndông ethak yeng hiving be loho ê. ");
INSERT INTO ymp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Loho mô kasîk bomang lîvông me bôlôtom oyang me ôthîng lêk lovak bêng hêyô. Me ŋanam budum hik be hevong êyô yeng vôv metom Yisu me hêkthôm. ");
INSERT INTO ymp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Me ya ŋa hîndông ê ik yêni ling be enang nena, “Anômbêng, tem aôma! Be ditu nôŋgêv aô livung!” ");
INSERT INTO ymp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Me Yisu henang ethak loho nena, “Môlô ning ôêv iving me yaônalêk! Bisête be môlô kô?” Êng me hiviyô be hethang lovak lêk ŋanam budum êng be hêk teŋeng anông. ");
INSERT INTO ymp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Êng me loho song kambom be enang nena, “Opalête ti be lovak lêk ŋanam budum elaŋô ya ambô be esopa?” ");
INSERT INTO ymp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yôv me Yisu hê kasîk bomang viyang vulu me hêyô avîlanô Gadala ining pîk. Me anô lokwaŋyi be thak gôk kambom îmô hiving thêi êlêm nang kalang be êpôm yêni hîlôk loŋdaŋlê. Be anô yi êng thak ivuling avîlanô, be ditu thak loho kô endom loŋdaŋlê êng. ");
INSERT INTO ymp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ôpyiêng êyê Yisu be elam kaêk lêkwaê nena, “Wapômbêng Nakandung, hôlêm vo nombong ômbête ethak yoô? Wakma atu be Wapômbêng etak me mî denang me hôlêm long iti vo nôŋgêv vovang êndêng yoô mesa?” ");
INSERT INTO ymp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Me bok bêng anông îmô dêim doke be eyang tak îmô. ");
INSERT INTO ymp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Me gôk kambom takêng epetenak Yisu nena, “Hovong vo nôŋgêv yoô vê, êng me nôŋgêv yoô nindôk bok takdaku.” ");
INSERT INTO ymp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Me Yisu henang ethak loho nena, “Môlô nu!” Êng me gôk kambom takêng etak anô yi êng me ê îlôk bok takêng kapô me evothong be ethak i mayaliv hîlôk wanda be ê êv yak hîlôk kasîk bomang kapô be ema. ");
INSERT INTO ymp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ŋa takatu be eyaŋging bok êyê nôm êng me îsôv be ê melak lông. Me enang ethak avîlanô hethak nôm atu be Yisu hevong ethak bok lêk anô yi atu be gôk kambom hivuling thêi. ");
INSERT INTO ymp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tomêng me avîlanô melak lông êng ik i thô be ê hêndêng Yisu. Loho yê yêni be êkô kambom be epetenak nena, “Notak yoô be nu!” ");
INSERT INTO ymp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yôv me Yisu hethak yeng te be hîvô hê ya long atu be thak hîmô nang Kapenaom. ");
INSERT INTO ymp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Me anô doho iwa anô himuving te hêk ya yêm be êlêm vo yêni. Êng me Yisu hêyê loho ning êv iving be henang ethak anô himuving atu nena, “Yînîng wakna, kapôlôm injêk mayaô. Yong kambom sapêng lêk ya hêv vê.” ");
INSERT INTO ymp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kîdôŋga ambô balambung doho elaŋô ambô êng me enang ethak i nena, “Ôpiti hevong vo nimbua Wapômbêng ya long mesa?” ");
INSERT INTO ymp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yisu heyala loho ning auk be henang nena, “Bisête be uwa auk kambom iti hêk môlô kapôlôŋing? ");
INSERT INTO ymp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ambô alête vumeng vo ya nang: ‘Lêk ya hêv yong kambom sapêng vê’ mesa ‘Numbiyômba be nombeng’? ");
INSERT INTO ymp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Metom tem yaŋgik thô êndêng môlô vo oyala nena Anô Ya Nakandung ya lêklokwang me bêng hêk pîk iti be hîtôm nêŋgêv kambom vê.” Yôv me henang ethak anô himuving atu nena, “Numbiyômba me numbua yong yêm be nu yong melak.” ");
INSERT INTO ymp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Êng me ôpêng hiviyô heva be hê ya melak. ");
INSERT INTO ymp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Me avîlanô êyê nôm êng be esong kambom be êv Wapômbêng ya athêng ling, vômbê nena lêk hêv lêklokwang lêk athêng bêng hêndêng avîlanô pîk. ");
INSERT INTO ymp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yisu hê me hêyê anô te be ya athêng nena Matyu be hîmô melak iwa takis. Me henang ethak ôpêng nena, “Nôlêm osopa ya,” êng me hiviyô be hê me hesopa Yisu. ");
INSERT INTO ymp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yisu heyang nôm hiving Matyu hîmô ya melak. Me ŋa iwa takis lêk ŋa evong kombom kambom bêng anông êlêm eyang nôm hiving yêni lêk ya ŋa hîndông. ");
INSERT INTO ymp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Palisi êyê me enang ik ya ŋa hîndông ling nena, “Bisête be môlô ning kîdôŋga heyang nôm hiving ŋa iwa takis lêk ŋa evong kombom kambom vo?” ");
INSERT INTO ymp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yisu helaŋô ambô êng me henang nena, “Ŋa lêk kômbôk yom thak ê êyê dokta. Me ŋa kômbôk mî me thak mî ê amî. ");
INSERT INTO ymp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bêng be môlô nu me umbua auk ethak ambô tiêng ya ondong: “ ‘Ya leng hiving môlôŋgêv kapôlômim êndêng avîlanô me ya handô môlôŋgêv da yom êndêng ya.’ Vômbê nena ya halêm vo yandam ŋa takatu be evong kombom kambom. Me mî ya halêm vo yandam ŋa thêthôp amî.” ");
INSERT INTO ymp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jon ya ŋa hîndông êlêm êyô vo Yisu me enang ik yêni ling nena, “Yoô lêk Palisi thak atip ethak nôm vo leŋing êv Wapômbêng, metom yong ŋa hôndông mî thak evong bêng amî vo?” ");
INSERT INTO ymp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Me Yisu henang nena, “Wakma anô te hiwa avî lêkmuk, êng me ya ŋa môlôô tem injang nôm lêk leŋing mavî me tem mî hîtôm leŋing malêing amî. Metom wakma atu be iwa yêni vê hêk loho, êng me loho tem itip ethak nôm.” ");
INSERT INTO ymp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Anô te mî hîtôm nimbua thôp lêkmuk bôte be nindi thôp bôô ya ambuang thing ethak amî. Hevong bêng me thôp lêkmuk tem nîmô thôp bôô bô êng kê. Êng me tem nitip bêng. ");
INSERT INTO ymp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Me anô te mî thak hêkê waing lêkmuk hîlôk boksipsip ya kôpik bôô amî. Hevong bêng me waing lêkmuk tem nimbuling bok kôpik bôô atu be nipupkê be waing eŋgathô ni. Bêng be ditu thak êkê waing lêkmuk hîlôk bok kôpik lêkmuk atu be belap vo ninding mavî me mî hîtôm nipupkê amî lêk waing mî hîtôm neŋgathô ni amî.” ");
INSERT INTO ymp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisu henang ambô denang me anômbêng te hêlêm be heya vabudum thîvô hîmô yêni va me henang nena, “Yînîng avena lêk hema, metom nôlêm otak bahem êyônjêk yêni me tem nimbiyô ethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Me Yisu hiviyô be hê hiving yêni me ya ŋa hîndông ê hiving. ");
INSERT INTO ymp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Loho veng be ê denang me avî lêk kômbôk te heveng yam êlêm bidong Yisu dôm me hêthôm ya kwêv dang. Avî êng bôk hiwa kômbôk lêkma helom hêk wak nômbêng iti hîtôm sondakbêng lauming be lahavôyi. ");
INSERT INTO ymp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Me avî êng ya auk nena, “Ya thôm ya kwêv yom me tem ya mavî.” ");
INSERT INTO ymp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Me Yisu hik i lîlîng be hêyê avî êng me henang nena, “Yînîng avena, kapôlôm injêk mayaô. Yong hôêv iving hevong be lêk huvutak mavî.” Me ketheng oyang me avî êng hivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yôvêm me Yisu hê hêyô anômbêng atu ya melak. Me hêyê avîlanô iyuv kotong be eleng be evong pôk bêng anông ");
INSERT INTO ymp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","me henang nena, “Môlô vê! Avena ti hêkthôm yom me mî hema amî.” Êng me loho malîk ethak yêni. ");
INSERT INTO ymp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Metom hêv avîlanô vê me hivutak êyô melak kapô me hevalong avena êng bang me hiviyô heva. ");
INSERT INTO ymp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Be ditu kôkôthing hethak nôm êng hevothong heveng long êng sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Me Yisu hetak long êng me heveng be hê me anô mandaluk pusip yi esopa yêni be elam nena, “Devit Lim Lêkmuk, lem iŋgik ong ethak yêi!” ");
INSERT INTO ymp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yisu hêyô melak kapô te be hê me anô yi atu ê hêndêng yêni. Me henang ik thêi ling nena, “Mamu ôêv iving nena hîtôm yambong be mamu umbutak mavî mesa mî?” Me thêi nang nena, “Bôvê, Anômbêng. Yêi êv iving.” ");
INSERT INTO ymp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Êng me yêni hetak bang hêyô hêk thêi maleŋiŋdaluk me henang nena, “Tem nimbutak bêng vômbê nena mamu ôêv iving ya.” ");
INSERT INTO ymp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Êng me maleŋiŋdaluk hipuak. Me Yisu hêv ambô lêklokwang hêndêng thêi nena, “Dô mamu nang ethak anô te thak nôm itiêng andô.” ");
INSERT INTO ymp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Metom thêi ê me enang nôm atu be Yisu hevong ethak thêi bêng heveng long êng sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Anô yi êng etak Yisu be ê denang me avîlanô iwa anô ambôlêk putup te be gôk kambom bôk hivuling yêni be êlêm êyô vo Yisu. ");
INSERT INTO ymp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Me hêv gôk kambom êng vê be ôpêng henang ambô. Be ditu avîlanô esong kambom me leŋing mavî be enang nena, “Sêmbôk me mî thak nômate bêng hivutak Islael amî.” ");
INSERT INTO ymp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Metom Palisi enang nena, “Gôk kambom ining anômbêng hêv lêklokwang hêndêng ôpêng, be ditu hîtôm nêŋgêv gôk kambom sapêng vê injêk avîlanô.” ");
INSERT INTO ymp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Me Yisu heveng melak lông lêk long yaônena sapêng be hivutak êyô ining melak yeng be hîndông avîlanô lêk henang Ambô Mavî hethak Wapômbêng ya lêkliŋyak bêng. Me hepesang avîlanô ning malêing sapêng lêk hêv ining kômbôk lomaloma sapêng vê. ");
INSERT INTO ymp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yisu hêyê avîlanô nômbêng atu be lahiki hethak loho, vômbê nena loho ning auk hîmô mayaliv be anô te mî hîmô vo nêŋgêv loho livung hîtôm boksipsip ining alang amî. ");
INSERT INTO ymp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yôv me henang ethak ya ŋa hîndông nena, “Nôm bêng anông lêk hîyôk be hîmô kukapô, metom ŋa ku me nayi yom. ");
INSERT INTO ymp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Be ditu oteng mek êndêng kukapô alang vo nêŋgêv ŋa ku doho bini vo ithup nôm.” ");
INSERT INTO ymp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yisu helam ya ŋa hîndông lauming be lahavôyi hêlêm êndêng yêni. Me hêv lêklokwang hêndêng loho vo êŋgêv gôk lêlêik vê injêk avîlanô me embong avîlanô kômbôk lêk malêing lomaloma imbutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Diti me aposol lauming be lahavôyi takatu ining athêng. Anô mung me Saimon, ya athêng yang nena Pita, yêni yang molok me Endulu me Jems loyang Jon, thêi me Sebedi namalô luvi; ");
INSERT INTO ymp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","me Pilip lo Batolomiu me Tomas lo Matyu anô sêmbôk be hiwa takis me Jems Alpius nakandung lo Tadius ");
INSERT INTO ymp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon atu be elam nena anô Selot te, me Judas Iskaliot, ôpatu yôv ketem netak Yisu îndôk ŋakyo baheŋing. ");
INSERT INTO ymp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisu hêv anô lauming be lahavôyi be ê me henang nena, “Dô môlô nu ŋa Samalia lêk ŋa long bôyang ining long andô. ");
INSERT INTO ymp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Me môlô nu êndêng Islael ining boksipsip takatu be eveng mayaliv. ");
INSERT INTO ymp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Môlô nu luvuluvu be onang bêng êndêng avîlanô nena, ‘Wapômbêng ya lêkliŋyak bêng lêk bidong.’ ");
INSERT INTO ymp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Me ombong avîlanô lêk kômbôk mavî me uŋgik ŋa ema ling me ombong ŋa kômbôk lepla imbutak mavî me ôŋgêv gôk kambom vê injêk avîlanô. Athêng bêng êng me mî môlô êv vuli amî me ya hêv oyang hêndêng môlô. Be ditu môlômbong ku takêng oyang bêng yom me dô umbua vuli ethak andô. ");
INSERT INTO ymp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“Môlô ô hîtôm ŋa ku be mavî vo avîlanô eyaŋging môlô me dô umbua nômate andô. Be ditu dô ombek vak mena umbua valuseleng mena umbua kwêv yi mena veŋiŋkapô bokgôp mena kwanding andô. ");
INSERT INTO ymp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Me môlô yô melak lông lêk long alêla takatu, êng me othalo anô kombom mavî te me môlô mô imbing inda endebe otak long êng be môlô nu bôyang. ");
INSERT INTO ymp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wakma môlôvong vo ômbô thak melak êng me ôŋgêv mek mavî êndêng ôpêng lêk ya avîlanô. ");
INSERT INTO ymp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Avîlanô melak êng leŋing mavî be iwa môlô thô, êng me môlô ning mek mavî êng tem nîmô imbing loho. Metom mî leŋing mavî be iwa môlô thô amî, êng me umbua mek mavî êng vê injêk loho bunu. ");
INSERT INTO ymp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Me long takatu be avîlanô mî iwa môlô thô amî lêk êndô endaŋô môlô ning ambô, êng me wakma otak long êng me uŋgik pîk limbalôm takatu be hîmô vemimkapô vê îndôk loho maleŋing me môlô nu. ");
INSERT INTO ymp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya hanang avanông ethak môlô nena waklavông Wapômbêng îthô avîlanô pîk lelalîlîng, êng me avîlanô long atu be mî iwa môlô thô amî, loho ning malêing tem nîmbô ethak vo avîlanô kambom nang Sodom lo Gomola ning malêing. ");
INSERT INTO ymp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ondaŋô! Ya hêv môlô be ô hîtôm boksipsip îmô avung yatap lîvông. Be ditu môlô yaŋging am katô hîtôm bôyîv thak evong lêk ômô mavî me osopa menak bôbô ining kombom be dô ombong kambom andô. ");
INSERT INTO ymp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Me môlô yaŋging am vo avîlanô! Loho tem embalong môlô be etak îndôk ining ŋa bêŋbêng baheŋing lêk tem embali môlô îndôk ining melak yeng. ");
INSERT INTO ymp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tem endom môlô bini êndêng king lêk gakmang bêŋbêng, vômbê nena môlô sopa ya. Hethak loŋdaŋlê êng me tem onang yînîng Ambô Mavî bêng êndêng loho lêk ŋa long bôyang imbing. ");
INSERT INTO ymp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Metom wakma evalong môlô be etak îlôk ŋakyo baheŋing me dô lemim iŋgik am nena tem onang ambô alê mena tem onang bisê andô. Vômbê nena hêndêng wakma êng me Wapômbêng tem nêŋgêv ambô êndêng môlô be onang. ");
INSERT INTO ymp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Me ambô te tem mî nêlêm nang môlô da ning auk amî, metom môlô ning Kamik ya Lovak Matheng tem nêŋgêv ambô atu be tem onang êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Me anô loyang yi tem yang enang yang bêng vo iŋgik vônô. Me lami tem embong bêng êndêng ining nali. Me nali tem ende dômîng lîlîng êndêng lami lo talôvi be enang vo iŋgik loho vônô. ");
INSERT INTO ymp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Avîlanô sapêng tem kapôlôŋing êndô môlô vômbê nena môlô me yînîng avîlanô. Metom ŋa takatu be eva lêklokwang hele be hêyô yandang, êng me Wapômbêng tem nimbua loho vê injêk kambom ya vuli. ");
INSERT INTO ymp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Me wakma avîlanô melak lông te êv vovang hêndêng môlô, êng me môlô sôv bunu melak lông yang. Ya hanang avanông ethak môlô nena tem môlômbong ku êng embeng Islael denang me Anô Ya Nakandung tem nendelêm. ");
INSERT INTO ymp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Sêik kapua mî îmô viling vo ining kîdôŋga amî. Me ŋa ku mî îmô viling vo ining avaka amî. ");
INSERT INTO ymp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Avîlanô thak elam melak alang nena, ‘Belsebul,’ bêng be tem embong bêng ethak yêni ya avîlanô bêng yom. Sêik kapua iwa ining kîdôŋga ning malêing, êng me mavî. Me ŋa ku iwa ining avaka ya malêing, êng me mavî yom. ");
INSERT INTO ymp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Be ditu dô môlô kô ŋa takatu be evong kombom kambom takêng andô. Nôm takatu be hivuŋi hêk long kapô tem nimbutak yêing. Me ambô takatu be hivuŋi hêk kapô tem avîlanô sapêng eyala. ");
INSERT INTO ymp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bêng be ambô takatu be ya hanang ethak môlô hêndêng bîlîvông, êng me onang êndêng lêkwak. Me ambô takatu be ya hanang thîkôthîk hîlôk môlô liŋdong, êng me othak omba melak vôv be ondam bêng vo avîlanô endaŋô. ");
INSERT INTO ymp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dô ôkô avîlanô andô. Loho hîtôm iŋgik lemvim kôpik yom vônô, metom dôhôlômim me loho mî hîtôm iŋgik vônô amî. Be ditu môlô kô Wapômbêng yom! Yêni yom hîtôm nimbuling avîlanô leŋving kôpik lêk dôhôlôŋing îndôk long atu be amela hethang îmô. ");
INSERT INTO ymp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Menak yaônena me thak avîlanô êv vuli hethak valuseleng kalalang tom. Metom môlô ning Kamik thak heyala menak yaônena takatu be te hema. ");
INSERT INTO ymp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wapômbêng heyala môlô bêng yom be bôk hiwa môlô lumim kwandôk ŋaung sapêng thô yôv. ");
INSERT INTO ymp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Be ditu môlô me bêng hîvô hethak vo menak be dô môlô kô andô. ");
INSERT INTO ymp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Bêng be opalê atu be henang ethak avîlanô nena yêni me yînîng, tem ya nang emba Wakamik atu be hîmô melak leng mandaluk nena, ‘Ôpêng me yînîng.’ ");
INSERT INTO ymp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Metom ôpatu be henang ethak avîlanô nena hîthông ya paling, tem ya nang ethak Wakamik atu be hîmô melak leng nena, ‘Ya hathông ôpêng paling’ bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Dô môlô song nena ya halêm pîk vo yambong môlô lemim mavî lêk lemim tom andô! Mî ya halêm vo yambong ku êng amî metom ya hauwa ambîng vovak be ya halêm. ");
INSERT INTO ymp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ya halêm vo “ ‘namalô ende dôm lîlîng êndêng lambô me nalavî ende dôm lîlîng êndêng talêmbô me namalô yanavî ende dôm lîlîng êndêng yaŋavî. ");
INSERT INTO ymp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Anô te da ya lêkma anông tem nimbutak ya ŋakyo.’ ");
INSERT INTO ymp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Me opalê atu be la hiving lambô lo talêmbô bêng anông hîvô hethak vo ya, ôpêng mî hîtôm nîmô imbing ya amî. Me opalê atu be la hiving namalô lo nalavî bêng anông hîvô hethak vo ya, ôpêng mî hîtôm nîmô imbing ya amî. ");
INSERT INTO ymp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Me opalê atu be mî hiwa ya alovalasing be hesopa ya amî, ôpêng mî hîtôm nîmô imbing ya amî. ");
INSERT INTO ymp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Opalê atu be hevong vo nembalong ya lêkmala long, êng me ya lêkmala tem nêŋgêv yak. Me opalê atu be hetak ya lêkmala vo hesopa ya, ôpêng tem nembalong ya lêkmala long. ");
INSERT INTO ymp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Me ôpatu be hiwa môlô thô, êng me hiwa ya thô hiving. Me ôpatu be hiwa ya thô, êng me hiwa ôpatu be hêv ya be ya halêm thô hiving. ");
INSERT INTO ymp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Me ôpatu be hêyê plopet te be hiwa thô, êng me tem nimbua vuli mavî îtôm thak plopet êng hiwa. Me ôpatu be hêyê anô thêthôp te be hiwa thô, êng me tem nimbua vuli mavî îtôm thak anô thêthôp êng hiwa. ");
INSERT INTO ymp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Me ôpatu be hêyê anô athêng mî te atu be hesopa ya hîtôm yînîng anô ya handông te be hêv nôma yaôna te hîtôm ŋanam thilimbung keyek te hêndêng ôpêng, êng me ya hanang avanông bing ethak môlô nena ôpêng tem nimbua ya vuli mavî.” ");
INSERT INTO ymp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yisu hêv ambô hêndêng ya ŋa hîndông lauming be lahavôyi yôv me hetak long êng me hê henang mêtê lêk hîndông avîlanô heveng melak lông takatu be hîmô Galili. ");
INSERT INTO ymp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon hîmô kalaondong me helaŋô ambô hethak ku takatu be Mesaya hevong. Êng me hêv ya ŋa hîndông doho be ê hêndêng yêni ");
INSERT INTO ymp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","vo enang iŋgik yêni ling nena, “Ong Mesaya atu be Wapômbêng bôk hevak ambô vo nêŋgêv êlêm mesa yoô yambing anô yaŋda?” ");
INSERT INTO ymp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Êng me Yisu henang viyang nena, “Môlômbunu me onang êndêng Jon ethak nôm takatu be lêk olaŋô lo ôyê. ");
INSERT INTO ymp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ŋa maleŋing pusip êyê tak, me ŋa veŋing kambom eveng, me ŋa kômbôk lepla ivutak mavî, me ŋa liŋdong putup elaŋô ambô, me ŋa ema iviyô hethak loŋbô, me avîlanô siv elaŋô Wapômbêng ya Ambô Mavî. ");
INSERT INTO ymp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Me mavî vo ŋa takatu be êv iving ya me mî kapôlôŋing yi amî.” ");
INSERT INTO ymp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon ya ŋa hîndông îvôê denang me Yisu henang ambô hethak Jon hêndêng avîlanô nena, “Bôk be môlô ô long thiliv vo ôyê ômbête? Môlô ô vo ôyê lovak hiyuv beselak mesa? Mî anông. ");
INSERT INTO ymp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Me môlô ô vo ôyê ômbête? Betha ô vo ôyê anô te hik kwêv kêkêlô lomaloma mesa? Mî. Ŋa takatu be ik kwêv kêkêlô me thak îmô king ining melak yom. ");
INSERT INTO ymp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Môlô ô long thiliv vo ôyê ômbête? Plopet te mesa? Avanông! Metom ya hanang ethak môlô nena Jon me bêng vo plopet sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bôk ekavu hethak ôpêng hêk kapua matheng nena, “ ‘Nondaŋô. Tem yaŋgêv yînîng anô ku te vo nenang yînîng ambô bêng imung vo ong me tem nepesang loŋdaŋlê vo ong.’ ");
INSERT INTO ymp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ya hanang avanông bing ethak môlô nena Jon me bêng vo avîlanô pîk sapêng. Metom ôpatu be yaônalêk hêk melak leng ya lêkliŋyak bêng, ôpêng me bêng vo Jon. ");
INSERT INTO ymp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Me hêndêng wakma Jon hivutak hele be hêyô lêk me ŋa kambom thak evong vovak be êv malêing hêndêng melak leng ya lêkliŋyak bêng be evong vo imbua. ");
INSERT INTO ymp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“Me plopet sapêng lêk kapua balambung bôk enang Wapômbêng ya ambô bêng hêlêm hele be hêyô wakma Jon hivutak. ");
INSERT INTO ymp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Me môlô lemim iving vo ondaŋô plopet ining ambô, yôv be ondaŋô! Kapua matheng henang nena Elaija tem nêlêm. Elaija êng me Jon yom. ");
INSERT INTO ymp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bêng be môlô ŋa lêk liŋdong me ondaŋô ambô ti katôyang! ");
INSERT INTO ymp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Tem ya nang ambô dôhô alê ethak avîlanô bôlô tiêng? Loho me hîtôm sêiknena takatu be îmô long ethak tom hîlôk me elam hê vo sêiknena vi nena, ");
INSERT INTO ymp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Yoômbî yeng beleng vo môlôndô yeng metom môlô mî olo yeng amî. Me yoô leng athêng malêng vo môlôndeng metom mî môlô leng amî.’ ");
INSERT INTO ymp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Bêng yom me Jon hêlêm me mî thak ninjang nôm bêng anông lêk ninum waing amî. Me avîlanô îpôlîk ethak yêni be enang nena gôk kambom hîmô hiving yêni. ");
INSERT INTO ymp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Metom Anô Ya Nakandung hêlêm me heyang nôm lêk hinum waing. Me avîlanô îpôlîk be enang nena, ‘Ôŋgô! Ôpiti êng me thak heyang nôm lêk hinum waing bêng anông. Yêni me ŋa iwa takis lêk ŋa evong kombom kambom ining anô môlôô.’ Metom ôpatu be hiwa Wapômbêng ya auk thêthôp me ya ku tem niŋgik thô nena auk êng me thêthôp anông.” ");
INSERT INTO ymp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yisu bôk hevong nôm thamtham bêng anông yôv hîmô melak lông doho, metom avîlanô takêng mî ele kapôlôŋing lîlîng amî. Be ditu Yisu hethang loho be henang nena, ");
INSERT INTO ymp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Alitaknena, môlô avîlanô Kolasin lo Betsaida! Bôk môlô yê nôm thamtham lomaloma. Metom betha bôk yambong nôm thamtham takêng îmô Taia lo Saidon lîvông, êng me tem bôk ende kapôlôŋing lîlîng yôv be iyum thôp leŋing malêing lêk ethav amela kambôk ethak luŋiŋkwandôk vo niŋgik thô nena leŋing malêing ethak ining kambom taksêmbôk be evong. ");
INSERT INTO ymp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ondaŋô! Ya hanang avanông bing ethak môlô nena waklavông Wapômbêng îthô avîlanô pîk lelalîlîng, êng me môlô ning malêing me tem bêng anông be nîmbô thak vo avîlanô Taia lo Saidon ining! ");
INSERT INTO ymp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Me môlô avîlanô Kapenaom, tem êŋgêv môlô ning athêng ling ethak leng mesa? Mî anông. Tem môlô nu ŋa ema ining long! Bôk môlô yê nôm thamtham lomaloma takatu be ya havong îmô môlô lîvông. Me betha bôk yambong bêng îmô Sodom lîvông, êng me tem etak ining kambom takêng me Sodom tem nîmô denang endebe nêyô lêk. ");
INSERT INTO ymp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ondaŋô! Ya hanang avanông bing nena waklavông Wapômbêng îthô avîlanô pîk lelalîlîng, êng me môlô ning malêing me tem bêng anông be nîmbô ethak vo avîlanô Sodom ining!” ");
INSERT INTO ymp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yôv me Yisu henang nena, “Wakamik, Ong me pîk lo leng ya alang! Lêk huvung yong auk hethak ŋa auk bêng me huik thô hethak ŋa takatu be îtôm sêiknena. Be ditu ya hêv yong athêng ling! ");
INSERT INTO ymp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wakamik, avanông ong da hosopa yong lem hiving be ditu hovong bêng. ");
INSERT INTO ymp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Wakamik bôk hêv nômkama sapêng êndêng ya yôv be anô te mî heyala Namalô amî. Mî, Wakamik yom. Me anô te mî heyala Wakamik katô amî. Mî, Nalum lêk ŋa takatu be Namalô la hiving niŋgik thô êndêng loho yom. ");
INSERT INTO ymp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Me môlô ŋa takatu be ovong ku lêk vovang be uwa malêing bêng, ôlêm êndêng ya me tem yaŋgêv lovak êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Môlô umbua auk injêk ya vo ondovak yînîng ambô, hîtôm môlô uwa aseleng atu be thak etak îlôk bokmaŋkao lôk vo êvôv nômkama. Môlô umbua auk injêk ya, vômbê nena thak ya havong kombom mayaô hêndêng avîlanô be ya hataving ya da. Vo nômkama dô hêv malêing êndêng môlô andô vo tem umbua lêkmala ");
INSERT INTO ymp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","vômbê nena yînîng aseleng atu be ya hêv me vumeng vo umbua. Me vak atu be ya hêv vo ômbô me mî malêing amî.” ");
INSERT INTO ymp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hêndêng Sabat te me Yisu lêk ya ŋa hîndông ê eveng kukapô te. Me ya ŋa hîndông ema vo leŋing be iwa wit doho heveng kukapô êng be eyang. ");
INSERT INTO ymp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Metom Palisi doho êyê me enang nena, “Nôŋgô! Yong ŋa hôndông evong kombom iti me mî thêthôp vo embong êndêng Sabat amî!” ");
INSERT INTO ymp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Me Yisu henang loho ning ambô viyang nena, “Betha bôk mî môlô sam ambô hethak Devit lêk ya ŋa môlôô ema vo leŋing be evong bêng yom mesa mî? ");
INSERT INTO ymp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yêni hivutak êyô Wapômbêng ya melak sel kapô be hiwa polom atu be mî hîtôm ŋa paling injang amî be yêni lêk ya ŋa môlôô eyang. Polom êng me ŋa îmbôk da yom ining vo injang. ");
INSERT INTO ymp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yôv be lemim êŋgêv balambung yang imbing. Hêndêng Sabat sapêng me ŋa îmbôk da thak evong ku hîmô melak Matheng kapô. Be ditu loho thak ivuling balambung bô êng be evong ku hêndêng Sabat, metom loho mî evong kambom amî. Be bôk môlô osam ambô êng hêk balambung mesa mî? ");
INSERT INTO ymp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Metom ya hanang ethak môlô nena nômate hîmô long iti me bêng vo melak matheng. ");
INSERT INTO ymp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Hêk kapua matheng me Wapômbêng henang nena, “ ‘Ya leng hiving môlôŋgêv kapôlômim êndêng avîlanô me ya handô môlôŋgêv da yom êndêng ya.’ “Me betha bôk oyala ambô êng ya ondong ma, êng me mî hîtôm onang nena ŋa takatu be kambom mî tem imbua kambom ya vuli amî. ");
INSERT INTO ymp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ya hanang bêŋiti êng vômbê nena Anô Ya Nakandung me Sabat ya Alang.” ");
INSERT INTO ymp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yôv me Yisu hetak kukapô êng me hivutak êyô avîlanô long êng ining melak yeng kapô. ");
INSERT INTO ymp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Me anô te hîmô long êng be bang bôk hema yôv. Me ŋa Palisi doho ethalo loŋdaŋlê vo enang Yisu bêng, be ditu enang ik yêni ling nena, “Thêthôp vo aômbong ŋa lêk kômbôk mavî êndêng Sabat mesa mî?” ");
INSERT INTO ymp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Me Yisu henang nena, “Anô te ya boksipsip hêv yak hîlôk lovang hêndêng Sabat me ôpêng teni vo nendandi boksipsip êng imbutak yêing mesa mî? ");
INSERT INTO ymp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Anô me bêng vo boksipsip, be ditu kapua balambung henang nena aômbong anô mavî êndêng Sabat.” ");
INSERT INTO ymp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yôv me Yisu henang ethak ôpêng nena, “Noto bahem.” Me heto bang vi kambom atu, êng me lêk hivutak mavî hethak loŋbô hîtôm bang vi mavî. ");
INSERT INTO ymp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Êng me Palisi iviyô be ê ethak tom me ekak ambô vo ethalo loŋdaŋlê te vo iŋgik Yisu vônô. ");
INSERT INTO ymp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Metom Yisu heyala nôm êng, be ditu hetak long êng be hê. Êng me avîlanô bêng anông esopa yêni be hevong loho ning kômbôk lomaloma sapêng mavî. ");
INSERT INTO ymp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Me Yisu henang lêklokwang ethak loho nena, “Dô onang ya bêng ethak anô te andô.” ");
INSERT INTO ymp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yisu henang bêng vo niŋgik anông hîtôm plopet Aisaia bôk henang nena, ");
INSERT INTO ymp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ondaŋô. Ôpiti me yînîng anô ku atu be bôk ya hatôk yêni yôv. Ôpatu be ya leng hiving yêni bêng anông me ya kapôlông mavî hethak inda. Be tem yaŋgêv yînîng Lovak Matheng vo nîmô imbing inda vo nenang kombom thêthôp bêng êndêng avîlanô pîk sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Me mî hîtôm la maning mayaliv mena nendam kaêk lêkwaê amî. Me yêni mî hîtôm nenang ambô lêkwaê be avîlanô eveng loŋdaŋlê endaŋô amî. ");
INSERT INTO ymp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Me tem mî hîtôm nekav beselak atu be hipu hêk li amî lêk mî hîtôm nîmbî amelandang atu be hevong ema ni amî. Me tem nembong mavî yom endebe netak kambom sapêng îmô ku mavî vimbing êm. ");
INSERT INTO ymp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Me avîlanô pîk sapêng tem êŋgêv imbing yêni be etak maleŋing vo nêŋgêv loho livung.” ");
INSERT INTO ymp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hêndêng wakma êng me anô doho iwa anô te be gôk kambom hîmô hiving inda be êlêm êyô vo Yisu. Gôk kambom êng hevong be ôpêng mandaluk pusip me ambôlêk putup. Me Yisu hevong be ôpêng mandaluk hipuak be hêyê tak me ambôlêk heyakê be henang ambô. ");
INSERT INTO ymp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Me avîlanô sapêng esong kambom be enang nena, “Betha diti me Mesaya, Devit Lim Lêkmuk mesa?” ");
INSERT INTO ymp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Metom Palisi elaŋô ambô êng be enang nena, “Belsebul, gôk kambom ining anômbêng hêv lêklokwang hêndêng yêni. Be ditu hîtôm nêŋgêv gôk kambom sapêng vê injêk avîlanô.” ");
INSERT INTO ymp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yisu heyala loho ning auk be henang nena, “Melak lông bêng te da ya avîlanô evak i kê hê ondong yi be evong vovak, êng me melak lông bêng êng tem nêŋgêv yak. Me melak kapô te da hevak i kê hê ondong yi be evong vovak, êng me tem mî nemba lêklokwang amî. Bêng yom me ondong te hevak i kê hê ondong yi be evong vovak, êng me tem mî nemba lêklokwang amî. ");
INSERT INTO ymp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Me Sakdang da hêv Sakdang vê hêk ya melak, êng me hîtôm hevak i kê hê ondong yi. Bêng be ya lêkliŋyak bêng tem nemba lêklokwang bisête? Mî anông. ");
INSERT INTO ymp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Môlô nang nena Belsebul hêv lêklokwang hêndêng ya be ya hêv gôk kambom vê. Metom môlô ning avîlanô thak evong ku êng hiving! Be ditu opalête hêv lêklokwang hêndêng loho be evong ku mavî takêng? Belsebul mesa opalê? Ôŋgô! Môlô da ning avîlanô ik thô nena môlô nang ambô yôhîng. ");
INSERT INTO ymp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Metom Wapômbêng ya Lovak Matheng hêv lêklokwang hêndêng ya be ya hêv gôk kambom vê hêk avîlanô. Be ditu oyala nena Wapômbêng ya lêkliŋyak bêng lêk hîmô môlô lîvông yôv. ");
INSERT INTO ymp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ondaŋô ambô yang imbing. Anô te hîtôm nimbutak êyô anô lêklokwang te ya melak kapô be nimbua ya nômkama vanî mesa? Mî anông! Ôpêng embalong anô lêklokwang êng be nekak lêku êm, êng me yêni hîtôm nimbua ya nômkama vanî. ");
INSERT INTO ymp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ôpatu be mî la hiving ya amî, ôpêng me yînîng ŋakyo. Me ôpatu be mî hêv ya livung vo nithup avîlanô ethak tom amî, êng me hindining loho be ê mayaliv. ");
INSERT INTO ymp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Bêng be ya hanang ethak môlô nena Wapômbêng tem nêŋgêv avîlanô ning kambom sapêng lêk ambôma takatu be enang hethak Wapômbêng vê. Metom anô te hêyê Lovak Matheng ya ku be henang ambôma nena, ‘Diti me Sakdang ya ku,’ êng me Wapômbêng mî hîtôm nêŋgêv kambom êng vê injêk ôpêng amî me mî anông. ");
INSERT INTO ymp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Me anô te henang ambô kambom hethak Anô Ya Nakandung, êng me Wapômbêng tem nêŋgêv ôpêng ya kambom vê. Metom anô te henang ambô kambom hethak Lovak Matheng, êng me Wapômbêng tem mî nêŋgêv ôpêng ya kambom êng vê amî me tem ninjêk bêng thêthô. ");
INSERT INTO ymp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Alokwang mavî me tem niŋgik anông mavî. Me alokwang kambom me tem niŋgik anông kambom bêng yom. Be ditu thak anô yê ya anông me eyala nena alokwang mavî mena alokwang kambom ma. ");
INSERT INTO ymp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Môlô me bôyîv kambom nali be kapôlômim hêyô thing hethak nôm kambom lomaloma atu be hivutak viemim. Be ditu mî onang ambô mavî amî! ");
INSERT INTO ymp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ŋa mavî me ining auk mavî lomaloma bêng anông hîmô kapôlôŋing be thak enang ambô mavî yom hele vieŋing. Me ŋa kambom me loho ning auk kambom lomaloma bêng anông hîmô kapôlôŋing, be ditu thak enang ambô kambom yom hele vieŋing. ");
INSERT INTO ymp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ondaŋô! Ya hanang ethak môlô nena hêndêng waklavông Wapômbêng îthô avîlanô pîk lelalîlîng me anô tomtom tem enang ining kambom takatu be bôk enang ethak avîlanô vi lêk ivuling loho bêng. ");
INSERT INTO ymp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Hethak môlô da ning ambô yom me tem Wapômbêng enang ethak môlô nena môlô ŋa mavî mena môlô ŋa kambom ma.” ");
INSERT INTO ymp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Êng me Palisi lêk kîdôŋga ambô balambung doho enang ethak Yisu nena, “Kîdôŋga, yoô leŋing iving nombong nôm thamtham te îtôm lavuning vo niŋgik thô nena hôlêm nang Wapômbêng.” ");
INSERT INTO ymp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","40","Êng me Yisu henang nena, “Môlô avîlanô bôlô tiêng me avîlanô kambom anông be thak mî osopa Wapômbêng amî. Be ditu lemim iving yambong lavuning te vo niŋgik thô nena Wapômbêng hêv ya be ya halêm, metom tem mî. Wak lô me Plopet Jona heva alim ŋanam te la kapô. Me wak lô bêng yom me tem Anô Ya Nakandung ninjêk pîk kapô. ");
INSERT INTO ymp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Hêndêng waklavông Wapômbêng îthô avîlanô pîk lelalîlîng me avîlanô Ninive tem enang môlô ning kambom bêng, vômbê nena avîlanô Ninive elaŋô Jona ya ambô be ele kapôlôŋing lîlîng. Ondaŋô! Anô te hîmô long iti môlô lîvông me yêni bêng hîvô hethak vo Jona. ");
INSERT INTO ymp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Me sêmbôk be Siba ning avî king hêlêm nang pik ya dang vo helaŋô Solomon ya auk mavî. Metom anô te lêk hîmô long iti môlô lîvông me yêni bêng hîvô hethak vo Solomon be môlôndô ondaŋô ya ambô. Bêng be waklavông Wapômbêng îthô avîlanô pîk lelalîlîng hêyô me Siba ning avî king êng tem nenang môlô ning kambom thak mî olaŋô ambô amî bêng.” ");
INSERT INTO ymp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Wakma gôk lêlêik hetak anô te me hê heveng long thiliv vo nethalo long mavî te vo nimbua lovak îmô. Metom mî hêpôm long te amî, ");
INSERT INTO ymp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","êng me tem nenang nena, ‘Yandena melak sêmbôk atu ethak loŋbô.’ Me hêyô be hêyê nena melak êng lêk hîmô oyang me epesang be lêk hivutak mambung anông. ");
INSERT INTO ymp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Êng me teni vo nethalo gôk bahevi be lahavôyi takatu be ining lêklokwang bêng anông hîvô hethak vo yêni ya be nimbua loho imbing vo imbutak êyô melak êng kapô ethak loŋbô. Êng me ôpêng tem nîmô kambom anông vo bôlôyang sêmbôk. Bêng be môlô avîlanô kambom bôlô tiêng tem ôpôm malêing êng imbing.” ");
INSERT INTO ymp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yisu henang ambô hiving avîlanô denang me talêmbô lo viyaŋi leŋing iving enang ambô imbing yêni, be ditu loho lêm eleva melak vi yêing. ");
INSERT INTO ymp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Me anô te hê henang ethak Yisu nena, “Lemtambô lêk aviyami eva yêing be loho leŋing iving enang ambô imbing ong.” ");
INSERT INTO ymp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Me Yisu henang hêndêng ôpêng nena, “Opalê me yînîng wakatik lêk aiyang loho?” ");
INSERT INTO ymp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","50","Me hîmbî bang hêndêng ya ŋa hîndông me henang nena, “Avîlanô takatu be esopa Wakamik atu be hîmô melak leng ya la hiving yom, ditu yînîng katik lêk aiyang me lîvô loho. Be ditu môlô takiti me yînîng katik lêk aiyang loho.” ");
INSERT INTO ymp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wak êng yom me Yisu hetak melak atu be hê hêyô kasîk bomang ya dang me hîlôk hîmô. ");
INSERT INTO ymp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Me avîlanô bêng anông ekalambu yêni thing, be ditu hethak yeng te be hîmô me avîlanô eva liŋdang hivup ethak. ");
INSERT INTO ymp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Me hîndông avîlanô hethak ambô dôhô bêng anông. Be henang nena, “Ondaŋô. Anô te hê me hekaliv ya yaŋvêk hîlôk ya kukapô. ");
INSERT INTO ymp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Hekaliv yaŋvêk takêng me doho hîlôk loŋdaŋlê be menak êpôm be eyang. ");
INSERT INTO ymp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Me doho hîlôk pîk lêk valu be ditu hivutak ketheng, vômbê nena pîk doke yom. ");
INSERT INTO ymp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Me wakma wak hîmbî hêyô hêk me hekapôk, vômbê nena ya galôk bidong be hêyô hîmô viling oyang. ");
INSERT INTO ymp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Me vi hîlôk yak lêklilu kapô be yak êng hilumbak hêyô yaŋvêk takêng vôv. ");
INSERT INTO ymp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Metom vi hîlôk pîk mavî be hik anông hîtôm 100 me doho 60 me doho 30. ");
INSERT INTO ymp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Be ditu môlô ŋa lêk liŋdong me ondaŋô ambô ti katôyang!” ");
INSERT INTO ymp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yisu ya ŋa hîndông êyô vo yêni me enang ik yêni ling nena, “Hevong bisê be thak honang ambô dôhô yom hêndêng avîlanô?” ");
INSERT INTO ymp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Me Yisu henang viyang nena, “Wapômbêng lêk hik ya auk long kapô thô hethak ya lêkliŋyak bêng hêndêng môlô. Me mî hik thô hêndêng loho amî. ");
INSERT INTO ymp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bêng be anô te heyala auk long kapô êng me tem Wapômbêng êŋgêv auk bêng anông êyômô imbing. Metom anô te mî heyala auk long kapô êng amî me tem nêŋgêv ya auk takatu be hîmô hiving inda vê. ");
INSERT INTO ymp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hethak ondong êng yom me ya hanang ambô dôhô hêndêng loho, vômbê nena “Loho yê, metom mî êyê katô amî. Loholaŋô, metom mî elaŋô katô be eyala ya ondong amî. ");
INSERT INTO ymp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Avanông bing, plopet Aisaia bôk henang me lêk hik anông hivutak loho nena, “ ‘Avîlanô ning auk bôk thekthek be îmbî i liŋdong thing me ivuliv i maleŋing thing. Wak nômbêng iti me tem endaŋô ambô, metom mî hîtôm eyala ya ondong amî. Me wak nômbêng iti me tem injê lômbôlông, metom mî hîtôm êpôm ya ondong amî. Tem injê ethak maleŋing lêk endaŋô îndôk i liŋdong me imbua injêk ining auk be ende i lîlîng vo yambong loho imbutak mavî.’ ");
INSERT INTO ymp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Metom mavî vo môlô maleŋing, vômbê nena êyê tak. Me mavî vo môlô liŋdoŋing, vômbê nena elaŋô ambô. ");
INSERT INTO ymp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ondaŋô! Ya hanang avanông ethak môlô. Sêmbôk me plopet lêk ŋa thêthôp bêng anông leŋing hiki vo injê nôm iti be lêk môlô yê, metom mî êyê amî. Me leŋiŋhiki vo endaŋô ambô takiti be lêk môlô laŋô, metom mî elaŋô amî.” ");
INSERT INTO ymp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ondaŋô tem ya nang ambô dôhô atu be hethak ekaliv yaŋvêk hîlôk kukapô ya ondong bêng êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Anô te helaŋô ambô hethak Wapômbêng ya lêkliŋyak bêng metom mî heyala ya ondong amî, ôpêng me hîtôm yaŋvêk atu be hêv yak hîlôk loŋdaŋlê. Yôv me Sakdang thak hêyô be hiwa yaŋvêk atu be Wapômbêng hevatho hîlôk yêni kapô vê. ");
INSERT INTO ymp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Me ôpatu be helaŋô ambô êng be hêv iving bôlôtom lêk la mavî, ôpêng me hîtôm yaŋvêk atu be hêv yak hîlôk pîk lêk valu, ");
INSERT INTO ymp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","metom Wapômbêng ya ambô mî hik galôk hîlôk yêni kapô amî be ditu wakma malêing lêk vovang bêng hêyô be hêpôm yêni hethak Wapômbêng ya ambô, êng me hetak ya hêv iving ketheng oyang. ");
INSERT INTO ymp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Anô te helaŋô Wapômbêng ya ambô metom lahiki bêng anông hethak ya lêkmala pîk iti lêk nômkama lomaloma lêk valuseleng evatek yêni, be auk takêng hithivung Wapômbêng ya ambô be ôpêng mî hik anông amî. Yêni me hîtôm yaŋvêk atu be hîlôk yak lêklilu kapô. ");
INSERT INTO ymp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Me anô te helaŋô Wapômbêng ya ambô be heyala ya ondong, êng me tem nembong ku be niŋgik anông mavî îtôm 100 mena 60 mena 30 ma. Yêni me hîtôm yaŋvêk atu be hîlôk pîk mavî.” ");
INSERT INTO ymp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisu henang ambô dôhô yang nena, “Melak leng ya lêkliŋyak bêng me bêŋiti. Anô te hevatho yaŋvêk mavî hîlôk ya kukapô. ");
INSERT INTO ymp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Metom hêndêng bîlîvông be avîlanô êkthôm me ôpêng ya ŋakyo te hêlêm me hevatho kamung kambom hîlôk kukapô êng hiving yôv me hê. ");
INSERT INTO ymp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yôvêm me yaŋvêk êng hipup hivutak be hik anông me kamung kambom atu hivutak hiving. ");
INSERT INTO ymp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Me ŋa eyaŋging kukapô êng ê hêndêng kukapô alang me enang ethak yêni nena, ‘Anômbêng, sêmbôk nang hovatho yaŋvêk mavî yom hîlôk yong kukapô. Metom hevong bisê be lêk kamung kambom hivutak hiving?’ ");
INSERT INTO ymp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Êng me henang ethak loho nena, ‘Ŋakyo te hevong nôm êng.’ “Êng me ya ŋa ku enang ik yêni ling nena, ‘Lem iving yoô na vo asapu kamung kambom takêng êng vê mesa dô?’ ");
INSERT INTO ymp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Metom kukapô alang henang nena, ‘Dô. Endekeme osapu nôm vê imbing kamung kambom. ");
INSERT INTO ymp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Môlôndô luvi indumbak îmô endebe wakma imbua nôm ya anông êm. Êng me tem ya nang ethak ŋa ku takatu be tem imbua nôm ya anông nena, “Môlô thup kamung kambom sapêng be okak lêku be otak îmô long îmbôk ethak amela. Me uthup nôm ya anông be otak îmô melak nôm hîmô.”’” ");
INSERT INTO ymp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yisu henang ambô dôhô te hethak loŋbô hêndêng loho nena, “Melak leng ya lêkliŋyak bêng me bêŋiti. Anô te hiwa alokwang va yaôna te be hevatho hîlôk ya kukapô. ");
INSERT INTO ymp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Me alokwang va êng me yaônalêk vo yaŋvêk sapêng, metom hilumbak hê lêkwaê anông vo nômkama kukapô vi be hivutak hîtôm alokwang bêng te. Be menak thak êlêm be elav ining unak hîlôk ya thaŋang sapêng.” ");
INSERT INTO ymp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yisu henang ambô dôhô yang hethak loŋbô hêndêng loho nena, “Melak leng ya lêkliŋyak bêng me bêŋiti. Avî te hiwa yis doke be hetak îlôk thiling bêng anông kapô me hekakô hele be thiling sapêng hithing bêng.” ");
INSERT INTO ymp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ambô takiti be Yisu henang ethak avîlanô me henang ethak ambô dôhô yom. Me wak nômbêng iti be thak henang ambô hêndêng avîlanô me thak henang ethak ambô dôhô yom ");
INSERT INTO ymp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","vo niŋgik anông hîtôm plopet bôk henang nena, “Tem ya nang ambô dôhô bêng anông êndêng môlô. Me tem ya nang auk takatu be hîmô long kapô êndêng sêmbôk be yaha pesang pîk iti hele be hêyô lêk iti bêng.” ");
INSERT INTO ymp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yôv me Yisu hetak avîlanô be ê me hê melak kapô. Me ya ŋa hîndông ê hêndêng yêni me enang nena, “Nonang ambô dôhô atu be hethak kamung kambom hivutak kukapô ya ondong bêng vo yoô andaŋô.” ");
INSERT INTO ymp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Êng me henang nena, “Ôpatu be hevatho yaŋvêk mavî me Anô Ya Nakandung. ");
INSERT INTO ymp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Me kukapô me pîk itiêng. Me yaŋvêk mavî me Wapômbêng ya lêkliŋyak bêng ya avîlanô. Me kamung kambom me anô kambom ya avîlanô. ");
INSERT INTO ymp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ŋakyo atu be hevatho yaŋvêk kambom me Sakdang. Me ŋa ku me aŋêla melak leng. Me wakma imbua nôm ya anông me pîk lo leng yandang. ");
INSERT INTO ymp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Wakma esapu kamung kambom be îmbôk ethak amela me pîk lo leng yandang. ");
INSERT INTO ymp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Me Anô Ya Nakandung da tem nêŋgêv ya aŋêla bini ya lêkliŋyak bêng kapô vo esapu nôm takatu be ivuling avîlanô ining êv iving lêk avîlanô takatu be evong kombom kambom sapêng vê. ");
INSERT INTO ymp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Me aŋêla tem ekaliv loho îndôk amela diŋang bêng. Long êng me loho tem endeng kambom be ethang vieŋing ondong long. ");
INSERT INTO ymp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","“Metom avîlanô thêthôp tem imbutak îtôm wak ya danda be îmô loho ning Kamik ya lêkliŋyak bêng kapô. Bêng be môlô ŋa lêk liŋdong me ondaŋô ambô ti katôyang!” ");
INSERT INTO ymp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yisu henang ambô dôhô te nena, “Melak leng ya lêkliŋyak bêng me hîtôm kukapô te be ivung nôm mavî te hîmô. Be anô te hêpôm nôm mavî êng me hivung ethak loŋbô. Me yêni la mavî be hêv ya nômkama sapêng vo anô êv vuli. Me hiwa valuseleng be hê hêv êndêng kukapô atu ya alang vo nimbua kukapô êng.” ");
INSERT INTO ymp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yisu henang ambô dôhô yang nena, “Melak leng ya lêkliŋyak bêng me hîtôm anô lêk valuseleng bêng te hethalo kômkôm kêkêlô vo nêŋgêv vuli. ");
INSERT INTO ymp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hethalo hele be hêpôm kômkôm kêkêlô anông te be ya vuli me bêng anông. Êng me hê me hêv ya nômkama sapêng vo êv vuli. Me hiwa valuseleng be hê me hêv vuli kômkôm kêkêlô êng ethak.” ");
INSERT INTO ymp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yisu henang ambô dôhô te hethak loŋbô nena, “Melak leng ya lêkliŋyak bêng me hîtôm ekaliv lek hîlôk kasîk bomang be êvôv alim ŋanam lomaloma. ");
INSERT INTO ymp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wakma lek hêyô thing me êvôv ê hethak liŋdang me îlôk îmô be ithup alim ya mavî hîlôk vak tham doho me îmbî alim ya kambom hê. ");
INSERT INTO ymp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Be ditu wakma pîk lo leng yandang me Wapômbêng tem nembong bêng yom. Be ya aŋêla tem êlêm vo imbua ŋa kambom vê injêk ŋa thêthôp lîvông ");
INSERT INTO ymp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","be îmbî îndôk amela. Long êng me loho tem endeng kambom be ethang vieŋing ondong long.” ");
INSERT INTO ymp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Me Yisu henang ik ya ŋa hîndông ling nena, “Lêk môlôyala ambô sapêng ya ondong yôv mesa mî?” Me loho nang nena, “Bôvê.” ");
INSERT INTO ymp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Êng me henang ethak loho nena, “Anô lêk auk hethak Wapômbêng ya ambô te heyala melak leng ya lêkliŋyak bêng ya ondong katôyang, ôpêng me hîtôm melak te ya alang. Yêni hê ya melak kapô me hiwa nôm lêkmuk mavî lêk ya bôô hiving be hêv êndêng avîlanô.” ");
INSERT INTO ymp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yisu henang ambô dôhô takêng yôv me hetak long êng be hê ");
INSERT INTO ymp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ya melak ondong. Me hîndông avîlanô hîmô ining melak yeng hele be loho song kambom be enang nena, “Ôpiti hiwa auk iti nang êsê? Bisête be yêni hîtôm nembong nôm thamtham? ");
INSERT INTO ymp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ôpiti me anô helav melak nakandung be talêmbô me Malia. Be viyaŋi me Jems lo Josep me Saimon lo Judas. ");
INSERT INTO ymp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Me livi îmô long iti hiving aô. Me bisête be ôpiti hîtôm nembong nôm takiti êng?” ");
INSERT INTO ymp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Loho nang bêng me îpôlîk ethak yêni. Metom Yisu henang ethak loho nena, “Plopet thak hiwa athêng bêng hêk melak yang. Metom ya melak ondong lêk ya lêkma me hîtôm anô athêng mî te.” ");
INSERT INTO ymp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hele be mî hevong nôm thamtham bêng anông hêk long êng amî vômbê nena loho mî êv iving yêni amî. ");
INSERT INTO ymp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hêndêng wakma êng me king Helot Antipas helaŋô ambô hethak nôm takatu be Yisu hevong. ");
INSERT INTO ymp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Êng me henang ethak ya ŋa ku nena, “Ôpêng me Jon Anô Hithik Avîlanô yom ditu hiviyô hethak loŋbô. Be ditu hiwa lêklokwang be hevong nôm thamtham takêng.” ");
INSERT INTO ymp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Sêmbôk me Helot hiwa yang Pilip yanavî Helodias. Be Jon henang ethak Helot nena, “Lêk huwa avî ti be ditu mî hosopa kombom thêthôp amî.” Êng me Helot hêv ya ŋa vovak ê me evalong Jon be ekak yêni be etak îlôk kalaondong. ");
INSERT INTO ymp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Avîlanô leŋing êv nena Jon me plopet te. Be ditu Helot hevong vo niŋgik Jon vônô metom hêkô avîlanô. ");
INSERT INTO ymp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anô doho êlêm eyang nôm hiving Helot vo leŋing êv ya waklavông talêmbô hevathu yêni. Me Helodias nalavî hêlêm hêyô be heloyeng heva loho lîvông. Me Helot hêyê be la mavî anông. ");
INSERT INTO ymp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Êng me Helot hevak ambô manjeng hiving inda nena, “Ya hanang avanông bing dake nena honang ik ya ling hethak nômate vo yaŋgêv êndêng ong, êng me tem yaŋgêv yom.” ");
INSERT INTO ymp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Me talêmbô hêv auk êndêng nalavî vo nenang nena, “Ya leng hiving Jon Anô Hithik Avîlanô kwandôk îndôk belev te be nôŋgêv êndêng ya!” ");
INSERT INTO ymp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Me king helaŋô ambô êng be la malêing. Metom la hêv ambô atu be lêk hevak hîlôk ŋa bêŋbêng maleŋing yôv, be ditu henang ethak ya ŋa vovak be ê kalaondong me endambêng Jon lôkbudum kisi. ");
INSERT INTO ymp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Me loho tak Jon kwandôk hîlôk belev te be iwa hêlêm êv êndêng avî voyavô atu. Me yêni hiwa be hê hêv êndêng talêmbô. ");
INSERT INTO ymp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yôv me Jon ya ŋa hîndông elaŋô me êlêm iwa liŋkôpik be ê elav. Loho lav yôv me ê enang ethak Yisu. ");
INSERT INTO ymp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yisu helaŋô ambô êng yôv me hetak long êng me hethak yeng te be hê long thiliv bôte. Me avîlanô bêng anông elaŋô nena yêni lêk ya ŋa hîndông yom lêk hê, be ditu etak ining melak lông me eveng yêni yam be ê. ");
INSERT INTO ymp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yisu hethak liŋdang me hêyê avîlanô bêng anông lêk îmô yôv. Be ditu lahiki hethak loho be hevong loho ning ŋa lêk kômbôk mavî. ");
INSERT INTO ymp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lêk yathiŋdang yôv be ditu ya ŋa hîndông êlêm enang ethak yêni nena, “Aômô long thiliv be ditu notak avîlanô takiti vo ini melak lông takatu be hîmô bidong vo êŋgêv ining nôm vuli.” ");
INSERT INTO ymp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Metom Yisu henang nena, “Mî! Loho mô. Me môlô da tem ombakông loho.” ");
INSERT INTO ymp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Me loho nang êndêng yêni nena, “Yoô nôm mî, metom polom bahevi lêk alim ŋanam yi yom ti be hîmô.” ");
INSERT INTO ymp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Êng me Yisu henang nena, “Umbua lêm ve ya.” ");
INSERT INTO ymp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Me henang ethak avîlanô nena, “Ôndôk ômô kwang takiti.” Me hiwa polom bahevi lêk alim yi atu be hêyê leng me henang la mavî hêndêng Wapômbêng. Yôv me hekav polom lêk alim be hêv êndêng ya ŋa hîndông me iwa be ik tham hêndêng avîlanô nômbêng atu. ");
INSERT INTO ymp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Me avîlanô sapêng eyang be leŋviŋyak. Me ya ŋa hîndông ithup nôm wata vi atu be hîmô denang hîlôk vak tham lauming be lahavôyi. ");
INSERT INTO ymp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Anô yom ditu hîtôm 5,000 me avî lo sêik takatu be eyang nôm êng hiving me mî iwa loho thô hiving amî. ");
INSERT INTO ymp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yôv me Yisu henang ethak ya ŋa hîndông vo ethak yeng ketheng be imung bini kasîk bomang viyang vulu me yêni da hîmô vo nêŋgêv avîlanô bini êm. ");
INSERT INTO ymp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hêv avîlanô be ê yôv me hethak dum te be hê vo neteng mek. Bîlîvông hêyô me yêni hîmô dum êng denang. ");
INSERT INTO ymp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Me yeng atu lêk hîmô kasîk lîvông me lovak hiyuv be hîmô yeng long hele hê, be ditu ŋanam budum hik be yeng êng hele lelalîlîng kambom anông. ");
INSERT INTO ymp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bidong oyang tem neyang wakbêng me Yisu heveng kasîk viling be hê êndêng ya ŋa hîndông. ");
INSERT INTO ymp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Me ya ŋa hîndông êyê yêni heveng kasîk viling me êkô kambom be enang nena, “Anô te dôhô!” me îpîndîk kambom be eleng. ");
INSERT INTO ymp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Metom henang ambô ketheng oyang hethak loho be henang nena, “Dô môlô kô andô me ômô mayaô! Ya da diti!” ");
INSERT INTO ymp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Êng me Pita henang nena, “Anômbêng, avanông ong da ditu, yôv be nonang vo yambeng kasîk viling be ya thôk êndêng ong.” ");
INSERT INTO ymp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Me Yisu henang nena, “Nôlêm.” Êng me Pita hetak yeng me heveng kasîk bomang viling be hê hêndêng Yisu. ");
INSERT INTO ymp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Metom hêyê lovak hiyuv lêklokwang be hêkô kambom. Êng me hêv yak hîlôk kasîk kapô be helam nena, “Anômbêng! Nôŋgêv ya livung!” ");
INSERT INTO ymp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ketheng oyang me Yisu hetak bang hê me hevalong inda. Me henang ethak yêni nena, “Yong hôêv iving me yaônalêk. Hevong bisê be kapôlôm yi?” ");
INSERT INTO ymp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yôv me thêi thak ivutak îlôk îmô yeng me lovak bêng êng hema. ");
INSERT INTO ymp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Êng me ŋa takatu be îmô yeng eya veŋiŋbudum thîvô me ikum be êv yeng ethak yêni be enang nena, “Avanông bing! Ong me Wapômbêng Nakandung.” ");
INSERT INTO ymp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yôv me loho ê ele be ethak viyang vulu liŋdang nang Genesalet. ");
INSERT INTO ymp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Me avîlanô long êng êyê Yisu be eyala yêni. Be ditu êv ambô heveng melak lông bêng êng sapêng. Me iwa ning ŋa lêk kômbôk sapêng be ê vo Yisu. ");
INSERT INTO ymp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Me eteng Yisu lêk kapôlôŋing malêing vo ŋa lêk kômbôk êthôm ya kwêv dang yom. Me ŋa takatu be êthôm sapêng me ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Palisi lêk kîdôŋga ambô balambung doho êlêm nang Jelusalem be ê êyô vo Yisu me enang ik yêni ling nena, ");
INSERT INTO ymp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bumalô loho ning ambô manjeng henang vo aômbôkîng baheŋing mambung yôv kîmîng aôŋgang nôm. Me bisête be yong ŋa hôndông ivuling ambô êng be mî îvôkîng baheŋing amî?” ");
INSERT INTO ymp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Êng me Yisu henang nena, “Bisête be môlô vuling Wapômbêng ya ambô balambung be osopa môlô da ning ambô manjeng? ");
INSERT INTO ymp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Hîtôm Wapômbêng bôk henang nena, ‘Nondovak lemambô lo lemtambô’ me ‘Ôpatu be hethang lambô lo talêmbô hethak ambô athek, êng me iŋgik ôpêng vônô.’ ");
INSERT INTO ymp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Metom thak môlôndông avîlanô nena anô te henang ethak lambô mena talêmbô ma nena, ‘Yînîng nômkama takatu be hîmô vo yaŋgêv mamu livung ethak, êng me bôk ya hanang yôv nena tem yaŋgêv êndêng Wapômbêng îtôm da,’ ");
INSERT INTO ymp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","êng me môlô va long thing vo dô ôpêng êŋgêv lambô mena talêmbô ma livung andô. Be ditu hik thô nena môlôvong Wapômbêng ya ambô hivutak hîtôm nôm oyang me osopa limbumi da ning bôk le long yom. ");
INSERT INTO ymp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Môlô ŋa ovatek avîlanô! Thak môlôvong bêng be avîlanô esong nena môlô ŋa mavî. Metom plopet Aisaia ya ambô sêmbôk be henang ethak môlô me avanông nena, ");
INSERT INTO ymp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Avîlanô takiti thak êv yînîng athêng ling ethak vieŋing yom, metom kapôlôŋing me hêk dêimbô vo ya. ");
INSERT INTO ymp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Loho êv yeng oyang ethak ya me thak enang loho da ning ambô manjeng yom be evatek nena, “Diti me Wapômbêng ya ambô.”’” ");
INSERT INTO ymp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Me Yisu helam avîlanô nômbêng atu êlêm ethak tom me henang nena, “Môlôndaŋô yînîng ambô ti be oyala katôyang. ");
INSERT INTO ymp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nôm takatu be thak avîlanô eyang hîlôk vieŋing me mî thak nembong be lohombutak lêlêik amî. Metom nôm takatu be avîlanô enang ele vieŋing yom, ditu hevong be loho ivutak lêlêik.” ");
INSERT INTO ymp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yôvêm me Yisu ya ŋa hîndông êlêm enang ethak yêni nena, “Nondaŋô. Palisi elaŋô yong ambô ti be loho leŋing maning kambom hethak ong.” ");
INSERT INTO ymp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Me Yisu henang viyang nena, “Wakamik atu be hîmô melak leng tem nesapu nôm takatu be mî yêni hevatho hîlôk ya kukapô amî lêk galôk vê. ");
INSERT INTO ymp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Be dô môlôndaŋô ŋa takêng ining ambô be osopa andô. Loho me hîtôm ŋa maleŋing pusip be evong vo endom avîlanô embeng loŋdaŋlê. Me anô mandaluk pusip yang helom anô mandaluk pusip yang heveng loŋdaŋlê, êng me tem luvi êŋgêv yak îndôk lovang.” ");
INSERT INTO ymp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Êng me Pita henang ethak Yisu nena, “Nuŋgik ambô dôhô êng ya ondong thô êndêng yoô.” ");
INSERT INTO ymp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Me Yisu henang ethak loho nena, “Hevong bisê be môlô thông hiving denang? ");
INSERT INTO ymp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Betha mî oyala amî nena nôm takatu be hîlôk anô vieŋing be hê heva leŋiŋthoham yôv me thak hele yêing be hê. ");
INSERT INTO ymp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Metom nôm takatu be hele vieŋing me hêlêm nang anô kapôlôŋing be hevong loho vutak lêlêik. ");
INSERT INTO ymp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nôm takatu be thak hîmô anô kapôlôŋing be hele yêing me auk kambom lêk ik anô vônô lêk evong sek iving anô lêk avî mena avî lêk anô lêk avîlanô muk evong sek mayaliv hiving i lêk vanî lêk enang ambô yôhîng hethak anô yang lêk enang ambô kambom hethak anô vi. ");
INSERT INTO ymp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kambom takiti ditu tem nembong be avîlanô imbutak lêlêik. Be ditu oyala nena anô te mî hîvôkîng bang be heyang nôm amî me ôpêng mî hivutak lêlêik amî.” ");
INSERT INTO ymp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yisu hetak long êng be hê hîmô melak lông Taia lo Saidon ining pîk. ");
INSERT INTO ymp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Me avî Kenan te hîmô long êng be hêlêm be helam lêklokwang lômbôlông nena, “Anômbêng! Devit Lim Lêkmuk! Nôŋgêv kapôlôm vo ya! Gôk kambom te hîmô hiving yînîng avena be hivuling inda kambom anông.” ");
INSERT INTO ymp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Metom Yisu mî henang avî êng ya ambô viyang amî. Êng me ya ŋa hîndông êlêm me enang ethak inda nena, “Avî ti helam kaêk heveng aô yam bôsaha! Be nonang vo ni!” ");
INSERT INTO ymp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Êng me henang nena, “Wapômbêng hêv ya be ya halêm vo avîlanô Islael takatu be eveng mayaliv hîtôm boksipsip yom.” ");
INSERT INTO ymp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Me avî atu hêlêm me heya vabudum thîvô be henang nena, “Anômbêng, nôŋgêv ya livung!” ");
INSERT INTO ymp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Me henang ethak avî êng nena, “Kambom vo êŋgêv sêiknena ning nôm êndêng avung.” ");
INSERT INTO ymp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Me avî êng henang nena, “Anômbêng, aliêng me avanông bing. Metom avung thak eyang limi ning nôm pômôp takatu be hêv yak hîlôk ining balê vimbing.” ");
INSERT INTO ymp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Me Yisu henang nena, “Avî, yong hôêv iving me bêng anông, be ditu nôm atu be lem hiving me lêk huwa yôv.” Me avî êng nalavî hivutak mavî hethak loŋbô hêndêng wakma êng yom. ");
INSERT INTO ymp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Me Yisu hetak long êng me hivup ethak kasîk bomang nang Galili ya dang. Hîvô me hethak dum te be hê hîmô. ");
INSERT INTO ymp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Me avîlanô bêng anông êlêm vo yêni me iwa ŋa veŋing kambom, lêk ŋa maleŋing pusip, lêk ŋa veŋing lo baheŋing lêkgwak, lêk ŋa vieŋing putup, lêk ŋa kômbôk lomaloma be êlêm êndô hêk Yisu va. Me hevong loho ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Me avîlanô êyê ŋa vieŋing putup enang ambô, lêk ŋa veŋing lo baheŋing lêkgwak ivutak mavî, me ŋa veŋing kambom eveng, lêk ŋa maleŋing pusip êyê tak. Loho yê nôm takêng be esong kambom be êv avîlanô Islael ining Wapômbêng ya athêng ling. ");
INSERT INTO ymp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisu helam ya ŋa hîndông êlêm me henang ethak loho nena, “Ya leng ik ya hethak avîlanô nômbêng iti. Loho bôk îmô hiving ya hîtôm wak lô be ining nôm lêk mî. Be ditu ya handô yaŋgêv loho bini lêk leŋing oyang, vômbê nena tem maleŋing endeyang be êŋgêv yak îndôk loŋdaŋlê.” ");
INSERT INTO ymp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Me ya ŋa hîndông enang nena, “Avîlanô bêng anông me aômô long thiliv, be yôv keme aômbua nôm nang êsê be aômbakông loho?” ");
INSERT INTO ymp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Me Yisu henang ik loho ling nena, “Môlô ning polom vithêla tu be hîmô?” Êng me enang nena, “Polom bahevi be lahavôyi lêk alim ŋanam yaônena doho.” ");
INSERT INTO ymp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Me Yisu henang ethak avîlanô nômbêng atu nena îndôk îmô. ");
INSERT INTO ymp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Êng me hiwa polom bahevi be lahavôyi atu lêk alim takatu be henang la mavî hêndêng Wapômbêng. Yôv me hekav polom lêk alim be hêv êndêng ya ŋa hîndông me loho iwa be ik tham hêndêng avîlanô. ");
INSERT INTO ymp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sapêng eyang be leŋiŋviŋyak me ya ŋa hîndông ithup nôm wata hîlôk vak tham bahevi be lahavôyi. ");
INSERT INTO ymp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Anô yom hîtôm 4,000 me avî lo sêik takatu be eyang nôm êng hiving me mî iwa loho thô hiving amî. ");
INSERT INTO ymp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yôv me Yisu hêv avîlanô be ê me hethak yeng be hê Magadan. ");
INSERT INTO ymp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Palisi lêk Sadyusi doho êlêm êndêng Yisu vo embatek yêni. Be ditu loho nang ethak inda nena, “Nombong lavuning te vo niŋgik thô nena Wapômbêng hêv ong be hôlêm.” ");
INSERT INTO ymp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Metom henang loho ning ambô viyang nena, “Hêndêng yathiŋdang me thak môlô nang nena, ‘Leŋlokwang hethethaleng be wak mavî tem nêyô.’ ");
INSERT INTO ymp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Me hêndêng lêkbôk dang me thak môlô nang nena, ‘Wak hîmbî vônô be tem ôthîng êyô.’ Môlôyala leŋlokwang ya lavuning katôyang. Metom lavuning lomaloma takatu be lêk hivutak môlô lîvông ya ondong me môlô thông paling denang. ");
INSERT INTO ymp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Môlô avîlanô bôlôti me avîlanô kambom be ôêv dômîm lîlîng êndêng ya. Me môlô lemim iving yambong lavuning vo niŋgik thô nena Wapômbêng bôk hêv ya be ya halêm, metom tem mî. Tem môlôŋgô Jona ya lavuning yom.” Yôv me Yisu hetak loho be hê. ");
INSERT INTO ymp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yisu lêk ya ŋa hîndông êyô kasîk bomang viyang vulu. Metom ya ŋa hîndông leŋing êv polom thing be mî iwa amî. ");
INSERT INTO ymp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Êng me henang ethak loho nena, “Oyaŋging am ethak Palisi lo Sadyusi ning yis.” ");
INSERT INTO ymp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Me loho nang ethak i nena, “Betha mî aô auwa polom amî ma be ditu henang ambô ti.” ");
INSERT INTO ymp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Metom heyala loho ning ambô atu be enang, êng me henang nena, “Môlô ning ôêv iving me yaônalêk. Be môlô nang ethak mî uwa polom amî vo? ");
INSERT INTO ymp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Môlô thông paling denang mesa? Mî lemim êv polom bahevi atu be avîlanô 5,000 bôk eyang amî e? Me vak tham vithêla ditu bôk uthup nôm wata hîlôk? ");
INSERT INTO ymp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Me polom bahevi be lahavôyi atu be avîlanô hîtôm 4,000 eyang, lêk vak tham vithêla ditu bôk uthup nôm wata hîlôk? ");
INSERT INTO ymp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“Môlô thông yînîng auk denang be osong nena ya hanang ambô hethak polom e? Oyaŋging am ethak Palisi lêk Sadyusi ining yis!” ");
INSERT INTO ymp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Êng me mîng ya ŋa hîndông eyala ya auk nena henang vo loho eyaŋging i ethak Palisi lêk Sadyusi takatu be îndông avîlanô hethak auk lêkgwak. Me mî henang ethak yis etak hîlôk polom amî. ");
INSERT INTO ymp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yisu hivutak êyô Sisalia Pilipai me henang ik ya ŋa hîndông ling nena, “Avîlanô ning auk bisête? Anô Ya Nakandung me opalête?” ");
INSERT INTO ymp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Me loho nang nena, “Doho nang bêŋiti nena ong me Jon Anô Hithik Avîlanô. Me doho nang nena ong me Elaija. Me doho nang nena ong me Jelemaia mena plopet bôô te ma.” ");
INSERT INTO ymp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yôv me henang ik loho ling nena, “Metom môlô da olam ya nena opalête?” ");
INSERT INTO ymp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Êng me Saimon Pita henang nena, “Ong Mesaya, Wapômbêng lêkmala Nakandung.” ");
INSERT INTO ymp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Me Yisu henang viyang nena, “Saimon, Jona nakandung, lem mavî vômbê nena anô pîk iti te mî hik auk êng thô hêndêng ong amî. Me Wakamik atu be hîmô melak leng, yêni da diti hik auk iti thô hethak ong. ");
INSERT INTO ymp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Me ya hanang êndêng ong Pita nena tem ya tak ong îtôm valu ondong anông vo yandav yînîng avîlanô ondong atu be êv iving ya êyômô valu êng. Be ŋama ya lêklokwang mî hîtôm nimbuling loho amî. ");
INSERT INTO ymp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tem yaŋgêv melak leng ya lêkliŋyak bêng ya iyam melak ambôlêk êndêng ong. Be nôm takatu be hopatôk hîmô pîk me tem Wapômbêng epatôk injêk melak leng bêng yom. Me nôm takatu be hopole hêk pîk me tem Wapômbêng epole vê injêk melak leng bêng yom.” ");
INSERT INTO ymp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Me henang lêklokwang ethak ya ŋa hîndông nena dô enang ethak anô te nena yêni me Mesaya andô. ");
INSERT INTO ymp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hêndêng wakma atu be Pita henang nena Yisu me Mesaya me Yisu hîndông ya ŋa hîndông hethak ambô lêkmuk te nena yêni tem nesopa Wapômbêng ya la hiving be ni Jelusalem. Me avaka lêk ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung tem êŋgêv vovang êndêng yêni. Yôvêm me tem iŋgik yêni vônô me wak ali lô me tem nimbiyô ethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Êng me Pita hiwa yêni hê dêim doke me hethang inda be henang nena, “Anômbêng, mî anông! Nôm êng mî hîtôm nêpôm ong amî! Me mî anông.” ");
INSERT INTO ymp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yisu hik i lîlîng me henang ethak Pita nena, “Sakdang, numba ya dôm! Hosopa anô ning auk yom me mî hosopa Wapômbêng ya auk amî. Be hovong vo nomba ya thing.” ");
INSERT INTO ymp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yôv me Yisu henang ethak ya ŋa hîndông nena, “Anô te hevong vo nesopa ya, êng me nende dôm lîlîng êndêng ya lêkmala pîk me nimbua ya alovalasing be nesopa ya. ");
INSERT INTO ymp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Vômbê nena ôpatu be la hêv ya lêkmala pîk bêng anông, êng me ya lêkmala êng tem nêŋgêv yak. Metom ôpatu be hetak ya lêkmala be hesopa ya, ôpêng tem nimbua lêkmala anông. ");
INSERT INTO ymp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Anô te hiwa nômkama pîk sapêng, metom mî hesopa Wapômbêng ya ambô amî be ya lêkmala hêv yak me ya nôm takêng tem nêŋgêv yêni livung bisê? Me anô te hîtôm nêŋgêv nômate êndêng Wapômbêng vo nimbua ya lêkmala ethak loŋbô mesa? Mî anông! ");
INSERT INTO ymp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Anô Ya Nakandung tem nêlêm imbing Lambô ya danda lêkmaŋging lêk ya aŋêla. Me tem nêŋgêv vuli mavî lêk vuli kambom êndêng avîlanô tomtom îtôm loho ning ku takatu be bôk evong. ");
INSERT INTO ymp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ya hanang avanông ethak môlô nena Anô Ya Nakandung tem nêlêm imbing ya lêkliŋyak bêng. Me môlô vi atu be lêk ova long iti tem ômô lêkmala denang me ôŋgô nôm êng imbing.” ");
INSERT INTO ymp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wak bahevi be lahavôtom hele be hê yôv me Yisu helom Pita hiving ŋa loyang yi Jems lo Jon be loho thak dum dêim bêng te atu be anô mî be loho ê îmô. ");
INSERT INTO ymp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Êng me Yisu liŋkôpik hivutak yaŋda heva loho maleŋing. Be thohav lo ma hivutak lêŋlêng hîtôm wak me ya kwêv sapêng hivutak thapuk hîtôm danda. ");
INSERT INTO ymp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hêndêng wakma naêng yom me Moses lo Elaija êyô be enang ambô hiving Yisu be loho yê. ");
INSERT INTO ymp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Êng me Pita henang ethak Yisu nena, “Anômbêng, mavî anông vo lêk aômô long iti. Lem hiving me tem yandav melak lêkkôpik lokwaŋlô, te vo ong me te vo Moses me te vo Elaija.” ");
INSERT INTO ymp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita henang ambô denang me mavông thapuk anông te hêyô be heva loho thing. Me ambô te hêlêm nang mavông êng kapô nena, “Ôpiti me yînîng Wakna atu be ya leng hiving anông. Me ya leng mavî anông hethak yêni. Be ditu môlôndaŋô ya ambô!” ");
INSERT INTO ymp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yisu ya ŋa hîndông elaŋô ambô êng me êkô be elowaling kambom be îlôk êk be maleŋing hele hê pîk. ");
INSERT INTO ymp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Metom Yisu hêlêm bidong me hêthôm loho be henang nena, “Môlômbiyô. Dô môlô kô andô.” ");
INSERT INTO ymp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Êng me loho êv maleŋing ling me êyê nena Yisu yom lêk heva. Me anô yi atu lêk mî. ");
INSERT INTO ymp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Yôv me loho tak dum êng be îlôk ele ê denang me Yisu henang lêklokwang ethak loho nena, “Dô môlô nang nôm atu be lêk ôyê bêng ethak anô te andô endebe Wapômbêng iŋgik Anô Ya Nakandung ling imbiyô injêk ŋama ethak loŋbô êm.” ");
INSERT INTO ymp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yisu ya ŋa hîndông enang ik yêni ling nena, “Bisête be kîdôŋga ambô balambung enang nena Elaija tem nimung be nêlêm yôv kîmîng Mesaya?” ");
INSERT INTO ymp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Êng me Yisu henang nena, “Avanông! Elaija tem nêlêm be nembong ku vo nômkama sapêng imbutak mavî ethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Metom ya hanang ethak môlô nena Elaija bôk hêlêm yôv. Me avîlanô îthông yêni paling be esopa ining leŋing iving yom be evong kambom lomaloma hêndêng yêni. Be tem êŋgêv vovang êndêng Anô Ya Nakandung bêng yom.” ");
INSERT INTO ymp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yôv me ya ŋa hîndông elaŋô ambô êng be eyala nena Yisu henang vo Jon Anô Hithik Avîlanô. ");
INSERT INTO ymp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yisu loho ê êyô me êyê avîlanô bêng anông lêk îmô. Me anô te hêlêm hêyô vo Yisu me heya vabudum thîvô hîmô yêni mandaluk ");
INSERT INTO ymp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","me henang nena, “Anômbêng, lem iŋgik ong ethak yînîng wakna, vômbê nena thak hiwa kômbôk hemayak be thak hêv yak hîlôk ŋanam lêk amela. Be thak hiwa vovang bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Be ya hauwa ha vo yong ŋa hôndông, metom loho mî hîtôm embong yêni mavî amî.” ");
INSERT INTO ymp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Me Yisu henang nena, “Môlô me avîlanô kambom be mî ôêv iving amî! Wak vithê tem ya mô imbing môlô be yambua môlô ning malêing? Umbua wakna êng êlêm.” ");
INSERT INTO ymp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Me hesok gôk kambom êng vôkê be hetak wakna êng me ketheng oyang me hivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yôv me Yisu ya ŋa hîndông yom ê vo inda me enang nena, “Bisête be yoô mî hîtôm aŋgêv gôk kambom êng vê amî?” ");
INSERT INTO ymp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Tomêng me Yisu henang viyang nena, “Vômbê nena môlô ning ôêv hiving me yaônalêk, be ditu môlô mî hîtôm amî. Ya hanang avanông ethak môlô nena betha môlô ning ôêv hiving yaônalêk hîtôm vôkva yaôna te, êng me hîtôm onang ethak dum te nena, ‘Numbiyô be numba bôyang’, êng me tem nesopa môlô ning ambô yom. Me nômate mî hîtôm malêing vo môlômbong amî.” ");
INSERT INTO ymp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yisu lêk ya ŋa hîndông sapêng ethak tom hîlôk Galili me henang ethak loho nena, “Tem enang Anô Ya Nakandung bêng be etak îndôk avîlanô baheŋing. ");
INSERT INTO ymp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Be tem iŋgik yêni vônô me wak ali lô me tem nimbiyô ethak loŋbô.” Ya ŋa hîndông elaŋô ambô êng be leŋing malêing bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yisu lêk ya ŋa hîndông ê êyô Kapenaom me ŋa iwa takis melak matheng êlêm me enang ik Pita ling nena, “Môlô ning kîdôŋga thak hêv takis melak matheng hiving mesa mî?” ");
INSERT INTO ymp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Me Pita henang nena, “Bôvê. Yêni thak hêv.” Yôv me Pita hivutak êyô melak kapô me Yisu henang ik yêni ling himung nena, “Saimon, lem hêv bisê? King pîk sapêng thak iwa ning takis nang opalê? Loho da ning nali mesa avîlanô vi?” ");
INSERT INTO ymp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Me henang nena, “Iwa nang avîlanô vi.” Êng me Yisu henang nena, “Avanông. Nali me mî thak êv takis êng hiving amî. ");
INSERT INTO ymp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Metom ya handô aômbong be loho leŋing ŋaŋa andô. Be ditu nu kasîk bomang me nokaliv yaklôm be alim mung atu be hôvôv, êng me numbua be nombalala ambôlêk me tem nôŋgô valuseleng te heva kapô. Me numbua valuseleng êng be nôŋgêv êndêng loho îtôm ai ning takis melak matheng.” ");
INSERT INTO ymp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wakma êng me Yisu ya ŋa hîndông ê vo inda me enang ik yêni ling nena, “Opalête tem nimbutak anô lêk athêng bêng îmô melak leng ya lêkliŋyak bêng kapô?” ");
INSERT INTO ymp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Me Yisu helam sêik nate hêlêm me hetak eva loho lîvông ");
INSERT INTO ymp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","me henang ethak loho nena, “Ya hanang avanông ethak môlô nena mî môlô le ning auk lîlîng be uvutak îtôm sêik nati amî, êng me môlô mî hîtôm umbutak ôyô melak leng ya lêkliŋyak bêng kapô bunu amî. Mî anông. ");
INSERT INTO ymp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Be ditu anô te hetaving i hele be yaônalêk hîtôm sêik nati, êng me tem nimbutak anô lêk athêng bêng îmô melak leng ya lêkliŋyak bêng kapô. ");
INSERT INTO ymp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Me ôpatu be hiwa sêik nate bêŋiti thô hethak yînîng athêng me hîtôm hiwa ya da thô. ");
INSERT INTO ymp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Metom anô te hevong be yînîng sêik atu be hêv iving ya te hêv yak, êng me mavî vo êthôkêng valu malêing bêng te ethak ôpêng lôkbudum be ekaliv îndôk mamik kolong kapô vo nema. ");
INSERT INTO ymp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Alitaknena môlô avîlanô pîk iti! Nômkama pîk bêng anông thak hevong be môlô ning ôêv iving hêv yak. Nôm takêng tem nimbutak, metom alitakna vo ôpatu be hevong be avîlanô ning êv iving êv yak. Ôpêng tem nitung malêing bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Bahem vi mena vem vima hevong be hovong kambom, êng me nondambêng vi êng kisi be nokaliv ini vo dô nombong kambom ethak loŋbô andô! Bahem lo vem vi yom me malêing bêng, metom mavî vo numbua lêkmala atu be tem nîmô îtôm wak nômbêng iti sapêng. Vômbê nena bahem lo vem luvi hîmô be hovong kambom, êng me tem ekaliv lemvim kôpik sapêng îndôk long atu be amela lêkmala hethang hîmô hîtôm wak nômbêng iti sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Me malemdaluk vi hevong be hovong kambom, êng me nômbî vi êng thô be nokaliv ini vo dô nombong kambom ethak loŋbô andô! Malemdaluk vi yom me malêing bêng, metom mavî vo numbua lêkmala atu be tem nîmô îtôm wak nômbêng iti sapêng. Vômbê nena malemdaluk luvi hîmô be hovong kambom, êng me tem ekaliv lemvim kôpik sapêng îndôk long amela lêkmala hethang hîmô hîtôm wak nômbêng iti sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Bêng be môlô yaŋging am! Dô môlô song nena sêiknena takiti me nôm oyang andô, vômbê nena loho ning aŋêla thak êyê nôm takatu be thak môlôvong hêndêng loho me iwa ê me enang ethak Wakamik hîmô melak leng. ");
INSERT INTO ymp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Anô te ya boksipsip hîtôm 100 îmô dum te be te heveng bidoho. Êng me lem hêv nena boksipsip alang tem nembong ômbête? Tem netak 99 takatu be îmô dum êng me ni vo nethalo ali atu be lêk heveng bidoho. ");
INSERT INTO ymp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ya hanang avanông ethak môlô nena hêpôm aliêng me tem la mavî bêng anông îmbô thak vo 99 takatu be îmô. ");
INSERT INTO ymp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bêng yom me môlô ning Kamik hîmô melak leng hêndô anô athêng mî te ni long amela lêkmala hethang îmô. ");
INSERT INTO ymp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Me aviyam hevong kambom hethak ong, êng me nu vo mamu da yom ômô bôte me nonang ya kambom êng bêng ethak inda. Yêni helaŋô ong, êng me tem mamu mô îtôm ŋa loyang ethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Metom mî helaŋô ong amî, êng me numbua anô te mena yi ma imbing ong be môlô nu êndêng yêni me nonang ya kambom êng bêng ethak loŋbô. Ŋa takêng tem emba be endaŋô yong ambô honang ethak inda me tem embatho long. ");
INSERT INTO ymp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Metom mî helaŋô loho ning ambô amî, êng me nu nang ya kambom bêng êndêng ŋa êv iving ya. Honang metom mî helaŋô ŋa êv iving ya amî, êng me môlôŋgô yêni îtôm anô daluk lêk anô hiwa takis te. ");
INSERT INTO ymp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ya hanang avanông ethak môlô. Nôm takatu be opatôk hîmô pîk me tem Wapômbêng epatôk injêk melak leng bêng yom. Me nôm takatu be opole hêk pîk me tem Wapômbêng epole vê injêk melak leng bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ya hanang avanông bing hethak loŋbô nena anô yi kapôlôŋing tom ethak nômate hîmô pîk iti be enang ik Wakamik ling vo imbua nômate, êng me Wakamik atu be hîmô melak leng tem nembong nôm êng imbutak anông. ");
INSERT INTO ymp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Vômbê nena long alê atu be anô yi mena lô ma ethak tom ethak yînîng athêng me tem ya mô loho lîvông.” ");
INSERT INTO ymp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yôv me Pita hêlêm me henang ik Yisu ling nena, “Anômbêng, yînîng aiyang hevong kambom hethak ya, êng me tem ya tak yêni ya kambom bôlô vithêla? Bôlô bahevi be lahavôyi mesa?” ");
INSERT INTO ymp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Êng me Yisu henang nena, “Ya hanang ethak ong nena notak aviyam ya kambom îtôm wak nômbêng iti sapêng me mî bôlô bahevi be lahavôyi yom amî! ");
INSERT INTO ymp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Vômbê nena melak leng ya lêkliŋyak bêng me hîtôm king te hevong vo ya ŋa ku êlêm êwê ya valuseleng viyang. ");
INSERT INTO ymp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wak êng hêyô me iwa anô ku te hêlêm. Ôpêng bôk heyang king ya valuseleng bêng anông hîtôm milion doho. ");
INSERT INTO ymp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yêni mî hîtôm nêŋgêv viyang amî, be ditu king henang vo êŋgêv ôpêng lo yanavî lêk nali lêk ya nômkama sapêng vo êŋgêv vuli. Me imbua valuseleng takêng be êwê king ya valuseleng viyang ethak. ");
INSERT INTO ymp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ôpêng helaŋô ambô êng me heya vabudum thîvô hîmô king va me henang nena, ‘Anômbêng, noyaŋging doke yôvêm! Valuseleng takatu be ya hauwa hêk ong sapêng me tem yaŋgêv viyang.’ ");
INSERT INTO ymp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Êng me king lahiki hethak ôpêng be henang nena, ‘Viyang dô lêk!’ Me hetak inda be hê. ");
INSERT INTO ymp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Anô ku êng hetak king ya melak be hele yêing me hethalo anô ku yang be bôk hiwa ya valuseleng îtôm 100 be bôk mî nêŋgêv viyang amî denang. Êng me hevalong ôpêng hêk be hekakô lôkbudum thing lêklokwang me hethang inda be henang nena, ‘Yînîng valuseleng êlêm!’ ");
INSERT INTO ymp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Me yang êng hêv yak hîlôk hêk yêni va me heteng inda lêk kapô malêing be henang nena, ‘Aiyang, noyaŋging doke yôvêm! Valuseleng takatu be ya hauwa hêk ong me tem yaŋgêv viyang.’ ");
INSERT INTO ymp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Metom ôpêng hêndô nendaŋô yang êng ya ambô, be ditu hiwa be hê hetak hîlôk kalaondong endebe nêŋgêv ya valuseleng êng viyang êm. ");
INSERT INTO ymp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ŋa ku vi êyê nôm atu be ôpêng hevong be esong kambom be leŋing malêing bêng be loho ê me enang hêndêng king. ");
INSERT INTO ymp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Êng me king helam ôpêng hêlêm me henang nena, ‘Ong anô ku kambom anông! Hoteng ya lêk kapôlôm malêing hele be ya hatak ong be mî nôwê yong tôp viyang amî. ");
INSERT INTO ymp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ya leng ik ya hethak ong, metom bisête be mî lem ik ong hethak anô ku yang êng bêng yom amî?’ ");
INSERT INTO ymp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Me king la maning kambom be hetak ôpêng hîlôk ŋa takatu be eyaŋging kalaondong baheŋing vo loho êŋgêv vovang êndêng yêni endebe nêŋgêv valuseleng êng viyang êm.” ");
INSERT INTO ymp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Me Yisu henang nena, “Wakamik atu be hîmô melak leng tem nembong bêng yom ethak avîlanô takatu be mî etak kapôlôŋing kambom ethak viyaŋi amî.” ");
INSERT INTO ymp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yisu henang ambô takêng yôv me hetak Galili be hê ŋanam Yelodan viyang vulu hêk Judia. ");
INSERT INTO ymp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Me avîlanô bêng anông esopa yêni be hevong loho ning ŋa lêk kômbôk sapêng ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Me Palisi doho êlêm êyô vo Yisu me evong vo eyek yêni be enang ik yêni ling nena, “Ambô balambung henang bisête? Anô te hîtôm nêŋgêv yanavî vê oyang mesa, aliêng me thêthôp e?” ");
INSERT INTO ymp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Metom Yisu henang viyang nena, “Betha bôk mî môlô sam ambô atu be henang nena, muŋdaluk anông sêmbôk be Wapômbêng hepesang avîlanô me hepesang anô da me avî da ");
INSERT INTO ymp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","yôv me henang nena, ‘Hethak ondong êng yom me anô tem netak lambô lo talêmbô me nethak tom imbing yanavî vo thêi imbutak îtôm leŋving kôpik tom yom.’ ");
INSERT INTO ymp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Thêi mî yi hethak loŋbô amî me lêk ivutak tom yom. Bêng be nôm atu be Wapômbêng bôk hevak long hethak tom me anô te mî hîtôm nepole vê amî.” ");
INSERT INTO ymp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Me Palisi enang nena, “Metom hevong bisê be Moses bôk henang nena anô te hevong vo netak yanavî, êng me nekavu kapua te be nêŋgêv êndêng yanavî vo nêŋgêv yêni vê?” ");
INSERT INTO ymp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Metom Yisu henang nena, “Môlô ŋa mî thak ondaŋô ambô amî, be ditu Moses hêv loŋdaŋlê êng hêndêng môlô vo osopa. Metom Wapômbêng mî hîlôk hethak kombom êng amî. ");
INSERT INTO ymp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya hanang avanông ethak môlô nena, anô te yanavî mî hevong sek amî metom yamalô hêv inda vê oyang be hiwa avî yang, ôpêng da me lêk hevong sek hiving avî yang êng.” ");
INSERT INTO ymp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yisu ya ŋa hîndông enang ethak inda nena, “Betha bêng me mavî vo ôpêng bôk mî nimbua avî andô.” ");
INSERT INTO ymp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Metom henang ethak loho nena, “Anô sapêng mî hîtôm esopa ambô êng amî. Me ŋa takatu be Wapômbêng hêv lêklokwang hêndêng loho yom ditu tem esopa ambô êng. ");
INSERT INTO ymp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Anô doho me talôvi evathu loho be leŋving kôpik da kambom bêng, be ditu mî hîtôm imbua avî amî. Doho me avîlanô bôk eŋgothe loho ning moma vê vo dô îmbî sêik andô. Me doho leŋing iving êŋgêv ining lêklokwang sapêng vo embong melak leng ya lêkliŋyak bêng ya ku, be ditu mî iwa avî amî. Metom opalê atu be hîtôm nesopa ambô tiêng me nesopa yom.” ");
INSERT INTO ymp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Avîlanô doho iwa sêiknena be êlêm êyô vo Yisu vo netak bang êyônjêk loho be nêŋgêv mek ethak loho. Metom ya ŋa hîndông ethang avîlanô takêng. ");
INSERT INTO ymp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Êng me Yisu henang ethak loho nena, “Otak sêiknena vo êlêm êndêng ya me dô môlômbasîng loho andô, vômbê nena avîlanô takatu be athêng mî me hîtôm sêiknena takiti be melak leng ya lêkliŋyak bêng me loho ning.” ");
INSERT INTO ymp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Êng me hetak bang hêyô hêk sêik takêng yôv me hetak long êng be hê. ");
INSERT INTO ymp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Anô te hêlêm êyô vo Yisu me henang nena, “Kîdôŋga, tem yambong kombom mavî alê vo yambua lêkmala îtôm wak nômbêng iti sapêng?” ");
INSERT INTO ymp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Êng me Yisu henang ethak inda nena, “Hevong bisê be honang ik ya ling hethak kombom alê me ‘mavî’? Anô tom yom me anô mavî! Be lem hiving numbua lêkmala atu be tem nîmô îtôm wak nômbêng iti sapêng, êng me nosopa Wapômbêng ya balambung sapêng.” ");
INSERT INTO ymp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Me ôpêng henang ik yêni ling nena, “Tem ya sopa balambung ali alête?” Êng me Yisu henang nena, “ ‘Dô nuŋgik anô vônô andô. Me dô nombong sek imbing anô yang yanavî andô. Me dô nombong vanî andô. Me wakma hova be hovong ambô me dô honang ambô yôhîng andô. ");
INSERT INTO ymp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Me nondovak lemambô lo lemtambô ning ambô. Me lem imbing avîlanô vi hîtôm lem hiving ong da.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Me anô muk êng henang nena, “Balambung takêng me thak ya hasopa sapêng. Metom tem yambong ômbête imbing?” ");
INSERT INTO ymp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Êng me Yisu henang hethak inda nena, “Lem iving numbutak thêthôp anông îmô Wapômbêng mandaluk, êng me nu me nôŋgêv yong nômkama sapêng vo avîlanô êŋgêv vuli. Me numbua valuseleng sapêng be nôŋgêv êndêng avîlanô siv vo yong nômkama mavî bêng anông tem nîmô melak leng. Hovong bêng yôv me nôlêm osopa ya.” ");
INSERT INTO ymp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Anô muk êng me anô lêk nômkama bêng anông, be ditu helaŋô ambô êng be hêv malêing bêng hêndêng yêni be hê lêk la malêing bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Êng me Yisu henang ethak ya ŋa hîndông nena, “Ya hanang avanông bing ethak môlô nena, ŋa lêk nômkama bêng tem êpôm malêing bêng vo imbutak êyô melak leng ya lêkliŋyak bêng kapô bini. ");
INSERT INTO ymp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ondaŋô! Me mî malêing vo bok kamel imbutak êyô lôvîk indi kwak ya ambuang bini amî, metom malêing bêng anông vo anô lêk nômkama bêng te tem nimbutak êyô melak leng ya lêkliŋyak bêng kapô bini.” ");
INSERT INTO ymp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ya ŋa hîndông elaŋô ambô êng be esong kambom anông be enang nena, “Bêng be opalê hîtôm nimbua lêkmala wak nômbêng iti sapêng?” ");
INSERT INTO ymp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Êng me Yisu hêyê loho kôlîlîng be henang nena, “Nôm êng me anô te mî hîtôm nembong amî me Wapômbêng yom hîtôm nembong.” ");
INSERT INTO ymp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Êng me Pita henang nena, “Nondaŋô! Bôk yoôtak yoô ning nômkama sapêng be alêm vo asopa ong, be ditu tem yoômbua ômbête?” ");
INSERT INTO ymp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Me Yisu henang ethak loho nena, “Ya hanang avanông ethak môlô. Wakma nômkama pîk sapêng hivutak lêkmuk ethak loŋbô me Anô Ya Nakandung da tem nimbua athêng bêng be nêyômô ya balê king vo neyaŋging ya avîlanô sapêng îmô long êng. Me môlô ŋa osopa ya lauming be lahavôyi takatu tem ôyô mô balê king lauming be lahavôyi be oyaŋging avîlanô Islael ondong lauming be lahavôyi takatu. ");
INSERT INTO ymp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Me avîlanô takatu be thak leŋing êv ya be etak ining melak lêk viyaŋi me livi lêk lami me talôvi lêk ining nali lêk ining kukapô, êng me tem Wapômbêng êŋgêv bêng anông êndêng loho îtôm 100 êyômô loho ning long imbing. Me loho tem imbua lêkmala atu be hîmô hîtôm wak nômbêng iti sapêng imbing. ");
INSERT INTO ymp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ondaŋô! Ŋa lêk athêng bêng anông tem imbutak ŋa athêng mî. Me ŋa athêng mî bêng anông tem imbutak ŋa lêk athêng bêng.” ");
INSERT INTO ymp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yisu henang nena, “Melak leng ya lêkliŋyak bêng me bêŋiti. Hêndêng lêkbôk momaŋaning me kukapô te ya alang hê vo nethalo ŋa ku vo embong ku îmô ya kukapô yak waing. ");
INSERT INTO ymp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yêni hêpôm anô doho be henang ik loho ling vo embong ya ku îtôm wak daluk te me tem nêŋgêv loho vuli ethak valuseleng kalalang tom. Me ŋa takêng îlôk ethak ya ambô êng. Êng me hêv loho be ê ya kukapô. ");
INSERT INTO ymp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Hîtôm wakma bahevi be lahavôva hêndêng lêkbôk me hê long thak ethak tom hîlôk me hêyê anô doho ku mî be loho mô oyang. ");
INSERT INTO ymp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Me henang ethak loho nena, ‘Môlô numbong yînîng ku imbing. Tem ya sopa kombom thêthôp be yaŋgêv môlô vuli.’ ");
INSERT INTO ymp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Êng me loho ê. “Waklîvông bing me hê hevong bêng. Me hêndêng wakma lô yathiŋdang me hê hevong bêng hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Me hêndêng wakma bahevi yathiŋdang hê me hêyê anô doho ku mî be îmô oyang me henang ethak loho nena, ‘Bisête be môlô mô oyang wak daluk itiêng?’ ");
INSERT INTO ymp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Me enang nena, ‘Anô te mî hêv ku hêndêng yoô amî.’ “Me ku alang henang nena, ‘Môlô numbong yînîng ku imbing.’ ");
INSERT INTO ymp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Yathiŋdang bîlîvông hêyô me kukapô alang henang ethak anô heyaŋging ku nena, ‘Nondam ŋa ku lêm me nôŋgêv loho vuli. Nôŋgêv vuli ŋa yathiŋdang anông imung, yôv me nôŋgêv vuli bêng ethak bini endebe nêyô ŋa lêkbôk momaŋaning me embeng yam anông.’ ");
INSERT INTO ymp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ŋa yathiŋdang anông êyô me hêv loho valuseleng kalalang tom. ");
INSERT INTO ymp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Me ŋa lêkbôk momaŋaning esong nena tem lohombua valuseleng doke bêng ma, metom mî. Loho iwa valuseleng kalalang tom bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Iwa ning vuli yôv me loho nang ambô ŋôlôŋôlông bêng hethak kukapô alang nena, ");
INSERT INTO ymp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Bisête be yoô lêm hêndêng lêkbôk be avong ku bêng lêk vovanîk heva wak mathethaleng me ŋa yathiŋdang evong ku doke yom, metom yoô sapêng auwa valuseleng hîtôm tom vo?’ ");
INSERT INTO ymp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Êng me kukapô alang henang ethak ŋa takêng te nena, ‘Aiyang, mî ya havong kambom hêndêng ong amî. Lêk ya hanang be hôlôk yôv nena tem nombong ku me numbua valuseleng kalalang tom. ");
INSERT INTO ymp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Be ditu numbua yong vuli be nu, vômbê nena ya da ya leng iving be ya hêv vuli ôpatu be heveng yam anông hethak valuseleng kalalang tom bêng yom! ");
INSERT INTO ymp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Valuseleng iti me yînîng be tem ya sopa yînîng ya leng hiving yom be yaŋgêv. Ya anô ya havong kombom me hevong bisê be môlô malemim dông vo?’ ");
INSERT INTO ymp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Ondaŋô! Ŋa lêk athêng bêng anông tem imbutak ŋa athêng mî. Me ŋa athêng mî bêng anông tem imbutak ŋa lêk athêng bêng.” ");
INSERT INTO ymp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Wakma Yisu hethak be hê Jelusalem me hiwa ya ŋa hîndông lauming be lahavôyi takatu hê dang vo avîlanô me henang ethak loho nena, ");
INSERT INTO ymp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ondaŋô. Aô yô daku Jelusalem me tem etak Anô Ya Nakandung îndôk ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung baheŋing me tem îtîtînîng inda be enang vo iŋgik yêni vônô. ");
INSERT INTO ymp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tem êŋgêv yêni êndêng ŋa long bôyang vo enang ambôma ethak inda be embali yêni be iŋgik vônô ethak alovalasing. Me hêndêng wak ali lô me tem nimbiyô ethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yôv me Sebedi yanavî hê hêyô vo Yisu hiving namalô luvi. Me heya vabudum thîvô me henang nena, “Anômbêng, ya leng iving nômate.” ");
INSERT INTO ymp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Êng me Yisu henang nena, “Lem iving ômbête?” Me avî êng henang nena, “Tem notak yînîng wakna yi tiêng yang sê îmô bahem viyôhôk me yang sê îmô bahem vikeng îmô yong lêkliŋyak bêng kapô.” ");
INSERT INTO ymp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Me henang ethak ŋa loyang yi atu nena, “Mamu thông nôm atu be onang ik ya ling paling. Hîtôm mamu num îndôk keyek atu be tem ya num îndôk mesa?” Me thêi nang nena, “Yêi hîtôm.” ");
INSERT INTO ymp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Me henang nena, “Avanông, keyek êng tem mamu num îndôk. Metom îmô ya baheng viyôhôk lêk vikeng me mî yînîng ku amî. Mî. Wakamik da heyaŋging ku êng be bôk hetak anô doho yôv vo îmô long êng.” ");
INSERT INTO ymp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ya ŋa hîndông lauming elaŋô ambô êng be leŋing ŋaŋa hethak Jems lo Jon. ");
INSERT INTO ymp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Êng me Yisu helam loho lêm ethak tom me henang nena, “Bôk môlôyala nena ŋa long bôyang ining king thak embam i me ivuling ŋa takatu be îmô loho vimbing. Me ining ŋa bêŋbêng thak enang lêklokwang hethak ining avîlanô vo esopa loho ning ambô. ");
INSERT INTO ymp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Metom dô môlô numbong kombom êng andô! Môlô te la hiving nimbutak îtôm anô lêk athêng bêng îmô môlô lîvông, êng me nimbutak îtôm môlô ning anô ku vo nêŋgêv môlô livung. ");
INSERT INTO ymp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Me ôpatu be la hiving nimbutak îtôm môlô ning anômbêng, êng me nîmô îtôm môlô ning anô ku oyang ");
INSERT INTO ymp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","hîtôm Anô Ya Nakandung hevong bêng yom. Me mî hêlêm vo avîlanô pîk embong yêni ya ku amî. Metom hêlêm vo nembong avîlanô pîk ining ku. Yêni hêlêm vo nimbua loho vê injêk malêing lêk netak ya lêkmala vo nêŋgêv avîlanô bêng anông livung.” ");
INSERT INTO ymp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yisu lêk ya ŋa hîndông etak Jeliko be ê me avîlanô bêng anông esopa yêni. ");
INSERT INTO ymp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Me anô maleŋing pusip yi îmô loŋdaŋlê dang vi me thêi elaŋô nena Yisu hêlêm. Êng me thêi elam lêklokwang nena, “Anômbêng, Devit Lim Lêkmuk, lem iŋgik ong ethak yêi!” ");
INSERT INTO ymp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Me avîlanô ethang thêi be enang nena, “Mamu bonong!” Metom thêi lam lêkwaê anông nena, “Anômbêng, Devit Lim Lêkmuk, lem iŋgik ong ethak yêi!” ");
INSERT INTO ymp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Êng me Yisu heva me helam thêi lêm me henang nena, “Mamu lemim iving yambong ômbête êndêng mamu?” ");
INSERT INTO ymp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Me thêi nang nena, “Anômbêng, yêi leŋing iving aŋga tak!” ");
INSERT INTO ymp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Êng me Yisu lahiki hethak thêi me hetak bang hêyô hêk maleŋiŋdaluk. Me ketheng oyang me thêi yê tak be esopa yêni. ");
INSERT INTO ymp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yisu loho êyô bidong Jelusalem me ê êyô Betpagi, long êng hêk bidong vo Dum Oliv. Me hêv ya ŋa hîndông yi be ê ");
INSERT INTO ymp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","me henang nena, “Mamu nu melak vulu me bôlôtom me tem ôŋgô ekak bokdoŋki te lo nakandung long be eva. Êng me mamu pole yak vê me ondom luvi be ôlêm vo ya. ");
INSERT INTO ymp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Me anô te henang ambô te hethak mamu, êng me mamu nang nena, ‘Anômbêng la hiving nembong ku te thak luvi’, êng me tem nîndôk vo mamundom be ôlêm.” ");
INSERT INTO ymp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nôm êng hivutak vo niŋgik anông hîtôm plopet bôk henang nena, ");
INSERT INTO ymp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Môlô nang ambô ti êndêng avîlanô Saion nena, ‘Ôŋgô. Môlô ning king lêk hêlêm vo môlô. Hêyô hîmô doŋki te be hêlêm îtôm anô athêng mî. Avanông, hêyô hîmô doŋki nakandung te be hêlêm.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Me ya ŋa hîndông yi atu ê me evong hîtôm Yisu henang. ");
INSERT INTO ymp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Me iwa doŋki talêmbô lêk nakandung be ê me loho ik ining kwêv thilimbung dêim thô be eŋgova hêyô hêk doŋki dômlokwang be Yisu hêyô hîmô. ");
INSERT INTO ymp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Me avîlanô bêng anông eŋgova ining kwêv thilimbung dêim hêk loŋdaŋlê. Me vi ele athaŋang lêk ŋaung be eŋgova hêk loŋdaŋlê. ");
INSERT INTO ymp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Me vi imung me vi eveng yam me Yisu hîlôk lîvông me leŋing mavî anông be îlôv lêlô be elam nena, “Osana ni êndêng Devit Lim lêkmuk!” “Wapômbêng êŋgêv la mavî êndêng ôpatu be hêlêm hethak Anômbêng ya athêng!” “Osana! Aôŋgêv Wapômbêng ya athêng ling ethak leng!” ");
INSERT INTO ymp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yisu hivutak êyô Jelusalem kapô me avîlanô nômbêng atu be îmô Jelusalem esong kambom be enang ik ling mayaliv nena, “Ôpiti me opalête?” ");
INSERT INTO ymp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Me avîlanô nômbêng atu be esopa Yisu enang nena, “Yêni me Yisu, plopet atu be hêlêm nang Nasalet hêk Galili.” ");
INSERT INTO ymp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yisu hivutak êyô melak matheng ya popatîng me hêyê avîlanô iwa nômkama be etak hîmô vo avîlanô êŋgêv vuli. Êng me hipuning loho be hêv loho vê hêk long êng be ele yêing be ê. Me hele ŋa takatu be ele ŋa long bôyang ining valuseleng thô hethak Islael ining valuseleng ining balê lîlîng. Me hevong bêng yom hêndêng ŋa takatu be etak menak bôbô hîmô vo avîlanô êŋgêv vuli. ");
INSERT INTO ymp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Me henang ethak loho nena, “Kapua matheng henang bêŋiti, ‘Yînîng melak me melak eteng mek îndôk.’ Metom lêk môlôvong be hivutak hîtôm ŋa vanî ning long ekopak îmô.” ");
INSERT INTO ymp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Me yêni hîmô melak matheng ya popatîng me ŋa maleŋing pusip lêk ŋa veŋing kambom ê êyô vo inda me hevong be loho ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung êyê nôm thamtham takatu be Yisu hevong. Me loholaŋô sêiknena elam heveng melak matheng ya popatîng nena, “Osana ni êndêng Devit Lim Lêkmuk!” Êng me loho leŋing maning ");
INSERT INTO ymp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","be enang ethak Yisu nena, “Tu be holaŋô sêiknena takiti ning ambô elam mesa?” Me Yisu henang nena, “Lêk ya halaŋô. Metom môlôvong nang bôk mî osam ambô ti nena, “ ‘Bôk hôpôpêk sêiknena lêk sêik inum sum vo êŋgêv yong athêng ling ethak vieŋing.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yôvêm me hetak loho me hele melak lông êng vi yêing be hê. Me hê hêk Betani bîlîvông êng. ");
INSERT INTO ymp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Hêndêng lêkbôk momaŋaning me Yisu hîvô hê Jelusalem hethak loŋbô me hema ve la. ");
INSERT INTO ymp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Me hêyê alokwang pik te heva loŋdaŋlê dang vi. Be ditu hê hêndêng alokwang êng, metom hêyê nena ŋaung oyang yom heva me ya anông mî. Êng me henang ethak alokwang êng nena, “Mî hîtôm nuŋgik anông ethak loŋbô amî!” Be ditu alokwang êng ya ŋaung heyeng be hema bôlôtom oyang. ");
INSERT INTO ymp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ya ŋa hîndông êyê nôm êng be esong kambom me enang nena, “Hevong bisête be alokwang iti hema ketheng oyang bêng?” ");
INSERT INTO ymp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Me Yisu henang nena, “Ya hanang avanông ethak môlô nena môlô êv iving me mî kapôlômim yi amî, êng me hîtôm môlômbong nang ya havong hêndêng alokwang iti lêk hîtôm môlômbong nôma yang imbing nena onang êndêng dum iti nena, ‘Nokaliv ong da nundôk mamik.’ Êng me tem nendaŋô môlô ning ambô. ");
INSERT INTO ymp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ômbêla takatu be môlô êv iving be oteng mek hêndêng Wapômbêng be onang ik yêni ling vo nêŋgêv, êng me tem nêŋgêv êndêng môlô.” ");
INSERT INTO ymp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yisu hivutak êyô melak matheng ya popatîng be hîndông avîlanô hîmô. Êng me ŋa bêŋbêng îmbôk da lêk avaka êlêm êndêng yêni me enang nena, “Opalê hêv lêklokwang hêndêng ong lêk hêv ku hêndêng ong be diti hovong nôm takiti êng?” ");
INSERT INTO ymp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Me Yisu henang viyang nena, “Tem ya nang iŋgik môlô ling ethak ambô te bêng imbing. Be môlô nang ambô êng viyang bêng êndêng ya, êng me tem ya nang ôpatu be hêv lêklokwang hêndêng ya, ya athêng bêng êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Opalête hêv ku ithik avîlanô hîlôk ŋanam hêndêng Jon? Wapômbêng leng mesa avîlanô pîk?” Me loho da enang ethak i nena, “Aô nang nena Wapômbêng hêv ku êng hêndêng Jon, êng me tem nenang nena, ‘Me hevong bisê be môlô mî ôêv iving Jon ya ku amî?’ ");
INSERT INTO ymp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Metom aô nang nena, ‘Anô pîk te hêv ku êng,’ êng me avîlanô tem leŋing maning ethak aô, vômbê nena loho sapêng êv iving nena Jon me plopet te.” ");
INSERT INTO ymp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yôv me loho nang ethak Yisu nena, “Yoô thông paling.” Me Yisu henang ethak loho nena, “Bêng yom me mî hîtôm ya nang ôpatu be hêv lêklokwang êndêng ya bêng ethak môlô amî. ");
INSERT INTO ymp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Môlô ning auk bisê hethak kôkôthing iti? Anô te nakandung lokwaŋyi hîmô. Me hê hêndêng namalô yang me henang nena, ‘Yînîng wakna, numbong yînîng ku embeng kukapô yak waing.’ ");
INSERT INTO ymp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Me namalô henang viyang nena, ‘Ya handô.’ Metom yôv keme hik ya auk lîlîng be hê. ");
INSERT INTO ymp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Me lambô hê hêndêng namalô yang me henang ambô tomêng hethak loŋbô hêndêng inda. Me nakandung henang nena, ‘Wakamik, tem yana.’ Metom mî hê amî. ");
INSERT INTO ymp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Be ditu ôpyiêng yang sê hesopa lambô ya ambô?” Me loho nang nena, “Namalô yang mung.” Me Yisu henang ethak loho nena, “Ya hanang avanông ethak môlô nena, ŋa iwa takis lêk avî sek mayaliv tem imbutak êyô Wapômbêng ya lêkliŋyak bêng kapô imung vo môlô. ");
INSERT INTO ymp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon bôk hêlêm be hik loŋdang thêthôp thô hêndêng môlô me môlô mî ôêv iving ya ambô amî. Metom ŋa iwa takis lêk avî sek mayaliv êv iving Jon ya ambô be bôk môlô yê yôv. Metom mî ole kapôlômim lîlîng be ôêv iving yêni amî. ");
INSERT INTO ymp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Môlôndaŋô ambô dôhô yang. Anô te hevatho ya ku yak waing te be hevak wandu hêwê heveng. Me helav lovang vo nembak waing anông pesa îndôk vo nimbua ya thôk. Me helav melak dêim te vo ŋa eyaŋging ya kukapô êng îmô. Yôv me hetak kukapô êng hîlôk anô doho baheŋing vo eyaŋging be wakma hik anông me loho imbua vi me êŋgêv vi êndêng yêni da. Me hetak long êng be hê hîmô long bôyang vambô. ");
INSERT INTO ymp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Yak waing êng anông hevong îyôk me kukapô alang hêv ya ŋa ku be ê vo imbua yêni ya tham. ");
INSERT INTO ymp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Metom ŋa takatu be eyaŋging kukapô evalong loho be evali yang me ik yang vônô me îmbî yang hethak valu. ");
INSERT INTO ymp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yôv me kukapô alang hêv ŋa ku bêng anông hethak loŋbô be ê, metom ŋa eyaŋging kukapô yak waing ivuling loho bêng yom hiving ");
INSERT INTO ymp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ele be namalô yom hîmô. Be ditu hesong nena loho tem endaŋô namalô ya ambôma, êng me hêv yêni be hê. ");
INSERT INTO ymp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Metom ŋa eyaŋging kukapô atu êng êyê kukapô alang nakandung hêyô me enang ethak i nena, ‘Ôpiti me kukapô alang nakandung be tem nimbua lambô ya long be neyaŋging ya ku. Bêng be aôŋgik yêni vônô me kukapô ti tem nimbutak îtôm aô ning.’ ");
INSERT INTO ymp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Be ditu evalong yêni be iwa hele kukapô vi yêing me ik vônô.” ");
INSERT INTO ymp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yôv me Yisu henang nena, “Wakma kukapô alang hele hêlêm hethak loŋbô, êng me tem nembong ômbête êndêng ŋa takatu be eyaŋging kukapô êng?” ");
INSERT INTO ymp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ŋa bêŋbêng îmbôk da lêk avîlanô ning avaka enang ethak yêni nena, “Tem nimbuling ŋa kambom takêng kambom anông. Me tem nêŋgêv kukapô yak waing êng êndêng anô vi vo eyaŋging. Me hêndêng wakma yak waing hik anông me ŋa takêng tem îmbî ya tham be êŋgêv êndêng yêni.” ");
INSERT INTO ymp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yisu henang ethak loho nena, “Môlôvong nang bôk mî osam ambô ti be hêk kapua matheng nena, “ ‘Valu atu be ŋa elav melak îpôlîk ethak, lêk hivutak landîng anông. Anômbêng da hevong nôm êng, be yoô yê nena mavî anông.’ ");
INSERT INTO ymp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Bêng be ya hanang ethak môlô nena Wapômbêng tem nêŋgêv ya lêkliŋyak bêng vê injêk môlô be nêŋgêv êndêng ŋa ondong yang. Me loho tem iŋgik anông îtôm alokwang mavî te thak hik anông. ");
INSERT INTO ymp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Me ôpatu be hêv yak hêyô hêk valu êng me tem nipup nenanena. Mena valu êng hêv yak hêyô hêk anô te me ôpêng tem nipilisik.” ");
INSERT INTO ymp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ŋa bêŋbêng îmbôk da lêk Palisi elaŋô Yisu ya ambô dôhô takêng me eyala nena yêni henang ethak loho. ");
INSERT INTO ymp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Êng me loho ethalo loŋdaŋlê vo embalong yêni. Metom êkô avîlanô vômbê nena avîlanô êv iving nena Yisu me plopet te. ");
INSERT INTO ymp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yisu henang ambô dôhô yang hethak loŋbô nena, ");
INSERT INTO ymp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","3","“Melak leng ya lêkliŋyak bêng me hîtôm King te heŋgambôm nômbêng vo namalô imbua avî. Êng me king hêv ya ŋa ku oyang be ê vo enang ethak avîlanô doho vo êlêm injang nôm imbing loho, metom lohondô ini. ");
INSERT INTO ymp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Yôv me hêv ŋa ku oyang vi hethak loŋbô be ê vo enang ethak avîlanô takatu be bôk helam loho yôv nena, ‘Ondaŋô! Lêk ya hapesang nôm yôv. Be ya hik yînîng bokmaŋkao malô map lêk alim dopdop doho be ya haŋgambôm, be ditu môlôlêm!’ ");
INSERT INTO ymp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Metom mî elaŋô amî me ê mayaliv. Vi ê ining kukapô me vi ê evong ining ku valuseleng. ");
INSERT INTO ymp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Me vi evalong ŋa ku takêng be evong kambom lomaloma hêndêng loho yôv me ik loho vônô. ");
INSERT INTO ymp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Êng me king la maning kambom anông be hêv ŋa vovak ê ivuling ŋa takatu be ik ya ŋa ku vônô be etak amela hêyô hêk loho ning melak lông. ");
INSERT INTO ymp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Êng me henang ethak ŋa ku nena, ‘Nôm lêk ya hapesang yôv be hîmô. Metom avîlanô takatu be ya halam loho me avîlanô kambom be êndô êlêm. ");
INSERT INTO ymp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Be ditu môlô nu loŋdaŋlê bêng sapêng be ôpôm opalêla takatu me onang ethak loho nena êlêm vo injang nôm iwa i.’ ");
INSERT INTO ymp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Me ŋa ku ê mayaliv be eveng loŋdaŋlê sapêng be ithining avîlanô mavî lêk avîlanô kambom takatu be êpôm loho. Êng me elom loho hêyô hele be melak kapô êng putup. ");
INSERT INTO ymp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Metom wakma king hivutak êyô melak kapô be hê vo ninjê avîlanô, êng me hêyê nena anô te mî hik kwêv ekam avî amî. ");
INSERT INTO ymp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Me henang ethak ôpêng nena, ‘Aiyang, hoveng bisê hele be hômô long iti kapô me mî huik kwêv ekam avî amî?’ Metom ôpêng bonong yom. ");
INSERT INTO ymp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Êng me henang ethak ya ŋa ku nena, ‘Ombalong ôpiti be okak va lo bang lêku be okaliv ende yêing binindôk long momaŋaning. Long êng me tem endeng kambom be ethang vieŋing kalalang long.’” ");
INSERT INTO ymp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yisu henang ambô dôhô êng yôv me henang nena, “Wapômbêng helam avîlanô bêng anông, metom bôk hîtôk nayi yom vo nimbua.” ");
INSERT INTO ymp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yôv me Palisi ê ethak tom me epatôk ambô te be hîtôm evak andêk vo Yisu henang ambô te bidoho me tem embalong yêni. ");
INSERT INTO ymp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yôv me loho êv ining ŋa îndông doho lêk Helot ya ŋa môlôô doho be ê hêndêng Yisu me enang nena, “Kîdôŋga, yoô ayala nena ong me anô ambô avanông yom. Be ditu thak huik Wapômbêng ya ambô thô thêthôp hêndêng avîlanô. Me mî thak hosopa anô ning auk be hôêv anô yang ling me hotaving anô yang amî, vômbê nena mî thak hôkô anô te amî. ");
INSERT INTO ymp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bêng be ditu nonang ethak yoô. Yong auk bisê? Mavî vo yoôŋgêv takis êndêng Sisa mesa dô?” ");
INSERT INTO ymp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yisu heyala loho ning auk kambom êng be henang nena, “Môlô ŋa ambô yôhîng! Bisête be môlô ovong vo ombatek ya? ");
INSERT INTO ymp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Uŋgik valuseleng atu be thak ôêv takis te thô ethak ya.” Me iwa valuseleng êng te be ê êv hêndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Me henang ik loho ling nena, “Opalête ya dôhô lêk athêng iti be hêyô hêk valuseleng?” ");
INSERT INTO ymp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Me enang nena, “Sisa.” Êng me Yisu henang ethak loho nena, “Bêng be Sisa ya nômkama me ôŋgêv êndêng Sisa da. Me Wapômbêng ya nômkama me ôŋgêv êndêng Wapômbêng da.” ");
INSERT INTO ymp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Elaŋô ambô êng be esong kambom me loho etak Yisu be ê. ");
INSERT INTO ymp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hêndêng wak êng yom me Sadyusi takatu be thak enang nena ŋa ema tem mî imbiyô ethak loŋbô amî ê hêndêng Yisu me enang ik yêni ling nena, ");
INSERT INTO ymp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Kîdôŋga, Moses bôk henang ethak aô nena, ‘Anô te hema be nali mî me yang hîmô, êng me nimbua avî tôp êng vo nîmbî yang atu be hema nakandung vê.’ ");
INSERT INTO ymp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bêng be ŋa lêk viyaŋi bahevi be lahavôyi îmô. Me bôp hiwa avî te be hema me nakandung mî. Me nok hiwa avî tôp êng hethak loŋbô, ");
INSERT INTO ymp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","metom hema be nakandung mî hiving. Me gwa bêng yom hê hele be hêyô ali dêi hema hiving. ");
INSERT INTO ymp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yandang me avî tôp êng hema hiving. ");
INSERT INTO ymp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Be ditu hêndêng wakma ŋa ema iviyô hethak loŋbô me ŋa lêk viyaŋi bahevi be lahavôyi takatu be iwa avî tôp atu, me avî êng tem nîmô îtôm loho ali alête yanavî? Vômbê nena loho sapêng bôk iwa inda.” ");
INSERT INTO ymp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Metom Yisu henang viyang nena, “Môlô nang ambô lêkgwak itiêng, vômbê nena môlô mî oyala kapua matheng lêk Wapômbêng ya lêklokwang katô amî. ");
INSERT INTO ymp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wakma ŋa ema iviyô hethak loŋbô me avîlanô tem mî imbua i ethak loŋbô amî. Me loho tem îmô îtôm aŋêla melak leng yom. ");
INSERT INTO ymp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Me ambô atu be hethak ŋa ema imbiyô ethak loŋbô me môlô ovong nang bôk mî osam ambô atu be Wapômbêng henang hêndêng môlô nena, ");
INSERT INTO ymp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Me henang nena, “Ya da hamô hîtôm Ablaham lo Aisak me Jekop ining Wapômbêng.” Bêng be yêni me mî ŋa ema ning Wapômbêng amî me ŋa lêkmala yom ining Wapômbêng.’” ");
INSERT INTO ymp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Avîlanô nômbêng atu be îmô long êng elaŋô Yisu ya ambô tiêng be esong kambom. ");
INSERT INTO ymp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Hêndêng wakma Palisi elaŋô nena Yisu hik Sadyusi ining auk lêkgwak thô, êng me loho thak tom be ê hêndêng Yisu. ");
INSERT INTO ymp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Me loho ning kîdôŋga ambô balambung te hê vo neyek Yisu be henang hik yêni ling nena, ");
INSERT INTO ymp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kîdôŋga, balambung ali alête me bêng vo balambung vi?” ");
INSERT INTO ymp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Êng me Yisu henang nena, “ ‘Lem imbing Anômbêng yong Wapômbêng injêk kapôlôm sapêng lêk dôhôlôm me yong auk sapêng imbing.’ ");
INSERT INTO ymp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Balambung itiêng me bêng vo balambung viyang be himung. ");
INSERT INTO ymp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Me balambung yang me hîtôm balambung mung atu be henang nena, ‘Lem imbing avîlanô vi hîtôm lem hiving ong da.’ ");
INSERT INTO ymp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ambô balambung sapêng lêk plopet ining ambô sapêng me hîmô balambung yi ti êng yom kapô.” ");
INSERT INTO ymp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Palisi ethak tom be îmô denang me Yisu henang ik loho ling nena, ");
INSERT INTO ymp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Môlô ning auk bisête hethak Mesaya? Ôpêng me opalê lim lêkmuk?” Me loho nang nena, “Devit lim.” ");
INSERT INTO ymp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Êng me Yisu henang ethak loho nena, “Yôv me hevong bisê be Lovak Matheng hêv auk hêndêng Devit da be helam Mesaya êng nena Anômbêng be henang nena, ");
INSERT INTO ymp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Anômbêng Wapômbêng enang ethak yînîng Anômbêng nena, “Nôndôk ômô ya baheng viyôhôk endebe ya tak yong ŋakyo îmô vemkapô vimbing êm.” ’ ");
INSERT INTO ymp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Me Devit da bôk helam Mesaya nena Anômbêng. Metom hevong bisê be ôpêng me Devit lim hiving?” ");
INSERT INTO ymp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Me loho mî hîtôm enang ambô êng 231 2 viyang amî. Be ditu hêndêng wak êng be hê me ŋa takêng êkô be loho te mî henang ik yêni ling ethak loŋbô amî. ");
INSERT INTO ymp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yisu henang ethak avîlanô nômbêng atu lêk ya ŋa hîndông nena, ");
INSERT INTO ymp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Kîdôŋga ambô balambung lêk Palisi thak îndông môlô hethak Moses ya balambung hîtôm Moses bôk hevong. ");
INSERT INTO ymp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Be ditu ambô nômbêng atu be loho nang ethak môlô me ondaŋô be ondovak be sopa. Metom kombom thak evong me dô osopa andô. Thak loho nang ambô bêng anông, metom loho da thak mî esopa amî. ");
INSERT INTO ymp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Loho êv balambung ya malêing lomaloma hêndêng avîlanô vo esopa. Be nôm êng me hîtôm vak malêing. Metom loho da thak mî êv livung doke amî. ");
INSERT INTO ymp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ŋa takêng thak epesang vak yaônena doho be eva Wapômbêng ya ambô hîlôk be epatôk hêk maleŋiŋdum lêk baheŋing. Me thak epatôk yak dêim hele hêkôlê heva ining kwêv dêim ya dang vo avîlanô injê be embam loho. ");
INSERT INTO ymp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Me thak loho leŋing iving injang nôm îmô ŋa bêŋbêng ining long thak îmô hêndêng wakma eŋgambôm nôm bêng. Lêk leŋing iving îmô ŋa bêŋbêng ining balê mung îmô melak yeng kapô. ");
INSERT INTO ymp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Me thak leŋing iving avîlanô etaving i be enang nena, ‘Waklîvông mavî’ lêk endam loho nena ‘Kîdôŋga’. ");
INSERT INTO ymp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Metom dô môlô mathethaleng vo avîlanô endam môlô nena ‘Kîdôŋga’ andô, vômbê nena môlô ning Kîdôŋga me tom yom be môlô sapêng me ŋa lêk viyaŋi. ");
INSERT INTO ymp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Lêk dô môlôndam anô pîk te nena môlô ning ‘kamik’ andô, vômbê nena môlô ning Kamik me tom yom be hîmô melak leng. ");
INSERT INTO ymp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Me môlô ning kîdôŋga me tom yom. Yêni me Mesaya. Be ditu dô anô te helam môlô nena ‘kîdôŋga’ andô. ");
INSERT INTO ymp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Me ôpatu be hîmô anômbêng anông hîmô môlô lîvông me nimbutak îtôm môlô ning anô ku. ");
INSERT INTO ymp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Me ôpatu be hembam yêni da, ôpêng tem nimbutak anô athêng mî te. Me ôpatu be hetaving i me ôpêng tem nimbutak îtôm anô lêk athêng bêng te. ");
INSERT INTO ymp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Metom alitaknena môlô Palisi lêk kîdôŋga ambô balambung! Môlô ŋa ambô yôhîng, be ditu môlô ik melak leng ya lêkliŋyak bêng ya melak ambôlêk thing vo loho. Me môlô da ôndô vo umbutak ôyô long êng kapô, metom wakma anô te hevong vo nimbutak êyô kapô me thak môlô ova long thing vo inda. ");
INSERT INTO ymp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Alitaknena môlô Palisi lêk kîdôŋga ambô balambung! Môlô ŋa ambô yôhîng. Me thak môlô veng pîk lêk mamik sapêng vo othalo anô te vo ombong yêni sopa môlô ning balambung. Be wakma ôpêng helaŋô môlô ning ambô be hesopa, yôvêm me môlô da ovong be ôpêng hevong kambom lomaloma hîvô hethak vo môlô. Be ditu ôpêng tem ni long atu be amela mî nema amî hîtôm môlô da. ");
INSERT INTO ymp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Alitaknena! Môlô me hîtôm ŋa maleŋing pusip ik loŋdaŋlê thô hêndêng avîlanô be thak onang nena, ‘Anô te hevak ambô hethak Wapômbêng ya melak matheng, êng me nôm yaôna be hîtôm netak ya ambô atu be hevak. Metom anô te hevak ambô hethak gol atu be hîmô Wapômbêng ya melak matheng, êng me nômbêng be ditu nesopa ya ambô atu be hevak.’ ");
INSERT INTO ymp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Môlô ŋa molo be malemim pusip! Ômbête me nômbêng? Gol mesa melak matheng hevong be gol hivutak matheng? ");
INSERT INTO ymp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Me thak môlô nang ambô bôte hiving nena, ‘Anô te hevak ambô hethak alakdala îmbôk da, êng me nôm yaôna be hîtôm netak ya ambô atu be hevak. Metom anô te henang avanông bing dake hethak da hîmô alakdala, êng me nômbêng be nesopa ya ambô atu be hevak.’ ");
INSERT INTO ymp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Môlô ŋa malemim pusip! Ômbête me nômbêng? Da mesa alakdala hevong da hivutak matheng? ");
INSERT INTO ymp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Bêng be ditu anô te hevak ambô hethak alakdala îmbôk da me lêk hevak ambô hethak alakdala lêk da takatu be hîmô hiving. ");
INSERT INTO ymp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Me anô te hevak ambô hethak melak matheng me lêk hevak ambô hethak melak matheng lêk Wapômbêng atu be hîmô kapô hiving. ");
INSERT INTO ymp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Me anô te hevak ambô hethak melak leng me lêk hevak ambô hethak Wapômbêng ya balê king lêk Wapômbêng atu be hêyô hîmô balê êng. ");
INSERT INTO ymp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Alitaknena vo môlô kîdôŋga ambô balambung lêk Palisi! Môlô ŋa ambô yôhîng. Be ditu thak uthup nôm takatu be thak hevong nôm vathing be uik tham hê ondong lauming be ôêv ondong te hêndêng Wapômbêng hîtôm da, metom môlô êv yak ethak osopa balambung bêŋbêng hîtôm kombom thêthôp lêk ôŋgêv kapôlômim êndêng avîlanô be ombong kombom mavî. Be ditu dô ombong kombom mavî yang me otak yang andô. ");
INSERT INTO ymp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Môlô me hîtôm ŋa maleŋing pusip ik loŋdaŋlê thô êndêng avîlanô! Me môlô thak ôêv thimathôm atu be hîlôk môlô ning thôk vê, metom môlô num bokmaŋkao atu be hîlôk thôk be ôtôking. ");
INSERT INTO ymp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Alitaknena môlô Palisi lêk kîdôŋga ambô balambung! Môlô ŋa ambô yôhîng. Me thak uthik keyek lêk belev vindôm yom. Metom keyek lêk belev kapô me hêyô thing ethak vanî lêk wambuk. ");
INSERT INTO ymp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Môlô Palisi me ŋa malemim pusip! Ômbôkîng keyek lêk belev vi kapô vo vi yêing imbutak mambung imbing! ");
INSERT INTO ymp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Alitaknena môlô Palisi lêk kîdôŋga ambô balambung! Môlô ŋa ambô yôhîng. Me môlô hîtôm valu atu be hîmô kalang be ethamba hethak peng thapuk be epesang mavî anông. Metom kalang kapô me putup hethak ŋa ema ning lokwang lêk nômkama lêlêik bôk epalê hîmô. ");
INSERT INTO ymp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Be ditu avîlanô êyê môlô ning bôk le long be loho song nena môlô me ŋa thêthôp ma. Metom môlô kapôlômim me hêyô thing hethak ku ovatek avîlanô lêk auk môlôndô Wapômbêng ya ambô. ");
INSERT INTO ymp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Alitaknena môlô Palisi lêk kîdôŋga ambô balambung! Môlô ŋa ambô yôhîng. Me thak môlô lav melak mavî hêyô plopet bôô ining kalang lêk ovatho thiling mavî hîmô ŋa thêthôp ining kalang. ");
INSERT INTO ymp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Me thak onang nena, ‘Bumalô loho ning kambom me bêng vo yoô ning, be ditu loho ik plopet vônô. Betha yoô amô imbing bumalô lohoma, êng me tem mî yoôndôk vo iŋgik plopet takêng vônô amî.’ ");
INSERT INTO ymp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bêng be môlô da ning ambô lêk ik thô nena môlô me ŋa takatu be bôk ik plopet vônô ining limi. ");
INSERT INTO ymp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yôv be môlô numbong bumalô loho ning kambom takêng endebe nîndôk dang me umbua ya vuli imbing! ");
INSERT INTO ymp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Môlô bôyîv kambom nali! Wapômbêng tem nembong ambô vo môlô be tem môlô nu long amela lêkmala. Me mî hîtôm môlô sôv bunu amî. ");
INSERT INTO ymp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Be ditu tem yaŋgêv plopet lêk ŋa auk bêng lêk kîdôŋga ambô balambung êthôk êndêng môlô, metom tem môlôŋgik doho vônô me môlôŋgik doho ethak alovalasing. Me tem ombali doho îndôk môlô ning melak yeng lêk upuning doho embeng melak lông nômbêng iti. ");
INSERT INTO ymp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Môlô thak osopa limbumi takatu be bôk ik ŋa thêthôp bêng anông vônô. Anô mung atu be ik vônô me Abel me ik bêng hethak be hêlêm hele be hêyô Sekalaia, Belekia nakandung. Ik yêni vônô hêk melak matheng lêk alakdala îmbôk da lîvông. Bêng be ditu Wapômbêng tem nêŋgêv vovang bêng êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ya hanang avanông ethak môlô nena avîlanô bôlôti tem êpôm vovang bêng ethak limi ning kambom takêng.” ");
INSERT INTO ymp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Aê, Jelusalem, Jelusalem! Môlô thak uik plopet vônô! Me ŋa takatu be Wapômbêng hêv loho lêm me môlô ik vônô hethak valu! Alitaknena! Ya havong lômbôlông vo ya thup nalumi ethak tom îtôm tale talêmbô hithup nali be îmô banik kapô, metom môlôndô. ");
INSERT INTO ymp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ondaŋô! Môlô ning melak me tem kambom be nîmô oyang! ");
INSERT INTO ymp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ya hanang avanông ethak môlô nena tem mî môlôŋgô ya ethak loŋbô amî endebe onang nena, ‘Wapômbêng embong mavî êndêng ôpatu be hêlêm hethak Anômbêng ya athêng.’” ");
INSERT INTO ymp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yisu hetak melak matheng me hele yêing be hê denang me ya ŋa hîndông ê hêndêng yêni be enang nena, “Nôŋgô melak matheng lêk ya leleyang mavî takiti!” ");
INSERT INTO ymp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Me Yisu henang nena, “Môlôŋgô nôm takiti. Ya hanang avanông ethak môlô nena malêing bêng tem nimbutak be ŋa vovak tem iŋgik nômkama mavî nômbêng iti pesa be valu yang mî hîtôm nêyômô yang long amî.” ");
INSERT INTO ymp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wakma Yisu hîmô Dum Oliv me ya ŋa hîndông yom ê hêndêng yêni be enang nena, “Nonang ethak yoô nena aŋgête nôm takiti be honang tem imbutak? Me ômbête ditu tem nimbutak vo niŋgik thô nena tem nondelêm vo pîk lo leng yandang?” ");
INSERT INTO ymp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Me Yisu henang viyang nena, “Oyaŋging am vo dô anô te embatek môlô andô. ");
INSERT INTO ymp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vômbê nena anô bêng anông tem êlêm ethak yînîng athêng be embatek avîlanô be enang nena, ‘Ya me Mesaya.’ ");
INSERT INTO ymp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Me tem môlôndaŋô kôkôthing ethak vovak bêng lêk kôkôthing oyang lomaloma hîvô be hele ethak vovak ivutak pîk luvuluvu. Nôm takêng tem nimbutak metom pîk lo leng ya dang me mî denang. Be ditu dô ondowaling andô. ");
INSERT INTO ymp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Me avîlanô ondong yang tem embong vovak imbing ondong yang. Me king yang lêk ya avîlanô tem embong vovak imbing king yang lêk ya avîlanô. Me long doho tem bôm lêk duviyang bêng imbutak. ");
INSERT INTO ymp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nôm takêng me hîtôm vovang atu be himung hêndêng wakma avî evong embathu. ");
INSERT INTO ymp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Me tem embalong môlô be etak îndôk anô vi baheŋing vo êŋgêv vovang êndêng môlô be iŋgik môlô vônô, vômbê nena môlô me yînîng avîlanô be ditu avîlanô pîk sapêng tem kapôlôŋing êndô môlô. ");
INSERT INTO ymp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Me avîlanô êv iving bêng anông tem etak ining êv iving me tem kapôlôŋing êndô i be enang i bêng ethak ŋakyo. ");
INSERT INTO ymp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Me plopet ambô yôhîng bêng anông tem imbutak be embatek avîlanô bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Me avîlanô takatu be êndô esopa Wapômbêng ya balambung tem imbutak bêng anông. Be ditu avîlanô ning kombom leŋing iving avîlanô vi tem ni yaônalêk. ");
INSERT INTO ymp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Metom ŋa takatu be eva lêklokwang hele be hîlôk yandang me Wapômbêng tem nimbua loho vê injêk kambom ya vuli. ");
INSERT INTO ymp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Be ditu avîlanô tem enang Wapômbêng ya Ambô Mavî tiêng ethak ya lêkliŋyak bêng embeng pîk bêŋiti sapêng vo avîlanô endaŋô yôv kîmîng pîk lo leng yandang êyô.” ");
INSERT INTO ymp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yisu henang ethak loŋbô nena, “Tem môlôŋgô nôm kambom anông sêmbôk be plopet daniel henang, nôm êng tem nemba Wapômbêng da ya melak.” Bêng be ditu môlô ŋa takatu be osam ambô tiêng me lemim êŋgêv katôyang. ");
INSERT INTO ymp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Hêndêng wakma êng me ŋa takatu be îmô Judia me îsôv bini dumlôlê. ");
INSERT INTO ymp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Me ŋa takatu be îmô melak vôv me dô îndôk bini melak kapô vo imbua loho ning nômkama andô. ");
INSERT INTO ymp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Me ŋa takatu be îmô kukapô me dô endeni melak vo imbua ining kwêv thilimbung andô. ");
INSERT INTO ymp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Alitaknena. Wakma êng me tem malêing bêng vo avî takatu be ethambeng lêk avî takatu be êv sum hêndêng sêik kasek. ");
INSERT INTO ymp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Be ditu môlô teng mek vo malêing takêng dô nimbutak êndêng Sabat mena wakma beleng simbak ma andô. ");
INSERT INTO ymp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Vômbê nena wakma êng me tem malêing lêkwaê anông be nîmbô ethak vo malêing taksêmbôk be pîk mî hivutak amî denang hele be hêyô lêk. Me heveng yam me tem mî nômate nimbutak bêng ethak loŋbô amî. ");
INSERT INTO ymp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Betha Wapômbêng mî hendambêng wakma malêing takêng bidong amî, êng me tem avîlanô sapêng êŋgêv yak. Metom la hêv avîlanô takatu be bôk hîtôk loho yôv, be ditu hendambêng wakma takêng hê bidong. ");
INSERT INTO ymp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Me hêndêng wakma anô te henang ethak môlô nena, ‘Ôŋgô, Mesaya hîmô long iti’ mena ‘hîmô long tamu,’ êng me dô môlôŋgêv imbing andô. ");
INSERT INTO ymp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Vômbê nena anô doho tem êlêm be enang ambô yôhîng nena, ‘Ya Mesaya’ mena ‘Ya me Wapômbêng ya plopet te.’ Me tem embong lavuning lêk nôm thamtham vo embatek avîlanô sapêng. Me loho hîtôm me tem embatek avîlanô takatu be bôk Wapômbêng hîtôk loho yôv vo yêni da ya. ");
INSERT INTO ymp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ondaŋô! Nôm takiti mî denang me lêk ya hanang himung ethak môlô vo oyaŋging am. ");
INSERT INTO ymp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Bêng be anô te henang ethak môlô nena, ‘Ôŋgô, Mesaya hîmô long thiliv,’ êng me dô môlô nu andô. Mena henang nena, ‘Ôŋgô, yêni hîmô melak iti,’ êng me dô môlô ôŋgêv imbing ôpêng andô. ");
INSERT INTO ymp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ondaŋô! Damak thak êv nang long wak hethak be danda hê hîlôk long wak ê hîlôk be avîlanô sapêng êyê. Me Anô Ya Nakandung tem nêlêm be avîlanô sapêng injê yêni bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Me menak jêng thak ethak tom hîmô long takatu be nômate hepalê hêk. ");
INSERT INTO ymp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Malêing takêng hele hîlôk yôv me ketheng oyang me “ ‘wak tem nimbutak momaŋaning, me ayông tem mî hîtôm nîmbî danda amî, me môtôp leng tem eŋgololong, me nôm lêklokwang takatu be hîmô leng tem endowaling.’ ");
INSERT INTO ymp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Hêndêng wakma êng me Anô Ya Nakandung ya lavuning tem nimbutak injêk leng. Me avîlanô pîk tem embolomba be endeng, vômbê nena tem injê Anô Ya Nakandung nîmô mavông be nêlêm hiving ya lêkliŋyak lêk ya danda lêkmaŋging. ");
INSERT INTO ymp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Me lavuak tem nendeng lêkwaê anông me tem nêŋgêv ya aŋêla bini pîk ya dang sapêng vo ithup avîlanô takatu be bôk yêni da hîtôk yôv. ");
INSERT INTO ymp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Bêng be ditu môlômbua auk ethak alokwang yêk. Wakma ŋaung heyeng be heŋgololong me ŋaung lêkmuk hivutak, êng me oyala nena wak mavî tem nêyô. ");
INSERT INTO ymp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Be ditu môlô yê nena nôm takiti hivutak, êng me môlôyala nena Anô Ya Nakandung ya waklavông nendelêm lêk bidong oyang be heva melak ambôlêk. ");
INSERT INTO ymp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ya hanang avanông ethak môlô nena avîlanô bôlô tiêng tem mî ema amî denang me nôm takiti sapêng tem nimbutak. ");
INSERT INTO ymp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pîk lo leng tem nêŋgêv yak bini, metom yînîng ambô bôte mî hîtôm nêŋgêv yak amî. ");
INSERT INTO ymp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Anô te mî heyala yînîng waklavông lêk wakma yandelêm amî. Me aŋêla leng mî eyala amî, me Nakandung mî heyala hiving amî, metom Wakamik yom heyala. ");
INSERT INTO ymp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hêndêng waklavông Anô Ya Nakandung tem nendelêm me avîlanô bôlô tiêng tem embong îtôm bôk evong hêndêng Noa ya wakma. ");
INSERT INTO ymp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Ŋanambô mî denang me avîlanô eyang be inum me iwa i hê be hêlêm be îthông paling hele be hêyô wakma Noa hê yeng kapô. Yôv me ŋanambô bêng hêyô be hivuling loho sapêng. Be bêng yom me avîlanô bôlô tiêng tem îthông paling me Anô Ya Nakandung tem nendelêm. ");
INSERT INTO ymp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Hêndêng wakma êng me anô yi tem îmô kukapô me tem imbua yang me yang îmô. ");
INSERT INTO ymp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Me avî yi tem epesang nôm îmô me tem imbua yang me yang îmô. ");
INSERT INTO ymp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Bêng be môlô ôŋgêv lêlê anông, vômbê nena môlô mî oyala waklavông atu be môlô ning Anômbêng tem nendelêm amî. ");
INSERT INTO ymp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Môlô lemim êŋgêv ambô ti katô. Melak te alang helaŋô ambô nena ŋa vanî tem ende ya melak kê, êng me yêni hêv lêlê vo ŋa vanî mî hîtôm ende ya melak êng kê amî. ");
INSERT INTO ymp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Me Anô Ya Nakandung tem nendelêm be nembong môlô ôpîndîk kambom, be ditu ômô lêlê bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Bêng be môlômbong ku îtôm anô ku lêkauk mavî be thak hesopa ambô. Ôpêng ya avaka hetak inda vo neyaŋging ya ŋa ku be nêŋgêv nôm êndêng loho îtôm wakma atu be hîtôk. ");
INSERT INTO ymp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Me hêndêng wakma ya avaka hîvô hêlêm ethak loŋbô be hêyê nena anô ku êng hevong ku mavî, êng me tem mavî vo ôpêng. ");
INSERT INTO ymp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ya hanang avanông ethak môlô nena avaka êng tem netak ôpêng vo neyaŋging ya nômkama sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Metom ôpêng anô kambom, êng me tem laŋgêv injêk kapô nena, ‘Lêk bôô me yînîng avaka mî hîvô hêlêm ketheng amî.’ ");
INSERT INTO ymp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Be ditu hik ŋa ku takatu be evong ku hiving yêni me heyang nôm lêk hinum waing hiving ŋa takatu be thak inum waing be elo molo. ");
INSERT INTO ymp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Hevong bêng be hîthông waklavông lêk wakma ya avaka tem nêyô paling. ");
INSERT INTO ymp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Êng me avaka atu tem nêŋgêv vovang bêng êndêng yêni me netak ôpêng îmô imbing ŋa takatu be enang ambô yôhîng. Long êng me loho tem endeng kambom be ethang vieŋing ondong long. ");
INSERT INTO ymp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Heveng yam me melak leng ya lêkliŋyak bêng tem nîtôm avî voyavô lauming iwa ning lam be ê vo injê ôpatu be tem nimbua avî lêkmuk. ");
INSERT INTO ymp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Avî lêkauk bahevi me avî auk mî bahevi. ");
INSERT INTO ymp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Avî auk mî iwa ning lam be ê, metom mî iwa ining lam ya thôk doho vo êtôm imbing amî. ");
INSERT INTO ymp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Metom avî lêkauk iwa ning lam lêk ya thôk hîlôk kolopak doho iving vo êtôm. ");
INSERT INTO ymp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Avî takêng eyambing anô êng vo nêyô hele be mî hêyô ketheng amî, be ditu maleŋing eyang be êkthôm. ");
INSERT INTO ymp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Metom hêndêng bîlîvông bing me kaêk te helam nena, ‘Anô hiwa avî lêk hêyô yôv be môlôlêm yêing vo umbua inda thô!’ ");
INSERT INTO ymp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Êng me avî voyavô takêng iviyô me epesang ining lam. ");
INSERT INTO ymp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Me avî auk mî enang ethak avî lêkauk nena, ‘Yoô ning lam hevong ema be môlôŋgêv lam thôk doho êndêng yoô.’ ");
INSERT INTO ymp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Me avî lêkauk enang nena, ‘Mî hîtôm aô sapêng amî be ditu môlô da nu vo ôŋgêv môlô ning vuli.’ ");
INSERT INTO ymp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Êng me loho ê denang vo êŋgêv loho da ning vuli me anô hiwa avî atu hêyô. Me vi atu be lêk epesang i yôv ivutak êyô melak kapô hiving yêni vo injang nôm me ik melak ambôlêk thing. ");
INSERT INTO ymp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Yôvêm me vi atu êyô me enang nena, ‘Anômbêng, anômbêng! Nuŋgik melak ambôlêk kê vo yoô.’ ");
INSERT INTO ymp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Metom ôpêng henang nena, ‘Ya hanang avanông bing ethak môlô nena ya hathông môlô paling.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yôv me Yisu henang ethak avîlanô takatu be elaŋô ya ambô nena, “Môlô mî oyala waklavông lêk wakma atu be Anô Ya Nakandung tem nendelêm amî, be ditu môlôŋgêv lêlê.” ");
INSERT INTO ymp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Me Yisu henang ethak loŋbô nena, “Melak leng ya lêkliŋyak bêng me hîtôm anô lêk valuseleng bêng te hevong vo nimbeng long bôyang yôv ketem nendelêm, be ditu helam ya ŋa ku hêlêm me hêv ya valuseleng êndêng loho vo eyaŋging. ");
INSERT INTO ymp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yêni hîmbî valuseleng tham hîtôm loho ning auk lêk ining ku, be ditu hêv 5,000 hêndêng anô te me 2,000 hêndêng anô yang me 1,000 hêndêng anô te me hê. ");
INSERT INTO ymp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ketheng oyang me ôpatu be hiwa 5,000 hê me hevong ku hethak be hêvôv 5,000 hêyô hîmô long hiving. ");
INSERT INTO ymp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Me yang atu be hiwa 2,000 hê me hevong ku bêng yom be hêvôv 2,000 hêyô hîmô long hiving. ");
INSERT INTO ymp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Metom ali atu be hiwa 1,000 hê me helav lovang be hivung ya avaka ya valuseleng îlôk. ");
INSERT INTO ymp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Yôv me avaka êng hê be heveng vambô anông yôv me hîvô lêm ethak loŋbô. Me helam ya ŋa ku hêlêm vo nendaŋô loho ning ku ya lavông. ");
INSERT INTO ymp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Me ali atu be hêvôv 5,000 hêyô hîmô long hiving hêlêm me henang nena, ‘Anômbêng, bôk hôêv 5,000 vo ya hayaŋging. Nôŋgô! Lêk ya havôv 5,000 hêyô hîmô long hiving.’ ");
INSERT INTO ymp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Me ya avaka henang nena, ‘Mavî anông! Ong anô katô be hovong ku mavî. Lêk hoyaŋging nôm yaôna mavî, be ditu tem yaŋgêv nôm bêng anông êndêng ong vo noyaŋging. Nôlêm vo ai leŋing mavî ethak tom!’ ");
INSERT INTO ymp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Me ôpatu be hiwa 2,000 hêlêm me henang nena, ‘Anômbêng, bôk hôêv 2,000 hêndêng ya be ya hayaŋging. Nôŋgô! Lêk ya havôv 2,000 hêyô hîmô long hiving.’ ");
INSERT INTO ymp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Me ya avaka henang nena, ‘Mavî anông! Ong anô katô be hovong ku mavî. Lêk hoyaŋging nôm yaôna mavî, be ditu tem yaŋgêv nôm bêng anông êndêng ong vo noyaŋging. Nôlêm vo ai leŋing mavî ethak tom!’ ");
INSERT INTO ymp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Yôv me ali atu be hiwa 1,000 hêlêm me henang nena, ‘Anômbêng, ya hayala nena ong me anôŋa, vômbê nena thak holav nôm hîlôk kukapô atu be mî hovatho amî. Me kukapô atu be mî hopayiv yaŋvêk hîlôk amî me thak huwa ya nôm. ");
INSERT INTO ymp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Be ditu ya hakô be ya havung yong 1,000 atu hîlôk pîk. Nôŋgô! Yong valuseleng êng ti.’ ");
INSERT INTO ymp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Me avaka henang viyang nena, ‘Ong anô kambom lêk ong anô vau! Honang nena thak ya halav nôm hîlôk kukapô atu be mî ya havatho amî. Me honang nena thak ya hauwa nôm hîlôk kukapô atu be mî ya hapayiv yaŋvêk hîlôk amî. ");
INSERT INTO ymp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Metom hevong bisê be mî notak yînîng valuseleng îndôk melak valuseleng vo wakma atu be ya hayô hethak loŋbô me tem yambua valuseleng ya nakandung doho êyô mô long imbing?’ ");
INSERT INTO ymp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Yôv me henang ethak ŋa ku vi nena, ‘Môlômbua 1,000 atu vê injêk inda be ôŋgêv êndêng ôpatu be hiwa 10,000. ");
INSERT INTO ymp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Vômbê nena ôpatu be hevong ku mavî hethak yînîng valuseleng be hivutak bêng anông, êng me tem ya tak doho êyômô long imbing be yaŋgêv êndêng ôpêng vo nimbutak bêng anông. Me ôpatu be mî hevong ku hethak yînîng valuseleng amî, êng me tem yaŋgêv doke atu be hevalong vê injêk inda. ");
INSERT INTO ymp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Me ôŋgêv anô volong êng vê bini long momaŋaning. Long êng me tem nendeng kambom be nethang ambôlêk ondong long.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Hêndêng wakma Anô Ya Nakandung êlêm iving ya danda lêkmaŋging lêk aŋêla sapêng, êng me tem nêyômô ya balê king lêkmaŋging. ");
INSERT INTO ymp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Me avîlanô pîk sapêng tem ethak tom be êlêm emba yêni mandaluk me tem nembak loho kê ni ondong yi îtôm boksipsip alang thak hik boksipsip tham be îmô bôyang me bokmeme da îmô bôyang. ");
INSERT INTO ymp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Me tem netak boksipsip îmô bang viyôhôk me bokmeme îmô bang vikeng. ");
INSERT INTO ymp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Yôv me King tem nenang ethak avîlanô takatu be îmô bang viyôhôk nena, ‘Môlôlêm! Wakamik bôk hevong mavî hêndêng môlô. Be ditu môlôlêm umbua lêkliŋyak bêng atu be Wapômbêng bôk hêpôpêk vo môlô hêndêng sêmbôk be hepesang pîk muŋdaluk anông. ");
INSERT INTO ymp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Vômbê nena sêmbôk be ya hama vo ya leng me môlô êv nôm hêndêng ya. Me ya muning hethak ŋanam me môlô êv ŋanam hêndêng ya. Me ya anô long bôyang me môlô uwa ya thô. ");
INSERT INTO ymp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ya kwak mî me môlô êv kwak hêndêng ya. Me ya hatung kômbôk me môlô yaŋging ya. Me ya hamô kalaondong me môlôlêm ôyê ya.’ ");
INSERT INTO ymp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Yôv me avîlanô thêthôp tem enang viyang nena, ‘Anômbêng, hêndêng aŋgête me yoô yê homa vo lem be yoô êv nôm hêndêng ong lêk ong muning hethak ŋanam be yoô êv ŋanam hêndêng ong? ");
INSERT INTO ymp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hêndêng aŋgête me ong anô long bôyang be yoô auwa ong thô lêk ong kwak mî be yoô êv hêndêng ong? ");
INSERT INTO ymp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hêndêng aŋgête me hutung kômbôk be yoô yaŋging ong lêk ayê hômô kalaondong be yoô athôk ayê ong?’ ");
INSERT INTO ymp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Me King tem nenang ethak loho nena, ‘Ya hanang avanông ethak môlô! Bôk ovong nôm takêng hêndêng yînîng avîlanô takatu be athêng mî, be ditu hîtôm môlô ovong hêndêng ya.’ ");
INSERT INTO ymp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Yôv me tem nenang ethak avîlanô takatu be eva bang vikeng nena, ‘Môlômbeng dang! Wapômbêng bôk henang yôv nena tem utung malêing be môlô nu long amela lêkmala atu be bôk embang yôv vo Sakdang lêk ya aŋêla. ");
INSERT INTO ymp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sêmbôk be ya hama vo ya leng me mî ôêv nôm hêndêng ya amî. Me ya muning hethak ŋanam me mî ôêv ŋanam hêndêng ya amî. ");
INSERT INTO ymp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Me ya anô long bôyang me mî uwa ya thô amî. Me ya kwak mî me mî môlô êv kwak hêndêng ya amî. Me ya hatung kômbôk lêk ya hamô kalaondong me mî môlôŋgô ya amî.’ ");
INSERT INTO ymp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Me tem loho nang viyang bêng nena, ‘Anômbêng, aŋgête me yoô yê homa vo lem, mena ong muning hethak ŋanam, mena ong anô long bôyang, mena ong kwak mî, mena hutung kômbôk, mena hômô kalaondong be mî yoô êv ong livung amî?’ ");
INSERT INTO ymp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Yôv me tem nenang viyang ethak loho nena, ‘Ya hanang avanông ethak môlô! Bôk mî môlômbong nôm takêng ethak yînîng avîlanô takatu be athêng mî te amî, be ditu hîtôm môlôvong hêndêng ya da.’ ");
INSERT INTO ymp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Be ditu avîlanô takiti êng tem ini vo imbua vovang îtôm wak nômbêng iti sapêng. Metom avîlanô thêthôp tem ini vo imbua lêkmala îtôm wak nômbêng iti sapêng.” ");
INSERT INTO ymp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wakma Yisu henang ambô nômbêng êng yôv me henang ethak ya ŋa hîndông nena, ");
INSERT INTO ymp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Môlôyala nena wak yi hêk denang vo nêyô Waklavông Hêv Lîlîng. Hêndêng waklavông êng me tem etak Anô Ya Nakandung îndôk ŋakyo baheŋing vo iŋgik yêni vônô ethak alovalasing.” ");
INSERT INTO ymp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yôv me ŋa bêŋbêng îmbôk da lêk avaka ethak tom hîlôk kwandôk bêng hîmbôk da, ôpatu be ya athêng nena Kaiapas ya melak popatîng. ");
INSERT INTO ymp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Me ethalo loŋdaŋlê vo embalong Yisu menang oyang be iŋgik yêni vônô. ");
INSERT INTO ymp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Metom loho nang nena, “Dô aômbong nôm ti êndêng Waklavông Hêv Lîlîng îndôk avîlanô maleŋing andô, endekeme loho leŋing maning be embong vovak.” ");
INSERT INTO ymp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Hêndêng wakma êng me Yisu hêyô Betani be hîmô Saimon ôpsêmbôk be hiwa kômbôk lepla ya melak. ");
INSERT INTO ymp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Me Yisu heyang nôm îmô me avî te hêyô hethak melak kapô. Avî êng hiwa kolopak kêkêlô te lêk nôm uv mavî hîmô kapô be ya vuli me bêng anông be heŋgathô hêyô hîmô Yisu kwandôk. ");
INSERT INTO ymp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yisu ya ŋa hîndông êyê nôm êng me leŋing maning be enang nena, “Bisête be hivuling nôm uv mavî ti be heŋgathô itup hê oyang? ");
INSERT INTO ymp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Hîtôm nêŋgêv vo anô yang êŋgêv vuli me nimbua valuseleng bêng be nêŋgêv êndêng avîlanô siv.” ");
INSERT INTO ymp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yisu helaŋô loho ning ambô êng me henang nena, “Bisête be môlô êv malêing hêndêng avî tiêng? Yêni hevong nôm mavî anông hêndêng ya. ");
INSERT INTO ymp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Avîlanô siv tem îmô imbing môlô îtôm wak nômbêng iti sapêng. Metom tem mî ya mô imbing môlô vambô amî. ");
INSERT INTO ymp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Avî ti heŋgathô nôm uv mavî hêyô hîmô ya vo hepesang ya leŋving kôpik vo endav ya. ");
INSERT INTO ymp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ondaŋô! Ya hanang avanông ethak môlô nena pîk nômbêng atu be enang Ambô Mavî heveng me tem enang ethak nôm atu be avî ti lêk hevong iving vo avîlanô leŋing êŋgêv ya kôkôthing.” ");
INSERT INTO ymp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yôv me Judas Iskaliot, Yisu ya ŋa hîndông lauming be lahavôyi takatu te, hê hêndêng ŋa bêŋbêng îmbôk da ");
INSERT INTO ymp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","me henang nena, “Tem ya hatak Yisu îndôk môlô bahemim, metom tem môlôŋgêv ômbête êndêng ya?” Êng me loho iwa valuseleng silva hîtôm 30 thô be êv hêndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tomêng me Judas hethalo loŋdaŋlê vo netak Yisu îndôk loho baheŋing. ");
INSERT INTO ymp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Waklavông Eyang Polom Yis Mî ya wak ali mung hêyô. Me Yisu ya ŋa hîndông ê hêndêng inda me enang ik yêni ling nena, “Lemêv tem yoôna melak alê vo yoô pôpêk nôm leŋing êŋgêv Waklavông Hêv Lîlîng îndôk?” ");
INSERT INTO ymp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Me henang nena, “Môlô nu melak lông kapô me tem utung anô te me onang ethak yêni nena, ‘Kîdôŋga henang nena ya wakma atu me lêk bidong. Be yêni lêk ya ŋa hîndông tem êlêm yong melak vo injang nôm leŋing êŋgêv Waklavông Hêv Lîlîng.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Me ya ŋa hîndông evong hîtôm henang be loho ê me epesang nôm Waklavông Hêv Lîlîng. ");
INSERT INTO ymp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yathiŋdang momaŋaning hêyô me Yisu heyang nôm hîmô hiving ya ŋa hîndông lauming be lahavôyi takatu ");
INSERT INTO ymp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","loho eyang nôm îmô denang me henang nena, “Ya hanang avanông ethak môlô nena môlô te tem netak ya îndôk ŋakyo baheŋing.” ");
INSERT INTO ymp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Me loho kapôlôŋing malêing kambom be loho tomtom enang nena, “Anômbêng, betha ya mî mesa?” ");
INSERT INTO ymp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Êng me Yisu henang viyang nena, “Ôpatu be hetak bang hîlôk belev hiving ya ditu tem netak ya îndôk ŋakyo baheŋing. ");
INSERT INTO ymp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Anô Ya Nakandung teni îtôm bôk ekavu yôv hethak yêni. Metom alitakna. Malêing bêng vo ôpatu be tem netak Anô Ya Nakandung îndôk ŋakyo baheŋing. Betha talêmbô bôk nembathu yêni amî, êng me tem mavî vo inda!” ");
INSERT INTO ymp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Me Judas, ôpatu be tem netak Yisu îndôk ŋakyo baheŋing, henang ik ling nena, “Kîdôŋga, betha ya mesa?” Me Yisu henang nena, “Hîtôm ditu honang.” ");
INSERT INTO ymp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Loho eyang nôm hîmô me Yisu hiwa polom te be henang la mavî hêndêng Wapômbêng. Yôvêm me hekavli be hêv hêndêng ya ŋa hîndông me henang nena, “Môlômbua be oŋgwang. Diti me yînîng vathiap.” ");
INSERT INTO ymp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yôvêm me hiwa keyek lêk waing be henang la mavî hêndêng Wapômbêng. Me hêv hêndêng loho be henang nena, “Môlô sapêng unum îndôk keyek iti. ");
INSERT INTO ymp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Diti me yînîng lêkma atu be tem neŋgathô vo nembak tava imbing Wapômbêng lêk avîlanô pîk iti vo nêŋgêv avîlanô bêng anông ining kambom vê. ");
INSERT INTO ymp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya hanang ethak môlô nena tem mî ya num waing ethak loŋbô amî endebe waklavông atu be tem ya num waing lêkmuk imbing môlô îmô Wakamik ya lêkliŋyak bêng kapô nêyô êm.” ");
INSERT INTO ymp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Loho êv yeng te yôv me etak long êng be ê Dum Oliv. ");
INSERT INTO ymp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Me Yisu henang ethak ya ŋa hîndông nena, “Yaô bîlîvông iti me tem môlôŋgô nôm takatu be tem nimbutak ya be môlô sapêng ining êv iving tem nêŋgêv yak hîtôm bôk ekavu nena, “ ‘Tem yaŋgik boksipsip ining alang vônô, me boksipsip tem îsôv mayaliv bini.’ ");
INSERT INTO ymp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Metom yôv ketem yambiyô ethak loŋbô me yamung be yana Galili me tem môlômbeng ya yam.” ");
INSERT INTO ymp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Me Pita henang viyang nena, “Mî! Loho sapêng etak ong be ê, metom tem mî hîtôm ya tak ong amî.” ");
INSERT INTO ymp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Me Yisu henang nena, “Ya hanang avanông bing ethak ong nena yaô bîlîvông iti me tale mî heleng amî denang me tem nonang îtôm bôlô lô nena hôthông ya paling.” ");
INSERT INTO ymp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Me Pita henang ethak inda nena, “Mî anông! Ik ya vônô hiving ong ma, metom mî hîtôm tem ya nang nena ya hathông ong paling amî.” Me ya ŋa hîndông sapêng enang bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yôvêm me Yisu lêk ya ŋa hîndông êyô long atu be elam nena Getsemani me henang ethak loho nena, “Môlô mô long iti me ya ha vo ya teng mek.” ");
INSERT INTO ymp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Me hiwa Pita hiving Sebedi nakandung luvi be loho ê. Me yêni kapô lêk malêing be lahiki bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Be henang ethak loho nena, “Ya kapôlông lêk malêing bêng anông hîtôm ya havong ama. Be ditu môlô mô lêlê be ondav long imbing ya.” ");
INSERT INTO ymp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Me hê dêim doke me hêv yak be thohav lo ma hîlôk pîk. Me heteng mek nena, “Wakamik, loŋdaŋlê te hêk, êng me ya leng hiving numbua keyek iti vê injêk ya. Metom dô nosopa ya leng hiving andô. Mî, nosopa ong da yong lem hiving.” ");
INSERT INTO ymp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yôv me Yisu hele hê me hêyê ya ŋa hîndông takatu me lêk êkthôm. Êng me henang ik Pita ling nena, “Hevong bisê be mî hîtôm ôŋgêv lêlê imbing ya wakma te amî? ");
INSERT INTO ymp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Môlô mô lêlê be oteng mek vo dô ôŋgêv yak îndôk nôm takatu be tem neyek môlô andô. Dôhô la hiving nembong bêng, metom kôpik vau be mî hîtôm nembong bêng amî.” ");
INSERT INTO ymp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yôv me hîvô hê hethak loŋbô me heteng mek nena, “Wakamik, loŋdaŋlê te mî hêk vo numbua keyek iti vê injêk ya vo dô ya num andô, êng me nosopa ong da yong lem hiving yom.” ");
INSERT INTO ymp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yôv me hele hê hethak loŋbô me hêyê loho êkthôm denang, vômbê nena maleŋing heyang be mî hîtôm îmô lêlê amî. ");
INSERT INTO ymp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Êng me hetak loho be hîvô hê me heteng mek bôô atu bôlô ali lô hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yôvêm me hele hê vo ya ŋa hîndông me henang ethak loho nena, “Môlô ôêkthôm be uwa lovak denang e? Ondaŋô. Wakma lêk bidong vo etak Anô Ya Nakandung îndôk ŋa kombom kambom baheŋing. ");
INSERT INTO ymp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ôŋgô! Anô netak ya îndôk ŋa takêng baheŋing lêk hêlêm yôv, be ditu môlômbiyô vo aô na êndêng loho.” ");
INSERT INTO ymp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisu henang ambô denang me Judas hêyô, yêni me ya ŋa hîndông lauming be lahavôyi takatu te. Me avîlanô bêng anông êlêm hiving yêni be iwa bîng vovak lêk ŋokyôhôk. Ŋa takêng me ŋa bêŋbêng îmbôk da lêk avaka êv loho be êlêm. ");
INSERT INTO ymp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ôpatu be tem netak Yisu îndôk ŋa êng baheŋing bôk henang lavuning te hêndêng loho nena, “Ôpatu be tem yaŋgu me Yisu be môlômbalong yêni!” ");
INSERT INTO ymp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Me ôpêng hê ketheng hêndêng Yisu me henang nena, “Kîdôŋga, bîlîvông mavî.” Me hiŋgu inda. ");
INSERT INTO ymp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Me Yisu henang nena, “Aiyang, nombong nôm atu be hôlêm vo nombong.” Êng me ŋa êng evalong Yisu hêk. ");
INSERT INTO ymp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Me ŋa takatu be loho eva hiving Yisu me te hendandi ya bîng vovak be hele kwandôk bêng hîmbôk da ya anô ku te limbuk vi thô. ");
INSERT INTO ymp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Me Yisu henang nena, “Notak yong bîng îndôk ya kôpik ethak loŋbô! Ŋa takatu be evong vovak hethak bîng me tem bîng injang loho da vônô. ");
INSERT INTO ymp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Betha hôthông paling nena ya hîtôm ya nang êndêng Wakamik me ketheng oyang me tem nêŋgêv aŋêla vovak ondong lauming be lahavôyi me doho êyômô imbing be êlêm vo êŋgêv ya livung. ");
INSERT INTO ymp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Metom ya havong bêng me ambô atu be bôk hêk Wapômbêng ya Kapua tem mî niŋgik anông amî. Be ditu nôm takêng tem nimbutak bêng hîtôm Wapômbêng ya Kapua henang.” ");
INSERT INTO ymp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yôv me Yisu henang ethak avîlanô nômbêng atu nena, “Bisê! Betha ya me anô kambom anông be ditu môlô uwa bîng vovak lêk ŋokyôhôk be ôlêm vo ombalong ya mesa? Wak nômbêng iti me ya handông avîlanô hîmô melak matheng ya popatîng kapô, me hevong bisê be mî môlômbalong ya amî? ");
INSERT INTO ymp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Metom nôm takiti lêk hivutak vo plopet ining ambô takatu be bôk ekavu tem niŋgik anông.” Êng me ya ŋa hîndông sapêng etak yêni be îsôv mayaliv be ê. ");
INSERT INTO ymp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ŋa takatu be evalong Yisu me iwa be ê Kaiapas, kwandôk bêng hîmbôk da ya melak popatîng. Long êng me kîdôŋga ambô balambung hiving avaka lêk ethak tom be îmô. ");
INSERT INTO ymp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Me Pita hesopa Yisu heveng yam, metom heveng dêim doke. Be hivutak êyô kwandôk bêng hîmbôk da ya bandêng kapô me hîlôk hîmô hiving kwak bidong vo ninjê nena ômbête tem nimbutak Yisu. ");
INSERT INTO ymp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Me ŋa bêŋbêng îmbôk da lêk kaŋso sapêng ethalo avîlanô doho vo îmbî ambô yôhîng ethak Yisu vo embong ambô ethak inda be iŋgik vônô. ");
INSERT INTO ymp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Me anô bêng anông êlêm be enang ambô yôhîng ethak yêni, metom loho mî êpôm Yisu ya kambom te vo iŋgik yêni vônô amî. Êng me anô lokwaŋyi îmô long êng be ê hêndêng long evong ambô ");
INSERT INTO ymp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","me enang nena, “Ôpiti bôk henang yôv nena, ‘Ya hîtôm ya seng Wapômbêng ya melak matheng thô be yandav ethak loŋbô îtôm wak lô yom.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Êng me kwandôk bêng hîmbôk da hiviyô heva me henang ik Yisu ling nena, “Ong ambô nonang viyang mî mesa? Hevong bisê hethak ambô ti be lêk enang ethak ong?” ");
INSERT INTO ymp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Metom Yisu bonong yom. Me kwandôk bêng hîmbôk da henang ethak inda nena, “Ya hanang hêndêng ong, hethak Wapômbêng lêkmala ya athêng me nonang ethak yoô nena ong Mesaya, Wapômbêng Nakandung mesa?” ");
INSERT INTO ymp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Me Yisu henang nena, “Hîtôm ditu lêk honang yôv. Metom ya hanang ethak môlô sapêng nena wak te êm ketem môlôŋgô Anô Ya Nakandung nêyômô Wapômbêng Lêkliŋyak Anông bang viyôhôk be nêlêm imbing mavông.” ");
INSERT INTO ymp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Me kwandôk bêng hîmbôk da helaŋô ambô êng me hêvôv ya kwêv kê be henang nena, “Lêk yôv! Ôpiti henang ambôma hethak Wapômbêng be lêk môlô laŋô yôv! Me bisête be aô leŋing iving andaŋô ambô doho imbing? ");
INSERT INTO ymp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Môlô ning auk bisête? Tem yambong ômbête ethak ôpiti?” Me loho enang nena, “Henang ambôma hethak Wapômbêng be ditu nema.” ");
INSERT INTO ymp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yôv me loho îsuvapôk ethak Yisu thohav lo ma me epeng yêni me doho epetav yêni ");
INSERT INTO ymp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","be enang nena, “Ong Mesaya, yôv be nonang ambô plopet iti, opalê diti hik ong?” ");
INSERT INTO ymp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita hîmô melak atu ya bandêng kapô me avî ku te hêlêm hêndêng yêni me henang nena, “Ong iti bôk hoveng hiving Yisu nang Galili.” ");
INSERT INTO ymp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Me Pita henang nena, “Ya hathông ambô tu be honang paling!” Me avîlanô takatu be îmô long êng elaŋô ambô êng. ");
INSERT INTO ymp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pita hê bandêng ambôlêk me avî ku yang hêyê me henang ethak avîlanô nena, “Ôpitu bôk heveng hiving Yisu nang Nasalet.” ");
INSERT INTO ymp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Me Pita henang ethak loŋbô nena, “Avanông bing dake! Ya hathông ôpêng paling!” ");
INSERT INTO ymp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yôv me ŋa takatu be eva bandêng kapô êlêm hêndêng Pita me enang nena, “Avanông bing nena ong me Yisu ya anô te, vômbê nena môlô ning ambô ya pôk me hîtôm tom.” ");
INSERT INTO ymp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Metom Pita henang nena, “Ya hanang avanông bing dake nena ya hathông ôpitu paling! Mî ya hanang ambô avanông amî, êng me Wapômbêng tem nêŋgêv vovang êndêng ya!” Bôlôtom me tale heleng. ");
INSERT INTO ymp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Me Pita la hêv ambô atu be Yisu henang ethak yêni nena, “Tale mî heleng amî denang me tem nonang îtôm bôlô lô nena hôthông ya paling.” Êng me Pita hele yêing me heleng bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hêndêng lêkbôk momaŋaning me ŋa bêŋbêng îmbôk da lêk avaka sapêng ethak tom me epatôk ambô vo iŋgik Yisu vônô. ");
INSERT INTO ymp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yôv me ekak bang luvi lêku me iwa be ê êv êndêng Pailat, Lom ining gavana atu be heyaŋging Judia. ");
INSERT INTO ymp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas ôpatu be hetak Yisu hîlôk ŋakyo baheŋing hêyê nena lêk evong ambô yôv vo iŋgik Yisu vônô. Êng me hele ya auk lîlîng be hê hêv valuseleng silva 30 takatu hêndêng ŋa bêŋbêng îmbôk da lêk avaka hethak loŋbô ");
INSERT INTO ymp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","me henang nena, “Lêk ya havong kambom be ya hatak ôpatu be kambom mî hîlôk môlô baheŋing.” Êng me loho nang nena, “Ong da yong malêing me mî yoô ning amî.” ");
INSERT INTO ymp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Me Judas hekaliv valuseleng silva takêng hêyô melak matheng ya popatîng me hê hevak lôk be hema. ");
INSERT INTO ymp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Me ŋa bêŋbêng îmbôk da ithup valuseleng silva takêng be enang nena, “Valuseleng iti me êv vo iŋgik anô vônô ethak. Bêng be mî mavî vo aô tak îmô imbing valuseleng melak matheng amî ndô.” ");
INSERT INTO ymp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Me loho epatôk ambô vo êŋgêv anô hepesang wîng yôhôk ya pîk bôte vuli vo thak lohondav avîlanô long bôyang injêk. ");
INSERT INTO ymp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Be ditu heveng hele be hêyô lêk me avîlanô elam long êng thêthô nena “Pîk Lêkma Heŋgathô”. ");
INSERT INTO ymp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Be ditu ambô ti lêk hik anông hîtôm plopet Jelemaia bôk henang yôv nena, “Loho iwa valuseleng be êv anô hepesang wîng ya pîk bôte vuli hîtôm sêmbôk be Wapômbêng henang ethak ya. Valuseleng êng me avîlanô Islael etak vo êŋgêv yêni vuli ethak.” ");
INSERT INTO ymp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yisu heva gavana Pailat mandaluk me Pailat henang nena, “Ong me ŋa Juda ning king mesa?” Me Yisu henang nena, “Hîtôm ditu ong da honang.” ");
INSERT INTO ymp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ŋa bêŋbêng îmbôk da lêk avaka îmbî Yisu liŋkôpik ethak ambô lomaloma metom mî henang viyang amî. ");
INSERT INTO ymp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Êng me Pailat henang nena, “Betha mî holaŋô loho ning ambô takatu be enang ethak ong amî e?” ");
INSERT INTO ymp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Metom yêni bonong yom me mî henang ya ambô viyang amî, be ditu Pailat hesong kambom. ");
INSERT INTO ymp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Waklavông Hêv Lîlîng nômbêng iti me avîlanô thak elam anô kalaondong te ya athêng vo Pailat êŋgêv vê. Me Pailat thak hêv ôpêng vê. ");
INSERT INTO ymp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hêndêng sondakbêng êng me anô te be ya athêng nena Yisu Balabas hîmô kalaondong. Be avîlanô bêng anông eyala ôpêng. ");
INSERT INTO ymp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Êng me avîlanô sapêng ethak tom me Pailat henang ik loho ling nena, “Môlô lemim êv ya tak opalête vo nêthôk êndêng môlô? Yisu Balabas mesa Yisu atu be elam nena Mesaya?” ");
INSERT INTO ymp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat henang bêng vômbê nena heyala loho ning auk leŋiŋdang atu be etak Yisu hîlôk yêni bang. ");
INSERT INTO ymp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat helaŋô ambô denang me yanavî hêv ambô hêyô vo yêni nena, “Bokam ya hayê navîng te hethak ôpitu be ya hakô kambom, be ditu dô nombong nômate ethak anô thêthôp itu andô.” ");
INSERT INTO ymp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Metom ŋa bêŋbêng îmbôk da lêk avaka îlôk avîlanô leŋing vo endam ethak Pailat vo netak Balabas ende yêing me iŋgik Yisu vônô. ");
INSERT INTO ymp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Me Pailat henang ik loho ling hethak loŋbô nena, “Môlô lemim êv ya tak anô yi ti yang sê?” Me avîlanô elam nena, “Balabas!” ");
INSERT INTO ymp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Me Pailat henang ik loho ling hethak loŋbô nena, “Yôv be tem yambong ômbête ethak Yisu atu be elam nena Mesaya?” Me sapêng elam nena, “Uŋgik vônô ethak alovalasing!” ");
INSERT INTO ymp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Me Pailat henang nena, “Vômbête? Yêni hevong ômbête kambom?” Metom loho elam lêklala hethak loŋbô nena, “Uŋgik vônô ethak alovalasing!” ");
INSERT INTO ymp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat helaŋô loho ning kaêk êng me hêyê nena vovak bêng hevong imbutak be yêni mî hîtôm nembong nômate amî. Êng me hiwa ŋanam be hithik bang heva avîlanô maleŋing be henang nena, “Ôpiti hema me ya lêkma tem mî nendahalîng long ethak ya baheng amî! Me môlô da ning malêing.” ");
INSERT INTO ymp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Me avîlanô sapêng enang viyang nena, “Ditu yôv! Ôpêng ya lêkma tem nendahalîng ethak yoô lêk yoô ning sêik lêkmuk baheŋing!” ");
INSERT INTO ymp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Êng me Pailat hetak Balabas be hê. Me henang be evali Yisu hethak yak lêklilu yôv me hetak hîlôk ŋa vovak baheŋing vo iŋgik vônô ethak alovalasing. ");
INSERT INTO ymp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gavana Pailat ya ŋa vovak iwa Yisu be ê ya melak bandêng kapô. Me ŋa vovak sapêng êlêm ethak tom be ekalambu yêni thing. ");
INSERT INTO ymp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Me îmbî ya kwêv thô me iwa kwêv lêkma dêim te hîtôm king ining kwêv be ik îlôk yêni. ");
INSERT INTO ymp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Me iwa yak lêklilu atu be epesang hîtôm king ining kwakdam me ik hîlôk kwandôk. Me etak kôm hîlôk yêni bang viyôhôk be hevalong hîtôm king ining kwanding. Me loho eya veŋiŋbudum thîvô hethak yêni me enang ambôma nena, “Waklîvông mavî, ŋa Juda ning king!” ");
INSERT INTO ymp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yôv me îsuvapôk ethak yêni me iwa kwanding atu be ik kwandôk ethak. ");
INSERT INTO ymp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Me enang ambôma hethak yêni yôvêm me îmbî kwêv lêkma atu thô me ik yêni da ya kwêv dêim hîlôk loŋbô. Me iwa yêni be ê vo iŋgik vônô ethak alovalasing. ");
INSERT INTO ymp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Loho iwa be ê me êpôm anô Sailini te be ya athêng nena Saimon hîlôk loŋdaŋlê. Me îpôvîng ôpêng vo nimbua Yisu ya alovalasing. ");
INSERT INTO ymp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Êng me loho ê êyô long te be ya athêng nena Golgota. Athêng êng ya ondong nena Long Kwandôk Lokwang. ");
INSERT INTO ymp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Long êng me loho iwa waing be isuvuling hiving nôm maning te me êv hêndêng yêni vo ninum. Metom hinum doke yom me maning be hêndô. ");
INSERT INTO ymp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yôv me loho ik yêni long hethak alovalasing yôv me îmbî valu vo injê nena opalê tem nimbua ya thôp. ");
INSERT INTO ymp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yôv me îlôk îmô long êng be eyaŋging inda. ");
INSERT INTO ymp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yêni kwandôk viling me ekavu ambô atu be evong ambô hethak inda bêng nena, ÔPITI ME YISU, ŊA JUDA NING KING ");
INSERT INTO ymp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Me êthôkêng anô vanî lokwaŋyi hiving. Be yang heva Yisu bang viyôhôk me yang heva bang vikeng. ");
INSERT INTO ymp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Me avîlanô takatu be elom loŋdaŋlê êng evali luŋiŋkwandôk be enang ambôma hethak yêni ");
INSERT INTO ymp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","be enang nena, “Ong atu be honang nena tem noseng melak matheng thô be nondav ethak loŋbô îtôm wak lô yom e? Yôv be nôŋgêv ong da livung! Ong Wapômbêng Nakandung, êng me notak alovalasing be nôlêm pîk!” ");
INSERT INTO ymp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung lêk avaka enang ambôma hiving nena, ");
INSERT INTO ymp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ôŋgô! Bôk hêv avîlanô livung, metom mî hîtôm nêŋgêv yêni da livung amî vo? Yêni me Islael ining king e? Yôv me netak alovalasing be nêlêm pîk vo aôŋga be aôŋgêv imbing yêni! ");
INSERT INTO ymp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ôpêng hêv iving Wapômbêng, be ditu Wapômbêng la hiving, êng me tem nêŋgêv inda livung, vômbê nena henang bêŋiti, ‘Ya Wapômbêng Nakandung.’ ” ");
INSERT INTO ymp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Me anô vanî yi atu be eva alovalasing hiving yêni enang ambôma hiving. ");
INSERT INTO ymp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Waklîvông bing me momaŋaning hêyô pîk nômbêng iti sapêng vôv be hêk hele be hêyô wakma lô. ");
INSERT INTO ymp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bidong oyang wakma lô me Yisu helam kaêk lêkwaê nena, “Eloi, Eloi, lama sabatani?” Ambô êng ya ondong bêŋiti, “Yînîng Wapômbêng, yînîng Wapômbêng, bisête be hotak ya?” ");
INSERT INTO ymp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Me avîlanô takatu be eva long êng elaŋô ambô êng me enang nena, “Helam Elaija!” ");
INSERT INTO ymp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ketheng oyang me ŋa êng te hê me hiwa kapôk be hethong îlôk waing maning. Me hepatôk kapôk êng hethak ŋok te be hêv hêndêng yêni vo ninum. ");
INSERT INTO ymp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Me avîlanô vi enang nena, “Ôndô yôvêm! Endekeme Elaija tem nêlêm êŋgêv yêni livung ma.” ");
INSERT INTO ymp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Me Yisu helam kaêk lêkwaê hethak loŋbô me hetak dôhô be hê me hema. ");
INSERT INTO ymp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bôlôtom oyang kwak bêng atu be thak heva melak matheng vo heyang melak kapô kisi me hipupkê hê luvi hêk viling be hêyô tamu vimbing. Me duviyang bêng hêv be valu bêŋbêng hipuk kethakê. ");
INSERT INTO ymp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Me kalang ambôlêk hikê be avîlanô matheng bêng anông tak sêmbôk be ema me iviyô hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hêndêng wakma Yisu hiviyô ethak loŋbô me ŋa iviyô takatu etak kalang be ê melak lông matheng Jelusalem be eveng yêing be avîlanô bêng anông êyê loho. ");
INSERT INTO ymp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Me anô vovak lêik lêk ŋa vovak takatu be eyaŋging Yisu hîmô êyê duviyang lêk nôm takatu be hivutak. Êng me loho êkô kambom be enang nena, “Avanông bing! Ôpiti me Wapômbêng Nakandung anông.” ");
INSERT INTO ymp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Me Malia nang Makdala lo Malia Jems loyang Josep ining talêmbô me Sebedi namalô luvi ning talêmbô, loho lêk avî bêng anông eva dêim doke be êyê. Avî takêng bôk etak Galili be eveng hiving Yisu vo êv yêni livung. ");
INSERT INTO ymp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Yathiŋdang me anô lêk valuseleng bêng te nang Alimatia be ya athêng nena Josep hêyô hêyê Pailat. Yêni me Yisu ya ŋa hîndông te be ditu hê me henang ethak Pailat nena, “Hîtôm yambua Yisu liŋkôpik mesa?” Êng me Pailat henang ethak ŋa vovak be loho ê iwa Yisu liŋkôpik be ê êv hêndêng inda. ");
INSERT INTO ymp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Me Josep hiwa Yisu liŋkôpik be hivuliv thing ethak kwak thapuk mambung te. ");
INSERT INTO ymp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Me hiwa Yisu liŋkôpik be hê me hetak hêk ya kalang lêkmuk te. Kalang êng me hekolop valu ambuang be hepesang vo netak ŋa ema injêk. Yôv me himbumbi valu bêng te be hele hik kalang ambôlêk thing ethak me hê. ");
INSERT INTO ymp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Me Malia nang Makdala lêk Malia yang îmô bidong oyang kalang be êyê hîmô. ");
INSERT INTO ymp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Waklavông epesang nômkama Sabat lêk hele be hê yôv. Me hiviyô heyang me ŋa bêŋbêng îmbôk da lêk Palisi ê vo injê Pailat. ");
INSERT INTO ymp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Me loho nang nena, “Anômbêng, yoô leŋing êv anô ambô yôhîng atu ya ambô hîmô lêkmala denang me henang bêŋiti, ‘Wak lô hele be hê me tem yambiyô ethak loŋbô.’ ");
INSERT INTO ymp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Be ditu nôŋgêv ŋa vovak bini vo eyaŋging kalang îtôm wak lô êng. Endekeme ya ŋa hîndông tem imbua liŋkôpik vanî me embatek avîlanô nena, ‘Lêk hiviyô hethak loŋbô hêk ŋama.’ Ambô yôhîng êng me tem bêng anông be nîmbô thak vo yang mung atu.” ");
INSERT INTO ymp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Êng me Pailat henang ethak loho nena, “Môlômbua ŋa vovak doho bunu me osopa môlô da ning auk be opesang kalang ambôlêk êng manjeng.” ");
INSERT INTO ymp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Êng me loho ê me ethang valu atu be hîmô kalang ambôlêk thing me ŋa vovak eyaŋging îmô. ");
INSERT INTO ymp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat hele be hê yôv me hêndêng sonda lêkbôk momaŋaning, sonda êng ya wak ali mung hêyô me Malia nang Makdala lo Malia yang ê vo injê kalang. ");
INSERT INTO ymp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Me Anômbêng ya aŋêla te hîlôk nang melak leng be hêlêm êyô me duviyang bêng te hêv. Me aŋêla êng himbumbi valu bêng atu be hîmô kalang ambôlêk vê be hêyô hîmô long. ");
INSERT INTO ymp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Me thohav lo ma hîtôm damak me ya kwêv thapuk anông. ");
INSERT INTO ymp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Me ŋa vovak êyê be êkô kambom be elowaling. Me êv yak îlôk êk hîtôm bôk ema yôv. ");
INSERT INTO ymp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Êng me aŋêla henang ethak avî yi êng nena, “Dô mamu kô andô. Ya hayala nena mamu othalo Yisu ôpatu be ik ethak alovalasing. ");
INSERT INTO ymp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yêni mî hêk long iti amî me lêk hiviyô hethak loŋbô hîtôm bôk be henang ethak môlô. Be ditu mamu lêm ôŋgô long atu be yêni hêk. ");
INSERT INTO ymp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yôv be mamu nu ketheng me onang ethak ya ŋa hîndông nena, ‘Lêk hiviyô hethak loŋbô hêk ŋama. Ondaŋô. Lêk himung be hê Galili. Be ditu môlô nu yô long êng me tem ôŋgô inda.’ Me lemim êŋgêv ambô atu be ya hanang. Ya halêm vo ya nang ambô tiêng êndêng môlô.” ");
INSERT INTO ymp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Avî yi êng elaŋô ambô êng be êkô, metom leŋing mavî anông hiving. Êng me thêi tak kalang be evothong ketheng be ê vo enang ambô êng ethak ya ŋa hîndông. ");
INSERT INTO ymp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ketheng oyang Yisu hêpôm thêi be henang nena, “Lêkbôk mavî mamu.” Êng me thêi ê evalong vakapô me êv yeng ethak yêni. ");
INSERT INTO ymp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yôv me henang nena, “Dô mamu kô andô me mamu nu me onang ethak yînîng aiyang loho vo loho ni Galili. Long êng me tem lohonjê ya.” ");
INSERT INTO ymp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Avî yi êng eveng denang me ŋa vovak takatu be eyaŋging kalang doho êyô Jelusalem. Me loho ê hêndêng ŋa bêŋbêng îmbôk da me enang kôkôthing ethak nômkama takatu be lêk hivutak. ");
INSERT INTO ymp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Me ŋa bêŋbêng îmbôk da lêk avaka ethak tom be evak ambô yôv me êv valuseleng bêng anông hêndêng ŋa vovak. ");
INSERT INTO ymp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Me loho nang ethak ŋa vovak nena, “Môlô nang bêŋiti ethak avîlanô nena, ‘Yoô aêkthôm be athông paling me Yisu ya ŋa hîndông êlêm hêndêng bîlîvông be iwa liŋkôpik vanî.’ ");
INSERT INTO ymp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Me gavana Pailat helaŋô kôkôthing êng me yoô da tem ana vo apesang ambô imbing yêni vo dô môlô utung malêing andô.” ");
INSERT INTO ymp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Me ŋa vovak iwa valuseleng me loho evong îtôm lêk enang. Be ditu ŋa Juda thak enang kôkôthing êng heveng hele be hêyô lêk. ");
INSERT INTO ymp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Êng me Yisu ya ŋa hîndông lauming be lahavôtom ê êyô Galili ya dum atu be bôk henang yôv nena loho ni. ");
INSERT INTO ymp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wakma loho yê Yisu, êng me êv yeng ethak yêni, metom doho ning auk yi be leŋing êv nena, “Yisu diti mesa?” ");
INSERT INTO ymp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Êng me Yisu hêlêm bidong me henang ethak loho nena, “Wapômbêng bôk hêv athêng bêng hêndêng ya vo ya hayaŋging nômkama leng lêk pîk sapêng. ");
INSERT INTO ymp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bêng be môlô nu pîk nômbêng iti sapêng me môlôndông avîlanô vo imbutak îtôm yînîng ŋa esopa ya. Me uthik loho îndôk ŋanam ethak Lambô ya athêng me Nakandung ya athêng me Lovak Matheng ya athêng. ");
INSERT INTO ymp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Me môlôndông loho vo esopa ambô nômbêng atu be bôk ya hêv hêndêng môlô yôv. Ondaŋô! Tem ya mô imbing môlô îtôm wak nômbêng iti sapêng endebe pîk lo leng yandang.”");
INSERT INTO ymp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mung anông me Ambô Mavî tiêng me hethak Wapômbêng Nakandung Yisu Kilisi. ");
INSERT INTO ymp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hîtôm Wapômbêng bôk henang ethak Nakandung Yisu Kilisi be plopet Aisaia bôk hekavu nena, “Nondaŋô! Tem yaŋgêv yînîng anô ku te vo nenang yînîng ambô bêng imung vo ong, me tem nepesang loŋdaŋlê vo ong. ");
INSERT INTO ymp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Me kaêk te hêlêm nang long thiliv nena, ‘Opesang loŋdaŋlê vo Anômbêng tem nêlêm, me opesang be nimbutak thêthôp vo yêni.’ ” ");
INSERT INTO ymp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Be ditu Jon Anô Hithik Avîlanô hê hîmô long thiliv be henang vo avîlanô ende kapôlôŋing lîlîng be ithik ŋanam vo Wapômbêng tem nêŋgêv loho ning kambom vê. ");
INSERT INTO ymp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Me avîlanô Judia lo Jelusalem sapêng elom êk be ê hêndêng yêni. Be enang ining kambom bêng me Jon hithik loho hîlôk ŋanam Yelodan. ");
INSERT INTO ymp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon me anô thak hik kwêv atu be epesang hethak bok kamel vuluk me hevak bokgôp hêyô hêk landong. Me thak heyang kômsopek lêk hinum biyo thôk. ");
INSERT INTO ymp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Me henang nena, “Ôpatu be tem nembeng ya yam, ya lêklokwang me lêkwaê anông vo yînîng. Yêni me anô lêk athêng bêng me ya me yaônalêk be ditu mî hîtôm ya kum be ya pole ya vakapô bokgôp ya yak vê amî. ");
INSERT INTO ymp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ya hathik môlô hethak ŋanam metom yêni tem nithik môlô ethak Lovak Matheng.” ");
INSERT INTO ymp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wak te me Yisu hetak Nasalet nang Galili be hê hêyô me Jon hithik yêni hîlôk ŋanam Yelodan. ");
INSERT INTO ymp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yisu hiviyô hêk ŋanam kapô me hêyê leng hikê me Lovak Matheng hîlôk be hêlêm vo yêni hîtôm menak bôbô te. ");
INSERT INTO ymp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Me ambô te hêlêm nang leng nena, “Ong me yînîng Wakna atu be ya leng hiving be ya leng mavî anông hethak ong.” ");
INSERT INTO ymp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Me ketheng oyang me Lovak Matheng hêv Yisu vê be hê long thiliv. ");
INSERT INTO ymp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Me hîmô long êng hîtôm wak buŋdaluk yi, êng me Sakdang hêyô be heyek yêni. Yêni hîmô hiving alim bomang metom thak aŋêla eyaŋging yêni. ");
INSERT INTO ymp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Etak Jon hîlôk kalaondong, êng me Yisu hê Galili be henang Wapômbêng ya Ambô Mavî bêng nena, ");
INSERT INTO ymp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Wakma lêk hêyô yôv be Wapômbêng ya lêkliŋyak bêng lêk bidong oyang. Be ditu onde kapôlômim lîlîng be ôŋgêv imbing Wapômbêng ya Ambô Mavî!” ");
INSERT INTO ymp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yisu hivup ethak kasîk bomang nang Galili ya liŋdang me hêyê Saimon loyang Endulu. Thêi me ŋa ik alim ŋanam be ditu ekaliv lek heveng kasîk bomang. ");
INSERT INTO ymp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Me Yisu henang ethak thêi nena, “Mamu lêm osopa ya! Tem yandông mamu vo ômbôv avîlanô îtôm ôvôv alim hîlôk lek.” ");
INSERT INTO ymp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bôlôtom oyang me thêi êndô ning lek îmô me esopa inda. ");
INSERT INTO ymp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yisu hivup ethak vauyaŋna me hêyê Jems loyang Jon. Thêi me Sebedi namalô luvi be îmô ning yeng be indi ining lek titip. ");
INSERT INTO ymp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Me bôlôtom oyang me helam thêi, êng me etak thêi ning kamik Sebedi hîmô yeng hiving ya ŋa ku me thêi ê esopa yêni. ");
INSERT INTO ymp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Me Yisu loho ê êyô Kapenaom be îmô. Me Islael ining waklavông thak iwa lovak elam nena Sabat hêyô be ditu Yisu hê Islael ining melak yeng vo hîndông avîlanô. ");
INSERT INTO ymp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Avîlanô elaŋô be esong kambom ethak ya ambô atu be hîndông loho vômbê nena, yêni hîndông loho hîtôm anô lêk athêng bêng. Me mî hîtôm loho ning kîdôŋga ambô balambung amî. ");
INSERT INTO ymp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Me anô te hîmô Islael ining melak yeng êng be gôk lêlêik hîmô hiving yêni be helam nena, ");
INSERT INTO ymp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yisu nang Nasalet, hôlêm vo nombong ômbête ethak yoô? Hôlêm vo numbuling yoô mesa? Ya hayala ong. Ong Wapômbêng ya Anô Matheng.” ");
INSERT INTO ymp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Me Yisu hethang gôk kambom êng lêklokwang be henang nena, “Ong bonong me notak ôpitu!” ");
INSERT INTO ymp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Me gôk lêlêik atu hîlônîng ôpêng kambom anông be hesaŋiyak me hetak ôpêng be hê. ");
INSERT INTO ymp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Me avîlanô sapêng esong kambom be enang ethak i nena, “Ômbête tiêng? Ôpiti hîndông auk lêkmuk hîtôm anô lêk athêng bêng. Be ya ambô me lêkliŋyak be gôk lêlêik elaŋô be esopa.” ");
INSERT INTO ymp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Be ditu Yisu ya kôkôthing êng hevothong eveng Galili ning long sapêng. ");
INSERT INTO ymp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Me bôlôtom me Yisu loho tak Islael ining melak yeng be ê Saimon lo Endulu ning melak. Me Jems lo Jon ê hiving. ");
INSERT INTO ymp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Êyô melak me loho nang ethak Yisu nena Saimon yaŋavî tu be hevong kômbôk vovang be hêk. ");
INSERT INTO ymp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Êng me Yisu hê hêyô vo avî êng me hevalong bang be hendandi hiviyô. Me kômbôk êng hetak yêni me hiviyô be hepesang nôm vo loho. ");
INSERT INTO ymp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wak ê hîlôk me avîlanô iwa ŋa lêk kômbôk lêk ŋa takatu be gôk kambom hivuling loho be ê êyô vo Yisu. ");
INSERT INTO ymp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Lêk avîlanô melak lông êng sapêng êlêm iving be îmô melak atu ya popatîŋlîvông. ");
INSERT INTO ymp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Êng me Yisu hevong avîlanô takatu be iwa kômbôk lomaloma bêng anông ivutak mavî. Lêk hêv gôk kambom bêng anông vê hiving. Gôk kambom takêng eyala nena yêni me opalê be mî hetak loho vo enang ambô amî. ");
INSERT INTO ymp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lêkbôk momaŋaning mî denang me Yisu hiviyô be hê long thiliv vo neteng mek. ");
INSERT INTO ymp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Me Saimon loho ê ethalo yêni heveng. ");
INSERT INTO ymp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Êpôm yêni me enang nena, “Avîlanô sapêng ethalo ong eveng.” ");
INSERT INTO ymp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Me Yisu henang nena, “Aô na bôyang. Aô na melak lông takatu be hîmô bidong vo ya nang Wapômbêng ya ambô êndêng loho imbing. Hethak ondong êng yom be diti ya halêm.” ");
INSERT INTO ymp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Me Yisu heveng Galili ning long sapêng be henang Wapômbêng ya ambô hîmô ning Islael ining melak yeng lêk hêv gôk kambom bêng anông vê hêk avîlanô. ");
INSERT INTO ymp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Me anô kômbôk lepla te hê hêyô vo Yisu me heya vabudum thîvô me hepetenak Yisu be henang nena, “Hethak ong da yong lem hiving me nombong be yambutak mavî.” ");
INSERT INTO ymp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Me Yisu lahiki hethak ôpêng be hetak bang hêyô hêk yêni me henang nena, “Ya leng êv numbutak mavî.” ");
INSERT INTO ymp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Êng me palê lepla êng hêyôv be liŋkôpik hivutak mambung. ");
INSERT INTO ymp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Me Yisu hêv ôpêng be hê bôlôtom me henang lêklokwang hethak yêni nena, ");
INSERT INTO ymp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Dô nonang nôm iti bêng ethak anô te andô. Metom nu me nuŋgik ong thô êndêng anô hîmbôk da me nôŋgêv da êndêng Wapômbêng vo niŋgik thô nena lêk huvutak mambung hîtôm Moses bôk henang yôv. Hovong bêng me tem avîlanô sapêng injê be eyala nena lêk huvutak mambung.” ");
INSERT INTO ymp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Metom ôpêng mî hesopa Yisu ya ambô sapêng amî. Mî, henang bêng be kôkôthing êng hê mayaliv. Be ditu Yisu mî hîtôm ni melak nenanena amî. Me hê heveng long thiliv me avîlanô êlêm nang luvuluvu be êyô vo injê yêni. ");
INSERT INTO ymp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wak doho hele be hê yôv me Yisu hê Kapenaom hethak loŋbô me avîlanô elaŋô nena Yisu lêk hêyô ya long. ");
INSERT INTO ymp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Êng me avîlanô bêng anông êlêm êyô be melak kapô putup me melak ambôlêk vi yêing putup bêng yom. Me Yisu henang Wapômbêng ya ambô hethak loho. ");
INSERT INTO ymp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Me anô doho iwa anô himuving te be êlêm be anô lokwaŋva evak umbam. ");
INSERT INTO ymp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Avîlanô bêng anông be long putup be mî hîtôm imbua ôpêng bini melak kapô vo Yisu amî. Be ditu ethak melak vôv me êŋgô melak vôv ambuang be îlîlô ôpêng lêk yêm hîlôk hele be hivup vo Yisu. ");
INSERT INTO ymp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yisu hêyê loho ning êv iving me henang ethak anô himuving atu nena, “Yînîng wakna, lêk ya hêv yong kambom sapêng vê.” ");
INSERT INTO ymp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Me kîdôŋga ambô balambung doho îmô hiving be leŋing êv nena, ");
INSERT INTO ymp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bisête be ôpiti henang ambôma bêng vo? Ôpêng hesong nena yêni me Wapômbêng mesa? Anô te mî hîtôm nêŋgêv kambom vê amî me Wapômbêng yom.” ");
INSERT INTO ymp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Me bôlôtom me Yisu heyala loho ning auk be henang nena, “Bisête be môlô lemim ik am hethak ambô tiêng? ");
INSERT INTO ymp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ambô alête vumeng vo ya nang ethak anô himuving iti: ‘Lêk ya hêv yong kambom vê’ mesa, ‘Numbiyômba me numbua yong yêm be nombeng’? ");
INSERT INTO ymp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bêng be tem yaŋgik thô ethak môlô nena Anô Ya Nakandung atu ya athêng me bêng hêk pîk be hîtôm nêŋgêv kambom vê.” Yôv me henang ethak anô himuving atu nena, ");
INSERT INTO ymp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ya hanang ethak ong nena numbiyômba be numbua yong yêm be nu yong melak.” ");
INSERT INTO ymp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Êng me ôpêng hiviyô nang loho lîvông be hiwa ya yêm me hele yêing be hê. Avîlanô esong kambom be êv Wapômbêng ya athêng ling be enang nena, “Bôk mî yoôŋga nômate bêŋiti amî!” ");
INSERT INTO ymp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yôv me Yisu hîvô hê kasîk bomang ya dang hethak loŋbô. Me avîlanô bêng anông êyô be yêni hîndông loho. ");
INSERT INTO ymp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yêni hivup ethak me hêyê Livai Alpius nakandung hîmô melak iwa takis. Me henang nena, “Nôlêm osopa ya.” Êng me hiviyô be hê hesopa yêni. ");
INSERT INTO ymp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yisu heyang nôm hiving Livai hîmô ya melak. Me ŋa iwa takis lêk ŋa evong kombom kambom bêng anông êyô be eyang nôm hiving yêni lêk ya ŋa hîndông vômbê nena loho bêng anông esopa Yisu. ");
INSERT INTO ymp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Me Palisi takatu be kîdôŋga ambô balambung êyê me enang ik ya ŋa hîndông ling nena, “Yisu heyang nôm hiving ŋa iwa takis lêk ŋa evong kombom kambom vo?” ");
INSERT INTO ymp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yisu helaŋô loho ning ambô me henang nena, “Ŋa lêk kômbôk yom ditu thak ê êyê dokta. Me ŋa kômbôk mî me mî. Me bêng yom ya halêm vo yandam ŋa takatu be evong kombom kambom. Me mî ya halêm vo yandam ŋa thêthôp amî.” ");
INSERT INTO ymp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wak te me Jon ya ŋa hîndông lêk Palisi esopa ining kombom itip ethak nôm vo leŋing êv Wapômbêng. Me avîlanô doho êyô vo Yisu me enang ik ling nena, “Jon lêk Palisi ining ŋa îndông itip ethak nôm me yong mî vo?” ");
INSERT INTO ymp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Me Yisu henang nena, “Anô te hiwa avî lêkmuk, êng me ya vathi tem injang nôm lêk leŋing mavî. Me tem mî hîtôm itip ethak nôm amî. ");
INSERT INTO ymp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Metom wakma atu be iwa yêni vê hêk loho, êng me loho tem itip ethak nôm. ");
INSERT INTO ymp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Anô te hîtôm nimbua thôp lêkmuk bôte be nindi thôp bôô ya ambuang thing ethak amî. Hevong bêng me tem thôp lêkmuk tem nîmô thôp bôô bô êng kê. Êng me tem nitip bêng. ");
INSERT INTO ymp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Me anô te mî thak hêkê waing lêkmuk hîlôk boksipsip ya kôpik bôô amî. Hevong bêng me tem waing lêkmuk nimbuling bok kôpik bôô atu be nipupkê be waing eŋgathô ni. Bêng be ditu thak êkê waing lêkmuk hîlôk bok kôpik lêkmuk atu be belap vo ninding mavî me mî hîtôm nipupkê amî lêk waing mî neŋgathô ni amî.” ");
INSERT INTO ymp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat te me Yisu lêk ya ŋa hîndông ê eveng kukapô te be ya loho iwa wit va doho vo injang. ");
INSERT INTO ymp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Me Palisi enang ethak Yisu nena, “Nondaŋô! Ambô balambung henang nena Sabat me mî hîtôm aômbong ku be aômbua nôm be aôŋgang amî. Metom yong ŋa hôndông ivuling waklavông êng!” ");
INSERT INTO ymp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Me Yisu henang nena, “Bôk môlô sam ambô hethak Devit lêk ya ŋa môlôô ema vo leŋing be evong bêng mesa mî? ");
INSERT INTO ymp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sêmbôk atu be Abiata hîmô hîtôm kwandôk bêng hîmbôk da me Devit hêyô Wapômbêng ya melak matheng kapô be heyang polom atu be mî hîtôm ŋa paling injang amî. Polom êng me ŋa îmbôk da yom ining vo injang. Metom hêv doho vo ya ŋa eveng iving inda be eyang iving. Be ditu loho vuling ambô balambung bô êng.” ");
INSERT INTO ymp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Me Yisu henang ethak loho nena, “Wapômbêng hepesang Sabat vo nêŋgêv avîlanô livung me mî hepesang avîlanô vo êŋgêv Sabat livung amî. ");
INSERT INTO ymp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bêng be Anô Ya Nakandung atu me Sabat ya Alang.” ");
INSERT INTO ymp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Me Yisu hivutak êyô Islael ining melak yeng kapô hethak loŋbô. Me anô bang bôk hema te hîmô melak êng kapô. ");
INSERT INTO ymp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Me ŋa takatu be ethalo loŋdaŋlê vo enang Yisu bêng îmô me êyê yêni nena tem nembong ôpêng mavî êndêng Sabat mesa mî. ");
INSERT INTO ymp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yôv me Yisu henang ethak ôpatu be bang hema nena, “Numbiyômba vo avîlanô sapêng injê ong.” ");
INSERT INTO ymp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yôv me henang ik loho ling nena, “Hîtôm aômbong ômbête vo aô sopa balambung Sabat? Hîtôm aômbong mavî mesa aômbong kambom? Hîtôm aôŋgêv avîlanô livung vo îmô lêkmala mesa aôŋgik loho vônô?” Metom loho sapêng bonong. ");
INSERT INTO ymp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Me Yisu la maning be hêyê loho kôlîlîng hêwê heveng lêk la malêing hethak loho evasing kapôlôŋing. Yôv me henang ethak ôpatu nena, “Noto bahem.” Me ôpêng heto bang me bang êng hivutak mavî hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yôv me Palisi ele yêing me ethak tom hiving avîlanô Islael vi atu be esopa Helot. Me evak ambô vo êpôm loŋdaŋlê te vo iŋgik Yisu vônô. ");
INSERT INTO ymp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Me Yisu lêk ya ŋa hîndông etak long êng be ê kasîk bomang ya dang me avîlanô Galili bêng anông esopa yêni. ");
INSERT INTO ymp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Avîlanô nang Judia me Jelusalem me Idumia me ŋanam Yelodan vi vulu lêk Taia me Saidon, bêng anông elaŋô nôm takatu be Yisu hevong be ditu êlêm vo injê yêni. ");
INSERT INTO ymp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Me Yisu hêyê avîlanô bêng anông be henang ethak ya ŋa hîndông nena êpôm yeng te yaping vo avîlanô endambu yêni thing me tem nethak yeng êng be nîmô. ");
INSERT INTO ymp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Vômbê nena bôk hevong avîlanô lêk kômbôk bêng anông mavî be ditu avîlanô takatu be evong kômbôk denang loho lêklokwang vo êthôm yêni. ");
INSERT INTO ymp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Me gôk lêlêik êyê yêni be êv yak îlôk êk yêni mandaluk be eleng lêklala nena, “Ong Wapômbêng Nakandung.” ");
INSERT INTO ymp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Metom Yisu henang lêklokwang hethak loho vo dô enang yêni bêng ethak avîlanô andô. ");
INSERT INTO ymp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Me Yisu hethak dum te be hê me helam ŋa takatu be yêni la hiving be êlêm hêndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Me hîtôk anô hîtôm lauming be lahavôyi me helam loho nena aposol. Yêni hetak loho vo îmô imbing yêni lêk nêŋgêv loho bini vo enang Wapômbêng ya ambô bêng. ");
INSERT INTO ymp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Me yêni la hiving nêŋgêv lêklokwang êndêng loho vo êŋgêv gôk kambom lomaloma vê. ");
INSERT INTO ymp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Diti me anô lauming be lahavôyi takatu be Yisu helam loho: Saimon, ôpatu be Yisu helam nena Pita me ");
INSERT INTO ymp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems loyang Jon, thêi ning lambô me Sebedi. Me helam thêi nena Boanegis. Boanegis ya ondong nena kakali nali. ");
INSERT INTO ymp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Me Endulu lo Pilip me Batolomiu lo Matyu me Tomas lo Jems Alpius nakandung me Tadius lo Saimon, Selot ining anô te ");
INSERT INTO ymp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","me Judas Iskaliot, ôpatu yôv ketem nenang Yisu bêng. ");
INSERT INTO ymp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yôv me Yisu lêk ya ŋa hîndông ê êyô melak te kapô me avîlanô bêng anông êyô be ekalambu loho thing hethak loŋbô hele be mî hîtôm injang nôm amî. ");
INSERT INTO ymp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Me Yisu ya avîlanô elaŋô ambô hethak nôm êng be êlêm vo imbua yêni bini vo eyaŋging vômbê nena enang bêng nena ya auk molo. ");
INSERT INTO ymp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kîdôŋga balambung nang Jelusalem îlôk be êlêm me enang nena, “Belsebul hîmô hiving yêni! Be ditu thak hêv gôk kambom vê hethak gôk kambom ining anômbêng Belsebul ya lêklokwang.” ");
INSERT INTO ymp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yôv me Yisu helam loho lêm ethak tom me henang ambô dôhô doho hethak loho nena, “Sakdang hîtôm nêŋgêv Sakdang da vê mesa? ");
INSERT INTO ymp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mî, me avîlanô melak lông bêng te evak i kê hê ondong yi, êng me tem nêŋgêv yak. ");
INSERT INTO ymp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lêk avîlanô ondong te evak i kê hê ondong yi, êng me tem nêŋgêv yak bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Me Sakdang da hevak i kê hê ondong yi be hevong vovak hiving yêni da, êng me tem nêŋgêv yak vômbê nena ya lêklokwang lêk êv yak yôv. ");
INSERT INTO ymp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ondaŋô ambô te imbing. Anô te hîtôm nimbutak êyô anô lêklokwang te ya melak kapô be nimbua ya nômkama vanî? Mî anông! Ôpêng embalong anô lêklokwang êng be nekak lêku êm, êng me yêni hîtôm nimbua ya nômkama vanî. ");
INSERT INTO ymp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ya hanang avanông ethak môlô nena Wapômbêng tem nêŋgêv avîlanô ning kambom lomaloma lêk ambôma takatu be thak enang vê. ");
INSERT INTO ymp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Metom anô te hêyê Lovak Matheng ya ku be henang ambôma nena, ‘Diti me Sakdang ya ku’, êng me Wapômbêng mî hîtôm nêŋgêv kambom êng vê injêk ôpêng amî. Mî anông. Ya kambom êng tem ninjêk thêthô îtôm wak nômbêng iti sapêng.” ");
INSERT INTO ymp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yisu henang ambô takêng hethak ŋa takatu be enang nena gôk lêlêik hîmô hiving yêni. ");
INSERT INTO ymp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Me Yisu talêmbô lêk viyaŋi eleva yêing me êv ambô hê vo enang ethak Yisu nena nêlêm yêing. ");
INSERT INTO ymp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Avîlanô bêng anông ekalambu yêni thing be enang nena, “Lemtambô lêk aviyami eva yêing be leŋing iving injê ong.” ");
INSERT INTO ymp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Me Yisu henang ik ling nena, “Opalête me yînîng wakatik lêk yînîng aiyang?” ");
INSERT INTO ymp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Me Yisu hêyê avîlanô nômbêng atu be ekalambu yêni thing hêwê heveng me henang nena, “Avîlanô takatu be esopa Wapômbêng ya la hiving, ŋa êng me yînîng wakatik lêk aiyang me lîvô loho. Bêng be ditu môlô takiti me yînîng wakatik lêk aiyang loho.” ");
INSERT INTO ymp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Me Yisu hîndông avîlanô hethak loŋbô hîmô kasîk bomang ya dang. Be avîlanô bêng anông ekalambu yêni thing, êng me hethak yeng te be hê hîmô kasîk îmô bidong liŋdang me avîlanô eva liŋdang ivup ethak. ");
INSERT INTO ymp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Me hîndông loho hethak ambô dôhô bêng anông. Be henang nena, ");
INSERT INTO ymp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ondaŋô! Anô te hê hekaliv ya yaŋvêk hîlôk ya kukapô. ");
INSERT INTO ymp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ôpêng hekaliv yaŋvêk takêng me vi hîlôk loŋdaŋlê. Êng me menak êpôm be eyang. ");
INSERT INTO ymp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Me doho hîlôk pîk lêk valu be ditu hivutak ketheng oyang, vômbê nena pîk doke yom. ");
INSERT INTO ymp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wakma wak hîmbî hêyô hêk me tem nekapôk, vômbê nena ya galôk me bidong oyang. ");
INSERT INTO ymp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Me vi hîlôk long yak lêklilu kapô be yak êng hilumbak hêyô yaŋvêk takêng vôv. Be ditu mî yaŋvêk takêng hik anông amî. ");
INSERT INTO ymp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Metom vi hîlôk pîk mavî me hipup be hivutak bêng be hik ya anông. Doho hîtôm 30 me doho 60 me doho 100.” ");
INSERT INTO ymp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yôv me Yisu henang ethak loho nena, “Môlô ŋa lêk liŋdong me ondaŋô ambô ti katôyang!” ");
INSERT INTO ymp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Avîlanô nômbêng atu etak Yisu be ê, êng me yêni lêk ya ŋa hîndông lauming be lahavôyi me avîlanô takatu be eveng hiving yêni yom ditu loho mô. Me loho nang ik yêni ling ethak ambô dôhô takatu be henang ya ondong. ");
INSERT INTO ymp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Me Yisu henang nena, “Wapômbêng lêk hêv ya auk long kapô hethak ya lêkliŋyak neyaŋging avîlanô hêndêng môlô. Metom avîlanô vi atu be îmô yêing vo ya lêkliŋyak bêng, loho thak elaŋô ambô êng hethak ambô dôhô yom. ");
INSERT INTO ymp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Bêng be, “ ‘loho tem injê bêng anông, metom tem mî eyala amî. Me tem endaŋô ambô bêng anông, metom tem mî eyala ambô takêng ya ondong amî. Vo dô loho ende kapôlôŋing lîlîng be Wapômbêng êŋgêv loho ning kambom vê andô.’ ” ");
INSERT INTO ymp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Me Yisu henang ethak loho nena, “Môlô mî oyala ambô dôhô ti amî mesa? Yôv be tem môlôyala ambô dôhô vi bisête? ");
INSERT INTO ymp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Anô atu be hevatho yaŋvêk, êng me hîtôm yêni hevatho Wapômbêng ya ambô. ");
INSERT INTO ymp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Me avîlanô vi me hîtôm yaŋvêk atu be ekaliv hîlôk loŋdaŋlê. Ŋa takêng elaŋô Wapômbêng ya ambô, metom ketheng oyang me Sakdang hêyô be hêv ambô takatu be evatho hîlôk loho kapôlôŋing vê. ");
INSERT INTO ymp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Me avîlanô vi me hîtôm yaŋvêk ekaliv hîlôk long valu oyang. Elaŋô Wapômbêng ya ambô be êv iving ketheng lêk leŋing mavî. ");
INSERT INTO ymp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Metom mî hîmbî galôk amî be ditu eva vauyaŋna yom, vômbê nena wakma malêing lêk vovang hêpôm loho hethak Wapômbêng ya ambô. Êng me etak ining êv iving ketheng oyang. ");
INSERT INTO ymp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Me avîlanô vi hîtôm yaŋvêk ekaliv hîlôk long yak lêklilu kapô. Avîlanô takêng elaŋô Wapômbêng ya ambô, ");
INSERT INTO ymp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","metom loho leŋiŋhiki bêng anông hethak ining lêkmala pîk iti lêk valuseleng hêvôv loho be maleŋing daŋtang ethak nômkama lomaloma. Auk takêng ditu hithivung Wapômbêng ya ambô be loho mî ik anông amî. ");
INSERT INTO ymp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Me avîlanô vi me hîtôm yaŋvêk ekaliv hîlôk pîk mavî. Elaŋô be evalong long hêk loho kapôlôŋing. Doho hik anông hîtôm 30 me doho hîtôm 60 me doho 100.” ");
INSERT INTO ymp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Me Yisu henang ik loho ling nena, “Môlô thak ôtôm lam be othong hîlôk wîng kapô mesa uvung hîmô long kapô? Mî, môlô tôm be ôthôkêng hethak eva aling. ");
INSERT INTO ymp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nômkama nômbêng atu be hîmô long kapô, êng me yôv ketem nimbutak yêing. Me nômkama takatu be anô ivung hêk long kapô, êng me yôv ketem nimbutak yêing. ");
INSERT INTO ymp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Môlô ŋa lêk liŋdong me ondaŋô ambô ti katôyang!” ");
INSERT INTO ymp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yôv me Yisu henang nena, “Ambô takatu be môlô laŋô me lemim êŋgêv katô. Be ditu kombom alê atu be hôthô anô vi lelalîlîng, hethak kombom êng yom ditu tem Wapômbêng îthô ong lelalîlîng bêng yom me tem netak doho êyômô long imbing. ");
INSERT INTO ymp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ôpatu be heyala Wapômbêng ya ambô tem Wapômbêng êŋgêv auk bêng anông êndêng yêni. Metom ôpatu be mî heyala Wapômbêng ya ambô amî me ya auk mavî atu be bôk hîmô hiving yêni me Wapômbêng tem nêŋgêv vê.” ");
INSERT INTO ymp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Me Yisu henang nena, “Wapômbêng ya lêkliŋyak bêng me bêŋiti. Anô te hekaliv yaŋvêk hîlôk ya kukapô. ");
INSERT INTO ymp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Me thak hêk hêndêng bîlîvông me heveng hêndêng lêkwak. Metom yaŋvêk da hipup be hivutak bêng be anô êng mî heyala amî. ");
INSERT INTO ymp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","29","Pîk da hevong ya ku be yaŋvêk êng hipup be livuk hivutak me hîmbî ŋaung be hik va hêyô hîmô. Be ditu nôm takêng da hepesang i. Yôv me wakma hêyô be anô êng hiwa bîng be hele anông ethak, vômbê nena waklavông imbua anông hêyô.” ");
INSERT INTO ymp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Me Yisu henang nena, “Tem ya nang bisête ethak Wapômbêng ya lêkliŋyak bêng vo nêŋgêv auk êndêng môlô? Lêk ambô dôhô alê yang, ditu tem ya nang? ");
INSERT INTO ymp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wapômbêng ya lêkliŋyak me hîtôm alokwang va yaôna te be anô te hevatho hîlôk ya kukapô. Alokwang va êng me yaônalêk. ");
INSERT INTO ymp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Metom hevatho be hipup me hivutak lêkwaê vo nômkama kukapô vi. Be thaŋang me lêkwaê be ditu long kapô mavî vo menak endav ining melak îndôk be îmô.” ");
INSERT INTO ymp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Me Yisu thak henang ambô dôhô bêng anông bêng yom hethak avîlanô. Me hîndông loho hîtôm loho da ning auk vo endaŋô be eyala. ");
INSERT INTO ymp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Avîlanô bêng anông îmô hiving yêni, be ditu thak hîndông loho hethak ambô dôhô yom. Me waklavông yêni da lêk ya ŋa hîndông yom îmô, êng me thak henang ambô dôhô sapêng ya ondong bêng hethak loho. ");
INSERT INTO ymp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wak êng ya yathiŋdang hêmbôk me Yisu henang ethak ya ŋa hîndông nena, “Aô na kasîk bomang viyang vulu.” ");
INSERT INTO ymp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Êng me loho tak avîlanô nômbêng atu me ethak yeng atu be Yisu hîmô be ê. Me yeng doho ê hiving. ");
INSERT INTO ymp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Êng me lovak bêng te hêyô, be hiyuv ŋanam be ŋanam hivutak hîlôk yeng kapô, be hevong vo nembak yeng thethong. ");
INSERT INTO ymp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yisu hêyô hêk kwalim te hêk yeng landang be hêkthôm. Êng me ya ŋa hîndông êyô ik yêni ling be enang nena, “Kîdôŋga, mî lem iŋgik ong nena ŋanam tem nendok aô vônô amî mesa?” ");
INSERT INTO ymp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Êng me Yisu hiviyô me hethang ŋanam budum lêk lovak be henang nena, “Notaving be nôŋgwêk yaô!” Êng me lovak hema me ŋanam hêk tiŋeng. ");
INSERT INTO ymp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Me Yisu henang ethak ya ŋa hîndông nena, “Môlô kô vo? Mî môlô êv iving amî denang e?” ");
INSERT INTO ymp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Me ŋa êng elowaling kambom be enang ik loho da ling nena, “Ôpiti me anô alête be ditu ŋanam lêk lovak elaŋô ya ambô be esopa.” ");
INSERT INTO ymp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yisu lêk ya ŋa hîndông ê kasîk bomang viyang vulu me êyô avîlanô Gelasa ining pîk. ");
INSERT INTO ymp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Me yeng hethak liŋdang me Yisu hivup pîk. Êng me anô lêk gôk lêlêik te hêlêm nang kalang be hê hêndêng Yisu. ");
INSERT INTO ymp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yêni thak hîmô kalang be mî hîtôm anô te embalong yêninjêk amî. Me mî hîtôm ekak yêni long ethak yakseng amî. ");
INSERT INTO ymp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bôk evalong yêni lômbôlông be ekak va lo bang lêku hethak yakseng metom hêsô yakseng takêng kisi. Me anô te mî hîtôm nembalong ôpêng be nîmô tiŋeng amî, mî anông. ");
INSERT INTO ymp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Me wak lêk bîlîvông sapêng me hîmô be heveng kalang lêk dumlôlê me hesaŋiyak be heŋgothe liŋkôpik hethak valu. ");
INSERT INTO ymp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yêni hêyê Yisu hêlêm dêim denang, me hevothong be hê hêndêng Yisu me heya vabudum thîvô hîmô Yisu mandaluk. ");
INSERT INTO ymp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Me Yisu henang ethak ôpêng nena, “Gôk lêlêik, notak ôpiti be nu.” Me anô lêk gôk êng helam kaêk lêklala nena, “Yisu, Wapômbêng Leng Anông Bing Nakandung, hôlêm vo nombong ômbête ethak ya? Hethak Wapômbêng ya athêng me dô nôŋgêv vovang êndêng ya andô!” ");
INSERT INTO ymp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Êng me Yisu henang ik ôpêng ling nena, “Yong athêng bisê?” Me ôpêng henang nena, “Yînîng athêng nena Ŋa Vovak Yalimamôk, vômbê nena yoô me bêng anông.” ");
INSERT INTO ymp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Me yêni heteng Yisu lômbôlông nena, dô nêŋgêv loho vê injêk long êng andô. ");
INSERT INTO ymp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bok bêng anông eyang tak îmô dum te ya lîkînîng îmô bidong long êng. ");
INSERT INTO ymp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Me gôk kambom takêng epetenak Yisu nena, “Nôŋgêv yoô vê ni îndôk bok takdaku kapô.” ");
INSERT INTO ymp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Êng me Yisu hetak loho be ele yêing be ê îlôk bok takêng kapô. Me bok takêng evothong be ethak i mayaliv hîlôk wanda be êv yak hîlôk kasîk bomang be ŋanam helok sapêng vônô. Bok takêng me hîtôm 2,000. ");
INSERT INTO ymp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Me ŋa takatu be eyaŋging bok îsôv be ê enang bêng heveng melak lông lêk long yaô nenanena hiving. Êng me avîlanô ê vo injê nôm atu be lêk hivutak. ");
INSERT INTO ymp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Loho yô vo Yisu me êyê ôpatu be gôk kambom yalimamôk bôk îmô hiving yêni lêk hipuk kwak me ya auk lêk mavî be hîmô yôhôk. Êng me loho êkô kambom. ");
INSERT INTO ymp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Me ŋa takatu be êyê nôm êng, enang kôkôthing hêndêng avîlanô hethak ômbê atu be hêpôm anô atu be gôk kambom bôk hîmô hiving yêni, me enang kôkôthing ethak bok takatu be îlôk ŋanam be ema hiving. ");
INSERT INTO ymp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Êng me avîlanô eteng Yisu lêklokwang vo netak loho ning long bini bôyang. ");
INSERT INTO ymp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yôv me Yisu hethak yeng, me anô atu be gôk kambom bôk hîmô hiving yêni hepetenak inda nena, “Hîtôm ya thôk imbing ong mesa?” ");
INSERT INTO ymp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Metom Yisu mî hîlôk hethak ôpêng ya ambô amî be henang nena, “Nu yong long lêk yong avîlanô. Me nonang ethak loho ethak nômbêng atu be Anômbêng hevong ethak ong lêk lahiki hethak ong.” ");
INSERT INTO ymp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Êng me ôpêng hîvô hê ya long, me henang kôkôthing ethak nômbêng atu be Yisu hevong êndêng yêni heveng melak lông lauming atu be hîmô Dekapolis kapô. Me avîlanô long êng sapêng elaŋô be esong kambom. ");
INSERT INTO ymp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisu hethak yeng be hê kasîk bomang ya liŋdang viyang vulu hethak loŋbô. Me heva liŋdang, me avîlanô bêng anông ithup i hethak tom be ekalambu yêni thing. ");
INSERT INTO ymp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Me anômbêng heyaŋging Islael ining melak yeng te hêlêm, be ya athêng nena Jailus. Yêni hê hêyê Yisu me hêv yak hîlôk hêk Yisu va. ");
INSERT INTO ymp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Me henang lêk kapô malêing nena, “Yînîng avena tem nema. Be hîtôm nôlêm otak bahem êyônjêk yêni vo nimbutak mavî be nîmô lêkmala?” ");
INSERT INTO ymp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Êng me Yisu hê hiving yêni. Me avîlanô bêng anông esopa yêni be ekalambu yêni thing. ");
INSERT INTO ymp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Avî te hîmô long êng be hiwa kômbôk lêkma helom hêk hîtôm sondakbêng lauming be lahavôyi. ");
INSERT INTO ymp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dokta bêng anông evong vo êŋgêv yêni livung, metom loho mî hîtôm amî me êv vovang bêng êndêng yêni. Avî êng hêv ya valuseleng sapêng hêndêng loho, metom kômbôk êng mî hekapôk doke amî me hê bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Me bôk helaŋô kôkôthing hethak Yisu, be ditu hîlôk avîlanô nômbêng êng kapô, be heveng Yisu yam me hêthôm ya kwak dang. ");
INSERT INTO ymp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yêni la hêv nena, “Ya thôm ya kwêv yom me tem ya mavî.” ");
INSERT INTO ymp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hêthôm yom, me ketheng oyang me lêkma hekapôk me helaŋô nena malêing êng lêk hetak yêni. ");
INSERT INTO ymp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Me bôlôtom me Yisu helaŋô nena ya lêklokwang doho hêv yak. Êng me hik i lîlîng eva avîlanô takêng lîvông me henang nena, “Opalête hêthôm yînîng kwêv?” ");
INSERT INTO ymp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Me ya ŋa hîndông enang nena, “Hôyê avîlanô nômbêng iti be ekalambu ong thing be ithithiving ong me honang ik ling nena opalête hêthôm ong vo?” ");
INSERT INTO ymp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Metom Yisu hêyê hêwê heveng nena opalête ditu be hêthôm yêni. ");
INSERT INTO ymp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Me avî êng heyala nôm atu be hivutak yêni, be ditu hêkô be helowaling me hê heya vabudum thîvô hîmô Yisu va. Me henang nôm takêng bêng ethak yêni. ");
INSERT INTO ymp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Me Yisu henang ethak yêni nena, “Yînîng avena, yong hôêv iving hevong be lêk huvutak mavî. Nu lêk lem mavî. Yong kômbôk lêk hetak ong.” ");
INSERT INTO ymp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yisu henang ambô denang me anô doho êlêm nang Jailus ya melak, Jailus me anômbêng heyaŋging Islael ining melak yeng, be loho nang ethak yêni nena, “Nalum avî lêk hema yôv, be ditu notak kîdôŋga me dô nôŋgêv malêing êndêng yêni andô.” ");
INSERT INTO ymp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Metom Yisu hevong hîtôm mî helaŋô loho ning ambô amî be henang ethak Jailus nena, “Dô nôkô andô, nôŋgêv imbing yom.” ");
INSERT INTO ymp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yisu hêndô avîlanô ni imbing yêni be ditu hiwa Pita me Jems loyang Jon yom be loho ê hiving inda. ");
INSERT INTO ymp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Loho êyô Jailus ya melak me hêyê avîlanô eleng athêng malêng be pôk bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Êng me hê melak kapô me henang ethak loho nena, “Môlô leng be pôk hethak leng vo ômbête? Sêik iti me hêkthôm yom me mî hema amî.” ");
INSERT INTO ymp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Metom loho malîk ethak yêni. Me Yisu hêv loho vê be ele yêing be ê, me hiwa sêik êng talêmbô lo lambô, me ya ŋa hîndông lô atu yom iving yêni be ê melak kapô atu be sêik atu hêk. ");
INSERT INTO ymp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Me hevalong avena êng bang be henang ethak ambô Hiblu nena, “Talita kôm!” (Ambô êng ya ondong nena, “Yînîng avena, ya hanang ethak ong nena numbiyô.”) ");
INSERT INTO ymp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Me ketheng oyang me avena êng hiviyô be heveng. Yêni ya sondakbêng hîtôm lauming be lahavôyi. Loho yê be esong kambom. ");
INSERT INTO ymp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Me Yisu henang lêklokwang hethak loho nena, dô enang nôm êng bêng ethak avîlanô andô. Me henang nena, “Ôŋgêv nôm vo ninjang.” ");
INSERT INTO ymp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisu hetak long êng me hê ya melak ondong, me ya ŋa hîndông ê hiving. ");
INSERT INTO ymp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat hêyô me Yisu hê Islael ining melak yeng me hîndông avîlanô. Me avîlanô bêng anông elaŋô ya ambô be îpîndîk kambom be enang nena, “Ôpiti hiwa ambô lêk auk thêthôp takiti nang êsê be diti hevong nôm thamtham hethak? ");
INSERT INTO ymp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ôpiti me anô helav melak yom. Yêni me Malia nakandung me Jems lo Josep me Judas lo Saimon loho ning ali bêng. Me livi îmô long iti hiving aô.” Loho nang bêng, me îpôlîk ethak yêni. ");
INSERT INTO ymp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Me Yisu henang ethak loho nena, “Plopet hiwa athêng bêng hêk melak yang. Metom ya melak ondong lêk ya lêkma lêk ya avîlanô, me hîtôm anô athêng mî.” ");
INSERT INTO ymp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Be ditu Yisu mî hîtôm nembong nôm thamtham îmô long êng amî, me hetak bang hêyô hêk ŋa lêk kômbôk tomtom yom be ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Me Yisu hesong kambom hethak loho mî êv iving yêni amî. Me Yisu hê melak nenanena me hîndông avîlanô. ");
INSERT INTO ymp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Me helam ya ŋa hîndông lauming be lahavôyi hethak tom me hîmbî loho tham hê yiyi me hêv lêklokwang lêk athêng bêng hêndêng loho vo êŋgêv gôk lêlêik vê. Yôv me hêv loho be ê. ");
INSERT INTO ymp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Me Yisu henang ethak loho nena, “Ombalong môlô ning kôm kwanding yom. Me dô umbua nôma doho imbing hîtôm polom lêk vak be valuseleng imbing andô. ");
INSERT INTO ymp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Me uŋgik vemimkapô bokgôp yom, me dô umbua kwêv yi andô. ");
INSERT INTO ymp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Me ôyô melak te, me ômô melak êng yom endebe otak long êng bunu bôyang. ");
INSERT INTO ymp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Me long takatu be mî iwa môlô thô amî lêk êndô endaŋô môlô ning ambô, me waklavông atu be otak long êng, me uŋgik limbalôm takatu be hîmô vemimkapô vê îndôk loho maleŋing vo niŋgik loho ning kambom thô.” ");
INSERT INTO ymp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Êng me Yisu ya ŋa hîndông ê lomelak lomelak be enang vo avîlanô ende kapôlôŋing lîlîng. ");
INSERT INTO ymp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Me loho êv gôk kambom bêng anông vê lêk etak wel hethak avîlanô lêk kômbôk bêng anông be evong loho ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Helot Antipas helaŋô kôkôthing hethak Yisu ya ku takatu be bôk hevong vômbê nena avîlanô sapêng bôk eyala yêni katô. Doho enang nena, “Jon Anô Hithik Avîlanô ditu hiviyô lêkmala hethak loŋbô be hiwa lêklokwang be hevong nôm thamtham takêng.” ");
INSERT INTO ymp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Me vi enang nena, “Yêni me Elaija.” Me vi enang nena, “Yêni me plopet te hîtôm plopet taksêmbôk doho.” ");
INSERT INTO ymp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Metom Helot helaŋô ambô takêng be henang nena, “Jon, ôpatu be bôk ya handambêng lôkbudum kisi, lêk hiviyô hethak loŋbô!” ");
INSERT INTO ymp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Sêmbôk me Helot hiwa yang Pilip yanavî Helodias vanî. Be Jon henang ethak Helot nena, “Lêk huwa mamuyam yanavî vanî be ditu huvuling ambô balambung.” Êng me Helot hêv ambô hê vo embalong Jon. Me evalong yêni be evak lêku be etak hîlôk kalaondong. ");
INSERT INTO ymp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Me Helodias hevalong la maning long hethak Jon be la hiving iŋgik yêni vônô, metom mî hîtôm amî ");
INSERT INTO ymp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","vômbê nena Helot hêkô Jon. Yêni heyala nena Jon me anô matheng lêk anô thêthôp. Be ditu heyaŋging Jon mavî. Me thak helaŋô Jon ya ambô be hîthông nena tem nembong ômbête, metom la hiving bêng anông vo nendaŋô ya ambô. ");
INSERT INTO ymp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yôv me Helodias hêpôm loŋdaŋlê te. Helot hevong nôm bêng te vo laŋgêv ya waklavông talêmbô hevathu yêni. Be helam ya ŋa bêŋbêng takatu be thak êv yêni livung lêk ŋa vovak lêik ining avaka me ŋa bêŋbêng nang Galili. ");
INSERT INTO ymp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Loho eyang nôm îmô me Helodias nalavî hêyô be heloyeng be hevong Helot lêk ya ŋa bêŋbêng sapêng maleŋing mavî. Êng me king henang ethak avena êng nena, “Lem iving ômbête be honang ik ya ling me tem yaŋgêv êndêng ong.” ");
INSERT INTO ymp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Me Helot evak ambô manjeng te hiving yêni nena, “Ya hanang avanông bing dake nena honang ik ya ling hethak nômate vo yaŋgêv êndêng ong, êng me tem yaŋgêv yom. Me honang ethak ya vo yambak yînîng pîk lêk nômkama sapêng kê îndôk lîvông be yaŋgêv vi êndêng ong, êng me tem yambong bêng yom.” ");
INSERT INTO ymp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yôv me avena êng hê me henang ik talêmbô ling nena, “Tem ya nang bisête?” Me talêmbô henang nena, “Nonang nena, ‘Ya leng hiving Jon Anô Hithik Avîlanô kwandôk.’ ” ");
INSERT INTO ymp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Me avena êng hîvô hê ketheng me henang ethak king nena, “Ya leng hiving diti yom me notak Jon Anô Hithik Avîlanô kwandôk îndôk belev te be nôŋgêv êndêng ya.” ");
INSERT INTO ymp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Me king helaŋô ambô êng be hiwa la malêing bêng, metom la hêv ambô atu be lêk hevak hîlôk ŋa bêŋbêng maleŋing. Be ditu hêndô nenang nena mî. ");
INSERT INTO ymp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yôv me hêv ôpatu be thak hik anô vônô be hê vo nimbua Jon kwandôk be nêlêm. Ôpêng hê kalaondong me hendambêng Jon lôkbudum kisi. ");
INSERT INTO ymp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Me hetak îlôk belev te, me hiwa be hê hêv hêndêng avî voyavô atu. Me avî êng hiwa be hê hêv hêndêng talêmbô. ");
INSERT INTO ymp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Me Jon ya ŋa hîndông elaŋô ambô êng, me loho lêm iwa ya kôpik be ê elav hîlôk kalang valu ambuang. ");
INSERT INTO ymp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposol îvôlêm êyô vo Yisu hethak loŋbô me enang kôkôthing ethak nôm takatu be loho vong lo îndông. ");
INSERT INTO ymp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Me avîlanô bêng anông ê be êlêm be ditu Yisu lêk ya ŋa hîndông mî hîtôm injang nôm amî. Be ditu henang ethak ya ŋa hîndông nena, “Môlô yom ôlêm vo aô na long thiliv bôte vo ambua lovak.” ");
INSERT INTO ymp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Êng me loho da yom ethak yeng te be ê long thiliv bôte. ");
INSERT INTO ymp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Metom avîlanô bêng anông êyê loho be eyala loho. Be ditu avîlanô nang lomelak lomelak evothong be ê êyô long êng imung yôv kîmîng Yisu lêk ya ŋa hîndông êyô heveng yam. ");
INSERT INTO ymp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Me Yisu hethak liŋdang me hêyê avîlanô bêng anông lêk îmô hîtôm boksipsip takatu be alaŋi mî, be ditu lahiki hethak loho. Me hîndông loho hethak nômkama bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yathiŋdang hêyô me ya ŋa hîndông ê hêndêng yêni me enang nena, “Lêk yathiŋdang me aômô long thiliv. ");
INSERT INTO ymp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Be ditu notak avîlanô takiti vo ini melak lêk long takatu be hîmô bidong, vo êŋgêv ining nôm vuli vo injang.” ");
INSERT INTO ymp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Metom Yisu henang nena, “Mî, môlô da ombakông loho.” Êng me loho nang viyang nena, “Ai, avîlanô bêng anông be ditu tem aô thalo valuseleng hîtôm anô te ya vuli ayông bahevi be lahavôlô vo aôŋgêv nôm vuli ethak e?” ");
INSERT INTO ymp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Me Yisu henang ik loho ling nena, “Môlô ning polom vithêla hîmô? Ôŋgô yôvêm.” Me loho yê yôv me êlêm enang nena, “Polom bahevi me alim ŋanam yi.” ");
INSERT INTO ymp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Êng me Yisu henang ethak ya ŋa hîndông vo enang ethak avîlanô nena îmbî i tham ini lundum lundum be îndôk îmô long kwang momalu. ");
INSERT INTO ymp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Me loho ik i tham hê lundum lundum be hîtôm 100 îmô dum te me dum yang me hîtôm 50, îmô bêng lundum lundum. ");
INSERT INTO ymp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Me Yisu hiwa polom bahevi hiving alim yi atu me hêyê leng be hêv la mavî. Yôv me hekav polom êng li be hêv hêndêng ya ŋa hîndông vo îmbî tham êndêng avîlanô takatu be îmô. Me hevong bêng ethak alim yi atu hiving. ");
INSERT INTO ymp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Me avîlanô sapêng eyang be leŋiŋviŋyak. ");
INSERT INTO ymp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Me polom lêk alim wata vi atu be hîmô denang me ya ŋa hîndông ithup îlôk vak tham lauming be lahavôyi. ");
INSERT INTO ymp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Me anô takatu be eyang nôm êng me loho hîtôm 5,000. ");
INSERT INTO ymp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yôvêm me Yisu henang ethak ya ŋa hîndông nena ethak yeng be imung bini Betsaida. Me yêni da hîmô vo nêŋgêv avîlanô bini êm. ");
INSERT INTO ymp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hêv avîlanô be ê, yôv me hethak dum te be hê vo neteng mek. ");
INSERT INTO ymp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bîlîvông êng me yeng atu lêk Yisu ya ŋa hîndông îmô kasîk bomang lîvông bing, me Yisu da hîmô dum denang. ");
INSERT INTO ymp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Me Yisu hêyê lovak iyuv bêng be hemolong yeng long hele hê ethak loŋbô. Me loho lêklokwang vo ivôsing yeng. Bidong tem neyang wakbêng me Yisu heveng kasîk viling be hê hêndêng loho. Be hevong vo nêŋgêv loho lîthîng, ");
INSERT INTO ymp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","metom ya ŋa hîndông êyê yêni heveng kasîk viling be esong nena anô dôhô te ma. Be loho sapêng êyê yêni be êkô kambom be embolomba be eleng. Ketheng oyang me Yisu henang ethak loho nena, “Dô môlô kô andô me ômô yaô! Ya yom diti!” ");
INSERT INTO ymp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Me hethak hivutak hîmô yeng hiving loho me lovak bêng êng hema. Êng me loho song kambom be ining auk ethak be hîlôk mayaliv. ");
INSERT INTO ymp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Vômbê nena ining auk me thekthek denang be mî eyala polom atu be Yisu heyali ya ondong amî. ");
INSERT INTO ymp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Loho ê ethak liŋdang viyang vulu nang Genesalet be êthô yeng hîmô. ");
INSERT INTO ymp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Me etak yeng be îlôk bing me avîlanô êyê Yisu be eyala yêni bôlôtom. ");
INSERT INTO ymp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Be ditu evothong eveng long nômbêng êng sapêng be iwa ŋa lêk kômbôk îlôk yêm be ê long atu elaŋô nena Yisu tem nîmô. ");
INSERT INTO ymp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Long nômbêng atu be yêni hê, melak lông yaônena lêk melak lông bêŋbêng, me avîlanô iwa ŋa lêk kômbôk be ê êndô loho hêk long ethak tom hîlôk. Me epetenak yêni lêk kapôlông malêing vo êthôm yêni da mena ya kwêv dêim ya dang yom. Me ŋa takatu be êthôm me sapêng ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Me Palisi lêk kîdôŋga ambô balambung doho êlêm nang Jelusalem be ekalambu Yisu thing. ");
INSERT INTO ymp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Me loho yê Yisu ya ŋa hîndông doho eyang nôm lêk baheŋing “lêlêik” me mî îvôkîng baheŋing hîtôm Palisi ning ambô manjeng henang amî. ");
INSERT INTO ymp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Palisi lêk avîlanô Islael thak esopa limi ning ambô manjeng be ditu thak îvôkîng baheŋing hîtôm kombom atu be limi thak evong. Esopa bêng me hîtôm injang nôm, me mî îvôkîng baheŋing amî me mî hîtôm injang nôm amî. ");
INSERT INTO ymp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Lêk ê maket be îvôlêm me mî îvôkîng baheŋing amî, êng me mî hîtôm injang nôm amî. Loho thak esopa limi ning bôk le long be îvôkîng keyek lêk wîng be belev, me esopa kombom lomaloma hîtôm ining ambô manjeng henang.) ");
INSERT INTO ymp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Êng me Palisi lêk kîdôŋga ambô balambung enang ethak Yisu nena, “Bisête be yong ŋa hôndông eyang nôm lêk baheŋing lêlêik me mî esopa bumalô loho ning ambô manjeng amî?” ");
INSERT INTO ymp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Me Yisu henang ethak loho nena, “Plopet Aisaia bôk hekavu ambô plopet hethak môlô ŋa takatu be onang ambô mavî metom ovong kambom lomaloma bêng anông, “‘Avîlanô lêk iti êv yînîng athêng ling hethak vieŋing ambôlêk yom. Metom kapôlôŋing me hêk dêimbô vo ya. ");
INSERT INTO ymp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Me thak enang loho da ning ambô manjeng yom be evatek nena, “Diti me Wapômbêng ya ambô.” Be ditu loho thak êv yeng oyang ethak ya.’ ");
INSERT INTO ymp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Môlô valong ŋa pîk ining ambô manjeng long me otak Wapômbêng ya ambô balambung.” ");
INSERT INTO ymp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Me Yisu henang ethak loho nena, “Môlô tak Wapômbêng ya ambô balambung hêk dang me osopa môlô da ning ambô manjeng. ");
INSERT INTO ymp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Hîtôm Moses bôk henang nena, ‘Nondovak lemambô lo lemtambô’ me ‘Ôpatu be hethang lambô lo talêmbô hethak ambô kambom, êng me iŋgik ôpêng vônô.’ ");
INSERT INTO ymp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Metom thak môlô nang nena, anô te henang ethak lambô mena talêmbô ma nena, ‘Yînîng nômkama takatu be hîmô vo yaŋgêv mamu livung ethak, êng me bôk ya hanang nena tem yaŋgêv êndêng Wapômbêng îtôm da. Be ditu mî hîtôm yaŋgêv mamu livung amî.’ ");
INSERT INTO ymp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Êng me omba long thing vo dô nêŋgêv talêmbô lo lambô livung andô. ");
INSERT INTO ymp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Môlô thak osopa limbumi ning ambô manjeng yom me ôêv dômîm lîlîng hêndêng Wapômbêng ya ambô. Be ovong kombom lomaloma hiving bêng yom.” ");
INSERT INTO ymp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Me Yisu helam avîlanô nômbêng atu hêlêm hêndêng yêni hethak loŋbô me henang nena, “Môlô sapêng ondaŋô ambô atu be tem ya nang me lemim êŋgêv katô. ");
INSERT INTO ymp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nôm eyang mî hîtôm nembong be anô te tem nimbutak lêlêik amî. Mî. Nôm takatu be hîmô anô kapô be hele yêing, ditu hevong be anô hivutak lêlêik.” ");
INSERT INTO ymp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yisu hetak avîlanô nômbêng atu me hê melak kapô. Êng me ya ŋa hîndông enang ik yêni ling hethak ambô dôhô atu be henang. ");
INSERT INTO ymp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Me Yisu henang nena, “Môlô thông paling iving e? Ondaŋô katô! Nôm takatu be eyang, mî hîtôm nembong be anô imbutak lêlêik injêk Wapômbêng mandaluk amî. ");
INSERT INTO ymp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nôm takêng mî hîlôk anô kapô be hivuling ining auk amî. Mî, hê heva anô leŋiŋthoham yôvêm me hele yêing be hê.” (Yisu henang bêng vo hik thô nena nôm eyang sapêng me mavî yom.) ");
INSERT INTO ymp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Me Yisu henang nena, “Nôm takatu be hîmô anô kapô be hele yêing, ditu hevong be anô ivutak lêlêik hêk Wapômbêng mandaluk. ");
INSERT INTO ymp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nôm takatu be hîmô anô kapô be hele yêing me bêŋiti: auk kambom lêk evong sek mayaliv lêk vanî lêk ik anô vônô lêk evong sek hiving anô yang yanavî lêk ");
INSERT INTO ymp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","maleŋing daŋtang me leŋing êv auk kambom hethak anô vi, me evong kambom hethak anô yang me mî moma amî, lêk evong athek ethak anô yang ya nômkama, me enang ambô yôhîng ethak anô yang lêk êmbôi be êv ining athêng ling be evong nômkama hîtôm ŋa molo. ");
INSERT INTO ymp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nôm kambom takêng ditu hîmô anô kapô be hele yêing be hevong ôpêng hivutak lêlêik.” ");
INSERT INTO ymp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Me Yisu hetak long êng be hê heveng long takatu be hêk bidong Taia. Be hê melak te kapô me hêndô avîlanô eyala nena yêni lêk hîmô long êng. Metom mî hîtôm nimbung i vo avîlanô amî. ");
INSERT INTO ymp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Me avî te atu be gôk lêlêik hîmô hiving nalavî helaŋô nena Yisu lêk hêyô long êng. Êng me hê ketheng me heya vabudum thîvô hîmô Yisu mandaluk. ");
INSERT INTO ymp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yêni me avî Glik te be talêmbô hevathu hêk Ponisia hîmô Silia kapô. Be hepetenak Yisu lêk kapô malêing vo nêŋgêv gôk kambom atu be hîmô hiving nalavî vê. ");
INSERT INTO ymp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Me Yisu henang nena, “Aôŋgêv nôm êndêng sêiknena be injang yôvêm. Me mî mavî vo aô kaliv sêiknena ning nôm êndêng avung amî.” ");
INSERT INTO ymp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Metom avî êng henang nena, “Anômbêng, êng me avanông. Metom avung thak ithup sêiknena ning nôm pômôp atu be hêv yak hîlôk balê vimbing be eyang.” ");
INSERT INTO ymp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Êng me Yisu henang nena, “Ambô atu be honang me mavî be ditu numbunnu. Gôk kambom êng lêk hetak nalum avî yôv.” ");
INSERT INTO ymp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Me avî êng hê hêyô ya melak me hêyê nena gôk kambom lêk hetak nalavî be hêk ya yêm. ");
INSERT INTO ymp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Me Yisu hetak Taia ning long me hesopa Saidon hivup hîlôk be hê hêyô Dekapolis ining long, yôvêm me hîvô hê kasîk bomang nang Galili. ");
INSERT INTO ymp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Êng me doho iwa anô liŋdong lêk ambôlêk putup te be êlêm êyô vo Yisu be epetenak yêni lêk kapôlôŋing malêing vo netak bang êyônjêk ôpêng. ");
INSERT INTO ymp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Êng me Yisu hiwa ôpêng be hê dêim doke vo avîlanô me hethong baŋduk hîlôk ôpêng liŋdong kapô. Yôvêm me hîsuvapôk ethak bang me hêthôm ôpêng diŋang. ");
INSERT INTO ymp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Me hêyê leng be hêvôv auk me henang ethak ôpêng hethak ambô Hiblu nena, “Epata!” (Ya ondong nena nupuak.) ");
INSERT INTO ymp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Êng me ôpêng liŋdong hikê me ambôlêk heyakê be henang ambô hêlêm yêing. ");
INSERT INTO ymp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Me Yisu henang nena, “Dô môlô nang bêng ethak avîlanô andô.” Henang bêng lômbôlông metom avîlanô mî bonong amî me enang bêng hê be hê. ");
INSERT INTO ymp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Me avîlanô esong kambom be enang nena, “Yêni hevong nômkama sapêng mavî anông. Hevong ŋa liŋdong putup elaŋô ambô me ŋa ambôlêk putup enang ambô hêlêm yêing.” ");
INSERT INTO ymp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wak te me avîlanô bêng anông êlêm ethak tom hethak loŋbô. Me loho nôm mî vo injang. Êng me Yisu helam ya ŋa hîndông êlêm me henang ethak loho nena, ");
INSERT INTO ymp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ya leng ik ya hethak avîlanô nômbêng iti. Loho bôk îmô hiving ya hîtôm wak lô be loho ning nôm lêk itup. ");
INSERT INTO ymp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Doho lêm nang long dêimbô be ditu ya hêv loho be ê oyang, me tem maleŋing endeyang be êŋgêv yak îndôk loŋdaŋlê.” ");
INSERT INTO ymp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Me ya ŋa hîndông enang nena, “Long iti me long thiliv me avîlanô bêng anông. Be aŋga aômbua polom nang êsê be aôŋgêv êndêng loho?” ");
INSERT INTO ymp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Me Yisu henang ik loho ling nena, “Môlô ning polom vithêla tu be hîmô?” Me enang nena, “Bahevi be lahavôyi.” ");
INSERT INTO ymp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Me Yisu henang ethak avîlanô nômbêng atu nena îndôk îmô bing. Me hiwa polom bahevi be lahavôyi atu me henang la mavî hêndêng Wapômbêng. Me hekavli be hêv hêndêng ya ŋa hîndông vo embani tham êndêng avîlanô nômbêng atu be îmô. ");
INSERT INTO ymp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Me ining alim ŋanam nenanena doho hîmô hiving. Hêv la mavî hethak yôvêm me hêv hêndêng ya ŋa hîndông vo embani tham êndêng avîlanô imbing. ");
INSERT INTO ymp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Me avîlanô nômbêng êng eyang be leŋiŋviŋyak. Me ya ŋa hîndông ithup nôm wata hîlôk vak tham bahevi be lahavôyi. ");
INSERT INTO ymp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Avîlanô takêng me hîtôm 4,000. Yôv me Yisu hêv loho sapêng be ê. ");
INSERT INTO ymp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Me yêni hethak yeng iving ya ŋa hîndông be ê Dalmanuta ning long. ");
INSERT INTO ymp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Me Palisi êyô me enang ik Yisu ling lêklokwang nena, “Nombong lavuning te vo niŋgik thô nena yong lêklokwang me hêlêm nang Wapômbêng mesa mî?” Loho nang bêng vo eyek yêni yom. ");
INSERT INTO ymp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Êng me Yisu kapô malêing be hêvôv auk me henang nena, “Hevong bisê be avîlanô bôlôti leŋing iving yambong lavuning te? Ya hanang avanông ethak môlô nena tem mî yambong lavuning te vo loho injê amî, mî anông.” ");
INSERT INTO ymp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yôv me Yisu hetak loho me hethak yeng hethak loŋbô be hê kasîk bomang viyang vulu. ");
INSERT INTO ymp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yisu ya ŋa hîndông leŋiŋpaling be mî iwa polom doho be ethak yeng amî me iwa polom tom yom. ");
INSERT INTO ymp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Me Yisu henang lêklokwang hethak loho nena, “Oyaŋging am ethak Helot lêk Palisi ining yis.” ");
INSERT INTO ymp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Me ya ŋa hîndông enang hethak i nena, “Betha henang ethak aô polom mî ma.” ");
INSERT INTO ymp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Metom yêni heyala loho ning ambô atu enang be henang ik loho ling nena, “Môlô nang ethak mî uwa polom amî vo? Môlô thông paling be lêk mî oyala amî denang e? Be môlô ning auk me thekthek e? ");
INSERT INTO ymp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Môlô ŋa lêk malemim metom mî ôyê tak amî vômbête? Me môlô ŋa lêk liŋdong metom thak mî olaŋô ambô amî vômbête? Môlô mî lemim êŋgêv nôm atu be bôk ya havong amî mesa? ");
INSERT INTO ymp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ya hakav polom bahevi vo avîlanô hîtôm 5,000, me uthup polom wata hîlôk vak tham vithêla?” Me loho nang viyang nena, “Lauming be lahavôyi.” ");
INSERT INTO ymp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Me ya hakav polom bahevi be lahavôyi vo avîlanô hîtôm 4,000, me uthup polom wata hîlôk vak tham vithêla?” Me enang viyang nena, “Bahevi be lahavôyi.” ");
INSERT INTO ymp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yôv me Yisu henang ethak loho nena, “Bisête be mî oyala doke amî?” ");
INSERT INTO ymp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Me loho ê êyô Betsaida me avîlanô doho iwa anô mandaluk pusip te hêyô me epetenak yêni lêklokwang vo nêthôm ôpêng. ");
INSERT INTO ymp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Me Yisu hevalong anô mandaluk pusip atu hîmô bang me hendandi be thêi tak melak lông êng me ê dêim doke. Me Yisu hîsuvapôk hethak ôpêng mandaluk luvi be hetak bang hêyô hêk ôpêng. Me henang nena, “Hôyê nômate mesa mî?” ");
INSERT INTO ymp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Me ôpêng hêv mandaluk ling me henang nena, “Ya hayê avîlanô doho, metom loho hîtôm alokwang hê be hêlêm.” ");
INSERT INTO ymp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Êng me Yisu hetak bang hêyô hêk ôpêng mandaluk hethak loŋbô. Me ôpêng mandaluk hipuak be hivutak mavî me hêyê nômkama sapêng hêlêm yêing. ");
INSERT INTO ymp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Me Yisu henang nena, “Nu yong melak metom dô nu melak lông andô.” ");
INSERT INTO ymp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Me Yisu lêk ya ŋa hîndông etak long êng me ivup ethak melak nenanena takatu be hîmô bidong Sisalia Pilipai. Eveng loŋdaŋlê denang me henang ik ya ŋa hîndông ling nena, “Avîlanô thak elam ya nena opalête?” ");
INSERT INTO ymp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Me loho nang viyang nena, “Doho thak enang nena ong me Jon Anô Hithik Avîlanô me doho enang nena ong me Elaija me doho enang nena ong me plopet bôô te.” ");
INSERT INTO ymp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Metom Yisu henang ik loho ling nena, “Me môlô da olam ya nena opalête?” Êng me Pita henang bêng nena, “Ong me Mesaya.” ");
INSERT INTO ymp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Me Yisu henang lêklokwang vo dô enang ya kôkôthing êng bêng ethak avîlanô andô. ");
INSERT INTO ymp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yôv me Yisu hîndông loho be henang nena, “Anô Ya Nakandung atu tem nesopa Wapômbêng ya la hiving be tem nimbua vovang bêng anông. Me avaka lêk ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung tem ende dômîng lîlîng êndêng yêni be iŋgik yêni vônô. Me hîtôm wak lô me tem nimbiyô ethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yisu henang ambô takêng bêng ethak loho, êng me Pita hiwa yêni be hê dêim doke me hethang yêni be henang nena, “Dô nonang bêng andô.” ");
INSERT INTO ymp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Metom Yisu hik i lîlîng be hêyê ya ŋa hîndông vi me hethang Pita nena, “Sakdang, numba ya dôm! Hosopa anô ning auk yom me mî hosopa Wapômbêng ya auk amî.” ");
INSERT INTO ymp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yôv me Yisu helam avîlanô nômbêng atu be êlêm iving ya ŋa hîndông me henang nena, “Anô te hevong vo nesopa ya, êng me nende dôm lîlîng êndêng yêni da me nimbua ya alovalasing be nesopa ya. ");
INSERT INTO ymp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Vômbê nena ôpatu be la hêv ya lêkmala pîk bêng anông, êng me ya lêkmala êng tem nêŋgêv yak. Metom ôpatu be hetak ya lêkmala be hesopa ya lêk yînîng Ambô Mavî, ôpêng tem nembalong ya lêkmala long. ");
INSERT INTO ymp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Anô te hiwa nômkama pîk sapêng metom mî hesopa Wapômbêng ya ambô amî be ya lêkmala hêv yak, aliêng tem nêŋgêv yêni livung bisê? ");
INSERT INTO ymp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Me anô te hîtôm nêŋgêv nômate êndêng Wapômbêng vo nimbua ya lêkmala ethak loŋbô mesa? Mî anông! ");
INSERT INTO ymp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Avîlanô bôlôti me thak evong kombom kambom lomaloma be êndô Wapômbêng. Bêng be avîlanô bôlôti te moma vo ya lêk yînîng ambô, me êndêng wakma atu be Anô Ya Nakandung hêlêm iving Lambô ya danda lêkmaŋging lêk ya aŋêla matheng, me yêni tem moma vo ôpêng bêng yom.” ");
INSERT INTO ymp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Me Yisu henang ethak loho nena, “Ya hanang avanông ethak môlô nena Wapômbêng ya lêkliŋyak bêng te nêlêm imbing ya lêklokwang bêng. Be môlô vi atu be ova long iti tem ômô lêkmala denang, me tem ôŋgô nôm êng imbing.” ");
INSERT INTO ymp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wak bahevi be lahavôtom hele be hê me Yisu hiwa Pita lo Jems me Jon iving yêni be ethak dum dêim te be ê îmô daluk. Êng me Yisu liŋkôpik hivutak yaŋda heva loho maleŋing. ");
INSERT INTO ymp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Me ya kwêv hivutak thapuk anông be anô pîk te mî hîtôm nîmbôkîng ya kwêv be nimbutak thapuk bêng amî. ");
INSERT INTO ymp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Me Elaija lo Moses êyô be enang ambô hiving Yisu be loho yê. ");
INSERT INTO ymp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Me Pita henang ethak Yisu nena, “Kîdôŋga, mavî anông vo lêk aômô long iti. Tem yoôndav melak lêkkôpik lokwaŋlô, te vo ong me te vo Moses me te vo Elaija.” ");
INSERT INTO ymp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Loho êkô kambom be îthông ambô enang paling be ditu Pita henang bêng.) ");
INSERT INTO ymp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Me mavông te hêyô be heva loho thing, me ambô te hêlêm nang mavông êng kapô nena, “Ôpiti me yînîng Wakna atu be ya leng hiving anông. Be ondaŋô ya ambô!” ");
INSERT INTO ymp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Me ketheng oyang me loho yê hêwê heveng me êyê Yisu yom heva me anô te mî heva hiving yêni amî. ");
INSERT INTO ymp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yôvêm me etak dum êng me îlôk ele ê me Yisu henang lêklokwang nena dô enang nôm atu be êyê bêng hethak avîlanô andô endebe Anô Ya Nakandung atu nema be nimbiyô injêk ŋama ethak loŋbô êm. ");
INSERT INTO ymp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Be ditu loho ivung ambô êng hêk loho da me mî enang bêng amî, metom ithupav hê be hêlêm mayaliv nena “nema lêk nimbiyô injêk ŋama” ya ondong bisête? ");
INSERT INTO ymp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Me loho nang ik Yisu ling nena, “Bisête be kîdôŋga ambô balambung enang nena Elaija tem nimung be nêlêm yôv kîmîng Mesaya?” ");
INSERT INTO ymp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Êng me Yisu henang nena, “Avanông! Elaija tem nimung vo nembong nômkama sapêng imbutak mavî ethak loŋbô. Metom ya hanang ethak môlô nena Elaija bôk hêlêm yôv. Metom avîlanô esopa ining leŋing iving yom be evong kambom lomaloma hethak yêni hîtôm Wapômbêng ya kapua bôk henang ethak yêni. Metom bisête be Wapômbêng ya kapua henang nena Anô Ya Nakandung atu tem nimbua vovang bêng lêk ende dômîng lîlîng êndêng yêni?” ");
INSERT INTO ymp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yisu loho êyô vo ya ŋa hîndông vi me êyê avîlanô bêng anông lêk ethak tom. Me kîdôŋga ambô balambung lêk ya ŋa hîndông vi atu be îmô enang ambô be îkôki hethak. ");
INSERT INTO ymp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Me avîlanô nômbêng êng êyê Yisu, me ketheng oyang me loho îpîndîk kambom me evothong ê me iwa yêni thô. ");
INSERT INTO ymp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Me Yisu henang ik loho ling nena, “Môlô kôk am hethak ômbête?” ");
INSERT INTO ymp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Me anô te hîmô avîlanô nômbêng êng lîvông be henang nena, “Kîdôŋga, gôk te hevalong yînîng wakna ambôlêk long be mî hîtôm nenang ambô amî. Be diti ya hauwa hêlêm vo ong. ");
INSERT INTO ymp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gôk kambom êng thak hîlônîng yêni be hîmbî yêni hîlôk pîk be ambôlêk apôk thapuk hele yêing me hethang ambôlêk ondong long me ling himuving be thotho. Ya hanang vo yong ŋa hôndông êŋgêv gôk kambom êng vê metom loho mî hîtôm amî.” ");
INSERT INTO ymp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Me Yisu henang viyang nena, “Môlô me avîlanô mî ôêv iving amî! Wak vithê tem ya mô imbing môlô be yambua môlô ning malêing imbing môlô? Umbua wakna êng êlêm.” ");
INSERT INTO ymp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Êng me iwa wakna atu hê vo Yisu. Gôk atu hêyê Yisu, me hîlônîng wakna êng kambom be hêv yak hîlôk pîk be hevali hêk me ambôlêk thôk hêv yak. ");
INSERT INTO ymp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Me Yisu henang ik lambô ling nena, “Gôk kambom hivuling yêni hêndêng aŋgête?” Me lambô henang nena, “Sêmbôk be yêni yaôna denang. ");
INSERT INTO ymp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Me gôk êng hîmbî yêni hîlôk amela lêk ŋanam lômbôlông vo niŋgik yêni vônô metom mî. Bêng be ong hîtôm, me nombong be gôk kambom êng etak yînîng wakna, êng me lem hik ong ethak yêi be hôêv yêi livung.” ");
INSERT INTO ymp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Me Yisu henang nena, “Bisête be honang nena, ‘ong hîtôm’? Wapômbêng hîtôm nembong nômkama sapêng vo ŋa takatu be êv iving yêni.” ");
INSERT INTO ymp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Me ketheng oyang me wakna êng lambô helam nena, “Ya hêv iving be nombong vo yînîng auk atu be mî ya hêv iving amî nêŋgêv ya ling vo yaŋgêv imbing!” ");
INSERT INTO ymp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Me Yisu hêyê nena avîlanô êvôv i ketheng ethak tom, êng me hethang gôk lêlêik atu be henang nena, “Ong gôk ambôlêk lêk liŋdong putup, ya hanang ethak ong nena notak wakna ti be nu me dô nômbôlêm ethak loŋbô andô.” ");
INSERT INTO ymp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Me gôk kambom êng heleng be hesaŋiyak me hîlônîng wakna êng kambom me hele yêing be hê. Me wakna êng hêk nang anô hema be avîlanô enang nena, “Lêk hema.” ");
INSERT INTO ymp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Metom Yisu hevalong bang vi me hendandi be hiviyô heva. ");
INSERT INTO ymp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yôv me Yisu lêk ya ŋa hîndông yom îmô melak kapô me loho nang ik yêni ling nena, “Bisête be mî hîtôm yoôŋgêv gôk kambom êng vê amî?” ");
INSERT INTO ymp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Me Yisu henang viyang hethak loho nena, “Mek yom hîtôm tem nêŋgêv gôk kambom yaliŋbêng vê.” ");
INSERT INTO ymp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Me loho tak long êng be ivutak êyô Galili. Me Yisu hêndô avîlanô endaŋô nena lêk loho mô long êng ");
INSERT INTO ymp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","vômbê nena hîndông ya ŋa hîndông. Me Yisu henang ethak loho nena, “Tem enang Anô Ya Nakandung atu êng bêng be etak îndôk avîlanô baheŋing. Be tem iŋgik yêni vônô, me hîtôm wak lô me tem nimbiyô ethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Metom loho îthông ambô êng ya ondong paling, be loho kô enang iŋgik yêni ling. ");
INSERT INTO ymp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Me Yisu loho ê êyô Kapenaom me îmô melak kapô te. Me Yisu henang ik loho ling nena, “Môlô kôk am hethak ômbête heveng loŋdaŋlê hêlêm?” ");
INSERT INTO ymp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Metom loho yala nena îkôki hethak loho ali alête me anô mung vo Yisu ya ŋa hîndông vi be ditu loho bonong. ");
INSERT INTO ymp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Me Yisu hîlôk hîmô me helam ya ŋa hîndông lauming be lahavôyi takatu be êlêm. Me henang nena, “Lem iving numbutak anô mung, êng me notaving ong endeni endebe numbutak yaônalêk me numbutak îtôm avîlanô sapêng ining anô ku oyang.” ");
INSERT INTO ymp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Me hiwa sêik nate be hîtîng eva loho lîvông. Me hevalong eva me henang ethak loho nena, ");
INSERT INTO ymp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ôpatu hiwa sêik yaôna te bêŋiti thô hethak yînîng athêng, êng me hîtôm hiwa ya thô. Me ôpatu be hiwa ya thô, me hîtôm hiwa ôpatu be hêv ya be ya halêm thô hiving.” ");
INSERT INTO ymp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Me Jon henang ethak Yisu nena, “Kîdôŋga, yoô yê anô te hêv gôk kambom vê hethak yong athêng. Metom yêni me mî aô te amî, be yoô nang vo netak ku êng.” ");
INSERT INTO ymp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Metom Yisu henang nena, “Dô! Mî omba yêni thing andô. Ôpatu be hevong nôm thamtham hethak yînîng athêng me heveng yam me tem mî nenang ambô kambom ketheng ethak ya amî, ");
INSERT INTO ymp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","vômbê nena ôpatu be mî hîpôlîk ethak aô amî, ôpêng me aô te. ");
INSERT INTO ymp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ya hanang avanông ethak môlô nena anô te hêyê nena môlô me Mesaya ya avîlanô be hêv ŋanam keyek te hêndêng môlô hethak yînîng athêng, ôpêng ya ku tem mî hîtôm nêŋgêv yak amî me tem nimbua ya vuli mavî. ");
INSERT INTO ymp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Me anô te hevong be yînîng sêik atu be hêv iving ya te hêv yak, êng me heveng yam me ôpêng ya vovang me tem bêng anông vo vovang yang atu be êthôkêng valu malêing bêng te hethak lôkbudum be îmbî yêni hîlôk mamik kapô vo nema. ");
INSERT INTO ymp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Me bahem hêvôv ong be hovong kambom, êng me nondambêng kisi be nôŋgêv vê vo dô nombong kambom ethak loŋbô andô! Bahem vi yom me mavî vo nu melak leng. Me kambom vo baheng luvi hîmô me tem nu long amela hethang hîmô hîtôm wak nômbêng iti sapêng. ");
INSERT INTO ymp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Me vem hêvôv ong be hovong kambom, êng me nondambêng kisi be nôŋgêv vê vo dô nombong kambom ethak loŋbô andô! Vem vi yom me mavî vo nu melak leng. Me kambom vo vem luvi hîmô me tem nu long amela hethang hîmô hîtôm wak nômbêng iti sapêng. ");
INSERT INTO ymp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Me malemdaluk hêvôv ong be hovong kambom, êng me nosapu vê. Malemdaluk vi yom me mavî vo nu Wapômbêng ya lêkliŋyak bêng kapô. Me kambom vo malemdaluk luvi hîmô me tem nu long amela hethang hîmô hîtôm wak nômbêng iti sapêng. Be ditu malêing bêng anông. ");
INSERT INTO ymp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Long êng me tem matamuak injang anô leŋving kôpik îtôm wak nômbêng iti sapêng, me amela tem nethang anô wak nômbêng iti.’ ");
INSERT INTO ymp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Amela tem nethang avîlanô sapêng îtôm mamik thak etak hîlôk nôm vo îmô mambung îmô Wapômbêng mandaluk. ");
INSERT INTO ymp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mamik me nôm mavî, metom ya maning hêv yak, me opalê hîtôm nembong be nimbutak maning ethak loŋbô? Bêng be ômô yôhôk îtôm mamik vathing mavî imbing amda bêng yom.” ");
INSERT INTO ymp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Me Yisu hetak long êng be hê heveng Judia lêk ŋanam Yelodan viyang vulu. Me avîlanô bêng anông êlêm ethak loŋbô. Me hesopa ya bôk le long be hîndông loho. ");
INSERT INTO ymp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Me Palisi doho êlêm me evong vo embatek Yisu be enang ik yêni ling nena, “Ambô balambung henang bisête? Anô te hîtôm nêŋgêv yanavî vê mesa mî?” ");
INSERT INTO ymp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Me Yisu henang viyang nena, “Moses bôk henang bisê?” ");
INSERT INTO ymp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Me loho nang nena, “Moses hîlôk nena anô te hevong vo nêŋgêv yanavî vê êng me nekavu kapua te be netak îndôk yanavî bang vo nêŋgêv yêni vê.” ");
INSERT INTO ymp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yôv me Yisu henang nena, “Môlô ŋa liŋdong kôtông kambom be ditu Moses hekavu balambung iti be hêv hêndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Metom ‘sêmbôk be mung anông atu be Wapômbêng hepesang avîlanô me hepesang anô be avî. ");
INSERT INTO ymp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Be ditu Wapômbêng bôk henang yôv nena, “Anô tem netak lambô lo talêmbô be nîmô imbing yanavî ");
INSERT INTO ymp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","vo thêi imbutak îtôm kôpik tom yom.” ’ Thêi me mî yi hethak loŋbô amî me lêk ivutak îtôm tom yom. ");
INSERT INTO ymp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bêng be nôm atu be Wapômbêng bôk hepatôk long hethak tom, me anô te mî hîtôm nepole vê amî.” ");
INSERT INTO ymp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yôvêm me Yisu lêk ya ŋa hîndông îmô melak kapô hethak loŋbô, me ya ŋa hîndông enang ik yêni ling hethak ambô atu. ");
INSERT INTO ymp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Me Yisu henang ethak loho nena, “Anô te hêndô yanavî be hiwa avî yang, êng me hevong sek be hivuling yanavî bôô. ");
INSERT INTO ymp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Me avî te hêndô yamalô be hiwa anô yang, êng me hevong sek bêng yom be hivuling yamalô bôô.” ");
INSERT INTO ymp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Me avîlanô iwa sêiknena be ê hêndêng Yisu vo netak bang êyônjêk loho. Metom ya ŋa hîndông ethang avîlanô takêng. ");
INSERT INTO ymp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yisu hêyê nôm êng, me la maning be henang ethak ya ŋa hîndông nena, “Otak sêiknena vo loho lêm êndêng ya me dô omba long thing andô, vômbê nena avîlanô takatu be athêng mî me hîtôm sêiknena takiti be Wapômbêng ya lêkliŋyak bêng me loho ning. ");
INSERT INTO ymp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ya hanang avanông ethak môlô nena, opalê atu be mî hiwa Wapômbêng ya lêkliŋyak neyaŋging avîlanô amî hîtôm sêiknena takiti, ôpêng mî hîtôm nîmô Wapômbêng ya lêkliŋyak bêng vimbing amî. Mî anông.” ");
INSERT INTO ymp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Me Yisu hevalong sêiknena be hetak bang hêyô hêk loho me hêv mek hethak loho. ");
INSERT INTO ymp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Me Yisu hiviyô be hê me anô te hevothong be hê hêndêng yêni, me heya vabudum thîvô hîmô va be henang nena, “Kîdôŋga mavî, tem yambong kombom mavî alêla vo yambua lêkmala îtôm wak nômbêng iti sapêng?” ");
INSERT INTO ymp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Me Yisu henang viyang nena, “Holam ya nena mavî vo? Anô te mî mavî amî me Wapômbêng yom ditu mavî. ");
INSERT INTO ymp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ambô balambung me bôk hoyala yôv: ‘Dô nuŋgik anô vônô andô. Me dô nombong sek imbing anô yang yanavî andô. Me dô nombong vanî andô. Me dô nonang ambô yôhîng ethak anô vi be nombong ambô vo loho andô. Me dô nonang ambô yôhîng vo numbua anô yang ya nômkama andô. Me nondovak lemambô lo lemtambô ning ambô.’ ” ");
INSERT INTO ymp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Me ôpêng henang nena, “Kîdôŋga, ya yaôna denang hele be hêyô lêk ya anômbêng me thak ya hasopa ambô balambung takêng sapêng.” ");
INSERT INTO ymp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Me Yisu hêyê ôpêng be la hiving yêni be henang nena, “Mavî anông, metom ong nômate mî denang. Nu me nôŋgêv yong nômkama sapêng vo avîlanô êŋgêv vuli, me numbua valuseleng êng sapêng be nôŋgêv êndêng avîlanô siv. Hovong bêng, me yong nômkama mavî lomaloma tem nîmô melak leng. Me nôlêm osopa ya.” ");
INSERT INTO ymp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yêni me anô lêk nômkama bêng anông. Be ditu helaŋô ambô êng, me hikum be hê lêk la malêing bêng. ");
INSERT INTO ymp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Me Yisu hêyê hêwê heveng me henang ethak ya ŋa hîndông nena, “Malêing bêng vo ŋa lêk nômkama bêng êŋgêv i êndêng Wapômbêng be îmô ya lêkliŋyak bêng vimbing.” ");
INSERT INTO ymp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yisu ya ŋa hîndông elaŋô be esong kambom. Me Yisu henang ethak loho hethak loŋbô nena, “Yînîng sêiknena, malêing bêng vo avîlanô takêng êŋgêv i êndêng Wapômbêng be îmô ya lêkliŋyak bêng vimbing! ");
INSERT INTO ymp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Me mî malêing bêng vo bok kamel imbutak êyô lôvîk indi thôp ya ambuang bini amî, metom malêing bêng vo anô lêk nômkama bêng te vo nêŋgêv i êndêng Wapômbêng be nîmô ya lêkliŋyak bêng vimbing.” ");
INSERT INTO ymp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Me Yisu ya ŋa hîndông esong kambom anông be enang hethak loho da nena, “Bêng be opalê hîtôm nimbua lêkmala wak nômbêng iti sapêng?” ");
INSERT INTO ymp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Me Yisu hêyê loho kôlîlîng be henang nena, “Anô te mî hîtôm nêŋgêv inda livung amî, me Wapômbêng yom hîtôm nêŋgêv yêni livung. Be ditu Wapômbêng yom hîtôm nembong nômkama sapêng.” ");
INSERT INTO ymp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Me Pita henang ethak Yisu nena, “Bôk yoôtak yoô ning nômkama sapêng me alêm vo asopa ong!” ");
INSERT INTO ymp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Me Yisu henang nena, “Ya hanang avanông ethak môlô, anô te la hêv ya lêk yînîng Ambô Mavî be hetak ya melak lêk viyaŋi me livi lêk talôvi lo lami me nali lêk ya pîk, ");
INSERT INTO ymp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","êng me Wapômbêng tem nêŋgêv bêng anông êndêng inda îtôm 100 nêyômô yêni ya long imbing. Ôpêng hîmô pîk denang, me tem nimbua nômkama takiti bêng anông: melak lêk viyaŋi me livi lêk talôvi me nali lêk pîk me avîlanô vi tem imbuling yêni imbing. Me heveng yam me tem nîmô lêkmala îtôm wak nômbêng iti sapêng. ");
INSERT INTO ymp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Metom ŋa lêk athêng bêng anông, tem imbutak ŋa athêng mî. Me ŋa athêng mî bêng anông, tem imbutak ŋa lêk athêng bêng.” ");
INSERT INTO ymp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Loho veng be ê daku Jelusalem me Yisu himung be hê. Me ya ŋa hîndông êyê be esong kambom me avîlanô takatu be eveng yam êkô hiving. Me Yisu henang ethak ya ŋa hîndông lauming be lahavôyi takatu ethak loŋbô vo etak avîlanô be êlêm yôvêm me henang ethak nôm takatu be tem nêpôm yêni. ");
INSERT INTO ymp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ondaŋô. Aô yô Jelusalem me tem enang Anô Ya Nakandung atu bêng be êŋgêv yêni êndêng ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung. Me tem enang be iŋgik yêni vônô me êŋgêv yêni êndêng avîlanô long bôyang ");
INSERT INTO ymp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","vo loho nang ambôma ethak yêni lêk îsuvapôk ethak yêni be embali yêni me iŋgik yêni vônô. Me hîtôm wak lô ende bini yôv me tem nimbiyô ethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yôv me Sebedi namalô luvi, Jems lo Jon, thêi ê êndêng Yisu me enang nena, “Kîdôŋga, yêi leŋing iving nombong nôm atu be tem yêi nang iŋgik ong ling ethak.” ");
INSERT INTO ymp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Me Yisu henang nena, “Mamu lemim iving yambong ômbête êndêng mamu?” ");
INSERT INTO ymp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Me thêi nang nena, “Notak yêi yang îmô bahem viyôhôk me yang îmô bahem vikeng îmô yong long lêkmaŋging kapô.” ");
INSERT INTO ymp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Me Yisu henang nena, “Mamu thông nôm atu be onang ik ya ling paling. Hîtôm tem mamu num îndôk keyek atu be tem ya num îndôk lêk uthik îndôk ŋanam atu be tem ya thik îndôk?” ");
INSERT INTO ymp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Me thêi nang nena, “Yêi hîtôm.” Me Yisu henang nena, “Avanông, keyek êng lêk ŋanam êng tem mamu num lêk mamu thik îndôk. ");
INSERT INTO ymp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Metom îmô ya baheng viyôhôk mena vikeng ma, aliêng me mî yînîng ku amî. Me Wapômbêng da heyaŋging ku êng be bôk hîtôk anô doho yôv vo loho mô long êng.” ");
INSERT INTO ymp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wakma ŋa hîndông lauming elaŋô ambô êng be leŋing ŋaŋa hethak Jems lo Jon. ");
INSERT INTO ymp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Êng me Yisu helam loho lêm ethak tom me henang nena, “Bôk môlôyala yôv nena avîlanô long bôyang ining king thak êv i ling be ivuling ŋa takatu be îmô loho vimbing. Me loho ning ŋa bêŋbêng thak enang lêklokwang hethak loho ning avîlanô bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ondaŋô! Dô môlômbong kombom êng andô! Môlô te la hiving nimbutak anô lêk athêng bêng îmô môlô lîvông, êng me nimbutak îtôm môlô ning anô ku vo nêŋgêv môlô livung. ");
INSERT INTO ymp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Me ôpatu be la hiving nimbutak îtôm môlô ning anômbêng, êng me nîmô îtôm avîlanô sapêng ining anô ku oyang ");
INSERT INTO ymp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","hîtôm Anô Ya Nakandung atu hevong bêng yom. Me mî ya halêm vo avîlanô pîk embong yînîng ku amî. Metom ya halêm vo yambong avîlanô pîk ining ku. Ya halêm vo yambua loho vê injêk malêing lêk ya tak yînîng lêkmala vo nêŋgêv avîlanô bêng anông livung.” ");
INSERT INTO ymp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Me Yisu lêk ya ŋa hîndông ê êyô Jeliko. Yôv me evong vo etak Jeliko me avîlanô bêng anông ê hiving loho. Me anô mandaluk pusip te be ya athêng nena Batimias hîmô loŋdaŋlê dang vi be hepetenak avîlanô vo êŋgêv inda livung. (Batimias ya ondong nena Timias nakandung.) ");
INSERT INTO ymp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Helaŋô nena Yisu nang Nasalet hêlêm, êng me helam lêkwaê nena, “Yisu, Devit Lim Lêkmuk, lem iŋgik ong ethak ya!” ");
INSERT INTO ymp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Me avîlanô bêng anông ethang yêni be enang nena, “Ong bonong!” Metom yêni helam kaêk lêkwaê anông nena, “Yisu, Devit Lim Lêkmuk, lem iŋgik ong ethak ya!” ");
INSERT INTO ymp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yôv me Yisu heva me henang nena, “Ondam yêni lêm.” Me elam hêndêng anô mandaluk pusip atu nena, “Lem mavî! Numbiyô be nu! Ôpêng helam ong.” ");
INSERT INTO ymp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yôv me hekaliv ya kwêv thilimbung hê me hîsôv kisi bôlôtom be hê hêndêng Yisu. ");
INSERT INTO ymp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Me Yisu henang ethak inda nena, “Lem iving yambong ômbête êndêng ong?” Me anô mandaluk pusip êng henang nena, “Kîdôŋga, ya leng iving yaŋga tak.” ");
INSERT INTO ymp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Me Yisu henang nena, “Nu. Yong hôêv iving hevong be lêk ong mavî.” Me ketheng oyang me ôpêng mandaluk hipuak be hêyê tak, me hesopa Yisu heveng loŋdaŋlê. ");
INSERT INTO ymp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yisu loho ê êyô bidong oyang Jelusalem me ê êyô Betpagi lo Betani, long yi êng hêk bidong Dum Oliv. Me hêv ya ŋa hîndông lokwaŋyi be ê ");
INSERT INTO ymp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","me henang ethak thêi nena, “Mamu nu melak vulu. Me ovong umbutak ôyô kapô me tem ôŋgô evak bokdoŋki map te long be heva. Bok êng bôk mî anô te hêyô mô amî. Me mamu pole yak êng vê me ondom be ôlêm. ");
INSERT INTO ymp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Me anôla henang ik mamu ling nena, ‘Mamu vong ombong ômbête?’ me yu nang ethak yêni nena, ‘Anômbêng la hiving nembong ku te thak yôv kîmîng nêŋgêv ketheng oyang îmbôlêm.’ ” ");
INSERT INTO ymp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yôv me thêi ê me êyê doŋki map atu be evak long be êthô hîmô melak ambôlêk hîmô bidong loŋdaŋlê vi yêing. Me thêi pole yak vê. ");
INSERT INTO ymp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Me anô doho eva long êng êyê be enang ik ling nena, “Mamu vong ômbê be opole bok ya yak vê?” ");
INSERT INTO ymp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Me thêi nang ambô atu be Yisu henang ethak thêi. Êng me loho lôk be etak thêi be thêi iwa bokdoŋki êng be ê. ");
INSERT INTO ymp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Me iwa doŋki êng be ê hêndêng Yisu, me ik ining kwêv thilimbung dêim thô be eŋgova êyô hêk bok dômlokwang be Yisu hêyô hîmô. ");
INSERT INTO ymp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Me avîlanô bêng anông eŋgova ining kwêv thilimbung dêim hêk loŋdaŋlê. Me vi ele athaŋang lêk ŋaung heveng kamung be eŋgova hêk loŋdaŋlê. ");
INSERT INTO ymp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Me doho imung me doho eveng yam me Yisu heva lîvông me loho lam nena, “Osana!” “Wapômbêng embong mavî êndêng ôpatu be hêlêm ethak Anômbêng ya athêng!” ");
INSERT INTO ymp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Wapômbêng êŋgêv la mavî nêyômô bumalô Devit lim iti atu be tem neyaŋging aô îtôm king hîtôm sêmbôk be Devit heyaŋging! Osana! Aôŋgêv Wapômbêng ya athêng ling ethak leng!” ");
INSERT INTO ymp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Me Yisu hê hêyô Jelusalem me hivutak êyô melak matheng ya popatîng kapô be hê. Me hêyê nômkama takatu be hîmô long êng. Metom wak lêk ê hîlôk jalôm yôv, be ditu hetak Jelusalem me hê Betani hiving ya ŋa hîndông lauming be lahavôyi takatu. ");
INSERT INTO ymp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Hiviyô heyang me loho tak Betani me ê vini Jelusalem. Me Yisu hema ve la. ");
INSERT INTO ymp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Me hêyê alokwang pik te ŋaung heva dêim doke. Êng me hê hêyô alokwang atu ondong vo ninjê nena alokwang atu hik anông mesa mî. Metom hêyê ŋaung oyang yom me mî niŋgik anông amî vômbê nena mî ya wakma niŋgik amî. ");
INSERT INTO ymp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yôv me Yisu henang ethak alokwang êng nena, “Tem mî nuŋgik anông ethak loŋbô be anô te injang amî.” Be ya ŋa hîndông elaŋô ambô êng hiving. ");
INSERT INTO ymp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Me Yisu loho êyô Jelusalem. Me hivutak êyô melak matheng ya popatîng lîvông. Me hêyê avîlanô iwa nômkama be êndô hîmô vo avîlanô vi êŋgêv vuli. Êng me hindining loho be hêv loho vê hêk melak matheng kapô be ele yêing be ê. Me hele ŋa takatu be ele ŋa long bôyang ining valuseleng thô hethak Islael ining valuseleng ining balê lîlîng. Me hevong bêng yom hethak ŋa takatu be êndô menak bôbô hîmô vo avîlanô êŋgêv vuli hiving. ");
INSERT INTO ymp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Me heva long thing vo avîlanô dô imbua ining nômkama be imbutak êyô melak matheng ya popatîng bini andô. ");
INSERT INTO ymp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Me Yisu hîndông loho be henang bêŋiti, “Wapômbêng ya kapua henang nena, ‘Yînîng melak me melak avîlanô pîk sapêng eteng mek îndôk.’ Me lêk môlôvong be hivutak hîtôm ŋa vanî ning melak ekopak îmô.” ");
INSERT INTO ymp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung elaŋô ambô êng be ethalo loŋdaŋlê vo iŋgik yêni vônô. Metom loho kô yêni vômbê nena avîlanô sapêng îpîndîk kambom hethak ya ambô. ");
INSERT INTO ymp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yathiŋdang hêmbôk anông me Yisu loho tak Jelusalem be ê. ");
INSERT INTO ymp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Heyang lêkbôk me Yisu loho îvôê me êyê alokwang pik atu lêk hema be hekapôk hêk ŋaung be hêyô ondong. ");
INSERT INTO ymp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Me Pita la hêv Yisu ya ambô be henang nena, “Kîdôŋga, nôŋgô! Alokwang pik wakbôk atu be hothang me lêk hekapôk yôv.” ");
INSERT INTO ymp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Me Yisu henang ethak loho nena, “Ôŋgêv imbing Wapômbêng yom. ");
INSERT INTO ymp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ya hanang avanông ethak môlô nena ôpatu be henang ethak dum iti nena, ‘Nokaliv ong da nundôk mamik’, me hêv iving be hevalong ya ambô êng long lêklokwang me mî kapô yi amî, êng me tem Wapômbêng embong be ya ambô atu be henang tem niŋgik anông. ");
INSERT INTO ymp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bêng be diti ya hanang ethak môlô nena, ômbêla takatu be môlô nang îlôk môlô ning mek, êng me môlôŋgêv imbing nena lêk môlô uwa yôv, me nôm êng tem môlômbua. ");
INSERT INTO ymp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Wakma môlô teng mek me lemim êv kambom atu be anô te bôk hevong ethak am, êng me otak kapôlômim vo ôpêng. Môlôvong bêng me môlô ning Kamik atu be hîmô melak leng tem netak kapô vo môlô bêng yom.” ");
INSERT INTO ymp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Me Yisu loho ê Jelusalem hethak loŋbô be êyô melak matheng ya popatîng. Me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung lêk avaka ê hêndêng Yisu. ");
INSERT INTO ymp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Me enang ik yêni ling nena, “Opalê hêv lêklokwang hêndêng ong lêk hêv ku hêndêng ong be ditu hovong nôm takiti?” ");
INSERT INTO ymp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Me Yisu henang viyang ethak loho nena, “Tem ya nang iŋgik môlô ling ethak ambô te bêng yom imbing. Be môlô nang ambô êng viyang thêthôp hêndêng ya êng me tem ya nang ôpatu be hêv lêklokwang hêndêng ya ethak môlô. ");
INSERT INTO ymp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Opalête hêv ku ithik avîlanô hîlôk ŋanam hêndêng Jon? Wapômbêng leng mesa anô pîk te? Môlô nang ethak ya!” ");
INSERT INTO ymp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Me loho da enang hethak i nena, “Aô nang nena Wapômbêng hêv ku êng hêndêng Jon me tem nenang nena, ‘Me hevong bisê be môlô mî ôêv iving Jon ya ku amî?’ ");
INSERT INTO ymp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Metom aô nang nena, ‘Anô pîk te hêv ku êng,’ êng me avîlanô tem leŋing maning ethak aô vômbê nena loho sapêng êv iving nena Jon me plopet te.” ");
INSERT INTO ymp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Me loho nang hêndêng Yisu nena, “Yoô thông paling.” Me Yisu henang ethak loho nena, “Bêng be mî hîtôm yandam ôpatu be hêv lêklokwang hêndêng ya, ya athêng êndêng môlô amî.” ");
INSERT INTO ymp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Me Yisu henang ambô dôhô doho hethak loho nena, “Anô te hevatho ya kukapô yak waing te me hevak wandu hêwê heveng. Me helav lovang vo embak waing anông pesa vo imbua ya thôk. Me helav melak dêim te hethak tololak vo anô mô vo eyaŋging ku êng. Yôv me hetak ku atu hîlôk anô doho baheŋing vo eyaŋging be wakma hik anông me tem loho imbua anông vi me êŋgêv vi êndêng yêni. Yôvêm me hetak long êng be hê hîmô long bôyang vambô. ");
INSERT INTO ymp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wakma yak waing hik anông hêyô me hêv ya anô ku te be hê hêndêng ŋa takatu be eyaŋging ya ku. Yêni la hiving lohoŋgêv anông doho vo yêni hîtôm sêmbôk be loho epatôk ambô hiving i. ");
INSERT INTO ymp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Metom loho evalong ôpêng hêk be ik yêni kambom me êv yêni be hê oyang. ");
INSERT INTO ymp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yôvêm me hêv anô ku yang be hê hethak loŋbô, metom ik inda hîlôk kwandôk be evong kombom lomaloma ethak yêni be evong yêni moma. ");
INSERT INTO ymp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yôv me hêv anô ku te hethak loŋbô metom loho ik yêni vônô. Yôv me hêv tomtom bêng hivup ethak metom evali vi me ik vi vônô. ");
INSERT INTO ymp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Hevong bêng hele be lêk mî me anô tom yom hîmô. Ôpêng me namalô atu be yêni la hiving anông. Hêv ôpêng be hê me la hêv nena, ‘Diti me yînîng wakna be tem endaŋô ya ambô.’ ");
INSERT INTO ymp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Metom ŋa takatu be eyaŋging ku êng êyê ôpêng me enang hethak loho da nena, ‘Ôpiti me ku alang nakandung be tem neyaŋging lambô ya ku. Bêng be aôŋgik yêni vônô me ku êng tem nimbutak aô ning.’ ");
INSERT INTO ymp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Be evalong yêni be ik yêni vônô be îmbî ya kôpik hele yêing be hê. ");
INSERT INTO ymp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Yôv be tem ku alang embong ômbête? Tem niŋgik ŋa takêng vônô me nêŋgêv ku êng êndêng anô vi vo eyaŋging. ");
INSERT INTO ymp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bôk môlô sam Wapômbêng ya ambô bôti mesa mî? “ ‘Valu atu be ŋa elav melak êndô, me lêk hivutak landîng anông. ");
INSERT INTO ymp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Anômbêng da hevong nôm êng, be yoô yê nôm êng nena mavî anông.’ ” ");
INSERT INTO ymp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Me ŋa Juda ning ŋa bêŋbêng eyala nena Yisu henang ambô dôhô êng hethak loho, be ethalo loŋdaŋlê vo embalong yêni. Metom êkô avîlanô, be ditu etak yêni me loho ê. ");
INSERT INTO ymp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yôv me êv Palisi doho lêk ŋa esopa Helot doho be ê hêndêng Yisu, vo embatek yêni ethak ambô te vo embalong inda. ");
INSERT INTO ymp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Loho yô vo Yisu me enang nena, “Kîdôŋga, yoô yala nena ong me anô ambô avanông. Thak hôyê ŋa lêk athêng lêk ŋa athêng mî hîtôm tom, be ditu thak honang ambô tom hêndêng loho sapêng. Me hôndông Wapômbêng ya loŋdaŋlê avanông thêthôp hêndêng avîlanô sapêng. Yôv be lem hêv bisête? Bumalô loho ning balambung henang nena mavî vo aôŋgêv takis êndêng Sisa mesa dô?” ");
INSERT INTO ymp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Hîtôm aôŋgêv takis êndêng Sisa mesa mî? Metom Yisu hêyê loho ning auk kambom êng thô be henang ik loho ling nena, “Hevong bisête be môlôvong vo ombatek ya? Umbua valuseleng te lêm vo yaŋga.” ");
INSERT INTO ymp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Êng me loho iwa valuseleng te hêlêm vo Yisu. Me henang ik loho ling nena, “Opalê ya dôhô lêk ya athêng hêyô hêk valuseleng iti?” Me loho nang nena, “Sisa.” ");
INSERT INTO ymp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Êng me Yisu henang ethak loho nena, “Sisa ya nômkama me ôŋgêv êndêng Sisa da. Me Wapômbêng ya nômkama me ôŋgêv êndêng Wapômbêng da.” Me loholaŋô be esong kambom hethak ya ambô êng. ");
INSERT INTO ymp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Me Sadyusi doho ê hêndêng Yisu. Sadyusi me ondong te atu be enang nena ŋa ema mî hîtôm imbiyô ethak loŋbô amî. Êng me enang ik Yisu ling nena, ");
INSERT INTO ymp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kîdôŋga, Moses bôk hekavu hêndêng aô nena, ‘Anô te hema be nali mî be yang hîmô, êng me nimbua avî tôp êng vo nîmbî yang atu be hema nakandung vê.’ ");
INSERT INTO ymp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bêng be ŋa lêk viyaŋi bahevi be lahavôyi îmô. Me bôp hiwa avî te be hema me nakandung mî. ");
INSERT INTO ymp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Êng me nok hiwa avî tôp êng ethak loŋbô. Metom nok hema be nakandung mî. Me gwa hiwa avî tôp êng hethak loŋbô. Metom gwa hema be nakandung mî. ");
INSERT INTO ymp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bêng be viyaŋi molok takatu be îmô me esopa kombom tomêng yom. Yôv me avî tôp atu hema hiving. ");
INSERT INTO ymp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Me waklavông ŋa ema iviyô hethak loŋbô, me avî atu be ŋa lêk viyaŋi bahevi be lahavôyi takatu be iwa, me loho ali alête yanavî êng?” ");
INSERT INTO ymp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Me Yisu henang viyang ethak loho nena, “Môlô mî oyala Wapômbêng ya lêklokwang lêk ya ambô atu be hêk ya kapua katô amî. Be ditu môlô nang ambô lêkgwak bêng. ");
INSERT INTO ymp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Waklavông ŋa ema iviyô hethak loŋbô, me avîlanô tem mî imbua i ethak loŋbô amî me mî. Loho tem îmô îtôm aŋêla melak leng yom. ");
INSERT INTO ymp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Môlô nang nena ŋa ema tem mî hîtôm imbiyô ethak loŋbô amî. Metom bôk môlô sam Moses ya kapua lêk kôkôthing amela hethang hîmô alokwang ling e? Wakma êng me Wapômbêng henang ethak Moses bêŋiti nena, ‘Ya me Ablaham lo Aisak me Jekop ining Wapômbêng.’ ");
INSERT INTO ymp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wapômbêng me mî ŋa ema ning Wapômbêng amî. Mî, yêni me ŋa lêkmala yom ining Wapômbêng. Be ditu môlô ning ambô me lêkgwak anông!” ");
INSERT INTO ymp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kîdôŋga balambung ining anô te hêyô me helaŋô Yisu lêk Sadyusi îkôki. Me helaŋô Yisu henang loho ning ambô viyang mavî anông. Tomêng me henang ik Yisu ling nena, “Balambung ali alête me ditu bêng vo balambung vi?” ");
INSERT INTO ymp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Êng me Yisu henang nena, “Balambung ali mung henang nena, ‘Môlô Islael ondaŋô katô. Anômbêng yom ditu aô ning Wapômbêng me yêni yom ditu Anômbêng. ");
INSERT INTO ymp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lemim imbing Anômbêng môlô ning Wapômbêng injêk môlô kapôlômim, lêk dôhôlômim me lêklokwang lêk môlô ning auk sapêng.’ ");
INSERT INTO ymp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Me balambung yang me bêŋiti: ‘Lem imbing avîlanô vi hîtôm lem hiving ong da.’ Balambung vi mî bêng vo balambung yi tiêng amî.” ");
INSERT INTO ymp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Me anô hîndông ambô balambung henang ethak Yisu nena, “Kîdôŋga, honang ambô mavî anông. Yong ambô me avanông bing nena Wapômbêng me tom yom me mî Wapômbêng yang hîmô hiving amî. ");
INSERT INTO ymp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aô leŋing imbing yêni avanông bing injêk aô kapôlôŋing lêk auk be lêklokwang sapêng. Lêk leŋing imbing avîlanô vi hîtôm aô leŋing iving aô da. Ambô balambung yi êng me bêng vo da nômbêng iti lêk da îmbôk ethak amela sapêng.” ");
INSERT INTO ymp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yisu helaŋô ôpêng henang viyang lêkauk mavî be henang ethak ôpêng nena, “Mî hômô dêimbô vo Wapômbêng ya lêkliŋyak bêng amî.” Me avîlanô sapêng êkô be mî enang ik yêni ling ethak loŋbô amî. ");
INSERT INTO ymp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Me Yisu hîndông avîlanô hîmô melak matheng ya popatîng be henang nena, “Kîdôŋga balambung thak enang nena Mesaya me Devit lim lêkmuk vo? ");
INSERT INTO ymp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lovak Matheng hêv auk hêndêng Devit da be henang nena, “ ‘Anômbêng henang ethak yînîng Anômbêng nena, “Nôndôk ômô ya baheng viyôhôk endebe ya tak yong ŋakyo îmô vemkapô vimbing êm.” ’ ");
INSERT INTO ymp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Me Devit da bôk helam Mesaya nena Anômbêng. Metom hevong bisê be ôpêng me Devit lim hiving?” Avîlanô elaŋô Yisu ya ambô êng be leŋing mavî anông. ");
INSERT INTO ymp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yisu hîndông loho be henang nena, “Môlô yaŋging am vômbê nena kîdôŋga ambô balambung, leŋing iving iŋgik kwêv dêim kêkêlô be embeng vo avîlanô embam loho. Lêk leŋing iving avîlanô bêng anông enang nena, ‘Waklîvông mavî anômbêng’ îndôk maket. ");
INSERT INTO ymp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Me leŋing iving îmô îtôm ŋa bêŋbêng îmô Islael ining melak yeng kapô. Me thak avîlanô eŋgambôm nôm bêng, me leŋing iving injang nôm îmô ŋa bêŋbêng ining long ethak îmô. ");
INSERT INTO ymp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Loho thak evatek avî tôp be iwa loho ning melak vanî, lêk eteng mek dêim anông vo avîlanô leŋing êŋgêv nena loho me ŋa thêthôp anông. Ŋa êng me tem imbua vovang bêng êndêng wakma evong ambô.” ");
INSERT INTO ymp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisu hê hîlôk hîmô bidong melak matheng ya kambum da, me hêyê avîlanô yalimamôk ê êv ining da. Me ŋa lêk valuseleng bêng etak valuseleng bêng anông hîlôk kambum da. ");
INSERT INTO ymp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Me avî tôp te atu be nômkama mî anông, hêyô me hetak ya da valuseleng lêkma yi yom hîlôk kambum da êng. ");
INSERT INTO ymp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Me Yisu helam ya ŋa hîndông êlêm me henang nena, “Ya hanang avanông ethak môlô nena avî tôp iti hêv valuseleng bêng anông vo ŋa takiti sapêng. ");
INSERT INTO ymp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Avîlanô nômbêng iti ning valuseleng bêng anông hîmô metom êv doke yom. Me avî tôp iti me nômkama mî anông, metom lêk hêv ya valuseleng sapêng me mî hevalong doho long amî.” ");
INSERT INTO ymp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisu hetak melak matheng be hele yêing me ya anô hesopa yêni te henang ethak yêni nena, “Kîdôŋga, nôŋgô melak matheng ya leleyang me kêkêlô bomang lêk ya valu bêŋbêng!” ");
INSERT INTO ymp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Me Yisu henang viyang nena, “Lêk hôyê melak bêŋbêng takiti e? Malêing bêng tem nimbutak be ŋa vovak tem iŋgik nômkama mavî nômbêng iti pesa be valu yang mî hîtôm nêyômô yang long amî.” ");
INSERT INTO ymp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yôvêm me Yisu hîmô Dum Oliv me hêyê melak matheng hîmô viyang vulu. Me Pita lo Jems me Jon lo Endulu loho yom ê enang ik yêni ling nena, ");
INSERT INTO ymp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nonang ethak yoô nena aŋgête ditu nôm takêng tem nimbutak? Lêk ômbête ditu tem nimbutak vo niŋgik thô nena nôm takêng lêk bidong oyang?” ");
INSERT INTO ymp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Me Yisu henang ethak loho nena, “Ŋa lomaloma tem êlêm ethak yînîng athêng be tem enang nena, ‘Ya me Mesaya atu.’ Me tem embatek avîlanô bêng anông. Be ditu oyaŋging am. ");
INSERT INTO ymp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Me tem môlôndaŋô kôkôthing ethak vovak lomaloma lêk vovak tem nimbutak pîk luvuluvu. Nôm takêng tem nimbutak, metom pîk lo leng ya dang me mî denang. Be ditu dô ondowaling andô. ");
INSERT INTO ymp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Me avîlanô ondong yang tem embong vovak imbing ondong yang. Me king yang lêk ya avîlanô tem embong vovak imbing king yang lêk ya avîlanô. Me duviyang lêk bôm bêng tem nimbutak long doho. Nôm takêng me hîtôm vovang mung atu be hêpôm avî lêk lathambeng te atu be hevong vo nembathu. ");
INSERT INTO ymp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Bêng be oyaŋging am. Tem embalong môlô be etak îndôk ŋa elaŋô ambô baheŋing. Me tem embali môlô îndôk Islael ining melak yeng hîlôk. Vômbê nena môlô sopa ya be tem môlômba ŋa bêŋbêng lêk king maleŋing vo onang ya bêng ethak loho. ");
INSERT INTO ymp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yînîng ŋa ya handông tem enang Ambô Mavî vo avîlanô pîk sapêng endaŋô yôv kîmîng nôm takêng tem nimbutak embeng yam. ");
INSERT INTO ymp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wakma evak môlô long be iwa be ê vo ombong ambô, êng me dô ôkô be onang nena, ‘Tem yoô nang ômbê?’ Mî. Wakma êng me onang auk takatu be Wapômbêng tem nêŋgêv hêndêng môlô yom. Ambô takêng me Lovak Matheng da tem nenang me mî môlô da tem onang amî. ");
INSERT INTO ymp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Me anô loyang tem yang enang yang bêng vo iŋgik vônô. Me lambô tem nembong bêng ethak nakandung. Me sêiknena tem ende dômîng lîlîng êndêng lami lo talôvi be enang vo iŋgik loho vônô. ");
INSERT INTO ymp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Môlô me yînîng avîlanô. Be ditu avîlanô sapêng tem kapôlôŋing êndô môlô. Metom ŋa takatu be eva lêklokwang hele be hêyô yandang, me Wapômbêng tem nêŋgêv loho vê injêk malêing vo îmô mavî. ");
INSERT INTO ymp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tem môlôŋgô nôm kambom anông te heva long matheng atu be thak itip vo nemba long êng. (Bêng be môlô ŋa takatu be osam ambô tiêng, me lemim êŋgêv katô êm.) Me môlô ŋa takatu be ômô Judia ôyê nôm êng me ôsôv bunu dumlôlê. ");
INSERT INTO ymp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Me ŋa takatu be îmô melak vôv me tem mî îndôk bini melak kapô vo imbua ning nômkama andô. ");
INSERT INTO ymp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Me ŋa takatu be îmô kukapô dô endeni melak vo imbua ning kwêv thilimbung andô. ");
INSERT INTO ymp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aê, titaknena. Wakma êng me tem malêing bêng vo avî takatu be ethambeng lêk avî takatu be êv sum vo sêik kasek. ");
INSERT INTO ymp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Oteng mek vo malêing takêng mî nimbutak êndêng wakma beleng simbak andô ");
INSERT INTO ymp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","vômbê nena wakma êng me tem malêing bêng anông be nîmbô ethak vo malêing taksêmbôk atu be Wapômbêng hepesang pîk hele be hêyô lêk. Me tem mî nimbutak bêng ethak loŋbô amî. ");
INSERT INTO ymp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Me Anômbêng mî hendambêng wakma malêing takêng kisi amî, êng me avîlanô sapêng tem ema. Metom yêni la hêv avîlanô takatu be bôk helam loho yôv be ditu hendambêng wakma êng hê bidong. ");
INSERT INTO ymp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","“Wakma êng me anô doho tem êlêm be embatek môlô nena, ‘Ya me Mesaya’ mena ‘Ya me Wapômbêng ya plopet te,’ me tem embong lavuning lêk nôm thamtham vo embatek avîlanô takatu be Wapômbêng bôk hîtôk loho yôv metom mî hîtôm embatek loho amî. Be ditu anô te henang ethak môlô nena, ‘Ôŋgô, Mesaya hîmô long iti’ mena ‘hîmô long tamu,’ êng me dô ôŋgêv imbing andô. ");
INSERT INTO ymp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ondaŋô! Nôm takiti lêk mî hivutak amî denang me ya hanang nôm takêng bêng ethak môlô vo môlô yaŋging am. ");
INSERT INTO ymp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Malêing takêng hele hîlôk yôvêm, “ ‘me wak tem nimbutak momaŋaning, me ayông mî hîtôm nîmbî danda amî; ");
INSERT INTO ymp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","me môtôp leng tem nêŋgêv yak me nôm takatu be hîmô leng tem nendowaling.’ ");
INSERT INTO ymp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Wak êng me avîlanô tem injê Anô Ya Nakandung atu tem nêlêm imbing mavông lêk ya lêkliŋyak lêk ya danda lêkmaŋging. ");
INSERT INTO ymp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yêni tem nêŋgêv ya aŋêla bini pîk lo leng ya dang sapêng vo ithup avîlanô takatu be bôk hîtôk loho yôv. ");
INSERT INTO ymp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Be ditu môlômbua auk ethak alokwang pik. Heyeng yôv me ŋaung lêkmuk hivutak, êng me oyala nena wak mavî nêyô. ");
INSERT INTO ymp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bêng yom me môlô yê nôm takêng hivutak, êng me oyala nena Anô Ya Nakandung atu ya wakma nendelêm lêk bidong oyang be hîmô melak ambôlêk. ");
INSERT INTO ymp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ya hanang avanông ethak môlô nena avîlanô bôlôti tem mî ema amî denang me nôm takêng sapêng tem nimbutak. ");
INSERT INTO ymp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Pîk lo leng tem nêŋgêv yak bini, metom yînîng ambô bôte mî hîtôm nêŋgêv yak amî. ");
INSERT INTO ymp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Anô te mî heyala Anô Ya Nakandung ya waklavông lêk ya wakma atu be tem nendelêm amî. Aŋêla leng mî eyala hiving amî, me Nakandung mî heyala hiving amî. Wakamik yom ditu heyala. ");
INSERT INTO ymp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bêng be oyaŋging am be ôŋgêv lêlê! Vômbê nena môlô mî oyala waklavông atu be nôm êng tem nimbutak amî. ");
INSERT INTO ymp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nôm êng me hîtôm anô te hetak ya melak be hê long bôyang. Yêni hê me henang ethak ya ŋa ku vo eyaŋging ya nômkama. Me hik ku tham tomtom hîtôm loho. Me henang ethak anô heyaŋging melak ambôlêk nena neyaŋging manjeng anông. ");
INSERT INTO ymp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Bêng be môlô mô lêlê be oyaŋging am vômbê nena môlô mî oyala waklavông atu be melak alang tem nêyô ethak loŋbô amî. Te nêlêm êndêng yathiŋdang mena bîlîvông bing mena wakma tale heleng mena heyang wakbêng ma. ");
INSERT INTO ymp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Endekeme tem nêlêm bôlôtom me ninjê nena môlô êkthôm denang. ");
INSERT INTO ymp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ambô ti be ya hanang ethak môlô, me ya hanang ethak avîlanô sapêng hiving nena, ‘Môlô yaŋging am!’ ” ");
INSERT INTO ymp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wak lokwaŋyi hêk denang vo leŋing êŋgêv waklavông Wapômbêng iwa Islael vê hêk malêing, yang me Hêv Lîlîng me yang me Eyang Polom Yis Mî. Me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung evong vo embatek Yisu vo embalong yêni be iŋgik vônô. ");
INSERT INTO ymp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Be enang nena, “Lêk me waklavông nôm wapôm be dô aômbong ku êng andô. Endekeme avîlanô tem leŋing maning be embong vovak.” ");
INSERT INTO ymp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wak êng me Yisu hîmô Saimon ya melak nang Betani. Sêmbôk me ôpêng hêpôm kômbôk lepla metom bôk mavî. Yisu hîmô balê eyang nôm hîmô me avî te hêlêm me hiwa kolopak kêkêlô te be nôm uv mavî hîmô kapô be ya vuli me bêng anông. Me hik kolopak êng kwandôk li me heŋgathô nôm uv mavî êng hêyô hîmô Yisu kwandôk. ");
INSERT INTO ymp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Me avîlanô vi atu be îmô long êng hiving êyê be leŋing maning be enang ethak loho da nena, “Bisête be hivuling nôm uv mavî êng hê oyang? ");
INSERT INTO ymp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hîtôm nêŋgêv vo anô yang êŋgêv vuli ethak valuseleng îtôm anô te ya ku sondakbêng te ya vuli vo nimbua be nêŋgêv avîlanô siv livung ethak!” Êng me leŋing maning be ethang avî êng kambom. ");
INSERT INTO ymp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Metom Yisu henang nena, “Bisête be môlô êv malêing hêndêng avî ti? Otak yêni. Yêni hevong nôm mavî anông hêndêng ya. ");
INSERT INTO ymp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Avîlanô siv tem îmô imbing môlô îtôm wak nômbêng iti sapêng, be lemim iving ôŋgêv loho livung êng me ôŋgêv livung. Metom tem mî ya mô imbing môlô vambô amî. ");
INSERT INTO ymp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nôm atu be yêni hîtôm nembong me lêk hevong yôv be heŋgathô nôm uv mavî hêyô hîmô ya be lêk hepesang ya kôpik yôv vo endav. ");
INSERT INTO ymp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ya hanang avanông ethak môlô nena pîk nômbêng atu be enang yînîng Ambô Mavî bêng heveng me tem enang ethak nôm atu be avî ti lêk hevong hiving embeng vo avîlanô leŋing êŋgêv yêni.” ");
INSERT INTO ymp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Êng me Judas Iskaliot, yêni me Yisu ya ŋa hîndông lauming be lahavôyi takatu te, hê hêndêng ŋa bêŋbêng îmbôk da vo nêŋgêv Yisu îndôk loho baheŋing. ");
INSERT INTO ymp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Elaŋô ambô êng me leŋing mavî anông be epatôk ambô vo êŋgêv valuseleng êndêng yêni. Be ditu yêni hethalo loŋdaŋlê vo nenang Yisu bêng. ");
INSERT INTO ymp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Waklavông ya athêng nena Eyang Polom Yis Mî ya wak ali himung hêyô. Hêndêng wak êng me thak ik boksipsip nakandung te vo leŋing êv Waklavông Hêv Lîlîng. Me Yisu ya ŋa hîndông enang ik yêni ling nena, “Lem hêv yoô na melak alête vo apôpêk nôm leŋing êŋgêv Waklavông Hêv Lîlîng îndôk?” ");
INSERT INTO ymp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Me Yisu hêv ya ŋa hîndông yi be ê me henang nena, “Mamu nu melak lông kapô me tem ôpôm anô te be hiwa ŋanam lêk wîng bêng te îndôk loŋdaŋlê, me osopa yêni bunu. ");
INSERT INTO ymp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Me hivutak êyô melak kapô te be hê, me yu nang ethak melak êng ya alang nena, ‘Kîdôŋga henang nena, “Yînîng melak kapô atu be yaŋgang nôm Waklavông Hêv Lîlîng imbing yînîng ŋa ya handông hîmô sê?” ’ ");
INSERT INTO ymp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Êng me tem niŋgik melak kapô bêng te atu be hêk daku viling thô ethak mamu. Melak kapô êng me nômkama sapêng bôk hîmô yôv. Be ditu mamu opesang aô ning nôm îmô long êng.” ");
INSERT INTO ymp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Êng me ya ŋa hîndông yi atu ê êyô melak lông êng kapô. Me êyê nômkama sapêng hîtôm datu be yêni henang. Me epesang nôm Waklavông Hêv Lîlîng vo loho. ");
INSERT INTO ymp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yathiŋdang hêmbôk me Yisu lêk ya ŋa hîndông lauming be lahavôyi ê êyô long êng. ");
INSERT INTO ymp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Loho eyang nôm îmô me Yisu henang nena, “Ya hanang avanông ethak môlô nena môlô te tem nenang ya bêng. Ôpêng diti heyang nôm hiving ya.” ");
INSERT INTO ymp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Me loho leŋing malêing be tomtom enang hethak yêni nena, “Betha ya mesa?” ");
INSERT INTO ymp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Me Yisu henang viyang ethak loho nena, “Môlô lauming be lahavôyi takatu te. Ôpêng diti hetak bang hîlôk belev hiving ya. ");
INSERT INTO ymp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Anô Ya Nakandung atu teni îtôm bôk ekavu yôv hethak yêni. Metom alitakna. Malêing bêng vo ôpatu be henang Anô Ya Nakandung bêng. Mavî vo talêmbô bôk mî nembathu yêni amî!” ");
INSERT INTO ymp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Loho eyang nôm hîmô me Yisu hiwa polom te me hêv la mavî. Yôvêm me hekavli be hêv hêndêng ya ŋa hîndông me henang nena, “Môlômbua be oŋgwang. Diti me yînîng vathiap.” ");
INSERT INTO ymp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yôvêm me hiwa keyek lêk waing be henang la mavî. Me hêv hêndêng loho sapêng be inum. ");
INSERT INTO ymp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Me henang ethak loho nena, “Diti me yînîng lêkma atu be tem neŋgathô vo nembak tava imbing Wapômbêng lêk avîlanô pîk vo nêŋgêv avîlanô bêng anông livung. ");
INSERT INTO ymp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ya hanang avanông ethak môlô nena, tem mî hîtôm ya num waing ethak loŋbô amî endebe yambôna Wapômbêng ya lêkliŋyak bêng kapô êm mîng tem ya num waing lêkmuk.” ");
INSERT INTO ymp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Me loho êv yeng te yôv me ethak be ê Dum Oliv. ");
INSERT INTO ymp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Me Yisu henang ethak loho nena, “Bôk ekavu hêk Wapômbêng ya kapua nena, “ ‘Tem yaŋgik boksipsip alang vônô, me boksipsip tem îsôv mayaliv bini.’ Be ditu môlô sapêng tem otak ya me ôsôv mayaliv bunu. ");
INSERT INTO ymp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Metom hik ya ling ethak loŋbô, me tem yamung be yana Galili yôv kîmîng môlô tem ombeng ya yam.” ");
INSERT INTO ymp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Me Pita henang nena, “Mî, loho sapêng etak ong be ê, me tem yamba imbing ong denang.” ");
INSERT INTO ymp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Me Yisu henang nena, “Ya hanang avanông bing hethak ong nena bîlîvông iti me tale mî nendeng bôlô yi amî denang, me tem nonang îtôm bôlô lô nena hôthông ya paling.” ");
INSERT INTO ymp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Metom Pita henang lêklokwang nena, “Evong vo iŋgik ya vônô imbing ong, metom mî hîtôm ya nang nena ya hathông ong paling amî. Mî anông!” Me ya ŋa hîndông sapêng enang bêng yom. ");
INSERT INTO ymp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yôvêm me loho êyô long atu be elam nena Getsemani me henang ethak ya ŋa hîndông nena, “Môlô mô long iti me ya ha vo ya teng mek.” ");
INSERT INTO ymp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Me hiwa Pita lo Jems me Jon be ê hiving yêni. Me yêni kapô putup be la malêing kambom. ");
INSERT INTO ymp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Me henang ethak loho nena, “Ya kapôlông lêk malêing kambom hîtôm lêk ya hama yôv. Môlô mô long iti me ôŋgêv lêlê.” ");
INSERT INTO ymp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Me hê dêim doke me hêv yak hîlôk pîk be heteng mek nena loŋdaŋlê te hêk vo yêni me Wapômbêng êŋgêv malêing lêk vovang iti vê. ");
INSERT INTO ymp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Me henang nena, “Aba, Wakamik, ong hîtôm nombong nômkama sapêng. Bêng be nôŋgêv keyek iti vê injêk ya. Metom dô nosopa yînîng ya leng hiving andô. Mî, nosopa ong da yong lem hiving.” ");
INSERT INTO ymp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yôvêm me Yisu hele hê me hêyê ya ŋa hîndông lêk êkthôm. Me henang ethak Pita nena, “Saimon, hôêkthôm e? Ong mî hîtôm nômô lêlê wakma nate amî e? ");
INSERT INTO ymp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nômô lêlê be noteng mek vo dô nôŋgêv yak îndôk nôm takatu be tem neyek ong andô. Dôhô la hiving nembong mavî metom kôpik vau be mî hîtôm nembong amî.” ");
INSERT INTO ymp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yôvêm me hîvô hê me heteng mek bôô atu hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yôv me hele hê hethak loŋbô me hêyê loho êkthôm denang, vômbê nena maleŋing heyang be mî hîtôm îmô lêlê amî. Be ditu îthông nena enang ômbê êndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yôvêm me hele hê bôlô ali lô me henang ethak loho nena, “Môlô ôêkthôm be uwa lovak denang e? Lêk hîtôm! Ondaŋô, wakma lêk hêyô yôv vo etak Anô Ya Nakandung atu îndôk ŋa kombom kambom baheŋing. ");
INSERT INTO ymp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bêng be umbiyô vo aô na. Ôŋgô! Ôpatu be tem nenang ya bêng lêk hêlêm yôv.” ");
INSERT INTO ymp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yisu henang ambô denang me Judas hêyô. Yêni me Yisu ya ŋa hîndông lauming be lahavôyi takatu te. Me avîlanô bêng anông êlêm iving yêni be iwa bîng vovak lêk ŋokyôhôk. Ŋa takêng me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung lêk avaka êv loho be êlêm. ");
INSERT INTO ymp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ôpatu be tem nenang Yisu bêng bôk hik lavuning te thô hêndêng loho nena, “Ôpatu be ya haŋgu, me Yisu. Be ditu ombalong injêk me oyaŋging inda manjeng me umbua bunu.” ");
INSERT INTO ymp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Me ôpêng hê ketheng hêndêng Yisu me henang nena, “Kîdôŋga.” Me hiŋgu yêni. ");
INSERT INTO ymp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Me ŋa takatu be ê hiving Judas evalong Yisu be iwa be ê. ");
INSERT INTO ymp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Me ŋa takatu be eva bidong te hendandi ya bîng vovak be hele kwandôk bêng hîmbôk da ya anô ku te limbuk vi thô. ");
INSERT INTO ymp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Êng me Yisu henang ethak loho nena, “Betha ya me anô kambom anông be môlô uwa bîng vovak lêk ŋokyôhôk be ôlêm vo ombalong ya mesa, bisê? ");
INSERT INTO ymp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wak nômbêng iti me thak ya hamô melak matheng ya popatîng be ya handông môlô metom mî môlô valong ya amî vo? Metom lêk nôm takêng hivutak vo Wapômbêng ya ambô niŋgik anông.” ");
INSERT INTO ymp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Êng me ya ŋa hîndông sapêng etak yêni me îsôv mayaliv be ê. ");
INSERT INTO ymp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Me anôsêng te hesopa Yisu heveng yam be hivuliv liŋkôpik hethak kwak mavî tom yom. Me evong vo embalong yêni, ");
INSERT INTO ymp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","metom evalong kwak oyang me hîsôv ling popam be hê. ");
INSERT INTO ymp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Me loho iwa Yisu be ê hêyô kwandôk bêng hîmbôk da. Me ŋa bêŋbêng îmbôk da sapêng lêk avaka sapêng lêk kîdôŋga ambô balambung sapêng ethak tom. ");
INSERT INTO ymp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Me Pita hesopa Yisu heveng yam metom heveng dêim doke. Me hivutak êyô kwandôk bêng hîmbôk da ya bandêng kapô. Me hê hîmô hiving kwak bidong be hivuning amela hiving loho. ");
INSERT INTO ymp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Me ŋa bêŋbêng îmbôk da lêk kaŋso sapêng ethalo avîlanô doho vo enang Yisu ya kambom takatu be hevong bêng, vo loho embong ambô ethak vo iŋgik yêni vônô. Metom mî êpôm Yisu ya kambom te vo iŋgik yêni vônô amî. ");
INSERT INTO ymp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Avîlanô bêng anông enang ambô yôhîng ethak Yisu, metom ining ambô takatu be enang me mî hîtôm tom amî. ");
INSERT INTO ymp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Me doho iviyôva me enang ambô yôhîng hethak Yisu bêŋiti, ");
INSERT INTO ymp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yoô laŋô yêni henang nena, ‘Tem yandining melak matheng iti be anô elav hethak baheŋing. Me hîtôm wak lô yom me tem yandav lêkmuk yang atu be mî elav hethak baheŋing amî.’ ” ");
INSERT INTO ymp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Metom ining ambô takatu be enang hê mayaliv me mî enang ambô tom yom amî. ");
INSERT INTO ymp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Êng me kwandôk bêng hîmbôk da hiviyô heva loho maleŋing me henang ik Yisu ling nena, “Ŋa takiti lêk enang ong bêng yôv me ong bonong vo? Ong ambô mî e?” ");
INSERT INTO ymp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Metom Yisu bonong yom me mî henang ambô te amî. Me kwandôk bêng hîmbôk da henang ik Yisu ling hethak loŋbô nena, “Ong Mesaya, Anômbêng Matheng atu Nakandung e?” ");
INSERT INTO ymp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Me Yisu henang nena, “Ya êng diti. Me tem môlôŋgô Anô Ya Nakandung atu tem nîmô Wapômbêng Lêkliŋyak Anông bang viyôhôk be tem nêyômô mavông leng be nêlêm.” ");
INSERT INTO ymp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Me kwandôk bêng hîmbôk da helaŋô ambô êng me hêvôv ya kwêv kê be henang nena, “Lêk yôv. Bisête be aô leŋing iving andaŋô ambô doho imbing? ");
INSERT INTO ymp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Lêk aô laŋô yôv nena hivuling Wapômbêng ya athêng be henang nena yêni da me hîtôm Wapômbêng. Be ditu môlô ning auk bisête?” Me loho sapêng enang nena, “Hevong kambom be ditu tem nema.” ");
INSERT INTO ymp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yôvêm me doho îsuvapôk hethak yêni. Me vi ivuliv mandaluk thing hethak kwak me epeng yêni be enang nena, “Nonang ambô plopet nena opalê diti hik ong?” Me kwak bidong evalong yêni be ik hiving. ");
INSERT INTO ymp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita hîmô tamu melak atu ya bandêng kapô, me kwandôk bêng hîmbôk da ya avî ku te hêlêm. ");
INSERT INTO ymp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Me hêyê Pita hivuning amela hîmô. Me hêyê yêni be henang nena, “Ong iti me thak hoveng hiving Yisu, anô Nasalet atu.” ");
INSERT INTO ymp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Metom Pita henang nena, “Mî, ya hathông ambô tu be honang paling.” Me hele be hê bidong bandêng ambôlêk. Me tale te heleng. ");
INSERT INTO ymp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Me avî ku atu hêyê Pita hethak loŋbô me henang ethak anô takatu be eva bidong hiving yêni nena, “Ôpiti me ŋa takatu ining anô te.” ");
INSERT INTO ymp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Metom yêni henang ethak loŋbô nena, “Mî.” Yôvêm me ŋa takatu be eva bidong enang hethak Pita hethak loŋbô nena, “Avanông bing nena ong me anô Galili te be ditu ong me ŋa êng te.” ");
INSERT INTO ymp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Metom Pita henang nena, “Mî ya hanang ambô avanông amî, êng me tem Wapômbêng êŋgêv vovang êndêng ya. Ethak Wapômbêng ya athêng me ya hanang avanông bing nena ya hathông ôpitu be honang paling.” ");
INSERT INTO ymp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ketheng oyang me tale heleng bôlôyang, êng me Pita la hêv ambô atu be Yisu henang ethak yêni nena, “Tale mî nendeng bôlô yi amî denang, me tem nonang îtôm bôlô lô nena hôthông ya paling.” Êng me Pita hikum be heleng bêng. ");
INSERT INTO ymp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Lêkbôk momaŋaning mî me kaŋso sapêng ethak tom. Loho me ŋa bêŋbêng îmbôk da lêk avaka lêk kîdôŋga ambô balambung. Epatôk ambô hethak tom yôvêm me evak Yisu bang lêku me iwa be ê êv êndêng Pailat. ");
INSERT INTO ymp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Me Pailat henang ik Yisu ling nena, “Ong ŋa Juda ning king mesa?” Me Yisu henang viyang nena, “Hîtôm ditu ong da honang.” ");
INSERT INTO ymp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Me ŋa bêŋbêng îmbôk da îmbî Yisu liŋkôpik hethak ambô lomaloma. ");
INSERT INTO ymp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yôv me Pailat henang ik Yisu ling hethak loŋbô nena, “Ong ambô mî mesa? Loho îmbî lemvim kôpik hethak ambô lomaloma.” ");
INSERT INTO ymp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Metom Yisu bonong yom. Be ditu Pailat hesong kambom. ");
INSERT INTO ymp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Waklavông Hêv Lîlîng nômbêng iti, me avîlanô thak elam anô kalaondong te ya athêng vo Pailat êŋgêv vê. Me thak hêv ôpêng vê. ");
INSERT INTO ymp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sondakbêng êng me anô te be ya athêng nena Balabas hîmô kalaondong. Yêni hîmô kalaondong hiving ŋa takatu be loho evong vovak hiving Lom be ik anô doho vônô. ");
INSERT INTO ymp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Êng me avîlanô ê êyô vo Pailat me elam vo nêŋgêv anô kalaondong te vê îtôm thak evong lômbôlông. ");
INSERT INTO ymp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Me Pailat henang ik loho ling nena, “Môlô lemim iving ya tak môlô avîlanô Islael ining king iti mesa?” ");
INSERT INTO ymp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat heyala nena ŋa bêŋbêng îmbôk da leŋiŋdang hethak Yisu be ditu evong ambô vo yêni be henang bêng. ");
INSERT INTO ymp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Metom ŋa bêŋbêng îmbôk da ik avîlanô kapôlôŋing ling vo endam nena netak Balabas bini me nembalong Yisu long. ");
INSERT INTO ymp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Me Pailat henang ik loho ling hethak loŋbô nena, “Me tem yambong ômbê thak ôpatu be olam nena Islael ining king?” ");
INSERT INTO ymp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Me sapêng elam nena, “Iŋgik vônô ethak alovalasing!” ");
INSERT INTO ymp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Me Pailat henang nena, “Vo? Yêni hevong ômbê kambom?” Metom loho elam lêklokwang hethak loŋbô nena, “Iŋgik vônô ethak alovalasing!” ");
INSERT INTO ymp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Me Pailat la hiving nembong avîlanô nômbêng atu leŋing mavî be ditu hetak Balabas be hê hêndêng loho. Me henang be evali Yisu hethak yak lêklilu, yôvêm me hetak hîlôk ŋa vovak baheŋing vo iŋgik vônô ethak alovalasing. ");
INSERT INTO ymp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yôvêm me ŋa vovak iwa Yisu be ê Pailat ya melak bandêng kapô. Me elam ŋa vovak sapêng be êlêm ethak tom. ");
INSERT INTO ymp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Me iwa kwêv lêkma dêim te hîtôm king ining kwêv be ik îlôk Yisu me iwa yak lêklilu atu be epesang hîtôm king ining kwakdam be ik hîlôk kwandôk. ");
INSERT INTO ymp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Me iviyô êv baheŋing ling ethak leng be enang nena, “Waklîvông mavî avîlanô Islael ining king!” ");
INSERT INTO ymp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Me ik kwandôk hethak kwanding te lômbôlông be îsuvapôk hethak yêni. Yôvêm me eya veŋiŋbudum thîvô me evong hîtôm êv yeng ethak yêni. ");
INSERT INTO ymp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Me enang ambôma hethak yêni yôvêm me ik kwêv lêkma atu thô me ik yêni da ya kwêv dêim hîlôk loŋbô. Me elom yêni be ê vo iŋgik vônô ethak alovalasing. ");
INSERT INTO ymp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Me anô te be ya athêng nena Saimon nang Sailini hêlêm nang bôyang be hevong vo ni Jelusalem. Yêni me Aleksanda lo Lupus ining lambô. Be ŋa vovak êpôm yêni be enang lêklokwang vo nimbua Yisu ya alovalasing. ");
INSERT INTO ymp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Êng me iwa Yisu be ê long te atu be ya athêng nena Golgota. Athêng êng ya ondong nena Long Kwandôk Lokwang. ");
INSERT INTO ymp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yôv me iwa waing be isuvuling hiving alokwang te ya thôk be êv hêndêng yêni vo ninum vo vovang etaving. Metom hêndô. ");
INSERT INTO ymp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Êng me loho ik yêni long hethak alovalasing. Yôvêm me îmbî valu vo injê nena opalête tem nimbua ya kwêv lo kwak. ");
INSERT INTO ymp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wakma bahevi be lahavôva lêkbôk me ik Yisu hethak alovalasing. ");
INSERT INTO ymp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Alovalasing ya viling me ekavu ambô atu be enang hethak Yisu nena, ŊA JUDA NING KING. ");
INSERT INTO ymp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Me êthôkêng anô vanî lokwaŋyi hiving yêni. Êthôkêng yang heva Yisu bang viyôhôk, me yang heva bang vikeng. ");
INSERT INTO ymp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Me avîlanô takatu be elom loŋdaŋlê êng be ê me enang ambôma hethak yêni lêk evali luŋiŋkwandôk be enang nena, “Ai! Ong anô atu be honang nena tem nunduning Wapômbêng ya melak matheng thô be nondav ethak loŋbô îtôm wak lô yom e? ");
INSERT INTO ymp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bêng me nôŋgêv ong da livung be notak alovalasing be nôlêm pîk!” ");
INSERT INTO ymp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung enang ambôma hiving. Be enang hethak loho da nena, “Ôŋgô! Yêni bôk hêv avîlanô vi livung, metom mî hîtôm nêŋgêv yêni da livung amî vo? ");
INSERT INTO ymp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yêni me Mesaya, Islael ining king e? Êng me netak alovalasing be nêlêm pîk vo aôŋga be aôŋgêv imbing!” Me anô yi atu be eva alovalasing hiving yêni thêi nang ambôma hiving. ");
INSERT INTO ymp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hêndêng wakma lauming be lahavôyi me momaŋaning hêyô pîk sapêng vôv be hêk hele be hêyô wakma lô. ");
INSERT INTO ymp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wakma lô me Yisu helam kaêk lêkwaê nena, “Eloi, Eloi, lama sabatani?” Ambô êng ya ondong nena, “Yînîng Wapômbêng, yînîng Wapômbêng, bisête be hôndô ya?” ");
INSERT INTO ymp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Me avîlanô vi atu be eva long êng elaŋô ambô êng be enang nena, “Ondaŋô, yêni helam Elaija.” ");
INSERT INTO ymp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Me anô te hevothong be hê me hiwa kapôk be hethong îlôk waing maning. Me hivuvi kapôk êng ethak ŋok te be hêv êndêng Yisu vo ninum. Me ôpêng henang nena, “Ôndô vo aôŋga yôvêm endekeme Elaija tem nêlêm êŋgêv yêni vê ma.” ");
INSERT INTO ymp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Me Yisu helam kaêk lêkwaê me hema. ");
INSERT INTO ymp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Me kwak bêng atu be hêkôlê heva melak matheng vo heyang melak kapô kisi me hipupkê hê luvi hêk viling be hêyô vimbing. ");
INSERT INTO ymp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Me anô vovak lêik atu be heva bidong vo Yisu hêyê kombom atu be Yisu hema hethak, êng me henang nena, “Avanông bing, ôpiti me Wapômbêng Nakandung anông.” ");
INSERT INTO ymp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Avî doho eva dêim doke be êyê heva. Avî takêng te me Malia nang Makdala. Me te me Malia, Jems anôsêng lo Josep ining talêmbô. Me te me Salome. ");
INSERT INTO ymp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sêmbôk be Yisu hîmô Galili me avî takêng thak esopa yêni be êv yêni livung. Me avî bêng anông îmô hiving Yisu be esopa inda be ê Jelusalem îmô long êng hiving. ");
INSERT INTO ymp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Wak ik Yisu vônô, êng me waklavông avîlanô thak epesang ining nômkama vo Sabat. Me wak êng ya yathiŋdang bîlîvông me tem Sabat. ");
INSERT INTO ymp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Bêng be ditu wak heva denang me Josep nang Alimatia hêyô. Yêni me Senhidlen ining anômbêng te. Yêni thak hêv lêlê vo Wapômbêng ya lêkliŋyak bêng atu be tem nêlêm. Yêni mî hêkô amî me hê hêyô Pailat me henang vo nimbua Yisu ya kôpik. ");
INSERT INTO ymp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Me Pailat helaŋô nena Yisu lêk hema yôv be hesong kambom me helam anô vovak lêik atu hêlêm. Me henang ik ôpêng ling nena, “Yisu lêk hema yôv mesa mî e?” ");
INSERT INTO ymp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Me helaŋô anô vovak lêik ya ambô yôv me hîlôk vo Josep imbua ya kôpik. ");
INSERT INTO ymp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Êng me Josep hêv kwak dêim mavî doho vuli be hiwa Yisu liŋkôpik vê hêk alovalasing be hivuliv thing ethak kwak takatu. Me hiwa hê hêndô hêk kalang valu ambuang atu be elav vo endav ŋama îndôk. Me himbumbi valu bêng te vo hik kalang ambôlêk thing hethak. ");
INSERT INTO ymp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malia nang Makdala lêk Malia Josep talêmbô eva be êyê long atu be etak Yisu ya kôpik hêk. ");
INSERT INTO ymp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat hele hîlôk yôv me Malia nang Makdala lo Malia, Jems talêmbô, me Salome, loho êv vuli nôm uv mavî vo imbua bini vo etak ethak Yisu kôpik. ");
INSERT INTO ymp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Me sonda êng ya wak ali himung ya lêkbôk momaŋaning mî me loho iviyô be ê kalang. ");
INSERT INTO ymp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Me enang ik i ling nena, “Anô alête tem nimbumbi valu atu be hîmô kalang ambôlêk vê vo aô êm?” ");
INSERT INTO ymp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Metom êyô kalang me êyê nena valu bêng atu me lêk imbumbi hê hîmô dang yôv. ");
INSERT INTO ymp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Loho ivutak êyô kalang kapô me êyê anôsêng te lêk kwêv thapuk dêim te hîmô loho baheŋing viyôhôk. Loho yê be esong kambom. ");
INSERT INTO ymp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Me ôpêng henang nena, “Dô môlô pîndîk andô. Ya hayala nena othalo Yisu nang Nasalet atu be ik ethak alovalasing. Yêni lêk hiviyô be hê yôv me mî hêk long iti amî. Ôŋgô long atu be êndô yêni hêk diti. ");
INSERT INTO ymp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yôv be môlô nu vo onang ethak ya ŋa hîndông lêk Pita nena, ‘Yêni lêk himung be hê Galili vo môlô. Môlô nu yô long êng me tem ôŋgô yêni îtôm sêmbôk atu be bôk henang yôv hethak môlô.’ ” ");
INSERT INTO ymp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Me avî takêng êkô be elowaling kambom me etak kalang be îsôv ele yêing be ê. Me êkô be loho bonong yom me mî enang ambô êng ethak anôla amî. ");
INSERT INTO ymp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yisu hiviyô hêndêng sonda te ya wak ali himung. Me hik inda thô mung hethak Malia nang Makdala, avî atu be bôk Yisu hêv gôk kambom bahevi be lahavôyi vê hîmô yêni. ");
INSERT INTO ymp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Êng me Malia hê me henang ethak ŋa takatu be bôk eveng hiving yêni. Ŋa takêng leŋing malêing be eleng îmô. ");
INSERT INTO ymp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Me elaŋô nena Yisu hîmô lêkmala be Malia lêk hêyê yêni, metom loho mî êv iving ambô êng amî. ");
INSERT INTO ymp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yôvêm me Yisu ya ŋa hîndông yi etak melak bêng be ê long yang. Me Yisu hivutak yaŋda be hik inda thô hethak thêi. ");
INSERT INTO ymp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Me ele ê enang ambô êng hêndêng ya ŋa hîndông viyang, metom mî êv iving thêi ning ambô amî. ");
INSERT INTO ymp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yôv me Yisu ya ŋa hîndông lauming be lahavôtom eyang nôm îmô, me Yisu da hêyô vo loho. Me hethang loho lêklokwang hethak kapôlôŋing thekthek be mî êv iving ŋa takatu be êyê nena yêni lêk hiviyô yôv ining ambô amî. ");
INSERT INTO ymp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yôv me Yisu henang ethak loho nena, “Môlô nu îtôm pîk sapêng me onang Ambô Mavî atu be hethak ya bêng ethak avîlanô sapêng. ");
INSERT INTO ymp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Opalê atu be hêv iving be hithik ŋanam me tem nîmô mavî. Me opalê atu be mî hêv iving amî, me tem nimbua vovang ethak ya kombom kambom takatu be hevong. ");
INSERT INTO ymp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wapômbêng tem netak nôm thamtham lomaloma îndôk ŋa êv iving baheŋing bêŋiti. Hethak yînîng athêng, me tem êŋgêv gôk kambom vê lêk enang ambô mathôm lêkmuk. ");
INSERT INTO ymp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Me embalong bôyîv kambom ethak baheŋing lêk inum nôm atu be tem niŋgik anô vônô metom tem îmô mavî. Me etak baheŋing êyônjêk ŋa lêk kômbôk, me tem imbutak mavî.” ");
INSERT INTO ymp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Anômbêng Yisu henang ambô hiving loho yôv me iwa yêni hethak leng be hê hîmô Wapômbêng bang viyôhôk. ");
INSERT INTO ymp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yôv me ya ŋa hîndông ê me enang Ambô Mavî êng heveng long nômbêng iti sapêng. Me Anômbêng hevong ku hiving loho be hik ining ambô long hethak nôm thamtham takatu be evong.");
INSERT INTO ymp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Anômbêng Tiopilus, anô bêng anông evong ku lêklokwang vo ekavu kapua hethak nôm takatu be bôk hik anông hêk yoô lîvông. ");
INSERT INTO ymp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Loho ekavu ambô hîtôm thak anô vi êyê Yisu hevong be henang. Ŋa êng îmô hîtôm Wapômbêng ya ŋa ku be enang kôkôthing êng ethak avîlanô. ");
INSERT INTO ymp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Be ditu mung anông me ya havong ku bêng hiving vo yînîng ambô sapêng nimbutak thêthôp be nîmô yêing, be ditu ya leng hiving nena ya kavu kapua tiêng êthôk êndêng ong ethak nôm takêng. ");
INSERT INTO ymp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ya hakavu ambô takêng vo nêŋgêv ong livung vo noyala ambô takatu be bôk holaŋô êng me ambô avanông. ");
INSERT INTO ymp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sêmbôk atu be King Helot heyaŋging avîlanô Judia me anô hîmbôk da te hîmô be ya athêng nena Sekalaia. Yêni hevong ku hîmbôk da hiving ŋa ondong atu be ining athêng nena Abiya. Me yanavî Elisabet hivutak nang Alon limi hiving hîtôm Sekalaia. ");
INSERT INTO ymp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Thêi mô thêthôp anông hêk Wapômbêng mandaluk me thak esopa ambô balambung lêk Anômbêng ya ambô sapêng avanông. ");
INSERT INTO ymp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Metom Elisabet me avî yamu te, be ditu thêi sêik mî me îmô hele be eyalôv. ");
INSERT INTO ymp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wak te me Abiya ya ondong ining waklavông embong ku îmô melak matheng. Me etak Sekalaia vo nembong ku îmô Wapômbêng mandaluk. ");
INSERT INTO ymp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Loho sopa ŋa îmbôk da ning kombom be îmbî valu vo injê nena opalête tem nimbutak êyô Anômbêng ya melak matheng kapô bini vo nîmbôk da uv mavî. Êng me Sekalaia ya athêng hivutak be yêni hevong bêng. ");
INSERT INTO ymp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Be hîmbôk da uv mavî me avîlanô bêng anông îmô melak vi yêing be eteng mek îmô. ");
INSERT INTO ymp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Êng me Anômbêng ya aŋêla te hêyô vo Sekalaia be heva long îmbôk da uv mavî ya alakdala viyôhôk. ");
INSERT INTO ymp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekalaia hêyê aŋêla, êng me hesong be hêkô kambom. ");
INSERT INTO ymp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Metom aŋêla henang nena, “Sekalaia, dô nôkô andô. Yong mek me Wapômbêng bôk helaŋô yôv. Vônîm Elisabet tem nembathu nalum malô te be nondam ya athêng nena Jon. ");
INSERT INTO ymp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Me tem lem mavî bêng anông. Sêik êng hivutak me avîlanô bêng anông tem leŋing mavî ");
INSERT INTO ymp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","vômbê nena yêni tem nimbutak anô lêk athêng bêng injêk Anômbêng mandaluk. Yêni mî hîtôm ninum waing lêk ŋanam maning vi amî. Me heva talêmbô la denang me tem Lovak Matheng imbôlô yêni kapô thing. ");
INSERT INTO ymp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Me tem nendom avîlanô Islael bêng anông endeni êndêng Anômbêng loho ning Wapômbêng ethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Me yêni tem nimbua Elaija ya kombom lêk lêklokwang be nimung vo Anômbêng. Me tem nembong be lambô lêk nali imbutak kapôlôŋing tom. Lêk tem nembong ŋa liŋdong kôtông liŋdoŋing ipuak be endaŋô ŋa thêthôp ining auk mavî. Me yêni tem nembong bêng vo avîlanô epesang i vo imbua Anômbêng thô.” ");
INSERT INTO ymp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Me Sekalaia henang ik aŋêla ling nena, “Yêi luvi bôk ayalôv yôv be ômbête tem niŋgik thô vo ya yala nena yong ambô tem niŋgik anông?” ");
INSERT INTO ymp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Metom aŋêla henang viyang nena, “Ya Gabliel be thak ya hava Wapômbêng mandaluk. Be diti yêni da hêv ya be ya halêm vo ya nang ambô mavî tiêng êndêng ong. ");
INSERT INTO ymp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yôv be nondaŋô. Mî hôêv iving yînîng ambô amî. Be tem viem putup me mî hîtôm nonang ambô amî endebe yînîng ambô ti niŋgik anông êndêng waklavông atu be Wapômbêng hîtôk.” ");
INSERT INTO ymp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Avîlanô eyaŋging Sekalaia hele be mî me leŋing êv nena ômbête lêk hêpôm inda hîlôk melak matheng kapô. ");
INSERT INTO ymp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yôv me Sekalaia hele yêing me ambôlêk lêk putup be mî hîtôm nenang ambô ethak loho amî. Me hik nômkama thô hethak bang yom me mî henang ambô amî. Êng me loho yala nena yêni lêk hêyê wêng te hîlôk melak matheng kapô. ");
INSERT INTO ymp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekalaia hevong ya ku yôv me yêni hîvô hê ya melak. ");
INSERT INTO ymp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yôvêm me Sekalaia yanavî Elisabet hethambeng. Me hîmô ya melak kapô yom hîtôm ayông bahevi. ");
INSERT INTO ymp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Me henang nena, “Lêk iti me Anômbêng la mavî be hevong nôm iti hêndêng ya be hêv yînîng moma vê hêk avîlanô maleŋing.” ");
INSERT INTO ymp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet ya ayông hethambeng hîtôm bahevi be lahavôte me Wapômbêng hêv aŋêla Gabliel be hê hêyô melak lông te be elam nena Nasalet hêk Galili kapô. ");
INSERT INTO ymp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yêni hê hêyô vo avî voyavô te be bôk mî ninjêk imbing anô amî denang. Avî êng ya athêng nena Malia be ya avîlanô bôk îtôk yêni yôv vo nimbua anô te be ya athêng nena Josep. Josep me King Devit lim. ");
INSERT INTO ymp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aŋêla hê hêndêng Malia me henang nena, “Waklîvông mavî ong! Anômbêng hîmô hiving ong be bôk hêv ya wapôm hêndêng ong.” ");
INSERT INTO ymp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Me Malia helaŋô ambô êng be hesong kambom be la hêv nena ambô alête bêng. ");
INSERT INTO ymp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Metom aŋêla henang ethak yêni nena, “Malia, dô nôkô andô vômbê nena lêk huwa Wapômbêng ya wapôm yôv. ");
INSERT INTO ymp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nondaŋô. Tem nothambeng be nombathu sêik anô te be nondam ya athêng nena Yisu. ");
INSERT INTO ymp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yêni tem nimbutak anô lêk athêng bêng. Me tem endam yêni nena Wapômbêng Leng Nakandung. Me tem Anômbêng Wapômbêng nêŋgêv lim Devit ya ku king êndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Me tem nîmô îtôm Jekop limi ning king wak nômbêng iti sapêng. Me ya ku king tem nîmô bêng yom me ya dang mî.” ");
INSERT INTO ymp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Me Malia henang ethak aŋêla nena, “Nôm êng tem nimbutak bisête? Bôk mî yaŋgêk imbing anô te amî.” ");
INSERT INTO ymp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Me aŋêla henang viyang nena, “Lovak Matheng tem nêlêm êndêng ong me Wapômbêng Leng ya lêklokwang tem nêyô ong vôv. Be sêik atu be tem nombathu me tem matheng be endam nena Wapômbêng Nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nondaŋô. Yatam avî Elisabet bôk avoŋa be elam yêni nena avî yamu, metom lêk hethambeng be ya ayông lêk bahevi be lahavôte be tem nembathu sêik malô te. ");
INSERT INTO ymp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Be ditu nômate mî malêing vo Wapômbêng embong amî.” ");
INSERT INTO ymp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Me Malia henang nena, “Bôvê! Ya Anômbêng ya avî ku. Be ditu nembong lêk bêng êndêng ya îtôm ditu honang.” Yôv me aŋêla hetak Malia be hê. ");
INSERT INTO ymp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wakma êng me Malia hetak ya long me hê ketheng be hêyô melak lông te hêk Judia long atu be dum nenanena bêng anông. ");
INSERT INTO ymp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Me hêyô Sekalaia ya melak be hê kapô me henang waklîvông mavî hethak Elisabet. ");
INSERT INTO ymp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Me Elisabet elaŋô ya ambô me sêik kasek hîsôv kisi heva yêni la kapô me Lovak Matheng hîvôlô yêni kapô thing. ");
INSERT INTO ymp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Êng me Elisabet helam kaêk lêk la mavî be henang nena, “Wapômbêng hevong mavî hêndêng ong hîvô hethak vo avî vi. Be tem nembong mavî bêng yom êndêng sêik itu be tem nombathu. ");
INSERT INTO ymp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Metom ya avî alête be yînîng Anômbêng talêmbô hêlêm vo ninjê ya? ");
INSERT INTO ymp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nondaŋô. Wakma ya halaŋô yong waklîvông me sêik kasek iti be heva ya leng la mavî be hîsôv kisi. ");
INSERT INTO ymp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mavî vo ong vômbê nena hôêv iving Anômbêng ya ambô atu be henang ethak ong tem niŋgik anông!” ");
INSERT INTO ymp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Me Malia henang nena, “Ya kapôlông hêv Anômbêng ya athêng ling, ");
INSERT INTO ymp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","me ya dôhôlông la mavî hêndêng Wapômbêng yînîng Malatine, ");
INSERT INTO ymp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","vômbê nena yêni hêyê ya avî oyang atu be ya havong ya ku be la hiving ya. Avîlanô lêk be eveng yam sapêng tem enang nena ya hauwa mek mavî ");
INSERT INTO ymp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","vômbê nena Wapômbêng Lêklokwang Anông hevong nômbêng ethak ya be ya athêng thak hêk matheng. ");
INSERT INTO ymp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yêni thak hêv kapô hêndêng ŋa takatu be elaŋô ya ambô hêndêng sêmbôk lêk ŋa diti me ŋa tem embeng yam imbing. ");
INSERT INTO ymp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Me hevong ku bêŋbêng hethak yêni da ya lêklokwang. Me avîlanô takatu be êv loho da ning athêng lêk auk kambom ling me thak hêv loho vê ê mayaliv. ");
INSERT INTO ymp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Me thak hêv king ining lêklokwang vê. Me hêv athêng bêng hêndêng ŋa takatu be thak etaving i. ");
INSERT INTO ymp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Me thak hevakông avîlanô takatu be ema vo leŋing hethak nôm mavî bêng anông be leŋiŋviŋyak. Metom ŋa lêk nômkama bêng me thak hêv loho vê be ê oyang. ");
INSERT INTO ymp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Me yêni thak hêv ya avîlanô ku Islael livung me la hêv ya tava be hêv kapô hêndêng loho wak nômbêng iti sapêng ");
INSERT INTO ymp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","hîtôm ambô atu be bôk hevak hiving aô ning bumalô loho lêk Ablaham lêk limi sapêng.” ");
INSERT INTO ymp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Yôv me Malia hîmô hiving Elisabet hîtôm ayông lô, yôvêm me hele hê ya long ethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Me Elisabet ya waklavông nembathu hêyô be hevathu sêik malô te. ");
INSERT INTO ymp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Êng me Elisabet ya lêkma lêk ya avîlanô elaŋô nena Anômbêng lahiki bêng anông hethak yêni, be ditu loho leŋing mavî anông hiving inda. ");
INSERT INTO ymp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Me sêik kasek êng hîmô hîtôm wak bahevi be lahavôlô me avîlanô êlêm vo eŋgothe ya kôpik. Be ditu leŋing iving êŋgêv lambô Sekalaia da ya athêng êndêng wakna êng. ");
INSERT INTO ymp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Metom talêmbô henang nena, “Mî. Aôndam nena Jon.” ");
INSERT INTO ymp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Me loho nang ethak yêni nena, “Limbumi la te bôk mî hiwa athêng Jon amî.” ");
INSERT INTO ymp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yôv me loho nang ik lambô ling ethak baheŋing nena endam ya athêng bisête. ");
INSERT INTO ymp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Me hik thô hethak bang nena imbua aseleng petap te lêm, êng me iwa lêm me hekavu hêyô hêk nena, “Ya athêng nena Jon.” Me loho sapêng êyê athêng êng be esong kambom. ");
INSERT INTO ymp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Me ketheng oyang me Sekalaia ambôlêk hik kê be henang ambô hethak loŋbô me hêv Wapômbêng ya athêng ling. ");
INSERT INTO ymp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Me avîlanô long êng êyê nôm êng be esong kambom. Me ambô êng hê be heveng Judia ning long dum nenanena sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Me leŋing êv be enang ik ling nena, “Anômbêng ya lêklokwang hîmô hiving sêik iti be yôvêm ketem nimbutak bisête?” ");
INSERT INTO ymp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yôv me Lovak Matheng hîvôlô Sekalaia Jon lambô kapô thing be henang ambô plopet nena, ");
INSERT INTO ymp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Aôŋgêv athêng bêng êndêng Islael ining Anômbêng Wapômbêng, lêk hêlêm vo nêŋgêv ya avîlanô vê injêk ining malêing. ");
INSERT INTO ymp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yêni hêv Anô Lêklokwang te hivutak ya anô ku Devit ya lêkma vo nimbutak aô ning Malatine. ");
INSERT INTO ymp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yêni hevong bêng hîtôm sêmbôk be henang ethak ya plopet matheng be enang nena, ");
INSERT INTO ymp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","tem Wapômbêng êŋgêv aô vê injêk ŋakyo lêk ŋa takatu be kapôlôŋing êndô aô baheŋing. ");
INSERT INTO ymp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bêng be yêni hêv kapô vo aô ning bumalô lêk la hêv ya tava matheng ");
INSERT INTO ymp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","atu be hevak vo nembatho ambô sêmbôk be hevak hiving aô ning bumalô Ablaham long nena ");
INSERT INTO ymp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tem nêŋgêv aô vê injêk ŋakyo ning lêklokwang vo aômbong ya ku me dô aô kô andô ");
INSERT INTO ymp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","vo aômô matheng lêk thêthôp injêk Wapômbêng mandaluk îtôm wak nômbêng iti sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Bêng be ong yînîng wakna, tem numung vo nôpôpêk Anômbêng ya loŋdaŋlê vo nêlêm, be ditu tem edam ong nena Wapômbêng Leng ya plopet. ");
INSERT INTO ymp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Me tem nombong be ya avîlanô ining auk ipuak vo eyala nena Wapômbêng tem nêŋgêv loho ning kambom vê me hethak loŋdaŋlê êng yom me tem nimbua loho vê injêk ining kambom. ");
INSERT INTO ymp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Aô ning Wapômbêng lahiki bêng anông be ditu hêv kapô vo aô be tem nembong nôm êng lêk nêŋgêv anô te lêm nang leng îtôm wak ");
INSERT INTO ymp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","vo nêŋgêv danda êndêng avîlanô takatu be îmô momaŋaning bêng kapô be êkô ema. Lêk ya danda êng tem nêŋgêv aô livung vo aômbeng loŋdaŋlê lambali mavî.” ");
INSERT INTO ymp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Me Jon hilumbak bêng be hivutak lêklokwang hethak dôhô ya kombom mavî. Me hê hîmô long thiliv hele be ya wakma hêlêm yêing be hevong ku heva avîlanô Islael maleŋing. ");
INSERT INTO ymp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hêndêng waklavông takêng te me Sisa Ogastus hevak ambô manjeng te vo imbua avîlanô pîk takatu be Lom eyaŋging sapêng ining athêng. ");
INSERT INTO ymp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wakma êng me muŋdaluk anông vo Sisa Ogastus ya gakmang iwa avîlanô ning athêng. Hêndêng wakma êng yom me Kulinius hîmô hîtôm plovins Silia ining gavana. ");
INSERT INTO ymp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Êng me avîlanô sapêng ê ining melak ondong tomtom vo imbua loho ning athêng. ");
INSERT INTO ymp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep hivutak nang King Devit ya lêkma, be ditu hetak Nasalet nang Galili me hê Devit ya melak ondong Betlehem nang Judia. ");
INSERT INTO ymp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yêni hê hiving Malia, avî atu be tem nimbua, vo nekavu thêi ning athêng. Wak êng me Malia bôk hethambeng yôv. ");
INSERT INTO ymp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Thêi mô Betlehem denang me Malia ya waklavông hêyô vo nembathu. ");
INSERT INTO ymp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Me hevathu namalô bôp be hivuliv îlôk kwak be hêndô hêk bokmaŋkao ning kambum, vômbê nena melak kapô te mî hêk oyang vo thêi mô amî. ");
INSERT INTO ymp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Me ŋa eyaŋging boksipsip doho îmô long êng vi yêing be eyaŋging ining bok hêndêng bîlîvông. ");
INSERT INTO ymp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Me Anômbêng ya aŋêla te hêyô vo loho lêk Anômbêng ya danda lêkmaŋging be hîmbî helawê loho be êkô kambom. ");
INSERT INTO ymp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Metom aŋêla henang nena, “Dô môlô kô andô. Ondaŋô! Ya hauwa ambô mavî te be ya halêm vo môlô be tem nembong avîlanô sapêng leŋing mavî anông. ");
INSERT INTO ymp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lêk iti hêk Devit ya melak ondong me avî te hevathu sêik te be tem nîmô îtôm môlô ning Malatine. Yêni Anômbêng me yêni Mesaya. ");
INSERT INTO ymp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tem môlôŋgô lavuning te bêŋiti nena ivuliv sêik kasek te ethak kwak be hêk bokmaŋkao ning kambum te.” ");
INSERT INTO ymp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aŋêla henang ambô êng yôv me ketheng oyang me aŋêla bêng anông nang melak leng êyô vo yêni. Be loho êv Wapômbêng ya athêng ling be enang nena, ");
INSERT INTO ymp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Athêng lêkmaŋging êndêng Wapômbêng îmô melak leng, me lambali êndêng avîlanô pîk takatu be Wapômbêng la mavî hethak loho.” ");
INSERT INTO ymp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aŋêla etak loho be ê melak leng me ŋa eyaŋging bok enang ethak i nena, “Aô na vo aôŋga nôm atu be Anômbêng henang ethak aô nena lêk hivutak Betlehem.” ");
INSERT INTO ymp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Êng me loho ê ketheng me êpôm Malia lo Josep me sêik kasek atu be hêk bokmaŋkao ning kambum te. ");
INSERT INTO ymp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Loho yê yôv me enang ambô takatu be aŋêla henang hêndêng loho hethak sêik kasek êng. ");
INSERT INTO ymp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Me avîlanô elaŋô ŋa eyaŋging boksipsip ining ambô êng be esong kambom. ");
INSERT INTO ymp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Me Malia la hêv ambô takêng be hevalong long hêk kapô. ");
INSERT INTO ymp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Me ŋa eyaŋging boksipsip ele ê me êv Wapômbêng ya athêng ling hethak leng lêk leŋing mavî bêng anông hêndêng Wapômbêng hethak nôm takatu be loho yê lo elaŋô hîtôm aŋêla bôk henang ethak loho. ");
INSERT INTO ymp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wak bahevi be lahavôlô hele be hê me eŋgothe sêik kasek êng ya kôpik be elam ya athêng nena Yisu. Athêng êng me Malia mî hethambeng amî denang me aŋêla bôk hêv yôv. ");
INSERT INTO ymp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Josep lo Malia ning waklavông imbutak mambung injêk Wapômbêng mandaluk hêyô hîtôm balambung atu be Moses bôk hekavu. Êng me thêi iwa Yisu be ê Jelusalem vo êŋgêv êndêng Anômbêng ");
INSERT INTO ymp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","hîtôm ya balambung bôk henang yôv nena, “Sêik malô mung sapêng me ôŋgêv êndêng Anômbêng.” ");
INSERT INTO ymp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Be ditu thêi iwa menak yi be ê vo êŋgêv da hîtôm Anômbêng ya balambung bôk henang nena imbua “menak bôbô map lokwaŋyi mena thaumbôm map lokwaŋyi ma.” ");
INSERT INTO ymp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Me anô te hîmô Jelusalem be ya athêng nena Simion. Yêni me anô thêthôp be thak hesopa Wapômbêng avanông bing. Yêni heyambing Mesaya atu be tem nêŋgêv Islael thîvô. Me Lovak Matheng hîmô hiving yêni. ");
INSERT INTO ymp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Lovak Matheng bôk henang ethak yêni yôv nena tem mî nema amî me nîmô endebe ninjê Mesaya atu be Anômbêng bôk hevak ambô vo nêŋgêv êlêm yôvêm. ");
INSERT INTO ymp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Me Lovak Matheng helom yêni be hê melak matheng ya popatîng kapô. Me Josep lo Malia iwa Yisu be êlêm vo esopa ambô balambung hîtôm limi ning kombom. ");
INSERT INTO ymp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Me Simion hisip wakna kasek hîmô bang me hêv Wapômbêng ya athêng ling be henang nena, ");
INSERT INTO ymp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Anômbêng, ya yong anô ku. Lêk yôv me notak ya vo yana lêk ya lambali mavî hîtôm sêmbôk be honang. ");
INSERT INTO ymp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Lêk ya maleng êyê ôpatu be hôêv êlêm vo nimbua yoô vê injêk kambom ya vuli yôv. ");
INSERT INTO ymp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Hôpôpêk loŋdaŋlê êng hêk avîlanô sapêng maleŋing. ");
INSERT INTO ymp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Loŋdaŋlê êng me hîtôm danda vo avîlanô long bôyang injê, me tem nêŋgêv athêng lêkmaŋging êndêng yong avîlanô Islael.” ");
INSERT INTO ymp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yisu lambô lo talêmbô elaŋô Simion ya ambô atu be henang ethak wakna êng be esong kambom. ");
INSERT INTO ymp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Yôv me Simion hêv mek êndêng loho be henang ethak sêik êng talêmbô Malia nena, “Nondaŋô. Wapômbêng hetak wakna ti vo nembong avîlanô Islael bêng anông tem imbua vuli kambom me bêng anông tem imbua vuli mavî. Yêni tem nîmô îtôm Wapômbêng ya lavuning te, metom avîlanô bêng anông tem enang ambôma ethak yêni. ");
INSERT INTO ymp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Be ditu tem avîlanô bêng anông ining auk long kapô tem nimbutak yêing. Be tem kapôlôm inding ong îtôm bîng vovak hevatho ong bimdaluk.” ");
INSERT INTO ymp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Me plopet avî te hîmô hiving be ya athêng nena Ana. Yêni me Panuel nalavî be hivutak nang Asel ya ondong. Wakma yêni hîmô avî voyavô me hiwa anô te be hîmô hiving hîtôm sondakbêng bahevi be lahavôyi. Yôv me yamalô hema be yêni hîmô hele be bôk heyalôv be ya sondakbêng lêk hîtôm 84. Wak lo bîlîvông me mî hetak melak matheng ya popatîng amî, me thak hitip ethak nôm lêk heteng mek be hêv yeng hethak Wapômbêng. ");
INSERT INTO ymp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Me wakma Simion henang ambô denang me avî êng hê bidong vo loho me hêv la mavî hêndêng Wapômbêng. Me henang ambô hethak wakna kasek êng hêndêng avîlanô takatu be îmô vo eyaŋging waklavông atu be Wapômbêng imbua avîlanô Islael vê injêk ining malêing. ");
INSERT INTO ymp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep lo Malia evong nômkama sapêng hîtôm Anômbêng ya balambung henang, yôvêm me ele ê ining long Nasalet hêk Galili hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Me wakna hilumbak be hivutak lêklokwang. Me ya auk mavî anông be Wapômbêng ya la mavî hîmô hiving yêni. ");
INSERT INTO ymp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sondakbêng nômbêng iti me Yisu talêmbô lo lambô thak ê Jelusalem vo injê Waklavông Hêv Lîlîng. ");
INSERT INTO ymp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Me Yisu ya sondakbêng hîtôm lauming be lahavôyi me loho sopa kombom atu be ê êyê waklavông êng îlôk Jelusalem. ");
INSERT INTO ymp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Waklavông bêng êng hele hîlôk me loho ele ê ning long. Me wakna Yisu me hîmô Jelusalem denang. Me talêmbô lo lambô îthông paling be ê. ");
INSERT INTO ymp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Me thêi song nena lêk hiving ya avîlanô vi be hê ma. Be ditu eveng wak daluk te yôvêm me êyê nena yêni mî, êng me loho ithupav be ethalo yêni heveng ining avîlanô lîvông. ");
INSERT INTO ymp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Metom mî êpôm amî, êng me thêi îvôê Jelusalem hethak loŋbô vo ethalo yêni. ");
INSERT INTO ymp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wak lô hele be hê yôv me êpôm yêni hîmô melak matheng kapô. Yêni hîmô hiving kîdôŋga doho be helaŋô loho ning ambô be henang ik ŋa êng ling ethak ambô takatu be loho nang. ");
INSERT INTO ymp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Avîlanô takatu be elaŋô ya ambô lêk êyê ya auk bêng lêk ambô henang viyang be esong kambom. ");
INSERT INTO ymp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Me lambô lo talêmbô êyê yêni be esong kambom hiving. Be talêmbô henang nena, “Yînîng wakna, hovong ômbête bêng ethak yêi? Yêi leŋing malêing bêng be athalo ong eveng.” ");
INSERT INTO ymp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Me Yisu henang viyang nena, “Mamu thalo ya vo? Mî mamu yala nena tem ya mô Wakamik ya melak amî mesa?” ");
INSERT INTO ymp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Metom thêi thông ambô êng ya ondong paling. ");
INSERT INTO ymp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yôv me hiving talêmbô lo lambô be loho ê Nasalet me thak helovak thêi ning ambô vimbing. Me talêmbô hevalong nôm takatu be henang be hevong long hêk kapô. ");
INSERT INTO ymp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yisu hivutak bêng me ya auk mavî anông. Me Wapômbêng lêk avîlanô leŋing tom be leŋing mavî hethak yêni. ");
INSERT INTO ymp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Hêndêng sondakbêng lauming be lambahevi atu be king Sisa Taibelias heyaŋging Lom me Pontius Pailat hîmô hîtôm Judia ining gavana, me Helot Antipas heyaŋging Galili, me yang molok Pilip heyaŋging Itulia lêk Takonitis, me Lisanias heyaŋging Abilene, ");
INSERT INTO ymp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","me Anas lo Kaiapas îmô hîtôm kwandôk bêng îmbôk da. Hêndêng wak êng me Sekalaia nakandung Jon hîmô long thiliv me Wapômbêng hêv ya ambô hêndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Êng me Jon hê eveng long takatu be hîmô bidong ŋanam Yelodan me henang vo avîlanô ende kapôlôŋing lîlîng be ithik ŋanam vo Wapômbêng tem nêŋgêv loho ning kambom vê. ");
INSERT INTO ymp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hevong bêng hîtôm plopet Aisaia bôk hekavu hîlôk ya kapua nena, “Kaêk te helam heveng long thiliv nena, ‘Ôpôpêk loŋdaŋlê vo Anômbêng êlêm, me opesang be nimbutak thêthôp vo yêni. ");
INSERT INTO ymp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Uthivung kolong sapêng thing me onde dumlôlê sapêng pesa be nimbutak kalông. Me opesang loŋdaŋlê lêkgwak be nimbutak thêthôp me loŋdaŋlê hethak be hîlôk me opesang be nimbutak thêthê mavî. ");
INSERT INTO ymp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Me avîlanô pîk sapêng tem injê Malatine atu be Wapômbêng hêv hêlêm ya ku.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Avîlanô bêng anông ê hêndêng vo nithik loho metom henang ethak loho nena, “Môlô me bôyîv kambom nali! Osong nena tem ya thik môlô vo ôsôv injêk Wapômbêng ya la maning e? Mî anông! ");
INSERT INTO ymp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Be ditu môlô ning kombom iŋgik thô imbing nena lêk ole kapôlômim lîlîng yôv. Me dô lemim êŋgêv auk te be onang ethak amda nena, ‘Ablaham me yoô ning bumalô, be ditu yoô me avîlanô thêthôp.’ Mî. Ya hanang ethak môlô nena Wapômbêng hîtôm nimbua valu takiti be nepesang Ablaham limi ethak. ");
INSERT INTO ymp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Iyam lêk hêk alokwang ondong yôv vo alokwang takatu be mî hik anông mavî amî me tem ende li be îmbôk ethak amela.” ");
INSERT INTO ymp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Me avîlanô nômbêng atu be elaŋô ya ambô enang ik yêni ling nena, “Tem yoômbong ômbête?” ");
INSERT INTO ymp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Me Jon henang nena, “Opalê atu be ya kwêv yi hîmô me nêŋgêv yang êndêng ôpyang atu be kwêv mî. Me opalê atu be ya nôm hîmô me nêŋgêv doho êndêng ôpyang atu be nôm mî.” ");
INSERT INTO ymp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Me ŋa iwa takis doho êlêm vo Jon ithik loho imbing be enang ik yêni ling nena, “Kîdôŋga, tem yoômbong ômbête?” ");
INSERT INTO ymp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Me Jon enang ethak loho nena, “Môlômbua takis îtôm Lom ining anômbêng henang yom me dô umbua doho oyang êyômô imbing andô.” ");
INSERT INTO ymp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Me ŋa vovak doho enang ik yêni ling hiving nena, “Me tem yoômbong ômbête?” Me henang ethak loho nena, “Lemim êŋgêv nena ovong ku alêla be êv môlô vuli ethak vithê me ditu hîtôm yom. Me dô môlômbong avîlanô êkô be êŋgêv ining valuseleng êndêng môlô andô. Lêk dô ômbî ambô oyang ethak avîlanô takatu be mî evong kambom te amî vo umbua ining valuseleng andô.” ");
INSERT INTO ymp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Avîlanô Islael thak êv maleŋing vo Mesaya nena tem nêlêm. Be ditu êyê Jon hevong ku takêng be leŋing êv nena betha Mesaya atu ma. ");
INSERT INTO ymp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Metom Jon henang ethak loho nena, “Ya hathik môlô hethak ŋanam, metom ôpatu be tem nembeng ya yam me ya lêklokwang me bêng anông vo yînîng. Yêni me anô lêk athêng bêng me ya me ya hamô ŋa ku oyang vimbing, be mî hîtôm ya pole ya vakapô bokgôp ya yak vê amî. Yêni tem nithik môlô ethak Lovak Matheng lêk amela. ");
INSERT INTO ymp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Me hevalong ya sala vo nethong ini wit be nîtîtînîng vo kôpik lêk limbalôm sapêng eŋgololong endebe nitup êm. Mîng nimbua ya anông be ni tak îmô melak kapô, metom ya kôpik me nîmbôk ethak amela atu be mî nema amî.” ");
INSERT INTO ymp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Me Jon enang ambô bêng anông hiving vo niŋgik avîlanô leŋing ling me henang Wapômbêng ya Ambô Mavî hêndêng loho. ");
INSERT INTO ymp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lêk hethang Galili ning Anômbêng Helot hethak ya kombom kambom takatu be hevong be henang nena, “Bisête be huwa aviyam yanavî Helodias hîtôm vônîm?” ");
INSERT INTO ymp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Êng me Helot evong kambom yang hethak loŋbô nena hetak Jon hîlôk kalaondong. ");
INSERT INTO ymp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Waklavông atu be Jon hithik avîlanô me hithik Yisu hiving. Hithik yôvêm me Yisu heteng mek me leng hikê. ");
INSERT INTO ymp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Me Lovak Matheng hîlôk be hêlêm nang menak bôbô be hêyô hîmô yêni. Me kaêk te hêlêm nang leng be henang nena, “Ong me yînîng wakna atu be ya leng hiving anông. Me ya leng mavî anông hethak ong.” ");
INSERT INTO ymp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisu ya sondakbêng me hîtôm 30 ma me hevong ya ku muŋdaluk heveng avîlanô maleŋing. Me avîlanô eyala nena yêni me Josep nakandung. Josep me Heli nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Me Heli me Matat nakandung. Matat me Livai nakandung. Livai me Melki nakandung. Melki me Janai nakandung. Janai me Josep nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep me Matatias nakandung. Matatias me Amos nakandung. Amos me Nahum nakandung. Nahum me Esli nakandung. Esli me Nagai nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai me Mat nakandung. Mat me Matatias nakandung. Matatias me Semen nakandung. Semen me Josek nakandung. Josek me Joda nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda me Joanan nakandung. Joanan me Lesa nakandung. Lesa me Selubabel nakandung. Selubabel me Sealtiel nakandung. Sealtiel me Neli nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli me Melki nakandung. Melki me Adi nakandung. Adi me Kosam nakandung. Kosam me Elmadam nakandung. Elmadam me El nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","El me Josua nakandung. Josua me Eliesel nakandung. Eliesel me Jolim nakandung. Jolim me Matat nakandung. Matat me Livai nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai me Simion nakandung. Simion me Juda nakandung. Juda me Josep nakandung. Josep me Jonam nakandung. Jonam me Eliakim nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim me Melea nakandung. Melea me Mena nakandung. Mena me Matata nakandung. Matata me Natan nakandung. Natan me Devit nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit me Jesi nakandung. Jesi me Obet nakandung. Obet me Boas nakandung. Boas me Salmon nakandung. Salmon me Nason nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason me Aminadap nakandung. Aminadap me Atmin nakandung. Atmin me Alni nakandung. Alni me Heslon nakandung. Heslon me Peles nakandung. Peles me Juda nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda me Jekop nakandung. Jekop me Aisak nakandung. Aisak me Ablaham nakandung. Ablaham me Tela nakandung. Tela me Naho nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho me Seluk nakandung. Seluk me Leu nakandung. Leu me Pelek nakandung. Pelek me Ebel nakandung. Ebel me Sela nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela me Kainan nakandung. Kainan me Alpaksat nakandung. Alpaksat me Sem nakandung. Sem me Noa nakandung. Noa me Lamek nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek me Metusela nakandung. Metusela me Inok nakandung. Inok me Jalet nakandung. Jalet me Mahalalel nakandung. Mahalalel me Kenan nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan me Enos nakandung. Enos me Set nakandung. Set me Adam nakandung. Adam me Wapômbêng nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jon ithik Yisu yôv me Lovak Matheng hevong ku lêklokwang hîmô Yisu kapô, êng me hetak ŋanam Yelodan hêk. Me Lovak Matheng helom yêni be hê long thiliv. ");
INSERT INTO ymp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Me hîmô long êng hîtôm wak buŋdaluk yi vo Sakdang eyek yêni. Me mî ninjang nôm amî hele be wak takêng hele hîlôk yôv me mîng hema ve la. ");
INSERT INTO ymp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Me Sakdang henang ethak inda nena, “Betha avanông ong me Wapômbêng Nakandung, êng me nonang vo valu tiêng imbutak îtôm polom.” ");
INSERT INTO ymp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Metom Yisu henang viyang nena, “Wapômbêng ya kapua henang nena, ‘Anô mî hîtôm nîmô lêkmala ethak polom yom amî.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yôvêm me Sakdang helom Yisu be hethak be hê dum dêim te. Ketheng oyang me hik pîk bêŋiti sapêng ya melak lông bêŋbêng ining dôhô thô hêndêng yêni hîtôm hêyê wêng. ");
INSERT INTO ymp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Me henang ethak Yisu nena, “Tem yaŋgêv long takiti êng ining athêng bêng lêk ining lêkmaŋging sapêng êndêng ong vo noyaŋging. Nôm takiti me yînîng be ya leng hiving yaŋgêv êndêng opalê, êng me tem yaŋgêv yom. ");
INSERT INTO ymp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Be ditu noya vem budum thîvô be nôŋgêv yeng ethak ya me tem yaŋgêv nômkama takiti sapêng êndêng ong.” ");
INSERT INTO ymp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Me Yisu henang nena, “Bôk ekavu yôv nena, ‘Nôŋgêv yeng êndêng Wapômbêng yong Anômbêng lêk nombong yêni yom ya ku.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yôv me Sakdang hiwa yêni be hê Jelusalem me hetak yêni heva melak matheng ya vôv anông. Me henang ethak inda nena, “Avanông, betha ong me Wapômbêng Nakandung, êng me nôsôv kisi be nu tamu pîk ");
INSERT INTO ymp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","vômbê nena bôk ekavu yôv nena, “ ‘Yêni tem nenang be ya aŋêla embalong ong be eyaŋging ong mavî ");
INSERT INTO ymp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","vo valu te dô nîmbî vemkapô andô.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Me Yisu henang nena, “Bôk ekavu yôv nena, ‘Dô noyek Wapômbêng yong Anômbêng andô.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sakdang eyek Yisu vo nembong kambom takêng yôvêm me hetak yêni be hê me heyambing wakma yang vo neyek inda ethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Hethak Lovak Matheng ya lêklokwang me Yisu hele hê Galili hethak loŋbô. Me ya kôkôthing heveng long takêng sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Me hîndông loho hîmô ining melak yeng be avîlanô sapêng êv ya athêng ling. ");
INSERT INTO ymp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Me Yisu hê Nasalet, long êng me ya long hilumbak bêng îmô. Hêndêng Sabat me hê melak yeng hîtôm ya kombom thak hevong. Hiviyô heva vo nesam Wapômbêng ya ambô. ");
INSERT INTO ymp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Me anô heyaŋging kapua hêv plopet Aisaia ya kapua hêndêng yêni me hekak be hêpôm ambô bôte henang bêŋiti, ");
INSERT INTO ymp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anômbêng ya Lovak Matheng hîmô hiving ya vômbê nena yêni da hîtôk ya vo ya nang ya Ambô Mavî êndêng avîlanô siv. Me hêv ya be ya halêm vo ya nang ethak ŋa takatu be îmô kalaondong vo ende yêing lêk ya nang ethak ŋa maleŋing pusip vo injê tak ethak loŋbô me yaŋgêv ŋa takatu be anô vi êv vovang hêndêng loho vê injêk ining vovang ");
INSERT INTO ymp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","me ya nang bêng nena lêk me Anômbêng ya waklavông hik ya la mavî thô.” ");
INSERT INTO ymp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yôv me hik kapua thing me hêv hêndêng ôpatu be heyaŋging kapua me hîlôk hîmô vo nîndông loho. Me avîlanô takatu be îmô melak yeng êyê yêni lêklokwang. ");
INSERT INTO ymp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Me henang ethak loho nena, “Ambô ti be hêk Wapômbêng ya kapua be lêk olaŋô diti lêk hik anông.” ");
INSERT INTO ymp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Me loho sapêng esong kambom be enang nena ya ambô me mavî anông. Metom enang nena, “Yêni me Josep nakandung, bêng e?” ");
INSERT INTO ymp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Me Yisu henang ethak loho nena, “Ya hayala nena môlô tem onang ambô atu be avîlanô thak enang êndêng ya bêŋiti, ‘Dokta, nombong ong da lemvim kôpik imbutak mavî.’ Yoô bôk alaŋô nôm takatu be hovong hêk Kapenaom. Be ditu nombong bêng injêk yong melak ondong imbing.” ");
INSERT INTO ymp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Me henang nena, “Ya hanang avanông ethak môlô nena, plopet te hê ya melak ondong me ya avîlanô mî thak iwa yêni thô amî. ");
INSERT INTO ymp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Metom ya hanang avanông bing ethak môlô nena, hêndêng Elaija ya waklavông me Islael ining avî tôp bêng anông îmô. Me Wapômbêng hevong be ôthîng mî hik hîtôm sondakbêng lô me wata te hiving be bôm bêng ivutak long êng sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Me Wapômbêng mî hêv Elaija be hê hêndêng avî tôp Islael te amî. Metom hêv yêni hê hêndêng avîlanô long bôyang ining avî tôp te atu be hîmô melak lông Salepat hîmô Saidon ining pik. ");
INSERT INTO ymp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Me bêng yom, sêmbôk atu be plopet Elisa hîmô me Islael ining avîlanô kômbôk lepla bêng anông îmô, metom loho te mî nimbutak mavî amî. Me Elisa hevong anô long bôyang te be ya athêng nena Naiman nang Silia yom hivutak mavî.” ");
INSERT INTO ymp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Me avîlanô takatu be îmô melak yeng elaŋô ambô takêng be leŋing maning kambom. ");
INSERT INTO ymp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Me iviyôva me êv Yisu vê hêk ining melak lông êng. Me imuthing inda hê hêndêng dum atu be elav melak lông hîmô ya dang vo îthô yêni vôkê îndôk bôŋdang. ");
INSERT INTO ymp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Metom Yisu hêv i vê hêk loho lîvông me heveng be hê. ");
INSERT INTO ymp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yôv me Yisu hîlôk be hê Kapenaom nang Galili. Sabat me hîndông avîlanô. ");
INSERT INTO ymp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Avîlanô elaŋô be esong kambom ethak ya ambô atu be hîndông loho vômbê nena, ya ambô êng me lêklokwang anông. ");
INSERT INTO ymp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Melak yeng êng me anô te atu be gôk lêlêik hîmô hiving yêni be helam kaêk lêkwaê nena, ");
INSERT INTO ymp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aê. Yisu nang Nasalet, hôlêm vo nombong ômbête ethak yoô? Hôlêm vo numbuling yoô mesa? Ya hayala ong. Ong me Wapômbêng ya Anô Matheng.” ");
INSERT INTO ymp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Metom Yisu hethang gôk kambom êng be henang nena, “Ong bonong me notak ôpitu.” Me gôk kambom êng hevong be ôpêng hêv yak îlôk pîk hêk loho lîvông me hetak ôpêng be hê me mî hivuling ôpêng amî. ");
INSERT INTO ymp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Me avîlanô sapêng esong kambom be enang ethak i nena, “Ambô alête tiêng? Yêni henang ethak gôk lêlêik hîtôm anô lêk athêng bêng be ya ambô me lêklokwang anông be gôk lêlêik elaŋô be ele yêing be ê.” ");
INSERT INTO ymp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Be ya kôkôthing takêng hê heveng long bêng êng sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Me Yisu hetak melak yeng be hê Saimon ya melak. Me Saimon yaŋavî hevong kômbôk vovang bêng be hêk. Me loho nang ik Yisu ling vo nêŋgêv yêni livung. ");
INSERT INTO ymp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Êng me Yisu hê bidong vo avî êng me hesok kômbôk êng me kômbôk êng hetak yêni. Me ketheng oyang me hiviyô be hê me hepesang nôm vo loho. ");
INSERT INTO ymp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hêndêng wakma wak hê hîlôk me Sabat yandang me avîlanô iwa ŋa lêk kômbôk lomaloma êyô vo Yisu. Me hetak bang hêyô hêk ŋa êng tomtom me sapêng ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Me hevong be gôk kambom etak avîlanô bêng anông be ele yêing be elam nena, “Ong Wapômbêng Nakandung.” Gôk kambom takêng eyala nena yêni me Mesaya, be ditu hethang loho lêklokwang be loho bonong. ");
INSERT INTO ymp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lêkbôk momaŋaning me Yisu hetak long êng me hê long thiliv. Me avîlanô ethalo yêni hele be êpôm yêni. Me loho vong vo embalong yêni long vo dô netak loho bini bôyang andô. ");
INSERT INTO ymp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Metom henang nena, “Tem yana vo ya nang Ambô Mavî ethak Wapômbêng ya lêkliŋyak bêng êndêng avîlanô melak yang imbing, vômbê nena hethak ondong iti yom me Wapômbêng hêv ya be ya halêm.” ");
INSERT INTO ymp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Êng me hê Judia ining melak yeng tomtom me henang Wapômbêng ya ambô hêndêng loho. ");
INSERT INTO ymp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wak te me Yisu heva kasîk bomang nang Genesalet ya dang me avîlanô bêng anông eva be elaŋô Wapômbêng ya ambô be ekalambu yêni thing hêwê heveng. ");
INSERT INTO ymp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Me hêyê ŋa ik alim ŋanam etak ining yeng yi hîmô liŋdang me ê îvôkîng lek. ");
INSERT INTO ymp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Êng me hê hethak Saimon ya yeng me henang ethak inda nena, “Nôlêm omolong yeng doke ni vulu.” Me hîlôk îmô be hîndông avîlanô. ");
INSERT INTO ymp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yêni hîndông avîlanô yôv me henang ethak Saimon nena, “Numbua yeng be nu kasîk lîvông me nokaliv lek îndôk kasîk vo numbua alim.” ");
INSERT INTO ymp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Me Saimon enang nena, “Anômbêng, bokam bîlîvông dêim me yoô kaliv lek hîlôk kasîk hele be mî yoômbôv alim te amî me mî anông. Metom lêk honang, be ditu tem yoô kaliv lek îndôk kasîk.” ");
INSERT INTO ymp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Loho vong bêng me êvôv alim bêng anông bomang be lek hevong itip. ");
INSERT INTO ymp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Êng me ik kayav vo ŋa êvôv alim vi vo êlêm êŋgêv loho livung. Êng me loho lêm êyô be etak alim îlôk yeng luvi hele be hêyô thing be hevong vo nembak yeng luvi thethong. ");
INSERT INTO ymp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Saimon Pita lêk ŋa takatu be îmô hiving yêni êyê alim nômbêng atu be loho êvôv be esong kambom. Êng me Saimon heya vabudum thîvô hîmô Yisu valuvi me henang nena, “Anômbêng, notak ya be nu. Ya anô ya havong kambom.” ");
INSERT INTO ymp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Me Sebedi nakandung Jems lo Jon atu be loho ŋa êvôv alim iving Saimon êyê nôm êng be esong kambom hiving. Me Yisu henang ethak Saimon nena, “Dô nôkô andô. Lêk iti be hê me tem nômbôv avîlanô îtôm lêk hôvôv alim takiti êng.” ");
INSERT INTO ymp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yôv me loho iwa yeng be ê ethak liŋdang me etak ining nômkama sapêng hîmô me ê esopa inda. ");
INSERT INTO ymp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wak te me Yisu hîmô melak lông te me anô palê lepla hêtêtô liŋkôpik te hêlêm. Hêyê Yisu me heya vabudum thîvô be hikum hîlôk pîk. Me hepetenak Yisu lêk kapô malêing nena, “Anômbêng, lem hiving me hîtôm nombong be ya leŋving kôpik imbutak mambung injêk Wapômbêng mandaluk.” ");
INSERT INTO ymp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Êng me Yisu henang nena, “Ya leng hiving.” Be hêthôm ôpêng me henang nena, “Numbutak mambung!” Bôlôtom oyang me palê lepla hetak ôpêng be hivutak lithing anông. ");
INSERT INTO ymp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Me Yisu henang ethak ôpêng nena, “Dô nonang bêng ethak anô te andô. Metom nu me nuŋgik ong thô êndêng anô hîmbôk da me nôŋgêv da êndêng Wapômbêng vo niŋgik thô nena lêk huvutak mambung hîtôm Moses bôk henang yôv. Hovong bêng me tem avîlanô sapêng injê be eyala nena lêk huvutak mambung.” ");
INSERT INTO ymp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Metom Yisu ya kôkôthing hethak ya ku hê mayaliv. Êng me avîlanô bêng anông êlêm vo endaŋô ya ambô lêk nembong loho ning kômbôk mavî. ");
INSERT INTO ymp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Metom wak bêng anông me Yisu thak hetak avîlanô hîmô me hê long thiliv vo neteng mek. ");
INSERT INTO ymp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wak te me Yisu hîndông avîlanô hîmô. Me Palisi lêk kîdôŋga ambô balambung êlêm nang Jelusalem lêk melak takatu be hîmô Galili lêk Judia kapô îmô. Me Anômbêng ya lêklokwang hîmô hiving Yisu be hevong avîlanô lêk kômbôk ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Êng me anô doho êlêm be iwa anô himuving te hiving hêk yêm be êlêm êyô. Loho vong vo imbua yêni bini melak kapô vo etak injêk bidong oyang vo Yisu. ");
INSERT INTO ymp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Metom avîlanô bêng anông be long putup be mî hîtôm imbua yêni bini melak kapô amî. Êng me ethak melak vôv be îlîlô ôpatu lêk yêm hîlôk long ambuang hê hetak avîlanô lîvông hêk Yisu mandaluk. ");
INSERT INTO ymp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yisu hêyê loho ning êv iving me henang ethak anô himuving atu nena, “Aiyang, lêk ya hêv yong kambom sapêng vê.” ");
INSERT INTO ymp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Me Palisi lêk kîdôŋga ambô balambung elaŋô be leŋing êv nena, “Ôpiti me opalê be hesong nena yêni me Wapômbêng mesa? Anô te mî hîtôm nêŋgêv kambom vê amî me Wapômbêng yom.” ");
INSERT INTO ymp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yisu heyala loho ning auk be henang nena, “Hevong bisê be môlô lemim êv bêng? ");
INSERT INTO ymp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ambô alête vumeng vo ya nang: ‘Lêk ya hêv yong kambom sapêng vê’ mesa ‘Numbiyômba be nombeng’? ");
INSERT INTO ymp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Metom tem yaŋgik Anô Ya Nakandung atu thô êndêng môlô nena yêni ya athêng bêng hêk pîk be hîtôm nêŋgêv kambom vê.” Yôv me Yisu henang ethak anô himuving atu nena, “Ya hanang ethak ong nena numbiyômba me numbua yong yêm be nu yong melak.” ");
INSERT INTO ymp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bôlôtom oyang me ôpêng hiviyô heva avîlanô lîvông me hiwa ya yêm be hê ya melak me hêv Wapômbêng ya athêng ling. ");
INSERT INTO ymp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Me avîlanô sapêng esong kambom be êv Wapômbêng ya athêng ling hiving. Me êkô be enang nena, “Lêk aô yê nômate da.” ");
INSERT INTO ymp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yôv me Yisu hê hêyê anô hiwa takis te be ya athêng nena Livai be hîmô melak iwa takis. Me henang ethak ôpêng nena, “Nôlêm osopa ya.” ");
INSERT INTO ymp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Êng me Livai hiviyô heva me hetak ya nômkama sapêng hîmô me hê esopa yêni. ");
INSERT INTO ymp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yôv me Livai hê me heŋgambôm nôm bêng hîmô ya melak vo Yisu. Me ŋa iwa takis bêng anông lêk avîlanô vi eyang nôm hiving thêi. ");
INSERT INTO ymp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Me Palisi lêk kîdôŋga ambô balambung doho thak îmô Palisi kapô êyê be enang ambô ŋôlôŋôlông hethak ya ŋa hîndông nena, “Bisête be môlô oang be unum hiving ŋa iwa takis lêk ŋa evong kombom kambom vo?” ");
INSERT INTO ymp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Êng me Yisu henang nena, “Ŋa lêk kômbôk yom ditu thak ê êyê dokta. Me ŋa kômbôk mî me mî. ");
INSERT INTO ymp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Me bêng yom, ya halêm vo yandam ŋa takatu be evong kombom kambom vo ende kapôlôŋing lîlîng. Me mî ya halêm vo yandam ŋa thêthôp amî.” ");
INSERT INTO ymp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Me loho nang hêndêng Yisu bêŋiti, “Wak bêng anông me Jon ya ŋa hîndông thak itip ethak nôm be eteng mek êndêng Wapômbêng. Me Palisi ining ŋa îndông thak evong bêng yom. Me bisête be yong ŋa hôndông eyang be inum wak nômbêng iti sapêng?” ");
INSERT INTO ymp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Me Yisu henang nena, “Anô te hiwa avî lêkmuk, êng me ya vathi tem injang nôm lêk leŋing mavî me tem mî hîtôm itip ethak nôm amî. ");
INSERT INTO ymp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Metom wakma atu be iwa yêni vê hêk loho, êng me loho tem itip ethak nôm.” ");
INSERT INTO ymp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Me Yisu henang ambô dôhô te bêŋiti, “Anô te mî hîtôm nendambêng thôp lêkmuk bôte be nindi thôp bôô ya ambuang thing ethak amî. Hevong bêng me tem nimbuling thôp lêkmuk be thêi ning leleyang tem mî nîtôm tom amî. ");
INSERT INTO ymp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Me anô te mî thak hêkê waing lêkmuk hîlôk boksipsip ya kôpik bôô amî. Hevong bêng me tem waing lêkmuk imbuling bok kôpik bôô atu be nipupkê be waing eŋgathô ni. ");
INSERT INTO ymp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bêng be ditu thak êkê waing lêkmuk hîlôk bok kôpik lêkmuk atu be belap vo ninding mavî me dô nipupkê andô lêk waing dô neŋgathô ni andô. ");
INSERT INTO ymp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Metom ŋa takatu be inum waing bôô yôv me thak îpôlîk vo waing lêkmuk. Be enang nena, ‘Waing bôô me vathing mavî vo waing lêkmuk.’” ");
INSERT INTO ymp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat te me Yisu lêk ya ŋa hîndông ê eveng kukapô te. Me loho iwa wit ya va be ekakathe hîmô baheŋing kapô vo ya kôpik êŋgêv yak me injang ya anông. ");
INSERT INTO ymp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Metom Palisi doho êyê be enang nena, “Hevong bisê be môlôvong nôm atu be itip nena dô embong êndêng Sabat andô?” ");
INSERT INTO ymp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Me Yisu henang ethak loho nena, “Bôk môlô sam Devit lêk ya ŋa môlôô ning kôkôthing ema vo leŋing be evong bêng mesa mî? ");
INSERT INTO ymp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yêni hêyô Wapômbêng ya melak sel ya popatîng kapô be hiwa polom matheng atu be ŋa îmbôk da yom ining vo injang. Metom Devit heyang me hêv doho hêndêng ya ŋa takatu be eveng hiving yêni be eyang.” ");
INSERT INTO ymp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yôv me Yisu henang ethak loho nena, “Anô Ya Nakandung atu me Sabat ya Alang.” ");
INSERT INTO ymp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat yang me Yisu hêyô melak yeng te be hê me hîndông avîlanô hîmô. Me anô te hîmô long êng be bang viyôhôk bôk ema. ");
INSERT INTO ymp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Me Palisi lêk kîdôŋga ambô balambung doho îmô be êyê Yisu manjeng vo injê nena tem nembong avîlanô lêk kômbôk mavî êndêng Sabat mesa mî. Loho thalo loŋdaŋlê vo enang yêni bêng. ");
INSERT INTO ymp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Metom heyala loho ning auk be henang ethak anô bang ema atu nena, “Nôlêm omba avîlanô lîvông.” Êng me ôpêng hiviyô be hê. ");
INSERT INTO ymp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Me Yisu henang ethak loho nena, “Ya havong vo ya nang iŋgik môlô ling. Ômbête me thêthôp vo aômbong êndêng Sabat? Hîtôm aômbong mavî mesa aômbong kambom? Hîtôm aôŋgêv anô te livung vo nîmô lêkmala mesa aômbuling yêni vo nema?” ");
INSERT INTO ymp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Me Yisu hêyê loho sapêng hêwê heveng me henang ethak ôpatu nena, “Noto bahem.” Êng me ôpêng hevong bêng me bang hivutak mavî hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Metom kîdôŋga ambô balambung lêk Palisi leŋing maning kambom be enang ethak loho da hê be hêlêm nena, “Tem aômbong ômbête ethak yêni?” ");
INSERT INTO ymp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wak te me Yisu hethak dum te be hê vo neteng mek. Me bîlîvông êng hele be heyang me heteng mek yom hêndêng Wapômbêng. ");
INSERT INTO ymp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Heyang wakbêng me helam ya ŋa hîndông êlêm ethak tom. Me hîtôk loho tomtom hîtôm lauming be lahavôyi me helam loho nena aposol. ");
INSERT INTO ymp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Loho te me Saimon be hêv athêng lêkmuk hêndêng inda nena Pita me yang molok Endulu hiving Jems lo Jon me Pilip lo Batolomiu ");
INSERT INTO ymp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","me Matyu lo Tomas me Jems Alpius nakandung me Saimon atu be elam nena anô Selot ");
INSERT INTO ymp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","me Judas Jems nakandung me Judas Iskaliot, ôpatu be yôk ketem netak Yisu îndôk ŋakyo baheŋing. ");
INSERT INTO ymp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yôv me Yisu lêk ya ŋa hîndông îlôk be ê kalông bôte. Me ya ŋa hîndông vi îmô long êng lêk avîlanô bêng anông êlêm nang Judia lo Jelusalem me avîlanô mamik Taia lo Saidon êlêm iving. ");
INSERT INTO ymp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Loho lêm vo endaŋô ya ambô lêk nembong loho ning ŋa lêk kômbôk mavî. Me ŋa lêk gôk lêlêik ivuling loho me Yisu hêv gôk takêng vê be loho ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Me avîlanô bêng anông evong vo êthôm yêni, vômbê nena lêklokwang bêng anông îmô inda be ditu thak hevong avîlanô sapêng ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yôv me Yisu hik i lîlîng be hêyê ya ŋa hîndông me henang ethak loho nena, “Mavî vo môlô avîlanô siv, vômbê nena Wapômbêng ya lêkliŋyak bêng me môlô ning. ");
INSERT INTO ymp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Me mavî vo môlô ŋa takatu be lêk oma vo lemim, vômbê nena tem lemvimyak. Me mavî vo môlô avîlanô takatu be lêk oleng, vômbê nena tem omalîk. ");
INSERT INTO ymp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Me mavî vo môlô avîlanô takatu be wakma avîlanô kapôlôŋing êndô môlô lêk enang ambôma ethak môlô be êv dômîng êndêng môlô vômbê nena osopa Anô Ya Nakandung. ");
INSERT INTO ymp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Vômbê nena loho ning bumalô bôk evong kombom tomêng yom hêndêng plopet sapêng. Bêng be ditu wakma nôm takêng ivutak me môlô lemim mavî, vômbê nena Wapômbêng tem nêŋgêv vuli mavî bêng te êndêng môlô injêk melak leng. ");
INSERT INTO ymp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Metom malêing bêng vo môlô ŋa lêk nômkama bêng anông. Lêk uwa môlô ning nômkama lêk lemim mavî yôv. ");
INSERT INTO ymp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Me malêing bêng vo môlô ŋa takatu be lêk lemviŋyak. Tem oma vo lemim. Me malêing bêng vo môlô ŋa takatu be lêk omalîk. Tem lemim malêing kambom be ondeng. ");
INSERT INTO ymp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Me malêing bêng vo môlô ŋa takatu be lêk avîlanô sapêng êv môlô ning athêng ling. Loho ning bumalô bôk êv plopet ambô yôhîng ining athêng ling bêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Metom ya hanang ethak môlô ŋa takatu be lêk olaŋô ya nena lemim imbing môlô ning ŋakyo me ombong kombom mavî êndêng ŋa kapôlôŋing êndô môlô. ");
INSERT INTO ymp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Me ôŋgêv mek mavî êndêng ŋa takatu be êv mek kambom êndêng môlô. Me oteng mek vo Wapômbêng embong mavî êndêng ŋa takatu be evong kambom hêndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Me anô te hepetav malem dang vi, êng me nuŋgik vi lîlîng vo nepetav imbing. Me anô te hiwa yong kwêv dêim atu be huik, êng me notak yêni vo nimbua yong kwêv yang imbing. ");
INSERT INTO ymp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Me anô te henang ik ong ling hethak nômkama, êng me nôŋgêv yom. Me anô te hiwa yong nômkama, êng me dô nonang vo nêŋgêv endelêm ethak loŋbô andô. ");
INSERT INTO ymp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Me kombom atu be lem hiving avîlanô embong êndêng ong, êng me nombong bêng yom êndêng avîlanô vi. ");
INSERT INTO ymp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Me môlô lemim iving ŋa takatu be leŋing iving môlô yom, êng me osong nena tem môlômbua vuli mavî te e? Mî anông. Ŋa evong kombom kambom thak evong bêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Me môlô thak ovong kombom mavî hêndêng ŋa takatu be evong kombom mavî hêndêng môlô yom, êng me osong nena tem môlômbua vuli mavî te e? Mî anông. Ŋa evong kombom kambom thak evong bêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Me môlô êv nômkama hêndêng ŋa takatu be lemim êv nena tem êŋgêv viyang, êng me osong nena tem môlômbua vuli mavî te e? Mî anông. Ŋa takatu be thak evong kombom kambom thak êv ining nômkama hêndêng avîlanô vi atu be evong kombom kambom bêng yom, vômbê nena leŋing êv nena ŋa takêng tem êŋgêv ining nômkama sapêng endelêm ethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Metom Wapômbêng leng thak hevong kombom mavî hêndêng ŋa wambuk lêk ŋa evong kambom hiving. Be ditu tem môlôŋgik thô nena môlô me yêni nali be lemim imbing môlô ning ŋakyo be ombong kombom mavî lêk ôŋgêv nômkama oyang êndêng loho me dô lemim êŋgêv nena loho êŋgêv viyang andô. Ovong bêng me heveng yam me tem umbua vuli bêng. ");
INSERT INTO ymp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Me môlô kapôlômim iŋgik am ethak avîlanô sapêng îtôm môlô ning Kamik kapô hiki hethak avîlanô pîk sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Dô môlô nang avîlanô vi ning kambom bêng be onang nena loho avîlanô kambom andô. Môlôvong bêng me Wapômbêng tem mî nembong bêng ethak môlô amî. Me dô onang ethak avîlanô vi nena tem lohombua ning kambom ya vuli andô. Môlô nang bêng me Wapômbêng tem nenang bêng ethak môlô imbing. Me anô te hevong kambom hêndêng môlô, êng me otak ya kambom. Môlôvong bêng me Wapômbêng tem nêŋgêv môlô ning kambom vê bêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Me môlô êv nômkama hêndêng avîlanô vi, êng me Wapômbêng tem nêŋgêv nômkama êndêng môlô bêng yom. Metom yêni tem nêŋgêv bêng anông êyômô imbing. Kombom alê atu be ovong êndêng avîlanô vi me tem yêni sopa môlô ning kombom be nembong bêng yom êndêng môlô.” ");
INSERT INTO ymp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yôvêm me Yisu henang ambô dôhô te hêndêng loho nena, “Hîtôm anô mandaluk pusip yang endom anô mandaluk pusip yang mesa? Mî anông. Thêi luvi tem êŋgêv yak îndôk lovang. ");
INSERT INTO ymp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sêik kapua me mî bêng vo ining kîdôŋga amî. Metom ethak melak yôvêm me tem imbutak îtôm ining kîdôŋga. ");
INSERT INTO ymp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Bisête be hôyê siŋusik hîmô aviyam mandaluk me mî hôyê aseleng bêng atu be hepalaŋganing hêk malemdaluk thing amî? ");
INSERT INTO ymp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Me bisête be honang hêndêng aviyam nena, ‘Aiyang, ya leng hiving yaŋgêv siŋusik itu be hîmô malemdaluk vê’? Metom ong da mî hôyê aseleng atu be hepalaŋganing hêk malemdaluk thing be nôŋgêv vê amî, be ditu ong anô ambô yôhîng. Nôŋgêv aseleng bêng atu be hepalaŋganing hêk malemdaluk thing vê vo nôŋgô tak katô êm kîmîng nôŋgêv siŋusik atu be hîmô aviyam mandaluk vê.” ");
INSERT INTO ymp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Alokwang mavî mî thak hik anông kambom amî. Me alokwang kambom mî thak hik anông mavî amî. ");
INSERT INTO ymp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Me anô thak êyê alokwang ya anông me eyala nena alokwang mavî mena alokwang kambom ma. Me anô thak mî hîtôm imbua alokwang pik lêk yak waing anông emba yak lêklilu amî. Mî anông. ");
INSERT INTO ymp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Be ditu auk mavî hîmô anô te kapô me tem nembong kombom mavî. Me auk kambom hîmô anô te kapô me tem nembong kombom kambom. Be ditu kombom alê hîvôlô anô te kapô thing ditu tem nenang ende ambôlêk.” ");
INSERT INTO ymp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Bisête be thak môlô lam ya nena ‘Anômbêng’ lômbôlông, metom mî thak osopa yînîng ambô amî? ");
INSERT INTO ymp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Me ôpatu be hêlêm hêndêng ya be helaŋô yînîng ambô be hesopa me tem ya nang ôpêng ya kombom lavông êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yêni me hîtôm ôpatu be helav ya melak landîng hîlôk pîk lêk valu be hevalong long manjeng. Me ŋanambô bêng hêyô be hîlônîng melak êng metom mî hipu amî, vômbê nena pîk lêk valu hevalong long manjeng. ");
INSERT INTO ymp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Metom ôpatu be helaŋô yînîng ambô be mî hesopa amî, êng me hîtôm helav ya melak hêyô hîmô pîk atu be valu mî. Be ditu ŋanambô bêng hêyô be hekalông melak êng me hipu ketheng oyang.” ");
INSERT INTO ymp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yisu henang ambô takêng hêndêng avîlanô yôvêm me hê Kapenaom. ");
INSERT INTO ymp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Me anô vovak lêik te nang Lom hîmô be yêni thak la hiving ya anô ku te bêng anông, metom ya anô ku êng hêpôm kômbôk kambom be hevong ema. ");
INSERT INTO ymp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Anô vovak lêik atu helaŋô Yisu ya kôkôthing, êng me yêni hêv ŋa Juda ning avaka doho be ê hêndêng Yisu vo enang iŋgik yêni ling vo nêlêm embong ya anô ku êng mavî. ");
INSERT INTO ymp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Loho yô vo Yisu me enang lêk kapôlôŋing malêing nena, “Ôpiti me anô mavî, be ditu mavî vo nôŋgêv yêni livung. ");
INSERT INTO ymp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ôpêng thak la hiving aô ŋa Juda be bôk helav aô ning melak yeng.” ");
INSERT INTO ymp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Êng me Yisu hê hiving loho. Be ê êyô bidong anô vovak lêik ya melak me ôpêng hêv ya ŋa môlôô doho be ê hêndêng Yisu be enang ethak inda nena, “Anô vovak lêik henang bêŋiti, ‘Anômbêng, dô nôlêm andô. Ya mî anô mavî vo nôlêm yînîng melak kapô amî, be ditu dô. ");
INSERT INTO ymp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Me bêng yom me ya mî anô mavî vo ya thôk aŋga ong amî. Me ya hamô anômbêng te vimbing me yînîng ŋa vovak îmô ya vimbing bêng yom. Me thak ya hanang hêndêng yînîng anô vovak te nena, “Nu,” me thak hê. Me ya hanang ethak yang nena, “Nôlêm,” me thak hêlêm. Me ya hanang ethak anô ku te nena, “Nombong ku ti,” me thak hevong. Be ditu hova dêim be honang yom vo yînîng anô ku nimbutak mavî, êng me tem mavî.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yisu helaŋô ôpêng ya ambô be hesong kambom be hik i lîlîng hîvô hê me henang ethak avîlanô nômbêng atu be eveng yêni yam nena, “Ya hanang avanông bing ethak môlô nena bôk mî ya hayê anô Islael te ya hêv iving hîtôm ôpiti amî!” ");
INSERT INTO ymp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Me ŋa takatu be enang ambô hiving Yisu îvôê melak me êyê nena anô ku atu lêk hivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Vauyaŋna me Yisu hê melak lông te be ya athêng nena Nain. Me ya ŋa hîndông lêk avîlanô bêng anông ê hiving yêni. ");
INSERT INTO ymp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Loho ê bidong melak êng ya bandêng ambôlêk me avîlanô melak lông êng iwa anô hema te be ele yêing. Ôpêng me avî tôp te nakandung tomêng yom. Me avîlanô melak lông êng bêng anông ê hiving avî tôp êng. ");
INSERT INTO ymp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Anômbêng hêyê yêni me lahiki be henang ethak inda nena, “Dô nondeng andô.” ");
INSERT INTO ymp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Me Yisu hê me hetak bang hêyô hêk balê me ŋa takatu be evak ôpêng eva tiŋeng. Me henang nena, “Anô muk, ya hanang ethak ong nena numbiyô!” ");
INSERT INTO ymp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Me anô hema êng hiviyô hîmô me henang ambô me Yisu hêv ôpêng hêndêng talêmbô. ");
INSERT INTO ymp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Me avîlanô sapêng êyê be êkô me êv Wapômbêng ya athêng ling be enang nena, “Plopet bêng te lêk hivutak aô lîvông” me “Wapômbêng lêk hêlêm vo nêŋgêv ya avîlanô livung.” ");
INSERT INTO ymp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Êng me kôkôthing ethak Yisu ya ku hê be heveng avîlanô Judia ning long sapêng lêk long bôyang takatu be hîmô bidong hiving. ");
INSERT INTO ymp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon ya ŋa hîndông enang nôm takatu be Yisu hevong hethak inda. Êng me helam lokwaŋyi hêlêm ");
INSERT INTO ymp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","me hêv thêi be ê vo enang iŋgik Yisu ling nena, “Ong Mesaya atu be Wapômbêng bôk hevak ambô vo nêŋgêv ong êlêm mesa yoô yambing anô yaŋda?” ");
INSERT INTO ymp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Anô yi êng êyô vo Yisu me enang nena, “Jon Anô Hithik Avîlanô hêv yêi be alêm vo anang iŋgik ong ling nena, ‘Ong Mesaya atu be Wapômbêng bôk hevak ambô vo nêŋgêv êlêm mesa yoô yambing anô yaŋda?’ ” ");
INSERT INTO ymp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wakma thêi yô me êyê Yisu hevong avîlanô lêk kômbôk lomaloma mavî lêk hêv gôk kambom bêng anông vê hêk avîlanô. Me hevong ŋa maleŋing pusip bêng anông êyê tak. ");
INSERT INTO ymp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yôvêm me henang ethak thêi nena, “Mamumbunnu me onang ethak Jon ethak nôm takatu be lêk mamu yê lo olaŋô. Ŋa maleŋing pusip êyê tak, me ŋa veŋing kambom eveng, me ŋa kômbôk lepla ivutak lithing, me ŋa liŋdong putup elaŋô ambô, me ŋa ema iviyô hethak loŋbô me ŋa siv elaŋô Wapômbêng ya Ambô Mavî. ");
INSERT INTO ymp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Be ditu mavî vo ŋa takatu be êv iving ya me mî kapôlôŋing yi amî.” ");
INSERT INTO ymp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Me Jon ya anô yi atu be iwa ambô be ê vo Yisu îvôê yôv me Yisu henang ik avîlanô ling ethak Jon nena, “Bôk môlô ô long thiliv vo ôyê ômbête? Môlô ô vo ôyê lovak hiyuv beselak mesa? ");
INSERT INTO ymp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mî. Betha ô vo ôyê anô te hik kwêv kêkêlô lomaloma e? Mî. Ŋa takatu be ik kwêv kêkêlô lêk iwa nômkama mavî mavî me thak îmô ŋa bêŋbêng lêk king ining melak yom. ");
INSERT INTO ymp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Môlô ô long thiliv vo ôyê ômbête? Plopet te mesa? Avanông! Metom ya hanang ethak môlô nena Jon me bêng vo plopet sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bôk ekavu hethak ôpêng hêk Wapômbêng ya kapua nena, “ ‘Nondaŋô. Tem yaŋgêv yînîng anô te vo nenang yînîng ambô bêng imung vo ong, me tem nepesang loŋdaŋlê vo ong.’ ");
INSERT INTO ymp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Ya hanang ethak môlô nena Jon me bêng vo avîlanô pîk sapêng. Metom ôpatu be yaônalêk hêk Wapômbêng ya lêkliŋyak bêng, ôpêng me bêng vo Jon.” ");
INSERT INTO ymp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Sêmbôk me Jon ithik avîlanô lêk ŋa iwa takis hiving, be ditu elaŋô ambô atu be Yisu henang ethak Jon me enang nena, “Wapômbêng ya kombom me thêthôp anông.” ");
INSERT INTO ymp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Metom Palisi lêk kîdôŋga ambô balambung êndô Jon ithik loho, be ditu êv dômîng hêndêng loŋdaŋlê atu be Wapômbêng hik thô hêndêng loho.) ");
INSERT INTO ymp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Me Yisu henang nena, “Tem ya nang bisête ethak avîlanô bôlô tiêng? Me loho hîtôm ômbête? ");
INSERT INTO ymp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Loho me hîtôm sêiknena takatu be îmô long ethak tom hîlôk me elam hê vo sêiknena vi nena, “ ‘Yoômbî yeng beleng vo môlôndô yeng, metom mî olo yeng amî. Me yoô leng athêng malêng vo môlôndeng, metom mî môlô leng amî.’ ");
INSERT INTO ymp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Bêng yom me Jon Anô Hithik Avîlanô hêlêm me thak hitip ethak nôm lêk waing. Me môlô pôlîk ethak yêni be onang nena gôk kambom hîmô hiving yêni. ");
INSERT INTO ymp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Metom Anô Ya Nakandung hêlêm me heyang nôm lêk hinum waing. Me môlô nang nena, ‘Ôŋgô! Ôpiti êng me thak heyang nôm lêk hinum waing bêng anông. Yêni me ŋa iwa takis lêk ŋa evong kombom kambom ining anô môlôô.’ ");
INSERT INTO ymp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Metom Wapômbêng nali takatu be iwa yêni ya auk thêthôp me loho ning ku tem niŋgik thô nena auk êng me thêthôp anông.” ");
INSERT INTO ymp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Palisi te helam Yisu be hê vo ninjang nôm imbing yêni. Êng me yêni hê hêyô vo ôpêng ya melak me hîlôk îmô vo ninjang nôm. ");
INSERT INTO ymp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Me avî hevong kombom kambom te nang long êng helaŋô nena Yisu lêk heyang nôm hîmô Palisi atu ya melak. Êng me hiwa wel uv mavî hîlôk kolopak kêkêlô te be hê hêyô melak êng. ");
INSERT INTO ymp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Me hêlêm eva Yisu dôm bidong va me heleng be mathôk hêv yak hêyô hîmô Yisu vakapô. Me heyav mathôk vê hethak yêni da kwandôk ŋaung. Me hiŋgu Yisu vakapô lômbôlông me hiwa wel uv mavî atu be hithik Yisu vakapô hethak. ");
INSERT INTO ymp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Palisi atu be helam Yisu hêlêm heyang nôm hiving inda hêyê nôm êng be la hêv nena, “Betha anô ti me plopet te ma, êng me tem neyala nena avî atu be hêthôm yêni me avî hevong kombom kambom te.” ");
INSERT INTO ymp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yisu heyala ôpêng ya auk be henang nena, “Saimon, yînîng ambô te hêk vo ya nang ethak ong.” Me Saimon henang nena, “Kîdôŋga, nonang.” ");
INSERT INTO ymp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Me Yisu henang nena, “Anô yi bôk iwa valuseleng hêk anômbêng te. Anô yang hiwa hîtôm 500 me yang hiwa hîtôm 50 be thêi ning tôp hêk denang. ");
INSERT INTO ymp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Me thêi mî hîtôm êŋgêv valuseleng êng viyang amî. Be ditu anômbêng êng henang ethak thêi luvi nena, ‘Tôp viyang dô lêk.’” Yôv me Yisu henang ik Saimon ling nena, “Lem hêv nena anô yi êng yang sê ditu la hiving ôpêng bêng anông?” ");
INSERT INTO ymp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Me Saimon enang viyang nena, “Betha yang atu be hiwa valuseleng bêng ma.” Me Yisu henang nena, “Honang ambô thêthôp.” ");
INSERT INTO ymp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Me Yisu hik i lîlîng me hêyê avî êng be henang ethak Saimon nena, “Nôŋgô avî ti. Ya havutak ayô yong melak kapô me mî hôêv ŋanam be ya hathik yaveng amî. Metom avî ti hithik yaveng hethak yêni da mathôk be heyav vê hethak kwandôk ŋaung. ");
INSERT INTO ymp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Me ya hayô athak yong melak kapô me mî huŋgu ya amî, metom wakma êng ele be diti me mîng avî ti hiŋgu yaveŋkapô lômbôlông me mî hetak amî. ");
INSERT INTO ymp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Me mî huwa wel be hoŋgathô hêyô hîmô ya kwandôk amî, metom avî ti hiwa wel uv mavî be heŋgathô hêyô hîmô yaveŋkapô. ");
INSERT INTO ymp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Be ya hanang ethak ong nena avî ti la hiving ya bêng anông, be ditu aô yala nena ya kambom bêng anông lêk hêv yak yôv. Metom avîlanô takatu leŋing êv nena ining kambom takatu be Wapômbêng hêv vê me doke yom, êng me tem leŋing imbing yêni doke bêng yom.” ");
INSERT INTO ymp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Me Yisu henang ethak avî êng nena, “Yong kambom sapêng lêk hêv yak yôv.” ");
INSERT INTO ymp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Me avîlanô takatu be îmô Saimon ya melak elaŋô ambô êng me enang ethak i nena, “Ôpiti me opalê be ditu hêv kambom vê?” ");
INSERT INTO ymp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Me Yisu henang ethak avî êng nena, “Ong da yong hôêv iving hevong be lêk ong mavî. Nu lêk lembali.” ");
INSERT INTO ymp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yôv me Yisu hê heveng melak lông lômbôlômbô be henang Ambô Mavî hethak Wapômbêng ya lêkliŋyak bêng. Me Yisu ya ŋa hîndông lauming be lahavôyi ");
INSERT INTO ymp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","lêk avî takatu be bôk hêv gôk kambom lêk kômbôk vê hêk loho eveng hiving yêni. Avî takatu te me Malia nang Makdala sêmbôk be gôk kambom bahevi be lahavôyi etak yêni. ");
INSERT INTO ymp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Me avî yang me Joana Kusa yanavî. Kusa me ôpatu be heyaŋging Helot ya melak. Me te me Susana lêk avî bêng anông iving. Avî takêng thak êv Yisu loho livung hethak ining nômkama. ");
INSERT INTO ymp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Avîlanô bêng anông êlêm nang lomelak lomelak be ethak tom vo injê Yisu. Me Yisu henang ambô dôhô te nena, ");
INSERT INTO ymp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Anô te hê me hekaliv yaŋvêk hîlôk ya kukapô. Yêni hekaliv yaŋvêk takêng me vi hîlôk loŋdaŋlê be avîlanô evak pesa lêk menak êpôm be eyang. ");
INSERT INTO ymp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Me doho hîlôk pîk lêk valu be hivutak. Metom pîk êng moma be yaŋvêk êng heyeng be hema. ");
INSERT INTO ymp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Me vi hîlôk long yak lêklilu kapô be yak êng hilumbak hiving hêyô yaŋvêk takêng vôv. ");
INSERT INTO ymp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Metom vi hîlôk pîk mavî be hipup me hivutak bêng be hik anông hîtôm 100.” Yisu henang ambô takêng yôv me helam kaêk be henang nena, “Môlô ŋa lêk liŋdong me ondaŋô ambô ti katôyang!” ");
INSERT INTO ymp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Me Yisu ya ŋa hîndông enang ik yêni ling ethak ambô dôhô êng ya ondong. ");
INSERT INTO ymp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Me henang nena, “Wapômbêng lêk hik ya auk long kapô thô hethak ya lêkliŋyak bêng hêndêng môlô yôv. Metom avîlanô vi me thak ya hanang ethak ambô dôhô yom. Be ditu “ ‘Loho yê, metom mî êyê katô amî. Me loholaŋô, metom mî eyala ya ondong katô amî.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Me Yisu henang nena, “Ambô dôhô êng ya ondong me bêŋiti. Yaŋvêk me hîtôm Wapômbêng ya ambô. ");
INSERT INTO ymp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yaŋvêk takatu be hîlôk loŋdaŋlê me hîtôm avîlanô takatu be elaŋô Wapômbêng ya ambô, me heveng yam me Sakdang hêyô be hêv Wapômbêng ya ambô vê hêk loho kapôlôŋing vo dô êŋgêv imbing be Wapômbêng imbua loho vê injêk kambom ya vuli andô. ");
INSERT INTO ymp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Me yaŋvêk takatu be hîlôk pîk lêk valu me hîtôm avîlanô takatu be elaŋô Wapômbêng ya ambô be evalong lêk leŋing mavî. Metom loho me hîtôm alokwang galôk atu be mî hîlôk pîk kapô be hê amî. Be ditu êv iving bidong oyang yom me wakma malêing êyô me etak ining êv iving. ");
INSERT INTO ymp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Me yaŋvêk takatu be hîlôk yak lêklilu kapô me hîtôm avîlanô takatu be elaŋô Wapômbêng ya ambô, metom loho ê me pîk iti ya malêing hêpôm loho be leŋing ik i hethak ining lêkmala be leŋing iving valuseleng lêk leŋing mavî pîk iti. Nôm takêng ithivung Wapômbêng ya ambô thing be loho mî ik anông mavî amî. ");
INSERT INTO ymp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Metom yaŋvêk takatu be hîlôk pîk mavî me hîtôm avîlanô takatu be kapôlôŋing mavî be maleŋing lêlê. Loholaŋô Wapômbêng ya ambô be evalong long manjeng me eva lêklokwang be ik anông mavî. ");
INSERT INTO ymp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Anô mî thak êtôm lam be îsîk thing ethak wîng mena ivung hîmô long kapô te amî. Loho thak êthôkêng eva vo avîlanô takatu be êyô melak kapô me injê danda. ");
INSERT INTO ymp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nômkama takatu be hekopak hêk long kapô me tem nimbutak long yêing. Me nômkama takatu be hivung i hêk auk kapô me tem nimbutak yêing be sapêng eyala. ");
INSERT INTO ymp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Bêng be môlôndaŋô yînîng ambô ti katô. Ôpatu be heyala yînîng ambô katô me tem Wapômbêng embong be ôpêng eyala nômkama doho imbing. Metom ôpatu be mî heyala yînîng ambô amî me Wapômbêng tem nimbua auk takatu be ôpêng hesong nena bôk hiwa yôv vê injêk yêni.” ");
INSERT INTO ymp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Me Yisu talêmbô lêk viyaŋi êlêm vo injê yêni, metom avîlanô bêng anông be long putup be mî hîtôm êlêm bidong vo yêni amî. ");
INSERT INTO ymp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Êng me anô te henang ethak Yisu nena, “Lemtambô lêk aviyami eva yêing be leŋing iving injê ong.” ");
INSERT INTO ymp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Êng me Yisu henang viyang nena, “Yînîng wakatik lêk aiyang loho me ŋa takatu be elaŋô Wapômbêng ya ambô be esopa.” ");
INSERT INTO ymp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wak te me Yisu henang ethak ya ŋa hîndông nena, “Aô na kasîk bomang viyang vulu.” Êng me ethak yeng te be ê. ");
INSERT INTO ymp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wakma loho ê me Yisu hêkthôm. Me lovak bêng te hêyô be hiyuv kasîk be hik ivutak hîlôk yeng kapô be hevong vo nîmô loho thethong îndôk kasîk kapô bini. ");
INSERT INTO ymp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Êng me loho ê ik Yisu ling be enang nena, “Anômbêng, Anômbêng! Tem aô sapêng ama be mî!” Me Yisu hiviyô be hethang lovak lêk kasîk budum bêng atu me hema be hêk tiŋeng. ");
INSERT INTO ymp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yôv me Yisu henang ethak loho nena, “Aŋga môlô ning ôêv iving hîmô sê?” Me loho song kambom be êkô me enang hê be hêlêm nena, “Ôpiti me opalê be ditu henang ambô hêndêng ŋanam lêk lovak be elaŋô ya ambô be esopa?” ");
INSERT INTO ymp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Me loho iwa yeng êng be ivup êyô kasîk be ê avîlanô Gelasa ining pîk. Long êng hêk Galili viyang vulu. ");
INSERT INTO ymp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Me loho ethak liŋdang me Yisu hetak yeng be hê me anô te be thak gôk kambom bêng anông îmô hiving yêni nang melak lông êng hêlêm hêpôm Yisu. Ôpêng bôk hetak ya melak me hê hîmô kalang be heveng kôlômbêng. ");
INSERT INTO ymp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ŋa long êng thak ekak ôpêng bang lo va lêku hethak yakseng me êv anô te vo heyaŋging. Metom gôk lêlêik êng thak hêyô be hîlônîng ôpêng be hêsô yakseng êng kisi me hiwa ôpêng be hê hêndô hîmô long thiliv. Me anô êng hêyê Yisu be heleng be hesaŋiyak be hekaliv inda hê hêk bidong Yisu va. Êng me Yisu henang ethak gôk atu nena, “Notak ôpiti be nu.” Êng me ôpêng helam lêklala bomang nena, “Yisu, ong Wapômbêng Leng Anông Bing Nakandung, lem hiving nombong ômbête êndêng ya? Dô nôŋgêv vovang êndêng ya andô!” ");
INSERT INTO ymp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Êng me Yisu henang ik ôpêng ling nena, “Yong athêng bisê?” Me ôpêng henang nena, “Yînîng athêng nena Ŋa Vovak Yalimamôk,” vômbê nena gôk kambom bêng anông îmô yêni kapô. ");
INSERT INTO ymp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Me gôk kambom takêng epetenak Yisu lômbôlông nena, “Dô nômbî yoôndôk lovang atu be ya ondong mî andô.” ");
INSERT INTO ymp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Me bok bêng anông eyang tak îmô dum te ya lîkînîng. Be ditu gôk kambom takêng epetenak Yisu nena, “Nôŋgêv yoô andôk bok takdaku kapô.” Êng me Yisu hetak loho be ê. ");
INSERT INTO ymp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Me gôk kambom takêng etak ôpêng me ê îlôk bok takêng kapô. Me bok takêng evothong be ethak i mayaliv hîlôk wanda êng be ê êv yak hîlôk kasîk bomang be ŋanam helok sapêng vônô. ");
INSERT INTO ymp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Me ŋa takatu be eyaŋging bok êyê nôm êng me îsôv be ê enang mayaliv heveng lomelak. ");
INSERT INTO ymp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Me avîlanô elaŋô be êlêm êyê nena ômbête hivutak long êng. Loho yô vo Yisu me êyê ôpatu be gôk kambom bêng anông bôk îmô hiving yêni, ôpêng ya auk lêk mavî be hipuk kwak be hîmô bidong Yisu va. Me loho yê be êkô kambom. ");
INSERT INTO ymp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Me ŋa takatu be êyê nôm êng enang hêndêng avîlanô takatu hethak nôm takatu be Yisu hevong hethak ôpêng be hivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Me avîlanô Gelasa sapêng êkô be elowaling kambom be enang vo Yisu tak loho bini bôyang. Êng me Yisu lêk ya ŋa hîndông ethak yeng be îvôê Galili hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Me anô lêk gôk kambom atu be lêk mavî hepetenak Yisu lêklokwang be henang nena, “Hîtôm ya thôk imbing ong?” Metom Yisu hêv ôpêng be hê me henang nena, ");
INSERT INTO ymp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Numbunnu yong long me nonang êndêng avîlanô ethak nômbêng atu be Wapômbêng hevong êndêng ong.” Êng me hîvô hê ya long me henang ethak avîlanô sapêng hethak nômbêng atu be Yisu hevong ethak inda. ");
INSERT INTO ymp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yisu hele hê kasîk bomang viyang vulu hethak loŋbô me avîlanô bêng anông lêk eyaŋging yêni hîmô liŋdang be iwa yêni thô. ");
INSERT INTO ymp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Me anômbêng heyaŋging melak yeng te hêlêm be ya athêng nena Jailus. Ôpêng eya vabudum thîvô hîmô Yisu va me henang ik yêni ling lêk kapô malêing vo Yisu imbing inda bini ya melak ");
INSERT INTO ymp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","vômbê nena nalavî tom yom be hêpôm kômbôk be hevong ema. Nalavî êng ya sondakbêng me hîtôm lauming be lahavôyi. Be ditu Yisu hiving inda be hê me avîlanô bêng anông ê iving be ekalambu yêni thing. ");
INSERT INTO ymp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Me avî te heva avîlanô takêng lîvông be hiwa kômbôk lêkma helom hêk wak nômbêng iti hîtôm sondakbêng lauming be lahavôyi. Be thak hêv ya nômkama sapêng hêndêng dokta, metom loho te mî hîtôm nembong be yêni mavî amî. ");
INSERT INTO ymp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Avî êng hêlêm bidong vo Yisu dômlokwang me hêthôm Yisu ya kwêv dêim ya dang yom me ketheng oyang me lêkma êng hekapôk. ");
INSERT INTO ymp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Êng me Yisu henang ik ling nena, “Opalête hêthôm ya?” Me avîlanô takêng enang nena, “Yoô mî.” Me Pita henang nena, “Anômbêng, avîlanô bêng anông ekalambu ong thing be ditu êthôm ong.” ");
INSERT INTO ymp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Metom Yisu henang nena, “Anô te hêthôm ya be ya hasae nena yînîng lêklokwang doho hêv yak.” ");
INSERT INTO ymp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Me avî êng hêyê nena mî hîtôm nimbung i amî. Be ditu hêkô be helowaling be hê me heya vabudum thîvô hîmô bidong Yisu va. Me hîmô avîlanô maleŋing me henang ondong alê atu be yêni hêthôm Yisu bêng lêk yêni hivutak mavî ketheng oyang bisê. ");
INSERT INTO ymp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Me Yisu henang ethak avî êng nena, “Yînîng avena, yong hôêv iving hevong be lêk huvutak mavî. Nu lêk lembali.” ");
INSERT INTO ymp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yisu henang ambô heva denang me anô te hêlêm nang Jailus ya melak be henang nena, “Nalum avî lêk hema yôv, be ditu notak kîdôŋga me dô nôŋgêv ku bêng êndêng yêni andô.” ");
INSERT INTO ymp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yisu helaŋô ambô êng me henang ethak Jailus nena, “Dô nôkô andô. Nôŋgêv imbing yom me nalum avî tem nimbutak mavî.” ");
INSERT INTO ymp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Yisu hêyô melak êng me avîlanô eleng athêng malêng lêk leŋing malêing bêng hethak avena êng îmô. Me Yisu henang ethak loho nena, “Athêng dô. Yêni hêkthôm yom me mî hema amî.” Metom loho yala nena lêk hema yôv be ditu emalîk ethak yêni. Me Yisu hêndô avîlanô ni imbing yêni, be ditu hiwa Pita lo Jon me Jems lêk avena êng talêmbô lo lambô yom be ê melak kapô hiving yêni. ");
INSERT INTO ymp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Me hevalong avena êng hîmô bang me henang nena, “Yînîng avena, numbiyô!” ");
INSERT INTO ymp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Me avena êng ya dôhô hêyô hîlôk kôpik hethak loŋbô me bôlôtom oyang me hiviyô. Me Yisu henang vo êŋgêv nôm êndêng avena êng vo ninjang. ");
INSERT INTO ymp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Me talêmbô lo lambô esong kambom. Metom Yisu henang lêklokwang nena dô enang nôm êng bêng ethak anô te andô. ");
INSERT INTO ymp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yisu helam aposol lauming be lahavôyi hethak tom me hêv lêklokwang lêk athêng bêng hêndêng loho vo êŋgêv gôk kambom sapêng vê lêk embong avîlanô kômbôk mavî. ");
INSERT INTO ymp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yôv me yêni hêv loho be ê vo enang ambô ethak Wapômbêng ya lêkliŋyak bêng lêk embong avîlanô lêk kômbôk mavî. ");
INSERT INTO ymp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Me Yisu henang ethak loho nena, “Môlô nu lomelak lomelak. Me dô umbua nômate imbing môlô andô. Dô umbua kwanding lêk vak me nôm lêk valuseleng andô. Me môlôŋgik kwêv tom me dô umbua kwêv yang imbing andô. ");
INSERT INTO ymp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Melak alêla takatu be môlô yô me ômô melak êng yom endebe otak long êng be unu bôyang. ");
INSERT INTO ymp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Metom long takatu be mî iwa môlô thô amî, be wakma môlô tak long êng be ô, me uŋgik limbalôm takatu be hîmô vemimkapô vê îndôk loho maleŋing vo niŋgik ining kambom thô.” ");
INSERT INTO ymp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yôv me loho ê eveng lomelak lomelak be enang Wapômbêng ya Ambô Mavî lêk evong avîlanô lêk kômbôk mavî. ");
INSERT INTO ymp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galili ning anômbêng Helot elaŋô nôm takatu be Yisu hevong be la hêv bêng anông hethak vômbê nena anô doho enang bêŋiti, “Jon hiviyô hêk ŋama hethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Me anô doho enang nena, “Elaija hêlêm,” me doho enang nena, “Plopet taksêmbôk te hiviyô hethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Êng me Helot henang nena, “Bôk ya handambêng Jon lôkbudum kisi yôv, metom Yisu me opalête be ya halaŋô avîlanô enang ambô takiti hethak yêni?” Êng me yêni hevong vo ninjê Yisu. ");
INSERT INTO ymp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Me aposol îvôlêm êyô me enang kôkôthing ethak nôm takatu be loho vong êndêng Yisu. Yôv me Yisu helom loho da yom be hê melak lông te be ya athêng nena Betsaida. ");
INSERT INTO ymp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Metom avîlanô bêng anông eyala long atu be Yisu hê. Êng me loho sopa yêni be ê. Loho ê êyô vo Yisu me yêni hiwa loho thô. Yôv me yêni henang ambô hethak Wapômbêng ya lêkliŋyak bêng be hevong avîlanô lêk kômbôk ivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Me hêndêng yathiŋdang hêmbôk me aposol lauming be lahavôyi takatu êlêm me enang ethak yêni nena, “Aômô long thiliv, be ditu notak avîlanô takiti vo ini melak lêk long takatu be hîmô bidong vo ethalo ning nôm lêk long injêk.” ");
INSERT INTO ymp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Metom Yisu henang nena, “Mî, môlô da tem ombakông loho.” Me loho nang nena, “Yoô ning polom bahevi me alim ŋanam yi yom hîmô be mî hîtôm amî. Bêng be tem yoôna vo aŋgêv nôm vuli vo avîlanô nômbêng itiêng mesa?” ");
INSERT INTO ymp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Loho nang ambô êng vômbê nena anô bêng anông îtôm 5,000 ma ditu îmô. Me Yisu henang ethak ya aposol nena, “Onang ethak avîlanô nena ithining i îtôm 50 50 be îndôk îmô lundum lundum.” ");
INSERT INTO ymp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aposol evong bêng hêndêng avîlanô be sapêng îlôk îmô bing. ");
INSERT INTO ymp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Me Yisu hiwa polom bahevi lêk alim yi atu be hêyê leng me hêv la mavî. Yôv me hekavli me hêv hêndêng aposol be îmbî tham hêndêng avîlanô nômbêng atu. ");
INSERT INTO ymp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Be avîlanô sapêng eyang be leŋiŋviŋyak. Me nôm wata vi atu be hîmô me aposol ithup îlôk vak tham lauming be lahavôyi. ");
INSERT INTO ymp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wak te me Yisu heteng mek me ya ŋa hîndông yom îmô hiving yêni. Me Yisu henang ik loho ling nena, “Avîlanô thak leŋing êv nena ya opalête?” ");
INSERT INTO ymp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Me loho nang viyang nena, “Doho nang nena ong me Jon Anô Hithik Avîlanô. Me doho nang nena ong me Elaija. Me doho nang nena ong me plopet bôô te hiviyô hethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Me Yisu henang ik loho ling nena, “Me môlô da lemim nena ya me opalête?” Me Pita henang viyang nena, “Ong me Mesaya atu be Wapômbêng hêv hêlêm.” ");
INSERT INTO ymp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Êng me Yisu henang lêklokwang hêndêng loho vo dô enang ambô êng bêng êndêng anô te andô. ");
INSERT INTO ymp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Me henang nena, “Wapômbêng bôk îtôk yôv nena Anô Ya Nakandung atu tem nimbua malêing lêk vovang bêng anông. Me avaka lêk ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung tem ende dômîng lîlîng êndêng yêni. Me tem iŋgik yêni vônô. Me hîtôm wak lô me tem nimbiyô ethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Me yêni henang ethak avîlanô sapêng nena, “Anô te hevong vo nesopa ya, êng me nende dôm lîlîng êndêng yêni da me nimbua ya alovalasing be nesopa ya wak nômbêng iti sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Vômbê nena ôpatu be la hiving ya lêkmala pîk bêng anông be hevalong long, ôpêng tem mî nimbua lêkmala anông amî. Metom ôpatu be hetak ya lêkmala be hesopa ya, ôpêng tem nimbua lêkmala anông. ");
INSERT INTO ymp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Anô te hiwa nômkama pîk sapêng metom hêndêng wakma ya lêkmala hêv yak, me ya nômkama takêng tem nêŋgêv yêni livung bisê vo nimbua lêkmala anông? ");
INSERT INTO ymp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Me anô te moma vo ya lêk yînîng ambô be wakma Anô Ya Nakandung hele hêlêm hiving ya danda lêkmaŋging lêk Lambô ya me aŋêla matheng ining, me tem yêni moma vo ôpêng bêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ya hanang avanông êndêng môlô nena Wapômbêng ya lêkliŋyak bêng tem nêlêm. Me môlô vi atu be ova long iti tem ômô lêkmala denang me ôŋgô nôm êng imbing.” ");
INSERT INTO ymp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yisu henang ambô êng yôv me wak bahevi be lahavôlô hele be hê. Me hiwa Pita lo Jon me Jems be loho ethak dum te be hê vo neteng mek. ");
INSERT INTO ymp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yisu heteng mek denang me thohav lo ma hivutak yaŋda be ya kwêv hivutak thapuk hîtôm damak êv. ");
INSERT INTO ymp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Me bôlôtom oyang me anô lokwaŋyi lêk danda lêkmaŋging êyôva be enang ambô hiving yêni. Yang me Moses me yang me Elaija. Thêi nang ambô hiving Yisu hethak nôm takatu be Yisu tem nembong be niŋgik anông îmô Jelusalem endebe netak pîk iti bini. ");
INSERT INTO ymp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Me Pita hiving Jon lo Jems maleŋing eyang be êkthôm. Metom iviyô me êyê Yisu ya danda lêkmaŋging lêk anô yi eva hiving yêni. ");
INSERT INTO ymp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Me thêi ê vini me Pita henang ethak Yisu nena, “Anômbêng, mavî anông vo lêk aômô long iti. Tem yoôndav melak lêkkôpik lokwaŋlô, te vo ong me te vo Moses me te vo Elaija.” Pita hîthông nena henang ambô alête bêng. ");
INSERT INTO ymp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita henang ambô denang me mavông te hêyô be heva loho thing be êkô kambom. ");
INSERT INTO ymp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Me ambô te hêlêm nang mavông êng kapô nena, “Diti me yînîng Wakna be bôk ya hatôk yêni yôv vo nembong yînîng ku, be ditu ondaŋô ya ambô.” ");
INSERT INTO ymp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ambô êng hivutak yôv me loho yê Yisu yom lêk heva. Pita lo Jon me Jems mî enang hêndêng anô te hethak nôm takatu be êyê lo elaŋô amî. ");
INSERT INTO ymp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hiviyô heyang me Yisu loho tak dum me loho lôk be ê me avîlanô bêng anông ê êpôm yêni. ");
INSERT INTO ymp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Me ŋa takêng te helam nena, “Kîdôŋga, ya hapetenak ong vo nôŋgêv yînîng wakna livung, vômbê nena yînîng wakna tom yom. ");
INSERT INTO ymp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Be gôk kambom te thak hekakô yêni me bôlôtom oyang me hesaŋiyak be helowaling be apôk thapuk hivutak ambôlêk. Gôk êng hivuling yêni liŋkôpik kambom anông me mî thak hetak yêni doke amî. ");
INSERT INTO ymp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bôk ya hapetenak yong ŋa hôndông lêklokwang vo êŋgêv gôk kambom êng vê, metom loho mî hîtôm amî.” ");
INSERT INTO ymp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Me Yisu henang viyang nena, “Môlô avîlanô bôlô tiêng mî ôêv iving be osopa loŋdaŋlê thêthôp amî! Wak vithê tem ya mô imbing môlô be yambua môlô ning malêing imbing môlô? Umbua wakna êng êlêm.” ");
INSERT INTO ymp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Me wakna êng heveng be hê hêndêng Yisu denang me gôk kambom êng hîmbî yêni vôkê hîlôk pîk me hevong be helowaling kambom. Metom Yisu hethang gôk lêlêik êng lêklokwang me hevong wakna êng be hivutak mavî me hêv êndêng lambô hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Me avîlanô sapêng îpîndîk kambom hethak Wapômbêng ya lêklokwang êng. Hêndêng wakma êng me avîlanô sapêng leŋing êv bêng anông hethak nôm takatu be Yisu hevong. Me Yisu henang ethak ya ŋa hîndông nena, ");
INSERT INTO ymp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Môlôndaŋô ambô ti be tem ya nang katôyang. Anô te tem netak Anô Ya Nakandung îndôk ya ŋakyo baheŋing.” ");
INSERT INTO ymp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Metom ya ŋa hîndông îthông ambô êng ya ondong paling, vômbê nena ambô êng ya ondong me hîmô kapô. Lêk êkô enang iŋgik yêni ling vo nenang ya ondong bêng êndêng loho. ");
INSERT INTO ymp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Me Yisu ya ŋa hîndông îkôki nena loho ali alête me nimbutak anô nimung vo loho. ");
INSERT INTO ymp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Metom Yisu heyala loho ning auk êng be hiwa sêik yaôna te be hîtîng eva bidong yêni da. ");
INSERT INTO ymp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Me henang ethak loho nena, “Ôpatu be hiwa sêik nate bêŋiti thô hethak yînîng athêng me hîtôm hiwa ya thô. Me ôpatu be hiwa ya thô me hîtôm hiwa ôpatu be hêv ya be ya halêm thô hiving. Me ôpatu be hetaving i hele be yaônalêk hîmô môlô lîvông ditu hivutak anô nimung vo môlô.” ");
INSERT INTO ymp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Me Jon enang nena, “Anômbêng, yoô yê anô te hêv gôk kambom vê hethak yong athêng. Metom yêni me mî aô te amî, be ditu yoô nang vo netak ku êng.” ");
INSERT INTO ymp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Metom Yisu henang nena, “Dô omba yêni thing andô. Ôpatu be mî hîpôlîk ethak môlô amî, ôpêng me heva hiving môlô.” ");
INSERT INTO ymp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wakma Wapômbêng tem nimbua Yisu bini leng me lêk bidong, êng me yêni latom vo ni Jelusalem. ");
INSERT INTO ymp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Me yêni hêv anô doho be ê melak te hêk Samalia vo epesang nômkama imung vo yêni. ");
INSERT INTO ymp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Metom avîlanô long êng êndô imbua yêni thô vômbê nena eyala nena yêni hê vini Jelusalem. ");
INSERT INTO ymp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ya ŋa hîndông yi Jems lo Jon êyê nôm êng be enang ik yêni ling nena, “Anômbêng, yêindam amela nang leng be nîndôk ethang loho mesa?” ");
INSERT INTO ymp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Metom Yisu hik i lîlîng me hethang thêi. ");
INSERT INTO ymp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Me loho ê melak yang. ");
INSERT INTO ymp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Loho veng loŋdaŋlê be ê me anô te henang ethak Yisu nena, “Long nômbêng atu be hô me tem ya sopa ong.” ");
INSERT INTO ymp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Me Yisu henang viyang nena, “Avung yatap ining pîk ambuang îmô me menak ining unak îmô, metom Anô Ya Nakandung atu me ya long ninjêk mî.” ");
INSERT INTO ymp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Me Yisu henang ethak anô yang nena, “Nosopa ya.” Metom ôpêng enang nena, “Anômbêng, notak ya vo ya nandav wakamik yôvêm.” ");
INSERT INTO ymp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Me Yisu henang ethak ôpêng nena, “Notak ŋa dôhôlôŋing bôk ema yôv vo loho da endav ining ŋama. Me yong ku me nu nang Ambô Mavî bêng ethak Wapômbêng ya lêkliŋyak bêng.” ");
INSERT INTO ymp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Me anô yang enang ethak Yisu nena, “Anômbêng, tem ya sopa ong, metom notak ya vo ya nang ya leng mavî êndêng yînîng avîlanô yôvêm.” ");
INSERT INTO ymp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Me Yisu henang viyang nena, “Ôpatu be heveng loŋdaŋlê be hik mandaluk lîlîng, ôpêng mî hîtôm nembong Wapômbêng ya lêkliŋyak bêng ya ku mavî yang amî.” ");
INSERT INTO ymp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yôv me Anômbêng hîtôk avîlanô vi hîtôm 72 be hêv loho yiyi imung be ê hêndêng melak lông takatu be tem yêni ni. ");
INSERT INTO ymp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Me yêni henang ethak loho nena, “Nôm bêng anông lêk hîyôk îmô kukapô, metom ŋa ku tomtom yom. Be ditu môlô teng mek êndêng ku ya alang vo nêŋgêv ŋa ku bini vo ithup nôm anông. ");
INSERT INTO ymp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Môlô nu. Ya hêv môlô be ô hîtôm boksipsip nali îmô avung yatap lîvông. ");
INSERT INTO ymp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Me dô môlômbua vak valuseleng lêk vak me veŋiŋkapô bokgôp imbing andô. Me dô onang waklîvông ethak anô te be okam îndôk loŋdaŋlê andô. ");
INSERT INTO ymp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Môlô yô melak te kapô me môlô nang ethak loho nena, ‘Wapômbêng ya lambali hîmô hiving môlô.’ ");
INSERT INTO ymp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Anô lambali te hîmô melak êng, êng me môlô ning ambô mavî êng tem nîmô imbing yêni. Me mî, êng me tem ambô êng nîmbôlêm vo môlô da ethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Me môlô mô melak êng yom. Me oŋgwang be unum nôm takatu be êv hêndêng môlô yom hîtôm môlô ning ku ya vuli. Me dô môlô nu thak melak viyang mayaliv andô. ");
INSERT INTO ymp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Môlô yô melak lông te be iwa môlô thô be êv nôm hêndêng môlô, êng me oŋgwang. ");
INSERT INTO ymp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Me môlômbong loho ning avîlanô lêk kômbôk imbutak mavî me môlô nang bêŋiti, ‘Wapômbêng ya lêkliŋyak bêng lêk hêlêm bidong vo môlô.’ ");
INSERT INTO ymp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Metom mî iwa môlô thô amî, êng me môlô nu me omba loŋdaŋlê be môlô nang nena, ");
INSERT INTO ymp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Môlô ning melak lông ya limbalôm atu be hîmô yoô veŋing kapô me yoô ik vê hîlôk môlô malemim vo niŋgik thô nena môlôvong kambom. Metom lemim êŋgêv katô vômbê nena Wapômbêng ya lêkliŋyak bêng lêk bidong.’ ");
INSERT INTO ymp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ya hanang ethak môlô nena waklavông atu be Wapômbêng tem nembong ambô ethak avîlanô me avîlanô long atu be mî iwa môlô thô amî, loho ning malêing me tem nîmbô thak vo avîlanô kambom nang Sodom. ");
INSERT INTO ymp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Alitaknena, môlô avîlanô Kolasin lo Betsaida! Bôk môlô yê nôm thamtham lomaloma. Metom bôk yambong nôm thamtham takêng îmô Taia lo Saidon lîvông, ketheng oyang me tem iŋgik kwêv kambom lêk ethav amela kambôk ethak luŋiŋkwandôk be ende kapôlôŋing lîlîng. ");
INSERT INTO ymp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Waklavông Wapômbêng îthô avîlanô pîk lelalîlîng, êng me môlô ning malêing tem nîmbô thak vo avîlanô Taia lo Saidon ining! ");
INSERT INTO ymp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Me môlô avîlanô Kapenaom, tem êŋgêv môlô ning athêng ling ethak leng mesa? Mî, tem môlôndôk bunu ŋa ema ning long!” ");
INSERT INTO ymp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yisu henang ethak ya ŋa hîndông nena, “Anô te helaŋô môlô ning ambô, êng me ôpêng helaŋô yînîng ambô hiving. Me anô te hele dôm lîlîng hêndêng môlô, êng me yêni hele dôm lîlîng hêndêng ya hiving. Me anô te hele dôm lîlîng hêndêng ya, êng me yêni hele dôm lîlîng hêndêng Ôpatu be hêv ya be ya halêm hiving.” ");
INSERT INTO ymp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Avîlanô 72 takatu îvôlêm ethak loŋbô me leŋing mavî bêng anông be enang nena, “Anômbêng, hethak yong athêng me gôk kambom elaŋô yoô ning ambô be esopa.” ");
INSERT INTO ymp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Me Yisu henang nena, “Ya hayê Sakdang hêv yak hîlôk leng hîtôm damak. ");
INSERT INTO ymp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ondaŋô. Bôk ya hêv lêklokwang hêndêng môlô yôv vo môlômbak bôyîv lêk ŋalivang pesa. Me môlô hîtôm okav Sakdang ôpatu be môlô ning ŋakyo ya lêklokwang sapêng li. Me nômate mî hîtôm nimbuling môlô amî. ");
INSERT INTO ymp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Me dô môlô lemim mavî bêng anông be onang nena gôk kambom elaŋô môlô ning ambô andô, metom môlô lemim mavî ethak Wapômbêng bôk hekavu môlô ning athêng yôv hêk melak leng.” ");
INSERT INTO ymp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yôv me Lovak Matheng hevong Yisu kapô mavî be henang nena, “Wakamik, ong me pîk lo leng ya alang! Lêk huvung yong auk vo ŋa auk bêng me huik thô hêndêng ŋa takatu be îtôm sêiknena. Be ditu ya hêv yong athêng ling! Wakamik, avanông ong da hosopa yong lem hiving be ditu hovong bêng. ");
INSERT INTO ymp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Wakamik bôk êv nômkama sapêng hêndêng ya yôv. Me anô te mî heyala Nakandung atu katô amî, me Wakamik yom. Me anô te mî heyala Wakamik katô amî. Me Nakandung lêk ŋa takatu be Nakandung la hiving niŋgik lambô thô êndêng loho yom.” ");
INSERT INTO ymp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Me Yisu hik i lîlîng be henang ethak ya ŋa hîndông yom nena, “Wapômbêng hevong mavî hêndêng môlô be môlô yê nôm takiti. ");
INSERT INTO ymp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ya hanang ethak môlô nena sêmbôk me plopet lêk king bêng anông leŋing iving injê nôm takiti be lêk môlô yê, metom mî êyê amî. Me leŋing iving endaŋô ambô takiti be lêk môlô laŋô, metom mî elaŋô amî.” ");
INSERT INTO ymp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wak te me anô lêk auk ethak ambô balambung te hiviyô heva vo neyek Yisu be henang nena, “Kîdôŋga, tem yambong ômbête vo yambua lêkmala îtôm wak nômbêng iti sapêng?” ");
INSERT INTO ymp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Me Yisu henang ik ôpêng ling nena, “Ambô balambung henang bisête? Me hosam ambô êng be hoyala bisête?” ");
INSERT INTO ymp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Me ôpêng enang viyang nena, “Lem imbing Anômbêng yong Wapômbêng injêk ong kapôlôm lêk dôhôlôm me lêklokwang lêk yong auk sapêng. Me lem imbing yong avîlanô môlôô hîtôm lem hiving ong da.” ");
INSERT INTO ymp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Me Yisu henang nena, “Avanông. Nombong bêng me tem numbua lêkmala.” ");
INSERT INTO ymp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Metom hevong vo avîlanô injê nena yêni me anô auk mavî be ditu henang nena, “Yînîng avîlanô môlôô me ŋa sêla?” ");
INSERT INTO ymp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Me Yisu henang viyang nena, “Anô te hetak Jelusalem me hivup hîlôk be hê Jeliko. Êng me ŋa vanî êyê yêni be ik inda kambom anông be hemayak hêk loŋdaŋlê me iwa ya nômkama vanî be ê. ");
INSERT INTO ymp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hêndêng waklavông êng yom me anô hîmbôk da te hesopa loŋdaŋlê êng ivup îlôk be hê. Me hêyê ôpêng, metom hivup îlôk loŋdaŋlê vi hele be hê. ");
INSERT INTO ymp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bêng yom me anô ondong Livai te hivup îlôk loŋdaŋlê tomêng yom hele me hêyê ôpêng, metom hivup îlôk loŋdaŋlê vi atu hele be hê. ");
INSERT INTO ymp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yôv me anô Samalia te hivup îlôk loŋdaŋlê êng hele me hêyê ôpêng be lahiki. ");
INSERT INTO ymp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Be ditu yêni hê hêndêng ôpêng me heŋgathô waing lêk wel hethak ya palê me hithum. Yôv me hiwa ôpêng be hetak hêyô hîmô ya bokdoŋki me helom be hê melak vathi te me yêni da heyaŋging. ");
INSERT INTO ymp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hiviyô heyang me hêv valuseleng silva yi hêndêng melak alang be henang nena, ‘Noyaŋging anô ti mavî. Me valuseleng iti mî hîtôm amî be wakma atu ya havôlêm be hotak doho êyômô long hiving, me tem ya wê yong valuseleng takêng viyang.’” ");
INSERT INTO ymp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yisu henang ambô dôhô êng yôv me henang ik anô lêkauk ethak balambung êng ling nena, “Lem hêv bisête? Ôpatu be ŋa kambom ik me loho alialê ditu hîtôm ya anô môlôô te?” ");
INSERT INTO ymp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Me anô lêkauk ethak balambung atu henang viyang nena, “Ôpatu be hêv kapô hêndêng yêni.” Me Yisu henang ethak ôpêng nena, “Nu me nombong bêng yom.” ");
INSERT INTO ymp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yisu lêk ya ŋa hîndông eveng be ê me Yisu hêyô melak lông te be hê. Me avî te be ya athêng nena Mata hiwa Yisu thô be hê hîmô ya melak. ");
INSERT INTO ymp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Me Mata yang molok Malia hîmô bidong vo Anômbêng va be helaŋô ya ambô. ");
INSERT INTO ymp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Metom Mata lahiki ethak yêni yom evong ku bêng anông vo hepesang nôm. Êng me yêni hê hêndêng Yisu me henang nena, “Anômbêng, lem hêv bisête? Ya havong ku bêng anông me yînîng aiyang molok mî hêv ya livung doke amî. Be ditu nonang ethak inda vo nêlêm êŋgêv ya livung.” ");
INSERT INTO ymp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Metom Anômbêng henang viyang hêndêng inda nena, “Mata, Mata, bisête be lem ik ong be kapôlôm malêing hethak nômkama lomaloma bêng anông? ");
INSERT INTO ymp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nômate yom ditu nômbêng be Malia lêk la hiving vo nimbua me lêk iwa nôm êng yôv, be anô te mî hîtôm nimbua nôm êng vê injêk yêni amî.” ");
INSERT INTO ymp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wak te me Yisu heteng mek îmô bôte. Heteng mek yôv me ya ŋa hîndông te henang ethak yêni nena, “Anômbêng, nôndông yoô vo yoô teng mek îtôm sêmbôk be Jon îndông ya ŋa hîndông.” ");
INSERT INTO ymp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Me Yisu henang nena, “Môlô teng mek bêŋiti, “ ‘Wakamik, nombong yong athêng injêk matheng. Me yong lêkliŋyak bêng êlêm. ");
INSERT INTO ymp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Me nôŋgêv nôm êndêng yoô îtôm wak nômbêng iti. ");
INSERT INTO ymp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Me notak yoô ning kambom vômbê nena thak yoôtak avîlanô vi ning kambom takatu be evong êndêng yoô. Me dô notak yoôndôk nôm takatu be tem neyek yoô andô.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Yôv me Yisu henang ambô dôhô te hêndêng loho nena, “Bîlîvông bing te me hô hêndêng yong anô môlôô te ya melak be honang nena, ‘Aiyang, yînîng anô môlôô te hêlêm nang long dêim be lêk hîmô yînîng melak be hema vo la be ya nôm mî. Be hîtôm nôŋgêv polom lokwaŋlô vo ya mesa?’ ");
INSERT INTO ymp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Me yong anô môlôô atu hîmô ya melak kapô tem nenang viyang nena, ‘Dô nuŋgik ya ling andô. Lêk yoô ik melak ambôlêk thing be aêkthôm yôv be tem mî yambiyô be yaŋgêv nômate êndêng ong amî.’ ");
INSERT INTO ymp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yêni hêndô nêŋgêv ya anô môlôô livung. Metom ya hanang ethak môlô nena ôpêng enang ik yang êng ling lômbôlông, êng me tem moma be nimbiyô me nêŋgêv nôm îtôm datu be henang ik yêni ling. ");
INSERT INTO ymp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Bêng yom me ya hanang ethak môlô nena, onang iŋgik Wapômbêng ling me tem nêŋgêv êndêng môlô. Me othalo nômate me tem ôpôm nôm êng. Me upindinding melak ambôlêk me tem niŋgik kê vo môlô. ");
INSERT INTO ymp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vômbê nena ŋa takatu be enang ik Wapômbêng ling me tem imbua. Me ethalo nômate me tem êpôm, me ipindinding melak ambôlêk, me tem niŋgik kê vo loho. ");
INSERT INTO ymp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Môlô sêiknena ning lami, nalum henang ik ong ling vo ninjang alim ŋanam me tem nôŋgêv bôyîv kambom te êndêng yêni mesa? Mî! ");
INSERT INTO ymp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mena henang ik ling vo ninjang menak daluk, êng me tem nôŋgêv ŋalivang te mesa? Mî! ");
INSERT INTO ymp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Môlô avîlanô kambom, metom thak môlôyala ôŋgêv nômkama mavî mavî hêndêng nalumi. Bêng be môlô ning Kamik atu be hîmô melak leng eyala katôyang îvô ethak vo môlô ning katik lo kamik, be ditu tem nêŋgêv Lovak Matheng êndêng ŋa takatu be enang ik yêni ling.” ");
INSERT INTO ymp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wak te me Yisu hêv gôk kambom vê hêk anô ambôlêk putup te. Me gôk kambom êng hetak anô êng be hê me anô ambôlêk putup êng enang ambô be avîlanô bêng anông êyê be esong kambom. ");
INSERT INTO ymp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Metom avîlanô doho enang nena, “Gôk kambom ining anômbêng Belsebul hêv lêklokwang êndêng Yisu, be ditu hêv gôk kambom vê hêk avîlanô.” ");
INSERT INTO ymp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Me loho vi evong vo eyek Yisu be enang ik yêni ling nena, “Nombong nôm thamtham te vo niŋgik thô ethak yoô nena Wapômbêng êv ong be hôlêm.” ");
INSERT INTO ymp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Metom Yisu heyala loho ning auk be henang ethak loho nena, “Avîlanô melak lông te evak i kê hê ondong yi be evong vovak, êng me melak lông êng tem nêŋgêv yak. Me avîlanô ondong te evak i kê hê ondong yi, êng me ondong êng tem nêŋgêv yak bêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Me Sakdang ya gôk kambom evak i kê hê ondong yi, êng me Sakdang ya lêklokwang thak heyaŋging nômkama tem nemba manjeng amî. Ya hanang ambô ti vômbê nena môlô nang nena ya hêv gôk kambom vê hethak Belsebul ya lêklokwang. ");
INSERT INTO ymp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Môlô nang nena ya hêv gôk kambom vê hethak Belsebul ya lêklokwang. Me opalête hêv lêklokwang êndêng môlô ning avîlanô be loho êv gôk kambom vê? Belsebul mesa opalê? Mî! Môlô da ning avîlanô ik thô nena môlô ning ambô me lêkwgak. ");
INSERT INTO ymp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wapômbêng da hêv lêklokwang hêndêng ya be ya hêv gôk kambom vê hêk avîlanô. Be ditu oyala nena Wapômbêng ya lêkliŋyak bêng lêk hêlêm îmô môlô lîvông yôv. ");
INSERT INTO ymp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Anô lêklokwang te hîtôm Sakdang hevalong nômkama vovak be heyaŋging ya melak, êng me ya nômkama tem nîmô mavî. ");
INSERT INTO ymp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Metom anô te ya lêklokwang bêng anông vo ôpyang êng hîtôm Wapômbêng hêyô be hevong vovak hiving ôpêng hele be hîmô yêni li, êng me tem nimbua ôpêng ya nômkama vovak takatu be hêv iving nena nôm takêng tem nembong be nimbutak lêklokwang. Be ditu ôpatu be lovak me tem nîmbî yang atu be hêv yak ya nômkama tham. ");
INSERT INTO ymp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Anô te mî hêv ya livung be yêiŋgik vovak imbing Sakdang amî, êng me ôpêng heva hiving Sakdang be thêi vong vovak hiving ya. Me anô mî hêv ya livung be hithup avîlanô hêlêm bidong vo Wapômbêng amî, êng me hîtôm hindining loho be îsôv mayaliv. ");
INSERT INTO ymp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Gôk lêlêik hetak anô te, êng me hê heveng long thiliv vo nethalo long mavî te vo nimbua lovak îmô. Be mî hêpôm long te amî, êng me tem nenang nena, ‘Dô me yandena melak sêmbôk atu be ya hamô ethak loŋbô.’ ");
INSERT INTO ymp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Me hêyô be hêyê nena melak êng lêk îthî be epesang be hivutak mambung anông. ");
INSERT INTO ymp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Êng me tem ni vo nethalo gôk bahevi be lahavôyi takatu be ining kambom hîvô hethak vo yêni ya be nimbua loho imbing vo imbutak êyô melak êng kapô ethak loŋbô be îmô. Êng me ôpêng tem nîmô kambom anông vo bôlôyang sêmbôk.” ");
INSERT INTO ymp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yisu henang ambô takêng îmô denang me avî te hîmô avîlanô nômbêng êng lîvông be helam nena, “Mavî vo avî atu be hevathu ong be hêv sum êndêng ong, nîmô lêk la mavî.” ");
INSERT INTO ymp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Metom Yisu henang nena, “Avanông, metom mavî bêng anông vo ôpatu be helaŋô Wapômbêng ya ambô be hesopa.” ");
INSERT INTO ymp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Avîlanô bêng anông êlêm be êlêm. Loho êyô vo Yisu me henang ethak loho nena, “Avîlanô bôlô tiêng me avîlanô kambom. Loho nang vo yambong nôm thamtham vo niŋgik thô nena Wapômbêng bôk hêv ya be ya halêm, metom tem mî. Loho tem injê Jona ya lavuning yom. ");
INSERT INTO ymp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sêmbôk atu me Jona hivutak îtôm lavuning te vo avîlanô Ninive êyê. Me lêk iti me Anô Ya Nakandung atu tem nimbutak bêng yom vo avîlanô bôlô tiêng injê. ");
INSERT INTO ymp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Sêmbôk me Siba ning avî king hetak ya long me hêlêm nang pîk ya dang vo nendaŋô Solomon ya auk mavî. Ondaŋô! Anô te hîmô long iti me bêng vo Solomon. Metom môlôndô ondaŋô ya ambô. Bêng be waklavông Wapômbêng îthô avîlanô pîk lelalîlîng me Siba ning avî king êng tem nenang môlô ning kambom thak môlô seng ambô bêng. ");
INSERT INTO ymp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Me sêmbôk be avîlanô Ninive elaŋô Jona ya ambô be ele kapôlôŋing lîlîng. Me anô te lêk hîmô long iti me bêng vo Jona. Metom môlôndô ondaŋô ya ambô. Bêng be waklavông Wapômbêng îthô avîlanô pîk lelalîlîng me tem avîlanô Ninive emba be enang môlô ning kambom takêng bêng. ");
INSERT INTO ymp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Anô mî thak êtôm lam be ivung hîmô long kapô mena îsîk thing ethak wîng amî, mî. Loho thak êthôkêng eva yêing vo avîlanô takatu be êyô melak kapô êng tem injê danda. ");
INSERT INTO ymp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Malemdaluk me hîtôm lam vo hêv danda hêndêng lemvim kôpik. Me malemdaluk mavî me tem danda injêk lemvim kôpik sapêng. Metom malemdaluk kambom me tem momaŋaning bêng injêk lemvim kôpik sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Be ditu noyaŋging ong katô. Endekeme nosong nena danda hîmô ong kapô, metom mî momaŋaning îmô kapô. ");
INSERT INTO ymp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Me danda hêk lemvim kôpik sapêng me momaŋaning mî hêk bôte amî, êng me lemvim kôpik sapêng tem nimbutak danda îtôm lam hêv danda hêndêng ong.” ");
INSERT INTO ymp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yisu henang ambô yôv me Palisi te henang ik yêni ling vo ninjang nôm imbing inda. Êng me Yisu hê hêyô vo ôpêng ya melak kapô be heyang nôm hîmô ya balê. ");
INSERT INTO ymp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Me Palisi êng êyê Yisu hîlôk îmô vo ninjang nôm me mî hithik bang hîtôm Palisi ning kombom amî. Êng me yêni hesong kambom. ");
INSERT INTO ymp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Me Anômbêng enang ethak yêni nena, “Môlô Palisi thak vôkîng keyek lêk belev vindôm yom, metom môlô kapôlômim hêyô thing ethak kombom kambom lêk maleŋing daŋtang. ");
INSERT INTO ymp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Môlô ŋa molo. Wapômbêng hepesang vi yêing lêk vi kapô hiving. Be ditu môlômbôkîng kapôlômim imbing me mî bahemim yom amî. ");
INSERT INTO ymp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Metom môlô ning nômkama takatu be hîmô belev kapô me môlôŋgêv êndêng ŋa nômkama mî vo nêŋgêv loho livung. Môlômbong bêng me tem môlô ning nômkama sapêng îmô mambung mavî injêk Wapômbêng mandaluk. ");
INSERT INTO ymp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Alitaknena vo môlô Palisi! Vovang bêng tem nêpôm môlô. Thak môlô thup nôm takatu be thak hevong nôm vathing be uik tham hê ondong lauming be ôêv ondong te hêndêng Wapômbêng hîtôm da. Môlôvong nôm yaôna êng me mavî, metom ôêv yak ethak ombong nôm bêng îtôm kombom thêthôp êndêng avîlanô lêk lemim imbing Wapômbêng anông. Be ditu dô ombong kombom mavî yang me otak yang andô. ");
INSERT INTO ymp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Alitaknena vo môlô Palisi! Vovang bêng tem nêpôm môlô. Môlô lemim iving ômô balê mung îmô melak yeng kapô lêk lemim iving avîlanô etaving i be enang nena, ‘Waklîvông mavî,’ êndêng môlô îndôk long ethak tom îlôk. ");
INSERT INTO ymp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Alitaknena vo môlô! Vovang bêng tem nêpôm môlô. Môlô lêlêik îtôm anô hema te atu be bôk elav bôô be avîlanô mî eyala kalang êng amî. Be ditu loho êyôva viling be ivutak lêlêik hêk Wapômbêng mandaluk. Bêng yom me avîlanô thak esopa môlô, metom mî eyala nena môlô da me kapôlômim lêlêik kambom amî.” ");
INSERT INTO ymp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kîdôŋga balambung te helaŋô ambô êng me henang ethak Yisu nena, “Kîdôŋga, honang ambô êng êndêng Palisi me huik yoô susu hiving.” ");
INSERT INTO ymp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Me Yisu henang nena, “Alitaknena vo môlô ŋa lêk auk ethak ambô balambung! Vovang bêng tem nêpôm môlô imbing. Môlô êv balambung lomaloma bêng anông êndêng avîlanô vo esopa. Balambung takêng me hîtôm vak malêing vo loho. Metom mî môlô da ôŋgêv loho livung doke amî. ");
INSERT INTO ymp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“Alitaknena vo môlô! Vovang bêng tem nêpôm môlô. Limbumi bôk ik plopet bêng anông vônô me môlô lav melak êyô ining kalang takêng vôv be oyaŋging dendaung. Môlôvong bêng be hik thô nena môlô lôk ethak limbumi ning bôk le long takatu be bôk evong. ");
INSERT INTO ymp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Be ditu Wapômbêng anô lêkauk bêng bôk henang bêŋiti, ‘Tem yaŋgêv plopet lêk aposol bêng anông êndêng loho, metom loho tem embong kambom êndêng doho me doho tem iŋgik vônô.’ ");
INSERT INTO ymp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bêng be avîlanô bôlôti tem imbua vovang bêng ethak plopet takatu be limi bôk ik vônô hêndêng waklavông Wapômbêng epesang pîk hele be hêyô lêk. ");
INSERT INTO ymp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Plopet mung atu be ik vônô me Abel me ik bêng ethak be hêlêm hele be hêyô Sekalaia me yandang. Ik yêni vônô hêk melak matheng lêk alakdala îmbôk da lîvông. Ya hanang avanông ethak môlô nena vuli kambom hethak bôk le long takêng tem nêpôm avîlanô bôlô tiêng. ");
INSERT INTO ymp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Alitaknena vo môlô ŋa lêk auk ethak ambô balambung! Vovang bêng tem nêpôm môlô. Môlô bôk okaliv iyam melak ambôlêk imbua auk mavî ethak Wapômbêng hê. Me môlô da thak ôndô ôyô long êng kapô bunu, metom wakma avîlanô vi evong vo êyô kapô bini me thak môlô va long thing vo loho.” ");
INSERT INTO ymp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yôv me Yisu hetak melak êng me kîdôŋga ambô balambung lêk Palisi leŋing ŋaŋa kambom be enang ik yêni ling hethak ambô lomaloma. ");
INSERT INTO ymp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Loho vong bêng vo embatek yêni be henang ambô te bidoho, êng me tem embalong inda jêk vo nembong ambô. ");
INSERT INTO ymp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hêndêng wakma êng me avîlanô bêng anông bomang ethak tom be êyô eva veŋing long. Me Yisu henang ethak ya ŋa hîndông nena, “Môlô yaŋging am ethak Palisi ning kombom kambom. Loho thak evong îtôm ŋa mavî hîmô avîlanô lîvông, metom auk lomaloma hîmô kapôlôŋing. Nôm êng me hîtôm yis be tem nêmbôv avîlanô bêng anông. ");
INSERT INTO ymp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nôm takatu be hivuŋi hêk long kapô me tem nimbutak yêing. Me ambô takatu be hivuŋi me tem avîlanô sapêng eyala. ");
INSERT INTO ymp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bêng be ambô takatu be môlô nang hêndêng bîlîvông me tem avîlanô endaŋô êndêng lêkwak. Me ambô takatu be môlô nang thîkôthîk hîlôk melak kapô, êng me tem emba melak vôv be endam bêng ini yêing. ");
INSERT INTO ymp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Yînîng avîlanô, ya hanang ethak môlô nena dô ôkô avîlanô andô. Loho hîtôm iŋgik lemvim kôpik yom vônô. Me heveng yam me tem mî hîtôm embong nômate amî. ");
INSERT INTO ymp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Metom tem yaŋgik ôpatu be tem môlô kô inda thô. Ôpêng me Wapômbêng yom. Yêni hîtôm niŋgik anô te vônô yôvêm me nîmbî ôpêng îndôk amela lêkmala. Be ditu ya hanang ethak môlô nena ôkô Wapômbêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Avîlanô thak êv vuli menak yaônena hethak valuseleng lêkma yi. Metom Wapômbêng mî hîtôm laŋgêv menak takêng te thing amî. ");
INSERT INTO ymp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Avanông bing, bôk yêni hiwa môlô sapêng kwandôk ŋaung thô yôv. Bêng be môlô me bêng vo menak be ditu dô môlô kô andô. ");
INSERT INTO ymp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ya hanang ethak môlô nena opalê atu be henang ethak avîlanô nena yêni me yînîng, me Anô Ya Nakandung atu tem nenang emba Wapômbêng mandaluk be aŋêla endaŋô nena, ‘Ôpêng me yînîng.’ ");
INSERT INTO ymp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Me ôpatu be henang ethak avîlanô nena hêndô ya, me tem ya nang emba Wapômbêng mandaluk be aŋêla endaŋô nena, ‘Ya hathông ôpêng paling.’ ");
INSERT INTO ymp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Me anô te henang ambô kambom hethak Anô Ya Nakandung atu, me tem Wapômbêng êŋgêv ôpêng ya kambom vê. Metom anô te hêyê Lovak Matheng ya ku be henang ambôma hethak nena, ‘Diti me Sakdang ya ku,’ êng me Wapômbêng tem mî nêŋgêv ôpêng ya kambom êng vê amî. ");
INSERT INTO ymp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Avîlanô evalong môlô hêk be iwa ê êyô melak yeng mena ethaŋang môlô heva ŋa bêŋbêng maleŋing mena ŋa lêk athêng bêng maleŋing, êng me dô môlô kô be lemim êŋgêv nena, ‘Tem yoô nang bisête?’ mena ‘anang viyang bisê?’ Mî. ");
INSERT INTO ymp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Hêndêng wakma êng yom me Lovak Matheng tem nêŋgêv auk êndêng môlô be onang.” ");
INSERT INTO ymp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Anô te heva avîlanô nômbêng atu lîvông me henang ethak Yisu nena, “Kîdôŋga, wakamik bôk ema yôv be ditu nonang ethak aiyang bêng vo nîmbî wakamik ya nômkama tham ni ondong yi be nêŋgêv yînîng êndêng ya.” ");
INSERT INTO ymp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Metom Yisu henang hethak ôpêng nena, “Aiyang, opalête hîtôk ya vo yambutak mamu ning jas?” ");
INSERT INTO ymp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Me Yisu henang ethak avîlanô nena, “Môlô yaŋging am katô vo dô malemim daŋtang ethak nômkama lomaloma andô. Anô te hiwa nômkama bêng anông metom yêni da mî hîtôm nimbua lêkmala ethak ya nômkama takêng te amî.” ");
INSERT INTO ymp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yôv me henang ambô dôhô te hêndêng loho nena, “Anô lêk valuseleng bêng te ya nôm ik anông bêng anông heveng kukapô. ");
INSERT INTO ymp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Êng me yêni henang ethak yêni da nena, ‘Tem yambong ômbête? Ya long ya tak yînîng nôm îmô mî.’ ");
INSERT INTO ymp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Me yêni henang nena, ‘Bêng be dô me yambong bêŋiti. Yandining yînîng melak sapêng be yandav melak lêkmuk bêŋbêng vo yandô yînîng nôm lêk nômkama sapêng îmô kapô. ");
INSERT INTO ymp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Me tem ya nang ethak ya da nena, “Lêk yôv! Yînîng nômkama bêng anông hîmô be tem yaŋgang be ya num me ya mô mavî yom îtôm sondakbêng nômbêng iti. Me mî hîtôm yambong ku te amî.” ’ ");
INSERT INTO ymp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Metom Wapômbêng henang ethak ôpêng nena, ‘Ong anô molo! Bîlîvông iti me tem yambua yong lêkmala vê be nôma. Me opalê tem nimbua nômkama takatu be hopesang vo ong da?’ ");
INSERT INTO ymp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Bêng yom be malêing iti tem nimbutak avîlanô takatu be ithining nômkama bêng anông vo loho da hêk pîk metom loho da me nômkama mî hêk Wapômbêng mandaluk.” ");
INSERT INTO ymp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Me Yisu henang ethak ya ŋa hîndông bêng nena, “Lêkmala me bêng vo nôm eyang. Me leŋving kôpik me bêng vo kwêv lo thôp. Be diti ya hanang ethak môlô nena, dô lemim êŋgêv nômkama pîk lomaloma bêng anông îtôm nôm lêk thôp andô. ");
INSERT INTO ymp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Môlô lemim êŋgêv menak nômbêng iti. Loho thak mî evatho nôm be iwa ya anông amî. Lêk loho ning melak lêk balê etak nôm îmô mî. Metom Wapômbêng thak hevakông loho. Be ditu Wapômbêng la hiving môlô bêng anông hîvô hethak vo menak be tem neyaŋging môlô mavî. ");
INSERT INTO ymp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Be ditu lemim ik am ethak nômate me nôm êng mî hîtôm netak wakma te oyang êyômô môlô ning lêkmala long imbing amî. Mî anông. ");
INSERT INTO ymp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Môlô mî hîtôm ombong nôma yaôna te bêŋiti amî. Me hevong bisête be môlô lemim ik am ethak nômkama bêng vi hiving? ");
INSERT INTO ymp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Lemim êŋgêv thiling vuak. Loho ivutak bisête? Loho thak mî evong ku lêk epesang ining thôp amî. Metom ya hanang ethak môlô nena thiling vuak mavî takêng ining wamba leleyang hîvô hethak vo King Solomon ya wamba leleyang lomaloma sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bêng be Wapômbêng hêv wamba mavî mavî hêndêng kamung lomaloma takatu be lêk aô yê, metom yamông me tem îmbôk ethak amela. Me môlô me bêng îvô hethak vo kamung takêng, be ditu Wapômbêng tem nêŋgêv wamba bêng anông êndêng môlô imbing. Alitaknena, môlô ning ôêv iving mî bêng amî. ");
INSERT INTO ymp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Be dô kapôlômim iŋgik am be othalo nena oŋgwang ômbê mena unum ômbê andô. ");
INSERT INTO ymp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vômbê nena ŋa pîk thak leŋiŋhiki be ethalo nôm takêng, metom môlô ning Kamik heyala nôm takatu be môlô êvyak ethak. ");
INSERT INTO ymp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Be ditu môlô lemim iŋgik am vo othalo Wapômbêng ya lêkliŋyak bêng, me tem nêŋgêv nôm takêng sapêng êndêng môlô imbing. ");
INSERT INTO ymp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Môlô boksipsip ondong yaôna, dô môlô kô andô. Môlô ning Kamik la mavî vo nêŋgêv ya lêkliŋyak bêng êndêng môlô. ");
INSERT INTO ymp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Be ditu uwa valuseleng hethak môlô ning nômkama me ôŋgêv êndêng ŋa siv. Ovong bêng me tem umbua vak valuseleng atu be hîmô wak nômbêng iti. Vak valuseleng êng me nômkama kêkêlô lomaloma atu be hîmô melak leng be ya dang mî. Melak leng me anô te mî hîtôm nimbua nômate vanî mena sepbidi mî hîtôm imbuling nômate amî. ");
INSERT INTO ymp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Vômbê nena long alê atu be môlô ning nômkama kêkêlô mavî hîmô, long êng yom ditu tem môlô kapôlômim îmô imbing. ");
INSERT INTO ymp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Môlô pesang am be ombong ku me upuk môlô ning kwak be ôtôm môlô ning lam be oyaŋging îmô ");
INSERT INTO ymp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","hîtôm avîlanô ku takatu be eyaŋging ining anômbêng îmô. Loho ning anômbêng êng bôk hê vo heyang nôm iwa avî yôvêm me tem nîmbôlêm ethak loŋbô. Wakma hîvô lêm ya long be hipindinding melak ambôlêk me tem iŋgik melak ambôlêk kê ketheng be imbua yêni thô. ");
INSERT INTO ymp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Me Mavî vo ŋa ku takatu be ining anômbêng êng hêyô be hêyê nena loho îmô lêlê be eyaŋging yêni hîmô. Ya hanang avanông ethak môlô nena anômbêng êng tem nipuk ya kwak ku me nenang vo loho îndôk îmô elawê balê me tem nêŋgêv nôm êndêng loho îtôm anô ku te. ");
INSERT INTO ymp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Anômbêng hele hêlêm hêndêng bîlîvông bing mena lêkbôk momaŋaning ma be hêyê ya ŋa ku mî êkthôm amî me eyaŋging yêni hîmô, êng me Mavî vo loho. ");
INSERT INTO ymp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Môlô lemim êŋgêv ambô ti katô. Melak te ya alang helaŋô ambô nena ŋa vanî tem ende ya melak kê, êng me yêni hêk lêlê vo ŋa vanî mî hîtôm ende melak êng kê amî. ");
INSERT INTO ymp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Bêng be ditu môlô mô lêlê imbing, vômbê nena Anô Ya Nakandung atu tem nendelêm êndêng wakma atu be môlô thông paling be môlô pîndîk kambom.” ");
INSERT INTO ymp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Me Pita henang nena, “Anômbêng, hôêv ambô dôhô ti hêndêng yoô yom mesa hôêv êndêng avîlanô sapêng hiving?” ");
INSERT INTO ymp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Êng me Anômbêng henang nena, “Ya hanang vo ôpatu be hevong ya anômbêng ya ku mavî hîtôm anô lêkauk bêng atu be heyaŋging nômkama mavî. Melak alang hetak yêni vo neyaŋging ya ŋa ku be nêŋgêv nôm êndêng loho îtôm wakma atu be hîtôk. ");
INSERT INTO ymp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Me Mavî vo anô ku êng hêndêng wakma atu be melak alang hîvô lêm hethak loŋbô be hêyê nena hevong ku êng hîmô. ");
INSERT INTO ymp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ya hanang avanông ethak môlô nena melak alang êng tem netak ôpêng vo neyaŋging ya nômkama sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Metom anô ku êng la hêv hêk kapô nena, ‘Lêk bôô anông me mî yînîng anômbêng îmbôlêm ketheng amî.’ Êng me hik avîlanô ku me heyang nôm lêk hinum waing bêng anông hele be helo molo. ");
INSERT INTO ymp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Hevong bêng îmô be hîthông paling me melak alang êyô be ôpêng îpîndîk kambom. Êng me melak alang tem nêŋgêv vovang bêng êndêng ôpêng me nêndô inda îmô imbing ŋa liŋdong kôtông. ");
INSERT INTO ymp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Anô ku atu be heyala ya anômbêng ya la hiving metom mî hevong nômkama hîtôm ya anômbêng ya la hiving amî me tem nimbua vovang bêng. ");
INSERT INTO ymp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Metom anô ku atu be mî heyala ya anômbêng ya la hiving amî be hevong nômkama kambom me tem nimbua vovang yaô. “Me avîlanô takatu be iwa nômkama bêng anông, êng me Wapômbêng la hiving lohombong ku bêng anông ethak. Me avîlanô be iwa nômkama bêng anông be eyaŋging, êng me Wapômbêng la hiving loho tak bêng anông êyô long imbing be embong ku bêng anông ethak.” ");
INSERT INTO ymp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yisu henang ambô dôhô te nena, “Ya halêm vo yambî amela îndôk pîk. Me ya leng hiving anông nena amela êng ethang ketheng oyang. ");
INSERT INTO ymp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Metom tem ya thik ŋanam te atu be lêk mî ya thik amî denang. Ŋanam êng me vovang lêk malêing bêng anông be tem ya kapôlông malêing bêng anông embeng endebe nîndôk yandang. ");
INSERT INTO ymp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Me môlô song nena ya halêm pîk vo yambong avîlanô kapôlôŋing îndôk bing e? Mî anông! Ya hanang ethak môlô nena ya halêm vo yambak loho kê. ");
INSERT INTO ymp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yaô be nembeng yam me avîlanô bahevi nang melak te tem embak i kê ni ondong yi be lokwaŋlô tem ende dômîng lîlîng êndêng lokwaŋyi, me lokwaŋyi tem ende dômîng lîlîng êndêng lokwaŋlô. ");
INSERT INTO ymp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Me tem embak i kê be lambô tem nende dôm lîlîng êndêng namalô, me namalô tem nende dôm lîlîng êndêng lambô, me talêmbô tem nende dôm lîlîng êndêng nalavî, me nalavî tem nende dôm lîlîng êndêng talêmbô, me yaŋavî tem nende dôm lîlîng êndêng namalô yanavî, me namalô yanavî tem nende dôm lîlîng êndêng yaŋavî.” ");
INSERT INTO ymp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Me Yisu henang ethak avîlanô nômbêng atu bêŋiti, “Thak môlô yê mavông loŋgavu hîmô long wak hê hîlôk, êng me môlô nang nena, ‘Ôthîng tem niŋgik êyô.’ Yôv me ôthîng thak hik êyô. ");
INSERT INTO ymp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Me lovak hêlêm nang vi anông me thak môlô nang nena, ‘Tem tak vovang.’ Yôv me thak tak vovang. ");
INSERT INTO ymp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Môlô avîlanô ambô yôhîng. Môlô yê leng lo pîk be ôêv ya ondong lelalîlîng be oyala katôyang, metom wakma lêk iti me môlô thông ya ondong paling. ");
INSERT INTO ymp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Me bisête be môlô mî ôêv am lelalîlîng be oyala katô nena ômbête me mavî vo ombong? ");
INSERT INTO ymp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ondaŋô! Yong ŋakyo te hevong vo nembong ambô vo ong be hiwa ong be hê melak embong ambô. Be mamu veng loŋdaŋlê hê denang, êng me nopesang ambô imbing yêni ketheng. Me mî hovong bêng amî, êng me ôpêng tem nendandi ong lêklokwang kambom bini êndêng jas. Me jas êng tem nêŋgêv ong ni êndêng kwak bidong. Me kwak bidong êng tem nêmbôv ong kisi bini vo netak îndôk kalaondong. ");
INSERT INTO ymp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ya hanang ethak ong nena tem nômô kalaondong endebe nôŋgêv yong vuli mena tôp viyang atu be etak sapêng êm.” ");
INSERT INTO ymp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yisu henang ambô yôv me anô doho enang ethak inda nena Pailat enang be ya ŋa vovak ik anô Galili doho vônô hêndêng wakma atu be loho îmbôk ining da hêndêng Wapômbêng îmô. ");
INSERT INTO ymp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Me Yisu henang viyang nena, “Môlô song nena anô Galili takêng ining kombom kambom hîvô hethak vo avîlanô Galili vi be ditu malêing êng hêpôm loho e? ");
INSERT INTO ymp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ya hanang ethak môlô nena mî anông. Môlô mî ole kapôlômim lîlîng amî, êng me malêing bêng tem nêpôm môlô sapêng bêng yom be oma. ");
INSERT INTO ymp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Me anô hîtôm 18 takatu be melak dêim nang Siloam hîŋgôlî be hik loho vônô, êng me môlô song nena loho ning kambom hîvô hethak vo avîlanô Jelusalem ining kambom e? ");
INSERT INTO ymp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ya ethak môlô nena mî anông. Môlô mî ole kapôlômim lîlîng amî, êng me tem malêing bêng êpôm môlô sapêng bêng yom be oma.” ");
INSERT INTO ymp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Me Yisu henang ambô dôhô te bêŋiti, “Anô te hevatho alokwang pik te heva ya kukapô. Me ôpêng thak hê kukapô êng lômbôlông vo ninjê nena hik anông mesa mî. Metom mî hik amî. ");
INSERT INTO ymp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Êng me yêni henang ethak ya anô ku atu be heyaŋging kukapô êng nena, ‘Nondaŋô. Hîtôm sondakbêng lokwaŋlô me thak ya halêm ayê alokwang iti ya va metom mî hik amî. Alokwang iti hivuling yînîng pîk iti ya thing. Be dô me nonde li.’ ");
INSERT INTO ymp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Metom anô ku êng henang viyang nena, ‘Anômbêng, notak emba sondakbêng te imbing vo ya tak pîk lêk bokmaŋkao la ethak ondong yôvêm. ");
INSERT INTO ymp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Be hik anông êndêng sondakbêng yang dake ma, êng me mavî. Me mî, yôv me mîng nonde li.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat te me Yisu hîndông avîlanô hîlôk melak yeng te. ");
INSERT INTO ymp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Me avî te hîmô be gôk kambom bôk hêv kômbôk hêndêng yêni be hîmô hîtôm sondakbêng 18. Avî êng dômlokwang lêkgwak kambom be mî hîtôm nemba tololak doke amî me mî anông. ");
INSERT INTO ymp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Me Yisu hêyê yêni be helam nena, “Nôlêm.” Êng me hêlêm me Yisu hetak bang hêyô hêk yêni be henang nena, “Avî, ya hêv yong kômbôk vê.” Me ketheng oyang me heva tololak ethak loŋbô be hêv Wapômbêng ya athêng ling. ");
INSERT INTO ymp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Metom anô atu be heyaŋging melak yeng la maning ethak Yisu hevong avî êng mavî hêndêng Sabat. Êng me anô atu henang ethak avîlanô nena, “Wak bahevi be lahavôtom me wak embong ku. Be ditu môlôlêm êndêng wak takêng vo embong môlô umbutak mavî me dô ôlêm êndêng Sabat andô.” ");
INSERT INTO ymp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Me Anômbêng henang ôpêng ya ambô viyang nena, “Môlô ŋa ambô yôhîng. Môlô sapêng thak opole môlô ning bokmaŋkao lêk bokdoŋki ining yak vê be ê inum ŋanam hêndêng Sabat mesa mî? ");
INSERT INTO ymp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Avî ti me Ablaham lim te. Sakdang hekak yêni long hethak kômbôk hîtôm sondakbêng 18. Me kambom vo ya pole ya yak vê êndêng Sabat mesa?” ");
INSERT INTO ymp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yisu henang ambô êng me ŋa takatu be îpôlîk ethak yêni elaŋô be loho moma kambom, metom avîlanô sapêng leŋing mavî hethak nôm mavî nômbêng atu be Yisu hevong. ");
INSERT INTO ymp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yôv me Yisu henang nena, “Wapômbêng ya lêkliŋyak bêng me bisête be hîtôm ya nang ethak ômbête? ");
INSERT INTO ymp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nôm êng me hîtôm alokwang va yaôna te. Be anô te hiwa be hevatho hîlôk ya kukapô. Yôvêm me alokwang va êng hilumbak bêng hîtôm alokwang be menak elav ining melak hîlôk ya thaŋang.” ");
INSERT INTO ymp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Me Yisu henang ethak loŋbô nena, “Tem ya nang ambô dôhô alête ethak Wapômbêng ya lêkliŋyak bêng? ");
INSERT INTO ymp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nôm êng me hîtôm avî te hiwa yis doke be hetak îlôk thiling bêng anông kapô me hisiŋgi hele be thiling sapêng hithing bêng.” ");
INSERT INTO ymp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yisu hê vini Jelusalem me hê hîmô melak lông bêŋbêng lêk melak ondong nenanena me hîndông avîlanô heveng loŋdaŋlê. ");
INSERT INTO ymp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Me anô te henang ik yêni ling nena, “Anômbêng, Wapômbêng tem nêŋgêv anô tomtom yom vê injêk kambom ya vuli mesa?” Me Yisu henang ethak loho nena, ");
INSERT INTO ymp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Môlô manjeng anông vo umbutak ôyô melak ambôlêk yaôna. Ya hanang avanông bing ethak môlô nena anô bêng anông tem leŋing imbing imbutak êyô, metom loho mî hîtôm amî. ");
INSERT INTO ymp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yôv me melak alang tem nimbiyô be niŋgik melak ambôlêk thing me môlô tem omba vi yêing be upindinding melak ambôlêk be ondam nena, ‘Anômbêng, nuŋgik melak ambôlêk kê vo yoô.’ “Metom yêni tem nenang viyang nena, ‘Ya hathông môlô paling. Môlôlêm nang êsê?’ ");
INSERT INTO ymp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Me tem môlô nang ethak yêni nena, ‘Sêmbôk yoô ang be anum iving ong me hôndông yoô heva yoô ning loŋdaŋlê.’ ");
INSERT INTO ymp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Metom yêni tem nenang nena, ‘Ya hathông môlô paling. Môlôlêm nang êsête? Môlô ŋa kambom be ombeng dang vo ya!’ ");
INSERT INTO ymp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","29","“Me avîlanô long bôyang tem etak pîk luvuluvu sapêng me ini vo injang nôm bêng îmô Wapômbêng ya lêkliŋyak bêng. Êng me tem môlôŋgô Ablaham lo Aisak me Jekop lêk plopet sapêng tem îmô long êng. Metom Wapômbêng tem nêŋgêv môlô vê be môlô tem ondeng athêng malêng be othang viemim ondong long. ");
INSERT INTO ymp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ondaŋô. Ŋa eveng yam doho tem imbutak îtôm ŋa imung. Me ŋa imung doho tem endeni be imbutak îtôm ŋa eveng yam.” ");
INSERT INTO ymp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hêndêng wakma Yisu henang ambô takêng yôv me Palisi doho êlêm me enang ethak Yisu nena, “Notak long iti be nu bôyang, vômbê nena Helot evong vo niŋgik ong vônô.” ");
INSERT INTO ymp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Me Yisu henang viyang nena, “Môlô nu nang ethak avung yatap êng nena, ‘Nondaŋô. Yaô be yamông me tem yaŋgêv gôk kambom vê be yambong avîlanô lêk kômbôk mavî. Be hîtôm wak lô me tem yaŋgik yînîng ku ya dang thing.’ ");
INSERT INTO ymp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bêng be yaô be yamông be neyang, me tem yambeng yom be yana Jelusalem, vômbê nena Jelusalem me long thak ik plopet sapêng vônô hêk, be ditu kambom vo plopet ema injêk bôyang ining long! ");
INSERT INTO ymp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Aê Jelusalem, Jelusalem! Môlô thak uik plopet vônô. Me ŋa takatu be Wapômbêng hêv hêlêm me môlô uik loho hethak valu. Alitaknena! Ya havong lômbôlông vo ya thup nalumi ethak tom îtôm tale talêmbô hithup nali be îmô banik kapô. Metom môlôndô! ");
INSERT INTO ymp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ondaŋô! Wapômbêng tem netak môlô ning melak lông be nîmô thiliv! Ya hanang avanông ethak môlô nena môlô tem mî ôŋgô ya ethak loŋbô amî endebe môlô nang nena, ‘Wapômbêng embong mavî êndêng ôpatu be hêlêm ethak Anômbêng ya athêng!’ êm.” ");
INSERT INTO ymp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat te me Yisu hê heyang nôm îmô Palisi ning anômbêng te ya melak me loho elav long manjeng vo inda. ");
INSERT INTO ymp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Me anô te liŋkôpik hithing kambom be hîmô bidong oyang vo Yisu. ");
INSERT INTO ymp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Me Yisu henang ik Palisi lêk ŋa lêk auk ethak ambô balambung ling nena, “Hîtôm aômbong ŋa lêk kômbôk mavî êndêng Sabat mesa dô?” ");
INSERT INTO ymp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Metom loho bonong yom. Êng me hiwa anô kômbôk êng be hepesang inda hivutak mavî me hetak be hê. ");
INSERT INTO ymp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Me Yisu henang ethak loho nena, “Môlô ning sêik te mena bokmaŋkao te ma hêv yak îlôk lovang êndêng Sabat me tem môlô nu ketheng vo ondandi imbutak yêing mesa mî?” ");
INSERT INTO ymp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Metom loho mî hîtôm enang ambô êng viyang amî. ");
INSERT INTO ymp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yisu hêyê avîlanô êlêm vo injang nôm me loho ê îlôk îmô ŋa bêŋbêng ining long thak îmô yom. Êng me yêni henang ambô dôhô te hêndêng loho nena, ");
INSERT INTO ymp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Anô te heŋgambôm nôm hiwa avî be helam ong me dô nundôk ômô ŋa bêŋbêng ining long andô. Endekeme loho bôk îtôk long êng yôv vo anô lêk athêng bêng te hîvô ethak vo ong. ");
INSERT INTO ymp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Me wakma nôm ya alang hêyô me tem nenang ethak ong nena, ‘Ong vê vo ôpiti tem nimbua yong long.’ Êng me tem ong moma kambom be nundôk ômô ŋa athêng mî ining long. ");
INSERT INTO ymp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bêng be anô te helam ong be hô vo noŋgwang nôm, êng me nômô vindôm anông. Hovong bêng me nôm alang tem nêlêm enang nena, ‘Aiyang, nôlêm ômô imbing ŋa bêŋbêng.’ Yêni da hevong bêng me tem numbua athêng bêng injêk ŋa nômbêng atu be êlêm eyang nôm êng maleŋing. ");
INSERT INTO ymp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Anô te hêv ya athêng ling me Wapômbêng tem netaving ôpêng. Metom anô te hetaving i hele be yaôna me Wapômbêng tem nêŋgêv ya athêng ling.” ");
INSERT INTO ymp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Me Yisu henang ethak melak ya alang nena, “Hovong vo nôpôpêk nôm bêng me dô nondam yong avîlanô môlôô lêk yong lêkma me avîlanô lêk valuseleng bêng yom andô. Hovong bêng me yôvêm ketem endam ong be nu loho ning melak me tem êŋgêv yong nôm viyang bêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Metom waklavông hôpôpêk nôm bêng, êng me nondam ŋa siv lêk ŋa baheŋing lo veŋing kambom lêk ŋa imuving me ŋa maleŋing pusip. ");
INSERT INTO ymp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ŋa takatu be mî hîtôm êŋgêv yong nôm viyang amî. Êng me tem mavî vo ong, vômbê nena heveng yam me Wapômbêng tem nêŋgêv yong nôm êng viyang êndêng waklavông atu be avîlanô thêthôp iviyô hethak loŋbô hêk ŋama.” ");
INSERT INTO ymp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Anô te atu be heyang nôm hîmô hiving Yisu helaŋô ambô êng me henang ethak Yisu nena, “Mavî vo avîlanô takatu be tem injang nôm bêng îmô Wapômbêng ya lêkliŋyak bêng kapô.” ");
INSERT INTO ymp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Me Yisu henang viyang nena, “Anô te hevong ya nôm bêng te be hêv ya anô ku te be hiwa ambô hê be vo avîlanô bêng anông. ");
INSERT INTO ymp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wakma ôpêng epesang nôm yôv me hêv ya anô ku atu be hê hethak loŋbô hêndêng avîlanô takatu be bôk hêv ambô yôv vo nenang ethak loho nena, ‘Môlôlêm. Lêk yoô pesang nômkama sapêng yôv.’ ");
INSERT INTO ymp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Metom avîlanô takêng mî esopa ya ambô amî. Be ditu anô te henang nena, ‘Lêk ya hêv kukapô bôte vuli yôv be tem yana vo yaŋga. Alitakna, ku êng evalong ya long be ditu hîtôm notak ya?’ ");
INSERT INTO ymp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Me anô yang henang nena, ‘Lêk ya hêv bokmaŋkao lauming vuli vo embong yînîng ku be tem yana vo ya yek loho vo yaŋga. Alitakna, ku êng evalong ya long be ditu hîtôm notak ya?’ ");
INSERT INTO ymp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Me anô yang henang nena, ‘Lêk ya hauwa avî lêkmuk be mî hîtôm ya thôk amî.’ ");
INSERT INTO ymp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Yôv me anô ku hiwa ambô takêng be hê vo ya anômbêng. Me melak ya alang la maning kambom be henang ethak ôpêng nena, ‘Nu ketheng oyang êndêng melak lông ya loŋdaŋlê bêng lêk loŋdaŋlê yaônena sapêng me numbua ŋa siv lêk ŋa imuving lêk ŋa baheŋing lo veŋing kambom lêk ŋa maleŋing pusip be nôlêm yînîng melak kapô.’ ");
INSERT INTO ymp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Yôv me anô ku êng hîvô lêm me henang nena, ‘Anômbêng, lêk ya havong hîtôm honang, metom melak mî putup amî denang.’ ");
INSERT INTO ymp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Me anômbêng enang ethak anô ku êng nena, ‘Notak melak lông me nu loŋdaŋlê bêng lêk loŋdaŋlê yaô sapêng be hôyê avîlanô me nonang lêklokwang nena loho îmbô thak be êlêm. Ya leng hiving yînîng melak putup anông. ");
INSERT INTO ymp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya hanang ethak môlô nena ŋa takatu be bôk ya halam loho yôv metom mî elaŋô yînîng ambô be esopa amî, loho mî hîtôm injang yînîng nôm doke amî me mî anông.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Avîlanô bêng anông eveng hiving Yisu. Be ditu hik i lîlîng me henang ethak loho nena, ");
INSERT INTO ymp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Anô te hevong vo nesopa ya, metom mî la hiving ya îvô hethak vo lambô lo talêmbô me yanavî lêk nali me viyaŋi lêk livi me ya lêkmala hiving amî, yêni mî hîtôm nîmô îtôm yînîng anô ya handông te amî. ");
INSERT INTO ymp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Me ôpatu be mî hiwa ya alovalasing be hesopa ya amî, yêni mî hîtôm nîmô îtôm yînîng anô ya handông te amî. ");
INSERT INTO ymp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Môlô ning anô te la hiving nendav melak dêim bêng te, êng me tem nîmô be laŋgêv katô êm nena hîtôm nendav melak êng be niŋgik thing mesa mî. ");
INSERT INTO ymp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Me mî la hêv bêng amî me tem nendav landîng yom me mî hîtôm niŋgik thing amî. Me avîlanô sapêng tem injê be emalîk ethak yêni ");
INSERT INTO ymp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","be tem enang nena, ‘Helav landîng yom me mî hîtôm niŋgik melak thing amî!’ ");
INSERT INTO ymp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Me king te la hêv nembong vovak imbing king yang, êng me tem nîmô be laŋgêv katô êm, vômbê nena ya ŋa vovak hîtôm 10,000 yom be hîtôm niŋgik vovak imbing king yang atu be ya ŋa vovak îtôm 20,000 mesa mî. ");
INSERT INTO ymp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Me heyala nena yêni mî hîtôm amî, êng me tem nêŋgêv ambô ni vo king yang atu be hîmô dêim denang vo thêi pesang ambô vo vovak dô. ");
INSERT INTO ymp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Me bêng yom, môlô te mî hele dôm lîlîng êndêng ya nômkama sapêng amî, êng me ôpêng mî hîtôm nîmô îtôm yînîng anô ya handông te amî. ");
INSERT INTO ymp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mamik me nôm vathing mavî. Metom wakma thilimbung be ya vathing hêv yak, êng me tem aômbong bisête vo vathing ethak loŋbô? Mî anông. ");
INSERT INTO ymp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bêng be ya ku lêk mî be dô me okaliv ini. “Bêng yom me môlô ŋa lêk liŋdong me ondaŋô ambô tiêng katôyang!” ");
INSERT INTO ymp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ŋa iwa takis lêk ŋa evong kombom kambom, êlêm vo endaŋô Yisu ya ambô. ");
INSERT INTO ymp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Metom Palisi lêk kîdôŋga ambô balambung enang ambô ŋôlôŋôlông bêng anông be enang nena, “Ôpiti hiwa ŋa kombom kambom thô be heyang nôm hiving loho.” ");
INSERT INTO ymp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Êng me Yisu henang ambô dôhô tiêng hêndêng loho nena, ");
INSERT INTO ymp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Môlô te ya boksipsip hîtôm 100 be te mî, êng me tem nembong ômbête? Yêni tem netak boksipsip 99 atu be injang kamung îmô me tem ni vo nethalo ali atu be mî endebe nêpôm êm. ");
INSERT INTO ymp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Me wakma atu be hêpôm me tem nimbua êyônjêk thakôk lêk la mavî bini. ");
INSERT INTO ymp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Me hêyô ya melak me tem nendam ya ŋa môlôô lêk ŋa takatu be îmô bidong iving yêni be nenang nena, ‘Ya leng mavî anông ethak lêk ya hatung yînîng boksipsip atu yôv, be ditu môlôlêm vo aô leŋing mavî ethak tom.’ ");
INSERT INTO ymp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Me ya hanang ethak môlô nena, ŋa melak leng leŋing mavî anông vo avîlanô thêthôp hîtôm 99 takatu be bôk ele kapôlôŋing lîlîng yôv, metom loho leŋing mavî bêng anông hîvô hethak vo anô kombom kambom te hele kapô lîlîng.” ");
INSERT INTO ymp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Me Yisu henang nena, “Avî te ya valuseleng silva lauming hîmô metom te mî. Êng me tem nembong ômbête? Yêni tem nêtôm amela be nîthî melak kapô be nethalo endebe nêpôm valuseleng êng. ");
INSERT INTO ymp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Me wakma atu be hêpôm me tem nendam ya ŋa môlôô lêk ya ŋa takatu be îmô bidong iving yêni me nenang ethak loho nena, ‘Ya leng mavî anông ethak lêk ya hatung yînîng valuseleng atu yôv, be ditu môlôlêm vo aô leŋing mavî ethak tom.’ ");
INSERT INTO ymp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ya hanang ethak môlô nena, leŋing mavî te da bêng yom thak hivutak hêk Wapômbêng ya aŋêla lîvông hethak anô kombom kambom te hele kapô lîlîng.” ");
INSERT INTO ymp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Me Yisu henang nena, “Anô te namalô bôp lo nok îmô. ");
INSERT INTO ymp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wak te me nok enang ethak lambô nena, ‘Wakamik, nombak yong nômkama kê ni ondong yi be nôŋgêv yînîng êndêng ya.’ Êng me lambô hik nômkama tham hê ondong yi be hêv êndêng namalô luvi. ");
INSERT INTO ymp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Yôv me nok hîmô vauyaŋna me hêv ya nômkama be avîlanô êv vuli me hiwa valuseleng sapêng be hê long bôyang. Me hevong kombom kambom lomaloma be hivuling ya valuseleng sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hele be ya valuseleng hitup me bôm bêng hêyô long êng me hêv yak ethak nômkama sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Me hê hêyô vo anô long êng te me henang ik ôpêng ling vo nêŋgêv ku te vo yênimbong, êng me ôpêng hêv ku vo neyaŋging ya bok. ");
INSERT INTO ymp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Me hema ve la be la hiving ninjang bok ining nôm doho, vômbê nena anô te mî hêv nômate hêndêng yêni amî. ");
INSERT INTO ymp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Yôv me yêni hiwa auk mavî be henang nena, ‘Aê, wakamik lêk ya ŋa ku sapêng eyang nôm mavî bêng anông be ekaliv viyang hê. Metom ya hamô long iti be ya hama vo ya leng kambom anông be tem ya ma! ");
INSERT INTO ymp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yambiyô be yana vo wakamik me ya nang ethak yêni nena, “Wakamik, ya havong kambom bêng êndêng ong lêk Wapômbêng. ");
INSERT INTO ymp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ya mî anô mavî hîtôm nondam ya nena nalum amî. Be ditu notak ya îtôm yong anô ku te.” ’ ");
INSERT INTO ymp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Yôv me yêni hiviyô be hê hêyô vo lambô. Me heva dêim denang me lambô hêyê be lahiki hethak yêni. Me hevothong be hê hêndêng namalô me heva inda hêk be hiŋgu mandang lômbôlông. ");
INSERT INTO ymp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Me nakandung enang ethak lambô nena, ‘Wakamik, ya havong kambom bêng hêndêng ong lêk Wapômbêng. Ya mî anô mavî hîtôm nondam ya nena nalum malô amî.’ ");
INSERT INTO ymp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Metom lambô henang ethak ya ŋa ku nena, ‘Ketheng! Umbua kwêv dêim ali mavî anông atu lêm vo aôŋgik îndôk yînîng wakna. Me uŋgik thilak îndôk baŋduk me uŋgik vakapô bokgôp ethak yêni va. ");
INSERT INTO ymp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Me môlô nu umbua bokmaŋkao dopdop te lêm me uŋgik vo aôŋgang lêk leŋing mavî, ");
INSERT INTO ymp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","vômbê nena yînîng wakna tiêng bôk hema yôv, metom lêk hîmô lêkmala hethak loŋbô. Yêni bôk mî, metom lêk aô pôm yêni hethak loŋbô.’ Êng me loho eŋgambôm nôm bêng be eyang me leŋing mavî. ");
INSERT INTO ymp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Me namalô bôp heveng ku denang. Yôv me hetak kukapô me hele hêlêm êyô bidong melak me helaŋô avîlanô eloyeng bêng. ");
INSERT INTO ymp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Êng me yêni helam anô ku te hêlêm me henang ik ôpêng ling nena, ‘Loho vong ômbête?’ ");
INSERT INTO ymp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Me anô ku êng henang ethak yêni nena, ‘Aviyam molok hele hêlêm be lemambô lêk hiwa yêni hethak loŋbô be hik bokmaŋkao dopdop te, vômbê nena yêni hîmô mavî be hele hêlêm.’ ");
INSERT INTO ymp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Namalô bôp helaŋô ambô êng me la maning be hêndô ni melak kapô. Êng me lambô hele yêing me hevong vo nembong yêni lanjêk yaô. ");
INSERT INTO ymp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Metom henang ethak lambô nena, ‘Nondaŋô! Sondakbêng nômbêng iti me thak mî ya haseng yong ambô amî me thak ya havong yong ku hîtôm anô oyang. Metom bôk mî huik bokmeme map te vo ya lêk yînîng ŋa môlôô aŋgang amî. ");
INSERT INTO ymp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Me nalum iti bôk hêv yong nômkama sapêng hêndêng avî sek mayaliv, metom hîvô lêm me huik êi ning bokmaŋkao dopdop mavî ti vo?’ ");
INSERT INTO ymp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Me lambô henang ethak inda nena, ‘Yînîng wakna, wak nômbêng iti me hômô hiving ya be yînîng nômkama sapêng me yong. ");
INSERT INTO ymp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Metom lêk me aô leŋing mavî, vômbê nena aviyam molok bôk hema yôv metom lêk hîmô lêkmala hethak loŋbô. Yêni bôk mî metom lêk aô tung yêni hethak loŋbô.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yisu henang ethak ya ŋa hîndông nena, “Anô lêk valuseleng bêng te hetak anô te vo neyaŋging ya ku. Heveng yam me helaŋô nena ôpêng hivuling ya nômkama. ");
INSERT INTO ymp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Be ditu helam yêni hêlêm me henang nena, ‘Ya halaŋô nena huvuling yînîng nômkama. Be ditu nokavu yong ku ya lavông êlêm vo yaŋga, vômbê nena ong mî hîtôm numbutak avaka vo noyaŋging yînîng ku ethak loŋbô amî.’ ");
INSERT INTO ymp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Me avaka atu la hêv nena, ‘Yînîng anômbêng tem nêŋgêv ya vê injêk ya ku, bêng be yambong ômbête? Ya lêklokwang mî hîtôm yandav pik amî lêk ya moma vo ya petenak avîlanô vo êŋgêv ya livung. ");
INSERT INTO ymp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Lêk ya hayala nôm atu be tem yambong vo avîlanô leŋing mavî be imbua ya thô ethak ining melak êndêng waklavông atu be yînîng anômbêng hêv ya vê hêk ku avaka.’ ");
INSERT INTO ymp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Êng me yêni helam ŋa takatu be bôk iwa anômbêng ya nômkama be loho ning tôp hêk denang. Anô mung hêyô me yêni henang ik ôpêng ling nena, ‘Huwa yînîng anômbêng ya nômkama vithê be yong tôp hêk denang?’ ");
INSERT INTO ymp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Me ôpêng enang nena, ‘Ya hauwa wel lêk kolopak îtôm 100.’ Êng me avaka atu henang nena, ‘Numbua kapua atu be bôk ya hakavu yong tôp hîlôk êlêm ketheng me nokavu nena 50 yom.’ ");
INSERT INTO ymp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Yôv me henang ik anô yang heveng yam ling nena, ‘Yong tôp vithê?’ “Êng me ôpêng henang nena, ‘Ya hauwa wit lêk vak hîtôm 100.’ “Me henang nena, ‘Numbua kapua atu be bôk ya hakavu yong tôp hîlôk êlêm me nokavu 80 yom.’ ");
INSERT INTO ymp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Êng me anômbêng atu hêyê nôm atu be ya avaka kambom evong be hêv ya athêng ling ethak ya auk bêng. Avanông, ŋa pîk ining auk embong mavî imbing loho da hîvô hethak vo ŋa danda.” ");
INSERT INTO ymp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ya hanang ethak môlô nena umbua nômkama pîk be ôŋgêv êndêng avîlanô vi vo loho leŋing mavî ethak môlô. Me waklavông atu be nômkama yandang, êng me tem imbua môlô thô bini melak atu be tem ômô mavî wak nômbêng iti sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ôpatu be heyaŋging nôm yaônena mavî me hîtôm neyaŋging nômbêng bêng mavî bêng yom. Me ôpatu be heyaŋging nôm yaônena kambom, êng me tem neyaŋging nômbêng bêng kambom bêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bêng be môlô mî thak oyaŋging nômkama pîk iti mavî amî, êng me opalê tem nêŋgêv ku vo oyaŋging nômkama melak leng takatu be tem nîmô îtôm wak nômbêng iti sapêng? Mî anông. ");
INSERT INTO ymp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Me môlô yaŋging anô yang ya nômkama kambom, êng me opalê tem nêŋgêv nômkama vo môlô da? Mî anông. ");
INSERT INTO ymp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Anô ku te mî hîtôm nembong anômbêng yi ning ku amî. Tem laŋgêv imbing anô yang sê me kapô êndô anô yang sê. Me tem nesopa anô yang sê me nende dôm lîlîng êndêng anô yang sê. Môlô mî hîtôm osopa Wapômbêng lêk valuseleng imbing amî.” ");
INSERT INTO ymp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ŋa Palisi takatu be leŋing iving valuseleng elaŋô Yisu ya ambô takêng be enang ambôma hethak inda. ");
INSERT INTO ymp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Be ditu Yisu henang ethak loho nena, “Môlôvong vo avîlanô leŋing êŋgêv nena môlô ŋa thêthôp, metom Wapômbêng heyala môlô kapôlômim. Nôm takatu be avîlanô pîk leŋing êv nena nôm mavî anông, êng me Wapômbêng hêyê nena nôm kambom anông.” ");
INSERT INTO ymp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Me Yisu henang nena, “Ambô balambung lêk plopet ining ambô yom heyaŋging avîlanô hele be hêyô Jon ya wakma. Metom hêndêng wakma êng hele be hêyô lêk me ya hanang Ambô Mavî bêng ethak Wapômbêng ya lêkliŋyak bêng. Be ditu avîlanô bêng anông lêklokwang vo imbutak êyô kapô. ");
INSERT INTO ymp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pîk lo leng tem nêŋgêv yak, metom Wapômbêng ya ambô balambung bônate mî hîtôm nêŋgêv yak amî. ");
INSERT INTO ymp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Anô te hêndô yanavî be hiwa avî yang, êng me hevong sek. Me anô te hiwa avî atu be yamalô bôk hêndô yêni, êng me ôpêng evong sek bêng yom.” ");
INSERT INTO ymp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Anô lêk valuseleng bêng te hîmô be thak hik kwêv thapuk lêk kwak lêkma kêkêlô mavî mavî. Me thak heyang nôm mavî lomaloma lêk la mavî bêng anông wak nômbêng iti sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Me anô siv te be ya athêng nena Lasalus be thak hêk ôpêng ya melak bandêng ambôlêk. Be palê hêtêtô liŋkôpik sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Be thak la hiving ninjang nôm pômôp takatu be hêv yak îlôk ôpêng ya balê nôm vimbing. Thak hîmô me avung êlêm ethamî ya palê. ");
INSERT INTO ymp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Wak te me anô siv atu hema me aŋêla iwa yêni be ê êndô hîmô bidong oyang hiving Ablaham. Yôvêm me anô lêk valuseleng bêng atu hema hiving be elav. ");
INSERT INTO ymp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Anô lêk valuseleng bêng atu hîmô ŋa ema ning long be hiwa vovang bêng. Yêni hêv mandaluk ling me hêyê Ablaham lo Lasalus îmô dêimbô. ");
INSERT INTO ymp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Êng me helam nena, ‘Wakamik Ablaham, lem iŋgik ong ethak ya be nôŋgêv Lasalus êlêm vo netak baŋduk oyang îndôk ŋanam be netak êyômô ya diŋang vo thilimbung, vômbê nena ya hauwa vovang bêng anông hîmô amela tiêng.’ ");
INSERT INTO ymp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Metom Ablaham henang viyang nena, ‘Yînîng wakna, lem êŋgêv sêmbôk be hômô pîk me bôk huwa yong nôm mavî mavî yôv me Lasalus hiwa ya kambom kambom. Metom long iti me lêk yêni hîmô mavî me huwa vovang. ");
INSERT INTO ymp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Me nômate hiving nena, Wapômbêng bôk hetak kolong bêng te hêk lîvông vo yoô me môlô. Be ditu mî hîtôm môlôlêm vo yoô me yoô thôk vo môlô amî.’ ");
INSERT INTO ymp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Me ôpêng enang nena, ‘Bêng be wakamik, ya hapetenak ong nena hîtôm nôŋgêv Lasalus be nendeni wakamik ya melak ");
INSERT INTO ymp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","me nenang ambô lêklokwang êndêng yînîng aiyang bahevi takatu vo dô êlêm long vovang bêŋiti imbing ya andô.’ ");
INSERT INTO ymp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Metom Ablaham henang nena, ‘Ôndô, Moses lêk plopet ining ambô hêk be hîtôm endaŋô be esopa.’ ");
INSERT INTO ymp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Me ôpêng henang nena, ‘Wakamik Ablaham, mî hîtôm amî. Metom betha anô ŋama te ni êndêng loho, êng me tem loho ende kapôlôŋing lîlîng.’ ");
INSERT INTO ymp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Metom Ablaham henang ethak yêni nena, ‘Loho mî elaŋô Moses lêk plopet ining ambô amî, bêng yom be anô ŋama te hiviyô hethak loŋbô me tem mî endaŋô ya ambô imbing amî.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yisu henang ethak ya ŋa hîndông nena, “Nômkama lomaloma tem nêyô vo nembong be avîlanô ning êv iving tem nêŋgêv yak. Metom alitakna vo anô atu be hevong nôm takêng ivutak loho. ");
INSERT INTO ymp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vovang bêng tem nêpôm ôpatu be hevong sêiknena takiti te hêv yak be hevong kambom, me hîvô hethak vo êthôkêng valu malêing bêng te ethak yêni lôkbudum be ekaliv îndôk mamik kapô vo nema. ");
INSERT INTO ymp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Be ditu oyaŋging am. “Aviyam evong kambom ethak ong, êng me nonang ya kambom êng bêng ethak inda. Helaŋô ong be hele kapô lîlîng, êng me notak yêni ya kambom êng. ");
INSERT INTO ymp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Metom aviyam hevong kambom hêndêng ong îtôm bôlô bahevi be lahavôyi hêndêng wak te, me bôlô bahevi be lahavôyi me hîvô lêm henang ethak ong nena, ‘Alitakna, ya havong kambom êndêng ong,’ êng me notak yêni ya kambom takatu be hevong ethak ong.” ");
INSERT INTO ymp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Me aposol enang ethak Anômbêng nena, “Nombong yoô ning êv iving ini bêng!” ");
INSERT INTO ymp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Me Anômbêng enang nena, “Môlô ning ôêv iving me yaôna hîtôm alokwang va yaôna te, êng me hîtôm môlô nang ethak alokwang bêng te nena, ‘Nosapu ong da be numba mamik,’ êng me tem nendaŋô môlô ning ambô be nesopa.” ");
INSERT INTO ymp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Me Yisu henang nena, “Môlô te hêv ku vo ya anô ku te ni vo nendav pîk be nembatho nôm îndôk mena hêv yêni hê vo neyaŋging boksipsip. Yôv me wakma atu ôpêng hele hêlêm nang ya ku atu be hevong, êng me betha tem nenang êndêng inda vo nîndôk îmô ketheng be ninjang nôm imung yôvêm mesa? ");
INSERT INTO ymp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mî. Tem nenang ethak yêni nena, ‘Nupuk yong kwak me nopesang yînîng nôm imung be numbua lêm vo yaŋgang be yanum imung. Yôv kîmîng noŋgwang be nunum embeng yam.’ ");
INSERT INTO ymp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Me betha tem nenang la mavî êndêng ya anô ku atu ethak ku atu be hevong mesa? Mî. Yêni hevong ya ku yom. ");
INSERT INTO ymp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Me môlô bêng yom. Môlôvong ku takatu be Anômbêng hêv hêndêng môlô be ovong yôv, êng me môlô nang nena, ‘Yoô me ŋa ku oyang be yoô vong yoô ning ku yom.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisu heveng loŋdaŋlê hê Jelusalem hele be hêyô Samalia lo Galili ining pîk ya ôlôv. ");
INSERT INTO ymp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Me hê bidong melak lông yaôna te me ŋa kômbôk lepla lauming êlêm êpôm yêni. Loho va dêim doke ");
INSERT INTO ymp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","me elam nena, “Anômbêng Yisu, lem iŋgik ong ethak yoô.” ");
INSERT INTO ymp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Me Yisu hêyê loho me henang nena, “Môlô nu uŋgik am thô êndêng ŋa îmbôk da.” Êng me loho eveng loŋdaŋlê be ê denang me leŋving kôpik hivutak mavî. ");
INSERT INTO ymp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Me ŋa takêng te hêyê nena liŋkôpik lêk hivutak mavî, êng me hele hê me helam kaêk lêkwaê anông be hêv Wapômbêng ya athêng ling. ");
INSERT INTO ymp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Me hêyô be heya vabudum thîvô be thohav lo ma hîlôk pîk hîmô Yisu valuvi me henang la mavî hêndêng yêni. Ôpêng me anô Samalia te. ");
INSERT INTO ymp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Me Yisu henang nena, “Ya havong anô lauming ivutak mavî. Me aŋga anô bahevi be lahavôva îmô sê? ");
INSERT INTO ymp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hevong bisê be anô long bôyang yom hele hêlêm be hêv Wapômbêng ya athêng ling me anô vi mî?” ");
INSERT INTO ymp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Me Yisu henang ethak ôpêng nena, “Numbiyô be nu. Yong hôêv iving yom lêk hevong be ong mavî.” ");
INSERT INTO ymp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wak te me Palisi enang ik Yisu ling nena, “Aŋgête me tem Wapômbêng ya lêkliŋyak bêng êlêm?” Me Yisu henang viyang nena, “Wapômbêng ya lêkliŋyak bêng hêlêm me avîlanô tem mî injê amî. ");
INSERT INTO ymp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Be ditu tem mî enang nena, ‘Ôŋgô, diti hîmô long iti,’ mena ‘Hîmô long daku.’ Ondaŋô. Wapômbêng ya lêkliŋyak bêng lêk hîmô môlô lîvông yôv.” ");
INSERT INTO ymp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Me Yisu henang ethak ya ŋa hîndông nena, “Wakma te tem nêyô be tem môlô lemim imbing anông vo ôŋgô Anô Ya Nakandung ya waklavông nendelêm. Metom tem mî môlôŋgô amî. ");
INSERT INTO ymp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Me avîlanô doho tem enang ethak môlô nena, ‘Ôŋgô, yêni heva long iti!’ mena ‘Heva long daku!’ Êng me môlô mô yaô me dô osopa loho andô, ");
INSERT INTO ymp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","vômbê nena Anô Ya Nakandung atu ya waklavông me tem avîlanô sapêng injê îtôm damak hêv be hîmbî danda heveng leng sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Metom tem nimbua vovang lomaloma me ŋa bôlôti tem ende dômîm lîlîng êndêng yêni yôvêm. ");
INSERT INTO ymp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Anô Ya Nakandung atu ya waklavông tem nimbutak îtôm sêmbôk be Noa ya waklavông. ");
INSERT INTO ymp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Avîlanô eyang be inum be iwa i heveng ele be hêyô wakma Noa hê yeng kapô. Êng me ŋanambô bêng hêyô be hivuling loho sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bêng yom hîtôm sêmbôk be Lot ya waklavông. Avîlanô eyang be inum be êv vuli lêk iwa vuli be evatho yaŋvêk lêk elav ining melak. ");
INSERT INTO ymp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Metom waklavông atu be Lot hetak Sodom be hê me amela lêk valu vovang salpa hîlôk nang leng be hivuling loho sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Waklavông atu be Anô Ya Nakandung atu niŋgik i thô me tem nimbutak ketheng oyang bêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Wak êng me anô te hîmô melak vôv me ya nômkama hîmô melak kapô, êng me dô nendeni melak kapô vo nimbua ya nômkama andô. Me bêng yom, anô te heva kukapô me dô nendeni melak vo nimbua ya nômate andô. ");
INSERT INTO ymp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Môlô lemim êŋgêv Lot yanavî! ");
INSERT INTO ymp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Anô te hevong vo nembalong ya lêkmala long, êng me ya lêkmala tem nêŋgêv yak. Metom anô te hetak ya lêkmala, êng me tem nimbua lêkmala îtôm wak nômbêng iti. ");
INSERT INTO ymp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ya hanang ethak môlô nena bîlîvông atu be yandelêm me anô yi tem injêk yêm tom, metom Wapômbêng tem imbua anô yang me yang tem ninjêk. ");
INSERT INTO ymp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Me avî yi tem epesang ining thiling îmô, metom tem nimbua avî yang me yang tem nîmô.” ");
INSERT INTO ymp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yisu ya ŋa hîndông enang ik yêni ling nena, “Anômbêng, nôm êng tem nimbutak êsê?” Me Yisu henang nena, “Menak jêng thak ethak tom hîmô long takatu be alim epalê hêk.” ");
INSERT INTO ymp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yisu henang ambô dôhô te hêndêng ya ŋa hîndông vo eteng mek îtôm wak nômbêng iti sapêng me dô kapôlôŋing injap andô. ");
INSERT INTO ymp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Be henang bêŋiti, “Melak lông te me jas te hîmô. Yêni thak mî hêkô Wapômbêng amî me thak hîpôlîk ethak avîlanô hiving. ");
INSERT INTO ymp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Me avî tôp te hîmô long êng. Be yêni hê hêndêng jas êng lômbôlông be henang nena, ‘Yêi lêk ŋakyo te ayê i kambom be nôlêm opesang. Be ditu nôlêm ondaŋô yînîng ambô be nopesang.’ ");
INSERT INTO ymp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Metom jas hêndô avî tôp êng ya ambô hîtôm bôlô bêng anông. “Hîtôm wak te me jas êng la hêv nena, ‘Mî ya hakô Wapômbêng amî me thak ya hapôlîk ethak avîlanô ning ambô hiving, ");
INSERT INTO ymp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","metom ya handô avî tôp iti nêlêm wak nômbêng iti sapêng be nimbuling yînîng auk. Bêng be yandaŋô yêni ya ambô be ya pesang ketheng vo dô ni be nêlêm emba be tem nembong be ya kapôlông injap.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Me Anômbêng henang nena, “Umbua auk ethak jas kambom iti ya ambô. ");
INSERT INTO ymp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bêng yom Wapômbêng tem nendaŋô ya avîlanô takatu be bôk hîtôk loho yôv ining athêng atu be eleng êndêng bîlîvông be lêkwak be nepesang mesa mî? Me tem nendaŋô long vambô mesa? Mî anông! ");
INSERT INTO ymp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ya hanang avanông bing nena tem nendaŋô ketheng be nepesang. Metom wakma Anô Ya Nakandung atu hele hêlêm pîk hethak loŋbô, êng me tem ninjê nena avîlanô êv iving doho îmô mesa mî?” ");
INSERT INTO ymp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Me Yisu henang ambô dôhô te hêndêng avîlanô takatu be êyê i hîtôm avîlanô thêthôp me avîlanô viyang mî. Êng me Yisu henang nena, ");
INSERT INTO ymp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Anô yi ê melak matheng vo eteng mek. Anô yang me Palisi me yang me anô hiwa takis. ");
INSERT INTO ymp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Palisi êng da heva be heteng mek bêŋiti nena, ‘Wapômbêng, mavî anông vo ya anô mavî me ya mî hîtôm anô vi amî. Loho me ŋa vanî lêk ŋa kambom lêk ŋa evong sek mayaliv. Metom ya mî anông, me ya mî hîtôm anô hiwa takis iti amî. ");
INSERT INTO ymp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sonda te ya wak yi me thak ya hatip ethak nôm. Me nômkama nômbêng atu be ya hauwa me thak ya havanî tham hê ondong lauming be ya hêv ondong te hêndêng ong.’ ");
INSERT INTO ymp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Metom anô hiwa takis heva dêim me moma be hêkô vo ninjê leng. Me hikum be hetak bang luvi hêk mandaluk thing me henang nena, ‘Wapômbêng, ya anô kombom kambom be nôŋgêv kapôlôm vo ya.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Êng me Yisu henang nena, “Ya hanang ethak môlô nena, anô hiwa takis hîvô hê ya melak me lêk hivutak anô thêthôp hêk Wapômbêng mandaluk. Metom anô yang êng me mî. Ôpatu be hêv ya athêng ling me Wapômbêng tem netaving ya athêng. Metom ôpatu be hetaving i me tem Wapômbêng êŋgêv ya athêng ling.” ");
INSERT INTO ymp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Avîlanô iwa ining sêiknena ê hêndêng Yisu vo netak bang êyônjêk loho. Me ya ŋa hîndông êyê be ethang loho. ");
INSERT INTO ymp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Metom Yisu helam sêiknena takatu êlêm me henang nena, “Otak sêiknena vo êlêm êndêng ya me dô omba long thing andô, vômbê nena avîlanô takatu be athêng mî hîtôm sêiknena takiti me Wapômbêng ya lêkliŋyak bêng me loho ning. ");
INSERT INTO ymp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya hanang avanông ethak môlô nena, ôpatu be mî hiwa Wapômbêng ya lêkliŋyak bêng hîtôm sêiknena amî me mî hîtôm nimbutak êyô long êng kapô bini amî. Mî anông.” ");
INSERT INTO ymp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Avaka te henang ik Yisu ling nena, “Kîdôŋga mavî, tem yambong ômbête vo yambua lêkmala îtôm wak nômbêng iti sapêng?” ");
INSERT INTO ymp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Me Yisu henang viyang êndêng yêni nena, “Bisête be holam nena mavî? Anô te mî mavî amî me Wapômbêng yom ditu mavî. ");
INSERT INTO ymp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ambô balambung me bôk hoyala yôv: ‘Dô nombong sek imbing anô yang yanavî andô. Me dô nuŋgik anô vônô paling andô. Me dô nombong vanî andô. Me dô nonang ambô yôhîng ethak anô vi be nombong ambô vo loho andô. Me nondovak lemambô lo lemtambô ning ambô.’” ");
INSERT INTO ymp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Me avaka êng henang nena, “Waklavông ya yaôna hele be hêyô lêk me thak ya hasopa ambô balambung takêng sapêng.” ");
INSERT INTO ymp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Me Yisu helaŋô be henang ethak ôpêng nena, “Metom ong nômate mî denang. Nu me nôŋgêv yong nômkama sapêng vo avîlanô êŋgêv vuli me numbua valuseleng takêng sapêng be nôŋgêv êndêng ŋa siv. Hovong bêng me tem yong nômkama mavî lomaloma nîmô melak leng. Me nôlêm osopa ya.” ");
INSERT INTO ymp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yêni me anô lêk nômkama bêng anông, be ditu helaŋô ambô êng be hêv malêing bêng hêndêng yêni be hê lêk la malêing. ");
INSERT INTO ymp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yisu hêyê ôpêng la malêing be henang nena, “Ŋa lêk nômkama bêng tem êpôm malêing bêng vo imbutak êyô Wapômbêng ya lêkliŋyak bêng kapô bini. ");
INSERT INTO ymp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Avanông bing nena vumeng vo bok kamel imbutak êyô lôvîk indi kwak ya ambuang bini, metom malêing bêng anông vo anô lêk nômkama bêng te tem nimbutak êyô Wapômbêng ya lêkliŋyak bêng kapô bini.” ");
INSERT INTO ymp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Avîlanô elaŋô ambô êng me enang ik i ling nena, “Bêng be opalê hîtôm nimbua lêkmala wak nômbêng iti sapêng?” ");
INSERT INTO ymp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Me henang nena, “Nôm takatu be anô mî hîtôm embong amî me Wapômbêng yom hîtôm nembong.” ");
INSERT INTO ymp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Me Pita henang nena, “Nondaŋô! Bôk yoôtak yoô ning nômkama sapêng be alêm vo asopa ong.” ");
INSERT INTO ymp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Me Yisu henang ethak loho nena, “Ya hanang avanông bing ethak môlô nena, anô te la hêv Wapômbêng ya lêkliŋyak bêng be hetak ya melak lêk yanavî lêk nali lêk viyaŋi me lambô lo talêmbô be hevong yêni ya ku, ");
INSERT INTO ymp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","êng me waklavông ôpêng hîmô pîk denang me Wapômbêng tem nêŋgêv ya nômkama sapêng êndêng inda, me tem nêŋgêv bêng anông êyômô long imbing, me heveng yam me tem nêŋgêv lêkmala atu be tem nîmô îtôm wak nômbêng iti sapêng êndêng inda imbing.” ");
INSERT INTO ymp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yisu hiwa ya ŋa hîndông lauming be lahavôyi takatu hethak tom me henang nena, “Ondaŋô. Aô na daku Jelusalem vo ambô taksêmbôk be plopet ekavu hethak Anô Ya Nakandung atu tem nimbutak avanông. ");
INSERT INTO ymp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tem êŋgêv yêni îndôk ŋa long bôyang baheŋing. Me tem emalîk ethak inda be enang ambô lomaloma ethak yêni me îsuvapôk ethak inda. ");
INSERT INTO ymp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Me tem embali inda be iŋgik yêni vônô me hêndêng wak ali lô me tem nimbiyô ethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Metom loho mî eyala ambô êng bôte amî. Me ambô êng ya ondong sapêng me hîmô kapô be mî eyala amî me îthông paling. ");
INSERT INTO ymp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yisu hêyô bidong Jeliko me anô mandaluk pusip te hîmô loŋdaŋlê dang be hepetenak avîlanô vo êŋgêv nômkama êndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ôpêng helaŋô avîlanô bêng anông ele me henang ik loho ling nena, “Ômbête hivutak?” ");
INSERT INTO ymp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Me loho nang ethak yêni nena, “Yisu nang Nasalet hêlêm.” ");
INSERT INTO ymp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Êng me anô mandaluk pusip atu helam nena, “Yisu, Devit Lim Lêkmuk, lem iŋgik ong ethak ya!” ");
INSERT INTO ymp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Avîlanô takatu be imung ethang yêni be enang nena, “Ong bonong.” Metom helam lêkwaê nena, “Devit Lim Lêkmuk, lem iŋgik ong ethak ya!” ");
INSERT INTO ymp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Êng me Yisu heva me henang vo lohombua ôpêng êlêm. Ôpêng hêyô me Yisu henang ik inda ling nena, ");
INSERT INTO ymp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Lem hiving yambong ômbête êndêng ong?” Me ôpêng henang viyang nena, “Anômbêng, ya leng hiving yaŋga tak.” ");
INSERT INTO ymp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Me Yisu henang ethak ôpêng nena, “Nôŋgô tak. Yong hôêv iving hevong be lêk huvutak mavî.” ");
INSERT INTO ymp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Me ketheng oyang me ôpêng mandaluk hipuak be hêyê tak. Me yêni hesopa Yisu be hêv Wapômbêng ya athêng ling. Me avîlanô êyê nôm êng me êv Wapômbêng ya athêng ling ethak leng. ");
INSERT INTO ymp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yisu hêyô Jeliko me hê yom. ");
INSERT INTO ymp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Me anô te ya athêng nena Sakius hîmô long êng. Yêni me ŋa hiwa takis ining avaka lêk anô valuseleng bêng. ");
INSERT INTO ymp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yêni la hiving ninjê nena Yisu me opalête, metom avîlanô bêng anông be Sakius me anô bidong be mî hîtôm ninjê Yisu amî. ");
INSERT INTO ymp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Êng me hevothong himung be hê me hethak alokwang pik te be hîmô vo ninjê Yisu vômbê nena te nende long êng bini. ");
INSERT INTO ymp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yisu hêyô long êng me hêyê aling me henang nena, “Sakius, nôndôk be nôlêm ketheng vômbê nena yaô tiêng me tem ya mô yong melak.” ");
INSERT INTO ymp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Êng me ketheng oyang me Sakius hîlôk be hêlêm me hiwa Yisu thô lêk la mavî. ");
INSERT INTO ymp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Me avîlanô sapêng êyê be enang ambô ŋôlôŋôlông nena, “Yêni hê hîmô hiving anô kombom kambom te.” ");
INSERT INTO ymp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yôv me Sakius hiviyô heva melak kapô me henang ethak Anômbêng nena, “Anômbêng, nondaŋô. Tem yambî yînîng nômkama tham ini ondong yi be yaŋgêv yang êndêng ŋa siv. Me bôk ya havatek anô te be ya hauwa ya valuseleng doho vanî, êng me tem yaŋgêv ôpêng ya valuseleng endeni me ya tak bôlôva êyômô long imbing be yaŋgêv êndêng yêni.” ");
INSERT INTO ymp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Me Yisu henang nena, “Lêk ôpiti hêv iving Wapômbêng hîtôm Ablaham, be ditu yêni me Ablaham nakandung te hiving. Bêng be lêk Wapômbêng hiwa avîlanô melak itiêng vê hêk kambom ya vuli. ");
INSERT INTO ymp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Vômbê nena Anô Ya Nakandung atu hêlêm vo nethalo ŋa takatu be êv yak me nimbua loho vê injêk kambom ya vuli.” ");
INSERT INTO ymp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Avîlanô elaŋô ambô êng yôv me Yisu henang ambô dôhô te hiving vômbê nena yêni lêk bidong nêyô Jelusalem. Me avîlanô takêng esong nena yêni hêyô Jelusalem me ketheng oyang me tem Wapômbêng ya lêkliŋyak bêng nimbutak pîk. ");
INSERT INTO ymp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Êng me Yisu henang nena, “Anômbêng te namalô hê vini melak lông bêng te hêk dêimbô vo îtôk inda nimbutak king yôv ketem nîmbôlêm ya melak ondong ethak loŋbô vo neyaŋging ya avîlanô. ");
INSERT INTO ymp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ôpêng hepesang i vo ni me helam ya ŋa ku lauming hethak tom me hêv valuseleng hîtôm kapua lauming hêndêng loho sapêng tomtom. Me henang nena, ‘Môlômbua valuseleng iti be môlômbong ku ethak endebe yambôlêm ethak loŋbô.’ Yôv me hetak loho be hê. ");
INSERT INTO ymp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Metom ya avîlanô da kapôlôŋing êndô yêni. Êng me yêni hê long bôyang me loho êv anô doho be esopa yêni vo enang nena, ‘Yoôndô ôpiti nimbutak îtôm king be neyaŋging yoô.’ ");
INSERT INTO ymp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Metom yêni hivutak king yôv me hîvô lêm me henang nena, ‘Ondam ŋa ku takatu be bôk ya hêv valuseleng hêndêng loho vo ya yala nena loho tomtom bôk êvôv valuseleng vithêla hêyô mô.’ ");
INSERT INTO ymp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Yôv me anô te himung hê me henang nena, ‘Anômbêng, ya havong ku hethak yong valuseleng kapua tom me nakandung lêk hivutak hîtôm buŋdaluk bahevi.’ ");
INSERT INTO ymp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Me ya anômbêng henang nena, ‘Mavî anông! Ong anô ku mavî be hôêv kapôlôm be hovong ku yaôna ti katôyang, be ditu tem noyaŋging melak lông lauming.’ ");
INSERT INTO ymp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Yôv me anô yang hêlêm me henang nena, ‘Anômbêng, yong valuseleng kapua tom me nakandung lêk hivutak hîtôm buŋdaluk yi be lalauming.’ ");
INSERT INTO ymp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Me ya anômbêng henang ethak yêni nena, ‘Tem noyaŋging melak lông bahevi.’ ");
INSERT INTO ymp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Yôv me anô ku ali lô hêlêm me henang nena, ‘Anômbêng, yong valuseleng atu ti. Ya havuliv hîlôk kwak be ya havung hîmô ");
INSERT INTO ymp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","vômbê nena ong me anôŋa be ditu ya hakô ong. Vômbê nena thak huwa anô vi ning valuseleng ya nakandung hîtôm yong. Me kukapô atu be mî hopayiv yaŋvêk hîlôk amî me thak huwa ya anông.’ ");
INSERT INTO ymp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Êng me ya anômbêng henang nena, ‘Ong anô ku kambom be tem yambong ambô vo ong ethak ong da yong ambô honang. Bôk hoyala yôv nena ya anôŋa be ya hauwa anô vi ning valuseleng ya nakandung hîtôm yînîng. Me nôm takatu be mî ya havatho amî me thak ya hauwa ya anông hîtôm yînîng. ");
INSERT INTO ymp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Me bisête be mî hotak yînîng valuseleng hîlôk melak valuseleng vo nêmbôv doho imbing amî, vo wakma atu be ya hale lêm hethak loŋbô me tem yambua doho êyômô long imbing?’ ");
INSERT INTO ymp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Yôv me henang ethak ŋa takatu be eva bidong nena, ‘Môlômbua ya valuseleng kapua te atu vê injêk yêni be ôŋgêv êndêng ôpatu be hêvôv valuseleng buŋdaluk bahevi.’ ");
INSERT INTO ymp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Me loho nang hêndêng yêni nena, ‘Anômbêng, yêni ya valuseleng buŋdaluk bahevi bôk hîmô yôv!’ ");
INSERT INTO ymp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Me yêni henang nena, ‘Ya hanang ethak môlô nena ôpatu be hevong ku mavî hethak yînîng nômkama be hivutak bêng, êng me tem ya tak doho êyômô long imbing be yaŋgêv êndêng ôpêng. Metom ôpatu be mî hevong ku hethak yînîng nômkama amî, êng me doke atu be hevalong me tem yaŋgêv vê injêk inda. ");
INSERT INTO ymp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“‘Metom avîlanô takatu be êyê ya hîtôm ining ŋakyo be êndô yambutak loho ning king, umbua loho lêm long iti me uŋgik loho vônô injêk ya maleng.’” ");
INSERT INTO ymp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisu henang ambô êng yôv me himung be hê daku Jelusalem. ");
INSERT INTO ymp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yisu hêyô bidong Betpagi lêk Betani, melak lông yi êng me hêk bidong dum atu be elam nena Dum Oliv. Me hêv ya ŋa hîndông yi be ê me henang nena, ");
INSERT INTO ymp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mamu nu melak lông vulu. Me umbutak ôyô me tem ôŋgô ekak bokdoŋki map te long be heva. Bok êng me anô te bôk mî hêyô hîmô amî denang. Be mamu pole yak vê me ondom be ôlêm. ");
INSERT INTO ymp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Me anô te henang ik ling nena, ‘Mamu pole vo?’ êng me mamu nang viyang nena, ‘Anômbêng la hiving nembong ku te ethak.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yisu hêv thêi be ê me êyê nômkama sapêng hîtôm datu be henang ethak thêi. ");
INSERT INTO ymp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Thêi pole doŋki êng ya yak vê me alaŋi enang ik thêi ling nena, “Mamu pole doŋki vê vo?” ");
INSERT INTO ymp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Me thêi nang nena, “Anômbêng la hiving nembong ku te thak.” ");
INSERT INTO ymp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yôv me thêi iwa doŋki be ê êv hêndêng Yisu. Me thêi îmbî ning kwêv thilimbung dêim thô be eŋgova hêyô hêk doŋki dômlokwang me êv Yisu livung be hêyô hîmô doŋki êng. ");
INSERT INTO ymp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Me Yisu hê me avîlanô eŋgova ining kwêv thilimbung dêim hêk loŋdaŋlê. ");
INSERT INTO ymp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wakma yêni hêlêm bidong long atu be loŋdaŋlê hîlôk be hê Dum Oliv me avîlanô nômbêng atu be esopa yêni leŋing mavî hethak nôm thamtham takatu be bôk loho yê. Be êv Wapômbêng ya athêng ling be elam kaêk lêkwaê nena, ");
INSERT INTO ymp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Wapômbêng embong mavî êndêng king atu be hêlêm ethak Anômbêng ya athêng! Me lambali îmô melak leng me Wapômbêng ya lêkmaŋging ethak leng anông bing!” ");
INSERT INTO ymp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Metom Palisi doho eva avîlanô takêng lîvông be enang ethak Yisu nena, “Kîdôŋga, nothang yong ŋa hôndông vo loho bonong.” ");
INSERT INTO ymp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Me Yisu henang nena, “Ya hanang ethak môlô nena loho bonong me valu tem êwê loho ning long be endam kaêk be êŋgêv Wapômbêng ya athêng ling.” ");
INSERT INTO ymp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yisu hêyô bidong Jelusalem me hêyê melak lông bêng êng be heleng ethak ");
INSERT INTO ymp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","be henang nena, “Ya leng hiving lêk iti me oyala loŋdaŋlê atu be tem nêŋgêv lambali êndêng môlô. Metom lêk iti me nôm takêng hîmô long kapô be môlô mî hîtôm ôŋgô amî. ");
INSERT INTO ymp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bêng be waklavông te tem nêyô be môlô ning ŋakyo tem êyô be endav wandu endawê môlô ning long be ekalambu môlô thing be imuthing môlô ethak lômlôm. ");
INSERT INTO ymp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Loho tem imbuling môlô ning long sapêng be iŋgik môlô lêk ŋa takatu be îmô môlô kapô vônô. Me valu atu be olav melak hethak me tem mî nêyômô yang long amî. Nôm malêing êng tem nêlêm vômbê nena môlô mî oyala waklavông atu be Wapômbêng hêlêm pîk vo nêŋgêv môlô livung amî.” ");
INSERT INTO ymp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yôvêm me Yisu hêyô melak matheng ya popatîng. Me hêyê avîlanô iwa nômkama be êndô hîmô vo avîlanô vi êŋgêv vuli. Êng me hindining loho be hêv loho vê hêk melak matheng kapô be ele yêing be ê. ");
INSERT INTO ymp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Me henang ethak loho nena, “Wapômbêng ya kapua henang nena, ‘Yînîng melak me melak eteng mek îndôk.’ Me lêk môlôvong be hivutak hîtôm ‘ŋa vanî ning long ambuang ekopak îmô.’” ");
INSERT INTO ymp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Me wak nômbêng iti me Yisu hîndông avîlanô hîlôk melak matheng. Me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung lêk ŋa Juda ning ŋa bêŋbêng ethalo loŋdaŋlê vo iŋgik inda vônô. ");
INSERT INTO ymp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Metom loho mî hîtôm êpôm loŋdaŋlê te amî vômbê nena avîlanô sapêng leŋing mavî bêng vo Yisu be îmô vo endaŋô ya ambô sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wak te me Yisu hîndông avîlanô hîmô melak matheng ya popatîng be henang Wapômbêng ya Ambô Mavî hêndêng loho, êng me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung ethak tom hiving avaka be ê hêndêng Yisu. ");
INSERT INTO ymp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Me loho nang ik inda ling nena, “Nonang ethak yoô, opalê hêv lêklokwang lêk ku hêndêng ong be diti hovong nôm takiti êng?” ");
INSERT INTO ymp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Me Yisu henang hêndêng loho nena, “Tem ya nang iŋgik môlô ling ethak ambô te bêng yom. Onang ethak ya nena ");
INSERT INTO ymp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","opalê hêv ku ithik avîlanô hîlôk ŋanam hêndêng Jon? Wapômbêng leng mesa anô pîk te?” ");
INSERT INTO ymp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Me loho da enang ethak i nena, “Aô nang nena Wapômbêng hêv ku êng hêndêng Jon, êng me tem nenang nena, ‘Me hevong bisê be môlô mî ôêv iving Jon ya ku amî?’ ");
INSERT INTO ymp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Me aô nang nena, ‘Anô pîk te hêv ku êng,’ êng me avîlanô tem îmbî aô ethak valu vômbê nena loho êv iving nena Jon me plopet te.” ");
INSERT INTO ymp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Me loho nang hêndêng Yisu nena, “Yoô thông paling nena opalê hêv ku êng hêndêng Jon.” ");
INSERT INTO ymp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Êng me Yisu henang ethak loho nena, “Bêng yom me mî hîtôm yandam ôpatu be hêv lêklokwang êndêng ya, ya athêng bêng êndêng môlô amî.” ");
INSERT INTO ymp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Me Yisu henang ambô dôhô te hêndêng avîlanô nena, “Anô te hevatho ya kukapô waing te be hêv hêndêng ŋa evong ku valuseleng doho vo eyaŋging me hê hîmô long bôyang vambô. ");
INSERT INTO ymp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Me waklavông yak waing hik anông hêyô me hêv ya anô ku te be hê hêndêng loho vo nimbua ya anông doho, metom loho ik yêni kambom be êv yêni be hê oyang. ");
INSERT INTO ymp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yôv me kukapô ya alang hêv anô ku yang be hê hethak loŋbô hêndêng loho, metom ik yêni hiving be ivuling me êv inda vê be hê bang oyang lêk moma bêng. ");
INSERT INTO ymp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yôv me hêv anô ku ali lô be hê, metom ŋa ku takêng ivuling ôpêng me êvôv inda be îmbî hele kukapô vi yêing be hê. ");
INSERT INTO ymp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Yôv me kukapô alang henang ethak yêni da nena, ‘Tem yambong ômbête? Tem yaŋgêv yînîng wakna atu be ya leng hiving bêng anông. Betha ya havong bêng me tem endaŋô ya ambô.’ ");
INSERT INTO ymp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Metom ŋa ku êyê namalô hêyô me enang ethak i nena, ‘Ôpiti me ku alang nakandung be tem neyaŋging lambô ya kukapô. Aôŋgik yêni vônô me kukapô tiêng tem nimbutak îtôm aô ning.’ ");
INSERT INTO ymp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bêng be ditu evalong yêni be êvôv hele yêing me ik yêni vônô. “Bêng be kukapô ya alang tem nembong ômbête êndêng loho? ");
INSERT INTO ymp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Teni vo niŋgik ŋa ku takêng vônô me nêŋgêv kukapô êng êndêng anô vi vo eyaŋging.” Me avîlanô elaŋô ambô dôhô êng be enang nena, “Yoôndô ambô dôhô êng iŋgik anông!” ");
INSERT INTO ymp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Metom Yisu hêyê loho me henang nena, “Me hevong bisê be bôk ekavu ambô iti be ya ondong bisête? “ ‘Valu atu be ŋa elav melak îpôlîk hethak me lêk hivutak landîng anông.’ ");
INSERT INTO ymp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Me avîlanô takatu be êv yak hêyô hêk valu êng me tem ipup nenanena. Mena valu êng hêv yak hêyô hêk anô te me ôpêng tem nipilisik.” ");
INSERT INTO ymp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung eyala nena Yisu henang ambô dôhô êng hethak loho. Be ditu evong vo ethalo loŋdaŋlê te vo embalong yêni ketheng oyang, metom êkô avîlanô. ");
INSERT INTO ymp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yôv me ŋa bêŋbêng maleŋing hendahalîng Yisu lêklokwang vo embalong yêni ethak ya ambô. Be ditu loho êv ŋa kambom doho vuli vo imbutak îtôm ŋa thêthôp vo embatek Yisu. Be loho yek Yisu vo embalong yêni be êŋgêv êndêng Lom ining gavana Pailat. ");
INSERT INTO ymp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Êng me loho enang hêndêng Yisu nena, “Kîdôŋga, yoô ayala nena yong ambô sapêng me ambô avanông yom. Me hovong kombom tom hêndêng avîlanô sapêng viyang dong lêk hôndông avîlanô hethak Wapômbêng ya ambô anông thêthôp yom. ");
INSERT INTO ymp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bêng be lem hêv bisê? Mavî vo yoôŋgêv takis êndêng Sisa mesa dô?” ");
INSERT INTO ymp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yisu heyala loho ning ambô yôhîng êng be henang ethak loho nena, ");
INSERT INTO ymp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Môlôŋgik valuseleng te thô vo yaŋga. Opalê ya dôhô lêk athêng hêyô hêk valuseleng iti?” Me loho nang viyang nena, “Sisa.” ");
INSERT INTO ymp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yôv me Yisu henang ethak loho nena, “Sisa ya nômkama me ôŋgêv êndêng Sisa da. Me Wapômbêng ya nômkama me ôŋgêv êndêng Wapômbêng da.” ");
INSERT INTO ymp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Me ŋa êng esong kambom hethak ya ambô henang be loho bonong. Be ditu mî hîtôm embatek Yisu ethak ya ambô te îndôk avîlanô maleŋing amî. ");
INSERT INTO ymp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Me Sadyusi doho ê hêndêng Yisu. Loho me ondong te atu be enang nena ŋa ema tem mî hîtôm imbiyô ethak loŋbô amî. ");
INSERT INTO ymp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Be ditu enang ik Yisu ling nena, “Kîdôŋga, Moses bôk hekavu hêndêng aô nena, ‘Anô te hema be nali mî me yang hîmô, êng me nimbua avî tôp êng vo nîmbî yang atu be hema nakandung vê.’ ");
INSERT INTO ymp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yôv be ŋa lêk viyaŋi bahevi be lahavôyi îmô. Be bôp hiwa avî te be hema me nakandung mî. ");
INSERT INTO ymp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Êng me nok hiwa avî tôp êng, metom nok hema hiving be nakandung mî. ");
INSERT INTO ymp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Me gwa hevong bêng yom. Me viyaŋi takatu be îmô me esopa kombom tomêng yom, metom loho sapêng sêik mî me ema bêng yom. ");
INSERT INTO ymp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yôvêm me avî tôp êng hema hiving. ");
INSERT INTO ymp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bêng be waklavông ŋa ema iviyô hethak loŋbô, me ŋa lêk viyaŋi bahevi be lahavôyi takatu be avî tôp atu hiwa, loho alialê tem nimbutak îtôm yamalô?” ");
INSERT INTO ymp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Me Yisu henang hêndêng loho nena, “Avîlanô bôlôti thak iwa i, ");
INSERT INTO ymp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","metom avîlanô takatu be Wapômbêng henang nena loho hîtôm imbiyô ethak loŋbô be imbua lêkmala heveng yam, ŋa takêng mî hîtôm imbua i ethak loŋbô amî. ");
INSERT INTO ymp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Loho tem mî ema ethak loŋbô amî vômbê nena loho mô hîtôm aŋêla. Loho mô hîtôm Wapômbêng nali vômbê nena loho tak ŋama be iviyô hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Moses da ya ambô hik thô nena ŋa ema tem imbiyô ethak loŋbô. Sêmbôk be Moses hêyê amela hethang hîmô alokwang ling me helam Anômbêng nena ‘Ablaham lo Aisak me Jekop ining Wapômbêng.’ ");
INSERT INTO ymp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Aô yala nena Wapômbêng me mî ŋa ema ning Wapômbêng amî. Mî, yêni me ŋa lêkmala yom ining Wapômbêng vômbê nena yêni mandaluk me avîlanô sapêng îmô lêkmala.” ");
INSERT INTO ymp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kîdôŋga balambung doho elaŋô ambô êng be enang ethak Yisu nena, “Kîdôŋga, yong ambô me mavî anông!” ");
INSERT INTO ymp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Loho nang bêng vômbê nena loho kô be mî hîtôm enang iŋgik yêni ling vo embatek inda ethak loŋbô amî. ");
INSERT INTO ymp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yôv me Yisu henang ethak loho nena, “Hevong bisê be avîlanô thak enang nena Mesaya me Devit lim lêkmuk? ");
INSERT INTO ymp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Hêk Kapua Yeng kapô me Devit da henang nena, “ ‘Anômbêng Wapômbêng henang ethak yînîng Anômbêng Mesaya nena, “Nôndôk ômô ya baheng viyôhôk ");
INSERT INTO ymp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","endebe ya tak yong ŋakyo îmô vemkapô vimbing êm.” ’ ");
INSERT INTO ymp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Me Devit da bôk helam Mesaya nena Anômbêng. Metom hevong bisê be ôpêng me Devit lim hiving?” ");
INSERT INTO ymp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Avîlanô elaŋô Yisu ya ambô denang me henang ethak ya ŋa hîndông nena, ");
INSERT INTO ymp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Môlô yaŋging am vo kîdôŋga ambô balambung. Loho leŋing iving iŋgik kwêv dêim kêkêlô be embeng vo avîlanô embam loho. Me leŋing iving avîlanô enang nena, ‘Waklîvông mavî anômbêng’ îmô long thak ethak tom hîlôk. Me leŋing iving îmô îtôm ŋa bêŋbêng îmô melak yeng kapô. Me waklavông avîlanô eŋgambôm nôm bêng me leŋing iving injang nôm îmô ŋa bêŋbêng ining long thak îmô. ");
INSERT INTO ymp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Me loho thak evatek avî tôp vo iwa ning melak. Me thak eteng mek dêim bomang vo avîlanô injê be esong nena loho me ŋa thêthôp. Wapômbêng tem nêŋgêv malêing bêng anông îmbô ethak êndêng loho vo avîlanô vi.” ");
INSERT INTO ymp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisu hîmô melak matheng denang me hêyê ŋa lêk nômkama bêng anông etak ining valuseleng hîlôk kambum da. ");
INSERT INTO ymp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Me avî tôp te atu be nômkama mî anông hêyô me hetak ya da valuseleng lêkma yi yom hîlôk kambum da êng. ");
INSERT INTO ymp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yisu hêyê me henang nena, “Ya hanang avanông bing ethak môlô nena avî tôp iti me alitak metom hêv ya valuseleng bêng anông hîvô hethak vo avîlanô takiti sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Avîlanô nômbêng iti ining valuseleng bêng anông hîmô metom êv doke yom. Metom avî tôp iti me nômkama mî anông be lêk hêv ya valuseleng sapêng me mî hevalong doho long amî.” ");
INSERT INTO ymp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yisu ya ŋa hîndông doho enang ambô hethak valu kêkêlô lêk nômkama leŋing mavî atu be avîlanô êv hêndêng Wapômbêng hîtôm da be etak hethak melak matheng vo ya leleyang mavî anông. Êng me Yisu henang nena, ");
INSERT INTO ymp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nôm takiti be lêk môlô yê, malêing bêng tem nimbutak be ŋa vovak tem iŋgik nômkama mavî nômbêng iti pesa be valu yang mî hîtôm nêyômô yang long amî.” ");
INSERT INTO ymp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Me loho nang ik Yisu ling nena, “Kîdôŋga, aŋgête me nôm takêng tem nimbutak? Me lavuning alê ditu tem nimbutak vo niŋgik thô nena nôm takêng lêk bidong vo nimbutak?” ");
INSERT INTO ymp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Me Yisu henang nena, “Oyaŋging am vo avîlanô dô embatek môlô andô. Ŋa lomaloma tem êlêm ethak yînîng athêng be enang nena, ‘Ya Mesaya atu.’ Lêk tem enang nena, ‘Wakma pîk lo leng yandang lêk bidong.’ Metom dô osopa loho andô! ");
INSERT INTO ymp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hêndêng wakma môlô laŋô nena vovak bêng be avîlanô pîk ik i vônô, êng me dô môlô kô andô. Nôm takêng tem nimbutak imung, metom pîk lo leng yandang tem mî nimbutak ketheng oyang amî.” ");
INSERT INTO ymp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yôv me Yisu henang nena, “Avîlanô ondong yang tem embong vovak imbing ondong yang. Me king yang lêk ya avîlanô tem embong vovak imbing king yang lêk ya avîlanô. ");
INSERT INTO ymp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Me long doho me tem duviyang bêng lêk bôm bêng me kômbôk bêng tem nêyô be niŋgik avîlanô bêng anông vônô. Nôm thamtham lêk lavuning lomaloma tem nimbutak leng lîvông be nembong avîlanô êkô kambom anông. ");
INSERT INTO ymp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Me nôm takêng tem mî nimbutak amî denang me tem embalong môlô be embong kambom ethak môlô. Be imbua môlô ni yô melak yeng vo embong ambô yôv me etak môlô îndôk kalaondong. Vômbê nena môlô sopa ya be ditu tem imbua môlô bini vo omba king lêk ining ŋa bêŋbêng maleŋing. ");
INSERT INTO ymp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Me nôm êng tem nimbutak îtôm loŋdaŋlê vo môlô nang yînîng Ambô Mavî bêng ethak loho. ");
INSERT INTO ymp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Metom dô ombak auk te injêk kapôlômim yôvêm nena tem onang bisê êndêng loho andô ");
INSERT INTO ymp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vômbê nena ya da tem yaŋgêv ambô lêk auk mavî êndêng môlô. Be ditu ŋa takatu be evong ambô vo môlô me mî hîtôm enang môlô ning ambô viyang mena iŋgik ambô êng pesa amî. ");
INSERT INTO ymp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Me lemami lo lemtami lêk aviyami lêk môlô ning lêkma lêk môlô ning ŋa môlôô tem etak môlô îndôk ŋakyo baheŋing be iŋgik môlô doho vônô. ");
INSERT INTO ymp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Avîlanô sapêng tem kapôlôŋing êndô môlô vômbê nena môlô sopa ya. ");
INSERT INTO ymp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Metom Wapômbêng tem neyaŋging môlô wak nômbêng iti be lumim kwandôk ŋaung te tem mî hîtôm nêŋgêv yak amî. ");
INSERT INTO ymp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bêng be môlômba lêklokwang me tem umbua lêkmala îtôm wak nômbêng iti sapêng.” ");
INSERT INTO ymp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Me Yisu henang nena, “Môlô yê nena ŋa vovak êyô be ekalambu Jelusalem, êng me môlôyala nena lêk bidong oyang vo imbuling melak lông êng kambom. ");
INSERT INTO ymp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bêng be môlô ŋa takatu be ômô Judia kapô me ôsôv bunu dum lôlêlôlê. Me môlô ŋa takatu be ômô Jelusalem kapô me nu vi yêing ketheng. Me môlô ŋa takatu be ômô Jelusalem vi yêing me dô unu kapô andô. ");
INSERT INTO ymp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Vômbê nena waklavông takêng me Wapômbêng ya wakma tem nêŋgêv vuli kambom êndêng avîlanô Jelusalem. Be ditu ambô taksêmbôk be bôk ekavu hêk Wapômbêng ya kapua tem niŋgik anông. ");
INSERT INTO ymp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Titaknena avî takatu be ethambeng lêk êv sum hêndêng ining sêik hêndêng waklavông takêng, vômbê nena malêing lêk vovang bêng tem nimbutak pîk iti be Wapômbêng ya la maning tem nêyômô avîlanô takêng. ");
INSERT INTO ymp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ŋa vovak tem ini Jelusalem be iŋgik avîlanô takêng bêng anông vônô ethak bîng vovak. Me tem imbua avîlanô Jelusalem bini êndô îmô pîk luvuluvu. Me avîlanô long bôyang tem êyô îmô Jelusalem be eyaŋging long êng endebe ŋa long bôyang ining waklavông yandang êm.” ");
INSERT INTO ymp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Me lavuning tem nimbutak injêk wak lêk ayông be môtôp. Me mamik budum tem niŋgik be pôk lêkwaê bomang be avîlanô pîk sapêng tem endaŋô be êkô kambom anông be ining auk teni mayaliv. ");
INSERT INTO ymp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Me nôm takatu be hîmô leng tem endowaling be avîlanô tem êkô be maleŋing endeyang be emayak ethak malêing bêng atu be tem nimbutak pîk. ");
INSERT INTO ymp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Hêndêng wak êng me tem lohonjê Anô Ya Nakandung atu tem nêlêm imbing mavông be nêlêm imbing ya lêklokwang lêk ya danda lêkmaŋging. ");
INSERT INTO ymp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nômkama takêng hevong vo nimbutak me omba be ôŋgêv malemim ling ethak leng, vômbê nena waklavông Wapômbêng nimbua môlô vê injêk môlô ning malêing lêk bidong oyang.” ");
INSERT INTO ymp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Me Yisu henang ambô dôhô te hethak loho nena, “Môlô lemim êŋgêv waklavông alokwang pik lêk alokwang vi imbing. ");
INSERT INTO ymp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Môlô yê nena alokwang takiti hîmbî ŋaung belap, êng me môlôyala nena wak mavî lêk bidong. ");
INSERT INTO ymp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Me bêng yom môlô yê nôm takêng hivutak, êng me oyala nena Wapômbêng ya lêkliŋyak bêng lêk hêlêm bidong oyang. ");
INSERT INTO ymp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ya hanang avanông ethak môlô nena, avîlanô bôlô tiêng tem mî ema amî denang me nôm takiti sapêng tem nimbutak. ");
INSERT INTO ymp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Pîk lo leng tem nêŋgêv yak bini, metom yînîng ambô bôte mî hîtôm nêŋgêv yak amî. ");
INSERT INTO ymp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Me môlô yaŋging am vo dô kapôlômim malêing hethak nômkama pîk andô. Endekeme môlômbong pîk ya kombom be unum waing be ondomolo be lemim iŋgik am hethak nômkama pîk, êng me wakma êng tem nimbua môlô ketheng îtôm andêk be tem ôpîndîk kambom. ");
INSERT INTO ymp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Avanông, wakma êng me tem nêpôm avîlanô îmô pîk iti sapêng. ");
INSERT INTO ymp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bêng be wak nômbêng iti me môlô yaŋging am katôyang be oteng mek vo Wapômbêng êŋgêv môlô livung be omba lêklokwang vo nôm takiti dô nimbuling môlô andô. Êng me môlô hîtôm omba Anô Ya Nakandung atu mandaluk.” ");
INSERT INTO ymp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Wak nômbêng iti me Yisu hîndông avîlanô hîmô melak matheng ya popatîng. Bîlîvông me hethak be hê Dum Oliv vo hêk. ");
INSERT INTO ymp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Me lêkbôk momaŋaning me avîlanô sapêng thak ê melak matheng ya popatîng vo elaŋô ya ambô. ");
INSERT INTO ymp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Waklavông Eyang Polom Yis Mî atu me sonda te ya wak ali mung ditu elam nena Hêv Lîlîng lêk bidong. ");
INSERT INTO ymp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung ethalo loŋdaŋlê te vo embalong Yisu be iŋgik vônô metom loho kô avîlanô. ");
INSERT INTO ymp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Me Sakdang hîlôk Judas ôpatu be elam nena Iskaliot la. Yêni me Yisu ya ŋa hîndông lauming be lahavôyi takatu te. ");
INSERT INTO ymp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yêni hê me hevak ambô hiving ŋa bêŋbêng îmbôk da lêk melak matheng ining kwak bidong vo netak Yisu îndôk loho baheŋing bisête. ");
INSERT INTO ymp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ŋa êng leŋing mavî me loho evak ambô vo êŋgêv valuseleng êndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Êng me Judas hîlôk hethak loho ning ambô be hethalo loŋdaŋlê vo netak Yisu îndôk loho baheŋing êndêng wak te atu be avîlanô mî îmô hiving inda amî. ");
INSERT INTO ymp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Waklavông Eyang Polom Yis Mî hêyô. Wak êng me melak kapô tomtom thak ik boksipsip nakandung te vo leŋing êv Waklavông Hêv Lîlîng. ");
INSERT INTO ymp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yôv me Yisu hêv Pita lo Jon be ê me henang nena, “Mamu nu vo opesang nôm Waklavông Hêv Lîlîng vo aôŋgang.” ");
INSERT INTO ymp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Me thêi nang ik Yisu ling nena, “Tem yêi pôpêk nôm îmô êsête?” ");
INSERT INTO ymp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Me Yisu henang ethak thêi nena, “Ondaŋô. Mamu nu melak lông kapô me tem ôpôm anô te be hiwa ŋanam lêk wîng. Me osopa yêni be umbutak ôyô melak atu be yêni hêyô be hê. ");
INSERT INTO ymp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Me mamu nang ethak melak ya alang nena, ‘Kîdôŋga henang ik ong ling nena melak kapô vathi atu tem yaŋgang nôm Waklavông Hêv Lîlîng imbing yînîng ŋa ya handông hîmô êsê?’ ");
INSERT INTO ymp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Êng me tem niŋgik melak kapô bêng te atu be hêk daku viling thô êndêng mamu. Melak kapô êng me nômkama sapêng bôk hîmô yôv. Be ditu mamu pesang nôm îmô long êng.” ");
INSERT INTO ymp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yôv me thêi ê me êyê nômkama sapêng hîtôm datu be henang. Êng me thêi pesang Waklavông Hêv Lîlîng ya nôm. ");
INSERT INTO ymp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wakma injang nôm hêyô me Yisu lêk ya aposol îlôk îmô balê injang nôm. ");
INSERT INTO ymp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Me henang ethak loho nena, “Ya leng hiving anông vo yaŋgang nôm Waklavông Hêv Lîlîng iti imbing môlô yôv kîmîng yambua vovang. ");
INSERT INTO ymp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ya hanang avanông ethak môlô nena tem mî yaŋgang nôm iti ethak loŋbô amî endebe Waklavông Hêv Lîlîng niŋgik anông injêk Wapômbêng ya lêkliŋyak bêng kapô êm.” ");
INSERT INTO ymp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Me yêni hiwa waing lêk keyek me henang la mavî yôv me henang nena, “Umbua be unum doke doke. ");
INSERT INTO ymp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ya hanang ethak môlô nena tem mî hîtôm ya num waing ethak loŋbô amî endebe Wapômbêng ya lêkliŋyak bêng êlêm êm.” ");
INSERT INTO ymp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Me yêni hiwa polom te me henang la mavî yôv me hekavli be hêv hêndêng loho me henang nena, “Diti me yînîng vathiap atu be ya hêv hîtôm da vo nêŋgêv môlô livung. Môlômbong bêng me lemim êŋgêv ya.” ");
INSERT INTO ymp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Eyang yôvêm me hevong bêng hethak keyek waing te be henang nena, “Keyek iti me tava lêkmuk atu be ya hapatôk hethak yînîng lêkma atu be tem yaŋgathô hîtôm da vo nêŋgêv môlô livung. ");
INSERT INTO ymp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Metom ondaŋô. Ôpatu be tem netak ya îndôk yînîng ŋakyo baheŋing bang diti hîmô hiving ya hîmô balê. ");
INSERT INTO ymp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Anô Ya Nakandung atu tem nembong îtôm sêmbôk be Wapômbêng bôk henang yôv. Metom alitakna, malêing bêng vo ôpatu be tem netak yêni îndôk ŋakyo baheŋing.” ");
INSERT INTO ymp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ya ŋa hîndông elaŋô ambô êng me loho da enang ik i ling nena, “Opalête tem nembong nôm êng?” ");
INSERT INTO ymp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yôv me loho îkôki hiving ethak loho ali alête tem nimbutak anômbêng vo loho vi. ");
INSERT INTO ymp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Êng me Yisu henang ethak loho nena, “Avîlanô pîk ining king thak embam i be êv malêing vo ŋa takatu be îmô loho vimbing. Me ŋa lêk athêng leŋing iving avîlanô embam loho nena ‘Ŋa wapôm mavî.’ ");
INSERT INTO ymp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Metom dô môlômbong bêng andô. Môlô ning anô lêk athêng me nembong îtôm anô athêng mî. Me môlô ning anômbêng me nembong ku îtôm anô ku oyang. ");
INSERT INTO ymp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Opalête me bêng vo anô vi? Ôpatu be hîlôk hîmô be heyang nôm mesa ôpatu be hepesang nôm? Ôpatu be hîlôk hîmô be heyang nôm, bêng e? Metom ya hamô môlô lîvông hîtôm anô ku oyang te vo yaŋgêv môlô livung. ");
INSERT INTO ymp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Môlô takatu be malêing lomaloma hivutak ya metom mî môlô tak ya amî me ômô hiving ya denang. ");
INSERT INTO ymp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Ya hêv lêkliŋyak bêng hêndêng môlô hîtôm Wakamik bôk hêv lêkliŋyak bêng hêndêng ya vo tem oŋgwang be unum imbing ya îmô balê îmô yînîng lêkliŋyak bêng kapô. Me môlô tem oyaŋging avîlanô Islael ondong lauming be lahavôyi takatu.” ");
INSERT INTO ymp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Me Yisu henang nena, “Saimon, Saimon, nondaŋô. Sakdang henang ik Wapômbêng ling vo neyek môlô îtôm lovak hiyuv iyokla vo limbalôm êŋgêv yak. ");
INSERT INTO ymp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Metom lêk ya hateng mek yôv vo ong Saimon, vo yong hôêv iving dô nêŋgêv yak andô. Be wakma hole ong lîlîng be hôvô lêm ethak loŋbô, êng me nombatho aviyami long.” ");
INSERT INTO ymp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Metom Pita henang nena, “Anômbêng, lêk ya hapôpêk ya yôv vo yana kalaondong imbing ong be ya ma imbing ong.” ");
INSERT INTO ymp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Metom Yisu henang nena, “Pita, ya hanang ethak ong nena yaô bîlîvông tale mî heleng amî denang me tem nonang îtôm bôlô lô nena hôthông ya paling.” ");
INSERT INTO ymp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yôv me Yisu henang ethak loho nena, “Bôk ya hêv môlô be ô me mî uwa vak valuseleng lêk vak bethap lêk vemimkapô bokgôp hiving môlô amî. Metom wak êng me môlô nômate mî mesa?” Me loho nang nena, “Mî, hîtôm.” ");
INSERT INTO ymp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Me Yisu henang ethak loho nena, “Metom lêk yong vak valuseleng lêk vak bethap hîmô me numbua. Me ong bîng vovak mî, êng me nôŋgêv yong kwêv thilimbung vo êŋgêv vuli me numbua valuseleng êng be nôŋgêv bîng vovak vuli ethak. ");
INSERT INTO ymp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ya hanang ethak môlô nena ambô êng tem niŋgik anông ethak ya lêk nômkama takatu be enang hethak ya me sapêng ya dang lêk bidong. Vômbê nena Wapômbêng ya kapua henang nena, ‘Loho tem injê yêni îtôm ŋa takatu be thak mî esopa balambung te amî.’” ");
INSERT INTO ymp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Me ya ŋa hîndông enang nena, “Anômbêng, nôŋgô yoô ning bîng vovak lokwaŋyi ti.” Me Yisu henang ethak loho nena, “Lêk yôv.” ");
INSERT INTO ymp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yisu hetak Jelusalem me hê Dum Oliv hîtôm thak hevong me ya ŋa hîndông ê hiving yêni. ");
INSERT INTO ymp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Yisu hêyô long êng me henang ethak loho nena, “Oteng mek vo dô ôŋgêv yak îndôk nôm takatu be tem neyek môlô andô.” ");
INSERT INTO ymp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Me hetak loho be hê dêim doke. Me heya vabudum thîvô me heteng mek bêŋiti, ");
INSERT INTO ymp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Wakamik, lem tom vo nôŋgêv keyek iti vê injêk ya, êng me nôŋgêv vê. Metom dô nosopa ya leng hiving andô. Mî, nosopa ong da yong lem hiving.” ");
INSERT INTO ymp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Me aŋêla te nang leng hêyô vo yêni me hevatho yêni long. ");
INSERT INTO ymp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yisu kapô malêing kambom be heteng mek lêklokwang anông be vovanîk hetekhetek hîlôk pîk hîtôm lêkma. ");
INSERT INTO ymp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Heteng mek yôv me hiviyô heva be hê hêndêng ya ŋa hîndông me hêyê loho êkthôm vômbê nena loho kapôlôŋing malêing kambom. ");
INSERT INTO ymp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Me henang ethak loho nena, “Môlô ôêkthôm vo? Môlômbiyô be oteng mek vo dô ôŋgêv yak îndôk nôm takatu be tem neyek môlô andô.” ");
INSERT INTO ymp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yisu henang ambô denang me anô bêng anông êyô. Ôpatu be elam nena Judas, yêni me ŋa hîndông lauming be lahavôyi takatu te, ditu helom loho be hêlêm. Yêni hêyô bidong Yisu vo niŋgu inda, ");
INSERT INTO ymp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","metom Yisu henang ik yêni ling nena, “Judas, hovong vo nuŋgu Anô Ya Nakandung atu be vo notak îndôk ya ŋakyo baheŋing mesa?” ");
INSERT INTO ymp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Êng me ya ŋa hîndông eyala nôm atu be tem nimbutak be ditu enang nena, “Anômbêng, tem yoôŋgik loho ethak bîng vovak mesa?” ");
INSERT INTO ymp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Êng me loho ning anô te hele kwandôk bêng hîmbôk da ya anô ku te limbuk viyôhôk thô. ");
INSERT INTO ymp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Metom Yisu hêyê nôm êng be henang nena, “Dô!” Me hetak bang hêyô hêk ôpêng limbuk me hivutak mavî hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yôv me Yisu henang ethak ŋa bêŋbêng îmbôk da lêk melak matheng ya kwak bidong lêk avaka takatu be êlêm vo embalong yêni nena, “Betha ya anô kambom anông te be ditu môlô uwa bîng vovak lêk olo be ôlêm vo ombalong ya e? ");
INSERT INTO ymp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wak nômbêng iti me ya hamô melak matheng ya popatîng hiving môlô me mî ovalong ya amî vo? Metom lêk me momaŋaning heyaŋging pîk be ditu môlô ning wakma.” ");
INSERT INTO ymp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Me evalong Yisu be iwa be ê êyô vo kwandôk bêng hîmbôk da ya melak. Me Pita hesopa heveng yam metom heveng dêim doke. ");
INSERT INTO ymp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Anô doho embang amela hîmô melak êng ya bandêng kapô me Pita hê hîlôk hîmô lîvông hiving loho. ");
INSERT INTO ymp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita hîmô amela danda me avî ku te hêyê yêni katô be henang nena, “Anô ti me thak hîmô hiving Yisu.” ");
INSERT INTO ymp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Metom Pita henang nena, “Avî, ya hathông ôpêng paling.” ");
INSERT INTO ymp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Vauyaŋna me anô yang hêyê yêni me henang nena, “Ong me ŋa takatu ning anô te.” Metom Pita henang nena, “Anô, ya mî anông.” ");
INSERT INTO ymp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yêni hîmô hîtôm wakma te ma me anô yang henang lêklokwang hethak loŋbô nena, “Avanông bing, yêni me anô Galili te. Be ditu yêni me Yisu ya anô te hiving.” ");
INSERT INTO ymp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Me Pita henang nena, “Anô, ya hathông yong ambô paling!” Pita henang bêng denang me tale heleng. ");
INSERT INTO ymp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Me Anômbêng hik i lîlîng be hêyê Pita me Pita la hêv Anômbêng ya ambô atu be henang nena, “Tale mî heleng amî denang me tem nonang îtôm bôlô lô nena hôthông ya paling.” ");
INSERT INTO ymp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yôv me Pita hele yêing be heleng kambom anông. ");
INSERT INTO ymp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ŋa takatu be evalong Yisu enang ambôma hethak inda be ik yêni. ");
INSERT INTO ymp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Loho ivuliv thohav lo ma thing be enang ik yêni ling lômbôlông nena, “Ong plopet te, êng me nonang nena opalê diti hik ong.” ");
INSERT INTO ymp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Me enang ambô kambom lomaloma hethak yêni hiving. ");
INSERT INTO ymp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hiviyô heyang me ŋa Juda ning avaka sapêng ethak tom. Loho me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung. Loho iwa Yisu be ê vo ning ŋa elaŋô ambô vo enang ik yêni ling nena, ");
INSERT INTO ymp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nonang ethak yoô nena ong Mesaya e?” Me Yisu henang ethak loho nena, “Ya hanang ambô êng êndêng môlô me tem môlô mî hîtôm ôŋgêv imbing amî. ");
INSERT INTO ymp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Me ya nang iŋgik môlô ling me tem mî môlô nang viyang amî. ");
INSERT INTO ymp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Metom lêk me Anô Ya Nakandung atu tem nêyômô Wapômbêng lêkmaŋgok bang viyôhôk îtôm wak nômbêng iti sapêng.” ");
INSERT INTO ymp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Me loho sapêng enang ik yêni ling nena, “Bêng be ong da me Wapômbêng Nakandung mesa?” Me Yisu henang ethak loho nena, “Ambô êng me thêthôp hîtôm ditu onang.” ");
INSERT INTO ymp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yôv me loho nang nena, “Bisête be aô leŋing iving andaŋô ambô doho imbing? Lêk henang yêni da bêng hele ambôlêk be aô laŋô yôv.” ");
INSERT INTO ymp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Me ŋa takatu iviyô me iwa Yisu be ê vo Pailat. ");
INSERT INTO ymp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yôv me îmbî ambô hethak yêni nena, “Yoô tung ôpiti henang ethak yoô ning avîlanô vo ende dômîm lîlîng êndêng gakmang. Yêni hêndô yoôŋgêv takis êndêng Sisa lêk henang nena yêni me Mesaya, king te.” ");
INSERT INTO ymp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Me Pailat henang ik Yisu ling nena, “Ong me ŋa Juda ning king mesa?” Me Yisu henang nena, “Hîtôm ditu ong da honang.” ");
INSERT INTO ymp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yôv me Pailat henang ethak ŋa bêŋbêng îmbôk da lêk avîlanô nômbêng atu nena, “Mî ya hatung yêni ya kambom te amî.” ");
INSERT INTO ymp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Metom enang lêklokwang nena, “Yêni hîndông avîlanô be helela ining auk heveng Judia sapêng. Muŋdaluk hêk Galili me hêlêm hele be hêyô long iti.” ");
INSERT INTO ymp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat helaŋô ambô êng me henang ik loho ling nena, “Ôpêng me anô Galili te e?” ");
INSERT INTO ymp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pailat helaŋô nena Yisu hêlêm nang Galili, êng me hêv yêni be hê vo Helot vômbê nena yêni heyaŋging long êng. Wak êng me Helot hîmô Jelusalem hiving. ");
INSERT INTO ymp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Me Helot hêyê Yisu be la mavî anông vômbê nena bôk helaŋô kôkôthing hethak Yisu be la hiving ninjê yêni, metom mî hele be lêk hêyê yêni be ditu la hiving nembong nôm thamtham te vo ninjê. ");
INSERT INTO ymp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Be ditu Helot henang ik Yisu ling bêng anông metom yêni bonong yom. ");
INSERT INTO ymp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Me ŋa bêŋbêng îmbôk da lêk kîdôŋga ambô balambung takatu be eva long êng enang ambô lêklokwang be îmbî yêni hethak ambô lomaloma. ");
INSERT INTO ymp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Êng me Helot lêk ya ŋa vovak iwa kwêv dêim te hîtôm king ining kwêv be ik hîlôk Yisu me enang ambôma be emalîk ethak yêni. Yôvêm me Helot hêv yêni be hê vo Pailat hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sêmbôk me Helot lo Pailat êyê i hîtôm ŋakyo, metom lêk me thêi ivutak ŋa môlôô. ");
INSERT INTO ymp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yôv me Pailat helam ŋa bêŋbêng îmbôk da lêk ŋa Juda ning avaka lêk avîlanô doho be êlêm ethak tom. ");
INSERT INTO ymp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Me henang nena, “Môlô wa anô ti hêlêm hêndêng ya me môlô nang nena anô ti henang ambô yôhîng be hêvôv avîlanô vo êndô gakmang. Be lêk ya hanang ik yêni ling heva môlô malemim hethak nôm takêng, metom mî ya hatung ôpiti ya kambom takatu be môlô nang yêni bêng ethak amî. ");
INSERT INTO ymp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Me Helot ya auk me bêng yom, be ditu hêv ôpiti hêlêm vo aô hethak loŋbô. Ondaŋô. Ôpiti mî hevong kambom te be tem ya nang vo iŋgik yêni vônô amî. ");
INSERT INTO ymp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Be ditu tem yambali yêni yôvêm me ya tak inda bini.” ");
INSERT INTO ymp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Metom avîlanô sapêng elam lêklala nena, “Uŋgik ôpitu vônô me otak Balabas be nêlêm êndêng yoô.” ");
INSERT INTO ymp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Balabas me ôpatu be hik vovak hiving Lom ining gakmang hîmô Jelusalem kapô be hik anô vônô, be ditu etak yêni hîlôk kalaondong.) ");
INSERT INTO ymp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Yôv me Pailat hevong vo netak Yisu bini, be ditu helam hêndêng avîlanô hethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Metom loho lam lômbôlông nena, “Uŋgik vônô ethak alovalasing! Uŋgik vônô ethak alovalasing!” ");
INSERT INTO ymp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yôv me Pailat henang bôlô ali lô hêndêng loho nena, “Hethak ômbê? Yêni hevong ômbê kambom? Ondong te mî hîmô vo yaŋgik yêni vônô amî. Be ditu tem yambali inda me ya tak yêni bini.” ");
INSERT INTO ymp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Metom loho lêklokwang kambom be elam kaêk lêkwaê nena iŋgik Yisu ethak alovalasing. Loho ning kaêk êng me hîvô hethak be Pailat helaŋô. ");
INSERT INTO ymp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Be ditu Pailat la hêv nena yêni sopa loho ning ambô ");
INSERT INTO ymp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","be hetak ôpatu be hîmô kalaondong hê êndêng loho hîtôm enang ik ling, me hêv Yisu hîlôk ŋa vovak baheŋing hîtôm avîlanô ning leŋing iving. ");
INSERT INTO ymp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Loho iwa Yisu be ê me êpôm Saimon nang Sailini hîlôk loŋdaŋlê be hê vini Jelusalem. Me ŋa vovak evalong yêni be êv Yisu ya alovalasing be hiwa be heveng Yisu yam. ");
INSERT INTO ymp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Me avîlanô bêng anông esopa yêni lêk avî takatu be eleng athêng malêng ethak yêni me loho sapêng iving be ê. ");
INSERT INTO ymp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Metom Yisu hik i lîlîng me henang ethak loho nena, “Môlô avî Jelusalem, dô ondeng ethak ya andô. Me ondeng vo amda lêk nalumi. ");
INSERT INTO ymp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ondaŋô. Wakma te tem nêyô be malêing bêng tem nêpôm avîlanô be tem enang nena, ‘Mavî vo avî yamu takatu be sêik mî be mî êv sum êndêng sêik amî.’ ");
INSERT INTO ymp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wak êng me avîlanô tem enang êndêng dumlôlê sapêng nena, ‘Ôŋgêv yak êyônjêk yoô be uthivung yoô thing.’ ” ");
INSERT INTO ymp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Lêk evong kambom hêndêng alokwang lêkmala, be ditu tem embong ômbête êndêng alokwang kapôk?” ");
INSERT INTO ymp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Me loho iwa anô vanî yi hiving vo iŋgik vônô imbing Yisu. ");
INSERT INTO ymp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Loho ê êyô long atu be elam nena Kwandôk Lokwang. Me loho êthôkêng Yisu lêk anô vanî yi atu hethak alovalasing. Êthôkêng yang heva Yisu bang viyôhôk me yang heva bang vikeng. ");
INSERT INTO ymp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Me Yisu henang nena, “Wakamik, nôŋgêv loho ning kambom vê vômbê nena loho thông paling be evong.” Yôvêm me ŋa vovak îmbî valu vo injê nena opalête tem nimbua ya thôp. ");
INSERT INTO ymp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Avîlanô eva be êyê me ŋa bêŋbêng îmbî yêni lîlîng be enang ambôma nena, “Bôk yêni hêv avîlanô vi livung yôv be nêŋgêv yêni da livung imbing, vômbê nena yêni me Mesaya, ôpatu be Wapômbêng bôk hîtôk yôv.” ");
INSERT INTO ymp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Me ŋa vovak êyô hiving be enang ambôma me êv waing maning hêndêng yêni. ");
INSERT INTO ymp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Me enang nena, “Ong ŋa Juda ning king e? Yôv be nôŋgêv ong da livung.” ");
INSERT INTO ymp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Me ekavu ambô te heva Yisu viling bêŋiti, ÔPITI ME ŊA JUDA NING KING. ");
INSERT INTO ymp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Anô vanî yi atu be êthôkêng hiving Yisu yang henang ambôma hêndêng yêni nena, “Ong Mesaya e? Yôv be nôŋgêv ong da livung me yêi imbing.” ");
INSERT INTO ymp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Metom yang helaŋô ambô êng me hethang yang êng be henang nena, “Tem noma bêng yom me hevong bisê be mî hôkô Wapômbêng amî? ");
INSERT INTO ymp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ai vong kombom kambom bêng anông be ditu thêthôp vo êv vovang hêndêng ai, metom ôpiti me mî hevong kambom te amî.” ");
INSERT INTO ymp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yôv me henang nena, “Yisu, wakma huvutak hîtôm king hîmô yong lêkliŋyak bêng kapô me lem êŋgêv ya.” ");
INSERT INTO ymp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Me Yisu henang nena, “Ya hanang avanông bing ethak ong nena, yaô tiêng yom me tem nômô imbing ya îmô long lêkmaŋging kapô.” ");
INSERT INTO ymp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Bidong oyang waklîvông bing me momaŋaning bêng hêyô pîk sapêng vôv be hêk hele be hêyô wakma lô. Me kwak bêng atu be êthôkêng heva melak matheng kapô hipupkê hê luvi. ");
INSERT INTO ymp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Me Yisu helam kaêk lêklokwang nena, “Wakamik, ya hatak ya dôhôlông hîlôk bahem.” Henang bêng yôv me auk hivutak be hê me hema. ");
INSERT INTO ymp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Me vovak lêik ining anômbêng hêyê nôm êng me yêni hêv Wapômbêng ya athêng ling be henang nena, “Avanông bing, ôpiti me kambom mî.” ");
INSERT INTO ymp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Me avîlanô takatu be ethak tom be eva vo injê, loho yê nôm êng be kapôlôŋing malêing bêng be ê. ");
INSERT INTO ymp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Metom Yisu ya ŋa môlôô lêk avî takatu be esopa yêni hêk Galili be êlêm, loho va dêim doke me êyê nôm takatu be hivutak. ");
INSERT INTO ymp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Me anô Alimatia te nang Judia hîmô be ya athêng nena Josep. Yêni heyambing waklavông atu be Wapômbêng ya lêkliŋyak bêng te nêlêm pîk. Yêni me anô mavî lêk anô thêthôp be yêni me ŋa Juda ning ŋa elaŋô ambô te. Be mî hîlôk hethak loho ning auk atu be ik Yisu vônô amî. ");
INSERT INTO ymp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Be ditu hê hêndêng Pailat me henang ik ling vo nimbua Yisu ya kôpik. ");
INSERT INTO ymp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Êng me hiwa Yisu liŋkôpik hîlôk hivup me hivuliv thing hethak kwak me hiwa be hê hêndô hêk kalang lêkmuk atu be ekolop valu be ambuang vo etak ŋa ema injêk. Kalang êng me mî bôk êndô ŋama te hêk amî denang. ");
INSERT INTO ymp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sabat lêk bidong oyang be avîlanô epesang i vo injê waklavông êng. ");
INSERT INTO ymp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Be ditu avî takatu be esopa Yisu hêk Galili be êlêm me esopa Josep be ê êyê kalang atu be êndô Yisu liŋkôpik hêk vo injê nena etak inda hêk bisê. ");
INSERT INTO ymp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yôv me avî takêng ê ining melak me epesang nôm uv mavî lêk wel. Me Sabat hêyô me iwa lovak hîtôm balambung henang. ");
INSERT INTO ymp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sonda êng ya wak ali himung ya lêkbôk momaŋaning me avî takatu iwa nôm uv mavî takatu be bôk epesang yôv be ê kalang. ");
INSERT INTO ymp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Loho êyô me êyê valu atu be hîmô lovang ambôlêk lêk imbumbi yôv hê hîmô dang. ");
INSERT INTO ymp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Me loho ivutak êyô kapô metom mî êpôm Anômbêng Yisu ya kôpik amî. ");
INSERT INTO ymp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Be loho leŋing êv bêng anông eva denang me ketheng oyang me anô yi lêk kwêv thapuk lêk danda bêng êyô be eva hiving loho. ");
INSERT INTO ymp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Êng me avî takêng êkô be maleŋing hîlôk pîk. Metom thêi enang ethak loho nena, “Bisête be môlô othalo anô lêkmala heveng ŋa ema ining long? ");
INSERT INTO ymp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yêni mî hêk long iti amî. Me lêk hiviyô hethak loŋbô. Be ditu lemim êŋgêv ambô sêmbôk be hîmô Galili denang me henang ethak môlô ");
INSERT INTO ymp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","nena tem etak Anô Ya Nakandung îndôk ŋa kombom kambom baheŋing be iŋgik yêni vônô ethak alovalasing me wak ali lô me tem nimbiyô ethak loŋbô.” ");
INSERT INTO ymp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Êng me loho leŋing êv ambô êng. ");
INSERT INTO ymp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Yôv me loho etak kalang be îvôê me enang ambô takêng sapêng ethak Yisu ya ŋa hîndông lauming be lahavôtom lêk avîlanô takatu be îmô hiving. ");
INSERT INTO ymp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Avî takêng te me Malia nang Makdala me Joana lo Jems talêmbô Malia lêk avî doho hiving enang ethak aposol. ");
INSERT INTO ymp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Metom aposol elaŋô avî takêng ining ambô be esong nena enang ambô molo ma be mî êv iving amî. ");
INSERT INTO ymp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Metom Pita hiviyô me hevothong be hê kalang be hikum me hêyê kwak yom hîmô. Yôv me yêni hele hê melak ethak loŋbô me la hêv bêng anông hethak nôm takatu be lêk hivutak. ");
INSERT INTO ymp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wak êng yom me Yisu ya ŋa hîndông yi ê long te be ya athêng nena Emeus. Long êng hêk dêim doke hîtôm 11 kilomita vo Jelusalem. ");
INSERT INTO ymp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Thêi veng loŋdaŋlê be ê me enang ethak nôm takatu be hivutak. ");
INSERT INTO ymp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Thêi nang ambô bêng anông me Yisu da hêlêm be heveng hiving thêi. ");
INSERT INTO ymp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Metom nômate hik thêi maleŋing thing be mî êyê be eyala yêni amî. ");
INSERT INTO ymp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Me henang ik thêi ling nena, “Mamu oveng be ôlêm me onang ômbête hê be hêlêm?” Êng me thêi va teŋeng me maleŋing ik thô nena thêi leŋing malêing. ");
INSERT INTO ymp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Anô yang be ya athêng nena Kelopas henang viyang nena, “Betha ong vathi te be hôvunu Jelusalem be ditu hôthông nôm takatu be hivutak hêk long êng êndêng wak takiti paling e?” ");
INSERT INTO ymp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Me Yisu henang ik thêi ling nena, “Ômbête bêng?” Me thêi enang ethak inda nena, “Nôm takatu be hêpôm Yisu nang Nasalet, ôpêng me plopet te be hevong ku bêŋbêng be ya ambô me lêkliŋyak anông heva Wapômbêng lêk avîlanô sapêng maleŋing. ");
INSERT INTO ymp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Me yoô ning avaka lêk ŋa bêŋbêng îmbôk da etak yêni hîlôk ŋa Lom baheŋing be ik inda vônô hethak alovalasing. ");
INSERT INTO ymp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Metom bôk yoô leŋing êv nena yêni me ôpatu be tem nêŋgêv Islael vê injêk ining malêing. Me ambô te hêk hiving nena, nôm takêng hivutak me lêk ya wak ali lô. ");
INSERT INTO ymp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Me nôma yang hiving nena avî doho îmô hiving yoô evong be yoô pîndîk kambom. Hêndêng lêkbôk momaŋaning me loho ê kalang ");
INSERT INTO ymp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","metom mî êyê Yisu liŋkôpik amî. Me loho îvôlêm enang nena loho yê wêng aŋêla doho enang nena yêni hîmô lêkmala. ");
INSERT INTO ymp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Me yoô ning anô doho ê kalang me êyê nôm takêng hîtôm datu be avî takatu enang, metom Yisu da me mî loho injê yêni amî.” ");
INSERT INTO ymp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Me Yisu henang ethak thêi nena, “Mamu ŋa auk mî lêk kapôlômim pilisik denang, be ditu mî yuêv iving plopet ining ambô amî! ");
INSERT INTO ymp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Betha bôk mî mamu yala nena Mesaya tem nimbua vovang takêng yôv ketem nimbua ya athêng lêkmaŋging mesa mî e?” ");
INSERT INTO ymp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yôvêm me yêni hiwa Wapômbêng ya ambô takatu be bôk ekavu hethak yêni da sa hethak thêi. Henang mung hethak Moses ya kapua yôvêm me plopet sapêng ining ambô takatu be bôk ekavu hethak yêni hiving. ");
INSERT INTO ymp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Me loho êyô bidong vo Emeus me Yisu hevong vo ni thêthô. ");
INSERT INTO ymp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Metom thêi nang lêklokwang nena, “Lêk yathiŋdang hêmbôk be tem bîlîvông be dô me nômô imbing yêi.” Êng me yêni hê melak kapô hiving thêi be loho mô. ");
INSERT INTO ymp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yôv me loho îmô vo injang nôm me yêni hiwa polom be hêv la mavî yôv me hekavli be hêv hêndêng thêi. ");
INSERT INTO ymp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Thêi yê me maleŋing hipuak be eyala yêni. Me ketheng oyang me yêni lêk mî. ");
INSERT INTO ymp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Me thêi nang ethak i nena, “Avanông bing, ai veng loŋdaŋlê me yêni hik Wapômbêng ya ambô thô be ai kapôlôŋing hîtôm amela hethang.” ");
INSERT INTO ymp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bôlôtom me thêi tak long êng me ele ê Jelusalem hethak loŋbô. Thêi yô me êpôm Yisu ya ŋa hîndông lauming be lahavôtom atu lêk anô doho ethak tom hiving be îmô. ");
INSERT INTO ymp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Me loho nang hêndêng thêi bêŋiti nena, “Avanông bing nena Anômbêng lêk hiviyô hethak loŋbô be yêni hik i thô hêndêng Saimon.” ");
INSERT INTO ymp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yôv me anô yi êng enang nôm takatu be hêpôm thêi hîlôk loŋdaŋlê bisê hiving polom atu be Yisu hekavli be hêv hêndêng thêi be thêi yala yêni. ");
INSERT INTO ymp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Me thêi nang ambô hethak loho hîmô denang me Yisu heva loho lîvông me henang nena, “Môlô kapôlômim injêk yaô!” ");
INSERT INTO ymp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Me loho pîndîk kambom be esong nena gôk anô dôhô be êkô anông. ");
INSERT INTO ymp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Metom Yisu henang nena, “Hevong bisê be môlô song kambom be môlô ning auk ethak be hîlôk mayaliv vo? ");
INSERT INTO ymp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ôŋgô ya baheng lo yaveng. Ya da êng diti be ombalong ya leŋving kôpik, vômbê nena gôk me lokwang lêk liŋkôpik mî hîtôm diti môlô yê ya.” ");
INSERT INTO ymp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Henang bêng me hik va lo bang thô hêndêng loho. ");
INSERT INTO ymp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Loho yê yêni me leŋing mavî anông, metom loho ning auk hîmô mayaliv denang be mî êv iving amî. Êng me Yisu henang ik loho ling nena, “Nôm doho hîmô vo yaŋgang mesa mî?” ");
INSERT INTO ymp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Êng me êv alim ŋanam atu be îmbôk kôkô te vi ");
INSERT INTO ymp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","me yêni hiwa be heyang eva loho maleŋing. ");
INSERT INTO ymp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Me Yisu henang ethak loho nena, “Sêmbôk be ya hamô hiving môlô denang me ya hanang nena ambô takatu be bôk ekavu hethak ya be hêk Moses ya balambung lêk Plopet ining Kapua me Kapua Yeng tem niŋgik anông.” ");
INSERT INTO ymp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Me yêni hik loho ning auk ling vo eyala Wapômbêng ya ambô hêk ya kapua ya ondong ");
INSERT INTO ymp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","be henang nena, “Wapômbêng ya kapua henang nena Mesaya tem nimbua vovang be nema me wak ali lô me tem nimbiyô ethak loŋbô. ");
INSERT INTO ymp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Me hethak ya athêng yom me tem enang mung injêk Jelusalem yôv kîmîng ni pîk nômbêng iti sapêng nena ende kapôlôŋing lîlîng vo Wapômbêng tem nêŋgêv ining kambom vê. ");
INSERT INTO ymp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Lêk môlô yê nôm takêng yôv be ditu môlô nang sapêng bêng. ");
INSERT INTO ymp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ondaŋô! Tem yaŋgêv nôm atu be Wakamik bôk hevak ambô vo nêŋgêv êyômô môlô. Metom môlô mô Jelusalem endebe umbua lêklokwang êng nang melak leng êm.” ");
INSERT INTO ymp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Me Yisu helom loho be hê hêyô bidong oyang Betani me hêv bang ling be hêv mek ethak loho. ");
INSERT INTO ymp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hêv mek denang me hetak loho me yêni hethak leng be hê. ");
INSERT INTO ymp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Êng me loho êv yeng hethak yêni yôv me ele ê Jelusalem lêk leŋing mavî bêng anông. ");
INSERT INTO ymp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Me wak nômbêng iti sapêng me loho mô melak matheng be êv Wapômbêng ya athêng ling.");
ALTER TABLE ymp_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
