﻿USE sofia;
DROP TABLE IF EXISTS sofia.yml_vpl;
CREATE TABLE yml_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yml_vpl WRITE;
INSERT INTO yml_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iesu Keliso tubunavo side bani'odi yadi tubuga, taunina Kini Devida 'ana wauma 'wainega i souyeni we'e Devida Ebelamo 'ana wauma 'wainega i souyeni. ");
INSERT INTO yml_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebelamo natuna Aisake, Aisake natuna Iakobo, Iakobo natunavo Iuda ma tainavo, ");
INSERT INTO yml_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iuda natunavo Felesi wata Dela, inadi Temali, Felesi natuna Esiloni, Esiloni natuna Lami, ");
INSERT INTO yml_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lami natuna Aminadaba, Aminadaba natuna Nasoni, Nasoni natuna Salimoni, ");
INSERT INTO yml_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni ma yana vavine Leabi natudi Bwasa, Bwasa ma yana vavine Ludi natudi Obedi, Obedi natuna Iese, ");
INSERT INTO yml_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iese natuna Kini Devida. Devida 'wainega i velamuga side bani'odi. Devida natuna Solomoni, we'e inana nagami Ulaia yana vavine, ");
INSERT INTO yml_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni natuna Lioboama, Lioboama natuna Ebaya, Ebaya natuna Esa, ");
INSERT INTO yml_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa natuna Iosefata, Iosefata natuna Dielome, Dielome natuna Usaia, ");
INSERT INTO yml_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia natuna Iotama, Iotama natuna Easi, Easi natuna Esekaia, ");
INSERT INTO yml_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekaia natuna Manasa, Manasa natuna Emoni, Emoni natuna Iosia, ");
INSERT INTO yml_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosia natuna Iekonaia ma tainavo i miamiani, tutuyanina 'waineye me Babiloni i maia me Isileli i 'ive'avinidi i nawedi yadi 'awalaweye. ");
INSERT INTO yml_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","We'e Babiloni 'wainega i velamuga side bani'odi. Iekonaia natuna Salatiela, Salatiela natuna Selubabela, ");
INSERT INTO yml_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabela natuna Abiuda, Abiuda natuna Eliakimu, Eliakimu natuna Asodi, ");
INSERT INTO yml_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asodi natuna Sadoki, Sadoki natuna Ekimu, Ekimu natuna Eliuda, ");
INSERT INTO yml_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda natuna Eleasa, Eleasa natuna Mateni, Mateni natuna Iakobo, ");
INSERT INTO yml_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iakobo natuna Iosefa. Iosefa kumanina yana vavine Meli, vavinenidi Iesu kumanina i golegoleniga Keliso, Yaubada 'ana Venua'ivina inana. ");
INSERT INTO yml_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bega 'ai'edi ta na lu'iawawa Ebelamo 'wainega i nagoga Kini Devida 'waineye lakata 14. We'e Kini Devida 'wainega i na nagoga tutuyanina me Babiloni i maia me Isileli i nawedi yadi 'awalaweye lakata 14. Wata tutuyanina 'wainega i na nagoga nika Keliso i tubuga wata lakata 14. ");
INSERT INTO yml_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Keliso yana tubuga side bani'odi. Meli 'awaie Iesu inana, kumanina veveakutagonina Iosefa faifaina. Bola kebu i da nagiga wata kebu tamu aitoi taiadi i da veluaga, siwe i 'asetai 'akonadi i miana 'Anu'anunu Magemagetana yana toketokena 'wainega. ");
INSERT INTO yml_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iosefa kumanina toveakutagona, i nuavita Meli yadi miana faifaina, siwe fai yana sauluva tonovina begaidi kebu nuanuana Meli i na 'ivebunumayagidi, we'e givagivayega i na bailedi. ");
INSERT INTO yml_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Igodi yana nuanuananina i da 'idewaiga, lovane i 'eno'eno nika i 'enoneganega 'Auvea yana anelose i souyeni i voneni i vo, Iosefa, 'omu Kini Devida tubuna, kebu 'u na venuanaluga Meli 'adi nagi faifaina, we'e i mianaga 'Anu'anunu Magemagetana yana toketokena 'wainega, 'asa'aiana 'u na nagidimo. ");
INSERT INTO yml_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mulieta i na venatuna, kwamana iavetana i na tubuga 'u na goleni Iesu, fai yana tomotoga i na 'ita'ita'iedi yadi sakona 'waidiega.” ");
INSERT INTO yml_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Bega Meli yadi miana wata Iesu yana tubuga faifaidi, basenadiotoga 'Auvea i vona yana tolu'ivona 'wainega 'ana mogitana i souyeni i vo, A na vonemi. Vavine ne'e'elina kebu tamu tomogo taiadi i da veluaga siwe i na miana. Kwamana iavetana i na tubuga, i na goleni Imanueli, 'ana saivila Yaubada 'ida taiadi.” ");
INSERT INTO yml_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tutuyanina Iosefa 'enoyega i tovoi, 'Auvea yana anelose yana veifufu i vematayakeyakeni, bega Meli i nagidi i nawedi yana vanuge. ");
INSERT INTO yml_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Siwe kebu tamu tutuya taiadi i da veluaga i nagoga 'ana tugusa i venatuna. Mulieta Iosefa kwamananina i goleni Iesu. ");
INSERT INTO yml_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kini Elodi yana tutuye Iesu i tubuga 'atamana Bedeliema 'waineye, 'awalawa Iudia nageneye. We'e kebu tutuya manamanawenaga nika tomotoga 'ifwaidi i le'wai Ielusalema. Tomotoganidi i maiaga inala yana 'eba lakayega yadi 'aseta bwaikina 'ubwana faifaidi. ");
INSERT INTO yml_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","I le'wai i velutoli i vo, Ava'aibe bei kwamana i tubuga 'omi me Diu yami kini? 'A 'asetai tamu Kini i tubuga fai no'o bega tamu 'ubwana 'a 'iseni i laka, Kininina 'ana tugusa, bega 'a maia ma yama ve'ililibu 'a na 'odu 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tutuyanina Kini Elodi wata me Ielusalema matatabuna, valanina i noganogaiga i toke i venuafouviga. ");
INSERT INTO yml_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mulieta tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo i goleva'augidi i velutoliedi i vo, Ava'aibe bei Keliso, Yaubada 'ana Venua'ivina i na tubuga?” ");
INSERT INTO yml_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yana velutoli i tutuli i vo, 'Atamana Bedeliema 'awalawa Iudia nageneye. Basenadiotoga Yaubada yana tolu'ivona Keliso yana tubuga faifaina side bani'odi i kilumi i vo, ");
INSERT INTO yml_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'Omu Bedeliema 'awalawa Iudia nageneye, kumanimu 'atamana siaimu, siwe 'amu wagava bwaikina 'awalawanina nageneye. Fai 'waimuyega tamu toveimea i na souyeni, yaku tomotoga me Isileli i na 'i'isave'avinidi.’” ");
INSERT INTO yml_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Valanina Elodi i noganogaiga, to'asetanidi i goledi i nagoi 'waineye 'aise'avadi i veifufugiva. I velutoliedi nuanuana i na 'asetai, ma'avia 'ubwananina i souyeni bega i 'iseni. ");
INSERT INTO yml_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I velutoliedi i 'a'ava mulieta i vetunedi side bani'odi i voneyedi i vo, 'Wa na nagoi Bedeliema kwamana 'wa na luala-deweni, tutuyanina 'wa na veluagaiga 'wa na mai 'wa na voneku wata yau a na nago, 'waineye a na 'odu.” ");
INSERT INTO yml_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Elodi i veifufu'a'ava nika tomotoganidi i tauya. I nunagoi wata 'ubwananina i 'iseni debanagodiega, i sivetonovedi i nagoga nika i le'wa kwamana yana 'eba mia 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","We'e tutuyanina to'asetanidi 'ubwana i 'iseniga yadi sosoana kebu ta na vona 'adi vebae 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tutuyanina i le'wai i luku vanuge, kwamana wata inana i 'isedi i miamia, nika i 'odu ma yadi ve'ililibu kwamana 'waineye. Mulieta yadi venuanayega yadi nuakalikali i 'ewadi kwamana 'waineye i yatodi. Nuakalikalinidi kukuafou, golida tutulina bwaikina, vane 'ailuga magaidi 'atumaidi, tamu Mulo we'e tamu Falanikisenisi, vanenidi 'adi tutula bwaikidi. ");
INSERT INTO yml_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","We'e Yaubada 'enoneganegayega tomotoganidi i vonedi, kebu wata i na vilaviladi Elodi 'waineamo, we'e ma'itufa mali 'edeamo i viladi i nagoi yadi 'atamane. ");
INSERT INTO yml_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tutuyanina to'asetanidi i tauya i nunagoi, lovane Iosefa i 'enoneganega. 'Auvea yana anelose i souyeni 'waineye i voneni i vo, 'U na tovoi kwamana inana taiadi 'wa na dega 'wa na nagoi 'awalawa Itifita. Bei 'wa na miamia fai Kini Elodi kwamana i na lualeni nuanuana i na luvewafai, mulieta yau a na vonana 'awalawanina 'wa na 'iaweni.” ");
INSERT INTO yml_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","15","Bega Iosefa i tovoi kwamana inana taiadi lovane i dega i nago Itifita, bei i miamia 'ana tugusa Kini Elodi i wafa. Yadi mia Itifita 'waineye faifaina basenadiotoga 'Auvea i vona yana tolu'ivona 'wainega i vo, Natuku Itifitayega a goleni i mai.” Nika bei vonanina 'ana mogitana i souyeni. ");
INSERT INTO yml_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","We'e Elodi i lukamata-wayoga i 'asetai 'ubwana 'adi to'aseta i vekalieni begaidi i nuasako-'afo'afo. Yana tolugaviavo i vonedi i luku 'atamana Bedeliema wata 'atamana siaidi 'waidie, kwakwama iavetadi 'adi malamala 'ailuga wata kumanidiavo 'adi malamala 'ailuga bola kebu i da veluagadiga, matatabudi i luvewafadi. I luvewafadiga fai 'ubwana 'adi to'aseta yadi veifufu 'wainega Elodi i 'asetai Iesu 'ana malamala 'ana vetonu bola kebu i da veluagaiga. ");
INSERT INTO yml_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kwakwama siaidi i luvewafadi faifaina basenadiotoga Yaubada yana tolu'ivona Ielemaia i vona-samula. Nika 'ana mogitana i souyeni i vo, ");
INSERT INTO yml_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","'Atamana Lema 'wainega vevine bonadi i nogai, 'we'wela wata taivonavona. Litieli 'adi wauma natudiavo faifaidi i taivonavona, kebu tamu aitoi 'ana fata nuadi i na 'iveolooloi, fai matatabudi i wafa.” ");
INSERT INTO yml_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","I miamia Itifita nika Elodi i wafa, mulieta 'Auvea yana anelose i souyeni Iosefa 'waineye 'enoneganegayega i voneni i vo, Itifitayega 'u na tovoi, kwamana inana taiadi 'wa na vilami 'wa na nagoi 'awalawa Isileli. Elodi 'akonadi i wafa bega kebu tamu aitoi nuanuana kwamana i na luvewafai.” ");
INSERT INTO yml_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bega Iosefa i tovoi kwamana inana taiadi i vagavaidi i viladi i nagoi, 'awalawa Isileli. ");
INSERT INTO yml_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","I viladi i nunagoi Iosefa ma yana kololo fai vala i nogai, Akeleasi i ve-kini tamana Elodi tutulina 'awalawa Iudia 'waineye. Iosefa kebu nuanuana bei i na mia, nika wata anelose 'enoneganegayega i voneni bega i nago 'atamana Nasaledi 'awalawa Galili bei i mia. ");
INSERT INTO yml_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nasaledi bei i miaga, nika tamu Yaubada yana tolu'ivona yana vona-samula Iesu faifaina 'ana mogitana i souyeni i vo, I na golegoleni kumanina tomogo Nasaledi.” ");
INSERT INTO yml_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Tutuyanina Iesu i miamia Nasaledi, Ioni Tobafitaiso i velamu i lalau'age Iudia sali'avu'avuye i vo, 'Wa na nuavilami yami sakona 'wa na vedumwe'ubu'ubusedi fai sai'afoga Yaubada yana veimea i na souyeni 'waimie.” ");
INSERT INTO yml_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ioni kumanina faifaina basenadiotoga Yaubada yana tolu'ivona Aisea i voneyeni i vo, Sali'avu'avuye tamu tomogo i vegolegole i vo, 'Auvea yana 'eda 'wa na vusia, wata 'wa na sivetonovi yana 'eba nago.’” ");
INSERT INTO yml_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioni 'ana talauma kameli vutuvutudiega i 'idewadi we'e bulumakau bunudi 'ana wa'ila, 'ana'ana limwana wata mai'awa. ");
INSERT INTO yml_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","6","Tomotoga fuedi Ielusalemayega, Iudia yana 'eba veimea matatabuna 'wainega, wata 'awalawa fuedi Ufa Iolidani lilivaneye, Ioni valana i nogai i nagoi 'waineye. Tutuyanina Ioni bonana i nogai, 'aitamogana 'aitamogana yadi sakona i lu'ivoneyedi nika Ioni i bafitaisodi Ufa Iolidani 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ioni i 'isanawedi totafalolo Falisi wata Sadusi i mimaia 'waineye bafitaiso faifaina nika i vonedi i vo, 'Omi tosakona, 'o'olo bani'odi. Igodi 'wa vo, 'A na dega Yaubada yana nuasako wata yana vematavuloga 'waidiega.’ Begaidi yami vaiseba 'wa vo, 'Akonadi 'a nuavilama 'u da bafitaisoma,’ siwe kebu nuanuami yami sauluva sakoidi 'wa na vedumwe'ubu'ubusedi. ");
INSERT INTO yml_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nagami yami sauluva i na tonova 'ami 'eba 'isa 'akonadi 'wa nuavilami, 'wa da vo bani'odi welavi vuagina 'atumaina, mulieta a na bafitaisomi. ");
INSERT INTO yml_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Wata kebu 'wa na vo, Ebelamo tubuma bega Yaubada kebu i na vematavulogima.’ Siwe a na vonemi, kebu 'aivaita 'wa na veluagai. 'Omi Ebelamo tubunavo kebu nani bwaikina Yaubada mataneye. Yaubada 'ana fata Ebelamo tubunavo i na 'idewadi kileu de'e 'waidiega. ");
INSERT INTO yml_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sai'afoga Yaubada i na vematavulogimi yami sauluva sakoidi faifaidi, 'wa da vo 'akonadi yana tamuyoko i da yadali bega welavi 'aitamogana 'aitamogana kebu vuagidi 'atumaidiga, i na talagidi i na tawedi 'ai-'ala'alase. ");
INSERT INTO yml_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","We'e 'wa na nuavilamiga 'ana tugusa yau a na bafitaisomi ufayega, kumanina mulikuye i mimaiga i na bafitaisomi 'Anu'anunu Magemagetana wata 'ai-'ala'alata 'waidiega. Wata tomogonina toketokeotogina, yau kebu bani'odiga, kebu i da lubwaineku 'waineye a na vetofolova fai taunina bwaikina. ");
INSERT INTO yml_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tutuyanina i na maiga, tomia fwayafwaya matatabudi i na vonayavuga 'waineye 'wa da vo bani'odi waifei 'ana tolaukadi, waifei wata 'ani'aninidi i na yato'edi mulieta i na vedodogidi yana bubuwakeye, we'e yogo i na tunuya 'ainina kebu yana 'weuga 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tutuyanina Ioni tomotoga i bafitaisodi, Iesu Galiliega i tauya i nago Ufa Iolidani bega Ioni i na bafitaisoi. ");
INSERT INTO yml_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ioni nuanuana i na talaboda begaidi i vo, Awale igodi yau a na bafitaisomu? Yau i lubwaineku 'u da bafitaisoku.” ");
INSERT INTO yml_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iesu Ioni yana vona i tutuli i vo, Kebu 'u na nuanuaga, 'asa'aiana 'u na bafitaisokumo. I lubwaineda Yaubada yana nuanua tonovidi matatabuna ta na 'idewadi,” nika Ioni i nogaya i vo, 'Atumaina.” ");
INSERT INTO yml_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesu i bafitaiso i 'a'ava, i lakama 'avale nika abama i 'anikililia Yaubada 'Anu'anununa yana yaveobu 'ana 'isa'isa bani'odi bunebune, i 'iseni i obuma i toa 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nika bona i nogai abamayega i vo, De'e natuku nuafouku a nuakalikalieni bwaikina, faifaina a sosoana.” ");
INSERT INTO yml_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","2","Ufa Iolidani 'waineye i bafitaiso i 'a'ava, Yaubada 'Anu'anununa Iesu i vagavaia i naweni sali'avu'avuye bega yaiaina 'adi to'edakumeta Seitani Iesu i na silubuya nuanuana i na sakona. Sali'avu'avuye Iesu i miamia 'aiata 40 nika i lase fai kebu tamu sai'afo 'ani'ani i da 'ania. ");
INSERT INTO yml_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tutuyanina Iesu i lase nika bei Seitani i souyeni 'waineye, i voneni i vo, 'Ai'edi 'omu mogitana Yaubada Natuna, 'u na vona de'e kileunidi i na ve'ani'ani.” ");
INSERT INTO yml_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iesu Seitani yana vona i tutuli i vo, Kebu. Basenadi i kilumi Yaubada yana Buki nageneye i vo, Tomotoga yadi mia 'ana 'atumaina kebu 'ani'ani'ava 'wainega i da veveluagadi. We'e mogitana Yaubada yana Vona i voneyediga, 'waidiega tomotoga yadi mia 'ana 'atumaina wata yawaidi i na veluagadi.’ “ ");
INSERT INTO yml_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","I 'a'avana wata Seitani Iesu i vagavaia i naweni Ielusalema, Vanuga 'Eba Velu'ui tabwaotogineye i lakaveni. ");
INSERT INTO yml_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Bei wata i voneni i vo, 'Ai'edi mogitana 'omu Yaubada Natuna de'e bega 'u na souga, veviga kebu 'u na veluagai fai Yaubada yana Buki nageneye i vo, Yaubada yana anelose i na vonedi i na 'i'ita'ita'iemu, nimadiega i na silakaimu bega kebu tamu sai'afo 'agemu 'u na nikeyedi kileu 'waidie.’ “ ");
INSERT INTO yml_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu Seitani yana vona i tutuli i vo, We'e Yaubada yana Buki 'waineye i vo, 'Ai'edi taunimi 'wa na tauyemi 'eba ilagi 'waidie, kebu i da lubwainemi 'Auvea yami Yaubada 'wa na sitonovi 'ami 'ita'ita'i faifaina.’ “ ");
INSERT INTO yml_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","I 'a'avana Seitani Iesu i vagavaia i lakaveni 'oya manamanaweotogina tabwaneye, fwayafwaya yana 'eba veimea wata yana 'ai'aiwabu matatabuna i veni. ");
INSERT INTO yml_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","I veni i 'a'avana i voneni i vo, 'Ai'edi ma yamu ve'ililibu 'u na lumata'afufu 'u na 'odu 'waikuye, de'e 'eba veimeanidi wata 'ai'aiwabunidi matatabuna a na velemu.” ");
INSERT INTO yml_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Seitani i vonavonaga nika Iesu i vo, Seitani 'asa'aiana 'u 'ailove 'u nago. Fai Yaubada yana Buki nageneye i vonaga i vo, 'Auvea yami Yaubada 'waineye 'wa na 'odu'odu, wata 'aiseotogina faifaina 'wa na folofolova.’” ");
INSERT INTO yml_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Seitani i tauya i nunago nika anelose i souyeni Iesu i 'i'isave'avini. ");
INSERT INTO yml_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tutuyanina Iesu vala i nogai Ioni 'akonadi vanuga yogona nageneye i yatoi Kini Elodi i lumataniga faifaina, bega Iesu i tovoi i nago 'awalawa Galili. ");
INSERT INTO yml_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nagami i nago Nasaledi mulieta 'atamananina i 'iaweni i nago Kafaneomi yana 'atamana 'ivauna i vili bei i miana. 'Atamananina Lavu Galili lilivaneye, 'awalawa Sebuloni wata Nafitalai nagedie. ");
INSERT INTO yml_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Naninina faifaina Yaubada yana tolu'ivona Aisea basenadiotoga i vona-samulaga 'ana mogitana i souyeni i vo, ");
INSERT INTO yml_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebuloni wata Nafitalai yadi fwayafwaya 'eda bwaikina lilivaneye, 'edanina balabala wata Ufa Iolidani kamwadiamo, i nagoga 'ana tugusa Galili 'waineye, 'awalawanina bei mali tomotoga kumanidiavo kebu Diu i miamiani. ");
INSERT INTO yml_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tomotoganidi i nunagoi dudubala nageneamo, mageta mataududulina i 'iseni. We'e egavo dudubala 'wau'waugaotogina nageneye i miamianiga, magetanina i magesedi.” ");
INSERT INTO yml_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tutuyanina Iesu i vilai i mai Galili i miamia bei yana lau'age i velamu i vo, 'Wa na nuavilami yami sakona 'wa na vedumwe'ubu'ubusedi fai sai'afoga Yaubada yana veimea i na souyeni 'waimie.” ");
INSERT INTO yml_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tamu 'aiata Iesu i balabala Lavu Galili balebaleamo tomotoga 'adi 'ailuga i 'isedi, Saimoni tamu 'ana wagava Fita wata taina Anidulu, vuatayega igana i 'ona'onadi fai taunidi toyaubani. ");
INSERT INTO yml_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iesu i vonedi i vo, We'e yaubaninina 'wa baileni, 'wa na maia 'wa na vetovetutuyama 'waikuye, yau tamu yaubani a na vemi bega tomotoga 'wa na 'ona'onadi 'wa na mimaiedi Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nika Saimoni wata Anidulu vualalalakana i bailedi Iesu taiadi i nagoi i na vetovetutuyama 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","22","Sai'afo i vaganago nika Sebedi ma natunavo i 'isedi, Iemesa wata Ioni yadi wakeye yadi vuata i agiagilidi. Ma taina Iesu i vonedi i vo, 'Wa maia,” nika tamadi ma wakana i bailedi Iesu taiadi i nagoi i na vetutuyama 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu toyaubani i venua'ivinedi i 'a'avana i nago 'awalawa Galili 'waineamo, yadi 'eba miava'auta 'waidie i veve. Vala 'Atumaina Yaubada yana veimea faifaina i lalau'age, wata tomotoga fuedi 'adi viga tulina tulina i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","We'e tomotoga fuedi 'awalawa Silia nageneye Iesu valana i nogai bega yadi toviga 'adi viga tulina tulina i miedi 'waineye. 'Ifwaidi tomotoga i veveviga bwaikina, 'ifwaidi yaiaina sakoidi i agedi, 'ifwaidi viga tamu 'wainega i alala wata 'ifwaidi bwalobwalokodi, matatabudi Iesu i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tomotoga fueotogidi Iesu i yogo'waili, kumanidiavo i maia Galiliega, 'awalawa Dekafolisi 'wainega, Ielusalemayega, Iudiayega wata Ufa Iolidani vi'ainega i damanama. ");
INSERT INTO yml_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Tomotoga fueotogidi i maia Iesu i 'isedi begaidi i laka 'oyeye i miabui. Mulieta yana tovetutuyamavo i maia lilivaneye i miabui nika Iesu i velamu i ve 'waidie i vo, ");
INSERT INTO yml_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Egavo i 'asetadi 'anu'anunudi mweadi begaidi taunidi i tauyedi Yaubada 'waineye, 'eba sosoana 'waidie fai 'akonadi Yaubada i veveimeyedi yana 'Aila'a nageneye. ");
INSERT INTO yml_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","We'e egavo 'asiau ma yadi nuavita i 'we'we'welaga, 'eba sosoana 'waidie fai Yaubada nuadi i na 'iveoloolodi i na sosoana. ");
INSERT INTO yml_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Egavo i nunuaobuga yadi sauluva bikadi, 'eba sosoana 'waidie fai Yaubada i vona'awaufaufa fwayafwaya matatabuna i na veledi. ");
INSERT INTO yml_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","We'e egavo nuanuadi bwaikina sauluva 'atumaina wata tonovina, 'eba sosoana 'waidie, fai nuanuananina Yaubada i na veledi nika 'adi fata. ");
INSERT INTO yml_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Egavo mali tomotoga i 'i'isanuakalikaliedi, 'eba sosoana 'waidie fai wata Yaubada i na 'isanuakalikaliedi. ");
INSERT INTO yml_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","We'e egavo yadi nuanua wata yadi sauluva tonoviotogidi, 'eba sosoana 'waidie fai 'awaie i na luku Yaubada 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Egavo mia 'atumaina wata mia niwalova faifaina i na vevelu'ase'ase tonuasako 'waidie, 'eba sosoana fai Yaubada i na awave-natuna 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","We'e egavo Yaubada yana nuanua i vevematayakeyakedi bega vita i veveluagadi mali tomotoga 'waidiega, 'eba sosoana 'waidie fai 'akonadi Yaubada i veveimeyedi yana 'Aila'a nageneye. ");
INSERT INTO yml_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Fai 'omi yaku tovetutuyamavo begaidi faifaiku tomotoga i na sisidibidibiemi, vita i na velevelemi wata nani tulidi tulidi faifaidi i na awavesakoyemiga, 'eba sosoana 'waimie. ");
INSERT INTO yml_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","'Wa na nuani, basenadiotoga tovedumwe'ai'ai Yaubada yana tolu'ivonavo vita i veledi wata 'omi bani'odi vita 'wa na veluagadi tosakona 'waidiega, siwe 'wa na sosoana mogitana fai 'ami tutula bwaikina Yaubada i yatoi i lulukamata abame.” ");
INSERT INTO yml_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Iesu i vonedi i vo, Eyaga 'eba 'ive'iwana, 'omi wata bani'odi tomia fwayafwaya 'awasasadie. Siwe 'ai'edi eyaga i na ve'ulaufaga kebu 'ana fata i na vegola-vaitugana bega ta na taweni tomotoga i na vagavefwayafwayai. ");
INSERT INTO yml_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","'Omi bani'odi mageta, Yaubada yana 'eda'eda 'ana tokiavemageta tomia fwayafwaya 'awasasadie. 'Ai'edi tamu 'atamana i na 'idewai 'oya deba'aiotogineye ava'ai i na velubabaleni? Kebu. Wata 'omi yaku mageta, tomotoga yadi 'eba 'isa. ");
INSERT INTO yml_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kebu tamu aitoi mageta i da kabukabuni 'aivoeyega i da talafwaseni. We'e mogitana magetanina 'ana 'eba yato 'waineye i lulutalauleni bega tomotoga vanuganina nageneye matatabudi i magemagesedi. ");
INSERT INTO yml_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","'Omi wata bani'odi yami sauluva i na tonova tomotoga matadie bega yami sauluvanidi 'atumaidi i na 'isedi nika Tamami abame i miamiaga i na subiai.” ");
INSERT INTO yml_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Iesu i vonedi i vo, Kebu 'wa na vo 'ako a mai veimeanidi Mosese 'wainega wata venidi Yaubada yana tolu'ivonavo 'waidiega a na geudi. Kebu, a maiga bega 'waikuyega veimeanidi wata venidi 'adi mogitana i na souyedi. ");
INSERT INTO yml_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A vona mogitana 'waimie, abama wata fwayafwaya 'awaie i na savovola we'e kebu 'ana fata Yaubada yana Veimeanidi 'waidiega tamu nani siaina i na 'a'ava, i na nagoga nagami ava'ai i voneyediga 'adi mogitana i na souyedi. ");
INSERT INTO yml_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Begaidi 'ai'edi aitoi veimeanidi tamu saiotogina kebu i na vematayakeyakeniga wata yana ve 'wainega tomotoga 'ifwaidi veimeanina i na vedumwe'ai'aieni, Yaubada yana 'Eba Veimea nageneye 'ana wagava i na vesiaiotoga. We'e 'ai'edi aitoi veimeanidi i na vematayakeyakediga wata yana ve 'wainega tomotoga 'ifwaidi veimeanidi i na vematayakeyakedi, Yaubada yana 'Eba Veimea nageneye kumanina 'ana wagava bwaikina. ");
INSERT INTO yml_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","A na vonemi, ve'etoboda 'adi tovevo wata totafalolo Falisi igodi i vo, Ve'etoboda matatabuna 'a vevematayakeyakedi bega yama sauluva 'atumaidi.’ We'e 'omi, 'ai'edi nuanuami 'wa na luku Yaubada yana 'Eba Veimea 'waineye, i lubwainemi yami sauluva tonovina Yaubada mataneye, we'e tovenidi wata Falisi kebu 'wa na saladiga.” ");
INSERT INTO yml_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Iesu i vonedi i vo, Veimea de'e 'akonadi 'wa 'asetai tubudavo i vonedi i vo, Kebu 'wa na luvewafaga,’ wata tamu i vo, 'Ai'edi aitoi i na luvewafaga 'eba vonayavuga 'waineye i na nago.’ ");
INSERT INTO yml_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","I vonaga mogitana, we'e yau a na vonemi. 'Ai'edi aitoi i na nuasakomo iana 'waineye, tomogonina i na nago 'eba vonayavuga 'waineye. 'Ai'edi aitoi iana i na awavesakoyeni i na vo, 'Omu kebu tamu sai'afo ava'ai 'atumaina 'waimuyega i na souyeni,’ tomogonina wata 'eba vonayavuga bwaikina 'waineye i na vonayavuga. We'e aitoi iana i na fali'wave'waveniga, voke Yaubada i na veimea 'ai-'ala'alata kebu yana 'weuga 'waineye i na nago. ");
INSERT INTO yml_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","'Ai'edi 'u na nago Vanuga 'Eba Velu'ui 'waineye nuanuamu yamu 'anivelena-maimaiga 'u na velomuyeni Yaubada 'waineye, nika iamu yana nuasako 'waimuye 'u na nuani, 'u baileni i na 'eno'eno nagami 'u na vilamu iamunina taiadi 'wa na veiana, mulieta 'u na vilamuga yamu 'anivelena-maimaiga 'u na velomuyeni Yaubada 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","'Ai'edi aitoi i na vevitamu tamu sakona faifaina bega i na vagavaimu i na nunawemu 'eba vonayavuga 'waineye 'u na vewavawava 'edeye 'wa na sivetovetonovi. 'Ai'edi kebu, i na 'anivelenemu tovevonayavuga 'waineye, mulieta i na yatomu tovematavuloga nimaneye nika 'u na luku vanuga yogona nageneye. ");
INSERT INTO yml_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A vona mogitana, kebu i na 'etoyavu-matayo'omu bei 'u na miamia i na nagoga 'ana tugusa 'u na tutula'a'ava, nika i na 'etoyavumu.” ");
INSERT INTO yml_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Wata Iesu i vonedi i vo, Veimea de'e 'akonadi 'wa 'asetai i vo, Kebu tamu aitoi yana vavine 'u na luobuyedi.’ ");
INSERT INTO yml_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","We'e yau a na vonemi, 'ai'edi aitoi tamu vavine i na 'isenimo nuana i na vevona, siwe 'asa'aiana 'akonadi nuanega taiadi i sakona. ");
INSERT INTO yml_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","'Ai'edi matamu tamu, avinodi kumanina nigonigona, siwe sai'afoga i da kiavebe'umu 'u da sakona, 'u kiamwanuya 'u taweni. 'U na kiamwanuyaga veviga sai'afo nika kebu 'u na sakonaga, mulieta 'amu fata 'aitamogana 'wainega 'u na luku abame. We'e 'ai'edi matamu 'ailugana 'waidiega 'u na sakosakonaga, mulieta 'u na wafa Yaubada i na tawe-mwadodouyemu 'ai-'ala'alase, veviga bwaikaotogina 'u na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","'Ai'edi nimamu tamu, avinodi kumanina toketokeotogina, sai'afoga 'wainega 'u da sakona, 'u boboi. 'U na boboiga veviga sai'afo nika kebu 'u na sakonaga, 'amu fata 'aitamoganega 'u na luku abame. We'e 'ai'edi nimamu 'ailugana 'waidiega 'u na sakosakonaga, mulieta 'u na wafa tomogomu matatabuna 'u na lukuveni 'ai-'ala'alase, veviga bwaikaotogina 'u na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Veimea de'e 'akonadi 'wa 'asetai i vo, 'Ai'edi aitoi nuanuana yana vavine i na vesa'ilidi tamu lubulubu 'waineye sa'ila 'ana vona i na kilumi vavine i na veledi nika bei i vesa'ilidi.’ ");
INSERT INTO yml_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Siwe yau a na vonemi, 'ai'edi aitoi yana vavine i na vesa'ilidi, 'asa'aiana 'akonadi i 'anivelenedi sakona 'waineye. Siwe 'ai'edi vavinenidi basenadi tamu tomogo taiadi i na veluaga yadi lamoga i na vesa'ilidiga, tomogo kebu i da sakona. Wata 'ai'edi tomogo vavine nagisa'isa'ilidi i na nagidiga i na sakona vavinenidi 'waidie.” ");
INSERT INTO yml_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Wata Iesu i vonedi i vo, Veimea de'e 'akonadi 'wa 'asetai tubudavo i vonedi i vo, 'Ai'edi aitoi i na vona'awaufaufa 'Auvea mataneye, kebu i da lubwaineni yana vona'awaufaufanina i na geuya.’ ");
INSERT INTO yml_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","We'e yau a na vonemi, 'ai'edi 'wa na vona'awaufaufaga kebu tamu ava'ai 'ana wagava 'wa na 'inanai bega 'wa na vo, Yama vona'awaufaufanina toketokena.’ Kebu 'wa na vo, 'A vona'awaufaufa abama mataneye,’ fai abamanina Yaubada yana veimea 'ana didiga 'ai'aiwabuna. ");
INSERT INTO yml_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Wata kebu 'wa na vo, 'A vona'awaufaufa fwayafwaya mataneye,’ fai fwayafwayanina Yaubada yana 'eba ba. Wata kebu 'wa na vo, 'A vona'awaufaufa Ielusalema mataneye,’ fai Ielusalemanina Kini bwaikina yana 'atamana. ");
INSERT INTO yml_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wata kebu 'wa na vo, 'A vona'awaufaufa 'unu'unuma 'waidiega,’ fai 'ai'edi nava'au 'akonadi i na buduliga kebu 'ana fata 'wa na vona i na ve'wau'wauga, we'e 'ai'edi 'wau'waugina kebu 'ana fata 'wa na vona i na buduli. ");
INSERT INTO yml_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","'Ai'edi tamu nani mogitana 'wa na 'idewaiga 'wa na vo, E'e,’ we'e 'ai'edi kebu 'wa na 'idewaiga, 'wa na vonamo 'wa na vo, Kebu,’ we'e 'ai'edi tamu nani 'wainega 'wa na awaida igodi yami vona i na kiavetoketokei, sauluvanina i mai Seitani 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Wata Iesu i vonedi i vo, Veimea de'e 'akonadi 'wa 'asetai i vo, 'Ai'edi tamu aitoi matamu i na 'etomwanuya wata matana 'u na 'etomwanuya, we'e aitoi nigomu i na tutukadiaga wata nigona 'u na tutukadia.’ ");
INSERT INTO yml_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","We'e yau a na vonemi. 'Ai'edi aitoi ava'ai sauluvaga sakoina i na 'idewai 'waimuye, kebu nimana 'u na tutuliga. 'Ai'edi tamu tomogo 'ae'aemu 'amu 'atagiega i na nikeiga, wata tamu 'ae'aemu 'u na 'iyoyoeni i na nikei. ");
INSERT INTO yml_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","'Ai'edi tamu aitoi i na nuasako 'waimuye bega i na nawemu 'eba vonayavuga 'waineye, mulieta toveimea i na vonemu 'amu kalekoyega yamu sauluvanina faifaina 'u na tutula, siwe wata 'amu talauma 'u na veleni. ");
INSERT INTO yml_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","'Ai'edi tamu tomogo bani'odi kabemani i na lukakademu i na vo, Yaku kukua 'u na 'ewa ta na nago tamu 'atamana 'waineye, siwe kebu a na tutulimuga.’ Kebu faifaina 'u na nuavita, ma yamu sosoana wata 'u na vaganago tamu 'atamana 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","We'e 'ai'edi aitoi tamu ava'ai nuanuana i na velu'uiemuga, kebu 'u na veumokaiga, 'u na veleni. We'e 'ai'edi aitoi i na vo, Side naninina 'u na veleku bola a na vevilai,’ kebu 'u na ve'o'oleniga 'u na tauyeni. ");
INSERT INTO yml_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Veimea de'e 'akonadi 'wa 'asetai i vo, Emiavo 'wa na nuakalikaliedi, we'e 'ami gaviavo 'wa na vedumwe'ai'aiedi.’ ");
INSERT INTO yml_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","We'e yau a na vonemi. 'Ami gaviavo 'wa na nunuakalikaliedi wata egavo vita i velevelemiga faifaidi 'wa na vevelu'ui. ");
INSERT INTO yml_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bani'odi 'wa na vesauluvediga i lubwainemi 'omi Tamami abame natunavo. To'atumaina wata tosakona 'adi nuakalikali i vesala Yaubada 'wainega fai yana inala i kabukabu matatabumi faifaimi wata yana 'wei matatabumi i velevelemi. 'Omi wata bani'odi, egavo i vesauluva sakoina 'waimie, 'wa na nuakalikaliedi. ");
INSERT INTO yml_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","'Ai'edi egavo i nuakalikaliemiga kumanidiavo 'aisedi 'wa na nunuakalikaliedi, yami nuakalikalinina Yaubada kebu i na tutuliga, tomotoga fuedi wata takesi tolaugogona vivinagodi taiadi ediavo 'aise'avadi i nunuakalikaliedi. ");
INSERT INTO yml_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Emiavo 'aisedi 'waidie 'wa na vekaiwaga kebu nani bwaikinaga, tomotoga fuedi wata Yaubada 'ana tobavu taiadi yadi sauluva, ediavo 'aisedi 'waidie i vevekaiwa. ");
INSERT INTO yml_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","We'e 'omi i lubwainemi yami sauluva matatabuna 'atumai'avadi, bani'odi Tamami abame yana sauluva.” ");
INSERT INTO yml_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iesu i veifufu 'aila'a 'waidie i vo, 'Wa na 'i'isave'avinimi kebu tomotoga matadie 'wa na 'a'anivelena tovewekowekoma 'waidie 'ami subia faifaina. 'Ai'edi 'wa na 'a'anivelena tomotoga matadie, Tamami abame kebu 'ana tutula i na velemiga. ");
INSERT INTO yml_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","We'e mogitana i lubwainemi givagivayega 'wa na 'a'anivelena tomotoganidi nuanuadi 'aivaita 'waidie. Tovekali yadi 'anivelena ma 'adi evulega 'atamanafouye wata 'eba miava'auta nagedie, nuanuadi tomotoga fuedi i na 'isedi i na subiadi. Siwe a na vonemi, subianina 'asa'aiana 'adi tutulanina i 'e'ewa-vagaseni. ");
INSERT INTO yml_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","We'e 'omi, givagivayega tovewekowekoma 'wa na 'i'ivaisedi siwe kebu emiavo 'waidie 'wa na lu'ivonaga. Ava'ai givagivayega 'wa 'i'idewadiga 'akonadi Tamami i 'isemi nika i na tutulimi.” ");
INSERT INTO yml_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Wata Iesu i vo, 'Ai'edi 'wa na velu'uiga Yaubada 'waineye, kebu tovekali 'wa na saladiga. Nuanuadi bwaikina i na tovoi i na vevelu'ui 'atamanafouye wata 'eba miava'auta nagedie 'adi subia faifaina. Siwe a na vonemi, subianina 'asa'aiana 'adi tutula i 'e'ewa-vagaseni. ");
INSERT INTO yml_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","We'e 'omi, 'wa na vevelu'uiga, 'wa na luku 'wa na saiboda mulieta 'wa na velu'ui Tamami 'waineye taunina to'isagiva. Yami sauluva givagivadi matatabuna i 'asetadi bega i na tutulimi. ");
INSERT INTO yml_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","Egavo i 'odu'odu yaubada-vekavekali 'waidie kebu 'wa na saladi yami velu'ui 'wa na lumanamanawedi. Yadi nuanua i vo 'ako yadi velu'ui manamanawedi yadi yaubadavo i na nogaidi. We'e Tamami 'akonadi 'ami vita i 'asetadi mulieta faifaidi 'wa vevelu'ui. ");
INSERT INTO yml_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","'Wa na velu'uiga, side bani'odi 'wa na velu'uiedi, 'wa na vo, Tamama, 'u miamia abame. 'Omu magemagetamu, nuanuama tomotoga fuema 'a na ve'ililibuyemu. ");
INSERT INTO yml_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nuanuama 'u na veveimeyema. Nuanuama tomia fwayafwaya yamu nuanua 'a na 'i'idewadi, bani'odi tomia abama yamu nuanua i 'i'idewadi. ");
INSERT INTO yml_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nuanuama 'ama'ama 'u na velevelema 'aiata 'aitamogana 'aitamogana faifaidi. ");
INSERT INTO yml_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mali tomotoga i vesauluva sakoina 'waimeye 'a nuatavunidi, 'omu wata bani'odi yama sakona 'u da nuatavunidi. ");
INSERT INTO yml_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","'Eba sailubu 'waidie kebu 'u na tauyema, wata 'u na 'ita'ita'iema Tosakona 'wainega. Yamu veimea, yamu toketokena wata yamu 'ai'aiwabu, kebu i na 'a'avaga, i na 'eno-vagata. Vona mogitana yama nuanua bani'odi.’ ");
INSERT INTO yml_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Side bani'odi 'wa na vevelu'uiedi, fai 'ai'edi mali tomotoga sakona i na 'idewai 'waimie 'wa na nuatavunidiga wata Tamami abame yami sakona i na nuatavunidi. ");
INSERT INTO yml_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","We'e 'ai'edi kebu, wata Tamami kebu i na nuatavunimiga. ");
INSERT INTO yml_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tutuyanina 'wa na veve'udigana 'ani 'wainega bega yami velu'ui i na vetoketoke Yaubada 'waineye, kebu 'wa na vemaigisivilavila tovekali bani'odi. Nuanuadi maigidi i na lu'ufafedi bega mali tomotoga i na 'asetadi 'ani 'wainega i veve'udigana nika i na subiadi. Siwe a na vonemi, subianina 'asa'aiana 'adi tutula i 'e'ewa-vagaseni. ");
INSERT INTO yml_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","We'e 'omi, 'wa na veve'udigana 'ani 'wainega velu'ui i na vetoketoke faifaina, maigimi 'wa na luvunagidi wata 'wa na veinata bega kebu tamu aitoi i na 'i'isa'inanamiga. Tamami, kumanina kebu 'wa da 'ise'iseniga i na 'asetami, fai yami sauluva givagivadi matatabuna i 'asetadi bega i na tutulimi.” ");
INSERT INTO yml_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Wata Iesu i vonedi i vo, Side bei fwayefwayeye kebu kukua fuedi 'wa na luvea'wedi fai bola 'walu'walu i na 'ivesakoidi wata i na lu'wanabudulidi 'alo tovainago vanuga i na baia i na luku i na vinagodi. ");
INSERT INTO yml_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","We'e mogitana i lubwainemi nani 'atumaidi 'wa na luvea'wedi abame, bei kebu tamu 'walu'walu 'alo i na lu'wanabudulidi 'alo wata tovainago i na vinagodi. ");
INSERT INTO yml_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","'Wa na nuani, ava'aibe bei yami 'ai'aiwabu i na 'eno'enoviga, bei tutuya fuedi yami nuanua i na nunago. ");
INSERT INTO yml_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Side bani'odi. Matami bani'odi nuami 'ana mageta. 'Ai'edi nani 'atumaidi 'wa 'ise'isediga, nuami matatabuna magemagetadi. ");
INSERT INTO yml_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","We'e 'ai'edi nani sakoidi 'wa na 'ise'isediga, nuami matatabuna i na dudubalidi. 'Wa na vo 'ako dudubalanina 'asa'aiana mageta, we'e mogitana nuamie dudubala bwaikina. ");
INSERT INTO yml_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kebu 'ana fata tamu aitoi 'ana toveimea 'adi 'ailuga 'waidie i na folofolova. 'Ako tamu i na baileni we'e tamu i na nuakalikalieni. Wata tamu i na vedumwe'ai'aieni, tamu i na vematayakeyakeni. Kebu 'ami fata 'wa na vetofolova Yaubada wata kukua 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Fai kebu 'ami fata 'wa na vetofolova Yaubada wata kukua 'waidie, begaidi a na vonemi. Kebu 'wa na venuafouviga yami mia faifaina, voke 'ai'edi 'ani'ani wata walu'ai 'ami fata 'alo kebu, wata ava'aiega talauma 'wa na veluagai tomogomi faifaidi. 'Ani'ani wata talauma nani-'avo'avovo we'e yami mia 'ana 'atumaina nani bwaikina. ");
INSERT INTO yml_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Manuga 'wa na nuanidi, kebu i da bakubakulaga, kebu i da 'a'aile'waga wata kebu yadi bubuakaga, siwe Tamami abame i 'i'isave'avinidi. Ava'ai naniga bwaikina? Manuga 'alo 'omi? ");
INSERT INTO yml_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Begaidi kebu tamu nani faifaina 'wa na venuafouviga. Kebu tamu aitoi 'ana fata yana mia fwayefwayeye i na 'ivemanawei yana venuafouviga 'wainega. ");
INSERT INTO yml_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Awale talauma faifaina 'wa vevenuafouviga? 'Wa na nuani makavuvula yadi tabo. Kebu i da folofolova wata kebu 'adi talauma i da 'i'idewadiga siwe 'adi vaigavu 'atumaidi. ");
INSERT INTO yml_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","A na vonemi, Kini Solomoni tomogo 'ai'aiwabuna 'ana vaigavu 'atumaidi, we'e makavuvula 'adi vaigavu 'atumaiotogidi. ");
INSERT INTO yml_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mosomoso matatabuna nani-'avo'avovo, 'asiau ta 'ise'isedi we'e 'awa'awai i na tunudi i na 'alaidi siwe Yaubada i veve'wesenidi. We'e 'omi tamu nani bwaikina mataneye, mogitana ma 'ami nuanua i veve'wesenimi. Awale yami vetumagana Yaubada 'waineye mweadi? ");
INSERT INTO yml_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Begaidi naninidi faifaidi kebu 'wa na venuafouviga 'wa na vo, Ava'ai 'a na 'ani, 'alo 'a na yemu wata tomogoma 'a na talaumadi?’ ");
INSERT INTO yml_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yaubada 'ana tobavu naninidi nuanuadi bwaikina faifaidi i vevenuafouviga. We'e 'omi naninidi nuanuami, Tamami abame 'akonadi yami nuanua i 'asetadi. ");
INSERT INTO yml_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","We'e 'wa vevenuafouviga 'asa'aiadi, i lubwaineni nagami taunimi 'wa na tauyemi Yaubada i na veveimeyemi wata yami sauluva i na tonova mataneye, mulieta naninidi matatabuna i na velevelemi. ");
INSERT INTO yml_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Begaidi kebu ma yami venuafouviga 'wa na vo, 'Awa'awai ava'ai vitaga i na souyedi?’ Fai 'awa'awai 'ana vita tulina i lulukamata. 'Asiau 'ana vita 'asa'aiana 'ana 'etowava.” ");
INSERT INTO yml_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Wata Iesu i vonedi i vo, Kebu tomotoga yadi sauluva 'waidiega 'wa na 'idi, i na nunago Yaubada i na lu'idiemi. ");
INSERT INTO yml_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mali tomotoga 'wa na awavesakoyediga wata 'ami awavesako 'wa na veluagai yami awavesakonina 'ana 'isa'isa bani'odi. ");
INSERT INTO yml_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Awale iamu mataneye fwayafwaya nani siaiotogina 'u 'iseni faifaina 'u vonavona, we'e kebu 'u da nuaniga 'omu 'ibwalobwalo'u bwaikina matamuye? ");
INSERT INTO yml_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kebu 'ana nogaya 'atumaina 'ai'edi 'u na vo, Iaku, nuanuaku matamu i lufwaluyaga a na 'ewai,’ we'e 'omu taunimu matamuye 'ibwalobwalo'u bwaikina. ");
INSERT INTO yml_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","'Omu tovekali, 'u awavesako siwe wata sauluvanidi 'u 'i'idewadi. Nagami taunimu matamuyega 'ibwalobwalo'u 'u na 'ewai bega 'u na 'isadewa nika 'amu fata fwayafwaya nani saiotogina 'u na 'ewai iamu matanega. ");
INSERT INTO yml_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","'Ai'edi nani 'atumaidi 'ou'ou ta na velediga, bola i na 'ivekokovidi wata i na ovada. Wata bani'odi Yaubada yana Vona 'Atumaina kebu 'wa na 'aniveleneni 'ana tovedumwe'ai'ai 'waidie bola vita i na velemi. We'e 'ami fwasalu 'wa na tawediga bawe 'waidie bola i na vatuveyokeyokedi, wata bani'odi Yaubada yana vona 'atumaidi kebu 'wa na 'anivelenedi 'ana tovedumwe'ai'ai 'waidie fai i na venani-'avo'avovo. ");
INSERT INTO yml_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","'Wa na vevelu'ui bega Yaubada i na velemi, 'wa na lalaualaga 'wa na veluagai, 'wa na velutolitoliga i na nogayemi saiboda i na sibaleni. ");
INSERT INTO yml_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Vona mogitana, egavo i na vevelu'uiga Yaubada i na veledi, egavo i lalaualaga i na veluagai wata egavo i na velutolitoliga i na nogayedi saiboda i na sibaleni. ");
INSERT INTO yml_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","10","'Ai'edi natumiavo 'ani'ani i na velu'uiemi, kebu 'ana fata kileu 'wa na veledi, wata igana i na velu'uiemi, kebu 'o'olo 'wa na veledi. ");
INSERT INTO yml_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","'Omi tosakona siwe tutuya fuedi ava'ai natumiavo nuanuadi, nani 'atumaidi 'wa veleveledi, we'e egavo Tamada abame i na velu'uieni, mogitana yana 'anivelena 'atumaiotogidi i na veledi. ");
INSERT INTO yml_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","'Ai'edi ava'ai nuanuami tomotoga i na 'idewai 'waimie, 'omi wata bani'odi 'wa na 'idewai 'waidie. Vona de'e, veimea matatabuna wata tolu'ivonavo yadi ve, 'adi 'itava.” ");
INSERT INTO yml_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Wata Iesu i vonedi i vo, 'Edanina i nago abame siaina wata 'ana 'awa welilina begaidi kebu tomotoga fuedi beidimo i da luku mia-vagata i da veluagai. We'e 'edanina i nago 'ai-'ala'alase bwaikina wata 'ana 'awa bababana, beidimo tomotoga fuedi i lukuluku. Begaidi i lubwainemi 'wa na luku 'awa welilineamo. ");
INSERT INTO yml_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","'Wa na 'isa'isa i na nunago tolu'ivona-vekavekali i na vekaliemi. 'Awasasamie 'wa da vo bani'odi 'aisaya tauvanuga we'e mogitana 'aisaya kasikasisidi bani'odi. ");
INSERT INTO yml_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yadi sauluva 'waidiega 'wa na 'isa'inanadi tomotoga 'atumaidi 'alo sakoidi. 'Adi 'isa'isa side bani'odi. Kebu 'ana fata kalibo vuagina ta na kadia ulaulawa 'wainega wata kebu 'ana fata 'ala'ai vuagina ta na kadia 'uwe 'wainega. ");
INSERT INTO yml_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","'Ai'edi welavi 'atumaina wata vuagina 'atumaina, we'e welavi sakoina wata vuagina sakoina. ");
INSERT INTO yml_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kebu 'ana fata welavi 'atumaina we'e vuagina sakoina, wata kebu 'ana fata welavi sakoina we'e vuagina 'atumaina. ");
INSERT INTO yml_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","We'e welavinidi kebu i da vuavuaga-'atumai matatabuna i na talagidi wata i na valo'udi mulieta i na tunudi i na 'alaidi. ");
INSERT INTO yml_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Begaidi 'ami fata tolu'ivonanidi 'wa na 'isa'inanadi yadi sauluva 'waidiega. ");
INSERT INTO yml_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Wata kebu 'wa na vo 'ako tomotoganidi i ve'awa-'Auvea 'waikuye matatabudi i na luku abame, Yaubada yana 'Eba Veimea 'waineye. Kebu, we'e mogitana egavo Tamaku abame yana nuanua i na vevematayakeyakedi, kumanidiavo i na luku. ");
INSERT INTO yml_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","'Awaie Vonayavuga 'ana 'Aiata 'waineye fuedi i na maia 'waikuye i na vo, 'Auvea, 'Auvea, 'amu wagavayega Yaubada yana Vona 'a lu'ivona mali tomotoga 'waidie wata 'amu wagavayega 'a vona yaiaina i 'awa'a'idi we'e 'ifwaidi tomotoga matadie 'eba nuavogana wata 'eba nua'ewa fuedi 'a 'idewadi.’ ");
INSERT INTO yml_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Siwe yau a na vo, 'Omi tosakona, 'wa vaganago, kebu tamu sai'afo a da 'aseta-tonovimi.’” ");
INSERT INTO yml_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Wata Iesu i vonedi i vo, Vonanidi 'akonadi a veifufuyediga egavo i na nogaidi i na vematayakeyakediga, taunidi bani'odi to'aiyogona vanuga ma yana nuamageta. To'aiyogonanina nagami kabutu'u 'atumaina i venua'ivineni, 'ogola fa'alidi i 'ewadi wata ovu manamanawedi i aladi bega yana vanuga matatabuna i yogoni. ");
INSERT INTO yml_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tutuyanina 'wei i 'wei, wayagata i obu, kaukau toketokena i nunuga vanuganina kebu i da 'etofoia fai vanuga fa'alina i yogoni 'ogola 'atumaidi 'waidiega. ");
INSERT INTO yml_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","We'e egavo yaku vona i na nogaidi siwe kebu i na vematayakeyakediga, taunidi bani'odi tamu to'aiyogona kebu ma yana nuamageta. To'aiyogonanina kabutu'u sakoina i venua'ivineni nidule i 'aiyogona. ");
INSERT INTO yml_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tutuyanina 'wei i 'wei, wayagata i obu wata kaukau toketokena i nunuga vanuganina i 'etofoia, matatabuna i 'ivesakootogi.” ");
INSERT INTO yml_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Tutuyanina Iesu yana venidi i ve'a'avadi, 'aila'a bwaikina nuadi i voganidi fai ma yana veimea i veve 'waidie, kebu bani'odi yadi ve'etoboda 'adi tovevo. ");
INSERT INTO yml_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu yana ve i 'a'ava, 'oyayega i obuma wata tomotoga fueotogidi i yogo'waili. ");
INSERT INTO yml_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","We'e tamu tomogo i mai 'ana viga sakoina 'eba kololo tomogona i velufo'afo'ana, ma yana ve'ililibu i 'odu Iesu mataneye i vo, 'Auvea, 'ai'edi nuanuamu 'amu fata 'u na 'ive'atumaiku.” ");
INSERT INTO yml_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu toviganina i 'abitonovi i vo, Fai bani'odi nuanuaku, 'u ve'atumai.” Nika tomogonina 'ana viga i 'a'ava i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bega Iesu i voneni i vo, Kebu tamu aitoi 'waineye 'u na lu'ivonaga, nuanuaku tonovimu 'u na nago tovelomu 'waineye, nagami i na 'isemu. Mulieta yamu velomu 'u na 'aniveleneni bani'odi veimeanina i mai Mosese 'wainega toviganina i ve'atumaiga faifaina. Tovelomunina i na 'isemu i na ve'awamogitana 'akonadi 'u ve'atumai wata bani'odi mali tomotoga i na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu i nago 'atamana Kafaneomi, bei tamu Loma tolugavia 'adi to'edakumeta i veluagai, tolugavianina i velu'ui Iesu 'waineye 'aivaita faifaina. ");
INSERT INTO yml_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","I vo, 'Auvea, yaku tofolova i miamia vanuge, 'asa'aiana 'ivie i 'eno'enomo i veveviga bwaikina.” ");
INSERT INTO yml_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu i vo, Ta na nago a na 'ive'atumaia.” ");
INSERT INTO yml_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Siwe tolugavianina Iesu yana vona i tutuli i vo, 'Auvea, yau tomogo-'avo'avovo, kebu i da lubwainemu 'u na luku yaku vanuge. 'U na vonamo nika yaku tofolova i na ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","A 'asetai ma yamu veimea bega 'amu fata 'u na 'ive'atumaia. Yau wata ma yaku veimea yaku tolugavia 'waidie 'aku fata a na vo, 'U nago,’ nika i na nago, wata a na vo, 'U mai,’ nika i na mai, wata yaku tofolova a na voneni a na vo, Side 'u 'idewai,’ nika i na 'idewai. Wata yau bani'odi, yaku to'edakumetavo yadi veimea a vevematayakeyakedi. 'Omu wata ma yamu veimea 'u na vonamo nika viga i na 'a'ava.” ");
INSERT INTO yml_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tutuyanina Iesu toveimea yana vonanina i nogai, nuana i vogani 'aila'anidi i yoyogo'wailiga i vonedi i vo, De'e Loma 'ana tomotoga siwe yana vetumagana toketokena. We'e 'omi me Isileli Yaubada yana tomotoga, siwe kebu bani'odi vetumagananina a da veluagai 'waimie. ");
INSERT INTO yml_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A na vonemi, 'awaie tomotoga fuedi i na maia 'awalawa tulina tulina 'waidiega, inala yana 'eba lakayega wata yana 'eba inivayega, ma fuedie i na luku Yaubada yana 'Eba Veimea nageneye bega Ebelamo, Aisake wata Iakobo taiadi i na 'aniluvetubama. ");
INSERT INTO yml_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","We'e tomotoganidi igodi i vo, 'Ima Yaubada natunavo,’ i na tawedi tanotanoge dudubala 'waineye, bei i na 'we'we'wela wata maigidi i na yuyuyudi fai veviga bwaikina.” ");
INSERT INTO yml_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mulieta Iesu i vona tolugavianina 'waineye i vo, 'U na nago yamu vanuge, naninina faifaina 'u vetumagana, mogitana i na souyeni 'u na 'iseni.” Iesu i vona'a'ava nika 'awasasanina 'waineye tofolovanina i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tamu tutuya Iesu i nago Fita yana vanuge. Bei Fita yana vavine inadi i 'isedi tomogodi i luyauyauta 'ivie i 'eno'eno. ");
INSERT INTO yml_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesu nimadie i 'abi, yauyautanina i 'awatagoni i tovoi Iesu 'ana'ana i 'idewadewa. ");
INSERT INTO yml_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","I lavia tomotoga ediavo yaiaina i agediga i miedi Iesu 'waineye. Iesu i vona yaiaina i 'awa'a'idi wata toviga matatabudi i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yana 'ive'atumainina toviga 'waidie, Aisea yana vona-samula faifaidi 'ana mogitana i souyeni. Taunina tamu 'Auvea yana tolu'ivona basenadiotoga i kilumi i vo, Taunina 'aiseotogina 'ada viga i 'ewadi wata yada veviga i 'ewayavuledi.” ");
INSERT INTO yml_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesu tomotoga fueotogidi i tovififineni i 'isedi i vona yana tovetutuyamavo 'waidie i vo, Ta na damana lavu vi'ainega.” ");
INSERT INTO yml_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nika bei tamu me Diu yadi ve'etoboda 'adi tove i mai Iesu 'waineye i vo, Tove, yau 'akonadi a tauyeku 'waimuye 'ai'edi ava'aibe bei 'u na nunagoga yau taiadi.” ");
INSERT INTO yml_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu tomogonina yana vona i tutuli i vo, 'U na nuani 'ou'ou walawala'ai ma 'adi ovu, manuga ma 'adi giuva, we'e yau a vetomotogaotoga kebu yaku vanuga bei a na 'eno 'alo a na veawai.” ");
INSERT INTO yml_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wata tamu tomogo, kumanina tovetutuyama, i mai i vona Iesu 'waineye i vo, 'Auvea taiadi ta da nago, siwe nuanuaku a na miamia nagami tamaku a na ve'ufai mulieta a na wai a na vetutuyamemu.” ");
INSERT INTO yml_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Siwe Iesu i vo, 'Omu 'asiau taiadi ta na nago 'u na vetutuyameku, we'e kumanidiavo 'anu'anunudi wafawafadi, taunidi yadi towafa i na veve'ufadi.” ");
INSERT INTO yml_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesu yana tovetutuyamavo taiadi wakeye i dodoga i tauya. ");
INSERT INTO yml_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","I nunagoi nika kaukau toketokena i nunuga yagina waka i ludododogi, we'e Iesu i 'eno'eno. ");
INSERT INTO yml_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iesu yana tovetutuyamavo i luvagovagoni i vo, 'Auvea 'u 'ita'ita'ieda, sai'afoga ta na wafa.” ");
INSERT INTO yml_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iesu i 'isa i vonedi i vo, Awale 'wa kololo? 'Omi yami vetumagana mweadi.” Bega i tovoi kaukau wata yagina i talabodedi nika i niwalova. ");
INSERT INTO yml_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","We'e yana tovetutuyamavo matatabudi nuadi i voganidi i vo, Aitoi tomogoga de'e? Nani matatabuna wata yagina kaukau taiadi bonana i vematayakeyakeni.” ");
INSERT INTO yml_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iesu ma enavo i damana lavu vi'ainega 'awalawa Gegesa. Bei tomotoga 'adi 'ailuga i veluagadi, yadi 'eba mia taumata 'awasasadie. Basenadi yaiaina i agedi bega toketokedi, begaidi tomotoga matatabudi i kololoyedi 'edanina 'waineamo kebu i da nunagoi. ");
INSERT INTO yml_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tutuyanina Iesu i 'iseni i vegolegole i vo, 'Omu Yaubada Natuna, ava'ai 'u na 'idewai 'waimeye? 'U maiga 'ama 'ivekokova faifaina? Siwe vematavuloga 'ana tutuya bola.” ");
INSERT INTO yml_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Sai'afo 'ani'ie bawe fatala bwaikina i luluduaduala begaidi yaiainanidi i taidaida Iesu 'waineye i vo, 'Ai'edi nuanuamu 'u na vona 'a na 'awa'a'ima, 'u da tauyema sino bawenidi 'a da agedi.” ");
INSERT INTO yml_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iesu i vonedi i vo, 'Asa'aiana 'wa souyemi 'wa nagoi.” Iesu yana voneye yaiainanidi i 'awa'a'idi i nagoi bawe i agedi fatala matatabuna i ve'ilililide 'oyeamo i obu nika i sou bwagale i ve'alamonumonu lavuye. ");
INSERT INTO yml_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","We'e bawe 'adi to'isave'avinavo i 'iseni i lilide i nagoi 'atamane, bei nani matatabuna i veifufuyedi wata Iesu tomotoganidi i 'ive'atumaidiga faifaina i veifufu. ");
INSERT INTO yml_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bega 'atamananina 'ana tomotoga matatabuna i nagoi Iesu 'waineye, i veugeugeni kebu i na miamia yadi 'awalaweye. ");
INSERT INTO yml_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Me Gegesa Iesu i veugeugeni bega i dodoga wakeye i viladi i damana Kafaneomi, taunina yana 'atamane. ");
INSERT INTO yml_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","We'e tomotoga 'ifwaidi tamu iadi bwalobwalokona ma 'evo'evona i evai i mieni bega Iesu i na 'ive'atumaia. Iesu i 'isedi i 'asetai ma yadi vetumagana bega tomogonina i voneni i vo, Iaku, kebu 'u na kolologa, yamu sakona 'akonadi a nuatavunidi.” ");
INSERT INTO yml_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","We'e 'ifwaidi ve'etoboda 'adi tovevo yadi nuanua i vo, Tomogo de'e i vona-uvi'agala Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu yadi nuanua i 'asetadi i vonedi i vo, Awale nuanua sakoidi nuamie i 'eno'enovi? ");
INSERT INTO yml_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","'Aku fata tomogonina a na voneni a na vo, Yamu sakona a nuatavunidi,’ wata 'aku fata a na vo, 'U tovoi 'u nago.’ 'Wa da nuani, ava'ai vonaga safailina? ");
INSERT INTO yml_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Siwe a na vemi yau a vetomotogaotoga ma yaku veimea fwayefwayeye bega 'aku fata tomotoga yadi sakona a na nuatavunidi.” Nika Iesu tomogo bwalobwalokona i voneni i vo, 'U tovoi, 'amu 'evo'evo 'u evai 'u nago yamu vanuge.” ");
INSERT INTO yml_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iesu yana voneye tomogonina i tovoi i nago yana vanuge. ");
INSERT INTO yml_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tutuyanina 'aila'a i 'iseni i kololo nika Yaubada i subiai i vo, Vona mogitana, veimea bwaikina i 'aniveleneni tomogonina 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Bei tomogo i 'ive'atumaiaga Iesu i 'iaweni, i nunagoga nika takesi 'ana tolaugogona 'ana wagava Madiu i 'iseni yana 'eba folova 'waineye i miamia. Iesu i voneni i vo, 'U mai taiadi ta na nago yaku tovetutuyama,” nika Madiu i tovoi Iesu taiadi i nago. ");
INSERT INTO yml_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mulieta Iesu ma yana tovetutuyamavo i 'ani'ani Madiu yana vanuge, nika takesi 'ana tolaugogona fuedi wata 'ifwaidi tosakona i mai ma fuedie i 'ani. ");
INSERT INTO yml_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","We'e 'ifwaidi Diu totafalolo Falisi i 'isedi i nagoi Iesu yana tovetutuyamavo i velutoliedi i vo, Awale yami tove takesi tolaugogona vivinagodi wata 'ifwaidi tosakona taiadi i 'ani?” ");
INSERT INTO yml_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu yadi vona i nogai i vona-awatabai 'waidie i vo, Egavo 'atumaidi kebu nuanuadi viga 'adi to'ive'atumai, 'aisedi toviga mogitana. ");
INSERT INTO yml_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","We'e 'omi 'wa na nagoi tamu Yaubada yana vona yana Buki nageneye 'wa na 'iseni 'ana 'aseta 'wa na venua'ivineni. Vonanina side bani'odi i vo, 'Aisaya 'wa nikenikedi 'wa vevelomuyediga 'waikuye, kebu nuanuaku. Nuanuaku tomotoga 'wa na 'i'isanuakalikaliedi.’ We'e yau a maiga kebu taunidi i awave'atumaiediga faifaidi, a maiga tosakona a na 'ita'ita'iedi.” ");
INSERT INTO yml_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mulieta Ioni Tobafitaiso yana tovetutuyamavo i maia Iesu 'waineye i velutolieni i vo, 'Ima wata totafalolo Falisi tutuya fuedi 'ani 'wainega 'a veve'udigana bega yama velu'ui i na vetoketoke Yaubada 'waineye, we'e yamu tovetutuyamavo awale 'ani 'wainega kebu i da veve'udiganaga?” ");
INSERT INTO yml_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu yadi vona i tutuli, taunina faifaina i vona-awatabai i vo, Tonagi yana sosoana 'waineye kebu tamu aitoi 'ana fata i na vemogai. We'e tamu 'aiata tomotoga 'ifwaidi i na maia tonaginina i na 'ive'avini, i na naweni i lubwainedi enavo ma yadi nuavita i na veve'udigana.” ");
INSERT INTO yml_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wata Iesu i awatalatutula 'waidie yana ve sauluva 'ivauna faifaina wata me Diu yadi sauluva tuatuaina 'adi luwanawana faifaidi i vo, 'Ai'edi talauma tuatuaina i na 'anilabu'i we'e kaleko 'ivaunega ta na bwadia, kebu i da lubwaineni. Fai bola ta na lekoai bwadi 'ivauna i na vesiai bega i na vefato'ai'ai tuatuaina i na 'ivesakoi.” ");
INSERT INTO yml_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wata bani'odi oine 'ana ba'ala 'aisaya bunudiega faifaina Iesu i vona i vo, 'Ai'edi oine 'ivauna ba'ala tuatuaina 'waineye i na iwagiga i na yuvefuai, i na iwaga 'ana ve'amubwadodo fai aya'aina wata ba'ala 'akonadi i sako. We'e 'ai'edi oine 'ivauna wata ba'ala 'ivauna bikana, i lubwaineni kebu i na yuvefuai, 'ailugana 'atumaidi.” ");
INSERT INTO yml_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tutuyanina Iesu i veve tomotoga 'waidie, nika me Diu yadi 'eba miava'auta 'ana to'edakumeta tamu i le'wa. I mai ma yana ve'ililibu Iesu mataneye i 'odu i voneni i vo, Natuku vevinena 'asiauotoga yawaina i 'a'ava, nuanuaku ta na nago nimamu 'u na yatoi 'waineye i na yawasa.” ");
INSERT INTO yml_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu i nogai, bega i tovoi i nunagoga yana tovetutuyamavo i yogo'waili. ");
INSERT INTO yml_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","22","I nunagoiga, tamu vavine wata mulidie i nago. Vavinenidi vevine 'adi viga i 'ewadi, malamala 12 nagedie kebu i da 'a'ailove viganina i 'eno'eno. Yadi nuanua 'waineye i vo, 'Ai'edi 'ana talauma'ava 'a na 'abitonovimo 'a 'asetai 'a na ve'atumai.” Bega i vaganago Iesu muliotogineye 'ana talauma mataifwana i 'abitonovi, nika Iesu i sivilai i 'isedi i vonedi i vo, Natuku, kebu 'wa na kolologa, yami vetumagana 'waikuye i 'ive'atumaimi.” Iesu yana voneye nika i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tutuyanina Iesu i le'wa to'edakumetanina yana vanuge, tomotoga fuedi i 'isedi bonadi bwaikina i vevemogai we'e 'ifwaidi i 'umo'umo yadi sauluva bani'odi. ");
INSERT INTO yml_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Bega Iesu i vonedi i vo, Matatabumi 'wa souyemi, kwamana vevinena de'e kebu i da wafaga, i 'eno'enomo.”'Aila'a i 'asetai kwamananina mogitana i wafa begaidi Iesu i sidibidibieni wata i namageni. ");
INSERT INTO yml_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tutuyanina tomotoga i yavula Iesu i luku kwamananina yana tutudaba 'waineye, nimaneye i 'abi nika i tovoi. ");
INSERT INTO yml_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tovemogainidi i 'iseni, i nagoi kwamana yana yawasa-vaitugana valana i veifufuyeni yadi 'awalawanina nageneye bega tomotoga matatabudi i 'asetai. ");
INSERT INTO yml_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Bei kwamana i 'ive'atumaiaga, Iesu i 'iaweni i nunagoga tomatasako 'adi 'ailuga mulineye i nagoi i vevegolegole i vo, 'Omu Yaubada 'ana Venua'ivina, Kini Devida tubuna, 'u da 'isanuakalikaliema.” ");
INSERT INTO yml_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iesu i mai i luku vanuge nika wata 'adi 'ailuga i mai i luku 'waineye bega Iesu i velutoliedi i vo, Mogitana 'wa vetumaganeku bega a na 'ive'atumaimi 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","30","Tomatasakonidi i vo, E'e 'Auvea,” bega Iesu matadi i 'abitonovidi i vonedi i vo, Yami vetumagana 'wainega matami i na ve'atumai,” nika i 'isadewa. Iesu i toke i vonedi i vo, Matami a 'ive'atumaidiga kebu tamu aitoi 'wa na voneniga.” ");
INSERT INTO yml_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Siwe i tauya i nagoi i lu'ivo'ivona yadi 'awalawanina matatabuna nageneye. ");
INSERT INTO yml_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tomotoganidi matadi i ve'atumaiga i tauya i nunagoi, tomotoga 'ifwaidi tamu iadi i mieni, tomogonina basenadi yaiaina i agei 'awana i ve'ebo'ebo bega kebu 'ana fata i na welava. ");
INSERT INTO yml_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iesu i vona yaiaina i 'awa'a'ia nika tomogo i welava. Tomotoga i 'iseni, nuadi i voganidi i vo, Kebu tamu tutuya nani de'e bani'odi ta da 'iseniga yada 'awalawa de'e Isileli nageneye.” ");
INSERT INTO yml_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","We'e totafalolo Falisi i vo, Seitani, yaiaina yadi to'edakumeta i agei yana toketokena i veleni bega i vonavona yaiaina i 'a'awa'a'idi.” ");
INSERT INTO yml_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu i lauvivila i nago 'atamana bwaikidi wata siaidi 'waidie i veve 'eba miava'auta nagedie. Vala 'Atumaina Yaubada yana veimea faifaina i lalau'age, wata tomotoga fuedi 'adi viga tulina tulina i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","'Aila'a i 'isedi, i 'isanuakalikaliedi fai 'adi vita fuedi wata kebu i da 'asetadi bani'odi i na munega 'alo ava'aiega 'aivaita i na veluagai, 'wa da vo bani'odi sifi kebu 'adi to'isave'avinaga. ");
INSERT INTO yml_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iesu yana tovetutuyamavo i vonedi i vo, Tomotoga fuedi i da luku Yaubada yana 'Aila'a 'waineye 'wa da vo bani'odi tutuya 'aile'wa, siwe tofolova kebu fuediga. ");
INSERT INTO yml_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Begaidi 'wa na velu'ui 'Auvea 'waineye, kumanina 'wa da vo 'aile'wa 'ana toveimea bega tofolova fuedi i na vetunedi 'ana talage tomotoga i na mimaiedi Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu yana tovetutuyamavo 'adi 12 i goleva'augidi, veimea i veledi bega yaiaina i na vonedi i na 'awa'a'idi wata toviga 'adi viga tulina tulina i na 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tomata'aulelevo 12 side 'adi wagava: yadi to'edakumeta Saimoni, tamu 'ana wagava Fita, Anidulu, Saimoni taina, Iemesa ma taina Ioni kumanidiavo Sebedi natunavo, ");
INSERT INTO yml_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filifi, Batolomiu, Tomasi, Madiu, taunina takesi 'ana tolaugogona, Iemesa, Alefasi natuna, Tadiusa, ");
INSERT INTO yml_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimoni, toawa'idi'idi kebu nuanuana Loma kabemani i na veveimeyedi, Iudasa Isakaliota, kumanina Iesu 'ana to'etogiluva. ");
INSERT INTO yml_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu yana tomata'aulelevo 12 i vetunedi yana vona i na lau'age-vuvueni bega i velu'ase'asedi i vo, Mali tomotoga kumanidiavo kebu Diu wata me Samelia 'waidie kebu 'wa na nagoiga. ");
INSERT INTO yml_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nuanuaku 'wa na nagoi me Isileli 'aisedi 'waidie, taunidi vuyovuyodi 'wa da vo 'aisaya sifi. ");
INSERT INTO yml_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","'Wa na lau'age 'waidie 'wa na vo, Yaubada yana veimea i souyeni 'awasasamie.’ ");
INSERT INTO yml_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Toviga 'wa na 'ive'atumaidi, towafa 'wa na sivetovoidi, tomotoga tomogodi i velufo'afo'ana 'wa na vona i na ve'atumai wata egavo yaiaina i agediga, 'wa na vona i na 'awa'a'idi. Veimea ma yana toketokena a velemi kebu ma 'ana tutulaga, 'wainega 'wa na 'aivaita kebu tutula 'alo fu'e faifaidi 'wa na nuanua. ");
INSERT INTO yml_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Wata a na vonemi, 'wa na nunagoiga side naninidi kebu 'wa na 'ewadi 'wa na nawedi, mani golida wata siliba, venuana, 'ageyafayafa, talauma 'ana veluga wata wautogana. Naninidi faifaidi kebu 'wa na nuanua, fai tofolova i lubwainedi ma 'adi 'aivaita. ");
INSERT INTO yml_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","'Ai'edi 'wa na le'wai 'atamana bwaikidi 'alo siaidi 'waidie, 'wa na lauala tamu tomogo yana nuanua 'atumaina 'wa na veluagai, taiadi 'wa na miamia, mulieta yami folova i na 'a'ava 'atamananina 'waineye, vanuganina 'wa na 'iaweni. ");
INSERT INTO yml_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tutuyanina vanuganina 'waineye 'wa na lukuga vanuganina 'ana tomia 'wa na vona-nuakalikaliedi 'wa na vo, Kaiwa, ma yami sosoana 'wa na miamia, Yaubada i na vesauluva-'atumai 'waimie.’ ");
INSERT INTO yml_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","'Ai'edi vanuganina 'ana tomotoga ma yadi sosoana i na 'i'isave'avinimi, yami vona nuakalikalinina i na 'eno'eno 'waidie. We'e 'ai'edi kebu, yami vona nuakalikalinina i na vilai 'waimie, ma'itufa Yaubada i na vesauluva 'atumaina 'waimie. ");
INSERT INTO yml_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","'Ai'edi ava'ai vanugaga 'alo 'atamanaga 'adi tomotoga i na vedumwe'ubu'ubusemi wata yami vona kebu i na nogaidiga, 'wa na 'iawedi. Tutuyanina 'wa na tauya, 'agemiega fwayafwaya 'wa na lubutubutuya, yadi 'eba 'isa 'wainega i na 'asetai 'awaie vematavuloga i na veluagai Yaubada 'wainega. ");
INSERT INTO yml_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A vona mogitana 'waimie, 'awaie Vonayavuga 'ana 'Aiata 'waineye me Sodoma wata me Gomola 'adi vematavuloga i na veluagai Yaubada 'wainega siwe sai'afo i na 'isanuakalikaliedi, we'e tomotoganidi i na vedumwe'ai'aiemiga 'adi vematavuloga bwaikaotogina i na veluagai 'aiatanina 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","A na vonemi, 'ou'ou walawala'ai sifi i ovaovadi, wata bani'odi a vevetunemi tomotoga kasikasisidi 'waidie vita i na velevelemi. Begaidi i lubwainemi ma yami nuamageta taunimi 'wa na 'isave'avinimi we'e yami sauluva i na bika bunebune bani'odi. ");
INSERT INTO yml_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","'Wa na 'isa'isa fai 'omi 'wa na vetolu'ivona faifaiku, tomotoga 'ifwaidi i na 'ive'avinimi i na nawemi yadi kaniselavo 'waidie, wata 'eba miava'auta 'waidie i na toke i na fitalimi. ");
INSERT INTO yml_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Fai 'omi yaku tofolova begaidi 'wa na vonayavuga toveimea bwaikidi wata kini 'waidie. Siwe tutuyanina 'waineye 'ami fata Vala 'Atumaina faifaiku 'wa na lu'ivoneyeni 'waidie, wata mali tomotoga kumanidiavo kebu Diu 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tutuyanina i na 'ive'avinimiga kebu 'wa na venuafouviga 'wa na vo, Ava'ai ta na veifufuyedi, 'alo bani'odi ta na voneyedi,’ fai tutuyanina 'waineye Yaubada i na awave'ede'edemi. ");
INSERT INTO yml_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bega vonanidi 'waidiega 'wa na vonavona kebu taunimi yami vona, Tamami 'Anu'anununa 'waimiega i na vonavona. ");
INSERT INTO yml_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tomotoga fuedi yaku tomotoga i na vedumwe'ai'aiemi, 'ifwaidi tomotoga taidiavo 'alo tatadiavo i na 'anivelenedi 'aku tovedumwe'ai'ai 'waidie i na luvewafadi. We'e tama 'ifwaidi natudiavo i na 'anivelenedi i na luvewafadi, wata yavayavava tamadiavo inadiavo taiadi i na vegaviedi bega i na wafa. ");
INSERT INTO yml_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Fai 'wa vetumagana 'waikuye begaidi tomotoga fuedi i na vedumwe'ai'aiemi, siwe egavo i na tokemaigedi i na nagoga tutuya 'eba ve'a'ava 'waineye 'ita'ita'i i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","'Ai'edi tamu 'atamana 'waineye vita i na velevelemiga 'wa na dega 'wa na nagoi tamu 'atamana 'waineye. Siwe a vona mogitana 'waimie, yami folovanina bola kebu 'wa na ve'a'avaiga, bola 'wa na lalauvivila me Isileli yadi 'atamana 'waidie, yau a vetomotogaotoga a na vilaku a na mai. ");
INSERT INTO yml_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kwamana yana 'aseta kebu yana tove yana 'aseta i da vebwaika-'iaweni wata tofolova 'ana toveimea kebu i da vebwaika-'iaweni. ");
INSERT INTO yml_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Begaidi 'ai'edi tove 'alo toveimea vita i na veluagadi, mogitana wata yadi kwakwamavo vitanidi i na veluagadi. 'Aila'anina 'waineye ta miamiani yau 'ana to'edakumeta siwe 'aku tovedumwe'ai'ai i awavesakoyeku i vo, 'Omu Seitani, yaiaina yadi to'edakumeta.’ Yau i awavesakoyeku we'e 'omi yaku 'aila'avo i na awavesako-otogemi. ");
INSERT INTO yml_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Vita i na velevelemi, siwe kebu 'wa na kololoyediga. 'Awaie naninidi tomotoga i givediga, matatabuna Yaubada i na sivemagesedi. Naninidi i nuagivediga, Yaubada i na lu'ivoneyedi. ");
INSERT INTO yml_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","'Aise'avami 'waimie a veveifufuga 'wa da vo dudubale, we'e 'omi 'wa na sivemagesedi 'aila'a 'waidie. Ava'ai ve'awayaya 'wainega 'wa nogaiga, 'atamanafouye 'wa na vetuleleyeni. ");
INSERT INTO yml_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Egavo nuanuadi i na luvewafamiga kebu 'wa na kololoyedi, 'adi fata tomogo'avami i na luvewafadi siwe 'anu'anunumi kebu. We'e mogitana ma yami ve'ililibu Yaubada 'wa na kololoyeni, 'ana fata tomogomi wata 'anu'anunumi taiadi i na luvewafadi 'ai-'ala'alata kebu yana 'weuga 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","'Ai'edi manudanidani 'ailuga ta na kimwanediga, 'adi tutula siaina, bani'odi kileu 'aitamogana. We'e Yaubada mataneye manudanidani 'aitamogana 'aitamogana kebu nuana i da fani, kebu 'ana fata tamu i na wafa nagami Tamami i na tauyeni. ");
INSERT INTO yml_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wata bani'odi, 'omi mataneye nani bwaikina i 'aseta'a'avami bani'odi nava'au matatabuna 'adi 'aila'a i 'asetadi. ");
INSERT INTO yml_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Begaidi kebu 'wa na kolologa, 'omi kebu nani-'avo'avovo manudanidani bani'odiga, 'omi nani bwaikina Yaubada mataneye i na 'i'isave'avinimi. ");
INSERT INTO yml_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","'Ai'edi aitoi i na lu'ivona tomotoga 'waidie faifaiku i na vo, Yau a tauyeku Iesu 'waineye taunina 'aku Toveimea,’ wata 'awaie abame bani'odi Tamaku mataneye a na vo, No'o tomotoganina yaku 'aila'a.’ ");
INSERT INTO yml_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","We'e 'ai'edi aitoi i na ve'eweku tomotoga 'waidie i na vo, Iesu kebu 'aku Toveimeaga,’ wata 'awaie abame Tamaku mataneye a na ve'eweni a na vo, No'o tomotoganina kebu yaku 'aila'aga.’” ");
INSERT INTO yml_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Wata Iesu i vonedi i vo, 'Ifwaimi yami nuanua a maiga bega tomotoga matatabumi 'wa na veveiaiana. Siwe kebu. A maiga 'wainega tomotoga tauni'avadi i na ve'alamagi'ai wata ve'idi'idi i na souyeni. ");
INSERT INTO yml_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","'Ifwaidi yaku vona i na vetumaganeni, we'e 'ifwaidi i na vedumwe'ai'ai, begaidi tomogo natuna tamana i na vegavieni wata vavine natudi vevinena inana i na vegaviedi. We'e vavine lawana vevinedi taiadi i na vegavia faifaiku. ");
INSERT INTO yml_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wata tomotoga 'adi gaviavo mogitana tauniotogidi yadi 'aila'a 'waidiega. ");
INSERT INTO yml_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","'Ai'edi aitoi tamana 'alo inana 'adi nuanua 'waineye i na vebwaika, we'e yau 'aku nuanua i na vesiai kebu 'ana fata i na vetutuyamekuga. Wata 'ai'edi aitoi natuna iavetana 'alo vevinena 'adi nuanua 'waineye i na vebwaika, we'e yau 'aku nuanua i na vesiai, kebu 'ana fata i na vetutuyamekuga. ");
INSERT INTO yml_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","'Ai'edi aitoi nuanuana mogitana i na mai 'waikuye, nagami taunina yana nuanua i na bailedi. Fai i na vematayakeyakeku veviga bwaikina i na veluagai yau bani'odi a na veluagai. Voke i na wafa faifaiku yau bani'odi a na wafa 'ai lagalagana 'waineye. 'Ai'edi aitoi kebu bani'odi i na vesauluvediga, taunina kebu 'aku tovetutuyama. ");
INSERT INTO yml_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","'Ai'edi aitoi yana mia 'ana 'atumaina i na ve'o'oleni, kebu nuanuana yawaina i na tauyeni faifaiku, taunina i na wafaotoga. We'e 'ai'edi aitoi yana mia 'ana 'atumaina wata yawaina i na tauyedi faifaiku mia 'atumaina wata miamia-vagaina i na veluagai.” ");
INSERT INTO yml_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wata Iesu i vonedi i vo, 'Omi yaku tovetutuyamavo 'ai'edi aitoi ma yana nuakalikali i na 'ivaisemi siwe 'asa'aiana yau i 'ivaiseku, we'e 'ai'edi ma yana nuakalikali yau i na 'ivaiseku, siwe 'asa'aiana Yaubada taunina 'aku tovetune i 'ivaiseni. ");
INSERT INTO yml_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","'Ai'edi aitoi Yaubada yana tolu'ivona i na 'ivaiseni fai taunina Yaubada yana tofolova, 'awaie ma fuedie 'adi tutula i na vesala. Wata 'ai'edi aitoi tamu tomogo i na 'ivaiseni fai tomogonina yana sauluva tonovina, 'awaie ma fuedie 'adi tutula i na vesala. ");
INSERT INTO yml_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Ai'edi aitoi yaku tofolova kebu ma 'ana wagavaga i na 'ivaiseni, avinodi yana 'aivaitanina siaina bani'odi ufa i na veleni i na yemu, 'awaie 'ana tutula i na veluagai.” Side bani'odi Iesu yana ve, tovetutuyamavo 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tutuyanina Iesu yana ve i 'a'ava yana tovetutuyamavo 12 'waidie, 'atamananina i 'iaweni i nago 'atamana 'ifwaidi 'waidie 'awalawa Galili nageneye, bei i na ve wata i na lau'age. ");
INSERT INTO yml_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tutuyanina 'waineye Ioni Tobafitaiso i miamia vanuga yogona nageneye, Keliso yana folova valana i nogai begaidi 'ifwaidi yana tovetutuyamavo i vetunedi i na velutolieni. ");
INSERT INTO yml_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Bega i maia Iesu 'waineye i vo, Ioni Tobafitaiso nuanuana i na 'asetai 'omu kumanimu faifaimu me Diu ta lulukamata ta vo, 'Awaie 'ada To'ita'ita'i i na mai Yaubada 'wainega,’ 'alo tulina faifaina ta lulukamata?” ");
INSERT INTO yml_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesu yadi velutoli i tutuli i vo, 'Wa na vilami 'wa na nagoi Ioni 'waineye, ava'ai a veveifufuyedi 'wa nogaidiga wata a 'i'idewadi 'wa 'isediga faifaidi 'wa na voneni. ");
INSERT INTO yml_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Side bani'odi 'wa na voneyedi 'wa na vo, Tomatasako i 'i'isadewa, tubusakosako i tutubuoga, tomogodi i velubonubonuga i veve'atumai. Tanigadi 'uludi i noganogaya, towafa i tovotovoi wafayega wata Vala 'Atumaina i lulu'ivoneyeni tovewekowekoma 'waidie.’ ");
INSERT INTO yml_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wata 'wa na voneni 'wa na vo, 'Ai'edi aitoi kebu ma yana venuanaluga i na vetumagana 'waikuye, 'eba sosoana 'waineye.’” ");
INSERT INTO yml_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ioni yana tovetutuyamavo i tauya i nunagoi, Iesu 'aila'a 'waidie i veifufu Ioni faifaina i vo, Basenadi 'wa nagoi sali'avu'avuye Ioni 'waineye aitoi nuanuami 'wa da 'iseni? Tamu tomogo umaumana yana sauluva bikana bani'odi 'ayalele, kaukau siaina i nunuga i 'anino'uya? Kebu. ");
INSERT INTO yml_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","'Wa da 'iseni aitoi? Tamu tomogo i vaigavu talauma 'atumaidiega? Kebu. Tomotoganidi bani'odi i vivigavuyediga yadi vanuga 'ai'aiwabudi 'waidie i miamiani. ");
INSERT INTO yml_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nuanuaku a na 'asetai 'wa nagoga 'wa da 'iseni aitoi? Tamu Yaubada yana tolu'ivona? E'e. Mogitana tolu'ivona. Siwe 'ifwaidi tolu'ivona sai'afo va'egai, we'e tomogonina 'wa 'iseniga bwaikaotogina. ");
INSERT INTO yml_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Vona mogitana tomogo bwaikina fai basenadiotoga faifaina i kilumi Yaubada yana Buki nageneye. Yaubada i vona 'ana Venua'ivina 'waineye i vo, A na vonemu. Yaku tomata'aulele a na vetunei i na kumeta yamu 'eda i na vusia.’ ");
INSERT INTO yml_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A vona mogitana 'waimie tomia fwayafwaya matatabudi sai'afo va'egai, we'e Ioni kumanina bwaikaotogina. Siwe tomotoga bwaikidi wata siaidi 'akonadi i lukuga Yaubada yana 'Eba Veimea nageneye i vagalaka, Ioni ma'itufa i obu fai bola kebu i da lukuga. ");
INSERT INTO yml_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Basenadiotoga Yaubada veimea i yatodi bega tomotoga i na vematayakeyakedi, bani'odi veimeanidi Mosese 'wainega wata tolu'ivonavo 'adi kilukiluma 'waidiega. Veimeanidi i 'eno'eno nika Ioni Tobafitaiso i souyeni. Tutuyanina 'waineye i velamu i maiga 'asiau, tomotoga fuedi i ve'edaeloelo wata i vevetunufelagi nuanuadi bwaikina i na luku Yaubada yana 'Eba Veimea nageneye, we'e tomotoga 'ifwaidi ma yadi ve'isakololo i vevedabadaba 'ana ve'ilove faifaina. ");
INSERT INTO yml_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Wata basenadiotoga Yaubada yana tolu'ivonavo nagami i vona-samula tamu tolu'ivona i na maiga faifaina. Tolu'ivonanina bwaikina, yana sauluva bani'odi Ilaitia kumanina basenadiotoga ma yawaina i nagomo abame. 'Ai'edi nuanuami yaku vona 'wa na vetumaganeni tolu'ivonanina bani'odi Ilaitia, 'asa'aiana Ioni. ");
INSERT INTO yml_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Veifufu de'e 'wa nogaiga, 'wa na venua'ivineni nika 'wa na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Wata Iesu i vona 'aila'a 'waidie i vo, Tutuya de'e 'ana tomotoga ava'ai 'wainega a na awatalatutulemi? Yami sauluva ava'ai bani'odi? Tomotoganimi bani'odi yavayavava to'wava, nuanuadi i na vetutuyama 'atamanafouye. Tamu 'aila'a i vegole ediavo 'waidie i vo, Nuanuama tamu nani ta da 'idewai siwe 'wa baila. 'A lauinava siwe kebu 'wa da suya. 'A tailauwawa siwe kebu 'wa da vemogai. Kebu nuanuami yama nuanua 'wa na fali'atumaiedi.’ ");
INSERT INTO yml_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","'Omi yavayavavanidi bani'odi, kebu nuanuami Ioni Tobafitaiso wata yau yama nuanua 'wa na fali'atumaiedi. Ioni i mai 'ani 'wainega i veve'udigana bega yana velu'ui i na vetoketoke Yaubada 'waineye wata kebu oine i da yemuga 'wa vona 'wa vo, Tomogo no'o, yaiaina i agei.’ ");
INSERT INTO yml_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","We'e yau a vetomotogaotoga a mai kebu a da ve'udiganaga, a 'ani'ani wata a yemuyemu siwe 'wa vo, Tomogo no'o 'wa 'iseni. 'Awana bwalabwalaina, yana 'ani wata oine yana yemu 'afoina, takesi tolaugogona vivinagodi wata tovedumwe'ai'ai i veveianedi.’ Aitoi Yaubada yana nuamageta i na vevematayakeyakeni, yana sauluva 'wainega i na veda nuamagetanina tonovina wata 'atumaina.” ");
INSERT INTO yml_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Basenadi Iesu 'eba nuavogana wata 'eba nua'ewa fuedi i 'idewadi, siwe 'atamananidi 'ana tomotogavo kebu i da nuaviladi yadi sakona 'waidiega. Begaidi Iesu 'atamananidi 'adi tomia i awavesakoyedi. ");
INSERT INTO yml_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","I vo, Ieu, 'omi me Kolesini wata me Bedasaida nuakalikalimi, 'waimie vita bwaikina i na souyeni. We'e basenadiotoga me Taia wata me Saidoni yadi sakona bwaikidi faifaidi Yaubada i leodi. 'Ai'edi 'eba nuavogana wata 'eba nua'ewa a 'idewadiga 'waimie, wata tosakonanidi 'waidie a da 'idewadiga, 'ako i da vemwakula wata talauma sakoidi i da ve'wesenedi, yadi nuavilana 'ana tugusa. ");
INSERT INTO yml_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A na vonemi, 'awaie Vonayavuga 'ana 'Aiata 'waineye me Taia wata me Saidoni 'adi vematavuloga i na veluagai Yaubada 'wainega, siwe sai'afo i na 'isanuakalikaliedi. We'e 'omi yaku vona 'wa baila kebu 'wa da nuavilamiga vita bwaikaotogina 'wa na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","We'e 'omi me Kafaneomi taunimi 'wa awa'ai'aimi igodi 'wa vo, 'Ima 'atumaima, 'a na luku abame,’ siwe mogitana Yaubada i na veimea 'wa na obu towafa yadi 'eba mia 'waineye. Basenadiotoga Yaubada me Sodoma i leodi yadi sakona faifaidi, we'e 'ai'edi yaku folovanidi toketokedi a 'idewadiga matamie a da 'idewadi matadie, i da nuaviladi 'atamananidi bola i da miamia. ");
INSERT INTO yml_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Vonayavuga 'ana 'Aiata 'waineye me Sodoma 'adi vematavuloga i na veluagai Yaubada 'wainega siwe sai'afo i na 'isanuakalikaliedi. We'e 'omi yaku vona 'wa baila kebu 'wa da nuavilamiga vita bwaikaotogina 'wa na veluagai.” ");
INSERT INTO yml_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tutuyanina 'waineye Iesu i vo, Tamaku, 'omu abama wata fwayafwaya 'adi Toveimea, a vekaiwa 'waimuye fai yaku ve 'adi 'aseta 'u givedi kumanidiavo igodina tonuamageta wata to'aseta 'waidiega, we'e egavo i nunuaobuga yavayavava bani'odi, yaku ve 'adi 'aseta 'u kiavemagetadi 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tamaku, vona mogitana ava'ai yamu nuanua i lubwaineniga 'akonadi 'u 'idewai 'amu kiavesosoana.” ");
INSERT INTO yml_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Iesu i velu'ui i 'a'avana tomotoga i vonedi i vo, Nani matatabuna Tamaku i 'anivelenedi 'waikuye a veveimeyedi. Kebu tamu aitoi yau Yaubada Natuna i da 'asetaku, Tamaku 'aiseotogina 'aku to'aseta. Wata kebu tamu aitoi Tamaku i da 'asetai, yau Natuna 'aiseotogiku 'ana to'aseta wata 'ai'edi egavo nuanuaku, 'waidie Tamaku a na sivemageseni. ");
INSERT INTO yml_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","'Omi matatabumi 'wa 'abiawaga wata 'ami vita faifaidi 'wa vevenuafouviga, 'wa na maia 'waikuye a na 'ivesafailidi bega yami mia i na ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yaku ve bani'odi 'aifafula. Bega yaku 'aifafulanina 'wa na 'ewai taiadi venuana ta na 'ifafuli. Yau tonuaobu yaku sauluva bikadi bega 'waikuyega 'aseta 'wa na 'ewai wata 'ami vita a na ve'ewalovemi. ");
INSERT INTO yml_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yaku ve wata folova a na velemiga bani'odi ta 'aifafula kebu vitanaga.” ");
INSERT INTO yml_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tamu 'Aiata Veawai 'waineye, Iesu ma yana tovetutuyamavo i nunagoi bakula 'waineamo, yana tovetutuyamavo i lase bega witi vuagidi i kaliwawadi i 'ani. ");
INSERT INTO yml_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","We'e 'ifwaidi Diu totafalolo Falisi i 'isedi Iesu i voneni i vo, 'U 'isanawedi, yamu tovetutuyamavo me Diu yada ve'etoboda i geugeuya witi vuagidi i kakaliwawadi, 'asa'aiana i folofolova 'Aiata Veawai 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iesu Falisi yadi vona i tutuli i vo, 'Wa da vo Yaubada yana Buki kebu 'wa da lu'iawawaiga, basenadiotoga Kini Devida ma enavo i lase faifaina. ");
INSERT INTO yml_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devida i luku Yaubada yana Vanuga 'Eba Velu'ui nageneye, beledi tamu Yaubada 'ana 'anivelena i 'ewai ma enavo i 'ani. De'e tamu 'ada veimea kebu tamu aitoi 'ana fata beledinina i na 'ania tovelomu 'aisedi 'adi tauya. ");
INSERT INTO yml_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Wata 'wa na nuani veimeanina i mai Mosese 'wainega, tovelomu 'adi tauya i na folofolova 'Aiata Veawai 'waineye Vanuga 'Eba Velu'ui nageneye. Avinodi 'Aiata Veawai 'ana veimea i geuya siwe kebu i da sakonaga. ");
INSERT INTO yml_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A na vonemi, yada Vanuga 'Eba Velu'ui nani bwaikina, siwe matamie tamu tomogo i tovotovoi bwaikaotogina. ");
INSERT INTO yml_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tamu Yaubada yana vona yana Buki nageneye i vo, 'Aisaya 'wa nikenikedi 'waikuye 'wa vevelomuyedi, siwe kebu nuanuaku. Nuanuaku tomotoga 'wa na 'i'isanuakalikaliedi.’ 'Ai'edi vona de'e 'wa da 'asetaiga, 'ako kebu yaku tovetutuyamavo 'wa da vonediga igodina i da sakona, i lubwaineni 'wa da 'isanuakalikaliedi. ");
INSERT INTO yml_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yau a vetomotogaotoga 'asa'aiana kumaniku 'Aiata Veawai 'ana Toveimea, begaidi 'aku laubwaina 'aiatanina 'waineye tomotoga yadi sauluva faifaina a na veveimea.” ");
INSERT INTO yml_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu i vona'a'ava i tauya i nago me Diu yadi 'eba miava'auta 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","'Eba miava'autanina nageneye tamu tomogo nimana 'okana i miamia. We'e 'ifwaidi tomotoga i maia, nuanuadi Iesu i na tolimatani tamu sauluva sakoina faifaina bega i velutolieni i vo, Yada ve'etoboda bani'odi i voneyedi? 'Ai'edi ta na 'ive'atumai yada 'Aiata Veawai 'waineye, i lubwaineni 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu yadi vona i tutuli i vo, 'Ai'edi tamu aitoi 'waimiega yana 'aisaya i na be'u kulie 'Aiata Veawai 'waineye, i na 'ivaiseni i na silakai 'alo kebu? Vona mogitana, i na silakai nika i na 'ita'ita'ieni. ");
INSERT INTO yml_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Siwe 'aisaya sai'afo nani-'avo'avovo we'e tomotoga nani bwaikina. Mogitana yada veimea i 'eno'enovi siwe tautauyina ta na 'aivaita 'Aiata Veawai 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iesu tomogo i voneni i vo, Nimamu 'u si'otoi.” Tomogonina nimana i si'otoi nika i ve'atumai, nimana vi'ainega bani'odi. ");
INSERT INTO yml_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Falisi i 'iseni i tauya i nagoi nika 'eda'eda i lauala bani'odi i na munega Iesu i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Iesu i 'asetai Falisi nuanuadi i na luvewafai bega 'atamananina 'waineye i miamiaga i 'iaweni i tauya i nago mali 'awalaweye, siwe tomotoga fuedi i veyogo'waila. 'Aila'anina nageneye toviga matatabuna i 'ive'atumaidi wata i talabodebodedi kebu faifaina i na veveifufu. ");
INSERT INTO yml_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I talabodediga nika Yaubada yana tolu'ivona 'ana wagava Aisea yana vona-samula 'ana mogitana i souyeni. Basenadiotoga Yaubada yana Vona 'ana Venua'ivina faifaina i kilumi i vo, ");
INSERT INTO yml_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","De'e yaku Tofolova, kumanina a venua'ivineni. Taunina a nuakalikalieni, faifaina a sosoana. 'Anu'anunuku a na tauyeni i na agei, bega yaku veimea tonovidi i na lu'ivona tomotoga 'aila'a tulina tulina 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kebu i na ve'ikwayekwayega wata kebu i na veta'ata'ala. Wata 'atamanafouye kebu bonana bwaikinega i na veifufu. ");
INSERT INTO yml_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Egavo mweadi 'wa da vo 'ayalele 'anino'una kebu i na kiadabadi i na 'ivaisedimo. Egavo yadi vetumagana mweadi 'wa da vo mageta i da taulovolovogi kebu i na luve'weudi i na 'ivaisedimo. Yana folova 'waineye i na tokemaiga i na nagoga nika Yaubada yana nuanua tonovidi i na vebwaika tomotoga 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bega tomotoga 'aila'a tulina tulina yadi vetumagana i na yato-vagasedi 'aku Tovenua'ivina 'waineye i na lulukamaseni.” ");
INSERT INTO yml_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tamu tomogo, basenadi yaiaina i agei bega matana i sako wata kebu 'ana fata i na welava, enavo i mieni Iesu 'waineye. Iesu tomogonina i 'ive'atumaia nika i 'isala wata i welava. ");
INSERT INTO yml_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tomotoga fuedi i 'iseni nuadi i voganidi i vo, Voke 'asa'aiana kumanina Yaubada 'ana Venua'ivina, Kini Devida tubuna.” ");
INSERT INTO yml_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","We'e tutuyanina me Diu totafalolo Falisi i nogai, i vona i vo, Seitani, yaiaina yadi to'edakumeta Iesu i agei yana toketokena 'wainega i vonavona yaiaina i 'a'awa'a'idi.” ");
INSERT INTO yml_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu 'akonadi i 'asetai Falisi yadi nuanua begaidi i vonedi i vo, 'Ai'edi 'eba veimea 'aise'avadi i na 'idia i na vevetalaga 'eba veimeanina i na velovi. Wata 'ai'edi 'atamana 'alo vanuga 'ana tomia yadi ve'ikwayekwayega 'wainega 'idi i na souyeni, nika i na yavula. ");
INSERT INTO yml_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","27","'Wa vonaga Seitani yana toketokena 'wainega a vona tamu yana tomotoga i 'awa'a'ia, siwe 'ai'edi mogitana a da folofolova Seitani yana toketokena 'wainega, 'wa da 'asetai Seitani yana 'aila'a 'aise'avadi i da 'idia i da vevetalaga kebu 'ana fata i na miamia i na 'a'avaotoga. We'e yami tomotoga 'ifwaidi i vonavona yaiaina i 'a'awa'a'idi, vetuma 'wa da velutoliedi ava'aiega yadi toketokena i veluagai. Nika i na vo, 'Wa vekali, kebu Seitani 'wainega.’ ");
INSERT INTO yml_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","We'e mogitana Yaubada 'Anu'anununa yana toketokena 'wainega yaiaina a vonevonedi i 'a'awa'a'idi, 'wa da 'asetai Yaubada yana veimea i souyeni 'awasasamie. ");
INSERT INTO yml_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Side bani'odi. Kebu tamu aitoi 'ana fata i na luku tamu tomogo toketokena yana vanuge i na vainago. We'e 'ai'edi nuanuana, nagami tomogonina toketokena i na 'iyogoyogoni, mulieta i na vainago. ");
INSERT INTO yml_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","'Ai'edi aitoi kebu taiadi 'a na folofolovaga, taunina 'aku gavia, we'e 'ai'edi aitoi kebu yau taiadi tomotoga 'a na vavagavaidi 'a na mimaiedi Yaubada 'waineye, kumanina tomotoga i sogisogiedi, taunina yaku folova 'ana to'ivesako. ");
INSERT INTO yml_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Begaidi a na vonemi, tomotoga 'adi fata nuatavuna i na veluagai yadi sakona wata awavesako tulina tulina faifaidi. Siwe egavo i na vona-uvi'agala 'Anu'anunu Magemagetana 'waineye kebu tamu sai'afo Yaubada i na nuatavunidi. ");
INSERT INTO yml_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","'Ai'edi aitoi yau a vetomotogaotoga i na awavesakoyekuga, 'ana fata nuatavuna i na veluagai. Siwe 'ai'edi aitoi i na vona-uvi'agala 'Anu'anunu Magemagetana 'waineye, kebu tamu sai'afo Yaubada i na nuatavuniga, tutuya de'e wata tutuya i mimaiga 'waineye i na 'eno-vagata. ");
INSERT INTO yml_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Wata bani'odi 'ai'edi welavi 'atumaina tutuya fuedi vuagina 'atumaina, we'e welavi sakoina tutuya fuedi vuagina sakoina. Welavi 'aitamogana 'aitamogana vuagidiega ta na 'asetadi ava'ai welaviga, wata bani'odi tomotoga yadi sauluva ta na 'isedi ta na 'asetadi tomotoga 'atumaidi 'alo sakoidi. ");
INSERT INTO yml_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","'Omi 'o'olo sakoimi, kebu 'ami fata nani 'atumaidi 'wa na 'inanadi. Vonanidi sakoidi 'wa 'inanadiga fai nuamie i 'eno'enovi. ");
INSERT INTO yml_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tomogo 'atumaina yana nuanua 'atumaidi 'waidiega i vevesauluva 'atumaina, we'e tomogo sakoina yana nuanua sakoidi 'waidiega i vevesauluva sakoina. ");
INSERT INTO yml_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Wata a na vonemi, 'aiatanina 'waineye tomotoga matatabumi 'wa na vonayavuga Yaubada 'waineye, yami vona-'avo'avovo 'aitamogana 'aitamogana 'wa na lu'ivoneyedi. ");
INSERT INTO yml_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","'Ai'edi yami vona tonovidi i na awave'atumaiemi, 'ai'edi yami vona vekali Yaubada i na veimea vematavuloga 'wa na veluagai.” ");
INSERT INTO yml_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mulieta 'ifwaidi ve'etoboda 'adi tove wata totafalolo Falisi Iesu i voneni i vo, Tove, nuanuama tamu 'eba nuavogana wata 'eba nua'ewa 'u na 'idewai bega 'a na 'asetamu ma yamu veimea Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","40","Iesu i vonedi i vo, 'Omi tutuya de'e 'ana tomotoga yami sauluva sakoidi wata kebu nuanuami Yaubada yana nuanua. 'Wa vonavona nuanuami 'eba nuavogana wata 'eba nua'ewa a na 'idewai siwe a nuani kebu tamu sai'afo a na 'idewaiga. We'e tamu nani a na veifufuyeni yami 'eba 'isa. Basenadiotoga Yaubada yana tolu'ivona 'ana wagava Iona igodi i dega Yaubada 'wainega nika tamu igana bwaikina i tononi bega kamoneye i miamia 'aiata wata lovana 'aitonu. Wata bani'odi yau a vetomotogaotoga 'awaie 'aiata wata lovana 'aitonu a na miamia fwayafwaya nageneye. 'Asa'aiana kumanina yami 'eba 'isa. ");
INSERT INTO yml_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","'Awaie Vonayavuga 'ana 'Aiata 'waineye me Ninive wata tutuya de'e 'ana tomotogavo taiadi 'wa na tovoi Yaubada mataneye, tomotoganidi i na matawa'ulimi fai tutuyanina Iona i lau'age 'waidie i nuaviladi. A na vonemi, Iona tomogo bwaikina we'e tomogonina matamie i tovotovoi kumanina bwaikaotogina siwe 'wa baila, kebu nuanuami 'wa na nuavilami. ");
INSERT INTO yml_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wata bani'odi basenadiotoga me Siba yadi toveimea bwaikina Kwini Siba 'ani'ieyega i mai bega Kini Solomoni yana nuamageta i na vinenegeni. 'Awaie Vonayavuga 'ana 'Aiata 'waineye Kwini Siba wata tutuya de'e 'ana tomotogavo taiadi 'wa na tovoi Yaubada mataneye, kwininidi i na matawa'ulimi fai kebu nuanuami nuamageta. Siwe a na vonemi, Kini Solomoni tomogo bwaikina, we'e tomogonina 'awasasamie i tovotovoi kumanina bwaikaotogina siwe 'wa baila, kebu nuanuami 'wa na vinenegeni.” ");
INSERT INTO yml_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Wata Iesu i vonedi vona-awatabaiega i vo, 'Ai'edi yaiaina i na 'awa'a'ia tamu tomogo 'wainega, i na nago 'awalawa sakoineye bei i na lalauala-vuvua tamu yana 'eba mia. 'Ai'edi kebu i na veluagaiga i na vo, A na vilaku yaku 'eba mianina basenadi a 'iaweniga 'waineye.’ Bega i na vilai, i na mai 'eba mianina i na 'iseni 'akonadi i 'idewai 'atumaina wata vunavunagina i 'eno'eno, siwe nage'avana. ");
INSERT INTO yml_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Fai kebu 'ana veluvaiga, i na souyeni i na nago wata yaiaina sakoiotogidi 7 i na vagavaidi i na miedi taiadi i na luku 'eba mianina 'waineye. Tomogonina i na 'ivesakootogi mogitana, basenadi kebu bani'odiga. 'Omi tutuya de'e 'ana tomotoga yami sauluva sakoidi wata bani'odi i na souyeni 'waimie, 'awaie vita bwaikaotogina 'wa na veluagai basenadi kebu bani'odiga.” ");
INSERT INTO yml_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu bola i veveifufu tomotoga 'waidie nika inana wata tainavo taiadi i le'wai. Tanotanoge i tovoi i vo, Nuanuama 'a na veifufu Iesu taiadi.” ");
INSERT INTO yml_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tamu tomogo i nago Iesu 'waineye i voneni i vo, Inamu wata taimwavo sino'o, nuanuadi taiadi 'wa na veifufu.” ");
INSERT INTO yml_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Iesu i voneni i vo, 'Wa da nuani, egavo taikwavoga wata inaku? A na vonemi. Side, yaku tovetutuyamavo, taunidi inaku wata taikwavo. ");
INSERT INTO yml_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aitoi Tamaku abame yana nuanua 'ana to'idumwebika, taunina taiku, novuku, 'alo inaku.” ");
INSERT INTO yml_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mulieta 'aiatanina 'waineye Iesu vanuga i 'iaweni i nago balebaleye, bei i miabui i na ve. ");
INSERT INTO yml_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","'Aila'a bwaikina i maia i tovififineni begaidi wakayega i talalaka we'e tomotoga lelege i tovoi. ");
INSERT INTO yml_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nani fuedi faifaidi i ve 'waidie vona-awatabaiega i vo, Tamu tomogo i nago bakule yana witi waifeidi i na bakulidi, we'e yadi sauluva luyavuyavulagi. ");
INSERT INTO yml_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yana luyavuyavulagi 'waineye witi 'ifwaidi i ve'anita'idi 'eda balebaleye tomotoga yadi 'eba nago 'waineye, mulieta manuga i mai i 'anidi. ");
INSERT INTO yml_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","'Ifwaidi i ve'anita'idi bwakebwakeye, nagami i tabo-matayo'o fai fwayafwaya kebu badubadunaga. Siwe tutuyanina inala i kabu i 'awagi'adi fai 'walamidi kebu i da vagaobuga. ");
INSERT INTO yml_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","'Ifwaidi i ve'anita'idi 'awanavenaveye kebu 'adi 'oiga, i ugawegawedi. ");
INSERT INTO yml_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","We'e 'ifwaidi i ve'anita'idi inageye fwayafwaya 'atumaina 'waineye i tabo i vuaga. Witi 'ifwaidi vuagidi 100, 'ifwaidi 60 wata 'ifwaidi 30.” ");
INSERT INTO yml_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wata Iesu i vo, Veifufu de'e 'wa nogaiga, 'wa na venua'ivineni nika 'wa na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mulieta Iesu yana tovetutuyamavo i maia 'waineye i velutolieni i vo, Awale 'u veve tomotoga 'waidie vona-awatabaiega?” ");
INSERT INTO yml_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bega Iesu i vonedi i vo, 'Akonadi Yaubada i tauyemi nani fuedi givagivadi 'wa 'asetadi yana veimea tomotoga 'waidie faifaina, we'e de'e tomotoganidi kebu. ");
INSERT INTO yml_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Egavo yaku ve i na vinenegeni wata i na venua'ivineni, yadi 'aseta Yaubada i na 'imoso'ieni bega yadi 'aseta i na vebwaika, we'e egavo kebu i da nogaya-dewai yadi 'aseta siaina Yaubada i na elodi. ");
INSERT INTO yml_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Avinodi tomotoganidi i 'ise'iseni siwe kebu i da 'isa'inanaiga wata i noganogai siwe kebu i da nogaya-dewai 'alo i da 'asetai, begaidi a veve 'waidie vona-awatabaiega. ");
INSERT INTO yml_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nika Yaubada yana tolu'ivona Aisea yana vona-samula 'ana mogitana i souyeni, Yaubada i vo, Yaku vona 'wa na noganogai siwe kebu nuami i na magetadi. Naninidi a 'i'idewadi 'wa na 'ise'isedi siwe kebu 'wa na 'isa'inanadi. ");
INSERT INTO yml_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Fai tomotoganidi nuadi i 'ivetabodadi. Tanigadi i 'ibodadi bega kebu 'adi fata yaku vona i na vinenegeni. Matadi i 'uludi bega kebu 'adi fata naninidi a 'i'idewadi i na 'isedi. We'e 'ai'edi mogitana i da 'isa'inana wata i da nogaya-dewa, nuadi i da magetadi, i da nuaviladi i da mai 'waikuye, nika a da 'ive'atumaidi.’ ");
INSERT INTO yml_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yaubada yana vonanina tomotoganidi faifaidi, we'e 'omi 'eba sosoana 'waimie fai taunimi matamiega 'wa 'ise'iseni wata taunimi tanigamiega 'wa noganogai. ");
INSERT INTO yml_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A vona mogitana 'waimie basenadiotoga Yaubada yana tolu'ivonavo fuedi wata tomotoganidi yadi sauluva tonovidi, nuanuadi bwaikina yaku folovanidi 'wa 'ise'isediga i da 'isedi wata yaku ve 'wa noganogaiga i da nogai, siwe kebu.” ");
INSERT INTO yml_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Wata Iesu yana tovetutuyamavo i vonedi i vo, A na vonemi, luyavuyavulagi 'ana vona-awatabai 'ana kiavemageta side bani'odi. ");
INSERT INTO yml_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Waifei i ve'anita'idi 'eda balebaleye 'ana nuanua, bani'odi tomotoga vona i nogai Yaubada i na veimeyedaga faifaina, siwe kebu i da 'asetaiga. Bega Seitani, kumanina Tosakona i mai tolau'age waifei i bakuli yadi nuanua 'waidie i elodi. ");
INSERT INTO yml_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Waifei i ve'anita'idi bwakebwakeye 'ana nuanua side bani'odi. Tomotoga ma yadi sosoana Yaubada yana Vona i nogai siwe yadi nuanua 'waidie kebu mogitana i da lukuga. ");
INSERT INTO yml_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","I vetumagana siwe tutuya 'ale'usana. Tutuyanina vita 'alo ve'isakololo i na souyedi Vonanina faifaina, i na baila-matayo'oyeni. ");
INSERT INTO yml_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Waifei i ve'anita'idi gaweye 'ana nuanua side bani'odi. Tomotoga Yaubada yana Vona i nogai siwe yadi mia faifaidi i vevenuafouviga wata 'ai'aiwabu 'adi nuanua 'waidie bwaikina, 'wa da vo Yaubada yana Vona i da ugawegaweni kebu i da vuaga. ");
INSERT INTO yml_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","We'e waifei i ve'anita'idi inageye fwayafwaya 'atumaina 'waineye 'ana nuanua side bani'odi. Tomotoga Yaubada yana Vona i nogai, i nuave'avini wata i 'asetai mulieta yadi folova Yaubada faifaina bani'odi i vuaga, 'ifwaidi 100, 'ifwaidi 60 wata 'ifwaidi 30.” ");
INSERT INTO yml_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wata Iesu i ve tomotoga 'waidie tamu vona-awatabai 'wainega, tomotoga 'atumaidi wata sakoidi faifaidi i vo, Yaubada yana veimea tomotoga 'waidie side bani'odi. Tamu tomogo witi waifeidi 'atumaidi i bakulidi. ");
INSERT INTO yml_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tamu lovana, tomotoga matatabudi i 'eno'enovi, 'ana gavia i mai matagawagawa witi 'ana 'isa'isa bani'odi i luyavuyavuleni nika i tauya. ");
INSERT INTO yml_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","27","Tutuyanina witi i vebwaika i adaga matagawagawa i vemageta bega tonibakula yana tofolovavo i 'iseni i mai i voneni i vo, 'Auvea, nagami waifei 'atumaidi ta bakulidi we'e gawa ava'aiega i mai?’ ");
INSERT INTO yml_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tonibakula i vo, Tamu 'aku gavia i 'idewai.’ Bega yana tofolovavo i velutolieni i vo, Bani'odi yamu nuanua, 'a na luabuabudi?’ ");
INSERT INTO yml_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yadi 'auvea i vo, 'Asa'aiana, 'ai'edi 'wa na luabuabudiga, bola witiotoga taiadi 'wa na siabudi. ");
INSERT INTO yml_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","'Wa bailedi, i na tabowanawana, bola 'aiala 'ana tutuye to'aiala a na vonedi a na vo, Nagami matagawagawa 'wa na luabuabudi 'wa na 'itavidi 'wa na tawedi 'aie i na 'alaidi, we'e witiotoga 'wa na vedodogidi yaku bubuwakeye.’” ");
INSERT INTO yml_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Wata Iesu i ve 'waidie vona-awatabaiega i vo, Yaubada yana veimea tomotoga 'waidie yana vebwaika side bani'odi. Tamu tomogo 'ayawana bilana i 'ewai i bakuli mulieta i vebwaika. ");
INSERT INTO yml_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bilanina siaina siwe tutuyanina i vebwaika welavi bwaikaotogina bega manuga i mimaia didineye i vevegiuva.” ");
INSERT INTO yml_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wata Iesu i ve 'waidie vona-awatabaiega i vo, Yaubada yana veimea tomotoga 'waidie yana susula side bani'odi. Tamu vavine falawa bwaikina i vilai mulieta isita i yatoi, i susula falawa matatabuna 'waineye nika i vebwaika.” ");
INSERT INTO yml_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tutuya fuedi Iesu i veve tomotoga 'waidie vona-awatabaiega, kebu tamu tutuya i da vonaotoga. ");
INSERT INTO yml_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","De'e bani'odi i vevega nika tamu Yaubada yana tolu'ivona yana vona 'ana mogitana i souyeni. Basenadiotoga i vona-samula Yaubada 'ana Venua'ivina yana vona faifaina i vo, Vona-awatabaiega a na veifufu 'waidie. Nani fuedi givagivadi fwayafwaya 'ana 'idewavau 'wainega i maiga 'asiau, a na lu'ivoneyedi 'waidie.” ");
INSERT INTO yml_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yana ve i 'a'avana, Iesu 'aila'a i 'iawedi i nago vanuge. Mulieta yana tovetutuyamavo i maia i luku 'waineye i voneni i vo, Nuanuama 'a na 'asetai matagawagawa i taboga bakule 'ana nuanua.” ");
INSERT INTO yml_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","38","Iesu i vo, Tomogonina waifei 'atumaidi i bakulidiga 'ana 'aseta yau, kumaniku a vetomotogaotoga. We'e tanoga, fwayafwaya matatabuna. Waifei 'atumaidi 'adi 'aseta tomotoganidi 'akonadi taunidi i tauyedi Yaubada 'waineye i veveimeyedi, we'e matagawagawa kumanidiavo Seitani yana 'aila'avo. ");
INSERT INTO yml_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tomogonina matagawagawa 'ana toluyavuyavulagi taunina Seitani, tutuya 'aiala 'ana 'aseta Vonayavuga 'ana tutuya, we'e to'aiala taunidi anelose. ");
INSERT INTO yml_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","41","Matagawagawa i luabuabudiga i tunudi i 'alaidiga 'ana 'aseta side bani'odi. Fwayafwaya 'ana 'eba ve'a'ava 'waineye, yau a vetomotogaotoga yaku anelosevo a na vetunedi, tovetalaimiimila wata 'ifwaidi tosakona i na va'augidi i na nawedi bega kebu wata i na miamia Yaubada mataneye. ");
INSERT INTO yml_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","I na nawediga i na tawedi 'ai-'ala'alase, bei i na 'we'we'wela wata maigidi i na yuyuyudi fai veviga bwaikaotogina. ");
INSERT INTO yml_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Egavo yadi sauluva tonovidi Yaubada mataneye 'awaie Tamadi yana 'Eba Veimea nageneye 'adi 'isa magemagetadi, 'wa da vo inala i da vulaoga. Veifufu de'e 'wa nogaiga, 'wa na venua'ivineni nika 'wa na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Wata Iesu i ve 'waidie i vo, Yaubada yana veimea tomotoga 'waidie 'ana 'atumaina side bani'odi. Basenadi tamu tomogo mani wata 'ai'aiwabu bwaikina i tavuni fwayefwayeye. Mulieta tamu tomogo i veluagai, wata i tavu-vaitugani. I sosoana-'afo'afo, i nago yana kukua matatabuna i vekimwaneyedi tutulidi i 'ewadi, fwayafwayanina i kimwanei bega yana fwayafwaya fai 'ana 'atumaina nageneye i 'eno'eno.” ");
INSERT INTO yml_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Wata Iesu i vo, Egavo taunidi i tauyedi bega Yaubada i na veveimeyedi yadi sauluva side bani'odi. Tamu tomogo i lalauala nuanuana mwali bwaikina wata 'atumaiotogina. ");
INSERT INTO yml_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","I na veluagaiga yana kukua matatabuna i na 'anivelenedi bega mwalinina i na tuveobuya.” ");
INSERT INTO yml_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","Wata Iesu i ve 'waidie vona-awatabaiega i vo, Yaubada yana veimea tomotoga 'waidie tutuya 'eba ve'a'ava faifaina side bani'odi. Tovuata igana tulina tulina i 'onadi, tutuyanina yadi vuata i adaga i yo'ei 'avale bei i lauvisi igana 'atumaidi yadi venuane i vedodogidi, sakoidi i tawedi. ");
INSERT INTO yml_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Wata bani'odi, bola tutuya 'eba ve'a'ava 'waineye, anelose i na nagoi tomotoga sakoidi i na va'augidi tomotoga 'atumaidi 'awasasadiega i na tawedi 'ai-'ala'alase, bei i na 'we'we'wela wata maigidi i na yuyuyudi fai veviga bwaikaotogina.” ");
INSERT INTO yml_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tutuyanina Iesu yana ve i 'a'ava, yana tovetutuyamavo i velutoliedi i vo, De'e vona-awatabainidi matatabuna 'wa 'asetadi 'alo kebu?” I vo, E'e 'a 'asetadi.” ");
INSERT INTO yml_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bega Iesu i vo, 'Ai'edi ve'etoboda 'adi tove taunina i na tauyeni bega Yaubada i na veveimeyeni, kumanina bani'odi tomogo 'ai'aiwabuna. Fai Yaubada yana Vona tuatuaidi wata yaku ve 'ivaudi i 'asetadi, 'ana fata mali tomotoga 'waidie i na veve.” ");
INSERT INTO yml_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Iesu vona-awatabaiega i ve i 'a'ava, i tauya i nago taunina yana 'atamane Nasaledi. Bei i ve tomotoga 'waidie yadi 'eba miava'auta nageneye siwe nuadi i voganidi yana ve faifaina. I vo, Ava'ai tomotoga de'e? Ava'aiega yana nuamageta i 'ewai, bani'odi i munega 'eba nuavogana wata 'eba nua'ewa i 'i'idewadi? ");
INSERT INTO yml_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","Tomogo no'o kebu tulinaga, tamana to'aiyogona, inana Meli wata tainavo ta 'asetadi, Iemesa, Iosefa, Saimoni wata Iudasa wata novunavo taiadi ta miamiani. We'e yana 'asetanidi wata yana toketokenanina ava'aiega i veluagadi?” ");
INSERT INTO yml_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","I bavuyeni begaidi i baila, kebu nuanuadi Iesu. Bega Iesu i vonedi i vo, Yaubada yana tolu'ivonavo ma 'adi ve'ililibu tomotoga tulidi 'waidie, we'e taunidi yadi 'atamana 'ana tomotogavo wata yadi 'aila'avo kebu i da ve'ililibuyediga.” ");
INSERT INTO yml_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Fai kebu i da vetumagana Iesu 'waineye, begaidi kebu bei 'eba nuavogana wata 'eba nua'ewa fuedi i da 'idewadiga. ");
INSERT INTO yml_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Tutuyanina 'waineye, Loma kabemani yadi to'edakumeta Kini Elodi 'awalawa Galili 'ana toveimea. Iesu yana folova toketokena valana i nogai, yana tofolovavo 'ifwaidi i vonedi i vo, No'o Iesu, 'asa'aiana mogitana taunina Ioni Tobafitaiso i yawasa-vaitugana. Begaidi 'eba nuavogana wata 'eba nua'ewa i 'i'idewadi.” ");
INSERT INTO yml_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Bani'odi i voneyediga fai basenadi yana veimea 'wainega Ioni i yogoni i yatoi vanuga yogona nageneye. We'e Elodi taina Filifi yana vavine Elodiasa i luobuyedi mulieta i nagidi. ");
INSERT INTO yml_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Begaidi Ioni Elodi i tolimatani i vo, 'U vekali, taimu yana vavine 'u nagidi, Yaubada yana veimea 'u geuya.” ");
INSERT INTO yml_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ioni yana vonanina faifaina Elodi nuanuana i na luvewafai siwe me Diu i kololoyedi fai i vo, Taunina tamu Yaubada yana tolu'ivona.” ");
INSERT INTO yml_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Tutuyanina Elodi yana 'aiata tubuga i veluagai sakali bwaikina i 'idewai, Elodiasa natudi vevinena i voneni matadie i kayama. Elodi i 'iseni nuana i 'ewai bega i vona'awaufaufa 'waineye i vo, 'Ai'edi ava'ai nuanuamu 'u na velu'uiga, vona mogitana a na velemu.” ");
INSERT INTO yml_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Inana i nogai natudi i tolivetonoveni bega vavinenina ne'e'elina i nago Elodi 'waineye i vo, Nuanuaku Ioni Tobafitaiso i na wafa, 'unu'ununa 'aivoeye 'u na dodogi 'u na mieni 'waikuye.” ");
INSERT INTO yml_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kini Elodi i nogai nuana i vita siwe kebu 'ana fata yana vona'awaufaufa i na geuya fai 'ana wakawaka matadie i vona, bega yana tolugaviavo i vonedi i nagoi yana nuanua i 'idewai. ");
INSERT INTO yml_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Vanuga yogona nageneye Ioni 'odona i boboi, 'aivoeye i dodogi i mieni vavine i veleni. I 'ewai i nago inana i veledi. ");
INSERT INTO yml_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tutuyanina Ioni yana tovetutuyamavo valana i nogai, i maia tomogona i naweni i ve'ufai, mulieta i nagoi Iesu i voneni. ");
INSERT INTO yml_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tutuyanina Iesu i 'asetai Ioni 'akonadi i wafa, bega 'atamananina i 'iaweni i dodoga wakeye, 'aiseneye i nago kebu tamu aitoi bei i da miamiaga 'waineye. Tomotoga fuedi yana tauya i 'asetai bega yadi 'atamana i 'iawedi i veyogo'waila balebaleamo i nagoi. ");
INSERT INTO yml_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tutuyanina i le'wa, Iesu wakayega i obu balebaleye, tomotoga fueotogidi i 'isedi i miamiani, i 'isanuakalikaliedi bega yadi toviga i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","'Akonadi i lavia sai'afoga i na sidudubali, tovetutuyamavo i maia Iesu 'waineye i voneni i vo, 'Akonadi tutuya i ve'ale'usa wata de'e bei kebu tomotoginaga, bega 'aila'a 'u na vonedi i na nagoi 'atamana 'waidie taunidi 'adi'adi i na kimwane.” ");
INSERT INTO yml_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iesu i vonedi i vo, 'Asa'aiana i na miamiani, we'e 'omi 'ai'edi ava'ai 'wa na veledi i na 'ani.” ");
INSERT INTO yml_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tovetutuyamavo i vo, 'Waimeye 'ani'ani mwadodoudi 5 wata igana 'ailuga, 'asa'aiana bani'odi, kebu fuediga.” ");
INSERT INTO yml_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iesu i vo, 'Wa miedi 'waikuye.” ");
INSERT INTO yml_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tomotoga i vonedi mosomoso tabwadie i miabui, mulieta Iesu 'ani'aninidi i 'ewadi, i 'isalaka abame i vekaiwa Yaubada 'waineye. I vekaiwa i 'a'avana, 'ani'ani i 'ivividi tovetutuyamavo i veledi bega tomotoga i veutadi. ");
INSERT INTO yml_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","'Aila'anidi matatabudi i 'ani, kamodi i aidi, mulieta tovetutuyamavo tomotoga nikilidi i va'augidi bayawa 12 i veadagidi. ");
INSERT INTO yml_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","To'aninidi iaveta tulai'avadi i lu'iawawadi 'adi 'aila'a 5,000, we'e vevine tulaidi wata yavayavava matatabudi kebu taiadi i da lu'iawawadiga. ");
INSERT INTO yml_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tomotoga i ve'anidi i 'a'ava, yana tovetutuyamavo i vonedi i vo, 'Wa na dodoga wakeye, ta na viwaia lavu vi'ainega, yau tomotoga a na vonedi i na nunagoi a na vemuli.” ");
INSERT INTO yml_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","24","Tomotoga i tauya i nunagoi we'e Iesu i laka 'oyeye, 'aiseneye i na velu'ui. 'Akonadi i laviotogi Iesu 'aiseotogina bei i miamia, we'e yana tovetutuyamavo i yogokamwana lavunina bwaikina 'waineye, kaukau toketokena i nunuga wata yagina i veveviladi. ");
INSERT INTO yml_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sai'afoga tutuya i na kililia, Iesu i le'wa 'waidie, ufa tabwaneamo i mimai. ");
INSERT INTO yml_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tutuyanina yana tovetutuyamavo i 'iseni i kololoyeni i bwau i vo, 'Wa 'isanaweni, yalua.” ");
INSERT INTO yml_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nika Iesu i vonedi i vo, Kebu 'wa na kolologa, yau taunida.” ");
INSERT INTO yml_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Fita i vona-matayo'o i vo, Vetuma 'alo 'omu'e 'Auvea, 'u da vona ufa tabwaneamo a da wai 'waimuye.” ");
INSERT INTO yml_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","30","Iesu i vo, 'U mai.” Yana voneye Fita i obu i nunago Iesu 'waineye nika i 'isadaba kaukau wata yagina i 'isedi i kololo, i velamu i 'a'awakoluya i bwau i vo, 'Auvea, 'u da 'ita'ita'ieku.” ");
INSERT INTO yml_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nika Iesu nimana i 'otoi Fita i 'ive'avini i voneni i vo, Awale 'u venuanaluga, yamu vetumagana 'waikuye siaina.” ");
INSERT INTO yml_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","I silakai i 'a'avana 'adi 'ailuga i dodoga, nika yagina i 'awatagoni. ");
INSERT INTO yml_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yana tovetutuyamavo i 'iseni nika i 'odu i vo, Vona mogitana, 'omu Yaubada Natuna.” ");
INSERT INTO yml_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","I duduna Genesaleta balebaleye bei yadi waka i yo'ei. ");
INSERT INTO yml_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tomotoga Iesu i 'isa'inanai bega vala i vetunedi 'awalawanina matatabuna 'waidie bega toviga i miedi Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","I velu'ui nuanuadi toviganidi i na 'abitonovidi, we'e 'ai'edi kebu, 'ana talauma mataifwa'avana i na 'abitonovi. Egavo i 'abitonovaga matatabudi i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Mulieta 'ifwaidi me Diu totafalolo Falisi wata ve'etoboda 'adi tovevo i maia Ielusalemayega Iesu i velutolieni i vo, Awave'eda'eda i maiga tubudavo 'waidiega, awale yamu tovetutuyamavo kebu i da ve'ililibuyediga i geugeudi? 'Ani 'ana tutuya 'waineye kebu nimadi i da 'i'ilekoa we'e i 'ani'animo.” ");
INSERT INTO yml_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu yadi velutoli i tutuli i vo, We'e 'omi awale Yaubada yana veimea kebu 'wa da ve'ililibuyediga 'wa geugeudi, ma'itufa taunimi yami ve'etoboda 'wa vematayakeyakedi? ");
INSERT INTO yml_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yaubada i vonaga i vo, Tamamu wata inamu 'u na ve'ililibuyedi,’ wata i vo, 'Ai'edi aitoi tamana 'alo inana i na awavesakoyedi bega vita i na veluagai, i lubwaineni 'wa na luvewafai.’ ");
INSERT INTO yml_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Veimeanidi 'wa geugeudi fai 'wa veve 'wa vo, 'Ai'edi aitoi ma yana mani, siwe kebu nuanuana tamana wata inana i na 'ivaisediga, 'omi 'wa tauyeni bega i na vonedimo i na vo, Mani de'e a na 'aniveleneni Yaubada faifaina,’ vonanina 'wa fali'atumaieni. We'e mogitana i lubwaineni tamana wata inana i da ve'ililibuyedi, maninina 'wainega i da 'ivaisedi. De'e bani'odi Yaubada yana Vona 'wa venani-'avo'avovoyeni, ma'itufa ve'etoboda tubumiavo 'waidiega 'wa vevematayakeyakedi. ");
INSERT INTO yml_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","'Omi mogitana tovekali. Basenadiotoga Yaubada yana tolu'ivona Aisea, Yaubada yana Vona 'wainega i vona-samula faifaimi. I vonaga mogitana i vo, ");
INSERT INTO yml_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","De'e 'aila'anidi 'awakebuladiega i ve'ililibuyeku, siwe kebu mogitana i da nuakalikalieku. ");
INSERT INTO yml_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Taunidi yadi nuanuayega i veve igodina Yaubada 'wainega, begaidi 'waikuye i 'o'odu-maimaiga.’” ");
INSERT INTO yml_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu 'aila'a i goledi i nagoi 'waineye i vonedi i vo, A na vonemiga 'wa na venua'ivineni nika 'wa na 'asetai. ");
INSERT INTO yml_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ava'ai i na luku tomotoga 'awadiamo kebu 'ana fata tomotoga i na 'iveyokedi, we'e mogitana vona 'alo nuanua sakoidi tomotoga 'waidiega i na souyediga, 'ana fata tomotoga i na 'iveyokedi.” ");
INSERT INTO yml_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mulieta Iesu yana tovetutuyamavo i maia i voneni i vo, Yamu vona 'wainega Falisi i kamogala, 'u 'asetai?” ");
INSERT INTO yml_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Iesu i vonedi i vo, Welavinidi Tamaku abame kebu 'ana bakubakulaga, matatabuna i na siabudi. ");
INSERT INTO yml_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Falisinidi kebu faifaidi 'wa na nuanua. Avinodi taunidi tomotoga 'ada to'edakumeta, siwe bani'odi tomatasako fai Yaubada yana Vona kebu i da 'isa'inanadiga. Kebu 'ana fata tamu tomatasako iana tomatasako i na siveikani fai bola i na be'uluga vakavakale.” ");
INSERT INTO yml_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Fita i voneni i vo, Nuanuaku vona-awatabainina 'u da kiavemagetai 'waimeye.” ");
INSERT INTO yml_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu i vo, 'Alo 'omi wata bola 'wa bavubavu? ");
INSERT INTO yml_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","I lubwainemi 'wa da 'asetai naninidi i na luku tomotoga 'awadiamo i na nago kamodie mulieta yogo yana 'edeye i na nago. ");
INSERT INTO yml_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","We'e naninidi sakoidi 'awadiega i na souyediga, 'ana fata tomotoga i na 'iveyokedi Yaubada mataneye, fai yadi nuanua 'waidiega i mai. ");
INSERT INTO yml_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sauluvanidi side, nuanuana sakoidi, luvewafa, lauobu, ve'avula-'avo'avovo, vainago, vekali wata vebonaivo. ");
INSERT INTO yml_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Naninidi de'e 'ana fata tomotoga i na 'iveyokedi Yaubada mataneye. 'Ai'edi nimami kebu 'wa na lekoadi Falisi yadi nuanua bani'odi, mulieta 'wa na 'ani, 'ako kebu 'ana fata i na 'iveyokemiga.” ");
INSERT INTO yml_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mulieta Iesu ma enavo bei i miamiaga i 'iaweni, i nagoi tamu 'awalawa 'waineye, 'atamana Taia wata Saidoni lilivadie. ");
INSERT INTO yml_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","I miamiani nika tamu vavine Kenani i le'wa, vavinenidi 'awalawanina 'waineye i miamia. Taunidi kebu vavine Diu siwe i mai i toke i velu'ui Iesu 'waineye i vo, 'Auvea, 'omu Kini Devida tubuna, 'u da 'isanuakalikaliema. Natuku vevinena yaiaina i agei bega i veveviga bwaikina.” ");
INSERT INTO yml_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Siwe kebu tamu ava'ai Iesu i da voneyeni 'waidie. Mulieta yana tovetutuyamavo i maia 'waineye i lukakadeni i vo, 'U veugeugedi, mulideye i mimai i vevetaniga-logilogi.” ");
INSERT INTO yml_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tovetutuyamavo i vonavonaga begaidi Iesu vavine i vonedi i vo, Yaubada i vetunekuga me Isileli 'aise'avadi 'waidie, taunidi vuyovuyodi 'wa da vo sifi, we'e 'omi mali tomotoga kebu.” ");
INSERT INTO yml_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","We'e vavine i nogai Iesu yana vona i mai ma yadi ve'ililibu i 'odu 'ageneye, i vo, 'Auvea 'u da 'ivaisema.” ");
INSERT INTO yml_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesu i vo, Kebu i da lubwaineku kwakwama 'adi'adi a na elodi a na 'anivelenedi 'ou'ou 'waidie.” ");
INSERT INTO yml_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Vavine i 'asetai Iesu i vonavona nagami i na folova taunina yana 'aila'a me Diu 'waidie, begaidi i voneni i vo, 'Auvea we'e mogitana. Siwe tutuyanina kwakwama i na 'ani'ani, 'ou'ou siaidi mukumuku i na luluyamuyamu. Begaidi sai'afo 'u da 'ivaisema.” ");
INSERT INTO yml_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iesu yadi vona i nogai i vonedi i vo, Yami vetumagana toketokena, ava'ai nuanuami 'ana mogitana i na souyeni 'waimie,” nika mogitana natudi i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu ma enavo 'awalawanina i 'iaweni, Lavu Galili balebaleamo i nagoi, i laka tamu 'oya siaina 'waineye i miabui. ");
INSERT INTO yml_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tomotoga fueotogidi i maia, yadi toviga fuedi i miedi, toviganidi 'ifwaidi 'agedi sakoidi, tomatasako, tubusakosako, tomotoganidi kebu 'adi fata i na welavaga wata 'ifwaidi i vigaotoga. Toviganidi i miedi Iesu 'waineye matatabudi i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tomotoga i 'iseni nuadi i voganidi fai egavo kebu i da welawelavaga siwe i welava, tubusakosako wata 'agedi i sakoga i yogodewa wata tomatasako i 'isa-vaitugana. Naninidi faifaidi tomotoga fuedi me Isileli yadi Yaubada i subiai. ");
INSERT INTO yml_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu yana tovetutuyamavo i goledi i nagoi 'waineye i vonedi i vo, Tomotoga de'e faifaidi a nuavita fai 'akonadi 'aiata 'aitonu taiadi ta miamiani siwe kebu 'adi'adiga. Kebu nuanuaku ma 'adi lase a na vetunedi i na nagoi yadi vanuge fai bola 'edeye i na mwea.” ");
INSERT INTO yml_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yana tovetutuyamavo i voneni i vo, De'e kebu tomotoginaga, ava'aibe bei 'ani'ani ta na veluagai tomotoga de'e ta na ve'anidi?” ");
INSERT INTO yml_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu i velutoliedi i vo, We'e 'omi, 'aivia 'ani'ani 'waimie?” I vo, Kebu fuediga, 'ani'ani mwadodoudi 7 wata igana siaidi.” ");
INSERT INTO yml_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iesu 'aila'a i vonedi fwayefwayeye i vemiamiabui. ");
INSERT INTO yml_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mulieta 'ani'aninidi 7 igana taiadi i 'ewadi, i vekaiwa Yaubada 'waineye, i 'a'avana i 'ivividi wata igana i baidi tovetutuyamavo i veledi 'aila'a i veutadi. ");
INSERT INTO yml_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Matatabudi i 'ani, 'adi fata, mulieta yana tovetutuyamavo tomotoga nikilidi i va'augidi bayawa bwaikidi 7 i veadagidi. ");
INSERT INTO yml_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","To'aninidi iaveta tulai'avadi i lu'iawawadi 'adi 'aila'a 4,000, we'e vevine tulaidi wata yavayavava kebu taiadi i da lu'iawawadiga. ");
INSERT INTO yml_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","'Ani i 'a'avana, Iesu tomotoga i vonedi i nagoi, we'e i dodoga wakeye i nago 'awalawa Magadani. ");
INSERT INTO yml_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tamu tutuya me Diu to'edakumetavo 'ifwaidi i maia Iesu 'waineye, taunidi totafalolo 'adi wagava Falisi wata Sadusi. Nuanuadi i na silubuya bega i voneni i vo, Nuanuama tamu 'eba nuavogana wata 'eba nua'ewa 'u na 'idewai bega 'a na 'asetamu ma yamu veimea Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Siwe Iesu yadi vona i tutuli i vo, 'Ai'edi 'wa na 'iseni Malayaubani i na laka 'wa na 'asetai tutuya kumaga, wata 'ai'edi 'wa na 'iseni waowa i na vetovotovoia 'wa na 'asetai 'ako i na 'wei. Tugusanidi i na vemi bega 'ami fata 'wa na 'asetai ava'ai i na souyedi, we'e 'eba 'isa toketokedi Yaubada i 'i'idewadi matamie tutuya i mimaiga faifaina kebu 'wa da 'isa'inanadiga. ");
INSERT INTO yml_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","'Omi tutuya de'e 'ana tomotoga yami sauluva sakoidi wata kebu nuanuami Yaubada yana nuanua. 'Wa vonavona nuanuami 'eba nuavogana wata 'eba nua'ewa, a na 'idewai siwe a nuani kebu tamu sai'afo a na 'idewaiga. We'e tamu nani a na veifufuyeni yami 'eba 'isa. 'Eba 'isanina 'asa'aiana Iona, taunina Yaubada yana tolu'ivona, igana bwaikina kamoneye i miamia 'aiata 'aitonu, mulieta i souyeni.” Iesu i vona'a'ava, i 'iawedi i nago tulineye. ");
INSERT INTO yml_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mulieta Iesu ma yana tovetutuyamavo i damana lavu vi'ainega, siwe tovetutuyamavo nuadi i fani, kebu tamu 'ani'ani i da 'ewaiga. ");
INSERT INTO yml_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iesu vona-awatabaiega i velu'ase'asedi bega tomotoga yadi sauluva sakoidi kebu i na tunuvedamanidi i vo, Taunimi 'wa na 'i'isave'avinimi i na nunago Falisi wata Sadusi yadi isita i na vedamanimi i na 'ivesakoimi.” ");
INSERT INTO yml_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","'Aise'avadi i veifufu i vo, Isita beledi 'ana 'eba 'ivebwaika, bani'odi i voneyediga fai 'ida beledi kebu ta da 'ewadiga.” ");
INSERT INTO yml_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu yadi vona i 'asetai bega i vonedi i vo, Awale nuafoumi i veviga 'wa veveifufu beledi faifaina? Yami vetumagana mweana. ");
INSERT INTO yml_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bola kebu 'wa da 'asetakuga yau 'aku fata 'ani'ani a na velemi. 'Wa na nuani basenadi 'ani'ani 5 a 'ivividi, tomotoga 5,000 i 'ani, mulieta i 'ani-wayogeni bayawa 'ifwaidi 'wa veadagidi. ");
INSERT INTO yml_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Wata 'wa na nuani basenadi 'ani'ani 7 'waidiega tomotoga 4,000 a ve'anidi wata bayawa 'ifwaidi 'wa veadagidi. ");
INSERT INTO yml_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Awale yaku vona kebu 'wa da 'asetaiga. 'Omi 'wa vo 'ako yau a vonavona beledi faifaina, siwe kebu. Begaidi a na veifufu-vaitugana 'waimie, taunimi 'wa na 'i'isave'avinimi i na nunago Falisi wata Sadusi yadi isita i na vedamanimi i na 'ivesakoimi.” ");
INSERT INTO yml_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nika tovetutuyamavo i 'asetai Iesu kebu i da vonavona isitanina beledi 'ana 'eba 'ivebwaika faifaina, we'e mogitana i vonavona Falisi wata Sadusi yadi ve-vekavekali kebu i na vedamanidiga. ");
INSERT INTO yml_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu ma enavo i nagoi tamu 'awalawa 'waineye 'atamana Sisalia Filifai lilivaneye, bei yana tovetutuyamavo i velutoliedi i vo, 'Wa da nogaiga tomotoga yadi veifufu yau a vetomotogaotoga aitoi?” ");
INSERT INTO yml_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tovetutuyamavo yana velutoli i tutuli i vo, 'Ifwaidi tomotoga i vonaga 'omu Ioni Tobafitaiso i yawasa-vaitugana, 'ifwaidi i vonaga 'omu Ilaitia abamayega i obuma wata 'ifwaidi i vonaga 'omu Ielemaia 'alo tamu Yaubada yana tolu'ivona wafayega i tovoi.” ");
INSERT INTO yml_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iesu yana tovetutuyamavo i velutoliedi i vo, We'e 'omi, 'wa da nuaniga yau aitoi?” ");
INSERT INTO yml_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimoni Fita i vo, 'Omu Keliso, Yaubada miamia-vagaina Natuna wata 'ana Venua'ivina.” ");
INSERT INTO yml_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu i voneni i vo, Saimoni, 'omu Iona natuna, Yaubada i vesauluva 'atumaina 'waimuye fai 'aku 'aseta kebu tomotogaotoga i da vemu, yamu 'asetanina tonovina i mai abamayega Tamaku 'wainega. ");
INSERT INTO yml_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Fai 'u 'asetakuga begaidi a na vonemu. 'Omu Fita, (wagavanina 'ana 'aseta Kileu), kileunina bababana tabwaneye yaku 'Aila'a a na va'augidi bega i na vefue. Yaku 'Aila'a i na mia-vagata, towafa yadi 'eba mia toketokena kebu 'ana fata i na tala'avui. ");
INSERT INTO yml_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Veimea a na velemu tomotoga yadi luku Yaubada yana 'Eba Veimea 'waineye faifaina. Ava'ai sauluvaga 'u na talabodeni fwayefwayeye, wata abame Yaubada i na talabodeni, ava'ai sauluvaga 'u na tauyeni fwayefwayeye, wata abame Yaubada i na tauyeni.” ");
INSERT INTO yml_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mulieta Iesu yana tovetutuyamavo i talabodebodedi i vo, Kebu tamu aitoi 'wa na voneni yau Keliso, Yaubada 'ana Venua'ivina.” ");
INSERT INTO yml_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tutuyanina 'waineye Iesu i velamu i kikiavemageta yana tovetutuyamavo 'waidie i lubwaineni i na nago Ielusalema, bei veviga bwaikina i na veluagai me Diu yadi to'edakumetavo 'au'auveadi, tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo 'waidiega. I na veimea i na wafa siwe 'aiata 'ana vetonu 'waineye Yaubada i na sivetovoia. ");
INSERT INTO yml_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Fita Iesu i voneni i nagoi tulidie bega i talabodeni i vo, 'Auvea, kebu bani'odi 'u na voneyediga. Veviga wata wafa 'u veifufuyediga Yaubada i da talabodedi bega kebu i da sousouyedi 'waimuye.” ");
INSERT INTO yml_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu i sivilai Fita i voneni i vo, 'U vaganago, yamu nuanuananina Seitani yana nuanua. Yaku 'eda 'u totovibodai, yamu nuanuananina tomia fwayafwaya yadi nuanua, kebu Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wata Iesu i vona yana tovetutuyamavo 'waidie i vo, 'Ai'edi aitoi nuanuana mogitana i na mai 'waikuye taiadi 'a na nagoga, nagami taunina yana nuanua i na bailedi. Fai i na vematayakeyakeku veviga bwaikina i na veluagai yau bani'odi a na veluagai. Voke i na wafa faifaiku yau bani'odi a na wafa 'ai lagalagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","'Ai'edi aitoi yana mia 'ana 'atumaina i na ve'o'oleni, kebu nuanuana yawaina i na tauyeni faifaiku, taunina i na wafaotoga. We'e 'ai'edi aitoi yana mia 'ana 'atumaina wata yawaina i na tauyedi faifaiku, mia 'atumaina wata miamia-vagaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","'Ai'edi tamu aitoi fwayafwaya matatabuna 'ana kukua i na 'ewadi mulieta yawaina i na 'a'ava, ava'ai 'ana 'atumaina? Kebu 'ana fata tamu nani 'wainega yawaina i na kimwanei. ");
INSERT INTO yml_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Fai 'awaie yau a vetomotogaotoga a na souyeku Tamaku yana mageta mataududulina 'wainega, yaku anelose taiadi, mulieta tomotoga matatabudi a na tutulidi yadi sauluva 'aitamogana 'aitamogana 'adi 'isa'isa bani'odi. ");
INSERT INTO yml_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A vona mogitana 'waimie, 'omi 'ifwaimi bola ma yawaimi 'wa na miamiani, yau a vetomotogaotoga 'wa na 'iseku a na mai tomotoga matatabumi a na veimeyemi.” ");
INSERT INTO yml_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","'Aiata 6 i 'a'ava, mulieta Fita, Iemesa ma taina Ioni, Iesu i 'edakumesedi, 'aise'avadi i laka 'oyeye. ");
INSERT INTO yml_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","I miamiani nika tovetutuyamavo matadie Iesu 'ana 'isa i vetuli, maigina i magetai inala bani'odi wata 'ana talauma 'adi lau'avu mataududulidi. ");
INSERT INTO yml_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","I 'ise'iseni nika tomotoga 'adi 'ailuga i souyedi Iesu taiadi i veveifufu. Tomotoganidi Mosese wata Ilaitia, taunidi basenadiotoga Yaubada yana tolu'ivonavo. ");
INSERT INTO yml_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Fita i vona Iesu 'waineye i vo, 'Auvea, 'ima taiadi ta miamiani, nani 'atumaiotogina 'waimeye. 'Ai'edi nuanuamu lau'weta 'aitonu 'a na 'idewadi, tamu 'omu faifaimu, tamu Mosese, tamu Ilaitia.” ");
INSERT INTO yml_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Fita bola i veveifufu waowa mataududulina i mai i tavunidi, waowanina 'wainega bona i souyeni i vo, De'e Natuku nuafouku faifaina a sosoana bwaikina. Nuanuaku bonana 'wa na nogai.” ");
INSERT INTO yml_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tovetutuyamavo 'adi 'aitonu bonananina i nogaiga i kololo-'afo'afo i lumata'afufu. ");
INSERT INTO yml_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iesu i mai i 'abitonovidi i vonedi i vo, Kebu 'wa na kolologa, 'wa tovoi.” ");
INSERT INTO yml_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tutuyanina i dadaga-lakata kebu tamu aitoi i da 'iseniga, Iesu 'aiseotogina. ");
INSERT INTO yml_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","'Oyayega i obuobuma Iesu i velu'ase'asedi i vo, Naninidi 'wa 'isediga kebu tamu aitoi 'wa na voneniga, nagami yau a vetomotogaotoga wafayega a na tovoi, mulieta 'wa na lu'ivona.” ");
INSERT INTO yml_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yana tovetutuyamavo i velutolieni i vo, Awale ve'etoboda 'adi tovevo i vonaga i vo, Nagami Ilaitia i na mai, mulieta Yaubada 'ana Venua'ivina i na souyeni?’” ");
INSERT INTO yml_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu yadi velutoli i tutuli i vo, Ava'ai i voneyeniga de'e mogitana, nagami Ilaitia i na mai Yaubada 'wainega, nani matatabuna i na 'ivenonogidi. ");
INSERT INTO yml_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","We'e a na vonemi, Ilaitia 'akonadi i mai siwe tomotoga kebu i da 'isa'inanaiga, begaidi vitanidi nuanuadi i na veleniga mogitana i veleni. Wata bani'odi yau a vetomotogaotoga vita i na veleku.” ");
INSERT INTO yml_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nika tovetutuyamavo i nuani wata i 'asetai Ioni Tobafitaiso faifaina i vonavona. ");
INSERT INTO yml_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tutuyanina Iesu ma enavo i le'wai laube'uye 'aila'a 'waidie, tamu tomogo i mai ma yana ve'ililibu i 'odu Iesu mataneye. ");
INSERT INTO yml_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","I voneni i vo, 'Auvea, natuku iavetana 'u da 'isanuakalikalieni. Tutuya fuedi i vavatu'oga wata i veveviga bwaikina. I be'ube'u 'ai 'ala'alaina 'waineye wata ufeye. ");
INSERT INTO yml_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A mieni yamu tovetutuyamavo 'waidie siwe kebu 'adi fata i na 'ive'atumaiaga.” ");
INSERT INTO yml_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesu tomotoga i vonedi i vo, 'Omi tovekali. Awale Yaubada yana toketokena kebu 'wa da vetumaganeniga? Tutuya manamanawena taiadi ta miamia wata a totokemaigeku siwe kebu mogitana 'wa da vetumaganeku. Kwamananina 'wa mieni ta na 'iseni.” ");
INSERT INTO yml_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu yaiaina i voneni i 'awa'a'ia kwamana 'wainega nika i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mulieta 'aise'avadie tovetutuyamavo Iesu i velutolieni i vo, Awale 'ima 'a vona yaiaina kebu i da 'awa'a'iaga?” ");
INSERT INTO yml_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iesu yadi vona i tutuli i vo, Fai bola yami vetumagana siaidi. A vona mogitana 'waimie, 'ai'edi yami vetumagana 'ana vebwaika bani'odi 'ayawana bilana siaina, 'ami fata 'wa da vona 'oya de'e 'waineye 'wa da vo, 'U tovoi 'u nago sino bei,’ nika i da nago. We'e 'ai'edi yami vetumagana i na vevebwaika, nani matatabuna 'ami fata. ");
INSERT INTO yml_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Side yaiainanidi kebu 'adi fata i na 'awa'a'idi 'ana tugusa velu'ui toketokena 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tutuyanina Iesu ma yana tovetutuyamavo i miava'auta 'awalawa Galili 'waineye Iesu i vonedi i vo, 'Awaie yau a vetomotogaotoga tamu aitoi i na 'etogiluveku 'aku gaviavo 'waidie i na 'ive'aviniku. ");
INSERT INTO yml_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","I na luvewafaku, siwe 'aiata 'ana vetonu 'waineye ma yawaiku Yaubada i na sivetovoiku.” Tovetutuyamavo i nogai, nuadi i vita-'afo'afo. ");
INSERT INTO yml_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu ma yana tovetutuyamavo i maia 'atamana Kafaneomi, bei takesi Vanuga 'Eba Velu'ui faifaina 'ana tolaugogona i maia Fita 'waineye i velutolieni i vo, Yamu Tove, takesi Vanuga 'Eba Velu'ui faifaina, i yatoyato?” ");
INSERT INTO yml_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Fita i vo, E'e, i yatoyato.” Mulieta Fita i luku vanuge, bola kebu i da veifufuga, Iesu i vona-matayo'o i vo, Saimoni, 'u da nuani, fwayafwaya 'ana toveimea bwaikidi, nuanuadi egavo i na takesi? Taunidi natudiavo 'alo mali tomotoga?” ");
INSERT INTO yml_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Fita i vo, Mali tomotoga i na takesi.” Iesu i voneni i vo, Vetuma yau fai Yaubada Natuna, kebu i da lubwaineku yana Vanuga 'Eba Velu'ui faifaina a na takesi. ");
INSERT INTO yml_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Siwe 'ai'edi takesinina yato a na bailaga, tolaugogonanidi a na 'ivebunumayagidi bega 'asa'aiana ta na yato. Nuanuaku 'u na nago lavuye, igananina nagami 'u na 'onaiga 'awanega mani 'u na 'ewai. Maninina 'omu wata yau yada yato 'ana 'etowava.” ");
INSERT INTO yml_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tutuyanina 'waineye tovetutuyamavo i nagoi Iesu 'waineye i velutolieni i vo, Aitoi bwaikaotogina Yaubada yana 'Aila'a nageneye?” ");
INSERT INTO yml_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iesu tamu kwamana i goleni i mai matadie i tovoi. ");
INSERT INTO yml_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Mulieta Iesu i vonedi i vo, A vona mogitana 'waimie, 'ai'edi nuanuami 'wa na luku Yaubada yana 'Aila'a nageneye, i lubwainemi 'wa na nuavilami wata 'wa na nuaobu yavayavava bani'odi. We'e 'ai'edi kebu nuanuami, kebu tamu sai'afo 'wa na luku. ");
INSERT INTO yml_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aitoi i na nuaobuga kwamana de'e bani'odi taunina bwaikaotogina Yaubada yana 'Aila'a nageneye. ");
INSERT INTO yml_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","De'e kwamananina 'wa 'ise'iseniga, 'ai'edi aitoi ma yana nuakalikali tamu kwamana de'e bani'odi i na 'ivaiseni faifaiku, siwe 'asa'aiana yau i 'ivaiseku. ");
INSERT INTO yml_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","'Ai'edi aitoi i na vetumagana 'waikuye kwakwama de'e bani'odi, siwe tamu tomogo i na vetalaimimili i na sakonaga, bola tomogonina veviga bwaikaotogina i na veluagai Yaubada 'wainega. Siwe bola tomogonina kebu i da vetalaimimilaga, bei tomotoga 'ifwaidi kileu vitana i da yogona-matayo'oi 'odoneye i da taweni malaveseye, veviga siaina i da veluagai. I da wafa-matayo'oga i lubwaineni, nika kebu i da vetalaimimilaga wata kebu veviga bwaikaotogina i da veluagai Yaubada 'wainega. ");
INSERT INTO yml_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tomia fwayafwaya nuakalikalimi, fai 'awasasamie 'eba sailubu fuedi 'waidiega tomotoga i sakosakona. 'Eba sailubu mogitana i na sousouyedi 'waimie, siwe 'ai'edi aitoi tamu tomogo i na silubuya bega i na sakona, nuakalikalina fai 'awaie vita bwaikina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","'Ai'edi nimamu 'alo 'agemu 'aitamogana 'wainega sai'afoga 'u da sakona, 'u boboi 'u taweni bega kebu 'u na sakona. Nika 'amu fata 'aitamoganega 'u na luku abame. We'e nimamu 'alo 'agemu 'ailugana 'waidiega 'u na sakosakonaga, mulieta 'u na wafa 'u na luku 'ai-'ala'alase, veviga bwaikaotogina 'u na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","'Ai'edi sai'afoga 'u da sakona matamu vi'ainega, 'u kiamwanuya bega kebu 'u na sakona. 'U na kiamwanuyaga veviga sai'afo, nika kebu 'u na sakonaga, mulieta 'amu fata 'aitamoganega 'u na luku abame. We'e 'ai'edi matamu 'ailugana 'waidiega 'u na sakosakonaga, mulieta 'u na wafa 'u na luku 'ai-'ala'alase, veviga bwaikaotogina 'u na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","'Wa na 'isa'isa, kwakwama de'e bani'odi kebu 'wa na awaobuobuyediga. A vona mogitana 'waimie yadi anelose abame tutuya matatabuna Tamaku mataneye i miamia. ");
INSERT INTO yml_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yau a vetomotogaotoga a maiga, egavo Yaubada yana 'eda'eda i bavuyeni bani'odi i vuyo, a na 'ita'ita'iedi. ");
INSERT INTO yml_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","'Wa da nuani. 'Ai'edi tamu tomogo ma yana sifi 100, we'e tamu i na vuyoga bani'odi i na munegi? Yana sifi 99 i na yatodi i na miamiani 'oya 'ifineye we'e i na nago sifinina i vuyoga i na lualeni. ");
INSERT INTO yml_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A vona mogitana 'waimie, tutuyanina i na veluagaiga i na sosoana-'afo'afo sifinina faifaina, we'e yana sifi 99 kebu i da vuyoga, faifaidi sai'afo. ");
INSERT INTO yml_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wata bani'odi, Tamaku abame kebu nuanuana tamu yaku kwamana i na vuyo nika i na wafa. ");
INSERT INTO yml_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","'Ai'edi iamu i na vesauluva sakoina 'waimuye, 'u na nago 'waineye 'aise'avami yana sakonanina 'u na lu'ivoneyeni 'waineye. 'Ai'edi bonamu i na nogai i na ve'awamogitana nika bei 'wa na veiana-vaitugana. ");
INSERT INTO yml_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","We'e 'ai'edi bonamu kebu i na nogaiga, tamu tomogo 'alo tomotoga 'adi 'ailuga taiadi 'wa na nagoi 'waineye bega nani matatabuna 'wa na veifufuyediga tovainenega 'ailuga 'alo 'aitonu 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","'Ai'edi bonami kebu i na nogaiga, 'u na sivemageseni tovetumaganavo matatabudi 'waidie. 'Ai'edi yadi nuanua i na vedumwe'ai'aieniga 'wa na lu'idieni 'waimiega, kumanina bani'odi Yaubada 'ana tobavu 'alo tosakona. ");
INSERT INTO yml_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","'Omi yaku tovetutuyamavo a na vonemi, ava'ai 'wa na talabodeni fwayefwayeye, wata abame Yaubada i na talabodeni, ava'ai 'wa na tauyeni fwayefwayeye, wata abame Yaubada i na tauyeni. ");
INSERT INTO yml_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Wata a na vonemi, de'e bei fwayefwayeye 'ai'edi 'ami 'ailuga yami nuanua 'aitamoganega 'wa na velu'ui, Tamaku abame yami nuanua i na 'idewai. ");
INSERT INTO yml_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","'Ana fata i na 'idewai fai 'ai'edi tomotoga 'adi 'ailuga 'alo 'adi 'aitonu i na va'auta 'aku wagavayega, yau lilivadie.” ");
INSERT INTO yml_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mulieta Fita i mai Iesu i velutolieni i vo, 'Auvea, 'ai'edi iaku tutuya fuedi sauluva sakoina i na 'i'idewaiga 'waikuye, 'aivia yaku nuatavuna? Yana sakonanidi a na nuatavunidiga tutuya 7 'alo 'aivia?” ");
INSERT INTO yml_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu i vo, Kebu 7-'ava, we'e mogitana tutuya matatabuna. ");
INSERT INTO yml_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","'Wa na nunuatavunaga fai tomotoga Yaubada yana 'Aila'a nageneye side bani'odi. Tamu toveimea bwaikina, basenadi yana tofolovavo nani 'ifwaidi i 'ewa-maimaigidi 'wainega, nuanuana i na tutulidi. ");
INSERT INTO yml_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tofolovanidi 'aitamogana 'aitamogana i vonevonedi i mimaia 'waineye we'e tamu i luku 'waineye i na tutula, basenadi mani bwaikaotogina i 'ewai bani'odi 10 milioni Kina. ");
INSERT INTO yml_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tofolovanina kebu 'ana fata i na tutuli bega 'ana toveimea i vona i vo, Tomogo de'e taunina, yana vavine, natunavo wata yana kukua matatabuna 'wa na nawedi tamu tomogo i na kimwanedi yana tofolova-maimaiga, tutulidi 'wa na miedi bega maninina i 'ewaiga i na taobwai.’ ");
INSERT INTO yml_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tofolovanina ma yana ve'ililibu i lumata'afufu 'ana toveimea mataneye i voneni i vo, 'Auvea, 'u da lulukamata, nani matatabuna bola a na tutulidi.’ ");
INSERT INTO yml_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","'Ana toveimea i 'isanuakalikalieni bega i vo, 'Asa'aiana a nuatavunimu, 'u nago, kebu 'u na tutulaga.’ ");
INSERT INTO yml_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tofolovanina i sousouyeni nika tamu iana tofolova i veluagai, kumanina basenadi mani sai'afo siaina bani'odi 100 Kina i veleni. 'Odoneye i 'abi sai'afoga i da kiami'ai i voneni i vo, Maninina basenadi a velemuga, 'asiauotoga 'u na tutuli.’ ");
INSERT INTO yml_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Iana i lumata'afufu mataneye i voneni i vo, 'U da lulukamata, bola a na tutuli.’ ");
INSERT INTO yml_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Siwe kebu bonana i da nogaiga, nuanuana i na tutuli bega yana veimea 'wainega i yatoi vanuga yogona nageneye, bei i na miamia 'ana tugusa maninina i na tutuli, mulieta i na souyeni. ");
INSERT INTO yml_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","'Ifwaidi tofolovavo iadi yana sauluva i 'iseni nuadi i vita-'afo'afo, bega i nagoi 'adi toveimea 'waineye i lu'ivona. ");
INSERT INTO yml_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mulieta toveimeanina yana tofolova, kumanina igodi i da tutula 10 milioni Kina i goleni i mai i voneni i vo, 'Omu tofolova sakoimu, 'u velu'ui-nuakalikali 'waikuye maninina igodi 'u da tutuliga a nuatavuni. ");
INSERT INTO yml_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","I lubwainemu iamu 'u da 'isanuakalikalieni, yau bani'odi a 'isanuakalikaliemu.’ ");
INSERT INTO yml_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","'Ana toveimea ma yana nuasako i yatoi vanuga yogona nageneye, bei vematavuloga i na veveluagai 'ana tugusa maninina i na tutuli, mulieta i na souyeni.” ");
INSERT INTO yml_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Vona-awatabainina i 'a'avana Iesu i vo, 'Ai'edi tofolovanina sakoina 'wa na salaiga, kebu ma yami nuakalikali emiavo yadi sakona 'wa na nunuatavunidiga, wata bani'odi Tamaku abame 'aitamogana 'aitamogana vita bwaikina i na velemi.” ");
INSERT INTO yml_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu yana ve nuatavuna faifaina i 'a'ava, 'awalawa Galili i 'iaweni, i vilai i nago Ufa Iolidani i damani i nago 'awalawa Iudia. ");
INSERT INTO yml_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","'Aila'a bwaikina i yogo'waili i nagoi, bei toviga i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Me Diu totafalolo Falisi nuanuadi tomotoga i na nuasako Iesu 'waineye begaidi 'aila'a matadie i velutolieni i vo, 'U da 'asetai, i lubwaineni tamu tomogo yana vavine i na vesa'ilidi 'ai'edi kebu ma yana lamunaga?” ");
INSERT INTO yml_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iesu yadi velutoli i tutuli i vo, Yaubada yana Buki nageneye de'e vonanina nagi faifaina 'wa da vo kebu 'wa da lu'iawawaiga. I vo, Tutuya 'eba velamu 'waineye Yaubada tomotoga i 'idewadi, iavetana wata vevinena.’ ");
INSERT INTO yml_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wata Yaubada i vo, Faifainanina 'ai'edi tomogo i na nagiga, 'akonadi i 'awa'idia tamana wata inana 'waidiega, yana vavine taiadi i luvetubama. 'Adi 'ailuga siwe 'wa da vo tomogo 'aitamogana.’ ");
INSERT INTO yml_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yaubada 'akonadi i luvetubamidi nika i ve'aitamoga, kebu 'adi 'ailuga, begaidi kebu i da lubwaineni tamu aitoi 'alo taunidi i na vemia'idiedi.” ");
INSERT INTO yml_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Falisi Iesu i velutolieni i vo, Vetuma ava'ai faifaina basenadiotoga Mosese i tauyeda tamu lubulubu 'waineye sa'ila 'ana vona ta na kilumi mulieta vavine ta na veugeugedi?” ");
INSERT INTO yml_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu i vonedi i vo, Mosese i tauyemiga fai sauluva 'atumaina 'wa baila, we'e tutuya 'eba velamu 'wainega i maiga 'asiau Yaubada kebu bani'odi nuanuana. ");
INSERT INTO yml_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","We'e yau a na vonemi, 'ai'edi aitoi yana vavine i na vesa'ilidi, 'asa'aiana 'akonadi i 'anivelenedi sakona 'waineye. Siwe 'ai'edi vavinenidi basenadi tamu tomogo taiadi i na veluaga yadi lamoga i na vesa'ilidiga, tomogo kebu i da sakona.” ");
INSERT INTO yml_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yana tovetutuyamavo i voneni i vo, 'Ai'edi sakona 'aisena faifaina Yaubada i tauyeni sa'ila, vetuma 'ai'edi kebu ta na nagiga, de'e nani 'atumaina.” ");
INSERT INTO yml_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu i vo, Tomotoga matatabudi kebu 'adi fata taunidi i na tauyedi venina 'waineye, egavo Yaubada i na 'ivaisedi 'aisedi 'adi fata. ");
INSERT INTO yml_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Egavo kebu i na nagiga yadi lamu tulina tulina. Side bani'odi, tomotoga 'ifwaidi daba i 'ewai bega kebu 'adi fata 'waidiega kwakwama i na veluagadi, 'ifwaidi fai i vetubusakosako daba bani'odi, we'e 'ifwaidi nuanuadi Yaubada i na veimeyedi wata 'aisena 'waineye i na folofolova bega kebu i da nagiga. Egavo yaku vonanina i nuani 'waidie 'atumaina, i lubwainedi yaku vonanina i na vematayakeyakeni.” ");
INSERT INTO yml_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tomotoga 'ifwaidi natudiavo i miedi nuanuadi Iesu i na 'abitonovidi i na velu'ui faifaidi, siwe yana tovetutuyamavo i talabodebodedi. ");
INSERT INTO yml_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iesu i vo, Kwakwama 'wa bailedi i na maia 'waikuye, fai egavo taunidi tonuaobu yavayavava de'e bani'odi, 'adi fata taunidi i na tauyedi bega Yaubada i na veveimeyedi yana 'Aila'a nageneye.” ");
INSERT INTO yml_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nimana i yatoi 'aitamogana 'aitamogana 'waidie, i velu'ui Yaubada 'waineye faifaidi mulieta i tauya. ");
INSERT INTO yml_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tamu tutuya tamu tomogo i mai Iesu 'waineye i velutolieni i vo, Tove, ava'ai sauluvaga 'atumaina a na 'idewai bega mia 'atumaina wata miamia-vagaina a na veluagai?” ");
INSERT INTO yml_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu yana velutoli i tutuli i vo, Awale faifaina 'u velutolieku sauluva 'atumaina faifaina? Tomogo 'aitamogana, 'aiseotogina 'atumaina. 'Ai'edi nuanuamu mia 'atumaina wata miamia-vagaina 'u na veluagaiga, Tomogonina taunina Yaubada, yana veimea 'u na vevematayakeyakedi.” ");
INSERT INTO yml_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Tubuvauvaunina i vo, Ava'ai veimeaga?” Bega Iesu i voneni i vo, Kebu 'u na luvewafaga, kebu tamu aitoi yana vavine 'u na luobuyediga, kebu 'u na vainagoga, kebu 'u na vekali tamu tomogo yana sauluva faifaina, tamamu wata inamu 'u na ve'ililibuyedi, we'e iamu 'u na nuakalikalieni, taunimu 'amu nuakalikali bani'odi.” ");
INSERT INTO yml_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tubuvauvaunina Iesu yana vona i tutuli i vo, Veimeanidi 'u voneyediga matatabuna a vematayakeyakedi. Wata ava'ai nuanuamu a na 'idewai?” ");
INSERT INTO yml_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu i voneni i vo, 'Ai'edi nuanuamu yamu sauluva 'atumai'avana 'u na vilamu 'u na nago, yamu kukua wata nani matatabuna 'waimuye i 'eno'enoviga 'u na vekimwaneyedi, tutulidi 'u na 'ewadi, bega egavo i vewekowekomaga 'u na 'ivaisedi nika 'u na ve'ai'aiwabu abame. 'U na 'anivelenedi i na 'a'avana 'u na mai 'u na vetutuyameku.” ");
INSERT INTO yml_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tubuvauvaunina Iesu yana vona i nogai nuana i vita i tauya fai yana kukua bwaikina nuana i loloi. ");
INSERT INTO yml_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tomogonina i tauya i nunago, Iesu yana tovetutuyamavo i vonedi i vo, A vona mogitana 'waimie, tove'ai'aiwabu yadi luku Yaubada yana 'Eba Veimea 'waineye vitana. ");
INSERT INTO yml_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Wata a na vonemi, bawe yana luku aima mataneamo vitana, we'e tove'ai'aiwabu yadi luku Yaubada yana 'Eba Veimea 'waineye vitaotogina.” ");
INSERT INTO yml_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yana tovetutuyamavo i nogaiga, nuadi i voganidi i velutolieni i vo, Vetuma aitoi 'ana fata 'ita'ita'i i na veluagai?” ");
INSERT INTO yml_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu i 'isadewadi i tutula i vo, Tomotoga 'aise'avadi kebu 'adi fata 'ita'ita'i i na veluagai, we'e Yaubada 'waineye nani matatabuna 'ana fata.” ");
INSERT INTO yml_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nika Fita i vona i vo, Maide 'ima nani matatabuna 'a bailedi 'a maia 'a vevetutuyamemu. 'Awaie ava'ai 'a na veluagai Yaubada 'wainega?” ");
INSERT INTO yml_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu i vonedi i vo, A vona mogitana 'waimie, 'awaie Yaubada nani matatabuna i na 'ive'ivaudi, tutuyanina 'waineye yau a vetomotogaotoga ma yaku veimea a na miabui didiga mataududulina 'waineye. We'e 'omi yaku tovetutuyamavo, 'awaie veimea 'ana didiga 12 'waidie 'wa na miabui, bega me Isileli 'adi wauma 12 'waidiega i na vonayavuga 'waimie. ");
INSERT INTO yml_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Egavo yadi vanuga i 'iawedi faifaiku, 'alo tamadiavo, inadiavo, novudiavo, ediavo, natudiavo, 'alo yadi tanoga i 'iawedi faifaiku, 'awaie naninidi faifaidi 'adi tutula bwaikaotogidi i na veluagadi ma 'adi 'imoso'i. Naninidi 'aitamogana 'aitamogana i 'iawediga faifaina 100 i na veluagai, mia 'atumaina wata miamia-vagaina taiadi i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Siwe tomotoga fuedi 'asiau i kumetaga 'awaie i na vemuli, we'e egavo 'asiau i vemuliga ma'itufa i na kumeta.” ");
INSERT INTO yml_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iesu vona-awatabaiega i vonedi i vo, Yaubada yana 'Aila'a 'adi tutula 'ana 'ewa side bani'odi. Tamu tomogo ma yana bakula 'awa'awaiogose i tovoi i nago i lauala yana tofolova i na 'ewadi. ");
INSERT INTO yml_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tomotoga 'ifwaidi i veluagadi i vonedi i nogaya wata 'adi tutula i lu'ivona-vagaseni 'waidie i vo, Tutula 'aiata 'aitamogana 'ana 'etowava a na velemi,’ mulieta i vetunedi i nagoi i na folova. ");
INSERT INTO yml_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","4","Inala i vagalakama wata i nago 'atamanafouye tomotoga 'ifwaidi i veluagadi i mia-maimaiga bega i vonedi i vo, 'Omi wata 'wa na nagoi 'wa na folova yaku bakule, i na 'a'ava a na tutulimi yami folova 'ana laubwaina 'wainega.’ ");
INSERT INTO yml_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","I nagoi i folofolova, mulieta 'aiata 'ana utukamwana 'waineye wata lavilavie, 'ifwaidi i veluagadi i vonedi i folova. ");
INSERT INTO yml_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lavilaviogose wata i nago 'atamanafouye, 'ifwaidi i veluagadi i miamiani bega i velutoliedi i vo, Awale 'wa mia-maimaiga, kebu tamu ava'ai 'asiau 'wa da 'i'idewaiga?’ ");
INSERT INTO yml_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tomotoganidi i vo, 'Ai'edi tamu aitoi i da 'ewama 'waineye 'a da folova, fai kebu, begaidi 'a miamiani.’ Tonibakula i vonedi i vo, A nuani 'omi wata 'wa na nagoi 'wa na folova yaku bakule.’ ");
INSERT INTO yml_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","'Akonadi sai'afoga i na dudubali, tonibakula tofolova 'adi to'isave'avina i voneni i vo, Tofolova 'u na goledi 'u na tutulidi, nagami egavo i vemuliga 'u na tutulidi, we'e egavo kumekumetana a 'ewadiga i na vemuli.’ ");
INSERT INTO yml_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tofolovanidi lavilaviogose i 'ewadiga 'adi tutula i veledi 'aiata 'aitamogana 'ana 'etowava. ");
INSERT INTO yml_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","We'e kumanidiavo 'awa'awaiogose i velamu i folovaga i 'iseni yadi nuanua i vo, Tovemuli i folova tutuya 'ale'usana siwe 'aiata 'aitamogana 'ana 'etowava i 'ewai, we'e 'ima 'aiata matatabuna 'a folovaga 'ako bwaikina 'a da 'ewai.’ Siwe wata tutulanina i 'ewaga matatabudi i vesala. ");
INSERT INTO yml_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","'Adi tutula i 'ewa'a'avana, i vebonavoluvolu tonibakula 'waineye i vo, Vevemulidi i folova 'awasasa 'aitamogana, we'e 'ima 'aiata matatabuna 'a folova inala bwaikina 'waineye, awale 'ama tutula taiadi i vesala?’ ");
INSERT INTO yml_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tonibakula tamu iadi i voneni i vo, Iaku, 'u ve'wada a na vonemu. Kebu a da vekaliemuga, 'asiau ta veifufuga 'u nuanuani a vo, Tutula 'aiata 'aitamogana 'ana 'etowava a na velemu,”’ nika 'u awave'atumaieni. ");
INSERT INTO yml_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","'Akonadi a velemuga 'asa'aiana 'u na 'ewai 'u na nago yamu vanuge. Nuanuaku tofolova vevemulina 'ana tutula wata 'omu 'amu tutula taiadi i na vesala. ");
INSERT INTO yml_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yau tauniku yaku mani, yaku 'eba veimea. Kebu yaku nuakalikali mali tomotoga 'waidie faifaina 'wa na ve'unumagigi.” ");
INSERT INTO yml_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Wata Iesu yana vona i luvaitugani i vo, Egavo 'asiau i vemuliga, 'awaie i na kumeta, we'e egavo 'asiau i kumetaga ma'itufa i na vemuli.” ");
INSERT INTO yml_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Tutuyanina Iesu i nunago Ielusalema yana tovetutuyamavo 12 i vonedi taiadi tulidie i nagoi i vonedi i vo, A na vonemi, ta nunagoiga Ielusalema bei yau a vetomotogaotoga i na 'etogiluveku tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo 'waidie i na veimea a na wafa. ");
INSERT INTO yml_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mulieta i na 'aniveleneku mali tomotoga kumanidiavo kebu Diu 'waidie, i na sidibidibieku, i na toke i na fitaliku wata i na tutufwaseku 'ai lagalagana 'waineye. 'Aiata 'ana vetonu 'waineye, Yaubada i na sivetovoiku.” ");
INSERT INTO yml_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tamu tutuya Sebedi yana vavine ma natudiavo i maia Iesu 'waineye, inadi ma yadi ve'ililibu i 'odu Iesu mataneye i velu'ui natudiavo faifaidi, Iemesa wata Ioni. ");
INSERT INTO yml_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesu i velutoliedi i vo, Ava'ai nuanuami?” Vavinenidi i vo, Tutuyanina 'u na ve-Kini nuanuama side natukwavonidi 'u da tauyedi i da miabui tamu 'amu 'atagiega, we'e tamu 'amu wamayega.” ");
INSERT INTO yml_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu Iemesa ma taina i vonedi i vo, 'Omi kebu 'wa da venua'ivinaga 'wa vevelu'ui 'waikuye. Sai'afoga veviga 'ana vedi a na yemuyeni, we'e 'omi 'ami 'ailuga 'ami fata vedinina 'wa na yemuyeni?” Yana vona i tutuli i vo, E'e, 'ama fata.” ");
INSERT INTO yml_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu i vo, 'Wa vonaga mogitana, 'aku vediega 'wa na yemu, siwe miabui 'aku 'atagiega wata 'aku wamayega yau kebu a da veveimeyediga. Didiganidi Tamaku i 'idewadi egavo i venua'ivinediga faifaidi.” ");
INSERT INTO yml_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tutuyanina tovetutuyamavo 'adi 10 yadi velu'ui i 'asetai, i kamogala Iemesa ma taina 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Begaidi Iesu matatabudi i va'augidi i vonedi i vo, 'Akonadi 'wa 'asetai toveimea bwaikidi wata to'edakumetavo yadi veimea toketokedi 'waidiega tomotoga i veveimeyedi. ");
INSERT INTO yml_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","We'e 'omi kebu bani'odi 'wa na munega. 'Ai'edi aitoi 'waimiega nuanuana i na vetomogo-bwaika, nagami i na vetofolova enavo 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","We'e 'ai'edi aitoi nuanuana i na veto'edakumeta 'waimie, nagami i na vetofolova-maimaiga 'waimie. ");
INSERT INTO yml_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yau a vetomotogaotoga 'wa na vetutuyameku. Yau a maiga, kebu a da vo, Tomotoga 'wa na foloveku,’ we'e mogitana a mai a na vetofolova tomotoga faifaimi wata yawaiku a na tauyeni tomotoga fuemi a na tuveobumi sakona 'waidiega.” ");
INSERT INTO yml_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu ma enavo 'atamana Ieliko 'wainega i tauya, tomotoga fueotogidi mulidie i nagoi. ");
INSERT INTO yml_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","We'e tomatasako 'adi 'ailuga 'edeye i miamiani, i nogai i le'wa i nunago, bega i vegolegole i vo, 'Auvea, 'omu Kini Devida tubuna, 'u da 'isanuakalikaliema.” ");
INSERT INTO yml_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'Aila'a i nogai i talabodedi i vo, 'Wa ve'wada,” nika tomatasakonidi i toke i vegolegole i vo, 'Auvea, 'omu Kini Devida tubuna, 'u da 'isanuakalikaliema.” ");
INSERT INTO yml_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu i tovoi i goledi i maia i velutoliedi i vo, Ava'ai nuanuami a na 'idewai faifaimi?” ");
INSERT INTO yml_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","I vo, 'Auvea, nuanuama matama i da ve'atumai 'a da 'isa.” ");
INSERT INTO yml_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu i 'isanuakalikaliedi matadi i 'abitonovidi nika i 'anialadi, Iesu mulineye i nago. ");
INSERT INTO yml_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Iesu ma yana tovetutuyamavo i nunagoi Ielusalema i le'wai 'atamana Bedifegi, 'Oya Olive 'waineye. 'Atamananina kebu 'ani'iega Ielusalema 'wainega. Bei Iesu tovetutuyamavo 'adi 'ailuga i vonedi i na kumeta wata i vo, 'Atamana debanagomiega 'waineye 'wa na nagoi, tutuyanina 'wa na le'wa 'wa na lukuluku doniki ma natudi 'wa na 'isedi i luifwedi i tovotovoi. 'Wa na yavudi 'wa na miedi 'waikuye. ");
INSERT INTO yml_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","'Ai'edi tamu aitoi i na vo, Awale 'wa yavuyavudi?’ 'Wa na vo, 'Auvea nuanuana,’ nika i na tauyedi.” ");
INSERT INTO yml_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iesu nuanuana doniki ma natudi i na miedi 'waineye nika tamu Yaubada yana tolu'ivona yana vona-samula 'ana mogitana i na souyeni. Basenadiotoga i kilumi Yaubada 'ana Venua'ivina faifaina i vo, ");
INSERT INTO yml_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ielusalema 'ana tomotoga 'wa na vonedi 'wa na vo, 'Wa na 'iseni, yami Kini i viwai 'waimie, kumanina tonuaobu, doniki kwavuneye i laka, we'e mogitana doniki tubuvauvauna.’” ");
INSERT INTO yml_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Bega tovetutuyamavo 'adi 'ailuga i kumeta Iesu yana nuanua i 'idewai, doniki ma natudi i miedi 'adi talaumayega doniki tubuvauvauna kwavuneye i ta'uli bega Iesu i laka tabwaneye. ");
INSERT INTO yml_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","'Aila'a bwaikina ma yadi ve'ililibu yana 'eda i 'ivivigavuya 'adi talaumayega wata welavi lukudiega. ");
INSERT INTO yml_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tokumeta wata tovemuli i toke i vegolegole Iesu faifaina i vo, Kaiwa, kaiwa. 'Omu Kini Devida tubuna. Taunina 'Auvea 'ana wagavayega i mimai, Yaubada i da vevesauluva 'atumaina 'waineye. Kaiwa, kaiwa, kumanina tabwaotogineye ta na subisubiai.” ");
INSERT INTO yml_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tutuyanina Iesu i luku Ielusalema fuedi i gagali i vo, Aitoi tomotogaga?” ");
INSERT INTO yml_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ediavo 'ifwaidi i vo, Taunina tamu Yaubada yana tolu'ivona 'ana wagava Iesu, Nasalediega 'awalawa Galili 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu i luku Vanuga 'Eba Velu'ui nageneye i 'isedi tokimwane wata tovekimwane matatabudi i sogiedi i obu, mani tulina tulina 'adi tosivedavedamana yadi talalia i tutuviladi we'e bunebune 'eba velomu faifaidi 'adi tovekimwane yadi 'eba miabui i tutufelefeledi. ");
INSERT INTO yml_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","I vonedi i vo, Basenadiotoga i kilumi Yaubada yana Buki nageneye, Yaubada i vo, Yaku vanuga 'ana wagava Vanuga 'Eba Velu'ui.’ Siwe 'omi 'wa vesivilai, tovainago yadi 'eba giva.” ");
INSERT INTO yml_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","I 'a'avana, mulieta tomatasako wata 'agedi sinunumidi i maia Vanuga 'Eba Velu'ui nageneye, Iesu i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","16","Tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo 'eba nua'ewa toketokedi Iesu i 'i'idewadi i 'isedi, wata i nogai Vanuga 'Eba Velu'ui nageneye yavayavava i vegolegole i vo, Yaubada 'ana Venua'ivina, Kini Devida tubuna ta na subiai.” Naninidi i 'isedi wata i nogaidi begaidi ma yadi kamogala i velutolieni i vo, Yavayavavanidi bonadi 'u nogai?” Iesu i vo, E'e, mogitana a nogai. We'e 'omi Yaubada yana Buki nageneye vona de'e 'wa da vo kebu 'wa da lu'iawawaiga i vona Yaubada 'waineye i vo, Yavayavava wata mwedamwedalidi 'u 'alaveleveledi, 'waidiega 'amu subia 'u veveluagai.’” ");
INSERT INTO yml_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Iesu i vona'a'ava, i 'iawedi i nago 'atamana Bedani, bei i 'eno. ");
INSERT INTO yml_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","I 'atai Iesu Bedaniega i vilai i mimai Ielusalema nika i lase. ");
INSERT INTO yml_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","'Ala'ai i 'isanaweni 'eda lilivaneye i vo 'ako ma vuagina, siwe i nago lilivaneye i 'iseni kebu vuaginaga luku'avana. Welavinina 'waineye i vona i vo, 'Omu 'asa'aiana, kebu wata 'u na vuavuaga,” nika 'ala'ai i bwavu-matayo'o. ");
INSERT INTO yml_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tovetutuyamavo i 'iseni nuadi i voganidi i vo, Bani'odi i munega i bwavu-matayo'o?” ");
INSERT INTO yml_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu yadi velutoli i tutuli i vo, A vona mogitana 'waimie, 'ai'edi kebu ma yami venuanaluga 'wa na vetumaganamo, yau 'ala'ai 'waineye a 'idewaiga, 'omi wata bani'odi 'wa na 'idewai. Kebu de'e bani'odi 'aisena, siwe wata 'ami fata de'e 'Oya Olive 'wa na voneni 'wa na vo, 'U tovoi, 'u obu eyage,’ nika i na obu. ");
INSERT INTO yml_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","'Ai'edi ma yami vetumagana 'wa na vevelu'uiga, 'ana fata naninidi nuanuami 'wa na veluagadi.” ");
INSERT INTO yml_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu i le'wa Ielusalema, i luku Vanuga 'Eba Velu'ui nageneye, tomotoga 'waidie i ve. Tovelomu yadi to'edakumetavo wata me Diu to'edakumeta 'au'auveadi i maia Iesu i velutolieni i vo, Nuanuama 'a na 'asetai aitoi i vetunemu bega naninidi 'u 'i'idewadi 'alo aitoi veimea i velemu?” ");
INSERT INTO yml_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu i vo, We'e tamu velutoli yau a na velemi, 'ai'edi yaku velutoli 'wa na tutula-'atumaiaga a na vonemi aitoi veimea i veleku bega nani de'e a 'i'idewadi. ");
INSERT INTO yml_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","'Wa da nuani, Ioni Tobafitaiso aitoi veimea i veleni bega tomotoga i bafitaisodi? Yaubada 'alo tomotoga?” To'edakumetanidi 'aise'avadi i veifufu i vo, Bani'odi ta na voneyedi? 'Ai'edi ta na vo, Yaubada veimea Ioni i veleni,’ 'ako i na vo, Vetuma awale kebu Ioni yana vona 'wa da vetumaganeni?’ ");
INSERT INTO yml_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wata 'ai'edi ta na vo, Tomotoga veimea Ioni i veleni,’ bola vita ta na veluagai 'aila'a 'waidiega fai i nuani Ioni tamu Yaubada yana tolu'ivona.” ");
INSERT INTO yml_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Begaidi Iesu yana velutoli i tutuli i vo, 'Ima kebu 'a da 'asetaiga aitoi veimea Ioni i veleni.” Iesu i vonedi i vo, Vetuma yau wata kebu a na vonemiga aitoi veimea i veleku bega folovanidi a 'i'idewadi.” ");
INSERT INTO yml_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Wata to'edakumetanidi i vonedi i vo, 'Wa na nuani, tamu tomogo natunavo iavetadi 'adi 'ailuga. Tulaina i voneni i vo, Natuku, nuanuaku 'asiau bakule 'u na folova.’ ");
INSERT INTO yml_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Siwe natuna i vo, Yau 'asa'aiana,’ mulieta i nuanua kebu'egana i nago i folova. ");
INSERT INTO yml_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Wata tamadi i nago natuna bwasiona i voneni i vo, 'Omu nuanuaku 'u na nago bakule 'u na folova.’ Natunanina i nogayeni i vo, 'Atumaina 'auvea, a na nago,’ siwe kebu i da nagoga.” ");
INSERT INTO yml_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bega Iesu to'edakumetanidi i velutoliedi i vo, Aitoi mogitana tamadi yana nuanua i 'idewai?” Yana velutoli i tutuli i vo, Tulaina.” Iesu i vonedi i vo, A vona mogitana 'waimie, takesi tolaugogona vivinagodi wata vevine toalagogona ma'itufa i lukuluku Yaubada yana 'Aila'a 'waineye we'e 'omi voke kebu. ");
INSERT INTO yml_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tomotoganidi nagami tosakona siwe i nuaviladi kwamananina tulaina bani'odi, Tamada yana nuanua i 'idewadi, we'e 'omi kwamana bwasiona yana sauluva 'wa salai. Ioni Tobafitaiso i mai Yaubada yana 'eda'eda tonovidi i vemiga, 'wa nogayenimo siwe kebu 'wa da 'idewadi. Tomotoganidi yadi sauluva sakoidi ma yadi vetumagana i nuaviladi Yaubada yana nuanua i 'i'idewadi, we'e 'omi yadi nuavilana 'wa 'iseni siwe kebu 'wa da vo 'a na nuavilama.” ");
INSERT INTO yml_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Wata to'edakumetanidi 'waidie Iesu i vona i vo, De'e tamu vona-awatabai. Tamu tomogo kalefa talagina i bakuli wata i kalieni. Vuagina 'ana 'eba vatanitani i 'idewai wata kileu i didigi, tabwaneye 'eba lu'atu'ai i yogoni. Mulieta tomotoga 'ifwaidi nimadie i yatoi i na 'isave'avini, nika i tauya i nago mali 'awalaweye. ");
INSERT INTO yml_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kalefa yana kumaga 'ana tutuya i le'wa, tonibakula yana tofolovavo i vonedi i nago yana bakula 'ana to'isave'avinavo 'waidie, vuaga 'ifwaidi i na miedi faifaina. ");
INSERT INTO yml_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Siwe to'isave'avinanidi tofolovavo i 'ive'avinidi, tamu i nikeimo, tamu i nikei i wafa wata tamu i lukileuya i wafa. ");
INSERT INTO yml_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mulieta tonibakulanina tofolovavo fuedi i vetunedi wata bani'odi i munegidi. ");
INSERT INTO yml_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","'Eba ve'a'avaotoga taunina natuna i vetunei i vona i vo, De'e natuku, i na ve'ililibuyeni.’ ");
INSERT INTO yml_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Siwe tutuyanina to'isave'avinanidi i 'iseni i mimai 'aise'avadi i vo, No'o tonibakula natuna, bola nani matatabuna i na 'ewadi i na veimeyedi. 'Wa maia ta na luvewafai bega naninidi ta na 'ewadi.’ ");
INSERT INTO yml_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bega i 'ive'avini i taweni i obu kalimulie, bei i luvewafai.” ");
INSERT INTO yml_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Iesu me Diu to'edakumetavo i velutoliedi i vo, 'Wa da nuani, tutuyanina tonibakula i na maiga, to'isave'avinanidi bani'odi i na munegidi?” ");
INSERT INTO yml_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yana velutoli i tutuli i vo, 'A nuani tosakonanidi i na nikedi i na wafa, mulieta tomotoga 'ifwaidi i na vonedi i na veto'isave'avina bega tutuyanina vuaga i na kumakumaga i na 'a'anivelenedi 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nika Iesu tamu vona-samula Yaubada yana Buki 'wainega i veifufuyeni 'waidie, tomotoga Yaubada 'ana Venua'ivina i na baileniga faifaina. I vo, 'Omi 'wa da vo de'e vonanina kebu 'wa da lu'iawawaiga i vo, To'aiyogonavo folova tamu i 'iseni siwe i baileni, tutuya de'e i ve'unututuyeni. 'Auvea taunina i 'idewai, 'ana 'isa 'waideye 'eba nua'ewa.’” ");
INSERT INTO yml_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Wata Iesu i vonedi i vo, 'Omi me Diu 'wa miamia Yaubada yana 'Aila'a nageneye siwe 'awaie i na bailemi, yana vetoveimea i na 'ewai 'waimiega ma'itufa mali tomotoga 'asa'aiana yana 'Aila'a i na veveimeyedi, kumanidiavo yana nuanua i na veve'ililibuyeni 'wa da vo i da vuavuaga-dewa. ");
INSERT INTO yml_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Egavo i na tayaidi i na be'u folovanina tabwaneye i na tudabedabedi, wata 'ai'edi folovanina i na 'anifoia tomotoga tabwadie i na tukudakudadi.” ");
INSERT INTO yml_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tovelomu yadi to'edakumetavo wata Diu totafalolo Falisi Iesu yana vona i nogai i 'asetai 'adi vona-awatabai, taunidi bani'odi to'aiyogonanidi wata to'isave'avinavo sakoidi. ");
INSERT INTO yml_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Igodi nuanuadi i da 'ive'avini siwe tomotoga i kololoyedi fai i vo, Taunina tamu Yaubada yana tolu'ivona.” ");
INSERT INTO yml_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Wata Iesu i ve tomotoga 'waidie vona-awatabaiega i vo, Tomotoga yadi luku Yaubada yana 'Aila'a 'waineye side bani'odi. Tamu toveimea bwaikina natuna iavetana yana nagi 'ana sakali i 'idewai. ");
INSERT INTO yml_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","I 'idewadewa i 'a'avana yana tofolovavo i vonedi i vo, 'Wa na nagoi tomotoganidi a tayegidiga, 'wa na vonedi i na maia.’ I nagoi i vonevonediga nika i baila. ");
INSERT INTO yml_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mulieta toveimeanina yana tofolovavo 'ifwaidi i vonedi i vo, Tomotoganidi a vonedi i bailaga, wata 'wa na vonedi 'wa na vo, Bulumakau veve'anidi wata 'ifwaidi 'aisaya 'akonadi i lalamidi wata nani matatabuna i 'idewadi i lulukamata. 'Wa na maia sakalinina 'waineye.”’ ");
INSERT INTO yml_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","Siwe wata i baila i nagoi taunidi yadi nuanua 'waidie. Tamu i nago yana bakule, tamu i nago yana sitoa 'waineye, we'e 'ifwaidi toveimea yana tofolovavo i 'ive'avinidi i nikedi i wafa. ");
INSERT INTO yml_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Toveimeanina vala i nogai i nuasako bwaikina, bega yana tolugaviavo i vonedi i nagoi to'ainikenidi i luvewafadi wata yadi 'atamana i kabuni. ");
INSERT INTO yml_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","I 'a'avana toveimeanina yana tofolovavo i goleva'augidi i vonedi i vo, 'Ani'ani 'akonadi a 'idewadewadi i lulukamata, siwe tomotoganidi a tayegidiga i baila, begaidi kebu i da lubwaineni i na mai. ");
INSERT INTO yml_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tutuya de'e 'wa na nagoi 'atamana bwaikina 'waineye bei egavo 'wa na veluagadiga 'wa na vonedi i na maia, yaku sakali 'waineye i na 'ani.’ ");
INSERT INTO yml_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bega tofolovavo i nagoi 'atamane tomotoga fuedi i veluagadi, yadi sauluva 'atumaidi wata sakoidi matatabudi i vonedi i maia bega toveimeanina yana vanuga bwaikina i veadagi. ");
INSERT INTO yml_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","12","Tomotoganidi i lukulukuga vanuge, nagi 'ana talauma i veleveledi bega i vavaigavu, mulieta toveimeanina i mai i na 'isedi. Tamu tomogo i 'iseni, nagi 'ana talauma kebu i da vigavuyeni bega i velutolieni i vo, Iaku, 'omu kebu nagi 'ana talauma 'u da vigavuyeni, awale 'u lukuma?’ Tomogonina kebu tamu ava'ai i da voneyeniga. ");
INSERT INTO yml_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bega toveimeanina yana tofolovavo i vonedi i vo, Nimana wata 'agena 'wa yogonidi 'wa taweni i na obu dudubale, bei i na 'we'we'wela wata maigina i na yuyuyuya fai veviga bwaikina.’” ");
INSERT INTO yml_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Iesu yana veifufu i 'a'ava i vo, Yaubada tomotoga fuedi i goledi, 'waidiega 'adi 'aivia bani'odi i venua'ivinedi we'e fuedi i vedumwe'ai'ai.” ");
INSERT INTO yml_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Totafalolo Falisi Iesu yana vona i nogai bega i nagoi 'aise'avadi i veifufu, nuanuadi i na velutolieni bonana i na nogai 'ai'edi i na vekali 'adi fata i na 'ive'avini. ");
INSERT INTO yml_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bega yadi tomotoga wata 'ifwaidi Kini Elodi yana tomotoga i vetunedi i maia Iesu 'waineye i velutoli i vo, Tove, yamu sauluva tonovidi, kebu 'u da vevekaliga. 'A 'asetamu tomotoga toketokedi kebu 'u da kololoyediga 'u totolimatanidi, we'e tomotoga sakoidi kebu 'u da vivieyediga, siwe 'u veve mogitana Yaubada yana nuanua tomotoga 'waimeye. ");
INSERT INTO yml_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","'U da nuani, i lubwaineda 'ida me Diu ta na takesi Loma yadi toveimea bwaikina Sisa 'waineye 'alo kebu? Nuanuama 'a na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iesu yadi nuanua sakoina i 'asetai begaidi i vonedi i vo, 'Omi tovekali, awale igodi 'wa sisiloloku? ");
INSERT INTO yml_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","20","Maninina 'wainega ta yatoyato takesi, 'wa na mieni ta na 'iseni.” Maninina i mieni i 'iseni i velutoliedi i vo, Mani de'e 'waineye, aitoi 'anununa wata 'ana wagava?” ");
INSERT INTO yml_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","I vo, Sisa.” Bega Iesu i vonedi i vo, Vetuma 'ai'edi ava'ai Sisa faifaina, 'wa na 'aniveleneni Sisa 'waineye, we'e ava'ai Yaubada faifaina 'wa na 'aniveleneni Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iesu yana veifufu i nogai, nuadi i voganidi nika i 'iawelovei. ");
INSERT INTO yml_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","'Aiatanina 'waineye, 'ifwaidi Diu totafalolo 'adi wagava Sadusi i maia Iesu 'waineye. Taunidi tovona igodina tomotoga kebu i na yawasa-vaitugana. ");
INSERT INTO yml_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tomotoganidi Iesu i velutolieni i vo, Tove, basenadiotoga Mosese yada veimea i kilumi i vo, 'Ai'edi tamu tomogo i na wafaga siwe kebu natunavoga, 'wabulina taina i na nagidi bega kwakwama i na vetubugidi tatana 'ana wagava wata 'ana wauma faifaidi.’ ");
INSERT INTO yml_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","We'e 'ima basenadi yama 'atamana 'waineye tamu tomogo ma tainavo 'adi 'aila'a 7, tulaiotogina i nagi kebu tamu natunaga i wafa. 'Wabula yadi bwa i nagia. ");
INSERT INTO yml_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Wata i wafa, 'adi vetonu yadi bwa i nagia, i nagoga taidiavo matatabudi 'wabulanidi taiadi i nagi siwe kebu tamu natudiavoga. ");
INSERT INTO yml_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tomotoganidi 7 i wafa'a'ava, mulieta 'eba ve'a'ava 'waineye vavine yawaidi i 'a'ava. ");
INSERT INTO yml_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","'Omi 'wa vonaga 'awaie towafa matatabudi i na yawasa-vaitugana, begaidi 'u na vonema, 'aiatanina 'waineye aitoi mogitana yana vavine, fai tomotoganidi 7 taiadi i nagi?” ");
INSERT INTO yml_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu yadi velutoli i tutuli i vo, 'Omi 'wa vekali mogitana fai Yaubada yana Buki wata yana toketokena 'wa bavuyedi. ");
INSERT INTO yml_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tutuyanina towafa i na yawasa-vaitugana, yadi sauluva bani'odi anelose abame, nagi kebu. ");
INSERT INTO yml_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","'Omi yami vona 'ana nogaya 'wa vo, Towafa kebu i na tovoi-vaitugana,’ siwe a na vonemi. 'Ai'edi Mosese 'ana kilukiluma 'wa da lu'iawawa-dewai 'wa da 'iseni Yaubada i vonavona 'waimie yawasa-vaitugana faifaina i vo, Yau Ebelamo, Aisake wata Iakobo yadi Yaubada.’ De'e bani'odi Yaubada i voneyediga fai tomotoganidi basenadiotoga i wafa siwe 'asiau ma yawaidi taiadi i miamiani. Begaidi ta na 'asetai egavo 'akonadi i wafa 'asiau ma yawaidi i miamiani, kebu tamu aitoi wafawafana Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tutuyanina 'aila'a Iesu yana ve i nogai nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","35","Totafalolo Sadusi yadi velutoli Iesu i tutula-'atumaia bega kebu nuanuadi wata i na veifufu. Tutuyanina totafalolo Falisi i nogai, i va'auta iadi tamu i venua'ivineni, taunina ve'etoboda 'adi tove, i vetunei Iesu 'waineye. Nuanuadi i na velutolieni bonana i na nogai 'ai'edi i na vekali 'adi fata i na 'ive'avini. ");
INSERT INTO yml_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","I velutolieni i vo, Tove, veimeanidi Mosese 'wainega i maiga, ava'ai veimeaga mogitana bwaikina?” ");
INSERT INTO yml_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yana velutoli Iesu i tutuli i vo, 'Auvea yami Yaubada 'wa na nuakalikalieni mogitana nuamiega, 'anu'anunumiega wata yami nuanua 'waidiega. ");
INSERT INTO yml_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","'Asa'aiana veimeanina bwaikaotogina wata kumekumetana. ");
INSERT INTO yml_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","We'e 'ana veluga wata bwaikaotogina, emiavo 'wa na nuakalikaliedi taunimi 'ami nuakalikali bani'odi. ");
INSERT INTO yml_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Veimea matatabuna i mai Mosese 'wainega wata Yaubada yana tolu'ivonavo yadi vona matatabuna, lamudi side veimeanidi 'ailuga.” ");
INSERT INTO yml_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Totafalolo Falisi Iesu i tovififineni i velutoliedi i vo, 'Omi 'wa da nuaniga, Keliso kumanina Yaubada 'ana Venua'ivina tamana aitoi?” Yana velutoli i tutuli i vo, Kini Devida.” ");
INSERT INTO yml_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iesu i vo, Siwe awale 'Anu'anunu Magemagetana Devida i tolivetonoveni bega i ve'awa-Toveimea Keliso 'waineye? Devida i vo, ");
INSERT INTO yml_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'Auvea i vona 'aku Toveimea 'waineye i vo, Veimea a velemuga bega 'u na miabui 'aku 'atagiega, i na nagoga 'amu gaviavo a na leodi bega 'u na veveimeyedi.”’ ");
INSERT INTO yml_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Keliso mogitana Devida 'ana wauma 'wainega i souyeni siwe i vebwaika-'iaweni, begaidi Devida i ve'awa-Toveimea Keliso 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kebu tamu aitoi 'ana fata Iesu yana vona i na tutuli, i ve'wadamo, wata 'awaie kebu i na vevelutolieniga fai i kololoyeni. ");
INSERT INTO yml_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mulieta Iesu i veifufu 'aila'a wata yana tovetutuyamavo 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","3","I vo, Ve'etoboda 'adi tovevo wata totafalolo Falisi veimeanidi i maiaga Mosese 'wainega 'adi tokiavemageta. Fai taunidi Mosese tutulina bonadi matatabuna 'wa na nogaidi wata 'wa na vevematayakayaka, siwe yadi sauluva kebu 'wa na vetutuyamediga fai nani fuedi i tatalabodedi siwe wata i 'i'idewadi. ");
INSERT INTO yml_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tomotoga i lulukakadedi bega yadi ve wata ve'etoboda i 'idewadiga i na vevematayakeyakedi, 'wa da vo venuana vitadi i da veve'ewadi, siwe kebu tamu sai'afo i da 'ivaisedi. ");
INSERT INTO yml_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nani fuedi i 'i'idewadi tomotoga matadie, nuanuadi i na 'ise'isedi 'adi subia faifaina. Tamu veimea i ve'ililibuyeniga side. Yaubada yana Vona 'ifwaidi i kilukilumidi i dododogidi didiwaka 'waidie, mulieta debadie wata nimadie i yogoyogonedi i yabeyabedi. Nuanuadi didiwaka bababadi bega fuedi i na 'ise'isedi. Wata 'adi talauma i lulumanamanawedi velu'ui faifaina nuanuadi tomotoga i na subisubiadi. ");
INSERT INTO yml_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sakali 'waidie nuanuadi i na mimiabui tomotoga 'adi wagava bwaikidi taiadi wata me Diu yada 'eba miava'auta 'waidie i mimiabui to'edakumetavo taiadi. ");
INSERT INTO yml_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yadi nuanua bwaikina 'atamanafouye tomotoga ma yadi ve'ililibu i na vevekaiwa wata i na veve'awa-tove 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kebu i da lubwaineni tomotoga i na awave-tove 'waimie fai ma fuemie Yaubada natunavo wata yami Tove 'aitamogana. ");
INSERT INTO yml_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tamami 'aiseotogina abame i miamia, begaidi kebu tamu aitoi 'ana wagava 'wa na silakai 'waineye 'wa na vonavona 'wa na vo, Tamada.’ ");
INSERT INTO yml_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wata kebu i da lubwaineni tamu aitoi i na awave-'auvea 'waimie fai yami 'Auvea 'aitamogana Keliso, kumanina Yaubada 'ana Venua'ivina. ");
INSERT INTO yml_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aitoi 'ana wagava bwaikina 'waimiega, i lubwaineni ma yana nuaobu i na vetofolova 'waimie. ");
INSERT INTO yml_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aitoi taunina i na awa'ai'aiaga, 'awaie Yaubada i na kiaobuyeni, we'e aitoi taunina tonuaobu 'awaie Yaubada i na kialakai. ");
INSERT INTO yml_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","'Omi ve'etoboda 'adi tovevo wata totafalolo Falisi, nuakalikalimi. 'Omi tovekali. Egavo nuanuadi i na luku Yaubada yana 'Eba Veimea 'waineye, siwe 'omi yadi 'eda 'wa totovibodai. 'Omi kebu nuanuami 'wa na lukuga 'wa baila, we'e egavo nuanuadi i na luku siwe 'wa totovibodedi. ");
INSERT INTO yml_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","'Omi ve'etoboda 'adi tovevo wata totafalolo Falisi, nuakalikalimi. 'Omi tovekali. Vekaliega 'wabu'wabulavo yadi vanuga 'wa eloelodi, we'e 'atamanafouye yami velu'ui 'wa lumanamanawedi 'ami subia faifaina. Yami sauluvanidi sakoidi faifaidi vematavuloga bwaikaotogina 'wa na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","'Omi ve'etoboda 'adi tovevo wata totafalolo Falisi, nuakalikalimi. 'Omi tovekali. Fwayefwayeamo wata eyageamo 'wa nunagoi 'ani'ie 'wa lalauala 'ai'edi tamu tomogo 'wa na veluagai i na vetovetutuyama 'waimie. Yami ve 'wainega yana sakona 'omi yami sakona i na vebwaika-'iaweni. Ma fuemie vita 'wa na veluagai towafa yadi 'eba mia 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","'Omi to'edakumetanimi nuami tabodadi, nuakalikalimi. Fai 'wa veve 'wa vo, 'Ai'edi aitoi nuanuana yana vona'awaufaufa i na kiavetoketokei i na vo, A vona'awaufaufa Yaubada yana Vanuga 'Eba Velu'ui 'wainega,”’ 'wa vo 'ako 'ana fata i na geuya. We'e 'ai'edi i na vo, A vona'awaufaufa Vanuga 'Eba Velu'ui 'ana golida 'wainega,’ 'wa nuani vona'awaufaufanina toketokena, kebu 'ana fata i na geuya. ");
INSERT INTO yml_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","'Omi 'wava'wavami, nuami tabodadi. Ava'ai naniga bwaikina? Yaubada yana Vanuga 'Eba Velu'ui 'alo 'ana golida, vanuganina 'wainega golida yayato'idina Yaubada faifaina. ");
INSERT INTO yml_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wata 'wa vonavonaga 'ai'edi aitoi nuanuana yana vona'awaufaufa i na kiavetoketokei bega i na vona'awaufaufa 'eba velomu 'wainega, vona'awaufaufanina nani-'avo'avovo 'ana fata i na geuya. We'e 'ai'edi i na vona'awaufaufa Yaubada 'ana 'anivelena 'eba velomu tabwanega, yana vona'awaufaufanina toketokena, kebu 'ana fata i na geuya. ");
INSERT INTO yml_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","'Omi nuami tabodadi. Ava'ai naniga bwaikina? Yaubada 'ana 'anivelena 'alo 'eba velomu, kumanina 'wainega 'anivelenanina yayato'idina Yaubada faifaina? ");
INSERT INTO yml_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bega 'ai'edi tamu tomogo i na vona'awaufaufa 'eba velomu 'wainega, 'asa'aiana 'akonadi 'anivelenanina 'eba velomu tabwaneye taiadi yayato'idina Yaubada faifaina. ");
INSERT INTO yml_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wata 'ai'edi tamu tomogo i na vona'awaufaufa Vanuga 'Eba Velu'ui 'wainega, 'akonadi Yaubada taiadi i awavetubamidi fai yana 'eba mia. ");
INSERT INTO yml_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wata bani'odi 'ai'edi tamu tomogo i na vona'awaufaufa abama 'wainega, 'akonadi Yaubada 'ana didiga 'ai'aiwabuna wata taunina bei i miamiaga taiadi i awavetubamidi. ");
INSERT INTO yml_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","'Omi to'edakumetanimi, nuakalikalimi. 'Omi tovekali. Veimea siaidi 'wa veve'ililibuyedi we'e veimea bwaikidi 'wa baibailedi. 'Ai'edi 'ani'ani 10 'waimie, 'aitamogana 'wainega 'wa na 'anivelena-maimaiga Yaubada 'waineye. Wata nani saiotogidi bani'odi matasilisilili 10, 'aitamogana 'wainega 'wa na 'anivelena-maimaiga Yaubada 'waineye. 'Atumaina, bani'odi 'wa na vevesauluvedi, siwe wata veimea bwaikidi 'wa da vematayakeyakedi, bani'odi sauluva tonovidi, 'isanuakalikali wata tutuya fuedi taunimi 'wa da tautauyemi Yaubada 'waineye. Naninidi bwaikidi 'wa da 'i'idewadi wata siaidi taiadi. ");
INSERT INTO yml_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","'Omi to'edakumetanimi, nuami tabodadi. Nani siaidi faifaidi 'wa nuanua, we'e nani bwaikidi 'wa vevenuafanidi, yami sauluva bani'odi tamu tomogo 'ana walu'aie nawagala i na obu i na iwayavuleni, we'e maidoga i na yemuyamo. ");
INSERT INTO yml_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","'Omi to'edakumetanimi, nuakalikalimi. 'Omi tovekali. Tomogomi 'wa 'ivivigavudi we'e inagemi vainago 'ana ve'isakololo wata veumokai, yami sauluva bani'odi vedi wata 'aivoe, dumwedi 'wa tamatamadi we'e inagedi yoke 'anikudana. ");
INSERT INTO yml_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","'Omi Falisi, matami 'uludi. Nagami vedi nagena yoke 'wa na tamai, nika wata tomogona vunavunagina. ");
INSERT INTO yml_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","To'edakumetanimi nuakalikalimi, tovekali. 'Omi bani'odi taumata, tabwana i 'ivivigavuya we'e inagena bokana. ");
INSERT INTO yml_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","'Ami 'isa 'wainega 'wa da vo yami sauluva tonovina we'e inagemi vekali wata sakona i veadagimi. ");
INSERT INTO yml_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","'Omi to'edakumetanimi, nuakalikalimi. 'Omi tovekali. Basenadiotoga tubumiavo Yaubada yana tolu'ivonavo i luvewafadi. We'e 'omi taumata 'atumaidi 'wa 'idewadi matumatu 'waidie tolu'ivonanidi luludi faifaidi wata tomotoga yadi sauluva tonovina i wafaga 'adi 'eba nuave'avina 'wa 'ivivigavudi. ");
INSERT INTO yml_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Wata 'omi 'wa vonavona 'wa vo, 'Ai'edi basenadi tubumavo taiadi 'a da miamiaga, 'ako kebu Yaubada yana tolu'ivonavo 'a da luvewafadi.’ ");
INSERT INTO yml_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","De'e bani'odi 'wa voneyediga, taunimi 'wa lu'ivoneyemi 'omi mogitana to'ainikenidi tubudiavo. ");
INSERT INTO yml_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Vetuma tubumiavo yadi sauluvanina 'wa na ve'a'avai, Yaubada yana tolu'ivonavo matatabuna 'wa na luvewafadi. ");
INSERT INTO yml_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","'Omi tosakona 'adi 'aila'a, 'o'olo bani'odi. Yami sakonanidi faifaidi Yaubada i na veimea 'wa na luku Ovu Dudubalina 'waineye, siwe kebu 'ami fata 'wa na dega. ");
INSERT INTO yml_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Begaidi a na vonemi. Tolu'ivonavo, tonuamageta wata tovevo a na vevetunedi 'waimie, 'ifwaidi 'wa na nikedi i na wafa, 'ifwaidi 'wa na tutufwasedi 'ai lagalagana 'waidie, 'ifwaidi 'wa na toke 'wa na fitalidi yami 'eba miava'auta 'waidie wata 'wa na lusogi-vuvuedi 'atamana 'aitamogana 'aitamogana 'waidiamo. ");
INSERT INTO yml_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Begaidi Yaubada yana tomotoga 'atumaidi i luvewafadiga faifaidi wata taunimi yami sauluvanidi sakoidi faifaidi, 'adi vita matatabuna 'omi 'wa na tovoieni. Basenadiotoga Keni taina Ebeli kebu yana sakonaga i luvewafai. Bei tubumiavo 'ainike i velamuya i maiga Sekalaia 'waineye, kumanina Belekaia natuna, yami 'aila'a i luvewafai 'eba velomu wata Vanuga 'Eba Velu'ui kamwadie. ");
INSERT INTO yml_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A vona mogitana 'waimie, 'adi vematavuloga matatabuna i na mai 'asiau 'ana tomotoga 'waimie.” ");
INSERT INTO yml_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Iesu i taivonavona i vo, Ieu, me Ielusalema, me Ielusalema, Yaubada yana tolu'ivonavo 'wa luluvewafadi wata yana tomata'aulelevo i vetunediga 'waimie, 'wa lukileudi i wafa. Kamukamu natudiavo fafedie i vevedodogidi, wata bani'odi yau, tutuya fuedi igodi a da 'a'avalamaigimi siwe 'wa baibaileku. ");
INSERT INTO yml_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","'Wa ve'wada a na vonemi. Yami 'atamana 'akonadi i velovi. ");
INSERT INTO yml_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kebu wata 'wa na 'ise'isekuga i na nagoga mulieta 'wa na vo, Taunina 'Auvea 'ana wagavayega i mimai, Yaubada i da vevesauluva 'atumaina 'waineye,’ nika bei wata 'wa na 'iseku.” ");
INSERT INTO yml_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu i vona'a'ava Vanuga 'Eba Velu'ui 'wainega i tauya, nika yana tovetutuyamavo nani 'ifwaidi i 'isediga Vanuga 'Eba Velu'ui 'waineye i veni. ");
INSERT INTO yml_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iesu i vonedi i vo, Vanuganina 'wa 'ise'iseniga mogitana 'ana 'isa 'atumaina, siwe 'awaie 'ami gaviavo i na maia matatabuna i na geuya wata kileunidi bega i bibinaga i na tutuwealidi, matatabuna i na tubakabakaledi.” ");
INSERT INTO yml_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mulieta Iesu i nago i laka 'Oya Olive tabwaneye i miabui. Yana tovetutuyamavo i maia 'aise'avadie i velutolieni i vo, Nuanuama 'a na 'asetai no'o Vanuga 'Eba Velu'ui 'ana geu faifaina 'u vonaga, ma'avia, wata ava'ai tugusaga i na vema bega 'a na 'asetai yamu vila-vaitugana wata fwayafwaya 'ana 'eba ve'a'ava 'waineye?” ");
INSERT INTO yml_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Iesu i vonedi i vo, Taunimi 'wa na 'isave'avinimi i na nunago tamu aitoi i na vekaliemi, fai tomotoga fuedi i na mai 'aku wagavayega igodi i na vo, Yau 'asa'aiana Keliso, Yaubada 'ana Venua'ivina.’ Yadi vonayega fuedi i na vekaliedi. ");
INSERT INTO yml_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Lilivamie vetalaga butu'aidi 'wa na noganogaidiga wata 'ani'ieyega vala'avadi, siwe a vovona-vagasemi, kebu nuafoumi i na veviga. Naninidi mogitana i na souyedi we'e fwayafwaya 'ana 'eba ve'a'ava bola. ");
INSERT INTO yml_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","'Eba veimea bwaikidi wata 'eba veimea bwaikidi 'ifwaidi taiadi i na vevetalaga, we'e 'awalawa wata 'awalawa 'ifwaidi taiadi i na vevetalaga. 'Awalawa fuedi 'waidie yoyoyo i na yueyue wata i na loka. ");
INSERT INTO yml_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tutuyanina vavine i na vebutudiga veviga bwaikina i na vebaedi, wata bani'odi naninidi a veifufuyediga tutuyanina i na souyediga veviga wata 'we'wela i na velamu. ");
INSERT INTO yml_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Fai 'omi 'wa vetumaganeku tomotoga 'aila'a tulina tulina i na vedumwe'ai'aiemi, i na 'ive'avinimi i na 'anivelenemi vita 'wa na veveluagadi, mulieta i na luvewafami. ");
INSERT INTO yml_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tomotoga fuedi yadi vetumagana i na mwea i na baileku, ediavo i na vedumwe'ai'aiedi wata i na 'etogiluvedi bega vita i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wata tolu'ivona-vekavekali fuedi i na souyedi tomotoga fuedi i na vekaliedi. ");
INSERT INTO yml_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sakona i na vebwaika-'afo'afo, ma'itufa tomotoga fuedi yadi nuakalikali i na vesiai. ");
INSERT INTO yml_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Siwe egavo i na tokemaigedi i na nagoga tutuya 'eba ve'a'ava 'waineye 'ita'ita'i i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yaku tomotoga Vala 'Atumaina i na lulu'age-vuvueni 'aila'a tulina tulina 'waidie, i na lu'ivona 'waidie Yaubada nuanuana tomotoga fuedi i na luku yana 'Aila'a nageneye bega i na veveimeyedi. De'e Valanina nagami tomotoga matatabudi i na 'aseta, mulieta fwayafwaya 'ana 'eba ve'a'ava.” ");
INSERT INTO yml_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","(Buki tokiluma bonaku, Iesu yana vona de'e 'wa na lu'iawawaiga 'wa na venua'ivineni nika 'wa na 'asetai.) Wata Iesu i vonedi i vo, 'Awaie tamu nani 'wa na 'iseni maigikolokololona Vanuga 'Eba Velu'ui nageneye i na tovotovoi. Naninina faifaina basenadiotoga Yaubada yana tolu'ivona 'ana wagava Daniela i vona-samula, vonanina Yaubada yana Buki nageneye i 'eno'eno. ");
INSERT INTO yml_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tutuyanina tugusanina i na souyeni, egavo i na miamiani 'awalawa Iudia nageneye, i lubwainedi i na dega i na nagoi 'oyeye. ");
INSERT INTO yml_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","18","'Ai'edi aitoi masi'edeye i na miamia, kebu 'ana fata i na luku vanuge yana kukua i na 'ewadi i na dega-matayo'o, wata aitoi i nagoga bakule, kebu 'ana fata i na vilai i na mai vanuge 'ana talauma 'ana 'ewa faifaina. ");
INSERT INTO yml_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Toveinainage wata vauvau nuakalikalidi, fai kebu 'adi fata i na dega-matayo'o veviga bwaikina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yaubada 'waineye 'wa na vevelu'ui bega naninina kebu i na souyeni toalu'uye wata 'Aiata Veawai 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yaubada fwayafwaya i 'idewavauyeni i maiga 'asiau veviga i sousouyedi siwe sai'afo, we'e tutuyanina 'waineye veviga bwaikaotogina i na souyeni, i na 'a'avana kebu wata bani'odi i na sousouyeni. ");
INSERT INTO yml_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Vitanina de'e 'ana tutuya Yaubada i na 'ive'ale'usai, 'ai'edi kebu, tomotoga matatabuna i na wafa'a'ava. Tomotoganidi Yaubada i venua'ivinediga faifaidi i na 'ive'ale'usai bega yadi mia i na ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Wata Iesu i vonedi i vo, Tutuyanina 'waineye 'ai'edi aitoi i na vonemi i na vo, Sino Keliso i le'wa,’ 'alo i na vo, Side taunina,’ kebu bonana 'wa na nogai 'wa na vo 'ako mogitana, fai keliso-vekavekali wata tolu'ivona-vekavekali i na sousouyedi. I na souyediga 'eba nuavogana wata 'eba nua'ewa i na 'i'idewadi, igodi nuanuadi tomotoganidi Yaubada i venua'ivinediga vekaliega nuadi i na 'ewadi. ");
INSERT INTO yml_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Naninidi 'awaie i na souyediga 'akonadi 'wa nogai, faifaidi a vona-vagasemi. ");
INSERT INTO yml_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Begaidi 'ai'edi aitoi i na vo, Keliso sino wala'aie,’ kebu bei 'wa na nagoiga, 'ai'edi i na vo, Keliso side vanuga nageneye,’ bonana kebu 'wa na nogaiga. ");
INSERT INTO yml_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kebu bonadi 'wa na nogaiga fai yau a vetomotogaotoga yaku souyagi 'wa da vo tamuyoana i na kianamali abama matatabuna i na magetai, tomotoga matatabumi 'wa na 'isa'a'avaku. ");
INSERT INTO yml_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","'Ai'edi manusibosibo 'wa na 'isedi i na vava'auta bei mogitana tamu nani wafana i 'eno'eno, wata bani'odi 'eba 'isanidi 'waidiega 'wa na 'asetai tutuya 'ana 'eba ve'a'ava i velilivana. ");
INSERT INTO yml_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tutuyanina vitanina i na 'a'ava nika inala i na lu'waugi, weta'i yana mageta i na 'a'ava, 'ubwana i na avuta abamayega wata nani matatabuna toketokedi abame i na yue. ");
INSERT INTO yml_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tutuyanina 'waineye tugusanidi yau a vetomotogaotoga faifaiku i na souyedi abame, we'e fwayefwayeye 'aila'a tulina tulina ma yadi venuafouviga i na 'we'wela, fai i na 'iseku yau a vetomotogaotoga abamayega a na mimai waowa 'wainega, ma yaku toketokena wata ma magetaku mataududulina. ");
INSERT INTO yml_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Evulega butu'aina bwaikina i na yuvei, mulieta yaku anelose a na vetunedi yaku tomotoga vevenua'ivinidi i na va'augidi i na miedi. Tomotoganidi i na miediga fwayafwaya matatabuna 'wainega, inala yana 'eba lakayega wata yana 'eba inivayega, bolimanayega wata yavalatayega. ");
INSERT INTO yml_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Modawa 'wa na nuani. Tutuyanina i na idiaga ta 'asetai 'aisaya i veyafa. ");
INSERT INTO yml_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wata bani'odi 'ai'edi tugusanidi a voneyediga 'wa na 'isedi, 'wa na 'asetai yaku souyagi 'akonadi i le'wale'wa. ");
INSERT INTO yml_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A vona mogitana 'waimie, tutuya de'e 'ana tomotoga bola i na miamiani naninidi matatabuna i na souyedi. ");
INSERT INTO yml_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Abama wata fwayafwaya 'awaie i na 'a'ava, we'e yaku vona kebu tamu sai'afo i na 'a'ava, i na 'eno-vagata.” ");
INSERT INTO yml_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Wata Iesu i vonedi i vo, Yaku mai-vaitugana kebu tamu aitoi i da 'asetaiga, ava'ai 'aiataga 'alo ava'ai 'awasasaga 'waineye a na vilaku. Anelose abame kebu i da 'asetaiga, 'alo yau Yaubada Natuna, Tamaku 'aiseotogina i 'asetai. ");
INSERT INTO yml_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yaku mai-vaitugana 'waineye tomotoga yadi sauluva bani'odi Noa yana tutuye tomotoganidi. ");
INSERT INTO yml_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Basenadiotoga Noa yana tutuye tomotoga i nunuatavutavuna, 'ani'ava, yemu'ava, nagi'ava, ava'ai i sousouyediga tomotoganidi kebu i da 'asetaiga, nika Noa i dodoga yana wakeye mwai bwaikina i ula tomotoganidi matatabudi i ve'alawafawafa. Yau a vetomotogaotoga yaku mai-vaitugana wata bani'odi. ");
INSERT INTO yml_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tutuyanina 'waineye tomotoga 'adi 'ailuga i na folofolova bakule, tamu i na vagavaia i na naweni, we'e tamu i na baileni. ");
INSERT INTO yml_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vevine 'adi 'ailuga 'ani'ani i na 'i'idewadewa, tamu i na vagavaidi, we'e tamu i na bailedi. ");
INSERT INTO yml_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Begaidi 'wa na miamia 'wa na 'isa'isa fai yau 'ami Toveimea yaku souyagi 'ana tutuya kebu 'wa da 'asetaiga. ");
INSERT INTO yml_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'Wa na nuani, 'ai'edi tamu tomogo tovainago yana mai 'ana tutuya i da 'asetaiga, i da 'isa'isa bega tovainagonina kebu 'ana fata i na luku yana vanuge. ");
INSERT INTO yml_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","'Omi wata bani'odi 'wa na 'isa'isa fai 'aiatanina 'waineye 'wa na vo, Kebu i na maiga,’ yau a vetomotogaotoga bei a na le'wa. ");
INSERT INTO yml_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tofolova 'atumaina kumanina ma yana nuamageta wata ma 'ana vetumagana yana sauluva side bani'odi. 'Ana toveimea i voneni yana tofolovavo 'ifwaidi i na 'i'isave'avinidi wata 'adi'adi i na veleveledi 'aiata 'aitamogana 'aitamogana, mulieta i tauya. ");
INSERT INTO yml_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tutuyanina 'ana toveimea i na vilai i na mai, 'ai'edi folovanidi matatabuna i na 'idewa'a'avadiga, 'eba sosoana 'waineye fai tutula i na 'ewai. ");
INSERT INTO yml_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A vona mogitana 'waimie, 'ana toveimea i na voneni yana vanuga wata yana kukua matatabuna 'adi to'isave'avina. ");
INSERT INTO yml_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","We'e 'ai'edi tofolovanina yana nuanua i na vo, 'Aku toveimea bola, kebu i na mai-matayo'oga,’ bega enavo tofolova i na nikenikedi we'e mali tomotoga taiadi i na 'ani'ani wata ufa toketokena i na yemuyemu bega nuadi i na lulugaugaudi, tamu tutuya tofolovanina kebu i da 'asetaiga 'ana toveimea i na mai yawaina i na velovogi. ");
INSERT INTO yml_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yana sauluva sakoina faifaina i na toke i na nikei mulieta i na yatoi tovekali taiadi, bei veviga bwaikina i na veveluagai i na 'we'we'wela wata maigidi i na yuyuyudi.” ");
INSERT INTO yml_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Wata Iesu i vonedi i vo, 'Aiatanina a na vilaku a na mai, tomotoga yadi luku Yaubada yana 'Aila'a 'waineye side bani'odi. Tamu vavine i na nagi bega enavo ne'e'ela 'adi 10 ma yadi mageta i nagoi tomogo 'ana lukamata faifaina. ");
INSERT INTO yml_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","'Adi 5 ma yadi nuamageta we'e 'adi 5 nuadi 'anigaugaudi. ");
INSERT INTO yml_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","Nuadi 'anigaugaudi yadi mageta ma ufadi we'e i na 'a'avaga faifaina kebu tamu i da 'ewaiga, we'e 'adi 5 ma yadi nuamageta yadi mageta i iwagidi wata yadi ufa ma 'adi 'imoso'i i 'ewadi. ");
INSERT INTO yml_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tonaginina i 'ivogavogana bega vevinenidi 'adi 10 matadi i duduna i 'eno-mataiva. ");
INSERT INTO yml_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","'Akonadi 'eno-waube'u nika vegole i nogai i vo, Side tonagi i mimai. 'Wa maia, 'wa na yogo'ede'edeni.’ ");
INSERT INTO yml_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","8","Vevinenidi 'adi 10 i 'isa yadi mageta i kialakaidi nika vevine nuadi 'anigaugaudi i vona ediavo 'waidie i vo, Yama mageta i 'weu'weu, yami ufayega 'wa da iwagema.’ ");
INSERT INTO yml_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Vevine ma yadi nuamageta ediavo yadi vona i tutuli i vo, Kebu, ufa de'e 'omi wata 'ima kebu 'ada fataga. 'Wa nagoi 'eba kimwane 'waineye bei yami ufa 'wa na 'ewadi.’ ");
INSERT INTO yml_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ne'e'elanidi nuadi 'anigaugaudi i tauya i nunagoi kimwane faifaina, nika tonagi i le'wa. Ne'e'elanidi 'adi 5 i 'idewadewa i lulukamataga taiadi i luku nagi 'ana 'ani 'waineye, 'awa i sibodai. ");
INSERT INTO yml_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","I saiboda mulieta vevinenidi kimwane faifaina i nagoiga i le'wai, i vegole i vo, 'Auvea, 'Auvea, nuanuama 'a da lukuwa.’ ");
INSERT INTO yml_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tonaginina i vo, 'Omi aigodi kebu a da 'asetamiga.’” ");
INSERT INTO yml_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Iesu yana vonanina 'ana 'eba ve'a'ava 'waineye i vo, Begaidi 'omi 'wa na 'isa'isa fai yaku mai-vaitugana 'ana 'aiata wata 'ana 'awasasa kebu 'wa da 'asetaiga.” ");
INSERT INTO yml_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Wata Iesu i vona-awatabai yana mai faifaina i vo, Tamu tomogo i tautauya 'ani'ie yana tofolovavo i goleva'augidi, yana kukua matatabuna i veledi i na 'isave'avinidi. ");
INSERT INTO yml_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tamu i veleni kileu golida 5,000, tamu kileu golida 2,000, we'e tamu kileu golida 1,000, nika i tauya. 'Aitamogana 'aitamogana i velediga yadi 'aseta wata yadi toketokena 'ana 'etowava 'wainega. ");
INSERT INTO yml_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tofolovanina kileu golida 5,000 i 'ewaiga i nago kebu i da mia-maimaiga maninina i vefoloveni, wata 'wainega 'imoso'i i veluagai kileu golida 5,000. ");
INSERT INTO yml_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wata bani'odi tofolovanina kileu golida 2,000 i veluagai i vefoloveni wata 2,000 i 'ewai. ");
INSERT INTO yml_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","We'e tofolovanina 'adi vetonu, kumanina kileu golida 1,000 i 'ewaiga, i nago fwayafwaya i alai 'ana toveimea yana mani i tavuni. ");
INSERT INTO yml_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Toveimeanina i nagoga tutuya manamanawena i mia, mulieta i vilai i mai yana tofolovavo i vonedi i maia nuanuana i na 'asetai yana mani i 'imoso'iedi 'alo kebu. ");
INSERT INTO yml_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tofolovanina kileu golida 5,000 i 'ewaiga i luku maninina ma 'ana 'imoso'i kileu golida 5,000 i veleni i vo, 'Auvea, basenadi kileu golida 5,000 'u velekuga a vefoloveni, side wata 5,000 a veluagai.’ ");
INSERT INTO yml_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'Ana toveimea i voneni i vo, Mogitana 'omu to'idumwebika, yamu folova 'atumaiotogina. Mani sai'afo siaina 'waineye 'u 'idumwebika, bega a na yatomu 'u na veto'isave'avina mani bwaikina 'waineye. 'Waikuye taiadi ta na miamia ta na sososoana.’ ");
INSERT INTO yml_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mulieta tofolovanina 2,000 i 'ewaiga i luku 'ana toveimea 'waineye i vo, 'Auvea, basenadi kileu golida 2,000 'u velekuga a vefoloveni, side wata 2,000 a veluagai.’ ");
INSERT INTO yml_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","'Ana toveimea i voneni i vo, Mogitana 'omu to'idumwebika, yamu folova 'atumaiotogina. Mani sai'afo siaina 'waineye 'u 'idumwebika, bega a na yatomu 'u na veto'isave'avina mani bwaikina 'waineye. 'Waikuye taiadi ta na miamia ta na sososoana.’ ");
INSERT INTO yml_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mulieta tofolovanina kileu golida 1,000 i 'ewaiga i luku 'ana toveimea 'waineye i vo, 'Auvea a 'asetamu, yamu veimea toketokedi. Kebu 'u da bakubakulaga siwe 'u 'a'aialamo, tofolova i folofolova we'e 'omu tutula'ava 'u 'ewa'ewamo. ");
INSERT INTO yml_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yau a kololo 'ai'edi yamu mani a da vegivai bega a nago a giveni fwayafwaya nageneye. Side yamu maninina, 'asa'aiana 'u 'ewai.’ ");
INSERT INTO yml_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","'Ana toveimea i yagaia i vo, 'Omu tofolova sakoimu, dumwemu 'aina. 'Omu yamu nuanua igodina yau kebu a da bakubakulaga siwe a 'a'aialamo wata tofolova i folofolova faifaiku, we'e yau tutula'ava a 'ewa'ewamo. ");
INSERT INTO yml_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","I lubwaineni yaku mani 'u da yatoi mani 'ana bubuaka 'waineye. A da vilaku a da mai yaku maninina ma 'ana 'imoso'i a da 'ewai.’ ");
INSERT INTO yml_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bega yana tofolovavo 'ifwaidi i vonedi i vo, Kileu golida 1,000 'wa eloi tofolova sakoina, kumanina ma yana kileu golida 10,000 'wa na veleni.’ ");
INSERT INTO yml_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","'Wa na eloiga fai 'ai'edi aitoi 'ana veuveuta 'wainega i na folova-'atumai wata 'ana 'imoso'i i na veluagai, we'e aitoi 'ana veuveuta kebu i na vefolova-'atumaieniga veuveutanina siaina i na elo'a'avai. ");
INSERT INTO yml_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","De'e tofolovanina dumwena 'aina ava'ai 'ana 'atumaina? 'Wa na naweni 'wa na taweni i na obu dudubale bei i na 'we'we'wela wata maigina i na yuyuyuya.” ");
INSERT INTO yml_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","32","Wata Iesu i vonedi i vo, 'Awaie yau a vetomotogaotoga ma yaku mageta mataududulina a na mai abamayega anelose matatabudi taiadi. Ma yaku veimea a na miabui 'aku didiga magemagetana wata 'ai'aiwabuna 'waineye, mulieta tomotoga 'adi 'aila'a tulina tulina fwayafwaya matatabuna 'wainega i na maia i na vonayavuga 'waikuye. I na 'a'ava a na 'ivisidi bani'odi 'aisaya 'adi to'isave'avina sifi wata goti i 'idi'ididi. ");
INSERT INTO yml_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yaku tomotoga a na yatodi 'aku 'atagiega we'e 'ifwaidi tomotoga 'aku wamayega. ");
INSERT INTO yml_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mulieta yau yadi Kini tomotoganidi 'aku 'atagiega a na vonedi a na vo, 'Omi 'akonadi Tamaku i vesauluva 'atumaina 'waimie, 'wa maia 'wa na luku yana 'Eba Veimea 'waineye. Bola fwayafwaya kebu i da 'idewaiga, Yaubada 'Eba Veimeanina i 'idewa-vagaseni faifaimi. ");
INSERT INTO yml_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","'Wa na lukuga fai basenadi a lase 'wa ve'aniku, 'anigoku i lala ufa 'wa veleku, tuliku siwe 'wa goleku a laka yami vanuge. ");
INSERT INTO yml_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kebu 'aku talaumaga 'wa ve'weseniku, a viga 'wa lukebeku, a luku vanuga yogona nageneye 'wa fogefogeku.’ ");
INSERT INTO yml_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yaku tomotoganidi yadi sauluva tonovidi i na velutolieku i na vo, 'Auvea, ma'avia 'a 'isemu 'u lase 'a ve'animu, 'alo 'anigomu i lala ufa 'a velemu? ");
INSERT INTO yml_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ava'ai tutuyaga 'a 'isemu kebu 'a da 'isa'inanamuga 'a golemu 'u laka yama vanuge, 'alo kebu 'amu talaumaga 'a ve'wesenimu? ");
INSERT INTO yml_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Wata ma'avia 'u viga 'alo 'u luku vanuga yogona nageneye 'a fogefogemu?’ ");
INSERT INTO yml_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yau yadi Kini yadi velutoli a na tutuli a na vo, A vona mogitana 'waimie, tutuyanina tamu iaku tomogo-'avo'avovo 'wa 'ivaiseniga siwe 'asa'aiana yau 'wa 'ivaiseku.’ ");
INSERT INTO yml_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","We'e tomotoganidi 'aku wamayega a na vonedi a na vo, 'Omi 'akonadi Yaubada i veimea vematavuloga 'wa na veluagai, 'wa na nagoi 'ai-'ala'alata kebu yana 'weuga 'waineye, 'ainina Yaubada i 'idewa-vagaseni Seitani enavo yaiaina taiadi faifaidi. ");
INSERT INTO yml_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","43","'Wa na nagoiga fai basenadi a lase siwe kebu 'wa da ve'anikuga, 'anigoku i lala ufa 'wa bodaku, yau tuliku 'wa 'iseku siwe kebu 'wa da goleku a da wai yami vanuge. Kebu 'aku talaumaga 'asa'aiana 'wa 'isekumo, a viga wata vanuga yogona nageneye a luku siwe kebu 'wa da 'isave'avinikuga.’ ");
INSERT INTO yml_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tovedumwe'ai'ainidi i na velutolieku i na vo, 'Auvea, ma'avia 'a 'isemu, 'u lase, 'anigomu i lala wata kebu 'amu talaumaga 'a bodamu. We'e 'omu tomogo tulimu, 'u viga, 'alo vanuga yogona 'waineye 'u luku 'a 'idumwe'aiemu kebu 'a da 'ivaisemuga?’ ");
INSERT INTO yml_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yau yadi Kini yadi velutoli a na tutuli a na vo, A vona mogitana 'waimie, tutuyanina tamu iaku tomogo-'avo'avovo 'wa bodaiga 'alo kebu 'wa da 'ivaiseniga, siwe 'asa'aiana yau 'wa bodaku wata kebu 'wa da 'ivaisekuga.’ ");
INSERT INTO yml_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mulieta a na veimea tovedumwe'ai'ainidi i na nago vematavuloga kebu yana 'a'avaga 'waineye, we'e tomotoganidi yadi sauluva tonovidi mia 'atumaina wata miamia-vagaina i na veluagai.” ");
INSERT INTO yml_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Iesu yana mai-vaitugana faifaina i ve i 'a'avana mulieta yana tovetutuyamavo i vonedi i vo, 'Akonadi 'wa 'asetai 'aiata 'ailuga i na 'a'avana Sakali Uvi'agalatagona i na velamu. Tutuyanina 'waineye yau a vetomotogaotoga i na 'aniveleneku i na tutufwaseku 'ai lagalagana 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tutuyanina 'waineye tovelomu yadi to'edakumetavo wata me Diu to'edakumetavo 'au'auveadi i va'auta, tovelomu bwaikina 'ana wagava Kaiafa yana vanuga 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bei i veifufu bani'odi i na munega givagivayega Iesu i na 'ive'avini i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Siwe wata i vo, Kebu sakali 'waineye ta na 'ive'aviniga, i na nunago tomotoga fuedi i na daba fai nuanuadi Iesu.” ");
INSERT INTO yml_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu bola i miamia 'atamana Bedani, Saimoni yana vanuge, kumanina basenadi viga sakoina i 'ewai tomogona i velufo'afo'ana. ");
INSERT INTO yml_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","I 'ani'ani nika tamu vavine bunama i mieni, magaina 'atumaina wata 'ana tutula bwaikina Iesu nava'auna i iwagi. Bei i koiaga kileu i 'eavi 'ana 'isa 'atumaiotogina, 'ana wagava alibasita. ");
INSERT INTO yml_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iesu yana tovetutuyamavo i 'iseni ma yadi luvulewa i manini i vo, Awale bunama i ve'amubwadodoyeni? ");
INSERT INTO yml_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bunamanina i lubwaineni i da vekimwaneyeni mani bwaikina i da veluagai 'wainega tovewekowekoma i da 'ivaisedi.” ");
INSERT INTO yml_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu yadi nuanua i 'asetai bega i vonedi i vo, Vavine kebu 'wa na 'ivebunumayagi. Naninina i 'idewaiga 'waikuye 'atumaiotogina i lubwaineni. ");
INSERT INTO yml_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wekowekoma tutuya fuedi taiadi 'wa na miamia we'e yau kebu. ");
INSERT INTO yml_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","I iwagikuga tomogoku i 'idewa-vagaseni 'aku ve'ufa faifaina, me Diu yada sauluva bani'odi. ");
INSERT INTO yml_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A vona mogitana 'waimie, bola Valaku 'Atumaina i na lulu'ageyeni fwayafwaya matatabuna 'waineye, vavinenina yana folova 'waikuye wata i na lulu'ivoneyeni 'ana 'eba nuave'avina.” ");
INSERT INTO yml_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Mulieta Iesu yana tovetutuyamavo 12 'waidiega, tamu iadi 'ana wagava Iudasa Isakaliota i nago tovelomu yadi to'edakumetavo i velutoliedi i vo, 'Ai'edi Iesu a na 'aniveleneniga 'waimie ava'ai 'wa na veleku?” Yana vona i noganogaiga kileu siliba matatabuna 30 i veleni. ");
INSERT INTO yml_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tutuyanina 'wainega i nagoga Iudasa i velamu i lalauala 'eda'eda 'atumaina Iesu 'ana 'etogiluva faifaina. ");
INSERT INTO yml_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Beledi Yalayalana Sakalina 'ana 'aiata 'eba velamu 'waineye, Iesu yana tovetutuyamavo i maia i velutolieni i vo, Ava'aibe bei nuanuamu Uvi'agalatagona 'ana 'ani faifaina 'a na 'idewadewa?” ");
INSERT INTO yml_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iesu yadi velutoli i tutuli i vo, 'Wa na nagoi Ielusalema, tomogonina 'akonadi 'wa 'asetai, 'wa na voneni 'wa na vo, Yama Tove i vonaga yana tutuya 'akonadi i le'wa, nuanuana 'ima yana tovetutuyamavo taiadi Uvi'agalatagona faifaina 'a na 'ani yamu vanuge.’” ");
INSERT INTO yml_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","I vona'a'ava yana tovetutuyamavo i tauya i nagoi, ava'ai Iesu i vonediga Uvi'agalatagona 'ana sakali i 'idewadewa. ");
INSERT INTO yml_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","'Akonadi i lavia, bega Iesu ma yana tovetutuyamavo 12 i maia i miabui i na 'ani. ");
INSERT INTO yml_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","I 'ani'ani Iesu i vonedi i vo, A vona mogitana 'waimie, 'waimiega tamu i na 'etogiluveku.” ");
INSERT INTO yml_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tovetutuyamavo yana vona i nogai nuafoudi i veviga bega 'aitamogana 'aitamogana i vevelutolieni i vo, 'Auvea, voke yau, siwe a nuani kebu.” ");
INSERT INTO yml_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iesu i vo, 'Ama 'ailugana 'ama beledi 'a lulu'utuva 'aivoeye, kumanina. ");
INSERT INTO yml_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Basenadiotoga i kilumi Yaubada yana Buki nageneye yau a vetomotogaotoga i na nikeku a na wafa, i vonaga mogitana, we'e 'aku to'etogiluva nuakalikalina. 'Ako kebu i da tubugaga 'atumaina, siwe fai i tubuga yana sakonanina faifaina veviga bwaikina i na veluagai.” ");
INSERT INTO yml_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iudasa taunina to'etogiluva i vona i vo, Tove voke yau, siwe a nuani kebu.” Iesu i vo, 'U vonaga, 'asa'aiana 'omu.” ");
INSERT INTO yml_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bola i 'ani'ani, Iesu 'ani'ani i 'ewai, i vekaiwa Yaubada 'waineye mulieta i 'ivivia i 'a'avana yana tovetutuyamavo i veledi. I vonedi i vo, 'Ani'ani de'e 'asa'aiana tomogoku, 'wa na 'ewai 'wa na 'ania.” ");
INSERT INTO yml_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Mulieta oine ma vedina i 'ewai, i vekaiwa Yaubada 'waineye i 'a'avana i veledi i vo, Matatabumi 'wa na yemu. Oine de'e 'asa'aiana dayagiku, i na ilolo fuemi faifaimi bega Yaubada yami sakona i na nuatavunidi. Yaku wafanina 'wainega Yaubada yana Veakutagona 'Ivauna basenadi faifaina i vona'awaufaufa i na velamu 'waimie. ");
INSERT INTO yml_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A vona mogitana 'waimie, oine de'e kebu wata a na yemuga, i na nagoga 'ana tugusa oine 'ivauna taiadi ta na yemu Tamaku yana 'Eba Veimea nageneye.” ");
INSERT INTO yml_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iesu i vona'a'ava tamu lei-subisubia i silakai i lei mulieta i nago i laka 'Oya Olive. ");
INSERT INTO yml_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iesu i vona yana tovetutuyamavo 'waidie i vo, 'Ako lovananina 'waineye matatabumi 'wa na degaloveku fai basenadiotoga Yaubada yana Buki nageneye i kilumi faifaimi i vo, Yaubada sifi 'adi To'isave'avina i na nikei i na wafa, nika sifi i na ve'aladegadega.’ ");
INSERT INTO yml_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Vonanina i kilumiga i na nikeku faifaina mogitana, siwe tutuyanina Yaubada i na sivetovoiku a na kumeta a na nago Galili bei ta na veluaga.” ");
INSERT INTO yml_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Fita i vona-matayo'o i vo, 'Ai'edi tomotoga matatabudi i na degalovemu, we'e yau kebu tamu sai'afo a na degalovemuga.” ");
INSERT INTO yml_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu Fita i voneni i vo, A vona mogitana 'waimuye 'ako lovane bola kamukamu kebu i na kwagega, nagami tutuya 'aitonu 'u na bavusebeku.” ");
INSERT INTO yml_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Fita i vo, 'Ai'edi taiadi ta na wafaga i lubwaineku, siwe kebu a na vo, Yau Iesu kebu a da 'asetaiga.’” Ava'ai Fita i voneyeniga, enavo matatabudi wata bani'odi i vona. ");
INSERT INTO yml_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mulieta Iesu ma yana tovetutuyamavo i nagoi tamu wala'ai 'atumaina 'waineye 'ana wagava Gedesemani, bei yana tovetutuyamavo i vonedi i vo, Side bei 'wa na miabui 'wa na miamiani, yau sino bei a na nago a na velu'ui.” ");
INSERT INTO yml_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","38","Tomotoga 'adi 'aitonu i vonedi taiadi i nagoi, Fita wata Sebedi natunavo 'adi 'ailuga Iemesa wata Ioni. Venuafouviga wata nuavita bwaikina Iesu i vebaeni i vonedi i vo, Yaku nuavita bwaikaotogina 'wa da vo nuafouku i da 'e'etokadia wata 'wainega sai'afoga a na wafa. Side bei 'wa na miamia kebu 'wa na 'enoga ta na 'isa'isa.” ");
INSERT INTO yml_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I vaganago i lumata'afufu i velu'ui i vo, Tamaku, 'ai'edi yamu nuanua i na lubwaineniga vita de'e wata wafa 'u da 'ewadi 'waikuyega. Siwe 'asa'aiana, de'e kebu yau yaku nuanuaga, 'omu yamu nuanua bega a na vematayakeyakenimo.” ");
INSERT INTO yml_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","I velu'ui i 'a'avana i vilai i nago yana tovetutuyamavo i 'isedi i 'eno'enovi. I luvagonidi Fita i voneni i vo, Awale 'wa 'eno'enovi, ta da 'isa'isa 'awasasa 'aitamogana. ");
INSERT INTO yml_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","'Wa na 'isa'isa wata 'wa na vevelu'ui bega tutuyanina Seitani i na vetalaimimilimi kebu 'wa na sakona. Nuanuami 'wa na 'ivaiseku siwe yami toketokena i mwea.” ");
INSERT INTO yml_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wata 'ana veluga Iesu i vaganago i velu'ui i vo, Tamaku, 'ai'edi kebu 'ana fata 'aku vita wata wafa 'u na 'ewadiga, 'asa'aiana a tauyeku 'waidie, yamu nuanua a na 'idewai.” ");
INSERT INTO yml_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wata i vilai i mai yana tovetutuyamavo i 'isedi i 'eno'enovi fai matadi i duduna-'afo'afo. ");
INSERT INTO yml_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wata i 'iawedi i vilai i nago 'ana vetonu i velu'ui, yana velu'uinidi i luvaituganidi. ");
INSERT INTO yml_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Mulieta i vilai i mai yana tovetutuyamavo i vonedi i vo, 'Omi 'alo 'wa 'eno'enovi? Sino 'wa 'isanaweni, 'aku to'etogiluva i le'wa. Yau a vetomotogaotoga yaku tutuya 'akonadi i le'wa bega i na 'aniveleneku tosakona yadi toketokena 'waineye. 'Wa tovoi ta na nagoi 'waidie.” ");
INSERT INTO yml_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bola Iesu i veveifufu nika Iudasa i mai, kumanina tamu Iesu yana tovetutuyamavo 12 'waidiega. Tomotoga fuedi taiadi i maia ma yadi kefata wata fulumai, tovelomu yadi to'edakumetavo wata me Diu to'edakumetavo 'au'auveadi 'waidiega i vetunedi. ");
INSERT INTO yml_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","To'etogiluvanina yana tugusa 'akonadi 'aila'a i vona-vagasedi i vo, Tomogonina a na 'avalamaigiga, kumanina nuanuami, 'wa na 'ive'avini.” ");
INSERT INTO yml_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tutuyanina i le'wai, Iudasa tonovina i nago Iesu i 'avalamaigina i voneni i vo, Tove, kaiwa.” ");
INSERT INTO yml_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu i voneni i vo, Iaku, ava'ai nuanuamu 'u na 'idewa-matayo'oi.” Nika Iudasa enavo i maia Iesu i 'ive'avini. ");
INSERT INTO yml_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tamu tomogo Iesu taiadi i 'iseni, yana kefata i yo'ei tovelomu bwaikina yana tofolova igodi i da nikei, taniga'avana i tutuomuya. ");
INSERT INTO yml_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iesu i voneni i vo, 'U baileni, yamu kefata 'ana 'eba 'aidodoga 'waineye 'u dodogi, egavo kefatayega i na vetalagaga wata mali tomotoga kefatayega i na luvewafadi. ");
INSERT INTO yml_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","'Wa da nuani, 'ai'edi nuanuaku 'aivaita a da velu'ui Tamaku 'waineye, anelose 'aila'a 12 'alo 'aivia bani'odi i da vetunedi i da 'ita'ita'ieku. ");
INSERT INTO yml_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Basenadi i kilumi Yaubada yana Buki nageneye i lubwaineku vitanidi a na veluagai, 'ai'edi anelose i da 'ita'ita'iekuga 'ako kebu 'adi mogitana i da souyedi.” ");
INSERT INTO yml_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tomotoganidi i maia Iesu 'ana 'ive'avina faifaina i vonedi i vo, Yau 'wa da vo to'ainike bega 'wa maia ma yami kefata wata fulumai 'aku 'ive'avina faifaina. 'Aiata 'aitamogana 'aitamogana a mimiabui Vanuga 'Eba Velu'ui nageneye a veve siwe kebu bei 'wa da 'ive'avinikuga. ");
INSERT INTO yml_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","We'e naninidi 'wa 'idewadiga 'waikuye nika ava'ai basenadi Yaubada yana tolu'ivonavo i kilumidi faifaiku yana Buki nageneye, 'adi mogitana i souyedi.” Iesu i vona'a'avana yana tovetutuyamavo matatabudi i degalovei. ");
INSERT INTO yml_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lovananina 'waineye ve'etoboda 'adi tovevo wata me Diu to'edakumeta 'au'auveadi i va'auta tovelomu bwaikina 'ana wagava Kaiafa yana vanuge. To'ive'avinanidi Iesu i mieni 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Fita i yogo'waila siwe kebu lilivadie, i nago i luku vanuganina 'ana kali nageneye, tanotanoge i miabui tolugaviavo taiadi, Iesu i vemata'i'i'ieni. ");
INSERT INTO yml_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Vanuganina nageneye tovelomu yadi to'edakumetavo wata me Diu yadi Kanisela i lalauala nuanuadi tomotoga 'ifwaidi i na veluagadi bega vekaliega Iesu i na vevitai sauluva sakoina faifaina nika to'edakumetanidi 'adi fata i na veimea i na wafa. ");
INSERT INTO yml_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Tomotoga fuedi i tovoi i lu'ivona-vekavekali siwe kebu mogitanaga. Mulieta 'eba ve'a'ava 'waineye tomotoga 'adi 'ailuga i tovoi i vona i vo, Tamu tutuya 'a nogai de'e tomogonina i vo, 'Aku fata Vanuga 'Eba Velu'ui a na geuya mulieta 'aiata 'aitonu nagedie a na vetovoi-vaitugani.’” ");
INSERT INTO yml_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tovelomu bwaikina i tovoi i voneni i vo, I vevitamuga bonadi 'u na tutuli, i vona mogitana 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Siwe Iesu kebu tamu ava'ai i da voneyeniga i veve'wada. Wata tovelomu bwaikina i velutoli-vaitugana Iesu 'waineye i vo, Yaubada miamia-vagaina mataneye 'u na vona mogitana kebu 'u na vekaliga. 'Omu Keliso, Yaubada 'ana Venua'ivina wata Natuna 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tovelomu bwaikina yana velutoli Iesu i tutuli i vo, 'U vonaga, 'asa'aiana bani'odi. Siwe matatabumi a na vonemi. 'Awaie yau a vetomotogaotoga 'wa na 'iseku ma yaku veimea Yaubada Bwaikaotogina 'ana 'atagiega a na miabui wata abamayega a na obuobuma waowa 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Iesu yana vona faifaina tovelomunina ma yana kamogala 'ana talauma i silabu'i i vo, 'Wa nogai? Yaubada 'waineye i vona-uvi'agala. 'Akonadi yana awavesako 'wa nogai, tovevita 'ifwaidi ta na talabodedi, kebu wata i na veveifufu. ");
INSERT INTO yml_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","We'e 'omi 'wa da nuani, i na wafa 'alo kebu?” Kaniselavo yana vona i tutuli i vo, Yana vonanina 'ana nogaya i lubwaineni wafa.” ");
INSERT INTO yml_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Bega maigina i 'ikiwakiwali, nimadi i nunumidi i nikenikei, i 'a'ava matana i umadi nimadiega i nikenikei wata i sidibidibieni i vo, 'Omu igodi Yaubada 'ana Venua'ivina, 'u da vonema, 'asiauotoga aitoi i nikemu?” ");
INSERT INTO yml_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","We'e Fita i miabui i miamia tanotanoge, nika tamu vavine tovelomu bwaikina yana tofolova i mai i voneni i vo, 'Omu, Iesu tomogo Galili, taiadi 'wa yabayaba.” ");
INSERT INTO yml_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Siwe tomotoga fuedi matadie i ve'ewa i vo, 'Omu ava'ai 'u vonevoneyeni a bavuyeni?” ");
INSERT INTO yml_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mulieta i vaganago kali 'ana 'eba luku 'waineye, wata tamu tofolova vevinena Fita i 'iseni tomotoga i vonedi i vo, Tomogo de'e, Iesu tomogo Nasaledi taiadi i yabayaba.” ");
INSERT INTO yml_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nika wata Fita i ve'ewa i vo, Vona mogitana, tomogonina kebu tamu sai'afo a da 'asetai.” ");
INSERT INTO yml_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kebu tutuya manamanawenaga, nika tomotoganidi bei i miamianiga i nagoi Fita 'waineye i voneni i vo, Vona mogitana, 'omu tamu Iesu iana, yamu itu 'ana nogaya 'omu wata Iesu ma fuemie me Galili.” ");
INSERT INTO yml_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nika Fita i ve'awafatafata i vo, 'Ai'edi a da vevekaliga, Yaubada i da nikeku, we'e aigodi, tomogonina kebu a da 'aseta-tonovi.” Fita i vona'a'ava nika kamukamu i kwage. ");
INSERT INTO yml_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","I nogai, i nuani Iesu yana vona i voneniga i vo, 'Ako lovane bola kamukamu kebu i na kwagega nagami tutuya 'aitonu 'u na bavusebeku.” Fita vonanina i nuani i souyeni 'atamane i taibwaubwau. ");
INSERT INTO yml_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","I 'atai 'awa'awaiogose tovelomu yadi to'edakumetavo wata me Diu to'edakumetavo 'au'auveadi, Iesu yana wafa 'ana 'eda tonovina faifaina i venua'ivina. ");
INSERT INTO yml_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","I veifufu i 'a'avana bulava kainumu 'wainega i yogoni i naweni i 'aniveleneni Loma kabemani yadi toveimea Failato 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tutuyanina Iudasa taunina to'etogiluva i 'asetai to'edakumetanidi yadi veimea Iesu i na wafa, nika ma yana nuavita bwaikina maninina siliba 30 i naweni nuanuana i na vevilai tovelomu yadi to'edakumetavo wata me Diu to'edakumetavo 'au'auveadi 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","I vonedi i vo, Yau a sakona, tomogonina a 'etogiluveniga yana sauluva tonovidi, siwe 'wa veimea i na wafa.” I voneni i vo, 'Omu taunimu, awale 'u vonevonema?” ");
INSERT INTO yml_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Bega Iudasa maninina i taweni Vanuga 'Eba Velu'ui 'ana 'efe'efeye, mulieta i souyeni i nago taunina i 'eto'imeni. ");
INSERT INTO yml_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tovelomu yadi to'edakumetavo maninina i 'ewai i vona i vo, De'e maninina tamu tomogo yana wafa tutulina begaidi kebu i da lubwaineni ta na yatoi Vanuga 'Eba Velu'ui 'ana mani taiadi.” ");
INSERT INTO yml_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","I veifufu i 'a'avana taunidi yadi nuanua i fali'atumaieni bega maninina 'wainega tamu tanoga i kimwanei. Tanoganina nagami nau 'ana to'abi yadi fwayafwaya dekudekuna 'wainega nau i 'abi'abidi, siwe tutuya de'e i kimwanei i na vetaumata mali tomotoga faifaidi. ");
INSERT INTO yml_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Fai maninina tamu tomogo yana wafa tutulina 'wainega fwayafwaya i kimwanei, bega tutuyanina 'wainega i velamu i maiga 'asiau, 'ana wagava Tanoga Dayadayagina. ");
INSERT INTO yml_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Tanoganina i kimwaneiga, nika bei Yaubada yana tolu'ivona 'ana wagava Ielemaia yana vona-samula 'ana mogitana i souyeni. Basenadiotoga i vona i vo, Me Isileli taunidi yadi nuanua i fali'atumaieni, tomogo tutulina i yatoiga mani siliba 30. Maninina 'wainega nau 'ana to'abi yadi tanoga i kimwanei, 'ana kimwane faifaina yau nagami 'Auvea i voneku.” ");
INSERT INTO yml_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","We'e Iesu i tovotovoi Failato mataneye, taunina kabemani Loma 'wainega, i velutolieni i vo, 'Omu me Diu yadi kini?” Iesu i vo, 'Asa'aiana 'u vona bani'odi.” ");
INSERT INTO yml_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Siwe tutuyanina tovelomu yadi to'edakumetavo wata me Diu to'edakumetavo 'au'auveadi i vevevita-maimaigiga Iesu kebu i da vonavona i veve'wadamo. ");
INSERT INTO yml_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Begaidi Failato i voneni i vo, I vevevitamuga nani tulina tulina 'waidiega 'u noganogai 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Siwe Iesu i baila kebu nuanuana vonanidi i na tutulidi begaidi Failato nuana i vogani. ");
INSERT INTO yml_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Malamala 'aitamogana 'aitamogana me Diu i sakasakali Uvi'agalatagona faifaina. Sakalinina 'waineye me Diu fuedi tamu iadi yogoyogonina i vevenua'ivineni bega kabemani i 'e'etoyavuya vanuga yogona 'wainega. ");
INSERT INTO yml_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tutuyanina 'waineye tamu tomogo 'ana wagava Balaba i miamia vanuga yogona nageneye, taunina to'ainike tomotoga fuedi i 'asetai. ");
INSERT INTO yml_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Me Diu to'edakumetavo yadi nuanua Failato i 'asetai, fai Iesu i ve'unumagigieni begaidi i 'aniveleneni. Bega tutuyanina tomotoga fuedi i va'auta Failato i velutoliedi i vo, Aitoi tomotogaga nuanuami a na 'etoyavuya, Balaba, 'alo Iesu, kumanina i golegoleni Keliso?” ");
INSERT INTO yml_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Failato i miabui vonayavuga 'ana didiga 'waineye, bola i vevelutolitoli nika tamu tomogo vala i mieni Failato yana vavine 'waidiega i vo, Tomogo we'e kebu i da sakonaga. Kebu tamu ava'ai 'u na 'idewai 'waineye fai lovane 'a 'enoneganega 'a 'iseni 'a kololo wata nuafouma i veviga.” ");
INSERT INTO yml_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Failato yana vavine 'adi 'enoneganega bola i veveifufuyeni, tovelomu yadi to'edakumetavo wata me Diu to'edakumetavo 'au'auveadi 'aila'a i nua'anidi bega Failato i na voneni Balaba i na 'etoyavuya we'e Iesu i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mulieta Failato i velutoli-vaitugana 'waidie i vo, Aitoi tomotogaga nuanuami a na 'etoyavuya?”'Aila'a i vo, Nuanuama Balaba.” ");
INSERT INTO yml_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wata Failato i velutoliedi i vo, We'e Iesu, kumanina i golegoleni Keliso, bani'odi a na munegi?” I vo, 'U tutufwaseni 'ai lagalagana 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nika Failato i velutoli-vaituganedi i vo, Yana sakona ava'ai?” Siwe tomotoga i toke i vegolegole i vo, 'U tutufwaseni 'ai lagalagana 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tutuyanina Failato i 'asetai tomotoga kebu nuanuadi yana nuanua, 'aise'avadi i veve'alamagi'ai sai'afoga i da daba, begaidi ufa i mieni 'waineye, 'aila'a i 'ise'iseni nimana i lekoadi. I vonedi i vo, De'e yami 'eba 'isa, tomogo de'e yana wafa 'ana vita yau kebu a na tovoieni, 'omi 'ami vita.” ");
INSERT INTO yml_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","'Aila'a matatabudi yana vona i tutuli i vo, 'Asa'aiana yana wafa 'ana vita 'ima natumavo taiadi 'a na tovoieni.” ");
INSERT INTO yml_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Fai tomotoga nuanuadi Balaba, Failato i 'etoyavuya we'e ma'itufa i veimea Iesu i na toke i na fitali. I 'a'avana i 'aniveleneni me Loma tolugaviavo 'waidie i na tutufwaseni 'ai lagalagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mulieta Failato yana tolugaviavo Iesu i naweni kabemani yadi vanuga bwaikina 'waineye, bei tolugaviavo matatabudi i va'augidi Iesu i tovififineni i sisidibidibieni. ");
INSERT INTO yml_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","'Ana talauma i yavudi mali talauma yamoyamoina 'wainega i talaumai. ");
INSERT INTO yml_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","I ve'weseni i 'a'ava 'ou'ounigodi ma yana 'ibadi i 'etofifini 'unu'ununeye i biuleni wata wautogana i 'ewai i vekia'umia 'ana 'atagiega. Vaigavunidi kini 'adi vaigavu bani'odi, yadi vaiseba i 'odu'odu 'waineye i sidibidibieni i vo, Kaiwa, 'omu me Diu yadi kini.” ");
INSERT INTO yml_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","I 'ikiwakiwali wata wautogananina 'wainega 'unu'ununeye i 'a'ainike. ");
INSERT INTO yml_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yadi saidibi i 'a'avana, talaumanina yamoyamoina i yavuya, taunina 'ana talauma 'wainega i talaumai, mulieta i vagavaia i naweni i na tutufwaseni 'ai lagalagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","I souyedi i nunagoi tamu tomogo Sailini 'ana wagava Saimoni i veluagai i lukakadeni Iesu 'ana 'ai lagalagana i eva. ");
INSERT INTO yml_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","I nagoi i le'wa tamu 'awalawa 'waineye 'ana wagava Goligota, 'ana saivila 'Unu'unu. ");
INSERT INTO yml_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bei oine i 'idewai tamu konini golana taiadi i veleni i na yemu bega 'ana kini'ona kebu i na veviga, siwe i baila veviganina faifaina i tauyeni. ");
INSERT INTO yml_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mulieta i tutufwaseni 'ai lagalagana 'waineye, i 'a'avana tolugaviavo nuanuadi Iesu 'ana talauma i na veusedi begaidi tamu 'wava i 'waveni bani'odi kate. 'Ai'edi aitoi i na kumetaga ava'ai talaumaga nuanuana i na 'ewai. ");
INSERT INTO yml_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mulieta i miabui i vevemata'i'ieni. ");
INSERT INTO yml_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","'Ana 'ai lagalagana tabwaneye vonanina 'wainega i vevitaiga i kilumi i tutufwaseni. Vonanina i kilumiga side bani'odi. TOMOGO DE'E IESU, ME DIU YADI KINI ");
INSERT INTO yml_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wata tovainago 'adi 'ailuga i tutufwasedi, tamu Iesu 'ana 'atagiega, tamu 'ana wamayega. ");
INSERT INTO yml_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Tomotoga 'ai lagalagana lilivaneamo i nunagoi, i veugalewalewa wata Iesu i yagayagaia i vo, 'Omu igodi Vanuga 'Eba Velu'ui 'u da sigeuya wata 'aiata 'aitonu nagedie 'u da vetovoia. 'Ai'edi 'omu Yaubada natuna, nika taunimu 'u na 'ita'ita'iemu, 'u na obuma 'ai lagalagana 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Wata bani'odi tovelomu yadi to'edakumetavo, ve'etoboda 'adi tovevo wata me Diu to'edakumetavo 'au'auveadi i sidibidibieni i vo, Tomotoga 'ifwaidi i 'ita'ita'iedi, we'e taunina kebu 'ana fata. Igodi me Isileli yada Kini. 'Ai'edi 'asiauotoga i da obuma 'ai lagalagana 'wainega ta da 'iseni ta da ve'awamogitana. ");
INSERT INTO yml_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I vetumagana Yaubada 'waineye wata i vo, Yau Natuna,’ nika ta na 'iseni 'ai'edi mogitana Yaubada nuanuana i na 'ita'ita'ieni.” ");
INSERT INTO yml_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wata bani'odi tovainagonidi taiadi i tutufwasediga ma fuedie i manini. ");
INSERT INTO yml_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","'Aiata 'ana utukamwana 'waineye fwayafwaya matatabuna i dudubali, i nagoga 'ana tugusa lavilavie 3 kiloki i magetai. ");
INSERT INTO yml_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","'Awasasanina 'waineye Iesu i toke i vegole me Diu bonadiega i vo, Iloi, Iloi, lema sabakitani,”'ana saivila i vo, Yaku Yaubada, yaku Yaubada, awale 'u bailaotogeku?” ");
INSERT INTO yml_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","'Ifwaidi tomotoga i tovotovoiga bonana i nogai i vo, Ilaitia i golegoleni, nuanuana abamayega i na mai i na 'ivaiseni.” ");
INSERT INTO yml_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tamu tomogo i lilide i nago kikifa i lu'utuvi oine yuyuna 'waineye, tamu 'ai 'waineye i velugaganeni i 'iyoyoeni Iesu 'waineye nuanuana i na yemu. ");
INSERT INTO yml_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nika 'ifwaidi i vo, 'U ve'wada, nagami ta na 'iseni voke Ilaitia i mimai i na 'ita'ita'ieni.” ");
INSERT INTO yml_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Wata Iesu i toke i vegole, 'anu'anununa i tauyeni nika yawaina i 'awatagoni. ");
INSERT INTO yml_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","52","Vanuga 'Eba Velu'ui nageneye tamu saiboda kaleko badubaduna 'wainega Yaubada yana tutudaba tabutabuotogina i sisibodai. Tutuyanina Iesu yawaina i 'a'avaga saibodanina i 'anilabu'alugedi, tabwanega i obu dibuneye. Yoyoyo i yue, kileu i 'anifuadi wata taumata 'ifwaidi i si'ididi, Yaubada yana tomotoga 'atumaidi basenadi i wafaga, fuedi i yawasa. ");
INSERT INTO yml_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","'Adi taumata i 'iawedi, mulieta tutuyanina Iesu wafayega i tovoi tomotoganidi i nagoi Ielusalema, bei tomotoga fuedi i 'isedi. ");
INSERT INTO yml_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","We'e tolugaviavo ma yadi to'edakumeta 'ai lagalagana lilivaneye i tovoi i 'ise'iseni, nika yoyoyo i yue, dudubala wata nani 'ifwaidi i 'isedi i kololo bwaikina i ve'awamogitana i vo, Vona mogitana, taunina Yaubada Natuna.” ");
INSERT INTO yml_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","We'e vevine fuedi 'ani'ieyega i tovoi i 'isanago 'ai lagalagana 'waineye, kumanidiavo Iesu 'ana to'aivaita Galiliega taiadi i maia. ");
INSERT INTO yml_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Vevinenidi 'waidiega 'adi 'aitonu side 'adi wagava, Meli 'atamana Magidala 'wainega, Meli Iemesa ma taina Iosefa inadi wata Sebedi yana vavine, kumanidi Iemesa ma taina Ioni inadi. ");
INSERT INTO yml_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","'Akonadi i laviotogi tamu tomogo 'ana wagava Iosefa 'atamana Alimadia 'wainega i mai, taunina tamu Iesu yana tovetutuyama wata 'ai'aiwabuna. ");
INSERT INTO yml_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","I nago Failato 'waineye i velu'ui Iesu tomogona faifaina. Bega Failato yana tolugaviavo i vonedi Iesu tomogona i na ta'ia Iosefa i na veleni. ");
INSERT INTO yml_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Iosefa Iesu tomogona i naweni velu'uva 'ivauna wata 'avu'avuna 'wainega i fania, mulieta taunina 'ana taumata bogiotoga i ala-vagaseniga matumatu 'waineye, bei i ve'ufai. I ve'ufai mulieta kileu bababana i ketoi i mieni taumata 'awana i vetovibodai nika i tauya. ");
INSERT INTO yml_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meli 'atamana Magidala 'wainega ma wagavina Meli i miabui i 'i'isanago taumata 'waineye. ");
INSERT INTO yml_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Iesu i tutufwaseniga me Diu yadi 'Aiata 'Idewadewa 'waineye, bega i 'atai tovelomu yadi to'edakumetavo wata totafalolo Falisi i nagoi Failato 'waineye i voneni i vo, 'Auvea, 'a nuanuani tovekalinina Iesu bola ma yawaineye i vona i vo, A na wafa siwe 'aiata aitonu i na 'a'ava nika a na tovoi-vaitugana.’ ");
INSERT INTO yml_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yana vonanina faifaina nuanuama 'u na veimea taumata i na ve'isabodeni, i na nagoga 'ana tugusa 'aiata 'aitonu i na 'a'ava. I na ve'isabodeniga nika yana tovetutuyamavo kebu 'adi fata i na nago tomogona i na vinagoi i na yatovai'edeni, we'e tomotoga i na vekaliedi i na vo, 'Akonadi i tovoi wafayega.’ Nika vekalinina i na vebwaika-'afo'afo nagami yana vekali sai'afo siaina.” ");
INSERT INTO yml_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bega Failato i vonedi i vo, Tolugaviavo a tauyedi, 'wa na nawedi taumata 'wa na ve'isaboda-'atumaieni.” ");
INSERT INTO yml_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Failato i vonedi i 'a'avana, i tauya i nagoi, taumatanina 'ana saiboda 'waineye yadi tugusa i yatoi bega kebu tamu aitoi 'ana fata i na luku, wata tolugavianidi i vonedi i na ve'isabodeni. ");
INSERT INTO yml_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Me Diu yadi 'Aiata Veawai i 'a'avana, Tafalolo 'awa'awaiogose Meli 'atamana Magidala 'wainega ma wagavina Meli i tovoi i nagoi taumata i na 'iseni. ");
INSERT INTO yml_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","I nunagoi nika yoyoyo bwaikina i yue 'Auvea yana anelose abamayega i obuma, kileu bababana bega taumata 'awana i vetovibodaiga i bifeleni, i laka tabwaneye i miabui. ");
INSERT INTO yml_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anelosenina 'ana 'isa 'wa da vo tamuyoana i da kianamali we'e 'ana talauma 'adi lau'avu mataududulidi. ");
INSERT INTO yml_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tolugavianidi i 'iseni i kololo-'afo'afo, i tatava nika i 'anifoidi 'adi 'isa 'wa da vo i da wafa. ");
INSERT INTO yml_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anelosenina vevine i vonedi i vo, We'e 'omi kebu 'wa na kolologa. A 'asetami Iesu kumanina i tutufwaseniga 'ai lagalagana 'waineye 'wa lulualeni. ");
INSERT INTO yml_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","De'e bei kebu, 'akonadi wafayega i tovoi, bani'odi basenadi i vona. 'Wa maia 'wa na 'iseni 'ana 'ivi'ava. ");
INSERT INTO yml_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","We'e tutuya de'e 'wa na vila-matayo'omi 'wa na nagoi yana tovetutuyamavo 'waidie side bani'odi 'wa na vonedi 'wa na vo, Iesu 'akonadi wafayega i tovoi, i kumekumeta Galili, 'wa na nagoi nika bei 'wa na veluagai. Naninidi a vonemiga, kebu nuami i na fani.’” ");
INSERT INTO yml_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Vevinenidi yana vona i nogai nika i tauya ma yadi kololo wata ma yadi sosoana i lilide i nunagoi tovetutuyamavo i na vonedi. ");
INSERT INTO yml_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","I nunagoiga nika Iesu i veluagai i vonedi i vo, Ekwavo, kaiwa.” I vaganagoi 'waineye ma yadi ve'ililibu i 'odu 'ageneye i 'abi i subiai. ");
INSERT INTO yml_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Wata Iesu i vonedi i vo, Kebu 'wa na kolologa, 'wa na nagoi taikwavo 'wa na vonedi i na nagoi Galili bei taiadi 'a na veluaga.” ");
INSERT INTO yml_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Iesu i vona'a'ava vevine i tauya i nunagoi, we'e tolugavia 'ifwaidi, kumanidiavo taumata i veve'isabodeniga i nagoi Ielusalema naninidi i souyediga matatabuna i lu'ivoneyedi tovelomu yadi to'edakumetavo 'waidie. ");
INSERT INTO yml_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Mulieta tovelomu yadi to'edakumetavo wata me Diu to'edakumetavo 'au'auveadi i va'auta yadi nuanua i 'idewai. Mani bwaikina tolugavianidi i veledi wata i vonedi i vo, 'Wa na nagoi 'wa na veveifufu 'wa na vo, Lovane 'a 'eno'enovi yana tovetutuyamavo i maia Iesu tomogona i vinagoi.’ ");
INSERT INTO yml_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","'Ai'edi de'e bani'odi 'wa na vonevoneyedi toveimea bwaikina kabemani i na nogai i na nuasakoga 'waimie, 'ima nuana 'a na 'ive'atumaia nika kebu vita i na velemiga.” ");
INSERT INTO yml_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tolugavianidi mani i 'ewai i nago i veifufu tomotoga 'waidiamo i vo, Lovane 'a 'eno'enovi, yana tovetutuyamavo i maia tomogona i vinagoi.” Bega veifufunina me Diu fuedi i nogai i awavemogitaneni begaidi 'eba velamu 'wainega i maiga 'asiau wata bani'odi i veveifufuyedi. ");
INSERT INTO yml_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yana tovetutuyamavo matatabudi 11 i nagoi 'awalawa Galili 'oyanina Iesu i voneyeniga 'waineye i laka. ");
INSERT INTO yml_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tutuyanina i 'iseni i 'odu i subiai, we'e 'ifwaidi ma yadi venuanaluga i vo, Mogitana Iesu 'alo tulina?” ");
INSERT INTO yml_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu i vaganago 'waidie i vonedi i vo, Yaubada veimea i veleku i tauyeku nani matatabuna abame wata fwayefwayeye a na veveimeyedi. ");
INSERT INTO yml_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Begaidi 'wa na nagoi tomotoga matatabudi 'aila'a tulina tulina 'waidie, 'wa na lau'age bega taunidi 'aku tovetutuyamavo. Wata 'wa na bafitaisodi Tamada 'ana wagavayega, Natuna 'ana wagavayega wata 'Anu'anunu Magemagetana 'ana wagavayega. ");
INSERT INTO yml_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Veimea matatabuna a velemiga 'wa na ve tovetutuyamavo 'ivaudi 'waidie bega i na vematayakeyakedi. A vona mogitana 'waimie, yau tutuya fuedi lilivamie taiadi ta na miamia i na nagoga fwayafwaya 'ana 'eba ve'a'ava 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Iesu Keliso, Yaubada Natuna Valana 'Atumaina. Valanina 'Atumaina side bani'odi i velamuyedi. Basenadi tolu'ivona Aisea Yaubada yana Vona Natuna faifaina i kilumi. Natuna i voneni i vo, A na vonemu. Yaku tomata'aulele a na vetunei i na kumeta yamu 'eda i na vusia. ");
INSERT INTO yml_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sali'avu'avuye i vevegolegole i vo, 'Auvea yana 'eda 'wa na vusia, wata 'wa na sivetonovi yana 'eba nago.’” ");
INSERT INTO yml_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tomata'aulelenina 'asa'aiana Ioni Tobafitaiso. Sali'avu'avuye Ioni i lalau'age tomotoga 'waidie wata i bafitaisodi nika bei Aisea yana vona-samula 'ana mogitana i souyeni. I vonedi i vo, 'Wa na nuavilami yami sakona 'wa na vedumwe'ubu'ubusedi bega a na bafitaisomi wata Yaubada yami sakona i na nuatavunidi.” ");
INSERT INTO yml_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","'Awalawa Iudia matatabuna 'wainega wata Ielusalemayega tomotoga fuedi Ioni valana i nogai bega i nagoi 'waineye. Tutuyanina Ioni bonana i nogai, 'aitamogana 'aitamogana yadi sakona i lu'ivoneyedi nika Ioni i bafitaisodi Ufa Iolidani 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioni 'ana talauma kameli vutuvutudiega i 'idewadi, we'e bulumakau bunudi 'ana wa'ila, 'ana'ana limwana wata mai'awa. ");
INSERT INTO yml_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ioni i lau'age tomotoga 'waidie i vo, Kumanina mulikuye i mimaiga toketokeotogina yau kebu bani'odiga, kebu i da lubwaineku 'waineye a na vetofolova, fai taunina bwaikina. ");
INSERT INTO yml_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yau ufayega a babafitaisomi we'e 'awaie i na babafitaisomi 'Anu'anunu Magemagetana 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tutuyanina 'waineye Iesu i tauya 'atamana Nasalediega, 'awalawa Galili nageneye i nago Ioni 'waineye nika i bafitaisoi Ufa Iolidani 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","I bafitaiso i 'a'avana, ufayega i lakalakama nika i 'iseni abama i 'anikililia, 'Anu'anunu Magemagetana yana yaveobu Iesu 'waineye 'ana 'isa'isa bani'odi bunebune. ");
INSERT INTO yml_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bona i nogai abamayega i vo, 'Omu natuku nuafouku. Faifaimu a sosoana mogitana.” ");
INSERT INTO yml_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mulieta Yaubada 'Anu'anununa i vagavaia i naweni sali'avu'avuye. ");
INSERT INTO yml_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Bei 'aiata 40 nagedie i miamia, yaiaina yadi to'edakumeta Seitani, i mai i silubuya nuanuana Iesu i na sakona. 'Aisaya walawala'ai taiadi i miamia siwe anelose i 'i'isave'avini. ");
INSERT INTO yml_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Kini Elodi Ioni Tobafitaiso i 'ive'avini vanuga yogona nageneye i yatoi, mulieta Iesu i vilai i nago 'awalawa Galili. Yaubada Valana 'Atumaina i lulu'ageyeni i vo, Yaubada yana tutuya i le'wa, sai'afoga yana veimea i na souyeni 'waimie. 'Wa na nuavilami yami sakona 'wa na vedumwe'ubu'ubusedi, Vala 'Atumaina 'wa na vetumaganeni.” ");
INSERT INTO yml_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tamu 'aiata Iesu i balabala Lavu Galili balebaleamo tomotoga 'adi 'ailuga i 'isedi, Saimoni ma taina Anidulu vuatayega igana i 'ona'onadi fai taunidi toyaubani. ");
INSERT INTO yml_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu i vonedi i vo, We'e yaubaninina 'wa na baileni, 'wa na maia 'wa na vetovetutuyama 'waikuye, yau tamu yaubani a na vemi bega tomotoga 'wa na 'ona'onadi 'wa na mimaiedi Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nika Saimoni wata Anidulu vualalalakana i bailedi Iesu taiadi i nagoi i na vetovetutuyama 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sai'afo i vaganago nika Sebedi natunavo i 'isedi, Iemesa wata Ioni yadi wakeye yadi vuata i agiagilidi. ");
INSERT INTO yml_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tutuyanina Iesu i 'isedi i goledi i vo, 'Wa maia,” nika tamadi ma yana tofolovavo wakeye 'iawedi Iesu taiadi i nagoi Kafaneomi. ");
INSERT INTO yml_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu ma enavo i miamiani Kafaneomi, mulieta me Diu yadi 'Aiata Veawai 'waineye Iesu i luku 'eba miava'auta nageneye, bei i ve. ");
INSERT INTO yml_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tomotoga nuadi i voganidi fai ma yana veimea i veve 'waidie, kebu bani'odi yadi ve'etoboda 'adi tovevo. ");
INSERT INTO yml_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tutuyanina Iesu i veve, tamu tomogo yaiaina sakoina i ageiga i mai 'eba miava'auta 'waineye, Iesu yana vona i noganogai. ");
INSERT INTO yml_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Bei ma 'ana labilabina i vevegolegole i vo, Iesu tomogo Nasaledi, 'u bailema 'ima kebu nuanuama 'omu. Voke nuanuamu 'u na leoma? A 'asetamu, 'omu Magemagetamu 'u mai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu yaiaina i talabodeni i vo, 'U ve'wada, 'u 'awa'a'imu tomogo 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yaiainanina tomogo i toke i fetoi i vebwaubwau nika i 'awa'a'ia. ");
INSERT INTO yml_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tomotoga i 'iseni nuadi i voganidi i veveakutolieni i vo, Emavo, de'e ava'ai vega? Yana ve 'ivauna wata ma yana veimea, yaiaina i tatalabodedi nika i vevematayakeyakeni.” ");
INSERT INTO yml_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tomotoga fuedi i lu'ivoneyeni bega valana 'awalawa Galili matatabuna i 'aseta. ");
INSERT INTO yml_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","'Eba miava'auta 'wainega Iesu ma enavo i souyedi tonovidi i nagoi Saimoni wata Anidulu yadi vanuge. Iemesa wata Ioni taiadi i nagoi. ");
INSERT INTO yml_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimoni yana vavine inadi i viga tomogodi i luyauyauta i 'eno'eno 'ivie. Iesu i le'wa i veifufu 'waineye yadi viga faifaina. ");
INSERT INTO yml_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesu i luku nimadie i 'abi i sivetovoidi nika yauyautanina i 'awatagoni, ma fuedie 'adi'adi i 'idewadewa. ");
INSERT INTO yml_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Inala 'akonadi i iniva i lavilavia, tomotoga ediavo yaiaina i agediga wata toviga i miedi Iesu 'waineye wata tomotoga matatabudi 'atamana bwaikina 'wainega i va'auta vanuga 'awaneye. ");
INSERT INTO yml_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Toviga 'adi viga tulina tulina Iesu i 'ive'atumaidi wata i vona yaiaina fuedi i 'awa'a'idi. Yaiainanidi i talabodebodedi kebu i na lulu'ivona fai 'akonadi i 'asetai taunina Keliso, Yaubada 'ana Venua'ivina. ");
INSERT INTO yml_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bola 'awa'awaiogose kebu i da magetaiga Iesu i tovoi, vanugayega i souyeni i nago tamu 'awasasa kebu tomotoginaga 'waineye, 'aiseneye i velu'ui. ");
INSERT INTO yml_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mulieta Saimoni ma enavo i 'isa Iesu i 'isa'avai i nagoi i lualeni. ");
INSERT INTO yml_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tutuyanina i veluagai i voneni i vo, Tomotoga fuedi nuanuadi 'omu, begaidi i lulualemu.” ");
INSERT INTO yml_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iesu i vonedi i vo, Ta na nagoi mali 'atamana 'waidie bei wata a na lau'age, folovanina faifaina a mai.” ");
INSERT INTO yml_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bega i nagoi i lau'age-vuvua 'awalawa Galili matatabuna 'waineye, yadi 'eba miava'auta nagedie wata yaiaina tomotoga i agediga, i vonavona nika i 'a'awa'a'idi. ");
INSERT INTO yml_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tamu tomogo viga sakoina 'eba kololo tomogona i velufo'afo'ana, i mai Iesu 'waineye ma yana ve'ililibu i 'odu i velu'ui 'aivaita faifaina i vo, 'Ai'edi nuanuamu, 'amu fata 'u na 'ive'atumaiku.” ");
INSERT INTO yml_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu tomogonina i 'isanuakalikalieni bega i 'abitonovi i voneni i vo, Fai bani'odi, nuanuaku, 'u ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yana voneye, nika tomogonina 'ana viga i 'a'ava i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Bega Iesu i toke i talabodeni wata i vetunei i vo, Kebu tamu aitoi 'waineye 'u na lu'ivonaga, nuanuaku tonovimu 'u na nago tovelomu 'waineye, nagami i na 'isemu. Mulieta yamu velomu 'u na 'aniveleneni bani'odi veimeanina i mai Mosese 'wainega, toviganina i ve'atumaiga faifaina. Tovelomunina i na 'isemu i na ve'awamogitana 'akonadi 'u ve'atumai wata bani'odi mali tomotoga i na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Siwe tomogonina yana ve'atumai i lu'ivoneyeni 'aila'a 'waidie, begaidi tomotoga fuedi i mimaia Iesu 'waineye, i tovififineni wata i vevetunufelagieni bega kebu 'ana fata i na luku 'atamana bwaikidi 'waidie. Begaidi i miamia 'awasasa kebu tomotoginaga 'waineye siwe wata tomotoga fuedi 'awalawa tulina tulina 'waidiega i nunagoi 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","'Aiata 'ifwaidi i 'a'ava, mulieta Iesu i vilai i nago Kafaneomi i luku vanuge. Tomotoga fuedi valana i nogai bega i va'auta vanuga nagena wata 'awana i luvaia, mulieta Iesu Yaubada yana Vona i lu'ageyeni 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tutuyanina Iesu i lalau'age, tomotoga 'adi 4 iadi i vebwalokoga ma 'evo'evona i mieni Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","I le'weni 'aila'a bwaikina i 'isedi kebu 'adi fata i na luku, begaidi i laka vanuga 'ubuneye ava'aibe bei Iesu i tovotovoi, 'ana saila'a 'ifwaidi i 'ewadi bega 'anibwekaneamo ma 'evo'evona i ve'ioyoi i obu. ");
INSERT INTO yml_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu i 'isedi i 'asetai ma yadi vetumagana begaidi tomogo bwalobwalokona i voneni i vo, Natuku, yamu sakona a nuatavunidi.” ");
INSERT INTO yml_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","'Ifwaidi ve'etoboda 'adi tovevo Iesu yana vona i nogai, nuadiega i vo, Awale i vona-uvi'agala Yaubada 'waineye? Kebu tamu aitoi 'ana fata sakona i na nuatavunidi, Yaubada 'aiseotogina 'ana fata.” ");
INSERT INTO yml_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iesu 'akonadi yadi nuanua i 'asetai i vonedi i vo, Awale bani'odi 'wa vevenua'ivinedi? ");
INSERT INTO yml_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","'Aku fata tomogonina a na voneni a na vo, Yamu sakona a nuatavunidi,’ wata 'aku fata a na vo, 'U tovoi, 'amu 'evo'evo 'u evai 'u nago.’ 'Wa da nuani, ava'ai vonaga safailina? ");
INSERT INTO yml_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Siwe a na vemi yau a vetomotogaotoga ma yaku veimea fwayefwayeye bega 'aku fata tomotoga yadi sakona a na nuatavunidi.” Begaidi Iesu tomogo bwalobwalokona i voneni i vo, 'U tovoi, 'amu 'evo'evo 'u evai 'u nago yamu vanuge.” ");
INSERT INTO yml_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nika i tovoi fuedi i 'iseni yana sita i evai i tauya. Matatabudi nuadi i voganidi bega Yaubada i subiai i vo, Kebu tamu tutuya bani'odi ta da 'iseniga.” ");
INSERT INTO yml_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu wata i vila-vaitugani i nago lavuye. 'Aila'a bwaikina i maia 'waineye, bei wata i ve. ");
INSERT INTO yml_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","'Akonadi yana ve i 'a'ava, i nunagoga takesi 'ana tolaugogona i 'iseni 'eba takesi 'waineye i miamia, 'ana wagava Livai, Alefasi natuna. Iesu i voneni i vo, 'U mai taiadi ta na nago, yaku tovetutuyama.” Nika Livai i tovoi Iesu taiadi i nago. ");
INSERT INTO yml_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mulieta Iesu ma yana tovetutuyamavo, tolaugogona 'ifwaidi wata tosakona ma fuedie i 'ani'ani Livai yana vanuge. Tomotoganidi Iesu i yoyogo'wai'waili. ");
INSERT INTO yml_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","'Ifwaidi ve'etoboda 'adi tovevo, kumanidiavo totafalolo Falisi, i 'isedi i nagoi Iesu yana tovetutuyamavo 'waidie, i velutoliedi i vo, Awale takesi tolaugogona vivinagodi wata tosakona taiadi i 'ani'ani, kebu 'ana 'isa 'atumainaga.” ");
INSERT INTO yml_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu i nogai i vona-awatabai 'waidie i vo, Egavo 'atumaidi kebu nuanuadi viga 'adi to'ive'atumai, 'aisedi toviga mogitana. Wata bani'odi, yau a maiga kebu taunidi i awave'atumaiediga faifaidi, a maiga tosakona a na 'ita'ita'iedi.” ");
INSERT INTO yml_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ioni Tobafitaiso yana tovetutuyamavo wata totafalolo Falisi 'ani 'wainega i veve'udigana, nuanuadi yadi velu'ui Yaubada 'waineye i na vetoketoke. Tomotoga 'ifwaidi i maia Iesu i velutolieni i vo, Awale Ioni yana tovetutuyamavo wata Falisi i veve'udigana 'ani 'wainega velu'ui faifaina, we'e yamu tovetutuyamavo kebu i da veve'udiganaga?” ");
INSERT INTO yml_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu yadi vona i tutuli, taunina faifaina i vona-awatabai i vo, Tonagi yana sosoana 'waineye kebu tamu aitoi 'ana fata enavo i na talabodedi bega 'ani'ani i na baileni. ");
INSERT INTO yml_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","We'e tamu 'aiata tomotoga 'ifwaidi i na maia tonaginina i na 'ive'avini i na naweni, i lubwainedi enavo ma yadi nuavita i na veve'udigana.” ");
INSERT INTO yml_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wata Iesu i awatalatutula 'waidie yana ve sauluva 'ivauna faifaina wata me Diu yadi sauluva tuatuaina 'adi luwanawana faifaidi i vo, 'Ai'edi talauma tuatuaina i na 'anilabu'i we'e kaleko 'ivaunega ta na bwadia kebu i da lubwaineni. Fai bola ta na lekoai bwadi 'ivauna i na vesiai bega i na vefato'ai'ai tuatuaina i na 'anilabu'i.” ");
INSERT INTO yml_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wata bani'odi oine 'ana ba'ala 'aisaya bunudiega, faifaina Iesu i vona i vo, 'Ai'edi oine 'ivauna we'e ba'ala tuatuaina 'waineye i na iwagi i na yuvefuai. Oine i na iwaga 'ana ve'amubwadodo fai aya'aina wata ba'ala 'akonadi i sako. We'e 'ai'edi oine 'ivauna wata ba'ala 'ivauna nika bikabikana i lubwaineni kebu i na yuvefuai 'ailugana 'atumaidi.” ");
INSERT INTO yml_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tamu 'Aiata Veawai 'waineye, Iesu ma yana tovetutuyamavo i nunagoi bakula 'waineamo, yana tovetutuyamavo i lase bega witi vuagidi i kaliwawadi i 'ani. ");
INSERT INTO yml_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","We'e 'ifwaidi Diu totafalolo Falisi i 'isedi Iesu i voneni i vo, 'U 'isanawedi, yamu tovetutuyamavo me Diu yada ve'etoboda i geugeuya witi vuagidi i kakaliwawadi, 'asa'aiana i folofolova 'Aiata Veawai 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu Falisi yadi vona i tutuli i vo, 'Wa da vo Yaubada yana Buki kebu 'wa da lu'iawawaiga, basenadiotoga Kini Devida ma enavo i lase faifaina. ");
INSERT INTO yml_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiada tovelomu bwaikina yana tutuye Devida i luku Yaubada yana Vanuga 'Eba Velu'ui nageneye, beledi tamu Yaubada 'ana 'anivelena i 'ewai ma enavo i 'ani. De'e tamu 'ada veimea, kebu aitoi 'ana fata beledinina i na 'ania tovelomu 'aisedi 'adi tauya. ");
INSERT INTO yml_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yaubada 'Aiata Veawai i yatoi tomotoga 'ada 'aivaita ta na veawai faifaina, kebu i da yatoi bega 'aiatanina i na veimeyeda. ");
INSERT INTO yml_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yau a vetomotogaotoga, nani matatabuna 'Aiata Veawai taiadi 'adi Toveimea, begaidi 'aku laubwaina 'aiatanina 'waineye tomotoga yadi sauluva faifaina a na veveimea.” ");
INSERT INTO yml_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu i vilai i nago me Diu yadi 'eba miava'auta 'waineye tamu tomogo i 'iseni nimana 'okana bei i miamia. ");
INSERT INTO yml_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","We'e Diu totafalolo 'ifwaidi Iesu i vemata'i'i'ieni. 'Ai'edi toviganina i na 'ive'atumaia 'Aiata Veawai 'waineye i na tolimatani fai folovanina 'wainega, igodina yadi veimea i da geugeuya. ");
INSERT INTO yml_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu i vona tomogo nimana 'okana 'waineye i vo, 'U mai side bei 'aila'a manawadie 'u tovoi.” ");
INSERT INTO yml_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tomogonina i mai mulieta Iesu Diu totafalolo i velutoliedi i vo, Yada veimea 'Aiata Veawai faifaina, 'wa da nuani, ta na vevesauluva-'atumai 'alo ta na vevesauluva-sako? Wata 'ai'edi tamu tomogo sai'afoga i na wafa ta na 'ivaiseni 'alo ta na luvewafai?” Siwe kebu bonana i da tutuliga. ");
INSERT INTO yml_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu i nuavita fai tomotoganidi kebu nuanuadi tomogo nimana 'okana i na 'ivaiseni. Begaidi Iesu i nuasako 'aitamogana 'aitamogana i 'isadewadi nika tomogo nimana 'okana i voneni i vo, Nimamu 'u si'otoi.” Nimana i si'otoi nika i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Falisi i 'iseni nika i tauya i nagoi i veifufu Kini Elodi yana 'aila'a taiadi bani'odi i na munega Iesu i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Iesu ma yana tovetutuyamavo i nagoi lavuye, siwe 'aila'a bwaikina Iesu yana folova valana i nogai i yogo'waila i maia 'awalawa Galili wata Iudia 'waidiega. 'Ifwaidi i maia Ielusalemayega, Idumeayega, Ufa Iolidaniega i damanama, 'atamana Taia wata Saidoni lilivadiega. ");
INSERT INTO yml_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Tomotoga fuedi i 'i'ive'atumaidi begaidi toviga i vevetunufelagieni nuanuadi i na 'abitonovi bega i na ve'atumai. 'Aila'a bwaikina begaidi Iesu yana tovetutuyamavo i vonedi waka i na 'ivenonogi faifaina, 'ai'edi i na lutamubodeniga nika i na laka tabwaneye i na lau'age. ");
INSERT INTO yml_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wata tomotoganidi yaiaina i agediga Iesu i 'iseni, yaiainanidi i tawedi i lumata'afufu fwayefwayeye Iesu mataneye i vebwaubwau i vo, 'Omu Yaubada Natuna.” ");
INSERT INTO yml_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Siwe Iesu yaiaina i talabodedi kebu faifaina i na veveifufu. ");
INSERT INTO yml_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tamu tutuya Iesu i laka 'oyeye, tomotoganidi Iesu nuanuana i goledi i na nagoi 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Tomotoganidi 'waidiega 'adi 12 Iesu i venua'ivinedi yana tomata'aulelevo bega i na miamiani 'waineye. Mulieta i na vetunedi i na lau'age tomotoga 'waidie, wata veimea i na veledi bega i na vona yaiaina tomotoga i agediga, i na 'awa'a'idi. ");
INSERT INTO yml_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tomotoganidi 12 i venua'ivinediga side 'adi wagava. Saimoni, kumanina Iesu i goleni Fita, ");
INSERT INTO yml_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Iemesa ma taina Ioni, taunidi Sebedi natunavo kumanidiavo Iesu i goledi Boenati, 'ana saivila Tamuyoana Natunavo. ");
INSERT INTO yml_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anidulu, Filifi, Batolomiu, Madiu, Tomasi, Iemesa, Alefasi natuna, Tadiusa, Saimoni, toawa'idi'idi kebu nuanuana Loma kabemani i na veveimeyedi, ");
INSERT INTO yml_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Iudasa Isakaliota, kumanina Iesu 'ana to'etogiluva. ");
INSERT INTO yml_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tutuyanina Iesu i le'wa vanuge, tomotoga fuedi i velamu i mimaia 'waineye, bega yana tovetutuyamavo taiadi kebu tamu 'awasasa i da veledi 'ani faifaina. ");
INSERT INTO yml_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tutuyanina Iesu yana 'aila'a valana i nogai i maia, igodi nuanuadi i na vagavaia i na naweni, fai i vonavona i vo, Iesu i ve'wava'wava.” ");
INSERT INTO yml_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","We'e ve'etoboda 'adi tovevo Ielusalemayega i maiaga i vona i vo, Seitani, yaiaina yadi to'edakumeta, Iesu i agei yana toketokena i veleni bega i vonavona yaiaina i 'a'awa'a'idi.” ");
INSERT INTO yml_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iesu i goledi i maia 'waineye i vona-awatabai 'waidie i vo, Yaku folovanina kebu Seitani yana toketokena 'wainega, fai Seitani kebu nuanuana enavo i na sogiedi. ");
INSERT INTO yml_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","'Ai'edi 'eba veimea 'aise'avadi i na 'idia i na vevetalaga bola 'eba veimeanina i na velovi. ");
INSERT INTO yml_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wata 'ai'edi vanuga 'ana tomia yadi ve'ikwayekwayega 'wainega 'idi i na souyeni, nika i na yavula. ");
INSERT INTO yml_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wata bani'odi 'ai'edi Seitani yana 'aila'a 'aise'avadi i da 'idia i da vevetalaga kebu 'ana fata i na miamia i na 'a'avaotoga. ");
INSERT INTO yml_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Side bani'odi. Kebu tamu aitoi 'ana fata i na luku tamu tomogo toketokena yana vanuge i na vainago, we'e 'ai'edi nuanuana, nagami tomogonina toketokena i na 'iyogoyogoni, mulieta i na vainago. ");
INSERT INTO yml_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Begaidi a na vonemi, tomotoga 'adi fata nuatavuna i na veluagai yadi sakona wata awavesako tulina tulina faifaidi. ");
INSERT INTO yml_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Siwe egavo i na vona-uvi'agala 'Anu'anunu Magemagetana 'waineye, kebu 'ana fata Yaubada i na nuatavunidi, yadi sakonanina i na 'eno-vagata.” ");
INSERT INTO yml_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu i vonaga fai tomotoga 'ifwaidi i vo, Kumanina yaiaina sakoina i agei,” we'e mogitana 'Anu'anunu Magemagetana 'wainega i vona yaiaina i 'awa'a'idi. ");
INSERT INTO yml_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iesu tainavo ma inadi i maia 'waineye, i tovoi 'atamanayega i vevelutoli Iesu faifaina. ");
INSERT INTO yml_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","'Aila'a Iesu taiadi i miamianiga i voneni i vo, Taimwavo wata inamu siva'e i lulualemu.” ");
INSERT INTO yml_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iesu i vona i vo, 'Wa da nuani, egavo taikwavoga wata inaku?” ");
INSERT INTO yml_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tomotoganidi i miafifineniga 'aitamogana 'aitamogana Iesu i 'isedi i vonedi i vo, A na vonemi. Side, yaku tovetutuyamavo, taunidi inaku wata taikwavo. ");
INSERT INTO yml_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aitoi Yaubada yana nuanua 'ana to'idumwebika, taunina inaku, novuku wata taiku.” ");
INSERT INTO yml_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tamu tutuya wata Iesu i vilai i mai Galili i ve lavu lilivaneye. 'Aila'a bwaikina i sififineni bega Iesu i dodoga wakeye i miabui, we'e tomotoga matatabudi i tovoi balebaleye i lau'age 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Nani fuedi i ve 'waidie vona-awatabaiega. Yana ve 'waineye i vo, A na vonemi. Tamu tomogo i nago bakule yana witi waifeidi i na bakulidi, we'e yadi sauluva luyavuyavulagi. ");
INSERT INTO yml_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yana luyavuyavulagi 'waineye witi 'ifwaidi i ve'anita'idi 'eda balebaleye, manuga i mai i 'anidi. ");
INSERT INTO yml_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","'Ifwaidi i ve'anita'idi bwakebwakeye, nagami i tabo-matayo'o fai fwayafwaya kebu badubadunaga. ");
INSERT INTO yml_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Siwe tutuyanina inala i kabu i 'awagi'adi fai 'walamidi kebu i da vagaobuga. ");
INSERT INTO yml_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","'Ifwaidi i ve'anita'idi 'awanavenaveye kebu 'adi 'oiga, i ugawegawedi bega kebu vuagidiga. ");
INSERT INTO yml_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","'Ifwaidi i ve'anita'idi inageye fwayafwaya 'atumaina 'waineye i tabo i vuaga. Witi 'ifwaidi vuagidi 30, 'ifwaidi 60, 'ifwaidi 100. ");
INSERT INTO yml_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Veifufu de'e 'wa nogaiga, 'wa na venua'ivineni nika 'wa na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mulieta Iesu 'aiseneye 'ifwaidi tomotoga toyogo'waila wata yana tovetutuyamavo 12 i maia 'waineye i voneni i vo, Nuanuama yamu vona-awatabai 'u na kiavemagetadi.” ");
INSERT INTO yml_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesu i vonedi i vo, 'Akonadi Yaubada i tauyemi nani fuedi givagivadi 'wa 'asetadi yana veimea tomotoga 'waidie faifaina. Siwe egavo Yaubada yana veimea i bavuyeni, vona-awatabai 'waidiega Yaubada yana Vona i noganogaidi. ");
INSERT INTO yml_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Basenadiotoga tobavunidi faifaidi i kilumi Yaubada yana Buki nageneye i vo, Tomotoganidi i na 'isa'isa, siwe naninidi a 'i'idewadi kebu i na 'isa'inanadi. Yaku vona i na noganogai, siwe kebu nuadi i na magetadi. We'e 'ai'edi mogitana i da 'isa'inanadi wata nuadi i da magetadi, i da nuaviladi i da mai 'waikuye nika a da 'ive'atumaidi.’” ");
INSERT INTO yml_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mulieta Iesu i vonedi i vo, Vona-awatabainina safailina, siwe 'omi kebu 'wa da 'asetaiga, bani'odi 'wa na munega wata 'ifwaidi vona-awatabai 'wa na 'asetadi? ");
INSERT INTO yml_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tobakula taunina Yaubada yana Vona 'ana toluyavuyavulagi. ");
INSERT INTO yml_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Waifei 'ifwaidi i ve'anita'idi 'edeye 'ana nuanua, bani'odi tomotoga Yaubada yana Vona i nogai siwe Seitani i yogo-matayo'o vonanina i elodi. ");
INSERT INTO yml_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Waifei i ve'anita'idi bwakebwakeye 'ana nuanua, bani'odi tomotoga ma yadi sosoana Yaubada yana Vona i nogai siwe yadi nuanua 'waidie kebu mogitana i da lukuga. I vetumagana siwe tutuya 'ale'usana. Tutuyanina vita 'alo ve'isakololo i na souyedi Vonanina faifaina, i na baila-matayo'oyeni. ");
INSERT INTO yml_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Waifei i ve'anita'idi gaweye 'ana nuanua, bani'odi tomotoga Yaubada yana Vona i nogai siwe yadi mia faifaidi i vevenuafouviga, 'ai'aiwabu nuadi i 'ewa'ewadi wata kukua 'adi nuanua 'waidie bwaikina 'wa da vo Yaubada yana Vona i da ugawegaweni kebu i da vuaga. ");
INSERT INTO yml_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","We'e waifei i ve'anita'idi inageye fwayafwaya 'atumaina 'waineye 'ana nuanua, bani'odi tomotoga Yaubada yana Vona i nogai, taunidi i tauyedi 'waineye mulieta yadi folova Yaubada faifaina bani'odi i vuaga, 'ifwaidi 30, 'ifwaidi 60 wata 'ifwaidi 100.” ");
INSERT INTO yml_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu i velutoliedi i vo, Lovane mageta ta na kabuni, mulieta bani'odi ta na munegi? 'Aivoeyega ta na talafwaseni 'alo talalia dibuneye ta na yatoi? Kebu, mageta ta na lutalauleni bega i na magemagetai. ");
INSERT INTO yml_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wata bani'odi, ava'ai tomotoga i givediga, 'awaie naninidi matatabuna Yaubada i na sivemagesedi, wata ava'ai i nuagivediga Yaubada i na lu'ivoneyedi i na vemageta. ");
INSERT INTO yml_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Veifufu de'e 'wa nogaiga, 'wa na venua'ivineni nika 'wa na 'asetai. ");
INSERT INTO yml_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ava'ai 'wa na nogaiga 'wa na nuamagetai, nika Yaubada i na 'imoso'ieni. ");
INSERT INTO yml_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Egavo yaku ve i na vinenegeni wata i na venua'ivineni, yadi 'aseta Yaubada i na 'imoso'ieni bega yadi 'aseta i na vebwaika, we'e egavo kebu i da nogaya-dewai yadi 'aseta siaina Yaubada i na eloi.” ");
INSERT INTO yml_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yaubada yana veimea tomotoga 'waidie yana vebwaika faifaina Iesu i vona-awatabai i vo, Yaubada yana veimea bani'odi tamu tomogo waifei i bakulidi. ");
INSERT INTO yml_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tofolovanina 'aiaseye i folofolova, lovane i 'eno'eno we'e waifei yadi tabo wata yadi vebwaika kebu i da 'asetadiga. ");
INSERT INTO yml_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Fwayafwaya taunina 'ani'ani i 'ivetabodi, nagami i tautaula mulieta 'ani'aninidi i sousouyedi. ");
INSERT INTO yml_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tutuyanina i luludabadaba i 'a'aiala fai tutuya kumaga.” ");
INSERT INTO yml_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wata Iesu i vona-awatabai i vo, Bani'odi ta na voneyedi Yaubada yana veimea yana vebwaika faifaina 'alo ava'ai 'wainega ta na awatalatutula? ");
INSERT INTO yml_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Yana vebwaika bani'odi 'ayawana, bilana siaina siwe tutuyanina i vebwaika nika welavi bwaikaotogina bega manuga i mimaia didineye 'waineye i veve'i'wa'u wata i na vevegiuva.” ");
INSERT INTO yml_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Iesu i lau'age tomotoga 'waidie vona-awatabai fuedi 'waidiega bega 'adi fata i na 'aseta. Kebu tamu tutuya vona-awatabai i da baileni, siwe yana tovetutuyamavo taiadi 'aisedie naninidi matatabuna i kikiavemagetadi. ");
INSERT INTO yml_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","'Akonadi i lavia, Iesu yana tovetutuyamavo i vonedi i vo, Ta na damana lavu vi'ainega.” ");
INSERT INTO yml_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iesu yana tovetutuyamavo taiadi wakeye i dodoga i nagoi 'aila'a i 'iawedi, siwe waka 'ifwaidi taiadi i nagoi. ");
INSERT INTO yml_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","I nunagoi nika kaukau toketokena i nunuga yagina waka i ludododogi sai'afoga i da veadagi. ");
INSERT INTO yml_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu i 'unugalo i 'eno'eno waka mulineye. Tovetutuyamavo i luvagoni i vo, Tove 'u tovoi, i na vileda ta na wafa, siwe voke kebu faifaina 'u da nuanuaga.” ");
INSERT INTO yml_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesu i tovoi kaukau i talabodeni wata yagina i voneni i vo, 'U niwalova,” nika kaukau i 'awatagoni i niwalova bwaikina. ");
INSERT INTO yml_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iesu yana tovetutuyamavo i vonedi i vo, Awale 'wa kololo? 'Omi bola kebu 'wa da vetumaganeku.” ");
INSERT INTO yml_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tovetutuyamavo 'akonadi kaukau wata yagina yadi 'ailove i 'isedi i kololo-'afo'afo Iesu yana toketokena faifaina. Bega 'aise'avadi i veifufu i vo, Ava'ai tomotogaga de'e? Nani matatabuna, kaukau wata yagina taiadi bonana i nogai i vematayakeyakeni.” ");
INSERT INTO yml_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu ma enavo i maia lavu vi'ainega me Gelasine yadi 'awalaweye. ");
INSERT INTO yml_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tutuyanina i le'wai, wakayega Iesu i obu tamu tomogo yaiaina i ageiga i veluagai, i mimai taumata 'waidiega. ");
INSERT INTO yml_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Tomogonina yana 'eba mia taumata 'awasasadie, tutuya fuedi tomotoga 'agena wata nimana i yogoyogonidi bulava kainumu 'waidiega siwe i sisidabadabadi. Kebu tamu aitoi i na vetoketoke bega i na 'ive'avini wata i na yogoni. ");
INSERT INTO yml_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","'Aiata lovana 'aitamogana 'aitamogana taumata 'awasasadie wata 'oyeye i vevebwaubwau taunina i nikenikei kileuyega. ");
INSERT INTO yml_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tomogonina 'ani'ieyega Iesu i 'isanaweni, i lilide i nago i lumata'afufu mataneye. ");
INSERT INTO yml_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Iesu yaiaina i voneni i vo, 'U 'awa'a'imu 'omu yaiaina sakoimu.” Yaiaina i vebwaubwau bonana bwaikinega i vo, Iesu, 'omu Yaubada Tabwaotogineye Natuna, ava'ai nuanuamu 'u na 'idewai 'waikuye? Yaubada 'ana wagavayega a velu'ui 'waimuye kebu 'u na 'ivekokoviku.” ");
INSERT INTO yml_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wata Iesu i velutolieni i vo, 'Omu aitoi 'amu wagava?” I vo, 'Aku wagava 'Aila'a, fai 'aku labilabina fuedi.” ");
INSERT INTO yml_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wata i toke i vevelu'ui 'waineye i vo, Kebu nuanuama 'u na veugeugema de'e 'awalawanina 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bawe fatala bwaikina 'oya lilivaneye i luluduaduala. ");
INSERT INTO yml_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yaiaina i taidaida Iesu 'waineye i vo, 'U da vetunema wata 'u da tauyema bawenidi 'a na agedi.” ");
INSERT INTO yml_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesu i tauyedi nika yaiaina i 'awa'a'idi i nagoi bawe i agedi. Bawenidi 2,000 fatala bwaikina, i ve'ilililide 'oyeamo i obu nika i sou bwagale i ve'alamonumonu lavuye. ");
INSERT INTO yml_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bawe 'adi to'isave'avinavo i 'iseni i lilide i nagoi i veifufuyeni 'atamana wata kweda 'waidie, bega tomotoga fuedi i nagoi i na 'iseni ava'ai i vonevoneyeni. ");
INSERT INTO yml_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tomotoganidi i maia Iesu 'waineye, tomogonina basenadi yaiaina fuedi i ageiga i 'iseni, 'akonadi yana nuanua i ve'atumai i ve'wesena ma 'ana talauma i miamia, nika tomotoga matatabudi i ve'alakolokololo. ");
INSERT INTO yml_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tomotoganidi matadie tomogo i ve'atumaiga wata bawe yadi monu, faifaidi tomotoga i le'wai 'waidie i veifufu. ");
INSERT INTO yml_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Begaidi 'atamananina 'ana tomotogavo Iesu i lukakadeni nuanuadi i na tauya yadi 'awalawa i na 'iaweni. ");
INSERT INTO yml_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mulieta Iesu i dododoga nika tomogonina yaiaina i ageiga i velu'ui-nuakalikali i vo, Iesu yau nuanuaku taiadi ta da nago.” ");
INSERT INTO yml_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Siwe Iesu i talabodeni i vo, 'Auvea i 'isanuakalikaliemu i 'ive'atumaimu, bega 'u na nago yamu 'aila'a 'waidie 'u na lu'ivona.” ");
INSERT INTO yml_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bega tomogo i nago naninidi matatabuna Iesu i 'idewadiga faifaidi i lu'ivona 'awalawa Dekafolisi matatabuna 'waineye. Tomotoga fuedi i nogai nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu ma enavo i vila-vaituganidi i damanama de'e bega lavu lilivaneye 'aila'a bwaikina i maia i sififineni. ");
INSERT INTO yml_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Me Diu yadi 'eba miava'auta 'ana to'edakumeta tamu, 'ana wagava Yailo Iesu i 'iseni i nago 'waineye ma yana ve'ililibu i lumata'afufu Iesu 'ageneye i velu'ui-nuakalikali i vo, Natuku vevinena sai'afoga yawaina i na 'a'ava. 'U da mai ta da nago nimamu 'u da yatoi 'waineye bega i na ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iesu Yailo taiadi i nunago wata 'aila'a bwaikina i vevetunufelagieni, nuanuadi Iesu i na yogo'waili. ");
INSERT INTO yml_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","'Aila'anina nagedie tamu vavine, vevine 'adi viga i 'ewadi, malamala 12 nagedie kebu i da 'a'ailove viganina i 'eno'eno. ");
INSERT INTO yml_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tutuya fuedi i nunago toawakweli fuedi 'waidie igodi i na ve'atumai siwe viganina i vebwaika kebu i da veve'atumai, we'e yadi kukua i ve'a'avadi fu'eyega. ");
INSERT INTO yml_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Iesu valana i nogai bega 'aila'a taiadi i nunagoi, yadi nuanua i vo, 'Ai'edi Iesu 'a na 'abitonoviga 'a na ve'atumai siwe wata 'ai'edi 'ana talauma'ava 'a na 'abitonovimo 'a 'asetai 'a na ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tutuyanina i 'abitonovi 'adi viga i 'a'ava i vebaedi 'akonadi i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nika Iesu i 'asetai yana toketokena i damana vavine 'waidie bega i sivilai i velutoli i vo, Aitoi 'aku talauma i 'abitonovi?” ");
INSERT INTO yml_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yana tovetutuyamavo i vo, 'U 'iseni, 'aila'a bwaikina i vetunufelagieni, awale 'u vo, Aitoi i 'abitonoviku?’” ");
INSERT INTO yml_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Siwe Iesu i 'i'isadaba nuanuana i na 'asetai aitoi i 'abitonovi. ");
INSERT INTO yml_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Vavine i 'asetai i lulualedi begaidi i kololo, ma yadi tatava wata ma yadi ve'ililibu i lumata'afufu Iesu 'ageneye i lu'ivona mogitana taunidi faifaidi. ");
INSERT INTO yml_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu i vonedi i vo, Natuku, yami vetumagana 'waikuye i 'ive'atumaimi. Ma yami sosoana 'wa na nago, 'ami viga i 'a'ava-vagata.” ");
INSERT INTO yml_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tutuyanina Iesu vavine 'waidie i vonavona 'ifwaidi tomotoga i le'wai Yailo yana vanugayega i voneni i vo, Natumu 'akonadi yawaina i 'a'ava. Kebu wata Tove 'u na vevekadia.” ");
INSERT INTO yml_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu i nogai Yailo i voneni i vo, Kebu bonadi 'u na nogaiga wata kebu nuafoumu i na veviga 'u na vetumaganamo.” ");
INSERT INTO yml_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Fuedi i talabodedi tomotoga 'adi 'aitonu taiadi i nagoi, Fita, Iemesa wata taina Ioni. ");
INSERT INTO yml_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tutuyanina i le'wai Yailo yana vanuge, Iesu 'aila'a i 'isedi wata vemogai bwaikina. ");
INSERT INTO yml_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bega i luku vanuga nageneye i velutoliedi i vo, Awale 'wa vevemogai? Kwamana de'e kebu i da wafaga, i 'eno'enomo.” ");
INSERT INTO yml_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","'Aila'a Iesu i sidibidibieni wata i namageni fai i 'asetai kwamananina mogitana i wafa. Iesu i vonedi matatabudi i souyedi, mulieta enavonidi, kwamana tamana wata inana taiadi i luku kwamananina yana tutudaba 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","42","Kwamana nimaneye i 'abi bonanega i voneni i vo, Talaida kumi,”'ana saivila i vo, Kwamana, 'u tovoi,” nika i tovoi i yaba. Kwamananina 'ana malamala 12. Tomotoga i 'iseni nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesu i talabodedi i vo, Kebu 'wa na lu'ivonaga siwe 'ani'ani 'wa na veleni i na 'ani.” ");
INSERT INTO yml_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu Yailo yana 'atamana i 'iaweni yana tovetutuyamavo taiadi i nagoi yana 'atamana Nasaledi 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Bei i miamiani 'Aiata Veawai i veluagai i velamu i ve 'eba miava'auta 'waineye. Tomotoga fuedi yana vona i nogai nuadi i voganidi i vo, Tomogo no'o ta 'asetai kumanina to'aiyogona, inana Meli, tainavo Iemesa, Iosese, Iudasa wata Saimoni we'e novunavo taiadi ta miamiani. Siwe yana nuamageta wata yana toketokena ava'aiega i veluagadi bega 'eba nuavogana wata 'eba nua'ewa i 'i'idewadi?” Faifainanina i vedumwe'ai'aieni kebu i da vetumaganeni. ");
INSERT INTO yml_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Bega Iesu i vonedi i vo, Yaubada yana tolu'ivonavo ma 'adi ve'ililibu tomotoga tulidi 'waidie, we'e taunidi yadi 'atamana 'ana tomotogavo wata yana 'aila'a kebu.” ");
INSERT INTO yml_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Begaidi Iesu nuana i vogani yana 'atamana 'ana tomotoga kebu i da vetumaganeni. Begaidi kebu 'ana fata 'eba nuavogana wata 'eba nua'ewa i da 'i'idewadiga siwe 'ifwaidi tomotoga Iesu i 'abitonovidi 'adi viga i 'a'ava i ve'atumai. Iesu i nago i veve 'atamana 'aitamogana 'aitamogana 'waidiamo. ");
INSERT INTO yml_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mulieta yana tovetutuyamavo 'adi 12 i goleva'augidi bega 'ailuga 'ailuga i vetunedi, wata veimea i veledi bega yaiaina i na vonedi i na 'awa'a'idi. ");
INSERT INTO yml_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Iesu i velu'ase'asedi i vo, Yami wautogana wata 'ami 'ageyafayafa 'wa na 'ewadi we'e kebu tamu ava'ai 'wa na 'ewadi. 'Ani'ani kebu, venuana kebu, mani kebu wata kebu tamu talauma vunavunagina 'wa na 'ewai. ");
INSERT INTO yml_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tutuyanina 'wa na nagoi tamu 'atamana 'waineye, 'ai'edi aitoi i na vonemi 'wa na luku yana vanuge, bei 'wa na miamia mulieta yami folova i na 'a'ava 'atamananina 'waineye, vanuganina 'wa na 'iaweni. ");
INSERT INTO yml_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Ai'edi ava'ai 'atamanaga 'ana tomotoga kebu i na lu'uma'umaiemiga wata yami vona kebu i na nogaidiga, 'wa na 'iawedi. Tutuyanina 'wa na tauya, 'agemiega fwayafwaya 'wa na lubutubutuya, yadi 'eba 'isa 'wainega i na 'asetai 'awaie vematavuloga i na veluagai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bega tovetutuyamavo i nagoi i lalau'age i vo, 'Wa na nuavilami yami sakona 'wa na vedumwe'ubu'ubusedi.” ");
INSERT INTO yml_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wata yaiaina tomotoga i agediga i veugeugedi i souyedi, we'e toviga fuedi i iwagidi bunamayega nika i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tutuyanina 'waineye 'awalawa Isileli nageneye Loma kabemani yadi to'edakumeta bwaikina 'ana wagava Kini Elodi. Iesu yana folova toketokena valana i nogai fai tomotoga fuedi i veveifufu faifaina. 'Ifwaidi i vo, No'o Iesu, 'asa'aiana mogitana taunina Ioni Tobafitaiso, i yawasa-vaitugana begaidi 'eba nuavogana wata 'eba nua'ewa i 'i'idewadi.” ");
INSERT INTO yml_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tomotoga 'ifwaidi i vo, Taunina Ilaitia, Yaubada yana tolu'ivona abamayega i mai,” we'e 'ifwaidi i vo, Taunina tamu Yaubada yana tolu'ivona fai yana sauluva tolu'ivonanidi basenadi bani'odi.” ");
INSERT INTO yml_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","We'e Kini Elodi Iesu valana i nogai i vo, Mogitana Ioni Tobafitaiso, basenadi 'odona a boboi i yawasa.” ");
INSERT INTO yml_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bani'odi i voneyediga fai basenadi yana veimea 'wainega Ioni i yogoni i yatoi vanuga yogona nageneye. We'e Elodi taina Filifi yana vavine Elodiasa i luobuyedi mulieta i nagidi. ");
INSERT INTO yml_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Begaidi Ioni i tolimatani i vo, 'U vekali, taimu yana vavine 'u nagidi, Yaubada yana veimea 'u geuya.” ");
INSERT INTO yml_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Elodiasa i nuasako nuanuadi Ioni i da wafa siwe kebu 'adi fataga. ");
INSERT INTO yml_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","We'e Elodi ma yana kololo Ioni i 'ita'ita'ieni fai i 'asetai tomogo 'atumaina yana sauluva tonovina Yaubada mataneye. Nuanuana Ioni yana veifufu i na vivinenegeni, siwe i venuafouviga vonanidi faifaidi. ");
INSERT INTO yml_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mulieta Elodiasa tamu 'eda i veluagai bega 'adi fata Ioni i na nikei. Elodi yana tubuga 'ana 'aiata 'waineye sakali bwaikina i 'idewai. Tomotoga ma 'adi wagava i goledi i maia sakalinina 'waineye, 'ifwaidi kabemani, 'ifwaidi tolugavia yadi to'edakumetavo wata 'ifwaidi toveimea 'awalawa Galili 'wainega. ");
INSERT INTO yml_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sakalinina 'waineye Elodiasa natudi vevinena i mai i kayama matadie bega Elodi wata 'ana wakawakavo taiadi i 'ivesosoanidi. Elodi vavine i voneni i vo, 'Ai'edi ava'ai nuanuamu 'u na velu'uieku 'ana fata a na velemu. ");
INSERT INTO yml_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A vona'awaufaufa 'waimuye 'ai'edi ava'ai nuanuamu a na velemu, 'ai'edi 'u na vo, Yamu 'eba veimea sai'afo 'u na veleku,’ 'aku fata a na velemu.” ");
INSERT INTO yml_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bega vavinenina i nago inana 'waidie i velutoli i vo, Ava'ai a na velu'uieni?” Inana i vo, Nuanuama Ioni Tobafitaiso i na wafa bega 'u na voneni 'unu'ununa i na velemu.” ");
INSERT INTO yml_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Vavine i vila-matayo'oi Elodi 'waineye i vo, Nuanuaku 'asiauotoga Ioni Tobafitaiso i na wafa, 'unu'ununa 'aivoeye 'u na dodogi 'u na mieni 'waikuye.” ");
INSERT INTO yml_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Vonanina i nogai nuana i vita bwaikina siwe kebu 'ana fata i na bailaga fai i vona'awaufaufa 'ana wakawakavo matadie. ");
INSERT INTO yml_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Bega Elodi tamu tolugavia i vetunei i nago vanuga yogona nageneye Ioni 'odona i boboi, 'aivoeye i dodogi i mieni vavine i veleni. I 'ewai i nago inana i veledi. ");
INSERT INTO yml_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tutuyanina Ioni yana tovetutuyamavo valana i nogai, i maia tomogona i 'ewai matumatuye i silukuveni. ");
INSERT INTO yml_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tutuyanina tomata'aulele i viladi Iesu 'waineye i lu'ivona yadi ve wata ava'ai i 'idewadiga faifaidi. ");
INSERT INTO yml_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Fai 'aila'a bwaikaotogina i mimaia wata i nunagoi, Iesu wata yana tovetutuyamavo kebu tamu 'awasasa 'waidie bega i na veawai wata i na 'ani. Faifainanina Iesu i vo, Ta na nagoi tulideye, tamu 'awasasa kebu tomotoginaga 'waineye, ta na veawai.” ");
INSERT INTO yml_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bega wakayega tulidie i nagoi ava'aibe bei kebu tamu aitoi i da miamia 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Siwe tomotoga fuedi Iesu ma enavo yadi tauya i 'asetai wata 'akonadi i 'isedi, begaidi 'agediamo i bala 'atamana 'aitamogana 'aitamogana 'waidiamo nagami i le'wai ava'aibe bei Iesu i nunagoga 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tutuyanina Iesu ma enavo i duduna 'aila'a bwaikina i 'isedi, i 'isanuakalikaliedi fai 'wa da vo bani'odi sifi kebu 'adi to'isave'avinaga. Begaidi i velamu nani fuedi faifaidi i ve 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","'Akonadi i lavia yana tovetutuyamavo i maia Iesu i voneni i vo, De'e bei 'atamana kebu wata 'akonadi tutuya i ve'ale'usa. ");
INSERT INTO yml_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tomotoga 'u na vetunedi i na nagoi taunidi 'adi'adi i na kimwane 'atamana wata kweda 'waidie.” ");
INSERT INTO yml_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iesu i vonedi i vo, 'Omi taunimi 'ai'edi ava'ai 'wa veledi i na 'ani.” Tovetutuyamavo i vo, Vetuma nuanuamu 'a na nago 'ani'ani bwaikaotogina bani'odi 'ana tutula lubulubu 200 'a na 'ewadi.” ");
INSERT INTO yml_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesu i velutoliedi i vo, 'Aivia 'ani'ani 'waimie? Nika 'wa nagoi 'wa 'isa.”'Akonadi i 'iseni i maia i voneni i vo, 'Ani'ani mwadodoudi 5 wata igana 'ailuga 'a veluagadi.” ");
INSERT INTO yml_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bega Iesu yana tovetutuyamavo i vonedi i vo, Tomotoga 'wa na vonedi i na veiwakukuna mosomoso 'waidie.” ");
INSERT INTO yml_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","I veiwakukuna, kukuna 'ifwaidi bani'odi tomotoga 100, 'ifwaidi bani'odi 50. ");
INSERT INTO yml_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iesu 'ani'ani i 'ewai i 'isalaka abame, Yaubada 'waineye i vekaiwa, i 'a'avana mwadodoudi i 'ewadi i 'ivividi. Yana tovetutuyamavo i veledi tomotoga 'aitamogana 'aitamogana i veutadi. Wata igana bani'odi. ");
INSERT INTO yml_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Matatabudi i 'ani kamodi i aidi. ");
INSERT INTO yml_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tovetutuyamavo tomotoga nikilidi i va'augidi bayawa 12 i veadagidi. ");
INSERT INTO yml_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","'Aila'anidi i 'aniga iaveta tulai'avadi 5,000, we'e vevine wata kwakwama kebu i da lu'iawawadiga. ");
INSERT INTO yml_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tomotoga i ve'anidi i 'a'avana, Iesu yana tovetutuyamavo i lukakadedi i vo, 'Wa na dodoga wakeye 'wa na kumeta 'wa na nagoi Bedasaida, yau 'aila'a a na vonedi i na nagoi.” ");
INSERT INTO yml_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tomotoga i tauya i nunagoi Iesu i laka 'oyeye bei i velu'ui. ");
INSERT INTO yml_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","'Akonadi i laviotogi we'e waka lavu kamwaneye Iesu 'aiseotogina 'avale. ");
INSERT INTO yml_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","50","Yana tovetutuyamavo i 'isedi vita bwaikaotogina nageneye ma yadi tokemaiga i voivoi fai kaukau i veveviladi. Sai'afoga tutuya i na kililia nika Iesu i le'wa lilivadiamo i nago ufa tabwaneamo. Tutuyanina Iesu i nunago 'waidie fuedi i 'isanaweni ma yadi kololo i 'we'weleni i vo, Yalua.” Nika Iesu i vona-matayo'o 'waidie i vo, Kebu 'wa na kolologa, yau taunida.” ");
INSERT INTO yml_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","I nago i dodoga wakeye yana tovetutuyamavo 'waidie nika kaukau i 'awatagoni. We'e tovetutuyamavo nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bagase Iesu 'aila'a bwaikina i ve'anidi yana tovetutuyamavo nuadi kebu i da magetadi yana toketokena faifaina. Wata Iesu i 'iseni ufa tabwaneamo i mimai, nuadi i voganidi, bola kebu i da 'asetaiga. ");
INSERT INTO yml_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","I duduna Genesaleta balebaleye bei yadi waka i lomuyeni. ");
INSERT INTO yml_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tutuyanina wakayega i obuobu tomotoga fuedi Iesu i 'isa'inanai. ");
INSERT INTO yml_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tomotoganidi i lilide i nagoi 'awalawanina matatabuna 'waineye yadi toviga i miedi ava'aibe bei Iesu i miamia 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesu i nago 'atamana siaidi, bwaikidi wata kweda 'waidie, tomotoga yadi toviga i miedi 'atamanafouye i yatodi i velu'ui 'waineye nuanuadi i na 'abitonovidi we'e 'ai'edi kebu, 'ana talauma mataifwa'avana i na 'abitonovi. Egavo i 'abitonovaga matatabudi i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tamu 'aiata 'waineye Diu totafalolo Falisi wata ve'etoboda 'adi tovevo 'ifwaidi Ielusalemayega i mai nuanuadi Iesu i na 'iseni. ");
INSERT INTO yml_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yana tovetutuyamavo i 'isedi i 'ani'animo, nimadi kebu i da 'ivevunavunagidi yadi ve'etoboda bani'odi. ");
INSERT INTO yml_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kumanidiavo me Diu, we'e mogitana Falisi, ve'etoboda i mai tubudiavo 'waidiega i veve'ililibuyedi, nimadi i na 'ivevunavunagidi yadi sauluva bani'odi mulieta i na 'ani. ");
INSERT INTO yml_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wata bani'odi 'ai'edi 'eba sivedavedamana 'wainega i na maia, nagami nimadi i na 'ivevunavunagidi mulieta i na 'ani. Wata 'ifwaidi ve'etoboda tubudiavo 'waidiega i mai i veve'ililibuyedi, bani'odi nau, vedi, 'aivoe wata sita i na 'ivevunavunagidi. ");
INSERT INTO yml_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Begaidi Falisi wata ve'etoboda 'adi tovevo Iesu i velutolieni i vo, Awave'eda'eda i maiga tubudavo 'waidiega, awale yamu tovetutuyamavo kebu i da ve'ililibuyediga i geugeudi? 'Ani 'ana tutuya 'waineye kebu nimadi i da 'ivevunavunagidi we'e i 'ani'animo.” ");
INSERT INTO yml_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu i vonedi i vo, 'Omi tovekali. 'Awami nani fuedi faifaidi i tatalaboda we'e wata 'wa 'i'idewadi. Basenadiotoga Yaubada yana tolu'ivona Aisea Yaubada yana Vona 'wainega i vona-samula faifaimi. I vonaga mogitana i vo, De'e 'aila'anidi 'awakebuladiega i ve'ililibuyeku, siwe kebu mogitana i da nuakalikalieku. ");
INSERT INTO yml_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Fai tomotoga yadi nuanua i veve igodina Yaubada 'wainega, begaidi 'waikuye i 'o'odu-maimaiga.’” ");
INSERT INTO yml_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Wata Iesu i vo, Aisea i kilumi mogitana, Yaubada yana veimea 'wa bailedi we'e tomotoga yadi ve 'wa vevematayakeyakedi.” ");
INSERT INTO yml_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wata i vonedi i vo, Yaubada yana veimea 'wa baibailedi, ma'itufa taunimi yami ve'etoboda 'wa vematayakeyakedi. ");
INSERT INTO yml_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Basenadiotoga Yaubada yana veimea Mosese i veleda i vo, Tamamu wata inamu 'u na ve'ililibuyedi.’ Wata i vo, 'Ai'edi aitoi tamana 'alo inana i na awavesakoyedi bega vita i na veluagai, i lubwaineni 'wa na luvewafai.’ ");
INSERT INTO yml_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Veimeanidi 'wa geugeudi fai 'wa veve 'wa vo, 'Ai'edi aitoi ma yana mani, siwe kebu nuanuana tamana wata inana i na 'ivaisediga, 'omi 'wa tauyeni bega i na vonedimo i na vo, Mani de'e a na 'aniveleneni Yaubada faifaina,”’ vonanina 'wa fali'atumaieni. We'e mogitana i lubwaineni tamana wata inana i da ve'ililibuyedi, maninina 'wainega i da 'ivaisedi. ");
INSERT INTO yml_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","De'e bani'odi Yaubada yana Vona 'wa venani-'avo'avovoyeni, ma'itufa ve'etoboda tubumiavo 'waidiega 'wa vevematayakeyakedi. Wata nani fuedi bani'odi 'wa 'i'idewadi.” ");
INSERT INTO yml_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu tomotoga i goledi i nagoi 'waineye i vonedi i vo, A na vonemiga 'wa na venua'ivineni nika 'wa na 'asetai. ");
INSERT INTO yml_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tamu ava'ai i na luku tomotoga nagedie, kebu 'ana fata tomotoganidi i na 'iveyokedi. We'e mogitana vona 'alo nuanua sakoidi tomotoga 'waidiega i na souyediga, naninidi tomotoga i na 'iveyokedi. ");
INSERT INTO yml_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Veifufu de'e 'wa nogaiga, 'wa na venua'ivineni nika 'wa na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesu tomotoga i 'iawedi i nago vanuge, mulieta yana tovetutuyamavo i velutolieni yana ve faifaina. ");
INSERT INTO yml_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Iesu i vonedi i vo, 'Omi bola kebu ma yami 'asetaga. 'Wa da 'asetai 'ai'edi 'ani'ani ta na 'ania kebu 'ana fata i na 'ivesakoida, fai kebu i na nago yada nuanua 'waidie, kamodeye i na luku bega yogo yana 'edeye i na nago.” Iesu bani'odi i veifufuyediga 'ani'ani matatabuna i awave'atumaiedi, kebu tamu sakona 'wainega i na souyeni. ");
INSERT INTO yml_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wata i vo, Ava'ai tomotoga nagediega i na souyediga, naninidi tomotoga i na 'iveyokedi. ");
INSERT INTO yml_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tomotoga nagediega nuanua sakoidi i sousouyedi bega i vevesauluva sakoina bani'odi ve'avula-'avo'avovo, vainago, luvewafa wata lauobu. ");
INSERT INTO yml_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Wata 'ifwaidi sauluva sakoidi bani'odi veumokai, veviga 'ana tolive'eda, vekali, sakona 'ana vebaisa, ve'unumagigi, vebonaivo, taunidi i na nualaka wata venua'ivina-sako. ");
INSERT INTO yml_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Naninidi i sousouyedi tomotoga nagediega, bega kumanidiavo i 'i'iveyokedi.” ");
INSERT INTO yml_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mulieta 'atamananina Iesu i 'iaweni i nago tamu 'awalawa 'waineye, 'atamana Taia lilivaneye. I le'wa i luku vanuge, kebu nuanuana tomotoga i na 'asetai yana 'eba mia fai nuanuana i na veawai, siwe kebu 'ana sala i na giva. ");
INSERT INTO yml_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","We'e tamu vavine natudi vevinena yaiaina sakoina i ageiga, Iesu valana i nogai i mai ma yadi ve'ililibu i 'odu 'ageneye. ");
INSERT INTO yml_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Vavinenidi kebu vavine Isileliga, taunidi i tubuga 'atamana Finisia 'awalawa Silia nageneye, siwe Iesu i velu'uieni nuanuaotogidi natudi i na 'ive'atumaia. ");
INSERT INTO yml_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iesu vavine i vonedi i vo, Nagami kwakwama a na ve'anidi. Kebu i da lubwaineku kwakwama 'adi'adi a na elodi a na 'anivelenedi 'ou'ou 'waidie.” ");
INSERT INTO yml_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Vavine i 'asetai Iesu i veveifufu nagami i na folova taunina yana 'aila'a Diu 'waidie, begaidi i voneni i vo, 'Auvea, we'e mogitana. Siwe tutuyanina kwakwama i na 'ani'ani, 'ou'ou siaidi mukumuku i na luluyamuyamu. Begaidi sai'afo 'u da 'ivaisema.” ");
INSERT INTO yml_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iesu i vonedi i vo, Fai yami vona 'ana nogaya 'atumaina 'wa na nago, natumi 'akonadi yaiaina i 'awa'a'ia i ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tutuyanina i le'wa yadi vanuge, natudi i 'iseni 'ivie i 'eno'eno 'akonadi i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu i tauya Taia 'wainega i nago 'atamana Saidoni, bega 'awalawa Dekafolisi 'waidiamo i nago i le'wa Lavu Galili. ");
INSERT INTO yml_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tomotoga 'ifwaidi tamu toviga i mieni Iesu 'waineye i velu'ui nuanuadi nimana i na yatoi iadi 'waineye bega i na ve'atumai. Toviganina tanigana 'uluna wata meana tafilina. ");
INSERT INTO yml_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu tomogo 'aila'a 'waidiega i 'ewai 'aiseneye i naweni nimadidina i 'etouyedi tomogonina tanigana 'waidie wata nimaneye i kiwala bega tomogo meana i 'abitonovi. ");
INSERT INTO yml_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Abame i 'isalaka i veyawaitunatunagi bonanega i vona i vo, Efada,”'ana saivila i vo, 'Wa 'ani'inimi.” ");
INSERT INTO yml_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yana voneye tomogo tanigana i 'ani'inidi wata meana i tonova nika i welava. ");
INSERT INTO yml_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Wata i viladi i mai 'aila'a 'waidie Iesu i velu'ase'asedi kebu i na lu'ivona tomogo i 'ive'atumaiaga faifaina, siwe fuedi i lu'ivo'ivona. ");
INSERT INTO yml_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Egavo i 'iseni nuadi i voganidi bwaikina i vo, Nani i 'i'idewadiga 'atumai'avadi. 'Eba nuavogana wata 'eba nua'ewa i 'i'idewadi siwe wata tomotoga tanigadi i kia'inidi i nogaya wata meadi i kiavetonovidi i welava.” ");
INSERT INTO yml_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Tomogo i 'ive'atumaia i 'a'avana, tamu 'aiata 'waineye wata 'aila'a bwaikina i va'auta. 'Adi'adi kebu, begaidi Iesu yana tovetutuyamavo i goledi i nagoi 'waineye i vonedi i vo, Tomotoga de'e faifaidi a nuavita fai 'akonadi 'aiata 'aitonu taiadi ta miamiani siwe kebu 'adi'adiga. ");
INSERT INTO yml_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","'Ai'edi ma 'adi lase a na vetunedi yadi 'atamane bola 'edeye laseyega i na mwea fai 'ifwaidi 'ani'ieyega i maia.” ");
INSERT INTO yml_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yana tovetutuyamavo i vo, De'e kebu tomotoginaga, kebu tamu aitoi 'ana fata 'ani'ani i na veluagai bega 'aila'a de'e ta na ve'anidi.” ");
INSERT INTO yml_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iesu yana tovetutuyamavo i velutoliedi i vo, 'Aivia 'ani'ani 'waimie?” I vo, 'Ani'ani mwadodoudi 7 'waimeye.” ");
INSERT INTO yml_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iesu 'aila'a i vonedi fwayefwayeye i vemiamiabui. Mulieta 'ani'aninidi 7 i 'ewadi, i vekaiwa Yaubada 'waineye, i 'a'avana i 'ivividi bega yana tovetutuyamavo i veledi 'aila'a i veutadi. ");
INSERT INTO yml_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wata 'adi igana siaidi 'ifwaidi faifaidi Iesu i vekaiwa i 'a'avana yana tovetutuyamavo i veledi wata bani'odi tomotoga i veutadi. ");
INSERT INTO yml_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Matatabudi i 'ani, 'adi fata, mulieta yana tovetutuyamavo tomotoga nikilidi i va'augidi, bayawa bwaikidi 7 i veadagidi. ");
INSERT INTO yml_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mulieta Iesu tomotoga i vonedi i nagoi yadi vanuge. To'aninidi iaveta tulai'avadi i lu'iawawadi 'adi 'aila'a bani'odi 4,000, we'e vevine tulaidi wata yavayavava kebu taiadi i da lu'iawawadiga. ");
INSERT INTO yml_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","We'e Iesu ma yana tovetutuyamavo i dodoga wakeye i nagoi 'awalawa Dalimanuda 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Diu totafalolo Falisi 'ifwaidi i maia Iesu 'waineye taiadi i ve'ikwayekwayega. Nuanuadi i na silubuya bega i vo, Nuanuama tamu 'eba nuavogana wata 'eba nua'ewa 'u na 'idewai bega 'a na 'asetamu ma yamu veimea Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu i veyawaitunatunagi i vonedi i vo, 'Omi tutuya de'e 'ana tomotoga, awale nuanuami 'eba nuavogana wata 'eba nua'ewa a na 'idewai? Kebu, a vona mogitana 'waimie, kebu tamu 'eba 'isa a na 'idewai 'omi 'aila'animi 'waimie.” ");
INSERT INTO yml_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bega i 'iawedi yana tovetutuyamavo taiadi i dodoga wakeye i damana lavu vi'ainega. ");
INSERT INTO yml_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tovetutuyamavo nuadi i fani kebu tamu 'ani'ani i da 'ewai, we'e wakeye beledi 'aitamogana. ");
INSERT INTO yml_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu vona-awatabaiega i velu'ase'asedi bega tomotoga sakoidi yadi sauluva kebu i na tunuvedamanidi i vo, Taunimi 'wa na 'i'isave'avinimi i na nunago totafalolo Falisi yadi isita wata Kini Elodi yana isita i na vedamanimi i na 'ivesakoimi.” ");
INSERT INTO yml_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","'Aise'avadi i veifufu i vo, Isita beledi 'ana 'eba 'ivebwaika, bani'odi i voneyediga fai 'ida beledi kebu ta da 'ewadiga.” ");
INSERT INTO yml_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yadi vonanina Iesu 'akonadi i 'asetai begaidi i vo, Awale 'wa ve'ivonavona 'ani'ani kebu ta da 'ewadiga faifaina? We'e nuami tabodadi. Voke yami nuanua bola kebu i da magetaiga wata kebu 'wa da 'asetai. ");
INSERT INTO yml_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ma matami siwe kebu 'wa da 'iseni wata ma tanigami siwe kebu 'wa da nogai. Yau ma yaku toketokena we'e voke nuami i fani. ");
INSERT INTO yml_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tutuyanina 'ani'ani 5 a 'ivividi tomotoga 5,000 faifaidi, nikila 'wa va'augidiga 'aivia bayawa 'wa veadagidi?” I tutula i vo, 'Adi 12.” ");
INSERT INTO yml_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wata i vo, 'Ani'ani 7 a 'ivividi tomotoga 4,000 faifaidi, 'aivia bayawa 'wa veadagidi nikilayega?” Tovetutuyamavo i vo, 'Adi 7.” ");
INSERT INTO yml_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Iesu i vo, 'Omi bola kebu 'wa da 'asetaiga.” ");
INSERT INTO yml_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesu ma yana tovetutuyamavo i maia Bedasaida, tamu tomatasako i mieni 'waineye, i velu'ui nuanuadi i na 'abitonovi bega i na ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iesu tomogo nimaneye i 'abi 'atamanayega i naweni tulineye. Mulieta Iesu tomogo matana i kiwalidi i 'a'avana nimana i yatoi tomogoneye i voneni i vo, 'Amu sala ava'ai 'u na 'isedi?” ");
INSERT INTO yml_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tomogo 'i'isanago i vona i vo, Tomotoga a 'ise'isedi siwe 'adi 'isa 'wa da vo bani'odi welavi i da 'anigogogonidi.” ");
INSERT INTO yml_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iesu nimana i yato-vaitugani tomogonina mataneye nika matana i ve'atumai i 'isadewa. ");
INSERT INTO yml_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu i voneni bega i na nago yana vanuge wata i vo, Kebu 'u na lu'ivona 'atamane.” ");
INSERT INTO yml_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mulieta Iesu ma yana tovetutuyamavo i tauya i nagoi 'atamana 'ifwaidi 'waidie, 'awalawa Sisalia Filifai nageneye. I nunagoi 'edeye i velutoliedi i vo, 'Wa da nogaiga tomotoga yadi nuanua yau aitoi?” ");
INSERT INTO yml_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tovetutuyamavo i vo, Tomotoga 'ifwaidi i vonaga 'omu Ioni Tobafitaiso wafayega i yawasa, 'ifwaidi i vonaga 'omu Ilaitia abamayega i obuma, we'e 'ifwaidi i vonaga 'omu tamu Yaubada yana tolu'ivona wafayega i tovoi.” ");
INSERT INTO yml_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iesu i vonedi i vo, We'e 'omi, 'wa da nuani yau aitoi?” Fita i vo, 'Omu Keliso, Yaubada 'ana Venua'ivina.” ");
INSERT INTO yml_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Bega Iesu yana tovetutuyamavo i talabodedi i vo, Kebu tamu aitoi 'waineye 'wa na lu'ivonaga yau Keliso, Yaubada 'ana Venua'ivina.” ");
INSERT INTO yml_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tutuyanina 'waineye Iesu i velamu i kiavemageta yana tovetutuyamavo 'waidie naninidi 'awaie i na souyediga 'waineye i vo, Yau a vetomotogaotoga i lubwaineku veviga fuedi a na veluagadi. Me Diu yada to'edakumeta 'au'auveadi, tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo i na vedumwe'ai'aieku mulieta i na luvewafaku siwe 'aiata 'ana vetonu 'waineye Yaubada i na sivetovoiku.” ");
INSERT INTO yml_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","De'e bani'odi Iesu i voneyediga i vonaotoga. Fita Iesu i voneni i vaganago 'aisedie, i toke i talabodebodeni i vo, Kebu bani'odi taunimu 'u na faliwafewafemu.” ");
INSERT INTO yml_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iesu i sivilai yana tovetutuyamavo i 'isedi bega Fita i talabodeni i vo, 'U vaganago, yamu nuanuananina Seitani yana nuanua. Wata tomia fwayafwaya yadi nuanua, kebu Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mulieta Iesu 'aila'a wata yana tovetutuyamavo i goledi i nagoi 'waineye i vonedi i vo, 'Ai'edi aitoi nuanuana mogitana i na mai 'waikuye taiadi 'a na nagoga, nagami taunina yana nuanua i na bailedi. Fai i na vematayakeyakeku veviga bwaikina i na veluagai yau bani'odi a na veluagai. Voke i na wafa faifaiku yau bani'odi a na wafa 'ai lagalagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","'Ai'edi aitoi yana mia 'ana 'atumaina i na ve'o'oleni, kebu nuanuana yawaina i na tauyeni faifaiku, taunina i na wafaotoga. We'e 'ai'edi aitoi yana mia 'ana 'atumaina wata yawaina i na tauyedi faifaiku wata Valaku 'Atumaina faifaina, mia 'atumaina wata miamia-vagaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","'Ai'edi tamu aitoi fwayafwaya matatabuna 'ana kukua i na 'ewadi mulieta yawaina i na 'a'ava, ava'ai 'ana 'atumaina? ");
INSERT INTO yml_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kebu 'ana fata tamu nani 'wainega yawaina i na kimwanei. ");
INSERT INTO yml_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","'Asiau tomotoganidi yadi sauluva sakoidi wata Yaubada i vedumwe'ai'aieni. We'e 'ai'edi aitoi yau faifaiku wata Valaku 'ana lu'ivona faifaina i na bunumayaga, yau a vetomotogaotoga yaku vila-vaitugana 'waineye wata a na bunumayageni. Yaku vila-vaitugana 'waineye, anelose magemagetadi taiadi 'a na maia, Tamaku yana mageta mataududulina nageneye.” ");
INSERT INTO yml_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wata Iesu i vo, A vona mogitana 'waimie, 'ifwaimi bola ma yawaimi 'wa na miamiani, nagami Yaubada yana veimea toketokena tomotoga 'waidie 'wa na 'iseni mulieta 'wa na wafa.” ");
INSERT INTO yml_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","'Aiata 6 i 'a'ava, mulieta Iesu yana tovetutuyamavo 'adi 'aitonu i vonedi Fita, Iemesa wata Ioni taiadi i laka 'oya bwaikina 'waineye. 'Aise'avadi i miamia Iesu i 'ise'iseni, nika 'ana 'isa i sivedamana. ");
INSERT INTO yml_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","'Ana talauma 'adi lau'avu mataududulidi, kebu tamu aitoi fwayefwayeye yana 'ilekoa bani'odi. ");
INSERT INTO yml_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","I 'ise'iseni nika tomotoga 'adi 'ailuga i souyedi Iesu taiadi i veveifufu. Tomotoganidi Ilaitia wata Mosese, taunidi basenadiotoga Yaubada yana tolu'ivonavo. ");
INSERT INTO yml_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nika Fita i vona-matayo'o Iesu 'waineye i vo, Tove, 'ima taiadi ta miamiani, nani 'atumaiotogina 'waimeye. 'Ai'edi 'u na tauyema lau'weta 'aitonu 'a na 'idewadi, tamu 'omu faifaimu, tamu Ilaitia faifaina wata tamu Mosese faifaina.” ");
INSERT INTO yml_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Fita kebu 'ana fata ava'ai i na voneyeni fai ma enavo i kololo bwaikina. ");
INSERT INTO yml_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Waowa i mai i umedi nika bona i nogai waowayega i vona i vo, De'e Natuku nuafouku, ava'ai i na voneyeniga, bonana 'wa na nogai.” ");
INSERT INTO yml_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","I vona'a'ava nika tovetutuyamavo i 'isadaba siwe kebu tamu aitoi i da 'iseniga, Iesu 'aise'avana. ");
INSERT INTO yml_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","'Oyayega i obuobuma Iesu i velu'ase'asedi i vo, Naninidi 'wa 'isediga, kebu tamu aitoi 'wa na voneniga, nagami yau a vetomotogaotoga wafayega a na tovoi, mulieta 'wa na lu'ivona.” ");
INSERT INTO yml_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iesu yana velu'ase'ase i ve'ililibuyeni, begaidi kebu tamu aitoi i da lu'ivona, siwe 'ifwaidi tutuya 'waidie 'aise'avadi i veveifufu i vo, Yawasa-vaitugana wafayega, ava'ai 'ana 'aseta?” ");
INSERT INTO yml_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mulieta yana tovetutuyamavo i velutolieni i vo, Awale ve'etoboda 'adi tovevo i vonaga i vo, Nagami Ilaitia i na mai, mulieta Yaubada 'ana Venua'ivina i na souyeni?’” ");
INSERT INTO yml_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu i vo, Ilaitia mogitana nagami i na mai Yaubada 'wainega, nani matatabuna i na 'ivenonogidi. We'e 'wa da nuani, Yaubada yana tolu'ivona basenadiotoga i kilumi yau a vetomotogaotoga faifaiku? I lubwaineni nagami veviga bwaikina a na veluagai wata tomotoga i na vedumwe'ai'aieku. ");
INSERT INTO yml_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","We'e a na vonemi, Ilaitia 'akonadi i mai siwe tomotoga kebu i da 'isa'inanaiga, begaidi vitanidi nuanuadi i na veleniga mogitana i veleni, bani'odi basenadiotoga Yaubada yana tolu'ivona i kilumi.” ");
INSERT INTO yml_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tutuyanina Iesu ma enavo i viladi 'oyayega, 'ifwaidi tovetutuyamavo i 'isedi i veve'ikwayekwayega ve'etoboda 'adi tovevo taiadi, we'e 'aila'a bwaikina i tovififinedi. ");
INSERT INTO yml_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tutuyanina 'aila'anidi Iesu i 'iseni nuadi i voganidi bega i lilide i nagoi nuanuadi taiadi i na veluaga. ");
INSERT INTO yml_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesu i velutoliedi i vo, Ava'ai faifaina 'wa veve'ikwayekwayega?” ");
INSERT INTO yml_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tamu tomogo 'aila'a nagediega i vo, Tove, natuku a mieni fai yaiaina i agei kebu 'ana fata i na welava. ");
INSERT INTO yml_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tutuyanina yaiaina i vevekadia i tawetaweni i obuobu tanotanoge, 'awanega buobuo, gagana i lovelovenedi wata tomogona i vevefatototo'ai'ai. Yamu tovetutuyamavo a velu'uiedi yaiaina i da veugeugeni, siwe kebu 'adi fata.” ");
INSERT INTO yml_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu tomotoga i vonedi i vo, Awale 'omi 'aila'animi Yaubada yana toketokena kebu 'wa da vetumaganeniga? Tutuya manamanawena taiadi ta miamia wata a totokemaigeku siwe kebu mogitana 'wa da vetumaganeku. Kwamananina 'wa mieni ta na 'iseni.” ");
INSERT INTO yml_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kwamana i mieni Iesu 'waineye, siwe tutuyanina yaiaina Iesu i 'iseni kwamana i vekadia i be'u i lui'oi'o'o 'awana buobuo i tubodai. ");
INSERT INTO yml_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Bega Iesu kwamana tamana i velutolieni i vo, Ava'ai tutuyaga bei i velamu?” Tamana i vo, Basenadi siaineye. ");
INSERT INTO yml_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yaiaina tutuya fuedi i vevekadia i be'ube'u 'aie wata ufeye, igodi kwamana i da luluvewafai. 'Ai'edi 'amu fata, 'u da 'isanuakalikaliema bega 'u da 'ivaisema.” ");
INSERT INTO yml_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu i vo, Awale 'u vo, 'Ai'edi 'amu fata?’ We'e egavo Yaubada i na vetumaganeni nani matatabuna safailidi 'waidie.” ");
INSERT INTO yml_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kwamana tamana i vo, Yau ma yaku vetumagana, siwe nuanuaku 'u na 'imoso'ieni.” ");
INSERT INTO yml_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu i 'isedi tomotoga fuedi i lilide i mimaia, yaiaina sakoina i ta'ali i vo, 'Omu kwamana 'awana 'u 'ibodai wata tanigana 'u 'ive'uluya a na vonemu. 'U 'awa'a'imu kebu wata 'u na age-vaitugani.” ");
INSERT INTO yml_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yaiaina i vebwaubwau wata kwamana i vekadia i tufa'o'oga nika i 'awa'a'ia. Kwamananina 'ana 'isa 'wa da vo i da wafa, fuedi i vo, Yawaina i 'a'ava.” ");
INSERT INTO yml_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nika Iesu kwamana nimaneye i 'abi i sivetovoia. ");
INSERT INTO yml_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mulieta i nagoi vanuge, 'aisedie yana tovetutuyamavo i velutolieni i vo, Awale 'ima 'a vona yaiaina kebu i da 'awa'a'iaga?” ");
INSERT INTO yml_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesu i vo, Naninidi bani'odi Yaubada 'waineye 'wa na velu'ui, 'ana fata yaiaina i na 'awa'a'ia.” ");
INSERT INTO yml_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Kwamana bei i 'ive'atumaiaga 'atamananina i 'iaweni i nagoi 'awalawa Galili 'waineamo. Iesu yana nago kebu nuanuana tamu aitoi i na 'asetai, fai i veve yana tovetutuyamavo 'waidie. I vonedi i vo, Yau a vetomotogaotoga tamu aitoi i na 'etogiluveku 'aku gaviavo 'waidie i na 'ive'aviniku. Bega mali tomotoga i na luvewafaku, mulieta 'aiata 'ana vetonu 'waineye a na yawasa-vaitugana.” ");
INSERT INTO yml_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iesu yana vonanina 'ana 'aseta kebu nuadi i da magetai, siwe i kololo kebu nuanuadi i na velutolieni. ");
INSERT INTO yml_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tutuyanina Iesu ma yana tovetutuyamavo i maia Kafaneomi i luku vanuge, mulieta i velutoliedi i vo, 'Edeye ava'ai faifaina 'wa ve'ikwayekwayega?” ");
INSERT INTO yml_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Siwe kebu nuanuadi i na lu'ivona fai i bunumayaga, we'e yadi ve'ikwayekwayeganina i vo, 'Waidega aitoi bwaikaotogina?” ");
INSERT INTO yml_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu i miabui mulieta yana tovetutuyamavo i goledi i nagoi 'waineye i vonedi i vo, 'Ai'edi aitoi nuanuana i na vetomogo-bwaika, nagami taunina i na kiaobuyeni bega i na vetofolova mali tomotoga 'waidie.” ");
INSERT INTO yml_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Mulieta Iesu tamu kwamana i mieni 'waidie i olia bega i vonedi i vo, 'Ai'edi aitoi ma yana nuakalikali tamu kwamana de'e bani'odi i na 'ivaiseni faifaiku siwe 'asa'aiana yau i 'ivaiseku. Wata 'ai'edi aitoi ma yana nuakalikali i na 'ivaiseku, siwe 'asa'aiana Yaubada taunina 'aku tovetune i 'ivaiseni.” ");
INSERT INTO yml_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioni Iesu i voneni i vo, Tove, tamu tomogo 'a 'iseni 'amu wagavayega i vonavona yaiaina i 'a'awa'a'idi, 'a talabodeni fai taunina kebu 'ada 'aila'a 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu i vo, Kebu 'wa na talabodeniga, aitoi 'aku wagavayega 'eba nuavogana wata 'eba nua'ewa i na 'i'idewadiga i lubwaineni, 'awaie kebu i na awavesakoyeku. ");
INSERT INTO yml_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","'Ai'edi aitoi kebu i na vedumwe'ai'aiedaga, ma fueda ta folofolova. ");
INSERT INTO yml_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","'Ai'edi aitoi 'aku wagavayega ufa i na velemi 'wa na yemu fai 'omi yau Keliso yaku tomotoga, a vona mogitana yana 'aivaitanina 'ana tutula bola i na veluagai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wata Iesu i vonedi i vo, 'Ai'edi aitoi i na vetumaganeku de'e kwamana bani'odi siwe tamu tomogo i na vetalaimimili i na sakonaga, bola tomogonina veviga bwaikaotogina i na veluagai Yaubada 'wainega. Siwe bola tomogonina kebu i da vetalaimimilaga, bei tomotoga 'ifwaidi kileu vitana i da yogona-matayo'oi 'odoneye i da taweni malaveseye, veviga siaina i da veluagai. I da wafa-matayo'oga i lubwaineni nika kebu i da vetalaimimilaga wata kebu veviga bwaikaotogina i da veluagai Yaubada 'wainega. ");
INSERT INTO yml_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","'Ai'edi sai'afoga 'u da sakona nimamu tamu 'wainega, 'u boboi bega kebu 'u na sakona. Mulieta nima'ea'eamu 'u na luku Yaubada 'waineye 'u na mia-vagata. We'e 'ai'edi kebu 'u na boboiga, nimamu 'ailugana 'waidiega 'u na sakosakona, mulieta 'u na wafa 'u na luku 'ai-'ala'alase kebu yana 'weuga 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","'Ai-'ala'alatanina kebu i na 'weuga, bei mwatamwata tomogomu i na 'e'etokudai. ");
INSERT INTO yml_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","'Ai'edi sai'afoga 'u da sakona 'agemu tamu 'wainega, 'u boboi bega kebu 'u na sakona. 'U na boboiga veviga sai'afo nika kebu 'u na sakonaga, mulieta 'agefa'ea'eamu 'u na luku Yaubada 'waineye 'u na mia-vagata. We'e 'ai'edi kebu 'u na boboiga, 'agemu 'ailugana 'waidiega 'u na sakosakona, mulieta 'u na wafa i na tawemu 'u na obu 'ai-'ala'alase. ");
INSERT INTO yml_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Bei mwatamwata tomogomu i na 'e'etokudai wata 'ai-'ala'alatanina kebu i na 'weuga. ");
INSERT INTO yml_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","'Ai'edi sai'afoga 'u da sakona matamu vi'ainega, 'u kiamwanuya bega kebu 'u na sakona. 'U na kiamwanuyaga veviga sai'afo, nika kebu 'u na sakonaga, mulieta 'amu fata 'aitamoganega 'u na luku Yaubada yana 'Eba Veimea nageneye. We'e 'ai'edi kebu 'u na kiamwanuyaga, matamu 'ailugana 'waidiega 'u na sakosakonaga mulieta 'u na wafa i na tawemu 'u na obu 'ai-'ala'alase. ");
INSERT INTO yml_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Bei mwatamwata tomogomu i na 'e'etokudai wata 'ai-'ala'alatanina kebu i na 'weuga.” ");
INSERT INTO yml_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wata Iesu i vona-awatabaiedi i vo, Yaubada tomotoga matatabuna i na sitonovidi 'ai-'ala'alata 'wainega. ");
INSERT INTO yml_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Eyaga 'eba 'ive'iwana, siwe 'ai'edi i na ve'ulaufa kebu 'ana fata i na vegola-vaitugana. Wata 'omi bani'odi, yami sauluva 'waidiega tomotoga yadi mia 'wa na 'ive'atumaidi wata ma fuemie 'wa na veveiana.” ");
INSERT INTO yml_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu ma enavo 'atamana Kafaneomi 'wainega i tauya i nagoi 'awalawa Iudia 'waineye, i damana Iolidani vi'ainega. Wata 'aila'a bei i maia Iesu 'waineye i ve 'waidie, bani'odi tutuya fuedi i veve. ");
INSERT INTO yml_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","'Ifwaidi Diu totafalolo Falisi nuanuadi tomotoga i na nuasako Iesu 'waineye begaidi i maia 'aila'a matadie i velutolieni i vo, Tomogo i lubwaineni yana vavine i na vesa'ilidi 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesu yadi velutoli i tutuli i vo, Basenadiotoga Mosese bani'odi i voneyedi bega vonanina i kilumi sa'ila faifaina?” ");
INSERT INTO yml_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Falisi i vo, Mosese i tauyeda tamu lubulubu 'waineye sa'ila 'ana vona ta na kilumi, vavine ta na veledi nika 'wainega ta na veugeugedi.” ");
INSERT INTO yml_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu i vonedi i vo, Mosese bani'odi i kilumiga fai sauluva 'atumaina 'wa baila. ");
INSERT INTO yml_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","We'e tutuya 'eba velamu 'waineye Yaubada tomotoga i 'idewadi, iavetana wata vevinena. ");
INSERT INTO yml_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Faifainanina 'ai'edi tomogo i na nagiga, 'akonadi i 'awa'idia tamana wata inana 'waidiega, yana vavine taiadi i luvetubama. ");
INSERT INTO yml_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","'Adi 'ailuga siwe 'wa da vo tomotoga 'aitamogana. Kebu 'ana fata ta na vo, 'Adi 'ailuga,’ fai taiadi i luvetubamaga ta na vo, 'Aitamogana.’ ");
INSERT INTO yml_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yaubada 'akonadi i luvetubamidi nika i ve'aitamoga, kebu 'adi 'ailuga, begaidi kebu i da lubwaineni tamu aitoi 'alo taunidi i na vemia'idiedi.” ");
INSERT INTO yml_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mulieta Iesu ma yana tovetutuyamavo i nagoi vanuge i velutolieni sa'ila faifaina. ");
INSERT INTO yml_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iesu i vonedi i vo, 'Ai'edi aitoi yana vavine i na vesa'ilidi wata tamu vavine i na nagidiga, 'akonadi i sakona yana vavine kumekumetana 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wata 'ai'edi vavine yadi lamoga i na sa'ileni, tamu tomogo i na nagiaga, 'akonadi i sakona yadi lamoga kumekumetana 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tomotoga 'ifwaidi natudiavo i miedi nuanuadi Iesu i na 'abitonovidi wata i na vona-nuakalikaliedi, siwe yana tovetutuyamavo i talabodebodedi. ");
INSERT INTO yml_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu i 'isedi i nuasako, begaidi i vonedi i vo, Kwakwama 'wa bailedi i na maia 'waikuye. Fai egavo taunidi tonuaobu yavayavava de'e bani'odi 'adi fata taunidi i na tauyedi bega Yaubada i na veveimeyedi yana 'Aila'a nageneye. ");
INSERT INTO yml_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A vona mogitana 'waimie, aitoi Yaubada i na vetumaganeni bani'odi de'e kwakwamanidi i vetumaganeku, Yaubada i na veimeyeni yana 'Aila'a 'waineye, we'e 'ai'edi kebu, kebu 'adi fata i na luku.” ");
INSERT INTO yml_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bega kwakwama i olidi nimana i yatoi 'aitamogana 'aitamogana 'waidie i velu'ui Yaubada 'waineye i na vesauluva-'atumaina 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu vanuga i 'iaweni i nunago 'edeye tamu tomogo i mai ma yana ve'ililibu 'agena i vetufano'uyedi mataneye i velutolieni i vo, Tove 'atumaimu, ava'ai a na 'idewai bega mia 'atumaina wata miamia-vagaina a na veluagai?” ");
INSERT INTO yml_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu i vo, Awale 'u awave'atumaieku? Kebu tamu aitoi 'atumainaga, Yaubada 'aiseotogina 'atumaina. ");
INSERT INTO yml_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ve'etoboda 'akonadi 'u 'asetadi basenadi Yaubada Mosese i veleni, kebu 'u na luvewafaga, kebu tamu aitoi yana vavine 'u na luobuyedi, kebu 'u na vainagoga, kebu 'u na vekali tamu tomogo yana sauluva faifaina, kebu 'u na 'ewa-maimaiga, tamamu wata inamu 'u na ve'ililibuyedi.” ");
INSERT INTO yml_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tomogo i vo, Tove, basenadi siaikuyega ve'etobodanidi a ve'ililibuyedi.” ");
INSERT INTO yml_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu tomogo i 'ise'iseni nika nuana i vekalikalia i voneni i vo, 'Waimuye nani 'aitamogana kebu 'u da 'idewaiga. 'U na nago yamu kukua wata nani matatabuna 'waimuye 'u na vekimwaneyedi, tutulidi 'u na 'ewadi bega egavo i vewekowekomaga 'u na 'ivaisedi, nika 'u na ve'ai'aiwabu abame. 'U na 'anivelenedi i na 'a'avana 'u na mai 'u na vetutuyameku.” ");
INSERT INTO yml_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tomogo i nogai i luvulewa ma yana nuavita i vilai i nago, fai yana 'ai'aiwabu fuedi nuana i loloi kebu nuanuana i na 'anivelenedi. ");
INSERT INTO yml_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu i sivilai yana tovetutuyamavo i vonedi i vo, Tove'ai'aiwabu yadi luku Yaubada yana 'Eba Veimea 'waineye vitana.” ");
INSERT INTO yml_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iesu yana tovetutuyamavo nuadi i voganidi yana vona faifaidi, begaidi i veifufu-vaitugana 'waidie i vo, Ekwavo a na vonemi, tomotoga yami luku Yaubada yana 'Eba Veimea 'waineye vitana. ");
INSERT INTO yml_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bawe yana luku aima mataneamo vitana, we'e tove'ai'aiwabu yadi luku Yaubada yana 'Eba Veimea 'waineye vitaotogina.” ");
INSERT INTO yml_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yana tovetutuyamavo i nogaiga, nuadi i voganidi bega i velutolieni i vo, Vetuma aitoi 'ana fata 'ita'ita'i i na veluagai?” ");
INSERT INTO yml_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu i 'isadewadi i tutula i vo, Tomotoga 'aise'avadi kebu 'adi fata 'ita'ita'i i na veluagai, we'e Yaubada 'waineye nani matatabuna 'ana fata.” ");
INSERT INTO yml_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Fita Iesu i voneni i vo, Maide, 'ima nani matatabuna 'a bailedi 'a maia 'waimuye 'a vevetutuyamemu.” ");
INSERT INTO yml_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu i vo, A vona mogitana 'waimie, egavo yadi vanuga i 'iawedi faifaiku wata Valaku 'ana lu'ivona faifaina, 'alo tamadiavo, inadiavo, ediavo, novudiavo, natudiavo 'alo yadi tanoga i 'iawedi faifaiku, 'awaie naninidi 'adi tutula bwaikaotogidi Yaubada i na veledi. ");
INSERT INTO yml_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Tutuya de'e wata tutuya i mimai 'waineye naninidi 'adi tutula bwaikaotogidi i na veluagadi ma 'adi 'imoso'i, bani'odi 100 nani 'aitamogana i baileniga faifaina. Side bani'odi, i na veluagadiga, vanuga fuedi, inadiavo fuedi, ediavo fuedi, novudiavo, natudiavo wata tanoga fuedi. Fai i vevetutuyameku veviga bwaikina i na veluagadi 'aku tovedumwe'ai'ai 'waidiega, we'e tutuya 'eba ve'a'ava 'waineye mia 'atumaina wata miamia-vagaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Siwe tomotoga fuedi 'asiau i kumetaga, 'awaie i na vemuli, we'e egavo 'asiau i vemuliga, ma'itufa i na kumeta.” ");
INSERT INTO yml_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","I tauya i nunagoi Ielusalema Iesu i 'edakumeta, yana tovetutuyamavo mulineye i maia nuadi i voganidi, we'e egavo 'ana toyogo'waila i kololo fai i 'asetai nani sakoina i na souyeni 'waineye. Iesu yana tovetutuyamavo 12 i vonedi i nagoi tulidie i kiavemageta ava'ai i na souyedi 'waineye Ielusalema nageneye faifaina. ");
INSERT INTO yml_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","I vonedi i vo, Ta nunagoiga Ielusalema, yau a vetomotogaotoga 'aku gaviavo i na 'etogiluveku tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo 'waidie. Mulieta wafa faifaina i na veimeyeku i na 'a'avana i na 'aniveleneku mali tomotoga kumanidiavo kebu Diu 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","I na sidibidibieku, i na kiwaliku wata i na toke i na fitaliku, mulieta i na luvewafaku, siwe 'aiata 'ana vetonu 'waineye a na tovoi wafayega.” ");
INSERT INTO yml_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi natunavo Iemesa wata Ioni, i maia Iesu 'waineye i voneni i vo, Tove, nuanuama tamu nani 'u na 'idewai faifaima.” ");
INSERT INTO yml_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu i vo, Ava'ai naniga a na 'idewai faifaimi?” ");
INSERT INTO yml_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","I tutula i vo, 'Awaie ma yamu veimea 'u na miabui 'amu didiga 'ai'aiwabuna 'waineye, nuanuama 'u da tauyema bega 'a da miabui lilivamuye, tamu 'amu 'atagiega, tamu 'amu wamayega.” ");
INSERT INTO yml_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iesu i vonedi i vo, 'Omi kebu 'wa da venua'ivinaga 'wa vevelu'ui 'waikuye. Sai'afoga veviga 'ana vedi a na yemuyeni, we'e 'omi 'ami 'ailuga 'ami fata vedinina 'wa na yemuyeni? I na bafitaisoku vevigayega, 'omi wata bani'odi 'ami fata?” ");
INSERT INTO yml_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","40","Iemesa ma taina i vo, E'e, 'ama fata.” Iesu i vonedi i vo, 'Wa vonaga mogitana, 'aku vediega 'wa na yemu wata 'wa na bafitaiso vevigayega yau bani'odi, siwe miabui 'aku 'atagiega wata 'aku wamayega yau kebu a da veveimeyediga. Didiganidi Yaubada i 'idewadi egavo i venua'ivinediga faifaidi.” ");
INSERT INTO yml_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tutuyanina tovetutuyamavo 'adi 10 Iemesa ma taina yadi veifufu i nogai, i kamogala 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Begaidi Iesu matatabudi i goleva'augidi i vonedi i vo, 'Akonadi 'wa 'asetai toveimea bwaikidi wata to'edakumetavo yadi veimea toketokedi 'waidiega tomotoga i veveimeyedi. ");
INSERT INTO yml_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","We'e 'omi kebu bani'odi 'wa na munega. 'Ai'edi aitoi 'waimiega nuanuana i na vetomogo-bwaika, nagami i na vetofolova enavo 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","We'e 'ai'edi aitoi nuanuana i na veto'edakumeta 'waimie, nagami i na vetofolova-maimaiga matatabumi 'waimie. ");
INSERT INTO yml_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wata bani'odi, yau a vetomotogaotoga a maiga kebu tomotoga faifaiku i na vetofolova, we'e mogitana a maiga a na vetofolova faifaimi wata yawaiku a na tauyeni fuemi a na tuveobumi nika yavuyavumi.” ");
INSERT INTO yml_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iesu ma enavo i maia Ieliko, tutuyanina i tautauya tovetutuyamavo wata 'aila'a bwaikina taiadi. Timio natuna 'ana wagava Batimio i miamia 'eda lilivaneye, taunina tomatasako kebu 'ana fata i na folova, i vevelu'ui mani. ");
INSERT INTO yml_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tutuyanina i nogai Iesu tomogo Nasaledi valana i vegolegole i vo, Iesu 'omu Kini Devida tubuna, 'u da 'isanuakalikalieku.” ");
INSERT INTO yml_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tomotoga fuedi i talaboda i vo, 'U ve'wada.” Nika i toke i vegolegole i vo, 'Omu Kini Devida tubuna, 'u da 'isanuakalikalieku.” ");
INSERT INTO yml_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu i nunago 'edeye bonana i nogai nika i tovoi i vo, 'Wa goleni i na mai.” Tomatasako i goleni i vo, 'U sosoana, 'u tovoi 'u nago i golegolemu.” ");
INSERT INTO yml_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yana velu'uva i taweni, i tovoi-matayo'o i nago Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu i velutolieni i vo, Ava'ai nuanuamu a na 'idewai faifaimu?” Tomatasako i vo, Tove, nuanuaku a da 'isala.” ");
INSERT INTO yml_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu i voneni i vo, 'Atumaina, fai 'u vetumaganeku 'akonadi 'u ve'atumai, 'u na nago.” I vona'a'ava nika matana i ve'atumai i 'isadewa, Iesu taiadi i nago. ");
INSERT INTO yml_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iesu yana tovetutuyamavo taiadi i nunago Ielusalema weyaginega, nika i le'wa 'atamana 'ailuga 'waidie Bedifegi wata Bedani. Bei 'Oya Olive 'waineye, Iesu tovetutuyamavo 'adi 'ailuga i vonedi i na kumeta. ");
INSERT INTO yml_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Wata i vonedi i vo, 'Atamana debanagomiega 'waineye 'wa na nagoi. Tutuyanina 'wa na le'wa 'wa na lukuluku doniki tubuvauvauna 'wa na 'iseni i luifweni i tovotovoi, basenadi kebu tamu aitoi kwavuneye i da lakaga. 'Wa na yavuya 'wa na mieni 'waikuye. ");
INSERT INTO yml_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","'Ai'edi tamu aitoi i na vo, Awale 'wa 'ewa'ewai?’ 'Wa na vo, 'Auvea nuanuana, bola wata i na vevila-matayo'oi.’” ");
INSERT INTO yml_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Tovetutuyamavo 'adi 'ailuga i nagoi doniki tubuvauvauna i veluagai vanuga 'awana lilivaneye bei basenadi i luifweni. Tutuyanina i yavuyavuya, 'ifwaidi tomotoga i tovotovoiga i vo, Awale 'wa yavuyavuya?” ");
INSERT INTO yml_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tovetutuyamavo i tutula 'waidie bani'odi Iesu i vonedi nika doniki i tauyeni. ");
INSERT INTO yml_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Doniki tubuvauvauna i mieni Iesu 'waineye, 'adi talauma kwavuneye i yatodi, bei Iesu i miabui. ");
INSERT INTO yml_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tomotoga fuedi ma yadi ve'ililibu yana 'eda i 'ivivigavuya 'adi talaumayega, we'e 'ifwaidi welavi matoutoudi i kinidabadi i ta'ulidi 'edeye. ");
INSERT INTO yml_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bega tokumeta wata tovemuli i toke i vevegolegole Iesu faifaina i vo, Kaiwa, kaiwa, taunina 'Auvea 'ana wagavayega i mimai, Yaubada i da vevesauluva 'atumaina 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tubuda Kini Devida yana 'Eba Veimea i mimai, Yaubada i da vevesauluva 'atumaina 'waineye. Kaiwa, kaiwa Yaubada kumanina tabwaotogineye ta na subisubiai.” ");
INSERT INTO yml_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu i nago Ielusalema i luku Vanuga 'Eba Velu'ui nageneye i vai'ala, fai 'akonadi i lavia begaidi ma yana tovetutuyamavo 'adi 12 i maia Bedani, kebu 'ani'iega Ielusalema 'wainega. ");
INSERT INTO yml_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","I 'atai Bedaniega i viladi i mimai nika Iesu i lase. ");
INSERT INTO yml_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","'Ani'ieyega i 'isanago 'ala'ai i 'iseni bega i nago lilivaneye nuanuana i na 'iseni ma vuagina 'alo kebu. Siwe tutuyanina i mai lilivaneye i 'iseni luku'avana fai kebu mogitana 'ala'ai 'ana tutuya. ");
INSERT INTO yml_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iesu 'ala'ai 'waineye i vona i vo, 'Asiau wata tutuya i mimai kebu tamu aitoi vuagimu i na 'ani'ania,” we'e yana tovetutuyamavo yana vonanina 'ala'ai 'waineye i nogai. ");
INSERT INTO yml_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tutuyanina i le'wai Ielusalema, Iesu i luku Vanuga 'Eba Velu'ui nageneye i 'isedi tokimwane wata tovekimwane, matatabudi i sogiedi i obu. Wata mani tulina tulina 'adi tosivedavedamana yadi talalia i tutuviladi wata bunebune 'eba velomu faifaidi 'adi tosivedavedamana yadi 'eba miabui i tutufelefeledi. ");
INSERT INTO yml_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kebu tamu aitoi i da tauyeni bega tamu kukua i na lukuveni Vanuga 'eba Velu'ui nageneye. ");
INSERT INTO yml_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iesu i vonedi i vo, Basenadiotoga i kilumi Yaubada yana Buki nageneye i vo, Yaku vanuga 'ana wagava Vanuga 'Eba Velu'ui tomotoga 'aila'a tulina tulina faifaidi.’ Siwe 'omi 'wa vesivilai, tovainago yadi 'eba giva.” ");
INSERT INTO yml_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo 'akonadi i nogai, i kololo bega 'aise'avadi i veifufu bani'odi i na munega Iesu i na luvewafai. I kolologa fai tomotoga matatabudi nuanuadi Iesu we'e yana ve faifaina nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","'Akonadi inala i simwanuya, bega Iesu ma yana tovetutuyamavo Ielusalema i 'iaweni i viladi i nagoi Bedani. ");
INSERT INTO yml_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","'Awa'awaie Iesu ma enavo i nunagoi i 'iseni 'ala'ai matatabuna i 'awagi'ai. ");
INSERT INTO yml_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Fita nuana i 'anita'ia bega Iesu i voneni i vo, Tove, 'ala'ai 'u voneniga 'akonadi matatabuna i 'awagi'ai.” ");
INSERT INTO yml_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Iesu yana tovetutuyamavo i vonedi i vo, A vona mogitana, 'ai'edi tamu tomogo ma yana vetumagana Yaubada 'waineye, 'ana fata de'e 'Oya Olive i na voneni i na obu eyage. 'Ai'edi kebu ma yana venuanaluga, i na vona ma yana vetumagana, naninina faifaina i vonaga i na souyeni. ");
INSERT INTO yml_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Begaidi a na vonemi, naninidi nuanuami 'wa na velu'ui Yaubada 'waineye. 'Ai'edi 'wa na vetumagana naninina nuanuami 'akonadi 'wa veluagaiga, Yaubada i na velemi. ");
INSERT INTO yml_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tutuyanina 'wa na vevelu'ui, 'ai'edi ma yami nuasako tamu tomogo 'waineye, nagami 'wa nuatavuni, nika Tamami abame yami sakona i na nuatavunidi. ");
INSERT INTO yml_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","We'e 'ai'edi kebu 'wa na nuatavuniga wata Tamami abame yami sakona kebu i na nuatavunidi.” ");
INSERT INTO yml_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Wata i viladi i maia Ielusalema. Tutuyanina Iesu i nunago Vanuga 'Eba Velu'ui nageneamo, tovelomu yadi to'edakumetavo, ve'etoboda 'adi tovevo wata to'edakumeta 'au'auveadi i maia Iesu 'waineye i velutolieni i vo, Nuanuama 'a na 'asetai aitoi i vetunemu bega naninidi 'u 'i'idewadi 'alo aitoi veimea i velemu?” ");
INSERT INTO yml_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu i vo, We'e tamu velutoli yau a na velemi, 'ai'edi yaku velutoli 'wa na tutula-'atumaiaga a na vonemi aitoi veimea i veleku bega nani de'e a 'i'idewadi. ");
INSERT INTO yml_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","'Wa da nuani, Ioni Tobafitaiso aitoi veimea i veleni bega tomotoga i bafitaisodi? Yaubada 'alo tomotoga?” ");
INSERT INTO yml_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","To'edakumetanidi 'aise'avadi i veifufu i vo, Bani'odi ta na voneyedi? 'Ai'edi ta na vo, Yaubada veimea Ioni i veleni,’ 'ako i na vo, Vetuma awale kebu Ioni yana vona 'wa da vetumaganeni?’ ");
INSERT INTO yml_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wata kebu 'ada fata ta na vo, Tomotoga veimea Ioni i veleni.’” To'edakumetavonidi 'aila'a i kololoyedi, kebu nuanuadi Ioni i na awaobuobuyeni, fai 'aila'a matatabudi i ve'awamogitana Ioni tamu Yaubada yana tolu'ivona. ");
INSERT INTO yml_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Begaidi Iesu yana velutoli i tutuli i vo, 'Ima kebu 'a da 'asetaiga aitoi veimea Ioni i veleni.” Iesu i vo, Vetuma yau wata kebu a na vonemiga aitoi veimea i veleku bega naninidi a 'i'idewadi.” ");
INSERT INTO yml_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mulieta Iesu i vona-awatabai 'waidie i vo, Tamu tomogo kalefa talagina i bakuli wata i kalieni. Vuagina 'ana 'eba vatanitani i 'idewai wata kileu i didigi, tabwaneye 'eba lu'atu'ai i yogoni. Mulieta tomotoga 'ifwaidi nimadie i yatoi i na 'isave'avini, nika i tauya i nago mali 'awalaweye. ");
INSERT INTO yml_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kalefa yana kumaga 'ana tutuya i le'wa, tonibakula tamu yana tofolova i voneni i nago yana bakula 'ana to'isave'avinavo 'waidie, vuaga 'ifwaidi i na miedi faifaina. ");
INSERT INTO yml_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Siwe to'isave'avinanidi tofolova i 'ive'avini i nikei, nima'ava'avana i vevilai. ");
INSERT INTO yml_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mulieta wata tamu tofolova i vetunei. Tofolovanina 'unu'ununeye i 'aitalaga wata i 'ivekokovaotogi. ");
INSERT INTO yml_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wata tamu i vetuneiga i luvewafaotogi. Wata fuedi i vetunedi, 'ifwaidi i nikedimo we'e 'ifwaidi i luvewafadi. ");
INSERT INTO yml_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","'Aitamogana i miamia bega 'eba ve'a'avaotoga i vetunei, taunina natuna nuafouna i vo, De'e natuku, i na ve'ililibuyeni.’ ");
INSERT INTO yml_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Siwe to'isave'avinanidi i 'iseni i mimai 'aise'avadi i veifufu i vo, No'o tonibakula natuna, bola nani matatabuna i na 'ewadi i na veimeyedi. 'Wa maia ta na luvewafai bega naninidi ta na 'ewadi.’ ");
INSERT INTO yml_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bega i 'ive'avini, i luvewafai i taweni kalimulie.” ");
INSERT INTO yml_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iesu me Diu to'edakumetavo i velutoliedi i vo, Tonibakula to'isave'avinanidi bani'odi i na munegidi? I na vilai i na mai to'isave'avinanidi matatabuna i na leodi mulieta tomotoga 'ifwaidi i na vonedi i na veto'isave'avina.” ");
INSERT INTO yml_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nika Iesu tamu vona-samula Yaubada yana Buki 'wainega i veifufuyeni 'waidie, tomotoga Yaubada 'ana Venua'ivina i na baileniga faifaina. I vo, 'Omi 'wa da vo de'e vonanina kebu 'wa da lu'iawawaiga i vo, To'aiyogonavo folova tamu i 'iseni siwe i baileni, tutuya de'e i ve'unututuyeni. ");
INSERT INTO yml_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","'Auvea taunina i 'idewai, 'ana 'isa 'waideye 'eba nua'ewa.’” ");
INSERT INTO yml_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Me Diu to'edakumetavo Iesu yana vona i nogai i 'asetai 'adi vona-awatabai, taunidi bani'odi to'aiyogonanidi wata to'isave'avinavo sakoidi. Igodi nuanuadi i da 'ive'avini, siwe tomotoga i kololoyedi fai 'aila'a bwaikina nuanuadi Iesu, begaidi i baileni. ");
INSERT INTO yml_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mulieta me Diu yadi to'edakumetavo 'ifwaidi Falisi wata 'ifwaidi Kini Elodi 'ana 'aila'avo i vetunedi i nagoi Iesu 'waineye, nuanuadi i na velutolieni bega bonana i na nogai, 'ai'edi i na vekali 'adi fata i na 'ive'avini. ");
INSERT INTO yml_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","15","I maia Iesu i voneni i vo, Tove, yamu sauluva tonovidi, kebu 'u da vevekaliga. 'A 'asetamu 'omu ma 'amu vetumagana. Kebu tomotoga 'atumaidi wata sakoidi 'u da lulu'idiedi. Siwe 'u veve mogitana Yaubada yana nuanua tomotoga 'waimeye. 'U da nuani, i lubwaineda 'ida me Diu ta na takesi Loma yadi toveimea bwaikina Sisa 'waineye 'alo kebu? Nuanuama 'a na 'asetai.” Iesu yadi bavuseba 'akonadi i 'asetai begaidi i vonedi i vo, 'Omi tovekali, awale igodi 'wa sisiloloku. Maninina 'wainega ta yatoyato takesi, 'wa na mieni ta na 'iseni.” ");
INSERT INTO yml_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Maninina i mieni i 'iseni i velutoliedi i vo, De'e mani 'waineye, aitoi 'anununa wata 'ana wagava?” I vo, Sisa.” ");
INSERT INTO yml_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bega Iesu i vonedi i vo, Vetuma, 'ai'edi ava'ai Sisa faifaina, 'wa na 'aniveleneni Sisa 'waineye we'e ava'ai Yaubada faifaina, 'wa na 'aniveleneni Yaubada 'waineye.” Iesu yana vona i nogai, nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","'Ifwaidi Diu totafalolo Sadusi i maia Iesu 'waineye, taunidi tovona igodina tomotoga kebu i na yawasa-vaitugana. Tomotoganidi Iesu i velutolieni i vo, Tove, basenadiotoga Mosese yada veimea i kilumi i vo, 'Ai'edi tamu tomogo i na wafaga siwe kebu natunavoga, 'wabulina taina i na nagidi bega kwakwama i na vetubugidi tatana 'ana wagava wata 'ana wauma faifaidi.’ ");
INSERT INTO yml_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","We'e tamu tomogo ma tainavo 'adi 'aila'a 7, tulaiotogina i nagi kebu tamu natunaga i wafa. ");
INSERT INTO yml_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","'Wabula yadi bwa i nagia, kebu tamu natuna wata i wafa. 'Adi vetonu yadi bwa i nagidi, i nagoga taidiavo matatabudi 'wabulanidi taiadi i nagi siwe kebu tamu natudiavoga. Tomotoganidi 7 i wafa'a'ava, mulieta 'eba ve'a'ava 'waineye vavine yawaidi i 'a'ava. ");
INSERT INTO yml_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","'Omi 'wa vonaga 'awaie towafa matatabudi i na yawasa-vaitugana, begaidi 'u na vonema, 'aiatanina 'waineye aitoi mogitana yana vavine, fai tomotoganidi 7 taiadi i nagi?” ");
INSERT INTO yml_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu yadi velutoli i tutuli i vo, 'Omi 'wa vekali mogitana fai Yaubada yana Buki wata yana toketokena 'wa bavuyedi. ");
INSERT INTO yml_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tutuyanina towafa i na yawasa-vaitugana yadi sauluva bani'odi anelose abame, nagi kebu. ");
INSERT INTO yml_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'Omi 'wa vonaga towafa kebu i na tovoi-vaitugana, siwe a na vonemi. 'Ai'edi Mosese 'ana kilukiluma 'wa da lu'iawawa-dewai 'wa da 'iseni Yaubada i vonavona 'waimie yawasa-vaitugana faifaina. Yaubada i veifufu Mosese 'waineye 'ai-'ala'alata 'wainega. I vo, Yau Ebelamo, Aisake wata Iakobo yadi Yaubada.’ ");
INSERT INTO yml_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","De'e bani'odi Yaubada i voneyediga fai tomotoganidi basenadiotoga i wafa siwe 'asiau ma yawaidi taiadi i miamiani. Egavo 'akonadi i wafaga 'asiau ma yawaidi i miamiani. Kebu tamu aitoi wafanaga Yaubada mataneye. 'Omi 'wa vekaliotoga.” ");
INSERT INTO yml_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tamu ve'etoboda 'adi tove taiadi, i nogai veifufunina. I 'iseni Iesu Sadusi yadi velutoli i tutula-'atumaia, bega i velutolieni i vo, Veimeanidi Mosese 'wainega i maiga, ava'ai veimeaga mogitana bwaikina?” ");
INSERT INTO yml_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu i vo, Side veimeanina bwaikina i vo, Me Isileli 'wa ve'wada a na vonemi, 'Auvea yada Yaubada, 'Auvea 'aitamogaotogina. ");
INSERT INTO yml_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","'Auvea yami Yaubada 'wa na nuakalikalieni mogitana nuamiega, 'anu'anunumiega, yami nuanua 'waidiega wata yami toketokena matatabuna 'waidiega.’ ");
INSERT INTO yml_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Veimea bwaikina 'ana veluga side bani'odi i vo, Emiavo 'wa na nuakalikaliedi taunimi 'ami nuakalikali bani'odi.’ De'e veimeanidi 'ailuga bwaikidi, kebu wata tamu bani'odiga.” ");
INSERT INTO yml_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ve'etoboda 'adi tove Iesu i voneni i vo, Tove, 'u vonaga 'atumai'avana. Mogitana Yaubada 'aiseotogina, kebu tamu wata aitoi. ");
INSERT INTO yml_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","'U vona mogitana Yaubada ta na nuakalikalieni nuadega, 'anu'anunuda 'waidiega, yada nuanua 'waidiega wata yada toketokena ta na tautauyedi 'waineye. Edavo ta na nuakalikaliedi taunida 'ada nuakalikali bani'odi. Velomu wata 'anivelena-maimaiga nani bwaikidi Yaubada 'waineye, siwe veimeanidi 'ailuga bwaikaotogidi.” ");
INSERT INTO yml_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesu i nogai tomogonina i vona mogitana begaidi i voneni i vo, 'Omu 'akonadi taunimu 'u tautauyemu Yaubada 'waineye bega sai'afoga i na veimeyemu.” Iesu i vona'a'ava wata kebu tamu aitoi i da vetoketoke bega i na velutolieni. ");
INSERT INTO yml_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu Vanuga 'Eba Velu'ui 'waineye i veve i velutoliedi i vo, Ve'etoboda 'adi tovevo i vonaga Keliso, taunina Yaubada 'ana Venua'ivina, Kini Devida tubuna. Awale bani'odi i voneyedi? ");
INSERT INTO yml_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Basenadiotoga 'Anu'anunu Magemagetana Devida i tolivetonoveni bega i ve'awa-Toveimea Keliso 'waineye. Devida i vo, 'Auvea i vona 'aku Toveimea 'waineye i vo, Veimea a velemuga bega 'u na miabui 'aku 'atagiega. I na nagoga 'amu gaviavo a na vetoketoke-'iawedi bega 'u na veveimeyedi.”’ ");
INSERT INTO yml_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Keliso mogitana Devida 'ana wauma 'wainega i souyeni siwe i vebwaika-'iaweni begaidi Devida i ve'awa-Toveimea Keliso 'waineye.” 'Aila'a bwaikina Iesu yana vonanina i nogai i sosoana. ");
INSERT INTO yml_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu i veve 'waidie i vona i vo, Taunimi 'wa na 'i'isave'avinimi i na nunago ve'etoboda 'adi tovevo i na vekaliemi. Talauma manamanawedi i veve'wesenedi i yabayaba 'atamanafouye bega tomotoga ma yadi ve'ililibu i na vevekaiwa 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nuanuadi to'edakumeta bwaikidi taiadi i na mimiabui 'eba miava'auta 'waidie wata sakali 'waidie nuanuadi i na mimiabui ma 'adi wagava taiadi. ");
INSERT INTO yml_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","We'e 'wabu'wabulavo i vevekaliedi yadi vanuga i eloelodi wata yadi velu'ui i lulumanamanawedi bega tomotoga i na subisubiadi, i na vo 'ako mogitana Yaubada yana tofolovavo 'atumaidi. Siwe 'awaie 'adi vematavuloga bwaikaotogina i na veluagai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","42","Iesu i miabui Vanuga 'Eba Velu'ui nageneye 'eba yato lilivaneye, 'aila'a i 'ise'isedi mani i yatoyato 'eba yato 'waineye. Tove'ai'aiwabu fuedi mani bwaikina i yato, we'e tamu 'wabula i vewekowekomaga kileu siaidi 'ailuga i dodogidi. ");
INSERT INTO yml_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yana tovetutuyamavo i goledi i maia 'waineye i vonedi i vo, A vona mogitana tomotoga i yatoga 'eba yato 'waineye, 'wabulanidi bwaikaotogina i yato. ");
INSERT INTO yml_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","'Ifwaidi i yatoga siwe wata yadi mani bwaikina i 'eno'enovi we'e 'wabulanidi yadi mani i lusaweni. Kebu wata tamu mani 'waidie i da 'eno'eno 'adi'adi faifaina.” ");
INSERT INTO yml_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu wata yana tovetutuyamavo taiadi i sousouyedi Vanuga 'Eba Velu'ui 'wainega, tamu yana tovetutuyama i voneni i vo, Tove, 'u 'iseni Vanuga 'Eba Velu'ui, kileu bwaikaotogidi 'waidiega i yogoni, 'ana 'isa 'atumaiotogina.” ");
INSERT INTO yml_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu i vo, Vanuganina 'u 'ise'iseniga mogitana 'atumaina, siwe 'awaie 'ami gaviavo i na maia matatabuna i na geuya wata kileunidi bega i bibinaga i na tutuwealidi, matatabuna i na tubakabakaledi.” ");
INSERT INTO yml_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Mulieta Iesu ma enavo i laka 'Oya Olive, bei i miabui i miamiani Vanuga 'Eba Velu'ui we'e no'o bega kebu 'ani'iega Ielusalema 'wainega. Fita, Iemesa, Ioni wata Anidulu 'aisedie Iesu i velutolieni i vo, 'U da vonema ava'ai tutuyaga Vanuga 'Eba Velu'ui i na geuya wata ava'ai tugusaga 'a na 'iseni bega 'a na 'asetai naninidi sai'afoga i na souyedi?” ");
INSERT INTO yml_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Bega Iesu i vonedi i vo, Taunimi 'wa na 'isave'avinimi i na nunago tamu aitoi i na vekaliemi, fai tomotoga fuedi i na mai 'aku wagavayega igodi i na vo, Yau 'asa'aiana Keliso, Yaubada 'ana Venua'ivina.’ Yadi vonayega fuedi i na vekaliedi. ");
INSERT INTO yml_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Lilivamie vetalaga butu'aidi 'wa na noganogaidiga wata 'ani'ieyega vala'avadi siwe a vovona-vagasemi, kebu nuafoumi i na veviga. Naninidi mogitana i na souyedi we'e fwayafwaya 'ana 'eba ve'a'ava bola. ");
INSERT INTO yml_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","'Eba veimea bwaikidi wata 'eba veimea bwaikidi taiadi i na vevetalaga, we'e 'awalawa wata 'awalawa taiadi i na vevetalaga. We'e 'awalawa fuedi 'waidie yoyoyo i na yueyue wata i na loka. Tutuyanina vavine i na vebutudiga veviga bwaikina i na vebaedi wata bani'odi naninidi a veifufuyediga tutuyanina i na souyediga veviga wata 'we'wela i na velamu. ");
INSERT INTO yml_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","'Wa na 'isa'isa fai 'omi 'wa na vetolu'ivona faifaiku, tomotoga 'ifwaidi i na 'ive'avinimi i na nawemi yadi kaniselavo 'waidie, wata 'eba miava'auta 'waidie i na toke i na fitalimi. Fai 'omi yaku tofolova begaidi 'wa na vonayavuga toveimea bwaikidi wata kini 'waidie. Siwe tutuyanina 'waineye 'ami fata Vala 'Atumaina faifaiku 'wa na lu'ivoneyeni 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","I lubwaineni nagami Valanina 'Atumaina yaku tomotoga i na lu'ageyeni tomotoga 'adi 'aila'a tulina tulina 'waidie, mulieta fwayafwaya 'ana 'eba ve'a'ava. ");
INSERT INTO yml_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","We'e 'omi, i na 'ive'avinimi i na nawemi vonayavuga 'waineye, siwe kebu 'wa na venuafouviga 'wa na vo, Bani'odi ta na voneyedi,’ fai tutuyanina 'waineye Yaubada i na awave'ede'edemi. Bega vonanidi 'waidiega 'wa na vonavona kebu taunimi yami vona, 'Anu'anunu Magemagetana 'waimiega i na vonavona. ");
INSERT INTO yml_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tomotoga fuedi yaku tomotoga i na vedumwe'ai'aiemi, 'ifwaidi tomotoga taidiavo 'alo tatadiavo i na 'anivelenedi 'aku tovedumwe'ai'ai 'waidie i na luvewafadi. We'e tama 'ifwaidi natudiavo i na 'anivelenedi i na wafa wata yavayavava tamadiavo, inadiavo taiadi i na vegaviedi bega i na wafa. ");
INSERT INTO yml_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Fai 'wa vetumagana 'waikuye begaidi tomotoga fuedi i na vedumwe'ai'aiemi, siwe egavo i na tokemaigedi i na nagoga tutuya 'eba ve'a'ava 'waineye 'ita'ita'i i na veluagai.” ");
INSERT INTO yml_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(Buki tokiluma bonaku, Iesu yana vona de'e 'wa na lu'iawawaiga 'wa na venua'ivineni nika 'wa na 'asetai.) Wata Iesu i vonedi i vo, 'Awaie tamu nani 'wa na 'iseni maigikolokololona Vanuga 'Eba Velu'ui nageneye i na tovotovoi. Tutuyanina tugusanina i na souyeni, egavo i na miamiani 'awalawa Iudia nageneye, i lubwainedi i na dega i na nagoi 'oyeye. ");
INSERT INTO yml_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","16","'Ai'edi aitoi masi'edeye i na miamia, kebu 'ana fata i na luku vanuge yana kukua i na 'ewadi i na dega-matayo'o wata aitoi i nagoga bakule, kebu 'ana fata i na vilai i na mai vanuge 'ana talauma 'ana 'ewa faifaina. ");
INSERT INTO yml_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","'Aiatanidi 'waidie toveinainage wata vauvau nuakalikalidi, fai kebu 'adi fata i na dega-matayo'o veviga bwaikina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yaubada 'waineye 'wa na vevelu'ui bega naninina kebu i na souyeni toalu'uye. ");
INSERT INTO yml_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yaubada fwayafwaya i 'idewavauyeni i maiga 'asiau veviga i sousouyedi siwe sai'afo, we'e 'aiatanidi 'waidie veviga bwaikaotogina i na souyeni, i na 'a'avana kebu wata bani'odi i na sousouyeni. ");
INSERT INTO yml_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vitanidi de'e 'ana tutuya 'Auvea i na 'ive'ale'usai, 'ai'edi kebu, tomotoga matatabuna i na wafa'a'ava. Tomotoganidi i venua'ivinediga faifaidi i na 'ive'ale'usai bega yadi mia i na ve'atumai. ");
INSERT INTO yml_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Tutuyanina 'waineye 'ai'edi aitoi i na vonemi i na vo, Sino Keliso i le'wa,’ 'alo i na vo, Side taunina,’ kebu bonana 'wa na nogai 'wa na vo 'ako mogitana, fai keliso-vekavekali wata tolu'ivona-vekavekali i na sousouyedi. I na souyediga 'eba nuavogana wata 'eba nua'ewa i na 'i'idewadi, igodi nuanuadi tomotoganidi Yaubada i venua'ivinediga vekaliega nuadi i na 'ewadi. ");
INSERT INTO yml_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Naninidi 'awaie i na souyediga 'akonadi 'wa nogai, a vovona-vagasemi bega 'wa na 'isa'isa. ");
INSERT INTO yml_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Tutuyanina vitanina i na 'a'ava nika inala i na lu'waugi, weta'i yana mageta i na 'a'ava, 'ubwana i na avuta abamayega wata nani matatabuna toketokedi abame i na yue. ");
INSERT INTO yml_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tutuyanina 'waineye tomia fwayafwaya matatabuna i na 'iseku yau a vetomotogaotoga abamayega a na mimai waowa 'wainega ma yaku toketokena wata ma magetaku mataududulina. ");
INSERT INTO yml_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yaku anelose a na vetunedi yaku tomotoga vevenua'ivinidi i na va'augidi i na miedi. Tomotoganidi i na miediga fwayafwaya matatabuna 'wainega, inala yana 'eba lakayega wata yana 'eba inivayega, bolimanayega wata yavalatayega. ");
INSERT INTO yml_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Modawa 'wa na nuani, tutuyanina i na idiaga ta 'asetai 'aisaya i veyafa. ");
INSERT INTO yml_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wata bani'odi 'ai'edi tugusanidi a voneyediga 'wa na 'isedi, 'wa na 'asetai yaku souyagi 'akonadi i le'wale'wa. ");
INSERT INTO yml_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A vona mogitana 'waimie, tutuya de'e 'ana tomotoga bola i na miamiani naninidi matatabuna i na souyedi. ");
INSERT INTO yml_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Abama wata fwayafwaya 'awaie i na 'a'ava, we'e yaku vona kebu tamu sai'afo i na 'a'ava, i na 'eno-vagata.” ");
INSERT INTO yml_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Wata Iesu i vonedi i vo, Yaku mai-vaitugana kebu tamu aitoi i da 'asetaiga, ava'ai 'aiataga 'alo ava'ai 'awasasaga 'waineye a na vilaku. Anelose abame kebu i da 'asetaiga, 'alo yau Yaubada Natuna, Tamaku 'aiseotogina i 'asetai. ");
INSERT INTO yml_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Fai 'omi kebu 'wa da 'asetaiga ma'avia nani de'e i na souyeni, begaidi taunimi 'wa na 'isave'avinimi wata 'wa na 'isa'isa. ");
INSERT INTO yml_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yaku le'wa side bani'odi. Tamu tomogo i na nago 'ani'ie bega yana tofolovavo 'aitamogana 'aitamogana yadi folova i veledi wata vanuga 'ana to'isave'avina i voneni i vo, 'U na 'isa'isa wata 'u na lulukamata.’ ");
INSERT INTO yml_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wata 'omi bani'odi 'wa na 'isa'isa fai kebu 'wa da 'asetaiga ma'avia yau tonivanuga a na le'wa. Lavilavie, lovana 'ana utukamwana, tu'wa'wale, 'alo 'awa'awaie. ");
INSERT INTO yml_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kebu nuanuaku a na le'wa a na 'isemi 'wa na 'eno'eno a na veyawailovogimi. ");
INSERT INTO yml_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ava'ai a voneyeni 'waimie, wata bani'odi tomotoga matatabuna a vonedi, 'wa na 'isa'isa.” ");
INSERT INTO yml_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","'Aiata 'ailuga i na 'a'ava, mulieta Uvi'agalatagona 'ana lusakali wata Beledi Yalayalana Sakalina i na 'idewai. Tutuyanina 'waineye tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo i veifufu, bani'odi i na munega givagivayega Iesu i na 'ive'avini i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Siwe wata i vo, Kebu sakalie ta na 'ive'aviniga i na nunago egavo nuanuadi Iesu i na nuasako i na daba.” ");
INSERT INTO yml_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu bola i miamia 'atamana Bedani i nago Saimoni yana vanuge, kumanina basenadi viga sakoina 'eba kololo tomogona i velufo'afo'ana, 'wainega i ve'atumai. I 'ani'ani nika tamu vavine bunama i mieni, magaina 'atumaina wata 'ana tutula bwaikina. Bunamanina 'ana wagava Nadi, we'e bei i koiaga kileu i 'idewai 'ana 'isa 'atumaiotogina, 'ana wagava alibasita. Bunamanina 'odona i tutubaia Iesu 'unu'ununa i iwagi. ");
INSERT INTO yml_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tomotoga 'ifwaidi i 'iseni, ma yadi nuasako i luvulewa i vo, Awale bunama i ve'amubwadodoyeni? ");
INSERT INTO yml_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","I lubwaineni i da vekimwaneyeni bega mani bwaikina i da veluagai bani'odi lubulubu 300, 'wainega tovewekowekoma i da 'ivaisedi.” Begaidi vavine i yagaia. ");
INSERT INTO yml_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","7","Iesu i vonedi i vo, 'Asa'aiana, 'wa 'ailove, vavine kebu 'wa na 'ivebunumayagi. Naninina i 'idewaiga 'waikuye 'atumaiotogina i lubwaineni, we'e tovewekowekoma tutuya fuedi taiadi 'wa na miamia, tutuyanina nuanuami 'ami fata 'wa na 'ivaisedi. We'e yau kebu tutuya manamanawena taiadi ta na miamia. ");
INSERT INTO yml_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Naninina vavine de'e 'waineye i 'eno'enoga, i tauyeni 'waikuye. Bunamanina 'wainega tomogoku i iwagi i 'idewa-vagaseni 'aku ve'ufa faifaina. ");
INSERT INTO yml_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A vona mogitana 'waimie, bola Valaku 'Atumaina i na lulu'ageyeni fwayafwaya matatabuna 'waineye, vavine de'e yana folova 'waikuye wata i na lulu'ivoneyeni 'ana 'eba nuave'avina.” ");
INSERT INTO yml_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iesu i iwagi i 'a'avana, mulieta tamu yana tovetutuyama 'ana wagava Iudasa Isakaliota i nago tovelomu yadi to'edakumetavo 'waidie nuanuana Iesu i na 'etogiluveni 'waidie bega i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma yadi sosoana yana vona i nogai bega i vona'awaufaufa tutula i na veleni. Begaidi Iudasa i lalauala 'eda'eda 'atumaina 'wainega Iesu i na 'aniveleneni 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Beledi Yalayalana Sakalina 'ana 'aiata 'eba velamu 'waineye, sifi natudiavo i nikenikedi i vevelomuyedi Uvi'agalatagona 'ana lusakali faifaina. 'Aiatanina 'waineye, tovetutuyamavo Iesu i velutolieni i vo, Ava'aibe bei nuanuamu yada sakali 'ana 'ani faifaina 'a na 'idewadewa?” ");
INSERT INTO yml_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bega Iesu yana tovetutuyamavo 'adi 'ailuga i vonedi i vo, 'Wa na nagoi Ielusalema, tamu tomogo ma yana 'eba koi ufa 'wa na veluagai, i na nunago tamu vanuga 'waineye 'wa na yogo'waili. ");
INSERT INTO yml_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Vanuganina 'waineye i na lukuga tonivanuga 'wa na velutolieni 'wa na vo, Yama Tove i vo, Ava'aibe bei yaku tutudaba yaku tovetutuyamavo taiadi 'a na 'ani Uvi'agalatagona faifaina?”’ ");
INSERT INTO yml_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nika tonivanuga i na vemi tamu tutudaba bwaikina vanuga 'etotubwatubwana tabwaneye 'akonadi i 'idewai faifaida. Bei 'ada'ada 'wa na 'idewadewa.” ");
INSERT INTO yml_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tovetutuyamavo 'adi 'ailuga i nagoi 'atamananina bwaikina 'waineye, naninidi Iesu i voneyediga matatabuna i veluagadi nika bei Uvi'agalatagona 'ana sakali i 'idewadewa. ");
INSERT INTO yml_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Inala i simwanuya Iesu ma yana tovetutuyamavo 12 taiadi i maia, i luku vanuge i na 'ani. ");
INSERT INTO yml_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yadi 'aninina 'waineye Iesu i vo, A na vonemi, tamu 'waimiega i na 'etogiluveku, taunina ma fueda ta 'ani'ani.” ");
INSERT INTO yml_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tovetutuyamavo yana vona i nogai nuafoudi i veviga 'aitamogana 'aitamogana i vevelutoli i vo, 'Auvea voke yau, siwe a nuani kebu.” ");
INSERT INTO yml_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesu i vo, 'Ami 12 'waimiega 'aitamogana i na 'etogiluveku. Taunina yau taiadi 'ama beledi 'a lulu'utuva 'aivoeye. ");
INSERT INTO yml_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Basenadiotoga i kilumi Yaubada yana Buki nageneye yau a vetomotogaotoga i na nikeku a na wafa. I vonaga mogitana, we'e 'aku to'etogiluva nuakalikalina. 'Ako kebu i da tubugaga 'atumaina, siwe fai i tubuga yana sakonanina faifaina veviga bwaikina i na veluagai.” ");
INSERT INTO yml_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tutuyanina i 'ani'ani Iesu tamu 'ani'ani i 'ewai i vekaiwa Yaubada 'waineye, mulieta i 'ivivia yana tovetutuyamavo i veledi. I vonedi i vo, 'Ani'ani de'e 'asa'aiana tomogoku. 'Wa na 'ewai 'wa na 'ania.” ");
INSERT INTO yml_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mulieta oine ma vedina i 'ewai, Yaubada 'waineye i vekaiwa, i veledi matatabudi i yemu. ");
INSERT INTO yml_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bega Iesu i vona i vo, Oine de'e 'asa'aiana dayagiku, i na ilolo fuemi faifaimi. Yaku wafanina 'wainega Yaubada yana Veakutagona 'Ivauna basenadi faifaina i vona'awaufaufa i na velamu 'waimie. ");
INSERT INTO yml_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A vona mogitana 'waimie, oine de'e kebu wata a na yemuga, i na nagoga 'ana tugusa oine 'ivauna a na yemu Yaubada yana 'Eba Veimea nageneye.” ");
INSERT INTO yml_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iesu i vona'a'ava lei-subisubia i leieni, mulieta i nago i laka 'Oya Olive. ");
INSERT INTO yml_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu i vona yana tovetutuyamavo 'waidie i vo, 'Ako matatabumi 'wa na degaloveku fai basenadiotoga Yaubada yana Buki nageneye i kilumi faifaimi i vo, Yaubada sifi 'adi To'isave'avina i na nikei i na wafa, nika sifi i na ve'aladegadega.’ ");
INSERT INTO yml_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Vonanina i kilumiga i na nikeku faifaina mogitana, siwe tutuyanina Yaubada i na sivetovoiku, a na kumeta a na nago Galili bei ta na veluaga.” ");
INSERT INTO yml_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Fita i vona-matayo'o i vo, 'Ai'edi tomotoga matatabudi i na degalovemu, we'e yau kebu a na degalovemuga.” ");
INSERT INTO yml_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu Fita i voneni i vo, A vona mogitana 'waimuye 'ako lovane tutuya 'aitonu 'u na bavusebeku mulieta kamukamu 'ana veluga i na kwage.” ");
INSERT INTO yml_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nika Fita i ve'awafatafata i vo, 'Ai'edi taiadi ta na wafaga i lubwaineku, siwe kebu a na vo, Yau Iesu kebu a da 'asetaiga.’” Ava'ai Fita i voneyeniga, enavo matatabudi wata bani'odi i vona. ");
INSERT INTO yml_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mulieta Iesu ma yana tovetutuyamavo i nagoi tamu wala'ai 'atumaina 'waineye 'ana wagava Gedesemani, bei yana tovetutuyamavo i vonedi i vo, Side bei 'wa na miabui 'wa na miamiani, yau sino bei a na nago a na velu'ui.” ");
INSERT INTO yml_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Tomotoga 'adi 'aitonu i vonedi taiadi i nagoi, Fita, Iemesa wata Ioni. Venuafouviga wata nuavita bwaikina Iesu i vebaeni i vonedi i vo, Yaku nuavita bwaikaotogina 'wa da vo nuafouku i da 'e'etokadia wata 'wainega sai'afoga a na wafa. Side bei 'wa na miamia kebu ta na 'enoga 'wa na 'isa'isa.” ");
INSERT INTO yml_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I vaganago i lumata'afufu i velu'ui Tamana 'waineye, 'ai'edi i na lubwaineniga 'ana vitanina i da 'ewai 'wainega. ");
INSERT INTO yml_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","I vo, Ie Tamaku, nani matatabuna 'waimuye safailidi, veviganina wata wafa 'u da 'ewadi 'waikuyega. Siwe 'asa'aiana, kebu yau yaku nuanuaga, 'omu yamu nuanua bega a na vematayakeyakenimo.” ");
INSERT INTO yml_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","I velu'ui i 'a'avana i vilai i nago yana tovetutuyamavo i 'isedi i 'eno'enovi. I luvagonidi Fita i voneni i vo, Saimoni, awale 'u 'eno'eno, 'u da 'isa'isa 'awasasa 'aitamogana. ");
INSERT INTO yml_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","'Wa na 'isa'isa wata 'wa na vevelu'ui bega tutuyanina Seitani i na vetalaimimilimi kebu 'wa na sakona. Nuanuami 'wa na 'ivaiseku siwe yami toketokena i mwea.” ");
INSERT INTO yml_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wata 'ana veluga Iesu i vaganago yana velu'uinina i luvaitugani. ");
INSERT INTO yml_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wata i vilai i mai yana tovetutuyamavo i 'isedi i 'eno'enovi fai matadi i duduna-'afo'afo. I luvagonidi siwe kebu tamu ava'ai i da voneyeniga fai i bunumayaga. ");
INSERT INTO yml_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Wata i vilai i nago i velu'ui, mulieta yana mai 'ana vetonu 'waineye yana tovetutuyamavo i luvagonidi i vonedi i vo, 'Omi 'alo 'wa 'eno'enovi? Sino 'wa 'isanaweni, 'aku to'etogiluva i le'wa. Yau a vetomotogaotoga yaku tutuya 'akonadi i le'wa bega i na 'aniveleneku tosakona yadi toketokena 'waineye. 'Wa tovoi ta na nagoi 'waidie.” ");
INSERT INTO yml_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bola Iesu i veveifufu nika Iudasa i mai, kumanina tamu Iesu yana tovetutuyamavo 12 'waidiega. 'Aila'a bwaikina taiadi i maia, ma yadi kefata wata fulumai, tovelomu yadi to'edakumetavo, ve'etoboda 'adi tovevo wata me Diu yadi to'edakumetavo 'au'auveadi i vetunedi i mai. ");
INSERT INTO yml_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","To'etogiluvanina yana tugusa 'akonadi 'aila'a i vona-vagasedi i vo, Tomogonina a na 'avalamaigiga, kumanina nuanuami, 'wa na 'ive'avini 'wa na naweni.” ");
INSERT INTO yml_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tutuyanina i le'wai, Iudasa tonovina i nago Iesu i 'avalamaigina i voneni i vo, Tove, kaiwa.” ");
INSERT INTO yml_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nika 'aila'a Iesu i tovififineni i 'ive'avini. ");
INSERT INTO yml_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iesu yana 'aila'a 'wainega tamu tomogo yana kefata i yo'ei tovelomu bwaikina yana tofolova igodi i da nikei, taniga'avana i tutuomuya. ");
INSERT INTO yml_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tomotoganidi i maia Iesu 'ana 'ive'avina faifaina i vonedi i vo, Yau 'wa da vo to'ainike bega 'wa maia ma yami kefata wata fulumai 'aku 'ive'avina faifaina. ");
INSERT INTO yml_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","'Aiata 'aitamogana 'aitamogana 'omi yau taiadi Vanuga 'Eba Velu'ui nageneye a veve siwe kebu bei 'wa da 'ive'avinikuga. We'e naninidi 'wa 'i'idewadiga 'waikuye nika ava'ai basenadiotoga Yaubada yana tolu'ivonavo i kilumi faifaiku yana Buki nageneye, 'adi mogitana i souyedi.” ");
INSERT INTO yml_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iesu i vona'a'avana yana tovetutuyamavo matatabudi i degalovei. ");
INSERT INTO yml_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Tamu tubuau 'ana kaleko manamanawena kebu ma 'ana iviga Iesu i yogo'waili, Iudasa yana 'aila'avo i 'iseni igodi i da 'ive'avini nika i yaiweili 'ana kaleko'ava i 'ewai, konekonena i dega. ");
INSERT INTO yml_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mulieta Iesu i mieni tovelomu bwaikina yana vanuge. Vanuganina 'waineye Diu yadi to'edakumetavo 'au'auveadi, tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo i va'auta Iesu yana vonayavuga i na vinenegeni. ");
INSERT INTO yml_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","We'e Fita i yogo'waila siwe 'ani'ieogose kebu lilivadie, i nago i luku vanuganina 'ana kali nageneye, tanotanoge i miabui tolugaviavo taiadi, 'ai i levaiga 'waineye i vevevala. ");
INSERT INTO yml_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Vanuganina nageneye tovelomu yadi to'edakumetavo wata me Diu yadi Kanisela matatabuna i lalauala, nuanuadi 'eba 'isa 'ifwaidi i na veluagadi nika 'adi fata Iesu i na vevitai bega i na luvewafai, siwe kebu tamu yana sakona i da veluagai. ");
INSERT INTO yml_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tomotoga fuedi i lu'ivona-vekavekali siwe yadi vonanidi kebu i da vesala. ");
INSERT INTO yml_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Mulieta 'ifwaidi i tovoi i vekali i vo, Tamu tutuya 'a nogai Iesu i vo, Vanuga 'Eba Velu'ui tomotoga i yogoniga a na geuya, 'aiata 'aitonu nagedie wata a na yogona-vaitugani, siwe kebu tomotoga 'adi 'a'aiyogona.’” ");
INSERT INTO yml_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Siwe tomotoganidi yadi vona tulina tulina, kebu i da vesala. ");
INSERT INTO yml_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tovelomu bwaikina i tovoi matadie Iesu i voneni i vo, I vevitamuga bonadi 'u na tutuli, i vona mogitana 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Siwe Iesu kebu tamu ava'ai i da voneyeniga i veve'wada. Wata tovelomu bwaikina i velutoli-vaitugana Iesu 'waineye i vo, Mogitana 'omu Keliso, Yaubada 'ana Venua'ivina wata Natuna, 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu i vo, Yau 'asa'aiana kumaniku. 'Awaie yau a vetomotogaotoga 'wa na 'iseku ma yaku veimea Yaubada Bwaikaotogina 'ana 'atagiega a na miabui wata abamayega a na obuobuma waowa 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Iesu yana vona faifaina tovelomunina ma yana kamogala 'ana talauma i silabu'i i vo, 'Wa nogai? I vona-uvi'agala Yaubada 'waineye, tovevita 'ifwaidi 'asa'aiana, kebu i na veifufuga. We'e 'omi 'wa da nuani, i na wafa 'alo kebu?” Kaniselavo matatabudi yana vona i tutuli i vo, Yana vonanina 'ana nogaya i lubwaineni i na wafa.” ");
INSERT INTO yml_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nika 'ifwaidi i 'ikiwakiwali i 'a'avana matana i umadi, nimadi i nunumidi i nikenikei wata i sidibidibieni i vo, 'Omu igodi tolu'ivona 'u da vonema, 'asiauotoga aitoi i nikemu?” I 'a'avana tolugaviavo i vagavaia i nunaweni i nikenikei. ");
INSERT INTO yml_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","We'e Fita i miamia tanotanoge, tamu vavine tovelomu bwaikina yana tofolova i souyeni i 'iseni i vevevala, i 'i'isadewai bega i voneni i vo, 'Omu tamu Iesu tomogo Nasaledi yana 'aila'a.” ");
INSERT INTO yml_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Siwe Fita i ve'ewa i vo, Yau kebu. Ava'ai 'u vonevoneyeniga kebu a da 'asetaiga.” Bega Fita i vaganago kali 'awaneye nika i nogai kamukamu i kwage. ");
INSERT INTO yml_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wata tofolovanina i 'iseni Fita i tovotovoi, 'ifwaidi tomotoga 'waidie i vo, Sino tomogonina, tamu Iesu yana 'aila'a.” ");
INSERT INTO yml_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Siwe Fita i ve'ewa-vaitugana i vo, Yau kebu.”'Awasasa 'ale'usana i 'a'ava wata 'ifwaidi tomotoga lilivaneye i tovotovoiga i voneni i vo, Mogitana, 'omu tamu Iesu yana 'aila'a fai 'u mai 'awalawa Galiliega.” ");
INSERT INTO yml_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nika Fita i ve'awafatafata i vo, 'Ai'edi a da vevekaliga Yaubada i da nikeku, we'e aigodi, tomogonina kebu a da 'aseta-tonovi.” ");
INSERT INTO yml_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Fita i vona'a'ava nika kamukamu 'ana veluga i kwage. I nogai i nuani Iesu yana vona i voneniga i vo, 'Ako lovane tutuya 'aitonu 'u na bavusebeku mulieta kamukamu 'ana veluga i na kwage.” Fita vonanina i nuani i taibwaubwau. ");
INSERT INTO yml_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","'Awa'awaiogose tovelomu yadi to'edakumetavo, to'edakumeta 'au'auveadi, ve'etoboda 'adi tovevo wata me Diu Kanisela 'ifwaidi taiadi i va'auta. Matatabudi i veifufu bega yadi nuanua 'aitamogana Iesu i yogoni i naweni i 'aniveleneni Loma kabemani yadi toveimea Failato 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bega Failato Iesu i velutolieni i vo, 'Omu me Diu yadi kini?” Iesu i vo, 'Asa'aiana 'u vona bani'odi.” ");
INSERT INTO yml_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Siwe tutuyanina tovelomu yadi to'edakumetavo i vevevita-maimaigiga Iesu kebu i da vonavona i veve'wadamo. ");
INSERT INTO yml_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Begaidi Failato i voneni i vo, I vevevitamuga nani tulina tulina 'waidiega 'u noganogai 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Siwe Iesu i baila, kebu nuanuana vonanidi i na tutulidi begaidi Failato nuana i vogani. ");
INSERT INTO yml_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Malamala 'aitamogana 'aitamogana me Diu i sakasakali Uvi'agalatagona faifaina. Sakalinina 'waineye me Diu tamu iadi yogoyogonina i vevenua'ivineni bega kabemani i 'e'etoyavuya vanuga yogona 'wainega. ");
INSERT INTO yml_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tutuyanina 'waineye tamu tomogo 'ana wagava Balaba i miamia vanuga yogona nageneye, kumanina toluvewafa, ma enavo i vetalaga Loma kabemani taiadi. ");
INSERT INTO yml_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tutuyanina Iesu i tovotovoi Failato mataneye, tomotoga fuedi i nagoi Failato 'waineye i velu'ui nuanuadi tamu tomogo i na 'etoyavuya Uvi'agalatagona 'ana sauluva bani'odi. ");
INSERT INTO yml_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Failato i 'asetai tovelomu yadi to'edakumetavo Iesu i ve'unumagigieni i 'aniveleneni 'waineye begaidi i vonedi i vo, Nuanuami me Diu yami kini a na 'etoyavuya?” ");
INSERT INTO yml_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Siwe tomotoga 'akonadi tovelomu yadi to'edakumetavo i nua'anidi bega Failato i na voneni Balaba i na 'etoyavuya we'e Iesu kebu. ");
INSERT INTO yml_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Failato i velutoli 'waidie i vo, Kumanina 'wa golegoleni me Diu yami kini, bani'odi a na munegi?” ");
INSERT INTO yml_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nika 'aila'a bwaikina i vegole i vo, 'U tutufwaseni 'ai lagalagana 'waineye bei i na wafa.” ");
INSERT INTO yml_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Wata Failato i velutoliedi i vo, Yana sakona ava'ai?” Siwe 'aila'anidi i toke i vegolegole i vo, 'U tutufwaseni 'ai lagalagana 'waineye.” ");
INSERT INTO yml_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Failato nuanuana tomotoga i na 'ivenua-agiagidi begaidi Balaba i 'etoyavuya, we'e i veimea tolugaviavo Iesu i na toke i na fitali mulieta i na naweni i na tutufwaseni 'ai lagalagana 'waineye, bega i na wafa. ");
INSERT INTO yml_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Vonayavuga i 'a'avana, tolugaviavo Iesu i naweni kabemani yadi vanuga bwaikina 'waineye, bei tolugavia matatabudi i va'auta. ");
INSERT INTO yml_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tolugavianidi talauma yamoyamoinega Iesu i ve'weseni wata 'ou'ou nigodi ma yana 'ibadi i 'etofifini 'unu'ununeye i biuleni. Vaigavunidi kini 'adi vaigavu bani'odi siwe 'wainega Iesu i sidibidibieni. ");
INSERT INTO yml_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bei i ve'ililibu-vekavekali 'waineye i vo, Kaiwa, 'omu me Diu yadi kini.” ");
INSERT INTO yml_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","'Uwe 'wainega 'unu'ununa i nikenikei, i 'ikiwakiwali wata igodi ma yadi ve'ililibu i 'odu'odu 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yadi saidibi i 'a'avana, talaumanina yamoyamoina i yavuya, taunina 'ana talaumayega i ve'weseni, mulieta i vagavaia i naweni i na tutufwaseni 'ai lagalagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tutuyanina Iesu i nunaweni 'edeye, tamu tomogo i veluagai 'ana wagava Saimoni, kwedayega i tauya i mimai Ielusalema. Saimoni tomogo Sailini, natunavo 'adi 'ailuga Alekisana wata Lufusa. Tolugaviavo Saimoni i lukakadeni Iesu 'ana 'ai lagalagana i eva. ");
INSERT INTO yml_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bega i nagoi i le'wa tamu 'awalawa 'waineye 'ana wagava Goligota, 'ana saivila 'Unu'unu. ");
INSERT INTO yml_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bei oine i 'idewai tamu konini 'ana wagava Mulo taiadi i veleni i na yemu bega 'ana kini'ona kebu i na veviga, siwe i baila veviganina faifaina i tauyeni. ");
INSERT INTO yml_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mulieta i tutufwaseni 'ai lagalagana 'waineye, i 'a'avana tolugaviavo nuanuadi Iesu 'ana talauma i na veusedi begaidi tamu 'wava i 'waveni bani'odi kate. 'Ai'edi aitoi i na kumetaga ava'ai talaumaga nuanuana i na 'ewai. ");
INSERT INTO yml_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Iesu i tutufwaseniga 'awa'awaie, 9 kiloki 'waineye. ");
INSERT INTO yml_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","'Ana 'ai lagalagana tabwaneye vonanina 'wainega i vevitaiga i kilumi i tutufwaseni. Vonanina i kilumiga side bani'odi. TOMOGO DE'E ME DIU YADI KINI. ");
INSERT INTO yml_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wata tovainago 'adi 'ailuga i tutufwasedi, tamu Iesu 'ana 'atagiega, tamu 'ana wamayega. ");
INSERT INTO yml_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nika 'ana mogitana i souyeni basenadi Yaubada yana Buki nageneye i kilumi vonanina i vo, Tomotoga i vo 'ako taunina tamu tosakona.” ");
INSERT INTO yml_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Tomotoga 'ai lagalagana lilivaneamo i nunagoi i veugalewalewa wata Iesu i yagayagaia i vo, 'Amu 'isa. 'Omu igodi Vanuga 'Eba Velu'ui 'u da sigeuya wata 'aiata 'aitonu nagedie 'u da vetovoia. 'Ai'edi vonanina mogitana, nika taunimu 'u na 'ita'ita'iemu, 'u na obuma 'ai lagalagana 'wainega.” ");
INSERT INTO yml_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","Wata bani'odi tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo 'aise'avadi i sidibidibieni i vo, Tomotoga 'ifwaidi i 'ita'ita'iedi, we'e taunina kebu 'ana fata i na 'ita'ita'ieni. Igodi Yaubada 'ana Venua'ivina wata me Isileli yada Kini. 'Ai'edi 'asiauotoga i da obuma 'ai lagalagana 'wainega ta da 'iseni ta da ve'awamogitana.” Wata tovainagonidi taiadi i tutufwasediga ma fuedie i manini. ");
INSERT INTO yml_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","'Aiata 'ana utukamwana 'waineye fwayafwaya matatabuna i dudubali, i nagoga 'ana tugusa lavilavie 3 kiloki i magetai. ");
INSERT INTO yml_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","'Awasasanina 'waineye Iesu i toke i vegole me Diu bonadiega i vo, Iloi, Iloi, lema sabakitani?”'Ana saivila i vo, Yaku Yaubada, yaku Yaubada, awale 'u bailaotogeku?” ");
INSERT INTO yml_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","'Ifwaidi tomotoga i tovotovoiga bonana i nogai i vo, 'Wa nogai? Ilaitia i golegoleni, nuanuana abamayega i na mai i na 'ivaiseni.” ");
INSERT INTO yml_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tamu tomogo i lilide i nago kikifa i lu'utuvi oine yuyuna 'waineye, tamu 'ai 'waineye i velugaganeni i 'iyoyoeni 'waineye, nuanuana Iesu i na yemu. Nika 'ifwaidi i vo, 'U ve'wada, nagami ta na 'iseni voke Ilaitia i mimai i na 'ita'ita'ieni.” ");
INSERT INTO yml_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mulieta Iesu i toke i vegole nika yawaina i 'awatagoni. ");
INSERT INTO yml_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Vanuga 'Eba Velu'ui nageneye tamu saiboda kaleko badubaduna 'wainega Yaubada yana tutudaba tabutabuotogina i sisibodai. Tutuyanina Iesu yawaina i 'a'avaga saibodanina i 'anilabu'alugedi, tabwanega i obu dibuneye. ");
INSERT INTO yml_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tolugavia 'adi to'edakumeta Iesu 'ana 'ai lagalagana lilivaneye i tovotovoi, i nogai Iesu yana vegole wata i 'iseni bani'odi i munega i wafa nika i ve'awamogitana i vo, Vona mogitana, taunina Yaubada Natuna.” ");
INSERT INTO yml_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wata 'ifwaidi vevine 'ani'ieyega i 'i'isanago 'ai lagalagana 'waineye. Vevinenidi 'waidiega, Salome, Meli 'atamana Magidala 'wainega wata tamu Meli, Iosese wata Iemesa inadi, Iemesa tamu 'ana wagava Nigolalaga. ");
INSERT INTO yml_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Vevinenidi 'adi 'aitonu Iesu 'ana to'aivaita tutuyanina i folofolova Galili. Wata 'ifwaidi vevine Iesu taiadi i maia Ielusalema 'waineye, ma fuedie i 'i'isanago. ");
INSERT INTO yml_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","'Akonadi i lavia Iosefa tomogo Alimadia i le'wa. Taunina tamu me Diu yadi Kanisela, tomotoga fuedi i ve'ililibuyeni wata Yaubada yana veimea yana mai fwayefwayeye i lulukamaseni. 'Aiatanina 'waineye Iesu i wafaga, Diu yadi 'Aiata 'Idewadewa, we'e 'awa'awai yadi tafalolo. Avinodi 'eba ilagi, siwe Iosefa tomogo Alimadia i vemata'ai'ai bega i nago Failato 'waineye, i velu'ui Iesu tomogona 'ana ta'i faifaina. ");
INSERT INTO yml_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tutuyanina Iosefa yana velu'ui Failato i nogai nuana i vogani i vo, Iesu 'akonadi i wafa?” Begaidi vona i vetunei tolugavia 'adi to'edakumeta 'waineye i mai i velutolieni i vo, Iesu 'akonadi i wafa?” ");
INSERT INTO yml_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tutuyanina Failato i 'asetai 'akonadi Iesu i wafa i tauyeni Iesu i na ta'ia. ");
INSERT INTO yml_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Bega Iosefa i nago talauma 'avu'avuna i kimwanei, mulieta Iesu tomogona i ta'ia talaumanina 'wainega i fania, i 'a'avana taumata basenadi i ala-vagaseni matumatu 'waineye bei Iesu i ve'ufai, kileu bababanega i vetubodai. ");
INSERT INTO yml_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Vevine 'adi 'ailuga matadie Iesu i ve'ufai, Meli 'atamana Magidala 'wainega wata tamu Meli Iosese inana. ");
INSERT INTO yml_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Inala i iniva nika me Diu yadi 'Aiata Veawai i 'a'ava, begaidi vevine 'adi 'aitonu i nagoi bunama magaina 'atumaina i kimwanei Iesu tomogona faifaina. Vevinenidi Meli 'atamana Magidala 'wainega wata tamu Meli Iemesa inana wata Salome. ");
INSERT INTO yml_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tafalolo 'awa'awaiogose inala be'ama i vulaoga, vevinenidi i tovoi i nagoi taumaseye. ");
INSERT INTO yml_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","I nunagoi 'edeye 'aise'avadi i veveifufu i vo, Aitoi kileu bwaikaotogina i da ketoi taumata 'awanega?” Siwe i 'isanago i 'iseni kileu ketoketona. ");
INSERT INTO yml_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Vevinenidi i maia i luku taumata nageneye tamu tubuau 'ana talauma 'avu'avuna 'atagiega i miabui i 'iseni nika i kololo-'afo'afo. ");
INSERT INTO yml_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Anelosenina vevine i vonedi i vo, Kebu 'wa na kolologa, a 'asetami Iesu tomogo Nasaledi kumanina i tutufwaseniga 'ai lagalagana 'waineye 'wa lulualeni, siwe 'akonadi wafayega i tovoi. De'e bei kebu i da miamiaga. 'Wa 'iseni 'ana 'ivi'ava. ");
INSERT INTO yml_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","We'e 'omi 'wa na nagoi yana tovetutuyamavo wata Fita taiadi 'wa na vonedi 'wa na vo, Iesu i kumekumeta Galili, 'wa na nagoi nika bei 'wa na veluagai, basenadi i vonemiga bani'odi.’” ");
INSERT INTO yml_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Vevinenidi i souyedi taumatayega i dega ma yadi tatava wata ma yadi nuavogana. Kebu tamu aitoi 'waineye i da veifufu fai i kololo. ");
INSERT INTO yml_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesu i tovoi-vaitugana Tafalolo 'awa'awaiogose. Nagami i souyeni Meli 'waineye, kumanina 'atamana Magidala 'wainega, basenadi yaiaina 7 i agei siwe Iesu i vona i 'awa'a'ia. ");
INSERT INTO yml_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","I 'iseni i 'a'avana, i nago yana tovetutuyamavo i na vonedi siwe i le'wa i 'isedi i vevemogai. I vonedi i vo, 'Wa ve'wada, Iesu 'akonadi i tovoi-vaitugana, yau taiadi a veluaga.” I nogai siwe kebu i da ve'awamogitana. ");
INSERT INTO yml_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mulieta Iesu yana tovetutuyamavo 'adi 'ailuga Ielusalema 'wainega i tauya i nunagoi tamu 'awalawa kebu 'atamananinaga 'waineye. 'Edeye Iesu i souyeni 'waidie, siwe i vemaigisivilavila. ");
INSERT INTO yml_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","I 'iseni wata taiadi i veifufu, mulieta i viladi 'ifwaidi ediavo 'waidie i lu'ivona siwe kebu i da vetumaganediga. ");
INSERT INTO yml_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tamu 'aiata Iesu yana tovetutuyamavo 11 i 'ani'ani nika 'awasasadie Iesu i souyeni i vonedi i vo, Awale nuamiega 'wa kibu? Egavo i 'iseku a tovoi-vaitugana siwe yadi vona kebu 'wa da vetumaganedi.” ");
INSERT INTO yml_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wata i vonedi i vo, 'Wa na nagoi tomia fwayafwaya matatabuna 'waidie, Vala 'Atumaina faifaiku 'wa na lu'ivona 'waidie. ");
INSERT INTO yml_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","'Ai'edi aitoi ma yana vetumagana taunina i na tauyeni 'waikuye i na bafitaiso, Yaubada i na 'ita'ita'ieni. We'e 'ai'edi aitoi kebu i na vetumaganeku, Yaubada i na veimea vematavuloga i na veluagai. ");
INSERT INTO yml_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","'Ai'edi egavo i na vetumaganeku veimea a na veledi bega 'eba 'isa toketokedi i na 'i'idewadi. 'Aku wagavayega i na vona yaiaina 'waidie i na 'awa'a'idi wata 'adi fata i na veveifufu bonanidi basenadi kebu i da 'asetadiga 'waidiega. ");
INSERT INTO yml_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wata 'ai'edi 'o'olo dabadabana i na 'abitonovidi kebu i na ovadiga wata 'ai'edi aitoi ufa toketokena 'eba wafa i na veyemudi, kebu i na wafaga. We'e toviga i na 'abitonovidi i na ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iesu yana tovetutuyamavo 'waidie i veifufu'a'ava, nika Yaubada i vagavaia i laka abame ma yana veimea 'ana 'atagiega i miabui. ");
INSERT INTO yml_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","'Akonadi Iesu i 'iawedi tovetutuyamavo i yavula 'atamana matatabuna 'waidie i lau'age. Yadi 'Auvea yana toketokena 'wainega i folofolova bega yadi folova ma 'adi 'eba 'isa toketokedi, tomotoga fuedi i 'isedi i ve'awamogitana yadi lau'age faifaidi. ");
INSERT INTO yml_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Iaku Tiofilo, 'omu toveimea bwaikimu. 'Akonadi 'u 'asetadi nani 'ifwaidi i souyediga 'waideye tutuyanina Iesu i miamia fwayefwayeye. Tomotoga fuedi naninidi 'eba velamuyega i 'isedi i nagoga 'eba ve'a'ava 'waineye, 'akonadi i lu'ivoneyedi. 'Ifwaidi tomotoga nuanuadi i na kiluma Iesu valana faifaina bega i nagoi i na veifufu tomotoganidi basenadi Iesu taiadi i folofolovaga 'waidie, bega ma yadi 'aseta 'adi fata i na kiluma-'atumaia. ");
INSERT INTO yml_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yau basenadi wata 'asiau tomotoganidi yadi kiluma a lu'iawawa-dewadi, begaidi nuanuaku Iesu Valana matatabuna a na kiluma-vedulei nika 'ana fata 'u na lu'iawawai. ");
INSERT INTO yml_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Basenadi vala'avadi 'u nogaidi, we'e yaku kiluma de'e 'wainega 'u na lu'iawawaiga 'u na 'aseta-'atumaia wata 'u na ve'awamogitana. ");
INSERT INTO yml_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Side bani'odi. Tutuyanina Kini Elodi i veveimea 'awalawa Iudia 'waineye, tamu me Diu yadi tovelomu i miamia 'ana wagava Sekalaia. Taunina Ebaya yana 'aila'a taiadi i folofolova Vanuga 'Eba Velu'ui 'waineye. Yana vavine 'adi wagava Elisabeti, 'adi 'ailuga Eloni 'ana wauma 'wainega. ");
INSERT INTO yml_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sekalaia wata Elisabeti yadi sauluva tonovina Yaubada mataneye, yana ve'etoboda wata yana veimea matatabuna i vevematayakeyakedi. ");
INSERT INTO yml_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabeti kakalidi i vemo'ai wata Sekalaia i ve'auvea begaidi kebu tamu natudiga. ");
INSERT INTO yml_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tamu tutuya Sekalaia ma yana 'aila'a tovelomu yadi tutuya i veluagai, i folofolova Vanuga 'Eba Velu'ui 'waineye Yaubada mataneye. ");
INSERT INTO yml_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tovelomu yadi folova 'ana awave'eda'eda 'wainega, Sekalaia i venua'ivineni bega i na luku 'Auvea yana tutudaba tabutabuna 'waineye, vane magaina 'atumaina i na kabuni. 'Eda'edanina 'wainega kileu ma 'adi wagava i vevefolovedi bega tamu tovelomu i na sivemageseni folovanina faifaina. ");
INSERT INTO yml_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tutuyanina vane i kabukabuni, me Diu 'aila'a 'akonadi i va'auta tanotanoge i vevelu'ui. ");
INSERT INTO yml_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nika tamu 'Auvea yana anelose i souyeni i tovoi 'atagiega 'eba velomu lilivaneye. ");
INSERT INTO yml_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekalaia i 'iseni nuana i vogani i kololo-'afo'afo. ");
INSERT INTO yml_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","14","Siwe anelosenina i vo, Sekalaia, kebu 'u na kolologa. Yaubada 'akonadi yamu velu'ui i nogai. Yamu vavine natumu iavetana i na venatuneni 'u na goleni Ioni bega 'omu ma yamu vavine wata tomotoga fuedi taiadi 'wa na sosoana yana tubuga faifaina. ");
INSERT INTO yml_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","'Wa na sosoanaga fai natumunina bola kumanina tomogo bwaikina Yaubada mataneye. We'e ufa toketokena bani'odi oine kebu i na yemudiga. Tutuyanina i na tubuga bei 'Anu'anunu Magemagetana i na age-vagaseni. ");
INSERT INTO yml_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wata taunina me Isileli fuedi 'adi tovagavai, i na miedi 'Auvea yadi Yaubada 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Taunina 'awaie kebu i na kolologa, ma yana venuafoufa'ala i na vetomata'aulele 'Auvea faifaina, yana toketokena wata yana nuanua bani'odi Yaubada yana tolu'ivona Ilaitia. Yana lau'age 'wainega kwakwama tamadiavo yadi nuanua i na siviladi bega natudiavo i na nuakalikaliedi. We'e tovedumwe'ai'ai i na nuaviladi sakona 'wainega, ma'itufa nuamageta i na 'ewai tomotoganidi yadi sauluva tonovidi 'waidiega. Side bani'odi natumu tomotoga i na 'idewadi 'Auvea yana mai faifaina.” ");
INSERT INTO yml_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekalaia anelose i velutolieni i vo, Bani'odi a na munega bega a na 'asetai, 'u vonavona mogitana 'alo 'u vevekali? Yau a ve'auvea wata yaku vavine i vemo'ai. Tamu 'eba 'isa 'u da veleku.” ");
INSERT INTO yml_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anelosenina i vo, Yau Gabalieli, Yaubada yana tofolova, tutuya fuedi mataneye a tovotovoi. Kumanina i vetuneku vala 'atumaina a mieni a lulu'ivoneyeni 'waimuye. ");
INSERT INTO yml_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Fai yaku vona kebu 'u da vetumaganeniga, tutuya de'e ma'awa'ulumu 'ana tugusa natumu i na tubuga bei 'u na welava-vaitugana. Valanina a vonemuga, 'awaie 'ana tutuya mogitana i na veluagai nika i na souyeni.” ");
INSERT INTO yml_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","We'e tomotoga matatabudi tanotanoge i lulukamata 'awasasa manamanawena, nuadi i voganidi i vo, Awale Sekalaia yana mia i vemanawe Vanuga 'Eba Velu'ui nageneye?” ");
INSERT INTO yml_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tutuyanina Sekalaia i souyeni kebu 'ana fata i na welava fai 'awana i ve'u'u'u bega tomotoga i 'asetai 'ana ve 'wainega tamu nani i 'iseni tutudaba tabutabuna nageneye. Begaidi nimanega i veifufu 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mulieta Sekalaia yana folova 'adi 'aiata i ve'a'avadi i vilai i nago yana vanuge. ");
INSERT INTO yml_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","'Aiata 'ifwaidi i 'a'ava, mulieta Elisabeti i miana begaidi kebu i da yabayaba i miamia yadi vanuge weta'i 'adi 5. ");
INSERT INTO yml_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Begaidi Elisabeti i vo, Tutuya de'e Yaubada i nuakalikaliema bwaikina. I 'ivaisema bega 'a miana, kakala 'ana bunumayaga 'waimega i 'a'ava.” ");
INSERT INTO yml_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeti yadi miana 'ana weta'i 'ana ve-6 'waineye, Yaubada yana anelose Gabalieli i vetunei abamayega i mai 'atamana Nasaledi 'awalawa Galili nageneye. ");
INSERT INTO yml_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","I maiga tamu vavine ne'e'elina 'ana wagava Meli 'waineye, 'akonadi i veakutagoni tamu tomogo 'ana wagava Iosefa faifaina. Tomogonina Kini Devida 'ana wauma 'wainega i souyeni. ");
INSERT INTO yml_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anelose i mai i vo, Kaiwa Meli, 'Auvea 'amu 'weabu i nuakalikaliemu bwaikina.” ");
INSERT INTO yml_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meli nuana i vogani bega nuana i 'ivina vonanina 'ana 'aseta bani'odi. ");
INSERT INTO yml_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anelosenina i vo, Meli, kebu 'u na kolologa, Yaubada yana nuakalikali bwaikaotogina 'waimuye i 'eno'eno. ");
INSERT INTO yml_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Begaidi a na vonemu, sai'afoga 'u na miana mulieta natumu iavetana 'u na venatuneni 'ana wagava 'u na goleni Iesu. ");
INSERT INTO yml_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Taunina tomogo bwaikaotogina, tomotoga i na 'ina'inanai i na vo, Yaubada Tabwaotogineye Natuna.’ We'e 'Auvea Yaubada i na silakai i na ve-kini tubuna Devida bani'odi, wata Iakobo 'ana wauma taunidi me Isileli i na veveimea-vagata 'waidie we'e yana 'Eba Veimea kebu 'ana 'eba ve'a'avaga.” ");
INSERT INTO yml_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meli anelose i voneni i vo, Bani'odi a na munega a na miana, fai yau ne'e'eliku kebu tamu aitoi taiadi a da veluaga?” ");
INSERT INTO yml_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anelose Meli yana vona i tutuli i vo, 'Anu'anunu Magemagetana i na agemu wata Yaubada yana toketokena i na ve'i'wa'uyemu. Begaidi kwamana 'u na venatuneni magemagetana, tomotoga i na 'ina'inanai i na vo, Kumanina Yaubada Natuna.’ ");
INSERT INTO yml_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'U na nuani nibaimu Elisabeti i vo, 'A kakala wata 'a vemo'ai, kebu 'ama fata 'a na venatunaga.’ Siwe 'akonadi yadi miana 'ana weta'i 6 i veluagai. ");
INSERT INTO yml_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Fai nani matatabuna Yaubada 'ana sala.” ");
INSERT INTO yml_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meli i vo, Yau 'Auvea yana tofolova, ava'ai 'u voneyeniga 'waikuye 'ana mogitana i da souyeni.” Nika anelose Meli i 'iaweni. ");
INSERT INTO yml_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","'Aiata 'ifwaidi i 'a'ava Meli i 'idewadewa nika i tauya i nago 'oya siaidi 'waidie 'awalawa Iudia nageneye Elisabeti i na fogedi. I le'wa 'atamananina bei Sekalaia i miamia i luku yana vanuge i vekaiwa Elisabeti 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Tutuyanina Elisabeti Meli yana vekaiwa i nogai kamodie kwamana i feto bwaikina. 'Anu'anunu Magemagetana Elisabeti i agedi mogitana begaidi bonadi bwaikinega i vo, Nibai, Yaubada i nuakalikaliemu bwaikina, vevine matatabuda 'waidega kebu tamu aitoi bani'odi 'omu'e. Natumunina 'u na venatuneniga Yaubada ma yana nuakalikali i na vesauluva 'atumaina 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Wata Elisabeti i vo, Nani 'atumaiotogina 'waimeye fai yama 'Auvea inana 'u mai 'ama foge faifaina. ");
INSERT INTO yml_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tutuyanina yamu vekaiwa 'a nogai, kwamana kamomeye ma yana sosoana i feto bwaikina. ");
INSERT INTO yml_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","We'e 'omu, 'Auvea yana vona 'u vetumaganeni 'ana mogitana i na souyeni, 'eba sosoana 'waimuye.” ");
INSERT INTO yml_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meli i vo, Nuakuyega 'Auvea a subisubiai. ");
INSERT INTO yml_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yaubada taunina 'aku To'ita'ita'i, faifaina 'anu'anunuku i sosoana-'afo'afo. ");
INSERT INTO yml_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yau kwamana siaiku ma yaku nuaobu a vetofolova-maimaiga 'waineye, siwe i nunuave'aviniku. 'Asiau wata tutuya i mimai 'aila'a 'aitamogana 'aitamogana faifaiku i na vo, Mogitana Yaubada i vesauluva 'atumaina 'waineye.’ ");
INSERT INTO yml_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","I na vonaga fai Yaubada Toketokena, kumanina magemagetana, faifaiku nani bwaikidi i 'idewadi. ");
INSERT INTO yml_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tutuya matatabuna lakata 'aitamogana 'aitamogana 'waidiega egavo Yaubada i veve'ililibuyeniga i 'i'isanuakalikaliedi. ");
INSERT INTO yml_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","We'e tomotoganidi i nunualakaga wata taunidi i awa'ai'aidiga, nimana yana toketokena 'wainega i luveyavulidi. ");
INSERT INTO yml_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Toveimea toketokedi yadi 'eba mia 'ai'aiwabudi 'waidiega i siobuyedi, we'e tonuaobu i silakaidi. ");
INSERT INTO yml_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wata tovewekowekoma, nani 'atumaidi i veledi bega i sososoana, we'e 'ai'aiwabudi i veviladi nima'ava'avadi, kebu tamu ava'ai i da veledi. ");
INSERT INTO yml_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yaubada i vona'awaufaufa tubudavo 'waidie kebu i na bailedi. Vona'awaufaufanina Ebelamo 'waineye wata 'ana wauma 'waideye kebu i na 'a'avaga i na 'eno-vagata. Begaidi 'ida me Isileli yana tofolovavo i 'ivaiseda, kebu i da venuafanida we'e mogitana i 'i'isanuakalikalieda.” ");
INSERT INTO yml_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meli yana vona i 'a'ava, bei Elisabeti taiadi i miamia bani'odi weta'i 'aitonu, mulieta i vilai i nago yana 'atamane. ");
INSERT INTO yml_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Meli i nago mulieta Elisabeti i vebutudi fai yadi tutuya i veluagai, i venatuna natudi iavetana i tubuga. ");
INSERT INTO yml_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tutuyanina ediavo wata yadi 'aila'avo valadi i nogai 'Auvea i 'isanuakalikaliediga, ma fuedi i sosoana. ");
INSERT INTO yml_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Mulieta kwamana yana tubuga 'ana 'aiata 8 i veluagai, ediavo wata yadi 'aila'avo i va'auta bununa i na boboi me Diu yadi sauluva bani'odi. Igodi nuanuadi i na goleni tamana wagavina Sekalaia, siwe inana i talaboda i vo, Kebu, ta na goleni Ioni.” ");
INSERT INTO yml_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Siwe ediavo i vo, We'e wagavanina kebu tamu aitoi yami 'aila'a nageneye 'ana wagava.” ");
INSERT INTO yml_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Begaidi nimadiega Sekalaia i velutolieni ava'ai wagavaga nuanuana i na goleni. ");
INSERT INTO yml_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekalaia nimanega i vonedi nuanuana lubulubu i na mieni bei wagava i na kilumi. Lubulubu i 'ewai i kilumi i vo, 'Ana wagava Ioni.” Fuedi i 'iseni nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tutuyanina kwamana 'ana wagava i kiluma'a'avai, nika Sekalaia meana i tonova wata i welava-vaitugana, Yaubada i subiai. ");
INSERT INTO yml_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Enavo i 'iseni nuadi i voganidi, bega valana i lulu'ivoneyeni 'oya 'ana tomia 'waidie 'awalawa Iudia nageneye. ");
INSERT INTO yml_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tomotoganidi kwamana valana i nogaiga nuadi i 'ivina wata tauni'avadi i velutoli i vo, Bola kwamana yana folova ava'ai?” Bani'odi i voneyediga fai 'Auvea yana nuanua wata yana toketokena 'waineye i 'eno'eno. ");
INSERT INTO yml_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","68","'Anu'anunu Magemagetana Ioni tamana Sekalaia i agei mogitana begaidi i vona-samula tutuya i mimai faifaina i vo, 'Auvea ta na subisubiai, taunina me Isileli yada Yaubada fai 'akonadi i 'ivaiseda wata i 'ita'ita'ieda. ");
INSERT INTO yml_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","'Ada To'ita'ita'i Toketokena Yaubada i silakai faifaida yana tofolova Kini Devida 'ana wauma 'wainega. ");
INSERT INTO yml_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Basenadiotoga Yaubada i vona'awaufaufa yana tolu'ivona magemagetadi 'waidiega i na 'ita'ita'ieda 'ada gaviavo 'waidiega wata taunidi i vedumwe'ai'aiedaga yadi toketokena 'waidiega. ");
INSERT INTO yml_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","I vona'awaufaufa tubudavo 'waidie i na 'isanuakalikaliedi, yana veakutagonanina magemagetana kebu i da venuafania. ");
INSERT INTO yml_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Veakutagonanina Yaubada i 'idewai tubuda Ebelamo 'waineye yana vona'awaufaufa toketokena 'wainega. ");
INSERT INTO yml_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","I na 'ita'ita'ieda 'ada gaviavo 'waidiega bega kebu tamu ava'ai ta na kololoyeni. Wata yana 'aivaitanina 'wainega 'ada fata ta na vetofolova faifaina, tutuya matatabuna yada sauluva tonovidi wata magemagetadi mataneye.” ");
INSERT INTO yml_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wata Sekalaia i vona-samula natuna faifaina i vo, We'e natuku, i na golemu Yaubada Tabwaotogineye yana tolu'ivona, fai 'Auvea yana 'eda 'u na vusia. ");
INSERT INTO yml_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yana tomotoga 'waidie 'u na mata'aulele yadi sakona i na vedumwe'ubu'ubusedi bega Yaubada i na nuatavunidi nika 'ita'ita'i i na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Nani de'e matatabuna i na souyeni fai yada Yaubada i 'isanuakalikalieda bwaikina wata 'ita'ita'i sai'afoga i na mai abamayega bani'odi mageta, bega egavo wafa faifaina i kolokolologa wata dudubala 'waineye i miamianiga i na magesedi. Magetanina i na kumeseda bega yada mia i na ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kwamananina i taulai toketokena wata yana nuanua matatabuna i tauyedi Yaubada 'waineye. Sali'avu'avuye i miamia, mulieta i souyeni yana folova i velamu me Isileli 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tutuyanina Ioni siaineye me Loma i veveimea me Diu yadi 'awalaweye. Yadi toveimea bwaikaotogina 'ana wagava Sisa Agosito, i veimea nuanuana 'atamana 'aitamogana 'aitamogana 'adi tomotogavo 'adi wagava i na kilumidi senisisi faifaina. ");
INSERT INTO yml_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","3","Veimea de'e i velamu-vauvau tutuyanina Kwilinio 'awalawa Silia 'ana toveimea yana tutuye, bega tomotoga matatabudi i nagoi 'adi tuvada 'waidie 'adi wagava i na kilumidi. ");
INSERT INTO yml_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iosefa i souyeni Kini Devida 'ana wauma 'wainega i miamia 'atamana Nasaledi, 'awalawa Galili nageneye. Bega i tovoi i nago Devida 'ana tuvadeye 'ana wagava Bedeliema, 'awalawa Iudia nageneye. ");
INSERT INTO yml_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Meli kumanidi basenadi i veakutagonidi siwe bola kebu Iosefa taiadi i da vemialuga ma vitavitadie wata taiadi i nago 'adi wagava i na kilumidi. ");
INSERT INTO yml_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tutuyanina Bedeliema 'waineye i miamia nika Meli i vebutudi, fai yadi tutuya 'akonadi i le'wa. ");
INSERT INTO yml_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Fai vanuga wakawaka i luvaidi kebu tamu 'awasasa bei i na luku, i nago 'aisaya yadi vanuge bei i venatuna, yadi tubu'edakumeta natudi iavetana i tubuga. Kwamana i velu'uvai mwedamwedalidi 'adi kalekoyega wata i ve'enovi bulumakau 'adi ta'ule. ");
INSERT INTO yml_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","9","We'e Bedeliema lilivaneye to'isave'avinavo yadi sifi i lulumadu'aiedi gidegideye, nika lovane tamu 'Auvea yana anelose i souyeni 'waidie wata 'Auvea yana mageta mataududulina i magesedi begaidi i kololo bwaikina. ");
INSERT INTO yml_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nika anelosenina i vo, Kebu 'wa na kolologa, yau a maiga vala 'atumaina a mieni 'waimie, bega tomotoga fuemi 'wa na sosoana bwaikina. ");
INSERT INTO yml_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","'Asiau 'ami To'ita'ita'i Bedeliema 'waineye i tubuga, taunina Toveimea Keliso, Yaubada 'ana Venua'ivina. ");
INSERT INTO yml_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yami tugusa 'wa na 'iseni mwedamwedalidi 'adi kalekoyega i velu'uvai i ve'enovi 'aisaya 'adi ta'ule, bega 'wa na 'asetai taunina kwamananina.” ");
INSERT INTO yml_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","I veifufu'a'ava nika enavo 'aila'a bwaikina i souyedi 'waineye ma fuedie Yaubada 'waineye i lei-subisubia i vo, ");
INSERT INTO yml_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Abama tabwaotogineye Yaubada ta na subisubiai, we'e fwayefwayeye tomotoganidi faifaidi Yaubada i sososoana i na mia 'atumaina.” ");
INSERT INTO yml_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tutuyanina anelosenidi i viladi abame, 'aisaya 'adi to'isave'avinavo 'aise'avadi i veifufu i vo, Ta na nagoi Bedeliema, naninina 'akonadi i souyeni faifaina 'Auvea i vonedaga ta na 'iseni.” ");
INSERT INTO yml_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bega i tovoi i lilide i nagoi Iosefa ma yana vavine i veluagadi wata kwamana i 'iseni 'aisaya 'adi ta'ule i ve'enovi i 'eno'eno. ");
INSERT INTO yml_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kwamana i 'iseni tamana wata inana 'waidie i veifufu ava'ai anelose i vonediga kwamananina faifaina. ");
INSERT INTO yml_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","We'e 'ifwaidi tomotoga valanina i nogaiga nuadi i voganidi 'aisaya 'adi to'isave'avinavo yadi veifufu faifaina. ");
INSERT INTO yml_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","We'e Meli vonanidi matatabuna i nuave'avinidi faifaidi nuadi i 'ivi'ivina. ");
INSERT INTO yml_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","To'isave'avina sifi i viladi yadi 'aisaya 'waidie, Yaubada i subisubiai wata i awa'ai'aia ava'ai i 'isediga wata i nogaidiga faifaidi, fai anelose yana veifufu 'waidie 'ana mogitana i souyeni. ");
INSERT INTO yml_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kwamana yana tubuga 'wainega i maiga 'ana 'aiata 8 'waineye bununa i boboi wata 'ana wagava i goleni Iesu. Basenadi Meli kebu i da mianaga, anelose wagavanina i voneni. ");
INSERT INTO yml_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Mulieta Meli wata Iosefa Iesu i naweni Ielusalema bega i na 'aniveleneni Yaubada 'waineye wata i na velomu. I nagoiga fai basenadiotoga Mosese Yaubada yana veimea i kilumi i vo, Kwakwama iavetadi yami tubu'edakumeta 'aitamogana 'aitamogana 'wa na 'anivelenedi 'Auvea 'waineye.” Wata i vo, Bunebune 'ailuga 'alo kabututula siaidi 'ailuga 'wa na nikedi 'wa na velomuyedi 'Auvea 'waineye kwamana wata inana taiadi faifaidi.” Meli vauvaudi begaidi yadi tutuya i veluagai Iosefa taiadi i laka Vanuga 'Eba Velu'ui 'waineye i na tafalolo bega i na vevunavunaga Yaubada mataneye. ");
INSERT INTO yml_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tutuyanina 'waineye tamu tomogo 'au'auveana i miamia Ielusalema, 'ana wagava Simioni. Taunina tomogo 'atumaina wata tove'ililibu Yaubada 'waineye, ma yana tokemaiga i lulukamata Yaubada 'ana Venua'ivina yana mai faifaina bega me Isileli i na 'ita'ita'iedi. ");
INSERT INTO yml_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","'Anu'anunu Magemagetana 'ana 'weabu bega i veni nagami 'Auvea 'ana Venua'ivina Keliso i na 'iseni mulieta i na wafa. ");
INSERT INTO yml_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","'Aiatanina 'waineye 'Anu'anunu Magemagetana Simioni i voneni i luku Vanuga 'Eba Velu'ui 'waineye, we'e kwamana Iesu inana wata tamana i mieni Vanuga 'Eba Velu'ui 'waineye bei Iesu i na 'aniveleneni 'Auvea 'waineye yadi veimea 'ana sauluva bani'odi. ");
INSERT INTO yml_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioni kwamana i olia i vekaiwa Yaubada 'waineye i vo, ");
INSERT INTO yml_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","'Auvea, 'asiau 'u na tauyeku ma yaku sosoana a na wafa, fai yamu vona'awaufaufa 'waikuye 'akonadi matakuyega a 'iseni. Kwamananina 'ama To'ita'ita'i 'u vetunei tomotoga fuema faifaima. ");
INSERT INTO yml_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Taunina bani'odi mageta mali tomotoga kumanidiavo kebu Diu 'waidie bega yamu nuanua i na 'asetadi, We'e 'ima yamu tomotoga me Isileli 'ama subia 'a na veluagai kwamananina 'wainega, fai yama 'aila'a 'wainega i souyeni.” ");
INSERT INTO yml_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","We'e Meli wata Iosefa nuadi i voganidi Simioni yana veifufu kwamana 'waineye faifaina. ");
INSERT INTO yml_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Mulieta Simioni i velu'ui bega Yaubada i na vesauluva 'atumaina Meli wata Iosefa 'waidie, i 'a'avana Meli i vonedi i vo, Kwamana de'e Yaubada i venua'ivineni bega 'wainega me Isileli fuedi 'ita'ita'i i na veluagai we'e 'ana tovedumwe'ai'ai fuedi vita i na veluagai 'wainega. Taunina 'eba 'isa Yaubada 'wainega siwe fuedi i na awavesakoyeni nika bei yadi nuagiva i na sivemagesedi. We'e 'omi Meli, yadi vedumwe'ai'ai faifaina 'wa na nuavita bwaikina 'wa da vo nuafoumi i da 'e'etokadia kefatayega.” ");
INSERT INTO yml_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Wata tutuyanina 'waineye tamu Yaubada yana tolu'ivona vevinedi i miamia Vanuga 'Eba Velu'ui nageneye, 'adi wagava Ana. Tamadi Fenueli, Asa 'ana wauma 'wainega. Ne'e'elidie i nagi i miamia malamala 7, nika yadi lamoga i wafa i 'wabula siwe yadi miayega malamala 84 i veluagai i vemo'ai mogitana. 'Wabulanidi kebu Vanuga 'Eba Velu'ui i da 'ia'iaweniga, 'aiata wata lovana i 'odu'odu Yaubada 'waineye, i vevelu'ui wata i veve'udigana 'ani 'wainega bega yadi velu'ui 'waineye i na vetoketoke. ");
INSERT INTO yml_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tutuyanina Simioni i veveifufu Iosefa Meli taiadi 'waidie, Ana i mai Yaubada 'waineye i vekaiwa, wata 'ifwaidi me Ielusalema 'waidie i veifufu kwamananina faifaina i vo, Kwamana de'e 'ada To'ita'ita'i kumanina ta lulukamaseni.” ");
INSERT INTO yml_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Veimeanidi Yaubada 'wainega i maiga, 'akonadi Iosefa wata Meli i 'idewa'a'avadi, mulieta i viladi yadi 'atamane Nasaledi 'awalawa Galili nageneye. ");
INSERT INTO yml_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kwamananina i taulai ma yana toketokena, ma yana nuamageta wata Yaubada ma yana nuakalikali i vevesauluva 'atumaina 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Malamala 'aitamogana 'aitamogana Iesu inana wata tamana yadi sauluva bani'odi i lakalaka Ielusalema, me Diu yadi Sakali Uvi'agalatagona faifaina. ");
INSERT INTO yml_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tutuyanina Iesu 'ana malamala 12 'waineye taiadi i laka sakalinina faifaina. ");
INSERT INTO yml_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","'Aiata 'ifwaidi i miamia Ielusalema 'waineye, tutuyanina sakali i 'a'ava tomotoga matatabudi i vilaviladi yadi 'atamane, we'e Iesu Ielusalema bei i miamia. Tamana wata inana kebu i da 'asetaiga, yadi nuanua i vo 'ako yadi 'aila'avo taiadi i kumeta. 'Aiata 'aitamogana i nunagoi mulieta i lovani nika Iesu kebu i da veluagaiga, bega i velamu i lauala yadi 'aila'avo wata ediavo 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","46","Nika kebu'a, wata i viladi Ielusalema bei i luala, mulieta 'aiata 'aitonu i 'a'avana i veluagai Vanuga 'Eba Velu'ui nageneye, Diu yadi ve'etoboda 'adi tovevo taiadi i miamiani. Ma fuedie i veveifufu yadi vona i vivinenegedi wata i velutolitoliedi. ");
INSERT INTO yml_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Fuedi i 'iseni yana 'aseta bwaikina wata i nogai Iesu yana tutula 'atumaidi wata tonovidi begaidi nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","We'e inana tamana taiadi i 'iseni nuadi i voganidi, bega inana i vo, Natuku awale we'e bani'odi yamu sauluva, bega ma yama venuafouviga tamamu taiadi 'a lulualemu?” ");
INSERT INTO yml_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iesu i vo, Awale mali vanuga 'waidie 'wa lauala-maimaiga? 'Wa da 'asetai i lubwaineku a na miamia Tamaku yana vanuge.” ");
INSERT INTO yml_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Siwe inana wata tamana yana veifufu faifaina kebu nuadi i da magetai. ");
INSERT INTO yml_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nika Iesu inana tamana taiadi i souyedi i nagoi Nasaledi, bei yadi veimea i vevematayakeyakedi. We'e inana nuadi i 'ivi'ivina naninidi faifaidi. ");
INSERT INTO yml_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bei Iesu i taulai, ma tomogona wata yana nuamageta taiadi, ma 'ana nuakalikali Yaubada 'wainega wata tomotoga 'waidiega. ");
INSERT INTO yml_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Me Loma yadi toveimea bwaikina 'ana wagava Sisa Taibilio, yana vetoveimea 'ana malamala 15 'akonadi i veluagai, Yaubada yana vona i mai Ioni Tobafitaiso 'waineye, kumanina Sekalaia natuna i miamia sali'avu'avuye. Tutuyanina 'waineye Fonitio Failato 'awalawa Iudia 'ana toveimea, we'e Elodi Galili i veveimeyeni, taina Filifi 'awalawa Itulia wata Tilakoniti i veveimeyedi, we'e Lisania 'awalawa Abilini i veveimeyeni, Anasa wata Kaiafa me Diu yadi tovelomu bwaikidi. ");
INSERT INTO yml_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tutuyanina Ioni Yaubada yana vona i nogai, i tovoi i nago 'awalawa fuedi 'waidie Ufa Iolidani lilivaneye i lau'age tomotoga 'waidie i vo, 'Wa na nuavilami yami sakona 'wa na vedumwe'ubu'ubusedi bega a na bafitaisomi wata Yaubada yami sakona i na nuatavunidi.” ");
INSERT INTO yml_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ioni kumanina faifaina basenadiotoga Yaubada yana tolu'ivona Aisea i voneyeni i vo, Sali'avu'avuye tamu tomogo i vegolegole i vo, 'Auvea yana 'eda 'wa na vusia, wata 'wa na sivetonovi yana 'eba nago. ");
INSERT INTO yml_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","'Oya 'wa na aladi i na vetano'atuga we'e 'awa'awakovadi 'wa na veivudi. 'Eda 'oka'okadi 'wa na vusivetonovidi wata 'eda bwakabwakadi 'wa na 'idewadi i na ve'atumai. ");
INSERT INTO yml_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bega tomia fwayafwaya matatabudi Yaubada yana 'ita'ita'i i na 'iseni.’” ");
INSERT INTO yml_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tomotoga fuedi Ioni valana i nogai bega i nagoi 'waineye bafitaiso faifaina nika i vonedi i vo, 'Omi tosakona, 'o'olo bani'odi. Igodi 'wa vo, 'A na dega Yaubada yana nuasako wata yana vematavuloga 'waidiega.’ Begaidi yami vaiseba 'wa vo, 'Akonadi 'a nuavilama 'u da bafitaisoma,’ siwe kebu nuanuami yami sauluva sakoidi 'wa na vedumwe'ubu'ubusedi. ");
INSERT INTO yml_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nagami yami sauluva i na tonova 'ami 'eba 'isa 'akonadi 'wa nuavilami 'wa da vo bani'odi welavi vuagina 'atumaina, mulieta a na bafitaisomi. Wata kebu 'wa na vo, Ebelamo tubuma bega Yaubada kebu i na vematavulogima.’ Siwe a na vonemi, kebu 'aivaita 'wa na veluagai. 'Omi Ebelamo tubunavo kebu nani bwaikina Yaubada mataneye. Yaubada 'ana fata Ebelamo tubunavo i na 'idewadi kileu de'e 'waidiega. ");
INSERT INTO yml_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sai'afoga Yaubada i na vematavulogimi yami sauluva sakoidi faifaidi 'wa da vo 'akonadi yana tamuyoko i da yadali bega welavi 'aitamogana 'aitamogana kebu vuagidi 'atumaidiga i na talagidi i na tawedi 'ai-'ala'alase.” ");
INSERT INTO yml_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","'Aila'anidi Ioni yana vona i nogai begaidi i velutolieni i vo, Vetuma, bani'odi 'a na munega?” ");
INSERT INTO yml_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ioni i vo, 'Ai'edi egavo 'ami talauma 'ailuga, we'e 'ifwaidi kebu 'adi talaumaga, tamu 'wa na veledi. Wata bani'odi, 'ai'edi ma 'ami'ami, we'e egavo kebu 'adi'adiga 'ifwaidi 'wa na veledi.” ");
INSERT INTO yml_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wata 'ifwaidi takesi tolaugogona vivinagodi i maia bafitaiso faifaina Ioni i velutolieni i vo, Tove, 'ima bani'odi?” ");
INSERT INTO yml_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ioni i vo, Me Loma yadi veimea 'ana tonovina 'wainega takesi 'wa na lalaugogona, kebu vekaliega 'imoso'i 'wa na 'ewa'ewadi taunimi faifaimi.” ");
INSERT INTO yml_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wata 'ifwaidi tolugaviavo i velutoli i vo, We'e 'ima bani'odi? Ava'ai 'a na 'idewai?” Ioni i vonedi i vo, 'Omi yami folova 'ana tutula 'asa'aiana i lubwainemi, we'e kebu 'ami tutula 'ana 'imoso'i faifaina ve'isakololoyega 'wa na vekali wata kebu tomotoga 'wa na vevita-maimaigidi bega yadi mani 'wa na 'ewa'ewadi.” ");
INSERT INTO yml_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tomotoga matatabudi i nuanua bwaikina Yaubada 'ana Venua'ivina Keliso yana mai faifaina, bega Ioni i 'iseni i venuanaluga i vo, Voke taunina Yaubada 'ana Venua'ivina 'alo tulina.” ");
INSERT INTO yml_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Begaidi Ioni i vonedi i vo, Yau ufayega a bafitaisomi, we'e kumanina mulikuye i mimaiga i na bafitaisomi 'Anu'anunu Magemagetana wata 'ai-'ala'alata 'waidiega. Wata tomogonina toketokeotogina, yau kebu bani'odiga, kebu i da lubwaineku 'waineye a na vetofolova-maimaiga fai taunina bwaikina. ");
INSERT INTO yml_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tutuyanina Keliso i na maiga, tomia fwayafwaya matatabudi i na vonayavuga 'waineye 'wa da vo bani'odi waifei 'ana tolaukadi, waifei wata 'ani'aninidi i na yato'edi mulieta i na vedodogidi yana bubuwakeye, we'e yogo i na tunuya 'ainina kebu yana 'weuga 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Veifufu 'atumaidi 'waidiega Ioni tomotoga i velu'ase'asedi wata Vala 'Atumaina i lu'ageyeni 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","We'e Ioni Kini Elodi i tolimatani taina yana vavine Elodiasa i luobuyediga faifaina. Wata 'ifwaidi Elodi yana sauluva sakoidi Ioni i lu'ivoneyedi. ");
INSERT INTO yml_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Begaidi Elodi i nuasako nani sakoiotogina i 'idewai, Ioni i yatoi vanuga yogona nageneye. ");
INSERT INTO yml_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Ioni bola kebu i da luku vanuga yogona nageneye, tomotoga i bafitaisodi i 'a'avana wata Iesu i bafitaisoi. Tutuyanina Iesu i vevelu'ui abama i 'anikililia, 'Anu'anunu Magemagetana yana yaveobu Iesu 'waineye 'ana 'isa'isa bani'odi bunebune. Bona i nogai abamayega i vo, 'Omu Natuku nuafouku. Faifaimu a sosoana mogitana.” ");
INSERT INTO yml_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tutuyanina Iesu 'ana malamala bani'odi 30 i veluagai yana folova i velamu tomotoga 'waidie. Tomotoga fuedi i 'asetai i vo, Iosefa natuna Iesu.” Iosefa tamana Eli. ");
INSERT INTO yml_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli tamana Madati. Madati tamana Livai. Livai tamana Meliki. Meliki tamana Yanai. Yanai tamana Iosefa. ");
INSERT INTO yml_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iosefa tamana Matadaya. Matadaya tamana Emosi. Emosi tamana Neumi. Neumi tamana Esili. Esili tamana Nakai. ");
INSERT INTO yml_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai tamana Meati. Meati tamana Matadaya. Matadaya tamana Semiai. Semiai tamana Ioseki. Ioseki tamana Dioda. ");
INSERT INTO yml_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Dioda tamana Diowane. Diowane tamana Lisa. Lisa tamana Selubabela. Selubabela tamana Salatiela. Salatiela tamana Nelai. ");
INSERT INTO yml_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nelai tamana Meliki. Meliki tamana Edai. Edai tamana Kosami. Kosami tamana Elimadami. Elimadami tamana Eli. ");
INSERT INTO yml_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ilai tamana Iosua. Iosua tamana Eliesa. Eliesa tamana Yolima. Yolima tamana Madati. Madati tamana Livai. ");
INSERT INTO yml_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai tamana Simioni. Simioni tamana Iuda. Iuda tamana Iosefa. Iosefa tamana Yonami. Yonami tamana Eliakimu. ");
INSERT INTO yml_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimu tamana Melia. Melia tamana Mena. Mena tamana Matati. Matati tamana Nedani. Nedani tamana Devida. ");
INSERT INTO yml_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devida tamana Iese. Iese tamana Obedi. Obedi tamana Bwasa. Bwasa tamana Salimoni. Salimoni tamana Nasoni. ");
INSERT INTO yml_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoni tamana Aminadaba. Aminadaba tamana Adamina. Adamina tamana Anai. Anai tamana Esiloni. Esiloni tamana Felesi. Felesi tamana Iuda. ");
INSERT INTO yml_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Iuda tamana Iakobo. Iakobo tamana Aisake. Aisake tamana Ebelamo. Ebelamo tamana Tela. Tela tamana Naoli. ");
INSERT INTO yml_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naoli tamana Seluki. Seluki tamana Leu. Leu tamana Feliki. Feliki tamana Iba. Iba tamana Sila. ");
INSERT INTO yml_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila tamana Keinana. Keinana tamana Afakisadi. Afakisadi tamana Semi. Semi tamana Noa. Noa tamana Lemeki. ");
INSERT INTO yml_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemeki tamana Metusela. Metusela tamana Inoki. Inoki tamana Ieledi. Ieledi tamana Malaleli. Malaleli tamana Keinana. ");
INSERT INTO yml_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keinana tamana Inosi. Inosi tamana Seti. Seti tamana Adama. Adama tamana Yaubada. ");
INSERT INTO yml_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu i bafitaiso Ufa Iolidani 'waineye i 'a'avana, 'akonadi 'Anu'anunu Magemagetana i agei mogitana bega 'Anu'anununina Iesu i vagavaia i naweni sali'avu'avuye. ");
INSERT INTO yml_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Seitani nuanuana Iesu i na sakona begaidi bei i silubuya 'aiata 40 nagedie, 'aiatanidi 'waidie Iesu kebu tamu 'ani'ani i da 'ani, mulieta 'aiatanidi i 'a'avana i lase. ");
INSERT INTO yml_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tutuyanina Iesu i lase nika bei Seitani i souyeni 'waineye, i voneni i vo, 'Ai'edi 'omu mogitana Yaubada Natuna, 'u na vona kileu de'e i na ve'ani'ani.” ");
INSERT INTO yml_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iesu Seitani yana vona i tutuli i vo, Kebu. Basenadi i kilumi Yaubada yana Buki nageneye i vo, Tomotoga yadi mia 'ana 'atumaina kebu 'ani'ani'ava 'wainega i da veveluagadi.’” ");
INSERT INTO yml_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Wata 'ana veluga Seitani Iesu i vagavaia i lakaveni 'oyeye, fwayafwaya yana 'eba veimea matatabuna i veni tutuya 'ale'usana nageneye ");
INSERT INTO yml_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bega Seitani i vo, De'e 'eba veimeanidi wata 'ai'aiwabunidi yau yaku 'eba veimea fai basenadi i 'anivelenedi 'waikuye. We'e a na velemu, 'ai'edi nuanuaku, 'ana fata a na 'anivelenedi tamu aitoi 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","'Ai'edi ma yamu ve'ililibu 'u na 'odu 'waikuye, naninidi matatabuna a na velemu.” ");
INSERT INTO yml_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nika wata Iesu i vo, We'e Yaubada yana Buki nageneye i vonaga i vo, 'Auvea yami Yaubada 'waineye 'wa na 'odu'odu, wata 'aiseotogina faifaina 'wa na folofolova.’” ");
INSERT INTO yml_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","I 'a'avana wata Seitani Iesu i vagavaia i naweni Ielusalema, Vanuga 'Eba Velu'ui tabwaotogineye i lakaveni. Bei wata i voneni i vo, 'Ai'edi mogitana 'omu Yaubada Natuna de'e bega 'u na souga, veviga kebu 'u na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Fai Yaubada yana Buki nageneye i vo, Yaubada yana anelose i na vonedi i na 'i'ita'ita'iemu wata i na ve'isabodebodemu. ");
INSERT INTO yml_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nimadiega i na silakaimu bega kebu tamu sai'afo 'agemu 'u na nikeyedi kileu 'waidie.’” ");
INSERT INTO yml_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu Seitani yana vona i tutuli i vo, We'e Yaubada yana Buki i vo, 'Ai'edi taunimi 'wa na tauyemi 'eba ilagi 'waidie, kebu i da lubwainemi 'Auvea yami Yaubada 'wa na sitonovi 'ami 'ita'ita'i faifaina.’” ");
INSERT INTO yml_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tutuyanina Seitani yana sailubu matatabuna i ve'a'avadi Iesu 'waineye, mulieta i 'iaweni i nago tulineye tamu tutuya 'waineye i na vilai. ");
INSERT INTO yml_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","'Anu'anunu Magemagetana yana toketokena Iesu 'waineye i 'eno'eno, bega i vilai sali'avu'avuyega i nago 'awalawa Galili. Tomotoga matatabudi i miamiani 'awalawanina 'waineye valana i 'asetai. ");
INSERT INTO yml_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Me Diu yadi 'eba miava'auta 'waidie Iesu i veve nika tomotoga fuedi i subisubiai. ");
INSERT INTO yml_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Mulieta Iesu i nago Nasaledi yana 'atamane bei i taulaiga 'waineye. Tamu 'Aiata Veawai i veluagai Iesu i luku me Diu yadi 'eba miava'auta 'waineye, yana sauluva bani'odi. Yadi tafalolo 'waineye i tovoi bega Yaubada yana Buki i na lu'iawawai tomotoga 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tamu tomogo lubulubu nunumina Iesu i veleni, lubulubunina Yaubada yana tolu'ivona Aisea 'ana kilukiluma. I luyawagi nika vonanina i veluagai 'ana nogaya side bani'odi. ");
INSERT INTO yml_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","'Auvea 'Anu'anununa 'waikuye i miamia, fai i venua'ivineku Vala 'Atumaina a na lu'ageyeni tovewekowekoma 'waidie. I vetuneku bega tomotoga yogoyogonidi 'adi 'etoyavu faifaina a na lu'ivona 'waidie, we'e tomatasako matadi i na ve'atumai-vaitugana faifaina. Wata i vetunekuga tomotoganidi vita i veveluagadi 'adi gaviavo 'waidiega, a na 'etoyavudi. ");
INSERT INTO yml_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Wata 'ami 'ita'ita'i 'Auvea 'wainega 'ana tutuya a na lu'ivoneyeni. ");
INSERT INTO yml_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Vonanina Iesu i lu'iawawai i 'a'avana Buki i vetalabodai 'ana to'isave'avina i veleni mulieta i miabui bega i na ve 'waidie. We'e tomotoganidi matatabudi vanuga 'eba miava'auta nageneye nuadi i 'ewai, Iesu 'waineye i 'isa-valavalalai. ");
INSERT INTO yml_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iesu i veifufu 'waidie i vo, Vonanina 'wa nogaiga, tutuyanina a lulu'iawawai 'ana mogitana i souyeni.” ");
INSERT INTO yml_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tomotoganidi i vavainenega Iesu i subiai fai nuadi i voganidi yana veifufu 'atumaidi faifaidi wata i vo, Tomogo no'o kebu tulinaga, ta 'asetai Iosefa natuna we'e bani'odi i munega?” ");
INSERT INTO yml_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Begaidi Iesu i vonedi i vo, A 'asetai bola voke yada vona-awatabai tamu 'wa na voneyeni 'waikuye 'wa na vo, 'Omu to'ive'atumai bega taunimu 'u na 'ive'atumaimu.’ Wata 'wa na vo, Naninidi 'eba nuavogana Kafaneomi 'waineye 'u 'idewadiga wata bani'odi yada 'atamana Nasaledi 'waineye 'u na 'idewadi.’ ");
INSERT INTO yml_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Siwe a na vonemi, Yaubada yana tolu'ivonavo taunidi yadi 'atamana 'ana tomotogavo kebu i da ve'ililibuyediga i vedumwe'ai'aiedi. ");
INSERT INTO yml_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Side bani'odi. 'Wa na nuani basenadiotoga Yaubada yana tolu'ivona Ilaitia yana tutuye, malamala 'aitonu wata weta'i 6 nagedie 'wei kebu i da 'wei'weiga bega loka bwaikina. ");
INSERT INTO yml_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tutuyanina 'waineye me Diu yadi 'wabu'wabulavo fuedi nuanuadi 'aivaita, siwe Yaubada kebu Ilaitia i da tauyeni i na 'ivaisedi, i vetunei tamu 'wabula 'waidie taunidi kebu Diu i miamia Salefati, 'awalawa Saidoni nageneye i 'ivaisedi. ");
INSERT INTO yml_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wata bani'odi tamu tolu'ivona 'ana wagava Ilaisa yana tutuye, 'awalawa Isileli nageneye tomotoga fuedi viga sakoina 'eba kololo tomogodi i velufo'afo'ana, nuanuadi 'aivaita siwe kebu i da 'ivaisedi fai yana 'aila'avo i vedumwe'ai'aieni. Begaidi i nago mali tomotoga kumanidiavo kebu Diu 'waidie, tamu tomogo Silia kumanina 'ana wagava Nemani viganina i 'ewaiga, i 'ive'atumaia.” ");
INSERT INTO yml_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","30","Tomotoga matatabudi i miamiani 'eba miava'auta 'waineye Iesu bonana i nogaidi i 'asetai 'adi vona, taunidi bani'odi tovedumwe'ai'ainidi begaidi ma yadi nuasako Iesu i tovififineni i 'ive'avini i yo'ei i naweni mwalilige. 'Atamananina 'oya tabwaneye bega igodi bwagale i da bifeleni, siwe Iesu 'aila'a 'awasasadiamo i 'afiweila, i souyeni i nago. ");
INSERT INTO yml_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mulieta Iesu Nasalediega i nago 'atamana Kafaneomi 'awalawa Galili nageneye, bei i ve tomotoga 'waidie 'Aiata Veawai 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tomotoga fuedi nuadi i voganidi yana ve faifaina, fai ma yana veimea i veve 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","'Eba miava'auta nageneye tamu tomogo yaiaina i ageiga, bonana bwaikinega i vegolegole i vo, 'Omu Iesu tomogo Nasaledi, ava'ai 'u na vaima? Voke nuanuamu 'u na leoma. 'A 'asetamu, 'omu Magemagetamu 'u mai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu yaiaina i talabodeni i vo, 'U ve'wada, tomogo 'wainega 'u 'awa'a'imu.” Yaiaina tomogo i bifeleni i be'u 'aila'a matadie nika i 'awa'a'ia, kebu wata veviga i da veluagai yaiainanina 'wainega. ");
INSERT INTO yml_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Fuedi nuadi i voganidi i velutolitoli i vo, Bani'odi de'e i munega? Vona'ava siwe toketokena wata ma yana veimea yaiaina i vonevonedi i 'a'awa'a'idi.” ");
INSERT INTO yml_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iesu valana i vebwaika i nago 'awalawa matatabuna 'waidie Kafaneomi lilivaneye. ");
INSERT INTO yml_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tutuyanina Iesu 'eba miava'auta i 'iaweni i nago Saimoni Fita yana vanuge. Saimoni yana vavine inadi i viga tomogodi yauyauta bwaikina bega Iesu 'waineye i velu'ui i na 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesu i luku 'adi 'ivi lilivaneye i tovoi tomogodi i luyauyautaga i talabodeni nika i 'awatagoni. I 'a'ava vavinenidi i tovoi 'ani'ani i 'idewadewa Iesu ma enavo faifaidi. ");
INSERT INTO yml_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","'Akonadi inala i simwanuya, yadi 'Aiata Veawai i 'a'ava, tomotoga yadi toviga 'adi viga tulina tulina i miedi Iesu 'waineye. 'Aitamogana 'aitamogana i 'abitonovidi 'adi viga i 'a'ava i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wata tomotoga fuedi 'waidiega yaiaina i 'awa'a'idi i vevegolegole i vo, Vona mogitana 'omu Yaubada Natuna.” Siwe Iesu i toke i talabodebodedi kebu i na lulu'ivona fai 'akonadi i 'asetai taunina Keliso, Yaubada 'ana Venua'ivina. ");
INSERT INTO yml_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bola kebu i da mageta'a'avaiga Iesu 'atamananina 'waineye i miamiaga i 'iaweni, 'aiseneye i nago tamu 'awasasa kebu tomotoginaga 'waineye bei i velu'ui. Begaidi tomotoga i lualeni i nago i veluagai i talabodebodeni i vo, Kebu 'u na nagoga mali 'awalawa 'waidie, side bei Kafaneomi ta na miamia.” ");
INSERT INTO yml_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nika Iesu i vo, 'Atamana 'ifwaidi wata 'waidie a na nago Vala 'Atumaina Yaubada tomotoga i na veimeyemiga faifaina a na lau'age, folovanina faifaina Yaubada i vetuneku.” ");
INSERT INTO yml_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bega i nago 'awalawa Iudia 'waineye i lau'age-vuvua me Diu yadi 'eba miava'auta 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tamu 'aiata 'waineye Iesu i tovotovoi Lavu Galili balebaleye, 'aila'a i maia i vevetunufelagieni nuanuadi Yaubada yana vona Iesu 'wainega i na vinenegeni. ");
INSERT INTO yml_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iesu toyaubani yadi waka 'ailuga i 'isedi 'akonadi i yo'edi, we'e taunidi i obu yadi vualalalakana i lekolekoadi. ");
INSERT INTO yml_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tamu waka 'waineye Iesu i dodoga, wakanina Saimoni yana waka, bega i voneni sai'afo i talalaka malavetayega mulieta Iesu i miabui i ve 'aila'a 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yana ve i 'a'avana Saimoni i voneni i vo, Sai'afo malaveseye 'u na sese bei ma emwavo vualalalakana 'wa na lelegedi igana 'wa na 'onadi.” ");
INSERT INTO yml_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nika Saimoni i vo, 'Auvea, lovana 'a vuata i 'asema kebu tamu igana 'a da 'onaiga. Siwe fai 'u vonaga, ta na laka vualalalakana a na lelegedi.” ");
INSERT INTO yml_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bega ma fuedie i laka i lelegedi igana fueotogidi i 'onadi sai'afoga vualalalakana i da bwekadi. ");
INSERT INTO yml_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bega ediavo tamu waka 'waineye i lu'waiedi 'aivaita faifaina. I maia waka 'ailugana i veadagidi sai'afoga i da kavivila. ");
INSERT INTO yml_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tutuyanina Saimoni Fita igana fuedi i 'isedi ma yana ve'ililibu 'agena i vetufano'uyedi i 'odu Iesu 'waineye i vo, 'Auvea, 'u na 'iaweku fai yau tosakona.” ");
INSERT INTO yml_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimoni Fita wata 'ifwaidi tomotoga yana wakeye nuadi i voganidi fai igana fueotogidi i 'onadi. ");
INSERT INTO yml_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wata bani'odi enavo tamu waka 'waineye Saimoni taiadi i folofolova nuadi i voganidi, enavonidi 'adi wagava Iemesa wata Ioni, Sebedi natunavo. Iesu Saimoni i voneni i vo, Kebu 'u na kolologa. Basenadi igana 'u 'ona'onadi, we'e yau tamu yaubani a na vemu bega tomotoga 'u na 'ona'onadi 'u na mimaiedi Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bega yadi waka i yo'edi 'avale, nani matatabuna i bailedi Iesu taiadi i nagoi i na vetovetutuyama 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tamu tutuya Iesu i miamia tamu 'atamana bwaikina 'waineye, 'atamananina 'waineye tamu tomogo i miamia vivigina, viganina sakoina 'eba kololo tomogona i velufo'afo'ana. Tomogonina Iesu i 'iseni i mai ma yana ve'ililibu i lumata'afufu 'ageneye i velu'ui i vo, 'Auvea, 'ai'edi nuanuamu 'amu fata 'u na 'ive'atumaiku.” ");
INSERT INTO yml_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu toviganina i 'abitonovi i voneni i vo, Fai bani'odi, nuanuaku, 'u ve'atumai.” Nika tomogonina 'ana viga i 'a'ava i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","'Akonadi tomogo i ve'atumai Iesu i toke i velu'ase'asei kebu tamu aitoi 'waineye i na lu'ivonaga, i vo, Nuanuaku tonovimu 'u na nago tovelomu 'waineye, nagami i na 'isemu. Mulieta yamu velomu 'u na 'aniveleneni bani'odi veimeanina i mai Mosese 'wainega toviganina i ve'atumaiga faifaina. Tovelomunina i na 'isemu i na ve'awamogitana 'akonadi 'u ve'atumai wata bani'odi mali tomotoga i na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iesu i talaboda siwe valana i vebwaika-'afo'afo, bega 'aila'a bwaikina i deli i maia yana vona i na vinenegeni wata 'adi viga 'waidiega i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Siwe Iesu yana sauluva tutuya fuedi 'aila'a 'waidiega i nunago tamu 'awasasa kebu tomotoginaga 'waineye, bei 'aiseneye i vevelu'ui Yaubada 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tamu 'aiata 'waineye Iesu i veve tomotoga 'waidie, 'aila'anina 'wainega 'ifwaidi Diu totafalolo Falisi wata 'ifwaidi ve'etoboda 'adi tovevo. To'edakumetanidi i maia 'atamana fuedi 'waidiega, bani'odi 'awalawa Galili, Iudia wata Ielusalema, ma fuedie i vavainenega. Yadi miava'autanina nageneye Yaubada yana toketokena i 'eno'eno bega 'wainega Iesu toviga i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","We'e 'ifwaidi tomotoga tamu iadi i vebwalokoga ma 'evo'evona i evai i mieni, nuanuadi i na lukuveni Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","'Aila'a bwaikaotogina kebu 'adi fata i na lukuveni, bega i lakaveni vanuga tabwana bababana 'waineye. Vanuga 'ana saila'a i 'ewadi bega 'anibwekaneamo ma 'evo'evona i ve'ioyoi i obu Iesu 'waineye tomotoga 'waidiamo. ");
INSERT INTO yml_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iesu tomotoganidi i 'isedi i 'asetadi ma yadi vetumagana, bega tomogo bwalobwalokona i voneni i vo, Iaku, yamu sakona 'akonadi a nuatavunidi.” ");
INSERT INTO yml_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","We'e ve'etoboda 'adi tovevo wata Falisi nuadiega i vo, Aitoi tomogoga de'e? Awale Yaubada 'waineye i vona-uvi'agala? Kebu tamu aitoi 'ana fata sakona i na nuatavunidi, Yaubada 'aiseotogina 'ana fata.” ");
INSERT INTO yml_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu 'akonadi yadi nuanua i 'asetadi begaidi i vo, Awale bani'odi 'wa vevenua'ivinedi? ");
INSERT INTO yml_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","'Aku fata tomogonina a na voneni a na vo, Yamu sakona a nuatavunidi,’ wata 'aku fata a na vo, 'U tovoi 'u nago.’ 'Wa da nuani, ava'ai vonaga safailina? ");
INSERT INTO yml_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Siwe a na vemi yau a vetomotogaotoga ma yaku veimea fwayefwayeye bega 'aku fata tomotoga yadi sakona a na nuatavunidi.” Nika Iesu tomogo bwalobwalokona i voneni i vo, 'U tovoi, 'amu 'evo'evo 'u evai 'u nago yamu vanuge.” ");
INSERT INTO yml_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","'Aila'a matatabudi i 'isa'isa nika tomogonina i tovoi-matayo'o, ma yana sosoana 'ana 'evo'evo i evai i tauya i nunago yana vanuge Yaubada i subisubiai. ");
INSERT INTO yml_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tomotoga matatabudi i 'iseni nuadi i vogani bwaikina wata i kololo begaidi Yaubada i subiai i vo, 'Asiau be'ama 'eba nuavogana wata toketokena ta 'iseni.” ");
INSERT INTO yml_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iesu tomogo bwalobwalokona i 'ive'atumaia, mulieta i nunagoga takesi 'ana tolaugogona 'ana wagava Livai i 'iseni yana 'eba folova 'waineye i miamia. Iesu i voneni i vo, 'U mai taiadi ta na nago yaku tovetutuyama.” ");
INSERT INTO yml_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nika Livai i tovoi nani matatabuna i 'iawedi Iesu taiadi i nago. ");
INSERT INTO yml_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mulieta Livainina 'ani'ani bwaikina i 'idewai yana vanuge Iesu faifaina. Tomotoga fuedi bei i luku i 'ani'ani Iesu ma yana tovetutuyamavo wata 'ifwaidi takesi 'ana tolaugogona taiadi. ");
INSERT INTO yml_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","We'e 'ifwaidi Diu totafalolo Falisi wata 'adi 'aila'avo ve'etoboda 'adi tovevo ma yadi nuasako tovetutuyamavo i velutoliedi i vo, Awale takesi tolaugogona vivinagodi wata tosakona taiadi 'wa 'ani'ani? Kebu 'ana 'isa 'atumainaga.” ");
INSERT INTO yml_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu i nogai, vona-awatabaiega i vonedi i vo, Egavo 'atumaidi kebu nuanuadi viga 'adi to'ive'atumai, 'aisedi toviga mogitana. ");
INSERT INTO yml_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wata bani'odi, yau a maiga kebu taunidi i awave'atumaiediga faifaidi, a maiga tosakona i na nuaviladi a na 'ita'ita'iedi.” ");
INSERT INTO yml_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","We'e 'ifwaidi Falisi wata ve'etoboda 'adi tovevo Iesu i voneni i vo, Ioni Tobafitaiso yana tovetutuyamavo tutuya fuedi 'ani 'wainega i veve'udigana bega yadi velu'ui i na vetoketoke Yaubada 'waineye. Wata bani'odi Falisi yadi tovetutuyamavo i veve'udigana we'e 'omu yamu tovetutuyamavo kebu 'ani 'wainega i da veve'udigana, i 'ani'ani wata i yemuyemu. Awale bani'odi i vevesauluvedi?” ");
INSERT INTO yml_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu yadi vona i tutuli taunina faifaina i vona-awatabai i vo, Tonagi yana sosoana 'waineye, kebu tamu aitoi 'ana fata enavo i na talabodedi bega 'ani'ani i na baileni. ");
INSERT INTO yml_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","We'e tamu 'aiata tomotoga 'ifwaidi i na maia tonaginina i na 'ive'avini i na naweni, i lubwainedi ma yadi nuavita i na ve'awamwau.” ");
INSERT INTO yml_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wata Iesu i awatalatutula 'waidie yana ve sauluva 'ivauna faifaina wata me Diu yadi sauluva tuatuaina 'adi luwanawana faifaidi i vo, 'Ai'edi talauma tuatuaina i na 'anilabu'i kebu i da lubwaineni talauma 'ivauna ta na boboi, 'wainega talauma tuatuaina ta na bwadia. Fai bola ta na lekoai bwadi 'ivauna i na vesiai bega i na vefato'ai'ai tuatuaina i na 'ivesakoi.” ");
INSERT INTO yml_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wata bani'odi oine 'ana ba'ala 'aisaya bunudiega faifaina Iesu i vona i vo, 'Ai'edi oine 'ivauna ba'ala tuatuaina 'waineye i na iwagiga, i na yuvefuai i na iwaga 'ana ve'amubwadodo, fai ba'ala aya'aina 'akonadi i sako. ");
INSERT INTO yml_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Oine 'ivauna wata ba'ala 'ivauna nika bikabikana i lubwaineni kebu i na yuvefuai.” ");
INSERT INTO yml_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wata Iesu i vo, 'Ai'edi aitoi oine tuatuaina i na yemuyaga, kebu nuanuana 'ivauna i na yemu, i na vo, Tuatuaina a da yemu 'ana lautonova 'atumaiotogina.’” De'e bani'odi Iesu i vonaga fai tomotoga fuedi yadi nuanua i vo, Yada sauluva tuatuaidi 'atumaiotogidi.” ");
INSERT INTO yml_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tamu 'Aiata Veawai 'waineye, Iesu ma yana tovetutuyamavo i nunagoi bakula 'waineamo, yana tovetutuyamavo i lase bega witi vuagidi i kaliwawadi i 'ani. ");
INSERT INTO yml_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","We'e 'ifwaidi Diu totafalolo Falisi i 'isedi Iesu i voneni i vo, Awale? Me Diu yada ve'etoboda 'wa geugeuya witi vuagidi i kakaliwawadi, 'asa'aiana 'wa folofolova 'Aiata Veawai 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu Falisi yadi vona i tutuli i vo, 'Wa da vo Yaubada yana Buki kebu 'wa da lu'iawawaiga, basenadiotoga Kini Devida ma enavo i lase faifaina. ");
INSERT INTO yml_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devida i luku Vanuga 'Eba Velu'ui nageneye, beledi tamu Yaubada 'ana 'anivelena i 'ewai ma enavo i 'ani. De'e tamu 'ada veimea kebu tamu aitoi 'ana fata beledinina i na 'ania tovelomu 'aisedi 'adi tauya. ");
INSERT INTO yml_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yau a vetomotogaotoga 'asa'aiana kumaniku 'Aiata Veawai 'ana Toveimea, begaidi 'aku laubwaina 'aiatanina 'waineye tomotoga yadi sauluva faifaina a na veveimea.” ");
INSERT INTO yml_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tamu 'Aiata Veawai 'waineye Iesu i nago me Diu yadi 'eba miava'auta 'waineye bei i ve. 'Eba miava'autanina nageneye tamu tomogo nimana 'ana 'atagi 'okana i miamia. ");
INSERT INTO yml_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","We'e 'ifwaidi ve'etoboda 'adi tovevo wata 'ifwaidi Diu totafalolo Falisi Iesu i vemata'i'i'ieni. 'Ai'edi toviganina i na 'ive'atumaia 'Aiata Veawai 'waineye i na tolimatani fai folovanina 'wainega, igodina yadi veimea i da geugeuya. ");
INSERT INTO yml_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Siwe Iesu 'akonadi yadi nuanua i 'asetai begaidi tomogonina nimana 'okana i voneni i vo, 'U mai 'aila'a matadie, 'u tovoi bega i na 'isemu,” nika tomogo i tovoi i nago. ");
INSERT INTO yml_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Bega Iesu ve'etoboda 'adi tovevo wata Falisi i velutoliedi i vo, Yada veimea 'Aiata Veawai faifaina, 'wa da nuani, ta na vevesauluva-'atumai 'alo ta na vevesauluva-sako? Wata 'ai'edi tamu tomogo sai'afoga i na wafa ta na 'ivaiseni 'alo ta na luvewafai?” ");
INSERT INTO yml_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iesu tomotoga 'aitamogana 'aitamogana i 'isadewadi i 'a'avana tomogonina i voneni i vo, Nimamu 'u si'otoi.” Nimana i si'otoi nika i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ve'etoboda 'adi tovevo wata Falisi kamodi i ogala-'afo'afo, 'aise'avadi i vo, Iesu bani'odi ta da munegi ta da luvewafai?” ");
INSERT INTO yml_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tomogo nimana 'okana i ve'atumai, mulieta 'aiata 'ifwaidi i 'a'ava, Iesu i laka 'oyeye i na velu'ui. Lovana matatabuna i vevelu'ui Yaubada 'waineye i 'aseni. ");
INSERT INTO yml_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","'Awa'awaie Iesu yana tovetutuyamavo matatabudi i goledi i nagoi 'waineye, 'waidiega 'adi 12 i venua'ivinedi bega i goledi tomata'aulele. ");
INSERT INTO yml_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tomata'aulelenidi side 'adi wagava, Saimoni, i goleni Fita, Anidulu, Saimoni taina, Iemesa ma taina Ioni, Filifi, Batolomiu, ");
INSERT INTO yml_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Madiu, Tomasi, Iemesa, Alefasi natuna, Saimoni, toawa'idi'idi kebu nuanuana Loma kabemani i na veveimeyedi, ");
INSERT INTO yml_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iudasa, Iemesa natuna, Iudasa Isakaliota, kumanina Iesu 'ana to'etogiluva. ");
INSERT INTO yml_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mulieta Iesu ma enavo i obuma 'oyayega i tovoi laube'uye, bei yana tovetutuyamavo fuedi wata 'aila'a bwaikina i miamiani. Tomotoganidi i maia 'awalawa Iudia matatabuna 'wainega, Ielusalemayega i obuma, 'atamana bwaikidi balebaleye Taia wata Saidoni 'waidiega i lukuma. ");
INSERT INTO yml_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Matatabudi i maia Iesu yana vona i na vinenegeni wata egavo i viga Iesu i na 'ive'atumaidi. Wata tomotoga yaiaina i agediga veviga i veluagai i maia, Iesu i vona yaiaina matatabudi i 'awa'a'idi. ");
INSERT INTO yml_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tomotoga matatabudi Iesu yana toketokena i 'iseni begaidi nuanuadi i na 'abitonovi bega yana toketokena i na damana 'waidie 'adi viga 'waidiega i na ve'atumai. ");
INSERT INTO yml_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu i 'isanago yana tovetutuyamavo 'waidie i vonedi i vo, 'Omi 'asiau 'wa vewekowekomaga, 'eba sosoana 'waimie fai 'akonadi Yaubada i veveimeyemi yana 'Aila'a nageneye. ");
INSERT INTO yml_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","'Omi 'asiau 'wa laselasega, 'eba sosoana 'waimie fai Yaubada i na vesauluva 'atumaina 'waimie nika 'ami fata. Wata 'omi 'asiau ma yami nuavita 'wa 'we'we'welaga, 'eba sosoana 'waimie fai 'awaie 'wa na sosoana wata 'wa na namaga. ");
INSERT INTO yml_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Tutuyanina yau a vetomotogaotoga faifaiku tomotoga i na vedumwe'ai'aiemi, i na sisidibidibiemi, i na yagayagaimi wata i na falisakoyemiga, 'eba sosoana 'waimie. Tutuyanina vitanidi i na souyediga, 'eba sosoana 'waimie, ma yami sosoana 'wa na sousou, fai 'ami tutula bwaikina Yaubada i yatoi i lulukamata abame. 'Wa na nuani basenadiotoga tovedumwe'ai'ainidi tubudiavo Yaubada yana tolu'ivonavo bani'odi i munegidi bega vita i veluagadi, 'omi wata 'asiau bani'odi. ");
INSERT INTO yml_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","We'e 'omi tutuya de'e 'wa ve'ai'aiwabuga, nuakalikalimi bola yami 'ai'aiwabunidi i na 'a'ava kebu wata 'wa na veluagadi, 'wa na nuavita nuami 'wa na 'uvanidi. ");
INSERT INTO yml_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","We'e 'omi tutuya de'e 'wa lulukamoaiga, nuakalikalimi bola 'wa na lase nika 'wa na nuavita nuami 'wa na 'uvanidi. We'e 'omi tutuya de'e 'wa namaga-'avo'avovoga, nuakalikalimi bola 'wa na nuavita wata 'wa na 'we'wela. ");
INSERT INTO yml_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Basenadiotoga tomotoga fuedi tolu'ivona-vekavekali i awave'atumaiedi nuanuadi yadi vona. We'e 'omi wata bani'odi, 'ai'edi tomotoga fuedi i na awave'atumaiemi nuanuadi yami vona, nuakalikalimi 'wa na nuavita fai vematavuloga 'wa na veluagai yami vekali faifaidi.” ");
INSERT INTO yml_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Wata Iesu i vo, 'Omi fuemi yaku vona 'wa vivinenegeniga a na vonemi. 'Ami gaviavo 'wa na nunuakalikaliedi wata egavo i na vedumwe'ai'aiemiga 'wa na vesauluva 'atumaina 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Egavo i na yagaimiga ma yami nuakalikali vona bikanega 'wa na vonedi wata egavo i na kiavesako 'waimie 'wa na velu'ui faifaidi bega Yaubada i na vesauluva 'atumaina 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","'Ai'edi tamu tomogo 'ae'aemuye i na 'ainikega, wata tamu 'ae'aemu 'u na 'iyoyoeni i na nikei. We'e 'ai'edi aitoi yamu 'eba vesifafa i na 'ewaiga, wata 'amu talauma 'u na tauyeni kebu 'u na ve'o'oleni. ");
INSERT INTO yml_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","'Ai'edi aitoi tamu ava'ai nuanuana i na velu'uiemuga, kebu 'u na veumokaiga 'u na veleni. Wata 'ai'edi aitoi tamu yamu kukua i na 'ewaiga, 'asa'aiana kebu 'u na lukwayegeni 'ana vevila faifaina. ");
INSERT INTO yml_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","'Ai'edi ava'ai nuanuami tomotoga i na 'idewai 'waimie, 'omi wata bani'odi 'wa na 'idewai 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","'Ai'edi egavo i nuakalikaliemiga kumanidiavo 'aisedi 'wa na nunuakalikaliedi, yami nuakalikalinina Yaubada kebu i na tutuliga, tomotoga fuedi wata tosakona taiadi ediavo 'aise'avadi i nunuakalikaliedi. ");
INSERT INTO yml_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wata 'ai'edi egavo i na vesauluva 'atumaina 'waimie wata 'aise'avadi 'wa na vesauluva 'atumaina 'waidie, kebu nani bwaikina Yaubada mataneye fai tomotoga fuedi wata tosakona taiadi yadi sauluva. ");
INSERT INTO yml_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Wata 'ai'edi nani 'ifwaidi tomotoga 'wa na veledi siwe nuanuami i na tutulidiga, kebu nani bwaikina Yaubada mataneye fai tosakona nani 'ifwaidi mali tosakona i veleveledi bega bola wata 'ana vebwaika bani'odi i na tututula. ");
INSERT INTO yml_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Siwe kebu. Egavo i na vesauluva sakoina 'waimie 'wa na nuakalikaliedi wata 'wa na vesauluva 'atumaina 'waidie. 'Wa na 'anivelena-maimaiga kebu tutula faifaina 'wa na nuanua. 'Ai'edi bani'odi 'wa na vevesauluvediga, 'awaie tutula bwaikina 'wa na veluagai Yaubada Bwaikaotogina 'wainega wata i na ve'awa-natunemi fai tutuya fuedi tosakona wata taunidi kebu i da vevekaiwa Yaubada 'waineye siwe i vevesauluva 'atumaina 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Begaidi side bani'odi. 'Omi tomotoga fuedi 'wa na 'i'isanuakalikaliedi, bani'odi Tamami i 'i'isanuakalikaliemi.” ");
INSERT INTO yml_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wata Iesu i vona 'aila'a 'waidie i vo, Kebu tomotoga yadi sauluva 'waidiega 'wa na 'idi, i na nunago Yaubada i na lu'idiemi. Wata tomotoga kebu 'wa na awavesakoyedi i na nunago Yaubada i na awavesakoyemi. Mali tomotoga yadi sakona 'wa na nuatavunidi nika Yaubada yami sakona i na nuatavunidi. ");
INSERT INTO yml_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tutuya fuedi 'wa na 'a'anivelena-maimaiga nika wata 'anivelena-maimaiga 'wa na veveluagadi. Nuakalikalinidi bwaikaotogidi bani'odi lugalagaladi wata 'udi'udilidi, kebu 'ami fata 'wa na lilidiga fai fueotogidi. 'Ai'edi 'wa na 'anivelena-maimaiga bwaikina, wata 'anivelena-maimaiga bwaikina 'wa na veluagai. Wata bani'odi 'ai'edi 'wa na 'anivelena-maimaiga siaina, wata 'anivelena-maimaiga siaina 'wa na veluagai.” ");
INSERT INTO yml_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Wata Iesu i vona-awatabai 'waidie i vo, Kebu 'ana fata tamu tomatasako iana tomatasako i na siveikani fai bola i na be'uluga vakavakale. ");
INSERT INTO yml_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kwamana yana 'aseta kebu yana tove yana 'aseta i da vebwaika-'iaweni, we'e tosikulu matatabudi yadi sikulu i na ve'a'avaga, yadi 'aseta bwaikina yadi tove bani'odi. ");
INSERT INTO yml_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Awale iamu mataneye fwayafwaya nani saiotogina 'u 'iseni faifaina 'u vonavona, we'e kebu 'u da nuaniga 'omu 'ibwalobwalo'u bwaikina matamuye? ");
INSERT INTO yml_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kebu 'ana nogaya 'atumaina 'ai'edi 'u na vo, Iaku, nuanuaku matamu i lufwaluyaga a na 'ewai,’ we'e kebu 'u da 'iseniga taunimu matamuye 'ibwalobwalo'u bwaikina? 'Omu tovekali. Nagami taunimu matamuyega 'ibwalobwalo'u bwaikina 'u na 'ewai bega 'u na 'isadewa, nika 'amu fata fwayafwaya nani siaina iamu matanega 'u na 'ewai.” ");
INSERT INTO yml_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wata Iesu i vonedi i vo, Welavi 'atumaina tutuya fuedi vuagina 'atumaina wata welavi sakoina tutuya fuedi vuagina sakoina. ");
INSERT INTO yml_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Welavi 'aitamogana 'aitamogana vuagidiega ta na 'asetadi ava'ai welaviga. Kebu 'ana fata 'ala'ai vuagina ta na kadia 'uwe 'wainega. Wata kebu 'ana fata kalibo vuagina ta na kadia ulaulawa 'wainega. ");
INSERT INTO yml_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wata bani'odi tomotoga, yadi sauluva 'waidiega ta na 'isa'inanadi tomotoga 'atumaidi 'alo sakoidi. Tomogo 'atumaina yana nuanua 'atumaidi 'waidiega i vevesauluva 'atumaina, we'e tomogo sakoina yana nuanua sakoidi 'waidiega i vevesauluva sakoina. Tomogo ava'ai i na voneyeniga, fai yana nuanua 'wainega i mai.” ");
INSERT INTO yml_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Wata Iesu i vona 'aila'a 'waidie i vo, Awale 'wa veve'awa-'Auvea 'waikuye siwe kebu yaku vona 'wa da vevematayakeyakediga? ");
INSERT INTO yml_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","'Ai'edi aitoi i na mai 'waikuye yaku vona i na nogaidi bega i na 'idewadi, taunina yana sauluva side bani'odi. ");
INSERT INTO yml_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","To'aiyogona nagami yana kabutu'u 'atumaina i venua'ivineni, 'ogola fa'alidi i 'ewadi wata ovu manamanawedi i aladi bega yana vanuga matatabuna i yogoni. Tutuyanina 'wei i 'wei, wayagata i obu, yana 'atamana i sesei vanuganina kebu i da 'etofoiaga fai vanuga fa'alina i yogoni. ");
INSERT INTO yml_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","We'e 'ai'edi aitoi yaku vona i na nogaidi siwe kebu i na vematayakeyakediga, kumanina bani'odi tamu to'aiyogona kabutu'u sakoina i venua'ivineni, yana vanuga i yogoni siwe 'ogola kebu. Tutuyanina wayagata i obu vanuga i 'etofoia matatabuna i 'etogeugeuya.” ");
INSERT INTO yml_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tutuyanina Iesu naninidi matatabuna i veifufu'a'avedi 'aila'a 'waidie, i tovoi i nago 'atamana Kafaneomi. ");
INSERT INTO yml_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","'Atamananina 'waineye tamu me Loma yadi tolugavia 'adi to'edakumeta i miamia ma yana tofolova-maimaiga. Tofolovanina i viga bwaikina, sai'afoga i da wafa. Fai tolugavianina yana tofolova i nuakalikalieni bwaikina, tutuyanina i nogai Iesu valana 'ifwaidi Diu yadi to'edakumetavo 'au'auveadi i vetunedi Iesu i na voneni i na mai yana tofolova i na 'ive'atumaia. ");
INSERT INTO yml_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","I nagoi i voneni i vo, Nuanuama bwaikina ta na nago iama 'u na 'ivaiseni. I lubwaineni tomogonina 'u na 'ivaiseni fai 'ida me Diu i nuakalikalieda wata taunina yama 'eba miava'auta de'e bei Kafaneomi i yogoni.” ");
INSERT INTO yml_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Iesu yadi vona i nogai taiadi i nagoi. 'Akonadi i le'wa vanuga lilivaneye, tolugavianina enavo 'ifwaidi i vetunedi Iesu i voneni i vo, 'Auvea, 'ama toveimea i vonaga side bani'odi i vo, Yau tomogo-'avo'avovo, kebu i da lubwainemu 'u na luku yaku vanuge, wata a bunumayaga kebu nuanuaku a na wai 'waimuye. Kebu yamu folova 'u na 'ivevitaiga, 'u na vonamo nika yaku tofolova i na ve'atumai. ");
INSERT INTO yml_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","A 'asetai ma yamu veimea bega 'amu fata 'u na 'ive'atumaia. Yau wata ma yaku veimea yaku tolugavia 'waidie 'aku fata a na vo, 'U nago” nika i na nago, wata a na vo, 'U mai,” nika i na mai, wata yaku tofolova a na voneni a na vo, Side 'u 'idewai,” nika i na 'idewai. Wata yau bani'odi, yaku to'edakumetavo yadi veimea a vevematayakeyakedi. 'Omu wata ma yamu veimea 'u na vonamo nika viga i na 'a'ava.’” ");
INSERT INTO yml_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tutuyanina Iesu toveimea yana vonanina i nogai, nuana i vogani bega i sivilai 'aila'anidi i yoyogo'wailiga i vonedi i vo, De'e Loma 'ana tomotoga siwe yana vetumagana toketokena, we'e 'omi me Isileli Yaubada yana tomotoga, siwe kebu bani'odi vetumagananina a da veluagai 'waimie 'alo mali tomotoga 'waidie.” ");
INSERT INTO yml_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","I 'a'avana, tomotoganidi i vetunedi i maiaga i viladi tolugavia 'waineye, yana tofolova i 'iseni 'akonadi i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bola kebu 'aiata fuedi i da 'a'avaga, Iesu i nago 'atamana Neini yana tovetutuyamavo wata 'aila'a bwaikina taiadi. ");
INSERT INTO yml_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","'Atamananina kalikalina bega tutuyanina Iesu i le'wa 'ana 'eba luku 'waineye i 'isedi tomotoga 'ifwaidi iadi i wafaga i evai i nunaweni taumaseye. Tomogonina i wafaga tamu 'wabula natudi tubu'eana iavetana, we'e tovemogai fuedi taiadi i nunagoi. ");
INSERT INTO yml_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tutuyanina Iesu i 'isedi i nuavita bwaikina i vonedi i vo, Kebu 'wa na vevemogaiga.” ");
INSERT INTO yml_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bega Iesu i nago 'evo'evo i 'abitonovi nika toeva i tovoi. Iesu i vona tomogonina i wafaga 'waineye i vo, Iaku, a na vonemu, 'u tovoi.” ");
INSERT INTO yml_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tomogonina i 'isala i miabui nika i velamu i welava. Wata Iesu tomogonina inana i vonedi i vo, Side natumi 'akonadi i yawasa.” ");
INSERT INTO yml_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Fuedi i 'iseni i kololo-'afo'afo Yaubada i subiai i vo, Tamu tolu'ivona bwaikaotogina i souyeni 'awasasadeye,” we'e 'ifwaidi i vo, Yaubada i mai yana tomotoga i na fogedi.” ");
INSERT INTO yml_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Naninina Iesu i 'idewaiga, valana i nago 'awalawa Iudia matatabuna 'waineye wata mali tomotoga i miamia lilivaneye i 'aseta. ");
INSERT INTO yml_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wata Ioni Tobafitaiso yana tovetutuyamavo i lu'ivona 'waineye naninidi Iesu i 'idewadewadiga faifaidi. ");
INSERT INTO yml_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Begaidi Ioni tomotoga 'adi 'ailuga i goledi i nagoi 'waineye i vonedi i vo, 'Wa na nagoi yada 'Auvea 'waineye 'wa na velutolieni 'wa na vo, 'Omu kumanimu faifaimu me Diu ta lulukamata ta vo, 'Awaie 'ada To'ita'ita'i i na mai Yaubada 'wainega,”'alo tulina faifaina ta na lulukamata?’” ");
INSERT INTO yml_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tutuyanina i maia Iesu 'waineye i velutolieni i vo, Ioni Tobafitaiso i vetunema nuanuana i na 'asetai 'omu kumanimu faifaimu me Diu ta lulukamata ta vo, 'Awaie 'ada To'ita'ita'i i na mai Yaubada 'wainega,’ 'alo tulina faifaina ta na lulukamata?” ");
INSERT INTO yml_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tutuyanina 'waineye Iesu toviga fuedi i 'i'ive'atumaidi, tomotoganidi yaiaina i agediga i vonevonedi i 'a'awa'a'idi wata tomatasako fuedi i 'i'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Begaidi Iesu i vona Ioni yana tovetutuyamavo 'waidie i vo, 'Wa na vilami 'wa na nagoi Ioni 'waineye, ava'ai a 'i'idewadi 'wa 'isediga wata a veveifufuyedi 'wa nogaidiga faifaidi 'wa na voneni. Side bani'odi 'wa na voneyedi 'wa na vo, Tomatasako i 'i'isadewa, tubusakosako i tutubuoga, tomogodi i velufo'afo'ana i veve'atumai. Tanigadi 'uludi i noganogaya, towafa i tovotovoi wafayega wata Vala 'Atumaina i lulu'ivoneyeni tovewekowekoma 'waidie.’ ");
INSERT INTO yml_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wata 'wa na voneni 'wa na vo, 'Ai'edi aitoi kebu ma yana venuanaluga i na vetumagana 'waikuye, 'eba sosoana 'waineye.’” ");
INSERT INTO yml_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ioni yana tovetutuyamavo i tauya i nunagoi, Iesu 'aila'a 'waidie i veifufu Ioni faifaina i vo, Basenadi 'wa nagoi sali'avu'avuye Ioni 'waineye, aitoi nuanuami 'wa da 'iseni? Tamu tomogo umaumana yana sauluva bikana bani'odi 'ayalele kaukau siaina i nunuga i 'anino'uya? Kebu. ");
INSERT INTO yml_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","'Wa da 'iseni aitoi? Tamu tomogo i vaigavu talauma 'atumaidiega? Kebu. Tomotoganidi bani'odi i vivigavuyediga yadi vanuga 'ai'aiwabudi 'waidie i miamiani. ");
INSERT INTO yml_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nuanuaku a na 'asetai 'wa nagoga 'wa da 'iseni aitoi? Tamu Yaubada yana tolu'ivona? E'e. Mogitana tolu'ivona. Siwe 'ifwaidi tolu'ivona sai'afo va'egai, we'e tomogonina 'wa 'iseniga bwaikaotogina. ");
INSERT INTO yml_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Vona mogitana tomogo bwaikina fai basenadiotoga faifaina i kilumi Yaubada yana Buki nageneye. Yaubada i vona 'ana Venua'ivina 'waineye i vo, A na vonemu. Yaku tomata'aulele a na vetunei i na kumeta yamu 'eda i na vusia.’ ");
INSERT INTO yml_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Wata a na vonemi, tomia fwayafwaya matatabudi sai'afo va'egai, we'e Ioni kumanina bwaikaotogina. Siwe tomotoga bwaikidi wata siaidi 'akonadi i lukuga Yaubada yana 'Eba Veimea nageneye i vagalaka, Ioni ma'itufa i obu fai bola kebu i da lukuga.” ");
INSERT INTO yml_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tutuyanina 'aila'a wata takesi tolaugogona vivinagodi taiadi yana vona i nogai, i ve'awamogitana Yaubada yana nuanua tonovidi fai basenadi Ioni i bafitaisodi. ");
INSERT INTO yml_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","We'e Falisi wata ve'etoboda 'adi tovevo Yaubada yana nuanua faifaidi i vedumwe'ai'ai fai kebu nuanuadi Ioni i na bafitaisodi. ");
INSERT INTO yml_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Begaidi Iesu i vonedi i vo, Tutuya de'e 'ana tomotoga, ava'ai 'wainega a na awatalatutulemi? Yami sauluva ava'ai bani'odi? ");
INSERT INTO yml_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tomotoganimi bani'odi yavayavava to'wava nuanuadi i na vetutuyama 'atamanafouye. Tamu 'aila'a i vegole ediavo 'waidie i vo, Nuanuama tamu nani ta da 'idewai siwe 'wa baila. 'A lauinava siwe kebu 'wa da suya. 'A tailauwawa siwe kebu 'wa da vemogai. Kebu nuanuami yama nuanua 'wa na fali'atumaiedi.’ ");
INSERT INTO yml_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","'Omi yavayavavanidi bani'odi, kebu nuanuami Ioni Tobafitaiso wata yau yama nuanua 'wa na fali'atumaiedi. Ioni i mai 'ani 'wainega i veve'udigana bega yana velu'ui Yaubada 'waineye i na vetoketoke wata kebu oine i da yemuga, 'wa vona 'wa vo, Tomogo no'o, yaiaina i agei.’ ");
INSERT INTO yml_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","We'e yau a vetomotogaotoga a mai kebu a da ve'udiganaga, a 'ani'ani wata a yemuyemu siwe 'wa vo, 'Wa 'iseni, tomogo no'o. 'Awana bwalabwalaina, yana 'ani wata oine yana yemu 'afoina, takesi tolaugogona vivinagodi wata tovedumwe'ai'ai i veveianedi.’ ");
INSERT INTO yml_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aitoi Yaubada yana nuamageta i na vevematayakeyakeni, yana sauluva 'wainega i na veda nuamagetanina tonovina wata 'atumaina.” ");
INSERT INTO yml_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tamu tutuya totafalolo Falisi 'ana wagava Saimoni Iesu i tayegi yana vanuge i na 'ani, bega i nago i miabui. ");
INSERT INTO yml_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","'Atamananina 'waineye tamu vavine toalagogona yana sauluva sakoina. Vala i nogai Iesu i mai Saimoni yana vanuge begaidi bunama magaina 'atumaina wata 'ana tutula bwaikina i 'ewai i luku vanuganina 'waineye. We'e bei i koiaga kileu i 'idewai 'ana 'isa 'atumaiotogina, 'ana wagava alibasita. ");
INSERT INTO yml_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","I nago Iesu lilivaneye i 'we'wela matageunega 'agena i 'ivebutadi mulieta nava'aunega i tamavelavelaladi. Wata ma yana ve'ililibu 'agena i yaogi, i 'a'avana bunamanina 'wainega i iwagi. ");
INSERT INTO yml_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tutuyanina Saimoni i 'iseni nuanega i vo, Kumanina Iesu, 'ai'edi mogitana Yaubada yana tolu'ivona 'ana fata i da 'asetai ava'ai vavinega i 'a'abitonovi wata i da 'asetai yana sauluva sakoina.” ");
INSERT INTO yml_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu i voneni i vo, Saimoni, nuanuaku tamu nani a na vonemu.” Saimoni i vo, Tove, nika 'u veifufu ta na nogai.” ");
INSERT INTO yml_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu i vo, Tamu tomogo 'ai'aiwabuna tomotoga 'adi 'ailuga mani i veledi, bola wata i na tutulidi. Tamu tomogo i veleniga lubulubu 500 wata tamu lubulubu 50. ");
INSERT INTO yml_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Siwe 'adi 'ailuga kebu 'adi fata i na tutulidi bega i talabodedi i vo, 'Asa'aiadi, kebu 'wa na tutulidiga.’ Tomotoganidi 'adi 'ailuga ma yadi sosoana i nuakalikalieni, siwe 'u na voneku aitoi tomotogaga yana nuakalikali bwaikaotogina tomogo 'ai'aiwabuna 'waineye?” ");
INSERT INTO yml_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimoni Iesu yana vona i tutuli i vo, A nuani tomogonina lubulubu 500 i veleni, kumanina i nuakalikalieni bwaikaotogina.” Iesu i vo, 'U vona mogitana.” ");
INSERT INTO yml_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nika i sivilai vavine 'waineye Saimoni i voneni i vo, 'Akonadi 'u 'iseni vavine de'e. We'e 'omu yamu vanuge a maiga, kebu ufa 'u da veleku bega 'ageku a da lekoadi yada sauluva bani'odi, siwe vavine de'e matageunega 'ageku i lekoadi wata nava'aunega i tamavelavelaladi. ");
INSERT INTO yml_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tutuyanina a le'wa kebu ma yamu sosoana 'u da 'avalamaigiku, we'e kumanina 'ageku 'ana yaoga kebu i da 'ailove. ");
INSERT INTO yml_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kebu 'u da ve'ililibuyeku bega bunama 'u da iwagi 'unu'unukuye siwe kumanina bunama magaina 'atumaina 'agekuye i iwaga'a'aveni. ");
INSERT INTO yml_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Begaidi a na vonemu, vavine de'e yana sakona fuedi faifaidi nuatavuna i veluagai, 'u 'iseni yana nuakalikali bwaikina 'waikuye. Aitoi yana sakona siaidi Yaubada i nuatavunidiga tomogonina yana nuakalikali Yaubada 'waineye siaina, we'e aitoi yana sakona fuedi Yaubada i nuatavunidiga, tomogonina yana nuakalikali Yaubada 'waineye bwaikina.” ");
INSERT INTO yml_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iesu vavine i voneni i vo, Yamu sakona a nuatavunidi.” ");
INSERT INTO yml_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","'Ifwaidi tomotoga 'eba 'ani 'waineye i miamianiga, nuadiega i vo, Ava'ai tomogoga de'e sakona i nunuatavunidi?” ");
INSERT INTO yml_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Siwe Iesu i vona vavine 'waineye i vo, Fai 'u vetumaganeku Yaubada i 'ita'ita'iemu. Ma yamu sosoana 'u na nago, Yaubada i na nuakalikaliemu.” ");
INSERT INTO yml_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","'Aiata 'ifwaidi i 'a'ava, Iesu ma yana tovetutuyamavo 12 taiadi i nagoi 'atamana siaidi wata bwaikidi 'waidie, Vala 'Atumaina Yaubada yana veimea tomotoga 'waidie faifaina i lulu'ageyeni. ");
INSERT INTO yml_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Wata 'ifwaidi vevine taiadi i nagoi bega Iesu ma enavo i na 'i'ivaisedi wata 'adi'adi i na kimwakimwane taunidi yadi mani 'waidiega. Vevinenidi 'ifwaidi basenadi Iesu 'adi viga i 'ive'atumaidi wata 'ifwaidi yaiaina i agediga Iesu i vona i 'awa'a'idi. Vevinenidi 'waidiega side kumanidiavo, Meli 'atamana Magidala 'wainega basenadi Iesu i vona yaiaina 7 i 'awa'a'idi 'wainega, Tusa yana vavine Ioana, tomogonina Kini Elodi yana vanuga 'ana to'isave'avina wata Susana. ");
INSERT INTO yml_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tamu 'aiata tomotoga fuedi i deli i maia Iesu 'waineye 'atamana fuedi 'waidiega. Begaidi Iesu vona-awatabaiega i ve 'aila'a 'waidie i vo, Side bani'odi. ");
INSERT INTO yml_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Tamu tomogo i nago bakule yana witi waifeidi i na bakulidi, we'e yadi sauluva luyavuyavulagi. Yana luyavuyavulagi 'waineye witi 'ifwaidi i ve'anita'idi 'eda balebaleye tomotoga yadi 'eba nago 'waineye i badi mulieta manuga i mai i 'anidi. ");
INSERT INTO yml_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","'Ifwaidi i ve'anita'idi bwakebwakeye, tutuyanina i tabo fai fwayafwaya kebu badubadunaga i lala-matayo'o i 'awagi'adi. ");
INSERT INTO yml_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","'Ifwaidi i ve'anita'idi 'awanavenaveye kebu 'adi 'oiga, i ugawegawedi. ");
INSERT INTO yml_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","We'e 'ifwaidi i ve'anita'idi inageye fwayafwaya 'atumaina 'waineye i tabo i vuaga, 'aitamogana 'aitamogana vuagidi 100.” Wata Iesu i vonedi i vo, Veifufu de'e 'wa nogaiga, 'wa na venua'ivineni nika 'wa na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mulieta Iesu yana tovetutuyamavo i voneni i vo, Nuanuama yamu vona-awatabainina 'u da kiavemagetai 'waimeye.” ");
INSERT INTO yml_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iesu i vonedi i vo, 'Akonadi Yaubada i tauyemi nani fuedi givagivadi 'wa 'asetadi yana veimea tomotoga 'waidie faifaina. Siwe tomotoga 'ifwaidi 'aseta i na 'ewai vona-awatabaiega. Tomotoganidi i na 'isa'isa siwe kebu i na 'isa'inanaiga, I na noganogai siwe kebu i na 'asetaiga. Begaidi a veve 'waidie vona-awatabai 'waidiega.” ");
INSERT INTO yml_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Wata Iesu i vonedi i vo, Yaku vona-awatabainina 'ana 'aseta side bani'odi. Waifei, bani'odi Yaubada yana Vona. ");
INSERT INTO yml_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Waifei i ve'anita'idi 'eda balebaleye 'ana nuanua, bani'odi tomotoga Yaubada yana Vona i nogai siwe Seitani i mai vonanina i elodi begaidi kebu 'adi fata i na vetumagana 'alo 'ita'ita'i i na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Waifei i ve'anita'idi bwakebwakeye 'ana nuanua, bani'odi tomotoga ma yadi sosoana Yaubada yana Vona i nogai siwe yadi nuanua 'waidie kebu mogitana i da lukuga. I vetumagana siwe tutuya 'ale'usana. Tutuyanina 'eba sailubu i na veluagai i na baileni. ");
INSERT INTO yml_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Waifei i ve'anita'idi gaweye 'ana nuanua, bani'odi tomotoga Yaubada yana Vona i nogai siwe yadi nuanua bwaikina 'ai'aiwabu wata fwayafwaya 'ana sosoana. Yadi kukuanidi wata yadi mia faifaidi i vevenuafouviga 'wa da vo i da ugawegawedi vuagidi kebu i da kumaga. ");
INSERT INTO yml_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","We'e waifei i ve'anita'idi inageye fwayafwaya 'atumaina 'waineye 'ana nuanua, bani'odi to'idumwebika 'atumaidi Yaubada yana Vona i nogai i 'ewai bega i tokemaiga i nagoga yadi folova Yaubada faifaina bani'odi i vuaga.” ");
INSERT INTO yml_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wata Iesu i vonedi i vo, Kebu tamu aitoi mageta i da kabukabuni 'aivoeyega i da tatalafwaseni 'alo talalia dibuneye i da yatoyatoi. We'e mogitana mageta 'ana 'eba yato 'waineye i lulutalauleni bega tomotoga i mimaia vanuganina nageneye i magemagesedi. ");
INSERT INTO yml_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wata bani'odi ava'ai tomotoga i givediga, matatabuna Yaubada i na sivemagesedi, wata ava'ai i nuagivediga Yaubada i na lu'ivoneyedi i na vemageta. ");
INSERT INTO yml_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Begaidi yaku vonanidi 'wa na venua'ivinedi nika 'wa na 'asetadi. Egavo yaku ve i na vinenegeni wata i na venua'ivineni, yadi 'aseta Yaubada i na 'imoso'ieni bega yadi 'aseta i na vebwaika, we'e egavo kebu i da vinenegeniga, taunidi i vo 'ako yama 'aseta bwaikina, 'asetanina Yaubada i na eloi.” ");
INSERT INTO yml_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesu tainavo ma inadi i maia igodi i da luku Iesu 'waineye nika 'aila'a bwaikina. ");
INSERT INTO yml_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tamu tomogo Iesu i voneni i vo, Inamu wata taimwavo tanotanoge i lulualemu.” ");
INSERT INTO yml_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Iesu 'aila'a i vonedi i vo, Egavo Yaubada yana Vona i noganogai wata i vevematayakeyakeniga taunidi mogitana inaku wata taikwavo.” ");
INSERT INTO yml_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tamu 'aiata Iesu yana tovetutuyamavo taiadi wakeye i dodoga i vonedi i vo, Ta na damana lavu vi'ainega,” nika i tauya. ");
INSERT INTO yml_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tutuyanina i damadamana Iesu i 'eno-mataiva. Yagi'oya bwaikina i nunuga yagina bwaikina waka i ludododogi sai'afoga i da veadagi wata i da kavivila. ");
INSERT INTO yml_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Begaidi tovetutuyamavo i maia Iesu 'waineye i luvagoni i vo, 'Auvea, 'Auvea, sai'afoga ta na wafa.” Iesu i tovoi kaukau wata yagina bwaikidi i talabodedi nika i 'awatagoni i niwalova. ");
INSERT INTO yml_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yana tovetutuyamavo i vonedi i vo, Awale kebu 'wa da vetumagana?” Siwe nuadi i voganidi wata i kololo 'aise'avadi i veifufu i vo, Aitoi tomogoga de'e? Kaukau wata yagina i talabodedi bonana i nogai i vematayakeyakeni.” ");
INSERT INTO yml_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iesu ma enavo i damana i luku 'awalawa Gegesa, 'atamana Galili vi'ainega. ");
INSERT INTO yml_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tutuyanina i obu 'avale tamu tomogo yaiaina i ageiga i veluagai, i mai 'atamana 'wainega. Basenadiotoga yana vanuga i baileni, konekonena i miamia taumata 'awasasadie. ");
INSERT INTO yml_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Tutuya fuedi tomotoga nimana wata 'agena i 'i'iyogoyogonidi bulava kainumu 'waidiega siwe yaiaina i kikiavetoketokei bega i dabadabadi nika i degadega wala'aie. Tutuyanina Iesu i 'iseni, i bwau i lumata'afufu 'waineye. Iesu yaiaina i voneni i vo, 'U 'awa'a'imu 'omu yaiaina sakoimu.” Tomogonina bonana bwaikinega Iesu i voneni i vo, Iesu, Yaubada Tabwaotogineye Natuna, ava'ai nuanuamu 'u na 'idewai 'waikuye? A vevelu'ui 'waimuye kebu 'u na 'ivekokoviku.” ");
INSERT INTO yml_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu i velutolieni i vo, 'Omu aitoi 'amu wagava?” Tomogo i vo, 'Aku wagava 'Aila'a.” De'e bani'odi i voneyediga fai yaiaina fuedi tomogonina i agei. ");
INSERT INTO yml_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yaiaina i toke i velu'ui-vaivaitugana i vo, Kebu nuanuama 'u na tawema 'a na obu Ovu Dududubalina yaiaina yama 'eba mia 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bawe fatala bwaikina 'oya lilivaneye i luluduaduala, begaidi yaiainanidi i taidaida Iesu 'waineye i vo, 'U da tauyema bawenidi 'a na agedi,” nika Iesu i tauyedi. ");
INSERT INTO yml_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yaiaina i 'awa'a'idi tomogo 'wainega i nagoi bawe i agedi fatala matatabuna i ve'ilililide 'oyeamo i obu nika i sou bwagale i ve'alamonumonu lavuye. ");
INSERT INTO yml_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bawe 'adi to'isave'avinavo i 'iseni yadi bawevo i ve'alawafawafa, begaidi i lilide i nagoi i veifufuyeni 'atamana wata kweda 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yadi veifufu i nogai bega fuedi i nagoi i na 'iseni. I maia Iesu 'waineye tomogonina basenadi yaiaina i ageiga i 'iseni, siwe 'akonadi i 'awa'a'idi, yana nuanua i ve'atumai i ve'wesena ma 'ana talauma i miamia, i miabui Iesu 'ageneye, nika tomotoga matatabuna i ve'alakolokololo. ");
INSERT INTO yml_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bawe 'adi to'isave'avinavo i lu'ivona 'waidie bani'odi i munega tomogo i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Begaidi tomotoga matatabudi 'awalawa Gegesa 'waineye, Iesu i voneni i na 'iawedi fai i kololo-'afo'afo. Iesu i vilai wakeye, i dodoga bega i na damana lavu vi'ainega. ");
INSERT INTO yml_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Sai'afoga i da tauya nika tomogonina i ve'atumaiga i mai Iesu i voneni i vo, Yau nuanuaku taiadi ta da nago.” Siwe Iesu i talabodeni i vo, 'U na vilamu 'u na nago yamu vanuge 'u na lu'ivona tomotoga fuedi 'waidie ava'ai Yaubada i 'idewaiga 'waimuye faifaina.” Bega tomogo i nago 'atamana bwaikina 'ana tomia matatabudi 'waidie i veifufu Iesu i 'ive'atumaiaga faifaina. ");
INSERT INTO yml_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesu ma enavo 'akonadi i damanama, tutuyanina i le'wa lavu vi'ainega 'aila'a i veluagadi i lulukamaseni. ");
INSERT INTO yml_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","I obu 'avale nika me Diu yadi 'eba miava'auta 'ana to'edakumeta tamu i veluagai 'ana wagava Yailo. Ma yana ve'ililibu i lumata'afufu Iesu 'ageneye i velu'ui-nuakalikali i vo, Nuanuaku ta na nago yaku vanuge natuku vevinena sai'afoga yawaina i na 'a'ava 'u na 'ivaiseni. Natukunina tubu'eana yaku tamogana, 'ana malamala 12.” Bega Iesu taiadi i nago wata 'aila'a bwaikina i vevetunufelagieni nuanuadi Iesu taiadi i na nago. ");
INSERT INTO yml_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","'Aila'anina nageneye tamu vavine, vevine 'adi viga i 'ewadi, malamala 12 nagedie kebu i da 'a'ailove viganina i 'eno'eno. Fu'eyega yadi kukua matatabuna i sigoidi siwe kebu tamu aitoi 'ana fata i na 'ivaisedi. ");
INSERT INTO yml_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Vavinenidi i mai Iesu mulineye, 'ana talauma mataifwana i 'abitonovi nika 'adi viga i 'a'ava. ");
INSERT INTO yml_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iesu 'aila'a i velutoliedi i vo, Aitoi i 'abitonoviku?” Matatabudi i ve'ewa we'e Fita i vo, 'Auvea awale bani'odi 'u velutoliedi? 'U 'iseni, 'aila'a bwaikina i sififinemu.” ");
INSERT INTO yml_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Siwe Iesu i vo, A 'asetai tamu tomogo nuanuana yau begaidi i 'abitonoviku, fai 'aku vebae 'wainega a 'asetai yaku toketokena i damana to'abitonovanina 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Vavinenidi i nuani 'akonadi Iesu i 'asetadi, begaidi ma yadi kololo i tatava wata ma yadi ve'ililibu i lumata'afufu Iesu 'ageneye. Nika 'aila'a 'awasasadie i lu'ivona Iesu 'waineye, ava'ai faifaina i 'abitonovi wata bani'odi i munega i ve'atumai-matayo'o, we'e tomotoga fuedi i vivinenegeni. ");
INSERT INTO yml_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iesu i vonedi i vo, Natuku, yami vetumagana 'waikuye i 'ive'atumaimi. Ma yami sosoana 'wa na nago.” ");
INSERT INTO yml_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tutuyanina Iesu i veveifufu, tamu tomogo i mai Yailo yana vanuga 'wainega Yailo i voneni i vo, Natumu 'akonadi yawaina i 'a'ava. Kebu Tove 'u na vevekadia.” ");
INSERT INTO yml_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Siwe Iesu i nogaiga Yailo i voneni i vo, Kebu nuafoumu i na veviga, 'u na vetumaganamo 'waikuye natumu i na ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","I nagoi i le'wai vanuge, tomotoga fuedi i talabodedi kebu i na lukuga, we'e Fita, Ioni, Iemesa wata kwamana inana tamana taiadi i luku. ");
INSERT INTO yml_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Fuedi vanuga nageneye i vevemogai kwamananina faifaina siwe Iesu i vonedi i vo, Kebu 'wa na vemogaiga, kwamana de'e kebu i da wafaga i 'eno'enomo.” ");
INSERT INTO yml_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Matatabudi Iesu i sidibidibieni wata i namageni fai i 'asetai kwamana mogitana i wafa. ");
INSERT INTO yml_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Siwe Iesu kwamana nimaneye i 'abi bonana bwaikinega i vo, Kwamana, 'u tovoi.” ");
INSERT INTO yml_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nika kwamana i yawasa i tovoi nika Iesu i vonedi i vo, 'Ani'ani 'wa na veleni i na 'ani.” ");
INSERT INTO yml_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kwamananina inana wata tamana nuadi i voganidi siwe Iesu i vonedi i vo, Kebu tamu aitoi 'waineye 'wa na lulu'ivonaga.” ");
INSERT INTO yml_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tamu tutuya Iesu yana tovetutuyamavo 12 i goleva'augidi, veimea wata toketokena i veledi bega toviga i na 'ive'atumaidi wata yaiaina i na vonedi i na 'awa'a'idi. ");
INSERT INTO yml_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mulieta i vetunedi i na lau'age 'atamana fuedi 'waidie Yaubada yana veimea tomotoga 'waidie faifaina wata toviga i na 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Siwe Iesu i velu'ase'asedi i vo, Tutuyanina 'wa na nunagoiga kebu venuana 'wa na 'ewaga, wata wautogana kebu, 'ani'ani kebu, mani kebu, wata talauma vunavunagidi. ");
INSERT INTO yml_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","'Ai'edi aitoi i na vonemi 'wa na luku yana vanuge bei 'wa na miamia mulieta yami folova i na 'a'ava 'atamananina 'waineye, vanuganina 'wa na 'iaweni. ");
INSERT INTO yml_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wata 'ai'edi ava'ai 'atamanaga 'ana tomotoga i na vedumwe'ubu'ubusemi wata yami vona kebu i na nogaidiga, 'wa na 'iawedi 'wa na nagoi wata 'agemiega fwayafwaya 'wa na lubutubutuya yadi 'eba 'isa 'wainega i na 'asetai 'awaie vematavuloga i na veluagai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mulieta tovetutuyamavo i tauya i nagoi 'atamana fuedi 'waidie i lalau'age Vala 'Atumaina faifaina wata tomotoga i 'i'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kini Elodi, 'awalawa Galili 'ana toveimea, Iesu yana folova valana i nogai nuana i vogani fai tomotoga 'ifwaidi i vonavona i vo, No'o Iesu, 'asa'aiana mogitana taunina Ioni Tobafitaiso i yawasa-vaitugana i ve-Iesu.” ");
INSERT INTO yml_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","We'e 'ifwaidi i vo, Ilaitia i vilai i mai abamayega,” wata 'ifwaidi i vo, Tamu tolu'ivona basenadiotoga i wafa wata i yawasa.” ");
INSERT INTO yml_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","We'e Elodi i vo, Ioni 'odona a boboi, we'e ava'ai tomogoga no'o valana a noganogai?” Bega i nuanua bani'odi i na munega Iesu i na 'iseni. ");
INSERT INTO yml_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Basenadi Iesu yana tovetutuyamavo i vetunediga 'akonadi i viladi i maia nani matatabuna i 'idewadiga faifaidi i lu'ivona Iesu 'waineye. I veifufu'a'ava, mulieta i vagavaidi 'aise'avadi i nagoi 'atamana Bedasaida. ");
INSERT INTO yml_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Siwe tomotoga fuedi valana i 'asetai ava'aibe bei i nunagoi begaidi Iesu i yogo'waili. Iesu i 'isedi nika i lu'uma'umaiedi mulieta Yaubada yana veimea faifaina i ve 'waidie wata toviga fuedi i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","'Akonadi i lavia sai'afoga i na sidudubali tovetutuyamavo i maia Iesu 'waineye i voneni i vo, Tomotoga 'u na vetunedi i na nagoi taunidi 'adi'adi i na lauala 'atamana wata kweda 'waidie wata bei i na 'eno fai de'e bei kebu tomotogina.” ");
INSERT INTO yml_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Siwe Iesu i vo, 'Omi taunimi 'wa na ve'anidi.” Yana vona i tutuli i vo, De'e 'aila'a bwaikaotogina we'e 'ima 'waimeye 'ani'ani mwadodoudi 5 wata igana 'ailuga, 'asa'aiana bani'odi, kebu fuediga. 'Alo nuanuamu 'a na nagoi 'adi'adi 'a na kimwane 'atamane?” ");
INSERT INTO yml_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","'Aila'anidi iaveta tulai'avadi 5,000 wata vevine kwakwama taiadi. Iesu yana tovetutuyamavo i vonedi i vo, Tomotoga 'wa na vonedi i na veiwakukuna, 'aila'a 'aitamogana 'aitamogana bani'odi 50.” ");
INSERT INTO yml_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yana tovetutuyamavo i nagoi tomotoga i vemianidi. ");
INSERT INTO yml_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","I 'a'avana Iesu 'ani'ani 5 wata igana 'ailuga i 'ewadi i 'isalaka abame Yaubada 'waineye i vekaiwa mulieta i 'ivividi yana tovetutuyamavo i veledi tomotoga i veutadi. ");
INSERT INTO yml_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","I 'ani'a'ava matatabudi kamodi i aidi, mulieta tovetutuyamavo tomotoga nikilidi i va'augidi bayawa 12 i veadagidi. ");
INSERT INTO yml_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tamu tutuya Iesu 'aiseneye i vevelu'ui Yaubada 'waineye, yana tovetutuyamavo i nagoi 'waineye i velutoliedi i vo, 'Wa da nogaiga tomotoga yadi nuanua yau aitoi?” ");
INSERT INTO yml_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yana velutoli i tutuli i vo, 'Ifwaidi i vonaga 'omu Ioni Tobafitaiso wafayega i yawasa, 'ifwaidi i vonaga 'omu Ilaitia, wata 'ifwaidi i vonaga 'omu tamu Yaubada yana tolu'ivona wafayega i tovoi.” ");
INSERT INTO yml_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wata yana tovetutuyamavo i velutoliedi i vo, We'e 'omi 'wa da 'asetai yau aitoi?” Fita i vo, 'Omu Keliso, Yaubada 'ana Venua'ivina.” ");
INSERT INTO yml_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bega Iesu yana tovetutuyamavo i toke i talabodedi i vo, Kebu tamu aitoi 'waineye 'wa na lu'ivonaga yau Keliso, Yaubada 'ana Venua'ivina. ");
INSERT INTO yml_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","I lubwaineku yau a vetomotogaotoga veviga fuedi a na veluagadi. Me Diu yada to'edakumeta 'au'auveadi, tovelomu yadi to'edakumetavo taiadi wata ve'etoboda 'adi tovevo i na vedumwe'ai'aieku, mulieta i na luvewafaku siwe 'aiata 'ana vetonu 'waineye Yaubada i na sivetovoiku.” ");
INSERT INTO yml_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mulieta matatabudi i vonedi i vo, 'Ai'edi aitoi nuanuana mogitana i na mai 'waikuye taiadi 'a na nagoga, 'aiata 'aitamogana 'aitamogana taunina yana nuanua i na bailedi. Fai i na vematayakeyakeku veviga bwaikina i na veluagai yau bani'odi a na veluagai. Voke i na wafa faifaiku, yau bani'odi a na wafa 'ai lagalagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","'Ai'edi aitoi yana mia 'ana 'atumaina i na ve'o'oleni kebu nuanuana yawaina i na tauyeni faifaiku, kumanina i na wafaotoga. We'e 'ai'edi aitoi yana mia 'ana 'atumaina wata yawaina i na tauyedi faifaiku, mia 'atumaina wata miamia-vagaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","'Ai'edi tamu aitoi fwayafwaya matatabuna 'ana kukua i na 'ewadi mulieta yawaina i na 'a'ava, ava'ai 'ana 'atumaina? ");
INSERT INTO yml_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","We'e 'ai'edi aitoi yau faifaiku wata Valaku 'ana lu'ivona faifaina i na bunumayaga, yau a vetomotogaotoga bola ma yaku mageta mataududulina a na vila-vaituganiku wata a na bunumayageni. Yaku vila-vaitugana 'waineye, anelose magemagetadi taiadi 'a na maia, Tamaku yana mageta mataududulina nageneye. ");
INSERT INTO yml_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A vona mogitana 'waimie, 'omi 'ifwaimi bola ma yawaimi 'wa na miamiani, nagami 'wa na 'iseni Yaubada yana veimea tomotoga 'waidie, mulieta 'wa na wafa.” ");
INSERT INTO yml_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iesu i veifufu i 'a'ava, 'aiata 8 sai'afoga i na veluagai, yana tovetutuyamavo Fita, Iemesa wata Ioni i vagavaidi taiadi i laka 'oya 'waineye 'aise'avadi i na velu'ui. ");
INSERT INTO yml_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tutuyanina Iesu i vevelu'ui Yaubada 'waineye, maigina 'ana 'isa i vetuli wata 'ana talauma 'adi lau'avu mataududulidi. ");
INSERT INTO yml_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","I 'ise'iseni nika tomotoga 'adi 'ailuga i souyedi Iesu taiadi i veveifufu. Tomotoganidi Mosese wata Ilaitia, taunidi basenadiotoga Yaubada yana tolu'ivonavo, 'adi 'isa mataududulina. Yadi veifufunina 'waineye i vonavona Iesu yana souyagi faifaina, 'awaie Ielusalema 'waineye fwayafwaya de'e i na 'iaweni. ");
INSERT INTO yml_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Fita ma enavo i 'eno'eno mulieta i 'isa Iesu yana mageta mataududulina wata tomotoga 'adi 'ailuga taiadi i tovotovoi i 'isedi. ");
INSERT INTO yml_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tomotoganidi sai'afoga i na tauya nika Fita kebu i da venua'ivina-dewaga, i vona-matayo'o i vo, 'Auvea, 'ima taiadi ta miamiani, nani 'atumaiotogina 'waimeye. 'Ai'edi 'u na tauyema lau'weta 'aitonu 'a na 'idewadi, tamu 'omu faifaimu, tamu Mosese wata tamu Ilaitia faifaina.” ");
INSERT INTO yml_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bola i veveifufu waowa i mai i ve'i'wa'uyedi mulieta i obu i tavunidi tovetutuyamavo 'adi 'aitonu i kololo bwaikina. ");
INSERT INTO yml_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bona'ava i nogai waowa 'wainega i vo, De'e Natuku, kumanina a venua'ivineni, bonana 'wa na nogai.” ");
INSERT INTO yml_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tutuyanina i veifufu i 'a'ava, nika Iesu i 'iseni 'aise'avana i tovotovoi. Tutuyanina 'waineye tovetutuyamavo kebu tamu aitoi 'waineye i da lu'ivona ava'ai i 'iseniga faifaina. ");
INSERT INTO yml_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Iesu yana vemaigisivilavila i 'a'ava, i 'atai 'oyayega ma enavo i obuma 'aila'a bwaikina i veluagadi. ");
INSERT INTO yml_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","'Aila'anidi 'waidiega tamu tomogo i vegole i vo, Tove, natuku tubu'eana iavetana yaku tamogana nuanuaku 'u na 'ivaiseni. ");
INSERT INTO yml_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yaiaina basenadi i agei, tutuyanina i vevekadia i vebwaubwau nika i vavatu'oga wata buobuo 'awana i tutubodai. Wata i vevekadi-vebogia, kwamana i veveviga bwaikina taunina i 'i'ivekokovi. ");
INSERT INTO yml_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yamu tovetutuyamavo a vonedi nuanuaku i da vona yaiaina i da 'awa'a'ia siwe kebu 'adi fataga.” ");
INSERT INTO yml_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu tomotoga i vonedi i vo, 'Omi tovekali. Awale Yaubada yana toketokena kebu 'wa da vetumaganeniga? Tutuya manamanawena taiadi ta miamia wata a totokemaigeku siwe kebu mogitana 'wa da vetumaganeku.” Iesu kwamana tamana i voneni i vo, Nika natumu 'u mieni ta na 'iseni.” ");
INSERT INTO yml_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kwamananina i nunagoga Iesu 'waineye yaiaina i vatufeleni i be'u fwayefwayeye i vatu'o'oga. Iesu yaiaina i talabodeni nika i 'awa'a'ia kwamana i ve'atumai, mulieta tamana i voneni i mai natuna i 'ewai. ");
INSERT INTO yml_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tomotoga matatabudi i 'iseni, nuadi i voganidi Yaubada yana toketokena faifaina. ");
INSERT INTO yml_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tomotoga bola i nunuavogana nani matatabuna Iesu i 'idewadiga faifaidi we'e yana tovetutuyamavo i vonedi i vo, Ava'ai a na vonemiga kebu nuami i na fani. Yau a vetomotogaotoga i na 'aniveleneku 'aku gaviavo yadi toketokena 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Siwe tovetutuyamavo kebu i da 'asetaiga yana vonanina 'ana nuanua. Yana nuanuananina Yaubada i giveni bega kebu 'adi fata i na 'asetai, i kololo kebu nuanuadi i na velutolieni. ");
INSERT INTO yml_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tamu tutuya Iesu yana tovetutuyamavo 'aise'avadi i ve'ikwayekwayega 'adi 'aila'a nageneye aitoi bwaikaotogina. ");
INSERT INTO yml_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu 'akonadi yadi nuanua i 'asetai begaidi tamu kwamana i goleni i nago i tovoi lilivaneye. ");
INSERT INTO yml_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","I vonedi i vo, 'Ai'edi aitoi ma yana nuakalikali tamu kwamana de'e bani'odi i na 'ivaiseni faifaiku, siwe 'asa'aiana yau i 'ivaiseku. Wata 'ai'edi aitoi ma yana nuakalikali i na 'ivaiseku, siwe 'asa'aiana Yaubada taunina 'aku tovetune i 'ivaiseni. Aitoi siaina matamie, taunina bwaikaotogina Yaubada mataneye.” ");
INSERT INTO yml_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tamu Iesu yana tovetutuyama 'ana wagava Ioni i mai i vona i vo, 'Auvea, tamu tomogo 'a 'iseni 'amu wagavayega i vonavona yaiaina i 'a'awa'a'idi. 'A 'iseni 'a talabodeni fai taunina kebu 'ada 'aila'a.” ");
INSERT INTO yml_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu i vona Ioni 'waineye wata 'ifwaidi yana tovetutuyamavo 'waidie i vo, Kebu 'wa na talabodeniga, 'ai'edi aitoi kebu i na vedumwe'ai'aiemiga taunina 'ami to'aivaita.” ");
INSERT INTO yml_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","'Akonadi Iesu yana tutuya i velilivana Yaubada i na vagavaia i na naweni abame. Begaidi ma yana tokemaiga i tovoi ma yana tovetutuyamavo i na nagoi Ielusalema. ");
INSERT INTO yml_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","I nunagoi 'edeye Iesu tomotoga 'ifwaidi i vonedi i na kumeta yadi 'eba veawai i na 'idewadewai me Samelia yadi 'atamane. ");
INSERT INTO yml_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Fai me Samelia wata me Diu kebu taiadi i da veveiana wata fai Iesu i nunago Ielusalema, me Diu yadi 'atamana bwaikina 'waineye, begaidi i talaboda kebu nuanuadi Iesu ma enavo i na miamiani yadi 'atamane. ");
INSERT INTO yml_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","We'e Ioni wata Iemesa tomotoga yadi talaboda i nogai Iesu i voneni i vo, 'Auvea bani'odi? Nuanuamu 'a na vona 'ai-'ala'alata abamayega i na obuma tomotoga de'e i na 'ala'a'avadi?” ");
INSERT INTO yml_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Siwe Iesu i sivilai i talabodedi, mulieta i tovoi i nagoi tamu 'atamana 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tutuyanina i nunagoi 'edeye tamu tomogo i vona Iesu 'waineye i vo, Yau 'akonadi a tauyeku 'waimuye, 'ai'edi ava'aibe bei 'u na nunagoga yau taiadi.” ");
INSERT INTO yml_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu tomogonina yana vona i tutuli i vo, 'U na nuani 'ou'ou walawala'ai ma 'adi ovu, manuga ma 'adi giuva, we'e yau a vetomotogaotoga kebu yaku vanuga bei a na 'eno 'alo a na veawai.” ");
INSERT INTO yml_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wata Iesu tamu tomogo i voneni i vo, Nuanuaku 'omu taiadi ta na nago, yaku tovetutuyama.” Nika tomogonina i vo, 'Auvea, 'atumaina siwe nuanuaku a na miamia nagami tamaku a na ve'ufai mulieta a na wai a na vetutuyamemu.” ");
INSERT INTO yml_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Siwe Iesu i vo, Kumanidiavo 'anu'anunudi wafawafadi, taunidi yadi towafa i na veve'ufadi. We'e 'omu 'u na nago 'u na lau'age Yaubada yana veimea tomotoga 'waidie faifaina.” ");
INSERT INTO yml_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wata tamu tomogo i vo, 'Auvea, nuanuaku a na vetutuyamemu, siwe nagami a na nago a na 'alanuai natukwavo wata yaku vavine 'waidie.” ");
INSERT INTO yml_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Siwe Iesu tomogonina i voneni i vo, 'Ai'edi aitoi nuanuana i na vetofolova faifaiku we'e ma yana venuanaluga taunina faifaina i na nuanua, kebu 'ana fata i na vetofolova Yaubada faifaina wata kebu 'ana fata Yaubada i na veimeyeni.” ");
INSERT INTO yml_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iesu tomotoga 'adi 'aitonu 'waidie i vona'a'ava mulieta tomotoga 72 i venua'ivinedi yana tovetutuyamavo. 'Adi 'ailuga 'adi 'ailuga i vetunedi i na kumeta 'atamana bwaikidi wata siaidi 'waidie, 'atamananidi 'waidie bola Iesu i na nago. ");
INSERT INTO yml_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iesu i vonedi i vo, Tomotoga fuedi i da luku Yaubada yana 'Aila'a 'waineye 'wa da vo bani'odi tutuya 'aile'wa, siwe tofolova kebu fuediga. Begaidi 'wa na velu'ui 'Auvea 'waineye, kumanina 'wa da vo 'aile'wa 'ana toveimea bega tofolova fuedi i na vetunedi 'ana talage tomotoga i na mimaiedi Yaubada 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","A na vonemi, 'ou'ou walawala'ai sifi natudi i ovaovadi, wata bani'odi a vevetunemi tomotoga kasikasisidi 'waidie vita i na velevelemi. ");
INSERT INTO yml_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kebu mani 'wa na 'ewadiga, venuana 'alo 'ageyafayafa 'ifwaidi. 'Ai'edi aitoi 'edeye 'wa na veluagaiga kebu taiadi 'wa na veveifufu manamanawena, 'wa na nago-matayo'o 'wa na lau'age. ");
INSERT INTO yml_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","'Ai'edi tamu vanuga 'waineye 'wa na lukuga vanuganina 'ana tomia 'wa na vona-nuakalikaliedi 'wa na vo, Kaiwa, ma yami sosoana 'wa na miamia, Yaubada i na vesauluva-'atumai 'waimie.’ ");
INSERT INTO yml_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","'Ai'edi 'waidiega tamu tomogo nuanuana yami vona-nuakalikali i na nogai, Yaubada i na vesauluva 'atumaina 'waineye. We'e 'ai'edi kebu nuanuadi yami vona-nuakalikali, ma'itufa Yaubada i na vesauluva 'atumaina 'waimie. ");
INSERT INTO yml_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Vanuganina 'waineye 'wa na lukuga bei 'wa na miamia, kebu 'wa na miayaba-vuvua vanuga fuedi 'waidie. 'Ani'ani i na 'idewaiga faifaimi 'wa na 'ani wata 'wa na yemu, kebu 'wa na bunumayaga fai tofolova i lubwainedi ma 'adi 'aivaita. ");
INSERT INTO yml_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","'Ai'edi ava'ai 'atamanaga 'ana tomotoga yami nago 'waidie faifaina i na sosoana, bega ava'ai i na 'idewaiga faifaimi kebu 'wa na venuanaluga 'wa na 'animo. ");
INSERT INTO yml_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","'Atamananina 'waineye toviga 'wa na 'ive'atumaidi wata tomotoga matatabudi 'wa na vonedi 'wa na vo, Sai'afoga Yaubada yana veimea i na souyeni 'waimie.’ ");
INSERT INTO yml_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","'Ai'edi ava'ai 'atamanaga kebu ma yadi sosoana i na lu'uma'umaiemiga i na vedumwe'ai'aiemi, 'wa na nagoi yadi 'atamanafouye 'wa na vonedi 'wa na vo, 'Wa 'isema, yami 'atamana fwayafwayana 'agemega 'a luvutuvutugi, yami 'eba 'isa 'awaie vematavuloga 'wa na veluagai Yaubada 'wainega. Siwe i lubwainemi 'wa na 'aseta-'atumaia, sai'afoga Yaubada yana veimea i na souyeni 'waimie.’ ");
INSERT INTO yml_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A na vonemi, 'awaie Vonayavuga 'ana 'Aiata 'waineye me Sodoma 'adi vematavuloga i na veluagai Yaubada 'wainega siwe sai'afo i na 'isanuakalikaliedi, we'e tomotoganidi i na vedumwe'ai'aiemiga 'adi vematavuloga bwaikaotogina i na veluagai 'aiatanina 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wata Iesu i vo, Ieu, 'omi me Kolesini wata me Bedasaida nuakalikalimi, 'waimie vita bwaikina i na souyeni. We'e basenadiotoga me Taia wata me Saidoni yadi sakona bwaikidi faifaidi Yaubada i leodi. 'Ai'edi 'eba nuavogana wata 'eba nua'ewa a 'idewadiga 'waimie, wata tosakonanidi 'waidie a da 'idewadiga, 'ako i da vemwakula wata talauma sakoidi i da ve'wesenedi, yadi nuavilana 'ana tugusa. ");
INSERT INTO yml_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","A na vonemi, 'awaie Vonayavuga 'ana 'Aiata 'waineye me Taia wata me Saidoni 'adi vematavuloga i na veluagai Yaubada 'wainega siwe sai'afo i na 'isanuakalikaliedi, we'e 'omi yaku vona 'wa baila kebu 'wa da nuavilamiga vita bwaikaotogina 'wa na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","We'e 'omi me Kafaneomi taunimi 'wa awa'ai'aimi igodi 'wa vo, 'Ima 'atumaima, 'a na luku abame,’ siwe mogitana Yaubada i na veimea 'wa na obu towafa yadi 'eba mia 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wata Iesu i vona yana tovetutuyamavo 'waidie i vo, 'Ai'edi aitoi yami vona i na nogai, siwe 'asa'aiana yaku vona i nogai, wata 'ai'edi aitoi i na vedumwe'ai'aiemi siwe 'asa'aiana yau i vedumwe'ai'aieku. Wata 'ai'edi aitoi i na vedumwe'ai'aieku siwe 'asa'aiana Yaubada 'aku tovetune i vedumwe'ai'aieni.” ");
INSERT INTO yml_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tomotoganidi 72 basenadi Iesu i vetunediga, 'akonadi yadi folova i ve'a'ava, ma yadi sosoana i viladi i maia Iesu 'waineye. I le'wai i voneni i vo, 'Auvea, 'amu wagavayega 'a vona yaiaina 'waidie i vematayakayaka i 'awa'a'idi.” ");
INSERT INTO yml_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iesu yadi vona i tutuli i vo, Yau a 'iseni Seitani yana toketokena i mwea abamayega i 'anita'ia 'ana 'isa bani'odi tamuyoana i kianamali. ");
INSERT INTO yml_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wata a na vonemi, veimea 'akonadi a velemi bega 'ami fata 'o'olo dabadabana wata dinigala weweda 'wa na badi kebu i na ovamiga. Toketokenanina 'wainega 'wa na vetoketoke 'ami gaviavo Seitani ma enavo yaiaina 'waidie bega kebu tamu nani sakoina 'wainega i na nikemi. ");
INSERT INTO yml_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","'Wa sosoana fai yaiaina yami vona i vematayakeyakedi. 'Atumaina, siwe kebu nani bwaikina. Mogitana 'wa na sosoana fai 'akonadi 'ami wagava i 'eno'enovi abame.” ");
INSERT INTO yml_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tutuyanina 'waineye 'Anu'anunu Magemagetana Iesu i kiavesosoani i vo, Tamaku, 'omu abama wata fwayafwaya 'adi Toveimea, a vekaiwa 'waimuye fai yaku ve 'adi 'aseta 'u givedi kumanidiavo igodina tonuamageta wata to'aseta 'waidiega, we'e egavo i nunuaobuga yavayavava bani'odi, yaku ve 'adi 'aseta 'u kiavemagetadi 'waidie. Tamaku, vona mogitana ava'ai yamu nuanua i lubwaineniga 'akonadi 'u 'idewai 'amu kiavesosoana.” ");
INSERT INTO yml_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Iesu i velu'ui i 'a'avana tomotoga i vonedi i vo, Nani matatabuna Tamaku i 'anivelenedi 'waikuye a veveimeyedi. Kebu tamu aitoi yau Yaubada Natuna i da 'asetaku, Tamaku 'aiseotogina 'aku to'aseta. Wata kebu tamu aitoi Tamaku i da 'asetai, yau Natuna 'aiseotogiku 'ana to'aseta wata 'ai'edi egavo nuanuaku, 'waidie Tamaku a na sivemageseni.” ");
INSERT INTO yml_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mulieta Iesu yana tovetutuyamavo 'aise'avadi i vonedi i vo, 'Eba sosoana 'waimie fai 'eba nuavogana wata 'eba nua'ewa a 'idewadewadi matamie. ");
INSERT INTO yml_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","We'e a na vonemi, tolu'ivona wata toveimea fuedi nuanuadi bwaikina yaku folovanidi 'wa 'ise'isediga i da 'isedi, wata yaku ve 'wa noganogaiga i da nogai siwe kebu.” ");
INSERT INTO yml_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mulieta tamu ve'etoboda 'adi tove i mai Iesu 'waineye nuanuana i na velutolieni bonana i na nogai, 'ai'edi i na vekaliga 'adi fata i na 'ive'avini. Begaidi i velutolieni i vo, Tove, ava'ai a na 'idewai bega mia 'atumaina wata miamia-vagaina a na veluagai?” ");
INSERT INTO yml_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesu yana velutoli i tutuli i vo, Veimeanina Mosese i kilumiga bani'odi i voneyedi?” ");
INSERT INTO yml_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tomogo i vo, 'Auvea yami Yaubada 'wa na nuakalikalieni mogitana nuamiega, 'anu'anunumiega, yami toketokena matatabuna 'waidiega wata yami nuanua 'waidiega. Wata emiavo 'wa na nuakalikaliedi taunimi 'ami nuakalikali bani'odi.” ");
INSERT INTO yml_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu tomogo i voneni i vo, 'Asa'aiana 'u vona mogitana. Veimeanidi 'u na 'i'idewadi bega mia 'atumaina wata miamia-vagaina 'u na veluagai.” ");
INSERT INTO yml_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tomogonina kebu nuanuana i na bunumayaga 'aila'a matadie begaidi i velutoli-vaitugana i vo, Aitoi tomogoga iaku?” ");
INSERT INTO yml_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tomogonina yana vona Iesu i tutuli i vo, Side bani'odi. Tamu tomogo Diu Ielusalemayega i tauya i obuobu Ieliko. 'Edeye tovainago i veluagadi i 'ive'avini, 'ana talauma i silabulabu'i wata i toke i nikei, sai'afoga i da luvewafai. Yana kukua wata yana mani i eloi i baileni 'edeye i 'eno'eno i dega. ");
INSERT INTO yml_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","'Aiatanina 'waineye tamu tovelomu 'edanina 'waineamo i nunago i 'iseni i kekeseni. ");
INSERT INTO yml_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wata bani'odi tamu tovelomu 'adi to'aivaita i mai i 'isanaweni i nago lilivaneye i 'isadewai wata i kekeseni. ");
INSERT INTO yml_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mulieta tamu tomogo Samelia i mai, kumanidiavo me Diu kebu taiadi i da veveianaga, i 'iseni nika i 'isanuakalikalieni. ");
INSERT INTO yml_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","I nago 'waineye 'ana kini'ona i lumulamuladi bunama wata oine 'waidiega. Mulieta i silakaveni yana doniki kwavuneye nika i naweni vanuga wakawaka 'waineye bei lovana 'aitamogana i 'isave'avini. ");
INSERT INTO yml_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","I 'atai mani i 'ewai i nago vanuga wakawaka 'ana to'isave'avina lubulubu 'ailuga i veleni wata i velu'ase'asei i vo, Tomogo 'u na 'isave'avini mani de'e 'wainega. 'Ai'edi maninina 'u na ve'a'avaiga, bola a na vilaku a na mai wata mani a na velemu yamu 'isave'avina tutulina.’” ");
INSERT INTO yml_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Veifufunina Iesu i ve'a'avai mulieta ve'etoboda 'adi tovenina i velutolieni i vo, Tomotoganidi 'adi 'aitonu 'waidiega 'u da nuani, tomogonina i nikeiga aitoi iana?” ");
INSERT INTO yml_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ve'etoboda 'adi tove i vo, Tomogonina i 'isanuakalikalieniga taunina mogitana iana.” Begaidi Iesu i voneni i vo, Wata 'omu bani'odi 'u na nago mali tomotoga 'u na 'isanuakalikaliedi wata 'u na vesauluva 'atumaina 'waidie.” ");
INSERT INTO yml_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu ma enavo i nunagoiga i le'wai tamu 'atamana 'waineye, bei tamu vavine 'ana wagava Malida i vonedi i luku yana vanuge 'ani faifaina. ");
INSERT INTO yml_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wata Malida taina 'ana wagava Meli i mai Iesu lilivaneye i miabui yana veifufu i vivinenegeni. ");
INSERT INTO yml_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Malida 'aisena 'ani'ani i 'idewadewa begaidi i nuavita bwaikina, i mai Iesu i voneni i vo, 'Auvea 'u 'iseni, yau 'aiseku a 'i'idewadewa, siwe voke kebu faifaina 'u da nuanua. Meli 'u da voneni i da 'ivaiseku.” ");
INSERT INTO yml_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Iesu i vo, Malida, Malida, 'omu nuamu 'u 'ivegauya nani fuedi 'waidiega. ");
INSERT INTO yml_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mogitana nani 'aitamogana i lubwaineni faifaina 'u na nuanua. Naninina faifaina taimu Meli i nuanua. Fai i nuaniku begaidi kebu a na talabodeniga.” ");
INSERT INTO yml_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tamu tutuya Iesu i vevelu'ui tamu 'awalawa 'waineye. Tutuyanina i ve'a'ava, tamu yana tovetutuyama i voneni i vo, 'Auvea, nuanuama velu'ui 'u da vema, bani'odi Ioni Tobafitaiso yana tovetutuyamavo velu'ui i vedi.” ");
INSERT INTO yml_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iesu i vonedi i vo, Side bani'odi 'wa na vevelu'uiedi 'wa na vo, Tamama, 'omu magemagetamu, nuanuama tomotoga fuema 'a na ve'ililibuyemu. Nuanuama 'u na veveimeyema, ");
INSERT INTO yml_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nuanuama 'ama'ama 'u na velevelema 'aiata 'aitamogana 'aitamogana faifaidi. ");
INSERT INTO yml_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mali tomotoga i vesauluva sakoina 'waimeye 'a nuatavunidi, 'omu wata bani'odi yama sakona 'u da nuatavunidi. 'Eba sailubu 'waidie kebu 'u na tauyema.’” ");
INSERT INTO yml_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Wata Iesu i ve yana tovetutuyamavo 'waidie velu'ui 'ana 'aseta faifaina. I vo, 'Ai'edi tamu aitoi 'waimiega 'u da 'eno'eno nika tamu iamu i da le'wa lovana 'ana utukamwane siwe 'ani'ani kebu, bega 'u da nago wata tamu iamu yana vanuge 'u da vo, Iaku, tamu tomogo 'ani'ieyega i mai siwe 'ani'ani kebu begaidi a mai 'waimuye 'ani'ani 'aitonu 'u na veleku bola a na tutulidi.’ ");
INSERT INTO yml_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","We'e 'ai'edi iamu i na vo, Kebu 'u na vematakaki, 'akonadi a saiboda ma yaku 'aila'a 'a 'eno'eno, kebu 'aku fata a na tovoi a na velemu.’ ");
INSERT INTO yml_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Siwe a na vonemi, kebu veiana faifaina i na 'ivaisemu, yamu velu'ui-vaivaitugana faifaina i na velemu ava'ai nuanuamu. ");
INSERT INTO yml_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Wata 'omi bani'odi. 'Wa na vevelu'ui bega Yaubada i na velemi, 'wa na lalaualaga 'wa na veluagai wata 'wa na velutolitoliga i na nogayemi saiboda i na sibaleni. ");
INSERT INTO yml_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vona mogitana, egavo i vevelu'uiga Yaubada i na veledi, egavo i lalaualaga i na veluagai wata egavo i velutolitoliga i na nogayedi saiboda i na sibaleni. ");
INSERT INTO yml_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","We'e 'omi kwakwama tamadiavo, 'ai'edi tamu natumu igana i na velu'uiemuga, kebu 'ana fata 'o'olo 'u na veleni. ");
INSERT INTO yml_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","'Alo 'ai'edi fou i na velu'uiemuga, dinigala weweda 'u na veleni? A nuani kebu i da lubwaineniga. ");
INSERT INTO yml_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","'Omi tosakona siwe tutuya fuedi ava'ai natumiavo nuanuadi nani 'atumaidi 'wa veleveledi, we'e egavo Tamada abame i na velu'uieni, mogitana 'Anu'anunu Magemagetana i na veledi.” ");
INSERT INTO yml_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tamu tomogo, basenadi yaiaina i ageiga kebu 'ana fata i na welava, Iesu i veluagai yaiaina i voneni i 'awa'a'ia. Tomotoga fuedi i nogai i welava begaidi nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","We'e tomotoga 'ifwaidi i vo, Seitani, yaiaina yadi to'edakumeta, Iesu i agei bega yana toketokena 'wainega i vonavona yaiaina i 'a'awa'a'idi.” ");
INSERT INTO yml_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tomotoga 'ifwaidi nuanuadi Iesu i na silubuya bega i vo, Nuanuama tamu 'eba nuavogana wata 'eba nua'ewa 'u na 'idewai bega 'a na 'asetamu ma yamu veimea Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Iesu 'akonadi yadi nuanua i 'asetai begaidi i vonedi i vo, 'Ai'edi 'eba veimea 'aise'avadi i na 'idia i na vevetalaga bola 'eba veimeanina i na velovi. 'Ai'edi vanuga 'ana tomia yadi ve'ikwayekwayega 'wainega 'idi i na souyeni, nika i na yavula. ");
INSERT INTO yml_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","'Wa vonaga Seitani yana toketokena 'wainega a vona tamu yana tomotoga i 'awa'a'ia, siwe 'ai'edi Seitani yana 'aila'a 'aise'avadi i da 'idia i da vevetalaga, kebu 'ana fata i na miamia i na 'a'avaotoga. ");
INSERT INTO yml_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","We'e yami tomotoga 'ifwaidi i vonavona yaiaina i 'a'awa'a'idi, vetuma 'wa da velutoliedi ava'aiega yadi toketokena i veluagai. Nika i na vo, 'Wa vekali, kebu Seitani 'wainega.’ ");
INSERT INTO yml_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","We'e mogitana Yaubada yana toketokena 'wainega yaiaina a vonevonedi i 'a'awa'a'idi, 'wa da 'asetai Yaubada yana veimea i souyeni 'awasasamie. ");
INSERT INTO yml_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","'Ai'edi tamu tomogo toketokena bani'odi Seitani ma yana 'eba vetalaga fuedi, yana vanuga i lulumadu'aieni bega kebu tamu aitoi yana kukua i na 'ivesakoidi. ");
INSERT INTO yml_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","We'e 'ai'edi tamu tomogo toketokeotogina i na mai tomogonina taiadi i na vetalaga, i na vetoketoke 'waineye yana kukua wata yana 'eba vetalaganidi i vevetumaganediga i na eloi enavo i na veutadi. ");
INSERT INTO yml_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","'Ai'edi aitoi kebu taiadi 'a na folofolovaga, taunina 'aku gavia, we'e 'ai'edi aitoi kebu yau taiadi tomotoga 'a na vavagavaidi 'a na mimaiedi Yaubada 'waineye, kumanina tomotoga i sogisogiedi, taunina yaku folova 'ana to'ivesako. ");
INSERT INTO yml_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","'Ai'edi yaiaina i na 'awa'a'ia tamu tomogo 'wainega, i na nago 'awalawa sakoineye bei i na lalauala-vuvua tamu yana 'eba mia. 'Ai'edi kebu i na veluagaiga i na vo, A na vilaku yaku 'eba mianina basenadi a 'iaweniga 'waineye.’ ");
INSERT INTO yml_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bega i na vilai, i na mai 'eba mianina i na 'iseni 'akonadi i 'idewai 'atumaina wata vunavunagina i 'eno'eno siwe nage'avana. ");
INSERT INTO yml_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Fai kebu 'ana veluvaiga i na souyeni i na nago wata yaiaina sakoiotogidi 7 i na vagavaidi i na miedi taiadi i na luku 'eba mianina 'waineye. Tomogonina i na 'ivesakootogi mogitana, basenadi kebu bani'odiga.” ");
INSERT INTO yml_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tutuyanina Iesu i vona'a'ava, tamu vavine 'aila'a 'waidiega bonadi bwaikinega i toke i vona i vo, 'Eba sosoana inamu 'waidie fai i venatunemu wata i vesusumu.” ");
INSERT INTO yml_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iesu i vonedi i vo, 'Wa vonaga mogitana siwe wata egavo Yaubada yana Vona i na nogai wata i na vevematayakeyakeni 'eba sosoana mogitana 'waidie.” ");
INSERT INTO yml_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","'Aila'a bwaikina Iesu i tovififineni bega i vonedi i vo, Tutuya de'e 'ana tomotoga yami sauluva sakoidi, yami nuanua bwaikina 'eba nuavogana wata 'eba nua'ewa a na 'idewai matamie 'wa na 'iseni 'wa na ve'awamogitana yau Yaubada 'wainega a mai. We'e tamu nani a na veifufuyeni yami 'eba 'isa. 'Eba 'isanina 'asa'aiana Iona, taunina Yaubada yana tolu'ivona, igana bwaikina kamoneye i miamia 'aiata 'aitonu, mulieta i souyeni. Naninina i souyeni Iona 'waineye me Ninive yadi 'eba 'isa Yaubada i vetunei. Wata bani'odi yau a vetomotogaotoga naninidi i na souyedi 'waikuye yami 'eba 'isa Yaubada i vetuneku. ");
INSERT INTO yml_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Basenadiotoga me Siba yadi toveimea bwaikina Kwini Siba 'ani'ieyega i mai bega Kini Solomoni yana nuamageta i na vinenegeni. 'Awaie Vonayavuga 'ana 'Aiata 'waineye, Kwini Siba wata tutuya de'e 'ana tomotogavo taiadi 'wa na tovoi Yaubada mataneye, kwininidi i na matawa'ulimi fai kebu nuanuami nuamageta. Siwe a na vonemi, Kini Solomoni tomogo bwaikina, we'e tomogonina 'awasasamie i tovotovoi kumanina bwaikaotogina siwe 'wa baila, kebu nuanuami 'wa na vinenegeni. ");
INSERT INTO yml_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wata bani'odi Vonayavuga 'ana 'Aiata 'waineye me Ninive wata tutuya de'e 'ana tomotogavo taiadi 'wa na tovoi Yaubada mataneye, tomotoganidi i na matawa'ulimi fai tutuyanina Iona i lau'age 'waidie i nuaviladi. A na vonemi, Iona tomogo bwaikina we'e tomogonina 'awasasamie i tovotovoi kumanina bwaikaotogina siwe 'wa baila, kebu nuanuami 'wa na nuavilami. ");
INSERT INTO yml_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kebu tamu aitoi mageta i da kabukabuni nika i da givegiveni wata 'aivoeyega i da tatalafwaseni. We'e mogitana mageta 'ana 'eba yato 'waineye i lulutalauleni bega egavo i lukuluku vanuganina nageneye i magemagesedi. ");
INSERT INTO yml_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matami bani'odi nuami 'ana mageta. 'Ai'edi nani 'atumaidi 'wa na 'ise'isediga, nuami matatabuna magemagetadi, we'e 'ai'edi nani sakoidi 'wa na 'ise'isediga, nuami matatabuna i na dudubalidi. ");
INSERT INTO yml_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'Wa na 'isa'isa i na nunago yami magetanina i na 'weu nuami i na dudubalidi. ");
INSERT INTO yml_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","'Ai'edi mageta i na magemagesemi 'ami fata nani fuedi 'wa na 'isedi, wata bani'odi 'ai'edi nuami magemagetadi kebu tamu nuami i na dudubalidi, nani matatabuna magemagetadi 'waimie.” ");
INSERT INTO yml_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tutuyanina Iesu i vona'a'ava, tamu Diu totafalolo Falisi Iesu i tayegi 'ani faifaina bega i nago i miabui i na 'ani. ");
INSERT INTO yml_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Falisinina Iesu i 'iseni kebu nimana i da 'ivevunavunagidi yadi sauluva bani'odi begaidi nuana i vogani. ");
INSERT INTO yml_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iesu tomogonina yana nuanua i 'asetai begaidi i voneni i vo, 'Omi Falisi, tomogomi 'wa 'ivivigavudi we'e inagemi vainago 'ana ve'isakololo wata veumokai, yami sauluva bani'odi vedi wata 'aivoe, dumwedi 'wa tamatamadi we'e inagedi yoke 'anikudana. ");
INSERT INTO yml_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","'Omi 'wava'wavami. Yaubada tomogomi i 'idewadi wata inagemi. ");
INSERT INTO yml_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","We'e i lubwainemi 'wa na 'anivelena-maimaiga tovewekowekoma 'waidie 'wa da vo yami nuanua inagemie 'wa da 'ivevunavunagidi sauluva sakoidi 'waidiega, nika nani matatabuna 'waidiega 'omi vunavunagimi wata magemagetami. ");
INSERT INTO yml_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","'Omi Falisi nuakalikalimi, fai 'awaie vita bwaikina 'wa na veluagai Yaubada 'wainega. Veimea siaidi 'wa veve'ililibuyedi we'e veimea bwaikidi 'wa baibailedi. 'Ai'edi 'ani'ani 10 'waimie 'aitamogana 'wainega 'wa na 'anivelena-maimaiga Yaubada 'waineye. Wata nani saiotogidi bani'odi matasilisilili 10, 'aitamogana 'wainega 'wa na 'anivelena-maimaiga Yaubada 'waineye. 'Atumaina, bani'odi 'wa na vevesauluvedi, siwe wata veimea bwaikidi 'wa da vematayakeyakedi, bani'odi sauluva tonovidi wata Yaubada 'wa da nuakalikalieni. ");
INSERT INTO yml_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","'Omi Falisi nuakalikalimi, fai 'awaie vita bwaikina 'wa na veluagai Yaubada 'wainega. Nuanuami to'edakumeta bwaikidi taiadi 'wa na mimiabui 'eba miava'auta 'waidie, wata nuanuami 'atamanafouye tomotoga ma yadi ve'ililibu i na vevekaiwa 'waimie. ");
INSERT INTO yml_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nuakalikalimi, 'omi bani'odi taumata, inagena sakoina we'e tabwana 'atumaina. Tomotoga tabwaneamo i baba i nunago siwe kebu i da 'asetai 'ageyafayafadie bokana i 'eno'eno. Wata 'omi bani'odi, 'ami 'isa 'atumaidi we'e inagemi sakoidi.” ");
INSERT INTO yml_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tamu ve'etoboda 'adi tove Iesu i voneni i vo, Tove, yamu vonanina 'wainega 'ima wata 'u falisakoyema.” ");
INSERT INTO yml_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu i vo, 'Omi ve'etoboda 'adi tovevo nuakalikalimi, 'awaie vita bwaikina 'wa na veluagai Yaubada 'wainega. Tomotoga 'wa lulukakadedi bega yami ve wata ve'etoboda i vevematayakeyakedi, 'wa da vo venuana vitadi 'wa da veve'ewadi, siwe kebu tamu sai'afo 'wa da 'i'ivaisedi. ");
INSERT INTO yml_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nuakalikalimi. Basenadiotoga tubumiavo Yaubada yana tolu'ivonavo i luvewafadi. We'e 'omi, taumata 'atumaidi 'wa 'idewadi matumatu 'waidie tolu'ivonanidi luludi faifaidi. ");
INSERT INTO yml_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tubumiavo tolu'ivonanidi i luvewafadi we'e 'omi luludi 'wa 'idewadi, 'eba 'isa yadi sauluvanina 'wa awave'atumaieni. ");
INSERT INTO yml_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yaubada yami nuanua i 'asetadi begaidi ma yana nuamageta i vo, Yaku tolu'ivonavo wata yaku tomata'aulelevo a na vetunedi 'waidie, tofolovanidi 'ifwaidi veviga i na veledi we'e 'ifwaidi i na luvewafadi.’ ");
INSERT INTO yml_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Tutuyanina Yaubada fwayafwaya i 'idewavauyeni 'wainega i maiga 'asiau tubumiavo tolu'ivona fuedi i luluvewafadi. Basenadiotoga Keni taina Ebeli i luvewafai, nika bei tubumiavo 'ainike i velamuya i nagoga Sekalaia 'waineye, kumanina i luvewafai 'eba velomu wata Vanuga 'Eba Velu'ui kamwadie. A vona mogitana tutuya de'e tomotoganimi to'ainikenidi 'adi vematavuloga 'omi 'wa na tovoieni, kebu 'ami fata 'wa na dega veviganina bwaikina 'wainega. ");
INSERT INTO yml_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","'Omi ve'etoboda 'adi tovevo nuakalikalimi. Yaubada yana Buki 'ana 'aseta 'ana 'awa 'wa sibodai. Kebu nuanuami 'wa na luku 'asetanina 'waineye we'e mali tomotoga nuanuadi i na luku siwe 'wa sibodai.” ");
INSERT INTO yml_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Tutuyanina Iesu i vona'a'ava nika i tauya vanuganina 'wainega. Ve'etoboda 'adi tovevo wata Falisi ma yadi nuasako i siloloi velutoli fuedi 'waidiega, 'ai'edi kebu i na tutula-dewadiga to'edakumetanidi 'adi fata i na lu'ivoneyeni Loma kabemani 'waidie bega Iesu i na 'ive'avini. ");
INSERT INTO yml_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","'Aila'a bwaikaotogina i deli i maia ma ediavo i vevetunufelagi nuanuadi Iesu yana vona i na vinenegeni. Nagami Iesu i veifufu yana tovetutuyamavo 'waidie bega tomotoga sakoidi yadi sauluva kebu i na tunuvedamanidi i vo, Taunimi 'wa na 'i'isave'avinimi i na nunago totafalolo Falisi yadi isita i na vedamanimi i na 'ivesakoimi. 'Awadi sauluva sakoidi i tatalabodedi, siwe wata givagivayega i 'i'idewadi. ");
INSERT INTO yml_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ava'ai tomotoga i givediga, matatabuna Yaubada i na sivemagesedi. Ava'ai i nuagivediga Yaubada i na lu'ivoneyedi. ");
INSERT INTO yml_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Side bani'odi, ava'ai givagivayega 'wa voneyediga 'wa da vo dudubale, siwe i na sivemagesedi 'aila'a matadie. Ava'ai 'wa ve'awayayediga tutudaba nageneye 'awaie i na vegolegoleyedi 'atamanafouye.” ");
INSERT INTO yml_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Wata Iesu i vo, Ekwavo a na vonemi. Egavo nuanuadi i na luvewafamiga kebu 'wa na kololoyedi, 'adi fata tomogo'avami i na luvewafadi siwe kebu wata tamu veviga i na velemiga. ");
INSERT INTO yml_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","We'e a na vonemi kumanina i lubwainemi 'wa na kololoyeni. Mogitana ma yami ve'ililibu Yaubada 'wa na kololoyeni, ma yana veimea 'ana fata i na luvewafami wata i na tawemi 'ai-'ala'alata kebu yana 'weuga 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","'Ai'edi manudanidani 5 ta na kimwanediga, 'adi tutula siaina, bani'odi kileu 'ailuga. We'e Yaubada mataneye manudanidani nani bwaikina, 'aitamogana 'aitamogana kebu nuana i da fani i nuanuanidi. ");
INSERT INTO yml_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wata bani'odi, 'omi mataneye nani bwaikina, i 'aseta'a'avami bani'odi nava'au matatabuna 'adi 'aila'a i 'asetadi. Begaidi kebu 'wa na kolologa, 'omi kebu nani-'avo'avovo manudanidani bani'odiga, 'omi nani bwaikina Yaubada mataneye i 'i'isave'avinimi.” ");
INSERT INTO yml_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Wata Iesu i vo, A na vonemi, 'ai'edi aitoi fwayefwayeye i na lu'ivona tomotoga 'waidie faifaiku i na vo, Yau a tauyeku Iesu 'waineye taunina 'aku Toveimea,’ wata bani'odi yau a vetomotogaotoga 'awaie Yaubada yana anelose matadie a na vo, No'o tomotoganina yaku 'aila'a.’ ");
INSERT INTO yml_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","We'e 'ai'edi aitoi i na ve'eweku tomotoga 'waidie i na vo, Iesu kebu 'aku Toveimeaga,’ wata bani'odi yau 'awaie Yaubada yana anelose matadie a na ve'eweni a na vo, No'o tomotoganina kebu yaku 'aila'a.’ ");
INSERT INTO yml_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wata 'ai'edi aitoi yau a vetomotogaotoga i na awavesakoyekuga, 'ana fata nuatavuna i na veluagai. Siwe 'ai'edi aitoi i na vona-uvi'agala 'Anu'anunu Magemagetana 'waineye, kebu nuatavuna i na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","'Wa vetutuyamekuga begaidi 'awaie i na 'ive'avinimi i na nawemi bega 'wa na vonayavuga 'eba miava'auta 'waidie, wata tutuya 'ifwaidi i na vagavaimi i na nawemi to'edakumeta bwaikidi wata toveimeavo 'waidie vonayavuga faifaina. Kebu 'wa na venuafouviga 'wa na vo, I vevitadaga bani'odi ta na ve'ewedi wata bani'odi ta na voneyedi?’ ");
INSERT INTO yml_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Fai tutuyanina 'waineye 'Anu'anunu Magemagetana i na awave'ede'edemi nika bani'odi 'wa na veifufu.” ");
INSERT INTO yml_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tutuyanina Iesu i veveifufu, tamu tomogo 'aila'a 'waidiega i vona i vo, Tove, nuanuaku tataku 'u na voneni bega kukuanidi tamama i wafa i 'iawediga i na veusedi, 'ifwaidi yana kukua, 'ifwaidi yau.” ");
INSERT INTO yml_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesu yana vona i tutuli i vo, Iaku, kebu tamu aitoi veimea i da veleku bega 'ami 'ailuga yami kukua a na veutami.” ");
INSERT INTO yml_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Begaidi i vona matatabudi 'waidie i vo, 'Wa na 'isa'isa wata taunimi 'wa na 'isave'avinimi bega kebu 'wa na nuagiva wata 'wa na veumokai nani tulidi tulidi 'waidiega. Siwe a na vonemi, kebu 'ana fata 'ai'aiwabu bwaikidi 'wainega yami mia 'ana 'atumaina 'wa na veluagai.” ");
INSERT INTO yml_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Begaidi Iesu vona-awatabaiega i vonedi i vo, Tamu tomogo 'ai'aiwabuna yana fwayafwaya 'wainega 'ani'ani bwaikina i veluagai. ");
INSERT INTO yml_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","I 'iseni yana nuanua 'waineye i vo, Bani'odi a na munegidi? Yaku bubuaka 'akonadi i adaga.’ ");
INSERT INTO yml_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bega wata i vo, 'Akonadi a nuani. Side bani'odi, yaku bubuaka matatabuna a na geudi 'ivaudi wata bwaikidi a na yogonidi bei 'ani'ani matatabuna a na vedodogidi wata yaku kukua 'ifwaidi taiadi. ");
INSERT INTO yml_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mulieta tauniku a na voneku a na vo, 'Alo yau tamu tove'ai'aiwabu. Yaku 'ai'aiwabu matatabuna 'akonadi a 'idewadi nonogidi i na 'eno'eno malamalanidi i mimaiga faifaidi. Bega folova 'waidiega a na veawai ma yaku sosoana a na 'ani'animo wata ufa toketokedi a na yemuyemumo.’ ");
INSERT INTO yml_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Siwe Yaubada i voneni i vo, 'Omu mogitana 'wava'wavamu. 'Ako lovananina 'u na wafa, we'e kukuanidi faifaidi 'u folovaga, aitoi i na veimeyedi?’” ");
INSERT INTO yml_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Iesu yana vona 'ana 'eba ve'a'ava 'waineye i vo, Vona mogitana, egavo fwayafwaya 'ana 'ai'aiwabu faifaidi i na folofolova siwe kebu i na ve'ai'aiwabu Yaubada mataneye, 'awaie ava'ai 'ana 'atumaina 'waidie.” ");
INSERT INTO yml_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wata Iesu i vona yana tovetutuyamavo 'waidie i vo, Kebu 'wa na venuafouviga yami mia faifaina, voke 'ai'edi 'ani'ani 'ami fata 'alo kebu, wata ava'aiega talauma 'wa na veluagai tomogomi faifaidi. ");
INSERT INTO yml_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","'Ani'ani wata talauma nani-'avo'avovo we'e yami mia 'ana 'atumaina nani bwaikina. ");
INSERT INTO yml_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","'Wa na nuani bwayobwayo yadi sauluva. Kebu i da bakubakulaga, kebu i da 'a'aile'waga wata kebu yadi bubuakaga siwe Yaubada i veve'anidi. Manuga nani-'avo'avovo we'e 'omi nani bwaikina Yaubada mataneye begaidi 'ami'ami i na velevelemi. ");
INSERT INTO yml_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Begaidi kebu tamu nani faifaina 'wa na venuafouviga. Kebu tamu aitoi 'ana fata yana mia fwayefwayeye i na 'ivemanawei yana venuafouviga 'wainega. ");
INSERT INTO yml_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Venuafouviga kebu 'ana fata i na 'ivaisemi tamu nani siaina 'waineye, awale 'wa vevenuafouviga nani fuedi faifaidi? ");
INSERT INTO yml_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","'Wa na nuani makavuvula yadi tabo. Kebu i da folofolova wata kebu 'adi talauma i da 'i'idewadiga siwe 'adi vaigavu 'atumaidi. A na vonemi. Kini Solomoni tomogo 'ai'aiwabuna 'ana vaigavu 'atumaidi, we'e makavuvula 'atumaiotogidi. ");
INSERT INTO yml_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mosomoso matatabuna nani-'avo'avovo, 'asiau ta 'ise'isedi we'e 'awa'awai i na tunudi i na 'alaidi siwe Yaubada i veve'wesenidi. We'e 'omi tamu nani bwaikina mataneye, mogitana ma 'ami nuanua i na veve'wesenimi. Awale yami vetumagana Yaubada 'waineye mweadi? ");
INSERT INTO yml_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Begaidi 'ani'ani wata walu'ai faifaidi kebu 'wa na venuafouviga bega tutuya fuedi 'wa na lalauala. ");
INSERT INTO yml_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yaubada 'ana tobavu naninidi nuanuadi bwaikina faifaidi i vevenuafouviga. We'e 'omi naninidi nuanuami, Tamami abame 'akonadi yami nuanua i 'asetadi. ");
INSERT INTO yml_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","We'e 'wa vevenuafouviga 'asa'aiadi, i lubwaineni nagami taunimi 'wa na tauyemi Yaubada i na veveimeyemi wata yana nuanua 'wa na 'i'idewadi, mulieta naninidi i na velevelemi.” ");
INSERT INTO yml_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Wata Iesu i vona yana tovetutuyamavo 'waidie i vo, 'Omi 'ami 'aila'a siaina kebu fuemiga, siwe kebu 'wa na kolologa, fai Tamami i veveimeyemi yana 'Aila'a nageneye, yana 'eba sosoana mogitana. ");
INSERT INTO yml_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yami kukua 'wa na vekimwaneyedi, tutulidi 'wa na 'ewadi 'wa na veusedi tovewekowekoma 'waidie, bega yami 'ai'aiwabu abame i na 'eno-vagata. 'Ai'aiwabunidi abame i 'eno'enoviga kebu yadi 'a'avaga fai tovainago wata 'walu'walu kebu i na 'ivesakoidi. ");
INSERT INTO yml_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","'Wa na nuani, ava'aibe bei yami 'ai'aiwabu i 'eno'enoviga, bei tutuya fuedi yami nuanua i na nunago. ");
INSERT INTO yml_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","'Wa na 'idewadewa, yami mageta i na 'ala'alata 'wa na lulukamata. ");
INSERT INTO yml_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tofolova 'atumaidi 'wa na vetutuyamedi, bani'odi yadi 'auvea i nago vavine 'ana vewelava 'waineye yana tofolovavo i 'idewadewa i lulukamaseni ma'avia i na vilai. Tutuyanina i na le'wa i na velutoli saiboda i na sibala-matayo'oyeni. ");
INSERT INTO yml_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tofolovanidi i 'idewadewa i lulukamataga 'eba sosoana mogitana 'waidie yadi 'auvea yana le'wa faifaina. A vona mogitana, yadi 'auveanina yana tofolovavo i na sosoanedi bega i na vonedi i na miabui, 'eba folova 'ana talauma i na ve'weseneni mulieta 'adi'adi i na veutadi. ");
INSERT INTO yml_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","We'e 'ai'edi 'auveanina lovana 'ana utukamwane 'alo 'eba 'ata'atai 'waineye i na le'wa, siwe yana tofolovavo i na lulukamaseniga 'eba sosoana mogitana 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","'Wa na nuani, 'ai'edi tamu tomogo tovainago yana mai 'ana tutuya i da 'asetaiga i da 'isa'isa bega tovainagonina kebu 'ana fata i na luku yana vanuge. ");
INSERT INTO yml_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","'Omi wata bani'odi 'wa na 'isa'isa fai 'aiatanina 'waineye 'wa na vo, Kebu i na maiga,’ yau a vetomotogaotoga bei a na le'wa.” ");
INSERT INTO yml_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Fita Iesu i velutolieni i vo, 'Auvea, vona-awatabainina 'u vonevoneyeniga 'ima tovetutuyamavo 'aisema 'ama vona 'alo tomotoga matatabuma faifaima?” ");
INSERT INTO yml_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Iesu yana velutoli i tutuli i vo, Tofolova 'atumaina kumanina nuana magemagetana wata ma 'ana vetumagana yana sauluva side bani'odi. 'Ana toveimea i voneni yana tofolovavo 'ifwaidi i na 'i'isave'avinidi wata 'adi'adi i na veleveledi 'aiata 'aitamogana 'aitamogana mulieta i tauya. ");
INSERT INTO yml_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tutuyanina 'ana toveimea i na vilai i na mai, 'ai'edi folovanidi matatabuna i na 'idewa'a'avadiga, 'eba sosoana 'waineye fai tutula i na 'ewai. ");
INSERT INTO yml_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A vona mogitana 'waimie, 'ana toveimea i na voneni yana vanuga wata yana kukua matatabuna 'adi to'isave'avina. ");
INSERT INTO yml_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","We'e 'ai'edi tofolovanina yana nuanua i na vo, 'Aku toveimea bola, kebu i na mai-matayo'oga,’ bega enavo tofolova i na nikenikedi we'e mali tomotoga taiadi i na 'ani'ani wata ufa toketokena i na yemuyemu bega nuadi i na lulugaugaudi, tamu tutuya tofolovanina kebu i da 'asetaiga 'ana toveimea i na mai yawaina i na velovogi. Yana sauluva sakoina faifaina i na toke i na nikei mulieta i na yatoi tovedumwe'ai'ai taiadi. ");
INSERT INTO yml_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tofolovanina 'ana toveimea yana nuanua i 'asetadi siwe i baila kebu i da 'idewadi, 'ana vematavuloga bwaikaotogina. ");
INSERT INTO yml_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","We'e tofolovanina 'ana toveimea yana nuanua kebu i da 'asetadi bega i na vekaliga, 'ana vematavuloga sai'afo. 'Ai'edi Yaubada nani fuedi i 'anivelenedi tamu aitoi 'waineye, i lubwaineni i na vevefolovedi bega 'ana Toveimea nani fueotogidi i na veleveleni. 'Ai'edi Yaubada nani fuedi i 'anivelenedi tamu aitoi 'waineye bega i na 'i'isave'avinidi, i lubwaineni i na vevefolovedi bega 'ana Toveimea nani fueotogidi ma 'ana 'imoso'i i na veleveleni.” ");
INSERT INTO yml_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Wata Iesu i vonedi i vo, Yau a maiga bega 'ai-'ala'alata i na souyeni fwayefwayeye. Nuanuaku bwaikina 'akonadi i da 'ala'alata. ");
INSERT INTO yml_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yau nuafouku i veveviga fai 'awaie a na luku veviga bwaikaotogina 'waineye, siwe mulieta veviganina i na 'a'ava nuafouku i na vatu. ");
INSERT INTO yml_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","'Ifwaimi yami nuanua a maiga bega tomotoga matatabumi 'wa na veveiaiana. Siwe kebu. A na vonemi, a maiga bega tomotoga a na 'ididi. ");
INSERT INTO yml_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tutuya de'e i na nagoga, 'aila'a tulina tulina i na 'idi. Side bani'odi, 'aila'a 'aitamogana nageneye tomotoga 5, 'adi 'ailuga nuanuadi yau, 'adi 'aitonu i na vedumwe'ai'aieku, 'alo 'adi 'aitonu nuanuadi yau, 'adi 'ailuga i na vedumwe'ai'aieku, bega ve'idi'idi i na souyeni. ");
INSERT INTO yml_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tomogo natuna iavetana i na vegavieni wata natuna iavetana tamana i na vegavieni faifaiku. Vavine natudi vevinena i na vegavieni wata natudi vevinena inana i na vegaviedi faifaiku. We'e vavine lawadi vevinena i na vegavieni wata vavine lawadi vevinedi i na vegaviedi faifaiku.” ");
INSERT INTO yml_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","55","Wata Iesu i vona tomotoga 'waidie i vo, 'Ai'edi 'wa na 'iseni waowa i na vetovotovoia 'wa na 'asetai i na 'wei, wata 'ai'edi Malayaubani i na laka 'wa na 'asetai tutuya kumaga. ");
INSERT INTO yml_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","'Omi tovekali, tugusanidi abame wata fwayefwayeye i na vemi bega 'ami fata 'wa na 'asetai ava'ai i na souyedi, we'e 'eba 'isa toketokedi Yaubada i 'i'idewadi tutuya i mimaiga faifaina, kebu 'wa da 'isa'inanadiga. ");
INSERT INTO yml_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Awale kebu nuanuami 'wa na venua'ivina-'atumai bega 'eda tonovineamo 'wa na nagoi? ");
INSERT INTO yml_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","'Ai'edi aitoi i na vevitamu tamu sakona faifaina bega i na vagavaimu i na nunawemu 'eba vonayavuga 'waineye, 'u na vewavawava 'edeye 'wa na sivetonovi. 'Ai'edi kebu, i na 'anivelenemu tovevonayavuga 'waineye mulieta i na yatomu tovematavuloga nimaneye nika 'u na luku vanuga yogona nageneye. ");
INSERT INTO yml_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A vona mogitana, kebu i na 'etoyavu-matayo'omu bei 'u na miamia i na nagoga 'ana tugusa 'u na tutula'a'ava, nika i na 'etoyavumu.” ");
INSERT INTO yml_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tutuyanina 'waineye tomotoga 'ifwaidi i maia Iesu 'waineye i vo, Me Galili 'ifwaidi i luku Vanuga 'Eba Velu'ui nageneye i vevelomu Yaubada 'waineye nika Failato yana tolugaviavo i maia i luvewafadi.” ");
INSERT INTO yml_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu i vonedi i vo, Fai bani'odi i wafayediga 'wa da nuaniga tomotoganidi i wafaga yadi sakona bwaikaotogina we'e me Galili 'ifwaidi sai'afo? ");
INSERT INTO yml_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kebu. A na vonemi, 'ai'edi yami sakona kebu 'wa na vedumwe'ubu'ubusediga, 'omi wata matatabumi 'wa na wafa. ");
INSERT INTO yml_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Basenadi 'wa 'asetai tomotoga 'adi 18 i miamia Ufa Sailoama lilivaneye nika vanuga manamanawena i 'anifoia i luvewafadi. Fai bani'odi i wafayediga 'wa da nuaniga tomotoganidi i wafaga yadi sakona bwaikaotogina we'e me Ielusalema 'ifwaidi sai'afo? ");
INSERT INTO yml_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kebu. A na vonemi, 'ai'edi yami sakona kebu 'wa na vedumwe'ubu'ubusediga, 'omi wata matatabumi 'wa na wafa.” ");
INSERT INTO yml_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wata Iesu vona-awatabaiega tomotoga i vonedi i vo, Tamu tomogo yana bakule 'ala'ai i tovotovoi. Tutuya fuedi i nunago vuagina faifaina i 'i'isa'ava. ");
INSERT INTO yml_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Begaidi yana bakula 'ana to'isave'avina i voneni i vo, Malamala 'aitonu a mimai nuanuaku vuaga a na 'ewadi siwe kebu tamu a da veveluagai. 'U na talagi, kebu i da lubwaineni fwayafwaya i veve'amubwadodoyeni.’ ");
INSERT INTO yml_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Siwe bakula 'ana to'isave'avina i vona i vo, 'Auvea 'u baileni, nagami lamuna a na 'oia wata 'aufafayega a na veivuya, ta na 'iseni malamala 'aitamogana nageneye. ");
INSERT INTO yml_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","'Ai'edi i na vuaga, 'atumaina i na tovotovoi, we'e 'ai'edi kebu, 'u na talagi.’” ");
INSERT INTO yml_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tamu 'Aiata Veawai Iesu i veve tamu me Diu yadi 'eba miava'auta 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Vanuganina 'waineye tamu vavine basenadi yaiaina i agei begaidi dumwena i 'obwa i miamia malamala 18 kebu 'ana fata i na tonova. ");
INSERT INTO yml_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tutuyanina Iesu i 'iseni i goleni i nago 'waineye i voneni i vo, Novuku, 'omu 'akonadi 'amu viga i 'a'ava 'u ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iesu vavine i 'abitonovi nika dumwena i tonova ma yana sosoana Yaubada i subiai. ");
INSERT INTO yml_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","'Eba miava'autanina 'ana to'edakumeta i 'iseni, i nuasako fai Iesu i 'ive'atumai yadi 'Aiata Veawai 'waineye. Begaidi to'edakumetanina tomotoga 'waidie i vo, 'Aiata 6 nagedie ta na folofolova, 'ai'edi 'wa viga nuanuami ve'atumai, 'aiatanidi 'waidie 'wa na maia, we'e 'Aiata Veawai 'waineye kebu.” ");
INSERT INTO yml_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Iesu yana vona i tutuli i vo, 'Omi tovekali. 'Awami i tatalaboda nani fuedi faifaidi siwe wata 'wa 'i'idewai. 'Omi yami sauluva 'aiata fuedi wata 'Aiata Veawai 'waidie yami 'aisaya 'wa yavuyavudi 'adi vanugayega 'wa nunawedi 'wa veveyemudi, siwe 'asa'aiana folova. ");
INSERT INTO yml_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Vavine de'e i ve'atumaiga tamu Ebelamo tubuna siwe Seitani i yogoni i miamia malamala 18, 'Aiata Veawai 'waineye i ve'atumaiga 'ana laubwaina.” ");
INSERT INTO yml_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesu yana vonanina 'wainega 'ana tovedumwe'ai'aivo bunudi i ve'alamayamayaga, we'e tomotoga fuedi i sosoana 'eba nuavogana wata 'eba nua'ewa Iesu i 'idewadiga faifaidi. ");
INSERT INTO yml_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Wata Iesu tomotoga i vonedi i vo, Bani'odi ta na voneyedi Yaubada yana veimea tomotoga 'waidie yana vebwaika faifaina 'alo ava'ai 'wainega ta na awatalatutula? ");
INSERT INTO yml_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yana vebwaika bani'odi 'ayawana, bilana siaina tamu tomogo i 'ewai i bakuli. I tabo i vebwaika nika welavi bwaikaotogina, bega manuga i mimaia didineye i vevegiuva.” ");
INSERT INTO yml_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wata Iesu i velutoliedi i vo, Bani'odi ta na voneyedi Yaubada yana veimea tomotoga 'waidie yana susula faifaina? ");
INSERT INTO yml_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yana susula bani'odi tamu vavine falawa bwaikina i vilai mulieta isita i yatoi, i susula falawa matatabuna 'waineye nika i vebwaika.” ");
INSERT INTO yml_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu i nunago Ielusalema bega 'atamana bwaikidi wata siaidi 'waidiamo i veve. ");
INSERT INTO yml_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tamu tomogo Iesu i velutolieni i vo, 'Auvea, Yaubada tomotoga fuedi i na 'ita'ita'iedi 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Iesu yana velutoli i tutuli i vo, 'Wa na vewavawava bega 'awa welilineamo 'wa na luku abame. A na vonemi, 'awaie fuedi nuanuadi beidimo i na nagoi siwe kebu 'adi fata. ");
INSERT INTO yml_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tutuyanina 'waineye tonivanuga saiboda i na sibodai bega tanotanoge 'wa na tovoi 'wa na vevelutoli 'wa na vo, 'Auvea, nuanuama 'a da lukuwa.’ Siwe wata yami vona i na tutuli i na vo, Kebu a da 'asetamiga wata kebu a da 'asetai ava'aiega 'wa maia.’ ");
INSERT INTO yml_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bega 'wa na vo, 'U ve yama 'atamane wata taiadi ta 'ani.’ ");
INSERT INTO yml_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Siwe wata i na vo, 'Wa nagoi, 'omi tosakona. Kebu a da 'asetamiga wata kebu a da 'asetai ava'aiega 'wa maia.’ ");
INSERT INTO yml_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tutuyanina 'waineye 'wa na 'iseni Ebelamo, Aisake, Iakobo wata tolu'ivona 'ifwaidi Yaubada yana 'Eba Veimea nageneye, we'e 'omi i na tawemi 'wa na obu kalimulie 'wa na 'we'we'wela wata maigimi 'wa na yuyuyudi. ");
INSERT INTO yml_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","'Awaie tomotoga fuedi i na maia 'awalawa tulina tulina 'waidiega, inala yana 'eba lakayega wata yana 'eba inivayega, bolimanayega wata yavalatayega, ma fuedie i na luku Yaubada yana 'Eba Veimea nageneye taiadi i na 'aniluvetubama. ");
INSERT INTO yml_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mogitana, tomotoga fuedi 'asiau i vemuliga 'awaie i na kumeta, we'e tomotoga fuedi 'asiau i kumeta, ma'itufa 'awaie i na vemuli.” ");
INSERT INTO yml_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wata tutuyanina 'waineye 'ifwaidi totafalolo Falisi i maia Iesu i voneni i vo, Kini Elodi nuanuana i na luvewafamu begaidi 'u na dega 'u na nago tulineye.” ");
INSERT INTO yml_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu yadi vona i tutuli i vo, Elodi ma yana 'aseta givagivayega sauluva sakoidi i 'i'idewadi bani'odi 'ou'ou walawala'ai. 'Wa na nagoi 'wa na voneni 'wa na vo, 'Asiau wata 'awa'awai Iesu toviga i na 'i'ive'atumaidi wata tomotoga yaiaina i agediga i na vonavona i na 'a'awa'a'idi we'e 'aiata 'ana vetonu 'waineye yana folovanidi i na ve'a'avadi.’ ");
INSERT INTO yml_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","We'e a na vonemi, 'asiau a nunago, 'awa'awai i na 'ataidiga a na le'wa Ielusalema. Yaubada yana tolu'ivonavo matatabudi bei i wafaga, i lubwaineku yau wata bei a na wafa.” ");
INSERT INTO yml_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Iesu i taivonavona i vo, Ieu, me Ielusalema, me Ielusalema, Yaubada yana tolu'ivonavo 'wa luluvewafadi wata yana tomata'aulelevo i vetunediga 'waimie, 'wa lukileudi i wafa. Kamukamu natudiavo fafedie i vevedodogidi, wata bani'odi yau tutuya fuedi igodi a da 'a'avalamaigimi siwe 'wa baibaileku. ");
INSERT INTO yml_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","'Wa ve'wada a na vonemi. Yami 'atamana 'akonadi i velovi. Kebu wata 'wa na 'ise'isekuga i na nagoga mulieta 'wa na vo, Taunina 'Auvea 'ana wagavayega i mimai, Yaubada i da vevesauluva 'atumaina 'waineye,’ nika bei wata 'wa na 'iseku.” ");
INSERT INTO yml_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Tamu 'Aiata Veawai 'waineye Iesu i nago tamu Falisi yadi to'edakumeta yana vanuge i na 'ani. Bei tamu tomogo tomogona i ve'alatubutubuga i veluagai we'e tomotoga fuedi vanuganina nageneye Iesu i vemata'i'i'ieni, 'ai'edi i na 'ive'atumaia 'Aiata Veawai 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Begaidi Iesu i velutoli Falisi wata ve'etoboda 'adi tovevo 'waidie i vo, Veimeanina i mai Mosese 'wainega 'ana 'aseta bani'odi? 'Ada fata toviga ta na 'ive'atumaidi 'Aiata Veawai 'waineye 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Siwe kebu tamu ava'ai i da voneyeniga. Bega Iesu toviganina nimaneye i 'abi i mieni i 'ive'atumaia nika i voneni i nago. ");
INSERT INTO yml_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wata Iesu i velutoliedi i vo, 'Ai'edi tamu aitoi 'waimiega natuna 'alo yana 'aisaya i na be'u ovuye 'Aiata Veawai 'waineye bani'odi i na munegi? Vona mogitana i na 'abiwalowaloga i na silakai.” ");
INSERT INTO yml_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Siwe Falisi wata ve'etoboda 'adi tovevo kebu tamu ava'ai i da voneyeniga. ");
INSERT INTO yml_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tutuyanina tomotoga i lukuluku 'ani faifaina Iesu i 'isedi i ve'abiwalowaloga nuanuadi i na miabui to'edakumeta yadi 'eba miabui 'waidie. Begaidi i vona-awatabai 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","I vo, 'Ai'edi tamu tomogo i na tayegimu sakali 'waineye, kebu 'u na miabui to'edakumeta yadi 'eba miabui 'waidie. 'Ai'edi 'akonadi bei 'u na miabuiga, voke tamu tomogo bwaikina wata i tayegi i na vemuli i na le'wa bega tonisakali i na vonemu 'u na tovoi we'e bei i na miabui. We'e 'omu 'u na nago 'aila'a mulidie 'u na miabui 'eba bunumayaga 'waimuye. ");
INSERT INTO yml_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bega 'ai'edi i na tayegimuga 'u na nago 'u na miabui tanotanoge mulieta tonisakali i na 'isemu i na vonemu i na vo, Iaku, 'u tovoi 'u mai side bei 'eba miabui 'atumaina 'waineye.’ Tomotoga matatabudi i na 'isemu i na ve'ililibuyemu. ");
INSERT INTO yml_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Egavo taunidi i na awa'ai'aidiga, 'awaie Yaubada i na veviladi i na obu we'e egavo taunidi tonuaobu, 'awaie Yaubada i na silakaidi.” ");
INSERT INTO yml_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wata Iesu i vona tonisakali 'waineye i vo, 'Ai'edi 'ani'ani siaina 'alo bwaikina 'u na 'idewaiga, kebu emwavo 'u na tayegidiga, bani'odi taimwavo, yamu 'aila'a 'alo tomotoga 'ai'aiwabudi i miamiani yamu 'atamane, fai bola wata i na tayegimu bani'odi i tutuli. ");
INSERT INTO yml_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Siwe a na vonemu. 'Ai'edi sakali 'u na 'idewaiga side tomotoganidi 'u na tayegidi. Tovewekowekoma, bwalobwaloko, tubusakosako wata tomatasako. ");
INSERT INTO yml_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","'Eba sosoana 'waimuye tomotoganidi 'u tayegidi faifaina fai kebu 'adi fata i na tutuli. Bola Yaubada 'ana to'idumwebika yadi tovoi-vaitugana 'waineye bei yamu nuakalikalinina 'ana tutula 'u na veluagai.” ");
INSERT INTO yml_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sakalinina 'waineye tamu tomogo Iesu yana veifufu i nogai bega i vona 'waineye i vo, 'Eba sosoana mogitana 'waidie, egavo i na luku Yaubada yana 'Eba Veimea nageneye yana sakali bwaikina 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu yana vona i tutuli vona-awatabaiega i vo, Tamu tomogo sakali bwaikina i 'idewai tomotoga fuedi i tayegidi. ");
INSERT INTO yml_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sakalinina 'ana 'aiata 'waineye yana tofolova i vetunei tomotoganidi i tayegidiga i vonedi i vo, 'Wa maia ta na nagoi nani matatabuna 'akonadi i 'idewadi.’ ");
INSERT INTO yml_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Siwe tomotoganidi i vonediga i ve'alabaibaila. Tamu tomogo i vo, Yau 'asa'aiadi fai yaku fwayafwaya a kimwanei a na nago a na 'iseni.’ ");
INSERT INTO yml_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wata tamu i vo, Yau 'asa'aiadi fai 'aisaya 10 a kimwanedi a na nago a na 'ewadi a na miedi.’ ");
INSERT INTO yml_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wata tamu i vo, Yau 'asa'aiadi 'asiauotoga a nagi begaidi kebu a na wai.’ ");
INSERT INTO yml_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Bega tofolovanina i vilai i mai i lu'ivona 'ana toveimea 'waineye. Toveimeanina taunina tonivanuga i nuasako yana tofolova i voneni i vo, 'U na lilide 'u na nago 'atamane wata 'eda 'waidie, tovewekowekoma, bwalobwaloko, tomatasako wata tubusakosako 'u na vagavaidi 'u na miedi.’ ");
INSERT INTO yml_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mulieta tofolovanina wata i vilai i mai i vo, 'Auvea, ava'ai 'u vonekuga 'akonadi a 'idewai, a nago a vonedi i maia siwe 'ani'ani bwaikaotogina wata 'awasasa 'ifwaidi i 'eno'enovi.’ ");
INSERT INTO yml_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bega 'ana toveimea i vo, 'U na nago 'ani'ie kwedeye wata wala'aie tomotoga 'u na veluagadiga 'u na lukakadedi i na maia bega 'awasasa i na veadagi. ");
INSERT INTO yml_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A na vonemi, egavo nagami a tayegidi kebu tamu sai'afo yaku 'ani'ani i na 'alatonovi.’” ");
INSERT INTO yml_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Tamu tutuya Iesu wata 'aila'a bwaikina taiadi i nunagoi i sivilai i vonedi i vo, Aitoi nuanuana i na mai 'waikuye bega i na vetutuyameku, nagami tamana, inana, yana vavine, natunavo, tainavo, novunavo wata taunina yana nuanua i na bailedi 'aiseku i na nuanuaniku. ");
INSERT INTO yml_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","'Ai'edi aitoi nuanuana mogitana i na mai 'waikuye, nagami taunina yana nuanua i na bailedi. Fai i na vematayakeyakeku veviga bwaikina i na veluagai yau bani'odi a na veluagai. Voke i na wafa faifaiku yau bani'odi a na wafa 'ai lagalagana 'waineye. 'Ai'edi aitoi kebu bani'odi i na vesauluvediga, taunina kebu 'aku tovetutuyama. ");
INSERT INTO yml_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nagami 'wa na venua'ivina 'ami fata folovanina 'wa na 'idewai 'alo kebu. Side bani'odi. 'Ai'edi aitoi 'waimiega nuanuana vanuga bwaikina i na yogoni nagami yana mani i na 'iseni 'ai'edi vanuganina 'ana tutula 'ana fata. ");
INSERT INTO yml_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","'Ai'edi yana mani kebu i na 'iseniga, tutuyanina yana folova i na velamu voke bola mani i na 'a'aveni i na ve'ale'usa wata tomotoga i na 'iseni i na sidibidibieni. ");
INSERT INTO yml_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","I na vo, Tomogo de'e nuanuana vanuga i na yogoni siwe kebu 'ana fata i na ve'a'avai.’ ");
INSERT INTO yml_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wata bani'odi 'ai'edi kini vala i na nogai tamu kini ma yana tolugaviavo 20,000 i mimaia nuanuadi taiadi i na vetalaga, siwe kininina vala i nogaiga nagami i na venua'ivina 'ana fata yana tolugaviavo 10,000 i na vetoketoke bega 'adi gaviavo 20,000 taiadi i na vetalaga. ");
INSERT INTO yml_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","'Ai'edi kebu 'adi fataga, 'ani'ieyega vala i na vetunei i na talabodeni wata i na velutolieni i na vo, Ava'ai nuanuamu a na velemu bega kebu ta na vetalaga?’” ");
INSERT INTO yml_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wata Iesu i vonedi i vo, Wata side bani'odi, kebu tamu aitoi 'ana fata i na vo, Yau Iesu yana tovetutuyama,’ 'ai'edi kebu nani matatabuna i na bailedi. ");
INSERT INTO yml_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Eyaga 'eba 'ive'iwana, siwe 'ai'edi i na ve'ulaufa kebu 'ana fata i na vegola-vaitugana. ");
INSERT INTO yml_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kebu 'ana fata bega 'ani'ani ta na 'ive'iwani wata kebu 'ana fata ta na yemuya, iwayavulagi 'ana laubwaina. Veifufu de'e 'wa nogaiga, 'wa na venua'ivineni nika 'wa na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tamu 'aiata takesi 'ana tolaugogona wata 'ifwaidi tosakona i maia Iesu 'waineye yana veifufu i na vivinenegeni. ");
INSERT INTO yml_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Siwe totafalolo Falisi wata ve'etoboda 'adi tovevo 'ifwaidi i vebonavoluvolu i vo, Kebu tamu sai'afo 'ana 'isa 'atumainaga fai no'o tomogonina tosakona i veveianedi wata yana sauluva sakoiotogina fai taiadi i 'ani'ani.” ");
INSERT INTO yml_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Yadi nuanua Iesu i 'asetai begaidi vona-awatabaiega i vonedi i vo, 'Ai'edi tamu aitoi 'waimiega ma yana sifi 100 we'e 'aitamogana i na yogo'eni nika i na vuyo, ava'ai i na 'idewai? Sifi 99 i na bailedi i na miamiani gidegideye i na vilai i na nago i na lualeni i na nagoga 'ana tugusa i na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Tutuyanina i na veluagai i na sosoana bega i na evai i na naweni yana vanuge. Enavo matatabudi i na goleva'augidi i na vo, Ta na sosoana fai yaku sifi i vuyoga 'akonadi a veluagai.’ ");
INSERT INTO yml_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A na vonemi, wata bani'odi 'eba sosoana mogitana abame, 'ai'edi tosakona 'aitamogana i na nuavilai, we'e tomotoga 'atumaidi 'adi 99 kebu i da vuyoga faifaidi yadi sosoana sai'afo. ");
INSERT INTO yml_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","'Ai'edi tamu vavine ma yadi mani siliba 10, we'e 'aitamogana i na taweni, bani'odi i na munega? Mageta i na kabuni, vanuga i na divuya i na lauala-'atumai i na nagoga 'ana tugusa i na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tutuyanina i na veluagai ediavo matatabudi i na goleva'augidi i na vonedi i na vo, Ta na sosoana fai yama mani 'a taweniga 'akonadi 'a veluagai.’” ");
INSERT INTO yml_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wata Iesu i vo, A na vonemi, wata bani'odi Yaubada yana anelose i na sosoana mogitana, 'ai'edi tamu tosakona i na nuavilai.” ");
INSERT INTO yml_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wata Iesu i vona-awatabai i vo, Tamu tomogo natunavo iavetadi 'adi 'ailuga. ");
INSERT INTO yml_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Bwasiona tamana i voneni i vo, Tamaku, bola 'u na wafa yamu kukua wata yamu fwayafwaya ma tataku 'a na veusedi. Siwe nuanuaku 'asiauotoga yau faifaiku 'u na 'idi-vagaseni 'u na veleku.’ Bega tamadi nani matatabuna i veusedi 'adi 'ailuga 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","'Aiata 'ifwaidi i 'a'ava, bwasiona 'ana veuveutanina i vekimwaneyedi, tutulidi i 'ewadi nika i 'idewadewa i tauya. I nago 'ani'ieogose tamu 'atamana bwaikina 'waineye, bei sauluva sakoidi 'waidie yana mani i ve'amubwadodoyedi. ");
INSERT INTO yml_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tutuyanina yana mani matatabuna i ve'a'aveni, loka bwaikina i souyeni 'awalawanina 'waineye, we'e yana mani kebu tamu sai'afo i da luvegalaleni. ");
INSERT INTO yml_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Begaidi i nago tamu 'atamana 'ana tomotoga 'waineye nuanuana i na folova, bega i voneni i na nago tamu yana tanoga 'waineye yana bawe i na 'isave'avinidi. ");
INSERT INTO yml_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I lase bwaikina nuanuana bawe 'adi fwalaegilayega i na 'ani siwe kebu tamu aitoi ava'ai i da veleni. ");
INSERT INTO yml_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","I miamia tutuya manamanawena mulieta nuana i vilai i vo, Tamaku yana tofolovavo matatabudi ma 'adi'adi 'adi fata i na 'ani-wayogedi, we'e yau laseyega a na mwea. ");
INSERT INTO yml_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","A na tovoi a na vilaku tamaku 'waineye a na voneni a na vo, Tamaku, a sakona 'waimuye wata Yaubada mataneye. ");
INSERT INTO yml_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kebu i da lubwainemu 'u na awave-natuna 'waikuye, 'u na veimeyekumo a na vetofolova 'waimuye.”’ ");
INSERT INTO yml_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bega i vilai i nago tamana 'waineye. Tamana 'ani'ieyega i 'isanaweni i 'isanuakalikalieni i lilide i nago i 'avalamaigi i yaogi. ");
INSERT INTO yml_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Natuna i vo, Tamaku yau a sakona matamuye wata Yaubada mataneye. Kebu i da lubwainemu 'u na awave-natuna 'waikuye.’ ");
INSERT INTO yml_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Siwe tamana yana tofolovavo i goledi i maia i vonedi i vo, 'Wa na lilide talauma 'atumaina 'wa na mieni ta na ve'weseni, didikumakuma nimaneye wata 'ageyafayafa 'ageneye 'wa na veagedi. ");
INSERT INTO yml_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mulieta 'wa na nagoi bulumakau natudi veve'anina 'wa na nikei ma yada sosoana 'ani bwaikina ta na 'idewai. ");
INSERT INTO yml_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Fai natuku de'e i wafa wata i yawasa-vaitugana. I vuyo wata a veluagai.’ Bega 'ani'ani i 'idewadewa i 'ani i sosoana. ");
INSERT INTO yml_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tutuyanina i 'ani'ani, natuna tulaina i folofolova bakule. I vilai i mimai sai'afoga i na le'wa mwalilige nika inava butu'aina i nogai i tavotavola. ");
INSERT INTO yml_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tamu tofolova i goleni i nago i velutolieni i vo, Ava'ai no'o i sousouyeni?’ ");
INSERT INTO yml_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tofolova i vo, Taimu i le'wa bega tamami ma yana sosoana bulumakau natudi veve'anina i nikei fai natuna kebu i da wafa, ma yawaina i vilai i mai.’ ");
INSERT INTO yml_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Natuna tulaina i nuasako bwaikina kebu nuanuana i na luku vanuge. Bega tamana i souyeni i nago i voneni nuanuana taiadi i na luku. ");
INSERT INTO yml_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Siwe natuna i vona i vo, Tamaku, malamala fuedi ma yaku tokemaiga a folofolova 'waimuye yamu veimea matatabuna a vematayakeyakedi. Siwe kebu tamu ava'ai 'u da veleku. Kebu tamu 'aisaya siaina 'u da veleku bega ma ekwavo 'a da 'ani 'a da sosoana. ");
INSERT INTO yml_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","We'e de'e natumu yamu kukua i ve'amubwadodoyedi vevine toalagogona 'waidie siwe tutuyanina i vilai i mai bulumakau veve'anina 'u nikei faifaina.’ ");
INSERT INTO yml_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tamana yana vona i tutuli i vo, Natuku, 'omu tutuya fuedi taiadi ta miamia. Nani matatabuna 'akonadi a 'anivelenedi 'waimuye. ");
INSERT INTO yml_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","I lubwaineda ta na 'ani ta na sosoana fai taimu i wafa wata i yawasa, i vuyo siwe wata ta veluagai.’” ");
INSERT INTO yml_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu i vona yana tovetutuyamavo 'waidie i vo, Tamu tomogo 'ai'aiwabuna yana tofolova i voneni bega yana kukua matatabuna i na 'isave'avinidi. Tamu tutuya tomogo tamu i nago i lu'ivona tomogo 'ai'aiwabuna 'waineye i vo, Yamu kukua 'ana to'isave'avina yana sauluva sakoina yamu mani i veve'amubwadodoyedi.’ ");
INSERT INTO yml_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bega tomogo 'ai'aiwabuna to'isave'avinanina i goleni i mai i voneni i vo, Yamu sauluva 'akonadi a 'asetai. Nuanuaku yaku kukua matatabuna tutulidi 'u na va'augidi ta na 'iseni 'aivia mani i luku, 'aivia mani i souyedi, nika ta na 'asetai 'aivia mani 'u ve'amubwadodoyedi. 'U na 'idewa'a'avai mulieta 'omu 'u na 'ailove folovanina 'wainega.’ ");
INSERT INTO yml_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tofolovanina i nago 'aisena i nuanua i vo, Yaku 'auvea i na veugeugeku, bani'odi a na munega? Kebu 'aku fata a na bakulaga fai luluku mweana wata talavelu'ui bunumayamayagina. ");
INSERT INTO yml_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","'Akonadi a nuani. Tamu nani a na 'idewai bega tutuyanina a na souyeku a na nago tomotoga fuedi i na vonevoneku yadi vanuge a na 'ani'ani wata a na 'eno'eno.’ ");
INSERT INTO yml_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Basenadi tomotoga 'ifwaidi kukua i 'ewa-maimaigidi yana 'auvea 'wainega bega 'awaie i na tutula, begaidi to'isave'avinanina i goledi 'aitamogana 'aitamogana i maia 'waineye. Tamu tomogo i velutolieni i vo, Ava'ai bola 'u na tutuli basenadi yaku 'auvea 'wainega 'u 'ewaiga?’ ");
INSERT INTO yml_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","I vo, Bunama ma ba'alidi 100.’ To'isave'avina i voneni i vo, Basenadi naninidi 'u 'ewadi 'ana lubulubu 'u kilumidiga side. 'U miabui, 'u sivedamaneni 100, 'u na kiluma-matayo'oi 50.’ ");
INSERT INTO yml_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wata tamu tomogo i velutolieni i vo, Ava'ai bola 'u na tutuli basenadi yaku 'auvea 'wainega 'u 'ewaiga?’ I vo, Witi ma venuanidi 100.’ To'isave'avina i voneni i vo, Side 'ana lubulubu basenadi 'u 'ewadina bei 'u kilumi, 'u miabui 'u sivedamaneni 100, 'u na kiluma-matayo'oi 80.’ Wata 'ifwaidi i maia, bani'odi i munegidi ava'ai basenadi i 'ewadiga faifaidi. ");
INSERT INTO yml_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tutuyanina yana 'auvea valana i nogai i vo, Yana sauluva sakoina i folova-sako 'waikuye, siwe yana 'asetayega yana sakona i velubwasabwasai.’” Wata Iesu i vo, Vona mogitana, tomotoga yadi nuanua bwaikina kukua, tutuya fuedi yadi 'aseta bwaikina bega yadi kukua i 'i'imoso'i, we'e Yaubada 'ana tove'ililibu tutuya fuedi yadi 'aseta siaina.” ");
INSERT INTO yml_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Wata Iesu i vona yana tovetutuyamavo 'waidie i vo, A na vonemi, tomotoga 'wa na 'ivaisedi yami kukua 'waidiega bega i na veianemi. Bola kukuanidi i na 'a'ava, ma yami sosoana 'wa na luku 'eba mia-vagata 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aitoi nani siaidi i na 'isave'avina-'atumaia kumanina ma 'ana vetumagana, wata 'ana fata nani bwaikidi i na 'isave'avina-dewadi. We'e aitoi nani siaidi i na 'isave'avina sakoidi, wata nani bwaikidi i na 'isave'avina sakoidi. ");
INSERT INTO yml_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Begaidi 'ai'edi fwayafwaya 'ana 'ai'aiwabu 'wa na ve'amubwadodoyedi, 'omi kebu ma 'ami vetumagana, 'awaie kebu tamu aitoi 'ai'aiwabu mogitana i na velemi bega 'wa na 'isave'avinidi. ");
INSERT INTO yml_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","'Ai'edi mali tomotoga yadi kukua 'wa na 'isave'avina sakoidi i na 'asetami kebu ma 'ami vetumagana, 'awaie igodi i da velemiga i na bodami. ");
INSERT INTO yml_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kebu 'ana fata tofolova 'aitamogana we'e 'ana toveimeavo 'adi 'ailuga 'waidie i na folofolova. 'Ako tamu i na baileni we'e tamu i na nuakalikalieni. Wata tamu i na vedumwe'ai'aieni, tamu i na vematayakeyakeni. Kebu 'ami fata 'wa na vetofolova Yaubada wata kukua 'waidie.” ");
INSERT INTO yml_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tutuyanina Falisi Iesu yana vona i nogai, i sidibidibieni fai yadi nuanua bwaikina mani. ");
INSERT INTO yml_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Bega Iesu i vonedi i vo, 'Omi kumanimiavo nuanuami tomotoga fuedi i na 'isemi nika i na awave'atumaiemi, siwe Yaubada yami nuanua matatabuna i 'asetadi. Naninidi tomotoga i subisubiadiga, Yaubada mataneye nani-'avo'avovo. ");
INSERT INTO yml_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Veimeanidi Mosese 'wainega wata tolu'ivonavo yadi ve 'asa'aiana 'ami awave'eda'eda, i maiga 'ana tugusa Ioni Tobafitaiso i le'wa. Tutuyanina 'waineye Vala 'Atumaina 'ana lau'age i velamu Yaubada nuanuana tomotoga i na veimeyedi yana 'Aila'a nageneye. Tomotoga fuedi i nogai i ve'edaeloelo nuanuadi i na luku Yaubada yana 'Eba Veimea nageneye. ");
INSERT INTO yml_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Abama wata fwayafwaya 'ana fata i na 'a'ava, we'e Yaubada yana veimea matatabuna kebu tamu sai'afo i na 'a'ava. ");
INSERT INTO yml_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","'Ai'edi aitoi yana vavine i na vesa'ilidi, wata tamu vavine i na nagidiga, 'akonadi i sakona. Wata 'ai'edi tomogo vavine nagisa'isa'ilidi i na nagidiga i na sakona vavinenidi taiadi.” ");
INSERT INTO yml_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Wata Iesu i vo, Tamu tomogo 'ai'aiwabuna i miamia, tutuya fuedi talauma 'atumai'avadi 'waidiega i vavaigavu wata 'ani'ani 'atumaidi i 'ani'ani. ");
INSERT INTO yml_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","We'e tamu tomogo i vewekowekoma 'ana wagava Lasalo, tutuya fuedi enavo i mimaieni tomogonina 'ai'aiwabuna yana vanuga 'awaneye. Bei i vevemiabuia nuanuana mukumuku i na 'ani'ani tomogo 'ai'aiwabuna 'ana talalia dibuneye. Tomogonina bonubonuna begaidi 'ou'ou i mimai yana bonu i luluyamudi. ");
INSERT INTO yml_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tutuyanina Lasalo i wafa, anelose abamayega i mai i vagavaia i naweni Ebelamo lilivaneye i miabui. Mulieta tomogo 'ai'aiwabuna i wafa i ve'ufai i nago towafa yadi 'eba mia 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bei veviga bwaikina i veveluagai, i 'isalaka Ebelamo i 'iseni 'ani'ie Lasalo taiadi. ");
INSERT INTO yml_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bega i vegole 'waineye i vo, Tamaku Ebelamo, 'u da 'isanuakalikalieku Lasalo 'u da vetunei nimana i da lu'utuvi ufeye meaku i da vebikai, yau veviga bwaikina a veveluagai 'ai-'ala'alata de'e 'waineye.’ ");
INSERT INTO yml_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Siwe Ebelamo i voneni i vo, Natuku, 'u na nuani basenadi ma yawaimuye nani fuedi 'atumaidi 'waimuye we'e Lasalo kebu. Siwe 'asiau ma yana sosoana nani 'atumaidi i veveluagadi, we'e 'omu 'u veveviga. ");
INSERT INTO yml_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Wata fai bwagala bwaikina 'omu wata 'ima kamwadeye i 'eno'eno, bega egavo nuanuadi i na wai kebu 'adi fata wata kebu tamu aitoi 'ana fata 'waimuyega i na damanama 'waimeye.’ ");
INSERT INTO yml_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Tomogo 'ai'aiwabuna i vo, Tamaku, we'e 'ai'edi kebu 'ana fataga, a vevelu'ui 'waimuye nuanuaku Lasalo 'u na vetunei tamaku yana vanuge taikwavo 'adi 5 i na vonedi i na nuaviladi bega de'e bei kebu i na mimaia veviga 'waineye.’ ");
INSERT INTO yml_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Wata Ebelamo i vo, 'Akonadi veimea Mosese 'wainega i mai wata Yaubada yana tolu'ivonavo yadi vona i 'eno'enovi, i lubwainedi vonanidi i na 'isedi wata i na vematayakeyakedi.’ ");
INSERT INTO yml_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wata tomogo 'ai'aiwabuna i vo, Tamaku Ebelamo, we'e kebu 'ana fataga, 'ai'edi tamu towafa i da yawasa-vaitugana i da nago i da vonedi 'adi fata i da nuaviladi yadi sakona 'waidiega.’ ");
INSERT INTO yml_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Siwe Ebelamo i vo, Mosese wata tolu'ivonavo yadi vona i bailaga wata bani'odi 'ai'edi towafa i na yawasa-vaitugana kebu yana vona i na vetumaganeni.’” ");
INSERT INTO yml_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu i vona yana tovetutuyamavo 'waidie i vo, 'Eba sailubu fuedi i 'eno'enovi, 'waidiega tomotoga i sakosakona. 'Ai'edi aitoi tamu tomogo i na vetalaimimili bega i na sakonaga, nuakalikalina fai 'awaie vita bwaikina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","'Ai'edi tovetalaimiimilanina tamu aitoi kwamana de'e bani'odi i na vetalaimimili, bola tomogonina veviga bwaikaotogina i na veluagai Yaubada 'wainega. Siwe bola tomogonina kebu i da vetalaimimilaga, bei tomotoga 'ifwaidi kileu vitana i da yogona-matayo'oi 'odoneye i da taweni malaveseye, veviga siaina i da veluagai. I da wafa-matayo'oga i lubwaineni, nika kebu i da vetalaimimilaga wata kebu veviga bwaikaotogina i da veluagai Yaubada 'wainega. ");
INSERT INTO yml_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Begaidi taunimi 'wa na 'isave'avinimi. 'Ai'edi tamu iami i na vesauluva sakoina 'waimie, 'wa na talabodeni wata 'ai'edi i na nuavilai yana sakona 'wainega, 'wa na nuatavuni. ");
INSERT INTO yml_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'Ai'edi 'aiata 'aitamogana nageneye sakona 7 i na 'idewadi 'waimie, yana mai 'aitamogana 'aitamogana 'waimie i na vo, A bunumayaga yaku sauluva faifaina, 'u da nuatavuniku,’ bonana 'wa na nogai 'wa na nuatavuni.” ");
INSERT INTO yml_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tomata'aulelevo yadi 'Auvea i voneni i vo, Nuanuama yama vetumagana 'u na 'imoso'iedi i na vetoketoke.” ");
INSERT INTO yml_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","'Auvea yadi vona i tutuli i vo, 'Ai'edi yami vetumagana 'ana vebwaika siaina bani'odi bila, 'ami fata welavi bwaikina de'e, 'waineye 'wa na vo, 'U 'aniabumu wata taunimu 'u bakulimu eyage,’ nika yami vona i na vematayakeyakeni. ");
INSERT INTO yml_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","'Ai'edi 'waimiega tamu aitoi ma yana tofolova, tofolovanina i na bakubakula 'alo 'aisaya i na 'i'isave'avinidi, tutuyanina i na vilai i na mai vanuge 'ana toveimea bani'odi i na voneyedi 'waineye? 'Wa da nuani, i da vo, 'Asa'aiana 'u miabui taiadi ta na 'ani?’ ");
INSERT INTO yml_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A nuani kebu. We'e mogitana i da vo, 'Aku'aku 'u na 'idewai, 'eba folova 'ana talauma 'u na ve'weseneni nika 'aku'aku wata 'aku walu'ai 'u na miedi, mulieta 'omu 'u na 'ani.’ ");
INSERT INTO yml_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Fai taunina yana tofolova kebu i na vekaiwa 'waineye, folovanina i 'idewaiga i lubwaineni. ");
INSERT INTO yml_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wata bani'odi 'omi, naninidi a voneyediga matatabuna 'wa na 'i'idewadiga 'wa na vo, 'Asa'aiana, fai 'ima yamu tofolovavo, begaidi 'a 'idewadiga i lubwainema.’” ");
INSERT INTO yml_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu i nunago Ielusalema weyaginega, nika i le'wa 'awalawa Samelia wata Galili 'adi 'edabala 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Sai'afoga i da le'wa tamu 'atamana 'waineye nika tomotoga 'adi 10 i veluagadi, viga sakoina i 'ewadi tomogodi i velufo'afo'ana. 'Ani'ieyega i tovoi bega i vegole i vo, 'Auvea Iesu, 'u da 'isanuakalikaliema.” ");
INSERT INTO yml_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","'Akonadi i 'isedi begaidi i vonedi i vo, 'Wa na nagoi tovelomu 'waidie, taunimi 'wa na sivemagesemi bega i na 'isemi viganina 'akonadi i 'a'ava, nika i na lu'ivoneyeni tomotoga 'waidie.” Tomotoganidi 'adi 10 i nunagoi 'edeye nika i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Matatabudi taunidi i 'isedi 'akonadi i ve'atumai, we'e tamu iadi ma yana sosoana i vilai i mimai Iesu 'waineye, bonana bwaikinega Yaubada i subisubiai. ");
INSERT INTO yml_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ma yana ve'ililibu i lumata'afufu Iesu 'ageneye i vekaiwa 'waineye. Tomogonina tomogo Samelia taunidi kebu me Diu taiadi i da veveiana. ");
INSERT INTO yml_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu i voneni i vo, Tomotoga 'ami 10 a 'ive'atumaimi, we'e emwavo 9 ava'aibe? ");
INSERT INTO yml_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Emwavonidi 'adi 9 me Diu, we'e 'omu tulimu siwe 'u vilamu 'u mai 'u vekaiwa Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wata Iesu i voneni i vo, 'U tovoi 'u nago, yamu vetumagana 'wainega 'akonadi 'u ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tamu tutuya 'ifwaidi totafalolo Falisi Iesu i velutolieni i vo, Ava'ai tutuyaga Yaubada yana veimea i na mai tomotoga 'waideye?” Yadi vona i tutuli i vo, Yana veimea yana mai kebu 'wa na 'iseniga. ");
INSERT INTO yml_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kebu tamu aitoi 'ana fata i na vo, Side taunina,’ 'alo i na vo, Sino'o taunina,’ fai yana veimeanina 'akonadi i mai tomotoga 'awasasamie.” ");
INSERT INTO yml_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mulieta yana tovetutuyamavo i vonedi i vo, 'Aiata 'ifwaidi i na 'a'ava 'wa na vo, Iesu i da souyeni ta da 'iseni,’ siwe kebu 'ana fata yau a vetomotogaotoga bei a na souyeku. ");
INSERT INTO yml_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","'Awaie tomotoga 'ifwaidi i na vonemi i na vo, Side taunina,’ 'alo i na vo, Sino taunina,’ kebu bonadi 'wa na vetumaganedi wata kebu 'wa na yogo'wailidi. ");
INSERT INTO yml_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","'Ai'edi tamuyoana i na kianamali abama matatabuna i na magetai, wata bani'odi yau a vetomotogaotoga tutuyanina a na vilaku a na mai tomotoga matatabudi i na 'isa'a'avaku. ");
INSERT INTO yml_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Siwe nagami tutuya de'e 'ana tomotoga i na vedumwe'ai'aieku veviga bwaikina a na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Basenadiotoga Noa yana tutuye tomotoga i nunuatavutavuna, 'ani'ava, yemu'ava, nagi'ava, nika Noa i dodoga yana wakeye mwai bwaikina i uledi matatabudi i ve'alawafawafa. Yau a vetomotogaotoga yaku mai-vaitugana wata bani'odi. ");
INSERT INTO yml_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Wata basenadiotoga Lota yana tutuye tomotoga i nunuatavutavuna, 'ani'ava, yemu'ava, i kimwakimwane wata i vevekimwane, i bakubakula wata i 'a'aiyogona vanuga, nika Lota i tovoi 'atamana Sodoma i 'iaweni 'ai-'ala'alata wata manufagila abamayega i obu matatabudi i 'alaidi. ");
INSERT INTO yml_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yau a vetomotogaotoga yaku souyagi wata bani'odi, tomotoga i na nunuatavutavuna nika bei a na le'wa. ");
INSERT INTO yml_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","'Aiatanina 'waineye 'ai'edi aitoi masi'edeye i na miamia, kebu 'ana fata i na luku vanuge yana kukua i na 'ewadi i na dega-matayo'o. Wata aitoi i nagoga bakule, kebu 'ana fata i na vilai vanuge tamu ava'ai 'ana 'ewa faifaina. ");
INSERT INTO yml_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","'Wa na nuanidi Lota yana vavine. 'Ai-'ala'alata 'wainega i degadega nika i siviladi i wafa. ");
INSERT INTO yml_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aitoi yana mia 'ana 'atumaina i na ve'o'oleni, kebu nuanuana i na tauyeni faifaiku i na wafaotoga. We'e 'ai'edi aitoi yana mia 'ana 'atumaina wata yawaina i na tauyedi faifaiku, mia 'atumaina wata miamia-vagaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A na vonemi, lovananina 'waineye tomotoga 'adi 'ailuga i na 'eno'enovi 'eba 'eno 'aitamogana 'waineye, tamu Yaubada i na vagavaia i na naweni we'e tamu i na baileni. ");
INSERT INTO yml_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Vevine 'adi 'ailuga 'ani'ani i na 'i'idewadewa, tamu i na vagavaidi, we'e tamu i na bailedi. ");
INSERT INTO yml_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tomotoga 'adi 'ailuga i na bakubakula, 'aitamogana Yaubada i na vagavaia, tamu i na baileni.” ");
INSERT INTO yml_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tovetutuyamavo i velutolieni i vo, 'Auvea, ava'ai tutuyaga naninidi i na souyedi?” Iesu i vo, 'Ai'edi manusibosibo 'wa na 'isedi i na vava'auta bei mogitana tamu nani wafana i 'eno'eno, wata bani'odi tugusanidi 'wa na 'isediga 'wa na 'asetai tutuya 'ana 'eba ve'a'ava i velilivana.” ");
INSERT INTO yml_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mulieta Iesu vona-awatabaiega i ve tovetutuyamavo 'waidie bega tutuya fuedi i na vevelu'ui Yaubada 'waineye kebu i na 'ailove. ");
INSERT INTO yml_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iesu i vo, Tamu 'atamana 'waineye, tovevonayavuga kebu Yaubada i da ve'ililibuyeni wata tomotoga faifaidi kebu i da nuanua. ");
INSERT INTO yml_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","'Atamananina 'waineye tovevonayavuganina i miamiaga wata bei tamu 'wabula i miamia. Tutuya fuedi i nunago toveimeanina 'waineye i vevelu'ui i vo, Tamu tomogo i vesauluva sakoina 'waimeye, nuanuama yamu veimea 'wainega 'u da 'ivaisema.’ ");
INSERT INTO yml_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Tutuya manamanawena tovevonayavuganina i baibaila kebu nuanuana i na 'ivaisedi, mulieta i logi yana nuanua i sivilai i vo, Yaubada kebu a da ve'ililibuyeni wata tomotoga faifaidi kebu a da nuanua, siwe vavine yadi mai-vaivaitugana faifaina a 'abiawa begaidi a na 'ivaisedi. 'Ai'edi kebu a na veimea bega 'aivaita i na veluagai, tutuya fuedi i na mimai-vebogi 'waikuye i na 'ivelogilogiku.’” ");
INSERT INTO yml_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Wata Iesu yana tovetutuyamavo i vonedi i vo, 'Wa na nuani tovevonayavuganina yana vona. ");
INSERT INTO yml_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Toveimea sakoina siwe vavine i 'ivaisedi, we'e 'omi mogitana 'aivaita 'wa na veluagai Yaubada 'wainega fai taunina 'atumaiotogina. 'Omi 'wa da nuani, Yaubada yana tomotoga lovana wata 'aiata i vevelu'ui 'aivaita faifaina, i na 'abiwalowaloga 'alo i na 'ivogavogana? ");
INSERT INTO yml_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A na vonemi i na veimea yana nuanua tonovidi 'waidiega 'aivaita i na veluaga-matayo'oi. We'e tutuyanina yau a vetomotogaotoga a na vilaku a na mai tomotoga fuedi ma yadi vetumagana a na veluagadi 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tomotoga 'ifwaidi yadi nuanua i vo, 'Ima 'atumaima, mali tomotoga nani-'avo'avovo,” begaidi Iesu i vona-awatabai 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","I vo, Tomotoga 'adi 'ailuga i luku Vanuga 'Eba Velu'ui 'waineye i na velu'ui. Tamu totafalolo Falisi we'e tamu takesi tolaugogona. ");
INSERT INTO yml_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falisi i tovi'eni i velu'ui i vo, Yaubada a vekaiwa 'waimuye fai yaku sauluva kebu bani'odi mali tomotoga, taunidi toveumokai, vivinagodi wata tove'avula-'avo'avovo. Wata a vekaiwa fai yau kebu de'e takesi tolaugogona vivinagona bani'odiga. ");
INSERT INTO yml_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wiki 'aitamogana 'aitamogana nagedie 'aiata 'ailuga 'ailuga 'ani 'wainega a veve'udigana bega yaku velu'ui 'waimuye i na vetoketoke, wata mani a veveluagai yaku folova 'wainega a 'e'etokwaudi 10, 'etokwau tamu a 'a'aniveleneni 'waimuye.’ ");
INSERT INTO yml_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","We'e tolaugogonanina tulineye i tovoi kebu nuanuana i na 'isalaka abame ma yana bunumayaga i 'odu i velu'ui i vo, Yaubada, yau tosakona, 'u da 'isanuakalikalieku.’” ");
INSERT INTO yml_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Wata Iesu i vo, A na vonemi, tolaugogonanina yana sakona Yaubada i nuatavuni nika i nago yana vanuge, we'e Falisi kebu. Egavo taunidi i na awa'ai'aidiga 'awaie Yaubada i na veviladi i na obu we'e egavo taunidi tonuaobu, 'awaie Yaubada i na silakaidi.” ");
INSERT INTO yml_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tomotoga 'ifwaidi natudiavo i miedi nuanuadi Iesu i na 'abitonovidi wata i na vona-nuakalikaliedi, siwe yana tovetutuyamavo i 'isedi i talabodedi. ");
INSERT INTO yml_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Iesu yavayavavanidi i vonedi i na maia 'waineye wata i vo, Kwakwama 'wa bailedi, i na maia 'waikuye, fai egavo taunidi tonuaobu yavayavava de'e bani'odi, 'adi fata taunidi i na tauyedi bega Yaubada i na veveimeyedi yana 'Aila'a nageneye. ");
INSERT INTO yml_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A vona mogitana 'waimie, aitoi Yaubada i na vetumaganeni bani'odi yavayavava yadi vetumagana, Yaubada i na veimeyeni yana 'Aila'a nageneye, we'e 'ai'edi kebu, kebu 'ana fata.” ");
INSERT INTO yml_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tamu me Diu yadi to'edakumeta i velutoli Iesu 'waineye i vo, Tove 'atumaimu, ava'ai a na 'idewai bega mia 'atumaina wata miamia-vagaina a na veluagai?” ");
INSERT INTO yml_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu yana velutoli i tutuli i vo, Awale 'u awave'atumaieku? Kebu tamu aitoi 'atumainaga, Yaubada 'aiseotogina 'atumaina. ");
INSERT INTO yml_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ve'etoboda 'akonadi 'u 'asetadi basenadi Yaubada Mosese i veleni, kebu tamu aitoi yana vavine 'u na luobuyedi, kebu 'u na luvewafaga, kebu 'u na vainagoga, kebu 'u na vekali tamu tomogo yana sauluva faifaina, tamamu wata inamu 'u na ve'ililibuyedi.” ");
INSERT INTO yml_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tomogo i vo, We'e ve'etobodanidi basenadi siaikuyega i maiga 'asiau a vevematayakeyakedi.” ");
INSERT INTO yml_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesu i voneni i vo, Wata tamu nani 'waimuye kebu 'u da 'idewaiga. 'U na nago yamu kukua wata nani matatabuna 'waimuye i 'eno'enoviga 'u na vekimwaneyedi, tutulidi 'u na 'ewadi, bega egavo i vewekowekomaga 'u na 'ivaisedi nika 'u na ve'ai'aiwabu abame. 'U na 'anivelenedi i na 'a'avana 'u na mai 'u na vetutuyameku.” ");
INSERT INTO yml_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tomogonina Iesu yana vona i nogai, nuana i vita bwaikina fai yana 'ai'aiwabu fuedi, nuana i loloi kebu nuanuana i na 'anivelenedi. ");
INSERT INTO yml_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu i 'iseni tomogo ma yana nuavita maigina i 'anivivili begaidi i vo, Tove'ai'aiwabu yadi luku Yaubada yana 'Eba Veimea 'waineye vitana. ");
INSERT INTO yml_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mogitana, bawe yana luku aima mataneamo vitana, we'e tove'ai'aiwabu yadi luku Yaubada yana 'Eba Veimea 'waineye vitaotogina.” ");
INSERT INTO yml_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tomotoganidi Iesu yana vona i noganogaiga i velutolieni i vo, Vetuma aitoi 'ana fata 'ita'ita'i i na veluagai?” ");
INSERT INTO yml_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu yadi vona i tutuli i vo, Tomotoga 'aise'avadi kebu 'adi fata 'ita'ita'i i na veluagai, we'e Yaubada 'waineye nani matatabuna 'ana fata.” ");
INSERT INTO yml_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Fita Iesu i voneni i vo, Maide 'ima nani matatabuna 'a bailedi 'a maia 'waimuye 'a vevetutuyamemu.” ");
INSERT INTO yml_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu i vonedi i vo, A vona mogitana 'waimie, egavo Yaubada yana veimea faifaina yadi vanuga i 'iawedi, yadi vevinevo, ediavo, tamadiavo, inadiavo 'alo natudiavo i 'iawediga, 'awaie naninidi 'adi tutula bwaikaotogina Yaubada i na veledi. ");
INSERT INTO yml_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Naninidi 'ai'edi i na bailediga, tutuya de'e nani fueotogidi Yaubada i na veledi wata 'awaie mia 'atumaina wata miamia-vagaina i na veluagai.” ");
INSERT INTO yml_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu yana tovetutuyamavo 12 i vonedi taiadi tulidie i nagoi i vonedi i vo, A na vonemi, ta nunagoi Ielusalema bei nani matatabuna basenadiotoga Yaubada yana tolu'ivona i kilumiga yau a vetomotogaotoga faifaiku, 'adi mogitana i na souyedi 'waikuye. ");
INSERT INTO yml_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","I na 'aniveleneku mali tomotoga kumanidiavo kebu Diu 'waidie i na sidibidibieku, i na yagaiku wata i na kiwaliku. ");
INSERT INTO yml_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","I na toke i na fitaliku mulieta i na luvewafaku, siwe 'aiata 'ana vetonu 'waineye a na tovoi wafayega.” ");
INSERT INTO yml_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Siwe tovetutuyamavo kebu i da 'asetaiga yana vona 'ana nuanua. Yana nuanuanina Yaubada i giveni bega ava'ai Iesu i vonevoneyeniga kebu 'adi fata i na 'asetai. ");
INSERT INTO yml_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu ma enavo sai'afoga i na le'wai Ieliko nika tamu tomatasako i veluagai 'edeye i miabui i vevelu'ui mani. ");
INSERT INTO yml_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tutuyanina 'aila'a i le'wa i nunagoi bonadi i nogai, bega i velutoli i vo, No'o ava'ai i sousouyeni?” ");
INSERT INTO yml_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","'Ifwaidi tomotoga yana velutoli i tutuli i vo, Iesu tomogo Nasaledi i mai i nunago.” ");
INSERT INTO yml_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Begaidi tomatasako i vegole i vo, Iesu, 'omu Kini Devida tubuna 'u da 'isanuakalikalieku.” ");
INSERT INTO yml_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tomotoganidi i tovotovoiga Iesu lilivaneye i yagaia i vo, 'U ve'wada.” Nika i toke i vegolegole i vo, Iesu, 'omu Kini Devida tubuna, 'u da 'isanuakalikalieku.” ");
INSERT INTO yml_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Iesu bonana i nogai i tovoi i vo, Tovegolegolenina 'wa mieni 'waikuye.” Tutuyanina i mai 'waineye i velutolieni i vo, Ava'ai nuanuamu a na 'idewai faifaimu?” I vo, 'Auvea, nuanuaku a da 'isala.” ");
INSERT INTO yml_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesu i vo, 'Atumaina, 'u 'isala. Fai 'u vetumaganeku, 'akonadi 'u ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Iesu yana voneye nika i 'isala bega i tovoi, Iesu mulineye i nunago Yaubada 'waineye i vevekaiwa. Wata tomotoga fuedi i 'iseni Yaubada i subiai. ");
INSERT INTO yml_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu tomatasako i 'ive'atumaia, i 'a'avana i luku Ieliko kamwaneamo i nago. ");
INSERT INTO yml_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","'Atamananina 'waineye takesi tolaugogona yadi to'edakumeta tamu bei i miamia. Kumanina tomogo 'ai'aiwabuna, 'ana wagava Sakiusa. ");
INSERT INTO yml_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nuanuana Iesu i na 'iseni siwe kebu 'ana fataga fai tomogo 'ale'usana wata 'aila'a bwaikina i tovibabaleni. ");
INSERT INTO yml_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Fai kebu 'ana fata i na 'iseniga begaidi i 'edakumeta i lilide i nago tamu welavi bwaikina 'edeye i tovotovoi, tabwaneye i laka bega 'ana fata Iesu i na 'iseni. ");
INSERT INTO yml_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tutuyanina Iesu i le'wa welavinina lilivaneye i 'isalaka i voneni i vo, Sakiusa, 'u lilide 'u obuma ta na nago yamu vanuge 'amu veba'wa faifaina a mai.” ");
INSERT INTO yml_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakiusa i lilide i obu, ma yana sosoana Iesu i vagavaia ma fuedie i nagoi yana vanuge. ");
INSERT INTO yml_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tomotoga fuedi Iesu i 'iseni i vebonavoluvolu i vo, Tomogo no'o awale i nago tosakona yana vanuge?” ");
INSERT INTO yml_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","We'e Sakiusa i tovoi 'Auvea mataneye i vo, A na vonemu, yaku kukua a na 'idia, 'etokwau 'ailuga, tamu tovewekowekoma a na veledi we'e luvegalalana tauniku faifaiku. Vekaliega tomotoga yadi mani a 'ewa-maimaigidi begaidi a na veviladi. Tutuyanina a na veviladiga, 'ai'edi 'aitamogana a vinagoi wata 'waikuyega 'aitonu taiadi a na veviladi.” ");
INSERT INTO yml_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iesu i voneni i vo, 'Asiau 'ita'ita'i i mai vanuga de'e 'ana tomia 'waineye i lubwaineni, fai tomogonina tamu wata Ebelamo tubuna. ");
INSERT INTO yml_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","We'e yau a vetomotogaotoga a maiga egavo Yaubada yana 'eda'eda i bavuyeni, bani'odi i vuyo, a na lualedi a na 'ita'ita'iedi.” ");
INSERT INTO yml_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iesu ma enavo sai'afoga i na le'wai Ielusalema. 'Aila'a Iesu yana vona i noganogai yadi nuanua igodi i vo, Sai'afoga Yaubada yana veimea i na souyeni tomotoga 'waideye.” Begaidi Iesu i vona-awatabai 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","I vo, Tamu toveimea bwaikina i nago 'ani'ie tamu 'awalawa 'waineye bega i na ve-kini, mulieta i na vilai i na mai yana 'atamane. ");
INSERT INTO yml_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yana tauya 'waineye yana tofolova 'adi 10 i goleva'augidi i nagoi 'waineye, 'aitamogana 'aitamogana lubulubu 100 i veledi. Wata i vonedi i vo, Tutuyanina a na 'iawemiga, 'omi mani de'e 'wa na vefolovedi bega 'adi 'imoso'i 'wa na veluagadi.’ ");
INSERT INTO yml_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Siwe yana tomotoga i vedumwe'ai'aieni bega tutuyanina i nunago vala i vetunei kini bwaikina 'waineye i vo, Tomogonina bola i na ve-kini kebu nuanuama i na vetoveimea 'waimeye 'a baila.’ ");
INSERT INTO yml_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Siwe toveimeanina i ve-kini mulieta i vilai i mai yana 'atamane. Tutuyanina i le'wa, yana tofolovavo basenadi mani i velediga, i vonedi i maia 'waineye. Nuanuana i na 'asetai 'aivia mani i veluagadi. ");
INSERT INTO yml_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tamu tofolova i mai i vo, 'Auvea, lubulubu 100 'u velekuga bega a vefolovedi a 'imoso'ieni lubulubu 1,000 a veluagai.’ ");
INSERT INTO yml_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yana 'auvea i voneni i vo, 'Atumaina, 'omu tofolova 'atumaimu ma 'amu vetumagana. Fai nani siaina 'u 'isave'avina-'atumaia, bega a na yatomu 'atamana bwaikidi 'adi 10 'u na 'isave'avinidi.’ ");
INSERT INTO yml_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tofolova 'ana veluga i mai i vo, 'Auvea, lubulubu 100 'u velekuga bega a vefolovedi a 'imoso'ieni lubulubu 500 a veluagai.’ ");
INSERT INTO yml_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yana 'auvea i voneni i vo, A na yatomu 'atamana bwaikidi 'adi 5 'u na 'isave'avinidi.’ ");
INSERT INTO yml_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wata tamu yana tofolova 'adi vetonu i mai i vo, 'Auvea, yamu mani side, bagase 'u veleku a giveniga a mieni 'waimuye. ");
INSERT INTO yml_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","A 'asetamu yamu veimea toketokedi, begaidi a kololo. Mali tomotoga yadi kukua 'u eloelodi wata kebu 'u da bakubakulaga siwe 'u 'a'aialamo.’ ");
INSERT INTO yml_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Yana 'auvea i voneni i vo, 'Omu tofolova sakoimu. Yamu vonanina faifaina 'amu veimea a velemu. 'U vonaga yaku veimea toketokedi, awale yaku mani 'u giveni? Wata 'u vonaga mali tomotoga yadi kukua a eloelodi wata kebu a da bakubakulaga siwe a 'a'aialamo, awale yaku mani kebu 'u da yatoi mani 'ana bubuaka 'waineye? A da vilaku a da mai yaku maninina ma 'ana 'imoso'i a da 'ewai.’ ");
INSERT INTO yml_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kini tomotoga i tovotovoiga i vonedi i vo, Lubulubu 100 'waineye 'wa na eloi, tomogonina lubulubu 1,000 'waineye 'wa na veleni.’ ");
INSERT INTO yml_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Siwe yana vona i tutuli i vo, 'Auvea, sino 'akonadi lubulubu 1,000 'waineye i 'eno'eno.’ ");
INSERT INTO yml_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wata yadi vona i tutuli i vo, A na vonemi, 'ai'edi aitoi 'ana veuveuta 'wainega i na folova-'atumai wata 'ana 'imoso'i i na veluagai, we'e aitoi 'ana veuveuta kebu i na vefolova-'atumaieniga veuveutanina siaina i na elo'a'avai. ");
INSERT INTO yml_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","'Asa'aiana, 'aku tovedumwe'ai'ainidi basenadi i vona igodi kebu nuanuadi a na ve-kini, 'wa na miedi matakuye 'wa na luvewafadi.’” ");
INSERT INTO yml_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tutuyanina Iesu i veifufu'a'ava tomotoga 'waidie i kumeta i nunago Ielusalema. ");
INSERT INTO yml_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","'Akonadi sai'afo i le'wale'wai 'atamana 'ailuga 'waidie Bedifegi wata Bedani. Bei 'Oya Olive 'waineye Iesu tovetutuyamavo 'adi 'ailuga i vonedi i na kumeta. ");
INSERT INTO yml_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Wata i vonedi i vo, 'Atamana debanagomiega 'waineye 'wa na nagoi. Tutuyanina 'wa na le'wa 'wa na lukuluku doniki tubuvauvauna 'wa na 'iseni i luifweni i tovotovoi, basenadi kebu tamu aitoi kwavuneye i da lakaga. 'Wa na yavuya 'wa na mieni 'waikuye. ");
INSERT INTO yml_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","'Ai'edi tamu aitoi i na velutoliemiga i na vo, Awale 'wa yavuyavuya?’ 'Wa na vo, 'Auvea nuanuana.’” ");
INSERT INTO yml_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tovetutuyamavonidi 'adi 'ailuga i nagoi ava'ai Iesu i voneyeniga bani'odi i veluagai. ");
INSERT INTO yml_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tutuyanina i yavuyavuya toni'aisaya i vonedi i vo, Awale 'wa yavuyavuya?” ");
INSERT INTO yml_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","35","Tovetutuyamavo i tutula i vo, 'Auvea nuanuana.” Nika toni'aisaya i tauyeni bega i 'ewai i naweni Iesu 'waineye. 'Aisayanina i mieni Iesu 'waineye 'adi talauma kwavuneye i yatodi mulieta Iesu bei i miabui. ");
INSERT INTO yml_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tutuyanina i laka i nunagoi tomotoga fuedi ma yadi ve'ililibu yana 'eda i 'ivivigavuya 'adi talaumayega. ");
INSERT INTO yml_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","'Akonadi i laka 'Oya Olive deba'aineye we'e no'o bega 'eda i obuobu Ielusalema faifaina, nika yana tovetutuyamavo fuedi ma yadi vekaiwa bonadi bwaikinega Yaubada i subisubiai, 'eba nuavogana wata 'eba nua'ewa Iesu i 'idewadewadiga faifaidi. ");
INSERT INTO yml_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","I vegolegole i vo, Yada Kini i mimai 'Auvea 'ana wagavayega, Yaubada i da vevesauluva 'atumaina 'waineye. Tomia abama ma yadi sosoana i miamia, kumanina tabwaotogineye ta na subisubiai.” ");
INSERT INTO yml_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Totafalolo Falisi 'ifwaidi 'aila'a 'waidiega bonadi bwaikinega Iesu 'waineye i vo, Tove, yamu tovetutuyamavo 'u talabodedi i na ve'wada.” ");
INSERT INTO yml_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iesu yadi vona i tutuli i vo, A na vonemi, 'ai'edi i da ve'wada, ma'itufa kileu ma yadi subia i da vegolegole.” ");
INSERT INTO yml_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu i le'wa Ielusalema lilivaotogineye i 'iseni ma yana nuavita matageuna i ilolo. ");
INSERT INTO yml_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Wata i vo, Nuanuaku bwaikina 'asiau 'wa da 'asetai bani'odi 'wa da munega bega yami mia i da ve'atumai. Siwe kebu 'ami fata 'wa na 'asetai. ");
INSERT INTO yml_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Tamu tutuya i na souyeni 'waimie 'ami gaviavo i na maia i na tovififinemi wata i na lutamubodemi. Yami 'atamana kalikalina wata fa'alina siwe 'ami gavianidi kalimuliega fwayafwaya i na ivuya i na laka, beidimo i na lakawa i na lukuwa nika i na leomi. I na lubaibaiemi bega kebu tamu aitoi i na luveyawayawai, vanuganidi wata kalinina matatabuna i na geudi. Vitanina i na souyeni 'waimie fai tutuyanina Yaubada i mai nuanuana i na 'ita'ita'iemi siwe 'wa bavuyeni.” ");
INSERT INTO yml_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Tutuyanina Iesu i luku Vanuga 'Eba Velu'ui 'waineye i 'isedi tomotoga fuedi yadi kukua i vevekimwaneyedi vanuganina nageneye. Begaidi matatabudi i sogiedi wata i vonedi i vo, Basenadiotoga i kilumi Yaubada yana Buki nageneye, Yaubada i vo, Yaku vanuga 'ana wagava Vanuga 'Eba Velu'ui.’ Siwe 'omi 'wa vesivilai tovainago yadi 'eba giva.” ");
INSERT INTO yml_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","'Aiata 'aitamogana 'aitamogana Iesu i veve Vanuga 'Eba Velu'ui nageneye. Tovelomu yadi to'edakumetavo, ve'etoboda 'adi tovevo wata tomotoga yadi to'edakumetavo matatabudi nuanuadi i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","'Ana luvewafa 'ana 'eda i luala-wayoga fai tomotoga matatabudi yana veifufu i vivinenegeniga kebu nuanuadi tamu yana vona i na ve'anita'ia. ");
INSERT INTO yml_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tamu 'aiata Iesu i luku Vanuga 'Eba Velu'ui 'waineye i lau'age tomotoga 'waidie. Tutuyanina i veve 'waidie Vala 'Atumaina faifaina tovelomu yadi to'edakumetavo, ve'etoboda 'adi tovevo wata to'edakumeta 'au'auveadi i maia i velutolieni. ");
INSERT INTO yml_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","I vo, Nuanuama 'a na 'asetai aitoi i vetunemu bega naninidi 'u 'i'idewadi 'alo aitoi veimea i velemu?” ");
INSERT INTO yml_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Iesu i vo, We'e tamu velutoli yau a na velemi. 'Wa da nuani, Ioni Tobafitaiso aitoi veimea i veleni bega tomotoga i bafitaisodi? Yaubada 'alo tomotoga?” ");
INSERT INTO yml_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","To'edakumetanidi 'aise'avadi i veifufu i vo, Bani'odi ta na voneyedi? 'Ai'edi ta na vo, Yaubada veimea Ioni i veleni,’ 'ako i na vo, Vetuma awale kebu Ioni yana vona 'wa da vetumaganeni?’ ");
INSERT INTO yml_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wata 'ai'edi ta na vo, Tomotoga veimea Ioni i veleni,’ 'aila'a de'e i na lukileuda fai i nuani Ioni tamu Yaubada yana tolu'ivona.” ");
INSERT INTO yml_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Begaidi Iesu yana velutoli i tutuli i vo, 'Ima kebu 'a da 'asetaiga aitoi veimea Ioni i veleni.” ");
INSERT INTO yml_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iesu i vonedi i vo, Vetuma yau wata kebu a na vonemi aitoi veimea i veleku bega naninidi a 'i'idewadi.” ");
INSERT INTO yml_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wata vona-awatabaiega Iesu i veifufu tomotoga 'waidie. I vo, Tamu tomogo kalefa talagina i bakuli mulieta tomotoga 'ifwaidi nimadie i yatoi i na 'isave'avini, nika i tauya i nago mali 'awalaweye bei i miamia tutuya manamanawena. ");
INSERT INTO yml_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kalefa yana kumaga 'ana tutuya i le'wa, tonibakula tamu yana tofolova i voneni i na nago yana bakula 'ana to'isave'avinavo 'waidie, vuaga 'ifwaidi i na miedi faifaina. Siwe to'isave'avinanidi tofolova i 'ive'avini i nikei i vevilai nima'ava'avana. ");
INSERT INTO yml_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mulieta tamu yana tofolova i vetunei, i nikei wata i yagaia, mulieta i vevilai nima'ava'avana. ");
INSERT INTO yml_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wata 'ana vetonu i vetunei, veviga bwaikina i veleni wata i taweni kalimulie. ");
INSERT INTO yml_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tonibakula i vo, Ava'ai a na 'idewai? 'Akonadi a nuani. Natuku yaku tamogana nuafouku a na vetunei, voke i na ve'ililibuyeni.’ ");
INSERT INTO yml_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Siwe to'isave'avinanidi i 'isanaweni i mimai 'aise'avadi i veifufu i vo, No'o tonibakula natuna, bola nani matatabuna i na 'ewadi i na veimeyedi. Ta na luvewafai bega naninidi ta na 'ewadi.’ ");
INSERT INTO yml_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bega i 'ive'avini i taweni i obu kalimulie bei i luvewafai.” Iesu tomotoga i velutoliedi i vo, Tonibakula 'ana talaga 'ana to'isave'avinavo bani'odi i na munegidi? ");
INSERT INTO yml_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","I na vilai to'isave'avinanidi matatabuna i na leodi mulieta tomotoga 'ifwaidi i na vonedi i na veto'isave'avina.” Tutuyanina tomotoga Iesu yana vona i nogai i vo, Vitanina Yaubada i da talabodeni bega kebu i da souyeni.” ");
INSERT INTO yml_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu i 'isanago tomotoga 'waidie, nika tamu vona-samula Yaubada yana Buki 'wainega i veifufuyeni 'waidie, tomotoga Yaubada 'ana Venua'ivina i na baileniga faifaina. I vo, 'Omi 'wa da nuani de'e vonanina ava'ai 'ana 'aseta? Vonanina i vo, To'aiyogonavo folova tamu i 'iseni siwe i baileni, tutuya de'e i ve'unututuyeni.’ ");
INSERT INTO yml_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Egavo i na tayaidi i na be'u folovanina tabwaneye i na tudabedabedi, wata 'ai'edi folovanina i na 'anifoia tomotoga tabwadie i na tukudakudadi.” ");
INSERT INTO yml_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ve'etoboda 'adi tovevo wata tovelomu yadi to'edakumetavo Iesu yana vona i nogai i 'asetai 'adi vona-awatabai, taunidi bani'odi to'aiyogonanidi wata to'isave'avinavo sakoidi, nika nuanuadi 'aiatanina 'waineye i da 'ive'avini, siwe kebu 'adi fataga fai tomotoga nuanuadi Iesu begaidi i kololoyedi. ");
INSERT INTO yml_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Me Diu yadi to'edakumetavo nuanuadi Iesu i na 'ive'avini begaidi i vevemata'i'i'ieni. Tomotoga 'ifwaidi mani i veledi 'adi tutula i na nago Iesu 'waineye i na bavuseba bega velutoli 'waidiega i na siloloi. 'Ai'edi kebu i na tutula-dewadiga to'edakumetanidi 'adi fata i na lu'ivoneyeni Loma kabemani 'waidie bega Iesu i na 'ive'avini. ");
INSERT INTO yml_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Begaidi tobavusebanidi i nagoi Iesu 'waineye i velutolieni i vo, Tove, yamu vona wata yamu ve tonovidi, kebu 'u da vekaliga. 'A 'asetamu kebu 'u da vavaiega wata kebu 'u da lalau'idi siwe 'u veve mogitana Yaubada yana nuanua tomotoga 'waimeye. ");
INSERT INTO yml_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","'U da nuani, i lubwaineda 'ida me Diu ta na takesi Loma yadi toveimea bwaikina Sisa 'waineye 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Iesu yadi bavuseba 'akonadi i 'asetai begaidi i vonedi i vo, Maninina 'wainega ta yatoyato takesi 'wa na mieni ta na 'iseni. Aitoi 'anununa wata 'ana wagava maninina 'waineye?” ");
INSERT INTO yml_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","I vo, Sisa.” Iesu i vonedi i vo, Vetuma 'ai'edi ava'ai Sisa faifaina 'wa na 'aniveleneni Sisa 'waineye, we'e ava'ai Yaubada faifaina 'wa na 'aniveleneni Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","To'edakumetanidi kebu 'adi fata tamu ava'ai 'wainega Iesu i na siloloi tomotoga matadie bega i na vekali, begaidi ma yadi nuavogana i ve'wadamo. ");
INSERT INTO yml_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","'Ifwaidi Diu totafalolo 'adi wagava Sadusi i maia Iesu 'waineye. Taunidi yadi vona igodina tomotoga kebu i na yawasa-vaitugana. ");
INSERT INTO yml_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tomotoganidi Iesu i velutolieni i vo, Tove, basenadiotoga Mosese yada veimea i kilumi i vo, 'Ai'edi tamu tomogo i na wafaga siwe kebu natunavoga, 'wabulina taina i na nagidi bega i na venatuna tatana 'ana wagava wata 'ana wauma faifaidi.’ ");
INSERT INTO yml_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tomogo ma tainavo 'adi 7, tulaiotogina i nagi kebu tamu natunaga i wafa. ");
INSERT INTO yml_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","'Wabula yadi bwa i nagia wata kebu tamu natunaga i wafa. ");
INSERT INTO yml_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wata bani'odi 'adi vetonu yadi bwa i nagidi i nagoga taidiavo matatabudi 'wabulanidi taiadi i nagi siwe kebu tamu natudiavoga. ");
INSERT INTO yml_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tomotoganidi 'adi 7 i wafa'a'ava, mulieta 'eba ve'a'ava 'waineye vavine yawaidi i 'a'ava. ");
INSERT INTO yml_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","'Omi 'wa vonaga 'awaie towafa matatabudi i na yawasa-vaitugana, begaidi 'u na vonema, 'aiatanina 'waineye aitoi mogitana yana vavine, fai tomotoganidi 7 taiadi i nagi.” ");
INSERT INTO yml_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu yadi velutoli i tutuli i vo, Tomotoga 'asiau fwayefwayeye i miamianiga, iaveta wata vevine i naginagi. ");
INSERT INTO yml_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","We'e tomotoganidi 'awaie i na tovoi-vaitugana i na luku abame, bei i na miamiani yadi sauluva bani'odi anelose, nagi kebu wata kebu i na wafaga. Fai Yaubada i na sivetovoidi wafayega begaidi natunavo. ");
INSERT INTO yml_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Basenadi Mosese i kiluma welavi i 'ala'alata faifaina, vonanina 'wainega ta 'asetai 'awaie towafa i na tovoi-vaitugana. Avinodi basenadiotoga Ebelamo, Aisake wata Iakobo yawaidi i 'a'ava, siwe i kilumiga i vo, 'Auvea Ebelamo yana Yaubada, Aisake yana Yaubada wata Iakobo yana Yaubada.’ ");
INSERT INTO yml_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","De'e bani'odi i kilumiga fai tomotoganidi basenadiotoga i wafa siwe 'asiau ma yawaidi Yaubada taiadi i miamia. Begaidi kebu tamu aitoi wafanaga Yaubada mataneye.” ");
INSERT INTO yml_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","We'e 'ifwaidi ve'etoboda 'adi tovevo Iesu yana vona i nogai i vo, Tove, 'u vona mogitana.” ");
INSERT INTO yml_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Begaidi kebu tamu aitoi ma yana venuafoufa'ala Iesu i da velutolieni tamu nani faifaina. ");
INSERT INTO yml_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu tomotoga i velutoliedi i vo, Tomotoga i vonaga Keliso, taunina Yaubada 'ana Venua'ivina, Kini Devida tubuna. Awale bani'odi i voneyedi? ");
INSERT INTO yml_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Basenadiotoga Devida tauniotogina i kilumi Buki Same 'waineye Yaubada 'ana Venua'ivina faifaina i vo, 'Auvea i vona 'aku Toveimea 'waineye i vo, Veimea a velemuga bega 'u na miabui 'aku 'atagiega. ");
INSERT INTO yml_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","I na nagoga 'amu gaviavo a na vetoketoke-'iawedi bega 'u na veveimeyedi.”’ ");
INSERT INTO yml_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Keliso mogitana Devida 'ana wauma 'wainega i souyeni siwe i vebwaika-'iaweni, begaidi Devida i ve'awa-Toveimea Keliso 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","'Aila'a bwaikina Iesu yana vona i vivinenegeni, yana tovetutuyamavo 'waidie i vo, Taunimi 'wa na 'i'isave'avinimi i na nunago ve'etoboda 'adi tovevo i na vekaliemi. Talauma manamanawedi i veve'wesenedi i yabayaba 'atamanafouye bega tomotoga ma yadi ve'ililibu i na vevekaiwa 'waidie. Nuanuadi to'edakumeta bwaikidi taiadi i na mimiabui 'eba miava'auta 'waidie wata sakali 'waidie nuanuadi i na mimiabui ma 'adi wagava taiadi. ");
INSERT INTO yml_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","We'e 'wabu'wabulavo i vevekaliedi yadi kukua i eloelodi wata yadi velu'ui i lulumanamanawedi bega tomotoga i na subisubiadi i na vo 'ako mogitana Yaubada yana tofolovavo 'atumaidi. Siwe 'awaie 'adi vematavuloga bwaikina i na veluagai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu i miamia Vanuga 'Eba Velu'ui nageneye mani 'eba yato lilivaneye, tomotoga 'ai'aiwabudi i 'ise'isedi yadi 'anivelena-maimaiga i yatoyato 'eba yato 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tamu 'wabula i vewekowekomaga i 'isedi kileu 'ailuga 'wau'waugidi i dodogidi. ");
INSERT INTO yml_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iesu yana tovetutuyamavo i vonedi i vo, A vona mogitana 'waimie, tove'ai'aiwabu mani bwaikina i na yato, we'e 'wabula yadi 'anivelena-maimaiga matatabudi i vebwaika-'iawedi. ");
INSERT INTO yml_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tove'ai'aiwabu i yatoga siwe wata yadi mani bwaikidi i 'eno'enovi, we'e 'wabulanidi yadi mani matatabuna i lusaweni. Kebu wata tamu mani 'waidie i da 'eno'eno 'adi'adi faifaina.” ");
INSERT INTO yml_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iesu yana tovetutuyamavo 'ifwaidi Vanuga 'Eba Velu'ui i 'iseni faifaina i veifufu i vo, 'Wa 'iseni, 'ana 'isa 'atumaiotogina. Kileu bwaikidi wata 'aninamanamalidi, we'e 'ana vaigavu tomotoga yadi 'anivelena-maimaiga Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Iesu yadi vona i nogai i vonedi i vo, Vanuganina 'wa 'ise'iseniga 'awaie 'ami gaviavo i na maia matatabuna i na geuya wata kileunidi bega i bibinaga i na tutuwealidi matatabuna i na tubakabakaledi.” ");
INSERT INTO yml_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mulieta i velutoli Iesu 'waineye i vo, Tove, nuanuama 'a na 'asetai ava'ai tutuyaga Vanuga 'Eba Velu'ui i na geuya wata ava'ai tugusaga 'a na 'iseni bega 'a na 'asetai naninidi sai'afoga i na souyedi.” ");
INSERT INTO yml_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu i vonedi i vo, Taunimi 'wa na 'isave'avinimi i na nunago tamu aitoi i na vekaliemi, fai tomotoga fuedi i na mai 'aku wagavayega igodi i na vo, Yau 'asa'aiana Keliso, Yaubada 'ana Venua'ivina,’ wata i na vo, Yaubada yana tutuya mogitana 'akonadi i sousouyeni.’ Siwe kebu bonadi 'wa na nogai wata kebu 'wa na yogo'wailidi. ");
INSERT INTO yml_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kebu 'wa na venuafouviga tutuyanina gavia wata vetalaga valadi 'wa na noganogaidi. Mogitana, naninidi nagami i na souyedi we'e fwayafwaya 'ana 'eba ve'a'ava bola.” ");
INSERT INTO yml_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wata Iesu i vonedi i vo, 'Eba veimea bwaikidi wata 'eba veimea bwaikidi 'ifwaidi taiadi i na vevetalaga, we'e 'awalawa wata 'awalawa 'ifwaidi taiadi i na vevetalaga. ");
INSERT INTO yml_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","'Awalawa fuedi 'waidie yoyoyo i na yueyue, loka wata viga sakoidi i na sousouyedi tomotoga fuedi 'waidie. 'Eba kololo fuedi 'wa na 'isedi we'e abame tugusa 'eba nua'ewa wata 'eba nuavogana i na souyedi. ");
INSERT INTO yml_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Naninidi 'awaie i na souyedi siwe nagami i na 'ivekokovimi. I na 'ive'avinimi i na nawemi 'eba miava'auta 'waidie wata i na yatomi vanuga yogona nagedie. Fai 'wa vetumagana 'waikuye begaidi i na nawemi 'wa na vonayavuga toveimea bwaikidi wata kini 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Siwe tutuyanina 'waineye 'ami fata Vala 'Atumaina faifaiku 'wa na lu'ivoneyeni 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kebu 'wa na venuafouviga wata kebu 'wa na nuanua 'wa na vo, Bani'odi ta na voneyedi vonayavuga 'waineye?’ ");
INSERT INTO yml_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tutuyanina 'waineye nuamageta a na velemi wata a na awave'ede'edemi bega 'ami gaviavo kebu 'adi fata yami vona i na tutuli wata ava'ai 'wa na voneyeniga kebu 'adi fata i na vo, 'Wa vevekali.’ ");
INSERT INTO yml_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Fai 'wa vetumaganeku begaidi tomotoga matatabudi wata yami 'aila'avo i na vedumwe'ai'aiemi. Bani'odi tamamiavo, inamiavo, taimiavo wata emiavo i na 'etogiluvemi bega 'ami gaviavo i na 'ive'avinimi we'e 'ifwaimi i na luvewafami. ");
INSERT INTO yml_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Siwe kebu tamu sai'afo 'wa na wafa-vagata. ");
INSERT INTO yml_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","'Wa na tovotovoi fa'alina kebu 'wa na baileku, i na nagoga mia 'atumaina wata miamia-vagaina 'wa na veluagai.” ");
INSERT INTO yml_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Wata Iesu i vonedi i vo, Bola 'wa na 'iseni tolugaviavo Ielusalema i na totovififineni nika 'wa na 'asetai sai'afoga i na leodi. ");
INSERT INTO yml_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tutuyanina tugusanina i na souyeni, egavo i na miamiani 'awalawa Iudia nageneye i lubwainedi i na dega i na nagoi 'oyeye, egavo Ielusalema 'waineye i na miamiani i na 'iaweni i na dega, we'e egavo 'akonadi i nagoi i yabayaba kebu wata i na vilaviladi Ielusalema. ");
INSERT INTO yml_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tutuyanina 'waineye Yaubada tomotoga fuedi i na vematavulogidi bega ava'ai basenadiotoga Yaubada yana Buki nageneye i kilumiga faifaina 'ana mogitana i na souyeni. ");
INSERT INTO yml_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","'Aiatanidi 'waidie toveinainage wata vauvau nuakalikalidi, fai kebu 'adi fata i na dega-matayo'o veviga bwaikina i na veluagai. Vita bwaikaotogina i na souyeni de'e 'awalawanina 'waineye wata Yaubada yana nuasako bwaikina i na souyeni tomotoganidi 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","'Adi gaviavo 'ifwaidi i na luvewafadi kefata 'waidiega we'e 'ifwaidi i na 'ive'avinidi i na nawedi mali 'eba veimea 'waidie. Mali tomotoga kumanidiavo kebu Diu yadi veimea toketokena 'wainega Ielusalema i na luvaia bei i na miamiani siwe tutuyanina Yaubada nuanuana, tomotoganidi yadi veimea i na 'a'ava. ");
INSERT INTO yml_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tutuyanina 'waineye tugusa 'adi 'isa 'eba kololo 'wa na 'isedi, inala weta'i wata 'ubwana 'waidie bega 'wa na 'asetai nani vitana sai'afoga i na souyeni. Tua bwaikina i na dodoga wata ta'wala bwaikina i na taina, yagina butu'aidi i na toke i na dududi tomia fwayafwaya matatabudi i na kololo-'afo'afo yadi nuanua i na ve'ale'usa. ");
INSERT INTO yml_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nani matatabuna toketokedi abame i na yue bega tomotoga i na 'asetai nani sakoina sai'afoga i na souyeni fwayefwayeye, begaidi yadi kololo 'waidiega i na mwea. ");
INSERT INTO yml_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tutuyanina 'waineye yau a vetomotogaotoga i na 'iseku a na mimai waowa 'wainega ma yaku toketokena wata ma magetaku mataududulina. ");
INSERT INTO yml_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tutuyanina 'wa na 'isedi naninidi i na sousouyedi, 'wa na tovoi 'wa na 'isalaka 'ami 'ita'ita'i 'akonadi i le'wale'wa.” ");
INSERT INTO yml_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesu i awatalatutula tomotoga 'waidie modawa yana sauluva 'wainega. I vo, 'Wa na nuanidi modawa wata welavi 'ifwaidi yadi sauluva. ");
INSERT INTO yml_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tutuyanina i na ididi ta 'asetai 'aisaya i veyafa. ");
INSERT INTO yml_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wata bani'odi, tutuyanina tugusanidi a voneyediga 'wa na 'isedi i na sousouyedi, 'wa na 'asetai sai'afoga Yaubada yana veimea i na souyeni 'waimie. ");
INSERT INTO yml_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A vona mogitana 'waimie, tutuya de'e 'ana tomotoga bola i na miamiani naninidi matatabuna i na souyedi. ");
INSERT INTO yml_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Abama wata fwayafwaya 'awaie i na 'a'ava, we'e yaku vona kebu tamu sai'afo i na 'a'ava i na 'eno-vagata. ");
INSERT INTO yml_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Taunimi 'wa na 'i'isave'avinimi i na nunago nani 'ifwaidi nuami i na 'ewadi 'wa na nuatavutavuna, bani'odi lusakali, ufa toketokedi wata nani 'ifwaidi 'adi venuafouviga. 'Ai'edi 'wa na nuatavutavunaga, yaku vila-vaitugana 'waineye a na veyawailovogimi. Nigola 'aisaya i sisimatayo'odi yawaidi i vevelovogidi, wata 'omi bani'odi tomia fwayafwaya matatabumi a na munegimi. ");
INSERT INTO yml_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tutuya matatabuna 'waidie 'wa na 'isa'isa, wata 'wa na vevelu'ui, nika 'wa na vetoketoke bega 'ami fata 'wa na dega naninidi vitadi i na souyediga 'waidie, mulieta 'wa na tovoi yau a vetomotogaotoga matakuye.” ");
INSERT INTO yml_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","'Aiatanidi 'waidie Iesu i veve Vanuga 'Eba Velu'ui nageneye we'e lavilavi i nunago 'Oya Olive bei lovana matatabuna i miamia. ");
INSERT INTO yml_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","'Awa'awaiogose tomotoga fuedi i nunagoi Vanuga 'Eba Velu'ui 'waineye nuanuadi Iesu yana vona i na vivinenegeni. ");
INSERT INTO yml_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Beledi Yalayalana Sakalina 'ana 'aiata i velilivana, sakalinina tamu 'ana wagava Uvi'agalatagona. ");
INSERT INTO yml_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo i nuanua bani'odi i na munega Iesu i na lugivai i na wafa. Fai tomotoga fuedi nuanuadi Iesu begaidi i kololoyedi. ");
INSERT INTO yml_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tutuyanina 'waineye Seitani i luku Iudasa Isakaliota yana nuanua 'waineye, taunina tamu Iesu yana tovetutuyamavo 'adi 'aila'a 12 'wainega. ");
INSERT INTO yml_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iudasa i nago tovelomu yadi to'edakumetavo wata Vanuga 'Eba Velu'ui 'ana tolumadu'aivo taiadi i veifufu bani'odi i na munega Iesu i na 'etogiluveni. ");
INSERT INTO yml_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ma yadi sosoana yana vona i nogai bega i vona'awaufaufa tutula i na veleni. ");
INSERT INTO yml_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iudasa yadi nuanua i awave'atumaieni i nago i lalauala 'eda'eda 'atumaina, bega 'ana fata givagivayega Iesu i na 'aniveleneni 'waidie nika tomotoga kebu i na 'asetai. ");
INSERT INTO yml_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sakalinina 'ana 'aiata i veluagai i lubwaineni sifi natudi i na nikedi i na velomuyedi Uvi'agalatagona 'ana lusakali faifaina. ");
INSERT INTO yml_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","'Aiatanina 'waineye Iesu Fita wata Ioni i vonedi i vo, 'Wa na nagoi 'ada'ada 'wa na 'idewadewa Uvi'agalatagona 'ana lusakali faifaina.” ");
INSERT INTO yml_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Fita ma iana Ioni i vo, Ava'aibe bei nuanuamu 'a na 'idewadewa?” ");
INSERT INTO yml_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Iesu i veifufu 'waidie i vo, Side bani'odi. 'Wa na nagoi Ielusalema, tamu tomogo ma yana 'eba koi ufa 'wa na veluagai. Vanuganina 'waineye i na nunagoga 'wa na yogo'waili i na luku we'e tonivanuga 'wa na velutolieni, 'wa na vo, Yama Tove i vo, Ava'aibe bei tutudaba yaku tovetutuyamavo taiadi 'a na 'ani Uvi'agalatagona faifaina?’ ");
INSERT INTO yml_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nika tonivanuga i na vagavaimi taiadi 'wa na laka, tamu tutudaba bwaikina i na vemi, 'akonadi i 'idewadewai faifaida. Bei 'ada'ada 'wa na 'idewadewa.” ");
INSERT INTO yml_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Fita wata Ioni Iesu i nogayeni, i 'a'ava i tauya i nagoi naninidi Iesu i voneyediga matatabuna i veluagadi nika bei Uvi'agalatagona 'ana sakali i 'idewadewa. ");
INSERT INTO yml_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","'Ani 'ana tutuya i le'wa Iesu ma yana tomata'aulelevo i maia i miabui i na 'ani. ");
INSERT INTO yml_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Iesu i vonedi i vo, Nuanuaku bwaikina nagami ma fuedeye ta na 'ani Uvi'agalatagona de'e faifaina mulieta veviga bwaikina a na veluagai. ");
INSERT INTO yml_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Siwe a na vonemi, kebu tamu tutuya wata Uvi'agalatagona a na 'ani, i na nagoga 'ana tugusa Yaubada yana 'Eba Veimea 'waineye Uvi'agalatagona 'ana mogitana i na souyeni, bei sakalinina bwaikina 'waineye a na 'ani.” ");
INSERT INTO yml_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mulieta Iesu oine ma vedina i 'ewai, Yaubada 'waineye i vekaiwa wata i vo, Oine de'e 'wa na 'ewai, 'aitamogana 'aitamogana 'wa na yemu. ");
INSERT INTO yml_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","A vona mogitana 'waimie, oine kebu wata a na yemuga i na nagoga 'ana tugusa Yaubada i na veveimea tomotoga matatabuna 'waidie.” ");
INSERT INTO yml_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wata Iesu 'ani'ani i 'ewai, i vekaiwa Yaubada 'waineye, mulieta i 'ivivia i 'a'avana yana tovetutuyamavo i veledi. I vonedi i vo, 'Ani'ani de'e 'asa'aiana tomogoku a tauyeni faifaimi. Tutuya fuedi side bani'odi 'wa na 'ani'aniedi, 'aku nuave'avina faifaina.” ");
INSERT INTO yml_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","'Ani i 'a'ava, wata bani'odi oine ma vedina i 'ewai i veledi i vonedi i vo, Oine de'e ma vedina 'asa'aiana dayagiku i na iloilolo faifaimi bega yaku wafanina 'wainega Yaubada yana Veakutagona 'Ivauna basenadi faifaina i vona'awaufaufa i na velamu 'waimie. ");
INSERT INTO yml_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Siwe a na vonemi, kumanina i na 'etogiluveku a na wafa taunina ma fueda ta 'ani'ani. ");
INSERT INTO yml_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yau a vetomotogaotoga a na wafaga fai Yaubada nuanuana, siwe 'aku to'etogiluva nuakalikalina, bola veviga bwaikaotogina i na veluagai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tovetutuyamavo Iesu yana vona i nogai 'aise'avadi i velutolitoli i vo, Aitoi kumanaga i na 'etogiluva?” ");
INSERT INTO yml_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sakalinina 'waineye tovetutuyamavo i ve'ikwayekwayega, 'waidiega aitoi mogitana bwaikaotogina. ");
INSERT INTO yml_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu i vonedi i vo, 'Akonadi 'wa 'asetai 'awalawa 'aitamogana 'aitamogana yadi kini yadi veimea toketokedi ve'isakololoyega tomotoga i veveimeyedi wata nuanuadi tomotoga i na subiadi i na vo, 'Omi yama to'edakumeta 'atumaimi.’ ");
INSERT INTO yml_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Siwe a na vonemi. 'Omi kebu bani'odi 'wa na munega. 'Ai'edi aitoi nuanuana i na vetomogo-bwaika, nagami taunina i na nuaobu bega i na vetomogo-'avo'avovo. We'e 'ai'edi aitoi nuanuana i na veto'edakumeta 'waimie, nagami i na vetofolova-maimaiga 'waimie. ");
INSERT INTO yml_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mali tomotoga yadi to'edakumetavo i mimiabuimo i lulukamata, yadi tofolovavo 'waidie 'ani'ani i na veleveledi i na 'ani'ani. We'e yau kebu bani'odi a da vevesauluvediga 'waimie, a vetofolova faifaimi. ");
INSERT INTO yml_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","'Omi yau taiadi vita ta veveluagadi siwe kebu 'wa da baileku. ");
INSERT INTO yml_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Tamaku i venua'ivineku bega tomotoga a na veveimeyedi, wata bani'odi veimea a na velemi bega bola yaku 'Eba Veimea 'waineye taiadi ta na 'ani'ani. Wata bei 'wa na miabui didiga 'ai'aiwabudi 'waidie bega waumanidi 12 tubuda bwaikina Isileli 'wainega i souyediga i na vonayavuga 'waimie.” ");
INSERT INTO yml_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Wata Iesu i vo, Saimoni a na vonemu. Seitani Yaubada i velu'uieni, nuanuana i na tauyeni 'omi 'aitamogana 'aitamogana i na silubumi vita 'waidiega bega 'ifwaimi 'wa na vedumwe'ai'aieku, ma'itufa 'wa na vetutuyameni. ");
INSERT INTO yml_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Siwe Saimoni faifaimu a velu'ui bega yamu vetumagana kebu i na mwea. 'Awaie 'u na baileku siwe tutuyanina 'u na vilamu 'waikuye emwavo yadi vetumagana 'u na kiavetoketokedi.” ");
INSERT INTO yml_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Fita i vo, 'Auvea, 'ai'edi i na 'ive'avinimu i na nawemu vanuga yogona 'waineye wata bei i na luvewafamuga, yau wata taiadi.” ");
INSERT INTO yml_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu i vo, Fita, a na vonemu. 'Ako lovane bola kamukamu kebu i na kwagega nagami tutuya 'aitonu 'u na bavusebeku.” ");
INSERT INTO yml_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wata Iesu i vonedi i vo, Basenadi a vetunemi 'wa nagoi 'wa lau'age nani 'ifwaidi a talabodedi, bani'odi mani, venuana wata 'ageyafayafa. We'e naninidi yami mia faifaina 'wa ve'ale'usa 'alo kebu?” I vo, E'e, kebu tamu nani 'wainega 'a da ve'ale'usa.” ");
INSERT INTO yml_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Wata Iesu i vo, 'Asiau tulina, fai ava'ai basenadiotoga i kilumi Yaubada yana Buki nageneye faifaiku i lubwaineni 'ana mogitana i na souyeni. Vonanina i vo, Tomotoga i vo 'ako taunina tamu tosakona.’ Fai vonanina 'ana mogitana i sousouyeni, bega egavo ma yadi mani i na 'ewadi, egavo ma yadi venuana i na 'ewadi wata egavo kebu yadi kefataga 'adi talauma i na vekimwaneyedi bega mani i na 'ewadi kefata i na kimwane.” ");
INSERT INTO yml_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tovetutuyamavo yana vona 'ana nuanua kebu i da 'asetaiga begaidi i voneni i vo, 'Auvea, kefata 'ailuga side.” Iesu i vo, 'Asa'aiana, kebu faifaina 'wa na veifufu.” ");
INSERT INTO yml_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu i veifufu'a'ava, mulieta ma yana tovetutuyamavo i tovoi i nagoi 'Oya Olive yana sauluva tutuya fuedi bani'odi. ");
INSERT INTO yml_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tutuyanina i le'wai Iesu i vonedi i vo, 'Wa na vevelu'ui bega tutuyanina Seitani i na vetalaimimilimi kebu 'wa na sakona.” ");
INSERT INTO yml_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","I 'iawedi sai'afo i vaganago bani'odi 'atagi 'ana vemanawe 'waineye 'agena i vetufano'uyedi i velu'ui. ");
INSERT INTO yml_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","I vo, Tamaku, 'Ai'edi yamu nuanua i na lubwaineniga vita de'e wata wafa 'u da 'ewadi 'waikuyega. Siwe 'asa'aiana de'e kebu yau yaku nuanuaga, 'omu yamu nuanua bega a na vematayakeyakenimo.” ");
INSERT INTO yml_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nika tamu anelose abamayega i souyeni i kiavetoketokei. ");
INSERT INTO yml_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tutuyanina i vevelu'ui nuafouna i veviga bwaikaotogina begaidi i ibala, 'ana ibala yana ilolo fwayefwayeye bani'odi dayaga. ");
INSERT INTO yml_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yana velu'ui i 'a'ava, Iesu i tovoi i vilai i nago yana tovetutuyamavo 'waidie, i 'isedi 'akonadi i 'eno-mataiva fai i nuavita bwaikina. ");
INSERT INTO yml_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","I luvagonidi i vonedi i vo, Awale 'wa 'eno'enovi? 'Wa tovoi 'wa na vevelu'ui bega tutuyanina Seitani i na vetalaimimilimi kebu 'wa na sakona.” ");
INSERT INTO yml_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bola Iesu i veveifufu yana tovetutuyamavo 'waidie, nika 'aila'a i le'wai Iudasa taiadi, kumanina tamu Iesu yana tovetutuyama. 'Aila'anidi i 'edakumesedi i maia i le'wai i nago nuanuana Iesu i na 'avalamaigi. ");
INSERT INTO yml_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","We'e Iesu i vo, Iudasa awale? Yau a vetomotogaotoga 'u 'e'etogiluveku 'avalamaiga 'wainega?” ");
INSERT INTO yml_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tutuyanina tovetutuyamavo i 'isedi 'aila'a nuanuadi Iesu i na 'ive'avini i vo, 'Auvea, bani'odi? Yama kefata 'waidiega 'a na nikedi?” ");
INSERT INTO yml_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tamu iadi yana kefata i yo'ei tovelomu bwaikina yana tofolova igodi i da nikei, taniga'avana 'ana 'atagiega i tutuomuya. ");
INSERT INTO yml_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Siwe Iesu i talabodedi i vo, 'Asa'aiana 'wa baileni, kebu bani'odi 'wa na munega.” Nika tomogonina tanigana i 'abitonovi i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tomotoganidi i maia Iesu 'ana 'ive'avina faifaina side 'aila'anidi. Tovelomu yadi to'edakumetavo, Vanuga 'Eba Velu'ui 'ana tolumadu'aivo wata me Diu yadi to'edakumetavo 'au'auveadi. Iesu i vonedi i vo, Yau 'wa da vo to'ainike bega 'wa maia ma yami kefata wata fulumai 'aku 'ive'avina faifaina. ");
INSERT INTO yml_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","'Aiata 'aitamogana 'aitamogana ma fuedeye ta mimiava'auta Vanuga 'Eba Velu'ui nageneye siwe kebu 'wa da 'ive'aviniku. Siwe 'asiau Seitani i veveimea, dudubala i vetoketoke, 'omi yami tutuya.” ");
INSERT INTO yml_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","'Aila'anidi Iesu i 'ive'avini i naweni i lukuveni tovelomu bwaikina yana vanuge, we'e Fita i yogo'waila siwe 'ani'ieogose kebu lilivadie. ");
INSERT INTO yml_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Vanuganina 'waineye tanotanoge 'ai i levai, Fita i mai bei tomotoga 'ifwaidi taiadi i vevevala. ");
INSERT INTO yml_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tamu tofolova vevinena Fita i 'iseni i vevevala nika 'ai magetanega i 'isadewai i vona i vo, Side tomogonina tamu Iesu iana.” ");
INSERT INTO yml_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Siwe Fita i ve'ewa i vo, Aigodi yau kebu a da 'asetaiga.” ");
INSERT INTO yml_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mulieta tamu tomogo i 'iseni i vo, 'Omu wata tamu Iesu iana.” Siwe Fita i vo, 'U vekali, yau kebu, tuliku.” ");
INSERT INTO yml_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","'Awasasa 'aitamogana i 'a'ava, mulieta tamu tomogo i 'alavulewai i vo, Vona mogitana, tomogonina tamu Iesu iana, 'adi 'ailuga i maia 'awalawa Galili 'wainega.” ");
INSERT INTO yml_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nika Fita i tutula i vo, We'e aigodi, yamu vonanina 'ana nuanua kebu tamu sai'afo a da 'asetaiga.” Bola Fita i veve'ewa nika kamukamu i kwage. ");
INSERT INTO yml_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Iesu i sivilai i 'isanago Fita 'waineye nika Fita i nuani 'Auvea yana vona i voneni i vo, 'Ako lovane bola kamukamu kebu i na kwagega nagami tutuya 'aitonu 'u na bavusebeku.” ");
INSERT INTO yml_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Fita vonanina i nuani mogitana, nika i souyeni i nago 'atamane i taibwaubwau. ");
INSERT INTO yml_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tomotoganidi Iesu i 'i'isave'aviniga i sisidibidibieni wata i nikenikei. ");
INSERT INTO yml_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Matana kalekoyega i umai i nikei i voneni i vo, 'Omu igodi tolu'ivona 'u da vonema, 'asiauotoga aitoi i nikemu?” ");
INSERT INTO yml_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wata nani fuedi 'waidiega i awavesakoyeni wata i yagaia. ");
INSERT INTO yml_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","I 'atai 'awa'awaiogose me Diu yadi Kanisela i va'auta bega Iesu i mieni matadie, 'ifwaidi Diu yadi to'edakumetavo 'au'auveadi, tovelomu yadi to'edakumetavo wata ve'etoboda 'adi tovevo. ");
INSERT INTO yml_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","To'edakumetanidi Iesu i velutolieni i vo, Nuanuama 'a na 'asetai, 'omu mogitana Keliso Yaubada 'ana Venua'ivina 'alo kebu?” Iesu yadi velutoli i tutuli i vo, 'Ai'edi a na vonemi, siwe bonaku kebu 'wa na vetumaganeni. ");
INSERT INTO yml_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Wata 'ai'edi tamu ava'ai faifaina a na velutoliemi, kebu 'wa na tutuliga. ");
INSERT INTO yml_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","'Asiau de'e 'wainega i na nagoga yau a vetomotogaotoga ma yaku veimea a na miabui Yaubada Toketokeotogina 'ana 'atagie.” ");
INSERT INTO yml_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nika matatabudi i vo, Vetuma, 'omu Yaubada Natuna?” Iesu i vo, 'Wa vonaga, 'asa'aiana bani'odi.” ");
INSERT INTO yml_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tomotoganidi Iesu bonana i nogai i vo, 'Akonadi taunida yana vona-uvi'agala Yaubada 'waineye ta nogai. Kebu wata aitoi i na lulu'ivona 'waideye yana sauluva sakoina faifaina.” ");
INSERT INTO yml_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Me Diu yadi Kanisela i veifufu'a'ava, matatabudi i tovoi Iesu i vagavaia i naweni Loma kabemani yadi toveimea Failato 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bei i lu'ivona-vekavekali Iesu faifaina i vo, Tomogo de'e tomotoga i talabodebodedi i vo, Kebu 'wa na takesi me Loma kabemani 'waidie,’ wata taunina i veveifufu i vo, Yau Keliso, yami Kini.’” ");
INSERT INTO yml_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Failato yadi vonanina i nogai bega Iesu i velutolieni i vo, 'Omu mogitana me Diu yadi kini?” Iesu i vo, 'U vonaga, 'asa'aiana bani'odi.” ");
INSERT INTO yml_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Failato i vona tovelomu yadi to'edakumetavo wata 'aila'a 'waidie i vo, Tomogo de'e kebu tamu yana sakona a da veluagai bega a na veimea i na wafa.” ");
INSERT INTO yml_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nika i kwayega-'afo'afo i vo, Yana ve 'wainega tomotoga fuedi i daba, i velamu Galiliega 'awalawa matatabuna Iudia nageneye, i maiga 'ana tugusa Ielusalema.” ");
INSERT INTO yml_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tutuyanina Failato i nogai Iesu yana folova i velamu Galili 'waineye begaidi i velutoliedi i vo, Tomogo de'e Galiliega i mai?” ");
INSERT INTO yml_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tutuyanina 'waineye Galili 'ana toveimea i miamia Ielusalema 'ana wagava Kini Elodi, begaidi Failato i vonedi Iesu i na vagavaia i na naweni 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tutuyanina Iesu i le'weni Elodi 'waineye i sosoana-'afo'afo, fai tutuya manamanawena vala'avana i noganogaimo, nuanuana Iesu 'eba nuavogana wata 'eba nua'ewa i na 'idewai a da 'iseni. ");
INSERT INTO yml_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Begaidi Elodi velutoli fuedi Iesu i veleni, siwe kebu tamu i da tutulidiga. ");
INSERT INTO yml_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","We'e tovelomu yadi to'edakumetavo ve'etoboda 'adi tovevo taiadi i tovotovoiga Elodi lilivaneye, bonadi bwaikinega i lu'ivona-vekavekali Iesu faifaina. ");
INSERT INTO yml_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Elodi ma yana tolugaviavo Iesu i sidibidibieni wata i yagaia, mulieta toveimea 'adi vaigavuyega i 'ivivigavuya wata i vevilai i nago Failato 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Basenadi Elodi wata Failato ma yadi nuasako ma iana i ve'idi'idi, siwe 'aiatanina 'waineye i veiana. ");
INSERT INTO yml_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Failato to'edakumetavo i goleva'augidi, tovelomu yadi to'edakumetavo, tomotoga 'adi to'edakumetavo wata tomotoga fuedi taiadi i vonedi i vo, Ava'ai faifaina tomogo de'e 'wa vevitaiga 'wa mieni 'waikuye, 'wa vo, Yana ve wata yana 'edakumeta 'wainega tomotoga fuedi i vevekaliedi bega i daba.’ Igodi yana sakonanidi 'wa lu'ivoneyediga 'waikuye faifaidi a velutolieni matamie siwe kebu tamu yana sakona a da veluagai. ");
INSERT INTO yml_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wata bani'odi kebu tamu yana sakona Elodi i da veluagai bega i vevilai i mai 'waikuye. Fai kebu tamu yana sakona, begaidi kebu i da lubwaineni i na wafa. ");
INSERT INTO yml_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","'Asa'aiana a na veimea i na fitalimo, i na 'a'ava a na 'etoyavuya.” ");
INSERT INTO yml_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Malamala 'aitamogana 'aitamogana me Diu i sakasakali Uvi'agalatagona faifaina. Tutuyanina 'waidie me Diu fuedi tamu iadi yogoyogonina i vevenua'ivineni bega kabemani i 'e'etoyavuya vanuga yogona 'wainega. ");
INSERT INTO yml_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nika tomotoga fuedi bonadi bwaikinega i 'alavegagali i vo, Iesu 'u na luvewafai, we'e Balaba 'u na 'etoyavuya.” ");
INSERT INTO yml_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tomogonina toluvewafa basenadi Loma kabemani taiadi i vetalaga Ielusalema nageneye bega i yatoi vanuga yogona nageneye. ");
INSERT INTO yml_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Failato nuanuana Iesu i na 'etoyavuya begaidi i kwayegedi. ");
INSERT INTO yml_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Siwe tomotoga i kwayega-'afo'afo i vo, 'U tutufwaseni, 'U tutufwaseni 'ai lagalagana 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wata Failato yana vona 'ana vetonu tomotoga i vonedi i vo, Ava'ai yana sakonaga? Bega i na wafaga kebu i da lubwaineni, fai kebu tamu yana sakona a da veluagai. A na veimea i na fitalimo, i na 'a'ava a na 'etoyavuya.” ");
INSERT INTO yml_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nika i toke i vegolegole i vo, 'U tutufwaseni. 'U tutufwaseni 'ai lagalagana 'waineye.” Nika yadi vona i tokega, Failato i ve'wada. ");
INSERT INTO yml_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bega ava'ai tomotoga yadi nuanua, Failato Iesu i tauyeni i na wafa. ");
INSERT INTO yml_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","We'e i veimea Balaba kumanina tomotoga nuanuadi, i na 'etoyavuya vanuga yogona 'wainega. Tomogonina toluvewafa basenadi Loma kabemani taiadi i vetalaga, ma'itufa Iesu i 'aniveleneni 'waidie, bega ava'ai nuanuadi, i na 'idewai 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bega tomotoga Iesu i naweni i na tutufwaseni. I nunagoi 'edeye tamu tomogo Sailini 'ana wagava Saimoni i veluagai, kwedayega i tauya i mimai Ielusalema. Tolugaviavo tomogonina i lukakadeni Iesu 'ana 'ai lagalagana i veevai, Iesu mulineye i nago. ");
INSERT INTO yml_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wata tomotoga fuedi i yogo'waila, tomotoganidi 'waidiega 'ifwaidi vevine i vevemogai Iesu faifaina. ");
INSERT INTO yml_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesu i sivilai i 'isedi i vonedi i vo, Me Ielusalema vevine, kebu 'wa na vemogai faifaiku. I lubwainemi taunimi wata natumiavo faifaidi 'wa da vemogai. ");
INSERT INTO yml_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","'Awaie tomotoga i na vo, Egavo kakalidi safailina 'waidie, fai kebu i da venatuna wata i da vesusuga, 'eba sosoana 'waidie vitanidi kebu i na veluagadi, we'e egavo ma natudiavo vita bwaikaotogina i na veluagai.’ ");
INSERT INTO yml_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wata tutuyanina 'waineye tomotoga i na vona 'oya 'waidie i na vo, 'Wa 'anibai-matayo'omi 'wa tavunima nika kebu 'a na veveviga.’ ");
INSERT INTO yml_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yau 'wa da vo welavi yauyauvina siwe i nike-maimaigiku, we'e 'omi bani'odi welavi bwavuna, mogitana 'awaie vita bwaikaotogina 'wa na veluagai.” ");
INSERT INTO yml_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tutuyanina tolugaviavo tosakona 'adi 'ailuga i nawedi Iesu taiadi i na luvewafadi. ");
INSERT INTO yml_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","I nagoi i le'wa tamu 'awalawa 'ana wagava 'Unu'unu 'waineye, bei Iesu i tutufwaseni 'ai lagalagana 'waineye. Wata tosakonanidi i tutufwasedi 'ai lagalagana 'waidie, tamu Iesu 'ana 'atagiega, tamu 'ana wamayega. ");
INSERT INTO yml_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mulieta Iesu i velu'ui i vo, Tamaku, tomotoganidi de'e yadi sakona 'u na nuatavunidi, ava'ai i 'i'idewaiga 'waikuye kebu i da 'asetaiga.” Tolugaviavo nuanuadi Iesu 'ana talauma i na veusedi begaidi tamu 'wava i 'waveni bani'odi kate. 'Ai'edi aitoi i na kumetaga, ava'ai talaumaga nuanuana i na 'ewai. ");
INSERT INTO yml_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tomotoga fuedi i tovotovoi i 'ise'iseni, we'e me Diu yadi to'edakumetavo Iesu i sidibidibieni i vo, Tomotoga 'ifwaidi i 'ita'ita'iedi, 'ai'edi mogitana Keliso, Yaubada 'ana Venua'ivina, i lubwaineni taunina i na 'ita'ita'ieni.” ");
INSERT INTO yml_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wata bani'odi tolugaviavo i sidibidibieni, oine yuyuna i mieni Iesu 'waineye i 'iyoyoeni. ");
INSERT INTO yml_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Wata i vo, 'Ai'edi 'omu me Diu yadi kini, nika taunimu 'u na 'ita'ita'iemu, 'u na obuma 'ai lagalagana 'wainega.” ");
INSERT INTO yml_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","'Ana 'ai lagalagana tabwaneye tamu vona i kilumiga i tutufwaseni. Vonanina i kilumiga side bani'odi. TOMOGO DE'E ME DIU YADI KINI. ");
INSERT INTO yml_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tamu tosakona 'ai lagalagana 'waineye Iesu i yagaia i vo, I vonaga 'omu Keliso, Yaubada 'ana venua'ivina. Vetuma taunimu 'u da 'ita'ita'iemu wata 'ima taiadi.” ");
INSERT INTO yml_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","We'e iana tamu tosakona i talaboda i vo, Awale? Sai'afoga 'ada 'aitonu ta na wafa. I lubwaineni Yaubada 'u da ve'ililibuyeni. ");
INSERT INTO yml_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","'Ada 'ailuga i lubwaineda ta na wafa yada sakona 'adi tutula, we'e Iesu kebu tamu yana sakonaga.” ");
INSERT INTO yml_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wata i vona Iesu 'waineye i vo, Iesu, tutuyanina 'u na ve-Kini ma yamu veimea 'u na mai, 'u da nuanuaniku.” ");
INSERT INTO yml_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nika Iesu i voneni i vo, A vona mogitana 'waimuye, 'asiau 'ada 'ailuga ta na luku Faladaisi, 'eba mia 'atumaina wata sosoana-vagata 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","'Aiata 'ana utukamwana 'waineye fwayafwaya matatabuna i dudubali, i nagoga 'ana tugusa lavilavie 3 kiloki i magetai. ");
INSERT INTO yml_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Inala yana mageta i 'ailove. Vanuga 'Eba Velu'ui nageneye tamu saiboda kaleko badubaduna 'wainega, Yaubada yana tutudaba tabutabuotogina i sisibodai. Tutuyanina Iesu yawaina i 'a'avaga, saibodanina i 'anilabu'alugedi. ");
INSERT INTO yml_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iesu bonana bwaikinega i vegole i vo, Tamaku, 'anu'anunuku a tauyeni 'waimuye.” I vona'a'ava nika yawaina i 'awatagoni. ");
INSERT INTO yml_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tutuyanina tolugaviavo 'adi to'edakumeta naninidi i souyediga i 'isedi, Yaubada i subiai i vo, Vona mogitana, tomogonina yana sauluva tonovina.” ");
INSERT INTO yml_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tomotoganidi i maiaga Iesu 'ana tutufwatagi 'waineye, yana wafa i 'iseni ma yadi nuavita i viladi i nagoi yadi vanuge. ");
INSERT INTO yml_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","We'e Iesu enavo, 'ifwaidi vevine taiadi basenadi Iesu i yogo'waili i maia Galili 'wainega, 'ani'ieyega i tovoi i 'i'isanago. ");
INSERT INTO yml_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ielusalema 'waineye tamu tomogo i miamia 'ana wagava Iosefa, 'ana tuvada Alimadia, 'awalawa Iudia nageneye. Taunina tomogo 'atumaina yana sauluva tonovidi wata i lulukamata Yaubada yana veimea yana mai fwayefwayeye faifaina. Iosefa tamu me Diu yadi Kanisela siwe tutuyanina kaniselanidi i veimea Iesu i na wafa, yadi nuanua kebu i da awave'atumaieni. ");
INSERT INTO yml_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tutuyanina Iosefa i 'asetai Iesu yawaina i 'a'ava, i nago Failato 'waineye i velu'ui i vo, Nuanuaku Iesu tomogona a na ta'ia a na ve'ufai.” ");
INSERT INTO yml_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Failato i tauyeni bega i nago Iesu tomogona i ta'ia i fania kaleko 'avu'avunega. Mulieta i nago i ve'ufai taumata 'ivauna nageneye. Taumatanina basenadi i ala-vagaseni matumatu 'waineye, kebu tamu aitoi bei i da ve'ufai. ");
INSERT INTO yml_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iesu i ve'ufaiga Falaide lavilavie, me Diu yadi 'Aiata Veawai sai'afoga i na velamu. ");
INSERT INTO yml_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vevinenidi Iesu i yogo'waili i maia Galiliega Iosefa taiadi i nagoi taumaseye, matadie Iesu i ve'ufai. ");
INSERT INTO yml_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Vevinenidi i viladi i nagoi yadi vanuge bunama magaidi 'atumaidi i 'idewadewadi, Iesu tomogona 'ana bunama faifaina. Tutuyanina i 'idewadewa'a'ava, nika inala i simwanuya yadi 'Aiata Veawai i velamu, bega i veawai me Diu yadi veimea bani'odi. ");
INSERT INTO yml_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Me Diu yadi 'Aiata Veawai i 'a'ava, Tafalolo 'awa'awaiogose vevine bunama i 'idewadewadiga i 'ewadi i nagoi taumaseye. ");
INSERT INTO yml_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tutuyanina i le'wai kileu i 'iseni taumata 'awana i sibodaiga, 'akonadi i sibaleni. ");
INSERT INTO yml_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Matatabudi i luku taumata nageneye 'Auvea Iesu tomogona i 'isa'avai. ");
INSERT INTO yml_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","I tovotovoi i vevenua'ivina nika tomotoga 'adi 'ailuga 'adi talauma mataududulidi i souyedi 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Vevinenidi i kololo-'afo'afo nika i lumata'afufu 'adi 'ailuga 'agedie. Tomotoganidi vevine i velutoliedi i vo, 'Omi 'wa maia taumaseye aitoi faifaina 'wa lalauala? Kumanina 'wa lulualeniga ma yawaina i miamia. ");
INSERT INTO yml_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Iesu de'e bei kebu i da miamiaga, 'akonadi wafayega i tovoi. 'Wa na nuani yana vona basenadi Galili 'waineye i vonemi i vo, Yau a vetomotogaotoga i na 'aniveleneku tosakona 'waidie, bega i na tutufwaseku 'ai lagalagana 'waineye mulieta 'aiata 'ana vetonu 'waineye Yaubada i na sivetovoi-vaituganiku wafayega.’” ");
INSERT INTO yml_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Nika veifufunina basenadi Iesu i voneyeniga vevine i nuani, bega i viladi i nagoi Ielusalema, naninidi matatabuna i lu'ivoneyedi tomata'aulele 11 wata 'ifwaidi tovetutuyamavo 'waidie. ");
INSERT INTO yml_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Vevinenidi i nagoi taumata 'waineye 'adi wagava side. Meli 'atamana Magidala 'wainega, Ioana, Meli Iemesa inana wata 'ifwaidi vevine. ");
INSERT INTO yml_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Vevinenidi yadi lu'ivona Iesu faifaina kebu i da awavemogitaneniga, 'ana nogaya 'waidie 'wa da vo 'wava'wavadi yadi veifufu. ");
INSERT INTO yml_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","We'e Fita i tovoi i lilide i nago taumaseye, i lukemula kebu tamu ava'ai i da 'iseniga, Iesu 'ana baniuma'ava i 'iseni. Bega i vilai i nago vanuge, i vevenua'ivina nika yana nuanua i ve'ale'usa. ");
INSERT INTO yml_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","'Aiatanina 'waineye Iesu i tovoi wafayega, tovetutuyamavo 'adi 'ailuga Ielusalemayega i tauya i nunagoi tamu 'atamana 'ana wagava Emeusa 'waineye, 'edanina 'ana nago bani'odi 'awasasa 'ailuga. ");
INSERT INTO yml_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","15","I nunagoi 'edeye ma iana i veveifufu-'eda'eda naninidi i souyediga faifaidi, nika Iesu tauniotogina mulidie i mai i 'ubwasadi. ");
INSERT INTO yml_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tomotoganidi Iesu i 'iseni, siwe voke bani'odi i munega kebu i da 'isa'inanaiga. ");
INSERT INTO yml_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu i velutoliedi i vo, Ava'ai faifaina 'wa veveifufu-'eda'eda?” Nika i tovoi maigidi 'ana 'isa nuavita. ");
INSERT INTO yml_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tamu iana 'ana wagava Kaliofasa i voneni i vo, Me Ielusalema matatabudi i 'asetai ava'ai i souyediga 'aiatanidi 'waidie, voke 'omu 'aiseotogimu bavubavumu.” ");
INSERT INTO yml_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wata Iesu i vo, Ava'ai naniga?” Kaliofasa i vo, Iesu, tomogo Nasaledi faifaina. Tomogonina tamu Yaubada yana tolu'ivona, tove ma yana 'aseta, 'eba nuavogana wata 'eba nua'ewa i 'idewadi, begaidi Yaubada wata tomotoga i awave'atumaieni. ");
INSERT INTO yml_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tovelomu yadi to'edakumetavo wata yada to'edakumetavo i 'aniveleneni Loma kabemani 'waidie, i veimea i na wafa mulieta i tutufwaseni 'ai lagalagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","'Ima 'a nuani kumanina Yaubada 'ana Venua'ivina i mai me Isileli i na 'ita'ita'ieda. Yana wafa 'wainega i maiga 'asiau 'aiata 'ana vetonu ta veluagai. ");
INSERT INTO yml_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","We'e 'asiau 'awa'awaiogose 'ifwaidi vevine 'ama 'aila'a 'wainega, i nagoi taumaseye Iesu tomogona i 'isa'avai. Tutuyanina i viladi i mai i lu'ivona 'waimeye i vo, Mogitana anelose i souyedi 'waimeye i vonema Iesu 'akonadi i tovoi-vaitugana.’ Yawaima i lovoga wata nuama i voganidi yadi vona faifaina. ");
INSERT INTO yml_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Begaidi 'ifwaidi emavo i nagoi taumaseye ava'ai vevinenidi i voneyeniga i veluagai, Iesu tomogona i 'isa'avai.” ");
INSERT INTO yml_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iesu tomotoganidi 'adi 'ailuga i vonedi i vo, 'Omi bavubavumi. Basenadiotoga Yaubada yana tolu'ivonavo nani fuedi i kiluma-vagasedi Keliso faifaina siwe kebu 'wa da vetumagana. ");
INSERT INTO yml_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","I lubwaineni Yaubada 'ana Venua'ivina veviganidi i veluagadi, mulieta i na luku abame, yana 'eba mia 'ai'aiwabuna 'waineye.” ");
INSERT INTO yml_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mulieta Iesu taunina faifaina i kiavemageta Yaubada yana Buki 'wainega. Vonanidi i veifufuyediga Mosese wata tolu'ivonavo 'adi kilukiluma 'waidiega. ");
INSERT INTO yml_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","'Akonadi i maia Emeusa lilivaneye 'adi 'ailuga i 'asetai Iesu 'ako i na vaganago tamu 'atamana 'waineye begaidi i talabodeni i vo, Side bei ta na 'eno, fai 'akonadi i lovalovani.” Bega ma fuedie i luku vanuge. ");
INSERT INTO yml_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mulieta i miabui i na 'ani Iesu 'ani'ani i 'ewai, i vekaiwa Yaubada 'waineye i 'ivivia i veledi. ");
INSERT INTO yml_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nika bei nuadi i magetai i 'isa'inanai, siwe 'waidiega i 'awafa'wani. ");
INSERT INTO yml_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tutuyanina Iesu i 'awafa'wani 'adi 'ailuga i veifufu i vo, Iaku vona mogitana, tutuyanina 'edeye i kikiavemageta Yaubada yana Buki 'wainega ma 'ana vebae 'waideye 'wa da vo nuafouda i da 'awadadedi.” ");
INSERT INTO yml_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ma iana i veifufu i 'a'ava nika i tovoi i viladi i nagoi Ielusalema, bei tovetutuyamavo 11 i veluagadi wata 'ifwaidi ediavo taiadi. ");
INSERT INTO yml_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tutuyanina i le'wa i nogai ediavo i veifufu i vo, Vona mogitana, 'Auvea i tovoi-vaitugana, Saimoni i 'iseni.” ");
INSERT INTO yml_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mulieta 'adi 'ailuga i veifufu nani matatabuna faifaidi. Yana souyagi 'edeye, taiadi i veifufu'eda'eda, wata 'ani 'waineye 'ani'ani i 'ivivia nika bei i 'isa'inanai. ");
INSERT INTO yml_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kaliofasa ma iana bola i veveifufu ediavo 'waidie nika Iesu tauniotogina i souyeni 'awasasadie. I vonedi i vo, Kebu 'wa na kolologa, ma yami sosoana 'wa na miamia.” ");
INSERT INTO yml_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Siwe i kololo-'afo'afo i 'iseni i vo 'ako yalua. ");
INSERT INTO yml_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wata Iesu i vonedi i vo, Awale 'wa kolokololo wata 'wa vevenuanaluga? ");
INSERT INTO yml_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","'Wa 'isamaiedi 'aku kini'ona nimakuye wata 'agekuye, wata 'wa na 'isa-dewaku yau mogitana aitoi. 'Wa na 'abitonoviku bega 'wa na 'asetaku yau kebu yaluaga, yalua kebu ma tomogona 'ana wagava kaukau.” ");
INSERT INTO yml_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","I vona'a'ava mulieta nimana wata 'agena i vedi. ");
INSERT INTO yml_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","I sosoana mogitana siwe kebu i da vetumagana fai bola ma yadi nuavogana. Begaidi Iesu i velutoliedi i vo, 'Ani'ani 'aivia 'waimie?” ");
INSERT INTO yml_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Bega igana kabukabunina i 'ewai i veleni matadie i 'ani. ");
INSERT INTO yml_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mulieta i vonedi i vo, 'Wa na nuani basenadi taiadi ta miamia a vonemi a vo, I lubwaineni nani matatabuna faifaiku i kilumidiga Buki Same, veimeanidi i mai Mosese 'wainega wata tolu'ivona yadi ve 'ana mogitana i na souyeni.’” ");
INSERT INTO yml_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Iesu yadi nuanua i kiavemagetadi bega nani fuedi Yaubada yana Buki nageneye i 'asetadi, nika bei nuadi i magetadi. ");
INSERT INTO yml_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","I vonedi i vo, Vonanidi tamu side bani'odi. Keliso, Yaubada 'ana Venua'ivina veviga bwaikina i na veluagai, i na wafa, mulieta 'aiata 'ana vetonu 'waineye Yaubada i na sivetovoia. ");
INSERT INTO yml_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","We'e Keliso valana i na souyeni Ielusalema 'wainega, i na nago tomotoga matatabudi 'aila'a tulina tulina 'waidie. Valanina side bani'odi. Egavo Keliso 'ana wagavayega i na nuaviladi sakona 'wainega Yaubada i na nuatavunidi. ");
INSERT INTO yml_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Naninidi basenadiotoga i kilumidiga Yaubada yana Buki nageneye, 'omi 'waimie i souyedi. ");
INSERT INTO yml_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yau 'ami To'aivaita a na vetunei 'waimie, To'aivaitanina faifaina basenadi Tamaku i vona'awaufaufa i na velemi. Siwe kebu 'wa na tauya-matayo'o, Ielusalema bei 'wa na lulukamata, nagami toketokena i na mai Yaubada 'wainega i na agemi.” ");
INSERT INTO yml_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","51","Iesu yana veifufu i 'a'ava, yana tovetutuyamavo i 'edakumesedi Ielusalemayega i nagoi Bedani. Bei nimana i silakai i vovona-nuakalikaliedi nika Yaubada i vagavaia i naweni abame. ");
INSERT INTO yml_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iesu i tauya i nunago yana tovetutuyamavo i 'odu i subiai, sosoana mogitana 'wainega i viladi i nago Ielusalema. ");
INSERT INTO yml_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tutuya matatabuna bei i miamia Vanuga 'Eba Velu'ui nageneye Yaubada 'waineye i vevekaiwa. 'Asa'aiana bani'odi, Luke ");
INSERT INTO yml_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Basenadiotoga Yaubada fwayafwaya wata abama bola kebu i da 'idewadiga, nagamidiotoga yana Tosivemageta i miamia. Tosivemagetanina Yaubada yana nuanua matatabuna 'ana tolu'ivona. Taunina Yaubada 'ana labilabina wata taunina 'asa'aiana Yaubada. ");
INSERT INTO yml_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tutuya 'eba velamunina 'waineye Tosivemageta Yaubada taiadi i miamia. ");
INSERT INTO yml_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yaubada yana nuanua 'wainega Tosivemageta nani matatabuna i 'idewadi abame wata fwayefwayeye, kebu tamu nani taunina i da souya-maimaigeni. ");
INSERT INTO yml_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Taunina miamia-vagaina yawaida lamuna wata 'wainega mia 'ivauna wata 'atumaina ta veluagai, bani'odi mageta 'waideye. ");
INSERT INTO yml_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yaubada yana Tosivemageta nani matatabuna dududubalidi i magemagesedi, we'e dudubalanina kebu 'ana fata i na vetoketoke magetanina i na luve'weuya. ");
INSERT INTO yml_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Yaubada nuanuana tomotoga magetanina i na 'asetai, begaidi yana tomata'aulele i vetunei bega i na lu'ivona 'waidie. Tomogonina 'ana wagava Ioni Tobafitaiso, i mai i lulu'ivona magetanina faifaina, bega tomotoga i na vetumagana. ");
INSERT INTO yml_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ioni kebu taunina mageta, i vetolu'ivonamo mageta faifaina. ");
INSERT INTO yml_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yaubada yana Tosivemagetanina 'asa'aiana taunina mageta mogitana, i obuma tomia fwayafwaya matatabudi nuadi i kikiavemagetadi. ");
INSERT INTO yml_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Avinodi fwayefwayeye i mai kumanina fwayafwaya 'ana to'idewadewa, siwe tomia fwayafwaya kebu i da 'isa'inanai. ");
INSERT INTO yml_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I mai taunina yana 'awalaweye siwe yana 'aila'avo i vedumwe'ai'aieni. ");
INSERT INTO yml_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","We'e egavo ma yadi vetumagana i lu'uma'umaieni wata taunidi i tauyedi 'waineye, Yaubada veimea i veledi bega kumanidiavo natunavo. ");
INSERT INTO yml_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tomotoganidi i tubuve'ivauga, kebu tomogo ma yana vavine 'waidiega wata kebu tamu tomogo yana nuanua 'wainega, tubuve'ivaunina Yaubada 'wainega yana 'aila'a faifaina. ");
INSERT INTO yml_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yaubada yana Tosivemageta i obuma i vetomotogaotoga taiadi 'a miamia, yana nuakalikali 'eno'eno-vagaina wata nani matatabuna tonovina lamuna. I mai tamada 'wainega, taunina Natuna tubu'eana, we'e 'ifwaima yana mageta mataududulina 'a 'iseni. ");
INSERT INTO yml_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioni Tobafitaiso i maiga bonana bwaikinega i lu'ivona 'aila'a 'waidie Yaubada yana Tosivemageta faifaina i vo, Sino taunina, kumanina faifaina a lulu'ivona 'waimie a vo, Avinodi yau a kumeta, taunina i mimai mulikuye, siwe taunina bwaikaotogina yau kebu bani'odiga fai yau bola kebu a da tubugaga nagamidiotoga taunina i miamia.’” ");
INSERT INTO yml_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yaubada yana Tosivemageta tonuakalikali mogitana, nuakalikali tulina tulina ma 'adi 'imoso'i ta veveluagadi 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yaubada yana veimea i veleda Mosese 'wainega, we'e yana nuakalikali 'eno'eno-vagaina wata nani matatabuna tonovina i souyeni Iesu Keliso 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kebu tamu aitoi Yaubada i da 'iseniga, 'aiseotogina Natuna, kumanina 'asa'aiana Yaubada. Natuna Tamana 'ana labilabina bega i sivemageseni 'waideye. ");
INSERT INTO yml_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Me Diu to'edakumetavo i miamiani Ielusalema 'waineye nuanuadi i na 'asetai Ioni Tobafitaiso aitoi, begaidi tomotoga 'ifwaidi i vetunedi i nagoi 'waineye i velutolieni. Tomotoganidi tovelomu 'ifwaidi wata Vanuga 'Eba Velu'ui 'ana to'isave'avinavo. ");
INSERT INTO yml_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ioni yadi velutoli kebu i da vedumwe'ai'aieni nani matatabuna i lu'ivoneyedi i vo, Yau kebu Keliso, Yaubada 'ana Venua'ivinaga.” ");
INSERT INTO yml_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bega i velutolieni i vo, We'e 'omu aitoi? 'Alo 'omu Ilaitia 'u vilamu Yaubada 'wainega?” Ioni i vo, Kebu.” Wata i velutoli i vo, 'Alo 'omu tolu'ivonanimu, kumanimu faifaimu basenadiotoga Yaubada i lu'ivona Mosese 'waineye, i vo, Bola i na mai?’” Nika wata i vo, Kebu.” ");
INSERT INTO yml_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wata tovelutolinidi i vo, Vetuma 'omu aitoi? Nuanuama taunimu 'u na lu'ivoneyemu bega 'a na vilama 'a na nagoi 'ama tovetune 'waidie 'a na veifufu.” ");
INSERT INTO yml_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Bega Ioni yadi velutoli i tutuli Yaubada yana tolu'ivona Aisea 'ana kilukiluma 'wainega i vo, Sali'avu'avuye a vevegolegole a vo, 'Auvea yana 'eda 'wa na vusia wata 'wa na sivetonovi yana 'eba nago.’” ");
INSERT INTO yml_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Tovelutolinidi Falisi i vetunediga Ioni i velutolieni i vo, 'U vonaga 'omu kebu Keliso, kebu Ilaitia wata kebu Yaubada yana tolu'ivona bwaikina, siwe awale tomotoga 'u babafitaisodi?” ");
INSERT INTO yml_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","I vonedi i vo, Yau ufa 'aisena 'wainega tomotoga a bafitaisodi, we'e tamu tomogo 'awasasamie i tovotovoi siwe kebu 'wa da 'isa'inanai. ");
INSERT INTO yml_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Avinodi yau a kumeta a folova, siwe kumanina mulikuye i mimaiga, 'awaie tomogo bwaikina, yau kebu bani'odi. Kebu i da i lubwaineku 'waineye 'ana vetofolova 'ana 'ageyafayafa a na ta'ia.” ");
INSERT INTO yml_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","De'e bani'odi Ioni i veifufuyediga Bedani 'waineye, Ufa Iolidani we'e no'o bega, wata bei tomotoga i bafitaisodi. ");
INSERT INTO yml_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","I 'atai Ioni i veveifufu 'aila'a 'waidie nika Iesu i 'isanaweni i mimai i vonedi i vo, Sino tomogonina, Yaubada yana Sifi Siaina i mai 'wainega. Taunina yana wafa 'wainega tomia fwayafwaya matatabuda yada sakona i na 'ewayavuledi. ");
INSERT INTO yml_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kumanina basenadi faifaina a lu'ivona 'waimie a vo, Avinodi yau a kumeta, taunina i mimai mulikuye, siwe bwaikaotogina yau kebu bani'odi fai bola kebu a da tubugaga nagamidiotoga i miamia.’ ");
INSERT INTO yml_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yau nagami Yaubada 'ana Venua'ivina kebu a da 'isa'inanai, siwe a mai tomotoga a babafitaisodi ufayega bega a na sivemageseni me Isileli 'waidie.” ");
INSERT INTO yml_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Wata Ioni side bani'odi i lu'ivoneyedi tomotoga 'waidie i vo, Tutuyanina 'waineye 'Anu'anunu Magemagetana a 'iseni abamayega i obu Iesu 'waineye, i age-vagaseni, yana yaveobu 'ana 'isa'isa bani'odi bunebune. ");
INSERT INTO yml_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yaubada 'ana Venua'ivina kebu a da 'asetai a vo 'ako aitoi, siwe tutuyanina Yaubada i vetuneku a na bafitaiso ufayega i voneku i vo, 'Awaie 'Anu'anunuku 'u na 'iseni i na obu tamu tomogo i na age-vagaseni nika bei 'u na 'asetai.’ ");
INSERT INTO yml_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tauniku matakuyega a 'iseni, a vona mogitana taunina Yaubada Natuna.” ");
INSERT INTO yml_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","I 'atai Ioni Tobafitaiso yana tovetutuyamavo 'adi 'ailuga taiadi i tovotovoi, nika Iesu i 'iseni i mai i nunago. Bega Ioni i vonedi i vo, Sino tomogonina Yaubada yana Sifi Siaina.” ");
INSERT INTO yml_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","'Adi 'ailuga yana vona i nogai Iesu mulineye i nagoi. ");
INSERT INTO yml_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu i sivilai i 'isedi i velutoliedi i vo, Tamu ava'ai yami nuanua faifaina 'wa mimaia?” Velutoliega yana velutoli i tutuli i vo, Tove, ava'aibe bei yamu vanuga?” ");
INSERT INTO yml_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iesu i vo, 'Wa mai ta na nagoi a na vemi.” Taiadi i nagoi yana 'eba mia i vedi. Fai 'akonadi i lavia, bani'odi 4 kiloki, bei i miamiani nika i lovani. ");
INSERT INTO yml_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tomotoganidi 'adi 'ailuga Ioni yana vona i nogai bega Iesu taiadi i nagoi, tamu 'ana wagava Anidulu, Saimoni Fita taina. ");
INSERT INTO yml_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anidulu Iesu taiadi i veifufu'a'ava, tonovina i nago nika tatana i veluagai i voneni i vo, Saimoni, 'ima 'akonadi Keliso, Yaubada 'ana Venua'ivina 'a veluagai.” ");
INSERT INTO yml_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bega i vagavaia taiadi i maia Iesu 'waineye. Iesu Fita i 'iseni i vo, 'Omu Saimoni, Ioni natuna, siwe 'awaie 'amu wagava i na golegolemu Sifasa.” Sifasa 'ana 'aseta kileu bababana, Fita me Kuliki bonadiega. ");
INSERT INTO yml_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","I 'atai Iesu nuanuana i na nago 'awalawa Galili, Filifi i veluagai i voneni i vo, 'U mai taiadi ta na nago yaku tovetutuyama.” ");
INSERT INTO yml_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filifi 'ana tuvada Bedasaida, 'atamananina 'wainega Anidulu wata Fita bega i maia. ");
INSERT INTO yml_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filifi Iesu yana vona i nogai Nataniela i veluagai i voneni i vo, 'U na nuani basenadiotoga Mosese wata tolu'ivonavo i kiluma Yaubada 'ana Venua'ivina faifaina yana Buki nageneye. Tomogonina 'akonadi 'a veluagai, 'ana wagava Iesu, Iosefa tomogo Nasaledi natuna.” ");
INSERT INTO yml_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniela i vo, Vona mogitana? Kebu 'ana fata tamu nani 'atumaina i na mai 'atamana Nasaledi 'wainega.” Yana vona Filifi i tutuli i vo, 'U mai ta na nago 'u na 'iseni.” ");
INSERT INTO yml_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tutuyanina Iesu Nataniela i 'iseni i mimai tomotoga i vonedi i vo, Sino taunina mogitana tomogo Isileli, yana sauluva matatabuna tonovina.” ");
INSERT INTO yml_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniela Iesu i velutolieni i vo, Bani'odi 'u munega 'u 'asetaku?” Iesu i vo, Nagami a 'isemu 'ala'ai lamuneye 'u tovotovoi mulieta Filifi i lu'ivona 'waimuye faifaiku.” ");
INSERT INTO yml_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniela i vo, Tove, 'omu mogitana Yaubada Natuna wata me Isileli yada Kini.” ");
INSERT INTO yml_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu i velutolieni i vo, 'U vetumagana fai yamu 'eba mia nagami a lu'ivoneyeniga 'waimuye? Siwe nani siaina. 'Awaie nani bwaikidi 'u na 'isedi, 'eba nuavogana wata 'eba nua'ewa a na 'i'idewadi. ");
INSERT INTO yml_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A vona mogitana, bola 'wa na 'iseni abama i na 'anikililia, Yaubada yana anelose 'wa na 'isedi i na lakalaka wata i na obuobuma yau a vetomotogaotoga 'waikuye. Yau kumaniku wanala abama wata fwayafwaya kamwadie.” ");
INSERT INTO yml_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","'Aiata 'ailuga i 'a'avana, tamu tomogo nagi sakalina i 'idewai 'atamana Kena 'waineye, 'awalawa Galili nageneye, Iesu inana 'akonadi i nago. ");
INSERT INTO yml_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tonisakali Iesu wata yana tovetutuyamavo i tayegidi. ");
INSERT INTO yml_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","'Ani 'waineye 'adi oine i 'a'ava, Iesu inana i voneni i vo, Natuku, oine matatabuna i 'a'ava.” ");
INSERT INTO yml_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu i vo, Inaku, ava'ai nuanuami a na 'idewai kebu 'wa na vonekuga. Yaku folova 'ana tutuya bola.” ");
INSERT INTO yml_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Siwe inana 'ani'ani 'adi to'idewadewa i vonedi i vo, Ava'ai Iesu i na voneyediga, 'wa 'idewadi.” ");
INSERT INTO yml_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Diu totafalolo yadi sauluva nimadi i 'i'ivevunavunagidi, begaidi vanuganina 'waineye 'eba koi ufa bwaikidi matatabuna 6 i yatodi, 'aitamogana 'wainega 'ana fata dalamu siaidi matatabuna 5 'alo 7 ta da veliliwadi i da adaga. 'Eba koinidi kileu i 'eavidi. ");
INSERT INTO yml_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu i vona 'ani'ani 'adi to'idewadewa 'waidie i vo, Nuanuaku 'eba koinidi ufa 'wa na veliliwadi.”'Eba koinidi i veliliwadi i ve'alafelefeledi. ");
INSERT INTO yml_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","I 'a'avana i vonedi i vo, 'Eba koi siainega 'wa na koia 'wa na naweni tonisakali 'wa na veleni i na yemu.” ");
INSERT INTO yml_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","I 'ewai i naweni i veleni ufanina i yemutonoviga 'akonadi i ve-oine. Tonisakalinina kebu i da 'asetaiga ava'aiega oine i veluagai we'e tofolova 'aise'avadi i 'asetai. Bega tonisakali tomogonina i nagiga i goleni i mai i voneni i vo, Tomotoga fuedi yadi sauluva nagami oine 'ana lautonova 'atumaina i na 'aniveleneni tomotoga i na yemu, mulieta tutuyanina nuadi i na lugaugaudi, kibwana i na sivemageseni i na yemu. We'e 'omu 'u vesivilai, nagami oine 'atumaina 'u sivemageseni mulieta 'atumaiotogina i vemuli.” ");
INSERT INTO yml_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","'Eba nuavogananina wata 'eba nua'ewanina bei Iesu i velamu i 'idewai 'atamana Kena 'awalawa Galili 'waineye. Yana folovanina 'wainega yana toketokena Yaubada 'wainega i sivemageseni, we'e yana tovetutuyamavo i vetumagana 'waineye taunina Yaubada 'ana Venua'ivina. ");
INSERT INTO yml_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sakalinina i 'a'ava, Iesu, inana tainavo taiadi wata yana tovetutuyamavo i nagoi 'atamana Kafaneomi bei sai'afo i yogomia. ");
INSERT INTO yml_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","'Akonadi tutuya i velilivana sai'afoga me Diu yadi Sakali Uvi'agalatagona 'ana 'aiata i na le'wa begaidi Iesu yana tovetutuyamavo taiadi i laka Ielusalema. ");
INSERT INTO yml_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iesu i luku Vanuga 'Eba Velu'ui nageneye tomotoga i 'isedi yadi 'aisaya i vevekimwaneyedi 'ifwaidi tomotoga 'waidie, bega i na nikedi i na velomuyedi Yaubada 'waineye. 'Aisayanidi bulumakau, sifi wata bunebune, we'e 'ifwaidi tomotoga mani tulina tulina 'adi tosivedavedamana i miabui 'adi talalia 'waidie i miamiani. ");
INSERT INTO yml_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Iesu ma yana nuasako bulava i 'ewadi i metani yana 'eba 'aifitala. Sifi wata bulumakau matatabudi i luveyavulidi, tosivedavedamana 'adi talalia i tutuviladi yadi mani i 'etoiwaga. ");
INSERT INTO yml_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","We'e bunebune 'ana tovekimwane i lukakadedi i vo, Yami manuga 'wa 'ewadi 'wa souyemi. Tamaku yana vanuga 'ana wagava Vanuga 'Eba Velu'ui, kebu yami 'eba sivedavedamanaga.” ");
INSERT INTO yml_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yana tovetutuyamavo i 'iseni i nuani tamu vona-samula basenadiotoga i kilumi Yaubada yana Buki nageneye i vo, Yaubada, nuanuaku bwaikina tomotoga yamu vanuga i na ve'ililibuyeni faifaina a 'i'ikasikasisi, begaidi vita a na veluagai.” ");
INSERT INTO yml_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Fai Iesu tomotoga i sogiedi begaidi me Diu to'edakumetavo i maia Iesu i velutolieni i vo, Awale? Aitoi veimea i velemu tomotoga 'u luveyavulidi? Nuanuama tamu 'eba nuavogana wata 'eba nua'ewa 'u na 'idewai 'a na 'iseni wata 'a na 'asetai 'omu ma yamu veimea Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu i vonedi i vo, 'Atumaina, 'eba nuavogana wata 'eba nua'ewa tamu a na 'idewai 'wa na 'iseni. Vanuga 'Eba Velu'ui de'e 'wa da geuyaga, 'aiata 'aitonu nagedie wata a da vetovoi-vaitugani.” ");
INSERT INTO yml_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","I voneni i vo, De'e Vanuga 'Eba Velu'uinina i yogoyogoni malamala 46 nagedie, we'e 'omu igodi 'aiata 'aitonu nagedie 'u na yogona-vaitugani.” ");
INSERT INTO yml_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Siwe Iesu kebu mogitana i da vonavona Vanuga 'Eba Velu'ui faifaina, i vonavona taunina faifaina. ");
INSERT INTO yml_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tutuyanina Iesu i tovoi-vaitugana wafayega nika bei yana tovetutuyamavo yana vonanina i nuani bega Yaubada yana Buki wata Iesu yana vonanina faifaidi ma yadi vetumagana i ve'awamogitana. ");
INSERT INTO yml_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sakali Uvi'agalatagona 'ana tutuye Iesu i miamia Ielusalema 'eba nuavogana wata 'eba nua'ewa i 'idewadi. Tomotoga fuedi i 'iseni i awavemogitaneni begaidi i vetumagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Siwe Iesu 'aitamogana 'aitamogana yadi nuanua i 'asetadi begaidi yadi vetumagananina faifaina Iesu kebu i da ve'awamogitana. ");
INSERT INTO yml_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Fai Iesu matatabuda i 'aseta'a'avada, begaidi kebu tamu aitoi 'ana fata yana 'asetanina i na awave'ede'edeni. ");
INSERT INTO yml_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ielusalema 'waineye tamu Diu totafalolo Falisi 'ana wagava Nikodimo i miamia, we'e taunina tamu me Diu to'edakumeta bwaikina. ");
INSERT INTO yml_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tamu lovana 'waineye i mai Iesu i voneni i vo, 'Auvea, 'a 'asetamu 'omu Tove 'u mai Yaubada 'wainega. Kebu tamu aitoi 'ana fata 'eba nuavogana wata 'eba nua'ewa 'u 'i'idewadiga, bani'odi i na 'idewadi, 'omu 'aiseotogimu Yaubada yana toketokena 'wainega 'u folofolova.” ");
INSERT INTO yml_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Siwe Iesu i voneni i vo, A vona mogitana 'waimuye 'ai'edi aitoi kebu i na tubuve'ivau, kebu 'ana fata i na luku Yaubada yana 'Eba Veimea 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimo i velutoli i vo, Tulaidi bani'odi i na munega i na tubuga-vaitugana? Kebu 'ana fata tamu tomogo i na luku inana umwadie wata i na tubuga-vaitugana.” ");
INSERT INTO yml_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Iesu i voneni i vo, Tomotoga inadiavo 'waidiega i tubuga taunidi 'asa'aiana 'adi wagava tomotoga. We'e egavo i na tubuve'ivau 'Anu'anunu Magemagetana 'wainega, 'Anu'anununina 'akonadi i agedi i 'ive'ivaudi. A vona mogitana 'waimuye, 'ai'edi tamu aitoi kebu i na tubuve'ivau ufa wata 'Anu'anunu Magemagetana 'waidiega 'ako kebu 'ana fata i na luku Yaubada yana 'Aila'a nageneye. ");
INSERT INTO yml_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kebu nuamu i na vogani fai a vo, I lubwainemi 'wa na tubuve'ivau.’ ");
INSERT INTO yml_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kaukau taunina yana nunuga i veveimeyeni. Butu'aina ta noganogai siwe yana 'eba velamu wata yana nago kebu ta da 'asetaiga. Wata bani'odi kebu 'ada fata ta na 'asetai, 'Anu'anunu Magemagetana bani'odi i munega tomotoga i agedi i tubuve'ivau.” ");
INSERT INTO yml_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimo i velutoli Iesu 'waineye i vo, Yamu vona 'ana 'aseta bani'odi? A bavuyeni.” ");
INSERT INTO yml_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu i vo, 'Omu me Isileli yama tove bwaikimu, awale naninidi a veveifufuyediga 'u bavuyedi? ");
INSERT INTO yml_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A vona mogitana 'waimuye, ava'ai 'a 'isedi wata 'a 'asetadi 'a veveifufuyedi 'waimuye, siwe kebu tamu aitoi 'waimiega yama vona faifaidi i da ve'awamogitana. ");
INSERT INTO yml_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Naninidi a veifufuyediga fwayafwayayega siwe kebu 'wa da vetumagana. We'e 'ai'edi naninidi abamayega a na veifufuyediga, mogitana 'wa na bavu-'afo'afo. ");
INSERT INTO yml_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kebu tamu aitoi i da laka abame wata i da vila-vaitugani i da obuma, yau a vetomotogaotoga 'aiseotogiku abamayega a obuma begaidi ma yaku 'aseta a veveifufu. ");
INSERT INTO yml_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Basenadiotoga sali'avu'avuye Mosese kumaea 'o'olo bani'odi welavi 'waineye i silakai bega egavo i 'isalaka 'waineye kebu i da wafaga. Yau wata bani'odi, i lubwaineni 'awaie yau a vetomotogaotoga tomotoga i na silakaiku, bega egavo ma yadi vetumagana taunidi i na tauyedi 'waikuye, mia 'atumaina wata miamia-vagaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Fai Yaubada tomia fwayafwaya matatabumi i nuakalikaliemi bwaikina, begaidi yau natuna tubu'eana i 'aniveleneku 'waimie bega egavo ma yadi vetumagana taunidi i na tauyedi 'waikuye kebu i na wafa mogitana, mia 'atumaina wata miamia-vagaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yaubada kebu i da vo, Natuku a na vetunei bega yana veimea 'wainega tomia fwayafwaya vematavuloga i na veluagai.’ Kebu, i vetunekuga tomia fwayafwaya a na 'ita'ita'iemi sakona 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Egavo ma yadi vetumagana taunidi i na tauyedi Yaubada Natuna 'waikuye kebu vematavuloga i na veluagai, siwe egavo i baila 'akonadi Yaubada i veimea vematavuloga i na veluagai fai kebu i da vetumagana Yaubada Natuna tubu'eaku 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yau Yaubada Natuna kumaniku a maiga bani'odi mageta tomia fwayafwaya 'waimie, siwe tomotoga fuedi nuanuadi dudubala. Fai yadi sauluva sakoidi kebu nuanuadi mageta, begaidi vematavuloga i na veluagai Yaubada 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tomotoganidi yadi sauluva sakoidi mageta i baila, kebu nuanuadi yadi sauluva sakoidi i na sivemagesedi. ");
INSERT INTO yml_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","We'e egavo yadi sauluva tonovidi, ma yadi sosoana i na maia magetanina 'waikuye bega tomotoga fuedi i na 'isedi i na 'asetadi Yaubada yana nuanua 'ana to'idumwebika.” ");
INSERT INTO yml_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Iesu i veifufu'a'ava Nikodimo 'waineye, mulieta yana tovetutuyamavo taiadi i nagoi 'awalawa Iudia. Bei sai'afo i yogomia wata yana tovetutuyamavo tomotoga fuedi i bafitaisodi Iesu yana veimea 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Ioni Tobafitaiso bola kebu i da luku vanuga yogona nageneye i nago 'atamana Ainoni, Selimi lilivaneye. Bei tomotoga fuedi i nunagoi 'waineye i bafitaisodi ufanina bwaikina 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tutuyanina 'waineye Ioni tobafitaiso yana tovetutuyamavo i ve'ikwayekwayega tamu tomogo Diu taiadi, yadi tafalolo 'ana sauluva 'ilekoa faifaina bega igodi i na vevunavunaga Yaubada mataneye. ");
INSERT INTO yml_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bega tovetutuyamanidi i nagoi Ioni i voneni i vo, Tove, 'u na nuani, tomogonina taiadi 'wa miamia Ufa Iolidani vi'ainega kumanina faifaina 'u veveifufuga, valana 'a nogai tomotoga fuedi i baibailemu i nunagoi 'waineye bafitaiso faifaina.” ");
INSERT INTO yml_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ioni i vonedi i vo, Yaubada abame tomotoga 'aitamogana 'aitamogana yada folova i veleda. ");
INSERT INTO yml_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","'Wa na nuani basenadi a vonemi a vo, Yau kebu kumaniku Keliso, yau a na vetomata'aulelemo faifaina.’ ");
INSERT INTO yml_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Side bani'odi. Nagi 'ana tutuye tonagi vavine i na 'ewai, we'e iana tosigeugeu kebu 'ana fata i na nuavita i na sosoanamo. Yau wata bani'odi yaku 'eba sosoana, 'ai'edi tomotoga fuedi i nunagoi Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","I lubwaineni Iesu 'ana wagava i na vevebwaika, we'e yau ma'itufa 'aku wagava i na vevesiai.” ");
INSERT INTO yml_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yaubada Natuna kumanina i mai tabwanega, bwaikaotogina kebu tomotoga bani'odi. Egavo i tubuga fwayefwayeye tutuya fuedi i veveifufu nani fwayefwayeye faifaidi, we'e kumanina i mai abamayega tomotoga i vebwaika-'iawedi. ");
INSERT INTO yml_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Naninidi i 'isediga wata i nogaidiga abame i lulu'ivoneyedi tomotoga 'waidie, siwe kebu fuedi i da vetumaganeni. ");
INSERT INTO yml_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Egavo Yaubada Natuna yana vona i vetumaganeni, taunidi wata Yaubada yana vona i ve'awamogitaneni. ");
INSERT INTO yml_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kumanina Yaubada i vetunei 'waideye, 'Anu'anununa i agei mogitana begaidi Yaubada yana vona i lulu'ivoneyedi tomotoga 'waideye. ");
INSERT INTO yml_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yaubada Natuna i nuakalikalieni bwaikina, nani matatabuna i 'anivelenedi 'waineye bega i veveimeyedi. ");
INSERT INTO yml_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Egavo ma yadi vetumagana taunidi i tauyedi Yaubada Natuna 'waineye mia 'atumaina wata miamia-vagaina 'akonadi i veluagai, we'e egavo i vedumwe'ai'aieni kebu mia-vagatanina i na veluagai, Yaubada yana nuasako i na 'eno-vagata 'waidie. ");
INSERT INTO yml_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Me Diu totafalolo Falisi vala i nogai Iesu yana bafitaisoyega yana tovetutuyamavo fuedi i veveluagadi, we'e Ioni Tobafitaiso kebu fuediga. ");
INSERT INTO yml_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","We'e Iesu kebu i da bafitaisodi tomotoga, yana tovetutuyamavo 'aisedi bafitaiso i 'i'idewai. ");
INSERT INTO yml_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fai Falisi i vona i vo, Iesu tovetutuyamavo fuedi i veveluagadi,” begaidi Iesu yana tovetutuyamavo i vonedi ma fuedi i tovoi Iudia i 'iaweni wata i viladi i na nagoi 'awalawa Galili. ");
INSERT INTO yml_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Fai Iesu nuanuana, i yogodaba 'awalawa Samelia kamwaneamo. ");
INSERT INTO yml_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","I nunagoi i souyedi tamu 'atamana 'ana wagava Saika 'waineye. 'Atamananina lilivaneye tamu tanoga basenadiotoga Iakobo i 'aniveleneni natuna Iosefa 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tanoganina 'waineye bei Iakobo ufa i alai. Fai 'akonadi 'aiata 'ana utukamwana, Iesu i 'abiawa 'eda manamanawena begaidi i miabui ufanina lilivaneye i na veawai. ");
INSERT INTO yml_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","We'e yana tovetutuyamavo i nagoi 'atamana bwaikina 'waineye 'adi'adi i na kimwane. Iesu i veveawai nika tamu vavine Samelia i le'wa ufa koi faifaina. Iesu i vonedi i vo, Ufa 'wa da koia 'wa da veleku a da yemu.” ");
INSERT INTO yml_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Me Diu wata me Samelia kebu taiadi i da veveiana, yadi 'eba yemu wata 'eba 'ani 'waidiega kebu 'ana fata me Diu bega i na yemu 'alo i na 'ani. Begaidi vavinenidi i vo, Yau vavine Samelia, awale 'waimeye ufa 'u vevelu'ui?” ");
INSERT INTO yml_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu i vonedi i vo, 'Ai'edi 'wa da 'asetai ava'ai Yaubada nuanuana i na velemi wata yau aitoi, 'wa da velu'uieku tamu ufa a da velemi, ufanina 'wainega mia 'ivauna wata 'atumaina 'wa da veluagai.” ");
INSERT INTO yml_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Vavine i voneni i vo, 'Auvea, yamu 'eba koi ufa kebu wata ufa va'ebeiotoga ovu manamanawena, we'e 'omu ava'aiega ufa 'u na 'ewai bega mia 'ivauna wata 'atumaina 'a na veluagai?” ");
INSERT INTO yml_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wata vavinenidi i vo, Tubuda Iakobo ufa de'e i alai, taunina wata ma natunavo yadi 'aisaya taiadi yadi 'eba yemu, wata 'asiau 'ima bei 'a yemuyemu. Iakobo tomogo bwaikina, we'e 'omu igodi 'u na vebwaika-'iaweni bega tamu ufa 'atumaiotogina 'u na velema?” ");
INSERT INTO yml_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","14","Iesu vavine yadi vona i tutuli i vo, 'Ai'edi aitoi de'e ovuyega ufanina i na yemu bola wata i na veufa'ani'anigoku, we'e aitoi ufa a na veleni i na yemuga, i na yemu-vagata kebu wata i na yemuyemu. Ufanina nuana 'waineye i na veufa-luluvuala bega mia 'atumaina wata miamia-vagaina i na veluagai.” ");
INSERT INTO yml_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Vavine i vo, 'Auvea, ufanina nuanuama 'u na velema bega 'anigoma kebu i na lalala wata de'e bei kebu 'a na mimai 'a na koikoi.” ");
INSERT INTO yml_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesu i vonedi i vo, 'Wa na nago yami lamoga 'wa na vagavaia 'wa na mai.” ");
INSERT INTO yml_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Vavine i vo, Yau kebu tamu yama lamoga.” Iesu yadi vona i tutuli i vo, Basenadi iaveta 5 'wa nagidi, we'e tomogonina taiadi 'wa miamiaga, kebu mogitana yami lamoga.” ");
INSERT INTO yml_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Vavine i vo, Yamu vona 'ana nogaya 'wainega 'a 'asetamu 'omu tamu Yaubada yana tolu'ivona. ");
INSERT INTO yml_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Me Samelia tubumavo 'oya de'e 'waineye i 'odu'odu Yaubada 'waineye, we'e 'omi me Diu 'wa vonaga 'wa vo, I lubwaineni matatabuda Ielusalema 'aisena 'waineye ta na 'odu'odu.’” ");
INSERT INTO yml_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu i vonedi i vo, Novuku, a vona mogitana 'waimie, 'awaie de'e 'oyanina 'waineye wata Ielusalema 'waineye kebu bei 'aise'avadi 'waidie tomotoga i na 'odu'odu, 'awalawa matatabuna 'waidie i na 'odu'odu Tamada 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'Omi me Samelia yami 'aseta siaina kumanina 'waineye 'wa 'odu'odu faifaina, we'e 'ima me Diu 'a 'aseta-'atumaia, fai yama 'aila'a 'wainega tomotoga 'ita'ita'i i veveluagai. ");
INSERT INTO yml_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Siwe 'awaie, naninidi i na souyediga, tutuya de'e 'akonadi i velamu, Yaubada 'Anu'anununa yana 'aivaita 'wainega tomotoga i na 'odu'odu Tamada 'waineye, yana nuanua tonovina i na 'aseta-'atumaia bega taunidi to'odu mogitana, kumanidiavo Tamada nuanuana bani'odi i da 'odu'odu 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yaubada taunina 'Anu'anunu, begaidi i lubwaineni egavo yadi nuanua tonovina mogitana, wata 'anu'anunudiega i na 'odu'odu 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Vavine i vona Iesu 'waineye i vo, Yau 'a 'asetai Mesaia, kumanina i goleni Keliso, 'awaie i na mai. Tutuyanina i na le'wa, nani matatabuna i na kiavemagetadi 'waimeye.” ");
INSERT INTO yml_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iesu i vo, Yau 'asa'aiana kumaniku Mesaia, a veveifufu 'waimie.” ");
INSERT INTO yml_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tutuyanina Iesu yana tovetutuyamavo i viladi i maia, i 'iseni vavine taiadi i veveifufu nuadi i voganidi. Siwe kebu tamu aitoi 'waidiega i da velutoli vavine 'waidie i da vo, Ava'ai nuanuami?”'Alo i da velutoli Iesu 'waineye i da vo, Awale vavine taiadi 'wa veveifufu?” ");
INSERT INTO yml_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Vavinenidi yadi 'eba koi ufa i baileni i 'eno'eno, i viladi i nago 'atamane. ");
INSERT INTO yml_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Tomotoga i vonedi i vo, Tomogo no'o 'asiauna be'ama 'a veluagai, yama sauluva matatabuna i lu'ivoneyedi. 'Wa maia ta na nagoi 'wa na 'iseni. Voke kumanina Keliso, Yaubada 'ana Venua'ivina.” ");
INSERT INTO yml_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tomotoga matatabudi 'atamana i 'iaweni i maia Iesu 'waineye 'ana 'isa faifaina. ");
INSERT INTO yml_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bola tomotoga i mimaia yana tovetutuyamavo Iesu i lukakadeni i vo, Tove, 'ai'edi sai'afo 'u da 'ani.” ");
INSERT INTO yml_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yadi vona i tutuli i vo, Yau ma 'aku'aku 'ai'edi nuanuaku 'ani, a na 'ani siwe 'ani'aninina kebu 'wa da 'asetaiga.” ");
INSERT INTO yml_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Begaidi yana tovetutuyamavo 'aise'avadi i veifufu i vo, Voke tamu aitoi 'akonadi 'ani'ani i veleni i 'ani?” ");
INSERT INTO yml_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesu yadi veifufu i nogai i vonedi i vo, Yaubada kumanina i vetunekuga, yana nuanua a 'i'idewadi wata folova i velekuga a na ve'a'avadi, 'asa'aiana kumanidi 'aku'aku. ");
INSERT INTO yml_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tamu yada sauluva ta vo, Ta na koyova mulieta weta'i 4 i na 'a'ava nika 'aile'wa,’ siwe a na vonemi. 'Wa 'isanawedi sino tomotoga i mimaia, taunidi bani'odi 'ani'ani 'akonadi i kumaga, tutuya 'aiala. ");
INSERT INTO yml_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","'Akonadi to'aiala tutula i veveluagai yadi folova faifaina, we'e vuaganidi i aladiga 'asa'aiana tomotoga, kumanidiavo mia 'atumaina wata miamia-vagaina i na veluagai. Bega tokoyova wata to'aiala taiadi i na sosoana. ");
INSERT INTO yml_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tamu yada vona 'akonadi 'ana mogitana i souyeni ta vo, Tamu tomogo 'ani'ani i bakuli we'e tamu tomogo i 'aiala.’ ");
INSERT INTO yml_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","A vetunemi bega vuaganidi 'wa na 'aiala, tofolova kumekumetadi valaku 'atumaina i bakulidi tomotoga 'waidie, 'omi nonogina 'wa na 'aile'wamo.” ");
INSERT INTO yml_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Me Samelia fuedi 'atamananina 'wainega i vetumagana Iesu 'waineye fai vavine i vo, Iesu yama sauluva matatabuna i veifufuyedi.” ");
INSERT INTO yml_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Begaidi tutuyanina me Samelia i maia Iesu i 'iseni i voneni i vo, Nuanuama bwaikina taiadi ta na yogomia.” Iesu i nogayedi bei taiadi i miamia 'aiata 'ailuga. ");
INSERT INTO yml_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","42","Yana lau'age 'wainega tomotoga fuedi i vetumagana Iesu 'waineye, tomotoganidi vavine i vonedi i vo, Kebu yami vona 'aisena 'wainega 'a da vetumagana, 'ima taunima yana vona 'a nogai wata 'a 'asetai taunina mogitana tomia fwayafwaya 'ada To'ita'ita'i.” ");
INSERT INTO yml_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Samelia 'waineye 'aiata 'ailuga 'akonadi i 'a'ava, Iesu wata yana tovetutuyamavo taiadi i tauya i nagoi 'awalawa Galili. ");
INSERT INTO yml_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Basenadi Iesu i vo, Yaubada yana tolu'ivonavo taunidi yadi 'atamana 'ana tomotogavo kebu i da ve'ililibuyediga wata i vedumwe'ai'aiedi.” ");
INSERT INTO yml_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Siwe tutuyanina i le'wai Galili Iesu 'ana tuvadeye, tomotoga ma yadi sosoana Iesu i lu'uma'umaieni fai basenadi taunidi i laka Ielusalema Sakali Uvi'agalatagona faifaina, bei i 'iseni 'eba nuavogana wata 'eba nua'ewa i 'idewadi. ");
INSERT INTO yml_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iesu wata yana tovetutuyamavo i viladi i nagoi 'atamana Kena 'awalawa Galili 'waineye, bei basenadi Iesu i vona ufa i ve-oine. Bei Kena 'waineye i miamiani tamu toveimea Kafaneomi 'waineye natuna i viga. ");
INSERT INTO yml_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tutuyanina vala i nogai Iesu i mai Galili, 'awalawa Iudia 'wainega, i nago 'waineye i voneni i vo, 'Auvea, nuanuaku bwaikina ta da nago Kafaneomi, natuku sai'afoga yawaina i na 'a'ava, 'u da 'ivaiseni.” ");
INSERT INTO yml_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu i vona toveimeanina 'waineye i vo, 'Omi nuanuami nagami 'eba nuavogana wata 'eba nua'ewa a na 'idewadi 'wa na 'isedi mulieta 'wa na vetumagana 'waikuye, we'e kebu nuanuami nagami 'wa na vetumagana.” ");
INSERT INTO yml_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Toveimeanina i vo, 'Auvea 'ai'edi ta na vemumuna natuku i na wafa, ta da lilide ta da nagoi.” ");
INSERT INTO yml_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu i voneni i vo, 'U nago, natumu kebu i na wafaga i na ve'atumai.” Toveimeanina Iesu yana vona i vetumaganeni nika i tauya. ");
INSERT INTO yml_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","I nunago 'edeye yana tofolovavo i veluagadi, yana vala i mimaieni natuna i ve'atumaiga faifaina. ");
INSERT INTO yml_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Begaidi i velutoliedi i vo, Ava'ai 'awasasaga i ve'atumai?” I vo, Bogi 'aiata-'wane'waneye bani'odi 1 kiloki yana luyauyauta i 'awatagoni.” ");
INSERT INTO yml_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nika tamana i nuani 'awasasanina 'waineye Iesu i voneni i vo, Natumu i na ve'atumai.” Begaidi ma yana 'aila'avo i vetumagana Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iesu yana mai Iudia 'wainega 'awalawa Galili 'waineye, yana folova toketokena 'ana veluga de'e i 'idewai. ");
INSERT INTO yml_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mulieta Iesu i laka Ielusalema, tamu me Diu yadi sakali faifaina. ");
INSERT INTO yml_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ielusalema kalikalina we'e tamu 'awa i 'idewai 'ana wagava Sifi-'adi-'Awa, fai beidimo sifi i lukulukuvedi. 'Awanina lilivaneye tamu awana iulaula, me Diu bonadiega i goleni Bedeseida, we'e lilivaneye masi'eda 'adi 5 i didigidi. ");
INSERT INTO yml_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Masi'edanidi 'waidie toviga fuedi i miamiani taunidi tomatasako, tubusakosako wata bwalobwaloko. Toviganidi bei i lulukamata fai tutuya 'ifwaidi tamu 'Auvea yana anelose i obuobuma ufanina i lulunekwanekwai. I na lunekwanekwai i 'a'avana, aitoi i na kumeta i na obu-matayo'oga, kumanina i na ve'atumai 'ana viganina 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Toviganidi 'waidiega tamu iadi ma 'ana viga i miamia malamala 38. ");
INSERT INTO yml_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu i mai tomogonina i 'iseni, i 'asetai 'ana viga i 'eno'eno tutuya manamanawena begaidi i velutolieni i vo, Nuanuamu 'u na ve'atumai?” ");
INSERT INTO yml_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Toviganina Iesu yana velutoli i tutuli i vo, 'Auvea, siwe kebu tamu aitoi i na siobuyeku, tutuyanina ufanina i na lunekwanekwai. Igodi a da obuobu siwe iaku tamu i kumeta i obu i ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iesu i voneni i vo, 'U tovoi, 'amu 'ivi 'u 'ewai 'u nago.” ");
INSERT INTO yml_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Iesu yana voneye nika tomogo i ve'atumai, 'ana 'ivi i evai i nago. 'Aiatanina 'waineye tomogo i ve'atumaiga, me Diu yadi 'Aiata Veawai 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Me Diu to'edakumetavo tomogonina i 'iseni 'ana 'ivi i evai i nunago begaidi i voneni i vo, Eva wata tamu folova, awale 'Aiata Veawai 'waineye 'amu 'ivi 'u evaeva, yada ve'etoboda 'u geugeuya?” ");
INSERT INTO yml_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","I vonedi i vo, Tomogonina i 'ive'atumaikuga i voneku i vo, 'Amu 'ivi 'u 'ewai 'u nago.’” ");
INSERT INTO yml_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Me Diu i velutolieni i vo, Aitoi bani'odi i voneyedi 'waimuye?” ");
INSERT INTO yml_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Siwe tomogonina Iesu 'ana wagava kebu i da 'asetaiga wata 'akonadi ava'aibe bei i nago 'aila'a bwaikina 'waidie i vetufawanawana. ");
INSERT INTO yml_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mulieta Iesu tomogonina i veluagai Vanuga 'Eba Velu'ui nageneye i voneni i vo, 'U 'iseni, 'akonadi 'u ve'atumai, kebu wata 'u na sakonaga. 'Ai'edi 'u na sakona-vaitugana, bola tamu nani vitaotogina i na souyeni 'waimuye.” ");
INSERT INTO yml_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Iesu i vona'a'ava, tomogonina i nago Diu to'edakumetavo i vonedi i vo, Tomogonina i 'ive'atumaikuga 'ana wagava Iesu.” ");
INSERT INTO yml_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","'Aiatanina 'waineye me Diu to'edakumetavo i velamu Iesu i vegavieni fai yadi nuanua igodi i vo, Iesu i folofolova 'Aiata Veawai 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Siwe Iesu i vonedi i vo, Tutuya matatabuna wata 'Aiata Veawai 'waidie Tamaku i folofolova, yau wata bani'odi a folofolovaga i lubwaineku.” ");
INSERT INTO yml_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yana vonanina faifaina me Diu to'edakumetavo i kamogala nuanuadi Iesu i na luvewafai fai yadi nuanua i vo, Yada ve'etoboda 'Aiata Veawai faifaina i geugeuya. Wata yana sakona i 'imoso'ieni i ve'awa-Tamaku Yaubada 'waineye, igodi nuanuana Yaubada taiadi i na vesala.” ");
INSERT INTO yml_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Begaidi Iesu me Diu i vonedi i vo, A vona mogitana 'waimie, yau Yaubada Natuna kebu tamu nani yaku nuanuayega a da 'idewai, ava'ai a 'i'idewadiga Tamada 'wainega a 'isa'ewadi. Ava'ai Tamada i 'i'idewadiga, yau wata bani'odi a 'i'idewadi. ");
INSERT INTO yml_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yau Natuna i nuakalikalieku bwaikina wata nani matatabuna i 'i'idewadiga, i veveku. I voneku begaidi toviganina a 'ive'atumaia 'wa 'iseni, siwe sai'afo nani siaina. We'e 'awaie folova toketokeotogidi i na veku a na 'idewadi, 'wa na 'isedi nuami i na voganidi. ");
INSERT INTO yml_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bani'odi Tamada towafa i sisivetovoidi, yau wata egavo nuanuaku mia 'ivauna wata 'atumaina a veleveledi. ");
INSERT INTO yml_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Tomotoga 'adi vematavuloga faifaina kebu Tamada i da veveimea. Yau Natuna veimeanina i veleku bega tomotoga a na veimeyemi 'ami vematavuloga faifaina, begaidi tomia fwayafwaya matatabumi 'wa na ve'ililibuyeku bani'odi Tamada 'wa veve'ililibuyeni. We'e egavo yau Yaubada Natuna kebu i da veve'ililibuyekuga, wata bani'odi Tamada i vetunekuga kebu i da veve'ililibuyeni. ");
INSERT INTO yml_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","A vona mogitana 'waimie, egavo yaku vona i na nogaidi wata i na vetumagana Yaubada 'aku tovetune 'waineye, 'akonadi mia 'atumaina wata miamia-vagaina i veluagai. Tovetumagananidi kebu vematavuloga i na veluagai fai 'akonadi wafaotoga 'ana 'eda i baileni mia-vagatanina i veluagai. ");
INSERT INTO yml_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Wata a vona mogitana 'waimie, 'awaie wata tutuya de'e 'akonadi i sousouyeni, tomotoganidi i nunagoi wafaotoga 'ana 'edeamo yaku vona i na nogai. 'Ai'edi tomotoganidi yau Yaubada Natuna yaku vona i na nogai i na vematayakeyakeni, mia 'atumaina wata miamia-vagaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tamada miamia-vagaina yawaimi lamuna, yau wata 'akonadi i tauyeku bega 'ana fata mia-vagatanina 'wa na veluagai 'waikuyega. ");
INSERT INTO yml_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Fai yau a vetomotogaotoga Tamada i tauyeku bega tomia fwayafwaya matatabumi 'wa na vonayavuga 'waikuye a na veimeyemi vematavuloga faifaina. ");
INSERT INTO yml_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Yaku vonanidi faifaidi kebu nuami i na voganidi. 'Awaie towafa taumatayega yaku vona i na nogai, nika matatabudi i na tovoi. Egavo basenadi yadi sauluva 'atumaidi mia 'atumaina wata miamia-vagaina i na veluagai, we'e egavo yadi sauluva sakoidi yaku veimea 'wainega vematavuloga i na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kebu 'ana fata tauniku yaku nuanuayega wata 'aise'avaku a na 'idewai. Ava'ai Yaubada i vonevonekuga, bani'odi a veveimea, we'e yaku veimeanidi tonovidi fai 'aku tovetunenina yana nuanua a 'i'idewadi, kebu tauniku yaku nuanua.” ");
INSERT INTO yml_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Wata Iesu i vonedi i vo, 'Ai'edi tauniku faifaiku a na lu'ivona, bola kebu 'wa na ve'awamogitana. ");
INSERT INTO yml_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Siwe tamu aitoi i lulu'ivona faifaiku, kumanina 'asa'aiana Tamaku, yana lu'ivonanina vona mogitana. ");
INSERT INTO yml_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Basenadi tomotoga 'ifwaidi 'wa vetunedi i nagoi Ioni Tobafitaiso 'waineye i velutoli faifaiku. Naninidi faifaiku i veifufuyediga, vona mogitana. ");
INSERT INTO yml_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","'Ai'edi kebu tamu aitoi i na lu'ivonaga faifaiku kebu tamu ava'ai, siwe nuami a tolinuata'idi Ioni yana lu'ivona faifaina. Yana lu'ivonanina faifaiku 'wa na nuani bega 'ita'ita'i 'wa na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ioni bani'odi mageta i 'awaiaia, nani fuedi i kiavemagetadi. Yana vona nuanuami, faifaina 'wa sosoana siwe kebu tutuya manamanawenaga wata 'wa baila. ");
INSERT INTO yml_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ioni yana lu'ivona faifaiku nani bwaikina, we'e nani bwaikaotogina 'eba nuavogana wata 'eba nua'ewa a 'i'idewadi. Folovanidi basenadi Tamada i veleku, yami 'eba 'isa bega 'wa da 'asetai Tamada i vetuneku. ");
INSERT INTO yml_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Tamada i vetunekuga, taunina faifaiku i lu'ivona, siwe kebu tamu tutuya bonana 'wa da nogaiga, maigina kebu 'wa da 'iseniga wata yana vona nuamie kebu i da 'eno'eno. Begaidi kebu 'wa da vetumagana 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yaubada yana Buki 'wa lulu'iawawa-vebogia, yami nuanua 'wa vo 'ako mia-vagata 'ana 'eda 'waineamo 'wa nunago. ");
INSERT INTO yml_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Avinodi Bukinina faifaiku i lulu'ivona, siwe 'wa baila, kebu nuanuami 'wa na mai 'waikuye bega mia-vagata 'wa na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Kebu a da nuanua tauniku 'aku subia tomotoga 'waimiega faifaina, fai a 'asetami kebu Yaubada 'wa da nuakalikalieni. ");
INSERT INTO yml_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tamaku yana veimea 'wainega a mai, siwe kebu faifaiku 'wa da sosoana 'wa baila, we'e 'ai'edi tamu aitoi taunina yana nuanuayega i na mai, faifaina 'wa na sosoana. ");
INSERT INTO yml_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kebu 'ami fata 'wa na vetumaganeku fai nuanuami tauni'avami 'wa na subisubiami, we'e kebu nuanuami 'ami subia Yaubada 'wainega. Yaubada toketokeotogina, kebu tamu wata aitoi bani'odi. ");
INSERT INTO yml_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","'Awaie tomia fwayafwaya matatabumi 'wa na vonayavuga Tamada 'waineye siwe kebu a na vevitami yami sakona faifaidi. 'Omi igodi 'wa nuani 'wa vo, 'A na luku abame, fai veimea Mosese 'wainega 'a veve'ililibuyedi.’ We'e mogitana Mosese 'awaie i na vevitami Yaubada mataneye. ");
INSERT INTO yml_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","'Ai'edi mogitana Mosese yana vona Yaubada yana Buki nageneye 'wa da vetumaganediga, yau wata 'wa da vetumaganeku fai faifaiku i kiluma. ");
INSERT INTO yml_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Vonanina Mosese i kilumiga faifaiku kebu 'wa da vetumaganediga, bega kebu tamu sai'afo yaku veifufu 'wa na vetumaganedi.” ");
INSERT INTO yml_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Mulieta me Diu yadi Sakali Uvi'agalatagona sai'afoga 'ana tutuya i na veluagai, Iesu wata yana tovetutuyamavo i viladi i damana Lavu Galili, me Loma bonadiega Lavu Taibilia. 'Aila'a bwaikina Iesu i yoyogo'waili fai 'akonadi yana folova toketokena i 'isedi toviga 'waidie. We'e Iesu yana tovetutuyamavo taiadi i laka tamu 'oya siaina 'waineye, i miabui. ");
INSERT INTO yml_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu i 'isanago 'aila'a bwaikina i 'isedi i mimaia 'waidie begaidi i velutoli Filifi 'waineye i vo, Bani'odi ta na munega 'ani'ani sai'afo moso'ina ta na kimwanei 'aila'a no'o ta na ve'anidi?” ");
INSERT INTO yml_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesu 'akonadi i 'asetai bani'odi i na munega bega 'aila'a i na ve'anidi, siwe nuanuana Filifi yana vetumagana i na sitonovi begaidi i velutoli. ");
INSERT INTO yml_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filifi Iesu yana velutoli i tutuli i vo, 'Ai'edi de'e 'aila'anina 'adi'adi ta da kimwanei lubulubu 200 'wainega 'ako kebu 'adi 'etowava.” ");
INSERT INTO yml_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Saimoni Fita taina, tamu Iesu yana tovetutuyama 'ana wagava Anidulu, i vona Iesu 'waineye i vo, Sino tamu kwamana 'ana 'ibua beledi 5 bali 'wainega i kabunidi, wata igana vakavakalidi 'ailuga. Siwe ava'ai 'ana 'atumaina? 'Ani'ani siaina we'e 'aila'a bwaikina.” ");
INSERT INTO yml_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu yana tovetutuyamavo i vonedi i vo, Tomotoga 'wa na vonedi i na miabui.” Bega tomotoga i miabui domwa 'ale'usadi 'waidie, iaveta tulai'avadi 'adi 'aila'a 5,000 siwe vevine wata yavayavava kebu 'adi lu'iawawaga. ");
INSERT INTO yml_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kwamana beledi wata igana Iesu i veleni. Iesu i vekaiwa Yaubada 'waineye, mulieta yana tovetutuyamavo i veledi tomotoga i veutadi. Wata igana bani'odi i veledi, matatabudi i 'ani kamodi i aidi. ");
INSERT INTO yml_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","I 'ani'a'ava Iesu yana tovetutuyamavo i vonedi i vo, Nuanuaku 'ani'ani 'ifwaidi 'wa luvegelalediga 'wa na kwakwadi bega kebu tamu ta na 'ivekokovi.” ");
INSERT INTO yml_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Matatabuna i kwakwadi bayawa 'adi 12 i vedodogidi. ");
INSERT INTO yml_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tomotoganidi Iesu yana folova toketokena i 'iseni i vo, Vona mogitana, Iesu kumanina tolu'ivonanina basenadiotoga Yaubada i vona'awaufaufa yana mai faifaina.” ");
INSERT INTO yml_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu tomotoga yadi nuanua i 'asetai nuanuadi i na 'ive'avini i na naweni i na ve-kini faifaidi. Fai Iesu kebu nuanuana, begaidi i tovoi 'aisena i vilai i laka 'oyeye. ");
INSERT INTO yml_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Iesu i laka 'oyeye, we'e lavilavie yana tovetutuyamavo i obu balebaleye. ");
INSERT INTO yml_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bei Iesu i lulukamaseni nika 'akonadi i lovani begaidi i dodoga i tauya Kafaneomi weyaginega. ");
INSERT INTO yml_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","I damadamana nika kaukau wata yagina bwaikidi i veluagadi. ");
INSERT INTO yml_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","I tokemaigedi i voi i nago sai'afo manamanawena nika Iesu i 'iseni ufa tabwaneamo i mimai waka lilivaneye, matatabudi i kololo-'afo'afo. ");
INSERT INTO yml_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iesu i vonedi i vo, Kebu 'wa na kolologa, yau taunida.” ");
INSERT INTO yml_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tutuyanina i 'asetai mogitana Iesu, i voneni i dodoga nika waka i lilide i duduna-matayo'o Kafaneomi. ");
INSERT INTO yml_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","I 'atai, tomotoga bei Iesu i ve'anidiga balebaleye i lulukamaseni, fai yadi nuanua i vo, Wakanina i mieniga 'akonadi tovetutuyamavo 'aisedi 'wainega i viladi.” ");
INSERT INTO yml_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","I miamia nika waka 'ifwaidi 'atamana Taibilia 'wainega i luku bei Iesu 'aila'a i ve'anidiga lilivaneye. ");
INSERT INTO yml_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tutuyanina 'aila'a Iesu ma yana tovetutuyamavo i 'isa'avadi, wakanidi 'waidie i dodoga i damana Kafaneomi i na lualeni. ");
INSERT INTO yml_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tomotoga Iesu i lulualeni nika i veluagai Kafaneomi 'eba miava'auta nageneye, i velutolieni i vo, Tove, ma'avia 'u mai de'e bei?” ");
INSERT INTO yml_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu i vonedi i vo, A vona mogitana 'waimie, yaku folova toketokena 'wa 'iseni siwe kebu faifaina 'wa da vetumagana 'waikuye 'wa da yoyogo'wai'waila, a ve'animiga faifaina 'wa yoyogo'wai'waila. ");
INSERT INTO yml_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kebu i da lubwainemi 'ani'ani 'ana nuanua i na vebwaika 'waimie, fai 'ani'aninidi bola i na koga wata i na 'anikudadi. 'Ani'aninina kumanina 'wainega mia 'atumaina wata miamia-vagaina 'wa na veluagaiga, i lubwainemi faifaina 'wa na nuanua. Yau a vetomotogaotoga Tamada Yaubada i venua'ivineku wata veimea i veleku, bega 'aku fata 'ani'aninina 'atumaina a na velemi.” ");
INSERT INTO yml_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tomotoga i velutoli Iesu 'waineye i vo, Bani'odi 'a na munega Yaubada yana folova 'a na 'i'idewadi?” ");
INSERT INTO yml_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu i vo, Yaubada nuanuana yami folova side bani'odi. Yau i vetunekuga 'wa na vetumaganeku. Siwe 'asa'aiana yami folova.” ");
INSERT INTO yml_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yana vona i tutuli i vo, Nuanuama yamu folova toketokena ma 'ana 'eba 'isa 'u na 'idewai, 'a na 'iseni 'a na 'asetai Yaubada i vetunemu, 'waimuye 'a na vetumagana. Siwe ava'ai folovaga toketokena 'u na 'idewai? ");
INSERT INTO yml_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Basenadiotoga tubudavo sali'avu'avuye i nunagoi 'adi'adi mana. Faifaina i kilumi Yaubada yana buki nageneye i vo, 'Ani'ani abamayega i veledi i 'ani.’” ");
INSERT INTO yml_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu i vonedi i vo, A vona mogitana 'waimie, we'e 'ani'aninina kebu Mosese yana 'anivelena abamayega, Tamaku yana 'anivelena. Siwe 'asiau nuanuana tamu 'ani'ani i na velemi abamayega, 'ani'aninina 'ani'ani mogitana. ");
INSERT INTO yml_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","'Ani'aninina mogitana tamu tomogo, siwe 'asa'aiana taunina 'ani'ani. Tomogonina abamayega i obuma, bega tomia fwayafwaya mia 'ivauna wata 'atumaina 'wa na veluagai.” ");
INSERT INTO yml_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tomotoganidi i vo, 'Auvea, nuanuama 'ani'aninina tutuya fuedi 'u na velevelema.” ");
INSERT INTO yml_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iesu i vonedi i vo, Yau 'asa'aiana kumaniku 'ani'ani. Yau mia 'ivauna wata 'atumaina 'ana to'anivelena tomotoga 'waimie. 'Ai'edi egavo i na mai 'waikuye kebu i na lasega, wata 'ai'edi egavo i na vetumagana 'waikuye kebu 'anigodi i na lala. ");
INSERT INTO yml_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","'Akonadi a vonemi, yaku folova toketokena matamie a 'idewai 'wa 'iseni, siwe kebu 'wa da vetumagana 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tomotoganidi Tamada i velekuga, matatabudi i na maia 'waikuye, kebu tamu sai'afo a na bailedi. ");
INSERT INTO yml_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yau a mai abamayega 'aku tovetune yana nuanua a na 'idewadi, kebu tauniku yaku nuanuaga. ");
INSERT INTO yml_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","'Aku tovetunenina yana nuanua side bani'odi. Nuanuana tomotoganidi i 'anivelenedi 'waikuye a na 'ita'ita'iedi, kebu tamu aitoi a na baileniga, wata tutuyanina tomotoga 'wa na vonayavuga Yaubada 'waineye, yaku tomotoga yawaidi a na veledi i na tovoi-vaitugana. ");
INSERT INTO yml_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Side bani'odi, Tamaku nuanuana egavo i na 'isa'inanaku yau natuna wata i na vetumaganeku, mia 'atumaina wata miamia-vagaina i na veluagai. Tutuya 'ana 'eba ve'a'ava 'waineye, tomotoganidi a na sivetovoidi.” ");
INSERT INTO yml_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Me Diu ma yadi nuasako i vebonavoluvolu fai Iesu i vo, Yau 'ami'ami a mai abamayega.” ");
INSERT INTO yml_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Begaidi i vo, Awale igodi bani'odi i voneyedi i vo, A obuma abamayega?’ Tamana wata inana ta 'asetadi. Iesu tomotogaotoga, Iosefa natuna.” ");
INSERT INTO yml_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu i vonedi i vo, Kebu 'aise'avami 'wa na vebonavoluvolu yaku veifufu faifaina. ");
INSERT INTO yml_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kebu tamu aitoi 'ana fata taunina yana nuanuayega i na mai 'waikuye. Nagami Tamada 'aku tovetune i na vagavaidi i na miedi 'waikuye, mulieta tutuya 'ana 'eba ve'a'ava 'waineye, tomotoganidi a na sivetovoidi. ");
INSERT INTO yml_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Basenadiotoga yaku vonanina faifaina Yaubada yana tolu'ivonavo i kilumi i vo, Tomotoga matatabudi Yaubada i na vedi wata i na ve 'waidie.’ Begaidi egavo Tamada yana vona i na vinenegeni wata yana ve i na 'ewadi i na maia 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","We'e 'omi kebu tamu aitoi Tamada i da 'iseniga, yau 'aiseotogiku a 'iseni fai a mai Yaubada 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A vona mogitana 'waimie, egavo ma yadi vetumagana taunidi i na tauyedi 'waikuye, 'akonadi mia 'atumaina wata miamia-vagaina i veluagai. ");
INSERT INTO yml_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yau 'asa'aiana kumaniku 'ani'ani. Yau mia 'ivauna wata 'atumaina 'ana to'anivelena tomotoga 'waidie. ");
INSERT INTO yml_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Basenadiotoga tubumiavo mana i 'ani sali'avu'avuye, siwe matatabudi i ve'alawafawafa. ");
INSERT INTO yml_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","We'e 'ani'ani mogitana abamayega i obuma bega egavo i na 'ani, kebu i na wafaotoga. ");
INSERT INTO yml_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yau 'asa'aiana kumaniku 'ani'ani abamayega a obuma. 'Ai'edi egavo 'ani'aninina i na 'aniaga kebu i na wafaotoga i na mia-vagata. 'Ani'aninina a vonevoneyeniga tomogoku, a na tauyeni bega tomia fwayafwaya matatabumi 'ami fata mia 'ivauna wata 'atumaina 'wa na veluagai.” ");
INSERT INTO yml_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Me Diu Iesu yana veifufu i nogai ma yadi nuasako 'aise'avadi i ve'ikwayekwayega i vo, No'o tomogo bani'odi i na munega tomogona i na veleda ta na 'ania? Kebu tamu sai'afo i da lubwaineni.” ");
INSERT INTO yml_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu i vonedi i vo, A vona mogitana 'waimie, yau a vetomotogaotoga 'ai'edi egavo kebu tomogoku i na 'aniaga wata dayagiku i na yemuyaga, kebu 'adi fata mia 'ivauna wata 'atumaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Egavo tomogoku i na 'ania wata dayagiku i na yemu 'akonadi mia 'atumaina wata miamia-vagaina i veluagai, wata tutuyanina tomotoga 'wa na vonayavuga Yaubada 'waineye a na sivetovoidi. ");
INSERT INTO yml_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Fai tomogoku 'ani'ani mogitana wata dayagiku walu'ai mogitana. ");
INSERT INTO yml_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Egavo tomogoku i na 'ania wata dayagiku i na yemuya a na miamia nagedie, yau 'adi labilabina wata i na miamiani nagekuye. ");
INSERT INTO yml_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamada 'aku tovetune miamia-vagaina kebu yana 'a'avaga, begaidi yana toketokena 'wainega a miamia. Wata bani'odi egavo i na 'anikuga yaku toketokena 'wainega i na mia-vagata. ");
INSERT INTO yml_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Basenadiotoga tubumiavo mana i 'ani sali'avu'avuye siwe matatabudi i ve'alawafawafa. We'e yau 'asa'aiana 'ani'ani mogitana abamayega a mai, 'ai'edi egavo 'ani'aninina i na 'aniaga i na mia-vagata.” ");
INSERT INTO yml_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","De'e Iesu yana ve wata yana lau'age tomotoga 'waidie, 'atamana Kafaneomi 'eba miava'auta nageneye. ");
INSERT INTO yml_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tovetutuyamavo fuedi Iesu yana vona i nogai 'aise'avadi i veifufu i vo, Iesu yana ve 'waideye 'ana nogaya vitana, kebu nuanuada. Kebu tamu aitoi 'ana fata i na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu i 'asetai yana tovetutuyamavo i vevebonavoluvolu yana ve faifaina begaidi i vonedi i vo, Yaku ve faifaina voke bunumi i mayaga. ");
INSERT INTO yml_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yaku venina vitana 'waimie kebu nuanuami, siwe 'ai'edi 'wa na 'iseku yau a vetomotogaotoga a na vilaku a na laka abame, 'waimie vitaotogina. ");
INSERT INTO yml_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","64","'Anu'anunu Magemagetana 'aiseotogina 'ana fata mia 'ivauna wata 'atumaina i na velemi, kebu tamu wata aitoi 'ana fata i na 'ivaisemi bega mianina 'ivauna wata 'atumaina 'wa na veluagai. Yaku vonanidi 'akonadi a voneyediga 'anu'anunumi 'adi 'aivaita, 'waidiega 'ami fata mianina 'ivauna 'wa na veluagai, siwe 'ifwaimi kebu 'wa da vetumagana.” Iesu de'e bani'odi i voneyediga fai nagami i 'asetai egavo kebu i da vetumagana, wata 'waidiega kumanina 'awaie i na 'etogiluveni i 'asetai. ");
INSERT INTO yml_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wata Iesu i vona tomotoga 'waidie i vo, Yaku ve 'ana 'aseta vitana 'waimie, begaidi basenadi a vonemi a vo, Kebu tamu aitoi 'ana fata taunina yana nuanuayega i na mai 'waikuye. Nagami Tamada tomotoganidi i na veleku mulieta i na mai 'waikuye.’” ");
INSERT INTO yml_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yana venina faifaina yana tovetutuyamavo 'ifwaidi i baileni, kebu nuanuadi wata i na vevetutuyameni. ");
INSERT INTO yml_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Begaidi Iesu yana tovetutuyamavo 12 i velutoliedi i vo, We'e 'omi bani'odi? Nuanuami 'wa na baileku 'wa na nagoi?” ");
INSERT INTO yml_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimoni Fita yana velutoli i tutuli i vo, 'Auvea, kebu 'ana fata tamu wata aitoi 'waineye 'a na nagoi. Yamu ve 'waidiega 'ama fata mia 'atumaina wata miamia-vagaina 'a na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","'A vetumagana 'waimuye wata 'a 'asetamu 'omu Yaubada Natuna Magemagetamu.” ");
INSERT INTO yml_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iesu i vonedi i vo, Vona mogitana 'ami 12 a venua'ivinemi, siwe 'waimiega tamu Seitani iana.” ");
INSERT INTO yml_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesu i vonavona Iudasa faifaina, taunina Saimoni Isakaliota natuna wata tamu 'adi 'aila'a 12 'wainega, siwe kumanina Iesu 'ana to'etogiluva. ");
INSERT INTO yml_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mulieta Iesu i folova-vuvua 'awalawa Galili nageneye, kebu i da nago Iudia, fai me Diu to'edakumetavo nuanuadi i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Me Diu yadi Sakali 'Ayavau sai'afoga 'ana 'aiata i na veluagai, bega Iesu tainavo i voneni i vo, Yada 'awalawa 'u na baileni 'u na nago 'awalawa Iudia bega yamu tovetutuyamavo 'eba nuavogana wata 'eba nua'ewa 'u na 'i'idewadiga i na 'ise'isedi. ");
INSERT INTO yml_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","'Ai'edi 'amu fata 'eba nuavogana wata 'eba nua'ewa 'u na 'i'idewadiga, taunimu 'u na sivemagesemu bega tomotoga fuedi i na 'isemu.” ");
INSERT INTO yml_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tainavo bani'odi i voneyediga fai taunidi wata kebu i da vetumagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iesu i vonedi i vo, 'Ai'edi nuanuami, i lubwainemi 'wa na nagoi Iudia we'e yau yaku tutuya bola, kebu 'waineye ta da le'wa. ");
INSERT INTO yml_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kebu 'ana fata tomia fwayafwaya i na vedumwe'ai'aiemi, we'e mogitana yau 'akonadi i vevedumwe'ai'aieku, fai tutuya fuedi a vonevonedi a vo, 'Omi yami sauluva sakoidi.’ ");
INSERT INTO yml_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","'Asa'aiana, 'wa kumeta ta waia sakalinina 'waineye. Tutuya de'e kebu i da lubwaineku.” ");
INSERT INTO yml_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tutuyanina Iesu i veifufu'a'avana, Galili bei i miamia. ");
INSERT INTO yml_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iesu tainavo i kumeta i nagoi Ielusalema sakalinina faifaina, mulieta Iesu i vemuli, givagivayega i nago kebu i da vemageta. ");
INSERT INTO yml_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sakalinina nageneye, me Diu to'edakumetavo i lalauala wata i vevelutolitoli Iesu faifaina, 'ai'edi aitoi i da 'iseni. ");
INSERT INTO yml_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tomotoga fuedi i ve'awayaya Iesu faifaina, 'ifwaidi i vo, Tomogo 'atumaina,” we'e 'ifwaidi i vo, Kebu, we'e i vevekalieda.” ");
INSERT INTO yml_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Siwe kebu tamu aitoi mageseye i da veveifufu fai me Diu to'edakumetavo i kololoyedi. ");
INSERT INTO yml_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sakalinina 'ana 'aiata sai'afoga i da 'a'ava, nika Iesu i vemageta i luku Vanuga 'Eba Velu'ui nageneye, bei i velamu i veve tomotoga 'waidie. ");
INSERT INTO yml_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Me Diu nuadi i voganidi yana ve faifaina i vo, Tomogo no'o kebu i da nago sikulu 'waineye. Bani'odi i munega yana 'aseta bwaikina?” ");
INSERT INTO yml_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Begaidi Iesu tomotoganidi i vonedi i vo, Yau kebu tauniku yaku nuanuayega a da veve, venidi Yaubada 'aku tovetune 'wainega i mai. ");
INSERT INTO yml_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Egavo nuanuadi Yaubada yana nuanua i na 'i'idewadi, i na 'asetai kebu a da veve yaku nuanuayega, mogitana Yaubada 'wainega i mai. ");
INSERT INTO yml_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aitoi yana nuanuayega i na veveifufu, kumanina nuanuana tomotoga i na subisubiai, we'e aitoi nuanuana 'ana tovetune i na ve'ililibuyeni, i vona mogitana kebu i da vevekali. ");
INSERT INTO yml_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Yaubada yana veimea Mosese i velemi, siwe kebu tamu aitoi 'waimiega veimeanidi i da vematayakeyakedi, begaidi igodi nuanuami 'wa na luvewafaku.” ");
INSERT INTO yml_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","'Aila'anidi Iesu yana vona i tutuli i vo, 'Omu yaiaina i agemu bega 'wava'wavamu, kebu tamu aitoi 'amu 'ainike i da voneyeniga.” ");
INSERT INTO yml_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu i vonedi i vo, 'Omi nuami i voganidi fai 'Aiata Veawai 'waineye tomogo a 'ive'atumaia Ufa Bedeseida 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Siwe 'omi wata 'wa folofolova 'Aiata Veawai 'waidie, fai veimea Mosese 'wainega bunu 'aibobo faifaina 'wa vevematayakeyakeni 'Aiata Veawai 'waidie 'wa 'i'idewai. We'e bunu 'aibobo kebu mogitana Mosese 'wainega i da mai, i velamu tubuda Ebelamo yana tutuye. ");
INSERT INTO yml_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Veimeanina natumiavo iavetadi 'adi 'aiata 8 i veveluagadi bunudi 'wa bobobodi, siwe wata 'ai'edi tamu kwamana 'ana 'aiata 8 i na veluagai 'Aiata Veawai 'waineye 'wa 'i'idewaimo, nika 'asa'aiana bei 'wa folofolova. Fai 'omi 'wa folofolova 'Aiata Veawai 'waidie, awale 'wa nuasako-maimaiga 'waikuye tomogo a 'ive'atumaiotogi 'Aiata Veawai 'waineye faifaina? ");
INSERT INTO yml_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kebu 'isa'ava 'wainega 'wa na awavesakoyeku, nagami 'wa na venua'ivina-'atumai mulieta 'wa na vona.” ");
INSERT INTO yml_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","'Ifwaidi Ielusalema 'ana tomotoga i vo, Voke no'o tomogonina yada to'edakumetavo nuanuadi i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","'Wa 'iseni? 'Aila'a 'waideye i veveifufu siwe kebu tamu aitoi i da talabodeni. Voke yada to'edakumetavo 'akonadi i 'asetai taunina Keliso, Yaubada 'ana Venua'ivina. ");
INSERT INTO yml_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Siwe 'ida 'akonadi ta 'asetai 'ai'edi Keliso i na souyeni, kebu tamu aitoi i na 'asetai yana 'eba mai. We'e 'atamananina 'wainega Iesu i maiga 'akonadi matatabuda ta 'asetai.” ");
INSERT INTO yml_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iesu i veve Vanuga 'Eba Velu'ui nageneye bonana bwaikinega tomotoga i vonedi i vo, 'Omi igodi 'wa vo 'wa da 'asetaku wata yaku 'eba mai 'wa da 'asetai. Yau a maiga, kebu tauniku yaku nuanuayega, 'aku tovetune nuanuana begaidi a mai. 'Aku tovetunenina yana nuanua 'atumai'avadi wata tonovidi, siwe 'omi kebu 'wa da 'asetai. ");
INSERT INTO yml_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","We'e yau a 'asetai fai i vetuneku wata 'wainega a mai.” ");
INSERT INTO yml_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yana vonanina faifaina nuanuadi i da 'ive'avini siwe kebu tamu aitoi 'ana fata, fai yana tutuya bola kebu i da veluagai. ");
INSERT INTO yml_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Avinodi tomotoga fuedi i vedumwe'ai'aieni, siwe wata tomotoga fuedi 'aila'anina nageneye i vetumagana Iesu 'waineye i vo, Ta 'asetai tutuyanina Keliso i na mai 'eba nuavogana wata 'eba nua'ewa fuedi i na 'idewadi. Vona mogitana de'e taunina Keliso, Yaubada 'ana Venua'ivina. Kebu tamu aitoi 'ana fata Iesu i na salai 'alo i na 'iaweni.” ");
INSERT INTO yml_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Diu totafalolo Falisi i nogai tomotoga 'ifwaidi i veve'awayaya i vo, Voke Iesu taunina Keliso.” Begaidi Falisinidi wata tovelomu yadi to'edakumetavo, Vanuga 'Eba Velu'ui 'ana tolumadu'aivo i vetunedi i nagoi Iesu i na 'ive'avini. ");
INSERT INTO yml_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Siwe Iesu i vonedi i vo, Tutuya 'ale'usana yau taiadi ta na miamia, mulieta a na nago 'aku tovetune 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","'Wa na lualeku siwe kebu 'wa na veluagaku wata kebu 'ana fata 'wa na waia yaku 'eba mia 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Me Diu to'edakumetavo 'aise'avadi i veifufu i vo, 'Wa da 'asetai ava'aibe bei igodi nuanuana i na nago? Voke i na nago mali 'awalawa 'waidie, bei yada 'aila'a me Diu i miamiani me Kuliki taiadi? Mulieta i na veve me Kuliki 'waidie. ");
INSERT INTO yml_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Fai i vo, 'Wa na lualeku siwe kebu 'wa na veluagaku,’ wata i vo, Kebu 'ami fata 'wa na wai yaku 'eba mia 'waineye.’ Awale bani'odi i voneyedi?” ");
INSERT INTO yml_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Me Diu yadi Sakali 'Ayavau 'ana 'aiata 'eba ve'a'ava, 'aiata bwaikina. 'Aiatanina 'waineye Iesu i tovoi i vegolegole i vo, 'Ai'edi aitoi 'anigona i lala, i da mai 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Aitoi i na vetumagana 'waikuye, 'ana fata i na mai bega i na yemu. Fai Yaubada yana Buki nageneye i voneyeni, i vo, Yana nuanua 'wainega ufa i na luluvuala-vebogi, ufanina 'wainega mia 'ivauna wata 'atumaina i sousouyeni.’” ");
INSERT INTO yml_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu i vonaga ufanina faifaina, 'ana 'aseta 'Anu'anunu Magemagetana, 'awaie Iesu 'ana tovetumaganavo i na agedi. Tutuyanina 'waineye Yaubada 'Anu'anununa bola kebu i da 'aniveleneni tomotoga 'waidie bega i na agedi, fai Iesu bola kebu i da laka abame yana 'ai'aiwabu 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","'Aila'anidi Iesu yana vona i nogai, 'ifwaidi i vo, Kumanina mogitana Yaubada yana tolu'ivonanina ta lulukamaseni.” ");
INSERT INTO yml_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","We'e 'ifwaidi i vo, No'o Keliso, Yaubada 'ana Venua'ivina.” Siwe 'ifwaidi i vo, Kebu, fai ta 'asetai Keliso kebu i na mai 'awalawa Galili 'wainega, siwe Iesu i mai 'awalawanina 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Basenadiotoga i kilumi Yaubada yana Buki nageneye, Keliso i na souyeni Kini Devida 'ana wauma 'wainega wata i na tubuga 'ana tuvadeye, 'atamana Bedeliema 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Bega 'aila'a i 'idia Iesu faifaina. ");
INSERT INTO yml_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","'Ifwaidi nuanuadi i na 'ive'avini, siwe kebu tamu aitoi i da 'abi tomogoneye. ");
INSERT INTO yml_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tolumadu'aivo i maia igodi Iesu 'ana 'ive'avina faifaina i viladi i nagoi Falisi wata tovelomu yadi to'edakumetavo 'waidie. To'edakumetanidi i velutoli i vo, Awale kebu Iesu 'wa da mieniga?” ");
INSERT INTO yml_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tolumadu'aivo i vo, Tomogo no'o yana vona 'adi nogaya 'atumaiotogidi, kebu tamu aitoi bani'odiga.” ");
INSERT INTO yml_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Falisi i velutoli i vo, Voke 'omi wata i vekaliemi? ");
INSERT INTO yml_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kebu tamu sai'afo 'ima yami to'edakumetavo 'waimega, 'alo Falisi i da vetumagana tomogonina 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","'Aila'anidi Iesu yana vona i noganogaiga, veimea Mosese 'wainega i bavuyedi, 'awaie 'adi vematavuloga i na veluagai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","To'edakumetanidi 'waidiega tamu 'ana wagava Nikodimo, kumanina basenadi i nago Iesu taiadi i veifufu. Enavo i vonedi i vo, Kebu i da lubwaineda yada ve'etoboda ta na geuya. Nagami Iesu i na vonayavuga 'waideye, 'ai'edi ma yana sakona, mulieta 'ana fata ta na veimea vematavuloga i na veluagai.” ");
INSERT INTO yml_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","I voneni i vo, Voke 'omu wata 'u mai Galiliega, Iesu taiadi ma fuemie bavubavumi. 'Ai'edi Yaubada yana Buki 'u da lu'iawawaga, 'u da 'asetai kebu tamu Yaubada yana tolu'ivona i da souyeni 'awalawa Galili 'wainega.” ");
INSERT INTO yml_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","I veifufu i 'a'avana, matatabudi i ve'iyavuyavulagi yadi 'atamane. ");
INSERT INTO yml_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Me Diu to'edakumetavo yadi ve'ikwayekwayega i 'a'ava, i nagoi yadi vanuge, we'e Iesu i laka 'Oya Olive. ");
INSERT INTO yml_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","I 'atai 'awa'awaiogose i vilai i mai Vanuga 'Eba Velu'ui 'waineye. 'Aila'a bwaikina i maia 'waineye bega Iesu i miabui i ve 'waidie. ");
INSERT INTO yml_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","We'e ve'etoboda 'adi tovevo wata totafalolo Falisi tamu vavine i miedi Iesu 'waineye. Vavinenidi 'ifwaidi tomotoga i 'isedi tamu tomogo tulina taiadi i veluaga bega i miedi Iesu wata 'aila'a bwaikina matadie. ");
INSERT INTO yml_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","To'edakumetanidi Iesu i voneni i vo, Tove, vavine de'e 'a miediga, mogitana i 'isedi tamu tomogo tulina taiadi i veluaga. ");
INSERT INTO yml_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Veimeanina i mai Mosese 'wainega i vonaga sauluvanina 'ana tutula i lubwaineni ta na lukileuya i na wafa. We'e 'omu yamu nuanua bani'odi?” ");
INSERT INTO yml_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","De'e bani'odi i voneyediga Iesu i sisiloloi, nuanuadi bonana i na nogai, 'ai'edi i na vekali 'adi fata i na 'ive'avini. Siwe Iesu kebu tamu ava'ai i da voneyeniga, i 'odumo fwayefwayeye nimanega i kilukiluma. ");
INSERT INTO yml_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bola i kilukiluma wata tovevitanidi i lulukwayegeni nuanuadi Iesu yadi vona i na tutuli, mulieta Iesu i tovoi i vonedi i vo, 'Atumaina, siwe aitoi 'waimiega kebu tamu tutuya i da sakonaga, kumanina nagami kileu i na 'ewai vavine i na nikedi.” ");
INSERT INTO yml_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wata i 'odu-vaitugana, i kilukiluma fwayefwayeye. ");
INSERT INTO yml_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tomotoga Iesu yana vonanina i nogai, 'aitamogana 'aitamogana i sousouyedi i degadega, we'e kumanidiavo 'au'auveadi nagami i souyedi. Tovevitanidi i nagoi we'e Iesu wata vavine taiadi i miamia. ");
INSERT INTO yml_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mulieta Iesu i tovoi vavine i vonedi i vo, Tomotoganidi i vevitamiga ava'aibe bei? Tamu aitoi 'waidiega i veimea 'wa na wafa?” ");
INSERT INTO yml_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Vavine i vo, 'Auvea kebu tamu aitoi.” Iesu i vonedi i vo, Yau wata kebu. 'Asa'aiana 'wa tauya, siwe kebu wata 'wa na sakosakona.” ");
INSERT INTO yml_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tomotoganidi i miamiani Vanuga 'Eba Velu'ui nageneye Iesu i vonedi i vo, Yau tomia fwayafwaya yami mageta. Egavo i na vetumagana 'waikuye yadi nuanua kebu dududubalidiga, siwe mia 'ivauna wata 'atumaina i na veluagai magetanina 'wainega.” ");
INSERT INTO yml_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Totafalolo Falisi i voneni i vo, Taunimu 'u awa'ai'aimu, kebu 'a na ve'awamogitana yamu vona faifaidi.” ");
INSERT INTO yml_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Wata Iesu i vonedi i vo, A vonaga tauniku faifaiku vona mogitana, fai a 'asetai ava'aiega a mai wata 'awaie a na nago 'waineye, we'e 'omi bega a maiga wata bei a na nagoga kebu 'wa da 'asetaiga. ");
INSERT INTO yml_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","16","Taunimi yami nuanuayega 'wa awavesakoyeku, kebu 'aseta mogitana 'wainega 'wa da vevenua'ivina. Yau kebu a da vevenua'ivinaga yami sakona faifaina, we'e 'ai'edi a na venua'ivinaga yaku venua'ivinanina mogitana tonovina, fai kebu 'aiseku yaku nuanuayega, Tamada 'aku tovetune i 'i'ivaiseku wata i labilabiniku. ");
INSERT INTO yml_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yami veimea kilukilumina i 'eno'eno i vo, 'Ai'edi tomotoga 'adi 'ailuga yadi lu'ivona i na vesala, i vona mogitana.’ ");
INSERT INTO yml_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wata yau bani'odi tauniku faifaiku a vonavona wata Tamada 'aku tovetune i vonavona faifaiku, 'ama 'ailuga yama nuanua i vesala bega vona mogitana.” ");
INSERT INTO yml_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Falisinidi Iesu i velutolieni i vo, Ava'aibe bei tamamu?” Iesu i vo, 'Wa bavuyekuga wata Tamaku 'wa bavuyeni. 'Ai'edi 'wa da 'asetakuga, Tamaku wata 'wa da 'asetai.” ");
INSERT INTO yml_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","De'e Iesu yana ve Vanuga 'Eba Velu'ui nageneye, 'anivelena-maimaiga 'ana 'eba yato lilivaneye. Kebu tamu aitoi i da 'ive'avini, i lubwaineni bei i na 'ive'aviniga 'ana tutuya bola. ");
INSERT INTO yml_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu tomotoganidi i vonedi i vo, A na tauya a na nago siwe 'wa na luala-wayogeku, 'wa na wafa yami sakona i na 'eno-vagata Yaubada kebu i na nuatavunidi. Bei a na nagoga kebu 'ami fata 'wa na waia.” ");
INSERT INTO yml_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Vonanina me Diu to'edakumetavo i nogaiga 'aise'avadi i vona i vo, Voke taunina i na luvewafai fai i vo, Bei a na nagoga kebu 'ami fata 'wa na waia.’” ");
INSERT INTO yml_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Wata Iesu i vonedi i vo, 'Omi de'e bega 'wa souyemi, we'e yau tabwanega a mai. Yami 'eba mia fwayefwayeye we'e yau abamayega a obuma. ");
INSERT INTO yml_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Faifainanina a vo, 'Wa na wafa yami sakona i na 'eno-vagata kebu Yaubada i na nuatavunidi.’ Yau Yaubada 'ana Venua'ivina, 'ai'edi kebu 'wa na vetumagana 'waikuye, tutuyanina 'wa na wafa, yami sakona i na 'eno-vagata.” ");
INSERT INTO yml_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Begaidi i velutolieni i vo, Nuanuama 'a na 'asetamu, 'omu aitoi?” Iesu yadi velutoli i tutuli i vo, Tutuya fuedi a lulu'ivoneyeku 'waimie, siwe 'asa'aiana bani'odi. ");
INSERT INTO yml_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'Ai'edi nuanuaku, 'aku fata nani fuedi yami sakona faifaidi a da lu'ivoneyedi wata a da awavesakoyemi, siwe 'aku tovetune ava'ai i vonekuga, 'aisedi a lulu'ivoneyedi tomia fwayafwaya matatabumi 'waimie. 'Aku tovetunenina yana nuanua wata yana sauluva tonovidi, 'ada fata ta na vetumagana yana vona 'waidie.” ");
INSERT INTO yml_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Siwe tomotoganidi kebu i da 'asetaiga, Iesu i vonavona Tamana faifaina, taunina 'ana tovetune. ");
INSERT INTO yml_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Begaidi wata Iesu i vonedi i vo, De'e 'wa bavuyeku, siwe tutuyanina yau a vetomotogaotoga 'wa na silakaiku 'ai lagalagana 'waineye bei 'wa na 'asetaku yau Yaubada 'ana Venua'ivina. Wata bei 'wa na 'asetai kebu tamu sai'afo tauniku yaku nuanuayega a da folofolova, siwe ava'ai 'akonadi Tamada i vonekuga bani'odi a vonevoneyedi. ");
INSERT INTO yml_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Fai tutuya fuedi 'aku tovetunenina yana nuanua a 'i'idewadi i sososoana faifaiku, begaidi kebu tamu tutuya i da bailekuga i labilabiniku.” ");
INSERT INTO yml_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tomotoga fuedi Iesu yana vona i nogai i vetumagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","32","Iesu i veifufu tomotoganidi i vetumagana 'waineye i vo, 'Ai'edi yaku ve 'wa na vevematayakeyakedi, 'omi yaku tovetutuyamavo mogitana, bega Yaubada 'ana 'aseta mogitana 'wa na 'asetai, nika 'asetanina i na yavumi sakona yana veimea 'wainega.” ");
INSERT INTO yml_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Me Diu to'edakumetavo i vona Iesu 'waineye i vo, 'Ima Ebelamo tubunavo, kebu tamu tutuya 'a da vetofolova-maimaiga tamu tomogo 'waineye. Awale 'u vo, I na 'etoyavumi?’” ");
INSERT INTO yml_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Wata Iesu i vonedi i vo, A vona mogitana 'waimie, egavo i sakosakonaga, sakonanina i veveimeyedi. ");
INSERT INTO yml_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tofolova-maimaiga kebu mogitana 'ana toveimea yana 'aila'a nageneye, we'e mogitana natuotogina, yana 'aila'a nageneye i na mia-vagata. ");
INSERT INTO yml_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","'Omi sakona yana tofolova-maimaiga, siwe 'ai'edi yau Yaubada Natuna a na 'etoyavumi 'omi mogitana yavuyavumi. ");
INSERT INTO yml_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A 'asetai 'omi Ebelamo tubunavo, siwe 'ifwaimi nuanuami 'wa na luvewafaku fai yaku ve 'wa vedumwe'ai'aiedi. ");
INSERT INTO yml_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Naninidi a 'isedi Tamaku 'waineye, a veveifufuyedi 'waimie, we'e 'omi ava'ai nuanuami 'wa na 'idewaiga 'waikuye fai tamami sakoina i vonemi.” ");
INSERT INTO yml_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Me Diu to'edakumetavo Iesu yana vona i tutuli i vo, 'Ima tamama Ebelamo.” Iesu i vo, 'Ai'edi mogitana 'omi natunavo, yana sauluva 'atumaidi 'wa da vevetutuyamedi. ");
INSERT INTO yml_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Siwe yami sauluva tulina, kebu Ebelamo bani'odi. Nuanuami 'wa na luvewafaku fai Yaubada yana veifufu mogitana a nogai 'wainega, a lu'ivona 'waimie. ");
INSERT INTO yml_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","'Omi kebu Ebelamo natunavo, we'e tamami mogitana yana sauluva sakoidi 'wa 'ewadi.” To'edakumetanidi i vo, 'Ima kebu 'eda natunavo. Matatabuma tamama 'aitamogana, taunina Yaubada.” ");
INSERT INTO yml_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu i vonedi i vo, 'Ai'edi Yaubada mogitana tamami, 'wa da nuakalikalieku fai yau Yaubada 'wainega a mai, taiadi ta miamia. Kebu tauniku yaku nuanuayega a da mai, Yaubada i vetuneku. ");
INSERT INTO yml_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Fai yaku vona kebu nuanuami 'wa na nogai, begaidi ava'ai a voneyediga 'wa bavuyedi. ");
INSERT INTO yml_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","'Omi Seitani natunavo, nuanuami yana nuanua sakoidi 'waidie taunimi 'wa na tautauyemi. Tutuya 'eba velamu 'wainega i maiga 'asiau Seitani kumanina toluvewafa, kebu tamu sai'afo yana vona tonovina, naninidi tonovidi matatabuna i vevedumwe'ai'aiedi. Tutuya fuedi vekaliega i vonavona fai 'asa'aiana bani'odi yana sauluva, wata vekali matatabuna taunina lamudi. ");
INSERT INTO yml_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yaku veifufu 'waimie vona mogitana, begaidi kebu 'wa da vetumaganeku. ");
INSERT INTO yml_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kebu tamu aitoi 'waimiega 'ana fata i na vevitaku sakona faifaina. Yaku veifufu 'waimie vona mogitana, begaidi i lubwainemi 'wa da vetumagana 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Egavo tamadi Yaubada, kumanidiavo yana veifufu 'ana tonogaya, siwe 'omi kebu Yaubada yana 'Aila'a nageneye, begaidi kebu nuanuami yana vona 'wa na nogai.” ");
INSERT INTO yml_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Me Diu to'edakumeta Iesu yana vona i tutuli i vo, Basenadi 'a vonaga, 'asiau 'ana mogitana i souyeni 'a vo, 'Omu yaiaina i agemu bega 'wava'wavamu, wata 'omu bani'odi tomogo Samelia sakoina.’” ");
INSERT INTO yml_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu i vonedi i vo, Yau kebu yaiaina i da agekuga. Tamaku a veve'ililibuyeni, we'e 'omi kebu 'wa da veve'ililibuyekuga. ");
INSERT INTO yml_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kebu tauniku 'aku awa'ai'ai faifaina a da nuanua. We'e mogitana 'awaie Yaubada i na awa'ai'aiku, kumanina tomotoga i na vonayavuga 'waineye bega i na veimeyedi vematavuloga faifaina. ");
INSERT INTO yml_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A vona mogitana 'waimie, egavo yaku vona i na vevematayakeyakediga kebu i na wafaotoga, i na mia-vagata.” ");
INSERT INTO yml_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Me Diu i voneni i vo, 'U vevekali, vona mogitana yaiaina i agemu. Basenadiotoga Ebelamo wata Yaubada yana tolu'ivonavo i wafa, we'e 'omu 'u vo, 'Ai'edi egavo yaku vona i na vevematayakeyakediga kebu i na wafaotoga, i na mia-vagata.’ ");
INSERT INTO yml_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tubuda Ebelamo 'omu kebu bani'odiga, taunina tomogo bwaikina siwe i wafa tolu'ivonavo taiadi. 'Omu 'wa da vo bwaikaotogimu begaidi bani'odi 'u vonevoneyedi.” ");
INSERT INTO yml_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu i vonedi i vo, 'Ai'edi tauniku a da awa'ai'aiku 'ana nogaya nani-'avo'avovo. Tamaku, kumanina igodi 'wa vo, Yama Yaubada,’ taunina 'aku toawa'ai'ai. ");
INSERT INTO yml_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kebu tamu sai'afo Yaubada 'wa da 'aseta-tonovi, we'e yau a 'asetai. 'Ai'edi a da vo, Kebu a da 'asetaiga,’ a da vekali, bani'odi 'omi yami sauluva. Siwe a 'asetai wata yana vona a vevematayakeyakedi. ");
INSERT INTO yml_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Basenadiotoga yaku mai 'ana tutuya tubumi Ebelamo i nuanimo nika i sosoana, siwe 'akonadi i 'iseni i sosoana-'afo'afo.” ");
INSERT INTO yml_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Me Diu Iesu i voneni i vo, 'Omu bola kebu 'amu malamala 50 i da veluagai, we'e Ebelamo 'u 'iseni? 'A nuani kebu tamu sai'afo 'u da 'isa-tonovi.” ");
INSERT INTO yml_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu i vo, A vona mogitana 'waimie, bola Ebelamo kebu i da tubugaga, yau miamia-vagaiku.” ");
INSERT INTO yml_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Me Diu yana vona i nogai i nuasako, kileu i 'ewadi nuanuadi i da luvewafai, siwe Iesu i giva tomotoga 'awasasadie mulieta Vanuga 'Eba Velu'ui 'wainega i souyeni. ");
INSERT INTO yml_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tamu tutuya Iesu wata yana tovetutuyamavo taiadi i nunagoi, nika tamu tomogo ma mata'uluna inana kamodiega i tubuga i 'iseni. ");
INSERT INTO yml_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Begaidi Iesu yana tovetutuyamavo i velutolieni i vo, Tove, aitoi yana sakona 'wainega ma mata'uluna i tubuga? Taunina 'alo inana tamana taiadi?” ");
INSERT INTO yml_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu i vonedi i vo, Yana vematasako kebu yana sakona 'wainega, 'alo inana tamana taiadi yadi sakona 'waidiega. I vematasakoga bega Yaubada yana toketokena 'wainega i na ve'atumai tomotoga i na 'iseni. ");
INSERT INTO yml_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","I lubwaineda tutuya safailina 'waineye 'aku tovetune yana folova ta na 'i'idewadi, we'e tutuya vitana i na souyeniga bani'odi dudubala, kebu tamu aitoi 'ana fata i na folova. ");
INSERT INTO yml_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tutuyanina a na miamia fwayefwayeye, yau tomia fwayafwaya yami mageta.” ");
INSERT INTO yml_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iesu i vona'a'ava, i kiwala fwayefwayeye, fwayafwayanina i 'ewai nimaneye i luogoi mulieta tomatasako matana i 'abidi. ");
INSERT INTO yml_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","I voneni i vo, Nuanuaku 'u na nago Ufa Sailoama 'waineye maigimu 'u na lekoai.” Ufanina Sailoama 'ana saivila, Vetune. Bega tomogonina i nago maigina i lekoai nika i 'isala, i vilai i mai. ");
INSERT INTO yml_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tomogonina matana i ve'atumaiga, enavo wata 'ifwaidi tomotoga basenadi tomogonina i 'iseni i talavelu'ui mani faifaina, 'aise'avadi i velutolitoli i vo, 'Wa da nuani, voke kumanina side bei i miamia i tatalavelu'ui?” ");
INSERT INTO yml_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tomotoga 'ifwaidi i vo, 'Asa'aiana kumanina,” we'e 'ifwaidi i vo, Kebu, no'o tulina siwe 'ana 'isa'isa.” Siwe tomogonina matana i ve'atumaiga i vo, 'Asa'aiana yau kumaniku.” ");
INSERT INTO yml_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tomotoga i velutolieni i vo, Bani'odi matamu i munega i ve'atumai?” ");
INSERT INTO yml_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","I vonedi i vo, Tamu tomogo 'ana wagava Iesu dobwadobwana i 'idewai mataku i 'abidi i 'a'avana i voneku i vo, Nuanuaku 'u na nago Ufa Sailoama 'waineye, bei maigimu 'u na lekoai.’ Bega a nago maigiku a lekolekoaiga nika a 'isala.” ");
INSERT INTO yml_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wata i velutolieni i vo, Tomogonina matamu i 'ive'atumaidiga, ava'aibe?” I vo, Aigodi.” ");
INSERT INTO yml_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bega tomotoga iadinina matana i ve'atumaiga i vagavaia i naweni totafalolo Falisi 'waidie. ");
INSERT INTO yml_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","We'e 'aiatanina 'waineye Iesu dobwadobwana i 'idewai tomogo i 'ive'atumaiaga, me Diu yadi 'Aiata Veawai 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bega Falisinidi tomogo i velutolieni i vo, Matamu bani'odi i munega i ve'atumai?” I vonedi i vo, Iesu dobwadobwanayega mataku i 'abidi, mulieta maigiku a lekoai nika a 'i'isadewa.” ");
INSERT INTO yml_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Falisi 'ifwaidi i vo, Tomogo de'e bani'odi i folovayediga 'ana 'isa kebu taunina Yaubada 'wainega, fai 'Aiata Veawai 'waineye i folova, yada ve'etoboda i geuya.” Siwe 'ifwaidi i vo, 'Ai'edi taunina tosakonaga kebu tamu sai'afo 'ana fata folova toketokedi i da 'i'idewadi.” Nika 'aise'avadi 'aila'a i 'idia. ");
INSERT INTO yml_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wata Falisi i velutoli-vaitugana tomogo 'waineye i vo, 'U vonaga Iesu matamu i 'ive'atumaidi, we'e 'u da nuaniga yana toketokena ava'aiega i veluagai?” Yadi velutoli i tutuli i vo, Taunina tamu Yaubada yana tolu'ivona.” ");
INSERT INTO yml_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","Me Diu to'edakumetavo kebu i da vetumagana fai i nuani igodina basenadi matana kebu i da sakoga, begaidi inana wata tamana taiadi i vonedi i maia i velutoliedi i vo, De'e natumi? Mogitana ma mata'uluna i tubuga? Bani'odi i munega i 'i'isadewa?” ");
INSERT INTO yml_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Inana wata tamana i vo, Mogitana de'e 'ima natuma wata 'a 'asetai ma mata'uluna i tubuga. ");
INSERT INTO yml_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Siwe matana yadi ve'atumai wata aitoi i 'ive'atumaidiga kebu 'a da 'asetadiga. Taunina 'wa na velutolieni, fai tulaina 'ana fata i na vonemi.” ");
INSERT INTO yml_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Inana wata tamana bani'odi i voneyediga fai i kololo me Diu to'edakumetavo 'waidie. Basenadi yadi veimea i kiavefa'ali i vo, 'Ai'edi aitoi i na vo, Iesu taunina Yaubada 'ana Venua'ivina,’ 'a na talabodeni kebu taiadi 'a na lukuluku 'eba miava'auta nageneye tafalolo faifaina.” ");
INSERT INTO yml_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Faifainanina inana wata tamana i vona i vo, Taunina 'wa na velutolieni, fai tulaina 'ana fata i na vonemi.” ");
INSERT INTO yml_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wata me Diu i vona-vaitugana tomogonina matana i ve'atumaiga i mai i voneni i vo, Nuanuama 'u na vona Yaubada mataneye kebu 'u na vekaliga, fai 'a 'asetai tomogonina Iesu, tosakona.” ");
INSERT INTO yml_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tomogo i vo, Aigodi tosakona 'alo kebu, siwe tamu nani a 'asetai, basenadi mataku 'uludi, siwe 'asiau mataku i ve'atumai nika a 'isa'isa.” ");
INSERT INTO yml_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wata i velutolieni i vo, Bani'odi i munegimu? Wata bani'odi i munega matamu i siayegidi?” ");
INSERT INTO yml_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","I vonedi i vo, 'Akonadi a lu'ivona 'waimie, siwe kebu nuanuami bonaku 'wa na nogai. Awale nuanuami a na vona-vaivaitugana? 'Alo nuanuami 'omi wata Iesu yana tovetutuyamavo?” ");
INSERT INTO yml_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ma yadi nuasako i yagaia i vo, 'Omu 'aisemu kumanina 'ana tovetutuyama, 'ima Mosese yana tovetutuyamavo. ");
INSERT INTO yml_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","'A 'asetai Yaubada i vona Mosese 'waineye, we'e tomogonina kebu tamu sai'afo 'a da 'asetai ava'aiega i mai.” ");
INSERT INTO yml_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tomogonina matana i ve'atumaiga i vonedi i vo, Nuaku i vogani yami bavu faifaina. Yana toketokena 'wainega mataku i ve'atumai siwe kebu 'wa da 'asetaiga ava'aiega i mai. ");
INSERT INTO yml_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Fai ta 'asetai Yaubada tosakona bonadi kebu i na nogai, siwe egavo i 'odu'odu wata i vevematayakeyakeni bonadi i noganogaidi. ");
INSERT INTO yml_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Fwayafwaya 'ana 'idewadewavau 'wainega i maiga 'asiau, kebu tamu aitoi 'ana fata tomatasako inana kamodiega i na 'ive'atumaia. ");
INSERT INTO yml_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","'Ai'edi Iesu kebu i da maiga Yaubada 'wainega wata 'ako kebu bani'odi i da folovediga.” ");
INSERT INTO yml_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yana vona i tutuli i vo, 'Omu tosakona, inamu wata tamamu yadi sakona 'wainega 'u tubuga, igodi nuanuamu 'u na ve 'waimeye.” De'e bani'odi i voneyedi i 'a'ava, i 'ive'avini i tufelefeleni i souyeni 'eba miava'auta 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu vala i nogai Falisi tomogonina matana i ve'atumaiga i bifelefeleni 'eba miava'auta 'wainega bega i nago i veluagai i velutolieni i vo, Kumanina i vetomotogaotoga, 'waineye 'u vetumagana 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tomogo i vo, 'Auvea, aitoi tomogoga? 'U voneku bega a na vetumagana 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu i voneni i vo, 'Akonadi 'u 'iseni, 'asa'aiana taunina taiadi 'u veveifufu.” ");
INSERT INTO yml_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tomogo i vona Iesu 'waineye i vo, 'Auvea, a vetumagana 'waimuye.” I vona nika ma yana subia i 'odu mataneye. ");
INSERT INTO yml_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu i vo, Yau a maiga fwayefwayeye tomotoga a na 'ididi, bega egavo yadi nuanua dudubalidi 'wa da vo i da vematasako, 'anu'anunudi matadi a na 'ive'atumaidi, we'e egavo igodina 'anu'anunudi matadi 'atumaidi a na 'ive'uludi.” ");
INSERT INTO yml_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Falisi ma fuedie i tovotovoi i nogai Iesu yana vona begaidi i velutolieni i vo, 'U vonavonaga 'ima wata matama 'uludi?” ");
INSERT INTO yml_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu i vonedi i vo, 'Ai'edi mogitana yami nuanua i vematasako, Yaubada kebu 'ana fata i na vematavulogimi yami sakona faifaidi fai bavubavumi. Siwe fai 'wa vonaga 'wa vo, Matama 'atumaidi nani matatabuna 'a 'asetadi,’ begaidi yami sakonanidi i na 'eno'eno.” ");
INSERT INTO yml_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Wata Iesu i vonedi i vo, A vona mogitana 'waimie, to'isave'avina sifi 'aiaseye yana 'aisaya 'adi mosomoso i veve'anidi, lovane i vevedodogidi 'adi kalie, bei wata i 'i'isave'avinidi. 'Ai'edi to'isave'avinanina nuanuana i na lukuga, 'awa 'waineamo i lukuluku, we'e 'ai'edi tamu aitoi kebu 'awa 'waineamo i na lukuga kaliamo i na nakikila, taunina to'ainike wata tovainago. ");
INSERT INTO yml_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tutuyanina to'isave'avina sifi nuanuana yana 'aisaya i na nawedi, 'awa 'ana to'isave'avina i vonevoneni saiboda i sisibaleni, mulieta to'isave'avinanina yana sifi 'aitamogana 'aitamogana 'adi wagaveamo i tayatayamidi. ");
INSERT INTO yml_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tutuyanina i sousouyedi to'isave'avina i kumekumeta we'e yana 'aisaya mulineye i delideli fai bonana i nogaya'inanai. ");
INSERT INTO yml_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","'Aisayanidi kebu 'adi fata tamu tomogo mulineye i na nagoi, bola bonana i na bavuyeni i na ve'aladegadega.” ");
INSERT INTO yml_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","De'e vona-awatabainina 'wainega Iesu i veifufu 'waidie, siwe kebu nuadi i da magetadi. ");
INSERT INTO yml_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Begaidi Iesu i vo, A vona mogitana 'waimie, yau sifi 'adi kali 'ana 'awa. ");
INSERT INTO yml_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Basenadi mali tomotoga nuanuadi i na veto'isave'avina igodina taunidi i da mai Yaubada 'wainega, tomotoganidi tovainago wata to'ainike, begaidi yaku sifi kebu bonadi i da nogaya'inanadi. ");
INSERT INTO yml_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","'Asa'aiana kumaniku 'awa. Egavo i na vetumagana 'waikuye, i na luku 'waikuyeamo a na 'ita'ita'iedi wata a na 'i'isave'avinidi bani'odi to'isave'avina sifi yana 'aisaya i nunawedi i veve'anidi wata i mimaiedi 'adi kalie. ");
INSERT INTO yml_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tovainago i na maiga, vainago'ava, 'ainike'ava, 'ivesako 'aisedi faifaidi i na mai. Yau a maiga tomotoga mia 'ivauna wata 'atumaina a na veledi bega i na sososoana, wata kebu tamu nani faifaina i na vevenuafouviga.” ");
INSERT INTO yml_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Wata Iesu i vonedi i vo, Yau to'isave'avina sifi 'atumaiku, begaidi yawaiku a na tauyeni a na wafa yaku sifi 'adi 'ita'ita'i faifaina. ");
INSERT INTO yml_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","'Ai'edi tamu tomogo i na vetofolova sifi i na 'i'isave'avinidi, fai taunina kebu tonisifi 'ai'edi 'ou'ou kasikasisina i na 'iseni i na mimaiga bola i na degalovedi, 'ou'ounina kasikasisina sifi i na ovadi i na ve'aladegadega. ");
INSERT INTO yml_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tofolovanina i dega fai taunina kebu tonisifi, begaidi kebu faifaidi i da vetafewa i folovamo tutula faifaina. ");
INSERT INTO yml_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Yau to'isave'avina sifi 'atumaiku. Tamada i 'asetaku wata yau a 'asetai, wata bani'odi yaku sifi a 'asetadi wata i 'asetaku. Fai taunidi yaku sifi, yawaiku a na tauyeni a na wafa 'adi 'ita'ita'i faifaina. ");
INSERT INTO yml_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","We'e 'ifwaidi yaku sifi tulidie i miamiani, kebu de'e kalinina nageneye. I lubwaineku kumanidiavo wata a na miedi, 'adi fata bonaku i na nogai, a na luvetubamidi 'aila'a 'aitamogana we'e 'adi to'isave'avina 'aitamogana. ");
INSERT INTO yml_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamaku i nuakalikalieku bwaikina fai tauniku a tauyeku 'awaie a na wafa, siwe wafanina 'wainega wata yawaiku a na veluaga-vaitugani. ");
INSERT INTO yml_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kebu tamu aitoi 'ana fata yawaiku i na dabai, yau taunikuna a na tauyeni. Fai ma yaku veimea wata ma yaku toketokena 'aku fata yawaiku a na tauyeni, wata 'aku fata yawaikunina a na veluaga-vaitugani. Tamaku yana veimea 'waikuye side bani'odi.” ");
INSERT INTO yml_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iesu i vona'a'ava, mulieta vonanina faifaina me Diu 'aila'a wata i 'idia. ");
INSERT INTO yml_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Fuedi i vona i vo, Vona mogitana yaiaina i agei i ve'wava'wava. Kebu bonana 'wa na nogai.” ");
INSERT INTO yml_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","We'e 'ifwaidi i vo, Iesu yana vona 'ana nogaya kebu bani'odi tomogo yaiaina i ageiga yana vona. Yaiaina kebu 'ana fata tomatasako i na 'ive'atumaia Iesu i 'idewaiga bani'odi.” ");
INSERT INTO yml_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Malayaubanie me Diu fuedi i va'auta Ielusalema tamu sakali i 'idewai. Sakalinina 'adi 'eba tolinuata'i wata yadi 'eba nuave'avina, basenadi mali tomotoga yadi Vanuga 'Eba Velu'ui i 'ivesakoi we'e i 'idewa-vaitugani faifaina. ");
INSERT INTO yml_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tutuyanina 'waineye Iesu i nago Vanuga 'Eba Velu'ui 'waineye, i yabayaba Kini Solomoni yana Masi'eda 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Me Diu i 'iseni i maia i tovififineni i voneni i vo, Tutuya manamanawena 'a vevenuanaluga yamu vona faifaidi. 'Asiauotoga nuanuama 'u na vona tonovina 'waimeye, mogitana 'omu Keliso Yaubada 'ana Venua'ivina 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","26","Iesu i vo, 'Akonadi a vonemi siwe kebu 'wa da vetumaganekuga. Folovanidi toketokedi a 'i'idewadiga Tamaku yana veimea 'wainega, 'wa da 'isedi 'wa da 'asetai yau a mai Yaubada 'wainega, siwe kebu 'wa da vetumagana fai 'omi kebu yaku sifi. ");
INSERT INTO yml_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yaku sifi mogitana bonaku i noganogai, 'aitamogana 'aitamogana a 'asetadi wata i yoyogo'wailiku. ");
INSERT INTO yml_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","29","Mia 'atumaina wata miamia-vagaina a veleveledi bega kebu i na wafaotoga. Kebu tamu aitoi 'ana fata i na 'iaweloveku, fai Tamaku kumanina sifinidi i velekuga toketokeotogina, tomotoga 'ifwaidi kebu bani'odiga. Kebu tamu aitoi 'ana fata i na sieloeloku Tamada yana 'isave'avina 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tamada wata yau, 'asa'aiana 'aitamogana.” ");
INSERT INTO yml_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Vonanina faifaina me Diu kileu i 'ewadi igodi i da luvewafai basenadi bani'odi. ");
INSERT INTO yml_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Siwe Iesu i vonedi i vo, Folova fuedi 'atumaidi wata toketokedi a 'i'idewadi, Tamada yana awave'eda'eda 'wainega. Folovanidi 'waidiega, ava'ai folovaga faifaina 'wa 'i'ikasikasisi bega 'wa na nikeku?” ");
INSERT INTO yml_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Me Diu Iesu yana vona i tutuli i vo, Yamu folova 'atumaidi faifaidi 'ako kebu 'a da nikemuga, siwe fai 'u vona-uvi'agala Yaubada 'waineye. 'Omu tomogo-'avo'avovo siwe igodi 'u vo, Yau Yaubada.’” ");
INSERT INTO yml_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu i vonedi i vo, Basenadiotoga i kilumi Yaubada yana Buki nageneye, bukinina 'wa veve'ililibuyeni bwaikina, Yaubada i vona toveimea i venua'ivinediga 'waidie i vo, 'Omi tomotoga 'asa'aiana taunimi yaubadanimi.’ ");
INSERT INTO yml_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","'Akonadi ta 'asetai Yaubada yana Buki i na 'eno-vagata wata kebu tamu sai'afo vekali nageneye, we'e toveimeanidi Yaubada yana Vona i nogai, Yaubada i goledi yaubadavo. ");
INSERT INTO yml_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yaubada tomotoga i fali-yaubadedi, we'e yau a vo, Yau Yaubada Natuna,’ i lubwaineku fai i venua'ivineku i vetuneku a mai tomia fwayafwaya 'waimie, begaidi kebu a da vona-uvi'agala Yaubada 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","'Ai'edi Tamaku yana folova kebu a da 'i'idewadiga, i lubwainemi kebu 'wa da vetumagana 'waikuye, siwe fai Tamaku yana folova a 'i'idewadi i lubwainemi 'wa na vetumagana 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kebu nuanuami 'wa na vetumagana 'waikuye, siwe fai folovanidi toketokedi a 'i'idewadiga, i lubwainemi 'wa na vetumaganedi bega 'wa na 'aseta-'atumaia, yau Tamada 'ana labilabina wata Tamadanina i labilabiniku.” ");
INSERT INTO yml_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iesu yana veifufunina faifaina, to'edakumetavo igodi i da 'ive'avini basenadi bani'odi, nika i 'iawedi i nago. ");
INSERT INTO yml_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iesu i vilai i damana Ufa Iolidani vi'ainega i miamia, basenadi bei Ioni tomotoga i bafitaisodi. ");
INSERT INTO yml_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tomotoga fuedi i maia Iesu 'waineye, 'aise'avadi i veifufu i vo, Ioni kebu tamu folova toketokena i da 'idewai, siwe nani matatabuna basenadi i veifufuyediga Iesu faifaina, 'akonadi 'adi mogitana i souyedi.” ");
INSERT INTO yml_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Begaidi tomotoga fuedi i vetumagana Iesu 'waineye taunina Yaubada 'ana Venua'ivina. ");
INSERT INTO yml_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","3","Tamu tomogo 'ana wagava Lasalo ma novunavo Meli wata Malida i miamia 'atamana Bedani. Meli kumanina 'Auvea Iesu 'agena i iwagi bunama magaina 'atumaina 'wainega wata nava'aunega i tamavelavelalai. Tamu tutuya Lasalo i viga bwaikina begaidi novunavo vala i vetunei Iesu 'waineye i vo, 'Auvea, iamu kumanina 'u nuakalikalieni i viga bwaikina.” ");
INSERT INTO yml_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tutuyanina Iesu valana i nogai i vona i vo, Viganina i souyeniga Lasalo 'waineye kebu wafaotoga faifaina, siwe i souyeni bega tomotoga fuedi Yaubada i na subiai, wata 'wainega yau Natuna i na awa'ai'aiku.” ");
INSERT INTO yml_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Lasalo ma novunavo Iesu i nuakalikaliedi bwaikina, begaidi tutuyanina i nogai Lasalo i viga kebu i da nago 'waineye, 'atamananina 'waineye i valenogaya bei wata 'aiata 'ailuga i mia. ");
INSERT INTO yml_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","'Aiatanidi 'adi 'ailuga i 'a'avana, mulieta yana tovetutuyamavo i vonedi i vo, Ta na vilada ta na nagoi Iudia.” ");
INSERT INTO yml_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yana tovetutuyamavo i vo, Tove, basenadi bei me Diu igodi i da lukileumu 'u da wafa, wata igodi nuanuamu bei 'u na nago.” ");
INSERT INTO yml_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu i vonedi i vo, 'Akonadi 'wa 'asetai 'aiata 'ana 'awasasa matatabuna 12. 'Awasasanidi 'waidie ta na yabaga kebu 'ana fata ta na nikeyeda fai fwayafwaya 'ana mageta 'wainega ta 'i'isadewa. ");
INSERT INTO yml_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Siwe 'ai'edi ta na yaba-vuvua lovane, bola ta na nikeyeda fai mageta kebu. Bola yaku tutuya 'atumaina i 'eno'eno, 'aku fata a na folofolova. ");
INSERT INTO yml_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iada Lasalo i 'enomwadumwadu, siwe ta na nagoi a na luvagoni i na 'isa.” ");
INSERT INTO yml_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yana tovetutuyamavo i vo, 'Auvea, 'ai'edi i na 'eno'enovamo 'ana fata i na ve'atumai.” ");
INSERT INTO yml_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Siwe Iesu i vonavona i wafaga faifaina, we'e yana tovetutuyamavo yadi nuanua i vo, 'Eno mogitana faifaina i vonavona.” ");
INSERT INTO yml_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Begaidi Iesu i vonaotoga 'waidie i vo, Lasalo i wafa, siwe 'ai'edi taiadi ta da miamia a da 'ive'atumaia viga 'aisena 'wainega bola yami vetumagana mweadi. 'Atumaina, ta na nagoi 'waineye yaku folova 'wa na 'iseni bega yami vetumagana i na vetoketoke.” ");
INSERT INTO yml_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi, tamu 'ana wagava Natulugaluga tovetutuyamavo 'ifwaidi i vonedi i vo, Ekwavo, ta na nagoi yada 'Auvea taiadi bega ma fueda ta na wafa.” ");
INSERT INTO yml_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tutuyanina Iesu yana tovetutuyamavo taiadi i le'wai Bedani lilivaneye, tomotoga i vonedi i vo, Lasalo yawaina i 'a'ava, taumaseye i 'eno'eno 'akonadi 'aiata 4 i 'a'ava.” ");
INSERT INTO yml_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Ielusalemayega ta na nago Bedani kebu 'ani'iega, vivideye begaidi me Diu fuedi i maia Bedani, Malida ma taina Meli nuadi i na 'iveoloolodi, novudi i wafaga faifaina. ");
INSERT INTO yml_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tutuyanina Malida vala i nogai Iesu i mimai, bega i nago i yogo'ede'edeni, we'e Meli i miamia vanuge. ");
INSERT INTO yml_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malida Iesu i veluagai i voneni i vo, 'Auvea, 'ai'edi 'omu taiadi ta da miamiaga 'ako novuku kebu i da wafa. ");
INSERT INTO yml_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mogitana novuku i wafa, siwe a 'asetai ava'ai nuanuamu 'u na velu'ui Yaubada 'waineye i na velemu bega 'aivaita 'a na veluagai.” ");
INSERT INTO yml_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu i voneni i vo, Novumu i na tovoi-vaitugana.” ");
INSERT INTO yml_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malida i vo, E'e, 'akonadi a 'asetai 'awaie fwayafwaya 'ana 'eba ve'a'ava 'waineye i na tovoi-vaitugana.” ");
INSERT INTO yml_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Wata Iesu i voneni i vo, Yau kumaniku towafa 'adi tosivetovoi wata mia-vagata 'ana to'anivelena. 'Ai'edi egavo i na vetumagana 'waikuye mulieta i na wafa, siwe mia 'atumaina wata miamia-vagaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Egavo i na vetumagana 'waikuye, wata yau taiadi 'a na miave'itubama, kebu tamu sai'afo i na wafaotoga. Malida, yaku vona de'e 'u da nuani, 'u vetumagana 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Malida i vo, E'e 'Auvea, yamu vonanina faifaina a vetumagana wata a 'asetai 'omu Keliso, Yaubada Natuna wata 'ana Venua'ivina, kumanimu basenadi Yaubada i vona'awaufaufa yamu mai fwayefwayeye faifaina.” ");
INSERT INTO yml_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Malida i vona'a'ava, nika i vilai i nago Meli 'waineye 'aise'avadi i veifufu i vo, Tove 'akonadi i mai, nuanuana 'u na nago i na vonemu.” ");
INSERT INTO yml_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Bega Meli i tovoi i lilide i mai Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesu bola kebu i da souyeni 'atamane, ava'aibe bei Malida i veluagaiga bei bola i tovotovoi. ");
INSERT INTO yml_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Me Diu i maiaga Meli ma iana 'adi 'iveoloolo faifaina, tutuyanina i 'iseni Meli i tovoi i souyeni i lilide i nunago yadi nuanua i vo 'ako i nunago taumaseye i na vemogai, begaidi i yogo'waili. ");
INSERT INTO yml_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tutuyanina Meli i le'wa ma yana ve'ililibu i lumata'afufu Iesu 'ageneye i voneni i vo, 'Auvea, 'ai'edi 'omu taiadi ta da miamiaga, 'ako kebu novuku i da wafa.” ");
INSERT INTO yml_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesu Meli i 'iseni me Diu taiadi i vevemogai nuana i vekalikalia wata i nuasako wafa faifaina. ");
INSERT INTO yml_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","I velutoliedi i vo, Ava'aibe bei iada 'wa ve'ufai?” I voneni i vo, 'Auvea 'u mai ta na nago 'a na vemu.” ");
INSERT INTO yml_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nika Iesu i lumatageu. ");
INSERT INTO yml_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Me Diu i 'iseni Iesu ma matageuna begaidi i vo, Vona mogitana, iana i nuakalikalieni bwaikina.” ");
INSERT INTO yml_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","We'e 'ifwaidi i vo, Tomatasako i 'ive'atumaia bega wata iana i da 'ivaiseni yana viga 'waineye nika kebu i da wafaga.” ");
INSERT INTO yml_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Wata Iesu nuana i vekalikalia sai'afo i vaganago taumata 'waineye. Taumatanina ovu matumatu 'waineye, kileu bababanega 'awana i vetovibodai. ");
INSERT INTO yml_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu tomotoga i vonedi i vo, Kileunina 'wa 'ewai.” Nika Malida towafanina novuna i vo, 'Auvea, magai fai 'aiata 4 'akonadi i 'a'ava.” ");
INSERT INTO yml_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Siwe wata Iesu i voneni i vo, 'Wa da vo kebu a da vonemu a vo, 'Ai'edi 'u na vetumagana 'waikuye, Yaubada yana toketokena 'u na 'iseni.’” ");
INSERT INTO yml_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tomotoga kileu i bifeleni, mulieta Iesu i 'isalaka i velu'ui Yaubada 'waineye i vo, Tamaku, a vekaiwa bwaikina 'waimuye fai bonaku 'u vivinenegeni. ");
INSERT INTO yml_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","'A 'asetai mogitana tutuya matatabuna bonaku 'u vivinenegeni, siwe de'e bani'odi a vevelu'uiediga fai nuanuaku tomotoga i na nogai i na vetumagana 'omu 'u vetuneku a mai.” ");
INSERT INTO yml_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesu i velu'ui'a'ava, nika i vegole i vo, Lasalo, 'u souyemu.” ");
INSERT INTO yml_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Iesu yana voneye Lasalo i tovoi i souyeni taumatayega nimana wata 'agena fanifanidi, we'e 'unu'ununa tamu kaleko 'wainega i baniumai. Iesu tomotoga i vonedi i vo, 'Wa na 'iyavuyavuya nika 'ana fata i na yaba.” ");
INSERT INTO yml_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Me Diu fuedi i maiga Meli 'waineye, Iesu yana folova toketokena i 'iseni i vetumagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","We'e 'ifwaidi i viladi i nagoi totafalolo Falisi 'waidie i lu'ivona ava'ai Iesu i 'idewaiga faifaina. ");
INSERT INTO yml_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Begaidi Falisi, tovelomu yadi to'edakumetavo wata me Diu yadi Kanisela taiadi i va'auta i veifufu Iesu faifaina i vo, Bani'odi ta na munegi? Tomogonina 'eba nuavogana wata 'eba nua'ewa fuedi i 'i'idewadewadi. ");
INSERT INTO yml_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","'Ai'edi ta na ve'ise'iseni, bola tomotoga matatabudi i na vetumagana 'waineye. Bega Loma kabemani tomotoga i na 'isedi i na vo, I baibailema i nunagoi Iesu 'waineye,’ nika i na leoda, 'ida me Diu yada veimea i na geuya, yada Vanuga 'Eba Velu'ui taiadi.” ");
INSERT INTO yml_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tamu me Diu yadi Kanisela 'ana wagava Kaiafa, taunina tovelomu bwaikina malamalanina 'waineye, i vonedi i vo, 'Omi 'wava'wavami, we'e kebu 'wa da nuaniga. ");
INSERT INTO yml_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","'Omi kebu 'wa da 'asetai, 'ana laubwaina tomogo 'aitamogana i na wafa tomotoga fuedi faifaidi, i na nunago yada 'awalawa 'ana tomotoga Loma kabemani i na luvela'ovi.” ");
INSERT INTO yml_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Vonanina Kaiafa i 'inanaiga, kebu taunina yana nuanuayega, siwe fai malamalanina 'waineye kumanina tovelomu bwaikina, i vona-samula 'awaie Iesu i na wafa me Diu matatabuna faifaidi. ");
INSERT INTO yml_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Siwe kebu 'aise'avadiga, wata Yaubada natunavo i miave'eve'e'elagi 'awalawa matatabuna 'waidie, Iesu yana wafa 'wainega i na va'augidi bega natunavo 'aila'a 'aitamogana. ");
INSERT INTO yml_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bega tutuyanina 'waineye me Diu to'edakumetavo i velamu 'aise'avadi i veveifufu-giva bani'odi i na munega Iesu i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Begaidi Iesu kebu i da yogomagemageta 'awalawa Iudia nageneye, givagivayega yana tovetutuyamavo taiadi i tauya i nagoi 'atamana Ifeleimi, sali'avu'avu lilivaneye, bei taiadi i miamiani. ");
INSERT INTO yml_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sai'afoga me Diu i na sakali Uvi'agalatagona faifaina, begaidi tomotoga fuedi 'awalawa tulina tulina 'waidiega i maia Ielusalema, nagami i na tafalolo yadi sauluva bani'odi, bega i na vevunavunaga Yaubada mataneye, mulieta sakalinina i na 'idewai. ");
INSERT INTO yml_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tomotoganidi Iesu i lulualeniga i va'auta Vanuga 'Eba Velu'ui nageneye, 'aitamogana 'aitamogana i velutolitoli i vo, 'Wa da nuani, 'ako Iesu i na mai 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","We'e Diu totafalolo Falisi wata tovelomu yadi to'edakumetavo taiadi veimea toketokena i yatoi i vo, 'Ai'edi aitoi Iesu i na 'iseni ava'aibe bei i miamiaga i na lu'ivona 'waimeye.” Yadi veimeanina i yatoiga fai nuanuadi Iesu i na 'ive'avini. ");
INSERT INTO yml_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","'Aiata 6 i na 'a'ava, me Diu sakalinina i na 'idewai Uvi'agalatagona faifaina, begaidi Iesu yana tovetutuyamavo taiadi i nagoi Bedani, Lasalo yana 'atamane, tomogonina Iesu i sivetovoia wafayega. ");
INSERT INTO yml_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bei 'ani'ani bwaikina i 'idewai Iesu 'ana ve'ililibu faifaina, bega Iesu wata Lasalo ediavo taiadi i miabui 'eba 'ani 'waineye i na 'ani, we'e Malida 'ani'ani i 'a'anivelena. ");
INSERT INTO yml_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tutuyanina Iesu i 'ani'ani, Meli bunama magaina 'atumaiotogina wata 'ana tutula bwaikina ma ba'alina i mieni Iesu 'ageneye i iwaga'a'aveni, mulieta nava'aunega i tamavelavelaladi. Bunamanina 'ana wagava Nadi, magaina vanuga matatabuna i susuli. ");
INSERT INTO yml_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Tamu yana tovetutuyama 'ana wagava Iudasa Isakaliota, kumanina Iesu 'ana to'etogiluva i vo, Awale bunamanina tutulina bwaikina i ve'amubwadodoyeni? I lubwaineni ta da vekimwaneyeni, maninina 'wainega tovewekowekoma ta da 'ivaisedi. Bunamanina 'ana tutula i vesala tofolova 'ana tutula malamala 'aitamogana faifaina.” ");
INSERT INTO yml_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","De'e bani'odi Iudasa i vonediga, kebu mogitana tovewekowekoma i da nuanidi faifaidi i da vonavona, fai taunina tovainago wata yadi mani 'ana to'isave'avina bega taunina 'ana 'aivaita faifaina i vona. ");
INSERT INTO yml_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","We'e Iesu i vo, 'Asa'aiana, vavine kebu 'u na 'ivebunumayagi. I iwagikuga i lubwaineni, tomogoku i 'idewa-vagaseni 'aku ve'ufa faifaina. ");
INSERT INTO yml_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tutuya fuedi 'omi tovewekowekoma taiadi 'wa miamiani, 'ami fata 'wa na 'i'ivaisedi, we'e yau kebu taiadi ta na mia-vagata.” ");
INSERT INTO yml_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","'Aila'a bwaikina me Diu vala i nogai Iesu i miamia Bedani, begaidi fuedi i maia nuanuadi i na 'iseni. Kebu Iesu 'aisenaga, wata nuanuadi Lasalo i na 'iseni, kumanina Iesu i sivetovoia wafayega. ");
INSERT INTO yml_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Fai me Diu fuedi Lasalo i 'iseni ma yawaina i 'asetai wafayega i yawasa-vaitugana, begaidi me Diu to'edakumetavo yadi veimea i vevedumwe'ai'aiedi Iesu 'waineye i vevetumagana. Faifainanina tovelomu yadi to'edakumetavo 'aise'avadi i veifufu nuanuadi Lasalo wata Iesu taiadi i na luvewafadi. ");
INSERT INTO yml_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","I 'atai, 'aila'a bwaikina i va'auta Uvi'agalatagona 'ana sakali faifaina, vala i nogai Iesu i mimai Ielusalema. ");
INSERT INTO yml_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Begaidi saisai lukudi i kinidabadi i miedi Iesu i na yogo'ede'edeni, i vegolegole Iesu faifaina i vo, Kaiwa, kaiwa. Taunina 'Auvea 'ana wagavayega i mimai, Yaubada i da vevesauluva 'atumaina 'waineye, kumanina me Isileli yada Kini.” ");
INSERT INTO yml_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu tamu doniki tubuvauvauna i 'ewai kwavuneye i laka bega i nago. Nika bei Yaubada yana Vona 'ana mogitana i souyeni basenadiotoga i kilumi Iesu faifaina i vo, ");
INSERT INTO yml_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","'Omi me Ielusalema kebu 'wa na kolologa. 'Wa na 'iseni, yami Kini i viwai 'waimie, doniki tubuvauvauna kwavuneye i miabui.” ");
INSERT INTO yml_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tutuyanina 'waineye yana tovetutuyamavo kebu i da 'aseta-'atumaiaga tamu vona-samula Yaubada yana Buki 'ana mogitana i sousouyeni, siwe tutuyanina Iesu i laka abame yana 'ai'aiwabu 'waineye, nika bei i nuani vonanina i kilumiga Iesu faifaina vona mogitana, wata tomotoganidi ma yadi sosoana i subiai wata i awave-Kini 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Tomotoganidi bagase Iesu i 'iseni Lasalo taumatayega i goleni wafayega i tovoi, i souyeni ma yawaina. Mulieta i nagoi Iesu yana folovanina toketokena i lu'ivoneyeni bega tomotoga fuedi i maia Iesu i yogo'ede'edeni. ");
INSERT INTO yml_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","We'e Falisi i 'isedi 'aila'a bwaikina i nunagoi Iesu 'waineye begaidi 'aise'avadi i veifufu i vo, 'Wa 'iseni, 'ida ta 'i'ivemweamweadaga. Tomotoga matatabudi 'akonadi i nunagoi Iesu 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tomotoga fuedi i va'auta Ielusalema Uvi'agalatagona 'ana lusakali faifaina, bega me Kuliki taiadi i na 'odu Yaubada 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Me Kuliki i maia Filifi 'waineye, taunina tomogo Bedasaida 'awalawa Galili nageneye, i voneni i vo, 'Auvea, nuanuama Iesu taiadi 'a da veifufu.” ");
INSERT INTO yml_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Bega Filifi i nago Anidulu i voneni, mulieta 'adi 'ailuga i nagoi Iesu 'waineye i lu'ivona. ");
INSERT INTO yml_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu yadi vona i nogai i vonedi i vo, Yau a vetomotogaotoga yaku tutuya i le'wa, Yaubada yaku toketokena magemagetana i na sivemageseni. ");
INSERT INTO yml_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A vona mogitana 'waimie, 'ai'edi waifei bubuwakeye i na 'eno'eno kebu 'ana fata i na vefue. We'e ta na koyoviga nagami tubutubuna i na 'anikudai 'wa da vo i da wafa, mulieta i na tabo, nika 'wainega 'ani'ani fuedi i na souyedi. ");
INSERT INTO yml_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wata side bani'odi. 'Ai'edi aitoi yana mia 'ana 'atumaina i na ve'o'oleni, kebu nuanuana yawaina i na tauyeni faifaiku, taunina i na wafaotoga. We'e 'ai'edi aitoi yana mia 'ana 'atumaina wata yawaina i na tauyedi faifaiku, mia 'atumaina wata miamia-vagaina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aitoi nuanuana i na vetofolova 'waikuye i lubwaineni i na vetutuyameku, bega ava'aibe bei a na nunago yaku tofolovanidi taiadi. We'e egavogi faifaiku i folofolovaga, 'awaie Tamaku i na silakaidi wata i na awave'atumaiedi.” ");
INSERT INTO yml_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Wata Iesu i vo, Tutuya de'e nuafouku i toke i veveviga. Voke a da velu'ui a da vo, Tamaku, nuanuaku vita wata wafa 'waidiega 'u na 'ita'ita'ieku.’ Siwe kebu i da lubwaineku bani'odi a na velu'ui, fai vitanina faifaina a mai. ");
INSERT INTO yml_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Side bani'odi a na velu'uiedi a na vo, Tamaku, nuanuaku yamu toketokena magemagetana 'u na sivemageseni tomotoga 'waidie.’” Iesu i vona'a'ava nika tamu bona i souyeni abamayega i vo, 'Akonadi yaku toketokena magemagetana a sivemageseni, wata 'awaie a na sivemageseni.” ");
INSERT INTO yml_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","'Aila'a i tovotovoi lilivadie bonananina i nogai 'ifwaidi i vo, Tamuyoana i duduya,” we'e 'ifwaidi i vo, Tamu anelose i vona Iesu 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nika Iesu i vo, Bonananina ta nogaiga, yau kebu 'aku 'aivaita faifaina, 'omi 'ami 'aivaita faifaina. ");
INSERT INTO yml_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tutuya de'e Yaubada i na velamu tomia fwayafwaya i na veveimeyedi vematavuloga faifaina wata Seitani kumanina fwayafwaya 'ana toveimea i na taweni. ");
INSERT INTO yml_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","We'e yau, tutuyanina i na silakaiku fwayafwaya 'wainega, tomotoga 'aila'a tulina tulina a na vagavaidi i na maia 'waikuye.” ");
INSERT INTO yml_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesu yana vona de'e i kiavemagetai bani'odi i na wafayediga faifaina. ");
INSERT INTO yml_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","'Aila'a yana vonanina i nogai i vo, Yada veimea basenadiotoga i kilumi i vo, Keliso kebu i na wafaga i na mia-vagata.’ We'e awale 'u vo, Yau a vetomotogaotoga tomotoga i na silakaiku 'ai lagalagana 'waineye?’ Aitoi kumanina i vetomotogaotoga?” ");
INSERT INTO yml_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Bega Iesu i vonedi i vo, Tutuya 'ale'usana 'waineye taiadi ta na miamia a na vevemi, yau yami mageta. Yaku venina nuami i na magetadi bega 'ai'edi 'wa na vetumaganeku nuami kebu dudubalidiga. Egavo i vevedumwe'ai'aieku taunidi bani'odi i yabayaba dudubala 'waineye, kebu i da 'asetai ava'aibe bei i nunagoi. ");
INSERT INTO yml_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tutuyanina taiadi ta na miamia i lubwainemi 'wa na vetumagana 'waikuye, yau yami mageta, bega ma yami sosoana 'wa na miamia yaku 'aila'a nageneye.” Iesu i vona'a'ava, i tovoi 'aila'a i 'iawedi givayega i nago tulineye. ");
INSERT INTO yml_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Avinodi Iesu 'eba nuavogana wata 'eba nua'ewa fuedi i 'i'idewadi tomotoga 'waidie, siwe kebu i da vetumagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Naninina faifaina basenadiotoga Yaubada yana tolu'ivona 'ana wagava Aisea i vona-samula i vo, 'Auvea, valamu 'a lulu'ivoneyeni siwe kebu tamu aitoi i da ve'awamogitana. Tomotoga 'Auvea yana toketokena i 'iseni, siwe kebu i da 'asetai wata i da vetumagana.” ");
INSERT INTO yml_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Fai tomotoganidi Yaubada yana vona i vevedumwe'ai'aieni, begaidi kebu 'adi fata i na vetumagana. Bega wata Aisea i kilumi faifaidi i vo, Yaubada matadi i 'ive'uludi, bega kebu 'adi fata i na 'isa. Nuadi i vetabodadi, bega kebu 'adi fata i na 'aseta. Begaidi kebu nuanuadi i na nuaviladi 'waikuye, a na 'ive'atumaidi.” ");
INSERT INTO yml_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Vona de'e Aisea i kilumiga fai Iesu yana 'ai'aiwabu magemagetana i 'iseni, faifaina i veifufu. ");
INSERT INTO yml_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","We'e tutuyanina 'waineye me Diu fuedi, yadi to'edakumetavo 'ifwaidi taiadi i vetumagana Iesu 'waineye, siwe kebu i da lu'ivona fai Falisi i kololoyedi. Yadi veimea toketokena faifaina i vo, Egavo i na vetumagana Iesu 'waineye 'a na talabodedi kebu taiadi 'a na lukuluku 'eba miava'auta nageneye tafalolo faifaina.” ");
INSERT INTO yml_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Fai nuanuadi tomotoga i na awave'atumaiedi, we'e kebu nuanuadi 'adi awave'atumai Yaubada 'wainega, begaidi i ve'wadamo kebu i da lu'ivona. ");
INSERT INTO yml_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesu bonana bwaikinega i veifufu tomotoga 'waidie i vo, Egavo i na vetumagana 'waikuye, siwe 'asa'aiana 'akonadi i vetumagana Yaubada 'aku tovetune 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wata bani'odi, egavo i na 'iseku wata 'akonadi Yaubada 'aku tovetune i 'iseni. ");
INSERT INTO yml_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yau a mai fwayefwayeye bega egavo i na vetumagana 'waikuye nuadi a na kiavemagetadi kebu yadi nuanua i na dududubalidi. ");
INSERT INTO yml_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Wata a maiga tomia fwayafwaya a na 'ita'ita'iemi, kebu a da mai bega yaku veimea 'wainega vematavuloga 'wa na veluagai. Begaidi egavo yaku vona i na nogaidi siwe kebu i na vematayakeyakedi, yau kebu a na veimeyedi vematavuloga i na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Siwe tutuyanina tomotoga 'wa na vonayavuga Yaubada mataneye, yaku vona tovedumwe'ai'ainidi i na veimeyedi bega vematavuloga i na veluagai. 'Adi vematavuloga lamuna, yaku vonanidi kebu nuanuadi, wata i vedumwe'ai'aieku. ");
INSERT INTO yml_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kebu yaku nuanuayega a da veveifufu, fai Tamada 'aku tovetune ava'ai i vonekuga wata bani'odi a vonavona. ");
INSERT INTO yml_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A 'asetai 'ami fata mia 'atumaina wata miamia-vagaina 'wa na veluagai Yaubada yana Vona 'waidiega, begaidi ava'ai a vonevoneyediga, fai 'akonadi Tamada i voneku.” ");
INSERT INTO yml_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","'Awa'awai bani'odi Uvi'agalatagona 'ana sakali i na 'idewai, Iesu 'akonadi i 'asetai yana tutuya, fwayafwaya i na 'iaweni i na vilai i na nago Tamana 'waineye. Iesu yana 'aila'a fwayefwayeye i nuakalikaliedi bwaikina, 'eba velamu 'wainega i nagoga wata yana wafa 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lovananina 'waineye, Iesu wata yana tovetutuyamavo taiadi i 'ani'ani we'e Seitani venua'ivina sakoina Iudasa i veleni bega Iesu i na 'etogiluveni. Iudasa kumanina Saimoni Isakaliota natuna. ");
INSERT INTO yml_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu i 'asetai taunina i mai Yaubada 'wainega wata i na vilai i na nago 'waineye, wata i 'asetai Yaubada nani matatabuna i 'anivelenedi 'waineye i na veveimeyedi. ");
INSERT INTO yml_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Fai naninidi Iesu i 'asetadi, begaidi 'eba 'ani 'wainega i tovoi 'ana talauma tabwaneye i ta'ia, mulieta tamatama i 'ewai tolobwaneye i yogoneni, 'wa da vo bani'odi tofolova-maimaiga. ");
INSERT INTO yml_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Iesu 'aivoe i 'ewai, bei ufa i iwagi bega yana tovetutuyamavo 'aitamogana 'aitamogana 'agedi i lekoadi, mulieta i tamavelavelaladi. ");
INSERT INTO yml_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tutuyanina i le'wa Saimoni Fita 'waineye i talaboda i vo, 'Auvea, yau kebu nuanuaku 'ageku 'u na lekoadi, 'ana 'isa kebu 'atumainaga.” ");
INSERT INTO yml_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu i voneni i vo, Yaku folova a 'i'idewaiga 'ana nuanua 'u bavuyeni, we'e 'awaie 'u na 'asetai.” ");
INSERT INTO yml_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Fita i ve'awafatafata i vo, Kebu tamu tutuya 'ageku 'u na lekoadi.” Iesu i vo, 'Ai'edi kebu a na lekoamuga, 'omu kebu wata 'aku 'auga.” ");
INSERT INTO yml_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Wata Saimoni Fita i vo, Vetuma kebu 'age'avaku 'u na lekoadiga, nuanuaku 'unu'unuku wata nimaku taiadi 'u na lekoadi.” ");
INSERT INTO yml_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu i voneni i vo, Egavo i toaga, tomogodi matatabuna vunavunagidi, 'age'avadi i veyokega i na lekoadi. 'Omi matatabumi vunavunagimi, we'e 'aitamogana 'waimiega kebu.” ");
INSERT INTO yml_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Fai Iesu 'akonadi i 'asetai 'ana to'etogiluva, taunina tosakona, begaidi i vo, 'Omi matatabumi vunavunagimi, we'e 'aitamogana 'waimiega kebu.” ");
INSERT INTO yml_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Iesu 'agedi i lekoa'a'avadi, wata 'ana talauma i silakaveni i vilai i nago i miabui. I velutoliedi i vo, 'Asiauotoga de'e yaku folova a 'idewaiga 'waimie, 'ana nuanua 'wa 'asetai, 'alo kebu? ");
INSERT INTO yml_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tutuya fuedi 'wa goleku 'wa vo, 'Auvea,’ wata 'wa vo, Tove,’ we'e 'wa vonaga vona mogitana fai yau yami 'Auvea wata yami Tove. ");
INSERT INTO yml_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Avinodi yau yami 'Auvea wata yami Tove 'agemi a lekoadi, 'omi wata bani'odi i lubwainemi ma yami nuaobu 'wa na vetofolova 'aitamogana 'aitamogana. ");
INSERT INTO yml_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yau 'eba 'isa a 'idewai 'waimie, bega bani'odi 'wa na vetutuyameku. ");
INSERT INTO yml_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A vona mogitana 'waimie, tofolova kebu 'ana toveimea i da vebwaika-'iaweni, 'alo tomata'aulele 'ana tovetune i da vebwaika-'iaweni. ");
INSERT INTO yml_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Naninidi a voneyediga, 'akonadi 'wa 'asetadi. 'Ai'edi ma yami nuaobu 'wa na vetofolova, 'wa na sososoana. ");
INSERT INTO yml_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kebu a da veveifufu 'omi matatabumi faifaimi, fai a venua'ivinemi begaidi 'aitamogana 'aitamogana yami nuanua a 'asetadi. A venua'ivinemiga bega tamu vona Yaubada yana Buki nageneye 'ana mogitana i na souyeni i vo, Tamu tomogo taiadi 'ama'ama 'aitamogana siwe i sivilai i vegavieku.’ ");
INSERT INTO yml_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","A vovona-vagasemi tamu tomogo i na 'etogiluveku, bega tutuyanina i na souyeni 'wa na vetumagana yau Yaubada 'ana Venua'ivina. ");
INSERT INTO yml_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A vona mogitana 'waimie, egavo ma yadi nuakalikali yaku tofolovavo i na 'ivaisedi, siwe 'asa'aiana yau i 'ivaiseku. Wata bani'odi egavo ma yadi nuakalikali i na 'ivaiseku siwe 'asa'aiana Yaubada 'aku tovetune i 'ivaiseni.” ");
INSERT INTO yml_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesu i veifufu'a'ava nika i nuavita bwaikina, yana tovetutuyamavo i vonedi i vo, A vona mogitana 'waimie, tamu iami i na 'etogiluveku.” ");
INSERT INTO yml_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Matatabudi i vetunuvilavila yadi nuanua i ve'ale'usa aitoi faifaina i vonavona. ");
INSERT INTO yml_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","24","Iadi tamu kumanina Iesu i nuakalikalieni bwaikina, lilivaotogineye i miabui begaidi Saimoni Fita i lu'wai i voneni i vo, Iesu 'u na velutolieni, aitoi mogitana faifaina i vonavona.” ");
INSERT INTO yml_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Bega i sivilai Iesu i ve'awayayai i vo, 'Auvea, aitoi kumanaga?” ");
INSERT INTO yml_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu i voneni i vo, Tomogonina a na ve'ililibuyeni, 'ani'ani a na 'ewai a na lu'utuvi a na veleni, taunina tomogonina 'aku to'etogiluva.” Bega Iesu 'ani'ani tamu i 'ewai i lu'utuvi nika Iudasa, Saimoni Isakaliota natuna, i veleni. ");
INSERT INTO yml_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Iudasa i 'anielo i 'ania, mulieta Seitani i agei. Iesu i voneni i vo, 'Ai'edi ava'ai nuanuamu 'u na 'idewaiga, 'u souye-matayo'oyemu 'u nago.” ");
INSERT INTO yml_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Iesu i vonavona Iudasa 'waineye we'e yana tovetutuyamavo 'ifwaidi kebu i da 'asetaiga ava'ai i vonevoneyeni. ");
INSERT INTO yml_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Fai Iudasa yadi mani 'ana to'isave'avina, 'ifwaidi yadi nuanua i vo, Voke i vetunei i nunago 'ada'ada i na kimwane sakali faifaina, 'alo egavo i vewekowekomaga i na 'ivaisedi.” ");
INSERT INTO yml_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nika bei Iudasa i souya-matayo'oyeni i nago, siwe 'akonadi i lovani. ");
INSERT INTO yml_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iudasa i tauya i nunago Iesu yana tovetutuyamavo i vonedi i vo, Tutuya de'e yau a vetomotogaotoga Yaubada yaku toketokena magemagetana i na sivemageseni, we'e 'waikuyega tomotoga Yaubada yana toketokena magemagetana i na 'iseni. ");
INSERT INTO yml_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Fai tomotoga Yaubada yana toketokena magemagetana i na 'iseni yau Natuna 'waikuyega, wata bani'odi sai'afootoga yana toketokena magemagetana i na sivemageseni yau Natuna 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ekwavo a nuakalikaliemi bwaikina, yau sai'afoga a na 'iawemi 'wa na lualeku. Siwe a na vonemi, basenadi bani'odi me Diu yada to'edakumetavo a vonedi a vo, A nunagoga bei kebu 'ami fata 'wa na waiga.’ ");
INSERT INTO yml_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Veimea 'ivauna a na velemi, side bani'odi. Ma emiavo 'wa na venuakalikali. Fai yau a nuakalikaliemi bwaikina, 'omi wata bani'odi ma emiavo 'wa na venuakalikali. ");
INSERT INTO yml_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","'Ai'edi ma emiavo 'aitamogana 'aitamogana 'wa na venuakalikaliga, mali tomotoga i na 'isemi i na 'asetai 'omi yaku tovetutuyamavo.” ");
INSERT INTO yml_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Fai Iesu i vonaga i vo, A na nago bei kebu 'ami fata 'wa na waia,” begaidi Fita i velutoli 'waineye i vo, 'Auvea, ava'aibe 'u na nago?” Iesu Fita yana velutoli i tutuli i vo, Bei a na nagoga kebu 'amu fata tutuya de'e 'u na yogo'wailiku, we'e bola mulikuye 'u na wai.” ");
INSERT INTO yml_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Wata Fita i velutoli i vo, 'Auvea, awale kebu 'aku fata a na yogo'wailimuga tutuya de'e 'waineye? We'e yau tauniku a tauyeku a na wafa faifaimu.” ");
INSERT INTO yml_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iesu i voneni i vo, Mogitanaotoga 'u tauyemu wafa 'waineye faifaiku? A vona mogitana 'waimuye, 'ako lovane bola kamukamu kebu i na kwagega, nagami tutuya 'aitonu 'u na bavusebeku.” ");
INSERT INTO yml_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Wata Iesu i vo, Kebu nuafoumi i na vevigaga, 'wa na vetumagana Yaubada 'waineye wata yau 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","3","'Awalawanina 'waineye Tamaku i miamiaga, vanuga fuedi i tovotovoi. Yau a na nago yami 'eba mia a na 'i'idewadewadi. I na 'a'ava, a na vilaku a na mai a na vagavaimiga ta na nagoi bei yau a miamiaga 'waineye. 'Ai'edi 'eba mianidi kebu i da 'eno'enoviga, 'ako kebu a da vonemiga. ");
INSERT INTO yml_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","'Atamananina bei a na nagoga, 'ana 'eda 'akonadi 'wa 'asetai.” ");
INSERT INTO yml_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi i voneni i vo, 'Auvea, 'ima kebu 'a da 'asetaiga ava'aibe 'u na nago, begaidi 'ana 'eda kebu 'a da 'asetai.” ");
INSERT INTO yml_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu i voneni i vo, Yau 'asa'aiana kumaniku 'eda. Yau Yaubada 'ana 'aseta mogitana 'ana Tosivemageta, wata 'waikuyega mia 'ivauna wata 'atumaina i sousouyeni. Kebu tamu wata 'eda i da 'eno'eno bega 'wa na nagoi Tamaku 'waineye, 'eda 'aitamogana, ma yami vetumagana taunimi 'wa na tauyemi 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","'Ai'edi mogitana 'wa da 'asetakuga, wata bani'odi Tamaku 'wa da 'asetai. Tutuya de'e, bega i na nagoga, Tamaku 'wa 'aseta-'atumaia wata 'wa 'iseni.” ");
INSERT INTO yml_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filifi i voneni i vo, 'Auvea, nuanuama Tamada 'u na vema, 'asa'aiana kumanina yama nuanua.” ");
INSERT INTO yml_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Wata Iesu yana tovetutuyamavo i vonedi i vo, 'Omi yau taiadi tutuya manamanawena ta miamia, siwe Filifi 'u da vo kebu 'u da 'asetaku. Egavo i 'iseku, 'asa'aiana 'akonadi wata Tamada i 'iseni. Awale 'u vo, Tamada 'u na vema?’ ");
INSERT INTO yml_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filifi 'u da vetumagana, yau Tamada taiadi 'a miave'itubama wata Tamadanina yau taiadi 'a miamia. Yaku vona a veifufuyediga 'waimie kebu tauniku yaku nuanuayega, Tamada 'aku labilabina yana folova i 'i'idewadi 'waikuyega. ");
INSERT INTO yml_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nuanuaku 'wa na vetumagana 'waikuye, yau Tamada taiadi 'a miave'itubama, wata bani'odi Tamadanina yau i labilabiniku. 'Ai'edi vitana 'waimie, 'eba nuavogana wata 'eba nua'ewa a 'idewadiga 'wa na nuanidi nika 'ami fata 'wa na vetumagana 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A vona mogitana 'waimie, egavo i na vetumagana 'waikuye folovanidi bani'odi yau a 'i'idewadiga 'adi fata i na 'idewadi. Siwe wata folova toketokeotogidi wata bwaikaotogidi 'adi fata i na 'i'idewadi fai yau a na nago Tamada 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ava'ai naniga nuanuami, 'aku wagavayega Tamada 'waineye 'wa na vevelu'ui, mogitana a na 'i'idewadi. Fai yami nuanua a na 'i'idewadi, mali tomotoga i na 'iseni Tamada i na subisubiai. ");
INSERT INTO yml_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Naninidi nuanuami, 'ai'edi 'aku wagavayega 'wa na vevelu'ui 'waikuye, mogitana a na 'i'idewadi.” ");
INSERT INTO yml_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Wata Iesu i vo, 'Ai'edi mogitana 'wa na nuakalikalieku yaku veimea 'wa na vevematayakeyakedi. ");
INSERT INTO yml_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tamada 'waineye a na velu'ui bega tamu 'ami To'aivaita i na velemi, taiadi 'wa na mia-vagata. ");
INSERT INTO yml_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","To'aivaitanina, taunina 'Anu'anunu Magemagetana, Yaubada yana nuanua tonovina i na veve 'waimie. Tomotoganidi fwayafwaya 'ana nuanua 'waidie i vebwaikaga, kebu 'adi fata taunidi i na tauyedi 'Anu'anunu Magemagetana 'waineye fai kebu i da 'isa'inanai wata kebu i da 'asetaiga. We'e 'omi 'akonadi 'wa 'asetai, fai taiadi 'wa miamia wata 'awaie i na agemi. ");
INSERT INTO yml_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","A na 'iawemi siwe kebu 'wa na vo, 'Ima fovafovama, kebu tamu 'ama to'aivaitaga,’ fai a na vilaku a na mai 'waimie. ");
INSERT INTO yml_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sai'afoga tomotoganidi fwayafwaya 'ana nuanua 'waidie bwaikina kebu wata i na 'ise'isekuga, we'e 'omi 'wa na 'ise'iseku. Yau a mia-vagata, begaidi 'omi wata 'wa na miamia. ");
INSERT INTO yml_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tutuyanina 'Anu'anunu Magemagetana i na mai, 'wa na 'asetai yau Tamaku taiadi 'a miave'itubama, 'omi wata bani'odi yau taiadi ta miave'itubama, wata yau 'omi taiadi ta miave'itubama. ");
INSERT INTO yml_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Egavo yaku veimea i 'asetadi wata i vevematayakeyakedi, taunidi 'aku tonuakalikali. Fai i nuakalikalieku, begaidi Tamaku i na nuakalikaliedi. Yau wata a na nuakalikaliedi nika tauniku a na sivemageseku 'aitamogana 'aitamogana 'waidie.” ");
INSERT INTO yml_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tamu Iudasa, kebu Iudasa Isakaliota, i velutoli Iesu 'waineye i vo, 'Auvea, awale taunimu faifaimu 'u na lu'ivona 'waimeye, we'e tomotoganidi fwayafwaya 'ana nuanua bwaikina 'waidie, kebu 'u na lu'ivonaga?” ");
INSERT INTO yml_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu Iudasa yana vona i tutuli i vo, Egavo i nuakalikalieku mogitana, yaku vona i na vevematayakeyakedi. Tomotoganidi Tamaku i na nuakalikaliedi bega yau wata Tamaku taiadi 'a na mai 'a na lauvila 'waidie. ");
INSERT INTO yml_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Egavo kebu i da nuakalikaliekuga, taunidi yaku vona kebu i na vematayakeyakedi. Vonanidi a veifufuyedi 'wa nogaidiga kebu tauniku yaku nuanuayega, Tamada 'aku tovetune 'wainega i mai. ");
INSERT INTO yml_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Fai bola taiadi ta miamia, begaidi a vona-vagasemi. ");
INSERT INTO yml_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tamada 'Anu'anunu Magemagetana 'aku wagavayega i na vetunei 'waimie. Fai taunina 'ami To'aivaita, nani matatabuna i na vemi wata naninidi a voneyediga matatabuna i na totolinuata'iemi. ");
INSERT INTO yml_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Sai'afoga a na 'iawemi siwe yaku nuanua bikana a na 'aniveleneni 'waimie. Nuanuanina bikana tauniku 'waikuyega tomia fwayafwaya kebu 'adi fata i na velemi, begaidi kebu nuafoumi i na veviga wata kebu 'wa na kololo. ");
INSERT INTO yml_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","'Akonadi 'wa nogai a vonemi a vo, Yau sai'afoga a na 'iawemi, siwe wata a na vilaku a na mai 'waimie.’ 'Ai'edi mogitana 'wa da nuakalikalieku, 'ako kebu 'wa da nuavitaga yaku tauya faifaina, 'wa da sososoana fai yau a na nago Tamada 'waineye, taunina i vebwaika-'iaweku. ");
INSERT INTO yml_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Fai bola taiadi ta miamia begaidi a vona-vagasemi yaku tauya faifaina, bega tutuyanina i na souyeni 'wa na 'iseni nika 'wa na vetumagana 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kebu a na veveifufu manamanawena 'waimie fai sai'afoga Seitani i na le'wa, kumanina tomia fwayafwaya 'adi toveimea sakoina, siwe kebu 'ana fata i na vetoketoke-'iaweku. ");
INSERT INTO yml_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","I lubwaineni tomia fwayafwaya i da 'aseta-'atumaia Tamada a nuakalikalieni wata a tauyeku 'waineye bega ava'ai nuanuana i na vonekuga a na 'idewai.” Iesu i vona'a'avana, yana tovetutuyamavo i vonedi i vo, 'Wa tovoi ta na nagoi.” ");
INSERT INTO yml_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Wata Iesu i vona yana tovetutuyamavo 'waidie i vo, Yau 'asa'aiana welavi kalefa mogitana, Tamaku tobakula. ");
INSERT INTO yml_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","'Ai'edi didiku 'ifwaidi kebu i na vuavuaga-'atumai, Tamaku i na kuyailidi, we'e didiku 'ifwaidi 'akonadi ma vuagidi, ililidi 'ifwaidi i na kinikadikadidi bega i na ve'atumai i na vuagadewa. ");
INSERT INTO yml_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","'Omi 'asa'aiana didiku, yaku vona a veifufuyediga 'wa vetumaganedi, nika i 'ivevunavunagimi bega 'wa na vuagadewa. ");
INSERT INTO yml_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yau taiadi ta na miave'itubama bega yau 'ami labilabina. 'Ai'edi didina ta na kuyai, kebu 'ana fata i na vuaga, we'e 'ai'edi welavinina 'waineye i na 'eno'enoga, 'ana fata i na vuaga. 'Omi wata bani'odi, 'ai'edi 'wa na bailekuga, kebu 'ami fata yaku nuanua 'wa na 'idewadi. ");
INSERT INTO yml_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yau welavi kalefa, 'omi didiku. Egavo 'waikuye i na mai taiadi 'a na miave'itubamaga, yau 'adi labilabina bega 'adi fata yadi folova faifaiku 'atumaidi wata yadi sauluva tonovidi 'wa da vo i da vuaga-'atumai. 'Ai'edi yau kebu taiadiga, 'aise'avami kebu 'ami fata tamu nani 'atumaina 'wa na 'idewai. ");
INSERT INTO yml_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Egavo i na baileku kebu taiadi 'a na miave'itubamaga, bani'odi didi sakoidi, tobakula i na kuyailidi wata i na valo'udi, mulieta i na bwavu i na tunudi i na 'alaidi. ");
INSERT INTO yml_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","'Ai'edi yau taiadi ta na miave'itubamaga wata yaku vona nuamie i na 'eno'enoviga, ava'ai nuanuami faifaidi 'wa na vevelu'ui 'ana fata 'wa na veluagadi. ");
INSERT INTO yml_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","'Ai'edi yami folova faifaiku 'atumaidi wata yami sauluva tonovidi, 'omi yaku tovetutuyamavo mogitana bega tomotoga i na 'isemi Tamaku i na subiai. ");
INSERT INTO yml_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tamaku i nuakalikalieku bwaikina, yau wata bani'odi a nuakalikaliemi, nuanuaku 'wa na miamiani yaku nuakalikalinina nageneye. ");
INSERT INTO yml_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tamaku yana nuakalikali nageneye a miamia fai yana veimea a vevematayakeyakedi, 'omi wata bani'odi, 'ai'edi yaku veimea 'wa na vevematayakeyakediga yaku nuakalikali nageneye 'wa na miamiani. ");
INSERT INTO yml_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Naninidi faifaidi a vona-vagasemi bega yaku sosoanayega 'wa na sososoana, sosoananina sosoana mogitana. ");
INSERT INTO yml_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","De'e yaku veimea bwaikina a velevelemi, yau a nuakalikaliemi bwaikina, nuanuaku 'omi wata bani'odi ma emiavo 'wa na venuakalikali mogitana. ");
INSERT INTO yml_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nuakalikali side bani'odi, 'ai'edi tamu tomogo yawaina i na tauyeni wafa 'waineye enavo 'adi 'ita'ita'i faifaina, de'e nuakalikali mogitana. ");
INSERT INTO yml_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","'Ai'edi yaku veimea 'wa na vevematayakeyakediga 'omi ekwavo mogitana. ");
INSERT INTO yml_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Basenadi a vo, 'Omi yaku tofolovavo,’ tutuya de'e a na vo, 'Omi ekwavo.’ Tofolova yana 'auvea yana nuanua matatabuna kebu i da 'asetadi, we'e 'omi, nani matatabuna Tamaku i vonekuga a lu'ivoneyedi 'waimie, begaidi a vo, 'Omi ekwavo.’ ");
INSERT INTO yml_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","'Omi kebu 'wa da venua'ivineku bega 'wa na vetofolova faifaiku, we'e mogitana yau a venua'ivinemi wata a vetunemi 'wa na folova 'atumaina faifaiku, 'wa da vo 'wa da vuaga-'atumai, vuaganidi 'eno'eno-vagaidi. 'Ai'edi ma vuagimi, ava'ai nuanuami 'aku wagavayega 'wa na velu'ui Tamada 'waineye i na velemi. ");
INSERT INTO yml_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","'Akonadi yaku veimeanina a vonemi a vo, Nuanuaku ma emiavo 'wa na venuakalikali.’ ");
INSERT INTO yml_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","'Ai'edi Yaubada 'ana tobaila i na vedumwe'ai'aiemi, 'wa na nuani yau wata nagami i vedumwe'ai'aieku. ");
INSERT INTO yml_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","'Ai'edi fwayafwaya 'ana nuanua 'waimie bwaikina tobailanidi bani'odi, 'ako i da nuakalikaliemi wata i da veianemi. We'e 'omi tulimi fai tomia fwayafwaya 'waidiega a venua'ivinemi, bega 'omi kebu ediavoga wata i vevedumwe'ai'aiemi. ");
INSERT INTO yml_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yaku vona 'wa na nuani a vo, Tofolova kebu 'ana toveimea i da vebwaika-'iaweni.’ Yau 'ami Toveimea veviga a veveluagadi tomotoga 'waidiega, wata bani'odi 'omi yaku tofolovavo, mogitana vita 'wa na veluagadi 'aku tovedumwe'ai'ai 'waidiega. Yaku vona kebu i da vematayakeyakediga, wata bani'odi yami vona i na baila. ");
INSERT INTO yml_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Vitanidi i na 'idewadiga 'waimie, fai 'omi yaku tomotoga wata fai Yaubada 'aku tovetune kebu i da 'asetaiga. ");
INSERT INTO yml_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","'Ai'edi basenadi kebu a da maiga wata 'ako kebu a da vonediga, Yaubada tosakonanidi kebu i da 'uvanidiga yadi sauluva sakoidi faifaidi. 'Akonadi a mai yadi sakona a lu'ivoneyedi siwe kebu i da nuaviladi, begaidi kebu 'adi fata i na dega vematavuloga 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Egavo i vedumwe'ai'aieku, siwe 'asa'aiana wata Tamaku i vedumwe'ai'aieni. ");
INSERT INTO yml_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wata 'ai'edi kebu 'eba nuavogana wata 'eba nua'ewa a da 'idewadi i da 'isediga, 'ako Yaubada kebu i da 'uvanidi yadi sauluva sakoidi faifaidi, siwe 'akonadi a mai folova toketokedi, kebu tamu aitoi 'ana fata bani'odi i da 'idewadiga, a 'idewadi matadie, siwe Tamaku taiadi i vedumwe'ai'aiema. ");
INSERT INTO yml_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","I vedumwe'ai'aiema i lubwaineni, fai basenadiotoga i kilumi Yaubada yana Buki nageneye faifaiku i vo, Yadi vedumwe'ai'ai 'waikuye kebu tamu lamunaga.’ Tutuya de'e 'akonadi vonanina 'ana mogitana i souyeni. ");
INSERT INTO yml_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","'Awaie 'Anu'anunu Magemagetana a na vetunei 'waimie, Tamada 'wainega. Taunina 'ami To'aivaita, Tamada yana nuanua tonovina i na veve 'waimie wata faifaiku i na lulu'ivona. ");
INSERT INTO yml_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Wata 'omi faifaiku 'wa na lulu'ivona tomotoga 'waidie, fai 'eba velamuyega i maiga 'asiau yau taiadi ta miamia nani matatabuna a veve 'waimie.” ");
INSERT INTO yml_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Wata Iesu i vona yana tovetutuyamavo 'waidie i vo, Naninidi 'akonadi a voneyediga 'waimie bega tutuyanina vita i na souyedi 'waimie yami vetumagana kebu i na mwea, nuanuaku 'wa na vetoketoke. ");
INSERT INTO yml_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yada to'edakumetavo me Diu i na talabodemi kebu 'ami fata 'wa na lukuluku 'eba miava'auta 'waidie tafalolo faifaina. Wata 'awaie tomotoga i na luvewafami, yadi nuanua i na vo 'ako Yaubada yana nuanua. ");
INSERT INTO yml_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","I na ve'idi'idiemiga wata i na luvewafamiga fai Tamada i bavuyeni wata yau bani'odi. ");
INSERT INTO yml_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Naninidi faifaidi nagami a matakiami bega tutuyanina i na souyedi 'waimie nika 'wa na nuani yaku vona. Vitanidi 'awaie 'wa na veluagadiga faifaidi nagami kebu a da vonemi fai yau taiadi ta miamia. ");
INSERT INTO yml_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Fai sai'afoga a na tauya a na nago 'aku tovetune 'waineye bega naninidi a lulu'ivona-vagasedi 'waimie. Siwe kebu tamu aitoi 'waimiega i da velutoli 'waikuye i da vo, Ava'aibe bei 'u na nago?’ ");
INSERT INTO yml_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Fai a vo, A na nago,’ 'wa nuavita bwaikina. ");
INSERT INTO yml_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Siwe a vona mogitana 'waimie 'ai'edi taiadi ta na miamia, 'atumaina siwe kebu mogitana 'atumaiotogina, fai 'ami To'aivaita kebu i na maiga, we'e a na nagoga 'atumaiotogina 'waimie fai To'aivaitanina a na vetunei i na mai. ");
INSERT INTO yml_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tutuyanina i na mai tomia fwayafwaya yadi sakona i na sivemageseni bega i na 'asetai matatabudi i sakosakona. Yaubada yana sauluva tonovina i na vedi, bega i na 'asetai 'awaie matatabudi i na vonayavuga Yaubada 'waineye, i na veimeyedi vematavuloga faifaina. ");
INSERT INTO yml_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tomotoga i sakosakona fai kebu i da vetumagana 'waikuye. ");
INSERT INTO yml_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Fai a nunago Tamada 'waineye kebu wata 'wa na 'ise'isekuga, 'eba 'isa yaku sauluva tonovina. ");
INSERT INTO yml_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","'Akonadi Yaubada i veimea tosakona 'adi toveimea Seitani vematavuloga i na veluagai, begaidi 'awaie tosakona matatabuna i na vonayavuga Yaubada mataneye. ");
INSERT INTO yml_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Fai 'wa nuavita, begaidi 'asiau kebu 'aku fata nani matatabuna a na lu'ivoneyedi 'waimie. ");
INSERT INTO yml_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Siwe tutuyanina 'Anu'anunu Magemagetana i na mai Yaubada 'ana 'aseta mogitana i na awave'ede'edemi, 'Anu'anununina nani matatabuna tonovidi 'adi tove. Kebu taunina yana nuanuayega i na veifufu 'waimie, siwe ava'ai i na nogai Yaubada 'wainega i na lu'ivona 'waimie, wata naninidi 'awaie i na souyediga faifaidi i na vona-vagasemi. ");
INSERT INTO yml_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","'Awaie ava'ai nuanuaku a na vonemiga, 'Anu'anunu Magemagetana i na lu'ivona 'waimie, bega 'wainega 'aku subia a na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tamaku yana 'ai'aiwabu matatabuna i 'anivelenedi 'waikuye begaidi 'akonadi a vonemi a vo, 'Awaie ava'ai a na voneyeniga, 'Anu'anunu Magemagetana i na lu'ivona 'waimie.’ ");
INSERT INTO yml_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sai'afoga a na 'iawemi 'wa na 'isa'avaku, siwe kebu tutuya manamanawenaga wata 'wa na 'iseku.” ");
INSERT INTO yml_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tovetutuyamavo 'ifwaidi 'aise'avadi i velutoli i vo, Yana vona 'ana nuanua bani'odi? I vonaga i vo, Sai'afoga a na 'iawemi 'wa na 'isa'avaku, siwe kebu tutuya manamanawenaga wata 'wa na 'iseku,’ wata i vo, Fai a na nago Tamada 'waineye.’ ");
INSERT INTO yml_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Wata i vo, Kebu tutuya manamanawenaga,’ 'ana nuanua ava'ai? Aigodi, kebu ta da 'asetai ava'ai i vonevoneyeni.” ");
INSERT INTO yml_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu 'akonadi i 'asetai yadi nuanua, nuanuadi i na velutolieni begaidi i vonedi i vo, Voke nuanuami 'wa na 'asetai yaku vona 'ana nuanua fai a vo, Sai'afoga a na 'iawemi 'wa na 'isa'avaku, siwe kebu tutuya manamanawenaga wata 'wa na 'iseku.’ ");
INSERT INTO yml_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A vona mogitana 'waimie, tutuyanina a na 'iawemi, 'aku mogai 'wa na 'we'wela, we'e Yaubada 'ana tovedumwe'ai'ai i na sosoana. Mogitana 'wa na nuavita siwe tutuyanina 'wa na 'iseku igodi 'wa nunuavitaga 'wa na sosoana. ");
INSERT INTO yml_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tutuyanina vavine i na vebutudi 'eba nuavita fai veviga bwaikina i vevebaedi, siwe tutuyanina kwamana i na tubuga 'eba sosoana bwaikina 'waidie, veviganina nua'ubudie i na yatoi fai natudi i na 'ise'iseni. ");
INSERT INTO yml_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","'Omi wata bani'odi, 'asiau 'wa nuavita siwe tutuyanina a na vilaku a na mai, 'wa na 'iseku 'wa na sosoana mogitana. Yami sosoananina kebu tamu aitoi 'ana fata i na 'ewayavuleni 'waimiega. ");
INSERT INTO yml_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tutuyanina 'waineye kebu wata 'wa na vevelu'ui 'waikuye. We'e a vona mogitana 'waimie, ava'ai nuanuami tonovina 'wa na vevelu'ui 'aku wagavayega Tamaku 'waineye i na velevelemi. ");
INSERT INTO yml_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Basenadi i maiga 'asiau, kebu 'aku wagavayega 'wa da vevelu'ui Tamaku 'waineye, siwe tutuya de'e i velamu bega i na nagoga 'wa na vevelu'ui 'aku wagavayega bega ava'ai nuanuami 'wa na veveluagadi, wata 'wa na sososoana mogitana.” ");
INSERT INTO yml_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Wata Iesu i veifufu yana tovetutuyamavo 'waidie i vo, Naninidi a veifufuyediga vona-awatabaiega, siwe 'awaie kebu wata vona-awatabaiega a na veveifufu, we'e Tamada faifaina a na veifufu 'waimie 'ana lu'eda'aiagalidi. ");
INSERT INTO yml_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tutuyanina 'waineye, ava'ai nuanuami 'wa na velu'ui 'aku wagavayega Tamada 'waineye nika i na velemi. Yau kebu a da veveifufu a na velu'ui Tamada 'waineye faifaimi, we'e mogitana 'omi taunimi 'wa na velu'ui Tamada 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Fai 'wa nuakalikalieku wata 'wa vetumagana yau a mai Yaubada 'wainega Tamada i nuakalikaliemi, begaidi ava'ai nuanuami 'ami fata taunimi 'wa na vevelu'ui 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yau a mai fwayefwayeye Tamada 'wainega, sai'afoga fwayafwaya a na 'iaweni a na vilaku 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Iesu yana tovetutuyamavo yana vona i nogai i vo, We'e vonanina 'ana nogaya kebu vona-awatabaiga, 'u vovonaotoga. ");
INSERT INTO yml_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","'Akonadi 'a 'asetamu, nani matatabuna 'u 'asetadi, kebu tamu wata aitoi 'ana fata i na awave'ede'edemu. Yamu 'asetanina 'a 'iseni 'a vetumagana 'waimuye 'a 'asetai 'omu 'u mai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu i vonedi i vo, 'Alo 'omi be'ama 'wa vetumagana. ");
INSERT INTO yml_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Siwe 'awaie wata 'akonadi i sousouyeni, matatabumi 'wa na vemiave'eve'e'elagi yami vanuga 'aitamogana 'aitamogana 'waidie, we'e yau 'wa na degaloveku. 'Wa na degaloveku siwe kebu mogitana 'aisekuga fai Tamada taiadi 'a miamia. ");
INSERT INTO yml_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Naninidi a voneyediga bega nuanua bikana mia 'atumaina taiadi 'wa na veveluagai 'waikuyega fai yau 'ami labilabina. Mogitana veviga 'wa na veveluagadi Yaubada 'ana tovedumwe'ai'ai 'waidiega siwe kebu 'wa na kolologa, 'wa na vevenuafoufa'ala. 'Akonadi a vetoketoke tomotoga matatabuna 'waidie.” ");
INSERT INTO yml_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu i veifufu'a'ava, mulieta i 'isalaka abame Tamana 'waineye i velu'ui i vo, Tamaku, 'akonadi yaku tutuya i veluagai, yau Natumu nuanuaku 'u na silakaiku, bega 'waikuyega fuedi i na subiamu. ");
INSERT INTO yml_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","'Akonadi 'u tauyeku tomotoga matatabudi a veveimeyedi bega egavo 'u velekuga mia 'atumaina wata miamia-vagaina a na veledi. ");
INSERT INTO yml_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mia-vagatanina 'ana 'eda'eda side bani'odi. Egavo i na 'aseta-'atumaimu 'omu Yaubada mogitana 'aiseotogimu, wata i na 'aseta-'atumaiku yau Iesu Keliso, 'amu Venua'ivina, kumaniku 'u vetuneku, bega mia-vagatanina i na veluagai. ");
INSERT INTO yml_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nani matatabuna 'u voneku a na 'idewadiga, 'akonadi a sigoidi, wata yaku folovanidi 'waidiega tomotoga fuedi i subisubiamu. ");
INSERT INTO yml_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Basenadiotoga fwayafwaya bola kebu i da souyeniga, taiadi ta miamia ma yada 'ai'aiwabu magemagetadi. Nuanuaku 'ai'aiwabunidi 'waidiega 'asiau 'u na 'ive'ai'aiwabuku. ");
INSERT INTO yml_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Basenadi tomia fwayafwaya 'waidiega yamu tomotoga 'u venua'ivinedi. Tomotoganidi 'u velekuga 'waidie a sivemagesemu, bega yamu vona i vematayakeyakedi. ");
INSERT INTO yml_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","'Akonadi i 'asetai nani matatabuna 'u velekuga, 'omu 'waimuyega i maia. ");
INSERT INTO yml_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Vonanidi 'u velekuga a lu'ivoneyedi 'waidie ma yadi sosoana i nogai. Bega i 'aseta-'atumaia yau a mai 'omu 'waimuyega wata i vetumagana 'omu 'u vetuneku. ");
INSERT INTO yml_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Tomotoganidi 'u velekuga faifaidi a vevelu'ui 'waimuye. Kebu tomia fwayafwaya matatabudi faifaidi a da vevelu'ui, siwe tomotoganidi 'u velekuga faifaidi a vevelu'ui fai 'omu yamu tomotoga. ");
INSERT INTO yml_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yaku tomotoga 'asa'aiana yamu tomotoga, we'e yamu tomotoganidi 'u 'anivelenedi 'waikuye bega 'waidiega 'aku subia a veveluagai. ");
INSERT INTO yml_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","'Ako a na wai 'waimuye we'e yaku tovetutuyamavo a na 'iawedi i na miamia de'e bei fwayefwayeye. Tamaku Magemagetamu, nuanuaku 'amu wagava toketokena 'wainega 'aku tovetumaganavo 'u na 'ita'ita'iedi, toketokenanina basenadi 'u velekuga 'wainega. Nuanuaku 'u na 'ita'ita'iedi bega yadi nuanua 'aitamogana bani'odi 'omu wata yau yada nuanua 'aitamogana. ");
INSERT INTO yml_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yau side bei bola taiadi 'a miamia, 'amu wagava toketokena 'wainega a 'ita'ita'iedi, toketokenanina basenadi 'u velekuga 'wainega. 'Waidiega kebu tamu aitoi i da vuyo a ve'isabodebodedi, we'e mogitana 'aitamogana i nunago 'eba vematavuloga 'ana 'edeamo fai basenadiotoga tamu vona tomogonina faifaina i kilumi yamu Buki nageneye, nika 'ana mogitana 'akonadi i souyeni. ");
INSERT INTO yml_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Tutuya de'e a na wai 'waimuye, we'e yaku tovetutuyamavo taiadi 'a miamiani, nani fuedi a veifufuyedi 'waidie bega yaku sosoana 'wainega i na sososoana. ");
INSERT INTO yml_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yamu vona a lu'ivona 'waidie, i nogai begaidi tomotoganidi fwayafwaya 'ana nuanua 'waidie bwaikina, i vevedumwe'ai'aiedi. I vevedumwe'ai'aiediga fai de'e tovetutuyamavo tomotoganidi yadi sauluva sakoidi i bailedi. Yau wata tovedumwe'ai'ainidi kebu yadi 'aila'a 'waineye a da miamia. ");
INSERT INTO yml_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A vevelu'uiga, kebu a da vo, 'U na vagavaidi fwayafwaya de'e 'wainega,’ we'e mogitana a vevelu'ui bega 'u na 'i'ita'ita'iedi Seitani yana nuanua sakoidi 'waidiega. ");
INSERT INTO yml_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tomotoganidi fwayafwaya 'ana nuanua 'waidie bwaikina, yau wata yaku tovetutuyamavo kebu 'adi 'aila'a nageneye 'a da miamia. ");
INSERT INTO yml_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Wata a vevelu'ui 'waimuye, Yaubada 'amu 'aseta mogitana 'wainega yaku tovetutuyamavo 'u na 'ivevunavunagidi bega magemagetadi matamuye. ");
INSERT INTO yml_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Basenadi 'u vetuneku a mai tomia fwayafwaya 'awasasadie, yau wata bani'odi yaku tovetutuyamavo a vevetunedi tomotoganidi 'awasasadie. ");
INSERT INTO yml_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yaku tovetutuyamanidi faifaidi tauniku a tauyeku 'waimuye bega tomotoganidi wata taunidi i na tauyedi mogitana 'waimuye, yamu 'aila'a. ");
INSERT INTO yml_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Kebu yaku tovetutuyamavo 'aise'avadi faifaidi a da vevelu'ui, siwe yadi veifufu wata yadi lau'age 'waidiega egavo i na vetumagana 'waikuye, faifaidi a vevelu'ui. ");
INSERT INTO yml_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","A vevelu'ui nuanuaku matatabudi yadi nuanua 'aitamogana. Tamaku, 'omu 'u labilabiniku wata yau 'amu labilabina, wata bani'odi nuanuaku tomotoganidi taiadi ta na miave'itubama bega yadi nuanua 'aitamogana, mali tomotoga i na 'isedi i na vetumagana 'u vetuneku a mai. ");
INSERT INTO yml_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Basenadi yamu toketokena magemagetana 'u veleku, yau wata bani'odi toketokenanina a veledi bega yadi nuanua 'aitamogana bani'odi 'omu wata yau 'aitamogana. ");
INSERT INTO yml_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yau 'adi labilabina, 'omu 'u labilabiniku, bega mogitana yadi nuanua i na luvetubama nika 'aitamogana. Mali tomotoga i na 'isedi i na 'asetai 'u nuakalikaliedi bwaikina bani'odi yau 'u nuakalikalieku, wata i na 'asetai 'u vetuneku a mai. ");
INSERT INTO yml_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tamaku, nuanuaku tomotoganidi 'u velekuga ava'aibe bei a na miamiaga wata taunidi taiadi, bega yaku 'ai'aiwabu magemagetadi i na 'isedi. Fai 'u nuakalikalieku bwaikina, fwayafwaya bola kebu i da souyeniga, 'ai'aiwabunidi 'u veleku. ");
INSERT INTO yml_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamaku, yamu veimea tonovidi. Tomotoganidi fwayafwaya 'ana nuanua bwaikina 'waidie i bavuyemu, we'e yau a 'asetamu wata yaku tomotoga i 'asetai 'omu 'u vetuneku. ");
INSERT INTO yml_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'Amu 'aseta faifaina a lu'ivona 'waidie, wata a na lulu'ivona 'waidie bega 'u nuakalikaliekuga wata bani'odi nuakalikalinina i na 'eno'eno nagedie, we'e yau a na labilabinidi.” ");
INSERT INTO yml_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu yana velu'ui i 'a'ava, mulieta yana tovetutuyamavo taiadi Ielusalema i 'iaweni i nagoi i obu Ufa Kidiloni i damani no'o bega i laka. Bei welavi fuedi i tovotovoi, nagedie i luku. ");
INSERT INTO yml_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iudasa kumanina Iesu 'ana to'etogiluva, 'awalawanina i 'asetai fai tutuya fuedi Iesu ma yana tovetutuyamavo bei i nunagoi. ");
INSERT INTO yml_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Lovananina 'waineye Falisi wata tovelomu yadi to'edakumetavo Iudasa i tauyeni, bega me Loma tolugaviavo wata Vanuga 'Eba Velu'ui 'ana tolumadu'aivo taiadi i maia, ma yadi fulumai i laudukala i le'wa 'awalawanina 'waineye ");
INSERT INTO yml_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","5","Iesu 'akonadi i 'asetai sai'afoga ava'ai i na souyeni 'waineye begaidi tutuyanina Iudasa tolugaviavo taiadi i le'wai, Iesu i vaganago 'waidie i velutoliedi i vo, Aitoi 'wa lulualeni?” Tolugaviavo i vo, Tomogo Nasaledi 'ana wagava Iesu.” Iesu i vo, Yau side tauniku.” ");
INSERT INTO yml_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tutuyanina Iesu i vonedi i vo, Yau side tauniku,” tolugaviavo i vemuliuga i nagoi i be'u i ve'ufo'ufobala. ");
INSERT INTO yml_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wata Iesu i velutoliedi i vo, Aitoi 'omi 'wa lulualeni?” Tolugaviavo i vo, Tomogo Nasaledi 'ana wagava Iesu.” ");
INSERT INTO yml_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu i vo, 'Akonadi a vonemi a vo, Yau side 'asa'aiana tauniku.’ Fai nuanuami yau, de'e yaku tovetutuyamavo 'wa na vonedi i na nagoi.” ");
INSERT INTO yml_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iesu i vonaga i vo, 'Wa na vonedi i na nagoi,” nika yana vonanina basenadi 'ana mogitana i souyeni fai i vo, Tamaku, tomotoganidi 'u velekuga 'waidiega kebu tamu aitoi a da baileni a 'ita'ita'iedi.” ");
INSERT INTO yml_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimoni Fita yana kefata i yo'ei tovelomu bwaikina yana tofolova igodi i da nikei, taniga'avana 'ana 'atagiega i tutuomuya. Tofolovanina 'ana wagava Maleko. ");
INSERT INTO yml_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iesu Fita i talabodeni i vo, 'Asa'aiana, yamu kefata 'u dodogi 'ana 'eba 'aidodoga 'waineye. I lubwaineku vita wata wafa a na veluagadi fai Tamaku nuanuana, we'e 'omu yana nuanuanina 'u tatalabodeni.” ");
INSERT INTO yml_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tolugaviavo ma yadi toeva biola wata Vanuga 'Eba Velu'ui 'ana tolumadu'aivo taiadi, Iesu i 'ive'avini i yogoni. ");
INSERT INTO yml_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Mulieta i 'ewai i naweni Anasa 'waineye. Kumanina natuna yadi lamoga tovelomu bwaikina malamalanina 'waineye, 'ana wagava Kaiafa. ");
INSERT INTO yml_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafa kumanina basenadi me Diu to'edakumetavo i vonedi i vo, 'Omi kebu 'wa da 'asetai, 'ana laubwaina tomogo 'aitamogana i na wafa tomotoga fuedi faifaidi.” ");
INSERT INTO yml_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimoni Fita wata tamu tovetutuyama Iesu i yogo'waili. Ma fuedie i le'wai tovelomu bwaikina yana vanuge, vanuganina kalikalina, nageneye i luku tamu 'awasasa 'waineye. Fai tovetutuyamanina tovelomu bwaikina i veianeni begaidi i tauyedi, Iesu taiadi i luku. ");
INSERT INTO yml_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","We'e Fita i tovotovoi tanotanoge kali 'ana 'awa lilivaneye we'e iana, kumanina tovelomu bwaikina i 'asetai i vilai i mai vavine ne'e'elina 'awa 'ana to'isave'avina Fita i voneni i tauyeni i luku. ");
INSERT INTO yml_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Vavinenina ne'e'elina Fita i voneni i vo, Voke 'omu kumanimu no'o tomogonina tamu yana tovetutuyama.” Siwe Fita i ve'ewa i vo, Yau tuliku.” ");
INSERT INTO yml_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Fai kaukau, tofolovavo wata tolugaviavo 'ai i levai mula'wanega bei i vevevala. Wata Fita i nago lilivadie i tovoi ma fuedie i vevevala. ");
INSERT INTO yml_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Vanuganina nageneye tovelomu bwaikina Iesu i velutolitolieni yana tovetutuyamavo wata yana ve faifaidi. ");
INSERT INTO yml_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yana vona Iesu i tutuli i vo, Yau tutuya fuedi mageseye a veveifufu 'aila'a 'waidie. Kebu a da givagiva a da veve, yaku ve matatabuna Vanuga 'Eba Velu'ui nageneye wata 'eba miava'auta 'waidie me Diu fuedi 'waidie. ");
INSERT INTO yml_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Awale 'u velutolitolieku? Nuanuamu velutoli, tomotoganidi yaku vona i noganogaidi 'waidie 'u da velutoli. Ava'ai a voneyediga i 'asetadi, 'adi fata i na lu'ivona 'waimuye.” ");
INSERT INTO yml_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","De'e bani'odi Iesu i vonevoneyediga, tamu Vanuga 'Eba Velu'ui 'ana tolumadu'ai Iesu maigineye i 'ainike wata i vo, Awale we'e bani'odi 'u voneyedi yada tovelomu bwaikina 'waineye, kebu 'u da ve'ililibuyeniga.” ");
INSERT INTO yml_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tolugavia yana vona, Iesu i tutuli i vo, 'Ai'edi a vekaliga, 'u na lu'ivona tomotoga 'waidie, we'e 'ai'edi a vona tonovina, awale 'u nikeku?” ");
INSERT INTO yml_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anasa yana velutoli i 'a'ava, Iesu yogoyogonina i vetunei i nago tovelomu bwaikina Kaiafa 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Fita bola i vevevala, 'ifwaidi tomotoga i voneni i vo, Voke 'omu no'o tomogonina tamu yana tovetutuyama.” Siwe Fita i ve'ewa i vo, Kebu, yau tuliku.” ");
INSERT INTO yml_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tovelomu bwaikina yana tofolova, kumanina Fita tanigana i tutuomuya we'e iana tamu wata taunina tofolova i vona Fita 'waineye i vo, 'Asiau 'a waia Iesu 'a 'ive'avini voke a 'isemu Iesu taiadi.” ");
INSERT INTO yml_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Wata Fita i ve'ewa i vo, Kebu,” nika kamukamu i kwage. ");
INSERT INTO yml_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","'Awa'awaiogose Kaiafa yana vanugayega me Diu to'edakumetavo Iesu i vagavaia i naweni Loma kabemani 'adi to'edakumeta yana vanuga bwaikina 'waineye 'ana wagava Failato. Taunina kebu tomogo Diu, begaidi me Diu i vo, 'Ai'edi ta na luku yana vanuge, ta na veyoke Yaubada mataneye bega kebu 'ada fata Uvi'agalatagona sakalina ta na 'ani.” ");
INSERT INTO yml_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Fai nuanuadi i na miamiani tanotanoge, begaidi Failato i souyeni yana vanugayega i mai i velutoliedi i vo, Ava'ai faifaina tomogo de'e 'wa vevitai?” ");
INSERT INTO yml_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Me Diu yana vona i tutuli i vo, 'Ai'edi kebu yana sakonaga, 'ako kebu 'a da mieniga.” ");
INSERT INTO yml_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bega Failato i vonedi i vo, 'Wa naweni i na vonayavuga 'waimie. 'Ai'edi ma yana sakona taunimi yami veimea 'waidiega vematavuloga 'wa na veleni.” Me Diu to'edakumetavo Failato i voneni i vo, Nuanuama i na wafa yana sakona faifaina, siwe 'omi me Loma 'wa talabodema. Nuanuama 'u na vona i na wafa 'ai lagalagana 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Basenadi Iesu i vona-vagata 'awaie i na wafa 'ai lagalagana 'waineye, tutuyanina me Diu i vo, Nuanuama 'ai lagalagana 'waineye i na wafa,” nika Iesu yana vonanina 'ana mogitana i souyeni. ");
INSERT INTO yml_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Failato i vilai i luku yana vanuge, tomotoga i vonedi Iesu i naweni 'waineye i voneni i vo, 'Alo 'omu kumanimu me Diu yadi kini?” ");
INSERT INTO yml_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu Failato i voneni i vo, Yamu vonanina, 'omu yamu nuanua 'alo mali tomotoga i vonemuna bani'odi 'u voneyedi?” ");
INSERT INTO yml_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Wata Failato i vo, 'Alo yau tomogo Diu bani'odi a da voneyedi? Taunimu yamu tomotoga wata tovelomu yadi to'edakumetavo i 'anivelenemu 'waikuye. Siwe ava'ai yamu sakonaga?” ");
INSERT INTO yml_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu i voneni i vo, De'e bei fwayefwayeye kebu yaku 'Eba Veimea i da 'eno'eno. We'e 'ai'edi yaku 'eba veimea fwayefwayeye i da 'eno'enoga, 'ako yaku tofolovavo i da 'ikasikasisieku me Diu yama to'edakumetavo taiadi i da vetalaga 'aku 'ita'ita'i faifaina. Yaku veimea lamuna kebu fwayafwaya 'wainega.” ");
INSERT INTO yml_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Bega Failato i vo, 'Alo 'omu kini?” Iesu i voneni i vo, 'U vonaga yau kini, 'u vona mogitana. Kumanina faifaina a mai fwayefwayeye a tubuga, a vevetolu'ivona Yaubada 'ana 'aseta mogitana faifaina. Egavo nuanuadi 'asetanina, yaku vona i noganogaidi.” ");
INSERT INTO yml_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Failato i vo, Ava'ai 'asetaga mogitana?” Mulieta Failato i vilai i obu tanotanoge me Diu i vonedi i vo, Kebu 'aku fata a na veimea i na wafa fai kebu tamu yana sakona a da veluagai. ");
INSERT INTO yml_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Siwe yami sauluva malamala 'aitamogana 'aitamogana Uvi'agalatagona 'ana sakali 'waineye 'wa vonavona tamu tomogo a 'e'etoyavuya vanuga yogona 'wainega. Bega nuanuami me Diu yami kini a na 'etoyavuya?” ");
INSERT INTO yml_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","I vegolegole i vo, Kebu, kebu kumanina yama nuanuaga. Nuanuama Balaba 'u na 'etoyavuya.” Balaba kumanina tovainago wata to'ainike. ");
INSERT INTO yml_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Failato 'aila'a bonadi i nogai, bega Iesu i 'ewai i naweni yana vanuge tolugaviavo i vonedi i toke i fitali. ");
INSERT INTO yml_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tolugavianidi 'ou'ou nigodi ma yana 'ibadi i 'etofifini Iesu 'unu'ununeye i biuleni wata talauma yamoyamoinega i ve'weseni. Vaigavunidi kini 'adi vaigavu 'adi 'isa'isa bani'odi, 'wainega Iesu i sidibidibieni. ");
INSERT INTO yml_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wata i ve'ililibu-vekavekali 'waineye i vo, Kaiwa, 'omu me Diu yadi kini.” I 'a'avana maigineye i 'ainike. ");
INSERT INTO yml_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Wata Failato i vilai i obuma 'aila'a i vonedi i vo, Tomogonina a na mieni 'wa na 'iseni, 'wa na 'asetai kebu tamu sakona a da veluagai 'wainega, bega kebu 'aku fata a na veimea i na wafa.” ");
INSERT INTO yml_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iesu i obumaga tanotanoge ma 'ivivigavuna, 'ou'ou nigodi 'etofifinina 'unu'ununeye wata talauma yamoyamoinega i ve'weseni. Failato 'aila'a i vonedi i vo, 'Wa 'isamaieni, side tomogonina.” ");
INSERT INTO yml_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tutuyanina tovelomu yadi to'edakumetavo wata Vanuga 'Eba Velu'ui 'ana tolumadu'aivo Iesu i 'iseni i vegolegole i vo, 'U tutufwaseni 'ai lagalagana 'waineye, 'u tutufwaseni 'ai lagalagana 'waineye.” Failato i vonedi i vo, 'Omi taunimi 'wa tutufwaseni 'ai lagalagana 'waineye. Kebu i da lubwaineni i na wafa, fai kebu yana sakonaga.” ");
INSERT INTO yml_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Me Diu i vo, I lubwaineni i na wafa fai yada veimea i geuya. 'A nogai igodi i vo, Yau Yaubada Natuna.’” ");
INSERT INTO yml_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Iesu yana vonanina me Diu i lu'ivoneyeni Failato i nogai i kololo bwaikina. ");
INSERT INTO yml_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Begaidi i vilai i luku vanuge, Iesu i voneni i vo, Nuanuaku a na 'asetai 'omu ava'aiega 'u mai?” Siwe Iesu kebu tamu ava'ai i da voneyeniga Failato 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Wata Failato Iesu i voneni i vo, Awale kebu bonaku 'u da tutuliga? Yau ma yaku veimea 'aku fata a na 'etoyavumu wata 'aku fata a na veimea i na tutufwasemu 'ai lagalagana 'waineye.” ");
INSERT INTO yml_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu i vona i vo, 'Ako kebu 'u da veimeyekuga, siwe fai Yaubada veimea i velemu, 'amu fata 'u na veimeyeku. Yamu veimeanina 'wainega 'u sakona, siwe tomogonina i 'aniveleneku 'waimuye yana sakona bwaikaotogina.” ");
INSERT INTO yml_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Vonanina Failato i nogai nuanuana bwaikina Iesu i na 'etoyavuya, siwe me Diu kebu nuanuadi. Begaidi i vegolegole i vo, 'Ai'edi aitoi taunina i na awa'ai'aia i na vo, Yau kini,’ tomogonina me Loma yami to'edakumeta bwaikaotogina Sisa 'ana gavia. 'Ai'edi Iesu 'u na 'etoyavuya 'omu kebu Sisa ianaga, fai Iesu taunina i awa'ai'aia nuanuana i na ve-kini.” ");
INSERT INTO yml_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tutuyanina Failato me Diu yadi vona i nogai Iesu i vagavaia i obuyeni didige, 'eba vonayavuga 'waineye bei Failato i miabui. Didiganina 'ana wagava Didiga Bababana, me Diu bonadiega i goleni Kabada. ");
INSERT INTO yml_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","'Akonadi 'aiata-'wana'wana, we'e 'awa'awai me Diu i na sakali Uvi'agalatagona faifaina. Failato me Diu i vonedi i vo, Side yami kini.” ");
INSERT INTO yml_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Me Diu i vegole-vaitugana i vo, 'U luvewafai, 'u luvewafai, 'u tutufwaseni 'ai lagalagana 'waineye.” Failato i velutoliedi i vo, Nuanuami yami kini a na tutufwaseni 'ai lagalagana 'waineye?” Tovelomu yadi to'edakumetavo Failato yana vona i tutuli i vo, Iesu kumanina kebu yama kini. Yada kini 'aitamogana Sisa.” ");
INSERT INTO yml_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Failato nuanuana nuadi i na 'iveagiagidi bega Iesu i 'aniveleneni 'waidie i na tutufwaseni 'ai lagalagana 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iesu i 'ewai i naweni, we'e 'ana 'ai lagalagana taunina i eva. Ma fuedie i nagoi i le'wai tamu 'awalawa 'ana wagava 'Unu'unu 'waineye, me Diu bonadiega i goleni Goligota. ");
INSERT INTO yml_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","'Awalawanina 'waineye bei Iesu i tutufwaseni 'ai lagalagana 'waineye. Wata tomotoga 'adi 'ailuga i tutufwasedi 'ai lagalagana 'waidie, tamu wamayega, tamu 'atagiega, we'e Iesu kamwaneye. ");
INSERT INTO yml_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Failato tamu vona i kilumi tolugaviavo i veledi Iesu 'ana 'ai lagalagana 'waineye i tutufwaseni. Vonanina i kilumiga side bani'odi. DE'E TOMOGO NASALEDI 'ANA WAGAVA IESU, ME DIU YADI KINI. ");
INSERT INTO yml_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","'Awalawanina bei Iesu i tutufwaseniga kebu 'ani'iega, Ielusalema lilivaneye begaidi tomotoga fuedi i lu'iawawai. Vonanina bona 'adi 'aitonu 'waidiega Failato i kilumi, me Loma, me Kuliki wata me Diu bonadiega. ");
INSERT INTO yml_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tovelomu yadi to'edakumetavo i 'iseni i nagoi Failato i voneni i vo, Awale 'u kilumi 'u vo, Me Diu yadi kini?’ Nuanuama 'u da kiluma side bani'odi. Tomogo de'e igodi i vo, Yau me Diu yadi kini.’” ");
INSERT INTO yml_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Siwe Failato i vonedi i vo, Ava'ai 'akonadi a kilumiga, 'asa'aiana bani'odi i na 'eno'eno.” ");
INSERT INTO yml_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","Tolugaviavo Iesu i tutufwaseni i 'a'avana, tolugavia 'adi 4 'ana talauma i 'ewadi, i veusedi. Wata tamu 'ana talauma i 'iseni kebu 'ana tubwaga tabwanega i obu begaidi i vo, Kebu ta na labu'iga, tamu 'wava ta na 'waveni bani'odi kate, ta na 'iseni aitoi i na kumeta kumanina i na 'ewa.” Naninina i 'idewaiga, nika tamu vona basenadiotoga Yaubada yana Buki nageneye i kilumiga, 'ana mogitana i souyeni i vo, 'Aku talauma i veusedi 'aitamogana 'aitamogana 'waidie, wata 'aku talauma faifaina i 'wava bani'odi kate.” Fai bani'odi i voneyediga, begaidi tolugaviavo bani'odi i 'idewai. ");
INSERT INTO yml_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iesu 'ana 'ai lagalagana lilivaneye vevine 'adi 4 i tovotovoi. Side vevinenidi, Iesu inana ma taidi, Kilofa yana vavine 'adi wagava Meli, wata tamu Meli 'atamana Magidala 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesu i 'isaobu inana wata yana tovetutuyama kumanina i nuakalikalieni i 'isedi taiadi i tovotovoi, bega inana i vonedi i vo, Inaku, siwe natumi.” ");
INSERT INTO yml_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","We'e tovetutuyamanina i voneni i vo, Iaku, siwe inamu.” Bei tutuyanina 'waineye i nawedi yana vanuge i 'i'isave'avinidi. ");
INSERT INTO yml_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iesu 'akonadi i 'asetai nani matatabuna i sigoidi wata fai nuanuana Yaubada yana Buki nageneye basenadiotoga i kilumiga 'ana mogitana i na souyeni begaidi i vo, 'Anigoku i lala.” ");
INSERT INTO yml_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Bei Iesu i tutufwaseniga tamu oine yuyuna ma 'aivoena i 'eno'eno. Tomotoga Iesu bonana i nogai, bega kikifa i 'ewai i lu'utuvi oine 'waineye, tamu 'ai 'waineye i velugaganeni i 'iyoyoeni Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesu oine i yemuyana i vo, I 'a'ava,” nika i 'odu, yawaina i tauyeni i wafa. ");
INSERT INTO yml_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iesu i wafa 'aiata 'idewadewa 'waineye. Me Diu to'edakumetavo kebu nuanuadi tomotoganidi tomogodi i na 'eno'eno 'ai lagalagana 'waidie 'Aiata Veawai 'waineye, wata fai 'awa'awai bani'odi 'Aiata Veawai bwaikina Uvi'agalatagona faifaina. Begaidi to'edakumetanidi i nagoi Failato 'waineye i velu'ui nuanuadi i na tauyedi bega tomotoganidi 'ai lagalagana 'waidie 'agedi i na tutubaidi bega i na wafa-matayo'o, mulieta i na ta'idi. ");
INSERT INTO yml_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Failato i tauyedi bega tolugaviavo i vonedi i nagoi tomotoga 'adi 'ailuga kumanidiavo Iesu taiadi i tutufwasediga, 'agedi i tutubaidi. ");
INSERT INTO yml_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Iesu 'waineye i le'wai i 'iseni 'akonadi taunina i wafa bega kebu 'agena i da tutubaidi. ");
INSERT INTO yml_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","We'e tamu tolugavia Iesu nuvilaneye i 'ailovena, nika dayaga wata ufa i kausewa. ");
INSERT INTO yml_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tamu tomogo mataotogineye i 'iseni dayaga wata ufa i kausewa bega i lu'ivoneyeni, yana lu'ivonanina vona mogitana. I vona mogitana wata i 'asetai kebu i da vekali bega 'omi wata 'wa na vetumagana Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tolugaviavo kebu Iesu 'agena i da tutubaidiga bega ava'ai basenadiotoga i kilumi Yaubada yana Buki nageneye 'ana mogitana i souyeni i vo, Kebu tamu luluna i na tutubaia.” ");
INSERT INTO yml_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wata tamu vona basenadiotoga i kilumi i vo, Tomogonina i loveniga tomotoga i na vemata'i'i'ieni.” ");
INSERT INTO yml_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mulieta tamu tomogo 'atamana Alimadia 'wainega 'ana wagava Iosefa, i nago i velu'ui Failato 'waineye Iesu tomogona faifaina. Iosefa tamu Iesu yana tovetutuyama siwe kebu nuanuana i na lu'ivona fai me Diu to'edakumetavo i kololoyedi. Iosefa yana velu'ui faifaina Failato i awave'atumaieni bega i voneni i nago Iesu tomogona i ta'ia i naweni. ");
INSERT INTO yml_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","We'e Nikodimo, basenadi kumanina lovane i nago Iesu 'waineye, bunama 'atumaidi wata bwaikidi i 'ewadi i mai Iosefa taiadi i nago. Bunamanidi 'adi wagava Mulo wata Aloe 'adi vita 'ana 'etowava bani'odi 30 kilogalamu. ");
INSERT INTO yml_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tomotoganidi 'adi 'ailuga Iesu tomogona i naweni kaleko manamanawedi 'waidiega i fania bunamanidi taiadi, bani'odi me Diu yadi sauluva ve'ufa faifaina. ");
INSERT INTO yml_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","42","Fai sai'afoga me Diu yadi 'Aiata Veawai i na velamu, bega tamu taumata kebu 'ani'iega vivideye bei Iesu i ve'ufai. Taumatanina basenadi i ala-vagaseni matumatu 'waineye bei kebu tamu aitoi i da ve'ufai, we'e lilivaneye welavi fuedi i tovotovoi. ");
INSERT INTO yml_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Me Diu yadi 'Aiata Veawai i 'a'avana, Tafalolo bola matalovalovanineye, Meli vavine Magidala i tovoi i nago taumaseye. Tutuyanina i le'wa i 'iseni kileu taumata 'awana 'ana vetoviboda 'akonadi i ketoi. ");
INSERT INTO yml_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bega i lilide i mai Saimoni Fita wata tamu tovetutuyama, kumanina Iesu i nuakalikalieni bwaikina, i vonedi i vo, 'Auvea tomogona i 'ewai taumata 'wainega siwe kebu ta da 'asetaiga ava'aibe bei i yatoi.” ");
INSERT INTO yml_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Begaidi Fita ma iana i tovoi i nagoi taumaseye. ");
INSERT INTO yml_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","I ve'ilililide iana i kumeta i le'wa-matayo'o taumaseye. ");
INSERT INTO yml_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","I lukemula i 'iseni kaleko'ava bagase bega Iesu tomogona i fania, siwe kebu i da lukuga. ");
INSERT INTO yml_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Saimoni Fita i vemuli i le'wa tonovina i luku, kalekonidi i 'isedi wata Iesu 'unu'ununa 'ana fanifani. Fanifaninina nununumina siwe tulineye i 'eno'eno. ");
INSERT INTO yml_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mulieta iana wata i luku Iesu i 'isa'avai, i vetumagana Iesu 'akonadi i tovoi. ");
INSERT INTO yml_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Siwe kebu mogitana i da 'aseta-'atumaia ava'ai basenadiotoga i kilumi Yaubada yana Buki nageneye, i lubwaineni Iesu i na tovoi-vaitugana wafayega. ");
INSERT INTO yml_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nika i viladi i nagoi vanuge. ");
INSERT INTO yml_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Meli 'atamana Magidala 'wainega i vilai i nago taumaseye bei i tovoi i 'we'we'wela. Wata i lukemula anelose 'adi 'ailuga i 'isedi ma 'adi talauma 'avu'avudi. Bei Iesu i ve'enoviga 'waineye i miamiani, tamu 'unu'ununega, tamu 'agenega. ");
INSERT INTO yml_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tomotoganidi 'adi 'ailuga Meli i velutolieni i vo, Vavine, ava'ai faifaina 'u 'we'we'wela?” Yadi velutoli i tutuli i vo, Yaku 'Auvea i 'ewai, siwe kebu a da 'asetaiga ava'aibe bei i yatoi.” ");
INSERT INTO yml_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","I vona'a'ava i sivilai Iesu i 'iseni i tovotovoi, siwe kebu i da 'isa'inanaiga. ");
INSERT INTO yml_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu i velutoli i vo, Vavine, ava'ai faifaina 'u 'we'we'wela? Aitoi kumanaga 'u lulualeni?” Meli yana nuanua i vo 'ako 'awalawanina 'ana to'isave'avina, begaidi i vo, 'Ai'edi Iesu tomogona 'u 'ewaiga, nuanuaku 'u na voneku ava'aibe bei 'u yatoi, bega a na nago a na 'ewai.” ");
INSERT INTO yml_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu i vona Meli 'waineye i vo, Meli.” Meli i sivilai i 'isanago me Diu bonadiega i vo, Labonai,”'ana saivila Tove. ");
INSERT INTO yml_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu i voneni i vo, Kebu 'u na 'abitonovikuga, yau bola kebu a da laka Tamada 'waineye. Siwe nuanuaku 'u na nago ekwavo 'waidie side bani'odi 'u na voneyedi 'u na vo, A na vilaku a na nago Tamaku 'waineye, Tamakunina 'omi wata Tamami, yaku Yaubada wata 'omi yami Yaubada.’” ");
INSERT INTO yml_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Iesu i vona'a'ava, mulieta Meli i vilai i mai tovetutuyamavo 'waidie, i vonedi i vo, Yau 'Auvea a 'iseni,” wata ava'ai i voneniga i lu'ivona 'waidie. ");
INSERT INTO yml_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tafalolo lovananina 'waineye, Iesu yana tovetutuyamavo me Diu to'edakumetavo i kololoyedi begaidi vanuga i sibodai nageneye i miasai'auga i miamiani. I veveifufu nika Iesu 'awasasadie i souyeni i vonedi i vo, Ma yami sosoana 'wa na miamiani, kebu 'wa na kololo.” ");
INSERT INTO yml_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","I vona'a'ava, mulieta 'ana kini'ona i vedi, nimana 'waidie wata nuvilaneye. Matatabudi i sosoana-'afo'afo fai 'Auvea i 'iseni. ");
INSERT INTO yml_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Wata Iesu i vona-vaitugana 'waidie i vo, Ma yami sosoana 'wa na miamiani, kebu 'wa na kololo. Basenadi Tamada i vetuneku a mai tomia fwayafwaya 'waimie, wata bani'odi 'omi a vevetunemi tomia fwayafwaya 'awasasadie.” ");
INSERT INTO yml_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","23","I vona'a'ava nika yawaina i tauyavuleni 'waidie i vonedi i vo, 'Anu'anunu Magemagetana a velevelemi, 'wa na lu'uma'umaieni nika i na agemi. 'Ai'edi tomotoga yadi sakona 'wa na nuatavunidi wata Yaubada i na nuatavunidi. We'e 'ai'edi kebu 'wa na nuatavunidiga wata nuatavuna kebu i na veluagai Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tutuyanina Iesu i souyeni yana tovetutuyamavo 'waidie, Tomasi kebu taiadi i da miamiaga, taunina iadi, tamu 'ana wagava Natulugaluga. ");
INSERT INTO yml_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Iesu i tauya i nago, mulieta Tomasi i le'wa i voneni i vo, 'Ima 'Auvea 'a 'iseni.” Tomasi i vonedi i vo, Yau kebu a na vetumagana Iesu i tovoiga faifaina, nagami 'ana kini'ona a da 'isedi nimaneye wata neli 'awa'ividi a da 'abitonovidi wata lumalumaneye 'ibadi 'awa'ivina 'waineye nimaku a da silukuveni, mulieta a da vetumagana.” ");
INSERT INTO yml_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","'Aiata 7 i 'a'ava, mulieta wata Iesu i souyeni. Tutuyanina 'waineye yana tovetutuyamavo matatabudi Tomasi taiadi i saiboda i miamiani, nika Iesu i souyeni 'awasasadie. I vonedi i vo, Ma yami sosoana 'wa na miamiani, kebu 'wa na kololo.” ");
INSERT INTO yml_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mulieta Tomasi i voneni i vo, Nimaku 'u 'isedi, 'u 'abitonovidi wata nimamu 'u na 'otoi nuvilakuye 'u na silukuveni. We'e venuanaluganina 'u baileni, 'u na vetumaganamo.” ");
INSERT INTO yml_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi i vo, 'Omu yaku 'Auvea wata yaku Yaubada.” ");
INSERT INTO yml_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Wata Iesu Tomasi i voneni i vo, Fai 'u 'iseku, begaidi 'u vetumagana. We'e egavo kebu i da 'isekuga i vetumaganamo, 'eba sosoana bwaikina 'waidie.” ");
INSERT INTO yml_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu folova toketokedi fuedi 'eba nuavogana wata 'eba nua'ewa i 'idewadi yana tovetutuyamavo matadie, siwe kebu matatabuna 'adi kilumaga buki de'e 'waineye. ");
INSERT INTO yml_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Naninidi 'akonadi kilukilumidi 'wa na lu'iawawadi bega 'wa na vetumagana Iesu Keliso taunina Yaubada Natuna wata 'ana Venua'ivina. Vetumagananina 'wainega mia 'ivauna wata miamia-vagaina 'wa na veluagai Iesu 'wainega. ");
INSERT INTO yml_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tamu tutuya Iesu yana tovetutuyamavo i nagoi Lavu Galili, wata bei Iesu i vemageta 'waidie. Yana souyagi side bani'odi. ");
INSERT INTO yml_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","3","Saimoni Fita, Tomasi tamu 'ana wagava Natulugaluga, Nataniela 'ana tuvada Kena 'awalawa Galili nageneye, Sebedi natunavo wata tovetutuyamavo 'adi 'ailuga i miamiani nika Saimoni Fita i vo, A na nago a na vuata.” Enavo i voneni i vo, Ma fuedeye ta na nagoi.” Bega i tovoi i nagoi, waka i 'ewai i laka i vuata, siwe lovananina matatabuna kebu tamu sai'afo igana i da 'onadi. ");
INSERT INTO yml_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Inala i vulaoga Iesu i 'iseni i tovotovoi balebaleye siwe kebu i da 'isa'inanaiga. ");
INSERT INTO yml_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","I vegole 'waidie i vo, Kwakwama, igana 'wa 'onadi, 'alo kebu?” I vo, Kebu'a'avaotoga.” ");
INSERT INTO yml_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wata i vegole 'waidie i vo, 'Ami 'atagiega 'wa na lelega, nika 'wa na 'onadi.” Yana voneye i lelegeni, siwe kebu 'adi fata vuata i na yo'ei fai igana fueotogidi i 'ona. ");
INSERT INTO yml_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tovetutuyamanina Iesu i nuakalikalieni bwaikina, Fita i voneni i vo, Fita, va'e 'Auvea.” Saimoni Fita i nogai iana i vo, Va'e 'Auvea,” bega 'ana talauma i 'ewai i ve'wesena, fai 'akonadi i yavudi ma 'ana iviga'ava yaubani faifaina, i sou i kayo i obu. ");
INSERT INTO yml_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","We'e tovetutuyamavo 'ifwaidi wakayega i voi, vuata ma iganina i yo'ei i obuyeni. Kebu 'ani'iega, bani'odi 'atagida 'ana vemanawe. ");
INSERT INTO yml_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tutuyanina 'avale i obu i 'iseni mula'wa i 'ala'alata, mula'wanina 'waineye igana wata 'ani'ani i 'ala'alaidi. ");
INSERT INTO yml_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu i vonedi i vo, Igana 'asiauotoga 'wa 'onadiga, 'ifwaidi 'wa na miedi.” ");
INSERT INTO yml_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimoni Fita i laka wakeye vuata ma iganina i yo'ei i lakama 'avale. Igananidi bwaikidi wata matatabuna 153. Fueotogidi siwe vuata kebu i da bwekaiga. ");
INSERT INTO yml_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Fita igana i miedi mulieta Iesu i vonedi i vo, 'Wa maia 'wa na 'ani.” Tovetutuyamavo 'waidiega kebu tamu aitoi nuanuana i na velutoli i na vo, 'Omu aitoi?” Fai 'akonadi i 'asetai taunina mogitana 'Auvea. ");
INSERT INTO yml_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Bega Iesu i nago 'ani'ani i 'ewadi i veledi, wata igana bani'odi. ");
INSERT INTO yml_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","De'e Iesu yana souyagi 'ana vetonu yana tovetutuyamavo 'waidie tutuyanina i tovoi wafayega. ");
INSERT INTO yml_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","'Ani i 'a'ava, mulieta Iesu i velutoli Saimoni Fita 'waineye i vo, Saimoni, 'omu Ioni natuna, nuanuaku a na 'asetai, mogitana 'u nuakalikalieku bwaikina we'e emwavo sai'afo?” Fita i vo, E'e 'Auvea, 'akonadi 'u 'asetaku a nuakalikaliemu.” Iesu i vo, Egavo i vetumagana 'waikuye siwe bola mweamweadi nuanuaku 'u na veve 'waidie bega i na vetoketoke, 'wa da vo bani'odi yaku sifi siaidi 'u da veve'anidi.” ");
INSERT INTO yml_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wata 'ana veluga Iesu i velutoli Fita 'waineye i vo, Saimoni, 'omu Ioni natuna, mogitana 'u nuakalikalieku bwaikina?” Fita i vo, E'e 'Auvea, 'akonadi 'u 'asetaku a nuakalikaliemu.” Iesu i vo, Egavo i vetumagana 'waikuye, nuanuaku 'u na 'i'ivaisedi, 'wa da vo bani'odi yaku sifi 'u da 'i'isave'avinidi.” ");
INSERT INTO yml_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Wata 'ana vetonu i velutolieni i vo, Saimoni, 'omu Ioni natuna, 'u nuakalikalieku?” Iesu yana velutoli 'ana vetonu 'waineye Fita nuana i vita, i voneni i vo, 'Auvea, nani matatabuna 'u 'asetadi, wata 'u 'asetaku a nuakalikaliemu.” Iesu i vo, Egavo i vetumagana 'waikuye nuanuaku 'u na veve 'waidie, 'wa da vo bani'odi yaku sifi 'u da veve'anidi. ");
INSERT INTO yml_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A vona mogitana 'waimuye, basenadi 'omu tubuvauvaumuye taunimu 'u 'ivivigavumu, 'ai'edi ava'aibe yamu nuanua, 'ana fata bei 'u na nago, siwe tutuyanina 'u na ve'auvea, nimamu 'u na 'otoidi bega tamu tomogo i na talaumamu, ava'aibe bei kebu yamu nuanua bei i na nawemu.” ");
INSERT INTO yml_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","De'e bani'odi Iesu Fita i matakiaiga fai 'awaie tosakona i na 'iyogoyogoni mulieta i na luvewafai, siwe yana wafanina 'wainega Yaubada 'ana subia i na veluagai. Mulieta Iesu i voneni i vo, Nuanuaku 'u na vetutuyameku.” ");
INSERT INTO yml_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Iesu i veveifufu Fita 'waineye, Fita i sivilai tovetutuyamanina Iesu i nuakalikalieni bwaikina i 'iseni, kumanina basenadi 'Auvea yana 'ani 'waineye lilivaotogineye i miabui i velutoli Iesu 'waineye i vo, 'Auvea, aitoi kumanaga i na 'etogiluvemu?” ");
INSERT INTO yml_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tutuyanina Fita tovetutuyamanina i 'iseni i velutoli Iesu 'waineye i vo, 'Auvea, de'e kumanina 'ana nuanua bani'odi? 'Awaie bani'odi i na wafayedi?” ");
INSERT INTO yml_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu Fita yana velutoli i tutuli i vo, 'Ai'edi nuanuaku yaku vila-vaitugana i na 'iseni, ma yawaina i na miamia a na vilaku, we'e 'asa'aiana, kebu kumanina faifaina 'u na nuanua, siwe 'omu'e 'u na vetutuyameku.” ");
INSERT INTO yml_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Vonanina Iesu i voneyeniga faifaina, tovetumagana fuedi yadi nuanua i vo 'ako, kebu i na wafaga. Siwe Iesu kebu i da vo, I na mia-vagata kebu i na wafaga,” mogitana i vo, 'Ai'edi nuanuaku yaku vila-vaitugana i na 'iseni, ma yawaina i na miamia a na vilaku, we'e 'asa'aiana, kebu kumanina faifaina 'u na nuanua.” ");
INSERT INTO yml_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yau kumaniku Iesu yana tovetutuyama, naninidi matatabuna a 'isedi wata faifaidi a kiluma, bega fuema 'a 'asetai vona mogitana kebu vekali. ");
INSERT INTO yml_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Naninidi Iesu i 'idewadiga a kilumidi, siwe wata nani fuedi i 'eno'enovi kebu a da kilumidiga. 'Ai'edi matatabuna i da kiluma'a'avadiga buki fueotogidi, a nuani fwayefwayeye kebu tamu 'awasasa i da 'eno'eno bega bei bukinidi ta na yatodi. ");
INSERT INTO yml_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Iaku Tiofilo, basenadi yaku buki kumekumetana 'waineye a kilumiga tutuyanina Iesu yana folova i velamu nani matatabuna i 'idewadi wata i ve faifaidi, i nagoga nika Yaubada i vagavaia i naweni abame. Bola kebu i da lakaga, nagami 'ana tomata'aulelevo vevenua'ivinidi yana awave'eda'eda i veledi 'Anu'anunu Magemagetana 'wainega. ");
INSERT INTO yml_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Iesu i yawasa-vaitugana yana veviga i 'a'ava, 'aiata 40 nagedie i sousouyeni 'ana tomata'aulelevo 'waidie, 'eba 'isa fuedi i 'idewadi bega i na 'asetai mogitana ma yawaina wata Yaubada yana veimea tomotoga 'waidie i veifufuyeni. ");
INSERT INTO yml_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tutuyanina Iesu taiadi i miamiaga i velu'ase'asedi i vo, 'Wa na miamia Ielusalema, 'Anu'anunu Magemagetana 'wa na lulukamaseni. Tamaku basenadi i vona'awaufaufaga 'waimie i na velemi wata yau bani'odi bagase a vonemi. ");
INSERT INTO yml_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ioni tomotoga i bafitaisodi ufayega, 'aiata 'ifwaidi i na 'a'avana, 'Anu'anunu Magemagetana i na agemi, 'wa da vo bani'odi Yaubada i da bafitaisomi.” ");
INSERT INTO yml_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tamu 'aiata Iesu ma yana tomata'aulelevo i miava'auta i velutolieni i vo, 'Auvea nuanuama 'u da vonema, tutuya de'e me Isileli 'u na yavuda me Loma yadi veimea 'wainega, we'e ma'itufa yada 'eba veimea 'u na luvaitugani?” ");
INSERT INTO yml_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesu i vonedi i vo, Nani de'e nuanuami 'wa na 'asetai siwe kebu i da lubwainemi. Yaubada Tamaku 'aisena i veimeyedi ava'ai tutuyaga nuanuana bani'odi i na 'idewai. ");
INSERT INTO yml_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Siwe nani de'e 'wa na 'asetai. Tutuyanina 'Anu'anunu Magemagetana i na agemi 'wa na vetoketoke bega 'wa na vetolu'ivona faifaiku, tomotoga i miamiani Ielusalema 'waineye, 'awalawa Iudia 'waineye, Samelia matatabuna nageneye wata tomia fwayafwaya matatabuna 'waidie.” ");
INSERT INTO yml_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tutuyanina Iesu yana vona i 'a'ava, tomata'aulelevo matadie Yaubada i vagavaia, i vevemata'i'i'ieni i lakalaka nika waowa 'waineamo i luku abame. ");
INSERT INTO yml_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bola i vevemata'i'i'ieni nika tomotoga 'adi 'ailuga abamayega i souyedi lilivadie ma 'adi talauma mataududulidi i tovotovoi. ");
INSERT INTO yml_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nika i vo, Tomotoga Galili, ava'ai faifaina 'wa 'i'isalaka abame? Ta'e Iesu 'waimiega i vagavaia i nunaweni abame, bola i na vila-vaitugani wata beidimo i na mai bani'odi 'wa 'iseni i nunago.” ");
INSERT INTO yml_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tomotoganidi abamayega i nagoi, mulieta tomata'aulelevo 'aise'avadi 'Oya Olive 'wainega i viladi i nagoi Ielusalema, kebu 'ani'iega vivideye. ");
INSERT INTO yml_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Matatabudi i luku tamu vanuga 'waineye. Vanuganina 'etotubwatubwana tutudaba 'ifwaidi dibuneye, 'ifwaidi tabwaneye. I laka tutudaba tabwaneye bei i miamianiga 'waineye. Tomotoganidi side 'adi wagava, Fita, Ioni, Iemesa, Anidulu, Filifi, Tomasi, Batolomiu, Madiu, Iemesa tamu, taunina Alefasi natuna, Saimoni, toawa'idi'idi kebu nuanuana Loma kabemani i na veveimeyedi, Iudasa, Iemesa natuna. ");
INSERT INTO yml_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tutuya fuedi tomotoganidi i vava'auta i vevelu'ui Yaubada 'waineye wata 'ifwaidi vevine, Meli Iesu inana wata tainavo taiadi. ");
INSERT INTO yml_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","17","'Aiata 'ifwaidi i 'a'ava, Iesu 'ana tovetumaganavo i miava'auta 'adi 'aila'a bani'odi 120. Fita i tovoi i vonedi i vo, Ekwavo, a na vonemi. Basenadiotoga 'Anu'anunu Magemagetana i venuayato Kini Devida 'waineye bega i kilumi Yaubada yana Buki nageneye tamu tomogo Keliso i na 'etogiluveni. I lubwaineni vonanina 'ana mogitana i souyeni, to'etogiluvanina 'asa'aiana Iudasa Isakaliota, tamu 'ada 'aila'a. Basenadi Iesu i venua'ivineni 'ada folova-vaita, siwe kumanina Iesu 'ana to'ive'avina i kumesedi. ");
INSERT INTO yml_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","We'e Iudasa yana 'etogiluva tutulina 'wainega tamu fwayafwaya i kimwanei. To'etogiluvanina tabwanega i be'u kamona i tutulabu'eni, kamokamona i yavula i wafa. ");
INSERT INTO yml_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tomotoga fuedi Ielusalema 'waineye valana i nogai, begaidi tanoganina Diu bonadiega i goleni Akelidama, 'ana saivila, Tanoga Dayadayagina.” ");
INSERT INTO yml_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wata Fita i vonedi i vo, Basenadiotoga Kini Devida i kilumi Yaubada yana Buki Same 'waineye to'etogiluvanina faifaina i vo, Yana vanuga i da venage'ava, bei kebu tamu aitoi i na miamiana.’ Wata i kilumi i vo, Tamu tomogo tutulina i da folofolova.’ ");
INSERT INTO yml_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Fai Yaubada yana Buki bani'odi i voneyediga, i lubwaineda tamu tomogo ta na venua'ivineni Iudasa tutulina, bega ma fuedeye Iesu yana yawasa-vaitugana ta na lulu'ivoneyeni. Tomogonina ta na venua'ivineniga tamu yada 'aila'a, basenadi taiadi ta yabayaba, mataneye Iesu 'ana bafitaiso Ioni 'wainega wata yana folova matatabuna i 'isedi, i nagoga nika Iesu i laka abame.” ");
INSERT INTO yml_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tutuyanina Fita i vona'a'ava, tovetumaganavo tomotoga 'adi 'ailuga i 'inanadi. 'Adi wagava Iosefa tamu 'ana wagava Balisaba we'e 'ifwaidi yadi 'eba 'ainana Iusito, wata Mataiasi. ");
INSERT INTO yml_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Fuedi i velu'ui i vo, Ie 'Auvea, basenadi Iudasa i vetomata'aulele siwe i baila i wafa i nago ava'aibe bei i lubwaineniga 'waineye. Tomotoga matatabuma yama nuanua 'u 'asetadi, bega nuanuama tomotoga de'e 'adi 'ailuga 'waidiega 'u na vema aitoi 'u venua'ivineni bega i na vetomata'aulele Iudasa tutulina.” ");
INSERT INTO yml_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yadi velu'ui i 'a'avana, tomotoganidi 'adi wagava i kilumidi kileu 'adi 'ailuga 'waidie, i dodogidi vedie, mulieta tamu tomata'aulele vedi i likweni, kileunina Mataiasi 'ana wagava i kilumiga i 'anita'ia, bega fuedi i 'asetai taunina Yaubada i venua'ivineni bega tomata'aulele tamu 'adi 'aila'a 'ana ve-12. ");
INSERT INTO yml_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Iesu yana tovoi-vaitugana mulieta 'aiata 50 i 'a'ava, Diu yadi Sakali Fenitikosi 'ana tutuya i le'wa. 'Aiatanina 'waineye Iesu 'ana tovetumaganavo fuedi i va'auta 'eba mia 'aitamogana 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","I miamiani nika butu'ai i nogai abamayega, 'ana nogaya kaukau bwaikaotogina bani'odi, i mai vanuga matatabuna i susuli. ");
INSERT INTO yml_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Fuedi tamu nani i 'iseni bani'odi 'ai meana i souyedi i obuobu tomotoga 'aitamogana 'aitamogana 'waidie i toa. ");
INSERT INTO yml_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nika 'Anu'anunu Magemagetana tovetumaganavo matatabudi i agedi bega 'aitamogana 'aitamogana yana 'alavelevelena 'wainega i vonavona, bonanidi basenadi kebu i da 'asetadiga 'waidiega. ");
INSERT INTO yml_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ielusalema 'waineye me Diu fuedi i miamiani, Yaubada 'ana tove'ililibu i maia 'awalawa tulina tulina 'waidiega. ");
INSERT INTO yml_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tutuyanina kaukau butu'aina i nogai me Diunidi i ve'ilililide i nagoi bei tovetumaganavo i miamianiga 'waineye. 'Aitamogana 'aitamogana bonana i nogai nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nuadi i 'ewai bega i vo, Tomotoganidi i vonavonaga, matatabudi 'awalawa Galili 'wainega i maia. ");
INSERT INTO yml_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bani'odi i munega taunidi bonadiega i veveifufu siwe 'aitamogana 'aitamogana bonada ta noganogaidi? ");
INSERT INTO yml_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","'Ifwaida me Falidia, me Midia, me Ilamu wata 'ifwaida Mesafotemiayega ta maia. 'Ifwaida me Iudia, 'ifwaida me Kafadosia, 'ifwaida me Fonito wata 'ifwaida me Eisia. ");
INSERT INTO yml_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","'Ifwaida ta maia Filigia wata Famifilia 'waidiega, 'ifwaida Itifita 'wainega wata 'awalawa Libia Sailini lilivanega wata 'ifwaida Loma 'wainega ta maia. ");
INSERT INTO yml_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","'Ifwaida me Diu mogitana we'e 'ifwaida tulida siwe ta ve-Diu. Wata 'ifwaida Kilitiega 'ifwaida Aleibiayega. Matatabuda ta maia 'awalawa tulina tulina 'waidiega siwe nani bwaikidi Yaubada i 'idewadi 'aitamogana 'aitamogana bonadega i vonavona ta noganogaidi.” ");
INSERT INTO yml_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nuadi i voganidi bega 'aitamogana 'aitamogana i velutolitoli i vo, Bani'odi i munega? 'Ana 'aseta ava'ai?” ");
INSERT INTO yml_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","We'e tomotoga 'ifwaidi tovetumaganavo i sidibidibiedi igodina ufa toketokena i da yemu nuadi i da lugaugaudi bega i da vona-'avo'avovo. ");
INSERT INTO yml_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Fita yadi vona i nogai, enavo 11 taiadi i tovoi bega Fita bonana bwaikinega 'aila'a i vonedi i vo, Ekwavo, fuemi 'wa miamiani Ielusalema 'waineye wata 'awalawa Iudia nageneye, 'wa ve'wada naninina i souyeniga a na kiavemagetai. ");
INSERT INTO yml_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yami nuanua 'wa vo 'ima ufa toketokena 'a yemu bega nuama i lugaugaudi. Siwe kebu, de'e bola 'awa'awai, yada sauluva kebu 'awa'awaie ta da yemuyemu. ");
INSERT INTO yml_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","We'e mogitana basenadiotoga Yaubada yana tolu'ivona Ioeli i vona-samula, vonanina i kilumi ava'ai 'wa 'ise'iseni faifaina. ");
INSERT INTO yml_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yaubada i vo, Sai'afoga fwayafwaya 'ana 'eba ve'a'ava 'waineye, 'Anu'anunuku tomia fwayafwaya fuedi a na veledi bega i na agedi. Natumiavo iavetadi wata vevinedi i na vona-samula ava'ai 'awaie i na souyediga faifaidi, we'e tubuvauvau 'adi ve 'waidiega, wata 'au'auveavo 'enoneganega 'waidiega nani fuedi i na 'isedi. ");
INSERT INTO yml_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wata bani'odi 'aiatanidi 'waidie, yaku tofolovavo iavetadi wata vevinedi 'Anu'anunuku a na veledi i na agedi mogitana bega i na vona-samula. ");
INSERT INTO yml_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Tugusa a na vedi abame, inala i na dudubali wata weta'i i na yamota bani'odi dayaga. Fwayefwayeye 'eba nuavogana wata 'eba nua'ewa a na 'idewadi bani'odi dayaga, 'ai-'ala'alata wata lufwa bwaikina i na 'isedi, mulieta 'Auvea i na souyeni. 'Aiatanina 'waineye fuedi i na kololo 'Auvea yana toketokena wata yana 'ai'aiwabu magemagetana faifaidi. ");
INSERT INTO yml_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tutuyanina 'waineye egavo nuanuadi 'aivaita, 'Auvea 'waineye i na vegole nika i na 'ita'ita'iedi.’” ");
INSERT INTO yml_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Wata Fita i vo, Me Isileli a na vonemi, side bani'odi. Iesu Nasalediega faifaina a vonavona. 'Akonadi 'wa 'asetai taunina 'eba nuavogana wata 'eba nua'ewa fuedi i 'idewadi matamie, naninidi toketokedi 'waidiega Yaubada i vemi veimea Iesu i veleni. ");
INSERT INTO yml_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tomogonina to'etogiluva i 'aniveleneni 'waimie we'e 'omi 'wa tauyeni tosakona 'waidie i tutufwaseni 'ai lagalagana 'waineye. Nagami Yaubada yana nuanua i 'idewai wata i 'asetai naninidi i na souyedi bega i tauyeni Iesu i mai i wafa. ");
INSERT INTO yml_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wafa 'ana veviga 'wainega Yaubada i 'ita'ita'ieni i sivetovoi-vaitugani, fai kebu 'ana fata wafa i na kiave'avina-vagaseni. ");
INSERT INTO yml_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Basenadiotoga Kini Devida i vona Iesu faifaina i vo, A 'asetai 'Auvea tutuya fuedi 'aku 'weabu, i miamia 'aku 'atagiega bega kebu a na venuafouviga. ");
INSERT INTO yml_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Begaidi ma yaku sosoana a subisubia. Tutuyanina a na wafa a 'asetai a na ve'atumai, avinodi 'anu'aunuku i na nago towafa yadi 'eba mia 'waineye siwe kebu 'u na baileku bega a na wafaotoga. Yau yamu Tofolova Magemagetaku kebu 'u na tauyeku bega tomogoku i na bokana. ");
INSERT INTO yml_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mia-vagata 'ana 'eda 'akonadi 'u veku wata a na sosoana mogitana fai 'omu yau taiadi.’ ");
INSERT INTO yml_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ekwavo, de'e a na kiavemageta tubuda Kini Devida faifaina. Basenadiotoga i wafa i ve'ufai, 'ana taumata tutuya fuedi ta 'ise'iseni bega ta 'asetai kebu i da vona taunina faifaina. ");
INSERT INTO yml_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tutuyanina Kini Devida ma yawaineye, taunina Yaubada yana tolu'ivona, i 'asetai Yaubada yana vona'awaufaufa 'waineye, bola yana 'aila'a 'wainega tamu tubuna Yaubada i na silakai i na ve-kini taunina bani'odi. ");
INSERT INTO yml_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Fai Devida i 'asetai bola ava'ai Yaubada i na 'idewai bega Keliso, taunina Yaubada 'ana Venua'ivina, yana tovoi-vaitugana faifaina i vona-samula i vo, Yaubada kebu i na baileni towafa yadi 'eba mia 'waineye wata tomogona kebu i na bokana.’ ");
INSERT INTO yml_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tomogonina taunina Iesu, Yaubada wafayega i sivetovoia, matatabuma matamega 'a 'iseni. ");
INSERT INTO yml_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yaubada i silakai veimea i veleni i miabui 'ana 'atagiega wata 'Anu'anunu Magemagetana i veleni, basenadi bani'odi Tamana i vona'awaufaufa 'waineye. We'e tutuya de'e Iesu 'Anu'anununina i velema i agema, 'akonadi 'wa 'ise'iseni wata 'wa noganogai. ");
INSERT INTO yml_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Iesu ma tomogona i laka abame we'e Devida kebu siwe i vo, 'Auvea i vona 'aku Toveimea 'waineye i vo, Veimea a velemuga bega 'u na miabui 'aku 'atagiega, ");
INSERT INTO yml_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","i na nagoga 'amu gaviavo a na leodi bega 'u na veveimeyedi.”’” ");
INSERT INTO yml_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Wata Fita i vona 'aila'a 'waidie i vo, 'Ida me Isileli fueda ta na 'aseta-'atumaia Toveimeanina i voneyeniga taunina Iesu siwe yami veimea 'wainega i tutufwaseni 'ai lagalagana 'waineye, Yaubada i silakai bega 'ana Venua'ivina wata 'ada Toveimea.” ");
INSERT INTO yml_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tutuyanina tomotoga Fita bonana i nogai nuafoudi i veviga bwaikina, tomata'aulelevo i velutoliedi i vo, Emavo, bani'odi 'a na munega?” ");
INSERT INTO yml_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Fita i vo, 'Aitamogana 'aitamogana 'wa na nuavilami yami sakona 'wainega wata 'wa na bafitaiso Iesu Keliso 'ana wagavayega bega Yaubada yami sakona i na nuatavunidi wata 'Anu'anunu Magemagetana i na velemi nika i na agemi. ");
INSERT INTO yml_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Basenadi Yaubada i vona'awaufaufa, 'Anu'anunu Magemagetana i na veleda wata vona'awaufaufanina i na damana natudavo 'waidie wata mali tomotoga kumanidiavo kebu Diu, matatabudi 'Auvea yada Yaubada i na goledi i na nagoi 'waineye.” ");
INSERT INTO yml_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Wata 'ifwaidi vona 'waidiega Fita i velu'ase'asedi i vo, Bola Yaubada tosakona fuedi i na vematavulogidi begaidi yadi sauluva sakoidi 'wa na bailedi nika taunimi 'wa na 'ita'ita'iemi.” ");
INSERT INTO yml_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","'Aiatanina 'waineye tomotoga bani'odi 3,000 Fita yana vona i vetumaganeni, i bafitaiso i luku tovetumaganavo 'adi 'aila'a 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tovetumaganavo taunidi i tauyedi tomata'aulelevo yadi ve 'waidie, i veveiana, Yaubada 'waineye i vevelu'ui wata Iesu 'ana 'eba nuave'avina faifaina ma fuedie i 'ani'ani. ");
INSERT INTO yml_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Matatabudi ma yadi kololo Yaubada i veve'ililibuyeni, we'e tomata'aulelevo 'eba nuavogana wata 'eba nua'ewa fuedi i 'idewadewadi tomotoga matadie. ");
INSERT INTO yml_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tovetumagananidi matatabudi i veveiana wata nani 'ifwaidi 'waidiega i veve'ivaivaita. ");
INSERT INTO yml_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yadi kukua i vekimwaneyedi, tutulidi i 'ewadi tovewekowekoma 'aitamogana 'aitamogana i veleveledi. ");
INSERT INTO yml_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","'Aiata 'aitamogana 'aitamogana matatabudi i 'odu'odu Vanuga 'Eba Velu'ui 'waineye wata yadi vanuge, ma yadi sosoana wata ma yadi nuaobu i 'a'aniluvetubama bega Iesu i na nunuave'avini. ");
INSERT INTO yml_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yaubada i subisubiai we'e tomotoga 'ifwaidi yadi sauluva i 'iseni nuadi i 'ewai i ve'ililibuyedi. 'Aiata 'aitamogana 'aitamogana tovetumaganavo 'adi 'aila'a i vevebwaika, fai egavo Iesu Valana i vetumaganeni 'Auvea i 'ita'ita'iedi i lukuluku 'adi 'aila'a 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tamu 'aiata Fita wata Ioni i nagoi Vanuga 'Eba Velu'ui 'waineye. 'Akonadi 'auyewa i 'awavilai, velu'ui 'ana tutuya i le'wa. ");
INSERT INTO yml_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Vanuga 'Eba Velu'ui tamu 'awana 'ana wagava 'Awa 'Ana 'Isa 'Atumaiotogina, bei tomogo 'agena sinunumina inana kamodiega i tubuga i miamia. 'Aiata 'aitamogana 'aitamogana enavo i nunaweni bei i vevemiabuia egavo i nunagoi Vanuga 'Eba Velu'ui 'waineye, 'waidie mani i vevelu'ui. ");
INSERT INTO yml_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tutuyanina Fita wata Ioni i 'isedi i mimaia, 'waidie i velu'ui 'ai'edi tamu ava'ai i da veleni. ");
INSERT INTO yml_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Siwe 'adi 'ailuga i 'isadewai Fita i voneni i vo, 'U 'isamaiema.” ");
INSERT INTO yml_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","I 'isanawedi yana nuanua i vo 'ako ava'ai i na veleku? ");
INSERT INTO yml_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nika wata Fita i voneni i vo, Kebu tamu mani 'waikuye bega a na velemu, siwe nani tamu 'atumaina a na velemu. Iesu Keliso tomogo Nasaledi 'ana wagavayega a na vonemu, 'U tovoi 'u yaba.” ");
INSERT INTO yml_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Fita 'ana 'atagie i 'abi i sivetovoia nika 'agena wata 'ana buseu-matana i vetoketoke i luafwalagi i yaba. Mulieta Fita wata Ioni taiadi i luku Vanuga 'Eba Velu'ui 'waineye, tomogonina i yogosousou Yaubada i subisubiai. ");
INSERT INTO yml_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","'Aila'a bwaikina tomogonina i 'iseni i yogosousou wata Yaubada i subisubiai, i 'isa'inanai taunina totalavelu'ui yana 'eba mia Vanuga 'Eba Velu'ui 'awaneye, matatabudi nuadi i voganidi wata nuadi i 'ewai yana ve'atumai faifaina. ");
INSERT INTO yml_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Vanuga 'Eba Velu'ui masi'edana 'ana wagava Masi'eda Solomoni bei tomogonina i ve'atumaiga, Fita wata Ioni taiadi i venima'abi'abi i tovotovoi. 'Aila'a i 'iseni i ve'atumai ma yadi nuavogana i ve'ilililide i mai 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Fita tomotoga i 'isedi i vonedi i vo, Ekwavo 'ida me Isileli 'aila'a 'aitamogana, awale nuami i voganidi wata 'wa 'i'isadewama? 'Omi 'wa nuaniga 'wa vo 'ako taunima yama toketokenayega 'alo yama sauluva magemagetadi 'waidiega tomogo de'e 'a da 'ive'atumaia, siwe kebu. I ve'atumaiga side bani'odi. ");
INSERT INTO yml_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebelamo, Aisake, Iakobo wata 'ifwaidi tubudavo yadi Yaubada, yana tofolova Iesu i silakai, toketokena wata veimea i veleni. Tomogonina 'wa 'aniveleneni yada to'edakumetavo 'waidie wafa faifaina, igodi Failato i da 'etoyavuya siwe 'wa talabodeni. ");
INSERT INTO yml_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Taunina magemagetana, yana sauluva tonovina Yaubada mataneye siwe 'omi 'wa vedumwe'ai'aieni, Failato 'wa voneni tamu to'ainike 'ana wagava Balaba i na 'etoyavuya. ");
INSERT INTO yml_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Begaidi yami veimea 'wainega yawaida lamuna i luvewafai siwe Yaubada i sivetovoia wafayega, 'ima matamega 'a 'iseni. ");
INSERT INTO yml_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iesu yana toketokena 'wainega tomogo de'e 'agena i 'ani'otoidi. Ava'ai 'wa 'iseni 'alo 'wa 'asetai yama vetumagana wata Iesu yana toketokena 'waidiega. Yama vetumagananina Iesu 'waineye tomogonina matamie i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ekwavo, side bani'odi. A nuani 'omi wata 'ida me Diu yada to'edakumetavo taiadi yami bavu 'wainega Iesu 'wa luvewafai. ");
INSERT INTO yml_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Basenadi Yaubada i venuayato yana tolu'ivonavo 'waidie bega i vona-samula 'ana Venua'ivina Keliso veviga bwaikina i na veluagai mulieta i na wafa. 'Akonadi 'ana mogitana i souyeni yami veimea 'wainega. ");
INSERT INTO yml_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Begaidi yami sakona 'waidiega 'wa na nuavilami Yaubada 'waineye bega yami sakonanidi i na 'u'umidi. ");
INSERT INTO yml_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Wata 'Auvea 'aivaita i na velemi bega 'anu'anunumi i na ve'atumai wata i na vetoketoke, nika Yaubada 'ana Venua'ivina, taunina Iesu i na vetunei faifaimi. ");
INSERT INTO yml_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tutuya de'e Iesu i miamia abame i na nagoga Yaubada yana tutuya 'ana mogitana i na veluagai. Tutuyanina 'waineye nani matatabuna fwayefwayeye wata abame i na 'ive'ivaudi, bani'odi basenadiotoga yana tolu'ivona magemagetadi i vona-samula. ");
INSERT INTO yml_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","23","Wata bani'odi basenadiotoga Mosese i kilumi Yaubada yana Buki nageneye Iesu faifaina i vo, 'Auvea yada Yaubada bola tamu yana Tolu'ivona i na vetunei 'waimie yau bani'odi. Taunina yada tomotoga 'waidega i na silakai wata nani matatabuna i na lu'ivonaga 'waimie bonana 'wa na nogai. 'Ai'edi aitoi kebu i na vematayakeyakeniga, Yaubada yana 'Aila'a 'wainega i na ve'idi'idieni i na wafaotoga.’” ");
INSERT INTO yml_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wata Fita i vonedi i vo, Basenadiotoga tolu'ivona matatabudi Yaubada yana nuanua i lu'ivoneyediga, i vona-samula naninidi i souyediga tutuya de'e faifaina. Tolu'ivonanidi bani'odi Samuela wata 'ifwaidi mulineye i mai. ");
INSERT INTO yml_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yaubada yana vona'awaufaufanidi tolu'ivona i lu'ivoneyediga 'omi faifaimi. Basenadiotoga Yaubada yana veakutagona i 'idewai tubudavo 'waidie wata 'omi 'waimie. Wata bani'odi i voneyedi tubuda Ebelamo 'waineye i vo, Tubumwavo 'waidiega a na vesauluva 'atumaina tomia fwayafwaya matatabuna 'waidie.’ ");
INSERT INTO yml_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nika mogitana Yaubada yana Tofolova i silakai, nagami 'waimie i vetunei bega i na vesauluva 'atumaina 'waimie, i na sivilami yami sauluva sakoidi 'waidiega.” ");
INSERT INTO yml_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tutuyanina Fita wata Ioni i veveifufu tomotoga 'waidie, 'ifwaidi totafalolo i maia 'waidie. Taunidi tovelomu, Diu 'ifwaidi 'adi wagava Sadusi wata Vanuga 'Eba Velu'ui 'ana tolumadu'aivo 'adi to'edakumeta. ");
INSERT INTO yml_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ma yadi nuasako i maia fai yadi nuanua igodina towafa kebu i na tovoi-vaitugana, siwe Fita wata Ioni tomotoga 'waidie i veve i vo, Yaubada Iesu i sivetovoia wafayega begaidi towafa fuedi i na yawasa-vaitugana.” ");
INSERT INTO yml_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Faifaina i 'ive'avinidi siwe 'akonadi i lavia i yatodi vanuga yogona nageneye i 'eno. ");
INSERT INTO yml_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","We'e fuedi Iesu valana i nogai i vetumagana i luku tovetumaganavo 'waidie i ve'ila'edi bega iaveta'ava 'adi 'aila'a 5,000, siwe vevine wata kwakwama taiadi. ");
INSERT INTO yml_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","I 'atai me Diu yadi toveimeavo, yadi to'edakumetavo 'au'auveadi wata ve'etoboda 'adi tovevo i va'auta Ielusalema. ");
INSERT INTO yml_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasa kumanina tovelomu bwaikina, Kaiafa, Ioni, Alekisana wata tovelomunina yana 'aila'a 'ifwaidi taiadi i mai. ");
INSERT INTO yml_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","I va'auta i 'a'avana, Fita wata Ioni i miedi matadie i velutolitoliedi i vo, Tomogo bani'odi 'wa munegi i ve'atumai? Ava'aiega yami toketokena 'wa veluagai 'alo aitoi 'ana wagavayega?” ");
INSERT INTO yml_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Siwe 'Anu'anunu Magemagetana Fita i agei mogitana bega yadi velutoli i tutuli i vo, 'Omi 'ama to'edakumetavo wata yama 'auveavo, 'asiau 'wa velutoliemaga, voke tomogo 'agena sinunumina 'a 'ivaiseni i ve'atumai faifaina. ");
INSERT INTO yml_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Siwe 'omi wata me Isileli fuemi 'wa na 'asetai, tomogonina 'wa 'ise'iseni, Iesu Keliso 'atamana Nasaledi 'wainega yana toketokena 'wainega i ve'atumaiotoga. Tomogonina Yaubada 'ana Venua'ivina, basenadi 'omi 'wa tutufwaseni 'ai lagalagana 'waineye siwe Yaubada i sivetovoia wafayega. ");
INSERT INTO yml_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Basenadiotoga i kilumi Yaubada yana Buki nageneye Iesu faifaina i vo, Folovanina 'omi to'aiyogona 'wa baileni, Yaubada i silakai i ve'unututuyeni.’ ");
INSERT INTO yml_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Side bani'odi. Fai Yaubada Iesu i silakai, 'aiseotogina 'ana fata i na 'ita'ita'ieda. Yaubada Iesu i veleda bega i na 'ita'ita'ieda, we'e tomia fwayafwaya matatabuna 'waidega kebu tamu aitoi bani'odiga.” ");
INSERT INTO yml_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Diu yadi kaniselavo Fita wata Ioni yadi venuafoufa'ala i 'iseni wata i 'asetadi taunidi tomotoga-'avo'avovo kebu i da luku sikulu 'waineye, begaidi nuadi i voganidi yadi vona 'atumaina faifaina, bega i nuani Iesu 'adi 'weabu wata 'adi tove. ");
INSERT INTO yml_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","To'edakumetavonidi kebu tamu ava'ai 'adi fata i na voneyeniga fai tomogonina i 'iseni 'akonadi i ve'atumai taiadi i tovotovoi. ");
INSERT INTO yml_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Bega i vonedi 'adi 'aitonu i souyedi tutudaba 'wainega kaniselavo 'aise'avadi i veifufu i vo, Bani'odi ta na munegidi? Kebu 'ada fata yadi folova toketokena ta na awave'eve'eweni fai tomotoga fuedi Ielusalema nageneye 'akonadi i 'asetai Fita wata Ioni tomogonina i 'ive'atumaia. ");
INSERT INTO yml_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Siwe 'adi 'ailuga ta na talabodedimo kebu wata Iesu Valana i na lu'ivona-vuvueni mali tomotoga 'waidie bega nani de'e kebu i na vebwaika.” ");
INSERT INTO yml_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","I goledi i luku-vaitugana 'waidie i velu'ase'asedi i vo, 'A talabodemi, kebu wata 'wa na veveifufu 'alo 'wa na veve Iesu faifaina.” ");
INSERT INTO yml_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","20","Siwe Fita wata Ioni yadi vona i tutuli i vo, 'Omi taunimi 'wa na venua'ivina ava'ai nuanuaga Yaubada mataneye 'atumaina. 'Omi yami nuanua 'a na vematayakeyakeni 'alo Yaubada? 'A nuaniga kebu 'ama fata 'a na 'ailove, 'a na veveifufu fai Iesu yana folova matamega 'a 'iseni wata yana vona tanigamega 'a nogai.” ");
INSERT INTO yml_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Kaniselavo kebu tamu ava'ai Fita wata Ioni 'waidiega i da veluagai bega i na vematavulogidi. Fai tomotoga fuedi Yaubada i subisubiai 'eba nua'ewa wata 'eba nuavogana faifaina, begaidi kebu 'adi fata i na nikedi. Tomogonina i ve'atumaiga kebu tubuvauvaunaga 'ana malamala 40 i 'iaweni. Wata kaniselavo i kwayega i talabodebodedi, mulieta i vonedi i souyedi. ");
INSERT INTO yml_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Fita wata Ioni i viladi i nagoi ediavo tovetumagana 'waidie, tovelomu bwaikidi wata to'edakumetavo 'au'auveadi yadi veifufu i lu'ivoneyeni 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","I lu'ivona i 'a'avana, ma fuedie yadi nuanua 'aitamoganega Yaubada 'waineye i velu'ui i vo, 'Auvea, 'omu bwaikimu, abama, fwayafwaya wata ufa 'adi to'idewadewa wata nani fuedi nagedie i 'eno'enovi. ");
INSERT INTO yml_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Basenadiotoga 'Anu'anunu Magemagetana i venuayato yamu tofolova wata tubuma Devida 'waineye bega i vona-samula vonanina i kilumi i vo, Awale tomotoga 'aila'a tulina tulina i nuasako bwaikina Yaubada 'waineye? Tomotoganidi yadi nuanua givagivana i 'idewa-wayogeni, igodi i da vesauluva sakoina 'Auvea 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kini fuedi yadi 'eba vetalaga i 'idewadi wata to'edakumetavo i va'auta nuanuadi 'Auvea wata 'ana Venua'ivina taiadi i na vetalaga.’ ");
INSERT INTO yml_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Yadi nuanuananina basenadiotoga Devida i voneyeni siwe 'akonadi 'ana mogitana i sousouyeni 'atamana de'e 'waineye, fai Kini Elodi wata Fonitio Failato i va'auta me Isileli wata mali tomotoga taiadi. Bega yadi nuanua 'aitamogana 'wainega Iesu yamu Tofolova Magemagetana 'u venua'ivineniga, i vedumwe'ai'aieni. ");
INSERT INTO yml_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Basenadiotoga ma yamu toketokena yamu nuanua 'u 'idewai Iesu faifaina, we'e ava'ai tomotoganidi i 'idewadewadi fai nagami yamu nuanua bani'odi. ");
INSERT INTO yml_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ie 'Auvea, 'akonadi 'u 'asetai tomotoganidi nuanuadi veviga bwaikina i na velevelema, begaidi 'ima yamu tofolovavo 'u na 'ivaisema bega yamu vona matatabuna venuafoufa'alayega 'a na lulu'ivoneyeni. ");
INSERT INTO yml_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Wata nuanuama yamu Tofolova Magemagetana Iesu, yana toketokena 'wainega 'eba nuavogana wata 'eba nua'ewa 'u na 'i'idewadi wata toviga 'u na 'i'ive'atumaidi.” ");
INSERT INTO yml_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tutuyanina i velu'ui'a'ava, Yaubada yana toketokena 'wainega vanuga i yue. 'Anu'anunu Magemagetana tovetumaganavo i agedi mogitana, ma yadi venuafoufa'ala Yaubada yana Vona i veveifufuyedi. ");
INSERT INTO yml_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tovetumaganavo matatabudi yadi nuanua 'aitamogana. Naninidi 'waidie, 'waidiega i ve'ivaivaita ma ediavo kebu tamu aitoi i da veumokai. ");
INSERT INTO yml_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Toketokena bwaikina 'wainega tomata'aulelevo i lulu'ivona mogitana, Toveimea Iesu yana tovoi-vaitugana faifaina wata Yaubada ma yana nuakalikali i vevesauluva 'atumaina 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Tovetumagananidi kebu tamu aitoi i da 'usa tamu nani 'wainega fai egavo ma yadi kukua bwaikidi i vevekimwaneyedi tutulidi i 'ewa'ewadi tomata'aulelevo i veleveledi, mulieta i veveusedi tovewekowekoma 'aitamogana 'aitamogana 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Bani'odi Iosefa, tomata'aulelevo i goleni Banabasa, 'ana saivila To'aivaita, yana fwayafwaya i vekimwaneyeni tutulina i mieni i 'aniveleneni tomata'aulelevo 'waidie. Tomogonina i tubuga Imula Saifilosi 'waineye wata Livai 'ana wauma 'wainega. ");
INSERT INTO yml_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tovetumaganavo ma ediavo kukuayega i ve'ivaivaita we'e iadi tamu 'ana wagava Ananaiasi ma yana vavine Safaila, tamu yadi fwayafwaya i vekimwaneyeni. ");
INSERT INTO yml_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tutulina 'ewai, 'ifwaidi i ve'o'oledi wata 'ifwaidi Ananaiasi i nawedi tomata'aulelevo i veledina i vonedi i vo, Side yama fwayafwaya tutulina matatabuna a mieni.” Yana vavine yana vekali i 'asetai. ");
INSERT INTO yml_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tutuyanina maninina i veledi Fita i vo, Ananaiasi, awale taunimu 'u tauyemu Seitani yana nuanua 'waineye, bega 'u vekali 'Anu'anunu Magemagetana 'waineye? Yamu vekalinina fai 'ifwaidi yami fwayafwaya tutulina 'u ve'o'oleni 'u vo, Matatabuna a mieni.’ ");
INSERT INTO yml_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Basenadi 'omu yamu fwayafwaya wata tutuyanina 'u vekimwaneyeniga tutulina 'omu yamu mani. Awale yamu nuanuananina bani'odi i souyeni? Kebu 'aisema 'u da vekaliemaga wata 'u vekali Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tutuyanina Fita yana vona i nogai i 'awauliulia i wafa. Fuedi valana i nogai Ananaiasi bani'odi i munega i wafa, i kololo bwaikina. ");
INSERT INTO yml_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mulieta nigolalaga i maia tomogona i fania i 'a'ava, i evai i naweni i ve'ufai. ");
INSERT INTO yml_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","'Awasasa 'aitonu i 'a'ava wata yana vavine i mai we'e yadi lamoga yana wafa kebu i da 'asetaiga. ");
INSERT INTO yml_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Fita i vonedi i vo, Nuanuaku a na 'asetai, vona mogitana de'e yami fwayafwaya tutulina matatabuna 'alo kebu?” Safaila i vo, E'e matatabuna.” ");
INSERT INTO yml_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Wata Fita i vo, Awale ma yami lamoga yami nuanua 'aitamogana 'wainega 'Auvea 'Anu'anununa 'wa silubuya? We'e nigolalaga yami lamoga i ve'ufaiga siwe 'akonadi i le'wai 'omi wata 'ako i na evami i na nawemi i na ve'ufami.” ");
INSERT INTO yml_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nika i 'awauliuludi i wafa Fita 'ageneye. Nigolalaganidi i luku i 'isedi 'akonadi i wafa i evadi i nawedi i ve'ufadi yadi lamoga lilivaneye. ");
INSERT INTO yml_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iesu yana 'Aila'a matatabudi valadi i nogai i kololo bwaikina wata mali tomotoga fuedi taiadi i kololo. ");
INSERT INTO yml_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tomata'aulelevo 'eba nuavogana wata 'eba nua'ewa fuedi i 'i'idewadi tomotoga matadie. Tovetumaganavo yadi sauluva i vava'auta Masi'eda Solomoni 'waineye Vanuga 'Eba Velu'ui nageneye. ");
INSERT INTO yml_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tomotoga fuedi tovetumaganavonidi i ve'ililibuyedi siwe kebu i da nagoi 'waidie i kololo. ");
INSERT INTO yml_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","We'e 'ifwaidi i vevetumagana Toveimea Iesu 'waineye i lukuluku 'adi 'aila'a 'waineye bega i veve'ila'edi, vevine wata iaveta. ");
INSERT INTO yml_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Fai tomata'aulelevo 'eba nuavogana wata 'eba nua'ewa i 'i'idewadi, toviga ma 'evo'evodi i mimaiedi 'edeye i yatoyatodi bega bola Fita 'ifwaidi i na 'abitonovidi, we'e 'ai'edi kebu, 'ifwaidi i na ve'i'wa'uyedimo i na ve'atumai. ");
INSERT INTO yml_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wata tomotoga 'aila'a bwaikaotogina 'atamana fuedi Ielusalema lilivaneye yadi toviga i miedi wata 'ifwaidi yaiaina i agediga matatabudi i ve'atumai. ");
INSERT INTO yml_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Tovelomu bwaikina ma enavo totafalolo Sadusi, ma yadi nuasako tomata'aulelevo i ve'unumagigiedi, i 'ive'avinidi i yatodi vanuga yogona nageneye. ");
INSERT INTO yml_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Siwe lovananina 'waineye tamu 'Auvea yana anelose vanuga yogona 'ana saiboda i sibaledi i vonedi i souyedi. ");
INSERT INTO yml_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Wata i vonedi i vo, 'Wa na nagoi 'wa na luku Vanuga 'Eba Velu'ui 'waineye tomotoga 'waidie 'wa na veifufu-dewa mia 'ivauna Iesu 'wainega faifaina.” ");
INSERT INTO yml_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tomata'aulelevo bonana i nogai, mulieta i 'atai i luku Vanuga 'Eba Velu'ui nageneye bei i veve tomotoga 'waidie. Tutuyanina tovelomu bwaikina ma enavo i le'wa, me Diu yadi Kanisela to'edakumetavo 'au'auveadi matatabuna taiadi i goleva'augidi. Tolugaviavo i vonedi i na nagoi vanuga yogona nageneye tomata'aulelevo i na miedi vonayavuga faifaina. ");
INSERT INTO yml_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Siwe tutuyanina tolugaviavo i le'wai tomata'aulelevo i 'isa'avadi bega i viladi i nagoi Kanisela 'waidie i lu'ivona i vo, 'A le'wai vanuga yogona 'a 'iseni 'ana saiboda fa'alidi wata to'isave'avinavo i tovotovoi 'awa lilivadie, siwe saiboda 'a sibalediga kebu tamu aitoi 'a da veluagai nageneye.” ");
INSERT INTO yml_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tutuyanina Vanuga 'Eba Velu'ui 'ana tolumadu'aivo 'adi to'edakumeta wata tovelomu yadi to'edakumetavo yadi vona i nogai, nuadi i voganidi i vo, Bani'odi i munega i souyedi?” ");
INSERT INTO yml_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","I vonavona nika tamu tomogo i le'wa i vonedi i vo, 'Wa ve'wada a na vonemi, tomotoganidi 'wa yatodiga vanuga yogona nageneye, sino i veve tomotoga 'waidie Vanuga 'Eba Velu'ui nageneye.” ");
INSERT INTO yml_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Bega Vanuga 'Eba Velu'ui 'ana tolumadu'aivo yadi to'edakumeta taiadi i nagoi vona bikanega tomata'aulelevo i veviladi. Kebu bonadi i da siaya'aia fai tomotoga i kololoyedi, bola tomata'aulelevo i na 'ikasikasisiedi kileuyega i na nikedi. ");
INSERT INTO yml_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Vanuga 'Eba Velu'ui 'ana tolumadu'aivo tomata'aulele i miedi Kanisela matadie, tovelomu bwaikina i vonedi i vo, Basenadi 'a talabodemi kebu Iesu faifaina 'wa na veve. Siwe 'akonadi yami venina tomia Ielusalema matatabudi i 'aseta wata nuanuami 'wa na 'uvanima yana wafa faifaina.” ");
INSERT INTO yml_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Siwe Fita ma enavo yadi vona i tutuli i vo, 'Omi wata mali tomotoga yami vona kebu 'a na vematayakeyakedi, Yaubada 'aisena yana nuanua i lubwaineni. ");
INSERT INTO yml_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","'Omi Iesu 'wa luvewafai 'ai lagalagana 'waineye, siwe tubudavo yadi Yaubada wafayega i sivetovoia. ");
INSERT INTO yml_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wata i silakai i vemiabuia 'ana 'atagiega veimea i veleni taunina yada To'edakumeta wata 'ada To'ita'ita'i, bega 'ida me Isileli 'ada fata ta na nuavilada Yaubada yada sakona i na nuatavunidi. ");
INSERT INTO yml_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yana wafa wata yana tovoi-vaitugana 'a 'isedi wata 'Anu'anunu Magemagetana i 'asetai, 'Anu'anununina Yaubada i tauyeni 'ana tove'ililibu i agedi.” ");
INSERT INTO yml_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaniselavo yadi vonanina i nogai i nuasako bwaikina yadi nuanua 'aitamoganega i vo, Ta na nikedi i na wafa.” ");
INSERT INTO yml_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","35","Siwe tamu iadi 'ana wagava Kamelieli taunina totafalolo Falisi, ve'etoboda 'adi tove wata fuedi i ve'ililibuyeni, i tovoi tomata'aulelevo i vonedi i souyedi. Mulieta Kamelieli kaniselavo i vonedi i vo, Ekwavo, 'ai'edi ava'ai nuanuami 'wa na 'idewai de'e tomotoganidi 'waidie, nagami 'wa na venua'ivina-'atumai. ");
INSERT INTO yml_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Basenadi tamu tomogo 'ana wagava Tiudasi i vo, Yau tomogo bwaikiku, 'waikuye 'wa na 'isa wata 'wa na vetutuyameku,’ bega tomotoga bani'odi 400 i nagoi 'waineye. Siwe mali tomotoga i nikei i wafa, 'ana tovetutuyamavo i ve'iyavuyavulagi yana nuanuananina igodi i da 'idewaiga i 'a'ava. ");
INSERT INTO yml_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mulieta kabemani tomotoga 'adi wagava i kilukilumidi tutuyanina 'waineye, tamu tomogo Galili 'ana wagava Iudasa yana nuanua tamu i 'idewai wata tomotoga fuedi i nagoi 'waineye. Taunina wata i wafa, yana tomotoga wata yana nuanuananina i 'iawelovedi. ");
INSERT INTO yml_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","Wata 'asiau bani'odi. A vona mogitana. 'Ai'edi Iesu valana tomotoga yadi nuanua bola i na 'a'ava, we'e 'ai'edi Yaubada yana nuanua, kebu 'ami fata 'wa na leodi. Voke bola 'wa na nunagoi Yaubada taiadi 'wa na vevetalaga. Begaidi de'e tomata'aulelenidi kebu 'wa na nikedi. 'Wa bailedi i na nagoi.” ");
INSERT INTO yml_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kaniselavo matatabudi Kamelieli yana vona i nogai i ve'ililibuyeni. Mulieta tolugaviavo i vonedi tomata'aulelevo i miedi i toke i fitalidi mulieta kaniselavo i talabodedi kebu wata Iesu faifaina i na veveifufu. I 'a'avana i vonedi i na nago. ");
INSERT INTO yml_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tomata'aulelevo ma yadi sosoana i souyedi i vo, Yaubada i tauyeda veviga ta veluagai Iesu faifaina.” ");
INSERT INTO yml_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","'Aiata 'aitamogana 'aitamogana tomata'aulelenidi i lukuluku Vanuga 'Eba Velu'ui 'waineye wata tomotoga yadi vanuge, 'waidie i veve wata i lalau'age Iesu Valana 'Atumaina faifaina i vo, Iesu taunina Keliso, Yaubada 'ana Venua'ivina.” ");
INSERT INTO yml_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","'Aiata 'aitamogana 'aitamogana tovetumaganavo 'adi 'aila'a i vevebwaika, siwe 'ifwaidi i nuavita yadi 'wabu'wabulavo faifaidi. Tovetumaganavo 'ifwaidi me Kuliki i vonavona i vo, 'Aiata 'aitamogana 'aitamogana tomata'aulelevo 'ani'ani 'wabu'wabulavo i velevelediga, yama 'wabu'wabulavo 'adi 'anivelena siaina, we'e me Ibeliu yadi 'wabu'wabulavo 'adi veuveuta bwaikina.” ");
INSERT INTO yml_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Begaidi tomata'aulelevo 'adi 12 tovetumaganavo matatabudi i vonedi i va'auta taiadi i veifufu i vo, Yama folova mogitana Yaubada yana Vona 'a na lalau'age. Kebu i da lubwainema folovanina 'a na baileni we'e 'ani'ani 'a na 'i'isave'avini. ");
INSERT INTO yml_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Begaidi side bani'odi emavo, 'waimiega tomotoga 'adi 7 'wa na venua'ivinedi, tomotoganidi ma 'adi ve'ililibu, 'Anu'anunu Magemagetana i agedi mogitana wata nuadi magemagetadi. Veimea 'a na veledi bega 'ani'ani 'ana veuta i na 'i'isave'avini. ");
INSERT INTO yml_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","We'e 'ima tutuya fuedi yama folova 'a na lalau'age wata 'a na vevelu'ui Yaubada 'waineye.” ");
INSERT INTO yml_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tovetumagananidi matatabudi i sosoana tomata'aulelevo yadi nuanua faifaina. Begaidi Sitiveni i venua'ivineni, taunina tovetumagana toketokena wata 'Anu'anunu Magemagetana i agei mogitana. Wata 'ifwaidi Sitiveni bani'odi i venua'ivinedi. 'Adi wagava side. Filifi, Filikolo, Nikanoli, Taimoni, Falimina, Nikola, tomogo Anitioki, basenadi i ve-Diu, mulieta i vetumagana Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tovetumaganavo tomotoganidi 'adi 7 i miedi tomata'aulelevo 'waidie, bega tomata'aulelenidi i velu'ui faifaidi wata nimadi i yatodi 'unu'unudie bega Yaubada i na nuakalikaliedi wata i na 'ivaisedi yadi folova 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Yaubada yana Vona valana i susula tomotoga fuedi 'waidie. Tovetumaganavo 'adi 'aila'a Ielusalema nageneye i vebwaika-'afo'afo, wata me Diu yadi tovelomu fuedi i vetumagana Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yaubada ma yana nuakalikali i vevesauluva 'atumaina Sitiveni 'waineye wata toketokena i veleni bega 'eba nuavogana wata 'eba 'isa toketokedi i 'i'idewadi. ");
INSERT INTO yml_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tamu me Diu yadi 'eba miava'auta 'ana wagava Yavuyavudi Folova-maimaiga 'Wainega, 'eba miava'autanina 'ana tomotoga 'ifwaidi i maia Sitiveni taiadi i ve'ikwayekwayega. Tomotoganidi taunidi Diu, 'ifwaidi i maia Sailini wata Alekisanidilia 'waidiega wata 'ifwaidi Silisia wata Eisia 'waidiega. ");
INSERT INTO yml_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tutuyanina i veve'ikwayekwayega, 'Anu'anunu Magemagetana nuamageta bwaikina Sitiveni i veleni bega kebu 'adi fata yana vona i na tutuli. ");
INSERT INTO yml_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","12","Begaidi tomotoganidi givagivayega i nagoi mali tomotoga i tutulidi bega i na lu'ivona-vekavekali Sitiveni faifaina. Tolu'ivonanidi i nagoi Diu yadi to'edakumetavo 'au'auveadi, ve'etoboda 'adi tovevo wata tomotoga 'ifwaidi 'waidie i vekali i vo, 'A nogai Sitiveni i vona-uvi'agala Yaubada wata Mosese 'waidie.” To'edakumetanidi tovekali yadi vona i nogai ma yadi nuasako i nagoi Sitiveni i 'ive'avini i mieni Kanisela 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kaniselavo tovekalinidi i goledi i luku Sitiveni faifaina i veifufu i vo, 'A nogai tutuya fuedi i vona-uvi'agala de'e vanuga tabutabuna wata yada veimea faifaidi. ");
INSERT INTO yml_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Wata tamu yana vona 'a nogai i vo, Iesu Nasalediega yada Vanuga 'Eba Velu'ui i na geuya wata yada sauluva matatabuna i mai Mosese 'wainega i na siviladi i na vetuli.’” ");
INSERT INTO yml_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Matatabudi i miamiani Kanisela yadi tutudaba nageneye Sitiveni i 'isadewai, i 'iseni 'ana 'isa i vetuli, maigina mataududulina bani'odi tamu anelose. ");
INSERT INTO yml_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tovelomu bwaikina Sitiveni i velutolieni i vo, Tolu'ivonanidi i vonaga mogitana 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Sitiveni tovelomu bwaikina kaniselavo taiadi i vonedi i vo, Tamakwavo wata ekwavo a na vonemi. Basenadiotoga tubuda Ebelamo i miamia Mesafotemia, bola kebu i da nago Elana, Yaubada Magemagetana i souyeni 'waineye i voneni i vo, Yamu 'aila'a 'u na 'iawedi wata yamu 'awalawa, 'u na nago tamu 'awalawa 'waineye bola a na vemu.’ ");
INSERT INTO yml_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Bega 'awalawa Kalidia i 'iaweni i nago 'atamana Elana 'waineye i mia. Mulieta Ebelamo tamana yawaina i 'a'ava Yaubada i voneni i kwekwe i mai yada 'awalaweye. ");
INSERT INTO yml_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Tutuyanina 'waineye Yaubada kebu tamu fwayafwaya Ebelamo i da veleniga, kebu tamu yana fwayafwaya mogitanaga bani'odi 'iave 'ana bababa, we'e Yaubada i vona'awaufaufa 'waineye bola fwayafwayanina matatabuna i na veleni wata 'ana wauma faifaidi. Vona'awaufaufanina Yaubada Ebelamo i veleniga, siwe tutuyanina 'waineye kebu natunavo. ");
INSERT INTO yml_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yaubada yana vona side bani'odi Ebelamo 'waineye i vo, Bola 'amu wauma i na nagoi mali 'awalaweye, bei malamala 400 nagedie i na vetofolova-maimaiga wata vita i na veveluagadi tomotoga 'waidiega. ");
INSERT INTO yml_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Siwe tomotoganidi bola vematavuloga a na veledi bega 'amu wauma i na viladi i na maia de'e 'awalawanina 'waineye i na 'odu'odu 'waikuye.’ ");
INSERT INTO yml_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wata Yaubada Ebelamo i voneni i vo, 'Amu wauma matatabudi bunudi i na bobodi yaku veakutagona 'u vetumaganeniga 'ana tugusa.’ Mulieta Aisake i tubuga, 'aiata 'ana ve-8 'waineye Ebelamo bununa i boboi. Wata bani'odi tutuyanina Aisake natuna Iakobo i tubuga, mulieta Iakobo natunavo 'adi 12, taunidi tubudavo ta veve'ililibuyedi.” ");
INSERT INTO yml_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Wata Sitiveni i vo, Tubudavonidi taidi Iosefa i ve'unumagigieni i vekimwaneyeni mali tomotoga 'waidie bega i naweni Itifita bei i vetofolova-maimaiga. Siwe Yaubada i 'wea'weabuya yana veviga 'waidiega i 'ita'ita'ieni. Tamu 'aiata Itifita 'ana kini Felo, Iosefa i goleni i nago 'waineye wata bei Yaubada i 'ivaiseni, begaidi Felo i 'iseni yana sauluva 'atumaina wata ma yana nuamageta. Bega i silakai i vetoveimea yana vanuga 'ana tofolovavo wata 'awalawa Itifita matatabuna 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tutuyanina 'waineye Itifita wata Kenani 'waidie loka bwaikina i souyeni. Tubudavo kebu 'adi fata ava'aibe bei 'ani'ani i na veluagai. ");
INSERT INTO yml_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mulieta Iakobo vala i nogai 'ani'ani fuedi Itifita 'waineye bega natunavo i vetunedi i na kimwane wata i na viladi i na maia. ");
INSERT INTO yml_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tamu tutuya 'adi'adi i 'a'ava wata i viladi i nagoi 'ani'ani i na kimwane. Bei Iosefa taunina i sivemageseni enavo 'waidie, mulieta i veifufu Felo 'waineye yana 'aila'a faifaidi. ");
INSERT INTO yml_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","15","Iosefa enavo i vonedi i vo, 'Wa na nagoi tamada 'wa na voneni matatabumi 'wa na maia de'e bei ta na mia.’ I viladi tamadi i voneni bega Iakobo ma yana 'aila'avo matatabudi 75 i maia Itifita. Bei i miamiani mulieta Iakobo i wafa wata 'ifwaidi tubudavo. ");
INSERT INTO yml_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Basenadiotoga Ebelamo i miamia Sekemu, tamu fwayafwaya i kimwanei Emoli 'ana wauma 'waidiega. Tutuyanina Iakobo wata Iosefa i wafaga tomogodi i nawedi fwayafwayanina 'waineye i ve'ufadi.” ");
INSERT INTO yml_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Wata Sitiveni kaniselavo i vonedi i vo, Malamala fuedi i 'a'ava tubudavo i miamia Itifita, 'adi 'aila'a i vebwaika-'afo'afo wata Yaubada yana vona'awaufaufa Ebelamo 'waineye bola 'awalawa Kenani tubunavo i na veledi, 'ana tutuya i vevelilivana. ");
INSERT INTO yml_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mulieta tamu kini i tovoi Itifita i veimeyeni, Iosefa i bavuyeni fai basenadiotoga i wafa. ");
INSERT INTO yml_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kini tubudavo i vekaliedi wata tutuya vitana i veledi. I lulukakadedi bega natudiavo wala'aie i yatoyatodi i wafawafa. ");
INSERT INTO yml_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","21","Tutuyanina 'waineye tamu kwamana i tubuga 'ana wagava Mosese, taunina 'atumaiotogina Yaubada mataneye. Weta'i 'aitonu nagedie inana wata tamana i giveni vanuge, mulieta i sivemageseni Felo natuna vevinena i fayayeni, i taulai 'wa da vo bani'odi natuotogina. ");
INSERT INTO yml_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Me Itifita yadi nuamageta matatabuna Mosese i veni, begaidi ma yana 'aseta. Yana vona 'adi nogaya 'atumaidi wata yana folova toketokena.” ");
INSERT INTO yml_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Wata Sitiveni i vo, Tutuyanina Mosese 'ana malamala 40 i vevenua'ivina nuanuana i na nago yana tomotogavo me Isileli i na fogedi. ");
INSERT INTO yml_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","I nago tamu tomogo Itifita i 'iseni tomogo Isileli i nikenikei, bega Mosese iana i 'ivaiseni tomogo Itifita i nikei i wafa. ");
INSERT INTO yml_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Yana nuanua i vo 'ako enavo 'akonadi i 'asetai bola Yaubada i na 'ivaiseni bega i na 'ita'ita'iedi me Itifita 'waidiega, kebu wata i na folova-maimaiga, siwe kebu i da 'asetaiga. ");
INSERT INTO yml_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","I 'atai wata i nago me Isileli 'adi 'ailuga i 'isedi i vevetalaga, Mosese nuanuana ma iana i na veiana bega i vonedi i vo, 'Wa 'ailove, we'e iamu awale tauni'avada 'wa vevetalaga?’ ");
INSERT INTO yml_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Igodi i da talabodedi nika tomogonina vetalaga i vesivauliga Mosese i bifeleni i vo, 'Omu kebu tamu aitoi i da silakaimu bega 'u na vetoveimea 'waimeye wata yada sauluva 'wainega 'u na veveimeyema. ");
INSERT INTO yml_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bogi tomogo Itifita 'u nikei i wafa, yau wata igodi nuanuamu 'u na nikeku.’ ");
INSERT INTO yml_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tutuyanina vonanina Mosese i nogai i dega Itifita 'wainega i nago 'awalawa Midiani. Kumanina mali tomotoga, siwe bei i nagi i venatuna, natunavo iavetadi 'adi 'ailuga. ");
INSERT INTO yml_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Malamala 40 i 'a'ava, Mosese i nunago sali'avu'avuye 'Oya Sainai lilivaneye, nika tamu anelose i souyeni 'waineye 'ai-'ala'alata nageneye. ");
INSERT INTO yml_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","I 'iseni welavi yauyauvina i 'ala'alata, nuana i vogani i nago lilivaneye nuanuana i na 'isadewai. 'Auvea bonana i nogai i vo, Yau tubumwavo yadi Yaubada. Ebelamo, Aisake wata Iakobo yadi Yaubada.’ Mosese ma yana kololo i tatava, kebu nuanuana i na 'ise'iseni. ");
INSERT INTO yml_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Wata 'Auvea Mosese i voneni i vo, 'Amu 'ageyafayafa 'u na ta'idi fai bei 'u tovotovoiga fwayafwaya tabutabuna.’ ");
INSERT INTO yml_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yaku tomotoga Itifita 'waineye i miamiani yadi veviga bwaikina a 'iseni mogitana wata yadi taivonavona a nogai bega a obuma a na 'ita'ita'iedi. Begaidi de'e 'wainega a na vevilamu 'u na nago Itifita.” ");
INSERT INTO yml_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Wata Sitiveni i vona kaniselavo 'waidie i vo, Side bani'odi, me Isileli Mosese i vedumwe'ai'aieni, i voneni i vo, 'Omu kebu tamu aitoi i da silakaimu bega 'u na vetoveimea 'waimeye, wata yada sauluva 'wainega 'u na veveimeyema.’ 'Ai-'ala'alata wata anelose 'waidiega Yaubada Mosese i vetunei me Isileli 'waidie, bega kumanina 'adi to'edakumeta wata 'adi to'ita'ita'i. ");
INSERT INTO yml_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","I nago tomotoganidi i vagavaidi Itifita 'wainega malamala 40 nagedie i yabedi sali'avu'avuye. Itifita 'waineye, Eyaga Yamoyamoina 'waineye wata sali'avu'avuye 'eba nuavogana wata 'eba nua'ewa fuedi i 'idewadi. ");
INSERT INTO yml_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosese kumanina me Isileli i vonedi i vo, Bola Yaubada tamu yana Tolu'ivona i na vetunei 'waimie yau bani'odi. Taunina yada tomotoga 'waidega i na silakai.’ ");
INSERT INTO yml_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tamu tutuya Mosese wata tubudavo me Isileli i miava'auta sali'avu'avuye. Bei 'Oya Sainai 'waineye tamu anelose Yaubada yana Vona i lu'ivoneyeni Mosese 'waineye. Vonanina Mosese i veleda i na 'eno-vagata.” ");
INSERT INTO yml_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Wata Sitiveni i vona kaniselavo 'waidie i vo, Tubudavo i vedumwe'ai'ai kebu Mosese i da vematayakeyakeni, nuanuadi i na viladi Itifita. ");
INSERT INTO yml_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Begaidi tomotoganidi Mosese tatana Eloni i voneni i vo, Mosese basenadi i vagavaida Itifita 'wainega i laka 'Oya Sainai 'waineye, siwe kebu ta da 'asetai voke i vuyo. Nuanuama kumaea 'u na 'idewadi bega 'waidie ta na 'odu'odu, taunidi i na 'edakumeseda.’ ");
INSERT INTO yml_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Eloni yadi vona i nogai tamu kumaea i 'idewai, 'ana 'isa'isa bani'odi bulumakau natudi wata i sakali. Sakalinina 'waineye tamu 'aisaya i nikei i kabuni kumaea faifaina bega i sosoana-'afo'afo fai taunidi 'adi 'idewadewa 'waineye ma yadi subia i 'odu'odu. ");
INSERT INTO yml_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Fai Yaubada i vedumwe'ai'aieni nuanuadi kumaea, begaidi Yaubada i bailedi, i tauyedi 'ubwana 'waidie i na 'odu'odu. I 'a'avana mulieta sauluvanina faifaina Yaubada yana tolu'ivona Emosi i kilumi Yaubada yana vona i vo, Me Isileli, malamala 40 nagedie sali'avu'avuye 'aisayayega 'wa vevelomu, siwe kebu 'wa da 'odu'odu 'waikuye. ");
INSERT INTO yml_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ma'itufa yami yaubada-vekavekali 'wa yabeyabedi. Yami kumaea Moleki ma 'ana lau'weta wata kumaea 'ubwana Lifani faifaina, ma yami subia 'waidie 'wa 'odu'odu.’ Begaidi me Babiloni a na tauyedi i na 'ive'avinimi i na nawemi yadi 'awalaweye i na veimeyemi.’” ");
INSERT INTO yml_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Wata Sitiveni i vo, Basenadiotoga tubudavo Vadavada Tabutabuna i yabeyabeni sali'avu'avuye, vadavadanina i 'idewaiga ava'ai Yaubada Mosese i awave'ede'edeni wata i veni 'ana 'isa'isa bani'odi. ");
INSERT INTO yml_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mulieta tubudavo Vadavada Tabutabuna natudiavo i veledi. Tutuyanina Iosua i 'edakumesedi i 'ewa-vuvueni wata Yaubada i 'ivaisedi mali tomotoga i sogiedi yadi fwayafwaya i elodi. Bei me Isileli i miamiani fwayafwayanina 'waineye wata vadavadanina i 'enoga i nago tutuyanina tubuda Devida i souyeni. ");
INSERT INTO yml_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devida yana sauluva 'atumaina Yaubada mataneye, begaidi Yaubada i nuakalikalieni. Wata Devida i velu'ui Yaubada 'waineye i vo, Yaubada, 'omu basenadiotoga Iakobo i 'odu'odu 'waimuye, 'u da tauyeku yamu Vanuga 'Eba Velu'ui a da yogoni.’ ");
INSERT INTO yml_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yaubada kebu i da tauyeni we'e natuna Solomoni vanuganina i yogoni. ");
INSERT INTO yml_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Siwe tomotoga 'adi 'a'aiyogona Yaubada Bwaikaotogina kebu yana 'eba mia. Begaidi tamu tolu'ivona Yaubada yana vona i kilumi i vo, ");
INSERT INTO yml_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Vanuganidi 'wa yogoyogonidiga yau 'Auvea kebu i da lubwaineku, kebu 'ana fata bei a na miaga. Abama yaku 'eba mia, fwayafwaya 'ageku 'adi 'eba yato wata yaku 'eba veimea. ");
INSERT INTO yml_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Naninidi 'wa da vo yau kebu a da 'idewadiga.’” ");
INSERT INTO yml_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Wata Sitiveni me Diu to'edakumetavo i vonedi i vo, 'Omi tutuya fuedi Yaubada yana vona 'wa baibaileni. 'Wa nogai siwe 'wa kwayega, kebu 'wa da vematayakayaka. 'Omi 'asa'aiana tubudavo yadi sauluva 'wa 'ewa-'afo'afoi. Tutuya fuedi 'Anu'anunu Magemagetana yana folova 'waimie 'wa tatalabodeni. ");
INSERT INTO yml_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tubudavo Yaubada yana tolu'ivonavo matatabudi i vedumwe'ai'aiedi veviga i veledi, kebu tamu i da vesauluva-'atumaieni. Basenadiotoga Yaubada yana tomata'aulelevo i vetunedi i vona-samula yana Tofolova Magemagetana yana mai faifaina, siwe tubumiavo i nikedi i wafa. We'e tutuyanina yana Tofolovanina i le'wa 'omi 'wa 'etogiluveni wata 'wa luvewafai. ");
INSERT INTO yml_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","'Omi kumanimiavo Yaubada yana veimea 'wa 'ewadi anelose 'waidiega siwe kebu 'wa da vematayakeyakedi.” Side bani'odi Sitiveni yana lau'age i ve'a'avai. ");
INSERT INTO yml_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Me Diu yadi to'edakumetavo Sitiveni yana vona i noganogaiga gadodi i 'alasedi i nuasako bwaikina 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Siwe Sitiveni 'Anu'anunu Magemagetana i agei mogitana bega i 'isalaka abame, i 'iseni Yaubada yana mageta mataududulina wata 'ana 'atagiega Iesu i tovotovoi. ");
INSERT INTO yml_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","I vo, Mataku 'wa na velugai. Abama i 'anikililia a 'iseni Iesu kumanina i vetomotogaotoga, ma yana veimea i tovotovoi Yaubada 'ana 'atagiega.” ");
INSERT INTO yml_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Tanigadi i 'ibodadi wata i vegolegole Sitiveni bonana i lutavutavuni. I lilide i tovififineni i 'ive'avini i yo'ei i obuyeni mwalilige bei i lukileuya. Sitiveni 'ana tovevita kumanidiavo to'ainike 'adi talauma i talata'idi, i 'etokwauya tamu tubuau 'ana wagava Saulo i 'isave'avinidi. ");
INSERT INTO yml_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tutuyanina i nikenikei Sitiveni bonana bwaikinega i velu'ui i vo, 'Auvea Iesu, 'anu'anunuku a tauyeni 'waimuye 'u na 'ewai.” ");
INSERT INTO yml_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","'Agena i vetufano'uyedi wata i vegole i vo, 'Auvea, yadi sauluva sakoina 'u da nuatavuni.” I vona'a'ava nika yawaina i 'a'ava. ");
INSERT INTO yml_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Tomotoganidi Sitiveni i lukileuya i wafa Saulo i 'ise'iseni, i awave'atumaieni. Tomotoga 'ifwaidi Yaubada 'ana tovematayakayaka Sitiveni i mogaia, i 'ewai i nagoi i ve'ufai. 'Aiatanina 'waineye Sitiveni i wafaga, Iesu 'ana tovedumwe'ai'ai i velamu tovetumaganavo Ielusalema 'waineye veviga bwaikaotogina i veleveledi. Saulo i nago vanuga 'aitamogana 'aitamogana 'waidie, 'ai'edi bei tovetumaganavo vevine wata iaveta i veveluagadi, i yo'eyo'edi i nunawedi vanuga yogona nageneye. Bani'odi i munegidi igodi tovetumaganavo 'adi 'aila'a i da leo'a'avadi. Begaidi tovetumaganavonidi i yavula i nagoi 'awalawa fuedi 'waidie, Iudia wata Samelia nagedie. Tomata'aulelevo 'aisedi i miamiani Ielusalema. ");
INSERT INTO yml_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tovetumaganavonidi i yavulaga i nagoi 'awalawa matatabuna 'waidie Iesu Valana i lulu'ageyeni. ");
INSERT INTO yml_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","We'e Filifi i nago tamu 'atamana bwaikina 'waineye 'awalawa Samelia nageneye, bei i lau'age Yaubada 'ana Venua'ivina Keliso faifaina. ");
INSERT INTO yml_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Wata bei 'eba nuavogana wata 'eba nua'ewa i 'idewadi begaidi yana vona i vinenegeni 'atumaina. ");
INSERT INTO yml_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filifi 'eba nuavogananidi i 'idewadi side bani'odi. Tomotoga yaiaina i agediga i veugeugedi, nika ma yadi vebwaubwau i 'awa'a'idi 'waidiega. Bwalobwaloko wata tomotoganidi 'agedi sinunumidi fuedi i 'ive'atumaidi. ");
INSERT INTO yml_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Begaidi tomotoga fuedi i sosoana bwaikina. ");
INSERT INTO yml_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","'Atamananina 'waineye tamu tomogo 'afo'afo'ana i miamia 'ana wagava Saimoni, taunina i awa'ai'aia i vo, Yau tomogo bwaikiku, yami 'eba 'isa.” Me Samelia fuedi nuadi i voganidi 'ana 'afo'a faifaina. ");
INSERT INTO yml_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Fai tutuya fuedi 'eba nuavogana wata 'eba nua'ewa i 'i'idewadi, tomotoga bwaikidi wata tomotoga-'avo'avovo nuadi i 'ewai i ve'ililibuyeni igodi i vo, Tomogo de'e yana toketokena bwaikina Yaubada 'wainega.” ");
INSERT INTO yml_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Siwe tutuyanina Filifi i le'wa i lalau'age Vala 'Atumaina faifaina, Yaubada yana veimea tomotoga 'waidie wata Yaubada 'ana Venua'ivina Iesu faifaina. Yana lau'agenina 'wainega fuedi i vetumagana, bega vevine wata iaveta i bafitaiso. ");
INSERT INTO yml_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Wata Saimoni i vetumagana i bafitaiso, begaidi Filifi i yogo'wai'waili fai yana folova toketokedi i 'isedi nuana i 'ewai. ");
INSERT INTO yml_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tomata'aulelevo i miamianiga Ielusalema, vala i nogai me Samelia fuedi Yaubada yana Vona i vetumaganeni, bega Fita wata Ioni i vetunedi i na nagoi i na fogedi. ");
INSERT INTO yml_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Tutuyanina i le'wai i 'asetai 'akonadi i bafitaiso 'Auvea Iesu 'ana wagavayega siwe 'Anu'anunu Magemagetana kebu i da agedi. ");
INSERT INTO yml_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Begaidi Fita wata Ioni nimadi i yatodi 'unu'unudie, i velu'ui faifaidi nika 'Anu'anunu Magemagetana i agedi. ");
INSERT INTO yml_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Tutuyanina Yaubada 'Anu'anunu Magemagetana i tauyeni tomotoganidi i agedi, Saimoni i 'iseni i nago Fita wata Ioni 'waidie igodi mani i da veledi i vo, Toketokenanina 'wa da veleku bega yau wata 'ai'edi nimaku a na yatodi tomotoga 'waidie, 'Anu'anunu Magemagetana i na agedi.” ");
INSERT INTO yml_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Fita ma yana nuasako Saimoni i voneni i vo, 'Omu igodi Yaubada yana nuakalikali 'u da kimwanei maniega. Nuanuaku yamu maninina taiadi 'wa da luku 'ai-'ala'alase i da 'alaimu. ");
INSERT INTO yml_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","'Omu yamu folova wata 'ima yama folova kebu i da vesala. Kebu i da lubwainemu 'u na 'ivaisema fai yamu nuanua kebu tonovinaga Yaubada mataneye. ");
INSERT INTO yml_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Sakonanina faifaina 'u nuanua, 'u na nuavilamu 'u na velu'ui 'Auvea 'waineye. Voke i na nuatavunimu. ");
INSERT INTO yml_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","A 'asetamu 'u ve'unumagigiema wata sakona i yogonimu.” ");
INSERT INTO yml_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimoni i vona Fita wata Ioni 'waidie i vo, 'Wa da velu'ui faifaiku 'Auvea 'waineye, bega veviganidi 'wa voneyediga kebu i na sousouyedi 'waikuye.” ");
INSERT INTO yml_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Fita wata Ioni i lulu'ivona 'Auvea faifaina mulieta i viladi i nunagoi Ielusalema, 'atamana fuedi Samelia nageneye 'waidiamo i nago, Iesu Valana 'Atumaina 'waidie i lau'age. ");
INSERT INTO yml_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tamu 'aiata 'Auvea yana anelose i souyeni Filifi 'waineye i voneni i vo, 'U na 'idewadewa nika 'u na nago yavalatayega, 'edeamo 'u na nunago tamu 'eda 'u na 'iseni Ielusalemayega i obuobu Gasa sali'avu'avu 'waineamo.” ");
INSERT INTO yml_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Bega Filifi i 'idewadewa i tauya, i nunago 'edeye 'awalawa Itiofia 'ana toveimea tamu i veluagai. Toveimeanina tomogo bwaikina, Itiofia 'ana Kwini 'adi wagava Kanidesa yadi mani 'ana to'isave'avina. Tomogonina basenadi i luku Ielusalema, Yaubada 'waineye i 'odu, i 'a'ava i vilai i nunago yana salioti 'wainega. I nunago 'edeye Yaubada yana Buki basenadiotoga Aisea i kilumi i lulu'iawawai. ");
INSERT INTO yml_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","'Anu'anunu Magemagetana Filifi i voneni i vo, 'U vaganago waka lilivaotogineye.” ");
INSERT INTO yml_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filifi i lilide i nago tomogonina lilivaneye, i nogai i lulu'iawawaga bega i velutolieni i vo, Bukinina 'u lulu'iawawaiga 'u 'asetai 'alo kebu?” ");
INSERT INTO yml_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tomogonina Itiofiayega i vo, Bani'odi a na munega a na 'asetai? 'Ai'edi aitoi i da kiavemagetai 'waikuye 'aku fata a da 'asetai. 'Ai'edi 'u da 'asetaiga 'u da lakama lilivakuye 'u da miabui 'u da kiavemagetai 'waikuye.” ");
INSERT INTO yml_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Vonanina Yaubada yana Buki nageneye i lulu'iawawaiga side bani'odi. I 'ivekokoviga, siwe kebu tamu vona 'awanega i da souyeni. I tokemaigeni 'wa da vo bani'odi sifi siaina i da naweni 'eba luvewafa 'waineye, 'alo tutuyanina sifi vutuvutuna i boboboi i veve'wadamo. Wata bani'odi, Tofolovanina kebu i da vetafewaga wata kebu i da 'we'welaga, i ve'wadamo. ");
INSERT INTO yml_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tomotoga i awaobubouyeni wata veviga bwaikina i veleni, siwe kebu tamu aitoi i da 'ivaiseni veimea tonovina 'wainega. Kebu 'ana fata tubunavo ta na luveseveseseledi, fai yana mia fwayefwayeye i daba-matayo'oi yana 'aila'a kebu. ");
INSERT INTO yml_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Itiofia 'ana toveimea Filifi i velutolieni i vo, Nuanuaku a na 'asetai aitoi faifaina i vonavona, taunina 'alo tamu tomogo?” ");
INSERT INTO yml_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Bega Filifi vonanina 'wainega i velamu, Vala 'Atumaina Iesu faifaina i kiavemagetai. ");
INSERT INTO yml_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","I nunago 'edeye ufa i 'iseni toveimeanina Filifi i voneni i vo, Ufa sino. I lubwaineku 'u na bafitaisoku.” ");
INSERT INTO yml_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filifi i voneni i vo, 'Ai'edi yamu nuanua matatabuna 'u na tauyeni Iesu 'waineye 'u na vetumaganeni a na bafitaisomu.” Toveimeanina i vo, A vetumagana Iesu Keliso taunina Yaubada Natuna wata 'ana Venua'ivina 'waineye.” ");
INSERT INTO yml_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Waka i 'ailove, 'adi 'ailuga i obu i tovi'utuva ufeye, Filifi toveimeanina i bafitaisoi. ");
INSERT INTO yml_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tutuyanina i lakama 'avale Filifi i 'awafa'wani fai 'Auvea 'Anu'anununa i vagavaia i naweni, we'e toveimeanina kebu i da 'asetai ava'aiamo i nago kebu wata i da 'iseni, siwe ma yana sosoana i tauya i nago yana vanuge. ");
INSERT INTO yml_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","We'e Filifi i souyeni 'atamana Asota, i nago 'atamana bwaikidiamo Iesu Valana 'Atumaina i lu'ageyeni i nago i le'wa Sisalia. ");
INSERT INTO yml_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Tutuyanina 'waineye, Toveimea Iesu 'ana tovetumaganavo Saulo i veve'isakololodi, nuanuana i na nikedi i na wafa. I nago tovelomu bwaikina i voneni lubulubu i na kilumidi i na veleni i na nawedi Damasiko. Bei Diu yadi 'eba miava'auta 'adi to'edakumetavo i na lu'iawawadi i na 'asetai Saulo ma yana veimea bega 'ai'edi Iesu yana 'Eda'eda 'ana tovetutuyama i na veluagadiga, vevine wata iaveta, i na 'ive'avinidi i na miedi Ielusalema. ");
INSERT INTO yml_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulo wata 'ifwaidi tomotoga taiadi i nunagoi Damasiko sai'afoga i na le'wa 'atamananina 'waineye, nika mageta abamayega i kianamali i mageseni. ");
INSERT INTO yml_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo i be'u fwayefwayeye bona i nogai i vonavona 'waineye i vo, Saulo, Saulo, awale vita 'u veleveleku a veveviga?” ");
INSERT INTO yml_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Bonana i tutuli i vo, 'Auvea, 'omu aitoi?” I vo, Yau Iesu, kumaniku vita 'u veleveleku. ");
INSERT INTO yml_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","'U na tovoi 'u na nago 'atamana bwaikina 'waineye, bei tamu tomogo i na vonemu ava'ai 'u na 'idewai.” ");
INSERT INTO yml_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tomotoganidi Saulo taiadi i nunagoiga, i tovi-valavalalai kebu 'adi fata tamu ava'ai i na voneyeniga. Bonananina i nogai, siwe kebu tamu aitoi i da 'iseniga. ");
INSERT INTO yml_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","'Akonadi mageta i 'awaiaia i 'a'ava, Saulo i tovoi i 'isala siwe kebu tamu ava'ai i da 'iseniga, begaidi nimaneye i 'abi i naweni Damasiko. ");
INSERT INTO yml_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","'Aiata 'aitonu nagedie, kebu 'ana fata i na 'isa, kebu i da 'ani wata kebu i da yemu. ");
INSERT INTO yml_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasiko 'waineye tamu tovetumagana i miamia, 'ana wagava Ananaiasi. 'Ana ve 'wainega 'Auvea i voneni i vo, Ananaiasi.” I vo, 'Auvea yau side.” ");
INSERT INTO yml_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","'Auvea i vona i vo, 'U na tovoi 'u na nago 'eda 'ana wagava 'Eda Tonovina 'waineamo, Iudasa yana vanuge 'u na velutoli Saulo 'atamana Tasisu 'wainega faifaina, tomogonina i vevelu'ui 'waikuye. ");
INSERT INTO yml_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","'Ana ve 'wainega tamu tomogo 'ana wagava Ananaiasi i 'iseni i luku vanuge, nimana i yatodi 'waineye nika i 'isa-vaitugana.” ");
INSERT INTO yml_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Siwe Ananaiasi i tutuli i vo, 'Auvea, tomotoga fuedi i lu'ivona 'waikuye tomogonina faifaina, yamu tomotoga Ielusalema 'waineye i 'ivekokovidi. ");
INSERT INTO yml_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","'Akonadi tovelomu yadi to'edakumetavo veimea i veleni i mai Damasiko, bega egavo 'amu wagava i awa'ai'aia i na 'ive'avinidi.” ");
INSERT INTO yml_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","'Auvea Ananaiasi i voneni i vo, 'Asa'aiana, 'u na nago fai 'akonadi a venua'ivineni yaku tofolova. Faifaiku i na lulu'ivona me Diu wata mali tomotoga kumanidiavo kebu Diu yadi kini taiadi 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Wata yau a na veni veviga bwaikina i na veluagai faifaiku.” ");
INSERT INTO yml_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","'Auvea yana vona i 'a'avana, Ananaiasi i tovoi i nago Iudasa yana vanuge, i luku Saulo i 'abitonovi i voneni i vo, Taiku Saulo, 'Auvea Iesu i vetuneku, kumanina 'u 'iseni 'edeye tutuyanina 'u mimai side bei. I vetuneku bega 'u na 'isa-vaitugana wata 'Anu'anunu Magemagetana i na agemu.” ");
INSERT INTO yml_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","19","I vona'a'avana tamu nani matanega i 'anita'ia bani'odi igana kwanavidi, nika i 'isadewa. I tovoi i bafitaiso, mulieta i 'ani nika yana toketokena i veluagai. Saulo i yogomia tovetumaganavo taiadi Damasiko 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Bei tonovina i nago Diu yadi 'eba miava'auta 'waidie i lau'age Iesu faifaina i vo, Taunina Yaubada Natuna.” ");
INSERT INTO yml_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Fuedi i nogai nuadi i voganidi 'aise'avadi i vona i vo, Voke kumanina tomogonina Iesu 'ana tovetumaganavo i luluvewafadi Ielusalema 'waineye. Wata i mai side bei igodi tovetumaganavo i da 'ive'avinidi i da nawedi tovelomu yadi to'edakumetavo 'waidie.” ");
INSERT INTO yml_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Siwe Saulo yana lau'age i vevetoketoke i kiavemageta Iesu mogitana Yaubada 'ana Venua'ivina, begaidi me Diu i miamianiga Damasiko 'waineye kebu 'adi fata bonana i na tutuli. ");
INSERT INTO yml_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","'Aiata fuedi i 'a'ava, mulieta me Diu i va'auta i veifufugiva bani'odi i na munega Saulo i na nikei i na wafa. ");
INSERT INTO yml_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","'Atamananina matatabuna kalikalina, kalinina i didigi i laka manamanawena bega toveifufunidi 'awa i tovibodadi igodi nuanuadi Saulo i na 'ive'avini, siwe tamu tomogo i lu'ivona 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Begaidi tamu lovana tovetumaganavo 'ifwaidi Saulo i dodogi walisava fa'alina 'waineye, kali badubaduna 'ana tutubweka 'waineamo i siobuyeni kalimulie i dega. ");
INSERT INTO yml_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tutuyanina Saulo Damasiko i 'iaweni i nago Ielusalema, nuanuana bei tovetumaganavo ma fuedie i na folofolova siwe i kololoyeni i vo 'ako kumanina kebu tovetumagana. ");
INSERT INTO yml_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mulieta tamu tovetumagana 'ana wagava Banabasa i mai Saulo i 'ivaiseni i 'edakumeseni i naweni tomata'aulelevo 'waidie. I veifufu 'waidie i vo, De'e iada, 'Auvea i 'iseni Damasiko 'ana 'edeye wata i veifufu 'waineye. Mulieta i nago Damasiko 'waineye ma yana venuafoufa'ala i lau'age Iesu faifaina.” ");
INSERT INTO yml_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tomata'aulelevo i ve'awamogitana bega taiadi i miamiani wata ma fuedie Ielusalema matatabuna 'waineye i lalau'age Toveimea Iesu faifaina, ma yana toketokena kebu i da kolologa. ");
INSERT INTO yml_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wata i nago Diu 'ifwaidi bonadi Kuliki 'waidie, taiadi i ve'ikwayekwayega nika igodi i da luvewafai. ");
INSERT INTO yml_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tutuyanina tovetumaganavo i 'asetai, i vagavaia i obuyeni 'atamana Sisalia bega i vetunei i nago Tasisu 'ana tuvadeye. ");
INSERT INTO yml_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tutuyanina i 'iawedi, Iesu 'ana tovetumaganavo 'adi 'aila'a i miamiani 'awalawa Iudia, Galili wata Samelia, yadi mia i ve'atumai wata i tovotovoi fa'alina Iesu 'waineye. Ma yadi kololo Toveimea Iesu i veve'ililibuyeni, wata 'Anu'anunu Magemagetana yana 'aivaita 'wainega 'adi 'aila'a i vevebwaika. ");
INSERT INTO yml_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Fita 'atamana fuedi 'waidie i folova-vuvua wata tamu 'aiata i nago 'atamana Lida, Yaubada yana tomotoga i na fogedi. ");
INSERT INTO yml_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Bei tamu tomogo bwalobwalokona i veluagai 'ana wagava Inia, malamala 8 'ivie i 'eno'enovamo kebu 'ana fata i na yaba. ");
INSERT INTO yml_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Fita i voneni i vo, Inia, Iesu Keliso i na 'ive'atumaimu. 'U tovoi, 'amu 'ivi 'u nunumi.” Fita i vona'a'ava, Inia i tovoi-matayo'o. ");
INSERT INTO yml_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tomotoganidi Lida wata Seloni laube'una 'waidie i miamiani, i 'iseni bega fuedi i nuaviladi taunidi i tauyedi 'Auvea 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","We'e 'atamana Iofa 'waineye tamu vavine i miamia, 'adi wagava Tabida, taunidi tovetumagana. 'Adi wagavanina 'ana saivila Kuliki bonadiega Dokasa. Vavine de'e yadi sauluva wata yadi folova 'atumaidi, tovewekowekoma i nunuakalikaliedi. ");
INSERT INTO yml_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tutuyanina 'waineye i viga nika i wafa. Vanuganina 'waineye i wafaga, 'etotubwatubwana, tutudaba 'ifwaidi dibuneye, 'ifwaidi tabwaneye bega ediavo tomogodi i 'idewadewai, mulieta i yatodi tamu tutudaba 'waineye vanuga tabwaneye. ");
INSERT INTO yml_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Iofa kebu 'ani'iega Lida 'wainega, bega tutuyanina tovetumaganavo vala i nogai Fita i miamia Lida, tomotoga 'adi 'ailuga i vetunedi Fita i na voneni nuanuadi i na lilide i na mai Iofa. ");
INSERT INTO yml_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Fita tomotoga 'adi 'ailuga i nogayedi i tovoi ma fuedie i nagoi. Tutuyanina i le'wai i lakaveni tutudaba 'waineye. 'Wabu'wabulavo fuedi Dokasa tomogodi i tovififineni i vevemogai, we'e talauma siaidi wata bwaikidi ma yawaidie i 'idewadiga Fita i veni. ");
INSERT INTO yml_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Fita i talabodedi i souyedi, i 'odu i velu'ui, mulieta i sivilai tomogodi 'waineye i vona i vo, Tabida, 'wa tovoi.” I 'isala Fita i 'iseni i tovoi i miabui. ");
INSERT INTO yml_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Fita nimana i 'otoi i sivetovoiotogidi. I 'a'avana, tovetumaganavo wata 'wabu'wabulavo taiadi i goledi i luku i vedi vavine 'akonadi i yawasa. ");
INSERT INTO yml_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Matatabudi Iofa nageneye valadi i nogai, bega fuedi i vetumagana 'Auvea 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","'Aiata fuedi nagedie Fita i miamia Iofa, Saimoni 'aisaya bunudi 'adi to'idewadewa yana vanuge. ");
INSERT INTO yml_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","'Atamana Sisalia 'waineye tamu tolugavia 'adi to'edakumeta i miamia, 'ana wagava Konilio. Tolugavianidi 'adi wagava 'Aila'a Itali. ");
INSERT INTO yml_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","To'edakumetanina wata yana vavine natunavo taiadi totafalolo, Yaubada 'waineye i 'odu'odu. Taunina kebu tomogo Diu siwe yana sauluva me Diu i vewekowekomaga i 'i'ivaisedi wata tutuya fuedi i vevelu'ui Yaubada 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tamu lavilavi bani'odi 3 kiloki 'waineye, 'ana ve 'wainega tamu Yaubada yana anelose i 'isaotogi i mimai 'waineye i voneni i vo, Konilio.” ");
INSERT INTO yml_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ma yana kololo i 'isanago 'waineye i tutula i vo, Ava'ai 'auvea?” Anelosenina i vo, Yaubada yamu velu'ui i nogaidi wata yamu nuakalikali i 'isedi i sosoana bega i nuanuanimu. ");
INSERT INTO yml_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","'Asiau 'ifwaidi tomotoga 'u na vetunedi i na nagoi Iofa, bei tamu tomogo i na veluagai 'ana wagava Saimoni Fita. ");
INSERT INTO yml_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","I miamia balebaleye, Saimoni kumanina 'aisaya bunudi 'adi to'idewadewa taiadi.” ");
INSERT INTO yml_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","I vona'a'ava i 'iaweni, Konilio yana vanuga 'ana tofolovavo 'adi 'ailuga wata tamu tolugavia siwe taunina totafalolo, i goledi i veifufudi mulieta i vetunedi i obu Iofa. ");
INSERT INTO yml_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","I 'atai tomotoganidi 'adi 'aitonu i nunago 'edeye sai'afoga i na le'wai Iofa, utukamwane Fita i laka vanuga tabwana bababana yadi 'eba veba'wa 'waineye bei i na velu'ui. ");
INSERT INTO yml_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","I lase nuanuana i na 'ani, siwe tutuyanina tomotoga 'ifwaidi 'ani'ani bola i 'idewadewa, Fita 'ana ve 'wainega abama i 'anikililia tamu nani i 'iseni i obuobuma. Naninina i 'iseniga bani'odi velu'uva bwaikina mataifwadi 4 'waidie i 'abi i sisiobuyeni fwayefwayeye. ");
INSERT INTO yml_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nageneye 'aisaya tulina tulina, 'ifwaidi daledaledi wata manuga, matatabudi me Diu yadi tabu. ");
INSERT INTO yml_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Fita tamu bona i nogai i vo, Fita, 'u tovoi 'u nikedi 'u 'anidi.” ");
INSERT INTO yml_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Siwe Fita i vo, Kebu 'Auvea, yau kebu a da 'ani-'avo'avovoga wata 'aisayanidi 'ima me Diu yama tabu kebu a da 'ani'anidiga.” ");
INSERT INTO yml_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Wata yana vona 'ana veluga 'waineye i vo, Ava'ai Yaubada i awave'atumaiediga, kebu 'u na awavesakoyedi.” ");
INSERT INTO yml_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tutuya 'aitonu naninina i souyeni 'waineye, mulieta velu'uvanina i silakai i laka abame. ");
INSERT INTO yml_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","18","Fita 'ana ve faifaina i vevenua'ivina nika Konilio yana tomotogavo i le'wai me Iofa i velutoliedi i vo, Ava'aibe bei Saimoni yana vanuga?” I vedi bega i nago tanotanoge i tovoi i vegole i vo, 'Wa da 'asetai tamu tomogo 'ana wagava Saimoni Fita de'e bei i miamia?” ");
INSERT INTO yml_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","We'e Fita bola i vevenua'ivina 'ana ve faifaina, nika 'Anu'anunu Magemagetana i vo, Saimoni, tomotoga 'adi 'aitonu i vevelutoli faifaimu. ");
INSERT INTO yml_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","'U tovoi 'u obu ma fuemie 'wa na nagoi. Tomotoganidi kebu me Diu siwe kebu 'u na venuanaluga 'u na nagomo fai yau a vetunedi.” ");
INSERT INTO yml_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bega Fita i obu tomotoganidi i vonedi i vo, Yau side, kumaniku 'wa lulualeku. Ava'ai faifaina 'wa maia?” ");
INSERT INTO yml_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","I voneni i vo, Konilio, tamu tolugavia 'adi to'edakumeta, i vetunema 'a maia. Taunina tomogo 'atumaina, Yaubada 'ana to'odu'odu wata me Diu fuedi i ve'ililibuyeni. Tamu anelose magemagetana i voneni i vo, Vala 'u na vetunei Fita 'waineye i na mai, ava'ai i na vonemuga bonana 'u na nogai.’” ");
INSERT INTO yml_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tomotoganidi 'adi 'aitonu i veifufu'a'ava, Fita i vonedi i luku i 'enovi Saimoni yana vanuge. I 'atai Fita i 'idewadewa, ma fuedie i tauya wata 'ifwaidi Iesu 'ana tovetumaganavo Iofa 'wainega taiadi i nagoi. ");
INSERT INTO yml_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","'Edeye i 'enovi mulieta i le'wai Sisalia, Konilio i lulukamata ma yana vavine, natunavo wata enavo 'akonadi i vonedi i maiaga ma fuedie. ");
INSERT INTO yml_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Fita i le'wa sai'afoga i da luku vanuge, Konilio taiadi i veluaga ma yana ve'ililibu 'agena i vetufano'uyeni i 'odu Fita 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Siwe i sivetovoia i voneni i vo, 'U tovoi, yau tomotoga 'omu bani'odi, kebu 'u na 'odu 'waikuye.” ");
INSERT INTO yml_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Fita Konilio taiadi i veifufu'eda'eda i luku vanuge tomotoga fuedi i 'isedi 'akonadi i va'auta i miamiani. ");
INSERT INTO yml_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Fita i vonedi i vo, 'Akonadi 'wa 'asetai 'ima me Diu yama ve'etoboda, kebu 'a na veiana wata 'a na vava'auta 'omi mali tomotoga taiadi, siwe 'akonadi Yaubada i veku bega kebu i da lubwaineku mali tomotoga a na awavesakoyedi wata a na awa'idi'idiedi. ");
INSERT INTO yml_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tutuyanina iada bonana i wai a nogai, kebu a da venuanaluga a tovoi a mai. Begaidi a na velutoliemu, awale nuanuamu yau?” ");
INSERT INTO yml_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilio Fita i voneni i vo, 'Aiata 'aitonu i 'a'ava, lavilavi 3 kiloki 'waineye a vevelu'ui yaku vanuge nika tamu tomogo 'ana talauma 'aninamanamalina i souyeni i tovoi matakuye. ");
INSERT INTO yml_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","I voneku i vo, Konilio, Yaubada yamu velu'ui i nogai wata yamu nuakalikali i 'isedi i sosoana i nuanuanidi. ");
INSERT INTO yml_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","'Asiau 'ifwaidi tomotoga 'u na vetunedi i na nagoi Iofa, bei tamu tomogo i na veluagai 'ana wagava Saimoni Fita i na voneni i na mai. Tomogonina i miamiana balebaleye, Saimoni 'aisaya bunudi 'adi to'idewadewa 'ana wakawaka.’ ");
INSERT INTO yml_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Bega a vetune-matayo'odi faifaimu, 'u maiga 'atumaina 'waikuye. 'Ida de'e matatabuda Yaubada mataneye, nuanuama ava'ai 'Auvea i vonemuga, faifaina 'u na lu'ivona 'waimeye.” ");
INSERT INTO yml_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Fita Konilio ma enavo i vonedi i vo, Tutuya de'e a 'asetai Yaubada kebu i da lau'idi, nuanuana me Diu wata mali tomotoga kumanidiavo kebu Diu. ");
INSERT INTO yml_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tomia fwayafwaya 'aila'a tulina tulina, siwe egavo ma yadi ve'ililibu i 'odu'odu 'waineye wata i vevesauluva tonovina, kumanidavo Yaubada i lulu'uma'umaiedi. ");
INSERT INTO yml_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","37","A 'asetai 'akonadi 'wa nogai Vala 'Atumaina me Isileli faifaima. Iesu Keliso, Yaubada 'ana Venua'ivina wata tomotoga fueda 'ada Toveimea i mai bega Yaubada taiadi ta na veiana. Valananina i velamu tutuyanina Ioni Tobafitaiso i lau'age wata i bafitaiso Galili 'waineye, mulieta nani bwaikidi i souyedi 'awalawa Iudia nageneye. ");
INSERT INTO yml_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wata 'wa 'asetai Yaubada yana toketokena Iesu tomogo Nasaledi i veleni wata 'Anu'anunu Magemagetana i agei. Fai Yaubada i 'wea'weabuya, begaidi Iesu i nago 'atamana fuedi 'waidie, i vevesauluva 'atumaina tomotoga 'waidie wata egavo Seitani ma yana 'aila'a i agediga i vona yaiaina 'waidie i 'awa'a'idi. ");
INSERT INTO yml_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","'Ima tomata'aulelevo nani matatabuna Iesu i 'idewadiga 'a 'isedi, Ielusalema 'waineye wata 'ifwaidi me Diu yama 'awalawa 'waidie, mulieta me Diu 'ai lagalagana 'waineye i tutufwaseni i wafa. ");
INSERT INTO yml_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Siwe 'aiata 'ana vetonu 'waineye Yaubada i sivetovoia wafayega wata i sivemageseni. ");
INSERT INTO yml_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tomotoga matatabudi kebu i da 'iseniga, we'e 'ima 'akonadi Yaubada i venua'ivinemaga bega 'a na vetolu'ivona faifaina 'a 'iseni. Tutuyanina i tovoi-vaitugana taiadi 'a 'ani wata 'a yemu. ");
INSERT INTO yml_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wata Iesu i toke i velu'ase'asema bega Valana 'Atumaina 'a na lu'ageyeni tomotoga 'waidie. Wata 'a na lu'ivona Yaubada 'akonadi Iesu i silakai bega tomotoga matatabuda ma yawaida wata towafa 'ada Toveimea, bola ta na vonayavuga 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yaubada yana tolu'ivonavo matatabudi i vona-samula Iesu faifaina i vo, Egavo i na vetumagana 'waineye, Yaubada yadi sakona i na nuatavunidi Iesu yana toketokena 'wainega.’” ");
INSERT INTO yml_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Fita bola i veveifufu, 'Anu'anunu Magemagetana i obuma, tovainenega matatabudi i agedi. ");
INSERT INTO yml_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Tomotoganidi 'Anu'anunu Magemagetana yana 'alavelevelena 'wainega i vonavona, bonanidi basenadi kebu i da 'asetadiga 'waidiega Yaubada i subisubiai. Me Diu tovetumaganavo Fita taiadi i maiaga Iofa 'wainega i nogai nuadi i voganidi, fai i 'asetai Yaubada 'Anu'anunu Magemagetana mali tomotoga kumanidiavo kebu Diu i veledi. ");
INSERT INTO yml_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Fita i vo, De'e tomotoganidi 'Anu'anunu Magemagetana i agedi 'ida basenadi bani'odi. Kebu tamu aitoi 'ana fata i na talabodedi bafitaiso ufayega faifaina.” ");
INSERT INTO yml_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Fita i veimeyedi i na bafitaiso Iesu Keliso 'ana wagavayega. I 'a'avana tovetumaganavo fuedi Fita i talabodeni taiadi sai'afo i na yogomia. ");
INSERT INTO yml_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tomata'aulelevo wata Iesu 'ana tovetumaganavo 'awalawa Iudia matatabuna 'waineye vala i nogai i vo, Mali tomotoga kumanidiavo kebu Diu, Yaubada yana Vona i vetumaganeni.” ");
INSERT INTO yml_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Ielusalema 'waineye 'ifwaidi Diu, taunidi Iesu 'ana tovetumaganavo yadi nuanua i vo, Egavo kebu Diu i na vetumagana Iesu 'waineye, Diu yada sauluva i na ve'ililibuyedi, nagami bunudi i na bobodi mulieta i na luku Iesu yana 'Aila'a 'waideye.” Bega tutuyanina Fita i laka Ielusalema, tomotoganidi i awavesakoyeni i vo, 'Omu 'u nago mali tomotoga kebu bunudi 'adi 'aiboboga 'waidie. Awale 'u miamia yadi vanuge wata taiadi 'wa 'ani'ani?” ");
INSERT INTO yml_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","Siwe Fita nani matatabuna 'waidie i veifufuyedi i vo, Nagami 'atamana Iofa 'waineye a vevelu'ui Yaubada 'waineye, 'aku ve 'wainega tamu nani a 'iseni i obuobuma abamayega. Naninina a 'iseniga bani'odi velu'uva bwaikina mataifwadi 4 'waidie i 'abi i siobuyeni 'waikuye. ");
INSERT INTO yml_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","A 'isadewai nageneye a 'isedi 'aisaya tauvanuga, walawala'ai, nani daledaledi wata manuga, matatabudi me Diu yada tabu. ");
INSERT INTO yml_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Bona a nogai i vo, Fita, 'u tovoi 'u nikedi 'u 'anidi.’ ");
INSERT INTO yml_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Siwe a vo, Kebu 'Auvea, yau kebu a da 'ani-'avo'avovoga wata 'aisayanidi 'ima me Diu yama tabu kebu 'a da 'ani'anidiga.’ ");
INSERT INTO yml_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Wata i vona-vaitugana 'waikuye abamayega i vo, Ava'ai Yaubada i awave'atumaiediga, kebu 'u na awavesakoyedi.’ ");
INSERT INTO yml_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tutuya 'aitonu naninina i souyeni 'waikuye, mulieta velu'uvanina i silakai i laka abame. ");
INSERT INTO yml_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tutuyanina i laka, nika tomotoga 'adi 'aitonu i le'wai 'waikuye Sisalia 'wainega, i maia ava'aibe bei vanuganina a miamiaga 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yaubada 'Anu'anununa i voneku avinodi tomotoganidi kebu Diu, taiadi 'a na nagomo. Wata de'e tomotoganidi 'adi 6, taunidi Iesu 'ana tovetumaganavo Iofa 'wainega, taiadi 'a nagoi Sisalia. 'A le'wai 'a luku tamu tomogo 'ana wagava Konilio yana vanuge. ");
INSERT INTO yml_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","I vonema bagase tamu anelose i souyeni i tovoi yana vanuge i voneni i vo, 'Ifwaidi tomotoga 'u na vetunedi i na nagoi Iofa, bei tamu tomogo i na veluagai 'ana wagava Saimoni Fita, i na voneni i na mai. ");
INSERT INTO yml_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ava'ai i na vonemu 'u na 'idewai bega Yaubada i na 'ita'ita'iemi sakona 'wainega, 'omu wata yamu vanuga 'ana tomia.’ ");
INSERT INTO yml_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tutuyanina a velamu a veveifufu Konilio ma enavo 'waidie, 'Anu'anunu Magemagetana i obuma i agedi, 'ida nagami i agedaga bani'odi. ");
INSERT INTO yml_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nika a nuani 'ada Toveimea Iesu yana vona basenadi i vo, Ioni Tobafitaiso ufayega tomotoga i bafitaisodi we'e 'omi 'Anu'anunu Magemagetana i na agemi 'wa da vo Yaubada i da bafitaisomi.’ ");
INSERT INTO yml_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","'Akonadi ta 'asetai Yaubada 'Anu'anununa Magemagetana mali tomotoga kumanidiavo kebu Diu i veledi, 'ida bani'odi nagami i veleda tutuyanina ta vetumagana Toveimea Iesu Keliso 'waineye. Begaidi kebu i da lubwaineku Yaubada a na talabodeni.” ");
INSERT INTO yml_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tutuyanina toawavesakonidi Fita yana veifufu i nogai, kebu tamu ava'ai i da voneyeni siwe Yaubada i subisubiaimo i vo, Mogitana, mali tomotoga kumanidiavo kebu Diu wata Yaubada i tauyedi, 'adi fata i na nuaviladi bega mia 'atumaina wata miamia-vagaina i na veluagai.” ");
INSERT INTO yml_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tutuyanina me Diu Sitiveni i nikei i wafa, tovetumaganavo veviga bwaikaotogina i veveluagai Iesu 'ana tovedumwe'ai'ai 'waidiega. Bega i yavula i nagoi 'awalawa 'ifwaidi 'waidie. Finisia, Imula Saifilosi wata 'atamana Anitioki, bei Iesu Valana i lulu'ivona ediavo me Diu 'aise'avadi 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","We'e 'ifwaidi tovetumaganavo Saifilosi wata 'atamana Sailini 'waidiega i nagoi Anitioki wata bei Vala 'Atumaina Toveimea Iesu faifaina, i lulu'ivona mali tomotoga kumanidiavo kebu Diu 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","'Auvea yana toketokena i veledi bega 'aila'a bwaikaotogina i nuaviladi wata i vetumagana 'Auvea 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Valadi i nago tovetumaganavo Ielusalema 'waineye i nogai bega Banabasa i vetunei Anitioki i na 'isedi. ");
INSERT INTO yml_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tutuyanina i le'wa i sosoana mogitana, fai i 'iseni Yaubada ma yana nuakalikali i vevesauluva 'atumaina tomotoga 'waidie. Matatabudi i velu'ase'asedi ma yadi vetumagana taunidi i na tautauyedi Toveimea Iesu 'waineye ma yadi tokemaiga. ");
INSERT INTO yml_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasa tomogo 'atumaina taunina tovetumagana toketokena wata 'Anu'anunu Magemagetana i agei mogitana, bega 'atamananina 'waineye tomotoga fuedi i vetumagana Toveimea Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mulieta Banabasa i tauya i nago 'atamana Tasisu Saulo i na lualeni. ");
INSERT INTO yml_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tutuyanina i veluagai i vagavaia i naweni Anitioki bei i valovei. Malamala 'aitamogana nageneye, 'adi 'ailuga tovetumaganavo fuedi taiadi i vava'auta wata i veve 'waidie. Tutuyanina 'waineye, bei mali tomotoga i velamu tovetumaganavo i golegoledi Keliso yana 'Aila'a. ");
INSERT INTO yml_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tutuyanina 'waineye, 'ifwaidi Yaubada yana tolu'ivonavo Ielusalemayega i nago Anitioki. ");
INSERT INTO yml_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","'Waidiega tamu 'ana wagava Agabu i tovoi, 'Anu'anunu Magemagetana yana 'alavelavelagi 'wainega i vona-samula bola loka bwaikina i na souyeni fwayafwaya matatabuna 'waineye. (Mulieta Loma 'ana toveimea bwaikaotogina Sisa Kaladiu yana tutuye vona-samulanina 'ana mogitana i souyeni nika loka bwaikina.) ");
INSERT INTO yml_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tovetumaganavo yana vonanina i nogai, i vevenua'ivina nuanuadi 'aitamogana 'aitamogana bani'odi 'adi fata mani i na yato ediavo Iudia 'waineye i miamianiga 'adi 'aivaita. ");
INSERT INTO yml_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Yadi nuanuananina i 'idewai i 'a'avana, Banabasa wata Saulo nimadie mani i yatoi bega i na naweni Ielusalema i na 'aniveleneni tovetumagana 'adi to'isave'avinavo 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tutuyanina 'waineye Kini Elodi i velamu 'ifwaidi Keliso yana 'Aila'a i 'ivekokovidi. ");
INSERT INTO yml_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yana tolugaviavo i vonedi Iemesa, Ioni tatana, kefatayega i luvewafai. ");
INSERT INTO yml_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Iemesa yana wafa faifaina me Diu i sosoana bega Elodi i veimea Fita i 'ive'avini i yatoi vanuga yogona nageneye. Nani de'e i souyeni Beledi Yalayalana Sakalina 'ana tutuye. ");
INSERT INTO yml_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Vanuga yogona nageneye tolugaviavo 'aila'a 4 Fita i 'isave'avini, 'aila'a 'aitamogana 'aitamogana nageneye tomotoga 'adi 4. Elodi yana nuanua Sakali Uvi'agalatagona i na 'a'ava, Fita i na vonayavuga tomotoga fuedi matadie, mulieta i na veimea i na wafa. ");
INSERT INTO yml_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Siwe tovetumaganavo 'adi 'aila'a i toke i vevelu'ui Yaubada 'waineye Fita faifaina. ");
INSERT INTO yml_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","'Awa'awai 'aiatanina 'waineye igodi Fita i da vonayavuga Elodi mataneye, lovananina 'waineye, Fita i 'eno'eno tolugavia 'adi 'ailuga 'awasasadie. Nimana bulava kainumu 'adi 'ailuga 'waidiega i yogonidi wata tolugavianidi nimadie i luifwedi, we'e 'ifwaidi tolugaviavo i tovotovoi vanuga yogona 'awana 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","I 'eno'eno nika tamu 'Auvea yana anelose i souyeni tutudaba i magetai. Anelosenina Fita 'avalaneye i 'abi i luvagoni i vo, 'U tovoi-matayo'o,” nika bulava kainumu i 'anita'idi Fita nimanega. ");
INSERT INTO yml_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nika anelose i voneni i vo, 'U na talaumamu wata 'amu 'ageyafayafa 'u na veagei.” Fita i 'idewai i 'a'avana wata i voneni i vo, Yamu velu'uva 'u 'ewai 'u na vesifafa, mulieta 'u na yogo'wailiku.” ");
INSERT INTO yml_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tutuyanina vanuga yogona 'wainega i souyeni anelose i kumeta Fita i vemuli siwe kebu i da 'asetai, naninina mogitana i sousouyeni 'alo 'ana ve. ");
INSERT INTO yml_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","I maia tolugaviavo 'ifwaidi i 'iawedi wata i vagamai tamu 'aila'a i 'iawedi, mulieta i le'wa vanuga yogona 'ana saiboda kainumu 'waineye. Saibodanina taunina i 'aniyavuya i souyedi. I nunagoi 'atamana kamwaneamo nika anelose Fita i 'iaweni. ");
INSERT INTO yml_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Bega Fita nuana i magetai i vo, 'Alo de'e mogitana. 'Auvea yana anelose i vetunei i 'ita'ita'ieku Elodi yana toketokena wata naninidi vitadi 'waidiega igodi me Diu nuanuadi i da 'idewadiga 'waikuye.” ");
INSERT INTO yml_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Fita 'akonadi i 'asetai ava'ai i souyeni 'waineye, i nago Meli yadi vanuge, kumanidi Ioni Malika inana. Bei tomotoga fuedi i va'auta, i vevelu'ui faifaina. ");
INSERT INTO yml_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Fita i le'wa i tovoi tanotanogayega i velutoli, nika tamu tofolova vevinena 'ana wagava Loda bonana i nogai bega i nago i na 'iseni aitoi. ");
INSERT INTO yml_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Vavinenina Fita bonana i nogaya'inanai, i sosoana-'afo'afo bega kebu saiboda i da sibaleni i vilai i lilide i nago enavo 'waidie. I vonedi i vo, Fita sino, 'aweye i tovotovoi.” ");
INSERT INTO yml_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","I voneni i vo, 'Omu 'u ve'wava'wava,” nika i ve'awafatafata i vo, Mogitana.” Bega tomotoganidi i voneni i vo, We'e voke Fita yana anelose.” ");
INSERT INTO yml_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Loda tomotoga taiadi i veve'ikwayekwayega Fita bola i vonavona nuanuana saiboda i na sibaleni, mulieta tutuyanina saiboda i sibaleni nika mogitana i 'iseni nuadi i voganidi. ");
INSERT INTO yml_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nimanega i talabodedi i na ve'wada bega i veifufu 'waidie, bani'odi 'Auvea i munegi i souyeni vanuga yogona 'wainega. I vo, Nani de'e matatabuna 'wa na lu'ivona Iesu taina Iemesa 'waineye wata 'ifwaidi tovetumaganavo 'waidie.” I vona'a'avana, i 'iawedi i nago tulineye. ");
INSERT INTO yml_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","I 'atai 'awa'awaie tolugaviavo Fita i 'isa'avai i veludabedabeni i vo, Fita ava'aiamo i nago?” ");
INSERT INTO yml_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kini Elodi i vonedi i na lualeni, siwe kebu i da veluagai begaidi tolugavianidi 16 i velutolitoliedi, mulieta i veimea i na luvewafadi fai Fita i 'isave'avina-sakoi. Mulieta Elodi Iudiayega i obu 'atamana Sisalia bei i na yogomia. ");
INSERT INTO yml_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tamu tutuya Kini Elodi i nuasako bwaikina tomia Taia wata Saidoni 'waidie, bega tomotoganidi i va'auta i nagoi i na 'iseni. Siwe nagami yana vanuga 'ana to'isave'avina 'ana wagava Balasitu i veianeni bega i na 'ivaisedi, Elodi nuana i na 'iveagiagia fai yana 'eba veimea 'wainega 'adi'adi i mimai. ");
INSERT INTO yml_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Balasitu i veifufu Elodi 'waineye begaidi tamu 'aiata i venua'ivineni bega kini 'adi vaigavu i vigavuyeni, i miabui 'ana didiga 'ai'aiwabuna 'waineye bega i veifufu tomotoga 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","'Aila'a yana vona i nogai, ma yadi subia i vegolegole i vo, We'e kebu tomogo bonana, tamu yada yaubada bonana.” ");
INSERT INTO yml_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Fai Elodi tomotoga yadi awa'ai'ai i awave'atumaieni wata kebu Yaubada i da ve'ililibuyeni begaidi tamu 'Auvea yana anelose i nikei ugauga i 'alavewafa-matayo'oi. ");
INSERT INTO yml_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tutuyanina 'waineye Keliso yana 'Aila'a i vevebwaika. Tomotoga fuedi basenadi Yaubada yana Vona kebu i da nogaiga, we'e 'asiau i nogai bega fuedi Iesu i vetumaganeni. ");
INSERT INTO yml_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Basenadi Banabasa wata Saulo i laka Ielusalema mani tovetumaganavo i na veledi loka faifaina. 'Akonadi i 'a'ava wata i vilaviladi Anitioki, we'e Malika tamu 'ana wagava Ioni i vagavaia ma fuedi i nagoi. ");
INSERT INTO yml_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anitioki 'waineye, tovetumaganavo 'waidiega 'ifwaidi Yaubada yana tolu'ivonavo wata 'ifwaidi yana tovevo. Tomotoganidi 'ifwaidi side 'adi wagava, Banabasa, Simioni tamu 'ana wagava Boto, Lusia tomogo Sailini, Maneni Kini Elodi taivakevakelina wata Saulo. ");
INSERT INTO yml_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tamu tutuya 'Auvea 'waineye i 'odu'odu wata 'ani 'wainega i veve'udigana, 'Anu'anunu Magemagetana i vonedi i vo, Banabasa wata Saulo 'wa na yato'idiedi fai a venua'ivinedi i na vetofolova faifaiku.” ");
INSERT INTO yml_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Begaidi tutuyanina ve'udigana wata velu'ui i 'a'avana, nimadi i yatodi 'adi 'ailuga 'unu'unudie, mulieta i vetunedi. ");
INSERT INTO yml_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","'Anu'anunu Magemagetana 'akonadi Banabasa wata Saulo i vetunedi, 'adi 'ailuga i obu 'atamana Selusia bega wakeye i dodoga i nagoi Imula Saifilosi. ");
INSERT INTO yml_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tutuyanina i le'wai i nagoi 'atamana Salami, bei Yaubada yana Vona i lu'ageyeni me Diu yadi 'eba miava'auta 'waidie. Wata Ioni Malika i 'weabudi 'adi to'aivaita. ");
INSERT INTO yml_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","'Agediamo imula kamwaneamo i yogodaba i souyedi 'atamana Fefosi, bei tamu tomogo 'afo'afo'ana i veluagai 'ana wagava Baiesu, tutuya fuedi 'eba nuavogana wata 'eba nua'ewa i 'i'idewadi. Taunina tomogo Diu, siwe i vekali tomotoga 'waidie i vo, Yau Yaubada yana tolu'ivona.” ");
INSERT INTO yml_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Baiesu iana kabemani 'ana to'edakumeta 'ana wagava Sesiasi Faulosi, yana 'aseta bwaikina. To'edakumetanina Banabasa wata Saulo i goledi nuanuana i na nagoi 'waineye Yaubada yana Vona i na veifufuyeni. ");
INSERT INTO yml_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Siwe tomogo 'afo'afo'ana, me Kuliki bonadiega tamu 'ana wagava Elimasi, nuanuana igodi Sesiasi Faulosi i na talabodeni bega kebu i na vetumagana Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Saulo tamu 'ana wagava Faulo, 'Anu'anunu Magemagetana i agei mogitana, i 'isanago tomogo 'afo'afo'ana 'waineye i vona i vo, 'Omu Seitani natuna, nani 'atumaidi matatabuna 'adi to'ivesako. 'Omu sakoimu tovekali, 'Auvea yana nuanua tonovidi 'adi tosigeugeu. ");
INSERT INTO yml_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","'Asiauotoga 'Auvea i na nikemu, matamu i na sako bega tutuya 'ifwaidi 'waidie kebu 'amu fata mageta 'u na 'ise'iseni.” Saulo yana voneye Elimasi i vebaeni matana i vewaowa wata i dudubali, bega i 'abitufa nuanuana tamu tomogo i na siveaia. ");
INSERT INTO yml_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tutuyanina kabemani 'ana to'edakumeta i 'iseni, i vetumagana Iesu 'waineye wata nuana i vogani bwaikina 'Auvea yana Vona faifaina. ");
INSERT INTO yml_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Mulieta Faulo ma enavo i dodoga Fefosi 'wainega i nagoi Fega, 'awalawa Famifilia 'waineye. Bei i miamia we'e Ioni Malika i vilai i nago Ielusalema. ");
INSERT INTO yml_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wata bega i tauya, Fega i 'iaweni i nagoi Anitioki 'awalawa Fisidia 'waineye. Me Diu yadi 'Aiata Veawai 'waineye, i luku yadi 'eba miava'auta nageneye i miabui. ");
INSERT INTO yml_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Yaubada yana veimea Mosese 'wainega wata tolu'ivona 'adi kilukiluma 'waidiega tamu tomogo i lu'iawawadi, i 'a'ava mulieta 'eba miava'auta 'ana to'edakumetavo vala i vetunei Faulo ma enavo 'waidie i vo, Emavo, 'ai'edi tamu yami nuanua 'ama 'aivaita faifaina, 'wa na veifufu 'waimeye.” ");
INSERT INTO yml_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bega Faulo i tovoi nimanega i talabodedi i na ve'wada mulieta i vo, Ekwavo, 'omi me Isileli wata 'omi mali tomotoga kebu Diu Yaubada 'waineye 'wa 'odu'oduga a na vonemi. ");
INSERT INTO yml_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","18","'Ida me Isileli yada Yaubada tubudavo i venua'ivinedi, wata tutuyanina i miamiani Itifita 'adi 'aila'a i vebwaika. Yaubada yana toketokenayega i vagavaidi Itifita 'wainega i miedi sali'avu'avuye malamala 40 nagedie i 'isave'avinidi. ");
INSERT INTO yml_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Mulieta Kenani 'waineye, Yaubada i 'ivaisedi 'awalawa bwaikidi 7 'adi tomotoga i leodi, bega yadi fwayafwaya matatabuna i 'aniveleneni me Isileli 'waidie i veimeyeni. ");
INSERT INTO yml_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","21","Naninidi i sousouyedi malamala 450 nagedie. I miamiani Kenani, Yaubada toveimea toketokedi i venua'ivinedi bega i na 'isave'avinidi. Mulieta Yaubada yana tolu'ivona Samuela yana tutuye, me Isileli nuanuadi tamu kini i na 'isave'avinidi. Begaidi Yaubada i veledi Saulo, Kisa natuna, Beniamina 'ana wauma 'wainega, i ve-kini malamala 40 nagedie. ");
INSERT INTO yml_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","I 'a'avana Yaubada i ve'idi'idieni i obu, ma'itufa Devida i silakai i ve-kini. Yaubada tomogonina faifaina i vo, Devida, Iese natuna yana nuanua bani'odi yau yaku nuanua, wata i vevematayakeyakeku nani matatabuna 'waidie.’ ");
INSERT INTO yml_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Devida 'ana wauma 'wainega Yaubada tamu tomogo i silakai 'ana wagava Iesu, i ve-To'ita'ita'i me Isileli 'waideye bani'odi basenadi i vona'awaufaufa. ");
INSERT INTO yml_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Bola Iesu kebu i da maiga, nagami Ioni i lau'age me Isileli matatabuna 'waidie i vo, Yami sakona 'wa na vedumwe'ubu'ubusedi, 'wa na nuavilami wata 'wa na bafitaiso.’ ");
INSERT INTO yml_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Mulieta sai'afoga Ioni yana folova i na 'a'ava, tomotoga i vonedi i vo, 'Wa da nuani yau aitoi? Kumanina Yaubada 'ana Venua'ivina 'wa lulukamaseniga, yau kebu kumanikuga. Siwe wata a na vonemi. Taunina i mimai mulikuye toketokeotogina, yau kebu taiadi 'ada vesala. Kebu i da lubwaineku 'waineye a na vetofolova fai taunina bwaikina.’ ");
INSERT INTO yml_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ekwavo, 'ifwaimi Ebelamo 'ana wauma 'wainega wata 'ifwaimi mali tomotoga kebu me Diu Yaubada 'ana to'odu'oduvo, valanina i mai Yaubada 'wainega 'ida faifaida, Iesu 'ana fata i na 'ita'ita'ieda. ");
INSERT INTO yml_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tomotoga i miamianiga Ielusalema 'waineye wata yadi to'edakumetavo kebu i da 'isa'inanaiga Iesu taunina To'ita'ita'i. Wata Yaubada yana tolu'ivonavo 'adi kilukiluma i vonavona Iesu faifaina kebu i da 'asetaiga, vonanidi i lulu'iawawa-vebogidi me Diu yadi 'Aiata Veawai 'waidie. Siwe tutuyanina i veimea Iesu i na wafa, tolu'ivonavo yadi vona 'ana mogitana i souyeni. ");
INSERT INTO yml_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kebu tamu yana wafa lamuna i da veluagai siwe Failato i voneni nuanuadi i na luvewafai. ");
INSERT INTO yml_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Vonanidi basenadiotoga i kilumidiga Iesu faifaina 'adi mogitana i souyedi i 'a'avana, mulieta enavo i ta'ia 'ai lagalagana 'wainega taumaseye i ve'ufai. ");
INSERT INTO yml_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Siwe Yaubada wafayega i sivetovoia. ");
INSERT INTO yml_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","'Aiata fuedi nagedie i sousouyeni enavo 'waidie, taunidi basenadi taiadi i maia Ielusalema Galili 'wainega. Enavonidi 'asiau i lulu'ivona tomotoga Isileli 'waidie Iesu faifaina. ");
INSERT INTO yml_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Wata 'ima bani'odi 'a mai Iesu Valana 'Atumaina 'a mieni 'wa na nogai. Ava'ai basenadiotoga Yaubada i vona'awaufaufa tubudavo 'waidie, 'akonadi i 'idewadi faifaida fai Iesu i sivetovoi-vaitugani wafayega. Basenadi bani'odi i kilumi Iesu yana tovoi-vaitugana faifaina Same 2 'waineye Yaubada i vo, 'Omu Natuku, fai yau Tamamu 'asiau veimea a velemu.’ ");
INSERT INTO yml_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yaubada i vona-awa'ufa'ufa Iesu i na sivetovoi-vaitugani wafayega, kebu tomogona i na baileni i na bokana taumaseye. Yaubada i vo, Basenadi a vona'awaufaufa Devida 'waineye nani 'atumaiotogidi wata magemagetadi a na 'idewadi faifaina. We'e naninidi 'waidiega a na vesauluva 'atumaina 'omi 'waimie.’ ");
INSERT INTO yml_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Wata tamu Same 'waineye Devida i vona Yaubada 'waineye i vo, Yamu Tofolova Magemagetana kebu 'u na baileni bega tomogona i na bokana taumaseye.’ ");
INSERT INTO yml_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Devida i kilumiga kebu taunina faifaina, fai tutuyanina i miamia ma yana 'aila'avo, Yaubada yana folova i 'idewa'a'avadina i wafa tubunavo lilivadie i ve'ufai siwe tomogona i bokana. ");
INSERT INTO yml_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","We'e tamu tomogo Yaubada i sivetovoia wafayega kebu i da bokanaga. ");
INSERT INTO yml_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ekwavo a na vonemi. Tomogonina taunina Iesu, 'wainega Yaubada 'ana fata yami sakona i na nuatavunidi begaidi valana 'a lulu'ageyeni. ");
INSERT INTO yml_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Aitoi i na vetumagana 'waineye yana sauluva tonovina Yaubada mataneye, we'e veimeanidi i mai Mosese 'wainega kebu 'ana fata i na 'ita'ita'ieda. ");
INSERT INTO yml_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Taunimi 'wa na 'i'isave'avinimi, bega vitanina Yaubada yana tolu'ivonavo faifaina i kilumi kebu i na souyeni 'waimie, fai bani'odi basenadi Yaubada i vo, ");
INSERT INTO yml_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Omi yaku vona 'wa kibuyaga, a na vonemi. Yaku folova 'wa na 'iseni nuami i na voganidi, nika 'wa na wafa! Fai yami tutuya 'waineye, tamu yaku folova a 'i'idewai 'waimie, siwe kebu 'ami fata 'wa na vetumagana. Avinodi tamu tomogo i na kiavemagetai 'waimie, siwe kebu 'wa na ve'awamogitana.’” ");
INSERT INTO yml_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","'Akonadi yadi tafalolo i 'a'ava, Faulo wata Banabasa i sousouyedi 'eba miava'auta 'wainega, tomotoga i velu'ui 'waidie nuanuadi 'Aiata Veawai matadie i na viladi bega wata i na veifufu nani de'e faifaidi. ");
INSERT INTO yml_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Matatabudi i yavula, 'ifwaidi Diu wata 'ifwaidi mali tomotoga i ve-Diu, Faulo wata Banabasa taiadi i veifufu'eda'eda. Tomata'aulelevo 'adi 'ailuga tomotoganidi i velu'ase'asedi i vo, Taunimi 'wa na tautauyemi Yaubada yana nuakalikali 'waineye, kebu 'wa na baileni.” ");
INSERT INTO yml_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","'Aiata Veawainina matadie i le'wa, tomotoga fuedi 'atamana bwaikina 'wainega i maia, nuanuadi 'Auvea yana Vona i na nogai. ");
INSERT INTO yml_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tutuyanina me Diu 'aila'a bwaikina i 'isedi i ve'unumagigi bega i vona-uvi'agala Faulo 'waineye wata tomotoga i vonedi i vo, We'e Faulo i vevekaliemi, kebu bonana 'wa na nogai.” ");
INSERT INTO yml_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Siwe Faulo wata Banabasa ma yadi venuafoufa'ala i vonedi i vo, I lubwainema Yaubada yana Vona nagami 'a na lu'ivona 'omi me Diu 'waimie mulieta mali tomotoga. Siwe fai 'wa vedumwe'ai'aieni, taunimi 'wa veimeyemi kebu i da lubwainemi mia 'atumaina wata miamia-vagaina 'wa na veluagai. Begaidi 'a na bailemi 'a na nagoi mali tomotoga kumanidiavo kebu Diu 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Fai 'akonadi bani'odi 'Auvea i vonema yana Buki 'wainega i vo, 'Omu mageta bani'odi a yatomu mali tomotoga kumanidiavo kebu Diu faifaidi, bega 'waimuyega tomia fwayafwaya matatabudi 'adi fata 'ita'ita'i i na veluagai.’” ");
INSERT INTO yml_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tutuyanina mali tomotoga vonanina i nogai, ma yadi sosoana 'Auvea i subisubiai yana Vona faifaina, we'e egavo 'akonadi Yaubada i venua'ivinedi bega mia 'atumaina wata miamia-vagaina i na veluagai i vetumagana Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","'Awalawanina 'waineye, tomotoga matatabudi 'Auvea yana Vona i nogai. ");
INSERT INTO yml_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Siwe me Diu i nagoi 'atamana 'ana to'edakumetavo wata vevine 'adi wagava bwaikidi 'waidie, i nua'anidi. Vevinenidi kebu Diu, siwe Yaubada 'ana tove'ililibu. Bega to'edakumetanidi 'aila'a i vonedi i daba Faulo wata Banabasa veviga i veledi wata i sogiedi yadi 'awalawa 'wainega. ");
INSERT INTO yml_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tomata'aulelevo 'adi 'ailuga i souyedi 'awalawanina 'wainega, 'agedi i lubutubutudi, yadi 'eba 'isa 'awaie vematavuloga i na veluagai Yaubada 'wainega. I 'a'ava nika i tauya i nago Ikoniami. ");
INSERT INTO yml_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","We'e Anitioki 'waineye, tomotoganidi i vetumagana Iesu 'waineye i sosoana-'afo'afo wata 'Anu'anunu Magemagetana i agedi. ");
INSERT INTO yml_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tutuyanina Faulo wata Banabasa i le'wa Ikoniami, i nagoi me Diu yadi 'eba miava'auta 'waineye, bei ma yadi toketokena i veifufu 'waidie nika me Diu wata mali tomotoga kumanidiavo kebu Diu fuedi i vetumagana Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","We'e me Diu 'ifwaidi i baila, kebu i da vetumagana bega i nagoi tomotoga 'ifwaidi i nua'anidi nika Faulo wata Banabasa i vedumwe'ai'aiedi. ");
INSERT INTO yml_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tomata'aulelenidi 'adi 'ailuga bei i miamiani 'aiata fuedi nagedie ma yadi venuafoufa'ala i veveifufu Toveimea Iesu yana nuakalikali faifaina. Yadi vonanina Toveimea Iesu i ve'awamogitaneni fai toketokena i veledi bega 'eba nuavogana wata 'eba nua'ewa i 'i'idewadi. ");
INSERT INTO yml_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Siwe 'atamananina 'ana tomotoga i 'idia, 'ifwaidi nuanuadi Faulo ma iana Banabasa, 'ifwaidi i baila. ");
INSERT INTO yml_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mulieta 'ifwaidi Diu wata mali tomotoga ma yadi to'edakumetavo nuanuadi tomata'aulelevo i na 'ive'avinidi veviga i na veledi mulieta i na lukileudi i na wafa. ");
INSERT INTO yml_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Tutuyanina yadi nuanua i 'asetai, Faulo ma iana i dega i nagoi 'awalawa Likionia. Bei 'atamana Lisitala, Debi wata 'ifwaidi 'atamana lilivadie Vala 'Atumaina Iesu faifaina i lau'age. ");
INSERT INTO yml_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lisitala 'waineye tamu tomogo i miamia, 'agena sinunumina i tubuga inana kamodiega kebu 'ana fata i na yaba. ");
INSERT INTO yml_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Tutuyanina Faulo i lalau'age, toviganina i miabui i vavainenega. Faulo i 'isanaweni yana nuanua 'waineye i vo, I lubwaineni a na 'ive'atumaia fai i vetumagana Iesu 'waineye.” Bega bonana bwaikinega i voneni i vo, 'U tovoi tonovimu,” nika tomogonina i luafwalagi i yaba. ");
INSERT INTO yml_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","12","Tutuyanina 'aila'a i 'iseni ava'ai Faulo i 'idewai toviganina 'waineye, i vegolegole bonadiega vona Likionia 'wainega igodi i vo, 'Akonadi yada yaubada 'adi 'ailuga i vetomotoga i obuma 'waideye.” Tomotoganidi yadi yaubada-vekavekali fuedi, yaubadanidi tamu 'ana wagava Siasi, we'e yadi toveifufu 'ana wagava Emisi. Tomotoga yadi nuanua i vo 'ako Banabasa i ve-Siasi we'e Faulo i ve-Emisi fai taunina toveifufu. ");
INSERT INTO yml_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Yadi vanuga 'eba velu'ui Siasi faifaina 'atamana bwaikina lilivaneye. 'Aiatanina 'waineye Siasi 'ana tovelomu bulumakau wata welavi ididi uyauyana i miedi 'atamana 'ana 'awa 'waineye, ma yana tomotogavo igodi 'aisayanidi i da velomuyedi wata i da 'odu Banabasa wata Faulo 'waidie. ");
INSERT INTO yml_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Tutuyanina Banabasa wata Faulo i 'asetai tomotoga nuanuadi i na velomu 'waidie, ma yadi nuavita 'adi talauma i silabu'idi i lilide i nagoi 'aila'a nagedie i vegolegole i vo, Emavo, awale nuanuami 'wa na velomu 'waimeye? 'Ima tomotogaotoga 'omi bani'odi, kebu yami yaubadavo. 'Ima 'a maiga Iesu Valana 'Atumaina 'a lulu'ivoneyeni 'waimie bega nani-'avo'avovo 'waidiega 'wa na nuavilami Yaubada miamia-vagaina 'waineye, kumanina abama, fwayafwaya, eyaga wata nani fuedi nagedie i 'idewadi. ");
INSERT INTO yml_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Basenadi tomia fwayafwaya matatabudi Yaubada i tauyedi taunidi yadi nuanua i 'i'idewadi. ");
INSERT INTO yml_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Siwe Yaubada nani fuedi 'atumaidi i 'idewadewadi faifaida, yada 'eba 'isa bega ta na 'asetai Yaubada miamia-vagaina wata toketokena. Yana nuakalikali i veveda fai i veve'wei abamayega, 'ani'ani i veleveleda 'aitamogana 'aitamogana 'adi tutuya 'waidie, bega kamoda i aiaidi wata ta sososoana.” ");
INSERT INTO yml_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Faulo wata Banabasa de'e vonanina 'wainega tomotoga i talabodedi kebu i na velomu 'waidie siwe i kwayega i nagoga yadi talaboda i vetoketoke. ");
INSERT INTO yml_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mulieta 'ifwaidi me Diu i maia Anitiokiega, 'awalawa Fisidia nageneye wata 'atamana Ikoniami 'wainega. Tomotoganidi 'aila'a i nua'anidi bega ma fuedie i daba Faulo i 'ive'avini i lukileuya. Yadi nuanua i vo, I wafa,” bega i luyo'ei i naweni mwalilige. ");
INSERT INTO yml_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Siwe tovetumaganavo i tovififineni nika Faulo i tovoi-matayo'o wata i vila-vaitugani i nago 'atamane. I 'atai, ma iana Banabasa i tauya i nago Debi. ");
INSERT INTO yml_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Faulo wata Banabasa Iesu Valana 'Atumaina i lu'ageyeni Debi 'waineye bega fuedi i vetumagana Iesu 'waineye, mulieta i viladi i nagoi Lisitala. Bega i nago Ikoniami, wata i tauya i nago Anitioki 'awalawa Fisidia nageneye. ");
INSERT INTO yml_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","'Atamananidi 'waidie, tomata'aulelenidi 'adi 'ailuga tovetumaganavo i velu'ase'asedi wata i kiavetoketokedi i vo, Kebu 'wa na 'ailove, 'wa na vevetumagana Iesu 'waineye, fai nagami veviga fuedi ta na veluagadi, mulieta Yaubada i na veimeyeda yana 'Aila'a nageneye.” ");
INSERT INTO yml_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Faulo wata Banabasa i nagoi tovetumagana 'adi 'aila'a 'aitamogana 'aitamogana 'waidie, 'adi to'isave'avinavo i venua'ivinedi i silakaidi. 'Ani 'wainega i veve'udigana wata i vevelu'ui bega tomotoganidi i vetumagana 'Auvea 'waineye i na 'isave'avinidi. ");
INSERT INTO yml_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","I 'a'ava i tauya i nago 'awalawa Fisidia 'waineamo nika i le'wai 'awalawa Famifilia. ");
INSERT INTO yml_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Fega 'waineye Iesu Valana i lu'ageyeni, mulieta i obu 'atamana Atelia. ");
INSERT INTO yml_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Bei i dodoga i viladi i nagoi Anitioki 'awalawa Silia nageneye. 'Atamananina 'waineye basenadi ediavo i velu'ui Faulo wata Banabasa faifaidi bega Yaubada i na 'ivaisedi wata i na nuakalikaliedi folovanina 'akonadi i ve'a'avaiga faifaina. ");
INSERT INTO yml_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tutuyanina Faulo wata Banabasa i le'wai Anitioki, tovetumaganavo i goleva'augidi i lu'ivona 'waidie. I veifufu 'waidie bani'odi Yaubada i 'ivaisedi, taiadi i folova wata mali tomotoga, kumanidiavo kebu Diu, wata Yaubada i tauyedi Iesu 'waineye i vetumagana. ");
INSERT INTO yml_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Anitioki 'waineye, i mia tutuya manamanawena tovetumaganavo taiadi. ");
INSERT INTO yml_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tamu tutuya tomotoga 'ifwaidi Iudia 'wainega i maia Anitioki. Bei tomotoganidi tovetumaganavo i ve 'waidie i vo, 'Ai'edi bunumi kebu 'wa na bobodiga bani'odi yada veimea Mosese 'wainega, Yaubada kebu i na 'ita'ita'iemi yami sakona 'waidiega.” ");
INSERT INTO yml_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Faulo wata Banabasa tovenidi taiadi i ve'ikwayekwayega, i 'alamagi'aia begaidi tovetumaganavo 'adi 'aila'a Faulo, Banabasa wata tovetumaganavo 'ifwaidi Anitioki 'wainega i venua'ivinedi i na nagoi Ielusalema, i na veifufu tomata'aulelevo wata to'isave'avinavo taiadi bunu 'aibobo faifaina. ");
INSERT INTO yml_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bega tovetumaganavo Anitioki 'wainega ediavo i vetauyidi, i nagoi 'awalawa Finisia wata Samelia 'waidiamo. Bei tovetumaganavo 'waidie i lu'ivona mali tomotoga kumanidiavo kebu Diu yadi nuavilana Yaubada 'waineye faifaina, begaidi matatabudi i sosoana mogitana. ");
INSERT INTO yml_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tutuyanina i le'wai Ielusalema, tomata'aulelevo, to'isave'avinavo wata tovetumaganavo matatabudi, Faulo ma enavo i yogo'ede'ededi ma yadi sosoana. Mulieta i veifufu 'waidie bani'odi Yaubada i 'ivaisedi taiadi i folova. ");
INSERT INTO yml_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","We'e tovetumaganavo 'ifwaidi, taunidi Falisi yadi 'aila'a 'wainega, i tovoi i vonedi i vo, Egavo nuanuadi i na luku Keliso yana 'Aila'a 'waideye, nagami bunu 'aibobo i na 'ewai wata ta na vonedi veimeanidi i mai Mosese 'wainega i na vevematayakeyakedi.” ");
INSERT INTO yml_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Begaidi tomata'aulelevo wata to'isave'avinavo taiadi i miava'auta bunu 'aibobo 'ana nuanua i na sivetovetonovi. ");
INSERT INTO yml_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tutuya manamanawena naninina faifaina i veveifufu, mulieta Fita i tovoi i vo, Ekwavo, 'akonadi 'wa 'asetai, basenadi yau Yaubada i venua'ivineku 'waimiega bega Iesu Valana 'Atumaina a na lau'age mali tomotoga kumanidiavo kebu Diu 'waidie bega 'adi fata i na vetumagana Iesu 'waineye. ");
INSERT INTO yml_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yaubada tomotoga matatabuda yada nuanua i 'asetadi bega i veda nuanuana mali tomotoga kumanidiavo kebu Diu, Iesu 'waineye i na vetumagana. I vedaga fai 'Anu'anunu Magemagetana i veledi, basenadi 'ida bani'odi. ");
INSERT INTO yml_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","'Ida me Diu wata kumanidiavo kebu Diu, Yaubada kebu i da lu'idida, fai tomotoganidi i vetumagana Iesu 'waineye, yadi sakona i nuatavunidi wata i 'ivevunavunagidi. ");
INSERT INTO yml_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Awale nuanuami igodi Yaubada 'wa na silubuya bega i na nuasako? 'Akonadi i veda mali tomotoga i tauyedi i na vetumagana. Tovetumaganavo kebu ta na lukakadedi 'ida me Diu yada ve'etoboda vitadi i na ve'ililibuyedi. 'Ai'edi ta na lulukakadediga, bani'odi venuana vitana ta vevevadi, ve'etobodanidi tubudavo wata 'ida kebu 'ada fata ta na evaevadi. ");
INSERT INTO yml_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kebu bani'odi ta na munega. Ta vetumagana Toveimea Iesu yana nuakalikaliega i 'ita'ita'ieda sakona 'wainega, wata bani'odi kumanidiavo kebu Diu i 'ita'ita'iedi.” ");
INSERT INTO yml_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Fita i vona'a'ava, matatabudi kulukulu i lovogi. Mulieta Banabasa wata Faulo i tovoi i lu'ivona 'waidie Yaubada 'eba nuavogana wata 'eba nua'ewa i 'idewadi mali tomotoga kumanidiavo kebu Diu matadie. ");
INSERT INTO yml_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tutuyanina i vona'a'ava, nika Iemesa i vo, Ekwavo a na vonemi. ");
INSERT INTO yml_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimoni Fita ava'ai 'akonadi i voneyeniga, i vona mogitana. I veifufuga Yaubada mali tomotoga kumanidiavo kebu Diu i nuakalikaliedi wata be'ama 'waidiega 'ifwaidi i venua'ivinedi wata 'Anu'anunu Magemagetana i agedi, bega yana tomotoga mogitana. ");
INSERT INTO yml_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Fita yana vona i vesala tolu'ivona yadi vona bani'odi, fai basenadiotoga i vona-samula mali tomotoga kumanidiavo kebu Diu Yaubada i na ve'ililibuyeni. ");
INSERT INTO yml_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Yaubada yana vona i kilumi i vo, Kini Devida 'ana wauma 'wa da vo yana vanuga basenadi i 'anigeuya, siwe yau Yaubada a na vilaku vanuganina a na vetovoi-vaitugani. ");
INSERT INTO yml_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","A na 'ive'ivauya bega tomotoga matatabudi yau yadi 'Auvea i na lualeku. Mali tomotoga kumanidiavo kebu Diu a venua'ivinediga a goledi i na maia bega yaku tomotoga mogitana. Vonanina yau 'Auvea yaku vona, basenadiotoga a voneyeni.’” ");
INSERT INTO yml_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Wata Iemesa i vonedi i vo, De'e yau yaku nuanua. Mali tomotoga kumanidiavo kebu Diu i nunuaviladiga Yaubada 'waineye, kebu nuanuaku vita fuedi ta na veleveledi. ");
INSERT INTO yml_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","21","Siwe tomotoga fuedi yada ve'etoboda wata veimea Mosese 'wainega i 'asetadi fai ta lulu'iawawa-vebogidi vanuga 'eba miava'auta 'waidie yada 'Aiata Veawai 'aitamogana 'aitamogana 'waidie wata 'atamana fuedi 'waidie ta lulu'ageyedi. Begaidi lubulubu'ava ta na kilumi ta na vonedi bega 'aisayanidi mali tomotoga i velomuyediga yaubada-vekavekali 'waidie kebu i na 'ani'anidi, wata kebu i na ve'avula-'avo'avovo. Lologa kebu i na 'ani wata 'aisaya 'i'i'idi kebu i na 'anidi fai dayaga i 'eno'eno nagedie.” ");
INSERT INTO yml_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yadi veifufu i 'a'ava, tomata'aulelevo, to'isave'avinavo wata tovetumagana matatabudi taiadi yadi nuanua 'aitamogana 'wainega, tomotoga 'ifwaidi i venua'ivinedi bega i na vetunedi i na nagoi Anitioki Faulo wata Banabasa taiadi. Tomotoganidi i venua'ivinediga ma 'adi ve'ililibu, 'adi wagava Sailasa wata Iudasa tamu 'ana wagava Balisaba. ");
INSERT INTO yml_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Valanina i kilumiga tomotoganidi i na naweniga 'ana nogaya side bani'odi i vo, Ie emavo, 'Ima emiavo tomata'aulelevo wata to'isave'avinavo 'a miamiani Ielusalema. 'Omi tovetumaganavo kebu Diu 'wa miamiani Anitioki, 'awalawa Silia wata Silisia 'waidie, 'a vekaiwa 'waim